﻿USE sofia;
DROP TABLE IF EXISTS sofia.aby_vpl;
CREATE TABLE aby_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aby_vpl WRITE;
INSERT INTO aby_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yewae Yesu Kerisonu sisia sirorari wakeye eno, Eibaramuini Deiwidini emuae Yesunu sisia sirorari miyai. ");
INSERT INTO aby_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibaramu dawae Aisikinu babae. Aisiki dawae Deikafunu babae. Deikafu dawae Diudaini danu daburakaini emenu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Diuda dawae Feresini Siraini emenu babae. Emenu amaenu ibiye Deima. Feresi dawae Esaronunu babae. Esaronu dawae Remunu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Remu dawae Aminadabunu babae. Aminadabu dawae Neisoninu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Neisoni dawae Samoninu babae. Samoni dawae Boasinu babae. (Boasinu amaenu ibiye Reiabu.) Boasi dawae Obedinu babae. (Obedinu amaenu ibiye Ruda.) Obedi dawae Desinu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Desi dawae Deiwidinu babae. Deiwidi dawae emua yawokeibirie dai kini mi. Deiwidi dawae Soromoninu babae. Deiwidi dawama Uraianu aweka waira muni. Eno uibake i awekama Soromoni dori. ");
INSERT INTO aby_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoni dawae Reoboamunu babae. Reoboamu dawae Abaidanu babae. Abaida dawae Asanu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa dawae Diosofedinu babae. Diosofedi dawae Doremanu babae. Dorema dawae Usaianu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia dawae Dodemunu babae. Dodemu dawae Eiasinu babae. Eiasi dawae Esikaianu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikaia dawae Manasanu babae. Manasa dawae Eimoninu babae. Eimoni dawae Dosaianu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Dosaia dawae Dekonaiaini danu daburakaini emenu babae. I furo Babaronia orofa orouma i Du orou mukake Babaronia orofaro waure ane ode ibaada emenu waiya ukeka orou ubu urieka. ");
INSERT INTO aby_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","I orouma i Du orou Babaronia orofaro waure ane odiriekaro Dekonaiama Sirudio dori. Sirudio dawae Serubabeonu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeo dawae Abaudinu babae. Abaudi dawae Iriekiminu babae. Iriekimi dawae Asonu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso dawae Sadokonu babae. Sadoko dawae Eikiminu babae. Eikimi dawae Iriudinu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iriudi dawae Iriesanu babae. Iriesa dawae Meidaninu babae. Meidani dawae Deikafunu babae. ");
INSERT INTO aby_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Deikafu dawae Diosefunu babae. Diosefu dawae Merinu eme. Merima Yesu dori. Yesu doriro i furo ibisa orouma Danu moi ibiye Keriso weisa. ");
INSERT INTO aby_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Enoba adinami nauwaro Eibaramubairoma akaemuku dore aariekake aarebe aarebe Deiwidibairo kakure aaka ie fodini (14) aare me sini. Nono Deiwidibairoma akaemuku dore aariekake aarebe aarebe Babaronia orofaro odirieka furoma kakure aaka ie moi fodini (14) aare me sini. Nono i Babaronia orofaro odirieka odoroma akaemuku dore aariekake Godi Danu ma wiroke mune aneka Mi Keriso doka furoma kakure aaka ie moi fodini (14) aarike me sini. ");
INSERT INTO aby_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","I Yesu Keriso dori wakeye i ari eno, Yesunu amae Meri eme mune mero me ibeebe boana muni. Diosefu mafisane we bou uke oisaro Diosefu mune mero me ibeebe boana muni. Godinu Imumu Irauma Merinu imuka ubarenaro isari ibake boana munike ibi. ");
INSERT INTO aby_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Diosefuma Meri medifine eno imuikema nono dawa irau mi ibake dawa arara me eme moima Meri we irufisane ibake Meri fema medifine imui. ");
INSERT INTO aby_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Eno imukeibiro i Godinu aneruma kuberoma isarike eno wei, Deiwidinu amara Diosefu, Meribake ia da iyake dawa anu awekaya mua wei. I boanaro ibinu amara dawae Godinu Imumu Irauma makinua Meri anu awekaya mua wei. ");
INSERT INTO aby_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Merima amara mufiro danu ibiye Yesu maifakuba danu orounu merama ukeka sinekaroma ma wirofekua i aneruma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Godinu adinaro we bou ui mima weiba enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Godinu we bou ukeka mima eno wei, nauawe, moi eme mune me aruma boana mufekuke amara dofekuie I amaranu ibi dawa Imanuero wefoisa. I ibinu ubiye Godi Dawa iyabairo ibinua, weada wei ibake Godinu we bou ukeka mima eno wei. ");
INSERT INTO aby_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Diosefu nauka aine ibeebe ido uyarike Godinu aneru wei wake enaenari uike Meri danu aweka muni. ");
INSERT INTO aby_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Diosefuma Meri muniro demuiro aine mero me ibaada Merima amara doriro Diosefuma Danu ibi Yesu mami. ");
INSERT INTO aby_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Merima Yesu Diudia orofa Bediriemu goiro dori. I furo i orofa yawokeibi mi Erodima i orofa eme yaisina yawokeibirie. I Yesu dori furo moi orou muina kakureibisa iwoka daiwere orouma i eweka amukaku iro yafawereroma Derusaremu goiro fakake eno weisa, i Du orounu awoena yawokeka mi aboro ibinu weisa? Eweka amukaku iroma Danu muina fariro ekiba ibake Dawa guriguri ufene farisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erodima emenu wake nauike i awoena yawokeka mibake merama imuka imui. Eno uiro nono i Derusaremu goi orou yaisina enaenari uisa. ");
INSERT INTO aby_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erodima weiro i dai ofereni ode sibore sianeka orouini nono i Mosesinu darawadu ma iwoka ukeibisa orouini dawabairo faka. Fakaro wei, Emema i Keriso aboro dofisane weisa wei? I Amaranaku, Du orounu kini, aboro dorinu wei? ");
INSERT INTO aby_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Eno weiro emuama eno weisa, i Diudia orofa Bediriemu goiro dorinua weisa. Weisake nono weisa, Godinu we bou ukeka mima eno owaowa yanake odi, a Diudia orofa Bediriemu goi, ae sara goi me, i Diudia yawokeka oroubairoma ae daiwere, danu ubi bobo goi, ibake abairoma moi dai yawokeka mi uyafekuke i Godinu Isaraera orou yawofiakua, eno owaowa uke odia weisa. ");
INSERT INTO aby_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erodima i muina kakureibisa iwoka daiwere orou fema weiro dawabairo faka. Fakaro dawama eno wei, i muina abo odoro fariro eka wei? ");
INSERT INTO aby_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Weike nono wei, Bediriemu goiro aniaweke i Amaranaku yodia ukenewaa uawe wei. I Amaranaku fou ufoisaie aafoke nabairo aare weawero naumake Dawabairo animake guriguri uke odima wei. ");
INSERT INTO aby_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I muina kakureka iwoka daiwere orouma Erodinu wake nauisake meisake anisa. Anaada ekabaie eweka amukeka enaro muina aaradae ureroma i uwara fouro enare ibiro eka. ");
INSERT INTO aby_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","I muina ekake emenu imuka rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","I muina kakureka iwoka daiwere orouma i uwara ubarenaro amuisake ekabaie i Amaranakuini Danu amaeini emua eraada ifoma kodudu yanaisake guriguri uisa. Eno uisake emenu irau me makeka eraerabusa ma dorobu yaraadae Dawabake gorudini urumuma imusu ari fauda ibi furanikisenisa urumuma imusu ari adua ibi miraini maisa. ");
INSERT INTO aby_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Godima i muina kakureka iwoka daiwere oroubairo kuberoma farike wei, yanu owereka odoro Erodinu daabaro da anifoke yanu moi daabaro anifoke yanu orofaro ane faforo weiro Danu wei enaenari moi daabaro anisa. ");
INSERT INTO aby_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","I muina kakureka iwoka daiwere orou ane me sikaro Godinu aneruma Diosefubairo kuberoma farike eno wei, uyaake i Amaranakuini Danu amae muake Idifi orofaro sabu ania wei. Erodima i Amaranaku yodia ufike nodo kuufine ukakua iro ane ibiaro nono wemaro owere aara wei. ");
INSERT INTO aby_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","I dumuro Diosefu uyarike i Amaranakuini Danu amaeini emua we murieke i orofaroma Idifi orofaro waure anirie. ");
INSERT INTO aby_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Idifi orofaro ane ibifiro Erodi feafiro nono owere aafisane ibake anisa. Godinu we bou ukeka mima wei ibake enaenari ui. Godima Danu we bou ukeka amaranu bebekuroma eno wei, Nanu Amara Idifi orofaro nono owere aafie wei ibake enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","I muina kakureka iwoka daiwere orouma Erodibairo fare dauisaro Erodima i orou na we irunekaya eno we imukada dino daiwere ui. Dino daiwere uike dawa i oroubairo iwoka siniba ibake moi orou we odaisada eno wei, aniaweke Bediriemu goini nono i goi udiudi goiro yaisina oya raarayai me sine mero me ibinisa amarananakunu nodo yaisina kuure aniawe wei. ");
INSERT INTO aby_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Erodima eno uiro Godinu wake we bou ukeka mi Derimaiyanu adina wake i odoro i wake wei wake wei enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Derimaiyama eno wei, moi wake goro Reima goiro weada sorara ukeibisa. Reisorobairoma sisia sirorari uisa awekabo emenu amarananakubake sorara ukeibisaie i amarananaku yaisina ibe me ibake sorara ukaada ibeibisa, Derimaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Erodi feariro Godinu aneru Idifiro Diosefubairo kuberoma farike eno wei, uyake i Amaranakuini Danu amaeini emua we muake Isaraera orofaro ania weike nono wei, i Amaranaku ufisane ukeibisa orou emua feare me sinisaya aiya ania wei. ");
INSERT INTO aby_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ania weiro Diosefuma uyarike i Amaranakuini Danu amaeini emua we murieke Isaraera orofaro waure anirie. ");
INSERT INTO aby_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Ane farike Diosefu moi wake nauibaie Akiriasima danu babae Erodinu ooru munike Diudia orofa yawokakua weisaro Diosefu i wake nauike ia iyarike i orofa medike ani. Aniro nono i Godinu aneruma adinaro kuberoma farike wei ibake Gareri orofaro ani. Anike Nasaredi goiro ibi. Ibake Godinu wake we bou ukeibisa orounu wake enaenari ui. Emenu wakeye eno, I Amaranaku Dawae Nasaredi goi miya wefeisaya emuama eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","I furo Dioni babadaido ukeka mima Diudia eme ibe me orofaro fariro eme keuwere dawabairo fakaro dawama eno wei, Godinu yawokaku odo fafine ukakua yanu merama merama ukaisa ibai maru uaweke imuke mediawe wei. ");
INSERT INTO aby_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Godinu we bou ui mi, Isaiyama Dionibake eno wei, dawae eme ibe me yao nauwaro enaada weaku, i Dai Minu daaba wabuke ma gienabu uawe weakua, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dioni danu burukekae irau me meramawere kemo abunu ofema barukeibi. Nono danu gabaganae boromakaunu ofema wayareibi. Danu urunae sigigini ewereini eno iseibi. ");
INSERT INTO aby_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","I Derusaremu goi orouini Diudia orofa orouini i Diodeni orofa orouini emua yaisina Dionibairo fakake emenu merama merama ukeka sineka we ma boroo yareibisaro Dionima i orou Diodeni aduaro babadaido ukeibirie. ");
INSERT INTO aby_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dionima eribaie i Ferosi orouini Sadusi orouini emua Dionibairo babadaido ufisane fakaro erieke emuabake eno wei, ya waruma dorie! Ainama Godinu fafekuke yabairo yanu merama ukekabake dino ufekubai wenuro naukisake ibake Godi ma berefoke ia iyare anifone nabairo durame faraisa wei? ");
INSERT INTO aby_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aniaweke merama ukaisa ibai maru uaweke imuke mediaweke irau ukeka mane ibooro odiawe wei. Eno ufoisaie Godima ya efiakuke iduaya wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eno weike nono wei, me sara uyafoisake Eibaramu dawa iyanu babaeya wefoisake iyae danu sisia sirorari oroua ibake iyae Godinu oroua wefoisaie enaenari meya wei. Eno weike nono wei, Godima Eibaramunu ba sisia sirorari oroue yewa omama ubu ufiane wefekuie ubu ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Godinu kodo fanisi odo fafine ukaku. Moi mima uya ei mamakuke ana umafine ukaku enaenari Godinu kodo odoe i ari eno, yanu merama ukeka sinekabake fanisi mafiane ukaku. Moi ana irau kaibai da uwafekuie umane kuufekuke mune inaaro siafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Dionima nono wei, ya yanu merama merama ukaisa ibai maru ukaisake imuke medaisaie ya aduama babadaido ukakunia wei. Nama i mi Danu waiya ukakuneroma nono i nanu umuro aafeku Mi Danu bunae daiwere na ari eno me wei. Eno weike wei, nae irauaiai mebake danu ibooro da deri umaua wei. Enoba i Mima ya Godinu Imumuini inaama babadaido ukenewaa ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Danu uidi kai saboro wanaro mame ibinuke Danu uidi kainu sisina kabe ma irauaiai ufine saboroma uidi kai kore eku urero sianaku. Urero eku sianakuro oyauma kemibai imusu orofaro ure fufuke sianakuro uidi kai mane sisina kabero isaraku. Isarakuro Dawa Danu uidi kai mune ku uke danu uwararo ane odakuke nono i kemibai munakuke i feare dakaku inaaro sianakua eno wei. I enaenari Yesunu fafeku odo i irau orou mune imusu odifekuke nono i merama orou mune ane feare dakaku inaaro siafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dionima Yesu babadaido ufine ibake Yesu Gareriroma Diodeni aduaro aare fari. ");
INSERT INTO aby_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Fariro nono Dioni dawa arara me Yesu babadaido ukeka ibake Yesubake eno wei, nae Abairo babadaido ukenewaa umaude anemebake nama babadaido umane nabairo faraku wei? ");
INSERT INTO aby_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eno weiro Yesuma wei, iduaya, Na babadaido ufakuie Godinu irau imukeka enaenari ufukua wei. Eno weiba ibake Dionima Diodeni aduaro Yesu babadaido ui. ");
INSERT INTO aby_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Dionima Yesu babadaido uke me siniro Yesu aduaroma kebiro amukada eribaie ure eba uiro Godinu Imumu Irauma ubari ada ari isare aarike Yesu Danu ofero yauriro eri. ");
INSERT INTO aby_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eno uiro ureroma wake isare aarike eno wei, yewae Nanu Amara ubibake Nanu imuka yaisina Dawabairo ibinuro Na rooro ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Godinu Imumu Irauma Yesu munike eme ibe me orofaro waure ane odi. Odiro iro ibeibiro seidanima Yesu uke iruke efine Dawabairo fari. ");
INSERT INTO aby_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu iro eweka fodini (40) dumu fodi (40) uruna ise dauike aineibi. Uruna ise dauike aineibiro eweka fodi (40) me siniro Yesu desini daiwere uri. ");
INSERT INTO aby_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seidanima Yesubairo farike eno wei, A Godinu Amarabaie wearo yewa omama buredi sifiro ia wei. ");
INSERT INTO aby_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eno weiro Yesuma ma owerike wei, Godinu bukaroma eno weakua wei, emema uruna mane ifeisaie emenu ibeka irau meya wei. Nono Godinu bebekuroma weaku wake yaisina naufeisaie emenu ibeka irauaiaiya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Eno weiro seidanima Yesu munike waure Derusaremu goiro ani. Anike i dai sosi uwara eku fou duboro amuke ane odike wei, Ae ba Godinu Amarabaie ewadoma bibi uake dooro isaa weike nono wei, Godinu bukaroma eno weaku, Danu aneruma a yawofeisake wanama gabo maimekaisaro me irauaiai isare ane isafakuro Anu umu omama da ufekua, Godinu bukaroma eno weaku enoya bibi ua wei. ");
INSERT INTO aby_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Seidanima eno weiro Yesuma dawabake wei, Godinu bukaroma nono eno weaku, anu Dai Godi da uke iruke ea eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seidanima Yesu nono munike moi yafa oraara okoro waure amuke ane odi. Amuke ane odike i orofa akaka orouini yaisina kube ari ma boroo yariro Yesu eri. ");
INSERT INTO aby_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eriro seidanima Yesubake eno wei, nanu umu udiro ifoma kodudu yanafakuke nabake guriguri ufakuie i emeini i nauwaro erabusaini yaisina Abake mamauanea wei. ");
INSERT INTO aby_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eno weiro Yesuma ma owerike wei, seidani, imusu ania! Godinu bukaroma eno weaku, yanu Dai Godibairo mane guriguri uaweke Danu waiya mane uawe eno weakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eno weiro seidanima Yesu ido medike aniro aneruma isare aare Yesu Dawa ma yawoisa. ");
INSERT INTO aby_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Moi orouma Yesubairo fakake eno weisa, Dioni ana ebaro oisaya weisaro nauike iroma Gareri orofaro ani. ");
INSERT INTO aby_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","14","Nasaredi goiroma anike Sebiuronini Nafadarai orofa Kafenamu goiro fari. Kafenamu goiye kuna udiro ibiba iro Godinu we bou ukeka mi Isaiyama wei ibake fari. ");
INSERT INTO aby_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isaiyama eno wei, Diodeni adua ekabokena kuna udinakuro Sebiuroni orofaini Nafadarai orofaini i orofa raarayai ibisa. Gareri orofae imusu orounu ibeka orofa. Iro eme keuwere merama mane ukaada ibake dumuro ibinao uke ibisabaie edoro daiwere uiro i orou yaisina eka. ");
INSERT INTO aby_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","I meramawere ukeibisa ibake emuae i feanao uke ibisa inu dumuro Godinu edoro daiwere uia, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","I furo Yesuma wake daiwere eno wei, i urero ibinu Minu yawokaku odo idua fafine ukakua yanu merama merama ukaisa ibai maru uaweke imuke mediawe wei. ");
INSERT INTO aby_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuma Gareri kuna udiro enaada eribaie moi aidakae emenu ibiyaiye Saimoni nono danu moi ibiye Fida, dawaini danu dabue Enuduruini emuama emenu iwame mukike aduaro ode ere eneibisiro Yesuma emua erie. I aidakae emua adua abu muneka miyai. ");
INSERT INTO aby_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I aidakae erieke emuabake eno wei, Nabairo aarawake yawokoakiro anifeke ya eme muneka miyaiya odimiaro eme muawaro Godinu wake naukeka orou sifisa wei. ");
INSERT INTO aby_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eno weiro i aidakae emenu iwame sabu meisike Yesunu umuro anisi. ");
INSERT INTO aby_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","22","Iroma Yesu aneebe eribaie moi aidakae Debedinu amarayai emenu ibiye Deimisini Dionini nono emenu babaeini boudiro yaure ibaada iwame ma wiromeibisaro erie. Emua erieke u weike Nanu umuro aarawa weiro emenu babae boudiro idua meisike Danu umuro anisi. ");
INSERT INTO aby_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuma Gareri orofa yaisinaro eneiareibi. I Du orounu sosi uwararo we ma iwoka ukaada Godinu irau yawokaku wake weibike i orounu oferi imusu imusu yaisina ma wirokeibirie. ");
INSERT INTO aby_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eno ukeibirieba ibake i Siria orofa orouma Danu buna ukeibi ibai nauisake emenu oferi imusu imusu orouini seidaninu merama imumu bobo orouini yanake kuure fearaisari ukeibisa orouini wana dabamame umu dabamame ukeibisa orouini emua yaisina Yesubairo waure fare odiriekaro emua yaisina ma wirokebirie. ");
INSERT INTO aby_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Emua ma wirokeibiriero Gareri orouini Dikaforisi orofa orouini Derusaremu goi orouini Diudia orofa orouini Diodeni adua ekabokena orouini eme keuwere Danu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yesuma i orou keuwere erieke amuke anike oraara okoro yaure ibibaie Danu iwoka ukeka orou Dawabairo faka. Fakaro emua erieke emuabake wake daiwere we ma iwoka urie. ");
INSERT INTO aby_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Yesuma eno wei, ainama danu naukekae irauaiai meya eno we imukadama nono danu ararae Godi imukenewaa ufike iwoka ufine ufekuie rooro ufi. Godinu urero yawokaku orofae danua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Awoenae emenu meramawere ukekabake imukada ii weaisa orou, Godima emua we ma biwewe ufiakuro rooro ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","I emenu imusu we ma daiwere uke me orou Godima emuabake yewa orofa yaisina mafiakuro rooro ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","I orou emenu ararae Godinu irau imukeka ukenewaa ufisane we imufeisaro Godima emua unu kofiaro enaenari ufeisake rooro ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","I moi imukari ukaisa orou Godima emuabake imukari ufekuke unu kofiakuro rooro ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","I irau mane imuka imukeka orouma Godi efeisake rooro ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aina ainama irauaiai ukeka emuabairo ma iwoka ufeisaie Godima emuabake Nanu amara aruma wefekuro naufeisake rooro ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","I orouma irauaiai ukeibaisaba ibake emema emua meramawere uke yareibakunekaba Godima i irau ukeibaisa oroubake Danu ure yawokeka orofaro odifiakuro iro ibaada rooro ukeifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yae Nanu oroubake emema yabiro merama wake wefeisake merama ufeisake meomao wefeisaie rooro uawe eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yanu moko muneka daiwere urero mufoisaya rooro daiwere uawe wei. I orounu oinamukuma Godinu we bou ukeka oroubairo enaenari ukeibisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yae yewa orofa akaka orounu damena ari. Emema irauaiai damena iseibaisa i ari yae irauaiai ukeibaisaie emema eraada ie irauaiaiya weibaisa. I damenanu imuna me sinakuie aneme aneme danu imuna nono fafeku? Ie ba mebake mune sianaisaro emema amune adire anaisa, i ari yama meramawere ufoisaie emema yanu wake da naufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yae yewa orofa akakanu ramefa edoro ari. Moi oraara okoro ibinu goi da feyafeku. ");
INSERT INTO aby_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Emema ramefa biakaisake okea ubarenaro fe ode dakaisake faniro aiso odaisaro eme yaisina ramefa edoro eraisa. ");
INSERT INTO aby_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Enaenari yanu irau ukekae ramefa edoro ari uawero emema efisake yanu urero ibinu Babae Godinu ibi we ma daiwere ufisa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mosesinu darawaduini Godinu we bou ukeka orounu wakeini i yaisina mune siamane da unea eno da imuawe. Ie mune siamane fare dauneke i darawadu wake ma boroo yamane fanea eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nanu ba wake wemaro nauawe, ureini dooini ibifekuro Godinu darawadu wakenanaku da me sifekuro i wake yaisina ukenewaa ufekuie nono i deima ba me sifekuro nono Godinu wakeye da me sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aina mima Godinu darawadu wake demuinaku nauke dakakuke nono moi orou enaenari we ma iwoka ukakuie dawa i ure yawokeka orofaro okoanaku sifekua eno wei. Nono aina mima Godinu darawadu wake yaisina naukenewaa ukakukema nono moi orou enaenari we ma iwoka ukakuie i urenu yawokeka orofaro daiwere sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yabake ba wake wemaro nauawe eno wei. Yanu irau ukeka sinekama i Ferosi orouini i darawadu ma iwoka ukaisa orounu irau ukeka sineka ma bereke dakaisaie i ure yawokeka orofaro da anifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mosesima i adina oroubake eno wei, eme da ma feaewe. Aina mima moi mi ma feafekuie dawa kodo ufeisaya Mosesima eno weiroma nono yabake eno weakune, aina mima danu naiyebake dino ufekuie dawa kodo ufekua eno wei. Nono aina mima danu naiyebake wake meramawere wefekuie i kanisoro oroubairo waure ane odifeisaro dawabake wake daiwere wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nono aina mima danu naiyebake ae gogore miya wefekuie dawa i feare dakaku inaaro anifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ae Godinu ofereni odeka orofaro anu ofereni odifane anifakukema nono iro anu naiyema abake dino ukaku eno imufakuie anu ofereni iro ibifiro anu naiyebairo aniake ibai yaisina ma gienabu uakema nono oweake anu ofereni odeka odia eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Moi mima ya kodo oroubairo wayai wefine waure anifekuie dawabake sabu naiye weawe. Mebaie i wayai weeka mima ya kodo ureka dai minu wanaro mame odifekuro i kodo ureka dai mima ya firisimaninu wanaro mame odifekuro firisimanima ya ana ebaro odifiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nanu ba wake wemaro nauawe, ya ana ebaro odifiakaisaie iro ibaada i owere fareka ukeka oi yaisina mafoisaro nono ya yaisina odaifiakuro anifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","28","Moi minu aruma enare odekaini moi minu aweka enare odekaini eno da uawe weisaro ya yaisina nauisaroma nono yabake ba eno weakune, aina mima moi aruma o aweka enare odifine imukakuie dawa imukama moi minu aruma o aweka ba enare odakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Anu ba ena naisama a ma merama ufekuie ma doroo yare mune siake naisa kai demui mane ibifakuie irauaiaiya weike nono naisa kai raarayaima i feare me inaaro anifakuie meramawere enoya ma doroo yare mune siyaa eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anu ba ena wanama a ma merama ufekuie umane kuufakuke wana demui mane ibifakuie irauaiaiya eno weike wei, nono ofe ubu yaisinaini feare me inaaro anifakuie meramawereya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosesima i adina oroubake danu darawadu wake eno wei, aina mima danu aweka medifekuie danu awekabake kodo ureka owaowa yanafekuke mafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eno weiroma nono yabake eno weakune, aina mima moi eme adarabake uke dadaku aweka medakuie danu emema merama ufekuke danu aweka ma merama ufekua wei. Eno ufeku ibake i awekama moi eme mufeku. Eno ufekuba ibake i aweka danu awoena emeini dodoo ukeifisisi. Ukeifisisiro nono i aweka danu awoena eme me ibifekuie emenu ukeifisisi ibai meramaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mosesima i adina oroubake eno wei, i darawadu wake ya nauisaya weike wei, I wakeye eno, buna we bou ufoisaie meo da weaweke anemerabu we bou ufoisaie Godibairo enaenari uawe eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eno weiroma nono Nama yabairo eno weakune, wake we bou ukaadae i wake bunawere wefone ukaadae urenu ibiro da weawe ie Godinu yaure yawokeka orofaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Enaenari nono eno wei, doonu ibiro da weawe ie Godi Danu umu amuke ibeka orofaya wei. Derusaremu goinu ibiro da weawe ie i dai yawokeka minu goiya wei. ");
INSERT INTO aby_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yama we bou ukaadae yanu demiro daiwere eno da weawe yama i fouma idi da weforo inana o duba da sifeku arie eno da weawe wei. ");
INSERT INTO aby_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yanu wakeye ba o me i mane weawe. Nono moi buna wake wefone arawere ufoisaie seidanima danu merama imuka yanu imuka ubarenaro mafekuro wefoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mosesima wei wake ya nauisa. I wakeye i ari eno, moi mima moi minu naisa ma doroo yafekuie danu naisa moko ma doroo yaewe wei. Eno weike nono wei, moi mima moi minu nio ma fururu yafekuie moko danu nio ma fururu yaewe weia wei. ");
INSERT INTO aby_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eno weike Yesuma nono wei, yabake weakune wei, moi mima yabake meramawere ufekuie moko da uawe wei. Nono moi mima ya omeafera ufekuie yanu moi ena ma oweawero nono ufi wei. ");
INSERT INTO aby_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nono moi mima yanu sedi mufine ya kodoro odifekuie yanu sedini yanu dubo barukekaini maawero mufi wei. ");
INSERT INTO aby_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nono moi mima danu arara aini daaba funaku anifuone bunawere wefekuie dawaini i yafa daabaro ania wei. ");
INSERT INTO aby_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moi orouma eenu wefeisaie emuabake mayakaweke nono moi orouma yadai we mufisane wefeisaie emuabairo mayakawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","I Mosesima wei wake ya nauisa. I wakeye eno wei, yanu naiyemukubake imukari uaweke yaini wasai ukaisa oroubake imuka ka uawe Mosesima adinaro weia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eno weike wei, yabake weakune wei, yaini ukaisa wasai oroubake imukari uaweke yabake meramawere ukaisa oroubake Godibairo guriguri uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eno ufoisaie yanu urero ibinu Babaenu amaraku sifoisaya wei. Godima eme yaisinabake imukari ukaada Danu eweka edoro i irau orouini i merama ukaisa oroubake makakuke Danu obi i irau orouini i merama ukaisa oroubake enaenari makakune eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Emema yabake imukari ukaisaro emua moko imukari ukaisaie i dawa irauaiairoma nono Godima yabake ya irauaiai oroua da wefekua wei. Inu ubiye i eme yaisinaini i dakesi muneka orouini enaenari ukaisabake eno wei. ");
INSERT INTO aby_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yanu naiyemuku manebake arie wake wefoisie i dawa irauaiairoma nono Godima yababake ya irauaiai oroua da wefekua eno weike wei, eme yaisina enaenari ukaisaro nono i Godi iwoka me imusu orouini enaenari ukaisa ibake eno weada wei. ");
INSERT INTO aby_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yanu ukeka sineka Godinu irau ukeka sineka ari ukenewaa uawe Yesuma i wake eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yanu ararae emema yanu ukeka sineka efisake yanu ibi we ma daiwere ufisane ibake eno da uforo wei. Emema efisake yanu ibi we ma daiwere ufisane ufoisaie i dawa yanu moko muneka iduaya eno wei. Nono eno ufoisaie yanu urero ibinu Babaema yabake irau me makeka moko da mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yanu ararae eraerabusa me oroubake anemerabu mafiakane ukaada emema naufisake efisane u daiwere da weaweke fenakuma mayakawe wei. I meomao weeka orouma Du orounu sosi uwaraini goi daaba daabaro eme moima efisane ibake eno ukaisaya wei. Eno weike nono wei, yabake ba irau wake wemaro nauawe wei, emema eno ukaisaro eme moima ibai eraisaie i dawa emenu moko muneka iduaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yanu ararae eraerabusa me oroubake anemerabu mafone wefoisaie fenakuma mayakawero eme moinakuma da efisa wei. ");
INSERT INTO aby_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","I fema ufoisaro yanu Babaema i fenakuma mafoisa ibai efekuke ya we ma irauaiai ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yama guriguri ukaadae i meomao orounu guriguri ukaisa ari eno da uawe wei. I orou emenu ararae eme moima efisane ibake Du orounu sosiro o daabaro enare ibaada eme moima efisane guriguri ukeibaisaya Yesuma eno wei. Yabake ba irau wake wemaro nauawe wei. Godima emua da we ma irauaiai ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nono yama guriguri ufone ukaadae yanu uwara ubarenaro aniaweke ko uaweke yanu urero ibinu Babaebairo fenakuma guriguri uawe. Eno ufoisaie yanu urero ibinu Babaema yanu fenakuma guriguri ukaisabai efekuke ya we ma irauaiai ufiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Guriguri ufoisaie i Godi iwoka me imusu orounu me sara wake keuwere emenu ba me godibairo guriguri ukaisa enaenari da uawe wei. I orouma wake keuwere wefeisaie Godima naufekua eno we imukaisa. ");
INSERT INTO aby_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","I orounu ukaisa i ari eno da uawe wei. Yanu urero ibinu Babaema yanu arara yaisina iwoka sinakuke yanu we nauke ereka Dawako iwoka ukakuba wake keuwere sara sara da weforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yama guriguri ufone ukaadae eno weawe, iyanu urero ibinu Babae, Anu ibi daiwereba ibake iifa ukaisi. ");
INSERT INTO aby_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anu yawokaku odo fafine weaisi. Anu arara ukeka yaisina ua, urero ukaku i ari eno dooro enaenari ua. ");
INSERT INTO aby_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Awoenae iyanu aine wai ure makeibaku uruna enaenari maa. ");
INSERT INTO aby_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iyanu naiyemukunu ba me ukeka iyabairo ukaisa, ibaie imuke medaisi enaenari iyanu ba me ukeka imuke media. ");
INSERT INTO aby_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","I merama uke ereka eraerabusa iyabairo da waure aarake i merama ukekabairoma iya imusu waure ania. ");
INSERT INTO aby_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ya emenu ba me ukeka imuke medifoisaie yanu urero ibinu Babaema yanu ba me ukeka imuke medifiaku. ");
INSERT INTO aby_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nono emenu ba me ukeka da imuke medifoisaie yanu urero ibinu Babaema yanu ba me ukeka da imuke medifiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ya Godibairo guriguri ufone ukaada uruna kau ufoisaie yanu iboo naisa imusu imusu da uawe. Nono i meomao weaisa orouma Godibairo guriguri ufisane ukaada uruna kau ukaisake bouna karaisa. Inu ubiye imukarima imusu ari ukaisake emema emua efisane ukaisaroma nono ya i ari eno da uawe. I orouma eno ukaisaie ibaie emenu moko idua munaisa. ");
INSERT INTO aby_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Godibairo guriguri ufone ukaadae uruna kau ufoisaie yanu foumaini iboo naisaini uroawero emema ya uruna kau ufoisa ibai iwoka da sifeisaro nono yanu urero ibinu Babaema ya fenakuma ukaisa ibai erakuba ibake yabairo irau makeka moko mafiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Eraerabusa keuwere yewa doo duboro duboro da odiawe. Yewa eraerabusa Yewa dooro raneini kikoima kuuraisaro waira ukeka orouma waira ukaisaya yanu eraerabusa urero odiawero raneini kikoima yanu eraerabusa iro da kuufisaro waira ukeka orouma waira da ufisa ibake yanu eraerabusa dooro mane da odiawe. ");
INSERT INTO aby_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yanu eraerabusa aboro ibakuie yanu imuka yaisina iro ibaku ibake yanu eraerabusa urero odiawero yanu imukaini yaisina iro ibifi eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yanu naisae yanu ofe ubunu edoro. Eno ibake yanu naisama irau erabusa eraisake irauaiai imuka imukaisaie yanu ofe ubu ubarenaro edorowere ibinu. ");
INSERT INTO aby_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nono yanu naisama merama erabusa eraisake merama imuka imukaisaie yanu ofe ubu ubarenaro dumuwere ibinu ibake erenewaa uforo eno wei. I merama erabusa eraisake merama imuka imukaisa i arie yanu edoro meramawere i dumu ari enoba ibake yanu imuka ubarenaro dumu daiwere ibinu. Yanu imukeka dumuwereie yanu ibekae meramawerea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Moi waiya ukeka mima dai miyainu waiya da ufeku. Eno ufekuie dai mi una demui mane dino ufekuro danu imukae moi dai mibairo ibifeku. Enoba i dai mi una demuinu waiya mane ukenewaa ufekuke nono i moi minu waiya me sarawere ufekua wei. I arie enoba Godinu waiyaini oi waiyaini demuiro da ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Enoba yabake weakune, yanu ibinisa ofebake da imuawe wei. Yanu wirokekae i urunabairoma da wirofoisaya wei. Nono yanu ofeye i barukekama da ma wirofiakua weike nono wei, ibake urunaini barukeka mane da imuawe wei. ");
INSERT INTO aby_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","I ada imuke eawe. I adama ana kai yo wawe dakaisake ana kai fira uke mero nono emuabairo uruna madawa odeka uwara mero nono iyanu urero ibinu Babaema emuabake uruna makakune. Godima emuabake eno imukadama nono iyabairo imukari daiwere imukenewaa ukakuni. ");
INSERT INTO aby_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aina mima imukebe imukebe danu ibeka odo ma yafa ufeku wei? Eno weike wei, eno da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ya anemebake yanu barukeka wau mane imukenewaa ukaisa wei? I isoni imuke eawe! I isoni emua waiya uke mero emenu mane wau rune dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Soromonima danu arake ibeka wau runiro danu waue irauaiai mero nono i isoni dawa wau rune meroma nono danu arakekae irauaiaiya wei. ");
INSERT INTO aby_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nono Godima wei, i koe eweira ari runi fomuke ibakuro nono wairo ari inaama yaraisaya wei. Godima i koe yawokakuke nono iya i dai menaku naukeka orouini yawokada wauma barukenewaa ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ibake aneme urunaini aduaini ifeke anemerabu barufeisi i da imuforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enoba i orofa akakaro Godinu wake nauke dakaisa orou yaisinae i urunaini adua yodia ukenewaa ukaisaro nono yanu urero ibinu Babaema yanu ibeka Dawa iwoka ukaku. ");
INSERT INTO aby_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","I da yodia ukenewaa ufoke nono Godinu irau yawokaku i orofa yodia ukenewaa uforo Godima yanu urunaini wauini i yaisina yabake mafiaku. ");
INSERT INTO aby_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Enoba wairobake da imuforo wei. I waironu ukeka sineka ido fafekuro imufoisa wei. Odo demuinu ukeka sineka i odo mane imukenewaa ufoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Yesuma eno wei, moi oroubairo moi mi me sara wayai da wefoisaie Godima ya wayai da wefekua wei. Nono moi oroubake me sara wayai wefoisake fanisi mafiakaisaie Godima enaenari yabake wayai wefekuke fanisi mafiakua eno wei. Nono moi orounu merama ukeka imuke medifoisaie Godima yanu merama ukeka imuke medifiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Eno weike nono wei, nono iyanu imuka ubarenaro meramako efekema wefene ibake eno wei, anemebake moi minu naisa urimiro ifurunaku erenewaa ukaisake nono yanu naisa urimiro ibinu ana kuku ari ifuruwere ere dakaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Anemebake eno weaisa, kaka, ukeka meramawere dai me ifurunaku ari anu naisa urimiro ibinua mune siama weaisakema nono yanu daiwere merama ukeka, ana kuku ari yanu naisa urimiro ibinuro ere dakaisa wei? Ya meomao weaisa orou yanu naisa urimiro ibinu ana kuku mune siafoisake erenewaa ufoisaie nono yanu kakamukuini naburakanu naisa urimiro ifurunaku ibinua mune siawe wei. Yesuma emenu merama merama ukekabake dubo waure weada yewa wake i ari eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Godinu irau wakeini we dodoo ukaisa orou, i oroue kua ari enoya emuabairo Godinu irauaiai wake da yayakawe wei. Yanu Godinu makinu i imukeka ie oi oma ari, ie borosiribairo da siawero borosirima amune adiadi yanao ufeisake ya owere anao ufeisaya wei. Inu ubiye Godinu makinu irau imukeka i we dodoo ukaisa oroubairo da yafiakane weada wei. ");
INSERT INTO aby_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","We nauke eawero mafiro muawe. Yodia uaweke fou uawe. Aisamero goi goi ukaada yaure ibinu weawero ko ma ro yafi wei. ");
INSERT INTO aby_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aina mima we nauke efekuie mafekuro mufeku. ");
INSERT INTO aby_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aina mima yodia ufekuie fou ufeku. Aina mima aisamero goi goi ukaada yaure ibinu wefekuie ko ma ro yafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Anu amarama urunabake eenu wefekuie oma mafaku? Eno me. Anu amarama adua abubake eenu wefekuie waru mafaku? Eno da ufakua wei. ");
INSERT INTO aby_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ya merama oroue yanu amara aruma irau eraerabusa makakunekaba aina mima Godibairo we nauke efoisaie yanu urero ibinu Babaema yabake Danu Imumu irau makenewaa ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Emema yabairo aneme ufisane wefeisaie emuabake enaenari eno uawe. Eno ufoisaie Godinu darawadu wakeini Danu we bou ukeka orounu wake ubi iduaba eno ufoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuma nono wei, i dai me aisamenakuro fare aniawe wei. I feare me inaanu orofa aisameye daiwerero nono i daabae ara mero nudawere ibake eme keuwere fare anaisa. ");
INSERT INTO aby_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nono i me ibene ibene ibeka orofaro anaisa aisame dai me aisame ebanakuro nono i daabae arawereba ibake eme keuwere me i daabanaku yodia uke fare anaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","I meo we bou ukeka oroubake erenewaa uforo wei. I orouma ya irufiakane i mamoe abu ari emua waa abu me i ari eno yabairo fafeisakema nono dubuenaroe i waa nauwa kuama i okoanaku abu ma merama ukaku i ari emenu merama imukama ya ma merama ufiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I irau ana warafekuie irau kai uwafeku. Nono i merama ana warafekuie merama kai uwafeku. Moi anama irau kai uwafekuie irau anaya wefeisa. Nono moi anama merama kai uwafekuie merama anaya wefeisa. Aneme aneme ufeku enaenari wefeisaya wei. Emema naadidi kai anaro mune dakaisake boruba kai sinisini bobo anaro mune dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Enoba i irau anae irau kai uwanaku. Nono i merama anae merama kai uwanakua wei. ");
INSERT INTO aby_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Irau anae merama ana kai uwane dakaku. Merama anae irau kai uwane dakakua wei. ");
INSERT INTO aby_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I merama anae irau ana kai uwane dakakuba ibake umane kuuraisake inaa yareibaku iro sianaisa. ");
INSERT INTO aby_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","I meo we bou ukeka orounu ukaisa ibaie i ana kaibai ariba ibake eraisake emua iwoka sinaisa. ");
INSERT INTO aby_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eme keuwere Nabake Dai Mi, Dai Mi meo eno weaisaie i orou yaisina i ure yawokeka orofaro da anifeisaro nono Nanu urero ibinu Babaenu imukeka waiya ukaisa orou mane iro anifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","23","I furo, Godinu kodo odoro, eme keuwere Nabairo eno wefeisa, Anu ibiro we bou ukeibaisike seidaninu merama imumu we berakeibaisike buna ukeka ukeibaisi eno wefeisaie ya meramawere ukaisa orou Nae ya iwoka meya Nabairoma aniawe wemauro anifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aina mima Nanu wake naukenewaa ukakuke enaenari ukakuie dawa iwoka daiwere mi ari eno. Enoba i mima danu uwara kukubu doo eba yafawere daunike kukubu kai oma deiro yanaike omaini dooini sianike usima yanairo arabi sini. ");
INSERT INTO aby_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Danu uwara eno uke ma enariro obi makeibiro oku fareibiro oyau daiwere fareibiro uwara oma duboro ibibairoma doroo yare da ui. ");
INSERT INTO aby_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nono aina mima Nanu wake naukakukema nono medakuie dawa awara me mi ari eno. Enoba i mima danu uwara kukubu siane da uike gibudi duboro ma enari. ");
INSERT INTO aby_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eno uiro obi makeibiro oku fareibiro oyau daiwere farike i uwara ma doroo yariro i uwara ido merama sinia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuma Danu wake we me siniro i orou yaisina Danu bunawere we ma iwoka ukeibirie ibai nauisake imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yesuma bunawere we ma iwoka ukeibiriero i owaowa odeka orounu buna me wake ari meba ibake i orou yaisina imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu o raararoma isare aareibaie eme keuwere Danu umuro aaka. ");
INSERT INTO aby_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Moi beko sini mima Yesubairo farike ifoma kodudu yanakada eenu weada eno wei, Dai Waria Mi, Anu arara ufakuie na ma wirofarakuro wiromaua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eno weiro Yesuma Danu wanayai i minu ofero ure burisada eno wei, Nanu ararae a ma wiromaro wiroa wei. Eno weibaie ena beko idua me siniro wiroi. ");
INSERT INTO aby_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuma i mibairo eno wei, eme yaisinabairo da weake ofereni ode sibore sianeka mibairo aniake anu ofe ma iwoka uaro efi wei. Anu ofe irauaiai ukinuba Mosesinu darawadue i beko bounu ofereni odeka enaenari uaro emema efisake anu ofe wirokinua wefisake iwoka ufisa wei. ");
INSERT INTO aby_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yesuma Kafenamu goiro faribaie moi Romani gaemani ame kafudenima Yesubairo farike eenu weada eno wei, Dai Waria Mi, nanu waiya ukeka miye wana siane me umuma enare mero aine ibaada oferi daiwere ukakuro aine ibinua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eno weiro Yesuma owerike dawabairo eno wei, iro animauke dawa ma wiromaua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yesuma eno weiro nono i ame kafudenima Yesubake ma owerike eno wei, Dai Waria Mi, na irauaiai me miya nanu uwararo da aarake wake mane wearo nanu waiya ukeka mi wirofi wei. ");
INSERT INTO aby_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eno weike nono wei, nae dai ame miya wei. Moi dai orouma na yawokakunekaro nono nama ame orou keuwere yawokakuniake moi mibake ania weakunero anakua wei. Nono moi mibake aara weakunero aarakua wei. Nono nanu waiya ukeka mibake eno ua weakunero enaenari ukakua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eno weiro Yesuma i wake nauike imuka foria uike Danu umuro eneibisa oroubairo eno wei, yabake ba wake wemaro nauawe wei. I Isaraera oroubairo imukeka daiwere i minu imukeka ari fou uke da unea wei. ");
INSERT INTO aby_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Eno weike nono wei, yabake weakune, eme keuwere eweka amukaku enaro orouini eweka isaraku enaro orouini i ure yawokeka orofaro fafeisake Eibaramuini Aisikini Deikafuini emua sebo udiro yaure ibaada demuiro uruna iseifeisaro nono i Du oroue emenu imuka yaisina Godibairo ibe meba ibake i ba ure yawokeka odoro i orou, Godima emua kebiro, i dumu orofaro bi mame odifiakuro iro emenu nio ake fagigi yaraada ii weifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuma eno weike i ame kafudenibairo nono eno wei, ania, ama daiwere imukinubake enaenari ufekua wei. Eno weibaie i waiya ukeka minu arama idua wiroiro irau sini. ");
INSERT INTO aby_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuma Fidanu uwara ubarenaro amui. Amuike eribaie Fidanu naroeya ofe wadada uiba aine ibiro eri. ");
INSERT INTO aby_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Erike danu wanaro ure buriro ofe wadada ukeibi ibai idua ure nuda ui. Ure nuda uiro Fidanu naroeyama uyarike Yesu uruna mairo i. ");
INSERT INTO aby_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dumu sineibiro i orou emenu moi seidaninu merama imumu bobo orou Dawabairo waure fare oisaro Yesunu wakema seidaninu imumu merama we ma beraike i oferi waureibisa orou yaisina ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isaiyama wei wake enaenari Yesuma eno ui. Adinami nauwaro Godinu we bou ukeka mi Isaiyama eno wei, Dawa yanu ofe meramaini yanu oferi waurekaini mune ma wiroia, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Eme keuwere Yesu enare kara uisaro Yesuma emua erieke Danu iwoka ukeka oroubairo eno wei, kuna ekabokenaro siraa yare anife wei. ");
INSERT INTO aby_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eno weibaie moi owaowa yanakeka mima Yesubairo farike eno wei, Sisa mi, aboro aboro anifakuie naini Anu umuro aamaua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Eno weiro Yesuma dawabake eno wei, i nauwa abu emenu uwara bobo, nono i gasira emua emenu mowa boboro nono i Ba Eme Sini Mi Danu aineka orofa meya wei. ");
INSERT INTO aby_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eno weiro moi iwoka ukeka mima eno wei, Dai Waria Mi, nanu babae feafekuro fira uke odimauke Anu umuro aamaua wei. ");
INSERT INTO aby_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dawama eno weibaie Yesuma wei, eno meya, awoena Nanu umuro aara wei. Nanu umuro aare me orouma Nanu umuro aare mero fearaisa orou fira ufiakane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuma boudi ubarenaro amuiro Danu iwoka ukeka orouma Danu umuro anisake ane amuisake anisa. ");
INSERT INTO aby_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aneebe Yesuma nauka aine ibibaie oyau daiwere fari. Oyau fariro adua ufe uyariro boudi inufine uiro Yesu boudi barunaro kudo odike aine ibi. ");
INSERT INTO aby_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aine ibiro i ukeibi ibai ekake Danu iwoka ukeka orouma Yesu ma uyakake daiwere weisa, Dai Waria Mi, iya feafene ukaisia ma wiroa weisa. ");
INSERT INTO aby_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Eno weisaro Yesuma wei, ya naukeka dai menaku orou anemebake ia iyaraisa weike uyarike oyauini adua ufeini we kuuriro me mo ari sini. ");
INSERT INTO aby_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eno uiro i orouma Yesu i uibai ekake imuka foria uisake eno weisa, yewa mide abo miro oyauini adua ufeini Danu wake naukisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gadarini orofa, kuna ekabokena iro ane enaka. Seidaninu merama imumu rewoke ibeka miyai eme feareibisaro ane odeibirieka oma eraboro ibeibisi. I miyai waama imusu ari ibake eme i daabaro ane dakeibisa. ");
INSERT INTO aby_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","I miyaima Yesu fou ukike eno weisi, Godinu Amara, uwabake aneme ufane ukaku weisi? Uwanu kodo ureka odo fare meya uwa fanisi da maa weisi. ");
INSERT INTO aby_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eno weisibaie borosiri keuwere ubibinakuro uruna ise eneibisa. ");
INSERT INTO aby_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Idua i seidaninu merama imumuma weisake eno weisa, iya we ma berafakuie i borosirinu imuka ubarenaro we odaiaro anife weisa. ");
INSERT INTO aby_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eno weisaro Yesuma emuabake eno wei, aniawe wei. Eno weibaie idua anisake i borosirinu imuka ubarenaro isaka. Isakaba ibake i borosiri yaisina durame anisake oraara okoroma bibi ukake kunaro isare imu ise feare soaka. ");
INSERT INTO aby_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Enoba i borosiri yawokeibisa orouma idua meisake sabu durame anisa. Ane goiro fakake i seidaninu merama imumu bobo miyai wiroisiro wake weisaro i goi orou yaisina nauisa. ");
INSERT INTO aby_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","I goi orou yaisina goiroma Yesu ibi orofaro aaka. Aare Yesubairo fakake Yesu eraada eno weisa, iyanu ibinisi orofaro da ibiake ania eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuma boudi ubarenaro amuike owerike ekabokena Danu goi enaro siraa yare ani. ");
INSERT INTO aby_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ane fariro moi orouma wana siane me umuma enare me mi boisa dubo uisaro aine ibiro Yesubairo waure fakake oisa. I mi waure faka orounu imukeka daiwerero Yesuma erike i wana siane me umuma enare me mibake eno wei, Nanu amara, anu merama ukeka Nama mune imuke medinea imuka ara sia wei. ");
INSERT INTO aby_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yesuma eno weibake moi Mosesinu darawadu ma iwoka ukeibirieka orouma emenu mane eno weisa, yewa mima eno wenuba ibake dawaini Godini emua demuiya weakuba ibake wake merama weakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Eno weisaro Yesuma emenu imukeibisa ibai iwoka ukaada emuabairo eno wei, anemebake imukama meramawere imukaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Abodei wakema wemauro naufoisa wei? Anu merama ukaku ima imuke medimauba ba uyake anu wea muake ania wemau eno wei? Abodei wakema arawere wei? ");
INSERT INTO aby_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yesuma eno weike nono wei, i dooro eneibaku Ba Eme Sini Minu buna daiwere ibake emenu merama ukeka mune imuke medakunero ya yaisina eraada iwoka ukaisa weike i wana siane me umuma enare me mibairo eno wei, uyake anu wea muake anu goiro ania wei. ");
INSERT INTO aby_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yesuma eno weiro i mi uyarike danu goiro ani. ");
INSERT INTO aby_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Enoba i ku uke ibisa orou yaisina ibai ekake imuka foria uisa. Godima i mibake buna daiwere eno maiba ibake emuama Godi we ma irauaiai uisa. ");
INSERT INTO aby_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu iroma ani. Aneibibaie moi dakesi muneibi mi, danu ibiye Madiu, dawa dakesi muneka uwararo yaure ibiro Yesuma eri. Erike eno wei, aarake Nanu iwoka ukeka mi sia wei. Eno wei ibake Madiu idua uyarike Yesunu umuro ani. ");
INSERT INTO aby_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dumudumu siniro Yesuma Madiunu uwara ubarenaro uruna ifine amuke yauri. Dakesi muneka orou keuwereini merama merama ukeka orou keuwereini emuama Yesuini Danu iwoka ukeka oroubairo uruna ifisane aare faka. ");
INSERT INTO aby_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fakaro i Ferosi orouma ekake Yesunu iwoka ukeka oroubairo eno weisa, yanu sisa mini i dakesi muneka orouini merama merama ukeka orouini anemebake demuiro uruna isaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Eno weisaro Yesuma nauike eno wei, i arama uke me oroubake i arama ma wirokeka mi aare dakinuke i arama uke ibinisa oroubake aarinua wei. ");
INSERT INTO aby_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nanu ararae yanu imukari ukekabake aanea weike nono wei, Na arara me yanu ofereni odeka wei. Aniaweke i wakenu ubi uke iwoka uawe wei. I iya irau oroua we imukaisa oroubake wemane wayo fare da uneke i merama merama ukeka oroubake wemane wayo fanea wei. ");
INSERT INTO aby_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dioninu iwoka ukeka orouma Yesubairo fakake eno weisa, i Ferosi orouini iyanu bisarama uruna ise mero kau ukaiside nono Anu iwoka ukeka oroude anemebake uruna kau uke dakaada uruna isaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eno weisaro Yesuma emuabake eno wei, Nanu moi wake wemaro nauawe wei, i awoena aweka mufeku mima uruna isakuba ibake i uruna isaisa orouma ii da wefeisa. Dawa emuabairo ibinuba ibake ii da wefeisa. Nono moi odo i aweka awoena mufeku mi mufeisake waure imusu orofaro odifeisaie i orouma uruna da ifeisake kau ufeisa. Enaenari dubuenaro emema Na waure anifeisaie Nanu iwoka ukeka orouma enaenari ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aina mima awoena wau fifinima adina wau dorobu yafeku ebaro yanake isura ufekuie i adina wau babafekuke eba daiwere unao ufekuba ibake eno da ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nono awoena wainima adina abunu ofero iifekuie adina abunu ofe da ure wawafeku ibake eno da ufeku. Nono i adina abu ofero iifekuie i adina abunu ofe babafekuro waini dooro isafekuro abunu ofeini wainini ido merama sifeku. Ibake awoena waini awoena abunu ofero iifekuro wainini abunu ofeini irauaiai ibifekua eno wei. Yesuma i Mosesinu adina darawadu wakeini nono Danu awoena wakeini ma demuiro da ufoisaya weada ibake eno dubo waure wei. ");
INSERT INTO aby_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuma emuabake eno weibaie moi Du orounu sosi uwara yawokeka mima farike Yesunu umu udiro ifoma kodudu yanakada eno wei, nanu arumanaku fearinua wei. Aarake nanu arumanaku anu wanama danu duboro odiaro irau sifi wei. ");
INSERT INTO aby_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eno weiro Yesu ido uyarike i minu umuro ani. Aniro Yesu Danu iwoka ukeka orouini anisa. ");
INSERT INTO aby_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ido anisaro moi aweka arama daiwere uike iwa mane dore aineibi. Iwa mane dore aineibiro oya duwero (12) eno uke iwa mane dore aineibi. Yesu enakua weisaro nauike danu imukama imuike eno we imui, animauke Danu wau barunaro ure burimauke wiromaua eno we imuike ane Yesunu derena enaro farike Danu wauro ure buri. ");
INSERT INTO aby_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ure buriro Yesuma ma owerike i aweka eraada eno wei, yewa aweka, imuka ara sia wei. Ama Na imukeka imukae daiwere ibake wirokinua wei. Yesuma eno weibaie i aweka idua wiroi. ");
INSERT INTO aby_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuma i yawokeka minu uwararo fareibibaie moi orouma wirori ukaro i ku uke ibisa orouma sorara daiwere ukeibisaro eri. ");
INSERT INTO aby_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Erike i oroubake eka imusu aniawe weike wei, i arumanaku feare mero nauka kunawere aine ibinua wei. Eno weiba ibake i orouma yo weisa. ");
INSERT INTO aby_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yo weisake i orou yaisina dooro isakaro Yesu i uwara ubarenaro amui. Amuike i arumanakunu wanaro munike ma uyariro i arumanaku idua uyari. ");
INSERT INTO aby_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yesuma i arumanaku ma uyari i wake i orofa akaka orou yaisinabairo we eneibisa. ");
INSERT INTO aby_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu iroma moi uwararo ani. Aneibibaie naisa kikori bobo miyaima Danu umuro anaada daiwereroma eno weisi, Deiwidinu amara uwabake imukari ua weisi. ");
INSERT INTO aby_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eno weisiro Yesu uwara ubarenaro amuibaie i miyai Danu umuro amuisike Dawabairo fakiro Yesuma emuabairo eno wei, eno umau imukaisi wei? Eno weibaie i naisa kikori bobo miyaima weisi, Dai Waria Mi euwa weisi. ");
INSERT INTO aby_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eno weisiro Yesuma emenu naisaro ure burisada eno wei, yanu naukeka daiwereba yabake enaenari umaua wei. ");
INSERT INTO aby_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eno weiro emenu naisa irauaiai uiro eki. Ekiro Yesuma emuabake buna wakeroma eno wei, moi oroubairo da wayai wefuao wei. ");
INSERT INTO aby_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eno weiro i miyai nauke meisike i orofa akaka yaisinaro we eneibisi. ");
INSERT INTO aby_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesuini i orouini emua iroma anisa. Aneibisabaie moi orouma seidaninu merama imumu boboro wake we me mi Dawabairo waure fare oisa. ");
INSERT INTO aby_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesuma i seidaninu merama imumu we berairo i merama imumu aniro i mi idua wake wei. Eno uiro i ku uke ibisa orouma ibai ekake imuka foria uisake eno weisa, iya Du orou iya adinaroma i ari eno ere mero iyanu kawama eraisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Eno weisaro i Ferosi orouma eno weisa, Dawa i dai merama imumunu bunaroma merama imumu we berakinua weisa. ");
INSERT INTO aby_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuma dai goini okoa goi goiro eneebe i Du orounu sosi uwara ubarenaro amuike we ma iwoka ukaada Godinu yawokaku orofabake wake weada i arama imusu imusu ukeibireka orouini oferi ukeibisa orouini emua yaisina ma wirokeibi. ");
INSERT INTO aby_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesuma i ku uke ibisa orou eriebaie i orou buna mero emenu imukeka imusu imusu imukeibisa. I orou emuae mamoe abu ari. I abu emenu yawokeka mi me ibake daaba daabaro imusu imusu me sara enereibaisa i ari i enoe orou enaenari emenu imukeka imusu imusu imukeibisa ibake Yesuma emuabake imukari daiwere ukeibirie. ");
INSERT INTO aby_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","I dauneka urunae keuwere i ari i Godinu wake nauke me oroue keuwere. Nono i uruna dauneka oroue keuwere me, i arie i Godinu wake we eneibeka oroue keuwere me. ");
INSERT INTO aby_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Enoba i dauneka ubi Mibairo guriguri ukaada Danu waiya ukeka orou Danu dauneka orofaro we odaifiakuro anifisa weawero anifisa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuma weiro Danu iwoka ukeka orou yaisina duweroma (12) Dawabairo ane faka. Fakaro Yesuma emua seidaninu merama imumu we ma berafisake arama imusu imusu ukeibirieka orouini oferi imusu imusu waureka orouini ma wirofisane ibake emuabairo buna marie. ");
INSERT INTO aby_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Mariero i eme duwero (12) emenu ibi ibiye yewado, bokaie Saimoni danu moi ibiye Fida. Dawaini danu dabue Enuduruini Debedinu amarayai Deimisini danu dabue Dionini Firifuini Badoromiaini Domasini i dakesi muneibi mi Madiu Arofiesinu amara Deimisini Dediusini i Keinani orofa mi Saimonini i Yesu weforairo muka mi Diudiasi Ikariadaini i orou duwero (12) emenu ibi ibiye idua. ");
INSERT INTO aby_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesu Danu iwoka ukeka orou duwero (12) we mune odirieke we iifa ukaada eno wei, i Du me imusu oroubairo da aniaweke i Samaria orofa orounu goi goiro da aniaweke i Isaraera orou, i oroue fe yareka mamoe ari, i oroubairo mane aniawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","8","Aniaweke Godinu yawokaku odo fafine ukakua eno weaweke i arama ukeka orou ma wiroaweke moi feareka orou ma uyaweke i beko mamakune orou ma wiroaweke i seidaninu merama imumu we ma berawe wei. Ya daiwere mukake moko oi make dauisaba ibake enaenari me mafoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Yesuma nono wei, yanu fausiro oi da youaweke yoake da muaweke moi wauini umu barukekaini uri fuini da muawe wei. I waiya ukeka mi dawabake danu uruna moko mafeisaya i yaisina da mune aniawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Moi goiro anifoisaro Godinu wake naufine ufeku mi yodia uke eneebe fou ufoisaie we muaweke danu uwara ubarenaro ane ibiawe wei. Moi uwara uwara ubarenaro da aniawe. I demui uwararo ibiaweke nono i moi uwara uwara mediaweke aniawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","I minu uwara ubarenaro amufoisaie arie wake weaweke i orou irau oroubaie Godinu irauaiai kakawera yabairo ibifekua eno we ma irauaiai uawe wei, nono i oroue irau orou mebaie yanu irauaiai ukeka owefike yabairo ibifine weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Enoba nono aina ainama ya da we mufeisake yanu wake da naufeisaie yanu derena emuabairo siaweke yanu umuro doo maisuawero emua medifiakane ukaada ufoisa ibai emua iwoka ufisaro aniawe wei. Eno uawero Godima emua da mufiaku ibai emua iwoka ufisa eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yabake weakune, Godinu kodo odo fafekuro merama Sodomu goi orouini Gomora goi orouini fanisi dai menaku mafiakuke nono i goi oroubake fanisi daiwere mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eawe, yae i mamoe abu ari, i meramawere orou nauwa kua ari emuabairo we odaimiauba ibake i waruma erenewaa ukaisa i ari eno uaweke awara buna uaweke nono i ubari gasirama irauaiai mane ukaku i ari eno irauaiai mane imuke uawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Enoba erenewaa uforo ya i kanisoro oroubairo waure ane odifeisake i Du orounu sosi uwara ubarenaro waure ane odifeisaro usima ya ufiakaisa. ");
INSERT INTO aby_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eno ufiakaisake gaemani dai yawokeka orouini kini orouini i Du me imusu oroubairo waure ane odifeisa. Godima yae nanu wake weforo naufisane ufekuba eno ufeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Eno ufeisaie aneme wefone da imufoke i odoro Godima yanu aneme aneme wefoisa ibai yanu imukaro mafiakuro enaenari wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eno weike wei, i odo yanu wake da wefoisaro Godinu Imumu Irauma yanu bebekuroma wake wefekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","I odoro dakaema dabue do mafekuro ma feafeisa. Enaenari babaema danu amara eno ufeku. Nono enaenari amara arumama emenu amae babae eno ufeisaro ma feafiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya Nanu ibi munaisaba ibake i orou yaisina emuama yabake imuka ka ufiakaisaya eno wei. Aina mima awoenaroma enare ara ukeifekuie i dubuena kai odo fafekuro dawa wirofekua wei. ");
INSERT INTO aby_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Enoba yabake meramawere ufeisaie moi goiro sabu aniawe wei. Yabake ba weakune, i Isaraera orounu goi goiro aneebe aneebe yaisina da ane suafoisaro i Ba Eme Sini Mima ido fafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","I uke iwoka miye daiwere mero nono danu sisa minu awarae daiwere. I waiya ukeka miye daiwere mero nono danu eme ereka minu awarae daiwere. I uke iwoka ukeka orou emua sisa mi ari iwoka sifeisaie iduaya wei. Nono i waiya ukeka mi dawa i yawokeka mi ari sifekuie iduaya Yesuma eno wei. Nae i uwara ubi miba ibake eme moima Nae Biesabo o seidani weaisabaie ya i uwara waiya ukeka oroubake ibi meramawere wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Eme moibake ia da siforo wei. Eme emenu oba ukeka sineka yaisina ma woromifekuke emenu imukaro i fema imukaisa eraerabusa yaisinae ma boroo yafekuro efeisa enoya emuabairo ia da siawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dumuro yabake aneme wemaro naufoisake ewekaro enaenari wefoisa. Wake mumuuroma wemaro nauaweke akaka abanaroma daiwere weawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","I ma feareka oroubake ia da siawe wei. I oroue yanu ofe mane ma feafeisake nono yanu imumu da ma feafeisaya eno wei. Enoba aina mima yanu ofe ma feafekuke nono imumuini ofeini i feare dakaku inaaro siafekua Dawa mane ia siawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Emema sisimuri adanakuyai korofeni kai demuima make munaisake yare isaisa. Nono moi gasiranaku dooro me sara da isare ufekuro iyanu urero ibinu Babae Dawako iwoka sifekuroma ai isare ufeku. ");
INSERT INTO aby_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Godima iyabake imukenewaa ukaku. Dawa iyanu bokai idi yaisina kakurada iwoka sinaku. ");
INSERT INTO aby_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Enoba Godima i gasirananaku imukakuke nono iyabake imukenewaa ukakua ia da siawe wei. ");
INSERT INTO aby_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aina mima emebairo nanu naukeka Yesu Kerisobairo odine wefekuie Nama Nanu urero ibinu Babaebairo dawa Na imukakunara wemaua wei. ");
INSERT INTO aby_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nono aina mima emebairo Yesu Keriso na iwoka meya wefekuie Nama Nanu urero ibinu Babaebairo dawa Na iwoka meya wemaua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aneme we imukaisa? Na yabake me irauaiai ibeka me mamiane fanea eno we imukaisa? Enobake fare da ue. Na yewa dooro irauaiai ukeka mamane fare da ue. Na irauaiai mamiane fare meroma Nanu wake wemaro moi orou naukeifisaro nono moi orou nauke dakada urane rarane ukeifisane ibake fare. ");
INSERT INTO aby_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Moi mini danu babae ma fiamiane fare, moi arumaini danu amae ma fiamiane fare, nono moi awekaini danu nainau ma fiamiane ibake weke fare. ");
INSERT INTO aby_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fareba dubuenaro nanu waiya ukeka orounu wasai ukeka oroue emenu demui boanaro isareka oroua wei. ");
INSERT INTO aby_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aina mima danu amae babaebake imukari daiwere ukakukema nono Nabake imukari dai menaku ukakuie dawa irauaiai meba Nanu amara da sifekua eno wei. Nono aina mima danu amara aruma imukari daiwere ukakukema nono Na imukari dai menaku ukakuie dawa irauaiai meba Nanu amara da sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aina mima danu arara da medifekuke irau ukeka korosi ari da waufekuie dawae irau mi meba ibake Nanu amara da sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aina mima yewa orofaro me ibeka i mane imufekuie dawa idua feafeku. Nono aina mima Nabake feafekuie dawa me ibene ibene ibeifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aina mima ya we mufekuie dawa Na we mufarakua wei. Nono aina mima Na we mufarakuie dawae Na we odai Godi we mufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aina mima Godinu we bou ukeka orounu wake naufeku, dawa i orou emuae Godinu we bou ukeka orou ibake naufekuie Godima i we bou ukeka orounu irauaiai moko makekae enaenari i mibairo mafekua eno wei. Nono aina mima moi irau minu wake naufeku, i mi dawae irau miba ibake i wake naufekuie Godima i irau minu moko makekae enaenari dawabairo mafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aina mima Nanu iwoka ukeka amaranaku nodo bugara ufekuro adua mafekuie dawae Nanu amaraba Godima i adua makekae i mibairo moko daiwere mafekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuma Danu iwoka ukeka orou duwero (12) emuabake we ma iwoka uke me sinike iroma ani. Anike i Du orounu moi goi goiro we ma iwoka ukaada eneiareibi. ");
INSERT INTO aby_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Dioni dawa ana ebaro ibiro Yesu Kerisonu wake weisaro Dionima nauike danu iwoka ukeka orou Yesu Kerisobairo we odairo anisake eno weisa, Ae iyanu koro ukaisi Mesaiaba moi mima fafekuro efeisi weisa? ");
INSERT INTO aby_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Eno weisaro Yesuma wei, oweaweke Dionibairo aniaweke yanu awoena erekaini naukekaini yaisina dawabairo eno weawe, i naisa kikori bobo oroue eraisaro i umu beo beo bobo oroue gienabu enaisaro i beko mamakune oroue wirokaisaro ofe irauaiai ibinisaro i ome gogore nauke me koko oroue naukaisaro nono i fearaisa oroue fearaisa iroma uyaraisaro meramawere me ibaisa oroue Godinu irau wake naukaisa. ");
INSERT INTO aby_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aina mima Nabake Na ma nuna da ufekuie Godima dawa we ma irauaiai ufekuro rooro daiwere ufeku. Eno ane Dionibairo weawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dioninu iwoka ukeka orouma Yesu meisake Dionibairo owere anisa. Anisaro Yesuma i ku uke ibisa oroubairo Dionibake Yesuma wei wake eno wei, i eme ibe me orofaro anisa ide abo mi efone anisa wei? Oyauma ouwa koe ma amani amani ukaku i ari i mi buna me, ouwa koe ari efone anisa wei? ");
INSERT INTO aby_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","I mede anemerabu efone anisa wei? I wau oi daiwere barukaku mi efone anisa wei? I wau oi daiwere oroue dai yawokeka orounu uwararo ibinisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Anemebake anisa? Godinu we bou ukeka mi efone anisa? Nanu wake nauawe wei. Dawa ba sara mi me. Dawa okoanaku we bou ukeka mi me. Godinu bukaro wakema eno weakubake. Dawae dai we bou ukeka miwere. ");
INSERT INTO aby_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Godinu bukaroma eno weaku, ea, Nanu fo weeka mi bokai mamaro anifike Anu daaba wabuke ma gienabu ufiro A dubuenaro anifakua, i wakema eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nanu ba wake wemaro nauawe wei. I furo yewa dooro awekaboma doreibirieka orou emua yaisinabairoe Dioni babadaido weaisa mi dawae daiwerero nono i oroue okoananaku. Nono Godinu yawokaku orofaro awoena yawokakune dai me oroue okoanaku mero daiwere nono Dioni danu adinaro waiya ukeibi i furo dawae okoanaku ari eno. ");
INSERT INTO aby_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dioni babadaido minu odoroma Godinu yawokaku wake bunawere weibaisi. Eno weibaisiba ibake emema Godinu yawokaku orofaro anifisane ukaada buna daiwere ukaisake anaisa. ");
INSERT INTO aby_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Adinaroma aare Dioni doka odorama emema Godinu we bou ukeka orounu wakeini Mosesinu darawadu wakeroma Godinu yawokeka wake we bou ukaroma ai Dioni dubuenaro fari. ");
INSERT INTO aby_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Enoba yanu arara i wake imufone ufoisaie Dioni dawae Iraida idua fari. ");
INSERT INTO aby_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aina ainama ome boboie naufeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Yesuma wei, yewa ibinisa oroue abo orou ari wei? Yewa oroue aneme orou ari wemau wei? Yewa oroue amarananaku ari weakune. Amarananakuma akaka naisaro yauraisake emenu naiyemukubake eno weaisa, buma uraisiro ya yaura ure dakaisa weaisake nono weaisa, sorara ukaisiro ya sorara uke dakaisa weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Eno weike wei, Dioni babadaido mima farinuke urunaini aduaini ise dakinuba ibake yama eno weaisa, dawa merama seidaninu imumu bobo miya eno weaisa. ");
INSERT INTO aby_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nono i Ba Eme Sini Mima farinuke buredini waini isinuba ibake yama eno imuke weaisa, Dawa uruna keuwere isinuba Dawae uruna eira mi ibake waini isinuro beforo merama ukinua weaisa. Dawae dakesi muneka orouini merama merama ukeka orounu domayeya weaisaie i Ba Eme Sini Mini Dioni emua Godinu demui waiya ukeibisi ibake i Godinu wake naukeibisake emua ereibisa orouma Godinu ukeka sineka baya eno we imukeibisa, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesuma buna ukeka keuwere moi goiro ukeibiro i goi orouma ereibisake emenu merama merama ukeka imuke mede dakeibisa ibake Yesuma emuabake wake imuna yarie. ");
INSERT INTO aby_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Eno weike wei, ya Korasani goi orouini Besaida goi orouini ya eforo weakune wei! Godinu buna ukeka keuwere ya ereibaisa. I Daira goi orouini Saidoni goi orouini emuama Godinu buna ukeka ibai efisaronae meramawere wau barufisake uka iiri okoro odaada emenu merama ukeka medifisanea wei. ");
INSERT INTO aby_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ibake Godinu kodo odo fafekuro Godima i Daira goi orouini Saidoni goi orouini fanisi dai menaku mafiakuke nono ya Korasani goi orouini ya Besaida goi orouni fanisi daiwere mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yesuma nono wei, ya Kafenamu goi orou, ya urero amuke anifone weaisa? Iro da amuke anifoisake feare dakaku inaaro anifoisaya eno wei. Godinu buna ukeka keuwere eraisaba i Sodomu goi orouma ibai efisaronae emenu merama ukeka sineka medifisaro emenu goi awoena idua ibifinea wei. ");
INSERT INTO aby_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ibake Godinu kodo odo fafekuro Godima i Sodomu goi orou fanisi dai menaku mafekuke nono ya Kafenamu goi orou yanu merama ukeka sineka mede da uisaba fanisi daiwere mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","I odoro Yesuma eno wei, Babae, Ae ureini dooini yawokaku. Ae Anu imukeka yaisina i orofa akaka iwoka daiwere oroubairo ma fe yarakuke i amarananaku ari i oroubairo Anu imukeka ma boroo yarakuro ibake we ma irauaiai ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","27","Ie Anu irau imukeka ibake eno ukakua Yesuma wei. Yesuma eno weike Danu iwoka ukeka oroubake eno wei, Nanu Babaema Danu imukeka yaisina Nabake makakuro enaenari ukakunea wei. Emema Nanu Babaenu Amara ma nuna ukaisaro Godi mane Dawa iwoka ukaku. Enaenari Godi ma nuna ukaisaro Godinu Amarama Godi iwoka ukakuke Dawama moi oroubairo Godi we ma boroo yarakuro moi orou mane Godi iwoka ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ya waiya daiwere ukaisake inimuwere erabusa wauraisake koroko sinakune orou ari, ibake Nabairo aarawero yabake ko yareka mamiaro me irauaiai ibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","nanu kobo ana baruna wauaweke Nanu imukeka uke iwoka uawe. Nanu imukae irauaiai, Na waa me miya Nabairo yanu imuka yaisina odiaweke ko yaawe wei. ");
INSERT INTO aby_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanu kobo anae inimu meba Nanu erabusaini inimu meba yanu imuka yaisina awoena Nabairo odifoisaie irauaiai ko yafekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Moi Sabadi odoro Yesuini Danu iwoka ukeka orouini konoura waiya ubarenaro fare fisii yare anaada Danu iwoka ukeka orou desini urieba ibake konoura ma roine mune wanama ma buruburu yaraada ise enereibisa. ");
INSERT INTO aby_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eno uisaro moi Ferosi orouma ekake Yesubairo eno weisa, iyanu darawaduma eno weaku, Sabadi odoro eno da uawe weakubairo Anu iwoka ukeka oroude anemebake eno ukaisa weisa. ");
INSERT INTO aby_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eno weisaro Yesuma emuabairo eno wei, Deiwidinu desini ureibibake uruna muneibi i wake kakuraisaba me wei? ");
INSERT INTO aby_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deiwidima desini ureibiba Godinu uwara ubarenaro amuike weiro i dai ofereni ode sibore sianeka mima i Godima ereibi iifawere buredi mairo Deiwidini danu naiyemukuini emuama mukake ma birabira yare isa. I buredie iifama imusu ari. I dai sosi yawokeka orou mane iseibisa, danu ubiye Godinu darawaduba ibake eno ukeibisa. Emuae eno uisaba ibake Godinu darawaduma emua unu koreka daaba dadau uke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Godinu darawadu bukaroma i dai ofereni ode sibore sianeka orouma Godinu Sabadi odoro waiya ukaada ima i Sabadi odo ma merama ukeibisa i wake ibinuro ya kakuraisaba me wei? I orouma Godinu Sabadi odo ma merama ukaada i enaenari Godinu darawadu ma merama ukeibisabaie nono Godima emuabairo darawadu ode dauia wei. ");
INSERT INTO aby_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iduaroma nono Na yabairo ibine ide daiwerero nono yanu dai sosi uwarae okoanakua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godima eno weaku, Nanu ararae yanu imukari ukekaroma nono Na arara me yama ofereni odeka. Enoba i wake iwoka uforonae i merama uke me orou wayai da wefonea wei. ");
INSERT INTO aby_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","I Ba Eme Sini Mi Dawae i Sabadi odonu ubi mi. Ibake Dawama i odo idua yawokeibakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu iroma anike i Du orounu moi sosi uwara ubarenaro amui. ");
INSERT INTO aby_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ane amuibaie wana merama mi ido yaure ibiro eri. Eriro moi orouma Yesu i dai oroubairo wayai wefisane ibake dubo waure weada eno weisa, Sabadi odoro ma wirokekae irauaiaiba me weisa? ");
INSERT INTO aby_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eno weisaro Yesuma eno wei, yanu moi abu Sabadi odoro doo eba yafawere ubarenaro isafeisaro yama ma youfoisoro amufeisaba me wei? ");
INSERT INTO aby_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yae abu mane imukaisake nono eme imukenewaa uke dakaisaya wei? Enoba i Sabadi odoro irauaiai ukekae irauba me weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eno weike i wana merama mibake eno wei, anu wana siaa weiro enaenari uiro danu wana irau sinike moi ena wana ari sini. ");
INSERT INTO aby_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","I Ferosi orouma i sosi ubarenaroma aweawero amuisake Dawa aneme aneme ma feafeisi ariya weada eno emenu emenu we makaneibisa. ");
INSERT INTO aby_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuma emenu imukeka iwoka uiba ibake emua medike iroma ani. ");
INSERT INTO aby_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aneibibaie eme keuwere Danu umuro anisaro emua yaisina ma wiroike emuabairo eno wei, moi oroubairo Nanu arama orou ma wirokakunia wake da weforo wei. ");
INSERT INTO aby_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Godinu we bou ukeka mi Isaiyama wei ibake eno ui. Isaiyama eno wei, ");
INSERT INTO aby_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nanu we mune odine waiya ukeka mi eawe. Dawae Nanu amara ubiba ibake Nanu imuka yaisina Dawabairo ibinua wei. Nanu Imumu Irau Dawabairo odaimauro Dawa i Du me imusu orounu ukeka sineka ma gienabu ufeku. ");
INSERT INTO aby_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dawa urane rarane da ufekuke dino wakeini daiwere da wefeku. ");
INSERT INTO aby_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dawa afua uke ibeka ouwa koe da ma kuufeku. I buna me oroue i afua umane ibeka ouwa koe ari eno. I oroubake da ma merama ufeku. Dawae ramefa uikiro yaraaku i inaa da ma feafeku, i buna me oroue ramefa uiki ari eno. Enoba i oroubake da ma merama ufeku. Dawae yaisina gienabu ere wefekuke irauaiai ufekuro i irau ukekama i ukeka yaisina ma berefekuke ibeifeku. ");
INSERT INTO aby_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","I Du me imusu orouma Danu ibi naufeisake Dawa nauke imukenewaa ufeisaya, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Moi orouma naisa kikori wake we me kokoro seidaninu merama imumu bobo mi Yesubairo waure fare oisaro Yesuma i mi ma wiroiro i mi wake weike danu naisa irau siniro eri. ");
INSERT INTO aby_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Enoba i orou yaisina ibai ekake emenu imuka foria uisake eno weisa, yewa miye Godinu ma wiroke mune aneka miba me weisa? ");
INSERT INTO aby_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","I Ferosi orouma ibai nauisake eno weisa, yewa mima i bokai merama imumu Biesabonu bunaro mane seidaninu merama imumu we yowerakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Eno weisaro Yesuma emenu imukeka iwoka sinike emuabake eno wei, moi gaemani orouma emenu mane uranada abanaro ma boroo yafisake urafisane ukaada merama ufeisa. Nono moi goi orou emenu emenu uranada abanaro ma boroo yareroma imusu imusu enafeisake urafeisaie emenu ibekae idua merama sifeku. Uwara demui orou emenu emenu uranada abanaro ma boroo yareroma imusu imusu enafeisake urafeisaie emenu ibekae idua merama sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","I ari enoe seidanima danu moi orou we yowefiakuie danu onami we yowenao ufeku. Enoba danu imusu abanaro ma boroo yanao ufekuro danu yawokeka buna idua merama sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yesuma eno wei, Na Biesabonu bunaroma seidaninu merama imumu we berakakuneie yanu orou emuade seidaninu merama imumu ainanu bunaroma we berakaisa wei? I ari enoroma yanu orouma ya kodo ufeisake ya meo weaisaya wefeisa wei. ");
INSERT INTO aby_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nono Godinu Imumu Iraunu bunaroma seidaninu merama imumu we berakakuneie Godima eme idua yawokaku ibai ma boroo yarakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Moi mima bunama imusu ari minu eraerabusa waira ufine aneme aneme ufeku? Dawa i bunama imusu ari minu umu wana naama uwane karifekuke nono danu eraerabusa waira ufeku. ");
INSERT INTO aby_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Enoba aina mima Na unu kore dafekuie Naini wasai ufeku. Enaenari aina mima eme moi Naini mune ku uke dakakuie eme we yowerakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Godima i orounu merama merama ukekaini merama wake weeka yaisina naufekuke imuke medifeku. Nono aina mima Godinu Imumu Iraubake merama wake wefekuie Godima da imuke medifekuro danu merama ukeka i mibairo idua ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aina mima i Ba Eme Sini Mibake merama wake wefekuie Godima naufekuke imuke medifeku. Nono aina mima Godinu Imumu Iraubake merama wake wefekuie da imuke medifekuro i merama ukeka i mi dawabairo me ibene ibene ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Irau ana warafekuie irau kai uwafeku. Merama ana warafekuie merama kai uwafeku. Moi anama irau kai uwafekuie irau anaya wefeisa. Nono moi anama merama kai uwafekuie merama anaya wefeisa. Aneme aneme ufeku enaenari weifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya waruma doreka! Yae merama oroude aneme aneme irauaiai wake wefoisa wei? Moi minu imuka imukeka wake farinubake ibake weaku wei. ");
INSERT INTO aby_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","I irau mi irauaiai wake weakuie danu imukaro ino me ibake irau wake mane weakua wei. Nono i merama mima meramawere wake weakuie danu imukaro ino daiwere ibinu ibake merama wake weakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Yesuma eno wei, yabake ba weakune. Godinu kodo odo fafekuro Godima emenu me sara wake yaisina we nauke efeku wei. I odoro Godima yanu irauaiai wakebake yabairo irauaiai ufeku. I ari eno, i odoro emenu meramawere wake yaisinabake Godima emuabairo kodo ufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Moi Mosesinu darawadu ma iwoka ukeibisa orouini Ferosi orouini emuama Yesubairo eno weisa, Sisa mi, anu buna uaro efeke A dawa ba Kerisoya wefe weisa. ");
INSERT INTO aby_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Eno weisaro Yesuma eno wei, ya meramawere uke Godinu wake nauke me orouma buna efone yodia ukaisa? Eno weike nono wei, Dionanu buna ukeka Godima ma boroo yariba nono yabake moi imusu buna ukeka da ufekuke nono i Dionanu buna ari ma boroo yafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dionama dai adua abunu boana ubarenaro ewekaini dumu buuba ibi i dawa enanarie i Ba Eme Sini Mima doo ubarenaro ewekaini dumu buuba ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","I Ninewe goi orouma Godinu kodo odoro uyafeisake yewa orou wayai wefeisa. I orouma Dionanu wake nauisake emenu merama merama ukeka imuke meisa. Dionae dai mi me. Awoena yabairo dai miwere sinike ibaada Godinu wake weakuro nauke dakaisa ibake i Ninewe goi orouma ya wayai wefeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Enoba Godinu kodo odo fafekuro Siba orofanu yawokeka aweka, emenu kuinima uyafekuke yewa orou wayai wefekua wei. Dawa adinami nauwaro Soromoni dawa we ma iwoka ukeibi wake naufine fari. Soromoni dawae dai mi me. Awoenae yabairo dai miwere sinike ibinuba ibake i odo i awekama uyafekuke ya wayai wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Seidaninu moi merama imumuma moi mi medakuke eme ibe me yao nauwa orofaro ko yafine eneibaku. ");
INSERT INTO aby_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","45","Enaada yodia ukeebe yodia ukeebe ko yare dakakuke eno weaku, nanu medineke aane uwararo owemauke iro animaua eno weaku. Eno weakuke seidaninu merama imumu ane farakuke erakubaie yawewe ure odakuro uwara ubarenaro aweawewerero irauaiai ibakuba ibake seidaninu merama imumuma anakuke seidaninu moi merama imumu seweni (7) dawa ari me, emuae dai meramawere, mune waure faraku. Enoba emua yaisina faraisake amuke idua ibaisa. Enoba i minu adina ibekae merama dai menakuroma nono awoenae seidaninu merama imumu keuwere ibaisa ibake i mi danu ibekae ba dai meramawere. Enoba yewa ibinisa orounu ibeka enaenari ufekua, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu wake weibibaie Danu amaeini naburakaini aakake Yesubairo wake wefisane enaka. ");
INSERT INTO aby_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ibake moi mima Yesubairo eno wei, Anu amaeini Anu naburakaini Abairo wake wefisane enare ibinisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Eno weiro Yesuma i mibake ma owerike eno wei, Nanu amaeini Nanu naburakade abo orouro wei? ");
INSERT INTO aby_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eno weike Danu wanama Danu iwoka ukeka oroubake wana fisi ukaada eno wei, yewa oroue Nanu amaemukuini naburakaya wei. ");
INSERT INTO aby_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aina mima Nanu urero ibinu Babae Godinu wake naukakuke enaenari ukakuie dawae Nanu nabueini arumaini Nanu amae ari enoya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","I odoro Yesuma i uwara ubarenaroma aweawero isarike kuna udiro anike yaure ibi. ");
INSERT INTO aby_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iro yauriro eme keuwere fakake Dawa enare kara uisaba ibake Yesu uyarike boudi ubarenaro amui. Boudi ubarenaro amuke yaure ibiro i orou emua kuna udiro enaka. ");
INSERT INTO aby_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Enakaro Yesuma emuabake dubo waure we ma iwoka ukaada eno wei, moi mima yobai waifine waiyaro ani. ");
INSERT INTO aby_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Anike yobai siane enereibibaie moi yobai daabaro isaka. Daabaro isakaro gasirama fakake ise me sika. ");
INSERT INTO aby_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nono moi yobai oma firifiri bobo dooro isakaro i doo aweawewereba ibake yobai sabu waraisa. ");
INSERT INTO aby_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Doo aweawewere ibake yobai sabu waraisaro nono ewekama farike yanairo iini funanakuba ibake boke ure me sika. ");
INSERT INTO aby_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nono moi yobaie sinisini bobo ou ubarenaro isakake irauaiai waraisakema nono ouwereba ibake onu eriro kaibai uwane dauisa. ");
INSERT INTO aby_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","9","Nono moi yobai irau dooro isakake irauaiai warakenewaa uke amuisake kaibai keuwere uwaka. Kai demuima kaibai wani aderedi (100) uwani. Nono moi kai demuima kaibai sikisidi (60) uwani. Nono moi kai demuima kaibai dedi (30) uwania weike nono wei, ya ome bobo orouronae Nanu wake naukenewaa uawe eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuma i wake we me siniro Danu iwoka ukeka orouma Yesubairo fakake eno weisa, anemebake emuabairo dubo waure weaku weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eno weisaro Yesuma emuabake eno wei, Godinu ararae ya Danu ure yawokeka fe wake naufoke iwoka ufone ukakuke nono Dawa arara me i orou ure yawokeka fe wake naunao ufeisa ibake emuabairo dubo waure weeka wake mane ma boroo yarakuro naukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nanu wake daiwere naukaisa oroubake moi naukeka mafiakuke nono i demuinaku naukaisa orounu dai menaku naukeka mareke mufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Enoba emuabairo dubo waure weakune. Ibake i orouma eraisake nono ba bai ere dakaisa. Naukekae naukaisake nono i wakenu ubi ma nuna ukaisa. ");
INSERT INTO aby_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiyama adinaro eno wei ibake i ari eno enaenari uka. Isaiyama eno wei, yae ido naukenewaa ufoisakema nono i wakenu ubiye ma nuna ufoisaya wei. Yae ido erenewaa ufoisakema nono ba bai da efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yewa orounu imukae imukenewaa me. Emenu omeye nauke dakaisa. Emenu naisae nauka ariari ukaku. Enoba ere dakaisake nauke dakaisake imukaini ma nuna ukaisake Nabairo owere dakaisaba emua ibake ma wiroke dakakuniaya wei. Eno weike wei, eno da ufoisaie ma wiromiaua, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesuma i wake weike emuabake nono wei, yae erenewaa ukaisake naukenewaa ukaisa ibake Godima ya we ma irauaiai ukakuro irauaiai ibinisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yesuma wei, yabake ba wake wemaro nauawe eno wei. Adinami nauwaro Godinu we bou ukeka orouini Danu irau orou keuwere yanu aneme aneme eraisa ibai efisane weisakema nono emua ere dauisa. Enoba emenu ararae yanu aneme aneme naukaisa ibai naufisane uisakema nono emua nauke da uisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","I yobai siane enaraku minu wakenu ubi naukenewaa uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I wakenu ubiye eno, aina mima Godinu yawokaku wake naukada ma nuna ukakuie seidanima farakuke i wake i minu imuka ubarenaroma mareke munaku. Ie i daabaro isaka yobai ari. ");
INSERT INTO aby_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Nono aina mima Godinu wake naukakuke rooro ukakuke danu naukekae daiwere me ibake i funaku siani iini ari, ibake moi odoro naukakuro Godinu wakebake waa uyareka farakuro i mima Godinu wake sabu medaku. Ie i oma duboro isaka yobai ari. ");
INSERT INTO aby_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Enoba aina mima Godinu wake naukada danu arara imusu imusu imukeka danu ararae eraerabusa daiwere munekabake we imukakuie i wakenu daaba dadau ukakuro i wake kai ba sine dakaku. I arie i ou ubarenaro isaka yobai ari. ");
INSERT INTO aby_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nono aina mima Godinu wake naukada iwoka ukakuie dawa Godinu waiya ukaku. Moi mima Godinu waiya daiwere ukakuie wani aderedi (100) ari ukaku. Nono aina mima Godinu waiya daiyaisa ukakuie sikisidi (60) ari ukaku. Nono moi mima Godinu waiya dai menaku ukakuie dedi (30) ari ukakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuma emuabake moi dubo waure weada eno wei, Godinu yawokaku odo yewa wake ari eno wei. Moi mima irau uidi kaibai danu waiyaro wawe odike ani. ");
INSERT INTO aby_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aniro dumuro eme nauka aine ibisabaie wasai mima farike awai yobai i irau uidi kaibai wawi iro awaini wawe odike ani. ");
INSERT INTO aby_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aniro dubuenaro i uidi warakada i awaini demuiro warake amuisa. ");
INSERT INTO aby_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Enoba i waiya ukeka orouma uwara ubi mibairo fakake eno weisa, dai mi, ama irau kaibai wawiba me weisake weisa, aneme aneme awai keuwere warakaisarie weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eno weisaro i mima eno wei, moi mima naini wasai uike merama awai yobai wawe odia wei. Eno weiro i waiya ukeka orouma dawabake eno weisa, i awai maifeisiba me weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Eno weisaro wei, da maifoke moi uidini maminao ufoisaba uidini awaini demuiro warafisake ayo ufeisaie i uidi muneka oroubake eno wemau, i awaiko mamiaweke inaaro yafone ukaada demuiro kobokobo uke inaaro yaewe wemaua wei. Nono dubuenaro i uidi ma doroo yaeweke nanu uruna odeka uwara ubarenaro odiawe wemaua wei. Yesuma i dubo waure wei wake i ari eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuma moi dubo waure weike emuabake eno wei, Godinu ure yawokekae okoanaku masida ana kai yo ari. Moi mima i ana kai yo demuinaku munike danu waiyaro wawi. ");
INSERT INTO aby_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I ana kai yoe daiwere mero i ana kai yoe okoakorowainaku. I ana kai warafekuie ana daiwere sifekuba i gasira emenu mowa i ana iwarabairo ukeifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuma emuabake moi dubo waure wei wake eno wei, Godinu ure yawokekae yewa wake ari, moi aweka unama wawareka iraa yisidi dai menaku munike dai farauwa ubarenaro odiro yisidima i farauwa yaisina ma wawaria wei. ");
INSERT INTO aby_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuma yewa wake dubo waure i ku uke ibisa oroubake eno wei. Danu wake aruro we dakeibike Danu wake yaisinae dubo waure weibi. ");
INSERT INTO aby_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Godinu we bou ui mi Isaiyama adinaro weiba ibake Yesuma i ari eno enaenari weibi. Isaiyama eno wei, na dubo waure wemau wei. I doo ubu ui odoroma fe yareka wake we ma boroo yamaua, Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuma boudiroma isarike i ku uke ibisa orou idua medirieke uwara ubarenaro amui. Uwara ubarenaro amuiro Danu iwoka ukeka orouma Dawabairo fakake eno weisa, i waiyaro awai waraisa, i wakenu ubi we ma boroo yaaro iya iwoka sife weisa. ");
INSERT INTO aby_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","38","Eno weisaro Yesuma emuabake ma owerike eno wei, i irau yobai wawaku miye i Ba Eme Sini Miro nono i waiyae yewa orofa akaka idua. Enoba i irau yobaiye Godinu yawokaku orofa ibinisa orouro nono i merama yobaie seidaninu orou. ");
INSERT INTO aby_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Enoba i merama yobai wawaku wasai miye seidani. I ayo ureka odoe yewa ureini doo me sifeku odo idua. Iduaba i waiya ma diwakeka oroue Godinu aneru. ");
INSERT INTO aby_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Enoe i awai mune inaaro yaraisa i ari i ureini doo me sifeku odoro i merama oroue enaenari ufeisa. ");
INSERT INTO aby_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","I Ba Eme Sini Mima Danu aneru we odaifekuro isare aafeisake Danu orofaro i eme uke irukaisa orouini merama orouini yaisina mufeisake i feare me inaaro siafeisaro iro emema emenu oferi ukeifekuro nio ake fagigi yaraada ii wefeisa. ");
INSERT INTO aby_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","I odoro Godinu wake naukaisa orou, i irau orouma Godinu yawokaku orofaro eweka edoro ari edoro sifeisa. Enoya ya ome bobo orou yae naukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuma eno wei, Godinu ure yawokekae yewa wake ari. Moi mima moi minu waiyaro fema oi daiwere doo daunike eri. I oi daune erike nono dooro karise odike nono owere ani. Goiro ane farike danu eraerabusa yaisina make oi munike nono i oi daiwere ibi doo feka oima maike munia wei. ");
INSERT INTO aby_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesuma eno wei, Godinu ure yawokekae yewa wake ari weike wei, moi sidowa bobo mima oi kaibairo, danu ibiye fera, i dawa bidi ari enoba yodia uke ani. ");
INSERT INTO aby_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yodia ukeebe yodia ukeebe moi fera, danu dawanae daiwere fou uri. Fou urike ane danu eraerabusa yaisina make oi munike owerike i fera bidi oima make munia wei. ");
INSERT INTO aby_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Yesuma eno wei, Godinu ure yawokakuie yewa wake ariya eno wei. Moi orouma emenu iwame kunaro siakake adua abu imusu imusu yaisina mukaro iwame wake fariba i orouma kuna udiro ma youre amuisa. Iwame kuna udiro amuiro i orouma yaure ibaada i irau adua abu bosearo youkake i merama adua abu mune siaka. ");
INSERT INTO aby_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Yewa orofa akaka dubuena odo me sifekuro enaenari ufeku. Godinu aneruma enaenari ufeisa. Godinu aneruma isare aafeisake i meramawere orou i irau oroubairoma mufeisake feare me inaaro siafeisaro iro emenu nio ake fagigi yaraada ii wefeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuma emuabake eno wei, i wake yaisina naukaisa? Eno weibaie naukaisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naukaisia weisaro Yesuma emuabake eno wei, Mosesinu darawadu sisa mima Godinu ure yawokaku wake uke iwoka ukakuie i eraerabusa, adinaini awoena eraerabusa, ma boroo yafeku enaenari Mosesinu darawadu sisa mima danu adina darawadu wakeini Nanu awoena wakeini we ma iwoka ukakua wei. ");
INSERT INTO aby_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuma i dubo waure we me sinike iroma ani. ");
INSERT INTO aby_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ane Danu orofaro farike i Du orounu moi sosi uwara ubarenaro amuike we ma iwoka ui. We ma iwoka uiro i orouma imuka foria uisake eno weisa, yewa mi Danu iwoka daiwere aboro muninuke Danu buna ukeka aneme aneme ukaku weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dawa yeka uwara ma enareka minu amaraba me arie weisa? Meride Danu amaeba me arie weisa? Deimisini Diosefuini Saimonini Diudiasini emuade Danu naburakaba me arie weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Danu aruaruma iyabairo ibinisaba ba me weisa? Yewa mi aneme aneme dai mi weisa? Danu iwoka aboro muninu weisa? ");
INSERT INTO aby_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eno weisake Dawabake dino uisaro Yesuma emuabake eno wei, moi we bou ukeka minu goi orouini danu orofaro ibaisa orouini emuama dawa iifa uke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eno ukaisaro i orouma Dawa imuke dakaisa ibake emuabairo buna ukeka uke dakakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Erodi, dawae gaemani dai mi. Dawa Yesunu buna ukeka wake nauiba ibake danu waiya ukeka oroubake eno wei, i miye Dioni babadaido mi. Dawa fearike uyari ibake i buna ukekae ibake i ari eno ukakua wei. ");
INSERT INTO aby_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Adinaro Erodima Dioni ana ebaro odi. Erodima danu nabue Firifunu aweka Erodiasi waira uke muni. ");
INSERT INTO aby_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eno uiro Dionima dawabake wei, anu nabuenu aweka muneka i ba mewereya media eno wei. ");
INSERT INTO aby_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eno weiro Firifunu aweka Erodiasima dino uike areare weibi ibake Erodima Dioni ana ebaro odike ma feafine wei. Eno weiro i orouma yaisina Dioni Godinu we bou ukeka miya we imuisa ibake Erodima ia iyarike Dioni ma feare daui. ");
INSERT INTO aby_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dubuenaro Erodinu doka odo fariro banau daiwere uiro eme keuwere banau ifisane faka. Ido fakaro uruna iseibisabaie Erodiasinu aruma emenu ibooro yaura ureibiro Erodima imuka ubarenaro rooro ui. ");
INSERT INTO aby_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rooro uike i orou naukeibisaro i arumabake eno wei, anemerabu mufane wefakuie abake mamauanea eno wake bunawere wei. ");
INSERT INTO aby_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eno weiro i aruma danu amaema wei ibake i arumama Erodibake eno wei, Dioni babadaido ukeka minu bokaifu naberoro odiake maina wei. ");
INSERT INTO aby_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eno weibaie Erodima imuka merama imuike. Nono bunawere we bou uiro danu banau iseibisa orou nauisa ibake Erodima enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dawama weiro Danu orouma ana ebaro anisake Dioni faya kuukake bokaifu naberoro oisa. ");
INSERT INTO aby_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eno uisake ane fakake i arumabairo makaro i arumama munike ane danu amaebairo mairo eri. ");
INSERT INTO aby_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eno uisaro Dioninu iwoka ukeka orouma ane ana ebaro fakake Dioninu ofe mukake ane dooro daune oisa. Dooro daune oisake Yesubairo anisake i uisabai yaisina weisaro naui. ");
INSERT INTO aby_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuma i wake ido nauike i orofa ido medike boudi ubarenaro amuike eme ibe me orofaro ani. Aniro eme keuwere Dawa moi orofaro anibai nauisake i goi goiroma udiro eneebe Dawabairo faka. ");
INSERT INTO aby_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Fakaro Yesuma kuna ekabokenaro farike gibudiro enarike i orou yaisina eraada imukari ui. Imukari urieba ibake emenu ofe arama uke ibisa orou ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dumu sineibiro Yesunu iwoka ukeka orouma Dawabairo fakake eno weisa, yewa orofae eme ibe me orofaya weisa. Nono dumu sinao ufekua i orou wearo yaisina goi goiro anifisake uruna oima make mune ifisa weisa. ");
INSERT INTO aby_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Eno weisaro Yesuma ma owerike eno wei, anemebake anifeisa weike wei, emuabake uruna mayakawero ifisa wei. ");
INSERT INTO aby_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eno weiro emuama eno weisa, iyabairo buredi faini (5) adua abu kai raarayai i mane ibinisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eno weisaro Yesuma waure aarawe wei. ");
INSERT INTO aby_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Waure aarawe weike weiro i orou yaisina bagibagi koe fafaro yauka. Yaukaro Yesuma i buredi faini (5) adua abu kai raarayaini munike urero eraada Godi we ma irauaiai uike i buredi ma birabira yarike Danu iwoka ukeka oroubairo mariero emuama i kuku uke ibisa oroubairo naka naka uisaro isa. ");
INSERT INTO aby_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","I orou yaisina isaro boana urie. Ise me sikaro iuwa iuwabai mukake bosearo youkaro bosea duwero (12) wake faka. ");
INSERT INTO aby_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eme keuwere fai dausinini (5,000) awekabo aruma amaraini i uruna idua isa. ");
INSERT INTO aby_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuma weiro Danu iwoka ukeka orou emuako boudiro amuisake ekara enaro siraa yafisane uisa. Siraa yafisane uisaro Yesuma i kuku uke ibisa oroubairo weiro nauisake anisa. ");
INSERT INTO aby_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Anisaro Yesu Danu mane guriguri ufine oraara oko kairo amuke ani. Amuke anike dumu siniro Danu mane iro ibi. ");
INSERT INTO aby_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yesu iro ibibaie i boudi kuna abanaro fari. Fariro oyau fariro kuna ufe uyariro i orou ekabokenaro ane dauisa. Wai awanakuro Yesuma kuna adua duboro enaenare emuabairo fari. ");
INSERT INTO aby_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","26","Yesu emuabairo faribaie Danu iwoka ukeka orouma Dawa ekake ia iyarada arua daiwere weisake weisa, ie imumua weisa. ");
INSERT INTO aby_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Eno weisabaie Yesuma emuabake eno wei, imuka ara uaweke yewae Naya, ia da iyawe wei. ");
INSERT INTO aby_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eno weiro Fidama wei, Dai Waria Mi, A dawa ba Yesubaie wearo kuna adua duboro Abairo aama wei. ");
INSERT INTO aby_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eno weiro Yesuma aara wei. Weibaie Fidama boudiroma aduaro isarike Yesubairo ani. ");
INSERT INTO aby_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aneibibaie oyau fariro kuna ufe uyariro Fidama ibai erike ia iyarada adua ubarenaro imu i. Imu isaada daiwere wei, Dai Waria Mi, na ma wiroa wei. ");
INSERT INTO aby_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Weiro Yesuma Fidanu wanaro sabu munike eno wei, ae imukeka dai menaku miya wei! Anemebake imuke dakinu wei! ");
INSERT INTO aby_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eno weiro boudi ubarenaro amuisiro oyau ido me sini. ");
INSERT INTO aby_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Enoba i boudi ubarenaro yaure ibisa orouma Yesubairo guriguri ukaada eno weisa, Ae Godinu ba Amaraya weisa. ");
INSERT INTO aby_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kuna ekabokenaro siraa yakake Genesareda orofaro ane enaka. ");
INSERT INTO aby_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Enakaro i orofa orouma Yesu iwoka uisake emenu arama uke ibisa orou Dawabairo waure fare odirieka. ");
INSERT INTO aby_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Odiriekaro i arama uke ibisa orouma eno weisa, Anu wau fifiro ure burifene weaisia weisa. Eno weisake i orouma Yesunu wau fifiro ure burisake idua wiroisa. ");
INSERT INTO aby_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Moi Ferosi orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Derusaremu goiroma Yesubairo ane fakake eno weisa, Anu iwoka ukeka orouma iyanu bisara orounu ukeka wake nauke dakaisa. Uruna isaisake wana wanadu uke dakaisaya eno weisa. Anemebake eno ukaisa? ");
INSERT INTO aby_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eno weisaro Yesuma emuabake ma owerike eno wei, yadeie anemebake ya bisara ukeka wake mane naukenewaa ukaisake nono Godinu darawadu wake nauke dakaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Godinu darawaduma eno weaku, yanu amae babaenu wakeini ukekaini muneibiaweke yawokeibiawe eno weakua wei. Aina mima danu amae babaebake wake merama wefekuie dawa ure bauawe, Godinu darawaduma eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Nono yama eno weaisa, moi mima danu me makeka Godibairo makakuba danu amae babae da mafekuie danu amae babae iifa da uke yafiakuie iduaya weaisa. Eno ukaisaba ibake yanu bisara ukeka i mane ma uyaraisake Godinu darawadu wakema weaku yanu amae babae iifa uawe weakuroma i wake mune imuke medaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","Eno weike nono wei, ya meomao oroua wei! Adinaro Isaiyama yabake ba we bou ukaada eno wei, Godinu wei wakeye i ari eno weaku, yewa oroue Nabake bebekuroma weaisake nono emenu imukama Na imuke dakaisake Nabairo guriguri me sara ukaisaya eno weaku. Nono emenu imukekae Godinu imukekaya eno weada we ma iwoka ukaisa, Isaiyama yabake wea, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuma weiro i ku siane ibisa orou Dawabairo faka. Fakaro Yesuma wei, Nanu wake nauaweke uke iwoka uawe wei. ");
INSERT INTO aby_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","I uruna aneme aneme moi minu boana ubarenaro anifeisaie ima i mi da ma merama ufeisa. Aneme aneme imuka ubarenaroma amufeisaro bebekuma wefekuie ima i mi ma merama ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Enoba danu iwoka ukeka orouma Dawabairo fakake eno weisa, i Ferosi orouma Anu wenu wakebake dino ukisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eno weisaro Yesuma wei, Nanu Babaenu wawe me yobai emua yaisina Dawa ma dorodoro yafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I Ferosi oroubake da imuawe wei. I naisa kikori bobo orouma moi naisa kikori bobo orounu wanaro mamifeisake waure anifeisaie emua yaisina kafururo isafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eno weiro Fidama Yesubake wei, i dubo waure wenu wakenu ubi wearo naufe wei. ");
INSERT INTO aby_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Eno weiro Yesuma wei, ya oroue imuke meba ibake yewa wake ma nuna ukaisaya wei? ");
INSERT INTO aby_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","I wakenu ubiye eno, uruna yaisina moi minu desini duraro anakuke nono wisi akeka orofaro faraku wei. ");
INSERT INTO aby_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Imukaroma imukeka amukakuro bebekuma weaku wakema i mi ma merama ukakua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Imukaroma merama imukeka keuwere amukaisa. Eme ma fearekaini moi minu aruma aweka enare odeka imukaini waira ukeka imukaini meomao wayai weeka imukaini amukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Moi mibake merama wake weeka imukeka amukaku. I amukaisa imukae i mi ma merama ukaisa. Yanu wana wanadu uke dakaisake uruna isaisa i bisarae moi orou ma merama uke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu iroma anike Daira goini Saidoni goiro fari. ");
INSERT INTO aby_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iro fariro moi Keinani goi awekama Yesubairo farike daiwere eno wei, Dai Waria Mi, nabake imukari uina wei. Eno weike wei, moi seidaninu merama imumuma nanu arumanu imuka ubarenaro rewoke ibaada merama ukakua weike wei, Deiwidinu amara na unu koina wei. ");
INSERT INTO aby_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eno weiro Yesuma dawabake moko wake ma owerike we da ui. Eno uiro Danu iwoka ukeka orouma fakake eno weisa, i aweka iyabairo wake daiwere weakua wearo anifi weisa. ");
INSERT INTO aby_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eno weisaro Yesuma eno wei, Godima Na i amarananaku ari i Isaraera oroubairo we odaikaraya wei. I oroue fe yareka mamoe abu ari ibake emuabairo mane Na we odaikaraya wei. ");
INSERT INTO aby_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eno weiro i awekama farike Yesunu umu udiro ifoma kodudu yanakada eno wei, Dai Waria Mi, na unu koina wei. ");
INSERT INTO aby_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eno weiro Yesuma dawabake eno wei, i amarananakunu uruna mumake kuasiribake siamauie ba meya wei. I amarananakue i Isaraera orou ari nono i kuasirie i Du me imusu orou ariba eno da umaua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Eno weiro i awekama wei, Dai Waria Mi ba weakua weike nono wei, I kuasirima emenu orounu isareka uruna ifurubai isaisa wei. ");
INSERT INTO aby_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eno weiro Yesuma dawabake eno wei, yewa aweka, anu imukekae daiwereya wei. Enoba anu wenu enaenari ufekua wei. Eno weiro i awekanu aruma ido wiroi. ");
INSERT INTO aby_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu iroma ani. Anaada Gareri kuna udiro eneebe oraara oko kairo amuke ani. Amuke ane farike yauri. ");
INSERT INTO aby_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","31","Yauriro eme keuwere Dawabairo waure amuke faka. Emenu umu beobeo bobo orouini umu wana daba mamirie orouini naisa kikori bobo orouini wake we me koko orouini moi orou keuwere waure fakake Yesunu umu udiro odiriekaro Yesuma emua yaisina ma wiromirie. Eno uiro i wake we me orouma wake weisake i umu wana daba mamirie orouma umu wana irau siniro anisake i umu beobeo bobo orouma gienabu uiro anisake naisa kikori bobo orouma ekake eno uisa. I orou yaisina eno uisaro i ku uke ibisa orouma imuka foria ukaada i Isaraera orounu Godi Danu ibi we ma daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuma weiro Danu iwoka ukeka orouma Dawabairo fakaro eno wei, yewa orouma eweka odo buuba Nabairo ibaada uruna ise dakaisaba emuabake imukari ukakuniaya wei. Emua odaimiauro anifeisaie daabaro desinima feanao ufeisa ibake emua da odaimiaua wei. ");
INSERT INTO aby_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eno weiro Danu iwoka ukeka orouma eno weisa, yewae yao orofaro aboro uruna mufeisike mafiakikiro i eme yaisina uruna ifeisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eno weisaro Yesuma emuabake eno wei, buredi abea yabairo ibinu wei? Eno weiro Danu iwoka ukeka orouma eno weisa, buredi sewenini (7) adua abu daimenaku weisa. ");
INSERT INTO aby_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Eno weisaro Yesuma eno wei, i orou yaisina dooro weawero yaufisa weiro yaukaro buredini adua abuini munike Godibairo we ma irauaiai ui. We me sinike buredini adua abuini ma birabira yarike Danu iwoka ukeka oroubairo mariero mukake i kuku uke ibisa oroubairo marieka. ");
INSERT INTO aby_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mariekaro mune isake boana urie. Ise soakaro uruna iuwa iuwabai mukake bosearo youkaro bosea seweni (7) wake faka. ");
INSERT INTO aby_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eme keuwere yaisina fo dausinini (4,000) awekaboini emenu amarananakuini emua yaisina i uruna isa. ");
INSERT INTO aby_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuma weiro i kuku uke ibisa orou idua anisa. Anisaro Yesu boudi ubarenaro amuike siraa yare Magadani oroforo ani. ");
INSERT INTO aby_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Moi Ferosi orouini Sadusi orouini emuama Yesu uke iruke efisane Dawabairo fakake eno weisa, Anu buna ukeka uaro urero ufiro efe weisa. ");
INSERT INTO aby_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Eno weisaro Yesuma emuabake eno wei, dumudumu sinaada gogorua ubereibakuro emema eraisake wairo kowaa enafekua weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nono wai urakuro duba ure eraisake awoenae obi isafekua weaisaya wei. I urero ou eraisake ya iwoka ukenewaa ukaisade nono Godinu awoena ukaku ibai ya nuna ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yewa meramawere uke Godinu wake nauke dakaisa orouma buna ukeka efone weaisaro moi buna ereka yabake da mafiakuro Godima Dionabairo uibai mane iwoka ukaisaya wei. Eno weike emua medirieke ani. ");
INSERT INTO aby_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kuna ekabokenaro siraa yare ane enakake Yesu Danu iwoka ukeka orouma buredi imuke da uisake mune da uisa. ");
INSERT INTO aby_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mune da uisaro Yesuma eno wei, Ferosi orouini Sadusi orounu wakeye wawareka iraa yisidi ariya wei. Weike wei, wake wefeisaie daiwere ufekuro emema naufeisaba eforo weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eno weiro Danu iwoka ukeka orouma i wakenu ubi emenu emenu we makanada eno weisa, iyama buredi mune dakisi ibake eno wenua weisa. ");
INSERT INTO aby_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Eno weisaro Yesuma emenu weaisa wake iwoka sinaada emuabake eno wei, ya dai menaku naukaisa oroua wei. ");
INSERT INTO aby_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Eno weike nono wei, anemebake nuna ukaisa wei? Adinaisa buredi fai (5) ma birabira yarero eme fai dausini (5,000) isaro iuwabai bosea abea youisa? I imuke dakaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nono buredi seweni (7) ma birabira yarero eme fou dausini (4,000) isaro iuwabai bosea abea youisa? ");
INSERT INTO aby_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I imuke dakaisa? Na i buredibake we daunero anemebake nuna ukaisa? I Ferosi orouini Sadusi orounu ure wawareka iraa yisidi eforo weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eno weike i Ferosi orouini Sadusi orounu we ma iwoka ukekabake weiro iwoka uisa. ");
INSERT INTO aby_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nono dubuenaro Yesuma Sesaria Firifai orofaro ane fari. Iro ane farike Danu iwoka ukeka oroubake eno wei, emema i Ba Eme Sini Mibake ainadei weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eno weiro Danu iwoka ukeka orouma ma owekake Yesubake eno weisa, moi orouma Ae Dioni babadaido mi fearikema nono uyari miya weaisaya weisa. Nono moi orouma Ae i adinaro ibi we bou ukeka mi Iraida weaisaya weisa. Nono moi orouma Ae i adinaro ibi we bou ukeka mi Derimaiyaba moi we bou ukeka mi ari weaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eno weisaro Yesuma emuabake eno wei, nono yadeie Nabake ainadei weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Eno weiro Saimoni Fidama ma owerike Yesubake eno wei, Ae Godinu Mesaia. Ae i me ibinu Godinu Amaraya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eno weiro Yesuma ma owerike eno wei, Saimoni, Dionanu amara, Godima a we ma irauaiai ukinua eno wei. Moi mima i moko wake abake we dakinuro Nanu urero ibinu Babaema i wake abairo we ma boroo yarinuro wenua wei. ");
INSERT INTO aby_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eno weike wei, Fida Nanu wake naua wei. Ae Fida. Anu ibinu ubiye oma. Nono i oma duboro ku ukeibada Nanu wake naukeka orou i oma duboro odimake ma enamiaro fearekanu bunama ya i aine wai ure yareibaku inaaro da waure anifiakuro ya me ibene ibene ibeifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Abake i ure yawokaku widu kai ari mamaanero ainanu ukeka aneme aneme uwane karifakuro dawabairo ibifeku enaenari urero uwane karifekuro dawabairo ibifekua wei. Nono ainanu aneme aneme ukeka yaisina woromifakuke mune imusu odifaku enaenari urero woromifekuke mune imusu odifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesuma eno weike nono bunawere wakeroma eno wei, Nae Keriso i Mesaiaya weakune ibai moi oroubairo eno da weawe wei. ");
INSERT INTO aby_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","I odoro Yesuma Danu iwoka ukeka oroubairo Danu feafeku ibai we ma iwoka urie. We ma iwoka ukaada eno yarie, Dawa Derusaremu goiro ane ibifekuro i Du orouini bisara orouini dai ofereni ode sibore sianeka orouini i Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Dawa ure yanake ufisaro oferi daiwere waufike feafike nono odo buuba me sifiro Yesu nono uyafekua eno we ma iwoka urie. ");
INSERT INTO aby_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eno we ma iwoka uriero Fidama Yesu mune imusu odike we iifa ukaada eno wei, Dai Waria Mi, nanu ararae Godima i orounu merama imuka mune medifiro Abake eno da ufisane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Eno weiro Yesuma ma owerike Fidabake eno wei, seidani, anu imukekae Nanu imukeka dadau ufane ukakua Nabairoma eka ania weike nono wei, ae Godinu imukeka imuke mero emenu imukeka imukada weakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesuma Danu iwoka ukeka oroubake eno wei, aina mima Nanu umuro aafine wefekuie danu arara ukeka yaisina medifike irau ukeka korosi ari mufike i fearekabake iya da iyafike dawa feafine wefekuie Nanu umuro aafi wei. ");
INSERT INTO aby_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nono aina mima danu me ibeka mane imukenewaa ufekuie dawa feafekuke Nabairo me ibene ibene da ibifekua eno wei. Nono aina mima danu me ibekabake imukenewaa dafekuke Nabake feafekuie dawae Naini me ibene ibene ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nono moi mima yewa orofa akakanu eraerabusa yaisina mufekuroma nono danu me ibeka imumuma i merama orofaro ugo ufekuie irau meya eno wei. Eno ufekuie danu imumu aneme aneme oima make mufeku wei? ");
INSERT INTO aby_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","I Ba Eme Sini Mini Danu aneruini emua Danu Babaenu bunaini arakekawere fafekuie eme yaisina aneme aneme ukaisa ibai emuabake moko mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yesuma nono wei, yabake ba wake wemaro nauawe wei, moi yewado enare ibinisa orouma da feare me sifeisaro i Ba Eme Sini Mima Danu yawokaku orofaro fafekuro efeisakema ai dubuenaro feafeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","I odo sikisi (6) me siniro Yesuma Fidaini Deimisini danu nabue Dionini emenu mane we murieke guriguri ufisane dai oraara okoro amuke anisa. ");
INSERT INTO aby_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iro amuke ane fakake emenu enare ibisa iboo naisaro Yesu Danu iboo naisa imusu ui. Danu iboo naisae eweka naisa ari ui. Nono Danu waue edoroini ou ari inanakeo ui. ");
INSERT INTO aby_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eno uiro Mosesini Iraidaini emuama Yesubairo me ari uke fakike wake wake weibisi. ");
INSERT INTO aby_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Enoba Fidama Yesubake eno wei, Dai Waria Mi, iyanu ewado ibinisiie irauaiaiya wei. Anu arara nama okoa uwarananaku kai buuba umauba me wei, moi Anu, moi Mosesinu, moi Iraidanu, Anu arara i uwarananaku umane wefakuie ma enamaua wei. ");
INSERT INTO aby_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eno weibaie ena edorowere ouma emua ma yaariro ou ubarenaroma wake isare eno aarike wei, yewae Nanu Amara ubiya wei. Nanu imuka yaisina Dawabairo ibinua Danu wake naukeibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Godima eno weiro Yesunu iwoka ukeka orouma i wake nauisake dooro iboo yanakada ia sika. ");
INSERT INTO aby_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eno uisaro Yesuma emuabairo farike emua ure burisada eno wei, uyaeweke ia da siawe wei. ");
INSERT INTO aby_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eno weiro emenu naisa foraisake ekabaie moi miyai iro mero Yesu mane idua enare ibiro eka. ");
INSERT INTO aby_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","I oraara okoroma isare aarada Yesuma emuabairo bunawere wakeroma eno wei, yewa kubekube ari erisa ibai moi oroubairo da weforo i Ba Eme Sini Mi feafekuke uyafekuie idua wefoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesuma eno weiro Danu iwoka ukeka orouma eno weisa, i darawadu we ma iwoka ukeibisa orouma Iraida dawako fafeku eno anemebake weaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Eno weisaro Yesuma eno wei, i dawa ba weaisaya wei, Iraida dawako farike ibaada i yaisina uke bou bou ukeibia wei. ");
INSERT INTO aby_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eno weike wei, Nanu wake wemaro nauawe wei. Iraida dawa fariro emema dawa ma nuna uisake dawabake meramawere uke yakaya wei. Enaenari i Ba Eme Sini Mibake meramawere uke yafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eno weiro ibake Danu iwoka ukeka orouma Dawa Dioni Babadaido mibake weakua eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Yesuini Danu iwoka ukeka eme una buuba Fidaini Deimisini Dionini i ku uke ibisa oroubairo isare aare fakaro moi mima Yesubairo farike ifoma kodudu yanakada eno wei, Dai Waria Mi, nanu amaranakubake imukari ua eno wei. Nanu amara yanake kureibakua wei. Moi furo yanake kuurakuke inaaroma aduaroma odo keuwere isareibakua eno wei. Eno ukaada oferi daiwere waurakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nanu amara Anu iwoka ukeka oroubairo waure ainero ma wirofisane wenebaie ma wiroke dakisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eno weiro Yesuma Danu iwoka ukeka oroubake eno wei, ya imukenewaa uke me oroua weike eno wei, yabairo odo abea ibimauro yanu imuka ubarenaro imukenewaa ufoisa wei? Eno weike nono wei, i amaranaku waure aara weiro waure ane Yesubairo fari. ");
INSERT INTO aby_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Fariro Yesuma i seidaninu merama imumubake wake bunawere weiro seidaninu merama imumuma i amaranaku medike isare aniro i amaranaku ido wiroi. ");
INSERT INTO aby_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nono dubuenaro Danu iwoka ukeka orouma emenu mane Yesubairo fakake eno weisa, i seidaninu merama imumu anemebake we berake dakisi weisa? ");
INSERT INTO aby_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Eno weisaro Yesuma eno wei, yanu imukeka dai menaku ibake we berake dakisaya wei. Yabake ba wake wemaro nauawe wei. Yanu imukekae dai menaku masida ana kai arie yeka oraarabake eno wefoisa, uyake ekararo ania wefoisaie enaenari ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nono uruna kau ukaada Godibairo guriguri ufoisaie yewa seidaninu merama imumu ari we ma berafoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Dubuenaro Gareri orofaro ibeibisabaie Yesuma emuabake eno wei, i Ba Eme Sini Mi moi orounu wanaro mame odifeisaro Dawa ufeisaro feafekuke odo buuba me sifekuro nono uyafekua wei. Eno weiro ibake Danu iwoka ukeka orou imukari daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuini Danu iwoka ukeka orouini Kafenamu goiro faka. Iro fakaro i Du orounu dai sosi dakesi muneka mima Fidabairo farike eno wei, anu sisa mi dai sosibake dakesi oi odakuba me wei? ");
INSERT INTO aby_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Eno weiro Fidama euwa wei, Dawa dai sosibake oi odakua wei. Nono dubuenaro Fidama uwara ubarenaro amuke fariro Yesu Dawako eno wei, Saimoni, aneme aneme imukaku wei? ");
INSERT INTO aby_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eno weike wei, i dai kini orouma abo oroubairo dakesi oi munaisa wei? Emenu daburakabairoba ba moi oroubairo munaisa wei? Aneme imukaku wei? Eno weiro Fidama ma owerike eno wei, moi oroubairo munaisa wei. Eno weiro Yesuma wei, danu daburakae dakesi oi ode dakaada me enaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nono i dai sosinu dakesi oi muneka orouma iyabake dino da ufeisaie kunaro aniaweke adua abu kimaima adua abanaro siaa wei. Siaake i bokai adua abu muake danu wake ebaro oi kaibai efakuie aini Naini uwanu dai sosi dakesi oi idua mua wei. Iduaya muake i dakesi oi munaisa oroubairo maa wei. ");
INSERT INTO aby_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Moi odo Yesunu iwoka ukeka orouma Dawabairo fakake eno weisa, ure yawokaku orofaro iyanu ibinisi furo abo mima iro daiwere sifeku weisa? ");
INSERT INTO aby_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","4","Eno weisaro Yesuma weiro moi amaranaku Dawabairo waure fare oisa. Waure fare oisaro Yesuma i amaranaku munike emenu ku ubarenaro ma yaure odike eno wei, yabake ba wake wemaro nauawe wei. Ya amarananaku ari da sifoisaie Godinu yawokaku orofaro da anifoisaya weike nono wei, ya ribuku amarananakunu imukeka ari imufoisake ribuku orounu imukeka ari imufoisake nono yanu imusu da we ma daiwere ufoisaie Godinu yawokaku orofaro anifoisake daiwere sifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nono aina mima nanu wake naukada moi amaranaku yewa amaranaku ari Nanu ibiro unu kofekuie dawama Na unu kofekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nono aina mima Nanu wake naukeka amaranaku ba me manao ufeisaro merama unao ufeku ibake i ba me makeka minu nodoro dai omawere naama doifisake dawararo siafisaro imu ifironae irauaiaiya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yewa orofa akakanu oroubairo merama uke ereka keuwere ibinu ibake meramawere ukaisaya eno wei. Merama uke ereka keuwere fareifekua wei. Nono moi mima moi mibairo merama uke efekuie Godima dawa fanisi daiwere mafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yanu moi umu wanama ya ma merama ufekuie i umu wana umane kuuaweke umu wana demui mane ibifekuie irauaiaiya eno wei. Nono moi ena umu wanayaima feare me inaaro ya mune siafiakuie ba me meramawere ibake moi ena umu wana umane kuuawe wei. ");
INSERT INTO aby_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yanu moi naisama ya ma merama ufekuie i naisa ma doroo yare mune siafoisake naisa demui mane ibifoisaie irauaiaiya eno wei. Naisa kai raarama feare me inaaro ya mune siafiakuie meramawere ibake i moi naisa kai ma doroo yafoisake naisa demuima urero amuke anifoisaie irauaiaiya eno wei. Naisa kai raarayai bobo feare me inaaro anifoisaie meramawereya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Amarananakubake yewa amaranaku ari imukama dino da uforo wei! Yabake wemaro nauawe eno wei. Emenu yawokeka aneruma urero Nanu Babaebairo ibinisaba dino da uforo eno wei! ");
INSERT INTO aby_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","I Ba Eme Sini mima i Godinu wake nauke me orou ugo unao uisa orou ari we mufiake ma wirofiane ibake faria eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Enoya imuke eawe wei! Moi mima mamoe abu wani aderedi (100) boboro nono mamoe abu una demuinaku fe yafekuie mamoe abu nainidi naini (99) oraararo medifiakuke i mamoe abu una demui yodia uke anifekua wei. Eno ufekuba me eno weike wei, euwa eno ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dawa anifekuke yodia ukeebe yodia ukeebe fou ufekuke imuka isafekuro rooro daiwere ufekuke i nainidi naini (99) fe yare me mamoe abu ibake enaenari rooro da ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","I enaenari iyanu urero ibinu Babae Dawa arara me yewa amarananaku feareroma feare me inaaro aneka wei. ");
INSERT INTO aby_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Anu aiyema abake merama ufekuie anu mane aniake dawabairo i merama we ma boroo yaa wei. Eno wearo anu wake naufekuie dawaini aini naiye we makafuwaisi eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dawa anu wake da naufekuie nono moi mi una demui o una raarayai ari we muake i mibairo aniake i wake nono wearo i miyai anu wake naufisisike anu wake dawa baya we imufisisike i mibairo emua deri ane wefisi eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Emua deri ane wefisisiro i mi da naufekuie aniake Godinu wake naukeka oroubairo i wake wearo i orouma dawabairo ane wefisa wei. Eno wefisaro dawa nauke dafekuie Godinu wake naukeka orouma dawa medifeisake dawa bi mame imusu odifeisaro i miye imusu mi ari o dakesi muneka mi ari eno imufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yabake ba wake wemaro nauawe wei. Yama aina ainanu aneme aneme ukeka yewa dooro naama uwane karifoisaie urero enaenari uwane karifekua wei. Nono aina ainanu aneme aneme ukeka yewa dooro woromifoisake mune imusu odifoisaie urero enaenari woromifekuke mune imusu odifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nono yabake ba wake wemaro nauawe wei. Yabairo eme una raara miyaima emenu imukeka daaba demuiro imukada Godibairo we nauke efisisiie Nanu urero ibinu Babaema ie emuabake mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nanu wake naukeka orou una raara o una buuba aboro aboro Nanu ibiro nanu wake we makanada ibifeisaie Na emuaini demuiro ibimaua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Fidama Yesubairo farike eno wei, Dai Waria Mi, nanu naiyenu merama ukeka nabairo abea ufekuro mumauke imuke medimau wei? Moi odoro merama ukeka seweni (7) ufekuro mumauke imuke medimau wei? ");
INSERT INTO aby_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eno weiro Yesuma Fidabake ma owerike eno wei, merama yaisina seweni (7) meya wei. i merama dawa keuwere ibake da kakufakua wei. Danu ba me merama ukeka yaisina muake imuke media wei. ");
INSERT INTO aby_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iduaba Godinu ure yawokekae yewa wake aria wei. Moi dai kini mima dawa dai waiya ukeka orounu waiyaini we muneka oini ma giena ufine ui. ");
INSERT INTO aby_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eno ukeibibaie moi waiya ukeka mima dawabairo fari. I mima dai kinibairo oi daiwere deni mirioni kina (K100000) we munike nono moko make daui. ");
INSERT INTO aby_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dawabairo oi meba ibake moko da mafeku wei. Ibake i dai Kinima eno wei, dawaini danu awekaini danu amara arumaini danu eraerabusaini yaisina make oi muaweke yaisina nabake moko makowe wei. ");
INSERT INTO aby_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Eno weiro i waiya ukeka mima ifoma kodudu yanakada eenu wei, dai mi koro uinaro i oi yaisina moko abake mamaane wei. ");
INSERT INTO aby_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eno weiro ibake i dai kini mima imukari ukaada i mibairo oi mune dauike ani. ");
INSERT INTO aby_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","I waiya ukeka mima anike moi waiya ukeka mi fou uri. Adinaroe dubuena fou uri waiya ukeka mima i bokai waiya ukeka mibairo oi du dausini kina (K2,000) we munike nono moko make daui. Enoba i bokai waiya ukeka mima i moi mi fou urike danu fayaro munike eno wei, a nanu oi moko maina wei. ");
INSERT INTO aby_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eno weiro i moi waiya ukeka mima ifoma kodudu yanakada eenu wei, na koro uinaro anu oi moko mamaane wei. ");
INSERT INTO aby_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Eno weiro i bokai mi dawa arara me koro ukeka ibake weiro oi moko mafine ana ebaro oisa. ");
INSERT INTO aby_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","I bokai mima eno uiro moi waiya ukeka orouma ibai ekake imuka merama imuisake ane dai Kinibairo wayai weisa. ");
INSERT INTO aby_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ane wayai weisaro dai Kinima nauike weiro i bokai mi dawabairo fari. Fariro dai kinima dawabake eno wei, a merama waiya ukeka mi! Ama nabairo eenu wenuba imukari ukaada i yaisina mune imuke daunaaya wei. ");
INSERT INTO aby_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Anu naiye anemebake enaenari imukari imuke dakinu wei? ");
INSERT INTO aby_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eno weike dino daiwere ukaada i minu moko oi yaisina mafine ibake i mi ana eba yawokeibisa orounu wanaro mame odi. ");
INSERT INTO aby_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Enoba yanu naiyemukunu ba me merama ukeka da mune imuke medifoisaie Nanu urero ibinu Babae Godima yanu ba me merama ukeka da mune imuke medifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuma i wake yaisina we me sinike Gareri orofa medike ani. Iroma ane Diodeni adua ekabokena Diudia orofaro fari. ");
INSERT INTO aby_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ane fariro eme keuwere Danu umuro anisake iro ane fakaro emua ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","I Ferosi orouma Yesu uke iruke efisane fakake eno weisa, moi mima danu aweka me sara medifine ufekuie iyanu darawaduma ibai aneaneme weaku weisa? ");
INSERT INTO aby_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","6","Eno weisaro Yesuma ma owerike emuabairo eno wei, yewa wake kakuraisaba me wei? Godima emeini aweka ubu uike eno wei, iduaba i mima danu amae babae medifiakuke danu awekabairo dakaa ufiro emua una raarayaima una demui ari sifisisia Godima eno wei. I owaowa ya kakuraisaba me Yesuma eno wei? Eno weike nono wei, Godima eno ui ibake emeini aweka emua una raarayai mero emuae una demui ari. Godima emua ma dakaa ui ibake moi mima emua da ma kasifiakua wei. ");
INSERT INTO aby_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eno weiro emuama weisa, Mosesima anemebake eno wei, moi mima danu aweka medifine kodo fefa danu awekabairo mafekuke i aweka medifeku weia weisa? ");
INSERT INTO aby_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eno weisaro Yesuma emuabake eno wei, yanu imuka arawere ibake Mosesima eno wei. I emua ubu urie odoroma ie eno uke dakeibaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nono yabake weakune wei, moi mima danu irau aweka moi emeakabake uke dakaku aweka medifekuie ba me merama ufekua weike nono wei, danu aweka medifekuke moi aweka mufekuro danu awoena awekaini demuiro dodoo ukeifisisiie meramawereya wei. ");
INSERT INTO aby_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","11","Yesuma eno weiro Danu iwoka ukeka orouma eno weisa, ie i ari eno ibake moi mi aweka mune dakakuie irauaiaiya weisa. Eno weisaro Yesuma wei, eme yaisina yewa wake da naufeisaro Godima moi orou unu kofiakuie imufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Moi orou emenu amaema eno uke dorie ibake aweka mune dakaisaya wei. Nono moi orouma moi orou bauma dafa murieba ibake aweka mune dakaisaya wei. Nono moi orouma i ure yawokaku wake naukenewaa ufisane ibake aweka mune dakaisaya wei. Aina mima yewa wake naukenewaa ukakuie enaenari ukakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Moi orouma emenu amarananaku Yesubairo waure fakaro Yesuma Danu wana emenu iiriro odifike we ma irau ufine ibake waure faka. Waure fakaro i Yesunu iwoka ukeka orouma emuabake dino wake weisa. ");
INSERT INTO aby_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eno weisa ibake Yesuma Danu iwoka ukeka oroubake wake bunawereroma eno wei, i amarananaku Nabairo aafisane weakunea wei. Eno weike nono wei, i ure yawokeka orofae emenu ibake weakunea wei. Eno weike nono wei, emenu aareka daaba yama dadau da uforo wei. ");
INSERT INTO aby_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eno weike Danu wanama emenu iiri okoro odike emua we ma irauaiai uike idua medirieke ani. ");
INSERT INTO aby_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Moi mima Yesubairo farike eno wei, Sisa mi, aneme aneme irauaiai umake me ibene ibene ibimau wei? ");
INSERT INTO aby_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eno weiro Yesuma dawabake eno wei, aneme irauaiaibake we nauke eraaku wei? Godi mane irauaiaiya wei, I me ibene ibene ibifane imufakuie Godinu darawadu wake yaisina naukenewaa ua wei. ");
INSERT INTO aby_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Yesuma eno weiro i mima ma owerike eno wei, abo darawadu wakeye wei? Eno weiro Yesuma ma owerike dawabake eno wei, eme da ma feaa, moi minu aruma aweka da enare odia, moi minu erabusa da waira ua, wayai weadae meo da wea, anu amae babaebake irauaiai uke yayana, anu naiyebake anu onami ari imukari uke yaa wei. ");
INSERT INTO aby_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eno weiro i awoena mima Yesubake eno wei, i yaisina nanu okoanakuroma eno ukeibakunea wei, nono moibaide aneaneme umau wei. ");
INSERT INTO aby_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eno weiro Yesuma dawabake eno wei, anu arara Godi ari irauaiai simaua wefakuie aniake anu eraerabusa yaisina make oi muake i oi yaisina eraerabusa me oroubairo mayanake Nanu umuro aara wei. Eno ufakuie a urero eraerabusa keuwere iro mufakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eno weiro i awoena mi nauike dawabairo eraerabusa keuwere ibake dawa arara me danu eraerabusa moi oroubairo makeka ibake imuka merama imuike owerike Yesu medike ani. ");
INSERT INTO aby_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesuma Danu iwoka ukeka oroubake eno wei, yabake ba wake wemaro nauawe wei. I eraerabusa keuwere mima Godinu ure yawokaku daabaro anaadae owaina me araramama imusu ari ukeifekuro anifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Enoba nono yabake weakunea wei, moi abu danu ibiye kemo, dawa bobo ebaro fare anifekuie dawabairo meya ara wei. Nono i eraerabusa keuwere bobo minu urero anekae owaina me araramama imusu aria wei. ");
INSERT INTO aby_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eno weiro Danu iwoka ukeka orouma naukake imuka foria daiwere ukaada weisa, eno weakuba ainama wirofeku weisa? ");
INSERT INTO aby_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eno weisaro Yesuma eno wei, emema da ufeisaie Godima i yaisina ufekuke Danu mane ma wirofiakua wei. ");
INSERT INTO aby_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yesuma eno weiro Fidama moko ma owerike eno wei, iya yaisina iyanu eraerabusa meisike Anu umuro aaraisia wei. Enoba anemerabu mufeisi wei. ");
INSERT INTO aby_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Eno weiro Yesuma emuabake eno wei, Nanu ba wake wemaro nauawe wei, i Ba Eme Sini Mima i awoena fafeku orofaro Danu irau yaureka duboro yaufeku wei. Yaufekuro Nanu umuro aaraisa orou yama moi irau yaureka duboro yaufoisake i Isaraera orounu akaemuku emenu iduu imusu imusu yaisina duwero (12) yawokeifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aina mima danu kakaini nabueini aruarumaini amaeini babaeini amarananakuini waiyaini Nanu ibibake medifekuie i ari eno moi keuwere urero moko mufekuke me ibene ibene ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nono moi yewa dooro daiwere sine ibinisa oroue i urero okoananaku sifeisaya eno wei. Nono moi Godinu waiya ukaisa orou emuae yewa dooro okoanakuba urero amufeisaie iro daiwere sifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuma eno wei, Godinu ure yawokakuie yewa wake aria wei. Moi uwara ubi mima wai awanakuro uyarike moi eme mune danu gureifi waiyaro odifiaro waiya ufisaro oi mafiane ani. ");
INSERT INTO aby_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ane faribaie dawaini i waiya ukeka orouini emuama oi waria we makanada iraua weisa. I orouma moi furo waiya ufisaro i waiya ubi mima emuabake oi kaibai deidemu emuabake moko mafiane weisa. Iraua weisaro waiya ubi mima emua we odairiero danu waiyaro anisa. ");
INSERT INTO aby_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Eweka amuke ane abanaro ibiro waiya ubi mima makedi ukeibisa orofaro anike eribaie moi orou me yaure ibisaro erie. ");
INSERT INTO aby_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Erieke emuabake eno wei, nanu waiyaro aniaweke waiya uawero yanu moko oi mamia wei. Eno weiro i orou idua danu waiyaro anisa. ");
INSERT INTO aby_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eweka okoro enariro i waiya ubi mima nono anike erieke weiro i moi me yaure ibisa orouini danu waiyaro anisa. Nono eweka ma owerike ane abanaro siniro nono anike enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dumudumu siniro nono anike moi orouma me enare ibisaro erieke eno wei, anemebake yewa eweka yafa me ibinisa wei? ");
INSERT INTO aby_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eno weiro emuama eno weisa, moi mima iya ukeka waiya make dakinuba ibake me ibinisia eno weisa. Eno weisaro ma owerike emuabake eno wei, yaini nanu waiyaro aniaweke waiya uawe wei. Eno weiro i orou ido waiyaro anisa. ");
INSERT INTO aby_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Eweka me siniro dumu ma girisi yafine ukeibi ibake i waiya ubi mima danu oi yawokeibi mibake eno wei, i waiya ukaisa orou wearo fafisaro i dubuena waiyaro anisa orouko emenu oi mafiake nono i abanaro anisa orounu oi mafiakema nono i bokai anisa orou emenu oi dubuena mafiao wei. ");
INSERT INTO aby_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eno weiro i oi yawokeibi mima weiro i dumudumu sinike ma oweriro anisa orouko idua faka. Idua fakaro oi kai demui eme una deidemu makeibirie. ");
INSERT INTO aby_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eno mane ukeibiriero i dawako ane waiya ukeibisa orouma fakake eno weisa, iyako aarisiba oi daiwere mufeisia eno we imukeibisaro emuaini iini oi kai deidemu eme una deidemu bokai orou marie enaenari makeibirie. ");
INSERT INTO aby_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Eno uke makeibiriero i dawako waiyaro anisa orouma i waiya ubi mibake kamena weisake eno weisa, i dubuenaro anisa orou emua waiya dai menaku ukisaya weisa. I bokairo anisi orou iya wai awanakuroma dumudumu eweka yafa eweka rarakada waiya daiwere ukisiro nono emuaini iyaini moko oi eku e’u mero demui mane munisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","14","Eno weisaro i waiya ubi mima emenu moi mibake eno wei, naiye, abake meramawere uke daunea wei. Oi waria we makanada oi kai demui mufeisi eno yaini naini eno ufeisi weisi enoya anu oi idua muake ania wei. Eno weike wei, Nanu ararae i dubuena anisa orouini ya bokai anisa orouini demui moko makeka ibake eno maniaya wei. ");
INSERT INTO aby_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yewa oi nanuba ibake daiwere o okoanaku mamiane wemauie enaenari mamaua wei. I dawa irauba me wei? Nanu irauaiai ukeka ibake dino ukaku, i waiya ubi mima eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Enoba i dubuena orouma urero bokai sifeisaro nono i bokai orouma urero dubuenaro sifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Yesuini Danu iwoka ukeka orouini Derusaremu goiro anisa. Aneibisabaie Yesuma Danu iwoka ukeka orou duero (12) emua we mune imusu odirieke emuabake eno wei, i Derusaremu goiro anaisia eawe wei. Iro fafeisiro i Ba Eme Sini Mi i dai ofereni ode sibore sianeka orouini Mosesinu darawadu we ma iwoka ukeibaisa orounu wanaro mame odifeisaro Dawa feafine wefeisake i imusu orounu wanaro mame odifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Odifeisaro i orouma Dawa we irukada domuma ufeisake korosiro ure odifeisaro ido feafekuro odo buuba me sifekuro nono feafeku iroma uyafekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Debedinu awekama danu amarayai mune Yesubairo waure fari. Waure farike ifoma kodudu yanakada danu arara emua Yesuma mufine ibake eno ui. ");
INSERT INTO aby_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eno uiro Yesuma eno wei, aneme ufane weaku wei? Eno weiro i awekama ma owerike eno wei, wearo Anu yawokeka orofaro anifakuie iro nanu moi amara Anu ba ena wana enaro yaufiro nono nanu moi amara Anu ewani ena wana enaro yaufi wei. ");
INSERT INTO aby_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eno weiro Yesuma eno wei, yanu we nauke ereka ya iwoka mero ya sara weaisaya wei. Na ure yanake ukeifeisaro yaini enaenari enare ara ufuaisiba me wei? Eno weibaie emuama euwa weisi. ");
INSERT INTO aby_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Eno weisiro Yesuma eno wei, ba weaisia. Na ure yanake ukeifeisaro enaenari ufuaisia wei. Nono i yaureka orofayaie Nanu meba da wemauro da yaufuaisia eno wei. Godima i orofa uke bou uiba Dawama wefekuro yaufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesuma eno weiro moi iwoka ukeka orou deni (10) i wake nauisake i miyaibake dino uisa. ");
INSERT INTO aby_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dino uisaro Yesuma weiro i iwoka ukeka orou yaisina Dawabairo faka. Dawabairo fakaro Yesuma emuabake eno wei, i imusu orounu dai yawokeka orou emuama arawere yawokada emenu imukeka emuabairo arawere odaisa. Eno ukaisaie ya ibai iwoka sinaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nono yabairo eno da ufoisa. Yabairoma aina mima dai mi sifekuie ya yaisina unu kofiaku. ");
INSERT INTO aby_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nono aina mima bokai mi sifekuie dawa yanu waiya ukeka mi sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Enaenari i Ba Eme Sini Mi emema Dawa unu da kofisaro Dawama emua unu kofiane fari. Enoba Dawa feafekuro Danu iwa dooro isafekuro nono Danu iwama eme keuwere make munao ari ufekuro irau sifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Deriko goiroma anisa. Anisaro eme keuwere emenu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aneibisabaie naisa kikori bobo miyai daaba udiro yaure ibaada Yesu fare aneibiro nauisike daiwereroma eno weisi, Dai Waria Mi, Deiwidinu sisia mi uwabake imukari ua weisi. ");
INSERT INTO aby_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eno weisiro i ku uke ibisa orouma dino ukaada eno da weawa weisa. Eno weisabaie nono daiwereroma eno weisi, Dai Waria Mi, Deiwidinu sisia mi, uwabake imukari ua weisi. ");
INSERT INTO aby_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eno weisiro Yesuma idua enarike eno wei, yabake aneme umane weaisi wei? ");
INSERT INTO aby_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eno weiro emuama weisi, Dai Waria Mi, uwanu ararae efune weaisua weisi. ");
INSERT INTO aby_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eno weisiro Yesuma emua imukari ukaada emenu naisaro wanama ure buriro emenu naisa wiroiro ekike Yesunu umuro anisi. ");
INSERT INTO aby_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Derusaremu goiro fafisane ukabaie moi goi Oriwa oraara udi Bedifagi goiro faka. Fakaro Yesuma Danu iwoka ukeka miyai we odaisada eno wei, yeka goiro aniawa wei. Ane fafuaisie moi donikini danu nakuini uwane oisaro enare ibinisiba efuaisiie emua ma woromiawake waure aarawa wei. ");
INSERT INTO aby_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Moi mima yabake aneme ukaisi wefekuie uwanu Dai Waria Mima mufine wenu weawaro mafia wei. ");
INSERT INTO aby_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Godinu we bou ukeka mima adinaro wei ibake Yesuma eno wei. I we bou ukeka mima eno wei, I Saioni orofa oroubake wea eno wei, emenu Dai yawokeka kini mi emuabairo fafeku wei. Dawa dai kini mi ari da fafeku. Moi donikinu naku deiro yaufekuke fafeku wea eno weia, I we bou ukeka mima eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","I iwoka ukeka miyaima anisike Yesunu wei wake enaenari uisi. ");
INSERT INTO aby_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I miyai i donikini danu nakuini waure fakike emenu wau donikinaku unanu deiro yaweke oisiro Yesu duboro yauri. ");
INSERT INTO aby_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eme keuwere emenu wau daabaro yaweke oisaro moi orou farai kakabai kuure daabaro yaweke odeibisa. ");
INSERT INTO aby_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Moi orouko anisaro Yesu ubarero aniro nono moi orouma emenu umuro anisa. Eno uisake i bokai anisa orouini i dubuenaro aneibisa orouini emua yaisina daiwere ousana weisake nono weisa, Godima we mune odiro Deiwidibairoma sirorari ui mi Dawa irauaiaiya weisa. Dawae Godinu ibiro idua farinua weisa. Godima Dawa we ma irauaiai ufeku weisa. Urero orouini Danu ibi we ma daiwere ukaisaya weisake eno mane daiwere weibisa. ");
INSERT INTO aby_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Eno we anisake weisaro Yesu Derusaremu goiro waure faka. Fakaro i Derusaremu goi orouma foria daiwere ukaada eno weisa, yewa miye aina weisa? ");
INSERT INTO aby_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eno weisaro Danu umuro anisa orouma eno weisa, yewae Godinu we bou ukeka mi Danu ibiye Yesu. Dawae Gareri orofa Nasaredi goi miya weisa. ");
INSERT INTO aby_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuma i dai sosi ubarenaro amui. Amuike erabusa make oi muneibisa orouini oima make erabusa muneibisa orouini yoweriro aweawero fare anisa. Yesuma i oi moko make makeka orounu seboini ofereni odeka ubari adanu karaini oima make muneka orounu yaureka duboini yaisina mune sianiro ubere aine ibisa. ");
INSERT INTO aby_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yesuma eno uike eno wei, Godinu bukaroma eno weakua wei. Nanu uwarae emenu guriguri ukeka uwaraya weakua wei. Nono yama Nanu uwara waira ukeka orounu uwara ubu ukisaya weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","I naisa kikori bobo orouini i umu beobeo bobo orouini emua i dai sosiro Yesubairo fakaro emua ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","I dai ofereni ode sibore sianeka orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Yesunu buna ukeka ekabaie i amarananakuma i dai sosiro wake goro weada Godima we mune odiro Deiwidibairoma sirorari ui Mi Dawa irauaiai weisaro i dai orouma naukake dino uisake Yesubake eno weisa, i amarananakunu wake naukakuba me weisa? Eno weisabaie euwa, naukakunea wei. Eno weike wei, yewa wake kakuraisaba me wei? I wakeye enoya wei, i okoa enaenare anaisa amarananakuini nono i ama isaisa amarananakuini emua emenu Dai Minu ibi we ma daiwere irauaiai ukaisaya wei. Na iwoka, i wake yama kakukaya wei. ");
INSERT INTO aby_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eno weike Yesu emua ido medirieke Derusaremu goiroma Bedeni goiro ane farike aini. ");
INSERT INTO aby_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wai uriro Yesuma uyarike Derusaremu goiro aneebe daabaro desini uri. ");
INSERT INTO aby_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ane eribaie boruba ana daaba udiro enare ibiro eri. Ane farike eribaie boruba kaibai mero kakabai mane ibisaro erike i boruba anabake eno wei, nono kaibai da uwafakua wei. Eno weibaie ena boruba ana ido geo urike nukubai boke uri. ");
INSERT INTO aby_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eno uiro Danu iwoka ukeka orouma ekake imuka foria uisake eno weisa, i boruba ana aneme aneme sabu geo urinuke nukubai boke urinu weisa? ");
INSERT INTO aby_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eno weisaro Yesuma emuabake ma owerike eno wei, yabake ba wake wemaro nauawe wei. Yae yanu naukekabake ie meya eno da we imufoisake nono imukenewaa ufoisaie Nanu une i boruba kaibaibake i enaenari ufoisake nono moi buna ufoisaya wei. Eno weike nono wei, yeka oraarabake uyake dawara ubarenaro isaa wefoisaie enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Imukenewaa ufoisaie guriguri ukaada anemerabu Godibairo eenu weada we naufoisaie Godima yabake idua mafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuma i dai sosi uwara ubarenaro amuike we ma iwoka ukeibirie. We ma iwoka ukeibiriebaie i dai ofereni ode sibore sianeka orouini Du orounu bisara orouini emuama Yesubairo fakake eno weisa, ainanu bunaro eno ukaku weisa? Aina mima a buna makakuyainuro eno ukaku weisa? ");
INSERT INTO aby_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Eno weisaro Yesuma emuabake eno wei, yabairo we nauke ereka bokai wemauro moko wake wefoisaie nono aina mima Na buna makakunararo eno ukakune ibai wemauro naufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","I Dioninu babadaido ukekae ureroma fariba ba emebairoma fari wei? Eno weibaie wake we makanada emenu mane eno weisa, aneme aneme wefeisi weisa? Ureroma faria wefeisiie Dioninu wake anemebake nauke da uisa wefekua weisa. ");
INSERT INTO aby_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nono emebairoma faria wefeisiie i orou yaisina Dioni Godinu we bou ukeka mi imuisaba emema iyabake aneme ufeisa weisa? ");
INSERT INTO aby_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Emenu mane eno we makakake nono Yesubairo eno weisa, iya iwoka meya weisa. Eno weisaro Yesuma emuabairo ma owerike eno wei, moko wake we dakisaba iduaya Nanu buna ukakune i wake yabairo da wemaua wei. ");
INSERT INTO aby_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuma yewa wake imuke eawe wei. Moi amarayai emenu babaeini demuiro ibeibisa. Emenu babaema danu bokai amarabairo ane farike eno wei, nanu gureifi kai waiyaro aniake waiya ua wei. ");
INSERT INTO aby_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eno weiro bokai mima nauike da animau wei. Eno weike nono dubuenaro danu imuka oweriro waiyaro anike waiya ui. ");
INSERT INTO aby_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nono emenu babaema danu dubuena amarabairo ane farike enaenari wei. Eno weiro dubuena amarama eno wei, na anu waiyaro animauke anu waiya umaua weikema nono ane daui. ");
INSERT INTO aby_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Abodei amarama danu babaenu wake naui wei? Eno weibaie danu bokai amarama danu wake nauia weisa. Eno weisaro Yesuma eno wei, yabake ba wake wemaro nauawe wei. I dakesi muneka orouini moi emeakanu umuro aneibisa awekaboini emuako Danu wake naufeisake Godinu ure yawokaku orofaro anifeisaro nono yae iro anifoisaba me Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eno weike nono wei, Dionima farike Godinu irau wake weibibaie yama danu wake nauke dauisaro i dakesi muneka orouini moi emeakanu umuro aneibisa awekaboini emuama danu wake nauisake urero amufisane emenu ba me merama ukeka imuke meisa. Eno uisaro yama ekake danu wake nauke da uisake yanu ba me merama ukeka imuke mede da uisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuma moi dubo waure wei wake eno weike wei, yewa wake nauawe wei, moi mima gureifi yobai danu waiyaro wawike oro mamike gureifi amuke adiadi yareifi ooru ubu uike danu waiya kukuara uike danu waiya danu waiya ukeka oroubairo yawofisane marieke moi orofaro ani. ");
INSERT INTO aby_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aniro dubuenaro ayo ureka oya fariro danu moi waiya ukeka orou i waiya yawokeibisa oroubairo gureifi mufine we odai. ");
INSERT INTO aby_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Danu moi waiya ukeka mi we odairo ane faribaie emuama dawa usima uka. Nono danu moi mi we odairo ane faribaie dawaini uka. Nono danu moi mi we odairo ane faribaie emuama dawa omama umaka. ");
INSERT INTO aby_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nono danu moi waiya ukeka eme keuwere we odaiseibiro ane fareibisabaie emuaini enaenari eno mane ukeibisa. ");
INSERT INTO aby_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ukeibisaro dubuena kai waiya ubi mima eno wei, nanu amara ubi we odaimauro dawabake iifa ufeisaya wei. Eno weike danu amara ubi we odairo ani. ");
INSERT INTO aby_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ane fariro i orouma dawa ekake eno weisa, yeka miye danu amara ubiba dawa ma feafeisike danu waiya mufeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eno weisake i mi mukake waiya oro dubuenaro siakake dawa ukaro fearia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Eno uisa ibake i waiya onami mima fafekuke i waiya yowokeka oroubake aneme ufeku wei? ");
INSERT INTO aby_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eno weiro i orouma eno weisa, dawa i meramawere orou arawere uke yafiakuke ufiakuro feafeisaya eno weisa. Eno ufekuke danu waiya mune irau yawokeka oroubairo mafiakuro ayo ureka oya fafekuro dawabake naa didi kaibai mafeisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eno weisaro Yesuma emuabake eno wei, yewa wemau wake Godinu bukaro kakuka. I wakeye eno, I uwara ukeka minu mune siaka omae i kukubu kora kai ari sini, yewae iyanu Godinu ukeka ibake kawama eraisia weisa. I wakeye enoya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iduaba yabake weakune, Godinu yawokaku orofaro yabairoma mareke mufekuke imusu oroubairo mafekuro i orouma Godinu waiya ukenewaa ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aina mima yewa omaro ure akuaku ufekuke isare ufekuie danu onami ure birabira yafekua wei. Nono i omama aina mibairo ufekuie i miye gibudi ari eno sifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","I dai yawokeka orouini Ferosi orouini Yesuma i dubo waure wei wake nauisake Dawae iyabake weakua eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eno we imuisake Yesu yabake umu wana naama uwafisane weisa. Eno weisaro i ku uke ibisa orouma Yesue Godinu we bou ukeka miya eno we imuisa ibake dai ofereni ode sibore sianeka orouini Ferosi orouini ia iyakake meisa. ");
INSERT INTO aby_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuma emuabake nono moi dubo waure weeka wake eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Dawama wei, Godinu ure yawokakuie yewa wake ariya wei. Moi dai kinima danu amaranu aweka muneka banau ufine ui. ");
INSERT INTO aby_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eno uke me sinike danu waiya ukeka orou wayo kofisane we odairiero anisa. Wayo anisabaie banau ifisa orou fare dauisa. ");
INSERT INTO aby_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","I banau ui ubi mima nono moi waiya ukeka orou we odaifiro wayo anifisane ukaada eno wei, aniaweke i banau ifeisa oroubake eno weawe wei, nanu banau yaisina uke me sinea eno weawe wei. I boromakauini keweama imusu ari boromakaunakuini unero uruna yaisina me sininu enoya i aweka muneka banau aare iawe eno weawe wei. Eno weiro danu waiya ukeka orouma idua anisa. Ane fakake danu wei enaenari weisa. ");
INSERT INTO aby_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eno weisaro i orouma nauisake nono moi orouma emua we irukada emenu waiyaini sidowaini iro anisa. ");
INSERT INTO aby_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nono moi orouma danu waiya ukeka orou emua meramawere ukaada uriekaro feaka. ");
INSERT INTO aby_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eno uisaro i banau ubi mi dino daiwere uike danu meremere orou we odairiero anisa. I eme ma fearieka oroubairo ane fakake emua uriekake emenu uwara uwara inaama yare soaka. ");
INSERT INTO aby_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","I dai kini mima danu waiya ukeka oroubake eno wei, nanu banau uke me sineroma nono i dawako wayo konia oroue meramawereba nanu banau da ifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iduaya i dai daaba daabaro iro aboro aboro aniaweke abo orou fou ufoisaie weawero aafisa wei. ");
INSERT INTO aby_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eno weiro danu waiya ukeka orouma anisake irau orouini merama orouini fou uriekake we waure fakaro i aweka muneka ibake banau ui uwara wake fari. ");
INSERT INTO aby_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","I dai mima i banau iseibisa orou efine fari. Faribaie moi mi aweka muneka emenu bisara wau rune dauiro erike eno wei, naiye, a aweka muneka bisara wau bobo ba mero aneme aneme yewa uwara ubarenaro amukinu wei? Eno weiro i mima wake we da uike wake muu ui. ");
INSERT INTO aby_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wake muu uiro dai kini mima danu moi banau yawokeka mibairo eno wei, danu umu wana naama uwane kariake dawa i aweawe dumuwere orofaro siyaaro isafi wei. Iro isafiro iro ibinisa orouini emenu nio ake fagigi yaraada ii weifeisa wei. ");
INSERT INTO aby_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Godima eno weaku, eme keuwere aarawe weakuroma nono dubuenaroe eme una demui demui mane we mufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","I Ferosi orouma Yesu meisake aweawero anisa. Ane emenu ararae Yesu we irufisaro Yesuma aneme moko wake emuabairo wefiro naufisake Danu umu wana naama uwafisane ibake emenu mane wake wake we makaka. ");
INSERT INTO aby_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I orouma eno we makakake emenu iwoka ukeka orouini i Erodinu orouini emua we odairiekaro Yesubairo we iruke efisane anisa. Ane fakake eno weisa, Sisa mi, ae meo we dakaku mi. Ae moi mi dawa dai miro nono moi mi dawa okoanakua eno we imuke dakakuke Godinu wakeini Danu imukekaini we ma iwoka ukenewaa ukakuke i dai yawokeka oroubake ia iyare dakaku ibai iya iwoka sinaisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Weisake eno we imukada i Romani oroubairo dakesi oi da mayakawe wefekuie i Romani orouma dino ufeisake nono dakesi oi i Romani oroubairo mayakawe wefekuie i Du orouma dino ufeisaya eno we imukada ibake Yesubairo we nauke eraada weisa, i Romani gaemani dai mi Kisabairo dakesi oi mafeisiie irauba me wearo naufe weisa. ");
INSERT INTO aby_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Eno weisaro Yesuma emenu merama imukeka iwoka uike eno wei, ya meomao weaisa orou! Anemebake Na we iruke eraada weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","I dakesi oi makowero ema wei. Eno weiro oi kaibai Dawabairo maisaro muni. ");
INSERT INTO aby_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mune eraada eno wei, ainanu iboo naisaini owaowaini ewado ibinu wei? ");
INSERT INTO aby_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eno weibaie Kisanua weisa. Eno weisaba ibake Yesuma emuabairo ma owerike eno wei, iduaroma i dai gaemani mi Kisanu aneme aneme dawabairo maeweke nono Godinu aneme aneme Godibairo maewe wei. ");
INSERT INTO aby_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eno weiro i orouma nauisake imuka foria uisake Yesu meisake anisa. ");
INSERT INTO aby_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","I odoro moi Sadusi orouma Yesubairo faka. I orouma feareroma da uyafeisaya eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","I orouma Yesubairo fakake eno weisa, Sisa mi, Mosesinu darawaduma eno weaku, moi mima aweka mufekuke amara aruma dore mero me ibeebe feafekuro danu nabuema danu kakanu aweka wabu mufekuro i feafeku mibake amara aruma dofeku eno weakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eno weisake Yesubake yewa wake wefero naua weisa. Demui aidakaku seweni (7) ibeibisa. Ibeibisake i bokai mima aweka munike amara aruma dore mero me ibeebe feari. ");
INSERT INTO aby_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nono danu nabuema danu kakanu aweka wabu munike enaenari me ibeebe feari. Eno mane ukeebe i aidakaku yaisina seweni (7) amara aruma dore mero me ibeebe feaka. ");
INSERT INTO aby_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Emuae feare me sikaro dubuena kaie ena aweka wabu idua feari. ");
INSERT INTO aby_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Enoroma i feare uyareka odoro abo mima i aweka mufeku eno weisa? Yewa orofaro i orou yaisina i aweka mukaba aina mima i aweka iro mufeku eno weisa? ");
INSERT INTO aby_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","I orouma eno weisaro Yesuma emuabake eno wei, Godinu bukaro wakeini Godinu bunaini ya iwoka me ibake ma nuna ukaada urero aweka amara ukeka wake weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","I feafeisake uyafeisa odoroma urero aweka amara da ufeisa wei. Iro Godinu aneruma aweka amara make dakaisaba i oroue Godinu aneru ari sifeisa ibake aweka amara daufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Yesuma eno weike nono moi wake eno wei, i Mosesinu feareroma nono uyareka wake imuke eawe wei. Mosesima Godi Danu wei darawadu wake eno owaowa yanake odi, Nae Eibaramunu Godi, Nae Aisikinu Godi, Nae Deikafunu Godi, Mosesima eno owaowa yanake odiro ya kakurada iwoka sinaisaya wei. Nono Godi Dawae i feareka orounu Godi meya wei. Eno weike nono wei, i orou emuae feakakema nono Godini me ibinisa ibake Dawae i me ibeka orounu Godiya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesuma eno weiro idua ku siane ibisa orouma nauisake Danu we ma iwoka ukeibi ibaibake emua imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuma i Sadusi orounu wake weeka daaba enare kuuriro nono i Ferosi orouma nauisake emuade ari Yesubairo we irufisaro Dawa aneme aneme wefeku ibai naufisane faka. ");
INSERT INTO aby_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Fakaba i Ferosi moi darawadu yawokeibi mima Yesu we irufike Dawa aneme wefibai naufine farike eno wei, Sisa mi, abo darawaduma daiwere wei. ");
INSERT INTO aby_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eno weiro Yesuma dawabairo ma owerike eno wei, anu ukekaini sinekaini anu imuka yaisina Godibairo odenewaa uake Godi aine wai ure imukeibia wei. ");
INSERT INTO aby_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ie i dai bokai darawadua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eno weike wei, nono moi darawadue enoya wei, anu naiyebake anu onami imukari unaku enaenari anu naiye imukari ukenewaa ua wei. ");
INSERT INTO aby_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eno weike wei, Mosesini i we bou ukeka orouini emenu wake yaisina i darawadu yaibairoma fariro ibake eno weisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","I Ferosi weaisa orouma ku uke yaure ibisaro Yesuma emuabake we nauke eraada eno wei, yama i Mesaiabake ainanu amaraya eno we imukaisa wei? Eno weiro Dawabake eno weisa, Dawae Deiwidinu sisia miya weisa. ");
INSERT INTO aby_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eno weisaro Yesuma emuabake eno wei, Godinu Imumu Irauma Deiwidibairo ma iwoka uiba ibake Deiwidima i wake anemebake eno wei i Mesaia nanu Dai Waria Miya wei? ");
INSERT INTO aby_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Deiwidi dawa eno wei, Godima nanu Dai Waria Mibairo eno wei, Nanu baena wana enaro yauaro Aini wasai ukaisa orou Nama buna umake Anu umu emenu duboro odimaua, Deiwidima eno wei. ");
INSERT INTO aby_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deiwidima i wake adinami nauwaro eno anemebake eno wei arie wei? Deiwidima Kerisobake nanu Dai Waria Mi weibairo nono Yesu aneaneme danu sisia mi sini arie wei? ");
INSERT INTO aby_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eno weiro nauisake moko wake we da uisake iduama eka nono we nauke ere da uisa. ");
INSERT INTO aby_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Yesuma i ku uke ibisa orouini Danu iwoka ukeka oroubake eno wei, i Mosesinu darawadu we ma iwoka ukeibaisa orouini i Ferosi orouini emuama Mosesinu darawadu iwoka sinaada i Du orounu sosiro we ma iwoka ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Enoya emenu we ma iwoka ukeka wake nauaweke enaenari uaweke nono emenu ukeka sineka enaenari da uawe eno wei. I orouma wake daiwere we ma iwoka ukaisake nono enaenari uke dakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I orouma emenu mane darawadu ego ari inimuma imusu ariro eme moinu owairo odaisake nono emenu wana raraga demuinakuma mame ere dakaisa. ");
INSERT INTO aby_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aneme aneme ukaada eme moima efisane ibake eno ukaisaya wei. Godinu wake oba uke wanaini awararo uwane kariseibaisaro ibaisa. I dai me obanaku me daiaisa oba uke uwanaisa. Nono emenu wau yafawere baruke sianaisaro fare isare anaku. Eme yaisina i efisane ibake eno baruke eneibaisa. ");
INSERT INTO aby_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Banauro anaisake moi emema efisake farinu wefisane i dai orounu yaureka orofaro yauraisa. I Du orounu dai sosi uwara ubarenaro amukaisake eme moima efisake farinu wefisane ibake ibooro ane yauraisa. ");
INSERT INTO aby_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Emenu ararae i makedi orofaro enaraisa orounu arie wake naufisane anaisa. Nono emenu ararae eme moima emua dai sisa orou wefisaro naufisane ibake eno ukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kaka nabue ya yaisina uwara demui orou ibake yabairo moi mibake sisa mi da weawe wei. Yabairo dai Sisa Mi una demui ibinua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yama yewa dooro moi mibake Babae da weawe eno wei. Yanu Babae una demui urero ibinua wei. ");
INSERT INTO aby_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nono moi mibake dawa dai mi da weawe wei. Yabairo Dai Mi una demui ibinu. Dawae Kerisoya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aina mima yabairo daiwere sifekuie dawa yanu waiya ukeka mi sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nono aina mima danu onami ma daiwere ufekuie nono Godima dawa ma okoanaku ufekua wei. Nono aina mima danu onami ma okoanaku ufekuie Godima dawa ma daiwere ufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesuma we iifa ukeka wake eno wei, ya darawadu we ma iwoka ukaisa orouini Ferosi orouini ya meomao weeka orou ya erenewaa uforo wei! Godinu ure yawokaku daaba dadau ukaisaro eme ane dakaisa wei. Ya iro ane dakaisaro eme moi emenu arara anifisane ukaisabaie yama emenu aneka daaba dadau ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","I darawadu we ma iwoka ukaisa orouini Ferosi orouini ya erenewaa uforo wei! Yae wabu awekabobake meomao ukaada emenu eraerabusa yaisina emenu uwaraini waira ukaisake nono guriguri yafawere we iruke ukaada ibaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","I darawadu we ma iwoka ukaisa orouini Ferosi orouini ya erenewaa uforo wei! Moi mima yanu iwoka ukeka mi sifine ibake dawararoma udiroma aboro aboro anaisa wei. Nono moi mima yanu iwoka ukeka mi sifekuie yae yanu ba me merama ukeka nono dawabairo mafoisaro merama daiwere ufekuro yaini dawaini feare me inaaro anifoisaro Godima yabake fanisi daiwere makaada nono dawabake fanisi daiwere mafeku wei. ");
INSERT INTO aby_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yesuma i orou me sara buna da we bou ufisane ibake emuabake we iifa ukaada eno wei, ya we ma iwoka ukeka orou yae naisa kikori bobo orou ari ibake yanu ukaisa ibai ya iwoka mero me sara ukaisaba erenewaa uforo wei! Yama eno weaisa wei, aina mima i dai sosinu ibiro buna we bou ufekuie ba meya weaisa. Nono aina mima i dai sosi uwara ubarenaro gorudima ubu ukaisa eraerabusanu ibiro buna we bou ufekuie danu wefeku enaenari ufeku eno weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ya naisa kikoriro gogore bobo oroua wei! Anemema daiwere wei, i gorudima ubu ukaisa erabusaba ba i dai sosi wei? I ubu ukaisa eraerabusaba i dai sosi uwarama daiwere wei? I dai uwarama i gorudi ma iifa uiba ibake i dai uwarama daiwereya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yae eno weaisaya wei, aina mima ofereni odeka orofanu ibiro buna we bou ufekuie i orofa buna me ibake i wefeku enaenari da ufeku weaisaya wei. Nono aina mima i ofereni odaada sibore sianada i ofereninu ibiro buna we bou ufekuie i ofereni bunawere ibake i wefeku enaenari ufekua weaisa. ");
INSERT INTO aby_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yae i naisa kikori ere dakaisa orou ariya wei! Abo deima daiwere wei? I ofereniba ofereni odeka orofa? I ofereni odeka orofama i ofereni ma iifa ukakuba ibake i ofereni odeka orofama daiwereya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yesuma nono wei, aina mima i wake weada ofereni odeka orofanu ibiro buna wake weakuie i ofereni odeka orofaini ofereni yaisina emenu ibiro buna wake weaku wei. ");
INSERT INTO aby_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aina mima wake weada dai sosinu ibiro buna wake weakuie dai sosini dai sosi uwara ubarenaro ibinu Godinu ibiro buna wake weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aina mima i wake weada urenu ibiro buna wake weakuie Godinu yaure ibaada yawokaku orofaini iro yaure ibinu Godinu ibiro buna wake weakua iro me sara buna da we bou uawe wei. ");
INSERT INTO aby_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","I Mosesinu darawadu we ma iwoka ukaisa orouini Ferosi orouini ya meomao weaisa orou erenewaa uforo wei. Yae waiyaro eraerabusaini moi okoa eraerabusa yaisina demuinaku Godinua weada imusu odaisa ibake daisi ofereni weaisa i odenewaa ukaisake nono i darawadunu buna wakeye eno emebake irauaiai ukekaini imukari ukekaini Godi nauke imuke ukekaini ie uke dakaisa. I daisi ofereni odekabai i yaisina koko da afoke nono i darawadu ukeka yaisina ukenewaa uforo wei! ");
INSERT INTO aby_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ya we ma iwoka ukaisa orou yae naisa kikori bobo orou ariya wei! Yae uruna naberoro uuni ari rabu ise yonuke dakaada mune sianaisakema nono dai kemo abu, dawa dai borowere ari, i abu una bobo ake adire mero i bobo yonukaisa i ari yae i dai menaku darawadu ukenewaa ukaisake nono i daiwere darawadu me sara ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ya darawadu yawokeka orouini Ferosi orouini, yabake weakune ba erenewaa uforo wei! Yae i ari eno ukaisa, faniginini naberoini eku duboro mane urokaisake nono ubarena uroke dakaisaro igawere uke ibaku wei. I enaenari yanu ofe eku duboro urokaisaro nono yanu imuka ubarenaro igawere ibakua wei. I imuka ubarenaro waira ukekaini eme ma fearekaini eno imuka keuwere imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ya Ferosi weaisa orou, yae naisa kikori bobo orou ari. I fanigini ubarenaro ko urofoisaie danu duboro amearubu sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ya Mosesinu darawadu we ma iwoka ukaisa orouini ya Ferosi orouini, yae meomao weaisa orou ya erenewaa uforo wei! Yae eme fearaisaro ane odaisa orofa ari. Eku duboro amearubu irauaiairo nono eu doo ubarena eme kaibai ibaisa iro iga erabusa keuwere ibinu. Yae i ari enoya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Emema yanu duboro ofe ubuini iboo naisa eraisake dawa irauaiai miya eno we imukaisaroma nono yanu imukekae meramawereya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","32","Yesuma eno wei, i Mosesinu darawadu we ma iwoka ukaisa orouini Ferosi orouini ya meomao weeka orouba erenewaa uforo wei! Yae i we bou ukeka orounu eme ane fearaisaro ane odaisa orofa ma wirokaisake nono Godinu irau orounu fearaisaro ane odaisa orofaro weree weree uke odaada weaisa, iyanu akaemuku ibeibisa furo ibeiferonae i we bou ukeka orou da ma feafenea eno weaisa. Eno weaisaie ya i eme ma feareibisa orounu amarakua eno weadama eno weaisaya wei. Eno weaisa ibake emenu meramawere ukeibisa enaenari uke me sifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yesuma eno weike emuabake nono wei, yae waru ariya wei. Yae warunu muneka amarakua wei! Aneme aneme ufeisike i feare me inaaro da anifeisia eno weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iduaba yabairo we bou ukeka orouini iwoka daiwere ukeka orouini i Mosesinu darawadu we ma iwoka ukaisa orouini emua yaisina yabairo we odaimauro fafeisa wei. Fafeisaro moibai ma feafoisake moibai korosiro ufoisake nono moibai yanu sosi uwara ubarenaro usima ufoisake yanu goi goiro emuabake merama ufoisake ure yowefiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eno ufoisa ibake Godima ya fanisi daiwere mafiakua wei. I irau orou ma fearekae yanu merama ukeka iduaya wei. Eiborobairoma Barakaiasinu amara Sakaraiyasibairo, i mi i ofereni odeka orofaroini dai sosi abanaro yama dawa ma feaka, i orou yaisinanu ma fearekaie yanu merama ukeka iduaya wei. ");
INSERT INTO aby_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yabake ba wake weakune wei, i yaisinabake Godima yewa ibinisa orou fanisi mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuma nono wei, O Derusaremu goi orou, yae Godinu we bou ukeka orou ma fearaisake Godinu we odaisaku orou omama umanakuneka. Aweka kokorokoma danu nakubai babama mune aare kamafu wowonaro odaku enaenari Nanu ararae ya Derusaremu goi orou yawomiane weakuneroma nono ya arara me Nama ya yawokeka eno wei. ");
INSERT INTO aby_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Enoba Godima yanu Derusaremu goi medinuba ewadoma ekae yama Na nono da ereifokoisakema nono eno wefoisa, Godinu ibiro farinu Mi Dawa irauaiaiya wefoisaie nono Na efokoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuma i dai sosi medike anifine ui. Anifine uibaie Danu iwoka ukeka orouma Dawabairo fakake eno weisa, i dai sosiwere aarake ea weisa. ");
INSERT INTO aby_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eno weisaro Yesuma emuabake eno wei, awoena yama i dai sosiwere eraisaroma nono yabake ba wake wemaro nauawe wei. Moi fafeku odoro i uwara oma yaisina ma ubefeisaro moi omama moi omanu duboro da ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuma Oriwa oraararo amuke ane yauri. Amuke ane yauriro Danu iwoka ukeka orou emenu mane Dawabairo fakake eno weisa, Anu dai sosi uwarabake wenu wake abonodo eno ufeku weisa? I dubuena odoro aneme aneme ufekuro iya efeisiro fafeku weisa? ");
INSERT INTO aby_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eno weisaro Yesuma eno wei, erenewaa uforo wei! Moi orouma ya we irufisane fafeisaba. ");
INSERT INTO aby_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eme keuwere Nanu ibiro fafeisake eno wefeisa, nae Kerisoya wefeisake ibake eme keuwere irufiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","I dai uranekanu yama yewado ubiubinaku naufoisake nono ekara moi nauwaro me wake mane naufoisaie ibake ia da iyaforo wei. Ie eno da fafekuro nono i dubuena kai fafeku odo ie oidea wei. ");
INSERT INTO aby_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","I dubuena kai odo fafine ukeifekuro moi orofa gaemanini moi orofa gaemanini emenu emenu urafeisaya wei. Eno ufeisaro i orofa akaka orou yaisina emenu emenu urafeisaya wei. Moi oroorofaro uruna mebake desini daiwere ureifiaku wei. Moi oroorofaro doo amani amani ukeifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","I ari eno ufekuie eme emenu oferi boana bobo awekama amara dofine ukaada oferi daiwere waureibaku i ari ido waufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","I eno ukeifekuie eme moima ya meramawere uke yafiakane naama umu wana uwafiakaisake ma feafiakaisaya wei. Yama Nanu ibi munaisa ibake eme yaisina imuka ka ufeisa ibake eno ufiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","I odoro eme keuwere Na medifokaisake emenu mane aya ode make makafiakaisake emenu emenu urane makafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","I odoro meomao weeka orouma uyafeisake meo wake wefeisaro eme keuwere emenu wake naufeisake emenu umuro anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","I odoro emema ba me meramawere ufeisa ibake imukari ukeka medifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nono aina mima awoenaroma enare ara ukeifekuro nono i dubuena kai odoro aneme aneme fafekuie dawa wirokeka mufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Godinu yawokaku odo i wakeye i orofa akaka orou yaisinabairo we eneifeisaro i orofa akaka orou yaisina naufeisaroma ai i dubuena kai odo ido fafekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Adinami nauwaro Godinu we bou ukeka mi Danero dawama eno wei, ido ba me meramawere erabusae i dai sosinu iifa ooruro enafekuke i yaisina ma merama ufekuro efoisaya Daneroma eno wei. Enobake ya kakuraisa orou ya ie iwoka ukaisa ibake erenewaa ufone weakune Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nono eno weike wei, eno ukeifekuie i Diudia orofaro ibifeisa orouma oraararo sabu amuke anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","I odoro i seboro yaure ibifeisa orouma uwara ubarenaro erabusa mufisane da anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","I odoro emenu waiyaro waiya ukeifeisa orouma emenu irau wau mufisane uwararo da owere fafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","I odoro i boana bobo awekaboini ama iseifeisa amaraku bobo awekaboini emenu anifeisa daabae meramawere ububa sabu da anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yesuma eno weike wei, enoya ewa furo guriguri uawero i sabu aneka odo i dai obi makeifeku odoroini nono i sabadi odoro da fafi, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","I odoro waa daiwere fafekua wei. Adinami nauwaro Godima yewa orofa akaka yaisina ubu ui i furoma awoena eno ere me nono dubuenaro eno da efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I waa daiwere fafeku odoe yafawereroma nono Godima da ma funaku ufironae eme yaisina feafisane enobairoma Godi Danu we mune odi orou imukada ibake i odo ma funaku ui. ");
INSERT INTO aby_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Enoba i odoro moi mima Keriso Dawae yewadoba iro ariya iro eawe wefekuie danu wake da nauforo wei. ");
INSERT INTO aby_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","I odoro we irukeka Kerisoini we irukeka we bou ukeka orouini uyafeisake buna ukekaini uke iruke erekaini eme irufisane eno ufeisake nono Godinu we mune odirie orouini we irufiakane ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","I yaisina yama efoisa ibake Nanu wake wemaro naukenewaa uawe wei! ");
INSERT INTO aby_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","I odoro Keriso Dawa eme ibe me orofaro ibinu wefeisaie emenu wake da naufoke iro da aniforo weike nono wei, Dawae moi uwara ooruro yaure ibinu wefeisaie emenu wake da naufone ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bidama eweka amukaku enaroma eweka isaraku enaroma bida mamaada edoro ukakuro eme yaisina eraisa i ari enoe sabunaku i Ba Eme Sini Mi fafekuro efoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yesuma emuabairo dubo waure weadama ibake eno wei, i feafeisa eme boubai iro iro aine ibifeisaro udu adama ifisane anifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","I dai waama imusu ari eraerabusa me sifeisaie aido sabunaku yewa iyama awoena eraisi eweka dumu sifekuro nono manabe edoro da ufekuro muina ureroma buruburu yafeisake dooro isafeisaro i urero ibinu bunama imusu ari erabusa yaisina amani amani ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eno ufeisaie i Ba Eme Sini Minu fareka ubu urero ufekuro efeisake ii weada imuka ure adirada efeisaro ou ubarenaroma Danu buna daiwereini Danu arakeka daiwere fafekuro efeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dawa fafekuke Danu aneru we odaifine kawia ufekuro anifeisake Danu we mune odirie irau orou eweka amukaku i enaroma eweka isaraku i enaroma eka ena ewa enaroma aboro aboro yaisina ane we mufiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesuma Danu iwoka ukeka oroubake eno wei, i boruba ana eaweke iwoka uawe wei. Eno weike wei, boruba ana awoena kua fare amukakuro eraisake obi kowaa idua farinua eno weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","34","Nanu wene wake enaenari ukeifekuro efoisaie i Ba Eme Sini Mi fafine ukaada aare aisamero enarinuro ukinua eno wefoisake iwoka sifoisaya wei. Yabake ba wake wemaro nauawe wei. Yewa ibinisa orou da feare me sifeisaro i wenebai yaisina ufekuro efeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ureini doo me sifekuro nono Nanu wakeye da me sifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesunu fafeku odo eme moima iwoka mero i urero ibinisa aneruini emua iwoka mero Godinu Amara Yesu Dawa iwoka mero nono i Godi Danu mane iwoka sine ibinua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noanu ibi i furo aneme aneme ukeibisa enaenari i Ba Eme Sini Minu fafeku furo enaenari ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Noanu ibi i furo waiya uwara ukaada urunaini adua iseibisake aruma aweka eme makaada munane makaneibisaro Noa danu boudi ubu uke me sinike ubarenaro amuiro obi nabana isarike oku nabana fariro eme yaisina feare me sika. Enobairoma i orou emuabairo fafine aareibi eraerabusa emua iwoka me. Emenu arara eraerabusa ukeibisaro oku nabana farike emua waure ane me siniro idua i yaisina iwoka uisa. Enoba i arie i Ba Eme Sini Minu fafeku odoro enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","I odoro eme una raara waiyaro waiya ukeifisisiie moi mi waure anifeisaro moi mi mane ibifeku. ");
INSERT INTO aby_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nono moi awekayai okea okeifisisiie moi aweka waure anifekuro moi aweka mane ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yanu Dai Minu fareka odo wai ufekuroba o dumudumunaku ya iwoka meba erenewaa uforo wei. ");
INSERT INTO aby_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yesuma nono wei, yewa wake imuke eawe. I uwara onami mima i waira ukeka minu dumuro fareka dawa iwoka sifironae danu uwara yawofineba da fare waira ukaada danu uwara da ma merama ufinea wei. ");
INSERT INTO aby_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","I ari enoe i Ba Eme Sini Minu fareka odo ya iwoka me ibake yawokenewaa ufone weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Moi dai mima danu waiya ukeka mi danu uwaraini waiyaini danu eraerabusa yaisina yawofine odiro i mima i goi orou emenu uruna makeibirie. Eno ukeibi ibaie irauaiai ukeibiba me ariya weike dubuenaro fare efine ania wei. ");
INSERT INTO aby_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Enaenari i yawokeka mima fafekuro danu waiya ukeka mi irauaiai ufekuro efekuke dawa we ma irauaiai ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yesuma nono wei, ba wake wemaro nauawe wei. I yawokeka mima danu eraerabusa yaisina yawofine mune odifekua wei. ");
INSERT INTO aby_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Nono moi koroko waiya ukeka mima eno we imufeku, nanu dai miye sabu da fafekua eno we imufekuke danu demuiro waiya ukeka orou usima ufiakuke urunaini ara adua i awara merama oroubairo ibaada ise ake ukeifekubaie danu dai mima fenaku fafeku. ");
INSERT INTO aby_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eno uke fafekuke dawa fanisi mafekuke meomao weeka oroubairo siane odifekuro iro emema nio ake fagigi yaraada oferibake ii wefeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Godinu ure yawokekae yewa wake ari Yesuma eno wei. I aruaruma denima (10) emenu ramefa mukake i aweka muneka mi fou ufisane anisa. ");
INSERT INTO aby_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Moi aruaruma fai (5) emenu awarae bunawerero nono moi aruaruma fai (5) emenu awarae buna me. ");
INSERT INTO aby_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I awara buna me aruaruma anifisane ukaada emenu ramefa mukake nono aduaini mune da uisake anisa. ");
INSERT INTO aby_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anisaro nono i awara buna aruaruma emenu ramefaini aduaini kawaburo iise mukake anisa. ");
INSERT INTO aby_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","I aruaruma yaisina anisabaie i aweka muneka mi fare dauiro me ane ekake ane nauka aisa. ");
INSERT INTO aby_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nauka aine ibisaro dumu abanaro ena aweka muneka mi ido aarakuba aafoke eforo eno daiwere weisaro nauisa. ");
INSERT INTO aby_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","I aruaruma yaisina nauisake uyakake ramefanu edoro ma daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eno uisabaie i awara buna me aruarumama i awara buna aruaruma faibairo (5) eno weisa, iya ramefa adua meya adua maisawe weisa. ");
INSERT INTO aby_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eno weisaro i awara buna aruarumama eno weisa, iyabairo adua daiwere meba yaini iyaini demuiro da iifeisia aniaweke sidowa oroubairo oima make muawe weisa. Eno weisa ibake anisa. ");
INSERT INTO aby_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aneibisabaie dubuenaro ena aweka muneka mi ido fariro i uke bou uisa aruarumaini dawaini danu aweka muneka uruna ifisane uwara ubarenaro amuisake aisame ko uka. ");
INSERT INTO aby_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nono dubuenaro ena awara buna me aruaruma fakake aisame udiro enare ibaada eno weisa, dai waria mi, ko woromiaro uwara ubarenaro amufe weisa. ");
INSERT INTO aby_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Eno weisaro i mima eno wei, ya na iwoka meba ko da woromimaua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Enoba i Dai Waria Minu fareka wai ufekuroba o dumudumuro ari ya iwoka me ibake erenewaa ukaada yawokenewaa uforo Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuma eno wei, Godinu ure yawokekae yewa wake ariya wei. Moi mima moi orofaro anifine ukaada danu waiya ukeka orou weiro dawabairo faka. Fakaro emua danu waiyaini uwaraini eraerabusa yaisina yawofisane wei. Eno weike danu waiya oroubake oi marie. ");
INSERT INTO aby_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Moi mibake fai dausini (5,000) kina maike nono moi mibake du dausini (2,000) kina maike nono moi mibake wani dausini (1,000) kina mai. I eme una buuba emenu buna imusu imusu ibake emenu oi imusu imusu marie. I oi make me sinike iroma moi orofaro ani. ");
INSERT INTO aby_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aniro i fai dausini kina muni mi sabu anike bisinesi waiya ukaadae moi fai dausini kina munike duboro odiro ibi. ");
INSERT INTO aby_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Enaenari i du dausini kina muni mima sabu anike bisinesi waiya ukaadae moi du dausini kina munike duboro odiro ibi. ");
INSERT INTO aby_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nono i wani dausini kina muni mima danu dai minu oi munike doo daunike ena oi doo ubarenaro fe odike yawe ure odike ani. ");
INSERT INTO aby_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Emenu dai mi moi orofaro anike oya keuwere ibeebe nono owerike fari. Goiro farike danu oi mariero waiya ukeibisa orou waiya aneme aneme ukeibisa ibai iwoka ufine emua weiro dawabairo faka. ");
INSERT INTO aby_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dawabairo fakaro i fai dausini kina muni mima danu moi fai dausini kina oi duboro waure farike eno wei, dai mi, ama nabake fai dausini kina makararo nono nama moi fai dausini kina duboro odinea mua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Eno weiro danu dai mima eno wei, ae gienabu irauaiai waiya ukaku miya wei. Ae okoanaku manararo irauaiai yawokinuba daiwere odimauro yawofakua wei. Eno weike wei, nabairo aare ibaada rooro ua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nono i du dausini kina muni mima farike eno wei, dai mi, ama nabake du dausini kina makararo nono moi du dausini kina duboro odinea mua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eno weiro danu dai mima eno wei, ae gienabu irauaiai waiya ukaku miya wei. Abake okoanaku manararo irauaiai yawokinuba daiwere odimauro yawofakua wei. Eno weike wei, nabairo aare ibaada rooro ua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nono dubuena kai i wani dausini kina muni mima danu dai mibairo farike eno wei, dai mi, ae arawere yawokaku miya wei. Ae arawere yawokada waiya wawe me nono uruna munakuke aneme aneme ode dakuke nono munaku wei. ");
INSERT INTO aby_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Enoba na iwoka sinaada abake ia sinaada anu wani dausini kina dooro daune fe odea anu oi idua mua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Eno weiro danu dai mima eno wei, ae waiya koroko merama miya wei! Nae arawere yawokeka mi. Waiya wawe me uruna muneibakuneke aneme aneme ode dakakuneke munakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ibai iwoka ukakuba mekema anemebake nanu oi banikaro ode dauiro iro oi duboro odifisaro fare mune daune wei? ");
INSERT INTO aby_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Eno weike wei, danu wani dausini kina mareke muaweke i fai dausini kina muni mibairo maewe wei. ");
INSERT INTO aby_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","I eraerabusa keuwere mibairo mune mafekuro mufeku. I mi dawabairo eraerabusa keuwere ibifeku wei. I okoa musinaku orounu okoanaku eraerabusa mareke mufeku wei. ");
INSERT INTO aby_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Eno weike wei, i merama waiya koroko mi muaweke i dumuwere aweawe orofaro mune siaawero iro emema emenu oferibake nio ake fagigi yaraada ii wefisa i dai mima eno weia Yesuma i wake emuabairo eno wei. ");
INSERT INTO aby_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","I Ba Eme Sini Mini danu aneruini edoro daiwerero fafeisaie Dawa Danu dai yaureka duboro yaufekuke eme yaisina Dawama yawofiaku. ");
INSERT INTO aby_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Idua yaufekuro i orofa akaka orouma Danu ibooro fafeisake enafeisa. Enafeisaro Dawama emua abanaro ma boroo yafiaku. I ari enoe i mamoe abu yawokeka mima mamoeini goudini ma boroo yare imusu imusu odaku enaenari i Ba Eme Sini Mima i mamoe abu ari orou Danu baena wana enaro odifiakuke nono i goudi abu ari orou Danu ewani enaro odifiaku wei. ");
INSERT INTO aby_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Odifiakuke nono i Dai Waria Mima Danu baena wana ena oroubake eno wefeku, Godima ya we ma irauaiai ukakua aarawe wefekua wei. Godima ureini doo ubu ukaada yanu yawokeka orofaini ubu uia aaraweke i orofaro yauawe wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na desini ukararo uruna mayaka. Na adua isa ukararo adua mayaka. Na imusu mi ari farero arie daiwere weisa. ");
INSERT INTO aby_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na wau erunaku baruke eneibisararo irau wau mayakaro rune. Na arama ukeibisararo unu koyaka. Na ana ebaro ibisararo Nabairo fare awaawa yaure odiaka wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Eno wefekuro Godinu wake naukeka orouma eno wefeisa wei, Dai Waria Mi, abo odoro desini uiyairo eraada uruna maisi? Adua isa uiyairo Abake adua maisi? ");
INSERT INTO aby_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Abo odoro imusu mi ari uke fariro arie daiwere weisi? Abo odoro Anu wau erunaku ekike irau wau maisi? ");
INSERT INTO aby_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Abo odoro arama daiwere uke ibiro eraada unu koki. Ana ebaro ibiro awaawa yaure oisi eno wefeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eno wefeisaro i Dai Waria Mima eno wefeku, ba wake wemaro nauawe. nanu wake naukeka oroubake eno uke yareibirieka ie Nabairo ukeibisaya wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yesuma eno weike nono wei, Dawa eno wefekuke Danu ewani ena wana enaro oroubake eno wefeku, ya meramawere orou, Godima ya we ma irauaiai uke dakaku. Godima i feare me inaae seidanini danu anerubake ubu ui. Nabairoma aniaweke i inaaro ibiawe wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na desini ukararo uruna make dayaka, Na adua isa ukararo adua make dayaka. ");
INSERT INTO aby_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yabairo imusu mi ari farero arie wake we da uisa. Na arama daiwere ukeibisararo unu kore dayaka. Ana ebaro ibisararo Na awaawa yaure ode dayaka eno wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eno wefekuro i merama orouma wefeisa, Dai Waria Mi, abo odoro desini uiyairo adua isa uiyairo imusu mi ari farike arama uike oferi waurike ana ebaro ibiro ekike A unu kore da uisi wefeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eno wefeisaro wefeku, yabake ba wake wemaro nauawe. Nanu wake naukeka orou unu kore dakeibisaie Na unu kore dakeibiyakaya eno wefekua wei. ");
INSERT INTO aby_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","I orouma i feare me inaaro anifeisaro Godinu wake irauke naukeka orouma me ibene ibene ibifeisa orofaro anifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesuma i wake we me sinike Danu iwoka ukeka oroubake eno wei, odo raarayai me sifekuro i Godima Isaraera orou Idifiroma waure ani banau uruna odo ido fafeku wei. I odoro i Ba Eme Sini Mi mufeisake moi orounu wanaro mame odifeisaro korosiro ure odifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","I dai ofereni ode sibore sianeka orouini i Du orounu bisara orouini i bokai ofereni ode sibore sianeka minu uwara ubarenaro amuke ku siane ibisa. I bokai minu ibiye Kaiyafasi. Danu uwararo anisake Yesu fema yabafisake umu wana naama uwafisake ma feafisane ukaada aneme aneme ufeisake ufeisa ibai we naufisane anisa. ");
INSERT INTO aby_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ane fakake eno weisa, i moi orouma dino unao ufeisake iyaini uranao ufeisaba ibake i banau iseifeisi odoro Yesu da mufeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yesu Bedeni goiro ane farike yauri. Dawae i beko mame ibi mi Saimoninu uwara ubarenaro anike yauriro moi awekama irauaiai urumuma imusu ari i adua danu make oi muneka oi daiwere omama ubu uisa kawaburo waure farike eribaie Yesu uruna iseibiro i awekama ena irau urumuma imusu ari aduama Yesu Danu iiriro ma oiniro ena adua Yesunu iiriro isari. ");
INSERT INTO aby_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eno uiro i awekae Yesu Danu iwoka ukeka orouma ekake dino daiwere ukaada eno weisa, anemebake me sara ma oininu weisa? ");
INSERT INTO aby_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I adua make moi muneroma oi me oroubairo mafiaronae irauaiaiya weisa. ");
INSERT INTO aby_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Eno weisaro Yesuma emenu imuke ibisabai iwoka ukaada eno wei, i awekabake dino wake da weawe wei. Dawae Nabake irauaiai ukinua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yesuma Danu iwoka ukeka oroubake nono wei, eraerabusa me orou yabairo aine wai ure ibeifeisa nono Nae yabairo aine wai ure da ibimaua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Eno weike nono wei, i adua Nanu iiriro ma oininuie Na ooru ufokaisa ibai uke bou ukinua eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yabake ba wake wemaro nauawe wei. Godinu wake i orofa akaka aboro aboro enaada yewa awekama Nabairo ukinu ibai we eneifeisaro naufeisake dawa ukinubai imukeifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Diudiasi Ikariada dawae Yesunu moi duwere (12) iwoka ukeka moi mi. Dawama i dai ofereni ode sibore sianeka oroubairo anike eno wei, Yesu mumauke yanu wanaro mame odimauro nabake anemerabu mafokoisa wei? Eno weiro dawabake siriwa oi dedi (30) makaro muni. ");
INSERT INTO aby_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","I oi munike Diudiasima Yesu abo odoro mune emenu wanaro mame odifiaku ibai yodia ukeibi. ");
INSERT INTO aby_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I ure wawareka iraa yisidi me buredi banau odo ido fari. I odo ido fariro Danu iwoka ukeka orouma Dawabairo fakake eno weisa, Anu Babae Godima Isaraera orou Idifiroma waure aneka banau uruna aboro uke bou ufeisi weisa? ");
INSERT INTO aby_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eno weisaro emuabake eno wei, yeka goiro moi mibairo aniaweke dawabairo eno weawe, iyanu Sisa Mima eno wenu, Nanu feareka odo farinuba ibake anu uwararo Naini Nanu iwoka ukeka orouini i banau uruna ifeisi eno wenua weawe wei. ");
INSERT INTO aby_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eno weiro Danu iwoka ukeka orouma Danu wei wake enaenari ane weisake uisake banau uruna uke bou uisa. ");
INSERT INTO aby_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dumu dumunaku siniro Yesuini Danu iwoka ukeka orou duweroini (12) uruna iseibisa. ");
INSERT INTO aby_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Uruna iseibisabaie Yesuma eno wei, Nanu ba wake wemaro nauawe wei, iya yewa ibinisi kuro moi mima Na we sibofarakuro mune ane korosiro ufokaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesuma eno weiro Danu iwoka ukeka orouma imuka merama imukada eno weisa, naba ainadei ari eno mane yaisina eno weibisa. ");
INSERT INTO aby_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eno weibisaro Yesuma eno wei, i miye Naini yewa uruna naberoro demuiro mufekuie dawama Na we sibofaraku miya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yesuma eno wei, i Ba Eme Sini Mi feafekua Godinu bukaroma eno weaku ibake enaenari feafekua wei. Nono Dawa we sibofaraku mibake Godima fanisi daiwere mafekua wei. Eno weike nono wei, i Na we sibofaraku mi danu amaema dawa da dofironae irauaiaiya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yesuma eno weiro Diudiasi i Yesu we siboi mima eno wei, Dai Waria Mi, naba ainadei wei? Eno weiro Yesuma wei, euwa ba weakua aya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yesuini Danu iwoka ukeka orouini uruna isa. Uruna isaada Yesuma buredi munike guriguri uike ma birabira yarike Danu iwoka ukeka oroubairo makaada eno wei, yewae nanu ofeya muaweke iawe wei. ");
INSERT INTO aby_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yesuma nono i fanigini munike Godibairo we ma irauaiai uike Danu iwoka ukeka oroubairo makaada eno wei, ya yaisina iawe wei. ");
INSERT INTO aby_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yewae nanu iwama Godinu awoena arararo uke makaneka ma ara ukakuke eme keuwerebairo isarakuke emenu merama merama ukeka urokaku wei. ");
INSERT INTO aby_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yesuma nono wei, ba weakune yewa gureifi naa didi kai iduda yaini isakuneba nono da ise ibimauke Na Babaenu yawokaku odo fafekuie Danu yawokaku orofaro yaini Naini nono demuiro ifeisia wei. ");
INSERT INTO aby_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eno weiro Yesuini Danu iwoka ukeka orouini yaura kai weisake Godi we ma irauaiai uisake i uwara ubarenaroma fakake Oriwa oraararo amuke anisa. ");
INSERT INTO aby_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Amuke ane fakake Yesuma emuabake wei, ya yaisina eweira dumuro Na medifokoisaya wei. Eno weike wei, Godinu bukaroma eno weaku wei, i mamoe abu yawokeka mi umauro i mamoe abu yaisina fiake ia iyare anifeisaya weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesuma Danu iwoka ukeka oroubairo nono wei, Godima Na ma uyafarakuro Nako Gareri orofaro animauro ya yaisina aima iro ane fafoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yesuma eno weiro Fidama wake bunawereroma ma owerike eno wei, i orou yaisina Abake maru ufeisake A medimekaisaroma nono nae A da medimauanea wei. ");
INSERT INTO aby_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuma Fidabake eno wei, Nanu ba wake wemaro naua wei. Kawama kai kokoroko eweira dumuro yama wefekuie ako Nanu ibi buuba we ma fe yaraada meo wefakua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yesuma eno weiro Fidama ma owerike eno wei, Aini feamane wemauie Abake meo da wemaua wei. Fidama eno weiro Yesu Danu iwoka ukeka orou yaisina Fida danu wei enaenari weisa. ");
INSERT INTO aby_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuini Danu iwoka ukeka orouini moi orofaro anisa. I orofanu ibiye Gesemani. Iro ane fakake Yesuma emuabake eno wei, ewado yaure ibiawero ekanaku animake guriguri uma wei. ");
INSERT INTO aby_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","38","Eno weike Fidaini Debedinu amarayai Deimisini Dionini we murieke ani. Anike imukari daiwere ukaada emua una buubabake eno wei, Nanu imukari ukaada imuka inimubi ukaku ibake Na feareka imuka imukakunea wei. ");
INSERT INTO aby_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eno weike emua medirieke funaku eka anike iboo yanakaisari uike guriguri ukaada eno wei, Babae, yewa merama ure yanakewere Nabairoma imusu anifine wefakuie anifekua wei. Eno weike nono wei, Nanu arara da uake Anu arara mane ua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Eno weike Danu iwoka ukeka oroubairo fare eribaie emua nauka aine ibisaro eraada Fidabake eno wei, fu kainaku sininuro Na anemebake yawoke daneka wei? ");
INSERT INTO aby_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yawokenewaa uaweke guriguri uawe uke ereka meramawere yabairo fanao ufekuro merama unao ufoisaya wei. Eno weike wei, yanu imukanu arararo ufoisaie nono yanu ofeye buna me ibake da ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eno weike nono anike guriguri ukaada eno wei, Babae, yewa merama ure yanake Nabairoma da anifekuie Anu arara umauke feamaua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eno weike nono uyarike Danu iwoka ukeka oroubairo faribaie emenu naisa nauka ariari uiro nauka aine ibisaro erie. ");
INSERT INTO aby_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","45","Erieke nono owerike ani. Anike guriguri ukaada dawako wei enaenari weike nono uyarike Danu iwoka ukeka oroubairo fari. Farike emuabake eno wei, idua nauka aine ibaada ko yaraisa wei? I eweka funaku sininuba i Ba Eme Sini Mi meramawere orounu wanaro mame odifeisa wei. ");
INSERT INTO aby_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uyaewero anife weike wei, Na we sibofari mi ido farinua eawe wei. ");
INSERT INTO aby_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuma eno weibibaie Diudiasi moi duwero (12) iwoka ukeka mini eme keuwere emenu goreini emenu dai bauini waukake faka. I dai ofereni odeka orouini Du orounu bisara orouini emuama we odaisa ibake faka. ");
INSERT INTO aby_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Adinaro Diudiasi, i Yesu we siboi mi dawama i meremere oroubairo wei, ereiforo abo mi nama yabamauke oo umauie dawa ena mi iduaba fare muforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Diudiasima Yesubairo farike eno wei, Dai Waria Mi, yaure ibinu eno weada fare yabaike oo ui. ");
INSERT INTO aby_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eno uiro Yesuma wei, naiye, anu aneme aneme ufane wefakuie ua wei. Eno weiro i faka orouma fakake Yesu yabaisake wanayai mune ane derena enaro uwaka. ");
INSERT INTO aby_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eno ukeibisa ibake Yesunu moi iwoka ukeka mima danu bau fausiroma ma youre munike i dai ofereni ode sibore sianeka minu waiya ukeka minu ome umane kasiniro isari. ");
INSERT INTO aby_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Eno uiro Yesuma dawabake eno wei, anu bau fausiro odia wei. Eno weike wei, i bauma uraneka oroue enaenari bauma eno uke uranao ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yesuma nono wei, imuke ea wei! Na yewa orou da mufokone wemauie Nanu Babaebairo wemauro aneru keuwere we odaifekuro isare aafeisake Na unu kofokaisaya wei. Eno weike wei, Na eno umauie Godinu bukaro weaku i wake enaenari da ufeku wei. ");
INSERT INTO aby_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Godinu bukaroma i ari eno ufeku weaku ibake yewa orouma eno ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesuma eno weike wei, anemebake Na waira ukeka mi ari bauini omaini ure yanake ufokone faraisa wei? Eno weike wei, aine wai ure yewa yafa dai sosi uwara ubarenaro yaure ibaada ya we ma iwoka ukeibisara weike imuke eawe wei! Na yewa orou da mufokone wemauie Nanu Babaebairo wemauro aneru keuwere we odaifekuro isare aafeisake Na unu kofokoisaya wei. Eno weike nono wei, Na eno umauie Godinu bukaro weaku i enanari da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Godinu we bou ukeka orounu weisa enaenari ufine ibake eno ukaisaya wei. Eno weiro Danu iwoka ukeka orou yaisina Dawa meisake fiake ia iyare anisa. ");
INSERT INTO aby_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","I Mosesinu darawadu we ma iwoka ukeibisa orouini Du orounu bisara orouini Kaiyafasi dawa i bokai ofereni ode sibore sianeka mi i orouma dawabairo fare yaure ibisaro Yesu muka orouma Yesu Kaiyafasibairo waure faka. ");
INSERT INTO aby_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yesu waure fareibisaro Fidama yafawereroma eroke eroke emenu umuro ani. Anike Kaiyafasinu uwara kekeuro fe yare ibaada i furisimani orouma Yesu aneme aneme uke yareifisa ibai efine uwara kekeuro fe yare ibi. ");
INSERT INTO aby_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","61","I dai ofereni ode sibore sianeka orouini i kanisoro orouini emua yaisina Yesu meo wayai wefisake Yesu ma feafisane i daaba yodia uisa. Yodia ukeibisabaie eme keuwere emuabairo fakake Yesubake meomao wayai weibisa. Eno uke meomao wayai weibisa ibake Yesu ma feafisa daaba fou ure dauisa. I orouma eno mane meomao wayai weibisaro moi miyaima fakike eno weisi, yewa Mima eno weia weisi, Godinu dai sosi uwara ma doroo yamauke odo buuba me sifekuro nono ma enamau weia weisi. ");
INSERT INTO aby_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eno weisiro i bokai dai ofereni ode sibore sianeka mima uyarike Yesubairo eno wei, i wake naukadama anemebake moko wake we dauke ibinu wei? ");
INSERT INTO aby_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Eno weiro Yesu wake we dauiro wei, i miyai anemebake A wayai weaisi wei? Eno weike i bokai dai ofereni ode sibore sianeibi mima Yesubake nono wei, Ae i Mesaia, ba Godinu amara? Anu moko wake Godinu ibiro ba wearo naufe wei. ");
INSERT INTO aby_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Eno weiro Yesuma ma owerike eno wei, anu weaku wake ba weakua wei. Eno weike wei, ewado awoenanaku i Ba Eme Sini Mi i bunama imusu ari Godinu baena wana enaro yaufekuke nono dubuenaro i ou mameifeku iro fafekuro efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesuma eno weiro i bokai dai ofereni ode sibore sianeka mima danu imuka merama daiwere ui ibake danu dubo barukeka yafawere wau ma girisada eno wei, Dawae Godibake merama wake wenuro naukisiba moi wayai weeka orounu wake da naufeisia wei. ");
INSERT INTO aby_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eno weike i kanisoro oroubairo nono wei, Dawabake aneme ufoisa? Eno weiro emuama eno weisa, Dawa Godibairo wake merama wenuba feafekua weisa. ");
INSERT INTO aby_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Eno weisake Yesunu iboo naisaro wisiomu ukaada Danu naisa wauma uwane dadau uke oisake wanama omeafera uraada eno weibisa, aina mima A uyainu weibisa? Ae Kerisoya iyanu ibi wearo naufe weibisa. ");
INSERT INTO aby_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","I orouma Yesu eno uke yareibisabaie Fida Kaiyafasinu uwara kekeuro yaure ibaada iroma ereibi. Yaure ibaada ereibiro moi arumama Fidabairo farike eno wei, ae Yesu Gareri Mini demuiro ibeibisia wei. ");
INSERT INTO aby_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Eno weiro Fidama i orou emenu ibooro yaure ibaada eno wei, anu weaku wake na iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Fidama eno weike ia iyarike ane sebo enaro yauri. Ane yauriro nono moi arumama dawa fare eraada i ibisa oroubairo eno wei, yewa mini Yesu Nasaredi goi Mini emua demuiro ibisia wei. ");
INSERT INTO aby_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eno weiro Fidama ma owerike eno wei, na ba weakune weike wei, i mi na iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dubuenaro i me sara enare ibisa orouma Fidabairo fakake eno weisa, ade Yesu Danu moi iwoka ukeka mideye weisa. Eno weisake weisa, aini Danu wake demuiro weibisiba ae Danu moi iwoka ukeka mi ere iwoka ukaisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eno weisaro Fidama wei, nae meo me ba weakunea wei. Eno weike wei, na meo wemauie Godima na fanisi mafarakua wei. Eno weike wei, i mi na iwoka meya eno meo wei. Eno weibiro kawama kokoroko ido yama wei. ");
INSERT INTO aby_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kawama kokoroko yama weiro Fidama nauike Yesunu adinaro wei wake imuike, Yesuma eno wei, kawama kai kokoroko wefekuie ako Nanu ibi buuba we ma fe yafakuke meo wefakua wei, i wake imuike aweawero anike imuka inimu daiwere ukeibiro ii daiwere wei. ");
INSERT INTO aby_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wai uriro i dai ofereni ode sibore sianeka orouini i Du orounu dai orouini emuama Yesu ma feafisane daaba yodia ukaada emenu emenu we makaka. ");
INSERT INTO aby_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","We makakake Yesu mukake Danu wanayai mune ane derena enaro naama uwane karisake Dawa Romani gaemani dai yawokeka mi Faeredibairo waure ane oisa. ");
INSERT INTO aby_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Eno uisaro Diudiasi, Yesu we siboiro ane muka mima eribaie Yesu ma feafisane uisaro erike danu imuka ma owerike i maka siriwa oi dedi (30) munike i dai ofereni ode sibore sianeka orouini i dai orouini emuabairo anike ena oi owere mafiane ukaada eno wei, Yesu Dawa merama me mi, Dawa irauaiai miro ma feafone ukaisa ibake na ba me merama uea wei. Eno weiro i dai orouma eno weisa, ie iyanu merama mero ie anu merama weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eno weisaro Diudiasima i siriwa oi i dai sosi uwara ubarenaro sianike owerike ani. Anike danu onami naa doike feari. ");
INSERT INTO aby_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I dai ofereni ode sibore sianeka orouma i oi mukake eno weisa, ie eme ma feareka oiya weisa, eno weisake weisa, ie iwa oiya weisa. Iyanu imusu mane i oi i dai sosinu oi duboro da odifeisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eno weisake moi wake we makakake dooma okea ubu ukeka minu doo imusu orou feafisaro emua iro ooru ufiakane ibake i doo oima make muka doo. ");
INSERT INTO aby_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eno uisa ibake awoena i dooe iwa doo weaisa. ");
INSERT INTO aby_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Godinu we bou ui mi Derimaiyama adinaro wei ibake enaenari uka. Derimaiyama eno wei, moi Isaraera orouma Dawabake siriwa oi dedi (30) mafeisia weisa. I oi mukake okea ubu ukeka minu doo oima make doo muka. Godima nabairo eno weaku ibake weakune Derimaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu i dai Romani gaemani yawokeibi minu ibooro enari. Enariro i dai mima eno wei, Ae i Du orounu dai yawokeka kini miba me wei? Eno weiro Yesuma dawabake ma owerike eno wei, anu weaku wake ba weakua wei. ");
INSERT INTO aby_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eno weiro i dai ofereni ode sibore sianeka orouini i Du orounu bisara orouini emuama Yesu wayai weisa. Wayai weisaro Yesuma moko wake we daui. ");
INSERT INTO aby_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yesu moko wake we daui ibake Faeradima Yesubake eno wei, emenu wayai weisa ibai naukinu wei? Anemebake moko wake we dakinu wei? ");
INSERT INTO aby_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Eno weiro Yesu wake we dakaada emenu wayai weisa wake moinaku moko we dauiro i dai yawokeka mima imuka foria ui. ");
INSERT INTO aby_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Godima Isaraera orou Idifiroma waure ani banau uruna i odoro oya moi moiro Isaraera orouma emenu arara aneme wefisaro enaenari emenu dai yawokeka mima ana ebaro ibeibisa orou una deidemu ma woromeibiro fare aneibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","I odo moi meramawere mi danu ibiye Barabasi, dawa ana ebaro ibi. ");
INSERT INTO aby_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","I eme yaisina idua fare ku uisaro Faeradima emuabairo eno wei, abo mi ma woromimau wei? Barabasiba Yesu Keriso weaisa mi ma woromimau wei? Ya weawero nauma wei. ");
INSERT INTO aby_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I orouma Yesubake ararua uisake Faeradinu wanaro mame oisaro Faeradi ibai dawa iwoka sini. ");
INSERT INTO aby_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nono Faeradima i kodo ureka orounu yaureka duboro yaure ibaada i wake weibaie danu awekama wake fo we odaike eno wei, Yesu Dawae irauaiai miya Dawa mediaro anifi wei. Awoena na kuberoma Dawa eneke imukari daiwere unea Dawa mediaro anifi wei. ");
INSERT INTO aby_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nono adinaro i dai ofereni ode sibore sianeka orouini i Du orounu bisara orouini emuama i ku uke ibisa oroubairo eno weisa, Faeradima aneme aneme wefekuie Barabasi ma woromiake Yesu ma feaa eno weawe weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","I dai yawokeka mima nono wei, i Barabasini Yesu eyakaweke abo mi ma woromimau ibai weawero enaenari nauma wei. Eno weiro Barabasi ma woromia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eno weisaro Faeradima i Yesu Keriso weaisa mibake aneme umau wei? Eno weibaie korosiro ure odia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Eno weisaro Faeradima Yesu Dawae aneme merama ukinu wei? Eno weibaie dino daiwere uisake wake daiwereroma korosiro ure odia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Faeradima eriebaie i orouma danu wake nauke dauisake urafisane uisa ibake Faeradi dawa medike adua ma oinike i orounu ibooro danu wana wanadu ukaada eno wei, Yesu Danu feareka ibake moi aneme aneme da umauba Yesu Dawa feafekuie nanu merama meya wei, yanu mane aneme aneme ufone wefoisaie uawe wei. ");
INSERT INTO aby_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eno weiro moi orouma ma owekake eno weisa, Yewa meramae iyaini iyanu amarananakubairo ibeifekua weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eno weisaro Faeradima Barabasi ma woromike weiro Yesu usima uka. Ukaro Faeradima Yesu korosiro ure odifisane emenu wanaro mame odirie. ");
INSERT INTO aby_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","I dai yawokeka minu meremere orouma Yesu waure ane i dai yawokeka minu uwara udiro oisa. Oisaro i ame orou yaisina Yesubairo faka. ");
INSERT INTO aby_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Fakake Yesunu wau ma kukukake i dai yawokeka kini orounu kokoiwerero yafa wauma baruke oisa. ");
INSERT INTO aby_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eno uisake sinisini bobo naa didima kini orounu mogoiso ari ubu uisake Yesu Danu iiriro ure afua umane oisa. Eno uke oisake uri kuure Danu baena wanaro mame oisake emenu ifoma kodudu yanakada uke irukada weisa, Du orounu kini bauwakanaku eawe eno mane weibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eno ukake Danu ibooro wisiomu ukake i urifu mareke mukake Yesunu iiriro uka. ");
INSERT INTO aby_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eno mane Yesu uke irukebe i kokoiwere wau ma kukukake Danu wauma baruke oisake korosiro ure odifisane Yesu waure anisa. ");
INSERT INTO aby_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yesu korosiro ure odifisane Yesu korosi makaro wauriro aneibisa. Aneibisabaie Sairina orofa moi mi danu ibiye Saimoni dawa emuabairo fariro ekake eno weisa, iyabairo aarake yeka minu korosi waua weisaba ibake farike wauri. ");
INSERT INTO aby_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wauriro ane Gorogada orofaro faka. (I orofa ibinu ubiye bokai kaibai mane orofa.) ");
INSERT INTO aby_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iro ane fakake wainini ena abu ubaro ibaku uwini ma bui ukake Yesubairo nifu ubu uisake maisa. Maisaro fofobai mane yabune ike ba bai ise daui. ");
INSERT INTO aby_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I meremere orouma Yesu korosiro ikokoma ure dabame oisa. Korosiro ikokoma ure dabame oisake Danu wau aina mima mufeku ari weisake i wauma kasi dodoo ukeibisa. Eno ukaada yaure ibisake Yesu ereibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","I ame orouma wayai weeka owaowa uisake korosi dubo Yesunu iiri duboro ure oisa. I owaowa uisa wakeye eno, yewae Yesu, i Du orounu dai yawokeka kini mi. ");
INSERT INTO aby_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","I orouma eno uke oisake nono moi waira ukeka miyai emuaini korosiro ikokoma ure dabame oisa. Moi waira ukeka mi Yesunu baena wana enaro ure oisake nono moi waira ukeka mi Danu ewani ena wana enaro ure oisa. ");
INSERT INTO aby_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Yesu korosiro ikokoma ure dabame oisaro i fare aneibisa orouma Yesu we irukada bokai gido gado ukaada yo weisake weisa, Ama dai sosi ma doroo yafake odo buuba me sifiro nono ma enafane weia Anu onami ma wiroa weisa. A Godinu Amaraba me weisa? A Godinu Amarabaie korosiroma isaaro efe weada eno uke we irukeibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","I dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini i Du orounu bisara orouini emua yaisina Yesu we irukada eno weisa, Dawa imusu orou ma wirokakuneke nono Danu onami anemebake ma wiroke dauke ibinu weibisa. Dawa iya Du orounu dai yawokeka kini mibaie korosiroma isafekuro efeisiie Dawa ba Godinu Amaraya we imufeisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dawae Godi imukakua weisa. Nae Godinu amaraya wenuba Godinu imukari Dawabairo ibifekubaie Godima Dawa unu kofiro efe eno uke we irukada weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nono i waira ukeka miyaima enaenari Yesubairo we irukeibisi. ");
INSERT INTO aby_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yesu korosiro ikokoma ure dabame oisaro ibeebe eweka okoro munike edoro uke da uike dumu sine ibi. Eno uke ibiro eweka arisi yare isare abanaro siniro nono eweka edoro ui. ");
INSERT INTO aby_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eweka ane abanaro siniro Yesuma daiwere weike eno wei, Irai, Irai Rama Sabadani, wei. I wei wake danu ubiye Nanu Godi, Nanu Godi, anemebake Na medinara weadama wei? ");
INSERT INTO aby_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yesuma eno weiro i ku uke siane ibisa orouma naukake moi orouma eno weisa, yeka Miye Iraida u weakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eno weisaro moi mima anike farai furi munike yafa ana kairo naama uwanekarike kimurima imusu ari ana kai idudabai kouro ma iyarike Yesu mafiro ifine ani. ");
INSERT INTO aby_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mafine aniro moi orouma eno weisa, Dawa Iraida u weakua media weisa, mediaro Iraidama fafike Dawa ma wirofekuba me ari efe weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuma nono daiwere weike i deima ba feari. ");
INSERT INTO aby_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesu feariro me sinibaie i Du orounu dai sosiwerero ooru raarayai abanaro enare kuure oisa dai burudu wau ekua barunaroma gagane isare aare ubiro fari. Eno uike i doo yaisina amani amani uiro eme odeibisa ara orofa yaisina eba sini. ");
INSERT INTO aby_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eba siniro adinaro Godinu wake naukada feareibisa orou Godima emua ma uyarie. ");
INSERT INTO aby_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nono dubuenaro Yesu fearekaroma uyariro i araroma uyaka orouma Derusaremu goiro anisaro eme keuwere emuama i orou erieka. ");
INSERT INTO aby_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I dai ame Kafudenini danu ame orouini emua Yesu yawokada ibisaro i doo yaisina amani amani uiro emua yaisina imuka foria uisake eno weisa, yewae Godinu ba Amara ubiya weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Awekabo keuwere ekararo bi mame ibaada iroma Yesu ereibisa. I awekaboe Yesunu umuro enaada Gareriroma ane Yesu yawokeibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Moi awekabo emenu ibiye yewado, Meri Megidarini Deimisini Diosefu emenu amae Merini Debedinu amarayainu amaeini i awekaboini nono moi awekaboini emua yaisina ekararo bi mame ibaada iroma Yesu ereibisa. ");
INSERT INTO aby_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dumudumu sineibibaie moi eraerabusa keuwere bobo Arimadia goi mi danu ibiye Diosefu dawama fari. I miye Yesu Danu moi iwoka ukeka duwero (12) mi meroma Danu moi iwoka ukeka mi. ");
INSERT INTO aby_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dawama farike Faeradibairo ane farike Yesunu ofe mufine ani. Aniro Faeradima danu ame oroubairo weiro enaenari Yesunu ofe mune maka. ");
INSERT INTO aby_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Makaro Diosefuma Yesunu ofe munike awoena inanakeo wauma Yesu oba ui. ");
INSERT INTO aby_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Oba uke me sinike danu awoena oma eraboro odike dai oma ferawere ma ubere ubere uke anike aisame eba ko urike ido medike ani. ");
INSERT INTO aby_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Diosefu dawa eno ukeibiro Meri Megidarinini moi Merini emua yaure ibaada iroma ereibisi. ");
INSERT INTO aby_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","I banau uke bou ukeka odo me siniro wai uriro i dai ofereni ode sibore sianeka i orouini Ferosi orouini emuama Faeradibairo fakake Yesubake eno weisa, i meo mi me ibaada i furo eno weia weisa, eweka odo buuba me sifekuro nono uyamau wei ibake abairo faraisia weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Eno weiro nauisiba uyanao ufekua anu ame orou wearo Danu ara uisa orofa odo buuba yawofisa weisa. Eno weisake nono weisa, Danu iwoka ukeka orouma Danu ofe waira unao ufeisake fearekaroma uyarinu wenao ufeisaya wearo i orofa yawokenewaa ufisa weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eno weisake nono weisa, eno ufeisaie Danu dubuena meo we irukekae daiwereya eno weisa, nono Danu adinaro meo we irukekae okoanakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eno weisaro Faeradima wei, yabairo ame orou ibinisaya emua waure ane odiawero yawofisa wei. ");
INSERT INTO aby_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eno weiro emua idua anisa. Ane fakake i dai oma fera aisame dadau uke oisa oma anama ma dabamamisake naama widu uisake ame orou oisaro yawokeibisa. ");
INSERT INTO aby_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabadi odo me sini wai awanakuro Meri Megidarinini moi Merini Yesu ooru uke oisa orofaro anisi. ");
INSERT INTO aby_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ane fakibaie doo daiwere amani amani ui. Godinu aneru ureroma isare aarike i dadau uke oisa oma ma ubere ubere uke ane odike i oma duboro yaure ibi. ");
INSERT INTO aby_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Danu ofe ubue bida ari. Nono danu waue inana keowere ure bira ari. ");
INSERT INTO aby_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","I Yesu ooru uke oisa orofaro i yawokeibisa orouma aneru ekake ia daiwere iyakake kiu weada feareka orou ari sika. ");
INSERT INTO aby_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eno uisaro aneruma i awekayaibake ia da iyaawa wei. Eno weike wei, na iwoka yae i korosiro ure oisa Yesu yodia ukaisia wei. ");
INSERT INTO aby_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","7","Yesu Dawae ewado meya wei. Dawae uyarinua wei. Yesu Danu wei wake enaenari ukinu wei. I aneruma eno weike wei, aarawake Yesu Danu ooru uke oisaro aine ibi orofa eawake sabu aniawake Yesu Danu iwoka ukeka oroubairo ibai ane weawa wei. Aniawake eno weawa wei, Yesu Dawa fearekaroma uyarinuba Dawako Gareri orofaro anifekuro iro ane efoisaya eno weawa wei. Eno weike nono wei, yabake ba wake weakune wei. ");
INSERT INTO aby_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eno weiro nauisike Yesu ooru uke oisa orofa meisike ia iyarada imuka foria uisikema nono emua rooro ukaada Yesu Danu iwoka ukeka oroubairo wefisine durame anisi. ");
INSERT INTO aby_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aneibisiro Yesuma emua daabaro fou urieke eno wei, ya awekayai faraisi wei. Eno weiro emua Danu umu udiro iboo yanakada Yesubake guriguri uisi. ");
INSERT INTO aby_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Emua guriguri uke me sikiro Yesuma emuabake eno wei, ia da siawa wei. Yesuma i awekayaibairo nono wei, Nanu naiyemuku Gareri orofaro anifisake Na iro efokoisaya wei. Aniawake emuabairo i wake eno weawa wei. ");
INSERT INTO aby_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I awekayaima daabaro aneibisibaie i Yesunu ooru yawokeibisa orouma Derusaremu goiro anisake i dai ofereni ode sibore sianeka oroubairo anisake emuabairo fakake i aneruma farike uiro eka eraerabusa yaisina wayai weisa. ");
INSERT INTO aby_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Eno weisaro i dai ofereni ode sibore sianeka orouma nauisake weisaro i Du orounu dai orou emuabairo faka. Fakake wake we naukada i ame oroubairo oi makaada eno weisa, i eme yaisinabairo eno weawe weisa, Danu iwoka ukeka orouma dumuro fakake iya nauka aine ibisiro Danu ofe waira ufisake mune anisaya eno ane weawe weisa. ");
INSERT INTO aby_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Eno weisake nono weisa, i Romani gaemani dai yawokeka mima i wake naufekuie dawabairo wefeisiro ya fanisi da mafiakua weisa. ");
INSERT INTO aby_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eno weisaro i ame orouma i oi mukake anisake enaenari eno meo weisa. I Du orouma awoena i meo wake enaenari weaisa. ");
INSERT INTO aby_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesunu iwoka ukeka orou ireweni (11) Gareri orofaro anisa. Ane fakake Yesu Danu fou ufiane wei i oraararo amuke anisa. ");
INSERT INTO aby_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amuke ane fakabaie Yesu enare ibiro ekake moibaie iboo yanakaisari ukaada guriguri uisaro moibai imuke dauisa. ");
INSERT INTO aby_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eno uisaro Yesuma emuabairo farike eno wei, Godima buna daiwere Nabairo manaraba ureini dooini yawokakune wei. ");
INSERT INTO aby_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Iduaya i orofa akaka eme yaisinabairo aniaweke Godinu wake weawero naufisake Nanu iwoka ukeka orou sifisaro emua babadaido ufia wei. Babadaido ukaada Babae Godinu ibiroini Danu Amaranu ibiroini Danu Imumu Iraunu ibiro emua babadaido ufiake Nama yabake bunawere we wake emuabake enaenari we ma iwoka uawero naufisa wei. Yesuma eno weike wei, Na yabairo ibimauro ureini dooini me sifekuro yabairo ibeimaua wei. I dawa imuke eawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Keriso Godinu amara Danu irau wake ewado na Maki nama awoena owaowa uke odakune. ");
INSERT INTO aby_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","I mi Isaiya Godinu we bou ukeka mi danu bukaro Godinu wake demuiro owaowa uke odike efene ibake weike Godima Dawabairo mai wake eno wei, eawe, nanu fo weeka mi dawako we odaimauro anifekuke Dai Minu daaba wabuke ma giena ufeku enaenari yanu imuka imuke ma giena ukeibiawe eno wei. I fo weeka mima yao nauwaro enarada iroma weibi, Dai Minu daaba wabuke ma gienabu uawe weia, Isaiyama eno yewa wake owaowa yanake odi. ");
INSERT INTO aby_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ibake Dioni babadaido ukeka mima eme ibe me yao nauwaro fariro eme keuwere dawabairo fakaro dawama eno wei, yanu merama ukeka sineka imuke mediawero Godima yanu merama ukeka sineka mufike imuke medifiro ya yaisina babadaido umia wei. ");
INSERT INTO aby_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eno weiro Derusaremu goi orouini i Diudia orofaro moi goi goi orouini emua yaisina Dionibairo aare fakake emenu merama ukeka sineka we ma boroo yakaro Dionima i orou i Diodeni aduaro babadaido urie. ");
INSERT INTO aby_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dioni danu barukekae irau me meramawere kemo abunu ofema barukeibi. Nono danu gabaganae boromakaunu ofema wayareibi. Nono danu iseka urunae sigigini ewereini eno iseibi. ");
INSERT INTO aby_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dionima ibaada eno weibi, nanu dubuenaro moi mi nanu umuro aafeku. Dawa buna daiwere na ari meya eno weibi. Na irauaiai meba Danu ibooro deri da umau wei. ");
INSERT INTO aby_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Awoena ba aduama babadaido uniaba nono dubuenaroe Dawa Godinu Imumu Irauma babadaido ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Moi furo Yesu Nasaredi Gareri goiroma aare Dionibairo fari. Fariro Dionima Diodeni aduaro Yesu babadaido ui. ");
INSERT INTO aby_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","11","Eno uiro Yesu aduaroma duero ido amukada eribaie urero ure eba uiro Godinu Imumu Irau ubari ada ari Dawabairo isare aari. Isare aariro ureroma wake daiwere weike eno wei, A Nanu amara ubibake Nanu imuka yaisina Abairo ibinu ibake Na rooro daiwere ukakunea Godima i wake eno wei. ");
INSERT INTO aby_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eno weiro Godinu Imumu Irauma Yesu munike eme ibe me orofaro waure ane odiro ibi. ");
INSERT INTO aby_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Dawa iro ibaada eweka keuwere fodi (40) iro ibeibiro seidanima Yesu uke iruke efine ibake Dawabairo fari. I awe abuini adaini ibeibisa orofaro Yesuini ibeibiro Godinu aneruma isare aare Yesu yawokeibisa. ");
INSERT INTO aby_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Dioni ana ebaro waure ane oisaro dubuena Yesu Gareri orofaro ane farike Godinu irau wake weada wefine eno wei, Godi Danu yawokaku eweka ido farinuba yanu merama ukeka sineka imuke mediaweke Godinu irau wake nauaweke mune awararo odiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","17","I Gareri kuna udiro enerebe eribaie Saimonini danu nabue Enuduruini emuama aduaro iwame ode ere enereibisiro erie. I miyai emua adua abu muneka miyai. Yesuma emuabake eno wei, Na aare we wauakoakiro anifeke yae eme muneka miyai odimiaro eme muawaro Godinu irau wake naukeka orou sifisa wei. ");
INSERT INTO aby_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eno weiro emenu iwame idua meisike aare Yesubairo fakiro kowede anisa. ");
INSERT INTO aby_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuma yafa menaku eka faraada eribaie Debedinu amarayai Deimisini Dionini emua you ubarenaro emenu iwame ma wiromeibisiro emua erieke eno wei, Nabairo aarawa wei. ");
INSERT INTO aby_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesuma eno weiro sabu emenu babaeini waiya ukeka orouini boudi ubarenaro mediriekike Yesunu umuro anisike ane Dawabairo fakiro kowede anisa. ");
INSERT INTO aby_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aneebe ane Kafenamu goiro faka. Fakaro Sabadi odo fariro Du orounu sosi uwara ubarenaro amuike we ma iwoka ukeibirie. Eno ukeibiriero Danu we ma iwoka ukeibirie ibake ima emenu imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dawama we ma iwoka ukaada eno uawe weibi ibake Danu we ma iwoka ukeka ie bunawerero nono i Mosesinu darawadu sisa orouma we ma iwoka ukaada moi mima enaenari uawe weakua eno ukeibiawe weibisabake emenu we ma iwoka ukekae buna me ibake i orouma Yesunu bunawere we ma iwoka ukekabake foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","I seidaninu imumu merama bobo mima sosi uwara ubarenaro ido amuike u weike eno wei, Yesu Nasaredi goi mi, aini naini demui meba aneme da uke makafukua eno wei. Eno weike nono wei, anemebake aarinu wei? Iya ma merama ufane ibake aarinu wei? Eno weike nono wei, Ae na iwoka, Ae i Godinu irauaiai miya wei. ");
INSERT INTO aby_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eno weiro Yesuma dino ukaada ma owerike eno wei, wake da weake dawabairoma amuake ania wei. ");
INSERT INTO aby_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eno wei ibake i seidaninu imumu meramama i mi ma biruru biruru ukaada arua daiwere weada imuka ubarenaroma fare isare ani. ");
INSERT INTO aby_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I ukeibi ubu ekake i orou emenu imuka foria daiwere ukaada emenu imusu we makanada yewa anemedei ubu weisa? Awoena we ma iwoka ukekae buna daiwere. Emebairo wenuroma nono I seidaninu imumu meramaini wenuro naukisake fare isare anisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesunu we ma iwoka ukeibirie ibai Gareri oroorofa eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","I Du orounu sosi uwara meisake Saimonini Enuduruini emenu uwara ubarenaro i miyaini Yesuini Deimisini Dionini emua yaisina ido amuisa. ");
INSERT INTO aby_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Amuisake ekabaie Saimoninu daroeya arama uike ofe wadada daiwere uiro aine ibi. ");
INSERT INTO aby_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aine ibiro Yesubairo fare weisa ibake aare Saimoninu daroeyanu wanaro munike ma uyariro danu wadada ukeibi ibai idua ure nuda uriro wiroike ani. Anike emua uruna waure aare mariero isa. ");
INSERT INTO aby_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dumudumu sinike eweka ane isareibiro i seidaninu imumu merama bobo orouini arama urie orouini emua yaisina Yesubairo waure aare farieka. ");
INSERT INTO aby_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","I goi orou keuwere i Saimoninu uwara aisamero ku ukeibisa. ");
INSERT INTO aby_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ku ukeibisaro arama imusu imusu uisa orou keuwere ma wirokeibirieke seidaninu imumu merama keuwere we ma berai. We ma berairo seidaninu imumu merama Yesu Dawa Godinu Amaraya ibai emua iwoka sikaba ibake emenu wake weeka daaba enare kuuri ibake emua wake we dauisake me anisa. ");
INSERT INTO aby_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wai awa dumu obaro Yesu uyarike eme ibe me orofaro anike Godibairo guriguri ukeibi. ");
INSERT INTO aby_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eno ukeibiro Saimonini danu naiyemukuini emuama Yesu ani biaro yowere anisake ekake eno weisa, eme yaisina a yodia ukaisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","38","Eno weisaro Yesuma emuabake ma owerike eno wei, moi goi goiro animake Godinu wake wemane ibake fanea eno wei. ");
INSERT INTO aby_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eno weiro Gareri nauwa goi goi yaisinaro anike Du orounu sosi uwara keuwerero wake weibike seidaninu merama imumu keuwere we ma berakeibi. ");
INSERT INTO aby_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Moi beko mami mima Yesubairo farike Yesunu ibooro ifoma kodudu yanakada eenu weada eno wei, anu arara ufakuie na ma wiroaro wiroma wei. ");
INSERT INTO aby_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eno weiro Yesuma ia sine dauike imukari daiwere uike i mi ure burisada eno wei, Nanu ararae a ma wiromauane wei. ");
INSERT INTO aby_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eno weike wei, beko me siaro wirofi weiro ido beko me siniro wiroi. ");
INSERT INTO aby_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Wiroiro Yesuma i beko bou irau sini mi ido odaisada bunawereroma eno wei, eme moibairo da ane wayai weake i Godibairo ofereni ode sibore sianeka mibairo aniake ma iwoka uaro efi wei. Mosesinu darawaduma eno weaku, i beko boubake we sibore sianeka enaenari ua wei. Anu ofe irauaiai ukinua aniake ma iwoka uaro efi wei. Ibake anu ofe irauaiai ukinuba i orou efeisake iwoka ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eno weiro nauke medike goi keuwere iro anike eme yaisinabairo ane Yesunu ui i yaisina wei ibake eme keuwere i Yesu ibi goiro faka. Faka ibake Yesuma goiro fare dauike kebiro yaureibiro i goi orou yaisina Yesubairo faka. ");
INSERT INTO aby_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Odo keu mero Yesuma nono owerike Kafenamu goiro fari. ");
INSERT INTO aby_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Fariro i orou yaisina Dawa fari ibai nauisake ane Danu uwara ubarenaro ku uisake uwaraini aisameini enare yaare ibisa. ");
INSERT INTO aby_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ibisaro Yesuma Godinu wake weibiro moi miyaini moi miyaini eno faka. Umu wana daba mami mi boiso dubo uisake waukake Yesubairo anifisane faka. ");
INSERT INTO aby_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Iro fakake emenu ararae uwara ubarenaro waure amufisane uisabaie eme keuwere dadau uisa ibake Yesubairo waure anifisa daaba mebake ferawere uwara fouro waure amuisake i ferawere uwara fou ma dorobu yakake i umu wana daba mami mi naama danu boiso duboini uwakake ebaro odaisaro Yesubairo isari. ");
INSERT INTO aby_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iro isariro Yesuma emenu imuka yaisina Dawabairo oisa ibai Dawa iwoka sinaada i umu wana daba mami mibake eno wei, Nanu amara, anu merama ukeka sineka muneke imuke medinea eno wei. ");
INSERT INTO aby_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yesuma wei ibaibake moi Mosesinu darawadu sisa orou emenu awarama imuisake eno weisa, anemebake wake eno weaku weisa? ");
INSERT INTO aby_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Eno weakuie Godini Dawaini emua demuiya weada weakua weisa. Weisake i ari enoe Godi mane merama ukeka sineka mune imuke medaku weisa. ");
INSERT INTO aby_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Eno weisa ibake Yesu Dawa emenu imukeka iwoka sinaada ibake uyarike emuabairo eno wei, i ari eno wake anemebake imukama imuke weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Abo wakema ofe arama mi aneaneme wemau, anu merama ukeka sineka mumauke imuke medimauba, ba anu wea muake ania wemau wei? Abodei wakema arawere wei. Eno weike nono wei, uyake anu wea muake ania wei. Idei wakema arawere wei, nono anu merama ukaku ima imuke medimau wene wakeye ara me wei. ");
INSERT INTO aby_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Eno weike nono wei, Na i Ba Eme sine Mi, Nanu moi buna ukeka umaro ya eaweke iwoka siawe weike nono wei, i mane meroma yanu dooro merama ukeka sineka munakuneke imuke medakunero ya eraada iwoka sinaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Eno weike i umu wana daba mami mibake nono wei, uyake anu wea muake goiro ania wei. ");
INSERT INTO aby_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eno wei ibake uyarike danu wea munike aniro eme keuwere ibai eraada imuka foria daiwere uisake eno weisa, iya adinaro eno ere mebairo awoena kawama eraisia eno weisa. Eno weisake ibake Godinu buna ukekabake Danu ibi we ma daiwere ukeibisa. ");
INSERT INTO aby_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu nono owerike Gareri kuna udiro fari. Fariro eme yaisina ane ku uisaro Yesuma emua we ma iwoka ukeibirie. ");
INSERT INTO aby_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dubuenaro nono Yesu enerebe eribaie Arofiesinu amara Riwai danu dakesi muneka orofaro yaure ibiro erike eno wei, aarake Nanu iwoka ukeka mi sia wei. Eno wei ibake i mima uyarike Yesunu umuro ani. ");
INSERT INTO aby_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuini Danu iwoka ukeka orouini emua Riwainu uwara ubarenaro yaure ibaada uruna iseibisa. Iseibisaro dakesi muneka orouini merama ukeka sineka orouini keuwere Danu umuro enarada ekabaie moi orouini Yesuini emua yaukake uruna iseibisa ibai eka. ");
INSERT INTO aby_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ibai ekake Mosesinu darawadu wake we ma iwoka ukeibisa orouini Ferosi orouini emuama Yesuini dakesi muneka orouini merama merama ukeka orouini uruna iseibisaro ekake Danu iwoka ukeka oroubairo eno weisa, Yesuini dakesi muneka orouini nono i moi merama ukeka sineka orouini Yesu anemebake emuaini uruna demuiro isaku weisa? ");
INSERT INTO aby_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eno weisaro Yesu emenu weisa wake nauike eno wei, i ofe arama me oroubake arama ma wirokeka mi aare dakinuke i ofe arama uke ibinisa oroubake aarinua eno wei. Eno weike nono wei, iya irau oroua weaisa oroubake wemane wayo aare dauneke Nae i merama ukeka sineka oroubake wemane wayo fanea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dioni danu iwoka ukeka orouini Ferosi orouini emenu bisarae eno, uruna ise dakeibisake kau uisabake uruna ise me. Enoba moi orouma Yesubairo eno weisa, Dioninu iwoka ukeka orouini Ferosi orouini emua uruna ise me. Nono Anu iwoka ukeka oroude anemebake uruna isaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Emuama eno weisaro Yesuma emuabake eno wei, aweka awoena mufeku mi danu banau ufiro i mi dawae danu oroubairo ibinuba ibake danu naiyemuku dawabairo aare ifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Moi odo i aweka awoena mufeku mi moiro anifekuie i uruna da ifeisake kau ufeisa. Enaenari Na animauie Nanu iwoka ukeka orou imukari ufeisake eno uke uruna kau ufeisaya eno wei. Eno weike wei, nono awoena Naini ibinisiie iseifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Yesuma nono wei, ainama awoena wau fekama adina wau sia ebaro fifini ufekuie i adina wau ido babafekuke eba daiwere ufekua weike nono wei, ainama i awoena wainima i adina abu ofero iifekuro awoena wainima adina abu ofe babanao ufekuke isanao ufeku ibake i awoena wainima ure wawarada i adina abu ofe ma merama ufeku ibake weike nono wei, i awoena wainima i awoena abu ofero iifekuie irauaiaiya wei. Yesuma i Mosesinu adina darawadu wakeini nono Danu awoena wakeini ma demuiro da ufoisaya weada ibake i wakeroma eno dubo waure wei. ");
INSERT INTO aby_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Moi Sabadi ewekaro Yesu Danu iwoka ukeka i orouini konoura waiya ubarenaro fare fisii yare anaada Danu iwoka ukeka orouma konoura ma roine isaada eneibisa. ");
INSERT INTO aby_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eno ukeibisaro i Ferosi orouma ekake Yesubairo eno weisa, ya i Sabadi ewekaro eno anemebake ukaisa weisa? Iyanu darawaduma weakubai i Sabadi ewekaro waiya da uawe weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Eno weisaro Yesuma emuabake ma owerike eno wei, Deiwidini danu orouini desini ureibibake uruna mune iseibisa i wake ya kakuraisakema nono ma nuna ukaisaya wei. Eno weike nono wei, Abiada dawa Godinu dai ofereni ode sibore sianeka mi i dai sosi yawokeibiro Deiwidima Godinu dai sosi uwara ubarenaro amuiro Abiadama i dai sosi uwara yawokeka orounu Godi ereibi iifa buredi mairo munike isaada danu oroubairo mariero isaya eno wei. Emuae eno uisaroma nono Godinu darawaduma emua unu koreka daaba dadau uke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Eno weike nono wei, Godima emeko ubu uike nono dubuenaro Sabadi eweka ai ubu uiba ibake i Ba Eme Sini Mi Dawae i Sabadi odonu ubi mi. Dawama i Sabadi eweka idua yawokeibakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu nono i Du orounu sosi uwara ubarenaro amuike eribaie wana merama mi idua yaure ibiro eri. ");
INSERT INTO aby_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Eriro i orouma Yesu ekake imukebe eno weisa, Yesu i wana merama mi yewa Sabadi odoro ma wirofekuba me ari weisa? Eno weisa ibake eraada emenu emenu we nauisake Yesu kodoro odifisane weisa. ");
INSERT INTO aby_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuma i wana merama mibake eno wei, uyake i orounu ubarenaro enaa wei. ");
INSERT INTO aby_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","5","Yesuma eno weike i orou yaisinabairo nono wei, Abodeima irauaiai wei, Sabadi odoro eme unu komiauba ma merama umiau wei? Ma wiromiauba ma feamau wei? Eno weibaie i orouma moko we dauisa ibake Yesu dino ui. Dino ukaada i orou yaisina ure owere ma owere uke erieke emenu aya muneka iwoka uike i wana merama mibake eno wei, anu wana siaa weiba ibake danu wana sianiro gienabu uike irau sini. ");
INSERT INTO aby_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I Ferosi orouini Du orounu sosi uwara ubarenaroma aweawero amuke fakake Erodi weaisa orou fou uriekake we makanada Yesu ma feareka daaba yodia ukeibisa. ");
INSERT INTO aby_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuini Danu iwoka ukeka orouini i Gareri kuna udiro anisaro nono i Gareri orouini Diudia orouini Yesunu umuro anisake Yesunu we ma iwoka ukeibi wake yaisina nauisake Danu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","9","Eme keuwere Yesunu umuro anisa. I Gareri orofa orouini Diudia orofa orouini Derusaremu goi orouini Idumeia orofa orouini Diodeni adua ekarana orouini Daira goi orouini Saidoni goi orouini eme keuwere Yesunu ukeibi ibai nauisake aareibisa ibake Yesuma Danu iwoka ukeka oroubake eno wei, na you mune bou ukeibiawe wei. I eme feferama ode dakaa unao ufeisa ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Adinaro arama ukeibisa orouini ma wirokeibirieba ibake eme keuwere awoena arama ukeibisa orouini emenu ararae Yesunu ofe ure burifisake irau sifisane ibake Dawabairo faka. ");
INSERT INTO aby_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Seidaninu merama imumu moi orounu imuka ubarenaro rewoke ibisaro faka. Fakaba seidaninu merama imumu bobo orouma Yesu ekake dooro isare biruke isarada eno weisa, A Dawa Godinu Amaraya eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eno weisaro Yesuma wei, Nae Godinu amaraba yewa wake moi oroubairo da ane weforo wei. ");
INSERT INTO aby_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu oraararo amuke anike Danu arara ukeibi orou u weiro Yesubairo aare faka. ");
INSERT INTO aby_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yesuma eme yaisina duwero (12) Dawaini ibekabake we munike Danu wake wefiro wefisane ibake emua murieke seidaninu merama imumu we ma berakeifisane ibake buna daiwere marie. ");
INSERT INTO aby_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I orou emenu ibi ibiye yewado, Saimoninu awoena ibi Fida mami. ");
INSERT INTO aby_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Debedinu amarayai Deimisini danu dabue Dionini emenu awoena ibiye Boanari mami. I ibinu ubiye ure ure weaku ari eno adarabai mamirie. ");
INSERT INTO aby_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Enuduruini Firifuini Badoromiaini Madiuini Domasini Deimisini dawae Arofiesinu amara, dawaini Dediusini dawa Keinani orofa mi, moi Saimonini Diudiasi Ikariada, i mi Diudiasi dawae Yesu weforairo muka mi. I orou yaisinabake Yesuma u weiro Dawabairo ane faka. ");
INSERT INTO aby_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesuini Danu iwoka ukeka orouini uwara ubarenaro amuisa. Amuisaro eme keuwere ku uisa ibake Yesuini Danu iwoka ukeka orouini emua i uruna ise da uisa. ");
INSERT INTO aby_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eno uisaro eme moima eno weisa, Yesu gogore ukinu weisa ibake Yesunu goi orouma nauisake Yesu we mufisane faka. ");
INSERT INTO aby_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moi Mosesinu darawadu wake we ma iwoka ukeibisa orouma Derusaremu goiroma fakake eno weisa, Danu imukaro Biesabo ibinu ibake emenu bokai merama imumunu bunaroma seidaninu merama imumu we berakakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eno weisabaie Yesuma ewaro aarawe weiro ane faka. Fakaro dubo waure weike eno wei, seidanima danu merama imumu da mune siafeku wei. ");
INSERT INTO aby_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eno weike Yesuma nono eno wei, gaemani orou emenu imusu urafeisaie emenu buna ido isafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nono uwara demui orou emenu emenu uranada abanaro ma gaganeroma imusu imusu enafeisake urafeisaie emenu ibekae idua merama sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","I ari enoe seidani danu moi orou we yowefiakuie danu onami we yowenao ufekua wei. Eno ufekuie danu imusu abanaro ma gagafekuro danu yawokeka buna ido merama sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","I moi waira ukeka mima bunama imusu ari minu uwara ubarenaro amufike bunama imusu ari minu wana uwane karifekuke danu eraerabusa waira ufekuke anifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yesuma eno weike nono wei, i ari enoba yabake ba wake weakunea nauawe wei, emenu merama ukekaini sara merama weekaini i yaisina Godima mufekuke imuke medifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nono ainama Godinu Imumu Irau sara we ma merama ufekuie Godima i merama ukeka da mune imuke medifekuro danu merama ukeka i mibairo ibene ibene ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","I owaowa odeka orouma adinaro eno weisa, Yesu Dawa seidaninu imumu merama Dawabairo ibinu ibake seidaninu merama imumu we berakakua weisaroma nono Yesu Dawae Godinu Imumu Iraunu bunaroma we berakeibi ibake Yesuma emuabake dubo waure weada i ari eno wei. ");
INSERT INTO aby_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Yesu Danu amaeini Danu naburakaini aakake aweawero enakake Yesu efene aarisia weisaro eme keuwere Yesuini demuiro yaure ibisaro moi orouma Yesubairo fakake eno weisa, Anu amaeini naburakaini aruarumaini uwara udiro enare ibaada A we nauke eraisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eno weisabaie Yesuma eno wei, Nanu amaeini naburakabake weaisa wei? Nanu wake wemaro nauawe wei, Nanu amaeini naburakade abo orouro wei? ");
INSERT INTO aby_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I ku uke ibisa orou eraada emuabake eno wei, yewa oroue Nanu amaeini naburakaini yewadoya wei. ");
INSERT INTO aby_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Abo orouma Godinu wake naukenewaa ufeisaie emuae Nanu amaeini nabueini Nanu aruarumaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Moi odoro Gareri kuna udiro Yesuma we ma iwoka ukeibiriero eme keuwere enare kara uisa. Enare kara uisa ibake youro amuike yaure ibiro i orou kuna udiro enare ibisa. ");
INSERT INTO aby_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Yesuma wake keuwere dubo waure wefine weike eno wei, nauawe, moi mima waiyaro yobai waifine anike diru munike yobai munike sianeibi. ");
INSERT INTO aby_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sianeibiro moi yobai daabaro isakaro adama fakake i yobai ise me sika. ");
INSERT INTO aby_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Moi yobai oma duboro isakake sabu warake amuisa. ");
INSERT INTO aby_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Warake amuisake doo aweawewere ibake ewekama farike yanairo iini funanaku ibake boke ure me sika. ");
INSERT INTO aby_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nono moi yobai sinisini bobo i ou ubarenaro isakake warakakema nono orobuwereba onu eriro kaibai uwane da uisa. ");
INSERT INTO aby_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Moi yobai irau dooro isakake warakenewaa uisake kaibai keuwere uwaka. Moibai keukeunaku uwaka, kai demuima kaibai dedi (30) uwaka. Nono moibai keukeuwere uwaka, kai demuima kaibai sikisidi (60) uwaka. Nono moibai keuwere uwaka, kai demuima kaibai wani aderedi (100) uwakaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesuma weike eno wei, ya ome bobo orouronae Nanu wake naukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","11","Dubuenaro i ku uke ibisa orou anisaro moi ibisa orouini Danu iwoka ukeka orou duweroini (12) emuama i dubo waure wei wakenu ubi yodia uisake weisa ibake Yesuma eno wei, Godima Danu ure yawokaku fe wakenu ubi ma boroo yarakuro ya iwoka ukaisaya wei. Godinu wake mune dakaisa oroue dubo waure weaisa wake mane naukaisake dubo waure weaisa wakenu ubi ma nuna ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eno weike wei, ibake ereka eraisakema nono ba bai ere dakaisaya wei. Naukeka naukaisakema nono i wakenu ubi ma nuna ukaisaya wei. I wakenu ubi iwoka sinao ufeisake emenu imuka yaisina Godibairo odinao ufeisaro Godima emenu merama ukeka sineka mune imuke medinao ufeku ibake weakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuma eno wei, yewa dubo waure wene wake ya iwokaba me ari wei. Iwoka da sifoisa ide moi dubo waure weeka wake aneme aneme iwoka sifoisa wei? ");
INSERT INTO aby_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Eno weike wei, i yo waweka miye Godinu wake we eneibaku mi ari enoya wei. Nono i daabae Godinu wake naukaisa orou ari eno. ");
INSERT INTO aby_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Enoba i mi Godinu wake we enarakuro i daabaro enareibaisa orou Godinu wake naukaisaro nono seidanima sabu farakuke i wake idua emuabairoma munaku. ");
INSERT INTO aby_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Enaenari moi oroue i oma duboro sianiro isaka i yobai ari eno. Godinu wake naukaiske rooro ukaisaro Godinu wakebake waa farakuro emenu naukekae irauaiai me. Enoba i oroue i yobai iini funaku ari ibake i wake naukaisake imuke medaisa. ");
INSERT INTO aby_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Moi orou emuae i ou ubarenaro isaka yobai ari ibake Godinu wake naukaisake imukeka imusu imusu imukaisake emenu arara erabusa munaisake emenu arara yaisina ukaisake i wakenu daaba ma yaaraisa ibake i wake kai uwane dakaku. ");
INSERT INTO aby_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nono moi orou emuae irauaiai doo ari eno. Enoba Godinu wake naukaisake imukenewaa ukaisake moi orou keukeunaku naukaisa, i oroue dedi (30) ari naukaisa. Nono moi oroue keukeuwere naukaisa, i arie sikisidi (60) ari naukaisa. Nono i ba moi oroue keuwere naukaisa i arie wani aderedi ari (100) naukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuma eno weike nono wei, ramefa biafoisake okea ubarenaro odifoisaba sebo wowonaro odifoisa wei? Eno we nauke erike wei, meya aiso odeka orofaro odifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Eno weike wei, i oba uke ibinisa eraerabusa yaisina woromifekuke emenu imukaro i fema imukaisa eraerabusa yaisinae ma boroo yafekuro efeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ya ome bobo orouronae naukenewaa uawe wei. Aneme aneme mafoisaie moko enaenari mufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eno weike emuabake nono wei, yanu naukaisa eraerabusa imukenewaa uawe wei. Ya okoanaku naufoisaie moko ma owere okoanaku mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Naukeka daiwere naukaku mi dawabairo naukeka moi mafekuke nono i dai menaku mane naukaku mi danu okoanaku naukeka mareke mufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuma nono eno wei, Godinu yawokaku odoe yewa wake ariya wei. Moi mima yobai munakuke waiyaro ane farakuke wawaku. ");
INSERT INTO aby_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nono aine wai ure ibakuro yo kaibai kua faraisake warakaisa. Yobai kua aneme aneme faraisake warakaisa ari ibai dawa iwoka me. ");
INSERT INTO aby_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Doo mane ma warakakuro kua faraisake kaka uraisake daiwere sinaisake kai uwanaisake ayo uraisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ayo uraisaro kaibai ma diwakaisa odo ido farakuba ibake bauma umane kuure munakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuma eno wei, Godinu yawokaku odo abo odo ari wemau wei? Godinu yawokaku odo abodei dubo waure weeka wake ari wemau wei. ");
INSERT INTO aby_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Godinu yawokaku odoe okoa masida ana kai yo ariya wei. I kai dai mebainakuro wawakuro iroma ana daiwere sinakuro ada yaisina i ana riuro yaure ibaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Godinu dubo waure weeka wakeroma wake keuwere Yesuma eno weibi. ");
INSERT INTO aby_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enoba i wake idua medike Danu iwoka ukeka orou emenu imusu ibisaba i wakenu ubi we ma boroo yariro nauisa. ");
INSERT INTO aby_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dumudumu siniro Danu iwoka ukeka oroubake Yesuma eno wei, kuna ekabokenaro siraa yafe wei. ");
INSERT INTO aby_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","37","Eno weiba ibake eme keuwere idua meisake Dawa we waure anisake youro amuisake anisa. Anisake moi orouini youro aneibisaro obeobe daiwere farike ufe daiwere uyariro you inuu yafine ui. ");
INSERT INTO aby_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","39","Yesu Dawa you barunaro kudo odike aine ibiro ma uyakake eno weisa, Sisa mi, iya feafene ukaisia weisa. A imukakuba me weisa? Eno weisaro uyarike oyauini adua ufeini we kuuriro oyauini adua ufeini idua me sinike me mo ari sini. ");
INSERT INTO aby_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuma emuabake eno wei, anemebake ia iyarada imuke dakaisa wei? ");
INSERT INTO aby_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yesuma eno weiro imuka foria uisake ia sikake eno weisa, i mide abo miro oyauini adua ufeini Danu wake naukisa weisa. ");
INSERT INTO aby_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","10","I Gerasini orofaro moi seidaninu merama imumu bobo mima ibeibi. I mi dawae eme feareibisaro ane odeibirieka i oma eraboro aineibi. Aineibiro i mima iya unao umisia weada ia sinaada i minu umu wana senima uwaneibisaro ma furufuru yareibi ibake emua yaisina dawa yawokenewaa uke dakeibisa. Danu imusu dumuini ewekaini eme feareibisaro ane odeibirieka oma eraboroini oraararoini enaada arua weada oma iyabaima danu onami owere umaneibi. Yesuini Danu iwoka ukeka orouma Gerasini orofa kuna ekabokenaro siraa yare ane enaka. Enakake Yesu aweawero amuike enariro i seidaninu merama imumu bobo mima yafawereroma Yesu erike durame ane Yesubairo ane farike Yesunu ibooro ifoma kodudu yanairo Yesuma i seidaninu merama imumubake eno wei, danu imuka ubarenaroma amua weiro i seidaniu merama imumuma daiwereroma eno wei, Yesu urero ibinu Dai Godinu Amara, nabake aneme ufane ukaku wei? Eno weike wei, Godibairo eno wea na fanisi da mafari wea wei. Eno weiro Yesuma i mibake ma owerike eno wei, anu ibide ainaro wei. Eno weibaie i seidaninu merama imumuma eno wei, nanu ibiye keuwereya weike wei, ibake keuwere ibinisia wei. Eno weike nono wei, yewa orofaroma aniawe da wea wei. ");
INSERT INTO aby_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","I borosiri keuwerema oraararo ibaada uruna iseibisaro seidaninu merama imumuma Yesubairo eno weisa, wearo anifeke i borosirinu imuka ubarenaro isafe weisa. ");
INSERT INTO aby_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eno weisaro Yesuma ma owerike eno wei, aniawe wei ibake fare anisake borosirinu imuka ubarenaro isaka. ");
INSERT INTO aby_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Isakaro i borosiri keuwere du dausini (2,000) durame anisake oraara okoroma kunaro bibi ure isakake imu ise me sika. ");
INSERT INTO aby_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Enoba i borosiri yawokeibisa orouma emenu goiro durame anaada i orou yaisinabairo ibai weisaro i goi orou yaisina i kunaro fare ekake Yesubairo ane faka. ");
INSERT INTO aby_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ane fare ekabaie i seidaninu merama imumu keuwere bobo mi danu awara irau siniro danu wau runike yaure ibi ibake i orou ekake ia sika. ");
INSERT INTO aby_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","17","Ia sikake i orouma i seidaninu merama imumuini borosirinu uisa ibai ekake i faka oroubairo weisaro i goi orouma Yesubake eno weisa, iyanu orofaro da ibiake ania eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuma youro amuiro i seidaninu merama imumu me sini mima Yesubake eno wei, naini anifu wei. ");
INSERT INTO aby_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Eno weibaie Yesuma ma owerike eno wei, Naini da aarake owere aniake anu goiro Godinu buna imukari ukeka yaisina anu goi oroubairo ane wea wei. Eno weiro i mi idua owere ani. ");
INSERT INTO aby_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Anike Dikaforisi orofaro goi yaisina deni (10) ibisa orofaro anike Yesunu bunaini imukari ukekaini ibai yaisina we eneibiro i orou naukada imuka foria ukeibisa. ");
INSERT INTO aby_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","23","Yesu owerike i kuna siraa yare ekara enaro ane enari. Ane enariro eme keuwere Dawa enare kara uisake enare ibisaro i Du orounu moi sosi yawokeibi mi danu ibiye Dairasi dawama aare farike Yesunu ibooro ifoma kodudu yanakada eno wei, nanu arumanaku feafine ukakua aararo anifuke anu wanama danu iiri duboro odiaro irau sifi wei. ");
INSERT INTO aby_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eno weiba ibake Yesuini idua aneibisiro eme keuwere Yesunu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Moi awekaini anisa. I aweka dawae arama daiwere uike iwa doraada aineibi. ");
INSERT INTO aby_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Oya yaisina duwero (12) iwa doraada arama ma wirokeka oroubairo aneibi. Anaada i oya yaisina duwero (12) iwa mane doraada arama ma wirokeka oroubairo anaada danu oi yaisina siane me sinikema nono arama irau sine dauike nono baba ukeibiba ibake anike i wake naui. ");
INSERT INTO aby_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Anike nauibaie Yesu enakua weisaro nauike danu imusu eno we imui, animauke Yesunu wau barunaro ure burimauie i arama wiromaua eno we imui. ");
INSERT INTO aby_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","29","Eno we imuike Yesunu wauro yabaibaie ena iwa doreibi ibai idua di kuuriba ibake irau sinike Yesunu buna dawabairo ani ibai idua iwoka sini. ");
INSERT INTO aby_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","I aweka Yesunu wau barunaro ure buribaie Yesunu buna anike i bunama i awekanu arama ma wiroiro Yesu Dawa iwoka sini. Iwoka sinike ibake i oroubairo ma owerike eno wei, nanu wauro ainama ure burisinu wei? ");
INSERT INTO aby_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eno weibaie Danu iwoka ukeka orouma eno weisa, ea, eme keuwere enare kara uke ibinisa orou emuama ure burisisaba aneme ariya weisa? Eno weisake nono weisa, anemebake Na ainama ure burinara weaku weisa? ");
INSERT INTO aby_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eno weisaro Yesu eka ere ewa ere uiba ibake i aweka ia sinike iura mami. ");
INSERT INTO aby_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","34","Yesunu buna daiwere i awekabairo fare aniba ibake iwoka sinaada Yesunu ibooro aare ifoma kodudu yanaike ba wake weibaie Yesuma eno wei, aruma, ama Na imukeka imukae daiwere imukinu ibake wirokinua ia da siake ania wei. Anu arama idua wirokinua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuma eno weibibaie moi mi Du orounu sosi yawokeibi minu uwararoma Dairasibairo aare farike eno wei, anu aruma fearinua i Sisa mibake wake areare da wea wei. ");
INSERT INTO aby_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Eno weiro Yesuma nauike Dairasibake eno wei, ia da siake imuka ara ua wei. ");
INSERT INTO aby_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuma eno weike i orou yaisina idua medirieke Fidaini Deimisini danu dabue Dionini emua we waure ane i Du orounu sosi yawokeibi minu uwararo fari. ");
INSERT INTO aby_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Farike nauibaie sorara ukeibisaba Yesuma i sorara ukeibisa oroubake eno wei, anemebake sorara ukaisa wei? I arumanaku feare mero nauka kunawere aine ibinua wei. ");
INSERT INTO aby_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesuma eno weiro i sorara ukeibisa orou meisake Yesubairo ririau ukeibisa. Ukeibisaro Yesuma i orou yaisina uwara udiro we odairiero isaka. Isakaro i arumanaku danu amaeini babaeini Fidaini Deimisini Dionini emua mane uwara ubarenaro yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ibisaro Yesuma I arumanakunu wanaro munike i Arameia orounu wakeroma eno wei, darida kumi, i wakenu ubiye arumanaku abake ba weakunea uyaa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eno weiro i dai sineibi arumanaku uyarike eneibibake i yaure ibisa orouma ekake imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Uisaro Yesuma eno wei, yewa une ubu moi oroubairo da weaweke i arumanaku uruna mawero ifi wei. ");
INSERT INTO aby_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","I orofa ido meisake Yesuini Danu iwoka ukeka orouini Danu orofaro anisa. ");
INSERT INTO aby_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Moi Sabadi odoro i Du orounu moi sosi uwara ubarenaro isarike we ma iwoka ukeibirie. Eno we ma iwoka ukeibiriero eme keuwere imuisake imuka foria ukaada eno weisa, Danu we ma iwoka ukekaini iwoka ukekae aboroma muninu weisa? Danu iwoka daiwere ainama makinu weisa? Danu ukeka buna daiwere aneme aneme ukaku weisake iya iwoka me weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","4","Eno weisake nono weisa, Godima i buna make dauiro yewa miye uwara ma enareka mi manea weisa. Dawa iya ari weisake eno weisa, Danu amae Merini Danu naburaka Deimisini Diosefuini Dudini Saimonini Danu aruarumaini emua iyabairo ibinisaya weisa. Eno weisake Dawabake dino uisaro Yesuma ma owerike eno wei, Godinu we bou ukeka mi moi orofaro anifekuie i orouma Dawabake iifa ufeisa. Nono danu orofaro anifekuie danu orouma dawa iifa uke da ufeisake ere medifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Emuama eno iifa uke da uisaba ibake Yesue buna daiwere uke da ui. I arama ukeibirieka orou mane una demui demui wana emenu ofero ure buriro irau sika. ");
INSERT INTO aby_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Emua imuke dauisaba ibake Yesu imuka foria ui. ");
INSERT INTO aby_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Moi odoro Yesuma goi goiro we ma iwoka uke enereibi. ");
INSERT INTO aby_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","I odoro Yesuma we odaifiero anifisane weiro Danu iwoka ukeka orou duero (12) Dawabairo aare faka. Fakaro una raara raara anifisake seidaninu merama imumu mune siafisane buna daiwere marieke eno wei, urunaini yoakeini oini da mufoke urini umu fogowoini runeka wau demui demui mane muforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Moi goiro fafoke moi uwara ubarenaro amufoke ibaada yanu wake i uwararo ibifeisa oroubairo we me sifoisaie aniforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Moi uwararo ibifeisa orouma ya da we mufeisake yanu wake da naufeisaie yanu derena emuabairo siaweke yanu umuro doo maisuawero emua medifiakane ukaada ufoisa ibai emua iwoka sifisaro aniawe wei. Eno uawero Godima emua da mufiaku ibai emua iwoka sifisa wei. ");
INSERT INTO aby_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eno weiro anisake Danu wei enaenari i orofa goi goiro eno weisa, yanu merama ukeka sineka imuke mediawe weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eno weibisake seidaninu merama imumu keuwere we yowereibisake oera munaada emenu wanama arama uke ibeibisa orou keuwere emenu awararo ma dasidasi ukeibisake ma wirokeibirieka. ");
INSERT INTO aby_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eme yaisina Yesunu ukeka sineka iwoka sikake weisaro Erodi, dai gaemani yawokeibi mima i wake nauike ma nuna uiro moi orouma eno weisa, Dioni Babadaido mi fearike uyariba ibake buna ukeka daiwere ukakua weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Moi orouma eno weisa, yeka miye Eraisaya weisa. Moi orouma eno weisa, Dawae Godinu we bou ukeka mi adinaro we bou ukeka mi ariya weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eno weisaro i dai yawokeka mi Erodima i wake yaisina nauike eno wei, yewae Dioni. I minu faya nama kuurero fearikema nono uyaria eno wei. ");
INSERT INTO aby_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Adinaro Erodima danu nabue Firifunu aweka Erodiasi muniro Dionima eno wei, anu nabuenu aweka muneka meramawereya media wei. Eno weiro Erodiasi weaisa i awekama dino uike Dioni ma feafine imui. Eno imuiro Erodi ia sinaada Dioni dawae Godinu irau mi ibai dawa iwoka sini. Dawa iwoka sini ibake Erodiasima ma feare dauike wakema weebe weebe wei. Enoba Erodi danu orou we odairo anisake Dioni mune ana ebaro oisaro Erodima Dioninu wake naufine aneibike naukeibikema nono i wakenu ubi ma nuna ukeibi. ");
INSERT INTO aby_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nono Erodi danu amaema dawa dori odo fariba ibake dawama banau daiwere umanike weiro danu goi dai orouini danu dai meremere orouini Gareri orofa dai orouini emua ido aare faka. ");
INSERT INTO aby_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Fakaro Erodiasima eno we imui, Dioninu ma feareka odo idua farinua we imui. Erodiasinu aruma emuabairo aare farike yaura ureibiro banau faka orouini Erodini emua rooro uisaro Erodima eno wei, anu arara anemerabu wearo mamake nanu yawokakune orofa baruna abake mamaane wei. ");
INSERT INTO aby_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eno weiro danu amaebairo ane wei, aneme wemau wei? Weiro danu amaema ma owerike eno wei, aniake Dioni Babadaido minu bokaifu maina wea wei. ");
INSERT INTO aby_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eno weiro owerike Erodibairo ane farike eno wei, Dioninu bokaifu naberoro awoena odiake maina wei. Eno weiba ibake Erodi imukari daiwere ui. ");
INSERT INTO aby_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Adinaisa danu bunawere we bou ui wake weiro danu banau uruna iseibisa orou nauisa ibake enaenari ui. ");
INSERT INTO aby_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Enoba Erodima weiro danu meremere mima ana ebaro anike Dioninu faya kuurike bokaifu naberoro odike owerike i arumabairo aare farike mai. Mairo munike ane danu amaebairo mairo eri. ");
INSERT INTO aby_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eno uisaro Dioninu umuro eneibisa orouma ibai nauisake ane danu ofe mukake ane eme odeibisa oma eraboro ane oisa. ");
INSERT INTO aby_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesunu iwoka ukeka orou owekake Yesubairo aare fakake emenu ukeibisa ibai yaisina weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eme keuwere ane fare ane fare eno mane ukeibisaro imu siane uruna ise da uke eno ukeibisaba ibake Yesuma eno wei, eme ibe me orofaro anifeke ko yafe wei. ");
INSERT INTO aby_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eno weiro youro amukaro eme keuwerema emua ekake umuma sabu anisake goi goiroma i orofaro emuako faka. ");
INSERT INTO aby_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","34","Ane fakaro Yesu youro enarike i orou yaisina erie. I orou yaisina mamoe abu ari. Yawoekeka mi iro meba ibake daaba imusu imusu eneibisa enaenari i orounu imukeka imusu imusu imukeibisaba Yesuma emuabake imukari uike emua we ma iwoka ukeibirie. ");
INSERT INTO aby_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Dumu dumu siniro Yesu Danu iwoka ukeka orou Dawabairo aare fakake eno weisa, yewae eme ibe me orofaro eweka isafine ukakua wearo goi aboro aboro anifisake uruna oiya ufisane weaisi weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eno weisaro Yesuma ma owerike emuabake eno wei, uruna mayakawe eno weiro emuama eno weisa, uruna du aderedi kina (K200) oima make mufeke anifeke mafiakiro ifisa weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eno weisaro Yesuma eno wei, aniaweke buredi abea yabairo ibinu ariya ane eawe wei. Eno weiro ane ekake owekake eno weisa, buredi fai ibinuro adua abu kai raarayai ibinisia weisa. ");
INSERT INTO aby_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Eno weisaro Yesuma eno wei, yaufisa weawe wei. Weiro moi orofaro eme wani aderedi yaukaro moi orofaro eme fifidi (50) yauka. ");
INSERT INTO aby_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","42","Danu wei enaenari uke ibisaro Yesuma buredi faini adua abu kai raarayaini munike urero erike Godi Dawa irauaiai we imukada guriguri uike buredi ma bira bira yarike Danu iwoka ukeka oroubairo marie. Mariero mukake i kuku ukeibisa oroubairo naka naka uisake adua abuini naka naka uisaro isa. ");
INSERT INTO aby_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Isaro boana uriero iuwa iuwa mukake bosearo youkaro bosea duero (12) wake faka. ");
INSERT INTO aby_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eme keuwere fai dausini (5,000) i uruna isa. ");
INSERT INTO aby_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu Danu iwoka ukeka orou emuako boudiro amuisake ekara enaro siraa yakake Besaida goiro anisa. ");
INSERT INTO aby_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","47","Anisaro Yesuma i eme fefera i orofaroma we odairiero anisa. Anisaro nono Dawae oraararo amuke anike guriguri ukeibi. Guriguri ukeibiro dumu sineibi ibake Danu imusu dooro ibiro Danu iwoka ukeka orounu you kuna abanaro ibi. ");
INSERT INTO aby_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesuma ereibiro oyau daiwere fariro i orou bara ureibisabaie oyau daiwerebake you ane dakeibi. ");
INSERT INTO aby_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nono wai ufine ukeibiro Yesu kuna duboro enaada you ma berefine ui. ");
INSERT INTO aby_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Eno uiro ekake imumuba aneme ariya weisake ia sinaada weisaro Yesuma eno wei, ia da siaweke imuka ara uawe yewae Naya wei. ");
INSERT INTO aby_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Eno weike youro amuiro oyau me sini. Oyau idua me siniro Danu iwoka ukeka orou imuka foria uisa. Emenu imuka arawerebake buredini adua erio abuini i eme fefera mariero isaro boana urie ibai imuke dauisa. ");
INSERT INTO aby_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kuna ekabokenaro siraa yare ane Genesareda orofaro enaka. ");
INSERT INTO aby_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Enakaro eme keuwere Yesu ekake Dawa emua iwoka ibake anisake arama uke ibisa orou we waukake Yesunu yaure ibi orofaro waure farieka. ");
INSERT INTO aby_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Yesu okoa goiro o badoa goiro o waiyaro aboro aboro aneibiro emenu arama ukeibisa orou waure fakaro eno weisa, anu wau fifiro ure burifeke wirofene farisia weisa. Eno weisake ure burisada irau sineibisa. ");
INSERT INTO aby_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moibai Ferosi weaisa orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Derusaremu goiroma fakake Yesu fou uka. ");
INSERT INTO aby_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Fou ukake ekabaie Danu iwoka ukeka orou uruna iseibisake wana wanadu uke dakeibisaro erieka. ");
INSERT INTO aby_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","I Ferosi orouini Du orouini emenu sisia sirorari bisara eno ukeibaisaya weisa. Uruna ifisane ukaadae wana wanadu ukenewaa ukaisa o sidowa uwararoma faraisaie uruna ise dakaisa. Wana wanaduko ukenewaa ukaisakema ai uruna isaisa. Emenu imukaro eno imukeibisa, Godima emenu imumu inoya wenao ufeku eno imukada ibake eno ukeibisa. Moi bisaradeie, faniginini okeaini naberoini seboini eno mane urokenewaa ukaada ibeibisa. ");
INSERT INTO aby_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I Ferosi orouini Mosesinu darawadu we ma iwoka ukeibisa orouma Yesubake eno weisa, Anu iwoka ukeka orou iyanu bisara orounu ukeka wake mune meya weisa. Uruna isaada wana wanadu uke mero uruna isaisaya eno weisa. Eno weisake dino ukaada anemebake eno ukaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Eno weisaro Yesuma ma owerike emuabake eno wei, ya sara merama ukaisa orou, Isaiyama yabake owaowa uke odiro eraada enaenari ukaisaya wei. Ya meo bobo oroude Yesuma eno weike wei, yae Isaiyanu yanake odi owaowa enaenari ukaisa wei. Isaiyama eno owaowa uke odi, yewa orounu imuka arawereba Nabake imukama imuke mero i wake mane wenewaa ukaisake emenu guriguri Nabairo me sara ukaisaya wei. Emenu imukeka we ma iwoka ukaada ie Godinu imukeka weisaya, Isaiyama yabake eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesuma nono wei, Godinu darawadu uke mero emenu bisara ukeka mane imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Godinu darawadu eka medaisake emenu bisara ukeka mane imukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesima eno wei, yanu amae babaenu wakeini muneibiaweke yawokeibiawe wei. Eno weike nono wei, ainama danu amaeini babaebake wake meramawere wefekuie ure bauawero feafi Mosesima weia eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nono yama eno weaisa, moi mi danu amae babaebake eno weaku, nanu ararae yabairo me makeka mamiauroma nono i me makeka eraerabusae kobani ibake yabake da mamiau wefekua wei. I wakenu ubiye Godibairo me makeka ibake da mamiaua eno wefekua weaisa. ");
INSERT INTO aby_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Eno weaisaba danu amae babaebake da unu kofekuba ibake Godinu amae babae unu koreka darawadu wake mune sianaisake emenu bisara ukeka mane ma uyaraisaya wei. Yanu bisara ukekadeie enaenari ukaisaba ibake moi oroubairo we ma iwoka ukeibaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Moi odo Yesuma eme keuwere weiro aare fakaro Dawama eno wei, Nanu wake naukenewaa uaweke iwoka siawe wei. ");
INSERT INTO aby_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Uruna yaisina moi minu boana ubarenaro anifeisaie ima danu imuka da ma merama ufeisaya eno wei. Da ma merama ufeisaro imuka ubarenaroma amufeisaro wefekuie ima dawa ma merama ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","(Ome bobo orou ya nauawe!) Eno weike i orou yaisina ido medirieke uwara ubarenaro amuiro Danu iwoka ukeka orouma ma owekake eno weisa, i dubo waure wenu wakenu ubi aneme aneme arie weisa? ");
INSERT INTO aby_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Eno weisaro Yesuma eno wei, ya iwokaba me wei? Uruna yaisina moi minu imukaro da anifeisake desini duraro anifeisake nono dubuenaro wisi akeka orofaro afeisabake i urunama i mi ma merama da ufeisaya eno wei. Eno wei ibake i uruna yaisinae irauaiaiya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aneme aneme imuka ubarenaroma amufeisaro wakema wefekuie ima i mi ma merama ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Eno weike nono wei, imukaroma merama imukeka keuwere amufeisaie ima i mi ma merama ufeisaya wei. Merama imukekaini moi orounu aruaruma enare odekaini waira ukekaini eme urekaini moi minu aweka enare odekaini fukeru uke naisama ure owere ma owere ukekaini imuka ka ukekaini we irukekaini merama ukekaini meo wayai weekaini meo weekaini imukama fukeru ukekaini we mero me sara ukekaini i yaisina imukaroma me nauwaro amukaisa ima i mi ma merama ukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuma eno weike i orofa ido medike Daira goi ubiubi orofaro fari. Farike moi uwara ubarenaro fenaku amuike ibiro i orou iwoka sika. ");
INSERT INTO aby_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Moi aweka danu arumanaku seidaninu merama imumu bobo ibake dawama Yesu fare ibibai nauike ido aare farike ifoma kodudu yanai. ");
INSERT INTO aby_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","I awekae Du aweka me, dawae Guriki orofa aweka. Danu goiye Sairofonisia. I awekama faraada ifoma kodudu yanaike eenu wei, i seidaninu merama imumu nanu arumanakunu imuka ubarenaro ibinua we beraa wei. ");
INSERT INTO aby_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eno weiro Yesuma ma owerike eno wei, amara aruma uruna iseibisaro boana ureibiriero kuasiribake makeibisaro iseibisaya wei. I dubo waure wei wakenu ubiye eno, Du oroma Godinu wake emuako bokai mufeisaro nono i imusu orou Godinu wake dubuenaro mufeisaya weadama dubo waure wei. ");
INSERT INTO aby_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","29","Eno weiro i awekama ma owerike eno wei, Dai mi, ba weakua wei. Eno weike nono wei, i kuasiri amarananakunu uruna ifuru iseifeisaya weibaie Yesuma eno wei, i wake ibake eno wenuro seidaninu merama imumu ainua ania wei. ");
INSERT INTO aby_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eno weiro anike ane uwararo farike eribaie seidaninu merama imumu aniro i arumanaku me aine ibiro eri. ");
INSERT INTO aby_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu nono owerike Daira goi ubiubi orofa medike Daira goi ubiubiroma anike Saidoni goini Dikaforisi orofaini ma bereike Gareri kuna udiro fari. ");
INSERT INTO aby_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iro ane fariro moi orouma wake naukenewaa meke wake wenewaa me mi we waure fakake eno weisa, Anu wana yewa minu iiri duboro odia weisa. ");
INSERT INTO aby_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","Eno weisaro Yesuma i mi aweawero waure anike Danu wana i minu ome ebaro sianike wisiomu uike i minu meanaro ure burisada urero erike imu sianada i Arameia orounu wakeroma eno wei, efada, i wakenu ubiye ure woromia wei. ");
INSERT INTO aby_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eno weibaie i mi ido wake nauike irauaiai wake wei. ");
INSERT INTO aby_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wake weiro Yesuma emuabake eno wei, yewa unebai eme moibairo da weawe wei. Weiro nauke meisake eme moibairo ane weisa. ");
INSERT INTO aby_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Weisaro nauisake emenu imuka foria daiwere uisake eno weisa, Danu ukeka yaisina ukenewaa ukakuba ibake i ome gogore orou wake naukaisaro i wake we dakaisa orou wake nauke we eno ukaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Moi odo eme keuwere ku uisa. Ku uisaro uruna mebake Yesuma Danu iwoka ukeka oroubairo weiro fakaro wei, i orou Nabairo eweka odo buuba ibinisaro uruna mero emuabake imukari ukakuniaya wei. ");
INSERT INTO aby_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eno weike wei, we odaimiauro anifeisaie emenu goi yafawereba daabaro anaada desinima feafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","6","Eno weiro Danu iwoka ukeka orouma eno weisa, eme ibe me orofaro uruna aboro mufeke mafero ifisane weaku weisa? Eno weisaro Yesuma ma owerike eno wei, yabairo buredi abea ibinu wei? Weibaie seweni (7) mane ibinisaya weisaro Yesuma i ku uke ibisa oroubake eno wei, yauawe weike buredi munike Godi we ma irauaiai ukaada guriguri uike ma birabira yarike Danu iwoka ukeka oroubairo mariero mukake emuama i orou mariekaro isa. ");
INSERT INTO aby_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Adua abua dai mebainakuini enaenari uike makaada yewaini mayakawe weiro mukake emuama mariekaro isa. ");
INSERT INTO aby_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Isaro boana uriero iuwabai bosea seweni (7) youkaro wake faka. ");
INSERT INTO aby_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eme keuwere fo dausini (4,000) uruna isa. Yesu emua we odairiero iroma anisa. ");
INSERT INTO aby_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Anisaro Yesuini Danu iwoka ukeka orouini youro anisake Damanuda orofaro ane enaka. ");
INSERT INTO aby_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Moi Ferosi weaisa orou fakake uraneka wake weisake Yesu we nauke eraada eno weisa, Anu buna ukeka uaro ureroma fafiro efe weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Weisaro imuka merama uike imu sianada eno wei, yewa orou anemebake moi buna ukeka yodia ukaisa wei? Eno weike wei, Nanu wake wemaro nauawe wei, moi buna ukeka yewa oroubake da we foramiaua weike i orou idua medi. ");
INSERT INTO aby_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Idua medirieke youro amuike siraa yare ekabokenaro ani. ");
INSERT INTO aby_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Yesunu iwoka ukeka orou buredi keuwere mune dauisake kai demui mane mukake anisaro Yesuma i Ferosi orouini Erodi orouini emenu meo we ma iwoka ukekabai imuike Dawama eno wei, i Ferosini Erodi weaisa orounu wawareka iraa yisidi eforo wei. Wawareka iraa yisidi dai mebainaku odifeisaro daiwere ure wawafeku enaenari emenu we ma iwoka ukeka daiwere ufekuro eme keuwere naufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eno weiro emenu emenu we makanada eno weisa, iyanu buredi mune dakisiba ibake weakua weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eno weisaro Yesuma emenu weibisa wake iwoka sinike wei, anemebake buredi wake weaisa wei? Ya iwoka sinenewaa meya wei. Yanu imukae arawere ibake oide ibinua wei. ");
INSERT INTO aby_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Eno weike nono wei, ya naisa bobo orou eraisakema nono ba bai ere dakaisaya wei? Eno weike wei, ya ome bobo oroue naukaisakema nono ba bai nauke dakaisaya wei. Ya ibai imukaisaba me wei? ");
INSERT INTO aby_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yesuma eno weike wei, adinaro buredi fai (5) ma birabira yarero eme keuwere fai dausini (5,000) isaro iuwabai bosea abea youisa wei? Eno weibaie bosea duero (12) youisia weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","21","Eno weisaro Yesuma wei, buredi seweni (7) ma birabira yarero eme keuwere fo dausini (4,000) isaro iuwabai abea bosearo youisa wei? Eno weibaie bosea seweni (7) youisia weisaro nono wei, Na i ue enaenari umauroma awoena iwoka sinaisaba me wei? Uruna mane da imuaweke irau naukekaini ukekaini eno imuawe wei. ");
INSERT INTO aby_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Besaida goiro aare fakake enare ibisaro moi orouma moi naisa kikori bobo mi waukake faraada eno weisa, yewa mi ure buriaro wirofi weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eno weisaro Yesuma i minu wanaro munike goi derena enaro waure ani. Derena enaro waure anike i minu naisaro wisiomu uike wana iiri duboro odaada eno wei, erakuba me wei? ");
INSERT INTO aby_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eno weiro i mima eno wei, na eme enaraisaro erakunea wei. Eno weike, ana ari enaisaro erakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eno weiro Yesuma Danu wana nono iiri duboro odiro naisa foraike ereebe irau sinaada erenewaa ui. ");
INSERT INTO aby_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eno uiro Yesuma eno wei, i Besaida goiro da aniake anu goiro owere ania wei. ");
INSERT INTO aby_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuini Danu iwoka ukeka orouini Sesaria Firifai goi goiro anisa. Aneebe Yesuma eno wei, i orouma Nabake ainadei weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eno weiro emuama eno weisa, moibaima Abake Dioni Babadaido fearekaroma uyari miya weaisaro Godinu bukaroma weaku, Iraida dawako fafeku weaku ibake moibaima Abake Iraida weaisaro nono moibaima Abake Godinu moi we bou ukeka miya weaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eno weisaro Yesuma ma owerike eno wei, nono yadeie Nabake ainadeia weaisa wei? Yesuma eno weiro Fidama wei, Ae Godinu Kerisoya wei. ");
INSERT INTO aby_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eno weiro Yesuma eno wei, i wake moi oroubairo da weawe wei. ");
INSERT INTO aby_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuma moi wake emuabake eno wei, i Ba Eme Sini Mima oferi daiwere waufekuro bisara orouini ofereni ode sibore sianeka orouini Mosesinu darawadu we ma iwoka ukaisa orouini emuama Danu wake da naufeisake Dawa ma feafeisaro feafekuro eweka odo buuba me sifekaro nono uyafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","33","Eno weiro nono Fida dawa arara me Yesuma feareka wake wei ibake ma owerike Yesubairo we iifa ui. Eno uiro Yesu owerike Danu iwoka ukeka orou erike Fidabake eno wei, seidani Nanu derena enaro ania wei. Anu imukekae Godinu imukeka ari mero emenu imukeka imukakua Yesuma bunawereroma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dubuenaro Yesuma i orouini Danu iwoka ukeka orouini emuabairo u weiro fakaro eno wei, ainama Nanu umuro aafine ufekuie danu arara ukeka eraerabusa yaisina medifike irau ukeka korosi ari mufike Nanu umuro aafie wei. ");
INSERT INTO aby_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Eno weike wei, moi mima yewa orofaro me ibifine imufekuie dawa ido feafekua wei. Yesuma eno weike wei, nono moi mima Naini Godinu wakebake feafekuie dawa nono uyafekuke me ibene ibene ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ainama i orofa akakanu eraerabusa yaisina mufekuro danu me ibeka imumu i merama orofaro fe yafekuie irauaiaiba me wei? Eno we nauike wei, ie irau meya wei. ");
INSERT INTO aby_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Danu me ibeka imumu aneme aneme make mufekuke anemeke ane ma owere mufeku ari weike nono wei, i ari eno da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yewa odoro eme keuwere Godinu wake nauke dakaisake merama mane ukaisa. Enoba ainama i ari eno ukaada Godinu wakebake maru ufekuie i Ba Eme Sini Mini Danu buna aneruini Danu Babaenu bunaini arakekaini idua fafeisaie i mibake moko maru ukaada dawa medifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuma moi wake emuabake eno wei, Nanu wakeye ba weakunea wei. Moi yewado enare ibinisa orou da feafeisaro Godinu yawokaku odoko bokai bunawere uke fafekuro efeisakema ai feafeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Odo sikisi (6) me siniro Yesuma Fidaini Deimisini Dionini emua we wauriro dai oraararo amuke anisa. Amuke anisake i oraararo ibisaro Yesu Danu iboo naisa imusu uiro Danu wau edoroini ou ari inanakeo sini. Moi wau urokeibaku mi i ari eno wau uroke dakeibaku. ");
INSERT INTO aby_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","5","Iraidaini Mosesini emua me ari uke fakike Yesubairo wake weibisiro ekake Fidama Yesubake eno wei, Dai mi, ewado irauaiai ibinisiba ibake okoa uwarananaku deibuuba Anu moi, Mosesinu moi, Iraidanu moi ma enafeisiba me wei? ");
INSERT INTO aby_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Emua ia daiwere iyakake ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eno weibaie ouma ma yaariro ou ubarenaroma wake isare aarike eno wei, yewae Nanu Amara ubiya Danu wake naukeibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eno weiro sabu ekabaie moi miyai iro mero Yesu mane enare ibiro eka. ");
INSERT INTO aby_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","I oraararoma isare aarada Yesuma eno wei, i oraararo erisa ibai moi oroubairo da weforo wei. I Ba Eme Sini Mi Dawako fearekaroma uyafekuie ido we boroo yafoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eno weiro nauisake emenu emenu we makakake eno weisa, fearekaroma uyafekude anemedei arie weisa? ");
INSERT INTO aby_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eno weisake Dawabake nono weisa, i Mosesinu darawadu we ma iwoka ukaisa orouma eno weaisa, Iraida dawako aafekuro i Keriso Dawa dubuenaro aafeku ideie anemebake eno weaisa weisa? ");
INSERT INTO aby_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eno weisaro Yesuma ma owerike eno wei, ba weakunea, Iraida dawako farike ibaada yaisina uke boubou ukeibia wei. Godinu bukaroma i Ba Eme Sini Mibake eno weaku, Dawae oferi daiwere waufekuro Dawabake imuka ka ufeisaya eno weaku. ");
INSERT INTO aby_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yesuma Dioni Babadaido mibake imukada dubo waure weike eno wei, Iraida fariro dawabake merama uke yaraada emenu arara erabusa ukeibisa, Godinu bukaroma eno weakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuini Danu iwoka ukeka orou una buubaini Danu eneiareibisaro iwoka ukeka oroubairo aare fakake ekabaie eme keuwere enare kara uke ibisa. Yesu Danu iwoka ukeka oroubairo enare kara ukaro i Mosesinu darawadu we ma iwoka ukeibisa orouini moi iwoka ukeka orouini dino wake we makanada enare ibisa. ");
INSERT INTO aby_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Enare ibisaro Yesu ido fariro ekake emenu imuka foria ukaada Yesubairo durame ane fakake arie weisa. ");
INSERT INTO aby_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","17","Arie weisaro Yesuma wei, aneme wake weaisa wei? Eno weiro moi mima i ku uke ibisa orounu kuroma uyarike eno wei, nanu seidaninu merama imumu bobo amaranaku waure fanea wei. ");
INSERT INTO aby_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Eno weike wei, i seidaninu merama imumuma nanu amaranakunu wake weeka daaba enare yaarakuke nono moi odo mune sianakuro isare uraada begiri farakuke nio ake fagigi yaraada danu ofe bedada ukaku ibake waure fanea wei. Anu iwoka ukeka oroubairo wenero i seidaninu merama imumu we berake dakisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eno weiro Yesuma ma owerike eno wei, yae imukenewaa uke dakaisa oroua wei. Yabairo odo abea ibimauro imukenewaa ufoisa wei? Yesuma eno weike nono i mibake eno wei, anu amara waure aara wei. ");
INSERT INTO aby_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eno weiro Dawabairo waure fariro seidaninu merama imumuma Yesu erike i amaranaku ma birubiru uike mune sianiro dooro isare urike iura mamaada bebekuroma begiri fareibi. ");
INSERT INTO aby_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eno ukeibiba ibake Yesuma danu babaebairo eno wei, odo abea eno ukaku wei? Eno weiro wei, okoanakuroma eno uke eneiyarakukema awoena dai sininua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Moi furo inaa domearoini aduaroini feafine mune sianeibakua wei. Enoba A imukari ufakuke unu kofakuba me wei? ");
INSERT INTO aby_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eno weiro Yesu ma owerike eno wei, anemebake ufakuba me weaku wei? Ainama imukenewaa naukenewaa ufekuie yaisina enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eno weiro i amaranakunu babaema daiwere eno wei, na imukakunea wei, nanu imukekae okoanakuba ibake Ama na unu kofarine weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eno weiro i ku uke ibisa orou durame aareibisa ibake Yesuma i seidaninu merama imumubake eno wei, nauke me wake we me imumu anifake nono da owere aafao wei. ");
INSERT INTO aby_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yesuma eno weiro i seidaninu merama imumuma imuka ubarenaroma arua daiwere weike i amaranaku ma birubiru uike fare ani. Fare aniro i amaranaku fearaisari uike aine ibiba ibake moi orouma ekake eno weisa, dawa fearinua weisa. ");
INSERT INTO aby_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eno weisaro Yesu danu wanama mamike ma uyariro uyare enari. ");
INSERT INTO aby_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuma uwara ubarenaro amuiro Danu iwoka ukeka orouma fenakuma eno weisa, yeka seidaninu merama imumu anemebake we berake dakisi weisa? ");
INSERT INTO aby_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eno weisaro Yesuma eno wei, yanu guriguri ukeka ima we berafoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","I orofa ido meisake Gareri orofa ma bereisa. Yesu Danu iwoka ukeka oroubake we ma iwoka ufine fema anisake eno we ma iwoka ukaada eno wei, i Ba Eme Sini Mi moi orounu wanaro mame odifeisaro emuama mufeisake ma feafeisaro eweka odo buuba me sifekuro nono fearekaroma uyafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eno weiro Danu wake iwoka sine da uisake ia sikake i wakenu ubi Yesubairo we nauke ere dauisa. ");
INSERT INTO aby_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kafenamu goiro aare fakaro Yesuma moi uwara ubarenaro amuike Danu iwoka ukeka oroubake eno wei, daabaro aarada aneme wake we aarisa wei. Eno weiro wake muu uisa. ");
INSERT INTO aby_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Emua enaada uraneka wake weibisa. Eno weisake weisa, ainama dai mi sifeku weisa? Eno weibisaba ibake Dawama we nauke eriero moko wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu yaurike u weiro Danu iwoka ukeka orou Dawabairo fakaro emuabake eno wei, ainama dai mi sifine ufekuie i mi dawako okoa mi sifekuke eme yaisina unu koreka mi sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Eno weike moi amaranaku munike aroro ma enare odike yabakada eno wei, ainama moi amaranaku mufekuie dawa Na mufarakua wei. Dawa Na mufarakuie dawae Na we odai Godini mufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dionima Yesubairo eno wei, Sisa mi, moi mima seidaninu merama imumu we berake ibiro ekike eno weisi, media weisike iyanu buriro enareka mi meya media weisia wei. ");
INSERT INTO aby_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eno weiro Yesuma wei, mediaweke i wake da weawe wei. Ainama buna ukeka Nanu ibiro ukeibakuie dawa wake merama Nabake we dakeibakua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ainama yaini Naini wasai uke dakakuie dawa yaini Naini iyanu unu koreka miya wei. ");
INSERT INTO aby_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yesuma eno weike wei, yae Kerisonu umuro enaraisaba moi mima yabake adua ifone mafiakuro Godima ibai da imuke medifekuke nono i mibake moko mafekua wei. Enoba yabairo wenewaa ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Godima i merama ma iwoka ukaisa orou fanisi daiwere mafiaku ibake yewa wake eno wei, moi mima Nanu wake naukaisa amaranakubairo ba me ukeka ma iwoka ufekuro meramawere unao ufeku ibake i mi i ba me ma iwoka uke me i furo i minu fayaro naama dai omawere doifeisake kunaro siafeisaro imu ifironaie irauaiaiya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anu wanama a ma merama umekuie umane kuure siafakuke wana demui mane ibifakuie irauaiaiya wei. Wana raarayaini feare me inaaro anifakuie meramawere enoya anu moi wana umane kuua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Iro i yareibaku inaaro anifeisaro i dofema emua iseifiakaisaro nono inaama emua yareifiakua wei.) ");
INSERT INTO aby_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Anu umuma a i merama daabaro mune odaimekuie umane kuuake umu demui mane i me ibene ibene ibeka orofaro anifakuie irauaiaiya wei. Umu raarayaima inaa yaraku orofaro anifakuie i inaae meramawere enoya anu umu umane kuuake siaa wei. ");
INSERT INTO aby_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Iro i yareifeku inaaro anifeisaro i dofema emua iseifiakaisaro nono inaama emua yareifiakua Yesuma eno wei.) ");
INSERT INTO aby_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anu naisama a ma merama umekuie i naisa ma doroo yaake mune siake naisa kai demui mane Godinu yawokaku orofaro eno uke anifakuie irauaiaiya wei. Nono naisa raarayai bobo inaa yaraku orofaro anifakuie meramawereya wei. ");
INSERT INTO aby_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iro i yareifeku inaaro anifeisaro i dofema emua iseifiakaisaro nono i inaama emua yareifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Eno weike Yesuma nono wei, i irauaiai ukeka sinekae i damenama ma imuna ukakuro irauaiai imuna ukaku uruna ari. Enoro emema emenu auri inaaro yare fidema ma gienabu ukaisari Godima danu orou inaama yare ma giena unao ukaku. Eno ukaada emenu naukeka ma arabi ufine ibake arabi inaama yaare ma giena ukaku. ");
INSERT INTO aby_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","I damenae irauaiaiya wei. Damenanu imuna me sifiro danu imuna nono aneme aneme odifoisa wei? I enaenari ya irauaiai da ufoisaie ya imuna me damena ari. Enoya ya imuna damena ari sine ibiawe wei. Eme yaisinabake yanu yanu imukari uke makanada irauaiai uke makaneibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu i orofa medike iroma Diudiaini Diodeni orofayairo ane farike i Diodeni adua siraa yare ibiro i orou Dawabairo fakake enare kara ukeibisaro Yesu Danu adinaro we ma iwoka ukeibirie enaenari ukeibi. ");
INSERT INTO aby_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eno ukeibibaie i Ferosi weaisa orouma Yesubairo we iruke efisane fakake we naukake eno weisa, moi mi danu aweka me sara medifekude irauba merama weisa? Danu moko wakeye aneaneme wefibai naufisane ibake eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eno weisaro Yesuma ma owerike eno wei, i Mosesima yanu sisia sirorari oroubake aneme weiro nauisa? ");
INSERT INTO aby_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yesuma eno weiro emuama eno weisa, Mosesima eno wei, moi mi danu aweka medifine kodo fefa i kodo yawokeka mibairo mufekuke danu awekabairo mafekukema nono ai medifeku weia weisa. ");
INSERT INTO aby_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Eno weisaro Yesuma emuabake ma owerike eno wei, yanu imuka arawereba ibake Mosesima eno weibia wei. ");
INSERT INTO aby_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Godima emeini awekaini emua ma dakaa ufekuie moi mima da ma fiafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adinarowere Godima orofa akaka yaisina odaada emeini aweka ubu urieba ibake emema danu babaeini amaeini medifekuke danu awekabairo dakaa ufekuro emuae demui ari eno sifisisia wei. ");
INSERT INTO aby_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ibake emuae rarayai mero emuae una demui. ");
INSERT INTO aby_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Godima emeini awekaini emua ma dakaa ufekuie moi mima da ma fiafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","11","Dubuenaro uwara ubarenaro danu iwoka ukeka orouma Dawabake i wei wake we nauke ekaro ma owerike eno wei, moi mima danu aweka medifekuke moi awoena aweka dawa ido mufekuie i mi danu awoena awekaini dodoo ukeifisisiie danu adina awekanu ibeka ma merama ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yesuma eno weike nono wei, moi aweka danu eme medifekuke moi eme mufekuke danu awoena emeini dodoo ukeifisisiie danu adina emenu ibeka ma merama ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Moi orouma emenu amarananaku Yesubairo waukake wanama iiriro odifine faka. Fakaro Danu iwoka ukeka orouma dino wake weisa. ");
INSERT INTO aby_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eno weisaba ibake Yesu dino uike emuabake bunawereroma eno wei, da we kuuawe wei. I amarananaku Nabairo aafisane weakunea wei. Godinu yawokaku orofae emenu ibake aafisane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eno weike nono wei, ya amarananakunu ure ribuku ukaisa enaenari da ufoisake eme unu kofiakaisaie ya Godinu yawokaku orofaro da anifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I amarananaku moi wanama yabakeibike nono moi ena wanama mune iiri duboro odaada we ma irauaiai ukeibi. ");
INSERT INTO aby_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuma i orofa medike daabaro ani. Daabaro aneibibaie moi mi durame eneebe farike ibooro ifoma kodudu yanakada eno wei, irau Sisa mi, na aneaneme umauke me ibene ibene ibimau wei? ");
INSERT INTO aby_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eno weiro Yesuma ma owerike dawabake eno wei, anemebake nabairo irauaiai me weaku wei. Eno weike wei, moi mima irauaiai meya wei. Godi Dawa mane irauaiaiya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Godinu darawadu a iwoka sinaku wei. Eme da ma fea, naiyenu awekanu umuro da yowea, waira da ua, da we irua, wayai wake weada meo da wea, anu amaeini babaeini irauaiai rirokenewaa ua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eno mane weiro i mima Yesubake nono wei, Sisa mi, na okoanakuroma eno ukeibakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eno weiro Yesuma i mibake imukari ukaada weike nono wei, dei demui mane eno ufaku wei, aniake anu eraerabusa yaisina oiya uke make oi muake erabusa me oroubairo anu oi yaisina mayanake Nanu umuro aara wei. Anu eraerabusa mafaku i ari enoe anu urero enaenari mafekuro mufakua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Eno weibaie i minu eraerabusa daiwere ibake danu iboo imusu odaada imuka merama imuike Yesu medike owere ani. ");
INSERT INTO aby_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuma Danu iwoka ukeka oroubake oweowere ukaada eno wei, eraerabusa daiwere bobo mi dawa Godinu orofaro anifine ukaadae ara daiwere ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eno weiro emenu imuka foria daiwere uisaro Yesuma nono wei, adara, Godinu yawokaku daabaro anaada ara daiwere ukeibaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eno weike nono eno wei, kemo abuma bobo ebaro fare anakuro ara dakakuroma nono i eraerabusa keuwere bobo mima Godinu yawokaku daabaro anaadae ara daiwere ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesuma eno weiro kawama naukake foria daiwere ukaada eno weisa, ainama wirofeku weisa? ");
INSERT INTO aby_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eno weisaro Yesuma emua eraada nono wei, Nama i wene ibai emema da ufeisaie Godima i yaisina ufekuke Dawa mane i orou ma wirofiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eno weiro Fidama eno wei, aruarumananakuini amarananakuini eraerabusini yaisina meisike anu umuro aaraisia wei. ");
INSERT INTO aby_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Eno weiro Yesuma ma owerike eno wei, Nanu wake naukeneawaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ainama danu uwaraini daburakaini aruarumaini amae babaeini amara arumaini dooini yaisina Godinu wakeini Nabake medifine dubuenaro danu uwaraini amarananakuini aruarumananakuini amaeini kuaboroini dooini medifeku i ari keuwere urero moko mufekuke nono i waa uyarekaini mufekuie nono dubuenaro me ibene ibene ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Eno weike nono wei, moi yewa dooro daiwere sine ibinisa oroue iro okoanaku sifeisaya wei, nono moi Godinu waiya ukaisa orou emuae yewa dooro okoananaku nono iro amufeisaie daiwere sifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","I Derusaremu daabaro Yesuko bokairo amuke aneibi. Amuke aneibiro Danu iwoka ukeka orouma Danu wei wakebake imuka foria uisake iro amuke anisaro nono moi orou ia sikake amuke anisa. ");
INSERT INTO aby_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesuma Danu orou yaisina duero (12) murieke emenu imusunaku anaada i dubuenaro ufeku ibai eno wei, Derusaremu goiro anifero moi mima Na i Ba Eme Sine Mibake wayai wake wefekuke mune i dai ofereni ode sibore sianeka orouini nono i Mosesinu darawadu we ma iwoka ukaisa orouini emuama Dawa mufeisake ma feareka wake weifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eno ufeisake i imusu orounu wanaro mafeisaro mufeisake uke irufeisake wisiomu ufeisake mobuma ufeisaya wei. Eno ukeebe nono ma feafeisaro feafekuro odo buuba me sifekuro nono iroma uyafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Debedinu amarayai Deimisini Dionini emuama Yesubairo fakike eno weisi, Irau Sisa mi, uwanu imukaisu rabu uwabake mamukuba me weisi? Eno weisiro Yesuma ma owerike emuabake eno wei, yabake anemerabu mamiane weaisi wei? ");
INSERT INTO aby_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","37","Yesuma eno weiro emuama nono weisi, Anu buna yawokaku odo fafiro Anu ba ena wana enaroini Anu ewani ena wana enaroini yaufune weaisua weisi. ");
INSERT INTO aby_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Eno weisiro Yesuma nono wei, yanu we nauke erekae ya iwoka mero me sara weaisia wei. Na ure yanake ukeifeisaro yaini enaenari enare ara ufuaisiba me wei? ");
INSERT INTO aby_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eno weiro emuama nono weisi, euwa enaenari ufukua weisi. Eno weisibaie ba weaisia wei. Eno weike nono emuabake eno wei, Na ure yanake ukeifeisaro enaenari ufuaisike Nanu babadaido umau enaenari ufuaisia wei. ");
INSERT INTO aby_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eno weike nono wei, i yaureka orofayaie nanu meba ya da mamiauro da yaufuaisia wei. Moi oroubake Godima i orofa uke bou uiba Dawama wefekuro yaufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","42","Yesu Danu moi deni (10) iwoka ukeka orouma i weisabai nauisake Deimisini Dionini dino uke yariekaro Yesuma emuabake u weike eno wei, I imusu dai yawokeka orou emenu oroubairo arawere yawokada emenu imukeka emuabairo arawere odaisaro ya ibai iwoka sinaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Enoba emenu ukaisa i ari eno ya uke dakaisa ibake yabairoma ainama dai mi sifekuie ya yaisina unu kofiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","O ainama bokai mi sifekuie dawama yanu waiya ukeka mi sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","I Ba Eme Sini Mi ido fariro emema Dawa unu kore da uisaro Dawama emua unu kofiane fari. Nono dubuenaro danu wirokeka iwama eme keuwerebake isafeku ibake eme keuwere make munao ari ufekuro irau sifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu Deriko goiro fare anaada Danu iwoka ukeka orouini moi eme keuwere iroma Danu umuro aneibisaro Dimiesinu amara Badimiasi dawa naisa kikori boboba ere dakaada eenu moi oroubairo weibi mi. Dawama daaba udiro yaure ibi. ");
INSERT INTO aby_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yaure ibiro Yesu farike aneibiro Dawa Yesu Nasaredi goi mi weisaro nauike u weike eno wei, Deiwidinu sisia sirorari mi Yesu nabake imukari ua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eno weiro Yesunu umuro enereibisa orouma fakake eno weisa, wake da wea weisabaie nono daiwere u weike wei, Deiwidinu sisia sirorari mi Yesu nabake imukari ua wei. ");
INSERT INTO aby_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eno weibi ibake Yesu iduama enarike eno wei, i mibake nabairo aafi weawe wei. Eno weiro naisa kikori mibake eno weisa, da ia siake uyaa weisake nono weisa, Yesu abake u weakua uyaa weisa. ");
INSERT INTO aby_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eno weisaro uyarike danu dubo barukeka wau ma worome mune sianike Yesubairo sabu ane fari. ");
INSERT INTO aby_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Fariro Yesuma dawabake eno wei, abake aneme umane weaku wei? Eno weiro i naisa kikori sini mima wei, Dai Mi, na naisa ere dakakuneba ibake emane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eno weiro Yesuma ma owerike nono wei, ania, anu imukeka imukae daiwere ibake wirokinua weiro naisa foraike erike Yesunu umuro ani. ");
INSERT INTO aby_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Derusaremu goiro aarebe Bedifeidaini Bedeni goiro aare faka. I goiyai oraara ibi Oriwa udiro aare fakaro Yesuma Danu iwoka ukeka orou moi miyai we odaifiane ukaada eno wei, aniawake goi araweko udiro uwara kubunero okoa doniki weaisa abu doise oisaro ibinuba efuaisiie ma worome muawake waure aarawa eno wei. I doniki duboro moi orou yaure me wei. ");
INSERT INTO aby_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yesuma eno weike nono wei, moi orouma eno wefeisa, ainama wenuro i doniki ma woromaisi wefeisaie, eno yama weawa wei, uwanu Dai Waria Mima mufune wenua weawaro mafia wei. ");
INSERT INTO aby_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eno weiro anisike okoa doniki ekibaie i doniki goi ebamoko uwararo uwane oisaro enare ibiro ekike ma woromeibisi. ");
INSERT INTO aby_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ma woromeibisiro i goi orouma eno weisa, aneme ukaisi weisa. Eno weisake weisa, anemebake i doniki ma woromaisi weisa? ");
INSERT INTO aby_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eno weisabaie emuama weisi, Yesuma wenuro ma woromaisua weisiba ibake mariekaro doniki mune waukike Yesubairo anisi. ");
INSERT INTO aby_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Waure aare fakike emenu dubo barukeka wau kukune i doniki duboro yaweke oisiro Yesu i doniki duboro amuke yauri. ");
INSERT INTO aby_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","9","Amuke yauriro eme keuwere emenu wauini farai kakabaini daabaro yaweke ode aneibisaro Yesu ubarero i dubo duboro aneibiro bokai orouini dubuena orouini emuama rooro daiwere ukaada ousana weada eno weisa, iyanu Dai Waria Mi yewado farinua weisa, Danu dai Godinu ibiroma farinu Mi idua irauaiaiya weisa. Godima Dawabake irauaiai ukeibakua weisa. ");
INSERT INTO aby_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iyanu dai sirorari mi Deiwidinu yawokeibi odo i ari moi awoena yawokeka odo we dawama ma irauaiai ukaada ibifekua weisa. Eno weisake nono weisa, iyanu urero Dai Mi, daiwereroma weisake eno mane ukeibisaro Yesu fare ani. ");
INSERT INTO aby_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Fare anike Derusaremu goiro ane farike i Derusaremu dai sosi uwara ubarenaro amui. Amuike ereibiro dumudumu sinibake Dawaini Danu eme yaisina dueroini (12) emuama Derusaremu goi meisake Bedeni goiro owere anisa. ");
INSERT INTO aby_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wai awanakuro i Bedeni goi meisake aneebe Yesu desini uri. ");
INSERT INTO aby_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","14","Yesu desini uriro boruba ana roro erike boruba kai mune ifine ani. Ane farike eribaie kai uwane me furobake kakabai maneba ibake eraada eno wei, anu kai moi orou da iseifisane weakune weiro Danu iwoka ukeka orou nauisa. ");
INSERT INTO aby_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Derusaremu goiro aare fakake Yesuma i dai sosi uwara ubarenaro amuke ani. Amuike oi make mune ukeibisa orouini oi muneka orouini yaisina yoweriro isakaro emenu oi moko make muneka seboini ofereni odeka ubari adaini mune makeka orounu yaureka seboini mune sianiro ubere aine ibisa. ");
INSERT INTO aby_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","17","Eno uike i fefenaro erabusa waureka orou da anifisane enare kuurike wei, Godinu bukaroma eno weaku, Nanu uwara dawa eme yaisinanu guriguri ukeka uwaraya wei. Godinu bukaroma eno weakuba me wei? Eno weike nono wei, yama waira ukeka orounu uwara ubu ukisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Eno weiro i dai ofereni ode sibore sianeka orouini i Mosesinu darawadu we ma iwoka ukeibisa orouini i Yesu wei wake nauisake Yesu ma feareka daaba yodia ukaada Yesu Danu wei wakebake ia sika. ");
INSERT INTO aby_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dumudumu siniro Yesuini Danu waiya ukeka orou i goi ido meisake owere anisa. ");
INSERT INTO aby_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Wai awanakuro daabaro fakake anaada ekabaie ena boruba ana yaisina boma urike ibiro Fidama erike eno wei, Dai Waria Mi, Ama boruba anabake wake weiro boma urinua ea wei. ");
INSERT INTO aby_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Fidama eno weiro, Yesuma wei, Nanu ba wake wemaro nauawe weike wei, Godi imukeibiawe wei. Aina mima i oraarabake eno wefekuie uyake dawara ubarenaro isaa, eno wefukukema nono Babae Godi imukenewaa ufekuie enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eno weike nono wei, aneaneme we nauke eraada guriguri ufoisake Babae Godi imukenewaa ufoisaie enaenari mafiakuro mufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya dawa enare ibaada guriguri ufoisaie moi mima yabake merama ukeka sineka uibai imukada imuke medifoisaie nono yanu urero ibinu Babaema yanu merama ukeka sineka mune imuke medifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yanu naiyemukunu merama ukeka sineka da mune imuke medifoisaie nono yanu urero ibinu Babaema yanu merama ukeka sineka da mune imuke medifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Derusaremu goiro nono anisake dai sosi uwara udiro enereibisabaie dai ofereni ode sibore sianeka orouini nono i Mosesinu darawadu we ma iwoka ukeibisa orouini dai sosi yawokeibisa orouini eme keuwere Dawabairo fakake eno weisa, Anu bunaroma eno ukaku weisa? Ainama i ari eno buna maiairo ariena eme i dai sosi uwara ubarenaroma yowerie weisa. ");
INSERT INTO aby_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eno weisaro Yesuma emuabairo ma owerike eno wei, Nanu yabairo we nauke ereka wake wemaro nabairo irauaiai moko weforo naumaukema ainanu bunaroma ukakune ibai wemauro naufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Eno weike nono wei, Dioninu babadaido ukeka Godima weiro ukeibiba emema weisaro ukeibi weawero nauma wei. ");
INSERT INTO aby_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yesuma eno weiro wake we makakake eno weisa, aneme wefeisi weisa, Godibairoma faria wefeisiie nono anemebake Dioninu weibi wake imuke da uisa wefekua weisa. ");
INSERT INTO aby_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","33","O emebairoma faria wefeisiie i orou yaisina emuama iyabake dino ufeisa ibake aneaneme weifeisi arie weisa? I orou yaisina imuisa, Dioni dawa Godinu we bou ukeka mi imuisaba ibake ia sinaada eno weaisa, Dioninu babadaido ukeka aboroma fari ibai iya iwoka meya weibisaro Yesuma ma owerike emuabake eno wei, Ainanu bunaro ukakune ibai da wemauro ya da naufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuma moi wake dubo waure weike eno wei, yewa wakeye Danu onamibake emuabairo eno wei, moi mi gureifi waiya umanike diru kuurike omama oro mame kara uike gureifi yobai wawi. Eno uike danu waiya moi orouma yawofisane marieke moi orofaro ani. ");
INSERT INTO aby_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nono dubena ayo ureka oya fariro danu waiya ukeka mi danu gureifi kai mufine we odairo ani. ");
INSERT INTO aby_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ane fariro i waiya yawokeibisa orouma i mi mukake usima ureebe gureifi kai make da uisake ma owekake we odaisaro ani. ");
INSERT INTO aby_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aniro nono moi mi we odairo ani. Ane fariro bokairo mukake ureebe nono ma owere odaisaro ani. ");
INSERT INTO aby_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ane fariro nono moi mi deri we odairo ani. Anike ane fariro mukake ukaro feari. Nono dubuena eme keuwere emua deri we odaiseibiro aneibisaro moibai usima ureibiriekake moibai ma feareibisa. ");
INSERT INTO aby_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Eno mane ukeibisaro eme moi mebake imukama imui, Nanu amara ubi we odaimaro dawabake iifa ufeisaya we imuike we odairo ani. ");
INSERT INTO aby_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","8","Ane fariro emenu emenu we makakake eno weisa, yewae danu amara ubiba ufeisike danu waiya mufeisia weisake munaadae ukake mune oro derena enaro siaka. ");
INSERT INTO aby_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eno ukaba ibake i waiya onami mima aneme ufeku wei? I waiya onami mima anifekuke i waiya yawokaisa orou ma feafiakuke danu waiya imusu oroubairo mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Godinu bukaro i wake kakuraisaba me? Na iwoka, ya kakuraisa. I Godinu bukaroma eno weaku, i uwara ma enarada mune siaka omama i bokai kukubu kora kai ari sini. ");
INSERT INTO aby_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yewae iyanu Godinu ukekabake kawama eraisia, eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuma i dubo waure wei wake emuabairo eno weibiba ibake Dawae iyabairo eno weakua we imuisake Dawa ma feafisane daaba yodia ukaada nono emuae i moi oroubake ia iyarada meisake mede anisa. ");
INSERT INTO aby_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","14","Moi orouma Ferosi orouini Erodi orouini emuama Yesu we iruke efisake mufisane wake weisake i orou we odairiekaro Yesubairo ane fakake eno weisa, Dai Waria Mi, A dawa meo me miya ba mi ibai iya iwoka ukaisia weisa. Eme yaisinabake emuae demuiya eno we imukaku. Eme moi daiwerero nono moibai okoanakua eno we imuke dakakua weisa. Eno weisake nono weisa, Ama Godinu wake we ma iwoka ukenewaa ukeibakuro ibai iya iwoka sinaisia weisa. ");
INSERT INTO aby_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ibake i Romani dai gaemani mi Kisabake dakesi oi mafeisiba me weisa? Eno weisaro emuama Dawa irukeka imuka imuisa ibai Dawa iwoka uiba ibake eno wei, anemebake we irukaisa wei? I siriwa oi makowero ema weiro maisa. ");
INSERT INTO aby_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Maisaro i oi inana eraada wei, ainanu ibo naisaini owaowaini ewado ibinu wei? Eno weiro emuamae Kisanua weisa. ");
INSERT INTO aby_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eno weisaro Yesuma ma owerike eno wei, Kisanu aneme aneme dawabake ma owere maeweke nono Godinu aneme aneme Godibake ma owere maewe weiro i wake kawama Yesuma idua eno weiro nauisa. ");
INSERT INTO aby_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Dubuenaro moi Sadusi orouma Yesubairo faka. I orouma eno imukada eno weisa, moi orou feafeaisake da uyafeisaya eno weada we ma iwoka uke enereibisa. I orouma Yesubairo aare fakake we iruke eraada eno weisa, Dai Waria Mi, Mosesima eno weia weisa, moi mima aweka mufekuke aruma amara mune da ufekuke me ibeebe feafeku. Feafekuro danu nabuema danu kakanu aweka wabu mufekuke nono i feafeku mibake aruma amara dore mufekua eno owaowa uke odike weia weisa. ");
INSERT INTO aby_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eno weisake nono weisa, demui aidakaku seweni (7) ibeebe bokai mi feari. ");
INSERT INTO aby_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Feariro nono danu abana nabuema danu kakanu aweka wabu munike amara aruma dore mero me ibeebe feari. ");
INSERT INTO aby_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Feariro danu moi abana nabuema munike amara aruma dore mero me ibeebe feari. Feariro eno mane i eme sewenima i aweka munaada amara aruma dore mero feare me sikaro nono i awekaini dubenama feari. ");
INSERT INTO aby_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Enoroma dubuenaro i feareroma uyareka odoro abo mima i aweka mufeku weisa? I eme yaisina seweni mukaba abo mima mufeku weisa? ");
INSERT INTO aby_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eno weisaro Yesuma wei, Godinu bukaro wakeini Danu bunaini ya iwoka meba ibake imuke dakaisake ma nuna ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yesuma eno weike nono wei, i urero ibinisa aneru emua aweka mune dakaisa enaenari eme yaisina feafeisake nono uyafeisaie aweka amara da ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Feareka orounu uyareka ibai Mosesinu bukaro kakuraisaba me wei? Eno weike nono wei, i yareibaku ananu i wake ya kakuraisaba me wei. Nono weike wei, I wakero Godima Mosesibake eno wei, Nae Eibaramuini Aisikini Deikabuini emenu Godiya wei. Godi Dawae i feareka orounu Godi meya eno weike wei, i orou feakakema awoena urero ibinisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eno weike wei, Dawae i wirokeka orounu Godi ibake ya ma nuna ukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Emuama wake wake we makaneibisabaie moi Mosesinu darawadu we ma iwoka ukeibi mima farike Yesu Danu irau wake naukebe imuike Yesubake eno wei, abodei darawaduma daiwere wei? ");
INSERT INTO aby_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eno weiro Yesuma ma owerike eno wei, i dai darawadue enoya wei, ya Isaraera orou, nauawe, yanu dai Godi Dawa demui maneya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yanu Dai Godibairo yanu awararoma imukekaini yaisina yanu imumuini imukama imukekaini yanu bunaini yaisina Godibairo odaada imukari uawe wei. ");
INSERT INTO aby_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yesuma eno weike nono wei, moi darawadu i ari enoya wei, yanu naiyemukubake yanu onarou ari imukari ukeibiawe wei. Eno weike nono wei, moi dai darawadu meya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eno weiro i mima eno wei, ba weakua wei, Dawa demui Godi manero moi meya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I mima nono wei, Godibake imukari ukenewaa ufeke imukenewaa ufeke ukenewaa ufeke iyanu naiyemukubake iyanu onarou ari imukari ukenewaa ufeisiie irauaiaiya eno wei. Eno weike nono wei, ofereni odekaini ofereni yarekaini irauaiai meya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eno weiro danu wake irauaiai weibibake Yesuma wei, Godinu yawokaku daaba ubiubi anifane ukakua wei. Yesuma eno weiro nono moi wake we nauke ereka we ere dauisa. ");
INSERT INTO aby_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dai sosi uwara ubarenaro Yesuma we ma iwoka ukaada eno wei, i Mosesinu darawadu we ma iwoka ukaisa orouma eno weaisa, i Kerisoe Deiwidinu sirorari miya anemebake eno weaisa wei? ");
INSERT INTO aby_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eno weike nono wei, I Kerisoe Deiwidinu sisia mi mane meya Dawae danu Dai Waria Mi. Godinu Imumu Irauma Deiwidibairo ma iwoka uiba Deiwidima eno wei, Godima Nanu Dai Waria Mibake eno wei, Nanu ba ena wana enaro yauaro aini wasai ukaisa oroubake buna umake Anu umu wowonaro odimia weiro Deiwidima eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deiwidima i Kerisobake Nanu Dai Waria Mi weibairo nono aneaneme Keriso Dawa Deiwidinu sirorari mi sini wei? ");
INSERT INTO aby_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Yesuma eno weiro i orou yaisina Danu wake naukenewaa uisaro we ma iwoka ukaada eno wei, eforo moi Mosesinu darawadu we ma iwoka ukaisa orou emema emenu ibi we ma daiwere ufiakaro naufisane ibake yafa wauma barufeisake i makedi orofaro enaraisa orouma a farinu wefisaro naufisake nono i Du orounu sosi uwara ubarenaro irau yaureka orofaro aweawe yaufisake banau uruna ifisane ibake enaenari ukeibisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eno weike nono wei, i orou emenu ararae eno mane ukaada nono emenu guriguri yafawere ukeibisaro moi orouma naufisane ibake eno wefisakema nono i wabu awekabonu eraerabusaini uwaraini yaisina waira ukeibisaya Yesuma eno weike nono wei, dubuenaro Godima emua fanisi daiwere mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","44","Dubuenaro dai sosinu me makeka oi bogesi ubiubi yaure ibaada ereibiro eme keuwere emenu oi fare odeibisa. Moi erabusa keuwere orou keuwere odeibisaro nono dubuenaro erabusa keu me wabu awekama farike danu korofeni oi kai raaranaku bogesiro odiro Yesuma eraada danu iwoka ukeka oroubairo weiro fakaro wei, Nanu wake nauwe wei, Yewa wabu aweka danu uruna make muneka oi yaisina odinu ibake danu oi daiwere odinua wei. Yesuma eno weike nono wei, eraerabusa keuwere orou oi daiwere oisaro emuabairo keuwere ibinisaba ibake okoananaku oisaya wei. Nono i wabu aweka dawabairo ibinu oi yaisina idua odinua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuma i dai sosi medike isareibiro moi iwoka ukeka mima eno wei, Dai Mi, oma daibaima uisa uwarawerewere ea wei. ");
INSERT INTO aby_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eno weiro Yesuma ma owerike eno wei, i dai uwarawerewere eraku wei? I oma yaisina ubefisaro moi omama moi oma duboro da ibifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","5","Dubuenaro Yesuma i Oriwa oraara okoro yaure ibaada dai sosi ereibiro Fidaini Deimisini Dionini Enuduruini emenu mane Dawabairo fakake eno weisa, Anu wenu enaenari abonodo ufeku weisa? I dubuena kai odo aneme aneme ufekuro efeisiroma fafeku weisa? Eno weisaro Yesuma ma owerike emuabake eno wei, erenewaa uforo wei. ");
INSERT INTO aby_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eme keuwere we irufisane nanu ibiro fafeisake eno wefeisa, na dawa Keriso, na dawa Keriso eno mane we irufeisake wefeisaro eme keuwere naufeisake emenu umuro anifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yesuma eno weike nono wei, ubiubi uraneka wake yama naufoke nono yafawere uraneka wake naufoisaie ia da siforo wei. Eno mane ufekuro ibai me sifekuie nono i dubuena kai odo idua fafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I orofa akaka imusu imusu uranefeisaro moi orofa gaemanini moi orofa gaemani uraneifeisaro moi oroorofaro doo amani amani ufekuro akaka keuwere arumu daiwere yaufeisake eno mane ufeisaro i merama dubuena kai odo idua fafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Enoya ibai erenewaa uawe wei. Ya waufiakaisake moi kanisoro oroubairo waure ane odifiakaisa. Eno ufeisake nono i Du orounu sosi uwara ubarenaro waure ane odifiakaisake usima ufiakaisake gaemani orouini kini oroubairo waure ane odifiakaisake Nabake ya eno ufiakaisaro yama Nanu ukeibisara wake emuabairo wefoisaro iwoka sifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yesuma eno weike nono wei, Godinu irau wake i orofa akaka orou yaisinabairo bokai iro we eneifeisaro dubuenaro i me sifeku odo ido fafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","I orouma merama ukeka eraerabusa fafeku odoro aare ya mufiakaisake waure anifiakaisaro yanu wefoisa wake aneme aneme wefoisa i ari eno da imuforo wei. ");
INSERT INTO aby_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Godima yabairo mafiaku wakema wefoisa wei. Yama i wake da wefoisaro Godinu Imumu Irauma yabake wake wefeku wei. I odoro kakama nono danu nabuebake do mafekuro ma feafeisaro babaema danu amarabake enaenari ufekuro amara aruma emenu amaeini babaeini emuabake wayai wefeisaro ma feafiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Eno weike nono wei, ya Nanu ibi munaisabake i orou yaisina yabake imuka ka ufiakaisaya wei. Ainama awoenaroma enare ara ukeifekuro i buna dubuena kai odoro dawa wirofekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","I meramawere erabusa dawae i dai sosinu iifa ooruro ibifekuke i yaisina ma merama ufekuie ya kakuraisa orouma i ufeku ubunu ubiye iwoka sifoisake i dubuena kai odo idua fafine ukinua wefoisaya wei. Eno ufekuie Diudia orofaro ibinisa orou oraararo sabu amuke anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Uwara seboro yaure ibifeisa orou uwara ubarenaro emenu erabusa mufisane da anifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Eno weike wei, waiya ukeifeisa orou da owefisake wau mufisane da anifeisa. ");
INSERT INTO aby_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","I odoro boana bobo awekaboini ama iseifeisa amara aruma bobo awekabo emenu anifeisa daabae meramawereya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eno weike nono wei, guriguri uaweke i merama odo, obi daiwere mafeku odoro da fafeku weawe wei. ");
INSERT INTO aby_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","I odo keuwere fafeisaro merama daiwere ufeisaya wei. Adinami nauwaro Godima i orofa akaka ubu ui i furoma eno me, awoena eno ere dakaisi, nono dubuenaro da efeisia wei. ");
INSERT INTO aby_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eno weike nono wei, Godima i meramawere odo keuwere ma fu da ufironae eme yaisina feafisanea wei. Nono Dawa Danu we mune odirie oroubake imukada ibake odo keuwere ma funaku uia wei. ");
INSERT INTO aby_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Moi mima yabake we irufekuke eno wefeku, Keriso Dawae ewadoba iro aria iro eawe eno wefekuie danu wake da nauforo wei. ");
INSERT INTO aby_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","I we irukeka Kerisoini we irukeka we bou ukeka orouini keuwere fafeisake buna ukekaini buna erekaini daiwere ufeisaro emenu ufeisabai efeisa. Eno ufeisake Godinu we mune odirie eme moi we irufiakane eno ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yewa wake yaisina yabake weakuneba naukenewaa uforo eno wei. ");
INSERT INTO aby_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","I merama odo odo me sifekuke eweka dumu sifekuro manabe edoro da ufekuro muina ureroma isare aafeisaro urenu bunawere yaisina amani ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Eno weike nono wei, eno ufeisaro I Ba Eme Sini Mi ou ubarenaroma Danu bunaini edoro daiwere ido fafekuro eme yaisina efeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dawa Danu aneru we odaifekuro anifeisake i eweka amukaku enaroma eweka isaraku enaroma ure baruna doo baruna iroma aboro aboro Danu we mune odirie orou yaisina mufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesuma Danu iwoka ukeka oroubake eno wei, I boruba anaro eaweke imuawe wei. Boruba ana awoena kua ido fafiro ya iwoka i obi isareka eweka ido farinu wefeisa wei. ");
INSERT INTO aby_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","I ari eno yewa yaisina eno ufekuro efoisake iwoka ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","I Ba Eme Sini Mi Dawa fafine aisamero enare ibinua Nanu wake ba wemaro nauawe wei. Yewa ibinisa eme yaisina da feare me sifoisaro ibai yaisina bokai ufekuro efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ureini doo me sifekuro nono Nanu wake da me sifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","33","I fafeku odo eme iwoka me, urero ibinisa aneruini iwoka me, Godinu amara Yesu Dawaini iwoka me, Godi Dawa mane iwoka uke ibinua wei. I dai Minu fareka odo wai ureifekuro fafeku o dumudumunaku sifekuro fafeku odo ya iwoka mebake naukenewaa ufoke erenewaa uforo wei. ");
INSERT INTO aby_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yewae i ari eno, moi mi moi orofaro anifine ukaada danu waiya ukeka oroubairo emenu waiya demui demui marieke danu dai yawokeka mibake eno wei, irauaiai yawokeifao wei. ");
INSERT INTO aby_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","Enaenari yabake weakuneba i Dai Minu fafeku odo ya iwoka meya wei. Dawa dumudumu o dumu abanaro o wai awaro o wairo ido fafekuke nauka aine ibifoisaro enao ufiakuba ibake yaini eme yaisinabake irauaiai koro ukenewaa ufone weakunea wei. ");
INSERT INTO aby_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","I Godima i Isaraera orou Idifiroma waure anisa banau urunaini ure wawareka iraa yisidi ode me buredi uruna iseka odo raarayai fafekuro iseifeisaba ibake i dai ofereni ode sibore sianeka orouini nono i Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Yesu fema mufisake ma feafisane daaba yodia uisakema nono iroma meisake eno weisa, banau odoro da wanaro mufeisi weisa. Eme yaisina emenu mane dino ufeisake iyaini uranao ufeisaba medifeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuma Bedeni goiro ibaada i beko mame ibiro Yesuma ma wiroi mi danu ibiye Saimoni danu uwara ubarenaro amuike yaure ibaada uruna iseibibaie moi aweka i irauaiai adua omama ubu uisa kawaburo waure amuke farike i kawabu minoo ma doro yarike Yesunu iiriro ma oini. ");
INSERT INTO aby_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eno uiro i yaure ibisa moi orouma dino uisake dino wakeroma eno weisa, anemebake me sara ma oininu weisa. ");
INSERT INTO aby_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","6","Eno weisake nono weisa, I adua make mune dedi kina (K30) muneroma erabusa me oroubake make dakinuke eno anemebake ukinu weisa? Eno weisake i awekabake dino daiwere uisaro Yesuma eno wei, mediaweke i awekabake dino wake da we makaewe weike wei, dawae Nabake irauaiai ukinua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yesuma eno weike nono wei, eraerabusa me orou yabairo aine wai ure ibeibaisade yanu arara emua unu kofiakane wefode unu kofoe weike nono wei, Na dawa yabairo aine wai ure da ibimaua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dawa Nanu ofero irauaiai urumu adua ma oininu ibake Nanu ooru ukeka uke bou ukinua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yesuma eno weike wei, nanu wake wemaro nauawe wei, Godinu irauaiai wake doo baruna ure baruna iro yaisina we enaada i aweka danu ukinu ibai imukeifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","11","Diudiasi Ikariada dawae Yesunu moi duwero (12) iwoka ukeka mi dawama moi dai ofereni ode sibore sianeka oroubairo aya odifine fare anike weiro naukake rooro daiwere uisake oi daiwere mafisane weisa. Eno weisaro Diudiasi Ikariadama Yesu we sibofiro mufisane daaba yodia ukeibi. ");
INSERT INTO aby_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ure wawareka iraa yisidi ode da uisa uruna danu kawama odo ido fariro Godima Isaraera orou Idifiroma waure aneka mamoenakubai i banau ufisane ureibisa. Danu iwoka ukeka orouma eno weisa, Anu banau aboro uke bou ufeisike ifeisi weisa? ");
INSERT INTO aby_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eno weisaro Yesuma Danu iwoka ukeka miyai we odaisada eno wei, yeka goiro aniawake moi adua koraku mi eawake danu umuro aniawa wei. ");
INSERT INTO aby_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","15","Aniawake danu uwararo faawake i uwara yawokaku mibairo eno weawa wei, uwanu Dai mini Danu iwoka ukeka orouini emua aboro banau ifisane wenu weawaro i mima yabake dai uwara moi ena baruna ooru mafia wei. ");
INSERT INTO aby_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I uwararo uruna mune uke bou ukeibiawa wei. Yesuma eno weike we odairiero i goiro anisike Yesu Danu wei enaenari weisiro uwara ooru mairo uruna uke bou ukeibisi. ");
INSERT INTO aby_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Dumudumu siniro Yesu Dawaini Danu iwoka ukeka orou duweroini (12) emuama i uwara ubarenaro amuke fare yaukake i uruna isaada Yesuma eno wei, moi uruna isaku mima na we sibofekuro mune ane korosiro ufokaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","20","Yesuma eno weiro Danu iwoka ukeka orou emenu imuka merama imukada eno weisa, naba ainadei ari eno yaisina weada we nauke ereibisaro eno weisaro Yesuma wei, moi duwero (12) iwoka ukeka mi naberoro dawaini demuiro uruna munaisua wei. I munaku mima Na we sibofarakua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Godinu bukaroma eno weakua wei. I Ba Eme Sini Mi Dawae enaenari feafekua wei. Enoba i Ba Eme Sini mi we sibofaraku mi danu merama ukeka sinekae daiwere. Enoba danu amaema dawa da dofironae irauaiaiya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesuini Danu iwoka ukeka orouini uruna isa. Uruna isaada Yesuma buredi munike Godi irauaiai we imukada guriguri uike ma birabira yarike Danu iwoka ukeka oroubairo makada eno wei, yewae Nanu ofeya muaweke iawe wei. ");
INSERT INTO aby_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Nono i fanigini munike mame ibaada Godibairo we ma irauaiai ukaada guriguri uike mairo i orou yaisina iseibisaro Dawama eawe wei, yewae Nanu awoena arararo uke makaneka iwa eme keuwerebake isafekua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nanu wake wemaro nauawe wei, yewa naadidi kai iduda idua yaini demuiro imauke nono da ise ibeimauke dubuenaro Godinu yawokeibaku orofaro yewa naa didi kai iduda nono demuiro ifeisia wei. ");
INSERT INTO aby_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eno weiro yaura kairoma Godibake we ma irauaiai ukaada weisake Oriwa oraararo amuke anisa. ");
INSERT INTO aby_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oriwa oraararo amuke aneebe amuke faka. Amuke fakake Yesuma eno wei, ya yaisina Nabake maru ufoisake Na medifoisaba ibake Godinu bukaro eno weakua wei, I mamoe abu yawokeka mi Nama umauro i mamoe abu yaisina daaba imusu imusuro anifeisaya eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nono dubuenaro fearekaroma Na ma uyafarakuro Nako Gareri orofaro animauro ya yaisina aima iro fafoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eno weiro Fidama ma owerike eno wei, i orou yaisina A maru ufeisake A medimekaisaro nono na maru da umauke A da medimauanea wei. ");
INSERT INTO aby_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Fidama eno weiro Yesuma nono wei, a naua wei, eweira dumuro kawama kokoroko wefekuie ako Nanu ibi buuba we ma fe yaraada meo wefakua wei. Yesuma eno weiro Fidama bunawereroma nono wei, Aini Naini feafukuba Abake meo da wemaua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Fidama eno weiro Yesunu iwoka ukeka orou yaisina enaenari weibisa. ");
INSERT INTO aby_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gesemani orofaro fakabaie Yesuma Danu iwoka ukeka oroubairo wei, yauawero Na guriguri uma wei. ");
INSERT INTO aby_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Eno weike Fidaini Deimisini Dionini emua we waure anike Danu imukari daiwere ukaada eno wei, Nanu imuka inimubi ukakuba Na feareka imuka imukakunea wei. Yewado yaure ibaada koro ukeibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eno weike yafa me funaku eka anike dooro iboo yanakaisari uike guriguri ukaada eno wei, yewa merama ure yanakewere Nabairoma mufane ufakuie mua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eno weike nono wei, Nanu Babae, Anu arara yaisina ufane weakunea wei. Yewa merama Na ure yanakewere Nabairoma anifine wefakuie anifekua wei. Nono Nanu arara da uake Anu arara mane ua wei. ");
INSERT INTO aby_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eno weike owerike fare eribaie Danu iwoka ukeka orou nauka aine ibisaba Fidabairo eno wei, a nauka ainaku ari wei? Wai funaku yawokakuba me wei? ");
INSERT INTO aby_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yawokenewaa uaweke guriguri uawe wei. Merama uke ereka yabairo fanao ufekua wei. Yanu imukanu arara ufoisaie nono yanu ofeye buna meba ibake eno da ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","40","Yesuma eno weike nono anike Danu adina wei wake enaenari weada guriguri uike owerike fare eriebaie nono nauka aisaro emenu naisa nauka ariari uiba ibake moko wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Eno uisaro anike nono owere farike eno wei, nauka ainibada ko yaraisa wei? Iduaya uyaewe wei. I eweka funaku sininuba i Ba Eme Sini Mi meramawere orounu wanaro mame odifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uyaewero anife wei. Na we sibofari mi idua farinua eawe wei. ");
INSERT INTO aby_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuma eno weibibaie Diudiasi moi duero (12) iwoka ukeka mini nono moi eme keuwere bauini goreini waukake faka. I dai ofereni odeka orouini Du orounu bisara orouini emuama we odaisaba ibake faka. ");
INSERT INTO aby_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Diudiasima i Yesunu wanaro mufisane aaka oroubake eno wei, ereiforo animake abo mi yabamauke oo umauie ido fare sabu mufoke aniforo wei. ");
INSERT INTO aby_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","46","Eno weike i orofaro ane faraada Yesubairo eno wei, Dai Sisa Mi weike oo ukeibiro i Diudiasini aaka orouma Yesu fare yabaisa. ");
INSERT INTO aby_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yabakeibisaro Yesunu moi iwoka ukeka mima danu bau munike i dai ofereni ode sibore sianeka minu waiya ukeka mi danu ome umane kasini. ");
INSERT INTO aby_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Yesuma i oroubake eno wei, anemebake Na waira ukeka mi ari bauini omaini ure yanake ufone farisa wei? I dai sosiro odo keuwere we ma iwoka ukeibisara i furo mune da uyakakema nono awoena bauini usini anemebake mune farisa wei? Eno weike wei, Godinu bukaroma eno weakuba ibake enaenari ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesuma eno weiro Danu iwoka ukeka orou yaisina Yesu meisake ia iyare fiake anisa. ");
INSERT INTO aby_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nono Yesunu moi iwoka ukeka mima enare ibaada wau mane baruike ibiro i orouma dawa ufisane yabaisaro wau mane ma kukune mukaro ofe mane ia sinike durame ani. ");
INSERT INTO aby_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","I orou Yesu wanaro mamisake dai ofereni ode sibore sianeka minu uwararo waure ane fakaro i ofereni ode sibore sianeka orouini Du orounu bisara orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emuama ku siane ibisaro ane faka. ");
INSERT INTO aby_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ane fakaro Fidama yafawereroma eroke eroke emenu umuro ane dai ofereni ode sibore sianeka minu uwara udiro ane farike yaure ibi. Dawaini nono moi waiya ukeka orouini inaa rarakada inaa udiro yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yaure ibisaro I ofereni ode sibore sianeka orouini kanisoro orouini yaisina Yesu meo wayai weifisake Yesu ma feafisane daaba yodia uisake daaba fou ure dauisa. ");
INSERT INTO aby_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ibake moi orouma uyarada meo wake weibisa ibake emenu imukekae demuiro ode dauisa. ");
INSERT INTO aby_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Nono moi orouma uyakake meo wake weisake eno weisa, yewa mima eno weia weisa, emema uisa dai sosi uwara ma doroo yamauke odo buuba me sifekuro nono awoena uwara wanama da umauke me ma enamaua eno weia weisa. ");
INSERT INTO aby_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","60","Moibaima eno weisaro nono moibaima imusu wake weisaro i dai ofereni ode sibore sianeka mi danu yaure ibi orofaroma uyarada Yesubake eno wei, i orounu weaisa wake naukinu wei? I dai ofereni ode sibore sianeka mima Yesubake nono wei, anemebake moko wake we dauke ibinu weike wei, ama aneme aneme wefaku wei? ");
INSERT INTO aby_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eno weibaie Yesu wake we da uiro dai ofereni ode sibore sianeka mima nono wei, Ae Godinu Amara Kerisoba me wei? ");
INSERT INTO aby_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eno weibaie Yesuma euwa wei. Eno weike wei, I Ba Eme Sini Mi i buna daiwere Godinu baena wana enaro yaufekuke nono iroma ou mameifeku iro fafekuro efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dawama eno weiba ibake i dai ofereni ode sibore sianeka mi danu wau ma girisada eno wei, moi wayai weeka orounu wake da naufeisi wei. ");
INSERT INTO aby_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Danu meo wake naukaisiba nono moi wayai wake da wefeisaya wei? Eno weiro i wake daaba demuiro weisa, Danu Godibairo wake merama wenuba Dawa ma feafeisia weisa. ");
INSERT INTO aby_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eno weisaro moi orouma Dawa wisiomu ukeibisake Danu naisa wauma dadau uke oisake wanama uraada eno weibisa, ainama A urakuyainu? Wearo naufe weibisa. Weada eno ukeibisaro meremere orouma Yesu mukake wanama ureibisa. ");
INSERT INTO aby_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Fidama i dai ofereni ode sibore sianeka minu uwara udiro yaure ibi. Idua yaure ibiro dai ofereni ode sibore sianeka minu moi waiya ukeibi arumama fare aneebe Fida inaa udiro yaure ibiro dawa eraada dawama eno wei, a dawa i Nasaredi goi mi Yesubairo ibia wei. ");
INSERT INTO aby_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","I arumama eno weibaie Fidama ma owerike eno wei, na meya weike wei, anu weaku wake na iwoka meya wei. Eno weike uyarike i sebo enaro anike nauibaie wai uraada kawama kokoroko weibi. ");
INSERT INTO aby_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","70","Kokoroko weibiro i arumama nono erike i ku siane ibisa oroubake eno wei, yewa miye Yesunu waiya demui miya weibaie Fidama na meya wei. Nono dubuenaro i ku uke ibisa orouma Fidabake nono weisa, ae i orou duwero (12) emenu naiyeya weisa. Ae Gareri mideie iwoka sinaisia weisa. Anu wake i Gareri orounu wake ari weakuro naukaisia weisa. ");
INSERT INTO aby_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Eno weisaro Fidama merama wake weada wei, Yeka mi na iwoka meya wei. Eno weike wei, Na meo me ba weakunea weike wei, na meo wemauie Godima na fanisi mafaraku wei. ");
INSERT INTO aby_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dawa eno weibiro kawama kokoroko nono yama weiro Fidama Yesunu wei wake imui. Yesuma Fidabake adinaisa eno wei, kawama kokoroko wefekuie ako Nanu ibi buuba we ma fe yafakuro kokoroko nono wefekua wei. I wei wake Fidama imukada aweawero anike imuka inimu ukaada ii daiwere wei. ");
INSERT INTO aby_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wai uriro dai ofereni ode sibore sianeka orouini dai orouini nono i Mosesinu darawadu we ma iwoka ukeibisa orouini kanisoro orouini emua yaisina wake we makakake Yesunu wana mune ane derena enaro naama uwakake Dawa Romani gaemani dai yawokeka mi Faeradibairo waure ane maisa. ");
INSERT INTO aby_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ane maisaro Faeradima Yesubake eno wei, A Du orounu dai yawokeka kini mi weibaie Yesuma euwa wei. ");
INSERT INTO aby_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Eno weiro dai ofereni ode sibore sianeka orouma wayai wake keuwere weibisaro Faeradima Yesubake eno wei, emenu wayai wake daiwerero anemebake wake we dakaku wei? ");
INSERT INTO aby_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Faeradima eno weiro Yesuma moko wake we dauiba ibake Faeradi imuka foria ui. ");
INSERT INTO aby_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Godima i Isaraera orou Idifiroma waure aneka banau uruna i ewekaro i orouma ana ebaro ibeibi mi una demuibake weibisaro i dai yawokeka mima dawa ma woromeibaku. ");
INSERT INTO aby_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","I odoro Barabasini moi eme ma feareka urane rarane ukeka orouini emua ana ebaro ibisa. ");
INSERT INTO aby_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","I ku uke ibisa orouma Faeradibairo fakake eno weisa, anu bisara ari eno ua weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eno weisaro Faeradima emuabake ma owerike eno wei, ya Du orounu Kiniya weaisa mi dawa naa ma woromimau eno wei? ");
INSERT INTO aby_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Eno weike nono dawa iwoka i orouma Yesubake ararua uyarada Dawa ukake waure aakabai iwoka sini. ");
INSERT INTO aby_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iwoka sinike weiro i dai ofereni ode sibore sianeka orouma i ku uke ibisa oroubairo enaada eno weisa, Barabasi naa ma woromia weawe weisaro i ku uke ibisa orouma naukada dino daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eno mane we enereibisaro Faeradi nono wei, Du orounu Kiniya weaisa mi aneme umau wei? Eno weibaie korosiro ikokoma ure odia weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eno weisaro Faeradima nono wei, Danu meramade aneme merama ukinu wei? ");
INSERT INTO aby_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eno weibaie korosiro ikokoma ure odia daiwere weibisaba ibake emenu ararae Yesu feafine ukaada weibisa ibake Barabasi ma woromike weiro Yesu usima uka. ");
INSERT INTO aby_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ukaro Faeradima Yesu korosiro ure odifisane emenu wanaro mame odirie. ");
INSERT INTO aby_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Meremere orouma Yesu waukake aweaweroma i Romani gaemani dai yawokeka minu uwara udiro waure anisake emenu naiyemuku u weisaro faka. ");
INSERT INTO aby_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Fakaro i dai yawokeka orounu kokoiwerero yafa wauma Yesu baruke oisake mebuma sini ari eno naadidima mukake Kini orounu mogoiso ari ubu uisake Yesunu iiriro ure afua umane oisake Yesubake eno weisa, A Du orounu dai yawokeka kini bauwakanakua eno weibisa. ");
INSERT INTO aby_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eno weada usima iiriro uraada wisiomu ukaada Yesunu ibooro ifoma kodudu yanakada Yesu we irukeibisa. ");
INSERT INTO aby_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eno ukeebe oisake i kokoi wau ma kukune mukake Danu ba barukeka i dei wau ma baruke oisa. Eno uisake korosiro ure odifisane waure anisa. ");
INSERT INTO aby_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","22","Aneibisaro Sairina orofa mi Saimoni dawae Arekisanaini Rufasini emenu babae. Dawae waiyaroma aare fariro eno weisa, Yesunu korosi waua weisake Gorogoda orofaro anisa. ");
INSERT INTO aby_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","24","I Gorogoda weaisa wakenu ubiye bokai kaibai mane orofa. Iro aare fakake moi mima iraa bobo waini adua Yesu ifine mai. Mairo mediro korosiro ikokoma ure oisake Danu wau ainama mufeku ari weisake kasi dodoo uisake wau sia imusu imusu muka. ");
INSERT INTO aby_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eweka amuke aare okoro enariro Yesu korosiro ikokoma ure dabame oisa. ");
INSERT INTO aby_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","27","Korosiro ikokoma ure dabame oisake owaowa uisake Yesunu korosiro ma dabame oisa i owaowanu ubiye i Du orounu dai yawokeka Kini mi. I owaowa korosiro ikokoma ure dabame oisake moi waira ukeka miyai una raarayai moi mi moi enaro korosiro ikokoma ure dabame oisake nono moi mi moi enaro korosiro ikokoma ure dabame oisa. ");
INSERT INTO aby_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Godinu bukaroma wake eno weakuba ibake enaenari uisa. Yesu Dawaini i merama ukaisa orouini emuae demuiya wefeisaya eno weakuba ibake enaenari uke oisa.) ");
INSERT INTO aby_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","I fare aneibisa orouma we irukeka wake weisake bokai gidogado ukaada yo weisake weisa, Ama dai sosi ma doroo yafake odo buuba me sifiro nono ma enafane weideie weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eno weisake nono weisa, Anu mane Anu bunama ma wiroa weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eno weisaro i ofereni ode sibore sianeka orouini nono i Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Yesu we irukada eno weisa, imusu orou ma wirokeibakukema nono eweira Danu onami anemebake ma wiroke dauke ibinu weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eno weisake nono weisa, i Isaraera orounu kini korosiroma isafiro efeke imufe weisa. Eno weisaro i korosiro ibaada i waira ukeka miyai emuaini me sara merama wake weada we irukeibisi. ");
INSERT INTO aby_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Eweka okoro enariro i goi goi yaisina eweka edoro uke dauike dumu sine ibiro eweka arisi yare ane abanaro fariie eweka nono edoro ui. ");
INSERT INTO aby_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eweka okoroma ane isafine abanaro siniro Yesuma daiwere wei, Irai, Irai, Rama Sabadani, i wei wakenu ubiye Nanu Godi, Nanu Godi, anemebake Na medinara weadama wei. ");
INSERT INTO aby_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eno weiro moi enare ibisa orouma naukake eno weisa, nauawe Dawae Iraida u weakua weisa. ");
INSERT INTO aby_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eno weisaro moi mima anike nifu ari erabunaku munike usiro uwanike kimurima imusu ari ana kai idudabai kouro sianike iro ma niuike Yesunu wake ebaro odike eno wei, Iraida ido fafike mufiro efe wei. ");
INSERT INTO aby_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","38","Eno weiro Yesuma daiwere weike ido feari. Yesu feariro dai sosi uwara ubarenaro ooru raarayai enare kuure oisa dai burudu wau ido ekua barunaroma gagane isare aare ubiro fari. ");
INSERT INTO aby_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","I dai meremere mima Yesunu feareka odo fu siniro erike eno wei, yewa mi Dawae Godinu Amara ubiya wei. ");
INSERT INTO aby_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Awekabo keuwere emua ekararo bi mame ibaada iroma Yesu ereibisa. Meri Megidarinaini nono moi Meri dawae Diosefuini Deimisi dawa dubuena mi emenu amaeini Saroumuini emuama Yesu ereibisa. ");
INSERT INTO aby_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu Gareriro ibi i furo i awekabo emuama Danu umuro eneiareibisa. Iro enaada Yesu yawokeibisaro i awekaboini nono moi awekaboini Dawaini Derusaremu goiro owere aare faka. ");
INSERT INTO aby_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","I sabadi uke bou ukeka odo fariro dumudumu sinibake Arimadia goi mi Diosefu dawa kanisoro mi dawa Godinu yawokaku odo yawokeibi. Dawama Faeradibairo anike Yesunu ofe mufine eenu wei. ");
INSERT INTO aby_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Weiro Faeradima Yesu fearinuba me ari we imuike danu meremere mibake u weike we nauke eri. ");
INSERT INTO aby_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","We nauke eribaie fearinua wei. Eno weiro Faeradima Yesunu ofe bou mufine Diosefu we odairo ani. ");
INSERT INTO aby_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Anike awoena inanawere wau oima make munike owere anike Yesunu ofe korosiroma munike wauma oba uike waure ani. ");
INSERT INTO aby_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ane eme odeibisa oma eraboro odiro dai oma ferawere ma ubere ubere uke anike oma eba dadau uke odi. ");
INSERT INTO aby_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eno ukeibiro Meri Megidarinaini Diosefunu amae Merini emuama ereebe Yesu ooru uke oisa orofa eki. ");
INSERT INTO aby_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","I sabadi odo me siniro Meri Megidarinaini Deimisinu amae Merini Saroumuini i awekaboma Yesunu ofero kare odeka irauaiai fauda oima make mune anisake aisa. Aisake wai awanakuro uyakake anaada bora eweka sianiro eme me sineibisaro odeibisa orofa eka. ");
INSERT INTO aby_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aneebe eno weisa, i dai oma aisamero ainama mune siafeku weisa? ");
INSERT INTO aby_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","5","Eweka fariro eme odeibisa oma erabo fare ekabaie i aisame dadau uke oisa oma ma ubere ubere uke ane odi ibake i ebaro isaka. Isakake ekabaie inanakeo wau yuni adara mi baena wana enaro yaure ibibake foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eno uke foria uisaro i yaure ibi mima eno wei, ia da siawe weike nono wei, i Nasaredi Mi Yesu Dawa korosiro feari Mi efone farisa weike eno wei, Dawa ewado ibe meya weike nono wei, Dawa uyarinua wei. Dawa oisa orofa yewadoya eawe wei. ");
INSERT INTO aby_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aniaweke Danu iwoka ukeka orouini Fidaini emuabake eno weawe wei, Yesu Dawako Gareriro anifekuro ane efoisaya wei. Yesuma wei enaenari anifekuro efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I mima eno weiro eku duboro amuisake ia sikake iura mamaada moi oroubairo we da uisake durame anisa. ");
INSERT INTO aby_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fura bokai odo wai awanakuro Yesu fearekaroma uyarike Meri Megidarinabairo Danu iboo ma iwoka ui. I aweka dawa adinaro Yesuma seidaninu merama imumu yaisina seweni (7) dawabairo we berai, i awekabairo dawako danu ibooro fariro erike ani. ");
INSERT INTO aby_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Yesu Danu iwoka ukeka orou sorara ukeibisaro ane farike eno wei, Yesu fearike nono uyarinuke ibinua wei. Eno weiro, Yesu Danu iwoka ukeka orouma i awekabake ma owekake eno weisa, dawa meo weakua weisake danu wake nauke dauisa. ");
INSERT INTO aby_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","13","Nono dubuenaro Yesu Danu umuro eneiareibisi miyai daabaro aneibisiro Yesu ofe imusu sinike emuabairo fariro ekike ane Danu umuro eneiareibisa oroubake Yesu erisua weisiro emenu wake nauke dauisa. ");
INSERT INTO aby_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nono dubuenaro Yesu Danu iwoka ukeka orou yaisina ireweni (11) uruna isaada yaure ibisaro Yesu emuabairo ane fari. Ane farike Danu imusu we forairo emenu imuke dakekaini imuka ara ukekaini i Yesu eka orounu wake nauke dauisaba ibake Yesuma dino wake wei. ");
INSERT INTO aby_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dino wake weike nono wei, doo baruna ure barunaro yaisina aneibiaweke i orou yaisinabake Godinu irau wake weibiawe wei. ");
INSERT INTO aby_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Godinu irau wake weibiawero ainama Godinu wake naufekuke babadaido ufekuie ma wirofeku wei. Eno weike nono wei, ainama Godinu irau wake da naufekuie merama orofaro anifekua wei. ");
INSERT INTO aby_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Eno weike wei, irau imukaisa orou eno ufeisaya wei. Eno weike nono wei, i irau imukaisa orou Nanu ibiro seidaninu merama imumu we berafeisake wake imusu wefeisake waa waru mufeisake buya ifeisaroma da feafeisake arama ukeka orou Nanu ibiro weada emenu iiri duboro wanama odifeisaro wirofeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Godima Yesu urero waure amuke aniro Danu ba ena wana enaro yauri. ");
INSERT INTO aby_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I Yesu Danu iwoka ukeka orouma Godinu wake aboro aboro we enereifisane anisa. Anisaro Godima emua unu koreibirieba ibake buna wake weibisake buna ukeka daiwere ukeibisaro i ereibisa orouma we imukeibisa, Godima emua unu korakunea eno we imukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Naiye, Diafarasi, nanu wakenaku ewadoya ea. Yesu Kerisoma buna ukeka keuwere iyabairo ukeibi. Moi orouma Danu buna ukeibi ibai ereibisake Danu wake iyabairo weibisake nono owaowaro yanakada iyabairo makeibisa. ");
INSERT INTO aby_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Emuama eno ukeibisaba ibake nanu imukekae i ari eno imukakune, Yesunu buna ukeka yaisina naukenewaa ukeibisaraba ibake i wake yaisina gienabu owaowaro odimake abairo odaimane eno imukada ibake owaowa yanake odakune. ");
INSERT INTO aby_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","I buna ukeibiro naui ena wake ba adaadake iwoka ufane ibake abairo yewa owaowa yanake odaisakune. ");
INSERT INTO aby_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Adinaro Erodi, dawae gaemani orounu dai yawokeka mi. Enoba dawae Diudia orofa yawokeibi. Dawama yawokeibi i furoe moi dawako ofereni ode sibore sianeka mi danu ibiye Sakarayasi dawa ibi. Danu akaemuku demui orou emuae Abaida weaisa orou. Dawaini danu orouini i dai sosi uwara ubarenaro Godinu waiya demuiro ukeibisa. Enoba Sakarayasi danu awekanu ibiye Erisabedi. Erisabedie Eroninu sisia aweka. Eroninu orouini Godibairo ofereni ode sibore sianeibisa. ");
INSERT INTO aby_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","I aiyaka emua Godinu daabaro gienabu enaada Danu darawaduini Danu wakeini imukenewaa ukeibisi. Eno ukeibisiro Godima emenu irauaiai ukeka sineka ereibi. ");
INSERT INTO aby_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Erisabedi dawae amara ara sini ibake amara dore dauke me ibeebe i aiyaka me ewai ure bauwaka ure eno uisi. ");
INSERT INTO aby_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Enoba i Abaida orounu waiya ukeka odo idua fari. I ofereni ode sibore sianeka orounu bisarae ukeibisa emenu waiya ukeka odo idua fariba ibake emenu ibi ibi fefaro yanakeibisake mauwa ubarenaro odeibisa. Eno uke odeibisake guriguri ukeibisake demui ibi mane muneibisa. ");
INSERT INTO aby_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","10","I odoe eno uisake Sakarayasinu ibi muka. Sakarayasinu ibi mukaba ibake Sakarayasima dai sosi uwara ubarenaro Godibairo ofereni odifine amuike ibibaie i fare ku siane ibisa orou yaisina aweawero ibaada guriguri uisa. ");
INSERT INTO aby_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eno uisaro Sakarayasi enare ibaada eribaie Godinu aneru irauaiai urumuma imusu ari inaa iro ofereni odeibisa baena wana enaro adinaroma enare ibiro eri. ");
INSERT INTO aby_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Erike imuka merama ukaada ia daiwere iyari. ");
INSERT INTO aby_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ia iyariro i aneruma eno wei, Sakarayasi, ia da sia eno wei. Godima anu guriguri ukaku ibai naukinuba anu aweka Erisabedima amara dofekuro danu ibiye Dioni mamifakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amara dofekuro yanu imuka irauaiai ukaada rooro ufuaisiro eme keuwere emuaini iini rooro ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eno weike nono wei, i amaranaku dai sifekuke Godinu dai mi sifekuro Godima efekua wei. Anu amarama waini aduaini ara aduaini da ifekua eno wei. Danu amaema dawa dofeku odoroma Godinu Imumu Irauma danu imuka ubarenaro isafekuke ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I mima Godinu wake wenewaa ufekuke eme keuwere emenu ba me ukekabairoma ma owefiakuro emenu Dai Godinu daabaro anifeisaya i aneruma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iraidanu ukeka sinekaini bunaini mufekuke dawako anifekuro nono i Mesaiama danu umuro aafekua wei. I babaebairo anifekuke i babaemukunu imuka ma owefekuro emenu amaraku nono imukari ukaada irauaiai mane imukeifeisaya wei. I Godinu wake nauke medaisa orounu imuka ma owefiakuro nono imukeka irauaiai imukeifeisaya wei. Enoba dawae i orou eno uke bou ufiakuie Dai Waria Mi idua fafekua i aneruma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","I aneruma eno weiro Sakarayasima anerubake ma owerike eno wei, nanu awekaini naini uwae bauwaka ure ewai ure eno ukisude aneaneme anu wake iwoka simau wei? ");
INSERT INTO aby_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eno weiro i aneruma dawabake nono wei, nanu ibiye Geibiro. Nae Godibairo ibakunea wei. Godima yewa irau wake nama abairo wemane we odainararo ibake abairo fanea wei. ");
INSERT INTO aby_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Eno weike nono wei, nanu wake nauke meba ewadoma ane i amaranaku dofeku odoroma yeka mie wake muu ufakuke koko mi ari wake da we ibifakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eno ukaada we makaneibisibaie i fare ku siane ibisa orouma Sakarayasi koro ukeebe eno we imuisa, i miye aneme ukaada dai sosi uwara ubarenaro yafawere ibinu ari eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakarayasima i dai sosi uwara ubarenaroma isarike emuabairo wake wefine we imuikema nono koko mi ari ukaada wake we daui. Ibake i aweawero enare ibisa orouma eno we imuisa, dawae kubekube erinua eno we imuisa. Eno we imuisaro Sakarayasima wake muu ukaada ibake wake moi emuabairo we dauike wanama uke kowokowo mane ui. ");
INSERT INTO aby_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eno uike moi odo odo ibeebe danu waiya ukeka odo me siniro danu uwararo idua ani. ");
INSERT INTO aby_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dubuenaro Erisabedima boana munike manabe kai fai (5) uwara ubarenaro fe ibeibi. ");
INSERT INTO aby_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dawama eno wei, nae amara dore me ibake nanu adinaro ibekae meramawereroma nono awoenae Godima na eraada unu korakunaraba eme moima na da we irufokaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabedi manabe sikisi (6) boana bobo ibiro Godima Danu aneru, Geibiro we odairo aneruma isare aarike Gareri orofa Nasaredi goiro ani. ");
INSERT INTO aby_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","28","I goiro moi adarabaini dodoo uke dakeibi aruma ibi. Ibibaie moi mima i aruma ure burise ere mero i arumama moi mi mufine we bou uke oisaro me ibi. I aruma mufine we oisaro ibi mi danu ibiye Diosefu. Dawae i adinaro dai yawokeka mi Deiwidinu sisia mi. I arumanu ibiye Meri. Aneruma i arumabairo farike eno wei, aruma, yaure ibinu, ae Godinu we mune odi aruma. Godi Dawa abairo ibinua wei. ");
INSERT INTO aby_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eno weiba ibake Merima imuka merama daiwere ukaada eno we imui, anemebake i ari eno wake weaku we imui? ");
INSERT INTO aby_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","I aneruma Meribake nono wei, ia da sia wei. Godima i irauaiai eraakuyainuba boana mufakuke aya amara dofakuie Danu ibiye Yesu mamifakua wei. ");
INSERT INTO aby_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","33","Dawae dai miwere sifekuro eme yaisinama Dawae i Dai Godinu Amaraya eno weifeisa. I Dai Godima Danu oinami Deiwidinu yawokeibi orofa mafekuro i Isaraera orou Dawama yawofiakuro Danu yawokeifiaku waiya da me sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eno weiro Merima anerubake ma owerike eno wei, nae eme mede aneaneme eno umau wei? ");
INSERT INTO aby_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eno weiro nono i aneruma Meribake nono wei, Godinu Imumu Irauma abairo isafekuro i urero Dai Godinu buna daiwere mafekuro isare aare oba unao ufekuba amara dofakuie Dawa Godinu iifa miya eno wefeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","I aneruma eno weike nono wei, anu yayae Erisabedi ewainakuma adinaro boana muninuke i amara ara sinia weaisa aweka boana bobo ibinuro manabe sikisi (6) me sininua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ie ara me. Godima aneme wefekuie enaenari ufakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","I aneruma eno wei ibake Merima dawabairo eno wei, nae Godinu waiya ukakune aruma na yewadoya einake anu wenu wake enaenari ua wei. Merima eno weiro i aneruma Meri idua medike ani. ");
INSERT INTO aby_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Merima moi odo yaure ibeebe uyarike moi Diudia orofa oraara goiro sabu amuke ani. ");
INSERT INTO aby_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","43","Merima Sakarayasinu uwararo ane farike Erisabedi arie weibibaie Erisabedinu amara boanaro amani amani ui. Eno uiro Godinu Imumu Irauma Erisabedinu imuka ubarenaro isariba ibake Erisabedima daiwere weike eno wei, Godima a i awekabo yaisinabairoma we ma irauaiai ukakuyainuke nono anu dofaku amaranakuini we ma irauaiai ukakua eno weike nono wei, nanu Dai Waria Minu amaema anemebake nabairo farinu wei? ");
INSERT INTO aby_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ama arie wake wenuro naunero nanu amara boana ubarenaro rooro ukaada ibake amani amani ukinua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ae Godinu wake naukakuba ibake Godima a we ma irauaiai ukakuyainua wei. Dawa abake we bou ui enaenari ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Erisabedi eno weiro Merima yaura kairoma eno wei, nanu imuka ubarenaroma Godi we ma daiwere ukakuneke Godi nanu wirokeka miya weada rooro ukaada weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Godima Danu merama uke ibaada waiya ukaku aruma eraada imukakunara ibake eno ukakune. Ibake i dubuenaro fafeisa orou yaisina emuama nabake irauaiaiya wefeisaya eno weakune. ");
INSERT INTO aby_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","I buna Godima nabake irauaiai ukeka keuwere ukakuro nono Danu ibiye iifawere wenea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","51","Nono i awoena ibinisa orouini nono dubuenaro fafeisa orouini aina ainama Dawa we iifa ukaada imukenewaa ufeisaie emua yaisinabake imukari daiwere ufiaku weakunea wei. Godi Danu buna wanama buna ukeka keuwere ukaku. I merama imukeka fukeru bobo orou ma berakakunero imusu imusu anaisa. ");
INSERT INTO aby_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nono i bunawere yawokaisa orou we mune ma okoa ukakuniake nono i daiwere me orou ma daiwere ukakunia. ");
INSERT INTO aby_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Enoba i eraerabusa me oroubake irau eraerabusa makakuniaro irauaiai ibaisa. Nono i eraerabusa keuwere bobo orou emua moi eraerabusa make dakakuniake aniawe weakunea weaku. ");
INSERT INTO aby_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Danu adinaro unu kofiane we bou ui ibake imukakuniake Danu waiya ukeka Isaraera orou yaisina Dawama unu korakune. ");
INSERT INTO aby_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Godima Eibaramuini danu sisia sirorari orouini emua yaisina imukari ukeka we bou uiba ibake imukada enaenari ukakua weakune, Merima i wake eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri dawae Erisabedibairo manabe kai buuba iro dawaini ibeebe medike owere danu uwararo ani. ");
INSERT INTO aby_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabedinu amara doreka odo fariro danu amara dori. ");
INSERT INTO aby_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Danu amara doriro danu kakamuku naburakaini nono danu emenu kakamuku naburakaini i goi orouini emua yaisina nauisake we imuisa, Godima Erisabedibake imukari daiwere ukakuyainuba amara dorinua, we imuisake dawaini rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Odo eida (8) me siniro i Du orounu bisaraba amaranakunu ofe kuureka odo idua fariba ibake i orou yaisina fakake danu ofe kuufisane ku siane ibaada eno weisa, i amaranaku danu babaenu ibi Sakarayasi mamia weisaro Erisabedima nauike eno wei, meya, danu ibiye Dioni mamimaua wei. ");
INSERT INTO aby_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","63","Eno weiro nauisake nono weisa, yewa mi, iyanu akaemuku demui oroubairo i ibi meya, media weisake danu babaebake wanama wanama uisaro nono Sakarayasima moko wanama wanama uiro fefa maisaro Sakarayasima owaowa yanake odi, danu ibiye Dioni, mamimaua eno owaowa yanake odiro i orou yaisina i owaowa ekake imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakarayasima eno owaowa yanake odiro danu wake we dakeibibai idua me siniro wake idua weike Godi we ma irauaiai ukeibi. ");
INSERT INTO aby_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eno ukeibi ibake danu goi orou yaisina ia iyareibisa. I wake Diudia oraara orouini aboro aboro we eneibisaro naukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","I wake nauka orouma imukama merama imukada eno we imuisa, Godinu buna i amaranakubairo ibinuba dawa dai sifekuke aneaneme ufeku ariya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Godinu Imumu Irauma Dioninu babae Sakarayasinu imuka ubarenaro isariba ibake Sakarayasima wake we bou ukaada eno wei, iya Isaraera orounu Dai Godima Danu oroubairo isare aarike iya ma wirokakuniba ibake Dawa we ma irauaiai ukaisia wei. ");
INSERT INTO aby_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Godima Danu we bou ukeka orounu bebekuroma adinaro wei wake enaenari ui ibake Godima moi mi Deiwidinu sisia oroubairoma ma uyari. I miye bunake ma wirokeka mi. ");
INSERT INTO aby_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","72","Iyabake wasai ukaisa orouini imuka ka ukaisa orouini emenu wanaro mareke mufekuke odifiakuro me irauaiai anifeisi. Danu adinaro iyanu babaemukubairo we iifa ukeibi i wake imukada ibake enanari ukaku. ");
INSERT INTO aby_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Godima iyanu babae Eibaramu imukada Danu we bou ui wake enaenari ukakuba iyaini wasai ukaisa orounu wanaroma mareke mumisike iya we ma irauaiai ukaada we fira umisi. Enoba ia da sifeisike Godinu ibooro irauaiai ukeka sineka mane ukaada gienabu ukeifeisia wei. ");
INSERT INTO aby_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","I Sakarayasima eno weike nono wei, a nanu amaranaku, iyanu Dai Godinu we bou ukeka amaraya eno wefeisa. Ako anifakuke iyanu Dai Waria Minu daaba wabuke bou ufakua wei. ");
INSERT INTO aby_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Danu ma wirokeka wake ama emuabairo wefakuro naufeisaro emenu merama merama ukeka mufekuke imuke medifekuba ibake Dawa imufeisa. Ama Godinu emebairo imukari ukekaini irauaiai ukekaini we ma iwoka ufakuro naufeisaya Sakarayasima eno wei. ");
INSERT INTO aby_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Eno weike wei, Godima iyabake imukari daiwere ukakuba i dai edoro ari ureroma isare aafekuke i dumuini fearekanu riuro ibinisi orou edoro ufekuke Danu gienabu daaba iyabake ma iwoka umisiro me irauaiai ibifeisi weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","I amaranaku Dioni dawa ibeebe dai sinaada danu imuka yaisina Godibairo odaada imuka irauaiai ui. Dawae dai mi sinikema nono i eme ibe me orofaro ibeebe iroma i Isaraera oroubairo Danu onami we ma boroo yafiane iro fari. ");
INSERT INTO aby_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","I furo Kisa Ogasidasi dawae Romani dai gaemani mi. Enoba dawama moi darawadu owaowa yanake odike mariero i orofa aboro aboro waure anisaro i owaowanu wake nauisa. I darawadue senisisi muneka darawadu wake. I orofa akaka orou yaisinanu ibi ibi yaisina mufine ibake i darawadu owaowa yanake odairo waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuiriniasima Siria orofa yawokeibibaie i furo i senisisi darawadu owaowa idua waure faka. ");
INSERT INTO aby_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","I orou yaisina emenu amae babaenu goiro emenu ibi ibi bukaro odifisane anisa. ");
INSERT INTO aby_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Diosefu dawae Deiwidinu sisia miba ibake Gareri orofa Nasaredi goiroma Diudia orofa Bediriemu goiro ani. Ie Deiwidinu goi ibake iro ani. ");
INSERT INTO aby_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Diosefu danu mufekua we oisa boana bobo aruma Meri munike emenu ibi bukaro yanake odifisine amuke anisi. ");
INSERT INTO aby_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","I Bediriemu goiro amuke anisike ibeebe Merima danu kawama amara idua dorike wauma oba uike boromakaunu uruna iseka orofaro odiro aine ibi. I ba uwara uwara ubarenaro yaure ibeka orofa ibe meba i boromakaunu uruna iseka orofaro odiro aine ibi. ");
INSERT INTO aby_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","I orofaro moi mamoe abu yawokeka orou emenu mamoe abu koero dumuro yawokeibisa. ");
INSERT INTO aby_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Emenu mamoe abu yawokeibisabaie Godinu aneruma emuabairo fariro Godinu arakekama edoro daiwere ari i mamoe abu yowokeibisa oroubairoini edorowere uiba ibake i oroue ia daiwere sika. ");
INSERT INTO aby_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Enoba i aneruma emuabake eno wei, ia da siaweke nanu wake nauawe wei, irauaiai wake wemaro eme yaisina naufisake rooro ufisane fanea wei. ");
INSERT INTO aby_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Eno weike nono wei, i ma wiroke mune aneka mi, Dawae, Mesaia, Godinu Keriso, Danu amaema awoena dorinua wei. ");
INSERT INTO aby_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Danu aine ibinu ubue eno, wauma oba uke oisaro boromakaunu uruna isaisa orofaro aine ibinua iro yodia uke aniaweke fou uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Eno weibibaie idua buna aneru keuwere i aneru unabairo fakake Godi we ma irauaiai uisake eno weisa, urero Godinu ibi we ma daiwere ufeisia weisa. Nono yewa dooro aina ainama Godinu wake naufeisaie Danu irau ukeka emuabairo mafiakuro me irauaiai ibifeisaya weisa. ");
INSERT INTO aby_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","I aneruma eno weisake i orou idua mediriekake urero amuke anisa. Amuke anisaro i mamoe abu yawokeibisa orouma eno weisa, Godinu aneruma iyabairo weisa wake enaenari anifeke Bediriemu goiro i amaranaku ane efe weisa. ");
INSERT INTO aby_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eno weisake sabu sabu ane fakake ekabaie Merini Diosefuini emua idua yaure ibisiro i amaranakue boromakaunu uruna iseka orofaro aine ibiro eka. ");
INSERT INTO aby_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","Ekake anisake i aneruma i amaranakubake wei wake eme yaisinabairo weisaro i wake nauisa orouma foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","I mamoe abu yawokeka orouma owekake emenu orofaro anisake iro yaure ibaada i anerunu wakeini emenu naisama eka ibaini imukada Godi we ma irauaiai ukeibisa. Merima emebairo wake moi we dauike i ukeibi ibai mane imukama imukenewaa ukeibi. ");
INSERT INTO aby_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Odo eida (8) me siniro Danu ofe kuukake Danu ibi Yesu mamisa. I ibiye aneruma adinaro Meri boana mune me i furo we bou ui enaenari mamisa. ");
INSERT INTO aby_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Merima i amaranaku doriba danu iifa wanadu ukekaini oferini ode sibore sianeka odo idua fari. Ie Mosesinu darawadu ibake Yesu mukake Derusaremu goiro dai sosi uwara ubarenaro Yesu Godibairo ma iwoka ufisaro efine waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Godinu bukaroma eno weaku, awekama danu kawama amara dofekuie i amara Godinu iifa amaraya eno weaku. ");
INSERT INTO aby_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eno weakuba Merini Diosefuini emua emenu iifa wanadu ukekaini ofereni ode sibore siafisine anisi. I oferenie uneinakuyai o awoena ubari unayai. Ie emenu darawaduba ibake i Isaraera orouma eno ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","I furo moi mi, danu ibiye Simioni, dawae Derusaremu goiro ibeibi. I mima iro ibaada Godi imukada Danu waiya gienabu ukeibi. Dawae iya Isaraera orou iyanu ma wirokeka efine ibeibi. Enoba Godinu Imumu Irauma dawabairo adinaro eno wei, ae sabu da feafakuke Godinu we bou ui Keriso efakukema aima feafakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godinu Imumu Irauma Simionibairo weiro ibake Simionima dai sosi uwara ubarenaro ani. Iro anike enare ibibaie Merini Diosefuma emenu darawaduma weaku ibake enaenari ufisake Yesu Godibairo ma iwoka ufisane ibake emuama Dawa waure faki. ");
INSERT INTO aby_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","32","Waure fakike Simioni eki. Ekiro Simionima i amaranaku munike Godibairo we ma irauaiai ukaada eno wei, Dai Waria Godi, Ama nabairo we bou ui amaranaku erakune. Ama eme yaisinabairo we odi, i ma wirokeka mi erakuneba nae idua feamane weakunea wei. Eno weike wei, Anu we odi Amara, Dawae i Du me imusu orou yaisinanu dai edoro ari. Dawae Anu Isaraera orounu arakekaba emema efeisaya Simionima eno wei. ");
INSERT INTO aby_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eno weiro Merini Diosefuini emuama i amaranakubake i wei wake nauisake imuka foria uisi. ");
INSERT INTO aby_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simionima Merini Diosefuini emua we ma irauaiai uike Meribake eno wei, yewa amaranaku ea wei. Dawae moi Isaraera orou ma wirofiakuke nono moi Isaraera oroue fanisi mafiakuke ma feafiaku. Dawae Godinu wake wefekuie Dawa Godinu ereka ubu ibake emema Dawaini dino ukeifeisake Dawa medifeisa ibake emenu imukama imukeka ma boroo yafeisaya weike nono wei, anu imukari daiwere muneifakuke dai bauma anu imuka kai umane kuunao ari ukeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","I furo moi we bou ukeibi aweka danu ibiye Ena. Dawae Feneuronu aruma. I Asura Du oroue danu akaemuku demui orou. I awekae ewai uri. Danu emeini oya seweni (7) ibeibisiro nono danu eme me siniro danu mane oya keuwere, eidi fo (84) ibeibi. I aweka ewai dai sosi uwara mede dakeibike iro ewekaini dumuini ibaada guriguri ukaada moi odo odoro uruna ise dakeibi. ");
INSERT INTO aby_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simionima wake we me sinibaie i awekama idua farike i amaranaku erike Godi we ma irauaiai ui. Nono dubuenaro Dawa i Godima i Romani gaemani yawokeibisa orou Derusaremu goiroma yowefiakua weada yawokeibisa oroubairo anike eno wei, ibakeye i ma wiroke mune aneka Mesaia weaisa mi dawa na erea wei. Weike eno mane we eneiareibi. ");
INSERT INTO aby_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Merini Diosefu Godinu darawadu wakema wei enaenari uke me sikike Derusaremu goi meisike iroma Gareri orofa, emenu Nasaredi goiro anisi. ");
INSERT INTO aby_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","I amaranaku dai sinaada buna munaada iwoka daiwere muneibiro Godima Dawa we ma irauaiai ukeibi. ");
INSERT INTO aby_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu Danu amaeini babae oya aine wai ure Derusaremu goiro Godima Isaraera orounu Idifiroma waure aneka banau uruna ifisine aneibisi. ");
INSERT INTO aby_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu oya ireweni (11) me siniro ie emenu bisaraba ibake Derusaremu goiro enaenari anisa. Iro anisake ibeibisa. ");
INSERT INTO aby_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","I banau me siniro Danu amaeini babaema Derusaremu goi mesike anisiro i okoa amaranaku, Yesu, Dawa emuaini ane daui. Dawae Danu mane i Derusaremu goiro ibi. Danu amae babae emuama danu ibeka iwoka me ibake eno we imuisi, Dawae Danu naiyemukuini demuiro anisaya we imukada i odoro gienabu aneibisi. Aneibisiro dumu siniro Yesu fare dauiba ibake Dawa yodia ukeibisi. Emenu goi orouini Yesunu naiyemukuini emua yaisinabairo yodia ukeebe fou ure dauisi. ");
INSERT INTO aby_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Fou ure dauisi ibake owekike Derusaremu goiro yodia ufisine owere anisi. ");
INSERT INTO aby_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iro ane fakike yodia ukeebe odo buuba me siniro dai sosi uwara ubarenaro amuisi. Amuisiro Yesuma i dai sisa orounu ku ubarenaro yaure ibaada emenu wake naukada emuabairo wake moi we nauke ereibi. ");
INSERT INTO aby_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eno ukaada yaure ibibaie i orouma Danu moko wake naukada Danu moko wakeini Danu iwoka daiwerebake imuka foria ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yesuma eno ukeibibaie Danu amae babaema fare eraada imuka foria uisike Danu amaema eno wei, nanu amara, anemebake Anu babae uwa eno ukeyanu wei? Anu babaeini naini uwa A yodia ukaada enaisua wei. ");
INSERT INTO aby_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eno weiro Yesuma ma owerike eno wei, anemebake Na yodia ukakuneki? Nae Nanu Babaenu uwara ubarenaro yaure ibineie irauaiairoma nono anemebake ma nuna ukaisi wei. ");
INSERT INTO aby_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eno weiro Merini Diosefuma Danu wei wake ma nuna uisi. ");
INSERT INTO aby_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesuini emua Nasaredi goiro owere anisa. Yesuma emenu weibisi wake nauke mede dakeibi. Ibake Danu amaema i wake yaisina moi oroubairo we dakeibike me imukama imukeibi. ");
INSERT INTO aby_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu dai sinadae buna muneibike iwoka daiwere muneibiro Godima Dawa we ma irauaiai ukeibiro nono emema Dawae irauaiai miya eno weibisa. ");
INSERT INTO aby_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Daibiriusi Kisa, i Romani gaemani orounu dai miye dawa dawama oya fifidini (15) i orofa yaisina yawokeibi. I orofa yawokebe oya fodini me siniro oya demui mane ibooro ibiro yawokeibibaie Godima danu wake Dionibairo weiro isare aari. Dionie Sakarayasinu amara, dawama eme ibe me yao orofaro ibeibiro Godinu wake dawabairo isare aari. I furo Faeradima Diudia orofa yawokeibiro nono Erodi dawae Gareri orofa yawokeibi. Nono danu dabue Firifuma Aiduriaini Durekonaidini orofayai yawakeibi. Risaniasima Ebiriana orofa yawokeibi. Einasini Kaiyafasini emuae i furo dai ofereni ode sibore sianeka waiya ukeibisi. ");
INSERT INTO aby_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I furo Godinu wake Dionibairo isare aariro nauike Dionima Diodeni adua ewa bokenaroma eka bokenaroma Godinu wake aboro aboro we eneiareibi. Godinu wake we enaada eno weibi, yanu merama merama ukeka imuke mediawero Godima yanu merama merama ukeka mufike imuke medifiro ya babadaido umia i wake eno we eneiareibi. ");
INSERT INTO aby_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Isaiya Godinu wake we bou ui mi danu bukaroma Dionibake eno weaku, dawae eme ibe me yao nauwaro wake we enaada eno weaku, I Dai Waria Minu daaba wabuke ma gienabu uawe. Oraara daabaini madoini kifuru kafuruini ma giena uaweke i daaba ma gienabu uawe. ");
INSERT INTO aby_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eme yaisina Godinu ma wirokeka mi efisane weaku, Isaiyama eno owaowa yanake odiro Dionima enaenari ukeibi. Danu ararae eme yaisina emenu merama merama ukeka medifisake Yesunu wake naufisane ibake eno weibi. ");
INSERT INTO aby_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eme keuwere Dionibairo babadaido ufisane fakaro Dionima emuabake eno wei, ya waruma murie! Ainama Godinu fafekuke yabairo yanu merama ukekabake dino ufekubai wenuro naukisake ibake nabairo babadaido ufoke Godinu dino ukekabai ma berefone nabairo durame faraisa wei? ");
INSERT INTO aby_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Owere aniaweke i merama ukeka imuke mediaweke irau ukeka mane ibooro odiawero Godima efike iduaya wefi wei. Eno weike nono wei, me sara ufoisake Eibaramu dawae iyanu babae iyae danu sisia oroua wefoisaie i ari eno meya weike nono wei, Godima Eibaramunu ba sisia oroue yewa omama ubu ufiane wefekuie ubu ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Godinu kodo fanisi ufi odo idua fafine ukaku. Moi mima uya ei mamakuke ana umafine ukaku enaenarie Godinu kodo ufeku odoro yanu merama ukeka sinekabake ya kodo ufine ukaku. Moi ana irau kaibai da uwafekuie umane kuufekuke mune inaaro siafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eno weiro i ku siane ibisa orouma eno weisa, Godima iyae aneaneme irauaiai ukeka ufene weaku weisa? ");
INSERT INTO aby_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eno weisa ibake Dionima wei, aina mi dawa dei barukeka dei raarayai boboie moi dei barukeka me mibairo moi dei mafi. Enaenari uruna keuwere bobo mi dawa naka naka ufi wei. ");
INSERT INTO aby_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Moi dakesi muneka orouma Dionibairo babadaido ufisane fakake eno weisa, Godima iyae aneaneme ufene weaku weisa? ");
INSERT INTO aby_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eno weisaro Dionima emuabake eno wei, i Romani gaemani orounu weaisa dakesi oi mane muaweke nono moi deiro dakesi oi da muawe wei. ");
INSERT INTO aby_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Moi ame orouma dawabairo fakake eno weisa, Godima iyae aneaneme ufene weaku weisa? Eno weisaro Dionima emuabake ma owerike eno wei, emebake merama merama dauke yayakaweke emenu oi waira da uaweke yanu moko oi mane muawe Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","I Du orou yaisina i ma wiroke mune aneka Mesaia weaisa Mi koro ukenewaa ukeibisaba ibake emenu imusu we makanada eno weisa, Dioni, dawae Godinu Mesaiaba me? Emenu emenu eno weibisa. ");
INSERT INTO aby_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eno weibisabaie Dionima emenu imukeka iwoka sinaada emuabake eno wei, nae adua mane babadaido ukakuniaya wei. Nono dubuenaro moi mi nanu umuro aafeku mi Danu bunae daiwere na ari eno me. Nae irauaiai meba Danu ibooro da inare kuumaua wei. Dawae moi orou Godinu Imumu Irauini inaama babadaido ukenewaa ufiakua wei. Inu ubiye Dawama Danu buna mafiakuke iyanu merama ukeka sinekaroma ma irau ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dionima eno weike nono wei, Dawae Danu uidi kai amuke adiadi yareka dirii sisina ma irauaiai ufine saboroma uidi kaibai kore urero eku sianakuro oyauma i ifuru afuru mane urefu yare waure anakuro uidi kaibai mane eu sisinaro isaraku. I ba kaibaie uwara ubarenaro odakuke i kemibai mane i feare dakaku inaaro sianaku. I inaama ifuru afuru aine wai ure yareifekua Dionima Godinu emebake kodo ufeku ibai ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dionima eno we iifa ukeibike Godinu irau wake i oroubairo yareibirie. ");
INSERT INTO aby_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","I Gareri orofa yawokeibi dai mi, Erodima danu dabuenu aweka Erodiasi mareke munike danu ba me merama ukeka keuwere ukeibi ibake Dionima dino wake Erodibake wei. Eno weiro ibake Erodima Dioni ana ebaro odi. Erodima Dioni ana ebaro odi ie danu moi merama ukeka daiwere idua ui. ");
INSERT INTO aby_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Dionima i orou yaisina babadaido uke me sinike Yesu babadaido uiro Yesuma guriguri ukaada weibibaie ure eba ui. Ure eba uiro Godinu Imumu Irauma ubari ada ari eno uke isari. Dawabairo isare aariro ureroma wake isare aarike eno wei, Ae Nanu Amara ubiba Nanu imuka yaisina Abairo ibinuro Nae rooro daiwere ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuma Danu dai sineka oya dedi (30) ma bereike emebairo Danu kawama waiya ubi. Eno ukeibiro emema, Dawa Diosefunu amaraya, weibisa. Diosefu, dawae Eirinu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eiri, dawae Madadinu amara. Madadi, dawae Riwainu amara. Riwai, dawae Merokainu amara. Merokai, dawae Danainu amara. Danai, dawae Diosefunu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Diosefu, dawae Madaiasinu amara. Madaiasi, dawae Eimosinu amara. Eimosi, dawae Naumunu amara. Naumu, dawae Esorinu amara. Esori, dawae Neigainu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Neigai, dawae Medinu amara. Medi, dawae Madaiasinu amara. Madaiasi, dawae Simeinanu amara. Simeina, dawae Dousekanu amara. Douseka, dawae Dodanu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Doda, dawae Doanainu amara. Doanai, dawae Reisanu amara. Reisa dawae Serubabeonu amara. Serubabeo, dawae Sirudionu amara. Sirudio, dawae Nerinu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, dawae Merokainu amara. Merokai, dawae Adinu amara. Adi, dawae Kosaninu amara. Kosani, dawae Emodamunu amara. Emodamu, dawae Erunu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eru, dawae Diosuanu amara. Diosua, dawae Iriesanu amara. Iriesa, dawae Doriminu amara. Dorimi, dawae Madadinu amara. Madadi, dawae Riwainu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Riwai, dawae Simioninu amara, Simioni dawae Diudanu amara. Diuda, dawae Diosefunu amara. Diosefu, dawae Donamunu amara. Donamu, dawae Iriekiminu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iriekimi, dawae Mereanu amara. Merea, dawae Menanu amara. Mena, dawae Madadanu amara. Madada, dawae Neidaninu amara. Neidani, dawae Deiwidinu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deiwidi, dawae Desinu amara. Desi, dawae Obedinu amara. Obedi, dawae Bouasinu amara. Bouasi, dawae Samoninu amara. Samoni, dawae Neisoninu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Neisoni, dawae Aminadabunu amara. Aminadabu dawae Adamininu amara. Adamini, dawae Aninu amara. Ani, dawae Esaronunu amara. Esaronu, dawae Feresinu amara. Feresi, dawae Diudanu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Diuda, dawae Deikafunu amara. Deikafu, dawae Aisikinu amara. Aisiki, dawae Eibaramunu amara. Eibaramu, dawae Diranu amara. Dira, dawae Neionu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neio, dawae Seruganu amara. Seruga, dawae Reunu amara. Reu, dawae Fereginu amara. Feregi, dawae Ibanu amara. Iba, dawae Siranu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sira, dawae Keinaninu amara. Keinani, dawae Afakadinu amara. Afakadi, dawae Seminu amara. Semi, dawae Noanu amara. Noa dawae Remekinu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Remeki, dawae Meduseranu amara. Medusera, dawae Inokinu amara. Inoki dawae Derodinu amara. Derodi, dawae Mererianu amara. Mereria, dawae Keinaninu amara. ");
INSERT INTO aby_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinani, dawae Enosinu amara. Enosi, dawae Sedinu amara. Sedi, dawae Adamunu amara. Adamu, dawae Godinu amara. ");
INSERT INTO aby_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Godinu Imumu Irauma Yesunu imuka ubarenaro isarike wake fariro Yesuma i Diodeni adua idua medike ani. Idua medike aneibibaie Godinu Imumu Irauma Yesu eme ibe me orofaro waure ane odi. ");
INSERT INTO aby_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Waure ane odiro Yesuma iro odo fodi (40) aineibibaie seidanima Yesu uke iruke ereibi. Yesuma odo fodi (40) iro ibaada uruna ise dake ibeibiro odo keuwere me siniro desini daiwere uri. ");
INSERT INTO aby_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eno uiro seidanima Yesubake eno wei, Ae ba Godinu Amarabaie wearo yewa omama buredi sifiro ia wei. ");
INSERT INTO aby_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eno weiro Yesuma seidanibake ma owerike eno wei, Godinu bukaroma eno weaku, emema uruna mane ifeisaie emenu ibekae ba meya weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eno weiro seidanima Yesu we munike moi orofaro amuke ane odike i ibeka oroorofaini emeini yaisina sabu ma boroo yariro eri. ");
INSERT INTO aby_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eriro seidanima Yesubake nono wei, i oroorofaini emeini yaisina na makara ie nanuba aina aina yabake mamiane wemauie mamiaua wei. Eno weike seidanima Yesubake nono wei, yewa orofa akakaini erawa naukawa i yaisina Abake mamauanero Ama yawokeifiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nanu umu udiro ukafu ufakuke nabairo guriguri ufakuie i yaisina Abairo mamauanea wei. ");
INSERT INTO aby_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eno weiro Yesuma nono ma owerike eno wei, yewa wakeye Godinu bukaro ibinu, i Dai Godibairo mane guriguri uaweke Danu waiya mane uawe eno ibinua Yesuma wei. ");
INSERT INTO aby_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Eno weiro seidanima Yesu we munike Derusaremu goiro waure ani. Waure anike i dai sosi uwara eku fou duboro amuke ane odike eno wei, Ae ba Godinu Amarabaie ewadoma bibi uake isare aniaro Godima Danu bukaro wei enaenari i aneruma A yawokada wanama gabo mamimekaro me irauaiai isare ane isafakuro Anu umu omama da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eno weiro Yesuma dawabake nono ma owerike eno wei, Godinu bukaroma eno weaku, anu Dai Godi da uke iruke ea eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seidanima danu uke iruke ereka yaisina me siniro Yesu idua medike moi odoroma nono uke iruke efekubake medike owere ani. ");
INSERT INTO aby_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Godinu Imumu Irauma Yesu buna daiwere mairo Yesuma Gareri orofaro nono ani. Aniro eme keuwere Danu wake i orofa aboro aboro iro yaisina we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesuma i Du orounu sosi uwara uwararo we ma iwoka uke eneiareibiro naukada Dawa we ma daiwere ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesuma Nasaredi goiro fari. Adinaro Yesu Dawa okoanakuro i Nasaredi goiro ibeibi. Danu sabadi odoro ukeka bisarae i Du orounu sosi uwara uwararo amukeibi, nono i odoe enaenari uike i bukaro wake kakufine uyarie enari. ");
INSERT INTO aby_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Uyare enariro moi mima i we bou ukeka mi Isaiyanu buka Yesubairo mairo muni. I buka munike ma uramike i wake yodia uke ane fou uri. I buka ubarenaro ibi wakeye eno, ");
INSERT INTO aby_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Godinu Imumu Irauma Nabairo ibinu ibake Dawama Na i eraerabusa me oroubairo Godinu irau wake weimane ibake weakune. Na mune odaikaraie i wake weimane fare. Dawama na we odaikaraie i ana ebaro ibinao uke ibinisa orou ma worome odaimiaro fare anifisane ibake na we odaikararo farea eno wei. Ya naisa kikori bobo ari orou ya naisa foraeweke eawe. Ya arawere yawokeibekaro ibeka orou ya iroma mediaweke aniawe. ");
INSERT INTO aby_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Godinu irauaiai yawokaku odo idua fafine ukinua eno weimane ibake Na we odaikararo fare. ");
INSERT INTO aby_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I bukaro wake eno kakurike i buka nono dadau uike i buka yawekeibi mibairo maike yauri. Yauriro i ku siane ibisa orouma Dawa erenewaa uisa. ");
INSERT INTO aby_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesuma yaure ibaada eno wei, awoenae yanu yaure ibaada naukisa Godinu bukaro wake enaenari ukakua wei. ");
INSERT INTO aby_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yesuma eno wei ibake i yaure ibisa orouma we makanada eno weisa, Danu wenu wakeye irauaiaiya weisake Danu bebekuroma fari irau wakebake imuka foria uisake nono weisa, yewae anemedei ubu weisa? Dawae ba Diosefunu amaraba mero weisa? ");
INSERT INTO aby_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eno weisaro Yesuma emuabake ma owerike eno wei, yanu imukaisa ibai Na iwokaro yanu adinaro dadaa eno wefoisa, i arama ma wirokeka mi ae anu onami ma wiroa. Inu ubiye eno, anu Kafenamu orofaro buna ukeibi i ari anu ba goiro enaenari ua, yama eno wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei. Moi we bou ukaku minu goi orouma dawa iifa uke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ba weakune, Iraida imuke eawe! Iraida waiya ukeibi i furo wabu awekabo keuwere ibeibisa. I furo oya buubaini moi oya ane abanaroma obi make dake ibeibiba ibake arumu daiwere fari. ");
INSERT INTO aby_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Arumu daiwere fariro Godima Iraida danu goiro wabu awekabobairo we odaise dauiro Iraidama Saidoni orofa Serefadi goiro wabu aweka una demui mane unu koria wei. ");
INSERT INTO aby_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","29","I moi we bou ukeka mi Eraisa imuke eawe. Dawae Siria orofaro beko bobo mi, Neimani, ma wiroike i Isaraera orofaro ibisa Du oroubairo beko bobo orou ma wiroke dariea weada i adinaro Danu onamibake i we bou urieka orouma uisabai enaenari Danu onamibake ma boroo yaraada Yesuma eno weibaie i Du orounu sosi uwara ubarenaro yaure ibisa orouma i wake naukada ararua uriero Yesu i goiroma ma youre mukake unamu efaroma siafisane waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Siafisane waure aneibisabaie Yesu emenu wana daaroma me ari uike iroma ani. ");
INSERT INTO aby_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","32","Yesuma Gareri orofa Kafenamu goiro isare ani. Iro isare ane farike sabadi odoro i orou we ma iwoka ukaada bunawere wei ibake i orouma imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","I Du orounu sosi uwara ubarenaro moi seidaninu merama imumu bobo mi yaure ibi. I sosi uwara ubarenaro yaure ibaada daiwereroma eno wei, Yesu Nasaredi Mi, media! Aini aneme uke makafune aarinu wei? Na iwokaya na ma merama ufarine aarinua wei. Na iwoka A. Ae Godinu iifa mi wei. ");
INSERT INTO aby_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eno weiba ibake Yesuma sabu eno wei, wake da weake imuka ubarenaroma amuake ania wei. Yesuma eno wei ibake i seidaninu merama imumuma i mi mune sianiro dooro isariro i seidaninu merama imumuma i mi moi merama ukeka uke dauike i mi idua medike ani. ");
INSERT INTO aby_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ibai eka orouma imuka foria ukaada emenu emenu we makakake eno weisa, Dawae wake bunawere weakuro seidaninu merama imumuma naukada anaisaya weisa. Aneaneme yewa ari buna wake weaku weisa? ");
INSERT INTO aby_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I orouma Danu ukeibi wake i Gareri orofaroma aboro aboro we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Yesuma uyarike Du orounu sosi uwara medike Saimoninu uwararo ani. Ane farike uwara ubarenaro amuike eribaie Saimoninu naroeya ofe wadada uibake aine ibiro eri. Ereibiro i orouma eno weisa, dawa ma wiroa weisaba ibake Yesuma i awekanu buudiro enare ibaada i ofe wadada ukeibi ibaibake wake bunawereroma wadada me sia weiro ure nuda ui. Wadada ukeibi ibai me siniro i awekama uyarike emua uruna mariero isa. ");
INSERT INTO aby_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eweka ane isareibiro i goi orou emenu arama imusu imusu uke ibisa orou yaisina Yesubairo waure fare odiriekaro Yesuma emua yaisina wanama ure buririero emua yaisina wiroisa. ");
INSERT INTO aby_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Seidaninu moi merama imumu bobo orou emuaini iini waure fare Yesubairo odiriekaro Yesuma weibiro i seidaninu merama imuma i orou medirieka. Emua medaada wake daiwere eno weisa, Ae ba Godinu Amaraya weisa. I seidaninu merama imumuma Yesu Dawae Kerisoya weada iwoka sikaba Yesuma emuabake i wake da weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wai awanakuro Yesuma i goi idua medike yao orofaro ani. Aniro i orouma Dawa yodia ukeebe yodia ukeebe ane fou uraada eenu weisa, iya da mediake iyanu Kafenamu goiro ibia weisa. ");
INSERT INTO aby_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Eno weisaro Yesuma emuabake eno wei, Godinu yawokaku irau wake moi goi goiro wemane ibake Godima Na we odaikararo farea wei. ");
INSERT INTO aby_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yesuma i Diudia orofa Du orounu sosi uwara uwararoma aboro aboro Godinu wake ane weibi. ");
INSERT INTO aby_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Moi odoro Yesuma Genesareda kuna udi gibudiro enare ibaada i oroubairo Godinu wake we ma iwoka ukeibiriero i orouma Dawa ubi ubinaku fare ku sianada daba daba ure makaneibisa. ");
INSERT INTO aby_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","Eno ukeibisaro eribaie boudi sia raarayai kuna udiro ibisiro eri. I boudi onarou orouma i boudiyai meisake emenu iwame urokeibisaro erieke Saimoninu boudiro ane amui. Ane amuike Saimonibake eno wei, bara uaro eka deka anife weiro enaenari ui. Yesuma i boudiro yaure ibaada iroma i orou we ma iwoka ukeibirie. ");
INSERT INTO aby_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","We ma iwoka ukeebe we ma iwoka uke me sinike Yesuma Saimonibake eno wei, kuna kouro aniaweke yanu iwame siawero isafiro adua abu muawe wei. ");
INSERT INTO aby_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eno weiro Saimonima wei, Dai Waria Mi, dumu yafa adua abu mufene iwame siane awake enarainisike mune dakisia weike nono wei, Ama weakuba iwame siafeisiro kunaro isafekua weike weiro enaenari uisa. ");
INSERT INTO aby_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eno uisake iwame ei mamisake ekabaie adua abu keuwere mukaba ibake iwame ma babafine ui. ");
INSERT INTO aby_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Enoba emenu moi adara wana fisifisi uisaro emua unu kofiakane boudiro ane faka. Fakake adua abu waukake boudiro oisaro boudi sia raarayai wake fariro inuu yafisine uisi. ");
INSERT INTO aby_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni Fidama ibai erike Yesunu umu udiro iboo yanakaisari ukaada eno wei, Dai Waria Mi, nae merama merama ukeka miya na medinake imusu ania wei. ");
INSERT INTO aby_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dawaini danu adua abu demuiro mune eneibisa orouini emuama i adua abu fefera ekake ibake ia sirie. ");
INSERT INTO aby_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Debedinu amarayai Deimisini Dionini emua Saimoninu adua abu demuiro mune eneibisa orouma ia sirie. Yesuma Saimonibake eno wei, ia da sia wei. Adua abu munaku enaenari dubuenaroe eme we mufiakua ia da sia wei. ");
INSERT INTO aby_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Emenu boudiroma gibudiro fare isakake emenu eraerabusa yaisina meisake Yesunu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuma moi goiro ibeibibaie moi beko mami mi dawaini i goiro ibeibi. Ibaada Yesu erike Yesubairo farike Danu umu udiro iboo yanakaisari ukaada eenu wei, Anu arara na ma wirofarine wefakuie na ma wiroina wei. ");
INSERT INTO aby_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eno weibaie Yesuma wana sianike i mi ure burisada eno wei, ie Nanu araraya wei. Yesuma i beko me sia weibaie idua me sini. ");
INSERT INTO aby_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuma i mibake nono wei, eme moibairo da wayai weake i ofereni ode sibore sianeka mibairo aniake ma iwoka uaro efi wei. Anu ofe ubu irauaiai yainua Mosesinu darawaduma weaku enaenari i bekoma ma merama ukakune orou ma wirokada ofereni odaisa enaenari uaro emema efisa wei. ");
INSERT INTO aby_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesuma eno weiroma nono emema Danu buna ukeka i oroorofa yaisinaro we eneibisa ibake arama ukeibirie orou keuwere Yesubairo wirofisane waure fareibirieka. ");
INSERT INTO aby_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ibake Yesuma eme ibe me orofaro guriguri ufine aneibi. ");
INSERT INTO aby_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Moi odoro Yesuma we ma iwoka ukeibibaie Ferosi orou keuwere fakake naukeibisa. I Ferosi orouma Gareri goi goini Diudia orofaro goi goini Derusaremu goini iroma Yesubairo fakake Danu wake nauisa. I furo Godinu buna Yesubairo ibiba ibake Yesuma eme keuwere ma wirokeibirie. ");
INSERT INTO aby_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Moi orouma wana siane me umuma enare me mi boiso dubo uisake wearo ode waukake Yesubairo odifisaro ma wirofine waure faka. ");
INSERT INTO aby_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eme keuwere uwara aisame dadau uisaba ibake uwara ubarenaro ane dauisa. Aisamero ane dauisake uwara fou fafaro amuisake i fou ma eba uisake i wana siane me umuma enare me mi danu boiso duboini weaini i bobo ebaroma owainanaku Yesu enare ibi orofaro oisaro isari. ");
INSERT INTO aby_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eno uisaro Yesuma emenu mi ba ma wirofeku ibai imukeka daiwere iwoka uike i mibake eno wei, Nanu amara, anu merama merama ukeka muneke imuke medinea wei. ");
INSERT INTO aby_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesuma eno wei ibaibake i darawadu ma iwoka ukeibisa orouini Ferosi orouini imukama eno wei imuisa, Dawa eno wenuba ibake Godinu ibi we ma okoanaku ukaku. Dawa aina? Godi mane emenu merama merama ukeka mufekuke imuke medifekua eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuma emenu we nauke ereka iwoka ukaada ibake emuabairo eno wei, yanu imukama eno anemebake imukaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yesuma eno weike wei, abodei wakema i arama mibake wemau? Anu merama merama ukeka mumauke imuke medimau wemauba, uyaake anu wea muake ania wemau arie wei? Abodei wakema arawere wei? Eno weike nono wei, anu wea muake ania wei. I dei wakema arawere wei nono anu merama ukaku ima imuke medimau wene wakeye ara me wei. Anemedei bunawere umauro Nanu buna efoisa wei? ");
INSERT INTO aby_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","I dooro eneibaku Ba Eme Sini Minu bunae daiwereba ibake emenu merama merama ukeka munakuneke imuke medakune. Yama ibai ma nuna unao ufoisaba eno umaua weike i wana siane me umuma enare me mibake nono wei, uyake anu wea muake anu goiro ania wei. ");
INSERT INTO aby_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yesuma eno weibaie i mima emenu ibooro idua uyarike danu wea munike Godi we ma irauaiai ukaada danu goiro ani. ");
INSERT INTO aby_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eno uiro eme yaisina dawa ekake imuka foria daiwere ukaada ia siriero Godi we ma irauaiai ukaada eno weisa, yewadei ubue kawama erisia weisa. ");
INSERT INTO aby_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesuma i goi idua medike ani. Aneibibaie moi dakesi oi muneka mi, danu ibiye Riwai, dawae danu dakesi oi muneka uwararo yaure ibiro eri. Yesuma erike i mibake eno wei, Nanu umuro aarake Nanu iwoka ukeka mi sia wei. ");
INSERT INTO aby_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eno weiro ibake i mima uyarike danu ukeibi eraerabusa yaisina medike Yesunu umuro ani. ");
INSERT INTO aby_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Riwaima dai banauwere Yesubake ui. I dai banauwere uiro i dakesi oi muneka orouini moi eme keuwere i banau ifisane faka. ");
INSERT INTO aby_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Emuaini Yesunu iwoka ukeka orouini demuiro uruna iseibisa. Eno ukeibisaro i Ferosi orouini i darawadu ma iwoka ukeibisa orouini emuama Yesunu iwoka ukeka oroubake kamena weada eno weisa, yaini i dakesi oi muneka orouini i merama merama ukeka orouini yade anemebake demuiro uruna isaisa weisa? ");
INSERT INTO aby_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Eno weisaro Yesuma emuabake ma owerike eno wei, i arama uke me oroubake weroma i arama ma wirokeka mi aare dakinuke i arama uke ibinisa oroubake wenuke aarinua wei. ");
INSERT INTO aby_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","I ari enoe i irau oroubake wemane wayo aare dauneke i merama merama ukeka oroubake yanu merama merama ukeka imuke mediawe wemane ibake wayo fanea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Moi orouma Yesubake eno weisa, Dioninu iwoka ukeka orouma emenu bisaraba ibake odo keuwere uruna ise dakaada kau ukaisake guriguri ukaisa, enaenari i Ferosi orounu iwoka ukeka orouma eno ukaisa. Nono Anu iwoka ukeka orouma eno uke dakaisake urunaini aduaini sara mune isaisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eno weisaro Yesuma emuabake ma owerike eno wei, yama imukaisabai yanu wayo kofiakaisa orou i aweka awoena mufeku minu banauro uruna da ifeisake me ibifeisake anifeisa? I ari eno me! ");
INSERT INTO aby_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nono moi odoro i aweka awoena mufeku mi waure anifeisaie i orou uruna da ifeisake kau ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesuma emuabake eno weike nono wei, Mosesinu adina darawaduini Yesunu awoena wakeini da ma demuiro ufoisaya weada ibake yewa wake emuabake dubo waure weike wei, moi mima awoena wau da ma babareroma i awoena wau fekama adina wau sia ebaro da fifini ufeku wei. Eno ufekuie i awoena wauini adina wauini emenu ubue imusu imusuba ibake awoena wauini adina wauini merama sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yesuma eno weike nono moi wake eno wei, ainama awoena waini adua i adina abu ofero iifekuie i awoena wainima i adina abu ofe ma babanao ufekuke isanao ufekuba ibake i awoena waini adina abu ofe ma merama ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eno unao ufekuba ibake i awoena wainie i awoena abu ofero iifeku wei. ");
INSERT INTO aby_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nono ainama adina waini mane ifekuke nono awoena waini arara dafekuro wefekuie, i adina wainiye irauaiaiya weadabake eno ufekua wei. Yesuma Mosesinu adina darawadu wakeini Danu awoena we ma iwoka ukeka wakeini ibake yewa dubo waure weeka wake i ari eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Moi sabadi odoro Yesuini Danu iwoka ukeka orouini konoura waiya ubarenaro fare fisii yare anaada Danu iwoka ukeka orouma konoura ma roiroi yaraada wanama ma buruburu yare isaada enereibisa. ");
INSERT INTO aby_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eno uisaro i Ferosi orouma ekake eno weisa, anemebake i ari eno ukaisa weisa? Iyanu darawaduma weaku, sabadi odoro eno da uforo weakubairoma nono anemebake eno ukaisa weisa? ");
INSERT INTO aby_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eno weisaro Yesuma emuabake ma owerike eno wei, yanu dai sisia mi Deiwidini danu orou emua desini uriero uruna muneibisa i dadaa ya bukaro kakuraisaba me wei? ");
INSERT INTO aby_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yesuma eno weike nono wei, Deiwidi dawae desini uriba ibake Godinu uwara ubarenaro amuike weiro i dai ofereni ode sibore sianeka mima Godinu ereibi iifa buredie i dai sosi uwara yawokeibisa orou mane iseibisa buredi mairo munike isaada danu oroubairo mariero isaya wei. Emuae eno uisaro Godinu darawaduma emua unu koreka daaba dadau uke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuma eno weike emuabake nono wei, i Ba Eme Sini Mi Dawae i sabadi odonu ubi mi. Enoba Dawama i odo idua yawokeibakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Moi sabadi odoro Yesuma i Du orounu sosi uwara ubarenaro amuike we ma iwoka ukeibi. We ma iwoka ukaada eribaie moi baena wana merama bobo mi idua yaure ibiro eri. ");
INSERT INTO aby_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","I darawadu we ma iwoka ukeibisa orouini Ferosi orouini emuama Yesu erenewaa ukaada Yesuma i wana merama mi ma wirofekuba me arie weisake ibake Yesu erenewaa ukaada we makakake eno weisa, i mi ma wirofekuie Dawa wayai wefeisia weisake ibake ereibisa. ");
INSERT INTO aby_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesuma emenu imuka ubarenaro imukeibisa ibai iwoka sinike i wana merama mibake eno wei, yewado Na ubiubi aarake enaa wei. Eno wei ibake i mima danu yaure ibi orofaroma uyarike Yesu ibi udiro ane enari. ");
INSERT INTO aby_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ane enariro Yesuma i oroubairo eno wei, abodeima irauaiai, yewa mi dawa sabadi odoro unu komauba ba ma merama umau wei? Dawae ma wiromau imukaisaba ba ma feamau imukaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eno weike i orou yaisina busikai ma oweowere uke erieke i wana merama mibake eno wei, anu wana siaa weiba ibake i mi dawa danu wana sianibaie danu wana gienabu sinike idua wiroi. ");
INSERT INTO aby_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eno uiro i orouma ibai ekake imuka ka daiwere uisake eno weisa, Yesu Dawa aneaneme ufeisi ari we makaka. ");
INSERT INTO aby_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","I odoro Yesuma oraararo guriguri ufine amuke ani. Oraararo amuke anike Godibairo dumu yafa guriguri ukaini. ");
INSERT INTO aby_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wai awanakuro Danu umuro eneibisa orou yaisina u weiro Dawabairo faka. Fakaro i faka oroubairoma eme duwero (12) mane we murieke emuabake yae afasoro oroua wei. ");
INSERT INTO aby_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","I orounu ibi ibiye yewado, Saimoni, danu moi ibiye Fida mami. Fidanu nabueye Enuduru. Fidaini Enuduru aidakaini Deimisini Dionini Firifuini Badoromiaini Madiuini Domasini Arofiesinu amara Deimisini, moi Saimoni, dawae Keinani goi mi, dawaini Deimisinu amara Diudiasini moi Diudiasi Ikariada, Dawae Yesu we forairo muka mini, Yesuma i orou yaisina we mune demuiro odirie. ");
INSERT INTO aby_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yesuini Danu iwoka ukeka orouini i oraararoma fakaro isare aaka. Yesunu umuro eneibisa eme feferaini Diudia orofa orouini Derusaremu goi orouini dawararo goiyai Dairaini Saidoni orouini eme keuwere Dawabairo Danu wake naufisake emenu arama imusu imusu urie ibai wirofisane fakaro emua ma wiromirie. Yesuma i seidaninu merama imumu bobo orouini emua ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesunu buna Dawabairoma fare aniba ibake i orouma Yesu ure burisake wiroisa. ");
INSERT INTO aby_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuma Danu iwoka ukeka orou eraada eno wei, Godinu ure yawokaku orofa ya meramawere ibeka orou yanua rooro uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yae awoena desini urakuneba nono dubuenaroe Godima ya unu koreifiakuro me irauaiai ibifoisa ibai imukada rooro uawe wei. Nono awoena ii weaisakema nono dubuenaro yo wefoisaya rooro uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yae i Ba Eme Sini Minu orouba ibake eme moima yabake imuka ka uke yafiakaisake yabairo me sara merama ufeisake yanu ibi we ma merama ufeisa. Eno ufiakaisaie rooro uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","I odoro eno yabairo ufeisaroma nono yanu moko muneka daiwere urero mufoisaya rooro uaweke rooro daiwere ufoisa ibai imuaweke bibi uraada amuke isare uawe. I orounu oinamukuma Godinu we bou ukeibirie oroubake enaenari meramawere ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ya eraerabusa keuwere orou erenewaa uforo! Yama awoena irauaiai ibinisaroma nono yanu eraerabusa yaisina sabu me sifekuba ibake meramawere ibifoisa. ");
INSERT INTO aby_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ya awoenae uruna isaisaro boana urakune orou erenewaa uforo, yama dubuenaroe desini daiwere ufiakuro ifoisa uruna meba ibake ii wefoisa. Awoena yae rooro ukaada yo weaisakema nono dubuenaroe imukari ufoisake ii wefoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Emema ya we ma irauaiai mane ufeisaie erenewaa uforo! Emenu babaemukuma i meo we bou ukeka oroubake enaenari we ma irauaiai mane urieka. ");
INSERT INTO aby_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesuma i wake eno weike nono wei, ya Godi imukaisa oroubake wake wemaro nauawe. Yaini wasai ukaisa oroubake imukari uaweke emema yabairo imuka ka uke yafiakaisaie emuabairo irauaiai uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Emema yabairo wake merama wefeisaie emuabairo irauaiai wake weaweke nono yabairo meramawere ukaisa oroubake Godibairo guriguri uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ainama ya omeafera ufiakuie nono moi enaini ma oweawero ufia. Ainama yanu sedi mufekuie yanu dei barukekaini dawabake maewe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aina ainama eenu wefeisaie emenu wefeisa rabu emuabake mayakawe. Ainama yanu eraerabusa mufekuie nono da we muawe. ");
INSERT INTO aby_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Emema yabairo aneme ufisane wefeisaie emuabairo enaenari uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Emema yabake imukari ukaisaro emua moko imukari ukaisaie irauaiairoma nono Godima yabake ya irauaiai orou da wefekua eno wei. Inu ubiye i eme yaisinaini i merama merama ukaisa orouini enaenari emenu emenu imukari uke makanaisa. ");
INSERT INTO aby_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yabairo ainama irauaiai moko moko uke makafoisa nono anemebake urero moko mufone ufoisa? I merama merama ukaisa orouini enaenari ukaisa. ");
INSERT INTO aby_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Emema yabairo anemerabu eenu wefeisaro makaada eno we imufoisa, emuabairo dubuenaro moko mumau we imufoisaie nono anemebake urero moko mufone ufoisa? I merama merama ukeka orouini enaenari ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yaini wasai ukeifeisa orou imukari uyakaweke emuabake ukeka irauaiai uaweke emua we muyakawe. Eno ufoisake mokobake imuke dafoisaie yanu urero moko daiwere mufoisa. Eno ufoisaie yae i urero ibinu Godinu amaraku sifoisa. Yanu Godi Dawae irauaiai. Dawae i imuke dakaisa orouini i omi ukaisa oroubake emuabairo irauaiai ukakune. ");
INSERT INTO aby_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Iyanu Babae Godima eme yaisinabake imukari ukakune enaenari uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesuma eno weike nono wei, moi oroubairo moi mi me sara wayai da wefoisaie Godima ya wayai da wefekua eno wei. Nono moi oroubake me sara wayai wefoisake fanisi mafiakaisaie nono Godima enaenari yabake wayai wefekuke fanisi mafiakua eno wei. Moi orounu merama ukeka imuke medifoisaie Godima yanu merama ukeka imuke medifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Moi oroubairo mafoisaie nono Godima yabairo mafiakuke nono moibai deiro makeifiakuro oraara ukeebe wake fafeku. Aneme aneme mafoisaie enaenari yanu moko mufoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuma emuabake moi wake dubo waure weike eno wei, naisa kikori bobo mima moi naisa kikori bobo mi wanaro mamifekuke waure anifekuie i miyai emuae kafururo isafisisia eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","I uke iwoka ukaku miye danu sisa mi ma bereke me. Nono i uke iwoka ukeibaku mi dawa i we ma iwoka ukeibaku mi ari eno i yaisina iwoka ukakuie danu sisa mi ari sinakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Yesuma eno weike wei, nono iyanu imuka ubarenaro meramako efekema ai dubuenaro wefene ibake eno wei, anemebake moi minu naisaro ifurunaku erenewaa ukaisake nono yanu naisaro ibinu ana kuku ari ifuruwere ere dakaisa? Anemebake eno weaisa, kaka, ukeka meramawere dai me ifurunaku ari mune siama weaisake nono yanu naisaro ukeka meramawere, ana kuku ari ibinuro ere dakaisa? Ya meomao weaisa orou yanu naisa ubarenaro ibinu ana kuku ko mune siaweke erenewaa uaweke nono yanu kaka nabuenu naisa ubarenaro ifuru mune siawe wei. Yesuma emenu merama merama ukekabake dubo waure weada yewa wake i ari eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesuma nono wei, irau ana dawa merama kaibai da uwafekuro nono merama ana dawa irau kai da uwafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Irau ana warafekuie irau kai uwafeku. Nono merama ana warafekuie merama kai uwafeku. Moi anama irau kai uwafekuie irau anaya wefeisa. Nono moi anama merama kai uwafekuie merama anaya wefeisa. Aneme aneme ufeku enaenari wefeisaya eno wei. Boruba kai sinisini bobo anaro mune dakaisaya eno wei. Imusu anaro fasiforo naadidi kai ari iro mune dakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","I ari enoe, i irau mima irauaiai wake weakuie danu imukaro ino mebake irau wake mane weaku. Nono i merama mima meramawere wake weakuie danu imukaro ino daiwere ibinuba ibake merama wake mane weakua eno wei. Moi mima danu imuka ima wake farakuba ibake i ari eno mane weibakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Anemebake Nae iyanu Dai Waria Miya weaisake nono Nanu wake nauke dakada imuke dakaisa? ");
INSERT INTO aby_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ainama Nabairo fafeisake Nanu wake naufeisake enaenari ufeisa, i oroue i ari eno we enaenari umiaua wei. ");
INSERT INTO aby_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Moi mima uwara ma enafine ui. Uwara kukubukai eba yafawere daune isare anike kukubukai oma duboro sianike omaini dooini sianike usima yanairo ara sini. Danu uwara eno ubu uiro obini okuini fakikema ma doroo yare dauisi. ");
INSERT INTO aby_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nono moi orouma Nabairo fafeisake Nanu wake naufeisakema nauke medifeisa i oroue i ari eno we enaenari umiau. Moi mima uwara ma enafine uikema kukubukai siane dauike me adua gibudiro ma enari. Eno uiro obi isarike oku farike i minu uwara sabu ma doroo yariro i uwara idua me sini. I enaenari emema Nanu wake da naufeisaie sarawere ufeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuma Danu we ma iwoka ukeibi wake i oroubairo we me sinike kafenamu goiro ane fari. ");
INSERT INTO aby_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ane fariro moi Romani ame kafudeninu waiya ukeibi ubi mi arama uike feafine ukeibi. ");
INSERT INTO aby_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ukeibiro moi orouma Yesunu eme ma wirokeibirie wake weisaro i ame kafudeni mima nauike danu waiya ukeka mi ma wirofine moi Du dai orou Yesubairo we odairiero anisa. ");
INSERT INTO aby_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Anisake ane Yesubairo faka. Yesubairo fakake eenu weada eno weisa, i miye irauaiai mi, dawae iya Du oroubake imukari ukakuni. Dawama iyanu sosi uwara ma enaria weisa. ");
INSERT INTO aby_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","I orouma eno weisaba ibake Yesuini emuaini demuiro owere anisa. Daaba yafa me ekanaku aneibisabaie i ame kafudeni danu we odairie naiyemukuma fakake Yesubairo i minu wake eno weisa, Dai Mi, nae irauaiai mebake Abairo fare daunea nanu uwararo da aarake wake mane wearo nanu waiya ukeka mi wirofi wea eno fare weisa. ");
INSERT INTO aby_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nae dai ame miroma nono moi dai orouma na yawokakunekaro nono nama ame orou keuwere yawokakuniaya eno wei. Ibake nama moi mi a ania weakunero anaku. Nono moi mi a ewaro aara weakunero aaraku. Nanu waiya ukeka mibairo a eno ua weakunero enaenari ukakua weakune weia weisa. ");
INSERT INTO aby_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eno weisaro Yesuma i wake nauike imuka foria ukaada owere eraada Danu umuro aareibisa oroue keuwerebake ma owerike eno wei, i wake naukaisa? Ya Isaraera oroubairo yama Na imukeka imuka i ari eno fou ure daunea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I Minu naiyemukuma Yesu meisake i minu uwararo owere anisa. Ane fakake ekabaie i arama uke ibi mi wiroikeibiro eka. ");
INSERT INTO aby_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Moi odoro Yesuini Danu iwoka ukeka orouini moi eme keuwereini emuama Neina goiro anisa. ");
INSERT INTO aby_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anisake i goiro fareibisabaie i goi orouma moi feari mi uwararoma ooru ubarenaro odifisane waure aneibisa. I feari mi danu amaeye wabu aweka danu amarae i una demui mane. Enoba i wabu aweka dawabairo moi amaraku me. I wabu awekaini i goi orouini emuama aneibisa. ");
INSERT INTO aby_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","14","Aneibisaro i Dai Waria Mima i wabu aweka erike imukari daiwere ukaada eno wei, ii da wea weike anaada i feari minu wearo yabairo i wearo oisake waure aneibisa orouma idua enaka. Enakaro Yesuma eno wei, awoena mi, uyaa wei. ");
INSERT INTO aby_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eno weibaie i mi idua uyare yaurike wake wei. Yesuma i mi danu amaebairo nono ma owere anu amara idua weike mai. ");
INSERT INTO aby_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yesuma eno uiro i orouma ia siriebake Godi we ma irauaiai ukaada eno weisa, awoenae i daiwere we bou ukeka mi iyabairo uyarinua weisa. Awoenae Godima Danu orou unu kofiane ukakuro eraisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesuma i uibai i Diudia orofaroma aboro aboro moi goi goiro we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Dioninu iwoka ukeka orouma i wake yaisina Dionibairo weisa. Eno weisaro Dionima danu iwoka ukeka miyai weiro dawabairo ane fakiro Dionima eno wei, iyanu Dai Waria Mibairo aniawake eno weawa, ae iyanu koro ukaisi Mesaiaba moi mima fafekuro efeisi ariya weike euwa, aniawake we nauke eawa wei. ");
INSERT INTO aby_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Eno weiro i miyaima anisike Yesubairo fakibaie Yesuma arama imusu imusu urie orouini umu beobeo bobo orouini naisa kikori bobo orouini seidaninu merama imumu bobo orouini emua yaisina ma wirokeibiriero ekike Yesubake eno weisi, Dioni babadaido mima uwa we odainuro danu wake Abairo wefune aare farisua weisi. Eno weisike Dioninu wake eno weisi, Ae iyanu koro ukaisi Mesaia A iduaba moi mima fafekuro efeisi weisi? ");
INSERT INTO aby_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eno weisiro Yesuma emuabake ma owerike eno wei, oweawake Dionibairo aniawake yanu awoena eraisi iini naukaisi ibai yaisina dawabairo eno weawa, i naisa kikori bobo orou emuae eraisaro i umu beobeo bobo orou emuae gienabu enaraisaro i beko mamakune orou emuae wirokada ofe irauaiai ibinisaro i ome gogore nauke me koko orou emuae naukaisaro i fearaisa oroue fearaisa iroma ma uyarakuniaro i meramawere ibinisa oroubairo Godinu wake weaisa eno weawa wei. ");
INSERT INTO aby_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ainama Na ma nuna da ufarakuke Na mede da ufarakuie Godima dawa ma irauaiai ufekuro rooro daiwere ufeku. Dionibairo owere aniawake i wake eno weawa Yesuma wei. ");
INSERT INTO aby_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Dioninu wake weeka miyai emua Yesu meisike owere anisiro Yesuma i ku siane ibisa orou eraada emuabairo Dionibake eno wei, I eme ibe me yao nauwaro anemerabu efone anisa? Oyauma ouwa koe ma amani amani ukaku ari eno buna me mi efone anisa? Anemerabu efone anisa? Irauaiai oi daiwere wau mune barukaku mi efone anisa? I irauaiai wau danu make munekae daiwere orou emuae eme ibe me orofaro ibe dakaisake i dai yawokeka orounu uwararo ibinisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","I mede anemerabu efone anisa? I we bou ukeka mi efone anisa? Nanu wake nauawe, dawae okoanaku we bou ukeka mi me. Dawae daiwere we bou ukeka miwere. ");
INSERT INTO aby_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Godinu bukaroma nono dawabake eno weaku, ea, Nanu fo weeka mi dawako we odaimauro anifekuke Anu daaba wabuke ma gienabu ufekuroma Ae ai dubuenaro anifakua ea weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eno weike nono wei, Nanu wake nauawe Yesuma eno wei. I furo yewa dooro awekaboma doreibirieka orou emua yaisinabairoe Dionoma daiwerero nono i oroue okoananaku. Danu ukeka waiya okoanaku me daiwereke danu waiyae bokairo. Ie ba. Nono Godinu yawokaku orofaro awoena yawokakune roiya me oroue okoanaku mero daiwere nono Dioni danu adinaro waiya ukeibi i furo dawae okoanaku ari Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eno weiro i orouini dakesi oi muneka orouini nauisake emuae adinaro Dionibairo babadaido uisaba ibake Godi we ma irauaiai uisa. ");
INSERT INTO aby_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nono I Ferosi orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emuama Godi imukekabai eka meisaba ibake Dionibairo babadaido uke dauisa. ");
INSERT INTO aby_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuma nono wei, yewa ibinisa oroude abo orou arie? Yewa oroue aneme ari wemau? ");
INSERT INTO aby_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yewa oroue amarananaku ari weakune. Amarananakuma akaka naisaro yauraisake emenu naiyemukubake eno weaisa, buma uraisiro ya yaura ure dakaisa. Sorara ukaisiro yae sorara uke dakaisaya weaisa. ");
INSERT INTO aby_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dioni babadaido mima farinuke moi uruna imusu imusu ise dakinuke wainini ise dakinuba ibake yama weaisa, dawae seidaninu merama imumu bobo miya weaisa. ");
INSERT INTO aby_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I Ba Eme Sini Mima farinuke moi imusu imusu urunaini waini aduaini isinuro yama eno weaisa, Dawae uruna eira mi ibake waini isinuro beforo merama ukinu miya weaisa. Dawae dakesi muneka orouini merama merama ukeka orouini emenu naiye weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eno weike nono wei, I Ba Eme Sini Mini Dionini emua Godinu demui waiya ukaisi ibake i Godinu wake naukaisake emua eraisa orouma Godinu ukeka sineka baya imukaisa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Moi Ferosi mima Yesubake eno wei, nanu uwararo aarake uruna ia wei. Eno weibake Yesuma i minu uwararo ani. ");
INSERT INTO aby_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Anike uruna ifine yaure ibibaie i goiro moi merama merama ukeibi awekama Yesu iro farinua ibai nauike anike irauaiai urumu adua omama ubu uisa kawaburo iise waurike uwara ubarenaro amuke fari. ");
INSERT INTO aby_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesu yaure ibiro i awekama Danu derena enaro fare enare ibaada ii weibiro ii du Yesunu umuro isareibi. Isareibiro nono i awakama Yesunu umu danu yafawere fouma idima ma isurike Yesunu umu oo uike i irauaiai adua munike Yesunu umuro ma oiniro i adua Yesunu umuro kari. ");
INSERT INTO aby_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eno uiro i uruna ui ubi mi dawa Ferosi miba ibake dawama erike eno we imui, yewa miye we bou ukeka mibaironae danu ofe ure burisaku awekae merama merama ukeka bobo awekaya ibai Dawa iwoka sifine we imui. ");
INSERT INTO aby_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","41","Eno we imuiro Yesuma i mibake eno wei, Saimoni, Nanu wake wemaro naua wei. Eno weiro i mima wei, Sisa, anu wake wearo nauma wei. Eno weibaie Yesuma wei, moi miyaima moi mibairo oi we muki. Moi mi dawa daiwere fai aderedi kina (K500) we muni, Nono moi mi dawae daiwere me fifidi kina (K50.00) mane we muni. ");
INSERT INTO aby_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","I miyaima eno uisikema nono dubuenaro moko makekabai oi mebake i minu moko make dauisiro i oi marie mima mediawa wei. Eno weiro abo mima i oi marie mibake imukari daiwere ukaku wei? Imuke ea, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yesuma eno weiro Saimonima wei, na imukakuneie eno, i oi daiwere we munike danu oi moko make daui mi dawae imukari daiwere ukakua wei. Eno weibaie, Yesuma wei, ba weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesuma eno weike owerike i aweka eraada Saimonibake nono wei, yewa aweka eraaku? Nae anu uwararo amunebairoma ama Na umu urokeka adua make danararo i awekama Nanu umu danu ii duma urokinuke nono danu fouma idima ma isurinua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eno weike nono wei, ama Na yabake oo uke danararo nono dawama Nanu umu oo ukaada ibinua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ae Nanu iiriro irauaiai urumu adua ma oine dakinuro dawama Nanu iiriro irauaiai urumu adua ma oininua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Enoba abake weakune i awekama Nabake imukari daiwere ukaada ibinubake danu dai meramawere ukeka muninuke imuke medinua wei. Ainama merama ukeka dai menaku imuke medakuro dawae imukari dai menaku mane ukakua wei. ");
INSERT INTO aby_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eno weike i awekabake nono wei, anu merama merama ukeka Nama muneke imuke medine wei. ");
INSERT INTO aby_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eno weiro i yaure ibaada uruna iseibisa orouma nauisake we makanada eno weisa, i merama merama ukeka mune imuke medaku mide ainadei, weisa? ");
INSERT INTO aby_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eno weisaro Yesuma i awekabake wei, anu imukekae daiwereba ibake wirokinua aniake me irauaiai ibia eno wei. ");
INSERT INTO aby_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Moi odo odoro Yesuma Godinu yawokaku orofabake irau wake moi goi goiro we eneiareibi. Danu iwoka ukeka orou duero (12) Dawaini anisaro Yesuma seidaninu merama imumu bobo arama uke ibisaro ma wiroi awekaboini moi awekaboini Dawaini eno anisa. Moi awekanu ibiye Meri Magidarini weaisa aweka, Yesuma i awekanu imuka ubarenaroma seidaninu merama imumu seweni (7) we yowerieke i aweka ma wiroi. ");
INSERT INTO aby_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","I awekaini Dusanu aweka Doana, danu eme Dusae Erodinu waiya ukeka orou yawokeibirie mi. I moi aweka ibiye Susanaini nono moi awekabo keuwereini emuama aneibisake Yesuini Danu iwoka ukeka orouini emuabairo urunaini oini makeibirieka. ");
INSERT INTO aby_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","I goi goi orou keuwere fare ku siakaro Yesuma emuabake dubo waure wake weada eno wei, moi mima yobai waifine waiyaro ani. Ane farike diru muni. Diru mune me sinike yobai munike siane eneibi. Yobai siane eneibiro yo moibai daabaro isakaro emema duboro amuke adiadi yare aneibisaro nono gasiroma iseibisa. ");
INSERT INTO aby_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nono moi yobai oma firifiri bobo dooro isakake sabu kua fareibisaro nono doo ubarenaro gibudike doo ubarenaro adua fofo meba ibake boke ure me sika. ");
INSERT INTO aby_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nono moi yobaie sinisini bobo ou kunu ubarenaro isakake irau warakakema nono ou kunuwereba onu eriro kai uwane dauisa. ");
INSERT INTO aby_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nono moi yobaie irau dooro isakake irauaiai warakake kaibai keuwere uwaka. Yo kai demuima moi kaibai wani aderedi (100) uwania weike wei, i ome bobo oroue ya Nanu wake naukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","10","Danu iwoka ukeka orouma Yesubairo eno weisa, i dubo waure wenu i wakenu ubide aneme ari weisa. Eno weisaro Yesuma ma owerike emuabake eno wei, Godinu ararae yama Danu ure yawokaku irau fe wakenu ubi iwoka ufone ibake ma boroo yarakunekema nono i moi emebairo dubo waure weeka wakeroma weakune. I orouma i wakenu ubi ma nuna ukaisaba ibake awoena eraisakema ba bai ere dakaisa. Ibake naukeka naukaisakema nono ba bai nauke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuma eno weike nono wei, i dubo waure wene wakenu ubiye eno, i yobaie Godinu wake ari. ");
INSERT INTO aby_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I daabae Godinu wake naukaisa orou ari. I miye Godinu wake we enarakuro i daabaro enereibeka orouma Godinu wake naukaisaro seidanima sabu farakuke i naukaisa wake idua ma nuna ukakune, i orouma naunao ufeisake wironao ufeisaba ibake eno uke yarakune. ");
INSERT INTO aby_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Enaenarie moi orou emua oma firifiriwere dooro siani, i ari eno emuama Godinu wake naukaisake rooro ukaisaro Godinu wakebake awe waa emuabairo farakuro ibake weada Godinu wake naukenewaa uke dakaisake emenu Godi imukeka imukae irauaiai me. Emenu imukekae irauaiai mebake i wake medaisa. ");
INSERT INTO aby_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Moi oroue i ou kunuwere orofa ariba ibake Godinu wake naukaisakema nono emenu imukeka imusu imusu imukaisake emenu arara eraerabusa munaisake emenu arara yaisina ukaisake i wakenu daaba dadau ukaisaba ibake irauaiai ukenewaa dakaisa. ");
INSERT INTO aby_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nono moi orou emuae i irau dooro isakake irauaiai waraisa ari eno, Godinu wake naukaisakema nono emenu irau imukama imukenewaa ukaada irau wake wenewaa ukaisake ibenewaa ukaada irauaiai ukenewaa ukaisaro emema eraisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuma nono eno wei, ramefa biafoisake okea wowonaroba sebo wowonaro odifoisa? I ari eno ufoisa? Me, eno da ufoisa! Ramefa mune biafoisaie aiso odeka orofaro aiso odifoisaro eme aweka i edoro eraada ibifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Enaenarie Godinu yawokaku orofabake fema imuke bou ukaku eraerabusa yaisinaini i fema ukeka yaisina ma boro yafekuke edororo odifekuro eraada iwoka ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Enoya i naukeka eraerabusa aneaneme wefeisaie naukenewaa uawe wei. Ainama naukenewaa ufekuie Godima moi naukeka dawabairo mafekua wei. I daiwere naukaku mibake moi naukeka mafekuke nono i demuinaku imukaisa orouma we imukaisa, nanu naukekae iduaya we imukaisaie emenu dai menaku naukaisa ibai mareke mufiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu Danu amaeini Danu naburakaini Yesubairo anifisane faka. Ane fakakema nono eme keuwere fare ku siane ibisake i daaba dadau uisaba ibake Yesubairo ane fare dauisa. ");
INSERT INTO aby_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ane fare dauisake ewa dewa enare ibisaro moi orouma emua eriekake Yesubairo ane fakake eno weisa, Anu amaeini naburakaini A emekane aarisake uwara udiro enare ibinisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eno weisaro Yesuma emuabake eno wei, Nanu amaeini Nanu naburakae Godinu wake naukada enaenari ukaisa oroue emua iduaya eyakawe wei. ");
INSERT INTO aby_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Moi odoro Yesuini Danu iwoka ukeka orouini boudiro amukaro Yesuma eno wei, kuna ekabokenaro siraa yafe wei. Eno wei enaenari aneibisa. ");
INSERT INTO aby_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aneibisabaie Yesu nauka aine ibiro oyau daiwere fari. Oyau daiwere fariro kuna ufe daiwere uyariro boudi inuu yafine uiro i orou feafisane uisa. ");
INSERT INTO aby_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","I orouma Yesu ma uyakake eno weisa, Dai Waria Mi, iyae feafene ukaisia weisa. Eno weisaro Yesuma naisa forakada uyarike oyauini adua ufeini we kuuriro oyauini adua ufeini me sinike me mo ari sini. ");
INSERT INTO aby_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eno uiro Yesuma Danu iwoka ukeka oroubake eno wei, Na imukenewaa ukakunekaba me wei? Yanu imukeka aboro wei? Eno weiro Danu iwoka ukeka orouma ia sinaada imuka foria uisake we makanada eno weisa, yewa miye abo miro oyauini aduaini Danu wake naukisa weisa. ");
INSERT INTO aby_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","29","I Gerasi orofaro seidaninu moi merama imumu bobo mima ibeibi. I mi dawae odo keuwere wau rune dakeibike uwararo aine dakaada i eme feareibisaro ane odeibirieka oma eraboro aineibi. I seidaninu merama imumuma i mibairo odo keuwere berukeibiba ibake emema i minu umu wana senima uwane kariseibisake yawokeibisa. Eno uke odeibisaroma i mima seni ma furufuru yareibiro i seidaninu merama imumuma danu derenaro amuiro eme ibe me orofaro ani. Yesuini Danu iwoka ukeka orouini emuama i Gerasi orofa kuna ekabokena iro ane enaka. I Gareri orofa moi enaroe i Gerasi orofa moi enaro nono i kunae abanaro ibi. I Gerasi orofaro ane enakaro Yesuma gibudiro isare enaribaie i seidaninu merama imumu bobo mima Yesu fou uri. Dawae Yesu fou uriro Yesuma i seidaninu merama imumubake eno wei, danu imuka ubarenaroma amuke ania wei. Eno weiba ibake i mima Yesu eraada ifoma kodudu yanakada daiwere eno wei, Yesu, dai urero ibinu Godinu Amara aini naini demui meya anemebake aarinu wei. Eno weike wei, na fanisi da maina wei. I Mi dawae odo keuwere wau rune dakeibike ofe mane enaada ba goiro ane dakeibike eme feareibisaro ane odeibirieka oma eraboro aineibi. (I seidaninu merama imumuma i mibairo odo keuwere berukeibiba ibake emema i minu umu wana senima uwane kariseibisa. Eno uke odeibisaroma i mima seni ma furufuru yareibike i seidaninu merama imumuma danu derenaro amuiro eme ibe me yao orofaro ani.) I mima Yesubairo aareibibaie Yesuma i seidaninu merama imumubake ania weibaie i mima Yesu eraada Yesunu umu udiro iboo yanakaisari ukaada wake daiwereroma eno wei, Yesu, Dai urero ibinu Godinu Amara nabake aneme ufane ukaku wei. Mediake na fanisi da maina wei. ");
INSERT INTO aby_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eno weiro Yesuma i minu ibi we nauke eribaie seidaninu merama imumu keuwere i minu imuka ubarenaro ibisaba i mima ibake eno wei, nanu ibiye keuwereya wei. ");
INSERT INTO aby_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eno weiro i seidaninu merama imumuma Yesubake nono weisa, i merama orofaro iya da we odaiya weisa. ");
INSERT INTO aby_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eno weada ekabaie borosiri keuwere oraararo uruna iseibisaro ekake Yesubairo eenu weada eno weisa, iyanu ararae i borosirinu imuka ubarenaro amufene weaisia weisaro Yesuma wei, iro aniawe wei. ");
INSERT INTO aby_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yesuma eno weiba ibake i seidaninu merama imumu i minu imukaroma amuke fakake anisake i borosirinu imuka ubarenaro isaka. Eno uisa ibake i borosiri yaisina durame anisake oraara okoroma bibi ukake kunaro isare imu iseake feaka. ");
INSERT INTO aby_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I borosiri yawokeibisa orouma i uisabai ekake goiro durame anaadae i goi orou yaisinabairo ibai ane wayai weisaro nauisa. ");
INSERT INTO aby_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","I goi orouma ibai nauisake efisane anisa. Ane Yesubairo i seidaninu merama imumu meisake anisa mi, dawae awara irauaiai uiro wau runike yaure ibiro ekake ia sirie. ");
INSERT INTO aby_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ibai ekake i seidaninu merama imumuini borosirinu uisa ibai eka orouma i awoena faka orou ibai yaisina weisaro nauisa. ");
INSERT INTO aby_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","I Gerasi orou yaisina ia daiwere iyakake Yesubake eno weisa, iyanu orofa mediake imusu ania weisaba ibake Yesuma boudiro anifine ane amui. ");
INSERT INTO aby_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ane amuibaie i seidaninu merama imumu me sini mima nono wei, naini anifu weibaie Yesuma meya weike wei, anu goiro aniake Godima abake imukari daiwere ukinu ibai yaisina wearo naufisa wei. Eno weiro i mima anike i goiro eme yaisinabairo Yesuma dawa ma wiroi ibai yaisina weiro nauisa. ");
INSERT INTO aby_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesuma nono owerike Gareri enaro nono ani. Eme keuwere Yesu koro ukeibisabaie Yesu idua fariro Yesubake arie wake weisa. ");
INSERT INTO aby_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Moi mi danu ibiye Dairasi, dawae moi Du orounu sosi uwara yawokeibi mi. Dawama Yesubairo farike Yesunu umu udiro iboo yanakaisari ui. I minu arumanaku una demuiba dawa arama uike feafine ukeibiro ibake Yesubairo farike eno wei, nanu uwararo aara wei. Eno weiro Yesuma i mi Danu uwararo ani. Aneibibaie eme keuwere Danu umuro enare waiyakake anisa. ");
INSERT INTO aby_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","I aneibisa ubarenaro moi aweka dawaini iini ani. I aweka dawae arama daiwere uike ibaada iwa mane dore aineibi. Oya duero (12) iwa mane doraada i arama ma wirokeka oroubairo anaada danu oi yaisina sianeibiroma danu arama irau sine dakeibi. ");
INSERT INTO aby_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I awekama Yesunu dubuenaro farike Danu wau barunaro ure buribaie danu iwa doreibi ibai idua di kuuri. ");
INSERT INTO aby_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eno uiro Yesuma wei, ainama Na ure burinara wei? Eno weibaie i eme yaisinama iyae iwoka meya weisa. Eno weisaro Fidama eno wei, Dai Waria Mi, eme keuwere Anu umuro enare waiyare aaraisa iro ea wei. ");
INSERT INTO aby_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eno weiro Yesuma wei, ainama Na ure burinara ari. Nanu buna Nabairoma dawabairo ainuro Na karanea wei. ");
INSERT INTO aby_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yesuma eno weibake i awekama we imui, Dawae iwoka ukakua we imukadae ia daiwere sinike iura mamaada Yesubairo farike iboo yanakaisari ukaada danu arama irau sini ena wake idua i oroubairo weike eno wei, nae Dawa ure burinero nanu iwa dorakuneibai idua di kuurinua wei. ");
INSERT INTO aby_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eno weiro Yesuma ma owerike eno wei, aruma ama Na imukeka imukae daiwere ibake wirokinua weike nono wei, aniake me irauaiai ibia wei. ");
INSERT INTO aby_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuma eno weibaie moi mima Dairasinu uwararoma emuabairo farike Dairasibake eno wei, anu aruma fearinua Sisa Mibairo wake goro da wea wei. ");
INSERT INTO aby_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eno weiro Yesuma nauike Dairasibake eno wei, ia da siake imukenewaa uaro dawa wirofi wei. ");
INSERT INTO aby_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dairasinu uwararo ane fakake Yesuma i orou yaisina medirieke Fidaini Dionini Deimisini i arumanu amae babaeini emua i uwara ubarenaro waure amurie. ");
INSERT INTO aby_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Waure amukada nauibaie uwara ubarenaro yaure ibisa orouma sorara ukeibisaro nauike eno wei, ii da weawe. I aruma feare mero nauka kunawere aine ibinua wei. ");
INSERT INTO aby_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yesuma eno wei ibaibake i orouma yo weisa. I aruma dawae fearinuba nono da uyafekua weisake ibake yo weibisa. ");
INSERT INTO aby_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesuma i arumanu wanaro munike eno wei, arumanaku uyaa wei. ");
INSERT INTO aby_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Yesuma eno weibaie i ai dai sineibi arumanakuba idua imu sianada iroma uyari. Uyariro Yesuma eno wei, uruna dawa maaro ifi weiro danu amae babaema imuka foria uisi. Uisiro Yesuma emuabake nono wei, eme moibairo i wake da weawa wei. ");
INSERT INTO aby_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Moi odoro Yesuma weiro Danu iwoka ukeka orou duero (12) Dawabairo fake. Dawabairo fakaro emuama seidaninu merama imumu we yowefisake imusu imusu arama uke ibeka orou ma wirofiakane ibake emuabairo buna marie. ");
INSERT INTO aby_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I iwoka ukeka orou buna marieke eno wei, aniaweke Godinu yawokaku orofa irau wake weaweke imusu imusu arama uke ibinisa orou ma wiroyakawe wei. ");
INSERT INTO aby_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nono waure aneka eraerabusa da muawe. Urini yoakeini urunaini oini moi wauini da mune aniawe wei. ");
INSERT INTO aby_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Moi goiro fafoisake moi uwara ubarenaro amufoisake ibaada yanu wake i goi oroubairo we me sifoisake anifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eno uforo abo goi orouma ya da mufiakaisake yanu wake da naufeisaie yanu derena emua mayakaweke yanu umuro doo maisuawero efisake iya medimisane ukaisaya we imufisaro aniawe wei. Eno uawero Godima emua da mufiaku ibai emua iwoka ufisa wei. ");
INSERT INTO aby_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesuma eno weibake anisa. I goi goiro anaada Godinu irau wake weibisake i imusu imusu arama uke ibeibisa orou ma wirokeibirieka. ");
INSERT INTO aby_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodi, i gaemani orou yawokeibirie dai mima Yesunu ukeibi sineibi ibai nauike ma nuna ui. Eno uiro moi orouma eno weisa, Dionima fearike nono uyaria weisa. ");
INSERT INTO aby_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nono moi orouma eno weisa, Iraida dawama fearike nono uyariba ibake owere farinua weisaro nono moi oroumae adinaro we bou uisa mima idua farinua weisa. ");
INSERT INTO aby_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eno weibisaro Erodima nauike ma nuna ukaada eno wei, Dioninu nodo nama umane kuurebairo nono ainama i ari eno buna ukakuro naukakune wei? Eno weike Yesu efine yodia uke ani. ");
INSERT INTO aby_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesunu afasoro orouma owekake aare Yesubairo fakake emenu goi goiro ukeibisa ibai yaisina weisa. I wake we me sikaro Yesuma Danu afasoro orou we murieke Besaida goiro waure anirie. ");
INSERT INTO aby_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","I fare ku siane ibisa orouma Danu anifine wei wake nauisake Danu umuro yowere anisa. Ane fakaro Yesuma emuabake arie wake weike Godinu irau yawokaku orofa wake emuabairo weike i arama uke ibisa orou ma wiromirie. ");
INSERT INTO aby_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dumudumu sineibibaie Danu iwoka ukeka orouma Dawabairo fakake eno weisa, wearo i fare ku siane yaure ibinisa orou goiro anifisa weisake nono weisa, uruna aboro mune ifeisa awaya anifisa wea weisa. Yewadake goini sidowaini meya weisa. ");
INSERT INTO aby_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eno weisaro Yesuma emuabake ma owerike eno wei, i orou uruna mayakawero ifisa wei. Yesuma eno weiro emuama weisa, iyabairo buredi faini (5) adua abu kai raaranakuyai mane ibinua eno weisa. Anifeke i oroubake uruna oima make mufene ibake weaku weisa? ");
INSERT INTO aby_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","I orou keuwerero nono emeakabai mane fai dausini (5000) iro ibisaba nono Yesuma Danu iwoka ukeka oroubake eno wei, i orou fifidi (50) fifidi (50) weawero kuku uke yaure anifisa wei. Enaenari weisaro yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Danu wei enaenari uke yaure ibisaro Yesuma i buredi faini (5) adua abu kaiyaini munike Godibairo we ma irauaiai ukaada guriguri uike ma birabira yarike Danu iwoka ukeka oroubairo mariero i kuku uke ibisa oroubairo naka naka uisa. ");
INSERT INTO aby_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Naka naka uisaro mune isaro boana urie. Ise me sikaro iuwabai mukake bosearo youisa. Bosearo youisaro bosea duero (12) wake faka. ");
INSERT INTO aby_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Moi odonaku Yesu Danu mane ibaada guriguri ukeibi. Guriguri ukeibiro Danu iwoka ukeka orou mane Dawa ubiubinaku yaure ibisa. Yesuma guriguri uke me sinike Danu oroubairo eno wei, emema Nabake ainadei weaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eno weiro ma owekake eno weisa, moi oroumae Abake Dioni babadaido miya weaisaro nono moi orouma Ae Iraidaya weaisaro nono moi orouma Ae moi adinaro we bou ukeka miro fearikema nono uyarinuke farinua eno weaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eno weisaro Yesuma emuabake ma owerike eno wei, nono yadeie, Nabake aneaneme weaisa wei? Eno weiro Fidama wei, Ae Godinu Kerisoya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Fidama eno weiro Yesuma wei, i wenu wakeye baya weike wei, i Ba Eme Sini Mima oferi daiwere waufekuro i Du dai orouini ofereni ode sibore sianeka orouini i Mosesinu darawadu we ma iwoka ukaisa orouini emuama Danu wake da naufeisaro Dawa ma fafeisaro odo buuba me sifekuro Dawa nono uyafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuma i ku siane ibisa orou yaisinabake eno wei, ainama Nanu umuro aafine ufekuie danu arara ukeka yaisina medifike Nanu arara ukeka mane korosi ari munaada Nanu umuro aafie wei. ");
INSERT INTO aby_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yesuma eno weike nono wei, moi mima danu ararae yewa orofaro mane me ibifine ufekuie idua me sara feafekuke fanisi ufekua wei. Nono ainama Nabake feafekuie dawa idua wirofekuke me ibene ibene ibeifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ainama yewa orofa akakaro eraerabusa yaisina mufekuke danu imuka ino da wirofekuke feafekuke i merama orofaro anefekuie ba meya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nono ainama Naini Nanu wakebake maru ufekuie i Ba Eme Sini Mini Danu buna aneruini emuama Danu arakekaini Godinu dai edororo fafekuie i mibake moko maru ufeku wei. ");
INSERT INTO aby_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nanu ba wake wemauro nauawe wei, moi me ibinisa orou da feafeisake Godinu yawokaku ibai efeisakema nono dubuenaro feafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuma i wake we me sinike nono odo eida (8) me siniro Yesuma Fidaini Dionini Deimisini murieke emua we guriguri ufine oraararo amuke anisa. ");
INSERT INTO aby_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iro amuke ane fakake guriguri ukeibibaie Danu iboo naisaini wauini inanakeowere sinike edoro ari ui. ");
INSERT INTO aby_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eno uiie eme una raarayai me ari uke fakike Yesubairo wake weisi. Mosesini Iraidaini emuama Godinu arakekaro fakike Godinu arara Yesu Derusaremu goiro feafeku ena wake Dawabairo weisi. ");
INSERT INTO aby_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fidaini i miyaima nauka kunawere aine ibaada nauke dauisakema nono uyakake Yesunu arakekaini nono Yesuini demuiro enare ibisi miyai erieka. ");
INSERT INTO aby_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mosesini Iraidaini emuama Yesu meisike aneibisibaie Fidama Yesubake eno wei, Dai Waria Mi, iyanu yewado ibekae irauaiaiba okoa uwarananaku kai buuba ma enafeisiie weike nono wei, moiye Anu, moiye Mosesinu, Moiye Iraidanu eno ma enafeisia wei. Danu imukekae gienabu me ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fidama eno weibaie ouma farike emua ma yaariero ia sirie. ");
INSERT INTO aby_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ou ubarenaroma wake isare aarike eno wei, yewae Nanu Amara ubi, Nama Dawa we mune odea Danu wake naukeibiawe wei. ");
INSERT INTO aby_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I wake eno weiro ekabaie Yesu Danu mane enare ibiro eka. Ibake i odoro emebairo i wakeini i ekabaini we dauisa. ");
INSERT INTO aby_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Moi odo i oraararoma isare aakaro nono i odoro eme keuwere Yesu fou uka. ");
INSERT INTO aby_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Moi mima i ku siane ibisa kuroma daiwere eno wei, Sisa mi, nanu amara ubiro moibai mero dawa manea imukari ukenewaa ua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moi odo odoro seidaninu merama imumuma nanu amaranu imuka ubarenaro isarakuro arua weakua wei. I seidaninu merama imumuma nanu amara ma birubiru ukakuro bebekuro begiri farakuro nono i seidaninu merama imumuma dawa mede dakakuke uraakua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eno ukakuba ibake Anu iwoka ukeka oroubairo i seidaninu merama imumu we yowefisane eenu wenero emuama i seidaninu merama imumu we yowere dakisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","I mima eno weiro Yesuma wei, ya Godi imuke dakaada meomao ukaisa orou. Yabairo odo abea ibimauro imufoisa wei? Yesuma eno weike wei, anu amara waure aara wei. ");
INSERT INTO aby_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eno weiro i amaranaku waure aariro i seidaninu merama imumuma ma birubiru uke mune sianiro i amaranaku isare uri. Yesuma i seidaninu merama imumubake buna wake weike i amaranaku ma wiroike danu babaebairo mai. ");
INSERT INTO aby_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yesuma eno uiro i orouma ekake Godinu bunabake imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","I orouma imuka foria uisaro Yesuma Danu iwoka ukeka oroubake eno wei, Nanu wake naukenewaa uawe wei. Godima da we kuufekuro Na moi orounu wanaro mame odifokaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yesuma eno weiro Danu wei wake ma nuna uisa. Emua iwoka unao ufeisaba ibake Godima emenu imukeka daaba dadau ui. Ibake i orouma ia sinaada i wakenu ubi adaada we nauke ere dauisa. ");
INSERT INTO aby_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesunu iwoka ukeka orouma bebekuma wake we makanada eno weisa, iyabairo abo mima daiwere? ");
INSERT INTO aby_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yesuma emenu weibisa ibai iwoka uike moi amaranaku munike Danu aroro ma yaure odike emuabairo eno wei, ainama yewa amaranaku ari Nanu ibiro mufekuie Naini iini mufarakua wei. Nono ainama Na we mufarakuie Na we odaikara Godini we mufekua wei. Ainama yabairo okoanaku sifekuie dawa daiwereya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dionima Yesubake eno wei, Dai Waria Mi, moi mima Anu ibiro seidaninu merama imumu we yowereibiro ekikema nono dawae Anu iwoka ukeka mi meba ibake i ukeibibai media weisia wei. ");
INSERT INTO aby_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Eno weiro Yesuma wei, mediawe da weawe wei. Ainama yaini wasai uke dakakuie ya unu korakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesunu urero amuke aneka odo fafine uiba ibake Yesuma Derusaremu goiro gienabu anifine ui. ");
INSERT INTO aby_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesuma moi Samaria goiro Danu aineka koru uke bou ufisa orou we odairiero anisa. ");
INSERT INTO aby_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ane fakabaie i Samaria orouma Yesu emenu goiro Dawa ainekabai emua arara da sirie. Yesuma Derusaremu goiro anifine ui ibake emua arara me Dawa fareroma emenu goiro aineka. ");
INSERT INTO aby_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesunu iwoka ukeka miyai Deimisini, Dionini emuama i wake nauisike Yesubairo eno weisi, Dai Waria Mi, i wake wefuro ureroma inaa isare aafekuke emua yare me sifiakua eno wefukuba me weisi? ");
INSERT INTO aby_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Eno weisiro Yesuma emuabake bunawereroma wake eno wei, i weaisibai mediawa wei. Eno weiro i goi mesiake moi goiro anisa. ");
INSERT INTO aby_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","I daabaro aneibisabaie moi mima Yesubake eno wei, A aboro aboro anifakuie naini Anu umuro aamaua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Eno weiro Yesuma wei, i nauwa abu emuae emenu uwara boboro nono i gasira emua emenu mowa boboro nono i Ba Eme Sini Mi, Danu aineka orofae meya wei. ");
INSERT INTO aby_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuma eno weike moi mibake nono wei, ae Nanu umuro aara weiro nono i mima eno wei, Dai Waria Mi, nanu babae feafekuro ooru uke odimaukema nono dubuenaroma Anu umuro aamaua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eno weibaie Yesuma wei, eno meya awoena Nanu umuro aara wei. Nanu umuro aare dakaisa orouma Nanu umuro aare mero me sara fearaisa orou ooru uke odifiakane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yesuma eno weike i mibake nono wei, ae aniake Godinu yawokaku irau wake we enereibia wei. Nono moi mima Yesubake eno wei, nanu uwararo ibinisa orou yaisinaba ibake arie wake wemauke emua medimiauke Anu umuro aamaua wei. ");
INSERT INTO aby_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Eno weiro Yesuma ma owerike eno wei, ainama Nanu waiya munakuke nono danu awararo arara ukeka imukada Nanu waiya medakuie owerakuke i mi dawae irauaiai mi meba ibake Godima dawa yawoke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Moi odo Yesuma sewenidi (70) eme emuako we odaifiaro anifisaro nono Dawa dubuenaro Godinu wake we anifine ibake emua we mune odirie. Emua una raara raara Danu anifine wei goi goiroma Danu anifine wei oroorofaro we odaifiane ibake we mune odirieke emua we odairie. ");
INSERT INTO aby_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Emua we mune odirieke i Godinu wake weeka oroue keu meya we imukada ibake yewa wake emuabake eno wei, i daunaisa urunama keuwerero nono i daunaisa oroue keu meya i waiya ubi mibairo guriguri uawero eme moi emua unu kofiakaro we odaifiaro anifisa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","I buna me mamoe weaisa abu ari emuama i waawere nauwa kuabairo anaisa i ari Nama ya aboro aboro we odaimiaro aniawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aniaweke fausini yoakeini moi sadoroini da wauaweke eme moi daabaro fou ufiakaisaie arie weada wake yafawere da weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Anifoisake moi uwara ubarenaro amufoisaie i oroubairo kawama wake eno weawe, Godima ya yaisinabairo aine wai ure ibeifi eno weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eno wefoisaro i uwararo irau mi ibifekuie yanu we ma irauaiai ukeka dawabairo ibifi nono mebaie yanu we ma irauaiai ukeka nono owefike yabairo ibifi wei. ");
INSERT INTO aby_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yae Godinu waiya orouba abo uwara ubarenaro amufoisaie i uwara onarounu urunaini aduaini me ifoisaya moi uwara uwararo da aniawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Abo goiro anifoisaie i goi orouma ya mufiakaisake aneme uruna mafiakaisaie iawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I goiro arama uke ibifeisa orou ma wiroaweke Godima eme yawokakune dubuena kai odo idua fafine ukinua eno weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Nono moi goiro anifoisaro i goi orouma ya medifiakaisaie daabaro anaada eno weawe, yanu goi doo iyanu umuro ma isurada medifeisiro efoisaie Godima eme yawokakune dubuena kai odo idua fafine ukinua eno weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesuma eno weike nono wei, Godinu kodo ufine odo idua fafekuro Godima i Sodomu goi meramawere ukeibisa orou ya fanisi dai menaku mafiakuke nono i arie eno ya uke yafiakaisa orou emua fanisi daiwere mafiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesuma bunawere wakeroma eno wei, ya Korasani goi orouini Besaida goi orouini ya eforo weakune wei! Godinu buna ukeka keuwere ya ereibaisaba i Daira goi orouini Saidoni goi orouini emuama ibai efisaronae meramawere wauma barufisake uka iiri okoro kafisake emenu ba me merama ukeka medifisane wei. ");
INSERT INTO aby_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Godinu kodo ureka odo fafekuro Godima i Daira goi orouini Saidoni goi orouini emua fanisi dai menaku mafiakuke nono ya Korasani goi orouini nono ya Besaida goi orouini yae yanu merama ukeka mede dakaisaba fanisi daiwere mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yesuma eno weike nono wei, ya Kafenamu goi orou yabake aneaneme wemau? Urero amuke anifone weaisa? Yae urero da waure amuke anifiakuke ya mune siafiakuro i feare dakaku inaaro anifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesuma weike Danu iwoka ukeka oroubake eno wei, Aina ainama yanu wake naufeisaie Nanu wake naufeisaya wei. Nono aina ainama ya medifiakaisaie Na we odaikara Godi medifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nono dubuenaro i sewenidi (70) orouma owekake rooro bobo Yesubairo fakake eno weisa, Dai Waria Mi, Anu ibiro weisiro i seidaninu merama imumuma iyanu wake nauisake anisaya weisa. ");
INSERT INTO aby_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eno weisaro Yesuma emuabake eno wei, i ukeibisaie bida mamaku i arie seidanima ureroma isare uriro erea wei. ");
INSERT INTO aby_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yesuma eno weike nono wei, yabake weakune ibake buna ufoisake waruini auwa ari rabunu duboro amune adiadi yare anifoke yaini wasai ukaku minu buna ma bereforo anemema ya da ma merama ufiaku wei. ");
INSERT INTO aby_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","I seidaninu merama imumuma yanu wake naukaisa. Yewabake rooro da uaweke yanu ibi urero owaowa yanake odiro ibinua rooro uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I odoro Godinu Imumu Irauma Yesunu imuka ubarenaro wake fariro rooro uike guriguri ukaada eno wei, Babae, Ae ureini dooini yawokaku. Ae yewa orounu ukeka yaisina i orofa akakaro iwoka daiwere oroubairo ma fe yarakuke nono yewa amarananaku ari orou emuabairo ma boroo yarakuro ibake we ma irauaiai ukakune. Ie Anu irau imukeka ibake eno ukaku. ");
INSERT INTO aby_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nanu Babaema Danu imukeka yaisina makakunararo enaenari ukakune. Enoroma i orouma Nanu Babaenu Amara ma nuna ukaisaro Godi Danu mane Dawa iwoka ukaku. Enaenari Godi ma nuna ukaisaro Godinu Amarama Godi iwoka ukakuke ainabairo ma boroo yarakuie emua idua Godi iwoka ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesuma Danu iwoka ukeka orou owere eraada emua manebake weada eno wei, yae aneaneme ukeibisarabai ereibisaba yae irau oroua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nanu wake wemaro nauawe Yesuma eno weike wei, Godinu moi we bou urie orouini moi dai yawokeka orouini emuama yanu aneme aneme eraisa ibai efisane weisakema nono ere dauisa. Yanu naukaisa wake naufisane uisakema nono nauke dauisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moi odoro Mosesinu darawadu we ma iwoka ukeibi mima uyarike Yesu uke iruke efine ukaada eno wei, Sisa mi, aneaneme umauke me ibene ibene ibeka mumau wei? ");
INSERT INTO aby_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Eno weiro Yesuma wei, Mosesinu darawaduma ibai aneaneme weaku. Ibaide a iwokaba me wei? ");
INSERT INTO aby_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eno weiro i mima eno wei, Mosesinu darawaduma eno weaku, yanu imuka yaisinaini imumu yaisinaini buna yaisinaini awara yaisinaini ima Godi imukari ukenewaa ukeibiaweke yanu onaroubake imukari ukaisari i ari enaenari yanu naiyemukubake imukari ukeibiawe weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Eno weiro Yesuma wei, ba weakua enaenari ufakuie me ibene ibene ibifakua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eno weiro i mima danu onami ma irauaiai ufine ukaada eno wei, nanu naiyeye aina wei? ");
INSERT INTO aby_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eno weiro Yesuma wei, moi Du mima Derusaremu goiroma Deriko goiro isare ani. Isare aneibibaie moi waira ukeka orouma fakake danu wauini oini yaisina mukake usima ureebe oisaro yanake kuurike aine ibi. ");
INSERT INTO aby_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aine ibiro moi ofereni ode sibore sianeka mima i daabaro isare aneebe eribaie i mi dawa yanake kuurike aine ibiro erike moi ena daaba udiro umane kaike ani. ");
INSERT INTO aby_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nono moi Du orounu bisara ukeka mi Riwai weaisa mima isare aneebe erike enaenari ui. Dawae i mi aine ibiro erike daaba moi enaro umane kaike isare ani. ");
INSERT INTO aby_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nono moi miye imusu goi mi dawae Samaria goi mima daabaro isare aneebe fare eribaie imukari ui. ");
INSERT INTO aby_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Imukari uike i mibairo ane ifoma kodudu yanaike iraa i minu bouro odike badesima waiyare odi. Eno uike i mi mune danu doniki abu duboro ma yaure odike waure ani. Anike awawa orou fareka uwararo farike i mi yawokenewaa uke aini. ");
INSERT INTO aby_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yawoke ainiro wai uriro uyarike i awawa orou fareka uwara yawokeibi mi du kina (K2.00) maike eno wei, i mi yawokenewaa ukeibiaro owemake famaro oi moi dawabake siafakuie anu oi moko mamauanea wei. ");
INSERT INTO aby_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesuma i wake eno weike i Mosesinu darawadu Sisa mibake eno wei, i eme una buubama i waira ukeka orouma uka mi ekade abo mima danu naiye wei? ");
INSERT INTO aby_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eno weiro Yesubake ma owerike eno wei, i imukari ui miya wei. Eno weibaie Yesuma i mibake eno wei, aniake i minu ukeka enaenari ua wei. ");
INSERT INTO aby_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuini Danu iwoka ukeka orouini aneebe moi goiro fakabaie moi aweka danu ibiye Mada dawama we kuuri. ");
INSERT INTO aby_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I aruma danu dakaeye Meri. Merima Yesunu umu udiro yaure ibaada Yesu we ma iwoka ukeibibai naukeibi. ");
INSERT INTO aby_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Madae okea oukada imukeka imusu imusu imuike Yesubairo farike eno wei, Dai Mi, nanu kakae na medinararo okea nanu mane oukakunea Ama ibai imukakuba me weike nono wei, wearo na unu kofari wei. ");
INSERT INTO aby_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Eno weiro Yesuma wei, Mada ae aneaneme imukada imuka merama imukaku wei. ");
INSERT INTO aby_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anu imuka demui mane imufakuie irauaiai ufaku. Merima Nanu wake naukenewaa ukakuie irauaiai ukakuba ie da mareke mumaua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Moi odoro Yesuma guriguri ui. Guriguri uke me siniro Danu moi iwoka ukeka mima eno wei, Dai Wari Mi, Dionima danu iwoka ukeka orou guriguri we ma iwoka urie, enaenari iya we ma iwoka ua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eno weiro Yesuma emuabake ma owerike eno wei, guriguri ukaadae eno weawe, Babae Anu ibi we ma irauaiai ukaisi. Anu yawokaku odo fafine weaisi. ");
INSERT INTO aby_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Awoenae iyanu aine wai ure makeibaku uruna maa. ");
INSERT INTO aby_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iyanu naiyemukunu ba me ukeka iyabairo ukaisa ibaie imuke medaisi enaenari iyanu ba me ukeka imuke media. I merama uke ereka eraerabusa iyabairo da waure aarake i merama ukekabairoma iya imusu waure ania. ");
INSERT INTO aby_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Eno weike nono wei, ainama danu naiyebairo dumu abanaro anifekuke eno wefeku, nanu naiye eneebe dumuro farinuro nabairo uruna meya kau kai buuba maina eno wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eno wefekuro nono i aine ibifeku mima eno wefeku, wake goro mediake ania. Nae nanu aweka amarakuini nauka aine ibinisiba da uyamauke uruna da mamauanea wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nanu wake nauawe. I mi dawae nanu naiye weroma uyare da ufekua wei. I mima aisamero enare ibaada areare weifekuro nauka aifine uke awafekuke uyafekuke uruna mafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","I ari enoya we nauke eawero mafiro muawe. Yodia uaweke fou uawe. Aisamero goi goi ukaada yaure ibinu weawero ko ma ro yafi wei. ");
INSERT INTO aby_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ainama we nauke efekuie mafekuro mufeku. Nono ainama yodia ufekuie fou ufeku. Nono ainama aisamero goi goi ukaada yaure ibinu wefekuie ko ma ro yafeku wei. ");
INSERT INTO aby_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Moi amaranakuma adua abubake we nauke efekuie danu babaema waru mafeku? Me eno da ufekua weike nono wei, O kokoroko urimibake we nauke efekuro aua mafeku? Me eno da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ya merama oroue yanu amarakubake irau uruna makakunekaba aina ainama we nauke efeisaie iyanu urero ibinu Babaema Danu Imumu Irau emuabake makenewaa ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Moi odoro seidaninu merama imumuma moi minu imuka ubarenaro ibiba ibake i mi dawa wake we dakeibi. Yesuma i merama imumu we berairo fare aniro i mi wake wei. Yesuma eno uiro ibai eka orouma imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Moi orouma eno weisa, Dawabairo Biesabo ibinu. Biesabo dawae i dai merama imumu enoba i merama imumunu bunaroma i seidaninu merama imumu we berakakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nono moi orouma Yesu uke iruke efisane ukaada eno weisa, Godinu buna uaro ureroma fafiro efe weisa. ");
INSERT INTO aby_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Eno weibisaro Yesuma emenu imukeka iwoka uike emuabake eno wei, gaemini orou emenu emenu uranada ku raarayai ufeisaie emenu yawokeka daaba idua merama sifekua wei. Enaenari moi uwara demui orou emenu emenu uranada abanaro ma boroo yareroma imusu imusu enafeisake urafeisaie emenu ibeka idua merama sifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nono seidaninu orou emenu emenu urafeisa ide aneaneme yewa orofa yawofeisa? Yae meo weaisa, Biesaboma Na buna makarabake i seidaninu merama imumu we berakakune eno meo weaisaba ibake yewa wake yabairo eno weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eno ukakune ide yanu orouma i seidaninu merama imumu ainanu ibiro we berakaisa? Enoroma i orouma ya kodo ufeisake yae meo weaisaya wefeisa wei. ");
INSERT INTO aby_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nono Godinu Imumu Iraunu bunaroma seidaninu merama imumu we berakuneie Godima eme idua yawokaku ibai yabairo iduama boroo yarakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Moi aurini goreini fidini i eraerabusa bobo mi dawae danu uwara yawokakuba ibake danu uwaraini eraerabusaini yaisina irauaiai ibaakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nono moi buna daiwere mima fafekuie urafisisike i minu biraini uraneka eraerabusa mufekuke danu eraerabusa mune anifekuke naka naka ufeku wei. ");
INSERT INTO aby_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ainama Na unu kore dakakunarake Naini wasai wake weaku. Enaenari ainama eme mune Naini ku uke dakakuie i eme Nabairoma we yowerakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Seidaninu moi merama imuma moi mi medakuie yao nauwaro ko yafine yodia uke anaku. Yodia ukeebe ko yareka orofa mebake ko yare dakakuke eno weaku, nanu medineke aane uwararo nono owere animaua weaku. ");
INSERT INTO aby_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","26","I seidaninu merama imumuma ane farakuke erakubaie i mi dawae danu imuka yawewe uraisari moi imumu iro ibe dakakubake i seidaninu merama imumuma anakuke seidaninu moi merama imumu seweni (7) dawa ari eno me, emuae dai meramawere we waure anaku. Anakuro faraisake i minu imuka ubarenaro amukaisake idua ibaisa. Ibake i minu adina ibeka meramae dai menakuro nono awoena i seidaninu merama imumu keuwere fare ibaisa ibake danu ibekae dai meramawereya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuma eno weiro i ku siane ibisa orounu kuro enare ibi moi aweka unama eno wei, Ae Anu amaema A doiyaike ama iduda maiyaiba Godima Anu amae we ma irauaiai ukakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Eno weiro Yesuma ma owerike eno wei, ba weakuroma nono aina ainama Godinu wake nauke imuke ukaisaie Godima emua ma irauaiai ukenewaa ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eme keuwere Yesubairo fareibisabaie Yesuma uyarike eno wei, yewa awoena ibinisa oroue meramawere. Aine wai ure Nama buna umaro efisane yodia ukaada ibaisa. Dionanu buna ukeka ma boroo yariro ekaba yabairo moi imusu buna ukeka da ma boroo yafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dionama Ninewe goiro Godinu wake weiro naukake Godima dawa we odairo fari eno iwoka uisa. Enaenari I Ba Eme Sini Mi ya awoena ibinisa orouma efoisake Dawae Godima we odairo farinua iwoka sifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Godinu kodo odo fafekuro Siba orofa yawokeibi aweka, emenu kuinima uyafekuke yewa orou wayai wefekuke emua aya mafiaku. Adinami nauwaro i aweka dawama yafawereroma Soromoninu iwoka daiwere wake naufine ibake Soromonibairo aare fari. Nono Soromoni dawae dai mi me. Nono awoena moi mi Dawae Dai Miwere yabairo ibinuro Dawa medaisaba ibake i odoro i awekama yabake wayai wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","I kodo odoro i Ninewe goi orouma uyafeisake yewa orou wayai wefeisake aya mafiakaisa. Dionama wake weibiba ibake emenu merama merama ukeka imuke meisa. Nono awoenae moi Mi Dawae daiwerero nono Dionae okoanaku. I dai mi Dawae yabairo ibinuro ere medaisaba ibake I Ninewe goi orouma wayai wefeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ainama ramefa biafekuie fe da odifekuke aiso odeka orofaro odifekuro i fafeisa orou yaisina i edoro efeisa. ");
INSERT INTO aby_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yanu naisae yanu ofe ubunu edoro. Enoba yanu naisama irau erabusa eraisake irauaiai imukaisa. Ie yanu ofe ubu ubarenaro edorowere ibinu. Yanu naisama merama erabusa eraisake merama imukaisa. Ie yanu ofe ubu ubarenaro dumuwere ibinu. ");
INSERT INTO aby_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Enoba erenewaa uforo yanu edoro dumu sinao ufekuba. Yanu imuka ubarenaro edoro daiwere ufekuro dumu me ie yanu ofe edoro ari ufeku, ramefanu edoro ariya Yesuma eno wei. Yesuma iyanu imukeka imusu imusu ibake dubu waure wei wake eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuma eno we me siniro moi Ferosi mima eno wei, nanu uwararo aarake uruna ia wei. Eno weiba ibake Yesuma ane uwara ubarenaro amuike uruna ifine yauri. ");
INSERT INTO aby_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","I Ferosi mima eribaie Yesuma wana uroke dauiro i Ferosi orou emenu bisaraba Dawama eno wana uroke dauiro ibake i Ferosi mi imuka foria ui. ");
INSERT INTO aby_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesuma dawabake eno wei, ya Fesosi orouma i faniginini naberoini urokenewaa ukaisakema nono yanu imuka ubarenaro imukeka meramawere, moi orounu eraerabusa mufone imukama imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yae ba awara me. Godima emenu dubo ofeini imuka ubareroini yaisina ubu uiba me wei? ");
INSERT INTO aby_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","I faniginini naberoro ibinu uruna i eraerabusa me oroubake naka naka ufoisaie yanu imuka amearubu ufekuro me irauaiai ibifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ya Fesosi orou ya erenewaa uforo wei. Yae waiyaro eraerabusa yaisinaini moi okoa eraerabusaini i yaisina naka naka ukaada i demuinaku daisi weisa nakanaku Godibake odenewaa uke odaisakema nono moi oroubake irauaiai uke dakaisake Godi imuke dakaisake imukari uke dakaisaya wei. Yanu daisi weaisa nakanaku odekaini Godi imukekaini imukari ukekaini i yaisina ukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ya Ferosi orou erenewaa uforo! Yae dai oroua wefisane ibake i Du orounu sosi uwara ubarenaro i irau yaureka orofa yodia ukenewaa ukaisake yauraisa enaenari yanu ararae i makediro enaisa orouma yabake iifa ukaada arie wefisane ibake iro anaisa. Eno ukaisake rooro ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Erenewaa uforo! Yae yewa ari! Emema ooru ukeka orofa ere dakaisaie iifa uke dakaada amune adire anaisaro ima emua ma merama ukaisa. Yae i fe yare ibeka ooru odeka orofa ari, yae eme ma merama ukaisaie emua iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuma eno weiro moi Mosesinu darawadu Sisa mima ma owerike eno wei, Sisa, eno weakuie iyabake wake merama weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eno weiro Yesuma ma owerike dawabake eno wei, ya darawadu we ma iwoka ukaisa orouini erenewaa uforo! Yae arawere darawadu wake emema mufisane weaisa. Yanu we ma iwoka ukaisa wakeye inimuwere edo aribake emema yodia daiwere ukaisaro yae wana demuima emua unu kore dakakuneka. Emenu mane wauraisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Erenewaa uforo wei. Yanu babaemukuma i we bou urieka orou ma fearieka yae enaenari imukaisake i ooru ukeka orofa ma irauaiai ukaada iro irauaiai oma odaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yanu babaemukuma i we bou urieka orou ma fearieka ibai irau weada ibake i we bou urieka orounu ooruro werei werei uke odaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yesuma eno weike nono wei, ibake Godima irauaiai imukada yabake eno wei, Nanu we bou uya orouini Nanu afasoro orouini emua we odaimiaro anifeisaro moibai ma feafiakaisake moibai ma merama ufiakaisaya Godima eno weia wei. ");
INSERT INTO aby_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yesuma i wake eno weike wei, Godinu we bou urie orou ma fearieka. I dawako odoroma i feaka orou yaisina yewa ibinisa orounu merama. Ibake Godima ya kodo ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eiboronu ma feaka odoroma Sakarayasi, dawae i ofereni odeka orofa dai sosi uwara ubarenaro ma feaka, i furoma i orou yaisinabake Godima ya fanisi mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ya Mosesinu darawadu we ma iwoka ukaisa orou ya erenewaa uforo! Yae Godinu irau imukeka emebairo ma fe yaraisa. Godinu irau imukekae uwara ari. Yae i ki ma fe yaraisake ubarenaro amuke dakaisake emenu amukeka daaba dadau ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu iroma aneibibaie i Mosesinu darawadu we ma iwoka ukeibisa orouini Ferosi orouini emuama dino daiwere ukaada we nauke ereka keuwere weisake merama wake weisa. ");
INSERT INTO aby_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Emenu ararae Yesunu moko wake wefiro naufisake Dawa kodo ufisane ibake wake daiwere weibisa. ");
INSERT INTO aby_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","I odoro eme keuwere fare ku siakake daba daba ure makane ibisaro Yesuma Danu iwoka ukeka orou emenu imusu we iifa ukaada eno wei, i Ferosi orounu ure wawareka iraa yisidi eforo wei. Ie meo ukekaya emuama eno weaisakema nono imusu dei ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Emenu oba ukeka eraerabusa yaisina ma woromifekuke emenu imukaro i fema imukaisa eraerabusa yaisinae i oba ukeka erabusa ariba i yaisina ma boroo yafekuro efeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Enoba yanu dumuro weaisa wakeye ewekaro naufeisa. Anemerabubake uwara ubarenaro mumuuroma weaisaie akaka naisaroma daiwere wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Adara, Nanu wake wemaro nauawe. I ma feareka oroubake ia da iyaawe. I orouma yanu ofe mane ma feafeisake nono yanu imumu da ma feafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ainabake ia iyafoisa? We iifa umaro naukenewaa uawe wei. Ainama yanu ofe ma feafekuke nono yanu imumu i feare dakaku inaaro siafeku Godi Dawa mane ia siawe wei. ");
INSERT INTO aby_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Emema sisimuri ada fai (5) oima make mukake korofeni kai raarayai sianaisaba Godima i gasirananaku imuke mede dakakune. ");
INSERT INTO aby_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Godima ya imukada yanu fouma idi yaisina iini kakuria ibake ia da siawe. Godima i gasirananaku imukakuke nono yabakeye daiwere imukenewaa ukakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuma moi wake eno wei, ainama eme moibairo nae Yesu imukakunea wefekuie enaenari Na i Ba Eme Sine Mima Godinu anerubairo Nae dawa iwoka ukakune wemaua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nono ainama eme moibairo nae Yesu iwoka meya wefekuie enaenari Godinu anerubairo Nae dawa iwoka meya wemaua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ainama i Ba Eme Sini Mibake wake merama wefekuie Godima danu merama wake naufekuke imuke medifeku. Nono ainama Godinu Imumu Iraubake wake meramawere wefekuie danu merama ukeka da mune imuke medifekuro idua i mi dawabairo ibeifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Moi odoro ya umu wana naama uwafiakaisake Du orounu sosi uwara ubarenaro waure fare odifiakaisa. Du orou yawokakuneka dai orouini gaemani yawokakuneka dai orouini emuabairo waure ane odifiakaisaie ia da iyaweke yanu moko weeka wake aneme aneme wefoisa i arie eno da imuforo wei, Godinu Imumu Irauma i odoro Danu imukeka mafiakuro enaenari wefoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Moi ku siane ibisa ku ubarenaroma moi mima uyarike Yesubairo eno wei, Sisa, nanu kakabairo wearo kakama babaenu eraerabusa moi naka ufike na moibai mafari wei. ");
INSERT INTO aby_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eno weiro Yesuma wei, naiye, ainama Nae anu kodo yawokeka mi odikara wei? Ainama Nae anu eraerabusa naka naka ukeka mi odikara wei? ");
INSERT INTO aby_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eforo! Moi minu eraerabusa naisa ure owere ma owere daufao! Yanu ibekae eraerabusa mane me. Aina mima danu ararae eraerabusa mane mufine ufekuie danu ibekae ba meya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eno weike dubo waure wake weike eno wei, moi eraerabusa keuwere irau doo bobo mi dawa idua yaure ibi. ");
INSERT INTO aby_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","19","I mima uyarada eno we imui, nanu waiyaro uruna keuwere ibinuro moi uruna odeka uwara meba aboro odimau ariya we imuike wei, eno umaua wei. Nanu uruna odeka uwara yaisina ma doroo yamauke awoena uruna odeka uwara daiwere ma enamauke iro nanu konouraini nanu eraerabusa yaisina iro odimauke nanu onamibake eno wemau, o naiye, nabairo eraerabusa keuwere ibinuba urunaini aduaini areare isaada rooro ukeimau eno wemaua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dawae eno weiroma nono Godima dawabake eno wei, ae awara me miya wei. Eweira dumuro ae feafakuro nono ainama i eraerabusa mufeku Godima eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesuma i wake eno weike nono wei, enaenari ainama eraerabusa keuwere munaada eno mane weibakuie Godinu ibooro i eraerabusae urero ibinisa eraerabusa ari meba dawae i awara me mi ari enoya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuma Danu iwoka ukeka oroubake eno wei, yanu ibinisa ofebake da imuawe wei. Yanu wirokekae i urunabairoma da wirofoisa. Nono yanu ofeye runeka wauma da ma wirofiakua weike nono wei i urunaini runeka wauini i mane da imuawe wei. ");
INSERT INTO aby_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yanu ibekae uruna mane iseroma ibe dakaisa. Yanu ofeye runeka erabusama runeroma ibe dakaisa. ");
INSERT INTO aby_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Enoya i owagoro ada imuke eawe. I ada emuae ana kai yo wawe dakaisake fira uke dakaisaro emuabairo uruna odeka uwara mero nono Godima emua uruna makakunea wei. Godima i ada imukakuneke nono iyae ba daiwere imukenewaa ukakunia wei. ");
INSERT INTO aby_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Enobairo nono anemebake aine wai ure yanu ibekabake imukaisa? Ainama danu ibekabake imukebe imukebema nono danu odo ma yafa da ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iduaya yewa dai me waiya da ufoisade nono anemebake i imusu eraerabusa imukaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","I isoni imuke eawe. I isoni emuae waiya uke mero emua emenu onarou rune dakaisaya wei. Soromoni weaisa mima arake ibeka wau runiro danu waue irauaiai mero nono i isoninu runie irauaiaiya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Godima i koe ma warakakuke runi fare odakuro nono waidei odoro ena koeye inaama yaraisa. Godima eno ukakuie ya Godi dai menaku imukaisa orouini ya wau rune odifiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Enoya yanu urunaini aduabake da yodia ukenewaa ukeibiaweke da imukenewaa ukeibiawe wei. ");
INSERT INTO aby_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","I orofa akaka Godinu wake nauke dakaisa orou yaisinae i urunaini adua yodia ukenewaa ukaisaro nono yanu urero ibinu Babaema yanu ibeka Dawa iwoka ukaku. ");
INSERT INTO aby_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ibake weroma yodia ukenewaa da ufoke nono Godinu irau yawokekama yodia ukenewaa uforo yanu urunaini i yaisina mafia wei. ");
INSERT INTO aby_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ya okoa mamoenanaku ari orou ia da iyawe wei. Godima Danu arara ukaada rooro bobo ya Danu yawokeibaku orofaro odia wei. ");
INSERT INTO aby_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yanu eraerabusa oima make muaweke i eraerabusa me oroubairo i oi mayakawe wei. Eno ufoisaie yanu eraerabusa urero ibene ibene ibifekua wei. Iroe waira orou me. Iroe ranema eraerabusa ma merama da ufeku wei. ");
INSERT INTO aby_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yanu eraerabusa aboro ibinisaie yanu imuka yaisinae iro ibinuba ibake wei. ");
INSERT INTO aby_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yanu wauini ramefaini mune ode bou uawe. Wau ruaweke ramefa biaweke yanu Dai Waria Mi yawoawe. Yanu Dai Waria Mi aweka muneka banauroma fafekuke yaure ibinisa wefekuie ko sabu woromiawe wei. ");
INSERT INTO aby_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","I dai mi fafekuke danu waiya orouma nauka aine dafeisake me ibifeisaro efiakuie emua we ma irauaiai ufiakua wei. Yabake ba wake wemaro nauawe wei. Eno ufekuie danu waiya ukeka orou ma yaufiakuke waiya ukeka wau rufekuke danu mane emuabairo uruna nabero mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dumu abanaro o wai awaro fafekuke emua eno uke yafiakuke we ma irauaiai ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ibai imuke eawe! I uwara onami mima i waira ukeka minu fareka odo iwoka ufironae danu uwara yawokenewaa ufineba danu uwara da fare ma merama ufine wei. ");
INSERT INTO aby_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Enaenari yawokenewaa uforo wei. I Ba Eme Sini Miye fema fafekuba ibake yawokenewaa uforo ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fidama eno wei, Dai Waria Mi, i dubo waure weaku wake iya manebake weakuba ba eme yaisinabake weaku wei? ");
INSERT INTO aby_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eno weiro Yesuma Danu iwoka ukeka oroubairo we nauke eraada eno wei, abodei mima ba irauaiai waiya derena fururu yare busi kai ukeka mi weike Danu mane nono i moko wake eno wei, i busi kai irauaiai waiya ukakuke nono oima make muneka odoroe uruna mune i moi waiya ukeibaisa orou makeibakunero iseibaisa i mi dawae irauaiai waiya ukeka miba Godima dawa yawokeka dai mi we odifekuro Godinu orou yawokeifiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eno weike nono wei. I dai yawokeka mima fafekuie danu waiya ukeifeku mi eno irauaiai ufekuro efekuke we ma irauaiai ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","46","I dai mima danu eraerabusa yaisina yawofine odifekua wei. Nono i koroko waiya ukeka mima eno we imufeku, nanu dai miye sabu da fafekua eno we imufekuke i goiro waiya ukeifeisa eme awekaini emua usima ureifiakuke uruna daiwere iseifekuke ara adua isaada awara arama ufekuie danu dai mi idua fema fafekuke i mi fanisi mafekuke i Godinu wake nauke me orounu orofaro odifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nono moi waiya ukeka miye danu dai minu imukeka iwoka ufekuke enaenari da ufekuie i dai mima i mi usima daiwere ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nono moi waiya ukeka miye danu dai minu imukeka iwoka meba ibake usima dai menaku ufeku wei. Godima ainabake iwoka daiwere mafekuke nono i ama enaenari daiwere ua wefeku. Ainama daiwere mufekuie enaenari daiwere ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuma eno wei, inaa dooro mawamane farea weike nono wei, Nanu ararae i inaama yewa doo yare me sifine weakune wei. ");
INSERT INTO aby_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Moi ara babadaido ukeka mumau inu ubiye oferi daiwere waumauba ibake awoenae imuka merama daiwere ukakune ie me sifekuro irauaiai ibimaua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aneme we imukaisa? Nae ya yewa orofa akaka oroubake me irauaiai ibeka mamiane farea eno we imukaisa? Nae ibake fare dauneke moi uwararo ibinisa orou ma fiake ku raarayai umiane farea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Awoenae moi eme fai (5) moi uwararo ibaisaie una raara emuae emenu imusu yaure ibaada imukaisiro, nono moi una buubae emenu imusu yaure ibaada imukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Moi uwararo babaeini danu amaraini emenu imusu imusu ibifisisi. Amaeini danu arumaini emenu imusu imusu ibifisisi. Dakamaeini nainauini emenu imusu imusu ibifisisi. Emenu emenu Nabake wake we makanada ibake urane rarane ufeisake fiake imusu imusu ibifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuma i fare ku siane ibisa oroubake eno wei, eweka isaraku enaro duba ou eraisake eno weaisa, awoenae obi mafekua weaisaro enaenari isaraku. ");
INSERT INTO aby_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Eka ena ewa enaroma oyau farakuie idua kowaa enaraku eno eno weaisaro enaenari kowaa sinakua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ya meomao weaisa orou! I ureini dooini eraerabusa erenewaa ukaadae iwoka ukaisake nono Godinu buna ukeka erenewaa ukaadae nono ma nuna ukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Anemebake i ba ukeka ma nuna ukaisake yanu mane ba me ukeka ma giena uke dakaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Moi mima ya moi kodo yawokeka oroubairo kodo ure yafiane wayai wefekuke waure anifiane ukeifekuie dawabake sabu naiye weada i wake yanu mane ma giena uawa wei. Eno da ufoisaie i kodo uraku dai mima yae furisimaninu wana daaro mune odifiakuro i furisimanima ya ana eboro odifiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yabake ba wake wemaro nauawe, ya ana eboro odifiakuie iro ibifoisake i faini oi yaisina mafoisaro ya idua i ana ebaroma odaifiakuro owere aweawero fafoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","I odoro moi orouma Gareri orounu ofereni odeibisa wake eno weisa, i Gareri orouma Derusaremu goiro Godibairo emenu ofereni odeibisabaie Fairadinu orouma emua ma feareibiriekaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eno weisaro Yesuma eno wei, imuke eawe, moi Gareri orou emuae meramawere orou ibake feaka, nono moi Gareri orou emua meramawere meba ibake feare dauisaya eno we imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ie ba me. Ya yaisina yanu merama merama ukeka imuke mede mero me sara feafoisake i inaa yaraaku orofaro anifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I Sairomu orounu feaka wake nauisa? Eme eidini (18) yeku yafa uwarawere omama ma enareibisaro doroo yarike i orou isare ure bauriero feakaya wei. I feaka oroue meramawere orou nono i moi Derusaremu goiro ibeibisa orou emuae merama orou meya eno we imukaisa? ");
INSERT INTO aby_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ie ba meya weakune. Ya yaisina yanu merama merama ukeka imuke mede mero me sara feafoisake i inaa yaraaku orofaro anifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuma yewa wake dubo waure emuabairo eno wei, moi mima boruba ana yobai waiyaro wawiro waiya ubi mima medike moi orofaro ani. Aniro nono dubuenaro ena boruba kaibai mufine odo keuwere fare eribaie boruba kaibai me. ");
INSERT INTO aby_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaibai meba ibake danu waiya yawokeibi mibake eno wei, oya buuba na fare ane aare ukaada erakunebaie kaibai uwane mero me ibinua uyama umaa wei. Anemebake nanu waiyaro me sara enare ibifeku wei. ");
INSERT INTO aby_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eno weiro i waiya ukeka mima ma owerike eno wei, dai mi, media, moi oya ibifiro ie yawokenewaa umauke danu iinibai udiro oorunaku daumauke boromakaunu ye waure aare odimaua wei. ");
INSERT INTO aby_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Eno umauke emauro kaibai uwafekuie da umamauro me ibifekua wei. Nono kaibai da uwafekuie ideima umamau weia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Moi sabadi odoro Yesuma Du orounu moi sosi uwara ubarenaro we ma iwoka ukeibi. ");
INSERT INTO aby_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yesuma we ma iwoka ukaada eribaie seidaninu merama imumuma moi aweka ma merama uiro oya eidini (18) ure giena uke enare dakeibike afua umane eneibiro Yesuma eri. ");
INSERT INTO aby_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","I aweka erike weiro Yesubairo fari. Yesubairo fariro Yesuma eno wei, yewa aweka, anu oferi waureka me sininuro ae wirokinua weada i aweka wanama ure buriro ure giena uke enarike Godinu ibi we ma irauaiai ui. ");
INSERT INTO aby_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eno uiba ibake i Du orounu sosi yawokeka mima dino uike eno wei, waiya ukeka odo sikisi (6) ibooro ibinuro anemebake sabadi i odoro ma wirokinu wei? ");
INSERT INTO aby_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eno weiro Yesuma dawabake ma owerike eno wei, ya meomao orou! Yae sabadi i odo odoro waiya ukaisa. Yae yanu boromakauini donikini uruna makakuneka. ");
INSERT INTO aby_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yae eno ukaisaba yewa awekae Eibaramunu sisia arumaro seidanima dawa oya eidini (18) ma merama ukeibiba ibake dawae sabadi odoro wirokinu ide irauba me wei? ");
INSERT INTO aby_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eno weiro Dawaini wasai uisa orouma maru uisaro i moi orouwere emuae Yesunu buna ukekabake rooro uisa. ");
INSERT INTO aby_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuma Godinu yawokaku orofa irau wake we ma iwoka ukaada eno wei, Godinu yawokekae aneme ari? Anemerabu ari wemau? ");
INSERT INTO aby_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Godinu yawokekae okoa masida ana kai yo ari. I yo kainaku moi mima munike danu waiyaro wawiro waraike dai anawere sini. Daiwere siniro i gasirama emenu mowa i ananu iwararo ubu uisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eno weike nono wei, Godinu yawokaku orofade aneme ari? ");
INSERT INTO aby_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Danu yawokekae yewa ari, moi awekama moi wawareka iraa yisidinaku munike i farauwa ubarenaro odiro yisidima i farauwa yaisina ma wawaria Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuma Derusaremu goiro ani. Amuke anaada i dai goini okoa goinanakuro we ma iwoka uke amuke aneibi. ");
INSERT INTO aby_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Eno uke amuke aneibiro moi mima eno wei, Dai Mi, eme keu menaku mane wirofeisaya wei? Eno weiro Yesuma wei, Godinu dai me aisamero anenewaa uaweke eawe wei. Awoenae eme keuwere i aisame yodia ukaisake ane dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","I uwara ubi mi dawako uyafekuke aisame yodia ufekuro yae dubuenaro enare ibaada Dawabake yaure ibinu wefoisake eno wefoisa, Dai Waria Mi, aisame woromiaro amufe wefoisaro dawama eno wefeku, ya orou Na iwoka mero yade aboroma farisa eno wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eno wefekuro yama wefoisa, abairo urunaini aduaini iseibisiro iyanu goiro we ma iwoka ukeibia eno wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eno wefoisaro dawama eno wefeku, yae Na iwoka meya weada, yae sara merama ukaisa oroua Nabairoma imusu aniawe wefekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eibaramuini Aisikini Deikafuini Godinu we bou ukeibirie orouini emuama Godinu yawokaku orofaro ibifeisaro efoisakema nono ya aneka daaba dadau ufekuba iro da anifoisake nio ake fagigi yafoisake ii wefoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eme keuwere eweka amukaku enaroma eweka isaraku enaroma eka ena ewa enaroma aboro aboroma fafeisake Godinu yawokaku orofaro Danu banau uruna ifisane fafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Imuke eawe. Yewa dooro moi okoanaku orouma iroe dai orou sifeisaro nono yewa dooro moi daiwere orouma iroe okoanaku orou sifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I odoro moi Ferosi orouma Yesubairo fakake eno weisa, yewadoma imusu ania. Erodima A ma feamine ukakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eno weisaro Yesuma emuabake eno wei, aniaweke yeka nauwa kua ari we irukeka mibairo eno weawe, ea, Nama i seidaninu merama imumu we berakakuneke eme ma wirokakunia. Eweiraini wairoini yainaini eno mane umauke nanu waiya uke me simaua wei. ");
INSERT INTO aby_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Godinu we bou urie orouma Derusaremu goiro mane feareibaisaba Naini iini we bou ukeka miba eweiraini wairoini yainaini Nanu waiya ukeimaua, eno ane weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Eno weike nono wei, O Derusaremu goi orou, Derusaremu goi orou, yewae Godinu we bou ukakune orou ma fearakunekake i Godinu we odaisakune orou omama urakuneka. Aweka kokorokoma danu nakubai babama oba ukakune, enaenari Nanu ararae ya Derusaremu orou yawokakuniaro nono yama Nanu yawokeka arara meya wei. ");
INSERT INTO aby_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Eawe! Godima yanu Derusaremu goi medakuba Na da ereifokoisake nono eno wefoisa, Godinu ibiro farinu mi Dawae irauaiaiya wefoisaie nono Na efokoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Moi sabadi odoro Yesuma moi Ferosi yawokeka dai minu uwararo uruna ifine ani. Ane faribaie moi umu wana wawari mi dawa idua yaure ibiro i ku siane ibisa orouma Yesu eraada i miye yewa sabadi odoro ma wirofekuba me ariya weada Yesu erenewaa ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuma i Mosesinu darawadu we ma iwoka ukeibisa orouini Ferosi orouini emuabake eno wei, Mosesinu darawaduma aneme weaku wei? Sabadi odoro ma wirokekae irauba me wei? Aneme weaku wei? ");
INSERT INTO aby_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eno weiro i orouma wake we dauisake wake muu uisa. Wake muu uisaro Yesuma i mi mune ma wiroike we odairo ani. ");
INSERT INTO aby_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesuma emuabake nono wei, yanu moi abu sabadi odoro yafa doo ebaro isafeisaie ma youfoisaro amufeisaba me wei? ");
INSERT INTO aby_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yesuma eno weiba ibake emuama Dawabairo moko wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","9","I uruna iseibisa orouma i irau orofaro yaufisane ukeibisaro Yesuma emua erieke emuabake eno wei, moi mima danu aweka muneka banauro aaraweke uruna iawe wefekuie i dawako irau orofa mufone da yodia uforo ukeebe moi dai miwere fafekuro i banau onami mima yanu orofa i mibake mafekuro yama dooro yaufoisake maru unao ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Moi minu banau ifone anifoisie eu diiriro yauawero banau ubi mima fafike eno wefi, naiye, yeka irau orofaro ane yaua wefekuie i uruna ifisa orouma yae we ma daiwere ufiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ainama danu onami ma daiwere ufekuie Godima dawa ma okoanaku ufeku. Nono ainama danu onami ma okoanaku ufekuie Godima dawa we ma daiwere ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuma i banau ubi mibake eno wei, banau ufakuie anu goi orouini eraerabusa daiwere orouini emua mane wayo da koyana. Emua mane wayo kofiakuie enaenari emuama abake moko wayo komekaisake ama emuabake ufaku ari enaenari moko ufeisaba eno da ufao wei. ");
INSERT INTO aby_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Banau ufakuie eraerabusa me orouini umu wana merama orouini umu beobeo bobo orouini naisa kikori bobo orouini emua wayo koyana wei. ");
INSERT INTO aby_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eno ufakuro i orouma ibake moko eno uke dafeisaie Godima a ma irauaiai umekuke i Godi imukaisa orou ma uyareka odoro abake moko eno ufiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuma eno weiro moi uruna ifine yaure ibi mima eno wei, ainama uruna Godinu orofaro ifekuie Godima dawa we ma irauaiai ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eno weiro Yesuma moi dubo waure wake weike dawabake ma owerike eno wei, moi odoro moi mima dai banauwere ufine ukaada eme keuwere wayo korie. ");
INSERT INTO aby_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","I banau iseka odo fariro i banau ubi mima danu waiya ukeka mi we odai. I orou wayo kofiaro fafisake danu banau ifisane ibake we odairo emuabairo ani. ");
INSERT INTO aby_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","I mi dawa anike weibaie i orou emua arara dauisa danu uruna aare iseka. Ibake emua arara dauisake moi mima eno wei, nae doo awoena oima make muneba iro animauke ere bou umauba i banauro da aamaua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","20","Nono moi mi dawae danu imukeka wake eno wei, nae boromakau deni (10) oima make muneba iro animauke ere bou umauba i banauro da aamaua eno wei. Dawae eno weiro nono moi mima eno wei, nae aweka awoena muneba i banauro da aamaua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I orouma eno mane weibisaba ibake i wayo ani mi medike danu dai mibairo owere ane farike i weisa wake enaenari yaisina dawabairo wei. Eno weiro i uwara ubi mima dino uike danu waiya ukeka mibake nono wei, i ba goiroma uwara kai deidemuroma iroma sabu aniake i eraerabusa me orouini umu wana merama orouini naisa kikori bobo orouini umu beobeo orouini emua waure aayana wei. ");
INSERT INTO aby_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eno weiba ibake i mima sabu owere anike danu wei wake enaenari uike danu dai mibairo farike eno wei, dai mi, anu wenu enaenari unero nono orofa keuwere me ibinua wei. ");
INSERT INTO aby_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eno weiro i banau ubi mima nono wei, nauwaroini waiyaroini aniake eme fou ufiakuie emenu wanaro muyanake waure aarayanaro nanu uwararo yaufisaro wake fafi wei. ");
INSERT INTO aby_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","I dawako wene oroue nanu banau da ifisane ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Yesuma daabaro ani. Daabaro aneibibaie eme keuwere Danu umuro anisa. Anisaro Yesuma emuabake eno wei, ainama Nanu iwoka ukeka mi sifine ufekuie danu amae babaeini danu aweka amarakuini danu kaka nabueini dawa danu ararae emuaba ibake emua derena da mafiakuie dawae Nanu iwoka ukeka mi da sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ainama danu arara da medifekuke irau ukeka korosi ari da waufekuie dawae irau mi meba ibake Nanu iwoka ukeka mi da sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ainama uwara ma enafine imukakuie ane yaurakuke danu oi kakufekua wei. Danu oi iduaba me ariya we imukaku. Mebaie uwara fosi mane siafekuro enaenari da sifekuke oi me sifekuba i uwara idua medifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Enoba emema i uwara ubi mi we irukada eno wefeisa, i miye uwara ma enarebe oi me sininuba medinua eno dawa we irukada wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Imuke eawe! Moi yawokeka dai kini mima moi kini mini urafisine ufekuie kawama yaufekuke danu meremere orou kakufiaku. Kakufiakuke efekuro danu meremere oroue deni dausiniro (1000) nono i moi kini minu meremere oroue keuwere duenidi dausini (2000) ibake imukenewaa ufeku. ");
INSERT INTO aby_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ie enaenari sifekuba me ari we imufeku. We imufekuro enaenari da sifekua eno we imufekuie danu fo weeka mi we odaifekuke aniake eno wea wefeku, aini dawaini demuiro yawofuane wenua ane wea wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesuma eno weike nono wei, ainama i eraerabusa yaisina derena da mafekukema nono Nanu umuro aafine ufekuro enaenari da sifekuke Nanu iwoka ukeka mi da sifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","I damenae irauaiai. I damenanu imuna me sifekuie danu imuna aneaneme i imuna ma owere odifeku? Me! ");
INSERT INTO aby_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Imuna meba i damenae irauaiai mero meramawere ibake emema mune sianaisa. Enaenarie yama irauaiai da ukeifoisaie emema yanu wefoisa wake da naukeifeisaba ibake yae i imuna me damena ari. Aina aina ya ome bobo oroue naukenewaa uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yesuma we ma iwoka ukeibibaie i dakesi oi muneka orouini merama ukeka orouini emuama danu wake naufisane faka. ");
INSERT INTO aby_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","I Ferosi orouini i Mosesinu darawadu we ma iwoka ukeibisa orouini emuama wake mumuuroma eno weisa, yewa mima i merama orouini demuiro yaure ibaada uruna isakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Eno weisaro Yesuma emuabairo dubo waure weeka wakeroma eno wei, yabairo moi mima mamoe abu yaisina wani aderedi (100) yawokeifekuro una demuinaku fe yafekuie moi nainidi naini (99) eme ibe me orofaro medifiakuke i fe yafeku mamoe una yodia ukeebe fou ufeku. Eno ufekuba me wei. ");
INSERT INTO aby_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eno weike nono wei, euwa eno ufekua wei. Dawae yodia ukeebe fou ufekuke mune owairo waurada rooro ufekuke anifeku wei. ");
INSERT INTO aby_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Goiro ane fafekuke wefekuro danu goi orouini danu naiyemukuini fafeisaro eno wefeku, nanu fe yarinu mamoe fou unea naini rooro uke yakowe wefekua wei. ");
INSERT INTO aby_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Enaenarie eme una demuima danu merama ukeka imuke medifekuie i urero ibinisa aneruma rooro daiwere ufeisake i nainidi naini (99) orou emuae irauaiai orou ibake rooro dai menaku ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesuma eno weike nono moi dubo waure wake weada eno wei, moi aweka una danu oi kaibai deniro (10) nono kai demuinaku fe yafekuie ramefa biafekuke yawewe ufekuke yodia ukenewaa ukeebe fou ufeku. Dawa eno ufekuba me? ");
INSERT INTO aby_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Euwa, dawae eno ufekuke wefekuro danu naiyemukaini moi uwara uwararo ibifeisa orouini fafeisaro eno wefeku, nanu fe yarinu oi kainaku fou unea naini rooro uke yakowe wefekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Enaenarie moi mima danu merama ukeka imuke medifekuie Godinu aneruma rooro ufeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuma moi wake dubo waure weike nono eno wei, moi mima amara una raarayai dorie. ");
INSERT INTO aby_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I dubuena dori amarama eno wei, babae, anu eraerabusa yaisina ma fiake nanubai mainaro muma wei. Danu amarama eno weiba ibake danu babaema danu amara wei enaenari ui. ");
INSERT INTO aby_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nono moi odoro i dubuena dori amarama danu eraerabusa fira ukaada munike moi orofaro ani. Dawae yafawere anike i imusu orofaro me sara ukeebe danu oi yaisina siane me sini. ");
INSERT INTO aby_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I oi me siniro i orofaro arumu daiwere yauri. ");
INSERT INTO aby_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Enoba uyarike moi mibairo waiya ufine ani. Ane farike weiro moi mima eno wei, aniake nanu borosiri yawokeibia wei. Eno weiba ena mi idua ani. ");
INSERT INTO aby_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aniro nono dawae desini daiwere uriba i boronu rau ifine imuiroma nono i orouma dawa i boronu rau make dauisa. ");
INSERT INTO aby_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Enoba i mima ane yaurike imukebe eno we imui, nanu babaenu waiya oroue keuwere ibinisake uruna daiwere isaada ibinisiro uruna moibai keuwere ibinuro nono nae desinima feamane ukakune ariya we imui. ");
INSERT INTO aby_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Awoenae uyamauke nanu babaebairo animauke eno wemaua we imui, babae, Godini aini yabairo meramawere uke yareibiaya wemaua wei. ");
INSERT INTO aby_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanu ukeka sinekae meramawerea anu waiya ukeka mi we odaina wemaua eno we imui. ");
INSERT INTO aby_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eno we imuike uyarike danu babaebairo idua ani. Uyarike daabaro aneibiro danu babaema dawa daabaro erike imukari uiba durame ane yabaike oo ui. ");
INSERT INTO aby_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","I mima eno wei, babae, Godini aini yabairo meramawere uke yareibiaya. Enoba nanu ukeka sinekae meramawereya nae anu amaraya eno da wea wei. ");
INSERT INTO aby_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Eno weiro danu babaema eno wei, nanu amarae fearefaisa ukinuke ibeebe farinua irau wauma rune odiaweke wana raragaro sia wawe odiaweke umu ofe baruke odiaweke awoena keweama imusu ari boromakau uaweke banau uawero isaada rooro ufe weiro enaenari uisa. ");
INSERT INTO aby_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nono danu bokai dori amara waiyaro anike waiya ukeebe owerike faribaie uwararo buma uraada yaura ureibisaro naui. ");
INSERT INTO aby_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nauike moi waiya ukeka mibairo we nauke erike eno wei, anemebake eno ukaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eno weibaie i waiya ukeka mima ma owerike eno wei, anu nabue farinuro anu babaema i awoena keweama imusu ari boromakau urinuro isaada rooro ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Eno weiro i mi dawae dino daiwere uike i uwararo ane daui. Dawae uwararo ane dauiba ibake danu babaema dawabairo ane farike eenu weada uwara ubarenaro aara wei. ");
INSERT INTO aby_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Eno weiro i bokai amarama dino wakeroma eno wei, oya keuwere anu waiya ukaada anu weaku wake yaisina munakuneke ukakunero anemebake awoena boromakau make dakakuniro nanu naiyemukuini naini iya iseroma rooro uke dakaisi wei. ");
INSERT INTO aby_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anu amarama anu oi fukeruwere arumabake me sara siane me sininuke owere farinuro dawabake wenuke irau awoena boromakau urinuke isaada rooro ukakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eno weiro danu babaema wei, nanu amara aini naini uwae demuiro ibinisuba nanu aneaneme eraerabusa yaisinae anua wei. ");
INSERT INTO aby_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nono anu nabueye fearefaisa ukinuke ibeebe farinuro fou uneke ibake rooro ukaisia wei. Yesuma i wake emuabake eno dubo waure wei. ");
INSERT INTO aby_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuma Danu iwoka ukeka oroubake moi wake dubo waure weada eno wei, moi mima danu dai minu eraerabusaini oini yaisina yawokeibi. Enaenari yawokeibibaie moi orouma danu dai mibairo fakake eno weisa, anu yawokeka mima anu eraerabusaini oini me sarawere yowokakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eno weisaro i dai mima danu eraerabusa yowokeibi mi weiro dawabairo ane fariro eno wei, a aneme ukakuro weisaro naune wei. Ie ba ba me wei? Anu waiyae idua me sininua aniake anu sidowa buka waure aare maina weiro ibake ani. ");
INSERT INTO aby_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Anike eno we imui, aneme umau ari we imui? Nae buna meba kare waiya da umaua eno wei. Na arara me eenu weeka. ");
INSERT INTO aby_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na imukakuneie eno umauke danu waiya medimauro nanu naiyemukuma na yawofokaisaya we imui. ");
INSERT INTO aby_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Enoroma danu dai minu oi moko mafeisa orou una deidemubake eno wei. I bokai mibake eno wei, nanu dai mi anemerabu moko mafaku wei? ");
INSERT INTO aby_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eno weibai wani aderedi (100) kerosini daramu ariya wei. Eno weiro i yawokeka mima wei, anu fefa muake mokoe fifidiya (50) eno owaowa uke odia wei. ");
INSERT INTO aby_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Eno weike nono moi mibake wei, nanu dai mibake anemerabu mafaku wei? Eno weibaie ibudi urimi fuse ari yaisina wani aderediya (100) wei. Eno weiro i yawokeka mima ma owerike dawabake eno wei, anu fefa sabu muake anu mokoe eidiya (80) eno owaowa uke odia wei. ");
INSERT INTO aby_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Eno uiba ibake danu dai yawokeka mima we imui, i uke gagao ukeka miye awara bunawereya we imui! I orofa akaka Godinu wake nauke dakaisa orou emuae i meomao ukekaroe emua iwokama imusu ariba ibake yewa dooro ibaada i Godinu edororo ibaisa orou emuae ibai iwoka dai menakuba emua ma berekakunekaya wei. ");
INSERT INTO aby_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesuma nono wei, Nanu wake wemaro nauawe wei, ibai imukada yanu yewa orofa akakaro oi irauaiai yawoaweke eme moibairo oi keuwere mayakawero yabake naiye wefisa wei. Nono dubuenaroe i oi me sifekuro feafoisaie Godima yae i me ibene ibene ibinu ure uwararo unu kofiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yesuma eno weike nono wei, ainama eraerabusa keu menaku moi mibairo makakuro yawokenewaa ukakuie eraerabusa keuwere dawabairo makakuro yawokenewaa ukakua eno wei. Nono ainama i eraerabusa keu menaku yawoke dakaada waira ukakuie i dawabairo keuwere makaku eraerabusaini iini yawoke dakaada waira ukakua wei. ");
INSERT INTO aby_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yewa orofa akakaro oi yawokenewaa dakaisade nono aneme aneme i urero ba eraerabusa yawofoisa wei. ");
INSERT INTO aby_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Moi minu eraerabusa yawokenewaa dakaisade nono ainama yanu onarounu eraerabusa mafiakuro yawofoisa wei. ");
INSERT INTO aby_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Moi waiya ukeka mima dai miyainu waiya da ufeku. Eno ufekuie dai miye una demui maneba dino ufekuro danu imukae moi dai mibairo ibifeku. I dai mi una demuinu waiya mane ukenewaa ufekuke i moi minu waiya me sarawere ufekua wei. I ari enoba Godinu waiyaini oi waiyaini demuiro da ufoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","I Ferosi orou emenu ararae oi ibake i orouma Yesunu wake naukada Yesubake wake merama weisa. ");
INSERT INTO aby_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesuma emuabake eno wei, yae eme moibairo yanu onarou mane we ma irauaiai ukaisaro nono Godima yanu imuka ubarenaro ibinu imukeka iwoka ukakua wei. Eme emenu ararae emenu onarou mane we ma irauaiaiya ukekabake ie irauaiaiya eno we imukaisaroma nono Godi Dawae ibai erakuke arara me i ari eno ukekabai. ");
INSERT INTO aby_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Adinaroma Dioninu doka odoro emema Mosesinu darawadu wakeini i we bou urieka orounu wakeini enaenari weibisa. Eno weada we ma iwoka ukeibiriekaro nono i Dioni doka odoroma Godinu yawokaku irau orofa wake we ma iwoka ukeibaisiya wei. Eno we ma iwoka ukeibaisi ibake eme keuwere Godinu yawokaku irau orofaro anifisane bunama imusu ari ukaisake anaisa. ");
INSERT INTO aby_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ureini dooini me sifekuie ara mero nono Godinu darawadu kai deidemunaku mane me sifeku i deima dawae arawereya Yesuma eno weike nono wei, Nanu wakeye da me sifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ainama danu aweka medakuke moi aweka munakuie dawae i awoena munaku awekaini demuiro dodoo ukeibakua weike eno wei. Nono ainama moi eme medaku aweka munakuie dawae i awekaini demuiro dodoo ukeibakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuma moi wake eno wei, moi eraerabusa keuwere irau wau bobo mima ibeibi. Dawae aine wai ure irau uruna mane iseibike irauaiai ibeibi. ");
INSERT INTO aby_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Dawa eno uke aine wai ure eno mane ukeibiro nono i ba me bou biobao bobo mima danu uwara aisame udiro ainada i eraerabusa keuwere bobo minu uruna ifurubai ifine ukeibi. Eno ukaada aineibiro kuasirima danu bou yabuneibisa. ");
INSERT INTO aby_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Eno ukeebe moi odoro i bou biobao bobo mi dawa feariro Godinu aneruma dawa waure amuke anisake Eibaramubairo ane oisa. Nono i eraerabusa keuwere bobo mi dawaini dubuena feariro ooru uisa. ");
INSERT INTO aby_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","24","Nono i eraerabusa keuwere bobo minu imumuma inaa yareibaku orofaro ani. I mima i inaa yareibaku orofaro oferi daiwere waurada naisa foraike eribaie Eibaramuini Rasorosini emua demuiro yaure ibisiro erieke daiwereroma eno wei, babae Eibaramu, nabake imukari uake Rasorosi we odaiaro wana raragama aduaro ma iyafike nanu meanaro odifiro nanu meana ure koboa ufi wei. Yewa inaaro oferi daiwere waurakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Eno weiro Eibaramuma ma owerike eno wei, nanu amara, anu adinaro ibeibi ibai imua wei. I furo ae irauaiai eraerabusa keuwere muneibiro Rasorosi dawae meramawere uke ibeibia eno wei. Nono awoenae Rasorosi dawa irauaiai ibinuro nono ae iro oferi daiwere waurakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nono iyanu ibinisi orofaroma anu ibinu orofae kafuru daiwereba yewadoma abairo aneaneme aafeisi eno wei? Nono abairoma iyabairo da aafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Eno weiro i mima wei, babae Eibaramu, Rasorosi yewaro da aafekua eno we imufakubaie nanu babaenu uwararo we odaiaro anifike nanu kaka nabue fai (5) we iifa ufiaro yewa oferi waureka orofaro da aafisa wei. ");
INSERT INTO aby_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eno weiro Eibaramuma ma owerike eno wei, Mosesinu darawadu bukaini Godinu we bou urie orounu bukaini emuabairo ibinuba i bukaro kakufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eno weibaie i mima wei, babae Eibaramu, i buka da kakufeisaya imusu moi feafeku mima uyafekuke emuabairo anifekuke emua we iifa ufiakuro danu wake naufeisake emenu ba me merama ukeka mune imusu odifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eno weiro Eibaramuma wei, Mosesinu darawadu bukaini Godinu we bou urie orounu bukaini da kakufeisade moi feafekuke nono uyare emuabairo anifekuke wefekude danu wakeini iini da naufeisaya weia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuma Danu iwoka ukeka oroubake eno wei, ba me uke ereka idua yabairo fafekua wei. Nono moi mima moi mi ba me uke iruke efekuro nono i mima Godi medifekuie Godima i irukeka mi fanisi daiwere mafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Moi mima Nanu wake naukeifeku mibairo ba me ufekuro i mima meramawere ufekuke Godi medifekuie dawa meramawereya wei. Eno ufekuro meramawere unao ufekua i ba me we ma iwoka ufiakua we imufisake i minu nodoro dai omawerema doifisake kunaro siafisaro isafike imu ifironae ie irauaiaiya weada yabake we iifa ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nono yanu kaka nabuema meramawere ufeisaie enaenari we iifa uyakawe. wei. Eno ufoisaie danu ba me ukeka mune imusu odifekua yama danu ba me ukeka imuke mediawe wei. ");
INSERT INTO aby_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dawae moi odoro i meramawere yaisina seweni (7) ukeifekuke nono i odoro danu merama yaisina mune derena enaro odeifekuke danu merama ukekabake arie weifekuie danu ba me ukeka mune imuke medeibiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","I afasoro orouma Yesubake eno weisa, Dai Waria Mi, iyanu Godi imukeka imuka ma buna ua weisa. ");
INSERT INTO aby_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eno weisaro Yesuma emuabake ma owerike eno wei, yanu Godi imukekae moi okoa masida ana yo kainaku ariroma nono yeka dai anabake uyake kuna ubarenaro ane isaa wefoisaie enaenari ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesuma eno wei, yabake weakune wei, waiya ukeka mima ewekaro waiyaro waiya ukeebe dumu sinakuro uwararo farakuro danu dai mima uruna ifeisia aarake yaua eno we dakaku. ");
INSERT INTO aby_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dawakoe danu dai minu uruna oukakuke makakuro danu dai mi isakuroma ai yaurakukema danu uruna ai isakua wei. ");
INSERT INTO aby_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Danu dai minu wake naukada enaenari ukaku i dawae danu waiya ibake danu dai mima dawa we ma irauaiai uke dakaku. ");
INSERT INTO aby_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Enaenari Godinu weaku wake yaisina enaenari ufoisaie yae irauaiai orou meya yae yanu waiya mane ukaisia eno weawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuma Derusaremu goiro anike Gareri orofaini Samaria orofa eka ena ewa enaro ibisiro abanaro ode kuure fare ani. ");
INSERT INTO aby_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Anike moi goiro ane faribaie moi beko mamirie orou yaisina deni (10) emuama Dawa ekake ekararowere enare ibaada iroma u daiwere weada eno weisa, Yesu, Dai Mi, iya imukari ua weisa. ");
INSERT INTO aby_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eno weisaro Yesuma emua eraada emuabake eno wei, aniaweke yanu mane i ofereni ode sibore sianaisa oroubairo yanu iboo naisa ma iwoka uyakawero efisa wei. Eno weiro anisaie idua wiroisa. ");
INSERT INTO aby_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Moi i bou irau siniro wiroi mima danu ofe irauaiai siniro iwoka uike owerike anaadae Godi daiwere we ma irauaiai uike ani. ");
INSERT INTO aby_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eno uisa ibake i mima Yesubairo farike Yesunu umu udiro ifoma kodudu yanakada Yesu we ma irauaiai ui. I mi dawae Samaria orofa mi. ");
INSERT INTO aby_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","I mima eno uiro Yesuma wei, i orou deni (10) wirokisaba me wei? I moi orou naini (9) aboro anisa wei? ");
INSERT INTO aby_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Anemebake yewa imusu mi mane owerinuke Godinu ibi we ma daiwere ukaku wei? ");
INSERT INTO aby_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eno weike i mibake nono wei, uyaa, ama Na imukakunara ibaima a ma wironea wei. ");
INSERT INTO aby_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Moi Ferosi orouma Yesubake eno weisa, Godinu yawokaku odo abonodo fafeku weisa? Eno weisaro Yesuma wei, Godinu yawokaku odoe moi ereka ubu ari eno da uke fafekuro da efoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awoenae yewaro Godima yawokakua da weawe, awoenae iro Godima yawakakua eno da weawe. Godinu yawokekae yanu imuka ubarenaro idua ibinua imukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuma Danu iwoka ukeka oroubake nono wei, moi furo i Ba Eme Sini Mi odo demuinaku efone wefoisakema nono Na da efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Moi orouma meo wefeisake yabake eno wefeisa, Dawae yewadoya, Dawae iroya eawe eno wefeisaie emenu wake da nauaweke emuabairo Na da yodia uke aniawe wei. ");
INSERT INTO aby_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bidama ure eka ena ewa enaro mamaada edoro ukeibakuro eme yaisina eraisa enaenari i Ba Eme Sini Minu farekae enaenari ufekuro eme yaisina efoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yesuma eno weike nono wei, kawamae Dawa oferi daiwere waufekuro yewa orofa akakaro ibinisa orouma Dawae medifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Adinaro Noanu ibi furo emema aneaneme ukeibisa i arie i Ba Eme Sini Minu fareifeku odoro enaenari ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noanu ibi furo emema urunaini adua isaada eme aweka munane makaneibisaro Noa dawae danu boudiro amuiro obi oku daiwere fariro i boudiro amuke dauisa orou yaisina emua imu ise feare me sika. ");
INSERT INTO aby_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Nono Rodinu ibeibi odoro enaenari ukeibisa. I furo emema urunaini adua iseibisake oima eraerabusa makane muneibisake waiya waweibisake uwara ma enareibisabaie Rodima Sodomu goi mediro i odoro Godima inaaini barai yari omaini ureroma odairo isare aarike i orou yaisina yare me sirie. ");
INSERT INTO aby_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Enaenarie emema emenu urunaini adua ifeisake emenu emenu arara waiya ukeifeisaro i Ba Eme Sini Mi idua fafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","I odoroe i seboro yaure ibifeisa orouma uwara ubarenaro eraerabusa mufisane da anifeisaya eno wei. I enaenari i waiyaro waiya ukeifeisa orouma emenu wau mufisane uwararo da owere aafeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rodinu aweka imuke eawe wei. Godima Rodini danu awekaini emua i Sodomu goi medifisike oraararo amuke anifisine weiro anaada Rodinu awekama i Sodomu goi imukari uiro ma owere eraada damena ari dai omawere sini. ");
INSERT INTO aby_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ainama danu arara mane yewa orofaro me ibeifine ufekuie idua feafekua wei. Nono aina ainama emua arara me yewa orofaro ibekaie emua me ibene ibene ibifeisaya wei. I wake yabake ba wemaro nauawe wei. ");
INSERT INTO aby_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","I dumuro eme una raara demuiro nauka aine ibifisisiie nono moi mi waure anifekuro nono moi mi mane aine ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Moi awekayai demuiro okea oukeifisisie moi una waure anifekuro nono moi una mane ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eme una raarayai demuiro waiyaro waiya ukeifisisiie moi mi fare mune waure anifekuro nono moi mi mane ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesuma eno weiro Danu iwoka ukeka orouma ma owekake eno weisa, Dai Waria Mi, i ari enoe abo orofaro eno ufeku weisa? Eno weisaro Yesuma emuabake dubu waure weadama ibake eno wei, emenu ofe bou aboro ibifekuie iro udu adama ifisane anifeisaro yama i orofa iwoka ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yesuma eme guriguri ukeifisake da medifisane ibake yewa wake dubo waure wakeroma emuabake eno wei, moi goiro kodo yawokeka dai mi dawae Godini emeini emuabake ia iyare dakeibike ibeibi. ");
INSERT INTO aby_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ibeibiro nono I goiro moi wabu awekama ibaada i kodo yawokeka mibairo fareibike eno weibi, Naini wasai ukaku mi wearo i ukakubai sabu medifi weibi. ");
INSERT INTO aby_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dawae eno mane aine wai ure weibiro i kodo yawokeibi mi dawa arara daui. Dawae arara mero i awekama dawabairo areare faraada eno weibiro nauke awakebe we imui, nae Godini emeini emuabake ia sine dakakunebairo nono dawama nabairo areare faraada eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nono yewa wabu awekama nabairo areare fare weakuba danu weaku enaenari umaua wei. Eno da umauie dawa nabairo areare fareifekuba nanu ibeka meramawere sifekua eno we imuia wei. ");
INSERT INTO aby_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesuma eno weike nono wei, i meramawere kodo yawokeka dai minu wake nauawe wei. ");
INSERT INTO aby_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dawa eno ukakuie Godinu wake naukaisa orouma Godibairo areare weaisaro emenu weaisa wake Godima naukenewaa ukakuba me wei? ");
INSERT INTO aby_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Euwa, emenu weaisa wake enaenari sabu sabu ukakua wei. Iduaroma i Ba Eme Sini Mima dooro nono owefekuke fafekuie emema Godinu wake ba adaadake naufeisa orou ma owere efiakuba me ariya wei? ");
INSERT INTO aby_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Moi orouma emenu onaroubake eno we imuisa, iyae irauaiairo nono moi orou emua irauaiai meya eno we imuisaba ibake Yesuma yewa wake dubo waure wakeroma emuabake eno wei, moi miyaima dai sosi uwara ubarenaro guriguri ufisine anisi. Moi mi dawae Ferosi miro nono moi mi dawae dakesi oi muneka mi. ");
INSERT INTO aby_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","I Ferosi mima uyarike danu onami mane imuke guriguri ukaada eno wei, Babae Godi, nae moi orou ari eno meba ibake A we ma irauaiai ukakunea wei. Nae waira mi me. Nae merama ukeka mi me. Nae moi orounu aruma aweka enare odeka mi me. Nae yewa dakesi muneka mi ari eno meya wei. ");
INSERT INTO aby_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Moi fura yaisinaro odo raarayai uruna ise dakuneke nanu eraerabusa yaisina i daisi ofereni Abairo makakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nono i dakesi oi muneka mima maru uike ekararo enarike guriguri ukaada danu oro uraada eno wei, Babae Godi, nae meramawere miya imukari uina weia wei. ");
INSERT INTO aby_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesuma i wake eno weike emuabake nono wei, Nanu wake nauawe, Godima i dakesi oi muneka minu ba me ukeka munike imuke medike i mi ma gienabu uiro dawae danu uwararo isare ania wei. Godima i Ferosi minu ba me ukeka mune imuke mede dauia wei. Ainama danu onami ma daiwere ufekuie Godima i mi dawa ma okoanaku ufekua eno wei. Nono ainama danu onami ma okoanaku ufekuie Godima i mi dawa ma daiwere ufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Moi orouma emenu amarananaku Yesubairo waure anifisaro Yesuma emua ure burifiane waure farieka. Eno uisaro Yesunu iwoka ukeka orouma ekake dino wake weisa. ");
INSERT INTO aby_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Eno weisaro Yesuma i amarananaku u weike Danu iwoka ukeka oroubake bunawereroma eno wei, i amarananaku Nabairo aafisane weakunea eno wei. Emenu aareka daaba dadau dauawe wei. Aina ainama i amarananakunu imukeka ari imufeisake emenu onarou we ma daiwere da ufeisaie Godinu yawokaku orofae i ari eno orou emenua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yabake ba wake wemaro nauawe wei. Ainama Godinu yawokaku amaranakunu ure ribuku ukaisa enaenari da ufekuie Godinu yawokaku orofaro da anifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Moi yawokeka mima Yesubake eno wei, irau sisa mi, aneaneme umauke me ibene ibene ibimau wei? ");
INSERT INTO aby_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eno weiro Yesuma ma owerike dawabake eno wei, anemebake Nae irauaiai weaku? Godi Danu mane irauaiaiya moi mima irauaiai meya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Eno weike nono wei, Godinu darawadue a iwoka ukaku. I darawadue eno, moi minu aruma aweka da enare odia, eme da ma feaa, waira daua, wayai weadae meo da wea, anu amae babaenu wefisisi enaenari ukenewaa ua. I darawadue i ari enoya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eno weiro i mima wei, i darawadu yaisina nanu okoanakuroma eno ukeibakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eno weiro Yesuma naukada ma owerike nono wei, demuinaku uke dakakua wei. I ie eno, anu eraerabusa yaisina make oi mufakuke i eraerabusa me oroubairo i oi mayanake Nanu umuro aara wei. Eno ufakuie abake urero eraerabusa mamekuro i eraerabusae urero ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesuma eno weiro i mima nauike danu eraerabusae keuwere ibake iboo naisa imusu odaada imuka merama ui. ");
INSERT INTO aby_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuma i imuka merama bobo mi eraada eno wei, i eraerabusa keuwere bobo mima Godinu yawokaku daabaro anaadae ara daiwere ukeifekuro anifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moi abu danu ibiye kemo dawama mara bobo ebaro fare anifekuie girisi da ufekua weike wei, nono i eraerabusa keuwere bobo mi dawae Godima yawokaku daabaro anaadae ara daiwere ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eno weiro i wake naukeibisa orouma eno weisa, enoba ainama wirofeku weisa? ");
INSERT INTO aby_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eno weisaro Yesuma emuabake ma owerike eno wei, emema eno da ufeisaie Godima i wenebai i yaisina Danu mane ma wirofiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eno weiro Fidama Yesubake ma owerike eno wei, iyae iyanu uwara meisike Anu umuro aaraisia ea wei. ");
INSERT INTO aby_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Eno weiro Yesuma emuabake nono wei, nanu ba wake wemaro nauawe wei, ainama danu uwaraini awekaini kakae nabueini danu amae babaeini amarakuini Godima dawa yawofine ibake i yaisina medinuba awoenae Godima dawabake keuwere moko mafekuro nono dubuenaroe me ibene ibene ibifekua, Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuma Danu iwoka ukeka orou duero (12) mune imusu odirieke emuabake eno wei, Derusaremu goiro anaisia eawe wei. Iro ane fafeisiie i Godinu we bou urie orouma i Ba Eme Sini Mibake adinaro aneme weibisaie enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iro Dawae i imusu orounu wana duboro mame odifeisaro emuama mufeisake Dawa uke irukada meramawere uke yafeisake Danu iboo naisaro wisiomu uke yafeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eno uke yafeisake mobuma ufeisake ma feafeisaro odo buuba me sifekuro nono uyafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesuma eno weiro Danu wakeye dubo waure wenu ariya we imukada ma nuna daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuma Deriko goiro fafine amuke aneibibaie moi naisa kikori bobo mima daaba udiro yaure ibaada eenu weibi. ");
INSERT INTO aby_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eno ukaada i fareibisa orounu wake goro nauike eno wei, emuade aneme ukaada weaisa wei? ");
INSERT INTO aby_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eno weibaie i orouma ma owekake eno weisa, Yesu, Nasaredi goi mi idua fare anakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eno weisaro i naisa kikori bobo mima daiwere eno wei, Yesu, Deiwidinu sisia mi nabake imukari ua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eno weiro i moi orouwerema mediake eno da wea weisaro dawama nono daiwereroma weada wei, Yesu, Deiwidinu sisia mi nabake imukari ua wei. ");
INSERT INTO aby_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eno weiro Yesuma enarike eno wei, i mi waure aarawe weiro enaenari uisa. ");
INSERT INTO aby_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","I mi Yesubairo waure fakaro Yesuma dawabake eno wei, anu ararae aneme umane weaku wei? Eno we nauke eriro i mima wei, Dai Waria Mi, nanu ararae nanu naisa forake emane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","43","Eno weibaie Yesuma wei, anu Na imukeka imukae daiwere ibake wirokinua anu naisama ea weibaie i mi idua naisa foraike erike Yesunu umuro anaada Godinu ibi we ma daiwere ui. I ku siane ibisa orouma ibai ekake Godi we ma irauaiai uisa. ");
INSERT INTO aby_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Yesuma Deriko goi fare fisii yare aneibi. Fare aneibiro moi mi danu ibiye Sakiyasi dawae adinaroma i goiro ibeibi. Sakiyasi dawae dai dakesi oi muneka miro nono dawae oini eraerabusa keuwere bobo mi. ");
INSERT INTO aby_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesuma fare aneibibaie Sakiyasima Yesu efine aneibiro eme keuwere fare ku siakaro dawae fu miba Yesu ere daui. ");
INSERT INTO aby_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Enoba iduama medike durame ane sikamu ana daaro amuke ane yauri. ");
INSERT INTO aby_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Amuke ane yaure ibiro Yesuma i orofaro fare anaada eku eribaie i mi idua yaure ibiba Yesuma eno wei, Sakiyasi, anu uwararo anakunea sabu isare aara wei. ");
INSERT INTO aby_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eno weiba ibake i mima sabu isarike daiwere rooro ukaada Sakiyasima danu uwararo Yesu waure ani. ");
INSERT INTO aby_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","I fare ku siane ibisa orouma ibai ekake wake mumuuroma eno weisa, Yesuma yeka meramawere minu uwararo ibinua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyasima Yesunu ibooro enare ibaada eno wei, Dai Waria Mi, ea. Nanu eraerabusa moibai nanu mumauke moibaiye i eraerabusa me oroubairo mamiaua wei. Eno weike nono wei, moi minu eraerabusa waira uebaini iini nono moi foini (4) i mibake ma owere mamaua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eno weiro Yesuma wei, awoenae Godinu wirokeka yewa uwararo farinua wei. Yewa mi dawaini Eibaramunu sisia miya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","I Ba Eme Sini mima yewa mini i Godibairoma fe yaraisa orouini emua yaisina yodia ufiake ma wirofiane ibake faria Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","12","Yesuma anike Derusaremu goiro fafine ui. Ane fafine uibaie i Danu umuro aneibisa orouma Godinu yawokaku odo sabu fafekua eno we imukeibisaba ibake Yesuma yewa wake emuabake moi dubo waure weeka wakeroma eno wei, moi dai mima danu adaadake yawokeka waiya ukeka wake moi orofaro anifike naufine ui. ");
INSERT INTO aby_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Anifine ukaada danu waiya ukeka orou deni (10) weiro dawabairo ane faka. Dawabairo ane fakaro emua demui demuibake duenidi kina (K20.00) marieke wei, yewa oi yawokenewaa uaweke i oima oi muneka waiya ukeibiawero na owere famake emia wei. ");
INSERT INTO aby_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Eno weike danu orofa orou emua arara me danu yawokeka ibake moi orou we odairiekaro anisake dawabake eno weisa, iyae arara me anu yawokeka ibake iyae ama da yawomisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dubuenaro i mima danu adaadake yawokeka wake nauike owere goiro aare fari. Goiro owere aare farike danu oi marie orou emuae i oi muneka waiya aneaneme ukeibisa ibai dawa iwoka sifine ibake emua weiro dawabairo aare faka. ");
INSERT INTO aby_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dawabairo aare fakake i bokai mima eno wei, dai mi, anu makara duenidi kina (K20.00) duboro moi du aderedi kina (K200.00) odinea mua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eno weiro danu dai mima eno wei, ae gienabu irauaiai waiya ukeka mi. Abake okoanaku manero irauaiai yawokinuba goi yaisina deni (10) mamauanero yawofiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nono moi abana mima farike eno wei, dai mi, anu makara duenidi kina (K20.00) duboro moi wani aderedi kina (K100.00) odinea mua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eno weiro danu dai mima eno wei, ae goi yaisina fai (5) mamauanero yawofiakua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Nono moi mima farike eno wei, dai mi, anu makara duenidi kinae yewadoya ea wei. Eno weike nono wei, ae arawere yawokada waiya wawe mero uruna munakuie ama moibai ode dakakuke yaisina munakua wei. Enoba nae anubai iwoka sinaada abake ia sineke anu makara duenidi kina (K20.00) wauma oba ueke fe odeke a farinuroma ai munea wei. ");
INSERT INTO aby_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Eno weiro i danu dai mima eno wei, ae meramawere mi! Ibake nanu imukeka iwoka sinaada nanu we enaenari uke dakinuba ae fanisi mamauanea wei. A iwoka, nae arawere yawokakuneke waiya wawe dakakukema nono urunae me munaada moibai ode dakakunebairoma me munakunea wei. Ie a iwoka sinakukema nono anemebake nanu oi banika uwararo odifaro dubo oi odifisaro fare mune daune wei? ");
INSERT INTO aby_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Eno weike i fare ku siane ibisa oroubake eno wei, i minu duenidi kina (K20.00) mareke muaweke yeka du aderedi kina (K200.00) bobo mibairo maewe wei. ");
INSERT INTO aby_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eno weiro emuama eno weisa, dawabairo du aderedi kina (K200.00) ibinudeie weisa! ");
INSERT INTO aby_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eno weisaro i dai mima emuabake eno wei, nanu wake nauawe wei, i keuwere bobo mibairo moibai duboro mafekua wei. Nono i keu menaku ibifekubainakue yaisina mareke mufekua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eno weike wei, nanu yawokakunia moi oroue wasai orou ari nanu yawokekae emua arara meya emua waure aayakaweke nanu ibooro emua uyakawero feafisa wei. Yesuma i dubo waure wakeroma i oroubake eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuma i wake we me sinike Dawako Derusaremu goiro amuke aneibiro Danu iwoka ukeka orouma Danu umuro amuke anisa. ");
INSERT INTO aby_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Amuke aneebe Bedifeidini Bedini goiyairo fafisane uisa. I goiyaie oriwa oraara udiroba iro amuke ane fafisane uisaro Yesuma weiro Danu iwoka ukeka miyai Dawabairo ane fakiro eno wei, yeka moi goiro aniawake i goiro fafuaisiie i goi araweko uwara kubune kukubu kairo moi okoa doniki weaisa abu doise oisaro ibinuba efuaisiie ma woromiawake waure aarawa eno wei. I okoa donikinu duburoe moi mima yaure meya wei. ");
INSERT INTO aby_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eno weike nono wei, i okoa doniki anemebake naa ma woromaisi wefeisaie emuabairo eno weawa wei, uwanu Dai Waria Mima mufike iro yaure anifine wenuba munaisua weawa wei. ");
INSERT INTO aby_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","33","Eno weike we odairiero ane fakike Danu wei wake enaenari uke ibiro eki. I okoa doniki ekike ane naa ma woromeibisibaie i doniki ubi orouma eno weisa, anemebake i doniki naa ma woromaisi weisa? ");
INSERT INTO aby_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eno weisaro emuama ma owekike eno weisi, uwanu Dai Waria Mima mufike iro yaure anifine wenuba munaisua eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I miyaima i okoa doniki waure fare oisi. Waure fare oisiro Danu iwoka ukeka orouma wau i doniki duboro yaweke oisake weisaro Yesu i doniki duboro yauri. Yesuma i doniki duboro yaurike ani. ");
INSERT INTO aby_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","38","Yesuma i doniki duboro yaurike aneibiro emema emenu wau daabaro yaweke ode aneibisaro i dubo duboro ani. Anike Oriwa oraara udiro fareibibaie Danu wake naukeibisa orou keuwere Danu buna ukeka keuwere ekaba ibake rooro daiwere uisake ousana weada Godinu ibi we ma daiwere ukaada daiwere eno weisa, iyanu yawokeka Dai Mi Godinu ibiro idua farinua weibisa. Godima Dawa ma irauaiai ufekua weibisa. Urero irauaiai ibinu Godinu ibi we ma daiwere ukaisia eno weibisa. ");
INSERT INTO aby_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eno weibisaro moi Ferosi orouma Yesubake eno weisa, Sisa Mi, Anu iwoka ukeka orou wearo i weaisabai medifisa eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eno weisaro Yesuma wei, yabake wemaro nauawe wei, yewa orouma wake da wefeisake medifeisaie i oma yaisina wake daiwere wefeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Yesuma i Derusaremu goi ubiubi faraada i goi orou erieke ii weada eno wei, awoenae Godinu me makekabai ma nuna ukakuba Godima Danu me ibeka abairoma ma feyarakuro ere dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Eno weike nono wei, moi odo fafiro wasai ufeisa orouma fafeisake yewaro gibudi daunada kara uke gibudi anu marao kararo siafisake kara ufisake a ma doroo yaraada anu orou yaisina ma feafiakasaya wei. Nono moi omama moi omanu duboro da ibifeku. Yae Godinu me makekae ya arara meba ibake i ari eno ufeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Yesuma i dai sosi uwara ubarenaro ane amui. Ane amuike i eraerabusa make oi muneibisa orouini i uwara ubarenaroma we yowerada emuabake eno wei, Godinu bukaroma eno weaku, Nanu uwarae emenu guriguri ukeka uwaraya wei. Nono yama Nanu guriguri ukeka uwarae waira ukeka orounu uwara ubu ukaisaya eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Yesuma aine wai ure i dai sosi uwara ubarenaro we ma iwoka ukeibirie. Eno ukeibiriebaie i dai ofereni ode sibore sianeka orouini i Du orou emenu yawokeibirieka orouini emuama Yesu ma feafisane daaba yodia ukeibisabaie i orou yaisina Danu wake naukenewaa uisaba ibake Dawa ma feareka daaba fou ure dauisa. ");
INSERT INTO aby_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Moi odoro Yesuma we ma iwoka ukaada Godinu irau wake weibibaie i dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini dai bisara orouini emuama Yesubairo ane faka. ");
INSERT INTO aby_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Emuama Yesubairo ane fakake eno weisa, i ari enoe Anu bunaro eno ukaku? Ainama Abairo i ari eno buna makakuyainuro eno ukaku? Wearo naufe weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Eno weisaro Yesuma emuabake ma owerike eno wei, Nanu we nauke erekako bokai wemaro yanu moko wake weawero Na nauma weike nono wei, Dioninu babadaido ukeka ie ureroma isare fariba ba emebairoma fari wei? ");
INSERT INTO aby_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eno weibaie i orou emenu emenu wake we makanada emenu mane eno weisa, aneme aneme wefeisi arie weisa? Ureroma isare faria wefeisiie Dioni anemebake imuke dakaisa wefekua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nono emebairoma faria wefeisiie yewa ku siane ibinisa orou yaisina Dioni dawae Godinu we bou ukeka miya eno we imukaisaba iyae omama umisaisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Emenu mane eno we makakake Yesubairo fakake eno weisa, iyae iwoka meya weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eno weisa ibake Yesuma emuabairo nono wei, iduaba Nanu ainama buna makakunararo ukakune ibai yabairo da wemaua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuma i orou yaisinabake yewa wake dubo waure wakeroma eno wei, moi mima gureifi yobai waiyaro wawe odike moi orouma yawokeifisane marieke dawae moi orofaro ani. Anike iro manabe kai keuwere ibeibi. ");
INSERT INTO aby_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ane iro ibeebe ayo ureka oya fariro danu waiya ukeka moi mi i moi gureifi kaibai mufine we odairo ani. Ane fariro i waiya yawokeibisa orouma emua arara me i gureifi makeka ibake i mi yabaisake usima ureebe gureifi kaibai make dauisake me ma owere odaisaro ani. ");
INSERT INTO aby_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I dai mima nono moi mi we odairo ane fariro enaenari yabaisake usima ureebe meramawere uke yakake gureifi kaibai make dauisake me ma owere odaisaro ani. ");
INSERT INTO aby_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nono i dai mima moi mi we odairo ani. Ane fariro enaenari yabaisake usima ureebe bou bedako badako uke oisake dawa we yowekaro ani. ");
INSERT INTO aby_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Eno mane ukeibiriekaba ibake i waiya ubi mima eno we imui, aneaneme umau arie we imui? Nanu amara ubima we odaimauro dawabake wefeisake iifa ufeisaya we imui. ");
INSERT INTO aby_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eno we imuike danu amara ubi we odairo ani. Ane fariro emenu emenu we makakake eno weisa, yewae danu amara ubiba dawa ma feafeisike danu waiya iyama mufeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eno weisake i mi munaadae waiya oro dubuenaro siakake dawa ma feakaya Yesuma wei. Eno weike emuabake nono wei, i waiya onami mi emuabake aneme ufeku wei? ");
INSERT INTO aby_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eno weike nono wei, Dawae anifekuke i waiya yawokeifeisa orou ma feafiakuke danu waiya mune imusu oroubairo mafiakua eno wei. Eno weiro nauisake eno weisa, yewa mi! I ari eno daufekua weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Eno weisaro Yesuma emua eraada eno wei, ya aneme weaisa? Godinu bukaroma eno weaku, i uwara ma enareka orounu mune siaka omae i bokai kora kukubu kai ari sinia eno wei, Godinu bukaroma anemebake eno weaku wei? ");
INSERT INTO aby_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ainama i omaro ure akuaku ufekuie danu onami ure birabira yafekua weaku. Nono i oma isafekuke aina minu duboro isare ufekuie i miye gibudi ari sifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesuma i wake emuabake dubo waure wakeroma weike eno weiro i wake emuabake weibibai emua iwoka uisa ibake i darawadu we ma iwoka ukeibisa orouini dai ofereni ode we sibore sianeka dai orouini emuama Yesunu umu wana naama uwafisane uisakema nono i ku siane ibisa oroubake ia iyakake meisa. ");
INSERT INTO aby_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Meisake imukenewaa uisakema moi orou Yesubairo we odairiekaro anisa. I orouma uke iruke enaada Yesu ukeibi sineibibai ere nauke ufisane anisa. Eno uke ere nauke ufisake Yesu mune i dai gaemani orounu wanaro mame odifisane ibake Danu ukeibi sineibibai ere naukenewaa uisa. ");
INSERT INTO aby_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I orouma Yesubake eno weisa, sisa mi, Ae eme yaisinabairo weakuro enaenari sinakuie enaenari ukakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Moi orou emua daiwerero nono moi oroue okoanakua eno we imuke dakakuke ba adaadake we ma iwoka ukakuneke meomao uke dakakuke ba Godinu wake mane weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eno weisake nono weisa, i Romani gaemani mi Kisabairo dakesi oi mafeisi ide irauba me weisa? ");
INSERT INTO aby_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Eno weisaro Yesuma i orou emenu imuisake we irukeibisabai iwoka sinike eno wei, i oi kaibai makowero ema wei. Eno weiro maisaro eraada eno wei, yewa ainanu iboo naisaini owaowaini yewado ibinu ariya eawe wei? Eno weibaie emuama eno weisa, ie Kisanu iboo naisaya weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eno weisaro Yesuma nono wei, iduaya Kisanu aneme aneme yaisina Kisabairo maeweke nono Godinu aneme aneme yaisina Godibairo maewe wei. ");
INSERT INTO aby_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eno weiro nauisake i ku siane ibisa orounu ibooro Yesu uke iruke dauisake Danu wei wakebake imuka foria uisake wake muu uisa. ");
INSERT INTO aby_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nono dubuenaro moi Sadusi weaisa orouma Yesubairo aare faka. I Sadusi orouma eme feafeisake iroma nono da uyafeisaya eno weada we ma iwoka ukeibisa. ");
INSERT INTO aby_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","I orouma Yesubairo fakake eno weisa, Mosesinu darawaduma eno weaku, moi mima aweka mufekuke amara aruma dore mero me ibeebe feafekuie danu nabuema danu aweka wabu mufekuke i feafeku mibake amara aruma dofeku eno weakua weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eno weisake nono weisa, demui aidakaku yaisina seweni (7) ibeibisaya weisa. Ibeebe i bokai mima aweka munike amara aruma dore mero me ibeebe feari. ");
INSERT INTO aby_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Feariro danu umuro isari mima danu kakanu aweka wabu munike amara aruma dore mero me ibeebe feari. ");
INSERT INTO aby_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nono abanaro isari mima i aweka wabu nono muniro eno mane emua yaisina mukakema nono moi amara aruma dore mero me ibeebe feare me sikaro i aweka wabu dawae dubuenama fearia eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","I demui aidakaku yaisina seweni emua i demui aweka una mukakema feakaba nono dubuenaro i feaka iroma uyafeisa i odoro abo mima i aweka wabu mufeku weisa? ");
INSERT INTO aby_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eno weisaro Yesuma emuabake ma owerike eno wei, yewado awoena ibinisa orouma ayakaku mune makanaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nono i Godima iraua weaku orou emua i feaka iroma uyafeisake me ibene ibene ibifeisa i orouma ayakaku da uke makafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","I ibifeisa orofaroe Godinu aneruini emuaini emuae demui ari sifeisa. I orou emuae Godinu amaraku sifeisaba ibake iro da feafeisaya eno wei. Godima emua i feafeisa iroma ma uyafiakuke me ibene ibene ibeka emuabairo mafiakuba ibake emuae nono da feafeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yesuma eno weike nono wei, Mosesima eno weia wei, Godima i fearaisa orou ma uyarakunea weia wei. Mosesima i feare mero yareibaku ananaku eraada eno wei, Godiye iyanu sisia sirorari orou Eibaramuini Aisikini Deikafuini emenu Godiya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yesuma eno weike nono wei, Godi Dawae i me ibeka orounu Godiba ibake i feaka orou emuae awoena yaisina me ibinisa. Godi Dawae i feakake me sika orounu Godi me ibake Godima eno weaku, Nae i me ibinisa orounu Godi weakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Yesuma eno weiba ibake i darawadu we ma iwoka ukeibisa moi orouma wake moi weekabai emua arara da sirieba ibake eno mane weisa, sisa mi, ba weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","I orouma eno we nauke ekaro Yesuma ma owerike eno wei, i darawadu we ma iwoka ukeibisa orouma i Keriso Deiwidinu sisia mi anemebake eno weaisa? ");
INSERT INTO aby_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Deiwidima i Samusi bukaro i Mesaiabake eno weaku, Godima nanu Dai Waria Mibake eno wei, Nanu baena wana enaro yauaro aini wasai ukaisa orou yaisina Nama buna umake Anu eu umu wowonaro odimia eno weia weakua wei. ");
INSERT INTO aby_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yesuma eno weike nono wei, Deiwidima i Kerisobake weada Dawae nanu Dai Waria Miya weibairoma nono aneaneme Yesu Dawae Deiwidinu sisia mi sini arie Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Yesuma eno weike i orou yaisina emenu ibooro Danu iwoka ukeka oroubake eno wei, i darawadu we ma iwoka ukaisa orou erenewaa uforo wei! I orou emenu ararae yafawere wau fayaroma rune siafisaro fare isafiro i makediro enaisa orounu arie wake naufisake i Du orounu sosi ubarena irau orofaro emuako ane yaufisake banauro emuako i orounu ibooro irau orofaro ane yaufisane ukaisa oroua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","I orouma i wabu awekabonu eraerabusa yaisina fema waira ukaisake nono meo guriguri yafawere emema emua efisake naufisane ibake eno ukaisaya wei. Emuae eno ukaisaba Godima emua fanisi daiwere mafiakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Moi odoro Yesuma dai sosi uwara ubarenaro ane enare ibaada eribaie moi orou keuwere emenu ofereni makeka bogesiro oi fare sianeibisa. Sianeibisaro i eraerabusa keuwere orouma oi daiwere fare sianeibisa. ");
INSERT INTO aby_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","3","Sianeibisaro nono moi i eraerabusa me wabu awekama farike toea kai raaranakuyai fare sianiro Yesuma erike eno wei, Nanu ba wake wemaro nauawe wei. Yewa wabu awekama oi daiwere fare sianinuro i orou yaisina dai menaku fare sianisake anisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","I orou emuabairo oi keuwere ibinubairoma emuae dai menaku fare sianisaya wei. Nono yewa wabu awekae danu uruna make muneka oi yaisina idua fare sianinuba ibake dawae oi daiwere fare sianinua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Moi orouma i dai sosi uwara ekake eno weisa, i dai omawerewereini nono i dai sosi uwara ubarenaro i weree wereeini Godibairo we makeka eraerabusaini eawe weada iro ereibisa. ");
INSERT INTO aby_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Eno uke eraada weibisaro Yesuma nauike eno wei, yanu i awoena ibinuro eraisa ie moi odoro i oma yaisina ma ubere ubere yafeisaro moi omanakuma moi oma duboro da ibifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesuma eno weiro Dawabake ma owekake eno weisa, abonodo i ari eno ufeku weisa? Aneme ufekuro efeisiroma eno ufeku weisa? ");
INSERT INTO aby_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eno weisaro Yesuma emuabake ma owerike eno wei, moi orouma ya we irufiakaisaba erenewaa uforo wei. Eme keuwere we irufisane Nanu ibiro fafeisake eno wefeisa, nae i Kerisoya wefeisake i odo idua farinua eno wefeisaie emenu wake da naufoke emenu umuro da aniforo wei! ");
INSERT INTO aby_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","I daiwere urane rarane ukeifeisa i wake naukeroma ia sineroma da aniforo wei. I ari eno ufekuroma i dubuena kai odo idua fafekua wei. ");
INSERT INTO aby_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","11","Yesuma eno weike nono emuabake eno wei, moi orofa gaemanini moi orofa gaemanini urafeisaro nono moi orofa akaka orou emenu imusu imusu urafeisaro i dooini amani amani ufekuro nono i orofa keuwerero arumu daiwere fafeku. Nono i oroorofaro arama daiwere ukaada oferi daiwere waufeisa. Urero ubu imusu imusu ufekuro efeisake ia daiwere iyafeisake nono urero moi buna ereka keuwere ufekuro efeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","13","Yesuma eno weike nono wei, dawakoe emema ya ma merama eno uke yafiakaisa, yae i Du orounu sosi yawokaisa orounu wanaro mame odifiakaisake ana ebaro odifiakaisake i dai kini orouini gaemani yawokaisa dai orouini emuabairo Nanu ibibake yae waure ane emuabairo odifiakaisaya eno wei. Emua eno ufeisaie i furo Nanu wake idua emuabairo wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","I orounu wayai weifeisa wakebake yama moko wake aneaneme wefeisiarie eno da wefoke ibaibake imukenewaa da uforo i yaisina yabake Nama wemauke buna imukeka mamiauro emenu moko wake wefoisaro i yaini wasai ukeifeisa orouma moko wake moi da wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yanu amae babaeini yanu kaka nabueini yayae wawaeini yanu goi demui orouini emuama ya umu wana naama uwafiakaisake ya wayai wefeisaro ya ufiakaisaro moibai yae feafoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eme yaisina yae Nanu ibi munaisaba ibake imuka ka ufiakaisaroma Godima ya unu kofiakuba irauaiai ibifoisaro yanu fouma idi deidemunakuma me sara da isafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","I meramawere uke yareifiakaisa ibaibake iura da maifoisake enare ara ukaada nono buna ufoisake enare arabi ufoisa i deima me ibene ibene ibifoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesuma ibai weike nono wei, i moi meremere orouma Derusaremu goiro enare kara ufeisaro efoisaie i Derusaremu goi ma merama ukeka odo idua fafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","I odo idua fafekuro i Diudia orouma oraararo sabu amuke anifeisaro i Derusaremu goiro ibifeisa orouma i goiroma sabu anifeisaro nono i waiyaro waiya kuneifeisa orouma Derusaremu goiro owere fareroma ane dafeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Godinu we bou ukeibirie orounu weibisa wake i odoro Godima i Derusaremu goi orou enaenari fanisi mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I odoro boana bobo awekaboini ama iseifeisa amaraku bobo awekaboini emenu anifeisa daabae dai meramawereya eno wei. Yewa orofa moi orouma imuka merama ufeisake i oroubake imuka ka daiwere ufiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Imuka ka daiwere uke yafiakaisake eme keuwere dai bauma faya kuufiakaisaro feafeisaro nono moi orou keuwere emenu umu wana naama uwafiakaisake moi oroorofaroma iro aboro aboro waure anifiakaisaya wei. I imusu orouma Derusaremu goiro uwara uwara ma doroo yafeisake amune adiadi yare aneebe emenu ibai medeka odo idua fafekuro medifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesuma emuabake nono wei, urero manabeini ewekaini muinaini ubu imusu imusu ufeisaro efoisaya wei. Yewa orofaro dawara ufe daiwere uyafekuke yama wefekuro emema ia daiwere iyafeisake ibai ma nuna ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Urero i eraerabusa yaisina amani amani ufeisaie emema iini i fafeisa eraerabusaini yaisina efeisake imuka merama imufeisake fearaisari ufeisake birufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nanu weakune i yaisina enaenari ufekuie i Ba Eme Sini Mima ou ubarenaro Danu bunaini Danu edorowereini idua fafekuro ya efoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","I yaisina ukeifekuie yanu ma wirokeka mi idua fafekua gienabu enaeweke urero eku ereibiawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuma emuabake dubo waure weike eno wei, i boruba anaini moi imusu ana eyakaweke iwoka siawe eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Awoena ana omuru yanakakuie i arumu idua farinua eno we imukaisa. ");
INSERT INTO aby_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","I ari enoe Nanu wene wake enaenari awoena ufekuro efoisake Godinu yawokaku odo idua fafine ukinua eno wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yabake ba wake wemaro nauawe wei. Yewa awoena ibinisa orou yaisinawere da feare soafeisaro i wenebai ufekuro efeisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ureini dooini me sifekuro nono Nanu wakeye da me sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Erenewaa uforo! Me sarawere da ibifoke gogore adua da ifoke yewa orofaro eraerabusa mane da imufoke i afa sianaisaro adama meya weakuke fare anakuro fema munaku i ari i odo yabairo fema fanao ufekuba ibake wei. I odoe yewa orofa akakaro ibinisa orou yaisinabairo fafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Erenewaa uforo! Ya buna mufoke guriguri uforo i meramawere fafekuke ufeku ima ya da ma merama ufinea i Ba Eme Sini Minu ibooro me irauaiai enaewe wei. ");
INSERT INTO aby_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesuma aine wai ure dai sosi uwara ubarenaro we ma iwoka ukeibirie. I eweka furo we ma iwoka ukeibirieke dumuroe Oriwa oraararo amuke ane aineibi. ");
INSERT INTO aby_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eno ukeibiro i orouma wai awanakuro Dawabairo Danu wake naufisane i dai sosi uwararo fareibisa. ");
INSERT INTO aby_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Godima i Isaraera orounu Idifiroma waure aneka banau odo idua fafine ui. I banaue i ure wawareka iraa yisidi me buredi ifisane uisa banau. ");
INSERT INTO aby_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","I odoro i dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini emuama Yesu ma feafisane daaba yodia ukeebe i moi orouwerebake ia iyakake i daaba fou ure dauisa. ");
INSERT INTO aby_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","I odoro seidanima Diudiasi Ikariadanu imuka ubarenaro isari. Diudiasi dawae Yesunu moi duero (12) iwoka ukeka mi. ");
INSERT INTO aby_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Diudiasima i dai ofereni ode sibore sianeka oroubairo Yesu do mafine ane wei. ");
INSERT INTO aby_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eno ane weiro i orouma rooro uisake Diudiasibake oi mafisane weisa. ");
INSERT INTO aby_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Weisaro ibake Diudiasima Yesu do mafine daaba yodia ukeibi. Dawa arara me eme keuwere ibai iwoka ukeka ibake yodia ukeebe i daaba fou uri. ");
INSERT INTO aby_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Godima i Isaraera orounu Idifiroma waure aneka banau odo idua fari. I furoe ure wawareka iraa yisidi ode me buredi iseibisake i banaunu mamoe abunaku una deidemu kuaiyama ureibisa. ");
INSERT INTO aby_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Enoba Yesuma Fidaini Dionibake eno wei, aniawake i banau uke bou ukeibiawaro iya aafero ife wei. ");
INSERT INTO aby_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yesuma eno weiro emuama Dawabake eno weisi, aboro ane uke bou ufuku weisi? ");
INSERT INTO aby_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eno weisiro Yesuma nono wei, i goiro aniawake moi adua kore aneifeku mi efuaisiie danu umuro aniawa wei. ");
INSERT INTO aby_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ane danu uwara ubarenaro amufuaisiie i uwara ubi mibairo eno weawa, uwanu Sisa mima wenua, anu awaawa orou faraisake yauraisa dubodei ooru we siboaro iro Naini Nanu iwoka ukeka orouini iyama iro ibaada i banau uruna ife eno wenua, weawa wei. ");
INSERT INTO aby_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eno weawaro yabake moi dai ooruini uruna iseka sebo ma iwoka ufiaro iro ibaada iyanu uruna uke bou ukeibiawa wei. ");
INSERT INTO aby_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eno weiro anisike Danu wei enaenari ekike i uruna uke bou ukeibisi. ");
INSERT INTO aby_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","I banau uruna iseka odo idua fariro Yesuini Danu afasoro orouini emua i uruna ifisane yauka. ");
INSERT INTO aby_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yaukake Yesuma emuabake eno wei, Nanu oferi waureka odo idua fafine ukakuba ibake yaini yewa uruna isenewaa umane weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yabake Nanu ba wake wemaro nauawe wei. Yewa isakuneie feamauke nono yewa banau uruna da ise ibeimauro Godinu yawokaku odo fafekuie ai nono imaua wei. ");
INSERT INTO aby_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesuma eno weike nono waini fanigini munike Godibairo we ma irauaiai uike emuabake wei, yewa fanigini muaweke ya yaisina iawe wei. ");
INSERT INTO aby_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yabake Nanu ba wake wemaro nauawe wei, Nae i naadidi kai iduda nono da ise ibeimauro Godinu yawokaku odo fafekuie yaini idua nono ifeisia eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesuma eno weike i buredi munike Godibairo we ma irauaiai uike ma birabira yarike emuabairo makaada eno wei, yewae Nanu oferoma nono yabake ma birabira yarakunea isaada Na imukeibiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Uruna ise me sikaro Yesuma i fanigini munike eno wei, yewa faniginie Nanu awoena arararo uke makaneka iwa, enoba ie yabake isafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yesuma eno weike nono wei, Na we sibofaraku mini yewa seboro demuiro yaure ibinisua eawe wei. ");
INSERT INTO aby_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I Ba Eme Sini Mima feafekua Godima eno weakuba ibake enaenari feafekua wei. Nono Na we sibofaraku miye Godima fanisi daiwere mafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesuma eno weiro Danu iwoka ukeka orouma emenu emenu we makanada eno weisa, ainama i ari eno ufeku weibisa? ");
INSERT INTO aby_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesunu iwoka ukeka orouma bebekuma wake we makanada eno weibisa, iyanu ibinisi kuro aina mima daiwere sifeku weibisa? ");
INSERT INTO aby_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eno weibisaro Yesuma emuabake ma owerike eno wei, i imusu yawokeka dai orouma emenu waiya ukeka orou arawere yawokakunekaroma nono emenu waiya ukeka orouma emuabakeye iyanu irauaiai yawokaisa oroua wefisane ibake eno uke yawokaisa. ");
INSERT INTO aby_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nono yabairoe eno me. Yabairo yanu dai miye okoanaku ari sinakuke nono dawae yanu waiya ukakua wei. ");
INSERT INTO aby_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","I sebo ubiubinaku yaure ibaada uruna isaku mi dawae daiwerero nono i urunabake waiya ukaku mi dawae okoanaku. Nono yabairo Nae yanu waiya ukakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Yesuma emuabake nono wei, Nabairo awe waa fareibaku odo odoro yama Nabairo ibeibaisaba ibake Nanu Babaema Nabake yawokeka orofa makara enaenari yabake makakuniaya wei. ");
INSERT INTO aby_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yama Nanu yawokeimau oroforo Nanu seboro yaure ibaada Naini urunaini aduaini ifoisake nono i Isaraera orounu naiyemuku dueronu (12) orou yaisina yama yawokeifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Yesuma Fidabake eno wei, Saimoni, emema uidi kaibai saboroma kore sianaisaro oyauma ifuru afuru ure fufuke sianaku enaenarie seidanima danu ararae ya orou yanu imuka ma nuna ufiaro yanu irau imukeka me sifine ukakuba ibake Godibairo abake guriguri une. Nono dubuenaro anu imukeka Godibairo ma owefakuie anu naiyemukunu imukeka ma ara ua wei. ");
INSERT INTO aby_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eno weiro Fidama wei, Dai Waria Mi, Aini ana ebaro animaua wei. Aini fearenewaa umaua wei. ");
INSERT INTO aby_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eno weiro ibake Yesuma wei, Fida Nanu wake naua wei. Kokoroko yama we dauke ibifekuro ako Nanu ibi buuba we ma fe yaraada Dawa na iwoka meya eno meo wefakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuma Danu iwoka ukeka oroubake eno wei, adinaro ya we odaiyero fausini yoakeini moi umu fogowoini mune dauisake anisa. Yanu anisaie irauba me? Eno we nauke eriebaie iyanu anekae irauaiaiya eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eno weisaro Yesuma eno wei, awoenae i fausini yoake bobo orou ya i erabusaini waure aniaweke ba bau me orou emenu dubo barukeka make oi muaweke ba bau oima make muawe eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eno weike nono wei, Godinu bukaroma Nabake eno weaku, Dawaini i meramawere orouini emuae demuiya eno weaisaya weakua wei. Idua Godinu bukaroma Nabake eno owaowa uke oisaro ibinuba enaenari ufekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesuma eno weiro emuama eno weisa, Dai Waria Mi, ba bau feka raara yewadoya ea weisabaie iduaya mediawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu i uwara ubarenaro isarike Danu adinaro Oriwa oraararo amuke aneibi enaenari amuke aniro Danu iwoka ukeka orouma Danu umuro amuke anisa. ");
INSERT INTO aby_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iro amuke ane fakaro Yesuma emuabake eno wei, guriguri uawe ukeebe meramawere munao ufoisake meramawere unao ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Yesuma eno weike emua medirieke yafawere me ekanaku eka ani. Anike ifoma kodudu yanaike guriguri ukaada eno wei, yewa merama ure yanakewere wadada adua ari, Nabairoma mufane wefakuie mua wei. Eno weike nono wei, Nanu arararo da uake Anu ararama ua wei. ");
INSERT INTO aby_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Ureroma aneru Yesubairo me ari uke isare aarike Yesu ma arabi ui. ");
INSERT INTO aby_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma arabi uiro Yesuma imuka oferi daiwere waurike guriguri ukenewaa uiba ibake Danu wadada iwa arie dooro isari.) ");
INSERT INTO aby_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesuma guriguri ukeebe medike uyarike Danu iwoka ukeka oroubairo owere ane farike eribaie emua imuka merama uisake nauka aine ibisaro fare erie. ");
INSERT INTO aby_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Emua fare erieke eno wei, anemebake nauka aine ibinisa wei? Uyaeweke guriguri uawe ukeebe meramawere uke ereka yabairo fanao ufekuro meramawere unao ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","48","Yesuma eno weibibaie eme keuwere dawabairo aare faka. Diudiasi moi duero (12) iwoka ukeka mi dawako fariro nono i orou yaisina danu umuro aare faka. Fakaro Diudiasima Yesubairo farike Yesu yabaike oo uiro Yesuma dawabake eno wei, Diudiasi, i Ba Eme Sini Mibairo oo ukakuie i uraneka orou Dawa mufisane waure faraada ibake i ubu i ari eno ukakua wei? ");
INSERT INTO aby_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Danu iwoka ukeka orouma i orounu imukeka iwoka uisake Yesubake eno weisa, i orouini urafeisia weisa? Iyanu ba bau yewadoya ea weisa. ");
INSERT INTO aby_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eno weisake moi iwoka ukeka mima ba bau munike i dai ofereni ode sibore sianeka minu waiya ukeka moi minu baena ome kaka umane kasiniro dooro isari. ");
INSERT INTO aby_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eno uiro Yesuma eno daua weike i waiya ukeka minu ome dooro munike ma dabame odike ma wiroi. ");
INSERT INTO aby_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eno uike Yesuma i dai ofereni ode sibore sianeka orouini dai sosi uwara furisi kafudenini i Du dai orouini, Dawa mufisane faka oroubake eno wei, Nae waira ukeka mi mebairo anemebake ba bauini goreini waure faraisa wei? ");
INSERT INTO aby_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eno weike nono wei, i dai sosi uwararo yabairo ibeibisara i furo Na mune naama umu wana uwane dayakakema nono awoenae yanu odo farinuro ibake eno ukaisaya weike nono wei, awoenae seidaninu bunaroba ibake eno ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","I orouma Yesunu wanaro mukake anisa. I dai ofereni ode sibore sianeka orounu uwararo waure ane oisa. Emuako anisaro Fida dawae yafawereroma eroke eroke emenu umuro ani. ");
INSERT INTO aby_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","I orouma goiro anisake i goi naisaro inaa mawaisake inaa udiro yaure ibisaro Fida dawaini inaa udiro fare yauri. ");
INSERT INTO aby_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Inaa edororo yaure ibeebe waiya ukeka moi aruma unama Fida erike ereebe eno wei, yewa mi dawae Yesuini demuiro ibisia wei. ");
INSERT INTO aby_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eno weibaie Fidama wei, yewa aruma, nae i Mi Dawa iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yaure ibeebe nono moi mima wei, yewa mi dawae Yesunu moi iwoka ukeka miya wei. Eno weiro Fidama nono wei, yewa mi na iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yaure ibeebe nono moi mima nono wei, yewa mi dawae Gareri miba Yesuini demuiro ibeibisia wei. ");
INSERT INTO aby_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Eno weiro Fidama wei, yewa mi na iwoka meya weike anu weaku wake na iwoka meya weibibaie kawama kokoroko idua yama wei. ");
INSERT INTO aby_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Kokoroko yama weiro Yesuma owerike Fida eribaie Fidama Yesunu kawama kokoroko yama weifekuro ako Nanu ibi buuba we ma fe yaraada meo wefakua eno wei wake imuike aweawero anike ii wei. ");
INSERT INTO aby_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu yabaisake mune anisa orouma Yesu uke iruke ma iruke ukaada usima uka. ");
INSERT INTO aby_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Emuama Yesunu naisa wauma dadau uisake wanama uraada eno weisa, ainama A uiyainu weibisa? We foraaro naufe weibisa. ");
INSERT INTO aby_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eno weada moi meramawere wake keuwere weada Dawabake meramawere uke yaka. ");
INSERT INTO aby_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wai uriro Du orounu dai kanisoro orouma midini uisa. I dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini dai orouini emua yaisina kanisoro midini ufisane uisake Yesu mune emenu ibooro ma enare oisa. ");
INSERT INTO aby_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Ane fakake Yesubake eno weisa, Ae i ba Kerisobaie wearo naufe weisa. Eno weisaro Yesuma emuabake ma owerike eno wei, ie wemauroma Nanu wake naukeroma imuke giena dafoisake Nanu we nauke emiau wake moko da wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eno weike nono wei, Awoenae i Ba Eme Sini Mima i bunama imusu ari Godinu baena wana enaro yaufekuro efoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","71","Eno weiro emuama eno weisa, Ae Godinu Amaraya weaku weisa? Eno weisake nono weisa, Danu wenu wake naukisiba moi weforakeka wake da naufeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I kanisoro orou yaisina uyakake Yesu mukake Faeradibairo waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Waure ane fakake wayai eno weisa, yewa miye Du orou yaisina we irukakuneke dakesi oi Romani gaemani oroubairo da mayakawe weakuke Nae Kerisoya, yanu dai yawokeka Kini miya weakua eno wayai weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eno weisaba Faeradima Yesubake eno wei, Ae i ba Du orounu dai yawokeka kini miba me wei? Eno weibaie Yesuma a ba weakua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eno weiro Faeradima i dai ofereni ode sibore sianeka orouini i fare ku siane ibisa oroubake eno wei, i mibairo merama ufibai fou ure daunea wei. ");
INSERT INTO aby_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eno weiba i orouma daiwere eno weisa, i Diudia orofa orouini Gareriroma ewa enaro ibeibisa i orou yaisina i Romani gaemani orouini urafisane eno meo we ma iwoka ukakunea eno meo weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Eno meo weisaro Faeradima nauike eno wei, i mi dawae Gareri miba me wei? ");
INSERT INTO aby_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eno weibaie euwa weisaba ibake Faeradi danu ararae i orouma Yesu Erodibairo waure anifisane wei. Erodima Gareri orofa yawokada i furo Derusaremu goiro ibeibiba Yesu dawabairo waure anifisane wei. Eno weiro danu wei enaenari waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodima Yesu efine ukeibiro dawabairo waure fakaro Yesu erike rooro ui. Erodima Yesunu buna ukeibi wake nauike danu ararae moi buna ukeka efine imui. ");
INSERT INTO aby_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Enoba Erodima Yesu moi buna ukeka ufiro efine keuwere we nauke ereibiroma Yesuma moko wake we daui. ");
INSERT INTO aby_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Erodima eno weibibaie i dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini emuama meo wayai daiwere weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eno weisaro Erodini danu ame orouini emuama Yesu meramawere uke yaraada uke iruisake irau wau baruke oisake Yesu ma owekake Faeradibairo nono waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Adinaroe Erodini Faeradini emuae moko moko emenu emenu wasai uke makaneibisikema nono i odoro awaawa uke makaki. ");
INSERT INTO aby_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Faeradima weiro i dai ofereni ode sibore sianeka orouini i darawadu we ma iwoka ukeibisa orouini i orou yaisina dawabairo ane fakaro emuabake eno wei, yewa miye nabairo waure aare oisake Dawae i Du orou yaisinabairo merama ukakua weisaba ibake Dawabairo we nauke erenewaa uneke Dawabairo merama fou ure daunea eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Enaenari Erodini dawae Dawabairo merama fou ure dakinuba Dawa nabairo ma owere odaisinua wei. Eno weike nono wei, Dawabairo merama meba Dawa da ma feamaua wei. ");
INSERT INTO aby_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Merama meba wemauro usima Dawa daiwere ufeisake odaifeisaro anifekua wei. ");
INSERT INTO aby_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(I Du orounu bisarae eno, moi oya fareibakuie ana ebaro ibaisa orou una demuinaku ma woromeibakunekaro aneibaisa.) ");
INSERT INTO aby_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Enoba Faeradima weibaie i orou yaisinama daiwere eno weisa, i mi dawa ma feake Barabasi naa ma woromiake iyabairo waure aare odia weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabasi dawae Du orouini Romani gaemani orouini urafisane weike eme ma feariba ibake ana ebaro oisaro ibi.) ");
INSERT INTO aby_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Faeradima Yesu medifiro anifine uike i orou yaisinabairo weibaie i orouma daiwere eno weisa, korosiro ikokama ure odia, korosiro ikokama ure odia eno mane weibisa. ");
INSERT INTO aby_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Faeradima dei raara weike nono wei, dawae aneme merama ukinu wei? Dawabairo merama meba da ma feamauke wemauro usima ureebe odaifeisaro anifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Faeradima eno weibaie Dawae korosiro ikokama ure odia eno daiwere weisaba ibake Faeradima Yesu feafekua wake idua wei. ");
INSERT INTO aby_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Fearadima Yesu feafekua wake idua weike Barabasi i urane rarane uke eme ma feareka mi ana ebaroma ma worome odairo i orouma Yesu emenu arara aneme ufisane ufeisa ibake Faeradima Yesu emenu wanaro marie. ");
INSERT INTO aby_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","I orouma Yesu mune anisa. Waure aneibisabaie Sairina orofa moi mi Saimoni dawae waiyaroma aare fariro ekake eno weisa, ama Yesunu korosi waua weisa. Eno weisaro Yesunu korosi mune wauriro anisa. Anisaro i mi dawae Yesunu umuro ani. ");
INSERT INTO aby_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","28","Eme keuwere emenu umuro anisa. Awekabo moima sorara ukaada aneibisaro Yesuma ma owerike i awekabo erieke emuabake eno wei, ya Derusaremu goi awekabo, Nabake ii da weaweke yanu onarouini yanu amarakubake ii weawe wei. ");
INSERT INTO aby_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","30","Moi merama odo yabairo fafekuro emema wefeisa, i amara aruma me awekabo rooro ufeisaya eno wefeisake nono wefeisa, i dai oraaraini okoa oraaraini boaweke iya ode kariawero feafe wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nae i awoena au ibaaku ana ari eno ukeibakuneba yae i sibi uraku ana ari ibake merama daiwere uke yafiakaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Moi merama uisike ana ebaro ibisi miyaini Dawaini demuiro ma feafiakane emua waure anirieka. ");
INSERT INTO aby_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Emua waure aniriekake bokai kaibai mane weaisa orofaro faka. Fakake Dawae korosiro ikokoma ure dabame oisa. Nono moi ana ebaro ibi mi moi ena anaro ikokoma ure dabame oisake nono moi mi moi ena anaro ikokoma ure dabame oisake Yesu Dawa ubarero ikokoma moi anaro ure dabame oisa. ");
INSERT INTO aby_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eno uke odiriekaro Yesuma eno wei, Babae, emenu ukaisa ibai emua iwoka meba ibake eno ukaisaya emenu ba me ukeka mune imuke media wei. I orouma eno uke oisake Danu wau ainama mufeku ariya weisake kasi dodoo uisa. ");
INSERT INTO aby_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","I ku siane ibisa orouma enare ibaada ereibisabaie i Du orou emua yawokeibirieka orouma we irukada eno weibisa, Dawama eno i ari weia weibisa, Nae Godinu ma wiroke mune aneka Miya, Godinu Kerisoe Naya eno weibike moi orou ma wirokeibirie enaenari Anu onami ma wiroa eno weibisa. ");
INSERT INTO aby_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","I ame orouma Dawa uke irukada arawere ana kai idudabai Dawa ifine maisake eno weisa, Ae i ba Du orou emenu dai yawokeka Mibaie Anu onami ma wiroa weisa. ");
INSERT INTO aby_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Moi wake eno owaowa uke oisa, yewae i Du oronu dai yawokeka kini mi eno owaowa uisake Danu iiri oko korosiro ure dabame oisaro ibi. ");
INSERT INTO aby_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Moi ana ebaro ibeibi mi dawae moi ena korosiro ibaada Yesubake eno wei, Ae Godinu Kerisoba me? Anu onamini uwaini ma wiroa wei. ");
INSERT INTO aby_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Eno weiro nono i moi ena korosiro ibi mima dawa we iifa ukaada wei, eno da wea wei. Ae Godibake ia iyarakuba me wei? ");
INSERT INTO aby_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eno weike wei, aini naini uwae ba meramawere uisuba ibake aido fearaisua wei. Nono yewa miye moi meramawere uke dauia wei. ");
INSERT INTO aby_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eno weike nono wei, Dai Waria Mi, Anu yawokeifaku odo fafekuie na imukenewaa ufario wei. ");
INSERT INTO aby_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","I mima eno weiro Yesuma dawabake moko eno wei, awoenae aini Naini demuiro i irauaiai Faradaisi weaisa oroforo ane ibifukua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Eweka amuke aare okoro farike edoro dauike dumu sine ibiro eweka ma owerike ane abanaro fariro idua nono edoro ui. I dai sosi uwara ubarenaro ooru raarayai enare kuure oisa ena dai burudu wau abanaroma gagane isare aare ubiro fari. ");
INSERT INTO aby_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","I yaisina eno uiro Yesuma daiwereroma eno wei, Babae, Nanu imumu Anu wana duboro odakunea weadae idua feari. ");
INSERT INTO aby_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eno uiro ame kafudeni mima erike Godinu ibi we ma daiwere uike eno wei, yewa mibairo merama meya wei, Dawae irauaiai miya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ibai efisane fare ku siane ibisa orouma ibai ekake Yesu feariba ibake imuka merama daiwere ukaada emenu goi goiro fiake anisa. ");
INSERT INTO aby_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","I Gareriroma faka awekaboini Yesunu naiyemukuini emuae ekararowere bi mame ibaada iroma ibai ereibisa. ");
INSERT INTO aby_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Moi Arimadia goi mi Diosefu dawae moi kanisoro mi, dawae Godinu wake naukeibi. Dawae irauaiai mi. Dawae Godinu yawokaku odo yawokeibi. Adinaro i moi kanisoro orouma Yesu ma feafisane weisaro nono dawae arara me Yesu ma feareka. ");
INSERT INTO aby_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","53","Enoba i mima Faeradibairo anike Yesunu ofe mufine eenu weike Yesunu ofe korosiroma munike inanakeo wauma oba ui. Oba uke me sinike awoena oma eraboro ane odi. Iro moi feareibisa orou ode dakeibirieka, dawama Yesu i oma eraboro ane odi. ");
INSERT INTO aby_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iro waure ane odiro i sabadi odobake uke bou ukeka odo idua me sifine uiro i sabadi odo idua fafine ui. ");
INSERT INTO aby_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","I Gareriroma Yesunu umuro aaka awekaboma Diosefunu umuro anisake i Yesunu ofe ane odi orofa eka. ");
INSERT INTO aby_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ane ekabaie Yesunu ofe idua oisaro ibiro eka. Ekake owekake emenu uwararo anisa. Owere ane fakake Danu ooru ukeka irauaiai urumuma imusu ari fauduini aduaini mune bou uisa. Eno ukeibisabaie sabadi odo fariba ie Godinu darawadu odoba meisake ko yaka. ");
INSERT INTO aby_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabadi odo me siniro wai awanakuro i awekaboma uke bou uisa eraerabusa mukake i ooru ukeka orofaro waure anisa. ");
INSERT INTO aby_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ane fakake ekabaie i aisame dadau uke oisa oma ubere aine ibiro eka. ");
INSERT INTO aby_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I dadau uke oisa oma ubere aine ibiba ibake i oma eraboro isakake ekabaie Yesunu ofe iro me! ");
INSERT INTO aby_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I awekaboma Danu ofe aboro waure anisa ariya weisake idua enare ibaada imukeibisabaie moi inanakeo wau ruki miyai emua udiro enare ibisi. ");
INSERT INTO aby_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Idua enare ibisiba ibake i awekaboma ia siriero ifoma kodudu yanake ibisaro I miyaima eno weisi, i feare mero me ibeka orou anemebake i fearaisaro aare odakuneka orofaro yodia ukaisa weisi? ");
INSERT INTO aby_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Eno weisike Dawae ewado ibe meya weisi. Dawae uyarike me ibinua weisi. Ya yaisina Gareriro ibisa furo Dawama yabairo eno weia weisi, i Ba Eme Sini Mie i meramawere orounu wanaro mame odifeisaro Dawa ma feafeisaro odo buuba me sifekuro nono uyafekua eno weia weisike nono weisi, ya ibai imukaisaba me weisi? ");
INSERT INTO aby_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Eno weisiro Danu wei wake i awekaboma imuisake i eme ara meisake owere anisa. Anisake i iwoka ukeka orou irewenini (11) moi orouini emua yaisinabairo ibai yaisina weisa. ");
INSERT INTO aby_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","I awekabonu ibi ibiye Meri Megidarini Doanaini Deimisinu amae Merini moi awekaboini emuama i afasoro oroubairo i wake weisaro nauisakema emuabairo i wakeye baya we imuke dauisa. ");
INSERT INTO aby_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nono Fida dawae danu mane i orofa ubi ure efine ibake i ooru uke oisa orofa efine durame ani. Ane farike eu afua umane i oma erabo eribaie i ane oisa orofaro Dawa oba uisa wau mane ibiro erike owerike ibai yaisina imukaro imukada sabu owerike uwararo ani. ");
INSERT INTO aby_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","I dai fura odoro Godinu wake naukeibisi miyaima Derusaremu goiroma Emeiasi goiro isare aneibisi. ");
INSERT INTO aby_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","I daabaro isare anaada Yesu me sini wake we makane isare aneibisi. ");
INSERT INTO aby_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eno we makane isare aneibisiro Yesuma emua fare fou uriero emuaini demuiro isare anisa. ");
INSERT INTO aby_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eno uke demuiro anaadama nono Godima i miyai Yesu iwoka ukekabai dadau uiro ibake Yesu ma nuna uisi. ");
INSERT INTO aby_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","18","Yesuma emuabairo eno wei, aneme wake weada anaisi wei? Eno weiro i miyaima imuka merama daiwere uisike moi mi iboo imusu nauwaro odiro nono moi mi danu ibiye Kiriofasi, dawama Yesubake eno wei, i Derusaremu goi orou yaisina i yaina odo uisa ibai emua yaisina iwoka sinaisaro nono ade aneaneme ibai a iwoka me wei? ");
INSERT INTO aby_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eno weiro Yesuma emuabake ma owerike eno wei, aneme uisabaie wei? Eno weiro emuama eno weisi, Yesu Nasaredi goi mibake weaisua weisi. Dawae Godinu bunawere we bou ui miya weisi. Danu buna ukeka keuwere ukeibiro Godinu emeini Dawae irauaiai Sisa miya eno we imukeibisaya eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iyanu dai ofereni ode sibore sianeka orouini i Du orounu yawokeka orouini emuama Dawa feafine weisake Romani gaemani orounu wanaro mame odiriekaro emuama korosiro ikokama ure dabame oisa. ");
INSERT INTO aby_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eno uisaro iyama we imuisi, Dawae Isaraera orounu ma wirokeka miya eno we imuisi. Nono Dawa feariro odo buuba me sininua eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Iyanu moi Godinu wake naukaisa awekaboma eweira wai awaro i eme araro anisake iroma owere farisake eno weisa, Danu ofe iro ibe meya weisa. Nono kubekuberoma erisibaie aneru unu raarayaima iyabairo eno weisi, Dawae uyarinuke me ibinua weisia i awekaboma iyabairo eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","I awekaboma eno weisaba ibake moi orou emuae i orofa efisane durame anisake erisabaie i awekabonu erisake weisa enaenari mane erisaya eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","I miyaima eno weibisiro Yesuma emuabake eno wei, ya awara me miyai! Godinu we bou ukeibirie orouma Godinu bukaro wake keuwere owaowa yanake odeibisade anemebake ibai erenewaa dauisi wei? ");
INSERT INTO aby_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","27","Godinu we bou urie orouma eno weisa, Godinu Kerisoma imuka oferi waufekuke feafekuke nono iroma uyafekuke Danu irauaiai arakekawere orofaro amuke anifekua weisaya eno wei, Yesuma eno weike nono wei, Mosesini Godinu we bou urieka orouini emenu bukaro ibinu wake Dawabake wake emuabairo weada i wakenu ubi wenewaa ukaada eno ui. ");
INSERT INTO aby_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Yesuma eno we aneibiro aneebe goiro fafisane uisa. Goiro fafisane ukaada Yesuma emua ma berefiane uibaie Dawa we kuurada eno weisi, dumu sinao ufekuba uwaini demuiro ibifeisia weisi. Eno weisiro Yesuini emuaini emenu uwararo anisa. ");
INSERT INTO aby_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Uwararo ane fakake uruna ifisane yaukaro Yesuma Godibairo guriguri uike uruna munike ma birabira yarike naka naka ui. ");
INSERT INTO aby_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eno uiro i miyai emenu naisa idua foranao uiro ekike Dawa idua iwoka siki. ");
INSERT INTO aby_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwoka sikiro Dawa emuabairoma me ari ui. Eno uiro i miyai emenu emenu eno we makanada weisi, daabaro aaradae Godinu bukaro wake wenuro naukisuke uwanu imuka irauaiai ukinua eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Enoroma nono i miyaima emenu uwara meisike iroma Derusaremu goiro amuke anisi. Derusaremu goiro ane fakiro i iwoka ukeka orou ireweni (11) Yesunu umuro eneiareibisa orouini emuama i miyaibairo ma owekake eno weisa, iyanu Dai Waria Miye uyarinua weisa. Dawae uyarinuke Fidabairo farinua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Emuama eno weisaro i miyaima daabaro fou uki wake wake weisike Yesuma uruna ma birabira yarinuro erisuke Dawa iwoka sinisua eno weisi. ");
INSERT INTO aby_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","I miyaima eno weibisibaie Yesu Danu mane me ari uke emuabairo farike enare ibaada arie wake wei. ");
INSERT INTO aby_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eno uiro i orouma yewae imumu erisia weisake ia daiwere sika. ");
INSERT INTO aby_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eno uisaro Yesuma emuabake eno wei, anemebake ia sinaada Na ma nuna ukakuneka wei? ");
INSERT INTO aby_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nanu umuini wanaini eawe. Ie ba Naya wei. Yanu wanama Na ure burise eaweke iwoka siawe wei. Imumu emuae damaini kaini me. Nono nae damaini kai boboya eawe wei. ");
INSERT INTO aby_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eno weike Danu umu wanaro uka ena iwidi awidi emua efisane ma iwoka urie. ");
INSERT INTO aby_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yesuma eno uiro i orouma rooro daiwere ukaada ma nuna uisake ibai imuisaroma nono Yesuma emuabairo nono wei, yabairo uruna ibinuba me wei? ");
INSERT INTO aby_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Eno weiro Dawabake aisa yaka aduaro abu maisaro munike emenu ibooro iseibiro eka. ");
INSERT INTO aby_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesuma emuabake eno wei, imuke eawe! Adinaroe yabairo ibaada Mosesini i we bou urieka orouini emenu Samusi bukaro Nabake weibisa wake enaenari ufekua weibisara. ");
INSERT INTO aby_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Ie enaenari idua ukinua weike Godinu bukaro wake we ma boroo yaraada eno wei, adinami nauwaro emema eno owaowa uke oisa, Godinu Kerisoma imuka oferi waufekuke feafekuro odo buuba me sifekuro nono uyafekua eno weisa. ");
INSERT INTO aby_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Godinu wirokeka wake i orofa akaka orou yaisinabairo we eneifeisa. We eneifeisaro ainama danu merama ukeka imuke medifekuie Godima danu ba me ukeka mufekuke imuke medifekua eno wei. I wake Derusaremu goiroma aboro aboro yaisina iro we eneifeisaya eno owaowa yanake oisaya wei. ");
INSERT INTO aby_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Emenu owaowa yanake oisa enaenari ukinuro yae ibai eraisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Godinu we bou ui enaenari Danu Imumu Irau yabairo we odaimauro isare aafekua eno wei. Yewa goiro ibiawero Dawa isare aafike Godinu buna yabairo makenewaa ufia Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Yesuma emuabairo eno weike Derusaremu goiroma Bedeni goiro aniro Danu iwoka ukeka orouini imusu orouini eno Danu umuro anisa. Dubuenaro Yesuma Danu wana ei mamaada i orou yaisina we ma irauaiai uriero Godima Dawa urero waure amuke ani. ");
INSERT INTO aby_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","I orouma owekake daabaro aarada rooro daiwere ukeuke Derusaremu goiro anisa. ");
INSERT INTO aby_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ane fakake aine wai ure i dai sosi uwara ubarenaro aneibisake Godinu ibi we ma daiwere ukeibisa. ");
INSERT INTO aby_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Adinami nauwaro dooini ure ubu uke me i furo yewa wakeye ibeibi. Yewa wakeye Yesu Keriso. Nono yewa wake Dawae Godibairo ibeibi. Yewa wake Dawae Godi. ");
INSERT INTO aby_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Adinaro dooini ure ubu uke me i furo yewa wakeye Godibairo ibeibi. ");
INSERT INTO aby_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dawama i eraerabusa yaisina ubu ui. Godima weiro Dawama i eraerabusa yaisina Danu mane ubu uiro i eraerabusa moinakuma me sara fare dauisa. ");
INSERT INTO aby_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Enoba Dawae i me ibene ibene ibekanu ubi. I me ibekanu ubiye Yesu Dawa eme emenu edoro ibake Dawa iwoka ukaisa. Emema i edorobairo faraisake Dawa iwoka sinaisa. ");
INSERT INTO aby_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I edoroma dumuro edoro daiwere ukakuro dumuma i edoro ma bereke dakaku. ");
INSERT INTO aby_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Godima Danu fo weeka mi Dioni babadaido ukeka mi we munike odairo danu ibeibi orofaro fari. ");
INSERT INTO aby_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dawama i edoro wake wefiro eme yaisina naufisake Yesunu daabaro anifisane ibake fari. ");
INSERT INTO aby_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dioni dawae i edoro me. I edoronu wake wefine ibake emebairo fari. ");
INSERT INTO aby_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I ba edoro idua farike eme yaisina edoro ukakune. ");
INSERT INTO aby_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Godima weiro Dawama i orofa akaka eraerabusa yaisina ubu uike yewa dooro farike ibiro yewa orofa akaka orouma Dawa ma nuna uisa. ");
INSERT INTO aby_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dawae Danu Isaraera oroubairo farike ibiro eme keuwere Danu wake nauke dauisaro dai me bonakuma Danu wake nauisake emenu awararo oisa. ");
INSERT INTO aby_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Danu wake nauisake emenu awararo oisa oroue Dawama emua Godinu amaraku we odirieke buna mariero Godinu amaraku sika. ");
INSERT INTO aby_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Danu wake nauisake emenu awararo odaisa oroue emenu amaemukuma awoena dorakuneka ari sinaisa. Emenu babaemukunu iwa barunama emua ubu uke mero nono emenu ararama emua ubu uke me. Emenu ofema emua ubu uke mero Godinu imukekama emua nono awoena ubu uriero emua Godinu amaraku sika. ");
INSERT INTO aby_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I Wakeye Ba Eme Sinike iyabairo ibaada Dawama iyabake imukari daiwere ukaada nono Dawae i ba ukeka sinekanu ubi. Danu arakekawere iya ekiba ibake Dawae Godinu amara ubiya weada Dawae arakekawereya weaisi. ");
INSERT INTO aby_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dionima Dawa erike i ku uke ibisa oroubake eno wei, nanu weibisara mi idua farinua eawe we. Weke nanu wake nauawe eno we, nanu umuro aafekua we mi idua farinua weya wei. Dawae daiwere na ari eno me. Dawa adinaroma ibeibiro nono nae nanu amaema na ai dubuenaro dokara weya Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dawa iya yaisinabake imukari ukakunike aine wai ure unu koraada iya we ma irauaiai ukakuniro me irauaiai ibinisia eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesima Godinu darawadu iyabairo ma’iro nono Yesu Kerisoma iyabake Godinu imukari ukekaini ba irauaiai wakeini ma’i. ");
INSERT INTO aby_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moi mima Godi ere da uiro Danu Amara ubi, Godini demuiro ibisi Mi, Yesu Keriso Dawama Godi erike iyabairo i wake yaisina we ma boroo yaria Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","I dai Du orouma moi ofereni ode sibore sianeka orouini i dai sosi uwara yawokeibisa Riwai weaisa orouini emua Derusaremu goiroma we odairiekaro Dionibairo fakake eno weisa, ae ainadei weisaro Dionima bunawereroma eno wei, nae i Keriso meya wei. Godima Dawa we odaifekuro fafekuke i Du orou unu kofiaku. Nae i mi meya wei. ");
INSERT INTO aby_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eno weiro emuama nono weisa, ae Iraidaba me weisabaie Dionima nae Iraida meya wei. Eno weiro emuama nono weisa, ae i dai we bou ukeka miba me eno weisabaie Dionima ma owerike nono wei, nae i dai we bou ukeka mi meya wei. ");
INSERT INTO aby_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eno weiro emuama nono weisa, ae ainadei? Wearo iya naufeke iya we odaisa oroubairo ane wefero naufisa weisake eno weisa, anu onamibakede aneme weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eno weisaro Dionima ma owerike eno wei, Isaiyama nabake eno weia wei, nae i eme ibe me orofaro wake weakune mi. Nae eno weakune, i Dai Waria Minu daaba wabuke ma nabi uke ma gienabu uke bou ukeibiawe eno weakunea wei. Adinaro i we bou ukeka mi Isaiyama i orou yaisina emenu merama ukeka mune siafisane Dionibake eno we bou uia Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","I Ferosi orouini we odairieka orouini emuama anisake Dionibairo fakake eno weisa, nae Keriso meya, Iraida meya, i Godinu bukaro weaku we bou ukeka mi meya eno wenude nono anemebake babadaido ukakune weisa. ");
INSERT INTO aby_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Eno weisaro Dionima ma owerike emuabake nono wei, nae adua mane babadaido ukakuniaya wei. Nono yanu kuro moi mi enare ibinuro yama dawa ma nuna ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dawae nanu umuro aafekuro Dawae Dai Waria Mi enoba Danu iboo naisa da enare kuumaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dionima i Diodeni adua ekabokena Bedeni goiro eme babadaido ukeibiriebaie i wake yaisina dawabairo fakake eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nono moi odoro Dionima eribaie Yesu fareibiba Dionima eno wei, eawe, Godinu awoena mamoe weaisa mi idua farakua wei. Dawae yewa orofa akaka orou yaisinanu merama merama ukeka mufekuke mune siafekua wei. ");
INSERT INTO aby_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nae i Mibake adinaro eno we, Dawae daiwereke Dawako ibeibi i furo na dore me ibake nae daiwere meya wei. ");
INSERT INTO aby_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Adinaisae Dawa ma nuna ueke ya Isaraera orou yaisina Dawa iwoka ufone ibake ba aduama babadaido ukeibiaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nono Godinu Imumu Irauma ubari ada ari ureroma isare aarike Dawabairo ibiro ereke eno we imue, adinaro Godima nabake eno wei, Nanu Imumu Irauma moi mibairo isafekuro efakuie i mi Dawae Nanu Imumu Irauma babadaido ufekua Godima eno wei ibai we imue. ");
INSERT INTO aby_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dionima eno weike nono wei, i Imumu Irau isare aaribai na ereba Dawae Godinu Amara ubi una demuibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","37","Nono moi odoro Dionini danu iwoka ukeka miyaini demuiro eneibisabaie Yesu fare ani. Fare aniro Dionima eno wei, Godinu awoena mamoe weaisa mi eawe weiro danu iwoka ukeka miyaima naukike Yesunu umuro anisi. ");
INSERT INTO aby_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesunu umuro anisiro Yesu ma owerike emua eraada eno wei, anemebake aaraisi weiro emuama eno weisi, Rabai, anu uwara aboro weisi? I ibinu ubiye sisa mi. ");
INSERT INTO aby_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eno weisiro Yesuma wei, aare eawa wei. Aare eawa weiro Dawaini anisake Danu uwara eki. Ekike dumudumu siniba ibake Dawaini i odo demui idua ibeiyaki. ");
INSERT INTO aby_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dioni babadaido minu wake naui moi minu ibiye Enuduru. Dawae Saimoni Fidanu nabue. ");
INSERT INTO aby_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","42","I mima danu kaka Saimoni yodia ukeebe fou urike eno wei, i Mesaia i Keriso weaisa mi Dawa fou urisia weike danu kaka we waurike ane Yesubairo odi. Odiro Yesuma Fida eraada eno wei, ae Dioninu amara Saimoni. Abake moi awoena ibi Sifasu wemaua wei. Sifasuini Fidaini demui ibi. I ibinu ubiye okoa oma kainaku. ");
INSERT INTO aby_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nono moi odoro Yesuma Gareri orofaro anifine uike Firifu yodia uke ane fou uraada eno wei, Nanu umuro aara wei. ");
INSERT INTO aby_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firifuini Enuduruini Fidaini emuae Besaida goi orou. ");
INSERT INTO aby_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Enoba Firifuma Nadanero yodia ukeebe fou urike eno wei, Mosesini i darawadu bukaini we bou urieka orounu weaisa mi fou urisia eno wei. Diosefunu amara Yesu Nasaredi goi mi fou urisia eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Firifuma eno weiro Nadaneroma ma owerike eno wei, Dawae Nasaredi goi miya wei? I goiroma moi irau mi da aafekua wei. Eno weiro Firifuma wei, ai aarake ea wei. ");
INSERT INTO aby_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","48","Weiro aareibisabaie Yesuma Nadaneronu aareka ubu eraada eno wei, eawe, ba Isaraera irau mi yewadoya dawae meo we dakaku miya weiro Nadaneroma eno wei, aneaneme eraada na iwoka sinakunara wei? Eno weiro Yesuma wei, Nae a i boruba ana ubiro enare ibeiarinu i furo a enaaro aima Firifu abairo farinua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yesuma eno weibaie Nadaneroma wei, Rabai, Ae Godinu Amara ubi. Ae iya Isaraera orounu dai yawokeka miya wei. ");
INSERT INTO aby_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Dawama eno weiro Yesuma ma owerike dawabake wei, Nadanero, a i boruba ana ubiro enare ibeiarinubai eneke wene ibake eno imukaku wei? Moi buna ukeka yewa ari mero nono ba daiwere efakua wei. Eno weike nono emuabake eno wei, Nanu ba wake wemaro nauawe wei. Ure eba ufekuro Godinu aneruma Na, i Ba Eme Sine Mibairo isare aareifeisake amuke aneifeisaro efoisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Odo rarayai me siniro Yesunu amae Merima i aweka munekabake uisa banau i Gareri orofa Keina goiro anike yaure ibi. ");
INSERT INTO aby_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuini Danu iwoka ukeka orouini emua wayo koriekaro iro ane fakake yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","4","I banau iseka orouma waini adua ise me sikaro Yesunu amaema Yesubairo farike eno wei, moi waini meya emua unu koyana weiro Yesuma ma owerike eno wei, amae, anemebake Nabairo eno weaku wei? Nanu onami ma boroo yareka odo fare meya eno da wea wei. ");
INSERT INTO aby_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesuma eno weiro Danu amaema nauike i banau waiya ukeka oroubake eno wei, Danu aneaneme wefeku enaenari uawe wei. ");
INSERT INTO aby_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iro omama ubu uisa dai okea sikisi (6) idua enare ibisa. Okoananaku mero yafa kerokerowai okea sikisi idua enare ibisa. Du orouma uruna ifisane ukaadae adua koreibisake emenu guriguri ukeka bisara ibake i aduama emenu umu wana urokeibisa. ");
INSERT INTO aby_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Enoba Yesuma eno wei, i enare ibinisa okeawere werero adua iiawe weiro enaenari uisaro wake faka. ");
INSERT INTO aby_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Yesuma nono wei, dai menaku koaweke banau ubi mibairo ane maewero ise efi wei. Eno weiro enaenari uisake maisaro i banau ubi mima munike dai menaku i. Ise eriro ba aduama waini siniro aboroma farinu ari weike ma nuna ui. (Nono i adua koka orou emua mane iwoka sika.) I banau ubi mima ise erike weiro i aweka awoena mufine ukeibi mi i banau ubi mibairo fari. ");
INSERT INTO aby_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Fariro i banau ubi mima eno wei, yewa wainie irauaiaiya wei. I banau ukeka orounu bisarae imusu. Irau wainiko makakunekaro isaisake boana urakuneie merama waini dubuena ai makakunekaya wei. Eno weike nono wei, Anu irau wainiko make daunike ai dubuenaroma makakunia wei. ");
INSERT INTO aby_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I buna ukekae Yesu Danu dawako buna ukeka. I buna ukekae Gareri orofa Keina goiro uike Godima Dawabake mai dai buna idua ma boroo yariro Danu iwoka ukeka orouma ibai idua ekake emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yesu eno uike Keina goi medike Dawaini Danu amaeini Danu naburakaini Danu iwoka ukeka orouini emua yaisina Kafenamu goiro isare anisa. Isare ane fakake moi odoyai iro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Godima i Isaraera orou Idifiroma waure aneka banau uruna odo fafine uiba ibake Yesuma Derusaremu goiro amuke ane fari. ");
INSERT INTO aby_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amuke anike i dai sosi uwara ubarenaro amuike eribaie moi orouma ofereni odeka boromakauini mamoeini ubari adaini oima make muneibisaro nono moi orou oi oisa seboro yaure ibaada oi moko moko make makaneibisaro Yesuma emua erie. ");
INSERT INTO aby_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Erieke naa munike abu ureka uifi ubu uike i orouini abuini yoweriero me nauawaro fare anisa. Eno uike i oi moko makeka orounu i oi ibi sebo ma uree yariro i oi yaisina fiakaka yakake isaka. ");
INSERT INTO aby_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Eno uike i ubari ada make oi muneibisa oroubake eno wei, yewa yaisina me nauwaro waure aniawe wei. Eno weike nono wei, Nanu Babaenu uwararo sidowa uwara ari dauforo wei. ");
INSERT INTO aby_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuma eno weiro Danu iwoka ukeka orouma we imuisa, Godinu bukaro i wake eno ibinu, Godinu uwara imukenewaa ukakuneba ibake ima na ma merama ufaraku, i wakeye eno ibinua we imuisa. ");
INSERT INTO aby_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesuma i orou eno uke yariero i dai Du orouma Yesubake eno weisa, aneme buna ukeka ufakuro efeisike Ae ba Dai Miba ibake iya we yowenia eno wefeisia weisa? ");
INSERT INTO aby_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eno weisaro Yesuma wei, yewa dai sosi uwara ma doroo yafoisaro eweka odo buubaro nono ma enamau enaenaria wei. ");
INSERT INTO aby_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yesuma eno weiro nono weisa, yewa dai sosi uwara oya fodi sikisi (46) ma enarada ibeibisabairo nono anu mane eweka odo buubaro ma enafane weaku eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","22","Ie Yesuma Danu ofe ububake dubo waure weike weiroma nono dubuenaro fearike iroma uyariro Danu iwoka ukeka orouma Danu wei wake imuisake i wakeini Godinu bukaini nauke imuke uisa. ");
INSERT INTO aby_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Godinu i Isaraera orou emenu Idifiroma waure aneka banau uruna i odoro Yesu Dawa Derusaremu goiro ibeibiro moi orouma Yesu Danu buna ukeka ekake Dawae ba Godinu Amaraya we nauke imuke uisa. ");
INSERT INTO aby_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesuma emenu imukeka yaisina iwoka siniba ibake emenu wanaro Danu onami ode daui. ");
INSERT INTO aby_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dawama emenu imuka ubarenaro imukeka yaisina iwoka siniba ibake moi mima Dawabairo emenu imukeka imusu imusu we daui. ");
INSERT INTO aby_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","I Ferosi orounu darawadu yawokeka mi danu ibiye Nikodimasi dawae i Du orou emenu kanisoro mi. ");
INSERT INTO aby_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dawama dumuro Yesubairo farike eno wei, Rabai, Ae Godibairoma farike Danu wake weakuba iya iwoka sinaisia eno wei. Godima A we odaiaiba ibake farike buna ukeka ukaku enoba Ae ba Godibairoma fari iya iwoka sinaisia eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Eno weiro Yesuma ma owerike eno wei, abake ba wake wemaro naua wei. Ainama nono danu amaema awoena doreka ari da sifekuie Godinu irauaiai yawokaku orofa da efekua wei. ");
INSERT INTO aby_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Eno weiro Nikodimasima nono wei, Dai Mi, aneaneme nono danu amaema doreka ari eno awoena sifeku weike nono wei, aneaneme nono okoanaku sifekuke danu amaenu boana ubarenaro amufekuro nono danu amaema dawa owere dofeku wei? ");
INSERT INTO aby_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Eno weiro Yesuma nono wei, abake ba wake wemaro naua wei. Ainama aduaini Godinu Imumu Irauma awoena doreka ari me irau ibeka da mufekuie Godinu yawokaku irau orofaro da anifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yesuma eno weike nono wei, danu amaema amara dofekuro isafekuke eme sifekua wei. Nono Godinu Imumu Irauma moi mi awoena doreka ari eno ufekuro nono i mima Danu Imumu mufekuba i awoena wirokekae ureroma mufekua wei. ");
INSERT INTO aby_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Awoena danu amaema doreka ari dofeku wake wene ibake imuka foria da ufao wei. ");
INSERT INTO aby_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Oyau farakuke mameibakuro danu yama naukakuke danu fare aneibaku daaba ma nuna ukaku enaenari Godinu Imumu Irauma moi mi awoena munakuke awoena me ibeka makakuro ae ibai ma nuna ukakua wei. ");
INSERT INTO aby_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Eno weiro Nikodimasima wei, ide aneaneme uburo wei? ");
INSERT INTO aby_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","11","Nikodimasima eno weiro Yesuma nono wei, abake ba wake wemaro nono naua wei. Ae i Isaraera orounu moi sisa mide nono anemebake ma nuna ukaku wei? Iyanu erekaini imukekaini eraerabusa abairo weisiro mune dakaku ibake ma nuna ukakua wei. ");
INSERT INTO aby_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yesuma Nikodimasibake eno weike nono wei, yewa dooro oyau fare aneibaku imukeka wake abake wenero ma nuna ukinuba nono urenu imukeka wake abake wemauro aneaneme sabu iwoka sifaku wei? ");
INSERT INTO aby_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yewa dooro ibinu moi mima urero amuke ane daui. Na, i Ba Eme Sine Mima iro ibeebe yewa dooro isare aarea wei. ");
INSERT INTO aby_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Godima Mosesibake eno wei, gorudima waru ubu uaro aina ainama i waru efeisaie sara da feafeisa weiro nono Mosesima eme ibe me yao orofaro ubu uike usiro aiso odiro i waru eka orou feare dauisa. Enaenarie Na i Ba Eme Sine Mi korosiro ure odifokaisaro nono aina ainama emenu imuka yaisina Nabairo odifeisaie urero me ibene ibene ibifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godima i orofa akaka orou yaisinabake imukari daiwere uiba ibake Danu Amara ubi Yesu Keriso iyabairo ma’iba aina ainama danu imuka yaisina Dawabairo odifeisaie emua me sara da feafeisake me ibene ibene ibeifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Enoba Godima Danu Amara emebairo fanisi wake weroma feareka daabaro odifiane we odaise daurieke nono i eme yaisina Dawabairo aafisake wirofisane ibake we odaia wei. ");
INSERT INTO aby_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aina ainama emenu imuka yaisina Yesu Kerisobairo odaisaie Godima emua kodo da ufekuro me sara da feafeisaya Godima eno wei. Nono aina ainama emenu imuka yaisina Yesu Kerisobairo ode dakaisaie Godima emua kodo adinaro urieke feareka enaro mune odirieba ibake emua me sara fearaisa. Enoba emuae Godinu Amara ubi Yesu Keriso imuke dakaisaba ibake me sara fearaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Anemebake i ari eno kodo ufeku? I orofa akaka orou yaisinabairo edoro daiwere fariro nono i orou emua arara me i edoro emuabairo fareka. Emenu ukeka sinekae meramawere ibake emenu ararae dumu ibake Godima emua kodo ufiaku. ");
INSERT INTO aby_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","I merama ukeka ukaisa orouma emua arara me edoro emuabairo fareka. I edoroma emenu merama ukeka edoro ufekuke ma boroo yafekuro Godima enao ufeku ibake emua i edoro arara me. ");
INSERT INTO aby_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nono i irau ukeka ukaisa orouma i edorobake ia sine dakaisa. I edororo aareibaisaro eme yaisinama erakunekake emuama Godinu wake imukaisa enaenari ukaisaya eno we imukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesuma Danu wake eno weiro Dawaini Danu iwoka ukeka orouini Diudia orofaro anisake ibisaro eme keuwere emuabairo fakaro babadaido urieka. ");
INSERT INTO aby_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","I furo Dionima babadaido ukeibirie. I dai adua Enoni goini Seiramu goiyai ubiubi ibiba eme keuwere Dionibairo fakaro emua babadaido urie. ");
INSERT INTO aby_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","I Dioni ana ebaro ode me i furo emua babadaido ukeibirie. ");
INSERT INTO aby_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","26","Dioni danu umuro eneiareibisa orouini moi Du mini emenu darawadubake umu wana urokeibisakema uruna ai iseibisa i urokeka bisara imusu ibake we raraneibisaro Dioninu orouma ane Dionibairo fakake eno weisa, Rabai, i Diodeni adua ekabokenaro iyabairo ibi mi, anu weibi i mi imukaku? I eme yaisina i mibairo faraisake babadaido ukaisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Eno weisaro Dionima wei, i urero ibinu Godima i waiya makinuba ibake eno ukaku. I ari eno waiya me sara da ufeisia wei. Godima i waiya iyabairo mamiisi i ari eno ufeisia wei. ");
INSERT INTO aby_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nae i Keriso meya wero nauisaya wei. Godima nako we mukarake odaikararo fareke Danu daaba wabukebisararo Dawa nanu umuro ai dubuenama faria wei. ");
INSERT INTO aby_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","I awoena awekama awoena eme munakuro awoena aweka muneka mi weaisa. Nono i awoena aweka munaku mi weaisaro i awoena emebairo anaku i ari Yesunu orou Dawabairo anaisa. Enoba i awoena aweka munaku mima danu naiyebake weakuro naukakuke rooro ukaku enaenari na Yesunu wake naukada rooro ukakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dawae daiwere sifekuro nono nae okoanaku simaua Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Danu ibeka orofa ureroba ibake Dawae daiwere, enoroma yewa dooro ibinisi oroue daiwere me. Enoba nae yewa dooro ibine mima i dooro eraerabusabake wene. Nono i ureroma fari Mi Dawae daiwereya Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Danu erekaini ukeka yaisina weakuroma nono emuama Danu wake nauke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ainama Yesunu wake baya eno we imukakuie Godi Dawa baya we imukada ibake eno weaku. ");
INSERT INTO aby_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Godima we odairo fari Mima Godinu wake weakuro nono Godima Dawabairo Danu Imumu Irau makenewaa ukakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Enoba Godi Danu imuka yaisina Danu Amara Yesu Kerisobairo ibinuba Godima i eraerabusa yaisina Yesubairo mairo Yesuma i eraerabusa yaisina yawokaku. ");
INSERT INTO aby_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ainama Godinu Amara Yesu Kerisobairo danu imuka yaisina makakuie me ibene ibene ibeka munaku. Nono ainama Godinu Amaranu wake da naufekuie i me irau ibene ibene ibeka orofa da efekuba Godinu dino ukeka dawabairo ibeifekua Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Eme keuwere Yesubairo fare babadaido uisake Danu iwoka ukeka orou sikaro nono eme keu menaku Dionibairo fare babadaido uisake danu iwoka ukeka orou sinaisaya eno weisaro i Ferosi orouma i wake nauisa. ");
INSERT INTO aby_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Yesu Dawae eme babadaido uke dariero nono Danu iwoka ukeka orou emuama i faka eme babadaido urieka.) ");
INSERT INTO aby_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","I Dai Mi Yesuma i Ferosi orounu weisa wake nauike ibake Diudia orofa medike owerike nono Gareri orofaro Danu iwoka ukeka orouini anisa. ");
INSERT INTO aby_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Danu fare ani daabae Samaria orofaro fare fisii yare fare ani. ");
INSERT INTO aby_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesuma ane Samaria orofa goiro fari. I goi ibiye Saika. I goiye iyanu sisia sirorari mi Deikafuma danu amara Diosefubake mai doo udiro ibi. ");
INSERT INTO aby_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Deikafunu dauni adua ooru i dooro ibeibi. Eweka okoro amuke aare fariro Yesuma daaba yafa aarebe ko yafine i adua ooru udiro fare yaure ibi. ");
INSERT INTO aby_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yaure ibiro moi Samaria goi awekama adua kofine fariro Yesuma eno wei, adua koake mainaro ima wei. ");
INSERT INTO aby_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Yesu Danu iwoka ukeka oroue iedake ibe meba ibake moi Samaria goiro uruna oima make mufisane anisa. Yesu Danu mane yaure ibaada i wakeye idua wei.) ");
INSERT INTO aby_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Eno weiro i Samaria awekama ma owerike eno wei, ae Du miro nono anemebake na Samaria awekabairo wake weaku wei? Anemebake nabairo adua kore mainaro ima weaku wei? I Du orouma Samaria oroubairo wake we dakeibisa ibake i awekama i wake eno weia wei. ");
INSERT INTO aby_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","I awekama eno weiro Yesuma nono wei, Godinu me makekaini i adua mainaro ima weaku mini emua iwoka ufiaronae Nabairo we nauke eraada wefaro Nae abake me ibene ibene ibeka adua ari mamaaro ifanea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yesuma eno weiro nono i awekama wei, abairo adua koreka fanigini me. Yewa adua doo ubarena yafawere ibinude i raraine mero me ibene ibene ibaaku adua aneme aneme kofaku wei? ");
INSERT INTO aby_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iyanu babae Deikafu dawaini danu amarakuini danu boromakauini emuama yewa adua isaba ibake i adua ooru iyabake ma’ia wei. Nono dawae okoanakuro Ae daiwere eno imukaku wei? ");
INSERT INTO aby_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Eno weiro Yesuma dawabake ma owerike eno wei, aina ainama yewa adua ifeisaie nono dubuenaro adua isa ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yesuma eno weike nono wei, aina ainama Nanu mamiau adua ifeisaie nono dubuenaro adua isa da ufeisaya eno wei. Nanu mamiau aduae moi oma ubarenaroma faraku adua ariba da raraifeku. Enaenari i adua emenu imukaro adua ari uke amukeifekua wei. I aduae me ibene ibene ibeka ari ibake da raraifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Eno weiro nono i awekama ma owerike eno wei, Dai Mi, i adua mainaro imaro nono adua isa da ukeifariro yewa adua da aare koreima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","17","Eno weiro Yesuma wei, aniake anu eme erakure waure aara weibaie, na eme meya wei. Eno weiro Yesuma nono wei, ba weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ama emeaka moi ena wana (5) murieke medirie. Medirieke nono awoena anu uwararo ibinu miye anu eme meba ba weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Eno weiro ibake i awekama Yesubake nono wei, Dai Mi, Ae Godinu we bou ukeka Miya weike wei, yewa Samaria goiro iyanu babaemukuma yeka eraku oraararo guriguri ukaisa. Nono ya Du orouma Derusaremu goiro mane guriguri uforo weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eno weiro Yesuma ma owerike eno wei, yewa aweka, Nanu wake naukenewaa ua wei. Moi odo fafekuro i odo yeka oraararo o Derusaremu goiro Nanu Babaebairo guriguri da ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yesuma eno weike nono wei, ya Samaria orou Godi ma nuna ukaisaba ibake Godibairo ba guriguri uke dakaisaya wei. Iya Du orou mane Godi iwoka sinaisia wei. Danu wirokeka Mi i Du oroubairoma fari ibake Godibairo guriguri ukaisia wei. ");
INSERT INTO aby_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Awoena eweka farinuba i Godibairo guriguri ukaisa orouma imukama Godibairo guriguri ukaisaie ba guriguri ukaisaya wei. Godi Danu ararae i orou yaisina emenu imukama imukeroma guriguri ukekabake imukaku. ");
INSERT INTO aby_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godi Dawae Imumuba ere dakaisi ibake Dawabairo imukama imukada guriguri ukaisiie ba guriguri ukaisia eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yesuma eno weiro i awekama Dawabake ma owerike eno wei, i Mesaia fafekua weisaro na naue wei. I Mesaia Danu moi ibiye Keriso. Dawa fafekuke Anu wenu ibai yaisina ma boroo yafekua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","I awekama eno weibaie Yesuma nono wei, i Mesaiae Na ewadoya wei. ");
INSERT INTO aby_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesuma eno weibiro Danu iwoka ukeka orouma fakake ekabaie Yesuini i aweka wake wake we makaneibisiro ekake imuka foria uisake aneme weaisi ari we imuisakema nono i wakenu ubi we nauke ere dauisa. ");
INSERT INTO aby_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","30","I Samaria awekama danu okea medike owerike goiro ani. Ane farike i goi oroubairo eno wei, moi mima nanu fema ukakune ibai yaisina we forakinua Dawae i Kerisoba me aria aniaweke eawe weiro anisa. ");
INSERT INTO aby_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","32","I aweka dawa goiro ibaada eno ukeibibaie Yesunu iwoka ukeka orouma Yesubake eno weisa, Rabai, uruna ia weisabaie, Yesuma eno wei, Nanu moi isakune urunae imusuro yama ma nuna ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","34","Eno weiro emuama eno weisa, Dawae moi mima uruna makinuro isinuba aneme aria eno we makaneibisaro Yesuma wei, Nanu urunae Godinu imukekaini waiyaini Danu makara waiyaini uke me simau ie Nanu uruna arie iduaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yesuma eno weike nono wei, ya eno weaisaya wei, manabe kai fo (4) me sifekuro iyanu waiyaro uruna daufeisia eno weaisaro nono Nama yabake eno weakune, i eme yaisina eyakawe, emenu imukae ba sineka uruna ariba i dauneka odo idua farinu weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aina mima daune fira ukakuie moko muneka munaku. Danu moko muneka ari ie i Godinu wake naukaisake me ibene ibene ibeka munaisa orou. Danu munakune orouma me ibene ibene ibeka munaisaba ibake i yo waweka orouini i uruna daune fira ukeka orouini rooro daiwere ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Enoba adinaro i dadaa wakeye ba. I wakeye eno, moi mima yo wawakuro nono moi mima uruna daunaku, i wake eno ibinua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yesuma eno weike nono wei, yanu wawe da uisa yo eraerabusa daufone ibaku we odaie wei. Imusu orouma yobai wawe me sikaro yama emenu wawisa erabusa daunaisa ibake yaini emuaini waiya demuiro ukaisaya wei. I wakenu ubiye eno, moi orouma Godinu wake we enereibaisaro moi orouma emenu umuro aarada i orou mune Godibairo odaisaie emuae waiya demuiro ukaisa orou iduaya wei. ");
INSERT INTO aby_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","I Samaria awekama goiro anike i goi oroubairo eno wei, moi mima nanu fema ukeka sineka yaisina we ma boroo yarinua weiro i Samaria goi moi orouma emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","42","I Samaria goi orouma Yesubairo ane fakake we kuukaro odo raarayai emuabairo ibaada Yesuma emua we ma iwoka ukeibiriebaie i goi orou keuwere emenu imuka yaisina Yesubairo oisake i awekabake eno weisa, ama weiro anu wake iya naukisia eno weisa. Nono Danu wenu wake naukenewaa ukaisike Dawae i orofa akaka orounu ma wirokeka Miya eno we imukada iwoka sinaisi ibake Danu wake naukenewaa ukaisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Odo raarayai me siniro wai uriro uyarike Gareri orofaro ani. ");
INSERT INTO aby_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Adinaisa Yesuma eno wei, Godinu we bou ukeka minu goi orouma Dawa we iifa uke dauisa ibake eno we imukaisa, dawae dai mi meya we imukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuma ane Gareri orofaro fariro i Gareri orouma rooro uisake arie daiwere weada eno weisa. I Gareri orouma Derusaremu goiro Godima i Isaraera orounu Idifiroma waure anisa banau uruna i furo anisake Yesunu buna ukeka ekake ibake rooro daiwere ukeibisa. ");
INSERT INTO aby_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Yesuma ane Gareri orofa Keina goiro fari. Adinaro i Keina goiro Yesuma ba aduama waini ubu ui. Enoba Yesu iro fariro Yesu Diudiaroma Keina goiro farinua weisaro moi Kafenamu goi gaemani mi i wake naui. I Kafenamu goi gaemani mi danu amaranaku arama daiwere uike feafine ukeibi ibake Yesubairo aare farike eno wei, aarake nanu amaranaku ma wiroa weada eno eenu wei. ");
INSERT INTO aby_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Eno weiro Yesuma wei, buna ukekaini ereka efakuie imufakuke nono da efakuie da imufakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eno weibibaie i mima nono eenu weike wei, Dai Waria Mi, sabu aara nanu amaranaku feanao ufekua wei. ");
INSERT INTO aby_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Eno weiro Yesuma dawabake ma owerike eno wei, ania anu amara wirokinuba irau sifekua weiro Danu wei wake imukada ani. ");
INSERT INTO aby_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Isare aneibiro danu waiya ukeka orou amuke aareibisaro fou uriero emuama eno weisa, Anu amara me irauaiai ibinua weisa. ");
INSERT INTO aby_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eno weisaro, aneme ewekaro wirokinu weiro emuama eno weisa, ariena eweka amuke aare okoro farike ma owereibiro ofe wadada me siniro irau sinia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eno weisa ibake danu babaema eno we imui, ariena i demui ewekaro Yesuma anu amaranaku wirokinua wei ibake wiroia we imuike dawaini danu goi orouini emua yaisina emenu imuka Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Enoba Yesuma Diudiaroma Gareriro farike yewa buna ukekaini nono ba adua weiro waini sini iini buna raarayai uiro i goi orou eka. ");
INSERT INTO aby_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Moi odoro Derusaremu goiro Du orounu banau uisaro Yesu iro amuike ani. ");
INSERT INTO aby_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","I Derusaremu goiro mamoenu fare aneka aisame udiroe koakoasiu ibi. I Du orou emenu wakeroma Beseda weibisa. Sebo yaisina fai (5) i koakoasiu udiro uke kara uke oisaro ibisa. ");
INSERT INTO aby_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Arama imusu imusu ukeibirie orou keuwere i seboro aine ibeibisa. Moibaie umuma enare me orou, moibaie umu beobeo amuneka orou, moibaie naisa kikori bobo orou, moibaie umu wana bedada orou. (I orouma adua bioru ufiro efisane ibake yawokada ibeibisa. ");
INSERT INTO aby_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Enoba moi odo odoro i aneruma aduaro isarada adua ma bioru ukeibiro i dawako bibi ure aduaro isareibi mi mane wirokeibi). ");
INSERT INTO aby_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Moi miye oya dedi eida (38) arama bobo aine ibeibi. ");
INSERT INTO aby_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","7","Dawama aine ibiro Yesuma farike eraada dawa oya keuwere aine ibakua we imukada eno wei, anu ararae wirokeka wei? Eno weiro i arama uke ibi mima wei, Dai Waria Mi, adua bioru ukeibakuie na mune aduaro odeka mi mebake moi miko isarakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","10","Eno weiro Yesuma wei, uyake anu wea muake ania weibaie i mi idua wiroike uyarike danu wea munike ani. Dawa uyarike ani odoe Sabadi odo ibake moi dai Du orouma dawa ekake eno weisa, eweirae Sabadi odoba ibake anu wea da waufae weisa. Ie iyanu darawadua media weisa. ");
INSERT INTO aby_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eno weisaro i mima wei, i Mima na ma wironarake wenu, anu wea muake ania wenua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","13","Eno weiro emuama eno weisa, ainama abake anu wea muake ania wenu weisabaie dawa iwoka me. Yesuma i ku uke ibisa orou ubarenaro aniba ibake i mima Yesu ma nuna ui. ");
INSERT INTO aby_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dubuenaro Yesuma i wiroi mi dai sosi uwararo fou urike eno wei, Nanu wake naua wei. Awoena irau sininuba nono dubuenaro merama ukeka da ufao wei. Ufakuie arama daiwere nono unao umekuba wei. ");
INSERT INTO aby_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eno weiro i mi Yesu idua medike i Du oroubairo anike eno wei, Yesuma na ma wironaraya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eno weiro i wake nauisake Yesuma i Sabadi odoro waiya ukinuba ibake iyanu odo ma merama ukinua eno we imuisake Yesuini dino uisa. ");
INSERT INTO aby_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eno uisaro Yesuma emuabake eno wei, Nanu Babae irau waiya ukeibakuba Naini irau waiya ukeibakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuma eno weiro ibake ararua daiwere uisake Yesu ma feafisane uisa. Yesuma i Sabadi odo imuke dauike eno wei, Godiye Nanu Babae weike Godini Dawaini we ma demuiro ui ibake i orouma Dawaini ararua daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuma emuabake eno wei, Nanu ba wake wemaro nauawe wei. Godinu Amara Danu imusu mane waiya uke dakakua wei. Dawa Danu Babaenu ukaku waiya erakuke enaenari ukakua wei. Godi aneaneme ukakuie Danu Amaraini enaenari ukakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Godinu imuka yaisina Danu Amarabairo ibinuba ibake Danu waiya yaisina Danu Amarabairo ma iwoka ukakua wei. Nono dubuenaro i buna ukeka i adinaro ukeibi i ari mero nono buna ukeka daiwere Dawabairo ma iwoka ufekuro imuka foria ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Godima i fearaisa orou ma uyarakunero me ibaisa enaenari Danu Amarama aina ainabake me irau ibeka emuabairo makakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Godi mane eme kodo ure dakakuneke i merama ukeka ma boroo yafine ibake i waiya Danu Amarabairo maiba ibake ukakuro eme yaisina Godi Dawa iifa ukaisa enaenari Yesubake iifa ukaisaya eno wei. Enoba ainama Danu Amara iifa uke dakakuie enaenari Danu Babaebake iifa uke dakakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nanu ba wake wemaro nauawe wei. Aina ainama Nanu wake naukaisake Na we odai Godi imukaisaie i me ibene ibene ibeka munaisa. Nono i me ibene ibene ibeka mukaba ibake Godinu kodoro ane dakaisake fanisi uke dakaisake feareka ma berekaisake me ibene ibene ibaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nanu ba wake wemaro nauawe wei, i odo aarebe idua farinuba i feareka daabaro anaisa orou, emuae Godinu wake nauke mero me ibeebe fearaisa orou ariba ibake emuama Godinu Amaranu wake naufeisaie i awoena wirokeka mufeisake me ibeifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Godi Dawae i me ibene ibene ibekanu ubiba ibake Danu Amarabairo buna mairo Danu Amaraini iini me ibene ibene ibekanu ubi Mi sini. ");
INSERT INTO aby_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Godinu Amarae Ba Eme Sini Miba ibake Godima Dawa buna mairo eme yaisinanu merama ukeka ma boroo yarakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Nanu weakune wakebake ya imuka foria da uawe wei. Moi odo fafekuro i feaka orou yaisina Danu wake naufeisake i fearekaroma uyafeisake Danu kodo ureifeku orofaro fafeisaro i irau ukeka orouma me ibene ibene ibeifeisaro nono i merama ukeka orouma fanisi orofaro anifeisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesuma eno wei, Nanu imukekama uke dakakunero Godima Danu buna makakunarake weakuro naukakuneke ai eme kodo urakuniaya wei. Nanu imukeka medakuneke Godinu imukeka mane gienabu ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nae Nanu wake mane wemauie Danu wake ba meya wefoisaie idua iraua weike wei, nono i urero ibinu Godima Nabake weaku ibake i wakeye baya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Dioni dawaini enaenaria wei. Yama yanu orou Dionibairo we odairiekaro Dionibairo fakaro Dionima emuabake eno wei, Dawae Godima we odai miya weiro nauisa. Dioninu wakeye baya Yesuma eno wei. Dionima weibi wakeye emenu wake. ");
INSERT INTO aby_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dioni dawae ba eme ibake emenu wake weibiroma nono Nanu wakeye imusuroma nono i ubiye demuiro nono Nama Nanu Babaenu wake bunawere weakune ie ya yaisina naufoke wirofone ibake weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yesuma nono wei, Dioni dawae ramefa edoro ari uiba ibake danu edororo enarada danu wake odo keu menaku nauisake rooro uisa. ");
INSERT INTO aby_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dionima wake weada Na ma boroo yariro danu ma boroo yarekae daiwere me. Nono awoenae Nanu ma boroo yareka daiwere ibinua wei. I ma boroo yarekae Nanu buna ukeka. Ima Na ma boroo yarenewaa ukakuro emema ibai eraada Godima Na ba we odaikara weada iwoka sinaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Godima Na we odaikarake Nanu waiya irauaiaiya wei. Enobairoma yae Godinu wake nauke karana uke dakaisake Dawa ere dakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Danu we odai Mi ma nuna ukaisaba Godinu wake yanu imukaro ibe dakakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yae Godinu buka erenewaa ukaisa. I bukaro erenewaa uaweke i me ibene ibene ibeka mufone imufoisaie i bukaro wakema weaku, Nae i Keriso yanu wirokeka mi weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Enobairo yama Na imuke dakaisake Nabairo wirokeka fare mune dakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nae emema Na we ma daiwere ukeibekaro naumane ibake weroma yodia uke enare meya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yanu imuka Godibairo ibe dakakuro Na iwoka sinakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Godinu ibiro yabairo fanebairo yama Na imuke dakaisaya wei. Nono dubuenaro moi mima danu imusu ibiro fafekuro dawa imufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yanu ararae emema ya irau orou wefisane ibake eno ukaisake nono Godima ya irau oroua weekabai ya arara me ibake Godi imuke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yanu imukekae eno, Dawa Godibairo iya wayai wefekua eno we imukaisaroma nono Nae eno da wemau. Ya Mosesinu darawadu wake imukenewaa ukaisaya weaisaba ibake ima ya wayai wefekua wei. ");
INSERT INTO aby_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesinu darawadu imukenewaa dakaisaba ibake Naini imukenewaa uke dakaisa. Mosesie Nabake bukaro owaowa yanake odi. ");
INSERT INTO aby_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Danu owaowa kakurada ubi imuke dafoisaie aneaneme Nanu wake imufoisa Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nono dubuenaro Yesuma Gareri kuna siraa yari. I kunanu moi ibiye Daibiriusi weaisa. ");
INSERT INTO aby_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesuma siraa yare aniro eme keuwere Danu umuro anisa. I orouma Yesuma eme ma wirokeka buna eka ibake Danu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuma i Gareri kuna siraa yare ane ekabokenaro amuike Danu iwoka ukeka orou oraararo waure amuke anirie. ");
INSERT INTO aby_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Godima i Isaraera orounu Idifiroma waure aneka banau uruna odo fafine ui. ");
INSERT INTO aby_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ibake Yesuma Danu naisama erieke i eme keuwere eraada Firifubake eno wei, aneme aneme uruna oima make mufeisike mafiakikiro i eme yaisina ifeisa eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu Dawa aneaneme ufeku ibai Dawa iwoka uikema Firifu me we nauke eraada ibake eno wei.) ");
INSERT INTO aby_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eno weiro Firifuma wei, duenidi kinama (K 20) enaenari sifekua eno wei. I oima uruna make mufeisiroma i eme moi enaenari da sifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Firifuma eno weiro Saimoni Fidanu dabue Enuduruma Yesubake eno wei, buredi faini (5) inaaro nonoka adua abu una raarayaini moi amaranakubairo ibinua eno wei. Ie uruna keuwere mero aneaneme ufeisi wei. ");
INSERT INTO aby_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","11","Eno weiro Yesuma wei, i orou weawero yaufisa wei. I orofae bagibagi koe fafaro i orou yaisina fai dausini (5,000) yaukaro Yesuma i buredini adua abu una raarayainaku munike Godibairo guriguri ukaada we ma irauaiai uike ma birabira yarike naka naka uiro emuaini emenu aweka amarakuini isaro boana urie. ");
INSERT INTO aby_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Isaro boana uriero Yesuma Danu iwoka ukeka oroubake eno wei, i iuwabai yaisina fira uawero me sara da ibifisa wei. ");
INSERT INTO aby_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Weiro i isa buredi iuwabai mukake bosearo youkaro bosea duwero (12) wake faka. ");
INSERT INTO aby_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","I uruna isa orouma i buna uibai ekake eno weisa i mi Dawae Godibairo we bou ukaada fafekua weibi mi iduaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu Dawa iwoka i orouma Dawa emenu kini mi sifike emua yawokeifiane eno imukeibisa ibake emua idua medirieke oraararo amuke ani. ");
INSERT INTO aby_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dumudumu siniro Yesunu iwoka ukeka orouma kuna udiro isare anisake Yesu koro ukeibisa. ");
INSERT INTO aby_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Koro ukeebe dumu ma girisi yariba ibake meisake boudiro amuisake Kafenamu goiro siraa yare anisa. Anisaro dumu siniro Yesu fare daui. ");
INSERT INTO aby_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aneibisabaie oyau daiwere fariro adua ufe daiwere uyari. ");
INSERT INTO aby_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","20","Ufe daiwere uyariro emuama bara uraada adua abanaro aneibisabaie Yesuma adua duboro enaenare aareibiro eka. Ekake ereibisaro emuabairo fafine aareibiro ia daiwere sikaro Yesuma emuabake eno wei, yewae Naya ia da siawe wei. ");
INSERT INTO aby_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eno weiro i orouma rooro ukaada Yesu unu kokaro boudiro amui. Amuiro iduama me ari sabunaku ane emenu weisa orofaro enaka. ");
INSERT INTO aby_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wai uriro i kuna ekabokenaro koro ukeibisa orouma Yesu fafiro efisane ku siane ibaada yawokeibisa. Yesuini Danu iwoka ukeka orouini i ku uke ibeiyaka orofaro ariena ari fakake ekabaie boudi demui mane ibiro eka. Enoba Yesunu iwoka ukeka orouma Dawa meisake emenu imusu boudiro siraa yare anisa. I orouma Yesu Dawa ane dauibai emua iwoka sika ibake idua ibaada Yesu koro ukeibisa. ");
INSERT INTO aby_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ibake idua koro ukeibisaro nono moi boudi Daibiriusi orofaroma i buredi isa orofaro fare enaka. ");
INSERT INTO aby_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","I orouini Yesu Danu iwoka ukeka orouini ekabaie Yesu iro meba ibake i orofa meisake i boudi yaisinaro amuisake Kafenamu goiro Yesu yodia ufisane siraa yare anisa. ");
INSERT INTO aby_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","I kuna ekabokenaro siraa yare ane udiro amuisake Yesu yodia ukeebe fou ukake eno weisa, Rabai, abonodo a ewado fari eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Eno weisaro Yesuma wei, Nanu ba wake wemaro nauawe wei, Nanu buna ukekabai imuke dakaisake nono buredini adua abuini mayaro isaro boana urieba ibake Nabairo ibifone ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yanu dooro ibeka boana waiyabake imukenewaa da uawe eno wei. Nono i me ibene ibene ibeka ari waiyae imukenewaa uawe wei. Babae Godima Danu imukeka Na, i Ba Eme Sine Mibairo makaraba Nama i me ibene ibene ibeka makakuniaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","I orouma Yesubairo eno weisa, aneaneme Godinu waiya ufeisiro Godima ie irauaiaiya wefeku eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eno weisaro Yesuma ma owerike nono wei, Godinu we odai Amara ubi imukenewaa ukaisaie Godinu waiya iduaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","I orouma Yesubake eno weisa, aneme buna ufakuro efeisike A imufeisi weisa? Aneme waiya ufaku? ");
INSERT INTO aby_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iyanu babaemukuma eme ibe me yao nauwaro enarada uruna danu ibiye mana iseibisa. Godinu bukaro eno odi, Dawama emuabake ureroma isari uruna mariero isa, i bukaro i wake eno ibinua weisa. ");
INSERT INTO aby_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eno weisaro Yesuma wei, Nanu ba wake wemaro nauawe wei. Mosesima i ureroma isari uruna make dariero Godima i ureroma isari uruna i oroubairo mariea wei. Nono awoenae Nanu Babaema i ba uruna ureroma yabairo makakunea eno wei. I ba urunae Yesu ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Godinu uruna ureroma isare aarakuba i orofa akaka orouma i uruna ifeisake me ibene ibene ibeifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesuma eno weiro i orouma nono weisa, Dai Waria Mi, i uruna aine wai ure iyabake makeibia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","36","Eno weisaro Yesuma emuabake eno wei, Nae yanu me ibene ibene ibeka urunaya wei. Aina ainama Na imufokoisaie emua adua isa da ufeisaya eno weike wei, adinaisa Nanu onamibake yabairo wene, yama Na erakunekake nono imuke dakakuneka wene wei. ");
INSERT INTO aby_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nanu Babaema moi orou Nabake makakunaraba i orou yaisina Nabairo fafeisaie da we yowemiaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eno weike Yesuma nono wei, Na ureroma Nanu arara umane ibake isare aare dauea wei. Godinu arara umane ibake isare aare enoba i Nabairo fafeisa orou da we yowemiaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Godima Na we odaikararo Danu arara umane ibake isare aarea wei. Godinu ararae eno, Dawama Nabake makakunara orou da we ma fe yamiauke i orou yaisina i dubuena kai odoro we ma uyamiauro me ibene ibene ibeifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nanu urero ibinu Babae Danu ararae eno, aina ainama Danu Amara efeisake emenu imuka yaisina Dawabairo odifeisaie me ibene ibene ibeka mufeisaro i dubuena kai odoro emua we ma uyamiaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Yesuma nono wei, Nae i ureroma isare aari uruna wei ibake i dai Du orouma kamena weibisabaie moi orouma eno weisa, Dawae Yesu Diosefunu amara. Danu amaeini babaeini iya iwokade aneaneme Na ureroma isare aare weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Eno weisaro Yesuma wei, yanu imusu kamena da weawe wei. ");
INSERT INTO aby_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eme me sara Nabairo da fafeisaro Na we odaikara Godima emua we ma youfiakuie idua Nabairo fafeisaro i dubuena kai odoro emua we ma uyamiaua wei. ");
INSERT INTO aby_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","I we bou ukeka orouma eno owaowa yanake oisa, Godima emua yaisina we ma iwoka ufiaku eno owaowa yanake oisa. Enoba aina ainama Godinu wake naufeisake iwoka ufeisaie Nabairo idua fafeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Eme yaisina Godi ere mero i Godibairoma isare aari Mi Dawa mane Godi eria wei. ");
INSERT INTO aby_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nanu ba wake wemaro nauawe wei, aina ainama emenu imuka yaisina Nabairo odaisaie i me ibene ibene ibeka munaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yesuma nono wei, Nae i me ibene ibene ibeka urunaya wei. ");
INSERT INTO aby_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yanu babaemukuma eme ibe me yao orofaro uruna danu ibiye mana iseibisake feareibisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","I ba uruna ureroma isare aariba aina mima i uruna ifekuie dawa da feafekua wei. ");
INSERT INTO aby_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nae i me ibene ibene ibeka uruna ureroma isare aare. Enoba ainama i uruna ifekuie me ibene ibene ibeifekua wei. I uruna mamiaro i orofa akaka orou yaisina ifisake me ibene ibene ibifisane makakunia. I urunae Nanu ofeya weada wei. ");
INSERT INTO aby_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesuma eno weiro i dai Du orou nauisake dino uisake emenu emenu we makakake eno weisa, i mi aneaneme danu ofe mamiro mufeke ifene weaku weisa. ");
INSERT INTO aby_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eno weisaro Yesuma nono wei. Nanu ba wake wemaro nauawe wei. I Ba Eme Sini Minu ofeini iwaini da ifoisaie i me ibene ibene ibeka yabairo ibe dafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Enoba ainama Nanu ofeini iwaini ifekuie i me ibene ibene ibeka dawabairo ibifekuba i dubuena kai odoro dawa we ma uyamaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nanu ofeye ba uruna. Nono Nanu iwae ba aduaya wei. ");
INSERT INTO aby_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ainama Nanu ofeini iwaini ifekuie dawa Nabairo ibifekuro nono Na dawabairo ibimaua wei. ");
INSERT INTO aby_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","I me ibekanu ubiye Babae Godiba ibake Nae me ibine enaenari ainama Nanu ofe ifekuie me ibene ibene ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yewa urunae ureroma isare aari uruna. Nono yanu babaemukuma mana weaisa uruna isake feaka. I mana weaisa urunae imusuroma nono ainama yewa wene uruna ifekuie me ibene ibene ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Enoba Yesuma Kafenamu goiro ibaada i Du orounu sosi uwara ubarenaro i wake we ma iwoka ukeibirie. ");
INSERT INTO aby_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Moi Yesunu umuro aneibisa orouma i Yesu wei wake nauisake yewa wake arawere ainama naukakuro weaku eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Eno weisaro Yesuma emenu weibisa wake iwoka uike emuabake ma owerike eno wei, i wene wakebake dino ukaada weaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I Ba Eme Sini Mima Danu adinaro ibeibi orofaro amuke anifekuro eraada aneaneme dawa imufoisa wei? ");
INSERT INTO aby_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godinu Imumu Irauma i me ibene ibene ibeka makaku. Enoba emema emenu imukekaini ubu ofenu bunama i me ibene ibene ibeka me sara da mufeisa. Nanu wene wakeini Godinu Imumu Irauini i me ibene ibene ibekaini emua demuiya weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yabairo eno weakunero nono moi orou emua imuke dakaisaya wei (Yesuma adinami nauwaroma i emenu imuka yaisina Dawabairo ode dauisa orou iwoka urieke nono Dawa we forafekuro mufeisa i mi Dawa iwoka sini.) ");
INSERT INTO aby_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesuma nono wei, ibake wene, Nanu Babaema aina aina da we mufekuie Nabairo da fafeisa wenea wei. ");
INSERT INTO aby_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesunu umuro aneibisa orouma i wake nauisake Yesu idua meisake owekake emenu arara ororofaro idua anisa. ");
INSERT INTO aby_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Idua anisaro Yesuma Danu iwoka ukeka orou duwerobake (12) eno wei, ya enaenari Na medifokoisake anifoisa wei? ");
INSERT INTO aby_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Eno weiro Saimoni Fidama ma owerike eno wei, Dai Waria Mi, abo mibairo anifeisi wei? Abairo i me ibene ibene ibeka wake ibinu ibake A imukada Ae Godinu iifa miya eno we imukaisia wei. ");
INSERT INTO aby_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Eno weiro Yesuma emuabake nono wei, ya orou duwero (12) Nama we mune odiaroma nono moi mi dawae seidaninu miya wei. ");
INSERT INTO aby_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuma Saimoni Ikariadanu amara Diudiasibake wei. Diudiasi dawae moi duwero (12) iwoka ukeka mike nono dawae Yesu we forafeku mi. ");
INSERT INTO aby_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesuma i wake weiro Kafenamu goi meisake Gareri orofaroma iro iro me eneiareibisa. Yesu Dawae arara me Diudia orofaro aneka. I Du orounu dai orouma Dawa ma feareka daaba yodia ukeibisaba Dawa iro ane daui. ");
INSERT INTO aby_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","I Du orounu akaemuku emenu waiya ba sineibiie farai kakabaima kukuarananaku ukeibisake i kukuarananakuro ainada dawako dauneibisa uruna kaie Godibairo ofereni makeibisake moi dauneibisabaima banau uke iseibisaba i odo fu sineiba Yesunu nabuemukuma Dawabake eno weisa, i Diudia orofa banauro aniake buna ukeka uaro anu umuro aaraisa orou emua efisa eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aina mi dawa danu buna ukeka emema efisane weakuie fema uke dakakuke eme yaisinanu ibooro ukakuro eraisaya weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Danu naburakaini emuama emenu imuka yaisina Dawabairo make dauisaba ibake eno weisa.) ");
INSERT INTO aby_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Eno weisaro Yesuma emuabake moko eno wei, Na ma boroo yareka odo fare mero nono yanu odo aine wai ure ibinua wei. ");
INSERT INTO aby_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I orofa akaka orouma yabake imuka merama uke dakaisa. Nono Nae i orounu merama ukekabake weakuneba Nabake imuka merama imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yanu imusu i banauro anifoisaro nono Na we ma boroo yareka odo fare dakinuba Nae awoena yaini iro da animaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu Dawa eno weike Gareriro ibi. ");
INSERT INTO aby_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dubuenaro Yesunu nabuemuku i banauro anisaro Yesu Dawa fenakuma i banauro aniro emema Dawa ere dauisa. ");
INSERT INTO aby_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","12","I dai Du orouma i banau siuro Yesu yodia ukeebe eno weisa, Dawa aboro weisabaie eme keuwere Dawabake wake mumuuroma eno weibisa. Moi orouma eno weisa, Dawae irau mi eno weisaro nono moi orouma eno weisa, Dawae eme we irukakune miya weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","I Du dai oroubake ia sikake ibake mumuuroma weibisa. ");
INSERT INTO aby_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I banau iseibisaro odo buuba me siniro Yesuma i Du orounu dai sosi uwara ubarenaro amuike we ma iwoka ukeibi. ");
INSERT INTO aby_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","We ma iwoka ukeibiriero i Du orouma naukake imuka foria ukaada eno weisa, i Mi sikuru uke da uibairo Dawa iwoka aboro muninu weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Eno weisaro Yesuma emuabake eno wei, Nanu imukekaro we dakakuneke Na we odaikara Godinu imukekama weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ainama Godinu arararo ukenewaa ufekuie dawa ainanu imukekaroma weakune ibai iwoka sifekua eno wei. Nae Godinu imukeka wake weakune o Nanu imukeka wake weakune ari, dawa eno dubenaro iwoka sifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ainama danu imukeka mane weakuie emema dawa we ma irauaiai ufisane ibake weakua wei. Nono ainama dawa we odai Godi we ma irauaiai ufine ukakuie i miye irauaiaiba ba miya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesima danu darawadu yabake marie. I darawaduma eno weaku, eme da ma feawe weakuroma nono yama Na ma feafokone ukaisaie i darawadu ma merama ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eno weiro i orouma ma owekake eno weisa, Ae seidaninu merama imumu bobo miba gogore wake weakua eno weisa. Ainama A ma feameku weisa? ");
INSERT INTO aby_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Eno weisaro Yesuma wei, moi me, Nama Sabadi odoro i arama daiwere uke ibi mi ma wiroeba ibake imuka foria uisake Na ma feafokone weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesima yanu ofe kuureka darawadu mariea weaisaya wei. (Ie Mosesibairoma me, yanu babaemukubairoma i ofe kuureka darawadu fari.) Mosesima Sabadi odoro ofe kuureiforo we daui. Yesuma eno weike nono wei, ie yanu babaemuku emuabairoma fariba ibake Sabadi odoro moi amarananaku ofe kuurakunekaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eno ukaisaie Mosesinu darawadu imukaisake nono Godinu Sabadi odo imuke dakaisaya wei. Eno ukaisaro nono Nama i minu ubu ofe yaisina ma wiroero irauaiai ibinude nono anemebake Naini dino ukaisa eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ya eme kodo uraadae i orounu ukeka mane da ere weaweke me sara kodo da uyakaweke ba gienabu kodo uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","26","Yesuma i kodo ureka wake eno weiro moi Derusaremu goi orouma eno weisa, yewae emenu ma feafisane weaisa miba me weisa? Eno weisake nono weisa, Dawa iyabairo wake daiwere weakuro i orouma wake muu ukaisaya weisa. Iyanu dai orouma Dawae i Mesaiaba me eno we imukaisa? ");
INSERT INTO aby_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yesunu goiye iya iwoka sinaisi. Nono i Mesaianu fareka orofa eme moima iwoka meba ibake Dawa aboroma fafeku ariya weisa? ");
INSERT INTO aby_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eno weisaro Yesuma i Du orounu dai sosi uwara ubarenaro we ma iwoka ukaada i wake nauike Yesuma daiwere eno wei, Nanu goini Naini ya iwoka ukaisaya weaisa wei? Eno weike nono wei, Nanu imusu fare dauero Na we odaikara Godi Dawae ba. Enoba yae Dawa ma nuna ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nae Dawa iwokaro Dawama Na we odaikararo farea wei. ");
INSERT INTO aby_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesuma eno wei ibake i dai Du orouma Yesunu umu wana naama uwafisane uisaro Danu feareka odo fare dauiba Dawa ure burise ere dauisa. ");
INSERT INTO aby_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","I dai sosi uwara ubarenaro yaure ibisa orou keuwere emenu imuka yaisina Yesubairo oisake eno weisa, yewa Miye i Mesaiaro moi mima nono dubuenaro fareroma danu ukekama yewa Minu buna ukeka ma bereke dafekua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","I ku siane ibisa orouma eno uke mumuuroma weibisaro i Ferosi weaisa orouma nauisake emuaini i dai ofereni ode sibore sianeka orouini furisi orouini emuama Yesu yabafisake Danu wanayai mune ane derena enaro naama uwafisane we odairiekaro Yesubairo anisa. ");
INSERT INTO aby_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ane Yesubairo fakaro Yesuma emuabake eno wei, yabairo yafa menaku mane ibimauke Na we odaikara Godibairo owere animaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yae Na yodia ukeebe da fou ufokaisake Nanu ibimau orofaro da aafoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yesuma eno wei ibake i Du orouma emenu emenu we makanada eno weisa, yewa mi aboro anifekuro da fou ufeisi eno weisa? Iyama yoweriekiro anisa Guriki orounu orofaro anifike emua we ma iwoka ukeifiane weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dawa aneme wenu, yama Na da fou ufokoisake Nanu animau orofaro da aafoisaya wenua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","I banau ise me sineibisa odoroe Yesuma uyarike eno wei, aina ainama adua isa ufiakuie Nabairo aafoke ifone weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Godinu bukaroma eno weaku, ainama danu imuka yaisina Nabairo odakuie danu imukaroma me ibene ibene ibeka wake dai adua ari eno uke amufekuke moi oroubairo adua ari aine wai ure yareifeku weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I wei wakeye Godinu Imumu Iraubake dubo waure wei, Aina ainama emenu imuka yaisina Yesubairo odifeisaie Godinu Imumu Irauma emuabairo mafiakuro mufeisaroma nono i odoro Yesu urero owere amuke ane dauiro Godima Yesu we ma daiwere dauiba ibake Danu Imumu Irau i oroubairo make darie. Enoba i dubuena kai odobake Yesuma dubo waure wakeroma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","41","Yesunu wei wake nauisake moi orouma eno weisa, yewa miye Godinu ba we bou ukeka mi fafekua weaisa mi yewadoya eno weisaro, nono moi orouma eno weisa, I Mesaia Dawa Gareriroma da fafekua weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Godinu bukaroma eno weaku, i Mesaiae Deiwidinu sisia sirorori mi. Ibake Deiwidinu goi Bediriemu goiroma fafekua Godinu bukaroma eno weakua weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eno weisake i orouma imukeka imusu imusu imuisake Yesubake i orou abanaro enare kuukake ku raarayai uisa. ");
INSERT INTO aby_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eno ku raara uisa ibake moi orouma Yesu yabake mufisake wanayai mune ane derena enaro naama uwafisane uisakema nono moibaibake ia iyakake eno uke dauisa. ");
INSERT INTO aby_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","I furisi orouma owekake i dai ofereni ode sibore sianeka orouini emuama i Ferosi oroubairo fakaro I Ferosi orouma eno weisa, anemebake muneroma fare dakisake me faraisa weisa? ");
INSERT INTO aby_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eno weisaro i furisi orouma ma owekake eno weisa, Danu wenu wakeye bunawerero nono moi emema i ari eno wake we dakaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eno weisaro i Ferosi orouma nono weisa, Dawae ya we iruneba aneme ariya eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Eno weisake nono weisa, i dai yawokeka orouini iyaini Dawa imuke dakaisia weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","I ku uke ibisa oroue Mosesinu darawadu iwoka meba fanisi mufeisa orofaro anifeisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Eno weisaro nono moi Ferosi mi danu ibiye Nikodimasi dawae adinaro Yesubairo ani mi dawama emuabake eno wei, iyanu darawaduma eno weaku, moi mi me sara fanisi da maewe weaku. Ba kodo ufoisake danu ukeka sineka naufoisake iwoka sifoisaie idua fanisi maewe weakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nikodimasima eno weiro dawabake ma owekake eno weisa, aini Gareriroma farinu weisa? Eno weisake nono weisa, Godinu bukaro erenewaa ufakuie i we bou ukeka orou Gareriroma da fafeisabai iwoka sifakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eno weisaro i orou yaisina ku siane ibisa ibai meisake emenu goi goiro fiake anisa. ");
INSERT INTO aby_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Yesuma Oriwa oraararo amuke anike iro aini. Ainiro wai uriro Yesu owerike isare aarike dai sosi uwararo ani. Ane fariro eme keuwere fakake ku siane ibisaro Yesuma yaure ibaada we ma iwoka ukeibirie. ");
INSERT INTO aby_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Yesuma we ma iwoka ukeibiriebaie moi Du orounu darawadu we ma iwoka ukeka orouini Ferosi orouini emua moi awekabonu emeakaini dodoo ukeibi aweka mukake waure aare Yesubairo faka. Waure fakake i ku siane ibisa orounu ibooro ma enare oisake Yesubake eno weisa, Sisa, yewa aweka merama ukinuro erisike ibake we waure faraisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eno weisake nono weisa, Mosesinu darawaduma eno weaku, i moi emeakabake ukeifeisa awekabo omama ure ma feaewe weakua weisa, ibake ama aneaneme wefaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","8","I orou emenu ararae Yesu we nauke efisaro Yesunu wefi wake naufisane ibake Yesu we iruke ereibisa. Eno weisaro Yesu ubiri afua umanike wanama dooro owaowa ukeibibaie emuama areare weada eno weisa, A wearo naufe weibisabake Yesuma uyarike emuabake eno wei, yabairo i merama merama uke dakaku mi dawako yewa aweka omama siane ufi weike nono ubiri afua umanike wanama nono dooro owaowa ui. ");
INSERT INTO aby_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yesuma eno uiro i Du orouma ekake fema fiake demui demui emenu dai orouko anisaro moibai emua ai dubuenama anisa. Yesuini i awekaini i ku siane ibisa orounu ibooro emenu imusu enare ibisi. ");
INSERT INTO aby_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Emenu mane enare ibeebe Yesuma uyarike i awekabake eno wei, anu wayai weeka orou aboro anisa wei? Abake do mamekaisaba me wei. ");
INSERT INTO aby_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yesuma eno weibaie i awekama ma owerike eno wei, Dai Mi, i orou anisaya wei. Eno weiro Yesuma wei, Naini iini abake da we foramanea aniake moi merama ukeka nono da ua wei. ");
INSERT INTO aby_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Moi odoro Yesuma i dai sosi uwara ubarenaro yaure ibisa oroubake eno wei, Nae dai ramefa edoro ari. Ibake yewa orofa akaka orou yaisina we ma iwoka ukakuniaba ibake Nae emenu ramefa edoro ari. Nanu umuro aafeisa oroue emuabairo dumu meba anifeisake i orofa akaka aboro aboro anifeisaie i me ibene ibene ibeka edoro emuabairo ibeifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Eno weiro i Ferosi orouma ma owekake eno weisa, anu mane anu onamibake weakuba ibake ae meo weaku ari iyama eno we imukaisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Eno weisaro Yesuma nono wei, meo mero ba weakunea wei. Nanu mane Nanu ukeka sineka wake weakuneba ie ba wakeya wei. Nanu aare orofa Na iwoka ukakuneke nono Nanu animau orofa Na iwoka sinakunero nono yae iwoka meya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yesuma eno weike nono wei, yama Na kodo urakunekaie ya iwoka mero emenu kodo ari urakuneka. Nono Nama ya awoena kodo ure dakakune. ");
INSERT INTO aby_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Enoro nono kodo uraadae Nanu mane mero Na we odaikara Godi Dawa Na unu kofarakuba ibake Nanu umau kodoe baya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nono yanu darawaduma eno weaku, eme una raarama ba erisua wake demui weaisiie emenu wakeye baya emema eno weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yesuma eno weike nono wei, Naini nono Na we odaikara Godini uwa Nanu onamibake demui wake weaisua wei. ");
INSERT INTO aby_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesuma eno weiro Dawabake ma owekake eno weisa, Anu Babae aboro weisabaie Yesuma wei, Naini Nanu Babaeini ya iwoka meya wei. Yama Na iwoka sifokoronae Nanu Babae iwoka sifonea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuma i wake i dai sosi uwara oi muneka ooruro weiro nono emema Dawa muneka odo fare da uiba ibake i dai Du orouma Dawa mune dauisa. ");
INSERT INTO aby_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuma emuabake nono eno wei, moi wake i ari enoya wei, Na animauro ya Na yodia ukeebe Na da fou ufokoisaie yanu merama merama ukeka idua yabairo ibifekuro i bobo feafoisaya eno wei. Ya feafoisake Nanu animau orofaro da aafoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yesuma eno weiro i Du orouma ma owekake eno weisa, Danu onami faya kuufekuba aneme ariya eno weisa? Anemebake eno weaku, Nanu animau orofaro ya da aafoisaya weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","24","Eno weisaro Yesuma wei, yae dooroma fakaro nono Nae ureroma isare fare. Ibake yae doo ubi orouro nono Nae ureroma isare fareba ibake Nae ure ubi Miya eno weike nono wei, ibake yewa wake weakunea wei. Eno weike wei, yama Nae i Mesaia i ma wirokeka miya da imufokoisaie Yanu merama merama ukeka yabairo ibifekuro feafoisa eno wenea wei. ");
INSERT INTO aby_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eno weiro i orouma Dawabake eno weisa, a ainadeiro? Eno weisabaie Yesuma wei, Nanu wake adinami nauwaroma weibakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yabairo Nanu onamibake wake keuwere wemauke ya kodo daiwere uraada yanu merama merama ukeka yaisina ma boroo yamaua eno wei. Na we odaikara Godi, Dawae ba, ibake Dawama aneme aneme Nabairo weakuro enaenari yewa orofa akaka oroubairo weibakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","28","Yesuma Babae Godibake weiro i orouma ma nuna uisaro Yesuma emuabake nono wei, yae i Ba Eme Sini Mi korosiro ikokoma ufoisaie i odoro Nae i Mesaia ibai idua iwoka sifokoisaya wei. Eno weike wei, nono moiye yama eno iwoka sifokoisa, Nae Nanu imukekaro uke dakakuneke Godinu imukekaini we ma iwoka ukekaini i mane weakune, eno iwoka ufokoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na we odaikara Godi Nabairo ibinu. Enoba Danu imukeka mane ukakune ibake Dawa rooro ukakuke Na mede dakakunaraya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuma eno wei ibake eme keuwere emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Yesuma Danu wake naukeibisa Du oroubake eno wei, Nanu wake naukenewaa ufoisaie Nanu ba iwoka ukeka orou sifoisake Nanu wake iwoka ufoisa ibake Nanu wakema ya ma wirofiakuro irau me ibifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yesuma eno weiro emuama ma owekake eno weisa, iyae Eibaramunu sisia sirorari orou ibake moi orouma iya yawoke dakakunisabairo anemebake yanu meramawere yawokeka ibai idua me sifeku weakua eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eno weisaro Yesuma emuabake nono wei, Nanu ba wake wemaro nauawe wei. Aina ainama merama ukaisaie i meramama emua yawokakuneba ibake emuae i meramawere yawokeibakuneka orou aria wei. ");
INSERT INTO aby_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I meramawere waiya ukaku mi dawa danu yawokaku minu uwararo da ibifeku. Nono i yawokaku minu amara danu dooro ibeifeku furo danu babaenu uwararo ibeifeku. ");
INSERT INTO aby_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Enoba Na Godinu Amarama Nama ya ma wiromiauie yanu merama ukeka sineka idua medifoisake me irauaiai ibenewaa ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yae Eibaramunu sisia orou Na iwokaroma nono ya arara me Nanu wake weeka ibake yae Na ma feafokone ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nae Nanu Babaenu ba irau wake naueba yabairo weibakunero nono yae yanu babaenu wake naukeibaisa ibake eno ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eno weiro i orouma Yesubake ma owekake eno weisa, Eibaramu dawae iyanu babaeya weisaro Yesuma wei, yae ba Eibaramunu amarakuronae danu ukeibi enaenari ukeifonea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Enoba awoenae yama Na ma feareka daaba yodia ukaisaya wei. Nae Godibairo naue wake yabairo weibakunero nono yama Na ma feafokone daaba yodia ukeibaisaya wei. Yae eno ukaisa ibake yae Eibaramunu ukeibi waiya enaenari uke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yama i ari eno ukaisaie yanu babaemukunu ukeka sineka enaenari ukaisaya wei. Eno weiro emuama nono weisa, iyanu amaemukuma iya daabaro dore dauisaya eno weisa. Iyanu babaeye demuiya, Dawae Godiya weisa. ");
INSERT INTO aby_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Eno weisaro Yesuma emuabake nono wei, Godiye yanu Babae me. Dawa Yanu Babaeronae yama Nabake imukari ufonea wei. Godima Na we odaikararo Dawaini demuiro ibeebe medeke Dawabairoma isare aare ibake Godi Dawa yanu Babaeronae yanu imuka yaisina Nabairo odifonea wei. ");
INSERT INTO aby_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Anemebake Nanu wake nauke dakaisa wei? Ya arara me Nanu wake weekaro ya naukeka ibake yanu ome dadau ukaisake Nanu wake nauke dakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ibake yanu babaeye seidani. Yae danu amaraku ibake yae danu weaku ukaku i ari enaenari mane ukaisaya wei. Adinami nauwaroma seidani dawae ma feareka mi. Enoba dawa arara me ba irauaiai ukeka. Dawae meo weeka mane iwoka ibake dawae ba me mi. Dawa wake weakuie meo wake mane weaku ibake dawae meo weekanu babae. ");
INSERT INTO aby_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Enoba yabake ba ofe ariri wake weakunero ya nauke imuke dakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ainama Nabake Ae merama ukakua wefeku? Eno da wefeku, Nae ba irau wake mane weakunero nono anemebake Na imuke dakakuneka eno wei? ");
INSERT INTO aby_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aina mi dawa Godibairoma fafekuie Godinu wake naukenewaa ufekua wei. Yae Godibairoma fare dauisaba ibake yae Godinu wake nauke dakaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yesuma emuabake i wake eno weiro i dai Du orouma Dawabake eno weisa, iyae Abake eno weaisi, Ae seidaninu merama imumu bobo Samaria orofa miya weaisi ieba, ba meo weaisi weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Eno weisaro Yesuma wei, Nabairo seidaninu merama imumu ibe me wei. Nae Nanu Babae we ma irauaiai ukakunero nono yama Nabake merama wake weaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanu onamibake we ma irauaiai uke dakakunero Godi Dawama Na we ma irauaiai ukakunaraba i meo weaisa orou yaisina kodo gienabu ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei. Aina ainama Nanu wake nauke ukenewaa ufeisaie da feafeisake me ibene ibene ibifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Eno weiro i Du orouma Dawabake ma owekake eno weisa, abairo seidaninu merama imumu ibinuro iya iwoka sinaisia eno weisa. Eibaramuini i we bou ukeka orou yaisina feakade aneaneme danu wake nauke ukenewaa ufeisaie da feafisake me ibene ibene ibifisane weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Iyanu babae Eibaramu dawa feari. Nono i we bou urieka orouini iini feakade nono eno anemebake weaku weisa? Ae daiwerero nono i oroue okoanaku eno imukaku weisake weisa, Ae ainadei, wearo naufe weisa. ");
INSERT INTO aby_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eno weisaro Yesuma wei, Nanu imusu Nanu onami we ma irauaiai umauie ba meya wei. Yama eno weaisa, Godiye Nanu Babaeya yama eno weaisakema nono Danu wake nauke dakaisa. I Godima Na we ma irauaiai ukakunarake Na ma daiwere ukakunaraya wei. ");
INSERT INTO aby_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yae Dawa ma nuna ukaisaro nono Nae Dawa iwoka ukakunea wei. Nama Godi Dawa iwoka meya wemauie yanu meo weaisa wake ari wemaua wei. Nae Godi iwoka ukakuneke Danu wake nauke ukenewaa ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yesuma nono wei, yanu babae Eibaramuma Nanu fareibisarabai erike rooro uia eno wei. ");
INSERT INTO aby_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yesuma eno weiro i Du orouma ma owekake eno weisa, Ae awoena miya weisa. Anu dai sineka oya fifidi (50) mune mero nono Eibaramu erike weaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Eno weisabaie Yesuma wei, Nako ibisararo Eibaramu danu amaema dawa ai dubuenaro doria wei. ");
INSERT INTO aby_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eno weiro i Du dai orouma dino uisake oma mukake Yesu umafisane uisaro Yesu me ari uike i dai sosi uwara medike ani. ");
INSERT INTO aby_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Moi odoro Yesuini Danu iwoka ukeka orouma enereibisabaie moi naisa kikori bobo doka mi idua yaure ibi. ");
INSERT INTO aby_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","I orouma dawa ma berekeibisabaie Yesunu iwoka ukeka orouma eno weisa, Rabai, yewa mi merama uiba danu amae babaema merama uisi ariro danu amaema dawa naisa kikori bobo dori ibake yaure ibinua eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eno weisaro Yesuma wei, dawa moi merama ukeka uke mero nono danu amae babaema merama ukeka uke meroma danu amaema dawa danu eno bobo doria wei. Godima Danu buna dawabairo ufiro emema efisane ibake danu amaema danu eno bobo doriro yaure ibinua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na we odaikara Godinu waiya sabu ufene weakune danu ubiye dumu sabu sifine ukaku ibake waiya da ufeisia weadama weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yesuma nono wei, yewa orofa akakaro ibaadae Nae yewa orofa akakanu edoro ariya wei. ");
INSERT INTO aby_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Eno weike dooro wisiomu uike bubudoini ma bui uike i doo munike i naisa kikori bobo minu naisaro mamaada eno wei, Sairoma kunaro aniake anu naisa uroa wei. (I Sairoma ibinu ubiye we odaiseka.) Yesuma eno weiro i mi nauike enaenari ane danu naisa uroike nono owerike ereere fari. ");
INSERT INTO aby_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","I mi danu goi orouini danu naiyemukuini dawae eenu weibi mi iwoka uisake ibake eno weisa, i eenu weada me yaure ibeibi miye yewa miba aina weisa? ");
INSERT INTO aby_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eno weisaro moi orouma weisa, euwa i mi iduaya weisaro moi orouma weisa, meba dawa ariya weisa. Eno weisaro i naisa wiroi mima eno wei, na ewadoya wei. ");
INSERT INTO aby_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","11","Eno weibaie anu naisa aneaneme ukinuke irau sininuro eraku weisa? Eno weisaro i mima nono wei, moi mi Danu ibiye Yesu Dawama dooro wisiomu ukinuke doo bubudoini ma bui ukinuke dooma mune nanu naisaro mamaada eno wenu, Sairoma kunaro aniake anu naisa uroa wenuro enaenari ane uroneke enea wei. ");
INSERT INTO aby_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eno weiro i orouma weisa, anu naisa ma wirokinu Mi aboro eno weisabaie Na iwoka meya dawama eno wei. ");
INSERT INTO aby_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","I ku siane ibisa orouma i naisa kikoriro ere karana ui mi i Ferosi weaisa oroubairo we waure fare oisa. ");
INSERT INTO aby_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuma Sabadi odoro dooma ma bui uike mune i minu naisaro mamike ma wiroi. ");
INSERT INTO aby_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wiroiro i orouma i mi waure fare oisaro i Ferosi orouma eno weisa, aneaneme ukinuro eraaku weisa? Weisaro i mima eno wei, Dawama dooro wisiomu ukinuke doo bubudoini ma bui ukinuke mune nanu naisaro maminuke eno wenuro ane Sairoma kunaro uroneke enea wei. ");
INSERT INTO aby_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","17","Eno weiro moi Ferosi orouma nono weisa, Dawa i Sabadi odo imuke dakinuke eno ukinuba ibake Dawae Godibairoma fare meya weisaro moibaima eno weisa, moi merama ukeka orouma eno da ufeisaya weisa. Eno weisake moibai emua Yesubairo enakaro nono moibai emua eno enakake wake we makanada i naisa irau sini mibake eno weisa, anu naisa ma wiroyainu mibake aneme weaku? Eno weisabaie Dawae Godinu we bou ukeka miya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","I miye naisa kikoriroma wirokinua imuke da uisa ibake i Ferosi orouma i minu amae babae u weisaro emuabairo fakiro i Ferosi orouma emuabake eno weisa, yewa miye yanu naisa kikori bobo dokiba ba me eno weisa? Enoroma nono awoenade aneme aneme eraaku weisa? ");
INSERT INTO aby_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I orouma eno weisaro, i aiyakama eno weisi, euwa, yewae uwanu naisa kikori bobo dokua weisi. ");
INSERT INTO aby_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Uwanu dokubairo aneaneme eraaku ari uwa iwoka meya weisi. Dawae dai emewereya danu onamibairo we nauke eawe eno weisi. ");
INSERT INTO aby_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Danu amae babaeye i Ferosi oroubake ia iyakike ibake eno weisi. I Du dai orouma adinaisa eno weisa, ainama Yesue i Mesaia wefekuie dai sosi uwara ubarenaroma yowefeisia weisa ibake danu amae babae enaenari eno weisi, dawae dai emewereya danu onamibairo we nauke eawe weisi. ");
INSERT INTO aby_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eno weisiro ibake i Ferosi orouma u weisaro i naisa kikoribairoma eri mi emuabairo fariro dawabake eno weisa, Yesu, Dawae merama miba Godi Dawa mane we ma irauaiai ukeibia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eno weisaro i mima ma owerike eno wei, Dawa merama miba me ari na iwoka me wei. Nono nae naisa kikori bobo ibeebe nono awoenae erakune ibake ie na iwoka ukakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eno weiro emuama nono weisa, Dawade abairo aneaneme ukinu weisa? Anu naisa aneme aneme ma wiroyainu weisa? ");
INSERT INTO aby_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eno weisaro i mima ma owerike eno wei, yabake wake adinaro wenero nauke dakisaya wei. Anemebake nono wemaro naufone weaisa wei? Yanu ararae Danu iwoka ukeka orou sifone ibake weaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eno weiro dawabake merama wake weisake bunawere wakeroma eno weisa, ae Danu iwoka ukeka mi weisa. Nono iyae Mosesinu iwoka ukeka oroua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","32","Godima Mosesibairo wake weibi, ie iya iwoka sinaisia weisa. Nono yewa Yesu Dawa aboroma fari weisa? Iya Dawa iwoka meya weisaro, i mima ie kawama naukakunea weike nono wei, Dawama nanu naisa ma wironarabairo nono yama Dawa iwoka me. Godima i meramawere ukeka orounu wake nauke dakakubai iya Du orou yaisina iwoka sinaisia wei. Ainama Godibairo guriguri ukakuke Godinu weaku enaenari ukakuro Godima danu wake naukakubai iya iwoka ukaisia eno wei. I mima eno weike nono wei, adinami nauwaroma naisa kikori bobo orou wiroke dakeibaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Godima Dawa da we odaifironae i ukaku ari waiya da ufinea wei. ");
INSERT INTO aby_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","I mima eno weiro nono i orouma dino uisake eno weisa, anu amaema doiai i furoma merama ukeka ukeibikema nono awoena iya we ma iwoka ukakunia weisa? Eno weisake i Du orounu sosiro guriguri da ukeifine ibake emenu sosi uwara ubarenaroma we yowekaro ani. ");
INSERT INTO aby_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuma i mi yoweka wake nauike i mi yodia uke anike fou urike eno wei, i Ba Eme Sini Mi imukakuba me wei? ");
INSERT INTO aby_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eno weiro i mima ma owerike eno wei, Dawa ainadeiro wei? Wearo naumake imuma wei. ");
INSERT INTO aby_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eno weiro Yesuma eno wei, ae Dawa erakuro Dawa awoena aini wake wake weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eno weibaie i mima nono wei, Dai Waria Mi, na imukakunea wei. Eno weike Yesunu umu udiro ifoma kodudu yanai. ");
INSERT INTO aby_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yanairo Yesuma wei, Nae dai kodo uraada emenu merama merama ukeka ma boroo yareimane yewa orofaro ibake weke farea wei. Enoba i naisa kikori bobo orou efeisaro nono i eraisa orou emua naisa kikori bobo orou ari sifiane ibake farea wei. ");
INSERT INTO aby_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eno weiro iedake enare ibisa moi Ferosi orouma nauisake eno weisa, iyaini iini naisa kikori ukakuniba me weisa? ");
INSERT INTO aby_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Eno weisaro Yesuma wei, ya naisa kikori sifiakuie yabairo merama meya eno wei. Nono iya eraisike iwoka ukaisi weaisa ibake yanu merama ukeka yabairo ibeifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuma emebake dubo waure weike eno wei, Nanu ba wake wemaro nauawe weike eno wei, ainama i mamoe abunu ibeka kara udiro fare anifekuke i kara bebefekuke ubarenaro isafekuie i mi dawae wairawereke meo bobo mi. ");
INSERT INTO aby_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Enoba i mamoe abu yawokaku mima i aisamero fare eneibaku. ");
INSERT INTO aby_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I aisame yawokeka miye dawabake i aisame woromakuro i mamoe yawokeibaku mima danu mamoe abunu ibi ibiro weakuro danu wake naukaisake aaraisaro emua waure anakune. ");
INSERT INTO aby_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dawako anakuro nono i mamoe abuma Danu wake nauke karana ukaisake Danu umuro anaisa. ");
INSERT INTO aby_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","I mamoe abue imusu minu wake naukeroma danu umuro ane dakaisake danu wake imusu nauke karana ukaisaba medaisake ia iyaraisake durame anaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","7","I wake nauisa orouma Danu dubo waure wei wake ma nuna uisaba ibake Yesuma i wake nono we ma boroo yarike eno wei, Nanu ba wake wemaro nauawe wei, Nae i mamoe abunu fare aneka aisame eba ari. ");
INSERT INTO aby_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I adinaro fare aneibisa meo bobo sisa oroue waira orou. Emuae meo bobo orou ibake i mamoe abuma emenu wake nauke dakeibisa. ");
INSERT INTO aby_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nae i mamoe abunu aisame ari. Enoba aina ainama Nabairo aafeisake i kara ubarenaro anifeisake wirofeisaro emua irauaiai yawomiauro me irauaiai ibaada ane fare ukaada uruna fou ureifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nono i waira uke meomao weaku mima waira uke ma feare ma merama ufiane ibake aarakua wei. Nae emenu ibeka ma giena umaro irauaiai ibifisane ibake fanea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nae i mamoe abunu irauaiai yawokeka Mi. I mamoe abu yawokeka mima danu mamoe abu yawokenewaa ufiane ibake i mamoe abubake fearekabake ia iyare mero emuabake fearakua wei. ");
INSERT INTO aby_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I oibake waiya ukaku miye ba irauke yawoke dakakune mi ibake i wurufu weisa nauwaro dai kua arima farakuro erakuke i mamoe abu danu meba ibake medakuneke ia iyare durame anakuro i nauwaro dai kua arima farakuke i mamoe abunu duboro amukakuke akaada ma berakakunero fiake ia iyare anaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I miye oibake waiya ukeibaku ibake dawa arara me i mamoe abu yawokenewaa ukeka. I mamoe abu danu meba ibake medakuneke ia iyare durame anaakua wei. ");
INSERT INTO aby_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yesuma eno weike nono wei, Nae i mamoe abunu irau yawokeka miya wei. Nanu Babaema Na iwoka ukakunararo nono Nama Nanu Babae iwoka ukakune enaenari Nanu mamoe abu emua Na iwoka ukakuniaro nono emuama Na iwoka ukaisaba ibake Nae Nanu mamoe abubake feamaua wei. ");
INSERT INTO aby_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Moi aboro aboro ibinisa mamoe abu yaisina Nanua eno wei. I mamoe abuma yewa kara ubarenaro ibe dakaisaba animauke we waumiauro Nanu wake nauke karana ufeisaro i mamoe abu yaisina demui kararo odimiauke yawokeka miye Nanu mane yawokeimiaua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nae Nanu arararo eme yaisinabake feamauke nono fearekaroma uyamauke Nanu me ibeka nono mumau ibake Nanu Babaenu imuka yaisina Nabairo ibinua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Moi mima Na ma feare dafarakuro Nanu arararo eme yaisinabake feamaua wei. Nanu Babaema Na buna daiwere makarake wei ibake Nanu mane feamauke nono uyamaua wei. ");
INSERT INTO aby_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","20","I Du orouma Danu wei wake nauisake imukeka imusu imusu imuisa ibake abanaro enare kuukake ku raarayai uisake moi orouma eno weisa, Dawae seidaniu merama imumu boboro gogore minu wake anemebake naufeisi weisa? ");
INSERT INTO aby_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eno weisaro nono moibaima eno weisa, Danu weaku wakeye i seidaninu merama imumu bobo orounu wake ari we meya weisake eno weisa, i seidaninu merama imumuma naisa kikori bobo orou da ma wirofiakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","24","I odoro Du orou emenu dai sosi uwara ma wirokeka banau uruna iseibisa. I furoe iu daiwere ukeibi. I odoro Yesuma i dai sosi uwara moi seboro enare ibi. I sebonu ibiye Soromoninu sebo eno weaisa. Iro enare ibibaie i Du orouma Dawabairo fakake Dawa enare kara uisake eno weisa, Anu ba wake abonodo wefakuro iya naufeisi eno weisa? Eno weisake nono weisa, Ae i ba Mesaiaba me weisa? Ba wenewaa uaro naufe eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","27","Eno weisaro Yesuma emuabake ma owerike eno wei, Na adinaro wenede ya Nanu wake nauke dakisa wei. Nae Nanu Babaenu wei waiya ukakunero i ukakune waiyama Na ma boroo yarakunararo eraisaya eno weike nono wei, yae Nanu mamoe abu me ibake Nanu weakune wake nauke dakaisaya eno wei. Nanu mamoe abu Na iwoka ukakuniaro nono Nanu weakune wake nauke karana ukaada Nanu umuro aaraisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aaraisaro emuabake me ibene ibene ibeka makakunisaba ibake me sara da feafeisake merama orofaro da anifeisaro moi mima emua Nanu wana daaroma da mareke mufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nanu Babaema emua Nabake makaraya wei. Dawae daiwerero nono emuae daiwere me. Dawae daiwerero moi mima Nanu Babaenu wana daaro emua da mareke mufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Enoba Nanu Babaeini Naini uwae demuiya wei. ");
INSERT INTO aby_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","33","Yesuma eno wei ibake i dai Du orouma Yesu nono ufisane oma mukaro Yesuma eno wei, Nae Godinu buna ukeka keuwere yanu naisaro ukeibakunero eraisaya wei. Anemedei buna ukeka umaro efone ibake Na omama umafokone ukaisa eno weiro nono i dai Du orouma ma owekake eno weisa, Anu irau ukekabake da ufeisiroma nono Ae ba emero nono Ama eno wenu, Godini Naini uwa demuiya wenuke Godibake merama wake wenuba ibake iyama Ae omama umafeisi weisa. ");
INSERT INTO aby_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Eno weisaro Yesuma emuabake nono wei, yanu darawadu bukaro Godima Danu dai waiya ukeka oroubake eno weaku, ya yaisinae moi godi weakunea weaku, Yesuma eno weike nono wei, Godima Danu wake emuabake marieke emuabake ya yaisinae moi godi weia wei. Godinu bukae ba ibake i wake ba ibifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Godima eno weibairo nono anemebake Godinu we mune odaikararo fare Mibake eno weaisa wei? Dawama wenu, Godini Naini uwa demuiya wenuba ibake Dawae Godibairo merama wake weakua weaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nae Nanu Babaenu waiya ba uke dakeimauie Na da imukowe wei. ");
INSERT INTO aby_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yesuma eno weike nono wei, Nae Nanu Babaenu waiya ukakuneroma Nae Godinu Amaraya da imufokoisaie Nanu ukeibakune ibai imuke eawe wei. Eno uke imufoisaie Nanu Babaema Nabairo ibinuro Nama Dawabairo ibineba ibai iwoka sifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesuma i wake eno wei ibake i orouma Yesu mufisake Danu umu wana naama uwafisane weisaro Yesuma emua medirieke iduama me ari sinike aniro mune dauisa. ");
INSERT INTO aby_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesuma Derusaremu goiroma anike Diodeni adua siraa yarike Dioni babadaido minu danu dawako babadaido ukeibirie orofaro fari. ");
INSERT INTO aby_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Fariro eme keuwere Yesunu weifi wake naufisane Dawabairo fakake emenu emenu eno weisa, Dionima moi buna ukeka uke dauike Yesubake weibi wake yaisinae baya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eno weisaro i eme keuwere emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Moi mi danu ibiye Rasorosi, dawa arama daiwere ui. Dawaini danu arumayai, Merini Madaini emua Bedeni goiro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(I arama ui minu moi aruma, Meri, dawae adinaro Yesunu umuro irauaiai urumuma imusu ari aduama ma oinike Yesunu umu uroike nono danu yafa fouma idima adua fofo ma isuri.) ");
INSERT INTO aby_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","4","I orouma Bedeni goiro ibeebe Rasorosima arama daiwere ui. Dawa arama uibake i danu arumayaima wake fo we odaisiro ane Yesubairo eno weisa, Dai Waria Mi, anu naiye mi Rasorosi, dawae arama daiwere ukinuke ibinua weisaro Yesu nauike eno wei, danu arama ukekae feareka arama ufeku nono mebaie emema i ukinu arama efeisake Godinu ibini Nanu ibini we ma daiwere ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuma Madaini Merini Rasorosini emuabake imukari ukeibirie. ");
INSERT INTO aby_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesuma Rasorosi arama ui wake nauike i Yesu Danu ibi goiro odo raarayai ibi. ");
INSERT INTO aby_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","I odo raarayai me siniro uyarike Danu iwoka ukeka oroubake eno wei, Diudia orofaro nono owefeke anife wei. ");
INSERT INTO aby_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yesuma eno weiro Danu iwoka ukeka orouma ma owekake eno weisa, Sisa, i dai Du orouma a ariena omama umamekane uisade nono anemebake iro nono anifane weaku eno weisa? ");
INSERT INTO aby_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Eno weisaro Yesuma emuabake ma owerike eno wei, eweka amukakuie edoro ukakuba ibake irau eneibeka odo farakua wei. I ewekanu edororo enaada yewa orofa akakanu edoro erakuba ure akuaku uke dakakua weike nono wei, ainama dumuro eneiarakuie i edoro dawabairo me ibake ure akuaku ukakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuma emuabake eno weike nono wei, iyanu naiye Rasorosima nauka aine ibinuba animauke dawa ma uyamaua wei. ");
INSERT INTO aby_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eno weiro Danu iwoka ukeka orouma nono weisa, dawa me nauka mane aine ibifeku ie meba uyafekua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","14","Nono Rasorosi dawae ba feari ibake Yesuma eno weiro Danu iwoka ukeka orouma ma nuna uisake Rasorosie ba nauka aine ibinua imuisake weibisa ibake Yesuma emuabake nono eno wei, Rasorosie fearinua wei. ");
INSERT INTO aby_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dawako iro ane da ue ie moi buna ukeka umauke yanu imukeka ma buna umane iro ane da ue ibake rooro ukakune weike wei, nono awoena dawabairo anife wei. ");
INSERT INTO aby_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eno weiro i afafa dorieka moi mi Domasima danu naiyemuku iwoka ukeka oroubake eno wei, iyaini iini anifeke dawa ma feafisane ukeifeisaie iyaini iini feafeisia Domasima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuma Bedeni goiro faribaie Rasorosi feariro ooru uisaro odo fo (4) ooruro aineibi. ");
INSERT INTO aby_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Aine ibiro nono i Derusaremu goiroma Bedeni goiro daabae yafawere me, funaku ibake Du orou keuwere Rasorosi feari wake nauisake ibake fare Madaini Meri yawoke ibaada ii weibisa. ");
INSERT INTO aby_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Idua ibisaro moibaima Yesu aarakua eno weisaro Madama nauike Yesu fou ufine isarike durame aniro nono Meri dawa uwara ubarenaro yaure ibi. ");
INSERT INTO aby_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Madama Yesubairo farike eno wei, A adinaro fafaronae nanu eweri da feafike me ibifinea eno weike nono wei, na iwoka awoena Ama aneme Godibairo wefakuie Godima Abake mamekua wei. ");
INSERT INTO aby_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","24","Eno weiro Yesuma Madabake ma owerike eno wei, anu eweri nono uyafekua imuka merama da imua weiro Madama Yesubake nono wei, i feareroma uyareka odo fafekuro uyafeku imukakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eno weibaie Yesuma wei, Nae i fearekaroma ma uyarekaini me ibene ibene ibekanu ubiya weike nono wei, ainama danu imuka yaisina Nabairo odifekuke feafekuie nono uyafekua wei. ");
INSERT INTO aby_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aina ainama me ibaada emenu imuka yaisina Nabairo odaisaie emua me sara da feafeisake me ibene ibene ibeifeisaya wei. Ie a imukaku wei? ");
INSERT INTO aby_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eno weiro Madama Yesubake ma owerike eno wei, Dai Waria Mi, euwa ie na imukakunea wei. Ae i Mesaia imukakuneke Ae Godibairoma yewa dooro fafane we bou uisa miya eno we imukakunea Madama eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","29","Madama i wake Yesubairo eno weike nono owerike uwararo ane farike Meribake eno wei, uwanu sisa Mi idua farinuke abake weakua weiro Merima nauike sabu uyarike Yesubairo ani. ");
INSERT INTO aby_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Yesu Dawae i goiro fare mero Mada fou uri orofaro idua ibi). ");
INSERT INTO aby_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Idua ibiro i uwararo yaure ibisa Du orouma Merinu uyarike uke aneibi ibai ekake emuaini iini uyakake danu umuro anaada eno we imuisa, danu ewerinu ooru efine anaakua eno we imuisake danu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Anisaro Merima Yesubairo ane farike Danu umu udiro ifoma kodudu yanaike eno wei, A fafaronae nanu eweri da feafike me ibifinea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Dawaini i Du orouini ii weibisaro Yesuma emua erieke imukari urieke eno wei, Rasorosi aboro ooru uke oisa eno weiro emuama eno weisa, Dai Waria Mi ewadoya aarake ea weisa. ");
INSERT INTO aby_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Eno weisabaie Yesuma ii weiro i Du orouma ekake eno weisa, Yesu Dawae Rasorosi dawabake imukari daiwere ukakua weisa. ");
INSERT INTO aby_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eno weisaro nono moibaima eno weisa, yewa mima naisa kikori mi ma wiroibairo anemebake we dakinuro dawa da feare dakinuke fearinu weisa? ");
INSERT INTO aby_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","I Du orouma eno weisaro Yesuma nauike imukari uike ane Rasorosi ooru uke oisa orofaro fari. I ooru uisa orofae oma erabo. ");
INSERT INTO aby_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Rasorosi ooru uisake moi omama i oma eba bibi ure oisaro ibiba Yesuma farike eno wei, i oma mune eka odiawe wei. Eno weiro i ooru uisa minu aruma Madama wei, dawa feariro odo fo (4) me sininuba urumu wefekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eno weiro Yesuma ma owerike Madabake eno wei, adinaisa abairo wene ibai imufakuie Godinu buna daiwere efaku wenea wei. ");
INSERT INTO aby_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eno weiro ibake i eba bibi ure oisa oma mune eka oisa. Mune eka oisaro Yesuma Danu naisa urero eku erike guriguri ukaada eno wei, Babae, awoenae Nanu weakune wake naukakuro Abake we ma irauaiai ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na iwoka Nanu weakune wake areare naukakuro yewa ibinisa orouma ba Ama Na we odaikararo farea eno imufisane ibake eno weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuma eno weike nono wake daiwereroma eno wei, Rasorosi, uyaake aara wei. ");
INSERT INTO aby_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eno weibaie i feari mi, Rasorosi, dawa danu aine ibi orofaroma uyarike idua fari. Danu umu wana yaisina wauma oba uke oisake bokaini iboo naisa yaisina moi wauma oba uisake oisaro aine ibiba eno bobo amuke fari. Amuke fariro Yesuma wei, i wau ma woromiawero anifi Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","46","Merini anisa moi Du orouma emenu imuka yaisina Yesubairo oisaro nono moi Du orouma Derusaremu goiro anisake i Ferosi oroubairo Yesu Danu ui buna i orouma weisaro nauisa. ");
INSERT INTO aby_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nauisake i dai ofereni ode sibore sianeka orouini Ferosi orouma eno weisa, kanisoro midini ufeisia weisaro ibake i kanisoro orou yaisina idua fare ku siaka. Fare ku siakaro i dai orouma eno weisa, i Mima Danu buna ukeka keuwere ukakuba aneaneme ufeisi weisa? ");
INSERT INTO aby_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eno ukeifekuro eme yaisina Danu umuro aninao ufeisaba i Romani dai yawokeka oroubairo wefeisaro emenu ame orou we odaifeisaro fafeisake iyanu dai sosi uwaraini iyanu Du orou goi goi yaisina ma merama ufeisake inaa yanao ufeisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Eno weisaro i ofereni ode sibore sianeka orou emenu dai mi danu ibiye Kaiyafasi, dawama uyarike eno wei, yanu imukekae ba me. I Mi dawa mane feafekuie iraua eno wei, ya ibai anemebake imuke dakisake eno weaisa wei. Anemebake iya Du orou yaisina feafeisi wei? ");
INSERT INTO aby_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiyafasi dawae i oyaro emenu dai ofereni ode sibore sianeka miba ibake Godima i imukeka mai ibake Yesu Dawae i Du oroubake feafekua we bou ui. ");
INSERT INTO aby_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","I we bou ukekae i Du orou emua manebake me. Godinu amaraku yaisina aboro aboro ibinisa orouini emua yaisinabake feafekuke mune demui orou uke odifiaku. ");
INSERT INTO aby_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Enoba i Du orouma eno weisa, Yesu Dawa ma feafeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","I odoroma Yesu i Du oroubairo ane dakeibi. Derusaremu goi medike Efaramu goiro ani. I goiye eme ibe me orofa udiro ibiro ani. Yesuma iro anike Danu iwoka ukeka orouini demuiro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nono dubuenaro i Godima Isaraera orounu Idifiroma waure aneka banau uruna odo fu siniro eme keuwere aboro aboro yaisina Derusaremu goiro emenu guriguri ukekanu bisaraba ibake emenu ubu ofe yaisina amearubu ufine ibake aduama urofisane faka. ");
INSERT INTO aby_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Fakake Yesu yodia ukeebe fou ure dauisake koroko siriero dai sosi uwara ubarenaro enakake eno weisa aneme imukaisa? Dawa yewa banauro fafekuba me eno weibisa? ");
INSERT INTO aby_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eno weibisaro i dai ofereni ode sibore sianeka orouini Ferosi orouma adinaro eno weisa, ainama Yesu efekuie iyabairo weforo naufeye weisa. Emenu ararae Yesu yabafisake Danu umu wana naama uwafisane ibake eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Odo sikisi (6) me sifiro i Godima Isaraera orou Idifiroma waure aneka banau uruna iseka odo fafine ui. I odo sikisi (6) mesine me ibooro ibiro Yesu Bedeni goiro ani. I feariro nono ma uyari mi Rasorosi danu uwararo ani. ");
INSERT INTO aby_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dawa iro aniro uruna ouisaro moi orouini Yesuini Rasorosini emua yaukaro Madama uruna korike mariero demuiro isa. ");
INSERT INTO aby_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Uruna iseibisabaie Merima uyarike irauaiai urumuma imusu ari adua danu make oi munekae daiwere, i aduama munike Yesunu umuro ma oinike uroke odike afua umanike danu bokai idi yafawereba ima Yesu Danu umu ma isuriro i irauaiai urumuma i uwara wake fari. ");
INSERT INTO aby_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Diudiasi Ikariada dawae Yesunu duero (12) moi iwoka ukeka mi, dawama Yesu ma feafisane we forai mi, dawama eno wei, i irauaiai urumuma imusu ari adua makeroma dedi kina (K30) muneroma eraerabusa me orou make dakinuke eno anemebake ukinu wei? ");
INSERT INTO aby_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I mi dawae i eraerabusa me orou imuke darieke nono dawae i iwoka ukeka orou emenu oi banika yawokada emenu oi waira ukeibike ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","I mima eno weiro Yesuma ma owerike eno wei, i arumabake dino wake da weaweke mediawe wei, i ibinu aduama dawabairo ibifekuro Nanu ooru ukeka odoro Nanu ofero ma oifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I eraerabusa me oroue yabairo aine wai ure ibeifeisaro nono Nae yaini aine wai ure da ibimaua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Moi Du orou keuwere Yesu Bedini goiro ibinua weisaro nauisake Yesuini Rasorosi i feariro ma uyari mi efiasane ibake ane faka. ");
INSERT INTO aby_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Eme keuwere Rasorosi fearekaroma uyaribai ekake emenu imuka yaisina Yesubairo oisaba ibake i dai ofereni ode sibore sianeka orouma Rasorosini Yesu ma feareka daaba yodia uisa. ");
INSERT INTO aby_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Nono moi odoro Yesuma Derusaremu goiro fafine uiro i banauro faka orouma Yesu Danu aareka wake nauisake farai kakabai kuukake Yesu we ma yokomifisane anisa. I orouma anaada eno weisa, iyanu ma wirokeka mima aaraku. Godima Dawa we odairo Dawae Godinu ibiroma aaraku weada we ma irauaiai ukaada daiwere Guriki wakeroma ousana weibisa. Ae iya Du orou iyanu yawokeka dai miwere eno weibisa. ");
INSERT INTO aby_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Eno weibisaro Yesuma okoa doniki abu duboro yaurike ani. Godinu bukaroma enaenari eno weaku, ya Saioni orofaro ibinisa orou iya da siawero yanu Dai yawokeka miwere okoa doniki duboro yaufekuke yabairo fafekua eno weaku. ");
INSERT INTO aby_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu Danu iwoka ukeka orou ibai ma nuna uisakema nono Yesu Dawa fearike nono uyarike Danu irauaiai ure orofaro aniroma ai idua Godinu bukaroma weaku wake imukake ie Dawabake weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesuma i Rasorosi feariro ooruroma u weike ma uyari odoro i eme yaisina Dawaini demuiro enereibisa orouini emuama Yesu Danu ukeibi ibai ekake i wake yaisina we me sikaro nauka. ");
INSERT INTO aby_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Danu ukeibibai yaisina weisaro nauisaba ibake i eme yaisina Yesu fou ufisane anisa. ");
INSERT INTO aby_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","I orou yaisina anisaro i Ferosi orouma wake we makakake eno weisa, yewa orou eyakawe iyanu wake nauke dakaisake i orou yaisina Danu umuro anaisaba ibake iyanu arara ukeka da ufeisia weisa. ");
INSERT INTO aby_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Moi Guriki orouini emuama i banau odoro Godibairo guriguri ufisane Derusaremu goiro amuke anisa. ");
INSERT INTO aby_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","22","Iro amuke anisake Firifu, dawae Gareri orofa Besaida goi mi, dawabairo fakake eno weisa, dai mi, iyae Yesu efene faraisia weisaro Firifuma nauike emua idua medirieke Enudurubairo ani. Anike Enudurubairo i wake ane weiro dawaini demuiro Yesubairo i wake wefisine anisi. ");
INSERT INTO aby_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Anisike Yesubairo fakike i wake weisiro Yesuma ma owerike eno wei, i Ba Eme Sini Minu odo idua farinuba Godima Dawa we ma daiwere ufekuro i irau ure orofaro amuke anifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei, konoura kai doo ubarenaro wawaisaro kukaubai yaurakuke awoena kua fare amukakuke kaibai keuwere sinaku. Nono yobai wawe dakaisaie kaibai uwane dakaku enaenari Na feamauie eme keuwere uyafeisa. Nono Na eno da feamauie emua da uyafeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aina mima danu arara yewa dooro danu onami imukada Yesu imuke da ufekuie dawa feafeku. Nono aina mi yewa dooro danu onami imuke da ufekuie Yesu imuka mane imufekuie dawa me ibene ibene ibifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ainama Nanu waiya moi ena baruna mufine ufekuie Nanu umuro aafi wei. Na aboro ibimauie Nanu waiya ukeka mi iro ibifekua wei. Nono ainama Nanu waiya ufekuie Godima dawa we ma daiwere ufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuma eno wei, Nanu imuka merama ukakua wei. Aneme wemau? Babae, Nanu feareka odo Nabairoma mune eka odia wemau? Me, eno da wemau wei. Ibake weke yewa orofaro fareba feamaua wei. ");
INSERT INTO aby_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Babae, Anu ibi we ma daiwere ua wei. Yesuma eno weibaie ureroma wake isare aarike eno wei, Nanu ibi we ma daiwere ue enaenari nono Na we ma daiwere umau wei. ");
INSERT INTO aby_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Godima eno weiro i ku siane ibisa orouma naukake moi orouma eno weisa, ure urinua weisaro nono moibaima eno weisa, moi aneruma Dawabake wake weakua weisa. ");
INSERT INTO aby_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","31","Eno weisaro Yesuma eno wei, i wakeye Nabake we mero yabake weakua weike nono wei, Na ma feafisane ukaisa ibake Godinu kodo odo farinuba i Nanu wake nauke dakaisa orou fanisi mafiakuke nono yewa orofa yawokaku mi, seidani, ma berefekua wei. ");
INSERT INTO aby_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na korosiro ure odifokaisaroma eme yaisina ma youre Nanu enaro odimiaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Danu feafekubai emuabairo we ma boroo yaraada ibake eno wei.) ");
INSERT INTO aby_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yesuma eno weiro i ku siane ibisa orouma eno weisa, iyanu darawadu bukaroma eno weaku, i Mesaia Dawa da feafekuke me ibene ibene ibifeku weakua weisa. Eno weakude nono anemebake ama eno wenu, i Ba Eme Sini Mi korosiro ikokoma ure odifeisa wenua weisake nono weisa, i Ba Eme Sini Mide ainadeiro weisa? ");
INSERT INTO aby_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Eno weisaro Yesuma wei, Nanu wake wemaro nauawe wei, Nae dai edoro. Yaini dai menaku ibimauro Nanu edororo aafoisake Nanu wake naufoisaie i merama ukeka dumu arima ya dadau dafiakuro Godinu irau daaba da ma nuna ufoisaya wei. Nono i dumuro eneibaisa orou emua iwoka me aboro aneibaisa ibai. ");
INSERT INTO aby_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nae edoro ari. Ibake Na nauke imuke ufoisaie i edoronu amaraku ari sifoisake irauaiai mane ukeifoisaya eno wei. Yesuma eno weike nono emua idua medirieke me ari uke aniro Dawa ere dauisa. ");
INSERT INTO aby_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuma buna ukeka keuwere ukeibiro ereibisakema nono Dawae i Mesaiaya we imuke dakeibisa. ");
INSERT INTO aby_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","40","Eno ukeibisa ibake Godinu we bou ukeka mi Isaiyanu adinaro wei wake enaenari ui. Isaiyanu adinaro wei wakeye eno wei, Dai Waria Godi iyanu ba wake nauke dakaisake nono Yesunu buna ukeka eraisakema imuke dakaisaba ibake iyanu Dai Waria Godi nauke imuke dakaisaba, ibake Isaiyama weike nono eno wei, Godima emenu naisa ma kinu ukinuke emenu imuka ma ara ukinuroma nono naisama enao ufeisake imukama imunao ufeisake Nabairo aanao ufeisake wironao ufeisaba, ibake Isaiyama eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiyama Yesunu bunaini arakekaini erike ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Moi dai Du orounu yawokeka orouma emenu imuka yaisina Yesubairo oisake nono moi oroubairo Yesunu wake we dauisaro moi Ferosi orouma emua dai sosi uwararoma yowenao ufiakaisaba ibake Yesunu wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Emenu ararae eme mane we ma irauaiai ukeka. Emua arara me Godi we ma irauaiai ukeka ibake emuabairo Yesunu wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuma u weike eno wei, ainama Na nauke imuke ukakuie Na we odaikara Godi nauke imuke ukaku eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ainama Na erakunaraie Na we odaikara Godi eraaku wei. ");
INSERT INTO aby_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nae yewa orofa akakanu edoro ibake fareba ainama Na nauke imuke ufekuie danu merama ukeka dumu ariro da ibifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nono ainama Nanu wake da naufekuke nono uke dafekuie dawa kodo da umauke fanisi da mamiau wei. Nae eme kodo umiane fare da ueke eme ma wiromiane ibake farea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ainama Nanu wake nauke dakakuke Na medakunaraie dawa i kodo ureka mima kodo ufine we odiro ibinua eno wei. Nanu weakune wakeye dai kodo ureka mi ari wei. Nanu weakune wake ima dawa dubuenaro kodo ufekua wei. ");
INSERT INTO aby_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nanu imukeka wake mane we dakakunea wei. Nanu Babaema eno wea weakuro enaenari weakune wei. ");
INSERT INTO aby_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ainama Nanu Babaenu riba wake naufekuie me ibene ibene ibifekua wei. Ibake Nama Nanu Babaenu wake weakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","I odo me sifiro wai ufiro Godima i Isaraera orou Idifiroma waure aneka banau uruna iseka odo fafeku. Yesu Dawa iwoka sini, Danu yewa doo mederoma urero aneka odo fariro anifine ukaada ibake Danu iwoka ukeka oroubake imukari ukeibi. Dawa yewa dooro ibaada i furo emuabake imukari ukeibi enaenari urero amufine ukaada emuabake imukari daiwere ukeibirie. ");
INSERT INTO aby_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Seidanima Yesu we forakeka imuka Diudiasi Ikariadabairo mai. Yesuini Danu iwoka ukeka orouini uruna demuiro iseibisabaie Yesu Dawa iwoka, Godima Dawabairo buna yaisina mairo Godibairoma fariba enaenari nono Godibairo amuke anifeku ibai iwoka sini. ");
INSERT INTO aby_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ibaie Dawa iwoka sinike uyarike Danu dei barukeka ma kukune mune eka odike dawero munike abagoro uwani. ");
INSERT INTO aby_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eno uike adua munike dai naberoro ma oinike Danu iwoka ukeka orounu umu aduama uroke odirieke Danu abagoro uwani daweroma ma isuriie. ");
INSERT INTO aby_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eno ukeebe Saimoni Fidabairo fari. Fariro Fidama Yesubake eno wei, Dai Waria Mi, nanu umue da urofakua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eno weiro Yesuma wei, Nanu ukakune waiya awoena ma nuna ukakuba dubuenaroma iwoka sifakua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yesuma eno weibaie Fidama nono wei, media nanu umu da urofakua weiro Yesuma ma owerike eno wei, anu umu da uromauie ae Nanu iwoka ukeka mi meya wei. ");
INSERT INTO aby_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yesuma eno weiro Saimoni Fidama ma owerike eno wei, Dai Waria Mi, nanu umu mane me, nanu wanaini bokaini yaisina uroa wei. ");
INSERT INTO aby_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eno weiro Yesuma Saimoni Fidabake nono wei, ainama adua karakuie ino me ibake umu mane urokakua weike wei, ya yaisinae ino mero nono una demui mane inowerea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu Dawa iwoka Dawa we sibofekuro mufeisa mi ibake eno wei, ya yaisinae ino mero una demui mane ino boboya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Emenu umu uroke me sinike Danu dei barukeka nono mune baruike Danu yaureka orofaro yaurike emuabake eno wei, Nanu awoena yabairo une ibai imukaisaba me wei? ");
INSERT INTO aby_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yama Nabake Dai Waria Mike Sisa Mi weaisaie ba weaisa. Ie ba Naya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nae yanu Dai Waria Mike Sisa Mi. Enoba Nama yanu umu uronea yanu yanu umu enaenari uroke makaewe wei. ");
INSERT INTO aby_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nae yanu Dai Waria Mima yanu umu uronero erisaba Nama yabairo unero erisa waiya enaenari ukeibiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei, i waiya ukeka miye daiwere mero nono i yawokeka mi dawae daiwere, enaenari i we odairo ani miye daiwere mero nono i we odai mi Dawae daiwere wei. ");
INSERT INTO aby_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nanu wake naukaisaba enaenari ufoisaie Godima yanu imuka ma irauaiai ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ya yaisinabake we dakakunia. Nanu we mune odia orou emua Na iwoka ukakuniake ibake emuabake weakunea eno wei. Eno uneba Godinu bukaro weaku wake enaenari ukinu. Godinu bukaro wakema eno weaku, Naini demuiro uruna isaisu, i mima Na medifarakuke we forafarakuro mufokaisaya Godinu bukaro wake eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I wake yabake awoena idua weakuneba nono dubuenaro enaenari ufekuro iwoka sifoisake Na nauke imuke ukofoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei, ainama Nanu we odaisakunia orou mufiakuie dawa Na we mufarakua eno wei. Nono ainama Na mufarakuie dawa Na we odaikara Godi mufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuma eno weike imuka merama sinaada eno wei, Nanu ba wake wemaro nauawe, yewado demuiro yaure ibinisi moi mima Na we sibofarakua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eno weiro ibake Danu iwoka ukeka orouma emenu emenu ere makanada Yesu Danu wei wake ma nuna uisa. ");
INSERT INTO aby_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Moi Yesunu iwoka ukeka mima Yesu buudiro yaure ibi. I miye Yesunu naiye ubi ari eno. ");
INSERT INTO aby_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","I Yesu Danu iwoka ukeka orouma Yesunu wei wake ma nuna uisake ibake Fidama i mibake wana fisi ukaada eno wei, Dawae anemebake weaku ariya we nauke ea wei. ");
INSERT INTO aby_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eno weiro i Yesunu udiro yaure ibi mima Yesubairo eno wei, Dai Waria Mi, ainama i ari eno ufeku wei? ");
INSERT INTO aby_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Eno weiro Yesuma wei, yewa uruna naberoro uruna komauke mamauro mufeku, i mufeku mima Na we forafarakuro mufeisaya weike ena wei enaenari uike Saimoni Ikariadanu amara Diudiasibairo mairo munike i. ");
INSERT INTO aby_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Munike ise me siniro seidanima Diudiasinu imuka ubarenaro isari. Eno uiro Yesuma Diudiasibake eno wei, anu arara waiya sabu ua wei. ");
INSERT INTO aby_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","29","Eno weiro i Danu iwoka ukeka orouma i wei wake ma nuna uisake we imuisa, Diudiasima iyanu oi banika yawokaku ibake Yesuma iyanu uruna ane oima make mua wenuba danu i eraerabusa me oroubake oi moi mayana wenu ariya eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Diudiasima i uruna mune ise me sinike aweawero sabu ani. Aweaweroe dumuwere. ");
INSERT INTO aby_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Diudiasi aweawero aniro Yesuma eno wei, i Ba Eme Sini Minu odo idua farinuba Nanu buna daiwere ma boroo yafekuro efoisake nono Godinu arakekawere efoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dawama Godinu buna ma boroo yafekuro enaenari Godima Danu buna awoena ma boroo yafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yesuma nono wei, Nanu adara, yabairo odo yafa menaku ibimaua wei. Nanu Du oroubake adinaro we wake enaenari yabake nono weakune. Na animauie yama Na yodia ukeebe da fou ufokoisake Nanu animau orofaro awoena da aafoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yabake awoena darawadu eno mamiau, Nanu imuka yaisina yabairo ibinu enaenari yanu yanu imukari uke makaneibiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yewa orofa akaka orouma yanu imukari ukeka efeisake ya oroue ba Yesunu iwoka ukeka orou iwoka ufiakaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesuma eno we me sinibaie Saimoni Fidama ma owerike eno wei, Dai Waria Mi, aboro anifaku wei? Eno weibaie Yesuma eno wei, Nanu animau orofaro awoena Nanu umuro da aafakuke dubuenaroma Nanu umuro aafakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eno weiro Fidama wei, anemebake awoena aini da aamau weike nono wei, nae Abake feamane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Eno weiro Yesuma Fidabake ma owerike eno wei, Nabake feafaku? Nanu ba wake wemaro naua wei, kokoroko yama we dafekuro ako Nanu ibi buuba we ma fe yaraada meo wefakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuma eno wei, imuka merama da uaweke Godi mane nauke imuke uaweke Naini enaenari nauke imuke uawe wei. ");
INSERT INTO aby_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nanu Babaenu ibinu orofaro uwara keuwere ibinu, iro uwara meronae yabairo yewa wake da wemanea wei. ");
INSERT INTO aby_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iro animauke yanu uwara uke bou umauke nono dubuenaro owere famauke ya waure animiaua wei. Iro waure animiauro yaini Naini demuiro ibifeisia wei. ");
INSERT INTO aby_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nanu animau daaba ya iwoka sinaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesuma eno weiro Domasima ma owerike eno wei, Dai Waria Mi, Anu anifaku orofa iya iwoka meba Anu anifaku daaba aneaneme iwoka sifeisi wei? ");
INSERT INTO aby_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Domasima eno weiro Yesuma nono wei, Nae i urero aneka daabanu ubini Nae i baya weekanu ubini Nae i me ibekanu ubi ibake moi mima Nabairo dawako da fareroma nono Babaebairo da anifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na iwoka sifokoronae Nanu Babae iwoka sifonea wei. Awoenae Godi eraisaba ibake Dawa iwoka sinaisa wei. ");
INSERT INTO aby_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Eno weiro Firifuma wei, Ama Babae Godi we siboaro efeke iyanu imuka irauaiai ufe wei. ");
INSERT INTO aby_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eno weiro Yesuma wei, Firifu, yaini odo keuwere ibakunede anemebake Na ma nuna ukaisa wei? Ainama Na efarakuie i mi dawa Nanu Babae efekua wei. Anemebake iyanu Babae Godi we siboaro efe wenu wei? ");
INSERT INTO aby_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nanu wake wemaro naua wei, Nanu Babaeini naini uwae demuiya eno wei. Dawae Naro Nae Dawaya eno wei. Nanu imukeka wake mane we dakakunero Nanu imuka ubarenaro ibinu Babaema Danu waiya ukakua wei. ");
INSERT INTO aby_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nanu wake wemaro nauawe, Nanu Babaeini Naini uwae demuiya ibai imuke eawe. Mebaie Nanu buna ukeibisara iro imuke eaweke Na imukowe wei. ");
INSERT INTO aby_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yesuma eno weike nono wei, Nanu ba wake wemaro nauawe wei. Aina ainama emenu imuka yaisina Nabairo odifeisaie Nanu buna ukakune ari ufeisaro Nae Nanu Babaebairo animauba emuama buna daiwere, Nama okoa bunanaku ukakune ari mero daiwere ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Anemerabubake Nanu ibiro we nauke efoisaie enaenari umauro Godinu buna Nabairo efoisake Danu ibi we ma daiwere ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anemerabubake Nanu ibiro we nauke efoisaie enaenari umaua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesuma nono eno wei, yama Nabake imukari ufokoisaie Nanu riba wake naukenewaa ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eno ufoisaie Nanu Babaebairo eno wemau, emuabairo moi unu koreka Mi we odaia wemauro yabairo we odaifekuro isare aafekuke me ibene ibene ibeifekua wei. Dawae Godinu Imumu Irau. Dawa Godinu ba wake mane we ma iwoka ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I orofa akaka aboro aboro Godinu wake nauke dauisa orou Dawa ere nauke dauisaba ibake Dawa iya mune meya weaisaroma nono Dawaini yaini demuiro ibinisaya eno wei. Nono dubuenaro yanu imuka ubarenaro isafekuke ibeifekuba yama Dawa iwoka sifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yesuma nono wei, ya da medimiauro amae babae me amaraku ari da sifoisaya eno weike wei, yabairo nono owere famaua wei. ");
INSERT INTO aby_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Odo keu menaku ibimauro i orofa akaka Nanu wake nauke dakaisa orouma Na da efokaisaro nono yama Na efokoisaya eno wei. Na me ibimau enaenari yaini me ibifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Godinu Imumu Irau yabairo fafeku i furo eno iwoka sifoisaya wei. Nae Godibairo ibinero nono yae Nabairo ibinisa, Nae yabairo ibinebaia iwoka sifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aina ainama Nanu darawadu naukenewaa ufeisaie emenu imuka yaisina Nabairo odifeisaro Godima i oroubairo Danu imuka emuabairo odifekua wei. Odifekuro Naini Nanu imuka yaisina emuabairo odimauke Nama Nanu onami emuabairo ma boroo yamiauro emua iwoka sifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eno weiro nono Diudiasi Ikariada meroma moi Diudiasima ma owerike eno wei, Dai Waria Mi, aneaneme iya Godinu wake naukaisi orou mane Anu onamima ma boroo yafakuke i orofa akakaro Godinu wake nauke me oroubairo da ma boroo yafiaku wei? ");
INSERT INTO aby_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Eno weiro Yesuma ma owerike eno wei, aina ainama emenu imuka yaisina Nabairo odifeisake Nanu wake naukenewaa ufeisaie Nanu Babaema Danu imuka yaisina emuabairo odifekuro Dawaini Naini demuiro emuabairo ibifukua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aina ainama emenu imuka yaisina Nabairo ode dakaisaie Nanu wake naukaisakema nono uke dakaisaya eno wei. Nanu imukeka wakema we dakakuneke Godinu imukeka wake mane weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yesuma eno wei, Nae yaini kowede demuiro ibaada ibake eno weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nono dubuenaro Godima Danu Imumu Irau, ya unu koreka Mi ari, Nanu ibiroma we odaifekuro isare aafekuke ya yaisina we ma iwoka ufiakuke yanu awara ma owefiakuro Nanu awoena weakune wake imufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nanu irauaiai kakawera yabake mamiauro irauaiai ibifoisa. I irauaiai kakawerae yewa dooro ibinisa orounu mero ie Nanu irauaiai kakaweraya eno wei. Imuka merama da imuaweke ia da siawe eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nae animauke nono owemauke yabairo famau wenero naukisaya wei. Nanu Babaeye daiwere nono Nae okoanaku Nabake imukari ufoisaie Nanu Babaebairo animau wenero naukisa wake ibake rooro ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yaini kowede ibaada demuiro Babaebairo animaua wenero naukisa wake enaenari ufekuro efoisake Na imuke nauke ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wake yafawere yabake da wemaua wei. Yewa orofa akaka aboro aboro orou yawokakune merama mi fafine ukakua wei. Danu bunae daiwere meba dawama Na da yawofarakua wei. ");
INSERT INTO aby_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Enoroma nono Nama Godinu weaku wake enaenari ukakuneba i orofa akaka orou yaisina eno we imufeisa, Dawa Danu imuka yaisina Godibairo odakuke imukari daiwere ukaku we imufeisaya eno wei. Yesuma eno weike nono wei, uyaewero ewadoma moiro anife Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuma eno wei, Nae i waiyaro ibinu ba gureifi naadidi ubi ari. Nono Nanu Babae Dawae i waiya yawokeka mi. ");
INSERT INTO aby_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nanu kai uwane dakaku iwarae Dawama umane kuure sianakuke eraada uraine sianaku. Nono i kai uwanaisa iwarabai kai keuwere uwafisane ibake uunabai owainanaku kuurakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I arie yama Nanu weakune wake naukaisa ibake Godima yanu imuka ma amearubu ukakuro Danu imukeka ukenewaa ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ibake yae i kai uwanaisa iwarabai ariya eno wei. Yama Nabairo ibenewaa ufoisaie nono Naini iini yabairo ibenewaa umaua eno wei. I gureifi naadidi ubi meie iwarabai kai da uwafeisaya wei, enaenari yama Nabairo da ibifoisaie yanu ukeka sinekae irauaiai meya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yesuma nono wei, Nae i gureifi naadidi ubi ariro nono yae i gureifi naadidi iwarabai ariya wei. Ainama Nabairo ibenewaa ufekuie dawabairo ibenewaa umauro danu ukeka sinekae irauaiai mane ukeifekua wei, i kaibai keuwere uwanaku iwara ari sifekua wei. Yama Na mederoma nono yabairo buna meba ibake Godinu arara da ufoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Moi mima Nabairo da ibifekuie Godima umane kuure sianakuro sibi uraku i ari dawae enoya wei. Sibi ufekuro iwara fira ufekuke inaaro siafekuro inaama yafekua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yama Nabairo ibenewaa ufoisake Nanu wake naukenewaa ufoisake anemerabubake Nanu ibiro we nauke efoisaie enaenari yabairo Babaema mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yanu ukeka sinekae irauaiaiba eme moima efeisake eno imufeisa, i oroue Yesunu iwoka ukeka orou eno we imufeisake Godi we ma daiwere ufeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Godima Danu imuka yaisina Nabairo ibinu enaenari Nanu imuka yaisina yabairo ibinua irauaiai ibiawero Nanu imuka yaisina yabairo ibifi wei. ");
INSERT INTO aby_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nama Godinu weaku wake naukenewaa ukakunero Danu imuka yaisina Nabairo ibinu enaenarie yama Nanu wake naukenewaa ufoisaie Nanu imuka yaisina yabairo ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","I wake yabake weneba Nanu rooro ukeka yabairo ibifekuro yae rooro daiwere ukeifoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yesuma eno weike nono wei, Nanu riba wakeye eno, Nanu imuka yaisina yabairo ibinu i ari yanu yanu imukari uke makaneibiawe wei. ");
INSERT INTO aby_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Moi mima danu naiyemukubake feafine imukari daiwere ufekuie imukari ukekanu ubiya wei. ");
INSERT INTO aby_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nanu weakune wake naukenewaa ukaisaie yae Nanu naiyemukua wei. ");
INSERT INTO aby_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yae Nanu waiya ukeka moi oroua da wemauke Nanu naiyemuku wemaua wei. I waiya ukeka oroue emenu yawokeka minu imukeka emua iwoka me. Nanu Babaenu wake yaisina enaenari yabairo weakunero naukaisaba ibake yae Nanu naiyemukua weakune wei. ");
INSERT INTO aby_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yama Na we mune dayaka. Irau ukeka uforo emake yanu irau ukeka me ibene ibene ibifine ibake ya munakuniaba anemerabubake Godibairo Nanu ibiro we nauke efoisaie yabairo mafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yewa riba wake yabake eno weakune yanu yanu imukari uke makaneibiawe weakunea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesuma eno wei, i orofa akaka orouma yabake imuka ka ukaisaie Nako imuka ka uke yayakakema dubuena yabairo ai ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yae i orofa akakaro Godinu wake nauke me orou ari eno me ibiforonae emuama yabake imukari ukeifiakane nono yae emua ari eno me ibake yabake imuka ka ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nanu adinaro we wake imuawe wei. Nae eno we, i waiya ukeka miye daiwerero nono i eme ereka miye okoanaku ie ba me. I eme ereka miye daiwerero nono i waiya ukeka miye okoanaku eno weya wei. Nae i eme ereka mi ibake meramawere uke yayakaba enaenari yae i Nanu waiya ukeka orou ibake ya meramawere uke yafiakaisaya eno wei. Nanu wake emua adinaro naufisaronae enaenari yanu wefo wake naufisanea wei. ");
INSERT INTO aby_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yewa orofa akaka orouma Na we odaikara Godi ma nuna uisaba yae Nanu orou ibake yabake meramawere uke yafiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Emuabairo da famake Nanu wake emuabairo da wemaronae emuabairo merama me. Nono emuabairo fareke Nanu wake wero nauke dauisaba ibake emenu merama merama ukeka emuabairo ibinuba ibake yabairo iya merama meya eno da wefeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ainama Nabake imuka ka ukakuie Nanu Babaebake imuka ka ukakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Moi mima emuabairo buna ukeka uke da ufiro Nanu imusu mane buna da umaronae emuabairo merama meya wei. Eno weike nono wei, dai buna ukeka ukeibisararo ereibisaba Naini Nanu Babae Godini uwabake imuka ka uisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Godinu bukaro ibinu wake i ari eno ufisane ibake yewae eno uisaba ie iraua eno wei. Emuae Nabake me sara imuka ka uisa ibaie Godinu bukaro i ari eno ibinua wei. ");
INSERT INTO aby_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","I unu koreka Imumu Irau Godibairoma we odaimauro yabairo isare aafekua wei. Dawama Godinu ba wake we ma iwoka ufiakua wei. I Imumu Irau Dawae Godibairoma isafekuke Nanu wene wake yaisina emebairo yafiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yae adinami nauwaroma Nabairo ibaada ereibisaba yae Nanu wake weeka oroua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuma nono eno wei, i wake yaisina wenero naukisaba nono dubuenaro yama Na da medifokoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Moi orouma ya Du orounu sosi uwararoma we yowefiakaisa wei. I odo idua fafekuba awoenae moi orouma Godinu waiya ufeisia eno wefeisake ibake ya ma feafiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","I orouma Nanu Babaeini Naini uwa emua iwoka meba ibake eno ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nama eno weakuneba dubuenaro enaenari ufekuro Nanu we iifa ukakune i wake imufoisaya Yesuma nono eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yesuma eno wei, adinaroe yabairo ibaada ibake yewa wake we da ue wei. ");
INSERT INTO aby_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nono awoenae Na we odaikara Godibairo animaua wei. Na iro animauro yama Dawae aboro anifeku ari we nauke ere dakakunekake Nanu wene wakebake imukari ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nanu wakeye ba. Na iro animauie irauaiai. Nono Na da animauie yanu unu koreka Imumu Irau Dawa yabairo da fafekua wei. Na animauke Dawa we odaimauro yabairo isare aafekua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yabairo isare aafekuie i orofa akakaro Godinu wake nauke dakaisa orou emenu merama merama ukeka we ma iwoka ufekuke Babae Godini uwanu gienabu ukeka we ma iwoka ufekuke Godima kodo ufekuke fanisi mafine we ma iwoka ufiakua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Emua emenu imuka yaisina Nabairo ode dakaisaba emenu merama merama ukeka we ma iwoka ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nae Nanu Babaebairo animauro Na nono da efokoisaba ibake Dawama ya aneanemeke Godinu ibooro gienabu ufoisa ibai we ma iwoka ufiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Babae Godima yewa orofa akaka merama yawokaku mibairo kodo uriba ibake i Imumu Irauma Babae Godinu kodo ureka daaba we ma iwoka ufekua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nanu wake keuwere wemauro koko anao ufoisaba ibake yabairo wake keuwere da wemaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Babae Godinu ba Imumu Irauma fafekuke yabake ba wake we ma iwoka ufiaku. Nono Danu imukeka wake da wefekuke Babaeini uwanu imukeka wake wefukuro naufeku i wake enaenari wefekuke i dubuenaro fafeku eraerabusa yaisina yabairo wefekua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nanu imukeka yaisina mufekuke we ma iwoka ufiakuro naukada Na we ma irauaiai ufokoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nanu Babaenu imukeka eraerabusae Nanuba ibake eno wene, Nanu imukeka mufekuke yabairo we ma iwoka ufiaku wenea Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Odo keu me mane ibimauke animauro yama Na nono da efokoisake nono odo keu mero yama Na nono efokoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Yesuma eno weiro Danu moi iwoka ukeka orouma we makanada eno weisa, Dawa aneme wenu, odo keu mero yama Na da efokaisake nono odo keu mero Na efokoisaya weakuke Nae Nanu Babaebairo animaua weakua weisake nono eno weisa, i odo keu me wenu wakede aneme weisa? Danu wenu wake iya iwoka meya weisa. ");
INSERT INTO aby_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuma i wake Dawabairo we nauke efisane ukeibisabai Dawa iwoka sinike emuabake eno wei, Nama wene, odo keu mero Na da efokoisake nono odo keu mero Na efokoisa wene, i wakebake weaisa? ");
INSERT INTO aby_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nanu ba wake wemaro nauawe wei, yama ii weada imukari ufoisaro i orofa akakaro Godinu wake nauke dakaisa orouma rooro ufeisaya wei. Yae imukari ufoisake nono medifoisake rooro ufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Moi awekama amara dofine ukaadae oferi daiwerebake rooro da ufekua wei. Amara dofeku dubuenaro oferi me sifekuro aima rooro ufekua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Enaenari awoenae yabairo rooro ibe me. Nono dubuenaro ya emiauie rooro ufoisaro yanu rooro ukeka moi orouma yabairo da mareke mufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ya emiau I odoroma eka Nabairo moi wake da we nauke efoisaya wei. Nanu ba wake nono wemaro nauawe wei. Nanu Babaebairo Nanu ibiro anemerabu we nauke efoisaie yabake mafiakua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Adinami nauwaro yama Nanu ibiro we nauke ere dakeibisa. Nono awoenae Nanu ibiro we nauke eaweke muaweke rooro daiwere ukeibiawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yabake dubo waure wakeroma weakunea wei. Nono moi odoro yabairo dubo waure wakeroma da wemauke Nanu Babaenu wake yaisina yabairo wemaua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","I odoro Nanu ibiro we nauke efoisaie Godi Dawaini naukakuba yanu wake Dawabairo da yoya uke wemaua eno wei. Yanu imuka yaisina Nabairo oisake Nae Godibairoma fare eno imukaisaba Godi Danu imuka yaisina yabairo ibinuba ibake yanu wake Dawabairo da wemaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nae Godibairoma yewa orofa akakaro fareba ibake nono yewa orofa medimauke nono owemauke Godibairo animaua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuma eno weiro Danu iwoka ukeka orouma ma owekake eno weisa, iduaya awoenae dubo waure wakeroma we dakakuke ba aruro weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ae i wake yaisina iwoka ukakuke iyanu we nauke ereka iwoka ukakuba ibake nono moi wake da we nauke efeisia eno weisa. Enoba ba Godima A we odaiyai eno we imukaisia weisa. ");
INSERT INTO aby_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Eno weisaro Yesuma nono wei, euwa, awoenae Na imukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","I odo idua fafine ukinuba ya yaisina Na medifokoisake yanu uwara uwararo fiake anifoisaro Nanu mane ibimaua eno wei. Nono Nanu mane mero Nanu Babaema Nabairo ibifekua wei. ");
INSERT INTO aby_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nama wene wakeye, yanu imuka yaisina Nabairo odifoke irauaiai mane ibifone ibake wenea wei. Yewa dooro ibaadae oferi waureifoisaya wei. Nono Nama yewa doonu merama ukeka sineka ma berea enare ara uawe Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuma i wake yaisina we me sinike naisa urero eku eraada eno wei, Babae, i odo idua farinua Anu amara we ma daiwere uake Anu arakekawere Nabairo mainaro Anu Amara Nama, A we ma daiwere uma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ama wei ibake yewa orofa akaka yaisina Nama yawokakuniaba Ama Nabairo makara oroue me ibene ibene ibeka emuabairo mamiaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","I me ibene ibene ibekae i ari eno, ainama A, i Ba Godini Na, Yesu Keriso, Anu we odaikara Mini imufeisaie me ibene ibene ibifeisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anu makara waiya yaisina yewa orofaro uke me sinebake A we ma daiwere ukakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Babae, adinami nauwaro eme ibe meke dooini ana omaini ubu uke me, i furo Abairo ibeibisararo Ama Na we ma daiwere ukarake Anu arakekawere makara. Enaenari nono awoena Ama Na we ma daiwere uinake Anu arakekawere maina weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ama moi orofa akaka orou munike Nabairo makara. I oroubairo Anu ukeka sineka yaisina weibisararo naukeibisa. I oroue Anu orou ibake Nabairo makararo Anu weibi wake naukada enaenari ukenewaa ukeibisaya wei. ");
INSERT INTO aby_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ama Nabairo makara eraerabusa yaisina Abairoma farakubai emua iwoka ukaisa weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ama Nabairo yakara wake yaisina emuabairo wero nauisaba Ama Na we odaikararo Abairoma emuabairo isare fare ibai emua imukenewaa ukaisa ibake weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I orou unu koyana. I orofa akaka orou yaisina emua unu kofiane ibake da weakunea wei. Ama Nabairo makara orou emuae Nanu orou. I orou emuae Anu orou ibake emua unu kofiane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nanu orou emuae Anu. Nono Anu orou emuae Nanu. Emenu ukaisa waiyabake emema Na we ma irauaiai ukakuneka weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Awoenae yewa orofa medimauke Abairo amuke aamauro nono yewa orou emuae yewa orofaro ibifeisa. Nanu irau Babae, Anu bunama munike Ama Nabairo makara orou yawokenewaa ufiaro Aini Naini uwa demuiro ibinisu enaenari demuiro ibifisane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ama Nabairo makara orouini demuiro ibaadae Anu bunanu ibiroma emua yawokeibisara. Eno yawokenewaa ukeibisararo moibai fe yare da uisaro i Godinu bukaroma weaku mi, i feare dakaku inaaro anifeku i mi mane fe yaria wei. Iduaroma Godinu bukaroma weaku enaenari ufeku weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Awoenae Abairo famau i wake weakuneba i orouma Nanu rooro ukeka ari rooro ufisane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anu wake emuabairo wero nauisa. Nauisabairo emuaini i orofa akaka orouini emuama imukeka daaba demui imuke meba ibake i orofa akaka orouma Nanu orou emuabake imuka ka uke yarakuneka weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Emua yewado da muyanake nono Ama emua unu kofiaro emua merama merama da ufisane ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nae yewa orofa akaka mi mero nono enaenari emuaini yewa orofa akaka orou me ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anu weaku wakeye ba ibake yewa orou we ma iifa uaro emuama yewa wake naufisake yewa orofa akakanu merama ukeka sineka medifisake emua emenu imusu iifama imusu ari uke irauaiai ibifisane ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ama Na yewa orofa akaka oroubairo we odaikararo isare aare enaenari Nanu orou yewa orofa akaka oroubairo we odaisakuniaya wei. ");
INSERT INTO aby_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nama Nanu imuka yaisina Abairo odakune enaenari Nanu ararae emuama Anu ba wake naufisake emenu imuka yaisina Abairo odifisane ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Babae, yewa orou emua manebake we dakakune. Nono yewa orouma Anu wake wefeisaro moi naufeisa orouini emuabake weakunea wei. I Anu wake naufeisa orou yaisina unu kofiane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Enoba Nanu ararae i orou yaisina demui orou sifisake demui imuka mane imufisane ibake weakunea wei. Ama Nabairo ibinuro nono Nama Abairo ibine enaenari uwabairo ibifisane weakunea wei. Uwabairo ibifisaro nono i orofa akaka orouma ibai efisake ba Ama Na we odaikaraya eno iwoka sifisane weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Anu arakeka Nabairo makara enaenari Nama emuabairo mayaba Aini Naini uwa demuiro ibinisu, enaenari emenu emenu demuiro ibenewaa ufisaro i orofa akakaro Godinu wake nauke me orouma efiakane weakunea wei. Ama Na we odaikarake Anu imuka yaisina Nabairo odi, enaenari emuaini Anu ukakubai iwoka ufisane ibake yewa wake Abairo weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Babae, Nanu ararae Ama Nabairo makara orou emua Nabairo ibifisane weakune. Ama Na adinami nauwaro emeini dooini ana oma ubu uke me, i furo Anu ararae Nabairo uike Nanu arakeka makaraba ibake Nanu ararae emua Nabairo ibaada Nanu arakeka efisane ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Nanu irau Babae, i orofa akakaro Anu wake nauke dakaisa orouma A ma nuna ukaisaro nono Nama A iwoka ukakunero yewa orouma Ama Na we odaikarabai emua iwoka sinaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anu ukeka sineka yaisina emuabairo weibisararo naukeibisa enaenari nono wemauba Anu arara Nabairo ui enaenari emuabairo uaro Na emenu imuka ubarenaro ibimaubai iwoka sifisane ibake weakunea Yesuma guriguri kairoma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuma guriguri ukaada i wake we me siniro Dawaini Danu iwoka ukeka orouini anisa. Aneebe i Kidironi weaisa kafuru isakake ekara enaro ane faka. I orofaroe moi waiya ibi ibake i waiya ubarenaro fare aisa. ");
INSERT INTO aby_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuini Danu iwoka ukeka orou emua adinaro i orofaro aneibisabaie Diudiasi, Yesu we forai mi dawa i orofa iwoka sini. ");
INSERT INTO aby_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","I dai ofereni ode sibore sianeka orouini i Ferosi orouini emuama i ame orouini furisi orouini yaisina Diudiasibairo maisaro Diudiasima emua we waure anirie. I orou yaisina ramefaini esiwaini emenu ure yanake ukeka eraerabusaini waure anisa. ");
INSERT INTO aby_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ane fakaro Yesuma i Dawabairo aneme ufeisa ibai Dawa yaisina iwoka sinike emuabake eno wei, ainadei yodia ukaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eno weibaie Yesu Nasaredi goi Mi yodia ukaisia eno weisa. Eno weisaro Yesuma ma owerike eno wei, Na ewadoya wei. Diudiasie i Yesu we forai mi dawae i faka orouini demuiro enare ibisa. ");
INSERT INTO aby_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuma emua yarieke na ewadoya eno weibaie i orouma ia iyarada yaisina derena enama eka anaada biruisa. ");
INSERT INTO aby_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Eno uisaro Yesuma nono wei, ya ainadei yodia ukaisa wei? Eno weibaie Yesu Nasaredi mi yodia ukaisia nono eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eno weisaro Yesuma wei, Na ewadode anemerabu yodia ukaisa weike nono wei, yewa orou mediawero anifisa wei. ");
INSERT INTO aby_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Adinaroe Yesuma Godibairo eno wei, Ama Nabairo we mune makara orou yaisina Nama moi ma fe yarekabake we bou dauiba ibake yewa orou yaisina mediaro anifisa Danu wake eno wei.) ");
INSERT INTO aby_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yesuma eno weiro, Saimoni Fidama danu ba bau muni. Munike i dai ofereni ode sibore sianeka minu waiya ukeka minu ba ena ome umane kasiniro dooro isari. I waiya ukeka minu ibiye Marokasi. ");
INSERT INTO aby_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Fidama eno uiro Yesuma Fidabake eno wei, anu bau fausiro odiake i ukakubai mediaro emenu arara ufeisa ibaie Nanu Babaema makara waiyaba i ure yanakewere ibake ia da simaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesuma eno weiro i ame orouini emenu Kafudenini i Du orounu furisi orouini emuama Yesu mukake umu wana naama uwakake waure anisa. ");
INSERT INTO aby_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anisake ane i mi danu ibiye Enasi dawabairo ko ane oisa. Enasi dawae Kaiyafasinu naromea. Kaiyafasi dawae i dai ofereni ode sibore sianeka orou emenu dai mi dawama i oyaro i waiya ukeibi. ");
INSERT INTO aby_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Adinaro Kaiyafasima i Du oroubairo eno wei, anemebake iya yaisina feafeisi? Imusu demui mima iya yaisinabake feafekuie iraua Kaiyafasima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","I orouma Yesu waure aneibisabaie Saimoni Fidaini moi Yesunu iwoka ukeka mini emua eroke eroke umuro anisi. Anisike i moi mi dawako i dai ofereni ode sibore sianeka minu uwara udiro fari. Fariro i dai ofereni ode sibore sianeka mima i moi Yesunu iwoka ukeka mi iwokaba ibake i Yesunu moi iwoka ukeka mini Yesu ubarenaro anisaro Fidae aisame udi me nauwaro enare ibi. I moi Yesunu iwoka ukeka mima i aisame yawokeibi arumabairo weiro aisame woromike Fidabake eno wei, amuke aara weiro Fida amuike ubarenaro ani. ");
INSERT INTO aby_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Amuke aniro i aisame yawokeibi arumama Fidabake eno wei, ae i Minu moi iwoka ukeka miba me wei? Eno weibaie Fidama na Dawa iwoka meya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iu ukeibi ibake i waiya ukeka orouma inaa mawaisake ofe iu urieba ibake inaa udiro enare ibisa. Fidaini iu uriba inaa udiro dawaini enare ibisa. ");
INSERT INTO aby_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I dai ofereni ode sibore sianeka mima Yesubake eno wei, Anu iwoka ukeka orou abo orou wei? Ama emua aneme we ma iwoka ukakune wei? ");
INSERT INTO aby_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Eno mane weibi ibake Yesuma nono wei, Nae fema we ma iwoka uke dakeibisaraya eno wei. I orou yaisinabairo we ma iwoka ukeibisarake nono i Du orounu sosi sosiroma emenu dai sosi uwara ubarenaro isareibisarake we ma iwoka ukeibisararo i Du orou emenu imuka yaisina Nabairo odeibisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nono ade anemebake Nabairo eno we nauke erakunara wei? Nanu wake weibisararo naukeibisa oroubairo we nauke efiakuie Nanu weibisara wake emua iwokaba ibake abairo wefeisaro naufakua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuma eno weibaie iedake enare ibi moi furisi mima Yesunu iboo naisaro wana ferama uraada eno wei, anemebake i dai ofereni ode sibore sianeka mibairo eno weaku wei? ");
INSERT INTO aby_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Eno weiro Yesuma dawabake ma owerike eno wei, Na aneme merama wake wene wearo nauma wei. Na merama wake we daunebairo nono anemebake Na unara wei? ");
INSERT INTO aby_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesuma eno weiro Enasima wake moi we dauike Yesu i dai ofereni ode sibore sianeka mi Kaiyafasibairo we odairo wanayai naama uwane karisake waure ane oisa. ");
INSERT INTO aby_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Fidama inaa udiro enare ibaada inaa rarakeibibaie i orouma eno weisa, ae ba Yesu Danu iwoka ukeka moi miba me weisa? Eno weisabaie Fidama eno wei, me, na meya wei. ");
INSERT INTO aby_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","eno weiro I dai ofereni ode sibore sianeka minu moi waiya ukeka mi dawae i ome umane kasini minu goi mi, dawama Fidabake eno wei, ae i waiyaro Dawaini enaisiro eniaba aneme ariya wei? ");
INSERT INTO aby_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eno weiro Fidama meya weibibaie wai uraada kokoroko idua yama wei. ");
INSERT INTO aby_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wai awanakuro i orouma Yesu mukake Kaiyafasinu uwara meisake i Romani gaemani yawokeka minu dai uwararo waure ane oisa. Ane oisake nono i orou i uwara ubarenaro amuke dauisa. Inu ubiye i Du orou emenu guriguri ukeka darawaduma eno weaku, I Du me imusu orounu uwararo amufeisaie yanu ofe ubu ino sifiakua weaku ibake emua i uwararo amuke dauisa. Godima i Isaraera orounu Idifiroma waure anisa banau uruna ise danao ufeisaba ibake i Du orouma i dai uwara ubarenaro amuke dauisa. ");
INSERT INTO aby_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Amuke dauisaba Faeradima aweawero emuabairo isarike eno wei, yewa mi aneme uiro yama wayai wake weforaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eno weiro emuama ma owekake eno weisa, Dawae merama ukeka mi ibake waure farisia eno weisa. Meronae abairo da waure aare odifenea weisa. ");
INSERT INTO aby_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Eno weisaro Faeradima nono wei, yanu mane Dawa mufoke yanu darawaduma kodo uforo wei. Eno weiro emuama nono ma owekake eno weisa, iyae Dawa da ma feafeisia i Romani gaemani orounu darawaduba eme da ma feafeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Yesuma adinaro Danu feafekubai Danu onami we bou uiba ibake Faeradima enaenari ui.) ");
INSERT INTO aby_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Faeradima i gaemani orounu dai uwara ubarenaro amuike weiro enaenari Yesu waure aare oisaro Faeradima Yesubake eno wei, Ae i Du orou emenu dai yawokeka miba me wei? ");
INSERT INTO aby_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Eno weibaie Yesuma ma owerike eno wei, anu mane Nabake we nauke erakunaraba eme moima i wake abairo weisaro aare weaku eno wei? ");
INSERT INTO aby_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yesuma eno weiro Faeradima nono wei, nae Du mi meba eno da wemaua weike nono wei, Anu Du orouini dai ofereni ode sibore sianeka orouma a waure fare odinekaya wei. Ama aneme ukinu wei? ");
INSERT INTO aby_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eno weiro Yesuma ma owerike eno wei, yewa orofa akaka yawoke dakakune. Nae yewa dooro yawokeka Kini orou ari me. Nae yewado yawokeimaronae Nae waiya ukeka orouini emuaini urafisaneba i Du orounu wanaro da mune odifarinea wei. Yesuma eno weike nono wei, Nae yewa orofa akaka yawoke dakakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eno weiro Faeradima wei, Ae dai yawokeka mi wei? Eno weiro Yesuma nono wei, Nae dai yawokeka miba ba weakua wei. Ibake Nanu amaema Na dokararo yewa orofaro fareie ba wake mane wemane farea wei. Ibake i ba wake naukaisa orouma Nanu ba wake naukaisaya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","39","Yesuma eno weiro Faeradima ma owerike eno wei, i ba wakeye aneme wei? Eno weike aweawero isarike i Du oroubairo anike eno wei, Dawabairo merama meya weike nono wei, ya Du orounu bisarae eno, Godima i Isaraera orounu Idifiroma waure aneka banau uruna iseka odo odoro ana ebaro ibaisa orou una deidemu weisaro naa woromeibaisaba yanu ararae i du orounu yawokeka dai mi Dawa naa ma woromimauba me eno wei? ");
INSERT INTO aby_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eno weibaie daiwere we mamisake eno weisa, i mi me, Barabasi ma woromiaro anifi weisa. (I mi Barabasi dawae waira ukeka mi.) ");
INSERT INTO aby_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","3","Faeradima weiro danu ame orouma Yesu mukake usima uka. Ukake sinisini bobo naa didi mukake kini orounu mogoiso ari ubuisake Yesunu iiriro baruke oisake Yesunu wau ma kukune mukake i dai yawokeka orounu barukeka kokoiwere wau mukake ima baruke oisa. Eno uke oisake Yesubairo fakake uke irukada eno weibisa, Du orounu dai yawokeka mi eawe weada wanama Yesu ureibisa. ");
INSERT INTO aby_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eno ukeibisaro Faeradima aweawero isarike i Du oroubairo anike eno wei, awoena Dawa me nauwa yabairo waure aamau. Waure aamauro yama Dawabairo aneme merama ukeka da efoisa eno wei. ");
INSERT INTO aby_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","6","Eno weiro Yesu sinisini bobo kini orounu mogoiso ari naa didima baruke oisake kokoiwere wau baruke oisaro i bobo aweawero isare fari. Isare fariro Faeradima i ku siane ibisa oroubake eno wei, i miye ewadoya eawe weibaie i dai ofereni ode sibore sianeka orouini dai Du orouini emuama eno weisa, korosiro ure odia, korosiro ure odia eno weisa. Eno areare weibisaba ibake Faeradima ma owerike eno wei, nae Dawabairo merama uke me imukakuneba yanu mane Dawa muaweke korosiro ure odiawe eno wei. ");
INSERT INTO aby_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Faeradima eno weiro i Du orouma moko eno weisa, iyabairo darawadu ibinua weisake nono weisa, Dawama Nae Godinu Amaraya eno weiba ie iyanu darawaduba ibake feafekua i orouma eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","9","Eno weisaro i wake Faeradima nauike ia sinaada gaemani orounu dai uwara ubarenaro amuike Yesubake eno wei, A aboroma fari wei? Eno weibaie Yesu we daui. ");
INSERT INTO aby_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","We dauiro Faeradima nono wei, anemebake moko wake nabairo we dakaku wei? Nanu bunae daiwereba a naa ma woromiawe wemauro enaenari ufeisaya eno wei, nono A korosiro ure odiawe wemauie enaenari ufeisabairo nono anemebake na wake weakunero moko we dakaku eno wei? ");
INSERT INTO aby_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eno weiro Yesuma Faeradibake ma owerike eno wei, Godima a buna maiyaiba ibake Na eno uke yafarakua eno wei. Ibake anu merama merama ukekae dai menaku. I imusu Na mune anu wanaro mame odikara mi deima danu merama merama ukekae daiwereya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesuma eno wei ibake Faeradima Yesu medike i oroubairo nono owere anike Yesu ma woromifisaro anifine weibaie i Du orou emua arara me Yesu ma woromekaro aneka ibake eno weisa, yewa mi ma woromifakuro anifekuie ae i dai yawokeka mi Sisanu naiye meya weisake nono weisa, ainama na dai yawokeka miya wefekuie Sisa ma okoanaku ufekua eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Eno weisaro Faeradima i wake nauike weiro enaenari Yesu waure ane i kodo ureka orofaro waure ane oisa. I Du orouma i orofanu ibiye Gabada weaisa. I ibinu ubiye oma kefarawere, semeresi ari enoya weada weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","15","Godima i Isaraera orounu Idifiroma waure aneka banau uruna iseka uke bou ui odo idua fariro eweka amuke aare okoro fariro Faeradima i Du oroubake eno wei, yanu dai yawokeka mi Dawa ewadoya weibaie emuama eno weisa, Dawa ma feaa, Dawa ma feaa, korosiro ure odia eno daiwere weisa. Eno areare weibisabaie Faeradima eno wei, ya Du orou yanu dai yawokeka mi korosiro ure odimane weaisa eno wei? Eno weiro i dai ofereni ode sibore sianeka orouma moko ma owekake eno weisa, iyanu dai yawokeka miye Sisa manea eno weisa. Iyabairo moi yawokeka dai mi ibe meya weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eno weisaro Faeradima Yesu korosiro ikokoma ure dabame odifisane Yesu emuabairo mariero emuama Dawa i Romani meremere oroubairo waure anisa. ");
INSERT INTO aby_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","I orouma Yesu mukake weisaro Dawa Danu korosi wauriro anisa. Aneebe aneebe moi orofaro ane faka. (I oko kainakue eme bokai kai ari ibake i orofanu ibiye bokai kaibai mane orofa weaisa.) Nono i Du orounu wakeroma Gorogada weaisa. ");
INSERT INTO aby_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Enoba i orofaro ane fakake Yesu korosiro ikokoma ure dabame oisa. Ure oisake nono moi waira ukeka mi moi enaro moi korosiro ikokoma ure dabame oisake nono moi waira ukeka mi moi enaro moi korosiro ikokoma ure dabame oisake Yesu ubarero moi korosiro ikokoma ure dabame oisa. ");
INSERT INTO aby_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Eno uisaro Faeradima owaowa yanaike i korosi duboro odi. I owaowa yanai wakenu ubiye eno, Yesu Nasaredi Mi, Dawae Danu orounu Dai yawokeka Mi. ");
INSERT INTO aby_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Faeradima i owaowa i Du orounu wakeroma yanaike nono i Romani orounu Radani wakeroma owaowa yanaike nono i Guriki wakeroma owaowa yanaike eno uke odi. I wake buubaroma owaowa yanake odike Yesunu korosi duboro odi. I orofae Derusaremu goiroma yafa meba ibake i Du orou keuwere i owaowa yanake odibai fare kakureibisa. ");
INSERT INTO aby_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kakureibisa ibake i dai ofereni ode sibore sianeka orouma Faeradibake eno weisa, i Du orounu dai yawokeka miya eno owaowa yanake odinu ie iyanu arara meya mune siaa weisake nono weisa, yewa mi danu imukinuke, Nae i Du orounu dai yawokeka mi wenua eno owaowa yanake odia weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Eno weisabaie Faeradima ma owerike eno wei, adinaro owaowa yanake odineba enaenari ibifekua mediawe eno wei. ");
INSERT INTO aby_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","I ame orouma Yesu korosiro ikokoma ure oisake nono Danu wau mune naka naka uisake duu fo (4) uke ane oisa. Ame orou foma (4) Yesu korosiro ikokoma ure oisa ibake eno uisa. Danu dubo barukekaini mukake nono i dubo barukekae irauaiai wau abanaro yoya uke me. I wau dubo enaroma wowona enaroma irauaiai ubu uiba ibake i ame orouma we makanada eno weisa, yewa wau da ma babafeke kasima ufe weisa, ainama Danu wau mufeku ariya eno weisa. Godinu bukaroma weaku wake enaenari ufeku ibake eno uisa. Godinu bukaroma eno weaku, Nanu wau mune naka naka ufeisake Nanu dubo barukeka waubake kasi ufeisaya, eno weakuba ibake i ame orouma enaenari eno uisa. ");
INSERT INTO aby_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesunu amaeini Kirofasinu aweka Merini Meri Megiderini weaisa awekaini Yesu ure oisa korosi udiro enare ibisa. ");
INSERT INTO aby_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Enare ibisabaie Yesuma Danu amaeini Danu iwoka ukeka ubi mi erieke Danu amaebake eno wei, anu amara iduaya ea wei. ");
INSERT INTO aby_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Eno weike Danu iwoka ukeka ubi mibake nono wei, anu amae iduaya ea wei. Yesuma eno wei ibake Danu iwoka ukeka ubi mima Danu amae we erakurike danu uwararo waure ani. ");
INSERT INTO aby_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eno weibiie Yesu Dawa iwoka Danu feareka odo idua fari ibake eno wei, Na adua isa ukakunaraya wei. Godinu bukaroma weaku wake enaenari ufeku ibake eno wei. ");
INSERT INTO aby_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","30","Yesuma eno weiro moi kimurima imusu ari ana kai idudabai okearo ibiro nifu ubu uisake usiro naama uwakake i kimuriwere adua kouro ma iyakake Yesunu bebekuro oisaro Yesuma i adua ike eno wei, Nanu waiya idua me sininua wei. Eno weike Danu ubiri afua umanike idua feari. ");
INSERT INTO aby_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","I odoe i Du orounu Sabadi odobake uke bou ukeka odo. I Sabadi odoe iifawere odo ibake Godima i Isaraera orounu Idifiroma waure anisa banau uruna iseka odoe i odoro ibake i Du orou emua arara me i eme una buuba korosiro ibeka ibake Faeradibairo eno weisa, i eme una buuba emenu umu ure furufuru yayakaweke waure ane odiakawe eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eno weisa ibake ame orouma anisake eka ena ewa enaro miyainu umuyai ure furufuru yarieka. ");
INSERT INTO aby_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ure furufuru yariekake aare Yesubairo fakake ekabaie Yesu feariba ibake Danu umuyai ure fururu yare dauisa. ");
INSERT INTO aby_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ure fururu yare da uisaro moi ame mima wari munike Yesunu manamaro yanairo aduaini iwaini fare isari. ");
INSERT INTO aby_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nae i yaisina ereba ibake yewa owaowa yanake odakune. Nanu wakeye ba ibake owaowa yanake odakuneba ya efoke yanu Babae imukenewaa ufone ibake weakune. ");
INSERT INTO aby_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Godinu bukaroma weaku wake enaenari ufekuba ibake ibai yaisina enaenari ui. Godinu bukaroma eno weaku, Danu moi kainaku da ure fururu yafeisa eno weakuke nono moi wake eno weaku, emuama manamaro yanafeisa mi nono uyafekuro Danu bou bedako nono efeisaya eno weaku. ");
INSERT INTO aby_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Diosefu, dawae Arimadia goi mi. Dawama i dai Du oroubake ia iyarike adinaro fema Yesunu wake naukeibi. Ibake dubuenaro Diosefu dawama Faeradibairo anike Yesunu ofe mufine weibaie Faeradima iraua wei. Iraua mune ane ooru ua weiba Diosefuma Yesunu ofe korosiroma munike ani. ");
INSERT INTO aby_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nono moi mi danu ibiye Nikodimasi dawae adinaro Yesubairo dumuro fari, i mima ooru ukeka ena urumuma imusu ari fauda danu ibiye muraini aroaini, ie daiwere, danu inimue fifidi (50) kiro ari waure fari. ");
INSERT INTO aby_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Waure fariro Diosefuini Nikodimasini emuama Yesunu ofe mukike irauaiai inanakeo wau mukike i fauda i wauro ure oisike i bobo Yesunu ofe bouro wayaki. I Du orounu bisarae eno ibake eno uisi. ");
INSERT INTO aby_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu korosiro ikokoma ure oisa orofaroe moi oriwa ana kaimawere ibi. I orofa ubarenaroe eme ooru ukeka oma erabo ibiro nono i oma eraboroe eme moi iro ode dakeibirieka. ");
INSERT INTO aby_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","I Du orounu sabadi odo sabu fanao ufekuba i ooru ukeka orofae yafa me ubiubinaku ibake i miyaima Yesu mukike iro ane ooru uke oisi. ");
INSERT INTO aby_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","I sabadi odo me siniro wai awa dumu obaro Meri Megiderinima i Yesu ooru uke oisa oma eraboro ane fari. Ane farike eribaie aisame dadau uke oisa oma fera mune siakaro aine ibiro eri. ");
INSERT INTO aby_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eno uke ibiro erike owerike Fidaini Yesu Danu moi iwoka ukeka mini emuabairo durame ane fari. Durame emuabairo ane farike eno wei, iyanu Dai Waria Mi ooru uke oisa oma eraboroma munisake aboro ane oisa ariya na iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Eno weiro nauisike Fidaini Yesunu moi iwoka ukeka ubi mini emua i Yesu ooru uke oisa oma eraboro durame anisi. ");
INSERT INTO aby_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Durame aneebe Yesunu moi iwoka ukeka mima Fida ma bereike i Yesu ooru uke oisa oma eraboro dawako ane fari. ");
INSERT INTO aby_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dawako ane farike eu afua umanike oma erabo ubarenaro eribaie i Yesunu ofero oba uisa ena inanakeo wau mane aine ibiro erike ubarenaro isare daui. ");
INSERT INTO aby_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Ubarenaro isare dauike udiro enare ibiro Fidama danu umuro faraadae i oma erabo ubarenaro isari. Isarike i aine ibi ena inanakeo wau erike nono Yesunu bokairo oba uisa wau worome me i moi wau duboro ibe me, i wau mane Yesunu bokairo oba uisa enaenari aine ibiro eri. ");
INSERT INTO aby_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ereibiro moi dawako fari ena iwoka ukeka mima ubarenaro isarike eraada eno we imui, Yesu fearekaroma uyarinua eno we imui. ");
INSERT INTO aby_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Adinaroe Godinu bukaro Yesu feafekuke nono uyafekua wei wake imuke dauisike Yesu iro me ekikema i wakeye ba eno we imuisi.) ");
INSERT INTO aby_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","I iwoka ukeka miyaima nono owekike emenu goiro anisi. ");
INSERT INTO aby_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","I Yesunu iwoka ukeka miyai emua anisiro Merima i oma eraboro nono owere ane fari. Owere ane farike i oma erabo aisame udinakuro farike enare ibaada ii weibi. Ii weebe ubiri afua umanike i ooru ubarenaro eu eribaie inanakeo wau ruki miyai moi mi dawae Yesu oisa bokai enaro yaure ibiro nono moi mi dawae Danu umu enaro yaure ibiro erie. ");
INSERT INTO aby_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eriero i aneruyaima eno weisi, yewa aweka, anemebake ii weaku eno weisi? Eno weisiro Meri Megiderinima ma owerike eno wei, Nanu Dai Waria Mi yewadoma munisake aboro waure ane oisa ari? Na iwoka me ibake ii weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eno weike owerike eribaie Yesu idua enare ibiro erike dawama Yesu ma nuna ui. ");
INSERT INTO aby_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma nuna uiro Yesuma anemebake ii weada ainadei yodia uke enaku wei? Eno weiro Merima Dawabake waiya yawokaku miya eno we imuike ibake wei, ama Dawa yewadoma waurinuke moiro ane odinuie i orofa we siboaro animake Danu ofe mumake waure anima eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Eno weiro Yesuma nono wei, Meri, eno weibaie Merima owerike yewae Yesua we imuike i Du orounu wakeroma eno wei, Rabonai wei. (I wakenu ubiye Sisa mi.) ");
INSERT INTO aby_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuma Meribake eno wei, Nanu Babaebairo amuke ane meya Na da ure burinake owere aniake Nanu iwoka ukeka oroubairo eno wea wei, Nae i Babae Godibairo amuke anakune. Naini yaini iyanu Babae Godi, Naini yaini iyanu Godibairo amuke anakunea aniake eno ane wea wei. ");
INSERT INTO aby_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yesuma eno wei ibake Meri nono owerike ani. I Yesunu iwoka ukeka oroubairo ane farike eno wei, iyanu Dai Waria Mi enea eno weike Yesunu wei wake yaisina emuabairo enaenari yarie. ");
INSERT INTO aby_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","I odoe Sanide odo dumudumunaku siniro i Yesunu iwoka ukeka orouma uwara ubarenaro yaure ibisa. I oroue Du oroubake ia iyakake uwara ko ure oisake ubarenaro yaure ibisa. Ko ure oisake ubarenaro yaure ibisaro Yesuma emuabairo me ari uke farike eno wei, ia da siaweke me irauaiai ibiawe wei. ");
INSERT INTO aby_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eno weike Danu ikokoma uka ena wanaro ebaini warima manamaro yanaisa eba emua ma yariwoka urie. I iwoka ukeka orouma emenu Dai Waria Mi ekake imuka irauaiai uisake rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eno uisaro Yesuma emuabake nono wei, me irauaiai ibiawe wei. Nanu Babaema Na we odaikara enaenari ya we odaisakuniaya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eno weike emuabairo imu sianada eno wei, Godinu Imumu Irau muawe wei. ");
INSERT INTO aby_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eno weike nono wei, i ari eno emebairo wefoisaie yanu merama merama ukeka muninuke imuke medinu wefoisaie enaenari ufekua wei. Nono moi oroubairo yanu merama merama ukeka mune dakinu wefoisaie enaenari emuabairo emenu merama merama ukeka ibifekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesuma farike eno ukeibibaie Domasi afafa doka mi dawa emuaini demuiro ibe daui. ");
INSERT INTO aby_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Domasima emuabairo nono fariro danu naiyemukuma eno weisa, iyae iyanu Dai Waria Mi farinuro erisia eno weisa. Eno weisaro Domasima ma owerike eno wei, nanu mane Danu ikokoma uka eba emauke nanu wana raragama Danu ikokoma uka ebaro da siamauke nono nanu wanama Danu manamaro yanaisa ebaro da mame emauie da imumaua eno weike nono wei, nanu wanama Danu bouro ure burimauke nanu naisama emauie baya imumaua eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Odo eida (8) me siniro Danu iwoka ukeka orouini Domasini uwara ubarenaro ko ure oisake demuiro yaure ibisa. Ko ure oisake yaure ibisabairoma Yesuma emuabairo nono me ari uke farike enare ibaada eno wei, ia da siaweke irauaiai ibiawe wei. ");
INSERT INTO aby_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eno weike Domasibake eno wei, Nanu ikokoma uyaka wanaro eba eake anu wana raragama Nanu wana ebaro siane eake Nanu manamaro yanayaka ebaro anu wana raragama siane ea wei. Anemebake Na imuke dakakunara wei? Eno da uake imukenewaa ua wei. ");
INSERT INTO aby_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yesuma eno weiro Domasima ma owerike eno wei, Ae nanu Dai ibi Waria Miya wei. Ae nanu Godi ubiya eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Eno weiro Yesuma Domasibake nono wei, ae Na enarakema ai imukakunara wea weike nono wei, aina ainama Na da efokaisakema nono emenu imuka yaisina Nabairo odifeisaie emenu rooro ukekae daiwereya Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuma buna ukeka keuwere ukeibiro Danu iwoka ukeka orou iyama ereibisi. I ukeibi sineibi ibai yaisina enaenari yewa bukaro owaowa yanake ode daue. ");
INSERT INTO aby_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","I owaowa odeie Yesunu buna ukeka efoke Dawae Godima we mune odi miya eno wefoke Dawae Godinu Amaraya eno imufoke me ibene ibene ibifone weakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesuma Danu onami Gareri kuna udiro nono fare iboo ma iwoka uriero Danu iwoka ukeka orouma Dawa eka. Ie eno ui. ");
INSERT INTO aby_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Fidaini afafa doka mi Domasini Nadaneroe Gareri orofa Keina goi mini Debedinu amarayaini Yesunu moi iwoka ukeka miyaini emuama yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yaure ibeebe Saimoni Fidama uyarike eno wei, nae Gareri kunaro iwame siamane anakunea wei, eno weiro emuama iyaini anifeisia eno weisa. Eno weisake anisake boudiro amuisake bara ure anisa. Anisake eneibisa dumu yafa adua abu moinaku mune dauisake boudiro me yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wai awanakuro Yesuma gibudiro enare ibiro Danu iwoka ukeka orouma Dawa ekakema ma nuna uisa. ");
INSERT INTO aby_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ma nuna uisaro Yesuma eno wei, adara, adua abu munisaba me wei? Eno weibaie emuama meya eno weisa. ");
INSERT INTO aby_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eno weisaro Yesuma eno wei, yanu iwame ba ena wana enaro siaweke adua abu youawe wei. Eno weiro Danu wei enaenari uisake adua abu keuwere iwame wake fariba ibake udiro waure amuke dauisa. ");
INSERT INTO aby_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesunu iwoka ukeka ubi mima eno wei, Dawae iyanu Dai Waria Miya wei. Eno weiro Saimoni Fidama nauike sedi mebake Danu dubo barukeka wauma mune baruike kunaro bibi urike rarane ane udiro amui. ");
INSERT INTO aby_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dawa eno uiro moi iwoka ukeka orouma boudiro anisa. Anaada ena adua abuma wake fari ena iwame ma youre ane udiro faka. Adua kouroma udiro yafa me funaku wani aderedi midasi (100) mane. ");
INSERT INTO aby_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Udiro ane fakake ekabaie Yesuma inaa mawaike buredi inaa udiro odike adua abu inaaro aisa ukeibiro eka. ");
INSERT INTO aby_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuma eno wei, yanu munisa adua abu moi waure aarawe wei. ");
INSERT INTO aby_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eno weiro ibake Saimoni Fidama boudiro amuike ena adua abu ibi ena iwame ma youre udiro odi. Udiro odike iwame ubarenaro eribaie adua abu wani aderedi fifidi diri (153) keuwerebairoma iwame babare daui. ");
INSERT INTO aby_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuma emuabake eno wei, aaraweke uruna iawe wei. Eno wei ibake Danu iwoka ukeka orouma ade ainadeiro we ere dauisake Dawae iyanu Dai Waria miya eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuma buredini adua abuini munike emua ane marie. ");
INSERT INTO aby_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuma fearike nono uyarike Danu iwoka ukeka oroubairo odo raarayai Danu iboo baua uiro eka. Ekaro nono yewa odo Danu iboo nono baua uiro Dawaini demuiro eneiyakake faka. ");
INSERT INTO aby_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uruna ise me sikaro Yesuma Saimoni Fidabake eno wei, Dioninu amara Saimoni, yewa orounu imukari ukaisari mero ae Nabake imukari daiwere ukakunaraba me wei? Eno weiro Fidama ma owerike eno wei, euwa Dai Waria Mi, A iwokaya Abake imukari ukakunebai wei. Fidama eno weiro Yesuma nono wei, Mamoe abu yawokaku mima mamoe abunanakubake uruna makaku enaenari Nanu mamoe abunanaku ari Nanu wake nauke imuke ukaisa oroubairo Nanu wake wea wei. ");
INSERT INTO aby_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuma eno weike Fidabake nono wei, Dioninu amara Saimoni ae Nabake imukari ukakunaraba me wei? Eno weiro Fidama Dawabake nono wei, euwa, Dai Waria Mi, nama Abake imukari ukakunebai A iwoka sinakua eno wei. Eno weiro Yesuma nono wei, mamoe abu yawokaku mima mamoe abunanaku yawokakune enaenari Nanu wake nauke imuke ukaisa orou yawokenewaa uyana wei. ");
INSERT INTO aby_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuma Saimoni Fidabake nono deibuuba we nauke erike eno wei, Dioninu amara Saimoni, ae Nabake imukari ukakunaraba me wei? Eno deibuuba we nauke eriba ibake Fidama imuka merama ukaada eno wei, Dai Waria Mi, Ae i yaisina iwoka sinakua weike nono wei, nae Abake imukari daiwere ukakunea wei. Eno weiro Yesuma Fidabake ma owerike eno wei, mamoe abu yawokaku mima mamoe abu uruna makakune enaenari Nanu wake nauke imuke ukaisa oroubairo Nanu wake wea wei. ");
INSERT INTO aby_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yesuma Fidabake eno weike nono wei, Nanu ba wake wemaro naua wei. A adinaroe awoena mi sinike anu wau baruike anu arara aboro aboro anifane ukaadae enaenari iro ania wei. Nono dubuenaro a bauwaka ufakuke anu wana siafakuro moi mima anu wau baruke odimekuke anu wanaro maimekuke anu aneka arara daaba idua ibifekuro moi daabaro waure animekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesuma Fidanu feareka daaba eno uke ma boroo yafiro Fidama Godinu ibi we ma daiwere ufine ibake eno wei.) Yesuma eno weike nono wei, Nanu umuro aarake Na da mediina eno wei. ");
INSERT INTO aby_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yesuma eno weiro Fidama ma owerike eribaie Yesunu iwoka ukeka ubi mi, i miye adinaro uruna demuiro iseibisa furo Yesunu udiro yaure ibaada eno wei, Dai Waria Mi A ainama we foramekuro mumekaisa wei? ");
INSERT INTO aby_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I weibi mima emua aneibisi umuro ane fariro Fidama erike eno wei, yeka mide aneme ufeisaro feafeku wei? ");
INSERT INTO aby_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Eno weiro Yesuma Fidabake ma owerike eno wei, Nanu arara dawa da feafike me ibifiro Na owere famane wemauie enaenari ufekua, ibake da imuake anu mane Nanu umuro aarake Na da mediina wei. ");
INSERT INTO aby_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesuma eno weiro nauisake Yesunu wake naukeibisa oroubairo eno we eneiareibisa, Yesunu iwoka ukeka ubi mi dawa da feafekuke me ibifekua eno we eneiareibisa. Nono Yesu Dawa eno we daui. Yesuma weiie eno wei, Nanu arara dawa da feafike me ibifiro Na owere famane wemauie enaenari ufekua ibake da imua weike wei, ie anu imukeka meya Nanu imukekaya, eno me weada weibi. ");
INSERT INTO aby_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","I iwoka ukeka miye na Dioni nama ibai yaisina ereba nanu wakeye ba ibake yewa owaowa yanake odakunea wei. ");
INSERT INTO aby_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuma ukeka sineka keuwere ukeibiroma nono i ukeibi sineibibai yaisinawere owaowa yanake odekabai sine dauiba i ukeibi sineibibai yaisinawere bukaro owaowa yanake ode dauea Dionima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nanu naiye Diafarasi, abairo Yesuma we ma iwoka ukekaini Yesu Danu ukeibike Danu we mune odirie afasoro oroubake Godinu Imumu Iraunu bunaro riba wake weibiro Godima Dawa we muniro urero amuke ani. Danu ukeibi ibai yaisina owaowa ueke abake make odaie. ");
INSERT INTO aby_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","4","Yesuma fearike nono uyarike Danu onaminu iboo naisa Danu orou emuabairo baua uiro eka. Emuama Dawa eka ibake Dawa fearikema nono uyare ibinua weisa. Dawa Danu we mune odirie oroubairo manabe kai demui odo deni (10) i odo yaisina fodi (40), emuaini demuiro ibaada Godinu yawokaku orofabake emuabairo weada eno wei, Derusaremu goiro ibeibiaweke imusu da aniawe wei. Eno weike emuabake nono wei, ewaro yawoawe weike Godinu we bou ui wake adinaro wero nauisa enaenari ufekua wei. ");
INSERT INTO aby_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dioni adinaro aduama babadaido ukeibi i ari enoe dubuena kai odo yafa me, me sifekuie ya yaisinabairo Godinu Imumu Irauma yabairo isare aafekuie Godi Danu Imumu Irauma ya yaisina babadaido ufekua Yesuma eno wei. ");
INSERT INTO aby_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","I ku siane ibisa orouma Yesubairo we nauke eraada eno weisa, Dai Waria Mi, awoena iya Isaraera orou iyanu imusu buna mamisiro nono iyanu imusu yawofeisiba me eno we nauke eka. ");
INSERT INTO aby_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","8","Eno we nauke ekaro Dawama eno wei, Godi Danu mane ewekaini dumuini i wai yaisina odiba i buna mafiaku odo ya dawa iwoka meroma nono Godinu Imumu Irauma yabairo isafekuba buna ufoisake Nanu fo weeka orou sifoisake Derusaremu goini Diudiaini Samariaini nono i orofa akaka yaisinabairo Nanu wake we eneiareifoisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eno weiro nauisake ereibisabaie Yesu urero amuke ani. Amuke aniro ouma Yesu dadau uiro Dawa ere dauisa. ");
INSERT INTO aby_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Yesuma amuke aneibiro i orou enare ibaada ereibisabaie inanakeo wau ruki miyai me ari uke baua ukike i orou emenu ibooro enare ibaada eno weisi, ya Gareri orou, anemebake enare ibaada urero eraisa weisike weisi, mediawe, Yesu yeka amuke anakuro eraisa enaenari nono dubuenaro owefekuke ureroma fafekuro efoisaya aneru una raarama eno weisi. ");
INSERT INTO aby_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","14","I Derusaremu goiye Oriwa oraara udiro nono i daabae yafa me, funaku. Nono i Oriwa oraararoma Derusaremu goiro aare fakake emenu uwara ubarenaro amuisa. Amuisake Fidaini Dionini Deimisini Enuduruini Firifuini Domasini Badoromiaini Madiuini Arofiesinu amara Deimisini Keinani orofa mi Saimonini Deimisinu amara Diudiasini moi awekaboini Yesunu amae Merini Danu naburakaini guriguri ukaada ibisa. ");
INSERT INTO aby_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","I odoro Fidama uyarike i Godinu wake naukada ku siane ibisa eme keuwere wani aderedi duenidi (120) eme emuabake eno wei, adara, Godinu bukaroma Diudiasima Yesu aya mafine wei wake enaenari ui. I Godinu Imumu Irauma Diudiasinu orofa muneka wake Deiwidinu imukaro mairo Deiwidima eno wei. I ari i mima Yesu aya maike i orou Yesu mufisane waure fariero i orouma Yesu muka. ");
INSERT INTO aby_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","19","Enoba dawaini iyaini demuiro ibaada Yesunu waiya ukaada i Diudiasi danu aya makeka oima make doo munike iro anike danu imusu ubiri yanai. Ubiri yanaike boana dorobu yariro desini dura feko fariro Derusaremu goi orou yaisina i wake nauisake iwoka sika ibake i doo danu ibi Ekedama weisa. I wakenu ubiye iwa dooro isaria weisa. ");
INSERT INTO aby_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Fidama eno weike nono wei, Godinu Samusi bukaro Diudiasibake i wake eno ibinu, Danu uwara moi mima da mufekuro me ibifekuke merama sifeku weia eno ibinu. Nono Godinu Samusi bukaro yewa wake eno ibinu, moi mima danu waiya ukeka ooru mufeku eno ibinua wei. ");
INSERT INTO aby_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yewa wakeye Samusi bukaro ibinua weike nono wei, enoba Dionima Yesu babadaido ui i furoma ane fare ukeebe urero amuke aneibi odoro ereibi mi we mufeisiro fafekuke Yesunu fearike uyarada ui wake fo weeka mi sifekua eno wei. ");
INSERT INTO aby_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","25","Fidama eno wei ibake eme una raarayai emenu ibi fefa kakayairo owaowa yanake mauwa ubarenaro oisa. Moi minu ibiye Diosefu danu moi ibiye Basabasi, nono danu moi ibiye Diasidasi i owaowa mukake mauwa ubarenaro oisake nono moi mi danu ibiye Madayasi danu fefa kakaro owaowa yanake mauaro oisake guriguri uisake eno weisa, O Dai Waria Mi, Ae eme yaisinanu imukeka yaisina iwoka ukaku ibake abo mima Diudiasinu medi orofa mufeku weisa? ");
INSERT INTO aby_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eno weisake ere dauisake moi ibi mukake ekabaie Madayasinu ibi muka. Eno uisa ibake Madayasima moi afasoro duweronu (12) orofa munike moi afasoro mi sini. ");
INSERT INTO aby_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yesu fearike nono uyarike urero amuke aniro odo fifidi (50) me siniro i Fenidikosi weaisa odo idua fari. Fariro i orou demui uwara ubarenaro yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","3","Yaure ibisaro ureroma oyau bibinu yama ari sabu isare aarike i uwara wake farike inaa giginamu ari ui. Eno uike emenu ofero yaure fare anisa. ");
INSERT INTO aby_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eno uiro Godinu Imumu Irauma isare aarike i orou yaisina emenu imuka ubarenaro isare wake faraada iwoka daiwere mariero wake imusu imusu weisa. ");
INSERT INTO aby_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","6","I odoro Derusaremu goiro Godinu wake naukebisa Du orou keuwere yaure ibisa. Moi orofa akakaroma fakake yaure ibeebe i oyau bibinu yama ari nauisake i uwararo anisake emenu imusu imusu wakeroma weibisaro nauke karana uisake imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eno uisake we imukada eno weisa, i wake imusu imusu weisa oroue Gareri oroua eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eno imuisake weisa, aneaneme iyanu ba wake weaisaro naukaisi weisa? ");
INSERT INTO aby_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","I oroue orofa akaka imusu imusuroma Derusaremu goiro faka. I oroorofanu ibi ibiye ewado ibinisa Fadiaini Midini Iramaidini Mesofadeimaini Dudiaini Kafadosiaini Fonidusini Eisiaini Furigiaini Famufiriaini Idifini Ribia Sairinabaini Romanini iroma i ba Du orouini moiroma aare ibaada guriguri ukeibisa Du orouini Kuridini Areibia orofa orouini Derusaremu goiro fakake naukada Godinu buna ukeka iyanu ba wakeroma weaisaro naukaisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eno weisake imuka foria uisake we imukada moi orouma eno weisa, yewa anemedei ubu weisa? ");
INSERT INTO aby_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eno weisaro moi orouma moibai we irukake eno weisa, emua awoena waini adua isisake ibake eno gogore wake weaisaya eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","I orouma eno weisa ibake Fidaini i Yesunu iwoka ukeka orou ireweni (11) uyakake Fidama daiwereroma eno wei, nanu Du orouini Derusaremu goiro yaure ibinisa eme yaisina nanu wake naukenewaa uawe wei. ");
INSERT INTO aby_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Eno weike nono wei, Yewa orou awoena waini iseroma gogore ukeroma wake imusu imusu we meya wei. Eno weike wei, eweira yewa wai urinuke eweka amuke aare abanaro farinuro iya awoena waini ise meya wei. ");
INSERT INTO aby_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","I Godinu adinaro we bou ukeka mi Doerama eno wei, Godima eno weakua wei, dubuenaro Nanu Imumu Irau we odaimauro eme yaisinabairo isafeku ibake yanu aruarumaini yanu adarabaini emuama wake we bou ufeisaya wei. Eno ufeisaro yanu awoena amarananakuma kubekube efeisaro nono yanu akaemukuma kubekube ma ubifeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kubekube efeisaro Nanu Imumu Irau we odaimauro Nanu waiya ukeka orou yaisinabairo isafeku wei. Isafekuro emuama Godinu wake we bou ufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Eno ufeisaro urero buna ukeka umauke dooro buna ukeka umauke iwaini inaaini inaa iroini eno umauro eweka edoro mero dumu mane sifekua wei. Eno ufekuke manabe edoro iwa gi sifekuro nono i Dai Waria Minu fareka dai odo edorowere idua fafekua wei. ");
INSERT INTO aby_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aina ainama i Dai Waria Mibake iya ma wiroa wefeisaie ma wirofiakua, Godima eno weakua Doerama wei. ");
INSERT INTO aby_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","23","Fidama i oroubake eno weike nono wei, ya Isaraera orou nanu wake nauawe wei. Eno weike wei, Yesu Nasaredi goi Mibake weakunea wei. I Mi Godima we mune odairo ya yaisina Danu kawama ukekaini Danu buna ukekaini Danu eme ma wirokeka bunaini yaisina ya ereibisaya eno wei. Godima Yesubairo buna makeibiro yabake i ukeka yaisina Yesuma ukeibibai ya eraada iwoka sikaya weike nono wei, Godima i buna makeibiro ibake eno ukeibia wei. Godima Yesu korosiro ikokoma ure odifisane ibake weike Dawa yabairo mariero yama Danu ukeibi sineibi ibaibake ararua ukaada wake goro weada Dawa korosiro ure odiawe eno areare weibisa ibake imusu merama orouma Yesu korosiro ikokoma ure dabame oisaro fearia eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Feariro Godima Dawa ma uyarike fearekanu buna mune imusu odiba i fearekama Dawa yabakibe daui ibake nono uyaria wei. ");
INSERT INTO aby_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","26","Deiwidima Yesunu wake eno we bou ukaada eno wei, Nama ereibakunero Godi nabairo ibene ibene ibeibakuke Nanu baena wana enaro ibeibaku ibake imuka ubarenaro ia da iyamauke nanu imukama rooro ueke nanu bebekuma rooro ukeka wake weimauke yewa dooro irauaiai ibeimauke i fearekabake ia da simaua, Deiwidima Yesunu wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eno weike nono wei, Nanu imumu eme odeka ooru orofaro da medifekuro Anu iifa Amaranu ofe da yaufeku ibake yewa orofaro ibeimauie ia da simaua wei. ");
INSERT INTO aby_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ama i me ibene ibene ibeka munekanu daaba Nabairo ma boroo yarike ama Nabairo ibeibaku ibake rooro umaua, Deiwidima adinaro Yesunu wake eno weiro Fidama i wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Fidama eno weike nono wei, nanu naiyemuku, i wakenu ubi ma boroo yamane weakunea wei. Iyanu adinaro dai mi, Deiwidi, feariro ooru uisaro danu ooru yewa dooro ibinua wei. ");
INSERT INTO aby_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deiwidiye Godinu we bou ukeka mi. Godima wake daiwereroma we bou ukaada Deiwidibake weiro Deiwidi dawa i wake nauike eno we imui, Godima Deiwidi danu moi sisia sirorari mi mufekuke dai yawokeka minu orofaro odifekuro yaufekua eno we imui. ");
INSERT INTO aby_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawa ibai iwoka uike i Kerisonu uyareka odo imui ibake weike eno wei, Danu Imumu feareka orofaro mede dauiro Danu ofe yaure dauia, Deiwidima eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Fidama eno weike nono wei, Yesu feariro nono Godima Dawa ma uyariro iya yaisina Dawa eki. ");
INSERT INTO aby_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Godi Danu bunama Yesu Danu ba ena wanaro odike Yesu ma dai ukaada eno wei, Imumu Irau abake mamauanea wei. Enaenari mairo muni ibake bunawere erekaini ukekaini yaisina Dawabairoma aarakuro ibai awoena eraisia eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Fidama eno weike nono wei, Deiwidima urero ane me i furo ibaada Yesubake wake eno wei, I Godima Nanu Dai Waria Mibake eno wei, Nanu ba ena wana enaro yauaro Aini wasai ukaisa orou buna umake mumiake Anu umu wowonaro odimia Godima weia, Deiwidima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Fidama eno weike nono wei, Isaraera orou, yewa yama korosiro ikokoma ure dabame oisa Mi, Godima Dawa i Dai Waria Mike i Keriso we mune odiba ibake imufone weakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eno weiro nauisake emenu imukaro imukenewaa uisake eno weisa, aneaneme ufeisi weisa? ");
INSERT INTO aby_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Eno weisaro Fidama wei, yanu sara merama ukekaini imukeka imuke mediaweke Yesu Kerisonu ibiro babadaido uawero Yesu Kerisoma yanu merama merama ukeka yaisina mufike imuke medifike Godinu Imumu Irau we odaifekuro yabairo isare aafekuro mufoisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Fidama eno weike nono wei, i we bou ukeka yaini yanu amarananakuini imusu orouini yanu Dai Waria Godima ya yaisinabake u wefeku ibake eno we bou uia Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eno areare weebe we iifa ukaada eno wei, yanu Du orounu merama ukeka mediaweke ma wiroawero Godima ya fanisi da mafia wei. ");
INSERT INTO aby_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fida danu wake nauisa i orou keuwere diri dausini (3000) babadaido uisake Godinu wake naukeka oroubairo ane dakaa uisa. ");
INSERT INTO aby_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eno uisake aine wai ure ku ukeibisake i afasoro orounu wake naukeibisake emenu awaawa demuiro ukeibisake uruna demuiro ma birabira yare isaada eno we imukeibisa, Godima Yesu iyabake we odairo isare aarike dooro fari ibake rooro ukaisia eno we imukeibisake guriguri ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Godima Danu afasoro orou buna mariero buna ukeibisaro moi orou ibai ereibisake i orou yaisina ia iyareibisa. ");
INSERT INTO aby_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Godi imukeibisa orou daaba demui orou yaisina ma demuiro uisake i naukeka orou yaisina demuiro sikake emenu eraerabusa yaisina make oi mukake eraerabusa me oroubairo marieka. ");
INSERT INTO aby_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Eno uisake emenu imukeka demui ibake dai sosi uwara ubarenaro amukeibisake guriguri ukeibisake uwara imusu imusuro uruna naka naka uke ma birabira yare iseibisake eme yaisinabairo irauaiai mane ukeibisaro i orou yaisina emenu wake eno weisa, i afasoro oroue irauaiaiya weisa. Godima i moi orou ma wirokada i afasoro oroubairo odeibiriero emuaini demuiro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Moi odoro dumudumu guriguri eweka muniro Fidaini Dionini emuama dai sosi uwararo anisi. ");
INSERT INTO aby_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Aneebe moi mi danu amaema dawa dori arima danu umu daba mamiro moi orouma waure aneibisake dai sosi i irauaiai aisame udiro odeibisaro yaure ibaada eme fare dai sosi uwara ubarenaro iyareianeibisaro oi eenu weibi. ");
INSERT INTO aby_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","4","Eno weibiro Fidaini Dionini emuama dai sosi uwararo aneebe ekibaie i mi idua yaure ibaada eenu weibi ibake Fidama eno wei, Dionini uwa ea wei. ");
INSERT INTO aby_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","6","Fidama eno weiro i mi oi mafisine weaisia imuike wana sianada erenewaa uiro Fidama wei, na oi meba da mamauanea wei. Eno weike nono wei, anemerabu nabairo ibinu ima a mamauanea wei. Fidama eno weike i minu wanaro mamike ma uyarada eno wei, Yesu Keriso Nasaredi goi Minu ibiroma weakunea uyake ania wei. ");
INSERT INTO aby_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Eno weiro i minu umu fafaini umuaini eno gienabu sinike uyare enariro Fidaini Dionini demuiro ane dai sosi uwara ubarenaro amuisake i mima bibi uraada Godibairo we ma irauaiai ui. ");
INSERT INTO aby_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Eno ukeibiro i yaure ibisa orouma ekake i mi aisame udiro yaure ibaada oi eenu weaku miya weisake iwoka ukaada danu umu irau sini ibaibake imuka foria daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I mima Fidaini Dioninu wanaro mamiro i dai sosiwere moi ena barunae Soromoninu sebo ibi i ena barunaro anisaro i orou yaisina sabu emuabairo durame ane faka. ");
INSERT INTO aby_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ane fakaro Fidama eno wei, ya Isaraera orou anemebake imuka foria ukaada naisama erenewaa ukaisa wei? Eno weike nono wei, i minu umu uwanu bunaini irauaiai ukekaini ima ma giena ukisu eno we imukaisa wei? ");
INSERT INTO aby_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Eno weike nono wei, Eibaramuini Aisikini Deikafuini emenu Godi, iyanu babaemukunu Godima Danu waiya ukeka Mi Yesu we ma daiwere ukaku ibake ma giena ukinua wei. I irau iifa Mi Faeradibairo waure ane oisake wayai weisaro Faeradima me we odaifine ui. ");
INSERT INTO aby_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","15","Eno uiro ya arara me Dawa me we odaiseka. Ibake moi ma feareka mi me we odaifine eenu weisake nono i me irauaiai ibaada eme ma wirokeka Mi ma feakaro Godima Dawa nono ma uyariro iya yaisina eki. ");
INSERT INTO aby_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eno weike nono wei, Yesunu iifa ibima yewa minu umu ma giena ukinua eno weike wei, i Danu ibiro imukisu ibake yewa mi irauaiai ukinuro i yewa mi eraada iwoka sinaisaya weike ba weakunea wei. Yesu Keriso imukisu ibake yewa mi irauaiai wirokinuro i buna eraisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","18","Eno weike Fidama nono wei, na iwoka sinakunea wei. Yaini yanu dai orouini adinaro yanu ukeibisa ibai ya iwoka me ibake eno uisaro Godima Yesunu oferi waufeku ibai Danu we bou ukeibirie oroubairo wei enaenari uia wei. ");
INSERT INTO aby_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Eno ui ibake yanu sara merama ukekaini merama imuka imukekaini imuke medifoisake Godibairo owefoisaie yanu merama ukekaini imukeka yaisina maisufekuro me sifekuro Godima yabairo ibaada yanu ko yareka odo keuwere yabairo odaiseifekuro fareifekua wei. I Keriso, Godinu we munike yabairo mai Mi, Yesu, yabairo we odaifekua wei. ");
INSERT INTO aby_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Enoba awoenae Dawa urero ibinuba nono dubuenaro orofa akaka eraerabusaini eme ma wirokeka odo fafekuro nono isare aafekua wei. Adinaro Godima Danu we bou urie oroubairo i odobake weia Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","Nono Fidama eno wei, Mosesima eno weia wei, Godima iyabairoma moi we bou ukeka Mi na ari mufekuro Danu wake aneaneme wefekuro naufoisaya Mosesima eno weia Fidama wei. Mosesima eno weia wei, aina mima Danu wake da naufekuie i wake da naufeku mi ma feafekua Mosesima eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Godinu we bou ukeka orou yaisina Samuerobairoma yewa wake enaenari weibisaya Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","26","Ya yaisinae Godinu we bou ukeka orounu amaraku. Ibake yae Godinu we bou ukekaro naukeka orou. Godima Eibaramubairo we bou uiro yanu babaemuku naukeibisaro nono awoena iya yaisina naukaisia wei. Godima Eibaramubairo eno wei, anu amarananakubairoma Yesu fafekuba i orofa akaka eme yaisina we ma irauaiai umiau Godima eno weia Fidama wei. Godi Danu waiya ukeka Mi Yesu feariro nono Godima Dawa ma uyarike yabairoko we odaike yanu merama merama ukeibisabairoma ya yaisina ma owefike we ma irauaiai ufine ibake we odaia Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fidaini Dionini emuama i ku uke ibisa oroubake Yesu fearike uyari wake weibisiro i Du orounu ofereni ode sibore sianeka orouini dai sosi uwara furisi kafudenini Sadusi sisa orouini emuama anisake i miyaibairo ane faka. ");
INSERT INTO aby_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","3","I afasoro miyaima Yesu fearike uyari enaenari i eme yaisina feare nono uyareifeisaya eno we ma iwoka ukeibisi ibake i dai orouma dino uisake dumu ma girisi yareibiro Fidaini Dionibairo ane fakake emua yabaisake emenu wanayai mukake ane derena enaro naama uwane odiriekake ana ebaro waure ane odirieka. ");
INSERT INTO aby_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eme keuwere Yesunu uyareka wake nauisake Yesu imuisaro nono moi orouma imuisakema nono emenu imuka yaisina Yesubairo ode dauisa. Eno uisaro Yesunu wake nauisa orou mane Danu wake mune imukaro oisa. Eno uisake Godinu wake nauisake emenu imuka yaisina Godibairo oisa emeye yaisina fai dausini (5,000) keuwere eno uisa. ");
INSERT INTO aby_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Nono wai uriro i Du dai orouini goi yawokeka orouini Mosesinu darawadu we ma iwoka ukeibisa orouini emua yaisina Derusaremu goiro ane faka. Ane fakake i dai ofereni ode sibore sianeka mi Enasini danu dai orou Kaiyafasini Dionini Arekisanaini danu moi goi orouini emuabairo Derusaremu goiro ane faka. ");
INSERT INTO aby_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ane fakaro moi orouma i afasoro orouini i umu giena ui mini i ku uke ibisa orou emenu ku ubarenaro waure aare odirieka. Waure aare odiriekaro i kanisoro orouma eno weisa, iyanu ibooro enaewe weisake Fidaini Dioni emuabake nono weisa, yewa minu umu aneaneme ma giena ukisi eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Ainanu bunaro o ainanu ibiro eno ukisi weisa? Eno weisaro Godinu Imumu Irauma Fidanu imuka ubarenaro wake fari ibake Fidama uyare eno wei, yewa orouini dai orouini goi yawokeka orouini ya nanu wake nauawe weike eno wei, i minu umu giena ui ibaibake we nauke eraisa wei? ");
INSERT INTO aby_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","I mi danu umu giena ui ena danu ubi wemauro ya kanisoro orouini Du orouini yaisina nauaweke iwoka siawe wei. Yesu Keriso Nasaredi Minu bunama i minu umu ma wirokinuro yanu ibooro irauaiai enare ibinuro eraisaya wei. I Yesu yama korosiro ikokoma ure dabame oisa. Korosiro ure dabame oisaro feariro Godima Dawa nono ma uyaria wei. ");
INSERT INTO aby_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Godinu bukaroma Dawabake weaku wakeye eno, I uwara ma enareka orounu mune sianeka kukubu kai ie i bokai kukubu kai ari sinia, Godinu bukaroma eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dawama iya ma wiromisia wei. Yewa dooro orofa akaka emema iya da ma wiromisaisaya wei. Godi Dawa mane Yesu Danu ibi daiwere mami ibake Danu ibima iya ma wiromisia Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","15","Fidaini Dionini emua i oroubake ia sine dauisike emua adinaro sikuru uke dauisibairoma nono Godinu bunaro wake daiwere weisi. Eno weisiro i kanisoro orouma ibai imuisake emenu imuka foria daiwere ukaada we imuisake eno weisa, i miyai Yesuini demuiro eneiareibisi ibake i umu merama mi ma wirokisiro emuaini enare ibinua weisake ekake ibake moko wake we da uisakema nono weisa, ya una buuba ya i uwara udiro amuawe weisaro amuisa. ");
INSERT INTO aby_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Eno weisaro amuisaro i kanisoro orou emenu mane eno weisa, i oroubake aneaneme ufeisi weisa? Eno weisake nono weisa, i Derusaremu orou emenu buna ukeka yaisina iwoka sinaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","18","Ibake i minu umu ma wiroke dakisa da wefeisia weisa. Eno weisake nono weisa, moi orouma i ukisa ibai naunao ufeisaba Yesunu ibiro da weforo wefeisike we iifa ufiakikia weisa. Eno weisake aarawe weisaro emuabairo ane fakaro eno weisa, Yesunu ibiro moi buna ukekaini weekaini eno da uforo weisa. ");
INSERT INTO aby_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Eno weisaro Fidaini Dionini emuama uyare eno weisi, Godinu wakema irauaiai o yanu wakema irauaiai ainanu wakema naufuku weawero naufu weisi. Eno weisike nono weisi, uwanu naukekaini erekama wefukua weisi. ");
INSERT INTO aby_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Eno weisiro i kanisoro orouma i miyaibake bunawereroma we iifa urieka. Eno weisaro nono Derusaremu goi orou emua ibai ereibisa ibake Godibairo we ma irauaiai ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","I umu giena ui miye awoena mi mero danu oyae fodi (40). Enoba i kanisoro orouma bunawereroma we iifa uriekake fanisi make dariekake me odairiekaro anisa. ");
INSERT INTO aby_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fidaini Dionini emuama i kanisoro orou meisike emenu naiyemukubairo sabu anisike i dai kanisoro orouini goi yawokeka orouini emenu weisa wake yaisina ane weisi. ");
INSERT INTO aby_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ibai yaisina ane weisiro i orou yaisina naukada Godibairo guriguri uisake eno weisa, iyanu Babae Godi, Ama yewa orofa akakaini ureini dawaraini ana omaini idina madina urunaini erawa naukawa yaisina ubu ui. ");
INSERT INTO aby_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ama weiro Anu Imumu Irauma Anu waiya ukeka mi Deiwidi iyanu sisia sirorari mibairo wei ibake Deiwidima eno wei, i imusu orou anemebake imuka ka ukaisa wei? I Isaraera orou yaisina anemebake me sara imukaisa? ");
INSERT INTO aby_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I kini orou yaisina emenu imusu uke bou ukeibisaro i yawokeka orou yaisina Godini Danu we mune odi Mini emuabairo urafisane enakaya, Deiwidima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","I orouma guriguri ukaada weisake eno weisa, Erodini Fonidiasi Faeradini imusu orouini Isaraera orouini emuama i Derusaremu goiro irau Yesu Keriso Anu we mune odi Mini urafisane faka. ");
INSERT INTO aby_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","I uisabai yaisina Ama adinaro eno ufisane wei ibake enaenari uisa. ");
INSERT INTO aby_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","I afasoro orouma eno weisake nono weisa, Babae Godi, awoenae i kanisoro orounu uraneka wake nauake iya Anu waiya ukeka orou unu koaro Anu wake bunawere wefene weaisia weisake guriguri uisa. ");
INSERT INTO aby_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Eno weisake nono weisa, Anu buna wana siaake eme ma wiroake Anu merama merama uke dakaku Irau Mi Yesunu ibiro buna ukeka ua weisa. ");
INSERT INTO aby_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Godibairo guriguri ukaada wake eno we me sikaro emenu yaure ibisa orofa amani amani uiro Godinu Imumu Irau emenu imuka ubarenaro isari ibake Godinu wake bunawere weada ia sine dauisa. ");
INSERT INTO aby_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Godinu wake naukeka orou emuae demui imuka imukeka orou. Ibake i orou yaisina emenu waiyaini eraerabusa yaisina omi ukeroma iyanua weroma omi uke dakeibisake i eraerabusa yaisina ma fiake naka naka ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Enoba i afasoro orouma Yesunu fearike nono uyaribai i wake bunawere weibisaro Godima emua daiwere we ma irauaiai ukeibirie. ");
INSERT INTO aby_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","I furo moi mima desini ure daui. I afasoro orou yaisina irauaiai ibeibisa. Eno ukaada i waiyaini i dooro ibi uwara bobo orou emenu waiyaini uwaraini mariekake i oi mukake afasoro oroubairo mariekaro i afasoro orouma i oi mukake i oi me oroubairo naka naka uke marieka. ");
INSERT INTO aby_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Moi Riwai goi mi danu ibiye Diosefu danu orofae Saifurasi, i afasoro orouma i mibake Banabasi weibisa, i ibinu ubiye we ma nabi ukeka mi. ");
INSERT INTO aby_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I mima enaenari danu waiyaini doo yaisina make oi munike i afasoro oroubairo marie. ");
INSERT INTO aby_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Moi minu ibiye Ananaiasi nono danu awekanu ibiye Safaira, i mima danu doo make oi munike moi oi danu uwararo fe odike moi oi i afasoro oroubairo waure ane marie. I minu aweka danu emenu ui ibai yaisina dawa iwoka sini. ");
INSERT INTO aby_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ananaiasima moi oi danu uwararo fe odike moibai mane waure fariro Fidama eno wei, Ananaiasi, seidaninu abairo mai imuka anemebake muninuke Godinu Imumu Irau we irukaku wei? Eno weike nono wei, anu doo marieke muni oi moibai fe odinuke moibai mane makaku ibake Godinu ibooro Danu Imumu Irau we irukakua wei. ");
INSERT INTO aby_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Eno weike Fidama nono wei, adinaro i dooe anua wei. Nono awoena oi muninuke i oi yaisina anua wei. Nono anemebake merama imukeka imukama imukaku wei? Eno weike nono wei, emebairo iruke meya ae Godibairo we irukakua wei. ");
INSERT INTO aby_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Fidama eno weiro Ananaiasima ibai nauike iduama biruke isarada idua feariro ibai ekake Godinu wake naukeka orou ia daiwere sika. ");
INSERT INTO aby_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ananaiasi eno uke feariro moi awoena orouma aare fakake Ananaiasinu ofe bou mukake wauma oba uisake waure anisake ooru uisa. ");
INSERT INTO aby_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ananaiasi eno uike feariro eweka amuke abanaro fariro nono danu aweka Safaira dawae danu eme uibai nauke da uike aare Fidabairo fari. ");
INSERT INTO aby_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","9","Aare fariro Fidama eno wei, yewa oiye anu doo marieke muni oi yaisina iduaya wei? Eno weike nono wei, moibai mero yewa mane wei? Wearo nauma wei. Eno weiro Safairama ma owerike eno wei, euwa weike, yewa maneya wei. Weiro Fidama nono wei, anemebake Godinu Imumu Irau we iruke efane weaku wei? Eno weike nono wei, anu eme ooru uke oisa orou idua aisamero faraisaba a waufeisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Eno weiro i aweka iduama biruke ane isarike feari. Nono Ananaiasi ooru uke oisa orou owere farada ekabaie Ananaiasinu aweka idua feari ibake nono danu ofe bou mune waukake danu eme ooru uke oisa iro waure ane ooru uke oisa. ");
INSERT INTO aby_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eno uisaro Godinu wake naukeka orouini me orouini i uisabai ere nauke uisake ia daiwere sirie. ");
INSERT INTO aby_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","I afasoro orouma eme keuwerebairo Godinu buna ukekaini kawama ukeka ukeibisa. Eno ukeibisaro Godinu wake naukeka orou yaisina moi dai sosi uwara seboro danu ibiye Soromoninu sebo, iro fare ku ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Moi imusu orou i afasoro oroubairo Godinu irau oroua eno we imukeibisake ia sineibisa ibake emuabairo fare yaure dakeibisa. ");
INSERT INTO aby_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Emua eno ukeibisaro nono moi Godinu wake naukada imukeibisa emeakaini awekaboini i Godinu wake naukeka oroubairo ane boboro dakaa ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","I afasoro orou aine wai ure eno mane ukeibisa ibake i orou emenu arama uke ibeibisa orou weama yaweke odeibiriekaro daaba udiro yaure ibeibisa. Eno uke waure ane odeibiriekaro Fidama i daaba daabaro eneiareibiro danu ewekaro eraisa imumuma emua riu sianeifiro wirofisane ibake emenu arama uke ibeibisa orou waure ane daaba udiro odeibirieka. ");
INSERT INTO aby_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","I Derusaremu goi udi udiro eme emenu arama uke ibeibisa orouini waure fariekaro seidaninu merama imumu bobo orouini arama uke ibeibisa orouini emua yaisina wirokeibisa. ");
INSERT INTO aby_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","I dai ofereni ode sibore sianeka mini danu naiyemukuini i Sadusi sisa orouini emuama i afasoro oroubake imuka ka ukaada emuabake aya odeka wake weisake i afasoro orou yabariekake waure ane ana ebaro odirieka. ");
INSERT INTO aby_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Waure ane ana ebaro odiriekaro dumuro Godinu aneruma anike emua ibisa ana ebaro aisame ma eba uike i afasoro orou aweawero waure fare odirie. ");
INSERT INTO aby_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Waure fare odirieke eno wei, dai sosi uwara ubarenaro enafoke Yesunu fearike nono uyarike awoena me ibinu wake weforo wei. ");
INSERT INTO aby_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I aneruma eno weiro i afasoro orou naukenewaa uisa. Eno uisake ibisaro wai uriro anisake i dai sosi uwara ubarenaro amuisake Yesunu fearike uyari wake we ma iwoka ukeibirieka. I odoro i dai ofereni ode sibore sianeka mini danu naiyemukuini emuama i kanisoro orouini Isaraera orounu goi yawokeka orouini dai midini ufisane wake we odaisa. Wake we odaisake moi orou i ana ebaro afasoro orou mufiakane we odairiekaro emuabairo anisa. ");
INSERT INTO aby_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Aneebe ane fakake ekabaie emua iro me. Emua iro meba ibake owekake aare fakake eno weisa, i ana ebaro aisame yaisina koure ibinuro yawokeka orouma yawokenewaa ukaisaro farisike ubarenaro amukisike erisibaie emua iro meya eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","25","Eno weisaro nauisake aboro anisa arie eno we imukeibisabaie moi mima farike i emuabake wake wefine ukaada eno wei, i ana ebaro odirieka oroue i dai sosi uwara ubarenaro enare ibaada we ma iwoka ukaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Eno wei ibake furisi kafudenini moi furisimani orouini anisake Isaraera orouma emua omama umanao ufiakaisaba ibake ia sikake i afasoro orou muriekake owainanaku wauriekake ane fare i kanisoro orounu ibooro enaewe weisaro enaka. ");
INSERT INTO aby_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","30","I kanisoro orounu ibooro enakaro i dai ofereni ode sibore sianeka mima eno wei, Yesu Kerisonu ibiro da wefone we iifa uisi ibai ya nauisaba me wei. Yanu ukeka eawe wei. Derusaremu goi orou yaisina yanu wake naukaisaya wei. Eno weike nono wei, yama eno weisa, iyama Yesu ma feakiaya weisa weiro i afasoro orou nauisake emuama eno weisa, Godinu imukeka mane mufeisia weisa. Eno weisake nono weisa, emenu imukeka da mufeisia weisa. Eno weisake nono weisa, yama Yesu korosiro ikokoma ukaro fearia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nono iyanu Babaemukunu Godima Dawa feariro nono ma uyarike Danu ba ena wana enaro odike Yesu iyanu Dai Mike ma wirokeka Miya we odia weisa. Eno weisake nono weisa, i Isaraera orou emenu merama merama ukeka yaisina imuke medifeisaie emenu merama merama ukeka yaisina mufekuke imuke medifeku ibake Godima eno we odi. ");
INSERT INTO aby_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","I ukeka yaisina iya eraisi. Nono Godima Danu Imumu Irau Danu wake naukeka oroubairo mariea weisa. Eno weisake nono weisa, Godinu Imumu Irauini iyaini i ukeka yaisina eraisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","I kanisoro orouma i wake nauisake ararua siriero i afasoro orou ufeisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Eno weisaro moi kanisoro mi danu ibiye Gameiria, dawae Du orounu dai darawadu yawokeka sisa mi. Nono i orou yaisina dawa irau miya eno we imukeibisa. I mima uyarike i afasoro orou i uwara udiro anifisane weiro anisaro dawama eno wei, ya Isaraera orou, i oroubake aneme aneme ufone ukaada erenewaa uforo wei. ");
INSERT INTO aby_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gameiriama eno weike nono wei, adinaro moi mi danu ibiye Deudasi dawama enarike na dai mi weiro eme keuwere fo aderedi (400) dawabairo ane dakaa uisaya eno wei. Enoro Deudasi ma feaka ibake danu umuro eneiareibisa orou yaisina daaba imusu imusu anisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Eno weike wei, nono dubuenaro moi Gareri mi danu ibiye Diudiasi, i ibi ibi fefaro muneibisa furo moi dai mi enariro moi orouma dawabairo dakaa uisa. Eno uisaro dawa feariro nono danu umuro eneiareibisa orou yaisina daaba imusu imusu anisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ibake yewa afasoro orou medifone weakunea wei. Eno weike nono wei, emenu ukekae emenu ukeka ari eno mane ufeisaie emenu ukeka isafekua wei. ");
INSERT INTO aby_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","40","Eno weike wei, nono emenu ukekae Godinu ukeka ibake da mune siafoisaya wei. Nono emua meo weaisaya wefoisake mune siafoisaie Godini uranao ukeifoisa ibake weakunea eno wei. Eno wei ibake i kanisoro orouma danu wei wake nauisake i afasoro orou u weisaro emuabairo ane fakaro usima uriekake nono Yesu Kerisonu ibiro da we ma iwoka uforo we iifa ukaada odairiekaro i afasoro orou owere anisa. ");
INSERT INTO aby_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eno uisaro i dai midini idua meisake owere anisa. I afasoro oroue Yesu Kerisonu orou ibake moi orouma emua meramawere uke yareibirieka. Eno ukeibisaro Godima wake we dauike i afasoro oroubake irauaiaiya we imui ibake i afasoro orouma maru uke dauisake rooro uisa. ");
INSERT INTO aby_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aine wai ure i afasoro orou i dai sosi uwara ubarenaro o moi orounu uwara ubarenaro Yesu Kerisonu irauaiai wake we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dubuenaro i iwoka ukeka orou keuwere uyareibisake i Guriki wake weibisa Du orouini ba Du farafa orouini wake we makaneibisa. Eno ukeebe i Guriki wake weibisa Du orouma eno weisa, iyanu wabu awekabobake urunaini oini daiwere make dakakunekaya eno weisa ibake wake we makaneibisa. ");
INSERT INTO aby_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Eno uisaro ibake i duwero (12) afasoro orouma i Godinu wake naukeka orou yaisina weisaro faka. Fakaro i afasoro orouma eno weisa, Godinu wake da wefeisike urunaini oini i mane naka ufeisiie irauaiai meba i Godinu Imumu Irau bobo awara bunawere orou seweni (7) we muyakawero i naka naka ukeka waiya mafiaki eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Eno weisake weisa, nono iyae iyanu mane guriguri ukeifeisike Godinu wake mane weifeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Eno weisaro emenu wake nauisake Godinu wake naukeka Imumu Irau bobo mi Sidiwinini moi orou Firifuini Fokorasini Naikeini Daimonini Famunesini nono Nikarosini danu orofa Anidiyoka, i Mi dawa Du mi ari sini, i orounu wake weisaro nauisake waure ane afasoro oroubairo odirieka. ");
INSERT INTO aby_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ane odiriekaro i afasoro orouma guriguri ukaada emenu wana emenu iiri duboro oisa. ");
INSERT INTO aby_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eno uisake Godinu wake we eneiareibisaro moi orou keuwere i wake naukeibisake Godinu wake naukeka orou sineibisa. Emua mane mero nono i Du orounu sosiro ofereni ode sibore sianeka orou keuwere Godinu wake naukeka orou sineibisa. ");
INSERT INTO aby_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Godima Sidiwini we ma irauaiai uike buna daiwere mai ibake Sidiwinima buna ukekaini kawama ukekaini keuwere ukeibiro eme keuwere ibai ereibisa. ");
INSERT INTO aby_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Moi du orounu sosiro guriguri ukeibisa orouma iyae iyanu onarou yawokeka oroua eno weisa. I orouini moi Sairina orouini moi Arekisania orouini moi Sirisia orouini moi Eisia orouini i oroorofa orou yaisina uyakake Sidiwinini wake we maka. ");
INSERT INTO aby_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eno uisaro danu iwoka daiwereke nono dawae Godinu Imumunu bunaroma wei ibake meisa. ");
INSERT INTO aby_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Meisake anisake moi meomao weeka orou we muriekaro i meomao weeka orouma eno weisa, Sidiwinima Mosesini Godini emuabake wake merama weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eno weisa ibake i ku siane ibisa orouma nauisake Sidiwinibake ararua daiwere uyaka. Eno uisake i dai Du orouma Sidiwini yabaisake wanayai mune ane derena enaro naama uwakake i kanisoro oroubairo waure ane oisa. ");
INSERT INTO aby_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Waure ane oisaro i meomao weeka orouma eno weisa, yeka mima eno weia eno meo weisa, dawama i dai sosini Mosesinu darawadubake merama wake weakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Eno weisake nono weisa, yeka mima eno weia weisa, Yesu Keriso Nasaredi Mima i dai sosi ma merama ufike Mosesinu darawadu mune siafekua eno weiro nauisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eno weisaro i kanisoro orou yaisina Sidiwininu iboo naisa ekabaie edoro daiwere uiro eka. I ekaie anerunu iboo naisa ari eno uiro eka. ");
INSERT INTO aby_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I dai ofereni ode sibore sianeka mima eno wei, emenu weaisa wayai wake meoba ba weaisa wei? ");
INSERT INTO aby_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eno weiro Sidiwinima moko wake ma owerike eno wei, babaemukuini naburaka, nanu wake nauawe wei, iyanu sisia sirorari mi, Eibaramu, danu ibeibi orofa Mesofadeimia orofaro ibeibike iroma Erani goiro ane daui. Iro me ibeibiro iyanu Babae Godi, Dawae iyanu dai Godi ibake Dawama Eibaramubairo aare fari. ");
INSERT INTO aby_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aare farike eno wei, anu goi orouini yewa orofaini mediake moi orofaro ania wei. I awoena orofa abake ma iwoka umane ukakunea iro ania wei. ");
INSERT INTO aby_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eno weiba ibake i Karidia orofa medike i orofaro idua ani. Medike ane Erani goiro fari. Iro ane farike iro ibeebe danu babae i Erani goiro feari. Danu babae feariro Godima Eibaramu yewa Isaraera orofa iyanu ibinisi orofaro waure fare odi. ");
INSERT INTO aby_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yewa orofa doo ma iwoka uike eno wei, yewa orofa akaka yaisina aini anu amara aruma mamauane eno we bou uikema nono i odoro i doo Eibaramubairo make daui. Make dauiro i we bou ui odoro Eibaramu dawa amara aruma me. ");
INSERT INTO aby_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ibake Godima moi wake Eibaramubake eno wei, anu amara aruma yewa orofa medifeisake moi orofaro anifeisaya wei. Iro oya keuwere fo aderedi (400) ibeifeisaro imusu emema emua arawere yawokeifiakaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","I imusu orounu yawokekae ba me ibake emua wemauro emenu ibeka merama sifekua wei. Godima eno weike nono wei, eno wemauro anu orou owefeisake yewa orofaro fare ibaada Nabake aine wai ure guriguri ukeifeisaya Godima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Godima danu we bou ukeka Eibaramubairo mai. I we bou ukekanu ubue ofe kuureka. Eibaramuma Aisiki dore muniro i amaranaku odo keuwere me eida (8) me siniro danu ofe kuuri. Aisiki dai sinike danu aweka Rebeka munike nono Deikafu dori. Deikafu dai sinike danu awekayai Riaini Reisoro murieke iyanu sisia orou yaisina duwero (12) dorie. ");
INSERT INTO aby_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Deikafuma i sisia orou duwero (12) dore odiriero iyanu sisia sirorari orouma Diosefuini dino uisake Idifi oroubairo maisake oi mukaro Diosefu Idifi orofaro waure anisaro waiya ukeka mi sini. ");
INSERT INTO aby_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Diosefu Idifiro waure anisaro Godima Diosefu yawokeibiro ani. Anike Idifi orofaro fariro Godima Diosefu unu kori ibake merama uke daui. Eno uike Godima Diosefu buna mairo Kini Fero, dawa dai Idifi orofa yawokeka mi dawama Diosefu dawa irau mi eno we imuike we mune danu uwara yawokeka mi we mune odi. ");
INSERT INTO aby_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Eno uke ibeebe moi furo Keinani orofa orou arumu daiwere yaukake iyanu babaemuku desini daiwere urie. ");
INSERT INTO aby_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Uruna me siniro arumu yaukake ibeebe uruna Idifi orofaro ibinua weisaro Deikafu i wake nauike danu amaraku iro we odairiero uruna ane mukake nono owere aaka. ");
INSERT INTO aby_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nono ena uruna me siniro nono we odairiero anisa. Ane fakaro Diosefuma danu kakamuku we ma iwoka urieke nae yanu nabueya weiro danu kakamukuini nabueini emuama Fero fou uka. ");
INSERT INTO aby_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Diosefu fou ukaro Diosefuma weiro danu babaeini danu goi orou yaisina Idifi orofaro erakure farieka. Eme keuwere yaisina sewenidi fai (75) erakure farieka. ");
INSERT INTO aby_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Erakure fariekaro Deikafu Idifi orofaro anike iro ibeebe feari. Dawaini iyanu akaemukuini emua yaisina feare me sika. ");
INSERT INTO aby_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Feare me sikaro waure ane Sikamu orofa oma eraboro ooru urieka. I ooru ukeka orofae Eibaramuma Eimo weibisa mi danu amarakubairo oima makaada i oma erabo muni. ");
INSERT INTO aby_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Godima Eibaramubairo Isaraera orofa mamauanea eno we bou ui. Godinu we bou ui odo idua fafine ukinuro iyanu sisia sirorari orouma amarananaku keuwere doreibiereka ibake eme keuwere Idifi orofaro ibeibisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nono dubuenaro moi kini mima uyarike Diosefu feariro danu ibi dawa iwoka me ibake iyanu oroubake meramawere ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eno ukeibike emenu awoena doreibisa amarananaku yaisina ma feafiane weibi ibake emenu awoena doreibiereka amarananaku yaisina nauwaro sianeibisaro iro feareibisa. ");
INSERT INTO aby_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","I amarananaku nauwaro sianeibisa i furo Mosesi danu amaema Mosesi doriro Godima eribaie irauaiai amaranaku eri. Ibake Mosesinu amae babaema manabe kai buuba dawa yawokebe nono iro meisi. ");
INSERT INTO aby_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Iro meisiro Feronu arumama i amaranaku munike omuiro danu amara ari sini. ");
INSERT INTO aby_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eno uiro Mosesi daisinike Idifi orounu sikururo sikuru ukeebe iwoka daiwere muni ibake danu weekaini ukeka daiwere ui. ");
INSERT INTO aby_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosesima Feronu uwararo ibeebe oya fodi (40) me siniro nono moi odoro dawa iduama uyarike danu Isaraera adara efiane ani. ");
INSERT INTO aby_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aneebe daabaro eribaie moi Idifi orofa mima moi Isaraera mi usima ureibi. Ureibiro ibake Mosesima i Idifi mi uriro feari. ");
INSERT INTO aby_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eno uike Mosesima eno we imui, nanu orou na iwoka sinaisa Godima na we odaisinuro nanu Idifi orofaroma nanu orou waure animiane fare eno we imuiroma nono danu orou i we imui ibai emua iwoka uke dauisa ibake Mosesi danu onami we irui. ");
INSERT INTO aby_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","We iruike ainike wai uriro danu goi oroubairo nono ani. Aneebe eribaie moi Isaraera miyai emenu emenu uraneibisi. Uraneibisiro Mosesima eneebe erike eno wei, mediawa. Ya demui orofa miyai ya anemebake uranaisi wei? ");
INSERT INTO aby_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","Eno weiro moi uraneibi mima eno wei, a ainadei? Aina mima a dai mi we odiai wei? Eno weike nono wei, ariena ama i Idifi mi uriro feari wei. Eno weike wei, na awoena enaenari ufarine weaku wei? ");
INSERT INTO aby_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eno weiro Mosesi iduama ia sinike Idifi orofa medike moi orofaro sabu ani. Ane Midiani orofaro ane fari. Ane farike iro ibeebe aweka munike danu amarayai dorie. ");
INSERT INTO aby_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","32","Mosesima iro ibeebe oya fodi (40) me siniro moi odoro Sainai weaisa oraara udiro amuke ani. Aneebe eribaie moi ananakuro inaa yareibi. inaa yareibiro i inaa yareibi ubarenaro eribaie aneruma enare ibiro erike eno we imui, yewa anemerabu we imuike durame anike faribaie Godima dawabake eno wei, Nae anu sisia sirorari orounu Godi weike nono wei, Eibaramuini Aisikini Deikafuini emenu Godiye Na ewadoya ea wei. Eno weiro Mosesi ia daiwere sinike iro ere daui. ");
INSERT INTO aby_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eno uiro Godima wei, anu umu fogowo ma kukua wei, eno weike nono wei, yewa dooe iifawere ibake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Godima eno weike ba nono wei, i Idifi orounu yawokekae arawere ibake Nanu orounu ibekae meramawereya eno wei. Godima eno weike nono wei, i Isaraera orou emenu ibekaini ii weekaini naue ibake iroma waure animiaua wei. Ibake Idifiro a we odaimauro anifakuke emua waure anifiakua Godima Mosesibairo eno weia Sidiwinima yewa wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Naiyemuku, adinaro iyanu akaemukuma Mosesi arara dauisake emuama eno weisa, ainama a dai mi we odiai eno weisa? Godima Mosesi we odairo ani. Aniro i inaa ubarenaro enare ibi aneruma dawa unu kori ibake Mosesi dawae emenu waure aarie mi nono dawae emenu dai mi sini. ");
INSERT INTO aby_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesima i danu eneiareibi oroorofaro i buna ukeka keuwere ukeibike danu Isaraera orou Idifiroma kokoi dawara ubarenaro waure fare anirie. I eme ibe me orofaro ane fakake iro eneiareibisa. Eno ukeebe oya fodi (40) eno areare ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosesima danu oroubake eno wei, Godima na we odi i ari moi we bou ukeka mi Godima iyabairo we mufekuke odifekua wei. ");
INSERT INTO aby_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosesini danu orou emua eme ibe me orofaro ane ibeibisa. Iro ibaada Mosesima wake weeka waiya ukeibi. Moi odoro Mosesima Sainai oraararo amuke aniro aneru unama dawabairo wake wei. Wake weiro i Sainai oraararo i me ibene ibene ibeka wake munike iyanu akaemukubairo isare aare weiro nauisake iroma ewa ewa we aaraisaro naukaisia Sidiwinima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sidiwinima danu Du oroubake nono eno wei, iyanu akaemukuma Mosesinu wake nauke dauisake i mi we ma berakake emenu mane eno we imuisa, iyanu Idifiro aineibisi irauaiaibairo nono yewa orofa meramawereya eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eno weisake nono uyakake Eronibake eno weisa, iyanu godi imusu ubu uaro i godima iya waure animisi weisa. Eno weisake nono weisa, iya waure aari mi Mosesi aboro ainu weisa? ");
INSERT INTO aby_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eno weisake gorudima moi boromakaunaku ubu uisake i boromakaubake ofereni maisa. Eno uisake emenu ubu uisa meo godibake rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eno uisa ibake Godima i orou yawoke darieke mediriero i orouma muinaini kudibake guriguri ukeibisa. Emua eno ukeibisa ibake Godima we bou urie orounu bukaro Godima eno wei, ya eme ibe me orofaro oya fodi, (40) ibeibisa furo ofereni Nabairo odeibisaba me? ");
INSERT INTO aby_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nabairo ofereni ode meya wei, i ba me godibake imukeibisa weike nono wei, i ba me godi danu ibiye Moroki danu ibeka farai uwaranakuini moi meo godi danu ibiye Refani danu muinaini waureibisake yanu wanama ubu ukeka eraerabusabake imukeibisake guriguri ukeibisaya wei. Eno ukeibisa ibake Godima eno wei, ya yaisina Babaronia orofaro yafawere we odaimiauro anifoisaya eno wei. I we bou urie orounu bukaro Godima eno weia Sidiwinima wei. ");
INSERT INTO aby_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sidiwinima eno weike iyanu akaemukunu faraima uisa dai sosi Godibairo guriguri ukeibisa uwara eme ibe me orofaro waure eneiareibisaya eno wei. Eno weike nono wei, Godima Mosesibairo weiro i faraima dai sosi uwara enaenari ma enaka. ");
INSERT INTO aby_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Godima weiro enaenari ma enakake dubuenaro emenu Keinani orofaro aareka furo Godima eme keuwere Keinani oroorofaro yoweriero ibake fiake iroma ia iyare anisaro iyanu akaemukuma i orofa muka. I furo Diosuaini iyanu akaemukuini emuama i faraima uisa dai sosi uwara waure anisa. Waure anisake Diosua idua feariro i faraima ma enaka dai sosi uwara oya keuwere ibeibiro nono Deiwidi danu odo ido faria Sidiwinima yewa wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deiwidinu odo idua fariro Godima Deiwidi erike irau miya we imui ibake Deiwidi danu ararae iyanu akae Deikafu danu Godinu dai ba sosi uwara ma enafine wei. ");
INSERT INTO aby_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Deiwidima eno weibaie Godima ama da ma enafakua eno wei. Ibake Soromonima i dai sosi uwara ma enari. ");
INSERT INTO aby_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","I urero ibinu Godi emenu ma enareka uwararo ibe dakakuie adinaro we bou ukeka mima Godinu wake eno wei, ");
INSERT INTO aby_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","I ureye Nanu yaureka orofaro nono i dooe Nanu umu amukeka orofaya eno wei. Eno ibake anemedei uwara Nabake ma enafoisa? Nanu wanama i yaisina ubu ue ibake anemedei irauaiai uwara ma enafoisaro iro ko yamau Godima eno weakua, I we bou ukeka mima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sidiwinima eno weike nono wei, ya ome boboba ba me orouro nauke nauke dakaisake Godi imuke dakaisake yae i imusu orou ari ibake Godinu Imumu Iraunu daaba dadau ukaisaya eno wei. Sidiwinima eno weike ba nono wei, yanu babaemukuma eno ukeibisa ibake ena furo enaenari ukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Eno weike nono wei, ya yanu babaemukuma Godinu we bou ukeibi orou yaisinaini urane rarane ukeibisake i Yesu Kerisonu owere fafekua weibisa orou uriekaro feakaya eno wei. Eno weike nono wei, i fafekua weisa Mi Godinu Irau Mi, yama eno uke wayai weisake ukaro fearia wei. ");
INSERT INTO aby_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sidiwinima eno weike wei, i aneruma Mosesibake i darawadu mairo muni. Muniro i darawadu dawabairoma yabairo aarebe aarebe awoena aare fari. I darawadue Godinu darawadua wei. Eno weike nono wei, i darawadu nono yama ma merama ukeibaisaya Sidiwinima yewa wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sidiwinima eno weiro i Isaraera orou yawokeibisa dai orouma dino daiwere uisake araruama ii saisa sirie. ");
INSERT INTO aby_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","56","Eno uisaro Godinu Imumu Irau we odairo Sidiwininu imuka ubarenaro isari ibake Sidiwinima urero eribaie ure eba siniro Yesu Godinu baena wana enaro ibiro erike eno wei, yeku ure eba ukinuro Yesu Godinu baena wana enaro enare ibinuro erakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Sidiwinima eno weiro i orou emenu ome ma yaakake daiwere beo we mamisake Sidiwini goi naisaroma ma youre me nauwaro mune siakake omama uka. Sidiwini ufisane ukaada emenu dubo barukeka wau kukune moi awoena mi danu ibiye Soro dawama yawokeifine maisake Sidiwini omama idua uka. ");
INSERT INTO aby_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","60","Eno ukeibisabaie Sidiwini Godibairo guriguri ui. Sidiwinima guriguri ukaada eno wei, Babae Godi, nanu imumu mua weike ifoma kodudu yanaike nono wei, Babae Godi, emenu i ukaisa meramawere emenu onaroubairo da odiake mune imuke media wei. Eno weike idua feari. ");
INSERT INTO aby_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Soro danu ararae Sidiwini ureka. Ibake i orouma Sidiwini ukaro moi Isaraera Godinu wake naukeka orou aare fakake ii weada Sidiwininu ofe bou mune ane ooru uisa. Sidiwini danu feari odoroma moi orouma Derusaremu goiro Godinu wake naukeibisa orou ba me merama uke yareibirieka. Eno ukeibirieka ibake i Godinu wake naukeibisa orou fiake imusu imusu anisa. Diudiaini Samaria orofayairo anisa. Anisaro i afasoro orou mane Derusaremu goiro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Soroma Godinu wake naukeibisa orounu goi goiro anike Godinu wake naukeibisa orou emenu wana mune ane derena enaro naama uwane anike emeini awekaboini yaisina eno urieke waure ane ana eboro odirie. ");
INSERT INTO aby_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","I fiake imusu imusu anisa orouma moi goi goiro Godinu wake we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Firifuma moi Samaria orofa goiro isare ani. Isare anike Yesu Kerisonu wake i oroubairo weada Yesunu ibiro buna daiwere uiro i orou yaisina danu wake naukenewaa uisa. ");
INSERT INTO aby_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","8","Firifuma eno weiro seidaninu moi merama imumu emenu imuka ubarenaroma amukada arua daiwere weada ia sine fare imusu anisa. Firifuma eno uike moi umu wana beobeo bobo orouini moi enare fare me orouini emua ma wirokeibiriero ibake i goi orou ibaibake rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nono moi mi danu ibiye Saimoni dawae diwari ureka mi. Enoba dawae i Samaria orofa goiro ibeibi. I goiro ibaada dawama eno wei, nae dai miya eno weibi. ");
INSERT INTO aby_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Eno weibi ibake i orou yaisina emenu imukekae ba dawa dai miya eno we imukeibisa. Saimonima diwari ureibike danu buna ukeka ukeibi ibake dawa dai miya eno weibisa. ");
INSERT INTO aby_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Saimoni dawae dai miya weisake ekabaie Firifuma Godinu yawokekaini Yesu Kerisonu ibiro wake bunawereroma weibi. Eno weibiro i goi orouma nauisake Yesu imukake Firifubairo emeini awekaboini emua babadaido urieka. ");
INSERT INTO aby_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Eno uriekaro Saimonima nauike Firifubairo ane fariro Firifuma dawa babadaido ui. Firifuma Saimoni babadaido uiro demuiro enarada Saimonima Firifunu buna ukeibi ibai yaisina ereibi ibake imuka foria daiwere ui. ");
INSERT INTO aby_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","16","I Samaria orou Godinu wake naukaisaya moi orouma eno weisaro i Derusaremu goiro ibisa afasoro orouma nauisa. Nauisake ibake Fidaini Dionini emua we odairiekaro Samaria orofaro isare anisi. Isare ane fakike i oroubake Godibairo guriguri ukaada eno weisi, Babae Godi, Anu Imumu Irau we odaiaro yewa oroubairo isafi weisi. ");
INSERT INTO aby_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eno weisike Fidaini Dionini emenu wanama i Samaria orou emenu iiri duboro odaada Godibairo guriguri uisiro Godima Danu Imumu Irau we odairo emenu imuka ubarenaro isari. ");
INSERT INTO aby_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimonima eribaie i afasoro orouma emenu wana i Samaria orounu iiri duboro odeibisaro Godinu Imumu Irau emuabairo isariro ukeibisa ibai Saimonima erike Fidaini Dionibake eno wei, oi mamiaro yanu buna ukeka na makuakiro nanu wanama emenu iiri duboro odimaro Godinu Imumu Irau emuabairo isafi wei. ");
INSERT INTO aby_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","21","Eno weiro Fidama ma owerike eno wei, a aneaneme imukaku wei? Eno weike nono wei, Godinu me makeka oima make mufaku wei? A eno imukakuba aini anu oini merama sifuwaisia wei. Fidama eno weike nono wei, anu imukekae meramawereba iyabairo Godinu waiya da ufakua wei. Eno weike ba nono wei, anu imukama Godibake imuke dakakuba iyabairo Godinu waiya da ufakua eno wei. ");
INSERT INTO aby_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fidama eno weike nono Saimonibake eno wei, anu imukekae meramawereya Godibairo guriguri uaro anu merama merama ukeka yaisina Godima mufike imuke medifi wei. ");
INSERT INTO aby_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Eno weike nono wei, anu ararae meramawereba merama mane ukeifakua wei. ");
INSERT INTO aby_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Fidama eno weiro Saimonima ma owerike eno wei, na arara me nanu merama ukeka wei. Eno weike nono wei, i merama ukekabake yama nabake Godibairo guriguri uawaro na ma wirofari wei. ");
INSERT INTO aby_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Fidaini Dionini emuama Yesu imukeibisi wakeini Yesunu wakeini eno we me sikike owekike Samaria orofa udi goi goiro anisi. Anisike Godinu wake we eneebe iroma Derusaremu goiro owere ane faki. ");
INSERT INTO aby_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Godinu aneruma Firifubairo isare aarike eno wei, isare aniake yeka Derusaremu goiroma Geisa daabaro isare ania wei. Eno weike nono wei, yeka daabae obi isare me daaba, eno weiro nauike i daabaro ani. ");
INSERT INTO aby_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ane faribaie moi dai Idiofia orofa goi mi, kuini Kadasinu oi yawokeibi mi idua fari. Dawae Derusaremu dai sosiro anike guriguri uike nono owerike idua fari. ");
INSERT INTO aby_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Danu osi abuma ma youreka seboro yaure ibaada Godinu buka ibiye Isaiya kakure aare idua fari. ");
INSERT INTO aby_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Idua faribaie Godinu Imumu Irauma Firifubake eno wei, i mibairo ania wei. ");
INSERT INTO aby_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eno weiro Firifu durame ani. Ane fariro i mima Godinu buka ibiye Isaiya kakuriro nauike Firifuma eno wei, anu kakuraku i wake danu ubi imukakuba me wei? ");
INSERT INTO aby_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eno weiro i mima ma owerike eno wei, nanu mane kakumau ide aneaneme i wakenu ubi imumauke iwoka simau weike nono wei, moi mima na we ma iwoka ufarakuie i wakenu ubi iwoka simaua wei. Eno weike Firifubake nono wei, nabairo osi abuma ma youreka seboro amuake yaua weiro amuke yauri. ");
INSERT INTO aby_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","I mima kakuri wakenu ubiye eno, Emema mamoe abu ma feafisane mune anifeisaie mamoe abu arua we dakaku. O mamoenakunu idi kuuraisaie arua we dakaku enaenari emema Dawa ma feafisane mune anisaie i ari enoba Dawaini arua we daui. ");
INSERT INTO aby_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dawa arua we daui ibake moi mima Dawa medaia we daui. Dawa fearike urero amuke anike iro ibinu. Ibake abo mima yewa orounu merama ukeka we ma boroo yafeku, i mima i wake eno kakuri. ");
INSERT INTO aby_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eno kakurike i Idiofia mima Firifubake eno wei, i Godinu we bou ukeka mima ainabake weaku? Danu onamibakeba moi mibake weaku? ");
INSERT INTO aby_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eno weibaie Firifuma i wakeroma Yesubake irau wake yaisina we ma iwoka ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eno we ma iwoka uke aneebe moi adua fou uki. Fou ukike i Idiofia orofa goi mima eno wei, na ama babadaido ufarine weakune wei. Eno weike nono wei, na babadaido ufarakuba me wei? ");
INSERT INTO aby_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Eno weiro Firifuma ma owerike dawabake eno wei, anu naukeka irauaiae babadaido umauanea weike nono wei, anu naukeka meramae babadaido da umauanea wei. Firifuma eno weibaie i Idiofia orofa goi mima wei, na Yesu Keriso Godinu Amara imukakunea wei.) ");
INSERT INTO aby_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Eno weike sebo ma youreka osi abubake wake we kuuriro enariro i seboroma aduaro isaki. Isakike Firifuma Idiofia orofa goi mi babadaido ui. ");
INSERT INTO aby_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Babadaido uiro aduaroma udiro amukeibisibaie Godinu Imumu Irauma Firifu munike sabu waure ani. Sabu waure aniro Idiofia orofa goi mi Firifu nono ere daui. Ere dauike Firifuma i mi babadaido ui ibake rooro daiwere ui. ");
INSERT INTO aby_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Godinu Imumu Irauma Firifu waure anike Asodu goiro fare odiro Firifuma iro Godinu wake weike i Asodu goi udi udiro Godinu wake we eneebe iroma Sesaria goiro ane fari. ");
INSERT INTO aby_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Soro dino ukeibike Yesunu wake naukeibisa oroubake meramawere uke yareibirie. Eno uke yareibirieke moi odo anike i dawako dai ofereni ode sibore sianeka mibairo anike eno wei, owaowa yanake mainaro i Damasikasi goiro Du orounu sosi yawokaisa oroubairo ane mamiaro efisake emuama na unu kofokoro i Yesunu wake naukaisa orou emeini awekaboini yaisina emenu wana mune ane derena enaro naama uwamiake mune Derusaremu goiro waure famia wei. Eno weiro owaowa yanake mairo ani. ");
INSERT INTO aby_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","4","Anike Damasikasi orofaro aneibibaie edoro daiwere ureroma isare aarike Soronu ofe ubu edorowere mane uiro Soro dooro isare uri. Isare uriro ureroma wake isare aarike eno wei. Soro, anemebake Na meramawere uke yarakunara wei? ");
INSERT INTO aby_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Eno weibaie Soroma ma owerike a ainadeiro wei? Eno weibaie Nae Yesua wei. Eno weike nono wei, aine wai ure Nabake meramawere uke yarakunara wei. ");
INSERT INTO aby_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yesuma eno weike nono wei, awoena uyaake Damasikasi goiro aniaro anu ufaku waiya abake moi mima mamekuro ufakua wei. ");
INSERT INTO aby_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Eno weiro Soro dawaini eneibisa danu naiyemuku i wake nauisake ba eme ere karana uke dauisake wake we dauisa. ");
INSERT INTO aby_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Eno uisaro Soro uyarike naisa foraike efine eribaie ere karana uke dauiba ibake danu naiyemuku emuama danu wanaro mamisake Damasikasi goiro waure ane faka. ");
INSERT INTO aby_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Iro waure ane fakake Soro odo buuba danu naisa ere karana uke mero me ibaada aduaini urunaini ise dauike me ibeiari. ");
INSERT INTO aby_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Godinu moi naukeka mi Ananaiasima Damasikasi goiro ibeibi. Iro ibeebe kubekuberoma eribaie Yesuma eno wei, Ananaiyasi, weibaie Ananaiyasima ma owerike na ewado wei. ");
INSERT INTO aby_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Eno weiro Yesuma wei, aniake gienabu weaisa daabaro isare aniake Diudiasinu uwara ubarenaro amua wei. I Darasu goi mi Soro aboro ibinu ariya we nauke ea wei. Eno weike Soroma guriguri ukeifekuro efakua wei. ");
INSERT INTO aby_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yesuma eno weike nono wei, anu fareka odoe Soro dawa iwoka uke ibinua wei. Anu fareka odoe Dawaini kubekuberoma erinuba ibake dawa iwoka uke ibinuba ama fafakuke anu wanama danu iiri duboro odifakuie danu naisa idua ere karana ufekua wei. ");
INSERT INTO aby_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yesuma eno weiro Ananaiyasima ma owerike eno wei, Dai Waria Mi, Soro dawa na iwokaya eno wei. Eno weike wei, i miye anu Derusaremu goi orounu ibeka ma meramawere uke yareibakunea eno wei. ");
INSERT INTO aby_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eno weike nono wei, i dai ofereni ode sibore sianeka orouma dawa owaowa yanake maisaro munike aaria wei. Dawa yewa goiro faria wei. Eno weike nono wei, dawa owaowa bobo eme mufiake waure anifiane faria wei. ");
INSERT INTO aby_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Eno weiro Yesuma wei, ania weike nono wei, i miye awoena Nanu waiya ukeka mi we mune odineba anifekuke imusu orou eme keuwere emenu dai yawokeka orouini Isaraera oroubairo Nanu wake we enereifeku wei. ");
INSERT INTO aby_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yesuma eno weike wei, dawae Nanu amara ibake emema dawabake meramawere uke yafeisaya wei. Ibai dawabairo we ma iwoka umauro naufekua wei, Yesuma eno weiro, Ananaiyasima nauike idua ani. ");
INSERT INTO aby_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anike i Diudiasinu uwara ubarenaro amuike danu wana Soronu iiri duboro odaada eno wei, kaka Soro, i Dai Mi Yesu, ama aareibiro daabaro fou uri Mima na we odaisinuro fanea wei. Eno weike nono wei, anu naisa ere dakeka me sifekuba Godinu Imumu Irau anu imuka ubarenaro isafine fanea wei. ");
INSERT INTO aby_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","19","Eno weiro adua abunu kekei ari i rabuma Soronu naisa dadau uke ibi ifuru idua isariro ere karana ui. Ere karana uiro dawa babadaido uisaro uruna ike buna muni. ");
INSERT INTO aby_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Soroma Damasikasi goiro Godinu wake naukeibisa oroubairo ibaada Godinu wake i Du orounu sosi sosiro anike eno wei, Yesu, Dawae Godinu amaraya wei. ");
INSERT INTO aby_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Eno weiro i wake nauisake eno weisa, yewa miye i Derusaremu goiro Godinu wake naukaisa orou emenu wana mune ane derena enaro naama uwafiake waure ane i dai ofereni ode sibore sianeka oroubairo mafiane farinua weisa. ");
INSERT INTO aby_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eno weisaro Soro dawa iwoka daiwere ui ibake eno wei, Yesu Dawae Keriso. I Danu ubiye Godima iya ma wiromine we mune odi Miya wei. Soroma eno wei ibake i Du orouma wake moi we dauisa. ");
INSERT INTO aby_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Soro eno uke Godinu wake we eneiareibiro odo keuwere me siniro moi Du orouma Soro ma feafisane daaba yodia uisa. ");
INSERT INTO aby_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Eno ukeibisaro Soro dawa emenu imukeibisabai dawa iwoka ui. I Du dai orouma i uwaraini i dai oro aisameini daabaini Soro ma feafisane yawokenewaa uisake dawa koro ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Eno uisaro i Godinu wake naukeka orouma Soro dumuro mukake fokearo oisake naama uwakake dai oro duboroma ma bebekake odaisaro isarike ani. ");
INSERT INTO aby_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Soro iroma isarike Derusaremu goiro i Godinu wake naukeka oroubairo ibifine iro ani. Iro aniro Yesunu iwoka ukeka orouma Soro dawae Godinu wake naukeka mi meya eno weisake ia sirie. ");
INSERT INTO aby_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eno uisaro moi mi danu ibiye Banabasi i mima Soro munike i Godinu wake naukeka oroubairo waure anike ma iwoka ukaada eno wei, Yesuma yewa mibake Damasikasi goiro Yesunu wake bunawere weia wei. ");
INSERT INTO aby_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eno weike nono wei, Yesuma eno weiro Soroma i oroubairo ibaada Derusaremu goi orounu uwara uwararo amuke isare ukaada Godinu wake weibia eno wei. ");
INSERT INTO aby_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Eno weike Soroini i Guriki wake weibisa Du orouini wake wake we makaka. We makakake Soronu iwoka ukeka daiwere ibake i Guriki orouma dawa ma feafisane daaba yodia ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","I Godinu wake naukeka orouma i Guriki orounu imukeka iwoka uisake Soro mukake Sesaria goiro waure anisa. Iro waure anisake iroma Darasu goiro we odaisaro ania Banabasima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I furo Diudiaini Garerini Samariaini orofa buubaro ibeibisa Godinu wake naukebisa orou emua irauaiai ibeibisa. I furo eno uke irauaiai ibeibisaro emenu naukeka daiwere sini. I Godinu wake naukeka orouma Godi we ma irauaiai uisaro Godinu Imumu Irauma emua unu koreibi ibake eme keuwere Godinu wake kawama naukeibisa ibake i Godinu wake adinaroma naukeibisa oroubairo ane dakaa ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Moi furo Fidama i oroorofa yaisina iro eneiareibi. Iro eneiareibike Rida goiro ibeibisa Godinu wake naukeibisa oroubairo awaawa ufiane isare aari. ");
INSERT INTO aby_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Isare aare farike moi ani enare fare me mi eri. I miye oya eida (8) enare fare mero wearo mane aine ibeibi. ");
INSERT INTO aby_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fidama i mi erike eno wei, Enasi, Yesu Kerisoma a ma wiroyainua uyaake anu wea mua wei. Eno weiro idua uyari. ");
INSERT INTO aby_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Fidama eno weiro i Ridaini Seroni mado goiro ibeibisa orouma i wiroi mi ekake emenu imuka yaisina Godibairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I furo moi Godinu wake naukeibi wabu aweka danu ibiye Dabida (danu Guriki ibiye Dokasi) dawa Dafa goiro ibeibike irauaiai ukeibi. Irauaiai ukeibike i eraerabusa me oroubairo uruna naka naka ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eno ukeebe arama uike feari. Feariro i orou emenu bisara uisake danu ofe bou mukake aduama uroisake uwara dubo dei ooruro oisa. Eno uke oisake moi naukeka orouma Fidae Rida goiro ibinua weisaro nauisake eme una raarayai we odairiekaro anisi. ");
INSERT INTO aby_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iro aneibisa daabae yafa me funaku. Ibake Dafa goiroma Rida goiro ane fakike Fidabairo eno weisi, iyanu goiro sabu aara weisi. ");
INSERT INTO aby_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eno weisiro Fidaini nono kowede owekake aaka. Ane fakake moi orouini Fidaini emuama i aweka oisaro ibi ooruro amuisa. Amuisake Fidama eribaie i wabu awekaboma enare ibaada ii weada Dabidanu wau yanake yaiseka eraerabusa Fida ma iwoka uisa. ");
INSERT INTO aby_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fidama i orou yaisina weiro aweawero isaka. Isakaro Fidama ifoma kodudu yanaike guriguri ukaada eno wei, Dabida, uyaa wei. Uyaa weiro naisa foraike Fida erike uyare yauri. ");
INSERT INTO aby_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Uyare yauriro Fidama nono danu wanaro mamike ma uyare enariro i Godinu wake naukeka orouini i wabu awekaboini u weike ma enariro i wabu aweka me irauaiai uyare enare ibiro eka. ");
INSERT INTO aby_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I Dafa goi orou i uibai nauisake emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fidama Saimoni moi abu ofe faureka minu uwararo ibeibi. Fidama eno uike Dafa goiro odo keuwere iro ibeibi. ");
INSERT INTO aby_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Koniriasi dawae Sesaria goiro ibeibiroma nono dawae Du mi me, dawae imusu Romani goi mi. Enoba i goiro ame kafudenie dawa. Danu meremere oroue Idari weibisa orou. ");
INSERT INTO aby_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Enoroma nono Koniriasi dawae irau mi. Dawaini danu koaini emua yaisina Godibake iifa ukaada Godibairo guriguri ukeibisa. Aine wai ure i erabusa mero me ibeibisa Du oroubake urunaini wea wau makeibiriekake Godibairo guriguri ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","4","Eno ukeebe moi odoro dumudumu siniro Koniriasi danu uwararo nauka aine ibe mero yaure ibaada kubekube eri. Kubekube eribaie aneruma dawabairo farike eno wei, Koniriasi. Eno weiro ia daiwere sinaada iroma eno wei, a ainadeiro wei. Eno weike nono wei, anemebake farinu wei? Koniriasima eno weiro, i aneruma ma owerike eno wei, Godima anu guriguri ukekaini irau ukeka yaisina erinuke dawa irau miya wenuke na we odainararo fanea wei. ");
INSERT INTO aby_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eno weike nono wei, eweira moi orou we odaiaro Dafa goiro Saimonibairo anifisa weike ba nono wei, i mi danu moi ibiye Fida, dawabairo anifisake dawa we erakure aafisa wei. ");
INSERT INTO aby_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Fida dawae i uwara ubi mi Saimoni, abu ofe fauraku mi danu uwararo ibinua wei, i uwarae dawara udiroya weike i anerue idua ani. ");
INSERT INTO aby_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Anerue idua Koniriasi medike ani. Aniro Koniriasi uyarike danu waiya ukeka miyaini danu ame moi una dawa Godinu wake naukeibi mini emua weiro fakaro i aneruma wei wake yariero nauisaro nono Dafa goiro we odairiero anisa. ");
INSERT INTO aby_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aneebe daabaro aisa. Aisake wai uriro uyakake anisa. Aneebe eweka okoro muniro Fidama moi uwara fafada fou duboro guriguri ufine amuke ani. ");
INSERT INTO aby_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Amuke anike guriguri ukeebe desini uriro uruna ifine wei. Desini uriro weiro uruna oukeibisabaie aine ibaada kubekuberoma eno eri. ");
INSERT INTO aby_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Eribaie ure eba ui. Ure eba uiro eribaie wauini abanaro ooru ubu uke odiro isare aari. Isare aariro Fidama abu imusu imusu i ooruro eri. ");
INSERT INTO aby_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","13","Boroini waraini uuyeini karirini gasiraini waruini yaisina i ooruro eriro Godima eno wei, Fida, uyake i abu uyanake ia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eno weiro Fidama ma owerike eno wei, Babae Godi, i abue Du orounu ise dakaisa abu. I abue inoba ibake da imaua wei. ");
INSERT INTO aby_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eno weiro Godima wei, i abu yaisina we ma irauaiai unede nono anemebake i abue inowereya weaku weike nono weiro i ooru amuke ani. ");
INSERT INTO aby_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","I abu ibisa i wau bobo nono weiro isare aarike nono amuke ani. Dei buuba eno isare aare amuke ane eno ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Eno ukeibiro Fidama ma nuna ukaada idua yaure ibi. Yaure ibibaie i eme una buuba idua fakake eno weisa, Saimoni Fida ewado yaure ibinuba me eno weisa? ");
INSERT INTO aby_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Eno weisaro Fida danu i ui ibai erike imukeibibaie Godinu Imumu Irauma dawabake eno wei, Na we odaie eme una buuba idua farisaya uyaake isare ane faaro emuaini demuiro aniawe wei. ");
INSERT INTO aby_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Godinu Imumu Irauma eno weiro Fida idua uyarike isare ane farike eno wei, yanu yodia ukaisa mi na ewadoya anemebake farisa wei? ");
INSERT INTO aby_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Fidama eno weiro, emuama ma owerike eno weisa, iyanu ame kafudeni Koniriasima a we waure ane fafero anu wefa wake naufine wenu ibake farisia weisa. Eno weisake nono weisa, Godinu aneruma Koniriasibairo wei ibake we odainiro abairo farisia weisa. Eno weisake nono weisa, iyanu ame kafudeni mi dawae irau miya weisake weisa, dawae aine wai ure Godibairo guriguri ukeibakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I Du moi orouma Koniriasi dawae irau miya eno we imukeibaisaya weisaro i wake Fidama nauike weiro i faka eme una buuba idua aisa. Aisake wai uriro nono owekake Koniriasibairo Fidaini demuiro owere anisa. I eme una buubaini Fidaini i Dafa goi moi orou emuaini demuiro anisa. ");
INSERT INTO aby_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aneebe daaba abanaro aisa. Aisake wai uriro nono uyakake anisa. Emua daabaro aneibisaro Koniriasima emua koro ukaada danu koaini danu naiyemukuini emua weiro danu uwararo faka. Emua danu uwararo fare siane ibisaro Fidaini danu we odairie orouini Dafa goi moi orou emuaini Sesaria goiro idua faka. ");
INSERT INTO aby_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Idua fakaro Koniriasima Fidanu ibooro ibo yanaike Fidanu umu udiro ifoma kodudu yanaike bokai ukafu ui. ");
INSERT INTO aby_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bokai ukafu uibaie Fidama Koniriasinu wanaro mamike ma uyarada eno wei, na Godi meya eno da uake uyaa wei. ");
INSERT INTO aby_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eno weiro sabu uwara ubarenaro waure ane amuiro eribaie eme keuwere yaure ibisa. ");
INSERT INTO aby_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eme keuwere yaure ibisaro erieke Fidama eno wei, Du orouini imusu orouini demuiro awaawa ukekabaie iifa daiwere ibake eno uke dakaisia Fidama eno wei. Eno weike ba nono wei, enobairoma nono Godima ariena nabairo eno wei, awoenae iifa meya wei. Eme yaisina emua demuiya weiro naue ibake fanea wei. ");
INSERT INTO aby_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Eno weike Fidama nono wei, anu we odairie orouma fakake nabairo weisaro naueke aanea wei. Anemebake weiro na waure aaneka wei? ");
INSERT INTO aby_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","32","Fidama eno weiro Koniriasima ma owerike eno wei, moi odo dumudumunaku nama guriguri uero aneruma isare aarike eno wei, Koniriasi, Godima anu guriguri ukekaini anu emebairo irau ukaku ibai yaisina imukaku ibake moi orou we odaiaro Saimoni Fidabairo anifisake dawa we waure abairo aafisa weia wei. Eno weike nono wei, Fidae Saimoni abu ofe faureka minu dawara udi uwararo ibinua aneruma eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eno wei ibake nama wero a waure aanekaya eno wei. Koniriasima eno weike nono wei, awoena Godima iya erakuniro yaure ibinisi iro Godima abairo weaku wake wearo naufe Koniriasima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Fidama eno wei, Godima eme yaisina iya demuiya weaku ibake na iwoka sinakunea wei. Eno weike nono wei, Godima i Du orouini imusu orouini imusu imusua eno imuke dakakuke iya yaisina demui oroua eno imukakua wei. ");
INSERT INTO aby_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Eno weike nono wei, aina mima Godi ia sinaada Godinu ukeka ukakuie Godima i mi irau miya imukakua wei. ");
INSERT INTO aby_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Eno weike nono wei, Godinu ararae Yesu Keriso Danu irau wake Isaraera oroubairo wefiro naufisake emenu imuka irauaiai ufiane ibake Yesu Keriso we odairo faria wei. Eno weike wei, Yesu Kerisoe eme yaisinanu Dai Waria Miya wei. ");
INSERT INTO aby_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eno weike ba nono Fidama eno wei, ya iwoka sinaisa Diudia ororofaro Yesunu wake iro we eneiareibi wei. Weike eno wei, Dioni babadaido mi dawa danu wake dawako enaada we eneiareibiro nono Yesue Gareri goiroma Diuda orofaro dubenaro enaada we eneiareibia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Eno weike wei, ya iwoka wei, Godima i Nasaredi Mi Yesubairo Danu Imumu Irau mai ibake Yesu Dawa irau ukekaini weekaini ukeibike seidaninu merama imumu we berakeibiro aneibisaya eno wei. I danu ubiye Godima Dawabairo ibeibi ibake eno ukeibia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Danu Diudia orofa goi goiro ukekaini Danu Derusaremu goiro ukeibi ibai iyanu naisama yaisina ereibisia wei. Eno weike wei, i yaisina ekiro Du orouma korosiro ikokoma ukaro fearia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Feariro odo buuba me siniro Godima Dawa nono ma uyaria wei. Ma uyariro Yesu fearike nono uyarike moi oroubairo fari. ");
INSERT INTO aby_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Eme yaisinabairo fare dauia wei, Godinu wake naukeibisake mune awararo odeibisi oroubairo mane fariro ekia wei. Ekike Dawaini uruna demuiro isia wei. ");
INSERT INTO aby_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","43","Eno weike nono wei, Yesuma iyabake eno wei, aniaweke eme yaisinabairo eno weawe weia wei, i fearaisa orouini feare me orouini emua yaisina Nabairo kodo ufeisa eno weawe weia wei. Nae Godinu we mune odi mi ibake i eme yaisina nama kodo umiau eno weia wei. I we bou urieka orou yaisina Yesubake eno weisa Yesu Kerisoma eme yaisinabake korosiro feariba aina ainama Yesu imukenewaa ufeisaie Godima emenu merama ukeka mufekuke imuke medifekua i we bou uisa orouma eno weisaya Fidama eno wei. ");
INSERT INTO aby_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fidama eno weibibaie Godinu Imumu Irauma i wake naukeibisa orounu imuka ubarenaro isari. ");
INSERT INTO aby_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Isariro Fidaini i Godinu wake naukeibisa Du orouini emuama ibai ekake emenu imuka foria daiwere uisa. Godinu Imumu Irauma i Du me imusu orounu imuka ubarenaro isari ibake emenu imuka foria uisa. ");
INSERT INTO aby_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Godinu Imumu Irauma emuabairo isari ibake emenu wake imusu imusu weisake Godi we ma irauaiai ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Eno uisaro Fidama erike eno wei, Godinu Imumu Irauma iyabairo isare aari enaenari emuabairo isarinuba emua babadaido ufene weakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eno weike weiro i orou we muriekake Yesunu ibiro babadaido urieka. Babadaido uriekaro Koniriasima we kuuriro Fidaini danu orouini emuabairo moi odo odo iro emuaini demuiro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","I imusu orouma Godinu wake naukaisaya weisaro i afasoro orouini Diudia orofaro Godinu wake naukeibisa orouini emuama i wake nauisa. ");
INSERT INTO aby_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Fidama Derusaremu goiro owere aare fari. Aare fariro moi Du Godinu wake naukeibisa orouma dawabake dino wakeroma eno weisa, i ofe kuure me orouini anemebake awaawa ukaku weisa? ");
INSERT INTO aby_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Eno weisaro Fidama ma owerike eno wei, adinaro Dafa goiro ui ibai yaisina emuabairo yaakai eno wei, adinaro Dafa goiro guriguri ueke yaure ibaada kubekuberoma erebaie wau daiwere ureroma nabairo isare aaria wei. ");
INSERT INTO aby_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","7","Isare aariro i wau ooruro boroini waraini uuyeini karirini gasiraini waruini i abu yaisina i wau ooruro ereibisarabaie ureroma wake isare aarike eno wei, Fida, uyaake i abu uake ia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","9","Eno weiro nama eno weya wei, Babae Godi, ie Du orounu ise dakaisa eraerabusaba da imaua wero ureroma wake isare aari nono weia wei, i wake eno weia wei, Na Godima i eraerabusa ma irauaiai unea i eraerabusae meramawere eno da wea weia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eno weiro i abu ibisa wauwere dei buuba nono nono isare amuke ane eno uia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Eno ukeibiro eraada ibisarabaie eme una buuba Sesaria goiroma Dafa goiro na we erakufokone fakaya wei. ");
INSERT INTO aby_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fakaro Godinu Imumu Irauma nabake eno weia wei, i imusu oroubake da imuake i farisa orouini ania weia wei. Eno weiro yewa orou sikisini (6) naini demuiro anisia wei. Anisike i minu uwararo amuisia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amuisiro i mima eno weia wei, aneruma nabairo farike eno weia wei, anu moi orou wearo anifisake Dafa goiro ibinu mi Saimoni danu moi ibiye Fida we erakufisake aafisa eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Fidama aafekuke Godinu wake wefekuro naufoisake wirofoisaya weia wei. ");
INSERT INTO aby_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","I mima eno wei ibake anisike wake wemane ukeibisarabaie Godinu Imumu Irauma emuabairo isaria wei. Adinaro iyabairo isari enaenari dubuenaro emuabairo isaria wei. ");
INSERT INTO aby_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eno uiro Yesunu wei wake enaenari imuea wei, Yesuma adinaro eno weia wei, Dionima ba aduama babadaido ui. Nono dubuenaro iyanu Imumu Irauma babadaido ufeku eno wei ibai imuea wei. ");
INSERT INTO aby_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Danu Imumu Irau iyabairo mai. Enaenari i imusu orouma Yesu imuisaro ibake Danu me makeka mariea wei. Eno weike nono wei, na daiwere meba Godinu me makeka daaba dadau da umaua wei. ");
INSERT INTO aby_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Fidama eno weiro nauisake Godi we ma irauaiai ukaada eno weisa, i imusu orouma Godibairo fakaro Godima emua ma wiromirieke me ibene ibene ibeka mariea weisa. Enoba i imusu orou emenu arara Godibairo fafisane wefeisaie fafeisaya i afasoro orouma eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sidiwini feari i furoma moi orouma uyakake i Godinu wake naukeibisa orou meramawere uke yareibirieka. Eno uke yareibirieka ibake Godinu wake naukeibisa orouma uyakake imusu oroorofaro anisa. Moi orou Fonisia orofaro anisa. Nono moi orou Saifurasi orofaro anisa. Nono moi orou Anidiyoka goiro anisa. I anisa iroe i Du orou emuabairo mane Godinu Irau wakeini Yesunu wakeini eno weibisa. ");
INSERT INTO aby_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eno uisaro nono moi Godinu wake naukeka orou Saifurasini Sairina weaisa orofayairoma Godinu wake i imusu oroubairo wefisaro naufisane ibake Anidiyoka goiro anisa. ");
INSERT INTO aby_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Anidiyoka goiro anisaro Yesu Danu buna mariero Godinu irau wake weisaro eme keuwere nauisake Yesunu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I wake Derusaremu goiro ibeibisa afasoro orouini Godinu wake naukeibisa orouini emuama nauisake Banabasi we odaisaro Anidiyoka goiro ani. ");
INSERT INTO aby_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Anike ane Anidiyoka goiro ane farike Godinu wake naukada irau ukeibisa ibai erike rooro daiwere ukaada i Du me imusu orouma Godinu wake naukeibisa i oroubake eno wei, yanu imukeka yaisina Yesubairo maeweke Yesunu umuro eneiareibiawe wei. ");
INSERT INTO aby_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi dawae irauaiai miba Godinu Imumu Irau dawabairo ibenewaa ukeibi ibake danu naukekae daiwere. Enoba dawama weiro eme keuwere nauisake Yesunu umuro anisa. ");
INSERT INTO aby_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabasima Anidiyoka goi medike Darasu goiro Soro yodia ani. ");
INSERT INTO aby_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ane farike Soro we erakurike owere Anidiyoka goiro we waure fari. Anidiyoka goiro Godinu wake naukeibisa oroubairo oya demui ibaada eme keuwere Godinu wake we ma iwoka ukeibirieka. I furo Anidiyoka goi orou emuako i Godinu wake naukeibisa oroubake kurisidini oroua weisa. ");
INSERT INTO aby_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Enoba i furo moi Godinu we bou urie orouma Derusaremu goiroma Anidiyoka goiro anisa. ");
INSERT INTO aby_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anisake moi Godinu we bou ukeka mi, danu ibiye Agabasi, dawa Godinu Imumu Irau dawabairo ibenewaa ukeibiba ibake uyarike eno wei, yewa orofa akaka orou yaisina arumu daiwere yaufoisaya eno wei. (Danu wei wake i dai mi Korodiasinu yawokeibi furo arumu daiwere enaenari yauka.) ");
INSERT INTO aby_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","I wake Agabasima eno weiro i Godinu wake naukeibisa orou yaisinama eno weisa, iya yaisina oi demuiro odifeisike iyanu Diudia orofa ibaada Godinu wake naukaisa oroubairo mafiakikia weisa. ");
INSERT INTO aby_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Eno weisake i oi Banabasini Sorobairo mariekaro emuama mukike i Diudia orofaro ibaada Godinu wake naukeibisa orounu dai yawokeka oroubairo ane marieki. ");
INSERT INTO aby_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","3","I furo i dai yawokeka mi Erodima moi Godinu wake naukeka orou meramawere uke yawokeibirie. Eno uike Dioninu kakae Deimisi warima yanairo feari. Eno uiro i Du orouma ibai ekake rooro daiwere uisa. Emua rooro daiwere uisa ibake Erodima Fida ana ebaro odifine ibake we yodia ui. (I furo i Du orou emenu Godima emua Idifiroma waure ani banau urunama iseibisa.) Ibake i odoro Erodima Fida ana ebaro odifine we yodia uke wei. ");
INSERT INTO aby_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Erodima weiro anisake Fidanu wanayai mune ane derena enaro uwane oisake mune ane ana ebaro oisa. Oisaro Erodima weiro danu meremere orou keuwere sikisidini (16) emuama Fida yawokeibisa. Fida ana ebaro ibiro Erodima eno we imui, Godima i Isaraera orounu Idifiroma waure aareka banau uruna ise me sifeisaro Fida i Du orounu ibooro waure ane odimauke ma feamaua eno we imui. Erodima eno we imukada ibiro Fida ana ebaro ibi. ");
INSERT INTO aby_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Fida ana ebaro ibi ibake Godinu wake naukeibisa orouma moi uwara ubarenaro fare ku siane ibaada Fidabake Godibairo guriguri ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erodima Fida wairo ana ebaroma mune ma feamaua eno we imui. I odo dumuro Fida senima umu wana uwane karisaro Fidama meremere miyai eka ena ewa ena emenu ubarero aine ibi. ");
INSERT INTO aby_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nono moi meremere miyai emua aisame udiro enare ibaada yawokeibisi. Eno uke oisaro aine ibiro Godinu aneruma i ana eba uwara ubarenaro faribaie edoro daiwere ui. Aneruma farike Fidanu manamaro fare urike wanaro munike ma uyarada uyaa wei. Eno weiro seni danu me woromike isari. ");
INSERT INTO aby_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Isariro aneruma eno wei, anu umu ofe odiake anu wau yua wei. Eno weiro enaenari uiro aneruma nono wei, anu dubo barukeka wau baruake nanu umuro aara wei. ");
INSERT INTO aby_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eno weike aniro Fida dawa anerunu wei enaenari danu umuro ani. Anaada Fidama dawa aneruma ukeibi ibai dawa iwoka me ibake ie ba o me ariya eno we imui. Danu imukeibie kube erakunea eno we imui. ");
INSERT INTO aby_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Aisame udiro yawokeibisi miyai enare ibisiro moi mi ma bereisike nono moi mi ma bereisi. Eno uisike aisame udiro fakibaie i ayanima uisa aisame danu me ninoke ro yari. Ro yariro aweawero anisi. Aweawero anisike daaba demuiro aneebe abanaroma aneru iduama me ari ui. ");
INSERT INTO aby_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Aneruma Fida medike aniro Fida idua imuke giena ui, i aneruma uibai yaisina eno uke iwoka uike eno wei, Godima Danu aneru we odaisinuro isare aarinuke Erodini Du orounu merama imukekaroma na mune aweawero odainaraya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","13","Eno weike Merinu uwararo ani. Meri dawae Dioni Makinu amae. I uwararo eme keuwere ku siane ibaada Fidabake guriguri ukeibisaie Fida idua farike aisamero goigoi ukaada yaure ibinisa weiro moi aruma danu ibiye Roda dawama aisame ko woromifine fari. ");
INSERT INTO aby_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Farike Fidanu wake nauke karana uike rooro ukaada i aisame ko worome dauike owerike i ku siane ibisa oroubairo durame ane fari. Iro ane farike eno wei, Fida farinuke uwara aisamero enare ibinua wei. ");
INSERT INTO aby_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","16","Eno weibaie a gogore boboba meo weakua eno weisa. Eno weisaro Rodama nono bebeku ara uike wei, na meo me, ba weakunea wei. Eno weiro emuama weisa, ie danu anerua weisa. Eno weibisabaie Fida dawa aisame udiro enare ibaada goigoi ukaada enare ibi. Eno ukeibi ibake ane aisame woromisake ekabaie Fida dawama enare ibaada ukeibi ibake i orou emenu imuka foria daiwere ukaada wake wake we makaneibisa. ");
INSERT INTO aby_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wake gorowere weibisa ibake Fidama wana ei mamike wake gorowere mediawe weiro meisa. Meisaro Fidama danu ana ebaro ibiro aneruma iro waure ane aweawero odi wake wei. Weike emuabake nono wei, Deimisini i Godinu wake naukaisa oroubairo yewa wake weawero naufisa weike emua idua medirieke moi orofaro ani. ");
INSERT INTO aby_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aniro wai uriro meremere orouma Fida me uyare ekake ibake Fida yodia ukaada wake gorowere weibisa. ");
INSERT INTO aby_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Enoba Erodima weiro danu orou Fida yodia ukeebe yodia ukeebe Fida fou ure dauisaro ana ebaro Fida yawokeibisa meremere orou kodo urie. Kodo urieke wei, i meremere orou yaisina uyakawero feafisa wei. Erodima eno weike Diudia orofa medike Sesaria goiro anike iro ibeibi. ");
INSERT INTO aby_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodima i Dairaini Saidoni goiyairo ibeibisa oroubake dino daiwere ui. Eno ui ibake i Dairaini Saidoni goiyai orouma eno we imuisa, Erodinu orofaro uruna muneibaisia we imuisa. Ibake Erodinu uwara yawokeka mi Barasusibairo fakake eno weisa, iyanu ararae Erodini wake we ma giena ufene farisia eno weisa. Eno weisaro Barasusima Erodibairo i weisa wake ane wei. Erodima i fafeisa odo namai we odiro i odoro dawabairo aare faka. ");
INSERT INTO aby_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","I odoro dawabairo aare fakaro Erodima danu kininu weree weree uike danu dai yaureka duboro yaure ibaada wake yafawere weibi. ");
INSERT INTO aby_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Eno weibiro nauisake daiwere eno weisa, danu wakeye emenu wake karana mero Godinu wake karana weakua weisa. ");
INSERT INTO aby_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Eno weibisaro na Godi meya mediawe we da uike emenu moko wefisa wake naufine ui ibake Godinu aneruma fanisi mairo okoa dudenanakuma Erodinu desini dura ise me sikaro Erodi idua feari. ");
INSERT INTO aby_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Godinu wake daiwere we eneiareibisa ibake eme keuwere naukeibisake ibai imukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasini Soro emua Godinu waiya uke me sikike Derusaremu goi meisike owere Anidiyoka goiro anisi. Anisike Dioni Maki we waure emuaini demuiro anisi. ");
INSERT INTO aby_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anidiyoka goiro moi Godinu wake naukeka orou iro ibeibisa. Ibeibisaro emuabairo Godinu we bou ukeka orouini sisa orou emuaini ibeibisa. Emenu ibiye Banabasini Simioni danu moi ibiye Naiga dawaini, Rusiasi dawae Sairina goi mi, dawaini Manaeni dawae Erodinu nabue, dawaini Soroini i orouma Anidiyoka goi orouini emuabairo ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ibake moi furo iro ibaada guriguri mane ukaada uruna ise dakeibisake kau uisaro Godinu Imumu Irauma emuabairo eno wei, Banabasini Soroini emua we mune odaiawero Nanu waiya ufisi wei. ");
INSERT INTO aby_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Eno weiro uruna ise mero guriguri mane ukaada emenu wana Soroini Banabasini emenu iiri duboro oisake emua we odairiekaro anisi. ");
INSERT INTO aby_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabasini Soroma iro anisiro Godinu Imumu Irauma emenu aneibisi daaba we seboiro anisi. Ane fakike boudiro amuisike moi ekara ena ewa ena dawara nono naisaroe Saifurasi weaisa dai orofaro anisi. ");
INSERT INTO aby_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Anisike i Saifurasi orofa Saramisa goiroko ane faki. Ane fakike i Du orounu sosiro Dioni Makini demuiro amuisa. Amuisake Godinu wake i oroubairo weibisa. ");
INSERT INTO aby_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Nono dubuenaro Saramisa goi meisake Saifurasi goi goiro yaisina Godinu wake we eneiareibisa. We eneebe Feifasu goiro ane faka. I goiro moi Du mi dawae wada barau bobo mi i goiro ibeibi. Dawae meo we ma ubireka mi. I minu ibiye Barayesu, dawae i goiro ibiro Soroini danu orou fakake i mi eka. I miye i Saifurasi weaisa orofa yawokeibi minu naiye. I yawokeibi mi danu ibiye Suragasi Forusi. I yawokeibi mima Soroini Banabasini emua Godinu wake wefisiro naufine emua weiro danu uwara ubarenaro amuisi. ");
INSERT INTO aby_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Godinu wake wefisine amuisiro nono i wada barau bobo mi, danu Guriki ibiye Iramasi, emenu wefisi wake daaba dadau ufine i orofa yawokeibi mibake dawama eno wei, emenu wefisisi wake da naua wei. ");
INSERT INTO aby_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Eno weiro Godinu Imumu Irauma Soroini ibenewaa ui ibake Soro danu moi ibiye Foru, dawama i wada barau bobo mi ereebe ere bauke faisa uike eno wei, ae seidaninu amaraya wei. Ae irau ukekabake wasai mi. Eno weike nono wei, anu imukekae irauaiai meya weike wei, anu imukekae we irukeka manea wei. Eno weike nono wei, Godinu Irau wake weeka daaba anemebake ma merama ufake dadau ufane ukaku wei? Eno weike wei, ibai media wei. ");
INSERT INTO aby_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eno weike Foruma i wada barau bobo mibake nono wei, nanu wake naua weike wei, Godima a awoena fanisi mamekuba moi odoro anu naisa kikori simekuro eweka edoro da efakua wei. Foruma eno weiro danu naisa dadau uiro moi mima danu wanaro mufike waure anifine yodia uke ani. ");
INSERT INTO aby_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I orofa yawokeibi mima i mi uibai erike Godinu buna weekaini ukeka ibake imuka foria daiwere uike Godinu wake nauke imuke ui. ");
INSERT INTO aby_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Foruini danu orouini emuama Feifasu goi meisake boudiro amuisake Famufiria orofaro anisa. Ane Fega goiro faka. Fakaro Dioni Makima i orou medirieke owerike Derusaremu goiro ani. ");
INSERT INTO aby_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Banabasini Foruini emua Fisidia orofa Anidiyoka goiro anisi. Ane fakike i furoe sabadi odo ibake i Du orounu sosiro emuaini amuisa. ");
INSERT INTO aby_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Amuisake yaukaro moi mima Mosesinu darawadu bukaini Godinu we bou ukeka bukaroma kakuri. Kakure me siniro i sosi yawokeibisa orouma, Foruini danu oroubake eno weisa, naiyemuku, yama yanu arararo unu koreka wake wefoisaie naufeisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Eno weisaro Foruma wana ei mamike eno wei, ya Isaraera orouini nono ya Godibake ia sinaisa imusu orouini nanu wake nauawe wei. ");
INSERT INTO aby_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Isaraera orounu Godima yanu sisia sirorari orou emua Idifi orofaro we mune odiriero ibeibisa ibake emuae bunama imusu ari orou sine ibeibisa. Sine ibeibisaro nono iroma Godi Danu buna wanama emua waure aniriea wei. ");
INSERT INTO aby_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","19","Waure anirieke eme ibe me orofaro odirieke oya fodi (40) emua yawokeibirie. Iro ibeebe nono Godima i Isaraera orou unu koreibiriero moi Keinani orofa goi goiro orouini uraneibisa. Eno ukeebe i orofa goi seweni (7) ure me siriekaro Keinani orofa yanu sisia sirorari oroubairo mariea eno wei. Mariero oya keuwere fo aderedini fifidi (450) Keinani orofaro ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iro ibeibisaro Godima emuabairo kodo ureibeka orou odairiero ibeibisaro nono Samueronu odo idua fariro emenu we bou ukeka miye dawa emuabairo odirie. ");
INSERT INTO aby_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Godima we mune odiriero yanu sisia sirorari orouma Godibake eno weisa, iyanu ararae Kini mi iyabairo we mune odia weisa. Eno weibisa ibake Godima Kisanu amara Soro dawae Bedimaninu sisia sirorari mi, emuabairo marie. Emuabairo mariero Soroma oya fodi (40) emua yawokeibirie. ");
INSERT INTO aby_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yawokeibiriero oya fodi (40) me siniro Godima dawa medike Deiwidi we munike emenu kini mi we odi. We odike eno wei, yewa mi Desinu amarae Nanu arara miya wei. Dawae Nanu wemau wake yaisina naufekua Godima eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Foruma eno weike nono wei, Godima we bou uike Deiwidinu sisia mi Yesu, we munike Isaraera orounu ma wirokeka mi we odia Foruma eno wei. ");
INSERT INTO aby_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Foruma eno weike nono wei, Dioni dawako fari. Farike Isaraera oroubake eno wei, yanu merama merama ukeka imuke mediaweke babadaido uawe Dionima eno weia Fidama wei. ");
INSERT INTO aby_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Fidama eno weike ba nono wei, Dioni dawa eno weiro danu ibaada ukeibi waiya i furo me sifine uiro Dionima nono wei, na aina imukaisa wei? Eno weike wei, yanu yawokaisa miye na meya eno weia wei. Moi mima nanu umuro aafekua wei. Dawae Dai miwere. Nono nae dai mi meba Danu iboo da enare kuumaua Dionima eno weia Foruma i wake emuabairo eno wei. ");
INSERT INTO aby_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Foruma wei, nanu kaka nabue, ya Eibaramunu sisia sirorari orouini ya Godibake imukaisa imusu orouini nanu wake nauawe wei, Godima yewa ya ma wirokeka wake we odaisinuro aarinua wei. ");
INSERT INTO aby_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Foruma eno wei, i Derusaremu goiro ibeibisa orouini emenu dai orouini emuama Yesu ukaro ba fearia wei. Foruma eno weike nono wei, i orou emua Dawa iwoka me enoba Dawa ukaro fearia wei. Godinu we bou ukeka orounu wake sabadi odoro aine wai ure kakureibisaro naukeibisake nono imuke dakeibisa. Eno ukeibisa ibake i we bou ukeibisa orounu wake ba sini. ");
INSERT INTO aby_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Foruma eno weike nono wei, i Derusaremu goi moi orouma Yesunu ukeka sineka moinaku merama fou ure da uisakema Faeradibairo anisake weisaro ibake Dawa ukaro fearia wei. ");
INSERT INTO aby_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Feariro i orouma i we bou ukeka orounu Yesu feafine wake weisa enaenari eno uisa. Enaenari uisaro Yesu feariro korosiroma Danu ofe bou mukake oma erabo eme odeka orofaro oisa. ");
INSERT INTO aby_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","Eno uisaro nono Godima Dawa ma uyariro awoena ibinua wei. Foruma eno weike nono wei, Yesu fearike nono uyarike eneiareibiro Danu Gareri goiroma Derusaremu goiro Danu umuro eneiareibisa orou emuama Dawa ereibisaya wei. Ereibisa ibake nono awoena i ere dauisa oroubairo Danu ukeibi sineibi ibai yaisina weaisaro naukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Foruma nono eno wei, Godima yanu sisia sirorari oroubairo Danu irau we bou ukeka orou mariero nono awoenae uwama yabairo i irau wake weaisua wei. Eno weike nono wei, Godima Yesu ma uyarike nono awoena Danu we bou ukeibi enaenari yabairo idua ukinua wei. Eno weike wei, i Samusi bukaro yewa wake eno ibinua wei, Ae Nanu Amara, Anu Babaeye Naya, i wake eno ibinua wei. ");
INSERT INTO aby_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Foruma eno weike nono wei, Godima Yesu ma uyarike eno wei, Danu ofe da yaufekua weia wei. Foruma eno weike nono wei, i Samusi bukaro i wake eno ibinua wei, Abake we ma irauaiai umauanea Deiwidibairo eno we bou ueba ibake Abairo enaenari umaua Godima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","I Samusi bukaro yewa moi wake eno ibinu, Ama wei ibake Anu iifa Amaranu ofe da yaufekua, I wake i Samusi bukaro eno ibinua Foruma eno wei. ");
INSERT INTO aby_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Foruma eno weike nono wei, yewa wakeye Deiwidinu wake me, yewa wei wakeye Yesunu wei wake. Ibake Deiwidima Godinu waiya danu oroubairo uike fearia wei. Feariro danu sisia sirorari oroubairo ane ooru uisaro danu ofe yauria wei. ");
INSERT INTO aby_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Eno weike nono wei, adinaro Godima ma uyari Minu ofeye yaure da uia wei. ");
INSERT INTO aby_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nanu wake nauawe, i Mi mane yanu merama merama ukeka ma isufekua wei. Ibake aina ainama Dawa imukaisaie Dawa mane emenu merama merama ukaisa ibai ma isurakuro Godima emuae irau oroua eno weakua wei. Eno weike nono wei, Mosesinu darawaduma merama ma isure dakakua wei. ");
INSERT INTO aby_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Eno weike wei, eforo, i Godinu wake we bou ukeibisa orounu wake yabairo fafekuba me ari? Emenu weisa wakeye eno weisa, Ya Godibairo merama wake weaisa orou eno imufoisake feafoisa. Nanu unu koreka waiya yabairo ukakuneroma nono moi mima Nanu ukakune i waiya we ma boroo yafiakuroma nono ya iwoka da ufoisa, i we bou ukeka orouma eno weisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Foruma danu wake eno weiro dawaini Banabasini emuama aweawero anisi. Anisiro i orouma eno weisa, yeka moi sabadi odoro nono yanu wake weawaro iya naufe weisa. ");
INSERT INTO aby_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","I orou yaisina fiake anisaro moi Du orouini moi Godibake imukeibisa imusu orouini emuama Foruini Banabasini emenu umuro anisa. Anisaro Foruini Banabasima eno weisi, Godima ya we ma irauaiai ukinuke unu koneba Danu daabaro enarenewaa uforo weisi. ");
INSERT INTO aby_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Moi sabadi odoro i Anidiyoka goi orouma Godinu wake naufisane anisa. Anisaro eme keu menaku ane mero goiro ibisa. ");
INSERT INTO aby_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nono eme keuwere anisaro moi Du orouma eme keuwere eriekake emua arara me ibake dino wake weisake Forunu we ma iwoka ukekaini weekaini meoya eno weisake i miyai emua merama miyaiya eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Eno weisaro Foruini Banabasima ia sine dauisike eno weisi, Godima Danu arara i wake yabairoko wefune wenuro ibake yabairo aarisua weisi. Eno weisike nono weisi, awoenae Godinu wake yama mune sianaisake yanu imusu kodo uraisaie Godinu me ibene ibene ibeka da mufoisaya eno weisi. Eno weisike nono weisi, ya eno ukaisaba Godinu irau wake i Du me imusu oroubairo ane wefukua weisi. ");
INSERT INTO aby_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Godima Danu bukaro yabake eno wei, Du me imusu orounu edoroe ya. Ibake i orofa akaka imusu orou yaisinabairo anifoke weforo naufeisake emuama i me ibene ibene ibeka mufeisa, eno weia wei. ");
INSERT INTO aby_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Foruma eno weiro i Du me imusu orou i weibai nauisake rooro daiwere ukaada Godi we ma irauaiai uisa. Eno uisake Godima we mune odirie eme keuwere Godi imuisa. ");
INSERT INTO aby_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Imuisake Godinu wake aboro aboro enaada we eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","I Du orou emua arara me ibake koroko wake weisaro moi adina ba ofe sirie awekaboini emeakaini emuama i Du orounu koroko wake weisa ibai nauisake emuaini moi goi orouma Foruini Banabasi yoweriekaro anisi. ");
INSERT INTO aby_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Anaada emenu umuro doo ma isukiro i Du orouma eno weisa, i miyaima iya meisike anaisia weisa. Eno weisaro Foruini Banabasi Anidiyoka goi meisiki Aikoniamu goiro anisi. ");
INSERT INTO aby_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Godinu Imumu Irauma i Anidiyoka goiro ibisa Danu iwoka ukeka oroubairo ibenewaa uiro emua rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Foruini Banabasini emuama Aikoniamu goiro ane fakike Du orounu sosiro amuisike Godinu wake bunawereroma weisi. Bunawereroma weisiro moi Du orouini Du me imusu orouini emuama i wake nauisake emenu imuka yaisina Godibairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Eno uisaro Godinu wake nauke me Du orouma emuaini dino wake weisaro i imusu orouma ibai nauisake i Godinu wake naukeibisa orou ufiakane ararua uyaka. ");
INSERT INTO aby_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Eno uisaro Foruini Banabasini emuama iro odo keuwere ibaada Yesunu irau unu koreka wake weibisi. Weibisiro Yesuma emua erieke emuabairo buna ukekaini ereka marie enaenari uisi. ");
INSERT INTO aby_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I Aikoniamu goi orou emua emenu imuka demui daabaro ode dauisa. Ibake moi orou emuama i Du orounu wake nauisa. Nono moi orouma i afasoro orounu wake nauisa. ");
INSERT INTO aby_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","I imusu orouini Du orouini emua yawokeibisa orouini emuama i afasoro orou omama ufiakane weisaro Foruini Banabasini emuama ibai nauisi. ");
INSERT INTO aby_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Nauisike i goi sabu meisike Raikonia orofa Risidaini Debe goiyairo emua iro anisi. Iro anisike i goiyaini i orofa goi goi iro anisike Yesunu wake weada eneiareibisi. ");
INSERT INTO aby_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Moi Risida goi mi danu umu daba mamiro enare fare me. Dawa danu amaema dori arima enare fare mero uwararo mane ibeibi. ");
INSERT INTO aby_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Foruini Banabasini emua fakiro i mima Forunu wake nauiro Foruma i mi erenewaa ukaada i mi dawa wirofine imukakua eno we imuike daiwereroma eno wei, anu umuma uyare enaa wei. Eno weibaie i mi idua sabu uyarike enari. ");
INSERT INTO aby_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eno uiro i ku siane ibisa orouma ibai ekake emenu Raikonia wakeroma eno weisa, moi godi ba eme ari iyabairo farisaya eawe weisa. ");
INSERT INTO aby_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eno weisake emenu godi danu ibiye Dufada, danu ibiye Banabasinu moi ibi mamisa. Nono Foru dawae wake weeka mi ibake danu moi ibiye Makari mamisa. ");
INSERT INTO aby_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","I godi Dufada danu uwara i goi barunaro enare ibi. I Dufadanu uwararo ofereni odeka miye segina segina uike boromakau unama ofereni odifine uwara aisamero waure fari. ");
INSERT INTO aby_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Waure fariro Foruini Banabasini emuama i wake nauisike imukada emenu wau ma gagane budebade uisike i oroubairo ane fakike eno weisi, anemebake eno ukaisa weisi? Eno weisike eno weisi, uwae godi mero uwae ba eme, ya ari enoya weisi. Irau wake wefune yabairo farisua weisi. I irau wakeye eno, i ba me godie mediaweke oweaweke i me ibene ibene ibeka Godibairo yanu imuka yaisina iro odiawe weisi. Eno weisike nono weisi, i ba Godima ureini dooini dawaraini eraerabusa yaisina ubu uia dawa mane imuawe weisi. ");
INSERT INTO aby_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Adinami nauwaroma emema emenu arara aneme aneme ukeibisa weisi. Eno ukeibisaro Godima emenu sara merama ukeibisabai eraada me yawokeibiriea weisi. ");
INSERT INTO aby_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Eraada yawokebe Dawa dino uke dauike emuabairo obi ureroma we odaiseibiro isareibia weisi. Obi isareibiro emenu uruna daiwere warakeibisaro rooro uekibisaya weisi. Eno weisike nono weisi, Godima eno ukeibike awoena enaenari ukaku ibake Danu mane eno uke ma boroo yarakuba Dawae ba Godi iwoka sinaisia weisi. ");
INSERT INTO aby_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Eno weebe weebe meisiro i orouma emuabake ofereni odifisane ukeibisabai idua meisa. ");
INSERT INTO aby_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Eno ukeibisiro moi Du orouma Anidiyokaini Aikoniamu goiyairoma Risida goi oroubairo fakake Foruini Banabasibake meo wayai wake emuabairo weisa. Eno weisake meomao wayai wake weibisaro Risida goi orouma i miyaibairo ararua sirieke oma mukake Foru siane uka. Siane ukaro dooro biruike ane isari. Biruike ane isariro wanaro ma youre ane goi barunaro oisa. Eno uisake dawa fearinua we imuisake ibake meisake anisa. ");
INSERT INTO aby_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Meisake anisaro Yesunu umuro eneiareibisa orouma Foru enare kara uisaro Foru uyarike goiro owere ani. Owere ane ainike wai uriro uyarike iroma Banabasini Debe goiro ane faki. ");
INSERT INTO aby_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","22","Foruini Banabasini emuama i Debe goi oroubairo Godinu irau wake weisiro eme keuwere nauisake emenu imuka yaisina Godibairo oisa. Nono dubuenaro Debe goi meisike owekike Risida goini Aikoniamu goini Anidiyoka goiro Godinu wake naukeibisa oroubairo anisike Godinu wake eno weisi, Godibairo ibenewaa uawe weisi. Merama odo odo keuwere yabairo fafekuro enare ara ufoisaie dubuenaro Godinu yawokaku orofaro anifoisaya weisi. Eno weibisiro i Godinu wake naukeibisa orouma i wake nauisake buna daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ibake Foruini Banabasini emuama i sosi sosi yawokeka orou emuabairo we mune odiriekike guriguri ukaada eno weisi, Yesu, emua yawokenewaa uyana weisi. Eno weisike anisi. ");
INSERT INTO aby_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Anisike Fisidia orofa ma bereisike Famufiria orofaro ane faki. ");
INSERT INTO aby_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ane fafike i Fega goiro fakike Godinu wake weisike nono meisike iroma anisi. Ane Adaria goiro isare anisi. ");
INSERT INTO aby_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Anisike iro boudiro amuisike iroma i Siria orofa Anidiyoka goiro anisi. I Anidiyoka goiro adinaro Godima weiro i orouma Foruini Banabasini emua we mune oisake Godibairo emuabake guriguri uisaro anisike nono owere aare Anidiyoka goiro faki. ");
INSERT INTO aby_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Fakike weisiro i Godinu wake naukeibisa orou yaisina i miyai emuabairo ane faka. Ane fakaro emuama eno weisi, Godima i imusu orounu imuka ma owere muneba i imusu orouma emenu naukeka Godibairo odaisaya weisike Godima emuabairo ukeibi ibai yaisina weisi. ");
INSERT INTO aby_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Foruini Banabasini emuama Anidiyoka goiro i Godinu wake naukeibisa oroubairo odo keuwere emuaini ibeibisa. ");
INSERT INTO aby_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Foruini Banabasini emuama Anidiyoka goiro ibisiro moi Diudia orofa Du orouma i naukeka oroubairo fakake we ma iwoka ukaada eno weisa, i Du orounu ofe kuureka da ufoisaie nono Godima ya da ma wirofiakua eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Eno weisaro Foruini Banabasini emuama i wake nauisike bunawereroma eno weisi, i wakeye ba me meramawereya weisi. Eno weisibaie i Anidiyoka goiro Godinu wake naukeibisa orouma Foruini Banabasini moi orouini emua i wake Derusaremu goiro ibisa orouini sosi yawokeibisa Anidiyoka goiro Godinu wake naukeibisa orouini emuabairo i wake wefisane we odairieka. I goi arawekoroma we odairiekaro anisa. ");
INSERT INTO aby_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anisake Fonisia orofa goi goini Samaria orofa goi goiro Godinu wake ane eno weisa, Godima i imusu orou awoena ma wirokakunea weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Weisake aneebe Derusaremu goiro ane fakake i Godibairo guriguri ufisane fare ku siaka orouini afasoro orouini sosi yawokeibisa orouini emuabairo arie daiwere weisa. Eno weisake i orou yaisina sosiro fare ku siaka. Fare ku siakaro Foruini Banabasini nono emuaini eneibisa orouini Godima emuabairo ukeibi ibai yaisina weisaro emua nauisa. ");
INSERT INTO aby_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Eno weisaro moi Godinu wake naukeibisa Ferosi weaisa orouma uyakake eno weisa, I imusu orounu ofe kuufeisike Mosesinu darawadu yaisina uforo wefeisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","I afasoro orouini sosi yawokeibisa orouma i wake naufisake imufisane fare ku siaka. Fare ku siakake wake keuwere we makaka. ");
INSERT INTO aby_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","We makaneibisaro Fidama uyarike eno wei, naiyemuku, nanu wake nauawe wei. I adina furo Godima yabairoma na we mune odikara. Na we mune odikarake Godima eno weia wei. I imusu oroubairo Danu wake wemaro naufisake Dawa imufisane ibake na we mune odikaraya wei. ");
INSERT INTO aby_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Eno weike nono wei, Godi Dawae i imusu orounu imukeka Dawa iwoka ui ibake Danu Imumu Irau we odairo emuabairo isariba ibake emuaini iyaini iyama Godinu wake naukeka orou sikia wei. Iya Godinu Imumu Irau muki i ari eno emuae enaenari mukaya wei. ");
INSERT INTO aby_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Eno weike nono wei, Godima emuaini iyaini demuiro imuia wei. Eno weike wei, i orouma Godinu wake nauisake Godi imuisaro emenu merama merama ukeka mune imuke media eno wei. ");
INSERT INTO aby_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Godima eno uibairo nono anemebake ofe kuureka wake weaisa wei? Eno weike nono wei, ya eno weaisaie Godi we iruke eraada weaisaya wei. Eno weike wei, ya eno ukaisaie Godinu wake naukaisa orounu owairo inimu eraerabusa abiare odinao ukaisaya wei. Fidama eno weike nono wei, adinaro akaemukuini iyaini iyanu owairo inimu eraerabusa waure dakeibiside nono anemebake i oroubairo eno weaisa wei? ");
INSERT INTO aby_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Fidama eno weike wei, emenu wirokekaini iyanu wirokekaini imusu imusu mero demuiya wei. Eno weike nono wei, emuaini iyaini Godinu wake naufeisiie iyanu Dai Waria Mi Yesu Kerisoma irauaiai unu korakuniba ibake Godima iya ma wiromisia wei. ");
INSERT INTO aby_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fidama eno weiro i yaure ibisa orouma Fidanu wei wake nauisake wake moi we dauisa. Wake moi we dauisaro Godima Foruini Banabasibairo buna mariero emuama i imusu oroubairo buna ukeibisi wake weisiro nauisa. ");
INSERT INTO aby_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Emenu wake weisiro me siniro Deimisima uyarike eno wei, kaka nabue, nanu wake nauawe wei. ");
INSERT INTO aby_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Fidama eno wenua wei, Godima i imusu orou munakuneke ma wirokakunero nono Danu wake naukeka orou sinaisa wenuro naukisia Deimisima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","16","I wakeini i Godinu we bou urie orounu wakeini emuae demuiya wei. Weike wei, yewa dubo waure weeka wake Godima Danu bukaro eno wei, moi doroo yari uwara ma irauaiai ufekuro uyafeku i ari Deiwidinu doroo yari uwara nono ma enamauro uyafekuro danu ibini nono ma daiwere umaua wei. Eno uke uyafekuro Dai yawokeka Mi nono odimaua wei. ");
INSERT INTO aby_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Enoba eme yaisinaini Nanu we munakune imusu orouini yodia ufisake i Dai Minu umuro anifisane ibake eno umaua wei. ");
INSERT INTO aby_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Adinami nauwaro Godima i wake eno weia, I Godima we bou urie orouma eno weisaya Deimisima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Deimisima eno weike nono wei, nanu imukekae i ari enoya wei, i Yesunu umuro aneka imusu orounu irau ibeka ma ara da ufeisia wei. ");
INSERT INTO aby_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Eno weike nono wei, emuabake owaowama ufeisia wei. Ufeisike eno wefeisia wei, i ba me godinu ofereni odeka uruna da iforo, moi minu aruma aweka da enare odiforo, mimi ufoisaro iwa isare dafeku abu da iforo, iwa da iforo, eno owaowama ufeisike emuabairo odaifeisia wei. ");
INSERT INTO aby_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Eno weike nono wei, adina furoma moi orouma Mosesinu darawadu moi goi goiro Du orounu sosi sosiro yaisina sabadi odoro aine wai ure ie kakureibisaro naukeibisa i ari enoe awoena enaenari kakuraisaro naukaisaya Deimisima i wake eno wei. ");
INSERT INTO aby_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","23","Deimisima eno weiro i afasoro orouini i dai yawokeka orouini Godinu wake naukeibisa orouini emua yaisina i wake nauisake i wakeye iraua weisa. Eno weisake eme una raarayai Diudiasi Basabasi weaisa mini Sairesini emua we murieka. I miyaie sosi yawokeibisi miyai. I miyaini Foruini Banabasini emua we odaifiakane eno we imuisake emenu imukama i owaowa yanake oisa. Emenu owaowae i ari eno, iya Godinu wake naukaisi orou yaisina, afasoro orouini dai yawokeka orouini iyama ya Anidiyokaini Siriaini Sirisia goi orouini ya imusu Godinu wake naukaisa oroubake arie wake weaisia weisa. Iyanu wake nauawe. ");
INSERT INTO aby_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Eno weisake nono weisa, moi orouma ewadoma yabairo aakake eno weisa, Mosesinu ofe kuureka darawadu wake weisaro ya yaisina nauisake iwoka uisaro nono iya nauisi. Eno weisake nono weisa, i oroue iyama we odaise dauisiro emenu me aare weisaya weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eno weisake weisa, awoena iyanu imukekae eno, eme una raarayai munisiba emuaini Banabasini Foru weaisa mini we odaifiakikiro yabairo aafeisaya weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabasini Foruini emuama Yesunu waiya ukeibisi ibake moi orouma emua ma feafiakane uisaro emua fearekabake ia sine dauisi. ");
INSERT INTO aby_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Diudiasini Sairesini emua we odaisaisiba fafisisiie emenu bebekuma i owaowa wake yaisina wefisisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Eno weisake nono weisa, Godinu Imumu Irauini iyanu imukekae eno, ya imusu orounu ibeka irau ma ara uke dakaisi. Moi wake mero yewa wake mane weaisi. ");
INSERT INTO aby_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Enoba i ba me godinu ofereni odeka abu da iawe, nono iwa da iawe, mimi ureibaisaro iwa dooro isare dakeibaku abu da iawe, moi minu aruma aweka da enare odiawe. I weaisi wake enaenari ufoisaie irauaiai ibifoisa. Iyanu wake idua me sininua eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","I owaowa yanake me sikake i miyai we odairiekaro anisi. Ane Anidiyoka goiro isare ane faki. Isare ane fakike weisiro i Godinu wake naukeibisa orou fare ku siaka. Fare ku siakaro i owaowa emuabairo maisiro kakuka. ");
INSERT INTO aby_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","32","Kakure me sikake i wake irauaiaiya weisake rooro uisa. I we bou urieka miyai Diudiasini Sairesini emuama wake keuwere i oroubairo weisiro i orou emua nauisake emenu imuka irauaiai sika. ");
INSERT INTO aby_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Diudiasini Sairesini emuama eno uisike moi odo odo iro ibeibisiro i Godinu wake naukeibisa orouma Diudiasi we odaisaro owerike Derusaremu goiro Godinu wake naukeibisa oroubairo arie we odaisa wake waure ane fari. ");
INSERT INTO aby_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Eno uiro Sairesi danu mane iro ibeibi. Iro ibeebe dawa arara me owere Derusaremu goiro aneka. ");
INSERT INTO aby_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ibake dawa iro ibiro Foruini Banabasini emuama Anidiyoka goiro ibaada emuaini moi Godinu wake naukeibisa orouma Godinu wake weada i orou we ma iwoka ukeibirieka. ");
INSERT INTO aby_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","38","Moi furo Foruma Banabasibake eno wei, uwanu adinaro enaada Godinu wake we eneiareibisu iro nono owere anifuke emua efiaku wei. Emua irauaiaiba merama ibinisaria anifuke efiaku weiro Banabasi i wake nauike eno wei, Dioni Makini demuiro anifeisi wei. Eno weiro Foru dawa arara me Dioni Makini aneka. Adinaro Dioni Makima emua Famufiria orofaro medirieke owere ani ibake Foru dawa arara me Dioni Makini demuiro aneka. ");
INSERT INTO aby_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Danu ubiye emenu imukeka imusu imusu sini ibake Banabasima Dioni Maki we muniro emenu imusu anisi. Ane boudiro amuisike ekara ena ewa ena dawara nono naisaroe i Saifurasi weaisa dai orofa iro anisi. ");
INSERT INTO aby_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Iro anisiro nono Foruini Sairesi emuae eno anisi. I Godinu wake naukeibisa orouma Foruini Sairesibake guriguri uisake odairiekaro anisi. ");
INSERT INTO aby_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Anisike ane Siriaini Sirisia orofa goi goiro Godinu wake we eneiareibisiro i Godinu wake naukeibisa orouma i wake nauisake emenu imuka irauaiai uisake rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Foruini Sairesini emuama Debe goiroko ane fakike nono meisike iroma ane Risida goiro ane faki. I goiro moi mi danu ibiye Dimodi dawa iro fou uki. Dimodi danu amaeye Godinu wake naukeibi Du aweka, nono danu babaeye imusu Guriki orofa mi. ");
INSERT INTO aby_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","I Risidaini Aikoniamu goiyairo Godinu wake naukeibisa orouma Dimodi dawae irau miya eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Eno we imuisa ibake Foruma Dimodibake eno wei, aini Godinu wake weneibaisi daabaro demuiro anifeisia wei. I Du orounu darawadu ibake Foruma Dimodi we munike danu ofe kuuri. Nono Dimodi danu babaeye imusu Guriki mi ibake dawae Dimodi danu ofe kuure dauiro ibai i Du orou yaisina emua iwoka sika ibake Foruma Dimodinu ofe kuuri. ");
INSERT INTO aby_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kuuriro nono dubuenaro Foruini danu orouini emuama moi goi goiro anisake iroma aboro aboro i imusu orouma Godinu wakeini afasoro orou emenu wakeini naufisane Derusaremu goiro afasoro orouini dai yawokeibisa orouini emenu ukeibisabai i imusu Godinu wake naukeibisa orou naufisake enaenari ufisane ibake i wake eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eno ukeibisa ibake Godinu wake naukeibisa orounu imukekae daiwere imuisake eme keuwere Godi imuisa ibake i sosiro aareibisa orou keuwere emenu imuka yaisina Godibairo odeibisa. ");
INSERT INTO aby_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","I goiyai meisake iroma Eisia orofaro anifisane uisaro Godinu Imumu Irauma emenu daaba dadau ui. Dadau ui ibake Firigiaini Gareisia orofayai iro aboro aboro eneiareibisa. ");
INSERT INTO aby_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","8","Ane Misia orofa udiro fakake Bidinia orofaro anifisane uisaro Yesunu Imumu Irauma emuabake mediaweke iro da aniawe wei. Eno weiro ibake Misia orofa gagade ukake Doroasi goiro isare ane fakake aisa. ");
INSERT INTO aby_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","I aine ibisa dumuro Foruma kubekuberoma eno eri. Kubekuberoma moi Masadonia orofa mi enare ibaada eenu weike eno wei, Masadonia orofaro aarake iya unu koa wei. ");
INSERT INTO aby_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Foruma i kube erike iyabairo weiro Godi Danu ararae Danu wake i oroubairo wefene ibake i daaba ukinua eno we imuisike ibake i daaba yodia ufene uisia Rukima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Rukima eno wei, iyama boudiro amuisike Doroasi goiroma i ekara ena ewa ena dawararo naisaroe Samodureisi weaisa orofaro isare anisi. Anisike iro aisike wai uriro Samodureisiroma Niaforusi goiro anisi. ");
INSERT INTO aby_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Anisike iroma nono umuma ane Firifai goiro faki. Firifaie i Masadonia orofanu dai goi. I goiye i Romani orounu goi. Iro ane fakike iro odo keuwere ibeibisi. Ibeebe Sabadi odoro moi orou adua udiro ku sianaisake guriguri ukaisaya eno weisaro i wake nauisike iro anisi. Goi arawekoro anisike adua udiro ane fakike moi ku siane ibisa awekabo emuabairo Godinu wake weisi. ");
INSERT INTO aby_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","14","Iyanu weisi wake naui moi aweka danu ibiye Ridia. Danu goiye Daiadaira. I awekae Godibairo guriguri ukeibi. Nono danu waiyae kokoi wau make oi muneibi. Dawama Forunu wake naukenewaa uiro Godima danu imuka yaisina ma oweri ibake Forunu wake naukenewaa ui. ");
INSERT INTO aby_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dawaini danu uwararo aineibisa koa yaisina iyama babadaido uriekiro Ridiama eno wei, yama na Godi imukenewaa ukakune imukaisaya nanu uwararo aare ibiawe wei. Eno wei ibake danu uwararo anisia Rukima eno wei. ");
INSERT INTO aby_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Moi odoro i guriguri ukeibisa orofaro aneebe moi wada barau ukeibi aruma fou ukia eno wei. I arumae seidaninu merama imumu bobo aruma. Ibake Dawama wada barau ukaada oi daiwere muneibike dawa yawokeibisa oroubairo makeibirie. ");
INSERT INTO aby_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","I arumama iyanu umuro anike kori daiwere urike eno wei, yewa oroue Godinu waiya ukaisa oroua wei. Eno weike nono wei, Godima ya ma wirofiane farisaya eawe wei. ");
INSERT INTO aby_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Aine wai ure eno areare weibiro Foruma ibai nauke awakebe dawama eno wei, danu imuka ubarenaro ibi seidaninu merama imumubake bunawereroma eno wei, i aruma danu imuka ubarenaroma amuake ania wei. Eno weiro ena seidnanu merama imumu sabu isare ani. ");
INSERT INTO aby_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Isare aniro i aruma yawokeibisa orouma dawa ekake eno weisa, iyanu oi daiwere munaisi ibai idua me sininua eno weisa. Eno weisake Foruini Sairesi muriekake i uwara seboro yaure ibaada kodo ureibisa oroubairo waure ane odirieka. ");
INSERT INTO aby_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Eno uisake meo weisake eno weisa, yewa Du miyaima merama wake weisiro yewa goi orou i miyainu merama wake naukada ibake emenu imuka merama imukaisaya weisa. ");
INSERT INTO aby_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eno weisake nono weisa, i Romani orounu darawadu da nauawe weisia eno meo weisa. ");
INSERT INTO aby_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eno meo weisa ibake eme keuwere ku sianada dino uisa ibake kodo ureka orouma Foruini Sairesini emenu wau ma girise mune siakake weisaro i Furisi orouma i miyai usima urieka. ");
INSERT INTO aby_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Usima ureebe ureebe oisaro iwa fareibi. Eno uisake ana eba uwara ubarena naisaro ane odiriekake i ana eba yawokeibi mibairo eno weisa, yewa miyai yawokenewaa ufiao weisa. ");
INSERT INTO aby_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eno weisa ibake ana fuyai wowonaro ode duboro ode eno uike emenu umuyai mune ana feraoro odike senima uwane karise odiriero yaure ibisi. ");
INSERT INTO aby_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yaure ibeebe dumu abanaro Foruini Sairesini emuama Godibairo guriguri ukaada yaura kairoma weibisiro i ana ebaro yaure ibisa orouma i yaura kai weibisibai nauisa. ");
INSERT INTO aby_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Foruini Sairesini emuama yaura kairoma weibisibaie doo amani amani daiwere uiro i uwara amani amani uiro i ana eba uwara aisame yaisina ko woromisaro i ana ebaro ibisa orou uwane odirieka seni yaisina me kukune isaka. ");
INSERT INTO aby_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eno uiro i ana eba uwara yawokeibi mi dawa nauka aine ibiro eno ukeibiba danu naisa foraike uyarada aisame ko worome ibibai erike eno we imui, yewa uwara ibinisa orou yaisina anisaya eno we imuike danu bau munike danu onami nodo kuufine ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Eno ukeibiro Foruma daiwere weike eno wei, eno da ua wei, iya yaisina yewado ibinisia wei. ");
INSERT INTO aby_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Eno weiro nauike ia daiwere sinaada moi mibake daiwereroma eno wei, esiwa maina wei. Esiwa mairo munike i ana eba uwara ubarenaro sabu isarike ia daiwere sinaada iura mamike Foruini Sairesini emenu umu udiro iboo yanai. ");
INSERT INTO aby_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eno uike uyarike Foruini Sairesi emua waure ane aweawero odirieke eno wei, ya, na i wirokeroma me ibene ibene ibeka aneme aneme umauke mumau wei? ");
INSERT INTO aby_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Eno weibaie emuama eno weisi, i Dai Waria Mi Yesu Keriso imukenewaa ua weisi. Eno weisike nono weisi, eno ufakuie aini anu uwararo ibinisa koaini yaisina Dawabairo wirofoisaya weisi. ");
INSERT INTO aby_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","I ana eba yawokeibi minu uwararo amuisaro Foruini Sairesini emuama i mini danu uwararo ibisa oroubairo Godinu wake emuabairo weisi. ");
INSERT INTO aby_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eno weisiro i mima Foruini Sairesi we murieke emua usima urieka biobao aduama uroiro dawaini danu koa yaisina emuabairo babadaido uisa. ");
INSERT INTO aby_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Babadaido uisaro i mima uruna nabero munike emuabairo mariero isi. Eno uisake dawaini danu koaini emuama emenu naukeka Godibairo oisake rooro daiwere uisa. ");
INSERT INTO aby_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wai uribaie i kodo ureka orouma furisi orou we odaisaro anisa. Foruini Sairesi ma woromifisane anisa. Ane fakake eno weisa, i miyai ma woromiaro anifisi weisa. ");
INSERT INTO aby_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eno weisaro i ana eba uwara yawokeibi mima Forubake i wake eno wei, i kodo ureka orouma ya ma woromimane we odaisisaro faraisaya aweawero amuawake irauaiai aniawa wei. ");
INSERT INTO aby_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Eno weibaie Foruma ma owerike eno wei, emuama uwa emenu naisaro usima ureibisaro ekaya wei. Eno weike nono wei, uwama moi merama uke dauisua wei. Eno weike wei, uwae Romani miyaia wei. Eno weike nono wei, emenu ararae uwa fema anekaro nono uwa eno da ufukua wei. Eno weike ba nono wei, emenu onarouma fafeisake uwa mune aweawero odaimukaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Eno weiro i furisi orou anisake i kodo ureka oroubairo Forunu wei wake emuabairo ane weisa. Ane weisaro Foruini Sairesini emuae i Romani oroua weisaro nauisake ia sirie. ");
INSERT INTO aby_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ia sirie ibake Foruini Sairesibairo anisake emenu imukaro imuisake arie weisake eenu weada eno weisa, iyanu goi mediawake aniawa weisa. Eno weisaro ana eba uwara ubarenaroma amuisike anisi. ");
INSERT INTO aby_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Anisike i aweka danu ibiye Ridia danu uwararo anisike i Godinu wake naukeibisa oroubairo Godinu irau wake weisike emenu imukeka ma irauaiai uriekike nono i goi meisike anisi. ");
INSERT INTO aby_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","3","Foruini Sairesini emuama Amofiforisi goi gagade ukike nono Aforonia goiro fakike idua anisi. I goiyai fare ma bereisike ane Desoronaika goiro faki. I goiro Du orounu moi sosi ibi ibake Foruma amuike Godinu wake wei. Foru danu ukeibi enaenari sabadi odoro deibuuba amukeibike i Godinu bukaro wakeye eno wei, iyanu fafine yawokaisi Mesaia weaisa Mi oferi daiwere mufeku odo odo fafekuro oferi daiwere waufekuke feafekuke nono uyafeku i wake Godinu bukaro eno ibinua wei. Yewae Yesu Keriso Dawabake weakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Eno uke bunawere weiro moi orou nauisake ie ba Yesu Keriso eno we imuisake ibake Foruini Sairesini emuabairo aare dakaa uisa. Eno uisaro Nono moi orou Godinu wake naukeibisa Guriki dai orou, emuaini moi ba ofe sirie awekaboini emenu imuka yaisina Yesubairo oisake emuabairo dakaa uisa. ");
INSERT INTO aby_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eno uisaro nono moi Du orou nauke da uisa ibake dino wake weisa. Eno weisake merama eme keuwere mukake Foruini Sairesini emua ufiakane imuisaro eme keuwere fare ku siakake wake goro daiwere weisa. Eno weisake Deisoninu uwararo anisake fare Foruini Sairesi emua i kanisoro oroubairo waure ane odifiakaro fafisake fanisi mafiakane ibake anisa. ");
INSERT INTO aby_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Anisake Deisoni danu uwararo fare usima i uwara ure uyakake Foruini Sairesi emua yodia uke anisake mune dariekake ibake ane Deisonini danu moi orouini emua muriekake ane i kanisoro oroubairo waure ane odirieka. Waure ane odiriekake eno weisa, Foruini Sairesi i miyaima goi aboro aboro eme yaisinanu imukeka irau ma merama uisike nono awoena idua farisia eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Awoena idua farisike Deisoninu uwararo aine ibinisia eno weisa. Eno weisake nono weisa, i miyaima dai yawokaku mi Sisanu darawadu nauke dakaisia weisa. Eno weisake emuama eno weisia weisa, moi kini mi, Danu ibiye Yesu, Dawa ibinua weaisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Eno weisaro i goi orouini kanisoro orouini emuama i wake nauisake emua arara dariero Deisonibake eno weisa, ama we mune ode ibinero ibake emuama eno ukaisia eno weisa. Eno weisake emuabake eno weisa, iyabairo oi maa weisa. Eno weisake weisa, i miyai irauaiai me ibifisisiie yanu oi ma owere mafeisi weisa. Eno weisaro Deisonini danu orouini emuama i kanisoro oroubairo emenu oi mariekaro kanisoro orouma emua we odairiekaro anisa. ");
INSERT INTO aby_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Deisonini danu orouini emuama Foruini Sairesi emuabairo ane fakake dumuro we odairiekaro anisi. Ane Beria goiro faki. Beria goiro ane fakike sosi ubarenaro amuisike Godinu irau wake wefisine amuisi. ");
INSERT INTO aby_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","I Beria Du oroue irauaiai orou. I Desoronaika goi orou ari me. Ibake i Beria goi orouma Godinu wake naukenewaa uisake Godinu buka aine wai ure kakureibisa. Eno ukeibisaro Foruini Sairesi emenu wake baba meo ari eno we imuisake ibake Godinu buka kakurenewaa ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eno ukeibisa ibake Du orou keuwereini Guriki emeakaini awekaboini emenu imuka yaisina Yesubairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Foruma Godinu wake Beria goiro weibibaie moi Desoronaika goi orouma i wake nauisake Beria goiro ane fakake dino uisake koroko wake weibisa ibake eme keuwere Foru arara dauisa. ");
INSERT INTO aby_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eno uisa ibake i Godinu wake naukeibisa orouma Foru we odaisaro ane boudi munike moi orouini ani. Aniro Sairesini Dimodini emuama i Beria goiro ibeibisi. ");
INSERT INTO aby_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Foruini danu orouini emuama Adena goiro ane fakaro Foruma danu orou emuabairo eno wei, aniaweke Sairesini Dimodini emua nabairo we odaiawero sabu aafisi wei. ");
INSERT INTO aby_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Foruma Adena goiro i miyai koro ukaada ibibaie Adena goi orounu wanama ubu uisa godi fefera erike imuka merama sineibi. ");
INSERT INTO aby_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eno ukeibi ibake i Du orounu sosi ubarenaroini moi goiro ku siane ibisa orofaro i Du orouini i Godibairo guriguri ukeka imusu orouini emuabake Godinu wake bunawere weibi. ");
INSERT INTO aby_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Moi Efikuriani weaisa orouini moi Sidoiki weaisa orouini emua fou urieke emuabairo Godinu wake wei. Weiro nauisake moi orouma eno weisa, yewa wake goro weeka mima aneme weaku weisa? Eno weisaro nono moi orouma eno weisa, dawa i imusu godibake sibore sianeka wake weakua eno weisa. Foruma Yesu Danu fearike uyari wake weibi ibake eno weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Eno weisake nono Forunu wanaro mukake emenu ku siane ibisa oraaranakuro waure ane oisa. I oraaranu ibiye Areafagu. Iro waure ane oisake eno weisa, anu awoena sibore sianeka wake wearo naufe weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Eno weisake nono weisa, i wake adinaro nauke dakaisike awoena kawama naukaisia weisa. I wakenu ubi iya iwoka sifene ibake weaisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(I Adena goi orounu ukeibisa ubue eno, aine wai ure kawama wake weekaini kawama ukekaini emenu ararae ere nauke uke iwoka sifisane ibake naukenewaa ukaada ibeibisa. Ibake i imusu orounu wake naukada i naukeibisa wake aine wai ure weada ibeibisa.) ");
INSERT INTO aby_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Eno ukeibisa ibake Foruma i Areafagu orofaro ku siane ibisa ubarenaro uyarike eno wei, Adena goi orou nanu wake nauawe wei, yanu sibore sianeka ukenewaa ukeibaisaro na erakunea wei. Yanu sibore sianeka eraerabusae keuwerero na aaneke enea wei. ");
INSERT INTO aby_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Eno weike nono wei, na owere anaadae moi ofereni odeka oisake danu owaowa uke oisaro ibinubai enea wei. I owaowa eno uke oisaro enea wei, yewa ofereni odaisiie iya iwoka me godinua eno owaowa uke oisaro enea wei. Eno weike nono wei, yewa Godibake yabairo weakunea wei. ");
INSERT INTO aby_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yewa Godiye ureini dooini eraerabusa yaisina ubu uia wei. Yewa Godi Dawae ureini dooini yaisina yawokakuba ibake Dawa emema ma enareka uwara ubarenaro ibe dakakua wei. ");
INSERT INTO aby_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Eno weike nono wei, emenu wanama Dawabake aneme aneme make dakaisia wei. Danu mane iyanu imu sianekaini me irauaiai ibekaini aneme aneme makakuniba ibake iyanu moko Dawa mune dakakua wei. ");
INSERT INTO aby_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Foruma eno weike nono wei, Godima amara una demuinaku munike orofa akaka eme yaisina dawabairoma ubu urieke emenu orofa imusu imusuro odirieke emenu oya abea ibeifeisa ibaini wei ibake eno uke me ibeibaisia wei. ");
INSERT INTO aby_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Godima eno uike eme yaisina Dawa yodia ufisake imufisane ibake eno uia wei. Eno weike nono wei, iyabairoma Dawabairo daaba yafa me ubiubinakua wei. ");
INSERT INTO aby_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Foruma emuabake nono eno wei, awoenae Dawa Godi ibake iya enaada me irauaiai ibinisia wei. Yanu orounu moi owaowa odeka orouma eno weisaya wei, iyae anu sisia orou weisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","30","Eno owaowaro eno uke oisaya wei, iyae Danu sisia orou ibake Godi Dawae oi kaibai, o gorudi, o oma, o emenu imukeka eraerabusae i ari me, i ari enoya da imufeisia wei. Eno weike wei, adina orouma Godi iwoka me ibake Godima emua dino uke yare dariea wei. Nono awoena Dawama iya eme yaisinabake eno buna wake weakua wei, yanu merama merama ukeka imuke mediawe eno weakua wei. ");
INSERT INTO aby_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Godima, Danu odi odoro yewa orofa akaka eme yaisina moi Mibairo gienabu kodo ufekua wei. I Mima feariro nono ma uyari ibake iya yaisina Dawa iwoka ufene ibake eno uia wei. ");
INSERT INTO aby_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Foruma i feareroma uyareka wake weiro nauisake moi orouma dawae meo weakua weisa. Eno weisaro nono moi orouma iyanu arara wake nono wefakuro naufeisia weisa. ");
INSERT INTO aby_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Eno weisaro Foruma i wake we me sinike i orou medirieke aweawero isare ani. ");
INSERT INTO aby_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Aweawero isare aniro moi orou dawabairo anisake emenu imuka yaisina Godibairo oisa. Daionisia weaisa mi dawa i Areafagu kodo ureka dai mi dawaini moi aweka danu ibiye Damarasi dawaini nono moi orouini emuama Forubairo anisake emenu imuka yaisina Godibairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","2","Foruma Adena goi medike Korinida goiro ane fari. I goiro moi Du mi danu ibiye Akuira dawaini danu awekaini iro ibeibisi. Akuira dawa doka orofae Fonidia. Akuira danu awekanu ibiye Fasira, enoba emuama Idari orofaroma awoena Korinida goiro faki. Moi mi danu ibiye Korodiasi Sisa, dawae i Romani orofa yawokeibi dai mi. Dawama Du orou yaisina emua Romani goiro ibeka dawa arara daui ibake weiro ia sika. Ia sikaba i Romani goi meisike Korinida goiro faki. Fakiro Foruma emua efiane ane emenu uwararo ani. ");
INSERT INTO aby_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Foruini Akuiraini emenu ukeibisi waiya demui. Emenu waiyae farai uwara wau yanake kariseka waiya ukeibisi enoba Foruma emuaini demuiro ibiro i waiya ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Moi sabadi odo odoro aine wai ure Du orounu sosi uwara ubarenaro amukeibike Du orouini Guriki orouini wake wake we makanada nono moi Du orouini Guriki orouini emuama Forunu weibi wake naukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dubuenaro Sairesini Dimodini emuama Masadonia orofaroma idua faki. Fakiro Foruma moi Du oroubairo eno wei. Yesue ya Du orounu ma wirokeka miya wei. ");
INSERT INTO aby_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Eno weiro i Du orouma Forunu wake nauke da uisake wasai imuka imuisake Yesubake merama wake weisa. Eno weisaro Foruma uyarike i orou emua medifiane ukaada ibake danu wau ure bu yaraada eno wei, yae Godi arara dakaisaba ie yanu merama, nanu merama meya wei. Eno weike nono wei, eweirae Du orou medimiauke i Du me imusu oroubairo animauke Godinu irau wake weimaua wei. ");
INSERT INTO aby_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Eno weike Foruma i Du orounu sosi medike Daidasi Dasidasinu uwarae i sosi udiro ibiba danu uwara ubarenaro ane amui. Daidasi Dasidasie Godinu wake naukeibi mi. ");
INSERT INTO aby_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nono Kurisifasi, dawae i Du orounu sosi yawokeibi mi ibake danu uwararo ibeibisa orou yaisinaini moi Korinida goi orouini emenu imuka yaisina Yesubairo oisake emuabairo babadaido uisa. ");
INSERT INTO aby_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Moi odo dumuro Foruma nauka aine ibeebe kube eribaie Yesuma eno wei, ia da siake wake da muu ua wei. ");
INSERT INTO aby_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Eno weike wei, abairo ibineba emema da umekaisaya wei. Eno weike wei, Na imukaisa orou keuwere yewa goiro ibinisa wei. ");
INSERT INTO aby_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Foruma i kube eri ibake Korinida goiro moi oyaini moi oya abanaro ibaada aine wai ure i oroubairo Godinu irau wake weibi. ");
INSERT INTO aby_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Moi mi danu ibiye Gario dawama Akeiya orofa yawokeibibaie i Du eme keuwerema Foru ufisane uyakake Foru mukake i kodo ureibisa oroubairo waure ane oisa. ");
INSERT INTO aby_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Emuabairo waure ane oisake dawabake eno weisa, yewa mima eno weakua weisa, Godi mane imukeibiawe weakuke iyanu darawadu ma merama ukakua weisa. ");
INSERT INTO aby_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Eno weisaro Foru danu ararae nono wefine uiro i kodo yawokeibi mi Garioma Forunu wake weeka daaba enare kuurike i Du oroubake ma owerike eno wei, dawa aneme merama ukinu wei? Eno weike nono wei, dawa waira uke dakinuke eme ure dakinuba kodo da ure yamaua wei. ");
INSERT INTO aby_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","16","Eno weike nono wei, ya Du orounu darawadu wake ma merama uiba yanu baubauwaka oroubairo merama wake weifibai nauke daueroma anemebake kodoro odifone aare weaisa wei. Eno weike danu kodo ureibi uwara ubarenaroma emua yoweriero anisa. ");
INSERT INTO aby_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Anisake awoena Du orounu sosi yawokeibi mi danu ibiye Sosidinisi dawa mukake usima ureibisaro Garioma i ureibisabai erike we kuure daurie. ");
INSERT INTO aby_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Foruma odo keuwere Korinida goiro ibeebe nono i goi medike boudiro amuike Fasiraini Akuira we murieke Siria orofaro anifine ui. Aneebe Sinikuria goiro farike Foruma Godibairo adinaro we bou ui ibake danu fouma idi yaisina garuru ui. Ie i Du orounu bisaraba ibake eno ui. ");
INSERT INTO aby_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Eno uiro nono iroma Efesa goiro ane faka. Fakaro Foruma Fasiraini Akuira emua iro medirieke i Du orounu sosiro amuiro dawaini i Du orouini wake wake bunawere we makaneibisa. ");
INSERT INTO aby_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","21","I Du orouma we kuukabaie Foruma meya weike wei, Godima na nono owemane wefekuie idua owemauke yabairo nono famaua wei. Eno weike ane boudiro amuike Efesa goiroma ani. ");
INSERT INTO aby_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Anike aneebe Sesaria goiro farike i goiro Godinu wake naukeibisa oroubairo amuke anike emuaini demuiro yaure ibisa. Farike emuaini yaure ibeebe i orou medirieke Anidiyoka goiro isare ani. ");
INSERT INTO aby_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anidiyoka goiro isare ane farike Anidiyoka goiro ibeebe nono i goi medike Gareisiaini Firigia orofayai goi goiro enaada Godinu irau wake weibike i Godinu wake naukeibisa orounu imukeka ma buna urie. ");
INSERT INTO aby_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nono dubuenaro moi Du mi danu ibiye Aforasi. Nono danu goiye Arekisania. Dawa i goiroma Efesa goiro ane fari. Dawae irau wake weibike Godinu buka kakurada iwoka daiwere sineibi mi. ");
INSERT INTO aby_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Adinaro moi orouma dawa Yesunu imukeka we ma iwoka ukeibisaro naukeibi. Naukeibike dawae Dioninu babadaido ukeka mane iwoka uike ibake Yesunu imukeka yaisina dawa iwoka da sini. ");
INSERT INTO aby_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I mima i Efesa goiroma farike danu imuka yaisina irauaiai ui ibake i Du orounu sosiro amuike Godinu wake bunawere we ma iwoka urie. Eno we ma iwoka ukeibiriero Fasiraini Akuiraini emuama danu we ma iwoka ukeibi wake nauisike i mi we mukike Godinu imukeka yaisina dawabake we ma iwoka ukenewaa uisi. ");
INSERT INTO aby_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nono dubuenaro Aforasima danu arara Akeiya orofaro anifine ibake i Godinu wake naukeibisa orouma owaowa uisake i Akeiya orofaro Godinu wake naukeibisa oroubairo make odaisada eno weisa, yewa minu ukeka sineka irauaiaiba dawa we muawe. Owaowaro eno owaowa yanake oisake make odaisa. Eno uisaro Aforasima iroma farike Godinu wake naukeibisa orounu imukeka ma irauaiai urie. ");
INSERT INTO aby_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Dawae Godinu buka munaada iroma Yesue i Du orounu ma wirokeka Miya eno bunawereroma we ma iwoka ukeibirie ibake i Du orouma dawabairo wake moi we dauisa. ");
INSERT INTO aby_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Aforasima Korinida goiro ibeibiro nono Foruma oraara nauwaro eneebe Efesa goiro isare ane fari. Isare ane farike moi Godinu wake naukeibisa orou fou urieke emuabairo eno wei, ya Godi imukeibisa odoro Godinu Imumu Irau yanu imuka ubarenaro isariba me wei? Eno weibaie aneme weaku weisake nono weisa, Godinu Imumu Iraude anemerabu weisa? ");
INSERT INTO aby_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Eno weisaro Foruma ma owerike eno wei, ainanu imukeka mukake babadaido uisa weibaie emuama Dioninua weisa. ");
INSERT INTO aby_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","6","Eno weisaro Foruma wei, Dionima eno weia wei, yanu merama merama ukeka yaisina imuke mediaweke nanu umuro aafeku Mi Dawa mane imuawe Dionima eno weia Foruma wei. I Miye Yesu Keriso Foruma eno weiro i orou nauisake emuabairo Yesunu ibiro babadaido uisaro Foruma wana emenu iiri duboro odi. Foruma eno uiro Godinu Imumu Irauma emenu imuka ubarenaro isariro wake imusu imusu weisake Godinu wake we bou uisa. ");
INSERT INTO aby_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Eme yaisina duwero (12) emuama ibai eno uisa. ");
INSERT INTO aby_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","10","Foruma sabadi odo odoro aine wai ure i Du orounu sosi uwara ubarenaro amukeibike Godima iya irauaiai yawokakunia weibi. Manabe kai buuba eno ukeibiro moi orouma emenu imukeka ara ukaada imuke dauisake i ku siane ibisa orou yaisinabake eno weisa, yewa Yesunu daabae meramawereya weisaro ibake Foruma Godinu wake naukeibisa orou we murieke waure anirie. Waure anirieke i moi mi Diranasi danu sikuru uwara ubarenaro ku uke ibaada aine wai ure guriguri ukaada Godinu wake weada we ma iwoka ukeibirie. Oya raarayai eno ukeibiro i Eisia orou yaisinaini Du orouini Guriki orouini emua yaisinae Yesunu wake Foruini danu orouini emuama weisaro nauisake moi orou Godinu wake nauisake naukeka orou ari sikaro nono moi orou Godinu wake nauisakema nono emua arara me Godinu wake naukeka ibake emuae nauke dakeka orou ari sika. ");
INSERT INTO aby_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Godima Foru buna daiwere mairo Foruma buna ukeka daiwere ukeibi. ");
INSERT INTO aby_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Eno ukeibi ibake danu muko o wauma mukake arama uke ibisa orounu ofero oisaro sabu irau sikaro seidaninu merama imumu emenu imuka ubarenaroma amuisake anisa. ");
INSERT INTO aby_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Eno uisaro moi Du me imusu wada barau ukeibisa orouma Yesunu ibiro weisake seidaninu merama imumu we yowekake eno weisa, Forunu weaku Mi Yesunu ibiro weaisia amuaweke aniawe weisa. ");
INSERT INTO aby_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","15","Moi Du orounu ofereni odeka mi danu ibiye Sikiwa danu amaraku yaisina sewenima (7) eno uisabaie i seidaninu merama imumuma eno wei, Yesu Dawae na iwokaya weike nono wei, Foruini na iwokaro nono yade abo orouro wei? ");
INSERT INTO aby_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Eno weibaie i seidaninu merama imumu bobo mi iroma bibi urike amuike i amaraku yaisina seweni (7) urieke emenu runeka wau mune sianike ure yanake urie. Eno urie ibake i orouma uwara ubarenaroma ofe mane aweawero sabu anisa. ");
INSERT INTO aby_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","I Efesa goi orou yaisina, Du orouini Guriki orouini emuama ibai nauisake ia daiwere sikake Yesunu ibi we ma irauaiai uisa. ");
INSERT INTO aby_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Awoena Godinu wake naukeibisa orou keuwere Foruini danu oroubairo fakake emenu diwari urekaini merama merama ukeka sineka yaisina we ma boroo yaka. ");
INSERT INTO aby_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Eno uisake moi wada barau ukeibisa orouma emenu wada barau eraerabusaini bukaini waukake demui orofaro ku siane oisake inaama yakaro yare me sini. I emenu wada barau ukeibisa bukae keuwere. I bukanu make oi munekae daiwere deni dausini kina (K1000). ");
INSERT INTO aby_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Eno uisake Godinu wake daiwere weisaro nauisake eme keuwere emenu imuka yaisina Godibairo oisa. ");
INSERT INTO aby_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nono dubuenaro Godinu Imumu Irauma Danu irau imukeka Forubairo mairo Foruma imukama we imuike eno wei, Masadoniaini Akeiya orofayairo fare animauke Derusaremu goiro animaua eno we imuike wei, nono dubuenaro iroma Romani goiro animaua wei. ");
INSERT INTO aby_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Foruma eno weiro danu unu koreka miyai Dimodini Erasidasini emua Masadonia orofaro we odairiero anisiro Foru dawa Eisia orofaro moi odoyai iro ibeiari. ");
INSERT INTO aby_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dawa iro ibeiari odoyairo eme keuwerema Godinu wake naukeibisa orouini urafisane ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Moi mi danu ibiye Dimidirisi dawama eno weibi ibake emuaini urafisane ukeibisa. I Mi Dimidirisi danu waiyae i ba me godi, Daiena danu okoa uwarananaku oi ubu ukaisa i siriwama ubu ukeibi. Ie danu oi waiya. Moi orouma i waiya ukeibisake oi daiwere muneibisa. ");
INSERT INTO aby_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","26","Ibake eno ukeebe Dimidirisima i danu waiya ukeibisa orou weiro fare ku uisaro emuabake eno wei, ya yewa waiya ukaisike oi daiwere munaisia weike nono wei, Foruma eno weakua wei, wanama ubu ukeka godiye ba me godiya weaku ibake yewa Efesa orouini i Eisia orofa goi goiro ibinisa orou keuwere danu weaku wake naukaisake i wanama ubu ukaisa godi medaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","29","Eno weike nono wei, dawama eno weakuba iyanu oi muneka waiya isafekua wei. Eno weike wei, i Eisia orofa orouini yewa orofa akaka orou yaisina i yanu ubu uisi aruma godi Daienanu dai sosi uwara da imufeisake dawabake sibore da siafeisaro danu ibi isafekua wei. Dimidirisima eno weiro danu goi orou nauisake dino daiwere ukaada daiwereroma eno weisa, Efesa goinu godi Daiena dawae daiwereya weisa ibake Efesa goi orou yaisina emenu imukeka imusu imusu imuisake i dai ku ukeibisa orofaro sabu anaada Masadonia miyai Geiasini Aridikasi emua yabariekake ma youre anaada i ku siane ibisa oroubairo waure anirieka. I miyaie Foruini demuiro anisa ibake eno uke yarieka. ");
INSERT INTO aby_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","31","Foru danu arara i ku uke ibisa orofaro anifine uiro nono moi Godinu wake naukeibisa orouma danu daaba dadau uisaro moi dai Eisia orofa yawokeibisa orou emuae Forunu naiyemuku ibake Forubairo wake we odaisake eno weisa, iro da ania weisa ibake Foru iro ane daui. ");
INSERT INTO aby_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Moi orouma emenu sara wake gorowere weibisaro nono moi orouma emenu imusu imukeka wake gorowere weibisa. Eno areare weibisa ibake i me sara faka orou emua aneme aneme weifeisa wakenu ubi emua iwoka me ibake eno we imuisa, iya anemebake farisi eno we imuisa. ");
INSERT INTO aby_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","34","Moi Du orouma i mi Arekisana ma youkabaie i orou emenu ibooro ane enare ibaada i oroubairo Arekisanama moko wake wefine wana ei mamiro i orouma dawa Du mi ere karana uisake wake goro daiwereroma eno weisa, Efesa goinu godi Daiena dawae daiwerea eno weisa. Ibake i wake sia we naukada ibisaro eweka naisa me sini. ");
INSERT INTO aby_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Eweka naisa me siniro i goiro owaowa odeka mima wana ei mameibi ibake i orouma wake goro meisaro i mima eno wei, iya Efesa goi orouma Daienanu sosi uwara yawokaisike i ureroma dooro isari eno iifa oma yawokeibaisiro i orofa akaka eme yaisina emua iwoka sinaisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Emua ibai iwoka sinaisaya wake goro mediaweke merama ukekama da uawe wei. ");
INSERT INTO aby_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Eno weike nono wei, Foruini danu orouini emua iyanu godinu eraerabusa waira uke dakisake iyanu godibake merama wake we dakisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Eno weike nono wei, Dimidirisini danu orouini emuama meo wayai wake wefisane ufeisaie i kodo ureka oroubairo anifeisake emenu wayai wake iro wefeisaya eno wei. ");
INSERT INTO aby_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nono yama wayai wake wefoisaie i kodo ureka oroubairo wefoisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Eno weike nono wei i Romani orofa yawokeibisa orouma iyanu urane rarane ukeka wake naufeisake fanisi mamisaisa wei. Ibake eno weike wei, iyanu urane rarane ukekae ba meya wei. ");
INSERT INTO aby_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Eno weike i orou yaisina we odairiero fiake anisa. ");
INSERT INTO aby_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","I ku siane ibeebe nono dubenaro i wake gorowere weibisabai me siniro Foruma weiro Godinu wake naukeibisa orou dawabairo ane fare ku uisaro Godinu wake yarieke emua idua medirieke Masadonia orofaro ani. ");
INSERT INTO aby_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Masadonia orofaro anike iroma i goi goiro Godinu wake naukeibisa orounu imukeka ma irauaiai ukeibirieke nono emua medirie. ");
INSERT INTO aby_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","I Masadonia orofa medike Gurisi orofaro ani. Ane farike manabe kai buuba iro ibeebe iroma Siria orofaro anifike boudiro amufike anifine ui. Eno uibaie moi orouma dawa ma feafisane daaba yodia ukeibisaro nono moi orouma ibai weisaro nauike anifine ukeibi ibai medike eno wei, Masadonia orofaro owemauke duero umuma animaua wei. ");
INSERT INTO aby_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Foruini moi orouini anisa. Moi mi Safadu, Beria goi mi dawae Firusunu amara dawaini anisa. Aridikasini Sekunadaini emuae Desoronaika goi miyai emuaini demuiro anisa. Geiasi dawae Debe goi mi dawaini anisa. Dimodi emuaini anisa. Emua demuiro anisaro nono moi Eisia orofa miyai Disikasini Dorofimasini emuae i orouini demuiro anisa. Foruini i orouini emuama Gurisi orofa meisake Firifai goiro ane faka. Ane fakaro na Rukima Firifai goiro emua yawokeibisararo idua faka. ");
INSERT INTO aby_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Iro ane fakake Foruini kowede anisa orouma Firifai goiroma Doroasi goiro isare anisake iya yawokeibisa. ");
INSERT INTO aby_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","I Godima Isaraera orounu Idifiroma waure aneka banau uruna odo me siniro iyama boudiro amuisike Firifai goiroma Doroasi goiro isare anisi. Iro aneebe aneebe daabaro odo fo (4) me siniro Doroasi goiro idua ane faki. Iro ane fakike i goiro odo seweni (7) i emuako isare ane ibisa orou iro emuaini kowede ibeiyaki. ");
INSERT INTO aby_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","I dai fura badoaro Babaenu iwaini ofe ifene fakike ku uisiro Foruma Godinu wake wei. Foru dawa wairo anifeku ibake i wake fefera weibiro manabe farike fare amuke aare okoro fari. ");
INSERT INTO aby_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","I uwaranu eku dubodei ooru buubaro yaure ibisiro ramefananaku biake oisaro edoro ukeibisa. ");
INSERT INTO aby_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Moi awoena mi, danu ibiye Yudikasi dawama uwara funefune aareka ebaro yaure ibaada nauka kunawere aine ibeebe biruike eu dooro isare urike feari. ");
INSERT INTO aby_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","11","Eno uiba ibake Foruma sabu isare anike i mi yabakada eno wei, wake goro mediawe wei, awoena dawa imu sianada wirokakua wei. Eno weiro uwara dubodei ooruro nono amuisiro Foruma Babaenu iwaini ofe naka naka uiro isi. Ise me sikiro Foruma Godinu wake i dumu yafa weibiro wai uriro idua medi. ");
INSERT INTO aby_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Idua mediro i ku uke ibisa orouma i awoena mi mukake imuka irauaiai uke emenu uwara uwararo anisaro nono iyama emua meisike idua anisi. ");
INSERT INTO aby_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Iya ane boudi ubarenaro amuisike anisi. Anisiro nono Foru dawae udiro umuma ani. Iyama boudiroma Foru Eisosa goiro fou ufene anisi. ");
INSERT INTO aby_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eisosa goiro ane fakike koro ukeibisiro Foru farike boudi ubarenaro amuiro Midarina goiro anisi. ");
INSERT INTO aby_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Iroma anisike Kiosa orofa ma bereisike ane abanaro aisike nono wai uriro uyakike Samosa goiro ane faki. Ane Samosa goiro fakike aneebe aneebe daabaro dumu siniro aisi. Aisike wai uriro uyakike ane Mairidasi goiro faki. ");
INSERT INTO aby_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","17","Foru dawa arara me i Eisia orofaro ibeka. Ibake danu ararae moi Du orounu banau odoe Fenidikosi weaisa, ibake i odoro danu ararae i Derusaremu goiro ibifine ibake Efesa goi ma berefine ukaada i Efesa goiro sosi yawokeibisa oroubairo wake fo we odairo dawabairo aare faka. ");
INSERT INTO aby_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","Aare fakaro Foruma eno wei, nanu wake nauawe wei, na yaini ibisararo yama nanu ukeka sinekabai iwoka sikaya wei, ibake nanu fare odoroma Godinu waiya nanu imuka yaisina iro odeke ukeibisara ibake ii weada rooro uke dakeibisarake Godinu waiya irauaiai ukeibisaraya wei. Eno ukeibisara ibake i Du orouma na ma feafokonebake ukeibisa merama ure yanake odo odo fareibiie Godinu waiya ukenewaa ukeibisaraya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Foruma eno weike nono wei, yaini ibaada Godinu irau wake yanu sosiroma yanu uwara uwararo weibisarake i demui wake i Du orouini i Guriki orouini emuabairo enaenari weibisarake yanu merama merama ukeka imuke mediaweke yanu imuka yaisina iyanu Dai Waria Mi Yesu Keriso Dawabairo odiawe eno weibisaraya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Eno weike nono wei, Godinu Imumu Irauma nabairo weakuba ibake awoena owemauke Derusaremu goiro animaua wei. Iro aneme aneme nabairo ufeisaie na iwoka meya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Eno weike wei, Godinu Imumu Irauma nabairo eno weakua wei, moi goi goiro anifakuie a ana ebaro odifeisake meramawere uke yamekaisaya eno weakua wei. Eno uke yamekaisaie Na da medimauanea Foruma eno weike nono wei, nanu ibeka irau da imumaubaro wei. ");
INSERT INTO aby_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","I Dai Waria Mi Yesunu makara waiya gienabu uke masoamane animaua wei. Moi oroubairo Godinu irau wakeini Danu irau unu korekaini wemane animaua wei. ");
INSERT INTO aby_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Foruma eno wei, adinaro yabairo ibaada Godima ya yawokakuneba Danu sisia sirorari orou sinaisa wero nauisaya wei. Foruma eno weike nono wei, awoena moi wake da wemauro yama nanu iboo naisa nono da efokaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Eno weike wei, moi dai me wakenaku mane wemaua wei. Godinu irau wake yabairo wenewaa ukeibisaraba ibake aina ainama ibeebe yanu imuka yaisina Godibairo da odifoisake feafoisaie i dawa nanu merama meya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Godima ya yawokeka orou we mune odirieba ibake yanu onarou erenewaa ufoke iyanu Godinu wake naukaisa orou yawokenewaa ufiakau wei. Godima Danu wake naukaisa orou Yesunu iwama make mune odirie ibake Godinu wake emuabairo weawero naufisa wei. ");
INSERT INTO aby_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Foruma eno weike nono wei, na animauro moi merama orouma yaini urafeisaya wei. (Waa boroma gasira ifine anakuro fiake ia iyare anaisa i ari) moi merama orouma uyafeisake Godinu wake naukaisa oroubairo fafeisake we ma berafiakaisaya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","31","Moi meomao orouma uyafeisake meo wake wefeisake we irufiakaisaro moi orouma emenu umuro aninao ufeisaba emua yawokenewaa ufiakau wei. Nama yabake imukari ukaada ii weada aine wai ure Godinu wake wenewaa ukeibisaraya wei. Nono awoenae ya Godibairo odimiauro Godima ya yawofiakua wei. ");
INSERT INTO aby_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Godinu wake naukenewaa uforo yanu imukeka ma irauaiai ufiake Danu we mune odirie orou yaisinabairo yanu ibeka orofa ma giena uke odifiakua wei. ");
INSERT INTO aby_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","34","Nama moi minu oini wau ereroma rooro uke naisa ure owere ma owere uke da ueke nanu wanama waiya ukaada naini nanu orounu urunaini wauini oima make muneibisaraya wei. ");
INSERT INTO aby_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ibake nanu ukeibisara i ari eno ufoke i buna me orou unu kofiakane weakunea wei. Eno weike nono wei, Yesunu wake imuke eawe wei, Yesuma eno wei, i erabusa makeka minu rooroe daiwere nono i muneka minu rooroe okoanakua Yesuma eno weia ibai imuke eawe Foruma eno wei. ");
INSERT INTO aby_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Foruma eno weiro emenu ifoma kududu yanaisake guriguri uisa. ");
INSERT INTO aby_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Eno uisake nono uyakake ii weada Foru yabaisake oo ukaada dawa nono da efeisia eno we imuisake imukari daiwere ukaada Foru boudi ubarenaro waure ane oisaro ani. ");
INSERT INTO aby_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Efesa goiro sosi yawokeibisa orou iro mediriekike boudi mukike Kosi goiro anisi. Iro ane aisike wai uriro uyaki. Uyakike ane Rouda goiro ane faki. ");
INSERT INTO aby_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ane fakike nono iroma Fadara goiro ane fakike iyanu boudi idua meisi. Meisike moi Fonisia orofaro aneibi boudiro amuisike iro anisi. ");
INSERT INTO aby_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","4","Aneebe ekara ena ewa ena dawararo naisaro Saifurasi weaisa dai orofa eraada ma bereisike Siria orofaro anisi. Aneebe i Daira weaisa goiro faki. I boudiro erabusa mune uwaforo odifisane ibake idua ane enaka. Ane enaka ibake isare anisike i goiro Godinu wake naukeibisa orou yodia ukeebe emuabairo fura demui emuaini idua ibisi. Godinu Imumu Irauma Danu wake naukeibisa oroubairo weiro i orouma Forubake eno we iifa ukaada eno weisa, Derusaremu goiro da ania weisa. ");
INSERT INTO 