﻿USE sofia;
DROP TABLE IF EXISTS sofia.abx_vpl;
CREATE TABLE abx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES abx_vpl WRITE;
INSERT INTO abx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yayto i ginikanan-na si Jesu-Kristo, i Dadi'-na si David pati' si Abraham: ");
INSERT INTO abx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","3","Si Abraham i tatay-na si Isaac nga iya i tatay-na si Jacob nga tatay-na si Juda pati' i mga bugtu'-na lalla. Si Juda i tatay-na kas Fares pati' Sara, ngan si Tamar i nana-na mga iya. Si Fares i tatay-na si Esrom nga tatay-na si Aram. ");
INSERT INTO abx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram i tatay-na si Aminadab nga iya i tatay-na si Naason nga tatay-na si Salmon. ");
INSERT INTO abx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon i tatay-na si Boas, ngan si Rahab i nana-na. Si Boas i tatay-na si Obed, ngan si Ruth i nana-na. Si Obed i tatay-na si Jesse ");
INSERT INTO abx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nga tatay-na si Hadi' David. Si David i tatay-na si Solomon, ngan i nana-na, alla-na dahulo si Urias. ");
INSERT INTO abx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon i tatay-na si Rehoboam nga iya i tatay-na si Abias nga tatay-na si Asa. ");
INSERT INTO abx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa i tatay-na si Jehosapat nga iya i tatay-na si Jehoram nga tatay-na si Usias. ");
INSERT INTO abx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias i tatay-na si Jotam nga iya i tatay-na si Ahas nga tatay-na si Esekias. ");
INSERT INTO abx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esekias i tatay-na si Manases nga iya i tatay-na si Amon nga tatay-na si Josias. ");
INSERT INTO abx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias i tatay-na si Jeconias pati' i mga bugtu'-na lalla si uras si kadistirru-na si mga a'a-na si Israel pan Babilonia bilang mga bihag. ");
INSERT INTO abx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pagkatapos si kadistirru-na mga iya pan Babilonia, si Jeconias i tatay-na si Salatiel nga tatay-na si Sorobabel. ");
INSERT INTO abx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel i tatay-na si Abiud nga iya i tatay-na si Eliakim nga tatay-na si Asor. ");
INSERT INTO abx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor i tatay-na si Sadok nga iya i tatay-na si Akim nga tatay-na si Eliud. ");
INSERT INTO abx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud i tatay-na si Eleasar nga iya i tatay-na si Matan nga tatay-na si Jacob. ");
INSERT INTO abx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob i tatay-na si Jose nga iya i sa'alla-na si Maria nga iya i nana-na si Jesus, i nag'arunan liwat Kristo. ");
INSERT INTO abx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sanglit bali katursi lut'o si ka'uru'ampuhan i tikang si Abraham pada'iray si David ngan katursi liwat gihapon i tikang namay si David pada'iray si kadistirru-na si mga a'a-na si Israel pan Babilonia. Tikang namay si uras si kadistirro, katursi gihapon lut'o tubtob si ka'allum-na si Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Da'ito sito i isturya hi'unong si ka'allum-na si Jesu-Kristo: Agpahanda-na si Jose i nanay-na nga si Maria. Ngan karaslon pa hamok mga iya, aniya' magpakatu'anan nga burod nayto dina pero yayto pagburod pina'agi si Espirito Santo. Ahinabo' to myintras pa aglabutan-na iya si Jose. Sanglit bali kuri si kamutangan-na si Jose kay si bala'ud-na mga iya kwintado nga agdangallahan na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngan tungod kay si Jose matadong a'a, agplano iya pagsunod si bala'ud-na mga iya nga agtugot pagbawi' si dati nagkasarabutan si pagdangallahan pero si sikrito pama'agi dina kay ga'i iya aruyag nga akamalu'an si Maria. ");
INSERT INTO abx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pero si kaliyat-liyatan si pagparapinsar-na sinan, agpakulaw i anghel-na si Paragdalom ari si upi, ngan agpinugad, “Jose, dadi'-na si David, dakaw agruha-duha pagpa'istar si Maria si ruma'-mo bilang alla-mo, kay i magtudok anan si iya tikang si Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sigurado lalla i ma'allom ngan kinahanglan Jesus i pina'arun-bi, kay iya i tisalbar si mga a'a-na basi' gana' na mga iya baratunun-na si sala' ngan basi' ga'i na mga iya sadaluman-na pa si sala'.” ");
INSERT INTO abx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ahinabo' nan dimu'an basi' atuman i nagpahalling-na si Paragdalom, pina'agi si paragsumat-na: ");
INSERT INTO abx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Aniya' magburod dangkanda nga ga'i pa akalabutan, ngan lalla i ma'allom dadi'-na. ‘Emmanuel’ i pina'arun-na, nga i kahulugan-na, ‘Atiya' i Diyos si kita’.” ");
INSERT INTO abx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sanglit pakakallat-na si Jose, agtuman-na i mandu'-na si anghel-na si Paragdalom ngan agkumpli-na dayon i dati pagkasarabutan si pagdangallahan-na mga iya. Agpa'istar-na si Maria si ruma'-na ");
INSERT INTO abx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pero ga'i aglabutan-na tubtob nga a'allom i dadi'-na, ngan ag'arunan-nay to Jesus. ");
INSERT INTO abx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngan panahun-na si Hadi' Herodes, a'allom si Jesus ari si Betlehem, Judea. Kahuman sinan hinabo', aniya' magpanakka si Jerusalem mga mata'o a'a tikang si sirangan, ");
INSERT INTO abx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nga agpamatilaw, “Singnga i dadi' ma'allom nga tihadi' si mga Hebro? Sakulawan kami' i bitu'on magpakatu'an si ka'allum-na nga agsirak ari si sirangan, ngan pada'ito kami' pagbuwan katalahuran si iya.” ");
INSERT INTO abx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Si pakabati'-na sinan si Hadi' Herodes, aburong iya huwang si mga sakup-na ari si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agtiripun-na i dimu'an mga puno' paraghalad-na si mga Hebro pati' mga paragturo' si bala'ud-na mga iya ngan agpantilaw-na, “Singnga ba' kuno' lugara a'allom i Tinu'inan Mannanalwas?” Anaruman mga iya, ");
INSERT INTO abx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Si Betlehem, Judea, kay yayto i nagsurat-na siray si paragsumat-na si Diyos: ");
INSERT INTO abx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Bisan ka'am magpangistar si Betlehem, Judea, ma'in ka'am i pinakaminos pamilya magpamuno' si Juda, kay aniya' puno' paluwa' anan si ka'am nga turu'inan-ko mangngataman si mga a'a-ko nga mga ka'uru'ampuhan-na si Israel.” ");
INSERT INTO abx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sanglit agpaban'u-na sikrito si Herodes i mga mata'o a'a ngan sakatu'anan-na tikang si mga iya i iksakto uras pagpakulaw-na si bitu'on. ");
INSERT INTO abx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Katapos, agpapada'iray-na mga iya si Betlehem ngan agtugunan-na, “Pada'iraya na kam ngan anda'u-bi pahalap i dadi' ngan kon sa'anda'an-bi pakatu'anu-bi ako basi' pada'iray may ako pagbuwan katalahuran si iya.” ");
INSERT INTO abx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pakabati'-na mga iya si tugun-na si hadi', pamalangngan dayon. Ngan pagparalangngan-na na mga iya, pakulaw gihapon i sakulawan-na mga iya bitu'on si sirangan ngan agdahulo si mga iya tubtob nga anyungod si nag'istaran-na si dadi'. ");
INSERT INTO abx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bali kalipay-na mga iya si pakakulaw-na mga iya si bitu'on. ");
INSERT INTO abx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Panakka-na mga iya si lugar, pasallod mga iya si ruma' ngan sakulawan-na i dadi' huwang si nanay-na Maria. Anluhod mga iya ngan agpangampo' ari si dadi'. Ag'abrihan-na mga iya i mga binawa-na rigalo ngan agpahalad mga iya mga bulawan, insinso, pati' mirra. ");
INSERT INTO abx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Katapos, agpa'upi-na mga iya si Diyos ngan agpanugunan-na nga ga'i na pahapit ari si Herodes. Sanglit, ag'agi na hamok mga iya si la'in lalan si pagpamalik-na mga iya si mga kalugaringun-na nasyon. ");
INSERT INTO abx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pakataliwan-na si mga mata'o a'a, agpakulaw i anghel-na si Paragdalom ari si upi-na si Jose. Agpinugad-na iya si anghel, “Banguna ngan ibakwitin i dadi' hasta i nanay-na pan Ehipto, kay tig'anda'-nay nan dadi' si Herodes ngan maratayun-na. Ari kam dahulo ag'istar ngan dakam pa'amban ari hasta nga ga'i kam pinugad-ko.” ");
INSERT INTO abx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pabangon si Jose, ngan ag'ibakwitan-na i dadi' huwang i nanay pan Ehipto. ");
INSERT INTO abx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ag'istar mga iya ari tubtob si pakamatay-na si Herodes. Ahinabo' nan pagtuman si nagpinugad-na si Paragdalom pina'agi si paragsumat-na siray, “Ban'u-ko i dadi'-ko paggawas ari si Ehipto.” ");
INSERT INTO abx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pakasabut-na si Herodes nga salabawan-na iya si kalistuhan-na si mga mata'o a'a, bali i kasina-na ngan agmando' iya diritso pagpanmatay si dimu'an mga kadadi'-dadi'an lalla si Betlehem tikang si dos anyos pan hawod, sigon si uras nga sakatu'anan-na tikang si mga mata'o a'a. ");
INSERT INTO abx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pina'agi sinan hinabo' atuman i mga allingun-na si paragsumat Jeremias nga agpinugad: ");
INSERT INTO abx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Aniya' kinabati'an mga busis ari si Rama nga bali pandinamag pati' bali i mga kabidu'an-na. Sigi dinamag si Raquel para si mga dadi'-na ngan andiri' kon nagli'aw iya, tungod kay agkamaratay na mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngan pakamatay-na si Herodes, aniya' upi-na si Jose ngan ari iya si Ehipto. Paluwa' gihapon i anghel-na si Paragdalom, ");
INSERT INTO abx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ngan aminugad, “Iya nayto i uras nga pwidi na sabalikan-mo i dadi' huwang i nanay-na pan Israel kay minatay na i mag'imamatay si dadi'.” ");
INSERT INTO abx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sanglit, pabangon si Jose ngan bawa-na i dadi' huwang i nanay-na pagbalik pan Israel. ");
INSERT INTO abx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero akabati' si Jose nga i manalli' hadi', iya si Arkilas, i dadi'-na si Herodes, sanglit atalaw iya pada'iray. Ngan tungod kay nagwaydungan iya si upi, agdiritso mga iya si Nasaret, nga baryo si prubinsya Galilea, ");
INSERT INTO abx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ngan ari na mga iya ag'istar. Tungod sinan atuman i nagpinugad-na si mga paragsumat-na si Diyos: “Ararunan iya Nasareno.” ");
INSERT INTO abx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Siray panahon paluwa' si Juan Paragbunyag si Disyirtu-na si Judea ngan agparawali, ");
INSERT INTO abx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Agbasula kam huwang si pagbag'o, kay matapit na gayod i paghadi'-na si man langit.” ");
INSERT INTO abx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iya i a'a nagtukuy-na si paragsumat Isaias: Aniya' addangan ari si disyirto nga agparapasamwak, “Hawani-bi i aragihan-na si Paragdalom; tadungu-bi i lalan ralangnganan-na.” ");
INSERT INTO abx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Agbado' si Juan si hiniro hinimo tikang si barahibu-na si kamel ngan agpaha iya tikang si anit-na si hayop. I kinakan-na duron pati' anira'. ");
INSERT INTO abx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nagdayo iya si mga a'a nga tikang si Jerusalem pati' si kaburubungtuhan si Judea hasta si dimu'an lugar matapit si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kahuman si pagparapangumpisal-na mga iya, agbunyagan-na mga iya si Juan ari si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero si pakakulaw-na si Juan nga padugok i mga Parisiyo pati' Sadusiyo ari si nagparabunyagan-na, agpangisugan-na mga iya, “Mga alisto kam gayod pagpamakunu-kuno! Say i magsumat si ka'am nga agpakalikay kam si titakka kastigu-na si Diyos kon agpamabunyag kam? ");
INSERT INTO abx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Agpakulawa kam dahulo pina'agi si mga buhat-bi nga agpamasol kam huwang si pagbag'o. ");
INSERT INTO abx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma'in nga agpanarig na kam hamok si mga kalugaringun-bi pagpinugad, ‘Tatay kami' may si Abraham.’ Kay sumatan-ta kam, bisan tikang sito mga kababatuhan akahimo i Diyos mga dadi' para si Abraham. ");
INSERT INTO abx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kay i kastigu-na akapariho si hatsa nga agpabantay-na andang si pu'un-na si mga kakayuhan, ngan bisan ay kayuha nga ga'i agbuwa' mahalap, tinabbong ngan pinabar'og. ");
INSERT INTO abx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Parti hamok si buwahi' i pagbunyag-ko si ka'am, pagpakulaw nga agpamasol na kam huwang si pagbag'o. Pero kahuman si ako, aniya' mabantog nga mas labaw pa i gahum-na. Ma'in ngani' ako angay bisan pagbitbit hamok si sapatus-na. Burunyagan-na i ditangnga' si mga a'a pagpa'ayop si Espirito Santo, pero burunyagan-na i ditangnga' paghusgar nga akapan'api. ");
INSERT INTO abx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aniya' andang nag'antanan-na tapan basi' sahimaliran-na i mga gini'ok ngan salalin-na ari si kamalig-na, pero papabar'ugon i mga babang si gana' kapaparungun-na api.” ");
INSERT INTO abx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sinan mga uras, anakka si Jesus ari si Suba' Jordan nga man Galilea basi' akapabunyag iya si Juan. ");
INSERT INTO abx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero agla'in-na kunta' dina si Juan i planu-na si pagpinugad, “Ako dina i magkinahanglan si titakka pagbunyag-mo. Ay kay ka'aw dina i padugok si ako.” ");
INSERT INTO abx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Anaruman si Jesus, “Pata'anin to hamok ina'anto kay angay gayod nga satuman-ta i dimu'an nagkinahanglan-na si Diyos.” Sanglit, angabuyon si Juan. ");
INSERT INTO abx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ngan akabunyagan na si Jesus, patukal iya si buwahi'. Hintak angabri i langit ngan sakulawan-na i Espiritu-na si Diyos nga pan hawod pada'iray si iya pariho si adda sarampati. ");
INSERT INTO abx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aniya' liwat kinabati'an busis tikang si langit nga agpinugad, “Iyay nan i Dadi'-ko nga hinigugma'-ko. Alipay gayod ako si iya.” ");
INSERT INTO abx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mangno aggiyahan-na si Jesus si Espirito kon singnga iya pa'arop ari si disyirto ngan ari iya agparatintar-na si Satanas. ");
INSERT INTO abx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kahuman si kwarinta diyas pagpu'asa-na allaw sangom, angabat iya kalingantuhan. ");
INSERT INTO abx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Padugok si iya i paratintar ngan aminugad, “Kon ungod kaw Dadi'-na si Diyos, tighimu'on daw mga batoy to, mga pan.” ");
INSERT INTO abx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Anaruman si Jesus, “Yayto i maka'anna' si Kasuratan: ‘Ga'i a'allom i a'a si kinakan hamok, kundi' sa'angkun-na i ungod kinabuhi' si kada allingon nga tikang si Diyos.’” ");
INSERT INTO abx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mangno, agbawa-na namay iya si Satanas pada'iray si sagrado syudad ngan agpatunggu-na iya si pinakamadyalta binubungan-na si templo. ");
INSERT INTO abx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aminugad si Satanas, “Kon ungod kaw Dadi'-na si Diyos, paluksuha daw, kay aka'anna' may si Kasuratan: Lihug-na i mga anghel-na pagpanginano si ka'aw, ngan mga iya i manarag si ka'aw, basi' ga'i akadabal si bato bisan i kitid-mo.” ");
INSERT INTO abx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Anaruman si Jesus, “Aka'anna' liwat si Kasuratan: ‘Dakam agpurbari-bi pagpirit i Paragdalom Diyus-bi nga sakulawan-bi i pagkadiyus-na.’” ");
INSERT INTO abx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kahuman sinan, agbawa-na namay iya si Satanas pada'iray si adda madyalta gayod bukid ngan agpakulaw-na iya si dimu'an mga ginhadi'an si kalibutan huwang i mga makawiwili kahalapan-na. ");
INSERT INTO abx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Agpinugad-na iya, “Pumwan-koy nan si ka'aw dimu'an kon anluhod kaw ngan angampo' si ako.” ");
INSERT INTO abx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Anaruman may si Jesus, “Pabulaga si ako Satanas! Kay yayto i maka'anna' si Kasuratan: ‘Ampu'in i Paragdalom Diyus-bi, ngan iya hamok i sinirbihan-bi.’” ");
INSERT INTO abx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mangno ag'ambanan-na iya si Satanas ngan pamadugok i mga anghel magpara'ataman si iya. ");
INSERT INTO abx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngan pakabati'-na si Jesus nga nagpriso si Juan, agbalik iya si Galilea. ");
INSERT INTO abx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pa'amban iya si baryo Nasaret, ngan palalin iya ag'istar ari si Capernaum. Yayto syudad awinan si bihing-na si Danaw Galilea, si pitak nga sakup-na si Sabulon pati' Neftali. ");
INSERT INTO abx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ahinabo' nan basi' atuman i nagsurat-na si paragsumat Isaias: ");
INSERT INTO abx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Aniya' mga taga sunsari'i si dati Sabulon pati' Neftali, i Galilea na ina'anto, nga urog i mga ma'in Hebro i magpangistar, kon singnga aka'anna' i pangngagihan si ligirun-na si danaw pati' si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Agpakakulaw to mga a'a nga malu'om i mga kinabuhi'-na si makagagahom danta', ngan agpakasirakan i mga magpakayungod si landung-na si kamatayon. ");
INSERT INTO abx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tikang sinan uras, agtikang si Jesus pagpasamwak, “Agbasula kam huwang si pagbag'o, kay matapit na gayod i paghadi'-na si man langit.” ");
INSERT INTO abx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngan pagparalalangngan-na si Jesus si bihing-na si Danaw Galilea, sakulawan-na i duwangan magdingsirarihan, si Simon nga kilala liwat si aron Pedro, pati' si Andres. Agtaktak-na mga iya i pukut-na siray uras kay pandaying may i mga paka'allum-na. ");
INSERT INTO abx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Agban'u-na mga iya si Jesus, “Tuwa kam, amaya'a kam ngan agsunura kam si ako basi' sapabawa-ko kam malabbat a'a pagtapod si Diyos pariho si kalabbat-na si daying nga sabawa-na si pukut-bi nan.” ");
INSERT INTO abx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mangno, aglabbahan-na dayon mga iya i mga pukut-na ngan amaya' si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ngan pira pa hamok i mga pitad-na, aniya' duwangan pa magdingsirarihan sakulawan-na si Jesus, nga kas Santiago pati' Juan, nga mga dadi'-na si Sebedeo. Agparaladlad-na mga iya i mga pukut-na ari si paraw, huwang i tatay-na mga iya. Agban'u-na mga iya si Jesus ");
INSERT INTO abx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ngan diritso ag'ambanan-na mga iya i sakayan-na, hasta liwat i mga tatay-na, ngan amaya' mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Aglibut-na si Jesus i bug'os Galilea ngan agparaturo' si mga sinaguga. Agparapasamwak-na i mahalap sumat kon pinapa'i i a'a akasakop si nagpanhadi'an-na si man langit ngan sigi pamulong si mga a'a nga mga binati'on pati' mga maburong. ");
INSERT INTO abx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Abantog dayon i mahi'unong si iya si bug'os prubinsya Siria, sanglit agpamawa-na si mga a'a i dimu'an magpangabat si pala'in-la'in binati', i mga mapaddi puhu'-na, i mga nagparapamawa-bawa si mara'at espirito, i mga buntugon pati' i mga irapa ngan intiro mga iya agbulung-na. ");
INSERT INTO abx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bali labbat i mamungyod si iya nga mga taga Galilea, mga magpangistar si lugar nag'arunan Awatong Syudad, mga taga Jerusalem, mga taga Judea hasta i magpangistar si dambila'-na si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pakakulaw-na si Jesus si magpanggubok, pasagka dina iya pan tagudtod, ngan anlumpagi'. Padugok si iya i mga inadalan-na ");
INSERT INTO abx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ngan agpanuru'an-na si pagpinugad: ");
INSERT INTO abx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mga malipayon i mga ga'i magpanapod si mga kalugaringun-na, kay mga iya i magpakasakop si mga nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mga malipayon i mga masurub'on, kay mga iya i mga rili'awon. ");
INSERT INTO abx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mga malipayon i mga mapa'inubsanon kay mga iya i papa'iridaron si kalibutan. ");
INSERT INTO abx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mga malipayon i mga linganto ngan mga uhaw si pagkamatadong, kay mga iya i papagustuhan. ");
INSERT INTO abx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mga malipayon i mga maluluy'on, kay mga iya i magpakakarawat si kalu'oy. ");
INSERT INTO abx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mga malipayon i mga gana' la'in tinago' si kasing-kasing-na, kay mga iya i magpaka'abat si paghuwang-na si Diyos tubtob nga sakulawan-nay to mga iya. ");
INSERT INTO abx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mga malipayon i mga masinagdunon, kay mga iya i nagkwinta-na si Diyos nga mga dadi'-na. ");
INSERT INTO abx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mga malipayon i mga nagparapamasakitan tungod si matadong mga binuhatan-na, kay mga iya i magpakasakop si mga nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mga malipayon kam kon nagparapanamyangan kam, nagparapamasakitan pati' nagparapamabati'-bati' nga akapara'at si ka'am tungod hamok si pagsunud-bi si ako. ");
INSERT INTO abx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Agkalipaya kam ngan agpanlaksiha kam, kay mahaya i sakarawat-bi primyo ari si langit, kay da'inan sinan gihapon i pa'agi-na mga iya pagparapamasakit si mga paragsumat-na si Diyos nga agpakadahulo si ka'am.” ");
INSERT INTO abx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Agpadayon si Jesus pagturo' si mga inadalan-na, “Ka'am i asiya-na si kalibutan. Sanglit dakam agpata'an. Pariho halimbawa' kon a'ala' na i kasira'-na si asiya, ga'i na apabwilta i kasira'-na. Gana' na gayod sinan pulus-na, sanglit angay naynan hamok nagtapukan basi' saturutum'akan-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ka'am liwat i danta'-na si bug'os kalibutan. I syudad nga aka'anna' si dyata'-na si bukid, ga'i gayod atago'. ");
INSERT INTO abx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gana' ato magsulsol lampara ngan tambunan-na dina si batiya'. Lugod, agpa'anna'-nay nan si tama' pamma'anna'an, para akadanta'an i dimu'an nga awinan si sallud-na si ruma'. ");
INSERT INTO abx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Si pariho pa'agi, pahayagu-bi i sana'an si ka'am nga makalupig si kalu'uman, basi' kinakulawan i mahalap binuhatan-bi ngan adayaw i Tatay-bi nga awiray si langit.” ");
INSERT INTO abx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Agpinugad si Jesus, “Dakam ag'isip nga pada'ito ako pagpara' si Bala'od pati' si Nagpanurat-na si mga Paragsumat. Ga'i ako pada'ito basi' apara' i mga turu'-na, kundi' i pagtuman dina si mga katuyu'an-na. ");
INSERT INTO abx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sumatan-ta kam si kamatu'uran, hasta nga ga'i apara' i kalangitan pati' i kalibutan, gana' may mapara' bisan adda litra o ma'in ngani' adda si mga madiki' baglis anan si Bala'od, hasta nga ga'i atuman i dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sanglit, bisan say i manupak maski adda hamok si mga mandu'-na sinan tungod kay gana' kuno' ka'impurtantihan-na, katapos agturo' pa liwat iya si la'in pag'irog si nagbuhat-na, aka'anggana'an may liwat iya si pwistu-na ari si mga nagpanhadi'an-na si man langit. Kundi' bisan say i magtuman sinan mga mando' si mga kinabuhi'-na ngan agparaturu'-nay nan si la'in, iya i makilala nga mahaya pwistu-na ari si mga nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kay sumatan-ta kam, kon angirog kam hamok si pagkamatadung-na si mga Parisiyo pati' si mga paragturo' bala'od, sigurado nga ga'i kam liwat agkakwirinta si nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Agpakapamati' kam nga aniya' mando' nagpakatu'an si mga a'a siray mga panahon, ‘Dakam agmatay,’ ngan bisan say i makamatay, paratukan iya. ");
INSERT INTO abx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero sumatan-ta kam nga bisan say i masina si igkasi a'a-na, paratukan iya. Ma'in nan hamok iya, bisan say i magtatsar si igkasi-na, aniya' sararumanan-na si Kunsiho. Ngan bisan ngani' i magyawit hamok, ‘Kapay-kapay kaw!’ sigurado nga akapan'impyirno. ");
INSERT INTO abx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Sanglit kon aniya' barawahun-mo pan altar paghalad si Diyos ngan sa'intuman-mo mismo sinan uras nga aniya' bali' sala'-mo si igkasi a'a-mo, ");
INSERT INTO abx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","labbahin dahulo i papahalarun-mo, ngan pada'irayon iya pagpakibagaw nga agsihalapay kam gihapon. Katapos, iya na kaw dina pabwilta paghalad si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Si uras nga nagbawa kaw si ka'asuntu-mo pan husgado, paniguruhon nga agkahalap kam myintras ga'i pa kam anakka ari, kay kon ga'i, iya si ka'aw i mangguyod pada'iray si huwis. Mangno i huwis na si ka'aw i mama'intriga si wardin pagpapriso si ka'aw. ");
INSERT INTO abx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sumatan-ta kaw si kamatu'uran, ga'i kaw akagawas ari si prisuhan, hasta nga ga'i sabayaran-mo bisan i ultimo na hamok sintabo si multa-mo. ");
INSERT INTO abx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sabati'an-bi liwat i mando' nga agpinugad, ‘Dakam agbisyo si pagdangallahan,’ ");
INSERT INTO abx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","pero sumatan-ta kam nga bisan say i maniplat si adda danda bawa i pagkasindak, akaparihoy nan si pagbisyo si pagdangallahan. ");
INSERT INTO abx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sanglit kon akapa'amban si pagtutu'u-mo i nagparakukulawan-na si mata-mo, ala'on adday nan ngan tapukin. Mas mahalap pa kon aka'ala'an kaw adda parti si puhu'-mo, kuntra kon gana' iban-na si puhu'-mo ngan linaho' kaw pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ngan kon akapa'amban si pagtutu'u-mo i nagparahimu-na si tamburu'-mo, uturon adday nan ngan tapukin. Mas mahalap pa kon aka'ala'an kaw adda parti si puhu'-mo, kuntra kon gana' iban-na si puhu'-mo ngan linaho' kaw pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aniya' liwat magparapaminugad, ‘Bisan say lallaha nga aruyag makibulag si alla-na, kinahanglan amaru'do' iya si papilis si pagbulag.’ ");
INSERT INTO abx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero sumatan-ta kam, i lalla nga pabulag si alla-na nga ga'i may to agbisyo si pagdangallahan-na mga iya, iya i aniya' baratunun-na si sala'-na si dati alla-na nga makitig'ob si la'in. Pwira pa sinan, i da'inan klasi pagbulag ma'in tugot si bala'od. Ngan bisan say i pakasal si nagbulagan danda, akasala' liwat iya si pagpakitig'ob si dati allahan. ");
INSERT INTO abx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Agpakabati' kam liwat nga nagtugunan i mga a'a siray mga panahon, ‘Dakam pasibog si mga sa'ad-bi, kundi' tumanu-bi kon ay i mga sa'ad-bi si Paragdalom.’ ");
INSERT INTO abx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero sumatan-ta kam, dakam gayod agtambahi-bi i mga sa'ad-bi si mga ga'i nan pwidi sadaluman-bi. Halimbawa' i pagpinugad, ‘Tistigos i langit,’ kay trunu-nay nan si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Dakam liwat agsabi si kalibutan, kay pannungtungan-nay nan si mga kitid-na o ma'in ngani' si Jerusalem, kay syudad-nay nan si Gilalabawi Hadi'. ");
INSERT INTO abx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ngan dakam liwat agsabi bisan pa i takuluk-bi kon agsa'ad kam, kay ga'i kam akapaputi' o akapahirom bisan adda hamok si mga barahibu-bi. ");
INSERT INTO abx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kunta' i naghimu-bi hamok, iya i pagtuman si mga sa'uhu'an-bi pati' i ga'i pagsalli' si mga sabaribadan-bi. Bisan ay nga tamba pa sinan, tawa'-na naynan si girara'ati. ");
INSERT INTO abx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sabati'an-bi na liwat nga nagpatugot siray, ‘Pwidi sapalaku-mo bayad i mata-na si makapirdi si mata-mo, o ma'in ngani' i impun-na si makapirdi si impun-mo.’ ");
INSERT INTO abx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero sumatan-ta kam, dakam angasa si mga a'a nga mara'at i binuhatan-na. Halimbawa', kon aniya' si ka'am manampalo si bayhun-bi, pa'atubangu-bi pa si iya i dambila'. ");
INSERT INTO abx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ngan kon aniya' magsumbong pagsiyo si dyakit-bi, pumwanon pa liwat si iya hasta i badu'-bi. ");
INSERT INTO abx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kon aniya' magpapalangkit si ka'am adda kilumitro, amaya'a si iya bisan pa anakka si kaduwa kilumitro. ");
INSERT INTO abx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kon aniya' mamalako si ka'am, buwanin, ngan dakam patalikot kon aniya' maruyag mag'indam si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sabati'an-bi na liwat i tugon, ‘Higugma'u-bi i igkasi a'a-bi ngan sikwayu-bi i mga kuntra-bi.’ ");
INSERT INTO abx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero sumatan-ta kam: Higugma'u-bi i mga kuntra-bi ngan pangadyi'i-bi i magparapamasakit si ka'am, ");
INSERT INTO abx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","basi' kinakulawan i mga kina'iya-bi nga irog si kina'iya-na si Tatay-bi nga awiray si langit. Agpasirakan-na si allaw-na i mga mara'at pati' i mga mahalap a'a ngan agbuwanan-na uran i mga matadong pati' i mga ma'in matadong. ");
INSERT INTO abx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ay i sakarawat-bi bulos kon aghigugma'-bi hamok i maghigugma' may si ka'am? Bisan i mga paragsukot buhis da'inan liwat sinan i nagparabuhat-na. ");
INSERT INTO abx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngan kon agbuhat kam hamok mahalap si mga bugtu'-bi, ay i sabuhat-bi nga labaw kuntra si ditangnga'? Bisan ngani' i mga a'a nga ga'i agtutu'o Diyos da'inan sinan i nagbuhat-na. ");
INSERT INTO abx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sanglit kinahanglan nga anakka kam si tama' pirmi pagdalom si kalugaringun-bi kay da'inan may sinan i langitnon Tatay-bi.” ");
INSERT INTO abx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Agpadayon si Jesus si pagturu'-na, “Agmatuha kam paghimo si mga matadong binuhatan-bi para hamok sakulawan-na si a'a. Kay kon agda'inan kam sinan, gana' na sakarawat-bi bulos tikang si Tatay-bi si langit. ");
INSERT INTO abx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sanglit kon aglimos kam si mga anggana', dakam agpangirog si mga a'a nga mahalap agparapamakunu-kuno nga mga rilihuso pina'agi si pagpabandilyu-na mga iya si mga nagbuhat-na ari si mga sinaguga pati' si mga kalsada para hamok nagdayaw si mga a'a. Sumatan-ta kam si kamatu'uran, sakarawat-na na mga iya i bug'os bulos nga nagpanhingyap-na. ");
INSERT INTO abx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lugod kon amuwan kam limos si mga anggana', dakam agpakatu'anu-bi i kawiri tamburu'-bi kon ay i naghimu-na si kawanan tamburu'-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Si da'inan pa'agi, ga'i kinatu'anan i pagbuwan-bi. Sanglit i Tatay-bi nga makasayod si sikrito nagbuhat-bi, iya i manprimyo si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kon agpangadyi' kam, dakam ag'irog si mga a'a nga mahalap agparapamakunu-kuno nga mga rilihuso pina'agi si karuyag-na mga iya pagpangadyi' nga agtutunggo ari si mga sinaguga pati' si mga iskina-na si mga kalsada para hamok kinakulawan si mga a'a. Sumatan-ta kam si kamatu'uran, sakarawat-na na mga iya i bug'os bulos nga nagpanhingyap-na. ");
INSERT INTO abx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lugod kon mangadyi' kam, pasallura kam si kwartu-bi, sirrahi-bi ngan mangadyi'a kam si Tatay-bi nga ga'i sakulawan-bi. Mangno i Tatay-bi nga iya i makasayod si sikrito pinahallingan-bi, iya i manprimyo si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ngan kon agpangadyi' kam, dakam agparaburubwiltahu-bi pariho si mga urasyun-na si mga a'a nga ga'i agtutu'o Diyos kay i mga pagkagasi-na nga kinapakalihan mga iya tungod si kalabbat-na si mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dakam angirog si mga iya, kay akatu'anan i Tatay-bi kon ay i mga nagkinahanglan-bi myintras pa kam amalako. ");
INSERT INTO abx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Lugod kon mangadyi' kam da'ituhu-bi sito: Tatay kami' nga awinan si langit, pakulawon ato si kinabuhi' kami' i kasagradu-na si arun-mo, ");
INSERT INTO abx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","dalumin kami' nga kinakulawan i paghadi'-mo ato, tumanon si kami' i katuyu'an-mo ato si kalibutan pariho si pagtuman-mo may si mga sari'i si langit. ");
INSERT INTO abx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Buwanin kami' si karakanon kami' nga tama' si ina'anto allaw. ");
INSERT INTO abx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasayluhon kami' si mga sala' kami', sigon si pagpasaylo kami' may si dimu'an makasala' si kami', ");
INSERT INTO abx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ngan patuttuton kami' nga ga'i kami' agsala' kon nagtintar kami', ngan patalahon kami' si aniya' mara'at katuyu'an-na. ");
INSERT INTO abx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kay basta agpasaylo kam si la'in nga akasala' si ka'am, pasaylu-na may kam liwat si Tatay-bi si langit. ");
INSERT INTO abx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero kon ga'i kam agpasaylo si sala'-na si la'in, ga'i may liwat pasaylu-na si Tatay-bi i mga sala'-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ngan kon agpu'asa kam, dakam angirog si mga a'a nga mahalap agparapamakunu-kuno nga mga rilihuso pina'agi si pagpaklaro nga masurub'on i mga bayhun-na huwang i pag'anna' agbon si mga takuluk-na, basi' kinatu'anan si mga a'a nga agpamu'asa mga iya. Sumatan-ta kam si kamatu'uran, sakarawat-na na mga iya i bug'os bulos nga nagpanhingyap-na. ");
INSERT INTO abx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lugod kon agpu'asa kam, agpanhupa kam ngan anguram'usa kam, ");
INSERT INTO abx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","basi' ga'i kinaklaruhan si mga a'a nga agpu'asa kam, kundi' i Tatay-bi nga ga'i kinakulawan iya hamok i makatu'anan sinan. Sanglit i Tatay-bi liwat i mamuwan si ka'am primyo, kay iya i makasayod si sikrito nagbuhat-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dakam agparatipon para si mga kalugaringun-bi manggad ato si kalibutan nga nagbaruki' o ma'in ngani' nagtakla' ngan pwidi liwat sarangka-na si mga mannangkaw i mga nag'anna'an-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lugod, agtipuna kam para si mga kalugaringun-bi manggad nan nga awiray si langit nga ga'i nagbaruki', ga'i nagtakla' ngan ga'i liwat pwidi sarangka-na si mga mannangkaw i nag'anna'an. ");
INSERT INTO abx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Buhatu-bi nan kay maski singnga kina'anda'an i kayamanan-bi, awiray may liwat ari i kabaraw-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","I mga mata-bi akapariho si lampara anan si puhu'-bi. Kon mahalap i mata-bi, panno' may si danta' i bug'os puhu'-bi. ");
INSERT INTO abx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero kon mara'at to, bali may liwat lu'om i puhu'-bi. Sanglit kon malu'om i danta' anan si puhu'-bi, day ay i kalu'um-na sinan! ");
INSERT INTO abx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Gana' ato makasirbi duwangan amo kay sigurado nga addangan hamok sinan i naghigugma'-na ngan addangan may i nagsikway-na. Ma'in ngani', unungan-na i kaduwangan ngan sikway-na i primiro. Gana' si ka'am makapadungan pagsirbi si Diyos pati' si manggad. ");
INSERT INTO abx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sanglit sumatan-ta kam, dakam abaraka mahi'unong si pagpanginabuhi'-bi kon ay i karakanun-bi pati' irinumun-bi o bisan mahi'unong si mga puhu'-bi kon ay i mga papabadu'un-bi. Ma'in hamok parti si pagkakan i kinabuhi' ngan ma'in hamok parti si pamado' i puho'. ");
INSERT INTO abx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kulawi-bi daw i mga manuk-manok nga agparapanlayug-layog; ga'i mga iya agsaburak ngan ga'i ag'ani o agparapangangkot pan kamalig, pero agtubungan-na mga iya si Tatay-bi ari si langit. Mas mahaya i balur-bi kuntra si kamanuk-manukan! ");
INSERT INTO abx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Say si ka'am i makapalanga bisan adda hamok uras si kinabuhi'-na pina'agi si kabaraka-na? ");
INSERT INTO abx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Dakam liwat abaraka si pagpanaptun-bi. Kulawi-bi daw i ka'angayan-na si mga lalag burak. Ga'i mga iya agballi ngan ga'i aghimo. ");
INSERT INTO abx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kundi' sumatan-ta kam, bisan si bug'os kayamanan-na si Hadi' Solomon gana' sapasul'ut-na pariho kahalap si adda sinan mga burak. ");
INSERT INTO abx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Agpamanaptunan-na ngani' mahalap si Diyos i mga gabon si katahuk-tahukan, nga allom ina'anto pero papabar'ugon asumo, ka'am pa ba' i ga'i pinanaptunan-na mahalap? Kulang pa kam si pagtapod! ");
INSERT INTO abx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sanglit dakam agparapaminugad, ‘Ay daw sito i karakanun-ta?’ ‘Ay daw sito i irimnun-ta?’ pati' ‘Ay daw sito i pagpanaptun-ta?’ ");
INSERT INTO abx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iyay nan i mga kahuruwangan-na si dimu'an nagparapanhingyap-na si mga ga'i magpanutu'o Diyos ngan sakatu'anan-na na si langitnon Tatay-bi i nagkinahanglanan-bi sinan. ");
INSERT INTO abx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lugod padahulu'u-bi i pag'anda' si pa'agi nga agpakasakop kam si mga nagpanhadi'an-na si Diyos hasta i pagkamatadung-na, ngan pinumwan may liwat nan dimu'an mga inanna' si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sanglit dakam agkabarakahi-bi i asumo kay katungdanan-na si manunod allaw pagpanginano si kalugaringun-na. I kasibutan-na si kada allaw, tama' hamok nga sa'agwanta-na si a'a para sinan allaw.” ");
INSERT INTO abx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Agpadayon si Jesus si pagturu'-na, “Dakam aghusgar, basi' ga'i may kam husgaran-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay bisan ay i nagpahusgar-bi si la'in, iya may i nagpahusgar-na si ka'am. Ngan bisan ay i nagsukulan-bi, iya may i surukulan pagpabalik si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ay kay sakulawan-mo lugod i day panarutsuhan nga makabuta si igkasi a'a-mo, pero ga'i sapanginanu-mo i day gip'at nga makasalingkop si kalugaringun-mo mata? ");
INSERT INTO abx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pinapa'i-mo may pakapinugad si igkasi-mo, ‘Ala'an-ta kaw si makabutay nan si ka'aw,’ nga aniya' may makasalingkop si kalugaringun-mo mata? ");
INSERT INTO abx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mahalap kaw gayod agsilhig si hawan-na si la'in! Ala'on dahulo i makasalingkop si mata-mo, ngan kahuman sinan saklaru-mo na ngan sa'ala'-mo i makabuta si igkasi-mo. ");
INSERT INTO abx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma'in angay si pirlas nga nagpa'itsa hamok si mga kabaktinan kay sigurado nga panurutum'akan-nay nan hamok. Si pariho pa'agi, aniya' mga sagrado nga ma'in angay nagpatubong si ka'idu'an, kay si pakatibus-na sinan bangin ka'am na i inatubang-na ngan pamang'alan-na. ");
INSERT INTO abx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Amalakuha kam basi' binuwanan kam. Mamuraw-purawa kam basi' aniya' sa'anda'an-bi. Aman'uha kam basi' pinadayon kam. ");
INSERT INTO abx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Buhatu-bi nan kay bisan say i mamalako akabuwanan, ngan bisan say i mamuraw-puraw aka'anda', ngan bisan say i maman'o agpakadayon. ");
INSERT INTO abx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ay kaw klasiha a'a nga kon amalako pan i dadi'-mo, buwanan-mo dina bato? ");
INSERT INTO abx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ma'in ngani', kon amalako iya daying, buwanan-mo dina sawa? ");
INSERT INTO abx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pa'anna'-ta si ka'am may, bisan kon mga mara'at i kina'iya-bi dimu'an, agbuwan kam mga mahalap rigalo si mga dadi'-bi. Iya pa ba' i Tatay-bi ari si langit i ga'i mamuwan si mga mahalap si magpamalako sinan si iya! ");
INSERT INTO abx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sanglit bisan ay i naghingyap-bi binuhat-na si la'in para si ka'am, buhatu-bi nan, kay yaynan i katumanan-na si Bala'od pati' si Nagpanurat-na si mga Paragsumat. ");
INSERT INTO abx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aniya' duwa pwirtahan panggawas: I adda masi'ok ngan i adda may mahaway. Malabbat i magpili' si mahaway nan kay si panlahus-na mga iya, masayon na i paglalangngan-na, bisan kon aka'abat mga iya nga iyay nan dina i magpatuttot si mga iya si kamatayon nga bulag si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lugod pili'u-bi i masi'ok bisan kon makuri i paglalangngan-bi ngan diki'it hamok i kahuruwangan-bi, kay iyay nan i lalan pada'iray si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Agbantaya kam si mga burubullo' paragsumat-na si Diyos. Pamadugok nan si ka'am nga day mga karniro i mga kiwa-na, pero i ungod gayod mga kina'iya-na mga iya akapariho si mga ma'isog hayop. ");
INSERT INTO abx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sakilala-bi nan mga iya pina'agi si mga panggawi'-gawi'-na. Gana' ato magpangko' ubas nga tikang dina si pu'un-na si tangulon o ma'in ngani' i prutas igos nga tikang dina si pu'un-na si sapinit. ");
INSERT INTO abx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pariho si kamutangan-na si kayo, basta marabong i pu'on, sigurado nga mahalap may sinan i binuwa'-na, pero kon bigik i pu'on, sigurado nga mara'at may liwat sinan i binuwa'-na. ");
INSERT INTO abx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I marabong pu'on impusibli nga mara'at i binuwa'-na, ngan mahalap dina i binuwa'-na si bigik pu'on. ");
INSERT INTO abx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I kada pu'on si kayo nga ga'i agbuwa' mahalap, tinabbong ngan pinabar'og. ");
INSERT INTO abx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sanglit pina'agi si mga buwa'-na i pagkilala si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ma'in i dimu'an magparaban'o si ako, ‘Paragdalum-ta kaw, Paragdalum-ta kaw,’ nga kwintado na si nagpanhadi'an-na si man langit, kundi' i mga kwintado hamok iya i magtuman si katuyu'an-na si Tatay-ko nga awiray si langit. ");
INSERT INTO abx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kon anakka na i allaw si paghusgar, malabbat i maminugad si ako, ‘Paragdalom, Paragdalom, ma'in ba' agpahalling kami' i makigpasumat-mo pina'agi si gahum-na si arun-mo, ngan agpakapapinda kami' si mga mara'at espirito mismo liwat sinan aron, hasta pa agpakahimo kami' si mga makagagahom binuhatan?’ ");
INSERT INTO abx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero diritsu-ko mga iya agsaruman, ‘Ga'i kam sakilala-ko. Patalaha kam si ako kay puro kam paragbuhat si karat'an!’ ");
INSERT INTO abx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kon sugad, i makapamati' si mga allingun-ko pati' magtuman sito si kinabuhi'-na, akapariho si madunong a'a magtindog ruma' si dyata'-na si bato. ");
INSERT INTO abx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Si panguran-na makusog, paluwa' i mahaya baha' ngan sakub-na payray ruma' si makusog bariyo pero ga'i to arungkab, kay takka si bato i pundasyun-na. ");
INSERT INTO abx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kundi' i makapamati' si mga allingun-ko pero ga'i to atuman si kinabuhi'-na, akapariho si ma'in madunong a'a magtindog ruma' si dyata'-na si baybay. ");
INSERT INTO abx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Si panguran-na makusog, paluwa' i mahaya baha' ngan sakub-na payray ruma' si makusog bariyo ngan diritsoy to arungkab hasta nga ga'i gayod nag'arim-ariman i bug'os ruma'!” ");
INSERT INTO abx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pakahuman-na si Jesus agpahalling sinan dimu'an, ag'usa i magpanggubok, ");
INSERT INTO abx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kay si pagturu'-na, akapariho iya si addangan nga aniya' pwirsa-na si mga allingun-na pagpasunod, ma'in pariho si mga paragturu'-na mga iya bala'od. ");
INSERT INTO abx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ngan pamadalugdug-na kas Jesus tikang si tagudtod, nagburungyuran iya si ka'aha'an. ");
INSERT INTO abx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aniya' liprusuhon padugok si iya ngan anluhod atubang si iya. Aminugad to, “Sinyor, sapahalap-mo gad ako, kon aruyag kaw.” ");
INSERT INTO abx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Agdu'unan-na si palat-na si Jesus i lalla ngan aminugad, “Oho' gad, buhat-koy nan. Anhalapa!” A'ala' dayon i liprusu-na ngan anlimpyo iya. ");
INSERT INTO abx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mangno agtugunan-na iya si Jesus, “Agmatuha nga ga'i kaw akasumat si la'in a'a parti sito, pero pada'iraya si paraghalad ngan pakulawon si iya i puhu'-mo. Tighalara ari si nagmandu'-na si Moises para si manhalap basi' kinatu'anan nga nagparatuman pa i Bala'od.” ");
INSERT INTO abx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ngan pasallud-na si Jesus si syudad Capernaum, aniya' padugok si iya addangan sinturyon pagpalako si bulig-na. ");
INSERT INTO abx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aminugad to, “Sinyor, awiray agparalibbak si ruma' i rilihugun-ko. Adda iya irapa ngan bali na i inantus-na kasakitan.” ");
INSERT INTO abx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Agpinugad-na iya si Jesus, “Hala kay pada'iray ako ngan pahalap-ko iya.” ");
INSERT INTO abx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Anaruman may i sinturyon, “Sinyor, pero ma'in ako angay pagpadagos si ka'aw si ruma'-ko. Kundi' amusngala hamok kay sigurado anhalap i rilihugun-ko. ");
INSERT INTO abx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Da'inan sinan i pagtu'u-ko kay adda may liwat hamok ako rilihugon nga ata'o pagsunod si mga malanga katungdanan-na, ngan aniya' may liwat mga sundalu-ko nga salihug-ko. Aminugad ngani' ako si addangan, ‘Pada'iraya,’ diritsoy to dayon pa'amban. Si addangan ray namay, ‘Tuwa,’ sigurado padugok to si ako. Aminugad ngani' ako si rilihugun-ko, ‘Trabahu'on to,’ diritsoy to dayon trabahu-na.” ");
INSERT INTO abx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pakabati'-na sinan si Jesus, ag'usa-nay nan gayod ngan agpinugad-na i mga a'a magpamungyod si iya, “Sumatan-ta kam, ga'i pa ako aka'anda' a'a nga da'inan kahaya i pagtutu'u-na ato si bug'os Israel. ");
INSERT INTO abx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pinugad-ta kam nga malabbat i pamadugok tikang si sirangan pati' si katundan ngan pamasintar agtingkulo' huwang si kas Abraham, Isaac pati' si Jacob si pakan nagtima para si nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero i mga ginsakupan-na gayod kunta' sinan ginhadi'an, tarabrugon dina pan gawas, si lugar nga bali lu'om kon singnga agparapangaraba ngan agparapanrigot mga iya.” ");
INSERT INTO abx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mangno agpinugad-na si Jesus i sinturyon, “Agbalika na ari! Turumanon na i nagsiguru-mo nga sabuhat-ko.” Ngan mismo siray uras, anhalap i rilihugun-na. ");
INSERT INTO abx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Si pamanahik-na si Jesus si ruma'-na kas Pedro, sakulawan-na i ugangan-na danda sito nga agparalibbak tungod kay mapanas iya. ");
INSERT INTO abx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ag'antanan-nay to si tamburo' ngan a'ala' i panas-na. Mangno manginanoy to dayon pagkiwa para si iya. ");
INSERT INTO abx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kasanguman, malabbat mga a'a i nagbawa pada'iray si Jesus nga nagpamawa-bawa si mara'at espirito ngan agpamapinda-nay nan mga espirito pina'agi si allingun-na. Agpamahalap-na liwat i dimu'an mga maburong. ");
INSERT INTO abx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ahinabo' nan basi' atuman i allingun-na si paragsumat Isaias: Iya i mag'antos si mga mara'at alabatan-ta kam ngan iya i mag'ako' si mga binati'-ta kam. ");
INSERT INTO abx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Si pakakulaw-na si Jesus si magpanggubok si iya, anmandar iya nga patalabok mga iya pan dambila'-na si danaw. ");
INSERT INTO abx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dungan sinan, aniya' si iya padugok addangan paragturo' bala'od ngan aminugad, “Ma'istro, amungyod ako si ka'aw bisan singnga kaw pa'arop.” ");
INSERT INTO abx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Anaruman si Jesus, “Mahalap pa i mga singgarong kay aniya' mga panluluku'an-na, pati' i mga kamanuk-manukan kay aniya' pannanapunan-na, pero i Pinili' A'a, gana' ngani' lugod panlilibbakan-na nga akadiskanso iya.” ");
INSERT INTO abx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mangno aniya' namay addangan si mga inadalan-na i maminugad si iya, “Sinyor, tugutin ako dahulo pagbalik hasta si pakamatay-na si tatay-ko.” ");
INSERT INTO abx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero agpinugad-na dina iya si Jesus, “Amaya'a ngan agsunura si ako. Pata'anin na hamok nga i mga minatay i mamalabbong si mga minatay-na.” ");
INSERT INTO abx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Si pasang'at-na si Jesus si paraw, anunod si iya i mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kata'ud-ta'uran, hintak anmadlos i danaw nga haros akatambunan i paraw si mga mahaya alon. Pero mahalap dina i pamaturi-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sanglit nagdugok iya si mga inadalan-na ngan nagpukaw, “Sinyor, salbaron kami'! Matutulluron na kita kam!” ");
INSERT INTO abx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Anaruman may iya, “Kulang pa kam si pagtapod. Ay kay agkataralaw kam?” Mangno pabangon iya ngan agpugungan-na i bariyo pati' i mga alon, ngan hintak anlinaw. ");
INSERT INTO abx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ag'usa mga iya ngan agsipurupatilaway, “Ay ba' to aha'a? Bisan i bariyo pati' i mga alon agpansunod si iya!” ");
INSERT INTO abx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Panakka-na mga iya si dambila', ari si lugar-na si mga Gadareno, aniya' manupo' si iya duwangan a'a nga nagpamawa-bawa si mara'at espirito. Tikang nan mga iya si adda si mga kwiba panlalabbungan. Bali mga iya kamama'isog sanglit gana' makalabay ari siray lugar. ");
INSERT INTO abx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Anurakaw mga iya, “Ay i tuyu'-mo si kami', Dadi'-na si Diyos? Pad'ito ba' kaw pagpasakit si kami' myintras anakka si tala'an allaw?” ");
INSERT INTO abx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aniya' magtarambak kabaktinan matapit si mga iya nga sigi pamu'ad. ");
INSERT INTO abx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agparapakimalu'oy i mga mara'at espirito si Jesus, “Kon papinda-mo kami', pabawahon kami' pada'iray si kabaktinan ray.” ");
INSERT INTO abx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Agpaminugad-na mga iya, “Hala pada'iraya na kam!” Sanglit pamaguwa' i mga mara'at espirito ngan diritso pamabalyo si kabaktinan. Mangno palahi i bug'os grupo pada'iray si pangpang diritso si buwahi' ngan agkamaratay. ");
INSERT INTO abx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pamalahi i magpangataman si kabaktinan pan syudad ngan agpamasamwak-nay nan dayon mga iya huwang na i dimu'an mahinabo' si mga nagpamawa-bawa si mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sanglit agpamada'iray si Jesus i a'a-na si bug'os syudad pagbagat si iya. Si pakabagat-na mga iya sito, sigi mga iya pamakimalu'oy nga kon pwidi pa'amban iya si mga lugar-na. ");
INSERT INTO abx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Amanakay kas Jesus si paraw ngan pamatalabok gihapon si danaw hasta nga anakka mga iya si kalugaringun-na syudad. ");
INSERT INTO abx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mangno aniya' magpanakka nga agpamawa irapa pada'iray si iya nga naghulid si tipo. Ngan pakakulaw-na si Jesus si pagtapud-na sinan mga a'a, agpinugad-na i irapa, “No', pabaskugon i huna'-huna'-mo. Nagpasaylo na i mga sala'-mo.” ");
INSERT INTO abx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tungod sinan, sigi panngurub-ngurob i mga paragturo' bala'od nga magtambong ari, “Aglalabawan-na sito a'a i Diyos.” ");
INSERT INTO abx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Akatu'anan si Jesus si mga inisipan-na, sanglit amatilaw iya, “Ay kay da'inan sinan i inisipan-bi? ");
INSERT INTO abx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Singnga sito i masayon: I pagpinugad, ‘Nagpasaylo na i mga sala'-mo’ o i pagpinugad, ‘Anungguha ngan alangngana’? ");
INSERT INTO abx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero, basi' sakatu'anan-bi nga i Pinili' A'a aniya' gahum-na ato si kalibutan pagpasaylo si mga sala', palangngan-koy to irapa.” Mangno agpinugad-na i irapa, “Anungguha, addu'on naglibbakan-moy nan ngan agbalika.” ");
INSERT INTO abx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Anunggo iya ngan aglugaring pagbalik. ");
INSERT INTO abx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pakakulaw-na sinan si magpanggubok, agpakadayaw mga iya si Diyos bawa i mahaya pagtahod si iya tungod si pagbuwan-na si a'a si da'inan klasi gahom. ");
INSERT INTO abx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Si paduwa'i-na gihapon si Jesus tikang si nag'istaran-na, samasiran-na namay si Mateo nga agparatingkulo' si pwistu-na si pannunukutan-na buhis. Agpinugad-na iya si Jesus, “Amaya'a ngan agsunura si ako.” Anunggo si Mateo ngan amaya' si iya. ");
INSERT INTO abx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mangno aniya' allaw nga ari kas Jesus si ruma'-na kas Mateo. Malabbat i pamadugok mga paragsukot buhis pati' mga nagpaminugad makasasala' ngan makitangka' si iya pagkakan huwang si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pakakulaw-na sinan si pamalabay mga Parisiyo, agtilaw-na mga iya i mga inadalan-na si Jesus, “Ay kay makihuwang ma'istru-bi nan pagkakan si mga paragsukot nan buhis pati' si mga makasasala' nan?” ");
INSERT INTO abx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngan pakatu'an-na si Jesus sinan, mismo iya i manaruman, “Ma'in i mga mahalap a'a i magpanginahanglan duktor, kundi' i mga maburong dina. ");
INSERT INTO abx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pero agpamalika kam ngan manginsayura kam dahulo si mga allingun-na si Diyos nga maka'anna' si Kasuratan: ‘Gana' kapulsanan-na si ako i pagkarilihusu-bi pariho si pagbuno' mga panhahalad kon ga'i dahulo sakulawan-ko i pagkamaluluy'un-bi.’ Ngan da'inan may, ga'i ako pada'ito pag'agda si magpaminugad nga matadong mga iya a'a, kundi' pada'ito ako pag'agda si mga makasasala'.” ");
INSERT INTO abx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Siray, aniya' mga nagpili' allaw si pagpu'asa basi' gana' la'in kinapinsaran pwira hamok si Diyos. Sanglit aniya' pamadugok mga inadalan-na si Juan ngan agpamatilaw si iya, “Ay kay ga'i agsunod i mga inadalan-mo si kabatasanan pagpu'asa pariho si mga nagbuhat kami' pati' si mga Parisiyo?” ");
INSERT INTO abx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Anaruman si Jesus, “Ga'i may gad ahimo nga abido' dina i mga imbitadu-na si kinasal lalla kon awinan pa iya. Pero ma'in na pira arala'on na i makapariho si kinasal lalla, ngan sinan uras, iya na dina i pagpu'asa-na si mga inadalan-ko.” ");
INSERT INTO abx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Agsumatan-na liwat mga iya sito isturya nga agtukoy si kamatu'uran: “Gana' magpatangbil si baha'o hiniro si adda kada'an na bado'. Kay kon da'ito sito i pagtangbil-mo, gisi'-na gihapon i badu'-mo si nagpatangbil-mo. Mas mara'at to kagisi'an kuntra si dahulo.” ");
INSERT INTO abx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Agsumatan-na mga iya si adday to pa: “Gana' magpa'isi si baha'o irimnon si kada'an na anit pangngingisihan, kay amura' to kon pa'isi-mo, mangno aburhat i pangngingisihan ngan atumpa i irimnon. Ma'in da'inan sinan. Kunta', i baha'o irimnon, pina'isi may si baha'o pangngingisihan, basi' gana' mapirdi si duwa.” ");
INSERT INTO abx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Si pagparapahalling-na si Jesus, aniya' manakka puno' nga paluhod dayon atubang si iya ngan makimalu'oy, “Pakamatay-na pa hamok si dadi'-ko danda ina'anto. Pero alayon baya'on ako ngan du'unin iya si palat-mo basi' anlanga pa i kinabuhi'-na.” ");
INSERT INTO abx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Patunggo si Jesus hasta i mga inadalan-na ngan amaya' si iya. ");
INSERT INTO abx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Siray uras, aniya' danda ari nga agparalalaha' dusi na ta'on. Patapit iya si damurihan-na ngan agsaphid-na i sidsid-na si badu'-na si Jesus, ");
INSERT INTO abx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kay aka'anna' si huna'-huna'-na si danda, “Kon sasaphid-ko bisan hamok i badu'-na, sigurado anhalap ako.” ");
INSERT INTO abx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Anili' si Jesus ngan sakulawan-na i danda. Aminugad iya, “Mana, pabaskugon i huna'-huna'-mo. I pagtutu'u-mo, iya i makapahalap si ka'aw.” Ngan mismo siray uras, anhalap dayon i danda. ");
INSERT INTO abx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ngan panakka-na na si Jesus si ruma'-na si puno', sakulawan-na i mga musikiro si paglabbong pati' i kasamukan-na si magpanggubok. ");
INSERT INTO abx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Animol si Jesus, “Pagawasa kam anan. Ma'in pa iya gayod i kamatayun-na si dadi'. Yayto kamatayon, pariho hamok si magpaturi.” Pero nagpattawahan dina si Jesus si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kahuman si pakapagawas si mga a'a, pasallod iya pan kwarto. Agbikyaw-na i tamburu'-na si dadi' ngan diritsoy to pabangon. ");
INSERT INTO abx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Agsamwak dayon i sumat mahi'unong sinan si dimu'an parti ari siray lugar. ");
INSERT INTO abx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Si pagparalalangngan-na si Jesus tikang ari siray lugar, aniya' duwangan buta lalla nga agpamungyod si iya ngan sigi panurakaw, “Dadi'-na si David, kalu'uyin kami'!” ");
INSERT INTO abx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngan pamanahik-na si Jesus si adda ruma', padugok i duwangan buta si iya ngan agtilaw-na, “Anutu'o ba' kam nga sahimu-koy to?” Anaruman may mga iya, “Oho', Sinyor.” ");
INSERT INTO abx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Katapos, addu'-na si Jesus i mga mata-na si duwangan ngan aminugad, “Sigon si pagtapud-bi, iya i mabuhat si ka'am.” ");
INSERT INTO abx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Akakulaw dayon mga iya pariho si dati. Agtugunan-na gayod mga iya si Jesus, “Aghinaya kam nga ga'i kam akasumat si bisan say mahi'unong sito.” ");
INSERT INTO abx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero pamagawas dina mga iya ngan agpanumat-na i hinabo' mahi'unong si Jesus si dimu'an parti ari siray lugar. ");
INSERT INTO abx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Si paduwa'i-na si duwangan, aniya' manakka mga a'a magpamawa pada'iray si Jesus ngula lalla nga nagbawa-bawa si mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ngan pakapapinda si mara'at espirito, akayawit dayon i ngula. Ag'usa i magpanggubok ngan agpaminugad, “Gana' pa kinakulawan pariho sito ato si Israel tikang pa si tinikangan.” ");
INSERT INTO abx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero agpaminugad dina i mga Parisiyo, “Akapapinda iya si mga mara'at espirito pina'agi si gahum-na si prinsipi-na si dimu'an mara'at espirito.” ");
INSERT INTO abx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mangno aglibot si Jesus si dimu'an mga kaburubungtuhan pati' mga kaburubaryuhan ngan agparaturo' si mga sinaguga. Agparapasamwak-na i mahalap sumat kon pinapa'i i a'a akasakop si nagpanhadi'an-na si man langit ngan sigi pamulong si mga a'a nga mga binati'on pati' mga maburong. ");
INSERT INTO abx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bisan singnga iya akakulaw magpantarambak, alu'oy gayod iya kay panno' mga iya si mga kabaraka ngan mga disgustado. Day pariho mga iya si mga karniro nga gana' mangngataman. ");
INSERT INTO abx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mangno agpinugad-na i mga inadalan-na, “Malabbat kunta' i aranihon pero diki'it hamok i mangngangani. ");
INSERT INTO abx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aniya' paragdalom si aranihon nga iya i pinalakuhi-bi pagpabawa pa mga trabahanti si nagpa'anihan-na.” ");
INSERT INTO abx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mangno agtiripun-na si Jesus i Dusi ngan agpamuwanan-na gahom pagpapinda si mga mara'at espirito pati' pagbulong si mga binati'on pati' si mga maburong. ");
INSERT INTO abx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yayto i mga arun-na si dusi apostol: I primiro si Simon nga kilala liwat si aron Pedro, si Andres nga sirari-na, si Santiago pati' Juan nga mga dadi'-na si Sebedeo, ");
INSERT INTO abx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe, si Bartolome, si Tomas, si Mateo nga paragsukot buhis, si Santiago nga dadi'-na si Alfeo, si Tadeo, ");
INSERT INTO abx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon nga sakop si grupu-na si mga Selote, pati' si Judas Iscariote i titraydor si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aglihug-na si Jesus i Dusi ngan agpanugunan-na, “Dakam pa'agi si mga lugar nag'istaran-na si mga ma'in Hebro o pasallod si mga bungtu-na si mga Samaritano. ");
INSERT INTO abx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lugod, anda'u-bi i mga a'a-na si Israel nga akapariho si mga magkaralilingo karniro. ");
INSERT INTO abx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Si paglibut-bi, yayto i pinasamwaku-bi: ‘Matapit na gayod i paghadi'-na si man langit.’ ");
INSERT INTO abx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bulungu-bi i mga maburong, allumu-bi gihapon i mga minatay, pahalapu-bi i mga liprusuhon, ngan pamapindahu-bi i mga mara'at espirito. Tungod kay agsangya i pagkarawat-bi ngan ga'i may nan agbayaran-bi, da'inan may liwat kunta' i pa'agi-bi si pagbuwan-bi. ");
INSERT INTO abx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dakam agpasuksok si rilus-bi bisan ay diplataha, bisan salapi', bulawan o burunsi. ");
INSERT INTO abx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dakam agbawa bag para si langngan-bi, dakam agbawa pagsalinan, sandalyas o bisan baston kay angay hamok nga nagpanginano i trabahanti. ");
INSERT INTO abx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kon akatakka kam si bisan singnga bungtuha o baryuha, anganda'a kam si matadong nan a'a sinan lugar nga awili pagpa'istar si ka'am ngan dakam palalin si la'in ruma' tubtob si pagtaliwan-bi. ");
INSERT INTO abx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Si pamanahik-bi, aminugara kam, ‘Pumwan-na kunta' i kamurayaw-na si Diyos si dimu'an mag'istar sito ruma'.’ ");
INSERT INTO abx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kon aghandom i panimalay pagkarawat sinan, angay gayod nga i kamurayaw-bi abilin si mga iya. Pero kon ga'i aghandom, angay nga abawi' nan gihapon si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kon aniya' a'a nga andiri' si ka'am, o ma'in ngani' ga'i amakali si mga allingun-bi, pataliwana kam sinan ruma' o bungto ngan paspasu-bi i alpug-na si kitid-bi. ");
INSERT INTO abx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sanglit sumatan-ta kam si kamatu'uran, si allaw si paghusgar, mas maningkarang pa i arabatun-na kastigo si magpangistar siray si mga syudad Sodom pati' Gomora kuntra si arabatun-na sinan bungto mismo liwat sinan allaw. ");
INSERT INTO abx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Agmatuha kam kay ari si papabawahan-ko si ka'am akapariho kam hamok si mga karniro nga akasalakot si mga ma'isog hayop. Sanglit angiruga kam si sawa nga mata'o paglikay si kadilikaduhan, ngan si pariho uras angiruga kam si sarampati nga ga'i ata'o aglabot. ");
INSERT INTO abx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Agmatuha kam si mga a'a kay mga iya si ka'am i mamadakop ngan pa'intriga-na kam mga iya si mga kunsiho, ngan karastiguhon kam ari si mga sinaguga-na mga iya ");
INSERT INTO abx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","tungod si ako. Pwira pa sinan, daragnason liwat kam pag'atubang si mga gubirnador pati' si mga hadi' basi' akatistigos kam si mga iya hasta si mga ma'in Hebro si ungod mahinabo'. ");
INSERT INTO abx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero si uras nga padakup-na kam mga iya, dakam abaraka kon papa'i-bi pagpamatu'od si pagkamatadung-bi ngan kon ay i mga papahallingun-bi. Kay sinan uras, pinumwan si ka'am i mga papahallingun-bi. ");
INSERT INTO abx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I mga allingon ma'in tikang si kalugaringun-bi, kundi' tikang si Espiritu-na si Tata' nga ka'am hamok i nagpapahalling-na. ");
INSERT INTO abx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Trarayduran-na pagmatay si mga sirari i mga siyaka-na magpanutu'o. Trarayduran-na liwat si mga tatay i mga magpanutu'o dadi'-na. Kuruntrahun-na si mga dadi' i mga mahanak-na hasta pa nga pamatay-na mga iya tungod si mga pagtu'u-na. ");
INSERT INTO abx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Naghumutan kam si dimu'an mga a'a tungod si ako, pero bisan say i mangilob tubtob si katapusan, iya i masalbar si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kon nagparapamasakitan kam si adda lugar, palalina kam si la'in. Sumatan-ta kam si kamatu'uran, ga'i pa satibus-bi aglibot i dimu'an syudad nga atiya' ato si Israel antis si pagtakka-na si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“I iskwila angga'i akalabaw si ma'istru-na o ma'in ngani' i rilihugon anlabaw dina si amu-na. ");
INSERT INTO abx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tama' hamok nga saparihu'an-na si iskwila i ma'istru-na ngan saparihu'an-na may si rilihugon i amu-na. Kon i tatay si panimalay nag'arunan Beelsebul, iya pa ba' i mga myimbru-na i ga'i nagsamyangan si mara'at nan. ");
INSERT INTO abx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sanglit gana' kunta' katalaw-bi si mga iya kay gana' ato nagtambunan nga ga'i gihapon akabukasan, o ma'in ngani' nagtago' nga ga'i kinatu'anan. ");
INSERT INTO abx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bisan ay i nagsumat-ko si ka'am si kalu'uman, busngalu-bi si kadanta'an. Ngan bisan ay i sapakalihan-bi nga nagguru-guro, bandilyuhu-bi si mga kakurukalsadahan. ");
INSERT INTO abx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dakam agkataralaw si mga magkatara'o pagmatay si puho' pero ga'i agkatara'o pagpirdi si espirito. Lugod, atalawa kam si aniya' gahum-na pagpirdi si espirito pati' si puho' ngan bug'os tapukan-na pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma'in ba' adda hamok tumbaga diplata i kantidad-na si duwa maya ari si mirkado? Pero gana' si mga iya magkataraktak hamok si pitak kon ma'in iya i tuyu'-na si Tata'. ");
INSERT INTO abx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bisan ngani' i barahibo si takuluk-bi ag'isip-na na. ");
INSERT INTO abx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sanglit dakam agkataralaw, kay mas mahaya i balur-bi kuntra si malabbat maya. ");
INSERT INTO abx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sanglit bisan say i magpahayag nga huwang iya si ako, pahayag-ko may liwat iya atubang si Tatay-ko nga awiray si langit. ");
INSERT INTO abx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero bisan say i magdidiwaray nga ga'i ako sakilala-na, didiwarayan-ko may liwat iya atubang si Tatay-ko nga awiray si langit. ");
INSERT INTO abx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gasi-bi ba' nga pada'ito ako pagbawa kamurayaw si kalibutan? Ma'in kamurayaw i nagbawa-ko kundi' kasamukan dina. ");
INSERT INTO abx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sigon si maka'anna' si Kasuratan: Pada'ito ako pagpa'ato si mga dadi' lalla kuntra si mga tatay-na, si mga dadi' danda kuntra si mga nanay-na, si mga umagad danda kuntra si mga ugangan-na danda. ");
INSERT INTO abx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","I pinakamara'at kuntra-na si a'a, mismo i mga myimbru-na gihapon si kalugaringun-na panimalay. ");
INSERT INTO abx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bisan say i maghigugma' si tatay-na o ma'in ngani' si nanay-na labaw kuntra si ako, ma'in iya angay nga ahimo inadalan-ko. Bisan say i maghigugma' si dadi'-na lalla o ma'in ngani' danda labaw kuntra si ako, ma'in iya angay nga ahimo inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bisan say i ga'i mag'ako' si mga pag'antus-na pariho si adda makamamalo' kamatayon si kudos ngan amaya' si ako, ma'in iya angay nga ahimo inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bisan say i makuntinto nga sa'anda'an-na na i kinabuhi'-na ina'anto, iya dina i tikarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero bisan say i magkarag si kalugaringun-na kinabuhi' para si ako, iya dina i maka'anda' si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bisan say i magpanginano pahalap si ka'am, agpanginano gayod si ako. Ngan bisan say i magpanginano si ako, ma'in hamok ako i nagpanginanu-na pero hasta pa liwat i magpapada'ito si ako. ");
INSERT INTO abx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bisan say i magpanginano si paragsumat-na si Diyos tungod si pagkaparagsumat-na, akakarawat may liwat iya si primyo nga nagtagama para si paragsumat. Ngan bisan say i magpanginano si matadong a'a tungod si pagkamatadung-na, akakarawat may liwat iya si primyo nga nagtagama para si matadong. ");
INSERT INTO abx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ngan kon aniya' si ka'am magpa'inom adda baso prisko buwahi' si mga magtikang to pa hamok pagtutu'o tungod kay inadalan-ko mga iya, sumatan-ta kam si kamatu'uran, sigurado nga ga'i arungay i primyo nga nagtagama si iya.” ");
INSERT INTO abx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kahuman-na si Jesus agtugon si dusi inadalan-na, pa'amban iya ari siray lugar ngan agparaturo' pati' agparapasamwak si mga kaburubungtuhan si Galilea. ");
INSERT INTO abx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Siray mga ka'urason ari pa si Juan si prisuhan. Ngan pakakatu'an-na mahi'unong si mga binuhatan-na si Kristo, anlihog iya si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tigtilaw-nay to, “Ka'aw na ba' i nagparapanimulat nga tipada'ito, o kinahanglan pa ba' kami' ag'antahak la'in?” ");
INSERT INTO abx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Anaruman may si Jesus, “Agbwiltaha kam ngan sumati-bi si Juan kon ay i mga sapamati'an-bi pati' kon ay i mga sakulawan-bi. ");
INSERT INTO abx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pinugaru-bi nga agpakakulaw gihapon i mga buta, agpakalangngan i mga lulid, agpanhalap i mga liprusuhon, agpakapamati' i mga bungol, a'allom gihapon i mga minatay, ngan nagpasamwak si mga anggana' i mahalap sumat. ");
INSERT INTO abx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sanglit tig'ala'on si iya i duda-na si pagpinugad nga malipayon i a'a nga ga'i ag'amban si pagtu'u-na si Diyos tungod si ako.” ");
INSERT INTO abx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pakataliwan-na si mga inadalan-na si Juan, agtikang si Jesus pagpahalling mahi'unong si Juan si magpanggurubok, “Ngan pamada'iray-bi si disyirto, ay i nagkukulawan-bi ari? Addangan ba' nga akapariho si bigahaw nga sigi hamok baya'-baya' kon palingnga i bariyo? ");
INSERT INTO abx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kon ma'in nan, ay may kay pamada'iray kam pag'usisa? Aniya' ba' a'a ari nga mahalap i pamadu'-na? Gana', kay i mahalap pamadu'-na, awiray ag'istar si mga palasyo. ");
INSERT INTO abx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kon sugad, ay may dina i nagpada'iray-bi pag'usisa? Tungod kay aniya' paragsumat-na si Diyos? Tama', ngan sumatan-ta kam, nga ma'in hamok iya paragsumat-na si Diyos, ");
INSERT INTO abx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","kay si Juan i nagtukoy si maka'anna' si Kasuratan: Aniya' paragsumat-ko nga padahulu-ko si ka'aw paghawan si pangngagihan-mo. ");
INSERT INTO abx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sumatan-ta kam si kamatu'uran: Si dimu'an mga a'a naghinganak si nana, gana' pa si mga iya nga akalabaw si Juan Paragbunyag, pero i gimiminusi si magpakasakop na si mga nagpanhadi'an-na si man langit, labaw pa si iya. ");
INSERT INTO abx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tikang pa gayod si primiro pagparawali-na si Juan Paragbunyag tubtob ina'anto, i mga nagpanhadi'an-na si man langit agbuwan na kakurihan si mga magkuntra sito ngan aniya' liwat mga ma'isog nga mag'ipipirit gayod nga akasakop kunta' sito. ");
INSERT INTO abx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kundi' myintras si pagtikang-na si Juan, nagparawali na dina i mahi'unong sito, ngan iya liwat to i makigpasumat-na andang si Diyos nga maka'anna' si Nagpanurat-na si mga Paragsumat pati' si Bala'ud-na si Moises. ");
INSERT INTO abx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ngan kon ag'aku'-bi hamok i kamatu'uran, sasayuran-bi na nga si Juan i katumanan-na si nagparapanimulat-bi Elias nga tipada'ito. ");
INSERT INTO abx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Si mga a'a makapamati', kunta' amati'. ");
INSERT INTO abx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Singnga na daw to hamok sapaparihu-ko mga a'ay to ina'anto panahon? Akapariho mga iya si mga dadi'-dadi' nga awiray si mirkado agparapaningkulo' ngan sigi burubaran'uhay: ");
INSERT INTO abx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Agparapanukaran kami' kam, pero ga'i kam agpanayaw. Sigi kami' dirinamagay, pero ga'i kam agpamanangis. ");
INSERT INTO abx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pada'ito si Juan nga ga'i parapangumbiti o parapaki'inom, ngan agpaminugad kam, ‘Nagbawa-bawa iya si mara'at espirito.’ ");
INSERT INTO abx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mangno pada'ito namay i Pinili' A'a nga parapangumbiti pati' parapaki'inom, ngan agpaminugad namay kam, ‘Atiya' i bali kamakikinakan pati' paralango, kumpaniya-na si mga paragsukot buhis pati' si mga makasasala'.’ Pero kinakulawan nga tama' i kadunung-na si Diyos pina'agi si mga madunong binuhatan-na si mag'ako' sito.” ");
INSERT INTO abx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mangno agtikang si Jesus pagpahalling kuntra si mga syudad nga ka'agsuban nagparapakulawan-na si mga makagagahom binuhatan tungod kay ga'i to agpamasol huwang si pagbag'o. ");
INSERT INTO abx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mga papabidu'on kam mga taga Corasin! Mga papabidu'on liwat kam mga taga Betsaida! Kon nagbuhat siray ari si mga syudad Tiro pati' Sidon i mga makagagahom binuhatan nagpakulaw si ka'am, maliyat na kunta' panahon i pagbasul-na mga iya huwang si pagbag'o, pina'agi kunta' si pagpanlipag'ak-na, nga mga makatol sako i mga badu'-na, panno' agbon i mga takuluk-na. ");
INSERT INTO abx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sanglit sumatan-ta kam, mas maningkarang pa i arabatun-na kastigo si magpangistar siray si Tiro pati' Sidon si allaw si paghusgar kuntra si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngan ka'am may mga taga Capernaum nan, gasi-bi ba' nga darayawon kam hasta si pagtakka-bi ari si langit? Ma'in, lugod agpakapada'iray kam dina si dilalom pitak. Kay kon nagbuhat siray ari si Sodom i mga makagagahom binuhatan nagpakulaw si ka'am, awinan paynan kunta' syudad agtutunggo hasta pa ina'anto. ");
INSERT INTO abx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sanglit sumatan-ta kam, mas maningkarang pa i arabatun-na kastigo si magpangistar siray si Sodom si allaw si paghusgar kuntra si arabatun-bi mismo liwat sinan allaw.” ");
INSERT INTO abx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mismo sinan mga uras aminugad si Jesus, “Tay, ka'aw nga Paragdalum-na si kalangitan pati' si kalibutan, agdayaw ako si ka'aw kay agtagu'-mo i sarabutan hi'unong si pagkahadi'-mo. Agtagu'-moy nan si mga madunong pati' malanga idukasyun-na ngan agpakatu'an-moy nan si mga makapariho si mga dadi'-dadi' nga mapa'inubsanon. ");
INSERT INTO abx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tay, ka'angayan nga ahinabo' nan kay iyay nan i makapalipay si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mangno agpadayon iya pagbagaw si magpanggurubok, “Agpatubyan-na na si ako si Tatay-ko i dimu'an kata'o pati' pagdalom. Gana' ni addangan makakilala pahalap si Dadi' kon ma'in hamok i Tata', ngan gana' ni addangan makakilala pahalap si Tata' kon ma'in hamok i Dadi' pati' i mga nagpamili'-na si Dadi' pagpakilala kon say iya. ");
INSERT INTO abx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sanglit, paduguka kam si ako, ka'am dimu'an magpangabat nan kabudlayan ngan nagpandada'og tungod si gana' kapulsanan-na kapapaniguru-bi pagtapit si Diyos. Mangno ako si ka'am i mamadiskanso. ");
INSERT INTO abx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Anunu'a kam si yugu-koy to ngan angadala kam si ako, kay ata'o ako paghinay-hinay pati' pagpa'ubos ngan sa'angkun-bi i murayaw inisipan naghingyap-bi ");
INSERT INTO abx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kay i yugu-ko masayon nagpasul'ot ngan maningkarang nagbawa.” ");
INSERT INTO abx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sin adda, pabalatas kas Jesus si kapatagan nga akatuman si Allaw Pandidiskanso. Tungod kay mga linganto i mga inadalan-na, sigi mga iya pangattos si mga matahak uhay-na si trigo ngan sigi panilsi'. ");
INSERT INTO abx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aniya' mga Parisiyo magpakakulaw sinan nga agpanriklamo si Jesus, “Kulawin ngani' nan! Ay kay agparapangattos i mga inadalan-mo si Allaw Pandidiskanso bisan kon sakatu'anan-bi nga supak nan si bala'od?” ");
INSERT INTO abx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Anaruman may dina si Jesus, “Ga'i ba' sabasa-bi kon ay i nagbuhat-na siray si David ngan alinganto iya hasta i mga kahuruwangan-na? ");
INSERT INTO abx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pasallod iya si pangngangampu'an tulda ngan angaddo' si pan nagla'in para si Diyos. Agkakan-nay nan ngan da'inan may i mga kahuruwangan-na bisan kon i mga paraghalad hamok i tugot pagkakan sinan. Pero ma'in nan sala' para si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ga'i ba' kam liwat agpakabasa si maka'anna' si Bala'od nga matuman si kada Allaw Pandidiskanso, nga kinahanglan ga'i manginano si kasagradu-na si allaw i mga paraghalad ari si templo, pero ma'in nan sala' para si mga iya? ");
INSERT INTO abx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sumatan-ta kam nga atiya' ato ina'anto i mas angay lugod dina paranginanuhon kuntra si templo. ");
INSERT INTO abx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kon agpakasabot kam hamok si karuyag sidngun-na sito mga allingon nga aka'anna' si Kasuratan, ‘Gana' kapulsanan-na si ako i pagkarilihusu-bi pariho si pagbuno' mga panhahalad kon ga'i dahulo sakulawan-ko i pagkamaluluy'un-bi,’ ga'i kam kunta' agparapamatok si mga a'a nga ma'in sala' i sabuhat-na. ");
INSERT INTO abx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngan ma'in nan hamok i sala'-bi kay kon i Pinili' A'a i Paragdalom si bisan ay, iya pa ba' i Allaw Pandidiskanso?” ");
INSERT INTO abx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tikang ari siray lugar, agdiritso iya pada'iray si sinaguga-na sinan mga Parisiyo. ");
INSERT INTO abx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aniya' lalla ari nga piyapi i adda tamburu'-na. Sanglit, tungod kay dati mga iya agparapanganda' rason nga sapa'akusar-na mga iya si Jesus, agpamatilaw to, “Nagpatugot ba' si bala'od pagbulong kon Allaw Pandidiskanso o ga'i?” ");
INSERT INTO abx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lingun-na may si Jesus si mga iya, “Kon addangan si ka'am i aniya' karniru-na ngan alaho' to si pangngukaran si Allaw Pandidiskanso, ga'i ba' to addu'-bi ngan isa-bi pagawas? ");
INSERT INTO abx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas mahaya baga i balur-na si a'a kuntra si karniro! Kon da'inan sinan, ma'in supak si bala'od i pagbuhat mahalap kon Allaw Pandidiskanso.” ");
INSERT INTO abx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Katapos agmandaran-na i lalla, “Buklaron tamburu'-moy nan.” Agbuklad-na si lalla, ngan anhamis gihapon i pustura-na si tamburu'-na nga pariho na gayod si dambila'. ");
INSERT INTO abx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sanglit pamagawas i mga Parisiyo ngan agtikang mga iya pagplano kon pinapa'i sapamatay-na mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Akatu'anan si Jesus si mga planu-na, sanglit palitira iya ari siray lugar. Malabbat si mga magpamungyod si iya i aniya' mara'at nagpangabat-na, ngan agpamulung-nay nan dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Agpanmandu'an-nay nan nga ga'i pagparasumat kon say iya. ");
INSERT INTO abx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Si da'inan pa'agi atuman i mga allingun-na siray si paragsumat Isaias: ");
INSERT INTO abx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Atiya' i rilihugun-ko nga pinili'-ko, i hinigugma'-ko nga akabuwan gayod kalipayan si ako. Pa'ayup-ko si iya i Espiritu-ko, ngan iya i mamakatu'an si pantay paghusgar-ko si dimu'an nasyon. ");
INSERT INTO abx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ga'i iya agparapakipasusuhay o agparagagasod. Ga'i iya kinapakalihan nga agparadiskurso si mga kakalsadahan. ");
INSERT INTO abx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ga'i iya amatti' bisan i maglaylay na gayod bigahaw, ngan ga'i iya amarong bisan i magkimmat-kimmat na hamok lampara, tubtob nga sapada'ug-na i pantay pagkukulaw-ko. ");
INSERT INTO abx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ngan i gahum-na si arun-na, iya i magbuwan kasiguraduhan nga sa'angkun-na si mga nasyon i mga nag'anduy-na. ");
INSERT INTO abx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mangno aniya' mga a'a magpamawa pada'iray si Jesus buta pati' ngula lalla nga nagbawa-bawa si mara'at espirito. Agpahalap-na iya si Jesus pina'agi si pagpapinda sinan sanglit akayawit dayon iya ngan akakulaw. ");
INSERT INTO abx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ag'usa i dimu'an mga a'a ari ngan agsipurupatilaway, “Pusibli ba' nga iya na i Dadi'-na si David nga nagparapanimulat-ta?” ");
INSERT INTO abx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero pakabati'-na sinan si mga Parisiyo, agpaminugad dina mga iya, “Tungod gad nan hamok si gahum-na si Beelsebul, i prinsipi-na si dimu'an mara'at espirito, sanglit akapapinday to a'a si mga mara'at espirito.” ");
INSERT INTO abx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Akatu'anan si Jesus si mga inisipan-na hi'unong si Beelsebul sanglit agpaminugad-na mga iya, “Kon aniya' nasyon nga ag'urunay i mga a'a-na, sigurado nga tulos to abungkag. Ngan da'inan may si adda syudad o pamilya, kon ag'urunay i mga sakup-na sito, sigurado nga ga'i to akatunggo. ");
INSERT INTO abx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kon ag'unay-na si Satanas agpapinda i mga kahuruwangan-na, mismo i kalugaringun-na i magpabulag si mga iya. Kon da'inan sinan, pinapa'i-na may pakatunggo si ginhadi'an-na? ");
INSERT INTO abx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sanglit kon i gahum-na si Beelsebul i naggamit-ko pagpapinda si mga mara'at espirito, say may tawa' gahom i naggamit-na si mga sakup-bi pagpapinda si mga iya? Kon sugad, mismo bali' mga iya i maghusgar pagpamatu'od nga sala' i mga isip-bi. ");
INSERT INTO abx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero kon i pagpapinda-ko si mga mara'at espirito pina'agi si Espiritu-na si Diyos sigurado nga aghadi' na i Diyos si lugar-bi to. ");
INSERT INTO abx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pariho sito: Pinapa'i asallod i ruma'-na si adda makusog lalla pagtangkaw si garamitun-na? Sumatan-ta kam: Kon aniya' mas makusog pa nga sagapus-na iya dahulo, sigurado sabawa-na i dimu'an inanna'-na si ruma'. ");
INSERT INTO abx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Bisan say i ga'i mamungyod si ako, anguntra si ako, ngan da'inan may liwat, bisan say i ga'i pahuwang si ako pag'agda a'a nga anutu'o, iya dina i magpawararak si mga aragdahun-ko. ");
INSERT INTO abx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sanglit sumatan-ta kam, sapasaylu-na si Diyos i dimu'an sala'-na si a'a, bisan pa i paglalabaw si Diyos, pero i pagparapakara'at si arun-na si Espirito Santo, ga'i apasaylo. ");
INSERT INTO abx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bisan say i mamahalling kuntra si Pinili' A'a, apasaylo iya, pero i magparapahalling kuntra si Espirito Santo, ga'i apasaylo si ina'anto hasta pa si titakkay ro panahon. ");
INSERT INTO abx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pahalapu-bi pag'ataman si kayo, basi' mahalap may sito i buwa'-na. Pero kon padayon i mara'at pag'ataman-bi sito, sigurado nga mara'at may liwat i buwa'-na. Ngan akilala kon say i mahalap tungod si buwa'-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mga alisto kam gayod pagpamakunu-kuno! Pinapa'i kam agpakapahalling si bisan ay mahalapa nga lagtok kam si karat'an? Bisan ay i manapwa si inisipan-na si a'a, iya may i sapahalling-na. ");
INSERT INTO abx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Agpagawas-na si mahalap a'a i mga kahalapan kay iya may i sana'an si iya, ngan agpaguwa'-na si mara'at a'a i mga karat'an kay iya may liwat i sana'an si iya. ");
INSERT INTO abx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sumatan-ta kam nga aniya' baratunun-na si mga a'a si kada allingon sayawit-na nga ma'in angay parahallingon kon anakka na i allaw si paghusgar. ");
INSERT INTO abx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay dipindi si mga sayawit-bi kon agpakalibri ba' kam o ma'in ngani' paratukan.” ");
INSERT INTO abx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mangno aniya' si mga Parisiyo pati' mga paragturo' bala'od i maminugad si iya, “Ma'istro, aruyag kami' nga anhimo kaw pangngilalahan si langitnon kasiguruhan.” ");
INSERT INTO abx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Anaruman si Jesus, “Kinakulawan gayod i kara'at-na si mga a'a sito panahon nga makihuhuwangon si mga pala'in-la'in diyos, kay sigi hamok paralakuhay si mga pangngilalahan si langitnon kasiguruhan. Pero gana' na purumwanon pa si mga iya pwira si pangngilalahan siray nga nagbuhat si paragsumat Jonas. ");
INSERT INTO abx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Si Jonas mismo i naghimo pangngilalahan si pag'istar-na tallo allaw ngan tallo sangom si battung-na si mahaya daying, ngan pariho si iya, ti'istar may liwat i Pinili' A'a si labbong tallo allaw ngan tallo sangom. ");
INSERT INTO abx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aniya' titakka allaw nga abanhaw i mga allom pa ina'anto basi' agpakahusgaran. Sinan allaw, abanhaw may liwat i magpangistar siray si syudad Ninibe pagtistigos kuntra si mga allom pa ina'anto kay agpamasol mga iya siray huwang si pagbag'o si pakapakali-na mga iya si nagpasamwak-na si Jonas. Sanglit tungod sinan matadong binuhatan nagpatukan i mga magka'arallom ina'anto tungod si mga buhat-na kay atiya' na i mas labaw pa kuntra si Jonas nga angay lugod dina parakalihan. ");
INSERT INTO abx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Si pariho pa'agi, kon anakkay nan allaw, abanhaw may liwat i Rayna si Sur. Iya i magparabiyahi siray tikang si matala lugar pagpamati' si madunong pinahallingan-na si Solomon. Sanglit tungod sinan matadong binuhatan, nagpatukan i dimu'an magka'arallom ina'anto tungod si mga buhat-na kay atiya' na i mas labaw pa kuntra si Solomon nga angay lugod dina durugukon. ");
INSERT INTO abx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Si papinda-na si mara'at espirito si adda a'a, ag'agi to si mga matuho' gayod lugar ngan sigi anda' si pandidiskansuhan-na. Tungod kay ga'i may aka'anda', ");
INSERT INTO abx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","aminugad to si kalugaringun-na, ‘Agbalik ako si inambanan-koy ray.’ Si panakka-na ari, sakatu'anan-na nga day gana' mag'istar, sinilhigan gayod ngan mahamis i dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mangno agbwilta iya pag'agda pa pito' kahuruwangan-na mara'at espirito nga mas mara'at pa kuntra si iya. Pa'ayop to mga iya ari basi' mga sabawa-bawa-na. Sanglit i kamutangan-na si a'a si damuri to mas mara'at pa dina kuntra si primiro. Sanglit da'inan sinan i tinakkahan-na si mga a'a-na sito panahon nga bali pagkara'at.” ");
INSERT INTO abx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sigi pa pahalling si Jesus si mga a'a, anakka may i nana-na pati' i mga bugtu'-na lalla. Agparapanunggo mga iya si gawas kay tipakibagaw mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aniya' makasumat si iya, “Awiray si gawas agparapanunggo i nana-mo huwang i mga bugtu'-mo, ngan tipakibagaw mga iya si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero agtilaw-na dina si Jesus i magsumat si iya, “Sakatu'anan-mo ba' kon say i nanay-ko pati' i mga bugtu'-ko?” ");
INSERT INTO abx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Agturu'-na i mga inadalan-na ngan diritso amahalling, “Atiya' si ka'am i nana-ko pati' i kabugtu'an-ko. ");
INSERT INTO abx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kay bisan say i magtuman si katuyu'an-na si Tatay-ko ari si langit, mga iya dina i kabugtu'an-ko pati' nana-ko.” ");
INSERT INTO abx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mismo siray allaw, paduwa'i si Jesus si ruma' ngan aningkulo' iya si bihing-na si danaw. ");
INSERT INTO abx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mangno, tungod si kalabbat-na si magpanggubok si iya, pasang'at iya si adda paraw ngan aningkulo'. I mga a'a may dimu'an si bihing agparapanunggo. ");
INSERT INTO abx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Agpadayon iya si pagturo' si mga iya pala'in-la'in pina'agi si mga isturya nga agtukoy si kamatu'uran. Aminugad iya, “Aniya' para'uma nga patakod basi' agsaburak. ");
INSERT INTO abx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Si pagsaburak-na si uma-na, aniya' mga gahi' nga aka'anna' dina si lalan ngan agpamadugok i mga manuk-manok pagtuktok. ");
INSERT INTO abx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aniya' liwat mga gahi' nga aka'anna' dina si mga malambo bato nga manipis hamok i pitak-na si dyata'. Sanglit tulos to anudok tungod si kanipis-na si pitak. ");
INSERT INTO abx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero ngan pamanas-na si allaw, alayong to dayon mga tinanom ngan a'uga tungod kay kulang i kalanga-na si mga gamut-na. ");
INSERT INTO abx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aniya' liwat mga gahi' nga aka'anna' dina si pitak nga aniya' pa mabilin mga gamut-na si simpot. Sanglit ngan panuduk-na si simpot, agsuputan-na dina si simpot i mga tinanom. ");
INSERT INTO abx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero aniya' may liwat mga gahi' nga aka'anna' si mahalap pitak. Sanglit mahalap i pamuwa'-na. Aniya' sito mga mahalap pitak nga i kutsitsa-na ag'addahatos dubli kuntra si nagpasaburak, aniya' may magsaysinta ngan aniya' may magtraynta. ");
INSERT INTO abx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Si mga a'a makapamati', kunta' amati'.” ");
INSERT INTO abx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Padugok si iya i mga inadalan-na ngan agpamatilaw, “Ay kay agparagamitan-mo si mga isturya nga agtukoy si kamatu'uran kon makibagaw kaw si mga a'a?” ");
INSERT INTO abx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Anaruman iya, “Nagpumwan-na si ka'am i pagsabut-bi nga iya i nagparatago' siray, kon pinapa'i i a'a akasakop si nagpanhadi'an-na si man langit, pero nagparatago' payto si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bisan say i aniya', iya i binuwanan pa basi' anlabbat gayod i tawa'-na; pero bisan say i gana', hasta pa i diki'it tawa'-na, inala' pa tikang si iya. ");
INSERT INTO abx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yayto i rason kon ay kay agparagamitan-ko mga iya si mga isturya nga agtukoy si kamatu'uran tungod kay sigi mga iya buruslungay, pero gana' mga sakulawan-na. Sigi paramati'ay, pero gana' mga sasabutan-na. ");
INSERT INTO abx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kinakulawan anan si mga iya i katumanan-na si makigpasumat-na si Diyos si Isaias: Sigi hamok mga iya paramati'ay, pero gana' mga sasabutan-na. Sigi hamok buruslungay, pero gana' mga sakulawan-na. ");
INSERT INTO abx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay yayray mga a'a agparapamakunu-kuno nga mga bulok hasta nga gana' na gayod lugod mga pamurubu'ut-na, agparapakangbungul-bungol ngan agparapakangbuta-buta. Kon ma'in da'inan sinan, amuklat na kunta' i mga mata-na, aka'abrihan i mga talinga-na, akaklaruhan i mga inisipan-na, abawa na kunta' mga iya pagtu'o si ako ngan sapahalap-ko mga iya. ");
INSERT INTO abx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero mga malipayon kam gayod kay agpakakulaw kam ngan agpakapamati'. ");
INSERT INTO abx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kay sumatan-ta kam si kamatu'uran, siray mga panahon aniya' malabbat mga paragsumat-na si Diyos pati' mga matadong a'a nga agparapanhandom pag'ikukulaw si mga sakulawan-bi, pero gana' si mga iya magpakakulaw. Malabbat magpanhandom nga agpakapakali si mga sapakalihan-bi, pero ga'i mga iya agpakapakali. ");
INSERT INTO abx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sanglit amati'a kam nga sasabutan-bi kon ay i karuyag sidngun-na si isturya-koy ray mahi'unong si parasaburak: ");
INSERT INTO abx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I lalan kon singnga aka'anna' dina i gahi', akaparihoy nan kamutangan si makapamati' si allingon kon pinapa'i iya akasakop si nagpanhadi'an-na si man langit ngan ga'i to sasabutan-na. Kon da'inan sinan, anakka si Satanas ngan ag'ala'-na si iya i allingon nga nagpasaburak si inisipan-na. ");
INSERT INTO abx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","I mga malambo bato namay nga manipis hamok i pitak-na si dyata', akaparihoy nan kamutangan si makapamati' si allingon nga malipayon dayon pagkarawat sito. ");
INSERT INTO abx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero tungod kay mababaw hamok i gamot ato sito a'a, ma'in maliyat i pagti'us-na. Si panakka-na si mga kakurihan o ma'in ngani' si pagpasakit-na si la'in tungod si pagtutu'o si allingon, pa'amban dayon iya si pagtutu'u-na. ");
INSERT INTO abx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","I pitak may nga aniya' mga titudok simpot, akaparihoy nan kamutangan si makapamati' pahalap si allingon pero si katapus-tapusan agparasasallod si iya i kabaraka si pagpanginabuhi' pati' i daya'on kalipayan-na si kayamanan. Iyay nan dimu'an i makapugong si pagtubu'-na si allingun-na, sanglit ga'i akabuwa'. ");
INSERT INTO abx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero i mahalap pitak, akaparihoy nan kamutangan si makapamati' si allingon ngan sasabutan-na gayod, sanglit mahalap i pagbuwa'-na. Aniya' sito klasi a'a nga i kutsitsa-na si allingon ag'addahatos dubli, aniya' may magsaysinta, ngan aniya' may magtraynta.” ");
INSERT INTO abx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Agsumatan-na mga iya gihapon si Jesus adda isturya nga agtukoy si kamatu'uran: “I paghadi'-na si man langit akapariho si a'a nga agsaburak si mahalap gahi' ari si uma-na. ");
INSERT INTO abx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero si pakapaturi-na na si dimu'an, anakka may i kuntra-na ngan agpasaburak may si buwa'-na si simpot si nagsaburakan si trigo ngan diritso pa'amban. ");
INSERT INTO abx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Panuduk-na si trigo ngan amurma i mga lawi-na, anudok may liwat i mga simpot. ");
INSERT INTO abx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Padugok i mga rilihugun-na ari si tagtawa' ngan aniya' magsumbong, ‘Amo, ma'in ba' mahalap i gahi' nagpasaburak-mo si uma-moy ray? Singnga may ray tikang magpanubo' ray simpot ari?’ ");
INSERT INTO abx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Lingun-na may si amo, ‘Sigurado nga kuntra-ta kam i magbuhat sinan.’ “Amatilaw i mga rilihugon si iya, ‘Aruyag ba' kaw nga panrabnot kami' mga simpot ray?’ ");
INSERT INTO abx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Anaruman may iya, ‘Dakam, kay tingali si pagpararabnut-bi si mga simpot, abawa dina hasta i mga trigo. ");
INSERT INTO abx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pata'anin na hamok nga agdungan agtubo' i duwa tubtob si tig'ani. Kon anakka naynan uras, tugunan-ko na hamok i magpangani pagtipon dahulo si mga simpot ngan pakkus-na mga iya basi' agpakabar'ugan. Katapos iya na dina pinasunod i trigo ngan binawa pada'iray si kamalig-ko.’” ");
INSERT INTO abx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Agsumatan-na namay mga iya si Jesus la'in isturya nga agtukoy si kamatu'uran: “I paghadi'-na si man langit akapariho si lisu-na si tinanom mustad, ");
INSERT INTO abx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","nga iya i pinakamadiki' liso nga satanum-na si a'a si uma-na. Pero kon anubo' to liso, iya i adda pinakamahaya si dimu'an tinanom. Akaparihoy to kahaya si kayo nga pwidi i sanga-na sa'ansalahan-na si mga manuk-manok.” ");
INSERT INTO abx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Agsumatan-na gihapon mga iya adda pa isturya nga agtukoy si kamatu'uran: “I paghadi'-na si man langit akapariho si pammatubo' nga nagpasakut-na si parakaran'on danda ari si malabbat harrina hasta nga agsarama si bug'os minasa.” ");
INSERT INTO abx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Atubang si kalabbatan nga pirmi aggubok si Jesus, puro hamok isturya nga agtukoy si kamatu'uran i nagpahalling-na. Ga'i gayod iya amahalling si ka'aha'an kon ma'in da'inan sinan. ");
INSERT INTO abx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tungod sinan, atuman i mga allingun-na si paragsumat-na si Diyos: Ga'i ako amahalling nga ga'i aggamit si isturya nga agtukoy si kamatu'uran. Ako i mamaguwa' si mga tinago' tikang pa siray si paghimo gayod si kalibutan. ");
INSERT INTO abx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Katapos pa'amban si Jesus si magpanggubok ngan diritso amanahik pan ruma'. Anunod si iya i mga inadalan-na ngan agpaminugad, “Isplikarin daw kami' si isturya-moy ray hi'unong si magpanudok simpot ari si uma.” ");
INSERT INTO abx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Anaruman iya, “I magpasaburak si mahalap gahi', iya i Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I uma, iya i kalibutan ngan i mahalap gahi', iya i mga a'a nga sakop si nagpanhadi'an-na. I mga simpot, iya i mga sakup-na si girara'ati, ");
INSERT INTO abx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ngan i kuntra magpasaburak si mga iya, iya si Satanas. I tig'ani, iya i katapusan-na sito panahon, ngan i mga mangngangani, iya i mga anghel. ");
INSERT INTO abx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kon ay i kamutangan-na si uras si pagpanrabnot si mga simpot ngan pagpabar'og, da'inan may liwat sinan i manakka si katapusan-na sito panahon. ");
INSERT INTO abx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Pabawa-na si Pinili' A'a i mga anghel-na, ngan mga iya i manhawan si dimu'an nga akapa'amban si pagtu'o, si dimu'an nga agparapamuhat si mga mara'at nga awiray akabiyo' si nagpanhadi'an-na. ");
INSERT INTO abx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tarapukan nan mga a'a ari si mag'arab-arab api, si lugar nga aniya' magparapangaraba pati' magparapanrigot. ");
INSERT INTO abx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Katapos agsiga pariho si allaw i mga matadong nga nagpanhadi'an-na na si Tatay-na mga iya. Si mga a'a makapamati', kunta' amati'. ");
INSERT INTO abx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“I paghadi'-na si man langit akapariho si manggad nga naglubluban si uma. Si paka'anda'-na sito si a'a, aglubluban-nay to utro ngan diritso iya padulhog nga bali kalipayan. Mangno agpamaligya'an-na i dimu'an mga inanna'-na basi' sabutung-na i uma. ");
INSERT INTO abx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Adda pa liwat: I kapapaniguru-na si mga mag'isasakop si nagpanhadi'an-na si man langit, akapariho si nigusyanti nga parabiyahi pag'anda' si mga mahalap klasi pirlas. ");
INSERT INTO abx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ngan paka'anda'-na si adda nga mahaya i balur-na, agpamaligya'an-na dayon i dimu'an mga inanna'-na ngan agbwilta-nay to basi' saballi-na. ");
INSERT INTO abx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“I paghadi'-na si man langit pariho liwat si adda pukot nga nagtaktak si danaw ngan akabawa si dimu'an klasi daying. ");
INSERT INTO abx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Si pakapannu'-na sito, nagguyod to si mga paradaying pan bihing. Katapos ag'ararung-arungan-nay to mga iya pagyabyab ngan nagpa'anna' si kanastro i mga mahalap klasi pero nagtapukan i mga mara'at. ");
INSERT INTO abx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da'inan sinan i kamutangan-na si katapusan-na sito panahon. Pamada'ito i mga anghel pagbulag si mga mara'at binuhatan-na nga akasalakot si mga matadong, ");
INSERT INTO abx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ngan mga iya i mamatapok sinan si mag'arab-arab api, si lugar nga aniya' magparapangaraba pati' magparapanrigot.” ");
INSERT INTO abx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Amatilaw si Jesus, “Agpakasabot ba' kam sito dimu'an?” Anaruman may mga iya, “Oho'.” ");
INSERT INTO abx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sanglit agpinugad-na mga iya, “Kon sugad, i kada paragturo' bala'od nga akasakop na si nagpanhadi'an-na si man langit, akapariho si tagruma' nga akakaya pagpa'ambit si mga sapundar-na ma'in hamok i mga kada'an kundi' hasta pa i mga baha'o.” ");
INSERT INTO abx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pakahuman-na si Jesus pagsumat sinan mga isturya nga agtukoy si kamatu'uran, pa'amban iya ari siray lugar, ");
INSERT INTO abx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ngan agbalik iya si tinubu'an-na baryo. Agtikang iya pagturo' si sinaguga-na mga iya ngan bali gayod i mga pag'usa-na si mga a'a ari. Agsipuruparatilaway mga iya, “Singngay to a'a agpara'inala' sito mga kadunong pati' mga pambihira gahom? ");
INSERT INTO abx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma'in ba' to i dadi'-na si panday ngan Maria i arun-na si nanay-na? Ma'in ba' iya i bugtu'-na kas Santiago, Joset, Simon, pati' si Judas? ");
INSERT INTO abx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ngan ma'in ba' atiya' pa liwat ato i mga bugtu'-na danda sinan? Kon sugad, singnga may nan iya agpara'inala' sinan dimu'an?” ");
INSERT INTO abx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sanglit, agdiri'-na gayod mga iya si Jesus. Pero agpinugad-na mga iya si Jesus, “Nagdayaw gayod si bisan singnga i paragsumat-na si Diyos, pwira na hamok si kalugaringun-na lugar pati' si kalugaringun-na pamilya.” ");
INSERT INTO abx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sanglit diki'it hamok i mga makagagahom binuhatan i sahimu-na ari tungod si kadiki'it-na si mga a'a magtapod si iya. ");
INSERT INTO abx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Siray ka'urason, aka'aning'ing si gubirnador Herodes, mahi'unong si kabantugan-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akapinugad dayon iya si mga tinapuran-na, “Sigurado nga iya si Juan Paragbunyag nga abanhaw, sanglit akakaya iya pagpakulaw sinan mga pambihira gahom.” ");
INSERT INTO abx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Akapinugad iya sinan tungod kay akunsinsya iya. Maliyat na panahon, agparasumatan-na si Juan si Herodes: “Supak si bala'od i pagtig'ub-mo si Herodias.” Sanglit si Herodes mismo i magpadakop si Juan. Agpakadinahan-nay to ngan agpaprisu-na. Agbuhat-nay nan si Herodes tungod si Herodias nga sa'alla-na bisan kon bayaw-nay to. Dati to alla-na si sirari-na nag'arunan Felipe. ");
INSERT INTO abx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aruyag gayod si Herodes nga pamatay-na si Juan, pero atalaw iya si mga a'a kay paragsumat-na si Diyos i pagkakilala-na sito mga iya. ");
INSERT INTO abx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero ngan panakka-na si pagsilibrar si kumpli'anyu-na si Herodes, agsayaw i dadi'-na danda si Herodias atubang si mga bisita nga akabuwan gayod kalipayan si Herodes. ");
INSERT INTO abx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tungod sinan, akasa'ad iya bawa i pagsumpa' nga buwanan-nay to bisan ay i pinalaku-na. ");
INSERT INTO abx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pina'agi si dikta-na si nanay-na, aminugad i durudangkanda, “Pumwanon si ako ina'anto si adda bandihado i takuluk-na si Juan Paragbunyag!” ");
INSERT INTO abx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Akapabido' to si hadi', pero ga'i iya akadiri' tungod si mga sa'ad-na nga sapamati'an-na si mga bisita. Sanglit agmando' iya nga pinumwan i nagpalaku-na si dadi', ");
INSERT INTO abx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ngan nagpapugutan dayon si Juan ari si prisuhan. ");
INSERT INTO abx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mangno nagbaway to si bandihado pada'iray si durudangkanda, katapos, iya na i magpumwan sito si nanay-na. ");
INSERT INTO abx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Agpamada'iray i mga inadalan-na si Juan pag'ala' si bangkay-na basi' akalabbungan. Mangno agbagat-na mga iya si Jesus ngan agpanumatan-na. ");
INSERT INTO abx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pakanutisya si Jesus mahi'unong sinan hinabo', amanakay iya si paraw huwang i mga inadalan-na basi' gana' makabaya' si pagpada'iray-na mga iya si adda mamingaw lugar. Pero si pakakatu'an sinan si ka'aha'an, agpamukod to ngan sigi pangagda si mga kaburubungtuhan nagpangagihan-na nga agpamaktas hamok. ");
INSERT INTO abx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ngan pasalta-na si Jesus si paraw, sakulawan-nay to kalabbatan to magpantarambak nga ari na dina. Alu'oy gayod iya si mga a'a ngan agpamulung-na i mga maburong nga huwang ari. ");
INSERT INTO abx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ngan pagsasaray-na na si allaw, padugok si Jesus i mga inadalan-na ngan agpaminugad, “Kuhap na ngan mamingaw liwat to lugar. Pamalitirahon naynan mga a'a basi' agpakapada'iray na mga iya si mamatapit baryo ato ngan agpakaballi si mga karakanun-na.” ");
INSERT INTO abx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Anaruman iya, “Ma'in na kinahanglan nga pama'amban pa mga iya. Ka'am na hamok mamuwan karakanon si mga iya.” ");
INSERT INTO abx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lingun-na may mga iya, “Lima nayto hamok bug'os pan-tay to kam pati' duwa agon.” ");
INSERT INTO abx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Agpinugad-na mga iya si Jesus, “Hala, bawahu-bi nan pada'ito.” ");
INSERT INTO abx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mangno agmandaran-na i mga inadalan-na pagpamalumpagi' si mga a'a si kagabunan. Katapos, ag'ala'-na si Jesus i lima bug'os pan pati' i duwa agon. Anhangad iya ngan agpasalamat si Diyos. Mangno agpanurutabbi'-na ngan agpumwan-nay to si mga inadalan-na pagtaltag si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Agpakakakan i dimu'an ngan agpakagustuhan. Katapos akatipon pa dina i mga inadalan dusi sagad nga puro panno' si tinurutabbi' la'a. ");
INSERT INTO abx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bisan i mga lalla hamok magpakakakan siray allaw anakka si mga singko mil, pwira pa si mga danda pati' si mga kadadi'-dadi'an. ");
INSERT INTO abx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kata'ud-ta'uran agpasakay-na si Jesus i mga inadalan-na si paraw basi' agpakadahulo mga iya pagbalik pan dambila' myintras nga agparapamalitira pa iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kahuman-na agpamalitira, agsulu-sulo si Jesus pada'iray si adda tagudtod pagpangadyi'. Ngan kasanguman, iya na hamok addangan i sari'i, ");
INSERT INTO abx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","pero i paraw siray mga ka'urason matala na dina si hubas ngan nagkurihan to si mga mahaya alon tungod kay sungsong mga iya si bariyo. ");
INSERT INTO abx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sanglit kamananalungan, bukud-na si Jesus i mga inadalan-na nga aglalangngan hamok si buwahi'. ");
INSERT INTO abx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pakakulaw-na si mga inadalan-na nga agparalalangngan iya si buwahi', bali gayod i mga katalaw-na. Agpaminugad mga iya, “Kalag may nan!” Ngan agpakaturakaw mga iya tungod si mga kulba-na. ");
INSERT INTO abx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero aminugad dayon si Jesus, “Dakam atalaw, akoy to! Agsariga kam hamok.” ");
INSERT INTO abx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Anaruman may si Pedro, “Paragdalom, kon ka'aw may nan dina, papada'iruhon may daw ako nga aglalangngan si buwahi'.” ");
INSERT INTO abx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lingun-na may si Jesus, “Pada'ituha.” Pahaw'as si Pedro si paraw ngan padugok iya si Jesus nga aglalangngan si buwahi'. ");
INSERT INTO abx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero ngan paka'abat-na si makusog bariyo, tinakka iya katalaw ngan ari agtikang iya pagtutullod. Anurakaw iya, “Paragdalom, sagibon ako!” ");
INSERT INTO abx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sa'agaw-na dayon si Jesus i tamburu'-na ngan sa'antanan-nay to. Aminugad iya, “Kulang pa kaw si pagtapod. Ay kay agduda pa kaw?” ");
INSERT INTO abx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pakasang'at-na mga iya si paraw, angalma dayon i bariyo. ");
INSERT INTO abx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mangno ag'ampu'an-na mga iya si Jesus ngan agpakapinugad, “Ungod gayod nga ka'aw i Dadi'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pakatalabuk-na mga iya si danaw, padu'ong mga iya si adda lugar nga sakop si Genesaret. ");
INSERT INTO abx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ngan pakakilala si Jesus si mga sunsari'i, agpatugon dayon mga iya si bug'os lugar ari. Sanglit sigi barawahay i mga a'a si mga maburung-na pada'iray si iya. ");
INSERT INTO abx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Agparapakimalu'oy mga iya nga kon pwidi agpakasaphid i mga maburong bisan i sidsid-na hamok si badu'-na. Ngan agpanhalap i dimu'an magpakasaphid. ");
INSERT INTO abx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mangno aniya' magpamadugok si Jesus mga Parisiyo pati' mga paragturo' bala'od nga mga man Jerusalem. Agpanriklamoy to si iya, ");
INSERT INTO abx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apa'i may kay agsupak-na si mga inadalan-mo i minuklatan-ta kam tuluhu'an? Gana' si mga iya magtuman si tama' pa'agi pagkuso' myintras amangan!” ");
INSERT INTO abx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Anaruman dina si Jesus, “Ngan kapa'i may liwat kay agsupak-bi i kasugu'an-na si Diyos para hamok adayaw i mga kabatasanan-bi? ");
INSERT INTO abx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Halimbawa' si mandu'-na si Diyos, ‘Tahurin i tatay-mo pati' i nanay-mo,’ ngan aniya' liwat, ‘Bisan say i magmaldisyon si tatay-na o nanay-na, kinahanglan iya amatay.’ ");
INSERT INTO abx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero agturo' kam dina nga ma'in kinahanglan pagbulig si mga mahanak, ngan kon aniya' inanna'-na si addangan, pwidi iya akapasangil si pagpinugad, ‘Tawa'-nay to si Diyos.’ ");
INSERT INTO abx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kon da'inan sinan, i karuyag sidngun-bi nga ma'in na kinahanglan nga tahuran-na pa i tatay-na. Kon sugad, agpara'-bi i gahum-na si allingun-na si Diyos para hamok adayaw i kabatasanan-bi. ");
INSERT INTO abx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga mahalap kam gayod agparapamakunu-kuno nga mga rilihuso kam! Tama' gayod i makigpasumat-na andang si Diyos si Isaias mahi'unong si ka'am: ");
INSERT INTO abx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yayto mga a'a, agpa'unrahan-na ako pina'agi si mga allingun-na, pero la'in dina i mga sabarawan-na. ");
INSERT INTO abx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gana' gayod kapulsanan-na si mga pag'ampu'-na si ako, kay i mga tuluhu'an nagturu'-na mga iya, mga hinimu-himu-na hamok kasugu'an si a'a.” ");
INSERT INTO abx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mangno agban'u-na si Jesus i magpantarambak ari pagtapit si iya ngan agpanumatan-na, “Amati'a kam ngan sabutu-bi to. ");
INSERT INTO abx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gana' gayod pasallod si bawa'-na si a'a nga akaparigsok si iya, kundi' i pagawas dina tikang si bawa'-na.” ");
INSERT INTO abx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mangno pamadugok si iya i mga inadalan ngan agpamatilaw, “Akatu'anan ba' kaw nga agka'irinsulto i mga Parisiyo si pakabati'-na mga iya si mga allingun-mo?” ");
INSERT INTO abx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Anaruman si Jesus, “I kada tinanom nga ma'in pinatanum-na si langitnon Tatay-ko, rarabnuton. ");
INSERT INTO abx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pata'ani-bi hamok mga iya, kay mga iya i makapariho si mga paraggiya nga buta. Kon agpatuttot i adda buta si kaparihu-na buta, sigurado agkataralibho' mga iya duwangan.” ");
INSERT INTO abx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pero aminugad dina si Pedro, “Isplikarin daw kami' sinan isturya nga agtukoy si kamatu'uran.” ");
INSERT INTO abx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Anaruman si Jesus, “Mga maluya pa kam gayod! Ga'i pa ba' kam gihapon agpakasabot? ");
INSERT INTO abx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gana' gayod pasallod si bawa'-na si a'a nga akarigsok si iya kay agdiritsoy nan dina pan battung-na ngan pagawas gihapon si puhu'-na. ");
INSERT INTO abx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero i pagawas si bawa'-na si a'a agtikang gayod si inisipan-na, sanglit iyay nan i makaparigsok si iya ");
INSERT INTO abx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","kay tikang si kina'iya-na i pagbuhat si mga sala' pariho si mga mara'at inisipan, pagmatay, pagbisyo si pagdangallahan o ma'in ngani' i pag'ubay si bisan say hamok sasindakan-na, pagtangkaw, pagtistigos si kinabubullu'an pati' paggutgot. ");
INSERT INTO abx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyay nan i mga makaparigsok si a'a; pero i pagkakan nga ga'i agkuso' si tama' pa'agi, ga'i akaparigsok si iya.” ");
INSERT INTO abx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Katapos pa'amban kas Jesus ari siray lugar basi' agpakadiskanso dahulo ari si lugar nga sakup-na si duwa syudad Tiro pati' Sidon. ");
INSERT INTO abx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pero aniya' danda padugok si iya nga Canaana mag'istar siray lugar. Amahalling to makusog, “Sinyor, Dadi'-na si David, kalu'uyin ako! Nagbawa-bawa si mara'at espirito i dadi'-ko danda ngan bali na gayod ra'at i kamutangan-na.” ");
INSERT INTO abx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ga'i gayod anaruman si Jesus bisan adda allingon. Sanglit pamadugok si iya i mga inadalan-na ngan sigi pamakibagaw, “Tumanin naynan hamok iya kay ga'i may pahuway si katuturakaw si damurihan-ta kam.” ");
INSERT INTO abx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Anaruman si Jesus, “Nagpabawa ako pada'ito para hamok pagpanginano si mga a'a-na si Israel nga agkaralilingo.” ");
INSERT INTO abx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tungod sinan, padugok i danda ngan anluhod atubang si iya. Aminugad to, “Sinyor, buligin ako!” ");
INSERT INTO abx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Anaruman may si Jesus, “Ma'in tama' pagsiyo si kinakan-na si mga dadi' basi' apatapok hamok si mga ka'idu'an.” ");
INSERT INTO abx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Ungod nan, Sinyor,” lingun-na may si danda. “Pero bisan ngani' i mga ka'idu'an agpakakakan gihapon si mga mu'mo' magkataraktak si lamisa-na si mga amu-na.” ");
INSERT INTO abx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sanglit agsarumanan-na iya si Jesus, “Mana, hugot gayod i pagtu'u-mo! Atuman i maliyat na nag'anduy-mo.” Ngan anhalap dayon i dadi'-na mismo siray uras. ");
INSERT INTO abx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pataliwan kas Jesus ari siray lugar ngan ag'agi mga iya si bihing-na si Danaw Galilea. Katapos, pasagka iya si adda tagudtod ngan ari agparatingkulo'. ");
INSERT INTO abx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bali labbat i magpanggubok namay si iya ngan aniya' sito nagpamawa-na mga lulid, mga buta, mga kiyod, mga ngula ngan malabbat pa mga maburong. Agpama'anna'-nay to mga iya atubang si Jesus, ngan agpamulung-na. ");
INSERT INTO abx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ag'usa gayod i mga a'a si pakakulaw-na mga iya nga akayawit i ngula, anhalap i kiyod, akalangngan i lulid ngan akakulaw na i buta. Ngan agdayaw-na dayon mga iya i Diyus-na si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Agban'u-na si Jesus i mga inadalan-na ngan aminugad, “Alu'oy ako sito mga a'a, kay tallo allaw na mga iya i pag'istar-na ato paghuwang si kita kam, sanglit akatibusan si mga balun-na. Ga'i ako aruyag nga pamalitira-ko hamok mga iya nga mga linganto, kay sigurado nga aniya' si mga iya magkadirismayo si lalan.” ");
INSERT INTO abx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Amatilaw i mga inadalan-na, “Singnga may kita kam anganda' si mga pan nga akahusto pammakakan sinan kalabbat mga a'a ato sito lugar si kamingawan?” ");
INSERT INTO abx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Pira pa bug'os pan-bi nan?” lingun-na si Jesus. Anaruman may mga iya, “Pito' nayto hamok ngan aniya' pa diki'it mamadiki' agon.” ");
INSERT INTO abx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Agmandaran-na si Jesus i mga a'a paglumpagi'. ");
INSERT INTO abx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mangno ag'ala'-na i pito' bug'os pan pati' i agon. Pakapasalamat-na si Diyos, agpanurutabbi'-nay to ngan agparu'du'-na si mga inadalan-na ngan mga iya i magtaltag si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Agpakapamangan i dimu'an ngan agpakagustuhan. Katapos akatipon pa dina i mga inadalan pito' sagad nga puro panno' si mga tinurutabbi' la'a. ");
INSERT INTO abx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bisan i mga lalla hamok magpakakakan siray allaw anakka mga kwatro mil, pwira pa si mga danda pati' si mga kadadi'-dadi'an. ");
INSERT INTO abx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pakapalitira-na si Jesus si mga a'a, pasang'at iya si paraw ngan agbiyahi pada'iray si lugar-na si mga Magdaleno. ");
INSERT INTO abx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mangno, aniya' mga Parisiyo pati' mga Sadusiyo magpamada'iray si Jesus ngan agpamalako kon akahimo iya pangngilalahan si langitnon kasiguruhan para si mga iya pagsiguro nga ungod gayod agka'adda mga iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero anaruman dina si Jesus, “Sangom na ngani' aminugad kam, ‘A, mahalap ina'anto i panahon kay mapiyat i langit.’ ");
INSERT INTO abx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Katapos kanalungan namay aminugad kam, ‘A, mara'at i panahon ina'anto kay mapiyat i langit ngan sigi dadampog.’ Ata'o kam lugod pagkilala si kamutangan-na si kalangitan, pero ga'i kam agpakatu'anan si mga pangngilalahan si ina'anto mga panahon. ");
INSERT INTO abx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kinakulawan gayod i kara'at-na si mga a'a sito panahon nga makihuhuwangon si mga pala'in-la'in diyos kay sigi hamok paralakuhay si mga pangngilalahan si langitnon kasiguruhan. Pero gana' na parakulawon pa si mga iya pwira si pangngilalahan siray nga nagbuhat si Jonas.” Sanglit patalikot kas Jesus si mga Parisiyo pati' si mga Sadusiyo ngan diritso pamalitira. ");
INSERT INTO abx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Si pakatba-na na mga iya si danaw, sadiskubrihan-na si mga inadalan-na nga salimutan-na mga iya pagbawa pan. ");
INSERT INTO abx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pero si Jesus namay, agpadayon pagturo' si mga iya pina'agi si pagpada'an, “Agmatuha kam! Agpanlikaya kam si pammatubu'-na si mga Parisiyo pati' si mga Sadusiyo.” ");
INSERT INTO abx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sanglit, agsingurub-ngurubay dayon mga iya, “Sapahalling-na gad nan hamok kay ga'i kita kam agpakabawa pan nga agkinahanglan pammatubo' paghimo.” ");
INSERT INTO abx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sakatu'anan-na andang si Jesus i mga bararagaw-na, sanglit agpinugad-na mga iya, “Kulang pa kam si pagtapod! Ay kay agbararagawan-bi gayod i ga'i pakabawa-ta kam balon? ");
INSERT INTO abx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ga'i pa ba' kam hamok gihapon agpakasantop? Ga'i ba' sa'intuman-bi kon pira pa dina sagad satipun-bi nga puro panno' si la'a-na si mga a'a ngan pagturutabbi'-ko si lima bug'os pan para si singko mil a'a? ");
INSERT INTO abx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ngan pira liwat sagad satipun-bi nga puro panno' ngan pagturutabbi'-ko si pito' bug'os pan para si kwatro mil a'a? ");
INSERT INTO abx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kapa'i may kay ga'i pa kam hamok gihapon agpakasantop nga ma'in mahi'unong si pan i nagbagaw-ko si ka'am? Pero aglikaya kam si pammatubu'-na si mga Parisiyo pati' si mga Sadusiyo.” ");
INSERT INTO abx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tungod sito, sasabutan-na dayon mga iya nga ma'in i pammatubo' si pan i nagtukuy-na si Jesus nga rilikayan-na mga iya, kundi' pagmato si mga turu'-na si mga Parisiyo pati' si mga Sadusiyo. ");
INSERT INTO abx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ngan panakka-na kas Jesus si mga lugar nga sakop si bungto Cesarea Filipos, agtilaw-na i mga inadalan-na, “Si mga burubaragaw-na si mga a'a mahi'unong si Pinili' A'a, say may kuno' iya?” ");
INSERT INTO abx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Anaruman may mga iya, “Aniya' magpaminugad nga iya kuno' si Juan Paragbunyag, ngan i ditangnga' may, iya kuno' si Elias. Pero aniya' liwat magpaminugad nga iya kuno' si Jeremias o ma'in ngani' tingali addangan pa si mga paragsumat-na si Diyos siray.” ");
INSERT INTO abx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Amatilaw gihapon iya, “Pero para si ka'am, say may i pagkakilala-bi si ako?” ");
INSERT INTO abx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Anaruman may si Simon Pedro, “Ka'aw i Tinu'inan Mannanalwas, i Dadi'-na si gana' kamatayun-na Diyos.” ");
INSERT INTO abx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aminugad may si Jesus si iya, “Malipayon kaw Simon nga dadi'-na si Jonas, kay ma'in a'a i magpakatu'an si ka'aw sinan kundi' mismo i Tatay-ko si langit. ");
INSERT INTO abx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ngan sumatan-ta kaw, ka'aw si Pedro, ngan anan sinan bato papatindugun-ko i manniniripon pag'ampo' nga ga'i pwidi salupig-na si gahum-na si kamatayon. ");
INSERT INTO abx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Papa'intrigahun-ko si ka'aw i lyabi si pagdalom si mga nagpanhadi'an-na si man langit. Bisan ay i nagpatugut-bi ato si kalibutan, nagpatugot may liwat ari si langit. Pero bisan ay i nagdiri'-bi ato si kalibutan, nagdiri' may liwat ari si langit.” ");
INSERT INTO abx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Katapos agtugunan-na si Jesus i mga inadalan-na nga ga'i gayod pagsumat si bisan say nga iya i Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kahuman siray, agtikangan-na si Jesus agsumat i mga inadalan-na, “Kinahanglan nga pada'iray ako si Jerusalem ngan ag'agi pala'in-la'in kasakitan marandu'un-na si mga mata'o kamabu'utan, si mga puno' paraghalad pati' si mga paragturo' bala'od. Pwira pa sinan, maratayon ako, pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ag'agda-na si Pedro si Jesus pabulag basi' sasu'it-na i amu-na. Agpinugad-nay to, “Paragdalom, andiri' i Diyos sinan! Ga'i nan ahinabo' si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero tili'-na dina iya si Jesus ngan diritso aminugad, “Ala'on nan si inisipan-mo, kay tawa'-nay nan si Satanas! Ka'aw i maka'ulang si naglalangnganan-ko. Imbis nga i mga katuyu'an-na si Diyos i nagpanginanu-mo, i tawa'-na dina si a'a i nagpasi'urug-mo!” ");
INSERT INTO abx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kata'ud-ta'uran, agsumatan-na si Jesus i mga inadalan-na, “Kon aniya' maruyag pagbaya' si ako, kinahanglan limut-na i mga kalugaringun-na katuyu'an, ngan agsunod si ako. Padayun-na i pag'ako' si mga pag'antus-na pariho si adda makamamalo' kamatayon si kudos. ");
INSERT INTO abx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kay bisan say i magpasiguro si kalugaringun-na kinabuhi' ina'anto, iya dina i tikarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero bisan say i magkarag si kalugaringun-na kinabuhi' para si ako, iya dina i maka'anda' si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ay i kapulsanan-na kon satawa'-na si a'a i bug'os kalibutan pero agkaragan-nay to dina kinabuhi'? Gana'! Kay gana' sapabayad-na si a'a nga sabawi'-nay nan gihapon kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tipada'ito i Pinili' A'a huwang i mga anghel-na nga nagsigahan palibot si maka'angayan danta'-na si Tatay-na ngan katapos pamuwanan-na i balang addangan si kararawatun-na primyo sigon si mga sabuhat-na. ");
INSERT INTO abx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sumatan-ta kam si kamatu'uran, aniya' si mga satu'oy to ina'anto nga ga'i amatay tubtob nga ga'i pa mga iya sakulawan-na i pagpada'itu-na si Pinili' A'a nga sa'angkun-na i pagkahadi'-na.” ");
INSERT INTO abx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kahuman si annom allaw, ag'agda-na si Jesus si Pedro hasta i magdingsirarihan Santiago pati' Juan paghuwang si iya. Agdahulo iya pasagka si adda madyalta bukid. ");
INSERT INTO abx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngan panakka-na na mga iya si buntay, si pagparakukulaw-na mga iya si Jesus, anla'in i puhu'-na. Agsiga i bayhun-na pariho si allaw ngan amuti' i badu'-na pariho si magdanta'. ");
INSERT INTO abx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mangno sakulawan-na mga iya nga hintak pamaluwa' kas Moises pati' si Elias ngan agbararagaw mga iya kas Jesus. ");
INSERT INTO abx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Agsupla-na si Pedro i baragaw-na kas Jesus si pagpinugad, “Paragdalom, mahalap gayod kay atiya' kita kam. Kon aruyag kaw, anhimo kami' tallo payag-payag para si ka'am, i adda para si ka'aw, i adda may tawa'-na si Moises, ngan i adda namay tawa'-na si Elias.” ");
INSERT INTO abx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ga'i pa iya atapos agparapahalling, aniya' pahulwa' madakmol panganod nga bali danta' ngan akatambunan mga iya sito. Mangno aniya' busis tikang si panganod nga agpinugad, “Iyay nan i Dadi'-ko nga hinigugma'-ko. Alipay gayod ako si iya. Amati'a kam si iya!” ");
INSERT INTO abx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pakabati'-na sinan si mga inadalan, agpaka'akkom mga iya tungod si mga katalaw-na. ");
INSERT INTO abx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pero padugok si Jesus ngan agpamalpak-na mga iya. Aminugad to, “Pabanguna kam anan, ngan dakam agkataralaw.” ");
INSERT INTO abx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Panhangad-na mga iya, gana' na mga sakulawan-na pwira na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ngan padalugdug-na na mga iya man bukid, agtugunan-na mga iya si Jesus, “Dakam agparasumat si bisan say si sakulawan-bi tubtob nga abanhaw i Pinili' A'a.” ");
INSERT INTO abx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amatilaw i mga inadalan si iya, “Pero kapa'i may kay agparapaminugad dina i mga paragturo' bala'od nga kinahanglan dahulo i pagpada'itu-na si Elias?” ");
INSERT INTO abx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Anaruman si Jesus, “Ungod nan, pada'ito si Elias paghamis si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero sumatan-ta kam nga manatu'o na dina si Elias ngan ga'i to sakilala-na si mga a'a. Lugod, gana' maka'ulang si mga iya pagbuhat si mga nagplanu-na karat'an para si iya. Si pariho pa'agi, papasakitan-na liwat mga iya i Pinili' A'a.” ");
INSERT INTO abx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sasabutan-na dayon si mga inadalan nga i nagtukuy-na si Jesus si nagparapahalling-na si mga iya, iya si Juan Paragbunyag. ");
INSERT INTO abx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Si pagbwilta-na mga iya si magpantarambak, aniya' lalla padugok si iya ngan anluhod. ");
INSERT INTO abx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aminugad to, “Sinyor, kalu'uyin may dadi'-koy to. Buntugon iya ngan bali na i inagi-na kasakitan. Agsob iya akasugba si api, ma'in ngani' akarabbo' si buwahi'. ");
INSERT INTO abx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Agbawa-ko na iya si mga inadalan-mo, pero ga'i mga iya sapahalap-na.” ");
INSERT INTO abx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Anaruman si Jesus, “Ay badaw! Ga'i pa gayod anutu'o mga a'ay to ina'anto panahon ngan bali kamakasuplikado! Pira pa i kinahanglan pag'istar-ko ato pati' i irilubun-ko si ka'am basi' agpanutu'o kam? Bawahon iya ato.” ");
INSERT INTO abx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Paka'isug-na si Jesus si mara'at espirito, diritsoy to pa'amban si dadi' ngan anhalap dayon iya mismo siray uras. ");
INSERT INTO abx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mangno pamadugok si Jesus i mga inadalan ngan agpamatilaw nga gana' la'in makapakali, “Apa'i may kay ga'i ray sapapinda kami' mara'at espirito?” ");
INSERT INTO abx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Anaruman may si Jesus, “Ada'inan nan tungod kay kulang pa gayod i pagtutu'u-bi. Kay sumatan-ta kam si kamatu'uran, kon aniya' may dina pagtutu'u-bi pariho kadiki'-diki' si lisu-na si tinanom mustad, pwidi kam akapinugad sito bukid, ‘Tigpatukala anan ngan tiglalina ari’ ngan diritsoy to palalin. Gana' si mga tuyu'-bi nga ga'i atuman.” ");
INSERT INTO abx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngan pagbiririyu'-na si mga inadalan ari si Galilea, agpanumatan-nay to si Jesus, “Trarayduran i Pinili' A'a ngan papa'intrigahon iya si pagdalum-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Matay-nay to mga iya, pero abanhaw si katallo allaw.” Tungod sinan, bali i mga kabidu'-na si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngan panakka-na kas Jesus pati' si mga inadalan-na ari si syudad Capernaum, nagdugok si Pedro si mga paragsukot si duwa drakma buhis ngan agpamatilaw, “Agparabayad ba' ma'istru-bi nan si buhis para si templo?” ");
INSERT INTO abx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Anaruman may iya, “Oho', agparabayad iya.” Ngan pagbalik-na na si Pedro si ruma'-na mga iya, si Jesus i primiro makapahalling. “Simon, ay si pag'abat-mo, say i mga nagparapanguliktahan-na si mga hadi' ato si kalibutan si pala'in-la'in kabaraydan pati' buhis? I mga a'a-na o i ma'in?” ");
INSERT INTO abx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“I mga ma'in a'a-na,” lingun-na may si Pedro. Aminugad may si Jesus, “Kon sugad, kunta' hasta kita kam agpakalibri. ");
INSERT INTO abx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero, para ga'i kita agkasinahan-na mga iya, mamangarawa ari. Addu'on dayon i primiro sadawi-mo ngan ngangahon i bawa'-na kay ari sa'anda'an-mo i adda kwarta diplata nga ampat drakma i balur-na. Bawahon ngan pabayaron si mga iya para si buhis-ko pati' si tawa'-mo.” ");
INSERT INTO abx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mismo siray uras, pamadugok i mga inadalan si Jesus ngan agpamatilaw, “Say ba' gayod i pinakabantugan si mga nagpanhadi'an-na si man langit?” ");
INSERT INTO abx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aniya' dadi' nagban'u-na si Jesus ngan agpatunggu-nay to atubang si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mangno aminugad, “Sumatan-ta kam si kamatu'uran, hasta nga ga'i kam agsalli' ngan angirog si kina'iya-na si mga dadi', sigurado nga ga'i kam agpakahuwang si mga nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kon sugad, bisan say i magpa'ubos si kalugaringun-na pariho sito dadi', iya i pinakabantugan si mga nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Bisan say i magpanginano pahalap si a'a nga ga'i mismo aka'allom si kalugaringun-na pariho sito dadi' tungod si gugma'-na si ako, agpanginano gayod si ako. ");
INSERT INTO abx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mara'at gayod si a'a kon nagpa'ingkutan i kallung-na gilingan bato ngan nagtunura si kalawot. Pero bisan kon mara'at to, mas mahalap payto kuntra kon akapa'amban iya si la'in nga baha'o pa hamok magtutu'o. ");
INSERT INTO abx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Papabidu'on gayod i kalibutan tungod kay sigurado nga aniya' buhat-na si a'a nga akapa'amban si pagtu'u-na si la'in! Gana' duda nga pamaluwa' to dimu'an, pero papabidu'on i a'a magbuhat sinan. ");
INSERT INTO abx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sanglit kon akapa'amban si pagtutu'u-mo i nagparahimu-na si tamburu'-mo o ma'in ngani' i nagparapada'irayan-na si kitid-mo, uturon ngan tapukin. Mas mahalap pa kon punggol kaw nga akaprubitso si gana' katapusan-na kinabuhi' kuntra kon huwang si ka'aw i duwa tamburu'-mo o i duwa kitid-mo nga pinabar'og kaw si gana' kapaparungun-na api. ");
INSERT INTO abx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ngan kon akapa'amban si pagtutu'u-mo i nagparakukulawan-na si mata-mo, ala'on adday nan ngan tapukin. Mas mahalap pa kon buta i adda mata-mo nga akaprubitso kaw si gana' katapusan-na kinabuhi' kuntra kon huwang si ka'aw i duwa mata-mo nga linaho' kaw pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aghinaya kam nga gana' nagtamay-bi bisan addangan si mga baha'oy to pa hamok magtutu'o. Kay sumatan-ta kam nga i mga anghel-na mga iya ari si langit pirmi ag'atubang si langitnon Tatay-ko. ");
INSERT INTO abx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ay si pag'abat-bi kon da'ito i mahinabo'? Kon addangan si ka'am i aniya' addahatos karniru-na, katapos alilingo i adda, ay binuhat-bi? Sigurado ambanan-bi i nubintay nwibi ari si tahok ngan anda'-bi i malilingo. ");
INSERT INTO abx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Malipayon kam gayod si paka'anda'-bi, ngan sumatan-ta kam si kamatu'uran, mas mahaya i kalipayan-bi para si adday nan karniro kuntra si nubintay nwibi ray nga ga'i agkaralilingo. ");
INSERT INTO abx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Si pariho pa'agi, ga'i may liwat aruyag i Tatay-bi si langit nga aniya' magkapirirdi bisan addangan sito mga a'a nga agtikang pa hamok si mga pagtutu'u-na.” ");
INSERT INTO abx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Agpadayon si Jesus pagpasabot si mga iya, “Sanglit kon agsakit kaw tungod si sala'-na si bugtu'-mo si pagtu'o, paduguka si iya ngan isplikarin si sala' nagbuhat-na, nga ka'am hamok duwangan. Kon amati' iya si ka'aw, sapabalik-mo gihapon iya si hul'os pagtu'o. ");
INSERT INTO abx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero kon ga'i iya mamati', amabaya'a addangan o ma'in ngani' duwangan kabugtu'an basi' akapamatu'uran i dimu'an nagkabaragawan pina'agi si duwangan o tallungan nga sayod si kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kon ga'i pa liwat to mamati' si ka'am, pasumaton to atubang si manniniripon pag'ampo' basi' aku'-na nga sala'an iya. Ngan kon andiri' pa liwat iya gihapon si pag'aradda-na si manniniripon pag'ampo', kilalahu-bi na iya pariho si ga'i magtutu'o Diyos o pariho si paragsukot buhis. ");
INSERT INTO abx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kay sumatan-ta kam si kamatu'uran, bisan ay i nagpatugut-bi ato si kalibutan, nagpatugot may liwat ari si langit. Pero bisan ay i nagdiri'-bi ato si kalibutan, nagdiri' may liwat ari si langit. ");
INSERT INTO abx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Si pariho kamutangan, kon aniya' duwangan si ka'am magka'adda si bisan ay nagpalaku-bi ato si kalibutan, tuman-nay nan si Tatay-ko si langit para si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kay basta aniya' magkatiripon bisan hamok duwangan o ma'in ngani' tallungan nga agpan'ako' si arun-ko, awiray ako si mga iya aghuwang.” ");
INSERT INTO abx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mangno padugok si Pedro ari si Jesus ngan amatilaw, “Paragdalom, simpira kinahanglan pasaylu-ko i bugtu'-ko si pagtu'o kon sigi hamok iya pakasala' si ako? Tubtob ba' si pito' bisis?” ");
INSERT INTO abx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Anaruman si Jesus, “Sumatan-ta kaw, ma'in hamok tubtob si pito', kundi' tubtob si sitinta pagpitu'i.” ");
INSERT INTO abx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Agpadayun-na si Jesus i saruman-na si pag'isturya, “Kon sugad i paghadi'-na si man langit akapariho si adda hadi' nga aruyag na pagbalansi si mga rilihugun-na. ");
INSERT INTO abx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Si pagkwirintahay-na na mga iya, aniya' addangan nagban'u-na pagpa'atubang si iya nga bali haya kantidad i sa'utang-na. ");
INSERT INTO abx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tungod kay ga'i may nan gayod sabayaran-na, agmando' i amo nga binaligya'an mga iya si la'in bilang mga uripon huwang i alla-na pati' i mga dadi'-na hasta pa i mga inanna'-na dimu'an para hamok aniya' mapabayad si utang-na. ");
INSERT INTO abx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Anluhod i rilihugon atubang si iya ngan makimalu'oy, ‘Alayon pag'angan-angan makali' panahon kay bayaran-ko may nan utang-koy nan dimu'an.’ ");
INSERT INTO abx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tungod si kalu'uy-na si amo, agpabalik-na iya nga para' gayod i dimu'an sa'utang-na. ");
INSERT INTO abx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pero si pagawas-na sito rilihugon, aniya' sabagatan-na addangan si mga igkasi-na rilihugon nga aka'utang hamok si iya syin dinari diplata. Agdagnas-nay to ngan agtiklu'-na dungan si pagparasukut-na, ‘Bayarin na ako si sa'utang-mo!’ ");
INSERT INTO abx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Anluhod atubang si iya i parihu-na rilihugon ngan makimalu'oy, ‘Alayon pag'angan-angan makali' panahon kay bayaran-ta may kaw.’ ");
INSERT INTO abx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pero ga'i to agpamati'an-na, kundi' agpaprisu-nay to dina ngan ga'i to tigpagawas-na tubtob si pakabayad-na si dimu'an sa'utang-na. ");
INSERT INTO abx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pakakulaw-na sinan hinabo' si ditangnga' mga rilihugon, bali i mga kabidu'-na sanglit padugok mga iya si amo ngan agpamasumbong si dimu'an mahinabo'. ");
INSERT INTO abx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Katapos agpaban'u-na si amo i rilihugon pagpasallod gihapon ngan ag'isugan-na, ‘Gana' kwinta-mo rilihugon! Agpara'-ko i dimu'an sa'utang-mo si ako tungod kay makimalu'oy kaw. ");
INSERT INTO abx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kunta' alu'oy may kaw liwat si igkasi-mo rilihugon pariho si nagbuhat-ko may si ka'aw!’ ");
INSERT INTO abx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ngan tungod si kasina-na si amo, agpa'intriga-nay to si wardin nga padayon i pagkastigo si iya hasta nga ga'i to akabayad si dimu'an utang-na. ");
INSERT INTO abx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Da'inan sinan i pa'agi-na si langitnon Tatay-ko si kada addangan si ka'am nga ma'in kinasing-kasing i pagpasaylu-na si bugtu'-na si pagtu'o.” ");
INSERT INTO abx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kahuman-na agparapahalling sinan si Jesus, pa'amban iya si Galilea. Pada'iray namay mga iya si parti si Judea nga aka'anna' si dambila'-na si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kalabbatan pirmi i magpamungyod si mga iya ngan aniya' may nagpamulung-na si Jesus si mga salabayan-na lugar. ");
INSERT INTO abx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mangno aniya' magpamada'iray si iya mga Parisiyo para hamok pagpurbar kon anala' iya si mga allingun-na. Amatilaw mga iya, “Nagpatugot ba' si bala'ud-ta kam nga akabulag i lalla si alla-na si bisan ay hamok rasuna?” ");
INSERT INTO abx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Patilaw i saruman-na si Jesus, “Ga'i ba' kam liwat agpakabasa si Kasuratan nga si panikangan, aghimu-na si Paraghimo i a'a, lalla pati' danda. ");
INSERT INTO abx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Katapos agtugon iya, ‘Sanglit, kinahanglan pa'amban i lalla si tatay-na pati' si nanay-na ngan maki'adda si alla-na basi' mga iya duwangan ahimo na hamok adda puho'.’ ");
INSERT INTO abx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kon sugad, ma'in na mga iya duwangan kundi' addangan na hamok. Sanglit kon ay i nagbug'us-na si Diyos, kinahanglan nga ga'i gayod agbulag-na si a'a.” ");
INSERT INTO abx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amatilaw gihapon i mga Parisiyo, “Kapa'i may kay aniya' mandu'-na dina si Moises nga kon aniya' na papilis si pagbulag, pwidi na sapaduwa'i-na si lalla i alla-na?” ");
INSERT INTO abx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Anaruman may si Jesus, “Tungod si pagdiri'-bi pag'isip malalom, agtugutan-na kam si Moises nga sabulagan-bi i mga alla-bi. Pero si tinikangan gayod ma'in da'inan sinan. ");
INSERT INTO abx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sumatan-ta kam nga bisan say lallaha nga pabulag si alla-na nga ga'i may to agbisyo si pagdangallahan-na mga iya, mangno pakasal iya si la'in danda, si kamatu'uran agsala' iya tungod si pagtig'ub-na si la'in. I da'inan klasi pagbulag ma'in tugot si bala'od.” ");
INSERT INTO abx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aminugad si iya i mga inadalan-na, “Kon da'inan may hamok sinan ka'istrikto i kamutangan si magdangallahan, mas mahalap na hamok nga ga'i ag'alla.” ");
INSERT INTO abx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Anaruman si Jesus si mga iya, “Yayto mga turo' ga'i sa'aku'-na si bisan say, pero kon i Diyos gayod i magpa'ambit si katuyu'an-na sito mga sa'aku'-nay to. ");
INSERT INTO abx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aniya' mga a'a nga tikang pa si paka'allum-na aniya' andang dipirinsya-na nga day mga kapon. Aniya' may liwat nga agpatuyo' gayod pagpakapon, kundi' aniya' may liwat magpandiri' gayod pag'alla basi' hul'os i mga pagsirbi-na si mga nagpanhadi'an-na si man langit. I maka'ako' sito kamutangan, kunta' ga'i iya agruha-duha pagtuman sito.” ");
INSERT INTO abx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Siray uras aniya' magpamawa si mga dadi'-na pada'iray si Jesus. I karuyag-na kunta' mga iya nga sadu'unan-na si mga palat-na si Jesus i mga dadi'-na pati' sapangadyi'an-na, pero agsimul-na si mga inadalan i mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kundi' aminugad dina si Jesus, “Tuguti-bi i kadadi'-dadi'an pagdugok si ako ngan dakam ag'ulangu-bi mga iya, kay i da'inan mga a'a i papasakupon si nagpanhadi'an-na si man langit.” ");
INSERT INTO abx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pakadu'un-na si Jesus si mga iya sa'uru'addangan, pa'amban iya ari siray lugar. ");
INSERT INTO abx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sin adda, aniya' lalla padugok si iya ngan diritso amatilaw, “Ma'istro, ay i mahalap buhat nga kinahanglan buruhatun-ko basi' sa'angkun-ko i kinabuhi' nga gana' katapusan-na?” ");
INSERT INTO abx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Anaruman dina si Jesus, “Kapa'i may kay agpatilaw kaw si ako mahi'unong kon ay i mahalap? Aniya' hamok Addangan nga mahalap. Kon aruyag kaw pagprubitso sinan kinabuhi', tumanon i mga kasugu'an.” ");
INSERT INTO abx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Ay mga kasugu'ana?” i saruman-na may si lalla. Aminugad may si Jesus, “Dakam agmatay, dakam agbisyo si pagdangallahan, dakam agtangkaw, dakam agbullo' si pagtistigos, ");
INSERT INTO abx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","agtahura kam si tatay-bi pati' si nanay-bi, pati' higugma'u-bi i igkasi a'a-bi pariho si paghigugma'-bi si kalugaringun-bi.” ");
INSERT INTO abx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Anaruman may i lalla, “Agsunud-ko naynan mga kasugu'an. Ay pa i pangulangan-ko?” ");
INSERT INTO abx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Agpinugad-na iya si Jesus, “Kon aruyag kaw nga atuman i katuyu'an-na si Diyos si kina'iya-mo, agbalika ari ngan baligya'in i dimu'an inanna'-mo. Pumwanon si mga anggana' i balli-na basi' aniya' kayamanan-mo ari si langit. Katapos pada'ituha basi' akabaya' kaw ngan agsunod si ako.” ");
INSERT INTO abx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngan pakabati'-na sinan si lalla, pa'amban to nga masurub'on kay iya i a'a nga bali haya i kayamanan-na. ");
INSERT INTO abx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Katapos agpinugad-na si Jesus i mga inadalan-na, “Sumatan-ta kam si kamatu'uran, makuri gayod nga akasakop i mga mayaman a'a si nagpanhadi'an-na si man langit. ");
INSERT INTO abx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bwilta-ko gihapon, mas makuri payto kuntra si pag'agi-na si adda kamel si tanugan-na si dagom!” ");
INSERT INTO abx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pakapamati'-na sinan si mga inadalan, ag'usa gayod mga iya sanglit agsipurupatilaway, “Kon sugad, say i masalbar?” ");
INSERT INTO abx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Buslung-na mga iya si Jesus ngan anaruman, “Impusibli to nga sahimu-na si a'a, pero sahimu-na si Diyos i dimu'an.” ");
INSERT INTO abx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mangno amahalling si Pedro, “Tara', kay ag'ambanan kami' i dimu'an tawa' kami' pagsunod si ka'aw! Ay may i mga kararawaton kami'?” ");
INSERT INTO abx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“Tama', ungod nan,” lingun-na may si Jesus. “Sumatan-ta kam si kamatu'uran, si uras nga analli' na i baha'o kalangitan pati' kalibutan, si paningkulu'-na gayod si Pinili' A'a si maka'angayan trunu-na, ka'am magpamaya' nan si ako, papatingkulu'on liwat si dusi truno basi' sahusgaran-bi i dusi pamilya si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bisan say i pa'amban si ruma'-na, si mga kadingsirarihan-na, si tatay-na o nanay-na, si mga dadi'-na, o mga uma-na para atuman i katuyu'an-ko, iya i tikarawat sinan dimu'an addahatos pa dina dubli ngan aka'angkon pa liwat iya si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero malabbat nagpanhangad kuno' ina'anto nga si damuri allaw agpaka'ubos dina, ngan malabbat liwat magpama'ubos ina'anto nga si damuri allaw nagpanhangad dina.” ");
INSERT INTO abx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Agpadayon si Jesus si mga allingun-na, “Ada'inan nan kay i pagsakup-na si a'a si mga nagpanhadi'an-na si man langit akapariho si aniya' pitak-na a'a nga paduwa'i nalung-nalong pa pagsangpit mga trabahanti si ubasan-na. ");
INSERT INTO abx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I nagkabaragawan inallaw-na si kada addangan, adda dinari diplata. Sanglit agpamapada'iray-nay to dayon si ubasan-na. ");
INSERT INTO abx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ngan ka'alasnwibihan, paduwa'i gihapon iya ngan sakulawan-na nga aniya' pa magparapanunggo si mirkado nga gana' mga trabahu-na. ");
INSERT INTO abx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Agpaminugad-nay to, ‘Amukura kam pada'iray si ubasan-ko basi' agpakatrabaho kam liwat ngan bayaran-ko may kam kon ay i tama'.’ ");
INSERT INTO abx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sanglit agpamada'iray mga iya. “Da'inan gihapon sinan i nagbuhat-na ngan pangalasdusi na hasta si pangalastris na. ");
INSERT INTO abx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mangno, ngan mga un'ura na hamok myintras aglulu'om, paduwa'i iya ngan aniya' pa liwat gihapon sakulawan-na magparapanunggo hamok. Agpanilaw-nay to, ‘Ay kay sigi kam hamok panunggo ato si bug'os allaw nga gana' turutrabahu'ay?’ ");
INSERT INTO abx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Lingun-na may mga iya, ‘Kay gana' may magsangpit si kami'.’ “Agpaminugad-nay to, ‘Hala, pada'iraya kam liwat si ubasan-koy ray basi' agpakatrabaho kam.’ ");
INSERT INTO abx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kasanguman, agpinugad-na si tagtawa' si ubasan i kapatas, ‘Tiripunon i mga trabahanti ngan panwilduhin. Padahulu'on agbuwan i mga damuri nagsangpit-ko ngan pasunuron pada'iray si mga primiro gayod.’ ");
INSERT INTO abx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“I magkasarangpit mga trabahanti nga un'ura na hamok myintras aglulu'om, puro agpakakarawat sa'aradda dinari diplata. ");
INSERT INTO abx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sanglit agla'om i mga magpakadahulu'an nagsangpit nga mas mahaya i mga kararawatun-na. Pero kada addangan si mga iya, adda dinari diplata gihapon i mga sakarawat-na. ");
INSERT INTO abx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Si pakakarawat-na mga iya si swildu-na, sigi dayon mga iya panngurub-ngurob kuntra si tagtawa'. ");
INSERT INTO abx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Aniya' si mga iya maminugad, ‘Ay kay agpaparihu-mo hamok si kami' i swildu-na si mga damurihan nagsangpit-mo nga un'ura namay hamok i mga satrabahu-na mga iya, kumparar si kami' nga maka'ura-urahan si trabaho ngan magbatad gayod si bug'os allaw?’ ");
INSERT INTO abx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pero agsarumanan-na si tagtawa' i addangan si mga iya, ‘Sangkay, ga'i may kaw agdaya'an-ko. Angumpurmi kam nga adda dinari diplata i allaw-bi, ma'in ba'? ");
INSERT INTO abx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sanglit, karawaton i iksakto swildu-bi ngan agpamalika na kam. Agtuyu'-ko gayod i pagbuwan pariho swildo si mga magpakadamurihan nagsangpit pati' si ka'am. ");
INSERT INTO abx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Katungud-ko gayod i pagdalom kon ay i karuyag-ko si kalugaringun-ko kwarta. O tingali a'awa' kam hamok tungod si pagkamabinuwan-buwanun-ko.’ ");
INSERT INTO abx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Adday nan halimbawa' pagpasabot si nagpinugad-ko pa hamok nga aniya' malabbat nagpanhangad kuno' ina'anto nga si damuri allaw agpaka'ubos dina ngan malabbat liwat magpama'ubos ina'anto nga si damuri allaw nagpanhangad dina.” ");
INSERT INTO abx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngan pagsasagka-na na kas Jesus pan Jerusalem, agbulag-na i dusi mga inadalan-na tikang si kalabbatan ngan agpaminugad-nay to, ");
INSERT INTO abx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pasagka kita kam pan Jerusalem kon singnga trarayduran ngan papa'intrigahon i Pinili' A'a pada'iray si mga puno' paraghalad pati' si mga paragturo' bala'od. Paratukan iya kamatayon ");
INSERT INTO abx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ngan papa'intrigahon si mga ma'in Hebro. Ralangkagan-na iya sito mga a'a, ralapduson, ngan papapaku'on si kudos pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mangno padugok si Jesus i alla-na si Sebedeo huwang i duwangan dadi'-na. Anluhod iya atubang si Jesus ngan agsumat nga aniya' papa'alayunun-na. ");
INSERT INTO abx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sanglit amatilaw may si Jesus, “Ay i karuyag-mo?” Aminugad may i nana, “Si pagtingkulu'-mo si truno ari si ginhadi'an-mo i saruyagan-ko kunta' nga tugutan-mo pagtingkulo' si kawanan-mo addangan to dadi'-ko ngan addangan to may si kawiri-mo.” ");
INSERT INTO abx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Agpinugad-na dina si Jesus i duwangan, “Ga'i sakatu'anan-bi i nagpalaku-bi.” Mangno amatilaw, “Aka'inom ba' kam siguro tikang si kupa si kasakitan nga kinahanglan irinumun-ko?” “Oho', sahimo kami' nan!” lingun-na may mga iya. ");
INSERT INTO abx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Anaruman may si Jesus, “Hala, sigurado na nga agpaka'inom kam tikang si kupa si kasakitan nga kinahanglan irinumun-ko, pero ma'in tawa'-ko i pagpili' kon say i magpaningkulo' si kawanan-ko pati' si kawiri-ko. Lugod, yaynan mga pwisto tawa'-nay nan si nagrisirbahan-na si Tata'.” ");
INSERT INTO abx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ngan pakapamati'-na may sinan si awatong pa inadalan, agkasirina mga iya si magdingsirarihan. ");
INSERT INTO abx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sanglit agban'u-na mga iya dimu'an si Jesus ngan agpanwaydungan-na, “Akatu'anan kam nga agpanggamit pinirit pagdalom i mga punu'-na si mga nasyon. Agpapalabaw to mga gilalabawi a'a si mga kalugaringun-na. ");
INSERT INTO abx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma'in da'inan sinan i pa'agi-bi pagdalom si kapararihu-bi. Kon addangan si ka'am i maruyag mabantog, kinahanglan iya agsirbi si la'in. ");
INSERT INTO abx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ngan kon addangan si ka'am i maruyag nga naghangad, kinahanglan ag'ako' nga magin rilihugun-bi. ");
INSERT INTO abx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bisan ngani' i Pinili' A'a ga'i pada'ito basi' nagsirbihan pero basi' iya i magsirbi ngan basi' sapumwan-na liwat i kinabuhi'-na paglukat si malabbat a'a.” ");
INSERT INTO abx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Si pataliwan-na kas Jesus si syudad Jerico, malabbat namay i magpamungyod si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari si bihing-na si tinampo, aniya' magparapaningkulo' duwangan buta. Ngan pakabati'-na mga iya nga tilabay kas Jesus, anurakaw mga iya pagban'o, “Paragdalom nga Dadi'-na si David, kalu'uyin kami'!” ");
INSERT INTO abx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nagsimol mga iya si kalabbatan nga ga'i agpararibok. Pero agkukusog dina i mga pagparapaman'u-na, “Paragdalom nga Dadi'-na si David, kalu'uyin kami'!” ");
INSERT INTO abx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pahuway si Jesus, agban'u-na mga iya ngan amatilaw, “Ay i saruyagan-bi nga sahimu-ko si ka'am?” ");
INSERT INTO abx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Anaruman may mga iya, “Paragdalom, i karuyag kami' kunta' nga agpakakulaw kami' gihapon.” ");
INSERT INTO abx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Alu'oy gayod si Jesus sanglit agkapkap-na i mga mata-na mga iya. Akakulaw dayon mga iya ngan agpamaya' si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngan pagdadara'un-na kas Jesus si Jerusalem, akatakka mga iya si baryo Betpahe nga aka'anna' si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. Agpadahulo si Jesus duwangan inadalan ");
INSERT INTO abx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ngan agmandu'an-na mga iya sito, “Pada'iraya kam si dahulu'an-tay ro kam baryo. Si panakka-bi aro, aniya' sa'anda'an-bi nagpa'ingkot mangnganak asno nga aniya' putro nati-na. Pamak'ari-bi ngan guyuru-bi pada'ito. ");
INSERT INTO abx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kon aniya' si ka'am mamatilaw, sumati-bi na hamok nga, ‘Agkinahanglan-nay to si Paragdalom,’ ngan diritsoy nan pabawa-na si ka'am.” ");
INSERT INTO abx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ahinabo' nan pagtuman si mga allingun-na si paragsumat-na si Diyos siray nga agpinugad, ");
INSERT INTO abx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sumati-bi sito i mga taga Sion, ‘Kulawi-bi, awira' na agdadara'on si ka'am i hadi'-bi. Mapa'inubsanon ngan agkabayo si adda asno, si adda putro, nga nati-na dina si asno.’” ");
INSERT INTO abx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sanglit pamalangngan i mga inadalan-na ngan agsunud-na mga iya i tugun-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Agguyud-na mga iya i mangnganak asno huwang hasta i nati-na. Agkamadiruhan-nay to mga iya si mga nagpamakurumbut-na ngan anakrang si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bali labbat i magpanggubok si iya nga agpamuklad si mga nagpamakurumbut-na ari si tinampo, ngan i ditangnga' may agpanabtab mga paklang pangngampin si tinampo. ");
INSERT INTO abx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sigi gagasod i magpantupo' si iya ngan da'inan may i magpamungyod: Hosanna, ka'aw nga Dadi'-na si David! Malipayon gayod i a'a nga pada'ito pina'agi si gahum-na si Paragdalom! Hosanna, hasta liwat ka'aw nga Gilalabawi! ");
INSERT INTO abx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngan pasallud-na na si Jesus si Jerusalem, bali kasibutan i bug'os syudad ngan agsipurupatilaway, “Say ba' nan?” ");
INSERT INTO abx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Anaruman may i magpanggubok, “Iya si Jesus i paragsumat-na si Diyos nga taga Nasaret, Galilea.” ");
INSERT INTO abx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Agdiritso kas Jesus pasallod si hawan-na si templo ngan agtabrug-na i dimu'an magparapamalli pati' i mga magparapamaligya' ari. Agpamabaliskad-na i mga lamisa-na si magparapamabalyo si pala'in-la'in kwarta. Agpamabaliskad-na liwat i mga bangkitu-na si magparapamaligya' panhahalad sarampati. ");
INSERT INTO abx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Amahalling to si mga iya dimu'an, “Aka'anna' si Kasuratan nga agpinugad i Diyos, ‘Pammangadyi'an i ruma'-ko,’ kundi' aghimu-bi to dina ‘pangngingistaran-na si mga tulisan.’” ");
INSERT INTO abx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mangno aniya' pamadugok si Jesus ari si templo mga buta pati' mga kiyod ngan agpamahalap-nay to. ");
INSERT INTO abx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero sigi dina tatamba i mga kasina-na si mga puno' paraghalad pati' si mga paragturo' bala'od tungod si mga urusahon nagbuhat-na pati' si padayon pagparapanurakaw-na si mga kadadi'-dadi'an ari si hawan-na si templo, “Hosanna, ka'aw nga Dadi'-na si David!” ");
INSERT INTO abx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sanglit agsimul-na iya sito mga a'a, “Akapakali ba' kaw si mga nagparapanurakaw-nay nan si mga kadadi'-dadi'an?” Anaruman may si Jesus, “Oho', pero ga'i may ba' liwat sabasa-bi i maka'anna' si Kasuratan? Bisan ngani' si mga pinahallingan-na si mga dadi' hasta pa si mga gana' pa gayod dalum-na, agpakulaw-na mismo si Diyos i maka'angayan pagdayaw si kalugaringun-na.” ");
INSERT INTO abx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Katapos ag'ambanan-nay to mga a'a ngan pagawas gihapon mga iya si syudad. Aglargo mga iya si baryo Betania kay ari agpamaturi. ");
INSERT INTO abx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kanalungan, si pagbwilta-na kas Jesus pan syudad, angabat iya kalingantuhan. ");
INSERT INTO abx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Si pagparabaktas-na, aniya' sakulawan-na kayo igos si bihing-na si lalan. Agduguk-na tungod kay bali rabong pero sadiskubrihan-na nga puro hamok dahon ngan gana' gayod buwa'-na. Sanglit agmaldisyun-nay ray kayo si Jesus, “Hala, tikang ina'anto ga'i na kaw agbuwa' hasta si kahastahan!” Kata'ud-ta'uran alayong i kayo ngan diritso a'uga. ");
INSERT INTO abx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pakakulaw-na sinan si mga inadalan-na, ag'usa gayod mga iya ngan agsipurupatilaway, “Ay kay da'inan kakali' i pag'uga-na sinan kayo?” ");
INSERT INTO abx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Anaruman si Jesus, “Sumatan-ta kam si kamatu'uran, kon aniya' pagtapud-bi ngan ga'i kam agduda, ma'in hamok i mahinabo' sito kayo i sahimu-bi, kundi' pwidi liwat kam akapinugad sito bukid, ‘Tig'alsaha anan ngan tigpa'itsaha pan kalawot,’ ngan atuman to. ");
INSERT INTO abx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kon anutu'o kam, sakarawat-bi i bisan ay nagpalaku-bi pina'agi si pagpangadyi'.” ");
INSERT INTO abx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mangno pasallod si Jesus si hawan-na si templo. Si pagparaturu'-na si mga a'a, pamadugok si iya i mga puno' paraghalad pati' i mga mata'o kamabu'utan si mga Hebro ngan agpamatilaw, “Singnga kaw agsarit si mga nagparabuhat-mo? Say i magtugot si ka'aw sinan?” ");
INSERT INTO abx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Anaruman dina si Jesus, “Patilawan-ta may kam liwat. Kon sasarumanan-bi ako, anumat may liwat ako kon say i magtugot si mga nagbuhat-ko. ");
INSERT INTO abx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mahi'unong si pagbunyag-na si Juan, say magtugot si iya, Diyos o a'a?” Agpandiriskusyon dahulo mga iya, “Tara', ay sito i pinasumat-ta kam? Kon anaruman kita kam, ‘I Diyos,’ sigurado amatilaw nan iya, ‘Kon sugad, kapa'i may kay ga'i kam agtutu'o si mga allingun-na si Juan?’ ");
INSERT INTO abx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero kon anaruman may liwat kita kam, ‘I a'a,’ aniya' kadilikaduhan-ta kam si mga a'a tungod kay ag'alagad gayod i mga a'a nga paragsumat-na si Diyos si Juan.” ");
INSERT INTO abx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sanglit anaruman dina mga iya, “Ga'i kami' akatu'anan.” Anaruman gihapon si Jesus, “Kon sugad, ga'i may liwat ako anumat si ka'am kon say i magtugot si ako nga sabuhat-koy to.” ");
INSERT INTO abx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Agpadayon si Jesus si la'in namay isturya: “Ay si pag'abat-bi sito? Aniya' tatay nga duwangan hamok lalla i dadi'-na. Padugok iya si siyaka ngan agpinugad-na, ‘No', pada'iraya ina'anto si ubasan ngan agtrabahu'a ari.’ ");
INSERT INTO abx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Amaribad to dayon, ‘Ga'-ko!’ pero kata'ud-ta'uran, agsalli' i isip-na ngan pada'iray iya si ubasan. ");
INSERT INTO abx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mangno padugok namay i tatay si addangan pa dadi'-na ngan iya gihapon i panlihugan-na. Anaruman to, ‘Oho', Tay, pada'iray ako,’ pero ga'i iya pada'iray. ");
INSERT INTO abx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Say si duwangan i magtuman si karuyag-na si tatay-na mga iya?” Anaruman may mga iya, “I dahulo naglihog.” Aminugad si Jesus si mga iya, “Sumatan-ta kam si kamatu'uran, akadahulo si ka'am i mga paragsukot buhis pati' i mga magparapamabayad danda pagsakop si mga nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay ngan pada'itu-na si Juan, ga'i kam anutu'o si iya nga i katuyu'an-na pagpasabot si ka'am i pa'agi pagtapit si Diyos nga ag'alagad si katadungan, pero anutu'o lugod si iya i mga paragsukot buhis pati' i mga magparapamabayad danda. Ngan bisan ngani' si pakakulaw-bi na, ga'i pa kam hamok gihapon agpamasol huwang si pagbag'o ngan ga'i kam anutu'o si iya.” ");
INSERT INTO abx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Amati'a kam si adday to pa isturya nga agtukoy si kamatu'uran: Aniya' lalla magtanom ubasan si pitak-na. Agpadir-nay to palibot, aghimo iya pammagga'an, ngan agtindugan-na turri pammamantayan. Katapos agpa'ataman-nay to si mga mangngataman ngan pataliwan iya pan la'in lugar. ");
INSERT INTO abx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ngan ma'in na pira i tigpangku'on si ubas, agpabawa iya mga rilihugun-na pada'iray si mga mangngataman pag'ala' si kapartihan-na. ");
INSERT INTO abx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero agparapamugulan-na dina si mga mangngataman i mga rilihugon. Aniya' si mga iya nga agparapamuniti-na, aniya' nagparapanmatay-na mga iya, ngan aniya' liwat nga agparapanalutugan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mangno, agpabawa gihapon i tagtawa' si ditangnga' pa mga rilihugun-na pada'iray nga angurog pa si primiro nagpabawa-na. Pero iya gihapon i nagbuhat-na si mga mangngataman si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Si katapusan na gayod, mismo i dadi'-na lalla i nagpabawa-na. Akapinugad iya si kalugaringun-na, ‘Tingali rispitaran-na mga iya i dadi'-ko.’ ");
INSERT INTO abx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pero si pakakulaw-na si mga mangngataman si dadi', agsarabut-sabot mga iya, ‘Awira' i iridiro. Tuwa na kam, matay-ta kam iya basi' kita kam i makabawa si kayamanan-na.’ ");
INSERT INTO abx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sanglit agpugulan-nay to mga iya, agdagnas-na pagawas si ubasan ngan agmatay-na.” ");
INSERT INTO abx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amatilaw si Jesus pagpaklaro si isturya-na, “Kon sugad, si pada'iray-na si tagtawa' si ubasan, ay may i binuhat-na kuntra si mga mangngataman?” ");
INSERT INTO abx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Agpanaruman may i mga puno' paraghalad pati' i mga mata'o kamabu'utan, “Sigurado nga panmatay-nay ray mga a'a si makangingirhat pa'agi, ngan pa'intriga-na si la'in mangngataman i ubasan-na, si makabuwan nan si iya si tama' kapartihan si balang tigpangku'on.” ");
INSERT INTO abx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aminugad si Jesus si mga iya, “Ma'in ba' nga sasayuran-bi to anan si Kasuratan? Kon ma'in i nagpabawa-na dadi', say may bali' i nagpinugad bato nga maka'anna' ari? I bato nga nagdiri'-na si mga panday, iya lugod dina i makapasarig si dimu'an. Agbuhat-nay to si Paragdalom, ngan urusahon gayod si pangulawan-ta kam! ");
INSERT INTO abx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Sanglit sumatan-ta kam nga binawi' si ka'am i katungud-bi bilang sakop si mga nagpanhadi'an-na si Diyos ngan pina'intrigay to si mga a'a kon singnga kinakulawan i buwa' sigon si paghadi'-na. ");
INSERT INTO abx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bisan say i mapangkol sinan bato, sigurado nga akadusmog iya ngan gana' na pulus-na si kinabuhi'-na. Pwira sinan, titakka liwat i uras nga alaho' nan bato ngan i maka'untugan, ga'i na gayod aka'arim-ariman.” ");
INSERT INTO abx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pakabati'-na si mga puno' paraghalad pati' si mga Parisiyo si mga isturya-na si Jesus, sakatu'anan-na mga iya nga mga iya i nagpatama'an. ");
INSERT INTO abx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sanglit ag'anda' dayon mga iya pa'agi pagdakop si Jesus, pero atalaw mga iya si kalabbatan magpantarambak kay ag'alagad gayod i mga a'a nga paragsumat-na si Diyos si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Agsumatan-na gihapon mga iya si Jesus adda isturya nga agtukoy si kamatu'uran: ");
INSERT INTO abx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“I paghadi'-na si man langit akapariho si hadi' nga agtima mahaya kumbiti para si kasal-na si dadi'-na lalla. ");
INSERT INTO abx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aglihug-na i mga rilihugun-na pagpakatu'an si mga dati nag'imbitaran-na nga pagpapada'iray na si kumbitihan, pero agpamaribad dina mga iya. ");
INSERT INTO abx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sanglit, aglihug-na gihapon i ditangnga' mga rilihugun-na ngan agtugunan-nay to mga iya, ‘Sumati-bi i mga imbitado nga andam na i kumbiti: Agbunu'-ko na i mga nagpamalammukan-ko baka ngan andam na i dimu'an. Pada'iraya na kam si pagkasalan.’ ");
INSERT INTO abx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pero ga'i to agpanginanu-na si mga imbitado, kundi' agpadayon dina mga iya si mga trabahu-na. Aniya' pamatakod dina ngan aniya' may magparapamanginano si mga nigusyu-na. ");
INSERT INTO abx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kundi' i ditangnga' liwat si mga iya parapamugol dina si mga rilihugon, parapangastigo ngan parapanmatay. ");
INSERT INTO abx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bali i kasina-na si hadi', sanglit aglihug-na i mga sundalu-na pagmatay sito mga kriminal ngan pagsunog si syudad nagpangistaran-na. ");
INSERT INTO abx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Katapos, agpinugad-na i mga rilihugun-na, ‘Priparado na i kumbiti para si kinasal, ngan gana' si mga nagpangimbitaran-ko siray nga magpangangay. ");
INSERT INTO abx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hala, pamada'iraya kam si mga iskina-na si mga kakalsadahan ngan pangimbitari-bi i bisan say sabagatan-bi.’ ");
INSERT INTO abx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sanglit, agpamaduwa'i i mga rilihugon ngan pada'iray si mga kakalsadahan pagtipon si dimu'an mga a'a nga sabagatan-na mga iya, magin mahalap may to o mara'at. Tungod sinan, apanno' i lugar nagkumbitihan si mga sa'imbitaran-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Pero ngan pasallud-na si hadi' pagpanginano si mga bisita, aniya' sakulawan-na ari nga ga'i agsalin si tama' bado' pangngumbiti. ");
INSERT INTO abx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Agtilaw-nay to, ‘Sangkay, pinapa'i kaw akasallod ato nga ga'i agsalin si angay para si kumbiti-na si kinasal?’ Ga'i akasibo' i a'a. ");
INSERT INTO abx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Mangno agpinugad-na si hadi' i mga magpanginano si mga bisita, ‘Gapusu-bi nan ngan patapuku-bi pan gawas, si lugar nga bali lu'om kon singnga agparapangaraba ngan agparapanrigot mga iya.’ ");
INSERT INTO abx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Kay si kamatu'uran, bisan kon malabbat i nag'imbitaran, diki'it i magkapirili'.” ");
INSERT INTO abx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Katapos pamagawas i mga Parisiyo ngan agplanuhan-na mga iya pagbantay si Jesus kon anala' i mga saruman-na si mga patilaw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sanglit agpanlihug-na mga iya i mga kalugaringun-na inadalan paghuwang si mga sakop si partido nga tinindug-na pa si Hadi' Herodes pagdugok si Jesus. Agpaminugad mga iya, “Ma'istro, akatu'anan kami' nga agsumat kaw pirmi si kamatu'uran pati' agturo' kaw liwat si pa'agi pagtapit si Diyos nga ag'alagad si kamatu'uran. Ga'i kaw atalaw kon ay i isip-na si a'a ngan gana' nagkilala-mo bisan say i makatama'an. ");
INSERT INTO abx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sumatin ngani' kami' kon ay si pag'abat-mo? Tama' ba' para si kita kam i pagbayad buhis si Emperador si Roma o ma'in?” ");
INSERT INTO abx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kundi' sa'abat-na si Jesus nga mara'at i mga katuyu'an-na, sanglit agpinugad-na mga iya, “Mga mahalap gayod i mga pamawa'-bi, pero mara'at i mga inisipan-bi. Ay kay agparadadakup-bi gayod i mga allingun-ko? ");
INSERT INTO abx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakulawu-bi daw ako si diplatay nan pammayad si buhis.” Agparu'du'an-nay to mga iya adda dinari diplata. ");
INSERT INTO abx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mangno amatilaw si Jesus, “Say to tawa' bayhon pati' aron maka'anna' to ato?” ");
INSERT INTO abx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Anaruman mga iya, “Tawa'-na si Emperador.” Sanglit amahalling may si Jesus, “Kon sugad, bayari-bi i Emperador si mga hinimo nga irog si iya kay tawa'-nay nan, ngan bayari-bi may i Diyos si mga hinimo nga irog may liwat si iya kay tawa'-nay nan.” ");
INSERT INTO abx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pakabati'-na mga iya sinan, bali i mga pag'usa-na, sanglit ag'ambanan-na na hamok mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Siray mismo allaw, aniya' pamadugok si Jesus mga Sadusiyo basi' agpakapatilaw. I mga Sadusiyo, iya i magparapanumat nga ga'i na abanhaw i mga a'a si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aminugad mga iya, “Ma'istro, agsumat si Moises nga kon aniya' magdangallahan nga gana' pa mga dadi'-na si pakamatay-na si lalla, kinahanglan nga pakasalan-na si sirari i mabalo basi' akadadi' mga iya nga akwinta bilang dadi'-na si siyaka-na. ");
INSERT INTO abx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aniya' si kami' ray pitungan lalla magdiringsirarihan. Inallahan i siyaka, pero amatay. Tungod kay gana' may sito mga dadi'-na, agpakasalan-na si manunod i mabalo. ");
INSERT INTO abx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero iya gihapon i mahinabo' si kaduwangan to, mangno si katallungan liwat hasta nga atibos mga iya pitungan. ");
INSERT INTO abx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Si katapus-tapusan, amatay liwat i danda. ");
INSERT INTO abx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tara', si pagkabanhaw, say may i tag'alla si danda si pitungan ray magdiringsirarihan kay akapakasal may dimu'an si iya?” ");
INSERT INTO abx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Anaruman si Jesus, “Sala' i mga isip-bi kay ga'i kam agpakasabot hi'unong si Kasuratan o si gahum-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Si pagkabanhaw, akapariho na mga iya si mga anghel. Gana' na uru'allahay ari si langit. ");
INSERT INTO abx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero mahi'unong si mga duda-bi kon aniya' ba' mabanhaw, ga'i ba' sabasa-bi i mga allingun-na si Diyos, ");
INSERT INTO abx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ako mismo i Diyos nagtutu'u-na kas Abraham, Isaac, pati' si Jacob hasta pa ina'anto’? Kon sugad, pariho si kamutangan-na mga iya, ma'in minatay i magpadayon pagtutu'o kundi' allom dina.” ");
INSERT INTO abx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pakabati'-na sinan si magpanggubok, ag'usa gayod mga iya si pagturu'-na. ");
INSERT INTO abx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pamadugok dayon i grupu-na si mga Parisiyo si pakakatu'an-na mga iya nga ga'i agpakasibo' i mga Sadusiyo si mga saruman-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aniya' addangan paragturo' bala'od si mga iya nga i tuyu'-na hamok pagpurbar kon anala' si Jesus si mga allingun-na. Sanglit amatilaw iya, ");
INSERT INTO abx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ma'istro, ay kasugu'ana i labaw gayod anan si Bala'ud-na si Moises?” ");
INSERT INTO abx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Anaruman may si Jesus, “Higugma'u-bi i Paragdalom Diyus-bi si bug'os kasing-kasing-bi, si bug'os kina'iya-bi, pati' si bug'os paminsada-bi. ");
INSERT INTO abx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iyay nan i labaw ngan pinaka'impurtanti sugo'. ");
INSERT INTO abx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ngan aniya' pa kaduwa nga pariho hamok i ka'impurtantihan-na: Higugma'u-bi i igkasi a'a-bi pariho si paghigugma'-bi si kalugaringun-bi. ");
INSERT INTO abx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I kabug'usan-na si Bala'ud-na si Moises pati' si Nagpanurat-na si mga Paragsumat, ato nag'inala' si duway to kasugu'an.” ");
INSERT INTO abx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngan pagtiriripun-na pa si mga Parisiyo, amatilaw si Jesus si mga iya, ");
INSERT INTO abx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngan ay may liwat i isip-bi parti si Tinu'inan Mannanalwas? Say i tagdadi' si iya?” Anaruman may mga iya, “Dadi'-na iya si David.” ");
INSERT INTO abx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aminugad may si Jesus, “Kon da'inan sinan, kapa'i may kay sigon si pagdalum-na si Espirito, akaban'o si David si iya ‘Paragdalom’? Yayto i allingun-na ari si Kasuratan: ");
INSERT INTO abx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Agpinugad i Paragdalom Diyos pada'iray si Paragdalum-ko, ‘Aningkulu'a ato si kawanan-ko, tubtob nga sapama'ubus-ko i mga kuntra-mo pa nga day pannungtungan-mo.’ ");
INSERT INTO abx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kon ‘Paragdalom’ i pagban'u-na si David si gi'uru'ampuhi-na, pinapa'i kam akapinugad nga gi'uru'ampuhi-na hamok si David i Tinu'inan Mannanalwas?” ");
INSERT INTO abx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gana' makapahalling bisan adda hamok allingon pagsaruman si iya. Sanglit tikang siray allaw, gana' na gayod mamintas mamatilaw pa si iya. ");
INSERT INTO abx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Katapos agturu'an-na si Jesus i magpantarambak ari hasta i mga inadalan-na, ");
INSERT INTO abx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I mga paragturo' bala'od pati' i mga Parisiyo, iya i mga tinu'inan pagpadayon si katungdanan-na si Moises. ");
INSERT INTO abx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sanglit kinahanglan sunud-bi mga iya ngan buhat-bi i dimu'an mga nagsumat-na. Pero dakam agsunuru-bi i mga nagparapanbuhat-na kay ga'i kinakulawan si mga pangiwa-kiwa-na i mga nagparapanwali-na. ");
INSERT INTO abx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sigi mga iya panhimo si mga rilihuso kabatasanan ngan agparapapalangkit-nay to nga mga mabuwat gayod nagda'og si mga a'a. Agbiriyu'-nay to mga iya agpakkos nga gana' makalikay, pero mismo mga iya ga'i ngani' amikyaw pagbulig bisan diki'it. ");
INSERT INTO abx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“I dimu'an buhat-na mga iya puro pagpadadayaw si a'a. Sakulawan-bi may kon ay i mga kahaya-na si mga nagpapakkos kahun-kahon si mga ruwa-na pati' si mga langngun-na nga mga nag'anna'an si mga birsikulo si Kasuratan. Ga'i ba' liwat sapaniparuhan-bi nga bali lambo i mga lis-na si mga pammakurumbut-na mga iya pagpadadayaw? ");
INSERT INTO abx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mga iya i mga magparapamili' si pwistoy nan nga akabuwan unra si mga kumbitihan pati' si mga printi panningkulu'an si mga sinaguga. ");
INSERT INTO abx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Agkararuyag liwat mga iya si mga talahuron pangumusta-na si mga a'a ari si mirkado pati' kon nagban'o mga iya si mga a'a, ‘Rabbi’. ");
INSERT INTO abx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Para si ka'am, dakam tigban'o, ‘Rabbi’, kay addangan hamok i Amu-bi ngan ka'am dimu'an agbururugto' si pagtu'o. ");
INSERT INTO abx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dakam liwat agban'o, ‘Tay’, si bisan say ato si kalibutan, kay addangan hamok i Tatay-bi, i sari'i si langit. ");
INSERT INTO abx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dakam liwat tigban'o, ‘Ma'istro’, kay addangan hamok i Ma'istru-bi, nga iya i Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kon say si ka'am i mag'ako' nga magin rilihugun-bi, iya dina i pinakabantugan, ");
INSERT INTO abx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","kay bisan say i magpalabaw si kalugaringun-na, iya dina i pina'ubus-na si Diyos, pero i magpa'ubos si kalugaringun-na, iya lugod i pinalabaw. ");
INSERT INTO abx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno nga mga rilihuso kam! Aglangkasan-bi i mga mag'isasakop si mga nagpanhadi'an-na si man langit ngan mismo ka'am ga'i agpakaprubitso sinan. Ma'in nan hamok iya, kundi' ka'am pa liwat dina i mag'ulang si mga papasakupon to. ");
INSERT INTO abx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno! Parapamiyahi kam si hubas hasta si kalawot para hamok agpaka'anda' kam bisan addangan mabawa si mga tuluhu'an-bi. Ngan kon agpaka'anda' na kam sito, adubli dina i mga sapa'ambit-bi karat'an si mga sa'anda'an-bi nga agpangangay nagtabrog pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mga papabidu'on kam mga butay nan paraggiya, kay agparapaminugad kam nga bisan say i magsumpa' nga agsabi si templo pagpamatu'od si kasarig-na si allingun-na, gana' sinan sapayan-na, pero kon i bulawan mga garamiton ari si templo i nagsabi-na si pagsumpa'-na, kinahanglan nga tuman-nay nan sa'ad. ");
INSERT INTO abx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga buta kam gayod nga gana' pamurubu'ut-na! Singnga si duway nan i mas impurtanti: I garamiton o i templo nga nagtagama para si pag'ampo'? ");
INSERT INTO abx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Agparapaminugad liwat kam nga bisan say i magsumpa' nga agsabi si altar, gana' sinan sapayan-na, pero kon i nagpahalad-na ari si altar i nagsabi-na si pagsumpa'-na, kinahanglan nga tuman-nay nan sa'ad. ");
INSERT INTO abx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga buta kam gayod! Singnga si duway nan i mas impurtanti: I halad o i altar nga nagtagama para si Diyos? ");
INSERT INTO abx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sanglit bisan say i magsumpa' nga agsabi si altar, ma'in nga yaynan hamok i nagsabi-na kundi' bawa na i nagpahalad anan. ");
INSERT INTO abx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ngan bisan say i magsumpa' nga agsabi si templo, ma'in nga yaynan hamok i nagsabi-na kundi' bawa na i mag'istar anan. ");
INSERT INTO abx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ngan bisan say i magsumpa' nga agsabi si langit, ma'in nga yaynan hamok i nagsabi-na kundi' bawa na i trunu-na si Diyos hasta pa i magtingkulo' sito. ");
INSERT INTO abx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno nga mga rilihuso kam! Bisan kon agsunud-bi i bala'ud-na si Diyos pagbuwan dyis pursyinto si iya si dimu'an inanda'an-bi hasta nga agtukib-bi pa liwat i dyis pursyintu-na si mga tinanum-bi panakot, bisan i mga mamamis, i mga malassom hasta pa i mga maharang, pero ga'i may lugod dina agpanginanu-bi i mas impurtanti si bala'od, nga iya i tama' pagtratar si a'a, i pagkalu'oy pati' i pagtu'o. Yayto kunta' dina damurihan to i kinahanglan nagbuhat-bi si pagparapanginanu-bi si dahulo. ");
INSERT INTO abx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mga buta kam gayod paraggiya! Agparasara'-bi i tagnok kon aka'anna' to si irimnun-bi, pero awili kam lugod pagtallon si kamel. ");
INSERT INTO abx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno! Sigi-bi panhugas i mga gawas-na si mga tasa-bi pati' mga mangku'-bi, pero i mga huna'-huna'-bi panno' si kabintahuso pati' si pagpagusto si bisan ay sasindakan-bi. ");
INSERT INTO abx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mga buta kam gayod Parisiyo! Kunta' i primiro nagpanginanu-bi i paglimpya si sallud-na si mga tasa-bi pati' mga mangku'-bi kay kon da'inan sinan, sigurado nga akalimpyahan liwat i gawas. ");
INSERT INTO abx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno nga mga rilihuso kam! Ka'am i makapariho si mga pantyon nga nagpamintaran puti' nga bali halap nagkulawan si gawas, pero i isi-na puro hamok ta'ulang pati' mga pala'in-la'in pa nga mga marigsok. ");
INSERT INTO abx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Si pariho kamutangan, i mga pamustura-bi matadong si pangulawan-na si a'a, pero panno' i inisipan-bi si mga pagpamakunu-kuno pati' mga kasal'anan. ");
INSERT INTO abx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mga papabidu'on kam mga paragturo' nan bala'od hasta ka'am mga Parisiyoy nan, kay mga mahalap kam hamok agparapamakunu-kuno! Agparapanindugan-bi mga mahalap pantyon i mga paragsumat-na si Diyos ngan agparapanhabungan-bi i mga labbung-na si mga matadong a'a. ");
INSERT INTO abx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Katapos agpinugad kam nga, ‘Kon allom na kami' siray ngan kapanahunan-na si mga kapapu'an kami', ga'i kunta' kami' a'among si mga sala'-na pagpanmatay si mga paragsumat-na si Diyos.’ ");
INSERT INTO abx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kon sugad angumpurmi kam nga mga ka'uru'ampuhan-na kam si mga magpanmatay si mga paragsumat-na si Diyos siray. ");
INSERT INTO abx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hala, sunuru-bi i mga binuhatan-na siray si mga kapapu'an-bi tubtob nga sakumplihan-bi i mga pangulangan-na mga iya sala'. ");
INSERT INTO abx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Day mga sawa kam! Pariho kam si mga malaray nan mananap! Pinapa'i-bi may nga agpakalikay kam si patok nga akapan'impyirno? ");
INSERT INTO abx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tungod sinan, tipabawa ako mga paragsumat pati' mga mata'o a'a hasta pa mga paragturo'. Aniya' si mga iya nga maratayun-bi pati' aniya' liwat papapaku'un-bi si kudos. Ngan aniya' liwat si mga iya nga darabalun-bi si mga sinaguga ngan paralanatun-bi mga iya bisan singnga mga iya pa'arop. ");
INSERT INTO abx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sanglit ka'am i makatuhunan si dimu'an kastigo nagpapatok para si kamatayun-na si mga matadong a'a, tikang si primiro, nga iya i pagmatay si Abel nga adda inusinti, ngan si Sacarias i pangultimo nga dadi'-na si Baraquias. Iya i nagmatay si pagkagul'atan-na si altar pati' si templo. ");
INSERT INTO abx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sumatan-ta kam si kamatu'uran, ungod to nga i mga a'a sito panahon i makatuhunan si kastigo para sito mga sala' dimu'an. ");
INSERT INTO abx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mga taga Jerusalem, ka'am gayod i mga hinigugma'-ko. Kunta' ga'i agpanmatay-bi i mga paragsumat-na si Diyos. Kunta' ga'i agpanalutugan-bi i mga a'a nagpamabawa-na si ka'am. Simpira na ako ag'andoy nga pamadugok kam si ako basi' ag'aradda kita kam pariho si umagak kon aglu'uban-na i mga siyu'-siyu'-na. Pero ga'i kam gayod agkararuyag. ");
INSERT INTO abx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tigamani-bi, burungkagon gayod ngan arambanan i syudad-bi huwang i mga kaparyintihan-bi. ");
INSERT INTO abx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sumatan-ta kam, ga'i na ako sakulawan-bi gihapon hasta nga ga'i kam agpakapinugad, ‘Malipayon i a'a nga akapada'ito pina'agi si gahum-na si Paragdalom.’” ");
INSERT INTO abx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Si paggagawas-na na si Jesus si hawan-na si templo, pamatapit si iya i mga inadalan-na ngan tigkulawan-na mga iya si Jesus i ka'angayan-na si mga mahaya bilding ari. ");
INSERT INTO abx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amatilaw to si mga iya, “Sakulawan-bi ba' nan dimu'an? Sumatan-ta kam si kamatu'uran, gana' sinan mabilin si mga sakulawan-bi nan bato si nagpanungtungan-na. Tirimpagon nan dimu'an.” ");
INSERT INTO abx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Si pagparalumpagi'-na si Jesus ari si tagudtod nag'arunan Bukid-na si Ka'ulibuhan, pamadugok si iya i mga inadalan-na hamok ngan agpaminugad, “Sumatin daw kami' kon sumiran nan ahinabo' ngan kon ay i pangngilalahan si pagpada'itu-mo gihapon pati' si katapusan-na si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Anaruman si Jesus, “Agbantaya kam ngan dakam agpatugot nga akadaya'an kam si bisan say, ");
INSERT INTO abx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","kay malabbat i tipada'ito nga aggamit si arun-ko si pagpinugad, ‘Ako i Tinu'inan Mannanalwas,’ ngan malabbat i mga sadaya'an-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dakam abaraka si mga sapamati'an-bi nga aniya' mga girra matapit si ka'am ngan aniya' liwat si mga matala lugar. Kinahanglan ahinabo' i mga da'ito sito pero ma'in payto i pagtapos si panahon. ");
INSERT INTO abx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Agparapanggirirra i mga nasyon ngan sigi panhiriran i mga ginhadi'an. Aniya' mga gutom pati' mga linog si pala'in-la'in lugar. ");
INSERT INTO abx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yayto dimu'an i mga panikangan-na pa hamok si mga pagkuri-bi. ");
INSERT INTO abx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Katapos darakupon kam ngan papa'intrigahon basi' akastigo ngan maratayon. Naghumutan kam si mga a'a-na si dimu'an nasyon tungod si ako. ");
INSERT INTO abx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sinan mga uras, malabbat i mangamban si mga pagtu'u-na. Agsiturutrayduray i mga a'a ngan agsihurumut-humutay. ");
INSERT INTO abx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ngan malabbat mga burubullo' paragsumat-na si Diyos i pamaluwa' ngan malabbat mga a'a i magpakadaya'an. ");
INSERT INTO abx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tungod si pagtatamba-na si mga mara'at binuhatan, urog i mga a'a nga agtikapara' i paghigugma'-na para si igkasi-na. ");
INSERT INTO abx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero bisan say i mangilob tubtob si katapusan, iya i masalbar si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ngan i mahalap sumat kon pinapa'i i a'a akasakop si nagpanhadi'an-na apasamwak si bug'os kalibutan pagpamatu'od si dimu'an nasyon. Katapos iya na dayon i katapusan-na si panahon. ");
INSERT INTO abx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Aniya' nag'ibitaran gayod a'a nga akapara'at si dimu'an, nga nagpinugad-na si paragsumat Daniel, ngan kinahanglan sasabutan-nay to si magbasa. Sanglit si pakakulaw-bi sinan nga anunggo ari si sagrado lugar, ");
INSERT INTO abx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kinahanglan agrarabunos pan tagudtod i mga magpangistar ari si Judea. ");
INSERT INTO abx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kon awiray i addangan si pammalayahayan ari si binubungan, paduwa'i iya pero ga'i na kunta' pasallod si ruma' pag'addo' si mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngan kon ari iya si uma-na, ga'i na kunta' padulhog pag'ala' si pammakurumbut-na. ");
INSERT INTO abx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ka'asi' gayod sinan mga allaw i mga burod pati' i mga nana nga aniya' nagpasusu-na! ");
INSERT INTO abx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ampu'i-bi si Diyos nga si pagparalitira-bi ga'i akatuman si tigtugnawon o si Allaw Pandidiskanso, ");
INSERT INTO abx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kay i mga kakurihan-na sinan mga allaw anubra pa si bisan ay kakurihana nga sa'abat-na si kalibutan tikang pa si panikangan tubtob ina'anto, ngan gana' na liwat gayod sinan makapariho pa hasta si kahastahan. ");
INSERT INTO abx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kon yaynan mga kakurihan ga'i nag'ibanan i kalabbat-na si allaw, sigurado nga gana' gayod mabilin allom. Pero tungod si mga pinili'-na a'a si Diyos, iribanan i allaw-na sinan. ");
INSERT INTO abx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sinan uras, kon aniya' magpaminugad si ka'am, ‘Kulawi-bi, atiya' na i Tinu'inan Mannanalwas!’ o ma'in ngani', ‘Kulawi-bi ro, awira' na iya!’ dakam iya agtutu'uhu-bi, ");
INSERT INTO abx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","kay sigurado nga aniya' pamaluwa' mga burubullo' tinu'inan mannanalwas. Pamaluwa' liwat i mga burubullo' paragsumat-na si Diyos. Agpanhimoy to mga a'a pala'in-la'in bantugan pangngilalahan si langitnon kuno' kasiguruhan pati' mga makagagahom binuhatan basi' sadaya'an-na mga iya, nga kon ahimo, hasta pa i mga a'a nagpamili'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tigamani-bi, agsumatan-ta na kam andang myintras ahinabo'. ");
INSERT INTO abx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Sanglit, kon aniya' si ka'am magsumat, ‘Kulawi-bi ari, awiray iya si disyirto,’ dakam pada'iray; o ma'in ngani', ‘Kulawi-bi, awinan iya si kwarto agtago',’ dakam agtutu'o sinan ");
INSERT INTO abx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","kay i pagpada'itu-na si Pinili' A'a akapariho si kil'at nga hintak agtikang si sirangan diritso pan katundan. ");
INSERT INTO abx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Agpakatu'anan gad kam sinan gihapon pariho kon aniya' magtiriripon mga wakwak si adda lugar, akatu'anan kam nga aniya' minatay anan. ");
INSERT INTO abx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Si katapus-na dayon si mga kakurihan-na sinan mga allaw, anlu'om i allaw ngan ga'i amuwan i bulan si danta'-na. Agkataraktak i mga bitu'on tikang si langit ngan agpamalisa i dimu'an gamhanan ari si mga ararupan-na. ");
INSERT INTO abx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Sinan uras, kinakulawan ari si langit i pangngilalahan nga titakka na i Pinili' A'a, ngan i dimu'an nasyon si kalibutan agpangabat kabido'. Mangno sakulawan-na mga iya i Pinili' A'a ari si panganod. Agdadara'on iya panno' si gahom ngan nagpalibutan si maka'angayan gayod danta'. ");
INSERT INTO abx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Papabawahun-na liwat i mga anghel-na dungan si makusog tandu-na si trumpita ngan mga iya i manipon si mga nagpamili'-na a'a tikang si ampat kantu-na si kalibutan, tikang gayod ato pan dambila'. ");
INSERT INTO abx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kon sugad, adali-bi i liksyon tikang si kayo igos: Kon agbirdi na i mga saringsing-na ngan aniya' na sito buraksa'-na, akatu'anan kam nga ma'in na pira i tigpangku'on bisan kon ga'i kam nagsumatan. ");
INSERT INTO abx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pariho sinan, si pakakulaw-bi nga ahinabo' nan dimu'an, akatu'anan kam nga matapit na gayod iya, day awira' na gayod iya si pwirtahan. ");
INSERT INTO abx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sumatan-ta kam si kamatu'uran, ahinabo' nan dimu'an antis ahuman i kapanahunan-na si mga a'ay to ina'anto. ");
INSERT INTO abx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aniya' titakka katapusan-na si kalangitan pati' si kalibutan, pero gana' gayod katapusan-na si mga allingun-ko hasta si kahastahan. ");
INSERT INTO abx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Gana' gayod makatu'anan kon sumiran nan allawa anakka, o kon ay urasa. Ga'i akatu'anan i mga anghel si langit, o bisan i Dadi'. I makatu'anan hamok sito, iya i Tata'. ");
INSERT INTO abx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kon ay i nagparabuhat-na si mga a'a siray ngan panahun-na kas Noe, iya may liwat gihapon si pagpada'itu-na si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Agparapamangan mga iya, agparapangirinom ngan agparakasalay tubtob si allaw si pasallud-na si Noe si arka. ");
INSERT INTO abx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tungod sinan, ga'i gayod mga iya agpakamangno si panakka-na si unop ngan agkagarawad na hamok mga iya dimu'an. Da'inan gihapon sinan i mga mahinabo' si pada'itu-na si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sinan uras, aniya' duwangan lalla maghuwang ag'uma pero addangan hamok i inala' paghuwang si Diyos ngan bilin i addangan. ");
INSERT INTO abx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aniya' liwat duwangan danda maghuwang aggiling pero addangan hamok i inala' ngan bilin i addangan. ");
INSERT INTO abx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sanglit, agbantaya kam kay ga'i sakatu'anan-bi kon ay allawa pada'ito i Paragdalum-bi. ");
INSERT INTO abx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero intumu-bi to: Pariho kon akatu'anan hamok i tagruma' kon ay urasa si sangom anakka i mannanangkaw, sigurado nga agbantay iya ngan ga'i iya agpata'an nga pwinirsa pagsallod i ruma'-na. ");
INSERT INTO abx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sanglit si pariho kamutangan, kinahanglan may kam liwat ag'ikmat, kay titakka i Pinili' A'a si uras nga ga'i kam anggasi. ");
INSERT INTO abx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“I tangkod pati' madunong tinapuran, iya i nagtu'inan-na si amo pagpamuno' si mga rilihugun-na basi' agpakabuwanan mga iya si mga kunsumu-na si tama' uras. ");
INSERT INTO abx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mangno si pagbalik-na si amo kon satakkahan-na i tinapuran nga agparabuhat pa si katungdanan-na, sigurado aka'angkon iya kahalapan. ");
INSERT INTO abx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sumatan-ta kam si kamatu'uran, tungod sinan, iya i nagtu'inan-na si amo pag'inantan si dimu'an mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero pananglit agpinsar dina i mara'at tinapuran, ‘Maliyat pa may agbalik i amu-ko.’ ");
INSERT INTO abx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mangno agtikang iya pagpandabal si nagpamunu'an-na mga rilihugon. Pagusto iya si pagkakan ngan sigi inom huwang i mga paralango. ");
INSERT INTO abx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sigurado nga anakka i amu-na sinan tinapuran si allaw nga ga'i iya anggasi, ngan ga'i iya akatu'anan si uras. ");
INSERT INTO abx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Agtagutad-na iya si amu-na basi' sapatig'ub-nay to si mga magparapamakunu-kuno nga ga'i agliwat i kahul'us-na si pagsirbi-na mga iya, nga awiray si lugar kon singnga agparapangaraba ngan agparapanrigot mga iya.” ");
INSERT INTO abx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Agpadayon si Jesus sito isturya, “Si pagdadara'un-na sinan panahon, i pagsakup-na si a'a si nagpanhadi'an-na si man langit, akapariho si awatong abay-na si karaslon danda nga agpamawa-bawa si mga kalugaringun-na lampara nga pamagawas pagtupo' si karaslon lalla. ");
INSERT INTO abx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Limangan si mga iya i ga'i mag'isip si titakka ngan i limangan may i aniya' mga dunung-na pag'andam kon ay i kinahanglanon. ");
INSERT INTO abx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Agpamawa si mga lampara-na i mga gana' isip-na, pero ga'i agpamalon si mga risirba-na lana. ");
INSERT INTO abx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero i mga aniya' dunung-na, aniya' gayod mga pangngisihan-na lana huwang si mga lampara-na. ");
INSERT INTO abx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tungod kay atrasado anakka i kinasal lalla, angabat mga iya piraw sanglit agpamanahik gihapon ngan agpakapaturi. ");
INSERT INTO abx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kamagkatutnga'an, bali kariribukan si mga a'a magpakakulaw nga titakka na iya: ‘Awira' na i karaslon! Pagawasa na kam anan ngan tupu'u-bi iya!’ ");
INSERT INTO abx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Mangno pamabangon i awatong abay ngan agpangandam si mga lampara-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aminugad i mga gana' isip-na ari si mga aniya' dunung-na, ‘Pa'ambiton daw kami' si mga lana-bi nan bisan diki'it. Agtikaparong namay mga lampara kami' to.’ ");
INSERT INTO abx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lingun-na may mga iya, ‘Sigurado nga ga'i to gayod akahusto kon agturunga'an-tay to kam. Lugod mas mahalap kon amalli na kam hamok ari si tindahan para si mga kalugaringun-bi.’ ");
INSERT INTO abx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Pero si pagparalalangngan-na mga iya pagballi lana, iya may i panakka-na si karaslon. I mga abay nga dati andam agpamungyod dayon si iya pasallod si nagkumbitihan. Mangno nagsirrahan dayon i pwirtahan-na. ");
INSERT INTO abx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ga'i agliyat, anakka i ditangnga'. ‘Sinyor! Sinyor! Pasalluron may kami'!’ i pakimalu'uy-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pero anaruman dina iya, ‘Sumatan-ta kam si kamatu'uran, ga'i ako angilala si ka'am.’” ");
INSERT INTO abx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Agtapusan-na si Jesus i isturya-na si pagpinugad, “Sanglit agbantaya kam, kay ga'i sakatu'anan-bi kon ay allawa o ay urasa anakka i Paragdalum-bi.” ");
INSERT INTO abx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Angisturya gihapon si Jesus: “I pagsakup-na si a'a si nagpanhadi'an-na si man langit akapariho liwat si a'a nga tibiyahi pan la'in lugar. Sanglit agban'u-na i mga tinapuran-na ngan agpa'intriga-na ato i mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Agpamuwanan-nay to sigon si abilidad-na si kada addangan si mga iya. I addangan agbuwanan-na si bulawan kwarta nga akapariho si kantidad-na si tallo ta'on swildo, i addangan may akapariho si duwa ta'on swildo ngan i addangan pa akapariho may si adda ta'on swildo. Katapos palangngan iya ngan agbiyahi pan la'in lugar. ");
INSERT INTO abx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pa'amban dayon i a'a makakarawat si mahaya kantidad ngan agpanigusyu-na i kwarta, sanglit anubo' payto dubli si sakarawat-na. ");
INSERT INTO abx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pariho liwat i nagbuhat-na si kaduwangan. Anubo' pa liwat dina dubli si sakarawat-na. ");
INSERT INTO abx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ag'ukad dina i a'a nga minos sakarawat-na ngan aglubluban-na i bulawan-na si amu-na. ");
INSERT INTO abx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pa'agi i maliyat panahon, agbalik i amu-na siray mga tinapuran ngan ag'aratubang mga iya pagbalansi. ");
INSERT INTO abx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Agpa'intriga i tinapuran makakarawat si mahaya kantidad huwang pa i tinubu'-na. Aminugad to, ‘Sinyor, agtapuran-mo ako pag'antan si bulawan kwarta nga kantidad tallo ta'on si swildu-ko. Kulawin to, adubli pa liwat dina tinubu'-nay to.’ ");
INSERT INTO abx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Anaruman i amu-na, ‘Mahalap i nagbuhat-mo. Ka'aw i tinapuran nga tangkod ngan aniya' kapulsanan-na! Akatapuran kaw gayod pagpanginano si nagpa'intriga si ka'aw, sanglit himu-ta kaw tinapuran si mas mahaya pa kantidad. Dayuna ngan pahuwanga agkalipay si amu-mo!’ ");
INSERT INTO abx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ama'intriga liwat i kaduwangan tinapuran ngan aminugad, ‘Sinyor, agtapuran-mo ako pag'antan si bulawan kwarta nga kantidad duwa ta'on si swildu-ko. Kulawin to, adubli pa liwat dina tinubu'-nay to.’ ");
INSERT INTO abx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Anaruman i amu-na, ‘Mahalap i nagbuhat-mo. Ka'aw i tinapuran nga tangkod ngan aniya' kapulsanan-na! Akatapuran kaw gayod pagpanginano si nagpa'intriga si ka'aw, sanglit himu-ta kaw tinapuran si mas mahaya pa kantidad. Dayuna ngan pahuwanga agkalipay si amu-mo!’ ");
INSERT INTO abx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Si katapusan, amahalling i katallungan tinapuran, ‘Sinyor, akatu'anan ako nga bali kaw ka'istrikto. Agparapa'ani kaw si bisan ma'in pinatanuman-mo ngan tigparatipun-mo bisan i ma'in pinahimaliran-mo. ");
INSERT INTO abx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tungod sinan atalaw ako ngan aglubluban-ko na hamok i bulawan-mo. Kulawin to, atiya' gihapon i dati tawa'-mo.’ ");
INSERT INTO abx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Anaruman may i amu-na, ‘Mara'at kaw gayod ngan hubya' tinapuran! Kon da'inan sinan i pagkakilala-mo nga agparapa'ani ako si bisan ma'in pinatanuman-ko ngan tigparatipun-ko bisan i ma'in pinahimaliran-ko, ");
INSERT INTO abx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kon sugad, kapa'i may kay ga'i agpadipusitu-mo si bangko i kwarta-ko basi' kunta' si pagbalik-ko, sakubra-koy nan nga aniya' na dina tubu'-na.’ ");
INSERT INTO abx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sanglit agmando' i amo, ‘Bawi'u-bi kwartay nan si iya ngan pumwanu-bi si addangan to nga urog nag'inantanan-na, ");
INSERT INTO abx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","kay bisan say i aniya', iya i binuwanan pa basi' anlabbat gayod i tawa'-na; pero bisan say i gana', hasta pa i diki'it tawa'-na, inala' pa tikang si iya. ");
INSERT INTO abx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ngan kon parti namay si gana' nan kapulsanan-na tinapuran, patapuku-bi nan pagawas, si lugar nga bali lu'om, kon singnga agparapangaraba ngan agparapanrigot mga iya.’ ");
INSERT INTO abx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Si pada'itu-na si Pinili' A'a nga nagsigahan palibot si maka'angayan danta'-na pati' nagbungyuranan si dimu'an mga anghel-na, aningkulo' to si trunu-na paghusgar. ");
INSERT INTO abx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I mga a'a-na si dimu'an nasyon papatiripunon atubang si iya ngan burulagun-nay to si duwa parti nga day adda mangngataman nga agparabulag-na i kakarniruhan tikang si mga kakandingan. ");
INSERT INTO abx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tigpabiriyu'-na i mga kakarniruhan banda si kawanan-na ngan i kakandingan may si kawiri-na. ");
INSERT INTO abx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Katapos amahalling i Hadi' si mga a'a si kawanan-na, ‘Paduguka kam si ako, ka'am nagpamuwanan-nay nan na si Tatay-ko si mga kabubuwasun-na. Karawatu-bi i mga sa'iridar-bi bilang mga sakop si ginhadi'an-ko nga nagtagama-na para si ka'am tikang pa siray ngan paghimo si kalibutan ");
INSERT INTO abx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kay agpakakan-bi ako ngan pakalingantu-ko. Agpa'inum-bi ako ngan pag'uhaw si ako. Agpadayun-bi ako si mga ruma'-bi bisan kon istranghiro ako si mga lugar-bi. ");
INSERT INTO abx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Agbuwanan-bi ako pagsalinan ngan pagkinahanglan-ko sito. Ag'ataman-bi ako ngan pamurong si ako. Ngan agbisita-bi ako ngan pakaprisu-ko.’ ");
INSERT INTO abx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Pero tipatilaw dina i mga matadong nagbagawan-na, ‘Paragdalom, ngan sumiran ba' pakabagat kami' si ka'aw nga linganto katapos agpakakan kami' kaw, pati' paka'uhaw-mo nga agpa'inom kami' kaw? ");
INSERT INTO abx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ngan sumiran ka'istranghiru-mo nga agpadayon kami' kaw, pati' pagkinahanglan-mo pagsalinan nga agbuwanan kami' kaw? ");
INSERT INTO abx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ngan sumiran liwat pamurong si ka'aw nga ag'ataman kami' kaw, pati' kaprisu-mo nga agbisita kami' kaw?’ ");
INSERT INTO abx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Anaruman may i Hadi', ‘Sumatan-ta kam si kamatu'uran, bisan say aha'a, igkasi-koy nan, ngan bisan ay i nagbuhat-bi si addangan si mga iya nga ga'i akabulos si ka'am, kwintadoy nan nga agbuhat-bi si ako.’ ");
INSERT INTO abx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kahuman sinan, tipahalling namay iya si mga a'a si kawiri-na, ‘Patalaha kam si ako mga magpakagaba'an nan na ngan pada'iraya kam si gana' ray kapaparungun-na api nga nagtagama para si Satanas pati' si mga igkasi-na ka'anghelan ");
INSERT INTO abx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kay ngan pakalingantu-ko, gana' si ka'am magpakakan si ako. Gana' si ka'am magpa'inom ngan nag'uhaw ako. ");
INSERT INTO abx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gana' si ka'am mag'imbitar ngan ka'istranghiru-ko siray si mga lugar-bi. Gana' si ka'am mamuwan pagsalinan ngan pagkinahanglan-ko, ngan gana' gayod manginano si ka'am ngan pamurong si ako pati' si pakaprisu-ko.’ ");
INSERT INTO abx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tisaruman to liwat mga iya, ‘Paragdalom, ngan sumiran pakakulaw kami' si ka'aw nga linganto kaw, nga bali kaw ka'uhawan, nga istranghiro kaw, nga agkinahanglan kaw pagsalinan? Ngan sumiran pamurong si ka'aw pati' apriso nga gana' si kami' manginano?’ ");
INSERT INTO abx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aminugad may to si mga iya, ‘Sumatan-ta kam si kamatu'uran, bisan say aha'a, igkasi-koy nan, ngan bisan ay i ga'i nagbuhat-bi si addangan si mga iya nga ga'i akabulos si ka'am, kwintadoy nan nga ga'i may liwat agbuhat-bi si ako.’ ");
INSERT INTO abx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mangno papalitirahon to mga iya pada'iray si gana' katapusan-na kastigo, pero i mga matadong pada'iray si ungod kinabuhi'.” ");
INSERT INTO abx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pakahuman-na si Jesus pagpahalling sinan dimu'an, aminugad iya si mga inadalan-na, ");
INSERT INTO abx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Akatu'anan kam nga duwa na hamok allaw i Pyista si Paglabay ngan papa'intrigahon i Pinili' A'a ngan papapaku'on.” ");
INSERT INTO abx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mismo siray uras, agtiripon i mga puno' paraghalad pati' i mga mata'o kamabu'utan-na si mga Hebro, ari si palasyu-na si Caifas, i gilalabawi paraghalad. ");
INSERT INTO abx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Agparapanganda' mga iya pa'agi nga sapadakup-na mga iya si Jesus nga gana' makatu'anan basi' sapamatay-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero agsarabut-sabot mga iya, “Kinahanglan ga'i kita kam agbuhat sito si kapyistahan-na kay tingali mangisog ngan agsararamok i mga a'a.” ");
INSERT INTO abx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngan ari kas Jesus si baryo Betania, si ruma'-na kas Simon nga akanaynayan na hamok Gu'uron, ");
INSERT INTO abx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","aniya' danda padugok si nagtarangka'an-na mga iya pagkakan nga magbawa-bawa pasangngit. Bali to kamahalan nga i pangngisihan-na hinimo tikang si bato alabastro. Agpabu'bu'-nay to si takuluk-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pakakulaw-na sinan si mga inadalan-na, andiri' gayod mga iya ngan agsipurupatilaway, “Ay kay agkaragan-nay nan hamok? ");
INSERT INTO abx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pwidi nan kunta' sabaligya'an-ta si mahaya kantidad ngan i bayad-na apumwan si mga anggana'.” ");
INSERT INTO abx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sakatu'anan-na si Jesus i maka'anna' si mga inisipan-na sanglit agtilaw-na mga iya, “Ay kay agpakamalu'an-bi dina iya? Ka'angayan gayod i nagbuhat-na si ako. ");
INSERT INTO abx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pirmi aniya' mga anggana' nga sabagatan-bi, pero ma'in na pira, ga'i na ako sabagatan-bi. ");
INSERT INTO abx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Si pamu'bu'-na sito pasangngit ato si puhu'-ko, ag'andam-nay to hamok para si uras si paglabbong. ");
INSERT INTO abx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sumatan-ta kam si kamatu'uran, bisan singnga nagpasamwak i mahalap sumat si bug'os kalibutan, parasumaton liwat i nagbuhat-na pagpa'intom ngan pagdayaw si pagka'a'a-na.” ");
INSERT INTO abx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mangno pada'iray si mga puno' paraghalad si Judas Iscariote, i addangan si Dusi. ");
INSERT INTO abx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amatilaw iya, “Ay i pinumwan-bi si ako kon pa'intriga-ko iya si ka'am?” Sanglit nagkwintahan dayon iya traynta salapi' diplata. ");
INSERT INTO abx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tikang siray uras, agtikang dayon si Judas pag'anda' si tama' uras nga sapa'intriga-na si Jesus si mga iya. ");
INSERT INTO abx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngan panakka-na si primiro allaw si Pyista si Tinapay nga Gana' Pammatubu'-na, pamadugok si Jesus i mga inadalan-na ngan agpamatilaw, “Singnga may i karuyag-mo nga agtima kami' para si pakan pagpa'intom si Paglabay?” ");
INSERT INTO abx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Anaruman iya, “Padulhuga kam pan syudad pagbagat sito a'a ngan pinugaru-bi, ‘Agpinugad i Ma'istro: Titakka na i uras nagtagama para si ako ngan aruyag ako pagsilibrar anan si ka'am nan huwang i mga inadalan-ko pagpa'intom si Paglabay.’” ");
INSERT INTO abx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sanglit agsunud-na si mga inadalan i dimu'an tugun-na si Jesus ngan agtima mga iya para si pakan. ");
INSERT INTO abx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kasanguman, agkatarangka' si Jesus pati' i Dusi. ");
INSERT INTO abx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Si pagpamangan-na na mga iya aminugad si Jesus, “Sumatan-ta kam si kamatu'uran, addangan gayod si ka'am i titraydor si ako.” ");
INSERT INTO abx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mga masurub'on gayod mga iya ngan agtikang pagpinugad si iya sa'uru'addanganay, “Paragdalom, sigurado ma'in ako ha?” ");
INSERT INTO abx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Anaruman may si Jesus, “I addangan nga magpaduldol si pan-na si matapit mangko' nagpaduldulan-ko, iya i titraydor si ako. ");
INSERT INTO abx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Maratayon i Pinili' A'a pariho si maka'anna' si Kasuratan, pero papabidu'on gayod i titraydor si iya! Mas mahalap pa kunta' si iya nga ga'i na hamok naghinganak si nanay-na.” ");
INSERT INTO abx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mangno aminugad si Judas, i titraydor si iya, “Rabbi, sigurado ma'in ako ha?” Anaruman si Jesus, “Ka'aw, ngan ka'aw i magpaguwa' sinan.” ");
INSERT INTO abx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Si pagpamangan-na na mga iya, angaddo' si Jesus adda bug'os pan ngan agpasalamat si Diyos. Agturutabbi'-nay to ngan agpumwan-na si mga inadalan-na dungan si pagpinugad, “Karawatu-bi to ngan kakanu-bi, iyay to i puhu'-ko.” ");
INSERT INTO abx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Katapos, angaddo' iya kupa ngan agpasalamat si Diyos. Mangno agpumwan-nay to si mga iya dungan si pagpinugad, “Anginuma kam dimu'an anan sinan kupa ");
INSERT INTO abx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kay iyay nan i laha'-ko nga kasarigan si pa'agi-na si Diyos pagtapit si iya ngan pa'awas to para si malabbat a'a basi' apasaylo i mga sala'. ");
INSERT INTO abx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sumatan-ta kam, ga'i na ako anginom gihapon sito bino tubtob si allaw nga paluwa' i baha'o pa'agi pag'inum-ko si bino huwang si ka'am ari si ginhadi'an-na si Tatay-ko.” ");
INSERT INTO abx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mangno, pakahuman-na mga iya agkanta adda salmo, pagawas dayon mga iya ngan pamada'iray si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. ");
INSERT INTO abx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Katapos agsumatan-na si Jesus i mga inadalan-na, “Mismo ina'anto sangom pamabulag kam dimu'an ngan ambanan-bi ako tungod si mahinabo' si ako, kay yayto i maka'anna' si Kasuratan: Maratayun-ko i mangngataman, sanglit agwararak i kakarniruhan. ");
INSERT INTO abx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero kahuman si pakabanhaw-ko, agdahulo ako si ka'am pan Galilea.” ");
INSERT INTO abx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Amahalling dayon si Pedro, “Bisan kon pama'amban i dimu'an tungod si mahinabo' si ka'aw, ga'i gayod ako pa'amban si ka'aw!” ");
INSERT INTO abx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Anaruman may si Jesus, “Sumatan-ta kaw si kamatu'uran, mismo ina'anto sangom, antis anutturu'ok i manok agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo.” ");
INSERT INTO abx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero aminugad dina si Pedro, “Ga'i nan sahimu-ko pagdidiwaray nan nga ga'i kaw sakilala-ko, bisan pa kon kinahanglan ako amatay huwang si ka'aw!” Ngan da'inan liwat sinan i mga pinahallingan-na si ditangnga' pa mga inadalan. ");
INSERT INTO abx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mangno anakka kas Jesus pati' i mga inadalan-na si lugar nga nagtanuman kakayuhan nag'arunan Getsemane. Agpaminugad-nay to, “Pada'iray ako si dahulu'an ngan ato kam dahulo agpanlumpagi' hasta nga ga'i ako atapos ag'ampo'.” ");
INSERT INTO abx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pero agpabaya'-na si Pedro pati' i duwangan dadi'-na si Sebedeo paghuwang si iya. Agtikang iya pag'abat kabidu'an ngan agpanangis gayod i kasing-kasing-na. ");
INSERT INTO abx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Si kaliyat-liyatan agpinugad-na mga iya, “Masurub'on gayod i kasing-kasing-ko ngan day mabubukahon tungod si paddi-na. Ato kam hamok basi' sa'abat-ko i paghuwang-bi.” ");
INSERT INTO abx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngan pakadahulu'an-na si Jesus si tallungan, pa'akkom iya ngan ag'ampo', “Tatay-ko, kon ahimo may dina, palihison si ako kupay to si kasakitan, pero dakaw agtumanon i katuyu'an-ko hamok, kundi' i katuyu'an-mo gayod.” ");
INSERT INTO abx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mangno pabwiltay to si mga iya ngan satakkahan-na nga agparapamaturi na dina. Sanglit agpukaw-na si Pedro si pagpatilaw, “Ga'i ba' kam agpakakaya pagpapiraw bisan un'ura hamok paghuwang si ako? ");
INSERT INTO abx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Agkallata kam ngan ag'ampu'a kam basi' sa'agwanta-bi i mga pagpurbar si mga pagtutu'u-bi. Awili i inisipan pagtuman si mga katuyu'an-na si Diyos, pero maluya pag'alagad i kada'an kina'iya.” ");
INSERT INTO abx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pa'amban gihapon si Jesus si mga iya si kaduwa bisis ngan ag'ampo' utro, “Tatay-ko, kon ga'i gayod akalihis to kupa si ako hasta nga ga'i sa'inum-ko i isi-na, tumanon i katuyu'an-mo gayod.” ");
INSERT INTO abx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Katapos, agbwilta-na i mga inadalan-na ngan satakkahan-na namay nga agparapamaturi dina kay mga mabuwat na i mga mata-na. ");
INSERT INTO abx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sanglit agpangambanan-nay to gihapon ngan ag'ampo' si katallo bisis nga pariho hamok i mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mangno pabwilta iya si mga inadalan-na ngan agpaminugad-na, “Agparapamaturi pa ba' kam gihapon? Ag'ikmata kam! Iya nayto i uras nga trarayduran na i Pinili' A'a ngan papa'intrigahon na iya si mga makasasala'. ");
INSERT INTO abx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Banguna na kam anan kay pada'iray na kita kam. Kulawi-bi ro, awira' na i magtraydor si ako!” ");
INSERT INTO abx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Si pagparapahalling-na pa si Jesus, anakka si Judas nga addangan si Dusi. Bali labbat i kahuruwangan-na nga nagpamabawa-na si mga puno' paraghalad pati' si mga mata'o kamabu'utan-na si mga Hebro. Aniya' mga ispada-na sito mga a'a pati' mga batuta. ");
INSERT INTO abx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Antis sinan, agsumatan-na dahulo si magtraydor i mga kahuruwangan-na kon ay i pangngilalahan si darakupun-na mga iya: “I lalla inuruk-ko, iya i nagkinahanglan-bi. Dakupu-bi dayon iya.” ");
INSERT INTO abx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ngan pakatapit-na si Judas si Jesus, aminugad dayon iya, “Rabbi, kumusta kaw!” ngan diritso ag'uruk-na. ");
INSERT INTO abx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Anaruman may si Jesus, “Sangkay, buhaton i nagpada'itu-mo.” Mangno pamadugok i mga lalla si Jesus. Agdakup-nay to mga iya ngan agpugulan-na. ");
INSERT INTO abx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tungod sinan, aniya' si mga kahuruwangan-na si Jesus i manhulkot si ispada-na ngan diritso agtigbas-na i rilihugun-na si gilalabawi paraghalad, ngan akapalungan to. ");
INSERT INTO abx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Agmandaran-na iya si Jesus, “Patakubon ispada-moy nan, kay dimu'an mag'antan si ispada, mismo i ispada i manmatay si iya. ");
INSERT INTO abx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ga'i ba' kam akatu'anan nga kon amalako ako bulig tikang si Tatay-ko, sigurado nga pabawahan-na ako ato sitinta mil o anubra pa mga ka'anghelan? ");
INSERT INTO abx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero kon agda'inan ako sinan, pinapa'i atuman i maka'anna' si Kasuratan nga kinahanglan ahinabo' to si da'ito gayod pa'agi?” ");
INSERT INTO abx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mangno amahalling si Jesus ari si magpandarusong, “Ribildi ba' ako nga kinahanglan kam gayod agbawa si mga ispada-bi pati' si mga batuta-bi nan pagdakop si ako? Balang allaw ari ako agparatingkulo' si mga hawan-na si templo si pagparaturu'-ko, ngan ga'i may ako agdakup-bi. ");
INSERT INTO abx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ahinabo' to dimu'an basi' atuman i maka'anna' si Nagpanurat-na si mga Paragsumat.” Agpata'anan-na iya si dimu'an mga inadalan-na ngan agpanrarabunos pag'amban. ");
INSERT INTO abx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mangno nagbawa si Jesus si mga magpandakop si iya pada'iray si ruma'-na si Caifas, i gilalabawi paraghalad. Agtiriripon ari i mga paragturo' bala'od pati' i mga mamata'o kamabu'utan. ");
INSERT INTO abx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pero amungyod si Pedro si mga iya nga apartado ngan akasallod to si hawan-na si ruma'-na si gilalabawi paraghalad. Ngan ari na iya, pahuwang iya si mga gwardya magpaningkarag ari pag'antahak kon ay i manakka. ");
INSERT INTO abx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Agparapanganda' i mga puno' paraghalad hasta pa i ditangnga' mga myimbro si Kunsiho mga binurubullo' ibidinsya kuntra si Jesus, basi' sapamatay-nay to mga iya. ");
INSERT INTO abx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero bisan kon bali labbat i mga magpamahalling kabubullu'an, gana' sapaguwa'-na mga iya ibidinsya. Si katapus-tapusan, aniya' gihapon duwangan si mga magtambong ari nga pan dahulu'an ");
INSERT INTO abx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","pagtistigos, “Agpahalling to a'a nga pwidi kuno' sabungkag-na i templu-na si Diyos ngan tindug-nay to gihapon sallod hamok si tallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kahuman sinan, anunggo i gilalabawi paraghalad ngan agtilaw-na si Jesus, “Gana' ba' sapasaruman-mo si mga iya? Ay kay agpakapahalling mga iya da'inan sinan?” ");
INSERT INTO abx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ga'i agsibu'-sibo' si Jesus. Agtilaw-na iya gihapon si gilalabawi paraghalad, “Pina'agi si arun-na si gana' kamatayun-na Diyos, agmandaran-ta kaw pagsumat si kami': Ka'aw ba' i Tinu'inan Mannanalwas, i Dadi'-na si Diyos?” ");
INSERT INTO abx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Lingun-na may si Jesus, “Oho', ngan ka'aw i magpaguwa' sinan. Sanglit sumatan-ta kam: Ga'i na agliyat, papakulawon kam si Pinili' A'a nga agtingkulo' si kawanan-na si Makagagahom ngan papakulawon kam liwat si iya ari si panganod si pagdadara'un-na.” ");
INSERT INTO abx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aggisi'-na dayon si gilalabawi paraghalad i sutana-na ngan mangisog, “Aglalabawan-na sito a'a i Diyos! Ga'i na kita kam agkinahanglan mga tistigos pa! Mismo ina'anto, sapamati'an-bi na nga aglalabawan-na sito a'a i Diyos. ");
INSERT INTO abx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ay i pinahusgar-bi si iya?” Anaruman may mga iya, “Kamatayon i angay nagpapatok si iya.” ");
INSERT INTO abx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mangno agpararukda'an-na mga iya si Jesus si bayhon ngan nagparapuniti iya. Nagparatampalo liwat iya si ditangnga' ");
INSERT INTO abx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ngan agparapatilawan-na mga iya sa'uru'addangan, “Tiguhon daw, ka'aw nga Tinu'inan Mannanalwas kuno', say di' i mamuniti si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Siray uras, ari pa si gawas si Pedro, ari si hawan agparalumpagi'. Kata'ud-ta'uran, aniya' kabulig danda padugok si iya ngan aminugad, “Huwang-na kaw liwat si Jesus nan nga taga Galilea.” ");
INSERT INTO abx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero agdidiwaray iya atubang si dimu'an mga a'a ari si pagpinugad, “Gana' sa'urup-urupan-ko si nagparayawit-moy nan.” ");
INSERT INTO abx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Katapos pasirong iya si pwirtahan-na si kuta', ngan ari namay iya sakulawan-na si la'in namay kabulig. Anumat to dayon si mga magpanunggo ari, “Huwang-nay to liwat a'a si Jesus nan nga taga Nasaret.” ");
INSERT INTO abx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero agdidiwaray iya gihapon ngan agsumpa' pa liwat iya: “Ga'i gayod ako angilala sinan!” ");
INSERT INTO abx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kata'ud-ta'uran, aniya' namay pamadugok si Pedro si mga magparapanunggo ari ngan agpaminugad, “Sigurado nga addangan kaw si mga kahuruwangan-na kay klarado si tunada-moy nan.” ");
INSERT INTO abx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mangno amahalling si Pedro, “Bisan pa ako pugutan-bi kon ga'i ako agsumat si kamatu'uran, akatu'anan i Diyos nga ga'i gayod ako angilala sinan.” Mismo siray uras, anutturu'ok i manok. ");
INSERT INTO abx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tungod sinan, sa'intuman-na dayon si Pedro i pinahallingan-na si Jesus: “Antis anutturu'ok i manok, agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo.” Mangno pagawas iya ngan ari agparadinamag makusog. ");
INSERT INTO abx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngan kanalungan, nagka'araddahan si mga puno' paraghalad pati' mga mata'o kamabu'utan-na si mga Hebro nga kamatayon i angay pinapatok si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Agpagapus-na mga iya si tamburo' ngan agpabawa-na basi' apa'intrigay to ari si Gubirnador Pilato. ");
INSERT INTO abx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Si pakakulaw-na si Judas, i magtraydor, nga nagpatukan si Jesus, bali i pagbasul-na ngan agpabalik-na i traynta salapi' diplata si mga puno' paraghalad pati' si mga mata'o kamabu'utan. ");
INSERT INTO abx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Lingun-na si Judas, “Sala'an gayod ako kay agtrayduran-ko i a'a nga ma'in angay nagpatukan kamatayon.” Anaruman may mga iya, “Ay i nagla'uman-mo pa si kami'? Tawa'-mo naynan baratunun-mo.” ");
INSERT INTO abx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sanglit agpatapuk-na na hamok si Judas i kwarta ari si templo ngan pa'amban. Pagawas iya si syudad ngan agbitay si kalugaringun-na. ");
INSERT INTO abx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Agpumwa'-na si mga puno' paraghalad i mga diplata pero aniya' maminugad, “Supak si bala'od nga nagpa'anna' nan si kaha-na si templo kay yaynan kwarta nagpabayad si kamatayun-na si a'a.” ");
INSERT INTO abx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sanglit agbaragawan-na na hamok mga iya nga ginamit i kwarta pammutong si pitak-na si paraghimo pakattan para panlabbungan si mga dayuhan. ");
INSERT INTO abx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iyay nan i rason kon ay kay Pitak si Pagwasakan-na si Laha' i pag'aron sinan hasta pa ina'anto. ");
INSERT INTO abx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pwira pa sinan, akata'op liwat nga atuman i mga allingun-na si paragsumat Jeremias: “Agkarawat-na mga iya i traynta salapi' diplata nga iya i kantidad nagpaprisyo si iya si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mangno agpabutung-na mga iya si pitak-na si paraghimo pakattan, sigon si mandu'-na si Paragdalom si ako.” ");
INSERT INTO abx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Siray uras, ari na si Jesus ag'atubang si gubirnador ngan agtilaw-na iya, “Ka'aw ba' i hadi'-na si mga Hebro?” Anaruman may si Jesus, “Oho', ngan ka'aw i magpaguwa' sinan.” ");
INSERT INTO abx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pero ngan pagparapamasumbung-na si mga puno' paraghalad pati' si mga mamata'o kamabu'utan si iya, ga'i gayod iya anaruman. ");
INSERT INTO abx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sanglit agtilaw-na iya gihapon si Pilato, “Sapakalihan-mo ba' kalabbat-nay nan si mga ibidinsya-na kuntra si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ga'i iya anaruman bisan namay hamok adda si mga sumbung-na hasta nga ga'i na gayod akapugungan i pag'usa-na si gubirnador. ");
INSERT INTO abx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kundi' aniya' kabatasanan-na si gubirnador kon Pyista pagpalibri addangan priso nga nagpalaku-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Siray uras aniya' bantugan gayod priso nag'arunan Barabas. ");
INSERT INTO abx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sanglit ngan malabbat na i magpanggubok ari, amatilaw si Pilato, “Say i saruyagan-bi nga pinalibri-ko: Si Barabas ba' o Jesus to nga nagkilala bilang Tinu'inan Mannanalwas?” ");
INSERT INTO abx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Agda'inan si Pilato kay akatu'anan iya nga nagpa'intriga si Jesus si iya tungod hamok si mga ka'awa'-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Si pagparatingkulu'-na si Pilato si panhuhusgaran panningkulu'an, agpatugon i alla-na sito mga allingon: “Dakaw agpata'anin a'ay nan nga ma'in angay nagpatukan kamatayon kay ina'anto pa hamok, bali i inantus-ko si upi-ko tungod si iya.” ");
INSERT INTO abx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero parapangaghat-na si mga puno' paraghalad pati' si mga mata'o kamabu'utan i magpanggubok nga si Barabas i pinalibri ngan si Jesus dina i maratayon. ");
INSERT INTO abx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Amatilaw gihapon i gubirnador si mga iya, “Say si duwangan to i saruyagan-bi nga pinalibri-ko?” Anaruman may mga iya, “Si Barabas!” ");
INSERT INTO abx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Amatilaw gihapon si Pilato, “Kon sugad, pa'i-ko may to Jesus to nagkilala bilang Tinu'inan Mannanalwas?” Anurakaw dina mga iya dimu'an, “Papaku'on iya si kudos!” ");
INSERT INTO abx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lingun-na may si Pilato, “Kapa'i may? Ay i mara'at binuhatan-na sito a'a?” Pero agkukusog dina i turakaw-na si mga a'a, “Papaku'on iya si kudos!” ");
INSERT INTO abx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sanglit pakahuna'-huna'-na si Pilato nga gana' may hamok kapulsanan-na si mga pama'agi-na kundi' agtikang dina agsaramok i mga a'a, angala' iya buwahi' si planggana ngan anguso' atubang si mga iya. Aminugad iya, “Gana' kalabtanan-ko si kamatayun-na sito a'a. Tawa'-bi naynan baratunun-bi!” ");
INSERT INTO abx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Agpaminugad may i dimu'an mga a'a, “Kami' i manaruman si kamatayun-na ngan hasta pa liwat si mga ka'uru'ampuhan kami'!” ");
INSERT INTO abx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sanglit agpalibri-na si Barabas. Mangno kahuman-na agpalatigo si Pilato si Jesus, agpa'intriga-nay to dayon si mga sundalo nga tipapako' si iya. ");
INSERT INTO abx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nagbawa si Jesus si mga sundalu-na si gubirnador pada'iray si hawan-na si palasyu-na. Katapos agtiripun-na mga iya i ditangnga' pa mga sundalo nga sakop si batalyun-na mga iya ngan agrilibutan-nay to mga iya. ");
INSERT INTO abx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naghugkasan to si panaptun-na ngan nagbistihan si hadi'anon pammakurumbot nga kulor igot. ");
INSERT INTO abx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mangno aghimo mga iya likaw tikang si tangulon ngan nagpakuruna si Jesus. Agpa'antan-nay to mga iya utod bigahaw si kawanan tamburo' pinakasiptir ngan agparapanluhod mga iya atubang si iya ngan sigi-na mga iya panlangkag, “Malanga pa kunta' i kinabuhi'-na si hadi'-na si mga Hebro!” ");
INSERT INTO abx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Agparapanrukda'an-nay to mga iya sa'uru'addangan ngan nagparasiyuhan si bigahaw-na nga iya mismo i nagparapapakol si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos si pagparapanlangkag-na, naghugkas i nagpakurumbot ngan nagbadu'an gihapon si kalugaringun-na panapton. Mangno agbawa-nay to mga iya pan gawas basi' apapako' si kudos. ");
INSERT INTO abx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Si pagparalalangngan-na mga iya, aniya' satupu'-na mga iya a'a nag'arunan Simon nga taga sunsari'i si syudad Cirene ngan agpirit-nay to mga iya pagpalangkit si kudus-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Anakka mga iya si tagudtod nag'arunan Golgota, nga i kahulugan-na takuluk-na si minatay. ");
INSERT INTO abx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ngan ari na mga iya, agpa'inum-na kunta' mga iya si Jesus bino nga nagsalakutan si mapa'it hirbo. Pero ngan pakatimtim-na sito, andiri' dayon iya pag'inom. ");
INSERT INTO abx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pakapapaku'-na mga iya si Jesus, agpararti-na mga iya i mga sul'ut-na pina'agi si ripa. ");
INSERT INTO abx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Katapos agpaningkulo' to pagbantay si iya. ");
INSERT INTO abx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Si takulukan-na si Jesus, agpadukut-na mga iya i sumbong kuntra si iya nga da'ito sito: SI JESUS I HADI'-NA SI MGA HEBRO ");
INSERT INTO abx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aniya' liwat duwangan bandido nga nagpapako' si mga kudus-na tingpid si iya, i addangan ari si kawanan-na ngan i addangan may ari si kawiri-na. ");
INSERT INTO abx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nagparatabri'an iya si mga manlalabay ngan nagparatamay. ");
INSERT INTO abx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Sigi mga iya panyayawit, “Ka'aw magpinugad nga bungkag-mo i templo ngan tindug-mo gihapon sallod si tallo allaw, salbaron i kalugaringun-mo! Pahaw'asa anan si kudos nan kon ungod kaw Dadi'-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Purupariho liwat sinan i mga langkag-na si mga puno' paraghalad, si mga paragturo' bala'od pati' si mga mata'o kamabu'utan. ");
INSERT INTO abx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Sigi liwat mga iya panyayawit, “Sasalbar-na i la'in a'a, pero i kalugaringun-na lugod ga'i! Iya kuno' i Hadi'-na si Israel! Kinahanglan pahaw'as iya ina'anto anan si kudos nan basi' kami' agpanutu'o si iya. ");
INSERT INTO abx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Agtapod iya si Diyos. Kulawan-ta daw kon sapalipay-na pa iya kay agpinugad may iya nga Dadi'-na iya si Diyos. Kunta' salbar-na iya ina'anto.” ");
INSERT INTO abx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bisan i mga bandido nga nagpamapako' tingpid si iya, agpangirog liwat pagtamay si iya. ");
INSERT INTO abx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ngan ka'amudtuhan, anlu'om i bug'os pitak palibot ari mga tallo uras. ");
INSERT INTO abx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pangalastris na, amahalling makusog si Jesus, “Eli, Eli, lama sabachthani?” nga i kahulugan-na, “Diyus-ko, Diyus-ko, kapa'i may kay ag'ambanan-mo na ako?” ");
INSERT INTO abx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngan pakapamati'-na si ditangnga' magparapanunggo matapit si iya, agpaminugad to, “Agban'u-na sito a'a si Elias.” ");
INSERT INTO abx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aniya' dayon addangan maglalahi pada'iray si Jesus. Agbawa iya ispungha hinumog si malassom na bino ngan agpatulu-nay to si adda lingkawan basi' anakka ari si bawa'-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngan agpaminugad may i ditangnga', “Hala, angantahak kita kam. Kulawan-ta daw kam kon anakka si Elias pagsalbar si iya!” ");
INSERT INTO abx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pakapahalling-na gihapon makusog si Jesus, agtugutan-na i kalugaringun-na espirito pag'amban. ");
INSERT INTO abx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ari si templo siray uras, hintak agisi' si duwa parti i pannalingkop kurtina tikang si dyata' diritso pan hawod. Abay'og i kalibutan ngan agkatirimpag i mga kapapangpangan. ");
INSERT INTO abx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Agpaka'abrihan i mga kwiba panlalabbungan ngan i mga bangkay-na si mga a'a nagtagama paghuwang si Diyos ka'urugan pabangon ngan agpakabalikan si dati kinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pamagawas mga iya si mga kwiba-na, pero kahuman dina si pakabanhaw-na si Jesus i pamasallud-na si sagrado syudad ngan agpakulaw mga iya si malabbat a'a. ");
INSERT INTO abx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngan pakakulaw-na si sinturyon hasta si mga kahuruwangan-na maggwardya si Jesus si dimu'an mahinabo' dungan si paka'abat-na si linog, kinulbahan gayod mga iya ngan agpakapinugad, “Sigurado nga iyay nan i Dadi'-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Malabbat liwat ari mga danda magparapamantaw hamok si katalahan. Iyay nan mga iya i magparapamaya'-baya' si Jesus pagpanginano si mga kinahanglanun-na tikang pa si Galilea. ");
INSERT INTO abx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Huwang si mga iya kas Maria Magdalena, si Maria nga nanay-na kas Santiago pati' Jose hasta pa i nanay-na si mga dadi'-na si Sebedeo. ");
INSERT INTO abx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aniya' mayaman a'a nga taga sunsari'i si bungto Arimatea nag'arunan Jose, ngan addangan liwat iya si mga inadalan-na si Jesus. Ngan kuhap na, ");
INSERT INTO abx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","padugok iya si Pilato pagpalako si bangkay-na si Jesus, ngan agmando' dayon si Pilato pagpumwan sito si Jose. ");
INSERT INTO abx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aghaw'as-na si Jose i bangkay ngan agputus-nay to si baha'o binalli katsa. ");
INSERT INTO abx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Katapos aghulid-nay to si kalugaringun-na kwiba panlalabbungan nga naghimo mismo si pangpang ari. Agpaligid mga iya adda mahaya bato pagsagpo' si pwirtahan-na si naglabbungan ngan diritso mga iya pama'amban. ");
INSERT INTO abx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Siray uras, agparapaningkulo' pa kas Maria Magdalena pati' i addangan pa Maria atubang si naglabbungan. ");
INSERT INTO abx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ka'asumuhan, nga iya i Bispira si Allaw Pandidiskanso, agbagat-na si mga puno' paraghalad pati' si mga Parisiyo si Pilato. ");
INSERT INTO abx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Agpinugad-nay to mga iya, “Sinyor, aka'intom kami' nga agpinugad ray bullu'on ray nga kahuman kuno' si katallo allaw, abanhaw iya. ");
INSERT INTO abx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sanglit kinahanglan anmando' kaw nga pagpabantay si naglabbungan tubtob si katallo allaw kay kon ga'i, tingali pamada'iray i mga inadalan-na ngan larisan-na mga iya pag'ala' i bangkay ngan panumatan-na i mga a'a nga abanhaw iya. Kon ahinabo' to, mas mara'at payto kabubullu'an kuntra si primiro nag'aku'-na.” ");
INSERT INTO abx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aminugad may si Pilato, “Hala, amabaya'a na kam hamok bisan pira mga sundalo. Tigbantayi-bi si mga iya pahalap i naglabbungan si pinakamahalap pa'agi sahimu-bi.” ");
INSERT INTO abx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sanglit agpamada'iray mga iya ngan agpamantayan-na pahalap i labbong huwang i pag'anna' si pangngilalahan pagpasiguro nga kinaklaruhan kon nagtandog i nagpasirra bato basi' satistigusan-na si nagbilin bantay. ");
INSERT INTO abx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngan pakahuman-na si Allaw Pandidiskanso, pagdadanta' pa hamok si Duminggo nalong, pamada'iray kas Maria Magdalena pati' i addangan pa Maria si naglabbungan pag'usisa. ");
INSERT INTO abx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Panakka-na mga iya ari, hintak anlinog makusog tungod si anghel-na si Paragdalom nga pan hawod tikang si langit. Agdiritsoy to si naglabbungan, agpaligid-na i bato ngan agtingkulu'an-na. ");
INSERT INTO abx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Agdadanta' i bug'os puhu'-na pariho si kil'at ngan i sutana-na bali pagkaputi'. ");
INSERT INTO abx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tungod si katalaw-na si mga gwardya si iya, nagpangadal to ngan agkadirismayo. ");
INSERT INTO abx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Agbagawan-na si anghel i mga danda, “Dakam agkataralaw. Akatu'anan ako nga agpara'anda'-bi si Jesus nga nagpapako' si kudos. ");
INSERT INTO abx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ga'i na iya ato; abanhaw iya sigon si dati allingun-na! Paduguka kam ato ngan kulawi-bi i naghuliran si iya. ");
INSERT INTO abx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Katapos pada'iraya kam dayon ngan sumati-bi i mga inadalan-na: ‘Abanhaw iya ngan agdahulo si ka'am pan Galilea, sanglit ari iya sakulawan-bi.’ Iyay nan dimu'an i tigpasumat-na.” ");
INSERT INTO abx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sanglit agdadagmit i mga danda pag'amban si naglabbungan nga bali pa i mga katalaw-na, pero akasalakutan na si mahaya kalipayan. Diritso mga iya palahi pagsumat si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Si pagparapanlalahi-na, hintak anupo' si Jesus si mga iya ngan aminugad, “Kumusta kam.” Pamadugok to, katapos pamakupo' si kitiran-na ngan agpangampo' si iya. ");
INSERT INTO abx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mangno agpinugad-na mga iya si Jesus, “Dakam agkataralaw. Pada'iraya na kam ngan sumati-bi i kabugtu'an-ko si pagtu'o nga pamada'iray mga iya si Galilea kay ari ako mga iya sakulawan-na.” ");
INSERT INTO abx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Si palangngan-na si mga danda, aniya' si mga gwardya magpamalik pan syudad pagsumat si mga puno' paraghalad mahi'unong si dimu'an mahinabo'. ");
INSERT INTO abx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Agtiriripon dayon i mga puno' paraghalad pati' i mga mata'o kamabu'utan ngan agkurunsabo. Agsuhulan-na mga iya i mga sundalo mahaya kantidad ");
INSERT INTO abx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","huwang i tugon, “Kinahanglan i pinasumat-bi nga agpamada'iray i mga inadalan-na ngan dabwi, ngan ag'ala'-na mga iya i bangkay si pakapaturi-bi. ");
INSERT INTO abx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kon sapakalihan-nay to hurub-hurob si gubirnador, ata'o kami' pagpalipay si iya nga matala pa kam si samok.” ");
INSERT INTO abx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sanglit agkarawat-na si mga sundalo i kwarta ngan agpanunud-na i tugon si mga iya. Ngan yaynan isturya agsara si dimu'an mga Hebro hasta pa ina'anto. ");
INSERT INTO abx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mangno agpamada'iray si Galilea i unsi inadalan, ari si dati bukid nagsumat-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pakakulaw-na mga iya nga agdadara'on si Jesus, agpangampo' to pero aniya' gihapon si mga iya nga agpanduda pa. ");
INSERT INTO abx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pero padugok si Jesus si mga iya ngan diritsoy to agpanu'inan-na, “Nagpumwan na si ako i dimu'an gahom si langit pati' ato si kalibutan. ");
INSERT INTO abx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sanglit pada'iraya kam si dimu'an nasyon ngan bisan singnga kam akatakka, anganda'a kam mga a'a nga magin inadalan. Buhatu-bi nan pina'agi si pagbunyag si mga mag'ako' si arun-na si Tata', si Dadi' pati' si Espirito Santo ");
INSERT INTO abx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ngan pina'agi liwat si pagturo' si mga iya pagtuman si dimu'an nagmandu'-ko si ka'am. Sigurado gayod nga aghuwang ako pirmi si ka'am hasta pa si katapusan-na sito panahon.”");
INSERT INTO abx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I tinikangan-na si mahalap sumat nga si Jesus i Tinu'inan Mannanalwas pati' i Dadi'-na si Diyos: ");
INSERT INTO abx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aniya' nagsurat-na si paragsumat Isaias siray panahon nga agpahalling i Diyos pada'iray si Dadi'-na: Aniya' paragsumat-ko nga padahulu-ko si ka'aw paghawan si pangngagihan-mo. ");
INSERT INTO abx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Awiray iya si disyirto ngan agparapasamwak, “Hawani-bi i aragihan-na si Paragdalom; tadungu-bi i lalan ralangnganan-na.” ");
INSERT INTO abx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mangno a'ungod to anan si Juan. Agparabunyag iya ari si disyirto ngan agparawali si mga a'a nga kinahanglan mga iya agbasol huwang si pagbag'o ngan agpabunyag basi' apasaylo i mga sala'-na. ");
INSERT INTO abx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka'urugan si magpangistar si Jerusalem i magdayo si iya ngan da'inan may i ditangnga' pa mga kaburubungtuhan si Judea. Kahuman si pagparapangumpisal-na mga iya, agbunyagan-na mga iya si Juan ari si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Agbado' si Juan si hiniro hinimo tikang si barahibu-na si kamel ngan agpaha iya tikang si anit-na si hayop. I kinakan-na duron pati' anira'. ");
INSERT INTO abx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yayto liwat i nagparasumat-na: “Aniya' mabantog kahuman si ako nga mas labaw pa i gahum-na. Ma'in ngani' ako angay bisan pagbak'ad si sintas-na si sapatus-na. ");
INSERT INTO abx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Agbunyagan-ko kam parti si buwahi', pero burunyagan-na i mga a'a pagpa'ayop si Espirito Santo.” ");
INSERT INTO abx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sinan mga uras, anakka si Jesus tikang si Nasaret, adda baryo si prubinsya Galilea ngan agpabunyag iya si Juan ari si Suba' Jordan. ");
INSERT INTO abx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ngan pakatuwa'-na si Jesus si buwahi', sakulawan-na i pag'abri-na si langit ngan i Espirito Santo pan hawod pada'iray si iya pariho si adda sarampati. ");
INSERT INTO abx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aniya' liwat kinabati'an busis tikang si langit nga agpinugad, “Ka'aw i Dadi'-ko nga hinigugma'-ko. Alipay gayod ako si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Agpirit-na dayon iya si Espirito pagpada'iray si disyirto, ");
INSERT INTO abx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ngan ag'istar iya ari sallod si kwarinta diyas. Agparatintar-na iya si Satanas ngan aniya' liwat ari mga ma'isog hayop, pero agpara'ataman-na iya si mga anghel. ");
INSERT INTO abx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kahuman pagpriso si Juan, pada'iray si Jesus si Galilea, ngan agpasamwak-na i mahalap sumat-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Agpinugad iya, “Anakka na i uras. Matapit na gayod i paghadi'-na si Diyos. Agbasula kam huwang si pagbag'o ngan anutu'uha kam si mahalap sumat.” ");
INSERT INTO abx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngan pagparalalangngan-na si Jesus si bihing-na si Danaw Galilea, sakulawan-na i magdingsirarihan Simon pati' Andres. Agtaktak-na mga iya i pukut-na siray uras kay pandaying may i mga paka'allum-na. ");
INSERT INTO abx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Agban'u-na mga iya si Jesus, “Tuwa kam, amaya'a kam ngan agsunura kam si ako basi' sapabawa-ko kam malabbat a'a pagtapod si Diyos pariho si kalabbat-na si daying nga sabawa-na si pukut-bi nan.” ");
INSERT INTO abx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mangno, aglabbahan-na dayon mga iya i mga pukut-na ngan amaya' si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngan pira pa hamok i mga pitad-na, sakulawan-na namay si Jesus kas Santiago pati' Juan nga mga dadi'-na si Sebedeo. Agparaladlad mga iya si mga pukut-na ari si paraw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Agban'u-na dayon mga iya si Jesus, ngan diritso ag'ambanan-na i tatay-na mga iya Sebedeo hasta i mga kabulig-na ari si paraw, ngan amaya' mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pada'iray kas Jesus si syudad Capernaum. Ngan panakka-na si Allaw Pandidiskanso, pasallod kas Jesus si sinaguga ari pagturo'. ");
INSERT INTO abx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ag'usa i mga a'a kay si pagturu'-na, akapariho iya si addangan nga aniya' pwirsa-na si mga allingun-na pagpasunod, ma'in pariho si mga paragturo' bala'od. ");
INSERT INTO abx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mangno, aniya' lalla paluwa' ari si sinaguga nga nagbawa-bawa mara'at espirito. Anurakaw to makusog, ");
INSERT INTO abx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ay ba' gayod i tuyu'-mo si kami', Jesus taga Nasaret? Pada'ito ba' kaw pagtapok si kami' pan impyirno? Sakilala-ta kaw. Ka'aw i Sagrado A'a nga nagpabawa-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Animol si Jesus, “Dakaw pararibok! Papindaha anan si iya!” ");
INSERT INTO abx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tinakka i lalla si buntug-na ngan agpakurug-kudug-na iya si mara'at espirito. Papinday to dayon si iya bawa i pagturakaw. ");
INSERT INTO abx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kinulbahan ngan agpangusa gayod i dimu'an mga a'a sanglit agsipurupatilaway mga iya, “Ay ba' to? Adda ba' to baha'o pagturo' nga aniya' gahum-na? Samandaran-na bisan i mga mara'at espirito ngan agpansunod si iya.” ");
INSERT INTO abx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sanglit, ga'i agliyat, abantog dagos si Jesus si bug'os Galilea. ");
INSERT INTO abx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngan paguwa'-na kas Jesus si sinaguga, pamadc'iray mga iya diritso si ruma'-na kas Simon pati' Andres, nga aghuruwang mga iya kas Santiago pati' Juan. ");
INSERT INTO abx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aglibbak i ugangan-na danda si Simon tungod kay mapanas iya. Agsumatan-na mga iya si Jesus nga maburong i ugangan-na si Simon. ");
INSERT INTO abx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sanglit, duguk-na si Jesus i maburong ngan antanan-na si tamburo' pagpabangon. A'ala' i panas-na ngan manginanoy to dayon pagkiwa para si mga iya. ");
INSERT INTO abx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Si pakatunud-na si allaw, agpamawa-na si mga a'a pada'iray si Jesus i dimu'an maburong hasta i mga a'a nga nagbawa-bawa si mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Agtarambak ari siray ruma' i ka'aha'an si bug'os syudad ");
INSERT INTO abx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ngan malabbat i sapahalap-na si Jesus nga aniya' pala'in-la'in binati'-na. Malabbat liwat i nagpapinda-na mara'at espirito, pero ga'i naynan agpanugutan-na nga agpakayawit pa kay akatu'anan mga iya kon say iya. ");
INSERT INTO abx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngan mananalong na, pabangon si Jesus ngan pagawas iya si ruma'. Pada'iray iya si adda mamingaw lugar ngan ari agpara'ampo'. ");
INSERT INTO abx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kata'ud-ta'uran, pagawas kas Simon pag'anda' si iya. ");
INSERT INTO abx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ngan paka'anda'-na na mga iya, agpanumat to, “Nagpara'anda' kaw si mga a'a.” ");
INSERT INTO abx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Anaruman dina si Jesus, “Pada'iray kita kam si la'in lugar, ari si mga matapit baryo, basi' sapasamwak-ko liwat ari i allingun-na si Diyos. Iyay nan i tuyu'-ko si pagpada'itu-ko.” ");
INSERT INTO abx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sanglit, aglibut-na mga iya i kaburubungtuhan si bug'os Galilea ngan agparawali si mga sinaguga ngan agparapamapinda si mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngan ari kas Jesus si adda bungto, aniya' liprusuhon padugok ngan makimalu'oy si iya. Anluhod to atubang si iya ngan aminugad, “Sapahalap-mo gad ako, kon aruyag kaw.” ");
INSERT INTO abx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Alu'oy si Jesus, sanglit agdu'unan-na si palat-na i lalla ngan aminugad, “Oho' gad, buhat-koy nan. Anhalapa!” ");
INSERT INTO abx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A'ala' dayon i liprusu-na ngan anlimpyo i puhu'-na. ");
INSERT INTO abx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Agpalitira-na dayon si Jesus i lalla, ngan bali i pagkapada'an-na, ");
INSERT INTO abx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Agmatuha nga ga'i kaw akasumat si la'in a'a parti sito, pero pada'iraya si paraghalad ngan pakulawon si iya i puhu'-mo. Tighalara ari si nagmandu'-na si Moises para si manhalap basi' kinatu'anan nga nagparatuman pa i Bala'od.” ");
INSERT INTO abx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero pagawas to dina ngan agsumat-na i dimu'an mahi'unong si mahinabo'. Sanglit, tungod si kalabbat-na si magpara'anda' si Jesus, aglikay na hamok iya si pagparadurudulhog. Lugod, ag'istar hamok iya si mga mamingaw lugar. Pero, nagparadayo gihapon iya si mga a'a tikang si dimu'an lugar. ");
INSERT INTO abx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kahuman si pira allaw, ngan pakabalik-na si Jesus si syudad Capernaum, sapamati'an-na si mga a'a nga anakka na iya. ");
INSERT INTO abx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sanglit malabbat magtiriripon si mga iyay ray ngan agparapasamwak-na i mga allingun-na si Diyos. Gana' na gayod lugar para si ditangnga' pa si sallod hasta si gawas-na si pwirtahan. ");
INSERT INTO abx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mangno aniya' magpanakka nga agpamawa irapa pada'iray si iya nga nagbayawan si patangan. ");
INSERT INTO abx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ga'i mga iya akatapit si Jesus tungod si kalabbat-na si a'a, sanglit amanahik mga iya si hagdan pan binubungan. Agbulsugan-na mga iya yungod si Jesus ngan ari agtuntun-na mga iya i irapa huwang si naglibbakan-na. ");
INSERT INTO abx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ngan pakakulaw-na si Jesus si pagtapud-na sito mga a'a, agpinugad-na i irapa, “No', nagpasaylo na i mga sala'-mo.” ");
INSERT INTO abx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aniya' liwat magpaningkulo' ari mga paragturo' bala'od nga agpanduda dina si iya. ");
INSERT INTO abx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ay kay akapahalling to a'a da'inan sinan? Aglalabawan-na sito a'a i Diyos. Gana' makapasaylo si mga sala' kon ma'in hamok i Diyos.” ");
INSERT INTO abx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sakatu'anan-na dayon si Jesus i isip-na si kada addangan si mga iya, sanglit agpantilaw-nay to, “Ay kay da'inan sinan i inisipan-bi? ");
INSERT INTO abx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Singnga sito i masayon: I pagpinugad sito irapa, ‘Nagpasaylo na i mga sala'-mo’ o i pagpinugad, ‘Anungguha, addu'on naglibbakan-moy nan ngan alangngana’? ");
INSERT INTO abx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero, basi' sakatu'anan-bi nga i Pinili' A'a aniya' gahum-na ato si kalibutan pagpasaylo si mga sala', palangngan-koy to irapa.” ");
INSERT INTO abx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mangno agpinugad-na i irapa, “Agtuninunga si ako. Anungguha, addu'on naglibbakan-moy nan ngan agbalika.” ");
INSERT INTO abx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anunggo iya, bitbit-na dayon i naglibbakan-na, ngan aglugaring iya pagawas nga kinakulawan si dimu'an ari. Ag'usa gayod i dimu'an ngan agparadayaw-na mga iya i Diyos, si pagpinugad, “Ga'i pa gayod kami' akakulaw pariho sito tikang si katikang!” ");
INSERT INTO abx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Si utro bisis paglalangngan-na si Jesus si bihing-na si danaw, nagburungyuran iya si kalabbatan ngan agparaturu'an-na. ");
INSERT INTO abx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Si pagparalalangngan-na, samasiran-na namay si Levi, i dadi'-na si Alfeo, nga agparatingkulo' si pwistu-na si pannunukutan-na buhis. Agpinugad-na iya si Jesus, “Amaya'a ngan agsunura si ako.” Anunggo si Levi ngan amaya' si iya. ");
INSERT INTO abx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mangno aniya' allaw nga ari kas Jesus si ruma'-na kas Levi. Malabbat i pamadugok paragsukot buhis pati' mga nagpaminugad makasasala' ngan makitangka' si iya pagkakan huwang si mga inadalan-na kay malabbat na si iya magparapamaya'-baya'. ");
INSERT INTO abx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Si pagpamangan-na, pamalabay i mga paragturo' bala'od nga mga Parisiyo. Ngan pakakulaw-na mga iya nga agkakan si Jesus huwang si da'ito klasi mga a'a, amatilaw mga iya si mga inadalan-na, “Ay kay makihuwang iya pagkakan si mga paragsukot nan buhis pati' si mga makasasala' nan?” ");
INSERT INTO abx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngan pakakatu'an-na sinan si Jesus, mismo iya i manaruman, “Ma'in i mga mahalap a'a i magpanginahanglan duktor, kundi' i mga maburong dina. Ga'i ako pada'ito pag'agda si magpaminugad nga matadong mga iya a'a, kundi' pada'ito ako pag'agda si mga makasasala'.” ");
INSERT INTO abx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Siray, aniya' mga nagpili' allaw si pagpu'asa basi' gana' la'in kinapinsaran pwira hamok si Diyos. Agsunod sito pamatasan i mga inadalan-na si Juan Paragbunyag pati' i mga Parisiyo. Sanglit, aniya' pamadugok ngan agpamatilaw si Jesus, “Ay kay ga'i agsunod i mga inadalan-mo si kabatasanan pagpu'asa pariho si nagbuhat-na si mga inadalan-na si Juan Paragbunyag pati' si inadalan-na si mga Parisiyo?” ");
INSERT INTO abx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Anaruman si Jesus, “Ga'i may gad ahimo nga ga'i amangan i mga imbitadu-na si kinasal lalla kon awinan pa iya. Basta nga huwang payto si mga iya, ga'i pa mga iya pwidi agpu'asa. ");
INSERT INTO abx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ma'in na pira arala'on na i makapariho si kinasal lalla, ngan sinan allaw, iya na dina i angay pagpu'asa-na si mga inadalan-ko.” ");
INSERT INTO abx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Agsumatan-na liwat mga iya sito isturya nga agtukoy si kamatu'uran: “Gana' magpatangbil si baha'o hiniro si adda kada'an na bado'. Kay kon da'ito sito i pagtangbil-mo, gisi'-na gihapon i badu'-mo si nagpatangbil-mo kay ga'i angagwanta i kada'an si baha'o. Mas mara'at to kagisi'an kuntra si dahulo.” ");
INSERT INTO abx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Agsumatan-na mga iya si adday to pa: “Gana' magpa'isi si baha'o irimnon si kada'an na anit pangngingisihan, kay amura' to kon pa'isi-mo, mangno aburhat i pangngingisihan ngan akarag i irimnon. Ma'in da'inan sinan. Angay si baha'o irimnon nga baha'o may i pangngingisihan.” ");
INSERT INTO abx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sin adda, pabalatas kas Jesus si kapatagan nga akatuman si Allaw Pandidiskanso. Sigi pangattos i mga inadalan-na si mga matahak uhay-na si trigo ngan sigi panilsi'. ");
INSERT INTO abx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aniya' mga Parisiyo magriklamo si iya, “Kulawin ngani' nan! Ay kay agkattos mga iya si Allaw Pandidiskanso bisan kon sakatu'anan-bi nga supak nan si bala'od?” ");
INSERT INTO abx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Anaruman may dina si Jesus, “Ga'i ba' sabasa-bi kon ay i nagbuhat-na siray si David ngan kinulang iya tubtob alinganto hasta i mga kahuruwangan-na? ");
INSERT INTO abx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Siray panahon, ngan si Abiatar i gilalabawi paraghalad, pasallod si David si pangngangampu'an tulda ngan angaddo' si pan nagla'in para si Diyos. Agkakan-nay nan nga i mga paraghalad hamok i tugot pagkakan sinan ngan agbuwanan-na pa liwat i mga kahuruwangan-na. Pero ma'in nan sala' para si mga iya.” ");
INSERT INTO abx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Si katapus-tapusan, aminugad si Jesus si mga iya, “Sayod kita nga naghimo i Allaw Pandidiskanso para si kahalapan-na si a'a ma'in nga naghimo i a'a para si kahalapan-na si Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sanglit kon i Pinili' A'a i Paragdalom si bisan ay, iya pa ba' i Allaw Pandidiskanso?” ");
INSERT INTO abx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Si adda bisis nga pasallod si Jests ri sinaguga, aniya' lalla ari nga piyapi i tamburu'-na. ");
INSERT INTO abx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aniya' liwat mga a'a ari magparapanganda' rason nga sapa'akusar-na mga iya si Jesus si pagtrabaho si Allaw Pandidiskanso. Sanglit agtigamanan-na gayod mga iya kon pahalap-na si Jesus i lalla. ");
INSERT INTO abx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pero agpinugad-na dina si Jesus i piyapi tamburu'-na, “Pada'ituha si dahulu'an.” ");
INSERT INTO abx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mangno aminugad si Jesus si mga iya, “Singnga sito i nagpatugot si bala'od si Allaw Pandidiskanso: Pagbuhat kahalapan o karat'an? Pagpanginano si a'a basi' asalbar i kinabuhi'-na o amatay to nga bulag si Diyos?” Pero tungod kay ga'i mga iya aruyag pagpa'ubos si mga kalugaringun-na, ga'i na hamok mga iya agparapanibu'-sibo'. ");
INSERT INTO abx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amuslong si Jesus si mga iya, ngan bali gayod kabidu'-na kay makudat gayod i mga takuluk-na. Sanglit katambahan i kasina-na si mga iya. Katapos agmandaran-na i lalla, “Buklaron tamburu'-moy nan.” Agbuklad-na si lalla, ngan anhamis gihapon i pustura-na si tamburu'-na pariho si dati. ");
INSERT INTO abx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sanglit pamagawas i mga Parisiyo ngan agtikang dayon mga iya pagplano huwang si mga sakop si partido nga tinindug-na pa si Hadi' Herodes kon pinapa'i sapamatay-na mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Palitira kas Jesus huwang i mga inadalan-na pada'iray si danaw, ngan bali labbat si mga taga Galilea i mamaya' si mga iya. Tungod kay abantog i mga binuhatan-na si Jesus, malabbat liwat i magpandayo si iya. Aniya' sito mga taga Judea, ");
INSERT INTO abx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","huwang na mismo i mga taga Jerusalem, hasta pa i mga taga prubinsya Idumea pati' i magpangistar si dambila'-na si Suba' Jordan. Agpamada'iray liwat i magpangistar palibot si mga syudad Tiro pati' Sidon. ");
INSERT INTO abx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sanglit agsumatan-na i mga inadalan-na pag'andam adda si mga madiki' paraw ari, kay nagparadarusong na iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Malabbat i sabulung-na, sanglit agparasusuksok i ditangnga' pa mga binati'on basi' aka'antan mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bisan sumiran sakulawan-na si mga mara'at espirito si Jesus, agpa'akkum-na mga iya i nagbawa-bawa-na ngan agpaturakaw-na, “Dadi'-na kaw si Diyos.” ");
INSERT INTO abx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero agdiri'-na dayon si Jesus i mga mara'at espirito pagparasumat pa kon say iya. ");
INSERT INTO abx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Katapos, pasagka si Jesus si adda matapit tagudtod. Agban'u-na i mga saruyagan-na pagdugok si iya, ");
INSERT INTO abx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ngan agpili' iya dusi. Agpanu'inan-nay to bilang mga apostol basi' sapabaya'-na ngan basi' salihug-na pagpasamwak si allingun-na ");
INSERT INTO abx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ngan da'inan may basi' sabuwanan-na gahom pagpapinda si mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yayto i dusi nagpili'-na: Si Simon nga ag'arunan-na si Jesus, Pedro; ");
INSERT INTO abx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago pati' si Juan nga mga dadi'-na si Sebedeo, nga agpangarunan-na si Jesus “Boanerges”, nga i kahulugan-na “Makusog pariho si dalugdog”; ");
INSERT INTO abx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago nga dadi'-na si Alfeo, si Tadeo, si Simon nga sakop si grupu-na si mga Selote, ");
INSERT INTO abx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pati' si Judas Iscariote i titraydor si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ngan padulhug-na kas Jesus, pasallod mga iya si mga ruma'-na ngan naggurubukan gihapon iya, sanglit gana' uras-na mga iya bisan si pagkakan. ");
INSERT INTO abx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ngan pakabati'-na sinan si kaburugtu'an-na si Jesus, pamataliwan mga iya pag'ala' si iya, kay i pagkagasi-na mga iya nga akapay to. ");
INSERT INTO abx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aniya' si magpanggurubok ari mga paragturo' bala'od nga man Jerusalem ngan agpaminugad, “Agbawa-bawa-na iya si Beelsebul nga prinsipi-na si dimu'an mara'at espirito, sanglit akapapinda iya si mga mara'at espirito.” ");
INSERT INTO abx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sanglit, agban'u-na mga iya si Jesus pagtapit si iya, ngan agpaminugad-na, “Ga'i agpapinda-na si Satanas i mga kahuruwangan-na mara'at espirito.” ");
INSERT INTO abx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mangno agpa'untali'an-na mga iya si Jesus pina'agi sito mga isturya nga agtukoy si kamatu'uran: “Kon aniya' nasyon nga ag'urunay i mga a'a-na, sigurado nga ga'i to akatunggo. ");
INSERT INTO abx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngan da'inan may si pamilya, kon ag'urunay i mga sakup-na sito, sigurado nga ga'i to akatunggo. ");
INSERT INTO abx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kon agribildi mismo i mga kahuruwangan-na si Satanas, ngan agkaburulag mga iya, pinapa'i-na may pakatunggo si ginhadi'an-na? Ma'in ba' matapit na i katapusan-na? ");
INSERT INTO abx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kundi', yayto i kamatu'uran: Gana' makasallod si ruma'-na si adda makusog lalla pagtangkaw si garamitun-na. Pero kon aniya' mas makusog pa nga sagapus-na iya dahulo, sigurado sabawa-na i dimu'an inanna'-na si ruma'. ");
INSERT INTO abx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sumatan-ta kam si kamatu'uran, sapasaylu-na si Diyos i dimu'an sala'-na si a'a, bisan pa i paglalabaw si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero bisan say i magparapakara'at si arun-na si Espirito Santo, ga'i na gayod apasaylo. Baratunun-nay nan sala' hasta si kahastahan.” ");
INSERT INTO abx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Agsumat-nay nan si Jesus tungod si katuyu'an-na mga iya pagpakara'at si Espirito Santo pina'agi si pagpinugad nga nagbawa-bawa dina iya si mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Siray uras anakka i nana-na pati' i mga bugtu'-na lalla si Jesus. Agparapanunggo mga iya si gawas ngan aniya' naglihug-na mga iya pasallod si ruma' pagban'o si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Agtingkulo' palibot si iya i magpanggubok. Mangno akasumatan si Jesus, “Awiray si gawas i nana-mo huwang i mga bugtu'-mo ngan agpara'anda'-na kaw.” ");
INSERT INTO abx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Amatilaw dina iya, “Sakatu'anan-bi ba' kon kas say i nanay-ko pati' i mga bugtu'-ko?” ");
INSERT INTO abx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mangno agdiritso amahalling si mga magpaningkulo' palibot si iya, “Atiya' si ka'am i nana-ko pati' i kabugtu'an-ko! ");
INSERT INTO abx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kay bisan say i magtuman si katuyu'an-na si Diyos, mga iya dina i kabugtu'an-ko pati' nana-ko.” ");
INSERT INTO abx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kahuman si pira allaw agtikang gihapon si Jesus pagturo' ari si bihing-na si danaw. Mangno tungod si kalabbat-na si magpanggubok si iya, pasang'at iya si adda paraw ngan aningkulo' kahuman pagpatukal-tukal sinan pan kalaluman yungod si pagtiriripunan-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Agpadayon iya si pagturo' si mga iya pala'in-la'in pina'agi si mga isturya nga agtukoy si kamatu'uran. Yayto i adda si nagpanturu'-na: ");
INSERT INTO abx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Amati'a kam! Aniya' para'uma nga patakod basi' agsaburak. ");
INSERT INTO abx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Si pagsaburak-na si uma-na, aniya' mga gahi' nga aka'anna' dina si lalan ngan agpamadugok i mga manuk-manok pagtuktok. ");
INSERT INTO abx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aniya' liwat mga gahi' nga aka'anna' dina si mga malambo bato nga manipis hamok i pitak-na si dyata'. Sanglit tulos to anudok tungod si kanipis-na si pitak. ");
INSERT INTO abx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero ngan pamanas-na si allaw, alayong to dayon mga tinanom ngan a'uga tungod kay kulang i kalanga-na si mga gamut-na. ");
INSERT INTO abx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aniya' liwat mga gahi' nga aka'anna' dina si pitak nga aniya' pa mabilin mga gamut-na si simpot. Sanglit ngan panuduk-na si simpot, agsuputan-na dina si simpot i mga tinanom hasta nga ga'i akabuwa'. ");
INSERT INTO abx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero aniya' may liwat mga gahi' nga aka'anna' si mahalap pitak. Sanglit mahalap i panuduk-na, anhaya ngan amuwa'. Aniya' sito mga mahalap pitak nga i kutsitsa-na agtraynta dubli kuntra si nagpasaburak, aniya' may magsaysinta, ngan aniya' may mag'addahatos.” ");
INSERT INTO abx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Agtapus-na si Jesus i isturya-na si pagpinugad, “Si mga a'a makapamati', kunta' amati'!” ");
INSERT INTO abx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ngan kas Jesus na hamok i mabilin ari, agpamatilaw i ka'agsuban kahuruwang-huwang-na huwang si Dusi kon ay i tinago' karuyag sidngun-na si mga isturya-na. ");
INSERT INTO abx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Anaruman si Jesus, “Nagpumwan-na si ka'am i pagsabut-bi nga iya i nagparatago' siray, kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos, pero nagparatago' payto si mga ma'in pa angay papasakupon. Sanglit i mga isturya nga agtukoy si kamatu'uran i nagparagamit-ko ");
INSERT INTO abx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","basi' sigi hamok mga iya buruslungay, pero gana' mga sakulawan-na. Sigi hamok paramati'ay, pero gana' mga sasabutan-na. Kon ma'in da'inan sinan, abawa na kunta' mga iya pagtu'o si Diyos ngan apasaylo na kunta' mga iya.” ");
INSERT INTO abx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mangno aminugad si Jesus, “Kon ga'i kam anabot siray isturya, pinapa'i may pakasabut-bi si ditangnga' pa mga isturya nga agtukoy si kamatu'uran? ");
INSERT INTO abx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","I nagpasaburak-na si para'uma, iya i allingon. ");
INSERT INTO abx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aniya' mga a'a nga akapariho si lalan kon singnga aka'anna' to mga gahi'. Si uras pakapamati'-na mga iya, anakka dayon si Satanas ngan ag'ala'-na si mga iya i allingon nga nagpasaburak si mga inisipan-na. ");
INSERT INTO abx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aniya' may magpakapariho si mga malambo bato nga manipis hamok i pitak-na si dyata'. Si uras si pagpamati'-na, mga malipayon dayon mga iya pagkarawat si allingon. ");
INSERT INTO abx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero tungod kay mababaw hamok i gamot ato sito mga a'a, ma'in maliyat i pagti'us-na. Si panakka-na si mga kakurihan o ma'in ngani' si pagpasakit-na si la'in tungod si pagtutu'o si allingon, pa'amban dayon mga iya si mga pagtutu'u-na. ");
INSERT INTO abx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aniya' namay magpakapariho si pitak nga aniya' mga titudok simpot. Iyay nan i mga a'a nga akapamati' pahalap si allingon ");
INSERT INTO abx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero si katapus-tapusan agparasasallod si mga iya i kabaraka si pagpanginabuhi', i daya'on kalipayan-na si kayamanan hasta pa i dimu'an mga sasindakan-na. Iyay nan dimu'an i makapugong si pagtubu'-na si allingon, sanglit ga'i akabuwa'. ");
INSERT INTO abx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero aniya' mga a'a magpakapariho kamutangan si mahalap pitak. Agpakapamati' to si allingon ngan ag'aku'-nay to gayod, sanglit mahalap i pagbuwa'-na. Aniya' sito nga i kutsitsa-na si allingon agtraynta dubli, aniya' may magsaysinta, ngan aniya' may mag'addahatos.” ");
INSERT INTO abx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Agpadayun-na si Jesus i mga allingun-na, “Say i magsulsol lampara para hamok tambunan-na si adda batiya' o ma'in ngani' agpa'anna'-na dina si dilalum-na si katri? Lugod, agpa'anna'-nay to si tama' pamma'anna'an. ");
INSERT INTO abx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pariho si mga allingun-ko, bisan kon nagparatago' ina'anto, akaguwa' to gihapon ngan kinakulawan, ngan bisan kon nagparatambunan, abaway to si pangulawan-na si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si mga a'a makapamati', kunta' amati'!” ");
INSERT INTO abx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Agpinugad-na liwat mga iya, “Tuninungi-bi pahalap i mga sapamati'an-bi! Bisan ay i nagsukulan-bi, iya may i surukulan pagpabalik si ka'am nga aniya' pasubra-na. ");
INSERT INTO abx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bisan say i aniya', iya i binuwanan pa; pero bisan say i gana', hasta pa i diki'it tawa'-na, inala' pa tikang si iya.” ");
INSERT INTO abx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Agpadayon gihapon si Jesus pag'isturya, “I paghadi'-na si Diyos, akapariho sito: Aniya' lalla magpasaburak si gahi'-na. ");
INSERT INTO abx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bisan kon i nagpanginanu-na hamok i ka'agsuban buhat-na allaw sangom, agpadayon i pagtuduk-na ngan sigi tutubo' i mga tinanum-na. Pero ga'i iya akatu'anan kon pinapa'i nan ahimo. ");
INSERT INTO abx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","I pitak mismo i magpahaya si mga tinanom basi' amuwa'. Si primiro anudok, mangno anubo', ngan si katapusan, iya i pagbuwa'-na. ");
INSERT INTO abx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngan kon matahak na i buwa'-na, sa'asyab-na na kay uras na si pag'ani.” ");
INSERT INTO abx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Agpatilaw si Jesus, “Ay pa ba' i pinakumpararan-ko si paghadi'-na si Diyos? Ay pa ba' isturyaha nga agtukoy si kamatu'uran i garamitun-ko pag'isplikar sito? ");
INSERT INTO abx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Akapariho si lisu-na si tinanom mustad, nga iya i pinakamadiki' liso si kalibutan nga satanum-bi. ");
INSERT INTO abx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero kon anubo' to liso, iya i adda pinakamahaya si dimu'an tinanom. Aniya' sito mamahaya sanga-na nga pwidi sa'ansalahan-na si mga manuk-manok.” ");
INSERT INTO abx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Malabbat pa purupariho sito mga isturya nga agtukoy si kamatu'uran i naggamit-na si Jesus pagpasamwak si allingun-na tubtob si sakaya-na mga iya pagsabot. ");
INSERT INTO abx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gana' pinahallingan-na nga ga'i aggamitan-na sito klasi mga isturya; pero ngan mga iya na hamok si mga inadalan-na, ag'isplikar iya si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ngan kasanguman sinan mismo allaw, agpinugad-na si Jesus i mga inadalan-na, “Patalabok kita kam pan dambila'.” ");
INSERT INTO abx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sanglit, pa'amban mga iya si kalabbatan. Pamasang'at i mga inadalan-na ari si paraw nga ari andang si Jesus, ngan agpamataliwan. Aniya' liwat mga la'in paraw magpamaya' si mga biyahi-na. ");
INSERT INTO abx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kata'ud-ta'uran, hintak angusog i bariyo, amuk'ay i mga mahaya alon nga salakay-na i paraw hasta nga mapapannu'on to. ");
INSERT INTO abx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero mahalap dina i pamaturi-na si Jesus nga di'ulunan pa gayod ari si ulin-na si paraw. Sanglit agpukaw-na iya si mga inadalan-na ngan agpamatilaw si iya, “Ma'istro, ga'i ba' kaw agmalasakit si kami'? Matutulluron na kita kam!” ");
INSERT INTO abx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Anunggo si Jesus ngan pugung-na i bariyo, “Pahuwaya!” ngan agmandaran-na liwat i mga alon, “Anlinawa!” Angalma i bariyo ngan hintak anlinaw. ");
INSERT INTO abx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mangno pinugad-na si Jesus i mga inadalan-na, “Ay kay agkataralaw kam? Ga'i pa ba' kam hamok gihapon agtapod?” ");
INSERT INTO abx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bali haya i katalaw-na mga iya bawa i pag'usa ngan agsipurupatilaway, “Ay ba' to iya? Bisan i bariyo pati' i mga alon agpansunod si iya!” ");
INSERT INTO abx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ga'i agliyat, anakka kas Jesus si dambila'-na si danaw, ari si lugar-na si mga Gerasenes. ");
INSERT INTO abx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Pasalta-na si Jesus si paraw, aniya' dayon sapantawan-na lalla nga pagawas pa hamok tikang si adda si mga kwiba panlalabbungan kon singnga iya agpara'istar. Nagbawa-baway nan si mga mara'at espirito ngan gana' makagapos si iya bisan pa kadina. ");
INSERT INTO abx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pirmi na nagparagapos i tamburu'-na pati' i kitid-na pero parapuknut-na hamok ngan agparabuka-na i pu'un-na si kadina ari si kitid-na. Gana' makapugong si iya tungod si kakusug-na. ");
INSERT INTO abx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allaw sangom, sigi hamok iya layaw-layaw ari si mga panlalabbungan pati' si mga katagudturan, nga sigi hamok turakaw ngan para'unay-na agsamad si bato i puhu'-na. ");
INSERT INTO abx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ngan pakakulaw-na may si lalla si Jesus ari si katalahan, alahi iya pagtupo' ngan anluhod atubang sito ");
INSERT INTO abx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","huwang i pagturakaw, “Ay i tuyu'-mo si ako, Jesus, Dadi'-na si Gilalabawi Diyos? Agsumpa'a si Diyos nga ga'i ako agpasakitan-mo!” ");
INSERT INTO abx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akapinugad iya sinan tungod si pagmandar-na si Jesus, “Hoy! Ka'aw, yawa' kaw, pa'ambana anan si puhu'-na!” ");
INSERT INTO abx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mangno agtilaw-na iya si Jesus, “Say i arun-mo?” Anaruman may i lalla, “Kalabbatan. Iyay nan i arun-ko, kay bali kami' labbat!” ");
INSERT INTO abx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mangno sigi hamok iya pakimalu'oy si Jesus nga ga'i pagtabrog si mga mara'at espirito pagawas siray lugar. ");
INSERT INTO abx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aniya' magtarambak kabaktinan matapit ari nga agparapamu'ad si bihing-na si tagudtod. ");
INSERT INTO abx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Agparapakimalu'oy i mga mara'at espirito si Jesus, “Pabawahon kami' pada'iray si kabaktinan ray ngan tugutin kami' nga akabalyo si mga puhu'-na.” ");
INSERT INTO abx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sanglit agtugutan-na mga iya. Pamaguwa' i mga mara'at espirito ngan diritso pamabalyo si kabaktinan. Mangno palahi i bug'os grupo, mga dos mil dimu'an, pada'iray si pangpang diritso si buwahi' ngan agkaralimbo. ");
INSERT INTO abx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pamalahi i mga magpangataman si kabaktinan pan syudad hasta si katahuk-tahukan ngan agpamakatu'an nga aniya' hinabo'. Sanglit agpamada'iray i mga a'a pagpanginsayod. ");
INSERT INTO abx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngan panakka-na mga iya ari si Jesus, sakulawan-na mga iya i lalla nga ga'i na nagbawa-bawa si kalabbatan mara'at espirito. Agparatingkulo' to, aniya' na badu'-na, ngan mahalap na gayod i paminsada-na. Ngan tungod sinan, bali mga katalaw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Padayon pagpasayod i mga magpakakulaw si ungod hinabo' kon pinapa'i anhalap i nagbawa-bawa ngan kon pinapa'i apirwisyo i mga baktin-na. ");
INSERT INTO abx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sanglit agtikangan-na si mga a'a pagpakimalu'oy si Jesus nga kon pwidi pa'amban iya si mga lugar-na. ");
INSERT INTO abx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ngan panakay-na si Jesus si paraw, makimalu'oy i nagbawa-bawa, “Pwidi ba' ako sapabaya'-mo?” ");
INSERT INTO abx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero andiri' si Jesus. Agpinugad-nay to dina, “Agbalika na si mga kaburugtu'an-mo ngan sumatin mga iya si mahaya nagbuhat-na si Paragdalom para si ka'aw, ngan sumatin liwat si kalu'uy-na si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sanglit pa'amban i lalla ngan aglibut-na i bug'os lugar nga sakop si Awatong Syudad. Parapasamwak-na i mahaya nagbuhat-na si Jesus para si iya, ngan ag'usa gayod i dimu'an magpakapamati'. ");
INSERT INTO abx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pakatba gihapon kas Jesus pagbalik pan dambila', ngan bali namay labbat i magpantarambak ari si baybayon. ");
INSERT INTO abx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kata'ud-ta'uran aniya' manakka nag'arunan Jairo nga addangan si mga punu'-na si sinaguga. Pa'akkom dayon iya si kitiran-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Agparapakimalu'oy gayod iya, “Agmasakit na i dadi'-ko danda! Alayon, baya'on ako ngan du'unin iya si mga palat-mo basi' anhalap ngan anlanga pa i kinabuhi'-na.” ");
INSERT INTO abx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Amaya' si Jesus si iya. Amaya' liwat i ka'aha'an si mga iya ngan nagparasaligsigan iya. ");
INSERT INTO abx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aniya' danda ari nga agparalalaha' dusi na ta'on. ");
INSERT INTO abx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bisan kon bali iya kapapabulong ngan tibos na i kwarta-na si kapapaduktor, ga'i pahuway i pag'antus-na. Imbis nga anhalap, agrara'at may dina. ");
INSERT INTO abx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Akapamati' iya mahi'unong si Jesus, sanglit amungyod iya si kalabbatan ngan sigi gayod iya susuksok para hamok akatapit si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aka'anna' si huna'-huna'-na si danda, “Kon sasaphid-ko bisan hamok i badu'-na, sigurado anhalap ako.” ");
INSERT INTO abx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pakasaphid-na si sidsid-na si badu'-na, pahuway dagos i pagdaras-na si laha'-na. Sa'abat-na dayon i puhu'-na nga libri na si nagpara'antus-na. ");
INSERT INTO abx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aka'abat dayon si Jesus si kalugaringun-na mismo nga abantad i gahum-na pagpahalap, sanglit anili' iya si mga a'a ngan amatilaw, “Say i makasaphid si badu'-ko?” ");
INSERT INTO abx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anaruman may i mga inadalan-na, “Sakulawan-mo may i magparapanaligsig si kita kam. Ay kay amatilaw pa kaw gihapon kon say i makasaphid si badu'-mo?” ");
INSERT INTO abx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero sigi pamuraw-puraw si Jesus pag'anda' kon say gayod i magbuhat. ");
INSERT INTO abx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mangno padugok i danda si Jesus kay sakatu'anan-na may i mahinabo' si iya. Pa'akkom iya si kitiran-na si Jesus ngan agkurug-kudog iya pagsumat si kamatu'uran tungod si kulba-na. ");
INSERT INTO abx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aminugad si Jesus, “Mana, i pagtutu'u-mo, iya i makapahalap si ka'aw. Murayaw pa kunta' i kamutangan-mo kay libri na kaw si nag'abat-mo.” ");
INSERT INTO abx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Si pagparapahalling-na pa si Jesus, aniya' magpanakka tikang si ruma'-na si Jairo, i punu'-na si sinaguga, ngan agpanumat mga iya, “Minatay na i dadi'-mo. Gana' na pulus-na si pagpara'ulang-mo si ma'istroy nan.” ");
INSERT INTO abx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Akapamati' si Jesus, pero agpakangbungul-bungol hamok iya ngan agsumatan-na i puno', “Dakaw abaraka, anutu'uha hamok.” ");
INSERT INTO abx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mangno agpinahan-na i mga a'a pagbaya' si mga iya pwira na kas Pedro pati' i magdingsirarihan, Santiago pati' Juan. ");
INSERT INTO abx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ngan panakka-na kas Jesus ari si ruma'-na si puno', sakulawan-na mga iya i kasamukan-na si mga paradinamag ngan sapamati'an-na mga iya i mga tinurakaw-na. ");
INSERT INTO abx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pasallod mga iya ngan agsimul-na si Jesus i mga parapandinamag, “Ay ba' to kasamukana? Dakam agparapandinamag! Ma'in pa iya gayod i kamatayun-na si dadi'. Yayto kamatayon, pariho hamok si magpaturi.” ");
INSERT INTO abx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nagpattawahan dina si Jesus si mga a'a, sanglit agpagawas-na mga iya dimu'an. Mangno, ag'agda-na i tatay-na pati' i nanay-na si dadi', hasta i tallungan inadalan-na, ngan pasallod mga iya si kwarto naglibbakan-na si dadi'. ");
INSERT INTO abx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Agbikyaw-na i tamburu'-na si dadi' ngan aminugad, “Talitha, koum!” nga i kahulugan-na, “Ni', agsumatan-ta kaw, pabanguna!” ");
INSERT INTO abx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pabangon diritso i dadi' nga dusi anyos i idad-na ngan agparalalangngan ari si kwarto, sanglit nginarat mga iya. ");
INSERT INTO abx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Katapos agtugon si mga iya si Jesus nga ga'i pagparasumat si la'in a'a. Ngan agpinugad-na liwat mga iya, “Buwani-bi iya karakanon.” ");
INSERT INTO abx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pa'amban si Jesus siray lugar ngan agbalik iya si tinubu'an-na baryo, huwang i mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Si Allaw Pandidiskanso, agtikang iya pagturo' si sinaguga ari. Matabbol si mga magpakapamati' si mga allingun-na nga ag'usa gayod. Agsipurupatilaway mga iya, “Singngay to a'a agpara'inala' sito dimu'an? Pambihira i kadunung-na. Pinapa'i iya akahimo sito mga makagagahom binuhatan? ");
INSERT INTO abx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma'in ba' iya i panday nga dadi'-na si Maria? Ma'in ba' iya i bugtu'-na kas Santiago, Joset, Judas, pati' si Simon? Ma'in ba' atiya' pa ato i mga bugtu'-na danda sinan?” Sanglit, agdiri'-na gayod mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aminugad may si Jesus si mga iya, “Nagdayaw gayod si bisan singnga i paragsumat-na si Diyos pwira na hamok si kalugaringun-na lugar, si mga kaburugtu'an-na, hasta pa si kalugaringun-na pamilya.” ");
INSERT INTO abx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sanglit, ga'i iya akahimo si mga makagagahom binuhatan ari pwira na si pagbulong si diki'it mga maburong pina'agi si pagpadu'on si mga palat-na. ");
INSERT INTO abx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ngan mahaya gayod i pag'usa-na si Jesus tungod si kadiki'it-na si mga a'a magtapod si iya. Mangno, aglibot si Jesus si mga kaburubaryuhan ngan agparaturo' si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Katapos agtiripun-na i Dusi ngan aglihug-na mga iya paglibot si mga lugar saduwang-duwangay ngan agpamuwanan-na gahom pagpapinda si mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yayto i mga tugun-na si mga iya: “Dakam agbawa bisan ay si mga langngan-bi pwira na si mga bastun-bi, gana' karakanon, gana' bag, ngan gana' kwarta si rilos. ");
INSERT INTO abx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Agsandalyasa kam hamok ngan dakam agbawa pagsalinan.” ");
INSERT INTO abx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Agsumatan-na liwat mga iya, “Bisan singnga kam nagkarawat pag'istar, dakam palalin si la'in ruma' tubtob nga pamataliwan kam sinan bungto. ");
INSERT INTO abx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kon anakka kam si adda lugar nga ga'i kam nagpanginano si mga a'a o ma'in ngani' ga'i kam nagpakalihan, pataliwana kam sinan lugar ngan paspasu-bi i alpug-na si kitid-bi pagpakatu'an nga gana' na baratunun-bi si mga iya.” ");
INSERT INTO abx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mangno pataliwan mga iya ngan agparapanwali nga kinahanglan i a'a agbasol huwang si pagbag'o. ");
INSERT INTO abx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Malabbat mara'at espirito i sapapinda-na mga iya ngan malabbat liwat mga maburong i nagpamu'bu'an-na lana basi' anhalap. ");
INSERT INTO abx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mangno aka'aning'ing si Hadi' Herodes si dimu'an mahi'unong sinan, kay abantog na si Jesus. Aniya' magpaminugad, “Sigurado nga iya si Juan Paragbunyag nga abanhaw, sanglit akakaya iya pagpakulaw sinan mga pambihira gahom.” ");
INSERT INTO abx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aniya' liwat magpaminugad, “Iya si Elias nga agbwilta na pagtuman si sa'ad!” Ngan i ditangnga' may agpaminugad, “Paragsumat-na iya si Diyos nga akapariho si mga paragsumat siray mga panahon.” ");
INSERT INTO abx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngan pakapamati'-na si Herodes sinan mga pinahallingan, aka'anna' dagos si inisipan-na, “Sigurado, iya si Juan Paragbunyag! Agpapugutan-ko iya siray, pero abanhaw!” ");
INSERT INTO abx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Maliyat na panahon, agparasumatan-na si Juan si Herodes, “Supak si bala'od i pagtig'ub-mo si alla-na si sirari-mo.” Sanglit si Herodes mismo i magpadakop si Juan. Agpakadinahan-nay to ari si prisuhan. Agbuhat-nay nan si Herodes tungod si Herodias nga nagpakasalan-na bisan kon bayaw-nay to. Dati to alla-na si sirari-na nag'arunan Felipe. ");
INSERT INTO abx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tungod sinan, aghumutan-na si Herodias si Juan ngan aruyag kunta' iya pagpamatay sito pero ga'i iya akahimo tungod ");
INSERT INTO abx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kay aniya' katahap-na si Herodes si Juan ngan agpara'apinan-nay to dina kay sakilala-na nga matadong to ngan sagrado a'a. Awili iya pagpamati' si mga allingun-na si Juan, bisan kon agduwa pirmi iya isip si kada pagpakali-na. ");
INSERT INTO abx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Si katapusan, anakka i nagpara'antahak-na gayod uras si Herodias pagpamatay si Juan, nga iya i pagsilibrar si kumpli'anyu-na si Herodes. Agpapakan si Herodes para si dimu'an punu'an si gubyirno, si militar, huwang na i mga mahaya a'a si Galilea. ");
INSERT INTO abx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Si pagkarakanay na, pasallod i dadi'-na danda si Herodias ngan agsayaw iya nga gana' kapadis-na. Alipay gayod kas Herodes pati' i mga bisita-na si sayaw-na. Sanglit agsa'aran-na iya si Herodes, “Ay i pinalaku-mo, Ni'? Buwanan-ta kaw bisan ay i karuyag-mo!” ");
INSERT INTO abx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ngan huwang si sa'ad-na agsumpa' iya, “Pumwan-ko si ka'aw bisan ay i pinalaku-mo, bisan i katunga' pa si ginhadi'an-ko.” ");
INSERT INTO abx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sanglit pagawas i durudangkanda ngan amatilaw iya si nanay-na, “Nay, ay i pinalaku-ko?” Anaruman may i nanay, “I takuluk-na si Juan Paragbunyag.” ");
INSERT INTO abx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Padugok dayon i durudangkanda pada'iray si hadi' ngan amalako iya, “I karuyag-ko nga pumwan-mo dayon si ako ina'anto si adda bandihado i takuluk-na si Juan Paragbunyag!” ");
INSERT INTO abx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Akapabido' to gayod si hadi', pero ga'i iya akadiri' tungod si mga sa'ad-na nga sapamati'an-na si mga bisita. ");
INSERT INTO abx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sanglit, aglihug-na i paragmatay-na pag'ala' si takuluk-na si Juan. Pa'amban dayon i naglihug-na ngan agpugutan-na si Juan ari si prisuhan. ");
INSERT INTO abx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mangno nagbaway to si bandihado pada'iray si durudangkanda, katapos, iya na i magpumwan sito si nanay-na. ");
INSERT INTO abx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngan pakapamati'-na sinan si mga inadalan-na si Juan, agpamada'iray mga iya pag'ala' si bangkay-na basi' ahulid si adda kwiba panlalabbungan. ");
INSERT INTO abx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngan pabwilta-na si mga apostol pagbaya' gihapon si Jesus, kahuman si pagpanlibut-na, agsumat mga iya si dimu'an binuhatan-na pati' si mga saturu'-na. ");
INSERT INTO abx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bali labbat i mga a'a nga sigi hamok tarakkahay ngan sigi taraliwanay hasta nga gana' na gayod uras-na kas Jesus pati' si mga inadalan-na bisan si pagkakan. Sanglit agpinugad-na si Jesus i mga inadalan-na, “Tana kam pamada'iray si adda mamingaw lugar basi' akadiskanso may kam.” ");
INSERT INTO abx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sanglit mga iya hamok kas Jesus mamanakay si paraw pagpada'iray si mamingaw lugar. ");
INSERT INTO abx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero malabbat i makakilala si mga iya nga agpakakulaw si mga pataliwan-na. Yaynan mga a'a agpanlalahi pagpangagda si mga kaburubungtuhan ngan agpandahulo mga iya pada'iray si mga tarakkahan-na kas Jesus pati' si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ngan pasalta-na si Jesus si paraw, sakulawan-nay to kalabbatan to magpantarambak ngan alu'oy gayod iya, kay day pariho mga iya si mga karniro nga gana' mangngataman. Sanglit maliyat gayod i pagturu'-na sito mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngan pagsasaray-na na si allaw, padugok si Jesus i mga inadalan-na ngan agpaminugad, “Kuhap na, ngan mamingaw liwat to lugar. ");
INSERT INTO abx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pamalitirahon naynan mga a'a basi' agpakapada'iray na mga iya si mamatapit baryo pati' katahuk-tahukan ngan agpakaballi si mga karakanun-na.” ");
INSERT INTO abx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero anaruman dina iya, “Ka'am na hamok mamuwan karakanon si mga iya.” Anaruman may mga iya, “Ay? Aruyag ba' kaw nga palangngan kami' pagballi pan para hamok pinumwan si mga iya? Agkinahanglan kita malabbat kwarta, mga dos syintos dinari diplata!” ");
INSERT INTO abx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Amatilaw gihapon si Jesus, “Pira pa bug'os pan-bi nan? Kulawi-bi daw.” Ngan pakakatu'an-na mga iya, agsumatan-na mga iya si Jesus, “Lima nayto hamok pati' duwa liwat agon.” ");
INSERT INTO abx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mangno agmandaran-na si Jesus i mga inadalan-na pagpamalumpagi' si mga a'a grupu-grupo si kagabunan. ");
INSERT INTO abx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sanglit agpanlumpagi' i mga a'a, ngan aniya' mga grupo magsa'uru'addahatos pati' aniya' magsasurusingkwinta. ");
INSERT INTO abx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Katapos, ag'ala'-na si Jesus i lima bug'os pan pati' i duwa agon. Anhangad iya ngan agpasalamat si Diyos. Mangno agpanurutabbi'-na ngan agpumwan-nay to si mga inadalan-na pagtaltag si mga a'a. Agpuruparti-na liwat i duwa agon si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Agpakakakan i dimu'an ngan agpakagustuhan. ");
INSERT INTO abx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Katapos akatipon pa dina i mga inadalan dusi sagad nga puro panno' si tinurutabbi' la'a pati' si agon. ");
INSERT INTO abx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bisan i mga lalla hamok magpakakakan siray allaw anakka si singko mil. ");
INSERT INTO abx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Agpasakay-na dayon si Jesus i mga inadalan-na si paraw basi' akadahulo mga iya pagbalik si syudad Betsaida, myintras nga agparapalitira pa iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Katapos si pagpataliwan-na si mga iya, pada'iray si Jesus si adda tagudtod pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ngan kasanguman, anakka si tangnga'-na si danaw i paraw ngan agsulu-sulo na hamok si Jesus si hubas. ");
INSERT INTO abx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sakulawan-na nga nagkurihan i mga inadalan-na pagliyu-liyo kay sungsong mga iya si bariyo. Sanglit kamananalungan, bukud-na i mga inadalan-na nga aglalangngan hamok si buwahi'. Pero pakalabay-na kunta', ");
INSERT INTO abx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","sakulawan-na si mga inadalan-na nga agparalalangngan iya si buwahi', ngan pagkagasi-na mga iya nga kalag i mga sakulawan-na. Agpakaturakaw mga iya ");
INSERT INTO abx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tungod kay mga iya dimu'an akakulaw, ngan bali gayod i mga katalaw-na. Pero aminugad dayon si Jesus, “Dakam atalaw, akoy to! Agsariga kam hamok.” ");
INSERT INTO abx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pakasang'at-na si Jesus si paraw, angalma dayon i bariyo. Ag'usa gayod i mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kunta' ga'i mga iya agda'inan sinan, pero hasta i mahinabo' si pan ga'i pa liwat sasantup-na mga iya kay ga'i pa mga iya aka'isip malalom. ");
INSERT INTO abx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pakatalabuk-na mga iya si danaw, padu'ong mga iya si adda lugar nga sakop si Genesaret ngan ari agpa'ingkut-na i mga paraw-na. ");
INSERT INTO abx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Si pamasalta-na mga iya si paraw, sakilala-na dayon si mga a'a si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sanglit agpatugon dayon i mga sunsari'i paglahi pada'iray si kaburubaryuhan basi' sabayawan-na mga iya si tipo i mga maburong pagbawa kon singnga na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bisan palingnga si Jesus, si kaburubungtuhan, kaburubaryuhan o katahuk-tahukan, sigi barawahay i mga a'a si mga maburung-na ari si mga mirkado. Agparapakimalu'oy mga iya nga kon pwidi agpakasaphid i mga maburong bisan i sidsid-na hamok si badu'-na, ngan agpanhalap i dimu'an makasaphid. ");
INSERT INTO abx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naggurubukan si Jesus si mga Parisiyo huwang si ditangnga' mga paragturo' bala'od nga man Jerusalem. ");
INSERT INTO abx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sakulawan-na sito mga a'a nga aniya' si mga inadalan-na si Jesus nga agkakan ma'in limpyado i mga tamburu'-na, nga i nagtukoy, iya i ga'i pagkusu'-na mga iya ");
INSERT INTO abx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","sigon si minuklatan-na mga iya tuluhu'an. Gana' si mga Hebro magkakan kon ga'i dahulo agkuso' si tama' pa'agi labihan na i mga Parisiyo. ");
INSERT INTO abx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ngan kon tikang gayod mga iya si mirkado, ga'i mga iya agpamangan hasta nga ga'i dahulo agpamandi. Ngan agsunod mga iya malabbat pa mga pala'in-la'in rilihuso kabatasanan, pariho si tama' pa'agi paghugas si baso, pitsil pati' kaldiro. ");
INSERT INTO abx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sanglit, agriklamo ari si Jesus i mga Parisiyo pati' i mga paragturo' bala'od, “Apa'i may kay ga'i agkiwa i mga inadalan-mo sigon si minuklatan-ta kam tuluhu'an? Myintras agpamangan, gana' si mga iya magkuso' si tama' pa'agi.” ");
INSERT INTO abx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Anaruman dina si Jesus, “Tama' gayod i makigpasumat-na andang si Diyos si Isaias mahi'unong si ka'am nga mga parapamakunu-kuno nga mga rilihuso. Aka'anna' si Kasuratan: Yayto mga a'a, agpa'unrahan-na ako pina'agi si mga allingun-na, pero la'in dina i mga sabarawan-na. ");
INSERT INTO abx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gana' gayod kapulsanan-na si mga pag'ampu'-na si ako, kay i mga tuluhu'an nagturu'-na mga iya, mga hinimu-himu-na hamok kasugu'an si a'a. ");
INSERT INTO abx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aglabbahan-bi i mga kasugu'an-na si Diyos para hamok satagalan-bi pahalap i mga hinimu-himu-na si a'a.” ");
INSERT INTO abx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Agpadayon pagpahalling si Jesus, “Mga madunong kam si pa'agi-bi pagdiri' si kasugu'an-na si Diyos para hamok asunod i mga kabatasanan-bi! ");
INSERT INTO abx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Halimbawa' si mandu'-na si Moises, ‘Tahurin i tatay-mo pati' i nanay-mo,’ ngan aniya' liwat, ‘Bisan say i magmaldisyon si tatay-na o nanay-na, kinahanglan iya amatay.’ ");
INSERT INTO abx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero agturo' kam dina nga ma'in kinahanglan pagbulig si mga mahanak, ngan kon aniya' inanna'-na si addangan, pwidi iya akapasangil si pagpinugad, ‘Korban to,’ nga i kahulugan-na, ‘Tawa'-nay to si Diyos.’ ");
INSERT INTO abx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kon da'inan sinan, ga'i iya agtugutan-bi pagbulig si tatay-na pati' nanay-na. ");
INSERT INTO abx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kon sugad, agpara'-bi i gahum-na si allingun-na si Diyos pina'agi si nagpapasa-bi mga kabatasanan. Ngan malabbat pa liwat nagbuhat-bi nga pariho sito.” ");
INSERT INTO abx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mangno agban'u-na gihapon si Jesus i magpantarambak pagpadugok si iya ngan agpanumatan-na, “Amati'a kam dimu'an, ngan sabutu-bi to! ");
INSERT INTO abx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gana' gayod pasallod si puhu'-na si a'a nga akaparigsok si iya, kundi' i pagawas dina.” ");
INSERT INTO abx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kata'ud-ta'uran, pa'amban kas Jesus sito ka'aha'an. Ngan pakasallud-na na mga iya si ruma', amatilaw i mga inadalan-na hi'unong sinan isturya nga agtukoy si kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Anaruman si Jesus, “Mga maluya pa kam gayod! Ga'i pa ba' kam gihapon agpakasabot? Gana' gayod pasallod si puhu'-na si a'a tikang si mga nagkakan-na nga akaparigsok sinan a'a ");
INSERT INTO abx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kay ga'i may akasallod si kina'iya-na, pero pasallod dina si battung-na ngan pagawas gihapon si puhu'-na.” Si pagpahalling-na sinan, agsumat si Jesus nga angay nagkakan i dimu'an karakanon. ");
INSERT INTO abx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mangno agpadayun-na i mga allingun-na si Jesus, “I pagawas si a'a, iya i makaparigsok si iya. ");
INSERT INTO abx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay tikang si kina'iya-na, man inisipan-na may liwat gayod, agtikang i pagbuhat si mga sala' pariho si mga mara'at inisipan, pag'ubay si bisan say hamok sasindakan-na, pagtangkaw, pagmatay, pagbisyo si pagdangallahan, ");
INSERT INTO abx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pagkabintahuso, pagtuyo' pagpasakit si la'in, pagdaya', mga malaw'ay binuhatan, ka'awa', paggutgot, pagdayaw mismo si kalugaringon, pati' ga'i paghuna'-huna' si mga titakka hinabo'. ");
INSERT INTO abx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyay nan dimu'an i mga mara'at binuhatan nga tikang si sallud-na si a'a ngan akaparigsok si iya.” ");
INSERT INTO abx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Katapos, pa'amban kas Jesus ari siray lugar ngan diritso pamada'iray si lugar nga sakup-na si syudad Tiro. Pamadiskanso mga iya si adda ruma' ngan aruyag kunta' si Jesus nga gana' makatu'anan kon singnga iya, pero ga'i pwidi atago' nga ari iya. ");
INSERT INTO abx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mala' ngani' kay aniya' danda ari makapamati' mahi'unong si Jesus sanglit pada'iray dayon iya kay aniya' dadi'-na danda nagbawa-bawa si mara'at espirito. Pa'akkom iya si kitiran-na ");
INSERT INTO abx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","bisan kon adday to iya Grika nga a'allom sallod si Fenicia nga nagtinagalan-na si Siria. Makimalu'oy iya si Jesus pagpapinda si mara'at espirito magbawa-bawa si dadi'-na. ");
INSERT INTO abx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero anaruman dina si Jesus, “Kinahanglan nga pinakakan dahulo i mga dadi'. Ma'in tama' pagsiyo si kinakan-na mga iya basi' apatapok hamok si mga ka'idu'an.” ");
INSERT INTO abx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Ungod nan, Sinyor,” lingun-na may si danda. “Pero bisan ngani' i mga ka'idu'an ari si dilalum-na si lamisa, agpakakakan gihapon si mga mu'mo' sataktak-na si mga dadi'!” ");
INSERT INTO abx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sanglit agsarumanan-na iya si Jesus, “Hala, tungod si saruman-mo akabalik na kaw si ka'am ray; pa'amban na ina'anto i mara'at espirito si dadi'-mo!” ");
INSERT INTO abx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agbalik i danda ngan sakatu'anan-na dayon nga ag'ambanan-na na dina si mara'at espirito i dadi'-na nga agparalibbak ari si mga katri-na. ");
INSERT INTO abx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Katapos, pa'amban kas Jesus si lugar nga sakop si Tiro ngan pa'agi mga iya si mga sakop si Sidon pati' si Awatong Syudad si pagbalik-na mga iya pan Danaw Galilea. ");
INSERT INTO abx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aniya' mga a'a magpamada'iray si Jesus nga agpamawa bungol lalla nga makuri gayod akayawit. Makimalu'oy to mga a'a si Jesus pagdu'on si lalla. ");
INSERT INTO abx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sanglit ag'agda-na si Jesus i lalla nga akabulag mga iya si magpanggubok ari. Agpasallud-na i mga tutturu'-na si Jesus si mga talinga-na si lalla, mangno anrukda' iya ngan ag'antanan-na i dalla'-na si lalla. ");
INSERT INTO abx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Katapos, anhangad iya, anhingasong malalom, ngan aminugad si Hebruhanon, “Ephphatha,” nga i kahulugan-na, “Angabriha!” ");
INSERT INTO abx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Akapamati' dayon i lalla ngan gana' na maka'ulang si dalla'-na sanglit anhalap dagos i pagpahalling-na. ");
INSERT INTO abx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Katapos, agtugunan-na si Jesus i dimu'an ari nga ga'i pagparasumat sito si la'in. Pero pariho si bisan singnga lugara, kon ay i kahugut-na si Jesus pagparadiri', iya may liwat dina i kapusukadu-na si mga a'a pagparasumat. ");
INSERT INTO abx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ngan ag'usa gayod i dimu'an makapamati' ngan agparapaminugad, “Mahalap gayod i dimu'an nagbuhat-na! Sapayawit-na bisan i ngula ngan sapapakali-na bisan i bungol!” ");
INSERT INTO abx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ga'i agliyat, bali namay labbat i magpanggubok si Jesus. Ngan gana' na mabilin si mga pagkakan-na, agban'u-na si Jesus i mga inadalan-na ngan agpaminugad-na, ");
INSERT INTO abx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Alu'oy ako sito mga a'a, kay tallo allaw na mga iya i pag'istar-na ato paghuwang si kita kam, sanglit akatibusan si mga balun-na. ");
INSERT INTO abx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kon palitira-ko mga iya pagpabalik nga mga linganto, sigurado nga aniya' si mga iya magkadirismayo si lalan, kay matala i nagpanlalangnganan-na si ditangnga' pagpada'ito.” ");
INSERT INTO abx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Amatilaw i mga inadalan-na, “Pero singnga may kita kam anganda' ato si kamingawan si kinahanglanon pan pammakakan?” ");
INSERT INTO abx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Pira pa bug'os pan-bi nan?” lingun-na si Jesus. Anaruman may mga iya, “Pito' nayto hamok.” ");
INSERT INTO abx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Agmandaran-na si Jesus i mga a'a paglumpagi'. Mangno ag'ala'-na i pito' bug'os pan, agpasalamat si Diyos, ngan agturutabbi'-na. Agpumwan-na si mga inadalan-na pagtaltag si mga a'a, ngan agpanbuhat-nay to. ");
INSERT INTO abx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aniya' pa mga iya diki'it mamadiki' agun-na. Agpasalamat liwat iya sito ngan agsumatan-na mga iya pagtaltag gihapon. ");
INSERT INTO abx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Agpakapamangan i dimu'an ngan agpakagustuhan. Katapos akatipon pa dina i mga inadalan-na pito' sagad nga puro panno' si mga tinurutabbi' la'a. ");
INSERT INTO abx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bisan i mga lalla hamok magpakakakan siray allaw anakka si mga kwatro mil. Pakapalitira-na si Jesus si mga a'a, ");
INSERT INTO abx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","pasang'at dagos iya si paraw, huwang i mga inadalan-na ngan agbiyahi pada'iray si lugar-na si mga Dalmanutano. ");
INSERT INTO abx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mangno, aniya' mga Parisiyo magpamada'iray si Jesus ngan nagpara'ulit-ukit iya huwang i pagpara'anda' pangngilalahan si langitnon kasiguruhan para si mga iya pagsiguro nga ungod gayod agka'adda mga iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Anhaguyhoy si Jesus ngan aminugad, “Apa'i may kay agparapanganda' mga a'ay to ina'anto panahon si pangngilalahan si langitnon kasiguruhan? Agsumatan-ta kam, gana' na parakulawon pangngilalahan si mga iya!” ");
INSERT INTO abx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sanglit patalikot kas Jesus si mga Parisiyo ngan pabwilta mga iya pan paraw ngan agtikang gihapon mga iya pagkatba pan dambila'. ");
INSERT INTO abx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sadiskubrihan-na si mga inadalan-na nga salimutan-na mga iya pagbawa pan, pwira na si adda hamok bug'os mabilin si paraw. ");
INSERT INTO abx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pero si Jesus namay, agpadayon pagturo' si mga iya pina'agi si pagpada'an, “Agmatuha kam! Agpanlikaya kam si pammatubu'-na si mga Parisiyo pati' i tawa'-na si Herodes.” ");
INSERT INTO abx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sanglit agsingurub-ngurubay dayon mga iya, “Sapahalling-na gad nan hamok kay gana' na pan-ta kam, ngan agkinahanglan pammatubo' paghimo.” ");
INSERT INTO abx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sakatu'anan-na andang si Jesus i mga bararagaw-na, sanglit agtilaw-na mga iya, “Ay kay agbararagawan-bi gayod i ga'i pakabawa-ta kam balon? Ga'i pa ba' kam hamok gihapon amuklat o agpakasantop? Agdiri' ba' kam pag'isip malalom? ");
INSERT INTO abx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aniya' mga mata-bi; ga'i ba' sakulawan-bi? Aniya' liwat mga talinga-bi; ga'i ba' sapamati'an-bi? Ga'i ba' sa'intuman-bi ");
INSERT INTO abx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kon pira pa dina sagad satipun-bi nga puro panno' si la'a-na si mga a'a ngan pagturutabbi'-ko si lima bug'os pan para si singko mil a'a?” Anaruman may mga iya, “Dusi.” ");
INSERT INTO abx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ngan pagturutabbi'-ko liwat si pito' bug'os para si kwatro mil a'a, pira pa dina sagad i satipun-bi nga puro panno' si mga la'a?” Anaruman mga iya, “Pito'.” ");
INSERT INTO abx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sanglit agtilaw-na mga iya si Jesus, “Tara', kapa'i may kay ga'i pa kam hamok gihapon agpakasantop?” ");
INSERT INTO abx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ngan panakka-na kas Jesus si syudad Betsaida, aniya' magpamawa buta lalla pada'iray si iya. Agpamakimalu'oy to si Jesus pagdu'on si nagbawa-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sanglit agpatuttut-na si Jesus i buta pagawas si syudad. Katapos agrukda' si Jesus panhirog si mga mata-na si buta. Agdu'unan-nay to si mga palat-na ngan amatilaw, “Aniya' na ba' sakulawan-mo?” ");
INSERT INTO abx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mamuraw-puraw i lalla ngan anaruman, “Oho', sakulawan-ko na i mga a'a, pero i pagkulaw-ko si mga iya day mga kakayuhan nga parapanlalangngan.” ");
INSERT INTO abx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agdu'unan-na gihapon si Jesus i mga mata-na si buta ngan anhalap dayon i pagkulaw-na nga bali na gayod kaklarado. ");
INSERT INTO abx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mangno agpabalik-na si Jesus i lalla ngan agtugunan-na, “Dakaw na pa'agi si syudad si pagbalik-mo si ka'am ray.” ");
INSERT INTO abx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Katapos, agpamada'iray-na kas Jesus pati' si mga inadalan-na i kaburubaryuhan nga sakop si bungto Cesarea Filipos. Si pagparalalangngan-na mga iya, amatilaw si Jesus, “Si mga burubaragaw-na si mga a'a, say may kuno' ako?” ");
INSERT INTO abx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Anaruman may mga iya, “Aniya' magpaminugad nga ka'aw kuno' si Juan Paragbunyag, ngan i ditangnga' may, ka'aw kuno' si Elias. Pero aniya' liwat magpaminugad nga tingali addangan pa kaw kuno' si mga paragsumat-na si Diyos siray.” ");
INSERT INTO abx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Amatilaw gihapon iya, “Pero para si ka'am, say may i pagkakilala-bi si ako?” Anaruman may si Pedro, “Ka'aw i Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Agtugunan-na mga iya si Jesus nga ga'i pagsumat si bisan say hi'unong si iya. ");
INSERT INTO abx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Katapos sinan, agtikangan-na si Jesus agturo' i mga inadalan-na, “Kinahanglan ag'agi pala'in-la'in kasakitan i Pinili' A'a ngan diriri'on iya si mga mata'o kamabu'utan, si mga puno' paraghalad, pati' si mga paragturo' bala'od. Pwira pa sinan, maratayon iya, pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Agpaklaru-nay nan gayod si mga inadalan-na, sanglit ag'agda-na iya si Pedro pabulag basi' sasu'it-na i amu-na. ");
INSERT INTO abx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero anili' dina si Jesus, buslung-na i ditangnga' mga inadalan-na, ngan ag'isugan-na si Pedro, “Ala'on nan si inisipan-mo, kay tawa'-nay nan si Satanas! Imbis nga i mga katuyu'an-na si Diyos i nagpanginanu-mo, i tawa'-na dina si a'a i nagpasi'urug-mo!” ");
INSERT INTO abx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kata'ud-ta'uran, agban'u-na si Jesus i magpantarambak ari pagtapit si iya, huwang i mga inadalan-na ngan agpanumatan-na, “Kon aniya' maruyag pagbaya' si ako, kinahanglan limut-na i mga kalugaringun-na katuyu'an, ngan agsunod si ako. Padayun-na i pag'ako' si mga pag'antus-na pariho si adda makamamalo' kamatayon si kudos. ");
INSERT INTO abx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kay bisan say i magpasiguro si kalugaringun-na kinabuhi' ina'anto, iya dina i tikarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero bisan say i magkarag si kalugaringun-na kinabuhi' para si ako pati' si mahalap sumat, iya dina i aniya' ungod kasiguruhan-na. ");
INSERT INTO abx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ay i kapulsanan-na kon satawa'-na si a'a i bug'os kalibutan pero agkaragan-nay to dina kinabuhi'? Gana'! ");
INSERT INTO abx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay gana' sapabayad-na si a'a nga sabawi'-nay nan gihapon kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Makasasala' gayod mga a'ay to ina'anto panahon, ngan makihuwang pa liwat mga iya si pala'in-la'in diyos. Sanglit, kon aniya' nga agkasipugan-na ako o ma'in ngani' i mga allingun-ko, karasipugan-na may liwat iya si Pinili' A'a si pagpada'itu-na nga nagsigahan na palibot si maka'angayan danta'-na si Tatay-na pati' si mga sagrado anghel.” ");
INSERT INTO abx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ngan agpadayon si Jesus si mga allingun-na, “Sumatan-ta kam si kamatu'uran, aniya' si mga satu'oy to ina'anto nga ga'i amatay tubtob nga ga'i pa mga iya sakulawan-na i katumanan-na si paghadi'-na si Diyos ato huwang si mahaya gahum-na.” ");
INSERT INTO abx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kahuman si annom allaw, ag'agda-na si Jesus kas Pedro, Santiago, pati' Juan paghuwang si iya nga mga iya hamok. Agdahulo iya pasagka si adda madyalta bukid. Ngan panakka-na na mga iya si buntay, si pagparakukulaw-na mga iya si Jesus, anla'in i puhu'-na. ");
INSERT INTO abx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amuti' nga bali suri'aw i badu'-na, anubra pa si kinulahan-na si bisan say parapu'pu'a si bug'os kalibutan i kaputi'an-na. ");
INSERT INTO abx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mangno sakulawan-na mga iya nga hintak pamaluwa' kas Elias pati' Moises ngan agbararagaw mga iya kas Jesus. ");
INSERT INTO abx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Agsupla-na si Pedro i mga baragaw-na kas Jesus si pagpinugad, “Rabbi, mahalap gayod kay atiya' kita kam. Anhimo kami' tallo payag-payag para si ka'am, i adda para si ka'aw, i adda may tawa'-na si Moises, ngan i adda namay tawa'-na si Elias.” ");
INSERT INTO abx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sapinugad-nay nan kay ga'i gayod iya akatu'anan kon ay i angay pinahalling-na tungod kay bali i kangarat-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mangno aniya' pahulwa' madakmol panganod ngan akatambunan mga iya sito. Aniya' busis tikang si panganod nga agpinugad, “Iyay nan i Dadi'-ko nga hinigugma'-ko. Amati'a kam si iya!” ");
INSERT INTO abx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mangno si pamuraw-puraw-na mga iya, gana' na mga sakulawan-na nga huwang si mga iya pwira na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ngan padalugdug-na na mga iya man bukid, agtugunan-na mga iya si Jesus nga ga'i pagparasumat si bisan say si mga sakulawan-na, tubtob nga abanhaw i Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sanglit aghilum-nay to hamok mga iya, ngan agbararagaw mga iya kon ay i karuyag sidngun-na si nagpinugad-na “abanhaw”. ");
INSERT INTO abx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Si kata'ud-ta'uran amatilaw mga iya si Jesus, “Apa'i may kay agparapaminugad i mga paragturo' bala'od nga kinahanglan dahulo i pagpada'itu-na si Elias?” ");
INSERT INTO abx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Anaruman si Jesus, “Ungod nan, kinahanglan pada'ito dahulo si Elias paghamis si dimu'an. Pero aniya' liwat maka'anna' si Kasuratan nga kinahanglan agsakit pala'in-la'in ngan nagdiri' i Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero sumatan-ta kam nga manatu'o na dina si Elias, ngan gana' maka'ulang si mga a'a pagbuhat si mga nagplanu-na karat'an para si iya. Sanglit atuman i maka'anna' si Kasuratan mahi'unong si iya.” ");
INSERT INTO abx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pabwilta-na mga iya ari si ditangnga' inadalan, sakulawan-na mga iya nga bali labbat i magpanggubok sito. Aniya' mga paragturo' bala'od magparapandiskusyon si mga iya. ");
INSERT INTO abx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Si pakakulaw-na si mga a'a si Jesus, agpangusa mga iya kay anakkay to ngan padugok mga iya pagpangumusta. ");
INSERT INTO abx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Amatilaw si Jesus, “Ay ba' nagparapandiskusyunan-bi nan?” ");
INSERT INTO abx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aniya' manaruman si magpanggubok, “Ma'istro, atiya' agbawa-ko i dadi'-ko lalla pada'ito si ka'aw, kay nagbawa-bawa iya mara'at espirito ngan ga'i iya agpayawit-na. ");
INSERT INTO abx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bisan sumiran to nagtagbo', pirmi iya akadusmog. Agbura' i bawa'-na, agkutom, ngan agtukog i bug'os puhu'-na. Agpalaku-ko kunta' si mga inadalan-mo pagpapinda si mara'at espirito, pero ga'i mga sahimu-na.” ");
INSERT INTO abx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Anaruman si Jesus, “Ay badaw! Ga'i pa gayod anutu'o mga a'ay to ina'anto panahon! Pira pa i kinahanglan pag'istar-ko ato pati' i irilubun-ko si ka'am basi' agpanutu'o kam? Bawahon iya ato!” ");
INSERT INTO abx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sanglit agbawa-na mga iya i dadi' pada'iray si Jesus. Pakakulaw-na si mara'at espirito si Jesus, tinakka i dadi' si buntug-na ngan atumba. Sigi ariwasa i dadi' ngan agbura' i bawa'-na. ");
INSERT INTO abx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Agtilaw-na si Jesus i tatay, “Ay na i kaliyat-na si pagparada'itu-na sito?” Anaruman may to, “Tikang pa gayod si kadadi'-na. ");
INSERT INTO abx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Simpira na gayod agpurbaran-na si mara'at espirito pagmatay si iya pina'agi si pagpasugba si api o ma'in ngani' pagparabbo' si buwahi'! Sanglit kon aniya' may dina sahimu-mo, alayon kalu'uyin kami' ngan buligin!” ");
INSERT INTO abx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Ay i paminugaran-mo nga kon aniya' sahimu-ko?” lingun-na si Jesus. “Gana' nga ga'i ahimo si a'a kon agtutu'o.” ");
INSERT INTO abx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Anaruman dagos i tata', “Aniya' pagtutu'u-ko, pero buligin ako nga salupig-ko i mga nagdudahan-ko pa!” ");
INSERT INTO abx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mangno sakulawan-na si Jesus nga sigi tatamba i maggurubok si mga iya, sanglit ag'isugan-na i makapangula pati' makapabungol espirito, “Agmandaran-ta kaw, pa'ambana si dadi' nan ngan dakaw na agbalik si iya!” ");
INSERT INTO abx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Anurakaw i mara'at espirito, agpakurug-kudug-na makusog, ngan pa'amban dayon si dadi'. Day minatay nayto nagkukulawan, sanglit matabbol i maminugad, “Minatay na iya!” ");
INSERT INTO abx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero antanan-na si Jesus i tamburu'-na basi' akabangon, ngan anunggoy to. ");
INSERT INTO abx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kahuman si pamasallud-na kas Jesus si adda ruma', amatilaw si iya i mga inadalan-na nga gana' la'in makapakali, “Apa'i may kay ga'i ray sapapinda kami' mara'at espirito?” ");
INSERT INTO abx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Anaruman may si Jesus, “Iyay ray i klasi-na si mara'at espirito nga apapinda hamok pina'agi si pag'ampo'.” ");
INSERT INTO abx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pa'amban kas Jesus sinan lugar ngan pa'agi mga iya si Galilea. Ga'i aruyag si Jesus nga kinatu'anan si mga a'a kon singnga mga iya ");
INSERT INTO abx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay agparaturu'an-na i mga inadalan-na sito: “Trarayduran i Pinili' A'a ngan papa'intrigahon iya si pagdalum-na si mga a'a. Matay-nay to mga iya, pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ga'i mga iya agpakasabot si karuyag sidngun-na sinan, ngan agkataralaw liwat pagpatilaw mahi'unong sinan. ");
INSERT INTO abx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anakka kas Jesus si syudad Capernaum. Ngan pasallud-na mga iya si mga ruma'-na, agpatilawan-na si Jesus i mga inadalan-na, “Ay ba' i nagparapandiskusyunan-bi ngan pagparalalangngan-tay to kam ina'an?” ");
INSERT INTO abx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gana' makasibo' si mga iya kay i nagparapandiskusyunan-na, iya i kon say i pinakabantugan si mga iya. ");
INSERT INTO abx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aningkulo' si Jesus nga ag'ararung-arungan-na iya si Dusi. Aminugad iya, “Bisan say i maruyag nga naghangad, kinahanglan iya agpa'ubos dina si kalugaringun-na basi' rilihugon iya si dimu'an.” ");
INSERT INTO abx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aniya' dadi' nagban'u-na si Jesus ngan agpatunggu-nay to atubang si mga iya. Mangno akbayan-na ngan aminugad, ");
INSERT INTO abx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bisan say i magpanginano pahalap si a'a nga ga'i mismo aka'allom si kalugaringun-na pariho sito dadi' tungod si gugma'-na si ako, agpanginano gayod si ako. Ngan bisan say i magpanginano si ako, ma'in hamok ako i nagpanginanu-na, pero hasta pa liwat i magpapada'ito si ako.” ");
INSERT INTO abx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Agsumatan-na si Juan si Jesus, “Ma'istro, aniya' lalla sakulawan kami' magparapapinda si mga mara'at espirito pina'agi si paggamit si arun-mo. Agsumatan kami' nga kinahanglan iya pahuway kay ma'in iya huwang si kita kam.” ");
INSERT INTO abx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Anaruman may si Jesus, “Dakam nan a'a agsimulu-bi, kay gana' makapara'at si arun-ko si titakka mga allaw kon akahimo iya makagagahom binuhatan pina'agi si arun-ko. ");
INSERT INTO abx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kay bisan say i ga'i manguntra si kita kam, huwang may iya si kita kam. ");
INSERT INTO abx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sumatan-ta kam si kamatu'uran, bisan say magpa'inom si ka'am adda baso buwahi' tungod kay sakop kam si Kristo, sigurado gayod ga'i arungay i primyo nagtagama si iya. ");
INSERT INTO abx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mara'at gayod si a'a kon nagpa'ingkutan i kallung-na gilingan bato ngan nagtunura si kalawot. Pero bisan kon mara'at to, mas mahalap payto kuntra kon akapa'amban iya si la'in nga baha'o pa hamok magtutu'o. ");
INSERT INTO abx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pariho kon akapa'amban si pagtutu'u-mo i nagparahimu-na si tamburu'-mo, uturon! Mas mahalap pa kon punggol i tamburu'-mo nga akaprubitso kaw si gana' katapusan-na kinabuhi', kuntra kon huwang si ka'aw i duwa tamburu'-mo nga akapan'impyirno kaw, pada'iray si gana' kapaparungun-na api. ");
INSERT INTO abx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ngan kon akapa'amban si pagtutu'u-mo i nagparapada'irayan-na si kitid-mo, uturon! Mas mahalap pa kon punggol i kitid-mo nga akaprubitso kaw si gana' katapusan-na kinabuhi', kuntra kon huwang si ka'aw i duwa kitid-mo nga linaho' kaw pan impyirno. ");
INSERT INTO abx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ngan kon akapa'amban si pagtutu'u-mo i nagparakukulawan-na si mata-mo, ala'on adday nan! Mas mahalap pa kon buta i adda mata-mo nga akasallod kaw si ginhadi'an-na si Diyos kuntra kon huwang si ka'aw i duwa mata-mo nga linaho' kaw pan impyirno, ");
INSERT INTO abx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kon singnga gana' kamatayun-na si mga ulut-na si mga minatay puho', ngan gana' liwat kapaparungun-na si api. ");
INSERT INTO abx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tungod sinan, day agpakapalkasan si api i dimu'an myintras ag'istar pa ato si kalibutan, pariho si pag'asiya si daying nga ga'i anra'at. ");
INSERT INTO abx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Aniya' mahalap kagamitan-na si asiya pariho may si ka'am. Sanglit dakam agpata'an. Pariho halimbawa' kon a'ala' na i kasira'-na si asiya, ga'i sapabwilta-bi i kasira'-na. Tambahi-bi asiya i mga kasing-kasing-bi ngan pahalapu-bi i paghururuwang-bi.” ");
INSERT INTO abx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Katapos pa'amban gihapon kas Jesus siray lugar. Pada'iray namay mga iya si lugar sakup-na si Judea hasta nga agpakatalabok pan dambila'-na si Suba' Jordan. Si kada pagtakkahi-na si adda lugar, naggururubukan iya ngan agparaturu'an-nay to sigon si kabatasanan-na. ");
INSERT INTO abx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aniya' magpamada'iray si iya mga Parisiyo para hamok pagpurbar kon anala' iya si mga allingun-na. Amatilaw mga iya, “Nagpatugot ba' si bala'ud-ta kam nga akabulag i lalla si alla-na?” ");
INSERT INTO abx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Patilaw i saruman-na si Jesus, “Ay i nagmandu'-na si ka'am si Moises?” ");
INSERT INTO abx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Anaruman may mga iya, “Agpatugut-na si Moises nga kon akabuwan i lalla papilis si pagbulag, pwidi na sapaduwa'i-na i alla-na.” ");
INSERT INTO abx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Anaruman may si Jesus, “Tungod si pagdiri'-bi pag'isip malalom, agpasurat-nay to bala'od si Moises. ");
INSERT INTO abx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero si tinikangan gayod ma'in da'inan sinan, kay ngan paghimu-na si Diyos si dimu'an, aghimu-na i a'a, lalla pati' danda. ");
INSERT INTO abx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sanglit, kinahanglan pa'amban i lalla si tatay-na pati' si nanay-na ");
INSERT INTO abx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ngan maki'adda si alla-na basi' mga iya duwangan ahimo na hamok adda puho'. Kon sugad, ma'in na mga iya duwangan, kundi' addangan na hamok. ");
INSERT INTO abx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sanglit, kon ay i nagbug'us-na si Diyos, kinahanglan nga ga'i gayod agbulag-na si a'a.” ");
INSERT INTO abx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngan pagbalik-na kas Jesus si ruma', agtilaw-na iya si mga inadalan-na tungod sinan. ");
INSERT INTO abx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Agsumatan-na mga iya, “Bisan say lallaha nga pabulag si alla-na mangno pakasal si la'in danda, si kamatu'uran agsala' iya tungod si pagtig'ub-na si la'in. ");
INSERT INTO abx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pariho may si danda nga pabulag si alla-na mangno pakasal si la'in lalla, akasala' may liwat iya tungod si pagtig'ub-na si la'in.” ");
INSERT INTO abx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Siray uras aniya' magpamawa si mga dadi'-na pada'iray si Jesus. I karuyag-na kunta' mga iya nga sadu'unan-na si palat-na si Jesus i mga dadi'-na pero nagsimol mga iya si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngan pakakulaw-na sinan si Jesus, asina iya ngan agpinugad-na i mga inadalan-na, “Tuguti-bi i kadadi'-dadi'an pagdugok si ako, ngan dakam ag'ulangu-bi mga iya, kay i da'inan mga a'a i papasakupon si nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sumatan-ta kam si kamatu'uran, bisan say i ga'i mangarawat si paghadi'-na si Diyos pariho pa'agi si pagkarawat-na si adda dadi'-dadi', sigurado ga'i gayod akasakop si mga nagpanhadi'an-na.” ");
INSERT INTO abx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mangno agkugus-na si Jesus i mga dadi' sa'uru'addangan, agpandu'unan-nay to si mga palat-na, ngan agpalakuhan-na si Diyos si mga kabubuwasun-na. ");
INSERT INTO abx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Si pagparalalangngan-na gihapon kas Jesus, aniya' lalla maglalahi padugok si iya ngan diritso anluhod atubang si iya. Amatilaw to si Jesus, “Ma'istro, sayod ako nga mahalap kaw. Ay i kinahanglan buruhatun-ko pagpasiguro nga sa'angkun-ko i kinabuhi' nga gana' katapusan-na?” ");
INSERT INTO abx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Anaruman dina si Jesus, “Ay kay akapinugad kaw nga mahalap ako? Ma'in ba' nga i Diyos hamok i mahalap? ");
INSERT INTO abx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sigurado akatu'anan kaw si mga kasugu'an: ‘Dakam agmatay; dakam agbisyo si pagdangallahan; dakam agtangkaw; dakam agbullo' si pagtistigos; dakam agdaya' nga aka'ala' kam si tawa'-na si la'in; agtahura kam si tatay-bi pati' si nanay-bi.’” ");
INSERT INTO abx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Anaruman may iya, “Ma'istro, tikang ngan aniya' na sarabutan-ko, agsunud-ko naynan mga kasugu'an.” ");
INSERT INTO abx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Abawa i kasing-kasing-na si Jesus sito lalla sanglit agpinugad-na, “Yayto na hamok i kulang-mo buruhaton. Agbalika ari ngan baligya'in i dimu'an inanna'-mo. Pumwanon si mga anggana' i balli-na basi' aniya' kayamanan-mo ari si langit. Katapos, pada'ituha basi' akabaya' kaw ngan agsunod si ako.” ");
INSERT INTO abx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngan pakabati'-na sinan si lalla, anla'in i bayhun-na ngan pa'amban to nga masurub'on kay iya i a'a nga bali haya i kayamanan-na. ");
INSERT INTO abx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Patalikot may si Jesus, kulawan-na i mga inadalan-na ngan amahalling, “Makuri gayod nga akasakop i mga mayaman a'a si nagpanhadi'an-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ag'usa gayod i mga inadalan-na tungod si mga allingun-na, sanglit agbwilta-na gihapon si Jesus i mga allingun-na, “Mga dadi'-ko, makuri gayod i pagsakup-na si mga mayaman. ");
INSERT INTO abx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas makuri payto kuntra si pag'agi-na si adda kamel si tanugan-na si dagom!” ");
INSERT INTO abx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Akatambay nan liwat si mga pag'usa-na, sanglit agsipurupatilaway mga iya, “Kon sugad, say i masalbar?” ");
INSERT INTO abx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Buslung-na mga iya si Jesus ngan anaruman, “Impusibli to nga sahimu-na si a'a, pero ma'in to impusibli si Diyos, kay sahimu-na i dimu'an.” ");
INSERT INTO abx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mangno amahalling si Pedro, “Tara', kay ag'ambanan kami' i dimu'an tawa' kami' pagsunod si ka'aw!” ");
INSERT INTO abx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Tama', ungod nan,” lingun-na may si Jesus. “Sumatan-ta kam si kamatu'uran, bisan say i pa'amban si ruma'-na, si mga kadingsirarihan-na, si nanay-na o si tatay-na, si mga dadi'-na, o si mga uma-na para atuman i katuyu'an-ko, nga agsara i mahalap sumat, ");
INSERT INTO abx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iya i tikarawat si ina'anto panahon addahatos pa dina dubli si mga ruma', mga kadingsirarihan, mga nanay, mga dadi', pati' mga uma, ngan huwang pa sinan i pagpamasakit liwat si iya si la'in a'a tungod si pagtu'u-na. Ngan si titakka panahon, aka'angkon pa liwat iya si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero malabbat nagpanhangad kuno' ina'anto nga si damuri allaw agpaka'ubos dina, ngan malabbat liwat magpama'ubos ina'anto nga si damuri allaw nagpanhangad dina.” ");
INSERT INTO abx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ngan ari na kas Jesus si lalan pasagka pan Jerusalem, padahulo si Jesus si mga inadalan-na. Abaraka i mga inadalan-na ngan atalaw i ditangnga' magpamaya' si mga iya. Mangno agbulag-na si Jesus i Dusi ngan agpanumatan-nay to si mga titakka mahinabo' si iya. ");
INSERT INTO abx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Aminugad iya, “Pasagka kita kam pan Jerusalem kon singnga trarayduran ngan papa'intrigahon i Pinili' A'a pada'iray si mga puno' paraghalad pati' si mga paragturo' bala'od. Paratukan iya kamatayon ngan papa'intrigahon si mga ma'in Hebro. ");
INSERT INTO abx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ralangkagan-na iya sito mga a'a, rurukda'an, ralapduson, ngan si katapus-tapusan maratayon pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mangno pamatapit ari si Jesus kas Santiago pati' Juan nga mga dadi'-na si Sebedeo, ngan agpaminugad, “Ma'istro, aniya' kunta' paralakuhon kami' si ka'aw ngan kinahanglan tuman-mo.” ");
INSERT INTO abx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Amatilaw may si Jesus, “Ay i karuyag-bi nga buruhatun-ko si ka'am?” ");
INSERT INTO abx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Anaruman may mga iya, “Si pagtingkulu'-mo si trunu-mo ari si maka'angayan ginhadi'an, i saruyagan kami' kunta' nga tugutan-mo kami' pagtingkulo' huwang si ka'aw, addangan si kawanan-mo ngan i addangan si kawiri-mo.” ");
INSERT INTO abx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Agpinugad-na mga iya si Jesus, “Ga'i sakatu'anan-bi i nagpalaku-bi.” Mangno amatilaw, “Aka'inom ba' kam siguro tikang si kupa si kasakitan nga kinahanglan irinumun-ko? Pabunyag ba' kam siguro pariho si kinahanglan nag'aku'-ko pag'antos si titakka pagbunyag si ako?” ");
INSERT INTO abx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Oho', sahimo kami' nan!” lingun-na may mga iya. Anaruman may si Jesus, “Hala, sigurado nga agpaka'inom kam tikang si kupa si kasakitan nga kinahanglan irinumun-ko, ngan burunyagan kam pariho si kinahanglan arantusun-ko si titakka pagbunyag si ako. ");
INSERT INTO abx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ma'in tawa'-ko i pagpili' kon say i magpaningkulo' si kawanan-ko pati' si kawiri-ko. Lugod, yaynan mga pwisto tawa'-nay nan si nagrisirbahan-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ngan pakapamati'-na may sinan si awatong pa inadalan, agkasirina mga iya si kas Santiago pati' Juan. ");
INSERT INTO abx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sanglit agban'u-na mga iya dimu'an si Jesus pagdugok si iya ngan agpanwaydungan-na, “Akatu'anan kam nga agpanggamit pinirit pagdalom i nagparapaminugad nga mga mahalap magpamuno' si mga nasyon. Agpapalabaw to mga gilalabawi a'a si mga kalugaringun-na. ");
INSERT INTO abx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ma'in da'inan sinan i pa'agi-bi pagdalom si kapararihu-bi. Kon addangan si ka'am i maruyag mabantog, kinahanglan iya agsirbi si la'in. ");
INSERT INTO abx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ngan kon addangan si ka'am i maruyag nga naghangad, kinahanglan ag'ako' nga magin rilihugun-na si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kay bisan i Pinili' A'a ga'i pada'ito basi' nagsirbihan pero basi' iya i magsirbi ngan basi' sapumwan-na liwat i kinabuhi'-na paglukat si malabbat a'a.” ");
INSERT INTO abx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mangno anakka kas Jesus pati' i mga inadalan-na si Jerico. Si pataliwan-na na mga iya siray syudad, malabbat namay i magpamungyod si mga iya. Siray uras, aniya' buta lalla magparatingkulo' ngan magparapalimos si bihing-na si tinampo. Bartimeo i arun-na sito nga dadi'-na si Timeo. ");
INSERT INTO abx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ngan pakabati'-na nga si Jesus taga Nasaret i palabay, agtikang iya pagban'o, “Jesus nga Dadi'-na si David, kalu'uyin ako!” ");
INSERT INTO abx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Malabbat si iya magsimol nga ga'i agpararibok. Pero agkukusog dina i pagparaban'u-na, “Dadi'-na si David, kalu'uyin ako!” ");
INSERT INTO abx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pahuway si Jesus ngan anlihog, “Ban'uhon iya.” Sanglit agsumatan-na mga iya i buta, “Aglipaya! Anungguha kay agban'u-na kaw.” ");
INSERT INTO abx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Agtapukan-na dayon si buta i nagpakurumbut-na, anhintak anunggo, ngan diritso iya padugok si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Amatilaw si iya si Jesus, “Ay i saruyagan-mo nga sahimu-ko si ka'aw?” Anaruman may i buta, “Rabbi, i karuyag-ko kunta' nga akakulaw ako gihapon.” ");
INSERT INTO abx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Pada'iraya na,” lingun-na si Jesus. “I pagtutu'u-mo, iya i makapahalap si ka'aw.” Akakulaw dayon iya ngan amaya' iya si Jesus si paglalangngan-na. ");
INSERT INTO abx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ngan pagdadara'un-na kas Jesus si Jerusalem, akatakka mga iya si mga baryo Betpahe pati' Betania. Aka'anna' to mga baryo si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. Agpadahulo si Jesus duwangan si mga inadalan-na ");
INSERT INTO abx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ngan agmandu'an-na mga iya sito: “Pada'iraya kam si dahulu'an-tay ro kam baryo. Si panakka-bi aro, aniya' sa'anda'an-bi nagpa'ingkot putro asno nga ga'i pa gayod akakabayuhan. Bak'aru-bi ngan guyuru-bi pada'ito. ");
INSERT INTO abx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kon aniya' si ka'am mamatilaw, ‘Pa'i-bi nan?’ sumati-bi na hamok nga, ‘Agkinahanglan-nay to si Paragdalom pero papabalikun-na may to dayon.’” ");
INSERT INTO abx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sanglit pamalangngan mga iya ngan sa'anda'an-na mga iya i asno ari si lalan nagpa'ingkot si pwirtahan-na si ruma'. Ngan pamak'ad-na na mga iya, ");
INSERT INTO abx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","amatilaw i ditangnga' magpanunggo ari, “Pa'i-bi nan? Apa'i may kay agbak'ad-bi nan?” ");
INSERT INTO abx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Agsarumanan-na mga iya pariho si tugun-na si mga iya si Jesus, sanglit nagtugutan mga iya pagbwilta. ");
INSERT INTO abx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Agguyud-na mga iya i asno pada'iray si Jesus. Agkamadiruhan-na mga iya si mga nagpamakurumbut-na ngan anakrang si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Malabbat i magpamuklad si mga nagpamakurumbut-na ari si tinampo, ngan i ditangnga' may agpangampin si tinampo si mga marabong paklang nga nagpanabtab-na si bihing-na si mga uma ari. ");
INSERT INTO abx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sigi gagasod i magpantupo' si iya ngan da'inan may i magpamungyod: Hosanna! Malipayon gayod i a'a nga pada'ito pina'agi si gahum-na si Paragdalom! ");
INSERT INTO abx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bali haya i kahalapan-na si ginhadi'an-na si gipapu'-papu'i-ta kam David, nga papatungguhon gihapon. Hosanna, hasta liwat ka'aw nga Gilalabawi! ");
INSERT INTO abx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pakasallud-na kas Jesus si Jerusalem, agdiritso mga iya si hawan-na si templo ngan mamuraw-puraw iya si dimu'an. Pero, tungod kay kuhap na, pagawas si Jesus huwang i Dusi ngan agpamalik gihapon mga iya pan Betania. ");
INSERT INTO abx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngan ka'asumuhan, si pagparalalangngan-na kas Jesus man Betania, angabat iya kalingantuhan. ");
INSERT INTO abx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aniya' sapantawan-na kayo igos nga bali rabong ngan iyay ray hamok i pala'in tungod kay ag'irog dina kon tig'iguson. Sanglit padugok iya pagkulaw kon aniya' buwa'-na, pero sadiskubrihan-na nga puro hamok dahon ngan gana' gayod buwa'-na. ");
INSERT INTO abx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sanglit agmaldisyun-nay ray kayo si Jesus, “Hala, tikang ina'anto, gana' na gayod makakinda si buwa'-mo hasta si kahastahan.” Ngan yaynan mga allingon, sapamati'an-na si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngan panakka-na kas Jesus si Jerusalem, pasallod mga iya si hawan-na si templo ngan diritso iya agtikang pagpanabrog si mga magparapamalli pati' i mga magparapamaligya' ari. Agpamabaliskad-na i mga lamisa-na si magparapamabalyo pala'in-la'in kwarta. Agpamabaliskad-na liwat i mga bangkitu-na si magparapamaligya' panhahalad sarampati. ");
INSERT INTO abx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ga'i liwat agtugutan-na si Jesus i pagparabawa-na si mga a'a si mga inanna'-na, nga ag'agi si mga hawan-na si templo. ");
INSERT INTO abx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Katapos agparaturu'an-na i mga a'a sito: “Ma'in ba' nga aniya' maka'anna' si Kasuratan nga agpinugad i Diyos, ‘Pammangadyi'an i ruma'-ko para si mga a'a-na si dimu'an nasyon,’ kundi', aghimu-bi to dina ‘pangngingistaran-na si mga tulisan!’” ");
INSERT INTO abx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sakatu'anan-na dayon si mga puno' paraghalad pati' si mga paragturo' bala'od i mahi'unong sinan, sanglit agpara'anda' mga iya pa'agi kon pinapa'i sapamatay-na mga iya si Jesus. Da'inan gayod sinan i mga saruyagan-na tungod kay agkabararaka mga iya si Jesus, kay agpa'usa gayod i dimu'an magpantarambak si nagparaturu'-na. ");
INSERT INTO abx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ngan kasanguman, pagawas gihapon kas Jesus si syudad. ");
INSERT INTO abx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngan kanalungan, si pagparalalangngan-na namay kas Jesus, sakulawan-na mga iya gihapon i kayo igos, pero uga na hasta pa i mga gamut-na. ");
INSERT INTO abx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aka'intom dagos si Pedro sanglit agpinugad-na si Jesus, “Rabbi, kulawin nan! A'uga i igos nagmaldisyun-mo!” ");
INSERT INTO abx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Anaruman si Jesus, “Anutu'uha kam si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sumatan-ta kam si kamatu'uran, pwidi kam akapinugad sito bukid, ‘Tig'alsaha anan ngan tigpa'itsaha pan kalawot,’ ngan atuman to para si ka'am kon aniya' pagtapud-bi ngan ga'i kam agduda. ");
INSERT INTO abx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tungod sinan sumatan-ta kam, bisan ay i nagpalaku-bi kon mangadyi' kam, kon agtutu'o kam nga tawa'-bi na, sigurado sakarawat-bi. ");
INSERT INTO abx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngan kon si pag'ampu'-bi, aniya' pa humut-bi si kaparihu-bi, pasayluhu-bi iya, basi' sapasaylu-na may liwat i mga sala'-bi si Tatay-bi ari si langit.” ");
INSERT INTO abx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero kon ga'i kam agpasaylo si sala'-na si la'in a'a, ga'i may liwat sapasaylu-na i mga sala'-bi si Tatay-bi ari si langit. ");
INSERT INTO abx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Agbwilta gihapon kas Jesus pan Jerusalem. Ngan pagparalalangngan-na si Jesus ari si mga hawan-na si templo, pamadugok si iya i mga puno' paraghalad, i mga paragturo' bala'od, hasta i mga mata'o kamabu'utan ");
INSERT INTO abx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ngan agpamatilaw mga iya si Jesus, “Singnga kaw agsarit si mga nagparabuhat-mo? Say i magtugot si ka'aw sinan?” ");
INSERT INTO abx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Anaruman dina si Jesus, “Patilawan-ta may kam liwat. Sarumani-bi ako dahulo ngan anumat may ako kon say i magtugot si mga nagbuhat-ko. ");
INSERT INTO abx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sumati-bi ako, say magtugot si Juan pagbunyag, Diyos o a'a?” ");
INSERT INTO abx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Agpandiriskusyon dahulo mga iya, “Tara', ay sito i pinasumat-ta kam? Kon anaruman kita kam, ‘I Diyos,’ sigurado amatilaw nan iya, ‘Kon sugad, kapa'i may kay ga'i kam agtutu'o si mga allingun-na si Juan?’ ");
INSERT INTO abx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero kon anaruman may liwat kita kam, ‘I a'a,’ a, ta!” Aniya' kadilikaduhan-na mga iya si mga a'a tungod kay ag'alagad gayod i mga a'a nga ungod paragsumat-na si Diyos si Juan. ");
INSERT INTO abx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sanglit anaruman dina mga iya, “Ga'i kami' akatu'anan.” Anaruman gihapon si Jesus, “Kon sugad, ga'i may liwat ako anumat si ka'am kon say i magtugot si ako nga sabuhat-koy to.” ");
INSERT INTO abx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mangno agpahalling si Jesus si mga a'a pina'agi si mga isturya nga agtukoy si kamatu'uran: “Aniya' lalla magtanom ubasan. Agpadir-na palibot, aghimo iya mahaya luwang si mahaya bato basi' aniya' pammagga'an, ngan agtindugan-na turri pammantayan. Katapos agpa'ataman-nay to si mga mangngataman ngan pataliwan iya pan la'in lugar. ");
INSERT INTO abx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ngan panakka-na si tigpangku'on si ubas, agpabawa iya addangan rilihugon pada'iray si mga mangngataman-na pag'ala' si kapartihan-na si mga pinangku'-na. ");
INSERT INTO abx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero agpugulan-na ngan agpuniti-na dina mga iya i rilihugon, ngan agpabalik-na mga iya nga gana' gayod sabawa-na. ");
INSERT INTO abx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mangno, agpabawa gihapon i tagtawa' addangan rilihugon. Agparapakul-nay to si mga mangngataman ngan agparapakamalu'an-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Katapos, agpabawa namay la'in rilihugon, ngan agmatay-nay to mga iya. Pariho sinan i mga nagpanhimu-na si malabbat pa nagpamabawa-na si tagtawa'. Agparakastigu-na mga iya i ditangnga' ngan i ditangnga' may agparapanmatay-na. ");
INSERT INTO abx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Aniya' addangan pa mabilin nga pwidi sapabawa-na si tagtawa', nga iya i dadi'-na lalla nga hinigugma'-na. Sanglit si katapusan, agpabawa-na liwat i dadi'-na pada'iray si mga mangngataman-na. Akapinugad iya si kalugaringun-na, ‘Tingali rispitaran-na mga iya i dadi'-ko.’ ");
INSERT INTO abx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Pero agsarabut-sabot i mga mangngataman, ‘Awira' i iridiro. Tuwa na kam, matay-ta kam iya basi' kita kam i makabawa si kayamanan-na.’ ");
INSERT INTO abx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sanglit agpugulan-nay to mga iya ngan agmatay-na. Mangno agdagnas-na mga iya i bangkay-na pagawas si ubasan.” ");
INSERT INTO abx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Amatilaw si Jesus pagpaklaro si isturya-na, “Kon sugad, ay may i binuhat-na si tagtawa' si ubasan?” Iya mismo manaruman si pagpinugad, “Yayto i binuhat-na: Pada'iray iya ngan matay-na i mga mangngataman. Katapos pa'intriga-na si la'in i ubasan-na. ");
INSERT INTO abx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ma'in ba' nga sasayuran-bi to anan si Kasuratan? Kon ma'in i nagpabawa-na dadi', say may bali' i nagpinugad bato nga maka'anna' ari? I bato nga nagdiri'-na si mga panday, iya lugod dina i makapasarig si dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Agbuhat-nay to si Paragdalom, ngan urusahon gayod si pangulawan-ta kam!” ");
INSERT INTO abx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sanglit ag'anda' dayon mga iya pa'agi pagdakop si Jesus kay akatu'anan mga iya nga mga iya i nagpatama'an sito isturya. Pero atalaw mga iya si kalabbatan magpantarambak, sanglit ag'ambanan-na na hamok mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Katapos aniya' si mga Parisiyo pati' si mga sakop si partido nga tinindug-na pa si Hadi' Herodes nga nagpanlihog pagdugok si Jesus, pagbantay kon anala' i mga saruman-na si mga patilaw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Padugok mga iya si Jesus ngan aminugad, “Ma'istro, akatu'anan kami' nga agsumat kaw pirmi si kamatu'uran. Ga'i kaw atalaw kon ay i isip-na si a'a ngan gana' nagkilala-mo bisan say i makatama'an, pero agturo' kaw hamok i pa'agi pagtapit si Diyos nga ag'alagad si kamatu'uran. Sumatin ngani' kami', tama' ba' para si kita kam i pagbayad buhis si Emperador si Roma o ma'in? ");
INSERT INTO abx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kinahanglan ba' kita kam sito agbayad o ga'i?” Kundi' sakatu'anan-na si Jesus nga mga mahalap hamok i mga pamawa'-na, pero mga mara'at i mga inisipan-na, sanglit agtilaw-na mga iya, “Ay kay agparadadakup-bi gayod i mga allingun-ko? Paru'du'i-bi daw ako adda dinari diplata kay kulawan-ko.” ");
INSERT INTO abx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mangno ag'ala' mga iya adda dinari. Ngan pakaparu'du'-na mga iya, amatilaw si Jesus, “Say to tawa' bayhon pati' aron maka'anna' to ato?” Anaruman mga iya, “Tawa'-na si Emperador.” ");
INSERT INTO abx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sanglit amahalling may si Jesus, “Kon sugad, bayari-bi i Emperador si mga hinimo nga irog si iya kay tawa'-nay nan, ngan bayari-bi may i Diyos si mga hinimo nga irog may liwat si iya kay tawa'-nay nan.” Sanglit ag'usa-na gayod mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kata'ud-ta'uran, aniya' pamadugok si Jesus mga Sadusiyo basi' agpakapatilaw. I mga Sadusiyo, iya i magparapanumat nga ga'i na abanhaw i mga a'a si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Aminugad mga iya, “Ma'istro, aniya' mando' nagsurat-na si Moises para si kita kam nga kinahanglan pakasalan-na si sirari i bayaw-na kon amatay i siyaka-na nga gana' pa dadi'-na, basi' akadadi' mga iya nga akwinta bilang dadi'-na si siyaka-na. ");
INSERT INTO abx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aniya' siray pitungan lalla magdingsirarihan. Inallahan i siyaka, pero amatay iya nga gana' pa dadi'-na. ");
INSERT INTO abx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mangno, agpakasalan-na si kaduwangan, ngan amatay to liwat. Pariho sinan i nagbuhat-na si katallungan. ");
INSERT INTO abx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mangno agbuhat-nay nan si mga magkabirilin pa mga sirari. Agpakasalan-nay ray danda mga iya pitungan ngan agkamaratay mga iya nga ga'i agpakadadi'. Si katapus-tapusan, amatay liwat i danda. ");
INSERT INTO abx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tara', si pagkabanhaw, say may i tag'alla si danda, kay sapakasalan-na iya si pitungan?” ");
INSERT INTO abx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Anaruman si Jesus, “Akatu'anan ba' kam kon ay kay sala' i mga isip-bi? Tungod kay ga'i kam agpakasabot hi'unong si Kasuratan o si gahum-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Si pagkabanhaw, akapariho na mga iya si mga anghel. Gana' na uru'allahay ari si langit. ");
INSERT INTO abx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero mahi'unong si mga duda-bi kon aniya' ba' mabanhaw, ga'i ba' sabasa-bi si Libru-na si Moises? Agpamatu'uran-nay nan si nagsurat-na mahi'unong si hinabo' siray si magpakayat tanaman kon singnga sapakalihan-na i busis-na si Diyos nga agpinugad, ‘Ako mismo i Diyos nagtutu'u-na kas Abraham, Isaac, pati' si Jacob hasta pa ina'anto.’ ");
INSERT INTO abx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kon sugad, pariho si kamutangan-na mga iya, ma'in minatay i magpadayon pagtutu'o kundi' allom dina. Sanglit sala' gayod i mga isip-bi.” ");
INSERT INTO abx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aniya' addangan paragturo' bala'od ari nga akapamati' si diskusyon. Ngan pakahuna'-huna'-na nga mahalap i saruman-na si Jesus si mga Sadusiyo, amatilaw iya, “Ay i pinaka'impurtanti si dimu'an mga kasugu'an?” ");
INSERT INTO abx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Anaruman may si Jesus, “Yayto i pinaka'impurtanti: ‘Amati'a kam, ka'am mga a'a-na si Israel! I Paragdalom Diyus-ta kam, iya hamok i Paragdalom. ");
INSERT INTO abx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Higugma'u-bi iya si bug'os kasing-kasing-bi, si bug'os kina'iya-bi, si bug'os paminsada-bi, pati' si bug'os kusug-bi.’ ");
INSERT INTO abx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ngan yayto i kaduwa: ‘Higugma'u-bi i igkasi a'a-bi pariho si paghigugma'-bi si kalugaringun-bi.’ Gana' kasugu'an manlabaw pa si duway to.” ");
INSERT INTO abx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aminugad may i paragturo' bala'od si Jesus, “Mahalap gayod i pagkapinugad-mo, Ma'istro. Tama' i nagsumat-mo nga gana' makapariho si Diyos, ngan gana' na la'in diyos pwira si iya. ");
INSERT INTO abx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kinahanglan aghigugma' i a'a si Diyos si bug'os kasing-kasing-na, si bug'os sarabutan-na, ngan si bug'os kusug-na ngan kinahanglan iya aghigugma' si igkasi-na pariho si paghigugma'-na si kalugaringun-na. Mas impurtanti pa i pagsunod si duway to kasugu'an kuntra si pagpabar'og si mga panhahalad hayop o si pagbuno' ari si panhahalaran ray.” ");
INSERT INTO abx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sahuna'-huna'an-na si Jesus nga madunong gayod i lalla tungod si mga saruman-na, sanglit aminugad iya, “Ma'in na kaw matala nga akasakop si mga nagpanhadi'an-na si Diyos.” Kahuman sinan, gana' na mamintas pa pagpatilaw si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Si pagparaturu'-na si Jesus ari si mga hawan-na si templo, amatilaw iya, “Pinapa'i akapinugad i mga paragturo' bala'od nga gi'uru'ampuhi-na hamok si David i Tinu'inan Mannanalwas? ");
INSERT INTO abx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mismo si David agpahalling sigon si pagdalum-na si Espirito Santo: Agpinugad i Paragdalom Diyos pada'iray si Paragdalum-ko, ‘Aningkulu'a ato si kawanan-ko, tubtob nga sapama'ubus-ko i mga kuntra-mo pa nga day pannungtungan-mo.’ ");
INSERT INTO abx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kon sugad, ‘Paragdalom’ i pagban'u-na mismo si David si gi'uru'ampuhi-na. Sanglit pinapa'i kam akapinugad nga gi'uru'ampuhi-na hamok si David i Tinu'inan Mannanalwas?” Alipay gayod i kalabbatan magpantarambak pagpakali si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Si pagparaturu'-na, agpinugad-na i mga a'a, “Agmatuha kam si mga paragturo' bala'od kay agkararuyag mga iya paglalangngan nga mga dikalsa pagpadadayaw ngan agkararuyag liwat si mga talahuron pangumusta-na si mga a'a ari si mirkado. ");
INSERT INTO abx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iyay nan i mga magparapamili' si mga printi panningkulu'an si mga sinaguga pati' si mga pwistoy nan nga akabuwan unra si mga kumbitihan. ");
INSERT INTO abx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mga iya i magparapandaya' si mga balo danda pag'ala' si mga inanna'-na, ngan katapos agparapangadyi' to mga a'a maliyat para hamok si pangulawan-na si la'in. Sanglit tungod sinan, mas mara'at i kastigo si mga iya kuntra si ditangnga'!” ");
INSERT INTO abx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Si pagparatingkulu'-na si Jesus atubang si kahon pangnganna'an kwarta si templo, agparatigamanan-na i mga magparapanlaho' ari. Malabbat mga mayaman nga mahaya i nagparapanlahu'-na. ");
INSERT INTO abx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mangno aniya' pubri balo danda manlaho' tumbaga diplata, duwa bug'os nga bali diki' i kantidad-na. ");
INSERT INTO abx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Agban'u-na si Jesus i mga inadalan-na pagtiriripon ngan agpanumatan-na, “Sumatan-ta kam si kamatu'uran, mas urog i naglahu'-na si pubri nan balo kuntra si nagpadunar-na mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay i nagpadunar-na mga iya, subra hamok si mga kayamanan-na; pero yaynan balo bisan kon anggana' iya, aglahu'-na i dimu'an tawa'-na nga gana' nagbilin-na.” ");
INSERT INTO abx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Si pa'amban-na kas Jesus si templo, aniya' addangan si mga inadalan-na maminugad, “Ma'istro, kulawin nan! Kamaka'angayan si mga kinurtihan mamahaya bato pati' si mga mahayay nan bilding!” ");
INSERT INTO abx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aminugad may si Jesus, “Sakulawan-bi ba' nan mga mahayay nan bilding? Gana' sinan mabilin si mga sakulawan-bi nan bato si nagpanungtungan-na. Tirimpagon nan dimu'an.” ");
INSERT INTO abx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Si pagparalumpagi'-na kas Jesus ari si tagudtod nag'arunan Bukid-na si Ka'ulibuhan, nga kinapantawan i templo, i huwang-na hamok, iya kas Pedro, Santiago, Juan, pati' si Andres. Agpamatilaw mga iya si Jesus, ");
INSERT INTO abx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sumatin daw kami' kon sumiran nan ahinabo'. Ay i pangngilalahan kon atuman naynan dimu'an?” ");
INSERT INTO abx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Anaruman si Jesus, “Agbantaya kam, ngan dakam agpatugot nga akadaya'an kam si bisan say. ");
INSERT INTO abx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Malabbat i tipada'ito nga aggamit si arun-ko si pagpinugad, ‘Ako i Tinu'inan Mannanalwas,’ ngan malabbat i mga sadaya'an-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dakam abaraka si pakapamati'-bi nga aniya' mga girra matapit si ka'am ngan aniya' liwat si mga matala lugar. Kinahanglan ahinabo' i mga da'ito sito pero ma'in payto i pagtapos si panahon. ");
INSERT INTO abx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Agparapanggirirra i mga nasyon ngan sigi panhiriran i mga ginhadi'an. Aniya' mga linog si mga pala'in-la'in lugar, ngan aniya' liwat mga gutom. Pero iyay nan i panikangan pa hamok si mga pagkuri-bi. ");
INSERT INTO abx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kinahanglan kam ag'andam pag'atubang para si mga karat'an manakka si ka'am. Darakupon kam ngan papa'intrigahon si mga kunsiho tungod si ako. Pwira pa sinan, karastiguhon liwat kam ari si mga sinaguga ngan papatungguhon atubang si mga gubirnador pati' si mga hadi' basi' akatistigos kam si mga iya si ungod mahinabo'. ");
INSERT INTO abx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kinahanglan pasamwak-bi i mahalap sumat si dimu'an nasyon antis si katapusan. ");
INSERT INTO abx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sanglit, bisan sumiran kam agpadakup-na mga iya ngan pa'intriga-na si mga husgado tungod si pagtu'u-bi, dakam abaraka kon papa'i-bi pagpamatu'od si pagkamatadung-bi ngan kon ay i mga papahallingun-bi. Sumatu-bi hamok i nagpumwan si paminsada-bi sinan uras, kay i mga allingon ma'in tikang si kalugaringun-bi, kundi' tikang si Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Trarayduran-na pagmatay si mga sirari i mga siyaka-na magpanutu'o. Trarayduran-na liwat si mga tata' i mga magpanutu'o dadi'-na. Kuruntrahun-na si mga dadi' i mga mahanak-na hasta pa nga pamatay-na mga iya tungod si mga pagtu'u-na. ");
INSERT INTO abx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Naghumutan kam si dimu'an mga a'a tungod si ako, pero bisan say i mangilob tubtob si katapusan, iya i masalbar si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aniya' nag'ibitaran gayod a'a nga akapara'at si dimu'an, ngan kinahanglan sasabutan-nay to si magbasa. Sanglit si pakakulaw-bi sinan nga anunggo si lugar nga ma'in angay para si iya, kinahanglan agrarabunos pan tagudtod i mga magpangistar ari si Judea. ");
INSERT INTO abx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kon awiray i addangan si pammalayahayan ari si binubungan, paduwa'i iya pero ga'i na kunta' pasallod si ruma' pag'addo' si mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngan kon ari namay iya si uma, ga'i na kunta' padulhog pag'ala' si pammakurumbut-na. ");
INSERT INTO abx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka'asi' gayod sinan mga allaw i mga burod pati' i mga nana nga aniya' nagpasusu-na! ");
INSERT INTO abx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ampu'i-bi si Diyos nga ga'i to akatuman si tigtugnawon, ");
INSERT INTO abx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kay i mga kakurihan-na sinan mga allaw anubra pa si bisan ay kakurihana nga sa'abat-na si kalibutan tikang si panikangan, si paghimu-na si Diyos si kalibutan, tubtob ina'anto, ngan gana' na liwat gayod sinan makapariho pa hasta si katapusan. ");
INSERT INTO abx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kon i kalabbat-na si allaw sinan mga kakurihan ga'i ag'ibanan-na si Paragdalom, sigurado nga gana' gayod mabilin allom. Pero tungod si mga pinili'-na a'a nga saruyagan-na gayod si Diyos, iribanan-na si Paragdalom i allaw-na sinan. ");
INSERT INTO abx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sinan uras, kon aniya' magpaminugad si ka'am, ‘Kulawi-bi, atiya' na i Tinu'inan Mannanalwas!’ o ma'in ngani' ‘Kulawi-bi ro, awira' na iya!’ dakam iya agtutu'uhu-bi. ");
INSERT INTO abx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sigurado nga aniya' pamaluwa' mga burubullo' tinu'inan mannanalwas. Pamaluwa' liwat i mga burubullo' paragsumat-na si Diyos. Agpanhimoy to mga a'a pala'in-la'in pangngilalahan si langitnon kuno' kasiguruhan pati' mga makagagahom binuhatan basi' aniya' sadaya'an-na mga iya, nga kon ahimo, hasta pa i mga a'a nagpamili'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Agbantaya kam sinan! Agsumatan-ta na kam andang si dimu'an myintras ahinabo'.” ");
INSERT INTO abx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Si mga allaw pakatapus-na sinan mga kakurihan, anlu'om i allaw ngan ga'i amuwan i bulan si danta'-na. ");
INSERT INTO abx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Agkataraktak i mga bitu'on tikang si langit ngan agpamalisa i dimu'an gamhanan ari si mga ararupan-na. ");
INSERT INTO abx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sinan uras, sakulawan-na si mga a'a i Pinili' A'a ari si panganod. Agdadara'on iya nga bali kamakagagahom ngan nagpalibutan si maka'angayan danta'. ");
INSERT INTO abx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Papabawahun-na liwat i mga anghel-na pagtiriripon si mga nagpamili'-na a'a, tikang si ampat kantu-na si kalibutan, tikang gayod ato pan dambila'. ");
INSERT INTO abx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kon sugad, adali-bi i liksyon tikang si kayo igos: Kon agbirdi na i mga saringsing-na ngan aniya' na sito buraksa'-na, akatu'anan kam nga ma'in na pira i tigpangku'on bisan kon ga'i kam nagsumatan. ");
INSERT INTO abx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pariho sinan, si pakakulaw-bi nga ahinabo' nan dimu'an, akatu'anan kam nga matapit na gayod iya, day awira' na gayod iya si pwirtahan. ");
INSERT INTO abx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sumatan-ta kam si kamatu'uran, ahinabo' nan dimu'an antis ahuman i kapanahunan-na si mga a'ay to ina'anto. ");
INSERT INTO abx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aniya' titakka katapusan-na si kalangitan pati' si kalibutan, pero gana' gayod katapusan-na si mga allingun-ko hasta si kahastahan.” ");
INSERT INTO abx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Gana' gayod makatu'anan kon sumiran nan allawa anakka o kon ay urasa. Ga'i akatu'anan i mga anghel si langit, o bisan i Dadi'. I makatu'anan hamok sito, iya i Tata'. ");
INSERT INTO abx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sanglit agbantaya kam! Agkallata kam! Ga'i sakatu'anan-bi kon sumiran i uras-na. ");
INSERT INTO abx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Akaparihoy to si a'a nga tibiyahi: Agbilin-na i ruma'-na si mga tinapuran-na, ngan balang addangan aniya' trabahu-na. Agsumatan-na i sari'i si pwirtahan nga kinahanglan iya agbantay. ");
INSERT INTO abx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kon sugad, agbantaya kam kay ga'i sakatu'anan-bi kon ay urasa i pagbalik-na si tagruma'. Tingali agbalik iya si baha'o sangom, tingali si magkatutnga', tingali kon si primiro pagtutturu'ok, ngan tingali si kanalungan na dina. ");
INSERT INTO abx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kon anhintak iya pagbalik, dakam agpatugot nga sakulawan-na kam agpamaturi. ");
INSERT INTO abx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sanglit, i nagparasumat-ko si ka'am, iya liwat i nagparasumat-ko si dimu'an: Agbantaya kam!” ");
INSERT INTO abx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Siray uras duwa na hamok allaw antis i Pyista si Paglabay pati' si Tinapay nga Gana' Pammatubu'-na, sanglit agparapanganda' pa'agi i mga puno' paraghalad pati' i mga paragturo' bala'od pagdakop si Jesus nga gana' makatu'anan basi' sapamatay-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero agsarabut-sabot mga iya, “Kinahanglan ga'i kita kam agbuhat sito si kapyistahan-na, kay tingali mangisog ngan agsararamok i mga a'a.” ");
INSERT INTO abx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ngan ari kas Jesus si baryo Betania, si ruma'-na kas Simon nga akanaynayan na hamok Gu'uron, aniya' danda padugok si nagtarangka'an-na mga iya pagkakan nga agbawa bali kamahalan pasangngit. Gana' sito salakut-na nga hinimo tikang si tanaman nardo nga i pangngisihan-na hinimo tikang si bato alabastro. Agbuka-na si danda i nag'isihan ngan agpabu'bu'-nay to si takuluk-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aniya' si mga a'a ari nga andiri' gayod ngan agsipurupatilaway, “Ay kay agkaragan-nay nan hamok pasangngit? ");
INSERT INTO abx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pwidi nan kunta' sabaligya'an-ta subra si tris syintos dinari diplata ngan i bayad-na apumwan si mga anggana'.” Sanglit ag'isugan-na mga iya i danda. ");
INSERT INTO abx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero aminugad dina si Jesus, “Pata'ani-bi hamok iya! Ay kay agpakamalu'an-bi to danda? Ka'angayan gayod i nagbuhat-na si ako. ");
INSERT INTO abx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pirmi aniya' mga anggana' nga sabagatan-bi ngan akabulig kam si mga iya bisan sumiran kam aruyag. Pero ma'in na pira, ga'i na ako sabagatan-bi. ");
INSERT INTO abx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Agbuhat-na hamok i sahimu-na. Agbu'bu'an-na si pasangngit i puhu'-ko pag'andam antis si uras si paglabbong. ");
INSERT INTO abx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sumatan-ta kam si kamatu'uran, bisan singnga nagpasamwak i mahalap sumat si bug'os kalibutan, parasumaton liwat i nagbuhat-na pagpa'intom ngan pagdayaw si pagka'a'a-na.” ");
INSERT INTO abx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mangno pada'iray si mga puno' paraghalad si Judas Iscariote, addangan si Dusi, pagtraydor si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Alipay to gayod mga puno' pagpamati' si mga sumbung-na si Judas, ngan agsa'aran-na mga iya pagbuwan kwarta. Sanglit, agtikang si Judas pag'anda' tama' uras nga sapa'intriga-na si Jesus si mga iya. ");
INSERT INTO abx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mangno anakka i primiro allaw si Pyista si Tinapay nga Gana' Pammatubu'-na, nga iya i allaw pagbuno' si mga papahalaron nati pa karniro para si pakan pagpa'intom si Paglabay. Sinan allaw, nagtilaw si Jesus si mga inadalan-na, “Singnga may i karuyag-mo nga agtima kami' para si pakan pagpa'intom si Paglabay?” ");
INSERT INTO abx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aglihug-na si Jesus i duwangan si mga iya ngan agsumatan-na, “Padulhuga kam pan syudad. Aniya' sakulawan-bi aro lalla nga agsuknong adda biso' buwahi'. Amungyura kam si iya. ");
INSERT INTO abx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sumati-bi i tagruma' nga nagpanahikan-na, ‘Agpatilaw i Ma'istro si ka'aw kon singnga i kwarto pammanganan-na basi' akapamangan iya huwang si mga inadalan-na pagpa'intom si Paglabay.’ ");
INSERT INTO abx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mangno, pakulaw-na kam adda mahaya kwarto ari si dyata' nga hamis na i dimu'an. Agtimaha kam ari para si kita kam.” ");
INSERT INTO abx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pa'amban i mga inadalan-na, padulhog pan syudad, ngan sa'anda'an-na mga iya i dimu'an nagsumat-na si Jesus. Mangno agtima mga iya para si pakan. ");
INSERT INTO abx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ngan kasanguman, pada'iray si Jesus pati' i Dusi. ");
INSERT INTO abx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Si pagtarangka'-na mga iya, aminugad si Jesus, “Sumatan-ta kam si kamatu'uran, addangan gayod si ka'am i titraydor si ako, addangan nga huwang gayod agkakan si ako.” ");
INSERT INTO abx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mga masurub'on gayod mga iya, ngan agtikang pagpinugad si iya sa'uru'addanganay, “Sigurado, ma'in ako, ha?” ");
INSERT INTO abx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Anaruman may si Jesus, “Addangan gayod si ka'am Dusi, addangan nga magpaduldol si pan-na si matapit mangko' nagpaduldulan-ko. ");
INSERT INTO abx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maratayon i Pinili' A'a pariho si maka'anna' si Kasuratan, pero papabidu'on gayod i titraydor si Pinili' A'a! Mas mahalap pa kunta' si iya nga ga'i na hamok naghinganak si nanay-na!” ");
INSERT INTO abx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Si pagpamangan-na na mga iya, angaddo' si Jesus adda bug'os pan ngan agpasalamat si Diyos. Agturutabbi'-nay to ngan agpumwan-na si mga iya dungan si pagpinugad, “Karawatu-bi to, iyay to i puhu'-ko.” ");
INSERT INTO abx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Katapos, angaddo' iya kupa ngan agpasalamat si Diyos. Mangno agpumwan-nay to si mga iya, ngan agpanginom mga iya dimu'an ari siray kupa. ");
INSERT INTO abx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aminugad namay si Jesus, “Iyay nan i laha'-ko nga kasarigan si pa'agi-na si Diyos pagtapit si iya ngan pa'awas to para si malabbat a'a. ");
INSERT INTO abx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sumatan-ta kam si kamatu'uran, ga'i na ako anginom gihapon si bino tubtob si allaw nga paluwa' i baha'o pa'agi pag'inum-ko si bino ari si ginhadi'an-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mangno, pakahuman-na mga iya agkanta adda salmo, pagawas dayon mga iya ngan pamada'iray si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. ");
INSERT INTO abx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Agsumatan-na si Jesus i mga inadalan-na, “Pamabulag kam dimu'an ngan ambanan-bi ako, kay yayto i maka'anna' si Kasuratan: Maratayun-ko i mangngataman, sanglit agwararak i mga karniro. ");
INSERT INTO abx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero kahuman si kabanhaw-ko, agdahulo ako si ka'am pan Galilea.” ");
INSERT INTO abx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Amahalling dayon si Pedro, “Bisan kon pama'amban i dimu'an, ga'i ako pa'amban si ka'aw!” ");
INSERT INTO abx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Anaruman may si Jesus, “Sumatan-ta kaw si kamatu'uran, mismo ina'anto sangom, antis si kaduwa tutturu'ok, agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo.” ");
INSERT INTO abx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero amahalling dina makusog si Pedro, “Ga'i nan sahimu-ko pagdidiwaray nan nga ga'i kaw sakilala-ko, bisan pa kon kinahanglan ako amatay huwang si ka'aw!” Ngan da'inan liwat sinan i mga pinahallingan-na si ditangnga' pa. ");
INSERT INTO abx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mangno anakka kas Jesus si lugar nga nagtanuman kakayuhan nag'arunan Getsemane. Agpinugad-na i mga inadalan-na, “Ato kam dahulo agpanlumpagi' hasta nga ga'i ako atapos ag'ampo'.” ");
INSERT INTO abx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pero agpabaya'-na kas Pedro, Santiago pati' Juan paghuwang si iya pan dahulu'an. Agtikang pagsamok i paminsada-na ngan agpanangis gayod i kasing-kasing-na. ");
INSERT INTO abx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Si kaliyat-liyatan agpinugad-na mga iya, “Masurub'on gayod i kasing-kasing-ko, ngan day mabubukahon tungod si paddi-na. Ato kam hamok basi' sa'abat-ko i paghuwang-bi.” ");
INSERT INTO abx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ngan pakadahulu'an-na si Jesus si tallungan, pa'akkom iya ngan ag'ampo' nga kon ahimo, kalihisan iya si mga pag'antus-na siray ka'urason. ");
INSERT INTO abx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aminugad iya, “Tay, Tatay-ko, sahimu-mo i dimu'an. Ala'on to kupa si kasakitan tikang si ako, pero dakaw agtumanon i katuyu'an-ko hamok, kundi' i katuyu'an-mo gayod.” ");
INSERT INTO abx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mangno pabwiltay to si mga iya ngan satakkahan-na nga agparapamaturi na dina. Sanglit agpukaw-na si Pedro si pagpatilaw, “Simon, ay kay agparapamaturi kam? Ga'i ba' kam agpakakaya pagpapiraw bisan un'ura hamok paghuwang si ako? ");
INSERT INTO abx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Agkallata kam ngan ag'ampu'a kam basi' sa'agwanta-bi i mga pagpurbar si mga pagtutu'u-bi. Awili i inisipan pagtuman si mga katuyu'an-na si Diyos, pero maluya pag'alagad i kada'an kina'iya.” ");
INSERT INTO abx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pa'amban gihapon si Jesus si mga iya ngan ag'ampo' utro nga pariho hamok i mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Katapos, agbwilta-na i mga inadalan-na ngan satakkahan-na namay nga agparapamaturi dina kay mga mabuwat na gayod i mga mata-na. Ngan pakakallat-na na mga iya, ga'i mga iya agpakatu'anan kon ay i mga papahallingun-na. ");
INSERT INTO abx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mangno pabwilta si Jesus si katallo bisis ngan agpaminugad-na, “Agparapamaturi pa ba' kam gihapon? Ag'ikmata kam! Iya nayto i uras nga trarayduran na i Pinili' A'a ngan papa'intrigahon na iya si mga makasasala'. ");
INSERT INTO abx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Banguna na kam anan kay pada'iray na kita kam. Kulawi-bi ro, awira' na i magtraydor si ako.” ");
INSERT INTO abx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Si pagparapahalling-na pa si Jesus, hintak anakka si Judas nga addangan si Dusi. Aniya' malabbat kahuruwangan-na nga nagpamabawa-na si mga puno' paraghalad, mga paragturo' bala'od, pati' si mga mata'o kamabu'utan. Aniya' mga ispada-na sito mga a'a pati' mga batuta. ");
INSERT INTO abx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Antis sinan, agsumatan-na dahulo si magtraydor i mga kahuruwangan-na kon ay i pangngilalahan si darakupun-na mga iya: “I lalla inuruk-ko, iya i nagkinahanglan-bi. Dakupu-bi dayon iya ngan si pagbawa-bi, bantayi-bi iya pahalap.” ");
INSERT INTO abx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ngan pakatapit-na si Judas si Jesus, mangumusta dayon iya, “Rabbi!” ngan diritso ag'uruk-na. ");
INSERT INTO abx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sanglit, agdakup-na mga iya si Jesus ngan agpugulan-na. ");
INSERT INTO abx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero aniya' magtutunggo matapit si mga iya manhulkot si ispada-na ngan diritso agtigbas-na i rilihugun-na si gilalabawi paraghalad, ngan akapalungan to. ");
INSERT INTO abx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Amahalling dayon si Jesus, “Ribildi ba' ako nga kinahanglan kam gayod agbawa si mga ispada-bi pati' si mga batuta-bi nan pagdakop si ako? ");
INSERT INTO abx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Balang allaw aghururuwang kita kam ari si mga hawan-na si templo si pagparaturu'-ko, ngan ga'i may ako agdakup-bi. Pero kinahanglan atuman i maka'anna' si Kasuratan.” ");
INSERT INTO abx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Agpata'anan-na iya si dimu'an mga inadalan-na ngan agpanrarabunos pag'amban. ");
INSERT INTO abx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aniya' addangan burubata' mamungyod kas Jesus nga agtapis hamok. Ngan pakapugol liwat kunta' si iya, ");
INSERT INTO abx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","palahi iya nga gana' gayod sul'ut-na kay abilin na dina i nagpatapis-na ari si magpamugol. ");
INSERT INTO abx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mangno agbawa-na mga iya si Jesus pada'iray si ruma'-na si gilalabawi paraghalad. Agtiriripon ari i dimu'an mga puno' paraghalad, i mga mata'o kamabu'utan, hasta pa i mga paragturo' bala'od. ");
INSERT INTO abx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngan amungyod si Pedro si mga iya nga apartado ngan akasallod to si hawan-na si ruma'-na si gilalabawi paraghalad. Aningkarag iya ari huwang si mga gwardya, ngan agpadarang iya si nagrambak baga ari. ");
INSERT INTO abx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Agparapanganda' i mga puno' paraghalad hasta pa i ditangnga' mga myimbro si Kunsiho mga ibidinsya kuntra si Jesus, basi' sapamatay-nay to mga iya, pero gana' mga sapaguwa'-na. ");
INSERT INTO abx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aniya' malabbat magpamahalling kabubullu'an kuntra si Jesus pero ga'i agsi'uruyon i mga pinahallingan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Si katapus-tapusan aniya' si mga magtambong ari nga pamatunggo pagtistigos kinabubullu'an, ");
INSERT INTO abx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sapamati'an kami' i nagsumat-na nga bungkag-na kuno' i templo nga hinimu-na si a'a, ngan anindog iya la'in nga ma'in hinimu-na si a'a sallod hamok si tallo allaw.” ");
INSERT INTO abx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero hasta may to mga a'a, ga'i liwat agsi'uruyon i mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kahuman sinan, anunggo i gilalabawi paraghalad atubang si dimu'an ngan agtilaw-na si Jesus, “Gana' ba' sapasaruman-mo si mga iya? Ay kay agpakapahalling mga iya da'inan sinan?” ");
INSERT INTO abx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ga'i agsibu'-sibo' si Jesus ngan ga'i anaruman bisan adda allingon. Agtilaw-na iya gihapon si gilalabawi paraghalad, “Ka'aw ba' i Tinu'inan Mannanalwas, i Dadi'-na si Pinakatalahuron?” ");
INSERT INTO abx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Oho'. Ako!” anaruman si Jesus. “Ngan papakulawon kam si Pinili' A'a nga agtingkulo' si kawanan-na si Makagagahom, ngan papakulawon kam liwat si iya ari si panganod si pagdadara'un-na!” ");
INSERT INTO abx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aggisi'-na dayon si gilalabawi paraghalad i sutana-na ngan mangisog, “Ga'i na kita kam agkinahanglan mga tistigos pa! ");
INSERT INTO abx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sapamati'an-bi na nga aglalabawan-na sito a'a i Diyos. Ay i pinahusgar-bi si iya?” Agpatukan-na mga iya dimu'an si Jesus nga kamatayon i angay si iya. ");
INSERT INTO abx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mangno nagpararukda'an si Jesus si ditangnga'. Nagtambunan i mga mata-na ngan nagparapuniti iya. Agparapatilawan-na mga iya sa'uru'addangan, “Tiguhon daw kon say ray!” Mangno nagbawa iya si mga gwardya ngan nagparadabal. ");
INSERT INTO abx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ngan ari pa si gawas si Pedro, ari si hawan, aniya' si mga kabulig-na danda si gilalabawi paraghalad nga palabay. ");
INSERT INTO abx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ngan pakakulaw-na si kabulig si Pedro nga agparapadarang, agparahiling-hiling-na iya ngan aminugad, “Huwang-na liwat kaw si Jesus nan nga taga Nasaret.” ");
INSERT INTO abx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero agdidiwaray iya si pagpinugad, “Ambot oy, gana' sa'urup-urupan-ko si nagparayawit-moy nan.” Pa'amban si Pedro ngan patapit iya andang si pwirtahan-na si kuta'. ");
INSERT INTO abx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngan pakakulaw-na si kabulig nga ari pa iya, agsumatan-na liwat i mga magpanunggo ari, “Addangan iya si mga kahuruwangan-na.” ");
INSERT INTO abx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero agdidiwaray gihapon si Pedro. Kata'ud-ta'uran aniya' namay si mga magparapanunggo ari nga agpaminugad, “Sigurado nga addangan kaw si mga kahuruwangan-na, kay taga Galilea liwat kaw.” ");
INSERT INTO abx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mangno amahalling si Pedro, “Bisan pa ako pugutan-bi kon ga'i ako agsumat si kamatu'uran, akatu'anan i Diyos nga ga'i ako angilala si nagparatukuy-bi nan lalla!” ");
INSERT INTO abx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mismo siray uras kinabati'an i kaduwa tutturu'ok. Tungod sinan, sa'intuman-na dayon si Pedro i pinahallingan-na si Jesus: “Antis si kaduwa tutturu'ok, agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo,” ngan anhintak iya andinamag. ");
INSERT INTO abx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ngan kanalungan, aghimu-na si mga puno' paraghalad i mga planu-na huwang si mga mata'o kamabu'utan pati' si mga paragturo' bala'od, nga iya i bug'os gayod Kunsihu-na si mga Hebro. Agpagapus-na mga iya i tamburu'-na si Jesus, ngan agpabawa-na basi' apa'intriga ari si Pilato. ");
INSERT INTO abx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Agtilaw-na si Pilato si Jesus, “Ka'aw ba' i hadi'-na si mga Hebro?” Anaruman may si Jesus, “Oho', ngan ka'aw i magpaguwa' sinan.” ");
INSERT INTO abx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mangno agparapamasumbung-na si mga puno' paraghalad si Jesus si malabbat mga mara'at binuhatan ");
INSERT INTO abx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","sanglit, amatilaw gihapon si Pilato, “Gana' ba' saruman-mo? Sapakalihan-mo ba' kalabbat-nay nan si mga sumbung-na kuntra si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ga'i anaruman si Jesus ngan iya gayod i nag'usahan-na si Pilato. ");
INSERT INTO abx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kundi' aniya' kabatasanan-na si Pilato kon Pyista pagpalibri addangan priso nga nagpalaku-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Siray uras aniya' addangan priso nag'arunan Barabas nga adakop huwang si mga igkasi-na ribildi. Agpakamatay mga iya ari si pagsaramukan-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sanglit pamadugok si Pilato i kalabbatan magpantambong ari pagpalako nga himu-na namay si mga iya i nagparabuhat-na si balang ta'on kon Pyista. ");
INSERT INTO abx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Amatilaw si Pilato, “Aruyag ba' kam nga yayto pinalibri-ko nagpinugad-bi to, ‘hadi'-na si mga Hebro’?” ");
INSERT INTO abx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Agda'inan si Pilato kay akatu'anan iya nga agpa'intriga-na si mga puno' paraghalad si Jesus si iya tungod hamok si ka'awa'-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero agsamuk-na si mga puno' paraghalad i mga a'a para hamok akalibri si Barabas. ");
INSERT INTO abx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Amatilaw si Pilato si mga a'a, “Kon sugad, pa'i-ko may to nagpinugad-bi to, ‘hadi'-na si mga Hebro’?” ");
INSERT INTO abx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Anurakaw dina mga iya, “Papaku'on iya si kudos!” ");
INSERT INTO abx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Amatilaw gihapon si Pilato, “Kapa'i may? Ay i mara'at binuhatan-na sito a'a?” Pero agkukusog dina i turakaw-na si mga a'a, “Papaku'on iya si kudos!” ");
INSERT INTO abx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aruyag si Pilato pagpalipay si mga a'a, sanglit agpalibri-na si Barabas. Mangno, kahuman-na agpalatigo si Jesus, agpa'intriga-nay to dayon si mga sundalo nga tipapako' si iya. ");
INSERT INTO abx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nagbawa si Jesus si mga sundalo pada'iray si hawan-na si palasyu-na si gubirnador, ngan agban'u-na mga iya pagtiriripon i ditangnga' pa mga sundalo nga sakop si batalyun-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nagbistihan si Jesus si hadi'anon pammakurumbot nga kulor igot. Mangno, aghimo mga iya likaw tikang si tangulon ngan nagpakuruna si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Agtikangan-na mga iya pagturakaw, “Malanga pa kunta' i kinabuhi'-na si hadi'-na si mga Hebro!” ");
INSERT INTO abx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sa'uru'addanganay mga iya agparapakol si iya si adda inutod andang bigahaw ari. Nagpararukda'an iya ngan agparapanluhod to atubang si iya pagtahod kuno' si iya. ");
INSERT INTO abx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Katapos si pagparalangkag-na mga iya sito, naghugkas i pammakurumbot kulor igot ngan agbadu'an-na gihapon mga iya si kalugaringun-na panapton. Mangno agbawa-nay to mga iya pan gawas basi' apapako' si kudos. ");
INSERT INTO abx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aniya' lalla nag'arunan Simon nga padulhog siray uras. Taga sunsari'i to iya si syudad Cirene nga tatay-na kas Alejandro pati' Rufo. Ngan pakatupu'-na si Simon kas Jesus, sapirit-na iya si mga sundalo pagpalangkit si kudus-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Agbawa-na mga iya si Jesus si tagudtod nag'arunan Golgota, nga i kahulugan-na, takuluk-na si minatay. ");
INSERT INTO abx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ngan ari na mga iya, agpa'inum-na kunta' mga iya si Jesus bino nga nagsalakutan mirra pero ga'i anginom. ");
INSERT INTO abx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mangno agpapaku'-na mga iya si Jesus si kudos. Agpararti-na mga iya i mga sul'ut-na mangno agpa'agi-na mga iya si ripa kon ay i mga sabawa-na. ");
INSERT INTO abx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nwibi si nalong ngan pagpapako' si Jesus si kudos ");
INSERT INTO abx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ngan aniya' makasurat ari sumbong kuntra si iya nga da'ito sito: I HADI'-NA SI MGA HEBRO ");
INSERT INTO abx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aniya' liwat duwangan bandido nga nagpapako' si mga kudus-na tingpid si Jesus, i addangan ari si kawanan-na, ngan i addangan may ari si kawiri-na. ");
INSERT INTO abx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nagparatabri'an iya si mga manlalabay ngan nagparatamay. Sigi mga iya panyayawit, “Hoy! Ka'aw i magpinugad nga bungkag-mo i templo ngan tindug-mo gihapon sallod si tallo allaw! ");
INSERT INTO abx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pahaw'asa anan si kudos nan ngan salbaron i kalugaringun-mo!” ");
INSERT INTO abx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Purupariho liwat sinan i mga langkag-na si mga puno' paraghalad pati' si mga paragturo' bala'od. Sigi liwat mga iya panyayawit, “Sasalbar-na i la'in a'a, pero i kalugaringun-na lugod, ga'i! ");
INSERT INTO abx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kinahanglan pahaw'as i Tinu'inan Mannanalwas ina'anto anan si kudos nan! Kinahanglan pahaw'as i Hadi'-na si Israel basi' agpakakulaw kami' ngan agpanutu'o!” Bisan i mga nagpamapako' tingpid si iya, agparatamay liwat si iya. ");
INSERT INTO abx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ngan ka'amudtuhan, anlu'om i bug'os pitak palibot ari mga tallo uras. ");
INSERT INTO abx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pangalastris na, amahalling makusog si Jesus, “Eloi, Eloi, lama sabachthani?” nga i kahulugan-na, “Diyus-ko, Diyus-ko, kapa'i may kay ag'ambanan-mo na ako?” ");
INSERT INTO abx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngan pakapamati'-na si ditangnga' magpanunggo matapit si iya, agpaminugad to, “Pamati'i-bi ngani'! Agban'u-na si Elias!” ");
INSERT INTO abx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aniya' addangan maglalahi pada'iray si Jesus. Agbawa iya ispungha hinumog si malassom na bino ngan agpatulu-nay to si adda lingkawan basi' anakka ari si bawa'-na si Jesus. Aminugad iya, “Hala, angantahak kita kam. Kulawan-ta kam kon anakka si Elias nga haw'as-na iya anan si kudos!” ");
INSERT INTO abx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pakaturakaw-na si Jesus, pahuway na dayon i paghingasung-na. ");
INSERT INTO abx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ari si templo siray uras, hintak agisi' si duwa parti i pannalingkop kurtina, tikang si dyata' diritso pan hawod. ");
INSERT INTO abx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aniya' sinturyon magtutunggo atubang si kudos. Ngan pakakulaw-na sito kon pinapa'i agturakaw ngan amatay si Jesus, akapinugad iya, “Sigurado nga yaynan a'a i Dadi'-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aniya' liwat mga danda magparapamantaw hamok si katalahan. Huwang si mga iya kas Maria Magdalena, si Maria nga nanay-na kas Joset pati' Santiago nga i anga'-na Sirari hasta pa si Salome. ");
INSERT INTO abx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iyay nan i mga danda magparapamaya'-baya' si Jesus pagpanginano si mga kinahanglanun-na ngan ari pa iya si Galilea. Ngan malabbat liwat mga danda ari nga magpamaya' si Jesus ngan pada'iray-na si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Siray allaw, Bispira na si Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aniya' talahuron myimbro si Kunsiho nag'arunan Jose nga taga sunsari'i si bungto Arimatea, ngan addangan liwat iya si mga magparapanimulat si paghadi'-na si Diyos. Sanglit tungod kay kuhap na, amintas iya pagpada'iray si Pilato pagpalako si bangkay-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ag'usa si Pilato si pakapamati'-na nga minatay nayto, sanglit aglihog iya addangan pag'ala' si sinturyon basi' satilaw-na kon minatay na ba' gayod. ");
INSERT INTO abx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngan pakakatu'an-na tikang si sinturyon mismo nga ungod, agtugutan-na si Jose pag'ala' si bangkay. ");
INSERT INTO abx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agballi si Jose katsa, aghaw'as-na i bangkay ari si kudos, ngan agputus-nay to si katsa. Mangno aghulid-na si adda kwiba panlalabbungan nga naghimo si pangpang ari. Agpaligid iya adda mahaya bato pagsagpo' si pwirtahan-na si naglabbungan. ");
INSERT INTO abx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Siray uras ari pa kas Maria Magdalena pati' si Maria nga nanay-na si Joset, ngan sakulawan-na mga iya kon singnga naghulid si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ngan pakahuman-na si Allaw Pandidiskanso, kas Maria Magdalena, Salome, pati' si Maria nga nanay-na si Santiago agpamalli mga pasangngit pammabu'bo' si bangkay-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ngan pada'iray-na mga iya si naglabbungan, atab pa gayod si Duminggo nalong, agsisirak pa hamok i allaw. ");
INSERT INTO abx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Si paglalangnganan, agsipurupatilaway mga iya, “Say si kita kam i mamaligid si bato tikang si pwirtahan-na si naglabbungan?” ");
INSERT INTO abx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero ngan pakapantaw-na mga iya si kwiba, sakulawan-na mga iya nga nagpaligid na dina i bato bisan kon bali haya. ");
INSERT INTO abx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Si pasallud-na mga iya si naglabbungan, akakulaw mga iya ari adda dadi'-dadi'on pa lalla nga disutana puti'. Agtingkulo' iya si kawanan ngan nginarat gayod mga iya. ");
INSERT INTO abx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Dakam agkataralaw!” lingun-na si lalla. “Agpara'anda'-bi si Jesus taga Nasaret, nga nagpapako' si kudos. Ga'i na iya ato; abanhaw iya! Kulawi-bi to, yayto i naghuliran si iya. ");
INSERT INTO abx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sanglit pada'iraya na kam ngan sumati-bi si Pedro hasta pa i ditangnga' mga inadalan-na, ‘Agdahulo iya si ka'am pan Galilea; sakulawan-bi iya ari pariho si nagsumat-na si ka'am siray.’” ");
INSERT INTO abx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Agkurug-kudog gayod i mga danda ngan agkaralingling sanglit agrarabunos mga iya pagawas si kwiba. Ngan tungod si bali mga katalaw-na, ga'i mga iya agsumat si bisan say. ");
INSERT INTO abx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kahuman si pakabanhaw-na si Jesus, atab si Duminggo, agpakulaw iya primiro si Maria Magdalena, nga nagpapindahan-na si pito' mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Agpada'iray-na i mga magpamaya' siray si Jesus nga agparapamanangis ngan agparapandinamag pa, ngan agpanumatan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngan pakabati'-na mga iya si mga allingun-na si Maria nga allom si Jesus ngan iya mismo i makakulaw, ga'i mga iya agpanutu'o. ");
INSERT INTO abx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kahuman sinan, ngan patakod i duwangan si mga iya, agpakulaw-na mga iya si Jesus si la'in namay pa'agi. ");
INSERT INTO abx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Agbwilta mga iya dagos ngan agpanumatan-na i ditangnga', pero ga'i liwat mga iya nagtutu'o. ");
INSERT INTO abx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Si katapus-tapusan, agpakulaw-na si Jesus i Unsi si pagpamangan-na mga iya. Ag'isugan-na mga iya tungod kay kulang mga iya pagtapod ngan mga makudat gayod i mga takuluk-na pagtutu'o si mga magpakakulaw si iya kahuman si kabanhaw-na. ");
INSERT INTO abx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Agsumatan-na mga iya si Jesus, “Pada'irayu-bi i bug'os kalibutan ngan pasamwaku-bi i mahalap sumat si dimu'an a'a. ");
INSERT INTO abx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bisan say i magtutu'o huwang i pagpabunyag, iya i taralwason. Ngan bisan say i ga'i magtutu'o, paratukan iya. ");
INSERT INTO abx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yayto i mga pangngilalahan si langitnon kasiguruhan nga purumwanon si mga magpanutu'o: Aniya' makapapinda si mara'at espirito pina'agi si paggamit si arun-ko; aniya' makapahalling si la'in linggwahi nga ga'i sata'uhan-na; ");
INSERT INTO abx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","gana' mara'at manakka si mga iya bisan kon aka'addo' mga iya si mga malara sawa o aka'inom mga iya hilo; ngan sapahalap-na mga iya i maburong pina'agi si pagpadu'on si mga palat-na.” ");
INSERT INTO abx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Katapos si pagpahalling-na si Ginu'o Jesus si mga iya, a'alsa iya pan langit ngan aningkulo' si kawanan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mangno agpamada'iray i mga inadalan-na si dimu'an lugar ngan agparapamasamwak si mahalap sumat. Agparahuwang si mga iya i Paragdalom ngan agpamatu'uran-na i allingun-na pina'agi si mga naghimu-na mga pangngilalahan si langitnon kasiguruhan. (9) Agpada'iray-na si mga danda kas Pedro ngan agsumatan-na mga iya diki'it mahi'unong si dimu'an nagpasumat si mga iya. (10) Kahuman sinan, makigpasamwak-na si Jesus si mga inadalan-na i sagrado ngan gana' pagliliwatun-na sumat mahi'unong si gana' katapusan-na katalwasan tikang si sirangan pada'iray si katundan.");
INSERT INTO abx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Talahuron Teofilo, Akatu'anan kaw nga malabbat i magpanalinguha pagtipon ngan pagsurat si mga magpaka'agi na hinabo' mahi'unong si Jesu-Kristo, nga atuman si uras nga allom pa kami' magpanutu'o sito. ");
INSERT INTO abx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Asurat to nga gana' gayod pagkala'inan-na si mga sakatu'anan-ta tikang si mga magpakasayod gayod si panikangan ngan mga iya mismo i magparapasamwak sito mga allingon. ");
INSERT INTO abx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sanglit talahuron Teofilo, tungod kay agmato gayod ako si pagparapanginsayod sito dimu'an tikang si panikangan, akahuna'-huna' ako nga angay kon akasurat ako adda nga hinamis ngan agsurunud-sunod na para atuman i katuyu'an-mo. ");
INSERT INTO abx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Agsurat-koy to basi' akatu'anan kaw nga akatapuran i mga nagparaturo' si ka'aw. ");
INSERT INTO abx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Siray mga panahon ngan si Herodes i hadi' si Judea, aniya' paraghalad nag'arunan Sacarias nga sakop si grupu-na si mga paraghalad Abias. I alla-na nag'arunan Elisabet tikang liwat si mga paraghalad grupu-na si Aaron. ");
INSERT INTO abx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Si pangulawan-na si Diyos matadong gayod mga iya duwangan ngan gana' barasulon si mga iya si dimu'an sugu'-na pati' mga tugun-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero ga'i mga iya agpandadi' hasta nga agkamaraktong tungod si Elisabet. ");
INSERT INTO abx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Siray mga allaw, pala'in-la'in grupo si mga paraghalad i maghimo si mga buruhaton ari si templo si adda duminggo. Kabatasanan si kada grupo i pagpili' pina'agi si ripa kon say i pasallod si templu-na si Paragdalom pagtubod si insinso. Adda allaw, ngan turnu-na na si grupu-na si kas Sacarias, ngan huwang iya sito mga buruhaton atubang si Diyos, iya i mapili' pagsallod si templo. ");
INSERT INTO abx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngan anakka na i uras pagtubod si insinso, sigi may parangadyi'ay i dimu'an mga para'ampo' ari si gawas. ");
INSERT INTO abx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mangno aniya' paluwa' linihug-na anghel si Paragdalom si kawanan banda si uru'altar pannunuburan. ");
INSERT INTO abx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pakakulaw-na si Sacarias, nginarat iya ngan tinakka katalaw. ");
INSERT INTO abx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","“Dakaw atalaw, Sacarias,” lingun-na si anghel. “Sapakalihan-na si Diyos i nagpara'ampu'-mo. Agdadi' lalla i alla-mo, ngan kinahanglan Juan i pina'arun-bi. ");
INSERT INTO abx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mahaya gayod i kalipay-bi si iya ngan anlaksi may i malabbat a'a si paka'allum-na, ");
INSERT INTO abx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tungod kay labaw iya si pangulawan-na si Paragdalom. Ga'i iya ag'inom bino o bisan ay makalalanguha irimnon, ngan i Espirito Santo i magdalom si iya tikang pa gayod si pagburud-na si iya si nanay-na. ");
INSERT INTO abx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Malabbat mga a'a-na si Israel i sapabalik-na gihapon si mga pagtu'u-na si Paragdalom, i Diyus-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Papadahulu'on iya si Paragdalom nga huwang i kina'iya pati' gahom nga pariho si tawa'-na si Elias pagpabalik si gugma'-na si mga tatay pada'iray si mga dadi'. Papadahulu'on iya basi' sapabwilta-na i dati mga dunung-na si mga magparapakangbungul-bungol pariho si tawa'-na si mga matadong a'a. Iyay nan i nagpapadahulu'an si iya basi' andam i mga a'a si pagtakka-na si Paragdalom.” ");
INSERT INTO abx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amatilaw si Sacarias si anghel, “Pinapa'i pakasiguru-ko nga a'ungod nan? Maktong na ako ngan da'inan may liwat i alla-ko.” ");
INSERT INTO abx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Ako si Gabriel nga tinapuran-na si Diyos. Aglihug-na ako pagtuli si ka'aw sito mahalap sumat. ");
INSERT INTO abx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero, tungod kay ga'i kaw anutu'o si mga allingun-ko, angula kaw tikang ina'anto ngan ga'i kaw akapahalling tubtob si allaw nga atuman to, nga sigurado anakka si tama' uras.” ");
INSERT INTO abx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Siray uras, agpara'antahak-na na si mga a'a si Sacarias ngan ag'usa gayod mga iya kon ay kay maliyat iya ari si sallud-na si templo. ");
INSERT INTO abx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Si pagawas-na, ga'i na iya akabagawan. Akahuna'-huna' dagos mga iya nga aniya' maka'urusa kurulawan sakulawan-na ari si templo, kay sigi na hamok iya pasabot ngan ga'i na akayawit. ");
INSERT INTO abx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pakakumpli-na na si turnu-na ari si templo, agbalik iya. ");
INSERT INTO abx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ga'i agliyat, agburod i alla-na ngan ga'i agguwa'-guwa' si ruma' tubtob si kalima bulan. ");
INSERT INTO abx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“I Paragdalom sito i magbuwan si ako. Yayto na i mga allaw nga agpakulaw-na na i pagpalangga'-na si ako ngan ag'ala'-na na i kamamalu'an-ko si mga a'a tungod si ga'i pagdadi'-ko,” lingun-na si Elisabet. ");
INSERT INTO abx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ngan panakka-na si annom bulan si pagburudan-na si Elisabet, aglihug-na gihapon si Diyos i anghel nag'arunan Gabriel pan Nasaret, adda baryo si prubinsya Galilea. ");
INSERT INTO abx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nagpapada'iray iya ari si adda dangkanda nga ga'i pa akalabutan nag'arunan Maria nga papakasalon si addangan nag'arunan Jose, nga tikang si mga ka'uru'ampuhan-na si Hadi' David. ");
INSERT INTO abx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pada'iray dayon i anghel ngan aminugad, “Kumusta kaw! Ka'aw i pinalangga' si dimu'an. Matapit si ka'aw i Paragdalom.” ");
INSERT INTO abx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aburong ngan ag'usa gayod si Maria sito mga allingon ngan parapinsar-na kon ay i karuyag sidngun-na sito pangumusta. ");
INSERT INTO abx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Dakaw atalaw, Maria,” lingun-na si anghel, “kay ka'aw i makakarawat si pagpalangga'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Agburod kaw ngan lalla i dadi'-mo. Kinahanglan Jesus i pina'arun-mo. ");
INSERT INTO abx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Labaw gayod iya ngan ararunan, Dadi'-na si Gilalabawi Diyos. Purumwanun-na si Paragdalom Diyos si iya i trunu-na si kapapu'an-na Hadi' David. ");
INSERT INTO abx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iya i magdalom si ka'uru'ampuhan-na si Jacob ngan gana' katapusan-na si ginhadi'an-na.” ");
INSERT INTO abx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Pinapa'i may nga atuman nan nga ga'i pa may ako akalabutan si bisan say lallaha?” lingun-na si Maria. ");
INSERT INTO abx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anaruman may i anghel, “Pahuwang si ka'aw i Espirito Santo ngan akalandungan kaw si gahum-na si Gilalabawi Diyos. Sanglit i sagrado dadi' nga ma'allom, iya i ararunan Dadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hasta ngani' i paryinti-mo Elisabet, tikaka'alluman na. Bisan kon ga'i kunta' iya pwidi agdadi' hasta nga anakka iya si kamaktungon, i ka'annom bulan na dina i pagburudan-na, ");
INSERT INTO abx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kay gana' nga ga'i sahimu-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anaruman gihapon si Maria, “Adda hamok ako rilihugun-na si Paragdalom. Atuman kunta' si ako i mga allingun-mo.” Mangno pa'amban dayon si iya i anghel. ");
INSERT INTO abx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ga'i agliyat, ag'andam dayon si Maria pagpada'iray si bungtu-na kas Sacarias ari si katagudturan parti si Judea. ");
INSERT INTO abx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngan panakka-na si ruma'-na mga iya, mangumusta dayon iya si Elisabet. ");
INSERT INTO abx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Si pakabati'-na si Elisabet si busis-na si Maria, angiwa dagos i dadi' ari si battung-na ngan i Espirito Santo i magdalom si iya. ");
INSERT INTO abx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akapinugad dayon iya makusog, “Pinalangga' kaw gayod labaw si dimu'an mga danda ngan pinalangga' liwat binurud-moy nan! ");
INSERT INTO abx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Day ma'in makatutu'o nga ako i sapili'-mo pagbisita, ka'aw nga nana-na si Paragdalum-ko. ");
INSERT INTO abx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngan pakabati'-ko si paman'u-mo, angiwa dayon i dadi' si battung-ko tungod si kalipay-na. ");
INSERT INTO abx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Malipayon kaw tungod si pagtutu'u-mo nga atuman si ka'aw i mga allingun-na si Paragdalum-ta.” ");
INSERT INTO abx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mangno agrayhak si Maria pagbusngal, “Agdayaw-ko i Paragdalom ");
INSERT INTO abx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ngan bali kalipayan i kasing-kasing-ko tungod si Paragsalbar-ko Diyos, ");
INSERT INTO abx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kay manginano si ako nga adda hamok rilihugun-na, ubos si kamutangan. Tikang ina'anto, pirinugarun-na si dimu'an mga a'a hasta si mga titakka pa panahon, nga ako i pinakamalipayon a'a, ");
INSERT INTO abx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tungod si mga urusahon sahimu-na si Makagagahom si ako, sagrado i arun-na. ");
INSERT INTO abx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anakka i kalu'uy-na si mga magpanahod si iya, tikang si ina'anto panahon hasta si mga tisunod pa. ");
INSERT INTO abx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Agpakulaw-na i gahum-na pina'agi si buhat-na, pagwarak si mga mahaya dalum-na. ");
INSERT INTO abx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ag'ala'-na i mga puno' tikang si mga pwistu-na, ngan agpamalabaw-na i mga dara'ug-da'ugon. ");
INSERT INTO abx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Agpakuntintu-na si mga kahalapan i mga anggana' pero agpapinda-na i mga mayaman nga gana' mga binawa-na. ");
INSERT INTO abx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Agbuligan-na i mga a'a-na si Israel, nga magpanirbi si iya, ngan ag'intom si pagkalu'oy ");
INSERT INTO abx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","si Abraham pati' si mga ka'uru'ampuhan-na hasta si kahastahan, kay iyay nan i sa'ad-na pada'iray si kapapu'an-ta kam.” ");
INSERT INTO abx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tallo bulan dina i pag'istar-na si Maria ari si ruma'-na si kas Elisabet myintras iya agbalik. ");
INSERT INTO abx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Panakka-na si kasiyam bulan si pagburud-na si Elisabet, aka'alluman iya ngan lalla i dadi'-na. ");
INSERT INTO abx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pakabati'-na si mga bugtu'-na hasta si mga katiringpid-na si kalu'oy nagpakulaw-na si Paragdalom si iya, pahuwang may mga iya si kalipayan-na. ");
INSERT INTO abx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagwalo' allaw-na si dadi', aniya' magpamada'iray pagturi' sito pagpakilala nga Hebro iya. I karuyag-na kunta' mga iya nga inarunan i dadi' Sacarias pina'irog si tatay-na. ");
INSERT INTO abx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero aminugad si Elisabet, “Ma'in! Kinahanglan Juan i pina'aron si iya.” ");
INSERT INTO abx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Anaruman dina mga iya, “Pero gana' bugtu'-bi nga da'inan sinan i arun-na?” ");
INSERT INTO abx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sanglit agpasabut-na mga iya i tatay pagpatilaw kon ay i saruyagan-na papa'arunon si dadi'. ");
INSERT INTO abx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Amalako pannuratan si Sacarias ngan ag'usa gayod mga iya kay i nagpasurat-na, “Juan i arun-na.” ");
INSERT INTO abx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mismo siray uras a'ala' i kangulahan-na ngan akayawit dagos iya ngan agtikang pagpahalling pagdayaw si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Agpa'usa i dimu'an mga katiringpid-na, ngan abantog dagos i mahinabo' si katagudturan parti si Judea. ");
INSERT INTO abx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pakakatu'an-na si dimu'an magpakabati' nga i gahum-na si Paragdalom pahuwang si iya, ag'usa mga iya ngan agsipurupatilaway, “Ay daw i manakka sito dadi' si damuri allaw?” ");
INSERT INTO abx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mangno agdaluman-na si Espirito Santo si Sacarias, i tatay-na si Juan, ngan amahalling si makigpasumat-na si Diyos si iya, ");
INSERT INTO abx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Angay gayod nagdayaw i Paragdalom, i Diyus-na si mga a'a-na si Israel, kay pada'ito iya ngan aglukat-na i mga ginsakupan-na. ");
INSERT INTO abx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aniya' nagpa'undung-na addangan nga gamhanan pagsalbar si kita kam, nga tikang si mga ka'uru'ampuhan-na si rilihugun-na David. ");
INSERT INTO abx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Atuman to si mga pinahallingan-na si mga sagrado paragsumat siray mga panahon nga: ");
INSERT INTO abx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pada'ito iya pagsalbar si kita kam tikang si mga kuntra-ta pati' si magpanhumot si kita. ");
INSERT INTO abx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Agpakulaw-na i kalu'uy-na pada'iray si mga kapapu'an-ta ngan ag'intum-na pirmi i sagrado pagkasarabutan naghimu-na. ");
INSERT INTO abx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yayto i sagrado sumpa' nagpumwan si kapapu'an-ta kam Abraham: ");
INSERT INTO abx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nga salbar-na kita kam si buruhatun-na si mga kuntra-ta, basi' gana' satalawan-ta pagsirbi si iya. ");
INSERT INTO abx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","I pagsirbi-ta si iya tangkod ngan matadong tubtob si katapusan-na si kinabuhi'-ta. ");
INSERT INTO abx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sanglit no', ararunan kaw paragsumat-na si Gilalabawi kay ka'aw i magdahulo si Paragdalom paghawan si pangngagihan-na. ");
INSERT INTO abx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka'aw i tipakatu'an si mga a'a-na nga papa'angkunon si mga katalwasan-na si pagpasaylo si mga sala'-na. ");
INSERT INTO abx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngan yaynan dimu'an tikang si mahigugma'on kalu'uy-na si Diyus-ta kam, sanglit aniya' sirak tikang si langit tidanta' si kita kam. ");
INSERT INTO abx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tipada'ito iya basi' akadanta'an i magpangistar si kalu'uman pati' i magpakatambunan si landung-na si kamatayon, ngan basi' agpakatuttot kita kam si mahalap lalan pangngagihan pada'iray si kamurayawan.” ");
INSERT INTO abx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anhaya i dadi' ngan agdugang pa i kabaskog si kina'iya-na. Ag'istar iya si disyirto tubtob si panahon nga agpahayag-na na i kalugaringun-na si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Siray panahon, aniya' mandu'-na si Emperador Augusto nga kinahanglan agparihistro i dimu'an nga sakop si nasyon Roma. ");
INSERT INTO abx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyay nan i primiro pagpanrihistro si mga a'a ngan paggubirnadur-na si Cerenio ari si Siria. ");
INSERT INTO abx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tungod sinan, agbalik i dimu'an a'a si mga bungtu-na si mga ginikanan-na pagparihistro. ");
INSERT INTO abx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sanglit pa'amban si Jose si Nasaret, adda baryo si prubinsya Galilea, ngan pasagka iya pan Betlehem, Judea. Iyay nan i bungto kina'alluman-na si Hadi' David ngan pada'iray kas Jose kay addangan may iya si mga ka'uru'ampuhan-na. ");
INSERT INTO abx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pada'iray si Jose pagparihistro huwang si Maria i pinahanda-na nga burod na siray uras. ");
INSERT INTO abx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Si pag'istar-na na mga iya ari, iya nayray i kasiyam bulan si pagburud-na si Maria. ");
INSERT INTO abx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka'alluman iya ngan lalla i suhag-na. Agputus-na si Maria i dadi' si amon ngan aghulid-na si adda pammasabsaban kahon tungod kay panno' na i ruma' pandidiskansuhan. ");
INSERT INTO abx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Matapit siray lugar aniya' mga manliliwat karniro nga agpangistar si kapatagan ngan agparapanmangno si mga inataman-na kon sangom. ");
INSERT INTO abx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sinan sangom, aniya' pakulaw si mga iya adda anghel-na si Paragdalom ngan agsiga si mga iya i maka'angayan danta'-na si Paragdalom. Kinulbahan ngan agkataralaw gayod mga iya. ");
INSERT INTO abx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Dakam agkataralaw,” lingun-na si anghel. “Pada'ito ako si ka'am pagpakatu'an si mahalap sumat nga akabuwan mahaya kalipayan para si dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aniya' addangan Paragsalbar ma'allom ina'anto ato si bungtu-nay to si David para si ka'am dimu'an. Iya i Tinu'inan Mannanalwas, nga Paragdalom. ");
INSERT INTO abx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yayto i pangngilalahan nga ungod isturya-koy to: Sa'anda'an-bi i dadi'-dadi' nagtukuy-ko nga nagputos si amon ngan naghulid si adda pammasabsaban kahon.” ");
INSERT INTO abx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kata'ud-ta'uran, hintak pamaluwa' i kalabbatan pa gayod mga kahuruwangan-na man langit ngan aghuruwang mga iya pagdayaw si Diyos si pagpinugad, ");
INSERT INTO abx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Darayawon i Diyos ari si langit, ngan amurayaw i mga pinalangga'-na a'a ato si kalibutan nga magpalipay si iya.” ");
INSERT INTO abx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ngan pabwilta-na si mga anghel pan langit, ag'aradda i mga manliliwat pagpinugad, “Tana kam pan Betlehem kay kulawan-ta kam i hinabo' nga nagpasumat-na si Paragdalom si kita kam.” ");
INSERT INTO abx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sanglit agdadagmit mga iya ngan sa'anda'an-na si Maria pati' si Jose, huwang i dadi'-dadi' nga aglibbak si adda pammasabsaban kahon. ");
INSERT INTO abx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pakakulaw-na mga iya si dadi', agpasamwak-na dayon i dimu'an mga allingon nagsumat si mga iya mahi'unong si dadi'. ");
INSERT INTO abx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Agpa'usa gayod i dimu'an magpakabati' si mga sumat-na si mga manliliwat. ");
INSERT INTO abx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero agparahilum-na si Maria i dimu'an mahi'unong sito. Agpara'isip iya kon ay i karuyag sidngun-na sito ngan ga'i to apara' si inisipan-na. ");
INSERT INTO abx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Si pagpamalik-na si mga manliliwat, bali i mga kalipayan-na ngan agdayaw-na gayod mga iya i Diyos, tungod si dimu'an mga sapakalihan-na pati' si mga sakulawan-na, nga agkapariho gayod si dimu'an nagsumat-na si mga iya si anghel. ");
INSERT INTO abx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ngan pagwalo' allaw-na si dadi', nga iya na i tama' uras si pagpaturi' pagpakilala nga Hebro iya, nag'arunan to iya Jesus kay iya may i aron dati nagpumwan-na si anghel myintras iya nagburod. ");
INSERT INTO abx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ngan sakumpli-na na mga iya i tala'an pagtuman si bala'ud-na si Moises hi'unong si paglimpyo si baha'o maka'alluman, agbawa-na kas Jose pati' si Maria i dadi' pan Jerusalem pagpakatu'an ari si templo nga nagpatubyan nayto si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Agda'inan mga iya sinan kay aniya' maka'anna' si Bala'ud-na si Paragdalom nga, “Kinahanglan nagtagama para si Paragdalom i balang suhag lalla ma'allom.” ");
INSERT INTO abx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Si pariho uras agsalingabut-na mga iya i pagpakatu'an nga limpyado na si Maria pina'agi si pagbawa mga gurulisan sigon si Bala'ud-na si Paragdalom nga agtugon pagpahalad “adda padis sarampati o ma'in ngani' duwa mga dumaraga punay.” ");
INSERT INTO abx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aniya' nag'arunan Simeon mag'istar si Jerusalem. Matadong iya ngan bali karilihuso a'a. Agdaluman-nay to iya si Espirito Santo ngan sigi panimulat si titakka magli'aw si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Agpasabut-na iya si Espirito Santo nga ga'i iya amatay myintras ga'i pa sakulawan-na i Tinu'inan Mannanalwas nga papabawahun-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tungod kay agdaluman-na iya si Espirito Santo, akapada'iray to si hawan-na si templo. Siray uras nagbawa si Jesus si mga mahanak-na ari pagtuman si kabatasanan nga kinahanglanun-na si Bala'od para si iya. ");
INSERT INTO abx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pasallud-na mga iya kugus-na dagos i dadi' si Simeon ngan agdayaw-na i Diyos si pagpinugad: ");
INSERT INTO abx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Amu-ko, tugutin na i rilihugun-mo pagkarawat si murayaw kamatayon nagsa'ad-mo ");
INSERT INTO abx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kay sakulawan-na mismo si duwa mata-ko mannalbar to nagpabawa-mo ");
INSERT INTO abx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nga nagtagama-mo basi' kinakulawan si dimu'an ka'aha'an. ");
INSERT INTO abx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iyay to dadi' i makasana'ag nga agpakatu'anan si kamatu'uran i mga ma'in Hebro, pati' i magbuwan unra si mga ginsakupan-mo nga a'a-na si Israel.” ");
INSERT INTO abx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Agpa'usa gayod i tatay pati' i nanay-na si dadi' si mga allingun-na si Simeon parti si iya. ");
INSERT INTO abx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mangno, agpalako si Simeon si Diyos para si kabubuwasun-na mga iya ngan agpinugad-na i nanay nga si Maria, “Yayto dadi' i nagtagama basi' malabbat ato si Israel i magpakadusmog ngan malabbat may liwat i magpakabangon. Nagtagama iya pagpakulaw si mga katuyu'an-na si Diyos, pero malabbat si iya i ga'i mangabuyon, ");
INSERT INTO abx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kay pina'agi si iya, agpakaguwa' i mga tinago' inisipan-na. Hasta ka'aw huwang si magkabirido' nga day pariho si nagtudyok labasa i kasing-kasing-mo.” ");
INSERT INTO abx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aniya' liwat paragsumat-na danda si Diyos nag'arunan Ana. Dadi'-na iya si Fanuel nga sakop si pamilya Aser ngan maktong na gayod iya. Agtig'ob mga iya dahulo si alla-na pito' ta'on kahuman si pangasal si mga iya ");
INSERT INTO abx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ngan tikang si pakabalu-na, ga'i na iya inallahan hasta nga anakka utsintay kwatro i idad-na. Pirmi iya pada'iray si templo pag'ampo' allaw sangom huwang na i pagpu'asa pati' pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Siray mismo uras, padugok to dayon si mga iya ngan agpasalamat iya si Diyos. Sigi to pahalling mahi'unong si dadi' atubang si dimu'an a'a ari nga agparapanimulat liwat si paglukat si mga a'a nga sakop si pamunu'an-na si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pakahuman-na si dimu'an turumanun-na mga iya ari si templo pagsunod si Bala'ud-na si Paragdalom, agbalik si Jose pati' si Maria pan Galilea ngan diritso si mga tinubu'an-na lugar, Nasaret. ");
INSERT INTO abx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anhaya i dadi' ngan mahalap i pamuhu'-na. Panno' iya si kadunong ngan agpalangga'-na iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Balang Pyista si Paglabay, pada'iray si Jerusalem i mga mahanak-na si Jesus ta'un-ta'on pagpamyista. ");
INSERT INTO abx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ngan pagdusi anyus-na si Jesus, pamada'iray gihapon mga iya pagpamyista tungod kay iya na i kabatasanan. ");
INSERT INTO abx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ari mga iya sallod si pito' allaw gayod kapyistahan myintras agpamalik. Ngan pagpamalik-na na si mga mahanak-na, pabilin si Jesus nga ga'i sakatu'anan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tungod kay i mga pagkagasi-na huwang iya ari si mga magpamalik, sigi hamok mga iya baraktasay hasta nga ag'adda allaw. Mangno agtikangan-na mga iya pag'anda' si mga kaburugtu'an pati' si mga kakurumpaniyahan. ");
INSERT INTO abx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngan ga'i na gayod mga iya sa'anda'an-na, pabwilta mga iya gihapon pan Jerusalem pag'anda' sito. ");
INSERT INTO abx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Si katallo allaw kahuman si pagpamalik-na mga iya, sa'anda'an-na dina mga iya nga agparatingkulo' ari si hawan-na si templo nga makihampang si mga ma'istro ari. Agpamati' to gayod si mga iya ngan sigi patilaw. ");
INSERT INTO abx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ag'usa i dimu'an a'a ari tungod si kalalum-na si pagsabut-na pati' si kalistuhan-na pagsaruman. ");
INSERT INTO abx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ngan pakakulaw-na si mga mahanak-na, bali gayod i mga pag'usa-na. Agpinugad-na iya si nanay-na, “No', ay kay agda'itu-mo kami' sito? Bali na kabaraka kami' si tatay-mo pagpara'anda' si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Anaruman dina si Jesus, “Apa'i may kay agpara'anda'-bi ako? Ga'i ba' kam akatu'anan nga kinahanglan panginanu-ko i mga tawa'-na si Tatay-ko ato si templo?” ");
INSERT INTO abx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero ga'i mga iya agpakasabot si karuyag sidngun-na si mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mangno, amaya' si mga iya i dadi' agbalik pan Nasaret ngan agsunod na gayod si mga karuyag-na. Pero agparahilum-nay to hamok dimu'an si nanay-na. ");
INSERT INTO abx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Akatambahan i kadunung-na si Jesus ngan anhalap i pamuhu'-na. Akatambahan pa liwat i pagpalangga'-na si iya si Diyos pati' si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ngan panakka-na si kakinsi ta'on si pagtinagal-na si Tiberio pagka'emperador, sapili'-na si Diyos si Juan nga dadi'-na si Sacarias pagpahalling si allingun-na ari si disyirto. Si Poncio Pilato, iya i gubirnador siray si Judea, si Herodes may i sari'i si Galilea, i sirari-na may nag'arunan Felipe i sari'i si Iturea pati' Trakonite, ngan si Lisanias may i sari'i si Abilinia. Iyay nan i panahon nga kas Anas pati' si Caifas i mga gilalabawi paraghalad. ");
INSERT INTO abx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agpada'iray-na si Juan i dimu'an mga lugar magpalibot si Suba' Jordan, pagwali si mga a'a nga kinahanglan mga iya agbasol huwang si pagbag'o ngan agpabunyag, basi' apasaylo i mga sala'-na. ");
INSERT INTO abx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tungod sinan atuman i mga allingon maka'anna' si Libru-na si paragsumat Isaias: Aniya' addangan ari si disyirto nga agparapasamwak, “Hawani-bi i aragihan-na si Paragdalom; tadungu-bi i lalan ralangnganan-na. ");
INSERT INTO abx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Arabunuhan i dimu'an kapatagan nga nagpalibutan si mga kabubukiran, ngan paratagon i dimu'an mga buntay pati' mga tagudturon. Taradungon i mga baliko' lalan, ngan haramison i mga garu'-gadu'on. ");
INSERT INTO abx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Papakulawun-na si Diyos i dimu'an mga a'a si titalwas si mga iya.” ");
INSERT INTO abx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Agpinugad-na si Juan i magpanggubok nga tipabunyag si iya, “Mga alisto kam gayod pagpamakunu-kuno! Say i magsumat si ka'am nga agpakalikay kam si titakka kastigu-na si Diyos kon agpamabunyag kam? ");
INSERT INTO abx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Agpakulawa kam dahulo pina'agi si mga buhat-bi nga agpamasol kam huwang si pagbag'o. Ma'in nga agpanarig na kam hamok si mga kalugaringun-bi pagpinugad, ‘Tatay kami' may si Abraham.’ Kay sumatan-ta kam, bisan tikang sito mga kababatuhan akahimo i Diyos mga dadi' para si Abraham. ");
INSERT INTO abx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kay i kastigu-na akapariho si hatsa nga agpabantay-na andang si pu'un-na si mga kakayuhan, ngan bisan ay kayuha nga ga'i agbuwa' mahalap, tinabbong ngan pinabar'og.” ");
INSERT INTO abx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Kon sugad, ay may i angay buhat kami'?” lingun-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Anaruman si Juan, “Angay gayod si ka'am nga mga aniya' nan duwa badu'-na pagbuwan si gana', ngan si mga aniya' nan pagkakan-na, pagbuwan si gana'.” ");
INSERT INTO abx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aniya' liwat magpamadugok mga paragsukot buhis pagpabunyag. Agpamatilaw mga iya, “Ma'istro, ay may i angay buhat kami'?” ");
INSERT INTO abx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Agpinugad-na mga iya, “Dakam agsukot subra si angay surukutun-bi.” ");
INSERT INTO abx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mangno aniya' mga sundalo mamatilaw si iya, “Ay may liwat i angay buhat kami'?” Anaruman may si Juan, “Dakam agparapangwarta si mga a'a ngan dakam agparapamasumbong mga binurubullo' sala' si mga iya. Akuntintuha kam si swildo nagparapangarawat-bi.” ");
INSERT INTO abx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mahaya gayod i mga pagla'um-na si mga a'a ngan aka'anna' si mga inisipan-na nga tingali si Juan na i Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Agsarumanan-na si Juan i mga inisipan-na mga iya dimu'an, “Parti hamok si buwahi' i pagbunyag-ko si ka'am, pero aniya' barantugon nga mas labaw pa i gahum-na. Ma'in ngani' ako angay bisan pagbak'ad si sintas-na si sapatus-na. Burunyagan-na i ditangnga' si mga a'a pagpa'ayop si Espirito Santo, pero burunyagan-na i ditangnga' paghusgar nga akapan'api. ");
INSERT INTO abx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aniya' andang nag'antanan-na tapan basi' sahimaliran-na i mga gini'ok ngan salalin-na ari si kamalig-na, pero papabar'ugun-na i mga babang si gana' kapaparungun-na api.” ");
INSERT INTO abx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aggamit pa liwat si Juan mga pala'in-la'in allingon pag'aghat si mga a'a pati' pagpasamwak si mahalap sumat si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ag'isugan-na si Juan si gubirnador Herodes kay agtig'uban-na i bayaw-na Herodias, huwang i dimu'an mga pala'in-la'in pa mga mara'at binuhatan-na. ");
INSERT INTO abx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngan tungod sinan, akatambahan pa liwat i mga sala'-na si gubirnador kay agpaprisu-na si Juan. ");
INSERT INTO abx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Antis si pakaprisu-na si Juan, sigi parabunyagay i mga a'a ngan agpabunyag liwat si Jesus. Dungan si pagpangadyi'-na, kahuman si pagbunyag si iya, angabri i langit ");
INSERT INTO abx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ngan i Espirito Santo pan hawod pada'iray si iya nga kinakulawan gayod i puhu'-na pariho si adda sarampati. Aniya' liwat kinabati'an busis tikang si langit nga agpinugad, “Ka'aw i Dadi'-ko nga hinigugma'-ko. Alipay gayod ako si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Siray uras, mga traynta anyos na si Jesus si pagtikang-na si trabahu-na para si Diyos. I pagkagasi-na si dimu'an, nga si Jesus, iya i dadi'-na si Jose. Si Jose, iya i dadi'-na si Eli. ");
INSERT INTO abx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli, iya i dadi'-na si Matat, nga dadi'-na si Levi. Si Levi, iya i dadi'-na si Melqui, nga dadi'-na si Jana. Si Jana, iya i dadi'-na si Jose, ");
INSERT INTO abx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","nga dadi'-na si Matatias. Si Matatias, iya i dadi'-na si Amos, nga dadi'-na si Nahum. Si Nahum, iya i dadi'-na si Esli, nga dadi'-na si Nagai. ");
INSERT INTO abx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai, iya i dadi'-na si Maat, nga dadi'-na si Matatias. Si Matatias, iya i dadi'-na si Semein, nga dadi'-na si Jose. Si Jose, iya i dadi'-na si Juda, ");
INSERT INTO abx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","nga dadi'-na si Joan. Si Joan, iya i dadi'-na si Resa, nga dadi'-na si Sorobabel. Si Sorobabel, iya i dadi'-na si Salatiel, nga dadi'-na si Neri. ");
INSERT INTO abx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri, iya i dadi'-na si Melqui, nga dadi'-na si Adi. Si Adi, iya i dadi'-na si Cosam, nga dadi'-na si Elmodam. Si Elmodam, iya i dadi'-na si Er, ");
INSERT INTO abx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","nga dadi'-na si Josue. Si Josue, iya i dadi'-na si Elieser, nga dadi'-na si Jorim. Si Jorim, iya i dadi'-na si Matat, nga dadi'-na si Levi. ");
INSERT INTO abx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi, iya i dadi'-na si Simeon, nga dadi'-na si Juda. Si Juda, iya i dadi'-na si Jose, nga dadi'-na si Jonan. Si Jonan, iya i dadi'-na si Eliakim, ");
INSERT INTO abx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","nga dadi'-na si Melea. Si Melea, iya i dadi'-na si Mainan, nga dadi'-na si Matata. Si Matata, iya i dadi'-na si Natan, nga dadi'-na si David. ");
INSERT INTO abx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David, iya i dadi'-na si Jesse, nga dadi'-na si Obed. Si Obed, iya i dadi'-na si Boas, nga dadi'-na si Salmon. Si Salmon, iya i dadi'-na si Naason, ");
INSERT INTO abx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nga dadi'-na si Aminadab. Si Aminadab, iya i dadi'-na si Admin, nga dadi'-na si Arni. Si Arni, iya i dadi'-na si Esrom, nga dadi'-na si Fares. ");
INSERT INTO abx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Fares, iya i dadi'-na si Juda, nga dadi'-na si Jacob. Si Jacob, iya i dadi'-na si Isaac, nga dadi'-na si Abraham. Si Abraham, iya i dadi'-na si Tare, ");
INSERT INTO abx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nga dadi'-na si Nahor. Si Nahor, iya i dadi'-na si Serug, nga dadi'-na si Reo. Si Reo, iya i dadi'-na si Peleg, nga dadi'-na si Eber. ");
INSERT INTO abx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Eber, iya i dadi'-na si Sela, nga dadi'-na si Cainan. Si Cainan, iya i dadi'-na si Arfaxad, nga dadi'-na si Sem. Si Sem, iya i dadi'-na si Noe, ");
INSERT INTO abx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","nga dadi'-na si Lamec. Si Lamec, iya i dadi'-na si Metusela, nga dadi'-na si Enoc. Si Enoc, iya i dadi'-na si Jared, nga dadi'-na si Mahalalel. ");
INSERT INTO abx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Mahalalel, iya i dadi'-na si Cainan, nga dadi'-na si Enos. Si Enos, iya i dadi'-na si Set, nga dadi'-na si Adan, ngan si Adan i dadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pag'amban-na si Jesus si Suba' Jordan, agdaluman-na na si Espirito ngan aggiyahan-na iya kon singnga iya pa'arop ari si disyirto ");
INSERT INTO abx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","sallod si kwarinta diyas. Sinan mga allaw agparatintar-na iya ari si Satanas ngan gana' si iya kakan-kakanay. Sanglit angabat iya kalingantuhan si katapusan. ");
INSERT INTO abx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Agpinugad-na iya si Satanas, “Kon ungod kaw Dadi'-na si Diyos, tighimu'on daw batoy to pan.” ");
INSERT INTO abx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Anaruman si Jesus, “Yayto i maka'anna' si Kasuratan: ‘Ga'i a'allom i a'a si kinakan hamok.’” ");
INSERT INTO abx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mangno, agbawa-na iya si Satanas pada'iray si madyalta buntay ngan hintak agpakulaw-na si dimu'an mga ginhadi'an si kalibutan. ");
INSERT INTO abx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Agpinugad-na iya, “Pumwan-ko si ka'aw i dimu'an gahom si pagtinagal sinan hasta pa i mga makawiwili kahalapan-na, kay nagpumwan nan si ako ngan pwidi sapumwan-ko si bisan say saruyagan-ko. ");
INSERT INTO abx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sanglit kon angampo' kaw si ako, tawa'-mo naynan dimu'an.” ");
INSERT INTO abx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Anaruman si Jesus, “Yayto i maka'anna' si Kasuratan: ‘Ampu'in i Paragdalom Diyus-bi, ngan iya hamok i sinirbihan-bi.’” ");
INSERT INTO abx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kahuman sinan agbawa-na namay iya si Satanas pada'iray si Jerusalem ngan agpatunggu-na iya si pinakamadyalta binubungan-na si templo. Aminugad si Satanas, “Kon ungod kaw Dadi'-na si Diyos, paluksuha daw ");
INSERT INTO abx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kay aka'anna' may si Kasuratan: Lihug-na i mga anghel-na pagpanginano si ka'aw nga akabantayan kaw pahalap. ");
INSERT INTO abx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mga iya i manarag si ka'aw, basi' ga'i akadabal si bato bisan i kitid-mo.” ");
INSERT INTO abx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Anaruman si Jesus, “Aka'anna' si Kasuratan: ‘Dakam agpurbari-bi pagpirit i Paragdalom Diyus-bi nga sakulawan-bi i pagkadiyus-na.’” ");
INSERT INTO abx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pakahuman-na si Satanas pagpurbar kon sapasala'-na si Jesus, pa'amban iya ngan ag'antahak na hamok si tama' uras para si iya. ");
INSERT INTO abx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagbalik-na si Jesus si Galilea, i gahum-na na si Espirito Santo i magdalom si iya. Abantog dayon i mahi'unong si iya ari siray bug'os lugar. ");
INSERT INTO abx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sigi iya panuro' si mga sinaguga-na si mga Hebro sanglit nagparadayaw iya si dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mangno pada'iray iya si baryo Nasaret, si tinubu'an-na lugar, ngan pasallod iya si sinaguga ari si Allaw Pandidiskanso, kay iya may i kabatasanan-na. Pan dahulu'an-na iya si mga a'a pagbasa si Kasuratan. ");
INSERT INTO abx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nagparu'do' si iya i nilikid sinurat-na siray si paragsumat Isaias. Agbuklad-nay to tubtob nga satakka-na kon singnga aka'anna' ari: ");
INSERT INTO abx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Atiya' si ako i Espiritu-na si Paragdalom, kay ako i tinu'inan-na pagpasamwak si mahalap sumat pada'iray si mga anggana'. Agpapada'itu-na ako basi' agpakatu'anan i mga bihag nga papalibrihon na mga iya, pati' i mga buta nga papakulawon na mga iya. Agpapada'itu-na liwat ako basi' pamahuway i magparapamakuri si mga dara'ug-da'ugon, ");
INSERT INTO abx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ngan basi' agpakatu'anan i mga a'a nga pakulaw-na ina'anto si Paragdalom i pagpalangga'-na. ");
INSERT INTO abx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Katapos aglikid-na gihapon i sinurat ngan agpumwan-nay to si kasugbung-na si puno' si sinaguga. Mangno aningkulo'. Agpamuslong si iya i dimu'an a'a ari si sinaguga. ");
INSERT INTO abx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Agtikang si Jesus pagwali si mga iya, “Mismo si pakapakali-bi ina'anto, atuman to kasuratan.” ");
INSERT INTO abx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Si pagparapahalling-na aruyag gayod i dimu'an mga a'a si iya ngan agpangusa tungod si mga maka'angayan allingon nagparayawit-na. Malabbat ari i magsipurupatilaway si mga katiringpid-na, “Ma'in ba' to i dadi'-na si Jose?” ");
INSERT INTO abx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pero padayon hamok si Jesus si pagpahalling-na, “Sigurado nga yayto parahallingon, ‘Duktor, bulungon i kalugaringun-mo,’ i nagpapa'igu'-bi si ako ngan makigpabuhat-bi may liwat si ako ato si tinubu'an-koy to lugar i nagparabuhat-ko kuno' ari si syudad Capernaum. ");
INSERT INTO abx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Sumatan-ta kam si kamatu'uran, gana' paragsumat-na si Diyos nga nagpaki'angayan si kalugaringun-na lugar. ");
INSERT INTO abx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Akapasiguro ako si ka'am nga malabbat mga balo siray ato si Israel ngan panahun-na kas Elias. Anhuraw siray tallo ngani' tunga' ta'on ngan aniya' grabi gutom si bug'os nasyon. ");
INSERT INTO abx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ga'i naglihog si Elias nga akapada'iray si bisan say si mga iya, pero pada'iray lugod dina iya si adda balo danda ari si bungto Sarepta nga sakop si syudad Sidon. ");
INSERT INTO abx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma'in nan hamok iya, ngan panahun-na kas Eliseo nga paragsumat-na si Diyos, malabbat liwat i mga liprusuhon ato si Israel, pero gana' bisan addangan si mga iya i nagpahalap-na si Eliseo. I manhalap lugod dina siray, iya i addangan nga taga prubinsya Siria nag'arunan Naaman.” ");
INSERT INTO abx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Si pakabati'-na sinan si mga a'a ari si sinaguga, agkasirina mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Agpamungkaras mga iya ngan nagdagnas si Jesus pagawas si baryo. Yayto baryo aka'anna' si adda tagudtod nga aniya' pangpang si bihing-na. Sanglit ari iya nagbawa basi' linaho'. ");
INSERT INTO abx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ragun-dagun-na hamok i ka'aha'an ngan durudiritso i langngan-na. ");
INSERT INTO abx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mangno, padalugdog iya pan Capernaum, Galilea. Ngan panakka-na si Allaw Pandidiskanso, agturo' iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ag'usa mga iya kay si pagturu'-na, aniya' pwirsa-na si mga allingun-na pagpasunod. ");
INSERT INTO abx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ari si sallud-na si sinaguga, aniya' addangan lalla nga nagbawa-bawa si adda mara'at espirito. Anurakaw to makusog pina'agi si busis-na si lalla, ");
INSERT INTO abx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ha! Ay ba' gayod i tuyu'-mo si kami', Jesus taga Nasaret? Pada'ito ba' kaw pagtapok si kami' pan impyirno? Sakilala-ta kaw. Ka'aw i Sagrado A'a nga nagpabawa-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Animol si Jesus, “Dakaw pararibok! Papindaha anan si iya!” Mangno, padusmug-na si mara'at espirito i lalla atubang si mga iya ngan papinday to si iya pero ga'i akapaddihan. ");
INSERT INTO abx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kinulbahan ngan agpangusa gayod i dimu'an mga a'a ngan agsipuruparatilaway, “Ay ba' to klasiha mga allingon? Mapwirsa i gahum-na, kay bisan i mga mara'at espirito samandaran-na ngan pamapinda dayon.” ");
INSERT INTO abx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sanglit, abantog si Jesus ari si kaburubungtuhan siray lugar. ");
INSERT INTO abx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagawas kas Jesus si sinaguga ngan agpamada'iray mga iya si ruma'-na si Simon, nga inadalan-na. Siray uras, mara'at i alabatan-na si ugangan-na danda si Simon tungod kay kalinturado iya. Agpa'alayon mga iya si Jesus pagbulong sito. ");
INSERT INTO abx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sanglit, duguk-na si Jesus i maburong ngan agmandaran-na nga a'ala' i kalintura-na. A'ala' i panas-na ngan agpanginanoy to dayon pagkiwa para si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pakatunud-na si allaw, agpamawa-na si mga a'a pada'iray si Jesus i dimu'an maburong nga mga pala'in-la'in i binati'-na. Agpandu'unan-nay nan si palat-na sa'uru'addangan ngan agpanhalap. ");
INSERT INTO abx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Malabbat liwat mga mara'at espirito magpamapinda si malabbat a'a nga sigi panurakaw, “Ka'aw i Dadi'-na si Diyos!” Pero agpangisugan-nay nan ngan ga'i agpanugutan-na nga agpakayawit pa kay agpakatu'anan nga iya i Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kanalungan, pada'iray si Jesus si adda mamingaw lugar. Sigi aranda'ay i mga a'a si iya. Ngan paka'anda' si iya, aghawiran-nay to kunta' mga iya. ");
INSERT INTO abx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero aminugad dina si Jesus, “Kinahanglan sapasamwak-ko ari si ditangnga' liwat mga bungto i mahalap sumat kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos, kay iyay nan i panlihugan si ako.” ");
INSERT INTO abx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sanglit, sigi iya wali si mga sinaguga ari si Judea. ");
INSERT INTO abx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Adda allaw, agparatutunggo si Jesus si bihing-na si Danaw Genesaret ngan aggurubok si iya i mga a'a pagpamati' si allingun-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akakulaw iya duwa paraw nga nag'ambanan hamok si mga mannagat ari si nabnaban kay agpanyabyab dina si mga pukut-na. ");
INSERT INTO abx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pasang'at iya si adda sito mga paraw nga tawa'-na si Simon, ngan tigpatukal-tukal-nay to diki'it si baybayon. Mangno aningkulo' iya si paraw ngan agparaturu'an-na i mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pakatapus-na pagparapahalling, agpinugad-na si Simon, “Pakurukalalumu-bi, ngan taktaku-bi pukut-bi nan basi' akabawa.” ");
INSERT INTO abx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Anaruman si Simon, “Sinyor, agbudlay gayod kami' pakanalong, ngan gana' sabawa kami' bisan adda pa may. Pero tungod kay agpinugad kaw, taktak-koy to mga pukot.” ");
INSERT INTO abx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pakahuman-na mga iya agtaktak, mabuburhaton gayod i mga pukut-na tungod si kalabbat-na si daying mga sadakup-na. ");
INSERT INTO abx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sanglit agpaypay-na mga iya i mga kabakas-na nga agpanakay si la'in paraw basi' akabuligan mga iya. Pamadugok to ngan agkargahan-na mga iya i duwa paraw ngan mga matutulluron tungod kay puro panno' si daying. ");
INSERT INTO abx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pakakulaw-na sinan si Simon Pedro, anluhod iya atubang si Jesus ngan aminugad, “Paragdalom, patalaha si ako kay adda ako makasasala'!” ");
INSERT INTO abx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Agda'inan iya sinan kay kinulbahan iya ngan ag'usa hasta pa i mga ka'adda-na sakayan tungod si mga pagtama'-na. ");
INSERT INTO abx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ag'usa liwat i duwangan kabakas-na si Simon, nga kas Santiago pati' Juan, i mga dadi'-na si Sebedeo. Pero agpinugad-na si Jesus si Simon, “Dakaw atalaw. Tikang ina'anto, mga a'a na i sabawa-mo pagtapod si Diyos pariho si daying sabawa-mo tubtob ina'anto.” ");
INSERT INTO abx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sanglit agbungsud-na mga iya i mga paraw-na, agpangambanan-na i dimu'an mga inanna'-na ngan amaya' mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngan ari kas Jesus si adda bungto, aniya' padugok lalla nga tanak i bug'os puhu'-na si lipruso. Pakakulaw-na sinan a'a si Jesus, pa'akkom iya. Mangno makimalu'oy, “Sinyor, sapahalap-mo gad ako, kon aruyag kaw.” ");
INSERT INTO abx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Agdu'unan-na si palat-na si Jesus i lalla ngan aminugad, “Oho' gad, buhat-koy nan. Anhalapa!” A'ala' dayon i liprusu-na. ");
INSERT INTO abx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mangno agtugunan-nay to si Jesus, “Dakaw agsumat si bisan say, pero pada'iraya si paraghalad ngan pakulawon si iya i puhu'-mo. Tighalara ari si nagmandu'-na si Moises para si manhalap basi' kinatu'anan nga nagparatuman pa i Bala'od.” ");
INSERT INTO abx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero agsasamwak dina i mga sumat mahi'unong si iya. Sanglit sigi durugukay i mga a'a pagpamati' si iya pati' pagpabulong si mga nagpangabat-na. ");
INSERT INTO abx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bisan bali i kasibutan-na, agsob palitira si Jesus pan kamingawan pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Adda allaw, aniya' mga Parisiyo pati' mga paragturo' bala'od magpaningkulo' matapit si iya si pagparaturu'-na. Tikang to mga iya si dimu'an kaburubungtuhan-na si Galilea pati' si Judea hasta pa si Jerusalem. Siray uras, ari si Jesus i gahom pagpahalap si mga maburong nga nagpumwan-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kata'ud-ta'uran aniya' magpanakka nga agpamawa irapa lalla nagbayawan si panlilibbakan. Ag'isasallod gayod kunta' mga iya si ruma' basi' sabawa-nay to mga iya atubang si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero gana' mga sa'anda'an-na pa'agi nga sahimu-nay nan mga iya tungod si kalabbat-na si a'a. Sanglit amanahik mga iya si hagdan pan binubungan. Agbulsugan-na mga iya ngan agtuntun-na mga iya i irapa huwang si naglibbakan-na ari si tangnga'-na si ka'aha'an, yungod si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ngan pakakulaw-na si Jesus si pagtapud-na sito mga a'a, aminugad iya, “Sangkay, nagpasaylo na i mga sala'-mo.” ");
INSERT INTO abx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Agtikang dayon pagngurub-ngurob i mga Parisiyo pati' i mga paragturo' bala'od, “Say ba' to aha'a maglalabaw to si Diyos? Gana' makapasaylo si mga sala' kon ma'in hamok i Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Akatu'anan si Jesus si mga inisipan-na, sanglit amatilaw iya, “Ay kay da'inan sinan i mga inisipan-bi? ");
INSERT INTO abx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Singnga sito i masayon: I pagpinugad, ‘Nagpasaylo i mga sala'-mo’ o i pagpinugad, ‘Anungguha ngan alangngana’? ");
INSERT INTO abx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero, basi' sakatu'anan-bi nga i Pinili' A'a aniya' gahum-na ato si kalibutan pagpasaylo si mga sala', palangngan-koy to irapa.” Mangno agpinugad-na i irapa, “Agtuninunga si ako. Anungguha, addu'on naglibbakan-moy nan ngan agbalika.” ");
INSERT INTO abx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Anunggo dayon iya atubang si dimu'an, agbitbit-na i naglibbakan-na ngan agparadayaw iya si Diyos si pagbalik-na. ");
INSERT INTO abx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ag'usa i dimu'an ngan agpakapinugad mga iya, “Pambihira i sakulawan kami' ina'anto.” Agdayaw-na mga iya i Diyos bawa i mahaya pagtahod si iya. ");
INSERT INTO abx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kahuman sinan, palangngan si Jesus ngan samasiran-na namay i paragsukot buhis nag'arunan Levi nga agparatingkulo' si pwistu-na. Agpinugad-na iya si Jesus, “Amaya'a ngan agsunura si ako.” ");
INSERT INTO abx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ag'ambanan-na si Levi i dimu'an inanna'-na ngan amaya' si iya. ");
INSERT INTO abx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mangno aniya' allaw nga agtima mahaya pakan si Levi para si Jesus ari si ruma'-na, ngan malabbat i mga paragsukot buhis pati' la'in pa nga nagpaminugad makasasala' nga makitangka' si mga iya pagkakan. ");
INSERT INTO abx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero aniya' pamalabay mga Parisiyo huwang i mga paragturo' bala'od nga sakup-na mga iya nga agriklamo ari si mga inadalan-na, “Ay kay makihuwang kam pagkakan pati' pag'inom si mga paragsukot nan buhis hasta si mga makasasala' nan?” ");
INSERT INTO abx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mismo si Jesus i manaruman si mga iya, “Ma'in i mga mahalap a'a i magpanginahanglan duktor, kundi' i mga maburong dina. ");
INSERT INTO abx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ga'i ako pada'ito pag'agda si magpaminugad nga matadong mga iya a'a, kundi' pada'ito ako pag'agda si mga makasasala' basi' agpamasol huwang si pagbag'o.” ");
INSERT INTO abx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Siray, aniya' mga nagpili' allaw si pagpu'asa basi' gana' la'in kinapinsaran pwira hamok si Diyos. Sanglit, aniya' ari maminugad si Jesus, “I mga inadalan-na si Juan Paragbunyag agsob agpamu'asa huwang si pagpangadyi'. Agbuhat-nay nan liwat si mga inadalan-na si mga Parisiyo. Pero mga inadalan-moy nan sigi hamok pamangan pati' pangirinom.” ");
INSERT INTO abx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Anaruman si Jesus, “Ga'i may gad ahimo nga ga'i amangan i mga imbitadu-na si kinasal lalla kon awinan pa iya. ");
INSERT INTO abx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ma'in na pira arala'on na i makapariho si kinasal lalla, ngan sinan mga allaw iya na dina i angay pagpu'asa-na si mga inadalan-ko.” ");
INSERT INTO abx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Agsumatan-na liwat mga iya sito isturya nga agtukoy si kamatu'uran: “Gana' magtabas si baha'o bado' basi' pinatangbil si kada'an. Kay kon da'ito sito i nagpatangbil-mo, agisi' i baha'o badu'-mo, ngan ma'in angay pagpapadis i baha'o pati' i kada'an.” ");
INSERT INTO abx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Agsumatan-na mga iya si adday to pa: “Gana' magpa'isi si baha'o irimnon si kada'an na anit pangngingisihan, kay amura' to kon pa'isi-mo, mangno aburhat i pangngingisihan ngan atumpa i irimnon. ");
INSERT INTO abx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma'in da'inan sinan. Kinahanglan i baha'o irimnon pina'isi may si baha'o pangngingisihan. ");
INSERT INTO abx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pero bali kuri pagsalli' si pagtu'u-na si a'a. Halimbawa', gana' maruyag magtimtim si baha'o hagos kon gara' na si bahal, kay lingun-na dina, ‘Mas mahalap i kada'an.’” ");
INSERT INTO abx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sin adda, pabalatas kas Jesus si kapatagan nga akatuman si Allaw Pandidiskanso. Sigi pangattos i mga inadalan-na si mga matahak uhay-na si trigo ngan sigi panilsi'. ");
INSERT INTO abx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aniya' mga Parisiyo magriklamo si iya, “Ay kay agkattos kam si Allaw Pandidiskanso bisan kon sakatu'anan-bi nga supak nan si bala'od?” ");
INSERT INTO abx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Anaruman may dina si Jesus, “Ga'i ba' sabasa-bi kon ay i nagbuhat-na siray si David ngan alinganto iya hasta i mga kahuruwangan-na? ");
INSERT INTO abx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pasallod iya si pangngangampu'an tulda ngan angaddo' si pan nagla'in para si Diyos. Agkakan-nay nan nga i mga paraghalad hamok i tugot pagkakan sinan ngan agbuwanan-na pa liwat i mga kahuruwangan-na. Pero ma'in nan sala' para si mga iya.” ");
INSERT INTO abx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Si katapus-tapusan, aminugad si Jesus si mga iya, “I Pinili' A'a, iya i Paragdalom si bisan ay, iya pa ba' i Allaw Pandidiskanso?” ");
INSERT INTO abx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Si adda gihapon Allaw Pandidiskanso, pasallod iya si sinaguga ngan agparaturo'. Aniya' lalla ari nga piyapi i kawanan tamburu'-na. ");
INSERT INTO abx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aniya' liwat mga Parisiyo ari pati' mga paragturo' bala'od magparapanganda' rason nga sapa'akusar-na mga iya si Jesus si pagtrabaho si Allaw Pandidiskanso. Sanglit agtigamanan-na gayod mga iya kon pahalap-na si Jesus i lalla. ");
INSERT INTO abx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero sakatu'anan-na si Jesus i mga inisipan-na. Sanglit agpinugad-na i piyapi tamburu'-na, “Anungguha ngan pada'ituha si dahulu'an.” Sanglit anunggo i lalla ngan pan dahulu'an. ");
INSERT INTO abx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mangno aminugad si Jesus si mga iya, “Amatilaw ako si ka'am, singnga sito i nagpatugot si bala'od si Allaw Pandidiskanso: Pagbuhat kahalapan o karat'an? Pagpanginano si a'a basi' asalbar i kinabuhi'-na o amatay to nga bulag si Diyos?” ");
INSERT INTO abx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Amuslong si Jesus si mga iya dimu'an ngan katapos agmandaran-na i lalla, “Buklaron tamburu'-moy nan.” Agbuklad-na si lalla, ngan anhamis gihapon i pustura-na si tamburu'-na pariho si dati. ");
INSERT INTO abx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero bali i mga kapuringut-na, sanglit agbararagawan-na dayon kon pa'i-na mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adda sinan mga allaw, pasagka si Jesus si adda tagudtod pagpangadyi' ngan sigi hamok iya ampo' si Diyos pakanalong. ");
INSERT INTO abx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kanalungan, agban'u-na i mga inadalan-na ngan agpili' iya dusi nga agpanu'inan-na bilang mga apostol. ");
INSERT INTO abx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yayto i dusi: Si Simon nga nag'arunan-na si Jesus, Pedro, si Andres nga sirari-na si Simon, si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO abx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago nga dadi'-na si Alfeo, si Simon nga sakop si grupu-na si mga Selote, ");
INSERT INTO abx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas nga dadi'-na si Santiago, pati' si Judas Iscariote i titraydor si katapusan. ");
INSERT INTO abx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mangno aghururuwang mga iya padalugdog ngan pamahuway si kapatagan. Ari agpangantahak i kalabbatan pa mga inadalan-na pati' kalabbatan mga taga Judea. Aniya' si mga iya nga mga taga Jerusalem gayod ngan aniya' pa liwat magpakahuwang sito grupo nga tikang dina si mga ligiron matapit si duwa syudad Tiro pati' Sidon. ");
INSERT INTO abx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Agpamada'iray to mga a'a basi' agpakapakali si mga turu'-na ngan agpakapabulong i ditangnga' si mga binati'-na. Agpanhalap i mga nagpamawa-bawa si mga mara'at espirito, ");
INSERT INTO abx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ngan agtalinguha gayod i mga maburong nga akasaphid si puhu'-na, kay abantad i gahum-na pagbulong, ngan agpanhalap mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Anili' si Jesus si mga inadalan-na ngan aminugad, “Mga malipayon kam mga anggana' nan ina'anto, kay ka'am i magpakasakop si mga nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mga malipayon kam mga lingantoy nan ina'anto, kay ka'am i papagustuhan. Mga malipayon kam mga masurub'on nan ina'anto, kay ka'am i papalaksihon. ");
INSERT INTO abx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mga malipayon kam kon nagpanhumutan kam si a'a, kon nagsikway ngan nagparasamyangan hasta kon nagdiri' i pagka'a'a-bi, kay para si mga iya bali kam ra'at tungod si pagsunud-bi si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Si kahinabu'-na sinan, aglipaya kam ngan agpanlaksiha kam, kay mahaya i sakarawat-bi primyo ari si langit pariho si mga sakarawat-na si mga paragsumat-na si Diyos siray nga nagparapamasakitan si mga ginikanan-na sito mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero mga papabidu'on kam mga mayaman nan ina'anto, kay sakarawat-bi na i makali'aw si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mga papabidu'on kam mga magpakagustuhan nan ina'anto, kay ka'am i papalingantuhan. Mga papabidu'on kam mga magpanlaksi nan ina'anto, kay ka'am i papaluha'on. ");
INSERT INTO abx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mga papabidu'on kam mga nagparapandayaw nan si dimu'an mga a'a, kay tikarawat kam pariho si mga sakarawat-na si mga burubullo' paragsumat-na si Diyos siray nga nagparapandayaw-na si mga ginikanan-bi. ");
INSERT INTO abx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lugod, sumatan-ta kam magpakabati' nan si ako: Higugma'u-bi i mga kuntra-bi, pakulawu-bi si mahalap i magpara'at si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Palakuhin si mga kabubuwasun-na i mga magpati'aw si ka'am, ngan pangadyi'i-bi i mga magparapamasakit si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kon aniya' si ka'am manampalo, pa'atubangu-bi pa si iya i dambila' bayhun-bi. Kon aniya' mangangkon si dyakit-bi, dakam agdiri'u-bi kon hugkas-na pa i badu'-bi. ");
INSERT INTO abx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bisan say i mamalako si ka'am, buwani-bi ngan kon aniya' mag'angkon si tawa'-bi, dakam agpiritu-bi nga pabalik-na pa si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kon ay i naghingyap-bi binuhat-na si la'in para si ka'am, buhatu-bi nan. ");
INSERT INTO abx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kon i naghigugma'-bi hamok i maghigugma' may si ka'am, ay may i darayawon si nagbuhat-bi? Bisan i mga nagpaminugad makasasala', aghigugma' si mga maghigugma' may si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ngan kon agbuhat kam hamok mahalap si magbuhat may mahalap si ka'am, ay may i darayawon si nagbuhat-bi? Bisan i mga nagpaminugad makasasala' agbuhat-nay nan. ");
INSERT INTO abx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ngan kon i pagpa'indam-bi tungod hamok kay agla'om kam nga binayaran, ay may i darayawon si nagbuhat-bi? Bisan i mga nagpaminugad makasasala' agpama'indam si mga kaparihu-na makasasala', kay agla'om mga iya nga binayaran pariho si nagpama'indam-na. ");
INSERT INTO abx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lugod, higugma'u-bi i mga kuntra-bi ngan buhatu-bi i mahalap para si mga iya. Pa'indamu-bi mga iya ngan dakam agla'om si mga bayad-na. Mangno i primyu-bi bali haya, hasta i pagkakilala nga ka'am i mga dadi'-na si Gilalabawi Diyos kay aka'irog kam si iya nga bali kadaluman si mga mara'at a'a nga ga'i magkatara'o pagpasalamat. ");
INSERT INTO abx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Alu'uya kam pariho si Tatay-bi nga maluluy'on. ");
INSERT INTO abx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dakam aghusgar, ngan ga'i may kam naghusgaran si Diyos. Dakam agpatok ngan ga'i may kam nagpatukan. Agpasayluha kam ngan papasayluhun-na may kam. ");
INSERT INTO abx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Amuwana ngan buruwanan-na may kam. Sa'angkun-bi i ka'abunda-na nga niyugyog ngan nagsu'so' hasta nga agsapwa si pannukulan, kay bisan ay i nagsukulan-bi, iya may i surukulan pagpabalik si ka'am.” ");
INSERT INTO abx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Agsumatan-na liwat mga iya si Jesus sito isturya nga agtukoy si kamatu'uran: “Pwidi ba' akapatuttot i adda buta si kaparihu-na buta? Sigurado nga agkataralibho' mga iya duwangan. ");
INSERT INTO abx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","I iskwila angga'i akalabaw si ma'istru-na. Pero bisan say mata'o na si dimu'an nagkinahanglan-na tururu'on, akapariho na iya si ma'istru-na. ");
INSERT INTO abx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ay kay sakulawan-mo lugod i day panarutsuhan nga makabuta si igkasi a'a-mo, pero ga'i sapanginanu-mo i day gip'at nga makasalingkop si kalugaringun-mo mata? ");
INSERT INTO abx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pinapa'i-mo may pakapinugad si igkasi-mo, ‘Sangkay, ala'an-ta kaw si makabutay nan si ka'aw,’ nga mismo i makasalingkop si mata-mo ga'i sapanginanu-mo? Mahalap kaw gayod agsilhig si hawan-na si la'in! Ala'on dahulo i makasalingkop si mata-mo, ngan kahuman sinan saklaru-mo na ngan sa'ala'-mo i makabuta si igkasi-mo. ");
INSERT INTO abx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gana' kayo nga mahalap i kamamatan-na nga agbuwa' mara'at, o ma'in ngani' mara'at i kamamatan-na nga agbuwa' mahalap. ");
INSERT INTO abx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bisan kon pariho i pagkukulaw si duwa kayo, akilala kon singnga i mahalap tungod si buwa'-na. Gana' magpangko' si prutas igos tikang si pu'un-na si tangulon o ma'in ngani' ubas tikang si pu'un-na si sapinit. ");
INSERT INTO abx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Agpagawas-na si mahalap a'a i mga kahalapan kay iya may i sari'i si inisipan-na, ngan agpaguwa'-na si mara'at a'a i mga karat'an kay iya may liwat i sari'i si inisipan-na. Bisan ay i manapwa si inisipan-na, iya may i sapahalling-na. ");
INSERT INTO abx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ay kay pirmi ako agparaban'u-bi, ‘Paragdalum-ta kaw, Paragdalum-ta kaw,’ pero ga'i agtuman-bi i mga tugun-ko? ");
INSERT INTO abx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sumatan-ta kam kon ay i kaparihu-na si addangan nga padugok si ako, akapamati' si mga allingun-ko ngan agtuman-na si kinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Akapariho iya si a'a magtindog ruma' nga ag'ukaran-na malalom nga anakka si bato i pundasyun-na. Si panakka-na si unop, ga'i to sabawa-na si baha' ngan ga'i to abantad, kay masarig i pagkatindog. ");
INSERT INTO abx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero i makapamati' si mga allingun-ko kundi' ga'i to atuman si kinabuhi'-na, akapariho si magtindog ruma' nga gana' purupundasyunay. Si pangigu'-na si baha' sito ruma', sigurado nga arugno' ngan agawad i dimu'an.” ");
INSERT INTO abx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pakahuman-na si Jesus agpahalling sinan dimu'an atubang si mga a'a, pasallod iya si syudad Capernaum. ");
INSERT INTO abx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aniya' ari maburong nga agmasakit na. Rilihugun-nay to si adda sinturyon ari ngan pina'ura-nay to gayod si amu-na. ");
INSERT INTO abx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Akapamati' i sinturyon mahi'unong si Jesus, sanglit tig'alayon iya si mga kilala-na mata'o kamabu'utan Hebro pag'ala' si Jesus. Makigpapada'iray-nay to si ruma'-na basi' abulong i rilihugun-na. ");
INSERT INTO abx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Panakka-na mga iya ari si Jesus, agparapakimalu'oy gayod mga iya si iya, “Angay to gayod a'a nga sabuligan-mo si panlihugan-nay to ");
INSERT INTO abx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kay aghigugma'-na kita kam mga Hebro, ngan iya i magpatindog si sinaguga ato.” ");
INSERT INTO abx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sanglit amaya' si Jesus si mga iya. Si pagdadara'un-na na mga iya si ruma', aniya' naglihug-na gihapon si sinturyon mga kumpaniya-na pagpinugad, “Sinyor, dakaw na hamok agparapabudlay kay ma'in gad ako angay pagpadagos si ka'aw si ruma'-ko. ");
INSERT INTO abx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sanglit ngani' ga'i sa'aku'-na mismo si kalugaringun-ko nga angay ako padugok si ka'aw. Kundi' amusngala hamok kay sigurado anhalap i rilihugun-ko. ");
INSERT INTO abx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Da'inan sinan i pagtu'u-ko kay adda may liwat hamok ako rilihugon nga ata'o pagsunod si mga malanga katungdanan-na, ngan aniya' may liwat mga sundalu-ko nga salihug-ko. Aminugad ngani' ako si addangan, ‘Pada'iraya,’ diritsoy to dayon pa'amban. Si addangan ray namay, ‘Tuwa,’ sigurado padugok to si ako. Aminugad ngani' ako si rilihugun-ko, ‘Trabahu'on to,’ diritsoy to dayon trabahu-na.” ");
INSERT INTO abx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pakabati'-na sinan si Jesus, ag'usa-nay nan gayod ngan pa'atubang si kalabbatan magpamungyod si iya. Aminugad iya, “Sumatan-ta kam, ga'i pa ako aka'anda' a'a nga da'inan kahaya i pagtutu'u-na ato si bug'os Israel.” ");
INSERT INTO abx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mangno agbalik i nagpanlihog mga a'a ngan sa'usisahan-na mga iya nga mahalap na dina i rilihugon. ");
INSERT INTO abx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ga'i agliyat, pada'iray si Jesus si adda bungto nag'arunan Nain, ngan amaya' si iya i mga inadalan-na pati' bali labbat pa mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pagdadara'un-na mga iya si pwirtahan-na si kuta'-na si bungto, aniya' minatay burubata' nagbayawan pan gawas nga nagpalibbak si karro sigon si kabatasanan-na mga iya paglabbong. Iyay nan hamok i sulo dadi'-na si nanay-na nga balo na. Bali labbat mga a'a si bungto magpanlibod. ");
INSERT INTO abx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pakakulaw-na si Paragdalom si nana, bali i kalu'uy-na sito ngan aminugad, “Dakaw agpanangis.” ");
INSERT INTO abx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Katapos, padugok iya ngan angantan si karro ngan diritso pamahuway i magpamayaw. Aminugad iya, “No', ako i magpinugad si ka'aw, pabanguna!” ");
INSERT INTO abx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pabangon i minatay ngan amahalling dayon. Mangno, agpa'intriga-nay to gihapon si Jesus si nana-na. ");
INSERT INTO abx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bali i mga pag'usa-na mga iya dimu'an ngan agdayaw-na mga iya i Diyos. Lingun-na mga iya, “Aniya' mangusbong si kami' gilalabawi paragsumat-na si Diyos. Atiya' na i Diyos pagbulig si mga ginsakupan-na.” ");
INSERT INTO abx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Agwarak i sumat mahi'unong si Jesus si bug'os Judea hasta pa si mga lugar magpalibot sito. ");
INSERT INTO abx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Akasumatan si Juan si mga inadalan-na mahi'unong sinan dimu'an. Duwangan si mga iya i nagban'u-na ");
INSERT INTO abx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","basi' salihug-na pagbagat si Paragdalom ngan pagpatilaw, “Ka'aw na ba' i nagparapanimulat nga tipada'ito, o kinahanglan pa ba' kami' ag'antahak la'in?” ");
INSERT INTO abx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ngan pakabagat-na na mga iya si Jesus, aminugad mga iya, “Agpapada'itu-na kami' si Juan Paragbunyag si ka'aw pagpatilaw, ‘Ka'aw na ba' kuno' i nagparapanimulat nga tipada'ito, o kinahanglan pa kami' ag'antahak la'in?’” ");
INSERT INTO abx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mismo siray uras, bali labbat i mga sapahalap-na si Jesus nga aniya' mga binati'-na, mga maburong pati' mga nagpamawa-bawa si mara'at espirito hasta pa liwat malabbat mga buta nga sapakulaw-na gihapon. ");
INSERT INTO abx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sanglit agpinugad-na i mga nagpanlihog, “Agbalika kam ngan sumati-bi si Juan kon ay i mga sakulawan-bi pati' i mga sapamati'an-bi na. Pinugaru-bi nga agpakakulaw gihapon i mga buta, agpakalangngan i mga lulid, agpanhalap i mga liprusuhon, agpakapamati' i mga bungol, a'allom gihapon i mga minatay, ngan nagpasamwak si mga anggana' i mahalap sumat. ");
INSERT INTO abx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sanglit, tig'ala'on si iya i duda-na si pagpinugad nga malipayon i a'a nga ga'i ag'amban si pagtutu'u-na si Diyos tungod si ako.” ");
INSERT INTO abx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pakataliwan-na si mga nagpanlihug-na si Juan, agtikang si Jesus pagpahalling si magpantarambak mahi'unong si Juan, “Ngan pamada'iray-bi si disyirto, ay i nagkukulawan-bi ari? Addangan ba' nga akapariho si bigahaw nga sigi hamok baya'-baya' kon palingnga i bariyo? ");
INSERT INTO abx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kon ma'in nan, ay may kay pamada'iray kam pag'usisa? Aniya' ba' a'a ari nga mahalap i pamadu'-na? Gana', kay i magsalin si mga mahal bado' ngan gara' si ka'abundahan, awiray ag'istar si mga palasyo. ");
INSERT INTO abx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pero ay may dina i nagpada'iray-bi pag'usisa? Tungod ba' si paragsumat-na si Diyos? Tama', ngan sumatan-ta kam, nga ma'in hamok iya paragsumat-na si Diyos ");
INSERT INTO abx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","kay si Juan i nagtukoy si Kasuratan: Aniya' paragsumat-ko nga padahulu-ko si ka'aw paghawan si pangngagihan-mo. ");
INSERT INTO abx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sumatan-ta kam, si dimu'an mga a'a naghinganak si nana gana' manlabaw si Juan. Pero i gimiminusi si magpakasakop na si mga nagpanhadi'an-na si Diyos labaw pa si iya.” ");
INSERT INTO abx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Akapakali i dimu'an mga a'a si mga allingun-na si Jesus, huwang i mga paragsukot buhis, sanglit agpakapinugad mga iya nga tama' i pa'agi-na si Diyos tungod kay sabunyagan-na mga iya si Juan. ");
INSERT INTO abx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero agdiri'-na si mga Parisiyo pati' si mga kunusido si bala'od i katuyu'an-na si Diyos para si mga kalugaringun-na, kay ga'i mga iya agpamabunyag si Juan. ");
INSERT INTO abx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Agpadayon i mga allingun-na si Jesus, “Singnga na daw to hamok sapaparihu-ko mga a'ay to ina'anto panahon? Ay ba' sito i mga kaparihu-na? ");
INSERT INTO abx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Si pagdiri'-na mga iya si kami', agkuntra pirmi i mga allingun-na nga day akapariho si mga dadi'-dadi' nga awiray si mirkado agparapaningkulo' ngan sigi burubaran'uhay: Agparapanukaran kami' kam, pero ga'i kam agpanayaw. Sigi kami' dirinamagay, pero ga'i kam agpamanangis. ");
INSERT INTO abx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pada'ito si Juan Paragbunyag nga ga'i parapangumbiti o parapaki'inom, ngan agpaminugad kam, ‘Nagbawa-bawa iya si mara'at espirito.’ ");
INSERT INTO abx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mangno pada'ito namay i Pinili' A'a nga parapangumbiti pati' parapaki'inom, ngan agpaminugad namay kam, ‘Atiya' i bali kamakikinakan pati' paralango, kumpaniya-na si mga paragsukot buhis pati' si mga makasasala'.’ ");
INSERT INTO abx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero kinakulawan nga tama' i kadunung-na si Diyos pina'agi si mga madunong binuhatan-na si dimu'an mag'ako' sito.” ");
INSERT INTO abx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mangno addangan si mga Parisiyo ari i mangimbitar si Jesus pagpangamudto si mga ruma'-na. Sanglit amaya' iya sito ngan agtarangka' mga iya si lamisa pagkakan. ");
INSERT INTO abx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aniya' danda ari siray bungto nga binantog si pagkamakasasala'-na. Ngan pakakatu'an-na nga agkakan si Jesus si ruma'-na si Parisiyo, pada'iray iya ngan agbawa pasangngit nga i pangngisihan-na hinimo tikang si bato alabastro. ");
INSERT INTO abx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mangno padugok to ngan payungod si kitid-na. Sigi to panangis tubtob nga abasi' si luha'-na i kitid-na si Jesus. Katapos agpahitan-nay to si barahibu-na, ag'uruk-na ngan agbu'bu'an-nay to si pasangngit. ");
INSERT INTO abx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pakakulaw-na sinan si Parisiyo mag'imbitar si iya, aka'anna' si huna'-huna'-na, “Kon paragsumat-nay to a'a si Diyos, sakatu'anan-na kunta' kon say nan mag'antan nan si iya ngan kon ay nan klasiha iya danda. Akatu'anan kunta' iya nga makasasala' nan.” ");
INSERT INTO abx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Agsarumanan-na si Jesus i sari'i si isip-na, “Aniya' surumatun-ko si ka'aw, Simon.” “Sumatin ako, Ma'istro,” lingun-na may si Simon. ");
INSERT INTO abx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Aniya' duwangan a'a nga mangutang si adda parapa'utang kwarta. I addangan angutang si iya kinyintos dinari diplata, ngan i addangan may singkwinta. ");
INSERT INTO abx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bisan addangan si mga iya gana' mga pammayad-na si mga sa'utang-na, sanglit ga'i na hamok mga iya agpabayad-na. Sinan, say si mga iya i urog maghigugma' si magpa'utang?” ");
INSERT INTO abx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Anaruman si Simon, “Tingali i mahaya utang-na nga ga'i nagpabayad.” “Tama' gayod i pagkapili'-mo,” lingun-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mangno anili' iya pada'iray si danda ngan agpinugad-na si Simon, “Sakulawan-moy to danda nga agbasi'-na si luha'-na i kitid-ko ngan agpahitan-nay to si barahibu-na. Pero ka'aw, ay i nagbuhat-mo si pasallud-ko si ruma'-mo sigon si kabatasanan pagkarawat si bisita? Ga'i ngani' ako agparu'du'an-mo bisan buwahi' pannawsaw-ko. ");
INSERT INTO abx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ga'i ako ag'uruk-mo, pero yayto danda, tikang pa gayod si pamanahik-ko, ga'i iya pahuway si ka'u'urok si kitid-ko. ");
INSERT INTO abx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ga'i ako agbu'bu'an-mo masangngit lana si takulok, pero agbu'bu'an-na pasangngit i kitid-ko. ");
INSERT INTO abx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sumatan-ta kaw, kinakulawan nga mahaya i gugma'-na. Kon sugad, akatu'anan ako nga nagpasaylo na i malabbat sala'-na. Pero kon i pagkagasi-na si a'a nga diki'it hamok i papasayluhon si iya, kinatu'anan may liwat nan tungod si diki'it gugma'-na.” ");
INSERT INTO abx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mangno agpinugad-na si Jesus i danda, “Nagpasaylo na i mga sala'-mo.” ");
INSERT INTO abx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sigi ngururub-ngurubay i ditangnga' mga bisita, “Say ba' to aha'a nga agparabasang-basang pagpasaylo si mga sala'?” ");
INSERT INTO abx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Agpinugad-na si Jesus i danda, “I pagtutu'u-mo, iya i makasalbar si ka'aw. Murayaw pa kunta' i kamutangan-mo.” ");
INSERT INTO abx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kahuman sinan, aglibot si Jesus si mga kaburubungtuhan pati' mga kaburubaryuhan. Agparapasamwak-na i mahalap sumat kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos. Huwang si iya i Dusi ");
INSERT INTO abx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","ngan aniya' liwat magpamahuwang mga danda nga agpakabulig si mga pagkinabuhi'-na nga mga kalugaringun-na gayod kwarta. I ditangnga' sinan mga danda, iya i magpanhalap si mga binati'-na ngan i ditangnga' may i nagpamapindahan si mga mara'at espirito. I magpamaya', iya kas Maria nga nag'arunan Magdalena nga nag'ambanan si pito' mara'at espirito, si Juana nga alla-na si Chuza nga tinapuran si panimalay-na si Herodes, si Susana, ngan malabbat pa. ");
INSERT INTO abx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sigi tarakkahay i mga a'a tikang si pala'in-la'in mga bungto. Ngan naggururubukan na gayod si Jesus sinan mga a'a, agsumatan-na mga iya sito isturya nga agtukoy si kamatu'uran: ");
INSERT INTO abx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aniya' para'uma nga patakod basi' agsaburak. Si pagsaburak-na si uma-na, aniya' mga gahi' nga aka'anna' dina si lalan. Agpakatumbanan to ngan agpamadugok i mga manuk-manok pagtuktok. ");
INSERT INTO abx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aniya' liwat mga gahi' nga aka'anna' dina si malambo bato nga manipis hamok i pitak-na si dyata'. Sanglit si panuduk-na, alayong to dayon mga tinanom tungod kay tulos atuho' i pitak. ");
INSERT INTO abx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aniya' liwat mga gahi' nga aka'anna' dina si pitak nga aniya' pa mabilin mga gamut-na si simpot. Anubo' to dungan si gahi' ngan agsuputan-na i mga tinanom. ");
INSERT INTO abx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero aniya' may liwat mga gahi' nga aka'anna' si mahalap pitak. Sanglit mahalap i panuduk-na, anhaya ngan amuwa'. I kutsitsa-na ag'addahatos dubli kuntra si nagpasaburak.” Pakapinugad-na sinan, amahalling iya makusog, “Si mga a'a makapamati', kunta' amati'.” ");
INSERT INTO abx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Agpatilawan-na iya si mga inadalan-na kon ay i tinago' karuyag sidngun-na si isturya-na. ");
INSERT INTO abx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Anaruman si Jesus, “Nagpumwan na si ka'am i pagsabut-bi nga iya i nagparatago' siray, kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos, pero nagparatago' payto si ditangnga'. Sanglit i mga isturya nga agtukoy si kamatu'uran i naggamit-ko, basi' sigi mga iya buruslungay, pero gana' mga sakulawan-na. Sigi paramati'ay, pero gana' mga sasabutan-na. ");
INSERT INTO abx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Yayto i karuyag sidngun-na si isturya-koy ray: I gahi', iya i allingun-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aniya' mga a'a nga akapariho si lalan. Agpakapamati' to, mangno anakka si Satanas ngan ag'ala'-na si mga iya i allingon nga nagpasaburak si mga inisipan-na. Agbuhat-nay nan si Satanas basi' ga'i mga iya agpanutu'o nga agkasaralbar. ");
INSERT INTO abx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","I malambo bato namay nga manipis hamok i pitak-na si dyata', akapariho si mga a'a nga mga malipayon pagkarawat si allingon, pero mababaw hamok sito i mga ginamut-na. Agpanutu'o dahulo mga iya, pero panakka-na si mga kakurihan pagpurbar kon ungod i mga pagtutu'u-na, pama'amban to dayon mga iya. ");
INSERT INTO abx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I pitak nga aniya' mga titudok simpot, akapariho si mga a'a nga agpakapamati' pahalap, pero sadurudiki'it akapugungan i pagtubu'-na si mga pagtutu'u-na tungod si mga kabaraka si pagpanginabuhi', si kayamanan pati' si mga magbuwan si mga iya kalipayan, ngan ga'i amatgas i mga pagtu'u-na. ");
INSERT INTO abx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero i mahalap pitak akapariho si mga a'a nga tangkod ngan mahalap i mga inisipan-na. Si pakapakali-na mga iya si allingon, ag'aku'-nay to ngan tungod si padayon pagti'os, mahalap i binuwa'-na. ");
INSERT INTO abx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Gana' ato magsulsol lampara, mangno agtagu'-na dina si biso' o ma'in ngani' si dilalum-na si katri. Lugod, agpa'anna'-nay to si tama' pamma'anna'an basi' sakulawan-na dayon i danta' si pasallod. ");
INSERT INTO abx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pariho si mga allingun-ko, bisan kon nagparatago' ina'anto, akaguwa' to gihapon ngan kinakulawan, ngan bisan kon nagparatambunan, abaway to si pangulawan-na si dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sanglit agmatuha kam kon pinapa'i-bi agpamati'. Bisan say i aniya', iya i binuwanan pa; pero bisan say i gana', hasta i gasi-na nga tawa'-na, inala' pa tikang si iya.” ");
INSERT INTO abx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mangno anakka i nana-na pati' i mga bugtu'-na lalla si Jesus pag'usisa si iya. Pero ga'i mga iya pwidi agpakatapit tungod kay naggurubukan iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aniya' makasumat si iya, “Awiray si gawas agparapanunggo i nana-mo huwang i mga bugtu'-mo ngan baragatun-na kaw.” ");
INSERT INTO abx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Anaruman si Jesus, “I magpakapamati' si allingun-na si Diyos nga ahimoy to kabatasanan si mga kinabuhi'-na, mga iya dina i nana-ko pati' kabugtu'an-ko.” ");
INSERT INTO abx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Adda allaw, agpinugad-na si Jesus i mga inadalan-na, “Patalabok kita kam pan dambila'-na si danaw.” Sanglit pamasang'at mga iya si paraw ngan agpamataliwan. ");
INSERT INTO abx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kata'ud-ta'uran, hintak anmadlos ngan asalakay i mga nagsakayan-na hasta nga mapapannu'on. Bali kadilikado i mga kamutangan-na pero mahalap dina i pamaturi-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sanglit nagdugok iya si mga inadalan ngan nagpukaw, “Sinyor, Sinyor, matutulluron na kita kam!” Anunggo si Jesus ngan agpugungan-na i bariyo pati' i mga mahaya alon. Pahuway i madlos ngan hintak anhuda'. ");
INSERT INTO abx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Agpatilawan-na i mga inadalan-na, “Singnga na i mga pagtutu'u-bi?” Si mga katalaw-na pati' si mga pag'usa-na, agsipurupatilaway mga iya, “Ay ba' to gayod iya? Samandaran-na bisan i bariyo pati' i buwahi' ngan agsunod si iya.” ");
INSERT INTO abx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Padayon i pagtalabuk-na kas Jesus pan dambila'-na si Danaw Galilea, ari si lugar-na si mga Gerasenes. ");
INSERT INTO abx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ngan pasalta-na si Jesus si paraw, aniya' dayon sapantawan-na sunsari'i lalla nga nagbawa-bawa si mara'at espirito. Yaynan lalla maliyat na nga ga'i agparabado' ngan ga'i agpara'istar si ruma' kundi' si mga kwiba panlalabbungan dina. ");
INSERT INTO abx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ngan pakakulaw-na may si lalla si Jesus, anggasod iya. Mangno aglalahi iya padugok ngan pa'akkom atubang si iya. Anurakaw iya, “Ay i tuyu'-mo si ako, Jesus, Dadi'-na si Gilalabawi Diyos? Makimalu'oy ako si ka'aw, dakaw ako agpasakitin!” ");
INSERT INTO abx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Akapinugad iya sinan kay agmandaran-na si Jesus i mara'at espirito nga pa'amban ari si a'a. Malabbat na bisis nga tinakka iya kon sakup-na iya sito. Bisan kon nagparakadinahan i mga langngun-na pati' i mga kitid-na ngan mahalap pa i pagkabantay, parapuknut-na hamok i kadina-na. Katapos, agparalahi'an-na iya si mara'at espirito pada'iray si mga mamingaw lugar. ");
INSERT INTO abx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mangno agtilaw-na iya si Jesus, “Say i arun-mo?” “Kalabbatan,” i saruman-na may si lalla, tungod kay bali labbat mara'at espirito i magbawa-bawa si iya. ");
INSERT INTO abx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sanglit sigi to hamok mga iya pakimalu'oy si Jesus nga ga'i mga iya agpakamandaran pagsallod si Buhon nga gana' salad-na. ");
INSERT INTO abx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aniya' magtarambak kabaktinan nga agparapamu'ad si bihing-na si tagudtod. Agparapakimalu'oy i mga mara'at espirito si Jesus nga akabalyo mga iya si puhu'-na si kabaktinan, ngan agpanugutan-nay to. ");
INSERT INTO abx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pakaguwa'-na si mga mara'at espirito si puhu'-na si lalla, diritsoy to pamabalyo si kabaktinan. Mangno palahi i bug'os grupo pada'iray si pangpang diritso si buwahi' ngan agkaralimbo. ");
INSERT INTO abx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pakakulaw-na si mahinabo' si mga magpangataman si kabaktinan, pamalahi mga iya pan syudad hasta si katahuk-tahukan pagpakatu'an sito. ");
INSERT INTO abx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sanglit agpamada'iray i mga a'a pagpanginsayod. Ngan panakka-na mga iya ari si Jesus, sakulawan-na mga iya i lalla nga ga'i na nagbawa-bawa si mga mara'at espirito. Agparatingkulo' to atubang si Jesus, aniya' na badu'-na, ngan mahalap na gayod i paminsada-na. Ngan tungod sinan, bali i mga katalaw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Padayon pagpasayod i magpakakulaw kon pinapa'i anhalap i nagbawa-bawa. ");
INSERT INTO abx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mangno ag'aradda i mga a'a sakop siray lugar pagpakimalu'oy si Jesus nga kon pwidi pa'amban si mga iya kay ga'i na agpangagwanta si mga katalaw-na. Sanglit pasang'at iya si paraw basi' agpakataliwan. ");
INSERT INTO abx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","I lalla may nga nagpa'ambanan-na si mga mara'at espirito makimalu'oy pag'ibabaya' si iya, pero agpinugad-na dina, ");
INSERT INTO abx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Agbalika na ngan pasumaton i mahaya nagbuhat-na si Diyos para si ka'aw.” Sanglit pa'amban i lalla ngan agpasamwak-na si bug'os syudad i mahaya nagbuhat-na si Jesus para si iya. ");
INSERT INTO abx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagbalik-na kas Jesus, bali labbat i magtupo' si iya tungod kay agpanla'om to dimu'an nga titakka iya. ");
INSERT INTO abx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Kata'ud-ta'uran, aniya' manakka punu'-na si sinaguga nag'arunan Jairo. Addangan hamok sito i dadi'-na, mga dusi anyos i idad-na nga durudangkanda. Pa'akkom dayon iya si kitiran-na si Jesus ngan agparapakimalu'oy nga kon pwidi pada'iray si Jesus si mga ruma'-na, kay agmasakit na i dadi'-na. Si pagparalalangngan-na na kas Jesus, nagparasaligsigan iya si kalabbatan magpamaya'. ");
INSERT INTO abx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aniya' danda ari nga agparalalaha' dusi na ta'on, pero gana' si iya makapahalap. ");
INSERT INTO abx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Patapit iya si damurihan-na ngan agsaphid-na i sidsid-na si badu'-na si Jesus. Mismo siray uras, pahuway dagos i pagdaras-na si laha'-na. ");
INSERT INTO abx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Amatilaw si Jesus, “Say i makasaphid si badu'-ko?” Ngan agbaribad na gayod i dimu'an, aminugad si Pedro, “Sinyor, naggurubukan kaw si mga a'a ngan nagparasaligsigan.” ");
INSERT INTO abx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero aminugad dina si Jesus, “Akatu'anan ako nga aniya' magsaphid si badu'-ko, kay sa'abat-ko nga abantad i gahum-ko pagpahalap.” ");
INSERT INTO abx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pakahuna'-huna'-na si danda nga ga'i na satagu'-na i mahinabo' si iya, padugok iya ngan pa'akkom si kitiran-na si Jesus nga bali pagkurug-kudugan. Agsumat-na atubang si dimu'an mga a'a kon ay kay agsaphid-na si Jesus pati' i hintak paghalap-na. ");
INSERT INTO abx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mangno agpinugad-na iya si Jesus, “Mana, i pagtutu'u-mo, iya i makapahalap si ka'aw. Murayaw pa kunta' i kamutangan-mo.” ");
INSERT INTO abx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Si pagparapahalling-na pa si Jesus, aniya' manakka tikang si ruma'-na si Jairo, i punu'-na si sinaguga, ngan agsumat iya, “Minatay na i dadi'-mo. Gana' na pulus-na si pagpara'ulang-mo si Ma'istroy nan.” ");
INSERT INTO abx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pakabati'-na sinan si Jesus, agpinugad-na si Jairo, “Dakaw abaraka, anutu'uha hamok ngan sigurado anhalap iya.” ");
INSERT INTO abx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ngan panakka-na si ruma'-na kas Jairo, agdiri'-na pagsallod si kwarto i dimu'an mga a'a pwira kas Pedro, Juan, Santiago pati' i mahanak-na si dadi'. ");
INSERT INTO abx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Siray uras, bali kasamukan si mga a'a si guwa' ngan sigi dirinamagay para si dadi'. Animol si Jesus, “Dakam agparapandinamag anan. Ma'in pa iya gayod i kamatayun-na si dadi'. Yayto kamatayon, pariho hamok si magpaturi.” ");
INSERT INTO abx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero nagpattawahan dina si Jesus si mga a'a kay akatu'anan mga iya nga minatay na i dadi'. ");
INSERT INTO abx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mangno, agbikyaw-na si Jesus i tamburu'-na si dadi' ngan aminugad, “Ni', pabanguna!” ");
INSERT INTO abx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Agbalik i espiritu-na, ngan diritso iya pabangon. Mangno tigbuwanan-na si Jesus si mga iya karakanon i dadi'. ");
INSERT INTO abx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nginarat i mga mahanak-na, pero agtugunan-na mga iya si Jesus nga ga'i pagparasumat si bisan say mahi'unong si hinabo'. ");
INSERT INTO abx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mangno agtiripun-na si Jesus i Dusi ngan agpamuwanan-na gahom pagpapinda si dimu'an mga mara'at espirito pati' pagbulong si mga binati'. ");
INSERT INTO abx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mangno aglihug-na mga iya pagpasamwak kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos ngan da'inan may i pagpahalap si mga maburong. ");
INSERT INTO abx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Agtugunan-na mga iya sito: “Dakam agbawa bisan ay si mga langngan-bi. Dakam agbawa baston, bag, karakanon, kwarta, pati' pagsalinan. ");
INSERT INTO abx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bisan singnga kam ruma'a agdayon, dakam palalin tubtob nga pamataliwan kam sinan bungto. ");
INSERT INTO abx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ga'i ngani' kam pinanginano si mga a'a, paspasu-bi i alpug-na si kitid-bi nga tikang sinan bungto kon pataliwan kam pagpakatu'an nga gana' na baratunun-bi si mga iya.” ");
INSERT INTO abx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sanglit pamataliwan i mga inadalan-na ngan agpamada'iray-na i dimu'an kaburubungtuhan hasta i mga kaburubaryuhan pagpasamwak si mahalap sumat pati' pagpahalap si mga maburong. ");
INSERT INTO abx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Siray uras, aka'aning'ing si gubirnador Herodes si dimu'an mahi'unong sinan. Nagsamukan gayod iya tungod kay aniya' magpaminugad nga si Jesus, iya si Juan Paragbunyag nga abanhaw. ");
INSERT INTO abx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aniya' liwat magpaminugad nga agbwilta na si Elias pagtuman si sa'ad, ngan i ditangnga' may agpaminugad nga adda iya paragsumat-na si Diyos siray mga panahon nga abanhaw. ");
INSERT INTO abx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero aminugad si Herodes, “Agpapugutan-ko na si Juan. Pero say to? Malabbat mga urusahon sapakalihan-ko parti si iya.” Sanglit agtalinguha gayod iya nga sabagatan-nay to. ");
INSERT INTO abx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ngan pabwilta-na si mga apostol kahuman si pagpanlibut-na, agsumatan-na mga iya si Jesus si mga nagpanbuhat-na. Mangno agpangagda-nay to nga pamalitira mga iya pada'iray si syudad Betsaida nga mga iya hamok. ");
INSERT INTO abx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero malabbat i magpaka'aning'ing ngan agpanlanat si mga iya. Agtupu'-na si Jesus i mga a'a ngan agpanginanu-na. Agpangisturyahan-nay to kon pinapa'i mga iya agpakasakop si nagpanhadi'an-na si Diyos ngan agpamahalap-na i mga binati'on. ");
INSERT INTO abx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngan pagtutunud-na na si allaw, pamadugok si Jesus i Dusi ngan agpaminugad, “Pamalitirahon naynan mga a'a basi' agpakapada'iray na mga iya si mamatapit baryo pati' katahuk-tahukan nga agpaka'anda' si mga karakanun-na pati' si mga pandidiskansuhan-na. Atiya' kita kam akatuman si mamingaw lugar.” ");
INSERT INTO abx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero anaruman dina iya, “Ka'am na hamok i mamuwan karakanon si mga iya.” Lingun-na may mga iya, “Lima na hamok bug'os pan-tay to kam pati' duwa agon. Aruyag ba' kaw nga palangngan kami' pagballi karakanon para sito mga a'a dimu'an?” ");
INSERT INTO abx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bisan i mga lalla hamok magtambong ari anakka si mga singko mil. Pero agmandaran-na dina i mga inadalan-na, “Pamalumpagi'u-bi i mga a'a sasurusingkwinta.” ");
INSERT INTO abx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Anunod i mga inadalan-na sanglit agpanlumpagi' i dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Katapos, ag'ala'-na si Jesus i lima bug'os pan pati' i duwa agon. Anhangad iya ngan agpasalamat si Diyos. Mangno agpanurutabbi'-na ngan agpumwan-nay to si mga inadalan-na pagtaltag si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Agpakakakan i dimu'an ngan agpakagustuhan. Katapos akatipon pa dina i mga inadalan dusi sagad nga puro panno' si mga tinurutabbi' la'a. ");
INSERT INTO abx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sin adda, akapangadyi' si Jesus atubang si mga inadalan-na hamok tungod kay ga'i ari i kalabbatan nga agsob magpamungyod. Mangno amatilaw iya, “Si mga burubaragaw-na si mga a'a, say may kuno' ako?” ");
INSERT INTO abx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Anaruman may mga iya, “Aniya' magpaminugad nga ka'aw kuno' si Juan Paragbunyag, ngan i ditangnga' may, ka'aw kuno' si Elias. Pero aniya' liwat magpaminugad nga tingali addangan pa kaw kuno' si mga paragsumat-na si Diyos siray nga abanhaw.” ");
INSERT INTO abx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Amatilaw gihapon iya, “Pero para si ka'am, say may i pagkakilala-bi si ako?” Anaruman may si Pedro, “Ka'aw i Tinu'inan Mannanalwas nga nagpabawa-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bali gayod katutugun-na si mga iya si Jesus nga ga'i pagsumat sito si bisan say. ");
INSERT INTO abx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Agpadayon si Jesus pag'isturya si mga iya, “Kinahanglan ag'agi pala'in-la'in kasakitan i Pinili' A'a ngan diriri'on iya si mga mata'o kamabu'utan, si mga puno' paraghalad pati' si mga paragturo' bala'od. Pwira pa sinan, maratayon iya, pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kata'ud-ta'uran, agsumatan-na mga iya dimu'an, “Kon aniya' maruyag pagbaya' si ako, kinahanglan limut-na i mga kalugaringun-na katuyu'an, ngan agsunod si ako. Padayun-na si allaw-allaw i pag'ako' si mga pag'antus-na pariho si adda makamamalo' kamatayon si kudos. ");
INSERT INTO abx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kay bisan say i magpasiguro si kalugaringun-na kinabuhi' ina'anto, iya dina i tikarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero bisan say i magkarag si kalugaringun-na kinabuhi' para si ako, iya dina i aniya' ungod kasiguruhan-na. ");
INSERT INTO abx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ay i kapulsanan-na kon satawa'-na si a'a i bug'os kalibutan pero agrungay-na o ma'in ngani' agkaragan-na dina i kinabuhi' nga gana' katapusan-na? Gana'! ");
INSERT INTO abx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sanglit kon aniya' nga agkasipugan-na ako o ma'in ngani' i mga allingun-ko, karasipugan-na may liwat iya si Pinili' A'a si pagpada'itu-na nga nagsigahan na palibot si maka'angayan danta'-na hasta i tawa'-na si Tata' pati' si mga sagrado anghel. ");
INSERT INTO abx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sumatan-ta kam si kamatu'uran, aniya' si mga satu'oy to ina'anto nga ga'i amatay tubtob nga ga'i pa mga iya sakulawan-na i paghadi'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga walo' allaw tikang si pagpinugad-na sinan si Jesus, tigbaya' iya kas Pedro, Juan pati' Santiago pasagka si adda bukid pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Si pagparapangadyi'-na, agla'in i itsura-na ngan masuri'aw i badu'-na pariho si kil'at. ");
INSERT INTO abx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kata'ud-ta'uran, hintak pamaluwa' duwangan to, Moises pati' Elias. Nagsigahan mga iya si maka'angayan danta' ngan agbararagaw mga iya kas Jesus hi'unong si kamatayun-na nga turumanun-na ari si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Siray uras agpanyuyungka' kas Pedro pero pakamangnu-na na mga iya, sakulawan-na i maka'angayan danta'-na si Jesus pati' i duwangan magtutunggo huwang-na. ");
INSERT INTO abx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ngan tilitira nayto mga a'a, agpinugad-na si Pedro si Jesus, “Sinyor, mahalap gayod kay atiya' kita kam. Anhimo kami' tallo payag-payag para si ka'am, i adda para si ka'aw, i adda may tawa'-na si Moises, ngan i adda namay tawa'-na si Elias.” Ga'i gayod iya akatu'anan kon ay i angay pinahalling-na. ");
INSERT INTO abx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Si pagparapahalling-na, aniya' pahulwa' madakmol panganod ngan bali gayod i mga kangarat-na si pagtatambun-na si mga iya sito. ");
INSERT INTO abx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mangno aniya' busis tikang si panganod nga agpinugad, “Iyay nan i Dadi'-ko nga pinili'-ko. Amati'a kam si iya.” ");
INSERT INTO abx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ngan pahuway-na na si busis, samangnuhan-na mga iya nga si Jesus na hamok i sari'i. Aghilum-nay to hamok si mga inadalan ngan gana' gayod nagsumatan-na mga iya siray uras si mga sakulawan-na. ");
INSERT INTO abx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Si padalugdug-na mga iya ka'asumuhan tikang si bukid, bali namay labbat i magtupo' si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aniya' manurakaw si magpanggubok, “Ma'istro, kalu'uyin daw ako pagkulaw si dadi'-koy to lalla kay iya hamok i dadi'-ko. ");
INSERT INTO abx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nagbawa-bawa iya si mara'at espirito ngan balang ta'ud-ta'od nagtagbo' to ngan hintak anurakaw. Parapadusmug-nay to ngan sigi-na pa'ariwasa tubtob amura' i bawa'-na. Labbahan-nay to hamok iya kon aghatlay na gayod i puhu'-na ngan mammatayon na. ");
INSERT INTO abx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Agparapakimalu'oy na ako si mga inadalan-mo nga kon ahimo papinda-nay to mga iya, pero ga'i mga sahimu-na.” ");
INSERT INTO abx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Anaruman si Jesus, “Ay badaw! Ga'i pa gayod anutu'o mga a'ay to ina'anto panahon ngan bali kamakasuplikado! Pira pa i kinahanglan pag'istar-ko ato pati' i irilubun-ko si ka'am basi' agpanutu'o kam? Bawahon ato dadi'-moy nan.” ");
INSERT INTO abx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Si paduguk-na si dadi', agpadusmug-nay to iya si mara'at espirito ngan tinakka si buntug-na. Pero ag'isugan-na si Jesus i mara'at espirito, ngan agpahalap-na i dadi'. Mangno agpa'intriga-nay to ari si tatay-na. ");
INSERT INTO abx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ag'usa gayod i dimu'an mga a'a si pagkaharangdun-na si Diyos. Si pagpara'usa-na si mga a'a si dimu'an nagbuhat-na si Jesus, aminugad to ari si mga inadalan-na, ");
INSERT INTO abx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Amati'a kam pahalap si mga papahallingun-koy to si ka'am: Trarayduran i Pinili' A'a ngan papa'intrigahon iya si pagdalum-na si mga a'a.” ");
INSERT INTO abx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ga'i mga iya agpakasabot si karuyag sidngun-na sinan. Agpadayon payto nga tinago' si mga iya sanglit ga'i mga sasantup-na ngan agkataralaw liwat pagpatilaw mahi'unong sinan. ");
INSERT INTO abx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aniya' nagkadiriskusyunan-na si mga inadalan parti si kon say i mahimo pinakabantugan si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tungod kay sakatu'anan-na si Jesus i mga inisipan-na, aniya' dadi' nagban'u-na ngan agpatunggu-nay to si kagiliran-na. ");
INSERT INTO abx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mangno agpinugad-na mga iya, “Bisan say i magpanginano pahalap si a'a nga ga'i mismo aka'allom si kalugaringun-na pariho sito dadi' tungod si gugma'-na si ako, agpanginano gayod si ako. Ngan bisan say i magpanginano si ako, ma'in hamok ako i nagpanginanu-na, pero hasta pa liwat i magpapada'ito si ako. Sapinugad-koy to kay bisan say si ka'am i pinakaminos si pangulawan-bi, iya dina i pinakabantugan.” ");
INSERT INTO abx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Agsumatan-na si Juan si Jesus, “Sinyor, aniya' lalla sakulawan kami' magparapapinda si mga mara'at espirito pina'agi si paggamit si arun-mo. Agsumatan kami' nga kinahanglan iya pahuway kay ma'in iya huwang si kita kam.” ");
INSERT INTO abx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Anaruman may si Jesus, “Dakam nan a'a agsimulu-bi, kay bisan say i ga'i manguntra si ka'am, huwang may iya si ka'am.” ");
INSERT INTO abx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ngan agtikatapit na gayod i allaw nga aralsahon na si Jesus pan langit, agpapirmaninti-na i disisyun-na pagpada'iray si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aniya' nagpanangpit-na mga a'a pagdahulo si iya ngan agpakatakkay to si adda bungto si Samaria. Ag'andam kunta' mga iya ari si dimu'an nagkinahanglan-na si Jesus, ");
INSERT INTO abx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","pero si panakka-na ari, ga'i iya nagpanginano kay kinatu'anan nga pan Jerusalem i arup-na. ");
INSERT INTO abx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pakasabut-na sinan si duwangan inadalan-na nga kas Santiago pati' Juan, aminugad mga iya, “Paragdalom, aruyag ba' kaw nga tigtaktak kami' api man langit basi' agkasurunog mga iya dimu'an?” ");
INSERT INTO abx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero tili'-na dina mga iya si Jesus ngan agpangisugan-na. ");
INSERT INTO abx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mangno agdiritso mga iya si manunod bungto. ");
INSERT INTO abx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Si pagparapamaktas-na na mga iya, aniya' addangan lalla maminugad si Jesus, “Amungyod ako si ka'aw bisan singnga kaw pa'arop.” ");
INSERT INTO abx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Anaruman si Jesus, “Mahalap pa i mga singgarong kay aniya' mga panluluku'an-na, pati' i mga kamanuk-manukan kay aniya' pannanapunan-na, pero i Pinili' A'a, gana' ngani' lugod panlilibbakan-na nga akadiskanso iya.” ");
INSERT INTO abx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mangno agmando' si Jesus si la'in namay a'a, “Amaya'a ngan agsunura si ako.” Pero anaruman dina i a'a, “Sinyor, tugutin ako dahulo pagbalik hasta si pakamatay-na si tatay-ko.” ");
INSERT INTO abx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aminugad si Jesus si iya, “Pata'anin na hamok nga i mga minatay i mamalabbong si mga minatay-na, pero ka'aw, palangngana ari ngan pasamwakon kon pinapa'i i a'a akasakop si nagpanhadi'an-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aniya' gihapon addangan maminugad, “Sinyor, aruyag ako pagsunod si ka'aw, pero agbalik ako dahulo pagsarit si pamilya-ko.” ");
INSERT INTO abx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Anaruman si Jesus, “I mag'arado nga sigi pa dina titili' si damurihan-na, ma'in angay nga huwang iya si pagsirbi-na si mga nagpanhadi'an-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kahuman sinan, agtu'in i Ginu'o sitintay dos la'in inadalan nga papadahulu'un-na saduwang-duwangan pada'iray si mga pala'in-la'in lugar aragihan-na. ");
INSERT INTO abx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Agsumatan-nay to mga iya, “Malabbat kunta' i aranihon pero diki'it hamok i mangngangani. Aniya' paragdalom si aranihon nga iya i pinalakuhi-bi pagpabawa pa mga trabahanti si nagpa'anihan-na. ");
INSERT INTO abx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pada'iraya na kam! Agmatuha kam kay ari si papabawahan-ko si ka'am, akapariho kam hamok si mga nati karniro nga akasalakot si mga ma'isog hayop. ");
INSERT INTO abx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dakam agbawa pitaka, bag, pati' adda pa sandalyas, ngan dakam agkarag si uras pagpakibagaw kon aniya' satupu'-bi si lalan. ");
INSERT INTO abx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kon tipanahik kam si adda ruma', aminugara kam dahulo, ‘Pumwan-na kunta' i kamurayaw-na si Diyos si dimu'an mag'istar sito ruma'.’ ");
INSERT INTO abx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kon i tata' anan sinan ruma' aghandom si kamurayaw, sakarawat-na i kamurayaw nagpalaku-bi para si iya. Pero kon ga'i iya aghandom si kamurayaw, pabwiltay nan gihapon si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Si paka'anda'-bi si ruma' nga angarawat, angistara kam anan ngan aku'u-bi i bisan ay pinumwan-na mga iya si ka'am karakanon pati' irinumon, kay angay hamok nagsuhulan i trabahanti. Dakam paralalin-lalin si pala'in-la'in ruma'. ");
INSERT INTO abx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kon akapada'iray kam si adda bungto ngan mahalap si ka'am i pagkapanginano, amangana kam bisan ay i nagpatulud-na mga iya si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pahalapu-bi i mga maburong sabagatan-bi, ngan panumati-bi nga anakka na i uras nga agpakasakop na mga iya si mga nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero kon akapada'iray kam si adda bungto nga gana' si ka'am magpanginano, pankalsadaha kam ngan pinugaru-bi, ");
INSERT INTO abx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Bisan i alpog nga tikang si bungtu-bi to nga andukot si mga kitid kami', paspas kami' pagpakatu'an nga anggana' na baratunon kami' si ka'am. Pero tigamani-bi to: Anakka na i uras nga agpakasakop na kam kunta' si nagpanhadi'an-na si Diyos.’ ");
INSERT INTO abx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sanglit sumatan-ta kam, mas maningkarang pa i arabatun-na kastigo si magpangistar siray si syudad Sodom si damuri allaw kuntra si arabatun-na sinan bungto mismo liwat sinan allaw. ");
INSERT INTO abx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mga papabidu'on kam mga taga Corasin! Mga papabidu'on liwat kam mga taga Betsaida! Kon nagbuhat siray ari si mga syudad Tiro pati' Sidon i mga makagagahom binuhatan nagpakulaw si ka'am, maliyat na kunta' panahon i pagbasul-na mga iya huwang si pagbag'o, pina'agi kunta' si pagpanlipag'ak-na, nga mga makatol sako i mga badu'-na, panno' agbon i mga takuluk-na. ");
INSERT INTO abx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sanglit mas maningkarang pa i arabatun-na kastigo si magpangistar siray si Tiro pati' Sidon si allaw si paghusgar kuntra si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ngan ka'am may mga taga Capernaum nan, gasi-bi ba' nga darayawon kam hasta si pagtakka-bi ari si langit? Ma'in, lugod agpakapada'iray kam dina si dilalom pitak. ");
INSERT INTO abx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Bisan say i magpamati' si ka'am, agpamati' si ako, ngan bisan say i mandiri' si ka'am, andiri' may si ako. I mandiri' si ako, ma'in hamok ako i nagdiri'-na pero hasta pa liwat i magpapada'ito si ako.” ");
INSERT INTO abx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Palangngan i sitintay dos ngan agbwilta gihapon si tama' uras. Bali i mga kalipayan-na ngan agpaminugad mga iya, “Paragdalom, bisan i mga mara'at espirito agpatubyan si kami' pina'agi si paggamit kami' si arun-mo.” ");
INSERT INTO abx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Anaruman si Jesus, “Sakulawan-ko i pagluya-na si Satanas nga hintak alaho' man langit pariho si linti'. ");
INSERT INTO abx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Agbuwanan-ta na kam gahom nga agpakatumban kam sawa ngan agpakapigis sipit-sipit, ngan salupig-bi i dimu'an gahum-na si kuntra-ta. Gana' gayod si ka'am makalabot. ");
INSERT INTO abx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero dakam agkarilipay tungod hamok kay agpatubyan si ka'am i mga espirito, kundi' aglipaya kam tungod kay akahuwang i mga arun-bi si listahan ari si langit.” ");
INSERT INTO abx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mismo siray uras, bali i kalipayan-na si Jesus nagpumwan-na si Espirito Santo, ngan akapinugad, “Tay, ka'aw nga Paragdalum-na si kalangitan pati' si kalibutan, agdayaw ako si ka'aw kay agtagu'-mo i sarabutan hi'unong si pagkahadi'-mo. Agtagu'-moy nan si mga madunong pati' malanga idukasyun-na ngan agpakatu'an-moy nan si mga makapariho si mga dadi'-dadi' nga mapa'inubsanon. Tay, ka'angayan nga ahinabo' nan, kay iyay nan i makapalipay si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mangno agpadayon iya pagbagaw si magpanggurubok, “Agpatubyan-na na si ako si Tatay-ko i dimu'an kata'o pati' pagdalom. Gana' ni addangan makatu'anan kon say i Dadi' kon ma'in hamok i Tata', ngan gana' ni addangan makatu'anan kon say i Tata' kon ma'in hamok i Dadi' pati' i mga nagpamili'-na si Dadi' pagpakilala kon say iya.” ");
INSERT INTO abx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Angatubang si Jesus si mga inadalan-na ngan aminugad si mga iya hamok, “Mga malipayon gayod i mga magpakakulaw si mga sakulawan-bi. ");
INSERT INTO abx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kay sumatan-ta kam, siray mga panahon aniya' malabbat mga paragsumat-na si Diyos pati' mga hadi' nga agparapanhandom pag'ikukulaw si mga sakulawan-bi, pero gana' si mga iya magpakakulaw. Malabbat magpanhandom nga agpakapakali si mga sapakalihan-bi, pero ga'i mga iya agpakapakali.” ");
INSERT INTO abx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sin adda, aniya' manunggo atubang si Jesus nga addangan si mga kunusido si bala'od. I tuyu'-na hamok sito pagpurbar kon anala' si Jesus si mga allingun-na, sanglit amatilaw iya, “Ma'istro, ay i kinahanglan buruhatun-ko basi' sakarawat-ko i kinabuhi' nga gana' katapusan-na?” ");
INSERT INTO abx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Anaruman si Jesus, “Ay i maka'anna' si Bala'ud-na si Moises? Ay i pagkasabut-mo si sabasa-mo ari?” ");
INSERT INTO abx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aminugad may iya, “Higugma'u-bi i Paragdalom Diyus-bi si bug'os kasing-kasing-bi, si bug'os kina'iya-bi, si bug'os kusug-bi pati' si bug'os paminsada-bi, ngan higugma'u-bi i igkasi a'a-bi pariho si paghigugma'-bi si kalugaringun-bi.” ");
INSERT INTO abx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tama' gayod i mga saruman-mo. Sabuhat-mo ngani' nan, sigurado nga a'allom kaw hasta si kahastahan,” lingun-na may si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero aruyag iya pagpaklaro nga matadong i kalugaringun-na, sanglit amatilaw iya gihapon si Jesus, “Oho' gad, ngan kas say may i igkasi a'a-ko?” ");
INSERT INTO abx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yayto isturya i nagpasaruman-na si Jesus: “Aniya' addangan man Jerusalem nga padalugdog pan syudad Jerico. Ngan ari na iya si tinampo, atupo' to si mga tulisan ngan naghugkasan iya si mga gamit-na ngan bali i pagkakastigo. Pagkatapos nag'ambanan iya nga day minatay na i kamutangan-na. ");
INSERT INTO abx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Siray uras, aniya' paraghalad nga akatuman padalugdog si pariho tinampo. Pakapantaw-na si nagtulis, pabalidbid to nga salihisan-na. ");
INSERT INTO abx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mangno aniya' liwat addangan tilabay nga huwang si grupu-na si mga paraghalad Levita. Si panakka-na liwat siray lugar ngan sapantawan-na i a'a, pabalidbid to nga salihisan-na. ");
INSERT INTO abx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kundi' si katapus-tapusan aniya' Samaritano nga agbiyahi. Ngan aragihan-na na i lugar-na siray a'a, sapantawan-nay to ngan angabat dayon mahaya kalu'oy. ");
INSERT INTO abx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Agduguk-nay to dayon ngan agpanampusan-na i mga kasamaran-na ngan agta'ta'an-na liwat lana pati' bino. Mangno agpasakrang-nay to si asnu-na ngan agbawa-na si adda ruma' pandidiskansuhan ngan iya mismo i mag'ataman. ");
INSERT INTO abx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ngan titaliwan na iya ka'asumuhan, agparu'du'an-na duwa dinari diplata i tinapuran si ruma' pandidiskansuhan. Agtugon iya, ‘Atamanin ako pahalap si iya, kay bayaran-ta may kaw kon pira pa i sagastu-mo si pagbwilta-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Tara', say may si tallungan ray si pag'abat-mo i magpakulaw nga adda iya igkasi-na si a'ay ray nga atupo' si mga tulisan?” ");
INSERT INTO abx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Anaruman may i kunusido si bala'od, “I addangan nga alu'oy si iya.” Agpinugad-na iya si Jesus, “Hala, irugon i nagbuhat-na.” ");
INSERT INTO abx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Si pagparalalangngan-na na gihapon kas Jesus pati' si mga inadalan-na, akahapit iya si adda baryo ngan akahawiran si addangan taga sunsari'i danda. Marta i arun-na ngan ");
INSERT INTO abx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","aniya' liwat sito sirari-na nag'arunan Maria. Pamanahik-na si Paragdalom, palumpagi' dagos i sirari atubang si iya pagpakali si mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero sibot dina si Marta si katitima si dimu'an papasirbihun-na. Padugok iya si Jesus ngan aminugad, “Paragdalom, gana' ba' hamok si ka'aw bisan kon agpata'anan-na ako si sirari-ko pagtrabaho ato sulu-sulo? Pinugaron iya nga buligan-na ako!” ");
INSERT INTO abx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Anaruman i Paragdalom, “Marta, Ni', panno' kaw si kabaraka ngan kasamok si huna'-huna' parti si pala'in-la'in. ");
INSERT INTO abx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aniya' hamok adda nga kinahanglanon gayod. Mahaya i kahalapan-na si sapili'-na si Maria, ngan ga'i nayto abawi' pa tikang si iya.” ");
INSERT INTO abx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Adda allaw agpangadyi' si Jesus si adda lugar. Si pakatapus-na, addangan si mga inadalan-na i maminugad si iya, “Paragdalom, turu'in daw kami' pagpangadyi' basi' akapariho kami' si mga inadalan-na si Juan nga agturu'an-na pagpangadyi'.” ");
INSERT INTO abx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agsarumanan-na mga iya, “Mangadyi' ngani' kam, pinugaru-bi: Tatay, pakulawon ato si kinabuhi' kami' i kasagradu-na si arun-mo, dalumin kami' nga kinakulawan i paghadi'-mo ato. ");
INSERT INTO abx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Buwanin kami' si karakanon kami' nga tama' si ina'anto allaw. ");
INSERT INTO abx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasayluhon kami' si mga sala' kami', kay agpasaylo kami' na i dimu'an makasala' si kami', ngan patuttuton kami' nga ga'i kami' agsala' kon nagtintar kami'.” ");
INSERT INTO abx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mangno agpinugad-na mga iya, “Baga-baga addangan si ka'am mamukaw si kumpaniya-mo si magkatutnga' kay makibagaw kaw, ‘Sangkay, pa'indamon daw kita dahulo tallo bug'os pan, ");
INSERT INTO abx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kay aniya' kumpaniya-ko liwat nga awiray agdayon si ruma' tikang si matala biyahi. Gana' gayod sapatulud-ko si iya.’ ");
INSERT INTO abx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Anaruman may i sari'i si sallod, ‘Dakaw na ako agpuyaton. Trangkado na i pwirtahan ngan atiya' na liwat pama'ubay si ako i mga dadi'-ko. Ga'i na ako pwidi pabangon pagbuwan si ka'aw si bisan ay.’ ");
INSERT INTO abx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sumatan-ta kam, maski kaw kumpaniya-na gayod, ga'i iya pabangon pagbuwan si pan nagpalaku-mo, kundi' i nagbangunan-na sito iya i ga'i paghuway-mo si kapapakibagaw, ngan buwanan-na kaw si dimu'an nagkinahanglan-mo. ");
INSERT INTO abx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Sanglit yayto i sumat-ko si ka'am: Amalakuha kam basi' binuwanan kam. Mamuraw-purawa kam basi' aniya' sa'anda'an-bi. Aman'uha kam basi' pinadayon kam. ");
INSERT INTO abx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Buhatu-bi nan kay bisan say i mamalako akabuwanan, ngan bisan say i mamuraw-puraw aka'anda', ngan bisan say i maman'o agpakadayon. ");
INSERT INTO abx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Say si ka'am mga tatay, nga kon amalako daying i dadi'-mo, buwanan-mo dina sawa? ");
INSERT INTO abx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ma'in ngani', kon amalako iya antallo, buwanan-mo dina sipit-sipit? ");
INSERT INTO abx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pa'anna'-ta si ka'am may, bisan kon mga mara'at i kina'iya-bi dimu'an, agbuwan kam mga mahalap rigalo si mga dadi'-bi. Iya pa ba' i Tatay-bi ari si langit, i ga'i mamuwan si Espirito Santo si magpamalako sinan si iya!” ");
INSERT INTO abx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aniya' nagpapindahan-na si Jesus mara'at espirito nga kapangula. Papinda-na si mara'at espirito, akapahalling dayon i mangula, sanglit bali i pag'usa-na si magpanggubok. ");
INSERT INTO abx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero aniya' si mga iya i maminugad dina, “Akapapinda iya si mga mara'at espirito pina'agi si gahum-na si Beelsebul, i prinsipi-na si dimu'an mara'at espirito.” ");
INSERT INTO abx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","I ditangnga' may sigi dina pamalako si Jesus pangngilalahan si langitnon kasiguruhan pagpasiguro kon say gayod iya. ");
INSERT INTO abx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Akatu'anan si Jesus si mga inisipan-na hi'unong si Beelsebul, sanglit agpaminugad-na mga iya, “Kon aniya' nasyon nga ag'urunay i mga a'a-na, sigurado nga tulos to abungkag. Ngan da'inan may si pamilya, kon ag'urunay i mga sakup-na sito, sigurado nga ga'i to akatunggo. ");
INSERT INTO abx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kon ag'urunay mismo i mga kahuruwangan-na si Satanas, pinapa'i-na may pakatunggo si ginhadi'an-na? Agsumatan-ta kam sito kay agpaminugad kam nga agpapinda ako si mga mara'at espirito pina'agi si gahum-na si Beelsebul. ");
INSERT INTO abx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sanglit kon i gahum-na si Beelsebul i naggamit-ko pagpapinda si mga mara'at espirito, say may tawa' gahom i naggamit-na si mga mannurunud-bi pagpapinda si mga iya? Kon sugad, mismo bali' mga iya i maghusgar pagpamatu'od nga sala' i mga isip-bi. ");
INSERT INTO abx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero kon i pagpapinda-ko si mga mara'at espirito pina'agi si gahum-na si Diyos, sigurado nga aghadi' na i Diyos si lugar-bi to. ");
INSERT INTO abx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kon aniya' addangan nga makusog, ma'armas ngan agbantay si ruma'-na, sigurado nga gana' makatangkaw si mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero kon naglusob iya si mas makusog pa nga salupig-na iya, sigurado nga siyuhan-nay to si mga armas nagtapuran-na ngan puruparti-na i mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Bisan say i ga'i mamungyod si ako, anguntra si ako, ngan da'inan may liwat, bisan say i ga'i pahuwang si ako pag'agda a'a nga anutu'o, iya dina i magpawararak si mga aragdahun-ko. ");
INSERT INTO abx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Si papinda-na si mara'at espirito si adda a'a, ag'agi to si mga matuho' gayod lugar ngan sigi anda' si pandidiskansuhan-na. Tungod kay ga'i may aka'anda', aminugad to si kalugaringun-na, ‘Agbalik ako si inambanan-koy ray.’ ");
INSERT INTO abx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Si panakka-na ari, sakatu'anan-na nga day sinilhigan gayod ngan mahamis i dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mangno agbwilta iya pag'agda pa pito' kahuruwangan-na mara'at espirito nga mas mara'at pa kuntra si iya. Pa'ayop to mga iya ari basi' mga sabawa-bawa-na. Sanglit i kamutangan-na si a'a si damuri to mas mara'at pa dina kuntra si primiro.” ");
INSERT INTO abx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Si pagparapahalling-na sinan si Jesus, aniya' danda mamahalling makusog tikang si magpanggubok, “Malipayon i nanay magburod ngan magpasuso si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Anaruman iya, “Mas malipayon dina i mga magpakapakali si allingun-na si Diyos ngan agpansunod sito.” ");
INSERT INTO abx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Si pagtatamba-na si magpanggubok, aminugad si Jesus, “Kinakulawan gayod i kara'at-na si mga a'a ina'anto panahon kay sigi hamok paralakuhay si mga pangngilalahan si langitnon kasiguruhan. Pero gana' na purumwanon pa si mga iya pwira si pangngilalahan siray nga nagbuhat si Jonas. ");
INSERT INTO abx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Si Jonas mismo i naghimo pangngilalahan para si magpangistar si syudad Ninibe, ngan pariho si iya, i Pinili' A'a may liwat i papakulawon pangngilalahan si langitnon kasiguruhan sito panahon. ");
INSERT INTO abx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aniya' titakka allaw nga abanhaw i mga allom pa ina'anto basi' agpakahusgaran. Sinan allaw, abanhaw may liwat i Rayna si Sur. Iya i magparabiyahi siray tikang si matala lugar pagpamati' si madunong pinahallingan-na si Solomon. Sanglit tungod sinan matadong binuhatan, nagpatukan i dimu'an magka'arallom ina'anto tungod si mga buhat-na kay atiya' na i mas labaw pa kuntra si Solomon nga angay lugod dina durugukon. ");
INSERT INTO abx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Si pariho pa'agi, kon anakkay nan allaw, abanhaw may liwat i magpangistar siray si syudad Ninibe pagtistigos kuntra si mga allom pa ina'anto kay agpamasol mga iya siray huwang si pagbag'o si pakapakali-na mga iya si nagpasamwak-na si Jonas. Sanglit tungod sinan matadong binuhatan nagpatukan i mga magka'arallom ina'anto tungod si mga buhat-na kay atiya' na i mas labaw pa kuntra si Jonas nga angay lugod dina parakalihan.” ");
INSERT INTO abx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gana' ato magsulsol lampara, mangno agpa'anna'-na dina si lugar nga ga'i kinakulawan, o ma'in ngani' nagtambunan dina si batiya'. Lugod, agpa'anna'-nay to si tama' pamma'anna'an basi' sakulawan-na dayon i danta' si pasallod. ");
INSERT INTO abx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I mga mata-bi akapariho si lampara anan si puhu'-bi. Kon mahalap i mata-bi, panno' may si danta' i bug'os puhu'-bi. Pero kon mara'at to, bali may liwat lu'om i puhu'-bi. ");
INSERT INTO abx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pasiguruha kam nga i kadanta'an-na si puhu'-bi ma'in dina kalu'uman. ");
INSERT INTO abx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kon sugad, kon panno' si danta' i bug'os puhu'-bi, ngan gana' parti sito nga malu'om, akadanta'an gayod i puhu'-bi pariho kon akasana'agan kam si danta'-na si lampara. ");
INSERT INTO abx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pakahuman-na si Jesus pagpahalling, aniya' Parisiyo mag'imbitar si iya pagkakan ari si mga ruma'-na. Sanglit amaya' iya ngan agtarangka' mga iya si pagkakanan, ");
INSERT INTO abx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","pero apa'usa i Parisiyo kay ga'i agtuman si Jesus si tama' pa'agi pagkuso' myintras amangan. ");
INSERT INTO abx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mangno agpinugad-na iya si Ginu'o, “Mga mahalap kam gayod mga Parisiyoy nan agpanhugas si gawas-na si mga tasa-bi pati' si mga mangku'-bi, pero i mga huna'-huna'-bi panno' si kabintahuso pati' si dimu'an klasi karat'an. ");
INSERT INTO abx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga kapay kam gayod kay ga'i kam manginano si titakka! Ma'in ba' pariho i kamutangan-na si garamiton pati' si a'a, kon say i maghimo si gawas, iya gihapon i maghimo si sallod? ");
INSERT INTO abx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kunta' agda'itu-bi, pumwan-bi i isi-na si mga mangku'-bi si mga anggana', ngan ahimo limpyado i dimu'an sana'an si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mga papabidu'on kam gayod mga Parisiyoy nan kay bisan kon agsunud-bi i bala'ud-na si Diyos pagbuwan dyis pursyinto si iya si dimu'an inanda'an-bi hasta nga agtukib-bi pa liwat i dyis pursyintu-na si mga tinanum-bi panakot, bisan i mga mamamis, malassom hasta pa i mga maharang, pero ga'i may lugod dina agpanginanu-bi i tama' pagtratar si a'a pati' i paghigugma' si Diyos. Yayto kunta' dina damurihan to i kinahanglan nagbuhat-bi si pagparapanginanu-bi si dahulo. ");
INSERT INTO abx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mga papabidu'on kam mga Parisiyoy nan, kay i mga printi pirmi panningkulu'an ari si sinaguga i mga nag'anduy-bi, ngan agkararuyag liwat kam si mga talahuron pangumusta-na si mga a'a ari si mirkado. ");
INSERT INTO abx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mga papabidu'on kam, kay agpakapariho kam si labbong nga gana' na sinyal-na nga nagparaturutum'akan na dina si mga a'a nga ga'i agpakatu'an-tu'anan.” ");
INSERT INTO abx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Addangan si mga kunusido si bala'od ari i manaruman si iya, “Ma'istro, kami' may liwat i nagparapabati'-bati'-mo si mga nagparapahalling-moy nan.” ");
INSERT INTO abx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Anaruman si Jesus, “Hasta ka'am mga kunusidoy nan si bala'od, papabidu'on liwat kam gayod kay agparapanhimo kam mga rilihuso kabatasanan ngan agparapapalangkit-bi to nga mga mabuwat gayod nagda'og si mga a'a, ngan ga'i ngani' kam amikyaw pagbulig bisan diki'it. ");
INSERT INTO abx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mga papabidu'on kam, kay agparapamantyunan-bi i mga paragsumat-na si Diyos siray, bisan kon i mga kapapu'an-bi i magpanmatay si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kon sugad kinakulawan mismo si ka'am nga ag'alagad kam si mga binuhatan-na si mga kapapu'an-bi. Agpanmatay-na mga iya i mga paragsumat-na si Diyos, ngan ka'am may i magparapamantyon si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tungod sinan paluwa' na i kadunung-na si Diyos nga dati agpinugad, ‘Amabawa ako si mga iya mga paragsumat-ko pati' mga apostol. I ditangnga' si mga iya nagpanmatay ngan i ditangnga' may nagparapamasakitan tungod si mga pagtutu'u-na.’ ");
INSERT INTO abx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kon sugad mga a'ay to ina'anto panahon i mga papasarumanon si mga laha'-na si dimu'an paragsumat-na si Diyos nga nagpamaturo' tikang pa gayod si paghimo si kalibutan. ");
INSERT INTO abx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","I primiro, iya i pagmatay-na mga iya si Abel ngan si Sacarias i pangultimo, nga nagmatay si pagkagul'atan-na si altar pati' si templo. Sumatan-ta kam, ungod to nga i mga a'a sito panahon i papasarumanon sito dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mga papabidu'on kam mga kunusidoy nan si bala'od, kay agsiyu-bi i lyabi si pwirtahan nag'inala'an si kata'o si Kasuratan. Mismo ka'am, ga'i agpakasallod sinan ngan ag'ulang-bi i mga tisallod.” ");
INSERT INTO abx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Si paduwa'i-na si Jesus tikang siray ruma' agkuntra-na dayon iya si mga Parisiyo pati' si mga paragturo' bala'od ngan pirmi na iya nagparapasunud-sunuran si mga pala'in-la'in patilaw, ");
INSERT INTO abx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","paglipat-lipat basi' sadakup-nay to mga iya kon anala' si mga saruman-na. ");
INSERT INTO abx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Si pariho uras, aggurubok i niyukut-yukot mga a'a tubtob nga agsituruturum'akay i balang addangan. Agpadahulu-na si Jesus agsumat i mga inadalan-na sito mga allingon: “Agpanlikaya kam si pammatubu'-na si mga Parisiyo nga iya i mga kina'iya-na pagparapamakunu-kuno nga mga rilihuso. ");
INSERT INTO abx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gana' ato nagtambunan nga ga'i gihapon akabukasan, o ma'in ngani' nagtago' nga ga'i kinatu'anan. ");
INSERT INTO abx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bisan ay i nagsumat-mo si kalu'uman, kinapakalihan gihapon si kadanta'an, ngan bisan ay i nagguru-guru-mo si sallud-na si kwarto, nagbandilyo gihapon si mga kakurukalsadahan. ");
INSERT INTO abx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga amigu-ko, sumatan-ta kam, dakam agkataralaw si mga magkatara'o pagmatay si puho', nga si pakatapus-na sinan gana' na la'in sahimu-na. ");
INSERT INTO abx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lugod sumat-ko si ka'am kon say i angay satalawan-bi: Atalawa kam si aniya' gahum-na pagtapok si ka'am pan impyirno kahuman si pagmatay-na si puho'! Sumatan-ta kam, ungod nan, atalawa kam si iya. ");
INSERT INTO abx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma'in ba' duwa hamok tumbaga diplata i kantidad-na si lima bug'os maya ari si mirkado? Pero gana' si mga iya naglimut-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bisan ngani' i barahibo si takuluk-bi ag'isip-na na. Sanglit dakam agkataralaw, kay mas mahaya i balur-bi kuntra si malabbat maya. ");
INSERT INTO abx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Sumatan-ta kam, bisan say i magpahayag nga huwang iya si ako, pahayag-na may liwat iya si Pinili' A'a atubang si mga anghel-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero bisan say i magdidiwaray nga sakilala-na ako, diriwarayan may liwat iya atubang si mga anghel-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bisan say i mamahalling kuntra si Pinili' A'a, apasaylo iya, pero i magparapakara'at si arun-na si Espirito Santo, ga'i apasaylo. ");
INSERT INTO abx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kon nagpandagnas kam pag'atubang si mga manhuhusgar para si Diyos kuno' ari si mga sinaguga, o ma'in ngani' atubang si mga huwis pati' si mga magtinagal si gubyirno, dakam abaraka kon papa'i-bi pagpamatu'od si pagkamatadung-bi, ngan kon ay i mga papahallingun-bi, ");
INSERT INTO abx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kay i Espirito Santo i manuro' si mga papahallingun-bi sinan uras.” ");
INSERT INTO abx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aniya' addangan si magpanggubok i maminugad si Jesus, “Ma'istro, pinugarin kita si siyaka-ko nga tunga' kami' na i binilin-na si tatay kami'.” ");
INSERT INTO abx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Anaruman may iya, “Say si ako i magtu'in nga akadalom si pagparti para si ka'am?” ");
INSERT INTO abx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mangno agpinugad-na i magtiriripon ari, “Agbantaya kam! Aglikaya kam si pagkabintahuso. I kinabuhi'-na si a'a ga'i agbasar si ka'abunda-na si mga inanna'-na.” ");
INSERT INTO abx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Katapos agsumatan-na mga iya sito isturya nga agtukoy si kamatu'uran: “Aniya' pitak-na si adda mayaman a'a nga mahalap i kutsitsa-na. ");
INSERT INTO abx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Anakka si isip-na, ‘Ay daw sito i hinimu-ko kay gana' na pangnganna'an-ko si mga baha'o inani-ko?’ ");
INSERT INTO abx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Mangno aminugad iya, ‘Da'ito sito i hinimu-ko. Bungkag-ko kamalig-koy to ngan amatindog ako mas mahaya sito basi' sabiyu'-ko pagpa'anna' i dimu'an inani-ko hasta i mga ipiktus-ko. ");
INSERT INTO abx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kahuman sinan sapinugad-ko i kalugaringun-ko, “Agsangya kaw si mga mahalap inanna' nga subra-subra si kinahanglanun-mo si mga titakka pira ta'on. Pahuwaya agpaka'allom, amangana, ag'inuma ngan aglipaya.”’ ");
INSERT INTO abx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Pero aminugad si iya i Diyos, ‘Kapay kaw! Mismo ina'anto sangom binawi' si ka'aw i kinabuhi'-mo. Tara', say may i binilinan-mo si dimu'an mga sa'angkun-mo?’ ");
INSERT INTO abx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Da'inan sinan i manakka si bisan say nga agparatipon inanna' para si kalugaringun-na pero ma'in mayaman si pangulawan-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Agpadayon si Jesus pagpahalling si mga inadalan-na, “Sanglit sumatan-ta kam, dakam abaraka mahi'unong si pagpanginabuhi'-bi kon ay i karakanun-bi, o bisan mahi'unong si mga puhu'-bi kon ay i mga papabadu'un-bi. ");
INSERT INTO abx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma'in hamok parti si pagkakan i kinabuhi' ngan ma'in hamok parti si pamado' i puho'. ");
INSERT INTO abx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kulawi-bi i mga wakwak: Ga'i mga iya agsaburak ngan ga'i ag'ani. Gana' budiga-na mga iya o ma'in ngani' kamalig, pero agtubungan-na mga iya si Diyos. Mas mahaya i balur-bi kuntra si kamanuk-manukan! ");
INSERT INTO abx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Say si ka'am i makapalanga bisan adda hamok uras si kinabuhi'-na pina'agi si kabaraka-na? ");
INSERT INTO abx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tungod kay ga'i may nan sabuhat-bi, bisan kon bali nan kadiki'-diki' buruhaton, dakam na abaraka hi'unong si ditangnga' pa. ");
INSERT INTO abx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kulawi-bi daw i ka'angayan-na si mga lalag burak. Ga'i mga iya agballi ngan ga'i aghimo. Kundi' sumatan-ta kam, bisan si bug'os kayamanan-na si Hadi' Solomon gana' sapasul'ut-na pariho kahalap si adda sinan mga burak. ");
INSERT INTO abx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Agpamanaptunan-na ngani' mahalap si Diyos i mga gabon si katahuk-tahukan, nga allom ina'anto pero papabar'ugon asumo, ka'am pa ba' i ga'i pinanaptunan-na mahalap? Kulang pa kam si pagtapod! ");
INSERT INTO abx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sanglit dakam agkasiribot pag'anda' kon ay i karakanun-bi pati' i irinumun-bi. Dakam abaraka mahi'unong sinan, ");
INSERT INTO abx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","kay iyay nan i kahuruwangan-na si nagparapanhingyap-na si mga a'a-na si dimu'an nasyon ngan sakatu'anan-na na si Tatay-bi i nagkinahanglanan-bi sinan. ");
INSERT INTO abx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lugod, anda'u-bi i pa'agi nga agpakasakop kam si mga nagpanhadi'an-na si Diyos ngan pinumwan nan liwat mga inanna' si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Dakam abaraka, ka'am nga day adda madiki' grupu-na si mga karniro nagparaliwat-ko, kay malipayon i Tatay-bi pagpa'ambit si ka'am si paghadi'-na huwang si ginhadi'an-na. ");
INSERT INTO abx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Baligya'i-bi i mga inanna'-bi ngan amuwana kam si mga anggana' kay pina'agi si pagpumwan-bi agpakatigayon kam si mga kaban nga ga'i arangka ngan ga'i liwat nagbaruki'. O ma'in ngani', agpakatigayon kam kayamanan ari si langit nga gana' katitibusun-na ngan gana' liwat makatangkaw. ");
INSERT INTO abx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Buhatu-bi nan kay maski singnga kina'anda'an i kayamanan-bi, awiray may liwat ari i kabaraw-bi.” ");
INSERT INTO abx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Agpadayon si Jesus si mga allingun-na, “Pasiguruha kam nga pirmi kam andang disalin pagsirbi ngan pirmi andang nagsulsulan i mga suga'-bi, ");
INSERT INTO abx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","pariho si mga mutsatso magparapangantahak si pagbalik-na si amu-na tikang si pagkasalan. Irugu-bi mga iya nga agpaka'abri dayon si pwirtahan si panuktuk-na si mga amu-na. ");
INSERT INTO abx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Agpaka'angkon kahalapan i mga rilihugon nga ag'ikmat si panakka-na si mga amu-na. Sumatan-ta kam si kamatu'uran, tungod sinan, agsalin i amo basi' iya i manulod. Mangno, pamatarangka'-na mga iya si lamisa ngan iya i manirbi si pagpamangan-na si mga rilihugon. ");
INSERT INTO abx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Agpaka'angkon kahalapan i mga rilihugon nga ag'ikmat si panakka-na si mga amu-na bisan kon anakkay to mga alas nwibi na dina si kasangumon o ma'in ngani' alas tris si kanalungon. ");
INSERT INTO abx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pero intumu-bi to: Pariho kon akatu'anan hamok i tagruma' kon ay urasa anakka i mannangkaw, sigurado ga'i iya agpata'an nga pwinirsa pagsallod i ruma'-na. ");
INSERT INTO abx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Si pariho kamutangan, kinahanglan may kam liwat ag'ikmat, kay titakka i Pinili' A'a si uras nga ga'i kam anggasi.” ");
INSERT INTO abx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mangno amatilaw si Pedro, “Paragdalom, kami' ba' i nagsumatan-mo sito isturya nga agtukoy si kamatu'uran o paray to si balang addangan?” ");
INSERT INTO abx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Anaruman may i Paragdalom, “I tangkod pati' madunong tinapuran, iya i nagtu'inan-na si amo pagpamuno' si mga rilihugun-na basi' agpakabuwanan mga iya si mga kunsumu-na si tama' uras. ");
INSERT INTO abx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mangno si pagbalik-na si amo, kon satakkahan-na i tinapuran nga agparabuhat pa si katungdanan-na, sigurado aka'angkon iya kahalapan. ");
INSERT INTO abx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sumatan-ta kam si kamatu'uran, tungod sinan, iya i nagtu'inan-na si amo pag'inantan si dimu'an mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero pananglit agpinsar dina i tinapuran, ‘Maliyat pa may agbalik i amu-ko.’ Mangno, agtikang iya pagpandabal si nagpamunu'an-na mga rilihugon, bisan lalla o danda. Pagusto iya si pagkakan ngan sigi palangu-lango. ");
INSERT INTO abx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sigurado nga anakka i amu-na sinan tinapuran si allaw nga ga'i iya anggasi ngan ga'i iya akatu'anan si uras. Agtagutad-na iya si amu-na basi' sapatig'ub-nay to si mga ga'i magpanutu'o. ");
INSERT INTO abx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“I tinapuran nga sayod si katuyu'an-na si amu-na pero ga'i ag'ikmat o ma'in ngani' ga'i agbuhat si katuyu'an-na, iya i makakarawat malabbat dabal. ");
INSERT INTO abx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero diki'it hamok i sakarawat-na dabal si ma'in sayod si katuyu'an-na si amu-na bisan pa kon angay karastiguhon i sabuhat-na. Ada'inan nan kay bisan say i nagbuwanan malabbat, malabbat may liwat i baratunun-na ngan bisan say i makatapuran mahaya, mahaya may liwat i aranda'on si iya. ");
INSERT INTO abx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Pada'ito ako paghusgar si kalibutan pina'agi si api ngan bali haya i pag'anduy-ko nga akasulsulan nayto! ");
INSERT INTO abx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero kinahanglan ako dahulo nagpalublob si mga pag'antos huwang i kamatayon nga akapariho si malilimbuhon. Ga'i gayod ako ahimutang hasta nga ga'i pa akumplito! ");
INSERT INTO abx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gasi-bi ba' nga pada'ito ako pagbawa kamurayaw si kalibutan? Sumatan-ta kam, ma'in nan iya, pero aniya' dina magkuruntra tungod si ako. ");
INSERT INTO abx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tikang ina'anto, kon aniya' limangan si adda pamilya, agkuruntray nan supak i tallungan si duwangan ngan i duwangan may makihiran si tallungan. ");
INSERT INTO abx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Anguntra i tata' si dadi'-na lalla ngan anguntra may i dadi' si iya. I nana, anguntra si dadi'-na danda ngan anguntra may liwat i dadi' si iya. Agkuntra-na pa liwat si umagad danda i nana, ngan i nana may anguntra si iya.” ");
INSERT INTO abx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mangno agpinugad-na si Jesus i magpanggubok, “Si pakakulaw-bi si dampog nga pahulwa' si katundan, aminugad kam dayon, ‘Ti'uran to,’ ngan ungod may anguran. ");
INSERT INTO abx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Si panrumbu-na si habagat, aminugad kam, ‘Tigpanason to,’ ngan ungod may. ");
INSERT INTO abx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mga mahalap kam hamok agtigo kon ay i titakka karat'an-na si la'in, pero ga'i kam agpakalikay sinan. Ata'o lugod kam pagkilala si kamutangan-na si kalangitan pati' si kalibutan, pero ga'i kam agpakatu'anan si kamutangan-na si ina'anto panahon. ");
INSERT INTO abx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ay kay ga'i kam ata'o paghusgar si tama' para si kalugaringun-bi? ");
INSERT INTO abx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Halimbawa', aniya' addangan si ka'am maghuwang si ka'asuntu-na pada'iray si huwis. Kunta' paniguru-na mismo sinan uras nga agkahalap mga iya myintras ga'i pa anakka ari, basi' ma'in iya i saguyud-na pada'iray si huwis. Mangno i huwis na si iya i mama'intriga si wardin ngan i wardin i manpriso si iya. ");
INSERT INTO abx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sumatan-ta kam, sigurado ga'i iya akagawas ari si prisuhan, hasta nga ga'i sabayaran-na bisan i ultimo na hamok sintabo si multa-na.” ");
INSERT INTO abx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sinan mismo uras ngan pagparapahalling-na si Jesus, aniya' si mga magpamakali magsumat si iya mahi'unong si mahinabo' pa hamok si pirangan mga taga Galilea. Agpamatay-nay to si Pilato ngan makigpasalakut-na i mga laha'-na mga iya si laha'-na si nagpamahalad-na hayop. ");
INSERT INTO abx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Anaruman si Jesus, “Gasi-bi ba' nga mas makasasala' mga iya kuntra si dimu'an mga taga Galilea kay da'iray pa'agi i mga pagsakit-na? ");
INSERT INTO abx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sumatan-ta kam, ma'in nan iya! Lugod, hasta nga ga'i kam agpamasol huwang si pagbag'o, intiro kam liwat agkamaratay nga bulag si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pariho kamutangan si disi'utso magkamaratay ari si Siloe, Jerusalem, nga agpakatur'ugan si turri. Gasi-bi ba' nga mas sala'an mga iya kuntra si dimu'an a'a mag'istar si bug'os Jerusalem? ");
INSERT INTO abx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Parariho hamok mga iya. Sumatan-ta kam, hasta nga ga'i kam agpamasol huwang si pagbag'o, ka'am liwat dimu'an agkamaratay nga bulag si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mangno agpadayun-na si Jesus i mga allingun-na sito isturya nga agtukoy si kamatu'uran: “Aniya' a'a nga agtanom kayo igos si ubasan-na nga sigi anda' kon aniya' sito buwa'-na, pero gana' sa'anda'an-na. ");
INSERT INTO abx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sanglit agpinugad-na i mag'ataman si ubasan-na, ‘I katallo ta'on nayto ako si ka'a'anda' kon aniya' buwa'-na sito igos, pero bisan adda gana' gayod sa'anda'an-ko. Tabbungon nayto hamok kayo! Kakarag-karag to dina si pitak.’ ");
INSERT INTO abx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Aminugad dina i mag'ataman, ‘Ay daw kon pata'anan-ta nayto hamok dahulo mga adda ta'on pa kay purbaran-ko dahulo ag'ukad palibot ngan anna'an-ko abuno. ");
INSERT INTO abx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kon amuwa' si utro tigbuwa'on, di' mahalap! Kon ga'i pa, di' iya na dina tabbung-ta.’” ");
INSERT INTO abx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Adda sinan Allaw Pandidiskanso, agparaturo' si Jesus si adda sinaguga. ");
INSERT INTO abx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aniya' ari danda magparapamati' nga disi'utso na anyos i pag'antus-na si pag'uba'uban-na tungod kay nagbawa-bawa iya si mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Si pakakulaw-na sinan si Jesus, agban'u-nay to pagdugok si iya si dahulu'an ngan agpinugad-na, “Mana, tikang ina'anto akalibri na kaw si nag'abat-mo.” ");
INSERT INTO abx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mangno agdu'unan-na si mga palat-na i danda. Akatisoy to dayon ngan diritso agparadayaw-na i Diyos. ");
INSERT INTO abx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bali i kasina-na si punu'-na si sinaguga kay agpahalap si Jesus si Allaw Pandidiskanso. Agpinugad-na i mga a'a, “Kinahanglan nga annom allaw hamok i pagtrabahu-bi. Sanglit pamada'ituha kam pagpabulong sinan mga allaw nga ga'i kam akasupak si Allaw Pandidiskanso.” ");
INSERT INTO abx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Agsupla-na iya si Paragdalom, “Klarado si isip-bi nga mahalap kam agparapamakunu-kuno nga mga rilihuso kam kay kada addangan si ka'am anliwat si butakal-bi baka o ma'in ngani' si asnu-bi tikang si kamalig pammasabsaban pada'iray si pammasurupan-bi bisan kon Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pero atiya' lugod addangan danda nga kapararihu-ta dadi'-na si Abraham, ngan day ag'ingkutan-na iya si Satanas tungod si pagpa'uba'ub-na si iya. Ma'in ba' to angay nagbak'aran liwat si gapus-na si Allaw Pandidiskanso nga disi'utso na anyos i pag'antus-na?” ");
INSERT INTO abx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pakapinugad-na sinan, akamalu'an i dimu'an kuntra-na, pero bali i mga kalipayan-na si mga a'a tungod si mga urusahon nagparahimu-na. ");
INSERT INTO abx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mangno amatilaw si Jesus, “Ay i makapariho si paghadi'-na si Diyos? Singnga ba' to patanding-ko? ");
INSERT INTO abx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akaparihoy to si lisu-na si tinanom mustad, nga satanum-na si a'a si hawan-na. Bisan madiki' to, kon anubo' na, akaparihoy to kahaya si kayo, nga pwidi i sanga-na sa'ansalahan-na si mga manuk-manok.” ");
INSERT INTO abx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Katapos, amatilaw gihapon iya, “Singnga ba' sapatanding-ko i paghadi'-na si Diyos? ");
INSERT INTO abx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Akaparihoy to si pammatubo' nga nagpasakut-na si parakaran'on danda ari si malabbat harrina hasta nga agsarama si bug'os minasa.” ");
INSERT INTO abx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mangno, agpadayon si Jesus si langngan-na pan Jerusalem. Pa'agi iya si mga kaburubungtuhan pati' si mga kaburubaryuhan ngan agparaturo' si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aniya' mamatilaw si iya, “Sinyor, diki'it ba' hamok mga a'a i magkasaralbar?” Aminugad to si mga iya, ");
INSERT INTO abx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Maniguruha kam gayod nga agpaka'agi kam dayon si madiki' nan pwirtahan, kay sumatan-ta kam, malabbat i mag'i'a'agi kunta' si damuri allaw nga ga'i na agpakadiritso. ");
INSERT INTO abx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Si pakatunggu-na na si tagruma' pagsirra si pwirtahan, gana' na sahimu-bi, kundi' i pagtutunggo na hamok si gawas pagtuktok ngan pagpakimalu'oy si pagpinugad, ‘Amo, abrihin may kami'.’ “Pero i papasarumanun-na dina, ‘Ga'i kam sakilala-ko o kon mga taga singnga kam.’ ");
INSERT INTO abx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Mangno surumatan-bi may iya, ‘Ma'in ba' agtararangka' kita kam pirmi si pagkakan, ngan agturo' kaw yungod si mga kalsada kami'?’ ");
INSERT INTO abx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Pero sarumanan-na gihapon, ‘Ga'i kam sakilala-ko o kon mga taga singnga kam. Patalaha kam si ako kay puro kam paragbuhat si karat'an!’ ");
INSERT INTO abx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Sigurado papahuwangon kam si mga sapamati'an-bi magpangaraba pati' magpanrigot ari kay sakulawan-bi kas Abraham, Isaac, Jacob pati' i dimu'an paragsumat-na si Diyos ari si ginhadi'an-na, pero ka'am may, nagtapukan dina pan gawas. ");
INSERT INTO abx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Katapos, bali labbat i magpanakka man sirangan, man katundan, man norte pati' man timugan ngan papasintaron mga iya si mga panningkulu'an-na si pakan ari si ginhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Si kamatu'uran aniya' si mga nagpanhangad kuno' ina'anto nga si damuri allaw agpaka'ubos dina, ngan aniya' liwat si mga magpama'ubos ina'anto nga si damuri allaw nagpanhangad dina.” ");
INSERT INTO abx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Siray mismo uras, aniya' mga Parisiyo nga pamadugok si Jesus ngan agpaminugad, “Ambanin to lugar ngan pada'iraya si bisan singnga na hamok lugara, kay papamatayun-na kaw si gubirnador Herodes.” ");
INSERT INTO abx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Anaruman iya, “Sumati-bi aro listoy ro si pagdaya', ‘Agpamapinda ako ina'anto si mga mara'at espirito tubtob asumo ngan huwang na sinan i pagpahalap si mga maburong. Katapos si sa'adday ro allaw, takka na ako si katuyu'an-ko. ");
INSERT INTO abx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero kinahanglan nga agpadayon ako ina'anto, asumo hasta si sa'addallaw, kay sigurado gayod nga gana' mamatay si mga paragsumat-na si Diyos gawas si Jerusalem!’ ");
INSERT INTO abx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mga taga Jerusalem, ka'am gayod i mga hinigugma'-ko. Kunta' ga'i agpanmatay-bi i mga paragsumat-na si Diyos. Kunta' ga'i agpanalutugan-bi i mga a'a nagpamabawa-na si ka'am. Simpira na ako ag'andoy nga pamadugok kam si ako basi' ag'aradda kita kam pariho si umagak kon aglu'uban-na i mga siyu'-siyu'-na. Pero ga'i kam gayod agkararuyag! ");
INSERT INTO abx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tigamani-bi, burungkagon ngan arambanan i syudad-bi huwang i mga kaparyintihan-bi. Sumatan-ta kam, ga'i na ako sakulawan-bi hasta nga ga'i kam agpakapinugad, ‘Malipayon i a'a nga akapada'ito pina'agi si gahum-na si Paragdalom.’” ");
INSERT INTO abx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Adda sinan Allaw Pandidiskanso, aniya' kilala Parisiyo mag'imbitar si Jesus. Pero si pagkakan-na si Jesus, nagparatigamanan iya ");
INSERT INTO abx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","kay sinan uras, aniya' addangan lalla ari atubang si Jesus nga maliyat na agpanhubag i mga langngun-na pati' i mga pa'a-na. ");
INSERT INTO abx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sanglit, agtilaw-na si Jesus i mga Parisiyo pati' i mga kunusido si bala'od, “Nagpatugot ba' si bala'od pagbulong kon Allaw Pandidiskanso o ga'i?” ");
INSERT INTO abx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ga'i mga iya agpakasibo', sanglit ag'antanan-na i lalla ngan agbulung-na. Kahuman sinan, agpabalik-nay to. ");
INSERT INTO abx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mangno agpatilawan-na gihapon mga iya, “Kon addangan si ka'am i aniya' dadi'-na lalla o aniya' butakal-na baka nga alaho' si buhon si Allaw Pandidiskanso, ga'i ba' to dayon isa-bi pagawas?” ");
INSERT INTO abx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero gana' makasibo' si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ngan pakakulaw-na si Jesus nga agpamili'-na si mga imbitado i mga pwisto ari si lamisa makabuwan unra, agsumatan-nay to mga iya sito isturya nga agtukoy si kamatu'uran: ");
INSERT INTO abx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kon aniya' mag'imbitar si ka'aw si pagkasalan, dakaw aningkulo' si pwisto nga akabuwan unra, kay tingali aniya' a'a nag'imbitaran nga mas dungganan pa si ka'aw. ");
INSERT INTO abx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kon da'inan sinan, padugok si ka'aw i mag'imbitar si ka'am duwangan ngan pinugad-na kaw, ‘Patingkulu'on iya anan si panningkulu'an-moy nan.’ Sanglit akamalu'an kaw, kay kinahanglan na kaw hamok aningkulo' si pinaka'ubos pwisto. ");
INSERT INTO abx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lugod, kon nag'imbitaran kaw, aningkulu'a si pinaka'ubos pwisto, basi' padugok si ka'aw i magpapakan ngan aminugad, ‘Sangkay, palalina si mas dungganan panningkulu'an.’ Mangno aka'unrahan kaw atubang si dimu'an kapararihu-mo imbitado. ");
INSERT INTO abx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sanglit agpa'ubusa kay bisan say i magpalabaw si kalugaringun-na, iya dina i pina'ubus-na si Diyos; pero i magpa'ubos si kalugaringun-na, iya lugod i pinalabaw.” ");
INSERT INTO abx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mangno, agpinugad-na si Jesus i magpapakan, “Kon agpakan kaw paningudto o ma'in ngani' panigab'i, dakaw ag'imbitarin i mga kumpaniya-mo, i mga bugtu'-mo, i mga paryinti-mo o ma'in ngani' i mga mayaman katiringpid-mo. Kon imbitaran-mo mga iya, tingali imbitaran-na may kaw, ngan kon da'inan sinan agbayaran-na kaw mga iya. ");
INSERT INTO abx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero, si pagpakumbiti-mo, imbitarin i mga anggana', i mga punggol, i mga lulid pati' i mga buta, ");
INSERT INTO abx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","basi' akabuwanan kaw si kabubuwasun-mo. Bisan kon ga'i mga iya akabulos si ka'aw, buruluson kaw si kabanhaw-na si mga matadong.” ");
INSERT INTO abx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Si pakapakali-na sinan si mga katarangka'-na si Jesus, aniya' addangan maminugad si iya, “Malipayon i a'a nga papatangka'on ari si ginhadi'an-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Anaruman si Jesus, “Aniya' addangan lalla nga agtima mahaya kumbiti, ngan malabbat i nag'imbitaran-na. ");
INSERT INTO abx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ngan uras na si kumbiti, aglihug-na i rilihugun-na pagsumat si mga dati nag'imbitaran-na, ‘Tuwa na kam kay andam na i dimu'an.’ ");
INSERT INTO abx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pero agpanhimo dina mga iya dimu'an pasangilan nga ga'i agpakatambong. Aminugad i primiro, ‘Makigdispinsaron dahulo ako. Akaballi pa hamok ako pitak ngan kinahanglan ako pada'iray pagkulaw sito.’ ");
INSERT INTO abx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Aniya' may maminugad, ‘Makigdispinsaron dahulo ako. Akaballi pa hamok ako awatong butakal baka basi' saduwa-duway to pagguyod si lima arado, ngan tipada'iray na ako pagpurbar kon mahalap nagpama'arado.’ ");
INSERT INTO abx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aniya' liwat maminugad, ‘Ga'i ako akapada'iro kay pakakasal pa hamok si ako.’ ");
INSERT INTO abx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Agbalik i rilihugon ngan agsumat-nay to si amu-na. Mangno asina i amo ngan agmandaran-na i rilihugun-na, ‘Dagmita, pada'iraya si kakalsadahan pati' kasipi'-sipi'an si bungto ngan papada'ituhon i mga anggana', i mga punggol, i mga buta pati' i mga lulid.’ ");
INSERT INTO abx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Si pagbalik-na si rilihugon aminugad iya, ‘Amo, tapos na i panlihugan-mo pero ma'in pa gayod ma'a'a.’ ");
INSERT INTO abx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mangno aglihug-na gihapon si amo i rilihugon, ‘Pada'iraya si katurutinampuhan, pati' si katahuk-tahukan ngan sagdahon i mga a'a pagsallod ato si ruma'-ko basi' ma'a'a. ");
INSERT INTO abx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sumatan-ta kaw, gana' makakinda si kumbiti nagtima-ko bisan addangan si mga dahuloy ray nag'imbitaran mga lalla.’” ");
INSERT INTO abx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Siray uras bali labbat i mamaya' si Jesus pagbaktas. Mangno angatubang to si mga iya ngan aminugad, ");
INSERT INTO abx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kon aniya' padugok si ako, kinahanglan iya agsikway si tatay-na pati' si nanay-na. Sikway-na liwat kunta' i alla-na, i mga dadi'-na, i mga kadingsirarihan-na. Kon ga'i nan panikway-na, hasta pa i kalugaringun-na, ga'i iya pwidi nga magin inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bisan say aha'a nga ga'i agti'os si mga aragihun-na pag'antos pariho si makamamalo' kamatayon si kudos ngan ga'i agsunod si ako, ga'i liwat iya pwidi nga magin inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Pananglit addangan si ka'am i maruyag manindog turri. Ga'i ba' dahulo iya maminsar ngan karkular-na i kantidad pagsiguro nga ahusto i kwarta-na pagpatapos? Sigurado da'inan i hinimu-na ");
INSERT INTO abx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","kay kon ga'i satapus-na i turri kahuman si pag'usuk-na, anunggod si iya i dimu'an makakulaw ");
INSERT INTO abx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","si pagpinugad, ‘Agtikang to a'a pagpatindog pero ga'i akapatapos.’ ");
INSERT INTO abx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Pananglit liwat aniya' hadi' tipakigirra kuntra si la'in hadi'. Ga'i ba' iya maminsar dahulo kon akagahos i dyis mil mga kasundaluhan-na pagpakigirra si baynti mil magdadara'on kuntra si iya? ");
INSERT INTO abx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kon ga'i iya akagahos, anlihog iya mga tinu'inan pagpalako nga agsiharalapay mga iya si mga kuntra-na myintras mamatala pa. ");
INSERT INTO abx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Si pariho pa'agi, bisan say si ka'am i ga'i mag'amban si dimu'an tawa'-na pati' si dimu'an katuyu'an-na, ga'i iya pwidi nga magin inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Aniya' mahalap kagamitan-na si asiya pariho may si ka'am. Sanglit dakam agpata'an. Pariho halimbawa' kon a'ala' na i kasira'-na si asiya, ga'i na apabwilta i kasira'-na. ");
INSERT INTO abx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gana' na sito pulus-na bisan kon pinasalakot si pitak o hinimo abuno. Angay nayto hamok nagtapukan. “Si mga a'a makapamati', kunta' amati'!” ");
INSERT INTO abx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Adda sinan allaw, agtiripunan-na si Jesus si mga paragsukot buhis pati' si mga nagpaminugad makasasala' pagpamati' si iya. ");
INSERT INTO abx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pero agparapanngurub-ngurob dina i mga Parisiyo pati' i mga paragturo' bala'od, “Agpakihuwang to a'a si mga makasasala' ngan agpakitangka' si mga iya.” ");
INSERT INTO abx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sanglit agsumatan-na mga iya si Jesus sito isturya nga agtukoy si kamatu'uran: ");
INSERT INTO abx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pananglit addangan si ka'am i aniya' addahatos karniru-na. Mangno akarungayan iya adda. Sigurado ambanan-na i nubintay nwibi ari si pammasabsaban ngan sunud-na i marungay karniro tubtob nga sa'anda'an-nay to. ");
INSERT INTO abx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Malipayon gayod iya si paka'anda'-na, ngan agpalangkit-nay to, ");
INSERT INTO abx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","agbalik. Mangno, ag'agda-na i mga kumpaniya-na pati' i mga katiringpid-na. Agpinugad iya, ‘Agkalipay kita kam kay sa'anda'an-ko na i marungay karniru-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Da'inan may liwat, malipayon i mga sari'i si langit tungod kay aniya' nubintay nwibi ato nga matadong bisan kon si mga pagkagasi-na, ga'i mga iya kinahanglan agbasol huwang si pagbag'o. Pero sumatan-ta kam nga pariho si kamutangan-na si makarungayan, urog pa gayod i kalipayan ari tungod si addangan makasasala' nga agbasol. ");
INSERT INTO abx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pananglit liwat aniya' addangan danda nga akarungayan adda si awatong salapi'-na diplata. Sigurado anda'-nay to pahalap. Anulsol iya suga' ngan silhigan-na i baklag tubtob nga sa'anda'an-nay to. ");
INSERT INTO abx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Si paka'anda'-na sinan, ag'agda-na i mga kumpaniya-na pati' i mga katiringpid-na. Agpinugad iya, ‘Agkalipay kita kam kay sa'anda'an-ko na i marungay kwarta-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sumatan-ta kam nga da'inan sinan i kalipayan-na si mga ginsakupan-na anghel si Diyos tungod si addangan makasasala' nga agbasol huwang si pagbag'o.” ");
INSERT INTO abx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Agpadayon si Jesus pagsumat si mga isturya nga agtukoy si kamatu'uran, “Aniya' addangan lalla, ngan puro lalla i duwangan dadi'-na. ");
INSERT INTO abx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Agpinugad i sirari si tatay-na, ‘Tay, pumwanon na si ako i kapartihan-ko tikang si dimu'an tawa'-mo.’ Sanglit agparti-na si tata' i dimu'an tawa'-na para si duwangan dadi'-na. ");
INSERT INTO abx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kapirahan allaw, ag'ala'-na si sirari i dimu'an tawa'-na ngan agbiyahi iya pan la'in nasyon. Ari agparapawandas-wandas-na i kayamanan-na ");
INSERT INTO abx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tubtob nga atibos i dimu'an kwarta-na. Mangno aniya' mahaya gutom ari siray nasyon ngan ag'abat iya si ka'anggana'on. ");
INSERT INTO abx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sanglit agpabinata' iya si addangan taga sunsari'i ngan naglihog iya pada'iray si mga uma-na pagtubong baktin. ");
INSERT INTO abx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pero gana' si iya mamuwan ni addangan maski ay, hasta si kaliyat-liyatan asindak iya si pagkakan-na si mga baktin para iya abagtok. ");
INSERT INTO abx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Si paka'alimagmag-na, akapaminsar iya, ‘Pagkalabbat mga trabahantis-na si tatay-ko nga bastanti si pagkakan, pero atiya' lugod ako ato mammatayon si kalingantuhan! ");
INSERT INTO abx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pa'amban ako ato ngan pabwilta si tatay-ko. Pinugad-ko iya: Tay, akasala' ako si langit pati' si ka'aw. ");
INSERT INTO abx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma'in na ako angay kilala-mo nga dadi'-mo. Alayon himu'on ako addangan si mga trabahantis-mo.’ ");
INSERT INTO abx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sanglit pataliwan dayon iya pagbalik si tatay-na. “Pero ngan matala pa iya, sakulawan-na na iya si tatay-na ngan bali gayod i kalu'uy-na. Aglalahi iya pagtupo' si dadi'-na, agkupkupan-na ngan ag'uruk-na. ");
INSERT INTO abx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Aminugad i dadi' si iya, ‘Tay, akasala' ako si langit pati' si ka'aw. Ma'in na ako angay kilala-mo nga dadi'-mo.’ ");
INSERT INTO abx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pero aminugad dina i tata' si mga rilihugun-na, ‘Dagmita kam! Bawahu-bi pada'ito i pinakamahalap bado' ngan makigpasalinu-bi iya. Singsingi-bi iya ngan sapatusi-bi. ");
INSERT INTO abx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ala'u-bi i nagpalammukan nati-nati baka ngan bunu'u-bi. Agpa'uwak ngan agkalipay kita kam. ");
INSERT INTO abx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Akapariho dadi'-koy to si mamatay na ngan a'allom gihapon. Akapariho liwat iya si marungay tungod si paglagataw-na nga kina'anda'an na.’ Sanglit agtikang mga iya pagkalipay. ");
INSERT INTO abx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Siray ka'urason, ari pa i siyaka si uma. Si pagbalik-na, sapakalihan-na i tukar ngan sakulawan-na i sarayaw. ");
INSERT INTO abx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sanglit agban'o iya addangan si mga rilihugon ngan agpatilawan-na kon ay ba' ray. ");
INSERT INTO abx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Anaruman i rilihugon, ‘Anakka i sirari-mo, ngan agbunu'-na si tatay-mo i nagpalammukan nati-nati baka kay agbalik iya nga ga'i apa'i.’ ");
INSERT INTO abx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Asina i siyaka ngan andiri' iya pagsallod. Sanglit pagawas i tatay-na ngan ag'aguy-aguy-na iya. ");
INSERT INTO abx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero agsarumanan-na dina i tatay-na, ‘Pinsaron! Malabbat ta'on day uripon ako pagsirbi si ka'aw ngan ga'i ako agsupak bisan adda si mga panlihugan-mo. Pero ga'i ako agbuwanan-mo bisan adda nati kanding basi' salipay-ko may i mga kumpaniya-ko. ");
INSERT INTO abx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lugod, agbunu'-mo i nagpalammukan nati-nati baka para sinan dadi'-moy nan, kay agbalik iya si katibus-na paggasto si pinaka'alluman-mo si pagpawandas-wandas pati' paghuwang si mga magpamabayad danda!’ ");
INSERT INTO abx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Anaruman i tata', ‘No', aghuwang kita pirmi ngan tawa'-mo i dimu'an tawa'-ko. ");
INSERT INTO abx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero kinahanglan agpa'uwak ngan agkalipay na kita, kay akaparihoy nan sirari-moy nan si mamatay na ngan a'allom gihapon. Akapariho liwat iya si marungay nga kina'anda'an na.’” ");
INSERT INTO abx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mangno agsumatan-na si Jesus i mga inadalan-na, “Aniya' addangan mayaman nga nagsumbungan hi'unong si tinapuran-na magparapawandas-wandas si manggad-na. ");
INSERT INTO abx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sanglit agpa'ala'-nay to ngan agtilaw-na, ‘Ay ba' to sapakalihan-koy to mahi'unong si ka'aw? Pa'intrigahon si ako i lista-mo si dimu'an inanda'an-na si kwarta-ko pati' i mga sagastu-mo, kay arala'on na kaw si katungdanan-mo.’ ");
INSERT INTO abx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mangno maminsar i tinapuran, ‘Papapindahun-na na ako si amu-ko si trabahu-koy to. Ay daw sito i binuhat-ko tikang ina'anto? Ma'in ako gara' si mabuwat trabaho ngan asipog ako pagpalimos. ");
INSERT INTO abx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aw, aniya' bali' pa'agi-ko basi' si pakapinda-ko si trabahu-koy to ato, akasangpot ako si la'in a'a.’ ");
INSERT INTO abx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Sanglit agpa'ala'-na sa'uru'addangan i mga magpaka'utang si amu-na. Agpatilawan-na i primiro, ‘Pira i utang-mo si amu-ko?’ ");
INSERT INTO abx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Anaruman to, ‘Utso syintos galunis si lana-na si prutas olibo.’ “Agsumatan-na iya si tinapuran, ‘Atiya' i listahan si baraydan-mo, listuhin pagsalli' ngan himu'on na hamok kwatro syintos.’ ");
INSERT INTO abx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Mangno agpatilawan-na i kaduwangan, ‘Pira may i utang-mo?’ “Anaruman may to, ‘Kinyintos sako trigo.’ “Agsumatan-na iya si tinapuran, ‘Atiya' i listahan si baraydan-mo, listuhin pagsalli' ngan himu'on na hamok kwatro syintos,’ ngan agda'inan-na i mga ditangnga' pa. ");
INSERT INTO abx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Akadayaw i amo si kalistuhan-na si daya'on tinapuran. Mas listo pag'asikaso si kaparihu-na i mga magpanunod si kalibutanon, kuntra si magpanunod si kadanta'an. ");
INSERT INTO abx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sumatan-ta kam, gamitu-bi i kalibutanon manggad pagpakikumpaniya malabbat, basi' si katibus-na sinan, pinanginano kam si pasallud-bi si gana' katapusan-na pangngistaran. ");
INSERT INTO abx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Bisan say i makatapuran si diki'it, akatapuran may si malabbat, ngan bisan say i daya'on si diki'it, daya'on may liwat si malabbat. ");
INSERT INTO abx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sanglit kon ma'in kam tarapuran pag'antan si kalibutanon manggad, gana' may magtapod si ka'am pagpa'antan si ungod kayamanan. ");
INSERT INTO abx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kon ma'in kam tarapuran pag'ataman si inanna'-na si la'in, gana' may mamuwan si ka'am basi' tawa'-bi na gayod. ");
INSERT INTO abx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gana' rilihugon makasirbi duwangan amo kay sigurado nga addangan hamok i naghigugma'-na ngan addangan may i nagsikway-na. Ma'in ngani', unungan-na i kaduwangan ngan sikway-na i primiro. Gana' si ka'am makapadungan pagsirbi si Diyos pati' si manggad.” ");
INSERT INTO abx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sapakalihan-nay nan dimu'an si mga Parisiyo. Pina'ura-na mga iya i kwarta sanglit agpanabri' mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aminugad may si Jesus si mga iya, “Ka'am i magpatadong si mga kalugaringun-bi si pangulawan-na si mga a'a pero katu'anan i Diyos si sallud-na si inisipan-bi. I nagdayaw-na si mga a'a huwang i mabalor si pangulawan-na mga iya, iya dina i day nagkasulya'an-na pati' i sasinahan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nagparawali na i Bala'od pati' i Nagpanurat-na si mga Paragsumat tubtob si paluwa'-na si Juan Paragbunyag. Mangno iya na i pagtikang pagparawali si mahalap sumat hi'unong si paghadi'-na si Diyos ngan maniguro i balang addangan pag'isasallod. ");
INSERT INTO abx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bali kuri i pagpara' si kalangitan pati' si kalibutan pero mas makuri pa i pagpara' bisan ay litraha si Bala'od. ");
INSERT INTO abx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“I lalla nga pabulag si alla-na mangno pakasal si la'in danda, si kamatu'uran agsala' iya tungod si pagtig'ub-na si la'in, ngan i lalla nga pakasal si nagbulagan danda, si kamatu'uran agsala' liwat iya tungod si pagtig'ub-na si dati allahan.” ");
INSERT INTO abx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Agpadayon si Jesus pagpahalling, “Aniya' mayaman lalla nga pirmi parasul'ot si mga mamahalap sida panapton pati' mga hadi'anon hiniro nga kulor igot. Balang allaw, pagusto hamok iya si kinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aniya' liwat addangan kasamdanon a'a nag'arunan Lazaro. Nagparahulid to si pwirtahan-na si padir-na si mayaman kay parapalimos iya. ");
INSERT INTO abx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Asindak pirmi iya pag'ikakakan kunta' si mga karag magkataraktak tikang si lamisa-na si mayaman lalla. Bisan i mga ido' padugok si iya ngan agdilat-na i mga kasamaran-na. ");
INSERT INTO abx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Mangno anakka i uras nga amatay si Lazaro. Agbawa-na iya si mga anghel basi' agkahuwang mga iya si Abraham. Amatay liwat i mayaman ngan naglabbungan. ");
INSERT INTO abx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nagpasakitan iya ari si dilalom pitak. Akahangad iya ngan si bali tala lugar, sakulawan-na si Abraham nga agtingpid mga iya si Lazaro. ");
INSERT INTO abx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sanglit aman'o iya, ‘Tay Abraham, kalu'uyin ako. Papada'ituhon si Lazaro ngan tigpatugnubon tutturu'-nay nan si buwahi' basi' anugnaw dalla'-koy to, kay bali pagsakit-koy to si kapanas-na sito api.’ ");
INSERT INTO abx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Pero anaruman dina si Abraham, ‘No', intumon nga si bug'os kinabuhi'-mo siray, mamahalap mga inanna' i sakarawat-mo, ngan mamara'at i mga sakarawat-na si Lazaro. Pero ina'anto nagli'aw iya ato ngan awinan may kaw agsakit. ");
INSERT INTO abx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pwira sinan dimu'an, aniya' nagpatangnga' si ka'aw pati' si kami' luwang nga i kalalum-na pati' kahaway-na gana' katapusan-na. Naghimoy to basi' ga'i akapada'iro i satu'o nga aruyag pada'iro si ka'am, ngan basi' ga'i akapada'ito i saru'o nga aruyag pada'ito si kami'.’ ");
INSERT INTO abx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Anaruman iya, ‘Kon da'inan sinan, makimalu'oy ako si ka'aw, Tay, papada'irayon si Lazaro si ruma'-na si tatay-ko, ");
INSERT INTO abx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kay aniya' limangan pa mga sirari-ko lalla. Makigpinahin mga iya pagbuhat si nagbuhat-ko, basi' ga'i mga iya akapada'ito sito lugar nga pammasakitan.’ ");
INSERT INTO abx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Anaruman si Abraham, ‘Pwidi mga iya amakali si Bala'ud-na si Moises pati' si Nagpanurat-na si mga Paragsumat.’ ");
INSERT INTO abx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aminugad iya, ‘Tay Abraham, ga'i mga iya amakali sinan, pero tibasol mga iya huwang si pagbag'o kon aniya' magbwilta tikang si mga minatay nga pada'iray si mga iya.’ ");
INSERT INTO abx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aminugad si Abraham si iya, ‘Kon ga'i mga iya amakali si Bala'ud-na si Moises pati' si Nagpanurat-na si mga Paragsumat, ga'i may mga iya apatutu'o bisan kon aniya' mabanhaw.’” ");
INSERT INTO abx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Agpadayon si Jesus pagpahalling si mga inadalan-na, “Sigurado nga aniya' buhat-na si a'a nga akapa'amban si pagtutu'u-na si la'in. Pero papabidu'on i a'a magbuhat sinan. ");
INSERT INTO abx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mara'at gayod si a'a kon nagpa'ingkutan i kallung-na gilingan bato ngan nagtunura si kalawot. Pero bisan kon mara'at to, mas mahalap payto kuntra kon akapa'amban iya si la'in nga baha'o pa hamok magtutu'o. ");
INSERT INTO abx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sanglit bantayi-bi i mga kalugaringun-bi. “Kon sakatu'anan-mo nga agsala' i bugtu'-mo si pagtu'o, tin'uhon. Kon agbasol iya huwang si pagbag'o, pasayluhon. ");
INSERT INTO abx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kon akasala' iya si ka'aw sin pito' si adda allaw, ngan sin pito' liwat iya pabwilta si ka'aw pagpinugad, ‘Agbasol ako,’ kinahanglan pasaylu-mo iya.” ");
INSERT INTO abx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Agpinugad-na si mga apostol i Paragdalom, “Tambahin i mga pagtutu'o kami'!” ");
INSERT INTO abx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Anaruman iya, “Kon aniya' may dina pagtutu'u-bi pariho kadiki'-diki' si lisu-na si tinanom mustad, pwidi kam akapinugad sito kayo sikamuro, ‘Tigrabnuta anan ngan tiglalina pan kalawot,’ ngan atuman to.” ");
INSERT INTO abx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mangno aminugad si Jesus, “Pananglit addangan si ka'am i aniya' rilihugun-na mangngarado, o ma'in ngani' manliliwat karniro. Si panakka-na si rilihugon tikang si nagtrabahu'an-na, pinugad-mo ba' to, ‘Tuwa, amangana dahulo ato?’ ");
INSERT INTO abx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sigurado ga'i, pero aminugad kaw dina, ‘Timahon i panigab'i-ko, agsalina ngan sirbihin ako si pagkakan-ko hasta si pakatapus-ko. Mangno iya na kaw dina amangan.’ ");
INSERT INTO abx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ga'i kaw agpasalamat si rilihugun-mo tungod kay agtuman-na hamok sito i panlihugan-mo. ");
INSERT INTO abx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sanglit da'inan may liwat i hinimu'u-bi. Si pakabuhat-bi si dimu'an panlihugan, angay kam hamok aminugad, ‘Ma'in kami' angay nagpa'unrahan kay agtuman kami' hamok i mga panlihugan si kami'.’” ");
INSERT INTO abx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mangno, si pagparabaktas-na kas Jesus pan Jerusalem, ag'agi iya si pagkatunga'an-na si Samaria pati' Galilea. ");
INSERT INTO abx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Si pagdadara'un-na si adda baryo, aniya' manupo' si iya awatong liprusuhon lalla. Ga'i gayod mga iya patapit si Jesus pero ");
INSERT INTO abx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","agpaman'o makusog, “Jesus, Sinyor, kalu'uyin kami'!” ");
INSERT INTO abx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Si pakakulaw-na si mga iya, aminugad iya, “Pada'iraya kam si mga paraghalad ngan pakulawu-bi puhu'-bi nan.” Si palangngan-na mga iya, agpanhalap to dayon. ");
INSERT INTO abx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aniya' addangan si awatong ray nga pabwilta tungod kay anhalap iya ngan sigi turakaw makusog pagdayaw si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Agluhod iya atubang si Jesus ngan agpasalamat bisan kon Samaritano dina iya. ");
INSERT INTO abx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Amatilaw si Jesus si mga inadalan-na, “Puro agpanhalap i awatong pero singnga na i siyamangan? ");
INSERT INTO abx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gana' ba' la'in magbwilta pagdayaw si Diyos pwira si dayuhan to?” ");
INSERT INTO abx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mangno agpinugad-na si Jesus i lalla, “Anungguha ngan pada'iraya na. I pagtutu'u-mo, iya i makapahalap si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Adda bisis sinan, nagpatilawan si Jesus si mga Parisiyo kon sumiran anakka i paghadi'-na si Diyos. Anaruman iya, “Ga'i kinakulawan i pagtakka-na si paghadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gana' makapinugad nga atiya' ato o awiray ari, kay awinan si kasing-kasing-bi i paghadi'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mangno aminugad iya si mga inadalan-na, “Titakka i panahon si pag'anduy-bi nga akahuwang kam gihapon si Pinili' A'a bisan adda allaw hamok. Pero ga'i nan sakulawan-bi. ");
INSERT INTO abx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aniya' mga a'a manumat si ka'am, ‘Awiray iya ari!’ o ma'in ngani', ‘Atiya' iya ato!’ Dakam pada'iray ngan anunod si mga iya ");
INSERT INTO abx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","kay si allaw si pagpada'itu-na, akapariho i Pinili' A'a si kil'at magsana'ag si bug'os kalangitan. ");
INSERT INTO abx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero si ina'anto panahon kinahanglan agsakit dahulo iya pala'in-la'in ngan diriri'on si ka'aha'an. ");
INSERT INTO abx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kon ay i nagparabuhat-na si mga a'a siray ngan panahun-na kas Noe, iya may liwat gihapon si pagpada'itu-na si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Agparapamangan mga iya, agparapangirinom ngan agparakasalay tubtob si allaw si pasallud-na kas Noe si arka. Mangno anakka i unop ngan agkamaratay mga iya dimu'an nga bulag si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Pariho liwat siray ngan panahun-na kas Lot. Agparapamangan may gihapon i mga a'a, agparapangirinom, agparapamalli, agparapamaligya', agparapananom ngan agparapanindog mga ruma'. ");
INSERT INTO abx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero si allaw si pataliwan-na kas Lot si syudad Sodom, ag'uran ari api pati' asupri ngan agkamaratay mga iya dimu'an nga bulag si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Da'inan sinan i titakka allaw si pagpakulaw-na si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sinan allaw, kon awiray i addangan si pammalayahayan ari si binubungan, paduwa'i iya pero ga'i na kunta' pasallod si ruma'-na pag'addo' si mga inanna'-na. Da'inan may liwat, kon ari iya si uma, ga'i na kunta' iya padulhog. ");
INSERT INTO abx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Intumu-bi i mahinabo' si alla-na si Lot nga makibabalikon ngan ahimo asiya si pagkastigo. ");
INSERT INTO abx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Bisan say i ma'awil si kalugaringun-na kinabuhi' ina'anto, iya dina i tikarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero bisan say i magkarag si kalugaringun-na kinabuhi', iya dina i aniya' ungod kasiguruhan-na. ");
INSERT INTO abx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sumatan-ta kam, sinan sangom, aniya' duwangan lalla maghuwang agpaturi pero addangan hamok i inala' paghuwang si Diyos ngan bilin i addangan. ");
INSERT INTO abx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aniya' liwat duwangan danda maghuwang aggiling pero addangan hamok i inala' ngan bilin i addangan.” ");
INSERT INTO abx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Agpatilaw mga iya, “Paragdalom, singngay nan ahinabo'?” Anaruman iya, “Agpakatu'anan gad kam sinan gihapon pariho kon aniya' magtiriripon mga wakwak si adda lugar, akatu'anan kam nga aniya' minatay anan.” ");
INSERT INTO abx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mangno agsumatan-na si Jesus i mga inadalan-na si isturya nga agtukoy si kamatu'uran pagpakatu'an nga kinahanglan pirmi mga iya agpangadyi' ngan ga'i abudlay. ");
INSERT INTO abx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aminugad iya, “Ari si adda bungto, aniya' huwis nga ga'i agtahod si Diyos ngan ga'i manginano si bisan say. ");
INSERT INTO abx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aniya' liwat balo danda ari siray bungto nga agparaburubwilta pada'iray si iya pagpakimalu'oy, ‘Pumwanon si ako i pantay paghusgar kuntra si ka'asuntu-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Si pira bisis agbaribad iya. Pero si katapus-tapusan akapaminsar iya, ‘Bisan kon ga'i ako agtahod si Diyos o manginano si bisan say, ");
INSERT INTO abx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","paniguru-ko nga sakarawat-na sito balo i pantay paghusgar kay sigi-na ako samok. Himu-koy to, basi' ga'i na ako a'uyam si pagparapada'itu-na!’” ");
INSERT INTO abx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mangno ag'isplikaran-na mga iya si Ginu'o, “Tuninungi-bi i allingun-na si huwis nga ma'in matadong. ");
INSERT INTO abx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kon agda'inan iya, ma'in ba' buruwanan-na si Diyos pantay paghusgar i mga pinili'-na nga agparapaman'o si iya allaw sangom? Atrasu-na ba' i pagpanginano si mga iya? Sigurado ga'i. ");
INSERT INTO abx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sumatan-ta kam nga panginanu-nay to dayon si Diyos basi' kakarawat mga iya pantay paghusgar. Pero si pagbwilta-na si Pinili' A'a si kalibutan, aniya' ba' sabagatan-na nga mga tangkod pagtutu'o si iya?” ");
INSERT INTO abx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aniya' mga a'a nga agtapod si mga kalugaringun-na pagkamatadong ngan agda'ug-da'og si ditangnga' mga a'a. Agpanumatan-nay to si Jesus si isturya nga agtukoy si kamatu'uran, ");
INSERT INTO abx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Aniya' duwangan lalla nga pasagka pada'iray si templo basi' mangadyi'. Parisiyo i addangan ngan i addangan may paragsukot buhis. ");
INSERT INTO abx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Anunggo i Parisiyo ngan agpangadyi' hi'unong mismo si kalugaringun-na si pagpinugad, ‘Diyus-ko, agpasalamatan-ta kaw kay ma'in ako pariho si ditangnga' mga a'a nga mga tulisan, mga mara'at binuhatan-na pati' agparapanbisyo si pagdangallahan. Salamat liwat kay ma'in ako pariho si daya'on ray paragsukot buhis. ");
INSERT INTO abx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Agpu'asa ako sin duwa si kada duminggo ngan agpahalad-ko i dyis pursyinto si dimu'an inanda'an-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pero agtutunggo ari si damurihan i paragsukot buhis. Ga'i ngani' iya anhangad si langit kundi' agdugmuk-na dina i darakan-na ngan aminugad, ‘Diyus-ko, kalu'uyin ako nga adda makasasala'.’ ");
INSERT INTO abx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Sumatan-ta kam, yaynan lugod lalla i magbalik nga matadong si pangulawan-na si Diyos, ma'in i addangan. Bisan say i magpalabaw si kalugaringun-na, iya dina i pina'ubus-na si Diyos pero i magpa'ubos si kalugaringun-na, iya lugod i pinalabaw.” ");
INSERT INTO abx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Siray uras aniya' magpankugos si mga dadi'-na pada'iray si Jesus. I karuyag-na kunta' mga iya nga sadu'unan-na si palat-na si Jesus i mga dadi'-na. Si pakakulaw-na si mga inadalan, agsimul-na mga iya i mga a'a ");
INSERT INTO abx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","pero makigpatapit-na dina si Jesus i kadadi'-dadi'an ngan aminugad, “Tuguti-bi i kadadi'-dadi'an pagdugok si ako ngan dakam ag'ulangu-bi mga iya, kay i da'inan mga a'a i papasakupon si nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sumatan-ta kam si kamatu'uran, bisan say i ga'i mangarawat si paghadi'-na si Diyos pariho pa'agi si pagkarawat-na si adda dadi'-dadi', sigurado ga'i gayod akasakop si mga nagpanhadi'an-na.” ");
INSERT INTO abx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aniya' puno' mamatilaw si Jesus, “Ma'istro, sayod ako nga mahalap kaw. Ay i kinahanglan buruhatun-ko pagpasiguro nga sa'angkun-ko i kinabuhi' nga gana' katapusan-na?” ");
INSERT INTO abx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Anaruman dina si Jesus, “Ay kay akapinugad kaw nga mahalap ako? Ma'in ba' nga i Diyos hamok i mahalap? ");
INSERT INTO abx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sigurado akatu'anan kaw si mga kasugu'an: ‘Dakam agbisyo si pagdangallahan, dakam agmatay, dakam agtangkaw, dakam agbullo' si pagtistigos, agtahura kam si tatay-bi pati' si nanay-bi.’” ");
INSERT INTO abx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aminugad may iya, “Tikang ngan aniya' na sarabutan-ko, agsunud-ko naynan mga kasugu'an.” ");
INSERT INTO abx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Si pakabati'-na sinan si Jesus, agpinugad-na iya, “Yayto pa i kulang-mo buruhaton. Baligya'in i dimu'an inanna'-mo. Pumwanon si mga anggana' i balli-na basi' aniya' kayamanan-mo ari si langit. Katapos pada'ituha basi' akabaya' kaw ngan agsunod si ako.” ");
INSERT INTO abx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngan pakabati'-na sinan si lalla, masurub'on gayod iya kay iya i a'a nga bali yaman. ");
INSERT INTO abx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Si patalikut-na, agbuslung-na iya si Jesus ngan akapinugad, “Makuri gayod nga akasakop i mga mayaman a'a si nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas makuri payto kuntra si pag'agi-na si adda kamel si tanugan-na si dagom!” ");
INSERT INTO abx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Agpamatilaw i mga magpakabati' sinan, “Kon sugad, say i masalbar?” ");
INSERT INTO abx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Anaruman may si Jesus, “Sahimu-na si Diyos i impusibli nga sahimu-na si a'a.” ");
INSERT INTO abx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mangno amahalling si Pedro, “Tara', kay ag'ambanan kami' i dimu'an tawa' kami' pagsunod si ka'aw!” ");
INSERT INTO abx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Tama', ungod nan,” lingun-na may si Jesus. “Sumatan-ta kam si kamatu'uran, bisan say i pa'amban si ruma'-na, si alla-na, si mga kadingsirarihan-na, si mga mahanak-na o si mga dadi'-na para agsara i paghadi'-na si Diyos, ");
INSERT INTO abx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iya i tikarawat anmas pa kalabbat sito si ina'anto panahon ngan si titakka, aka'angkon pa liwat iya si kinabuhi' nga gana' katapusan-na.” ");
INSERT INTO abx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Agpamabulag-na si Jesus i Dusi ngan agpaminugad-nay to, “Pasagka kita kam pan Jerusalem ngan ari turumanon i dimu'an nagsurat-na siray si mga paragsumat mahi'unong si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Papa'intrigahon iya si mga ma'in Hebro. Ralangkagan-na iya sito mga a'a, saramyangan, rurukda'an, ralapduson ngan si katapus-tapusan maratayon ");
INSERT INTO abx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pero abanhaw si katallo allaw.” ");
INSERT INTO abx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gana' mga sasabutan-na sito si mga inadalan ngan ga'i mga iya katu'anan si karuyag sidngun-na si nagparapahalling-na si Jesus kay laparap pa si mga iya i kahulugan-na. ");
INSERT INTO abx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Si pagdadara'un-na si Jesus si syudad Jerico, aniya' buta lalla magparatingkulo' ngan agparapalimos si bihing-na si tinampo. ");
INSERT INTO abx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Si pakabati'-na nga aniya' kalabbatan tilabay, agpatilaw iya si magpakadahulu'an kon ay i mahinabo'. ");
INSERT INTO abx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Anaruman may mga iya, “Tilabay si Jesus taga Nasaret.” ");
INSERT INTO abx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mangno aman'o iya, “Jesus nga Dadi'-na si David, kalu'uyin ako!” ");
INSERT INTO abx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nagsimol iya si mga magpandahulo nga ga'i agpararibok. Pero agkukusog dina i pagparaban'u-na, “Dadi'-na si David, kalu'uyin ako!” ");
INSERT INTO abx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pahuway si Jesus ngan anlihog pagsagubay si lalla pada'iray si iya. Si pakatapit-na na sito, amatilaw si Jesus, ");
INSERT INTO abx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ay i saruyagan-mo nga sahimu-ko si ka'aw?” Anaruman may iya, “Paragdalom, i karuyag-ko kunta' nga akakulaw ako gihapon.” ");
INSERT INTO abx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aminugad may si Jesus, “Akakulaw na kaw. I pagtutu'u-mo, iya i makapahalap si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Akakulaw dayon iya. Amaya' iya si Jesus ngan agparadayaw-na i Diyos. Si pakakulaw-na sinan si dimu'an mga a'a, agparapandayaw liwat mga iya. ");
INSERT INTO abx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Si panakka-na kas Jesus si kuta' magpalibot si syudad Jerico, pasallod mga iya ngan durudiritso hamok i mga langngan-na. ");
INSERT INTO abx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aniya' addangan lalla ari nag'arunan Saqueo nga puno' si mga paragsukot buhis ngan mayaman. ");
INSERT INTO abx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Agtalinguha iya pag'ikukulaw kon say si Jesus, pero tungod kay mapundok iya, ga'i iya akakulaw tungod kay naggurubukan si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sanglit palahi iya pan dahulu'an ngan amanahik si kayo sikamuro basi' akakulaw iya kay ari ti'agi si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Panyungud-na si Jesus ari, anhangad iya ngan agpinugad-na, “Saqueo, parusdusa anan. Kinahanglan ari ako gayod agdayon si ruma'-mo ina'anto.” ");
INSERT INTO abx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ag'usa iya pero ginarapan gihapon parusdos ngan bali i kalipayan-na si pagpara'istimar-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Agpakakulaw sinan i dimu'an mga a'a ngan agtikang pagpanngurub-ngurob, “Awiray iya ag'istimar-na si adda makasasala'.” ");
INSERT INTO abx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Si pagkakanan anunggo si Saqueo ngan agpinugad-na i Paragdalom, “Sinyor, aniya' kunta' papasumatun-ko si ka'am. Pumwan-ko i katunga'-na si mga inanna'-ko si mga anggana'. Bisan ay sadaya'-ko si igkasi a'a-ko, bayaran-ko i kantidad ampat dubli.” ");
INSERT INTO abx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mangno amahalling si Jesus atubang si iya, “Sa'istimar-na sito panimalay i magsalbar si mga iya mismo ina'anto allaw, kay klarado tungod si pagtutu'u-na nga addangan liwat to iya si ka'ampu-ampuhan-na si Abraham. ");
INSERT INTO abx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","I tuyu'-na si Pinili' A'a pagpada'ito, iya i pag'anda' pati' pagsalbar si mga magkararungay.” ");
INSERT INTO abx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gasi-na si mga a'a nga titikang na i paghadi'-na si Diyos kay agtatapit na mga iya si Jerusalem. Sanglit si pagparapakali-na mga iya, agtambahan-na si Jesus adda pa isturya nga agtukoy si kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Amahalling iya, “Aniya' dungganan a'a nga tibiyahi si matala nasyon basi' agpatu'in pagkahadi' ngan tibwilta iya gihapon. ");
INSERT INTO abx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sanglit agban'o iya awatong si mga tinapuran-na ngan agpa'intrigahan-na sa'aradda bulawan kwarta diplata nag'arunan mina. Agtugon iya, ‘Panigusyuhu-bi to kwarta tubtob si pagbwilta-ko.’ ");
INSERT INTO abx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pero agpanguntra dina si iya i mga ginsakupan-na ngan aniya' nagpanlihug-na paglanat ngan pagtuli si mga riklamu-na, ‘Ga'i kami' aruyag nga iyay ray a'a i hadi' kami'.’ ");
INSERT INTO abx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pero bisan pa, nagpahadi' gihapon iya. Si pagbalik-na, agpatawag-na i mga tinapuran nagpamuwanan-na kwarta, basi' sakatu'anan-na kon pira i ganansya-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Anakka i primiro ngan aminugad, ‘Sinyor, agtubo' i mina-mo ngan ahimo awatong.’ ");
INSERT INTO abx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Anaruman i amo, ‘Mahalap i nagbuhat-mo. Ka'angayan kaw tinapuran. Tungod kay akatapuran kaw si diki'it nag'antanan, tu'inan-ta kaw pagpuno' si awatong syudad.’ ");
INSERT INTO abx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Anakka i kaduwangan ngan aminugad, ‘Sinyor, agtubo' i mina-mo ngan ahimo lima.’ ");
INSERT INTO abx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Anaruman may i amu-na, ‘Ka'aw i tipuno' si lima syudad.’ ");
INSERT INTO abx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Agda'inan liwat i ditangnga' tubtob anakka i tinapuran nga agpinugad, ‘Sinyor, atiya' i mina-mo. Agputus-koy to dugnit ngan aghimus-ko. ");
INSERT INTO abx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Atalaw ako si ka'aw kay bali kaw ka'istrikto. Agparaprubitso kaw si ma'in hinimus-mo ngan agparapa'ani si ma'in pinatanuman-mo.’ ");
INSERT INTO abx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Anaruman gihapon i amo, ‘Gamit-ko i kalugaringun-mo mga allingon paghusgar si ka'aw. Bali kaw ra'at tinapuran! Kon da'inan sinan i pagkakilala-mo nga bali ako ka'istrikto ngan agparaprubitso si ma'in hinimus-ko ngan agparapa'ani si ma'in pinatanuman-ko, ");
INSERT INTO abx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kon sugad, kapa'i may kay ga'i agpadipusitu-mo si bangko i kwarta-ko basi' kunta' si pagbalik-ko, sakubra-koy nan nga aniya' na dina tubu'-na.’ ");
INSERT INTO abx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mangno agpinugad-na i magpanunggo ari, ‘Bawi'u-bi minay nan si iya ngan pumwanu-bi si addangan to nga aniya' awatung-na mina.’ ");
INSERT INTO abx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aniya' maminugad, ‘Sinyor, ay kay si iya? Awatong na tawa'-nay nan!’ ");
INSERT INTO abx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Anaruman iya, ‘Sumatan-ta kam nga bisan say i aniya', iya i binuwanan pa; pero bisan say i gana', hasta pa i diki'it tawa'-na, inala' pa tikang si iya. ");
INSERT INTO abx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero bawahu-bi pada'ito i mga magpanguntra si ako siray nga ga'i ag'ako' si pagkahadi'-ko. Matayu-bi mga iya ato atubang si ako.’” ");
INSERT INTO abx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kahuman-na si Jesus pagpahalling sinan, agpadayon mga iya pagbaktas ngan agdahulo iya pasagka pan Jerusalem. ");
INSERT INTO abx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aniya' mga baryo nag'arunan Betpahe pati' Betania nga aka'anna' si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. Si pagdadara'un-na mga iya sito mga baryo, agpadahulo si Jesus duwangan si mga inadalan-na ngan agpanmandu'an-na mga iya sito: ");
INSERT INTO abx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Pada'iraya kam si dahulu'an-tay ro kam baryo. Si panakka-bi aro, aniya' sa'anda'an-bi nagpa'ingkot putro asno nga ga'i pa gayod akakabayuhan. Bak'aru-bi ngan guyuru-bi pada'ito. ");
INSERT INTO abx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kon aniya' si ka'am mamatilaw, ‘Ay kay agbak'ad-bi nan?’ sumati-bi na hamok nga, ‘Agkinahanglan-nay to si Paragdalom.’” ");
INSERT INTO abx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pamalangngan i nagpanlihog pagdahulo ngan sa'anda'an-na mga iya i asno sigon si nagsumat si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Si pamak'ad-na mga iya, amatilaw i mga tagtawa', “Ay kay agbak'ad-bi nan?” ");
INSERT INTO abx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Anaruman mga iya, “Agkinahanglan-nay to si Paragdalom.” ");
INSERT INTO abx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Agguyud-nay to mga iya pada'iray si Jesus ngan agpamakamadiru-na i mga pammakurumbut-na ngan agpasakrang-na mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Si pagkabayu-na na, agpamuklad-na si mga a'a i mga pammakurumbut-na ari si tinampo. ");
INSERT INTO abx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Agdadara'on na kas Jesus si pagdadalugdugan-na si tinampo man Bukid-na si Ka'ulibuhan. Mangno, agtikang pagkalipay i dimu'an mga inadalan. Makusog i mga busis-na pagdayaw si Diyos tungod si dimu'an mga makagagahom binuhatan nga sakulawan-na mga iya: ");
INSERT INTO abx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Malipayon gayod i Hadi' nga pada'ito pina'agi si gahum-na si Paragdalom. Aniya' kamurayaw ari si langit ngan maka'angayan gayod i kina'iya-na si Gilalabawi! ");
INSERT INTO abx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aniya' si mga Parisiyo nga huwang si kalabbatan ari i maminugad si Jesus, “Ma'istro, simulon mga inadalan-moy nan!” ");
INSERT INTO abx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Anaruman iya, “Sumatan-ta kam, kon ga'i mga iya agpanibu'-sibo', agpanggasod may i mga bato.” ");
INSERT INTO abx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Si pagra'un-da'un-na si Jesus si Jerusalem, anuro' i luha'-na si pakapantaw-na si syudad tungod si ura-ura kalu'uy-na. ");
INSERT INTO abx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Agpahalling iya, “Ka'am mga taga Jerusalem, kon katu'anan kam hamok ina'anto mga allaw kon ay kunta' i makapamurayaw si ka'am pero palihis na i uras kay agpakangbuta kam hamok. ");
INSERT INTO abx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Titakka i panahon nga nagpalibutan i syudad-bi si mga kuntra-bi. Tampungan-na mga iya i mga pangngagihan-bi ngan panulung-na kam. ");
INSERT INTO abx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Paratagun-na mga iya i dimu'an nagtindug-bi ngan manhumpilad kam hasta i mga dadi'-bi nga awinan sallod si kuta'-bi. Gana' binilin-na mga iya bato bisan namay hamok adda si mga nagpanungtungan-nay nan. Buruhaton to dimu'an kay ga'i kam manginano ngan pada'itu-na si Diyus-bi pagtalwas si ka'am.” ");
INSERT INTO abx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pasallod si Jesus si hawan-na si templo ngan diritso agtikang pagpanabrog si mga magparapamaligya' ari. ");
INSERT INTO abx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Agpaminugad-na mga iya, “Aka'anna' na siray pa si Kasuratan nga agpinugad i Diyos, ‘Pammangadyi'an i ruma'-ko,’ kundi' aghimu-bi to dina ‘pangngingistaran-na si mga tulisan.’” ");
INSERT INTO abx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mangno allaw-allaw na iya agparaturo' ari si templo. Ag'aradda i mga puno' paraghalad huwang si mga paragturo' bala'od pati' si mga punu'-na si mga a'a pagmamatay kunta' si iya, ");
INSERT INTO abx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","pero ga'i mga iya aka'anda' pa'agi kay agtuninong gayod i dimu'an mga a'a si mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Agpadayon si Jesus si pagparaturu'-na si mga a'a ari si mga hawan-na si templo, ngan i mahalap sumat i nagparawali-na. Adda sinan mga allaw, pamadugok si iya i mga puno' paraghalad pati' i mga paragturo' bala'od huwang i mga mata'o kamabu'utan ngan agpamatilaw, ");
INSERT INTO abx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Sumatin kami', singnga kaw agsarit si mga nagparabuhat-mo? Say i magtugot si ka'aw sinan?” ");
INSERT INTO abx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Anaruman dina si Jesus, “Patilawan-ta may kam liwat. Sumati-bi daw ako, ");
INSERT INTO abx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","say i magtugot pagbunyag si Juan, Diyos o a'a?” ");
INSERT INTO abx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Agpandiriskusyon dahulo mga iya, “Tara', ay sito i pinasumat-ta kam? Kon anaruman kita kam, ‘I Diyos,’ sigurado amatilaw nan iya, ‘Kon sugad, kapa'i may kay ga'i kam agtutu'o si mga allingun-na si Juan?’ ");
INSERT INTO abx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero kon anaruman may liwat kita kam, ‘I a'a,’ aniya' kadilikaduhan-ta kam kay sigurado nga tinalutugan kita kam si mga a'a kay i mga pagtu'u-na gayod nga paragsumat-na si Diyos si Juan.” ");
INSERT INTO abx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sanglit anaruman dina mga iya, “Ga'i kami' akatu'anan kon say magtugot si iya.” ");
INSERT INTO abx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Anaruman gihapon si Jesus, “Kon sugad, ga'i may liwat ako anumat si ka'am kon say i magtugot si ako nga sabuhat-koy to.” ");
INSERT INTO abx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Agpadayon si Jesus pagpahalling si mga a'a sito isturya nga agtukoy si kamatu'uran: “Aniya' lalla magtanom ubasan. Agpa'ataman-nay to si mga mangngataman ngan pataliwan iya. Maliyat iya ag'istar si la'in lugar. ");
INSERT INTO abx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ngan panakka-na si tigpangku'on si ubas, agpabawa iya addangan rilihugon pada'iray si mga mangngataman-na basi' pumwan-na mga iya i kapartihan-na si mga pinangku'-na. Pero agpuniti-na dina mga iya i rilihugon, ngan agpabalik-na mga iya nga gana' gayod sabawa-na. ");
INSERT INTO abx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Agpabawa gihapon i tagtawa' addangan rilihugon pero nagparapuniti to liwat. Nagparapakamalu'an to ngan nagpabalik nga gana' sabawa-na. ");
INSERT INTO abx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Agpabawa-na pa liwat i katallungan rilihugon. Agsamad-nay to mga iya ngan agpasurhub-na si gawas-na si ubasan. ");
INSERT INTO abx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mangno akapinugad i tagtawa' si kalugaringun-na, ‘Ay daw i binuhat-ko? Pabawa-ko dadi'-koy to lalla nga hinigugma'-ko. Tingali rispitaran-nay to mga iya.’ ");
INSERT INTO abx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Pero si pakakulaw-na si mga mangngataman si dadi', agsarabut-sabot mga iya, ‘Awira' i iridiro. Matay-ta kam iya basi' kita kam i makabawa si kayamanan-na.’ ");
INSERT INTO abx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sanglit agdagnas-nay to mga iya pagawas si ubasan ngan agmatay-na.” Amatilaw si Jesus pagpaklaro si isturya-na, “Kon sugad, ay may i binuhat-na si tagtawa' si ubasan kuntra si mga iya?” ");
INSERT INTO abx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iya mismo manaruman si pagpinugad, “Yayto i binuhat-na: Pada'iray iya ngan matay-na i mga mangngataman. Katapos, pa'intriga-na si la'in i ubasan-na.” Si pakapakali-na sinan si mga a'a, agpaminugad mga iya, “Ga'i nan kunta' ahinabo'!” ");
INSERT INTO abx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Agpapuntuk-na si Jesus i pangulawan-na si mga iya ngan aminugad, “Kon ma'in nan iya i karuyag-bi mahinabo', ay may i pagkasabut-bi si nagsurat siray si Kasuratan? Kon ma'in i nagpabawa-na dadi', say may bali' i nagpinugad bato nga maka'anna' ari? I bato nga nagdiri'-na si mga panday iya lugod dina i makapasarig si dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bisan say i makapangkol sinan bato, sigurado nga akadusmog iya ngan gana' na pulus-na si kinabuhi'-na. Pwira sinan, titakka liwat i uras nga alaho' nan bato ngan i maka'untugan ga'i na gayod nag'arim-ariman.” ");
INSERT INTO abx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Akatu'anan i mga paragturo' bala'od pati' mga puno' paraghalad nga mga iya i nagpatama'an sito isturya. Sanglit ag'anda' dayon mga iya pa'agi pagdakop si Jesus pero ga'i to mga sahimu-na kay atalaw mga iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Agparatigamanan-na mga iya pahalap si Jesus sanglit agpanlihog mga iya ispiya nga agpamakunu-kuno nga mga tangkod a'a. Agla'om mga iya nga mga sadakup-na si Jesus kon anala' si pagpahalling-na, basi' sapa'intriga-nay to mga iya si pudir-na si gubirnador. ");
INSERT INTO abx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Agpamatilaw i mga ispiya si Jesus, “Ma'istro, katu'anan kami' nga pirmi tama' i mga pinahallingan-mo pati' pagturu'-mo. Gana' pina'urug-mo si bisan say kundi' agturo' kaw hamok i pa'agi pagtapit si Diyos nga ag'alagad si kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sumatin ngani' kami', tama' ba' para si kita kam i pagbayad buhis si Emperador si Roma o ma'in?” ");
INSERT INTO abx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kundi' sayod si Jesus si mga kalistuhan-na, sanglit aminugad iya, ");
INSERT INTO abx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakulawu-bi daw ako adda dinari diplata.” Mangno amatilaw iya, “Say nan tawa' bayhon pati' aron maka'anna' nan anan?” ");
INSERT INTO abx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Anaruman mga iya, “Tawa'-na si Emperador.” Sanglit amahalling may si Jesus, “Kon sugad, bayari-bi i Emperador si mga hinimo nga irog si iya kay tawa'-nay nan ngan bayari-bi may i Diyos si mga hinimo nga irog may liwat si iya kay tawa'-nay nan.” ");
INSERT INTO abx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ga'i mga iya sadakup-na si Jesus si mga allingun-na ari si publiko, ngan ga'i liwat mga iya agpakasibo' kay bali i pag'usa-na mga iya si saruman-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aniya' pamadugok si Jesus mga Sadusiyo basi' agpakapatilaw. I mga Sadusiyo, iya i magparapanumat nga ga'i na abanhaw i mga a'a si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aminugad mga iya, “Ma'istro, aniya' mando' nagsurat-na si Moises para si kita kam nga kinahanglan pakasalan-na si sirari i bayaw-na kon amatay i siyaka-na nga gana' pa dadi'-na, basi' akadadi' mga iya nga akwinta bilang dadi'-na si siyaka-na. ");
INSERT INTO abx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aniya' siray pitungan lalla magdingsirarihan. Inallahan i siyaka, pero amatay iya nga gana' pa dadi'-na. ");
INSERT INTO abx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mangno, agpakasalan-na si kaduwangan ");
INSERT INTO abx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ngan da'inan may liwat si katallungan hasta nga agbuhat-nay nan si mga magkabirilin pa mga sirari. Agpakasalan-nay ray danda mga iya pitungan ngan agkamaratay mga iya nga ga'i agpakadadi'. ");
INSERT INTO abx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Si katapus-tapusan, amatay liwat i danda. ");
INSERT INTO abx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tara', si pagkabanhaw, say may i tag'alla si danda, kay sapakasalan-na iya si pitungan?” ");
INSERT INTO abx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Anaruman si Jesus, “Agpamakasal i mga a'a ina'anto panahon. ");
INSERT INTO abx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero la'in i kamutangan si mga a'a nga angay papasakupon si titakka panahon, si uras nga abanhaw mga iya, kay gana' na uru'allahay ari. ");
INSERT INTO abx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ga'i na mga iya agkamaratay kay akapariho na mga iya si mga anghel. Mga dadi'-na na mga iya si Diyos ngan agdiringsirarihan tungod si kabanhaw-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero mahi'unong si mga duda-bi kon aniya' ba' mabanhaw, agpamatu'uran-na nayto si Moises si nagsurat-na mahi'unong si hinabo' siray si magpakayat tanaman kon singnga ag'arunan-na i Paragdalom ‘I Diyos nagtutu'u-na kas Abraham, Isaac pati' si Jacob hasta pa ina'anto.’ ");
INSERT INTO abx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kon sugad, pariho si kamutangan-na mga iya, ma'in minatay i magpadayon pagtutu'o kundi' allom dina, ngan tungod sinan, akasayuran kita nga agpadayon pa i kinabuhi'-na si dimu'an nga mamatay na.” ");
INSERT INTO abx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aniya' mga paragturo' bala'od ari i manaruman dina, “Ma'istro, mahalap i saruman-mo!” ");
INSERT INTO abx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gana' na ni addangan mamuso' pagpatilaw si iya. ");
INSERT INTO abx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mangno amatilaw si Jesus si mga iya, “Pinapa'i akapinugad i mga paragturo' bala'od nga gi'uru'ampuhi-na hamok si David i Tinu'inan Mannanalwas? ");
INSERT INTO abx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mismo si David agpakatu'an ari si Libro si mga Salmo: Agpinugad i Paragdalom Diyos pada'iray si Paragdalum-ko, ‘Aningkulu'a ato si kawanan-ko, ");
INSERT INTO abx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tubtob nga sapama'ubus-ko i mga kuntra-mo pa nga day pannungtungan-mo.’ ");
INSERT INTO abx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kon sugad, ‘Paragdalom’ i pagban'u-na si David si gi'uru'ampuhi-na. Sanglit pinapa'i kam akapinugad nga gi'uru'ampuhi-na hamok si David i Tinu'inan Mannanalwas?” ");
INSERT INTO abx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Si pagparapakali-na si mga a'a, agpinugad-na si Jesus i mga inadalan-na, ");
INSERT INTO abx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Agmatuha kam si mga paragturo' bala'od kay agkararuyag mga iya paglalangngan nga mga dikalsa pagpadadayaw ngan agkararuyag liwat si mga talahuron pangumusta-na si mga a'a ari si mirkado. Iyay nan i mga magparapamili' si mga printi panningkulu'an si mga sinaguga pati' si mga pwistoy nan nga akabuwan unra si mga kumbitihan. ");
INSERT INTO abx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mga iya i magparapandaya' si mga balo danda pag'ala' si mga inanna'-na, ngan katapos agparapangadyi' to mga a'a maliyat para hamok si pangulawan-na si la'in. Sanglit tungod sinan, mas mara'at i kastigo si mga iya kuntra si ditangnga'.” ");
INSERT INTO abx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Si panili'-na si Jesus, sakulawan-na i pagparalahu'-na si mga mayaman si mga panhahalad-na ari si kahon pangnganna'an kwarta si templo. ");
INSERT INTO abx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mangno aniya' pubri balo danda manlaho' duwa hamok tumbaga diplata. ");
INSERT INTO abx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aminugad si Jesus, “Sumatan-ta kam si kamatu'uran, mas urog i naglahu'-na si pubri nan balo kuntra si tawa'-na mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay i nagpadunar-na mga iya, subra hamok si mga kayamanan-na; pero yaynan balo bisan kon anggana' iya, aglahu'-na i dimu'an pankunsumu-na.” ");
INSERT INTO abx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aniya' magparapamahalling mahi'unong si templo nga mahalap i pagkadikurasyon sito si mga kinurtihan bato pati' si mga ka'angayan inanna' nagpamahalad si Diyos. Pero aminugad si Jesus, ");
INSERT INTO abx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Titakka i allaw nga gana' sinan mabilin si mga sakulawan-bi nan bato si nagpanungtungan-na. Tirimpagon nan dimu'an.” ");
INSERT INTO abx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Agpamatilaw mga iya, “Ma'istro, sumatin daw kami' kon sumiran nan ahinabo'. Ay i pangngilalahan nga matapit na i uras?” ");
INSERT INTO abx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Anaruman si Jesus, “Agbantaya kam, ngan dakam agpatugot nga akadaya'an kam si bisan say, kay malabbat i tipada'ito nga aggamit si arun-ko si pagpinugad, ‘Ako i Tinu'inan Mannanalwas,’ ngan agpanumat liwat, ‘Matapit na i uras.’ Dakam anunod si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dakam atalaw si pakapamati'-bi nga aniya' mga girra pati' magpangato si gubyirno. Kinahanglan ahinabo' dahulo i mga da'ito sito pero ga'i dayon anakka i pagtapos si panahon.” ");
INSERT INTO abx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mangno agpadayon si Jesus pagsumat si mga iya, “Agparapanggirirra i mga nasyon ngan sigi panhiriran i mga ginhadi'an. ");
INSERT INTO abx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aniya' mga makusog gayod linog, mga gutom pati' pisti si pala'in-la'in lugar ngan ari may si langit aniya' mga makangingirhat hinabo' pati' mga pangngilalahan si langitnon kasiguruhan. ");
INSERT INTO abx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero antis nan ahinabo', darakupun-na kam si mga a'a ngan papasakitan-na kam tungod si pagtu'u-bi. Barawahun-na kam mga iya si mga sinaguga pati' si mga prisuhan ngan papa'atubangun-na kam si mga hadi' pati' mga gubirnador tungod si ako. ");
INSERT INTO abx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tungod sinan, akatistigos kam si mga iya si ungod mahinabo'. ");
INSERT INTO abx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero pasarigu-bi i mga inisipan-bi ina'anto nga ga'i kam abaraka kon pinapa'i pagdipinsa si mga kalugaringun-bi antis sinan allaw ");
INSERT INTO abx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kay pumwan-ko si ka'am i kadunong si pagpahalling basi' gana' na gayod pa'agi-na si mga ka'asuntu-bi pagpakidiskusyon si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bisan ngani' i mga mahanak-bi, mga kadingsirarihan-bi, mga paryinti-bi pati' i mga kumpaniya-bi titraydor si ka'am. Aniya' si ka'am nagpanmatay-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aghumot si ka'am i dimu'an mga a'a tungod si ako. ");
INSERT INTO abx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero akatapod kam nga kumplito i katalwasan-bi nga gana' ni adda marungay si mga barahibu-bi. ");
INSERT INTO abx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pina'agi si pag'ilub-bi sa'angkun-bi i ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pero si pakakulaw-bi nga nagpalibutan na i Jerusalem si mga sundalo, katu'anan kam nga matapit na i pakabungkag-na. ");
INSERT INTO abx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kinahanglan agrarabunos pan tagudtod i mga magpangistar ari si Judea. I mga sari'i si sallud-na si syudad kinahanglan pamagawas ngan i mga sari'i si uma, ga'i na pamadulhog. ");
INSERT INTO abx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iyay nan i panahon si kastigo pagtuman si dimu'an nagpansurat siray. ");
INSERT INTO abx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka'asi' gayod sinan mga allaw i mga burod pati' i mga nana nga aniya' nagpasusu-na! Bali gayod i kakurihan sito lugar ngan bali i pagkakastigo sito mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Maratayon mga iya si ispada o ma'in ngani' barawahon mga iya bilang priso si dimu'an mga nasyon. Padayon agturutum'ak i mga ma'in Hebro si Jerusalem hasta nga ga'i akumplito i katuyu'an-na si Diyos hi'unong si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aniya' mga pangngilalahan si langitnon kasiguruhan nga kinakulawan si allaw, si bulan pati' si mga bitu'on. Ato si kalibutan, agsakit i mga nasyon ngan agkabururong tungod si hinagashas-na pati' binuk'ay-na si mamahaya alon. ");
INSERT INTO abx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Agkadirismayo i mga a'a pag'antahak kon ay i manakka si kalibutan kay agpamalisa i dimu'an gamhanan ari si mga ararupan-na. ");
INSERT INTO abx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sinan uras, sakulawan-na si mga a'a i Pinili' A'a ari si panganod. Agdadara'on iya panno' si gahom ngan nagpalibutan si maka'angayan gayod danta'. ");
INSERT INTO abx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Si pagtikang-na sito mga hinabo', anungguha kam ngan anhangara kay agtatapit na i katalwasan-bi.” ");
INSERT INTO abx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Agsumatan-na liwat mga iya sito isturya nga agtukoy si kamatu'uran: “Kulawi-bi daw i kayo igos o bisan ay kayuha. ");
INSERT INTO abx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kon aniya' na sito buraksa'-na, akatu'anan kam nga ma'in na pira i tigpangku'on bisan kon ga'i kam nagsumatan. ");
INSERT INTO abx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pariho sinan, si pakakulaw-bi nga ahinabo' nan dimu'an, akatu'anan kam nga matapit na gayod i paghadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sumatan-ta kam si kamatu'uran, ahinabo' nan dimu'an antis ahuman i kapanahunan-na si mga a'ay to ina'anto. ");
INSERT INTO abx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aniya' titakka katapusan-na si kalangitan pati' si kalibutan, pero gana' gayod katapusan-na si mga allingun-ko hasta si kahastahan. ");
INSERT INTO abx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Agmatuha kam basi' ga'i abaraw i mga inisipan-bi si pagpaka'allom tungod si kabaraka o ma'in ngani' pag'atindir si pala'in-la'in kalipayan hasta nga agkaralango kam. Tungod si kabaraw-bi, agpakahintakan kam kon anakkay nan allaw pariho si pagbugkas-na si padlong si uras nga ga'i kam anggasi. ");
INSERT INTO abx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sigurado nga gana' makalibri si dimu'an magpangistar ato si bug'os kalibutan. ");
INSERT INTO abx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lugod, agbantaya kam pirmi huwang i pagpangadyi' nga aniya' kusug-bi paglahos si dimu'an titakkay ro hinabo' ngan basi' akatunggo kam atubang si Pinili' A'a.” ");
INSERT INTO abx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Allaw-allaw agparaturo' si Jesus si templo ngan sangum-sangom iya pagawas basi' amaturi ari si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. ");
INSERT INTO abx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nalung-nalong pa, pada'iray na si templo i mga a'a pagpakali si iya. ");
INSERT INTO abx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Agtatapit na i Pyista si Tinapay nga Gana' Pammatubu'-na nga nag'arunan liwat Pyista si Paglabay. ");
INSERT INTO abx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Agkataralaw i mga puno' paraghalad pati' i mga paragturo' bala'od si mga a'a sanglit agparapanganda' mga iya pa'agi nga sapamatay-na mga iya si Jesus nga gana' makatu'an-tu'anan. ");
INSERT INTO abx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Siray uras akatumanan na si Satanas pagdalom si Judas Iscariote, nga addangan si Dusi. ");
INSERT INTO abx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Agpada'iray-na si Judas i mga puno' paraghalad pati' i mga puno' si mga bantay si templo. Makikunsaboy to si mga iya kon pa'i-na agtraydor si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Agkaralipay i mga puno' ngan ag'aradda mga iya pagsuhol kwarta si Judas si pagtangdu'-na. ");
INSERT INTO abx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sanglit angabuyon iya ngan agtikang pag'anda' si tama' uras nga sapa'intriga-na si Jesus si mga iya kon ma'in ma'a'a. ");
INSERT INTO abx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mangno anakka i nagtala'an allaw sallod si Pyista si Tinapay nga Gana' Pammatubu'-na pagbuno' si mga papahalaron nati pa karniro para si pakan pagpa'intom si Paglabay. ");
INSERT INTO abx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sanglit agtugunan-na si Jesus si Pedro pati' si Juan, “Padulhuga kam ari ngan timahu-bi i karakanun-ta kam para si pakan.” ");
INSERT INTO abx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Agpamatilaw mga iya, “Singnga may karuyag-mo nga agtima kami'?” ");
INSERT INTO abx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Anaruman si Jesus, “Si pasallud-bi si syudad, aniya' sakulawan-bi aro lalla nga agsuknong adda biso' buwahi'. Amungyura kam si iya si ruma' nagpanahikan-na, ");
INSERT INTO abx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ngan sumati-bi i tagruma', ‘Agpatilaw i Ma'istro si ka'aw kon singnga i kwarto pammanganan-na basi' akapamangan iya huwang si mga inadalan-na pagpa'intom si Paglabay.’ ");
INSERT INTO abx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mangno, pakulaw-na kam adda mahaya kwarto ari si dyata' nga hamis na i dimu'an. Timahi-bi ari.” ");
INSERT INTO abx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pa'amban mga iya ngan sa'anda'an-na i dimu'an nagsumat-na si Jesus. Mangno agtima mga iya para si pakan. ");
INSERT INTO abx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngan panakka-na si uras, agtarangka' kas Jesus pati' i mga apostul-na. ");
INSERT INTO abx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Agpinugad-na mga iya, “Agtalinguha gayod ako nga agkatarangka' kita kam pagpa'intom si Paglabay ina'anto myintras ako agsakit, ");
INSERT INTO abx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","kay sumatan-ta kam, ga'i na ako angutro agkakan sito tubtob atuman i katuyu'an-na sito pakan ari si ginhadi'an-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Katapos, angaddo' iya kupa ngan agpasalamat si Diyos dungan si pagpinugad, “Karawatu-bi to ngan agpa'uru'arambitaya kam, ");
INSERT INTO abx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kay sumatan-ta kam, tikang ina'anto ga'i na ako anginom si bino tubtob anakka i paghadi'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mangno angaddo' iya adda bug'os pan ngan agpasalamat si Diyos. Agturutabbi'-nay to ngan agpumwan-na si mga iya dungan si pagpinugad, “Iyay to i puhu'-ko nga nagpatubyan para si ka'am. Irugu-bi to buhat basi' pirmi ako sa'intuman-bi.” ");
INSERT INTO abx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kahuman si panihapon, ag'addu'-na utro i kupa ngan pariho gihapon i nagbuhat-na. Aminugad iya, “Iyay to kupa i kasarigan si baha'o pa'agi-na si Diyos pagtapit si iya ngan ahimoy to pina'agi si laha'-ko nga pa'awas para si ka'am. ");
INSERT INTO abx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero i titraydor si ako, atiya' agtangka' sito lamisa. ");
INSERT INTO abx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maratayon i Pinili' A'a sigon si dati planu-na si Diyos, pero papabidu'on gayod i titraydor si iya.” ");
INSERT INTO abx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mangno agsipuruparatilaway mga iya kon say si mga iya i makabuhat sito. ");
INSERT INTO abx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Katapos, agparasusuhay mga iya kon say i bantugan si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Agwaydong si mga iya si Jesus, “Agpanggamit pinirit pagdalom i mga hadi'-na si mga nasyon ngan i mga aniya' gahum-na aglugaring pagpangaron ‘Paragbuhat Mahalap’ si mga kalugaringun-na. ");
INSERT INTO abx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero ma'in da'inan sinan i pa'agi-bi pagdalom si kapararihu-bi. Lugod, kon say si ka'am i pinakabantugan, kunta' aglugaring iya nga magin gisirarihi ngan i magpuno' may kinahanglan agpakangrilihugon. ");
INSERT INTO abx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kay singnga si duway to i labaw, i nagtuluran o i magtulod? Ma'in ba' i nagtuluran? Pero si paghuwang-ko si ka'am, agpakangrilihugon ako dina. ");
INSERT INTO abx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ka'am i mag'unong si mga kakurihan-ko. ");
INSERT INTO abx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sanglit papatu'inun-ko si ka'am i gahom pagpamuno' pariho si nagpatu'in-na na si Tatay-ko si ako, ");
INSERT INTO abx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","basi' agkatarangka' kam si lamisa-ko ari si ginhadi'an-ko ngan basi' nagpamatingkulo' kam si mga truno si uras nga husgaran-bi i dusi pamilya si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, amati'a Simon. Tugot na si Satanas pagpurbar kon ungod i mga pagtutu'u-bi ngan pina'agi sito abulag i tangkod pati' i ma'in nga day nag'ag'ag trigo. ");
INSERT INTO abx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero ag'ampu'an-ta kaw nga ga'i arungay i pagtutu'u-mo. Si pagsarig-na gihapon si pagtutu'u-mo, pakusugon i mga pagtutu'u-na si mga kabugtu'an-mo.” ");
INSERT INTO abx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aminugad may iya, “Paragdalom, andam ako pagpakihuwang si ka'aw bisan pa si kaprisuhan pati' si kamatayon.” ");
INSERT INTO abx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Anaruman may si Jesus, “Pedro, sumatan-ta kaw, antis anutturu'ok i manok ina'anto, agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo.” ");
INSERT INTO abx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mangno amatilaw si Jesus, “Aniya' ba' pangulangan-bi ngan pagpalangngan-ko si ka'am nga gana' bawa-bawahay pitaka, bag pati' adda pa sandalyas?” Agpanaruman mga iya, “Gana'.” ");
INSERT INTO abx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agpinugad-na mga iya si Jesus, “Pero ina'anto, bawahu-bi kon aniya' pitaka-bi pati' bag-bi, ngan kon say i gana' ispada-na, kinahanglan baligya'an-na i pammakurumbut-na basi' akaballi iya. ");
INSERT INTO abx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kinahanglan atuman si kinabuhi'-ko i maka'anna' si Kasuratan: ‘Trarataron iya pariho si makasasala'.’ Sumatan-ta kam nga ma'in na pira i pagtuman sito.” ");
INSERT INTO abx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mangno agpaminugad i mga inadalan, “Paragdalom, kulawin, aniya' ato duwa ispada.” Anaruman si Jesus, “Tama' naynan.” ");
INSERT INTO abx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kahuman sinan pamatakod kas Jesus pati' i mga inadalan-na pada'iray si tagudtod nag'arunan Bukid-na si Ka'ulibuhan kay iya may i kabatasanan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Si panakka-na mga iya ari agpaminugad-nay to, “Ag'ampu'a kam basi' sa'agwanta-bi i mga pagpurbar si mga pagtutu'u-bi.” ");
INSERT INTO abx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mangno padahulo iya si mga inadalan-na nga tu'ig hamok takka-na si balitok i katala-na. Anluhod iya ngan agpangadyi', ");
INSERT INTO abx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tatay-ko, kon katuyu'an-mo, ala'on to kupa si kasakitan tikang si ako, pero dakaw agtumanon i katuyu'an-ko hamok, kundi' i katuyu'an-mo gayod.” ");
INSERT INTO abx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Katapos, aniya' anghel man langit pakulaw si iya ngan agpabaskug-na i pagtutu'u-na. ");
INSERT INTO abx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mangno day mabuka i kasing-kasing-na si kasakitan. Maniguro pa gayod iya agpangadyi' ngan manarabigay i dangga-na day laha' nga sigi mattak. ");
INSERT INTO abx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kahuman-na ag'ampo', pabwiltay to si mga iya ngan satakkahan-na nga agparapamaturi na dina tungod si mga kabidu'an-na. ");
INSERT INTO abx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Agtilaw-na mga iya si Jesus, “Ay kay agparapamaturi kam? Banguna kam anan ngan ag'ampu'a kam basi' agpaka'agwanta kam.” ");
INSERT INTO abx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Si pagparapahalling-na pa si Jesus, aniya' kalabbatan manakka ngan i magbaya' si mga iya, iya si Judas nga addangan si Dusi. Agduguk-na sito si Jesus basi' angurok. ");
INSERT INTO abx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero amatilaw si Jesus, “I pag'uruk-mo ba' i pa'agi-mo pagtukoy si Pinili' A'a pagtraydor si iya?” ");
INSERT INTO abx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ngan pakasabut-na na si mga magpalibot si Jesus si tihinabo', amatilaw mga iya, “Paragdalom, gamit kami' ba' mga ispaday to?” ");
INSERT INTO abx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngan addangan si mga iya i manigbas dayon si rilihugun-na si gilalabawi paraghalad, ngan akapalungan i kawanan talinga-na. ");
INSERT INTO abx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero agsimul-na mga iya si Jesus, “Tama' naynan!” Mangno, ag'addu'-na i talinga-na si lalla ngan agpasulit-na gihapon. ");
INSERT INTO abx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mangno amahalling si Jesus ari si mga puno' paraghalad, si mga puno' si mga gwardya si templo pati' si mga mata'o kamabu'utan nga agpamada'iray pagdakop si iya, “Ribildi ba' ako nga kinahanglan kam gayod agbawa si mga ispada-bi pati' si mga batuta-bi? ");
INSERT INTO abx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Balang allaw aghururuwang kita kam ari si mga hawan-na si templo ngan ga'i may ako agdakup-bi. Pero iya nayto i uras nagpatugut-na si ka'am si Diyos, i uras nga i kalu'uman i magdalom.” ");
INSERT INTO abx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mangno, agpugulan-na mga iya si Jesus ngan agbawa-nay to mga iya pada'iray si ruma'-na si gilalabawi paraghalad. Amungyod si Pedro nga apartado si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Si panakka-na mga iya, aniya' magpaparuktan ari si hawan nga pangngangarung-arungan ngan pahuwang si Pedro si mga magpaningkarag ari. ");
INSERT INTO abx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Si pagparalumpagi'-na ari, aniya' kabulig danda makakulaw si iya. Agparahiling-hiling-na iya pahalap ngan aminugad, “Huwang-nay to liwat sinan!” ");
INSERT INTO abx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero agdidiwarayan-na iya si pagpinugad, “Ni', ga'i ako angilala sinan.” ");
INSERT INTO abx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kata'ud-ta'uran, aniya' liwat maminugad si iya, “Addangan liwat kaw si mga kahuruwangan-na.” Anaruman si Pedro, “Mano, ga'i kami' aghuwang sinan.” ");
INSERT INTO abx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mga un'ura i palihis, aniya' gihapon maminugad, “Sigurado ako nga huwang-nay to liwat sinan, kay taga Galilea liwat iya.” ");
INSERT INTO abx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Anaruman si Pedro, “Ambot Mano, gana' sa'urup-urupan-ko si nagparayawit-moy nan!” Mismo si pagparapahalling-na, anutturu'ok i manok. ");
INSERT INTO abx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Anili' i Paragdalom ngan diritso agbuslung-na si Pedro. Tungod sinan, sa'intuman-na dayon si Pedro i pinahallingan-na si Paragdalom: “Antis anutturu'ok i manok ina'anto, agdidiwaray na kaw dina sin tallo nga ga'i ako sakilala-mo.” ");
INSERT INTO abx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mangno pagawas iya ngan ari agparadinamag makusog. ");
INSERT INTO abx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Siray uras, nagparalangkagan si Jesus ngan nagparapuniti si mga gwardya magpamantay si iya. ");
INSERT INTO abx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nagtambunan i mga mata-na ngan nagparapinugad, “Tiguhon daw! Say di' i mamuniti si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngan agparapamahalling pa mga iya mga pala'in-la'in pagtamay si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kanalungan, agtiripon i kunsihu-na si mga mata'o kamabu'utan si mga Hebro, nga aghururuwang i mga puno' paraghalad pati' i mga paragturo' bala'od. Agpa'atubang-na mga iya si Jesus ngan ");
INSERT INTO abx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","agmandaran-na, “Sumatin ngani' kami': Ka'aw ba' i Tinu'inan Mannanalwas?” Anaruman si Jesus, “Kon sumatan-ta kam, ga'i kam anutu'o, ");
INSERT INTO abx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ngan kon ako namay i mamatilaw si ka'am, ga'i kam anaruman. ");
INSERT INTO abx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero tikang si ina'anto, papatingkulu'on i Pinili' A'a si kawanan-na si Makagagahom Diyos.” ");
INSERT INTO abx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Agpamatilaw mga iya dimu'an, “Kon sugad, ka'aw bali' i Dadi'-na si Diyos?” Anaruman si Jesus, “Tama' gayod i pagkapinugad-bi nga ako.” ");
INSERT INTO abx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mangisog dayon mga iya, “Ga'i na kita kam agkinahanglan pa mga ibidinsya! Mismo iya i magyawit si mga mara'at allingon nga sapamati'an-ta na kam.” ");
INSERT INTO abx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pamatunggo i bug'os kunsiho ngan nagbawa dayon iya atubang si Pilato. ");
INSERT INTO abx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Agtikangan-nay to mga iya pagpasumbong si pagpinugad, “Sadiskubrihan kami' nga agparapamasamuk-na sito a'a i nasyun-ta kam. Agdiri'-na i pagbayad buhis si Emperador ngan agparapinugad nga addangan iya hadi', i Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sanglit agtilaw-na si Pilato si Jesus, “Ka'aw ba' i hadi'-na si mga Hebro?” Anaruman may si Jesus, “Oho', ngan ka'aw i magpaguwa' sinan.” ");
INSERT INTO abx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mangno agpinugad-na si Pilato i mga puno' paraghalad pati' i magpanggubok ari, “Gana' sa'anda'an-ko sala' sito a'a nga angay paratukan.” ");
INSERT INTO abx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero agpamirit gayod mga iya si pagpinugad, “Iyay nan i a'a magparapasaramulyo si mga a'a si bug'os Judea pina'agi si mga turu'-na. Agtikang iya ari si Galilea ngan agparaharushus-na pada'ito.” ");
INSERT INTO abx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Si pakabati'-na sinan si Pilato, amatilaw iya kon taga Galilea ba' si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Si pakakatu'an-na nga taga sunsari'i si Jesus si nagpamunu'an-na si Herodes, agpapada'iray-nay to si nag'istaran-na kay siray uras ari liwat mismo si Jerusalem si Herodes. ");
INSERT INTO abx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Si pakakulaw-na si Herodes si Jesus, bali gayod i kalipay-na. Maliyat na panahon aghandom iya pag'ikukulaw tungod si mga sapamati'an-na mahi'unong si iya ngan agla'om iya nga aniya' mga makagagahom binuhatan sapakulaw-na si iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sanglit malabbat i mga patilaw-na si Herodes pero ga'i gayod iya anaruman. ");
INSERT INTO abx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Agparapantutunggo ari i mga puno' paraghalad pati' i mga paragturo' bala'od ngan maniguroy to gayod mga iya paghimu-himo kasal'anan kuntra si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mangno nagparapakamalu'an liwat iya si kas Herodes pati' si mga sundalu-na. Agparapanlangkagan-nay to mga iya ngan agbistihan-na si mabulangga'ak gayod. Pagkatapos agpabwilta-na mga iya pada'iray si Pilato. ");
INSERT INTO abx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tikang siray allaw, agkakumpaniya na kas Herodes pati' Pilato nga dati bali pagkuntrahan. ");
INSERT INTO abx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Agpaman'u-na si Pilato i mga puno' paraghalad, i mga la'in pa punu'an pati' i mga a'a ");
INSERT INTO abx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ngan agpaminugad-na, “Agbawa-bi to a'a ato ngan agpaminugad kam nga agparadagka-na i mga a'a pagribildi. Ag'usisa-ko na iya atubang si ka'am ngan gana' sa'anda'an-ko sala' sito a'a nga angay paratukan sigon si mga sumbung-bi. ");
INSERT INTO abx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Da'inan may si Herodes, gana' liwat sa'anda'an-na si iya sala', sanglit agpabwilta-na iya ato si kita kam. Mismo ka'am akakulaw nga gana' binuhatan-na nga angay paratukan kamatayon. ");
INSERT INTO abx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sanglit, palibri-ko iya kahuman-ko si iya agpalapnit.” ");
INSERT INTO abx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Agdurungan i mga a'a agpanurakaw, “Matayon nan a'a! Palibrihon si Barabas!” ");
INSERT INTO abx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Apriso si Barabas tungod kay iya i magtikang si saramok ari si syudad pati' akamatay. ");
INSERT INTO abx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aruyag gayod si Pilato nga akalibri si Jesus, sanglit, makibagaw gihapon iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero sigi hamok mga iya panurakaw, “Papaku'on iya si kudos, papaku'on iya si kudos!” ");
INSERT INTO abx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Si katallo bisis aminugad gihapon si Pilato si mga iya, “Apa'i may kay agda'inana kam sinan? Ay i mara'at binuhatan-na sito a'a? Gana' may sa'anda'an-ko si iya sala' nga angay paratukan kamatayon. Sanglit, palapnit-ko hamok iya ngan palibri-ko.” ");
INSERT INTO abx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero sigi hamok mga iya panurakaw nga pinapako' si kudos si Jesus, ngan abawa iya si mga tinurakaw-na. ");
INSERT INTO abx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sanglit, akapinsar si Pilato pagtugot na hamok si mga karuyag-na. ");
INSERT INTO abx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Agpalibri-na si Pilato i a'a nagpapalibri-na mga iya nga mapriso tungod si saramok pati' pagmatay ngan agpa'intriga-na si Jesus basi' atuman i katuyu'an-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aniya' lalla taga sunsari'i si syudad Cirene nag'arunan Simon nga padulhog siray uras. Si pagbawa-na na si mga sundalo si Jesus si pammamatayan, satupu'-na mga iya si Simon ngan agpabalyu-na mga iya i kudos pagpapalangkit si iya si damurihan-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bali na labbat i magparapamurubungyod si iya, ngan aniya' mga danda magparapandinamag. ");
INSERT INTO abx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Anili' si mga iya si Jesus ngan aminugad, “Ka'am mga danday nan nga mga taga Jerusalem, dakam ako agparapanangisi-bi, lugod panangisi-bi i mga kalugaringun-bi pati' i mga kadadi'an-bi, ");
INSERT INTO abx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","kay titakka i uras nga agpaminugad kam, ‘Malipayon i mga danda nga ga'i pwidi agdadi' pati' ga'i nagsusuhan!’ ");
INSERT INTO abx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sinan uras malabbat makapinugad, ‘Mas mahalap kon akatimpagan kami' si mga kabubukiran, o ma'in ngani' akatambunan si mga katagudturan!’ ");
INSERT INTO abx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","I mga binuhatan-na si mga a'a si ako ina'anto, akapariho si pagpirit si mamata' kayo pagpatukon. Kon agda'ito sito mga iya ina'anto, iya pa ba' kon uga na i ga'i mga pinatukun-na.” ");
INSERT INTO abx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aniya' liwat duwangan kriminal nagbawa-na si mga sundalo nga paratukan kamatayon. ");
INSERT INTO abx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Si panakka-na mga iya si tagudtod nag'arunan Takuluk-na si Minatay, agpapaku'-na mga iya si Jesus. Nagpapako' liwat i mga kriminal si mga kudus-na, i addangan ari si kawanan-na ngan i addangan may ari si kawiri-na. ");
INSERT INTO abx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aminugad si Jesus, “Tatay-ko, pasayluhon mga iya kay ga'i agpakatu'anan si mga sabuhat-na.” Mangno, agpararti-na mga iya i mga sul'ut-na si Jesus pina'agi si ripa. ");
INSERT INTO abx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Agparapangulaw i mga a'a pero sigi dina panabri' i mga puno' si iya. Agparapaminugad mga iya, “Sasalbar-na lugod i la'in a'a. Pata'anan-ta kon sasalbar-na i kalugaringun-na, kon ungod nga iya i Tinu'inan Mannanalwas nagpabawa-na si Diyos, i Addangan Pinili'-na.” ");
INSERT INTO abx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pamadugok liwat i mga sundalo ngan nagparalangkagan iya. Ag'agda-na mga iya pagpaki'inom si malassom na bino ");
INSERT INTO abx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ngan agpaminugad, “Kon ungod nga ka'aw i hadi'-na si mga Hebro, salbaron kalugaringun-moy nan.” ");
INSERT INTO abx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aniya' makasurat ari si takulukan-na nga da'ito sito: I HADI'-NA SI MGA HEBRO ");
INSERT INTO abx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Addangan liwat si mga kriminal nga kahuruwangan-na nagpapako', agparatamay si pagpinugad, “Ma'in ba' ka'aw i Tinu'inan Mannanalwas? Salbaron kalugaringun-moy nan pati' kami'!” ");
INSERT INTO abx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero agsimul-na iya si huwang-na kriminal, “Gana' ba' katahap-mo si Diyos? Pariho may hamok i patuk-ta pati' si tawa'-na? ");
INSERT INTO abx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Si kita, tama' i sakarawat-ta para si sabuhat-ta. Pero yayto a'a gana' binuhatan-na mara'at.” ");
INSERT INTO abx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mangno aminugad iya, “Jesus, intumon may ako kon agtikang na i paghadi'-mo.” ");
INSERT INTO abx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Anaruman si Jesus si iya, “Sumatan-ta kaw si kamatu'uran, mismo ina'anto allaw aghuwang na kita ari si para'iso.” ");
INSERT INTO abx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ngan ka'amudtuhan, anlu'om i bug'os pitak palibot ari mga tallo uras, ");
INSERT INTO abx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","tungod kay aniya' maka'ulang si pagsirak-na si allaw. Mangno ari si templo, hintak agisi' si duwa parti i pannalingkop kurtina. ");
INSERT INTO abx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Amahalling makusog si Jesus, “Tatay-ko, agpatubyan-ko si ka'aw i espiritu-ko.” Si pakapinugad-na sinan, pahuway na dayon i paghingasung-na. ");
INSERT INTO abx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ngan pakakulaw-na si sari'i sinturyon si mahinabo', agdayaw iya si Diyos si pagpinugad, “Sigurado nga matadong to a'a.” ");
INSERT INTO abx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kundi' pakakulaw-na si kalabbatan mangngungusisa ari si kamatayun-na, pamalitiray to nga sigi pandugmok si mga darakan-na ngan sigi panagutsot. ");
INSERT INTO abx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero i dimu'an magpakakilala si iya agparapanunggo hamok si katalahan pagkulaw sito dimu'an huwang na i mga danda nga magparapamaya'-baya' tikang pa si Galilea. ");
INSERT INTO abx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aniya' matadong ngan bali kadaluman a'a nga nag'arunan Jose. Taga sunsari'i iya si Arimatea, Judea nga agparapanimulat si paghadi'-na si Diyos. Bisan kon myimbro iya si kunsiho, ga'i to angalagad si mga disisyun-na mga iya pati' si mga buhat-na. ");
INSERT INTO abx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sanglit padugok iya si Pilato pagpalako si bangkay-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Katapos, aghaw'as-na i bangkay ari si kudos ngan agputus-nay to si katsa. Mangno aghulid-na si adda kwiba panlalabbungan nga naghimo si pangpang ari, nga gana' pa gayod makalabbungan. ");
INSERT INTO abx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Siray allaw, Bispira na si Allaw Pandidiskanso ngan agtikalu'om na. ");
INSERT INTO abx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Agpamungyod si Jose i mga danda nga magpamaya' si Jesus tikang si Galilea ngan sakulawan-na mga iya kon pinapa'i paghulid si Jesus si kwiba panlalabbungan. ");
INSERT INTO abx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mangno agpamalik mga iya pag'andam si pasangngit pati' i mga la'in gamit pammabu'bo' si puhu'-na pero agdiskanso mga iya dahulo si Allaw Pandidiskanso sigon si kasugu'an. ");
INSERT INTO abx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kadumingguhan, nalung-nalong pa gayod i mga danda agpamada'iray si naglabbungan ngan agpamawa-na i nagpangandam-na pasangngit. ");
INSERT INTO abx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Si panakka-na mga iya ari, sa'usisahan-na mga iya nga nagpaligid na dina i bato, ");
INSERT INTO abx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pero si pasallud-na mga iya, ga'i na mga iya sa'anda'an-na ari i bangkay-na si Ginu'o Jesus. ");
INSERT INTO abx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Si pagpara'usa-na mga iya mahi'unong sito, hintak mga iya agpakakulaw duwangan lalla magtutunggo si mga kagiliran-na nga akapariho si kil'at i kadanta'-na si mga sutana-na. ");
INSERT INTO abx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tungod si kangarat-na si mga danda agpakaduko' mga iya, pero agpaminugad i mga lalla, “Ay kay ato kam si lugar-nay to si mga minatay agpara'anda' si addangan nga allom? ");
INSERT INTO abx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ga'i na iya ato; abanhaw iya! Ga'i na ba' sa'intuman-bi i nagsumat-na si ka'am ngan paghuruwang-bi ari si Galilea? ");
INSERT INTO abx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Agpinugad iya, ‘Papa'intrigahon i Pinili' A'a si pagdalum-na si mga makasasala'. Papapaku'on iya si kudos ngan si katallo allaw abanhaw iya.’” ");
INSERT INTO abx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sa'intuman-na dayon mga iya i mga pinahallingan-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Si pagpamalik-na na mga iya man kwiba, agdiritso mga iya si panniripunan-na si Unsi pati' si ditangnga' pa mga inadalan ngan agsumatan-nay to si dimu'an mahinabo' si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","I mga danda magpanumat sito si mga apostol, iya kas Maria Magdalena, Joana, Maria nga nanay-na si Santiago pati' i mga la'in pa mga kahuruwangan-na. ");
INSERT INTO abx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ga'i mga iya agpanutu'o si mga danda tungod kay para si mga iya day surusurumaton to hamok isturya. ");
INSERT INTO abx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bisan kon da'inan sinan, paduwa'i gihapon si Pedro ngan aglalahi pan kwiba. Si pangubu'-na, gana' la'in sakulawan-na kon ma'in na hamok i tampi' nagpaputos si Jesus. Mangno agbalik iya, nga agpara'usa-na kon ay kay da'iray i mahinabo'. ");
INSERT INTO abx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mismo siray allaw, aniya' duwangan si mga inadalan nga agbaktas pada'iray si bungto Emmaus. Mga unsi kilumitro i katalahan-na sito tikang si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sigi mga iya isturya mahi'unong si dimu'an mga mahinabo' pa hamok. ");
INSERT INTO abx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Si pagparabagaw-na mga iya, patapit si Jesus si mga iya ngan makibungyod aglalangngan, ");
INSERT INTO abx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","pero aniya' maka'ulang nga ga'i mga iya samayu'-mayu'an-na gayod. ");
INSERT INTO abx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Amatilaw to si mga iya, “Ay i nagparabagaw-bi si pagparalalangngan-bi?” Pahuway mga iya nga mga masurub'on. ");
INSERT INTO abx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Addangan si mga iya nga nag'arunan Cleopas i manaruman, “Ka'aw daw hamok siguro i addangan mamyista si Jerusalem nga ma'in sayod si mga mahinabo' ari si pa'agi ray mga allaw?” ");
INSERT INTO abx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Ay hinabu'a?” lingun-na may si Jesus. “I mahi'unong si Jesus nga taga Nasaret,” i saruman-na mga iya. “Paragsumat-na iya si Diyos, nga bali kagamhanan i mga allingun-na pati' i mga buhat-na si pangulawan-na si Diyos pati' si dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Agpa'intriga-na iya si mga puno' paraghalad pati' si mga punu'an-ta kam nga akapatukan kamatayon, ngan nagpapako' to si kudos. ");
INSERT INTO abx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tara' kay agla'om kami' nga iya i tilukat si mga a'a-na si Israel nga agpakalibri. Pwira pa liwat sinan, i katallo nayto allaw tikang si pakahinabu'-na ngan ");
INSERT INTO abx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","agpa'usa kami' si isturya-na si mga kahuruwangan kami' danda. Ina'an nalung-nalong pa, agpamada'iray mga iya si kwiba naglabbungan, ");
INSERT INTO abx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero ga'i mga iya sa'anda'an-na i puhu'-na. Agpamalik mga iya ngan agsumatan-na kami' nga agpakakulaw kuno' mga iya mga anghel magpaminugad nga abanhaw iya. ");
INSERT INTO abx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mangno aniya' si mga kahuruwangan kami' magpamada'iray ngan ari kinadiskubrihan nga ungod i nagsumat-na si mga danda hi'unong si kwiba, pero ga'i mga iya sakulawan-na ari si Jesus.” ");
INSERT INTO abx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aminugad si Jesus si mga iya, “Day gana' mga isip-bi, mga maluya pa kam gayod pagtutu'o si dimu'an mga pinahallingan-na si mga paragsumat-na si Diyos! ");
INSERT INTO abx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma'in ba' nga kinahanglan agsakit sito i Tinu'inan Mannanalwas ngan pina'agi sinan sa'angkun-na i maka'angayan pwistu-na?” ");
INSERT INTO abx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mangno ag'isplikaran-na mga iya si dimu'an magpaka'anna' si Kasuratan mahi'unong si iya, tikang gayod si Bala'ud-na si Moises hasta pa nga ag'agihan-na mga iya i kabug'usan-na si Nagpanurat-na si mga Paragsumat. ");
INSERT INTO abx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Si pagdadara'un-na na mga iya si papada'irayun-na bungto, a'abat si Jesus nga day ma'in pa iya tihuway. ");
INSERT INTO abx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sanglit maniguro gayod mga iya paghawid si pagpinugad, “Padiskansuha dahulo si kami' to kay kuhap na. Ma'in na pira i kasangumon.” Pahawid iya ngan agdayon si mga nag'istaran-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Si pagtararangka'-na na mga iya si pagkakanan, angaddo' si Jesus adda bug'os pan, agpasalamat iya si Diyos, ngan agturutabbi'-na. Mangno agparu'du'-nay to si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Siray uras ag'abrihan-na si Diyos i mga mata-na ngan agpakamayu'-mayo' nayto si iya. Diritso iya apara' si mga pangulawan-na ");
INSERT INTO abx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ngan aniya' si mga iya maminugad, “Sanglit may bali' day matapit andang i kasing-kasing-ta ngan akabalikan i pagla'um-ta si pagparabagaw-na si kita ina'an ari si lalan pati' si pagparapasabut-na si kita si Kasuratan.” ");
INSERT INTO abx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Patukal dayon mga iya ngan agbwilta pan Jerusalem. Ari mga iya satakka-na i Unsi pati' i ditangnga' pa mga inadalan nga agtiriripon. ");
INSERT INTO abx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yayto i tinakka-na mga iya allingon: “Ungod gayod nga abanhaw i Ginu'o. Agpakulaw iya si Simon.” ");
INSERT INTO abx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mangno agsumat may i duwangan si mga mahinabo' si mga iya ari si lalan, pati' kon pinapa'i mga iya sakilala-na si Jesus si pagturutabbi'-na si pan. ");
INSERT INTO abx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Si pagparabararagaw-na mga iya mahi'unong sito, hintak pakulaw si Jesus nga agtutunggo huwang si mga iya ngan aminugad, “Karawatu-bi i kamurayaw.” ");
INSERT INTO abx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nginarat mga iya ngan bali i mga kulba-na kay i mga pagkagasi-na nga kalag i mga sakulawan-na. ");
INSERT INTO abx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Agpaminugad-na mga iya, “Ay kay agkabururong kam pati' aniya' pa mga pagduda-bi? ");
INSERT INTO abx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kulawi-bi ngani' mga tamburu'-koy to pati' mga kitid-ko. Akoy to gayod! Kapkapu-bi ako ngan buslungu-bi pahalap. I kalag gana' isi-na pati' ta'ulang-na ma'in pariho si sakulawan-bi ina'anto si ako.” ");
INSERT INTO abx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pakapinugad-na sinan, agpakulaw-na si mga iya i mga tamburu'-na pati' i mga kitid-na. ");
INSERT INTO abx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Myintras ga'i pa mga iya agpanutu'o tungod kay agsalakot pa si mga kasing-kasing-na i kalipayan pati' i pag'usa, amatilaw pa iya, “Aniya' ba' ato nga pwidi akakan?” ");
INSERT INTO abx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Agparu'du'an-nay to mga iya pinarilya daying ");
INSERT INTO abx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ngan agkakan-na mismo atubang si mga iya. ");
INSERT INTO abx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aminugad to si mga iya, “Yayto i nagpinugad-ko si ka'am siray ngan paghururuwang-ta pa kam: Kinahanglan nga atuman i dimu'an maka'anna' si Kasuratan mahi'unong si ako nga kina'anda'an si Bala'ud-na si Moises, si Nagpanurat-na si mga Paragsumat, pati' si Mga Salmo.” ");
INSERT INTO abx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mangno, agpangabrihan-na si Jesus i mga inisipan-na basi' agpakasabot mga iya si Kasuratan ");
INSERT INTO abx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ngan aminugad, “Aka'anna' si Kasuratan nga papasakiton ngan maratayon i Tinu'inan Mannanalwas pero si katallo allaw abanhaw iya. ");
INSERT INTO abx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Katapos tirikangan ato si Jerusalem hasta nga anakka si dimu'an nasyon i pagpasamwak nga kinahanglan agbasol i a'a huwang si pagbag'o. Nagpasamwak liwat nga pwidi apasaylo i mga sala' pina'agi si arun-na. ");
INSERT INTO abx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ka'am i mga magpakatistigos sito dimu'an. ");
INSERT INTO abx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pabawa-ko si ka'am i nagsa'ad-na siray si Tatay-ko, sanglit ag'antahaka kam hamok ato si syudad hasta nga ga'i kam nag'ayupan si gahom man dyata'.” ");
INSERT INTO abx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pakapabungyud-na si mga iya pan gawas si syudad nga agdadara'on si baryo Betania, ag'alsa-na si Jesus i mga tamburu'-na ngan agbindisyunan-na mga iya. ");
INSERT INTO abx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Si pagparabindisyun-na, pa'amban to si mga iya ngan a'alsa iya pan langit. ");
INSERT INTO abx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mangno, agpanluhod i mga inadalan pag'ampo' si iya ngan katapos agpamwilta mga iya pan Jerusalem nga bali i mga kalipayan-na. ");
INSERT INTO abx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pirmi na hamok mga iya ari si templo pagdayaw si Diyos.");
INSERT INTO abx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antis si panikangan aniya' na Allingon, ngan yayto Allingon aghuwang si Diyos, ngan i Allingon, iya i Diyos. ");
INSERT INTO abx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aghuwang na iya si Diyos antis pa si panikangan. ");
INSERT INTO abx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ahimo i dimu'an pina'agi si iya, ngan kon ma'in iya i magbuhat, gana' mahimo si bisan ay. ");
INSERT INTO abx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Awinan si iya i ungod kinabuhi', ngan yaynan kinabuhi' i magdanta' si mga a'a. ");
INSERT INTO abx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Agsana'ag to danta' si kalu'uman, pero ga'i to sasabutan-na. ");
INSERT INTO abx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mangno abantog i naglihug-na si Diyos nag'arunan Juan. ");
INSERT INTO abx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naglihog iya bilang tistigos pagpamatu'od mahi'unong sito danta', basi' pina'agi si iya anutu'o kunta' i dimu'an. ");
INSERT INTO abx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma'in iya mismo i danta', pero pada'ito hamok iya pagpasayod hi'unong sito danta', ");
INSERT INTO abx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","kay ma'in na pira tisiga ato si kalibutan i ungod danta' nga agsana'ag si balang a'a. ");
INSERT INTO abx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Si kamatu'uran, mismo sinan panahon, ato na si kalibutan i Allingon pero ga'i iya nagkilala si mga a'a bisan kon naghimo mga iya pina'agi si iya. ");
INSERT INTO abx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pada'ito iya si mga sakup-na pero ga'i iya nag'ako'. ");
INSERT INTO abx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero aniya' may gihapon magtapod si arun-na, ngan para sito dimu'an nga ag'ako' si iya, agpumwan-na i katungod nga magin dadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ga'i mga iya aka'angkon sito kamutangan pina'agi si pribilihiyu-na si maghinganak si mga iya, o tungod si mga pag'ungara'-na, o ma'in ngani' tungod si mga pagpili'-na, kundi' ahimo mga iya dadi'-na tungod kay i Diyos mismo magbuwan si mga iya baha'o kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Agpakang'a'a i Allingon ngan makihuwang pag'istar si kita kam. Sakulawan-ta kam i maka'angayan kina'iya-na nga iya i ka'angayan-na si gana' kaparihu-na Dadi'. Linihug-na iya si Tata' pagpakatu'an si kabug'usan-na si mapinalangga'on pagpanginanu-na pati' si kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Agparapasayod si Juan mahi'unong si iya pina'agi si pagpinugad, “Yayto i nagparapinugad-ko siray nga i mabantog kahuman si ako, labaw dina kay dati na iya antis si paka'allum-ko.” ");
INSERT INTO abx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tungod si kabug'usan-na si mapinalangga'on pagpanginanu-na, bali pagsangyahan si kahalapan nga sunud-sunod sakarawat-ta kam dimu'an. ");
INSERT INTO abx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Agpumwan-na si Diyos i bala'od pina'agi si Moises, pero i mapinalangga'on pagpanginano pati' i kamatu'uran paguwa' pina'agi si Jesu-Kristo. ");
INSERT INTO abx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gana' pa gayod bisan say aha'a makakulaw si Diyos, pero aniya' magpakilala kon say iya, nga gana' la'in kon ma'in mismo i Diyos nga gana' kaparihu-na Dadi' nga awiray ina'anto si kagiliran-na si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aniya' nagpamabawa-na si mga punu'-na si mga Hebro ari si Jerusalem mga paraghalad pati' mga kabulig-na sito nga nagpangarunan Levita pagpatilaw si Juan kon say gayod iya. Yayto i kamatu'uran nagsumat-na si Juan. ");
INSERT INTO abx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ga'i iya agruha-duha pagsaruman, lugod diritso iya aminugad, “Ma'in ako i Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Agpaminugad to si iya, “Kon sugad, ka'aw si Elias.” Aminugad iya, “Ma'in.” Amatilaw gihapon mga iya, “Ka'aw na ba' i nagparapanimulat kami' paragsumat?” Anaruman may iya, “Ma'in.” ");
INSERT INTO abx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Si katapus-tapusan agpaminugad mga iya, “Say kaw gayod? Buwanin kami' saruman nga angay sapasumat kami' si magpanlihog si kami'. Ay i pagka'abat-mo mahi'unong si pagka'a'a-moy nan?” ");
INSERT INTO abx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Anaruman si Juan pina'agi si mga allingun-na siray si paragsumat Isaias, “Ako i magparapasamwak ari si disyirto, ‘Tadungu-bi i aragihan-na si Paragdalom.’” ");
INSERT INTO abx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Mangno amatilaw si iya i nagpamabawa Parisiyo, “Kapa'i may kay agparabunyag kaw kon ma'in ka'aw i Tinu'inan Mannanalwas, o ma'in ka'aw si Elias, o ma'in ka'aw i nagparapanimulat kami' paragsumat?” ");
INSERT INTO abx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Anaruman si Juan, “Parti si buwahi' i pagbunyag-ko pero aniya' huwang ato nga ga'i sakilala-bi. ");
INSERT INTO abx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iya i tisunod si ako. Ma'in ngani' ako angay bisan pagbak'ad si sintas-na si sapatus-na.” ");
INSERT INTO abx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ahinabo' nan dimu'an ari si baryo Betania nga banda sirangan si Suba' Jordan kon singnga agparabunyag si Juan. ");
INSERT INTO abx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ka'asumuhan, sakulawan-na si Juan nga tidugok si iya si Jesus, ngan aminugad iya, “Kulawi-bi, awira' i Nati Karniru-na si Diyos nga tipara' si sala' ato si kalibutan! ");
INSERT INTO abx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iya i nagtukuy-ko si pagpinugad, ‘I a'a nga mabantog kahuman si ako, labaw dina kay dati na iya antis si paka'allum-ko.’ ");
INSERT INTO abx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngan pagtu'in si ako pagbunyag parti si buwahi', mismo ngani' ako ga'i pa liwat angilala kon say iya, pero nagtu'inan ako sito basi' akakilala si iya i mga a'a-na si Israel.” ");
INSERT INTO abx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Agpadayon si Juan pagpamatu'od hi'unong si mahinabo' si pa'agi ray pa hamok mga allaw, “Sakulawan-ko i Espirito man langit nga pa'ayop si iya pariho si adda sarampati. ");
INSERT INTO abx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ga'i kunta' ako angilala si iya kon ga'i agpinugad i maglihog si ako pagbunyag, ‘I a'a kon singnga sakulawan-mo i Espirito pan hawod ngan pa'ayop, burunyagan-na i mga a'a pagpa'ayop si Espirito Santo.’ ");
INSERT INTO abx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sakulawan-koy nan gayod ngan akatistigos ako nga yaynan i Dadi'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka'asumuhan, pabwilta gihapon ari si Juan ngan aniya' duwangan si mga inadalan-na huwang si iya. ");
INSERT INTO abx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pakakulaw-na nga palabay si Jesus, aminugad iya, “Kulawi-bi, iyay ray i Nati Karniru-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pakabati'-na si iya si duwangan inadalan, agpanlanat mga iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Panili'-na si Jesus, sakulawan-na mga iya, mangno amatilaw, “Ay i tuyu'-bi?” Pagpakulaw si karuyag-na mga iya nga magin ma'istru-nay to, agtahuran-nay to mga iya si Hebruhanon allingon, “Rabbi, pabaya'on daw kami' pada'iray si pandidiskansuhan-mo.” ");
INSERT INTO abx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Anaruman may si Jesus, “Hala, tana kam basi' aniya' sakatu'anan-bi.” Sanglit amaya' mga iya pagkulaw si pandidiskansuhan-na. Siray uras, mga alas kwatro na si kakuhapon ngan ari mga iya hasta pa si ka'asumuhan kuhap. ");
INSERT INTO abx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si duwangan nan nga makapamati' si mga allingun-na si Juan ngan magpamaya' si Jesus, addangan si mga iya si Andres, nga sirari-na si Simon Pedro. ");
INSERT INTO abx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Si pagbalik-na mga iya, gana' la'in isip-na si Andres kon ma'in i pag'anda' dayon si Simon ngan agpakatu'an-na, “Sabagatan kami' na i Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mangno agtulihan-na si Simon pada'iray si Jesus. Pakakulaw-na si Jesus si iya, agpinugad-na iya, “Ka'aw si Simon, i dadi'-na si Juan. Ararunan kaw Cefas.” Si linggwahi-na kas Jesus, iyay nan i makapariho si sagara'an-bi na aron, Pedro. ");
INSERT INTO abx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ka'asumuhan, akahuna'-huna' si Jesus pagpada'iray si Galilea. Pakabagat-na si Felipe, agpinugad-nay to, “Amaya'a si ako.” ");
INSERT INTO abx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe taga Betsaida nga iya liwat i nag'istaran-na syudad si kas Andres pati' Pedro. ");
INSERT INTO abx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pakabagat-na si Felipe si Nataniel, agpinugad-nay to, “Sabagatan kami' na i nagtukoy si Bala'ud-na si Moises nga nagtukoy liwat si Nagpanurat-na si mga Paragsumat. Iya si Jesus taga Nasaret nga dadi'-na si Jose.” ");
INSERT INTO abx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aminugad si Nataniel, “Ay? Taga Nasaret? Sigurado nga gana' sahimu-na kahalapan para si mga a'a si addangan nga taga sunsari'i.” Aminugad may si Felipe, “Tuwa, amaya'a basi' aniya' sakatu'anan-mo.” ");
INSERT INTO abx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pakakulaw-na si Jesus nga padugok si Nataniel, aminugad iya, “Atiya' i tangkod a'a-na si Israel, nga ga'i ata'o pagdaya'.” ");
INSERT INTO abx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Pinapa'i ako sakilala-mo?” lingun-na si Nataniel. Anaruman si Jesus, “Sakatu'anan-ta na kaw andang bisan ngan ari pa kaw si landung-na si igos myintras kaw agban'u-na si Felipe.” ");
INSERT INTO abx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tungod sinan, akahintakan si Nataniel ngan diritso akapinugad, “Rabbi, ka'aw i Dadi'-na si Diyos, ka'aw i Hadi'-na si Israel.” ");
INSERT INTO abx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aminugad si Jesus, “Anutu'o kaw hamok tungod kay agsumatan-ta kaw nga sakatu'anan-ta na kaw bisan ngan ari pa kaw si landung-na si igos. Aniya' pa mga tihinabo' nga anmas pa sito ka'urusahon.” ");
INSERT INTO abx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mangno agpadayon iya pagsumat si mga iya, “Sumatan-ta kam si kamatu'uran, titakka i panahon nga sakatu'anan-bi dimu'an kon ay i maka'angayan kamutangan-na si Pinili' A'a nga bisan i mga anghel-na si Diyos amanahik paduwa'i si langit pagsirbi si iya.” ");
INSERT INTO abx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kasa'addallawan, aniya' kumbiti si nagkasal ari si Cana, adda baryo si prubinsya Galilea. Agparabulig-bulig ari i nanay-na si Jesus, ");
INSERT INTO abx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ngan ari liwat si Jesus kay imbitado iya huwang i mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngan atibos na i bino agpinugad-na iya si nanay-na, “Gana' na mga binu-na.” ");
INSERT INTO abx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Anaruman may si Jesus, “Nay, pata'anin hamok ako. Ma'in payto i tama' uras pagpakulaw si gahum-ko.” ");
INSERT INTO abx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Agtugunan-na si nanay-na i mga sirbinti, “Sunuru-bi bisan ay i panlihugan-na si ka'am.” ");
INSERT INTO abx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aniya' ari annom tadyaw pangngingisihan buwahi' para si kinahanglanon nga anlimpyo i mga Hebro si pangulawan-na si Diyos. Yayto mga tadyaw hinimo tikang si bato ngan ka'isihan to mga baynti pada'iray si traynta galon balang adda. ");
INSERT INTO abx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aminugad si Jesus si mga sirbinti, “Isihi-bi buwahi' i mga tadyaw.” Sanglit agpangisihan-nay to mga iya hasta nga agpansapwa. ");
INSERT INTO abx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mangno aminugad si Jesus si mga iya, “Anabu'a kam ngan bawahu-bi pada'iray si tinapuran sito kumbiti.” Sanglit anabo' mga iya ngan agbawa-na pada'iray si tinapuran si kumbiti. ");
INSERT INTO abx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Animtim to si buwahi' nga mahimo bino. Ga'i iya akatu'anan kon singngay nan tikang, pero akatu'anan i mga sirbinti magtabo' si buwahi'. Mangno agban'u-na si tinapuran i kinasal lalla ");
INSERT INTO abx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ngan agpinugad-na, “Kabatasanan si magpakumbiti pagpa'inom dahulo si gimahalapi bino ngan kon mga baring na i mga imbitado, iya na dina i pagpa'inom si bino nga minos i kantidad-na. Pero agpadamuri-mo lugod dina i gimahalapi bino.” ");
INSERT INTO abx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Si da'inan pa'agi aghimu-na si Jesus i primiro si mga pangngilalahan si langitnon kasiguruhan pagpamatu'od kon say iya. Ahinabo' nan ari si Cana, Galilea. Ari sapakulaw-na si Jesus i ka'angayan-na, sanglit agsasarig i pagtu'u-na si iya si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kahuman sinan, padalugdog iya pan syudad Capernaum huwang i nanay-na, i mga bugtu'-na pati' i mga inadalan-na ngan ari mga iya tubtob si pira allaw. ");
INSERT INTO abx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ngan titakka na i Pyista si Paglabay, pasagka si Jesus pan Jerusalem. ");
INSERT INTO abx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sata'upan-na ari si hawan-na si templo i magparapamaligya' mga papahalaron baka, karniro, pati' sarampati. Ari liwat i magparapanukli' si pala'in-la'in klasi kwarta nga agpaningkulo' si mga lamisa-na. ");
INSERT INTO abx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sanglit aghimo si Jesus panlalapnit tikang si pisi' ngan sigi iya pantabrog si dimu'an karniro pati' baka pagawas si ridur-na si templo ngan sigi-na liwat pamabaliskad i mga lamisa-na si magparapamabalyo si pala'in-la'in kwarta hasta nga agpanwararak i mga sinsilyo. ");
INSERT INTO abx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dungan sinan, sigi liwat iya pangisog si magparapamaligya' sarampati, “Gawasi-bi nan! Ay kay aghimu-bi mirkado i ruma'-na si Tatay-ko?” ");
INSERT INTO abx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mangno sa'intuman-na dayon si mga inadalan-na i maka'anna' si Kasuratan: “Day mabuka i kasing-kasing-ko tungod si kadisididu-ko pagpanginano si ruma'-mo, Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pero i mga punu'-na si mga Hebro pamadugok si Jesus ngan agpamatilaw dina, “Ay pangngilalahana si langitnon kasiguruhan i sahimu-mo si kami' pagpamatu'od nga aglihug-na kaw si Diyos pagbuhat sito dimu'an?” ");
INSERT INTO abx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Anaruman si Jesus, “Bungkagu-bi to templo ngan ako mismo i manindog sito gihapon sallod hamok si tallo allaw.” ");
INSERT INTO abx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pero agminus-na dina iya si mga punu'-na si mga Hebro, “Kwarintay sa'is ta'on i katitindog sito templo, katapos aminugad kaw nga tindug-moy to sallod hamok si tallo allaw?” ");
INSERT INTO abx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero i templo nga nagtukuy-na si Jesus, mismo i puhu'-na. ");
INSERT INTO abx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kahuman si kabanhaw-na, aka'intom i mga inadalan-na si nagpahalling-nay to, ngan siray uras agtamba i mga pagtu'u-na si Kasuratan pati' si mga pinahallingan-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ngan kari'i-na na si Jesus si Jerusalem si Pyista si Paglabay, kalabbatan i magpakakulaw si mga nagparahimu-na pangngilalahan si langitnon kasiguruhan, sanglit agpanutu'oy to si iya. ");
INSERT INTO abx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kundi' ga'i dayon pabawa si Jesus pagtapod sito mga a'a kay sayod iya si kina'iya-na si dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ma'in na ministir nga nagsumatan pa iya hi'unong si a'a kay andang na iya sayod si bisan ay parti si a'a. ");
INSERT INTO abx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aniya' ari addangan nag'arunan Nicodemos nga myimbro si Kunsihu-na si mga Hebro. Sakop to iya si grupu-na si mga Parisiyo. ");
INSERT INTO abx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Adda sinan sangom, anungbalay iya si Jesus ngan agpakulaw iya si pag'aku'-na nga magin ma'istru-nay to si Hebruhanon allingon, “Rabbi, katu'anan kami' nga nagpabawa-na kaw si Diyos paragturo' tungod kay gana' makahimo si mga pangngilalahan si langitnon kasiguruhan nagparapamuhat-mo kon ga'i aghuwangan-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aminugad may si Jesus, “Sumatan-ta kaw si kamatu'uran, ga'i pwidi akatu'anan i a'a si paghadi'-na si Diyos hasta nga ga'i iya a'allom si kaduwa bisis.” ");
INSERT INTO abx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aminugad may si Nicodemos, “Pero pinapa'i i a'a a'allom si kaduwa bisis? Sigurado nga ga'i na iya akasallod si battung-na si nanay-na para naghinganak utro!” ");
INSERT INTO abx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Anaruman si Jesus, “Sumatan-ta kaw si kamatu'uran, ga'i pwidi i a'a akasakop si nagpanhadi'an-na si Diyos hasta nga ga'i iya a'allom pina'agi si buwahi' pati' pina'agi si Espirito. ");
INSERT INTO abx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","I puho' ahimo pina'agi si mga mahanak ngan tikang si kada'an kina'iya paguwa' i kalibutanon buhat, pero a'allom i espiritu-na si a'a pina'agi si Espirito ngan tikang si iya paguwa' i espirituhanon pangiwa-kiwa. ");
INSERT INTO abx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kunta' ga'i kaw ag'usa si pagpinugad-ko, ‘Kinahanglan kam a'allom si kaduwa bisis.’ ");
INSERT INTO abx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ga'i sapugungan-ta i bariyo kon singnga pa'arop. Sabati'an-ta i tandu-na, pero ga'i kita akatu'anan kon singngay to tikang o kon singnga sito i arup-na. Da'ito sito i kamutangan-na si kada addangan nga a'allom pina'agi si Espirito.” ");
INSERT INTO abx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Amatilaw si Nicodemos, “Pinapa'i nan ahinabo'?” ");
INSERT INTO abx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Anaruman may si Jesus, “Adda kaw paragturo' si mga a'a-na si Israel pero ay kay ga'i kaw anabot sinan? ");
INSERT INTO abx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sumatan-ta kaw si kamatu'uran, agpahalling kami' si mga sakatu'anan kami' ngan agtistigos kami' parti si mga sakulawan kami', pero ka'am nga mga puno', ga'i pa kam gihapon anutu'o si mga allingon kami'. ");
INSERT INTO abx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Agsumatan-ta kaw si mga mahinabo' ato si kalibutan pero ga'i kaw anutu'o; ay pa may i panutu'u-mo kon sumatan-ta kaw si mga mahinabo' ari si langit? ");
INSERT INTO abx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gana' pa makapada'iray si langit pwira si addangan nga tikang si langit nga gana' la'in kon ma'in i Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pariho si pangalsa-na si Moises si burunsi sawa nagpapaku'-na si dyata'-na si pusti ari si disyirto, aralsahon may liwat i Pinili' A'a ");
INSERT INTO abx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","basi' i dimu'an magpanutu'o, aka'angkon si kinabuhi' nga gana' katapusan-na huwang si iya. ");
INSERT INTO abx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tungod si subra gugma'-na si Diyos si mga a'a, agpabawa-na i gana' makapariho Dadi'-na basi' bisan say nga agtapod si iya ga'i amatay nga bulag si Diyos kundi' aka'angkon dina si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay i tuyu'-na si Diyos pagpabawa si Dadi'-na pada'ito si kalibutan ma'in pagpatok si mga a'a kundi' basi' pina'agi si iya atalwas mga iya. ");
INSERT INTO abx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bisan say i magtapod si iya ga'i nagpatukan, pero bisan say nga ga'i agtapod, andang na iya nagpatukan tungod si ga'i pagtapud-na si arun-na si gana' makapariho Dadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yayto i nagbasaran-na si Diyos paghusgar: I danta' pada'ito si kalibutan, pero aruyag dina i mga a'a si kalu'uman kuntra si kadanta'an tungod kay i mga sagara'an-na i karat'an dina. ");
INSERT INTO abx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bisan say nga agbuhat si karat'an anguntra si danta' ngan ga'i iya aruyag pada'iray si kadanta'an tungod si katalaw-na nga kinatu'anan i mga nagbuhat-na. ");
INSERT INTO abx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kundi' bisan say nga ag'alagad si kamatu'uran, ga'i agruha-duha pada'iray si kadanta'an basi' kinakulawan nga i dimu'an buhat-na ahimo huwang si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kahuman sinan, pamadalugdog kas Jesus pati' i mga inadalan-na pada'iray si kapatagan parti si Judea, kon singnga aniya' uras-na mga iya pagsikirilalahay pahalap, ngan ari siray lugar aniya' magpakabunyagan. ");
INSERT INTO abx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si pariho uras, sigi may bunyag si Juan ari si bulwang nag'arunan Enon, nga matapit si baryo Salim, tungod kay malabbat buwahi' ari. ");
INSERT INTO abx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ahinabo' nan myintras si kaprisu-na si Juan. ");
INSERT INTO abx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sigi pasusuway i ditangnga' si mga inadalan-na si Juan kuntra si addangan Hebro mahi'unong si pagtuman si kinahanglanon nga anlimpyo i a'a si pangulawan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pamada'iray mga iya si Juan ngan agpaminugad, “Rabbi, sa'intuman-mo ba' i a'a nga pahuwang si ka'aw ngan ari si dambila'-na si Suba' Jordan, i addangan nga nagparasumat-mo? Sigi liwat iya bunyag ngan i kalabbatan awiray dina padugok si iya.” ");
INSERT INTO abx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Anaruman si Juan, “I a'a akakarawat hamok kon ay i nagpumwan-na si iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ka'am mismo i makatistigos nga agpinugad ako, ‘Ma'in ako i Tinu'inan Mannanalwas lugod nagpabawa ako pagdahulo si iya.’ ");
INSERT INTO abx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pariho si kamutangan-na si kinasal, i kinasal danda para hamok si kakasal-na. I abay-na si lalla, ga'i a'uyam pag'antahak sito bisan sumiran to anakka. Lugod, bali iya kalipayan kon sapamati'an-na na i busis-na si kinasal. Akapariho sinan i kalipayan-ko ngan atuman to gayod ina'anto. ");
INSERT INTO abx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sigi hahaya i ka'impurtantihan-na ngan ako may, sigi didiki'. ");
INSERT INTO abx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“I addangan man dyata' labaw si dimu'an, pero i addangan nga tikang si kalibutan, natural hamok iya a'a nga akasumat hamok kon ay i mga sakatu'anan-na ato si kalibutan. I addangan man langit labaw gayod si dimu'an ngan ");
INSERT INTO abx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","agpamatu'od iya si mga sakulawan-na ari pati' si mga sapamati'an-na. Pero bihira i manutu'o si mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Para si addangan ray nga anutu'o, agpamatu'od iya nga ungod atuman i mga nagpakatu'an-na si iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay i addangan nga nagpabawa-na si Diyos, agpahalling hamok si mga allingun-na si Diyos ngan gana' nga ga'i pwidi sahimu-na si Espirito nagpa'ayup-na si Diyos si iya. ");
INSERT INTO abx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aghigugma'-na si Tata' i Dadi' ngan agpatu'in-na i dimu'an si iya. ");
INSERT INTO abx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bisan say i manutu'o si Dadi' aka'angkon si kinabuhi' hasta si kahastahan, pero bisan say nga andiri' si Dadi' ga'i aka'angkon sinan, kay i kastigu-na si Diyos agpadayon anan si iya.” ");
INSERT INTO abx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Akatu'anan i mga Parisiyo nga mas malabbat sapabungyud-na pati' sabunyagan-na mga inadalan si Jesus kuntra si Juan, ");
INSERT INTO abx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","bisan kon si kamatu'uran ma'in mismo si Jesus i magbunyag kundi' i mga inadalan-na dina. ");
INSERT INTO abx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Si pakakatu'an-na si Ginu'o nga nagparamasiran na iya si mga Parisiyo, pa'amban iya si Judea ngan pabwilta gihapon pan Galilea. ");
INSERT INTO abx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kinahanglan iya ag'agi ari si Samaria sanglit ");
INSERT INTO abx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","si pagparabaktas-na, anakka iya si Sicar nga adda bungto ari. Matapit to si pitak nagpumwan-na si Jacob si dadi'-na nag'arunan Jose. ");
INSERT INTO abx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ari siray lugar aniya' bali lalom buhon nga nagpa'ukad-na pa si Jacob. Tika'amudto na siray uras ngan tungod si kabudlayan-na si Jesus, aningkulo' iya matapit si buhon. ");
INSERT INTO abx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kata'ud-ta'uran, aniya' Samaritana manarok ari. Mangno agpinugad-nay to si Jesus, “Pa'inumon daw ako.” ");
INSERT INTO abx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Siray uras, agpamalli na dina karakanon si bungto i mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aminugad may i danda si iya, “Ay kay si ako kaw agpalako buwahi'? Adda kaw Hebro ngan ako may adda dina Samaritana.” Agda'inan iya sinan kay ga'i gayod agka'uyon i mga Hebro pati' i mga Samaritano. ");
INSERT INTO abx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Anaruman may si Jesus, “Kon katu'anan kaw hamok kunta' si nagparu'du'-na si Diyos rigalo ngan kon say magpalakoy to si ka'aw buwahi', sigurado ka'aw kunta' dina i mamalako si iya ngan i allom buwahi' i pinumwan-na si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lingun-na may si danda, “Sinyor, gana' ngani' nagbawa-mo pannanarok ngan bali to lalom buhon. Singnga may kaw angala' si nagpinugad-mo allom buwahi'? ");
INSERT INTO abx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mas gamhanan ba' kaw si ginikanan kami' Jacob nga magbuwan si kami' sito buhon? Ag'inom iya sito buhon ngan da'inan may i mga dadi'-na. Tikang liwat sito buhon i buwahi' nagpasurop si mga hayup-na.” ");
INSERT INTO abx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Anaruman si Jesus, “Bisan say i manginom sito buwahi', nag'uhaw gihapon. ");
INSERT INTO abx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero bisan say i maka'inom si purumwanun-ko buwahi' ga'i na iya nag'uhaw hasta si kahastahan. Lugod, i nagpumwan-ko si iya buwahi', ahimo burabod anan si kalugaringun-na nga agbubulwang pagbuwan kinabuhi' nga gana' katapusan-na.” ");
INSERT INTO abx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Agpinugad-na iya si danda, “Sinyor, buwanin ako sinan buwahi' basi' ga'i na ako nag'uhaw ngan ga'i na ako agparaburubwilta pada'ito pagsarok.” ");
INSERT INTO abx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Agpinugad-na si Jesus i danda, “Hala, balika dahulo ari, ala'on i alla-mo, ngan bwiltaha.” ");
INSERT INTO abx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Anaruman may to, “Gana' may alla-ko.” Lingun-na may si Jesus, “Ungod nan, kay ");
INSERT INTO abx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","si kamatu'uran, limangan na i sapakasalan-mo pero i katig'ub-mo ina'anto ma'in kakasal-mo. Sanglit ungod gayod i allingun-mo.” ");
INSERT INTO abx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aminugad i danda, “Sinyor, sa'abat-ko nga paragsumat-na kaw si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I mga ginikanan kami' agparapangampo' ato sito bukid, pero ka'am mga Hebro sigi paminugad nga kinahanglan kami' ag'ampo' ari si Jerusalem kay iya i tama' lugar.” ");
INSERT INTO abx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Amahalling si Jesus, “Mana, anutu'uha si ako nga titakka i uras nga ga'i ampu'an-bi i Tata' ato sito bukid o ma'in ngani' ari si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ka'am mga Samaritano agparapangampo' si ga'i sakilala-bi pahalap, pero kami' angilala gayod kon say i nagpara'ampu'an kami' kay i katalwasan agtikang si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero bisan pa, titakka na i uras ngan kon sayod kaw si kamatu'uran, ina'anto na i uras nga i ungod mangngangampo' si Tata' kinahanglan agpangampo' sigon si kamatu'uran ngan pina'agi si pag'ayup-na si Espirito. Mga iya i klasi si mangngangampo' nga nag'anda'-na si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Adda Espirito i Diyos, ngan i mangngangampu'-na kinahanglan agpangampo' sigon si kamatu'uran ngan pina'agi si Espirito.” ");
INSERT INTO abx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aminugad i danda, “Akatu'anan ako nga tipada'ito i Tinu'inan Mannanalwas ngan si panakka-na, iya i mangisplikar si kita kam si dimu'an.” ");
INSERT INTO abx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mangno amahalling si Jesus, “Ako naynan nagpinugad-moy nan. Ako nga magbagaw to si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mismo sinan uras, anakka i mga inadalan-na ngan mahaya i pagpangusa-na si pakakulaw-na mga iya nga makibagaw iya si adda danda. Pero gana' ni addangan si mga iya mamuso' pagpatilaw, “Ay i nagkinahanglan-mo?” o ma'in ngani', “Ay kay makibagaw kaw si iya?” ");
INSERT INTO abx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mangno pa'amban i danda nga bilin i pansasaruk-na. Agbwilta iya pan bungto ngan agpaminugad-na i mga a'a, ");
INSERT INTO abx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Amaya'a kam si ako basi' sakulawan-bi i a'a nga akatu'anan si dimu'an kina'agi-agi-ko. Siguro iya nayto i Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sanglit pamagawas si bungto i mga a'a ngan agpamalangngan pada'iray si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Siray mismo uras, nagpara'aguy-agoy to si mga inadalan-na, “Rabbi, amangana dahulo.” ");
INSERT INTO abx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero agpinugad-na dina mga iya, “Aniya' karakanun-ko nga ga'i sakatu'anan-bi.” ");
INSERT INTO abx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Agsipurupatilaway dayon i mga inadalan-na, “Say daw i magtuli si iya ato pagkakan?” ");
INSERT INTO abx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aminugad si Jesus, “I pagtuman si katuyu'an-na si magpapada'ito si ako hasta nga atapos i nagpumwan-na trabaho, iya i makapariho si kinakan nga akapabagtok si ako. ");
INSERT INTO abx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma'in ba' aniya' parahallingon, ‘Ampat bulan na hamok, tig'ani na’? Sumatan-ta kam, angulawa kam ngan pantawu-bi i kamamalli'an! Mga matahak na ngan angay nag'ani. ");
INSERT INTO abx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bisan ina'anto, sakarawat-na na si mag'ani i bayad si kabudlayan-na ngan ina'anto dayon satipun-na i mga inani-na basi' agpaka'angkon to si kinabuhi' nga gana' katapusan-na. Tungod sinan, i magsaburak pati' i mag'ani, akakarawat mga iya duwangan si kalipayan. ");
INSERT INTO abx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sanglit kamatu'uran gayod i parahallingon, ‘Agpasaburak-na si addangan ngan ag'ani-na may si la'in.’ ");
INSERT INTO abx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Patanumu-bi si isip-bi nga agpanlihug-ko kam pag'ani si ga'i nagbudlayan-bi. Tawa'-na si ditangnga' i mabuwat trabaho ngan ka'am dina i makaprubitso si kahalapan-na si mga binudlayan-na.” ");
INSERT INTO abx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Malabbat si mga Samaritano mag'istar sinan bungto i manutu'o si Jesus tungod si mga pinahallingan-na si danda, “Sakatu'anan-na i dimu'an kina'agi-agi-ko.” ");
INSERT INTO abx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sanglit ngan panakka-na si mga Samaritano ari si iya, naghawiran iya pagdiskanso dahulo si mga lugar-na, ngan duwa allaw i pahuway-na ari si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bali labbat i makatamba pa si magpanutu'o si iya, tungod si mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Agpinugad-na si mga a'a i danda, “I pagtutu'o kami' ma'in na tungod si mga nagsumat-mo, pero tungod kay sabati'an kami' na mismo si mga kalugaringon kami' ngan sasayuran kami' nga yayto gayod a'a i Paragsalbar-na si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kahuman si duwa allaw pataliwan si Jesus pan Galilea. ");
INSERT INTO abx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Dati na iya agpinugad nga i paragsumat-na si Diyos ga'i nagdayaw si kalugaringun-na lugar. ");
INSERT INTO abx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Panakka-na ari si Galilea, nagpanginano hamok iya si mga taga sunsari'i tungod kay agpakakulaw to si dimu'an nagbuhat-na si Jesus si kari'i-na mga iya si Jerusalem ngan Pyista si Paglabay. ");
INSERT INTO abx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Amisita gihapon si Jesus ari si baryo Cana kon singnga aghimu-na siray bino i buwahi'. Aniya' addangan tinapuran-na si hadi' ari si syudad Capernaum nga maburong i dadi'-na. ");
INSERT INTO abx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pakakatu'an-na sito nga anakka si Jesus ari si Galilea tikang si Judea, makibagat iya pagpakimalu'oy nga pada'iray-na ngan pahalap-na si Jesus i dadi'-na nga mammatayon na. ");
INSERT INTO abx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Agpinugad-na iya si Jesus, “Hasta nga ga'i kam mga a'ay nan akakulaw mga pangngilalahan si langitnon kasiguruhan pati' mga urusahon, ga'i kam agpanutu'o.” ");
INSERT INTO abx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aminugad i tinapuran-na si hadi', “Sinyor, amaya'a si ako padalugdog myintras amatay i dadi'-ko.” ");
INSERT INTO abx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Anaruman may si Jesus, “Balika na ari kay mahalap na i dadi'-mo.” Agtapod i lalla si allingun-na si Jesus, sanglit pa'amban. ");
INSERT INTO abx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngan ari pa iya si lalan, agtupu'-na iya si mga rilihugun-na ngan nagsumatan iya nga mahalap na i dadi'-na. ");
INSERT INTO abx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Agpatilaw iya kon ay urasa i panhalap-na si dadi'. Nagsarumanan may iya, “Da'illaw ngan mga ala una si kakuhapon.” ");
INSERT INTO abx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mangno akahuna'-huna' i tatay nga da'inan gayod sinan ka'urason ngan pagpinugad-na si iya si Jesus, “Mahalap na i dadi'-mo.” Sanglit anutu'o na gayod iya hasta pa i bug'os pamilya-na. ");
INSERT INTO abx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iyay nan i kaduwa bisis nga aghimo si Jesus pangngilalahan si langitnon kasiguruhan ari si Galilea nga human pa hamok man Judea. ");
INSERT INTO abx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kahuman sinan, pasagka si Jesus pan Jerusalem pag'atindir si adda pyista-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Adda si pansasalluran si kuta' si Jerusalem i nag'arunan Pwirtahan-na si Karniro ngan matapit ari aniya' pammandihan nga day libtong. Betesda sito i pag'aron si Hebruhanon. Nagpalibutan to si lima panninirungan nga waswas hamok. ");
INSERT INTO abx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Malabbat pirmi ato mga a'a magparapanlibbak nga aniya' mga pangundi'an-na pariho si mga buta, mga lulid, pati' mga irapa. ");
INSERT INTO abx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Addangan ari si mga iya nga trayntay utso anyos na i pag'antus-na si pangundi'an-na. ");
INSERT INTO abx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pakakulaw-na si Jesus si iya nga aglibbak ari pati' pakakatu'an-na nga da'inan i kamutangan-na sito a'a si maliyat na panahon, agtilaw-nay to, “Aruyag ba' kaw anhalap?” ");
INSERT INTO abx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aminugad may i aniya' pangundi'an-na, “Sinyor, gana' may si ako mamulig pagpatugsob kon hintak angalimbukad i buwahi'. Kon ag'itutugsob ako, aniya' pirmi makadahulu'an si ako.” ");
INSERT INTO abx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mangno agpinugad-na iya si Jesus, “Anungguha! Addu'on naglibbakan-moy nan ngan palangngana.” ");
INSERT INTO abx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hintak dayon anhalap i lalla; addu'-na i naglibbakan-na ngan palangngan. Ahinabo' nan si Allaw Pandidiskanso, ");
INSERT INTO abx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","sanglit ngan aniya' makatupo' si iya si mga punu'-na si mga Hebro diritso iya nagsimol, “Allaw Pandidiskanso ina'anto; nagdiri' si bala'od nga agbawa kaw si panlibbakan-moy nan.” ");
INSERT INTO abx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero anaruman dina iya, “I a'a magpahalap si ako, iya i magmando' si ako, ‘Addu'on naglibbakan-moy nan ngan palangngana.’” ");
INSERT INTO abx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sanglit agpaminugad may mga iya, “Say aha'a i magmando' sinan si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","I a'a nga manhalap ga'i akasumat kon say ray aha'a, kay pakawara' na dina si Jesus si magpantambong ari. ");
INSERT INTO abx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kata'ud-ta'uran, sa'anda'an-na nayto dina si Jesus ari si templo ngan agpinugad-na, “Tara', di' mahalap na kaw gayod. Dakaw na palagtok pa si sala' basi' akalikay kaw si mas grabi pa kamutangan.” ");
INSERT INTO abx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pa'amban i lalla ngan agsumatan-na i mga punu'-na si mga Hebro nga si Jesus bali' i magpahalap si iya. ");
INSERT INTO abx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tungod kay agparabuhat sinan si Jesus bisan si Allaw Pandidiskanso, nagpakurihan iya si mga punu'-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Agsumat si Jesus si mga iya, “Ga'i agpata'an i Tatay-ko si trabahu-na tikang pa siray hasta ina'anto, sanglit sigi may liwat hamok ako trabaho.” ");
INSERT INTO abx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tungod sinan, maniguro gayod i mga punu'-na si mga Hebro pag'imamatay si iya ma'in hamok tungod kay agtalapas iya si Allaw Pandidiskanso kundi' tungod kay agpapantay-na si Diyos i kalugaringun-na si pagpinugad nga kalugaringun-na Tatay i Diyos. ");
INSERT INTO abx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sanglit aminugad si Jesus si mga iya, “Sumatan-ta kam si kamatu'uran, gana' sahimu-na si Dadi' pina'agi si kalugaringun-na. Akahimo hamok iya kon ay i sakulawan-na nagbuhat-na si Tata', tungod kay bisan ay nagbuhat-na si Tata', buhat-na may liwat si Dadi'. ");
INSERT INTO abx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Agda'inan sinan i Dadi' kay aghigugma'-na iya si Tata' ngan pakulaw-na iya si dimu'an buhat-na. Papakulawun-na liwat iya si Tata' si mga hinabo' nga anmas pa sito ngan sigurado bali i pagpangusa-bi. ");
INSERT INTO abx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Agbanhaw-na si Tata' i mga minatay ngan agbuwanan-na kinabuhi', ngan si pariho pa'agi, buwanan-na may liwat si Dadi' i bisan say nga nagpili'-na. ");
INSERT INTO abx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pwira pa sinan, i Tata' ga'i aghusgar si bisan say, lugod agpatubyan-na si Dadi' i bug'os paghusgar, ");
INSERT INTO abx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","basi' agtahod i dimu'an si Dadi' pariho si pagtahud-na mga iya si Tata'. Bisan say nga ga'i agtahod si Dadi', ga'i may liwat agtahod si Tata' nga magpabawa si iya. ");
INSERT INTO abx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sumatan-ta kam si kamatu'uran, bisan say makapamati' si allingun-ko ngan anutu'o si magpabawa si ako, aka'angkon si kinabuhi' hasta si kahastahan ngan ga'i nagpatukan. Akalampas na iya si kamatayon ngan aka'angkon na iya si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sumatan-ta kam si kamatu'uran, titakka i uras nga bisan si ina'anto atuman, nga i mga day minatay agpakabati' si busis-na si Dadi'-na si Diyos, ngan i mga magpanginano sito agka'arallom. ");
INSERT INTO abx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Basi' akapariho i Dadi' si Tata' nga nag'inala'an si kinabuhi', agbuwanan-nay to si katungod basi' i kinabuhi' pwidi nag'inala' mismo anan si Dadi'. ");
INSERT INTO abx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Agbuwanan-na liwat to gahom paghusgar tungod kay iya i Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Dakam ag'usa sito: Titakka i uras nga i dimu'an si mga minatay na akapamati' si busis-na ");
INSERT INTO abx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ngan pamahulwa', i mga mahalap binuhatan-na pamabangon nga aka'angkon si ungod kinabuhi' ngan i mga mara'at binuhatan-na pamabangon nga agpakapatukan. ");
INSERT INTO abx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kon kinalugaringun-ko hamok, gana' sahimu-ko. Akahusgar hamok ako kon ay i sapamati'an-ko ngan pantay i paghusgar-ko tungod kay ga'i ako agsunod si karuyag-ko kundi' kon ay dina i karuyag-na si magpapada'ito si ako. ");
INSERT INTO abx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kon ako mismo magtistigos parti si kalugaringun-ko, ga'i nan nagkwinta. ");
INSERT INTO abx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kundi' aniya' addangan magtistigos nga pabor si ako ngan katu'anan ako nga kamatu'uran i mga allingun-na. ");
INSERT INTO abx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aniya' nagpanlihug-bi pada'iray si Juan, ngan agtistigos to liwat kon ay i kamatu'uran mahi'unong si ako. ");
INSERT INTO abx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma'in nga agkinahanglan-ko i pagtistigus-na si a'a, kundi' agsumat-koy to basi' kam kunta' akasana'agan ngan asalbar. ");
INSERT INTO abx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan i makapariho si suga' nga nagsulsulan pagbuwan danta'. Si primiro, awili kam nga akasana'agan si mga allingun-na ngan akabuwan to si ka'am kalipayan. ");
INSERT INTO abx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero i mga buhat-ko akapamatu'od kon say gayod ako, anmas pa kuntra si pinahallingan-na si Juan. I trabaho nagpumwan-na si ako si Tata' nga makigtapus-na, nga iya i dimu'an mga kiniwa-kiwa-ko, iya i makapamatu'od nga agpabawa-na gayod ako si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ngan mismo i Tata' nga magpabawa si ako agtistigos mahi'unong si ako. Ga'i sabati'an-bi i busis-na ngan ga'i sakulawan-bi i kahimu-na, ");
INSERT INTO abx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ngan tungod kay ga'i agtutu'u-bi i nagpabawa-na, sayod ako nga gana' binuwa'-na si allingun-na si Diyos anan si pangiwa-kiwa-bi. ");
INSERT INTO abx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Maniguro kam pag'adal si Kasuratan tungod kay i pagkagasi-bi nga pina'agi sinan sa'angkun-bi na i kinabuhi' hasta si kahastahan. Si kamatu'uran mismo may nan Kasuratan i magpamatu'od mahi'unong si ako, ");
INSERT INTO abx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero agdiri'-bi lugod dina i pagdugok si ako nga iya hamok i pa'agi para kam kunta' aka'angkon si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ga'i ako aglalanat si pagdayaw-na si mga a'a. ");
INSERT INTO abx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lugod sayod ako kon ay i mga pagka'a'a-bi ngan akatu'anan ako nga i gugma'-na si Diyos ga'i anan si mga kasing-kasing-bi. ");
INSERT INTO abx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pada'ito ako pina'agi si gahum-na si Tata' pero ga'i ako agkarawat-bi, lugod i nagkarawat-bi dina kon aniya' pada'ito nga iya mismo magtu'in si kalugaringun-na. ");
INSERT INTO abx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kon i nag'anduy-bi i pagsidarayaway-bi dina ngan ga'i lugod kam maniguro nga sadayaw-na kam si adda hamok Diyos, pinapa'i kam anutu'o si ako? ");
INSERT INTO abx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Pero dakam ag'isip nga ako i mama'akusar si ka'am atubang si Tata'. Lugod, si Moises nga nagla'uman-bi para si katalwasan-bi, iya dina i mama'akusar si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kon agtutu'u-bi kunta' si Moises, sigurado anutu'o may kam si ako, kay agsurat iya mahi'unong si ako. ");
INSERT INTO abx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tungod kay ga'i may kam anutu'o si nagsurat-na, pinapa'i may panutu'u-bi si mga nagpahalling-ko?” ");
INSERT INTO abx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Si adda bisis pakatba si Jesus si dambila'-na si Danaw Galilea nga nag'arunan liwat Danaw Tiberias. ");
INSERT INTO abx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kalabbatan i magpamaktas paglanat si iya kay agpakakulaw to si pagpahalap-na si mga maburong nga agbuwan si mga iya pangngilalahan si langitnon kasiguruhan. ");
INSERT INTO abx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Padu'ung-na kas Jesus pati' si mga inadalan-na, pasagka mga iya pan tagudtod ngan agtiringkulu'ay ari. ");
INSERT INTO abx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Matapit na siray i pyista-na si mga Hebro nag'arunan Paglabay. ");
INSERT INTO abx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pamantaw-na si Jesus, sakulawan-na i kalabbatan tidugok si iya, mangno amatilaw iya si Felipe, “Singnga kita sito amalli pan pammakakan-ta si mga a'ay ro?” ");
INSERT INTO abx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yaynan patilaw, pagpurbar hamok i katuyu'an-na kay aniya' na dati si isip-na kon ay i buruhatun-na. ");
INSERT INTO abx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Anaruman may si Felipe, “Bisan tu'ig hamok aka'ikib i balang a'a, anggasto kita kam mga dos syintos dinari diplata pagballi pan.” ");
INSERT INTO abx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aniya' pa liwat mamahalling si mga inadalan-na nga iya si Andres, i sirari-na si Simon Pedro, ");
INSERT INTO abx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aniya' ato adda dadi'-dadi'on pa lalla nga agbalon lima bug'os pan pati' duwa agon. Pero ambot daw kon aniya' ba' sito pulus-na para si kalabbat-nay nan mga iya.” ");
INSERT INTO abx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aminugad si Jesus si mga inadalan-na, “Pamatingkulu'u-bi mga iya dimu'an.” Mahaway ari i kagabunan sanglit agpakatingkulo' i mga a'a ngan i kalabbat-na bisan si mga lalla hamok anakka mga singko mil. ");
INSERT INTO abx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mangno, addu'-na si Jesus i pan, agpasalamat si Diyos ngan makigpumwan-na si magpaningkulo'. Iya gihapon i nagbuhat-na si duwa agon, ngan akabuwanan i dimu'an tubtob si mga karuyag-na. ");
INSERT INTO abx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ngan bagtok na i mga a'a, agpinugad-na si Jesus i mga inadalan-na, “Tipunu-bi i mga la'a kay basi' ga'i akarag.” ");
INSERT INTO abx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dusi sagad pa dina i makapannu'an si la'a si lima bug'os pan. ");
INSERT INTO abx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pakakulaw-na si mga a'a sinan pangngilalahan si langitnon kasiguruhan nga nagbuhat-na si Jesus, aminugad mga iya, “Sigurado iya nayto gayod i nagparapanimulat-ta kam paragsumat nga tipada'ito si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pakasabut-na si Jesus nga tidugok i mga a'a pagpirit si iya pagpabaya' basi' akatu'inan nga magin mga hadi'-na, patalikot dina si Jesus ngan pasagka pa nga iya hamok sulu-sulo. ");
INSERT INTO abx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngan paglulu'om na, padalugdog pan danaw i mga inadalan-na si Jesus, ");
INSERT INTO abx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ngan agpamanakay si paraw pagtalabok si danaw pan syudad Capernaum. Ngan malu'om na, ga'i pa hamok gihapon anakka si Jesus si nagtupu'an-na kunta'. ");
INSERT INTO abx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mangno angusog i bariyo ngan bali kamamahaya si alon. ");
INSERT INTO abx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngan mga lima o annom kilumitro na i mga linahi'an-na, sakulawan-na mga iya si Jesus nga aglalangngan si buwahi' padugok si paraw ngan bali i mga kulba-na. ");
INSERT INTO abx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero aminugad to dina si mga iya, “Akoy to, dakam atalaw.” ");
INSERT INTO abx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mga malipayon dayon mga iya pagpasakay si iya ngan hintak anakka dayon i paraw si tarakkahan-na. ");
INSERT INTO abx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ka'asumuhan, aniya' mga paraw magpanakka tikang si syudad Tiberias nga agdu'ong matapit ari si lugar nagpamanganan-na si mga a'a si pan katapus-na si Ginu'o pagpasalamat si Diyos. Mangno, agpaka'intom to mga a'a nga adda may hamok i paraw ari pati' ma'in huwang si Jesus pagsakay si mga inadalan-na ngan agpamataliwan nga mga iya hamok. ");
INSERT INTO abx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sanglit si pakakatu'an-na mga iya nga ga'i na ari si Jesus pariho si mga inadalan-na, aniya' si mga iya mamanakay si mga paraw basi' agpakapada'iray si Capernaum pag'anda' si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Si pakabagat-na mga iya si Jesus ari si dambila'-na si danaw aminugad mga iya, “Rabbi, sumiran pa kaw ato?” ");
INSERT INTO abx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Anaruman si Jesus, “Sumatan-ta kam si kamatu'uran, agpara'anda'-bi ako tungod kay agkabaragtok kam si nagkakan-bi pan, ma'in tungod kay akasayod na kam si mga pangngilalahan si langitnon kasiguruhan naghimu-ko. ");
INSERT INTO abx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dakam agparapabudlay pag'anda' si karakanon nga apan'os, lugod anda'u-bi i karakanon nga gana' pagrara'atun-na hasta si kahastahan. Pumwan-nay nan si ka'am si Pinili' A'a. Human na i Diyos Tata' pagpublikar si pag'alagad-na si iya.” ");
INSERT INTO abx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sanglit agpatilaw mga iya, “Ay may i angay buruhaton kami' pagtuman si nagkinahanglan-na trabaho si Diyos?” ");
INSERT INTO abx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Anaruman si Jesus, “Yayto i nagkinahanglan-na si Diyos trabaho: Agtapura kam si nagpabawa-na.” ");
INSERT INTO abx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sanglit amatilaw gihapon mga iya, “Ay may pangngilalahana si langitnon kasiguruhan nga sahimu-mo basi' akakulaw kami' ngan agtapod si ka'aw? Ay may i hinimu-mo? ");
INSERT INTO abx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Agpamangan i mga ginikanan kami' si karakanon nag'arunan manna ari si disyirto nga tikang si langit, sigon si maka'anna' si Kasuratan: ‘Agbuwanan-na mga iya karakanon man langit basi' agpakakakan.’” ");
INSERT INTO abx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aminugad si Jesus, “Sumatan-ta kam si kamatu'uran, ma'in si Moises i magbuwan si ka'am si karakanon man langit, kundi' i Tatay-ko dina i magbuwan si ka'am si ungod karakanon nga tikang si langit. ");
INSERT INTO abx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","I karakanon nga tikang si Diyos iya i addangan nga man langit ngan agbuwan to kinabuhi' si mga a'a-na si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lingun-na may mga iya, “Sinyor, mismo ina'anto, buwanin kami' dayon da'inan sinan karakanon.” ");
INSERT INTO abx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sanglit agsumat si Jesus, “Ako i karakanon nga agbuwan kinabuhi'. Bisan say i padugok si ako gana' kalilingantuhun-na ngan bisan say i manutu'o si ako gana' ka'u'uhawun-na. ");
INSERT INTO abx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero pariho si nagsumat-ko si ka'am, ga'i pa kam hamok gihapon anutu'o bisan kon sakulawan-bi na ako. ");
INSERT INTO abx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","I dimu'an nga nagpatubyan-na si Tata' si ako, padugok si ako ngan bisan say nga padugok si ako, ga'i agtabrug-ko. ");
INSERT INTO abx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay pada'ito ako tikang si langit ma'in pagtuman si katuyu'an-ko kundi' pagtuman si katuyu'an-na si magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","I katuyu'an-na si magpabawa si ako nga gana' sarungay-ko si dimu'an nagpatubyan-na si ako hasta nga banhaw-ko mga iya si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Da'ito sito i binuhat-ko kay i katuyu'an-na si Tatay-ko nga bisan say i padugok pirmi si Dadi' ngan agtapod si iya, aka'angkon si kinabuhi' nga gana' katapusan-na. Allum-ko mga iya si damuri allaw.” ");
INSERT INTO abx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tungod sinan, aniya' si mga Hebro magtikang pagpanngurub-ngurob si pagpinugad-na, “Ako i karakanon nga tikang si langit.” ");
INSERT INTO abx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Agpaminugad mga iya, “Ma'in ba' to si Jesus, nga dadi'-na si Jose? Akatu'anan kita kam kon say i mga mahanak-na. Ay kay ina'anto akapinugad iya, ‘Tikang ako si langit’?” ");
INSERT INTO abx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Anaruman si Jesus, “Dakam agparapanngurub-ngurob anan. ");
INSERT INTO abx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gana' makadugok si ako kon ma'in inagda-na si Tata' nga magpapada'ito si ako, ngan ako i mamanhaw si iya si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aka'anna' si Nagpanurat-na si mga Paragsumat: ‘Turu'an-na si Diyos i dimu'an a'a.’ Bisan say i mamakali si Tata' ngan aka'adal si iya, iya i mandugok si ako. ");
INSERT INTO abx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gana' na la'in makakulaw si Tata' kon ma'in hamok i addangan nga tikang si iya. Iya hamok gayod i makakulaw si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sumatan-ta kam si kamatu'uran, bisan say manutu'o, aka'angkon si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ako i karakanon nga agbuwan kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Siray, akapamangan i mga ginikanan-bi karakanon nag'arunan manna ari si disyirto, pero agkamaratay may hamok gihapon mga iya. ");
INSERT INTO abx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ina'anto, atiya' i karakanon nga man langit, nga kon sakakan-na si addangan ga'i na iya amatay. ");
INSERT INTO abx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako i allom karakanon nga tikang si langit. Bisan say i mamangan sito karakanon, a'allom hasta si kahastahan. Yayto karakanon iya i isi-ko nga agpumwan-ko para aka'angkon kinabuhi' i mga a'a si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mangno aniya' si mga Hebro magparapamasusuhay hi'unong sito ngan agsiparatilaway, “Pinapa'i-na may sito a'a pagpumwan si isi-na pagpakakan si kita kam?” ");
INSERT INTO abx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Anaruman may si Jesus, “Sumatan-ta kam si kamatu'uran, hasta nga ga'i kam amangan si isi-na si Pinili' A'a ngan anginom si laha'-na, ga'i anan si ka'am i ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bisan say makakakan si isi-ko ngan maka'inom si laha'-ko, iya i maka'angkon si kinabuhi' nga gana' katapusan-na, ngan banhaw-ko iya si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ungod karakanon i isi-ko, ngan ungod irinumon i laha'-ko. ");
INSERT INTO abx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bisan say i makakakan si isi-ko ngan maka'inom si laha'-ko, maki'adda si ako ngan ako may maki'adda si iya. ");
INSERT INTO abx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aglihug-na ako si allom pirmi Tata', ngan allom ako tungod si iya. Si pariho pa'agi, i maka'ala' pagkakan ato si ako a'allom may liwat tungod si ako. ");
INSERT INTO abx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iyay to i karakanon nga tikang si langit. I makakakan sito a'allom hasta si kahastahan. Ma'in to pariho si manna nga nagkakan-na si kapapu'an-bi, nga aniya' may hamok gihapon mga kamatayun-na.” ");
INSERT INTO abx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Agpahalling-nay nan si Jesus ngan pagturu'-na si sinaguga ari si Capernaum. ");
INSERT INTO abx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Si pakapamati'-na sinan si mga inadalan-na, aniya' magpaminugad si mga iya, “Bali kuri pag'ako' si nagturu'-na. Say may manutu'o sinan?” ");
INSERT INTO abx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bisan kon gana' magsumat, sakatu'anan-na si Jesus nga agpanngurub-ngurob i mga inadalan-na mahi'unong si mga allingun-na, sanglit agpaminugad-nay to, “Ma'in pa ba' kam andam pag'ako' sito? ");
INSERT INTO abx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iya pa ba' kon sakulawan-bi i pagbalik-na si Pinili' A'a pan langit! ");
INSERT INTO abx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","I Espirito i magbuwan kinabuhi', ngan gana' kapulsanan-na si pagpapaniguru-na si a'a nga agtapod si kalugaringun-na. I nagsumat-ko si ka'am mga allingon, akapadugok si ka'am si Espirito ngan akabuwan si ungod kinabuhi'. ");
INSERT INTO abx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero aniya' pa si ka'am nga ga'i agpanutu'o.” Akapinugad iya sinan kay tikang pa si tinikangan, akatu'anan na si Jesus kon say i ga'i magpanutu'o si iya ngan kon say i titraydor si iya. ");
INSERT INTO abx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Agpadayon si Jesus pagpahalling, “Iyay nan i rason kon ay kay akapinugad ako si ka'am nga gana' makadugok si ako hasta nga ga'i iya agsagda-na si Tata'.” ");
INSERT INTO abx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tungod sinan, bali labbat si mga inadalan-na i pamabulag ngan ga'i na agpamungyod si iya. ");
INSERT INTO abx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sanglit agtilaw-na si Jesus i Dusi, “Tara' ka'am, pabulag ba' liwat kam si ako?” ");
INSERT INTO abx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Anaruman si iya si Simon Pedro, “Paragdalom, singnga pa may kami' pa'arop? Awinan si ka'aw i mga allingon nga agbuwan si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Anutu'o kami' ngan sayod nga ka'aw i Sagrado A'a nagpabawa-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mangno anaruman si Jesus, “Si ka'am Dusi, ma'in ba' nga ako mismo i magpili' si ka'am? Pero addangan si ka'am i nagdaluman-na si Satanas!” ");
INSERT INTO abx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I nagtukuy-na sinan iya si Judas nga dadi'-na si Simon Iscariote. Bisan kon addangan iya si Dusi, iya i magtraydor si Jesus si katapus-tapusan. ");
INSERT INTO abx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kahuman sinan, agparalibut-libot si Jesus ari si Galilea. Agtuyo' iya pag'amban si Judea tungod kay nag'imamatay iya si mga punu'-na ari si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mangno ngan matapit na i Pyista-na si mga Payag-payag nga nagsilibraran-na si mga Hebro, ");
INSERT INTO abx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","nagpinugad si Jesus si mga bugtu'-na lalla, “Kinahanglan kaw pa'amban ato ngan pada'iraya ari si Judea basi' agpakakulaw i mga inadalan-mo si mga makagagahom binuhatan-mo. ");
INSERT INTO abx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay gana' ato a'a nga tinago' i pagtrabahu-na kon aruyag iya nga magin bantugan. Tara', kay agparahimo may kaw lugod sinan mga buhat, hala, pahayagon i kalugaringun-mo si dimu'an a'a.” ");
INSERT INTO abx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Agda'inan sinan pagpahalling i mga bugtu'-na tungod kay ga'i to liwat agpanutu'o si iya. ");
INSERT INTO abx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sanglit anaruman si Jesus si mga iya, “Ga'i pa anakka i tama' uras para si ako. Ma'in ako pariho si ka'am nga pwidi bisan ay urasa. ");
INSERT INTO abx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ga'i kam naghumutan si mga a'a ato si kalibutan, pero ako naghumutan tungod si pagparapinugad-ko nga sala' i mga nagparapamuhat-na. ");
INSERT INTO abx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hala, mamyistaha na kam ari pero ako ga'i pa tungod kay ga'i pa anakka i tama' uras para si ako.” ");
INSERT INTO abx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pakapinugad-na sinan, pabilin iya ari si Galilea. ");
INSERT INTO abx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero kahuman-na si mga bugtu'-na pagtaliwan pagpamyista, pataliwan may liwat si Jesus pero aglikay iya si ka'aha'an. ");
INSERT INTO abx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ari si Pyistahan nagpara'anda' iya si mga punu'-na si mga Hebro ngan agparapamatilaw, “Singnga ba' nan a'a?” ");
INSERT INTO abx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Si magpantambong, matabbol magparapangguru-guro hi'unong si iya. Aniya' magpaminugad, “Mahalap iya a'a.” I ditangnga' may agpanaruman, “Ma'in may. Agparadaya' dina iya si mga a'a.” ");
INSERT INTO abx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero gana' bisan say si mga iya mamahalling nga kinabati'an si kalabbatan tungod si mga katalaw-na si mga punu'-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hinunga'-tunga' na dina si Pyista ngan pagpakulaw-na si Jesus si kalabbatan ari si hawan-na si templo. Agtikang iya ari pagturo' ");
INSERT INTO abx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ngan agpangusa i mga punu'-na si mga Hebro. Sigi mga iya pamatilaw, “Singngay to a'a ag'inala' si kata'u-na nga ma'in may malanga i inadalan-na?” ");
INSERT INTO abx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Anaruman si Jesus, “I nagturu'-ko, ma'in tikang si kalugaringun-ko. Tikang to si magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bisan say aha'a nga agpili' pagbuhat si katuyu'an-na si Diyos, sigurado sakatu'anan-na kon tikang ba' si Diyos i nagturu'-ko o kon agpahalling hamok ako si kalugaringun-ko. ");
INSERT INTO abx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","I a'a nga agpahalling para si kalugaringun-na, agbuhat-nay nan hamok pagpalabaw si kalugaringun-na. Pero i a'a nga makigdayaw-na dina i magpabawa si iya, panno' iya si kamatu'uran. Gana' kina'anda'an kabubullu'an anan si iya. ");
INSERT INTO abx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma'in ba' nga agpumwan-na si ka'am si Moises i bala'od? Pero gana' si ka'am magsunod sinan. Ma'in ba' nga ag'imamatay-bi dina ako?” ");
INSERT INTO abx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Anaruman dina i magpantarambak ari, “Kapay kaw pag'isip sinan! Say may i mag'imamatay si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero anaruman dina si Jesus si mga puno', “Si paghimu-ko makagagahom binuhatan, agpangusa kam dimu'an. ");
INSERT INTO abx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kulawi-bi daw. Ka'am agparaturi' si mga dadi' bisan kon Allaw Pandidiskanso sigon si nagmandu'-na si ka'am si Moises. Si kamatu'uran ma'in nan gayod tikang si Moises kundi' tikang pa dina si mga ginikanan-na si nasyun-ta kam. ");
INSERT INTO abx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kon agturi' kam si dadi' si Allaw Pandidiskanso basi' ga'i nagsupak i bala'ud-na si Moises, ay kay asina kam si ako si pagpahalap-ko si bug'os puhu'-na si a'a si Allaw Pandidiskanso? ");
INSERT INTO abx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dakam aghusgar kon tama' ba' o ma'in i bisan ay sigon si sakulawan-bi si gawas, lugod husgari-bi dina sigon si malalom katuyu'an-na sito.” ");
INSERT INTO abx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sinan ka'urason, aniya' si mga a'a si Jerusalem nga agtikang pagkilala si iya ngan agpaminugad, “Tingali iya nayto i a'a nga nag'imamatay-na si mga puno'. ");
INSERT INTO abx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Atiya' iya agparapahalling si katabbulan-na si mga a'a pero ga'i lugod mga iya agpakasibo'. Agtutu'o na ba' mga iya nga iya nayto i Tinu'inan Mannanalwas? ");
INSERT INTO abx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero kita kam, sayod lugod kon taga singngay to a'a. Si panakka-na si Tinu'inan Mannanalwas, gana' makatu'anan kon singnga iya tikang.” ");
INSERT INTO abx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Si padayon pagturu'-na si Jesus ari si hawan-na si templo, angusog i busis-na, “Oho' gad, sakilala-bi ako ngan sakatu'anan-bi kon taga singnga ako pero ma'in tungod si kalugaringun-ko pagdalom sanglit atiya' ako ina'anto. Panno' si kamatu'uran ngan tarapuran i magpabawa si ako pero ga'i iya sakilala-bi. ");
INSERT INTO abx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Sayod ako si iya kay tikang ako si iya ngan iya i magpabawa si ako.” ");
INSERT INTO abx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tungod sinan, nag'idadakop iya si ditangnga' mga a'a, pero gana' ni addangan mangaddo' si iya, tungod kay ma'in pa iya i uras-na. ");
INSERT INTO abx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero malabbat gihapon si magpantarambak i manutu'o si iya. Agpaminugad to, “Kon anakka i Tinu'inan Mannanalwas, akahimo ba' iya mga pangngilalahan si langitnon kasiguruhan nga anmas pa kuntra si nagbuhat-na sito a'a?” ");
INSERT INTO abx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aniya' si mga Parisiyo magpaka'aning'ing si mga ginuru-guru-na si mga a'a parti si Jesus. Mangno agpamabawa mga iya pati' i mga puno' paraghalad mga bantay si templo pagdakop si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aminugad si Jesus, “Makali' na hamok i pagpakihuwang-ko si ka'am, mangno pada'iray na ako si magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Anakka i uras nga anda'-bi ako pero ga'i ako sa'anda'an-bi ngan ga'i kam akapada'iray kon singnga ako.” ");
INSERT INTO abx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Agsipurupinugaray i mga punu'-na si mga Hebro, “Singnga daw sito a'a i parada'irayan-na nga ga'i iya sa'anda'an-ta kam? Tipada'iray ba' iya si nag'istaran-na si mga Hebro nga agsaralakot si sakup-na si mga Griko basi' akaturo' iya sito mga a'a? ");
INSERT INTO abx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ay i karuyag sidngun-na si pagpinugad-na, ‘Anakka i uras nga anda'-bi ako pero ga'i ako sa'anda'an-bi,’ pati' ‘Ga'i kam akapada'iray kon singnga ako’?” ");
INSERT INTO abx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Si pangultimo allaw nga iya i pinaka'impurtanti si Pyista, anunggo si Jesus ngan amahalling makusog, “Bisan say nag'uhaw, dakam agruha-duha padugok si ako ngan anginom. ");
INSERT INTO abx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bisan say nga anutu'o si ako, agdadaras anan si iya i burabod si allom buwahi' pariho si maka'anna' si Kasuratan.” ");
INSERT INTO abx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I nagtukuy-na si Jesus sinan mga allingon, iya i Espirito nga kararawatun-na si magpanutu'o si iya. Sito mga ka'urason, ga'i pa nagpa'ayop i Espirito tungod kay ga'i pa may si Jesus nag'alsa ngan nagpa'unrahan. ");
INSERT INTO abx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Si pakapamati'-na sinan si mga a'a, aniya' magpaminugad, “Sigurado nga iya nayto i nagparapanimulat paragsumat.” ");
INSERT INTO abx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aniya' liwat magpaminugad, “Iya i Tinu'inan Mannanalwas.” Aniya' may magpamatilaw, “Pinapa'i may nga i Tinu'inan Mannanalwas tikang dina si Galilea? ");
INSERT INTO abx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ma'in ba' aka'anna' si Kasuratan nga i Tinu'inan Mannanalwas tikang si Betlehem, i bungto nag'istaran-na si David ngan addangan iya si mga ka'ampu-ampuhan-na?” ");
INSERT INTO abx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sanglit tungod si Jesus atunga' si duwa grupo i mga a'a. ");
INSERT INTO abx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aniya' mga mag'idadakop si iya, pero gana' ni addangan mangaddo' si iya. ");
INSERT INTO abx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Si katapus-tapusan, i nagpanlihog mga bantay-na si templo agbwilta na hamok pada'iray si mga puno' paraghalad pati' mga Parisiyo. Agpamatilaw to si mga iya, “Ay kay ga'i iya agdakup-bi?” ");
INSERT INTO abx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Anaruman may i mga bantay, “Gana' maka'irog agpahalling sito a'a.” ");
INSERT INTO abx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Hasta ba' liwat ka'am saluku-na?” lingun-na si mga Parisiyo. ");
INSERT INTO abx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Aniya' ba' si mga puno' o si mga Parisiyo nga magtutu'o si iya? ");
INSERT INTO abx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Gana'! Pero yaynan mga a'a nga gana' sa'urup-urupan-na si bala'od, sigurado mga iya agpakagaba'an.” ");
INSERT INTO abx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Addangan si mga Parisiyo ari si Nicodemos nga human na siray makibagat si Jesus. Amatilaw to, ");
INSERT INTO abx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tugot ba' si bala'ud-ta kam i pagpatok si adda a'a myintras ga'i pa iya nagbistahan?” ");
INSERT INTO abx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Agpanaruman may mga iya, “Dakaw agpinugad nga adda kaw taga Galilea. Ag'adala si Kasuratan basi' sakatu'anan-mo nga gana' paragsumat nga tikang si Galilea.” ");
INSERT INTO abx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mangno agpamalik mga iya pada'iray si mga kalugaringun-na ruma'. ");
INSERT INTO abx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mangno pada'iray si Jesus si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. ");
INSERT INTO abx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kamananalungan pabwilta iya si hawan-na si templo. Nagtiripunan iya si dimu'an mga a'a, sanglit aningkulo' iya pagturo' si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aniya' mga paragturo' bala'od pati' mga Parisiyo magpamawa danda nga sadakup-na mga iya maki'ubay si ma'in kakasal-na. Agpatunggu-nay to mga iya tangnga' si mga a'a ngan ");
INSERT INTO abx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","agpinugad-na mga iya si Jesus, “Ma'istro, sadakop kami' to danda nga maki'ubay si ma'in kakasal-na. ");
INSERT INTO abx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ari si Bala'od agmando' si Moises pagtalutog si da'ito klasi danda. Tara', para si ka'aw ay may siguro i tama'?” ");
INSERT INTO abx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Agpinugad mga iya sinan pagpurbar si Jesus basi' kon anala' pagsaruman, sapa'akusar-nay to mga iya. Pero paduko' dina si Jesus ngan agtikang pagpasurat si tutturu'-na si pitak. ");
INSERT INTO abx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngan ga'i namay gayod mga iya pahuway si kapapatilaw, anunggo si Jesus ngan aminugad, “Kon say si ka'am i gana' sala'-na, iya i primiro manalutog sito danda.” ");
INSERT INTO abx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mangno anduko' gihapon iya ngan agsurat ari si pitak. ");
INSERT INTO abx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Si pakapamati'-na mga iya sinan, agsa'uru'addangan mga iya pag'amban tikang si kamabu'utan hasta nga si Jesus na hamok i mabilin pati' i danda nga agparatutunggo pa ari. ");
INSERT INTO abx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Anunggo si Jesus ngan aminugad, “Ni', singnga na mga iya? Gana' ba' mabilin pagpatok kamatayon si ka'aw?” ");
INSERT INTO abx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Anduko' i danda ngan aminugad, “Sinyor, gana' namay.” Aminugad may si Jesus, “Hasta ako ga'i may liwat amatok si ka'aw. Hala, pada'iraya na ngan ambanin na i pagparapakasala'!” ");
INSERT INTO abx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Si manunod pagpahalling-na si Jesus atubang si mga a'a agpinugad iya, “Ako i danta'-na si kalibutan. Bisan say magsunod si ako, sigurado nga ga'i aglalangngan si kalu'uman lugod aka'angkon dina si danta' nga magbuwan si ungod kinabuhi'.” ");
INSERT INTO abx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pero agsupla-na dina iya si mga Parisiyo, “Ka'aw gihapon mismo i magtistigos si kalugaringun-mo, sanglit ma'in makatutu'o i nagpahalling-mo.” ");
INSERT INTO abx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Anaruman may si Jesus, “Bisan kon ako mismo i magtistigos para si kalugaringun-ko, kamatu'uran gihapon i nagpahalling-ko tungod kay sayod ako kon ay i tinikangan-ko ngan kon ay i tarakkahan-ko. Pero ga'i kam agpakatu'anan kon ay i tinikangan-ko o kon ay i tarakkahan-ko. ");
INSERT INTO abx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aghusgar kam si ako sigon si sakulawan-bi si pagka'a'a-ko ina'anto; pero ako, ga'i aghusgar si bisan say. ");
INSERT INTO abx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero kon anhusgar may dina ako, sigurado nga tama' gayod i disisyun-ko kay ma'in hamok ako sulo i maghimo sinan kundi' aghuwang kami' si Tata' nga magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aka'anna' si Bala'ud-bi nga kon aniya' duwangan magtistigos sigurado nga kamatu'uran i mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Addangan ako si magtistigos para si kalugaringun-ko, ngan i addangan pa, iya i magpabawa si ako nga gana' la'in kon ma'in i Tata'.” ");
INSERT INTO abx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mangno agpamatilaw mga iya, “Singnga may i tatay-mo?” Anaruman may si Jesus, “Ga'i ako sakilala-bi ngan da'inan may i Tatay-ko kay kon sakilala-bi ako, sakilala-bi may liwat kunta' i Tatay-ko.” ");
INSERT INTO abx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Agpahalling sinan si Jesus ngan pagparaturu'-na ari si hawan-na si templo matapit si pangnganganna'an si mga nagpahalad. Pero gana' ni addangan mandakop si iya tungod kay ga'i pa anakka i uras-na. ");
INSERT INTO abx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aminugad gihapon si Jesus si mga iya, “Pa'amban ako ngan sigurado anda'-bi. Agkaramatay kam huwang si mga kasal'anan-bi ngan ga'i kam agpakatuttot si parada'irayan-ko.” ");
INSERT INTO abx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tungod sinan, agsipurupatilaway i mga punu'-na si mga Hebro, “Ay daw i karuyag sidngun-na si pagpinugad-na nga ga'i kita kam agpakatuttot si parada'irayan-na? Tingali ag'unay iya.” ");
INSERT INTO abx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero agpadayon si Jesus pagpahalling, “Tikang kam si hawod pero ako tikang si dyata'. Sakop kam si kalibutan pero ako ma'in. ");
INSERT INTO abx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Agpinugad-ta kam nga agkamaratay kam huwang si mga kasal'anan-bi ngan kon ga'i kam agpanutu'o nga akoy ray mismo nagpakilala-koy ray si ka'am, sigurado nga agkamaratay kam huwang si mga kasal'anan-bi.” ");
INSERT INTO abx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Agpaminugad may mga iya, “Kay say ba' kaw gayod?” Anaruman may si Jesus, “Kon ay i pagpakilala-ko si ka'am tikang pa si panikangan. ");
INSERT INTO abx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Malabbat i surudya'un-ko si ka'am pati' parapatukun-ko ngan tungod kay panno' si kamatu'uran ngan tarapuran i magpabawa si ako, kinahanglan sumat-ko gayod ato si kalibutan kon ay i sapamati'an-ko tikang si iya.” ");
INSERT INTO abx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ga'i mga iya agpanabot nga agsumatan-na mga iya hi'unong si Tatay-na. ");
INSERT INTO abx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sanglit aminugad si Jesus, “Kon alsa-bi na i Pinili' A'a, iya na kam dina akatu'anan nga akoy ray nagpakilala-koy ray si ka'am. Sakatu'anan-bi liwat nga ga'i ako agbuhat si kalugaringun-ko hamok kundi' agpahalling hamok ako kon ay i nagturu'-na si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","I magpabawa si ako pirmi aghuwang si ako ngan ga'i ako agpata'anan-na tungod kay pirmi agbuhat-ko i makapalipay si iya.” ");
INSERT INTO abx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Malabbat i magpanutu'o si iya si pakapakali-na mga iya sinan. ");
INSERT INTO abx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Agpinugad-na si Jesus i mga Hebro nga aniya' pagtutu'u-na si iya, “Kon ga'i kam palabba si nagturu'-ko, ungod kam gayod nga mga inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sasayuran-bi i kamatu'uran, ngan i kamatu'uran na i magpalibri si ka'am.” ");
INSERT INTO abx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Agpanaruman may mga iya, “Kami' i mga ka'uru'ampuhan-na si Abraham ngan ga'i pa kami' nag'uripon si bisan say. Ay kay agpinugad kaw nga linibri kami'?” ");
INSERT INTO abx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Anaruman si Jesus, “Sumatan-ta kam si kamatu'uran, bisan say magparapakasala', uripon iya si sala'. ");
INSERT INTO abx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I uripon ma'in gayod kwintado si pamilya, pero i dadi' kwintado hasta si kahastahan. ");
INSERT INTO abx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sanglit kon palibri-na kam si Dadi' ungod gayod i pagkalibri-bi. ");
INSERT INTO abx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sayod ako nga mga ka'uru'ampuhan-na kam si Abraham pero ag'imamatay-bi dina ako tungod kay ga'i agbuwanan-bi lugar i allingun-ko. ");
INSERT INTO abx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Agsumatan-ta kam si nagpakulaw-na si ako si Tata', ngan ka'am may agbuhat si sapamati'an-bi tikang si tatay-bi.” ");
INSERT INTO abx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Agpanaruman mga iya, “Tatay kami' si Abraham.” Aminugad may si Jesus, “Kon ungod kam nga mga dadi'-na si Abraham buhat-bi may kunta' i nagbuhat-na. ");
INSERT INTO abx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kundi' ag'imamatay-bi gayod ako dina, ako nga magsumat si ka'am si kamatu'uran nga sapamati'an-ko tikang si Diyos. Ga'i nan agbuhat-na si Abraham. ");
INSERT INTO abx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ag'irog kam dina si buhat-na si kalugaringun-bi tatay.” “Ma'in kami' mga dadi' si gawas,” lingun-na may mga iya. “Gana' la'in Tata' kami' kon ma'in hamok i Diyos mismo.” ");
INSERT INTO abx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aminugad si Jesus si mga iya, “Kon ungod nga i Diyos i Tatay-bi, kunta' higugma'-bi ako tungod kay tikang ako si Diyos ngan ina'anto atiya' ato. Ga'i ako pada'ito nga kalugaringun-ko hamok; kundi' iya i magpapada'ito si ako. ");
INSERT INTO abx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ay kay ga'i sasabutan-bi i allingun-ko? Tungod kay ga'i kam amakali si nagpahalling-ko. ");
INSERT INTO abx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I tatay-bi nga tagtawa' si ka'am, iya si Satanas, ngan agkararuyag kam pagtuman si karuyag-na si tatay-bi. Adda iya kriminal tikang pa gayod si panikangan ngan bullu'on iya kay ga'i anan si iya i kamatu'uran. Si pagbullu'-na, agpakulaw hamok iya si ungod kina'iya-na kay ungod gayod nga bullu'on iya pati' tata'-na si dimu'an kabubullu'an. ");
INSERT INTO abx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero ako lugod nga agsumat si kamatu'uran, ga'i agtutu'u-bi! ");
INSERT INTO abx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aniya' ba' si ka'am makapamatu'od nga aniya' baratunun-ko si sala'? Kon agsumat ako si kamatu'uran, ay kay ga'i ako agtutu'u-bi? ");
INSERT INTO abx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bisan say nga tawa'-na si Diyos akapakali si nagpahalling-na si Diyos. I rason kon ay kay ga'i kam agpakapakali, kay si kamatu'uran ma'in kam tawa'-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nagpinugad si Jesus si mga punu'-na si mga Hebro, “Ma'in ba' kami' tama' si pagpinugad nga adda kaw Samaritano pati' nga nagbawa-bawa kaw si mara'at espirito?” ");
INSERT INTO abx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Anaruman may si Jesus, “Ga'i ako nagbawa-bawa si mara'at espirito kundi' agrispitar hamok ako si Tatay-ko pero ka'am ga'i agrispitar si ako. ");
INSERT INTO abx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ga'i ako aghingyap nga aka'unrahan i kalugaringun-ko, lugod aniya' addangan maghingyap sinan para si ako, ngan iya i huwis. ");
INSERT INTO abx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sumatan-ta kam si kamatu'uran, kon i a'a agsunod si allingun-ko, gana' kamamatayun-na.” ");
INSERT INTO abx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tungod sinan agpaminugad i mga punu'-na si mga Hebro, “Ina'anto sasayuran kami' na nga ungod kaw gayod nagbawa-bawa si mara'at espirito! Amatay si Abraham ngan da'inan may i mga paragsumat. Apa'i may kay akapinugad pa kaw hamok gihapon nga kon i a'a agsunod si allingun-mo, ga'i iya kakinda si kamatayon? ");
INSERT INTO abx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mas gamhanan pa ba' kaw kuntra si papo' kami' Abraham? Amatay iya ngan da'inan may liwat i mga paragsumat. Ngan ka'aw, say may kaw si pagkagasi-mo?” ");
INSERT INTO abx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Anaruman si Jesus, “Kon ako mismo magpa'unra si kalugaringun-ko gana' sinan kwinta-na. Kundi' i magpa'unra si ako gana' la'in kon ma'in i Tatay-ko nga nag'aku'-bi nga Diyus-bi. ");
INSERT INTO abx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ga'i kam angilala si iya pero angilala ako. Kon aglirong ako, akapariho ako si ka'am nga mga bullu'on, pero ungod nga sakilala-ko iya ngan agsunod ako si allingun-na. ");
INSERT INTO abx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Alipay i papu'-bi Abraham si pag'ikukulaw si pagtakka-ko ngan si panakka-ko bali gayod i kalipay-na.” ");
INSERT INTO abx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Agpinugad i mga punu'-na si mga Hebro, “Ga'i pa ngani' kaw agsingkwinta anyos tapos agpinugad kaw nga sakulawan-mo si Abraham!” ");
INSERT INTO abx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Anaruman may si Jesus, “Sumatan-ta kam si kamatu'uran, myintras a'allom si Abraham, dati na ako!” ");
INSERT INTO abx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tungod sinan agpangaddo' mga iya bato pagtalutog si iya, pero patago' dahulo si Jesus mangno pakawara' iya ari si hawan-na si templo. ");
INSERT INTO abx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Si pagparalalangngan-na si Jesus, aniya' sakulawan-na lalla nga buta tikang pa si ka'allum-na. ");
INSERT INTO abx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Amatilaw i mga inadalan-na, “Rabbi, say may nan tawa' sala' kay a'allom iya dati buta? Sala'-na ba' nan o si mga mahanak-na?” ");
INSERT INTO abx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aminugad may si Jesus, “Gana' bisan addangan si mga iya i makasala'. Ahinabo' nan basi' kinakulawan i buhat-na si Diyos si kinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngan myintras allaw pa, kinahanglan nga buhat-ta kam i trabahu-na si magpapada'ito si ako kay ma'in na pira i kasangumon nga gana' na makatrabaho. ");
INSERT INTO abx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Myintras nga atiya' pa ako, ako i danta'-na si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pakapinugad-na sinan, anupra iya si pitak ngan pina'agi si rukda'-na, agbasi'-na i lapok ngan agpatakpul-na si mata-na si lalla. ");
INSERT INTO abx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Agsumatan-nay to, “Pada'iraya na ngan anguram'usa ari si libtong nag'arunan Siloe.” I kahulugan-na sinan aron: Naglihog. Sanglit pada'iray i buta, anguram'os ari ngan akakulaw na iya si pagbalik-na. ");
INSERT INTO abx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Agsipurupatilaway i mga katiringpid-na pati' i mga dati magpakakulaw si iya si pagparapalimus-na pa, “Ma'in ba' iya i lalla magparapalimos pirmi?” ");
INSERT INTO abx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aniya' may magpaminugad nga iya gayod. I ditangnga' may agpaminugad, “Ma'in nan iya, agkapariho hamok i mga itsura-na.” Pero maniguro gayod mismo i lalla si pagpinugad, “Ako nayto mismo.” ");
INSERT INTO abx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Kon sugad, pinapa'i may nga akakulaw na kaw?” lingun-na may mga iya. ");
INSERT INTO abx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Anaruman may iya, “Agtakpulan-na si nagkumul-kumul-na lapok i mga mata-ko si lalla nag'arunan Jesus. Mangno agmandaran-na ako pagpada'iray si Siloe ngan pagkuram'os ari. Sanglit pada'iray ako ngan akakulaw dayon katapos si pagkuram'us-ko.” ");
INSERT INTO abx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Amatilaw i mga a'a, “Singnga may to a'a ina'anto?” Aminugad may iya, “Ambot, ga'i ako akatu'anan.” ");
INSERT INTO abx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nagbawa pada'iray si mga Parisiyo i lalla nga dati buta. ");
INSERT INTO abx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Allaw Pandidiskanso siray pagpalapuyut-na si Jesus si lapok pati' pagpahalap-na si mata-na si lalla. ");
INSERT INTO abx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sanglit agpatilawan-na liwat si mga Parisiyo i lalla kon pinapa'i nga akakulaw iya. Anaruman i lalla, “Agtakpulan-na lapok i mga mata-ko ngan agkuram'usan-ko, mangno akakulaw dayon ako.” ");
INSERT INTO abx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aniya' magpaminugad si mga Parisiyo, “Ma'in nan lalla tikang si Diyos kay ga'i agtuman-na i bala'od mahi'unong si Allaw Pandidiskanso.” Pero agpaminugad i ditangnga', “Pinapa'i-na si addangan makasasala' pakahimo si mga pangngilalahan si langitnon kasiguruhan pariho sito?” Sanglit aniya' magpanutu'o ngan aniya' may liwat ga'i. ");
INSERT INTO abx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mangno tilaw-na gihapon mga iya i lalla, “Ka'aw i nagpahalap-na. Ay may i sapasumat-mo mahi'unong si iya?” Anaruman i lalla, “Paragsumat-na iya si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ga'i pa hamok gihapon agpanutu'o i mga punu'-na si mga Hebro nga dati iya buta nga ina'anto akakulaw na. Sanglit agpa'ala'-na mga iya i mga mahanak-na ");
INSERT INTO abx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ngan agtilaw-na, “Iya ba' to gayod i dadi'-bi nga nagpinugad-bi dati buta si paka'allum-na? Apa'i may kay akakulaw na iya ina'anto?” ");
INSERT INTO abx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Agpanaruman i mga mahanak-na, “Oho', ungod nga iya i dadi' kami' ngan ungod liwat nga dati iya buta si paka'allum-na. ");
INSERT INTO abx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero ga'i kami' akatu'anan kon apa'i kay akakulaw na iya o kon say i magpahalap si mga mata-na. Tilawu-bi na hamok iya kay tama' namay iya si idad pagpahalling para si kalugaringun-na.” ");
INSERT INTO abx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Akapinugad sinan i mga mahanak-na si lalla kay atalaw mga iya si mga puno' to nga magpa'ala' si mga iya, tungod kay agdisisyon na i mga punu'-na si mga Hebro nga pina'itsapwira si sinaguga i bisan say mag'ako' nga si Jesus, iya i Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sanglit agpinugad i mga mahanak-na si lalla, “Idaran na iya, iya na hamok tinilawu-bi.” ");
INSERT INTO abx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Si kaduwa bisis agpaban'u-na mga iya i dati buta. Agpinugad-na mga iya, “Pa'unrahin i Diyos nga iya maghimo sito. Katu'anan kami' nga makasasala' nan a'a nag'arunan nan Jesus.” ");
INSERT INTO abx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Anaruman iya, “Ga'i ako akatu'anan kon makasasala' ba' iya o ma'in. I adda hamok sakatu'anan-ko nga dati ako buta pero ina'anto akakulaw na!” ");
INSERT INTO abx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mangno amatilaw mga iya, “Ay i nagbuhat-na si ka'aw? Agpapa'i-na pagpahalap i mga mata-mo?” ");
INSERT INTO abx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Anaruman iya, “Agsumatan-ta na kam pero ga'i ako agpakali-bi. Ay kay aruyag kam nga sapakalihan-bi gihapon? Aruyag ba' kam liwat magin inadalan-na sinan lalla?” ");
INSERT INTO abx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mangno agtamay-na dina mga iya ngan agpinugad-na, “Inadalan-na bali' kaw sinan lalla! Kami' inadalan-na si Moises. ");
INSERT INTO abx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Akatu'anan kami' nga agbagawan-na na dina si Diyos si Moises, pero yaynan lalla, ga'i ngani' kami' akatu'anan si tinikangan-na.” ");
INSERT INTO abx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mangno aminugad i lalla, “Urusahon to gayod! Ga'i kam akatu'anan si tinikangan-na pero sapahalap-na i mga mata-ko. ");
INSERT INTO abx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Katu'anan kita kam nga ga'i agpakali-na si Diyos i mga makasasala'. Lugod, agpakali dina iya si diyusnon a'a magbuhat si katuyu'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tikang pa siray, gana' pa sapakalihan-ta nga aniya' makapahalap si a'a nga buta tikang si ka'allum-na. ");
INSERT INTO abx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon ma'in nan lalla linihug-na si Diyos, gana' kunta' sahimu-na.” ");
INSERT INTO abx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tungod sinan allingon anaruman mga iya, “Tikang pa gayod si ka'allum-mo, ga'i na kaw pukkalan-na si sala'. Day turututu'o daw kaw gayod agwaydong si kami'!” Mangno nagtabrog iya. ");
INSERT INTO abx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Akapakali si Jesus nga nagtabrog i lalla, sanglit agbagat-nay to ngan agpinugad-na, “Anutu'o ba' kaw si Pinili' A'a?” ");
INSERT INTO abx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Amatilaw i lalla, “Say may nan iya, Sinyor? Sumatin ako basi' anutu'o ako si iya.” ");
INSERT INTO abx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aminugad si Jesus, “Sakulawan-mo na iya. Si kamatu'uran, iya i kabagaw-mo ina'anto.” ");
INSERT INTO abx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mangno aminugad i lalla, “Paragdalom, agtutu'o ako,” ngan anluhod iya pag'ampo' si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aminugad si Jesus, “Pada'ito ako si kalibutan paghusgar, basi' agpakakulaw i mga buta ngan i mga magpakakulaw may agkaburuta.” ");
INSERT INTO abx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Aniya' mga Parisiyo ari magpakabati' sinan ngan agpamatilaw, “Ay ray allingun-moy ray? Huwang ba' kami' si mga buta?” ");
INSERT INTO abx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Lingun-na may si Jesus, “Kon mga buta kam, gana' kunta' baratunon si mga sala'-bi. Pero kay agpaminugad may kam nga agpakakulaw kam, sanglit aniya' baratunun-bi.” ");
INSERT INTO abx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Aminugad si Jesus, “Sumatan-ta kam si kamatu'uran, i matangkaw pati' i tulisan ga'i pa'agi si pwirtahan-na si kuta' kundi' amanahik dina si la'in pangngagihan ");
INSERT INTO abx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","pero i mangngataman si karniro sigurado nga ari pa'agi. ");
INSERT INTO abx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nagpasallod iya si magbantay si pwirtahan, ngan amati' i mga kalugaringun-na karniro si busis-na. Pamagawas mga iya kon agban'u-na sa'uru'addangan i mga arun-na. ");
INSERT INTO abx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pakagawas-na mga iya, agdahulo iya ngan anunod i mga karniru-na kay angilala si busis-na. ");
INSERT INTO abx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ga'i mga iya agsunod si ga'i mga sagara'an-na, lugod pamalahi dina mga iya kay ga'i sakilala-na i busis.” ");
INSERT INTO abx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Agpapuntuk-nay nan pananglitan si Jesus si mga Parisiyo, pero ga'i mga iya agpanabot. ");
INSERT INTO abx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sanglit aminugad gihapon si Jesus, “Sumatan-ta kam si kamatu'uran, ako i pwirtahan si kuta'-na si mga karniro. ");
INSERT INTO abx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I dimu'an makadahulu'an si ako, iya i mga matangkaw pati' tulisan, pero ga'i amati' ngan anunod si mga iya i mga karniro. ");
INSERT INTO abx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako i pwirtahan. Bisan say i pasallod nga ag'agi si ako, atalwas. Libri mga iya pagsallod pati' paggawas para agpaka'anda' pannabsaban. ");
INSERT INTO abx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","I mga matangkaw padugok hamok pagtangkaw, pagmatay pati' pagpirwisyo. Pero ako padugok pagbuwan si mga iya kinabuhi' ngan para agpangabunda. ");
INSERT INTO abx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako i mahalap mangngataman. I mahalap mangngataman ag'unong si mga karniru-na. ");
INSERT INTO abx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I nagswilduhan manliliwat, ma'in kalugaringun-na i mga karniro nag'ataman-na. Sanglit kon aniya' tidara'on ma'isog hayop, sigurado nga palahi iya ngan ambanan-na i mga karniro. Mangno si panakka-na si ma'isog to hayop, agwararak dayon i mga kakarniruhan. ");
INSERT INTO abx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Palahi i manliliwat kay gana' sapayan-na para si iya kon agkapara'i i mga karniro tungod kay adda may hamok iya nagswilduhan. ");
INSERT INTO abx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ako i mahalap mangngataman. Angilala ako si mga karniru-ko ngan angilala may liwat mga iya si ako. ");
INSERT INTO abx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Akaparihoy to si kami' si Tatay-ko. I Tata' angilala si ako ngan ako may liwat angilala si iya. Pwira pa sinan, ag'unong liwat ako si mga karniru-ko. ");
INSERT INTO abx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aniya' mga karniru-ko nga ma'in parihu-bi sunsatu'o. Papabungyurun-ko kam ngan kinahanglan pabungyud-ko may liwat mga iya. Papakali-ko mga iya si busis-ko basi' ahimo na kam hamok adda puron kakarniruhan nga aniya' adda mangngataman. ");
INSERT INTO abx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sanglit ako aghigugma'-na si Tata' tungod kay andam ako pagpa'unong si kinabuhi'-ko, ngan katapos angkun-koy to gihapon. ");
INSERT INTO abx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gana' sito maka'ala' tikang si ako, pero agpa'unung-koy to kay iya gayod i karuyag-ko. Aniya' gahum-ko pagpa'unong sito ngan aniya' gahum-ko pag'angkon gihapon. Iyay nan i nagmandu'-na si ako si Tatay-ko nga buruhatun-ko.” ");
INSERT INTO abx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tungod sinan mga allingon, atunga' gihapon i mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Malabbat si mga iya i magpaminugad, “Ay kay amati' kam si iya nga nagbawa-bawa si mara'at espirito? Kapay iya.” ");
INSERT INTO abx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero aniya' may magpaminugad, “Ma'in da'inan sinan i pinahallingan-na si a'a nga nagbawa-bawa si mara'at espirito. Pinapa'i-na si mara'at espirito pakapamuklat si mata-na si buta?” ");
INSERT INTO abx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mangno anakka i Pyista si Pagpasagrado si Templo ari si Jerusalem. Tigtugnawon na siray, ");
INSERT INTO abx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ngan ari si Jesus si hawan-na si templo sigi lalangngan ari si Balkun-na si Solomon. ");
INSERT INTO abx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nagpalibutan iya si mga Hebro nga magkuntra si iya ngan nagpinugad, “Day ay pa i kaliyat-na si pagpa'antahak-mo si kami'. Kon ungod nga ka'aw na i Tinu'inan Mannanalwas, sumatin kami'.” ");
INSERT INTO abx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Anaruman si Jesus, “Agsumatan-ta na kam pero ga'i kam agpanutu'o. I mga makagagahom binuhatan naghimu-ko pina'agi si arun-na si Tatay-ko, iya i magpamatu'od kon say gayod ako, ");
INSERT INTO abx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","pero ga'i kam agpanutu'o kay si kamatu'uran ma'in kam sakop si mga inataman-ko. ");
INSERT INTO abx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Agpakali si busis-ko i mga karniru-ko; angilala ako si mga iya ngan mga iya may agsunod si ako. ");
INSERT INTO abx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Agbuwanan-ko mga iya si kinabuhi' nga gana' katapusan-na, ngan ga'i mga iya agkamaratay nga bulag si Diyos. Ga'i mga iya agkasiriyo tikang si gamhanan mga tamburu'-ko. ");
INSERT INTO abx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","I Tatay-ko nga magpumwan si mga iya ato si ako, iya i makagagahom si dimu'an, ngan gana' sito makasiyo tikang si tamburu'-na. ");
INSERT INTO abx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako pati' i Tata' ag'adda hamok.” ");
INSERT INTO abx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sanglit, agpangaddo' gihapon bato i mga Hebro pagtalutog si iya ");
INSERT INTO abx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","pero agpinugad-na dina mga iya si Jesus, “Agpakulaw-ta kam si malabbat pambihira makagagahom binuhatan sigon si nagmandu'-na si ako si Tata' pagbuhat. Singnga sinan mga makagagahom binuhatan i maka'aghat si ka'am pag'itatalutog si ako?” ");
INSERT INTO abx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Ma'in nan iya i rason kon ay kay ag'itatalutugan kami' kaw,” lingun-na sito mga Hebro, “kundi' i pagpakara'at-mo dina si Diyos. Ay kay agpinugad kaw nga Diyos kaw nga adda may kaw hamok a'a?” ");
INSERT INTO abx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Anaruman may si Jesus, “Ma'in ba' aka'anna' si nagtapuran-bi Bala'od nga agpahalling i Diyos sito: ‘Agpinugad ako nga mga diyos kam’? ");
INSERT INTO abx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ga'i akalirungan i Kasuratan sanglit kon da'inan i pag'arun-na si Diyos si mga nagbuwanan si allingun-na, ");
INSERT INTO abx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","iya pa ba' i addangan nga nagtagama-na para hamok pagpabawa ato si kalibutan? Tara', ay may kay agparahimu-himu'an-bi ako kasal'anan nga agpakara'at-ko i Diyos pina'agi si pagpinugad-ko, ‘Ako i Dadi'-na si Diyos’? ");
INSERT INTO abx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dakam ako agtutu'uhu-bi kon ga'i agbuhat-ko i buhat-na mismo si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero kon iya i nagbuhat-ko, bisan kon ga'i may kam dina agtutu'o si ako, kunta' anutu'o kam si mga makagagahom binuhatan naghimu-ko basi' kam agpakatu'anan ngan agpakasayuran nga i Tata' ag'ayop si ako ngan ako may ag'adda si iya.” ");
INSERT INTO abx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tungod sinan, nag'idadakop gihapon iya pero pakawara' iya. ");
INSERT INTO abx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mangno pabwilta si Jesus pada'iray si dambila'-na si Suba' Jordan ari banda si nagparabunyagan-na siray si Juan. Ag'istar iya ari ");
INSERT INTO abx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ngan kalabbatan i pamada'iray si iya ngan agpakapinugad, “Bisan kon gana' sahimu-na si Juan mga pangngilalahan si langitnon kasiguruhan, pero ungod i dimu'an pinahallingan-na mahi'unong sito lalla.” ");
INSERT INTO abx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ngan malabbat ari siray lugar i magpanutu'o si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Aniya' binurungan lalla nag'arunan Lazaro nga taga baryo Betania ngan siyaka-nay to kas Marta pati' Maria. Iyay nan gihapon i Maria nga tibu'bo' pammasangngit si kitid-na si Ginu'o nga i barahibu-na mismo i nagpapahit-na. ");
INSERT INTO abx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sanglit agpatugon i magdingsirarihan danda pagpakatu'an si Jesus, “Paragdalom, maburong i hinigugma'-mo.” ");
INSERT INTO abx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pakapakali-na sinan si Jesus, aminugad iya, “Ma'in kamatayon i panubtuban-na si nag'abat-nay ro. Lugod, i katuyu'an-na si Diyos sito, iya i pagpakulaw si ka'angayan-na basi' adayaw i Dadi'-na si Diyos pina'agi sito.” ");
INSERT INTO abx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aghigugma'-na gayod si Jesus si Marta, hasta i sirari-na danda pati' si Lazaro. ");
INSERT INTO abx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero si pakakatu'an-na nga maburong si Lazaro, agpabilin pa dina iya duwa allaw ari si lugar nag'istaran-na. ");
INSERT INTO abx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mangno, agpinugad-na i mga inadalan-na, “Agbwilta kita kam pan Judea.” ");
INSERT INTO abx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anaruman mga iya, “Pero Rabbi, ma'in pa maliyat nagparatatalutugan kaw si mga punu'-na si mga Hebro, tapos aruyag pa kaw gihapon nga pabwilta ari?” ");
INSERT INTO abx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Anaruman si Jesus, “Ma'in ba' dusi uras i kadanta'an? I a'a nga aglalangngan kon allaw ga'i apangkol, kay akakulaw iya pina'agi si danta'-na si kalibutan. ");
INSERT INTO abx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Apangkol hamok iya kon aglalangngan si sangom kay gana' magdanta' si iya.” ");
INSERT INTO abx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pakapinugad-na sinan, agpadayon iya pagsumat si mga inadalan-na, “Akapaturi i kumpaniya-ta kam Lazaro, sanglit kinahanglan ako pada'iray pagpukaw si iya.” ");
INSERT INTO abx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Anaruman i mga inadalan-na, “Paragdalom, mahalap ngani' kon akapaturi iya basi' tulos anhalap.” ");
INSERT INTO abx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","I karuyag sidngun-na si mga allingun-na si Jesus nga si Lazaro minatay na, pero i pagsabut-na si mga inadalan-na nga natural hamok pagpaturi. ");
INSERT INTO abx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sanglit agdiritsu-na na hamok pagsumat si mga iya, “Minatay na si Lazaro, ");
INSERT INTO abx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngan mas mahalap para si ka'am nga ga'i ako ari kay basi' agpanutu'o kam. Pero pada'iray-ta kam iya si mga iyay ray.” ");
INSERT INTO abx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Katapos amahalling si Tomas, i nag'anga'an Karuwa, pada'iray si mga igkasi-na inadalan, “Hala, amaya' kita kam basi' biyo' lugod ag'urunong.” ");
INSERT INTO abx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Si panakka-na ari kas Jesus, sakatu'anan-na nga ampat allaw na dina si Lazaro ari si kwiba panlalabbungan. ");
INSERT INTO abx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mga tallo kilumitro hamok i katalahan-na si Betania tikang si Jerusalem, ");
INSERT INTO abx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","sanglit malabbat si mga Hebro i pamada'iray si ruma'-na kas Marta pati' Maria pagli'aw si mga iya tungod si kamatay-na si siyaka-na. ");
INSERT INTO abx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngan pakabati'-na si Marta nga titakka si Jesus, pa'amban iya si ruma' pagtupo' sito, pero ga'i pagawas si Maria. ");
INSERT INTO abx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Agpinugad-na si Marta si Jesus, “Paragdalom, kon ato kaw hamok, ga'i kunta' amatay i siyaka-ko. ");
INSERT INTO abx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero akatu'anan ako nga bisan ina'anto pumwan-na si Diyos si ka'aw bisan ay i pinalaku-mo.” ");
INSERT INTO abx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Anaruman si Jesus si iya, “Abanhaw ray siyaka-moy ray.” ");
INSERT INTO abx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Anaruman may si Marta, “Akatu'anan ako nga abanhaw iya si katapusan allaw si kabanhaw-na si dimu'an.” ");
INSERT INTO abx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lingun-na may si Jesus si iya, “Ako i pagkabanhaw pati' i kinabuhi'. Bisan say i magtapod si ako, arallumon bisan kon amatay iya. ");
INSERT INTO abx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ngan bisan say i maka'angkon si ungod kinabuhi' pina'agi si pagtapud-na si ako, ga'i na iya amatay. Anutu'o ba' kaw sito?” ");
INSERT INTO abx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Anaruman iya, “Oho' Paragdalom, agtutu'o ako nga ka'aw i Tinu'inan Mannanalwas, i Dadi'-na si Diyos nga tipada'ito gayod si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pakapinugad-na sinan, agbalik iya ngan agsikritu-na i sirari-na si pagpinugad, “Atiya' i Ma'istro ngan ag'anda'-na kaw.” ");
INSERT INTO abx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pakabati'-na sinan si Maria, pabangon dayon iya ngan agdadagmit pagtupo' si iya. ");
INSERT INTO abx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Siray uras, ga'i pa gayod akasallod si Jesus si baryo, pero ari pa dina si lugar nagtupu'an-na si iya si Marta. ");
INSERT INTO abx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pakakatu'an-na si mga Hebro kahuruwangan-na si Maria nga hintak iya pabangon ngan diritso iya paduwa'i, agpamungyod to si iya kay i mga pagkagasi-na nga pada'iray iya si kwiba naglabbungan pagdinamag. Iyay nan i mga kahuruwangan-na si ruma' magparali'aw si iya. ");
INSERT INTO abx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ngan panakka-na si Maria si naghuwayan-na kas Jesus, sakulawan-nay to dayon mangno pa'akkom iya si kitiran-na ngan aminugad, “Paragdalom, kon ato kaw hamok, ga'i kunta' amatay i siyaka-ko.” ");
INSERT INTO abx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pakakulaw-na si Jesus nga agparadinamag iya hasta i mga Hebro magpamungyod si iya, abantad i kasing-kasing-na ngan tinakka iya kalu'oy. ");
INSERT INTO abx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Amatilaw si Jesus, “Singngay ray iya aghulid-bi?” Anaruman may mga iya, “Paragdalom, amungyura si kami' basi' sakulawan-mo.” ");
INSERT INTO abx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Anuro' i luha'-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mangno, agpaminugad i mga Hebro, “Kulawi-bi, kinakulawan nga aghigugma'-na gayod iya!” ");
INSERT INTO abx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero i ditangnga' si mga iya agpaminugad, “Kon sahimu-na sito a'a nga sapakulaw-na gihapon i buta, pwidi liwat sapugungan-na i kamatayun-na sito a'a.” ");
INSERT INTO abx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Abantad gihapon i kasing-kasing-na si Jesus sanglit padugok iya si naglabbungan. Adday to kwiba nga aniya' nagpatarangka mahaya bato si pwirtahan-na. ");
INSERT INTO abx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aminugad si Jesus, “Ala'u-bi batoy nan.” Amahalling si Marta, i sirari-na si minatay, “Pero Paragdalom, ampat naynan allaw iya nagpa'anna' anan. Sigurado nga mabaho' naynan ina'anto mga ka'urason.” ");
INSERT INTO abx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mangno aminugad si Jesus, “Ga'i ba' kaw agpinugad-ko nga kon anutu'o kaw, akakulaw kaw si ka'angayan-na si Diyos?” ");
INSERT INTO abx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sanglit ag'ala'-na mga iya i bato. Mangno anhangad si Jesus ngan aminugad, “Tay, agpasalamat ako si ka'aw kay agpakali-mo ako. ");
INSERT INTO abx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Akatu'anan ako nga pirmi ako agpakali-mo, pero agpahalling-koy to para si mga a'ay to magpanunggo ato basi' agpanutu'o mga iya nga ka'aw i magpabawa si ako.” ");
INSERT INTO abx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pakatapus-na agpahalling sinan, aman'o makusog si Jesus, “Lazaro, pagawasa anan!” ");
INSERT INTO abx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mangno pagawas i mamatay nga putos si mga tinabas-tabas katsa i langngun-na pati' i mga kalalaki-na sigon si kabatasanan-na mga iya paglabbong ngan i sulang-na may nagpakkos pudung-pudong. Amahalling si Jesus si mga iya, “Bak'ari-bi iya basi' akalibri.” ");
INSERT INTO abx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sanglit malabbat si mga Hebro nga pamada'iray pagbisita si Maria i magpanutu'o na si Jesus kay agpakakulaw mga iya si nagbuhat-na. ");
INSERT INTO abx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kundi' aniya' pa gihapon magpamada'iray si mga Parisiyo pagsumbong si nagbuhat-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mangno i mga puno' paraghalad pati' i mga Parisiyo agpaban'o si bug'os Kunsiho. Agpaminugad mga iya, “Tara', ay i binuhat-ta kam sito? Sigi may to hamok a'a himo si mga pala'in-la'in pangngilalahan si langitnon kasiguruhan. ");
INSERT INTO abx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kon pata'anan-tay to hamok iya, sigurado nga anutu'o i dimu'an si iya, mangno pada'ito i mga taga Roma pagsiyo si pudir si templu-ta kam pati' si panggubyirnuhan-ta kam.” ");
INSERT INTO abx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mangno addangan si mga iya nga nag'arunan Caifas, i gilalabawi paraghalad siray ta'on, i maminugad, “Gana' gayod mga kalibutan-bi! ");
INSERT INTO abx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ga'i ba' kam agpakatu'anan nga mas mahalap para si ka'am kon aniya' addangan nga agpakamatay para si mga a'a kuntra kon abungkag i bug'os nasyon?” ");
INSERT INTO abx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ga'i iya akapinugad sinan si kalugaringun-na hamok, kundi' tungod si pagkagilalabawi-na paraghalad siray ta'on, agdaluman-na iya si Diyos pagsumat andang nga agpakamatay si Jesus para si nasyun-na si mga Hebro, ");
INSERT INTO abx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ngan ma'in hamok para sinan nasyon kundi' pati' si mga magwararak dadi'-na si Diyos basi' agkahuruwang ngan agka'aradda mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mangno tikang siray allaw abug'os na i planu-na si Kunsiho pagmatay si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sanglit aglikay na iya pagparapakulaw si katabbulan-na si mga a'a. Pa'amban iya ari ngan pada'iray si Efraim, adda bungto nga matapit si disyirto. Ag'istar iya ari huwang si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngan matapit na i Pyista-na si mga Hebro nag'arunan Paglabay, malabbat i pamasagka pan Jerusalem tikang si mga kaburubungtuhan. Pamada'iray mga iya para si kinahanglanon nga anlimpyo si pangulawan-na si Diyos myintras anakka i Paglabay. ");
INSERT INTO abx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Agparapanganda'-na mga iya si Jesus, ngan si pagparapanunggu-na mga iya ari si hawan-na si templo, agsipurupatilaway mga iya, “Ay si pag'abat-bi, atiya' na ba' iya mamyista?” ");
INSERT INTO abx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Agmando' i mga puno' paraghalad pati' i mga Parisiyo si bisan say nga makakulaw si Jesus pagsumat dayon basi' sadakup-nay to mga iya. ");
INSERT INTO abx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ngan annom allaw pa myintras anakka i Pyista si Paglabay, anakka kas Jesus si baryo Betania nga nag'istaran-na si Lazaro, i nagbanhaw-na siray. ");
INSERT INTO abx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aniya' tima ari para si Jesus, ngan addangan si Marta si magparabulig pagsirbi, pero si Lazaro agtangka' si lamisa huwang si kas Jesus. ");
INSERT INTO abx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mangno, ag'ala'-na si Maria i naghimus-na tunga' litro pasangngit nga bali kamahalan. Gana' sito salakut-na nga hinimo tikang si tanaman nardo. Agpabu'bu'-nay to si kitid-na si Jesus ngan katapos, mismo i barahibu-na i nagpapahit-na. Sanglit ag'alimwag i bug'os ruma'. ");
INSERT INTO abx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pero andiri' si Judas Iscariote nga addangan si mga inadalan-na nga iya liwat i titraydor si iya. ");
INSERT INTO abx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Agsimul-nay to, “Ay kay ga'i nayto hamok binaligya'an pasangngit ngan pinumwan i bayad-na si mga anggana'? Tingali aballi payto si tris syintos dinari diplata.” ");
INSERT INTO abx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Akapinugad iya sinan ma'in tungod kay aniya' kalu'uy-na si mga anggana', pero tungod kay malanga i tamburu'-na. Iya i mag'inantan si kwarta-na mga iya, ngan pirmi iya agsalingabot sito. ");
INSERT INTO abx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pero anaruman dina si Jesus, “Pata'ani-bi hamok iya! Tama' hamok i paghimus-na sito pasangngit siray ngan angay liwat i nagbuhat-na pag'andam si puhu'-ko kay ma'in na pira ralabbungan na ako. ");
INSERT INTO abx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pirmi aniya' mga anggana' nga sabagatan-bi, pero ma'in na pira, ga'i na ako sabagatan-bi.” ");
INSERT INTO abx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Siray uras, bali labbat si mga Hebro magpakatu'anan nga ari si Jesus. Sanglit aghururuwang mga iya pamada'iray, ma'in hamok tungod si iya pero tungod kay aruyag liwat mga iya pagkulaw si Lazaro nga nagbanhaw-na siray. ");
INSERT INTO abx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sanglit agplanuhan-na liwat si mga puno' paraghalad pagmatay si Lazaro, ");
INSERT INTO abx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kay tungod si iya, malabbat mga Hebro magpamabalyo pada'iray si Jesus ngan agpantapod si iya. ");
INSERT INTO abx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ka'asumuhan, agpakabati' i kalabbatan magpantambong si Pyista nga tidara'on na si Jesus si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sanglit agpanabtab mga iya si mga day paklang-na si pinang. Pagawas mga iya si syudad pagtupo' si iya ngan sigi panggasod: Hosanna! Malipayon gayod i a'a nga pada'ito pina'agi si gahum-na si Paragdalom Diyos! Malipayon i Hadi'-na si Israel! ");
INSERT INTO abx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Si pakabagat-na si Jesus si adda asno, agkabayuhan-nay to sigon si maka'anna' si Kasuratan: ");
INSERT INTO abx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Dakam agkataralaw, ka'am mga taga Sion; kulawi-bi, awira' na i hadi'-bi, ngan agkabayo si nati-na si adda asno. ");
INSERT INTO abx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ga'i dahulo agpakasabot sito i mga inadalan-na. Kahuman pag'alsa si Jesus pagpa'unra si iya, iya na dina i panabut-na si mga inadalan nga si Jesus may bali' i nagtukoy si maka'anna' si Kasuratan ngan agpamuhat-nay to mga iya para si iya. ");
INSERT INTO abx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sigi panumat i mga a'a nga magpakakulaw si iya ngan pagban'u-na si Lazaro si labbong pati' ngan pagbanhaw-na sito. ");
INSERT INTO abx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ngan i mga a'a may magpakapamati' nga si Jesus i maghimo sito pangngilalahan si langitnon kasiguruhan, pamagawas liwat pagtupo' si iya. ");
INSERT INTO abx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sanglit agsipurupinugaray i mga Parisiyo, “Gana' gayod sahimu-ta kam. Kulawi-bi daw, i bug'os kalibutan awiray padugok si iya!” ");
INSERT INTO abx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Aniya' mga Griko magpamungyod si magpamada'iray si Jerusalem pag'ampo' kay Pyista si Paglabay. ");
INSERT INTO abx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Padugok mga iya si Felipe nga taga Betsaida, Galilea ngan agpaminugad, “Sinyor, aruyag kami' makibagat si Jesus.” ");
INSERT INTO abx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pa'amban si Felipe pagsumat si Andres ngan aghuwang mga iya duwangan pagsumat si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Anaruman si Jesus si mga iya, “Iya nayto i uras nga tinuman na i maka'angayan pagdayaw si Pinili' A'a. ");
INSERT INTO abx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sumatan-ta kam si kamatu'uran: I liso nga nagpa'uga mangno nagpatanom, day mamatay na. Pero kon ga'i iya ag'agi sito, agpabilin to adda hamok liso. Kundi' pina'agi si kamatayun-na, anudok to ngan agbuwa' malabbat. ");
INSERT INTO abx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","I a'a magpasi'urog si kalugaringun-na kinabuhi' ina'anto, iya dina i magkarag si dimu'an tawa'-na hasta pa i kinabuhi'-na. Pero i a'a nga agsikway si kinabuhi'-na ato si kalibutan, iya dina i magpadayon pag'antan si ungod kinabuhi' hasta si kahastahan. ");
INSERT INTO abx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kinahanglan agsunod si ako i maruyag magsirbi si ako, kay bisan singnga ako, awiray may liwat i rilihugun-ko. Papa'unrahan-na si Tatay-ko bisan say i manirbi si ako. ");
INSERT INTO abx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Masamok gayod i pamurubu'ut-ko ina'anto ngan ga'i ako akatu'anan kon ay i angay parahallingun-ko. Ga'i ako akapinugad, ‘Tatay-ko, librihon ako si manakka ina'anto uras,’ kay si kamatu'uran, i nagpapada'ituhan si ako si kalibutan, iya i pag'antos si kakurihan-na sito uras. ");
INSERT INTO abx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sanglit aminugad ako, ‘Tatay-ko, pakulawon i ka'angayan-na si arun-mo!’” Mangno aniya' kinabati'an busis tikang si langit nga agpinugad, “Human naynan ka'angayan agpakulaw-ko ngan urutruhun-koy nan gihapon.” ");
INSERT INTO abx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Akabati' siray busis i magpanggubok ari ngan agpaminugad dina, “Agparadalugdog!” I ditangnga' may agpaminugad, “Aniya' siguro anghel magbagaw si iya.” ");
INSERT INTO abx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pero aminugad si Jesus si mga iya, “Ma'in nan para si ako mga allingon, kundi' para dina si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ina'anto na i paghusgar si kalibutan. Tarabrugon na ina'anto i prinsipi-na si karat'an sito kalibutan. ");
INSERT INTO abx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero si pangalsa-na mga iya si puhu'-ko tikang si pitak, paduguk-ko i dimu'an si ako.” ");
INSERT INTO abx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Agpahalling-nay nan basi' sapahayag-na i pa'agi si kamatayon aragihan-na. ");
INSERT INTO abx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Amahalling i mga a'a, “Akatu'anan kami' tikang si Bala'od nga agpadayon i pagtinagal-na si Tinu'inan Mannanalwas, ay may kay agpinugad kaw nga aralsahon i Pinili' A'a? Say may i Pinili' A'a?” ");
INSERT INTO abx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mangno agsumatan-na mga iya si Jesus, “Ma'in na gayod maliyat i paghuwang-na si ka'am si danta', sanglit myintras nga atiya' pa padagusu-bi i kinabuhi'-bi antis kam akatambunan si kalu'uman. I a'a nga maglalangngan si kalu'uman ga'i akatu'anan kon singnga iya pa'arop. ");
INSERT INTO abx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sanglit tapuri-bi i danta' myintras awinan pa iya si ka'am, basi' agkahirimo kam nga mga dadi'-na si kadanta'an.” Pakatapus-na agpahalling si Jesus, pa'amban iya ngan ga'i na pakulaw si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan kahuman-na si Jesus paghimo sinan mga pangngilalahan si langitnon kasiguruhan mismo atubang si mga iya, ga'i pa hamok gihapon mga iya agtutu'o si iya. ");
INSERT INTO abx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ahinabo' to basi' atuman i mga allingun-na siray si paragsumat Isaias, “Paragdalom, say i manutu'o si sumat kami', ngan say i nagpakatu'anan si gahum-na si Paragdalom?” ");
INSERT INTO abx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ngan akatu'anan kita kam kon ay kay ga'i mga iya agpakatutu'o tungod si la'in pa pinahallingan-na si Isaias, ");
INSERT INTO abx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Agbutahan-na mga iya si Diyos ngan aghimu-na mga iya mga bulok hasta nga gana' na gayod pamurubu'ut-na, basi' sigi buruslungay pero gana' mga sakulawan-na ngan basi' ga'i agpakaklaruhan i mga inisipan-na. Kon ma'in da'inan sinan, abawa na kunta' mga iya pagtu'o si Diyos ngan sapahalap-ko mga iya.” ");
INSERT INTO abx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Akapahalling sinan si Isaias tungod kay sakulawan-na i maka'angayan kamutangan tarakkahun-na si Jesus. Sanglit i nagtukoy sinan mga allingon, iya si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero si kamatu'uran, malabbat i magpanutu'o si iya bisan si mga punu'an. Pero tungod si ditangnga' mga Parisiyo, aghilum-na hamok mga iya i mga pagtu'u-na. Ga'i mga iya agbusngal sito tungod kay agkataralaw mga iya nga pina'itsapwira si sinaguga. ");
INSERT INTO abx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ag'andoy dina mga iya si pagdayaw-na si a'a kuntra si pagdayaw-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tungod sinan, si pangultimo na gayod pagpaki'atubang-na si Jesus si mga a'a myintras si ga'i na pagpakulaw-na si mga iya, amahalling iya makusog, “Kon i a'a anutu'o si ako, ma'in hamok ako i nagtutu'u-na kundi' hasta pa i magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Si pangulaw-na si ako, sakulawan-na may liwat i magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Pada'ito ako bilang danta' si kalibutan, basi' ga'i ag'istar si kalu'uman i bisan say nga anutu'o si ako. ");
INSERT INTO abx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ngan para namay si a'a nga akapamati' si mga allingun-ko pero ga'i agtuman-na, ga'i ako agpatok si iya. Kay pada'ito ako ma'in pagpatok si kalibutan kundi' pagsalbar dina. ");
INSERT INTO abx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aniya' maghusgar para si magdiri' si ako ngan ga'i ag'ako' si mga allingun-ko. I allingon nagpahalling-ko, iya mismo i mamatok si iya si damuri allaw. ");
INSERT INTO abx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ga'i ako agpahalling para si kalugaringun-ko hamok, kundi' agmandu'an-na ako si Tatay-ko kon ay i pinahalling-ko pati' kon pinapa'i-ko pagsumat. ");
INSERT INTO abx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Katu'anan ako nga i nagmandu'-na si ako akapatuttot si kinabuhi' nga gana' katapusan-na. Sanglit bisan ay i karuyag-na si Tatay-ko, iya hamok i nagpahalling-ko.” ");
INSERT INTO abx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anakka na i Bispira si Pyista si Paglabay, ngan sakatu'anan-na si Jesus nga titakka na liwat i uras si pag'amban-na ato si kalibutan, pagbalik pada'iray si Tatay-na. Aghigugma'-na i mga ginsakupan-na ato si kalibutan, ngan ina'anto agpamakulaw-nay to kon singnga gayod takka i gugma'-na. ");
INSERT INTO abx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ngan paglulu'om na, amangan mga iya. Agbuwanan-na na dina si Satanas mara'at inisipan si Judas Iscariote nga dadi'-na si Simon pagtraydor si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pero akatu'anan si Jesus nga agbuwanan-na iya si Tatay-na si gahom pagdalom si dimu'an, nga tikang iya si Diyos, ngan tibalik gihapon si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tungod sinan, anunggo iya si nagkakanan-na ngan aghugkas-na dayon i badu'-na ngan agtapis iya tu'alya. ");
INSERT INTO abx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mangno amabu'bo' iya buwahi' si adda planggana, agpanawsawan-na sa'uru'addangan i kitid-na si mga inadalan-na pati' agpahitan-na si tu'alya. ");
INSERT INTO abx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ngan padugok iya si Simon Pedro, aminugad to dayon si iya, “Paragdalom, agtuyo' ba' kaw gayod pagsawsaw si kitid-koy to?” ");
INSERT INTO abx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Anaruman may si Jesus, “Si ina'anto, ga'i pa sasayuran-mo buruhatun-koy to, pero si damuri allaw sasabutan-moy to gihapon.” ");
INSERT INTO abx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aminugad may si Pedro, “Dakaw, ga'i pwidi nga sawsawan-mo kitid-koy to.” Anaruman gihapon si Jesus, “Kon ga'i kaw sasawsawan-ko, gana' na labut-mo si ako.” ");
INSERT INTO abx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aminugad may si Pedro, “Paragdalom, kon da'inan sinan, ma'in hamok kitid-koy to, pero hasta pa mga tamburu'-koy to pati' takuluk-ko.” ");
INSERT INTO abx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Anaruman si Jesus, “I a'a nga human na agpamandi bali na kalimpyado i puhu'-na, sanglit i kitid-na na hamok i kinahanglan nagsawsawan. Ngan ka'am mga limpyado na pwira si addangan.” ");
INSERT INTO abx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Akapinugad iya nga ma'in mga iya dimu'an limpyado tungod kay sakatu'anan-na may kon say i titraydor si iya. ");
INSERT INTO abx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kahuman pagpanawsaw si mga kitid-na, pasul'ut-na gihapon i naghugkas-na ngan agbalik si pwistu-na. Mangno agpatilawan-na mga iya, “Sasabutan-bi ba' i nagbuhat-ko si ka'am? ");
INSERT INTO abx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Agban'u-bi ako, Ma'istro pati' Paragdalom, ngan tama' nan kay da'inan ako sinan. ");
INSERT INTO abx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kon sugad, tungod kay ako nga Paragdalum-bi pati' Ma'istru-bi i magsawsaw si mga kitid-bi, kinahanglan agsisurusawsaway may liwat kam balang addangan. ");
INSERT INTO abx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Agbuwanan-ta na kam pangngingirugan basi' sabuhat-bi i nagbuhat-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sumatan-ta kam si kamatu'uran, gana' ato rilihugon nga labaw dina kuntra si amu-na o ma'in ngani' nga i naglihog labaw kuntra si maglihog. ");
INSERT INTO abx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ma'in hamok nga basta sakatu'anan-bi to, kundi' mga buruwanan kam si mga kabubuwasun-bi kon kinakulawan to anan si ka'am.” ");
INSERT INTO abx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Agpadayon pagpahalling si Jesus, “Ma'in i nagtukuy-ko nga ka'am dimu'an akatapunan kay sakilala-ko i mga pinili'-ko. Pero ahinabo' to basi' atuman i maka'anna' si Kasuratan: ‘Aniya' magpararudong pirmi si ako nga anguntra dina.’ ");
INSERT INTO abx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Agsumatan-ta na kam andang ina'anto myintras to ahinabo', basi' kon ahinabo' nayto agpanutu'o kam nga akoy ray mismo nagpakilala-koy ray si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sumatan-ta kam si kamatu'uran, bisan say mag'ako' si nagpabawa-ko, ag'aku'-na may liwat ako ngan bisan say mag'ako' si ako, ag'aku'-na may hasta i magpabawa si ako.” ");
INSERT INTO abx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Katapus-na pagpahalling sinan si Jesus, nagsamukan gayod iya si inisipan-na. Mangno aminugad, “Sumatan-ta kam si kamatu'uran, addangan gayod si ka'am i titraydor si ako.” ");
INSERT INTO abx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Agsitirili'-tili'ay i mga inadalan-na ngan agkabururong kon say si mga iya i nagtukuy-na. ");
INSERT INTO abx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aniya' addangan si mga inadalan-na si Jesus magtingpid si iya nga hinigugma'-na gayod. ");
INSERT INTO abx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Agsinyasan-nay to inadalan si Simon Pedro ngan agpinugad-na, “Patilawin iya kon say i nagtukuy-na.” ");
INSERT INTO abx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sanglit pasandi iya si Jesus ngan amatilaw, “Paragdalom, say i nagpinugad-mo?” ");
INSERT INTO abx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Anaruman may si Jesus, “Kon say i binuwanan-ko si papaduldulun-koy to pan si mangko', iya naynan.” Mangno pakapaduldul-na si pan, pumwan-na dayon pada'iray si Judas Iscariote nga dadi'-na si Simon. ");
INSERT INTO abx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pakakarawat-na si Judas si pan, ag'ayupan-na na dayon iya si Satanas. Agpinugad-na iya si Jesus, “Kon ay i buruhatun-mo, buhaton dayon ina'anto.” ");
INSERT INTO abx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero gana' magpanabot si magpanangka' si pagkakanan kon apa'i kay agyawit iya sinan. ");
INSERT INTO abx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gasi-na hamok si ditangnga' nga aniya' nagpaballi-na si Jesus si Judas mga kinahanglanon para si Pyista o ma'in ngani' pagbuwan si mga anggana' kay iya may i mag'inantan si kwarta. ");
INSERT INTO abx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sanglit pakakarawat-na si Judas si pan, pagawas iya ngan bali na dayon lu'om siray. ");
INSERT INTO abx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pa'amban-na si Judas, aminugad si Jesus, “Ina'anto papakulawon i ka'angayan-na si Pinili' A'a ngan tungod si tihinabo' si iya papakulawon liwat i ka'angayan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si pakakulaw na sito tungod si mahinabo' si Dadi', i Diyos namay i maniguro pagpakulaw si ka'angayan-na si Dadi' pina'agi si kalugaringun-na buhat para si Dadi', ngan sigurado nga pakulaw-nay to dayon. ");
INSERT INTO abx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mga dadi'-ko, ma'in na maliyat i paghururuwang-ta kam. Sinan uras, sigi kam hamok panganda' si ako. Ngan pariho si nagsumat-ko siray si mga punu'-na si mga Hebro, sumatan-ta kam ina'anto, ‘Ga'i kam akadiritso si parada'irayan-ko.’ ");
INSERT INTO abx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Sanglit, bilinan-ta kam baha'o sugo': Agsihirigugma'aya kam. Kinahanglan agsihirigugma'ay kam, pariho gihapon si paghigugma'-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si da'ito pa'agi, kinatu'anan si dimu'an nga mga inadalan-ta kam.” ");
INSERT INTO abx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sanglit amatilaw si Simon Pedro, “Paragdalom, kay singnga kaw pa'arop?” Anaruman may si Jesus, “Si parada'irayan-ko, ga'i kaw akalanat dayon, pero akalanat kaw gihapon si damuri allaw.” ");
INSERT INTO abx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Amatilaw gihapon si Pedro, “Paragdalom, kapa'i may kay ga'i ako pwidi akalanat si ka'aw ina'anto? Karagan-ko kinabuhi'-koy to para hamok si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mangno anaruman si Jesus, “Ungod ba' gayod nga karagan-mo kinabuhi'-moy nan para si ako? Sumatan-ta kaw si kamatu'uran, myintras anutturu'ok i manok, sin tallo na kaw dina agdidiwaray nga ga'i ako sakilala-mo!” ");
INSERT INTO abx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Agpinugad-na si Jesus i mga inadalan-na, “Dakam agpasamuku-bi i mga inisipan-bi, agtapura kam si Diyos ngan agpanapura liwat kam si ako. ");
INSERT INTO abx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Malabbat i mga kwarto ari si ruma'-na si Tatay-ko. Kon ma'in to ungod, ga'i kam sumatan-ko sito. Tipada'iray na ako pag'andam para si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kon pada'iray ako ngan ag'andam para si ka'am, pabwilta ako ato ngan bawa-ta kam paghuwang si ako basi' kon singnga ako, ari may kam. ");
INSERT INTO abx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Akatu'anan na kam si pangngagihan si parada'irayan-ko.” ");
INSERT INTO abx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aminugad may si Tomas, “Paragdalom, ga'i kami' akatu'anan kon palingnga kaw. Pinapa'i may kami' akatuttot si pangngagihan?” ");
INSERT INTO abx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Anaruman si Jesus, “Ako i pangngagihan, i kamatu'uran, pati' i kinabuhi'. Gana' makapada'iray si Tata' kon ga'i ag'agi si ako. ");
INSERT INTO abx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kon ungod gayod ako sakilala-bi, akakilala may liwat kam si Tatay-ko. Tikang ina'anto, sakilala-bi na iya ngan sakulawan-bi.” ");
INSERT INTO abx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aminugad si Felipe, “Paragdalom, pakulawon kami' si Tata'; iyay nan hamok i nagkinahanglan kami'.” ");
INSERT INTO abx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Anaruman si Jesus, “Ga'i pa ba' kaw hamok gihapon angilala si ako Felipe bisan kon maliyat na panahon nga aghuwang-huwang ako si ka'am dimu'an? Kon say makakulaw si ako, akakulaw may si Tata'. Ay kay akapinugad kaw, ‘Pakulawon daw si kami' i Tata'’? ");
INSERT INTO abx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ga'i ba' kaw anutu'o nga ako ag'adda si Tata' ngan i Tata' may ag'ayop si ako? I nagpahalling-ko si ka'am ma'in kinalugaringun-ko kundi' tikang si Tata' nga atiya' ag'ayop si ako ngan agbuhat iya si karuyag-na trabaho. ");
INSERT INTO abx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Anutu'uha kam si ako kon aminugad ako, nga ag'adda ako si Tata' ngan i Tata' may ag'ayop si ako, o ma'in ngani', anutuhu'a kam sigon si mga makagagahom binuhatan naghimu-ko. ");
INSERT INTO abx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sumatan-ta kam si kamatu'uran, bisan say magtutu'o si ako, buhat-na may i nagbuhat-ko, ngan anmas pa i sabuhat-na sito kay pada'iray ako si Tata'. ");
INSERT INTO abx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Buhat-ko bisan ay i pinalaku-bi pina'agi si arun-ko basi' kinakulawan i ka'angayan-na si Tata' pina'agi si Dadi'. ");
INSERT INTO abx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pwidi kam amalako bisan ay pina'agi si arun-ko ngan sigurado nga buhat-koy nan. ");
INSERT INTO abx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kon aghigugma'-bi ako, satuman-bi i mga nagmandu'-ko. ");
INSERT INTO abx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Amalako ako si Tatay-ko ngan buwanan-na kam la'in Paragsagdon ");
INSERT INTO abx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","nga iya i Espirito magpasayod si kamatu'uran nga aghuwang si ka'am hasta si kahastahan. Ga'i iya nagkarawat si kalibutanon pa mga a'a tungod kay ga'i mga sakulawan-na ngan ga'i mga sakilala-na. Pero sakilala-bi iya kay awinan na iya aghuwang si ka'am ngan ti'ayop iya si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ga'i kam ambanan-ko nga day mga ilo hamok. Agbwilta gihapon ako si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ma'in na pira, ga'i na ako sakulawan-na si kalibutan, pero sakulawan-bi ako gihapon. Tungod kay gana' si ako makasiyo si ungod kinabuhi', padayon may liwat i mga kinabuhi'-bi. ");
INSERT INTO abx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sinan uras, sasantup-bi nga pariho si pag'adda-ko si Tatay-ko, ag'adda may kam si ako ngan ako may ag'ayop si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bisan say mangarawat si mga nagmandu'-ko ngan agtuman-na, aghigugma' si ako. Bisan say maghigugma' si ako, higugma'-na may si Tatay-ko. Higugma'-ko may liwat iya ngan pasayud-ko si iya i kalugaringun-ko.” ");
INSERT INTO abx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mangno aminugad may si Judas nga ma'in Iscariote, “Paragdalom, pinapa'i may sapasayud-mo i kalugaringun-mo nga si kami' hamok pero ma'in si bug'os kalibutan?” ");
INSERT INTO abx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Anaruman may si Jesus, “Bisan say maghigugma' si ako, agsunod si mga nagturu'-ko. Aghigugma'-na iya si Tatay-ko, ngan kami' na si Tata' maghuwang pagdugok si iya basi' aka'istar anan si kasing-kasing-na. ");
INSERT INTO abx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","I ga'i maghigugma' si ako, ga'i may liwat agsunod si mga nagturu'-ko. Ma'in to tikang si ako mga sapakalihan-bi to allingon, kundi' tikang to si Tata' nga magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yayto dimu'an agpahalling-ko ina'anto si paghuwang-ko pa si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero i Paragsagdon nga iya i Espirito Santo, nga papabawahun-na si Tata' magsalli' si ako, iya i manuro' si ka'am si dimu'an ngan magpa'intom si ka'am si intiro mga nagpamahalling-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Bilin-ko si ka'am i kamurayaw; i kamurayaw nga tawa'-ko gayod pumwan-ko si ka'am. Ma'in to pariho si nagpumwan-na si mga kalibutanon a'a. Dakam agpasamuku-bi i mga inisipan-bi, ngan dakam agkataralaw. ");
INSERT INTO abx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Agpakapakali kam ngan pagpinugad-ko, ‘Titaliwan ako pero tipada'ito ako gihapon si ka'am.’ Kon aghigugma'-bi ako, kunta' agkarilipay kam si pagpada'iray-ko si Tata', tungod kay labaw i Tata' kuntra si ako. ");
INSERT INTO abx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Agsumat-koy to si ka'am ina'anto myintras nga ga'i pa ahinabo' basi' kon ahinabo' nayto, agpanutu'o kam nga kamatu'uran i nagsumat-ko. ");
INSERT INTO abx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma'in na maliyat i pagpakihampang-ko si ka'am kay tipada'ito na i prinsipi si karat'an ato si kalibutan. Ga'i iya akadalom si ako, ");
INSERT INTO abx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero kinahanglan nga akasayod i kalibutan nga aghigugma'-ko i Tata' ngan agsunud-ko gayod i nagmandu'-na. Hala! Tana na kam paduwa'i ato sito ruma'.” ");
INSERT INTO abx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Agpadayon si Jesus pagpahalling, “Ako i ungod pu'un-na si ubas, ngan i Tatay-ko may i mangngataman. ");
INSERT INTO abx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ag'utud-na i kada sanga-ko nga ga'i agbuwa' ngan agkaparan-na i aniya' buwa'-na basi' sigi pa hahaya i inala'an-na sito. ");
INSERT INTO abx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pariho si nagkaparan, akalimpyuhan na kam pina'agi si pag'aku'-bi si allingon nga nagturu'-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Padayuna kam pagpaki'adda si ako ngan ako may padayon pagpaki'adda si ka'am. Gana' ato sanga nga akalugaring pagbuwa'. Kinahanglan nga pirmi to agdukot si pu'on. Da'inan may si ka'am, ga'i kam agpakabuwa' pwira na kon padayon kam pagpaki'adda si ako. ");
INSERT INTO abx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ako i pu'on ngan ka'am i mga sanga. Kon padayon kam pagpaki'adda si ako ngan ako may liwat si ka'am, agpamuwa' kam malabbat. Kon bulag kam si ako, gana' sahimu-bi. ");
INSERT INTO abx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bisan say i ga'i padayon pagpaki'adda si ako, akapariho iya si sanga nga nagtapukan ngan a'uga. Angay hamok nagtipon i da'inan klasi mga sanga basi' agpakabar'ugan. ");
INSERT INTO abx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kundi' kon padayon kam pagpaki'adda si ako ngan kon padayon kam pagpanginano si mga allingun-ko, sa'angkun-bi bisan ay nag'ungara'-bi. ");
INSERT INTO abx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Agsara i ka'angayan-na si Tatay-ko tungod kay sigi lalabbat i mga binuwa'-bi, ngan pina'agi sito, sigi may liwat kaklaro nga ka'am i mga inadalan-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Aghigugma'-ko kam irog gayod si paghigugma'-na si ako si Tata'. Dakam pabulag si paghigugma'-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kon agtuman-bi i mga nagmandu'-ko, ga'i kam pabulag si gugma'-ko, pariho si pagtuman-ko si mga nagmandu'-na si Tatay-ko pati' i ga'i pagbulag-ko si gugma'-na. ");
INSERT INTO abx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Agpasumat-koy to si ka'am basi' sa'abat-bi may i kalipayan nag'abat-ko, ngan basi' abug'os i kalipay-bi. ");
INSERT INTO abx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yayto i nagmandu'-ko si ka'am: Agsihirigugma'aya kam irog si paghigugma'-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gana' na manlabaw pa si paghigugma'-na si addangan nga ag'unong para si mga kumpaniya-na. ");
INSERT INTO abx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngan mga kumpaniya-ta kam kon tuman-bi i mga nagmandu'-ko si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ga'i na kam kwinta-ko nga mga rilihugun-ko, kay i rilihugon ga'i akatu'anan si dimu'an planu-na si amu-na. Lugod, kwinta-ko na kam nga mga kumpaniya, kay agpasumat-ko si ka'am i dimu'an mga sabati'an-ko tikang si Tatay-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma'in ka'am i magpili' si ako, kundi' ako dina i magpili' si ka'am pati' i magtu'in nga pamalangngan kam ngan pagbuwa' malabbat, mga buwa' nga gana' kawawara'un-na. Mangno pumwan-na si ka'am si Tatay-ko i bisan ay nagpalaku-bi si iya pina'agi si gahum-na si arun-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yayto i nagmandu'-ko si ka'am: Agsihirigugma'aya kam. ");
INSERT INTO abx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kon aghumot si ka'am i mga kalibutanon a'a, dakam alimot nga ako i primiro naghumutan-na sito. ");
INSERT INTO abx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kunta' kon sakop pa kam si kalibutan sigurado higugma'-na kam sito pariho si paghigugma'-na sito si mga ginsakupan-na. Pero kay ma'in na, ngan tungod kay ako mismo i magpili' si ka'am basi' akabulag kam si dati nagsakupan-bi, bali mga iya i paghumut-na si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Intumu-bi i mga allingon nagsumat-ko si ka'am: ‘Gana' ato rilihugon nga labaw kuntra si amu-na.’ Kon sugad, kon agpasakitan-na ako mga iya, pasakitan-na may liwat kam. Kon agsunud-na mga iya i mga nagturu'-ko, sunud-na may liwat i mga nagturu'-bi. ");
INSERT INTO abx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Da'ito sito i binuhat-na mga iya si ka'am tungod si pagpaki'adda-bi si ako, kay ga'i mga iya agpakakilala si magpabawa si ako. ");
INSERT INTO abx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kon ga'i ako kunta' pada'ito si kalibutan ngan agturo' si mga iya, gana' kunta' mga iya baratunun-na si sala' si pagdiri'-na mga iya si ako. Sanglit ina'anto, gana' na rasun-na mga iya parti si mga sala'-na. ");
INSERT INTO abx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bisan say magkuntra si ako, kuntra-na may liwat hasta pa i Tatay-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kon ga'i kunta' ako agbuhat atubang si mga iya si mga makagagahom binuhatan nga gana' la'in makahimo, gana' kunta' mga iya baratunun-na sinan sala'. Pero bisan kon agpakakulaw mga iya sito mga makagagahom binuhatan, agkuntra-na pa hamok ako gihapon mga iya hasta pa i Tatay-ko. ");
INSERT INTO abx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero ahinabo' to basi' atuman i maka'anna' si nagtapuran-na mga iya Bala'od: ‘Agkuntra-na ako mga iya bisan kon gana' tama' rason.’ ");
INSERT INTO abx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Si panakka-na si Paragsagdon nga papabawahun-ko si ka'am tikang si Tata', nga iya i Espirito magpasayod si kamatu'uran nga paguwa' tikang si Tata', iya i manistigos mahi'unong si ako. ");
INSERT INTO abx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pero kinahanglan liwat nga tistigusan-bi ako tungod kay aghururuwang may kita kam tikang si katikang. ");
INSERT INTO abx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Agsumat-koy to dimu'an basi' ga'i kam pamalisa si pagtu'u-bi. ");
INSERT INTO abx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Para'itsapwirahun-na kam mga iya si sinaguga. Si kamatu'uran titakka i uras nga kon aniya' si ka'am magmatay, i pagkagasi-na nga pina'agi sito buhat akasirbi iya si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Buhat-nay to mga iya tungod kay ga'i mga iya akakilala si Tata' ngan da'inan may si ako. ");
INSERT INTO abx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Agsumatan-ta kam sito basi' si panakka-na sinan uras, agpaka'intom kam nga dati na kam agpada'anan-ko. Siray, ga'i kam dahulo agsumatan-ko tungod kay pirmi may kita kam aghururuwang. ");
INSERT INTO abx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ina'anto tipada'iray na ako ari si magpabawa si ako, pero ga'i kam manginano si tarakkahan-ko. ");
INSERT INTO abx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lugod, panno' kam dina si kabido' tungod kay agsumatan-ta kam si mga titakka hinabo'. ");
INSERT INTO abx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero sumatan-ta kam si kamatu'uran: Para si kahalapan-bi i pagtaliwan-ko. Hasta nga ga'i ako pa'amban, ga'i may liwat pada'ito i Paragsagdon. Pero kon pa'amban ako, pabawa-ko iya pada'ito si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Si panakka-na, iya i magpamatu'od nga amuklat kunta' i mga kalibutanon a'a mahi'unong kon ay i sala', kon ay i pagkamatadong, pati' kon ay i paghusgar. ");
INSERT INTO abx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iya i manmuklat si a'a si sala' nga aniya' pa baratunun-na tungod kay ga'i iya agtutu'o si ako. ");
INSERT INTO abx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iya i manmuklat si a'a si pagkamatadung-ko tungod kay pabwilta na ako si Tata' ngan ga'i na ako sakulawan-bi. ");
INSERT INTO abx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iya liwat i manmuklat si a'a si gana' makalikay paghusgar tungod kay i prinsipi si karat'an nagpatukan na dina. ");
INSERT INTO abx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Bali pa kunta' labbat i mga parahallingun-ko si ka'am, pero ga'i pa sa'agwanta-bi ina'anto. ");
INSERT INTO abx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero kon anakka na i Espirito magpasayod si kamatu'uran, iya i magpadayon pagpamuklat ngan pagpasunod si ka'am si dimu'an nga kamatu'uran. Ga'i iya amahalling si kinalugaringun-na hamok, kundi' amahalling iya si mga sapakalihan-na ngan sumatan-na kam si mga titakka hinabo'. ");
INSERT INTO abx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iya i mamakulaw si ka'am si ka'angayan-ko pina'agi si pag'ala' si tawa'-ko pati' pagpakatu'an sito si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","I dimu'an nga tawa'-na si Tata', tawa'-ko. Sanglit akapinugad ako, ti'ala' i Espirito si mga tawa'-ko, kay iya i tipakatu'an si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ga'i na agliyat nga sakulawan-bi pa ako pero ga'i may liwat agliyat nga sakulawan-bi ako gihapon.” ");
INSERT INTO abx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aniya' si mga inadalan-na nga agsipurupinugaray, “Ay daw i karuyag sidngun-na si pagpinugad, ‘Ga'i na agliyat nga sakulawan-bi pa ako pero ga'i may liwat agliyat nga sakulawan-bi ako gihapon,’ pati' ‘Tungod kay pada'iray ako si Tata'’?” ");
INSERT INTO abx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sigi hamok mga iya paminugad, “Ay i karuyag sidngun-na si ‘ga'i na agliyat’? Ga'i kita akasantop si nagparayawit-na.” ");
INSERT INTO abx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Akatu'anan si Jesus nga aruyag kunta' mga iya pagpatilaw sito si iya sanglit agpaminugad-nay to, “Ga'i ba' kam agpanabot si karuyag sidngun-ko si pagpinugad, ‘Ga'i na agliyat nga sakulawan-bi pa ako pero ga'i may liwat agliyat nga sakulawan-bi ako gihapon’? ");
INSERT INTO abx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sumatan-ta kam si kamatu'uran, agpamanangis kam ngan agkabirido' pero i kalibutan agkalipay. Agkabirido' kam pero i kabidu'-bi akasalli'an kalipayan. ");
INSERT INTO abx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I danda nga agbati' ag'abat kakurihan tungod kay anakka na i uras-na pero kon aka'alluman na iya, salimutan-na i pagsakit-na tungod si kalipay-na si baha'o ma'allom dadi'-na. ");
INSERT INTO abx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Da'inan may si ka'am: Ina'anto i uras si kabidu'an-bi, pero bwilta-ko kam gihapon ngan sigurado nga bali i kalipayan-bi. Gana' bisan say makabawi' si kalipayan-bi. ");
INSERT INTO abx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sinan uras, ga'i na kam amatilaw pa si ako parti si bisan ay. Sumatan-ta kam si kamatu'uran, pumwan-na si ka'am si Tatay-ko i bisan ay nga pinalaku-bi pina'agi si arun-ko. ");
INSERT INTO abx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pero tubtob ina'anto, gana' pa gayod nagpalaku-bi pina'agi si arun-ko. Amalakuha kam basi' kam agpakakarawat ngan sigurado nga abug'os i kalipay-bi. ");
INSERT INTO abx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Bisan kon agpahalling ako pina'agi si mga malalom allingon, titakka i uras nga ga'i na gamit-ko i da'inan klasi pagpahalling kundi' sumatan-ta kam diritso mahi'unong si Tatay-ko. ");
INSERT INTO abx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sinan allaw, amalako na kam pina'agi si arun-ko. Ga'i ako agpinugad nga ako mismo i mamalako si Tata' para si ka'am. ");
INSERT INTO abx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ma'in ministir kay aghigugma'-na may kam si Tata' tungod kay aghigugma'-bi may ako ngan agtutu'o kam nga tikang ako si Diyos. ");
INSERT INTO abx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tikang ako si Tata' ngan pada'ito si kalibutan. Ina'anto pa'amban ako ato si kalibutan ngan agbalik pada'iray si Tata'.” ");
INSERT INTO abx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mangno aminugad i mga inadalan-na si Jesus, “Ina'anto klarado gayod i mga nagpahalling-mo. Ga'i kaw aggamit si mga malalom allingon. ");
INSERT INTO abx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ina'anto pa hamok panabot kami' nga sakatu'anan-mo i bisan ay ngan sakatu'anan-mo bisan i paratilawun-na si bisan say. Iyay nan i maka'aghat si kami' pagtutu'o nga ungod tikang kaw si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Ungod ba' nga agpanutu'o na kam gayod?” lingun-na may si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Titakka i uras ngan si kamatu'uran ma'in na pira nga agkaburulag-bulag kam ngan balang addangan si ka'am agbalik. Ambanan-bi ako nga ako na hamok sulo pero si kamatu'uran ga'i ako agsulu-sulo kay i Tatay-ko aghuwang si ako. ");
INSERT INTO abx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Agsumatan-ta kam sito basi' agpaka'angkon kam kamurayaw pagpaki'adda si ako. Ato si kalibutan palibot kam si mga kasakitan kundi' pabaskugu-bi i mga huna'-huna'-bi! Salupig-ko na i magpuno' ato si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Katapus-na si Jesus pagpahalling, anhangad iya si langit ngan agpangadyi': “Tay, anakka na i uras. Pakulawon i ka'angayan-na si Dadi'-mo, basi' sapakulaw-na may i ka'angayan-mo ");
INSERT INTO abx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kay agbuwanan-mo na iya gahom pagdalom si dimu'an a'a basi' akabuwan may iya si kinabuhi' nga gana' katapusan-na si dimu'an nagpatubyan-mo si iya. ");
INSERT INTO abx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ay may i kinabuhi' nga gana' katapusan-na kon ma'in i pagkilala pahalap si ka'aw, i adda hamok ungod Diyos pati' i pagkilala liwat si Jesu-Kristo nga nagpabawa-mo? ");
INSERT INTO abx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Agpakulaw-ko i ka'angayan-mo ato si kalibutan pina'agi si pagtapus-ko si mga buruhaton nagpa'intriga-mo si ako. ");
INSERT INTO abx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ina'anto Tay, pakulawon gihapon i ka'angayan-ko tingpid si ka'aw pariho si ka'angayan-ko siray ngan huwang pa ako si ka'aw, antis naghimo i kalibutan. ");
INSERT INTO abx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Agpakilala-ta kaw si mga nagpatubyan-mo si ako tikang si kalibutan. Si kamatu'uran, dati na mga iya mga pinili'-mo mangno agpatubyan-mo si ako ngan agsunud-na mga iya i allingun-mo. ");
INSERT INTO abx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ina'anto, akatu'anan na mga iya nga i dimu'an nagpumwan-mo si ako tikang gayod si ka'aw ");
INSERT INTO abx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kay agsumatan-ko mga iya si mga nagsumat-mo si ako, ngan agpan'aku'-nay to. Akatu'anan mga iya ngan akasiguro nga tikang ako si ka'aw, ngan agtutu'o mga iya nga agpabawa-mo ako ");
INSERT INTO abx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","sanglit agpangadyi' ako para si mga iya. Pero ga'i ako mangadyi' para si mga kalibutanon pa a'a kay ga'i mga iya agpanutu'o. Lugod, agpangadyi' dina ako para si mga nagpatubyan-mo si ako, kay mga iya i pinili'-mo. ");
INSERT INTO abx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mga iya dimu'an nga tawa'-ko, tawa'-mo may, ngan i dimu'an tawa'-mo, tawa'-ko may liwat. Kinakulawan i ka'angayan-ko anan si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ina'anto, tipada'inan na ako si ka'aw. Pa'amban na ako si kalibutan, pero atiya' pa mga iya si kalibutan. Sagrado Tatay, bantayin mga iya si gahum-na si arun-mo, i aron nagpumwan-mo si ako, basi' ag'aradda mga iya pariho si pag'adda-ta. ");
INSERT INTO abx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Si paghururuwang kami', agpamantayan-ko mga iya ngan agpanginanu-ko si gahum-na si aron nagpumwan-mo si ako. Gana' si mga iya marungay pwira si addangan nga nagtagama nga amatay bulag si Diyos basi' atuman i maka'anna' si Kasuratan. ");
INSERT INTO abx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Tipada'inan na ako ina'anto si ka'aw, pero agsumat-ko nayto dimu'an nga ato pa ako si kalibutan basi' sa'abat-na may mga iya i kabug'usan-na si kalipayan-ko. ");
INSERT INTO abx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Agpumwan-ko na si mga iya i mga allingun-mo, katapos nagkuntra mga iya si mga a'a si kalibutan, kay ma'in na mga iya sakop si mga a'a-na si kalibutan pariho si ako nga ma'in na sakop sito. ");
INSERT INTO abx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I nagpangadyi'an-ko ma'in nga bulag-mo mga iya si kalibutan, kundi' bantayin mga iya tikang si girara'ati espirito. ");
INSERT INTO abx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ma'in na mga iya sakop si mga a'a-na si kalibutan pariho si ako nga ma'in na sakop sito. ");
INSERT INTO abx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tagamahon mga iya pagsirbi si ka'aw pina'agi si kamatu'uran. I allingun-mo, iya i kamatu'uran. ");
INSERT INTO abx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pariho si pagpabawa-mo si ako nga akasalakot si mga a'a si kalibutan, aglihug-ko may liwat mga iya pagsalakot ato. ");
INSERT INTO abx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Para si mga iya, agtagama-ko i kalugaringun-ko pagsirbi si ka'aw basi' a'ungod liwat i pagkatagama si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ma'in hamok, Tay, para si mga inadalan-ko i mga pagpangadyi'-ko lugod para liwat si mga sabawa-na mga iya pagtapod si ako tungod si mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amalako ako nga agka'aradda mga iya dimu'an, pariho Tay nga ka'aw ag'ayop si ako ngan ako may ag'adda si ka'aw. Angay kunta' kon akabiyo' may liwat mga iya si kita basi' agpanutu'o i kalibutan nga agpabawa-mo ako. ");
INSERT INTO abx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Agpamuwanan-ko na mga iya si maka'angayan kina'iya nagpumwan-mo si ako basi' agka'aradda mga iya pariho si pag'adda-ta: ");
INSERT INTO abx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ako ag'ayop si mga iya ngan ka'aw may liwat ag'ayop si ako. Amalako ako nga ahul'os gayod i pag'aradda-na mga iya basi' akatu'anan i kalibutan nga agpabawa-mo ako ngan aghigugma'-mo i mga magpanutu'o pantay si paghigugma'-mo may si ako. ");
INSERT INTO abx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tatay-ko, aruyag gayod ako nga i mga nagpamumwan-mo si ako akahuwang si ako si parada'irayan-ko. Si da'ito pa'agi, akakulaw mga iya si langitnon ka'angayan-ko nga nagpumwan-mo tungod si paghigugma'-mo si ako myintras pa naghimo i kalibutan. ");
INSERT INTO abx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Matadong Tatay, bisan kon ga'i kaw sakilala-na si kalibutan, angilala ako si ka'aw ngan agpakatu'anan i magpanutu'o nga agpabawa-mo ako. ");
INSERT INTO abx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Agpakilala-ta na kaw si mga iya ngan padayon pa ako pagpakilala si ka'aw basi' agsihirigugma'ay mga iya pariho si paghigugma'-mo may si ako ngan basi' aka'ayop i kalugaringun-ko anan si mga iya.” ");
INSERT INTO abx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kahuman si pakapangadyi'-na si Jesus, pataliwan iya huwang i mga inadalan-na mangno padalugdog mga iya ngan pabalatas si sapa' nag'arunan Kidron. Ari si dambila' pasagka mga iya hasta anakka si nagtanom kakayuhan nga puro olibo ngan ari mga iya pamadiskanso. ");
INSERT INTO abx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sayod sito lugar si Judas, i magtraydor si Jesus, tungod kay agsob ato agbararagat kas Jesus si mga inadalan-na. ");
INSERT INTO abx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sanglit pada'ito iya nga aniya' nagbaya'-na bali labbat kasundaluhan taga Roma nagpahuwang si mga pinili' gwardya-na si templo nga nagpamabawa-na si mga puno' paraghalad pati' mga Parisiyo. Agpamaway to mga a'a agus'os, sirilya pati' mga armas. ");
INSERT INTO abx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tungod kay sakatu'anan-na may si Jesus i dimu'an titakka si iya, tupu'-na mga iya ngan amatilaw, “Say i nagpara'anda'-bi?” ");
INSERT INTO abx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lingun-na may mga iya, “Si Jesus nga taga Nasaret.” Aminugad may si Jesus, “Akoy nan.” Ngan si Judas may nga traydor, agtutunggo huwang si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pakapinugad-na si Jesus nga “Akoy nan,” pamasibog mga iya ngan agpakabaliskad. ");
INSERT INTO abx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mangno, agtilaw-na gihapon mga iya, “Say i nagpara'anda'-bi?” Ngan aminugad may mga iya, “Si Jesus nga taga Nasaret.” ");
INSERT INTO abx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Agsumatan-ta na kam nga akoy nan,” lingun-na may si Jesus. “Sanglit kon ako i nagpara'anda'-bi, palitirahu-bi mga kahuruwangan-koy to.” ");
INSERT INTO abx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ahinabo' nan basi' atuman i mga allingun-na siray: “Tatay-ko, gana' sarungay-ko bisan addangan si mga nagpatubyan-mo si ako.” ");
INSERT INTO abx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tungod kay aniya' nagbawa-na ispada si Simon Pedro, hulkut-na dayon ngan tigbas-na i rilihugun-na si gilalabawi paraghalad, ngan akapalungan i kawanan talinga-na. Malco i arun-na si rilihugon. ");
INSERT INTO abx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Agmandaran-na si Jesus si Pedro, “Patakubon ispada-moy nan! Ma'in ba' nga kinahanglan ako anginom si kupa si kasakitan nga nagpumwan-na si Tatay-ko?” ");
INSERT INTO abx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mangno nagdakop si Jesus si mga sundalo huwang i punu'-na mga iya pati' i mga gwardya-na si templo. Aggapus-na mga iya, ");
INSERT INTO abx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ngan agbawa-na dahulo pada'iray si Anas, i ugangan-na lalla si Caifas nga gilalabawi paraghalad siray ta'on. ");
INSERT INTO abx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas i magpahalling siray si mga punu'-na si mga Hebro nga mas mahalap kon aniya' addangan magpakamatay para si mga a'a. ");
INSERT INTO abx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Amungyod si Simon Pedro pati' i addangan pa inadalan ngan pagbawa si Jesus pada'iray si palasyu-na si gilalabawi paraghalad. Akabungyod si kas Jesus i addangan pasallod si hawan-na tungod kay kilala-na iya sito, ");
INSERT INTO abx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pero si Pedro ag'antahak hamok si gawas. Sanglit agbwiltay to pagsarit si danda magbantay si pwirtahan pagpasallod si Pedro. ");
INSERT INTO abx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Amatilaw i danda si Pedro, “Ma'in may kaw addangan si mga inadalan-na sinan a'a, ha?” Anaruman si Pedro, “Ma'in.” ");
INSERT INTO abx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tungod kay matugnaw siray sangom, agrambak uring i mga rilihugon pati' i mga gwardya-na si templo ngan agpanunggo palibot si api pagpadarang sanglit patingpid may si Pedro si mga iya. ");
INSERT INTO abx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Si pariho uras, agparatilaw-na si gilalabawi paraghalad si Jesus mahi'unong si mga inadalan-na pati' si mga nagparaturu'-na. ");
INSERT INTO abx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Anaruman si Jesus, “Hayag ako agparapahalling si kalabbatan, ngan pirmi ako agparaturo' ari si mga sinaguga o ma'in ngani' si templo kon singnga pirmi agtiriripon i mga Hebro. Gana' nagparatagu'-ko si mga allingun-ko. ");
INSERT INTO abx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ay kay ako i nagparapatilawan-bi? Tilawu-bi i mga magpakabati' si ako, kay sigurado nga agpakatu'anan mga iya si mga pinahallingan-ko.” ");
INSERT INTO abx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pakapinugad-na sinan si Jesus, addangan si mga gwardya nga agtutunggo matapit ari i manampalo si iya ngan aminugad, “Ma'in da'inan sinan i pagsaruman si gilalabawi paraghalad.” ");
INSERT INTO abx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aminugad may si Jesus, “Kon aniya' pinahallingan-ko mara'at, anistigusa kon ay, pero kon kamatu'uran hamok i nagsumat-ko, ay kay agtampalu-mo ako dina?” ");
INSERT INTO abx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tungod sinan, agpata'an na hamok si Anas nga binawa iya gapos pa pada'iray si Caifas, i gilalabawi paraghalad. ");
INSERT INTO abx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si pagparatutunggu-na si Pedro pagpadarang, nagtilaw iya, “Ma'in may kaw addangan si mga inadalan-na, ha?” Agdidiwaray iya si pagpinugad, “Ma'in.” ");
INSERT INTO abx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mangno, addangan si mga rilihugun-na si gilalabawi paraghalad nga bugtu'-na si sapalungan-na si Pedro i maminugad si iya, “Ma'in ba' sakulawan-ta kaw nga huwang-na ari si kakayuhan?” ");
INSERT INTO abx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Agdidiwaray gihapon si Pedro, ngan mismo siray uras, anutturu'ok i manok. ");
INSERT INTO abx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngan mananalong na, tikang ari si Caifas, nagbawa si Jesus si mga punu'-na si mga Hebro pada'iray si palasyu-na si gubirnador nga taga Roma. Panakka-na mga iya ari, ga'i mga iya pasallod si palasyo. Aglikay mga iya nga agpakarigsukan para mga iya agpakakakan si pakan si Paglabay. ");
INSERT INTO abx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sanglit aggawas-na na hamok mga iya si Pilato ngan amatilaw, “Ay i mga sumbung-bi kuntra sito a'a?” ");
INSERT INTO abx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Anaruman may mga iya, “Kon gana' sinan sala'-na, ga'i nan kunta' bawa kami' pada'ito si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Amahalling si Pilato, “Ka'am na hamok i bahala'. Sunuru-bi i kalugaringun-bi bala'od paghusgar si iya.” “Pero gana' pudir kami' pagpatok kamatayon,” lingun-na may si mga punu'-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ahinabo' nan pagtuman si mga allingun-na si Jesus siray parti kon ay kamatayuna i manakka si iya. ");
INSERT INTO abx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mangno pasallod gihapon pan palasyo si Pilato, ngan tigpa'atubang-na si Jesus si iya. Agtilaw-nay to, “Ka'aw ba' i hadi'-na si mga Hebro?” ");
INSERT INTO abx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Amatilaw may liwat si Jesus, “Tikang ba' nan gayod si kalugaringun-mo isip o nagturu'an kaw hamok si la'in a'a mahi'unong si ako?” ");
INSERT INTO abx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Anaruman may si Pilato, “Kay ay pag'abat-mo, Hebro ako? Nagbawa kaw pada'ito si mga igkasi-mo huwang si mga puno' paraghalad-bi. Kay ay i nagbuhat-mo?” ");
INSERT INTO abx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aminugad may si Jesus, “Ga'i ato sito kalibutan i ginhadi'an-ko. Kay kon atiya' ato, sigurado nga makihiran i mga ginsakupan-ko basi' ga'i ako sadakup-na si mga punu'-na si mga Hebro. Ma'in tikang ato si kalibutan i gahum-ko paghadi'.” ");
INSERT INTO abx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Kon sugad adda kaw hadi'?” lingun-na si Pilato. Anaruman may si Jesus, “Tama' kaw gayod si pagpinugad-mo si ako hadi', kay si kamatu'uran nag'allom ako pagdalom ngan pada'ito ako si kalibutan pagpasayod mahi'unong si kamatu'uran. Ngan bisan say i mag'apilo sito kamatu'uran, agpakali si ako.” ");
INSERT INTO abx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Amatilaw si Pilato, “Say may makatu'anan si kamatu'uran?” Mangno patalikot dayon si Pilato ngan pagawas iya pagpinugad si mga punu'-na si mga Hebro, “Gana' sa'anda'an-ko sala' si iya nga angay paratukan. ");
INSERT INTO abx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero tungod kay kabatasanan na nga aniya' nagpalibri-ko priso kon Pyista si Paglabay, aruyag ba' kam nga yayto pinalibri-ko magpinugad to, ‘hadi'-na si mga Hebro’?” ");
INSERT INTO abx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pero anurakaw dina mga iya, “Ga'i, ma'in iya! Si Barabas lugod!” Si Barabas, addangan nga ribildi. ");
INSERT INTO abx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Katapos agpa'intriga-na si Pilato si Jesus para naglatigo. ");
INSERT INTO abx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Agpanhimo i mga sundalo likaw tikang si tangulon ngan nagpakuruna si Jesus. Nagbistihan liwat iya si hadi'anon pammakurumbot nga kulor igot. ");
INSERT INTO abx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mangno agtikangan-na dayon mga iya pagtahod kuno' si pagburubwilta pagturakaw, “Anlanga pa kunta' i kinabuhi'-na si hadi'-na si mga Hebro!” Ngan sigi-na pa liwat mga iya tampalo. ");
INSERT INTO abx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kahuman sinan, paguwa' gihapon si Pilato ngan agpinugad-na i mga punu'-na si mga Hebro, “Amati'a kam! Pa'intriga-ko iya si ka'am basi' sakatu'anan-bi nga gana' sa'anda'an-ko sala' si iya nga angay paratukan.” ");
INSERT INTO abx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Si paguwa'-na si Jesus nga nagsul'utan si matunok kuruna pati' si hadi'anon pammakurumbot nga kulor igot, agpinugad-na mga iya si Pilato, “Atiya' na i a'a!” ");
INSERT INTO abx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pakakulaw-na si iya si mga puno' paraghalad pati' si mga gwardya-na, agpanurakaw mga iya, “Papaku'on iya! Papaku'on iya si kudos!” Pero anaruman dina si Pilato, “Hala, bawahu-bi iya ngan ka'am na hamok i mamapako' si iya. Pero para si ako, gana' sa'anda'an-ko sala' si iya nga angay paratukan.” ");
INSERT INTO abx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero agpipirit dina i mga punu'-na si mga Hebro, “Aniya' bala'od kami', ngan ato sito bala'od kinahanglan iya nagmatay tungod si pagpinugad-na nga Dadi'-na iya si Diyos.” ");
INSERT INTO abx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ngan pakabati'-na sinan si Pilato, akatambahan i katalaw-na. ");
INSERT INTO abx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pasallod gihapon iya si palasyo ngan agtilaw-na si Jesus, “Taga singnga ba' kaw gayod?” pero ga'i anaruman si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Ay kay ga'i ako agsarumanan-mo?” lingun-na may si Pilato. “Ga'i ba' kaw akatu'anan nga aniya' gahum-ko nga pwidi kaw sapalibri-ko o sapapaku'-ko si kudos?” ");
INSERT INTO abx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Anaruman si Jesus, “Gana' kunta' gahum-mo pagbuhat bisan ay si ako kon ga'i kaw nagbuwanan tikang si dyata'. Sanglit bisan kon agsala' kaw si pagtalapas si katungdanan-mo, mas mahaya dina i baratunun-na si magpama'intriga si ako pada'ito si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tungod sinan, agpara'anda' gayod pa'agi si Pilato nga akalibri si Jesus, pero sigi dina panurakaw i mga punu'-na si mga Hebro, “Kon palibri-moy nan a'a, ma'in kaw kumpaniya-na si Emperador. Kay bisan say i maminugad nga hadi' iya, kuntra-na gayod si Emperador.” ");
INSERT INTO abx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pakabati'-na sinan si Pilato, agbawa-na dayon si Jesus panggawas. Aningkulo' si Pilato si panhuhusgaran panningkulu'an ari si lugar nag'arunan I Plasa si Kinurtihan Bato. Gabata sito i pag'aron si Hebruhanon. ");
INSERT INTO abx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tika'amudto na siray si Bispira si Pyista si Paglabay. Amahalling si Pilato pada'iray si mga punu'-na si mga Hebro, “Atiya' na i hadi'-bi.” ");
INSERT INTO abx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero anurakaw dina mga iya, “Papindahon iya anan! Papindahon iya anan! Papaku'on iya si kudos!” Lingun-na may si Pilato, “Apa'i? Papaku'-ko si kudos i hadi'-bi?” Anaruman may i mga puno' paraghalad, “Gana' la'in hadi' kami' kon ma'in hamok i Emperador!” ");
INSERT INTO abx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Si katapus-tapusan, agpa'intriga-na gihapon si Pilato si Jesus pagpapako' si kudos. Sanglit nagbawa si Jesus si mga sundalo. ");
INSERT INTO abx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nagpapalangkit iya si kalugaringun-na kudos pada'iray si tagudtod nag'arunan Takuluk-na si Minatay. Golgota sito i pag'aron si Hebruhanon. ");
INSERT INTO abx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Panakka-na ari, nagpapako' iya si kudos ngan aniya' duwangan pa nagpapako' padurudambila' ngan nagpatangnga' iya. ");
INSERT INTO abx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aniya' tigsurat-na si Pilato papadukuton ari si kudos nga da'ito sito: JESUS TAGA NASARET I HADI'-NA SI MGA HEBRO ");
INSERT INTO abx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Matapit hamok si syudad i lugar nga nagpapaku'an si Jesus, sanglit malabbat si mga Hebro i magpakabasa sinan mga allingon. Nagsurat nan si Hebruhanon, si Latin pati' si Grikuhanon. ");
INSERT INTO abx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Agriklamo i mga puno' paraghalad-na si mga Hebro ari si Pilato, “Makigliwaton nagpasurat nan anan: ‘Hadi'-na si mga Hebro’ lugod salli'in nga: ‘Agpinugad to a'a, ako i Hadi'-na si mga Hebro.’” ");
INSERT INTO abx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Anaruman si Pilato, “Kon ay i makigsurat-ko, kinahanglan iya gayod i mapasurat.” ");
INSERT INTO abx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ngan pakapapaku'-na si mga sundalo si Jesus, nagpuruparti ampat i mga sul'ut-na, adda si balang addangan. Pero i dilalom badu'-na, iya i pagka'alang-alangan. Durudiritso hamok pan hawod i tanhun-na sito ngan gana' panahi'an-na. ");
INSERT INTO abx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Agsarabot mga iya, “Ga'i to gisi'-gisi'-ta kam. Pa'agi-ta na kam hamok si ripa kon say i makabawa.” Ahinabo' nan basi' atuman i mga allingon nga aka'anna' si Kasuratan: Agpuruparti-na mga iya i panaptun-ko, ngan agpa'agi-na si ripa i badu'-ko. Ngan da'inan sinan i nagbuhat-na si mga sundalo. ");
INSERT INTO abx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Siray uras, agparapanunggo yungod si kudus-na si Jesus i nana-na, i siyaka-na danda si nana-na, si Maria nga alla-na si Clopas pati' si Maria Magdalena. ");
INSERT INTO abx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pakakulaw-na si Jesus nga ari i nana-na nga agtingpid si hinigugma'-na inadalan, agpinugad-na i nana-na, “Nay, aku'on iya bilang dadi'-mo pagmangno si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ngan agpinugad-na may i inadalan-na, “Aku'on iya bilang nana-mo.” Tikang siray, kwintado nayto danda si pamilya-na sito inadalan. ");
INSERT INTO abx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mangno ngan pakakatu'an-na si Jesus nga tapos na i dimu'an buruhatun-na ngan basi' atuman i Kasuratan, amahalling iya, “Nag'uhaw ako.” ");
INSERT INTO abx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aniya' ari adda biso' nga nag'isihan malassom na bino, sanglit ag'ala' mga iya ispungha ngan aghumug-nay to si bino. Agpatulu-na mga iya i ispungha si hisop lingkawan basi' anakka si bawa'-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pakasupsup-na si Jesus si malassom na bino, aminugad iya, “Tapos na.” Mangno pa'ubo' iya ngan agtugutan-na i kalugaringun-na espirito pag'amban. ");
INSERT INTO abx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Siray allaw, iya i Bispira kay si kasanguman iya i pagtikang-na si adda si bali ka'impurtanti Allaw Pandidiskanso. Tungod kay ga'i aruyag i mga punu'-na si mga Hebro nga nag'ambanan hamok si mga kudos i mga nagpapako' hasta nga anakka si Allaw Pandidiskanso, agsarit mga iya ari si Pilato kon pwidi tigpamatti'an-na si mga kalalaki basi' tulos agkamaratay ngan ahaw'as si kudos. ");
INSERT INTO abx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sanglit pamada'iray i mga sundalo pagpamatti' si primiro nagpapako' huwang-na si Jesus, mangno i kaduwangan. ");
INSERT INTO abx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero ngan pamaduguk-na mga iya si Jesus, sadiskubrihan-na mga iya nga minatay na dina, sanglit ga'i na hamok nagpamatti'an. ");
INSERT INTO abx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero addangan si mga sundalo i manundat pa gihapon buros si kagiliran-na ngan hintak pa'awas i laha' pati' buwahi'. ");
INSERT INTO abx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","I makakulaw sito agtistigos ngan kamatu'uran gayod i mga nagsumat-na. Akatu'anan iya nga puro ungod i mahinabo' nagsumat-na ngan agsumat-nay to dimu'an basi' may kam agpanutu'o. ");
INSERT INTO abx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ahinabo' nan dimu'an pagtuman si mga allingon nga aka'anna' si Kasuratan: “Gana' makapatti'an si mga ta'ulang-na bisan adda.” ");
INSERT INTO abx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ngan da'inan may i la'in pa maka'anna' si Kasuratan: “Parapamuslung-na mga iya i nagsundat-na.” ");
INSERT INTO abx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kata'ud-ta'uran, aniya' taga sunsari'i si bungto Arimatea nag'arunan Jose magsarit si Pilato pag'ala' si bangkay-na si Jesus. Inadalan-na iya si Jesus, pero ga'i iya agpahayag si kalabbatan tungod kay atalaw iya si mga igkasi-na puno' si mga Hebro. Sanglit panugut-na si Pilato, pada'iray dayon iya ngan ag'ala'-na i bangkay. ");
INSERT INTO abx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Amaya' si iya si Nicodemos, i manungbalay siray si Jesus ngan sangom. Agbaway to day pamada, hinimo tikang si masangngit mga tanaman mirra pati' aloe, mga trayntay kwatro kilos i kabuwat-na. ");
INSERT INTO abx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pakahuman-na mga iya duwangan pagbayaw si bangkay, agputus-nay to mga iya si tinabas-tabas katsa huwang si pasangngit sigon si kabatasanan-na si mga Hebro paglabbong. ");
INSERT INTO abx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aniya' ari gardin nga matapit si nagpapaku'an si Jesus, ngan aniya' ari kwiba panlalabbungan. Gana' pa gayod makalabbungan ari, ");
INSERT INTO abx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","sanglit ari mga iya aglabbungan-na si Jesus, tungod kay matapit to kwiba ngan iya nayray i Bispira-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kadumingguhan, nga iya i primiro allaw si duminggu-na mga iya, ga'i pa agdanta' i kanalungon pada'iray na si Maria Magdalena si naglabbungan ngan sakulawan-na nga nagpaligid na dina i bato tikang si pwirtahan-na. ");
INSERT INTO abx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sanglit alahi dagos iya pagpada'iray si Simon Pedro pati' si addangan pa inadalan nga hinigugma'-na si Jesus ngan agpaminugad-na, “Ag'ala'-na mga iya i Paragdalom ari si naglabbungan ngan ga'i kami' akatu'anan kon singnga mga iya agbawa-na!” ");
INSERT INTO abx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sanglit pada'iray dayon kas Pedro pati' i addangan pa inadalan si naglabbungan. ");
INSERT INTO abx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Agpanlalahi mga iya duwangan, pero ahuros si Pedro, sanglit akadahulu'an anakka i addangan ari si naglabbungan. ");
INSERT INTO abx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Paduko' iya ngan sasiripan-na i mga tinabas-tabas katsa nga bilin ari, pero ga'i iya pasallod. ");
INSERT INTO abx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Panakka-na si Pedro ari si naglabbungan, pasallod dayon iya ngan sakulawan-na i mga tinabas-tabas nga bilin ari. ");
INSERT INTO abx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sakulawan-na liwat ari i pudung-pudong nga nagpapakkos si sulang-na si Jesus. Nagtipig to ngan bulag si mga tinabas-tabas. ");
INSERT INTO abx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Si katapus-tapusan pasallod liwat i dahulu'an manakka inadalan. Akakulaw iya ngan anutu'o gayod. ");
INSERT INTO abx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero ga'i pa gihapon mga iya agpakasantop si maka'anna' si Kasuratan nga agbagaw parti si kasiguraduhan nga abanhaw si Jesus. ");
INSERT INTO abx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mangno agbalik i mga inadalan si mga ruma'-na. ");
INSERT INTO abx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero sigi hamok dinamag si Maria ari si gawas-na si naglabbungan. Si pagparadinamag-na, paduko' iya ngan anirip si naglabbungan. ");
INSERT INTO abx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aniya' sakulawan-na ari si sallod duwangan anghel, mga disutana puti' ngan agpaningkulo' si lugar naghuliran si Jesus. I addangan banda si takulukan-na ngan i addangan may si kitiran-na. ");
INSERT INTO abx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Agtilaw-na iya, “Mana, ay kay agparadinamag kaw?” Anaruman may iya, “Ag'ala'-na mga iya i Paragdalum-ko, ngan ga'i ako akatu'anan kon singnga mga iya agbawa-na.” ");
INSERT INTO abx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pakapahalling-na sinan, patalikot iya ngan sakulawan-na nga ari na dina si Jesus. Pero ga'i iya angilala kon si Jesus ba' ray. ");
INSERT INTO abx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Amahalling to, “Mana, ay kay agparadinamag kaw? Say i nagpara'anda'-mo?” Tungod kay i pagkagasi-na nga hardiniroy to hamok ari, aminugad iya, “Kon ag'ala'-mo may dina iya, alayon sumatin ako kon singnga iya agbawa-mo, kay ala'-ko.” ");
INSERT INTO abx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Agpinugad-na iya, “Maria.” Pakapakali-na sinan si Maria hintak iya pa'atubang gihapon dungan si pagpahalling si Hebruhanon, “Raboni!” nga i kahulugan-na, Ma'istro. ");
INSERT INTO abx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Amahalling si Jesus, “Labbahin ako, kay ga'i pa ako akabalik pada'iray si Tata'. Lugod pada'irayon i mga kabugtu'an-ko si pagtu'o ngan sumatin mga iya nga tibalik na ako si Tatay-ko nga mga Tatay-bi liwat, i Diyus-ko nga mga Diyus-bi liwat.” ");
INSERT INTO abx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sanglit agpada'iray-na si Maria Magdalena i mga inadalan-na si Jesus ngan agpanumatan-nay to, “Sakulawan-ko i Ginu'o.” Pwira pa sinan, agpanumatan-na liwat to si tugun-na si iya. ");
INSERT INTO abx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kasanguman mismo siray allaw nga iya i primiro allaw-na si duminggo, agtiriripon i mga inadalan nga trangkado i pwirtahan tungod si mga katalaw-na si mga punu'-na si mga Hebro. Pahulwa' si Jesus ngan patig'ob si mga iya ngan aminugad, “I kamurayaw awinan si ka'am!” ");
INSERT INTO abx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pakapahalling-na sinan, agpakulaw-na mga iya si tamburu'-na pati' si kagiliran-na. Bali i mga kalipayan-na si mga inadalan pakakulaw-na mga iya si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aminugad gihapon si Jesus, “I kamurayaw awinan si ka'am! Pariho si pagpabawa-na si ako si Tata', pabawa-ko may liwat kam.” ");
INSERT INTO abx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pakapahalling-na sinan, anhingasong to si mga iya ngan aminugad, “Karawatu-bi i Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kon agpasaylo kam si sala'-na si bisan say, nagpamasaylo na mga iya. Pero kon ga'i mga iya agpasaylu-bi, ga'i may liwat mga iya nagpasaylo.” ");
INSERT INTO abx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Si pagpakulaw-na si Jesus si mga inadalan-na siray uras, ga'i ari si Tomas, i nag'anga'an Karuwa nga addangan si Dusi. ");
INSERT INTO abx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sanglit agsumatan-na iya si mga igkasi-na inadalan, “Sakulawan kami' i Ginu'o!” Aminugad dina iya, “Ga'i ako anutu'o sinan hasta nga ga'i sakulawan-ko i mga pammaku'an, sapasuksuk-ko i kamrang-ko si mga pammaku'an si tamburo', pati' sapasul'ut-ko i tamburu'-ko si kagiliran-na.” ");
INSERT INTO abx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pa'agi i adda duminggo, agtiripon gihapon i mga inadalan si ruma' panniripunan-na mga iya nga huwang na si Tomas. Bisan kon trangkado i pwirtahan, akasallod si Jesus nga agtutunggo huwang si mga iya ngan aminugad, “I kamurayaw awinan si ka'am.” ");
INSERT INTO abx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mangno, agpinugad-na si Tomas, “Tuwa, kulawin ngan pasuksukon kamrang-moy nan si pammaku'an to si mga tamburu'-ko pati' pasul'uton tamburu'-moy nan si kagiliran-koy to. Dakaw abawa si pagduda kundi' agtutu'uha.” ");
INSERT INTO abx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Anaruman si Tomas, “Paragdalum-ko ngan Diyus-ko!” ");
INSERT INTO abx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mangno agsumatan-na iya si Jesus, “Abawa kaw pagtutu'o si pakakulaw-mo si ako pero anmas pa i kalipayan-na si mga a'a nga agpanutu'o bisan kon ga'i agpakakulaw.” ");
INSERT INTO abx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Malabbat pa i naghimu-na si Jesus mga pangngilalahan si langitnon kasiguruhan atubang si mga inadalan-na nga ga'i nagpa'anna' ato sito libro. ");
INSERT INTO abx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero nagsurat to basi' agpanutu'o kam nga si Jesus i Tinu'inan Mannanalwas, i Dadi'-na si Diyos. Ngan tungod si pagtutu'u-bi, sa'angkun-bi i kinabuhi' nga gana' katapusan-na pina'agi si gahum-na si arun-na. ");
INSERT INTO abx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kapirahan allaw, pakulaw gihapon si Jesus si mga inadalan-na ari si Danaw Tiberias. Da'ito sito i hinabo': ");
INSERT INTO abx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aghururuwang kas Simon Pedro, si Tomas nga nag'anga'an Karuwa, si Nataniel nga taga sunsari'i si Cana, adda baryo si prubinsya Galilea, i mga dadi'-na lalla si Sebedeo, pati' i duwangan pa inadalan. ");
INSERT INTO abx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“Mamukot ako ina'anto,” lingun-na si Simon Pedro. Lingun-na may mga iya, “Amaya' kami'.” Sanglit pataliwan mga iya ngan ag'aradda mga iya sakayan, pero gana' gayod mga sabawa-na siray sangom. ");
INSERT INTO abx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nalung-nalong pa, anunggo si Jesus si baybayon pero ga'i agpakatu'an-tu'anan i mga inadalan nga si Jesus ray. ");
INSERT INTO abx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aman'oy to si mga iya, “Mga sangkay, aniya' ba' sabawa-bi?” Anaruman may mga iya, “Gana' may.” ");
INSERT INTO abx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aminugad si Jesus, “Taktaku-bi pukut-bi nan si banda kawanan si sakayan-bi basi' agpakabawa kam.” Sanglit agbuhat-nay nan mga iya, mangno tungod si katabbul-na si daying ga'i na mga iya sapasang'at-na i mga pukut-na. ");
INSERT INTO abx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mangno i inadalan nga hinigugma'-na si Jesus aminugad ari si Pedro, “I Paragdalom may nan!” Si pakapakali-na si Simon Pedro si mga allingun-na, “I Paragdalom may nan,” pasul'ut-na i badu'-na kay aghugkas-nay to, ngan pakuppa iya si buwahi' diritso pan bihing. ");
INSERT INTO abx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I mga inadalan may ari si sakayan agpangguyod si pukot nga panno' si daying kay matapit hamok mga iya si bihing, mga syin mitros i katalahan-na. ");
INSERT INTO abx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pakadu'ung-na mga iya, akakulaw mga iya nagrambak uring nga bali na baga ngan aniya' nagpaparilya daying ari pati' aniya' liwat pan. ");
INSERT INTO abx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Agpinugad-na mga iya si Jesus, “Amawaha kam pada'ito si mga daying-bi nan.” ");
INSERT INTO abx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sanglit pasang'at si Simon Pedro si sakayan ngan agguyud-na i pukot pan baybayon. Panno' to si mga mahaya daying 153 bug'os, pero ga'i to aburhat bisan kon da'iray i kalabbat-na. ");
INSERT INTO abx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aminugad si Jesus si mga iya, “Tuwa na kam basi' kita kam agpakapamahaw.” Gana' gayod mamuso' mamatilaw si mga inadalan kon say iya. Akatu'anan mga iya nga i Paragdalom to. ");
INSERT INTO abx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Patapit si Jesus ngan angaddo' si pan. Katapos agpumwan-nay to si mga iya hasta i daying. ");
INSERT INTO abx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iyay nan i katallo bisis pagpakulaw-na si Jesus si mga inadalan-na kahuman si pakabanhaw-na. ");
INSERT INTO abx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pakatapus-na mga iya agpamahaw, agtilaw-na si Jesus si Simon Pedro, “Simon, dadi'-na si Juan, aghigugma'-mo ba' ako labaw si paghigugma'-na mga iya?” Anaruman may iya, “Oho', Paragdalum-ko. Sayod kaw nga matapit gayod ako si ka'aw.” Lingun-na may si Jesus, “Pakakanon i mga nati karniru-ko.” ");
INSERT INTO abx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Amatilaw gihapon si Jesus, “Simon, dadi'-na si Juan, aghigugma'-mo ba' ako?” Anaruman iya, “Oho', Paragdalum-ko. Sayod kaw nga matapit gayod ako si ka'aw.” Lingun-na si Jesus, “Atamanon i mga karniru-ko.” ");
INSERT INTO abx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Si katallo bisis amatilaw gihapon iya, “Simon, dadi'-na si Juan, ma'in ba' nga matapit kaw gayod si ako?” Asakit si Pedro kay si katallo dina agtilaw-na iya, “Ma'in ba' nga matapit kaw gayod si ako?” Aminugad iya, “Paragdalum-ko, sayod kaw si dimu'an, sanglit sakatu'anan-mo nga bali ako tapit si ka'aw.” Amahalling si Jesus, “Pakakanon i mga karniru-ko. ");
INSERT INTO abx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sumatan-ta kaw si kamatu'uran, siray ngan dadi' pa kaw, akalugaring kaw pagsalin ngan akalangngan bisan singnga i karuyag-mo. Pero kon anakka na kaw si kamaktungon, ugnat-mo na hamok i mga langngun-mo kay la'in na i magsalin si ka'aw ngan nagguyod kaw pada'iray si ga'i saruyagan-mo.” ");
INSERT INTO abx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Agpinugad si Jesus sinan pagbuwan isip si Pedro kon pinapa'i sapakulaw-na i ka'angayan-na si Diyos tungod si klasi kamatayon kararawatun-na. Mangno aminugad to si iya, “Amaya'a ngan agsunura si ako!” ");
INSERT INTO abx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Si pagparabaktas-na na mga iya duwangan, anili' si Pedro mangno sakulawan-na nga amungyod si mga iya i inadalan nga hinigugma'-na si Jesus. Iyay nan i inadalan magsandi siray si Jesus ari si pagkakanan ngan magpatilaw, “Paragdalom, say si ka'aw i titraydor?” ");
INSERT INTO abx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pakakulaw-na sinan si Pedro, amatilaw dayon iya, “Paragdalom, ay may i binuhat-mo si iya?” ");
INSERT INTO abx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Anaruman si Jesus, “Kon aruyag ako nga agpabilin iya allom hasta si pagtakka-ko gihapon, gana' labut-mo. Kinahanglan kaw hamok nga agsunod gayod si ako.” ");
INSERT INTO abx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tungod sinan, agsara si mga kabugtu'an si pagtu'o i allingon nga yayto inadalan ga'i amatay. Pero ga'i agpinugad si Jesus nga ga'i to amatay, kundi' agpinugad hamok iya nga, “Kon aruyag ako nga agpabilin iya allom hasta si pagtakka-ko gihapon, gana' labut-mo.” ");
INSERT INTO abx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iyay nan i inadalan nga magtistigos ngan magsurat sito mga hinabo'. Sayod kami' nga kamatu'uran i pagtistigus-na. ");
INSERT INTO abx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bali pa labbat i pala'in-la'in nagbuhat-na si Jesus. Kon nagsurat i kada adda, tingali bisan i bug'os kalibutan ga'i akahusto pamma'anna'an si mga libro masurat kunta'.");
INSERT INTO abx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hinigugma'-ko Teofilo, ari si primiro libro naghimu-ko, agsurat ako mahi'unong si dimu'an nagbuhat-na pati' nagturu'-na si Jesus ");
INSERT INTO abx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tubtob si allaw ngan pan langit iya kay ag'ala'-na iya si Tatay-na. Pan langit iya kahuman hamok si pagtugun-na si mga pinili'-na apostol sigon si gahum-na si Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kahuman agsakit si Jesus, agpakulaw-na i puhu'-na sito mga a'a sallod si kwarinta diyas ngan agparapamatu'od iya pina'agi si malabbat binuhatan nga ga'i kadudahan nga abanhaw iya. Agparasumat liwat iya kon pinapa'i i a'a akasakop si mga nagpanhadi'an-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Adda bisis, si pagkakan-na huwang si mga apostol, agtugunan-na mga iya, “Dakam pa'amban ato si Jerusalem pero antahaku-bi i rigalo nagpasa'ad-na si Tatay-ko nga iya i pagpa'ayop si Espirito Santo si ka'am. Sapakalihan-bi na ako siray agpahalling mahi'unong sito rigalo. ");
INSERT INTO abx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Agbunyag si Juan ray parti si buwahi', pero si pira allaw binunyagan kam pagpa'ayop si Espirito Santo si ka'am.” ");
INSERT INTO abx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sanglit si pagbaragat-na gihapon mga iya, agpatilawan-na mga iya si Jesus, “Paragdalom, ina'anto na ba' i pagbawi'-mo si ginhadi'an para si mga a'a-na si Israel tikang si pagsakup-na si mga taga Roma?” ");
INSERT INTO abx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Anaruman iya, “Gana' labut-bi si mga pala'in-la'in panahon pati' mga pitsa nagtala'an-na si Tatay-ko tikang si kalugaringun-na gahom. ");
INSERT INTO abx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero si pag'ayup-na si ka'am si Espirito Santo, akakarawat kam gahom nga magin tistigus-ko kam. Agsumat kam si kamatu'uran mahi'unong si ako ato si mga a'a si Jerusalem, ari si bug'os prubinsya si Judea pati' si Samaria hasta si dimu'an lugar ato si kalibutan.” ");
INSERT INTO abx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pakatima-na sinan pagpahalling, a'alsa iya pan langit si pagparapangulaw-na mga iya ngan kasalingkupan iya si panganod hasta nga ga'i na kinakulawan. ");
INSERT INTO abx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ga'i mga iya aglipatan-na pagbuslong i pagdyadyalta-na si Jesus ngan si pagparapamantaw-na, hintak mga iya agpakakulaw duwangan lalla magtutunggo si mga kagiliran-na nga mga disutana puti'. ");
INSERT INTO abx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Agpatilaw i duwangan, “Ka'am mga taga prubinsya Galilea, kapa'i may kay agparapantutunggo kam ato ngan sigi pangulaw pan langit? Yayray pan langit ray Jesus nga nag'ala' tikang si ka'am, pabwiltay ray gihapon pariho pa'agi si pagpada'iray-na.” ");
INSERT INTO abx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mangno agbalik i mga apostol pan Jerusalem tikang si tagudtod nag'arunan Bukid-na si Ka'ulibuhan. I katalahan-na sinan tagudtod tikang si syudad tama' hamok ralangnganun-na si mga Hebro kon Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Panakka-na mga iya ari, amanahik mga iya si kwarto nag'istaran-na mga iya. I mga huwang ari iya kas: Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, si Santiago nga dadi'-na si Alfeo, si Simon nga sakop si grupu-na si mga Selote pati' si Judas nga dadi'-na si Santiago. ");
INSERT INTO abx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pirmi mga iya ag'aradda pag'ampo' huwang si mga danda pati' si Maria nga nanay-na si Jesus. Huwang liwat si pagtiriripon i mga bugtu'-na lalla si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Siray mga allaw, mga syinto baynti i kalabbat-na si mga magpanutu'o. Si adda pagtiripun-na mga iya, anunggo si Pedro ");
INSERT INTO abx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ngan aminugad, “Mga kabugtu'an si pagtu'o, atuman na i maka'anna' si Kasuratan ngan ga'i to akalikayan. Makigpapahalling-nay to siray si Espirito Santo si David mahi'unong si Judas, nga iya i maggiya si mga magpandakop si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Addangan iya si kahuruwangan-ta kam ngan aka'ambit iya si trabahu-tay to kam para si Diyos.” ");
INSERT INTO abx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iyay ray i mga nagpahalling-na si Pedro. Katu'anan i dimu'an nga nagballihan si Judas pitak pina'agi si nagpasuhol si iya si karat'an-na ngan ari iya ag'unay. Latod na i battung-na si pakataktak-na si puhu'-na, sanglit abuntay to, ngan agwatwat i dimu'an tina'i-na. ");
INSERT INTO abx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Akatu'anan i dimu'an mga a'a ato si Jerusalem mahi'unong sito. Sanglit yayray pitak ag'arunan-na mga iya Akeldama, nga i kahulugan-na, Pitak si Pagwasakan-na si Laha'. ");
INSERT INTO abx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Agpadayon si Pedro si pagpinugad, “Aka'anna' si Libro si mga Salmo nga: Inambanan pa kunta' i pitak-na. Gana' pa kunta' bisan addangan mag'istar ari, ngan: Binawi' pa kunta' i katungdanan-na pagpamuno' ngan pinumwan si la'in. ");
INSERT INTO abx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Sanglit kinahanglan nga agpili' addangan nga huwang si kita kam si bug'os panahon pag'istar-na pa si Paragdalum-ta kam Jesus huwang si kita, ");
INSERT INTO abx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tikang si pagparapasamwak-na si Juan mahi'unong si pagbunyag-na, tubtob a'alsa si Jesus pan dyata' tikang si paghuruwang-ta kam. Addangan sito mga a'a i magin tistigos huwang si kita nga abanhaw iya.” ");
INSERT INTO abx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tungod sinan, agpatunggo mga iya duwangan pirili'on. I addangan, iya si Jose nga danay nag'arunan Barsabas ngan Justus i anga'-na. I kaduwangan, iya si Matias. ");
INSERT INTO abx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mangno agpangadyi' i dimu'an magpanutu'o, “Paragdalom, sayod kaw andang si ungod kina'iya-na si balang addangan. Pakulawon kami' kon say si duwangan to i nagpili'-mo ");
INSERT INTO abx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","pagbuhat si trabahu-na si adda apostol, nga ag'ambanan-na si Judas kay pada'iray iya si lugar nga angay si iya.” ");
INSERT INTO abx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kahuman si pagpangadyi'-na mga iya, agparagmano i duwangan ngan si Matias i makamano. Sanglit huwang na iya si dusi mga apostol. ");
INSERT INTO abx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Si allaw si Pentecostes ngan ari si adda ruma' i dimu'an magpanutu'o, ");
INSERT INTO abx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","hintak aniya' kinabati'an tando tikang si langit. I tando pariho si hinaguyung-na si magburung-busong makusog bariyo ngan kinabati'an si bug'os ruma' nagpaningkulu'an-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aniya' liwat sakulawan-na mga iya day api magpandilat-dilat. Agwararak to ngan pa'anna' si kada addangan. ");
INSERT INTO abx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pa'ayop i Espirito Santo si mga iya dimu'an ngan agpapahalling-na mga iya kada addangan si la'in linggwahi sigon si abilidad nagpumwan-na si Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sinan mga allaw, aniya' mag'istar si Jerusalem mga rilihuso Hebro nga tikang si balang nasyon si kalibutan. ");
INSERT INTO abx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ngan pakapakali-na mga iya sinan ribok, bali labbat i magpanggubok ngan aburong gayod mga iya kay akapakali i kada addangan si mga iya nga agpahalling-na si magpanutu'o i balang kalugaringun-na mga iya linggwahi. ");
INSERT INTO abx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Si ura-ura pag'usa, agpamatilaw mga iya, “Ma'in ba' to mga taga prubinsya Galilea magpamahalling to? ");
INSERT INTO abx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pinapa'i daw kay sapakalihan-ta mga iya nga akapahalling si kalugaringun-ta kam mga linggwahi? ");
INSERT INTO abx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sakop kita kam dina si nasyon Partia nga mga taga sunsari'i si mga prubinsya Media, Elam pati' Mesopotamia. I ditangnga' may tikang dina si mga prubinsya Judea, Capadocia, Ponto pati' Asia. ");
INSERT INTO abx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aniya' liwat tikang si Frigia, Pamfilia, Ehipto pati' parti-na si Libya nga matapit si syudad Cirene, ngan mga bisita tikang si Roma. ");
INSERT INTO abx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","I ditangnga' si kita kam mga Hebro, ngan aniya' liwat mga mabawa si rilihiyun-na si mga Hebro. I ditangnga' may, mga taga isla Creta pati' mga Arabo. Sapakalihan-ta kam mga iya agpahalling si mga kalugaringun-ta linggwahi pagsumat si mga urusahon naghimu-na si Diyos!” ");
INSERT INTO abx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aburong ngan ag'usa gayod mga iya sanglit agsipurupatilaway, “Ay i karuyag sidngun-na sito?” ");
INSERT INTO abx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero aniya' dina si mga iya nga pakangswirti-na hamok pina'agi si pagpinugad, “Mga langu-langoy nan mga iya.” ");
INSERT INTO abx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mangno anunggo si Pedro ari si unsi kahuruwangan-na mga apostol. Agpakusug-na i pagpahalling-na pada'iray si magpanggubok, “Mga igkasi-ko Hebro, da'inan may si dimu'an magpangistar si Jerusalem, pasayud-koy to si ka'am. Amati'a kam pahalap kon ay i papahallingun-ko. ");
INSERT INTO abx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gasi-bi nga langoy to mga a'a. Sala' kam! Alas nwibi pa hamok si nalong! Ngan para kam kasayuran, ");
INSERT INTO abx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","yayto i allingun-na siray si paragsumat Joel: ");
INSERT INTO abx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Agsa'ad i Diyos si pagpinugad, ‘Si damuri mga allaw, pa'ayup-ko i Espiritu-ko si dimu'an mga a'a. I mga dadi'-bi, lalla pati' danda, iya i mamahalling si makigpasumat-ko, i mga dadi'-dadi'on pa lalla, iya i makakulaw maka'urusa kurulawan ngan i mga kamabu'utan-bi, iya i magpangupi. ");
INSERT INTO abx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sinan mga allaw pa'ayup-ko i Espiritu-ko bisan si mga rilihugun-ko maski lalla o danda, ngan mga iya i mamahalling si makigpasumat-ko. ");
INSERT INTO abx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anhimo ako mga urusahon ato si langit pati' mga pangngilalahan si langitnon kasiguruhan anan si kalibutan. Aniya' laha' pati' api hasta madakmol humbo. ");
INSERT INTO abx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ga'i na andanta' i allaw ngan i bulan agpiyatan pariho si laha'. Himu-koy to antis anakka i bali kapambihira ngan maka'angayan allaw nga aniya' impurtanti buruhatun-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ngan bisan say i mag'ampo' si arun-na si Paragdalom, atalwas.’” ");
INSERT INTO abx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mangno agpadayon i mga allingun-na si Pedro, “Ka'am mga a'a-na si Israel, amati'a kam sito: Si Jesus nga taga Nasaret, iya i a'a nagpili'-na si Diyos pagpada'ito si ka'am. Agpamatu'od i mga makagagahom binuhatan, mga urusahon pati' mga pangngilalahan si langitnon kasiguruhan nga iya i nagpili'-na si Diyos pagpada'ito si ka'am. Agbuhat-nay to si Diyos atubang si ka'am pina'agi si Jesus, ngan mismo ka'am akatu'anan. ");
INSERT INTO abx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yayto a'a agpa'intriga-na si Diyos si pagdalum-bi kay iya may i katuyu'an-na ngan dati iya akatu'anan kon ay i tarakkahan-na. Agpamatay-bi iya huwang i bulig-na si mga mara'at a'a, ngan nagpapako' iya si kudos. ");
INSERT INTO abx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero agbanhaw-na iya si Diyos. Agpalibri-na iya tikang si pagpugul-na si kamatayon tungod kay ga'i ahimo nga prisu-na iya sito. ");
INSERT INTO abx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kay agpinugad siray si David mahi'unong si iya: Sa'abat-ko nga pirmi huwang si ako i Paragdalom. Ga'i ako abantad tungod kay pirmi iya atiya' si kawanan-ko. ");
INSERT INTO abx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sanglit malipayon i kasing-kasing-ko ngan malipayon ako si pagpahalling-ko. Si pagla'um-ko ga'i abaraka i puhu'-ko, ");
INSERT INTO abx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tungod kay ga'i ako pata'anan-mo si dilalom pitak. Ga'i kaw liwat agtugot nga arunot i bangkay-na si Sagrado Nagtagama-mo. ");
INSERT INTO abx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Agturu'an-mo ako si lalan si ungod kinabuhi'. Si paghuwang-mo si ako pirmi ako malipayon. ");
INSERT INTO abx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga kabugtu'an, pasayud-ko si ka'am nga si Hadi' David, i ginikanan-na si nasyun-ta kam, amatay ngan naglabbungan matapit ato. Hasta ina'anto awinan i labbung-na. ");
INSERT INTO abx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero paragsumat-na iya si Diyos ngan allom pa iya, ngan sakatu'anan-na nga agsa'ad ngan agsumpa' i Diyos nga patingkulu'-na si trunu-na i addangan si mga ampu-na. ");
INSERT INTO abx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sanglit kay dati iya akatu'anan si titakka, agpahalling si David mahi'unong si pakabanhaw-na si Tinu'inan Mannanalwas, nga ga'i iya pata'anan-na si Diyos ari si dilalom pitak, ngan ga'i liwat arunot i bangkay-na. ");
INSERT INTO abx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Jesus i nagbanhaw-na si Diyos, ngan kami' dimu'an i tistigos nga ungod to. ");
INSERT INTO abx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Agpa'anna'-na iya si Diyos si gilalabawi pwisto ari si kawanan-na, ngan sakarawat-na tikang si Tatay-na i nagpasa'ad Espirito Santo ngan agpa'ayup-na si magpanutu'o. Iya magpahimo si sakulawan-bi to pati' sapakalihan-bi. ");
INSERT INTO abx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Ma'in si David i nagpalabaw ari si langit, pero agpahalling iya: Agpinugad i Paragdalom Diyos pada'iray si Paragdalum-ko, ‘Aningkulu'a ato si kawanan-ko ");
INSERT INTO abx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tubtob nga sapama'ubus-ko i mga kuntra-mo pa nga day pannungtungan-mo.’ ");
INSERT INTO abx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Sanglit, ka'am dimu'an mga a'a-na si Israel, siguruhu-bi to: Si Jesus nga makigpapaku'-bi si kudos, iya i nagtu'inan-na si Diyos bilang Paragdalom pati' Tinu'inan Mannanalwas.” ");
INSERT INTO abx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aka'igu'an gayod i mga a'a si pakapakali-na mga iya si mga nagpahalling-na si Pedro, ngan aminugad mga iya pada'iray si kas Pedro pati' si ditangnga' mga apostol, “Mga kabugtu'an, ay i angay buruhaton kami'?” ");
INSERT INTO abx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Anaruman may si Pedro, “Balang addangan si ka'am kinahanglan agbasol huwang si pagbag'o. Agpabunyaga kam liwat pag'ako' si arun-na si Jesu-Kristo, kay basi' pasaylu-na kam ngan basi' pa'ayup-na si ka'am i rigalo nga iya i Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Para si ka'am pati' si mga dadi'-bi i sa'ad, da'inan may si mga a'a nga titakka pa. Paray to si dimu'an mga a'a nag'agda-na si Diyos nga Paragdalum-ta.” ");
INSERT INTO abx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Si Pedro maniguro pagwaydong ngan malabbat pa i nagpahalling-na nga agmato i mga a'a. “Salbaru-bi i kalugaringun-bi basi' ga'i kam akahuwang si kara'at-na si mga a'a ina'anto panahon.” ");
INSERT INTO abx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nagbunyagan i mga a'a mangalagad si mga allingun-na si Pedro, ngan aniya' mga tris mil a'a makatamba si kalabbat-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tangkod gayod i magpanutu'o pagsunod si nagturu'-na si mga apostol. Hugot mga iya si pag'aradda-na, hasta si pagtarangka'-na mga iya pagkakan si tinurutabbi' pan huwang si pag'ampo'. ");
INSERT INTO abx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Malabbat mga urusahon pati' mga pangngilalahan si langitnon kasiguruhan nagpanhimu-na si mga apostol ngan nginarat i dimu'an mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Agsob aghuruwang i magpanutu'o ngan i tawa'-na si addangan tawa'-na si dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Si uras nga aniya' pirangan magkinahanglan, agbaligya' i mga aniya' si mga inanna'-na ngan agbuwanan-na mga iya i anggana'. ");
INSERT INTO abx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Balang allaw agbaragat i magpanutu'o ari si mga hawan-na si templo. Agtarangka' mga iya pagkakan si tinurutabbi' pan si pala'in-la'in ruma' ngan gana' na gayod maka'ulang si pag'aradda-na mga iya. Panno' mga iya kalipayan si pagpamangan-na ngan ");
INSERT INTO abx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","agpandayaw si Diyos. Nagpalangga' mga iya si dimu'an mga a'a. Pwira pa sinan, allaw-allaw agpatamba-na si Paragdalom ari si mga iya i magkataralwas. ");
INSERT INTO abx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Adda allaw sinan, ngan alas tris si kuhap nga iya i kabatasanan pagpangadyi', agsasagka kas Pedro pati' Juan si lalan pan templo. ");
INSERT INTO abx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mismo sinan aniya' lulid nagbayawan pada'iray si pangngagihan si kuta'-na si templo nag'arunan Pinakamahalap Pwirtahan. Allaw-allaw ari nagparapa'anna' i lulid pagpalako limos si mga a'a tisallod si mga hawan-na si templo. ");
INSERT INTO abx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Si pakakulaw-na si lulid nga tisallod kas Pedro, agduku'an to pagpalako si mga iya kwarta. ");
INSERT INTO abx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Agbuslung-na iya si Pedro ngan da'inan may liwat si Juan. Mangno aminugad si Pedro, “Ngulawa si kami'!” ");
INSERT INTO abx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sanglit agbuslung-na mga iya kay agla'om nga kabuwanan. ");
INSERT INTO abx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero aminugad dina si Pedro, “Gana' kwarta-ko bulawan o salapi', pero pumwan-ko si ka'aw i atiya' si ako. Pina'agi si gahum-na si Jesu-Kristo nga taga Nasaret sumatan-ta kaw, langngana.” ");
INSERT INTO abx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ag'antanan-na iya si Pedro si kawanan tamburo' ngan buligan-na pagtunggo. Mismo sinan uras amaskog dayon i mga kalalaki-na ");
INSERT INTO abx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ngan akalumpat. Agtikang iya paglangngan ngan amaya' iya si kas Pedro pati' Juan pasallod si mga hawan-na si templo. Si pagparalalangngan-na, sigi iya lulukso ngan paradayaw si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ngan pakakulaw-na si dimu'an mga a'a si pagparalalangngan-na, ngan akabati' si pagparadayaw-na si Diyos, ");
INSERT INTO abx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sakilala-na mga iya nga iya i magparalumpagi' ngan magparapalimos ari si Pinakamahalap Pwirtahan. Ag'usa gayod mga iya si mahinabo' si lulid. ");
INSERT INTO abx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Si pagparakuyut-kuyut-na si parapalimos ari si kas Pedro pati' Juan, ag'usa i dimu'an mga a'a ngan dagmit to pamatapit si mga iya ari si Balkun-na si Solomon. ");
INSERT INTO abx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ngan pakakulaw-na sinan si Pedro, amahalling iya, “Mga igkasi-ko a'a-na si Israel, ay kay ag'usa kam gayod sito? Kapa'i may kay agparabuslung-bi kami' nga si pagkagasi-bi gahom kami' o pagkadiyusnon kami' i makapalangngan sito a'a? ");
INSERT INTO abx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I Diyus-na si Abraham, si Isaac, si Jacob, pati' si kapapu'-papu'an-ta kam, iya i magpakulaw si ka'angayan-na si Jesus nga rilihugun-na pina'agi si pagpalangngan sito a'a. Agpa'intriga-bi si Jesus si mga puno' basi' nagmatay, ngan agsikway-bi iya atubang si Pilato bisan kon i karuyag-na, palibri-na iya. ");
INSERT INTO abx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Agsikway-bi i Sagrado ngan Matadong A'a-na si Diyos, ngan agpalaku-bi lugod nga akalibri dina i kriminal. ");
INSERT INTO abx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Agpamatay-bi i magbuwan si ungod kinabuhi', pero agbanhaw-na iya si Diyos ngan kami' mismo i makatistigos sito. ");
INSERT INTO abx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","I gahum-na si arun-na si Jesus, iya i magpabaskog sito lulid. I pagtutu'o si arun-na, iya i maghimo si sakulawan-bi pati' sakatu'anan-bi. I pagtu'o nagpumwan-na si Jesus, iya i makapalangngan si iya ngan sayod kam dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga kabugtu'an, katu'anan ako nga ga'i kam anabot kon ay i manakka si nagpanbuhat-bi ngan da'inan may liwat i mga punu'-bi. ");
INSERT INTO abx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ma'in ba' nga makigpasumat-na andang si Diyos si dimu'an mga paragsumat-na nga papasakitan i Tinu'inan-na Mannanalwas ngan da'ito sito i pagtuman-na? ");
INSERT INTO abx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sanglit agbasula kam huwang si pagbag'o ngan pahuwanga kam gihapon si Diyos, kay basi' para'-na i mga sala'-bi. Pahuwanga kam basi' patakka-na liwat si Paragdalom i panahon si kamurayaw pagpasarig si kina'iya-na si a'a, ");
INSERT INTO abx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ngan basi' lihug-na gihapon i Tinu'inan Mannanalwas nga iya si Jesus nga nagtubyanan para si ka'am. ");
INSERT INTO abx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kinahanglan ari iya ag'istar si langit tubtob anakka i panahon si pagbag'u-na si Diyos si dimu'an, pagtuman si sa'ad-na siray mga panahon nga nagpasurat-na si mga sagrado paragsumat-na. ");
INSERT INTO abx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Intumu-bi nga agpinugad si Moises, ‘I Diyos, nga iya i Paragdalom nagtutu'u-bi, iya i mamatubyan paragsumat tikang mismo si ka'am nga pariho si pagpatubyan-na si ako. Kinahanglan kam agtuninong basi' akatuman si dimu'an nagpanumat-na. ");
INSERT INTO abx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bisan say i ga'i magtuninong si iya, pinabulag tikang si mga ginsakupan-na hasta si kahastahan.’ ");
INSERT INTO abx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Si kamatu'uran, makigpasumat-na andang si Diyos si dimu'an mga paragsumat i mahinabo' ina'anto mga allaw. Tikang si paragsumat Samuel hasta pa i mga manunod, gana' makalihis pagpahalling sito. ");
INSERT INTO abx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ka'am i mag'iridar si dimu'an tawa'-na pati' nagla'uman-na si mga paragsumat siray ngan para si ka'am i pagkasarabutan naghimu-na si Diyos nga ag'aku'-na si mga kapapu'-papu'an-bi. Agsumatan-na si Abraham, ‘Buruwanan i dimu'an mga a'a si kalibutan si mga kabubuwasun-na pina'agi si minamat-mo.’ ");
INSERT INTO abx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sanglit ngan pagpa'undung-na si Diyos si rilihugun-na, agpapada'itu-na iya dahulo si ka'am basi' ka'am i binuwanan-na si kabubuwason kon sa'ambanan-bi balang addangan i mga mara'at kina'iya-bi.” ");
INSERT INTO abx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sigi surusalli' pagpahalling si Pedro pati' Juan si mga a'a. Sinan uras, aniya' pamadugok mga paraghalad pati' mga Sadusiyo ngan huwang i kapitan si mga bantay si templo. ");
INSERT INTO abx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Agkasirina gayod mga iya kay agturo' i mga apostol si mga a'a, ngan aggamit-na mga iya i pakabanhaw-na si Jesus pagpasamwak nga abanhaw i dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sanglit ag'aristar-na mga iya kas Pedro pati' Juan, ngan tungod kay tikatunod na i allaw, agpamrisu-nay to mga iya tubtob si ka'asumuhan. ");
INSERT INTO abx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero malabbat dina i magpanutu'o si mga magpamakali si sumat, ngan anakka mga singko mil i katabbul-na si mga lalla bisan kon ma'in kwintado i mga danda. ");
INSERT INTO abx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ka'asumuhan, agtiriripon si Jerusalem i mga puno' Hebro pati' i mga mata'o kamabu'utan hasta i mga paragturo' bala'od. ");
INSERT INTO abx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Huwang liwat ari si Anas, nga gilalabawi paraghalad, ngan da'inan may si Caifas, Juan, Alejandro pati' i ditangnga' pa mga lalla si pamilya-na si gilalabawi paraghalad. ");
INSERT INTO abx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Makigpa'ala'-na mga iya si Pedro pati' Juan pagpada'iray atubang si mga iya ngan agtikangan-nay to pagtilaw, “Say tawa' gahom o say tawa' aron i naggamit-bi nga agtugot si ka'am pagbuhat sito?” ");
INSERT INTO abx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mangno, tungod si pagdalum-na si Espirito Santo akasaruman si Pedro, “Ka'am nga mga puno' pati' ka'am nga mga mata'o kamabu'utan si mga Hebro, ");
INSERT INTO abx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kon nagpatawag kami' ina'anto pagpasayod mahi'unong si nagbuhat kami' kalu'oy si lulid ngan pinatilawan kon pinapa'i iya anhalap, ");
INSERT INTO abx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kinahanglan kam katu'anan sito hasta i dimu'an mga a'a ato si Israel: Yayto a'a, magtutunggoy to atubang si ka'am, bali na gayod sagha'. Agpasagha'-na iya si gahum-na si arun-na si Jesu-Kristo nga taga Nasaret, i makigpapaku'-bi si kudos pero agbanhaw-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iya i bato nagtukoy si Kasuratan nga agpinugad: I bato nga nagdiri'-bi, ka'am mga panday, iya lugod dina i makapasarig si dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iya hamok i katalwasan-ta. Gana' la'in aron nagpa'intriga si mga a'a ato si bug'os kalibutan nga aniya' gahum-na pagtalwas si kita kam.” ");
INSERT INTO abx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Si pakakulaw-na si Kunsiho si kapusukadu-na kas Pedro pati' Juan, ag'usa mga iya. Ag'usa liwat mga iya kay sadiskubrihan-na nga urdinaryoy to hamok mga a'a ngan gana' iniskwilahan-na. Samangnuhan-na mga iya nga agpakihuwang to mga a'a si Jesus siray. ");
INSERT INTO abx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pero ga'i mga iya agpakasibo' kay sakulawan-na mga iya i managha' lalla nga agtutunggo atubang si mga iya. ");
INSERT INTO abx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sanglit agmandaran-nay to mga iya paggawas si Kunsiho ngan agbararagaw. ");
INSERT INTO abx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Agsipurupatilaway i mga huwang si Kunsiho, “Ay ba' i binuhat-ta kam sito mga a'a? Akatu'anan i dimu'an magpangistar ato si Jerusalem nga aghimo mga iya makagagahom binuhatan nga bali kapambihira, ngan ga'i nan sadidiwarayan-ta kam. ");
INSERT INTO abx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero basi' ga'i na agsasamwak si mga a'a i mahi'unong sito, gulat-tay to mga iya. Kinahanglan ga'i na mga iya aggamit si arun-na si Jesu-Kristo pagpahalling si bisan say.” ");
INSERT INTO abx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mangno, agban'u-na mga iya gihapon kas Pedro pati' Juan. Agmandaran-nay to mga iya nga ga'i gayod aggamit si arun-na si Jesus pagpahalling pati' pagturo'. ");
INSERT INTO abx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero anaruman dina si Pedro pati' Juan, “Ka'am mismo manhusgar kon tama' si pangulawan-na si Diyos i pagsunod si ka'am kuntra si iya. ");
INSERT INTO abx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kinahanglan agpadayon gayod kami' pagsumat si sakulawan kami' pati' si sapakalihan kami'.” ");
INSERT INTO abx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kahuman si pagparagulat-na si Kunsiho, agpagawas-nay to mga iya. Ga'i mga iya aka'anda' tama' pa'agi pagkastigo si kas Pedro pati' Juan kay agpandayaw si Diyos i dimu'an mga a'a tungod si mahinabo'. ");
INSERT INTO abx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","I lalla may nga nagpasagha'-na si pambihira gahom, subra na kwarinta i idad-na. ");
INSERT INTO abx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pakagawas-na kas Pedro pati' Juan, pabwilta mga iya si mga igkasi-na magpanutu'o. Agsumat-na mga iya i dimu'an nagpinugad-na si mga puno' paraghalad pati' mga mata'o kamabu'utan. ");
INSERT INTO abx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Si pakapakali-na mga iya sinan, ag'aradda mga iya pagpangadyi' makusog, “Makagagahom Paragdalom kami', ka'aw i maghimo si kalangitan, si pitak, si kalawot, pati' si dimu'an mga inanna'-na sito. ");
INSERT INTO abx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Rilihugun-mo i gipapu'-papu'i kami' David. Ka'aw i magpapahalling si Espirito Santo si iya si pagpinugad: Apa'i kay agkasirina gayod i la'in mga nasyon, ngan agkurunsabo mga iya nga gana' may pulus-na? ");
INSERT INTO abx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Agpangandam pagsupak si Paragdalom i mga hadi' si kalibutan, ngan ag'aradda i mga puno' kuntra si nagtu'inan-na pagtalwas. ");
INSERT INTO abx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Si kamatu'uran agtiriripon kas gubirnador Herodes pati' si Poncio Pilato ato sito syudad huwang si ditangnga' pa mga a'a-na si Israel pati' si mga ma'in Hebro basi' agkurunsabo kuntra si sagrado rilihugun-mo nga si Jesus. Iya i nagtu'inan-mo pagtalwas. ");
INSERT INTO abx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Agbuhat-na mga iya i dati nagpili'-mo nga angay mahinabo' ngan awinan hamok si ka'aw i pagdalom tungod si gahum-mo ngan tungod kay iya i katuyu'an-mo. ");
INSERT INTO abx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Paragdalom kami', usisahon may ina'anto mga paggulat-nay to mga iya. Tugutin kami' mga rilihugun-mo, nga magin pusukado pagpasamwak si sumat-mo. ");
INSERT INTO abx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pakulawon i gahum-mo pagbulong. Buhaton i mga pangngilalahan si kasiguruhan pati' mga urusahon. Makighimu'on to si gahum-na si arun-na si sagrado rilihugun-mo nga si Jesus.” ");
INSERT INTO abx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kahuman-na mga iya pagpangadyi', abay'og pariho si linog i lugar nagtiripunan-na mga iya. Agdaluman-na mga iya dimu'an si Espirito Santo ngan pusukado mga iya pagpasamwak si allingun-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ag'aradda i dimu'an magpanutu'o si mga paminsada-na pati' mga katuyu'an-na. Gana' magpinugad nga tawa'-na hamok i mga inanna'-na, pero agsi'uru'arambitay mga iya si dimu'an mga tawa'-na. ");
INSERT INTO abx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Agpadayon i mga apostol pagtistigos si kabanhaw-na si Ginu'o Jesus. Mahaya i gahum-na mga iya pagpahalling ngan agpalangga'-na gayod si Diyos i dimu'an magpanutu'o. ");
INSERT INTO abx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Balang ta'ud-ta'od, aniya' si mga iya magbaligya' pitak o ma'in ngani' mga ruma' ngan agpa'intriga-na mga iya i balli-na ari si mga apostol basi' mga iya mag'antan, ngan agtaltag-nay ray mga iya si bisan say kumpurmi si nagkinahanglan-na. Sanglit gana' kinulangan si mga iya. ");
INSERT INTO abx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aniya' taga isla Cipre nag'arunan Jose. Huwang iya si grupu-na si mga paraghalad Levita ngan nag'anga'an iya Bernabe si mga apostol nga i kahulugan-na, parag'aghat si makarungayan pagla'om. ");
INSERT INTO abx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Agbaligya' to a'a si pitak-na ngan agpa'intriga-na i balli-na ari si mga apostol basi' mga iya mag'antan. ");
INSERT INTO abx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aniya' a'a nag'arunan Ananias huwang si alla-na Safira nga agbaligya' liwat si pitak-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Agsabot mga iya si alla-na nga tagu'-na i ditangnga' kwarta, pero agbawa-na pada'iray si mga apostol i ditangnga', ngan agpa'intriga-na ari basi' mga iya mag'antan. ");
INSERT INTO abx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mangno amatilaw si Pedro, “Ananias, apa'i kay abawa kaw si Satanas hasta nga agbullu'an-mo i Espirito Santo ngan agtagu'-mo i ditangnga' kwarta sakarawat-mo ngan pagbaligya'-mo si pitak? ");
INSERT INTO abx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ma'in ba' ray tawa'-mo myintras ray nagbaligya'an? Ka'aw magtu'ig si kwarta ngan pakatima pagbaligya'. Ay i sapinsaran-mo kay agbuhat kaw sito? Ma'in mga a'a i nagbullu'an-mo, lugod i Diyos dina.” ");
INSERT INTO abx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Si pakapakali-na sinan si Ananias, atumba iya ngan amatay. Bali gayod katalaw-na si dimu'an magpakapakali hi'unong si mahinabo'. ");
INSERT INTO abx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mangno aniya' mga dadi'-dadi'on pa lalla pamadugok ngan agputus-na mga iya i bangkay-na. Agbawa-nay to mga iya pagawas ngan aglabbungan-na dayon. ");
INSERT INTO abx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mga tallo uras i pa'agi, pasallod i alla-na nga ga'i katu'anan si mahinabo'. ");
INSERT INTO abx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Agpatilawan-na iya si Pedro, “Sumatin ako, iya ba' to i dimu'an balli-na si pitak sakarawat-bi si Ananias?” Anaruman iya, “Oho', yaynan i balli-na.” ");
INSERT INTO abx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mangno agpinugad-na iya si Pedro, “Apa'i kay angabuyon kaw pagpurbar kon sadaya'an-bi i Espiritu-na si Paragdalom? Pakalihin! Kinabati'an na i mga pitad-na si mga a'a maglabbong si alla-mo. Barawahun-na liwat kaw mga iya pagawas.” ");
INSERT INTO abx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sinan mismo, atumba iya ngan amatay atubang si Pedro. Mangno pamasallod gihapon i mga lalla ngan sakulawan-na mga iya nga minatay liwat i danda. Agbawa-nay to mga iya pagawas ngan aglabbungan-na dayon tingpid si alla-na. ");
INSERT INTO abx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bali gayod katalaw-na si bug'os manniniripon pag'ampo' hasta si dimu'an makatu'anan mahi'unong sito mga hinabo'. ");
INSERT INTO abx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Agparapanhimo i mga apostol malabbat mga pangngilalahan si langitnon kasiguruhan pati' mga urusahon si mga a'a. Kabatasanan-na si dimu'an magpanutu'o pagtiriripon ari si Balkun-na si Solomon. ");
INSERT INTO abx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gana' ni addangan mamuso' pahuwang si mga iya bisan kon nagtahuran mga iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kundi' bisan pa, malabbat gihapon mga lalla pati' mga danda magpanutu'o si Ginu'o nga akatamba si mga iya. ");
INSERT INTO abx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sanglit, tungod si nagparabuhat-na si mga apostol, nagpamawa i mga maburong pada'iray si kakalsadahan. Aghulid-nay to mga iya si mga katri ngan i ditangnga' may si mga tipo, basi' bugana' pa nga aniya' si mga iya salandungan-na si Pedro si palabay-na. ");
INSERT INTO abx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Malabbat liwat magpanggubok ari nga tikang si mga bungto matapit si Jerusalem. Agpamawa-na mga iya i mga maburung-na pati' i mga magpangantos si pagpamawa-bawa-na si mga mara'at espirito, ngan anhalap to mga iya dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mangno, bali gayod ka'awa'-na si gilalabawi paraghalad pati' si dimu'an mga kahuruwangan-na nga huwang si grupu-na si mga Sadusiyo. ");
INSERT INTO abx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sanglit agpadakup-na mga iya i mga apostol ngan agpamaprisu-na. ");
INSERT INTO abx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero kasanguman, ag'abrihan-na si anghel naglihug-na si Paragdalom i mga pwirtahan-na si prisuhan, ngan agpagawas-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Agpinugad iya, “Pada'iraya kam si mga hawan-na si templo ngan sumati-bi i mga a'a si bug'os sumat mahi'unong si baha'oy to kinabuhi'.” ");
INSERT INTO abx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kanalungan, agtuman-na mga iya i panlihugan. Pamasallod mga iya si mga hawan-na si templo ngan agpadayon mga iya pagturo' si mga a'a. Si panakka-na si gilalabawi paraghalad pati' si mga kahuruwangan-na ari si templo, agpatawag-na mga iya i bug'os Kunsiho nga iya i pagtiripun-na si dimu'an mata'o kamabu'utan si mga a'a-na si Israel. Aglihog mga iya pagpada'iray si prisuhan pag'ala' si mga apostol. ");
INSERT INTO abx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero ngan panakka-na si mga tinapuran, ga'i to sa'anda'an-na mga iya ari. Sanglit agpamwilta mga iya ngan agpanumat, ");
INSERT INTO abx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kandado pa i prisuhan ngan i mga bantay agtutunggo pa liwat si pwirtahan. Pero si pangabri kami' sito, gana' sa'anda'an kami' si sallod bisan addangan si mga iya.” ");
INSERT INTO abx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aburong i kapitan si mga bantay si templo pati' i mga puno' paraghalad si pakapakali-na mga iya sito sumat. Ag'usa mga iya kon ay i panakkahan-na sito. ");
INSERT INTO abx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mangno aniya' manakka addangan ngan agpinugad, “Kulawi-bi! Agparapanunggo ari si mga hawan-na si templo ngan agparaturo' si mga a'a i mga nagpanprisu-bi.” ");
INSERT INTO abx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sinan mismo, pada'iray i kapitan huwang si mga tinapuran sakup-na, ngan ag'ala'-na i mga apostol. Ga'i mga iya aggamit pwirsa kay atalaw mga iya kon talutugan-na mga iya si mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Si paka'ala'-na mga iya si mga apostol, agpa'atubang-nay to mga iya si Kunsiho basi' sapatilawan-na si gilalabawi paraghalad. ");
INSERT INTO abx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Lingun-na, “Bali kapipina kami' si ka'am nga ga'i kam agturo' labihan na si paggamit si arun-na sito a'a. Pero agpasamwak-bi si bug'os Jerusalem i nagturu'-bi, ngan disidido kam gayod pagpamatu'od nga kami' i aniya' baratunun-na si kamatayun-na.” ");
INSERT INTO abx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Anaruman si Pedro pati' i la'in pa mga apostol, “Kinahanglan kami' agsunod si karuyag-na si Diyos kuntra si karuyag-na si mga a'a! ");
INSERT INTO abx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Agpamatay-bi si Jesus; agpabiyat-bi iya si day sanga-na si kayo pero i Diyus-na si kapapu'-papu'an-ta kam, iya i magbanhaw si iya. ");
INSERT INTO abx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mangno agpa'anna'-na iya si Diyos si gilalabawi pwisto ari si kawanan-na, ngan aghimu-na Prinsipi pati' Paragsalbar, basi' iya i makapabasol si mga a'a-na si Israel huwang si pagbag'o ngan basi' iya i magpasaylo si mga sala'-na. ");
INSERT INTO abx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tistigos kami' sito mga hinabo', ngan agtistigos liwat i Espirito Santo nga nagpa'ayup-na si Diyos si mga magpanunod si iya.” ");
INSERT INTO abx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Si pakapakali-na sinan si Kunsiho, agkasirina gayod mga iya ngan agmamatay-na i mga apostol. ");
INSERT INTO abx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero aniya' addangan si mga Parisiyo nag'arunan Gamaliel nga manunggo ngan agmandar pagpagawas dahulo kali'-kali' si mga apostol. Adda liwat iya paragturo' bala'od huwang si Kunsiho nga nagtahuran si dimu'an a'a. ");
INSERT INTO abx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Si pakagawas-na si mga apostol, agdiskurso iya, “Mga igkasi-ko a'a-na si Israel, agmatuha kam si buruhatun-bi sito mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pira pa hamok ta'on pa'agi, paluwa' si Teudas nga agpahaya-haya a'a. Aniya' mga kwatro syintos a'a magsunod si iya. Nagmatay iya ngan agburulag-bulag i dimu'an mannurunud-na ngan gana' pulus-na si dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kahuman si iya, ngan pagparapamarihistru-na si mga a'a siray, paluwa' i nag'arunan Judas nga taga prubinsya Galilea. Agpasunud-na i malabbat a'a pagkuntra si gubyirno. Nagmatay liwat iya ngan agburulag-bulag liwat i dimu'an mannurunud-na. ");
INSERT INTO abx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sanglit, mahi'unong sito ina'anto kamutangan, waydungan-ta kam: Pata'ani-bi to mga a'a! Pamalibrihu-bi mga iya. Kon mga a'a hamok i maghimo si katuyu'an-na o trabahu-na mga iya, ga'i nan akapadayon. ");
INSERT INTO abx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero kon tikang nan si Diyos, ga'i nan sapinahan-bi mga a'a ngan sakatu'anan-bi na hamok nga agpakihiran kam si Diyos.” ");
INSERT INTO abx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Agka'araghat mga iya si mga nagpahalling-na sito a'a. Agpaban'u-na mga iya i mga apostol pagpasallod ngan agpalapdus-nay to mga iya tubtob agkaralaksi' i mga panit-na. Mangno, agpanmandaran-na nga ga'i na aggamit si gahum-na si arun-na si Jesus pagpahalling, ngan agpamalibri-na. ");
INSERT INTO abx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Si pa'amban-na si mga apostol si kunsiho, mga malipayon mga iya kay si pangulawan-na si Jesus angay hamok si mga iya i pag'antos kamamalu'an tungod kay tangkod i pag'aku'-na mga iya si arun-na. ");
INSERT INTO abx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ga'i mga iya pahuway pagturo' pati' pagpasamwak si mahalap sumat nga si Jesus i Tinu'inan Mannanalwas. Allaw-allaw to agparabuhat-na mga iya ari si mga hawan-na si templo ngan da'inan may si pala'in-la'in ruma'. ");
INSERT INTO abx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Siray mga allaw sigi lalabbat i mga inadalan-na si Jesus ngan agsaralakot hamok i mga Hebro nga Grikuhanon i pinahallingan-na pati' i mga Hebruhanon. Mangno agriklamo i mga Grikuhanon kuntra si mga Hebruhanon kay naglihisan i mga balu-na mga iya si ayuda balang allaw. ");
INSERT INTO abx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Sanglit agtiripun-na si Dusi i dimu'an mga inadalan, ngan agpaminugad-na, “Ma'in tama' kon ambanan kami' i pagpasamwak si allingun-na si Diyos, basi' hamok sapanginano kami' i mga kinahanglanun-na si mga balu-ta kam. ");
INSERT INTO abx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sanglit mga kabugtu'an, amili'a kam pitungan mismo anan si ka'am nga kilala si pagkamadunong pati' si pagkamasinunuron si pagdalum-na si Espirito Santo. Pa'intriga kami' to buruhaton si mga iya, ");
INSERT INTO abx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","basi' sa'arop kami' i pagpasamwak si allingon hasta pa i pagpangadyi'.” ");
INSERT INTO abx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Angabuyon i dimu'an mga a'a si nagkabaragawan. Agpili'-na mga iya si Esteban nga hul'os gayod i pagtutu'u-na ngan agsunod gayod si pagdalum-na si Espirito Santo. Nagpili' liwat kas Felipe, Prucuro, Nicanor, Timon, Parmenas pati' si Nicolas. Taga sunsari'i to iya si syudad Antioquia nga abawa dahulo si rilihiyun-na si mga Hebro. ");
INSERT INTO abx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nagpama'atubang to mga a'a ari si mga apostol. Mangno agpamangadyi' i mga apostol ngan agpamadu'un-na i mga palat-na pagtubyan si katungdanan-na si balang addangan. ");
INSERT INTO abx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Sanglit agsamwak i allingun-na si Diyos. Madagmit i paglabbat-na si mga inadalan ari si Jerusalem ngan malabbat si mga paraghalad magpanunod si ungod pagtu'o. ");
INSERT INTO abx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aka'angkon si Esteban si mapinalangga'on pagpanginanu-na si Diyos pati' si mahaya gahom. Agparahimo iya pirmi mga urusahon pati' mga pangngilalahan si langitnon kasiguruhan atubang si mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero aniya' grupo manguntra tikang si Sinaguga-na si mga Libri Lalla. Da'inan i pag'aron sinan tungod kay i mga sakup-na dati mga uripon pero ina'anto nagpalibri na. Taga sunsari'i mga iya si mga syudad Cirene pati' Alejandria ngan i ditangnga' tikang si mga prubinsya Cilicia pati' Asia. Agtikang to mga lalla pagpakipasuhay si Esteban, ");
INSERT INTO abx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","pero salupig-na mga iya si kadunung-na pati' si nagparapahalling-na si Espirito Santo pina'agi si iya. ");
INSERT INTO abx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mangno agkunsabo mga iya mga a'a nga pagpinugad, “Sapakalihan kami' si Esteban agparapakara'at si arun-na si Moises hasta si Diyos.” ");
INSERT INTO abx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sanglit agsamuk-na si mga Libri Lalla i mga a'a pati' i mga mata'o kamabu'utan, ngan da'inan may i mga paragturo' bala'od. Agdagnas-na mga iya si Esteban ngan agbawa-nay to atubang si Kunsiho. ");
INSERT INTO abx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ag'andam mga iya burubullo' tistigos nga agsumat, “Yayto a'a ga'i pahuway pagpakara'at si sagrado templo pati' si bala'od, ");
INSERT INTO abx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","kay sapakalihan kami' nga agpinugad iya, ‘Bungkag-nay to lugar si Jesus taga Nasaret ngan salli'an-na i kabatasanan nagturu'-na si Moises si kita kam.’” ");
INSERT INTO abx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I dimu'an magpaningkulo' si kunsiho agpamuslong pahalap si Esteban, ngan sakulawan-na mga iya nga agsana'ag i bayhun-na pariho si bayhun-na si adda anghel. ");
INSERT INTO abx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mangno amatilaw i gilalabawi paraghalad si Esteban, “Ungod ba' to mga sumbong?” ");
INSERT INTO abx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Anaruman iya, “Mga kabugtu'an pati' mga mahanak, pamati'i-bi ako! Ngan kari'i-na pa si prubinsya Mesopotamia, antis iya ag'istar ari si syudad Haran, sakulawan-na si gipapu'-papu'i-ta kam Abraham i Diyos nga aniya' maka'angayan danta'-na. ");
INSERT INTO abx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Agpinugad-na iya si Diyos, ‘Ambanin i nasyun-mo pati' i kabugtu'an-mo, ngan pada'iraya si pitak papakulawun-ko si ka'aw.’ ");
INSERT INTO abx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Sanglit pa'amban iya si Mesopotamia nga kilala liwat si aron Kaldea ngan palalin iya si Haran. Ngan minatay na i tatay-na, agpapada'itu-na iya si Diyos ato sito pitak nag'istaran-bi to ina'anto. ");
INSERT INTO abx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ga'i iya agbuwanan-na si Diyos iriridaron ato bisan namay hamok day palat pitak. Lugod, agsa'ad i Diyos nga arangkunun-nay to pitak si Abraham pati' si mga ka'ampu-ampuhan-na, bisan kon gana' pa dadi'-na si Abraham si pagpinugad-na sito. ");
INSERT INTO abx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Agpinugad-na liwat iya si Diyos, ‘Mga dayuhan i ka'ampu-ampuhan-mo ari si la'in nasyon ngan nag'uripon mga iya sallod si kwatro syintos ta'on. ");
INSERT INTO abx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero kastigu-ko i nasyon mag'uripon si mga iya. Kahuman sinan, pamagawas mga iya sinan nasyon ngan ampu'an-na ako mga iya ato sito lugar.’ ");
INSERT INTO abx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mangno ag'aku'-na si Abraham i pagkasarabutan naghimu-na si Diyos, ngan agpaturi' si Abraham pagpakilala nga agsunod iya si pagkasarabutan. Agpadayun-nay to si Abraham pada'iray si dadi'-na Isaac sanglit agturi'-nay to ngan pagwalo' allaw-na tikang si paka'allum-na. Da'ito liwat sito i nagbuhat-na si Isaac pada'iray si dadi'-na Jacob ngan da'inan may si Jacob pada'iray si dusi dadi'-na nga ginikanan-na si nasyun-ta kam. ");
INSERT INTO abx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Addangan si Jose si dusi to. Nagbaligya'an iya si unsi ngan nagbawa pan Ehipto pagpa'uripon kay mismo mga iya nga ginikanan-na si nasyun-ta kam agka'arawa' si bugtu'-na. Pero ga'i iya agpata'anan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Agsalbar-na si dimu'an mga kakurihan-na ngan agbuwanan-na kadunong. Agbuligan-na iya basi' palangga'-na si Paraon, nga hadi' ari si Ehipto. Sanglit iya i nagtapuran-na si Paraon pagpamuno' si bug'os Ehipto hasta si dimu'an mga inanna'-na. ");
INSERT INTO abx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mangno aniya' manakka gutom si Ehipto pati' si Canaan. Bali gayod kakurihan siray lugar ngan i mga kapapu'-papu'an-ta kam agkuri si pagkinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ngan pakabati'-na si Jacob nga aniya' pa pagkakan ari si Ehipto aglihug-na i mga dadi'-na. ");
INSERT INTO abx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ari si kaduwa biyahi-na agpakilala si Jose si kalugaringun-na si mga siyaka-na ngan sasayuran-na dayon si Paraon i pamilya-na kas Jose. ");
INSERT INTO abx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kahuman sinan, agpa'ala'-na si Jose si Jacob nga iya i tatay-na pati' i ditangnga' mga kabugtu'an-na. Sitintay singko dimu'an mga iya. ");
INSERT INTO abx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mangno palalin si Jacob ari si Ehipto ngan ari na hamok agkamaratay i mga kapapu'-papu'an-ta kam huwang si Jacob. ");
INSERT INTO abx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nagbalikan gihapon i mga bangkay-na pan syudad Sikem ngan naglabbungan ari si adda kwiba panlalabbungan nagballi-na andang si Abraham ray. Agballi-nay to si tama' kantidad tikang si mga dadi'-na si Hamor ari si Sikem. ");
INSERT INTO abx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ngan titakka na i uras pagtuman-na si Diyos si sa'ad-na para si Abraham, aglalabbat may i mga a'a-ta kam ari si Ehipto. ");
INSERT INTO abx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pa'agi i pira ta'on aniya' la'in hadi' ari si Ehipto nga ma'in sayod si kinabuhi'-na si Jose. ");
INSERT INTO abx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Agdaya'an-na i mga a'a-ta kam ngan agpanda'ug-da'ug-na. Agpirit-na i mga kapapu'-papu'an-ta kam pagpatapok si mga baha'o allom dadi'-na mga iya basi' agkamaratay nga ga'i aglabbat. ");
INSERT INTO abx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Siray uras a'allom may si Moises, ngan bali iya kalalaki dadi'-dadi'. Nag'ataman iya ari tallo bulan si panimalay-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ngan ga'i na pwidi atago', nagpa'anna' si Moises ari si gawas, sa'anda'an-na iya si prinsisa nga dadi'-na si Paraon ngan ag'ataman-na pariho si kalugaringun-na dadi'. ");
INSERT INTO abx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nagturu'an si Moises si dimu'an kadunung-na si mga taga Ehipto. Bantugan iya si pagpahalling pati' si pagtrabaho. ");
INSERT INTO abx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ngan kwarinta na i idad-na si Moises, akahuna'-huna' iya pagpanginano kon ay i kamutangan-na si mga kapararihu-na a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akakulaw iya addangan taga Israel nga ma'in tama' pagkakastigu-na si taga Ehipto. Sanglit amulos iya ngan agmatay-na i taga Ehipto. ");
INSERT INTO abx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aka'anna' si isip-na si Moises nga agpili'-na iya si Diyos pagsapod si mga igkasi-na, ngan agla'om iya nga agpanabot mga iya sito, pero ga'i may bali'. ");
INSERT INTO abx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ka'asumuhan, akabagat na liwat si Moises duwangan mga a'a-na si Israel maghiran. Agsagdunan-nay to kunta' mga iya si pagpinugad, ‘Ay ba' kam? Pariho may kam hamok Hebro! Ay kay agsipurupapaddihay kam?’ ");
INSERT INTO abx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Pero patikwang-na dina si Moises si magkastigo si addangan ngan aminugad, ‘Say i magtu'in si ka'aw nga ka'aw i puno' pati' huwis para si kami'? ");
INSERT INTO abx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Matay-mo ba' liwat ako pariho si pagmatay-mo ngan da'illaw si taga Ehipto?’ ");
INSERT INTO abx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ngan pakabati'-na sinan si Moises, palitira iya pagtago' ari si mga Midiano. Ag'istar iya ari bilang dayuhan ngan inallahan nga agdadi' duwangan lalla. ");
INSERT INTO abx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pa'agi i kwarinta ta'on. Mangno aniya' anghel pakulaw si Moises ari si magpakayat tanaman si disyirto matapit si Bukid Sinai. ");
INSERT INTO abx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pakakulaw-na sinan, nginarat iya. Si pagtatapit-na pag'usisa, sabati'an-na i busis-na si Paragdalom: ");
INSERT INTO abx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako mismo i Diyus-na si kapapu'-papu'an-mo; i Diyus-na kas Abraham, Isaac pati' si Jacob.’ Agkurug-kudog si Moises si katalaw ngan ga'i na mangahas pagkulaw. ");
INSERT INTO abx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mangno agpinugad-na iya si Paragdalom, ‘Ala'on sandalyas-moy nan kay sagradoy nan pitak nagtutungguhan-moy nan. ");
INSERT INTO abx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Sakulawan-ko na i pagda'ug-da'og si mga ginsakupan-ko ari si Ehipto. Sapakalihan-ko i mga inaraba-na ngan pada'ito ako paglibri si mga iya. Paduguka kay lihug-ta kaw pabwilta pan Ehipto.’” ");
INSERT INTO abx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Agpadayon si Esteban pagpahalling, “Yayto Moises, iya gihapon i Moises nga nagdiri' si mga taga Israel si allingon, ‘Say i magtu'in si ka'aw nga ka'aw i puno' pati' huwis para si kami'?’ Kundi' aglihug-nay to iya si Diyos pagpamuno' pati' paglibri si mga iya, pina'agi si anghel magpakulaw si iya ari si magpakayat tanaman. ");
INSERT INTO abx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises i magtuttot si mga taga Israel paggawas si Ehipto. Agparahimo iya urusahon pati' mga pangngilalahan si langitnon kasiguruhan ngan ari pa iya si Ehipto pati' ari si Piyat Kalawot. Agpadayon iya mga kwarinta ta'on pa paghimo sito ari si disyirto. ");
INSERT INTO abx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yayto Moises i magsumat si mga a'a-na si Israel, ‘Aniya' paragsumat pinaguwa'-na si Diyos tikang mismo si ka'am nga pariho si pagpatubyan-na si ako.’ ");
INSERT INTO abx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Huwang iya si magtiriripon ari si disyirto ngan aghururuwang si kapapu'-papu'an-ta kam. Huwang liwat iya si anghel magbagaw si iya ari si Bukid Sinai. Iya i nagtu'inan si allom mga allingun-na si Diyos basi' pasamwak-na si kita kam. ");
INSERT INTO abx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero andiri' i kapapu'-papu'an-ta kam pagsunod si Moises. Nagbaribadan dina iya ngan agka'arawil mga iya pagbwilta pan Ehipto. ");
INSERT INTO abx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ngan ari pa si Moises si Bukid Sinai, pa'ayop mga iya si Aaron nga siyaka-na si Moises ngan agpinugad, ‘Anhimu'a mga diyus-diyos magtuttot si kita kam si tama' lalan. Ga'i na sakatu'anan-ta kam kon apa'i na si Moises nga magtuttot si kita kam paggawas si Ehipto.’ ");
INSERT INTO abx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iya na i paghimu-na kas Aaron adda diyus-diyos pariho si nati-nati baka. Agbuno' mga iya mga hayop panhahalad sito ngan agkalipay pagbuwan unra si sahimu-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sanglit agtalikutanan-na mga iya si Diyos, ngan agpata'anan-na mga iya nga a'uripon si pag'ampo' si kabitu'unan. Ag'alagad to si maka'anna' si Libru-na si mga Paragsumat: Mga a'a-na si Israel, ma'in ray para si ako, i nagbunu'-bi hayop ngan nagpahalad-bi, si kwarinta ta'on ari si disyirto. ");
INSERT INTO abx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I karru-na si ladawan-na si Molok pati' si bitu'on Refan i nagparapalangkit-bi. Aghimu-bi duway to mga diyus-diyos basi' sa'ampu'an-bi. Sanglit distirru-ta kam ari si dahulu'an-na pa si Babilonia. ");
INSERT INTO abx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Iya liwat to i kapapu'-papu'an-ta kam nga aghimo pangngingistaran-na tulda si Diyos pagpa'intom nga pirmi to huwang si mga iya ari si disyirto. Naghimoy to pagtuman si tugun-na si Diyos si Moises, pagpapariho si pangngirugan nagpakulaw-na si iya. ");
INSERT INTO abx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nagpa'iridar to pangngingistaran si kapapu'-papu'an-ta kam pada'iray si mga dadi'-na, ngan agbawa-nay to mga iya si uras si pagpunu'-na si Josue pag'angkon sito pitak. Sa'angkun-nay to mga iya pitak tungod kay agpapinda-na dahulo si Diyos i mga a'a-na si mga dati nasyon ato. Nag'ataman to pangngingistaran ato sito pitak tubtob si panahun-na kas David nga ");
INSERT INTO abx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","pinalangga'-na si Diyos. Agsarit iya kon akatindog ba' pangngistaran-na si Diyus-na kas Jacob. ");
INSERT INTO abx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero si Solomon nga dadi'-na si David i makapatindog dina si templu-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Kundi' i Gilalabawi Diyos ga'i ag'istar si mga tinindug-na si a'a, kay mismo i Paragdalom agpasayod pina'agi si paragsumat-na: ");
INSERT INTO abx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","I langit, iya i trunu-ko ngan i kalibutan, iya i pannungtungan-na si kitid-ko. Ay klasiha pangngistaran i nagtindug-bi para si ako? O ma'in ngani', singnga may i pandidiskansuhan-ko? ");
INSERT INTO abx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma'in ba' i gahum-ko maghimo sito dimu'an? ");
INSERT INTO abx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Makudat gayod panakuluk-bi nan mga a'a kam! Akapariho kam pangasing-kasing si ga'i magpanutu'o si Diyos. Agpakangbungul-bungulan-bi i allingun-na si Diyos. Pariho kam si kapapu'-papu'an-bi nga pirmi agdiri' si pagdalum-na si Espirito Santo! ");
INSERT INTO abx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aniya' ba' paragsumat-na si Diyos nga ga'i agpasakitan-na si kapapu'-papu'an-bi tungod si mga pagtutu'u-na? Gana'! Agmatay-na dina mga iya i magpakatu'an andang si pagpada'itu-na si Matadong A'a. Ina'anto panahon ka'am i magtraydor ngan magpamatay si iya. ");
INSERT INTO abx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ka'am nga makakarawat si Bala'ud-na si Diyos nagpabawa pina'agi si mga anghel, ka'am mismo i ga'i magpanunod.” ");
INSERT INTO abx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ngan pakabati'-na sinan si magpaningkulo' si Kunsiho, agpanrigot mga iya si ura-ura kasina. ");
INSERT INTO abx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero tungod si pagdalum-na si Espirito Santo, akahangad si Esteban pan langit ngan akakulaw si maka'angayan danta'-na si Diyos pati' si Jesus nga agtutunggo si kawanan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Lingun-na si Esteban, “Ngulawa kam! Sakulawan-ko i pagbuka-na si langit ngan i Pinili' A'a agtutunggo si kawanan-na si Diyos.” ");
INSERT INTO abx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pakapakali-na mga iya sinan allingon agpanambunan-na mga iya i mga talinga-na ngan agpanurakaw makusog. Nagdarusong iya, ngan ");
INSERT INTO abx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","nagdagnas pagawas si syudad basi' akatalutugan. Agpanhugkas i mga tistigos, ngan agpama'anna'-na i mga badu'-na atubang si dadi'-dadi'on pa lalla nag'arunan Saulo. ");
INSERT INTO abx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Si pagparatalutug-na mga iya pagmatay si Esteban, ag'ampo' iya, “Paragdalom Jesus, karawaton i espiritu-ko.” ");
INSERT INTO abx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mangno alukmo' iya ngan anurakaw makusog, “Paragdalom, pasaylu'on mga iya si mga sala'-nay to.” Pakapinugad-na sinan, amatay dayon iya. ");
INSERT INTO abx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Huwang ari si Saulo, nga ag'alagad si pagmatay si Esteban. Mismo sinan allaw agtikang i pagpamasakit si manniniripon pag'ampo' ari si Jerusalem. Nagpanhar'as mga iya dimu'an si la'in a'a tungod hamok si mga pagtu'u-na. Pwira si mga apostol, agwarak i ditangnga' si bug'os mga prubinsya Judea pati' Samaria. ");
INSERT INTO abx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Aniya' diyusnon mga lalla maglabbong si Esteban ngan mabidun'on gayod mga iya. ");
INSERT INTO abx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lugod si Saulo may sigi dina kastigo si manniniripon pag'ampo' basi' pama'amban kunta' si mga pagtu'u-na. Pada'iray iya si pala'in-la'in ruma', ngan agpangguyud-na pagawas i mga lalla pati' i mga danda ngan agpamaprisu-na. ");
INSERT INTO abx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Agparapanwali-na si magburulag-bulag magpanutu'o i allingon bisan singnga mga iya pa'arop. ");
INSERT INTO abx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Padalugdog si Felipe si adda syudad ari si Samaria ngan agparapasamwak mahi'unong si Tinu'inan Mannanalwas. ");
INSERT INTO abx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Si pakapakali-na si magpantarambak si nagparapahalling-na si Felipe ngan pakakulaw-na si nagparahimu-na mga pangngilalahan si langitnon kasiguruhan, agtuninong gayod i dimu'an si nagparapahalling-na. ");
INSERT INTO abx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aniya' malabbat nagbawa-bawa si mga mara'at espirito magpanurakaw si papinda-na. Aniya' malabbat liwat irapa pati' kiyod magpanhalap. ");
INSERT INTO abx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sanglit bali gayod kalipay-na si mga a'a ari siray syudad. ");
INSERT INTO abx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ari siray syudad aniya' addangan nag'arunan Simon magparatambal huwang si pagparati'aw pati' pagparatigo si titakka. Bisan kuntray nan dimu'an si Diyos, maliyat na panahon maniguro pirmi iya nga ag'usa i dimu'an Samaritano ngan agparapahambog iya nga bantugan iya. ");
INSERT INTO abx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Agtuninong si iya i dimu'an mahaya a'a ngan da'inan may i mga urdinaryo hamok a'a. Agpanlaksi mga iya si pagpinugad, “Yayto a'a i nag'arunan Gamhanan kay awinan si iya i gahum-na si mga diyos.” ");
INSERT INTO abx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Agsunud-na iya si mga a'a tungod kay maliyat na iya agparabuhat urusahon pina'agi si pagtapud-na si mga mara'at espirito. ");
INSERT INTO abx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero sigi pasamwak si Felipe si mahalap sumat kon pinapa'i i a'a akasakop si mga nagpanhadi'an-na si Diyos pati' si gahum-na si arun-na si Jesu-Kristo. Ngan panutu'u-na mga iya si nagwali-nay to si Felipe, agpamabunyag i mga lalla hasta pa i mga danda. ");
INSERT INTO abx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mismo si Simon anutu'o ngan nagbunyagan. Agparaburubungyod iya si Felipe bisan singnga, ngan ag'usa gayod iya si mga sakulawan-na pangngilalahan si langitnon kasiguruhan pati' makagagahom binuhatan. ");
INSERT INTO abx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ngan pakapakali-na si mga apostol ari si Jerusalem nga ag'ako' i mga Samaritano si allingun-na si Diyos, aglihug-na mga iya si Pedro pati' si Juan pagpada'iray. ");
INSERT INTO abx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Si panakka-na mga iya, agpangadyi'an-na nga aka'ayop si magpanutu'o i Espirito Santo, ");
INSERT INTO abx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kay ga'i payto padugok si bisan say si mga iya. Agpabunyag hamok mga iya pag'ako' si arun-na si Ginu'o Jesus. ");
INSERT INTO abx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mangno agpadu'un-na kas Pedro pati' Juan i mga palat-na ari si magpanutu'o ngan pa'ayop dayon i Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ngan pakakulaw-na si Simon nga pa'ayop i Espirito Santo si pandu'un-na si mga apostol, amaru'do' iya kwarta si mga iya ngan aminugad, ");
INSERT INTO abx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Buwanin may liwat ako sito gahom basi' pa'ayop i Espirito Santo si bisan say pinadu'unan-ko si mga palat-ko.” ");
INSERT INTO abx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Anaruman dina si Pedro, “Atunaw pa kaw kunta' huwang si kwarta-moy nan, kay gasi-mo nga pwidi kabayaran kwarta i gahum-na si Diyos pagpa'ayop si Espirito Santo! ");
INSERT INTO abx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gana' labut-mo si trabaho kami' to para si Diyos, kay ma'in tama' i katuyu'an-mo si pangulawan-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Basulin to karat'an huwang si pagbag'o ngan mangadyi'a si Paragdalom. Tingali pasaylu-na kaw maski mara'at i inisipan-mo. ");
INSERT INTO abx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Akatu'anan ako nga bali kaw ka'awa'on ngan uripon kaw si sala'!” ");
INSERT INTO abx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mangno aminugad si Simon, “Ampu'i-bi ako si Paragdalom basi' gana' si nagpinugad-bi nan mahinabo' si ako.” ");
INSERT INTO abx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pakahuman-na kas Pedro pati' Juan pagsumat si kamatu'uran ngan pagpasamwak si allingun-na si Paragdalom, agbalik mga iya pan Jerusalem. Si nagpara'agihan-na pagbalik agparawali-na mga iya i mahalap sumat si malabbat pa mga kaburubungtuhan si Samaria. ");
INSERT INTO abx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Siray uras aniya' anghel nagpabawa-na si Paragdalom maminugad si Felipe, “Pada'iraya si timugan, ari si tinampo nga ag'agi si disyirto tikang si Jerusalem padalugdog pan syudad Gaza.” ");
INSERT INTO abx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Sanglit palangngan dayon iya, ngan si pagparabaktas-na, sadahulu'an-na iya si addangan taga Etiopia. Mahaya katungdanan-na sito kay iya i tinapuran si dimu'an kayamanan-na si Candace nga Rayna-na si mga taga Etiopia. Agpakapun-na na iya kay i mga kapon hamok i makasirbi si mga rayna siray mga panahon. Manari'i iya si Jerusalem pag'ampo'. ");
INSERT INTO abx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Si pagbalik-na, agsakay iya si karuwahi-na ngan sigi basa makusog si Libru-na si Paragsumat Isaias. ");
INSERT INTO abx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Agsumatan-na may si Felipe si Espirito Santo, “Lanaton ray karuwahi ngan tapitin gayod.” ");
INSERT INTO abx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mangno aglalahi iya patapit si karuwahi ngan sabati'an-na i pagparabasa-na si lalla. Sanglit amatilaw iya, “Sasabutan-mo ba' i karuyag sidngun-na si nagparabasa-moy nan?” ");
INSERT INTO abx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Anaruman may to, “Pa'i-ko may sito pakasabot kon gana' mag'isplikar si ako?” Sanglit ag'agda-na iya si taga Etiopia pagsang'at ngan pagtingkulo' huwang si iya. ");
INSERT INTO abx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yayto i parti-na si Kasuratan nagparabasa-na: Aniya' addangan nagguyod si kamatayon pariho si burunu'on karniro, ngan ga'i iya agsibu'-sibo' atubang si mag'akusar pariho si karniro nga ga'i agribuk-ribok atubang si magburog. ");
INSERT INTO abx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Si dimu'an pagpakamalo' si iya, ga'i iya nagbuwanan pantay paghusgar. Gana' makasumat mahi'unong si mga ka'ampu-ampuhan-na kay nagbawi' na i kinabuhi'-na ato si kalibutan. ");
INSERT INTO abx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Amatilaw i taga Etiopia, “Alayon, sumatin ako, say nagtukuy-na si paragsumat, i kalugaringun-na o i la'in?” ");
INSERT INTO abx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mangno agtikang si Felipe pagpaklaro sinan mismo parti si Kasuratan ngan agpadayon pagsumat si mahalap sumat hi'unong si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Si pagparabiyahi-na mga iya, aniya' sa'agihan-na mga iya sapa', ngan aminugad i taga Etiopia, “Kulawin! Atiya' buwahi'. Aniya' ba' maka'ulang kon agpabunyag ako?” ");
INSERT INTO abx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Agpahuway-na i karuwahi ngan paladdop mga iya basi' sabunyagan-na iya si Felipe. ");
INSERT INTO abx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ngan pahaw'as-na mga iya si buwahi', hintak ga'i na kinakulawan si Felipe kay agpara'-na iya si Espiritu-na si Paragdalom. Agpadayon i taga Etiopia si biyahi-na ngan bali kalipayan. ");
INSERT INTO abx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero mismo sinan uras, agpaluwa'-na si Felipe si Espirito ari si syudad Azoto, ngan agpadayon si langngan-na pagpasamwak si mahalap sumat si balang bungto nag'agihan-na hasta nga anakka iya si syudad Cesarea. ");
INSERT INTO abx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Siray ka'urason, sigi pa pakatalaw si Saulo nga paratukan kamatayon i mga inadalan-na si Ginu'o. Aruyag gayod iya nga akapada'iray si syudad Damasco pag'usisa kon aniya' sa'anda'an-na mga a'a ari nga huwang si baha'o pa'agi pagtapit si Diyos nagturu'-na si Jesus. Sanglit pada'iray iya dahulo si gilalabawi paraghalad pagpalako mga surat nga papakulawon si mga sinaguga ari basi' sadakup-nay to mga a'a, lalla o danda ngan sapamawa-nay to bilang priso pan Jerusalem. ");
INSERT INTO abx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Si pagra'un-da'un-na ari si Damasco, aniya' danta' man langit nga hintak agsiga palibot si iya. ");
INSERT INTO abx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Alaho' iya si nagkabayuhan-na ngan aniya' sapamati'an-na busis nga makibagaw si iya, “Saulo, Saulo, ay kay agpa'antus-mo ako?” ");
INSERT INTO abx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amatilaw si Saulo, “Say kaw, Sinyor?” Anaruman may si iya, “Ako si Jesus nga mag'antos tungod si nagparabuhat-mo si mga magpanutu'o si ako. ");
INSERT INTO abx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Banguna ngan pasallura si kuta'-na si syudad. Surumatan kaw ari si kinahanglan buhat-mo.” ");
INSERT INTO abx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sigi hamok tutunggo i mga kahuruwangan-na lalla si Saulo pero gana' magpakasibo'. Akapakali mga iya busis pero gana' mga sakulawan-na bisan ay. ");
INSERT INTO abx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pabangon si Saulo pero panmuklat-na si mga mata-na, ga'i na iya kakulaw, sanglit nagtuttutan na hamok iya pasallod si Damasco. ");
INSERT INTO abx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Abuta iya tallo allaw ngan gana' kakan-kakanay ni panginom bisan ay. ");
INSERT INTO abx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ari si Damasco, aniya' inadalan nag'arunan Ananias nga ag'agi si adda maka'urusa kurulawan. Ari sakulawan-na pati' sapamati'an-na i Paragdalom nga agban'u-na iya, “Ananias.” Anaruman iya, “Paragdalom, atiya' ako.” ");
INSERT INTO abx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Agtugunan-na iya si Paragdalom, “Pada'iraya si ruma'-na si Judas, ari si kalsada nag'arunan Tadong ngan pinugaron nga makibagaw kaw si lalla nag'arunan Saulo nga taga sunsari'i si syudad Tarsos. Agparapangadyi' iya sito mga ka'urason ");
INSERT INTO abx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ngan agpakulaw-ko liwat iya ina'anto si la'in maka'urusa kurulawan nga agkabagat kam duwangan ngan agdu'unan-mo iya si mga palat-mo basi' akakulaw iya gihapon.” ");
INSERT INTO abx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Agsarumanan-na may si Ananias i kabagaw-na, “Paragdalom, malabbat sapakalihan-ko mga sumat mahi'unong sito lalla pati' si dimu'an mga pagpirwisyu-na si mga a'a-mo nga nagtagama paghuwang si ka'aw ari si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pada'ito iya nga aniya' kuno' gahum-na tikang si mga puno' paraghalad pagdakop si dimu'an magsangpit si ka'aw.” ");
INSERT INTO abx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero aminugad dina i Paragdalom, “Pada'iraya! Yayto lalla i nagpili'-ko manirbi si ako basi' sapakilala-na ako si mga ma'in Hebro pati' si mga hadi'-na hasta si mga a'a-na si Israel. ");
INSERT INTO abx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ako mismo mamakulaw si iya kon singnga tubtob i arantusun-na para si ako.” ");
INSERT INTO abx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pakapara'-na si maka'urusa kurulawan, pada'iray dayon si Ananias si nagturo' ruma' ngan diritso iya pasallod. Si pamadu'un-na si mga palat-na ari si Saulo, aminugad iya, “Bugtu'-ko Saulo, si Jesus nga pakulaw si ka'aw ari si tinampo si pagra'un-da'un-mo ato, iya i Paragdalom. Iya i maglihog si ako pagpapada'ito basi' akakulaw kaw gihapon ngan basi' pa'ayop si ka'aw i Espirito Santo.” ");
INSERT INTO abx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aniya' dayon mataktak day hingbis tikang si mga mata-na si Saulo ngan akakulaw dayon iya. Anunggo iya ngan nagbunyagan. ");
INSERT INTO abx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ngan pakakakan-na na, anagha' dayon i puhu'-na. Ag'istar dahulo si Saulo mga pira allaw ari si Damasco huwang si mga inadalan. ");
INSERT INTO abx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Agtikang dayon iya pagwali ari si mga sinaguga nga si Jesus, iya i Dadi'-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","I dimu'an makapakali si iya agpangusa ngan agsipuruparatilaway, “Ma'in ba' nan iya i magparapirwisyo ari si Jerusalem si mga magparapanangpit si Jesus? Sigurado iyay nan, ngan pada'ito iya pagpandakop namay sito ngan sabawa-na bilang priso pada'iray si mga puno' paraghalad.” ");
INSERT INTO abx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero sigi dina tatamba i kagamhanan-na si Saulo tungod si pagparawali-na ngan pina'agi si pagparapamatu'ud-na nga si Jesus i Tinu'inan Mannanalwas, ga'i agpakasibo' i ditangnga' mga Hebro magpangistar ari si Damasco. ");
INSERT INTO abx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kahuman si pira allaw, aniya' mga punu'-na si mga Hebro magkurunsabo pagmatay si iya, ");
INSERT INTO abx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","sanglit allaw sangom i pagparabantay si iya ari si mga pangngagihan si kuta'-na si syudad. Kundi' sakatu'anan-na si Saulo i planu-na mga iya ");
INSERT INTO abx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","sanglit kasanguman, ag'ala'-na iya si mga mannurunud-na ngan nagtunton iya si kanastro tikang si adda bintana' si kuta'. ");
INSERT INTO abx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ngan panakka-na si Saulo si Jerusalem makihuwang iya si mga inadalan ari, pero agkataralaw mga iya dimu'an kay ga'i mga iya agtutu'o nga ungod iya inadalan. ");
INSERT INTO abx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero aniya' addangan si mga iya nag'arunan Bernabe nga iya i magbawa si Saulo pagbagat si mga apostol. Agsumat iya mahi'unong si pagpakulaw-na si Ginu'o si Saulo si pagbiyahi-na pati' i mahi'unong si pagbagaw-na si iya. Agpasayod iya nga bali kapusukado si Saulo pagpasamwak si mahalap sumat ari si Damasco kay ag'aku'-na i arun-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sanglit gana' na maka'ulang si pangiwa-kiwa-na si Saulo kay aghuruwang mga iya ag'istar si mga apostol ari si Jerusalem ngan pusukado paggamit si arun-na si Paragdalom pagwali. ");
INSERT INTO abx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sigi iya pakibagaw si mga Hebro nga Grikuhanon i pinahallingan-na ngan sigi iya pakipasusuhay tubtob nga nagmamatay iya. ");
INSERT INTO abx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ngan pakakatu'an-na sinan si mga kabugtu'an si pagtu'o, agbaya'-na mga iya si Saulo padalugdog pan syudad Cesarea ngan agpataliwan-nay to mga iya pan Tarsos. ");
INSERT INTO abx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tikang siray, agpaka'angkon dayon si maliyat kamurayawan i manniniripon pag'ampo' si bug'os mga prubinsya Judea, Galilea pati' Samaria. Anarig i mga pagtu'u-na ngan aglalabbat mga iya tungod si pagpara'aghat-na si Espirito Santo. Agpanahod gayod mga iya si Paragdalom hasta si mga kinabuhi'-na. ");
INSERT INTO abx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Si pagparalibut-libut-na si Pedro si pala'in-la'in lugar, akapada'iray iya si bungto Lida pagbisita si mga a'a ari nga nagtagama paghuwang si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aniya' sabagatan-na irapa nag'arunan Eneas nga agparalibbak sallod si walo' na ta'on. ");
INSERT INTO abx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Agpinugad-na iya si Pedro, “Eneas, agpahalap-na kaw si Jesu-Kristo mismo ina'anto. Banguna ngan lukuton naglibbakan-moy nan.” Pabangon dayon si Eneas. ");
INSERT INTO abx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Akakulaw si iya i dimu'an magpangistar si Lida hasta pa i bug'os kapatagan si Saron ngan agpanutu'o mga iya si Ginu'o. ");
INSERT INTO abx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ari liwat si syudad Jopa, aniya' inadalan danda nag'arunan Tabita. Dorcas i pag'aron si iya si Grikuhanon, nga i kahulugan-na adda usa. Pirmi iya agparahimo si mga mahalap binuhatan ngan pirmi iya agparabulig si mga anggana'. ");
INSERT INTO abx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mismo si kari'i-na si Pedro si Lida, binurungan si Tabita ngan amatay. Nagtrapuhan i bangkay-na ngan naghay'ad si kwarto ari si dyata'. ");
INSERT INTO abx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Agtapit hamok i Lida pati' i Jopa, sanglit ngan pakakatu'an-na si mga inadalan nga ari si Pedro si Lida, aglihog mga iya duwangan lalla pag'ala'. Agsagda-nay to mga iya, “Alayon dagmita, amaya'a dayon si kami'!” ");
INSERT INTO abx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Amaya' dayon si Pedro ngan diritso amanahik pan dyata' si panakka-na ari. Agtiriripon si iya i dimu'an mga balo. Agparapamanangis to ngan agparapamakulaw-na si iya i mga pammakurumbot pati' i ditangnga' panapton nagparahimu-na si Dorcas ngan allom payto. ");
INSERT INTO abx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Agpamagawas-na mga iya dimu'an si Pedro. Mangno anluhod iya ngan mangadyi'. Katapos angatubang iya si minatay ngan aminugad, “Tabita, kallata!” Anmuklat dayon i minatay. Pakakulaw-na nga ari si Pedro, aningkulo' to. ");
INSERT INTO abx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ag'antanan-na iya si tamburo' ngan agbuligan-na pagtunggo. Mangno, agban'u-na si Pedro i mga magpanutu'o labihan na i mga balo ngan agpakulaw-na si mga iya nga a'allom gihapon si Dorcas. ");
INSERT INTO abx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Abantog nan hinabo' si bug'os Jopa ngan malabbat i manutu'o si Ginu'o. ");
INSERT INTO abx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ag'istar dahulo si Pedro ari si Jopa si ruma'-na si paragbulad anit nag'arunan Simon. ");
INSERT INTO abx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ari si syudad Cesarea aniya' sinturyon nag'arunan Cornelio nga sakop si adda batalyon taga Italia. ");
INSERT INTO abx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rilihuso iya ngan matinu'uhon si rilihiyun-na si mga Hebro hasta i pamilya-na. Makibuwan-buwanon iya si mga magpanginahanglan ngan pirmi agparapangadyi'. ");
INSERT INTO abx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Adda allaw sinan ngan mga alas tris si kuhap akakulaw iya maka'urusa kurulawan. Klarado gayod i pagkakulaw-na si anghel pinabawa-na si Diyos, nga padugok si iya ngan aminugad, “Cornelio!” ");
INSERT INTO abx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Agbuslung-na pahalap si Cornelio i anghel bisan kon bali i katalaw-na ngan amatilaw, “Sinyor, ay i tuyu'-mo si ako?” Anaruman i anghel, “I pagparapangadyi'-mo pati' i pagkamabinuwan-buwanun-mo si mga anggana' akapariho si halad nga anakka ari si langit sanglit tungod sinan pirmi kaw sa'intuman-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Anlihuga ina'anto pan syudad Jopa pag'ala' si addangan lalla nag'arunan Simon nga kilala liwat si aron Pedro. ");
INSERT INTO abx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Makisangpot iya si ruma'-na si Simon paragbulad anit nga ag'istar matapit si kalawot.” ");
INSERT INTO abx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Si pakapara'-na si anghel magbagaw si Cornelio, aman'o iya duwangan si mga rilihugun-na ngan addangan si mga tinapuran-na sundalo nga rilihuso. ");
INSERT INTO abx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ag'isturya-na si mga iya i dimu'an nagsumat-na si anghel, ngan aglihug-nay to mga iya pan Jopa. ");
INSERT INTO abx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ka'asumuhan amudto agra'unda'on si syudad i nagpanlihog. Sinan uras, agpanahik may si Pedro si hagdan pada'iray si patag binungbungan pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Alinganto iya pero ga'i akapamangan tungod kay nagpara'andam pa hamok. Sinan uras aniya' sabuslungan-na nga pariho iya si mag'upi bisan kon kallat pa. ");
INSERT INTO abx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sakulawan-na nga angabri i langit ngan aniya' inanna' day tampi' nga bali lambo, nagtunton nga day nag'ingkutan si ampat kantu-na. ");
INSERT INTO abx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Panno' to si dimu'an klasi si hayop, mananap, pati' manuk-manok. ");
INSERT INTO abx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mangno aniya' sapakalihan-na busis maminugad, “Pedro, anungguha, anmataya sinan ngan kakanon.” ");
INSERT INTO abx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Anaruman si Pedro, “Ga'i ahimo, Paragdalum-ko! Ga'i pa ako akakakan bisan ay karniha nga marigsok o ma'in tugot pagkakan.” ");
INSERT INTO abx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sapakalihan-na gihapon i busis, “Dakaw agpinugad nga marigsok i naghimu-na na si Diyos limpyado.” ");
INSERT INTO abx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sin talloy to ahinabo' mangno nag'isa dayon i day tampi' pan langit. ");
INSERT INTO abx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Dungan si pagpara'usa-na si Pedro kon ay i tuyu'-na si Diyos pagturo' pina'agi sito maka'urusa kurulawan, satuttutan-na si mga naglihug-na si Cornelio i ruma'-na si Simon. Agparapanunggo mga iya si yungud-na si pwirtahan-na si padir. ");
INSERT INTO abx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Aman'o mga iya pagpatilaw kon ari ag'istar si Simon nga kilala liwat si aron Pedro. ");
INSERT INTO abx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Si pagparapinsar-na pa si Pedro mahi'unong si maka'urusa kurulawan, agpakatu'an-na iya si Espirito, “Simon, aniya' tallungan lalla magpara'anda' si ka'aw. ");
INSERT INTO abx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sanglit paduwa'iha ngan dugukon dayon. Dakaw agruha-duha pagbaya' si mga iya kay ako gayod sinan i maglihog.” ");
INSERT INTO abx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Paduwa'i si Pedro ngan agpinugad-na i mga lalla, “Ako i nagpara'anda'-bi. Ay kay pada'ito kam?” ");
INSERT INTO abx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Anaruman i mga lalla, “Aglihug-na kami' si Cornelio nga sinturyon. Matadong iya a'a, matinu'uhon si rilihiyun-bi mga Hebro, ngan nagtahuran si dimu'an kaparihu-bi ari si Cesarea. Aniya' magbagaw si iya sagrado anghel nga pagpapada'iray kunta' si ka'aw ari si mga ruma'-na basi' akapakali si mga parahallingun-mo.” ");
INSERT INTO abx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mangno agpadayun-na si Pedro i mga lalla si ruma' bilang bisita-na. Ka'asumuhan amaya' si Pedro si mga iya, ngan aniya' mga kabugtu'an si pagtu'o tikang si Jopa magpamaya'. ");
INSERT INTO abx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Si manunod allaw anakka kas Pedro ari si Cesarea. Agparapanimulat-na mga iya si Cornelio ngan agparapangagda-na i mga kabugtu'an-na pati' i mga matapit gayod kakurumpaniyahan-na. ");
INSERT INTO abx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Si pag'isasallud-na si Pedro si ruma', agtupu'-na iya si Cornelio ngan pa'akkom si kitiran-na pagbuwan katalahuran. ");
INSERT INTO abx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero agpatunggu-na iya si Pedro si pagpinugad, “Anungguha kay a'a may hamok ako parihu-mo.” ");
INSERT INTO abx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Si pagparabagaw-na mga iya, pasallod si Pedro si ruma' ngan sakulawan-na i malabbat a'a magtiripon. ");
INSERT INTO abx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aminugad to si mga iya, “Sayod kam nga kuntra si bala'od kami' mga Hebro i pagpaki'adda o bisan pagbisita si mga ma'in Hebro. Pero agpakulaw-na si ako si Diyos nga gana' nagpinugad-ko marigsok bisan say aha'a. ");
INSERT INTO abx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Sanglit si pag'ala' si ako, ga'i ako agbaribad; amaya' dayon ako. Ina'anto tilaw-ta may kam, ay kay agpa'ala'-bi ako?” ");
INSERT INTO abx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Anaruman si Cornelio, “Ampat allaw na i pa'agi, agparapangadyi' ako si ruma'-ko mga alas tris si kuhap, pariho gihapon sito ka'urason. Aniya' lalla manhintak pakulaw atubang si ako nga masuri'aw i bisti-na ");
INSERT INTO abx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ngan aminugad, ‘Cornelio, agpakalihan-na si Diyos i mga pangadyi'-mo ngan ag'intum-na i pagkamabinuwan-buwanun-mo si mga anggana'. ");
INSERT INTO abx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pa'ala'on si Simon nga kilala liwat si aron Pedro ari si Jopa. Bisita iya ari si ruma'-na si Simon paragbulad anit nga ag'istar matapit si kalawot.’ ");
INSERT INTO abx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sanglit agpalihugan-ta kaw dayon, ngan salamat si pagpada'itu-mo. Ina'anto atiya' kami' intiro atubang si Diyos pagpamati' si dimu'an nga nagtugun-na si ka'aw si Paragdalom pagsumat si kami'.” ");
INSERT INTO abx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mangno agtikang pagpahalling si Pedro, “Ina'anto pa hamok panabut-ko nga ungod bali' gana' pina'urug-na si Diyos ");
INSERT INTO abx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kundi' ag'aku'-na i dimu'an a'a tikang si pala'in-la'in nasyon magpa'unra si iya ngan magparabuhat si katadungan. ");
INSERT INTO abx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Akatu'anan kam si sumat nagpabawa-na si Diyos si mga a'a-na si Israel nga iya i pagpasamwak si mahalap sumat nga aniya' kamurayawan-na si a'a pina'agi si Jesu-Kristo nga Paragdalom si dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Akatu'anan kam si mahinabo' si bug'os prubinsya Judea nga agtikang ari si prubinsya Galilea pakahuman si pagparapasamwak-na si Juan mahi'unong si pagbunyag. ");
INSERT INTO abx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Sapakalihan-bi kon agpapa'i-na si Diyos pagtu'in si Jesus nga taga Nasaret pina'agi si pagpa'ayup-na si Espirito Santo pati' pagbuwan gahom. Tungod kay aghuwang si iya i Diyos, agparalibot iya nga puro kahalapan i nagbuhat-na ngan agparapapindahan-na si mara'at espirito i dimu'an nagdaluman-na kas Satanas. ");
INSERT INTO abx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Tistigos kami' si dimu'an nagbuhat-na ari si Jerusalem hasta pa si bug'os nasyun-na si mga Hebro. Si pagmatay-na sito mga iya, agpabiyat-nay to mga iya si day sanga-na si kayo ");
INSERT INTO abx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","pero si katallo allaw, agbanhaw-na iya si Diyos ngan agpakulaw iya. ");
INSERT INTO abx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ga'i iya kinakulawan si dimu'an mga a'a, pero agpakulaw iya si kami' nga mga pinili'-na andang tistigos. Kami' i mga tistigos magtarangka' si pagkakan ngan pag'inom huwang si iya kahuman si pakabanhaw-na. ");
INSERT INTO abx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Agtugunan-na kami' pagpasamwak si mga a'a ngan pagtistigos nga iya i huwis nagtu'inan-na si Diyos paghusgar si mga allom pati' si mga minatay. ");
INSERT INTO abx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Agtistigos i dimu'an paragsumat-na si Diyos siray mahi'unong si iya nga bisan say i magtutu'o si iya, apasaylo i mga sala'-na pina'agi si gahum-na si arun-na.” ");
INSERT INTO abx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Si pagparapahalling-na si Pedro sito mga allingon, pa'ayop i Espirito Santo si dimu'an magpamakali. ");
INSERT INTO abx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Agpangusa i mga tinuri' magpanutu'o nga iya i mga Hebro magpamaya' si Pedro kay nagpumwan liwat bisan si mga ma'in Hebro i rigalo nga iya i Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kinatu'anan to kay la'in na dina mga linggwahi i kinapakalihan nga nagparapahalling-na sito mga a'a ngan agparapandayaw mga iya si Diyos. Mangno aminugad si Pedro, ");
INSERT INTO abx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Angay nayto kunta' mga a'a nga agpakabunyagan liwat si klasi nga naggamitan buwahi'. Aniya' pa ba' si ka'am mandiri' sito? Sigurado gana' kay ag'ayop na si mga iya i Espirito Santo pariho si pag'ayup-na si kita kam.” ");
INSERT INTO abx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sanglit agmando' iya pagbunyag si mga iya nga magpan'ako' si arun-na si Jesu-Kristo. Mangno aghawiran-na mga iya si Pedro bisan pira hamok allaw. ");
INSERT INTO abx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Akabati' i mga apostol pati' i mga kabugtu'an si pagtu'o si bug'os prubinsya Judea nga aniya' liwat magpanutu'o si mga ma'in Hebro si allingun-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sanglit si pakapada'iray-na si Pedro si Jerusalem, agsu'it-na iya si mga tinuri' magpanutu'o ");
INSERT INTO abx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","si pagpinugad, “Pasallod kaw si ruma'-na si mga ma'in tinuri' ngan agkakan huwang si mga iya.” ");
INSERT INTO abx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Agtikang si Pedro pag'isplikar pasunud-sunod si tukib mahinabo', ");
INSERT INTO abx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Agparapangadyi' ako ari si syudad Jopa ngan aniya' sabuslungan-ko nga pariho ako si mag'upi. Akakulaw ako maka'urusa kurulawan ngan aniya' inanna' day tampi' nga bali lambo nagtunton man langit. Day nag'ingkutan to si ampat kantu-na ngan aghahawod si yungud-ko. ");
INSERT INTO abx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Agbuslung-koy to ngan sakulawan-ko ari i malabbat klasi si hayop, huwang-na i mga ma'ilaw, i mga mananap, pati' mga manuk-manok. ");
INSERT INTO abx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mangno akabati' ako busis magpinugad, ‘Pedro, anungguha, anmataya sinan ngan kakanon.’ ");
INSERT INTO abx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Anaruman may ako, ‘Ga'i ahimo, Paragdalum-ko! Ga'i pa ako akakakan marigsok karni o i ma'in tugot.’ ");
INSERT INTO abx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Kinapakalihan gihapon i busis tikang si langit, ‘Dakaw agpinugad nga marigsok i naghimu-na na si Diyos limpyado.’ ");
INSERT INTO abx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sin talloy to ahinabo' mangno nag'isa gihapon i day tampi' pan langit. ");
INSERT INTO abx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Mismo sinan aniya' tallungan lalla tikang si syudad Cesarea magparapanunggo yungod si nag'istaran kami' nga naglihog pag'ala' si ako. ");
INSERT INTO abx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Agsumatan-na ako si Espirito nga ga'i ako agruha-duha pagbaya' si mga iya. Agpamaya' liwat si ako i annumangan mga ka'arabay-ko kabugtu'an si pagtu'o ngan pamasallod kami' si ruma'-na si magpa'ala' si kami'. ");
INSERT INTO abx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Agsumatan-na kami' nga akakulaw kuno' iya anghel nga paluwa' si ruma'-na ngan aminugad, ‘Anlihuga pan Jopa, pag'ala' si Simon nga kilala liwat si aron Pedro. ");
INSERT INTO abx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iya i manumat si ka'aw kon pinapa'i kam agkasaralbar hasta i dimu'an ginsakupan-mo.’” ");
INSERT INTO abx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Agpadayon si Pedro, “Si pagtikang-ko pa hamok pagpahalling, pa'ayop i Espirito Santo si mga iya pariho si pag'ayup-na si kita kam si tinikangan. ");
INSERT INTO abx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mangno sa'intuman-ko i nagpinugad-na si Ginu'o: ‘Parti si buwahi' i pagbunyag-na si ka'am si Juan, pero burunyagan kam pagpa'ayop si Espirito Santo.’ ");
INSERT INTO abx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sanglit kon agbuwanan-na mga iya si Diyos pariho rigalo si nagpumwan-na si kita kam si panutu'u-ta kam si Ginu'o Jesu-Kristo, say ba' ako nga pwidi akadiri' si tuyu'-na si Diyos?” ");
INSERT INTO abx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Si pakabati'-na si mga magpanu'it si iya, ga'i na dayon mga iya agpakasibo', lugod agpandayaw si Diyos si pagpinugad, “Kon sugad agbuwan liwat panahon i Diyos si mga ma'in Hebro pagbasol huwang si pagbag'o basi' aka'angkon si ungod kinabuhi'.” ");
INSERT INTO abx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aniya' dati nagsurat ato sito libro nga malabbat i magburulag-bulag magpanutu'o ari si Jerusalem kahuman hamok si pagmatay si Esteban. Nagpamasakitan to si la'in a'a tungod si pagtutu'u-na mga iya si Jesus sanglit agpamiyahi mga iya pada'iray si prubinsya Fenicia, si isla Cipre pati' si syudad Antioquia. Ka'urugan si mga iya agparapamasamwak si allingun-na si Diyos si mga Hebro hamok. ");
INSERT INTO abx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero aniya' si mga iya tikang si Cipre pati' si syudad Cirene nga agtikang pagpahalling liwat si mga Griko si panakka-na mga iya si Antioquia. Agparapanumat to si mahalap sumat nga si Jesus, iya i Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Agbuligan-na mga iya pahalap si Paragdalom. Malabbat i mga a'a magpanutu'o ngan pahuwang si Ginu'o. ");
INSERT INTO abx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Akabantugan sito hinabo' i manniniripon pag'ampo' ari si Jerusalem ngan aglihug-na mga iya si Bernabe pan Antioquia. ");
INSERT INTO abx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Si panakka-na ari, alipay gayod iya si pakakulaw-na si ibidinsya si pagpalangga'-na si Diyos si mga a'a. Ag'aghat-na mga iya dimu'an pag'unong kinasing-kasing si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Bernabe daluman a'a ngan mahaya i kapulsanan-na pagsirbi si Diyos. Agsunod gayod iya si pagdalum-na si Espirito Santo ngan matgas i pagtutu'u-na. Siray uras malabbat magka'araghat si pagtutu'o si Ginu'o. ");
INSERT INTO abx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mangno pada'iray si Bernabe si syudad Tarsos pag'anda' si Saulo. ");
INSERT INTO abx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Si paka'anda'-na, agbwiltahan-nay to pan Antioquia. Sanglit sallod si adda ta'on maki'adda kas Bernabe pati' Saulo si manniniripon pag'ampo' ari ngan bali labbat i saturu'an-na mga iya. I primiro pag'aron Kristiyano si mga inadalan ahimo ari si Antioquia. ");
INSERT INTO abx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sinan panahon aniya' magpamadalugdog pan Antioquia mga paragsumat tikang si Jerusalem. ");
INSERT INTO abx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anunggo i addangan si mga iya nag'arunan Agabos ngan makigpasumat-na iya si Espirito Santo nga aniya' titakka gutom si dimu'an lugar nga sakop si nasyon Roma. Ahinabo' nan ngan pag'emperadur-na si Claudio. ");
INSERT INTO abx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nagka'arabuyunan si mga inadalan nga tubtob si sakaya-na si balang addangan, angamot kwarta si mga kabugtu'an si pagtu'o mag'istar si Judea. ");
INSERT INTO abx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Agbuhat-nay nan mga iya ngan si Bernabe pati' si Saulo i nagpabawa-na si mga amut-na pada'iray si mga mahanak si pagtu'o ari. ");
INSERT INTO abx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sinan mga panahon, aniya' nagpamadakup-na si Hadi' Herodes nga sakop si manniniripon pag'ampo'. I tuyu'-na i pagpasakit si mga iya tungod si mga pagtu'u-na. ");
INSERT INTO abx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Addangan si mga iya si Santiago nga siyaka-na si Juan. Nagpapugutan iya pina'agi si ispada. ");
INSERT INTO abx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ngan pakakulaw-na nga akalipay nan si punu'-na si mga Hebro, agpadakup-na pa liwat si Pedro. Ahinabo' nan ngan Pyista si Tinapay nga Gana' Pammatubu'-na. ");
INSERT INTO abx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kahuman-na pagpadakop si Pedro agpaprisu-nay to. Nagpabantayan iya si ampat grupo mga kasundaluhan nga agrilyibo sapatang-patangan. Agplano si Herodes pagbista si iya atubang si kalabbatan kahuman si Pyista si Paglabay. ");
INSERT INTO abx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sanglit sigi parangadyi'ay si Diyos i manniniripon pag'ampo' kay awiray pa si prisuhan si Pedro. ");
INSERT INTO abx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Si sangom myintras agbista-na iya si Herodes ka'asumuhan, agpaturi si Pedro si tangnga'-na si duwangan sundalo. Paluyu-luyo i pusas-na ngan nagpa'ingkot to si padurudambila' bantay. Aniya' liwat mga bantay magtutunggo si gawas-na si mga pwirtahan. ");
INSERT INTO abx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hintak aniya' paluwa' anghel nagpabawa-na si Paragdalom ngan nagdanta'an i sallud-na si prisuhan. Agpalpak-na si Pedro si kagiliran pagpukaw. Agpinugad-nay to, “Dagmita, anungguha!” Ahulso' dayon i mga pusas-na si Pedro. ");
INSERT INTO abx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mangno agpinugad-na iya si anghel, “Tuhayon badu'-moy nan basi' ga'i kaw asugyapot ngan pasul'uton sandalyas-moy nan.” Agbuhat-nay nan si Pedro. Agsumatan-na liwat iya si anghel, “Pasul'uton pammakurumbut-moy nan ngan amaya'a si ako.” ");
INSERT INTO abx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Amaya' si Pedro pagawas si prisuhan, pero day gana' si isip-na nga i nagparabuhat-na si anghel ungod gayod ahinabo'. Si pagkagasi-na nga akakulaw iya maka'urusa kurulawan. ");
INSERT INTO abx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ag'agihan-na mga iya i dahulo pati' i kaduwangan bantay ngan anakka si pwirtahan ransang si kuta' pan syudad. Aglugaring to pag'abri ngan pa'agi mga iya ari. Aghuwang mga iya aglangngan si kalsada tubtob anakka si pagsangahan-na mangno hintak pa'amban si iya i anghel. ");
INSERT INTO abx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mangno aka'alimagmag si Pedro ngan aminugad, “Ina'anto akatu'anan na ako ngan gana' na duda-ko nga aglihug-na si Paragdalom i anghel-na ngan agsalbar-na ako tikang si pagdalum-na si Herodes. Agsalbar-na liwat ako tikang si dimu'an karat'an nagparapatakka-na si mga Hebro.” ");
INSERT INTO abx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Si pakasantup-na si kamutangan-na, pada'iray iya si ruma'-na si Maria, i nana-na si Juan nga kilala liwat si aron Markos nga kon singnga agtiripon i mga a'a pagpangadyi'. ");
INSERT INTO abx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Anuktok si Pedro si pwirtahan-na si kuta'. Padugok ngan angusisa si pwirtahan i kabulig danda nag'arunan Roda. ");
INSERT INTO abx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Si pakakilala-na si busis-na si Pedro, alahi iya pabwilta tungod si mahaya kalipay-na bisan ga'i pa sa'abrihan-na i pwirtahan. Agsumat iya, “Awiray si pwirtahan si Pedro!” ");
INSERT INTO abx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nagsarumanan iya, “Ga'i kaw akatu'anan si nagparayawit-moy nan.” Si pagpara'insistir-na nga ungod to gayod, agpaminugad mga iya, “Tingali i anghel-nay nan.” ");
INSERT INTO abx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero sigi hamok tuktok si Pedro, ngan si pangabri-na mga iya si pwirtahan, agpangusa gayod mga iya si pakakulaw si iya. ");
INSERT INTO abx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Agsinyas si mga iya si Pedro pagpamingaw ngan agsumat-na kon agpapa'i-na iya agpagawas si prisuhan si Paragdalom. Aminugad iya, “Sumati-bi si Santiago pati' i ditangnga' mga kabugtu'an si pagtu'o mahi'unong sito.” Mangno pa'amban iya ngan pada'iray si la'in lugar. ");
INSERT INTO abx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kanalungan bali kasamukan si mga sundalo. Agsipuruparatilaway mga iya, “Ay daw i mahinabo' si Pedro?” ");
INSERT INTO abx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pakahuman-na si Herodes pagpa'anda' pahalap si iya, ag'imbistigaran-na pahalap i mga bantay tungod kay ga'i namay gayod iya kina'anda'an. Mangno agmando' to pagpamatay si mga bantay. Kahuman sinan, pa'amban si Herodes si prubinsya Judea ngan ag'istar iya makali' ari si syudad Cesarea. ");
INSERT INTO abx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Maliyat na panahon agparapakidiskusyon iya si magpangistar si mga syudad Tiro pati' Sidon sanglit ag'aradda i mga taga sunsari'i pagpabawa mga pinili' a'a pagpakibagaw si iya. Agpasiguro dahulo mga iya si bulig-na si Blastus nga addangan si mga tinapuran-na si hadi'. Mangno pina'agi si iya, agpakatapit mga iya nga agsiharalapay kay agla'om mga iya si nasyun-na si hadi' para si mga pagkakan-na. ");
INSERT INTO abx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Si nagtala'an-na allaw si Herodes, agsul'ot iya si hadi'anon badu'-na ngan aningkulo' iya si trunu-na. Agdiskurso iya atubang si mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sigi mga iya panurakaw, “Iyay nan i busis-na si adda diyos, ma'in si a'a.” ");
INSERT INTO abx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ga'i iya agdiri' sinan mga allingon pina'agi si pagpinugad kunta' nga i Diyos dina i angay nagdayaw sanglit agpadusmug-na dayon iya si adda anghel nagpabawa-na si Paragdalom. Tikang sinan pinaddihan dayon iya battong tungod si pagkutkut-na si mga wati si tina'i-na hasta nga amatay. ");
INSERT INTO abx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero agsamwak i allingun-na si Diyos ngan malabbat magpanutu'o. ");
INSERT INTO abx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ngan pakatapus-na kas Bernabe pati' si Saulo si mga tuyu'-na ari si Jerusalem, agbwilta mga iya nga agpabaya'-na si Juan nga kilala liwat si aron Markos. ");
INSERT INTO abx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aniya' mga paragsumat pati' mga paragturo' nga sakop si manniniripon pag'ampo' ari si syudad Antioquia nga iya kas: Bernabe, Simeon nga nag'anga'an Nigro, Lucio nga taga sunsari'i si syudad Cirene, Manaen nga nagpahaya siray paghuwang-huwang si gubirnador Herodes, pati' si Saulo. ");
INSERT INTO abx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Adda bisis ngan pagpangampu'-na si Paragdalom si manniniripon bawa i pagpu'asa, agpakatu'an-na mga iya si Espirito Santo, “Tagamahu-bi si Bernabe pati' si Saulo para si nagpatu'in-ko si mga iya trabaho.” ");
INSERT INTO abx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sanglit padayon i pagpamu'asa-na ngan agpamangadyi' hi'unong si duwangan to. Kahuman sinan, nagpandu'unan to si mga palat-na si mga mahanak si pagtu'o pagpatubyan si mga iya si katungdanan. Mangno nagpamataliwan. ");
INSERT INTO abx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sanglit, tungod kay i Espirito Santo i maglihog kas Bernabe pati' Saulo, padalugdog mga iya pan bungto Seleucia kon singnga mga iya patalabok pan isla Cipre. ");
INSERT INTO abx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Si panakka-na mga iya si Salamina nga adda syudad ari, agtikang dayon mga iya pagwali si allingun-na si Diyos ari si mga sinaguga-na si mga Hebro. Huwang si mga iya si Juan Markos nga nagpabaya'-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Agparapamalatas mga iya si mga kaburubungtuhan si bug'os isla hasta nga anakka mga iya si syudad Papos. Mata'o i gubirnador ari nga nag'arunan Sergio Paulo. Aglihog to pag'ala' si kas Bernabe pati' Saulo kay aruyag iya amati' si allingun-na si Diyos. Si pag'araratubang-na na mga iya, aniya' andang ari tinapuran nga huwang si gubirnador. Hebro iya nga nag'arunan Bar-Jesus pero si Grikuhanon Elimas i pag'aron si iya. Tambalan iya nga bantugan si pagti'aw pati' si pagtigo si titakka. Agparapakunu-kunoy to nga paragsumat-na iya si Diyos. Si pagparapamati'-na si gubirnador si kas Bernabe, agkuntra si Elimas si mga pinahallingan-na mga iya. Maniguroy to gayod nga ga'i abawa i gubirnador si pagtu'o. ");
INSERT INTO abx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mangno si Saulo nga kilala liwat si aron Pablo, amuslong ari si Elimas. Agdaluman-na iya si Espirito Santo ngan aminugad, ");
INSERT INTO abx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Sapat-na kaw si Satanas ngan kuntra-na kaw si dimu'an katadungan! Agsunod kaw gayod si karat'an ngan daya'on kaw. Ga'i ba' kaw pahuway pagbaliko' si mga matadong pama'agi pagsunod si Paragdalom? ");
INSERT INTO abx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ina'anto akatuhunan kaw si kastigu-na si Paragdalom. Abuta kaw ngan ga'i kaw akakulaw si danta'-na si allaw tubtob si nagtala'an-na si Diyos.” Abuta dayon iya ngan agparapangarap-karap addangan pagpatuttot si iya. ");
INSERT INTO abx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pakakulaw-na si mahinabo' si Elimas, anutu'o dayon i gubirnador kay ag'usa gayod iya si gahom nga paluwa' tikang si nagparaturo' mahi'unong si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Amanakay paraw kas Pablo pati' i mga kahuruwangan-na tikang si Papos pada'iray si Perga nga syudad si Pamfilia. Kundi' ngan kari'i-na na mga iya, pa'amban si Juan si mga iya ngan pabwiltay to dina pan Jerusalem. ");
INSERT INTO abx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tikang si Perga pada'iray mga iya si Antioquia, Pisidia. Si Allaw Pandidiskanso, pasallod mga iya si sinaguga ari ngan aningkulo'. ");
INSERT INTO abx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pakahuman si mga barasahon nga nag'ala' tikang si Bala'ud-na si Moises pati' si Nagpanurat-na si mga Paragsumat, aniya' naglihug-na si mga puno' si sinaguga pagpinugad si mga iya, “Mga kabugtu'an, kon aniya' sumat-bi nga aka'aghat si mga a'a, alayon amahallinga kam.” ");
INSERT INTO abx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Anunggo si Pablo ngan agsinyas pagpamingaw ngan aminugad, “Amati'a kam si ako, ka'am mga a'a-nay nan si Israel hasta pa ka'am mga ma'in nan Hebro nga matinu'uhon si rilihiyon kami' mga Hebro. ");
INSERT INTO abx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Diyus-na si mga a'a-na si Israel, iya i magpili' si mga kapapu'-papu'an-ta kam pati' i magpa'asinso si mga iya dungan si paglalabbat-na mga iya tikang pa ngan pagpangistar-na ari si Ehipto bilang dayuhan. Kinakulawan i mahaya gahum-na si paggiya-na si mga iya paggawas sinan nasyon ");
INSERT INTO abx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ngan ag'antos iya si mga gawi'-na ari si disyirto sallod si kwarinta anyos. ");
INSERT INTO abx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mangno, iya i magpirdi si mga ka'aha'an si pito' nasyon ari si Canaan ngan agpumwan-na i mga pitak-na si mga ginsakupan-na bilang nag'iridar-na mga iya. ");
INSERT INTO abx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ahinabo' nan dimu'an sallod si kwatro syintos singkwinta anyos. “Kahuman sinan, agbuwanan-na mga iya si Diyos mga huwis pagpuno' tubtob si panahun-na kas Samuel nga paragsumat-na. ");
INSERT INTO abx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mangno agpalako i mga a'a adda hadi' ngan agpumwan-na si mga iya si Saulo nga aghadi' tubtob si kwarinta anyos. Dadi'-nay to iya si Kis, nga sakop si pamilya Benjamin. ");
INSERT INTO abx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pakahuman pagbawi' si pagkahadi'-na si Saulo, agtu'inan-na si Diyos si David nga magin hadi'-na mga iya. I Diyos mismo magpakatu'an si mga a'a hi'unong si iya si pagpinugad-na: ‘Si dimu'an sakilala-ko, si David nga dadi'-na si Jesse, iya gayod i maka'irog si kina'iya-ko. Buruhatun-na i dimu'an karuyag-ko.’ ");
INSERT INTO abx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Tikang si mga ka'uru'ampuhan-na sito lalla i Paragsalbar Jesus, nga nagpabawa-na si Diyos paghadi' si Israel sigon si dati sa'ad-na. ");
INSERT INTO abx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Myintras abantog si Jesus, agparapasamwak si Juan Paragbunyag nga kinahanglan agpamakulaw i dimu'an a'a-na si Israel nga agbasol huwang si pagbag'o pina'agi si pagpabunyag. ");
INSERT INTO abx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Si paghinapus-tapus-na si trabahu-na si Juan, aminugad iya, ‘Say i pagkakilala-bi si ako? Ma'in ako i nagparapanimulat-bi, pero tipada'ito iya kahuman si ako. Ma'in ngani' ako angay bisan pagbak'ad si sintas-na si sapatus-na.’” ");
INSERT INTO abx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Agpadayon si Pablo pagsumat, “Mga kabugtu'an nga ka'ampu-ampuhan-na si Abraham, huwang na kam mga ma'in nan Hebro nga matinu'uhon si rilihiyon kami' mga Hebro, tuninungi-bi to. Kita kam dina i nagpatakkahan si sumat hi'unong si pa'agi nga atalwas i a'a, ");
INSERT INTO abx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","kay sumatan-ta kam, i mga a'a si Jerusalem angabuyon si mga punu'-na nga ga'i pagkilala si Jesus. Lugod, si karuyag-na mga iya nga nagmatay to, si ma'in tinuyo' agtuman-na dina mga iya i mga allingun-na si mga paragsumat nga nagparabasa balang Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan ga'i mga iya aka'anda' tama' rason nga angay pagpatok kamatayon, agpalaku-na mga iya si Pilato pagpamatay si iya. ");
INSERT INTO abx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ngan atuman na i dimu'an maka'anna' si Kasuratan hi'unong si iya, tighaw'as-nay to mga iya tikang si day sanga-na si kayo ngan tighulid-nay to si kwiba panlalabbungan. ");
INSERT INTO abx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero agbanhaw-na iya si Diyos, ");
INSERT INTO abx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ngan sallod si pira allaw kinakulawan iya si mga kahuruwangan-na siray pagbiyahi tikang si prubinsya Galilea pan Jerusalem. Mga iya ina'anto i magpantistigos mahi'unong si iya atubang si mga igkasi-ta. ");
INSERT INTO abx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Pakatu'an kami' si ka'am i mahalap sumat: I nagpasa'ad-na si Diyos si mga kapapu'-papu'an-ta kam mga Hebro, ");
INSERT INTO abx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","atuman ato si kita kam ngan pagpa'undong si Jesus bilang Paragsalbar. Aniya' maka'anna' mahi'unong sito buhat si kaduwa Salmo: Ka'aw i Dadi'-ko; ina'anto publikar-ko nga ako i Tatay-mo. ");
INSERT INTO abx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","35","Pwira pa sinan, tungod kay aniya' sa'ad-na si Diyos maka'anna' si Kasuratan: Tuman-ko i nagsa'ad-ko si David nga gana' la'in kon ma'in i dimu'an nga makatapuran ngan diyusnon kararawatun-mo, aniya' liwat maka'anna' si Kasuratan mahi'unong si pagbanhaw-na si Jesus nga ga'i arunot i bangkay-na: Ga'i ako agtugot nga arunot i bangkay-na si Sagrado Nagtagama-ko. ");
INSERT INTO abx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Parti si David akatu'anan kita nga agsirbi iya si katuyu'an-na si Diyos. Si pakamatay-na, naglabbungan iya huwang si mga kapapu'-papu'an-na ngan arunot i bangkay-na. ");
INSERT INTO abx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kundi' i nagbanhaw-na si Diyos, ga'i ag'agi pagkarunot. ");
INSERT INTO abx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Sanglit mga kabugtu'an, aruyag ako agpakatu'an si ka'am nga si Jesus i nagtukoy nga Gisurusagraduhi Tinu'inan ngan pasamwak-ko nga pina'agi si kamatayun-na, apasaylo i sala'. ");
INSERT INTO abx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Gana' nagkwinta matadong si pangulawan-na si Diyos pina'agi si pagsunod si bala'ud-na si Moises kundi' agkwinta-na matadong i kada addangan nga padayon si pagtutu'o si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Agmatuha kam nga ga'i ahinabo' si ka'am i nagpinugad-na si mga paragsumat: ");
INSERT INTO abx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ka'am magparatamay nan, manginanuha kam pahalap. Sigurado panno' kam si pag'usa pero amatay kam gihapon bulag si Diyos kay aniya' buruhatun-ko myintras allom pa kam nga ga'i kam anutu'o bisan kon aniya' magpasayod si ka'am nga kamatu'uran to.” ");
INSERT INTO abx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mangno agdahulo kas Pablo pati' Bernabe paggawas si sinaguga, sanglit aniya' mamungyod si mga iya pag'imbitar nga pagpahalling pa mahi'unong sito si manunod Allaw Pandidiskanso. ");
INSERT INTO abx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kahuman pagpalitira si magtiriripon, malabbat i mamukod si kas Pablo. Aniya' si mga iya mga Hebro pati' mga rilihuso nga magkabarawa si mga rilihiyun-na. Sanglit agpadayon pa kas Pablo pagpasayod mahi'unong si nagpanwali-na bawa i pag'aghat sito mga a'a nga agpasigi si pagtapud-na mga iya si mapinalangga'on pagpanginanu-na si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Si manunod Allaw Pandidiskanso, haros i dimu'an a'a si bug'os syudad agtiriripon pagpakali si allingun-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Si pakakulaw-na si mga Hebro si katabbul-na sito mga a'a, aniya' si mga iya nga bali i ka'awa'-na ngan agparahimullu'an-na mga iya i nagparapahalling-na si Pablo. ");
INSERT INTO abx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pero pusukado dina kas Pablo pati' Bernabe pagsupla si mga iya. Aminugad si Pablo, “Kinahanglan wali kami' dahulo si ka'am i allingun-na si Diyos. Kundi' kay andiri' may kam, klarado nga ga'i kam aburubantad ngan ma'in kam angay pag'angkon si kinabuhi' nga gana' katapusan-na. Sanglit pada'iray na hamok kami' ina'anto si mga ma'in Hebro ");
INSERT INTO abx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","basi' atuman i nagtagamahan-na si kami' si Paragdalom: Aghimu-ta kaw danta' para si mga ma'in Hebro, basi' ka'aw i mamakatu'an si dimu'an mga a'a kon pinapa'i mga iya atalwas.” ");
INSERT INTO abx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Si pakapakali-na sinan si mga ma'in Hebro, alipay mga iya ngan agdayaw-na mga iya i allingun-na si Paragdalom. Agpanutu'o i dimu'an nga nagpangandam pag'angkon si kinabuhi' nga gana' katapusan-na. ");
INSERT INTO abx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Agsara i allingun-na si Paragdalom si dimu'an lugar palibot siray syudad. ");
INSERT INTO abx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tungod sinan, aniya' mga kilalado danda nga matinu'uhon si rilihiyun-na si mga Hebro pati' mga mahaya a'a si syudad nga sa'aghat-na si mga Hebro pagkuntra si kas Pablo pati' Bernabe. Agparapamasakitan-nay to mga iya tungod hamok si mga pagtu'u-na hasta nga nagpamapinday to ari siray lugar. ");
INSERT INTO abx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sanglit papaspas-na mga iya i alpug-na si mga kitid-na pagpakatu'an nga anggana' na baratunun-na mga iya si mga a'a ari ngan agdiritso mga iya si syudad Iconio. ");
INSERT INTO abx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bisan kon da'inan sinan i manakka si kas Pablo, agkarilipay i magkabirilin inadalan ngan agpandaluman-nay to si Espirito Santo. ");
INSERT INTO abx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ari si syudad Iconio, pasallod kas Pablo pati' Bernabe si sinaguga-na si mga Hebro, sigon si kabatasanan-na na mga iya kon anakka si baha'o lugar. Tungod si kahalap-na si pagwali-na mga iya, bali labbat si mga Hebro ngan da'inan may si mga ma'in Hebro i magpanutu'o. ");
INSERT INTO abx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero i mga Hebro nga agdiri' pagtutu'o si Jesus agpara'aghat-na i ditangnga' nga ma'in Hebro pagkuntra si mga kabugtu'an si pagtu'o. ");
INSERT INTO abx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bisan kon da'inan sinan, tama'-tama' i kaliyat-na kas Pablo pag'istar ari, ngan pusukado mga iya pagwali tungod si pagtapud-na mga iya si Ginu'o. Agparasumat mga iya mahi'unong si mapinalangga'on pagpanginanu-na, ngan mismo si Jesus i makapamatu'od nga ungod to pina'agi si pagbuwan-na si mga iya gahom paghimo mga urusahon pati' mga pangngilalahan si langitnon kasiguruhan. ");
INSERT INTO abx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Sallod sinan mga ka'urason, i mga a'a nga alisang dahulo agsadurudiki'it pag'abuyon si mga apostol ngan i ditangnga' may angabuyon si mga ga'i magpanutu'o Hebro hasta nga anakka nga agduwa na hamok grupo i mga a'a si syudad. ");
INSERT INTO abx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ga'i agka'aradda siray i mga ma'in Hebro pati' i mga Hebro pero tungod si mga kasina-na mga iya si kas Pablo, agkurunsabo mga iya huwang i mga punu'-na pagkastigo pati' pagtalutog. ");
INSERT INTO abx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero agpakatu'anan to parti si plano sanglit palitira mga iya pada'iray si syudad Listra pati' si bungto Derbe nga mga sakop si Liconia. Akatakka liwat mga iya si ditangnga' kaburubungtuhan sakop sito prubinsya, ");
INSERT INTO abx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ngan agpamadayon pagpasamwak si mahalap sumat. ");
INSERT INTO abx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ari si Listra aniya' addangan maglipag'ak nga ga'i gayod agamit i kitid-na tungod kay lulid iya tikang pa si paka'allum-na. ");
INSERT INTO abx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Agparapamati' to si pagparapasamwak-na si Pablo. Agbuslung-nay to pahalap si Pablo ngan sa'abat-na nga aniya' gayod sito pagtapud-na si Jesus nga sapalangngan-na iya ");
INSERT INTO abx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","sanglit agban'u-nay to si Pablo, “Anungguha!” Pakabati'-na sinan, anlukso dayon i lulid ngan agtikang paglangngan. ");
INSERT INTO abx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pakakulaw-na si mga taga Liconia si nagbuhat-na si Pablo, agpanurakaw to si mga kalugaringun-na linggwahi, “I mga diyos nga ag'istar si langit, atiya' na nga agpakang'a'a!” ");
INSERT INTO abx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","13","Ari si gawas-na si syudad, aniya' templu-na si diyus-na mga iya nag'arunan Zeus ngan i pagkagasi-na mga iya nga si Bernabe si Zeus na, ngan si Pablo may si Hermes kay iya i tinu'inan parapasamwak. Sanglit i paraghalad-na si Zeus agbawa mga panhahalad pada'iray si pwirtahan-na si syudad. Agpamawa mga iya mga tinulu-tulo burak pati' mga butakal baka nga burunu'on kunta' pagpakulaw nga ag'ampo' mga iya si mga apostol. ");
INSERT INTO abx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pakakatu'an-na kas Bernabe pati' Pablo hi'unong sito, wagnit-na dayon mga iya i mga badu'-na pagpakulaw nga akariman mga iya sito mga a'a tungod kay ga'i to agpakakilala si ungod Diyos. Pamadugok mga iya si kalabbatan magpanggubok ari ngan pina'agi si makusog busis agpasayod mga iya, ");
INSERT INTO abx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Dakam agbuhat sinan. Mga a'a hamok kami' nga pararihu-bi. Agpasamwak kami' si ka'am si mahalap sumat basi' patalikot kam si mga gana' kapulsanan-na diyos pada'iray si Diyos nga gana' kamatayun-na, i maghimo si kalangitan, si pitak, si kalawot, pati' si dimu'an mga inanna'-na sito. ");
INSERT INTO abx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Siray mga panahon, agpata'anan-na hamok i mga ka'aha'an pagsunod si mga kalugaringun-na pama'agi. ");
INSERT INTO abx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero agpasiguro pirmi iya nga aniya' pruwiba si pagkadiyus-na. Agpakulaw iya si kadaluman-na pina'agi si pagpumwan si ka'am i tigtanumon pati' i tigpangku'on. Iya i magbuwan si ka'am ka'abunda si pagkakan pati' i magpanno' si kasing-kasing-bi si kalipayan.” ");
INSERT INTO abx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bisan pina'agi sinan mga allingon, agkuri dahulo kas Pablo pagpugong si mga a'a pag'ampo' si mga iya. ");
INSERT INTO abx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mangno aniya' manakka mga Hebro tikang si mga syudad Antioquia pati' Iconio nga makabawa si mga a'a pagkuntra kas Pablo. Sanglit nagtalutugan si Pablo ngan nagdagnas pagawas si syudad. I pagkagasi-na mga iya nga minatay nayto. ");
INSERT INTO abx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero ngan pag'ararung-arung-na si mga inadalan, akamangno gihapon iya. Si pakatunggu-na, pabwilta iya pan syudad. Ka'asumuhan pataliwan mga iya si Bernabe pan Derbe. ");
INSERT INTO abx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Agpasamwak kas Pablo si mahalap sumat ari si Derbe ngan malabbat i magkahirimo mga inadalan-na si Jesus. Mangno pabwilta mga iya pan Listra, Iconio pati' Antioquia ");
INSERT INTO abx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","pagpabaskog si mga inadalan pati' pag'aghat sito pagpadayon si katangkud-na mga iya si ungod pagtu'o. Agparapinugad mga iya, “Si pagsakup-ta kam si mga nagpanhadi'an-na si Diyos, sigurado kita kam ag'agi malabbat kasakitan.” ");
INSERT INTO abx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pahuway kas Pablo pati' Bernabe si kada lugar nga aniya' manniniripon pag'ampo' pagtu'in mga lalla nga angay ag'inantan si katungdanan bilang mahanak si pagtu'o ngan pina'agi si pagpangadyi' pati' pagpu'asa, agpatubyan-nay to mga iya si Ginu'o nga dati na nagpantapuran-na. ");
INSERT INTO abx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Palabay mga iya si prubinsya Pisidia ngan agdiritso pan prubinsya Pamfilia. ");
INSERT INTO abx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pahuway dahulo mga iya ari si syudad Perga pagpasamwak si allingun-na si Diyos, mangno diritso mga iya padalugdog pan bungto Atalia. ");
INSERT INTO abx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tikang si Atalia, patalabok mga iya pagbwilta si Antioquia kon singnga nagpatubyan mga iya si Diyos siray ngan pataliwan-na mga iya pagpamiyahi. Nagpamatubyan to si mapinalangga'on pagpanginanu-na si Diyos basi' atuman i trarabahu'un-na mga iya pagpasamwak. ");
INSERT INTO abx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sanglit panakka-na mga iya ari, agpaban'u-na i manniniripon pag'ampo' ngan agpasumat-na mga iya i dimu'an sabuhat-na si Diyos si paghuwang-na si mga iya, ngan kon pinapa'i sapamuklat-na i mga ma'in Hebro parti si pagtutu'o. ");
INSERT INTO abx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ngan ag'istar mga iya ari si pira bulan pagpakihuwang si mga inadalan. ");
INSERT INTO abx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Aniya' mga lalla man prubinsya Judea magpamada'iray si syudad Antioquia nga agparapanturo' si mga kabugtu'an si pagtu'o si pagpinugad, “Hasta nga ga'i kam agpamaturi' sigon si kabatasanan nagturu'-na si Moises, ga'i kam agkataralwas.” ");
INSERT INTO abx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","3","Tungod sinan, anupak kas Pablo pati' Bernabe hasta nga agdiriskusyon mga iya. Sanglit nagpakibagawan mga iya duwangan si manniniripon pag'ampo' pagbagat si mga apostol pati' si mga mahanak si pagtu'o nga awiray si Jerusalem mahi'unong si nagsupakan-na mga iya. Nagtimahan mga iya para si mga biyahi-na ngan nagpamataliwan huwang si mga magpanutu'o nagpamili' pagbaya' si mga iya. Si pagbalatas-na mga iya ari si mga prubinsya Fenicia pati' Samaria, agparasumat mga iya kon pinapa'i pakabawa-na pagtutu'o si mga ma'in Hebro. Tungod sinan sumat, bali i kalipayan-na si dimu'an kabugtu'an sinan mga lugar. ");
INSERT INTO abx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Panakka-na mga iya ari si Jerusalem, mahalap i pagkarawat si mga iya si manniniripon pag'ampo', si mga apostol pati' si mga mahanak si pagtu'o. Agpasumat-na mga iya sito mga a'a i dimu'an sabuhat-na si Diyos si paghuwang-na si mga iya. ");
INSERT INTO abx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mangno, aniya' si magpanutu'o nga mga Parisiyo magpanunggo ngan magpaminugad, “Kinahanglan nagturi' ngan nagtugunan pagsunod gayod si Bala'ud-na si Moises i dimu'an nga ma'in Hebro.” ");
INSERT INTO abx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sanglit ag'aradda i mga apostol pati' i mga mahanak si pagtu'o pagbararagaw hi'unong si kamutangan-na si magpanutu'o nga ma'in Hebro. ");
INSERT INTO abx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kahuman si bali diribatihay, anunggo si Pedro ngan aminugad, “Mga kabugtu'an si pagtu'o, katu'anan kam nga agpili'-na ako si Diyos tikang si ka'am ngan ay ba' ray pa ta'una, basi' mismo tikang si ako akapamati' ngan agpanutu'o si mahalap sumat i mga ma'in Hebro. ");
INSERT INTO abx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I Diyos nga sayod andang si ungod kina'iya-na si kada addangan, agpakulaw si pag'ako' si mga ma'in Hebro pina'agi si pagpa'ayop si Espirito Santo si mga iya, pariho si nagbuhat-na may si kita kam. ");
INSERT INTO abx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pina'agi si pagtutu'o, agpasaylu-na si Diyos i mga kasal'anan-na. Sanglit kinakulawan nga para si Diyos, i mga ma'in Hebro gana' pagkala'inan-na si kita kam. ");
INSERT INTO abx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kon sugad, dakam na agparapurbari-bi i pasinsya-na si Diyos pina'agi si pagbuwan kakurihan sito mga inadalan. Agparapapasunud-bi mga iya si Bala'ud-na si Moises nga bisan ngani' mismo kita kam pati' i mga kapapu'-papu'an-ta kam ga'i agpakakaya. ");
INSERT INTO abx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lugod, agtutu'o kita nga atalwas kita tungod si mapinalangga'on pagpanginanu-na si Paragdalum-ta kam Jesus nga iya may liwat i mahinabo' si mga ma'in Hebro.” ");
INSERT INTO abx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tungod sinan, gana' rinibuk-ribukay si pagparapamati'-na si dimu'an mag'atindir ari siray bararagaw ngan diritso agsumat kas Bernabe pati' Pablo mahi'unong si mga nagbuhat-na si Diyos pina'agi si mga iya atubang si mga ma'in Hebro. Sito mga buhat, aniya' mga urusahon pati' mga pangngilalahan si langitnon kasiguruhan. ");
INSERT INTO abx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pakahuman-na mga iya agpahalling, anunggo si Santiago ngan aminugad, “Mga kabugtu'an, amati'a kam si ako. ");
INSERT INTO abx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Agsumat-na na si Simon kon pinapa'i agpakatu'an-na si Diyos si primiro bisis i kadisididu-na pagpanginano si mga ma'in Hebro kay aniya' nagbulag-na ditangnga' si mga iya nga magin baha'o grupo ka'aha'an sakop si iya. ");
INSERT INTO abx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ag'alagad gayod sinan i maka'anna' si Nagpanurat-na si mga Paragsumat: ");
INSERT INTO abx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Pada'ito ako gihapon kahuman-ko pagkastigo si mga a'a-ko ngan patunggu-ko gihapon i mga ginsakupan-na si Hadi' David. Patindug-ko i magkaburungkag ngan pabwilta-ko mga iya si dati kamutangan-na ");
INSERT INTO abx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","basi' agpanganda' si Paragdalom i ditangnga' ka'aha'an nga iya i mga ma'in Hebro nga nagtagama pag'ako' si arun-ko. Iyay nan i allingun-na si Paragdalom nga magbuhat sito ");
INSERT INTO abx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","nga nagpakatu'an tikang pa siray.” ");
INSERT INTO abx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mangno agpadayon si Santiago pagpahalling, “Sanglit para si ako, ma'in angay pagpakuri si mga ma'in Hebro nga pamadugok si Diyos. ");
INSERT INTO abx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lugod, suratan-ta kam mga iya pagsumat nga nagdiri' i mga pagkakan nga human na nagpahalad si mga diyus-diyos hasta pa i aniya' laha'-na o ma'in ngani' i tikang si mga hayop nga ga'i nagpalaha'. Nagdiri' liwat i pag'ubay si bisan say hamok sasindakan-na. ");
INSERT INTO abx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Angay nga pasunud-ta mga iya bisan hamok sinan mga kasugu'an kay maliyat na nagparawali si kada lugar i Bala'ud-na si Moises ngan kalabbatan i sayod sito tungod kay nagparabasay to si mga sinaguga kada Allaw Pandidiskanso.” ");
INSERT INTO abx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mangno agsarabot i mga apostol pati' i mga mahanak si pagtu'o, huwang i bug'os manniniripon pag'ampo', nga aniya' pinabaya' si mga sunsari'i magpanutu'o si kas Pablo pati' Bernabe pagbwilta pan Antioquia. Sanglit tikang si kabugtu'an si pagtu'o agpili' mga iya duwangan nga mga puno', Silas pati' Judas nga kilala liwat si aron Barsabas. ");
INSERT INTO abx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yayto i surat nagpabawa si mga iya: Tikang to surat si mga apostol pati' si mga mahanak si pagtu'o, nga mga kabugtu'an-bi. Agsurat kami' si ka'am mga magpanutu'o nga ma'in Hebro anan si Antioquia, hasta si mga prubinsya Siria pati' Cilicia: Kumusta kam dimu'an. ");
INSERT INTO abx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Akapamati' kami' nga aniya' mga a'a, nga tikang kuno' si kami', magparaturo' si ka'am nga akapasamok dina si mga inisipan-bi. Si kamatu'uran, ga'i kami' aglihog sinan mga a'a. ");
INSERT INTO abx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sanglit agsarabot kami' pagpili' mga a'a pagpabawa pada'inan si ka'am. Agpabungyod kami' mga iya si kas Pablo pati' Bernabe, mga hinigugma' kami' kumpaniya ");
INSERT INTO abx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","nga andam pirmi pagpa'unong si mga kinabuhi'-na para si Paragdalum-ta kam Jesu-Kristo. ");
INSERT INTO abx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sanglit agpapada'inan kami' kas Judas pati' Silas pagpamatu'od nga i isi-na sito surat sigon gayod si nagbararagawan kami'. ");
INSERT INTO abx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Angabuyon kami' si katuyu'an-na si Espirito Santo nga mahalap para si ka'am kon ga'i kam nag'ura-urahan pagpabug'at pwira na i pagtuman sito mga buruhaton: ");
INSERT INTO abx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Agdiri'a kam si mga pagkakan nga human na nagpahalad si mga diyus-diyos hasta pa i aniya' laha'-na o ma'in ngani' i tikang si mga hayop nga ga'i nagpalaha'. Diri'u-bi liwat i pag'ubay si bisan say hamok sasindakan-bi. Para si kahalapan-bi kon agtuman kam sito. ");
INSERT INTO abx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mangno, nagpataliwan mga iya ngan agpamaktas pan Antioquia. Panakka-na mga iya ari, agpaban'u-na mga iya i manniniripon pag'ampo' ngan agpumwan-na mga iya i surat. ");
INSERT INTO abx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Agbasa-nay to si mga a'a ngan agkarilipay hi'unong si maka'a'aghat isi-na sito. ");
INSERT INTO abx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mahaya i mga sabulig-na kas Judas pati' Silas kay mga paragsumat-nay to liwat si Diyos. Aka'aghat ngan akapabaskog mga iya si mga kabugtu'an si pagtu'o tungod kay ma'isi i mga pinahallingan-na. ");
INSERT INTO abx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kahuman si pira allaw, nagpataliwan mga iya si mga kabugtu'an huwang i pagpalako kamurayaw ngan makigpangumusta mga iya si magpanlihog sito. ");
INSERT INTO abx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pero pabilin kas Pablo pati' Bernabe ari si Antioquia. Agpadayon mga iya pagturo' ngan pagpasamwak si allingun-na si Paragdalom ngan malabbat ari i mga kapararihu-na. ");
INSERT INTO abx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kahuman si pira duminggo, ag'agda-na si Pablo si Bernabe, “Tana pabwilta pagbisita si mga kabugtu'an si pagtu'o si intiro kaburubungtuhan nagpasamwakan-ta si allingun-na si Paragdalom. Kulawan-ta kon mati'ay na mga iya.” ");
INSERT INTO abx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Karuyag-na si Bernabe nga pinabaya' si mga iya si Juan, nga kilala liwat si aron Markos. ");
INSERT INTO abx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Iyay nan i dadi'-dadi'on pa lalla nga pabulag si mga iya ngan kari'i-na mga iya si prubinsya Pamfilia ngan ga'i na agpadayon pagtapos si mga trabahu-na. Bisan kon agsiharalapay na mga iya, akahuna'-huna' gihapon si Pablo nga ga'i pagpabaya' sito kay aniya' sito kina'iya-na pagbulag nga gana' sarit-saritay. ");
INSERT INTO abx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tikaladkad na kunta' i mga laha'-na kas Pablo pati' Bernabe ngan gana' gayod papirdi si mga iya sanglit agbulag na hamok mga iya. Patalabok si Bernabe huwang si Markos pan isla Cipre ");
INSERT INTO abx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ngan si Silas may i nag'agda-na si Pablo pagbaya' si iya. Nagpatubyan kas Pablo pati' Silas si mga kabugtu'an si mapinalangga'on pagpanginanu-na si Paragdalom. ");
INSERT INTO abx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pataliwan mga iya ngan si paka'agi-na mga iya si Siria pati' si Cilicia, sigi mga iya pabaskog si mga pagtu'u-na si manniniripon pag'ampo' si mga kaburubungtuhan ari. ");
INSERT INTO abx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Agdiritso kas Pablo pada'iray si bungto Derbe mangno si syudad Listra. Aniya' sunsari'i inadalan nag'arunan Timoteo. Hebro sito i nanay-na nga sakop si mga magpanutu'o pero Griko dina i tatay-na. ");
INSERT INTO abx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nagparadayaw to si mga kabugtu'an si pagtu'o ari si Listra pati' ari si syudad Iconio. ");
INSERT INTO abx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Aruyag gayod si Pablo pagpahuwang sito, sanglit agturi'-nay to basi' nagkarawat si mga Hebro, kay akatu'anan i mga Hebro ari si mga aragihan-na lugar nga Griko dina i tatay-na. ");
INSERT INTO abx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Si pagparapamada'iray-na mga iya si kaburubungtuhan, agpakatu'an-na mga iya i nagbararagawan-na si mga apostol pati' si mga mahanak si pagtu'o ari si Jerusalem basi' akasunod i magpanutu'o. ");
INSERT INTO abx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sanglit agbabaskog i manniniripon pag'ampo' ato sito mga lugar ngan sigi mga iya lalabbat si kada allaw. ");
INSERT INTO abx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Agpamaktas kas Pablo si mga lugar sallod si Frigia nga sakop si prubinsya Galacia, kay ga'i mga iya nagtugutan si Espirito Santo pagpasamwak si allingun-na ari si banda timugan parti si prubinsya Asia. ");
INSERT INTO abx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Si pagdadara'un-na mga iya si mga lugar sakop si Misia ari si banda norte, akahuna'-huna' mga iya pasallod si mga lugar sakop si Bitinia pero ga'i gihapon mga iya agtugutan-na si Espiritu-na si Jesus. ");
INSERT INTO abx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Sanglit pa'agi na hamok mga iya ari si Misia ngan padalugdog pan syudad Troas. ");
INSERT INTO abx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kasanguman aniya' nagpakulaw si Pablo maka'urusa kurulawan. Ari sakulawan-na i taga prubinsya Macedonia nga agtutunggo ngan sigi pakimalu'oy si iya, “Pada'ituha may alayon si Macedonia ngan buligin kami'.” ");
INSERT INTO abx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pakakulaw-na si Pablo sinan maka'urusa kurulawan, agdadagmit dayon kami' nga akatalabok pan Macedonia, kay akasiguro kami' nga da'inan sinan i pa'agi-na si Diyos pagmando' si kami' pagpasamwak si mahalap sumat si mga taga sunsari'i. ");
INSERT INTO abx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tikang si Troas, agpalayag kami' pan isla Samotrasia mangno ka'asumuhan agdiritso kami' pan bungto Neapolis. ");
INSERT INTO abx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tikang ari agpamaktas kami' pan Filipos. Adday nan si pinaka'impurtanti syudad si Macedonia nga aglugaring si panggubyirnuhan tungod kay ka'urugan si magpangistar ari tikang gayod si Roma. Ag'istar kami' ari si pira allaw. ");
INSERT INTO abx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Panakka-na si Allaw Pandidiskanso, pagawas kami' si syudad ngan pada'iray kami' si suba' kon singnga agla'om kami' nga aniya' pammamangadyi'an-na si mga Hebro. Panakka kami' ari, aningkulo' kami' ngan agtikang dayon kami' pagpakibagaw si mga danda nga agtiriripon ari. ");
INSERT INTO abx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Addangan si mga magpamati' si Lydia, nga parabaligya' si mahal mga hiniro nga kulor igot. Yayto danda taga sunsari'i dina si syudad Tiatira ngan matinu'uhon si rilihiyun-na si mga Hebro. I Paragdalom i makapamuklat si inisipan-na pag'ako' si sumat-na si Pablo. ");
INSERT INTO abx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kahuman si pakabunyag si iya hasta pa si kahuruwangan-na si ruma', ag'imbitaran-na kami' pagpada'iray si mga iyay ray. Aminugad iya, “Kon agkilala-bi ako nga adda tangkod magtutu'o si Paragdalom, tana kam pan ruma' ngan ari kam pasangpot.” Sanglit sapabaya'-na kami'. ");
INSERT INTO abx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Adda bisis si pagpada'iray kami' si pammamangadyi'an-na si mga Hebro, aniya' manupo' si kami' binalli na uripon danda nga nag'ayupan si mara'at espirito. Tungod sinan, akatu'anan iya si titakka ngan akapayaman iya si mga tagtawa' si iya pina'agi si pala'in-la'in pagtigo. ");
INSERT INTO abx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Sigi iya burub