﻿USE sofia;
DROP TABLE IF EXISTS sofia.abt_wosera_vpl;
CREATE TABLE abt_wosera_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES abt_wosera_vpl WRITE;
INSERT INTO abt_wosera_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","tAn Jisas Kraisna gwaal waaranga maandéka bakamuna yé a. Jisas Devitna kémba yaalandén. Devit Abrahamna kémba yaalandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham wan Aisakna aapa wa. Aisak wan Jekopna aapa wa. Jekop wan Juda déku aanyémbéré waayékanjele deku aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda wan Peres ambét Serana aapa wa. Bérku aasa Tamar wa. Peres wan Hesronna aapa wa. Hesron wan Ramna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram wan Aminadapna aapa wa. Aminadap wan Nasonna aapa wa. Nason wan Salmonna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon wan Boasna aapa wa. Boasna aasa Rahap wa. Boas wan Obetna aapa wa. Obetna aasa Rut wa. Obet wan Jesina aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi wan Israelna du dakwa deku néma du Devitna aapa wa. Abrahammba taale naakiye ye ye Devit kukmba naakite wa du tambavétik maanmba kaayék vétik vétik (14) naakinangwa. Devit wan Solomonna aapa wa. Solomonna aasa taale Uriana taakwa wa télén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon wan Rehoboamna aapa wa. Rehoboam wan Abiyana aapa wa. Abiya wan Asana aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa wan Jehosafatna aapa wa. Jehosafat wan Jehoramna aapa wa. Jehoram wan Usiana aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia wan Jotamna aapa wa. Jotam wan Ahasna aapa wa. Ahas wan Hesekiana aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia wan Manasena aapa wa. Manase wan Emonna aapa wa. Emon wan Josaiana aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia wan Jehoiakin déku aanyé waayékale deku aapa wa. Wani sapak wa Israelséna maamasé Babilonmba yaae Israelsale waariyandarén. Waariyandaka Babilonséna mayé apa wa Israelséna mayé apat taalékérandéka de Babilonmba yaan dunyansé Israelsat kéraae kure yéndarén Babilonét. Devitmba taale naakilakét ye ye Jehoiakin kukmba naakite wa du tambavétik maanmba kaayék vétik vétik (14) naakinangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israelsé Babilonmba téndarén sapak Jehoiakin wan Sealtielna aapa wa. Sealtiel wan Serubabelna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel wan Abiutna aapa wa. Abiut wan Eliakimna aapa wa. Eliakim wan Asorna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor wan Sadokna aapa wa. Sadok wan Akimna aapa wa. Akim wan Eliutna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut wan Eleasarna aapa wa. Eleasar wan Matanna aapa wa. Matan wan Jekopna aapa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop wan Josepna aapa wa. Josep dé Mariana du wa. Maria Jisas kéraalén. Déké wanangwa, “Nanat yékun yandénngé Got wan du Krais wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Talimba Israel du dakwat wa kure yéndarén Babilonét. Wani sapak Jehoiakin yaréndén. Jehoiakinmba taale naakilakét ye ye Got wan du Krais kukmba naakite wa du tambavétik maanmba kaayék vétik vétik (14) naakinangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria Jisas Krais kéraalén kundi anga wa kwaakwa. Taale Mariana aasa aapa wandarén, lé Josepmba kumbilénngé. Wandaka kukmba bét nakurakmba wayéka yarékapuk yambéréka Gotna Yaamambi wa gaaye lat mayé apa kwayéndéka nyaan télén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kukmba lé kéraaké yakwa du, déku yé Josep, dé wan yéku musé male yakwa du wa. Lé nyaan téléka dé wani muséké vékusékte déku mawulémba wandén, “Lé nak duwale wa kwaambérén. Bulaa lé katik kéraaké wuté.” Wunga watake wa nakapuk wandén, “Wuné lé kéraakapuk ye akwi du dakwana ménimba yéte lat waaruwutu lé nékéti yakalékwa. Wuné yakélak yaaséka-kawutékwa lé.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wunga watake wani muséké vékulakapékare yéngan nak kwaandén. Kwaandéka Néman Du Gotna kundi kure gaayakwa du nak gaaye yénganmba dat wandén, “Méno Josep, Devitna gwaal waaranga maandéka bakamu, ma véku. Méné wup yaké yambak Maria kéraamuké. Gotna Yaamambi gaaye lat mayé apa kwayéndéka wa nyaan télékwa. Gotna Yaamambi wunga kwayéndénngé méné lé kéraamuké wup yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lé dunyanngu nyaan kéraakalékwa. Kéraalu wa dé déku du dakwa Satanna taambamba kéraae yandarén kapéremusé yasnyéputi-kandékwa. Wunga yaké yandékwanngé vékulakate méné déku yé Jisas ma waaménék.” Josepét wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Talimba Néman Du Got déku yémba kundi kwayétan duwat ani kundi wandéka wa Gotna nyéngaamba anga viyaatakandén: Du kumbikapuk yan taakwa nak nyaan tékalékwa. Te kéraalu de déku yé Emanuel waakandakwa. Wunga viyaatakandéka wani sapak wani kundi wa sékérékén. Wani yé Emanuel anga wandékwa: Got nanale randékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep yéngan kwaae vélérkiyaae waarape Néman Du Gotna kundi kure gaayakwa du wan pulak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yate Maria kéraandén. Wani sapak dé lale yamba kwaandékwe wa. Yandéka kukmba nyaan kéraaléka wa déku yé waandén, Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot Judana du dakwana néma du téndén sapak wa Maria Jisas kéraalén, Betlehemmba. Betlehem Judiamba wa téndékwa. Kéraaléka kukmba de nyétmba tékwa kunngé vékusékngwa dunyansé nyaayalamba yaae Jerusalemét yéndarén. Ye saambake wandarén, “Nané nyaayalamba te nyétmba tékwa kulé kunét vénanén. Véte vékuséknanén. Yéku laku nyaan wa yaalan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dé Juda du dakwana néma du tékandékwa. Wunga vékusékte kunét vétake wa déké yaanangwa, dat kwaati séte waandé daaké. Dé yamba dé ro?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wunga wandaka néma du Herot vékutake rakarka yate wandén, “Kalmu wani nyaan kukmba wuna taalé kéraaké dé?” Wunga watake wani muséké kalik yandén. Yandéka Jerusalemmba tékwa akwi du dakwa de wani muséké vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot kalik yate wandéka de Gotna gaamba jémbaa yakwa dunyanna akwi néma dunyan, Moses wan apakundiké vékusékngwa dunyan, wunga yaandarén. Yaandaka det waatakundén, “Got wan du Krais yamba yaalaké dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wunga wandéka dat wandarén, “Judiamba tékwa gaayé, Betlehemmba wa yaalakandékwa. Wani muséké talimba Gotna yémba kundi kwayétan du nak Gotna nyéngaamba Gotna kundi anga viyaatakandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Guné Betlehemmba tékwa du dakwa, ma véku. Kukmba guna gaayé du nak néma du tékandékwa. Téte wuna du dakwa Israelké yékunmba vékandékwa. Véké yandékwanngé vékulakate, wa de guna makalkéri gaayé Judiana képmaamba tékwa gaayé Betlehemngé katik waké daré, ‘Wan baka gaayé wa.’ Wunga wakapuk yate, guna gaayéké wakandakwa, ‘Néma gaayé wa.’ Wunga viyaatakandén Gotna nyéngaamba.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Judana néma du Herot wani kundi vékutake, nyaayalamba yaan dunyansé déké yaandarénngé wandén. Wandéka yaandaka nak du vékukapuk yamuké dele yakélak kundi bulndarén. Bulte det waatakundén, “Yani sapak dé wani kun nyétmba baasnyé ye yaalak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wunga waatakundéka dat wandaka wandén, “Betlehemét ma yéngunék. Ye kurkasale ma waak wani nyaanngé. Waake vétake waambule yaae guné wunat waké ya. Wangunu wuné waak ye kwaati séte déké waandé daakawutékwa.” Wunga wate dé det paapu yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herot wunga wandéka vékutake yéndarén. Yéte nyaayalamba talimba véndarén kun nakapuk véndarén. Wani kun nyétmba taale yéténdéka wa de déku kukmba yén. Ye wani kun nyaan kwaan gaamba anjoré téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Téndéka véte yéku mawulé vékute mawulé tawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yate gaamba wulaae véndarén wani nyaan déku aasa Mariale rambéréka. Vétake kwaati séte waandé daandarén dat. Yate deku wutmba tén musé naangndarén. Naange dat yéku musé kwayéndarén. Gol matu, yaa yamungandaka yéku yaama yakwa musé, yéku yaama yakwa gu, wunga kwayéndarén dat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kwayétake yare kwaae yéngan kwaandarén. Kwaandaka Got det wandén, “Guné Herotké waambule yéké yambakate.” Naandén. Wunga wandéka vélérkiyaae waarape de nak yaambumba waambule yéndarén deku gaayét. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wani dunyansé waambule yéndaka Josep kwaandéka Néman Du Gotna kundi kure gaayakwa du nak gaaye dat yénganmba wandén, “Herot wani nyaan waake vétake dé viyaakandékwa. Wunga yandékwanngé méné ma waarape wani nyaan déku aasale kure yéménék. Isipét ma yaange yé. Yaange ye wani taalémba ma yarépékangunék. Kukmba gunat wawutu waambule yaangunék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wunga wandéka Josep bari vélérkiyaae waarape wani nyaan déku aasale kure yaange yéndén. Nyéndéngan wa bét kure yaange yéndén Isipét. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ye saambake Isipmba yaréndarén. Herot kiyaandu deku gaayét nakapuk waambule yéké yandakwanngé talimba yatéte Gotna yémba kundi kwayétan du viyaatakan kundi wa sékérékén. Wani du Néman Du Gotna kundi vékute wani kundi Gotna nyéngaamba anga viyaatakandén: Wuna nyaan Isipmba yaténdu wuné dat waawutu Isip yaasékatake waambule yaakandékwa gaayét. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Judana néma du Herot Jerusalemmba rate nyaayalamba yaan dunyansé déké waambule yéndarénngé kaavépatindén. Kaavépatiye néma rakarka yate wandén, “Wunat paapu a yandarén.” Wunga watake déku mawuléké wandén, “Nyaayalamba yaan dunyansé wandarén, ‘Kwaaré vétik pulak talimba wa wani nyétmba tékwa kun baasnyé ye vénanén.’ Naandarén.” Wunga watake deku kundiké vékulakate déku waariyakwa dunyansat wandén, “Guné Betlehemét ye, Betlehemale tékwa taalat waak ye akwi dunyanngu nyaan ma viyaawuréngunék. Kwaaré vétik yan nyambalésé, kwaaré nakurak yan nyambalésé, kéraandarén kulé nyambalésé waak, de akwi ma viyaawuréngunu.” Naandén. Wunga wandéka ye wani nyambalésé akwi viyaawuréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Talimba Gotna yémba kundi kwayétan du nak, déku yé Jeremaia, wa ani kundi Gotna nyéngaamba viyaatakandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramamba asa du dakwa wa némaanmba géraakwa. Wani gaayémba némaanmba géraandakwa. Reselna gwaal waaranga maandéka bakamuna nyambalésé wa kiyaawuran. Kiyaawuréndaka wa deku nyambaléké géraandakwa. Deké néma sémbéraa yate géraandakwa. Herot wandéka déku waariyakwa dunyan Betlehemmba nyambalésé viyaawuréndarén sapak Jeremaia viyaatakan kundi wa sékérékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kukmba Herot kiyaan. Kiyaandéka Josep déku taakwa, nyaanale Isipmba yaréndarén. Wamba yare Josep yéngan kwaandéka Néman Du Gotna kundi kure gaayakwa du gaaye Josepét wandén, ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wani nyaanét viyaandékngé mawulé yan du wa kiyaan. Bulaa méné ma waarape wani nyaan déku aasale kure Israelét nakapuk waambule yéngunék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wunga wandéka Josep vélérkiyaae waarape wani nyaan déku aasale kure Israelét waambule yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep wani taalémba saambake vékundén, Arkelaus déku aapa Herotna taalé kéraae Judia du dakwana néma du téndéka. Vékutake Judiamba ramuké wup yandén. Ye gaan kwaandéka Got dat yénganmba wandéka wani nyaan déku aasale kure Galilit yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ye Nasaretmba yaréndarén. Josep, Maria, Jisas wani gaayémba yaréndaka Gotna yémba kundi kwayétan dunyan talimba viyaatakan kundi wa sékérékén. Jisaské nyéngaamba anga viyaatakandarén: Déké wakandakwa, wan Nasaret du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wani sapak baptais kwayékwa du Jon du yarékapuk yakwa Judiana taalémba baasnyé ye Gotna kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wani taalat yaan du dakwat anga wandén, “Got néma du rate gunéké véké yandékwa sapak a yaakwa. Yaandékwanngé vékulakate guné Gotna kémba téké mawulé yate kapérandi musat ma kuk kwayéngunék.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Talimba Gotna yémba kundi kwayétan du nak déku yé Aisaia Jonngé Gotna nyéngaamba anga viyaatakandén: Du nak waandékwa du yarékapuk taalémba. Waate anga wandékwa, “Néman Duna yaambu ma kutngunék. Kutngunu yaambu yékunmba kwaakandékwa déké.” Naandékwa. Jonna aasa dé kéraakapuk yarélén sapak wa Aisaia wani kundi viyaatakandén. Viyaatakandéka kukmba Jon yaae du dakwat wandén, deku mawulé yékunmba téndu de Jisas yaaké yandékwanngé yékunmba vékulakandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon yéku laplap, yéku kakémuké yamba vékulakandékwe. Dé kamelna yéwit yandarén laplap gindén. Giye dé bulmakau sépémba yandarén let gindén. Dé japét kandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Saam gék pulak musé julipte kandén. Dé Gotna kundi wandéka Jerusalemmba tékwa du dakwa, Judiana taalémba tékwa du dakwa, Jordan kaambélé yékwanmba tékwa du dakwa wunga némaamba du dakwa wa yéndarén déké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ye yandarén kapérandi muséké kalik yate wandaka dé det Gotna yémba baptais kwayéndén Jordan kaambélémba. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juda dunyansé deku néma du waak asapéri wa yéndarén, Jon Gotna yémba det baptais kwayéndénngé. Farisi dunyan, Sadyusi dunyan, de wunga yéndarén. Yéndaka Jon det waarute wandén, “Guné kapérandi mawulé vékukwa dunyansé wa. Got néma kot vékute néma du raké yandékwa nyaa a yaakwa. Wani nyaa Got du dakwa yandarén kapérandi muséké rakarka yakandékwa. Wani nyaaké vékulakate guné dunyan yaawi tundaka yaange yékwa kapérandi kaambe pulak a wunéké yaange yaangunéngwa. Wunéké yaambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Taale guné yangunén kapérandi musé yaasékatake yéku musé male ma yangunék. Yangunu nak du dakwa véte wakandakwa, ‘De kapérandi musé yaasékatake bulaa yéku musé wa yandakwa.’ Wunga wakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Guné guna mawulémba anga waké yamarék, ‘Nané Abrahamna gwaal waaranga maandéka bakamu a ténangwa. Dé Gotna ménimba yéku musé yakwa du téndén pulak nané waak Gotna ménimba yéku musé yakwa du a ténangwa.’ Wunga wate paapu wa yangunéngwa. Guné yéku musé yamba yangunéngwe wa. Got mawulé yamunaae dé wandu ani matu du ye de Abrahamna gwaal waaranga maandéka bakamu pulak tékandakwa. Abrahamna gwaal waaranga maandéka bakamu téngunéngwanngé Got yamba vékulakandékwe wa. Yangunéngwa muséké wa vékulakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Gwaaménja kundi nak wakawutékwa. Du sék vaakukapuk yakwa miyéké vékulakate kwandang kéraae wani miyé vélékandékwa. Véle yaamba tukandékwa. Bulaa wani gwaaménja kundiké ma vékulaka. Bulaa Got déku kundi vékukapuk yakwa du dakwat yandarén kapérandi musé yakata-kandékwa. Yakatandu de yaa yaanpékatékwa taalat yékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Guné guna kapérandi mawulé yaasékangunu wuné gunat Gotna yémba baptais kwayékawutékwa. Wuna kukmba yaaké yakwa du wan dé néma du wa. Wuné baka du a téwutékwa. Déku mayé apa wa wuna mayé apat taalékéran. Yénga pulak déku jémbaa yaké wuté, baka du téwutékwanmba? Dé néma du randéka wuné déku musé déké kure yéké yapatiwutékwa. Wuné baka du a téwutékwa. Wuna kukmba yaaké yakwa du Gotna Yaamambi gunat kwayékandékwa. Guna kapérandi musé kéraae yaamba tukandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Du wit kéraae yéku wit sék kéraaké gérindakwa. Gériye yéku wit sék gaamba taakate apa vaanjatindakwa. Yandakwa pulak wuna kukmba yaaké yakwa du wunga yakandékwa. Dé déku du dakwat kéraae kure ye déku gaayémba taakate kapérandi musé yan du dakwat kéraae yaanpékatékwa yaamba vaanjanda-kandékwa.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wani sapak Jisas Galili taakatake Jordan kaambélat yéndén. Jon dat Gotna yémba baptais kwayéndénngé wa yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ye saambakndéka Jon kalik yate wandén, “Méné néma du wa raménéngwa. Wuné baka du a téwutékwa. Kamuké méné wunéké yaau, wuné ménat baptais kwayéwuténngé? Méné Gotna yémba wunat baptais kwayéménu wan yékun wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wunga wandéka Jisas wa wan, “Yamba wa. Méné wunat baptais ma kwayé. Wunga yate wan Got wandén pulak wa yakaménéngwa.” Wunga wandéka yi naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yi naatake Jisasét baptais kwayéndéka dé bari gumba yaalandén. Yaalandéka nyét kepukandéka véndén Gotna Yaamambi nyaamiyo pulak déké gaayandéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gaayandéka Gotna gaayémba waan kundi nak anga waandén, “An wuna nyaan wa. Déké wuné néma mawulé yawutékwa. Déké wuna mawulé yékun yandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon Jisasét baptais kwayéndéka Gotna Yaamambi wa Jisasét kéraae kure yéndén du yarékapuk taalat. Satan Jisasna mawulé yakwe véndénngé wa Gotna Yaamambi dé wani taalat kéraae kurindén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kure yéndéka Jisas wani taalémba yaréte kakému kulak yamba kandékwe wa. Némaamba (40) gaan nyaa baka randén. Re kukmba kaandéké kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yandéka Satan yaae dat wandén, “Méné anga waménéngwa, ‘Wuné Gotna nyaan a.’ Wunga wate bulaa wani muséké wunat ma wakwasnyéménu. Ma waménu de ani matu waalakwe kakému yandaru. Wunga yandu ménéké vésékngawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wunga wandéka wandén, “Yamba wa. Wani muséké ani kundi Gotna nyéngaamba kwaandékwa: Du dakwa kakémuké male vékulakate de yékunmba katik téké daré. De Gotna kundi vékundaru deku mawulé yékunmba téndu de yékunmba tékandakwa. Wani kundi vékute matu kakému yandénngé wuné katik waké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas wani kundi wandéka Satan Jisas kéraae kure yéndén Jerusalemét. Kure waare dat Gotna kundi bulndakwa néma gaana saambunmba anjoré taakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Taakatake dat wandén, “Méné anga waménéngwa, ‘Wuné Gotna nyaan a.’ Wunga wate méné ma késéke daawuli. Wani muséké ani kundi Gotna nyéngaamba kwaandékwa: Got déku kundi kure gaayakwa dunyansat wandu de ménéké yékunmba vékandakwa. Véndaru méné deku taambamba rate ména maan matumba katik viyaaké méné. Méné wani kundi vékute késéke daawuliye yékunmba raménu akwi du dakwa véte vékusék-ngandakwa. Méné Gotna nyaan wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wunga wandéka Jisas wa wan, “Yamba wa. Wani muséké ani kundi Gotna nyéngaamba kwaandékwa: Got wan ména Néman Du wa. Dé mayé apa yate ménat yékun yandénngé waangété yakwa du pulak katik yaké méné. Wani kundi vékute wuné katik késéke daawuliké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jisas wani kundi wandéka Satan Jisasét kéraae kure waaréndén néma némbat. Kure waare ani képmaamba tékwa akwi gaayé, wani gaayémba tékwa akwi yéku musé waak Jisasét wakwasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wakwasnyétake wandén, “Méné kwaati séte wunéké waandé daate wuna yé kavérékménu, wuné wani gaayé, wamba tékéskwa musé waak kwayéwutu méné deké néma du rakaménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wunga wandéka wandén, “Méno, Satan, ma yaange yé. Ani kundi Gotna nyéngaamba wa kwaakwa: Ména néma du nakurak Got male wa. Méné déké waandé daate dat ma waataku. Déku yémba male ma kavérék. Wani kundi vékute wuné ménéké katik waandé daaké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wunga wandéka Satan Jisas yaasékatake yéndén. Yéndéka Gotna kundi kure gaayakwa dunyan gaaye Jisasét yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Baptais kwayékwa du Jon wani képmaana néma du Herot kapérandi musé yandéka dat waarundéka wa Herot wandéka Jon kalapusmba taakandarén. Taakandaka kwaandéka Jisas wani muséké kundi vékutake Galilit yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ye déku gaayé Nasaret taakatake Kaperneamét yéndén. Wani gaayé Galili néma gu kwaawu nak sakumba téndén. Wani gaayé Sebulun ambét Naptalina taalémba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas wani gaayét ye Gotna kundi kwayéndéka talimba yatéte Gotna yémba kundi kwayétan du déku yé Aisaia, déku kundi wa sékérékén. Aisaia talimba ani kundi Gotna nyéngaamba viyaatakandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulunna taalé Naptalina taalé waak bét solwarat yéndakwa yaambumba wa témbérékwa. Jordan kaambéléna nak sakumba témbérékwa. Galilimba wan nak gaayémba yaan némaamba du dakwa wa téndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wamba tékwa du dakwa Satanna taambamba téte ganngumba wa téndakwa. Téte lambiyakngé yate de néma yaa vérékte kaalékwa pulak yaandéka wa véndarén. Ve yékunmba vékulakamunaae wa de nyaamba tékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas wani taalat ye saambake dé baasnyé ye Gotna kundi kwayéndén. Kwayéte wandén, “Got néma du rate gunéké véké yandékwa sapak a yaae kwambalikwa. Yaandékwanngé vékulakate guné guna kapérandi mawulé ma yaasékangunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Galili néma gu kwaawuna nak saku wutépmba yététe véndén Saimon, déku nak yé Pita, déku waayéka Andrule bérku jémbaa yarémbéréka. Bét akwi nyaa yambérén pulak wani néma gu kwaawumba aaswut taawurémbérén gukwamiké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Vétake bérét wandén, “Béné ma yaa wunale. Yaambénu wuné bénat nak jémbaaké yakwasnyé-kawutékwa. Yakwasnyéwutu béné gukwami kutmbénén pulak du dakwa kéraakambénéngwa. Kéraambénu de wuna kundi vékukandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wunga wandéka bari aaswut yaasékatake waarape dale yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas ayélap yépulak naae véndén Sebedina nyaan vétik Jems ambét déku waayéka Jon bérku aapa Sebediale botmba randaka. Rate aaswut kururéréndaka Jisas bérét wandén, dale yémbérénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wandéka bét bérku aapa botmba randéka yaasékatake Jisasale yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas yeyé yaayate Galilimba tékwa akwi gaayét yéndén. Ye saambake Gotna kundi bulndakwa gaamba rate du dakwat yakwasnyéndén, Gotna jémbaaké. Akwi du dakwat kundi kwayéndén, Got néma du rate déku du dakwaké yékunmba véké yandékwanngé. Baat yakwa du dakwa, sépémaalé kapére yan du dakwat waak kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wunga yandéka de Siria provinsmba tékwa akwi taalémba déké kundi saapé yéndarén. Saapé yéndaka de wani kundi vékute némaamba du dakwa wa déké kure yéndarén. Baat yakwa du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalé, kutakwa kulure kure tén du dakwa nyambalé, méningan yandéka vaakétte bérumbéru yakwa du dakwa nyambalé, maan kapére yandéka yékapuk yakwa du dakwa nyambalé, wani du dakwa nyambalat wa kure yéndarén Jisaské. Kure yéndaka det kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kururéndéka némaamba du dakwa wa dale yéndarén. Galilimba yaan du dakwa, Dekapolismba yaan du dakwa, Jerusalemmba yaan du dakwa, Judiamba yaan du dakwa, Jordan kaambélé ani aangé sakumba yaan du dakwa, dale wunga yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Némaamba du dakwa yaandaka Jisas vétake némbat nak waaréndén. Waare randéka déku dunyan déké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yaandaka det Gotna jémbaaké baasnyé ye yakwasnyéndén. Yakwasnyéte anga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Du dakwa ras deku mayé apaké vékulakakapuk yate Gotna mayé apaké vékulakate wa déku jémbaa yandakwa. Wani du dakwa Gotna kémba téndaka dé néma du rate deké yékunmba véndékwa. Véndékwanngé de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Du dakwa ras géraandakwa. Wani du dakwana mawulé Got yékun yakandékwa. Yakwate yandékwanngé de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Du dakwa ras deku yé kavérékngapuk yate nak du dakwat waarukapuk yate yékunmba yaténdakwa. Wani du dakwat Got yékun yandu de ani képmaamba néma du dakwa tépékaa-kandakwa. Tépékaaké yandakwanngé de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Du dakwa ras Gorké vékulakate yéku mawulé vékute yéku musé male yaké néma mawulé yandakwa. Kaandéké kiyaakwa du kakému kaké néma mawulé yandakwa pulak, wa de yéku musé male yaké néma mawulé yandakwa. Wani du dakwat Got yékunmba yandu deku mawulé yékunmba téndu de yékunmba tépékaa-kandakwa. Tépékaaké yandakwanngé de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Du dakwa ras nak du dakwaké sémbéraa yandakwa. Wani du dakwaké Got sémbéraa yakandékwa. Sémbéraa yandékwanngé de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Du dakwa ras deku mawulémba yéku mawulé male téndékwa. Wani du dakwa Gorét véte dale yékunmba tépékaa-kandakwa. Tépékaaké yandakwanngé vékulakate de mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Du dakwa ras nak du dakwa waaru waariyandaka de nyéndémba téndakwa. Téndaka de yamba waaru waariyandakwe wa. Wani nyéndémba tékwa du dakwaké Got wakandékwa, ‘De wuna nyambalé wa.’ Dé det wunga wandénngé vékulakate wani nyéndémba tékwa du dakwa mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Du dakwa ras Gotna jémbaa yandaka nak du dakwa kalik yate det yaavan kutndakwa. Yaavan kutndakwa du dakwa Gotna kémba téndaka Got néma du rate deké yékunmba véndékwa. Véndékwanngé vékulakate mawulé tawulé yénga yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ma véku. Guné wuna jémbaamba yaalangunén wa. Du ras wunéké kalik yate gunat kenakte kapérandi musé yate gunéké papukundi wandaru, guné mawulé tawulé ma yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Talimba de Gotna yémba kundi kwayétan dunyansat wunga yaavan kutndarén. Det yaavan kutndarénngé vékulakate gunat wunga yaavan kutndaru, guné mawulé tawulé ma yangunék. Kukmba Got gunat yékun yandu guné dale yékunmba tépékaa-kangunéngwa. Tépékaaké yangunéngwanngé guné yéku mawulé vékute mawulé tawulé ma yangunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wani kundi watake Jisas anga wandén: “Ani gwaaménja kundi ma véku. Dakwa de sol taakandakwa, kakému résék yandénngé. Sol résék yakapuk yandu, yénga pulak yandaru nakapuk résék yaké dé? Yamba wa. Nakapuk katik résék yaké dé. Yandu kakémumba katik yaasnyéké daré. De wani sol baka vaanjati-kandakwa. Bulaa wani kundiké ma vékulaka. Guné, wuna du, guné kakémumba yaasnyéndakwa sol pulak wa. Guné nak du dakwat yékun yangunu de kapérandi musé nakapuk katik yaké daré. Guné nak du dakwat yékun yakapuk yangunu résék yakapuk yakwa sol baka vaanjatindakwa pulak, Got gunat vaanjati-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Guné, wuna du, guné vérékngwa téwaayé pulak wa téngunéngwa. Téngunénga nak du dakwa gunat véndakwa. Guné némbumba tékwa gaayé pulak wa téngunéngwa. Téngunénga nak du dakwa guné yékunmba vésékndakwa, némbumba tékwa gaayét yékunmba véndakwa pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Ani gwaaménja kundi ma véku. Du téwaayé véréke kure yaae sapngutaka-ndarén aké arulamba daré taako kapuk? Yamba wa. De jaambétakumba taakandakwa. Taakandaka wamba rakwa akwi du dakwa yékunmba véndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bulaa wani kundiké ma vékulaka. Guné wani téwaayé pulak wa téngunéngwa. Guné Gorké yéku jémbaa ma yangunék. Wani jémbaa paakuké yambak. Du dakwana ménimba ma yangunék. Yangunu kurkale vésékngandakwa. Vésékte anjorémba rakwa du guna aapa Gotna yé kavérék-ngandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Guné anga waké yamarék, ‘Jisas Moses wan apakundiké kuk kwayéké wa yaandén. Talimba yatéte Gotna yémba kundi kwayétan dunyanna kundiké kuk kwayéké wa Jisas yaandén.’ Wunga waké yambakate. Moses wan apakundi Gotna yémba kundi kwayétan dunyanna kundi waak yékunmba vékute wandarén pulak yaké wa yaawutén. Guné wani kundiké yékunmba vékusékngunénngé wa yaawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ani kundi ma véku. Nyét képmaa wayéka téndu Moses wan akwi apakundi rapéka-kandékwa. Randu guné wani kundi vékute wandékwa pulak ma yangunék. Kukmba nyét képmaa késkandékwa. Késndu Moses wan apakundi waak késkandékwa. Yi wan wanana wa, gunat wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Du ras Moses wan apakundi nakngé anga wamunaandaru, ‘Wani apakundi wan makal kundi wa. Nané wani kundi yaasékananu wan yékun wa.’ Wunga wandaru, Got néma du rate deké wakandékwa, ‘Wan baka du wa. De wuna taambamba baka randakwa. Deku yé katik kavérékngé wuté.’ Wunga wandu de nak du wani apakundi vékute wandékwa pulak yate anga wamunaandaru, ‘Wani apakundi akwi yékunmba ma vékukwak. Kundi nak katik yaasékaké nané.’ Wunga wandaru Got néma du rate deké wakandékwa, ‘Wan de néma du wa. De wuna taambamba yékunmba randakwa. Deku yé kavérék-ngawutékwa.’ Wunga wakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Guné Moses wan apakundiké yékunmba vékusékngunénngé wa gunat wawutékwa. Apakundiké vékusékngwa dunyansé, Farisi dunyansé waak, de Moses wan apakundi akwi yékunmba vékute wandékwa pulak yaké de néma jémbaa yandakwa. Yandaka nak du det véte wandakwa, ‘De yéku musé yakwa du wa téndakwa.’ Wunga wandaka Got deku mawulé vékusékte deké wandékwa, ‘Yamba yé wa.’ Naandékwa. Wunga wandéka gunat wawutékwa. Guné yéku mawulé vékute yéku musé ma yangunék. Yangunu guna yéku yapaté deku yapatat taalékérandu, guné Gotna kémba yaalakangunéngwa. Guna yéku yapaté deku yapatat taalékérakapuk yandu guné Gotna kémba katik yaalaké guné.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wani kundi watake det anga wandén: “Talimba tan du ani kundi wandaka wa vékungunén. Anga wandarén, ‘Guné du dakwat viyaandékngé yambak. Guné det viyaandékngunu, guné kot vékukwa néma duké kure yéndaru dé wani kapérandi muséké gunat yakata-kandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wunga wandaka bulaa wuné nak kundi gunat wawutékwa. Ma véku. Du ras nak duwat rakarka yamunaandaru, Got wani kapérandi muséké det yakata-kandékwa. Du ras nak duwat waarute anga wamunaandaru, ‘Guné waangété du wa.’ Wunga wandaru, wa Got kot vékukwa néma du rate wani kapérandi muséké wunga wakwa duwat némaamba yakata-kandékwa. Du ras nak duwat némaamba waarute anga wamunaandaru, ‘Guné baka gandéndu du wa. Kapérandi taalat yékangunéngwa.’ Wunga wandaru, wa Got wandu wunga wakwa du yaa yaanpékatékwa taalat yékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Wani muséké vékulakate guné nak nak anga ma yangunék. Guné Gorké musé kwayéké yate, déké musé kwayéndakwa jaambé tékwanmba téte, nak du dakwat yangunén kapérandi muséké vékulakamunaae, wa taale Gorké kwayéké yangunéngwa musé jaambéna nak sakumba taakatake, wani du dakwaké bari ma yéngunék. Ye dele kundi bule dele nakurakmawulé yate dele kurkale téngunu. Te kukmba waambule yaae guné taakangunén musé Gorét kwayéké ya. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Du ras gunat kotimngé yamunaandaru, guné dele sékét yaambumba yététe dele kayéndéng kundi bule ma yawuréngunék. Nakurakmawulé ma yangunék. Guné dele wani kundi bule yawurékapuk yamunaae, kalmu guné kot vékukwa néma duké kure yéndaru dé wandu guné kalapusmba taakaké daré? Taakandaru guné wamba kwaapéka-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kot vékukwa néma du wandén akwi yéwaa gunat waarun duké kwayéngunu, wani sapak male wa kalapus yaasékatake yaale baka yékunmba yékangunéngwa. Yi wan wanana wa, gunat wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Talimba tan du ani kundi wandaka wa vékungunén. Anga wandarén, ‘Guné nak duna taakwale kapérandi musé yaké yamarék.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wunga wandaka bulaa wuné gunat anga wawutékwa. Du, nak duna taakwat véte léké jaambindan, wa déku mawulémba kapéremusé wa yandén. Yandéka déku mawulé wa kapére yakwa. Dé baka lat véte léké jaambiye wa kapérandi musé yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Guné guna yékutuwa sakumba tékwa méni, nak duna taakwat véte, dele kapérandi musé yaké jaambimunaate, wani méni ma pékwe vaanjatingunék. Guna nakurak méni male téndu wani kapérandi musé yakapuk yate kukmba Gotna gaayét yékangunéngwa, wan yékun wa. Guna méni vétik téndu wani kapérandi musé yangunu Got wandu guné kapérandi taalat yékangunéngwa, wan kapére wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Guné guna yékutuwa taambat kapérandi musé yaké yamunaate, wani taamba ma sékwe vaanjatingunék. Guna nakurak taamba male téndu wani kapérandi musé yakapuk ye kukmba Gotna gaayét yékangunéngwa, wan yékun wa. Guna taamba vétik téndu wani kapérandi musé yatake kukmba kapérandi taalat yékangunéngwa, wan kapére wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Talimba yatan du ani kundi waak wandaka wa vékungunén. Anga wandarén, ‘Du nak déku taakwa kewuréndu yélénngé mawulé ye, wa dé wani muséké nyéngaa nak ma viyaandu. Viyaae lat kwayéndu wani nyéngaa kure yékalékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wunga wandaka bulaa wuné gunat anga wawutékwa. Taakwa nak duké yékapuk yate nak duwale kapérandi musé yakapuk yalu, léku du lat dé yaasékatake yélénngé wamunaandu, wan kapérandi musé wa. Lé dé yaasékatake yélénngé wandu lé ye nak du kumbimunaalu, wa lé wani kumbilékwa duwale kapérandi musé wa yambérékwa. Taale kumbilén du kapéremusé yandéka bét waak kapéremusé wa yambérékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wani kundi watake Jisas anga wandén: “Talimba yatan dunyan ani kundi waak wandaka wa vékungunén. Anga wandarén, ‘Guné jémbaa nak yaké wate guna kundit apa yate Néman Du Gotna yémba wamunaae, wa guné wani jémbaa ma yangunék. Wani jémbaa katik yaasékaké guné.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wunga wandaka bulaa wuné gunat anga wawutékwa. Guné guna kundit apamama yamuké waké yamarék. Wani jémbaa baka ma yangunék. Guné Gotna gaayéna yémba waké yamarék. Got rakwa taalé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Képmaana yémba waké yamarék. Got képmaamba déku maan vaakindékwa. Guné Jerusalemna yémba waké yamarék. Nana Néman Du Gotna taalé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Guné guna maakamba waké yamarék. Guné gélé némbé waama yandu waama némbé gélé yandénngé yaké yapatingunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De gunat jémbaaké waatakundaru guné yi naae, anga ma wangunék, ‘Yi, wani jémbaa yakanangwa.’ Wunga yamuké kalik ye, anga ma wangunék, ‘Yamba wa. Wani jémbaa katik yaké nané.’ Wunga ma wangunu. Wunga yaak wa. Nak kundi nak waké yamarék. Guna kundit mayé apa kwayémuké deku yémba waké yamarék. Guna kundit mayé apa kwayémuké deku yémba wamunaae, wa guné Satanna kundi vékute wandékwa pulak wa yangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Talimba yatan du ani kundi wandaka wa vékungunén. Anga wandarén, ‘Du vétik waariyate du nak, nak duna méni viyaapékundu dé yakatamuké we viyaapékwan duwat déku méni viyaapéku-kandékwa. Du vétik waariyate du nak, nak duna némbi nak viyaangérindu dé yakatamuké we wani duwat déku némbi nak viyaangéri-kandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wunga wandaka bulaa wuné gunat anga wawutékwa. Du ras gunat kapérandi musé yandaru, guné det kapérandi musé yakataké yamarék. Du ras guna yékutuwa saku saawimba viyaandaru, guné yakataké yamarék. Waalakwe baka téte guna akituwa saku saawi ma kwayé viyaandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Du ras guna laplap kéraaké, gunat kotimndaru, kot vékukwa néma du wani muséké yi naandu guné kwayéte laplap nak waak det ma kwayéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Du ras guné dele yéte deku musé kwemaka yaambumba kure yéngunénngé apamama yate wandaru, guné dele yéte deku musé sékaa yaambumba ma kure yéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Du ras gunat muséké waatakundaru, guné wani musé det ma kwayéngunék. Du ras guna muséké mawulé ye gunémba kéraae gunat wani musé kukmba kwayékataké wandaru, wani musé det ma kwayéngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Talimba yatan dunyan ani kundi wandaka wa vékungunén. Anga wandarén, ‘Guné guna du dakwaké néma mawulé yate guna maamaké ma kalik yangunék.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wunga wandaka bulaa wuné gunat anga wawutékwa. Guné guna maamaké ma néma mawulé yangunék. Du ras gunat kapérandi musé yandaru, guné Gorét ma waatakungunék, dé det yékun yamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Guné wunga yate, wa anjorémba rakwa du guna aapa Gorale wa nakurakmawulé yangunéngwa. Yate guné déku nyambalé wa yaténgunéngwa. Got nakurak jémbaa male yandékwa akwi du dakwaké. Got wandéka nyaa vékwa. Véndéka kakému yékunmba yaalandékwa, yéku musé yakwa du dakwana képmaamba, kapérandi musé yakwa du dakwana képmaamba waak. Got wandéka maas viyaakwa. Viyaandéka kakému yékunmba yaalandékwa, yéku musé yakwa du dakwana képmaamba, kapérandi musé yakwa du dakwana képmaamba waak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Takis kéraakwa duké wangunéngwa, ‘De kapérandi musé yakwa du wa.’ Wunga wangunéngwa du de deku du dakwaké néma mawulé yandakwa. Guné de yakwa pulak, guna du dakwaké male néma mawulé yangunu, wa Got gunat katik yékun yaké dé. Gunéké néma mawulé yakwa du dakwa, gunéké kalik yakwa du dakwa, akwi du dakwaké waak ma néma mawulé yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Gotna kundi vékukapuk yakwa du dakwa de deku du dakwaké male mawulé yate dele kundi bulndakwa. Guné de yakwa pulak, guna du dakwaké male mawulé yate, dele kundi bulte, wa guné yénga pulak yékun yaké guné? Akwi du dakwaké mawulé yate, dele kundi ma bulngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Anjorémba rakwa du guna aapa dé yéku musé male yapékakwa du wa randékwa. Guné dé rakwa pulak yéku musé male yapékakwa du ma yaténgunék.” Jisas wunga wandén déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas kundi ras waak anga wandén: “Guné Gorké yéku jémbaa yate déké male ma vékulakangunék. Guné Gorké yéku jémbaa yate nak du dakwa wunga yangunu vétake guna yé kavérékndarénngé mawulé yate deku ménimba wani jémbaa yate, wa gunékét gunéké wa vékulakangunéngwa. Wunga vékulakate deku ménimba yangunu, wa anjorémba rakwa du guna aapa Got kukmba guna yé katik kavérékngé dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","“Paapu yakwa du ras deku yé kavérékte Gotna kundi bulndakwa gaamba wulaae téte, yaambumba waak téte musé asé kapuk du dakwat musé kwayéndakwa. Némaamba du dakwa véte wani paapu yakwa duna yé kavérékndarénngé, wa de paapu yakwa du musé asé kapuk du dakwat musé kwayéndakwa. Wunga kwayéndaka némaamba du dakwa véte wani paapu yakwa duna yé kavérékndakwa. Kukmba Got wani paapu yakwa duna yé katik kavérékngé dé, némaamba du dakwa deku yé bulaa kavérék-ndakwanmba. Yi wan wanana wa, gunat wawutékwa. Guné paapu yakwa du kwayékwa pulak kwayéké yamarék. Guné musé asékapuk du dakwat musé kwayémuké, nak du dakwat wani muséké waké yamarék. Yakélak ma kwayéngunék. Wunga kwayéngunu nak du dakwa wani muséké vékusékngapuk yandaru gunale tékwa du dakwa waak wani muséké katik vékusékngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Guné wunga yakélak kwayéngunu anjorémba rakwa du guna aapa Got vékandékwa. Vétake kukmba dé yangunén yéku musé kwayékata-kandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Paapu yakwa du Gorét waatakuké, de Gotna kundi bulndakwa gaamba wulaae téte, yaambumba waak téte Gorét waatakundakwa. Némaamba du dakwa det véndarénngé wa wamba Gorét waatakundakwa. Némaamba du dakwa det véte deku yé kavérékndarénngé wa wamba Gorét waatakundakwa. Wunga yandaka némaamba du dakwa deku yé kavérékndakwa. Wunga yate yandarén yéku musé wa kaatandakwa. Paapu yakwa du wani du dakwamba yéku musé wa kéraandarén. Yi wan wanana wa. Gunat a wawutékwa. Kukmba Got yandarén yéku musé katik kwayékataké dé. Guné paapu yakwa du Gorét waatakundakwa pulak Gorét waatakuké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Guné Gorale kundi bulké yate guné nak nak ma guna gaamba wulaae pété kurkale tépe kapmang rate dale kundi bulngunék. Bulngunu guna aapa Got wunga rate bulngunu véte guna kundi vékukandékwa. Dé yamba vénangwe wa. Dé guna kundi vékutake kukmba yangunén yéku musé kwayékata-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Gorké vékusékngapuk yakwa du dakwa anga wandakwa, ‘Nané némaamba kundi bulte nana néma duwat waatakunanu vékukandékwa.’ Wunga wate némaamba baka kundi baka bulte waatakundakwa. Guné némaamba baka kundi bulndakwa pulak guné Gorale bulké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Guné dat waatakukapuk yangunén sapak wa guna aapa Got yapatingunéngwa muséké wa vékusékndén. Vékusékndénngé vékulakate guné dale kundi bulte némaamba baka kundi bulké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Guné dat ma anga waatakungunék: Nana aapa, méné ména gaayémba raménéngwa. Nané ména yé kavérékngé mawulé yanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Méné néma du rate akwi du dakwaké yékunmba véménénngé mawulé yanangwa. Ména gaayémba rakwa du ména kundi yékunmba vékundakwa pulak, nané ani képmaamba tékwa du dakwa waak ména kundi yékunmba vékuké mawulé yanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ani nyaa yapatinangwa kakému tiyaaménénngé ménat waatakunangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Du dakwa nanat kapérandi musé yandaka nané wani muséké nakapuk yamba vékulakanangwe wa. Yananu méné yananén kapérandi musé yasnyéputiye méné wani muséké nakapuk vékulakaké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Méné nanat yékun yaménu nané kapérandi musé yakwa duna kundi vékukapuk yate, kapérandi musé nakapuk katik yaké nané. Wunga ménat waatakunangwa. Méné nané akwi du dakwaké yékunmba vépékaaréte apa tapa yapékate néma du rapéka-kaménéngwa apapu apapu. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Guné wani kundiké ma vékulaka. Guné nak du dakwa gunat yandarén kapérandi muséké vékulakakapuk yangunu, anjorémba rakwa du guna aapa Got yangunén kapérandi musé yasnyéputiye wani muséké nakapuk katik vékulakaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Guné nak du dakwa gunat yandarén kapérandi muséké vékulaka-pékaréte det yakataké mawulé yangunu, wa guna aapa Got yangunén kapérandi muséké vékulaka-pékaréte wani kapérandi musé yasnyéputikapuk yate gunat yakata-kandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wani kundi watake det nakapuk anga wandén: “Paapu yakwa du Gorale kundi bulké, de naknya naknya kakému yaakétndakwa. Yaakétte nak du dakwa kakému yaakét-ndakwanngé vékusék-ndarénngé wa deku saawimba waama képmaa kaavindakwa. Kaavindaka deku saawi waama yandékwa. Yandéka nak du dakwa véte wandakwa, ‘Wani du Gorké vékulakate wa kaandéké kiyaandakwa. Wan de yéku musé yakwa du wa.’ Wunga wate deku yé wa kavérékndakwa. Wunga yate yandarén yéku musé wa kaatandakwa. Paapu yakwa du wani du dakwamba yéku musé wa kéraandarén. Yi wan wanana wa. Gunat a wawutékwa. Kukmba Got yandarén yéku musé katik kwayékataké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Guné de yakwa pulak yaké yamarék. Guné Gorale kundi bulké yate, kakému yaakétte guna saawi ma yakwasnyéngunék. Ye némbé viyaangunu, akwi nyaa yangunéngwa pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Guné wunga yangunu, nak du dakwa gunat véte katik vékusékngé daré, guné Gorale kundi bulké yate kakému yaakét-ngunéngwanngé. De wani muséké vékusékngapuk yandarénngé guna saawi ma yakwasnyéngunu. Wunga yangunu, guna aapa Got male wani muséké vékusék-ngandékwa. Dé yamba vénangwe wa. Guné kakému yaakétte dale kundi bulte kapmang rangunu dé ve sérémaa yangunén yéku musé gunat kwayékata-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Guné apapu néma muséké vékulakangunéngwa. Yate wani muséké mawulé yangunéngwa. Ma véku. Guné wunga yate, ani képmaana némaamba musé kéraaké vékulakaké yamarék. Ani képmaana musé wan néma musé yamba wa. Biyaak wani musé kérékndakwa. Wani musé résépu yakandékwa. Sél yakwa du nak duna gaa wulaae wani musé sél yakandakwa. Wani musé rapékakapuk yakwanngé vékulakate, guné Gotna gaayémba yékunmba rapékamuké ma vékulakangunu. Vékulakate ma yéku musé male yangunék. Gotna gaayémba rate yanguna musé wan néma musé wa. Wani musé wan ani képmaana musé pulak yamba wa. Gotna gaayémba rate yanguna musé rapéka-kandékwa. Biyaak wani musé katik kérékngé daré. Wani musé katik résépu kurké dé. Sél yakwa du wani gaayét wulaakapuk yate wani musé sél katik yaké daré. Ani képmaamba musé saawulatékwa du dakwa de ani képmaana muséké male wa néma mawulé yandakwa. Gotna gaayémba raké vékulakakwa du dakwa de dale yékunmba rapékaké wa néma mawulé yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Guna méni wan sépémba tékwa téwaayé pulak wa. Wani téwaayé yékun téndu guné yéku musé male véngunu guna mawulé yékunmba tékandékwa. Yandu guna sépé yékunmba téndu guné nyaamba yarékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Guné kapérandi musé male véngunu, guna mawulé yékunmba katik téké dé. Guna mawulé yékunmba tékapuk yandu, guna sépé yékunmba tékapuk yandu, guné ganngumba yarékangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Du nak néma du vétikngé jémbaa yaké yapatikandékwa. Wunga jémbaa yamunaate, wa dé nak néma duké yéku mawulé yate nakngé kalik yakandékwa. Guné wani du pulak wa téngunéngwa. Guné néma du Gorké jémbaa yate déké male vékulakate, wa guné déké apapu mawulé yakangunéngwa. Yate guné yéwaa kéraaké katik vékulakaké guné. Guné yéwaa kéraaké male apapu vékulakamunaate, wa néma du Gorké kalik yakangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wani kundi watake Jisas det nakapuk anga wandén: “Nakurak néma duké jémbaa yangunénngé vékulakate gunat wawutékwa. Guné wup yate kulak kakému laplapké waak vékulalaakaké yambak. Kakému, kulak, laplap wan baka musé wa. Néma musé yamba wa. Guné wani muséké vékulalaakaké yambak. Got wandéka wa téngunéngwa. Guna sépé guna mawulé guna kwaminyan yatakandéka wa téngunéngwa. Wan néma musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Guné apit ma vé. De kakému yamba yaanandakwe wa. De kakému kéraate kaandi ras gaamba yamba taakandakwe wa. Yandaka anjorémba rakwa du guna aapa dé wa det kakému kwayékwa. Api wan makal musé wa. Guné du dakwa guné néma musé wa. Got apit wunga kakému kwayéndu, wa vékusék-ngangunéngwa. Gunat waak kakému kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Ma véku. Guna du nak némaamba kwaaré ras waak yatémuké vékula-laakamunaae, wa watake némaamba kwaaré ras waak yatémuké apa yaké dé? Yamba wa. Déku kapmang watake némaamba kwaaré ras waak yatéké yapati-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kamuké guné laplapké vékulalaako? Wunga yaké yambak. Guné maaweké ma vékulaka. Nané wani maawe yamba taawunangwe wa. De baka yaalandakwa. De jémbaa yamba yandakwe wa. De laplap yamba samapndakwe wa. Yandaka Got wa deké yékunmba véndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Det yéku nyaap kwayéndékwa. Talimba némaamba musé kureran néma du nak déku yé Solomon yéku yéku laplap saawundén. Yate wani maawe saawukwa pulak yéku musé yamba saawundékwe. Maawe saawukwa yéku musé wa Solomon saawan yéku musat taalékéran. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Got wani maaweké yékunmba véndékwa. Wani maawe ayélap sékét male tékandakwa. Bulaa téndakwa. Séré kiyaakandakwa. Kiyaandaru du dakwa wani maawe péle yaamba tukandakwa. Wani maawe wan makal musé wa. Guné du dakwa guné néma musé wa. Guné Gorké yamba yékunmba vékulaka-ngunéngwe wa. Yate wup yate wangunéngwa, ‘Nanéké yékunmba kalmu véké dé?’ Wunga wangunénga bulaa gunat wawutékwa. Got maawet wunga yandu véte vékusék-ngangunéngwa. Gunat laplap kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Wunga vékusékte wup yakapuk yate anga waké yambak, ‘Kamu musat kaké nané? Kamu kulakét kaké nané? Kamu laplapét saawuké nané?’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Wunga waké yambak. Anjorémba rakwa du guna aapa guné wani muséké yapatingunéngwanngé wa vékusékndékwa. Gotna kundi vékukapuk yakwa du dakwa de wani muséké vékula-laakandakwa. Guné de yakwa pulak wani muséké vékulalaakaké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yate guné Gotna kémba yaale déku kundi yékunmba vékute wandékwa pulak yate déku jémbaa yaké ma néma mawulé yangunék. Wunga yangunu, wa dé gunat wani musé kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwayéké yandékwanngé vékulakate guné séré yaaké yakwa muséké wup yaké yamarék. Séré yaaké yakwa muséké vékulalaakaké yamarék. Bulaa yaaké yakwa muséké male vékulakangunék.” Jisas wunga wandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wani kundi watake Jisas nakapuk wandén: “Nak du dakwa yan muséké vékulakate guné bari anga waké yambak, ‘Wani du dakwa wan de kapérandi musé yakwa du dakwa wa.’ Naaké yamarék. Guné wunga wangunu, wa Got guné yan musé véte gunat wakandékwa, ‘Guné kapérandi musé yakwa du dakwa wa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wunga wakwate yandékwanngé vékulakate, guné deké, ‘Wan de kapérandi mawulé vékukwa du dakwa wa,’ naaké yamarék bari. Got nak du dakwat guné yan musé vétake gunat yakata-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nak du dakwa yan makal kapérandi musé wan ménimba kwaakwa mu pulak wa. Guné yan néma kapérandi musé wan ménimba kwaakwa néma baangé pulak wa. Yénga guné nak du dakwana ménimba kwaakwa mu véte, gunékét guna ménimba kwaakwa néma baangé yamba véngunéngwe? Guné wunga yate, wa nak du dakwa yan makal kapéremuséké wate guné yan néma kapérandi muséké yamba vékulaka-ngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","“Guné néma kapérandi musé yatake yénga guné makal kapéremusé yan du dakwat anga wo? ‘Guné kapérandi musé wa yangunén. Guné yékunmba yaténgunénngé wa wuné gunat yékun yakawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wunga waké yamarék. Guné wunga wangunan, wa guné paapu yakwa du wa yaténgunéngwa. Taale guné yan néma kapérandi muséké ma kuk kwayéngunék. Kwayétake makal kapéremusé yan du dakwat ma yékun yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Guné Gotna kundiké kalik yakwa du dakwat Gotna kundi kwayéké yamarék. Guné det Gotna kundi kwayéngunu, wa de du tikwa waasa du dakwat yaavan kurkwa pulak wa gunat yaavan kurkandakwa. Du dakwa ras Gotna kundiké kuk kwayéndakwa. Det waak Gotna kundi kwayéké yamarék. Du waaréndakwa gaavi baalat yamba kwayéndakwe wa. Wunga kwayéndaru baalé képakmba yatéte wani musé baka maanét vaakikandakwa. Gotna kundi wan yéku kundi wa. Guné waaréndakwa gaavi baalat kwayékapuk yakwa du pulak, Gorké kuk kwayékwa du dakwat Gotna kundi kwayéké yamarék. Guné det déku kundi kwayéngunu de kalmu baalé vaakikwa pulak kapérandi musé gunat yaké daré?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gorét waataku-pékaréngunu gunat kwayékandékwa. Ani gwaaménja kundi ma véku. Guné waake waake vékangunéngwa. Guné pétémba viyaangunu viyaangunu pété naapikandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Akwi du dakwa Gorét waatakundaru wa det kwayékandékwa. Du dakwa waake waake vékandakwa. Du dakwa pétémba viyaandaru pété naapikandékwa. Guné wani gwaaménja kundi vékute Gorét ma waataku-pékaréngunék. Waatakuréngunu dé guna kundi vékukandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ani kundi waak ma véku. Guné aapambéré, guna nyambalé kakému kwayéngunénngé wandaru, guné matut kwayéké guné det? Yamba wa. Guné det kakému wa kwayékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","De mako kwayéngunénngé wandaru guné kaambet kéraae kwayéké guné det? Yamba yé wa. Wa guné det mako wa kwayékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bulaa wani kundiké ma vékulaka. Guné kapérandi mawulé vékukwa du yatéte wa guné guna nyambalésat yéku musé kwayéngunéngwa. Anjorémba rakwa du guna aapa yéku mawulé vékukwa du rate gunat taalékére dé néma yéku musé kwayékandékwa, dat waatakukwa du dakwat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nak du dakwa gunat yékun yandarénngé mawulé yangunéngwa pulak, guné det ma yékun yangunék. Moses wan apakundi, Gotna yémba kundi kwayétan duna kundi waak wan guné wunga yangunénngé wa wandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Kapérandi taalat yéndakwa yaambu wan néma yaambu wa. Wani yaambu néma tépiyaa wa. Wani yaambumba néma pété wa tékwa. Du dakwa wani néma pétémba tépiyaa yan yaambumba yéké néma jémbaa yamba yandakwe wa. Némaamba du dakwa wani néma yaambumba yéndakwan, wa lambiyak-ngandakwa. Gorale katik rapékaké daré. Guné wani yaambumba yéké yamarék. Gotna gaayét yéndakwa yaambu wan makalkéri yaambu wa. Wani yaambu néma tépiyaa yamba yé wa. Wani yaambumba makal pété wa tékwa. Ayélapkéri du dakwa male néma jémbaa yate wa wani makal pétémba wulaae wani makalkéri yaambumba yéndakwa. De kulémawulé kéraae Gorale rapéka-kandakwa apapu apapu. Guné wani makalkéri yaambumba ma yéngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas wani kundi watake anga wandén: “Guné jéraawu ma yangunék. Du ras gunéké yaae paapu yate gunat anga wakandakwa, ‘Nané Gotna yémba wa kundi kwayénangwa.’ Wunga wate késpulak nakpulak kundi wate guna mawulé yaavan kutndaru, nak du dakwa képakmba yatéte deké wakandakwa, ‘Wan yéku musé yakwa apu wa. Sipsip yékunmba téndakwa pulak de yékunmba téndakwa. Deku kundi ma vékukwak.’ Wunga watake de katik vékusékngé daré. Waaléwasa kapérandi mawulé vékundakwa pulak de kapérandi mawulé wa vékundakwa. Wunga katik vékusékngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Guné deku jémbaa, deku yapaté kurkale ma véngunék. Vétake deku mawuléké vékusék-ngangunéngwa. Képmaamba tékwa ani muséké ma vékulaka. Raamény baangwimba yéku miyé sék yamba vaakundékwe wa. Kapérandi waaramba yéku sék yamba vaakundékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Apamama yakwa yéku miyémba wa yéku sék vaakundékwa. Apamama yakapuk yakwa kapérandi miyémba kapérandi sék vaakundékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Apamama yakwa yéku miyémba kapérandi sék yamba vaakundékwe wa. Apamama yakapuk yakwa kapérandi miyémba yéku sék yamba vaakundékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yéku sék vaakukapuk yakwa miyé véle yaamba tundakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Guné wani muséké vékulakate miyé sékét véte vékusék-ngangunéngwa. Nak baan miyé wan yéku miyé wa. Nak baan miyé wan kapérandi miyé wa. Bulaa wani dunyanséké ma vékulaka. Guné deku kapérandi jémbaa véte vékusék-ngangunéngwa. Wan kapérandi musé yate paapu yakwa dunyansé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Némaamba du dakwa paapu yate wunat wandakwa, ‘Méné nana Néman Du wa.’ Wunga wate baka kundit male bulte anjorémba rakwa du wuna aapa Gotna kundi yamba vékundakwe wa. Wani du dakwa de Gotna kémba katik yaalaké daré. Gotna kundi vékute wandékwa pulak yakwa du dakwa male de Gotna kémba yaalakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wuné néma kot vékukwa néma du raké yawutékwa nyaa némaamba du dakwa wunat anga wakandakwa, ‘Néman Du, Néman Du, ména yémba nané Gotna kundi kwayénanén. Ména yémba wananga kutakwa yaange yéndarén. Ména yémba wate nané késépéri kulé apanjémba yananén. Nané ména du dakwa a ténangwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wunga wandaru det wakawutékwa, ‘Yamba wa. Paapu wa yangunéngwa. Wuné guné yamba vésékwutékwe wa. Guné wunale nakurakmawulé yamba yangunéngwe wa. Guné kapérandi mawulé vékukwa du dakwa wa. Ma yaange yéngunék.’ Naakawutékwa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Ani gwaaménja kundi ma véku. Nyaangét vékupukaakwa du matumba gaa kutndén. Kuttakandéka kukmba néma wimut kutndéka, néma maas viyaandéka, néma kwayé kwandéka wani gaa yékunmba kwaandén, matumba kutndénmba. Wani gwaaménja kundiké ma vékulaka. Wuna kundi vékute wawutékwa pulak yakwa du dakwa de matumba yéku gaa kurén du pulak wa yaténdakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Ani gwaaménja kundi ma véku. Nyaangét vékupukaakapuk yakwa du nak dé yaawiyamba gaa kutndén. Kuttakandéka kukmba néma wimut kutndéka, néma maas viyaandéka, néma kwayé kwandéka wani gaa vaakérén. Vaakétndéka kwayé yaae wa wani gaa yaate yéndén. Wani kundiké ma vékulaka. Wuna kundi baka vékute wawutékwa pulak yakapuk yakwa du dakwa, de yaawiyamba gaa kurén du pulak wa yaténdakwa.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas mayé apale téte wa Gotna kundi wunga kwayéndéka némaamba du dakwa déku kundiké vatvat naandarén. Vat naate wandarén, “Yéki. Dé Gotna jémbaaké yékunmba wa vékusékndékwa. Vékusékte wa nanat yakwasnyéndékwa. Apakundiké vékusékngwa du de nanat Gotna jémbaaké wunga yamba yakwasnyéndakwe wa.” Wunga wate déku kundi vékute vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas némbu taakatake daawulindéka némaamba du dakwa déku kukmba yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yéndaka lepro yan du nak dat yaae kwaati se waandé daate wandén, “Néman Du, wuné yékun yawuténngé méné mawulé ye waménu wuné yékun yakawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wunga wandéka déku taambamba kutte wandén, “Wuné yékun yaménénngé mawulé yawutékwa. Méné ma yékun ya.” Wunga wandéka dé wani lepro késndéka wani du yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yandéka dat wandén, “Ma véku. Ménat yawutén muséké nak du dakwat waké yamarékate. Méné Gotna kundi bulnangwa gaamba jémbaa yakwa duké ma ye déku ménimba téménu dé ména sépat véndu. Véndu méné Moses talimba wan pulak Gorké kwaami ma kwayéménék. Kwayéménu nak du dakwa véte, lepro késndéka yékun yaménénngé vékusék-ngandakwa.” Jisas dat wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisas Kaperneamét yéndéka Romna waariyakwa dunyanséna néma du nak yaae dat wandén, “Néman Du, ma véku. Wuna jémbaa yakwa duna maan kapére yandéka dé yamba yéndékwe wa. Néma kaangél vékute gaamba male kwaandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wunga wandéka wandén, “Wuné yaae dat kururé-kawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wunga wandéka wandén, “Néman Du, yamba wa. Wuné baka du a téwutékwa. Méné néma du wa téménéngwa. Wunga téte méné ye wuna gaat wulaaké yamarékate. Méné ma amba rate baka waménu dé wuna du nakapuk yékun yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nak du wunéké néma du téndékwa. Téndéka wuné wandékwa pulak yawutékwa. Wuné waariyakwa dunyanna néma du téwutékwa. Wuné duwat nak, ‘Méné ma yé,’ naawutéka yéndékwa. Nak duwat, ‘Méné ma yaa,’ naawutéka yaandékwa. Wuna jémbaa yakwa duwat, ‘Wani jémbaa ma ya,’ naawutéka dé wani jémbaa yandékwa. Méné yawutékwa pulak ma yaménu. Baka ma waménu wuna du nakapuk yékun yakandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas wani kundi vékute vékulaka vékulaka naandén. Yate déku kukmba yaatan du dakwat wandén, “Ani du dé wunéké yékunmba vékulakandékwa. Wuné wawutu du dakwa yékun yandarénngé wa vékusékndékwa. Guné Israel du dakwa ras wunéké ayélapkéri yékunmba wa vékulaka-ngunéngwa. Dé Rom du téndéka déku yéku mawulé wa guné Israelsé guna yéku mawulat taalékéran. Yi wan wanana wa, gunat wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma véku. Israel du dakwa ras de Gotna gaayét wulaakandakwa. De male yamba wa. Akwi genge gaayémba yaan némaamba du dakwa ras waak déku gaayét wulaakandakwa. Nyaa yaalakwanmba némaamba yaandaru nyaa daawulikwanmba némaamba yaae de némaamba du dakwa wa déku gaayét wulaakandakwa. Wulaae de Gotna kémba rate nana gwaal waaranga maandéka bakamu Abraham, Aisak, Jekopale, wunga rate kakému kakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel du dakwa némaamba de Gotna gaayét katik wulaaké daré. Wani du dakwaké Got kuk kwayékandékwa. Kwayéte wandu de kapérandi taalat yékandakwa. Wani taalémba ganngu male ye téndékwa. Nyaa yamba ve wa. Wani taalémba rakwa du dakwa néma kaangél kurkandakwa. Kutte de yéku taalémba raké mawulé yate némaamba géraakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wunga watake Romna waariyakwa dunyanna néma duwat wandén, “Ména gaayét ma waambule yé. Ye saambake wunéké yékunmba vékulakate wuna kundiké ‘Yi wan wanana wa’ naaménénngé, méné waménén musé wunga vékaménéngwa.” Naandén Jisas. Wunga wandén sapak male Romna waariyakwa dumba jémbaa yakwa du dé nakapuk yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ye Pitana gaat wulaae véndén Pitana naakumo baat yandéka kwaaléka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Vétake dé léku taambamba kutndéka baat késén. Yandéka yékun ye waarape musé kurure kakému yaake Jisasét kwayélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Garambu yandéka kutakwa kure yatan némaamba du dakwa nyambalésé wa kure yaandarén Jisaské. Kure yaandaka wandéka de kutakwasé yaange yéndarén. Baat yakwa du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalé waak déké kure yaandarén. Kure yaandaka det kururéndéka de akwi nakapuk yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas wunga yandéka Gotna yémba talimba kundi kwayétan du Aisaia déku kundi wa sékérékén. Déku kundi Gotna nyéngaamba anga kwaandékwa: Baat yandéka nanat kururéndén. Nana kapérandi musé kururéndén. Sépémaalé kapére yandéka dé mayé apa yate wandéka nané nakapuk yékun yananén. Wani kundi Aisaia viyaatakandén, Jisasna aasa dé kéraakapuk yalén sapak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Némaamba du dakwa jaawuwe téndaka Jisas véte déku dunyansat wandén, “Botmba waare néma gu kwaawu nak sakwat ma yékwak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wunga wandéka apakundiké vékusékngwa du nak yaae dat wandén, “Néman Du, méné nanat Gotna jémbaaké yakwasnyéménéngwa. Wuné ménale yeyé yaayaké mawulé yawutékwa. Yéména akwi taalat wuné waak yékawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wunga wandéka Jisas wa wan, “Kurkale ma vékulaka. Waaléwasa de képmaamba tékwa kwaawumba kwaandakwa. Api deku kwaatmba kwaandakwa. Wuné Duna Nyaan kwaawuta gaa nak yamba te wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wunga wandéka déku du nak dat wandén, “Néman Du, méné yi naaménu taale wuné ye rawutu wuna aapa kiyaandu déku pusaa kéraae rémngawutékwa. Rémtake wuné ménale yeyé yaayakawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wunga wandéka wandén, “Yamba wa. Bulaa wunale ma yaa. Wuna kundi vékukapuk yakwa du dakwa de kiyaan du dakwa pulak wa téndakwa. Wani du dakwa kiyaan du dakwat yénga rémndaru.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wani kundi watake Jisas botmba waaréndéka déku dunyan waak waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Waare yéndaka néma wimut kutndéka gu waarape waare botmba gwaande vékulékngé yan. Yandéka Jisas yundé kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kwaandéka déku dunyan ye dat sérkiyaandarén. Sérkiyaate wandarén, “Néman Du, a lambiyaknangwa. Méné ma waarape nanat yékun ya.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wunga wandaka det wandén, “Guné kamuké guné wup yo? Yate wangunéngwa, ‘Déku mayé apa makal mayé apa wa, yé?’ Wunga wate wunéké guné yamba yékunmba vékulakangunéngwe wa.” Wunga watake waarape wandéka wimut késndéka gu nakapuk daae yékunmba tén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Téndéka de akwi vatvat naate wandarén, “Yéki. Dé wandéka wa wimut gu déku kundi vékute wandékwa pulak yandékwa. Wan yénga pulak du dé?” Wunga watake Jisasale yékunmba yéndarén botmba. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas déku dunyansale botmba ye néma gu kwaawuna nak sakumba saambakndarén. Gadaraséna képmaamba saambakndarén. Saambakndaka du vétik bét du dakwa kiyaandaka rémndarén kwaawumba re wa dé véké yémbérén. Kutakwasé wa wani du vétikét kulure kure yatan. Kure yaténdaka bét waangété yate nak duwat akwi nyaa viyaaké yambéréka nak du dakwa wani yaambumba yamba yéndakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bét ye Jisasét vétake némaanmba waatakute wambérén, “Méné, Gotna nyaan, aanat kamu yaké méné? Aanat kaangél tiyaaké méné yaak? Kot vékukwa néma du raména sapak wayéka yamba yaae wa. Bulaa aanat kaangél tiyaaké yamarék.” Dat wunga wambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wani taalémba baalé asa wa de kakému katéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Katéndaka de wani du vétikét kure yatan kutakwasé Jisasét wandarén, “Méné nanat yakéléké mawulé yaménan, wa méné ma waménu nané wani baaléna mawulémba wulaakanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wunga wandaka det wandén, “Guné wunga ma yaange yéngunu.” Wunga wandéka de wani du vétik yaasékatake ye wani baaléna mawulémba wulaae téndarén. Téndaka wani baalé néma jaangumba yaange daawuliye gumba vaakére kulak ke kiyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yandaka baaléké kaavéran dunyansé yaange ye néma gaayémba saambake wani muséké du dakwat saapéndarén. Saapéte de kutakwasé kure yatan du vétikngé waak saapéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wunga wandaka vékutake wani gaayémba tékwa du dakwa yaandarén, Jisas véké. Yaae dat véte wandarén, dé deku képmaa yaasékatake yéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas bot nakmba waare néma gu kwaawu nak sakwat ye déku gaayémba saambakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Saambakndéka maan kapére yandéka yeyé yaayakapuk yan du nak déké yaate yéndarén. Dé jaambémba kwaandéka yaate yéndarén. Yéndaka Jisas wa vékusékndén. De deku mawulémba wandarén, “Jisas apamama yate nana duwat kururé-kandékwa.” Wunga wandaka Jisas vékusékte maan kapére yan duwat wandén, “Wuna du, ména mawulé yékunmba yénga téndu. Yaménén kapérandi musé wa yasnyéputiwutén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wunga wandéka apakundiké vékusékngwa dunyansé dekét deku kapmang bulte wandarén, “Got male wa du dakwa yandakwa kapérandi musé yasnyéputi-kandékwa. Wani du wa wan, ‘Wuné yandén kapérandi musé wa yasnyéputiwutén.’ Wunga wate dé Gorét wasélékngwa, baka du wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wunga wandaka Jisas deku mawulé vékusékte det wandén, “Kamuké guné guna mawulémba wani kapérandi mawulé yo? Wunga yaké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Wuné Duna Nyaan ani képmaamba yatéte yandarén kapérandi musé yasnyéputiké wa apamama yawutékwa. Guné wani muséké yamba vékusék-ngunéngwe wa. Yandén kapérandi musé yasnyéputi-wuténngé wate baka kundi wuté wak, kapuk néma kundi wuté wak? Dé waarape yéndénngé wawutan wan néma kundi waké wuté, kapuk? Guné wuna mayé apaké yékunmba vékusék-ngunénngé wa wuné ani kundi dat wakawutékwa.” Wunga watake maan kapére yan duwat wandén, “Méné ma waarape ména jaambé kéraae kure ména gaat yé.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wunga wandéka waarape déku gaat yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yéndéka wamba téte vétan du dakwa wup yate Gotna yé kavérékndarén. Kavérékte Jisaské wandarén, “Got wani duwat mayé apa kwayéndéka wa wunga yandén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas wani taalé yaasékatake yéndén. Yéte véndén takis kéraakwa du nak déku yé Matyu takis kéraandékwa gaamba randéka. Vétake dat wandén, “Méné ma yaa wunale.” Wunga wandéka waarape Jisasale yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas déku dunyansale Matyuna gaamba rate kakému karéndaka takis kéraakwa du némaamba, kapérandi musé yakwa du némaamba waak wunga yaandarén. Yaae dele rate kakému kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Rate karéndaka Farisi dunyan ras vétake Jisasna dunyansat wandarén, “Kamuké dé guna néma du takis kéraakwa du, kapérandi musé yakwa nak du waak, dé dele kakému ko?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wunga wandaka Jisas vékute wandén, “Yékun yatékwa du dakwa doktaké yamba yéndakwe wa. Sépémaalé kapére yan du dakwa de doktaké yéndakwa. Yéndaka dokta deku sépé kururéndékwa. Wuné du dakwana kapérandi mawulé kururéwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gotna nyéngaamba ani kundi wa kwaakwa: Got wa wandén, ‘Guné wunéké kwaami tuwe tiyaamuké kalik yawutékwa. Guné nak du dakwaké sémbéraa yate det yékun yangunénngé wuné mawulé yawutékwa.’ Got wunga wandéka déku kundi déku nyéngaamba wa kwaakwa. Guné ma ye wani kundiké yékunmba vékulakangunék. Kapérandi mawulé vékukwa du dakwa wunéké yaae wuna kundi vékundarénngé wa gaayawutén. Yéku mawulé vékukwa du dakwaké yamba vékulakawutékwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baptais kwayékwa du Jonna dunyansé Jisaské ye dat wandarén, “Nané, Farisi dunyan waak Gorale kundi bulké yate nané késépéri nyaa kakému yaakétnangwa. Kamuké daré ména dunyansé nané yakwa pulak kakému yaakérkapuk yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wunga wandaka Jisas det gwaaménja kundi nak anga wandén: “Du nak taakwa kéraaké yandu de kakému yaake mawulé tawulé yate kakému kaké daré, kapuk yamba yé? Kakandakwa. Taakwa kéraaké yakwa du dele randu de mawulé tawulé yate kakandakwa. Kukmba nak du yaae wani duwat kure yéndaru de déku du dakwa déké sémbéraa yate kakému katik kaké daré. Wuné wuna dunyansale wayéka yaréwutéka de mawulé tawulé yate wa kakému kandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wunga watake det gwaaménja kundi vétik waak anga wandén: “Du dakwa kulé laplap nak tambék kéraae jaangwa laplapmba tékwa ayéku yaambumba yamba taake samapndakwe wa. De kulé laplap nak tambék kéraae jaangwa laplapmba tékwa ayéku yaambumba taake samape kukmba gu yakwasnyéndaru kulé laplap makal pulak yandu jaangwa laplap gérikndu néma yaambu yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dékény kwaaré viyaae révéndarén meme sépémba kulé wain kulak yamba wukaasanda-ndakwe wa. Wunga yandaru, wani meme sépé jaangwa ye pungndu gu akwi yékéraa-kandékwa. Yékéraandu wani meme sépé katik yékun yaké dé. Kulé meme sépémba wukaasanda-ndaru, kulé kulak meme sépé waak yékunmba tékandékwa.” Wunga gwaaménja kundi wandén. Talimba tan du wan kundi, déku kulé kundiale véréti katik yékunmba kwaaké béré. Naate wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wani kundi wayéka waténdéka Judana néma du nak yaae Jisasét kwaati se waandé daate wandén, “Wuna takwanyan bulaakakét a kiyaalén. Méné yaae ména taamba lémba kutménu lé nakapuk taamalkalékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wunga wandéka waarape déku kukmba yéndéka déku dunyansé waak dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Yéténdaka taakwa nak Jisasna kukmba yaalén. Késépéri (12) kwaaré wa lé waaléramu yarélén. Lé Jisaské kundi vékute léku mawulémba walén, “Déku laplapmba taamba kure wuné nakapuk yékun yakawutékwa.” Wunga watake yaae déku laplapna waambumba kutlén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kutléka Jisas waalakwe lat vétake wandén, “Nyéno, nyéna mawulé yénga yékun téndu. Nyéné nyénat kururéké yawutékwa mayé apaké vékulakate bulaa yékun yanyénén wa.” Wunga wandéka wani taakwa bari yékun yalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisas wunga watake néma duna gaat yéndén. Ye véndén du ras kiyaan takwanyanngé sémbéraa yate paati waandaka du dakwa némaamba géraandaka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Vétake kaapamba téte wandén, “Wani takwanyan yamba kiyaalékwe wa. Lé baka yundé wa kwaalékwa. Guné akwi ma yaale yékéraa.” Wunga wandéka dat waangindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Waangindaka wandéka de akwi du dakwa yéndaka wani takwanyan kwaan taalat wulaandén. Wulaae léku taambamba kutndéka waaraplén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Waarapléka du dakwa akwi gaayét yéte wani muséké kundi saapé yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas wani taalé taakatake yéndéka méni kiyaan du vétik Jisasna kukmba yémbérén. Yéte némaamba waate wambérén, “Méno, Devitna gwaal waaranga maandéka bakamu. Méné néma du Devit pulak téte aanéké ma sémbéraa yaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wunga wambéréka Jisas ye gaat wulaandén. Wulaandéka déké yémbérén. Yémbéréka bérét anga waatakundén, “Yénga béné vékwo wunéké? Wuné béna méni kururéké apamama wuté yo, kapuk yamba yé?” Wunga waatakundéka wambérén, “Yi. Néman Du, méné wunga yamuké wa apamama yaménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wunga wambéréka déku taamba bérku ménimba kutte wandén, “Bénat kururéké yawutékwa mayé apaké yékunmba vékulaka-mbénénngé béna méni ma nakapuk yékun yandu.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wunga wandéka bérku méni nakapuk yékun yan. Yandéka Jisas bérét némaanmba watangndén, “Béné wani muséké ye nak duwat waké yamarékate.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wunga watangndéka déku kundi yamba vékumbérékwe. Wa ye akwi gaayémba bét wani muséké saapé yé yaayambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wani du vétik yémbéréka Jisaské du nak kure yéndarén. Wani du kutakwa déku mawulémba wulaae téléka kundi yamba bulndékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","De wani du Jisaské kure yéndaka Jisas wandéka wani kutakwa yaange yéléka wani du kundi bulndén. Bulndéka wamba tékésén du dakwa vékulaka vékulaka naate wandarén, “Yéki. Wan yéku musé wa. Talimba wunga pulak musé Israelmba yamba yandaka vénangwe.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wunga wandaka Farisi dunyansé nak pulak mawulé yate wandarén, “Wan yéku musé yamba wa. Kutakwana néma du Satan wa dat mayé apa kwayéndéka wandéka wa akwi kutakwa yaange yéndakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas akwi gaayémba yeyé yaayandén. Yeyé yaayate akwi gaayémba yéte Gotna kundi bulndakwa gaamba wulaate Gotna kundi det kwayéndén. Got néma du rate deké yékunmba véké yandékwanngé kundi kwayéndén. Kwayéte baat yan du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalésat waak kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Du dakwa némaamba déké yéndaka deké sémbéraa yandén. Sipsipké kaavérékwa du sipsipké kaavérékapuk yandéka, sipsip baka yeyé yaayaténdaka, deku mawulé yékéyaak yakwa pulak, deku mawulé wa yékéyaak yan. Yandéka Jisas deké sémbéraa yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sémbéraa yate déku dunyansat gwaaménja kundi anga wandén, “Yaawimba némaamba kakému wa aak yate tékéskwa. Tékésndéka ayélapkéri du male jémbaa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Guné wani yaawina duwat ma waatakungunu dé wandu jémbaa yakwa du némaamba yaae déku kakému kéraakandakwa.” Jisas wunga gwaaménja kundi wandén. Némaamba du dakwa Gotna kundi vékuké mawulé yandaka Gotna jémbaa yate déku kundi kwayékwa du ayélapkéri male yaténdakwanngé wa wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas déku du tambavétik maanmba kaayék vétikét (12) waandéka yaandaka det mayé apa kwayéndén, de wandaru akwi kutakwa yaange yémuké. Det nak mayé apa waak kwayéndén, de baat yakwa akwi du dakwa nyambalé, sépémaalé kapére yan akwi du dakwa nyambalat waak kururémuké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","De déku kundi kure yéndarénngé wa det wandén. Deku yé anga: Saimon, déku nak yé Pita. Déku waayéka Andru. Sebedina nyaan vétik Jems ambét déku waayéka Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip. Bartolomyu. Tomas. Matyu. Talimba takis kéraatan du. Alfiusna nyaan Jems. Tadius. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nak Saimon. Talimba akwi genge gaayét yéte wandén, “Nak képmaana du nanéké néma du témuké kalik yawutékwa.” Nak du déku yé Judas Iskariot. Kukmba Jisas kwayéndén déku maamasat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas wani dunyansat anga wandén, “Guné Samariamba tékwa gaayét yéké yambak. Nak képmaamba tékwa gaayét waak yéké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Guné nana gaayé Israelmba tékwa gaayét male ma yéngunék. Israelséna mawulé wa yékéyaak yawuran. Lambiyakén sipsipna mawulé yékéyaak yakwa pulak, Israelsé Gotna kundi kuk kwayéndaka deku mawulé wa yékéyaak yawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Deké ye det anga wangunék, ‘Néman Du Got gunéké vékwate yandékwa sapak a yaae kwambalikwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wunga watake guné baat yakwa du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalat waak kururéngunék. Kiyaan du dakwat wangunu de nakapuk taamale waarapkandakwa. Lepro yan du dakwat ma kururéngunék. Du dakwana mawulémba tékwa kutakwa wangunu de yaange yékandakwa. Wuné gunat mayé apa baka kwayéwutén. Kwayéwuténngé guné wani jémbaa baka ma yangunék. Wani jémbaaké yéwaa kéraaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Guné yéwaa ras kéraae kure yéké yamarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Guné yéte saawungunén musé male kwaandu yéngunék. Wut nak waak, laplap ras waak, su, sétongunéngwa baangé, kure yéké yamarék. Guné du dakwat yékun yangunu de gunat yékun yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Guné gaayét nak wulaae, guné kurkale ma véngunék. Véngunu yéku du gunale kundi bulndu, déku gaamba male ma yaréngunék. Késnga nakngat yéké yambak. Déku gaamba yare guné yéké ya. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Guné gaa nakmba wulaae wamba yarékwa du dakwat anga ma wangunék, ‘Guna mawulé yénga yékun téndu.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Guné wunga wangunu wamba yarékwa du dakwa gunéké mawulé yandaru, Got det yékun yandu de yékunmba yatékandakwa. Wamba yarékwa du dakwa gunéké mawulé yakapuk yate gunat kuk kwayéndaru, Got det yékun katik yaké dé. Got gunat yékun yandu guné yékunmba yatékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Guné gaayé nakét wulaangunu wamba tékwa du dakwa guna kundi vékukapuk yate, gunat kuk kwayéndaru, wani gaayé ma yaasékangunék. Yaasékaké yate guna maanmba kwaakwa baawu ma viyaaputétake yéngunék.” Jisas wunga wandén. Jisas wani kundi wate ani muséké wandén. Nané Judasé anga yanangwa. Gotna kundi kuk kwayékwa du dakwat Got yandarén kapérandi musé yakataké yandékwanngé, vékusékmuké wa deku gaayé yaasékaké yate nana maanmba kwaakwa baawu viyaaputénangwa. Yatake yénangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jisas déku dunyansat nakapuk wate anga wandén, “Gunat kuk kwayéké yakwa du dakwaké gunat wawutékwa. De nanat wunga kuk kwayéte néma kapérandi musé yandakwa. Talimba Sodommba yatan du dakwa, Gomoramba yatan du dakwa waak de kapérandi musé yandarén. Kukmba Got néma kot vékute néma du raké yandékwa nyaa dé wandu de Sodommba tan du dakwa, Gomoramba tan du dakwa kaangél kurkandakwa. Du dakwa nanat kuk kwayéndaran, wa wani nakurak kapérandi musé Sodommba tan du dakwa, Gomoramba tan du dakwa yandarén kapérandi musat wa taalékéra-kandékwa. Wani nyaa Got wandu nanat kuk kwayéké yakwa du dakwa néma kaangél kurkandakwa. Yi wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ma véku. Wawutu guné akwi gaayét yékangunéngwa. Waaléwasa sipsipét yaavan kutndakwa pulak, wani gaayémba tékwa du dakwa de gunat yaavan kurké mawulé yakandakwa. Kaambe yéte kapérandi musé dat yaavan kutmuké jéraawu yandékwa pulak, guné kapérandi muséké ma jéraawu yangunék. Nyaamiyo waariyakapuk yate yékun yaréndakwa pulak, guné waariyakapuk yate kurkale ma yaréngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Guné jéraawu ma yangunék. Du ras gunat kéraae kotim-ngandakwa. Du ras Gotna kundi bulndakwa gaamba gunat viyaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Guné wuna du téngunéngwanngé du ras wuna jémbaaké kalik yate gunat kure yéndaru guné deku néma duna ménimba tékangunéngwa. De wunga yandaru guné det wuna kundi kwayékangunéngwa. Nak gaayé du dakwat waak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Du ras gunat kotimndaru guné wup yate guna mawulémba anga waké yambak, ‘Nané kamu kundit waké nané? Deku kundi yénga pulak kaataké nané?’ Wunga waké yamarék. Wani sapak Got wanguna kundi gunat kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wani sapak guna aapa Gotna Yaamambi guna mawulémba wulaae téndu guné déku kundi vékute wakangunéngwa. Guna mawulémba vékulakate kundi katik bulké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kukmba némaamba du deku aanyé waayékat kotimndaru wa aanyé waayékat viyaandék-ngandakwa. Aapambéré deku nyambalat kotimndaru de wani nyambalat viyaandék-ngandakwa. Nyambalé waak aasa aapat kotimndaru aasa aapat viyaandék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Guné wuna du téngunéngwanngé akwi du dakwa gunéké kalik yakandakwa. Guné guna mawulémba mayé apa yate wuna jémbaa kutpékaa-téngunu kukmba Got gunat kéraandu dale yékunmba rapéka-kangunéngwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nak gaayémba gunat yaavan kutndaru nak gaayét ma yaange yéngunék. Israelna akwi gaayémba jémbaa yasékéyakngapuk téngunu wa wuné Duna Nyaan waambule yaakawutékwa. Yi wan wanana wa. Gunat wa wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ani gwaaménja kundi ma véku. Yakwasnyékwa du skulkwa nyambalat taalékére néma du wa randakwa. Jémbaa kwayékwa du wa deku jémbaa kurkwa duwat taalékére deké néma du randakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nak du yakwasnyékwa duwat yandakwa pulak, wa nyambalat waak yandakwa. Nak du jémbaa kwayékwa duwat yandakwa pulak, wa demba jémbaa yakwa duwat waak yandakwa. Bulaa wani kundiké ma vékulaka. Nak du wuné guna néma duwat yandakwa pulak, wa guné wuna dunyansat waak yakandakwa. Nak du wunéké kapérandi kundi bulte wandakwa, ‘Guna néma du wan akwi kutakwana néma du wa, déku yé Belsebul wa.’ Naandakwa. De wunéké wunga wate guné wuna dunyansé gunéké néma kapérandi kundi wakandakwa.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wani kundi watake Jisas déku dunyansat ani kundi wandén, “Du ras gunat kapérandi musé yandaru guné deké wup yaké yamarékate. Yate paakungunén akwi musé kukmba némaamba du dakwa vékandakwa. Yakélak wangunén akwi kundi kukmba némaamba du dakwa vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ganngumba wawutén kundi nyaamba ma wangunék. Bulaa gunale rate yakélak wawutékwa kundi, némaamba du yamba vékundakwe wa. Guné male vékungunéngwa. Kukmba guné kaapamba téte wani kundi némaamba wangunu vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Du ras wandakwa, gunat viyaandékmuké. Deké wup yaké yambak. De gunat viyaandéke guna kwaminyan viyaaké yapatikandakwa. Guné Gorké ma wup yangunék. Dé male wa wani muséké apa tapa yandékwa. Dé du dakwana sépé du dakwana kwaminyan waak viyaaké apa tapa yandékwa. Det yaa yaanpékatékwa taalat vaanjandamuké wa apa tapa yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Ani kundi ma véku. Du dakwa de makalkéri yéwaa nakét kwayéte makal api vétik kéraandakwa. Makal api nak képmaamba vaakétndéka guna aapa Got wani muséké wa vékusékndékwa. Api nak képmaamba vaakérkapuk yandénngé wandu, wani api katik vaakérké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gunéké waak wa vékusékndékwa. Akwi muséké wa vékusékndékwa. Guna maakamba tékwa némbé akwi naakiye wani muséké waak wa vékusékndékwa. Vékusékte dé gunéké yékunmba véndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Véndékwanngé vékulakate guné wup yaké yambak. Api wan makal musé wa. Du dakwa wan néma musé wa. Guna aapa Got makal apiké wunga yékunmba véte gunéké yékunmbaa-sékéyak wa vékandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Du ras némaamba du dakwana ménimba téte nak nak anga wamunaandaru, ‘Wuné Jisasna du a.’ Wunga wandaru, wa kukmba wuné wuna aapana gaayémba rate déku ménimba téte dat wakawutékwa, ‘Ani du an wuna du a.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Du ras némaamba du dakwana ménimba téte nak nak anga wamunaandaru, ‘Wuné Jisasna du yamba wa.’ Wunga wandaru, wa wuné wuna aapana gaayémba rate déku ménimba téte dat wakawutékwa, ‘Wani du wan wuna du yamba wa.’ Wunga wakawutékwa Gorét.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Guné anga wambak, ‘Képmaamba tékwa akwi du dakwa waariyakapuk yate yékunmba téndarénngé wa Jisas yaandén.’ Yamba wa. Wuné yaanngé du ras wuna kundi yékunmba vékundaru deku kém rakarka yate dele waariya-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yaawuténngé du dakwa ras wuna kundi yékunmba vékundaru du dakwa ras wuna kundi kuk kwayékandakwa. Yate nyambalé deku aapale waariya-kandakwa. Takwanyanngu deku aasale waariya-kandakwa. Méyasngu deku yawuale waariya-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nakurak gaamba yarékwa du dakwa de waak waariya-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Guné guna aasa aapaké néma mawulé yate wunéké ayélapkéri mawulé yangunan, wa guné wuna du katik téké guné. Guné guna nyambaléké néma mawulé yate wunéké ayélapkéri mawulé yangunan, wa guné wuna du katik téké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Guné anga wangunan, ‘Jisasna jémbaa kutpékaa-kanangwa. Yate kaangél kutte takwemimba kiyaananan wan baka musé wa. Néma musé yamba wa.’ Wunga wangunan, wa guné wunga yate guné wuna du tékangunéngwa. Guné wunga wakapuk yate wunga yakapuk yangunan, wa guné wuna du katik téké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Guné wunéké vékulakate wuna jémbaa kutpékaangunu, wuna maamasé gunat viyaandékndaru, wa guné wunale apapu apapu yékunmba rapéka-kangunéngwa. Guné guna sépéké male vékulakate guna jémbaa male yangunan, wa guné kiyaae lambiyak-ngangunéngwa. Wunale yékunmba katik rapékaké guné.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wani kundi watake Jisas déku dunyansat anga wandén, “Du dakwa gunat yékun yate, wa wunat waak yékun wa yandakwa. Yate wunat wandéka yaawutén du Gorét waak wa yékun yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Guné Gotna yémba kundi kwayékwa du nakét véte anga wangunu, ‘Wani du dé Gotna yémba kundi kwayéndékwa. Wuné dé randa taalé, kakému waak kwayékawutékwa.’ Wunga watake wunga yangunu kukmba Got gunat yékun yakandékwa, déku yémba kundi kwayékwa dunyansat yékun yanda pulak. Guné yéku musé yakwa du nakét véte anga wangunu, ‘Wani du dé yéku musé male yapékandékwa. Wuné déké randa taalé, kakému waak kwayékawutékwa.’ Wunga watake wunga yangunu kukmba Got gunat yékun yakandékwa, yéku musé male yapékakwa duwat yékun yanda pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Ani kundi waak ma véku. Du dakwa wuna duwat véte anga wandaru, ‘Wani du de néma du yamba téndakwe wa. Baka du wa yaténdakwa. Yatéte Jisasna jémbaa kutndakwa. Det yékun ma yakwak. Det kulak ma kwayékwak.’ Wunga watake de wani makal jémbaa yandaru Got wani makal jémbaaké katik yékéyaak yaké dé. Kukmba wani yéku jémbaa kaatakandékwa det. Yi wan wanana wa.” Jisas wunga déku dunyansat wandén. Wandéka de déku jémbaa yaké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","2","Jisas Krais déku dunyansé tambavétik maanmba kaayék vétikét (12) kundi wasékéyaktake wani gaayé taakatake dé wani képmaamba tékwa gaayét yéte du dakwat Gotna kundi kwayéndén. Kwayéte Gotna jémbaa yandéka baptais kwayékwa du Jon kalapusmba rate Jisas yan jémbaaké vékundén. Vékute déku duwat wandéka Jisaské yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ye Jisasét wandarén, “Talimba Gotna nyéngaamba kundi viyaatakandarén, nanat yékun yaké kukmba yaaké yakwa duké. Méné wani du méné, kapuk nak duké kaavéréké nané? Wani muséké vékusékngé Jon mawulé yandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wunga wandaka det wandén, “Guné ma waambule ye véngunén musé vékungunén kundiké Jonét wangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Méni kiyaan du dakwa véndaka, maan kapére yan du dakwa yékun ye yeyé yaayandakwa. Lepro yan du dakwa yékun yandaka waan waangété yandéka vékukapuk yan du dakwa de kundi vékundakwa. Wani du dakwat wa kururéwutén. Wuné wawutéka kiyaan du dakwa de nakapuk taamale waarape yaténdakwa. Musé asékapuk yan du dakwat Gotna kundi kwayéwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Du dakwa ras wunéké wandakwa, ‘Got dat wa wandén, dé nanat yékun yandénngé. Yi wan wanana wa.’ Wunga wate de wunéké yékunmba vékulakandakwa. Wunéké wunga vékulakakwa du dakwa de mawulé tawulé yénga yandaru. Jonét wunga ma wangunék.” Naandén Jisas Jonna dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jisas wunga wandéka Jonna dunyansé yéndaka Jisas wamba tan du dakwat Jonngé anga wandén, “Guné du yarékapuk taalat ye yénga pulak du véké guné yék? Mayé apa yakapuk yate wimut kutndéka viyékngwa séwaa pulak yakwa duwat véké guné yék, kapuk yénga pulak? Jon wan dé wani musé pulak yamba wa. Jon wan dé mayé apa yakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yéku laplap saawan duwat véké guné yék, kapuk yénga pulak? Jon wani du pulak yamba yaténdékwe wa. Yéku laplap saawan du de néma duna gaamba wa randakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gotna yémba kundi kwayétan du nakét véké guné yék, kapuk yénga pulak? Yi, Jon wan Gotna yémba kundi kwayétan du wa. Dé néma du wa téndékwa. Gotna yémba kundi kwayétan nak néma duwat taalékére dé néma du wa téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Jonngé ani kundi Gotna nyéngaamba wa kwaakwa: Got déku nyaanét wandén, ‘An wuna kundi kure yékwa du a. Wuné wawutu dé taale yéte ména yaambu kurkandékwa.’ Nané wani kundi véte anga vékuséknangwa. Jon wan Gotna kundi kure taale yaakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Wunga vékusékte gunat wawutékwa. Baptais kwayékwa du Jonna jémbaa ani képmaamba talimba tan duna jémbaat wa taalékérandén. Taalékérandéka dé gunat yékun yawuta jémbaaké yamba yékunmba vékusékndékwe wa. Yandéka de Gotna kémba téte du dakwat yékun yawuta jémbaaké vékusékngwa du dakwa akwi deku yéku mawulé déku yéku mawulat wa taalékérandén. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wunga watake Jisas anga wandén, “Jon yaae dé du dakwat Gotna kundi kwayéndén. Baasnyé ye wandén sapak bulaa waak némaamba du dakwa Gotna kémét yaavan kurké, wa de apamama yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Got néma du rate du dakwaké yékunmba vékandékwa. Moses talimba wani muséké kundi kwayéndén. Gotna yémba kwayétan nak du waak de wani muséké kundi kwayéndarén. Jon waak wani muséké kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Guné deku kundi vékumunaangunu, wan yékun wa. Talimba tan du anga wandarén, ‘Elaija kukmba yaakandékwa.’ Wunga wandaka bulaa gunat wawutékwa. Wani kundi wate, wa de Jonngé wa wandarén. Wandaka wa Jon yaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Guné vékusékngé mawulé ye kurkasale waan taake yékunmba vékwe wa vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bulaa a tékwa du dakwa yénga pulak daré? Gunat wakawutékwa. Bulaa tékwa du dakwa de aamemba kétikwa nyambalé pulak wa yaténdakwa. De nak nyambalat waandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Waate wandakwa: Nané gwaaré waate kaang viyaananga guné yamba kétingunéngwe. Nané sémbéraa yate géraananga guné yamba géraangunéngwe wa. Guné nanale nakurakmawulé yamba yangunéngwe wa. Wunga waakwa nyambalé pulak, bulaa tékwa du dakwa wunga yaténdakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“De Jonale nakurakmawulé yamba yandakwe wa. De wunale nakurakmawulé yamba yandakwe wa. Jon yaae kangunéngwa kakému kakapuk yate kangunéngwa wain kulak yamba kandékwe. Yandéka guné akwi déké kalik yate wangunéngwa, ‘Kutakwa déku mawulémba wulaae téndéka wa waangété yandékwa.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wunga wangunénga wuné Duna Nyaan yaae kangunéngwa kakému kate kangunéngwa wain kulak kawutékwa. Kawutéka guné wunéké kalik yate wangunéngwa, ‘Ma véna. Wani du némaamba kakému kate némaamba wain kulak kandékwa. Kate dé takis kéraakwa dunyansale rate, kapérandi musé yakwa nak du dakwale rate wa dele kundi bulndakwa.’ Naangunéngwa. Wunga wangunénga gunat wawutékwa. Got dé akwi muséké vékusékndékwa. Déku jémbaa wan yéku jémbaa wa. Yi wan wanana wa. Wani kundiké vékulakate wa aané Jonale Gorké yatékwa jémbaaké yékunmba vékulaka-kangunéngwa.” Naandén Jisas wani du dakwat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas néma gaayémba ras talimba vékapuk yandarén kulé apanjémba késépéri yandén. Yandéka de wamba tan du dakwa yandarén kapérandi musé yaasékatake Gorké yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yandaka Jisas det anga wandén, “Sémbéraa yawutékwa, guné Korasinmba tékwa du dakwaké! Sémbéraa yawutékwa, guné Betsaidamba tékwa du dakwaké! Wuné guna gaayémba yatéte kulé apanjémba yawutén. Yawutéka wa véngunén. Véte Gorké yamba yékunmba vékulakangunéngwe wa. Tairmba talimba tan du dakwa, Saidonmba talimba tan du dakwa waak, Gorké vékusékngapuk ye wani apanjémba vémunaae, talimba de yandarén kapérandi muséké kalik yate, wani kapérandi musé yaasékakatik daré. Yandarén kapérandi muséké kalik yate, nak du dakwa deku mawuléké vékusékndarénngé de jaangwa laplap saawuwe baawumba rakatik daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Guné ma véku. Kukmba Got néma kot vékute néma du raké yandékwa nyaa dé wandu de Tairmba talimba tan du dakwa, Saidonmba talimba tan du dakwa waak de kaangél kurkandakwa. Guné, Korasinmba tékwa du dakwa, Betsaidamba tékwa du dakwa waak, guné wuna jémbaa véte guné wunat kuk kwayéngunén. Kuk kwayéngunénga wani nakurak kapérandi musé de yan akwi kapérandi musat wa taalékérandén. Wani nyaa Got wandu guné néma kaangél kurkangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Guné Kaperneammba tékwa du dakwa, guné akwi nyaa anga wangunéngwa, ‘Nané Gotna gaayét waarékanangwa.’ Wunga wangunénga gunat wawutékwa. Got wandu guné kapérandi taalat daawulikangunéngwa. Guné Gotna gaayét katik waaréké guné. Wuné guna gaayémba yatéte kulé apanjémba wa yawutéka véngunén. Véte guné Gorké yékunmba yamba vékulaka-ngunéngwe wa. Talimba Sodommba tan du dakwa némaamba kapérandi musé ye wani apanjémba vémunaae, de yandarén kapérandi musé yaasékandaru Got wani gaayé katik yaavan kurkatik dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Guné ma véku. Kukmba Got néma kot vékute néma du raké yandékwa nyaa dé wandu de Sodommba tan du dakwa kaangél kurkandakwa. Guné Kaperneammba tékwa du dakwa, guné wuna jémbaa, wunat waak kuk kwayéngunén. Kuk kwayéngunénga wani nakurak kapérandi musé de yan akwi kapérandi musat wa taalékérandén. Wani nyaa Got wandu guné néma kaangél kurkangunéngwa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jisas wani kundi watake Gorét anga wandén, “Wuna aapa, méné nyét képmaana néma du wa raménéngwa. Ména jémbaaké ras paakuménénga rékaamba muséké vékusékngwa du ména jémbaaké yamba yékunmba vékusékndakwe wa. Rékaamba muséké vékusékngapuk yakwa du dakwa, deku mawulé nyambaléna mawulé tékwa pulak téndéka yékéyaakmba yaténdaka det ména jémbaaké wakwasnyéménén. Wunga yaménén wan yékun wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wuna aapa, ména mawulémba vékulakate wa wunga yaménén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wani kundi watake det anga wandén, “Wuna aapa dé wunat déku jémbaa, mayé apa waak, wa tiyaandén. Wuné déku nyaan téwutéka du dakwa wuné yamba kurkale vékusékndakwe wa. Dé male wa wuné vékusékndékwa. Du dakwa déké yamba kurkale vékusékndakwe wa. Wuné male wa dé vékusék-wutékwa. Déké wawutén du dakwa waak déké wa vékusékndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Guné guna mawulémba vékulaka vékulaka naate yékunmba raké néma apa jémbaa yakwa du dakwa, guné wunéké yaangunu, wuné wawutu guna mawulé yékunmba tékandékwa. Yaap yarékwa du dakwana mawulé yékunmba tékwa pulak téndu guné yékunmba rakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wuné jémbaa yawutékwa pulak guné jémbaa ma yangunék. Guné wuna jémbaamba yaalangunu wuné wani jémbaaké gunat yakwasnyé-kawutékwa. Yakwasnyéwutu nané nakurakmawulé yate wani jémbaa yakanangwa. Wuné wuna yé kavérékngapuk yate guna mawulé yékun yawutu guna mawulé yékunmba tékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwayéwutékwa jémbaa wan mawulé yanguna jémbaa wa. Wup yanguna jémbaa yamba yé wa. Guné wani jémbaa yaké apamama yakangunéngwa. Guné wuna jémbaa yangunu guna mawulé yékunmba tékandékwa. Téndu yékunmba yarékangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kukmba Judana yaap yaré nyaa nak Jisas déku dunyansale wit tékwa yaawimba nak yéndarén. Yéténdaka déku dunyansé kaandé yandéka wit kumbu ras taakwe sék kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kandaka Farisi dunyan vétake Jisasét wandarén, “Ma vé. Ména dunyan wit kumbu taakundakwa, yaap yaré nyaamba. Nana apakundi anga wandékwa, ‘Guné yaap yaré nyaa jémbaa yaké yambak.’ Wani apakundi ména dunyan yamba vékundakwe wa. De wit kumbu taakute jémbaa wa yandakwa yaap yaré nyaamba. Wan kapérandi musé wa yandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Wunga wandaka det wandén, “Talimba nana gwaal waaranga maandéka bakamu Devit yan muséké Gotna nyéngaamba wa viyaatakandarén. Wani kundiké guné yamba vékulakangunéngwe wa. Talimba Devit déku dunyansale kaandé yandéka Gotna kundi bulndakwa gaamba wulaae wani gaamba jémbaa yakwa duwat waatakundén, Gorké kwayéte taakandarén kakému det kwayéndarénngé. Waatakundéka kwayéndaka Devit déku dunyansale wani kakému kandarén. Wunga ye nana apakundi yamba vékundakwe. Nana apakundi anga wandékwa, ‘Gotna gaamba jémbaa yakwa du male Gorké kwayéndarén kakému kakandakwa. Nak du wani kakému katik kaké daré.’ Wunga wandéka Devit déku dunyansale wunga yandaka guné deké anga yamba wangunéngwe wa, ‘Wan kapérandi musé wa yandarén.’ Wunga wakapuk yate kamuké guné wuna duké anga wo? ‘De nana apakundi vékukapuk yate kapérandi musé wa yandakwa.’ Guné wunga wate yamba yékunmba vékusékngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nak kundi waak ma véku. Gotna gaamba jémbaa yakwa du de yaap yaré nyaa Gotna gaamba jémbaa yandakwa. Moses wan apakundi anga wandékwa, ‘Gotna gaamba jémbaa yakwa du yaap yaré nyaa waak déku gaamba wani jémbaa yakandakwa. Wan yékun wa.’ Wunga wandéka yaap yaré nyaa wani jémbaa yandaka guné det yamba waarungunéngwe wa. Yangunéngwanngé kamuké guné wuna dunyansat waaruwu? ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma véku. Wuné néma du wa téwutékwa, Gotna kundi bulnangwa gaaké. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Gotna nyéngaamba ani kundi wa kwaakwa: Got wa wandén, ‘Guné nak du dakwaké sémbéraa yate det yékun yangunénngé mawulé yawutékwa. Guné kwaami viyaae tuwe wunat tiyaamuké kalik yawutékwa.’ Got wunga wandén. Wandéka wani kundi déku nyéngaamba kwaandéka guné wani kundiké yamba yékunmba vékusékngunéngwe wa. Guné wani kundiké yékunmba vékusékmunaae, wa guné kapérandi musé yakapuk yan duwat katik waarukatik guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wani kundi wuné Duna Nyaan wawutékwa. Yaap yaré nyaaké néma du a téwutékwa. Wuné du dakwana jémbaaké yi naawutu, wa yi naawutén pulak yakandakwa, yaap yaré nyaamba.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wani kundi watake Jisas wani taalé taakatake Gotna kundi bulndakwa gaat wulaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wulaandéka taamba kapére yan du nak wamba téndén. Téndéka Jisaské kalik yakwa du ras deku mawulémba anga wandarén, “Jisas yaap yaré nyaamba jémbaa yandu dé kotim-nganangwa.” Wunga wate Jisasét wandarén, “Yaap yaré nyaamba dunyan baat yakwa duwat kururéndakwan, wa de nana apakundiké daré kuk kwayu, kapuk? Wani muséké yénga méné vékwo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wunga wandaka det wandén, “Guna du nak déku sipsip yaap yaré nyaa kwaawumba vaakétndu, wani sipsip kéraae kusaleké dé, kapuk yénga yaké dé? Dé déku sipsip kéraae kusale-kandékwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipsip wan makal musé wa. Du dakwa wan néma musé wa. Yaap yaré nyaamba dunyansé nak duwat yékun yandaru nana apakundi wani muséké det katik waaruké dé. Wuné yaap yaré nyaamba duwat yékun yawutu, nana apakundi wani muséké wunat katik waaruké dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wunga watake taamba kapére yan duwat wandén, “Ména taamba ma kayéndéng.” Wunga wandéka déku taamba kayéndéngndéka nak taamba tan pulak yékunmba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Téndéka Farisi dunyansé rakarka yate wani gaa taakatake ye jaawuwe kundi bulndarén, Jisas viyaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas wani muséké vékusékte wani gaayé taakatake yéndén. Yéndéka némaamba du dakwa déku kukmba yéndarén. Yéténdaka Jisas wandéka baat yan du dakwa, sépémaalé kapére yan du dakwa akwi yékun yawuréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yandaka det némaanmba watangndén, déké nak du dakwat kundi saapékapuk yamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","18","Wunga wandéka Gotna yémba kundi kwayétan du Aisaia déku kundi wani sapak wa sékérékén. Talimba Aisaia ani kundi Gotna nyéngaamba viyaatakandén: Got wa wandén, “Wuné wani duwat wawutéka wa dé wuna jémbaa yakwa du téndékwa. Wuné déké néma mawulé yawutéka wuna mawulé yékun yandékwa déké. Wuné wawutu wuna Yaamambi déku mawulémba wulaae tékandékwa. Téndu dé néma kot vékukwa néma du rate wuna kundi akwi du dakwat wakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dé katik waaruké dé. Dé némaanmba katik waaké dé. Dé yaambumba téte det némaanmba katik waké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dé répkwaakwa séwaa nak katik répsékéyakngé dé. Wani séwaat yékun kurkandékwa. Katik vaanjandaké dé. Dé ayélap vérékngwaakwa yaa katik vélékéyaakngé dé. Dé nakapuk yamungandu néma yaa vérékngandékwa. Dé wunga yate déké ayélap vékulakakwa du dakwat yékun yandu de apamama yate déké yékunmba vékulaka-kandakwa. Dé jémbaa yandu yéku musé male tékandékwa. Kapérandi musé késkandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Akwi képmaamba tékwa du dakwa déké yékunmba vékulakate wakandakwa, ‘Dé nanat yékun yakandékwa.’ Wunga wate déké kaavéré-kandakwa.” Got wunga wandén. Wandéka Aisaia wani kundi Jisaské viyaatakandén Gotna nyéngaamba, déku aasa kéraakapuk yalén sapak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dunyan ras du nak Jisaské kure yéndarén. Wani duwat kutakwa wa kure yatan. Kure téléka déku méni kiyaandéka kundi yamba bulndékwe. Yandéka Jisas dat kururéndéka nakapuk kundi bulte méni véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yandéka késépéri du dakwa vétake vatvat naate wandarén, “Yéki. Wani du wan Devitna gwaal waaranga maandéka bakamu dé kapuk? Dé nanat yékun yandénngé Got wan du dé, kapuk yénga pulak dé?” Wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisi dunyan wani muséké vékute dekét deku kapmang kundi bulte wandarén, “Wani du wan Got wan du yamba wa. Kutakwana néma du déku yé Belsebul, wa déku mawulémba wulaae tékwa. Téte mayé apa kwayéndéka wa wani du wandéka kutakwa yaange yéndakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wunga wandaka Jisas deku mawulé vékusékte det wandén, “Ani kundi ma véku. Néma gaayémba rakwa dunyan mawulé vétik yate kémba kém kutéke rate waariyamunaae katik tésékéyakngé daré. Nakurak gaamba yarékwa du dakwa mawulé vétik yate deku kapmang waariyamunaae de waak katik tésékéyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wani kundiké ma vékulaka. Kutakwana néma du Satan déku dunyansale wunga téndakwa. De mawulé vétik yate deku dunyansale waariyamunaae de katik tésékéyakngé daré. Guné wunat wangunén pulak, Satan déku kém yaange yéndarénngé wandu de katik tésékéyakngé daré. Satan wunga jémbaa yamba yandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Guné wunéké ani kundi wangunéngwa. Kutakwana néma du, Belsebul wuna mawulémba téte wa wunat mayé apa tiyaandéka wawutéka wa kutakwasé yaange yéndakwa. Naangunéngwa. Wan papukundi wa wangunéngwa. Guna du ras de waak wandaka kutakwa yaange yéndakwa. Guna du wunga yandaka guné det anga yamba wangunéngwe, ‘Belsebul guna mawulémba téte mayé apa kwayéndéka wa wangunénga kutakwasé yaange yéndakwa.’ Det wunga wakapuk yate kamuké guné wunat wani kundi wo? Wuné dele nakurak jémbaa yawutéka de wa vékusékndakwa. Guné wunéké papukundi wa wangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma véku. Gotna Yaamambi wuna mawulémba téte wunat mayé apa tiyaandékwa. Tiyaandéka wuné kutakwat wawutéka wa yaange yéndakwa. Guné wani musé véte anga vékusék-ngangunéngwa. Got néma du rate du dakwaké yékunmba véké yandékwa sapak wa yaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ani kundi ma véku. Du nak mayé apa yakwa duna gaamba wulaae déku musé baka kéraamuké, taale wani duwat kure jorikat gikandékwa. Gitake déku gaamba wulaae déku musé baka kéraakandékwa. Wani kundiké ma vékulaka. Satan dé wani mayé apa yakwa du pulak wa. Wuné wani duwat jorikat gikwa du pulak a. Wuna mayé apa Satanna mayé apat wa taalékéran. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wunale jémbaa yakapuk yakwa du dakwa de wuna maama wa téndakwa. Wuné du dakwat wawutéka de wuna kémba téndakwa. Wuna du dakwat yékun yakapuk yakwa du dakwa de wuna du dakwat yaavan kutndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Wani muséké vékulakate gunat wawutékwa. Du dakwa kapérandi musé ye wani kapérandi muséké kalik ye yaasékandaru, wa Got yandarén kapérandi musé yasnyéputi-kandékwa. Du dakwa kapérandi kundi watake wani kapérandi kundiké kalik ye yaasékandaru, wa Got wani kapérandi musé yasnyéputi-kandékwa. De wasélékte kapérandi kundi Gotna Yaamambiké wamunaandaru, wa Got wani kapérandi musé katik yasnyéputiké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wuné Duna Nyaan, du dakwa wunat wasélékte wunéké kapérandi kundi watake wani kapérandi kundiké kalik ye yaasékandaru, wa Got wani kapérandi musé yasnyéputi-kandékwa. De wasélékte Gotna Yaamambiké kapérandi kundi wamunaandaru, wa Got wani kapérandi musé katik yasnyéputiké dé. Bulaa katik yasnyéputiké dé. Kukmba sérémaa sérémaa waak katik yasnyéputiké dé.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wani kundi watake Jisas det anga wandén, “Yéku miyémba yéku sék vaakundakwa. Kapérandi miyémba kapérandi sék vaakundakwa. Nané miyé sékét véte wa vékuséknangwa, yéku miyé, kapérandi miyéké waak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Guné Farisi dunyan, guné duwat tikwa kaambe pulak wa yaténgunéngwa. Guné kapérandi mawulé male vékungunéngwa. Yate yéku kundi yénga pulak bulké guné? Du dakwa deku mawulémba vékulakate wa kundi bulndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yéku mawulé vékukwa du dakwa de yéku musé yate yéku kundi bulndakwa. Kapérandi mawulé vékukwa du dakwa de kapérandi musé yate kapérandi kundi bulndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ma véku. Gunat wawutékwa. Got néma kot vékute néma du randa nyaa akwi du dakwat Got waatakundu de bulndarén néma kundi, bulndarén baka kundi, bulndarén akwi kundi dat waambule kaatakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kukmba guna kundi akwi vékutake rasét wakandékwa, ‘Guné yéku musé yakwa du wa.’ Watake rasét wakandékwa, ‘Guné kapérandi musé yakwa du wa.’ Got wunga wakandékwa.” Jisas Farisi dunyansat wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wani kundi wandéka apakundiké vékusékngwa du ras, Farisi du ras de wunga Jisasét wandarén, “Néma du, nané vékapuk yananén kulé apanjémba nak yaménu véké mawulé yanangwa. Méné yaménu nané ve vékusék-nganangwa. Got wandéka wa yaaménén. Wunga vékusék-nganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wunga wandaka det wandén, “Ani sapakmba yatékwa du dakwa kapérandi musé yatépékandakwa. De Gorét wa kuk kwayéndarén. Wunat wangunén kulé apanjémba katik yaké wuté. Gotna yémba kundi kwayétan du Jona talimba yandén pulak male yakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Talimba Jona gaan kupuk nyaa kupuk néma gukwamina biyaamba kwaandén pulak, wuné Duna Nyaan rémngé yandakwa kwaawumba gaan kupuk nyaa kupuk kwaakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Talimba Ninivemba tan du dakwa Jonana kundi vékutake yandarén kapérandi musé yaasékandarén. Jona néma du téndéka wuné amba téte kundi bulkwa du wuné néma du téte Jonat wa taalékérawutén. Kukmba Got néma kot vékute néma du randa sapak Ninivemba tan du dakwa waarape Gotna ménimba téte wakandakwa, ‘Jona nanat Gotna kundi kwayéndéka nané vékute yananén kapérandi musé yaasékatake Gotna kundi yékunmba vékunanén. Jisas Jonat taalékére gunat Gotna kundi wandéka guné yangunén kapérandi musé yaasékatake Gotna kundi yamba vékungunéngwe. Wunga yate guné néma kapérandi musé wa yangunén.’ Wunga wakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Talimba néma taakwa nak, ani sékaa taalémba yaae néma du Solomonna kundi vékuké yaambumba kulémba yélén. Dé nyaangét vékupukaakwa du téndéka wuné amba téte gunale kundi bulkwa du wuné nyaanngét vékupukaakwa du téte Solomonét wa taalékérawutén. Kukmba Got néma kot vékute néma du randa sapak wani néma taakwa waarape Gotna ménimba téte gunat wakalékwa, ‘Wuné sékaa taalémba yaawutén. Yaae Solomonna kundi vékuwutén. Jisasna kundi Solomonna kundit wa taalékéran. Guné Jisasna kundi yamba vékungunéngwe wa. Wunga yate néma kapérandi musé wa yangunén.’ Naakalékwa wani taakwa.” Jisas wunga wandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wani kundi watake Jisas det anga wandén, “Ani kundi ma véku. Kutakwa ye nak duna mawulémba wulaae te yaasékatake yélén. Maas viyaakapuk yakwa taalémba yeyé yaayate taaléké waaklén lé ramuké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Waakpatiye walén, ‘Wuné talimba rawutén gaat waambule yékawutékwa.’ Wunga watake waambule ye vélén wani duna mawulé yékun ye baka téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vétake ye kutakwa taambak kaayék vétik (7) we kure yaalén. Kukmba kure yaalén kutakwasé yan kapérandi musé wa taale yaan kutakwa yan kapérandi musat taalékéran. Wani kutakwa akwi wani duna mawulémba wulaae téndarén. Talimba nak kutakwa déku mawulémba wulaae téléka ayélapkéri kapérandi musé yandén. Rékaamba kutakwa déku mawulémba wulaae téndaka wani du némaamba kapérandi musé yandén. Wani kundiké ma vékulaka. Némaamba kapérandi musé yan du yatan pulak, bulaa yatékwa du dakwa wunéké yékunmba vékulaka-kapuk yate baka yatéte némaamba kapérandi musé yakwa du dakwa wa tékandakwa.” Det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas du dakwat wayéka kundi kwayéténdéka déku aasa, déku waayékanje waak ye kaapamba téndarén. Téte dale kundi bulké mawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yandaka du nak wa wulaae Jisasét anga wandén, “Ma véku. Ména aasa, ména waayékanje yaae kaapamba téte ménale kundi bulké mawulé yandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wunga wandéka Gotna kémngé det yakwasnyéké mawulé yate dat wandén, “Wuna aasa waayékanje yénga pulak daré?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wunga watake déku dunyansat déku taambat wakwasnyéte wandén, “Ma vé. An wuna aasa, wuna waayékanje a. ");
INSERT INTO abt_wosera_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Anjorémba rakwa du wuna aapa déku kundi vékute wandékwa pulak yakwa du dakwa wan wuna waayékanje, wuna nyangengu, wuna aasa pulak wa yaténdakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wani nyaa Jisas kundi wasékéyaktake gaa taakatake néma gu kwaawut yéndén. Ye néma gu kwaawu tékwanmba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Randéka némaamba du dakwa wa yaae dé ranmba jaawundarén. Jaawundaka, de déku kundi yékunmba vékundarénngé mawulé yate, wa botmba waare néma gu kwaawumba awulaka yépulak naae randén. Randéka du dakwa néma gu kwaawu aarkémba tékéséndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Téndaka det késépéri gwaaménja kundi wandén. Taale det anga wandén: “Du nak déku yaawimba wit sék yaasnyéké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye yaasnyéndéka wit sék ras yaambumba vaakétndarén. Vaakére baka randaka api wa yaae kéraae akwi kawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wit sék ras matuale ran ayélap képmaamba vaakérén. Vaakére bari buréle waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Waaréndaka néma nyaa véndéka méngi kurkale kurkapuk ye rékaa ye kiyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit sék ras raamény waara ténmba vaakérén. Vaakére randaka raamény waara wa wure waare taakatépan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wit sék ras yéku képmaamba vaakérén. Vaakére wamba re yékunmba wuréndarén. Wure waare yéku sék vaakundarén. Ras sék ayélap (30) vaakundarén. Ras rékaamba (60) sék vaakundarén. Ras némaamba (100) sék vaakundarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisas wunga watake wandén, “Guné vékusékngé mawulé ye kurkasale waan taake kurkale vékwe wa vékusék-ngangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wani kundi wandéka Jisasna dunyan yaae dat wandarén, “Kamuké méné det gwaaménja kundi wo? Méné det gwaaménja kundi wapékaté-ménénga wa de ména kundi kurkale vékuké yapatindakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wunga wandaka det wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Véndu de déku kémba tékandakwa. Wani muséké talimba Got paakundén kundi wa. Paakutake bulaa yi naandékwa, guné wani muséké vékusékngunénngé. Nak du dakwa katik vékusékngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yéku mawulé vékukwa du dakwa wuna kundi vékundakwa. Wuna kundi yékunmba vékukwa du dakwa kukmba Gotna akwi kundiké yékunmba vékusék-ngandakwa. Wuna kundi yékunmba vékukapuk yakwa du dakwa wandakwa, ‘Nané Gotna kundi vékuséknangwa.’ Wunga watake kukmba déku kundiké yékéyaak yate baka yatékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wani du dakwa deku ménimba véndarén muséké yamba yékunmba vékusékndakwe wa. Wani du dakwa deku waanmba vékundarén kundiké yamba yékunmba vékusékndakwe wa. Yandaka wa det gwaaménja kundi wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Deké Gotna yémba kundi kwayétan du Aisaia talimba Gotna nyéngaamba viyaatakandén kundi bulaa wa sékérékén. Got wandéka Aisaia du dakwaké déku kundi anga viyaatakandén: Guné wuna kundi vékute wani kundiké katik vékusékngé guné. Véte yékunmba katik vésékngé guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wunga watake wa Got Aisaiat wandén: Wani du dakwa wuna kundi vékusékmuké kalik yandaka wa deku mawulé kapére yandékwa. Deku waan wa kétaaktépéndarén. Deku méni wa kusndarén. De wuna kundi vékusékngé mawulé yamunaae, wa wuna kundi vékusékngatik daré. Deku waan kuttépékapuk yamunaae, wa yékunmba vékukatik daré. Deku méni laamunaae, wa yékunmba vékatik daré. Wunga yamunaae, wa wuna kundi yékunmba vékundaru wa det kururékatik wuté. Got deku mawuléké Aisaiat wunga wandén. Wandéka Aisaia déku kundi déku nyéngaamba viyaatakandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wunga watake Jisas déku dunyansat wandén, “Guna mawulé wan deku mawulé pulak yamba wa. Got gunat wa yékun yandén. Yandéka guna mawulé yékun wa tékwa. Téndéka guné yékunmba véte, yékunmba vékute, kurkale vékusékngunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ani kundi ma véku. Gotna yémba kundi kwayétan némaamba dunyansé, Gotna némaamba du dakwa ras waak, talimba yatéte a yawutéka véngunéngwa jémbaa véké néma mawulé yate de yamba véndakwe wa. De wawutéka a vékungunéngwa kundi vékuké néma mawulé yate de yamba vékundakwe wa. Yi wan wanana wa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wani kundi watake Jisas anga wandén, “Wit sék yaasnyan duké wawutén gwaaménja kundiké wawutu guné vékuké ya. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Got néma du rate du dakwaké yékunmba véké yandékwa kundi, wani kundi du dakwa ras baka vékundakwa. Vékute de wani kundiké yamba yékunmba vékusékndakwe wa. Wani du dakwa wan yaambumba vaakérén wit sék pulak wa. De taale wani kundi yékunmba vékundakwa. Vékundaka Satan yaae wani kundi kéraae kure yéndékwa. Yéndéka wa wani kundiké yékéyaak yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Du dakwa ras matuale ran képmaamba vaakérén wit sék pulak wa. De wani kundi bari vékundakwa. Vékute taale wani kundiké mawulé yate mawulé tawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yate yamba yékunmba vékulakandakwe wa. Wani kundi deku mawulémba daawulikapuk yandéka de yamba yékunmba vékulakandakwe wa. Yandaka wa nak du Gotna kundiké kalik yate det yaavan kutndaka kapérandi musé ras deké yaandéka wa Gotna kundi bari yaasékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Du dakwa ras wan raamény waaramba vaakérén wit sék pulak wa. De Gotna kundi taale yékunmba vékundakwa. Vékute ani képmaana muséké male vékulakate yéwaa, musé asé kéraaké vékundakwa. Wani musé wa Gotna kundit taakatépékwa. Taakatépéndéka wani du dakwa Gotna jémbaa yaasékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Du dakwa ras wan yéku képmaamba vaakérén wit sék pulak wa. De Gotna kundi yékunmba vékute, wandékwa pulak yate, déku kundi yékunmba vékusékndakwa. Vékusékte yéku jémbaa yandakwa déké. Ras déké yéku jémbaa ayélapkéri yandaka, de ras déké yéku jémbaa némaamba yandaka, de ras déké yéku jémbaa némaamba-sékéyak yandakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wani kundi watake Jisas gwaaménja kundi nak waak anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa anga. Du nak déku yaawimba yéku wit sék yaasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yaasnyéndéka du dakwa gaan yundé kwaandaka wani duna maama yaae kapérandi waara jé yéku wit sékna nyéndémba yaasnyétake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yéndéka kukmba wit sék buréle waare sék vaakuké yandéka véndarén kapérandi waara wani wirale téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vétake jémbaa yakwa dunyan ye wani yaawina duwat wandarén, ‘Néma du, talimba méné yéku wit sék wa yaasnyéménén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yénga pulak ye dé wani kapérandi waara jé waaréto?’ Wunga wandaka det wandén, ‘Nana maama nak wa yaae wani musé yan.’ Wunga wandéka de jémbaa yakwa dunyan dat wandarén, ‘Wani kapérandi waara pélnanénngé méné mawulé yo?’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wunga wandaka det wandén, ‘Yamba wa. Kapérandi waara pélte ras yéku wirale ka pélnguna. Kapérandi waara katik pélké guné. Baka tékwak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yéku wit kapérandi waarale véréti yénga waarétémbéru. Waare sék vaakumbéru wit sék sékuké yakwa dunyansat anga wakawutékwa, “Taale wani kapérandi waara pélte guné tayémba paatéké ya. Paatétake guné yaamba tuké ya. Yatake wit sékwe wuna kakému taakawutékwa gaamba guné taakaké ya.” Wunga wakawutékwa wit sékuké yakwa duwat.’ Naandén.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Wani kundi watake Jisas kundi nak waak anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwa taale makalkéri kém tékandakwa. Kukmba néma kém tékandakwa. Wani kém wan miyé nakna sék pulak wa. Wani miyé sékna yé mastet wa. Mastet sék nak miyé sék pulak yamba wa. Wani miyé sék wan makalkéri sék wa. Nana képmaamba tékwa akwi nak sék wan némaan wa. Du nak wani miyé sék kéraae yaawimba taawundén. Taawundéka bari waare némaan ye wani yaawimba tékwa miyat taalékérandén. Néma miyé téndéka api yaae wani miyé gaalémba kwaat séte randarén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wani kundi watake nak kundi anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwa kulémawulé kéraate kulé du dakwa wa yaalakandakwa. Wani du dakwa wan yis pulak wa. Taakwa nak yis kéraae plauale kulotlén. Kulotléka wani plaua nak pulak yaalandén. Nak pulak yaalan pulak, Gotna du dakwa kulé du dakwa yaalakandakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas késépéri gwaaménja kundi du dakwat wandén. Kundi det kaapamba yamba wandékwe wa. Gwaaménja kundimba male det wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Det gwaaménja kundi wunga wandéka Gotna yémba kundi kwayétan du nakna kundi wa sékérékén. Wani du talimba Gotna nyéngaamba Jisaské anga viyaatakandén: Wuné gwaaménja kundi det wakawutékwa. Talimba Got képmaa yandén sapak déku kundi ras paakundén wa. Paakutakandéka ran kundi bulaa a wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas jaawuwe tékésén du dakwa yaasékatake gaamba nak wulaandén. Wulaandéka déku dunyansé déké wulaae dat wandarén, “Wani kapérandi waaraké gwaaménja kundi waménén. Bulaa wani muséké ma waménu nané kurkasale vékusék-nganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wunga wandaka Jisas det wandén, “Yéku wit sék yaasnyan du wan wuné wa. Wuné Duna Nyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wani yaawi wan képmaamba tékwa akwi gaayé wa. Yéku wit sék wan Gotna kémba yaalan du dakwa wa. Kapérandi waara wan Satanna du dakwa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kapérandi waara yaasnyan du wan Satan wa. Wit sékundakwa sapak wan kuksékéyakmba yaaké yakwa sapak wa, ani képmaa késna sapak wa. Wit sékukwa dunyan wan Gotna kundi kure gaayakwa dunyan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kapérandi waara péle yaamba tundara pulak, kukmba ani képmaa késna sapak, de kapérandi musé yakwa du dakwat wunga yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wuné Duna Nyaan wuné wawutu wuna kundi kure gaayakwa du akwi genge gaayémba yéte Gotna du dakwale téte kapérandi musé yakwa du dakwat kéraakandakwa. Akwi kapérandi musé, du dakwana mawulé yaavan kurkwa akwi musé waak kéraakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kéraae de wani du dakwa, wani kapérandi musé waak néma yaamba vaanjanda-kandakwa. Vaanjandandaru kapérandi musé yan du dakwa wani yaamba yaante de néma kaangél vékukandakwa. Vékute géraakandakwa. Yéku taalémba raké mawulé yate némaamba géraakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wani sapak Gotna du dakwa dale rakandakwa, déku gaayémba. Deku aapa Got pulak wa rakandakwa. Rate de nyaa véte kaalékwa pulak wa rakésékandakwa. Guné vékusékngé mawulé ye kurkale waan taake ma yékunmba vékungunék.” Jisas wunga wandén déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wani kundi watake anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwa déku kémba yaalakandakwa. Déku kémba raké yandakwa yapaté wan néma musé wa. Du dakwa wunga raké néma mawulé yakandakwa. Yandaru deku mawulé ani duna mawulé pulak wa tékandékwa. Wani du ye yaawimba nak véndén, némaamba yéwaa paakwe rémtépé-takandaka téndéka. Vétake mawulé tawulé yate, wani yéwaa kéraaké néma dusék yandén. Yatake nakapuk rémtépétake ye déku musé akwi kwayéte yéwaa kéraae wani yéwaat kwayéte némaamba yéwaa véndén yaawi kéraandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wani kundi watake Jisas anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwa déku kémba yaalakandakwa. Déku kémba raké yandakwan wan néma musé wa. Du dakwa wunga raké néma mawulé yate nak muséké katik vékulakaké daré. Yandaru deku mawulé ani duna mawulé pulak tékandékwa. Du nak déku jémbaa yate kusondakwa yéku gaaviké waakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Waake yéku gaavi nak vétake wani gaavi kéraaké néma mawulé yandén. Yate nak muséké vékulakakapuk yate déku musé akwi kwayéte némaamba yéwaa kéraandén. Kéraae wani yéwaat akwi kwayétake wani yéku gaavi kéraandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Wani kundi watake Jisas nak kundi anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwa déku kémba rakandakwa. Kukmba déku du dakwa déku kémba yaalakapuk yan du dakwat waak anga pévukandékwa. Kukmba ani du yandarén pulak yakandékwa. Du nak aaswut néma gu kwaawumba taawutakandéka kwaandéka késpulak nakpulak gukwami wa wulaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wulaandaka aaswut vékulékndéka wutépét témbétsondarén. Témbétsotake rate gukwami pévundarén. Péve yéku gukwami kéraae dismba taakandarén. Taakate kapérandi gukwami vaanjandandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Kukmba ani képmaa késkwa sapak Got wandu déku kundi kure gaayakwa dunyan wunga yakandakwa. De gaaye Gotna du dakwale téte kapérandi musé yakwa du dakwat kéraae néma yaamba vaanjanda-kandakwa. Vaanjandandaru kapérandi musé yan du dakwa wani yaamba yaante néma kaangél vékukandakwa. Vékute géraakandakwa. Yéku taalémba raké mawulé yate némaamba géraakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wani kundi watake Jisas det anga waatakundén, “Guné wani kundiké akwi guné kurkasale vékusékék?” Wunga waatakundéka wandarén, “Yi. A vékuséknangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wunga wandaka det wandén, “Apakundiké vékusékngwa du wuna jémbaamba yaale de néma gaana du pulak wa. Dé déku gaamba wulaae talimba taakandén musale kulé musé waak kure yaandékwa. Kure yaandékwa pulak, de deku mawulémba vékute talimba vékundarén kundi, Gotna kémngé kulé kundi waak kwayéndakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wani kundi watake Jisas wani gaayé taakatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ye déku gwalepangemba saambake Gotna kundi bulndakwa gaamba du dakwat Gotna jémbaaké yakwasnyéndén. Yakwasnyéndéka de vatvat naate wandarén, “Yéki. Yénga pulak dé wani muséké vékusékék? Yénga pulak ye dé talimba vékapuk yananén kulé apanjémba yo? ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dé gaa kurkwa duna nyaan wa. Déku aasa wan Maria wa. Déku waayékanje wan Jems, Josep, Saimon, Judas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Déku nyangengu akwi nanale yaréndakwa. Dé néma du yamba yé wa. Wa baka du wa. Wunga vékuséknangwa. Yamba dé wani kundi kéraak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wunga watake déku mayé apaké vékusékngapuk yate déké kalik yandarén. Yandaka Jisas det anga wandén, “Gotna yémba kundi kwayékwa duké de nak gaayé du dakwa wa wakwa, ‘Wan néma du wa. Dé yéku jémbaa wa yandékwa.’ Wunga wandaka déku kém déku gwalepangemba tékwa du dakwa waak déké wandakwa, ‘Wan baka du wa. Nané pulak du wa.’ Wunga wandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jisasna gwalepangemba tékwa du dakwa déké yékunmba vékulakakapuk yandaka Jisas wani gaayémba du dakwa talimba vékapuk yandarén kulé apanjémba némaamba yamba yandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wani sapak Galilimba tékwa du dakwana néma du déku yé Herot Jisaské wandaka vékundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Vékute déku jémbaa yakwa dunyansat wandén, “Wani du wan baptais kwayékwa du Jon wa. Talimba wawutéka déku kumbu sékundarén. Sékundaka kiyaae bulaa nakapuk taamale wa waarapndén. Taamale waarape néma mayé apa kéraae wani apanjémba yandékwa.” Naandén Herot. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Talimba Herot déku aanyé Filipna taakwa kéraandén. Wani taakwana yé Herodias. Kéraandéka Jon dat wandén, “Ména aanyé wunga randéka déku taakwa kéraaménén wan sépélak yaménén. Got wani muséké watépéndékwa.” Wunga wandéka Herodias Jonna kundiké kalik yate waléka Herot léku kundi vékute wandéka déku dunyan yaae Jonét kulkiye senét giye dé kalapusét kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kure ye taakandaka kalapusmba kwaandéka Herot dat viyaandékngé mawulé yandén. Yandéka Juda du dakwa wa wan, “Jon wan Gotna yémba kundi kwayékwa du wa.” Wunga wandaka Herot Jonét viyaandékmuké wup yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nak nyaa du ras yaae Herorale jaawuwe rate Herotna aasa dé kéraalén nyaaké vékulakate kakému karéndarén. Karéndaka Herodiasna takwanyan yaae wani dunyanséna ménimba téte kétilén. Kétiléka Herot véte néma mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yate lat wandén, “Musé ras kwayéwuténngé mawulé yanyénu wani musé kwayékawutékwa. Wawutén pulak yakawutékwa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wunga wandéka ye léku aasat walén, “Dé wunat musé nak tiyaaké wandékwa. Kamu muséké waké wuté?” Wunga waléka léku aasa Jon talimba wandén kundiké wayéka kalik yapékaréte walén, “Baptais kwayékwa du Jon, déku maaka. Wunga kéraanyénu kiyaandénngé vékusék-ngawutékwa.” Naaléka léku takwanyan yaae Herorét walén, “Baptais kwayékwa du Jonna kumbu sékwe amba dismba ma taake wunat tiyaaménék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wunga waléka Herot wunga yamuké kalik yate vékulaka vékulaka naandén. Takamba kundi we gite wa wakakét yandén. Yi wan wanana wa naandén. Naandéka dale rate kakému karan dunyan wa vékundarén. Wandén kundiké vékulakate, nak kundi wamuké kalik yate wa yi naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Naatake wandéka déku du ye kalapusmba wulaae Jonna kumbu sékundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sékwe maaka dismba taake wani takwanyanét kure ye kwayéndarén. Kwayéndaka kure ye léku aasat kwayélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wunga yandaka Jonna dunyansé yaae déku pusaa kéraae kure ye rémndarén. Rémtake ye Jisasét wani muséké saapéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas wani kundi vékutake wani gaayé taakatake botmba waare du yarékapuk taalat yéndén. Dé kapmang yéndén, botmba. Yéndéka du dakwa déké kundi vékutake deku gaayé taakatake képmaamba dé yénét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yéndaka Jisas néma gu kwaawu wutépét yaae bot taakatake véndén némaamba du dakwat. Vétake deké sémbéraa yate baat yan du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalésat waak kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Garambu yandéka Jisasna dunyansé déké yaae dat wandarén, “Garambu a yakwa. An du yarékapuk taalé a. Ma waménu ani du dakwa gaayét yéndaru. Ye deku kakému kéraakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wunga wandaka det wandén, “De yéndarénngé wuné katik waké wuté. Guné det kakému ma kwayéngunék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naandéka wandarén, “Nané némaamba kakému yamba yé wa. Makal bret taambak, gumba kutndarén gukwami vétik wunga male rakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naandaka wandén, “Ma kure yaa wunéké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wunga wandéka kure yéndaka wamba tékésén du dakwat wandén, waaramba randarénngé. Wandéka randaka makal bret taambak gukwami vétik kéraae kure téte nyérét yaasawure véte Gorét wandén, “Yéku musé a tiyaaménén. Wan yékun wa.” Naatake bret bule déku dunyansat kwayéndén. Kwayéndéka du dakwat muni waate kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kwayéndaka akwi du dakwa kurkale kandarén. Kandaka bret ras baka randéka Jisasna dunyansé kémbi tambavétik maanmba kaayék vétik (12) wunga laakwandaka vékulékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wani bret kan du wan 5,000 pulak wa. Némaamba dakwa nyambalé waak wa wamba rate kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisasna dunyansé wunga yandaka Jisas det wandén, “Guné botmba waare ma taale yéngunék, néma gu kwaawuna nak sakwat.” Wunga wandéka déku dunyansé yéndaka wani du dakwat wandén, deku gaayét yéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wandéka de yéndaka dé kapmang némbat waaréndén Gorale kundi bulké. Waare nyaa daandéka dé kapmang randén némbumba. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Randéka déku dunyansé yén bot ye néma gu kwaawu nyéndémba téndéka wimut kutndéka bot némaamba waaré daan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yandéka yé gérké yaténdéka Jisas gutakumba déku dunyanséké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yéténdéka dat véte bérundarén. Bérute wandarén, “Wan gaamba wa yaatékwa.” Wunga wate néma wup yate némaanmba waawakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Waawakndaka Jisas det bari wandén, “An wuné a yaatékwa. Guné wup yaké yambak. Yéku mawulé vékute ma yaréngunék.” Naandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wani kundi wandéka Pita Jisasét anga wandén, “Néman Du, wan méné yaatéménan, wunat ma waménu wuné gutakumba ménéké yaakawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Naandéka wandén, “Méno, ma yaa.” Wunga wandéka bot yaasékatake daawuliye gutakumba baasnyé ye ye Jisas ténét yéké yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yate wimut kutndéka néma gu waarapndéka véte wup yandén. Wup ye gumba daawuliké yandén. Yate waandén, “Néman Du, wuné ma kut.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wunga wandéka dat bari kutte wandén, “Kamuké méné ména mawulémba anga wak, ‘Jisas wuné kurké dé mayé apa yo kapuk?’ Wunga wambak. Wunéké ma yékunmba vékulaka.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wunga watake dat kure ye botmba waarémbéréka wimut késén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Késndéka botmba ran dunyansé déku yé kavérékte wandarén, “Méné Gotna nyaan wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas déku dunyansale néma gu kwaawu nak sakwat botmba ye Genesaretna taalémba saambakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Saambakndaka wani gaayémba yatékwa du dakwa Jisaské vékusékndarén. Vékusékte wani taalémba tékwa du dakwat kundi wasatindaka de baat yan du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalé waak kure yéndarén Jisaské. ");
INSERT INTO abt_wosera_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kure yéndaka deku mawulémba wandarén, “Nané déku sépémba kure wa yékun yakanangwa. Déku sépémba kurké yapatiye déku laplapmba male kutnanan wa yékun yakanangwa.” Wunga wate Jisasét wandarén, “Méné yi naaménu nané ména laplapna waambumba male kurkanangwa.” Wunga watake déku laplapmba kure wa yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wani sapak Farisi dunyan ras, apakundiké vékusékngwa dunyan ras, wunga Jerusalem taakatake Jisasale bulké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ye dat wandarén, “Nana gwaal waaranga maandéka bakamu anga wandarén, ‘Kakému kaké yate taale wananén pulak guna taamba kurkasale ma yakwasnyéngunék. Wunga yatake guné Gotna ménimba yékunmba yatékangunéngwa.’ Wunga wandaka nané kakému kaké yate taale nana taamba wandarén pulak kurkale yakwasnyénangwa. Kamuké daré ména dunyan nana gwaal waaranga maandéka bakamu wan kundi vékukapuk yo? De kaké yate taale deku taamba nana gwaal waaranga maandéka bakamu wandarén pulak yamba kurkale yakwasnyéndakwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wunga wandaka det wandén, “Guné yénga pulak dé? Kamuké guné guna gwaal waaranga maandéka bakamuna kundi male vékute Gotna kundiké kuk kwayu? ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Got anga wandén, ‘Guné guna aasa aapat ma yékun ya.’ Wunga watake anga waak wandén, ‘Du nak déku aasa aapaké kapérandi kundi bulndu guné wani duwat ma viyaangunu yénga kiyaandu.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wunga wandéka guné Gotna kundiké kuk kwayéte nak kundi wangunéngwa. Anga wangunéngwa, ‘Du nak déku aasa aapat anga wandu, “Ani musé Gorét kwayéwutén. Gorét kwayékapuk ye bénat kwayékatik wuté. Bénat yékun yaké yapatiwutékwa.” Wunga watake déku aasa aapat yékun yakapuk yandékwan wan yékun wa. Wa Gorét wa kwayéndén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Guné wunga wate guna gwaal waaranga maandéka bakamuna kundi vékute Gotna kundiké kuk kwayéngunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Guné paapu yakwa du wa. Talimba Gotna yémba kundi kwayétan du Aisaia wa wandén gunéké. Anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Got wa wandén, ‘Ani du dakwa wunéké yéku kundi wandakwa. Wunga wate wunéké deku mawulémba yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","De deku apakundi vékute wandékwa pulak yate wani kundiké wandakwa: Wan Gotna kundi wa. Wunga wate wuna yé kavérékte baka kundiké wa bulndakwa.’ Naandén. Got wunga wandéka wa Aisaia viyaatakandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wani kundi watake Jisas du dakwat waandéka yaandaka det anga wandén, “Guné wuna kundi ma yékunmba véku. Vékute ani muséké ma yékunmba vékusék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kangunéngwa muséké vékulakate Got katik waké dé, ‘Guné kapérandi musé yakwa du dakwa wa.’ Yamba wa. Bulngunéngwa kapérandi kundiké vékulakate Got anga wakandékwa, ‘Guné kapérandi musé yakwa du dakwa wa.’ Wunga wakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wunga wandéka déku dunyansé yaae dat wandarén, “Farisi dunyan waménén kundiké kalik yandarén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wunga wandaka Jisas ani gwaaménja kundi wandén, “Anjorémba rakwa du wuna aapa néma yaawi nak yandén. Ye némaamba miyé taawundén wani yaawimba. Taawukapuk yandéka baka wure waaran miyé wa méngiale pélkandékwa.” Farisi dunyanséké wa wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Watake anga wandén, “Guné Farisi dunyanséké vékulakaké yambak. De méni kiyaan du pulak wa yaténdakwa. Méni kiyaan du nak, nak méni kiyaan duwat yaambu wakwasnyéké mawulé ye, wa bét ye véréti kwaawumba vaakérkambérékwa. Yandékwa pulak wa Farisi dunyansé nak duwat Gorké yéndakwa yaambu wakwasnyéké yapatindakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wunga wandéka Pita dat wandén, “Kanangwa muséké waménén gwaaménja kundiké nanat waménu nané wani kundiké kurkale vékusék-nganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wunga wandéka wandén, “Guné waak wani kundiké yamba vékusék-ngunéngwe kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma véku. Du dakwa kandakwa musé deku biyaat daawuliye tété naae wa yéndékwa. Kandakwa musé deku mawulé yamba yaavan kutndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bulndakwa kundi taale du dakwana mawulémba téndékwa. Du dakwana mawulémba yaalakwa muséké vékulakate wa Got wakandékwa, ‘Wan kapérandi musé yakwa du dakwa wa.’ Naakandékwa. Ani muséké vékusékte wunga wakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Du dakwana mawulémba kapérandi mawulé yaalandékwa. Yaalandéka kapérandi mawulé vékundakwa, du dakwat viyaandékndakwa, dunyan nak duna taakwat kéraandakwa, dakwa nak taakwana duké yéndakwa, du dakwale kapérandi musé yandakwa, dakwa duwale kapérandi musé yandakwa, sél yandakwa, papukundi wandakwa, nak du dakwaké kapérandi kundi wandakwa, wunga kapérandi musé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wani kapérandi mawulé du dakwana mawulémba wa yaalandékwa. Yaalandéka wa wani kapérandi musé yandakwa. Kapérandi musé yandaka Got deké wandékwa, ‘Wan de kapérandi musé yakwa du dakwa wa.’ Wunga wate yandarén kapérandi mawuléké vékulakandékwa. De gwaal waaranga maandéka bakamuna kundi vékukapuk yate deku taamba yékunmba yakwasnyékapuk yandarénngé yamba vékulakandékwe wa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wani kundi watake Jisas déku dunyansale de wani gaayé taakatake nak taalat yéndarén. Tair béré Saidon tékwa taalat yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yéndaka Kenanmba yaan taakwa nak yaalén. Lé Juda taakwa yamba wa. Nak gaayémba yaan taakwa wa Jisaské yaalén. Yaae némaamba waate walén, “Néman Du, méné Devitna gwaal waaranga maandéka bakamu wa yatéménéngwa. Méné wunéké ma sémbéraa yaménu. Kutakwa nak wuna takwanyanna mawulémba wulaae téte lat yaavan kutlékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wunga waléka Jisas lale kundi nak yamba bulndékwe wa. Yandéka déku dunyansé dat wandarén, “Ani taakwa a nana kukmba yaate némaanmba waalakét yaalékwa. Ma waménu léku gaayét yélu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Wunga wandaka wani taakwat wandén, “Israel du dakwa wan de sipsip deku mawulé yékéyaak yandéka baka yeyé yaayandakwa pulak wa. Got wandéka wuné det male yékun yaké yaawutén. Nyéné nak gaayé taakwa wa. Israel taakwa yamba wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wunga wandéka yaae dat kwaati se waandé daate walén, “Néman Du, wunat ma yékun yaménu.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wunga waléka déku mawulémba wandén, “Nané Juda nak gaayé du dakwaké, ‘Waasa wa,’ naate nana du dakwaké, ‘Nyambalé wa,’ naanangwa.” Wunga watake ani gwaaménja kundi lat wandén, “Nané nyambalé kakwa kakému kéraae waasat ka kwayénana.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wunga wandéka walén, “Néman Du, yi wan wanana wa. Wuné anga wawutékwa. Nyambalé kakému kandaka ras képmaamba vaakétndéka deku waasa kéraae kandakwa. Méné wunat yékun yaménu wan yékun wa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wunga waléka wandén, “Wuné nyéna takwanyanét yékun yaké apamama yawutékwanngé wate nyéné wunéké yékunmba vékulaka-nyénéngwa. Wan yékun wa. Mawulé yanyénéngwa musé bulaa yakawutékwa.” Naandén. Wunga wandén sapak male wa léku takwanyan yékun yalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas wani gaayé taakatake képmaamba yéndén. Galilina néma gu kwaawu tékwanmba yéndén. Ye némbumba waare randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Randéka némaamba du dakwa déké yaandarén. Maan kapére yan du dakwa nyambalé, méni kiyaan du dakwa nyambalé, apa rangwa yan du dakwa nyambalé, kundi bulkapuk du dakwa nyambalé, sépémaalé kapére yan némaamba du dakwa nyambalé ras waak, wani du dakwa nyambalé akwi kéraae yaate Jisaské yaandarén. Yaae wani du dakwa nyambalé Jisasna maanale taakandarén. Taakandaka det kuruwuréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kururéndéka wamba rakésén du dakwa véndarén. Kundi bulkapuk yan du dakwa nyambalé nakapuk kundi bulndarén. Apa rangwa yan du dakwa nyambalé deku apa kayéndéng tén. Maan kapére yan du dakwa nyambalé yeyé yaayandarén. Méni kiyaan du dakwa nyambalé nakapuk véndarén. Wunga yékun yandaka vétake vékulaka vékulaka naandarén. Wunga yate wandarén, “Israelna néma du Got det wa kurkale yandén.” Naandarén. Wunga wate wa Gotna yé kavérékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Némaamba du dakwa wamba téndaka Jisas déku dunyansat waandéka yaandaka det anga wandén, “Wuné wani du dakwaké sémbéraa yawutékwa. Nyaa kupuk wa wunale amba randarén. Deku kakému wa kawuréndarén. Wa kaandale randakwa. De kaandale re deku gaayét yéndarénngé wamuké kalik yawutékwa. Kaandale ye yaambumba kiyaakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wunga wandéka déku dunyan dat wandarén, “Ani taalémba du ras yamba yare wa. Wani du dakwa wan némaamba wa. Yamba bret ras kéraae wani du dakwat kwayénanu kaké daré?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wunga wandaka det wandén, “Bret katik dé ro?” Wunga wandéka wandarén, “Makal bret taambak kaayék vétik (7), gumba kutndarén makal gukwami nak nak rakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wunga wandaka wani du dakwat wandén, képmaamba daae randarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wandéka randaka wani makal bret gukwami waak kéraae Gorét wandén, “Yéku musé wa nanat tiyaaménén. Wan yékun wa.” Naandén. Wunga watake wani bret gukwami waak bule déku dunyansat kwayéndén. Kwayéndéka akwi du dakwat kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kwayéndaka akwi kurkale kandarén. Kandaka kakému ras baka randéka kémbi taambak kaayék vétik (7) waandandaka vékulékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wani kakému kan dunyan wan 4,000 wa. Dakwa nyambalé waak némaamba wa wamba rate kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kasékéyak-ndaka Jisas du dakwat wandéka deku gaayét yéndarén. Yéndaka dé botmba nak waare Magadanna taalat yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi dunyan ras Sadyusi dunyan ras Jisaské yéndarén. Ye deku mawulémba anga wandarén, “Got wandéka dé Jisas yaak, kapuk baka nané pulak du dé?” Wunga vékulakate dat wandarén, “Méné kulé apanjémba nak ma yaménu vékanangwa. Wunga vétake vékusék-nganangwa. Got wandéka wa yaaménén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wunga wandaka det wandén, “Garambu yandéka nyaa daawulindéka nyét gwaavé yandéka véte wangunéngwa, ‘Nyét gwaavé yandékwa. Séré yéku nyaa vékandékwa.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wunga watake ganmbamba nyét gélé yandéka véte wangunéngwa, ‘Nyét gélé yatékwa. Bulaa wimut kutndu maas viyaakandékwa.’ Wunga wangunéngwa. Guné nyérét véte vékusékngunéngwa wimut béré maaské. Guné yawutékwa kulé apanjémba véte wunéké vékusékngé yapatingunéngwa. Guna mawulé yékéyaak yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bulaa ani sapak yatékwa du dakwa wa kapérandi musé yapékaténdakwa. Gorké wa kuk kwayéndarén. Wunat wangunén apanjémba, kulé apanjémba, katik yaké wuté. Anga male yakawutékwa. Talimba yatan du Jona yandén pulak yakawutékwa.” Naatake Jisas de yaasékatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas déku dunyansale néma gu kwaawu nak sakwat yéndarén. Ye saambake déku dunyansé dat wandarén, “Nané bret yamba kure yaanangwe wa. Yékéyaak yananén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Wunga wandaka Jisas det ani gwaaménja kundi wandén, “Guné jéraawu ma yangunék. Farisi dunyansé béré Sadyusi dunyanséna yis kurké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wunga wandéka deku kapmang bulte wandarén, “Nané bret ras yamba kure yaanangwe wa. Wunga yananga bret némaan yandénngé kutndakwa musé yiské wa wandén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wunga bulndaka vékusékte det wandén, “Kamuké guné anga wo? ‘Nané bret yamba wa.’ Wuné gunat yékun yaké yawutékwanngé yamba yékunmba vékulakangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Guné wuna mayé apaké yamba wayéka yékunmba vékusék-pékaréngunéngwe kapuk? Talimba 5,000 dunyansat makal bret taambak kwayéwutéka kurkale kandaka bret ras baka randéka kémbi késépéri waandangunénngé guné vékulako kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nakapuk 4,000 dunyansat makal bret taambak kaayék vétik (7) kwayéwutéka bret ras baka randéka kémbi késépéri waandangunénngé guné vékulako kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yékunmba vékulakate vékusék-ngangunéngwa. Wuné némaamba bret yaalandénngé apamama yawutén. Yate wuné yiské wayéka watéte bretké yamba vékulakawutékwe wa. Farisi dunyansé béré Sadyusi dunyanséna yiské ma jéraawu yangunénénngé wa wawutén.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wunga wandéka wa vékusékndarén. Dé bretmba kutndakwa yiské yamba wandékwe wa. Dé Farisi béré Sadyusi dunyanséna kapérandi kundi vékukapuk yamuké wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas déku dunyansale Sisaria Filipaina taalat yéndarén. Ye Jisas déku dunyansat anga wandén, “Wuné Duna Nyaan a téwutékwa. Wunéké du dakwa yénga daré wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wunga wandéka wandarén, “Ménéké ras wandakwa, ‘Wan baptais kwayékwa du Jon wa.’ Ras wandakwa, ‘Wan talimba yatéte Gotna yémba kundi kwayétan du Elaija wa.’ Ras wandakwa, ‘Wan Gotna yémba talimba kundi kwayétan du déku yé Jeremaia wa.’ Ras wandakwa, ‘Jeremaia yamba wa. Gotna yémba talimba kundi kwayétan nak du wa.’ Wunga wandakwa ménéké.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wunga wandaka det wandén, “Wa guné yénga pulak? Guné wunéké yénga guné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wunga wandéka Saimon Pita wa wan, “Méné nanat yékun yaménénngé Got wan du Krais wa. Méné apapu apapu rapékakwa du Gotna nyaan wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wunga wandéka wandén, “Jonna nyaan Saimon, méné yéku mawulé wa vékuménéngwa. Ani képmaamba tékwa du wunéké waménén kundi ménat yamba wandakwe wa. Anjorémba rakwa du wuna aapa Got déku kapmang wa ménat wani kundi wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","An ménat wawutékwa. Ména yé Pita. Nana kundimba anga wa: Matu. Wani néma matu taakumba wuna jémbaamba yaalan du dakwa taakakawutékwa. Taakawutu du dakwa kiyaandakwa yapaté nak kapérandi musé waak wuna du dakwat katik yaavan kurké dé. De yékunmba rapéka-kandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wuna mayé apa ménat kwayékawutékwa. Kwayéwutu méné waménu nak du dakwa Gotna kémba yaalakandakwa. Méné ani képmaamba yatéte ‘Yamba wa’ naaménéngwa muséké Got déku gaayémba rate wani muséké ‘Yamba wa’ naakandékwa. Méné ani képmaamba yatéte, yi naaménéngwa muséké Got déku gaayémba rate, wani muséké yi naakandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wunga watake déku dunyansat wandén, “Ma véku. Guné nak duwat anga waké yambak, ‘Jisas wan nanat yékun yandénngé Got wan du Krais wa.’ Wunga waké yamarékate.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wani sapak Jisas taale ani kundi déku dunyansat wandén, “Wuné Jerusalemét waaréwutu de maaka dunyan, Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan, de wunga wunat kapérandi musé yakandakwa. Ye wunat viyaandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupuk yambanmba Got wandu wuné nakapuk taamale waarapkawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wunga wandéka Pita dé kure ye bét kapmang téte wandén, “Néman Du, méné wunga waké yambak. Got wani kapérandi muséké katik yi naaké dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wunga wandéka waalakwe Pitat wandén, “Satan, méné ma yaange yé. Méné wuna jémbaa taakatépé-ménéngwa. Méné Gotna kundi yamba vékuménéngwe wa. Méné ani képmaana duna kundi male wa vékuménéngwa.” Naandén Jisas Pitat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wani kundi watake Jisas déku dunyansat anga wandén, “Guné wunale yaate wuna jémbaa yaké mawulé yangunan, wa anga ma yangunék. Guné guna mawulé ma yaasékangunék. Yaasétake wunéké vékulakate anga ma wangunék, ‘Nané déku jémbaa yatépéka-kanangwa. Yate nané kaangél kutte takwemimba kiyaamunaananu wan baka musé wa. Néma musé yamba wa.’ Wunga wate wuna jémbaa ma yaténgunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wunéké vékulakakwa du dakwa wuna jémbaa yatépékandaru wuna maama det viyaandaru kiyaae de wunale yékunmba rapéka-kandakwa apapu apapu. Wunéké vékulakakapuk yakwa du dakwa deku sépéké male vékulakate deku jémbaa male yatémunaae, wa de kiyaae lambiyak-ngandakwa. Wunale katik rapékaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Du dakwa ani képmaana musé akwi kéraaké vékulakate, deku jémbaa male yate, kiyaae yénga pulak yékunmba rapékaké daré? Yamba yé wa. Katik yékunmba rapékaké daré. De Gotna gaayét yéké mawulé yate yéwaa kwayéké daré kapuk? Yamba yé wa. Katik yéké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kukmba wuna aapa Got wunat mayé apa tiyaate wandu wuné Duna Nyaan nyaa véte kaalékwa pulak ye gaayakawutékwa. Gotna kundi kure gaayakwa dunyansale gaayakawutékwa. Gaaye akwi du dakwa yandarén musé kwayékata-kawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ani kundi ma véku. Guné amba yatékwa du ras wayéka kiyaakapuk yatéte vékangunéngwa, wuné néma du rate apa tapa ye yaawutu. Duna Nyaan wuné yaawutu vékangunéngwa. Yi wan wanana wa.” Jisas déku dunyansat wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nyaa taambak kaayék nakurak (6) yandéka Jisas, Pita, Jems, Jemsna waayéka Jon wunga de kure néma némbat nak waaréndarén. Waare de male wamba yaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yaréte véndarén. Jisasna sépé waalakwe nak pulak yaalan. Yaalandéka déku saawi nyaa vékwa pulak yan. Yandéka déku laplap wamatama ye kalkal naan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yandéka talimba yatéte Gotna yémba kundi kwayétan du Moses ambét Elaija Gotna gaayémba gaaye Jisasale bulténdaka wa Jisasna du kupuk véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita det vétake Jisasét wandén, “Néman Du, nané amba ranangwan, an yékun a. Méné mawulé yaménu wuné gaa kupuk amba kaakawutékwa. Ménéké nak, Moseské nak, Elaijaké nak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wani kundi wayéka waténdéka waama yasékéyakén buwi nak gaaye det taakatépéndén. Taakatépéndéka kundi nak buwimba awula wan, “An wuna nyaan a. Déké néma mawulé yawutékwa. Déké wuna mawulé yékun yandékwa. Guné déku kundi ma véku.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wani kundi vékutake Jisasna du wup yasékéyake kwaati se waandé daae saawi képmaamba tindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yandaka Jisas deké yaae det kutte wandén, “Guno, ma waarap. Wup yaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wunga wandéka waarape du nak yamba véndakwe. Jisas male véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ye wani némbu yaasékatake daawulitéte Jisas det wandén, “Ma véku. Guné véngunén muséké nak duwat bulaa waké yambak. Wuné Duna Nyaan kiyaawutu Got wandu wuné nakapuk taamale waarapwutu wani sapak guné wani muséké waké ya.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wunga wandéka déku du dat anga wandarén, “Apakundiké vékusékngwa dunyan anga wandakwa, ‘Gotna yémba talimba kundi kwayétan du Elaija taale yaakandékwa. Yaandu Got wan du Krais kukmba yaakandékwa.’ Kamuké daré wunga wo?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wunga wandaka wandén, “Yi wan wanana wa. Elaija taale yaakandékwa. Yaae Kraisna yaambu kurkandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gunat anga wawutékwa. Elaija wa yaan. Yaandéka du dakwa déké vékusékngapuk yate dat kapérandi musé yandarén. Dat yandarén pulak wuné Duna Nyaan wunat kapérandi musé yakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wunga wandéka wandarén, “Dé Elaijaké wate wa baptais kwayétan du Jonngé wa wandékwa. Wanana.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas, Pita, Jems, Jon, de wunga daawuliye déku dunyan ras waak némaamba du dakwale jaawuwe téndarénmba saambakndarén. Saambakndaka du nak Jisaské yaae dat kwaati se waandé daandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Waandé daate wandén, “Néman Du, méné wuna nyaanngé ma sémbéraa yaménu. Késépéri apu waangété yate kiyaandékwa. Kiyaate késépéri apu yaamba vaakétte gumba waak vaakétndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yandéka ména dunyanngé kure yéwutéka dé kururéké yapatindarén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wunga wandéka Jisas wa wan, “Yénga pulak dé? Guné wunéké yékunmba yamba vékulaka-ngunéngwe wa. Guna mawulé yamba yékunmba téndékwe wa. Wuné baapmu némaamba wa gunale yatéwutéka guné wunéké yamba yékunmba vékulaka-ngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma kure yaa wani nyaan anga wunéké.” Wunga wandéka kure yéndaka Jisas wani nyaanét kure yatan kutakwat waarundéka bari wani nyaan yaasékatake yaange yélén. Yaange yéléka wani sapakngakét wani nyaan nakapuk yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kukmba Jisas déku kapmang randéka déku dunyan déké ye dat wandarén, “Nané wani kutakwat wananga yamba yaange yélékwe. Yénga pulak nané wani jémbaa yaké yapatik?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wunga wandaka det wandén, “Guné Gorké yékunmba vékulakakapuk yate wa wani jémbaa yaké yapatingunén. Ma véku. Guné Gorké ayélapkéri vékulakamunaate, wa guné déké yéku mawulé ayélapkéri wa yakangunéngwa. Guné Gorké yéku mawulé ayélapkéri yamunaate, wa guné apanjémba wa yakangunéngwa. Ani némbu ma vé. Guné Gorké yéku mawulé ayélapkéri yangunu, guna yéku mawulé makal miyé sék pulak makal male téndu, ani némbu waarape yéndénngé Gorét waataku-munaangunu, wa ani némbu waarape yékandékwa. Guné déké yékunmba vékulakapékate dat waatakumunaae, wa guné kulé apanjémba ras waak yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Guné kutakwa yaange yéndarénngé waké mawulé yate, guné kakému kakapuk yaakétte wani muséké Gorét ma waatakungunék. Wunga yangunu wa yaange yékandakwa. Wunga yakapuk yangunu, wa katik yaange yéké daré. Naandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas déku dunyanale Galilina taalémba yeyé yaayatéte Jisas det wandén, “Kukmba wuné Duna Nyaan maamat kwayéndaru deku taambamba rakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rawutu wuné viyaandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupuk yambanmba Got wandu nakapuk taamale waarapkawutékwa.” Wunga wandéka wani muséké néma sémbéraa yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas déku dunyansale Kaperneamét yéndarén. Ye saambakndaka Gotna kundi bulndakwa néma gaaké takis kéraakwa dunyansé Pitat yaae wandarén, “Guna néma du Gotna kundi bulndakwa néma gaaké takis ras dé kwayu?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wunga wandaka Pita wa wan, “Yi. Kwayéndékwa.” Wunga watake gaamba wulaae Jisasét wani kundi wayéka wakapuk téndéka Jisas dat waatakundén, “Saimon, yénga méné vékulako? Ani képmaana néma du kandémba daré takis kéraau? Deku kémna du dakwamba daré kéraau, kapuk nak gaayé du dakwamba daré kéraau?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wunga wandéka Pita wa wan, “Nak gaayé du dakwamba male takis kéraandakwa.” Wunga wandéka Jisas wa wan, “Yi wan wanana wa. Néma duna kém deku du dakwa takis deké yamba kwayéndakwe wa. Wuné Gotna nyaan a téwutékwa. Wuné déku gaaké takis kwayékapuk yawutu, wa wuné déku nyaan téwutékwanngé vékulakate dé wunat katik waaruké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wuné déku gaaké kwayékapuk yawutu, nak du dakwa wunat kapérandi mawulé yate wunat waarukandakwa. Deku mawulé katik kapére yaké dé, naate wa wuné waak takis kwayékawutékwa. Méné ma ye néma gu kwaawumba gukwami taawuwe wuré. Taale wuréménéngwa gukwami kéraae déku tépngémba yéwaa nak vékaménéngwa. Vétake kéraae kure yaae det ma kwayéménu. Kwayéménéngwa yéwaa, wan aana takis wa, Gotna kundi bulndakwa néma gaaké.” Naandén Jisas Pitat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wani sapak Jisasna dunyan yaae dat wandarén, “Kandé akwi néma duwat taalékére néma du ro, Gotna kémba?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wunga wandaka Jisas deku nyaanét nak waandéka yaae deku nyéndémba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Téndéka det wandén, “Ma véku. Guna kapérandi mawulé yaasékatake ma yéku mawulé vékungunu. Guna mawulé makal nyambaléna mawulé pulak tékapuk yandu Gotna kémba katik yaalaké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ani nyaan déku yé yamba kavérékndékwe wa. Déku mawulé yékunmba téndékwa. Déku mawulé tékwa pulak deku mawulé yékunmba tékwa du dakwa, de deku yé kavérékngapuk yate Gotna kémba rate, néma du néma taakwa rakandakwa. De nak néma du néma taakwat waak taalékéra-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Du dakwa wunéké yékunmba vékulakate anga pulak nyaanét yékun yate wunat waak wa yékun yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wani kundi watake anga wandén: “Ani makal nyambalé wuna kundi yékunmba vékundakwa. Du ras du nakét déku kwaalémba néma matut giye dé vaanjanda-ndaru solwaramba daawuliye kulak ke kiyaandu wan kapérandi musé wa. Du nak wandu wani nyambalé nak déku kundi vékute wuna kundi yaaséka-munaandu, wa Got wunga waké yakwa duwat yandén kapérandi musé némaanmba yakata-kandékwa. Wan néma kapérandi musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Némaamba du dakwa ani képmaana kapérandi muséké male vékulakate wuna kundiké yékéyaak yandakwa. Wani du dakwaké sémbéraa yawutékwa. Du ras wandaru wuna kundi vékukwa du dakwa deku kundi vékute wunat kuk kwayéndaran, wa det wunga wan du deku mawulé wa yaavan kutndakwa. Wan néma kapérandi musé wa. Got wunga waké yakwa duwat yandarén kapérandi musé némaanmba yakata-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Guna maan taamba kapérandi musé yaké yandu, wa wani maan taamba ma sékwe vaanjandangunék. Guna nakurak maan nakurak taamba male téndu wani kapérandi musé yakapuk yate Gotna kémba yaalamunaangunu, wan yékun wa. Guna maan vétik taamba vétik téndu guné wani kapérandi musé yatake kukmba yaa yaanpékatékwa taalat daawulimunaangunu, wan kapére wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Guné guna ménit kapérandi musé véte wani kapérandi musé yaké mawulé yamunaae, wani méni ma pékwe vaanjandangunék. Guna nakurak méni male téndu wani kapérandi musé yakapuk yate Gotna kémba yaalamunaangunu, wan yékun wa. Guna méni vétik téndu guné wani kapérandi musé yatake kukmba yaa yaanpékatékwa taalat daawulimunaangunu, wan kapére wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ma véku. Wani makal nyambalésat kuk kwayéké yambak. Deké anga wambak, ‘De makalkéri nyambalésé wa. Deké katik vékulakaké nané.’ Anjorémba rakwa du wuna aapa Gotna kundi kure gaayakwa dunyan deké yékunmba véndakwa. Yandaru deké wani kundi wambak. Wani du déku ménimba rapékandaka wani nyambalésat yékun yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wuné Duna Nyaan lambiyakén du dakwa Satanna taambamba kéraae det yékun yaké wa ani képmaat gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ani gwaaménja kundiké ma vékulaka. Du nak némaamba (100) sipsipké séngite kaavéréndékwa. Sipsip nakurak lambiyakndu, wani du kamu yaké dé? Dé lambiyakén sipsipké waakngé dé kapuk? Déku ras sipsip némbumba waara tékwanmba wayéka téte katéndaru de yaasékatake ye lambiyakén sipsipké waakngandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Waake vétake dé wani sipsipké mawulé tawulé yakandékwa. Dale tan sipsipké mawulé yate lambiyakén sipsipét vétake dé mawulé tawulé wa yakandékwa. Yi wan wanana wa. Gunat wa wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wani kundiké vékulakate vékusék-ngangunéngwa. Wani du sipsipké yékunmba véndékwa pulak, anjorémba rakwa wuna aapa du dakwaké yékunmba véndékwa. Véte wani makal nyambalé nak lambiyake kapérandi taalémba tépékaamuké kalik yandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wani kundi watake Jisas anga wandén: “Guné wuna jémbaamba yaalan du, guné nak nak ma véku. Wuna jémbaamba yaalan nak du ménat kapérandi musé yandu méné déké ye béné kapmang rate méné dat ma wa, ‘Méné wunat kapérandi musé wa yaménén.’ Dat wunga ma wa. Nak du dakwat wani muséké méné waké yambak. Méné ye dat waménu dé ména kundi vékute ménat yandén kapérandi musé yaasékandan, wan yékun wa. Béné véréti nakurakmawulé yate yékunmba yarékambénéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dé ména kundi vékukapuk yandu wuna jémbaamba yaalan du vétikét waak ma we kure guné déké nakapuk ye dat nakapuk ma waménu, ménat yandén kapérandi muséké. Wunga yaké yaménéngwanngé talimba du nak ani kundi Gotna nyéngaamba wa viyaatakandén: Du vétik kupuk nakurak kundi wandaru, wan yékun wa. Nak du wani kundi vékukandakwa. Viyaatakandén kundiké vékulakate méné du vétikét waak ma we kure ye guné akwi ménat kapérandi musé yan duna kundi vékuké ya. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Méné bét kure ye ménat kapérandi musé yan duwat wangunu dé guna kundi vékumuké kalik yandu, wuna jémbaamba yaale jaawuwe rakwa du dakwat ma waménék, ménat yandén wani kapérandi muséké. Waménu wani muséké dat wandaru dé deku kundi waak vékumuké kalik yandu guné akwi dat ma wangunék, dé guné yaasékatake yéndénngé. Nak gaayé du, takis kéraate kapérandi musé yakwa du waak wuna jémbaamba yaalakapuk yate apakmba yaténdakwa pulak, dé waak guné yaasékatake ye yatékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Gunat a wawutékwa. Guné ani képmaamba yatéte, ‘Yamba yé wa,’ naangunéngwa muséké Got déku gaayémba rate wani muséké, ‘Yamba yé wa,’ naakandékwa. Guné ani képmaamba yatéte yi naangunéngwa muséké Got déku gaayémba rate wani muséké yi naakandékwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nak kundi waak gunat wawutékwa. Guna du vétik nakurakmawulé yate anjorémba rakwa du wuna aapa Gorét waatakumbéru dé bérku kundi vékute waatakumbérén pulak yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Du vétik kupuk wunéké vékulakate nakurakmawulé yate nakurak taalémba jaawuwe randaka wa wuné dele rawutékwa. Rawutékwanngé vékulakate wa wani kundi wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisaské ye dat wandén, “Néman Du, wuna du wunat kapérandi musé yapékandu dat wakawutékwa, ‘Wani muséké nakapuk katik vékulakaké wuté. Dékumukét yénga yakét.’ Wani kundi apu taambak kaayék vétik (7) waké wuté?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wunga wandéka Jisas dat wandén, “Wuné apu taambak kaayék vétik wunga waménénngé yamba wawutékwe wa. Ména du késépéri apu ménat kapérandi musé yandu méné apapu apapu dat ma wa, ‘Wani muséké nakapuk katik vékulakaké wuté. Dékumukét yénga yakét.’ Wunga wate wani kundi yaasékaké yambak. Wunga waké yaménéngwa apu naakiké yapati-kaménéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wani kundi Pitat watake ani gwaaménja kundi wandén: “Got néma du rate déku kémngé yékunmba véte anga yakandékwa. Néma du nak wandén, ‘Némaamba jémbaa yakwa duwat yéwaa wa kwayéwutén. Kwayéwutéka wani kwaambu dé pulak yamba tiyaakatandakwe wa. Bulaa wuna yéwaa tiyaakata-ndarénngé mawulé yawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wunga watake det wandén, wunga kwayékata-ndarénngé. Wandéka du nak déké kure yéndarén. Wani du némaamba yéwaa kéraandén (10 milion kina). ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wani du yéwaa ras yamba kure yéndékwe. Wani yéwaa kwayékataké yapatindén. Yapatindéka néma du wandén, de wani duwat, déku taakwa, déku nyambalé, déku akwi musé nak duwat kwayéte yéwaa kéraae déku yéwaa kwayékata-ndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wunga wandéka wani du néma du ranmba kwaati se waandé daate wandén, ‘Néma du, méné ma wunéké sémbéraa yate wunéké kaavéré. Kukmba wuné ména yéwaa akwi kwayékata-kawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wunga wandéka wani jémbaa yakwa duna néma du déké sémbéraa yate dat wandén, ‘Dékumukét yénga yakét. Wani kwaambu katik tiyaakataké méné. Baka ma yéménu.’ Naandén néma du. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wani jémbaa yakwa du kaapat gwaande dale jémbaa yakwa duwat nak véndén. Wani du dat ayélap yéwaa kéraae wani kwaambu yamba kwayékatandékwe wa. Vétake dat kulkiye dé déku kwaalémba némaamba kutte wandén, ‘Méné wunémba kéraaménén yéwaa akwi bulaa ma tiyaakata.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wunga wandéka wani du kwaati se waandé daate wandén, ‘Méné wunéké sémbéraa yate wunéké ma kaavéré. Kukmba ména yéwaa kwayékata-kawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wunga wandéka kalik yandén. Kalik yate dé kure ye kotime kalapusmba taakandén. Taakatake dat wandén, ‘Méné wuna yéwaa tiyaakata-take méné kalapusmba kése baka yékun yaalakaménéngwa.’ Wunga watakandéka kalapusmba kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Dale jémbaa yatan du véte déké néma sémbéraa yandarén. Sémbéraa yate deku néma duwat ye wani muséké akwi wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wandaka néma du waandéka wani du yaandéka dat wandén, ‘Méné kapérandi musé male yakwa du wa. Taale méné wunat waatakwe wunémba kéraaménén néma yéwaaké wawutén, “Yénga yakét. Dékumukét. Wani kwaambu tiyaakataké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wunga wate ménéké sémbéraa yawutén. Kamuké méné wuné yan pulak ménale jémbaa yatan duké yamba sémbéraa yaménéngwe? Méné déké sémbéraa yakapuk ye, wa méné kapérandi musé yakwa du wa téménéngwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wunga watake rakarka ye wani duwat kalapusmba taakandén. Taakatake dat wandén, ‘Wuna yéwaa akwi tiyaakatatake méné kalapusmba kése baka yékun yaalakaménéngwa.’ Naandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas wani kundi watake anga wandén, “Guné wani kundiké ma vékulaka. Nak du gunat kapérandi musé yandaru ma wangunék, ‘Yénga yakét. Dékumukét. Wani kapérandi muséké nakapuk katik vékulakaké nané.’ Guné wunga wakapuk yangunan, wa Got yangunén kapérandi muséké apapu apapu vékulaka-kandékwa. Vékulakate wani kapérandi musé katik yasnyéputiké dé.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas wani kundi wasékéyaktake Galili taakatake Jordan kaambélémba vaatiye Judiana taalat yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yéndéka némaamba du dakwa déku kukmba yéndarén. Yéndaka dé wani taalémba baat yan du dakwa, sépémaalé kapére yan du dakwat waak kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi dunyan ras Jisaské yéndarén. Deku mawulémba wandarén, “Nané dat nak muséké waatakunanu kalmu dé kapérandi kundi wandu nané dat kotimngé nané?” Wunga vékulakate dat wandarén, “Nana apakundi yénga dé wo? Du nak déku taakwa kewuréte dé yaasékatake yélénngé wamunaandu, wan yékun dé kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wunga wandaka det wandén, “Kamuké guné wunat waatakwo wani muséké? Talimba Gotna nyéngaamba du nak wani muséké kundi viyaatakandéka wa véngunén. Anga wa viyaatakandén: Talimba baasnyé ye Got akwi musé yate du dakwa waak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yatake wandén, ‘Du déku aasa aapa yaasékatake taakwa kéraae bét nakurakmba yarékambérékwa. Yaréte nakurak sépé ye yarékambérékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wani kundiké vékulakate vékuséknangwa. Du taakwa kéraae bét nakurakmba yarémbérékwa. Nakurak sépé ye yarémbérékwa. Sépé vétik yamba yé wa. Got bérké wandékwa, ‘Nakurak sépé ye wa yarémbérékwa.’ Wunga wandékwanngé du nak déku taakwat katik kewuréte waké dé, lé dé yaasékatake yélénngé.” Jisas wunga det wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wani kundi wandéka Farisi dunyan wa wan, “Wa Moses kamuké dé nak pulak kundi wak? Talimba anga wandén, ‘Du nak déku taakwa kewuréte dé yaasékatake yélénngé wamunaate, taale nyéngaa nak viyaakandékwa wani muséké. Viyaae lat kwayéte wandu lé dé yaasékatake yékalékwa.’ Moses wunga wandén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wunga wandaka det wandén, “Guné akwi kapérandi mawulé vékukwa du dakwa yaténgunénga wa Moses gunéké wani kundi wandén. Talimba baasnyé ye dunyansé deku taakwat wunga yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wuné gunat anga wawutékwa. Duna taakwa nak duwale kapérandi musé yakapuk yalu, léku du lé kewuréte dé yaasékatake yélénngé baka watake, dé nak taakwa kéraamunaae, wani du dé kukmba kéraandén taakwale bét kapérandi musé wa yambérékwa. Naawutékwa.” Jisas wunga wandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wani kundi wandéka Jisasna dunyan dat wandarén, “Nana du dakwa anga yandakwa. Du nak taakwa kéraae kukmba kewuréte dé yaasékatake yélénngé mawulé yamunaae, wandu lé dé yaasékatake yékalékwa. Méné wa wakwa, ‘Du déku taakwa kewuréte dé yaasékatake yélénngé baka katik waké dé.’ Méné wunga waménéngwanngé nané bulaa nana mawulémba anga wanangwa: Du taakwa kéraakapuk ye baka yaténdaru wan yékun wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wunga wandaka det anga wandén, “Du ras wunga yaké apamama yandakwa. Baka yaténdarénngé Got det mayé apa kwayéndékwa. Némaamba du baka yatéké yapatindakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ani du de taakwa yamba kéraandakwe wa. Du ras deku aasa kéraandaka deku sépé kapérandi yandéka de taakwa kéraaké yapatindakwa. Du ras deku sépé nak du sékundaka de taakwa kéraaké yapatindakwa. Du ras Gotna jémbaaké male vékulakate de taakwa yamba kéraandakwe wa. Wani kundi vékute wunga yaké mawulé yakwa du wani kundi yékunmba vékukandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Du dakwa ras makal nyambalésé Jisaské kure yéndarén, det taamba kutte deké Gorét waatakundénngé. Kure yéndaka Jisasna dunyan det waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Waarundaka Jisas det wandén, “Makal nyambalésé ma taaka de wunéké yénga yaandaru. Yaandaru guné det waatépéké yambak. Gotna kémba tékwa du dakwa wan de wani makal nyambalésé pulak wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wunga wate deku maakamba taamba kutndén. Ye wani taalé taakatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Du nak Jisaské ye wandén, “Méné, Gotna jémbaaké nanat yakwasnyékwa du, kamu yéku musé ye wuné kulémawulé kéraae apapu apapu yékunmba rapékaké wuté?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wunga wandéka Jisas wa wan, “Kamuké méné yéku muséké wunat waatakwo? Got male wa yéku musé yakwa du wa yaréndékwa. Méné apapu apapu yékunmba rapékaké mawulé yamunaae Got wandéka Moses wan apakundi ma vékuménék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wunga wandéka wani du wa wan, “Kamu apakundi?” Naandéka Jisas wa wan, “De ani kundi an. Du dakwat viyaandékngé yambak. Nak duna dakwale kapérandi musé yaké yambak. Sél yaké yambak. Nak duké papukundi waké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Méné ména aasa aapat ma yékun yaménék. Ména sépéké néma mawulé yaménéngwa pulak, nak du dakwaké néma mawulé ma yaménék. Yate det ma yékun ya.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wani kundi vékutake wani du dat wandén, “Wani kundi akwi vékute wandékwa pulak wa yawutén. Kamu musé nak waak yaké wuté?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wunga wandéka wandén, “Anga waak ma yaménék. Yéku mawulé vékute yékunmba rapékaké mawulé yamunaae, taakaménén akwi musé nak duwat kwayéte yéwaa kéraae yéwaakapuk du dakwat ma kwayéménék. Kwayéménu Got ménat yékun yandu kukmba méné Gotna gaayét ye wamba yékunmbaasékéyak rapéka-kaménéngwa. Méné yéwaakapuk du dakwat yéwaa kwayétake waambule yaae wuna jémbaamba ma yaalaménék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wunga wandéka wani du vékutake déku némaamba musé kwayémuké kalik yandéka déku mawulémba vaak yan. Yandéka Jisas yaasékatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dé yéndéka Jisas déku dunyansat wandén, “Némaamba musé kurerékwa du yakélak yakélak yare ye Gotna kémba katik yaalaké daré. De apamama ye wa néma jémbaa yakandakwa Gotna kémba yaalamuké. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ani kundi waak wawutékwa: Néma bulmakau nak laplap samapndakwa raaményna yaambumba wulaaké mawulé yamunaae, apamama wa yakandékwa. Némaamba musé kurerékwa du Gotna kémba yaalaké mawulé yate de ma apa tapa yapékandarék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wani kundi vékutake Jisasna dunyan vékulaka vékulaka naate wandarén, “Nané Judasé anga wanangwa, ‘Got du rasét yékun yandéka de némaamba musé kurerékwa du wa yaténdakwa.’ Wani kundiké bulaa vékulakanangwa. Némaamba musé kurerékwa du Gotna kémba wulaaké apa tapa yamunaandaru, yénga pulak musé kurerékapuk du dakwa Gotna kémba wulaae yékunmba rapékaké daré apapu apapu?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wunga wandaka det véte wandén, “Du dakwa deku kapmang apamama yate Gotna kémba yaale yékunmba rapékaké wa yapatindakwa. Got dékét déku kapmang wa wani muséké apamama yandékwa. Got akwi musé yaké wa apa tapa yandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wani kundi vékutake Pita wa wan, “Ma véku. Nané nana akwi musé yaasékatake ména jémbaa yate ménale yeyé yaayaténangwa. Wunga yanangwanngé, kamu musé kéraaké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wunga wandéka Jisas dat wandén, “Gunat wawutékwa. Kukmba kulé nyét kulé képmaa akwi musé waak kulé yaalanda sapak wuné Duna Nyaan néma duna yéku tékétmba rate du dakwana néma du rakawutékwa. Wani sapak guné wuna dunyan tambavétik maanmba kaayék vétik (12), guné néma duna tékétmba rate, Israelna kém tambavétik maanmba kaayék vétik (12) wani kémngé guné néma du rate vékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wunéké yékunmba vékulakakwa du dakwa wuna jémbaa yaké deku gaa, aanyé waayéka, aasa, aapa, nyambalé, képmaa yaasékandaru Got det yékun yandu yékunmbaasékéyak yarépéka-kandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bulaa némaamba tékwa néma du dakwa kukmba baka du dakwa tékandakwa. Bulaa baka tékwa némaamba baka du dakwa de kukmba néma du dakwa rakandakwa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas det ani kundi wandén: “Got néma du rate du dakwaké yékunmba vékandékwa anga. Du nak wain miyé tékwa néma yaawi nak yandén. Yatake ganmbamba, nyaa yaalakapuk téndéka ye wani yaawimba jémbaa yamban dunyanngé waakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Waake vétake det wandén, ‘Guné ani akwi nyaa jémbaa yangunu, wuné gunat nak nak yéwaa tambavétik (10) kwayékawutékwa.’ Wunga wandéka yi naandarén. Yi naandaka wandéka déku wain yaawit yéndarén, déku jémbaa yaké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kukmba nyaa yaalandéka wani yaawimba jémbaa yamban dunyan raské waak waaklakét yéndén, du jaawundakwa taalat. Ye véndén dunyan ras baka yatékésndaka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Vétake det wandén, ‘Guné waak ye wuna yaawimba ma jémbaa yangunék. Yangunu wuné gunat nak nak yéwaa tambavétik kwayékawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wunga wandéka déku wain yaawit yéndarén. Nyaa vélénawuréndéka ye déku yaawimba jémbaa yamban duké ras waak waake véndén. Vétake wandéka de waak déku jémbaa yaténdaka nyaa tépatekwe daawuliké yaténdéka dunyan raské waak waake véndén. Vétake wandéka de waak déku jémbaa yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yaténdaka garambu nyaa daawulikandéka du jaawundakwa taalat nakapuk ye véndén du ras waak baka yatékésndaka. Vétake det wandén, ‘Kamu yate guné akwi nyaa amba baka yato?’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wunga waatakundéka wandarén, ‘Nanat du nak yamba jémbaa yananénngé wandékwe wa.’ Wunga wandaka det wandén, ‘Guné waak ye wuna yaawimba jémbaa ma yangunék.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kukmba nyaa daawulindéka yaawina néma du jémbaa yakwa dunyanséké séngite kaavérékwa duwat wandén, ‘Méné jémbaa yakwa dunyansat ma waaménu yaandaru det yéwaa ma kwayé. Taale, wani kukmba yaae jémbaa yan dunyansat ma kwayéménék. Kwayétake nyéndé nyaa yaae jémbaa yan dunyansat kwayétake, sésékuk sékéyak wani ganmbamba yaae jémbaa yan dunyansat ma kwayéménék.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wunga wandéka dé wunga kwayéndéka de garambu yaae jémbaa yan dunyan démba yaae nak nak yéwaa tambavétik (10) kéraandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kéraandaka taale yaae jémbaa yan dunyan yéwaa kéraaké yaate vétake deku mawuléké wandarén, ‘Nané kalmu néma yéwaa kéraaké nané?’ Wunga vékulakate de waak nak nak yéwaa tambavétik kéraandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kéraate yaawina néma duwale waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Waarute anga wandarén, ‘Wani dunyan garambu sékét yaae ayélap sapak male wa jémbaa yandarén. Nané taale yaae ganmbamba jémbaa baasnyé ye néma jémbaa yananga nyaa nana sépémba wa vénjékwan. Kamuké méné ména jémbaa yan akwi dunyansat nakurak yéwaa wunga male kwayu? Wa sépélak yaménén.’ Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wunga wandaka wamba tan du nakét wandén, ‘Wuna du, ma véku. Wuné gunat kapérandi musé yamba yawutékwe wa. Ganmbamba gunat wawutén, “Guné wuna jémbaa yangunu wuné gunat yéwaa tambavétik (10) kwayékawutékwa”. Wunga wawutéka guné wani yéwaaké yi naangunén. Wawutén pulak gunat wa kwayéwutén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guné guna yéwaa ma kéraae kure gaayét yéngunék. Wuné wuna mawulémba vékute kukmba jémbaa yan dunyansat waak gunat kwayéwutén yéwaa pulak wunga male wa kwayékawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wan wuna jémbaa wa. Wan wuna yéwaa wa. Det kwayéwutén yéwaaké guné katik bulké guné. Wuné det yékun yate yandarén makalkéri jémbaaké néma yéwaa kwayéké mawulé yawutéka kamuké guné wunat waaruwu?’ Naandén yaawina néma du.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wunga watake Jisas det wandén, “Got néma du rate déku kémba yaalan du dakwaké wunga yékunmba vékandékwa. Déku kémét kukmba yaalan du dakwat taale yékun yakandékwa. Yatake déku kémba taale yaalan du dakwat kukmba yékun yakandékwa. Deké nakurakmawulé yate det akwi yékun yakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Jisas Jerusalemét waaréte déku dunyan tambavétik maanmba kaayék vétik (12) det male kure yéndén. Yéte det wandén, “Ma véku. Bulaa Jerusalemét waarénangwa. Waarénanu de Duna Nyaan wuné kéraae kuriye Gotna gaamba jémbaa yakwa dunyanna néma dunyansé béré apakundiké vékusékngwa dunyansat kwayéndaru wuné deku taambamba rakawutékwa. Rawutu de wuné viyaandék-ndarénngé wakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wandaru nak gaayé dunyan wuné kéraae wunat wasélékte raamény baangwit viyaae wuné takwemimba baangtakandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupukmba Got wandu nakapuk taamale waarapkawutékwa.” Jisas déku dunyansat wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedina taakwa léku nyaan vétik Jisaské kure yélén. Ye képmaamba kwaati se waandé daate dat waatakulén, dé lat yékun yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Waatakuléka Jisas wa wan, “Kamuké nyéné mawulé yo?” Wunga wandéka dat walén, “Kukmba méné du dakwaké néma du rate waménu bét wuna nyaan vétik nak ména yékutuwa taambamba, nak ména akituwa taambamba rakambérékwa. Bét wamba rate nak du dakwaké néma du rakambérékwa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wunga waléka wandén, “Guné wunat waatakungunéngwa muséké yamba vékusékngunéngwe wa. Wuné néma kaangél kurkawutékwa. Béné wani kaangél kurké béné apamama yo kapuk?” Wunga wandéka wambérén, “Yi. Wunga kurké aané apamama yatékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wunga wambéréka wandén, “Kaangél kurké yawutékwa pulak béné kaangél kurkambénéngwa. Yi wan wanana wa. Kukmba kandé wuna yékutuwa taambamba raké ya? Kandé wuna akituwa taambamba raké ya? Wuné wani muséké katik waké wuté. Wan wuna kundi yamba wa. Wamba raké yakwa duké wuna aapa talimba déku mawulémba wandén wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wani kundi wandéka Jisasna dunyan tambavétik (10) wani muséké vékute bérét rakarka yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yandaka Jisas waandéka yaandaka det wandén, “Anga wa vékusékngunéngwa. Nak gaayéna néma dunyan, du dakwaké apamama yate wandakwa, deku kundi yékunmba vékute deku jémbaa yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Guné de yakwa pulak yaké yambak. Gunale yatékwa du nak Gotna ménimba néma du raké mawulé ye, wa dé guna jémbaa yakwa du ma yaréndék. Yaréte guna kundi vékute wangunéngwa pulak ma yandu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wuné Duna Nyaan wunga yawutékwa. Nak du dakwaké jémbaa yate det yékun yaké wa yaawutén. Du dakwa wunéké jémbaa yandarénngé yamba vékulake yaawutékwe wa. Wuné kiyaae némaamba du dakwa Satanna taambamba kéraawutu de Gorale yékunmba rapékandarénngé wa yaawutén.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas déku dunyansale Jeriko taakatake yéndarén. Yéndaka du dakwa némaamba de déku kukmba yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yéténdaka méni kiyaan du vétik yaambumba rambérén. Rate vékumbérén Jisas yaambumba yéndéka. Vékute waambérén, “Ménawa, Devitna gwaal waaranga maandéka bakamu, méné Devit pulak néma du téte aanéké ma sémbéraa yaménu.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wunga waambéréka wani du dakwa bérét waarundarén, bét yakélak rambérénngé. Waarundaka nakapuk némaanmba waambérén, “Néman Du, Devitna gwaal waaranga maandéka bakamu, aanéké ma sémbéraa yaménu.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wunga waambéréka wa Jisas waandén, déké yaambérénngé. Waandéka déké yémbéréka wandén, “Bénat kamu yawuténngé béné mawulé yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wunga wandéka wambérén, “Néman Du, méné aanat kururéménu aané nakapuk véké mawulé yatékwa.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wunga wambéréka bérké sémbéraa yate déku taambat bérku ménimba kutndéka bérku méni bari yékun yan. Yandéka bét yékunmba vététe wa Jisasale kwaare yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas déku dunyansale Jerusalemét waaréké yatéte Betfagemba saambakndarén. Wani gaayé Oliv némbumba téndékwa, Jerusalem tékwanmba. Saambake Jisas déku du vétikét wandén, “Béné wani gaayét ma wulaambénu. Wulaae vékambénéngwa, donki vétik témbéru. Aasa donki léku nyaanale miyémba lékitakandaka wa témbérékwa. Vétake wani donki vétik ma lepékwe kure yaambénék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yambénu du nak wani muséké bénat waatakundu anga ma wambénék, ‘Nana Néman Du wani donkiké mawulé yandékwa.’ Wunga ma wambénu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas wunga wandéka talimba yatéte Gotna yémba kundi kwayétan du Gotna nyéngaamba viyaatakandén kundi wa sékérékén. Anga viyaatakandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guné ma ye Saionmba tékwa du dakwat anga wangunék, “Ma vé. Guna néma du gunéké wa yaandékwa. Dé déku yé kavérékngapuk yate yéku mawulé vékute wa yaandékwa. Dé donki nyaantakumba waare wa yaandékwa.” Wani kundi talimba Jisasna aasa dé kéraakapuk yalén sapak viyaatakandéka kukmba wa Jisas Jerusalemmba tékwa du dakwaké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisasna du vétik déku kundi vékutake wandén pulak yambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ye aasa donki léku nyaanale lepékwe kure yémbérén déké. Ye yépmaa yandéka saape témbérén laplap laariye donkina bungulmba vaakutakambérén. Vaakutaka-mbéréka Jisas donki nyaantakumba waare randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yéréndéka némaamba du dakwa laplap ras yaambumba taakate yaambu yakusondarén. Yandaka du ras tépmaa pulak musé yaambumba taakate yaambu kusondarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yatake du dakwa ras taale yéndaka de ras Jisasna kukmba yaate némaanmba anga waandarén: Devitna gwaal waaranga maandéka bakamu nanéké wa yaandékwa. Wan yékun wa. Néman Du Got wandéka wa yaandékwa. Wan yékun wa. Got dat yékun yénga yandu. Anjorémba rakwa du Gotna yé kavérék-nganangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wunga waandaka wa Jisas ye Jerusalemét wulaandén. Wulaandéka wani gaayémba tékwa akwi du dakwa déké vatvat naate wandarén, “Wani du wan kandé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wunga wandaka dale yaan du dakwa wa wan, “An Gotna yémba kundi kwayékwa du déku yé Jisas wa. Dé Galilimba wa yaandékwa. Déku gaayé Nasaret wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas Gotna kundi bulndakwa néma gaamba wulaae véndén du ras musé kwayéte yéwaa kéraaténdaka. Vétake det kewurésalendén. Kewurésalete nak gaayéna yéwaa kéraate wani gaayéna yéwaa kwayékwa dunyanséna jaambé taakungérundén. Yate viyaae tuwe Gorké kwayéké yandakwa api kwayékwa dunyansé ran tékét kutmbalakundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yate det wandén, “Ani kundi Gotna nyéngaamba wa kwaakwa: Got wa wandén, ‘Du dakwa wuna gaamba yaale wunale kundi bulkandakwa.’ Got wunga wa wandén. Wani kundiké guné yamba vékulaka-ngunéngwe wa. Guné ani gaamba Gorale kundi yamba bulngunéngwe wa. Guné musé kwayéte yéwaa kéraangunénga ani gaa an sél yakwa du paakwe rakwa gaa pulak a gérékén.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas awula Gotna gaamba téndéka méni kiyaan du dakwa ras, maan kapére yan du dakwa ras wunga déké yaandarén. Yaandaka det kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kururéndéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan waak véndarén. Vétake vékundarén nyambalé Gotna gaamba némaanmba waandaka. Anga waandarén, “Devitna gwaal waaranga maandéka bakamu nanéké wa yaandékwa. Wan yékun wa.” Wunga waandaka vékutake Jisas wani du dakwat kururéndéka véte dat rakarka yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yate dat wandarén, “Waandakwa kundi méné vékwo? Wan sépélak wa yandakwa.” Wunga wandaka Jisas wa wan, “Yi. Wa vékuwutékwa. Wan yékun wa yandakwa. Wunga yandakwanngé ani kundi Gotna nyéngaamba wa kwaakwa: Méné Got, makal nyambalé, munyaa kakwa nyambalé waak det wa waménén, ména yé yékunmba kavérékndarénngé. Wani kundiké yékéyaak guné yak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naatake Jisas Jerusalem taakatake Betanit yéndén. Ye wamba kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas wamba kwaae ganmbamba Jerusalemét waambule yaambumba yéténdéka dat kaandé yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yandéka yéte véndén yéku sék vaakukwa miyé nak yaambu aarkémba téndéka. Némaamba gaanga wani miyémba téndéka véte déku mawulémba wandén, “Némaamba gaanga téndéka sék wa vaakwe tékwa. Ras géle kakawutékwa.” Wunga watake wani miyé sék géle kaké yéndén. Ye wani miyé sék ras yamba vaakwe téndéka véndékwe wa. Gaanga male téndéka véndén. Vétake wandén, “Ani miyémba nakapuk sék katik vaakuké dé.” Wunga wandéka wani miyé bari rékaa yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yandéka Jisasna dunyan vétake vatvat naate wandarén, “Yéki. Yénga pulak ye dé wani miyé bari rékaa yak?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wunga wandaka Jisas det wandén, “Gunat wawutékwa. Guné Gorké yékunmba vékulakate mawulé vétik yakapuk yangunu, wa guné wani miyat yawutén pulak, guné yakangunéngwa. Guné wangunu miyé rékaa yakandékwa. Wani musé male katik yaké guné. Nak musé waak yakangunéngwa. Ani némbu ye solwaramba daawulindénngé wangunu, dé ye solwaramba daawulikandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Guné Gorké yékunmba male vékulakate, dat waatakuké yangunéngwa pulak, gunéké apamama yandékwanngé guna mawulémba wamunaate, wa guné dat waatakungunu gunéké wunga yakandékwa. Yi wan wanana wa.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas Jerusalemmba saambake Gotna kundi bulndakwa néma gaat wulaandén. Wulaae du dakwat Gotna jémbaaké yakwasnyéndén. Yakwasnyéndéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, maaka dunyan waak Jisaské yaae dat wandarén, “Kamu mayé apa kéraae méné wani jémbaa yo? Kandé wak wani jémbaa yaménénngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wunga wandaka det wandén, “Wuné waak nak kundi gunat waataku-kawutékwa. Waatakuwutu guné wuna kundi waambule kaatangunu wuné guna kundi kaatakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Guné ma wa. Kandé Jonét wak dé du dakwat baptais kwayéndénngé? Got dé wunga wak, kapuk képmaana du nak dé wunga wak?” Wunga waatakundéka de deku kapmang bule waarute wandarén, “Nané anga wananu, ‘Got wa wunga wan.’ Wunga wananu, wa nanat anga wakandékwa, ‘Kamuké guné déku kundi vékukapuk yo?’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anga waké nané? ‘Képmaana du nak wa wan.’ Némaamba du dakwa Jonngé wandakwa, ‘Gotna yémba kundi kwayétan du nak wa. Yi wan wanana wa.’ Naandakwa. Deké wup yate kundi katik bulké nané Jonngé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wunga bule paapu yate Jisasét wandarén, “Yamba vékuséknangwe wa. Wani muséké katik waké nané.” Naandaka det wandén, “Wuné waak wunat wandéka yaae ani jémbaa yawutékwa duké katik waké wuté.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wani kundi watake Jisas ani gwaaménja kundi wandén: “Yénga guné vékulako? Du nak nyaan vétik talimba kéraandén. Nak nyaa talényanét ye wandén, ‘Wuna nyaan, bulaa ma ye wuna wain miyé tékwa yaawimba jémbaa yaménék.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wunga wandéka wandén, ‘Wuné kalik yakwa.’ Naatake kukmba nak mawulé yate wani yaawimba jémbaa yaké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wani du ye talényanét wandén pulak déku nak nyaanét wunga wandén. Wandéka wandén, ‘Yi. Bulaa yékawutékwa.’ Wunga watake yaawimba jémbaa yaké yamba yéndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Wani nyaan vétikmba kandé aapana kundi vékwak?” Naandéka wandarén, “Talényan wa vékwan.” Wunga wandaka Jisas det wandén, “Gunat wawutékwa. Takis kéraatan kapérandi du, yaambumba yatan dakwa, de taale wa Gotna kémba yaalandakwa. Yi wan wanana wa. De yaalandaru guné kukmba yaalaké guné, kapuk katik yaalaké guné? ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Baptais kwayétan du Jon yaae wandén, ‘Guné kapérandi mawulé yaasékatake Gotna kundi ma yékunmba vékungunék.’ Wunga wandéka guné déku kundi yamba vékungunéngwe wa. Yangunénga takis kéraakwa kapérandi dunyan, yaambumba yatékwa dakwa waak de déku kundi vékundarén. Vékute yandarén kapérandi musé yaasékatake Gotna kundi yékunmba vékundarén. Yandaka véte guné yandarén pulak yamba yangunéngwe wa. Guné yangunén kapérandi musé yaasékakapuk yate déku kundi yamba vékungunéngwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wani kundi watake Jisas det anga wandén: “Guné ani gwaaménja kundi waak ma véku. Du nak wain miyé taawuké yaawi nak yandén. Aatmu giye wain miyé taawundén. Taawutake kukmba wain kulak kéraae kaké wain sék guriksande vakipékumuké kwaawu matumba vaandén. Vaatake yaawiké séngite véréndara sémény gaa nak kaandén. Yawurétake wani yaawiké séngiréte yaawimba jémbaa yate yéwaa kéraaké mawulé yan dunyansat kwayéndén. Kwayétake dé nak taalat yén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Miyé sék géléké yandakwa sékét yaaké yandéka dale rate déku jémbaa yakwa du rasét wandén, yaawiké kaavéte séngirékwa duké yéndarénngé. Ye miyé sék ras kwayéndaru kure yaandarénngé wa mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yate wandéka déku jémbaa yakwa dunyan yéndaka yaawiké kaavéte séngirékwa dunyan det vétake nakét viyaate, nakét viyaandékte, nakét matut vaanéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yandaka kukmba dé yaawina néma du déku jémbaa yakwa du rasét waak wandéka yéndarén. Késépéri duwat wa wandéka yéndarén. Yéndaka yaawiké kaavéte séngirékwa dunyan wa det wungat male viyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Yandaka kukmba wani néma du déku mawulémba anga wandén, ‘De wuna nyaanna kundi wa vékukandakwa.’ Wunga watake déku nyaanét wandéka yaawiké kaavéte séngirékwa dunyanséké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yéndéka yaawiké kaavéte séngirékwa dunyansé déku nyaanét véte deku kapmang kundi bulndarén. Bulte anga wandarén, ‘Yaawina néma du kiyaandu wani nyaan déku aapana akwi musé kéraakandékwa. Nané dé viyaandéktake ani yaawi kéraakanangwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naatake dé kure yaawi yaasékatake kaapamba kure gwaande viyaandékndarén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wani kundi watake Jisas det wandén, “Guné yénga guné vékulako? Kukmba yaawina néma du yaae yaawiké kaavéte séngiran dunyansat yénga pulak yaké dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wunga waatakundéka dat wandarén, “Yaae wani kapérandi musé yan dunyansat viyaandékwuré-kandékwa. Wunga yakandékwa. Viyaandéktake nak dunyansat wani yaawi kwayékandékwa, de yaawiké kaavéte séngiréndarénngé. Kwayéndu kukmba miyé sék géléndara sapak wani miyé sék géle dat kwayékandakwa.” Jisasét wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wani kundi wandaka det anga wandén: “Viyaandékndarén nyaanngé ani kundi Gotna nyéngaamba wa kwaakwa: Gaa kaakwa du yéku matuké waakte matu nakurakngé kalik yatakandaka baka randén. Randéka Néman Du Got wani matut vétake wandén, ‘Wan yéku matu wa. Wani matu randu gaa yékunmba kwaakandékwa.’ Wunga watake wani matu kéraae taakandéka wa gaa yékunmba kwaan. Kwaandéka véte yéku mawulé vékunangwa. Wani kundi Gotna nyéngaamba vétake guné yamba yékunmba vékulakangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wani kundiké gunat anga wawutékwa. Talimba guné Judasé Gotna kémba wa téngunén. Téte déku jémbaaké kalik yangunén. Yangunénngé Got wandu déku kémba katik téké guné. Nak gaayé du dakwa wa déku kémba yaalaké yakwa. Wani du dakwa de déku jémbaa yékunmba yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wani matu taakumba vaakérké yakwa du deku sépémaalé ayélap ayélap yasokandékwa. Wani matu du nakna sépétakumba vaakétmunaae, wa wani duwat akwi yaavan kurkandékwa.” Naandén Jisas. Wani matuké wunga wate dékét déké wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wani kundi wandéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Farisi dunyan waak wani gwaaménja kundi vétik vékute wa vékusékndarén. Jisas deké wa wani kundi wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wunga vékusékte wandarén, “Nané dé kure kalapusmba taakakanangwa.” Naandarén. Wunga wate anga waak wandarén, “Akwi du dakwa wandakwa, ‘Jisas wan Gotna yémba kundi kwayékwa du nak wa.’ Wunga wandakwanngé nané dé kure kalapusmba taakamunaananu, wa nanat waarukandakwa.” Wunga watake wani du dakwa det wunga waarumuké wup yate Jisas yamba kulkindakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas det nakapuk gwaaménja kundi nak waak anga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Got néma du rate du dakwaké yékunmba anga vékandékwa. Néma du nak yaréndén. Yare déku nyaan taakwa kéraamuké yandéka wandéka néma kakému yaake kaké yandarén. Yaténdaka taale wani néma du némaamba du dakwat waandén, kukmba yaae dele kakému kandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yatake kakému ka sapak, déku jémbaa yakwa dunyansat wandén, ‘Guné ma akwi genge gaayémba yéte wawutén du dakwat wangunék, de bulaa yaae kakému kandarénngé.’ Wunga wandéka ye wandaka wani du dakwa yaamuké kalik yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yandaka wani néma du déku jémbaa yakwa dunyan rasét waak wandén, ‘Guné ma ye talimba wawutén du dakwat anga wangunék: Ma véku. Nané kakému taakananén wa. Néma bulmakau, yéku bulmakau nyaan waak wa viyaae tunanén. Akwi musé taakananga rakwa. Guné ma yaae kangunu. Wunga ma wangunék det.’ Wunga wandéka wandén pulak yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“De wunga yandaka de waandén du ye wani kakému kamuké kalik yandarén. Deku jémbaaké male vékulakandarén. Yate nak du waarape yaawit yén. Yéndéka nak waarape yéwaa kéraaké yandékwa jémbaa yaké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yéndéka ras waarape néma duna jémbaa yatan dunyansat kulkiye det kapérandi musé yate det viyaandékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Viyaandékndaka néma du rakarka yate déku waariyakwa dunyansat watakandéka ye déku jémbaa yatan dunyansat viyaandékén dunyansé akwi viyaasandandarén. Yate deku gaayé gaa yaat tundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Yandaka néma du déku jémbaa yakwa dunyansat wandén, ‘Kakému taakananga a rakwa. Yaandarénngé wawutén du dakwa kapérandi musé wa yandarén. Yatake nana kakému katik kaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yandaru guné ye akwi yaambumba téte nak du dakwat véte det anga ma wangunék, “Guné ma yaae taakananén kakému kangunék.” Wunga ma wangunék det.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wunga wandéka jémbaa yakwa dunyan waarape ye yaambumba yéte véndarén du dakwat wandarén, yaandarénngé. Yéku musé yakwa du dakwa, kapérandi musé yakwa du dakwat waak wandarén. Wandaka yaae taakwa kéraan duna aapana gaamba randarén. Randaka wani gaa sékérékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wani néma du kakému kakwa du dakwa véké watake wani gaat wulaandén. Wulaae véndén yéku laplap saawukapuk yan du nak randéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jaangwa laplap male saawundén. Yandéka néma du dat wandén, ‘Méné, yénga pulak ye méné yéku laplap saawukapuk ye méné anga yaalak?’ Wunga wandéka wani du kundi yamba bulndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yandéka néma du déku jémbaa yakwa dunyansat wandén, ‘Guné wani duwat ma kulkiye déku maan taamba giye kaapat vaanjang-ngwandéngunék. Yangunu ganngumba randu. Wamba rate néma kaangél vékute yéku taalémba raké mawulé yate némaamba géraakandékwa.’ Naandén wani néma du. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Wani gwaaménja kundiké ma vékulaka. Got dé wani néma du pulak wa. Got némaamba du dakwat wa wandén, de déku kémba yaalamuké. Wandéka némaamba du dakwa déku kundi kuk kwayéndarén. Kwayétake déku kémba katik yaalaké daré. Dé némaamba du dakwat wandéka, wa ayélap du dakwa male déku kundi vékute déku kémba yaalandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wani kundi wandéka Farisi dunyan ras ye dekét deku kapmang kundi bulndarén. Bulte wandarén, “Nané Jisasét késmu nakmuké waatakunanu kalmu kapérandi kundi waambule kaataké dé kapuk? Dé kapérandi kundi wandu, dé kure ye kalapusmba taakakanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wunga watake deku dunyan ras, Herotna dunyan ras waak det watakandaka Jisaské ye dat anga wandarén, “Néma du, méné det Gotna jémbaaké yakwasnyéménéngwa. Méné yéku kundi male wate det Gotna kundiké yékunmba yakwasnyéménéngwa. Méné nakurak kundi male waménéngwa, néma du dakwa, baka du dakwat waak. Méné deké wup yamba yaménéngwe wa. Wunga vékuséknangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Méné wunga yate bulaa méné nanat ma wa. Yénga méné vékulako? Nana apakundi yénga dé wo? Nané takis Romna néma du Sisar, dat kwayéké nané?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wunga wandaka Jisas deku mawuléké wa vékusékwuréndén. De deku mawulémba anga wandarén, “Bulaa dé kapérandi kundi wandu dé kalapusmba taakakanangwa.” Wunga wandaka Jisas vékusékte det wandén, “Guné paapu yakwa dunyan wa. Kamuké guné wunat wunga waatakwo? ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Guné takis kwayéngunéngwa yéwaa nak wunat ma wakwasnyéngunu véwutu.” Wunga wandéka wani yéwaa nak kure yéndarén déké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kure yéndaka det wandén, “Ani yéwaamba kwaakwa nyaap an kéna nyaap dé? Kéna yé daré ani yéwaamba viyaatakak?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wunga waatakundéka wandarén, “Wan Romna néma du Sisarnan wa.” Wunga wandaka det wandén, “Yi wan wanana wa. Sisarna musé dat ma kwayéngunék. Gotna musé Gorét ma kwayé.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wunga wandéka wani kundi vékutake vatvat naate vékulaka vékulaka naandarén. Ye dé yaasékatake yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusi dunyan deku mawulémba anga wandarén, “Kiyaan du dakwa nakapuk taamale katik waarapké daré.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","De ras Jisaské ye dat anga wandarén: “Néma du, méné du dakwat Gotna jémbaaké yakwasnyéménéngwa. Méné ani muséké nanat ma wa. Talimba Moses anga wandén, ‘Du nak taakwa kéraae nyaan kéraakapuk ye kiyaandu déku waayéka wani taakwa kéraakandékwa. Yandu nyaan kéraalu wani nyaanngé wakandakwa, Aanyéna nyaan wa. Naakandakwa.’ Moses wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bulaa ma véku. Talimba nakurak kémba du taambak kaayék vétik (7) yaréndarén. Aanyé taakwa kéraae nyambalé kéraakapuk ye kiyaandén. Kiyaandéka déku waayéka wani taakwa kéraae nyambalé kéraakapuk ye kiyaandén. Kiyaandéka nak waayéka wani taakwa kéraae nyambalé kéraakapuk ye kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kiyaandéka akwi waayékanje wungat male ye de akwi nyambalé kéraakapuk ye baka kiyaawuréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yandaka kukmba wani taakwa kiyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bulaa nanat ma wa. Kiyaan du dakwa taamale waarapké yandakwa sapakngé waménéngwa. Wani sapak wani taakwa kandale raké lé? Talimba wani nakurak kémna aanyémbéré waayékanje de akwi lat male kéraandarén.” Sadyusi dunyan Jisasét wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas deku kundi vékutake det anga wandén, “Guné Gotna nyéngaamba kwaakwa kundi yamba vékusék-ngunéngwe wa. Vékusékngapuk yate Gotna mayé apaké waak yamba vékusék-ngunéngwe wa. Yangunénga guna mawulé kapére yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ma véku. Kukmba Got wandu kiyaan du dakwa taamale waarape Gotna gaayémba rate déku kundi kure gaayakwa dunyan pulak rakandakwa. Rate du de taakwa katik kéraaké daré. Taakwa de du katik kumbiké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Kundi ras waak wakawutékwa kiyaan du dakwa taamale waarapké yandakwanngé. Got gunat wandéka déku nyéngaamba kwaakwa kundi ras vétake guné yamba yékunmba vékulaka-ngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Got wa wandén, ‘Wuné Abrahamna néma du a. Wuné Aisakna néma du a. Wuné Jekopna néma du a. Wuné deku néma du Got a rawutékwa.’ Wunga wandéka déku kundi déku nyéngaamba kwaandéka wa vékuséknangwa. Dé kiyaan duna néma du yamba randékwe wa. Wani du de talimba kiyaandarén. Taale wa kiyaandarén. Kukmba wa Got wani kundi wandén. De kiyaae nakapuk taamale waarape randaka wa Got wani kundi wandén. Got kiyaae taamale waarape rakwa duna néma du wa randékwa. Got wan kiyaakapuk kulé tékwa duna néma du wa. Wunga wa vékuséknangwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wunga wandéka wamba tékésén du dakwa wani kundi vékute déku kundiké vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wani kundi wandéka Sadyusi dunyan kundi bulkapuk kundimék randarén. Randaka Farisi dunyan vékutake yaae dele jaawuwe randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Randaka dele rate apakundiké yakwasnyékwa du nak déku mawulémba wandén, “Dé wuna kundi waambule kaatate kalmu kapérandi kundi waké dé?” Wunga vékulakate Jisasét wandén, “Néma du, méné Gotna kundiké nanat yakwasnyéménéngwa. Nana apakundimba kamu apakundi dé akwi apakundit taalékérak?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wunga waatakundéka Jisas dat wandén, “Guné guna Néman Du Gorké ma néma mawulé yangunék. Yate dat wangunu guna mawulé, guna kwaminyan, guna yaamambiké néma du rakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wani kundi wan néma kundi wa. Akwi apakundit wa taalékérawuréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nak apakundi wan wungat male wa. Anga wandékwa, ‘Guné guna sépéké néma mawulé yangunéngwa pulak, nak du dakwaké ma néma mawulé yangunék. Yate det ma yékun yangunék.’ Naandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wani kundi vétik wan néma apakundi wa. Akwi apakundit wa taalékérandén. Guné wani kundi vékute wandékwa pulak yate guné Moses wan apakundi Gotna yémba kundi kwayétan duna kundi waak wa vékungunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Farisi dunyansé yaae nakurakmba jaawuwe téndaka Jisas det waatakundén, “Gunat yékun yamuké Got wan du Krais yénga pulak du dé? Yénga guné déké vékulako? Dé kéna gwaal waaranga maandéka bakamu dé?” Wunga waatakundéka dat wandarén, “Wan Devitna gwaal waaranga maandéka bakamu wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Wunga wandaka det wandén, “Talimba Krais ani képmaamba yatékapuk yandéka Gotna Yaamambi Devitna mawulémba wulaandéka Devit Kraiské anga wandén, ‘Wuna Néman Du.’ Naate anga wandén: Néman Du Got wuna Néman Duwat wa wandén, ‘Méné néma du rate wuna yékutuwa taambamba ma raménék. Raménu wuné wawutu ména maama ména taambamba rakandakwa. Randaru méné néma du rate deké vérékaménéngwa.’ Got wunga wandén. Devit wani kundi wate dé Kraiské ‘Wuna Néman Du wa’ naandén. Kamuké dé Devit Kraiské wunga wak? ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit Got wan du Kraiské, ‘Wuna Néman Du wa,’ naandéka yénga pulak dé Krais Devitna gwaal waaranga maandéka bakamu to? Krais Devitna gwaal waaranga maandéka bakamu téte Devitna néma du waak dé to, kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wunga wandéka Jisasna kundi waambule kaataké yapatindarén. Wani nyaa dat kundi nak waak waatakumuké wup yandarén. Kukmba waak dat kundi nak nakapuk yamba waatakundakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas déku dunyan, némaamba du dakwat waak anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Apakundiké vékusékngwa dunyan, Farisi dunyan waak Moses talimba wan apakundiké yékunmba vékusékndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Vékusék-ndakwanngé vékulakate guné deku kundi vékute wandakwa pulak ma yangunék. Yate yandakwa pulak yaké yambak. De némaamba kundi wate wandarén pulak yamba yandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Du nak némaamba musé yaatandéka nak du yaae ras waak vaakutakandékwa pulak, Farisi dunyan, apakundiké vékusékngwa dunyan waak néma jémbaa ras waak du dakwat kwayéndakwa. Kwayéte det anga wandakwa, ‘Guné ani apakundi akwi vékute wandékwa pulak ma yangunék.’ Wunga wandaka wani kundi vékute wandékwa pulak yaké néma jémbaa yandakwa. Yandaka deké sémbéraa yakapuk yate det yékun yamba yandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Akwi du dakwa det véte deké, ‘Yéku dunyan wa,’ naandarénngé wa mawulé yandakwa. Yate Gotna kundi ras nyéngaamba viyaatake wani nyéngaa deku saawi deku taambamba waak gindakwa. Gite deku laplapna waambumba yakusondakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","De nak duwale kakému kate yéku taaléké waakte du dakwana ménimba raké wa mawulé yandakwa, de véte deku yé kavérékndarénngé. De Gotna kundi bulnangwa gaamba wulaae néma duna taalémba raké mawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","De du dakwa jaawundakwa taalémba yeyé yaayandaru nak du dakwa det véte anga wandarénngé wa mawulé yandakwa: ‘Wan nana néma dunyansé wa yaakwa. Nanat Gotna kundiké yakwasnyékwa dunyansé wa.’ Wunga wandarénngé wa mawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Guné wuna dunyan téte guné wunga yaké yambak. Guné akwi wuna jémbaamba yaale aanyémbéré waayékanje wa yaténgunéngwa. Téngunu guna aanyémbéré waayékanje gunéké katik waké daré, ‘Nanat Gotna kundiké yakwasnyékwa du wa.’ Katik naaké daré. Wuné kapmang Gotna kundiké yakwasnyékwa du a téwutékwa. Gunéké wani kundi katik waké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Anjorémba rakwa du guna aapa wan nakurak male wa randékwa. Randékwanngé guné nak duké, ‘Nana néma du wa,’ naaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Guna néma du wan wuné Got wan du Krais wa. Wunga vékusékte guné nak duké, ‘Nana néma du wa,’ naaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Guna du nak néma du raké mawulé yate wa guna jémbaa yakwa du ma randék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Deku yé kavérékngwa du dakwaké kukmba Got wandu baka du dakwa rakandakwa. Deku yé kavérékngapuk yakwa du dakwaké kukmba Got wandu wa de néma du dakwa rakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jisas wani kundi watake apakundiké vékusékngwa dunyan, Farisi dunyansat waak anga wandén: “Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné yékunmba katik rapékaké guné. Guné paapu yakwa dunyansé wa. Némaamba du dakwa Gotna kémba yaalaké mawulé yandakwa. Yandaka guné wangunénga vékute Gotna kémba yaalaké yapatindakwa. Guné waak Gotna kémba yamba yaalangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa dunyansé wa. Guné du kiyaan kwawitakwana musé akwi kéraangunéngwa. Kéraae paapu yate néma kundi Gorét wangunéngwa, nak du dakwa gunat véte guna yé kavérékndarénngé. Yangunéngwanngé néma kapérandi musé gunéké yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa dunyansé wa. Guné sékaa yaambumba yéte solwaramba yéte némbumba waak yéte guna kundi vékuké yakwa duké nak waakngunéngwa. Waake véngunénga wani du guna jémbaamba wulaandéka dat yakwasnyéngunénga némaamba kapérandi musé yandékwa. Yandékwa wani kapérandi musé wa guné yakwa kapérandi musat taalékérakwa. Guné waak dé waak akwi kapérandi taalat yékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Méni kiyaan du nak duwat yaambu wakwasnyéké yapatindékwa pulak, wa guné nak du dakwat yéku yaambu wakwasnyéké yapatingunéngwa. Gunéké kapérandi musé yaakandékwa. Guné anga wangunéngwa, ‘Du ras jémbaa nak yaké yate Gotna kundi bulndakwa néma gaana yémba wamunaandaru, wan baka musé wa. Kukmba mawulé ye, wa wani kundi yaaséka-kandakwa. De jémbaa yaké yate Gotna kundi bulndakwa néma gaamba taakandarén gol matumba yandarén muséna yémba wamunaandaru, wan néma musé wa. Wandarén pulak ma yandarék. Kukmba wani kundi katik yaasékaké daré.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Guné wunga wangunénga wa guna mawulé kapére yandékwa. Méni kiyaan du yaambuké kurkale vékusékngapuk yandakwa pulak, wa guné Gorké yamba yékunmba vékusékngunéngwe wa. Néma musé kamu musé dé? Gotna kundi bulndakwa néma gaa dé, kapuk wani gaamba rakwa musé dé? Gotna kundi bulndakwa néma gaamba rakwa musé, Gotna kundi bulndakwa néma gaa waak, akwi wan néma musé wa. Wani gaa wan Gotna gaa wa. Wani gaamba rakwa musé wan Gotna musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Guné anga waak wangunéngwa, ‘Du ras jémbaa nak yaké yate kwaami viyaae tuwe Gorké kwayéndakwa jaambéna yémba wamunaandaru, wan baka musé wa. Kukmba de mawulé ye wani kundi yaaséka-kandakwa. De jémbaa nak yaké yate wani jaambémba rakwa kwaamina yémba wamunaandaru, wan néma musé wa. Wandarén pulak ma yandarék. Wani kundi katik yaasékaké daré.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Guné wunga wate méni kiyaan du yaambuké kurkale vékusékngapuk yandakwa pulak, wa Gorké yamba yékunmba vékusék-ngunéngwe wa. Néma musé kamu musé dé? Gorké kwayéndakwa kwaami dé, kapuk Gorké kwayéndakwa kwaami rakwa jaambé dé? Wani musé véréti wan néma musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwaami viyaae tuwe Gorét kwayéndakwa jaambé wan Gotna musé wa. Wani jaambémba rakwa kwaami wan waak wan Gotna musé wa. Du wani jaambéna yémba wate, wani jaambémba rakwa kwaamina yémba waak wa wandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Got déku gaamba randékwa. Du Gotna kundi bulndakwa néma gaana yémba wate de Gotna yémba waak wa wandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Got déku gaayémba randékwa. Du Gotna gaayéna yémba wate, wa Got rakwa jaambéna yémba wa wandakwa. Wunga yate de Gotna yémba waak wa wandakwa. Guné jémbaa nak yaké yate watake, wa wangunén pulak ma yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa du wa. Guné akwi musé asé muni waate tambavétik (10) taakate nakurak tambék Gorké kwayéngunéngwa. Wunga kwayéte akwi nyénganyam waak muni waate yém tambavétik (10) taakate nakurak yém Gorké kwayéngunéngwa. Nyénganyam wan néma musé yamba wa. Wan makalkéri musé wa. Guné wani makalkéri muséké vékulakate Moses wan apakundimba kwaakwa néma muséké yamba vékulakangunéngwe wa. Guné nak du dakwat yékun yamba yangunéngwe wa. Guné nak du dakwaké mawulé yamba sémbéraa yangunéngwe wa. Guné Gorké yékunmba vékulakakapuk yate yaké wangunéngwa pulak yamba yangunéngwe wa. Guné guna salmu walmu muni waate yém tambavétik (10) taakate nakurak yém Gorké kwayéngunéngwan, wan yékun wa. Wani yapaté yaasékaké yambak. Wani makal musé yate guné wawutén néma musé waak yamunaae, wa yékun yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Méni kiyaan du, nak duwat yaambu wakwasnyéké yapatindékwa pulak, wa guné nak du dakwat yéku yaambu wakwasnyéké yapatingunéngwa. Guné makal musé yaké néma jémbaa yate yékunmba yangunéngwa. Néma musé yaké yékéyaak yangunéngwa. Yate ani du pulak wa yangunéngwa. Dé kulak tuwe kaké yate makalkéri saat kulakmba kwaandéka vékusékte kéraae kure ye gurikndékwa. Yate kamel kulakmba kwaandéka vékusékngapuk yate kamel kulakale kandékwa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa dunyan wa. Guné aké kasnya yakwasnyéte kuksaku male yakwasnyé-ngunéngwa. Biyaasaku yamba yakwasnyéngunéngwe wa. Yangunénga biyaasaku kapére yandékwa. Guné guna sépéké vékulakate némaamba musé nak du dakwamba kéraae musé ras sél ye baka kéraangunénga guna mawulé kapére yandékwa, wani kasnyana biyaasaku kapére yakwa pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Guné Farisi dunyan, méni kiyaan du yaambuké kurkale vékusékngapuk yandakwa pulak, wa yékunmba yamba vékusékngunéngwe wa. Guné kasnya yakwasnyéte taale awulamba ma yakwasnyéngunék. Wunga yangunu kuksaku yékun yakandékwa. Wunga yaké yangunéngwa pulak, guné kapérandi mawulé yaasékatake yéku mawulé vékungunu guna mawulé yékunmba téndu wa yéku musé yakwa du tékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa dunyan wa. Guné pusandu rémndarén kwaawu pulak wa téngunéngwa. Du dakwa wani kwaawu taakumba yéku musé taakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taakandaka nak du dakwa véte wani muséké male vékulakate wandakwa, ‘Wan yékun wa.’ Wunga wate anda kwaawumba kwaakwa kiyaan duna apaké, kapérandi muséké waak yamba vékusékndakwe wa. Guné wunga pulak wa. Du dakwa gunat véte wandakwa, ‘Wan yéku musé yakwa du wa.’ Wunga wate yamba vékusékndakwe wa. Guna mawulé kapérandi yandékwan. Yandéka guné paapu yate kapérandi musé yangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Guné apakundiké vékusékngwa dunyan, Farisi dunyan waak, gunéké kapérandi musé yaakandékwa. Guné paapu yakwa du wa. Gotna yémba kundi kwayétan dunyan, nak yéku musé yakwa dunyan waak talimba yate kiyaandaka rémndarén taalémba yéku musé taakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Taakate wangunéngwa, ‘Nané nana gwaal waaranga maandéka bakamu yatan sapak yatémunaae, wa de yan pulak, Gotna yémba kundi kwayétan dunyansat katik viyaandékngatik nané.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wunga wate guné det viyaandékén duna gwaal waaranga maandéka bakamu téngunéngwanngé wa wangunéngwa. Wunga wate yaténgunénga guna mawulé deku mawulé pulak wa téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Téndéka kapérandi musé yandarén pulak, guné waak kapérandi musé wa yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guné kapérandi musé yakwa du wa. Duwat tikwa kaambe pulak yatéte wa kapérandi musé yangunéngwa. Got wandu guné kapérandi taalat yékangunéngwa. Nak taalat yaange yéké yapati-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Wuné wawutu Gotna yémba kundi kwayékwa dunyan, nyaangét pukaakwa dunyan, Gotna kundiké yakwasnyékwa dunyan waak gunéké yaakandakwa. Anga wa vékusék-wutékwa. De yaandaru rasét viyaandék-ngangunéngwa. Rasét takwemimba viyaae baang-ngangunéngwa. Rasét Gotna kundi bulngunéngwa gaamba raamény baangwit viyaakangunéngwa. Rasét wulkure yékangunéngwa késnge naknget. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Guné wunga yangunu Got yangunén kapérandi musé gunat yakata-kandékwa. Talimba guna gwaal waaranga maandéka bakamu némaamba yéku musé yan dunyansat viyaandékndarén. Taale Kein déku waayéka Abelét viyaandékndén. Viyaandékndéka guna gwaal waaranga maandéka bakamu yéku musé yakwa duké kalik yate det viyaandékndarén. Viyaandéklaakét viyaandéklaakét ye kukmba Berekiana nyaan déku yé Sekaraiat viyaandékndarén. Dé Gotna gaana nyéndémba téndéka dat viyaandékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Viyaandékndarénngé Got yandarén kapérandi muséké vékulakate guné deku gwaal waaranga maandéka bakamat némaamba yakata-kandékwa. Guné ani sapak tékwa dunyan, yandarén kapérandi muséké gunat némaamba yakata-kandékwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas wani kundi watake wamba tékésén du dakwat véte wandén, “Guné Jerusalemmba tékwa du dakwa, guné Gotna yémba kundi kwayétan dunyansat wa viyaandékngunén. Got wandéka déku kundi kure yén dunyan gunéké yéndarén. Yéndaka det matut viyaangunénga kiyaandarén. Gunéké sémbéraa yawutékwa. Séraa kéraalén nyaanngé saaptépe rate deké yékunmba vélékwa pulak, wuné némaamba apu gunat yékun yate gunéké yékunmba véké wa mawulé yawutén. Yawutéka kalik yangunén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yangunénngé kukmba dunyansé yaae guna gaayé yaavan kurkandakwa. Yaavan kutndaru guné wamba katik raké guné. Guna gaayé baka taalé male téké yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wa anga vékusékwutékwa. Guné wunat nakapuk bari katik véké guné. Kukmba wunéké wakangunéngwa, ‘Got wandéka wa wani du yaandén. Nané déku yé kavérék-nganangwa.’ Naangunu wuné waambule yaawutu wunat nakapuk vékangunéngwa. Yi wan wanana wa. Gunat wa wawutékwa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas Gotna kundi bulndakwa néma gaa taakatake yéké yaténdéka déku dunyan déké yaandarén. Yaae dat wandarén, “Ma vé. Ani gaa an yéku gaa a.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wunga wandaka det wandén, “Yi, bulaa wan yéku gaa wa. Yéku matut yatakandaka vénangwa. Kukmba dunyansé yaae ani gaa akwi yaavan kurkandakwa. Yaavan kutte ani matu kéraae vaanjandandaru ani matu nak matu taakumba katik kwaaké dé. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wani kundi watake Jisas wani gaa taakatake ye Oliv némbat waaréndén. Waare randéka déku dunyan male déké ye dat wandarén, “Nanat ma wa. Yani nyaa Gotna kundi bulndakwa néma gaa yaavan kurké daré? Kamu musé taale yaandu vétake anga waké nané? ‘Yi, bulaa Jisas waambule yaaké yakwa nyaa bari yaakandékwa. Yaandu ani képmaa bari késkandékwa.’ Yani nyaa wunga waké nané?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wunga waatakundaka wandén Jisas, “Guné jéraawu ma yangunék. Yate paapu yakwa duna kundi vékuké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Deké kalik yate wa ani kundi wawutékwa. Némaamba dunyan yaae gunat paapu yaké mawulé yakandakwa. Yate wuna yémba wate de nak nak anga wakandakwa, ‘Wuné Got wan du Krais wuné anana an.’ Wunga wandaru némaamba du dakwa paapu yandara kundi vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Némaamba du waariyakandakwa. Waariyandaru nak du waariyandakwanngé bulkandakwa. Yandaru vékute guné wup yaké yambak. Taale wunga yakandakwa. Sésékuk sékéyak yaaké yakwa sapak kukmba wa yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nak kantrimba tékwa du dakwa de nak kantrimba tékwa du dakwale waariyakandakwa. Nak néma duna kém nak néma duna kémale waariyakandakwa. Ras taalémba du dakwa kaandéké kiyaakandakwa. Ras taalémba némaamba apu néma waalé génngandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wani kapérandi musé wan dakwa nyaan baasnyé ye kéraaké yate kaangél kutndakwa pulak wa. Wani dakwa kaangél ras waak kurké yandakwa pulak, kukmba kapérandi musé ras waak yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Guné wuna dunyan téngunéngwanngé akwi képmaamba tékwa du dakwa gunéké kalik yakandakwa. Yate gunat kéraae kure ye kapérandi musé yate gunat viyaandék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wani sapak némaamba du dakwa wunéké kuk kwayékandakwa. Némaamba du dakwa deku du dakwaké kalik yate det deku maamat kwayékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kukmba némaamba dunyan yaae nak nak paapu yate anga wakandakwa, ‘Wuné Gotna yémba kundi kwayékwa du a.’ Wunga wate paapu yandaru némaamba du dakwa deku kundi vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Némaamba du dakwa némaamba kapérandi musé yakandakwa. Yate de yéku mawulé yaasékatake de nak du dakwaké néma mawulé katik yaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Wani sapak wuna du dakwa deku mawulémba apamama yate wuna jémbaa kutépékaandaru kukmba Got de kéraandu dale yékunmba rapéka-kandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wuna du dakwa akwi genge gaayét yéte akwi taalémba tékwa du dakwat wuna kundi anga wakandakwa, ‘Got néma du rate du dakwaké yékunmba vékandékwa.’ Wunga wandaru kukmba sésékuk sékéyak yaaké yakwa nyaa yaakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Guné ani nyéngaamba véte ani muséké ma yékunmba vékulakangunék. Wani kundi watake Jisas anga wandén: “Talimba Gotna yémba kundi kwayétan du nak déku yé Daniel ani kundi viyaatakandén: Kukmba du nak yaae Gotna kundi bulndakwa néma gaamba Got watépéndén musé nak taakakandékwa. Taakandu de wani gaaké wakandakwa, ‘Kapérandi gaa wa.’ Naakandakwa. Wunga viyaatakandén musé yaalandu vékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Véte wani sapak guné Judiamba tékwa du dakwa guna gaayé yaasékatake némbat bari ma yaange yéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wani sapak kaapamba tékwa du dakwa ma bari yaange yéndarék. Deku musé kéraaké deku gaat nakapuk katik wulaaké daré. Baka ma yaange yéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yaawimba tékwa du dakwa gaayét waambule ye laplap ras waak katik kéraaké daré. Bari ma yaange yéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Wani kapérandi sapak nyaan rakwa dakwa, nyambalé munyaa kwayétékwa dakwa waak bari yaange yéké yapati-kandakwa. Deké sémbéraa yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wani kapérandi sapak maas viyaakwa sapakmba yaandu, yénga pulak bari yaange yéké guné? Wani kapérandi sapak yaap yaré nyaamba yaandu, yénga pulak bari yaange yéké guné? Moses anga wa wandén, ‘Yaap yaré nyaamba guné sékaa yaambumba yéké yambak.’ Yéké yangunéngwanngé vékulakate Gorét ma waatakungunék, wani kapérandi sapak wani sapakmba yaakapuk yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wani sapak némaamba vakmi yaakandékwa. Wani vakmi akwi vakmit wa taalékéra-kandékwa. Talimba Got akwi musé yandén sapak wunga pulak vakmi nak yamba yaandékwe wa. Bulaa waak kukmba waak wunga pulak vakmi nakapuk katik yaaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wani vakmi yaandu Got déku du dakwaké sémbéraa yate wandu wani vakmi bari késkandékwa. Wunga wakapuk yamunaandu, wa akwi du dakwa lambiyak-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wani sapak du ras gunat anga wandaru, ‘Wani duwat ma vé. Wan Got wan du Krais wamba wa randékwa.’ Wunga wandaru guné deku kundi vékuké yambak. De paapu wa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Némaamba du yaae Gotna du dakwat paapu yate nak nak anga wakandakwa, ‘Wuné Got wan du Krais wuné anana.’ Wunga wandaru ras paapu yate nak nak anga wakandakwa, ‘Wuné Gotna yémba kundi kwayékwa du wuné anana.’ Wunga watake paapu yate késpulak nakpulak apanjémba, kulé apanjémba waak yakandakwa. Guna mawulé yaavan kutmuké wa wunga yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gunat wa wawutén, kukmba yaaké yakwa muséké. Kukmba wani musé yaandu guné véte vékusékte deku kundi vékuké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Du dakwa ras gunat wakandakwa, ‘Ma vé. Got wan du Krais dé du yarékapuk taalémba wa randékwa.’ Wunga wandaru guné wani taalat yéké yambak. Gunat wakandakwa, ‘Ma vé. Got wan du Krais wani gaamba wa awula randékwa.’ Wunga wandaru guné deku kundi vékuké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wuné Duna Nyaan waambule gaayawutu akwi du dakwa vékandakwa. Nyét kusnyérakndéka akwi du dakwa véndakwa pulak, guné akwi wuné gaayawutu vékangunéngwa. Wunga véké yangunéngwanngé vékulakate guné deku papukundi vékuké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wunga watake Jisas ani kundi wandén, “Kaandi yaate jaawundaka véte guné kiyaan kwaami nak randékwanngé vékusékngunéngwa. Wani muséké vékusékngunéngwa pulak, guné wawutén musé véte vékusék-ngangunéngwa, wuné yaaké yawutékwanngé.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wani kundi watake Jisas anga wandén: “Wani vakmi yéndu bari nyaa vékapuk yandu gaan yakandékwa. Yandu baapmu waak vékapuk yalu kun nyétmba vaakérkandakwa. Vaakétndaru nyétmba tékwa akwi musé vasanye yeyé yaayakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yandaru ani képmaamba tékwa akwi du dakwa kulé apa musé vékandakwa nyétmba. Véte wunéké vékusék-ngandakwa. Vékusékte géraakandakwa. Géraate wuné Duna Nyaan wunat vékandakwa. Wuné apa tapa yate nyaa véte kaalékwa pulak yate buwimba rate gaayawutu vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Véndaru nyétmba rakwa du nak paati némaamba waandu wuné wawutu wuna kundi kure gaayakwa dunyan akwi képmaamba tékwa akwi genge gaayémba ye Gotna du dakwa kéraae kure yéte nakurakmba taakakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wani kundi watake Jisas anga wandén: “Miyéké yékunmba ma vékulaka. Miyé ras gaanga périye vény waapindéka véte wa vékusékngunéngwa. Kakému naaré yakwa sékét bulaa a yaandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wani miyat véte wani sékérké vékusékngunéngwa pulak, wawutén musé véte vékusék-ngangunéngwa. Wuné bari waambule yaakawutékwa. Wunga vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gunat wawutékwa. Bulaa tékwa du dakwa ras kiyaakapuk ye wayéka téte wawutén akwi musé vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nyét képmaa waak késkandékwa. Wuna kundi katik késké dé. Rapéka-kandékwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yani nyaa waambule yaaké wuté? Ani képmaamba tékwa du dakwa wani nyaaké yamba vékusékndakwe wa. Gotna kundi kure gaayakwa dunyan wani nyaaké yamba vékusékndakwe wa. Wuné Gotna nyaan rate wuné waak yamba vékusékwutékwe wa. Wuna aapa kapmang dé male wa waambule yaaké yawutékwa nyaaké vékusékndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Talimba Noa yaran sapak du dakwa yandarén pulak, waambule yaaké yawutékwa sapak du dakwa wungat male yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa yaran sapak néma kwayé kwakapuk yandéka du dakwa de Gorké vékulakakapuk yate ani képmaana muséké male vékulakaténdarén. Vékulakate kakému kandarén, kulak kandarén, taakwa kéraandarén, wunga yaténdaka Noa néma sip yatake wani sipmba wulaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wani du dakwa Gorké vékulakakapuk yate néma guké yamba vékulakandakwe wa. Yaténdaka néma gu windéka kulak ke akwi kiyaasandandarén. Wuné Duna Nyaan waambule yaaké yawutékwa sapak némaamba du dakwa wani du dakwa yan pulak, ani képmaana muséké male vékulakaté-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Waambule yaaké yawutékwa sapak du vétik yaawimba jémbaa yarémbéru Gotna kundi kure gaayakwa dunyan nakét kéraate nak yaaséka-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wani sapak taakwa vétik gaayémba jémbaa yarémbéru Gotna kundi kure gaayakwa dunyan nakét kéraate nak yaaséka-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wanngé guné wunéké ma kaavéréte yékunmba véréngunék. Wuné guna Néman Du yaaké yawutékwa nyaaké yamba vékusékngunéngwe wa. Yate guné wunéké kaavéréte ma yékunmba véréngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ani gwaaménja kundi kurkale ma véku. Sél yakwa du yaaké yakwa sapakngé gaana néma du vékusékmunaae, wa dé yundé kwaakapuk yékunmba véréndu sél yakwa du déku gaa katik naapiye wulaaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wani kundiké vékulakate guné wunéké kaavéréte ma yékunmba véréngunék. Guné yamba vékusékngunéngwe wa. Yani sapak wuné Duna Nyaan waambule yaaké wuté? Vékusékngapuk yangunéngwa sapak wa wuné waambule yaakawutékwa. Yaaké yawutékwanngé vékulakate guné wunéké ma kaavéréte yékunmba véréngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wani kundi watake Jisas anga wandén: “Yéku mawulé vékute yéku jémbaa yakwa du anga yakandékwa. Déku néma du dat anga wakandékwa, ‘Méné wuna jémbaa yakwa duké ma séngite véré. Yate det kakému ma kwayéménék.’ Wunga watake yéndu wunga yarékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yaréndu kukmba déku néma du waambule yaae vétake wakandékwa, ‘Méné jémbaa yékunmba yaménén. Wan yékun wa.’ Wunga wandu yéku jémbaa yakwa du yéku mawulé yate yékunmba yarékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Déku néma du yandén yéku jémbaa véte wakandékwa, ‘Méné waambule yaaké yawutékwa nyaaké vékusékngapuk yate, méné yéku jémbaa wa yaménén. Wan yékun wa. Bulaa wuna akwi muséké ma yékunmba véréménu.’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Kapérandi mawulé vékute kapérandi jémbaa yakwa du déku mawulémba anga wakandékwa, ‘Wuna néma du nak gaayét ye katik bari waambule yaaké dé.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wunga watake dé dale jémbaa yakwa dunyansat viyaakandékwa. Viyaatake waangété kulak kakwa dunyansale rate kakému kate waangété kulak kate waangété yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yate déku néma duké vékulakakapuk yaréndu wani sapak déku néma du waambule yaakandékwa. Vékusékngapuk yandékwa sapak wa waambule yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yaae wani jémbaa yakwa du yan kapérandi musé véte dat némaanmba viyaakandékwa. Viyaae wandu ye paapu yakwa dunyansale rakandékwa, kapérandi taalémba. Wani taalémba raké yakwa du dakwa néma kaangél vékute géraakandakwa. Yéku taalémba raké mawulé yate némaamba géraakandakwa.” Jisas gwaaménja kundi wunga wandén, yéku mawulé vékute waambule yaaké yandékwanngé kaavéré-ndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wani kundi watake Jisas anga wandén: “Waambule yaaké yawutékwa nyaa Got wandu du dakwa ras dale randaru du dakwa ras dale katik raké daré. Got néma du rate anga yakandékwa. Du nak taakwa kéraaké yandén. Yandéka dakwa tambavétik (10) deku lam kéraae kure dé ve kure ye du ambét taakwale kakému kaké yaambutaku yéténdarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wani dakwa taambak (5) de yéku mawulé vékundarén. Yandaka dakwa taambak (5) de yékunmba yamba vékulakandakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yate deku lam kure yéte yaa vérékngwa gu ras waak yamba kure yéndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yandaka yéku mawulé vékukwa dakwasé deku lam kure yéte yaa vérékngwa gu ras waak kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ye yaambumba randaka taakwa kéraaké yakwa du bari yamba yaandékwe wa. Yandéka wani dakwana méni yundé yandéka kwaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kwaandaka nyéndéngan yandéka vékundarén du nak anga waandéka, ‘Taakwa kéraaké yakwa du a yaakwa. Guné ma ye yaambumba dé ve kure yaangunék.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wunga waandéka wani kundi vékutake wani dakwasé akwi vélérkiyaae waarape deku lam yavérékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yavérékndaka yaa vérék guké yékunmba vékulakakapuk yan dakwasé yéku mawulé vékukwa dakwat wandarén, ‘Guné nanat yaa vérékngwa gu ras ma tiyaangunu. Nana lam a kiyaakngate yakwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wunga wandaka yéku mawulé vékukwa dakwa wa det wan, ‘Yamba wa. An ayélap a tékwa. Nané ras gunat kwayémunaananu nana lam akwi ka kiyaakna. Guné stuamba ma ye ras kéraangunu.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wunga wandaka wani yaa vérékngwa gu kéraaké yéténdaka wani taakwa kéraaké yakwa du yaan. Yaandéka yéku mawulé vékukwa dakwasé dé kure ye kakému kaké yandakwa gaamba wulaandarén. Wulaandaka pété tépéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kukmba yékunmba vékulakakapuk yan dakwasé yaae waandarén, ‘Néma du, pété ma naapi. Nané yaalananu.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wunga waandaka taakwa kéraaké yakwa du det wandén, ‘Yamba wa. Wuné guné yamba vékusékwutékwe wa. Gunat wa wawutékwa. Papukundi yamba wawutékwe wa.’ Yékunmba vékulakakapuk yan dakwat wunga wandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wani kundi watake Jisas det wandén, “Wani kundiké vékulakate wunéké waak ma vékulaka. Waambule yaaké yawutékwa nyaaké yamba vékusékngunéngwe wa. Yate wunéké kaavéréte ma yékunmba véréngunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wani kundi watake Jisas ani gwaaménja kundi wandén: “Waambule yaaké yawutékwa nyaa Got néma du rate anga yakandékwa. Néma du nak, nak gaayét yéké yate déku jémbaa yakwa duwat waandéka yaandaka det wandén, de déku yéwaa kéraae wani yéwaale jémbaa yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Watake deku mayé apaké vékusékte wa det nak nak yéwaa muni waate kwayéndén. Nakét yéwaa 5,000 kwayéndén. Nakét yéwaa 2,000 kwayéndén. Nakét yéwaa 1,000 kwayéndén. Wunga kwayétake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yéndéka yéwaa 5,000 kéraan du bari ye wani yéwaale jémbaa ye némaamba yéwaa ras waak wanale kéraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yéwaa 2,000 kéraan du dé waak wani yéwaale jémbaa ye rékaamba yéwaa ras waak wanale kéraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yéwaa 1,000 kéraan du wani yéwaale jémbaa yamba yandékwe wa. Dé ye kwaawu vaae wani yéwaa kwaawumba rémndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kukmba némaamba kwaaré yéndéka néma du nakapuk waambule yaandén, déku jémbaa yakwa duké. Yaae det kwayéndén yéwaaké dele kundi bulké mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yandéka dé yéwaa 5,000 kéraan du wani yéwaa kure yaae kwayéte wandén, ‘Néma du, méné wunat yéwaa 5,000 wa tiyaaménén. Bulaa ma vé. Wani yéwaale jémbaa yawutéka tiyaandarén yéwaa anana. Yéwaa 5,000 ras waak wa kéraawutén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wunga watake akwi yéwaa kwayéndéka déku néma du wa wan, ‘Méné yéku jémbaa yakwa du wa. Yéku jémbaa yaménén. Méné makal muséké wa yékunmba véménén. Véménénngé wuné wawutu méné némaamba muséké néma du rakaménéngwa. Méné wunale rate, aané sékét mawulé tawulé yate yékunmba rakatékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Dé wunga wandéka yéwaa 2,000 kéraan du dé waak yaae wandén, ‘Néma du, méné wunat yéwaa 2,000 wa tiyaaménén. Bulaa ma vé. Wani yéwaale jémbaa yawutéka tiyaandarén yéwaa anana. Yéwaa 2,000 ras waak wanale kéraawutén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wunga watake akwi yéwaa kwayéndéka déku néma du wa wan, ‘Méné yéku jémbaa yakwa du wa. Yéku jémbaa yaménén. Méné makalkéri muséké yékunmba véménén. Véménénngé wuné wawutu rékaamba muséké néma du rakaménéngwa. Méné wunale sékét rate, aané mawulé tawulé yate yékunmba rakatékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dé wunga wandéka yéwaa 1,000 kéraan du dé waak yaae wandén, ‘Néma du, ménéké vékusékwutékwa. Méné du dakwaké mawulé yamba sémbéraa yaménéngwe wa. Méné musé ras waak kéraaké mawulé yate jémbaa yate nak du dakwat yékun yamba yaménéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wuné ménéké wup ye wa képmaamba kwaawu vaae ména yéwaa rémwutén. Rémtake nakapuk kéraae ména yéwaa ménéké kure yaawutékwa. Ma kut.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wunga wandéka néma du dat wandén, ‘Méné kapérandi jémbaa yate saalakukwa du wa. Wuné waménén pulak nak du dakwaké sémbéraa yakapuk yate, musé ras waak kéraaké mawulé yate, jémbaa yate, nak du dakwaké yamba vékulakawutékwe wa. Wunga wa yawutékwa. Yi wan wanana wa. Wunga yawutékwanngé wa vékusékménéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vékusékte kamuké méné wuna yéwaa kure ye yéwaa taakandakwa gaamba taakakapuk yak? Méné wamba taakamunaaménu wuné waambule yaae wani yéwaa kéraate yéwaa ras waak kéraakate yawutén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wunga watake jémbaa yakwa nak duwat wandén, ‘Guné dat kwayéwutén yéwaa démba kéraae yéwaa 10,000 kéraan duwat ma kwayéngunék.’ Naandén.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jisas wani kundi watake det wandén, “Yéku jémbaa ye némaamba musé kéraan du dakwa kukmba musé ras waak kéraakandakwa. Yéku jémbaa yakapuk ye ayélapkéri musé kéraan du dakwa kukmba baka rakandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jisas wunga watake wandén, “Wani néma du déku jémbaa yakwa dunyansat wandén, ‘Kapérandi jémbaa yan du ma kéraae kaapat vaanjang-ngwandéngunék. Yangunu ganngu yakwa kapérandi taalémba yarékandékwa. Wani taalémba du dakwa néma kaangél vékute géraakandakwa. Yéku taalémba yaréké mawulé yate némaamba géraakandakwa.’ Néma du wunga wandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wani kundi watake Jisas anga wandén: “Kukmba wuné Duna Nyaan waambule yaakawutékwa. Gotna kundi kure gaayakwa dunyan wunale yaandaru wuné akwi du dakwaké néma du rakawutékwa. Apa tapa yate néma du rate deké wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ani képmaamba tékwa akwi du dakwa wuna ménimba jaawuwe saakikandakwa. Saakindaru wawutu de kém vétik kutéke tékandakwa. Sipsipké séngite kaavérékwa du yandékwa pulak yakawutékwa. Dé jémbaa yate sipsip meme pévéndéka sipsip nak taalat yéndaka meme nak taalat yéndakwa. Wani du yakwa pulak wa yakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yate wuné du dakwat wawutu du dakwa ras wuna yékutuwa saku taambamba téndaru ras wuna akituwa saku taambamba tékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Téndaru wuné néma du rate wuna yékutuwa saku taambamba tékwa du dakwat anga wakawutékwa, ‘Wuna aapa Got gunat wa yékun yandén. Bulaa guné ma yaala. Yékunmba rapékaké yangunéngwa taalé wa yékun yan. Talimba ani képmaa baasnyé ye yandén sapak wa yékunmba rapékaké yangunéngwa taaléké wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Talimba wuné kaandale rawutéka wunat wa kakému tiyaangunén. Kulak yandéka wunat kulak tiyaangunénga wa kawutén. Wuné nak gaayémba yaawutéka wunat guna gaat wa kure yéngunén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wuné laplapkapuk baka téwutéka wunat laplap tiyaangunénga giwutén. Baat yandéka wunat wa yékun yangunén. Wuné kalapusmba kwaawutéka yaate wunéké véngunén. Wunga yangunénngé bulaa yéku taalémba yékunmba rapéka-kangunéngwa.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wuné wunga wawutu yéku musé yakwa du dakwa anga wakandakwa, ‘Néman Du, yani nyaa méné kaandale raménénga nané ménat kakému kwayék? Yani nyaa méné kulakngé kiyaaménénga nané ménat kulak kwayék? ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yani nyaa méné nak gaayémba yaaménénga nané méné nana gaat kure yék? Yani nyaa méné laplapkapuk baka téménénga nané ménat laplap kwayék? ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yani nyaa ménat baat yandéka nané ménat yékun yak? Yani nyaa méné kalapusmba kwaaménénga nané ménat véké yék?’ ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wunga waatakundaru wuné néma du rate det anga wakawutékwa, ‘Guné wuna jémbaamba yaalan du dakwat nak yékun yate wa wunat waak wa yékun yangunén. Yi wan wanana wa. Gunat wa wawutékwa.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wunga watake wuna akituwa saku taambamba tékwa du dakwat anga wakawutékwa, ‘Got gunat wa kuk kwayéndén. Bulaa guné wuné yaasékatake yaa yaanpékatékwa taalat ma yéngunék. Wani yaa katik kiyaakngé dé. Talimba Got wani taalé yatake wandén, “Satan déku dunyansale wani kapérandi taalémba rakandakwa.” Wunga wandén taalat ma yéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Talimba wuné kaandale rawutéka guné wunat kakému yamba tiyaangunéngwe wa. Kulak yandéka guné wunat kulak yamba tiyaangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wuné nak gaayémba yaawutéka wunat yamba kure yéngunéngwe wa guna gaat. Wuné laplapkapuk baka téwutéka wunat laplap yamba tiyaangunéngwe wa. Wunat baat yandéka, kalapusmba waak kwaawutéka guné wunat yamba yaae véngunéngwe wa.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wunga wawutu de waak wakandakwa, ‘Néman Du, yani nyaa méné kakému kulakngé kiyaaménénga vétake nané ménat kakému kulak yamba kwayénangwe? Yani nyaa méné nak gaayémba yaaménénga, laplapkapuk baka téménénga, ménat baat yandéka, kalapusmba kwaaménénga, véte nané ménat yékun yakapuk yak?’ Naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wunga wandaru wuné néma du rate det anga wakawutékwa: ‘Guné wuna jémbaamba yaalan du dakwat nak yékun yakapuk yate wa wunat waak yékun yamba yangunéngwe wa. Det kuk kwayéte wunat waak wa kuk kwayéngunén. Yi wan wanana wa. Gunat wa wawutékwa.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Wunga wawutu wuna jémbaamba yaalan du dakwat yékun yakapuk yan du dakwa kapérandi taalat yékandakwa. Ye wamba rate néma kaangél vékupékaaté-kandakwa. Yaténdaru wuna jémbaamba yaalan du dakwat yékun yan du dakwa yéku gaayét ye apapu apapu yékunmba rapéka-kandakwa.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas wani kundi wasékéyaktake déku dunyansat ani kundi wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Anga wa vékusékngunéngwa. Nyaa vétik male re nané Judasé Pasova waanangwa nyaana kakému yaake kakanangwa. Wani sapak Duna Nyaan wuné wuna maamat kwayéndaru wunat takwemimba baangtaka-kandakwa.” Det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wani sapak Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, maaka dunyan waak ye deku néma duna gaamba jaawuwe randarén. Wani néma duna yé Kaiafas wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rate kundi bulndarén, de yakélak ye Jisas kulkiye viyaandékngé. Bule wunga yaké wa kundi gindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kundi gite wandarén, “Dé ma viyaandékngwak. Kakému yaake kaké yanangwa nyaa, dé katik kulkiké nané. Bulaa némaamba du dakwa wani kakému kaké ani gaayét wa yaandarén. Bulaa nané Jisas kulkinanu, wa de rakarka ye nanat némaanmba waarukandakwa. De yéndarumbut dé kulkiye viyaandékngwak.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Jerusalem taakatake Betanit yéndén. Ye saambake talimba lepro yan du déku yé Saimon déku gaamba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rate kakému karéndaka taakwa nak matumba yandarén makalkéri botol kure yaalén. Wani botolmba yéku yaama yakwa gu wa tén. Dunyansé wani gu kéraaké némaamba yéwaa wa kwayékandakwa. Wani taakwa yaae Jisas ranmba téte déku maakamba wani gu sévilén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Séviléka Jisasna dunyan véte rakarka yandarén. Yate wandarén, “Kamuké lé wani gu baka sévik? ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wani gu wan yéku gu wa. Lé wani gu kwayéte némaamba yéwaa kéraae musékapuk du dakwat kwayémunaalu yékunmba yakatik.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas deku kundi vékutake det wandén, “Kamuké guné wani taakwat waaruwu? Wunga yaké yambakate. Wan yéku musé wa yalén wunat. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Musékapuk du dakwa gunale rapéka-kandakwa. Apapu apapu guné det yékun yakangunéngwa. Wuné gunale katik yarépékaké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wani taakwa wuné kiyaawutu kwaawumba rémngé yandakwanngé vékulakate wa wani gu wuna sépémba sévilén.” Wunga wate Judasé pusaa rémngé yate yandakwanngé wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Watake det anga wandén, “Kukmba wuna kundi akwi képmaamba kwayéte ani taakwa yan muséké waak wakandakwa. Wate léké vékulaka-kandakwa. Yi wan wanana wa. Gunat wa wawutékwa.” Det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wani sapak Jisasna du nak déku yé Judas Iskariot dé Gotna gaamba jémbaa yakwa dunyanna néma dunyanséké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ye det wandén, “Guné wunat kamu tiyaangunu wuné Jisas gunat kwayéké wuté?” Wunga wandéka déké yéwaa 30 kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kwayéndaka ye Jisas det kwayéké yandékwanngé vékulakandén. Vékulakate wani muséké bulkapuk yaréte Jisas kwayéké yandékwa sapakngé kaavéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pasova waanangwa kakému yaake kanangwa sapak nané Judasé bret kate yis kurkapuk yandarén bret male kanangwa. Wani sapak yandéka yis kurkapuk yandarén bret baasnyé ye yaakéndarén nyaa Jisasna dunyansé yaae dat wandarén, “Musé yani taalémba kururétakananu Pasova waanangwa sapakna kakému rate kaké méné mawulé yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wunga wandaka wandén, “Guné Jerusalemmba wulaae talimba wawutén duwat ve dat ma wangunék, ‘Nana néma du, Gotna kundiké nanat yakwasnyékwa du anga wandékwa, “Wuné kiyaaké yakwa sapak a yaakwa. Wuné wuna dunyansale ména gaamba Pasova kakému kakanangwa.” Naandékwa.’ Dat wunga ma wangunék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wunga wandéka Jisasna dunyan wandén pulak ye kakému kururétakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nyaa daawulindéka Jisas yaae déku dunyan tambavétik maanmba kaayék vétik wunga dele rate kakému karéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Karéte det wandén, “Nanale rakwa du nak wuné kwayékandékwa wuna maamasat. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wunga wandéka deku mawulé kapére yandéka vatvat naate nak nak dat waatakundarén, “Néman Du, wan wunéké méné wo kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wunga waatakundaka wandén, “Wunale sékét dismba tékwa kumbingumba bret vaanjande taawun du wa wuné maamasat kwayéké yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wuné Duna Nyaan kiyaakawutékwa. Gotna nyéngaamba kiyaaké yawutékwanngé talimba kundi viyaatakandarén. Kiyaawutu kapérandi musé yaakandékwa, wuné maamasat kwayékwate yakwa duké. Wani du déku aasa dé kéraakapuk yamunaalu wan yékun yakatik.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wunga wandéka Jisas maamasat kwayéké yakwa du Judas wa wan, “Néma du, wan wunéké méné wo kapuk?” Wunga wandéka Jisas dat wandén, “Yi. Wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisas déku dunyansale rate kakému karéte bret kéraae Gorét wandén, “Yéku musé wa tiyaaménén. Wan yékun wa.” Wunga watake bret bule déku dunyansat kwayéte wandén, “Ma kéraae kangunék. An wuna sépé a.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wunga watake wain kulak tén kasnya nak kéraae Gorét wandén, “Yéku kulak wa tiyaaménén. Wan yékun wa.” Naatake déku dunyansat kwayéte wandén, “Guné akwi ani kulak ma kangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","An wuna nyéki a. De wuné viyaandékndaru wuna nyéki vaakundu guné véte vékusék-ngangunéngwa. Got du dakwat yékun yaké wandén kundi wa sékérék-ngandékwa. Wuna nyéki vaakundu Got némaamba du dakwa yandarén kapérandi musé yasnyéputi-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gunat wawutékwa. Ani képmaamba téte wuné wain kulak nakapuk katik kaké wuté. Kukmba wuna aapa Got du dakwaké néma du randu, nané déku gaayémba dale rate wuné gunale kulé wain kulak kakawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wunga wandéka Gotna nyéngaamba kwaakwa gwaaré waatake waarape gwaande Oliv némbat waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yaambumba yéte Jisas déku dunyansat wandén, “Bulaa gaan guné akwi wunat kuk kwayéte yaange yékangunéngwa. Wunga vékusékwutékwa. Yaange yékwate yangunéngwanngé Gotna kundi déku nyéngaamba anga wa kwaakwa: Wuné sipsipké séngite kaavérékwa duwat viyaawutu sipsip yaange yékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wani kundi wandékwa pulak yaange yéngunu wa kiyaakawutékwa. Kiyaae kukmba nakapuk taamale waarape taale Galilit yékawutékwa. Yéwutu guné kukmba yaakangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wunga wandéka Pita wa wan dat, “Wuné ménat kuk katik kwayéké wuté. Katik yaange yéké wuté. Nak du ménat kuk kwayéte yaange yéndaru, wuné wunga katik yaké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wunga wandéka Jisas wa wan, “A vékusékwutékwa. Bulaa gaan séraa waakapuk téndu méné apu kupuk wakaménéngwa, ‘Wuné Jisas yamba véwutékwe wa.’ Wunga waménu séraa waakandékwa. Wunga vékusékte wa ménat wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wunga wandéka Pita wan, “Yamba yé wa. Wunga katik waké wuté. Wuné ménale kiyaakawutékwa. Wup katik yaké wuté. Wani kundi katik waké wuté.” Wunga wandéka Jisasna nak du akwi wungat male wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wani kundi watake Jisas déku dunyansale taalé nakét wulaandarén. Wani taaléna yé Getsemani wa. Wamba rate det wandén, “Guné amba ma ra. Wuna yékwa Gorale kundi bulké.” Wunga watake Pita, Sebedina nyaan vétik wunga kéraae kure sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yéténdaka déku mawulé kapére yandéka vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yate det wandén, “Wuna kwaminyan bérukwa. A kiyaakawutékwa. Guné wunale sékét amba véréngunék. Yundé kwaaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wunga wandéka véréndaka dé ayélap yépulak naae képmaamba kwaate Gorét wandén, “Wuna aapa, akwi muséké wa apamama yaménéngwa. Méné yaaké yakwa muséké waké mawulé ye, wa méné waménu wunéké yaaké yakwa vakmi wunéké katik yaaké dé. Ménat wunga waatakuwutékwa. Méné wuné mawulé yakwa pulak yaké yambak. Ménékét mawulé yaménéngwa pulak yaké ma yaménék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wani kundi watake déku dunyanngé waambule ye véndén yundé kwaakéséndaka. Vétake de sérkiyaate Pitat wandén, “Yénga pulak dé? Guné ayélapkéri sapak wunale raké yapatingunéngwa. Guné wa yundé kwaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Guné yundé kwaaké yambakate. Yékunmba vékulakate Gorét ma waataku, vakmi gunat yaavan kurkapuk yandénngé. Anga wa vékusékwutékwa. Guné yundé kwaamuké kalik yangunénga guna sépé apa tapa yakapuk yandéka wa gunat yundé yandéka wa yundé kwaangunén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wunga watake nakapuk det yaasékatake ayélap yépulak naae Gorét anga wandén, “Wuna aapa, wunéké yaaké yakwa vakmi wunéké yaandu wuné wani muséké kuk katik kwayéké wuté. Wani muséké yi naakawutékwa. Ménékét mawulé yaménéngwa pulak ma yaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wunga watake déku dunyanngé nakapuk waambule ye véndén nakapuk yundé kwaandaka. Deku ménimba yundé male yandéka wa kwaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Déku dunyansé nakapuk taakatake ye Gorale nakapuk bulte waatakundén. Taale Gorét waatakundén kundi male wa nakapuk waatakundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Waatakutake déku dunyanséké waambule yaae det sérkiyaate wandén, “Yénga pulak dé? Guné wayéka yundé kwapéko? Ma véku. Wuné Duna Nyaan wuné kapéremusé yakwa dunyansat kwayéké yandékwa sapak a yaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ma waarapngunu yékwak. Ma vé. Wuné maamat kwayéké yakwa du wa yaatékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wayéka téte bulténdéka déku du nak Judas yaan. Némaamba dunyan deku waariyandakwa kulaa, baangé waak kure Judasale sékét yaandarén. Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Israelna maaka dunyan waak wunga watakandaka wa yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Takamba Jisas maamasat kwayéké yakwa du Judas, Jisasét kulkiké yakwa dunyansat anga wandén, “Wuné taama réngwutékwa du wan Jisas wa. Dé ma kulkingunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas bari yaae Jisasét wandén, “Néma du, yéku mawulé vékute ma yaréménu.” Wunga watake dat taama réngndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yandéka Jisas dat wandén, “Méno, yaké mawulé ye, yaké yaaménén musé bari ma yaménu.” Wunga wandéka yaae dé kulkindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kulkindaka Jisasale tan du nak waariyandékwa kulaa kelike Gotna gaamba jémbaa yakwa akwi dunyanna néma dumba jémbaa yakwa duwat viyaae déku waan satékyasnyéndéka vaakérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Vaakétndéka dat Jisas wa wan, “Waariyaménéngwa kulaa tékwa wutmba ma waambule laakwa. Waariyandakwa kulaat dunyan waariyandaru nak du det waariyandakwa kulaat viyaandaru kiyaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wuné mawulé yamunaawutu wuné wuna aapat waatakuwutu bari wandu déku kundi kure gaayakwa némaamba dunyan yaae wunat yékun yakatik daré. Wani muséké méné yamba vékulaka-ménéngwe wa. Wuné wuna aapat wunga katik waatakuké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Talimba du ras Gotna nyéngaamba viyaatakandarén, nak du yaae wunat kulkiye kure ye viyaandékngé yandakwanngé. Wuna aapa wunat yékun yandénngé waataku-munaawutu wani kundi katik sékérékngé dé. Wuné wuna aapa wunat yékun yandénngé waatakukapuk yawutu de déku kundi kure gaayakwa dunyan wunat yékun yaké katik yaaké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wani kundi watake Jisas dat kulkiké yaan dunyansat wandén, “Guné wuné kurké yaate kamuké guné waariyangunéngwa kulaa baangé waak kure yaak? Guné sél yakwa duwat viyaaké guné wani musé kure yaau kapuk? Késépéri nyaa wuné Gotna kundi bulnangwa néma gaamba yatéte du dakwat Gotna kundiké yakwasnyéwutén. Wamba téwutéka wunat yamba kulkingunéngwe. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wunat yangunéngwa muséké talimba du ras Gotna nyéngaamba wa viyaatakandarén. Viyaatakandaka bulaa deku kundi wa sékérékngwa.” Wunga wandéka déku dunyan akwi dé yaasékatake yaange yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisas kulkiye kure yén dunyansé dé kure yéndarén Kaiafasna gaat. Kaiafas dé Gotna gaamba jémbaa yakwa akwi dunyanna néma du wa. Apakundiké vékusékngwa dunyan, Israelna maaka dunyan waak Kaiafasna gaamba jaawuwe randaka Jisas wani gaat kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yéndaka Pita Jisasna kukmba ye apakmba téndén. Téte véndén Jisas kulkin dunyan dé kure wani gaamba wulaandaka. Véte ye polisale kaapamba randén. Jisasét yaké yandakwa musé véké watake randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Randéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Israelna nak néma dunyan waak Jisas viyaandékngé mawulé yandarén. Yate wandarén, “Jisas yan kapéremusé raské kandé waké ya?” Wunga wate papukundiké kalik yamba yandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yate wandaka paapu yakwa némaamba dunyan yaae Jisas yan musé raské wandarén. Wandaka néma dunyan yandén kapéremuséké yamba vékundakwe wa. Yandaka du vétik yaambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Yaae wambérén, “Wani du anga wandén, ‘Wuné Gotna kundi bulnangwa néma gaa yaavan kurkawutékwa. Yaavan kure nyaa kupuk yéndu nakapuk kaakawutékwa.’ Wani du wunga wandén.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wunga wambéréka Gotna gaamba jémbaa yakwa akwi dunyanna néma du waarape téte Jisasét wandén, “Kamuké méné bérku kundi yamba waambule kaataménéngwe? Bérku kundi yénga pulak dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wunga wandéka Jisas kundi yamba bulndékwe wa. Yandéka Gotna gaamba jémbaa yakwa akwi dunyanna néma du dat wandén, “Wuné rapékakwa du Gotna yémba wate wawutékwa, méné wunat waménénngé. Méné Got wan du Krais méné kapuk? Méné Gotna nyaan méné kapuk?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wunga wandéka anga wandén, “Yi. Wa waménén. An gunat akwi wawutékwa. Kukmba vékangunéngwa, wuné Duna Nyaan néma du rate apa tapa yakwa du Gotna yékutuwa taambamba re buwiale anjoré nyétmba gaayawutu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas wunga wandéka Gotna gaamba jémbaa yakwa akwi dunyanna néma du rakarka yate déku laplap gérikte wandén, “Dé wunga wate Gorké kapérandi kundi bulte wa Gorét wasélékndén. Déku kundi wa vékungunén. Wan kapérandi kundi wa. Nak duwat katik waatakuké nané, yandén kapérandi muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yénga guné wo déké?” Wunga wandéka wandarén, “Kapéremusé wa yandén. Dé ma kiyaandu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wani kundi watake Jisasna saawimba sépmany sévaanguralndaka ras dat taambat viyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Viyaate dat wasélékte wandarén, “Méné Got wan du Krais, Gotna yémba kundi kwayékwa du rate méné akwi muséké wa vékusékménéngwa. Vékusékte, nanat ma wa. Kandé ménat viyaak?” Wunga wate dat wasélékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita kaapamba randén, gaaké aatmu gisangwandé-ndarénmba. Randéka wani gaamba jémbaa yakwa taakwa nak yaae dat walén, “Méné waak wan Galilimba yaan du Jisasale yatéménén wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wunga waléka Pita wamba rakésan du dakwana ménimba téte wandén, “Yamba wa. Wuné wa wanyénéngwa kundi yamba vékusékwutékwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wunga watake gwaande pétémba randén. Randéka jémbaa yakwa taakwa nak waak dat véte lale sékét tan du dakwat walén, “Ani du Nasaret du Jisasale wa yaténdén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wunga waléka némaanmba wandén, “Yamba yé wa. Wani du yamba véwutékwe wa. Gotna yémba wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wunga wandéka ayélap raré naae wamba tan du ras dat yaae wandarén, “Galili du bulndakwa pulak wa kundi bulménéngwa. Méné waak Galilimba yaan du wa. Méné Jisasna du nak wa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wunga wandaka Pita det némaanmba wandén, “Yamba yé wa. Wani du yamba véwutékwe wa. Gunat wa wawutékwa. Papukundi wamunaawutu Got wunat yénga viyaandu.” Naandéka wa séraa waan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Waandéka Jisas dat wandén kundiké vékulakandén. Takamba Jisas wa wandén, “Anga wa vékusékwutékwa. Séraa waakapuk téndu apu kupuk wakaménéngwa, ‘Wuné dé yamba véwutékwe wa.’ Wunga waménu séraa waakandékwa.” Naandén. Pita Jisasét kuk kwayétake Jisas wan kundiké vékulake gwaande néma sémbéraa yate géraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yé gétndéka Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, Israelna maaka dunyansé waak kundi gindarén, Jisas viyaandékngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kundi giye dé baangwit giye Romna néma du Pailatké kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisas maamat kwayén du Judas, Jisas viyaandékngé bulndaka vékundén. Vékutake nak mawulé yate Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, Israelna maaka dunyansé waak wunga randaka deké waambule yéndén. Ye dat kwayéndarén yéwaa det nakapuk waambule kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kwayéte wandén, “Wuné kapérandi musé wa yawutén. Kapérandi musé yakapuk duwat wa déku maamasat kwayéwutén. Kwayéwuténngé wa dé viyaandaru kiyaakandékwa.” Naandéka wandarén, “Wan nana jémbaa yamba wa. Wan ména jémbaa wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wunga wandaka wani yéwaa Gotna kundi bulndakwa néma gaamba vaanjolatake yéndén. Ye dé baangwimba kwalko ye kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gotna gaamba jémbaa yakwa dunyanna néma dunyansé vaanjolandén yéwaa kéraate wandarén, “An du viyaandékndarénngé kwayénanén yéwaa a. Ani yéwaa Gotna kundi bulnangwa néma gaamba rakwa yéwaale taakamunaae, wa Moses wan apakundit kuk wa kwayékatik nané. Wani yéwaale katik taakaké nané.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naatake wani yéwaa kéraae képmaa aké nyaakwa duwat kwayétake déku képmaa kéraandarén. Kéraae wandarén, “Nak gaayémba yaan du dakwa nana gaayémba kiyaandaru det ani képmaamba rémnganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naatake wunga yandaka du dakwa wani képmaaké yé anga waandarén, “Nyéki képmaa.” Bulaa waak wani képmaaké wunga yé waanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gotna gaamba jémbaa yakwa dunyanna néma dunyansé wunga yandaka Gotna yémba talimba yatéte kundi kwayétan du Jeremaia viyaatakan kundi wa sékérékén. Jeremaia Gotna nyéngaamba anga viyaatakandén: Israel du dakwa anga wandarén, “Dé ma kéraakwak. Yéwaa ras (30) kwayétake dé kéraakanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wunga watake de wani yéwaa kéraae képmaa aké nyaakwa duwat kwayéte déku képmaa kéraandarén. Néman Du Got wunat wandén wani muséké. Jeremaia wunga viyaatakandén, Jisasna aasa dé kéraakapuk yalén sapak. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas kure ye Romna néma du Pailatna ménimba taakandaka téndén. Téndéka Pailat dat waatakundén, “Méné Judaséna néma du méné kapuk?” Wunga waatakundéka Jisas wa wan, “Yi. Ména kapmang wa wunga waménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wunga wandéka Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, Israelna maaka dunyansé waak papukundi wandarén, Jisas yan muséké. Jisas wani kapéremusé yamba yandékwe wa. De dat papukundi wandaka deku kundi nak waambule yamba wandékwe wa. Kundi nak yamba bulndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yandéka Pailat dat wandén, “Ménéké wandakwa akwi kundi méné vékwo? Kamuké méné kundi bulkapuk téte véto?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wunga wandéka yamba kundi nak wandékwe wa Pailarét. Yandéka wa Pailat vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akwi kwaaré Pasova waanangwa nyaana kakému kanangwa sapak Romna néma du kalapusmba kwaakwa du nakét wandéka dé kalapus yaasékatake gwaande baka yékunmba yéndékwa. Jerusalemmba tékwa du dakwa deku mawulémba vékulakate Romna néma duwat waandaka mawulé yandakwa duwat wandéka kalapus yaasékatake gwaande baka yékunmba yéndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wani sapak kapéremusé yan du nak kalapusmba kwaandén. Déku yé Jisas Barabas. Némaamba du dakwa déké vékusékndarén wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat anga wa vékusékndén. Jisas kapéremusé nak yamba yandékwe wa. Néma dunyan Jisaské kalik yate dat giye kure yaandarén déké. Wunga vékusékte déku mawulémba wandén, “Kalmu amba jaawuwe tékwa du dakwa Jisaské mawulé yaké daré kapuk?” Wunga wate wani du dakwat wandén, “Yénga pulak guné mawulé yo? Kandat wawutu yékunmba yéké dé? Barabasét wawutu kalapus yaasékatake yaale baka yékunmba yéké dé, kapuk Got wan du Krais waandakwa du Jisasét wawutu dé baka yékunmba yéké dé?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat kundi vékundékwa taalémba randéka lé déku taakwa kundit wasatite walén, “Méné wani yéku musé yakwa duwat yaavan kurké yambak. Gaan kwaae déké yéngan wa kwaawutén. Kwaawutéka wuna mawulé kapére yandékwa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, Israelna maaka dunyansé waak wamba tékésén du dakwat wandarén, Pailarét wandaru Pailat wandu Barabas kalapus yaasékatake yaale baka yékunmba yéndu de Jisasét viyaandékndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wunga wandaka néma du Pailat det nakapuk waatakundén, “Ani du vétikngé yénga pulak guné mawulé yo? Kandat wawutu dé gunéké yaale baka yékunmba yéké dé?” Wunga wandéka wandarén, “Barabas.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wunga wandaka Pailat wa wan, “Krais waandakwa du Jisasét yénga pulak yaké wuté?” Wunga waatakundéka wa akwi wandarén, “Dé takwemimba ma baangtaka.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wunga wandaka wandén, “Kamuké? Kamu kapérandi musé dé yak?” Wunga wandéka némaanmba waandarén, “Dé takwemimba ma baangtaka.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","De wunga waandaka Pailat déku mawuléké wandén, “Wuna kundi yamba vékundakwe wa. Deku kundi vékukapuk yamunaawutu wa waariyakandakwa.” Wunga watake gu ras kéraae akwi du dakwana ménimba téte déku taamba yakwasnyéndén. Yakwasnyéte wandén, “Wuné guna ménimba taamba a yakwasnyéwutékwa, guné véte anga vékusékngunénngé. Wuné ani duwat viyaandékmuké kalik yawutékwa. Guné dat viyaandékngunan, wa guna musé wa. Wuna musé yamba wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Naandéka wamba tan du dakwa wa wan, “Wa vékunangwa. Dé kiyaandénngé wa mawulé yanangwa. Got wani muséké, ‘Kapérandi musé wa,’ naamunaate nanat, nana nyambalat waak yénga viyaandu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wunga wandaka wandén Pailat, Barabas kalapus yaasékatake gwaande baka yékunmba yéndénngé. Watake déku waariyakwa dunyansat wandén, Jisasét raamény baangwit némaanmba viyaae dé takwemimba baangtakandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailatna waariyakwa dunyansé deku néma gaat Jisas kure yéndarén. Kure yéndaka akwi waariyakwa dunyan dé ténmba jaawundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Jaawuwe deku mawulémba wandarén, “Néma du gwaavé laplap saawuwe yéku hat saaptakandakwa.” Wunga wate dat waangite wasélékte Jisasna laplap laaritake gwaavé laplapét saawutakandarén. Saawutake raamény baangwi nak kéraae hat pulak nyéwayékwe déku maakamba taakandarén. Taakatake baangé nak kéraae déku yékutuwa saku taambamba taakandarén. Taakatake dat kwaati séte waangite wasélékte wandarén, “Méné Judaséna néma du, yékunmba ma raménék.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wunga wate dat sépmany sévaanguralte wani baangé kéraae déku maakamba viyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wani yapaté akwi yasékéyaktake wani saawutakandarén gwaavé laplap laariye déku laplap nakapuk saawutakandarén. Saawutake dé takwemimba baangtakaké kurindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yaambumba yéte waariyakwa dunyansé, Sairini du nak déku yé Saimon véndarén. Vétake dat wandarén, dé Jisas baangtakaké yandakwa takwemi yaatandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wandaka yaatandéka ye Golgota waandakwa taalémba saambakndarén. Wan Judana kundi wa. Nana kundimba wanangwa, Duna Maaka Apa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Saambake marasinale yandarén wain kulak Jisasét kwayéndarén, dé katake néma kaangél vékukapuk yandénngé. Kwayéndaka kakwe vétake yamba kandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yandéka dat takwemimba baangtakandarén. Baangtake rate déku laplap muni waataké satu pulak pilai yandarén. Yandaka det taalékéran du wa déku laplap kéraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kéraandéka wani taalémba rate Jisaské véréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisasét baangtakandarén takwemina waambumba anjoré taakandarén kundi wan anga wa: “An Judaséna néma du Jisas wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasét takwemimba baangtake waariyate sél yan du vétikét takwemi vétikmba baangtakandarén. Nakét déku yékutuwa sakumba baangtakandarén. Nakét déku akituwa sakumba baangtakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dunyan ras yeyé yaayatéte Jisas takwemimba baangtakandaka téndéka véte dat waangite wasélékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Yate wandarén, “Ménawa. Yénga pulak dé? Méné Gotna kundi bulnangwa néma gaa yaavan kure nyaa kupuk yéndu nakapuk kaaké wa waménén. Bulaa ména kapmang ména sépat ma yékun yaménék. Méné Gotna nyaan témunaae méné wani takwemi yaasékatake ma gaayaménu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wunga wandaka Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, apakundiké vékusékngwa dunyansé, Israelna maaka dunyansé de waak Jisasét waangite wasélékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yate wandarén, “Dé nak duwat wa yékun yandén. Déku sépat yékun yaké yapatindékwa. Dé Israelna néma du ramunaae baangtakandarén takwemi yaasékatake gaayandu nané véte déké wakanangwa, ‘Dé Got wan du Krais wa.’ Naakanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dé wandén, ‘Wuné Gotna nyaan a. Got wunat yékun yakandékwa.’ Naandén. Bulaa vékanangwa. Got déké mawulé yate dat yékun yaké dé kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wunga wandaka bét Jisasale takwemimba baangtakandarén du vétik bérku takwemimba téte bét waak wani kundi male wate dat wasélékmbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nyaa naawuréndéka akwi képmaamba gaan yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ye téndéka kukmba nyaa tépatekwe daawuliké yaténdéka Jisas Hibruna kundimba némaanmba anga waandén, “Eli, Eli, lema sabaktani.” Wani kundi nana kundimba anga wa: “Wuna néma du Got, kamuké méné wunat kuk kwayu?” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wunga waandéka wamba tékésén du ras wani kundi vékute wandarén, “Wani du dé talimba yatéte Gotna yémba kundi kwayétan du Elaijat wa waandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wunga watake wamba tan du nak bari pétépété ye nyambiyap pulak musé ras kéraae nyéngi yakwa wain kulakmba taawundén. Taawundéka gumbés yandéka baangémba maaye Jisas kandénngé kusoré-kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yandéka ras téte wandarén, “Wayéka ma téte vékwak. Elaija kalmu yaae dat kurké dé kapuk?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wunga waténdaka Jisas nakapuk némaanmba waatake wunga kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jisas kiyaandéka Gotna kundi bulndakwa néma gaamba lékindarén sémény laplap anjorémba gérike ye andalamba késén. Ye tambék vétik yan. Yandéka waalé géndéka néma matu nyéndémba pukaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yandaka kiyaan du dakwa rémndarén kwaawu kepukandéka de talimba kiyaan Gotna du dakwa némaamba wa nakapuk taamale waarapndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kukmba Jisas taamale waarapndéka Jerusalemét wulaandarén. Wulaandaka némaamba du dakwa de véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Waariyakwa dunyan deku néma du waak Jisaské téte véténdarén. Véténdaka dé kiyaandéka waalé géndéka yaalan nak musé waak véte néma wup yandarén. Yate wandarén, “Wani du wan Gotna nyaan wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Némaamba dakwa yaae apakmba pulak téte de waak véndarén. Talimba Jisas Galili taakatake yaandéka de dale yaae dat kakému kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wani taakwa nak wan Makdala taakwa Maria wa. Nak Jems ambét Josepna aasa Maria wa. Nak Sebedina nyaan vétikna aasa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Garambu yandéka Arimatea du nak déku yé Josep yaandén. Dé némaamba musé kurerékwa du wa. Dé waak wan Jisasna du nak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yaae Romna néma du Pailatké yéndén. Ye Jisasna pusaa kéraamuké dat waatakundén. Waatakundéka wandéka Josepét kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kwayéndaka kéraae yéku waama laplapét valambatndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Valambare kure ye déku kwaawumba taakandén. Talimba wani kwaawu déku jémbaa yakwa dunyan wa matumba vaae wulaandarén. Dé Jisasna pusaa wani kwaawumba taakatake néma matu nak varémane ye yaambumba taakatépéndén. Taakatépétake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yéndéka bét Makdala taakwa Maria, Jems ambét Josepna aasa Maria Jisas taakandarén kwaawu ténmba téte vétémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas kiyaandéka kwaae ganmba Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Farisi dunyan waak Pailatké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ye dat wandarén, “Néma du, wani paapu yan du wayéka baka yatéte wandén kundiké vékulakanangwa. Anga wandén, ‘Nyaa kupuk yéndu wuné nakapuk taamale waarapkawutékwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wani kundiké vékulakate ménat waatakunangwa. Méné waménu waariyakwa dunyan ye dé taakandarén kwaawuké nyaa kupuk kurkale séngiréte vétékandakwa. Vétékapuk yamunaandaru kalmu déku dunyansé ye déku pusaa sél ye kure yéte du dakwat anga waké daré? ‘Kiyaae nakapuk taamale wa waarapndén.’ Wunga wandaru kukmba yaké yandakwa papukundi taale yandarén papukundit taalékéra-kandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wunga wandaka Pailat det wandén, “Guné waariyakwa dunyansat kéraangunu ye wani taaléké ma séngindaru.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wunga wandéka ye de kwaawumba taakatépéndarén matumba baangwi gitake bi pulak musé taakandarén, du yakélak paakwe ye wulaakapuk yamuké. Yatake waariyakwa dunyansé rasét wandaka wani kwaawuké séngiténdarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judana yaap yaré nyaa yéndéka Sande ganmbamba nyaa yaalaké yaténdéka Makdala taakwa Maria, Jems ambét Josepna aasa Mariale bét Jisasna pusaa taakandarén taalé véké yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yétémbéréka néma waalé génén. Géndéka Néman Du Gotna kundi kure gaayakwa du nak Gotna gaayémba gaayandén. Gaaye kwaawumba taakatépéndarén matu varémansatitake wani matu taakumba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Déku saawi nyét kusnyérakngwa pulak yan. Yandéka déku laplap waama buwi pulak wamatama ye kalkal naan. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yandéka wamba tékésén waariyakwa dunyan néma wup yate képmaamba vaakére kiyaan dunyan pulak kwaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wani taakwa vétik ye vémbéréka Gotna kundi kure gaayakwa du bérét wandén, “Wup yaké yambak. Anga wa vékusékwutékwa. Takwemimba baangtakandarén du Jisaské waake véké wa yaambénén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Talimba wandén pulak wa nakapuk taamale wa waarapndén. Dé amba yamba re wa. Ma yaae vémbénu taakandaka kwaandén taalé. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vétake bari ye déku dunyansat anga ma wambénu, ‘Jisas kiyaae bulaa wa nakapuk taamale waarapndén. Waarape taale yéndékwa Galilit. Guné ye dé wamba vékangunéngwa.’ Wunga det ma wambénu. Bénat wa wawutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wunga wandéka wup yate mawulé tawulé yate wani taalé yaasékatake bari pétépété yémbérén, déku dunyansat wani kundi waké. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yémbéréka Jisas bérét yaambumba vétake wandén, “Béna mawulé yékunmba yénga téndu.” Naandéka dat yaae kwaati séte déku maanmba kutte déké waandé daambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yambéréka Jisas bérét wandén, “Wup yaké yambak. Béné ye wuna dunyansat wambénu Galilit yéndarék. Ye wani taalémba wuné vékandakwa.” Naandén Jisas bérét. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wani taakwa vétik wayéka yétémbéréka Jisasna pusaa taakandarén taaléké séngiye tan dunyan ras Jerusalemét wulaae yaandéka véndarén muséké Gotna gaamba jémbaa yakwa dunyanna néma dunyansat wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wandaka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan Israelna maaka dunyansale jaawuwe kundi bulte wa kundi nak gindarén. Gite séngitan dunyansat némaamba yéwaa kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kwayéte det wandarén, “Du dakwat anga ma wangunu, ‘Gaan yundé kwaananga Jisasna dunyan yaae déku pusaa wa sél ye kure yéndarén.’ Naangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wunga wangunu Romna néma du wani kundi vékute rakarka yandu dat wananu gunat katik waaruké dé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wunga wandaka séngiye tan dunyan wani yéwaa kéraae kure ye Gotna gaamba jémbaa yakwa dunyanna néma dunyansé wan pulak wandarén. Wandaka Judasé wani kundi vékundarén. Bulaa waak wani kundi male vékundakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisasna dunyan tambavétik maanmba kaayék nakurak (11) Galilit yéndarén. Ye Jisas yéndarénngé wandén wani némbumba saambakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ye Jisasét wamba vétake déké kwaati séte waandé daandarén. Yate de ras déké yékunmba vékulakakapuk yate wandarén, “Ani du an kiyaae taamale waarapén du Jisas dé kapuk?” Wunga vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas yaae déku dunyansat wandén, “Got wunat akwi mayé apa wa tiyaandén. Tiyaandénngé wuné nyét képmaaké waak néma du rakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Raké yawutékwanngé vékulakate gunat anga wawutékwa. Guné ma ye akwi képmaamba tékwa du dakwat wangunu wuna jémbaamba yaalandarénngé. Yaalandaru Gorké vékulakate ma wangunék, ‘Aapana yémba, Nyaanna yémba, Gotna Yaamambina yémba a yanangwa.’ Naate det ma baptais kwayéngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gunat kwayéwutén akwi kundi det ma kwayéngunu wuna kundi yékunmba vékukandakwa. Vékute wawutén pulak yakandakwa. Ani muséké yékéyaak yaké yambak. Wuné gunat katik yaasékaké wuté. Akwi gaan nyaa gunale yatépéka-kawutékwa. Ani képmaa késké yakwa sapak wuné gunale yatépéka-kawutékwa.” Jisas déku dunyansat wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","An yéku kundi a, Gotna nyaan Jisas Kraiské. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Taale Gotna yémba kundi kwayétan du nak déku yé Aisaia Gotna nyéngaamba anga viyaatakandén: Got déku nyaanét anga wandén, “An wuna kundi kure yékwa du a. Wuné wawutu wa dé taale yéte ména yaambu kurkandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Du yarékapuk taalémba du nak a waatékwa. Waate anga wandékwa, “Néman Duna yaambu ma kutngunék. Kutngunu yaambu kurkale kwaakandékwa déké.” Wani gwaaménja kundi talimba Aisaia wa viyaatakan. Du dakwana mawulé yékunmba téndu, de Jisas yaaké yandékwanngé yékunmba vékulaka-ndarénngé, wa wani kundi viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jonna aasa dé kéraakapuk yalén sapak wa Aisaia wunga viyaatakandéka kukmba baptais kwayékwa du Jon yaténdén du yarékapuk taalémba. Yatéte déké yaan du dakwat anga wandén, “Guné vékungunén kapérandi mawulé ma yaasékangunék. Yangunu Gotna yémba gunat baptais kwayékawutékwa. Guné wunga yaasékatake Gotna yémba baptais kéraangunu Got guna kapérandi mawulé yasnyéputi-kandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wunga wandéka Jerusalemmba tékwa du dakwa, Judia distrikmba tékwa nak du dakwa waak, némaamba du dakwa wa déké yéndarén. Ye yandarén kapérandi muséké kalik yate wandaka Gotna yémba det baptais kwayéndén, Jordan kaambélémba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon yéku laplapké, yéku kakémuké yamba vékulakandékwe wa. Dé kamelna yéwimba yaaténdarén laplapét gindén. Giye bulmakau sépémba yandarén lerét gindén. Jap, saam gék pulak musé waak wa kandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Du dakwat anga kundi kwayéndén, “Wuna kukmba du nak dé a yaakwa. Déku mayé apa wa wuna mayé apat taalékéran. Dé néma du wa randékwa. Wuné baka du a téwutékwa. Téte yénga pulak déku jémbaa yaké wuté? Baka du téte déké jémbaa yaké yapatiwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gunat Gotna yémba wa baptais kwayéwutén. Dé Gotna Yaamambi wa gunat kwayékandékwa.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wani sapak Jisas Nasaretmba yaandén. Wani gaayé Galili distrikmba wa téndékwa. Yaandéka Jon dat Jordan kaambélémba Gotna yémba baptais kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kwayéndéka dé gumba yaalatéte véndén. Nyét bari kepukandéka Gotna Yaamambi nyaamiyo pulak ye déké gaayandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gaayandéka kundi nak Gotna gaayémba anga wan, “Méné wuna nyaan wa. Ménéké néma mawulé wa yawutékwa. Ménéké wuna mawulé yékun yandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gotna Yaamambi bari wandéka Jisas du yarékapuk taalat yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Waaléwasa male tén taalat. Ye saambake nyaa dumi vétik (40) wamba kapmang yaréndéka Satan wa yaae déku mawulé yakwe véndén. Yandéka Gotna kundi kure gaayakwa dunyansé wa gaaye Jisasét yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kukmba néma du wandéka Jon kalapusmba kwaandéka Jisas yéndén Galili distrikét. Ye Gotna kundi anga kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Talimba Got wa wandén, dé néma du rate gunéké véké yandékwanngé. Bulaa Got néma du rate gunéké véké yandékwa sapak a yaakwa. Yaandékwanngé vékulakate guné guna kapérandi mawulé yaasékatake Gotna kundi ma vékungunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Galili néma gu kwaawu nak saku aarkémba yététe véndén Saimon déku waayéka Andruale bérku jémbaa yarémbéréka. Bérku jémbaa yate bét wani néma gu kwaawumba aaswut taakaréndarén gukwamiké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Vétake anga wandén, “Ma yaambénu wunale. Yaambénu bénat nak jémbaaké yakwasnyé-kawutékwa. Yakwasnyéwutu gukwami kutmbénén pulak du dakwa kéraakambénéngwa. Kéraambénu wuna kundi vékukandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Naandéka bari aaswut yaasékatake waarape wa dale yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","De ayélap yépulak naae Jisas véndén Sebedina nyaan vétik Jems ambét déku waayéka Jonét. Bérku aapa Sebediale déku jémbaa yakwa dunyansale sékét bérku botmba randarén. Rate aaswut kururérémbéréka Jisas bérét wandén, dale yémbérénngé. Wandéka bérku aapa déku dunyansale botmba rakéséndaka bét bari yaasékatake Jisasale yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas déku dunyansale sékét yéndarén Kaperneamét. Ye saambake yare yaap yaré nyaa Gotna kundi bulndakwa gaamba wulaae du dakwat Gotna kundiké yakwasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Apa tapa yate wa det Gotna kundi kwayéndén. Kwayéndéka apakundiké vékusékngwa dunyan wunga wakapuk yandaka du dakwa déku kundi vékute vatvat naate déké vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Yandaka kutakwa kulure kure yatékwa du nak wani gaat wulaandén. Wulaae Jisasét waate anga wandén, “Méné Nasaret du Jisas, nanat kamu yaké méné yaak? Nanat yaavan kurké méné yaak kapuk? Méné a vésékwutékwa. Méné Gotna yéku laku du wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Naandéka Jisas kutakwat anga wandén, “Nyéné kundi bulké yambak. Wani du yaasékatake ma yaale yaange yényénu.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Naandéka lé wani duwat taakusoraktake némaanmba waatake wa yaale yaange yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yaange yéléka akwi du dakwa véte vatvat naate deku kapmang bulte anga wandarén, “Yéki. Ani du kamu kulé kundi dé wo? Dé apamama yate kutakwat wandéka wa déku kundi vékundakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wunga wandaka de Galili distrikmba tékwa akwi gaayémba Jisaské kundi saapé yé yaayandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas Gotna kundi bulndakwa gaa yaasékatake yéndén. Jems, déku waayéka Jon, du ras waak, Jisasale wa sékét bari yéndarén. Ye Saimon ambét Andruna gaat wulaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonna naakumo baat yandéka kwaalén. Kwaaléka Jisasét bari wandarén léké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wandaka wulaae léku taambamba kutndéka waarapléka baat késén. Yandéka lé kakému yaake kurure det kwayélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Garambu nyaa daawulindéka yaap yaré nyaa yéndéka de baat yakwa du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalé, kutakwa kulure kure yatékwa du dakwa nyambalésat waak wa Jisaské kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kure ye wani gaayémba tékwa nak du dakwale jaawundarén gaa maakamba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jaawuwe téndaka wa némaamba du dakwa nyambalésat kururéndén. Yatake wandéka némaamba kutakwa du dakwa nyambalésé yaasékandarén. Yaasékatake yaange yéké yandaka wa dé kutakwat waarundén, de déké kundi saapékapuk yandarénngé. Déké wa vékusékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ganmbamba yé gérkapuk téndéka Jisas waarape gwaande yéndén, du dakwa yarékapuk taalat. Ye wamba Gorale kundi bulndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bulréndéka Saimon déku duwale sékét Jisaské waakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Waake vétake dat anga wandarén, “Akwi du dakwa ménéké waakpatindakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naandaka anga wandén, “Deké nakapuk katik waambule yéké wuté. Nané nak gaayét ma yékwak. Wani gaayémba waak Gotna kundi kwayékawutékwa. Wani jémbaa yamuké wa yaawutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naatake wa yéndén Galilimba tékwa akwi gaayét. Yéte kundi kwayéndén, Gotna kundi bulndakwa némaamba gaamba. Kwayéte wandéka wa de du dakwat kulure kure yatan kutakwasé yaange yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepro yan du nak yéndén Jisaské. Ye kwaati se waandé daate dat anga wandén, “Wuné yékun yawuténngé mawulé yamunaae, ma waménu wuné yékun yakawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naandéka déké sémbéraa ye déku taambat kutte anga wandén, “Yékun yaménénngé wa mawulé yawutékwa. Ma yékun yaménék.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Naandéka dé lepro bari késndéka wa yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yandéka dat némaanmba anga wandén, “Méné ma véku. Ménat yawutén muséké nak duwat waké yambak. Gotna kundi bulndakwa gaamba jémbaa yakwa duké bari ma ye déku ménimba téménu dé ména sépé vékandékwa. Véndu yékun yaménénngé méné Moses talimba wan pulak Gorké kwaami ma kwayéménék. Kwayéménu nak du dakwa véte lepro késndéka yékun yaménénngé wa vékusék-ngandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naandéka Jisasna kundi vékukapuk yate wa dé wani muséké akwi gaayémba saapéndén. Saapéndéka némaamba du dakwa Jisasale jaawuké mawulé yandaka dé Jisas kalik yate deku gaayét yamba wulaandékwe wa. Dé du dakwa yarékapuk taalat wa yéndén. Ye yaréndéka du dakwa dat vémuké wa yaandarén akwi gaayémba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kukmba Jisas waambule yéndén Kaperneamét. Waambule ye gaamba randéka déké kundi vékundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vékute némaamba du dakwa wani gaamba wulaakére téndaka taalé vékulékén. Vékulékndéka pétale yaambu yamba kwaae wa. Yandéka Jisas Gotna kundi kwayéndén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kwayéténdéka de du vétik vétik maan taamba kapére yan du nakét jaambémba yaate kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yaate ye némaamba du dakwa jaawundaka taalé vékulékénmba wa wulaae Jisas tanmba saambakngé yapatindarén. Yapatiye gaamba waare nak tambék saambun ayélap raapindarén Jisas tanale. Raapiye wani du kwaan jaambémba baangwi lékiye wani yaambumba dé jaambale kusandandarén du dakwana nyéndémba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kusande Jisas tanmba taakandaka dé vététe anga vékusékndén. De deku mawulémba wa wandarén wa, dé wani duwat kururéké apamama yaké yandékwanngé. Wunga vékusékte wani duwat anga wandén, “Wuna du, wuné yaménén kapérandi musé wa yasnyéputiwutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jisas wani kundi wandéka de apakundiké vékusékngwa du ras wamba téte deku mawulémba anga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wani du kamuké dé wunga wak? Got kapmang wa du yan kapérandi musé yasnyéputi-kandékwa. Wani du anga wandén, ‘Wuné yandén kapérandi musé wa yasnyéputiwutén.’ Dé baka du wunga wate wa Gorét wasélékndékwa wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naandaka Jisas deku mawulé vékusékte det anga wandén, “Kamuké guné guna mawulémba wunga vékulako? Guné wunga yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Wuné Duna Nyaan ani képmaamba téte yandarén kapérandi musé yasnyéputiké wa apamama yawutékwa. Guné wani muséké yamba vékusékngunéngwe wa. Yandén kapérandi musé yasnyéputiké yawutékwanngé wate baka kundi wuté wak, kapuk néma kundi wuté wak? Dé waarape déku jaambé kéraae kure yéndénngé wamunaae wa néma kundi waké wuté kapuk? Guné wuna mayé apaké yékunmba vékusékngunénngé wani kundi bulaa dat a wakawutékwa.” Naandén. Naatake maan taamba kapére yan duwat anga wan, “Ménat a wawutékwa. Méné waarape ména jaambé kéraae kure ména gaat ma yéménék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naandéka waarape kwaandén jaambé bari kéraae kure akwi du dakwana ménimba bari gwaandéndén. Gwaandéndéka véte akwi du dakwa vatvat naandarén. Vatvat naate Gotna yé kavérékndaka deku mawulé bérundéka anga wandarén, “Yéki. Wunga pulak musé talimba nak yamba vénangwe wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas nakapuk gwaande néma gu kwaawu aarkémba téndén. Téndéka némaamba du dakwa déké yaae jaawundaka det Gotna kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kwayétake yéte véndén Alfiusna nyaan déku yé Livai takis kéraandékwa gaamba randéka. Vétake anga wandén, “Wunale ma yaa.” Naandéka waarape wa Jisasale yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas yéndéka némaamba du dakwa dale sékét yéndarén. Yéndaka takis kéraakwa némaamba dunyansé, nak kapérandi musé yakwa némaamba dunyansé ras waak dale sékét yéndarén. Ye Jisas déku dunyan waak Livaiale kakému karéndaka de yaae de waak dele sékét kakému karéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Karéndaka véte apakundiké vékusékngwa Farisi dunyan ras Jisasna dunyansat anga wandarén, “Kamuké dé takis kéraakwa du, kapérandi musé yakwa du ras waak dele dé kakému ko?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naandaka dé det gwaaménja kundi anga wandén, “Yékunmba yatékwa du dakwa doktaké yamba yéndakwe wa. Sépémaalé kapére yan du dakwa wa doktaké yékwa. Yéndaka dokta deku sépé kururéndakwa.” Naandén. Naatake anga wandén, “Wuné du dakwana kapérandi mawulé wa kururéwutékwa. Kapérandi mawulé vékukwa du dakwa wunéké yaae wuna kundi vékundarénngé wa gaayawutén. Yéku mawulé vékukwa du dakwaké yamba vékulakawutékwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nakapuk baptais kwayékwa du Jonna dunyansé, Farisi dunyan waak Gorale kundi bulmuké yate wa kakémuké yaakétndarén. Yaakétndarénngé vékulakate du dakwa ras Jisaské ye anga wandarén, “Jonna dunyansé Farisi dunyansé waak némaamba apu wa kakému yaakétndakwa. Yaakére baka yaréte Gorale kundi bulndakwa. Ména dunyan wunga yamba yandakwe wa. Akwi nyaa wa kakému kandakwa. Kamuké daré ména dunyansé kakému yamba yaakétndakwe?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naandaka Jisas det gwaaménja kundi anga wandén: “Du nak taakwa kéraaké yandu de kakému yaake mawulé tawulé yate kakému kaké daré kapuk? Wa kakandakwa. Taakwa kéraaké yakwa du dele sékét yaréndu wa mawulé tawulé yate kakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kukmba nak du yaae wani duwat kure yéndaru wani sapak wa de déku du dakwa déké sémbéraa yate kakému katik kaké daré. Wuné wuna dunyansale wayéka a yatéwutéka wa mawulé tawulé yate kakému kandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wani kundi watake det gwaaménja kundi vétik waak anga wandén: “Du dakwa kulé laplap nak tambék kéraae jaangwa laplapmba tékwa yaambumba yamba taake yatépéndakwe wa. De kulé laplap nak tambék kéraae jaangwa laplapmba tékwa yaambumba taake yatépé-munaandaru, wa kukmba gu yakwasnyéndaru kulé laplap makal pulak yandu jaangwa laplap gérikndu néma yaambu tékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dékény kwaaré viyaae révéndarén meme sépémba kulé wain kulak yamba wukaasanda-ndakwe wa. Wunga yamunaandaru, wa wani meme sépé jaangwa ye pungndu kulak akwi yékéraa-kandékwa. Yékéraandu wani meme sépé katik yékun yaké dé. Kulé meme sépémba wukaasanda-ndaru kulé kulak yékunmba tékandékwa.” Wunga gwaaménja kundi wandén, talimba yatan du wan kundi déku kulé kundiale véréti yékunmba kwaakapuk yaké yandékwanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yaap yaré nyaa nak Jisas déku dunyansale sékét wit tékwa yaawi nakmba yéndarén. Yéte déku dunyan wit sék kaké wa wit kumbu ras taakundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Taakundaka Farisi dunyan ras vétake Jisasét anga wandarén, “Ma véna. De wit kumbu taakundakwa yaap yaré nyaamba. Nana apakundi anga wandékwa, ‘Guné yaap yaré nyaamba jémbaa yaké yambakate.’ Wani apakundi yamba vékundakwe wa. Wit kumbu taakute jémbaa wa yandakwa, yaap yaré nyaamba. Wan kapérandi yapaté wa yandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Naandaka det anga wandén, “Talimba nana gwaal waaranga maandéka bakamu Devit yan muséké wa Gotna nyéngaamba viyaatakandarén. Wani kundiké yamba vékulaka-ngunéngwe wa. Talimba Devit déku dunyansale kaandé yandéka dé Gotna kundi bulndakwa gaamba wulaae wani gaamba jémbaa yakwa duwat waatakundén, Gorké kwayéte taakandarén kakému det kwayéndénngé. Wani sapak Abiatar wa dé Gotna gaamba jémbaa yakwa dunyanna néma du téndén. Waatakundéka kwayéndéka Devit wani kakému déku dunyansat kwayéndéka de akwi kandarén. Wunga yate nana apakundi yamba vékundakwe wa. Nana apakundi anga wandékwa, ‘Gotna gaamba jémbaa yakwa du male Gorké kwayéndarén kakému yénga kandaru. Nak du wani kakému katik kaké daré.’ Wunga wandéka Devit déku dunyansale wunga yandaka deké anga yamba wangunéngwe wa, ‘Wan kapérandi musé wa yandarén.’ Wunga wakapuk yate kamuké guné wuna dunyansat waaru, nana apakundi vékukapuk yandarénngé? Guné wunga wate yamba kurkasale vékusék-ngunéngwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naatake det anga wandén, “Du dakwat yéku yapaté yamuké wa Got yaap yaré nyaa yandén. Du dakwa de yaap yaré nyaat yékun yandarénngé yamba wandékwe wa Got. ");
INSERT INTO abt_wosera_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wunga yandénngé vékulakate gunat a wawutékwa. Wuné Duna Nyaan, wuné yaap yaré nyaaké néma du a rawutékwa. Wuné du dakwana jémbaaké yi naawutu wa de yaap yaré nyaamba yi naawutén pulak yénga yandaru.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nakapuk yaap yaré nyaa Jisas Gotna kundi bulndakwa gaat wulaandéka taamba lin du nak wamba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Randéka Jisasna kundiké kalik yakwa du ras wani gaamba téte Jisasét véténdarén. Vététe deku mawulémba anga waténdarén, “Jisas yaap yaré nyaamba wani duwat kalmu kururéké dé kapuk? Dat kururémunaae, wa nana apakundiké kuk kwayéndu dé kotimnganangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Waténdaka taamba lin duwat anga wandén, “Ma waarape yaae amba té.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Naandéka waarape wamba téndéka det anga wandén, “Nana apakundi yénga dé wo? Yaap yaré nyaamba nané yéku musé yaké nané, kapuk kapérandi musé yaké nané? Yaap yaré nyaamba kiyaaké yakwa du dakwat yékun yaké nané, kapuk det viyaandékngé nané?” Naandén. Naandéka kundi yamba bulndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yate déku kundi vékumuké kalik yandaka wa dé rakarka yate deké sémbéraa yandén. Sémbéraa yate wani duwat anga wandén, “Ména taamba ma kayéndéng.” Wunga wandéka déku taamba kayéndéngndéka wa nakapuk yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yandéka Farisi dunyan gwaande ye Jisasét viyaandékmuké Herotna dunyansale sékét kundi bulndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas déku dunyansale sékét Galili néma gu kwaawuna aarkat yéndarén. Yéndaka némaamba du dakwa yandén muséké kundi vékutake déké yéndarén. Galili distrik, Jerusalem, Judiamba tékwa gaayé ras waak, Idumea distrik, Jordan kaambélé nak saku, Tairmba tékwa taalé, Saidonmba tékwa taalé, wani gaayémba yaae wa déké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ye saambakndaka dé baat yakwa némaamba du dakwa nyambalésat, sépémaalé kapére yan némaamba du dakwa nyambalésat waak wa kururéndén. Kururéndéka de wunga pulak apu du dakwa nakapuk yékun yaké we déku sépémba kurké mawulé yate jaawundaka wa taalé vékulékén. Vékulékndéka déku dunyansat anga wandén, “Bot nak ma kéraae kure yaangunu rawutu. Némaamba du dakwa wa jaawuwe téndakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kutakwa kulure kure yatan du dakwa Jisasét véte déku ménimba vaakére kwaate anga waandarén, “Méné Gotna nyaan wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wunga waandaka Jisas det némaanmba wandén, de déké kundi saapékapuk yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas némbat waaréndén. Waare mawulé yandékwa dunyansat waandéka déké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yaandaka dé du tambavétik maanmba kaayék vétikét (12) wa wakandéngndén, de déku jémbaa yandarénngé. De dale yeyé yaayatéte déku kundi vékwe ye du dakwat Gotna kundi kwayéte mayé apa kéraae wandaru kutakwa yaange yékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Déku dunyanséna yé anga wa: Saimon. Dat nak yé kwayéndén, Pita. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedina nyaan vétik Jems ambét déku waayéka Jon. Bérét nak yé kwayéndén, Boanerges. Nana kundimba wani kundi anga wandékwa, jatndu pulak nyaarangte waakwa du. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru. Filip. Bartolomyu. Matyu. Tomas. Alfiusna nyaan Jems. Tadius. Nak Saimon. Dé talimba akwi gaayémba yéte anga wandén, “Nak képmaana du nanéké néma du témuké kalik yawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot. Kukmba wa Jisas maamat kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kukmba Jisas waambule yéndén gaat. Ye saambakndéka némaamba du dakwa jaawuwe téndaka déku dunyansale kakému kaké yapatindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yandaka du dakwa ras Jisaské anga wandarén, “Wa waangété wa yandén.” Naandaka Jisasna kém vékutake dé kure yémuké déké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Apakundiké vékusékngwa dunyan ras Jerusalemmba talimba yaandarén. Yaae saambake Jisasét véte déké anga wandarén, “Déku mawulémba akwi kutakwana néma du déku yé Belsebul wa wulaae tékwa. Téte mayé apa kwayéndéka wa wandéka de kutakwasé yaange yéndakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naandaka det waandén, yaandarénngé. Waatake det gwaaménja kundi anga wandén, “Ani kundi ma vékungunék. Guné wunat wangunén pulak yate kutakwana néma du Satan déku dunyan yaange yéndarénngé wamunaandu, wa katik tésékéyakngé daré. Satan wunga jémbaa yamba yandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Néma gaayémba tékwa du mawulé vétik yate kém vétikmba téte waariyamunaate, wa katik tésékéyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nakurak gaamba yarékwa du dakwa mawulé vétik yate deku kapmang waariyamunaae, wa de waak katik tésékéyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan déku dunyansale wunga pulak wa. De mawulé vétik yate deku dunyansale waariyamunaate, wa katik tésékéyakngé daré. Deku jémbaa késkandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Du nak apamama yakwa duna gaamba wulaae déku musé baka kéraaké we taale wani du kure baangwit gikandékwa. Gitake déku gaamba wulaae wa déku musé baka kéraakandékwa.” Naatake anga wandén, “Satan wan wani apamama yakwa du pulak wa. Wuné wani duwat baangwit gikwa du pulak a. Wuna mayé apa wa Satanna mayé apat taalékéran.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Naatake anga wandén, “Ani kundi ma vékungunék. Du dakwa kapérandi musé ye wani kapérandi muséké kalik ye yaasékandaru, wa Got yandarén kapérandi musé yakwasnyéputi-kandékwa. Du dakwa Gorét wasélékte kapérandi kundi watake wani kapérandi kundiké kalik ye yaasékandaru, wa Got wani kapérandi musé yakwasnyéputi-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","De Gotna Yaamambiké wasélékte kapérandi kundi wandaru, wa Got wani kapérandi musé katik yakwasnyéputiké dé. Wani kapérandi musé tépékaa-kandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Takamba de ras Gotna Yaamambiké vékulaka-kapuk yate wa anga wandarén, “Kutakwana néma du Jisasna mawulémba wa wulaae randékwa.” Wunga wate Gotna Yaamambit wa wasélékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wani sapak Jisasna aasa déku waayékanje waak yaandarén. Yaae kaapamba téte kundit wasatindarén déké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wasatindaka némaamba du dakwa Jisasale téte dat anga wandarén, “Ména aasa, ména waayékanje yaae kaapamba téte méné véké wandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wandaka anga wandén, “Wuna aasa waayékanje yénga pulak daré?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wunga watake akwi du dakwat véte anga wandén, “An wuna aasa, wuna waayékanje a. ");
INSERT INTO abt_wosera_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gotna kundi vékute wandékwa pulak yakwa du dakwa wan wuna aasa, wuna nyangengu, wuna waayékanje pulak wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas nakapuk kundi kwayéndén néma gu kwaawuna aarkémba. Kwayéréndéka némaamba du dakwa ye dé ranmba jaawundarén. Jaawundaka, de déku kundi yékunmba vékundarénngé mawulé yate wa botmba waare randén. Randéka de néma gu kwaawuna aarkémba téndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Téndaka det némaamba gwaaménja kundi kwayéte det Gorké yakwasnyéndén. Yakwasnyéte det anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ma vékungunu. Du nak déku yaawimba wit sék yaasnyémuké wa yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ye yaasnyéndéka wit sék ras yaambumba vaakérén. Vaakére baka randaka api wa yaae kéraae akwi kawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wit sék ras matuale tan ayélap képmaamba vaakérén. Vaakére bari buréle waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waare méngi kurkasale kurkapuk ye nyaa véndéka képmaa rékandang yandéka wa bari rékaa ye kiyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit sék ras raamény waaramba vaakérén. Vaakére randaka raamény waara wa wuttépe waare taakatépan. Taakatépéndéka wit sék yamba vaakundakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wit sék ras yéku képmaamba vaakérén. Vaakére wamba re yékunmba wure waaréndarén. Waare yéku sék vaakundarén. Ras de 30 sék vaakwan. Ras de 60 sék vaakwan. Ras de 100 sék vaakwan.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naatake det anga wandén, “Guné vékusékngé mawulé ye kurkale waan taake ma kurkale vékungunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wani du dakwa yékéraandaka dale yeyé yaayatékwa dunyansé, dale tékwa dunyan ras waak, wa Jisasét wani gwaaménja kundiké waatakundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Waatakundaka det anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Véréndu wa de déku kémba tékandakwa. Wani muséké talimba Got kundi paakundén. Paakutake bulaa wakwasnyéte yi naandékwa, guné wani muséké vékusék-ngunénngé. Nak du dakwat wani muséké gwaaménja kundi kwayéwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kwayéwutéka Gotna nyéngaamba kwaakwa ani kundi wandékwa pulak wa yandakwa: De véte yékunmba katik vésékngé daré. De kundi vékute wani kundiké katik vékusékngé daré. Vékusékmunaae, wa Gotna kundi vékundaru Got de yan kapérandi musé yakwasnyéputikatik dé.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas wunga watake det anga wandén, “Wani gwaaménja kundina waambuké guné vékusékék kapuk? Vékusékngapuk yate yénga pulak akwi gwaaménja kundina waambuké vékusékngé guné? ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Bulaa wani gwaaménja kundiké wakawutékwa. Wit sék yaasnyan du wit sék yaasnyéte Gotna kundi kwayéndakwa pulak wa yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Du dakwa ras Gotna kundi yékunmba vékundakwa. Vékundaka Satan bari yaae wani kundi kéraae kure yéndékwa. Yéndéka wa de wani kundiké yékéyaak yandakwa. Wani du dakwa wan yaambumba vaakérén wit sék pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Du dakwa ras matuale ran képmaamba vaakérén wit sék pulak wa. Taale Gotna kundi bari vékundakwa. Vékute taale wani kundiké mawulé yate mawulé tawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yate yamba yékunmba vékulakandakwe wa. Wani kundi deku mawulémba daawulikapuk yandéka de yamba yékunmba vékulakandakwe wa. Yandaka nak du Gotna kundiké kalik yate det yaavan kutndaka vakmi ras deké yaandéka wa Gotna kundi bari yaasékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Du dakwa ras wan raamény waara ténmba vaakérén wit sék pulak wa. De Gotna kundi taale yékunmba vékundakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Vékute ani képmaana muséké male vékulakandaka deku mawulé yéwaa, musé asé kéraaké géndékwa. Géndéka musé raské waak wa mawulé yandakwa. Wani musé wa Gotna kundit taakatépékwa. Taakatépéndéka wani du dakwa Gotna jémbaa yaasékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Du dakwa ras wan yéku képmaamba vaakérén wit sék pulak wa. De Gotna kundi yékunmba vékute, wandékwa pulak yate, déku kundi yékunmba vékusékndakwa. Vékusékte yéku jémbaa yandakwa Gorké. Ras déké yéku jémbaa ayélapkéri (30 pulak) yandaka, de ras déké yéku jémbaa némaamba (60 pulak) yandaka, de ras déké yéku jémbaa némaamba-sékéyak (100 pulak) yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wani kundi watake Jisas anga wandén, “Ma vékulakangunu. Du dakwa téwaayé yaa takngére kure yaae sapngutakandarén aké arulamba daré kusolatako, kapuk jaambé atndamba daré taako? Yamba wa. De jaambé taakumba wa taakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Paakwe rakwa musé sérémaa vékangunéngwa. Yakélak wandarén kundi sérémaa vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Guné vékusékngé mawulé ye kurkale waan taake ma kurkale vékungunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naatake det anga wandén, “Wani kundiké ma yékunmba vékulakangunu. Guné yékunmba vékulakate, wa wuna kundi kurkasale vékukangunéngwa. Guné kundi ayélap vékute, wa ayélap vékusék-ngangunéngwa. Yékunmba vékute, wa yékunmba vékusék-ngangunéngwa. Vékusékngunu Got gunat yéku mawulé ras waak kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wuna kundi yékunmba vékukwa du dakwa kukmba Gotna kundiké yékunmba vékusék-ngandakwa. Wuna kundi yékunmba vékukapuk yakwa du dakwa anga wandakwa, ‘Nané Gotna kundi vékusékwuran wa.’ Naandakwa. Wunga watake sérémaa déku kundiké yékéyaak yatake baka tékandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Wani kundi watake anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Véte dékét déku kapmang jémbaa yandu nak du dakwa yékéyaakmba téndaru Gotna kém némaan yakandakwa, ani wit sék pulak. Du nak wit sék képmaamba yaasnyétake gaan kwaae nyaa waarape wunga yatépékandéka wa wit sék buréle waarékwa. Waaréndéka dé yamba vékusékndékwe wa. Yénga pulak dé wit sék buréle waaro? ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Képmaa dékét déku kapmang yandéka wa wani wit sék buréle waare gaanga ye vaakwe wa aak yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yandéka wit sék taakundakwa sékét yaandéka wani du véte kulaat taakundékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wani kundi watake Jisas anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Wani du dakwaké yénga pulak waké wuté? Kamu gwaaménja kundimba wawutu wani du dakwaké vékusékngé guné? ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anga wakawutékwa. Wani du dakwa taale makalkéri kém tékandakwa. Kukmba néma kém tékandakwa. Wani kém wan miyé nakna sék pulak wa. Wani miyé sékna yé mastet wa. Wani miyé sék wan makalkéri sék wa. Nana képmaamba tékwa akwi nak sék wan de némaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Du wani miyé sék taawundéka wa wure waare néma miyé ye gaalé baae néma miyé téndékwa. Téndéka déku gaalémba némaamba api wa yaae kwaat séte randakwa aanganmba.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas wunga kundi kwayéte gwaaménja kundi késépéri wa wandén du dakwat. De vékute vékusékngé apamama yandaka wa det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gwaaménja kundimba male wandén det. Watake kukmba déku dunyansé male téndaka det wani kundina waambu kaapa yandén, de yékunmba vékusékndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nyaa daawuliye gaan yandéka wani nyaamba wa Jisas déku dunyansat anga wandén, “Ma yékwak néma gu kwaawu nak sakwat.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wunga wandéka déku dunyansé wamba tan némaamba du dakwasé yaasékatake Jisas ran botmba waaréndarén. Waare dé kure yéndarén. Yéndaka du ras nak botmba waak yéndarén, dele. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yéndaka néma wimut kutndéka gu waarape waare botmba gwaande wa vékulékngé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yaténdéka Jisas awula botna kuk sakumba yundé kwaandén. Aambutékmba maaka taake kwaandén. Kwaandéka dat sérkiyaandarén. Sérkiyaate anga wandarén, “Néma du, a lambiyaknangwa. Nanéké yamba vékulaka-ménéngwe kapuk?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wunga wandaka vélérkiyaae waarape wandéka wimut késndéka gu nakapuk daae yékunmba tén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Téndéka déku dunyansat anga wandén, “Guné kamuké guné wup yo? Gunat yékun yaké yawutékwa mayé apaké yamba yékunmba vékulaka-ngunéngwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wunga wandéka asa wup wa yandarén. Yate dekét deku kapmang bulte anga wandarén, “Yéki. Dé wandéka wa wimut béré gu déku kundi vékute wandékwa pulak yandékwa. Dé wan yénga pulak du dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas déku dunyansale botmba ye Galili néma gu kwaawuna nak sakumba saambakndarén. Wan de Gerasaséna képmaa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Saambake Jisas bot taakandéka wa kutakwa kulure kure yatan du nak waangété ye dat véndén. Wani du dé du dakwa kiyaandaka rémndarén taalémba wa yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Yaréndéka du ras némaamba apu déku maan taamba sen baangwit gindarén. Gindaka wani sen bérélte yaange yéndén. Apa tapa sen baangwit waak gindaka wa dé wani sen bérélte yaange yéndén. Yéndéka dat kurké apamama ye yapatindarén wa. Dat baangwit nakapuk giké yapatindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gaan nyaa du dakwa kiyaandaka rémndarén taalé, némbumba waak téte waawak baanite dékét déku kapmang wa déku sépémba matut sékundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisas saambakndéka wani du Jisasét apakmba véndén. Vétake déké pétépété ye kwaati se waandé daandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yandéka Jisas vétake anga wandén, “Déku mawulémba tékwa kutakwasé ma yaange yékéraangunu.” Naandén. Wunga wandéka wani du némaanmba waate anga wandén, “Jisas, méné anjorémba rakwa du Gotna nyaan wa. Méné wunat yénga pulak yaké méné yo? Gotna yémba ménat waatakuwutékwa. Méné wunat kaangél tiyaaké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naandéka dat anga wandén, “Ména yé yénga dé?” Wunga wandéka dat anga wandén, “Késépéri kutakwa wa wunat kulure kure yaténdaka wa wuna yé Késépéri wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wunga watake anga wandén, “De nak képmaat yémuké kalik yawutékwa. Ménat waatakuwutékwa. De anika yéndarénngé waké yambak.” Naandén kutakwa kulure kure yatan du. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wani némbumba baalé asa wa de ténale téte kakému katékésndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Katéndaka wani duwat kulure kure yatan kutakwasé Jisasét anga wandarén, “Méné nanat yakéléké mawulé yamunaae, ma waménu nané wani baaléna mawulémba wulaakanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wunga wandaka det anga wandén, “Guné wunga ma yaange yéngunu.” Naandén. Wunga wandéka de wani du yaasékatake ye wani baaléna mawulémba wulaae téndarén. Téndaka wani baalé néma jaangumba yaange daawuliye gumba vaakére gu ke de akwi (2,000 pulak) wa kiyaawuréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wani baaléké séngiye kaavéran dunyansé wunga yandaka vétake wa yaange yéndarén. Ye de akwi gaayémba tan du dakwat wani muséké saapéndarén. Saapéndaka wa de du dakwa wani musé vémuké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ye Jisas ténmba saambake de késépéri kutakwasé yaasékatake yén du véndarén, dé laplap giye yéku mawulé vékute Jisasna maanale randéka. Véte wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yandaka Jisas wani musé yandéka vén du dakwa wa det saapéndarén, kutakwa kulure kure yatan du yékun yandéka baalé kiyaanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Saapéndaka wa Jisasét wandarén, dé deku képmaa yaasékatake yéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wandaka Jisas de yaasékatake yéké yate botmba waaréndéka dé kutakwa kure yaténdaka yékun yan du wa dat anga wandén, “Wuné ménale yéké mawulé yawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wunga wandéka dat anga wandén, “Méné ména gaayé ména dunyanséké waambule ye det ma waménék, Néman Du ménéké sémbéraa ye ménat yéku musé yandénngé.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wunga wandéka dé yaasékatake ye kundi kwayéndén, Dekapolis distrikmba tékwa némaamba gaayémba. Jisas dat yandén muséké wa kundi kwayéndén. Kwayéndéka akwi du dakwa vékute vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas déku dunyansale botmba ye Galili néma gu kwaawu nak sakumba saambakndaka némaamba du dakwa wa jaawuwe dale sékét téndarén. Dé néma gu kwaawu aarkémba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Téndéka du nak déku yé Jairus déké yéndén. Dé néma du nak wa téndén, wani gaayémba kwaakwa Gotna kundi bulndakwa gaaké. Dé ye kwaati se Jisaské waandé daate dat anga wandén, “Wuna takwanyan ani kiyaaké yarékwa. Méné ma yaae ména taamba lémba kutménu lé nakapuk yékun yakalékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wunga wandéka dale sékét yéndén. Jisas yaambumba yéténdéka asa du dakwa wa déku kukmba yéndarén. Yéndaka yaambu vékulékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yandéka lé taakwa nak dele yétélén. Késépéri (12) kwaaré wa waaléramu yarélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Némaamba apu wa talimba doktaké yélén, lé kururéndarénngé. Yandaru lé yékun yamuké wate léku akwi yéwaa doktasat kwayéléka késén. Yaléka wani musé yamba wurétékndéka yékun yalékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yate lé Jisaské kundi vékutake léku mawulémba anga walén, “Déku laplapmba taamba kure wuné nakapuk yékun yakawutékwa.” Wunga watake lé némaamba du dakwale sékét ye déku kukmba ye déku laplapmba kutlén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kutléka dé waaléramu bari wurétékndéka vékuséklén, yékun yalénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yaléka Jisas vékusékndén, déku mayé apa ras yénngé. Vékusékte waalakwe déku kukmba yaatan du dakwat anga waatakundén, “Wuna laplapmba kaandé kurék?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wunga waatakundéka déku dunyan anga wandarén, “Asa du dakwa wa ménale yaaténdaka taalé vékulékndéka wa véménéngwa. De ras daré ménat kurék kapuk yénga véké? Kamuké méné nanat waatakwo, ménat kurén duké?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wunga wandaka dé deku kundi vékukapuk yate dat kurén duké waakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Waakndéka wani taakwa lat yan muséké vékusékte néma wup yate wa déké yaae kwaati se waandé daate wani muséké kaapamba walén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Waléka anga wandén, “Nyéno, nyénat kururéké yawutékwa mayé apaké yékunmba vékulakate wa bulaa yékun yanyénén. Nyéna mawulé yénga yékun téndu yékunmba ma yényénu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas wayéka téte waténdéka du nak Jairusna gaamba yaandén. Yaae saambake wani néma duwat anga wandén, “Ména takwanyan wa kiyaan. Ma waménu wani néma du katik yaaké dé. Déku nak jémbaa yénga yandu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Naandéka Jisas wani kundi vékute Gotna kundi bulndakwa gaana néma duwat anga wandén, “Wup yaké yambak. Wuné ména takwanyanét yékun yaké yawutékwa mayé apaké ma yékunmba vékulakaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wunga watake Pita, Jems, Jemsna waayéka Jon det anga wandén, “Guné male guna kapmang wunale sékét ma yaangunu. Nak du dakwa katik wulaaké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naandéka dale sékét yéndarén, wani néma duna gaat. Ye véndarén némaamba du dakwa jaawuwe téte wani takwanyanngé mawulé sémbéraa yatéte némaanmba géraaténdaka. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Vétake gaamba wulaae anga wandén, “Kamuké guné wunga géraau? Yamba kiyaalékwe wa. Baka yundé wa kwaalékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wunga wandéka dat waangindarén. Waangindaka dé deku kundi yamba vékundékwe. Yate wandéka de akwi gwaandéndarén kaapat. Gwaandéndaka dé takwanyanna aasa aapa déku du kupuk sékét wunga wulaandarén, takwanyan kwaan taalat. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wulaae léku taambamba kutte déku kundimba lat anga wandén, “Talita kumi.” Wani kundi nana kundimba anga wa: “Nyéno, ma waarap.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas wandéka lé bari waarape yeyé yaayalén. Léku kwaaré tambavétik maanmba kaayék vétik (12) wa. Yeyé yaayaléka véte vatvat naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yandaka anga wandén, “Ma vékungunék. Wani muséké nak du dakwat waké yambak. Kakému ras ma kwayéngunu kalu.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas wani gaayé taakatake déku gwalepanget yéndén. Yéndéka déku dunyan dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ye saambake yaap yaré nyaa Gotna kundi bulndakwa gaat wulaandén. Wulaae Gotna kundiké du dakwat yakwasnyéndén. Yakwasnyéndéka némaamba du dakwa vékute vatvat naate anga wandarén, “Yéki. Wani du yamba dé wani kundi kéraak? Yénga pulak dé wani muséké vékuséku? Yénga pulak ye dé talimba vékapuk yananén késépéri kulé apanjémba yo? ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dé gaa kurkwa du wa. Maria wan déku aasa wa. Jems, Josep, Judas, Saimon wan déku waayékanje wa. Déku nyangengu akwi amba yaréndakwa, nanale. Deké wa vékuséknangwa. Dé néma du yamba yé wa. Wan baka du wa. Yénga pulak dé wani kundi wo?” Wunga wate wa de déké kalik yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kalik yandaka Jisas anga wandén, “Gotna yémba kundi kwayékwa du gwalepangemba téte kundi kwayéndaka deku kém, deku gaamba rakwa du dakwa, deku gwalepangemba tékwa du dakwa deku kundi vékumuké kalik yandakwa. Nak gaayémba téndaka wani gaayé du dakwa deku kundi wa vékundakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wunga watake dé talimba vékapuk yandarén kulé apanjémba yamba yandékwe wa wani gaayémba. Ani jémbaa male yandén. Baat yakwa ayélapkéri du dakwat déku taamba kutndéka wa yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wani gaayémba tékwa du dakwa déku kundi vékukapuk yandaka Jisas vékulaka vékulaka naandén. Kukmba Jisas genge gaayémba yéte Gotna kundi du dakwat kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Déku dunyan tambavétik maanmba kaayék vétikét (12) waandéka yaandaka det mayé apa kwayéndén, de wandaru du dakwana mawulémba tékwa kutakwa yaange yéndarénngé. Kwayétake det anga wandén, “Ma du vétik du vétik wunga yéngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kakému, wut, yéwaa kure yéké yambak. Sétowe yéngunéngwa baangé male ma kure yéngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su ma saawuwe laplap nakurak male saawungunu. Vétik yamba wa. Guné du dakwat yékun yangunu wa de gunat yékun yate wani musé gunat kwayékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Guné ye gaayémba nak saambake gaat nak wulaae wani gaamba male ma yaréngunék. Wani gaamba yare kukmba nak gaayét ma yéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Guné gaayét nak wulaangunu wani gaayémba tékwa du dakwa guna kundi vékukapuk yate gunat kuk kwayéndaru, wani gaayé yaasékaké yate guna maanmba kwaakwa baawu ma viyaaputétake yéngunék. Wunga yangunu de véte anga wakandakwa, ‘Nané det kapérandi yapaté wa yananén. Kukmba Got yananén kapérandi yapaté waambule nanat yakata-kandékwa.’ Naakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wunga wandéka yéndarén déku dunyansé. Ye du dakwat anga wandarén, “Yangunén kapérandi musé ma yaasékangunu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wunga watake du dakwana mawulémba tékwa kutakwat wandaka wa yaange yéndarén. Baat yakwa du dakwana sépémba wani sépémba kutndakwa wel kutndarén. Kuttakandaka wa yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisasna dunyan wunga yandaka akwi gaayémba Jisaské kundi bulndaka néma du Herot wani kundi vékundén. Du dakwa ras wa anga wan, “Wa baptais kwayétan du Jon kiyaae wa taamale waarapndén. Taamale waarape néma mayé apa kéraae wa wani apanjémba yandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wunga wandaka de ras wa anga wan, “Wan talimba yatan du Elaija wa.” Ras wa anga wan, “Gotna yémba kundi kwayétan du nak wa, talimba yatan wani du pulak.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wunga wandaka Herot wani muséké vékute anga wandén, “Talimba wawutéka wa Jonna kumbu sékundarén. Sékundaka kiyaae bulaa nakapuk taamale wa waarapndén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Talimba Herot déku aanyé Filipna taakwa kéraandén. Wani taakwana yé Herodias wa. Kéraandéka Jon anga wandén, “Ména aanyé yaréndéka déku taakwa kéraaménén wan kapére yaménén. Got wani muséké waarundékwa.” Wunga wandéka Herot Jonna kundiké kalik yate wandéka déku dunyan ye Jonét kulkiye senét giye dé kure yéndarén kalapusét. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Taakandaka kalapusmba kwaandéka Herodias rakarka yate Jonét viyaandékngé mawulé yalén. Yaléka Herot wani muséké kalik yandéka Jon viyaandékngé yapatilén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot anga vékusékndén. Jon wan Gotna kundi vékute yéku musé yakwa du wa. Wunga vékusékte wup yate wa Herodias Jonét viyaandékngapuk yamuké wa Jonngé yékun yate kureréndén. Kureréte nakurak apu nakurak apu Jonale kundi bulte wa déku kundiké mawulé yate vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kukmba Herodias Jonét viyaandékngé yalékwa nyaa yaan. Herot déku aasa dé kéraalén nyaaké vékulakate wa néma paat yandén. Yate kakému kandarénngé wandéka déku jémbaa yakwa néma dunyansé, waariyakwa dunyanna néma dusé, Galilimba tékwa néma dunyansé, wunga wa yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yaae randaka Herodiasna takwanyan wulaae kétilén. Kétiléka Herorale kakému karan dunyansé véte de akwi néma mawulé yandarén. Yate néma du Herot wani taakwat anga wandén, “Kamuké nyéné mawulé yo? Ma wanyénu kwayékawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naatake anga wandén, “Musé ras kwayéwuténngé mawulé yanyénu kwayékawutékwa. Wuna képmaa, wuna gaa, wuna musé nyéndémba muniye kwayéwuténngé mawulé yanyénu wunga yakawutékwa. Yi wan wanana wa. Nyénat wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wunga wandéka wani takwanyan gwaande léku aasat anga walén, “Kamu musé tiyaandénngé waké wuté?” Wunga waatakuléka léku aasa wa anga wan, “Baptais kwayékwa du Jon, déku maaka. Wunga kéraanyénu kiyaandénngé vékusék-ngawutékwa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wunga waléka lé bari waambule néma du ran taalat wulaalén. Wulaae anga walén, “Baptais kwayékwa du Jonna kumbu sékwe dismba ma taake wunat tiyaaménék.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wunga waléka Herot wunga yamuké kalik yate vékulaka vékulaka naandén. Takamba kundi we gite wakakét yandén wa. Yi wan wanana wa, naandén. Naandéka dale rate kakému karan dunyan wa vékundarén. Wandén kundiké vékulakate nak pulak kundi wamuké kalik yate wani taakwat yi naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yi naatake wandéka déku du nak ye kalapusmba wulaae Jonna kumbu sékundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sékwe maaka dismba taake kure ye wani taakwat kwayéndén. Kwayéndéka wa léku aasat kwayélén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wunga yandaka Jonna dunyan vékutake yaae déku pusaa kéraae kure ye rémndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisasna dunyan nakapuk waambule yéndarén déké. Ye dale téte yandarén akwi jémbaa, wandarén akwi kundiké waak dat wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wandaka némaamba du dakwa wa yeyé yaayandarén. Yeyé yaayandaka Jisas déku dunyansale yamba yaap yaréte kakému kandakwe wa. Wunga yate det anga wandén, “Nanékét nané male du dakwa yarékapuk taalat ye guné wamba yaap yaréké ya.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wunga watake de bot kéraae kure du dakwa yarékapuk taalat deku kapmang yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","De yéndaka némaamba du dakwa véte deké vékusékndarén. Vékusékte akwi gaayémba yaae képmaamba bari pétépété ye wa taale saambakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Saambakndaka Jisas botmba yaae néma gu kwaawu wutépmba téte némaamba du dakwat véndén. Vétake déku mawulémba anga wandén, “Sipsipké séngite kaavérékwa du tékapuk yandu de sipsip katik kurkale téké daré. Wani du dakwa wan wani sipsip pulak wa.” Naandén. Naate deké sémbéraa yandén. Sémbéraa yate det némaamba kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kwayéndéka garambu yandéka déku dunyan yaae dat anga wandarén, “An du yarékapuk taalé a. Nyaa a daawulikwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ma waménu wani du dakwa akwi gaayét ye deku kakému kéraandaru.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wunga wandaka Jisas det anga wandén, “Yamba wa. Gunékét guné det kakému ma kwayéngunék.” Wunga wandéka anga wandarén, “Nané deké bret kéraamunaae, wa némaamba (200) yéwaa kwayékatik nané. Nané ye wani du dakwaké kakému ras kéraae det kwayénanénngé méné mawulé yo, kapuk yénga pulak dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wunga wandaka wandén, “Bret katik dé ro? Ma ye véngunu.” Wunga wandéka waake véndarén. Vétake waambule yaae anga wandarén, “Makal bret taambak, gumba kutndarén gukwami vétik wunga male rakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Naandaka Jisas det anga wandén, “Akwi du dakwat ma wangunu yéku waaramba jaawuwe randaru.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wunga wandéka de ras néma kém ras makal kém wunga jaawuwe rakésndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rakésndaka dé wani makal bret taambak gukwami vétik kéraae nyérét yaasawure véte Gorét anga wandén, “Yéku musé a tiyaaménén. Wan yékun wa.” Wunga watake bret bule déku dunyansat kwayéndén, du dakwat muni waate kwayéndarénngé. Kwayétake wani gukwami vétik waak kwayéndén, muni waate kwayéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kwayéndéka muni waate kwayéndaka akwi du dakwa kurkale kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kandaka bret ras gukwami ras baka randéka Jisasna dunyan kémbi tambavétik maanmba kaayék vétik (12) wunga laakwandaka vékulékén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Némaamba (5,000) du wa wani bret kandarén. Némaamba dakwa némaamba nyambalé waak wamba sékét kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisasna dunyan wunga yandaka det anga wandén, “Guné botmba waare guné ma taale yéngunu, néma gu kwaawu nak sakwat, Betsaidat.” Wunga wandéka yéndaka dé dale tan du dakwat wandén, deku gaayét yékéraa-ndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wandéka yéndaka Gorale kundi bulmuké némbat waaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gaan yandéka déku dunyan botmba ye nyéndé néma gu kwaawumba téndaka Jisas kapmang randén némbumba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rate véndén wimut kutndéka bot waambulte waambulte yaaléka déku dunyan botmba yémuké néma jémbaa yandaka. Vétake yé gérké yaténdéka wa gutakumba deké yéndén. Ye det taalékéraké yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ye gutakumba yéténdéka véte anga wandarén, “Wa gaamba wa yaatékwa.” Wunga watake de akwi dat véte néma wup yate némaanmba waawakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Waawakndaka bari anga wandén, “Guno, wup yaké yambak. An wuné a yaatékwa. Yéku mawulé vékute ma yaréngunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wunga watake botmba waaréndén. Waare dele randéka wimut wa késén. Yandéka vatvat naate anga wandarén, “Yéki. Wan yénga pulak du dé?” Naatake vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nalémba Jisas wani du dakwat wani bret kwayéndénngé de yamba yékunmba vékulakandakwe wa. Wani muséké yékéyaak yate vatvat naate wa wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas déku dunyansale botmba néma gu kwaawu nak sakwat ye Genesaretna taalémba saambakndarén. Saambake bot témbétsoréndarén wutépét. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yatake yéndaka du dakwa Jisasét véte déké bari vékusékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vékusékte akwi gaayét pétépété yéte sépémaalé kapére yan du dakwa nyambalésat kéraae jaambémba taakandarén. Taake det kéraae yaate yéndarén, Jisas yatékwa akwi taalat. ");
INSERT INTO abt_wosera_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas yén akwi gaayét de baat yakwa du dakwa nyambalé, sépémaalé kapére yan du dakwa nyambalésat waak kéraae yaatate kurindarén. Kéraae yaate kurite jaawundakwa taalémba taakandarén. Taakate dat anga wandarén, “Méné ma yi naaménu de ména laplapna waambumba male kurkandakwa.” Wunga wandaka wa de déku laplapmba kure wa yékun yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Apakundiké vékusékngwa du ras Jerusalemmba te, ye Farisi dunyansale jaawundarén Jisas ténmba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jaawuwe véndarén Jisasna dunyan ras Farisi dunyan taamba yakwasnyéndakwa pulak yakapuk yate deku taamba baka yakwasnyéte kakému kandaka. Du deku taamba baka yakwasnyéndaka Farisi dunyan det véte anga wandakwa, “Nana apakundi yamba vékundakwe wa. Wan kapérandi musé yakwa dunyan wa.” Naandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi dunyan némaamba Judana nak du waak deku gwaal waaranga maandéka bakamu wandarén pulak wunga male taamba kurkale yakwasnyéte wa kakému kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","De maketmba yaae taale gu yaakundakwa. Gu yaakwe wa kakému kandakwa. Deku gwaal waaranga maandéka bakamu wandarén pulak wa de aké, dis, jaambé waak kurkale yakwasnyéndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De wunga yandaka Jisasna dunyan gwaal waaranga maandéka bakamu wandarén pulak yakapuk yandaka wa de Farisi dunyan apakundiké vékusékngwa dunyan waak Jisasét anga waatakundarén, “Kamuké daré ména dunyan nana gwaal waaranga maandéka bakamu wandarén kundi vékukapuk yate deku taamba baka yakwasnyéte daré kakému ko?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wunga waatakundaka Jisas anga wandén, “Guné paapu yakwa dunyansé wa. Talimba Gotna yémba kundi kwayétan du Aisaia ani kundi viyaatakate gunéké wa kundi viyaatakandén. Papukundi yamba viyaatakandékwe wa. Dé ani yéku kundi wa viyaatakandén anga: Got anga wandén, ‘Ani du dakwa wunéké yéku kundi wandakwa. Wunga wate wa wunéké deku mawulémba yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","De deku apakundi vékute wandékwa pulak yate wa wani kundiké anga wandakwa, “Wan Gotna kundi wa.” Naandakwa. Wunga wate wuna yé kavérékte wa baka kundi bulndakwa.’ Got wunga wandéka wa Aisaia viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Guné wani du pulak wa téngunéngwa. Guné Gotna kundi vékukapuk yate wa képmaana duna kundi male vékungunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wani kundi watake Jisas anga wandén, “Guné Gotna kundi vékukapuk yate nana gwaal waaranga maandéka bakamu wan kundi male vékute anga wangunéngwa, ‘Nané nyaangét vékupukaakwa du a.’ Wunga wangunénga guna mawulé kapére yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Talimba Moses Gotna kundi anga kwayéndén, ‘Guné guna aasa aapat ma yékun yangunék.’ Wunga watake ani kundi waak wandén, ‘Du nak déku aasa aapaké kapérandi kundi wamunaandu wani du ma viyaangunu kiyaandu.’ Wunga wandéka wani kundi Gotna nyéngaamba wa kwaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Guné wani kundi vékukapuk yate anga wangunéngwa, ‘Du nak déku aasa aapat anga wandu, “Ani musé Gorké wa kwayéwutén. Gorké kwayékapuk ye bénat kwayékatik wuté. Bénat yékun yaké yapatiwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wunga watake déku aasa aapat yékun yakapuk yandékwan wan yékun wa. Wa Gorét wa kwayéndén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Guné wunga wate Gotna kundi vékukapuk yate guna gwaal waaranga maandéka bakamuna kundi male vékute guna kundi wangunénga de du dakwa waak wunga wa sépélak yandakwa. Yandaka guné kapérandi musé ras waak wa yangunéngwa.” Naandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas wani kundi watake du dakwat nakapuk waandéka yéndarén déké. Yéndaka det anga wandén, “Wuna kundi yékunmba ma vékungunék. Vékute ani muséké ma yékunmba vékusékngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Du dakwana biyaamba daakwa muséké vékulakate Got anga katik waké dé, ‘Wan kapérandi musé yakwa du dakwa wa.’ Du dakwana mawulémba yaalakwa muséké vékulakate Got anga wakandékwa, ‘Wan kapérandi musé yakwa du dakwa wa.’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Guné vékusékngé mawulé ye kurkale waan taake ma kurkale vékungunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Watake du dakwa yaasékatake déku dunyansale sékét gaat wulaandarén. Wulaae déku dunyan dat waatakundarén wani kundiké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Waatakundaka det anga wandén, “Guné waak wani kundiké yamba vékusékngunéngwe kapuk? Ma véku. Du dakwa kakwa musé deku biyaat daawuliye tété naae yéndékwa. Kandakwa musé deku mawulé yamba yaavan kutndékwe wa.” Naandén. Jisas wunga wandéka anga vékuséknangwa. Akwi kakému kwaami wan yékun wa, Gotna ménimba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas nakapuk anga wandén, “Du dakwana mawulémba yaalakwa muséké vékulakate wa Got wakandékwa, ‘Wan kapérandi musé yakwa du dakwa wa.’ Ani muséké vékusékte wunga wakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Du dakwana mawulémba kapérandi mawulé wa yaalandékwa. Yaalandéka kapérandi mawulé vékute kapérandi musé yandakwa, sél yandakwa, du dakwat viyaandékndakwa, du nak duna taakwat kéraandakwa, taakwa nak dakwana duké yéndakwa, nak du dakwana muséké jaambindakwa, késpulak nakpulak kapérandi musé yandakwa, papukundi wandakwa, kundi vékukapuk yate sépélak yandakwa, yéku musé nak du dakwaké yaandéka deké yaakapuk yandéka wani du dakwaké kapére mawulé vékundakwa, nak du dakwaké kapérandi kundi wandakwa, dekét deku kapmang deku yé kavérékndakwa, waangété yandakwa, wunga kapérandi musé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wani kapérandi mawulé akwi du dakwana mawulémba wa yaalandékwa. Yaalandéka wa wani kapérandi musé yandakwa. Kapérandi musé yandaka Got deké anga wandékwa, ‘Wan kapérandi musé yakwa du dakwa wa.’ Naandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wani kundi watake Jisas wani gaayé yaasékatake Tairna taalat yéndén. Ye gaayémba saambake gaa nakét wulaandén. Wulaae déku mawulémba anga wandén, “Wuné ani gaamba rawutu du dakwa katik vékusékngé daré.” Naae paakwe yaréké yapatindén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Du dakwa déké vékusékte kundi bulndaka taakwa nak vékutake déké bari yélén. Lé Juda taakwa yamba wa. Nak gaayé taakwa wa. Jisaské yélén. Léku gwalepange Fonisia wa Siria kantrimba téndékwa. Léku takwanyanna mawulémba kutakwa nak wulaae téléka wa lé aasa Jisaské yélén. Ye kwaati se waandé daate dat anga walén, “Kutakwa nak wuna takwanyanna mawulémba wa wulaae tékwa. Ma waménu yaange yélu.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wunga waléka Jisas déku mawulémba anga wandén, “Nané Judasé, nak gaayé du dakwaké, ‘Waasa wa,’ naate nana du dakwaké, ‘Nyambalé wa,’ naanangwa.” Wunga watake ani gwaaménja kundi lat anga wandén, “Nané nyambalé kakwa kakému kéraae makal waasat katik kwayéké nané. Nané taale nyambalésat ma kwayékwak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wunga wandéka anga walén, “Néma du, yi wan wanana wa. Wuné anga wawutékwa. Nyambalé kakému kandaka ras képmaamba vaakétndéka deku waasa kéraae kandakwa. Méné wunat yékun yaménu wan yékun wa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wunga waléka lat anga wandén, “Wunga yékunmba watake bulaa nyéna gaayét ma yényénu. Kutakwa nyéna takwanyanna mawulé yaasékatake lé wa yaange yén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wunga wandéka léku gaayét waambule ye vélén léku takwanyan yékun ye jaambémba kwaaléka. Véte vékuséklén kutakwa lat yaasékatake yaange yélénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kukmba Taiarna taalé taakatake Saidon distrikét yéte Dekapolisna taalémba ye Jisas Galili néma gu kwaawumba saambakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ye saambakndéka de du nakét kure yéndarén déké. Wani du waangété ye kundi yamba vékundékwe wa. Yate kundi yamba kurkale bulndékwe wa. Wani duwat kure ye Jisasét wandarén, dat taamba kutndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wandaka Jisas wani duwat kure du dakwa yaasékatake ayélap yépulak naae bérkét bét male témbérén. Téte Jisas déku séktamba wani duna waanmba vatndékute sépmany sévaae déku séktamba wani duna tékiyaalémba vatndékundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Vatndékute nyérét yaasawure véndén. Yaasawure véte sémbéraa yate némaanmba yaamambi jaate déku kundimba anga wandén, “Efata.” Naandén. Nana kundi anga wa: Ména waan ma véku. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jisas wunga wandéka bari yékun ye wa kurkale vékundén. Vékundéka tékiyaalé yékun yandéka wa kurkale bulndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bulndéka Jisas du dakwat waalakwe véte det anga wandén, “Wani muséké bulké yambak.” Wunga wandéka déku kundi vékukapuk yate apamama ye wani muséké kundi bulndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bulndaka du dakwa wani kundi vékute vatvat naate anga wandarén, “Yéki. Wan yénga pulak du dé? Yékun wa yandékwa. Yandéka de kundi vékukapuk yan du dakwa wa yékunmba vékundakwa. Kundi bulkapuk yan du dakwa wa kundi bulndakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Wani sapak nak nyaa némaamba du dakwa yaae jaawundarén, Jisas ténmba. Jaawuwe te kakémuké yapatindaka Jisas wandéka déku dunyan déké yaandaka det anga wandén, “Wani du dakwa nyaa kupuk wunale yaréte deku akwi kakému kasékéyaktake bulaa kaandale téndaka deké sémbéraa yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ras de apakmba wa yaandarén. Wuné det kakému kwayékapuk yate yéndarénngé wamunaawutu deku gaayét waambule yéte yaambumba kaandéké kiyaakandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wunga wandéka déku dunyan dat anga wandarén, “Ani taalé du yarékapuk taalé a. Yénga pulak nané némaamba du dakwaké kakému kwayéké nané?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wunga wandaka det anga wandén, “Bret katik dé ro?” Wunga waatakundéka anga wandarén, “Bret taambak kaayék vétik (7) wa rakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wunga wandaka Jisas akwi du dakwat anga wandén, “Guno, ma rangunu képmaamba.” Wunga wandéka randaka wani makal bret kéraae Gorét anga wandén, “Yéku kakému wa nanat tiyaaménén. Wan yékun wa.” Wunga watake bret bule déku dunyansat kwayéndén, du dakwat muni waate kwayéndarénngé. Kwayéndéka muni waate det kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gumba kutndarén makal gukwami waak nakurak nakurak wa ran. Jisas wani gukwami kéraae Gorét anga wandén, “Yéku kwaami wa tiyaaménén. Wan yékun wa.” Naandén. Wunga watake déku dunyansat kwayéndén, du dakwat muni waate kwayéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kwayéndéka waate kwayéndaka akwi kurkale kandarén. Némaamba (4,000 pulak) du dakwa wa wamba rate kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kasékéyakndaka Jisas bulan bret ras gukwami ras baka randéka Jisasna dunyan kémbi taambak kaayék vétik (7) wunga laakwandaka vékulékén. Yandaka Jisas wandéka wa de du dakwa yékéraandarén deku gaayét. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yékéraandaka Jisas déku dunyansale botmba waare Dalmanuta distrikét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi dunyan ras yaae Jisasale waaruké yandarén. Ye deku mawulémba anga wandarén, “Got wandéka dé Jisas yaak kapuk?” Wunga vékulakate dat anga wandarén, “Méné kulé apanjémba nak ma yaménék. Yaménu véte anga vékusék-nganangwa. Got wandéka wa yaaménén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wunga wandaka Jisas kalik yate anga wandén, “Kamuké guné ani sapak yarékwa du dakwa guné kulé apanjémbaké waatakwo? Yamba wa. Katik véké guné. Gunat a wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wunga watake de yaasékatake déku dunyansale botmba nakapuk waare néma gu kwaawuna nak sakwat yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisasna dunyan bretké yékéyaak ye nakurak bret male wa kéraae kure yéndarén botmba. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yandaka Jisas det ani gwaaménja kundi wandén, “Ma véku. Guné jéraawu ma yangunék. Farisi dunyanna yis Herotna yismba waak kurké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wunga wandéka dekét deku kapmang bulte anga wandarén, “Nané bret ras yamba kure yaanangwe wa. Wunga yananga yiské wa wandén, bret némaan yandénngé kutndakwa wani musé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naandaka Jisas vékusékte anga wandén, “Kamuké guné anga wo? ‘Nané bret yamba yé wa.’ Guné wunga wate wuna mayé apaké yamba wayéka yékunmba vékusék-pékaaténgunéngwe wa. Guna mawulé yékéyaak dé yo, kapuk yénga pulak dé yo? ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Guna méni wa tékwa. Yénga guné vékapuk yo? Guna waan wa tékwa. Yénga guné kundi vékusékngapuk yo? Yénga guné guna mawulémba yékunmba vékulaka-kapuk yo? ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Talimba 5,000 dunyansat bret taambak bule kwayéwutéka kandarén. Kandaka ras randéka kémbi katik guné laakwak?” Wunga waatakundéka anga wandarén, “Kémbi tambavétik maanmba kaayék vétik (12) wa laakwananén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Naandaka anga wandén, “Talimba nak nyaa 4,000 du dakwat bret taambak kaayék vétik (7) bule kwayéwutéka wa kandarén. Kandaka ras randéka kémbi katik guné laakwak?” Wunga waatakundéka anga wandarén, “Kémbi taambak kaayék vétik (7) wa laakwananén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wunga wandaka det anga wandén, “Yi wan wanana wa. Wunga wate yénga guné wuna mayé apaké vékusékngapuk yo? Wuné yiské wate bretké yamba vékulakawutékwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kukmba Jisas déku dunyansale ye Betsaidamba saambakndarén. Saambakndaka wa méni kiyaan du nakét kure yéndarén Jisaské. Kure ye Jisasét wandarén, déku taamba wani dumba kutndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wandaka wani duna taambamba kutndéka bét gaayé sékét taakatake yépulak naambérén. Ye yaambumba téte sépmany déku taambamba sévaae wani duna ménimba kutndén. Ye taambat kutte anga waatakundén, “Musé nak méné vu kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Waatakundéka wani du ayélap vététe wa anga wandén, “Du ras a vétéwutékwa. Véwutéka wa miyé pulak yeyé yaayandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wunga wandéka nakapuk taambat kutndén déku ménimba. Kutndéka déku méni yékun yandéka wa dé kurkale véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Véndéka Jisas anga wandén, “Wani gaayét nakapuk waambule yéké yambakate. Ména gaat ma yéménék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas wunga watake déku dunyansale sékét yéndarén, Sisaria Filipaimba tékwa gaayét. Yaambumba yéte det anga waatakundén, “Du dakwa wunéké yénga daré wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wunga waatakundéka anga wandarén, “Ménéké ras wa wakwa, ‘Wa baptais kwayétan du Jon wa.’ Naandaka ras wa wakwa, ‘Wa talimba yatéte Gotna yémba kundi kwayétan du Elaija wa.’ Naandaka ras wa wakwa, ‘Gotna yémba kundi kwayétan nak du wa.’ Naandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Déku dunyansé wunga wandaka det anga waatakundén, “Wa guné wunéké yénga guné wo?” Wunga waatakundéka Pita anga wandén, “Méné nanat yékun yaménénngé Got wan du Krais wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wunga wandéka Jisas det anga wandén, “Wani kundi nak du dakwat waké yambakate.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas wunga watake déku dunyansat anga wandén, “Duna Nyaan wunat kapérandi musé yandaru wa de maaka dunyan, Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan de wunga wunat kuk kwayékandakwa. Kwayéndaru wunat viyaandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupuk yambanmba wa nakapuk taamale waarapkawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wunga wate gwaaménja kundi yamba wandékwe wa. Yandéka yékunmba vékundarén. Vékute Pita dat kure yépulak naae bérkét kapmang téte kalik yate anga wandén, “Wunga bulké yambak.” Naandén Pita. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wunga wandéka Jisas waalakwe déku dunyansat vététe Pitat anga wandén, “Méné Satan, ma lakasati. Méné Gotna kundi yamba vékuménéngwe wa. Méné ani képmaana duna kundi wa vékuménéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wunga watake nakapuk waandéka némaamba du dakwa déku dunyansé waak déké yéndarén. Yéndaka det anga wandén, “Guné wunale yaate wuna jémbaa yaké mawulé yamunaae, wa anga ma yangunék. Guné guna mawulé ma yaasékangunék. Yaasékatake wunéké vékulakate anga ma wangunék, ‘Nané déku jémbaa yatépéka-kanangwa. Yate nané kaangél kutte takwemimba kiyaananu, wan baka musé wa. Néma musé yamba wa.’ Wunga wate wuna jémbaa ma yaténgunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wunéké vékulakakwa du dakwa wuna jémbaa yatépékandaru wuna maama det viyaandaru kiyaae de wunale yékunmba rapéka-kandakwa apapu apapu. Wunéké vékulakakapuk yakwa du dakwa deku sépéké male vékulakate deku jémbaa male yatépékamunaae, wa de kiyaae lambiyak-ngandakwa. Wunale katik rapékaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Du dakwa ani képmaana musé akwi kéraaké vékulakate, deku jémbaa male yate, kiyaae yénga pulak yékunmba rapékaké daré? Yamba yé wa. Katik yékunmba rapékaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","De Gotna gaayét yéké mawulé yate yéwaa kwayéké daré kapuk? Yamba yé wa. Katik kwayéké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bulaa tékwa némaamba du dakwa wa kapérandi musé yate Gotna kundi yamba vékundakwe wa. Kukmba wuna aapa wunat mayé apa tiyaate wandu wuné Duna Nyaan nyaa véte kaalékwa pulak ye gaayakawutékwa. Gotna kundi kure gaayakwa dunyansale sékét gaayakawutékwa. Gaaye wa kuk kwayékawutékwa, wunat kuk kwayén du dakwat.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas det anga wandén, “Ani kundi ma vékungunék. Guné amba tékwa du dakwa ras kiyaakapuk ye wayéka yatéte vékangunéngwa Got apa tapa yate néma du rate déku du dakwaké yékunmba véndu. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nyaa taambak kaayék nakurak (6) yéndéka Jisas, Pita, Jems, Jon det wunga kure néma némbat nak waaréndarén. Waare de male wamba yaréndarén. Yaréte véndaka Jisasna sépé waalakwe nak pulak yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Déku laplap wamatama ye kalkal naan. Ani képmaamba tékwa du nak yandu déku laplap wunga pulak waama yaké wa yapati-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yandéka talimba yaréte Gotna yémba kundi kwayétan du Elaija ambét Moses bét Jisasale kundi bulténdaka Jisasna dunyan kupuk véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Vétake asa wup wa yandarén. Yate Pita kundi waké kurkale vékusékngapuk yate Jisasét anga wandén, “Néma du, nané amba ranangwan an yékun a. Nané gaa kupuk ma kaakwak. Ménéké nak, Moseské nak, Elaijaké nak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wunga waténdéka buwi nak wa gaaye det taakatépéndén. Taakatépéndéka kundi nak awula buwimba wan, “An wuna nyaan a. Déké néma mawulé yawutékwa. Guné déku kundi ma vékungunu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wunga wandéka vékutake véndarén Jisas male téndéka. Nak du yamba véndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yatake de wani némbu yaasékatake daawulitéte Jisas det anga wandén, “Ma véku. Guné véngunén muséké nak duwat bulaa waké yambak. Wuné Duna Nyaan kiyaawutu Got wandu wuné nakapuk taamale waarapwutu wani sapak guné wani muséké waké ya.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wunga wandéka nak duwat yamba wandakwe wa wani muséké. Deku kapmang bulte anga waatakundarén, “Kiyaae taamale waarapké yandékwa kundi wan kamu kundi dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jisasna dunyan dat anga waatakundarén, “Apakundiké vékusékngwa dunyan anga wandakwa, ‘Gotna yémba talimba kundi kwayétan du Elaija taale yaakandékwa. Yaandu Got wan du Krais kukmba yaakandékwa.’ Kamuké daré wunga wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wunga wandaka anga wandén, “Yi wan wanana wa. Elaija taale yaakandékwa. Yaae Kraisna yaambu kurkandékwa. Wani kundiké vékulakate wunéké waak ma vékulakangunék. Gotna nyéngaamba kwaakwa kundi nak wandékwa pulak Duna Nyaanét kapérandi musé yate dat kuk kwayékandakwa. Kamuké daré wani kundi viyaatakak? ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gunat a wawutékwa. Elaija wa yaan. Yaandéka du ras dat kapérandi musé yandarén. Talimba wani muséké waak wa Gotna nyéngaamba viyaatakandarén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas, Pita, Jems, Jon wunga daawulindarén Jisasna nak dunyan raské. Daawuliye véndarén némaamba du dakwa dele jaawuwe téte apakundiké vékusékngwa du ras dele waarundaka. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Véténdaka akwi du dakwa Jisasét vétake vatvat naandarén. Vatvat naate déké péte ye dat anga wandarén, “Ménat vétake wa mawulé yanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wunga wandaka Jisas déku dunyansat anga wandén, “Kamu kundi guné dele bulu?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wunga waatakundéka du nak anga wandén, “Néma du, wuna nyaan wa kure yaawutén ménéké. Kutakwa nak wa tékwa déku mawulémba. Téléka kundi yamba bulndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wani kutakwa dat kure apamama yaléka wa képmaamba vaakétndékwa. Vaakétndéka biyaat wa déku tépngémba yaalakwa. Yaalandéka némbi tindéka déku sépé apa tapa yakwa. Bulaa ména dunyansat wa wawutén, de wandaru kutakwa yaange yélénngé. Wawutéka wunga yaké wa yapatindarén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wunga wandéka Jisas wani du dakwat anga wandén, “Yénga pulak dé? Guné wunéké yamba yékunmba vékulaka-ngunéngwe wa. Wuné némaamba baapmu wa gunale yatéwutéka guné wunéké yamba yékunmba vékulaka-ngunéngwe wa. Guné wani nyaan ma kure yaangunu wunéké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wunga wandéka déké kure yéndaka dat kulure kure yatan kutakwa Jisasét vétake wani nyaanét taakusoraklén. Yaléka képmaamba vaakére baandéka biyaat déku tépngémba yaalan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaalandéka Jisas déku aapat anga waatakundén, “Kwaaré katik dé wunga yarak?” Naandén. Wunga waatakundéka anga wandén, “Makalnyan yaréndéka wa baasnyé ye wunga yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Némaamba apu wani kutakwa dat kure téte dat yaavan kutte viyaaléka wa gumba, yaamba waak vaakétndén. Méné apamama yamunaae, aanéké ma sémbéraa yate waménu dé yékun yandu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wunga wandéka Jisas anga wandén, “Méné waak ma apamama yaménu. Du dakwa Gorké yékunmba vékulakamunaae, wa de akwi musé yaké apamama yakandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wunga wandéka wani nyaanna aapa anga wandén, “Gorké ayélap a vékulakawutékwa. Ma wunat yékun yaménu Gorké yékunmba vékulaka-kawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wunga wandéka Jisas véndén némaamba du dakwa pétépété yaate jaawundaka. Vétake wani kutakwat anga wandén, “Nyéné dat kure yatényénénga wani nyaan kundi bulkapuk yate waan yamba vékundékwe wa. Ma dé yaasékatake yaange yényénu. Yaange ye nakapuk déku mawulat wulaaké yambakate.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wunga wandéka némaanmba waatake wani nyaanét kulémba vasasaawurak-télén. Yatake dé yaasékatake wa yaange yélén. Yéléka wani nyaan kiyaan du pulak géréke wa kwaandén. Kwaandéka du ras anga wandarén, “Dé wa kiyaan.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naandaka Jisas déku taambamba kutndéka wa dé yékun ye waarape téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yandéka Jisas déku dunyansale gaat wulaandarén. Wulaae deku kapmang yaréte déku dunyan dat anga wandarén, “Nané wani kutakwat wananga yamba yaange yélékwe wa. Yénga pulak nané wani jémbaa yaké yapatik?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wunga waatakundaka anga wandén, “Wani muséké Gorét ma waatakungunék. Gorét taale waatakute, wa guné wangunu kutakwa yaange yékandakwa. Guné Gorét waatakukapuk yangunu, wa kutakwa guna kundi katik vékute yaange yéké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas déku dunyansale wani gaayé taakatake Galili distrikmba yeyé yaayaténdarén. Yeyé yaayate déku dunyansat anga wandén, “Némaamba du dakwa yarénangwa taaléké vékusékmuké kalik yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yate kundi ras gunat wakwate yawutékwa.” Wunga watake det ani kundi wandén, “Kukmba wuné Duna Nyaan maamat kwayéndaru deku taambamba rakawutékwa. Rawutu wuné viyaandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupuk yambanmba nakapuk taamale waarapkawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wunga wandéka wani kundi yamba kurkale vékusékndakwe wa. Yate wani kundiké dat waatakumuké wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kukmba Kaperneamét yéndarén. Ye saambake gaat wulaae Jisas déku dunyansat anga waatakundén, “Yaambumba yaate kamu kundiké guné bulék?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wunga waatakundéka kundi yamba bulndakwe. Yaambumba yaate deku kapmang waarute bulte anga wandarén, “Nanémba kandé taalékére nanéké néma du raké ya?” Wunga watake nékéti yate Jisasét kundi yamba bulndakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yandaka dé rate det anga wandén, “Ma yaale vékungunu. Du nak du dakwaké néma du raké mawulé yamunaae, dékét déku yé kavérékngapuk yate akwi du dakwaké jémbaa yakwa du ma yaténdu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Naatake wani gaamba vétan makalnyan nakét kure wandéka deku nyéndémba téndén. Téndéka wani nyaanét kutte det anga wandén, “Ma vékungunu. Du dakwa wunéké vékulakate anga pulak nyaanét yékun yate wa wunat waak wa yékun yandakwa. De wunat yékun yate wunat wandéka yaawutén duwat waak wa yékun yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jisas wani kundi wandéka Jon dat anga wandén, “Néma du, du nak ména yémba kutakwat wandéka yaange yéndaka wa vénanén. Dé nanale yamba yeyé yaayaténdékwe wa. Yandéka dat watépénanén, wani jémbaa yakapuk yandénngé.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naandéka Jisas dat anga wandén, “Guné wani jémbaa yandénngé watépéké yambak. Wuna yémba kulé apanjémba yakwa du wunéké kapérandi kundi bari katik waké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nanat kuk kwayékapuk yakwa du wa nana du wa yaréndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ani kundi waak ma vékungunék. Du dakwa guné wuna dunyansat véte anga wandaru, ‘Wani du Jisasna jémbaa wa yandakwa. Nané det ma yékun yakwak. Det kulak yandu det kulak kwayékanangwa.’ Wunga wate wani makal jémbaa gunéké yandaru wa Got wani makal jémbaaké katik yékéyaak yaké dé. Kukmba wani yéku jémbaa waambule kwayékata-kandékwa det. Yi wan wanana wa. Gunat a wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas wani kundi watake anga wandén: “Ani makal nyambalé wuna kundi yékunmba vékundakwa. Du ras nak duwat déku kwaalémba néma matut giye dé vaanjanda-ndaru solwaramba daawuliye kulak ke kiyaandu wan kapérandi musé wa. Du nak wandu wani nyambalé nak déku kundi vékute wuna kundi yaaséka-munaandu, wa Got wunga wan duwat yandén kapérandi musé waambule némaanmba yakata-kandékwa. Wan néma kapérandi musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Guna taamba kapérandi musé yaké yandu, wa wani taamba ma sékwe vaanjatingunék. Guna nakurak taamba male téndu wani kapérandi musé yakapuk yate Gotna kémba yaalamunaangunu, wan yékun wa. Guna taamba vétik téndu guné wani kapérandi musé yatake kukmba kapérandi taalat daawulimunaangunu, wan kapére wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wani taalémba yaa yaanpéka-téndékwa apapu apapu. Yaanpéka-téndéka de pusaamba kakwa kaawiya yamba kiyaandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Guna maan kapérandi musé yaké yandu, wa guné wani maan ma sékwe vaanjatingunék. Guna nakurak maan male téndu wani kapérandi musé yakapuk yate Gotna kémba yaalamunaangunu, wan yékun wa. Guna maan vétik téndu wani kapérandi musé yatake kukmba kapérandi taalat daawulimunaangunu, wan kapére wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wani taalémba yaa yaanpéka-téndékwa apapu apapu. Yaanpékaténdéka de pusaamba kakwa kaawiya yamba kiyaandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Guné guna méni kapérandi musé véte wani kapérandi musé yaké mawulé ye, wani méni ma kwapékwe vaanjatingunék. Guna nakurak méni male téndu wani kapérandi musé yakapuk yate Gotna kémba yaalamunaangunu, wan yékun wa. Guna méni vétik téndu guné wani kapérandi musé yatake kukmba kapérandi taalat daawulimunaangunu, wan kapére wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wani taalémba yaa yaanpéka-téndékwa apapu apapu. Yaanpéka-téndéka de pusaamba kakwa kaawiya yamba kiyaandakwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wani kundi watake anga wandén, “Nané sol kakémumba kutnanu wa yékun yakandékwa. Wunga pulak wa, Got wandu yaa pulak yaandu guné akwi kaangél kure kukmba yékun yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kakému résék yandénngé wa sol kutnangwa. Sol yékun yakapuk yandu yénga pulak yananu nakapuk résék yaké dé? Yamba yé wa. Résék nakapuk katik yaké dé. Kakémumba yéku sol kutmunaananu wani kakému résék yakandékwa. Guné sol pulak yate wa akwi du dakwat ma yékun yangunék. Yate dele ma nakurakmawulé yate kurkale yaréngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wani gaayé taakatake Judia distrikét ye taakatake Jisas déku dunyansale Jordan kaambélémba vaatindarén. Vaatiye nak sakumba téndaka némaamba du dakwa Jisaské yaae jaawundarén. Jaawundaka dé apapu yandékwa pulak yate wa nakapuk det Gotna kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yaténdéka wa Farisi du ras déké yaandarén. Yaae deku mawulémba anga wandarén, “Nané dat nak muséké waatakunanu kalmu kapérandi kundi wandu nané dé kotimngé nané?” Wunga vékulakate dat anga wandarén, “Nana apakundi yénga dé wo? Du nak déku taakwa kewuréte dé yaasékatake yélénngé wamunaandu wan yékun dé kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wunga wandaka det anga wandén, “Wani muséké nana gwaal waaranga maandéka bakamu Moses yénga dé wak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wunga wandéka anga wandarén, “Moses anga wandén, ‘Du nak déku taakwa kewuréte dé yaasékatake yélénngé waké mawulé yamunaate, taale ma nyéngaa nak viyaandu, wani muséké. Viyaae lat kwayéte yénga wandu dé yaasékatake yélénngé.’ Moses wunga wandén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wunga wandaka det anga wandén, “Guné akwi kapérandi mawulé yakwa du dakwa yaténgunénga wa Moses gunéké wani kundi viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Talimba baasnyé ye du deku taakwat wunga yamba yandakwe wa. Talimba Gotna nyéngaamba du nak anga viyaatakandén: Talimba baasnyé ye Got akwi musé yatake wa du dakwa waak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Viyaatakatake ani kundi waak viyaatakandén: Du déku aasa aapa yaasékatake taakwa kéraae bét nakurakmba yarékambérékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nakurak sépé pulak ye wa yarékambérékwa. Wani kundiké vékulakate anga vékuséknangwa. Du taakwa kéraae bét nakurakmba yarémbérékwa. Nakurak sépé pulak ye wa yarémbérékwa. Sépé vétik yamba yé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Got bérké anga wandékwa, ‘Nakurak sépé ye wa yarémbérékwa.’ Wunga wandékwanngé du nak déku taakwat katik waké dé, dé yaasékatake yélénngé.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Naatake déku dunyansale sékét gaat wulaandarén. Wulaae de wani kundiké Jisasét waatakundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Waatakundaka det anga wandén, “Du deku taakwa kewuréte de yaasékatake yéndarénngé watake nak taakwa kéraamunaae, wa de taale kéraandarén taakwat kapérandi musé wa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Taakwa deku du yaasékatake nak duké yémunaae, wa de wani duwale kapérandi musé wa yandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Du dakwa ras makal nyambalésé Jisaské kure yéndarén, det taamba kutndénngé. Kure yéndaka Jisasna dunyan vétake det waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Waarundaka Jisas vétake rakarka yate déku dunyansat anga wandén, “Makal nyambalésé ma taaka de wunéké yénga yaandaru. Yaandaru guné det watépéké yambak. Gotna kémba tékwa du dakwa wan de wani makal nyambalésé pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Got néma du rate déku du dakwaké yékunmba vékandékwa. Dé wunga yaké yandékwanngé makal nyambalésé wa mawulé yandakwa. Makal nyambalésé mawulé yakwa pulak, du dakwa dé deké yékunmba véké yandékwanngé mawulé yate, wa de déku kémba yaalakandakwa. Makal nyambalésé yakwa pulak mawulé yakapuk yakwa du dakwa déku kémba katik yaalaké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wunga watake nyambalésé nak nak kéraae taambat kutte anga wandén, “Got gunat yékun yandénngé wa dat waatakuwutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas nakapuk yaambumba yaténdéka du nak déké yaae déké kwaati se waandé daandén. Daate anga wandén, “Méné yéku du wa. Gotna jémbaaké nanat yakwasnyé-ménéngwa. Ma wa. Kamu musé ye wuné kulémawulé kéraae apapu apapu yékunmba rapékaké wuté?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Naandéka Jisas anga wandén, “Kamuké méné wunat anga wo? ‘Yéku du wa.’ Got male wa yéku du yaréndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Got wandéka Moses wan ani apakundi wa vékusék-ménéngwa: Du dakwat viyaandékngé yambak. Nak duna taakwale kapérandi musé yaké yambak. Sél yaké yambak. Nak duké papukundi waké yambak. Paapu yate nak duna musé kéraaké yambak. Ména aasa aapat ma yékun yaménu. Moses wani kundi wandéka wa vékusék-ménéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wunga wandéka anga wandén, “Néma du, wuné makalnyanmba wani vékwe yaae, yaae ani sapak wani apakundi a vékuwutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wunga wandéka déké néma mawulé yate anga wandén, “Méné nak musé waak ma yaménu. Méné taakaménén akwi musé nak duwat kwayéte yéwaa kéraae yéwaakapuk du dakwat ma kwayéménu. Kwayéménu Got ménat yékun yandu kukmba méné Gotna gaayét ye wamba yékunmbaa-sékéyak rapéka-kaménéngwa. Méné yéwaakapuk du dakwat yéwaa kwayétake waambule yaae wuna jémbaamba ma yaalaménék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wunga wandéka wani du vékutake déku némaamba yéwaa, musé asé nak duwat kwayémuké kalik yandéka wa déku saawi, mawulé waak kapére yan. Yandéka wa yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wani du yéndéka Jisas déku dunyansat véte anga wandén, “Némaamba musé kurerékwa du dakwa yakélak yakélak yare ye Gotna kémba katik yaalaké daré. De apamama ye wa néma jémbaa yakandakwa Gotna kémba yaalamuké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wunga wandéka déku kundi vékute vatvat naandarén. Vatvat naandaka anga wandén, “Guno, wuna dunyan, ma vékungunék. Du dakwa Gotna kémba yaalaké mawulé yate de apamama ma yandarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Néma bulmakau nak laplap samapndakwa raaményna yaambumba wulaaké mawulé yamunaae apamama wa yakandékwa. Némaamba musé kurerékwa du dakwa Gotna kémba yaalaké mawulé yate de ma apa tapa yapékandarék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wunga wandéka vatvat naate deku kapmang bulte anga wandarén, “Yéki. Némaamba musé kurerékwa du dakwa Gotna kémba wulaamuké apa tapa yamunaandaru yénga pulak musé kurerékapuk yakwa du dakwa Gotna kémba wulaae yékunmba rapékaké daré apapu apapu? Yamba yé wa. Gotna kémba wulaaké wa yapati-kandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wunga wandaka anga wandén, “Du dakwa deku kapmang apamama yate Gotna kémba yaale yékunmba rapékaké wa yapatindakwa. Got dékét déku kapmang wa wani muséké apamama yandékwa. Got akwi musé yaké wa apa tapa yandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wani kundi wandéka Pita anga wandén, “Ma vékuménu. Nané nana akwi musé yaasékatake ména jémbaa yate ménale yeyé yaayaténangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Wunga wandéka anga wandén, “Yi wan wanana wa. Wunéké yékunmba vékulakakwa du dakwa Gotna kundi kwayémuké wate deku gaa, aanyé waayéka, nyangengu kaayéngu, aasa aapa, nyambalé, képmaa yaasékandaru Got bulaa det yékun yandu wa némaamba gaa, aanyé waayéka, nyangengu kaayéngu, aasa, nyambalé, képmaa waak kéraakandakwa. De wuna kundi kwayéndaru du ras det yaavan kurkandakwa. Kukmba de yékunmbaa-sékéyak yarépéka-kandakwa apapu apapu. Yi wan wanana wa. Gunat a wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ani kundi waak ma vékungunu. Bulaa yarékwa néma du dakwa némaamba kukmba baka du dakwa wa yarékandakwa. Bulaa baka yarékwa némaamba du dakwa kukmba néma du dakwa wa rakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kukmba Jisas déku dunyansale sékét Jerusalemét yéndakwa yaambumba wa yéndarén. Jisas taale yéndéka véte vatvat naate déku dunyan anga wandarén, “Yéki. Wani gaayét yéte wa wup yamba yandékwe wa.” Naandarén. Naandaka deku kukmba yékwa du dakwa dat véte wa de wup yandarén. Yaambumba yéte Jisas déku dunyansat male wa kundi kwayéndén, déké yaaké yakwa muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Anga wandén, “Ma vékungunék. Bulaa Jerusalemét waarénangwa. Waarénanu de Duna Nyaan wuné kéraae kure ye Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan waak det wuné kwayéndaru wa wuné deku taambamba rakawutékwa. Rawutu de wunat viyaandarénngé wakandakwa. Wandaru nak gaayé dunyansé wuné kéraakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kéraae wunat wasélékte sépmany sévaate raamény baangwit viyaae wunat viyaandék-ngandakwa. Yandaru kiyaawutu nyaa vétik yéndu kupuk yambanmba nakapuk taamale waarapkawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jisas wunga wandéka Sebedina nyaan vétik Jems ambét Jon déké yémbérén. Ye anga wambérén, “Néma du, watén pulak aanéké yaménénngé wa mawulé yatékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wunga wambéréka anga wandén, “Kamu yawuténngé béné mawulé yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wunga wandéka anga wambérén, “Kukmba méné apamama yate du dakwaké néma du rate waménu aané nak ména yékutuwa taambamba, nak ména akituwa taambamba rakatékwa. Aané wamba rate nak du dakwaké néma du rakatékwa. Wunga wa mawulé yatékwa.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naambéréka anga wandén, “Béné wunat waatakumbénéngwa muséké yamba vékusék-mbénéngwe wa. Wunat kapérandi musé wa yakandakwa. Wuné néma kaangél kurkawutékwa. Béné wani kaangél kurké béné apamama yo kapuk?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Naandéka anga wambérén, “Yi. Wunga yaké wa apamama yatékwa.” Wunga wambéréka anga wandén, “Kapérandi musé wunat yaké yandakwa pulak bénat wa yakandakwa. Kaangél kurké yawutékwa pulak wa kaangél kurkambénéngwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kukmba kandé wuna yékutuwa taamba, kandé wuna akituwa taambamba raké ya? Wani muséké katik waké wuté. Wan wuna kundi yamba wa. Wamba raké yakwa duké Got talimba déku mawulémba wa kundi wandén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wani kundi wandéka Jisasna dunyan tambavétik (10) wani muséké vékute Jems ambét Jonét rakarka yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yandaka Jisas waandéka yaandaka det anga wandén, “Anga wa vékusék-ngunéngwa. Nak gaayéna néma du du dakwaké apamama yate wa wandakwa, deku kundi yékunmba vékute deku jémbaa yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Guné de yakwa pulak yaké yambak. Gunale tékwa du nak Gotna ménimba néma du raké mawulé yate, wa dé guna jémbaa yakwa du ma yaréndu. Yaréte guna kundi vékute wangunéngwa pulak ma yandék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wuné Duna Nyaan wunga yawutékwa. Nak du dakwaké jémbaa yate det yékun yamuké wa yaawutén. Du dakwa wunéké jémbaa yandarénngé yamba vékulake yaawutékwe wa. Wuné kiyaae némaamba du dakwat Satanna taambamba kéraawutu de Gorale yékunmba rapéka-ndarénngé wa yaawutén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kukmba Jisas déku dunyansale Jerikot yéndarén. Ye saambake Jeriko taakandaka némaamba du dakwa dele sékét yaambumba wa yéndarén. Yéndaka méni kiyaan du nak yaambumba rate du dakwat yéwaaké yaawiréndén. Wani du wan Timeusna nyaan Bartimeus wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yaawire vékundén Nasaret du Jisas yaandéka. Vékute Jisasét waate anga wandén, “Méno, Devitna gwaal waaranga maandéka bakamu wa. Méné Devit pulak néma du téte wunéké ma sémbéraa yaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wunga wandéka némaamba du dakwa dat waarute anga wandarén, “Yakélak ma ra.” Wunga wandaka yamba randékwe yakélak. Nakapuk waate anga wandén, “Néma du, Devitna gwaal waaranga maandéka bakamu, wunéké ma sémbéraa yaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wunga wandéka Jisas vékutake yaambumba téte anga wandén, “Wani du ma waangunu wunéké yaandu.” Wunga wandéka méni kiyaan duwat anga wandarén, “Ména mawulé yékunmba yénga téndu. Ma waarapménu. Jisas a waakwa, déké yéménénngé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wunga wandaka dé yépmaa yandéka saape randén laplap taakatake waarape yéndén Jisaské. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ye saambakndéka dat anga waatakundén, “Ménat kamu yawuténngé méné mawulé yo?” Wunga waatakundéka méni kiyaan du anga wandén, “Néma du, wuné véké wa mawulé yawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Naandéka anga wandén, “Ménat kururéké yawutékwa mayé apaké yékunmba vékulaka-ménénga bulaa ména méni wa yékun yan. Bulaa ma yéménu.” Naandén Jisas. Naandéka déku méni bari yékun yandéka kurkasale véndén. Véte wa Jisasale yaambumba yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisas déku dunyansale Jerusalemét waaréndakwa yaambumba waaréndarén. Waaréte Betfage tékwan Betani waak tékwan ye kwambalitéte véndarén. Wani gaayé vétik Oliv némbumba wa tékwa. Jerusalemale wa tékwa. Vétake Jerusalemmba saambakngé yatéte Jisas déku du vétikét anga wandén, “Béné wani gaayét ma wulaambénu. Wulaae vékambénéngwa donki nyaan nak. Miyémba lékitakandaka wa téndékwa. Talimba du nak wani donkimba yamba waare randékwe wa. Ma lepékwe kure yaambénék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yambénu du nak bénat anga waatakundu, ‘Kamu yaké béné wani donki nyaan lepékwak?’ Wunga wandu anga ma wambénék, ‘Néman Du wani donkiké mawulé yandékwa. Dé bari wandu waambule kure yaakandakwa.’ Dat wunga ma wambénu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wani kundi vékutake ye vémbérén donki nyaan yaambumba téndéka. Wani donki miyémba lékitakandaka gaa nakna pétale wa téndén. Vétake wani donkina baangwi lepékumbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lepékumbéréka du ras wamba téte anga wandarén, “Wani donki nyaan lepékwe kamu yaké béné?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","7","Wunga waatakundaka wa Jisas wan pulak wambérén. Wambéréka yi naandaka donki nyaan kure yémbérén Jisaské. Ye bérku laplap ras donkina bungulmba vaakutakambérén. Vaakutaka-mbéréka Jisas waare wamba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Re yéndéka némaamba du dakwa laplap ras yaambumba taakate yaambu yakusondarén. Yandaka du ras yaawit ye miyé gaalé ras satéke kure yaae yaambumba taakate yaambu yakusondarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yatake du dakwa nyambalé ras taale yéténdaka ras Jisasna kukmba yététe némaanmba anga waandarén: Néman Du Got wandéka wa yaandékwa. Wan yékun wa. Got dat yékun yénga yandu. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nana gwaal waaranga maandéka bakamu Devit talimba néma du randén pulak, wa dé bari néma du rate nanéké yékunmba vékandékwa. Ani néma duwat Got yékun yénga yandu. Nané anjorémba rakwa du Gotna yé ma kavérékngwak. Wunga waandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wunga waaténdaka Jisas ye Jerusalemét wulaandén. Wulaae Gotna kundi bulndakwa néma gaat wulaandén. Wulaae akwi musé véndén. Vétake nyaa daawuliké yandéka déku dunyansale sékét Jerusalem taakatake Betanit nakapuk yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jisas Betanimba kwaae ganmbamba Jerusalemét waambule yémuké yaambumba yéténdéka dat kaandé yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yandéka yéte véndén yéku sék vaakukwa miyé nak apakmba téndéka. Némaamba gaanga wani miyémba téndéka véte déku mawulémba anga wandén, “Némaamba gaanga téndéka sék wa vaakwe tékwa. Ras géle kakawutékwa.” Naandén. Wunga watake wani miyé sék géle kamuké yéndén. Ye vépatikndén. Wani miyé sék ras yamba vaakwe te wa. Wani miyé sék vaakundékwa sékét wayéka yamba yaae wa. Gaanga male téndéka véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Vétake anga wandén, “Du dakwa ani miyémba nakapuk sék katik géle kaké daré.” Wunga wandéka déku dunyansé wani kundi vékundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas déku dunyansale sékét Jerusalemét yéndarén. Ye saambake wa dé Gotna kundi bulndakwa néma gaamba wulaae véndén dunyansé ras musé kwayéte yéwaa kéraaténdaka. Vétake det kewurésalendén. Kewurésalete wa nak gaayéna yéwaa kéraate wani gaayéna yéwaa kwayékwa duna jaambé taakungérundén. Yate viyaae tuwe Gorké kwayéké yandakwa api kwayékwa du rakéséndarén tékét kutmbalakundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yate det anga wandén, “Guné ani gaamba musé ras kéraae kure yeyé yaayaké yambakate.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wunga watake anga wandén, “Ani kundi Gotna nyéngaamba wa kwaakwa: Got anga wandén, ‘Akwi képmaamba yaan du dakwa wuna gaat yaale wunale de kundi yénga bulndaru.’ Got wunga wa wandén. Wani kundiké guné yamba vékulakangunéngwe wa. Guné ani gaamba Gorale kundi yamba bulngunéngwe wa. Guné musé kwayéte yéwaa kéraangunénga ani gaa an sél yakwa du paakwe rakwa gaa pulak a gérékén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wunga wandéka akwi du dakwa déku kundi vékute vatvat naandarén. Naandaka de Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, apakundiké vékusékngwa dunyansé waak wani muséké kundi vékundarén. Vékute wup yandarén Jisaské. Wup yate anga wandarén, “Némaamba du dakwa déku kundi vékute mawulé yate wa vatvat naandakwa. Yénga pulak viyaandékngé nané dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nyaa daawulindéka Jisas déku dunyansale Jerusalem taakatake nakapuk yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nak gaayémba kwaae ganmbamba waarape Jisas déku dunyansale Jerusalemét waambule yéte wa véndarén wani miyé rékaa ye téndéka. Gaanga, apa, méngi waak, akwi wa rékaa yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yandéka Pita vétake Jisas wan kundiké vékulakate dat anga wandén, “Néma du, ma véna. Wani miyé wa rékaa yan. Nalé wani miyéké anga wa waménén, ‘Du dakwa ani miyémba nakapuk sék katik géle kaké daré.’ Wunga waménénga bulaa wa rékaa yan.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Dé wunga wandéka Jisas det anga wandén, “Gunat a wawutékwa. Guné Gorké ma yékunmba vékulakate mawulé vétik yakapuk yate anga wangunu, ‘Got wuna kundi vékukandékwa. Yi wan wanana wa.’ Wunga wamunaate, wa guné ani némbu ye solwaramba daawulindénngé wangunu, wa dé ye solwaramba daawulikandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wani muséké vékulakate gunat a wawutékwa. Guné Gorét waatakute dé waatakuké yangunéngwa pulak gunéké apamama yandénngé guna mawulémba watake dat waatakungunu wa dé gunéké wunga yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Guné téte Gorale kundi bulte yéku mawulé ma vékungunék. Nak du dakwa gunat kapéremusé yandaru guné de yan kapéremuséké nakapuk vékulakaké yambak. Wunga yangunu, wa anjorémba rakwa du guna aapa Got yangunén kapéremusé yasnyéputiye wani muséké nakapuk katik vékulakaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nak du dakwa gunat yandarén kapéremuséké wayéka vékulakate det yakataké mawulé yangunu, wa anjorémba rakwa du guna aapa Got guné yan kapéremuséké vékulakate wa wani kapéremusé yasnyéputikapuk yate gunat yakata-kandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas déku dunyansale nakapuk waambule yéndarén Jerusalemét. Ye saambake Jisas Gotna kundi bulndakwa néma gaat nakapuk wulaandén. Wulaae yeyé yaayaténdéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan, maaka dusé, wunga déké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yaae dat anga wandarén, “Kamu mayé apa kéraae méné wani jémbaa yo? Kandé wak wani jémbaa yaménénngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wunga wandaka det anga wandén, “Wuné waak nak kundi gunat waataku-kawutékwa. Waatakuwutu guné wuna kundi waambule kaatangunu wuné guna kundi kaatakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Guné ma wa. Kandé Jonét wak dé du dakwat baptais kwayéndénngé? Got dé wunga wak, kapuk képmaana du nak dé wunga wak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wunga waatakundéka de deku kapmang bulte waarute anga wandarén, “Nané anga wananu, ‘Got wa wunga wan.’ Wunga wananu, wa nanat anga wakandékwa, ‘Kamuké guné déku kundi vékukapuk yo?’ ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anga kalmu waké nané? ‘Képmaana du nak wa wan.’ Némaamba du dakwa Jonngé anga wandakwa, ‘Gotna yémba kundi kwayétan du nak wa. Yi wan wanana wa.’ Wunga wandakwa. Deké wup yate kundi katik bulké nané Jonngé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wunga bule paapu yate Jisasét anga wandarén, “Yamba vékuséknangwe wa. Wani muséké katik waké nané.” Naandaka det anga wandén, “Wuné waak wunat wandéka yaae ani jémbaa yawutékwa duké katik waké wuté.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas ani gwaaménja kundi det wandén: “Du nak wain yaawi nak yandén. Aatmu giye wain miyé taawundén. Taawutake kukmba wain kulak kéraae kaké wain sék guriksande vakipékumuké kwaawu matumba vaandén. Vaatake yaawiké séngite kaavéréké yandakwa sémény gaa nak kaandén. Kaatake wani yaawiké séngiréte yaawimba jémbaa yate yéwaa kéraaké mawulé yan dunyansat kwayéndén. Kwayétake dé nak taalat yén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Miyé sék géléké yandakwa sékét yandéka dale yaréte jémbaa yakwa du nakét wandén, déku yaawiké kaavéte séngirékwa duké yéndénngé. Ye miyé sék ras kwayéndaru kure yaandénngé wa mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yate wandéka déku du yéndéka yaawiké séngirékwa du wa dé viyaandarén. Viyaae dé kewuréndaka miyé sék kéraakapuk baka male waambule yaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Yaawina néma duké waambule yaandéka déku nak duwat waak wandéka deké yéndén. Yéndéka déku maakamba viyaate dat kapérandi musé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yandaka yaawina néma du déku jémbaa yakwa du nak baanét waak wandéka yéndén. Yéndéka dé viyaandékndarén. Yandaka wa dé du rasét waak wandéka yéndarén. Yéndaka rasét baka viyaate wa rasét viyaandékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Yandaka kukmba wani néma du déku mawulémba anga wandén, ‘Wuna nyaan male a yarékwa. Déké néma mawulé yawutékwa. Déku kundi wa vékukandakwa.’ Naandén. Wunga watake déku nyaanét wandéka yaawiké kaavéte séngirékwa dunyanséké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yéndéka yaawiké séngirékwa du dat vétake deku kapmang kundi bulndarén. Bulte anga wandarén, ‘Yaawina néma du kiyaandu wani nyaan wa déku aapana akwi musé kéraaké yakwa. Nané dé viyaandéktake ani yaawi kéraakanangwa.’ Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wunga watake dé kure ye viyaandékndarén. Viyaandéke déku pusaa kéraae yaawi taakatake kaapat vaanjang-ngwandéndarén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas wunga watake det anga wandén, “Guné yénga guné vékulako? Yaawina néma du yaae yaawiké kaavéte séngiran dunyansat yénga pulak yaké dé? Dé yaae wani dunyansat viyaandékwuré-kandékwa. Viyaandéktake nak duwat wani yaawi kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Viyaandékndarén nyaanngé ani kundi Gotna nyéngaamba wa kwaakwa: Gaa kaakwa du yéku matuké waakte matu nakurakngé kalik yatakandaka baka randén. Randéka Néman Du Got wani matut vétake anga wandén, ‘Wan yéku matu wa. Wani matu randu gaa yékunmba kwaakandékwa.’ Wunga watake wani matu kéraae taakandéka gaa wa yékunmba kwaan. Kwaandéka nané véte mawulé tawulé yanangwa. Wani kundi Gotna nyéngaamba vétake guné yamba yékunmba vékulakangunéngwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wani kundi wandéka néma dunyansé anga vékusékndarén. Jisas deké wa wani kundi wandén. Wunga vékusékte anga wandarén, “Dé ma kure kalapusmba taakakwak.” Wunga watake du dakwa det waarumuké wup yate wa dé yamba kulkindakwe wa. Yate dé taakatake yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Néma du ras dekét deku kapmang bulte anga wandarén, “Nané Jisasét késmusé nakmuséké waatakunanu dé kalmu kapérandi kundi waambule kaataké dé kapuk? Dé kapérandi kundi wandu dé kure ye kalapusmba taakakanangwa.” Naandarén. Wunga watake Farisi dunyan ras, Herotna dunyan waak det wandaka wa Jisaské yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yaae dat anga wandarén, “Néma du, méné du dakwat Gotna jémbaaké wa yakwasnyé-ménéngwa. Méné yéku kundi male wate det Gotna kundiké yékunmba yakwasnyé-ménéngwa. Méné nakurak kundi male waménéngwa, néma du dakwa, baka du dakwat waak. Méné deké wup yamba yaménéngwe wa. Wunga wa vékuséknangwa. Méné wunga yate bulaa nanat ma waménu. Yénga méné vékulako? Nana apakundi yénga dé wo? Nané takis Romna néma du Sisar, dat kwayéké nané kapuk? Nané takis kwayéké yanangwan wan yékun dé, kapuk yamba yé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wunga wandaka Jisas deku mawulé wa vékusék-wuréndén. De deku mawulémba anga wandarén, “Bulaa dé kapérandi kundi wandu dé kure kalapusmba taakakanangwa.” Naandarén. Wunga wandaka Jisas vékusékte det anga wandén, “Guné paapu yakwa dunyansé wa. Kamuké guné wunat wunga waatakwo? Guné yéwaa nak ma kure yaangunu véwutu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naandéka déké yéwaa nak kure yéndarén. Kure yéndaka anga wandén, “Ani yéwaamba kwaakwa nyaap an kéna nyaap dé? Kéna yé daré ani yéwaamba viyaatakak?” Wunga waatakundéka anga wandarén, “Wan Romna néma du Sisarnan wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wunga wandaka det anga wandén, “Yi wan wanana wa. Romna néma du Sisarna musé dat ma kwayéngunék. Gotna musé Gorét ma kwayéngunék.” Naandén. Wunga wandéka wani kundi vékutake vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi dunyan deku mawulémba anga wandarén, “Kiyaan du dakwa nakapuk katik taamale waarapké daré.” Naandarén. De ras Jisaské ye dat anga wandarén: ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Néma du, méné du dakwat Gotna jémbaaké yakwasnyé-ménéngwa. Méné ani muséké nanat ma waménu. Talimba Moses anga viyaatakandén: Du nak taakwa kéraae nyaan kéraakapuk ye kiyaandu déku taakwa wayéka yarépékalu déku waayéka wani taakwa kéraakandékwa. Yandu nyaan kéraalu wani nyaanngé wakandakwa, ‘Aanyéna nyaan wa.’ Wunga wakandakwa. Moses wunga wa viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bulaa ma véku. Talimba nakurak kémba du taambak kaayék vétik (7) yaréndarén. Aanyé taakwa kéraae nyambalé kéraakapuk ye kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kiyaandéka déku waayéka wani taakwa kéraae nyambalé kéraakapuk ye, wa dé waak kiyaan. Kiyaandéka nak waayéka wani taakwa kéraae nyambalé kéraakapuk ye dé waak kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kiyaandéka akwi waayékanje wungat male ye akwi nyambalé kéraakapuk ye baka kiyaawuréndarén. Yandaka kukmba wa wani taakwa kiyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bulaa nanat ma waménu. Kiyaan du dakwa taamale waarapké yandakwa sapakngé waménéngwa. Wani sapak wani taakwa kandale raké lé? Talimba wani nakurak kémna aanyémbéré waayékanje de akwi lat male kéraandarén.” Naandarén Sadyusi dunyansé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas deku kundi vékutake det anga wandén, “Guné Gotna nyéngaamba kwaakwa kundi yamba vékusék-ngunéngwe wa. Vékusékngapuk yate Gotna mayé apaké waak yamba vékusék-ngunéngwe wa. Yangunénga wa guna mawulé kapére yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ma véku. Kukmba Got wandu kiyaan du dakwa taamale waarape Gotna gaayémba yaréte déku kundi kure gaayakwa dunyansé pulak yarékandakwa. Yaréte dunyansé de taakwa katik kéraaké daré. Dakwa de du katik kumbiké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Kundi ras waak wakawutékwa kiyaan du dakwa taamale waarapké yandakwanngé. Talimba makal miyé nak yaa yaandéka Moses téte véténdéka Got dat kundi kwayéndén. Kwayéndén kundi Moses Gotna nyéngaamba anga viyaatakandén: Wuné Abrahamna néma du a. Wuné Aisakna néma du a. Wuné Jekopna néma du a. Wuné deku néma du Got a rawutékwa. Wunga viyaatakandéka guné wani kundi déku nyéngaamba vétake wa yamba yékunmba vékulaka-ngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wani kundiké vékulakate anga vékuséknangwa. Got kiyaan duna néma du yamba randékwe wa. Wani du talimba wa kiyaandarén. Taale wa kiyaandarén. Kukmba wa Got wani kundi wandén. De kiyaae nakapuk taamale waarape randaka wa Got wani kundi wandén. Got kiyaae taamale waarape rakwa duna néma du wa randékwa. Got wan kiyaakapuk kulé tékwa duna néma du wa. Wunga wa vékuséknangwa. Guné nak kundi wangunénga wa guna mawulé kapére yandékwa.” Naandén Jisas Sadyusi dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","De kundi bulndaka apakundiké vékusékngwa du nak wamba téte vékuténdén. Vékuténdéka Jisas Sadyusi dunyanna kundi kurkasale waambule kaatandéka vékutake yaae Jisasét anga wandén, “Nana apakundimba kamu apakundi dé akwi apakundit taalékérak?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wunga waatakundéka Jisas anga wandén, “Ani kundi dé akwi néma kundit wa taalékérawuréndén: Israel du dakwa, ma vékungunék. Nana Néman Du Got wan nakurak male wa. Déku kapmang wa néma du randékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guné guna Néman Du Gorké ma néma mawulé yangunék. Yate dat wangunu guna mawulé, guna kwaminyan, guna yaamambi, guna mayé apaké néma du rakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nak néma apakundi anga wa: Guné guna sépéké néma mawulé yangunéngwa pulak, nak du dakwaké ma néma mawulé yangunék. Yate det ma yékun yangunék. Wani kundi vétik wan néma apakundi wa. Akwi néma apakundit wa taalékérandén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jisas wunga wandéka anga wandén, “Néma du, yékunmba wa waménén. Nana Néman Du Got dékét déku kapmang wa nana néma du randékwa. Nak néma du nak yamba yé wa. Wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Waménén pulak, nané Gorké néma mawulé ma yakwak. Yate dat wananu wa nana mawulé, nana kwaminyan, nana yaamambi, nana mayé apaké néma du rakandékwa. Randu nana sépéké néma mawulé yanangwa pulak, nak du dakwaké néma mawulé ma yakwak. Nané wani kundi vétik vékute wa yékun yakanangwa. Wani kundi vétik talimba wandarén kundit wa taalékérandén. Talimba wandaka kwaami viyaae matu jaambémba tuwe Gorké wa kwayénanén. Kakému waak Gorké wa kwayénanén. Ména kundi vékute yaké yanangwa yapaté wa Gorké kwaami kakému kwayénangwa yapatat wa taalékérandén. Waménén kundi wan néma kundi wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wani du yékunmba vékulakate wa wunga wandén. Wandéka Jisas vékutake dat anga wandén, “Kalmu ayélap yaréyaré naae Gotna kémba yaalaké méné?” Wunga wandéka akwi dunyansé, nak kundi Jisasét waatakumuké wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas Gotna kundi bulndakwa néma gaamba du dakwat kundi kwayéte det anga wandén, “Apakundiké vékusékngwa dunyan anga wandakwa, ‘Gunat yékun yandénngé Got wan du Krais dé Devitna gwaal waaranga maandéka bakamu wa.’ Kamuké daré wunga wo? ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Talimba Krais ani képmaamba yatékapuk yandéka wa Gotna Yaamambi Devitna mawulémba wulaae randéka Devit Kraiské anga wandén, ‘Wuna Néman Du wa.’ Naate anga wandén: Néman Du Got wuna Néman Duwat anga wandén, ‘Méné néma du rate wuna yékutuwa taambamba ma raménék. Raménu wuné wawutu ména maama ména taambamba wa rakandakwa. Randaru méné néma du rate deké vérékaménéngwa.’ Naandén Got. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit wani kundi wate dé Kraiské, ‘Wuna Néman Du wa,’ naandén. Kamuké dé Devit Kraiské wunga wak? Devit Got wan du Kraiské, ‘Wuna Néman Du wa,’ naandéka yénga pulak dé Krais Devitna gwaal waaranga maandéka bakamu to? Krais Devitna gwaal waaranga maandéka bakamu téte Devitna néma du waak dé to kapuk?” Naandén Jisas. Jisas wunga wandéka némaamba du dakwa déku kundi vékute wa mawulé tawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas ani kundi waak det kwayéndén: “Guné apakundiké vékusékngwa dunyanséké ma jéraawu yangunék. De sémény laplap saawuwe du dakwa jaawundakwa taalémba yeyé yaayaké wa mawulé yandakwa. Yeyé yaayandaru du dakwa det véte anga wandarénngé wa mawulé yandakwa: ‘Wan de nana néma du wa.’ Wunga wate deku yé kavérék-ndarénngé wa mawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gotna kundi bulnangwa gaamba wulaae néma duna taalémba raké wa mawulé yandakwa. Némaamba dunyansale kakému kate yéku taaléké waakte du dakwana ménimba raké mawulé yandakwa, de véte deku yé kavérék-ndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","De du kiyaan kwawitakwana musé asé akwi kéraandakwa. De paapu yate néma kundi Gorét waténdakwa, du dakwa det véte deku yé kavérék-ndarénngé. Yandakwanngé Got wandu néma kapérandi musé deké yaakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas Gotna kundi bulndakwa néma gaamba rate véndén némaamba du dakwa Gorké yéwaa kwayéndaka. Rékaamba musé kurerékésén némaamba du dakwa néma yéwaa kwayéndaka wa véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Véténdéka musékapuk yan du kiyaan kwawitakwa nak yaae makalkéri yéwaa vétik Gorké kwayéléka véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Vétake déku dunyansat waate det anga wandén, “Rékaamba musé kurerékwa du dakwa Gorké yéwaa ras kwayéndarén. Kwayéndaka deku yéwaa ras waak wa rakwa gaamba. Ani taakwa makalkéri yéwaa vétik kurerélén pulak akwi wa kwayélén. Kwayétake lé kakému kéraala yéwaa nak yamba yé wa. Gorké kwayéndakwa yéku yapatat lé kwayén yéku yapaté wa taalékéran. Yi wan wanana wa. Gunat wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas Gotna kundi bulndakwa néma gaa taakatake yéké yaténdéka déku du nak dat anga wandén, “Néma du, ani yéku yéku gaat ma vé. Yéku matut male wa yandarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wunga wandéka Jisas dat anga wandén, “Yi, bulaa wan yéku gaa wa. Yéku matut yatakandaka vénangwa. Kukmba dunyansé yaae ani gaa akwi yaavan kurkandakwa. Yaavan kutte ani matu kéraae vaanjanda-ndaru ani matu nak matu taakumba katik kwaaké dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Wani kundi watake Jisas wani gaa taakatake ye Oliv némbat waaréndén. Waare rate Gotna kundi bulndakwa néma gaa apakmba kwaandéka véndén. Véréndéka déku dunyansé Pita, Jems, Jon, Andru, de male déké yaae dat anga wandarén, “Nanat ma waménu. Yani nyaa Gotna gaa yaavan kurké daré? Kamu musé taale yaandu vétake anga waké nané, ‘Yi, bulaa wani vakmi yaakandékwa.’ Yani nyaa wunga waké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wunga waatakundaka wandén, “Guné jéraawu ma yangunék. Yate paapu yakwa duna kundi vékuké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Késépéri du wa yaae wuna yémba wate paapu yate nak nak anga wakandakwa, ‘Wuné Got wan du Krais wuné anana an.’ Wunga wandaru némaamba du dakwa wa deku paapu yandakwa kundi vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Némaamba du waariya-kandakwa. Waariyandaru nak du waariyandakwanngé wakandakwa. Wandaru vékute guné wup yaké yambak. Taale wunga musé wa yakandakwa. Sésékuk sékéyak yaaké yakwa sapak kukmba wa yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nak kantrimba tékwa du dakwa de nak kantrimba tékwa du dakwale waariya-kandakwa. Nak néma duna kém nak néma duna kémale waariya-kandakwa. Késépéri képmaamba némaamba apu néma waalé génngandékwa. Du dakwa kaandéké kiyaakandakwa. Wani vakmi wan dakwa nyaan baasnyé ye kéraaké yate kaangél kutndakwa pulak wa. Wani dakwa kaangél ras waak kurké yandakwa pulak, kukmba vakmi ras waak yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Guné jéraawu ma yangunék. Guné wuna du téngunéngwanngé dunyan ras wuna jémbaaké kalik yate gunat kulkiye guné kotimngandakwa. Gotna kundi bulndakwa gaamba gunat viyaakandakwa. Guné wuna jémbaa kutngunéngwanngé du ras guné kure yéndaru deku néma duna ménimba wa tékangunéngwa. Téte guné wuna yéku kundi det ma kwayéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wuna du dakwa taale akwi képmaamba tékwa du dakwat wuna kundi ma kwayéndarék. Kwayéndaru sésékuk sékéyak yaaké yakwa sapak yaakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gunat kure ye kotimndaru guné taale guna mawulémba anga waké yambak, ‘Nané deku kundi yénga pulak waambule waké nané?’ Wunga waké yambak. Wani sapak wa Gotna Yaamambi waké yangunéngwa kundi gunat kwayékandékwa. Gotna Yaamambi guna mawulémba rate wa gunat wakandékwa. Wandu vékute wani kundi det ma kwayéngunék. Guna mawulémba vékulakate baka waké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Wani kapérandi sapak némaamba du deku aanyé waayékat kotimndaru aanyémbéré waayékanjet viyaandék-ngandakwa. Aapa deku nyambalésat kotimndaru nak du wani nyambalésé viyaandék-ngandakwa. Nyambalésé waak deku aasa aapat kotimndaru nak du wa aasa aapat viyaandék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Guné wuna du téngunéngwanngé wa akwi du dakwa gunéké kalik yakandakwa. Wani muséké wup yaké yambakate. Deku mawulémba apamama yate wuna jémbaa yatépékaké yakwa du dakwat Got kéraandu de dale apapu apapu yékunmba rapéka-kandakwa. Katik lambiyakngé daré.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Guné ani nyéngaamba véte ani muséké yékunmba ma vékulakangunék. Wani kundi watake Jisas anga wandén: “Talimba Gotna yémba kundi kwayétan du nak ani kundi viyaatakandén: Kukmba du nak yaae Gotna kundi bulndakwa néma gaamba Got watépéndén musé nak taaka-kandékwa. Taakandu de wani gaaké anga wakandakwa, ‘Kapérandi gaa wa.’ Naakandakwa. Wunga viyaatakandén musé yaalandu vékangunéngwa. Véte wani sapak guné Judiamba tékwa du dakwa guna gaayé yaasékatake némbat bari ma yaange yéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wani sapak kaapamba rakwa du dakwa bari ma yaange yéndarék. Deku musé kéraamuké gaat nakapuk katik wulaaké daré. Baka ma yaange yéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yaawimba tékwa du dakwa gaayét waambule ye laplap ras waak katik kéraaké daré. Bari ma yaange yéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Wani kapérandi sapakmba nyaan rakwa dakwa, nyambalé munyaa kwayétékwa dakwa waak bari yaange yéké yapati-kandakwa. Deké sémbéraa yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wani kapérandi sapak maas viyaakwa sapakmba yaandu, yénga pulak bari yaange yéké guné? Yéké yangunéngwanngé vékulakate Gorét ma waatakungunék, maas viyaakwa sapakmba wani kapérandi sapak yaakapuk yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wani sapak némaamba vakmi wa yaaké yakwa. Wani vakmi akwi vakmit wa taalékéra-kandakwa. Talimba Got akwi musé yandén sapakmba yaae bulaa ani sapakmba wunga pulak vakmi nak yamba yaandékwe wa. Bulaa waak kukmba waak wunga pulak vakmi nakapuk katik yaaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wani vakmi yaandaru Got déku du dakwaké sémbéraa yate wandu wani vakmi bari késkandakwa. Wunga wakapuk yamunaandu, wa akwi du dakwa lambiyak-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wani sapak du ras gunat anga wandaru, ‘Ani duwat ma véngunék. An Got wan du Krais a.’ Wunga wandaru guné deku kundi vékuké yambak. De anga wandaru, ‘Wani duwat ma véngunék. Wan Got wan du Krais wamba wa randékwa.’ Wunga wandaru guné deku kundi vékuké yambak. De paapu wa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Némaamba du yaae Gotna du dakwat paapu yate nak nak anga wakandakwa, ‘Wuné Got wan du Krais wuné anana.’ Wunga wandaru ras paapu yate nak nak anga wakandakwa, ‘Wuné Gotna yémba kundi kwayékwa du wuné anana.’ Wunga watake paapu yate késpulak nakpulak kulé apanjémba, talimba vékapuk yangunén apanjémba waak yakandakwa. Guna mawulé yaavan kutmuké wa wunga yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Guné ma jéraawu yangunék. Gunat wa wawutén, kukmba yaaké yakwa muséké. Kukmba wani musé yaandu guné véte vékusékte deku kundi vékuké yambak.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wani kundi watake Jisas anga wandén: “Wani vakmi yéndaru bari nyaa vékapuk yate ganngu yakandékwa. Yandu baapmu waak katik kaaléké lé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yalu akwi kun nyétmba vaakérkandakwa. Vaakétndaru nyétmba tékwa akwi apa yakwa musé naayéro-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yandaru ani képmaamba tékwa du dakwa wuné Duna Nyaan wuné vékandakwa. Wuné apa tapa yate nyaa véte kaalékwa pulak yate buwimba re gaayakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gaaye wawutu wuna kundi kure gaayakwa dunyansé képmaana akwi taalémba tékwa akwi gaayémba ye wuna du dakwa kure yéte nakurakmba taaka-kandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wani kundi watake Jisas anga wandén: “Miyéké yékunmba ma vékulakangunék. Miyé ras gaanga périye vény waapindéka véte anga vékusék-ngunéngwa. Kakému naaré yakwa sékét bulaa a yaandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wani miyat véte wani sapakngé vékusék-ngunéngwa pulak, wawutén musé véte vékusék-ngangunéngwa. Wuné bari waambule yaakawutékwa. Wunga wa vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gunat a wawutékwa. Bulaa tékwa du dakwa ras kiyaakapuk ye wayéka téte wawutén akwi musé vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nyét képmaa waak késkandékwa. Wuna kundi katik késké dé. Rapéka-kandékwa. Yi wan wanana wa. Gunat a wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yani nyaa waambule yaaké wuté? Ani képmaamba tékwa du dakwa wani nyaaké yamba vékusékndakwe wa. Gotna kundi kure gaayakwa du waak wani nyaaké yamba vékusékndakwe wa. Wuné Gotna nyaan wuné waak yamba vékusékwutékwe wa. Wuna aapa dékét déku kapmang dé male wa waambule yaaké yawutékwa nyaaké vékusékndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Guné wunéké kaavéréte ma kurkale yaréngunék. Wuné guna Néman Du yaaké yawutékwa nyaaké yamba vékusék-ngunéngwe wa. Yate guné wunéké kaavéréte ma yaréngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ani kundiké ma vékulakangunék. Néma du nak gaayét yéké yate taale déku jémbaa yakwa dunyansé nak nakét jémbaa kwayéndén. Kwayétake pétéké séngite kaavérékwa duwat anga wandén, ‘Wuna gaaké ma kurkale séngite kaavéréménu.’ Naandén. Naatake déku gaa taakatake apakmba tékwa gaayét yéndén. Wani du yéku jémbaa yate waambule yaaké yandékwanngé vékulakate kurkale séngite kaavéré-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Guné wani du pulak jémbaa yate ma kaavéréte yékunmba yaréngunék. Guné yamba vékusék-ngunéngwe wa. Yani nyaa wuné guna néma du nakapuk waambule yaaké wuté? Garambu yaaké wuté, kapuk nyéndé gaan yaaké wuté? Yé gérké yaténdu yaaké wuté, kapuk ganmbamba yaaké wuté? Wani muséké yamba vékusékngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wuné bari yaaké wuté kapuk? Yaaké yawutékwanngé vékulakate ma kaavéréte yékunmba yaréngunék. Guné wunéké yékéyaak ye yundé kwaaké yambak. Ma yékunmba yaréngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gunat wawutén kundi akwi du dakwat a wawutékwa. Guné akwi waambule yaaké yawutékwanngé vékulakate ma kaavéréte yékunmba yaréngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nyaa vétik yéndu yis kurkapuk yandarén bret kandakwa nyaa yaakandékwa. Wani nyaa Judasé Got talimba det yékun yandénngé vékulakate Pasova waandakwa nyaana kakému kakandakwa. Wani sapak Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, apakundiké vékusékngwa dunyansé waak mawulé yandarén, de yakélak ye Jisas kulkiye dé viyaandékngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yate anga wandarén, “Dé ma viyaandékngwak. Kakému yaake kaké yanangwa nyaa dé katik kulkiké nané. Bulaa némaamba du dakwa wani kakému kaké wa ani gaayét yaandarén. Bulaa nané Jisas kulkinanu, wa de rakarka yate nanat némaanmba waarukandakwa. De yéndarumbut dé kulkiye viyaandékngwak.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas Betanit yéndén. Ye saambake talimba lepro yan du déku yé Saimon, déku gaamba randén Jisas. Rate dale kakému karéndéka taakwa nak matumba yandarén makalkéri botol kure yaalén. Wani botolmba yéku yaama yakwa gu wa tén. Dunyansé wani gu kéraaké némaamba yéwaa wa kwayékandakwa. Wani taakwa yaae Jisas ranmba téte botol pulaape déku maakamba wani gu sévilén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Séviléka du ras vétake dekét deku kapmang bulte lat rakarka yandarén. Yate anga wandarén, “Kamuké lé wani gu baka sévik? ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wani gu wan yéku gu wa. Lé wani gu kwayéte némaamba yéwaa kéraae musékapuk du dakwat kwayémunaalu yékun yakatik.” Wunga watake lat némaanmba waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas deku kundiké kalik yate det anga wandén, “Kamuké guné wani taakwat waaruwu? Wunga yaké yambakate. Wan yéku musé wa yalén wunat. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Musékapuk du dakwa gunale yarépéka-kandakwa. Yaréndaru mawulé yangunéngwa sapak apapu apapu guné det yékun yakangunéngwa. Wuné gunale katik yarépékaké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wani taakwa léku mayé apamba wa yalén. Wuné kiyaawutu kwaawumba rémngé yandakwanngé vékulakate wa wani gu wuna sépémba sévilén.” Wunga wate Judasé pusaa rémngé yate yandakwanngé wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Watake det anga wandén, “Kukmba wuna kundi akwi képmaamba kwayéte ani taakwa yan muséké waak wakandakwa. Wate léké vékulaka-kandakwa. Yi wan wanana wa. Gunat a wawutékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wani sapak Jisasna du nak déku yé Judas Iskariot, dé Gotna gaamba jémbaa yakwa dunyanna néma duké yéndén, Jisas det kwayéké kundi bulmuké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ye bulndéka déku kundi vékute mawulé yandarén. Yate dat yéwaa ras kwayéké wa kundi gindarén. Kundi gindaka ye det Jisas kwayéké yandékwa sapakngé kaavéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis kurkapuk yandarén bret kandakwa sapak wa yaan. Wani bret baasnyé ye yaakéndakwa nyaa wa nyansipsip ras viyaandakwa, Pasova waandakwa sapakna kakémuké. Wani nyaa Jisasna dunyan déké yaae dat anga wandarén, “Yani taalémba ye musé kururé-takananu Pasova waanangwa sapakna kakému rate kaké méné mawulé yo?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wunga waatakundaka du vétikét anga wandén, “Ma ye Jerusalemét wulaambénu. Wulaae kulak tékwa aké yaate tékwa du nakét vékambénéngwa. Vétake déku kukmba ma yémbénu. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ye wulaandékwa gaat ma wulaambénu. Wulaae wani gaana duwat anga ma wambénék, ‘Gotna kundiké nanat yakwasnyékwa du ménat anga wandékwa: Wuné wuna dunyansale Pasova waanangwa sapakna kakému kaké yanangwa gaa yani taalémba dé kwaau? Wunga wandékwa.’ Naambénék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wunga wambénu anjorémba tékwa néma rum nak bénat wakwasnyé-kandékwa. Wani taalémba kakému kanangwa jaambé, ranangwa tékét waak wa tékésékwa. Béné wani taalémba kakému, musé asé ma kururétakambénu nanéké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wunga wandéka ye Jerusalemét wulaae Jisas wan pulak vémbérén. Vétake Pasova waanangwa sapakna kakému, musé asé waak kururétakambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nyaa daawulindéka Jisas déku dunyan tambavétik maanmba kaayék vétik (12) sékét wunga yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yaae rate kakému karéndarén. Karéte det anga wandén, “Nanale karékwa du nak wuné kwayékandékwa wuna maamat. Yi wan wanana wa. Gunat a wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wunga wandéka deku mawulé kapére yandéka vatvat naate nak nak dat anga waatakundarén, “Wan wunéké méné wo kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wunga waatakundaka anga wandén, “Wuna du nak wa. Wunale sékét dismba tékwa kumbingumba bret vaanjande taawukwa du wa wuné maamat kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wuné Duna Nyaan kiyaakawutékwa. Gotna nyéngaamba kiyaaké yawutékwanngé talimba kundi wa viyaatakandarén. Kiyaawutu vakmi yaakandékwa, wuné maamat kwayékwate yakwa duké. Wani du déku aasa dé kéraakapuk yamunaalu wan yékun yakatik.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jisas déku dunyansale rate kakému karéte bret kéraae Gorét anga wandén, “Yéku musé a tiyaaménén. Wan yékun wa.” Wunga watake bret bule déku dunyansat kwayéte anga wandén, “Ma kéraae kangunék. An wuna sépé a.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wunga watake wain kulak tén kasnya nak kéraae Gorét anga wandén, “Yéku kulak a tiyaaménén. Wan yékun wa.” Naatake det kwayéndéka kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kandaka det anga wandén, “An wuna nyéki a. De wuné viyaandékndaru wuna nyéki vaakundu guné véte anga vékusék-ngangunéngwa. Got du dakwat yékun yaké wandén kundi wa sékérék-ngandékwa. Wuné kiyaae némaamba du dakwat yékun yakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gunat a wawutékwa. Ani képmaamba wayéka baka yatéte wuné wain kulak nakapuk katik kaké wuté. Kukmba wuna aapa Got du dakwaké néma du randu nané déku gaayémba dale rate wuné gunale kulé wain kulak kakawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wunga wandéka Gotna nyéngaamba kwaakwa gwaaré waatake waarape gwaande Oliv némbat waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas déku dunyansat anga wandén, “A vékusékwutékwa. Guné akwi wunat kuk kwayéte yaange yékangunéngwa. Yaange yékwate yangunénngé Gotna kundi déku nyéngaamba anga wa kwaakwa: Wuné sipsipké séngite kaavérékwa duwat viyaawutu sipsip yaange yékéraa-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wani kundi wandékwa pulak yaange yékangunéngwa. Yéngunu wa wuné kiyaaké yakwa. Kiyaae kukmba nakapuk taamale waarape talétalé Galilit yékawutékwa. Yéwutu guné kukmba wa yaakangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naandéka Pita dat anga wandén, “Wuné ménat kuk katik kwayéké wuté. Katik yaange yéké wuté. Nak du ménat kuk kwayéte yaange yéndaru, wuné wunga katik yaké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wunga wandéka anga wandén, “A vékusékwutékwa. Bulaa gaan séraa apu vétik waakapuk téndu méné apu kupuk anga wakaménéngwa, ‘Wuné Jisas yamba véwutékwe wa.’ Wunga waménu wa séraa waaké ya. Yi wan wanana wa. Wunga vékusékte wa ménat wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naandéka anga wandén, “Yamba yé wa. Wunga katik waké wuté. Wuné ménale kiyaamuké, katik wup yaké wuté. Wani kundi katik waké wuté.” Naandén Pita. Wunga wandéka Jisasna dunyansé akwi wungat male wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wani kundi watake Jisas déku dunyansale taalé nakét wulaandarén. Wani taaléna yé Getsemani wa. Wulaae det anga wandén, “Amba ma rangunu. Wuné Gorale kundi bulké mawulé yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wunga watake Pita, Jems, Jon det kéraae kure sékét yéndarén. Yéténdaka déku mawulé kapére yandéka vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yate det anga wandén, “Wuna kwaminyan bérukwa. A kiyaakawutékwa. Guné amba ma séngite kaavéréngunék. Yundé kwaaké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Wunga watake de randaka dé ayélap yépulak naae képmaamba kwaate Gorét anga wandén, “Wuna aapa, akwi muséké wa apamama yaménéngwa. Méné yaaké yakwa muséké waké mawulé ye, wa méné waménu wunéké yaaké yakwa vakmi wunéké katik yaké dé. Ménat wunga waatakuwutékwa. Méné wuné mawulé yakwa pulak yaké yambak. Ménékét mawulé yaménéngwa pulak ma yaménék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wani kundi watake déku dunyanngé waambule ye véndén yundé kwaakéséndaka. Vétake det sérkiyaate Pitat anga wandén, “Saimon, wan yundé méné kwaau kapuk? Méné ayélapkéri sapak wunale raké yapatiménéngwa. Méné wa yundé kwaan.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wunga watake det anga wandén, “Guné yundé kwaaké yambakate. Yékunmba vékulakate Gorét ma waatakungunék, vakmi gunat yaavan kurkapuk yandénngé. A vékusékwutékwa. Guné yundé kwaamuké kalik yangunénga guna sépé apa tapa yakapuk yandéka wa gunat yundé yandéka wa yundé kwaangunén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wunga watake nakapuk de yaasékatake ayélap yépulak naae Gorét nakapuk waatakundén. Taale Gorét waatakundén kundi male wa nakapuk waatakundén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Waatakutake déku dunyanngé nakapuk waambule ye véndén nakapuk yundé kwaandaka. Deku méni yundé male yandéka wa kwaandarén. Kwaae vélérkiyaae dat nakapuk vétake yamba vékusékndakwe wa. Dat kamu kundi waké daré? Vékusékngapuk ye yakélak randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dé nakapuk ye Gorét waatakutake déku dunyanngé waambule yaae det sérkiyaate anga wandén, “Yénga pulak guné wayéka yundé kwaapéko? Yaak. Ma vékungunu. Wuné Duna Nyaan wuné kapéremusé yakwa dunyansat kwayéké yandékwa sapak a yaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ma waarapngunu yékwak. Ma véngunu. Wuné maamat kwayéké yakwa du wa yaatékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas wayéka téte bulténdéka déku du nak Judas bari yaandén. Némaamba dunyansé deku waariyandakwa kulaa, baangé waak kure sékét dale yaandarén. Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan, maaka dunyan waak takamba wunga watakandaka wa yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Takamba Jisas maamat kwayéké yakwa du Judas Jisasét kulkiké yakwa dunyansat anga wandén, “Wuné taama réngwutékwa du wan Jisas wa. Dé kulkiye ma kurkale kure yéngunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas bari yaae Jisasét anga wandén, “Néma du.” Wunga watake dat taama réngndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yandéka dale yaan du Jisaské ye dé kulkindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kulkindaka wamba tan du nak waariyandékwa kulaa kelike Gotna gaamba jémbaa yakwa akwi dunyanna néma duké jémbaa yakwa duwat viyaae déku waan satékyasnyé-ndéka vaakérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yandéka Jisas det anga wandén, “Guné wunat kulkiké yaate kamuké guné waariyangunéngwa kulaa baangé waak kure yaak? Guné sél yakwa duwat viyaaké guné wani musé kure yaau kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Késépéri nyaa wuné Gotna kundi bulnangwa néma gaamba yatéte du dakwat Gotna kundiké wa yakwasnyéwutén. Wamba téwutéka wunat yamba kulkingunéngwe wa. Wunat yangunéngwa muséké talimba du ras Gotna nyéngaamba wa viyaatakandarén. Viyaatakandaka bulaa deku kundi a sékérékngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wunga wandéka déku dunyan akwi dé yaasékatake yaange yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Déku dunyan yaange yéndaka wa Jisasét kure yéndarén. Kure yéndaka waama laplap nakurak male saawan biyaku du nak Jisasna kukmba wa yéndén. Yéndéka dat kulkiké naae déku laplapmba kutndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kutndaka laplap lékutake baka male wa yaange yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisas kulkin dunyansé dé kure yéndarén, Gotna gaamba jémbaa yakwa akwi dunyanna néma duké. Gotna gaamba jémbaa yakwa dunyanna akwi néma dunyansé, maaka dunyansé, apakundiké vékusékngwa dunyansé waak wa Gotna gaamba jémbaa yakwa akwi dunyanna néma duna gaamba jaawundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita apak pulakmba téte Jisasna kukmba ye néma duna gaaké aatmu gisangwandé-ndarén taalat wulaandén. Wulaae polisale kaapamba randén. Yépmaa yandéka dé dele yaamba véréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gotna gaamba jémbaa yakwa akwi dunyanna néma du, Israelna nak néma dunyansé waak Jisas viyaandékngé wa mawulé yandarén. Yate anga wandarén, “Jisas yan kapéremuséké kandé waké ya?” Wunga wandaka du nak wunga yamba wandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paapu yakwa némaamba dunyan yaae wa paapu yate wa Jisas yan muséké wandarén. Wate nakurak kundi yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Du ras téte paapu yate Jisaské anga wandarén, “Wani du anga wandén, ‘Du kaan ani gaa, Gotna kundi bulnangwa néma gaa yaavan kurkawutékwa. Yaavan kure nyaa kupuk yéndu wuné nak pulak gaa kaakawutékwa.’ Wunga wandéka wa vékunanén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wunga wate késpulak nakpulak kundi wa wandarén. Nakurak kundi yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wani kundi wandaka Gotna gaamba jémbaa yakwa akwi dunyanna néma du waarape téte Jisasét anga wandén, “Kamuké méné deku kundi waambule kaatakapuk yo? Deku kundi yénga pulak dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wunga wandéka Jisas kundi yamba bulndékwe wa. Yandéka Gotna gaamba jémbaa yakwa akwi dunyanna néma du dat anga wandén, “Méné Got wan du Krais méné kapuk? Méné anjorémba rakwa néma du Gotna nyaan méné kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wunga wandéka anga wandén, “Yi. Kukmba vékangunéngwa, wuné Duna Nyaan néma du rate apa tapa yakwa du Gotna yékutuwa taambamba re buwiale anjoré nyétmba gaayawutu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wunga wandéka Gotna gaamba jémbaa yakwa akwi dunyanna néma du rakarka yate dékét déku laplap gérikte anga wandén, “Guné déku kundi wa vékungunén. Wan kapérandi kundi wa. Nak duwat katik waatakuké nané, yandén kapérandi muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dé wunga watake Gorké kapérandi kundi bulte wa Gorét wasélékndén. Yénga guné wo déké?” Wunga wandéka anga wandarén, “Kapéremusé wa yandén. Dé ma kiyaandu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wani kundi watake du ras Jisasna sépémba sépmany sévaanguralndarén. Sévaanguralte déku ménimba laplap nak gitépéndarén. Gitake dat viyaate, dat wasélékte anga wandarén, “Méné Gotna yémba kundi kwayékwa du rate akwi muséké wa vékusékménéngwa. Vékusékte, nanat ma wa. Kandé ménat viyaau?” Wunga wate polis dat kure taambat baawundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita andamba randén, gaaké aatmu gisangwandé-ndarénmba. Randéka Gotna gaamba jémbaa yakwa akwi dunyanna néma duna jémbaa yakwa taakwa nak yaalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yaae vélén Pita yaale randéka. Vétake dat anga walén, “Méné waak Nasaretmba yaan du Jisasale wa yatéménén.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wunga waléka anga wandén, “Yamba wa. Wuné wa wanyénéngwa kundi yamba vékusék-wutékwe wa.” Wunga watake gwaande pétémba randén. Randéka wa séraa waan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yandéka wani taakwa dat nakapuk vétake lale sékét tan du dakwat anga walén, “Ani du waak wan déku jémbaamba wulaan du wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wunga waléka nakapuk anga wandén, “Yamba yé wa.” Wunga wandéka ayélap raré naae wamba tékésén du nakapuk anga wandarén, “De Galilimba wa yaandakwa. Méné waak Galilimba yaan du wa. Méné Jisasna du nak wa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wunga wandaka Pita det némaanmba anga wandén, “Yamba yé wa. Wa wangunéngwa du yamba véwutékwe wa. Gotna yémba wa wawutékwa. Paapu wamunaawutu wa Got wunat yénga yaavan kutndu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wunga wandéka wa séraa nakapuk waan. Waandéka Jisas dat wandén kundiké vékulakandén. Takamba Jisas wa wandén, “A vékusékwutékwa. Séraa apu vétik waakapuk téndu méné apu kupuk wakaménéngwa, ‘Wuné dé yamba véwutékwe wa.’ Wunga waaménu séraa nakapuk waakandékwa.” Pita wani kundiké vékulakate Jisasét kuk kwayétake néma sémbéraa yate wa géraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yé gétndéka Gotna gaamba jémbaa yakwa dunyanna néma dunyansé, maaka dunyansé, apakundiké vékusékngwa dunyansé, akwi néma dunyansé waak jaawuwe kundi bulndarén. Bule wandaka Jisas baangwit giye Romna néma du Pailatké kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kure yéndaka Pailat Jisasét anga waatakundén, “Méné Judaséna néma du méné kapuk?” Wunga waatakundéka anga wandén, “Yi. Ménékét ména kapmang wa wunga waménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wunga wandéka Gotna gaamba jémbaa yakwa dunyanna néma dunyansé késépéri papukundi wandarén, Jisas yan muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wandaka Pailat dat anga wandén, “De ménéké némaamba kundi wa wandakwa, yaménén muséké. Kamuké méné deku kundi waambule kaatakapuk yo? Kamuké méné kundi bulkapuk téte véto?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wunga wandéka kundi ras waak yamba wandékwe Pailarét. Yandéka wa Pailat vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akwi kwaaré Pasova waandakwa nyaana kakému kandakwa sapak Romna néma du wandéka du dakwa mawulé yandakwa du nak kalapus yaasékatake gwaande baka yékunmba yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wani sapak kapéremusé yan dunyan ras kalapusmba kwaandarén. Talimba de Rom dunyanngé kalik yate Jerusalemmba tékwa du dakwat wandaka wa de Rom dunyansale waariyandarén. Naknya du rasét viyaandékndarén. Wani kapéremusé yan dunyan nak wan Barabas wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akwi du dakwa yaae Pailarét waatakundarén, akwi kwaaré wandén pulak nakapuk wandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Waatakundaka Pailat anga vékusékndén. Jisas kapérandi musé yamba yandékwe wa. Gotna gaamba jémbaa yakwa dunyanna néma dunyansé Jisaské kalik yate dat giye kure yaandarén déké. Wunga vékusékte déku mawulémba anga wandén, “Jaawuwe tékwa du dakwa Jisaské kalmu mawulé yaké daré kapuk?” Wunga watake wani du dakwat anga wandén, “Judaséna néma duwat wawutu baka yékunmba yéndénngé guné mawulé yo kapuk?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wunga wandéka Gotna gaamba jémbaa yakwa dunyanna néma dunyan wamba tékésén du dakwat wandarén, Pailarét wandaru Jisaské wakapuk yate Barabaské wandénngé. Wandu Barabas kalapus yaasékatake gwaande baka yékunmba yékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wunga wandaka Pailat det nakapuk anga wandén, “Waangunéngwa Judaséna néma duwat yénga pulak yaké wuté?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Naandéka de akwi waate anga wandarén, “Dé takwemimba ma baangtaka.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wunga waandaka anga wandén, “Kamuké? Kamu kapérandi musé dé yak?” Wunga wandéka némaanmba waandarén, “Dé takwemimba ma baangtaka.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wunga waandaka Pailat déku mawulémba anga wandén, “Deku kundi vékuwutu wa wunéké mawulé yakandakwa.” Wunga watake wa wandén, Barabas kalapus yaasékatake gwaande baka yékunmba yéndénngé. Watake déku waariyakwa dunyansat wandén, Jisasét raamény baangwit némaanmba viyaae dé takwemimba baangtakandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailatna waariyakwa dunyansé deku néma gaat Jisas kure yéndarén. Kure yéndaka waandaka akwi waariyakwa dunyan yaae dé ténmba jaawundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jaawuwe deku mawulémba anga wandarén, “Néma du gwaavé laplap saawuwe yéku hat wa saaptakandakwa.” Wunga wate Jisasét waangite wasélékte déku laplap laariye gwaavé laplapét saawutakandarén. Saawutake raamény baangwi nak kéraae hat pulak nyéwayékwe déku maakamba taakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Taakatake dat wasélékte anga wandarén, “Méno, Judana néma du, yékunmba ma raménék.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wunga wate baangé nak kéraae déku maakamba viyaandarén. Viyaate dat sépmany sévaanguralte dat wasélékte déké kwaati se waandé daandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wunga yasékéyaktake yaak wani saawutakandarén gwaavé laplap laariye déku laplap nakapuk saawutakandarén. Saawutake dé takwemimba baangtakamuké kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yaambumba yéte waariyakwa dunyansé Sairini du nak déku yé Saimon véndarén. Déku nyaan vétik Aleksander ambét Rufus wa. Dé nak taalémba yaae Jerusalemét wulaaké yéndéka wa véndarén. Vétake wa dat wandarén, dé Jisas baangtakaké yandakwa takwemi yaatandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Watakandaka yaatandéka ye Golgota waandakwa taalémba saambakndarén. Wan Judana kundi wa. Nana kundimba wanangwa, Duna Maaka Apa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Saambake marasinale yandarén wain kulak Jisasét kwayéndarén, dé katake néma kaangél vékukapuk yandénngé. Kwayéndaka yamba kandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yandéka dat takwemimba baangtakandarén. Baangtake rate déku laplap muni waataké satu pulak pilai yandarén. Yandaka det taalékéran du wa déku laplap kéraan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ganmba (9 klok pulak) wa Jisas takwemimba baangndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dé baangndarén takwemina waambumba anjoré viyaataka-ndarén kundi wan anga wa: An Judaséna néma du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisas takwemimba baangtake waariyate sél yan du vétik takwemi vétikmba baangtakandarén. Nakét déku yékutuwa sakumba baangtakandarén. Nakét déku akituwa sakumba baangtakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wunga yandaka Gotna nyéngaamba talimba viyaatakandarén kundi wani sapak wa sékérékén. Anga viyaatakandarén: Dat véndarén kapéremusé yan duwale téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dunyan ras yeyé yaayatéte Jisas takwemimba baangtakandaka téndéka véte dat waangite wasélékndarén. Yate anga wandarén, “Ménawa. Yénga pulak dé? Méné Gotna kundi bulnangwa néma gaa yaavan kure nyaa kupuk yéndu nakapuk kaaké wa waménén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bulaa ména kapmang ména sépat ma yékun yaménék. Méné apamama yate wani takwemi yaasékatake ma gaayaménu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wunga wandaka Gotna gaamba jémbaa yakwa dunyanna néma dunyan, apakundiké vékusékngwa dunyan waak deku kapmang bulte Jisasét waangite wasélékndarén. Yate anga wandarén, “Dé nak duwat wa yékun yandén. Dékét déku sépat yékun yaké yapatindékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dé nanat yékun yandénngé Got wan du Krais rate Israelna néma du ramunaae wa baangtakandarén takwemi yaasékatake gaayandu nané véte déku kundiké anga wakatik nané, ‘Yi wan wanana wa.’ Naakatik nané.” Naandarén. Wunga wandaka Jisasale takwemimba baangtakandarén du vétik bérku takwemimba anjo téte bét waak dat wasélékmbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nyaa vélénawuréndéka nyéndé nyaa wa akwi képmaamba gaan yan. Ye téndéka kukmba nyaa tépatekwe daawuliké yaténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yandéka Jisas déku kundimba némaanmba anga waandén, “Eloi, Eloi, lama sabaktani.” Wani kundi nana kundimba anga wa: “Wuna néma du Got, kamuké méné wunat kuk kwayu?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wunga waandéka wamba tékésén du ras wani kundi vékute anga wandarén, “Ma vékungunu. Wani du dé talimba yatéte Gotna yémba kundi kwayétan du Elaijat wa waakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wunga watake du nak pétépété ye nyambiyap pulak musé ras kéraae nyéngi yakwa wain kulakmba taawundén. Taawundéka gumbés yandéka baangémba maaye Jisas kandénngé kusoré-kwayéndén. Yate anga wandén, “Wayéka ma téte vékwak. Elaija kalmu yaae dat kutndu gaayaké dé kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wunga waténdéka Jisas némaanmba waatake wunga kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas kiyaandéka Gotna kundi bulndakwa néma gaamba lékindarén sémény laplap anjorémba gérike ye andalamba késén. Ye tambék vétik yan. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisas wunga kiyaandéka waariyakwa dunyanna néma du téte véténdén. Vététe anga wandén, “Wani du wan Gotna nyaan wa. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Dakwa ras yaae apakmba pulak téte de waak véténdarén. Talimba Jisas Galilimba déku dunyansale jémbaa yandaka Jisasale yeyé yaayate dat kakému kwayéndarén. Wani dakwa nak wan Makdalamba yaan taakwa Maria wa. Nak wan nak Jems ambét Josepna aasa Maria wa. Nak wan Salome wa. Jisas Galili taakatake yaandéka wani dakwa, késépéri dakwa ras waak dale yaandarén Jerusalemét. Wani dakwa apakmba pulak téte véndarén Jisas kiyaandéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yaap yaré nyaa yaaké yandéka du dakwa wani nyaa musé asé kururétakandarén. Garambu yandéka Arimatea du déku yé Josep wup yamba yandékwe wa. Yate Romna néma du Pailatké yéndén. Dé Israelna néma du nak wa. Dé akwi duna ménimba yéku du wa téndén. Dé waak Got néma du rate du dakwaké yékunmba véké yakwa sapakngé wa kaavéréndén. Dé Jisasna pusaa kéraamuké wa Pailatké yéndén. Ye Pailarét waatakundén, Jisasna pusaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Waatakundéka Pailat yamba vékusékndékwe wa. Jisas dé kiyaak kapuk? Vékusékngapuk yate wandéka waariyakwa dunyanna néma du yaandéka Pailat dat anga waatakundén, “Jisas dé kiyaak kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wunga waatakundéka anga wandén, “Yi.” Wunga wandéka Pailat Josepét anga wandén, “Wani pusaa yénga kéraaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wunga wandéka Josep yéku waama laplap kéraae Jisasna pusaa lepékwe kure gaaye laplapét valambatndén. Valambare kure ye kwaawu nakmba taakandarén. Talimba wani kwaawu jémbaa yakwa dunyan matumba vaae wulaandarén. Josep Jisasna pusaa wani kwaawumba taakatake matu nak varémane ye yaambumba taakatépéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Taakatépéndéka Makdala taakwa Maria ambét Josepna aasa Maria bét Jisas taakandén kwaawumba vétémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judana yaap yaré nyaa yéndéka Makdala taakwa Maria, Jemsna aasa Maria, Salome, de wunga Jisasna pusaamba kutmuké wa yéku yaama yakwa musé kéraandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kéraae Sande ganmbamba nyaa yaalandéka de Jisasna pusaa taakandarén taalat yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yaambumba yététe dekét deku kapmang bulte anga wandarén, “Kwaawumba taakatépéndarén matu kandé varémansatiké ya?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wani matu néma matu wa. Wunga watake ye véndarén kwaawumba taakatépéndarén matu varémansati-takandaka randéka. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vétake kwaawumba wulaae véndarén du nak waama laplap saawuwe yékutuwa sakumba randéka. Vétake vatvat naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Vat naandaka anga wandén, “Wup yaké yambak. A vékusékwutékwa. Takwemimba baangndarén Nasaret du Jisaské waake vémuké wa yaangunén. Dé wa nakapuk taamale waarapén. Dé amba yamba re wa. Ma yaae taakandaka kwaandén taalé véngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bulaa guné ma ye déku dunyan, Pitat waak, anga ma wangunu, ‘Jisas Galilit taale wa yéndékwa. Guné ye talimba wandén pulak dé wamba vékangunéngwa.’ Wunga det ma wangunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dé wunga wandéka vatvat naate vékulaka vékulaka naate kwaawu yaasékatake gwaande yaange yéndarén. Ye néma wup yate wani muséké yamba wandakwe wa.  ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande ganmbamba wa Jisas nakapuk taamale waarapndén. Waarape yaandéka dat taale Makdala taakwa wa vélén. Talimba kutakwa taambak kaayék vétik (7) wa léku mawulémba wulaae téndaka Jisas wandéka lé yaasékatake yaale yaange yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisas taamale waarapndéka dat vétake déku dunyanngé yélén. Yéléka déké sémbéraa yate géraandaka det anga walén, “Jisas wa nakapuk taamale waarapén. Waarapndéka dé wa véwutén.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wunga waléka vékute anga wandarén, “Yamba yé wa. Wan paapu wa yanyénéngwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kukmba Jisasna dunyan vétik Jerusalem yaasékatake yaambumba yémbérén. Yétémbéréka Jisas nak du pulak ye bérké yaandéka wa dé vémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vétake déké vékusékte gaayét waambule ye Jisasna dunyansat anga wambérén, “Dé a vétén.” Wunga wambéréka anga wandarén, “Yamba yé wa. Wan paapu wa yambénéngwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kukmba Jisasna dunyan tambavétik maanmba kaayék nakurak (11) kakému karéndaka Jisas deké yaandén. Yaae det anga wandén, “Taamale waarapwutéka de wuné vétake wa gunat wandarén. Kamuké guné deku kundi yamba vékungunéngwe? Kamuké guné wunéké yamba yékunmba vékulaka-ngunéngwe?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wunga watake det anga wandén, “Guné ma ye képmaana akwi taalémba tékwa akwi du dakwat wuna kundi ma kwayéngunék. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wunéké yékunmba vékulakate wuna kundiké, ‘Yi wan wanana wa,’ naate wuna yémba baptais kéraan du dakwat Got Satanna taambamba kéraandu de dale yékunmba rapéka-kandakwa. Wunéké yékunmba vékulaka-kapuk yakwa du dakwa wa Got wandu lambiyak-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wunéké yékunmba vékulakate wuna kundiké, ‘Yi wan wanana wa,’ naakwa du dakwa talimba vékapuk yandarén apanjémba anga yakandakwa. De wuna yémba wandaru du dakwana mawulémba wulaae tékwa kutakwa yaange yékandakwa. De vékukapuk yandakwa kulé kundimba bulkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","De du dakwat tikwa kaambe kutte wa de yékun tékandakwa. De kapérandi kulak kamunaae, wa yékunmba rakandakwa. De baat yakwa du dakwat taamba kutndaru nakapuk yéput yakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Néman Du Jisas wunga wandéka kukmba Got wandéka Gotna gaayét waare néma du rate déku yékutuwa taambamba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Déku dunyan akwi gaayémba yéte déku kundi kwayéndarén. Kwayéndaka Néman Du dele jémbaa yate det mayé apa kwayéndéka deku kundi vékukwa du dakwa yandarén kulé apanjémba véndarén. Véte anga wandarén, “Deku kundi wan papukundi yamba yé wa. Wan yéku kundi wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Néma du Tiofilus, ménéké ani kundi viyaatakawutékwa. Méné anga vékusék-ménéngwa. Du ras nanale yaréte nakpulak apanjémba wa yandarén. Yandaka nak du wani jémbaa baasnyé ye yandaka vétake wani jémbaa yapékandaka véte wani jémbaaké nanat kundi tiyaandarén. Wunga vékusékte anga waak wa vékusék-ménéngwa. Késépéri du wani jémbaaké saapéte nyéngaamba kundi viyaatakaké mawulé yandarén. Yate de nanat taale wan duna kundi pulak kundi viyaatakandarén. Wunga wa vékusék-ménéngwa. De wunga yandarén pulak, wuné waak wani muké viyaaké mawulé yawutékwa. Méné kurkale vékusékménénngé wuné yékunmba viyaataka-kawutékwa. Késépéri apu wani muséké kurkale vékusékngé watake det waatakuwutén. Waatakwe bulaa vékusékte kurkale vékulakate yékunmba viyaataka-kawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Viyaa-takawutu méné kurkale vékusék-ngaménéngwa. Wani muséké ménat wakwasnyéndarén kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judiana néma du téndén sapak Gotna gaamba jémbaa yakwa du nak téndén. Déku yé Sekaraia. Dé Abiyana kémba wa téndén. Déku taakwa léku yé Elisabet lé Aronna kémba télén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Talimba Aron Gotna gaamba jémbaa yakwa akwi dunyanséna néma du wa téndén. Te kiyaandéka déku gwaal, waaranga, maandéka, bakamu, bakamu, de waak Gotna gaamba jémbaa yakwa du tékésndarén. Bét Néman Du Gotna ménimba yéku musé yakwa du taakwa wa yarémbérén. Bét déku apakundi kurkasale vékulakate wandékwa pulak yate bét kapérandi musé yamba yambérékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lé nyaan yamba kéraalékwe wa. Yaléka bét kapmang yarémbérén. Nyaan yamba wa. Bét aanyapa yan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nak nyaa Sekaraia béré Gotna gaamba jémbaa yakwa duna jémbaa yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yate Gotna gaamba jémbaa yakwa akwi dunyan yan pulak yate deku jémbaaké kundi bulte wandarén, Sekaraia Néman Du Gotna gaamba wulaae yéku yaama yakwa musé tundu yaasnyé waaréndénnge. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wandaka wulaandéka yéku yaama yakwa yaasnyé yaalakwa nyaa de akwi du dakwa kaapamba jaawuwe téte Gorét waandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Waandaka Sekaraia awulamba téte véndén Néman Du Gotna kundi kure gaayakwa du nak yéku yaama yaalakwa yaasnyé tékwa jaambéna yékutuwa sakumba téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Vétake vat naae asa wup yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yandéka Gotna kundi kure gaayakwa du dat anga wandén, “Sekaraia, wup yambak. Got ména kundi wa vékundén. Vékutake wa wandén, ména taakwa Elisabet dunyanngu nyaan kéraalénngé. Kéraalu méné déku yé Jon waakaménéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ména taakwa wani nyaan kéraalu méné késépéri du dakwale guné mawulé tawulé yate dusék takwasék yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wani nyaan aasana biyaamba wayéka randu Gotna Yaamambi déku mawulémba wulaae rakandékwa. Dé wain kulak waangété gu waak katik kaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dé Gotna ménimba néma du wa tékandékwa. Téndu guné déké mawulé tawulé yate dusék takwasék yakangunéngwa. Dé wandu talimba Gorét kuk kwayén késépéri Israelsé deku Néman Du Gotna kundi nakapuk vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dé Gotna yémba kundi kwayétan du Elaija téte apamama yan pulak, dé téte wunga apamama yakandékwa. Yate dé wandu aapambéré deku nyambaléké mawulé tawulé yandaru Gotna kundiké kuk kwayékwa du nak mawulé vékute Gotna kundi vékukwa du dakwa yakwa pulak mawulé tawulé yakandakwa. Dé taale yéte wandu du dakwa yékunmba vékulakate Néman Du yaaké yandékwanngé kaavérékandakwa.” Naandén Gotna kundi kure gaayakwa du. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wunga wandéka Sekaraia dat wandén, “Aané taakwale aanyapa yaténmba yénga pulak ye wani kundiké waké wuté, Yi wan wanana wa?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Naandéka dé Gotna kundi kure gaayakwa du wa wan, “Wuné Gotna kundi kure gaayakwa duna néma du nak anana. Wuna yé Gebriel. Wuné Gotna ménimba téwutékwa. Téwutéka Got wunat wandéka wa déku kundi kure gaayawutén. Dé wandéka wuné yéku kundi ménat waké watake gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bulaa ma véku. Méné wuna kundi yamba vékuménéngwe wa. Bulaa méné kundi bulkapuk yarékaménéngwa. Yaréménu wawutén akwi musé yaakandékwa. Yaandu wani nyaa wuna kundi sékérékndu méné nakapuk kundi bulkaménéngwa.” Wunga watake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia Gotna kundi bulndakwa gaat wulaae bari yaalakapuk yandéka du dakwa kaapamba téte déké kaavététe vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yandaka dé kukmba kaapat yaale dele kundi bulké yapatindén. Yandéka wa vésékndarén. Dé Gotna gaamba yéngan pulak ye nak pulak mu nak véndén wa. Wunga vésékndaka kundi bulké yapatiye dé kundi bulké yate déku taambat male yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dé nyaa ras yare déku jémbaa yasékéyaktake déku gaayét waambule yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ye yaréndéka kukmba déku taakwa Elisabet nyaan ralén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Rate baapmu taambak léku gaamba ralén. Rate walén, “Talimba wuné nyaan kéraakapuk kwawitakwa kwaawutéka du dakwa wunat wasélékndarén. Yandaka wuné wup nékéti yawutén. Bulaa Néman Du Got wunéké mawulé sémbéraa yate wa wunat yékun yandén.” Naalén Elisabet. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nyaan raléka baapmu taambak kaayék nakurak (6) yandéka Got wandéka déku kundi kure gaayakwa du nak déku yé Gebriel Nasarerét gaayandén. Nasaret Galilimba wa téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wani nyaa taakwa nak léku yé Maria wamba yarélén. Talimba lé duwale yamba kwaalékwe wa. Talimba léku aapa aasa Josepna kémale wa kundi gindarén, lé kukmba Josepké yélénngé. Josep talimba tan néma du Devitna kémba wa téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Got wandéka Gebriel gaaye Mariat wandén, “Nyéné yaro? Néman Du Got nyénéké mawulé sémbéraa yate nyénale randékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wunga wandéka wani kundi vékute wani kundiké vékusékngapuk ye wup yate vékulaka vékulaka naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yaléka lat wandén, “Maria, wup yamarék. Got nyénéké mawulé tawulé yandékwa. Yate nyénat yékun yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ma véku. Nyéné nyaan re du nyanngu nyaan nak kéraae déku yé Jisas waakanyénéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dé néma du wa tékandékwa. Apa tapa yapékakwa du Got dat wakandékwa, ‘Méné wuna nyaan wa.’ Wunga watake Néman Du Got wandu déku gwaal waaranga maandéka bakamu bakamu Devit néma du téte Judaséké véténdén pulak, wa dé néma du téte deké vékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dé néma du apapu apapu tékandékwa Israel du dakwaké. Téte deké kurkale vésék naakandékwa apapu apapu.” Naandén Gebriel. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wandéka Maria dat walén, “Yénga pulak nyaan raké wuté, du kumbikapuk yawuténmba?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naaléka wandén, “Gotna Yaamambi nyénéké gaayakandékwa. Gaayandu Got nyénat mayé apa kwayékandékwa. Kwayéndu nyaan re kéraakanyénéngwa. Kéraanyénu wani nyaanngé wakandakwa, ‘Dé wan yéku nyaan wa. Wan Gotna nyaan wa.’ Wunga wakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","“Ani kundi waak ma véku. Got akwi musé yaké apa yandékwa. Nyéna kémna taakwa nak Elisabetké wandarén, ‘Wan nyaan kéraakapuk yakwa taakwa.’ Wunga wandaka aanyapa yaléka Got wandéka nyaan ralékwa. Baapmu taambak kaayék nakurak (6) wakwa lé nyaan raléka.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wunga wandéka Maria wa wan, “Wa vékuwutén. Wuné Néman Du Gotna jémbaa yakwa taakwa a. Wunat waménéngwa pulak Néman Du yakandékwa. Wan yékun wa.” Wunga waléka wani du Gotna gaayét waambule yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria yaré yaré naae musé asé kéraae Judana némbumba tékwa gaayé nakét bari yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ye Sekaraiana gaat wulaae Elisaberale kundi bullén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bulléka Elisabet Mariana kundi vékuléka léku biyaamba ran nyaan génén. Géndéka Gotna Yaamambi Elisabetna mawulémba wulaae ran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wulaae randéka lé némaanmba waate walén, “Got nyénat wa yékun yandén. Yi wan wanana wa. Nyénat yékun yandén musé nak taakwat yékun yandén musat wa taalékéran. Got nyéna biyaamba rakwa nyaanét waak wa yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyéné wuna Néman Duna aasa wa ranyénéngwa. Nyéné wunéké yaanyénén wan yékun wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nyéné yaae wunale kundi bulnyénénga wuné nyéna kundi vékuwutéka wuna biyaamba rakwa nyaan dusék yate géndéka vékuwutén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyéné Néman Du Gotna kundi yékunmba wa vékute wanyénén, ‘Wandén pulak yakandékwa. Yi wan wanana wa.’ Wunga watake nyéné mawulé tawulé yate yékunmba rakanyénéngwa.” Naalén Elisabet. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria wani kundi vékutake gwaaré anga waalén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wuné mawulé tawulé yate Néman Duna yé kavérék-wutékwa. Got wunat yékun yate wuné déku taambamba wa taakandén. Taakandéka wuné déké mawulé tawulé yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Wuné néma taakwa yamba yé wa. Wuné baka taakwa rate déku jémbaa yakwa taakwa wa rawutékwa. Rawutéka dé yéku musé yapékarékwa du rate wunéké wa vékulakandén. Vékulakate dé apa tapa yakwa du rate wunat néma musé wa yandén. Yandénngé bulaa, sérémaa waak, akwi du dakwa wakandakwa, ‘Got Mariat wa yékun yandén. Yi wan wanana wa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gotna kundi yékunmba vékukwa du dakwaké Got mawulé sémbéraa yandékwa. Bulaa, sérémaa waak, wunga pulak yakwa du dakwaké mawulé sémbéraa yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Got apamama yate késépéri apanjémba yandékwa. Dé wandéka deku sépé deku musé aséké vékulakate deku yémba kavérékngwa du dakwa yaange yéndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dé wandéka nak ge nak gemba tan néma du baka du téndakwa. Wandéka baka du dakwa néma du dakwa téndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Musé asé kure yarékapuk yakwa du dakwat yéku musé kwayéndékwa. Asapéri musé asé kure yaran du dakwat wandéka musé asé kapuk ye baka yéndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Talimba Got Abrahamét, nana nak gwaal waaranga maandéka bakamat waak anga wandén, ‘Guné Israel du dakwa, gunéké mawulé sémbéraa yate bulaa, sérémaa waak, gunat yékun yakawutékwa.’ Wunga watake wani kundiké vékulakate déké jémbaa yakwa Israel du dakwat apapu apapu yékun yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria wani gwaaré wunga waatake Elisaberale yarélén. Baapmu kupuk yare léku gaayét waambule yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kukmba Elisabet nyaan kéraala sapak yaandéka nyaan dunyanngu kéraalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kéraaléka Elisabetna kém léku gaayé du dakwa waak vékute lale mawulé tawulé yate dusék takwasék yandarén. Yate wandarén, “Néman Du Got Elisaberét yéku musé wa yandén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nyaa taambak kaayék vétik (7) yéndéka kaayék kupuk yambanmba du dakwa yaae jaawundarén, déku kém du, ‘Gotna du’ naate, wani nyaanna sépé sékumuké. Jaawundaka déku sépé sékwe wani nyaanna yé Sekaraia waaké mawulé yandarén. Sekaraia déku aapana yé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yandaka déku aasa lékét walén, “Yamba yé wa. Déku yé Jon waakanangwa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wunga waléka lat wandarén, “Talimba béna dukémba nak wani yé yamba waandakwe.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wunga watake déku aapa Sekaraiat waatakundarén. Sekaraia wayéka kundi bulkapuk yaréndéka dat taambat yate anga waatakundarén, “Kamu yé waaké nané dat?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wunga wandaka taambat yate det wandén nyéngaa kwayéndarénngé. Wandéka kwayéndaka nyéngaamba viyaatakandén, “Jon déku yé.” Wunga viyaatakandéka de akwi vékulaka vékulaka naan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yandaka déku kundi bari yékun yandéka Sekaraia nakapuk kundi bulndén. Bulte Gotna yé kavérékndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yandéka de wani gaayémba rakésén du dakwa asa wup wa yandarén. Yandaka wani muséké saapé yé yaayandarén, Judiana némbumba tékwa akwi gaayémba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yandaka wani kundi vékwan du dakwa vékulaka naandarén. Néman Du Got wani nyaanét mayé apa wa kwayéndén. Wunga vékute vékulaka vékulaka naate wandarén, “Sérémaa wani nyaan némaan ye yénga pulak du téké dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gotna Yaamambi wani nyaanna aapa Serakaiana mawulémba wulaae randén. Randéka Gotna kundi anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nané Israel du dakwa, nana Néman Du Gotna yé kavérék-nganangwa. Nanat yékun yaké wa gaayandén. Gaaye dé nanat Satanna taambamba kéraakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dé wa wandén, apamama yate nanat yékun yana du nanéké yaandénngé. Gotna jémbaa wani yatan du Devitna kémba wa yaalakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Talimba Got wandéka déku yémba kundi kwayétan du ani kundi wandarén, “Nanéké kalik yakwa du nana maama waak nanat viyaandékngé mawulé yandaru Got kéraakandékwa nané déku taambamba.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Got talimba nana gwaal waaranga maandéka bakamat anga wandén, “Wuné gunéké mawulé sémbéraa yakawutékwa. Yate gunat wuné yékun yakawutékwa. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wani kundi Got nana gwaal maandéka waaranga bakamu Abrahamét wa wandén. Wandén pulak ye dé nanat yékun yate nana maamana taambamba nané kéraakandékwa. Kéraandu déké nané yéku jémbaa yate déké katik wup yaké nané. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yate nané ani képmaamba yatéte akwi nyaa déku kundi kurkasale vékute yéku musé male yakanangwa. Yate déku ménimba yékunmba yatékanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wani kundi watake Sekaraia déku nyaanét anga wandén: Méné wuna nyaan, sérémaa du dakwa ménéké wakandakwa, “Néman Du Gotna yémba kundi kwayékwa du wa.” Naakandakwa. Méné taale yéte Néman Duna yaambu kutlaakét yéménu wunga wakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Méné wunga yate déku du dakwat wakaménéngwa, de yan kapérandi musé yasnyéputiye de kéraae déku taambamba taakaké yandékwanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Asapéri du dakwa kapérandi musé yate de ganngungamba téndakwa. Te sérémaa lambiyak-ngandakwa. Nana Néman Du Got nanéké mawulé sémbéraa yate wa wandén, wani wandén du déku gaayémba re ani képmaat nanéké gaayandénngé. Gaaye nané kéraae yéku yaambumba taakakandékwa, nané nakurakmawulé yate Gorale yékunmba rananénngé. Wunga wandén Sekaraia. ");
INSERT INTO abt_wosera_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kukmba wani nyaan Jon némaan yandéka déku mawulé yékunmba tén. Dé du yarékapuk talimba yaréndén. Yaréte Israel du dakwat Gotna kundi wanda sapakngé kaavéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wani kwaaré Romna néma du déku yé Sisar Ogastus genge gaayéna képmaamba tékwa du dakwana néma du téte wandén, déku du déku képmaamba tékwa akwi du dakwana yé viyaawuré-ndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Talimba akwi du dakwana yé yamba viyaatakandakwe wa. Wani jémbaa taale baasnyé yandaka Kwirinius dé Romna néma duké jémbaa yate Siria provinsmba néma du téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Akwi du dakwa deku gwalepanget yéndarén, deku yé viyaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep Israelna néma du Devitna kémba wa téndén. Devitna gwalepange Betlehem wa. Betlehem Judia distrikmba tékwa. Josep Galili distrikmba tékwa gaayé Nasaret taakatake déku kémna gwalepange Betlehemét yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bét déku aasa aapa wakandéng-ndarén taakwale yémbérén Betlehemét, bérku yé viyaatakaké. Wani taakwana yé Maria wa. Lé nyaan biyaa ralén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Némaamba du dakwa wulaandaka saayénga vékulékndéka bét ye saambake taaléké yapatimbérén. Bét taalé yamba yé wa. Yandéka lé nyaan kéraaké yépmaa vékwe bulmakau kwaandakwa gaat wulaalén. Wulaae léku léwinyan wamba kéraalén. Kéraae laplapét saaplén. Saape bulmakau kakwa mikwamba waambitakaléka kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wani gaan du ras nak taalémba deku sipsipké kaave véréndarén. Wani taalé Betlehem tékwanmba téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kaave véréndaka Néman Du Gotna kundi kure gaayakwa du nak Gotna gaayémba gaaye téndéka néma yaa pulak kalkal naae yaae det kaaléndén. Kaaléndéka vétake asa wup wa yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yandaka Gotna gaayémba gaayakwa du det wandén, “Guné wup yaké yamarékate. Ma véku. Yéku kundi wakawutékwa. Akwi du taakwa ani kundi vékute mawulé tawulé yate dusék takwasék yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bulaa taakwa nak nyaan kéraalén wa Devitna gaayémba. Wani kéraalén nyaan guné Satanna taambamba kéraae gunat yékun yaké yakwa du wa. Wani Got wan du Krais. Wani nana Néman Du. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bulaa ye vékangunéngwa wani nyaan. Aasa laplapét giye bulmakau kakému kan mikwamba waambitakaléka wa kwaandékwa. Ye wawutén pulak vétake vékusék-ngangunéngwa wuna yéku kundiké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wandéka Gotna kundi kure gaayakwa dunyansé rékaamba bari gaaye wani duwale téndarén. Téte gwaaré anga waandarén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Got anjoré déku gaayémba rate yékun wa yandén. Déku yé kavérék-nganangwa. Got mawulé tawulé yandékwa du dakwa yénga yékunmba téndaru ani képmaamba. Wunga waandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wani dunyan wunga gwaaré waatake de yaasékatake waambule waaréndarén Gotna gaayét. Waaréndaka sipsipké kaavéran dunyansé deku kapmang bulte wandarén, “Ma yékwak Betlehemét. Ye Néman Du wan nyaanngé waake vékanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wunga watake bari yéndarén. Ye gaayémba saambake Maria ambét Josep, wani nyaan waak véndarén. Nyaan bulmakau kakému kan mikwamba kwaan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nyaan vétake Gotna kundi kure gaayakwa du wani nyaanngé wandén pulak saapéndarén du dakwat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wandaka vékute akwi vatvat naate wandarén, “Yéki. Wan yénga pulak musé dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wunga wandaka Maria sipsipké kaavéran duna kundi vékute léku mawulémba vékulakarélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsipké kaavéran dunyansé waambule yéte Gotna yé kavérékte déké mawulé tawulé yandarén. Yate wandarén, “Néman Du Got nanat kundi wandéka vékutake nané wani musé akwi wa vénanén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nyaa taambak kaayék vétik (7) yéndéka kaayék kupuk yambanmba, “Gotna du” naate wani nyaanna sépé sékundarén. Sékwe déku yé Jisas waandarén. Talimba Maria nyaan rakapuk yalén sapak Gotna kundi kure gaayakwa du wa wani yé lat wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria nyaan kéraae Moses kwayén apakundi wakwa pulak yaké mawulé yalén, léku sépé Gotna ménimba nakapuk yékun yandénngé. Yatake nakurak baapmu pulak yéndéka Josepale Jerusalemét yémbérén. Néman Du Gorét kwayéké watake Jisas kure yémbérén Jerusalemét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Néman Du Gotna apakundi nak anga wandékwa. “Du dakwa kéraandara akwi léwinyan Gorké ma kwayéndarék.” Naandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Néman Du Gotna apakundi nak waak anga wandékwa, “Du taakwa bérku dunyanngu nyaan Gorké kwayéte bét déké nyaamiyo vétik viyaae ma kwayémbérék. Nyaamiyot kwayékapuk ye nyaamiyo pulak apit ma kwayémbérék.” Naandékwa. Maria ambét Josep wani kundi wandékwa pulak wunga yaké watake yémbérén Jerusalemét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wani sapak du nak déku yé Simeon dé Jerusalemmba yaréndén. Dé yéku yapaté male yate dé Gorale kundi bulkwa du wa yaréndén. Got Israel du dakwat yékun yanda sapakngé wa kaavéréndén. Gotna Yaamambi déku mawulémba wa wulaae ran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Talimba Gotna Yaamambi Simeonét anga wandén, “Méné bari kiyaakapuk ye rate vékaménéngwa Néman Du Got wani wan du Krais.” Wunga wandéka dé wani muséké kaavéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gotna Yaamambi déku mawulémba wulaae rate wandéka Gotna kundi bulndakwa néma gaat wulaandén. Wulaandéka Jisasna aasa aapa bét Jisas kure wulaambérén, Gotna apakundi wandékwa pulak léwinyanét yaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kure wulaambéréka Simeon wani nyaan kéraae déku taambamba kure téte, Gotna yé kavérékte anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Néman Du, talimba waménén kundi bulaa a sékérékndékwa. Wa véwutén bulaa nanat yékun ye nané kéraae Gotna taambamba taakaké yakwa du. Bulaa wuné ména jémbaa yakwa du wunat waménu mawulé tawulé ye kiyaakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ani duwat wa waménén, dé wani jémbaa yandu akwi taalémba tékwa du dakwa véndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gaan yaa vérékte kaalékwa pulak ani nyaan nak gaayé du dakwana mawulémba kaalékandékwa. Kaaléndu de Gorké yékunmba vékulaka-kandakwa. Vékulakate Israel du dakwa deku yé kavérék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasna aasa aapa Simeon wan wani kundiké vékulaka vékulaka naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Naambéréka Simeon Gorét waatakundén, bérét yékun yandénngé. Waatakutake wani nyaanna aasa Mariat anga wandén: Ma véku. Got wa wandén, ani du jémbaa yandu némaamba Israelsé dat kuk kwayéndaru, némaamba Israelsé déku kundi vékukandakwa. Dé Gotna jémbaa yandu némaamba du dakwa dat kuk kwayékandakwa. Kuk kwayéndaru ras du dakwa kuk kwayén du dakwana mawulé vékusék-ngandakwa. Du ras dat kapérandi musé yandaru véte apakangél vékute bérukanyénéngwa. Naandén Simeon. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Aanyapa taakwa nak léku yé Ana, Gotna kundi bulndakwa néma gaamba ralén. Lé Fanuelna takwanyan wa. Aserna kémba ralén. Lé Gotna yémba kundi kwayékwa taakwa wa yarélén. Talimba du kumbilén. Kumbiye raléka kaa taambak kaayék vétik (7) yéndéka léku du kiyaan. Kiyaandéka kaa késépéri (84) wa kwawitakwa kwaalén. Kwaate Gotna kundi bulndakwa gaamba yarélén. Yaréte wani gaa yamba yaasékalékwe. Wunga yate gaan nyaa Gorale kundi bullén. Nakurak apu nakurak apu wa kakémuké yaakére Gorale kundi bullén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon kundi wasékéyakndéka Josep ambét Maria wayéka wunga témbéréka lé yaae wani nyaanét véte Gotna yé kavéréklén. Kavérékte Jerusalemmba tan du dakwat walén, wani nyaanngé. Talimba Got wa wandén, du nak yaae de kéraae déku taambamba taakandénngé. Talimba wandén kundi sékérékndénngé Ana wani sapakngé kaavérékwa du dakwat walén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Néman Du Gotna apakundi wandékwa pulak yasékéyaktake Jisasna aasa aapa dé Nasarerét nakapuk waambule kure yémbérén. Nasaret Galili distrikmba tékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wani nyaan wa némaan ye mayé apa kéraandén. Yandéka déku mawulé yékun yandéka késépéri musé aséké vékutépak naandén. Got déké kurkale véte dat yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Akwi kaa Jisasna aasa aapa Jerusalemét yémbérén Pasova waandakwa sapakna kakému kaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasna kaa tambavétik maanmba kaayék vétik (12) yandéka bét dé kéraae kure sékét yéndarén, akwi kaa yambérén pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kukmba Pasova waandakwa sapakna kakému kandarén nyaa késndéka de deku gaayét yéndakwa yaambumba waambule yén. Yéndaka Jisas Jerusalemmba yarépékandén. Yaréndéka déku aasa aapa yamba vékumbérékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bét bérku mawuléké anga wambérén, “Jisas aana kémale wa yéndékwa.” Wunga watake bét nyaa nakurak yaambumba yémbérén. Ye garambu yaap rate yaambumba yén bérku kém bérku du dakwat waatakumbérén déké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Waatakutake dé vékapuk ye déké waakmbérén. Waake waake waakpatimbérén. Waakpatiye Jerusalemét waambule yémbérén, déké waake véké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ye nyaa kupuk déké waakmbérén. Waake kukmba vémbérén dé Gotna kundi bulndakwa néma gaamba randéka. Dé nak duwat Gotna kundiké yakwasnyékwa néma dunyansale rate deku kundi vékute det késpulak nakpulak muséké waatakundén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yate deku kundi vékusék naate sékmba sékmba we kaatandéka déku kundi vékuran dunyan vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Déku aasa aapa dat véte vékulaka vékulaka naambérén. Yate déku aasa dat walén, “Wuna nyaan, kamuké méné aanat wunga yo? Aané ména aapale wup yate ménéké akwi gaayémba waaktén.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wunga waléka bérét wandén, “Kamuké béné waakék? Wuné wuna aapana gaamba rawutékwa. Wan yékun wa. Yénga béné amba rawutékwanngé yamba vékusék-mbénéngwe?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wunga wandéka bét wani kundina waambu yamba kurkale vékusék-mbérékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yambéréka dé bérale nakapuk waambule ye Nasaretmba saambakndarén. Saambake yaréte dé bérku kundi vékute wambérén pulak yandén. Yandéka déku aasa wani muséké léku mawulémba taake yaréte vékulaka vékulaka naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas némaan yandéka déku mawulé vékuték vékuték naandéka késépéri musé aséké vékusék naandén. Got, du dakwa waak, de akwi déké mawulé tawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taiberius Rommba néma du asapéri (14) kaa téndéka nak kaa Got Jonét kundi kwayéndén. Wani sapak Taiberius Rommba néma du tépékaandéka Pontius Pailat Judia distrikna néma du téndén. Wani sapak Herot Galili distrikmba tékwa du dakwaké néma du téndéka, déku aanyé Filip Ituria distrikmba tékwa du dakwaké, Trakonitismba tékwa du dakwaké waak wa néma du téndéka Lisanias Abilene distrikmba tékwa du dakwaké wa néma du téndén. Yandaka Anas ambét Kaiafas Gotna gaamba jémbaa yakwa akwi dunyanna néma du wa témbérén. Wani sapak Sekaraiana nyaan Jon, dé du yarékapuk taalémba yaréndéka Got dat wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wandéka Jon déku kundi vékutake Jordan kaambélé yékwanmba yeyé yaayandén. Yeyé yaayatéte du dakwat anga wandén, “Guné yangunén kapérandi musé asé yaasékangunu wuné Gotna yémba gunat baptais kwayékawutékwa. Guné Gotna yémba wunga baptais kéraangunu guna kapérandi mawulé yasnyéputi-kandékwa.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon wunga yandénngé talimba Gotna yémba kundi kwayétan du déku yé Aisaia Gotna nyéngaamba anga viyaatakandén: Du nak a waakwa du yarékapuk taalémba. Waate anga wandékwa, “Néman Duna yaambu ma kutngunék. Kutngunu yaambu yékunmba kwaakandékwa déké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Akwi jaangu képmaat ma vaae yambapngunék, yaambu jaangu daawulikapuk yandénngé. Akwi néma némbu akwi makal némbu waak ma kurkale vaangunék, yaambu wutép wurékapuk yandénngé. Rangwa yan yaambu ma kutngunu yaambu kayéndéng yéndék. Matu rakwa yaambu matu ma kéraasolangunu yaambu yékunmba randék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wunga yangunu akwi du dakwa vékandakwa det yékun yandénngé Got wani wan du.” Wani gwaaménja kundi talimba Aisaia wa viyaatakan. Du dakwana mawulé yékun téndu, de Jisas yaamuké yékunmba vékulaka-réndarénngé, wa wani kundi viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Du dakwana mawulé yékun téndénngé Jon det kundi kwayéndén. Késépéri du dakwa Jon det baptais kwayéndénngé yaandaka det anga wandén, “Guné kapére mawulé yakwa du dakwa wa. Got néma kot vékute néma du randa nyaa a yaandékwa. Wani nyaa Got du dakwa yandarén kapéremuséké rakarka yakandékwa. Wani nyaaké vékulakate guné, dunyansé yaawi tundaka yaange yékwa kaambe pulak, wa wunéké yaange a yaangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wunéké yaambak. Guné taale yangunén kapérandi musé yaasékatake yéku musé male ma yangunék. Yangunu nak du dakwa véte wakandakwa, ‘De kapérandi musé yaasékatake bulaa yéku musé male wa yandakwa.’ Naakandakwa. Guné guna mawulémba anga wangunéngwa, ‘Nané Abrahamna gwaal waaranga maandéka bakamu a ténangwa. Dé Gotna ménimba yéku musé yakwa du téndén pulak nané waak Gotna ménimba yéku musé yakwa du dakwa a ténangwa.’ Wunga wate paapu wa yangunéngwa. Guné yéku musé yamba yangunéngwe wa. Got mawulé yamunaae wandu ani matu du saakwe Abrahamna gwaal waaranga maandéka bakamu tékandakwa. Abrahamna gwaal waaranga maandéka bakamu téngunéngwanngé Got yamba vékulakandékwe wa. Yangunéngwa muséké wa vékulakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Gwaaménja kundi nak wawutékwa. Du nak sék vaakukapuk yakwa miyéké vékulakate kwandang kéraae wani miyé vélékandékwa. Véle yaamba tukandékwa. Bulaa wani gwaaménja kundiké ma vékulaka. Bulaa Got déku kundi vékukapuk yakwa du dakwat wani yandarén kapérandi musé yakata-kandékwa. Yakatandu de yaa apapu yaanpékatékwa taalat yékandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon wunga wandéka de vékute wup yate dat waatakundarén, “Nané kamu yaké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wunga wandaka det wandén, “Guné laplap vétik kure re guné laplap rakapuk du dakwat ma kwayéngunu. Guné kakému ras taakatake guné kakému kapuk yan du dakwat ma kwayéngunu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wani kundi wandéka de takis kéraakwa du ras déké yaandarén, det baptais kwayéndénngé. Yaae dat wandarén, “Néma du, méné Gorké nanat wakwasnyé-ménéngwa. Nané kamu yaké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wunga wandaka det wandén, “Guné Romna gavman gunat wan pulak male takis ma kéraangunu. Yate yéwaa kusonaae kéraaké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wani kundi wandéka waariyakwa du ras dat waatakundarén, “Wa nané yénga pulak dé? Nané kamu yaké nané?” Wunga wandaka det wandén, “Guné du dakwat mayé apa yate deku yéwaa baka kéraaké yambak. Guné du dakwat papukundi wate deku yéwaa kéraaké yamarék. Guné jémbaa ye wani kéraangunén yéwaaké mawulé ma yangunu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon wunga yate wunga wandéka akwi du dakwa vékulaka vékulaka naate deku mawulémba wandarén, “Jon wan nanat yékun yandénngé Got wan du Krais dé wani dé, kapuk dé yénga pulak du dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wunga vékulakandaka Jon det anga wandén, “Wuné gunat Gotna yémba baptais kwayékawutékwa. Wuna kukmba yaaké yakwa du wan néma du wa. Wuné baka du a téwutékwa. Déku mayé apa wa wuna mayé apat taalékéran. Baka du téwutékwanmba, yénga pulak ye déku jémbaa yaké wuté? Dé néma du randéka wuné déké jémbaa yaké yapatiwutékwa, wuné baka du téwutékwanmba. Wuna kukmba yaaké yakwa du Gotna Yaamambi gunat kwayékandékwa. Guna kapérandi musé kéraae yaamba tukandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dunyansé wit géle yéku wit sék kutpévéte gérindakwa. Gérisotake yéku wit sék gaamba taakate apa vaanjatindakwa. Yandakwa pulak wuna kukmba yaaké yakwa du wunga yakandékwa. Dé déku du dakwa kéraae kure ye déku gaayémba taakatake, kapérandi musé yan du dakwa kéraae yaanpékatékwa yaamba vaanjanda-kandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon wani kundi du dakwat kwayéte Gotna kundi ras waak kwayéndén, deku mawulé yékun téndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galilimba tékwa du dakwana néma du Herot déku aanyé yaréndéka dé déku taakwa kéraandén. Léku yé Herodias. Késépéri kapérandi musé ras waak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yandéka Jon dat waarundéka Herot dé ani kapérandi musé waak yandén. Dé wandéka déku dunyansé Jon kalapusmba taakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Talimba Herot Jonét kalapusmba taakandarénngé wakapuk yandéka, wani sapak Jon déké yaan akwi du dakwat Gotna yémba baptais kwayéndén. Kwayétake Jisasét waak Gotna yémba baptais kwayéndén. Kwayéndéka téte Gorale kundi bulténdéka nyét kepukandéka Gotna Yaamambi nyaamiyo pulak ye Jisaské gaayandén. Gaayandéka kundi nak Gotna gaayémba anga wan, “Méné wuna nyaan wa. Ménéké néma mawulé wa yawutékwa. Ménéké wuna mawulé yékun yandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisasna kaa 30 yandéka déku jémbaa baasnyé yandén. Du dakwa déké anga wandarén, “Wan Josepna nyaan wa.” Naandarén. Josep wan Helina nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wan Matatna nyaan wa. Matat wan Livaina nyaan wa. Livai wan Melkina nyaan wa. Melki wan Janaina nyaan wa. Janai wan Josepna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep wan Matatiasna nyaan wa. Matatias wan Amosna nyaan wa. Amos wan Nahumna nyaan wa. Nahum wan Eslina nyaan wa. Esli wan Nagaina nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai wan Matna nyaan wa. Mat wan Matatiasna nyaan wa. Matatias wan Semenna nyaan wa. Semen wan Josekna nyaan wa. Josek wan Jodana nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda wan Joananna nyaan wa. Joanan wan Resana nyaan wa. Resa wan Serubabelna nyaan wa. Serubabel wan Sealtielna nyaan wa. Sealtiel wan Nerina nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri wan Melkina nyaan wa. Melki wan Adina nyaan wa. Adi wan Kosamna nyaan wa. Kosam wan Elmadamna nyaan wa. Elmadam wan Erna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wan Josuana nyaan wa. Josua wan Elieserna nyaan wa. Elieser wan Jorimna nyaan wa. Jorim wan Matatna nyaan wa. Matat wan Livaina nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai wan Simeonna nyaan wa. Simeon wan Judana nyaan wa. Juda wan Josepna nyaan wa. Josep wan Jonamna nyaan wa. Jonam wan Eliakimna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim wan Meleana nyaan wa. Melea wan Menana nyaan wa. Mena wan Matatana nyaan wa. Matata wan Natanna nyaan wa. Natan wan Devitna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit wan Jesina nyaan wa. Jesi wan Obetna nyaan wa. Obet wan Boasna nyaan wa. Boas wan Salmonna nyaan wa. Salmon wan Nasonna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason wan Aminadapna nyaan wa. Aminadap wan Atminna nyaan wa. Atmin wan Arnina nyaan wa. Arni wan Hesronna nyaan wa. Hesron wan Peresna nyaan wa. Peres wan Judana nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda wan Jekopna nyaan wa. Jekop wan Aisakna nyaan wa. Aisak wan Abrahamna nyaan wa. Abraham wan Terana nyaan wa. Tera wan Nahorna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor wan Serukna nyaan wa. Seruk wan Reuna nyaan wa. Reu wan Pelekna nyaan wa. Pelek wan Eberna nyaan wa. Eber wan Selana nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela wan Kainanna nyaan wa. Kainan wan Arpaksatna nyaan wa. Arpaksat wan Siemna nyaan wa. Siem wan Noana nyaan wa. Noa wan Lamekna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wan Metuselana nyaan wa. Metusela wan Enokna nyaan wa. Enok wan Jaretna nyaan wa. Jaret wan Mahalalelna nyaan wa. Mahalalel wan Kenanna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wan Enosna nyaan wa. Enos wan Setna nyaan wa. Set wan Adamna nyaan wa. Adam wan Gotna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gotna Yaamambi Jisasna mawulémba wulaae rate apamama yandéka dé Jordan kaambélé yaasékatake yéndén. Yéndéka Gotna Yaamambi wa dat kure yén du yarékapuk taalat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kure yéndéka dé wani taalémba nyaa dumi vétik (40) yaréndéka Satan déku mawulé yakwe véndén. Wani sapak dé kakému yamba kandékwe. Ye wani nyaa yéndéka kukmba wa Jisasét kaandé yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yandéka Satan dat anga wandén, “Méné anga waménéngwa, ‘Wuné Gotna nyaan a.’ Wunga wate bulaa wani muséké wunat ma wakwasnyéménu. Ma waménu de ani matu waalakwe kakému yandaru. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yandaru wuné ve wakawutékwa, méné Gotna nyaan wa.” Wunga wandéka wandén, “Yamba wa. Wani muséké ani kundi Gotna nyéngaamba wa kwaakwa: Du dakwa kakémuké male vékulakate de kurkale katik téké daré. Wani kundi vékute matu kakému yandénngé katik waké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jisas wani kundi wandéka Satan dat kéraae kure waaréndén. Kure waare dat ani képmaamba tékéskwa akwi gaayé bari wakwasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wakwasnyéte dat anga wandén, “Got wandéka ani képmaamba tékwa akwi gaayé, wani gaayémba yarékwa akwi du dakwa akwi salmu walmu waak wan wuna taambamba wa randakwa. Wuné wani musé du nakét kwayéké mawulé ye wa dat kwayékawutékwa, dé deké néma du randénngé. Wuné wani musé ménat kwayékawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Méné kwaati séte wunéké waandé daate wuna yé kavérékménu, wuné ménat kwayékawutékwa. Kwayéwutu méné deku néma du rakaménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wunga wandéka wandén, “Yamba wa. Gotna nyéngaamba ani kundi wa kwaakwa: Ména néma du dé Got nakurak wa. Méné déké waandé daate dat ma waataku. Déku yé male ma kavérék. Wani kundi vékute wuné ménéké katik waandé daaké wuté. Yate ména yé katik kavérékngé wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas wani kundi wandéka Satan dat kéraae kure yéndén Jerusalemét. Kure ye waare dé Gotna kundi bulndakwa néma gaana saambunmba taakandén. Taakatake dat anga wandén, “Méné anga waménéngwa, ‘Wuné Gotna nyaan a.’ Wunga wate méné ma késéke daawuli. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Wani muséké ani kundi wa kwaakwa Gotna nyéngaamba: Got déku kundi kure gaayakwa duwat wandu de ménéké yékunmba vékandakwa. Méné deku taambamba yékunmba rakaménéngwa. Ye ména maan matumba katik viyaaké méné. Méné wani kundi vékute késéke daawuliye yékunmba raménu akwi du dakwa vétake anga wakandakwa. Méné Gotna nyaan wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wunga wandéka wandén, “Yamba wa. Wani muséké ani kundi Gotna nyéngaamba wa kwaakwa: Got nakurak wa ména Néman Du. Dé apamama yate ménat yékun yandu méné waangété du yakwa pulak katik yaké méné. Wani kundi vékute wuné katik késéke daawuliké wuté.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wunga wandéka Satan nak jémbaa yandénngé Jisasét yamba wandékwe wa. Ye dat yaasékate anga wandén, “Nak nyaa waambule yaakawutékwa. Nakapuk kalmu wuna kundi vékuké dé?” Naatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gotna Yaamambi Jisasna mawulémba rate mayé apa kwayéndéka Galilit nakapuk waambule yéndén. Yéndéka wani taalémba tékwa akwi gaayémba du dakwa déké bul yé yaayandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dé Gotna kundi bulndakwa gaamba wulaate du dakwat Gotna kundi kwayéndén. Kwayéndéka vékute de akwi Jisasna yé kavérékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas Nasarerét yéndén. Talimba makalnyan yare aasa aapale wani gaayét yéndén. Ye yare némaan ye wani gaayé yaasékatake yéndén. Wani sapak Nasarerét waambule ye wani gaayémba yaréndén. Yare yaap yaré nyaa Gotna kundi bulndakwa gaat wulaandén. Akwi yaap yaré nyaa yandén pulak ye Gotna kundi bulndakwa gaat wulaandén. Wulaae re Gotna kundi nyéngaamba véte waké waarape téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Téndéka Gotna yémba talimba kundi kwayétan du Aisaia viyaan nyéngaa kure yaae dat kwayéndarén. Kwayéndaka lékwe véndén ani kundi viyaatakandéka kwaandéka. Vétake det anga wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Néman Du Got wunat wa wandén, wuné déku kundi musé asé kure rakapuk du dakwat kwayéwuténngé. Watake déku Yaamambi tiyaandéka wuna mawulémba a wulaae rakwa. Got wunat wa wandén, wuné yaae ani kundi det kwayéwuténngé. De kalapus pulakmba kwaakwa du dakwa bulaa yékun tékandakwa. De ménimbo pulak yan du dakwa bulaa kurkale vékandakwa. Kaangél kurkwa du dakwa bulaa nakapuk katik kaangél kurké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bulaa Néman Du Got du dakwat yékun yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas wunga watake wani nyéngaa nakapuk valambare wani gaaké séngitékwa duwat kwayéndén. Kwayétake randén, wani kundi det yakwasnyéké. Randéka wani gaamba rakésén du dakwa akwi dat male véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Véndaka det anga wandén, “Bulaa Gotna nyéngaamba kwaakwa kundi wa sékérékén. Yandéka wa véngunén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Naandéka de wani kundi vékutake vatvat naate déku kundiké vékulaka vékulaka naan. Yate wandarén, “Yéki. Wa yéku kundi wa wandékwa.” Naatake anga wandarén, “Wani du wan Josepna nyaan wa. Yénga pulak ye dé wani yéku kundi wato?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wunga wandaka Jisas det anga wandén, “Kalmu guné apapu wangunéngwa kundi wunat anga waké guné? ‘Dokta, ménékét ména sépé ma yékun yaménék.’ Wunga wate kalmu anga waak waké guné? ‘Kaperneammba yaménén jémbaa wa vénanén. Yaménén pulak ménékét ména gwalepangemba yatéte ma yaménu.’ Naanguna kundi wa waambule anga wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Guné a wawutékwa. Gotna yémba kundi kwayékwa dunyan deku gwalepangemba yatéte kundi kwayéndaka deku gaayémba tékwa du dakwa deku kundi vékumuké kalik yandakwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ma véku. Talimba Gotna yémba kundi kwayétan du Elaija yaténdéka Israelmba du kiyaan kwawitakwa asa wa yarékésén. Wani sapak yaténdaka kaa kupuk baapmu taambak kaayék nakurak (6) maas yamba viyaae. Yandéka akwi gaayémba néma kaandé yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yandéka Got Elaijat yamba wandékwe, dé ye Israelmba yarékéskwa du kiyaan kwawitakwasat yékun yandénngé. Got Elaijat wandén, dé ye nak taalémba yarékwa kwawitakwat nak yékun yandénngé. Lé Saidonmba tékwa gaayé Sarefatmba yarélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Ani kundi waak ma véku. Gotna yémba kundi kwayékwa du nak waak déku yé Elisa, dé yaréndéka lepro yan dunyan asa wa yarékésén Israelmba. Yaréndaka Elisa det yamba kururéndékwe. Nakurak duwat male kururéndén. Wani du Siria du wa, déku yé Naman. Wan Israel du yamba yé wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gotna kundi bulndakwa gaamba ran du dakwa Jisas wan kundi vékutake anga wandarén, “Jisas wunga wate wa nanat waarundén wa.” Wunga wate asa rakarka wa yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ye waarape Jisasét kulkiye gaayé yaasékatake kaapat témbét-sangwandéndarén. Deku gaayé anjoré némbu nakmba tén. Téndéka Jisas témbére dé wani némbuna jaangwat kure yéndarén. Dé wani jaangumba vaanjandaké watake kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kure ye wunga yaké yapatindarén. Dé deku nyéndémba ye gwaande de yaasékatake dé wa yén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas Kaperneamét daawulindén. Wani gaayé Galili distrikmba tékwa. Daawuliye saambake yaréndén. Yare yaap yaré nyaa Gotna kundi bulndakwa gaamba wulaae du dakwat Gotna kundiké yakwasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mayé apale wa det Gotna kundi kwayéndén. Kwayéndéka vékute vatvat naate vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yaréndaka kutakwa kulure kure yatékwa du nak wani gaamba randén. Randéka dat kure yatékwa kutakwa némaanmba waalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Waate anga walén, “Méné Nasaret du Jisas, nanat kamu yaké méné yaak? Nanat yaavan kurké méné yaak kapuk? Méné a vésékwutékwa. Méné Gotna yéku laku du wa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wunga waléka lat wandén, “Nyéné kundi bulké yambak. Wani du yaasékatake ma yaale yaange yényénu.” Naandéka wani du taakusorakléka képmaamba vaakétndén. Vaakétndéka dat yaavan kurkapuk yaasékatake yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yéléka akwi du dakwa vétake vatvat naate dekét deku kapmang bulte wandarén, “Yéki. Ani du yénga kundi dé wo? Dé du dakwat kulure kure yatékwa kutakwat wandéka wani du dakwa yaasékate yaange yéndakwa. Néma du rate apamama yakwa du wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wunga wandaka wani taalémba tékéskwa akwi gaayémba Jisaské kundi saapé yé yaayandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas waarape Gotna kundi bulndakwa gaa taakatake Saimonna gaat wulaandén. Saimonna naakumo néma baat yandéka kwaalén. Kwaaléka Jisasét wandarén, dé yaae lé kururéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wandaka wulaae lé kwaanale téte wandéka wani baat késén. Yandéka wani taakwa bari waarape kakému kéraae det kwayélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","41","Garambu nyaa daawulindéka yaap yaré nyaa yéndéka baat yakwa du dakwa nyambalé, sépémaalé maan taamba kapére yan du dakwa nyambalé, kutakwa kulure kure yatékwa du dakwa nyambalé waak wa Jisaské kure yéndarén. Kure yéndaka dé déku taamba wani du dakwa nyambalésémba kutndéka de nakapuk yékun yandarén. Yandaka késépéri du dakwat kulure kure yatan kutakwasat wandéka yaalandarén. Yaale yéte dat wandarén, “Méné Gotna nyaan wa.” Wunga wate wa vékusékndarén. Dé Got wan du Krais wa. Wunga vékusékndaka det némaanmba wandén, “Wani muséké saapéké yambak.” Wandéka yaange yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ganmbamba waarape wani gaayé yaasékatake du dakwa yarékapuk taalat yéndén, Gorale kundi bulké. Yéndéka du dakwa déké waake yéndarén. Ye dé ve wandarén, “Méné nanale yaré. Nak gaayét yéké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naandaka det anga wandén, “Wuné nak gaayét ye Gotna kundi kwayékawutékwa, Got néma du rate du dakwaké véké yandékwanngé. Got wani jémbaa yawuténngé wa wandéka yaawutén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naatake Galili distrik yaasékatake ye Judia distrikmba saawe yéte Gotna kundi bulndakwa gaamba du dakwat Gotna kundi kwayéténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nak nyaa Jisas Genesaret néma gu kwaawuna wutépmba téndéka asa du dakwa wa yaae dale jaawuwe téndarén, Gotna kundi vékuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas te véndén bot vétik néma gu kwaawuna wutépmba rambéréka. Gukwami wurékwa dunyan de takamba wa bot yaasékatake aaswut yakwasnyé-réndarén. Yakwasnyé-réndaka véndén deku bot rambéréka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Vétake bot nakmba waaréndén. Wani bot wa Saimonna bot wa. Waare rate Saimonét wandén, dé bot valuwindu ayélap yépulak naandénngé. Wandéka valuwindéka ye awulaka botmba rate wutépmba tékésén du dakwat Gotna kundi yakwasnyéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kundi bulsékéyaktake Saimonét anga wandén, “Bot ma nyéndé néma gu kwaawut kure wulaae méné ména dunyansale guné aaswut vaanjande guné gukwami wuréké ya.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wunga wandéka anga wandén, “Néman Du, gaan nané néma jémbaa wa yananén. Ye gukwami yamba wurénangwe wa. Waménéngwanngé vékwe wa aaswut nakapuk vaanjanda-kawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wunga watake aaswut vaanjande asa gukwami wa wuréndarén. Wuréndaka aaswut tékngé tékngé yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yandéka nak botmba rakésén dunyanét waandarén, de yaae kutndarénngé. Waandaka yaandaka bot vétikmba kéraasangwandé-ndarén kwaami. Yandaka bot véréti gumba daawuliké yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Yambéréka vétake gukwami némaamba wuréndarénngé vékulakate Saimon Pita, dale botmba rakésén dunyan waak vatvat naandarén. Sebedina nyaan vétik Jems ambét Jon bét waak vatvat naan. Bét Saimonale jémbaa yatémbérén. Vatvat naae Saimon Jisasna maanale kwaati séte dat anga wandén, “Néman Du, wuné kapéremusé yakwa du a. Méné wuné yaasékatake ma yé.” Naandéka dat wandén, “Méné wup yaké yambak. Méné gukwami wuréménén pulak méné wuna jémbaa yate du dakwa kéraakaménéngwa, de wuna jémbaamba yaalandarénngé.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naandéka de botmba ye bot wutépmba témbétsotake deku musé asé akwi yaasékatake dale yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas ye gaayé nakmba randén. Lepro yan du nak wani gaayémba yaréndén. Déku sépé waasémama wurésapén. Wani du Jisasét vétake yaae kwaati séte waandé daate dat anga wandén, “Néman Du, wuné yékun yawuténngé méné mawulé yamunaae ma waménu wuné yékun yakawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Naandéka dat taamba kutte wandén, “Yékun yaménénngé wa mawulé yawutékwa. Méné ma yékun ya.” Naandéka wani lepro késndéka wani du yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yandéka dat wandén, “Ma véku. Ménat yawutén muséké nak duwat waké yambak. Méné Gotna gaamba jémbaa yakwa duké ye déku ménimba téménu dé ména sépat vékandékwa. Véndu méné yékun yaménénngé talimba Moses wan pulak Gorké kwaami ma kwayéménék. Kwayéménu du dakwa véte lepro késndéka yékun yaménénngé wa vékusék-ngandakwa.” Wunga wandéka yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisas wunga yandéka genge gaayémba asa du dakwa wa déku mayé apaké kundi bulndarén. Yate asa du dakwa wa Jisaské yaandarén, Gotna kundi vékute Jisasét waatakundaru dé sépémaalé kapére yan du dakwat kururéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yaandaka apapu det yaasékate dé du yarékapuk taalémba yéte Gorale kundi bulndén wamba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nak nyaa Jisas du dakwat Gotna kundiké yakwasnyé-téndéka de Farisi du ras, apakundiké vékusékngwa du ras, wunga rakésndarén. Wani dunyansé Galili distrikmba tékwa akwi gaayé, Jerusalem, Judia distrikmba tékwa ras gaayé waak, ge gemba yaandarén. Yaae rakésndaka Néman Du Gotna mayé apa Jisasna mawulémba wulaae téndéka baat yakwa du dakwa, sépémaalé kapére yan du dakwat waak kururéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yandéka du ras maan taamba kapére yan du nak jaambémba yaate yaandarén. Yaate yaae gaat wulaae Jisas téndénmba taakaké mawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yandaka némaamba du dakwa téndaka taalé vékulékén. Vékulékndéka kure wulaaké yapatindarén. Yaambu yamba yé wa. Yandéka gaamba waare nak sakumba ayélap péraalékundarén. Péraae wani du kwaan jaambémba baangwit téwaakwe wani yaambumba dé jaambale kusandandarén du dakwana nyéndémba. Kusande Jisasna saawimba taakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Taakandaka Jisas vététe anga vékusékndén. Deku mawuléké wandarén, dé wani duwat kururémuké apa yandékwanngé. Wunga vékute wani duwat wandén, “Wuna du, yaménén kapérandi musé wa yasnyéputiwutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas wani kundi wandéka de apakundiké vékusékngwa dunyan, Farisi dunyan waak deku kapmang bulte anga wandarén, “Yénga pulak du dé wani du? Du dakwa yakwa kapérandi musé wan Got male wa yasnyéputikwa. Wani du wa wakwa, ‘Wuné yandén kapérandi musé wa yasnyéputiwutén.’ Dé baka du wunga wate wa Gorét wasélékndékwa wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naandaka Jisas deku mawulé vékusékte wa det anga wandén, “Kamuké guné guna mawuléké vékulako? Guné wunga yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Wuné Duna Nyaan ani képmaamba téte yandarén kapérandi musé yasnyéputimuké wa apamama yawutékwa. Guné wani muséké yamba vékusék-ngunéngwe wa. Yandén kapérandi musé yasnyéputiwuténngé wate baka kundi wuté wak, kapuk néma kundi wuté wak? Dé waarape yéndénngé wamunaae wan néma kundi waké wuté kapuk? Guné wuna mayé apaké yékunmba vékusék-ngunénngé wa wuné ani kundi bulaa dat wakawutékwa.” Naatake maan kapére yan duwat wandén, “Méné ma waarape ména jaambé kéraae kure ména gaat yéménék.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Naandéka akwi du dakwana ménimba bari waarapndén. Waarape kwaandén jaambé kéraae kure Gotna yé kavéréklaakét yéndén déku gaat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yéndéka akwi du dakwa vétake vatvat naandarén. Naate Gotna yé kavérékndaka deku mawulé géndéka, anga wandarén, “Yéki. Bulaa nakpulak néma musé nak a vénanén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kukmba Jisas ye véndén takis kéraakwa du nak takis kéraandékwa gaamba randéka. Wani duna yé Livai wa. Vétake Jisas dat anga wandén, “Méné ma yaa wunale.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naandéka waarape akwi musé asé yaasékatake Jisasale yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai ye déku gaamba kakému rékaamba yaakéndén Jisaské. Yaakétake wandéka de takis kéraakwa dunyansé késépéri, kapérandi musé yakwa dunyan késépéri, Jisasna dunyansé waak, wunga kandarén kakému bérale sékét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Karéndaka de Farisi dunyan ras, deku jémbaamba gwaande apakundiké vékusékngwa dunyan ras, de Jisasna dunyansat waarute anga wandarén, “Kamuké guné takis kéraakwa dunyan, kapérandi musé yakwa dunyan ras waak, guné dele kakému kulak ko?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Naandaka Jisas det gwaaménja kundi nak anga wandén, “Yékunmba yatékwa du dakwa doktaké yamba yéndakwe wa. Baat yakwan, sépémaalé maan taamba kapére yan du dakwa male wa yékwa doktaké. Yéndaka dokta deku sépé kururéndékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naatake wandén, “Wuné du dakwana kapérandi mawulé wa kururéwutékwa. Kapérandi mawulé vékukwa du dakwa yandarén kapérandi mawulé yaasékatake wunéké yaae wuna kundi vékundarénngé wa gaayawutén. Yéku mawulé vékukwa du dakwaké yamba vékulakawutékwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dunyan ras yaae Jisasét anga wandarén, “Baptais kwayékwa du Jonna dunyan Gorale kundi bulké yate de késépéri nyaa kakému yaakétndakwa. Yaakére baka yaréte Gorale kundi bulndakwa. Farisi dunyan wunga male yandakwa. Ména dunyan wunga yamba yandakwe wa. De akwi nyaa kakému kulak kandakwa. Kamuké daré ména dunyan kakému yaakérkapuk yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Naandaka Jisas det gwaaménja kundi nak anga wandén, “Du nak taakwa kéraaké yandu du dakwa mawulé tawulé yatéte kakému yaake kaké daré, kapuk wandu de kakému yaakérké daré? Wa kakandakwa. Taakwa kéraaké yakwa du dele sékét yaréndu wa mawulé tawulé yatéte kakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kukmba dunyan ras yaae wani du kure yéndaru, wani sapak wa de déku du dakwa déké mawulé sémbéraa yate kakému katik kaké daré. Wuné wuna dunyansale wayéka yaréwutéka wa mawulé tawulé yate kakému kandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wani kundi watake det gwaaménja kundi vétik waak anga wandén: “Du dakwa kulé laplap tambék sékwe kéraae jaangwa laplapmba tékwa yaambu yamba taake yatépéndakwe wa. De kulé laplap tambék sékwe kéraae jaangwa laplapmba tékwa yaambumba taake yatépé-munaandaru, wa bét vétikmba gérikngambérékwa. Kulé laplap jaangwa laplapale katik yékun yaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Dékény kaa viyaae révéndarén meme sépémba kulé wain kulak katik wukaasandaké daré. Wunga yamunaandaru wani meme sépé jaangwa ye pungndu kulak akwi yékéraa-kandékwa. Yékéraandu wani meme sépé katik yékun yaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kulé meme sépémba wukaasanda-ndaru kulé wain kulak wa yékunmba tékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Talimba yandarén wain kulak kakwa du taale dé kulé wain kulak kaké kalik yakandékwa. Yate anga wakandékwa, ‘Talimba yandarén kulak wan yékun wa.’ Naate wa talimba yaténdén muséké wa mawulé yandékwa.” Talimba yatan duna kundi vékukwa du Jisasna kulé kundi vékuké kalik yandaka wa wani gwaaménja kundi wandén wunga. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yaap yaré nyaa nak Jisas déku dunyansale sékét wit tékéskwa yaawi nakmba yéndarén. Yététe déku dunyan wit sék kaké we wit kumbu ras taakwe deku taambat léwaakite wit sék kandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kandaka Farisi dunyan ras vétake det anga wandarén, “Guné wit kumbu taakwe taambat léwaaki-ngunéngwa, yaap yaré nyaamba. Nana apakundi anga wandékwa, ‘Guné yaap yaré nyaamba jémbaa yaké yambakate.’ Wani apakundi yamba vékungunéngwe wa. Guné wit kumbu taakwe taambat léwaakite wa guné jémbaa wa yangunéngwa, yaap yaré nyaamba. Wa kapérandi yapaté wa yangunéngwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Naandaka Jisas det anga wandén, “Talimba nana gwaal waaranga maandéka bakamu Devit yan muséké Gotna nyéngaamba wa viyaatakandarén. Wani kundiké yamba vékulaka-ngunéngwe wa. Talimba Devit déku dunyansale kaandé yandéka dé Gotna kundi bulndakwa gaat wulaae wani gaamba jémbaa yakwa duwat waatakundén, Gorké kwayéte taakandarén kakému det kwayéndarénngé. Waatakundéka kwayéndaka Devit wani kakému déku dunyansat kwayéndéka de akwi kandarén. Wunga yate nana apakundi yamba vékundakwe wa. Nana apakundi anga wandékwa, ‘Gotna gaamba jémbaa yakwa du male wa Gorké kwayéndarén kakému yénga kandaru. Nak du wani kakému katik kaké dé.’ Wunga wandéka Devit déku dunyansale wunga yandaka deké anga yamba wangunéngwe wa, ‘Wan kapérandi musé wa yandarén.’ Wunga wakapuk ye nanat kamuké guné anga wo? ‘Guné nana apakundi vékukapuk yate kapérandi musé wa yangunén.’ Guné wunga wate yamba kurkale vékusék-ngunéngwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naatake det anga wandén, “Wuné Duna Nyaan yaap yaré nyaana néma du a rawutékwa. Wuné du dakwana jémbaaké yi naawutu wa de yaap yaré nyaamba yi naawutén pulak yénga yandaru.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nakapuk, yaap yaré nyaamba Jisas Gotna kundi bulndakwa gaat wulaae du dakwat Gotna kundi kwayéténdén. Wani gaamba yékutuwa saku taamba lin du nak wa véran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Randéka de apakundiké vékusékngwa dunyan, Farisi dunyan waak, wani gaamba rate vésék naaréndarén Jisasét. Yate deku mawulémba anga wandarén, “Jisas yaap yaré nyaamba wani duwat kalmu kururéké dé kapuk? Dat kururémunaae, wa nana apakundiké kuk kwayékandékwa. Wunga yandu dé kotimnganangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naandaka dé déku kapmang wa vékundén awula deku mawulémba wandarén kundi. Vékutake taamba lin duwat wandén, “Ma waarape yaae amba té.” Naandéka waarape téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Téndéka Jisas det anga wandén, “Wuné gunat waatakukwate yawutékwa. Nana apakundi yénga dé wo? Yaap yaré nyaamba nané yéku musé yaké nané, kapuk kapérandi musé yaké nané? Yaap yaré nyaamba kiyaaké yakwa du dakwat yékun yaké nané, kapuk det viyaandékngé nané?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wunga watake det nak nak yaasatiyaale vétake wani duwat wandén, “Ména taamba ma kayéndéng.” Naandéka déku taamba kayéndéngndéka wa nakapuk yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yandéka de asa rakarka wa yandarén. Yate dekét deku kapmang bulte wandarén, “Nané Jisas yénga pulak yaké?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wani sapak Jisas dé Gorale kundi bulké némbat waaréndén. Waare gaan Gorale kundi bulndén. Bulréndéka ye yé gérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yé gére nyaa yaalandéka déku dunyansat waandéka yaandarén. Yaandaka du tambavétik maanmba kaayék vétikét (12) wa wakandéngndén, déku kundi kure yékwa dunyan téndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Deku yé anga wa: Saimon. Déku nak yé Jisas wa kwayén, Pita. Saimonna waayéka, Andru. Jems. Jon. Filip. Bartolomyu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu. Tomas. Alfiusna nyaan, Jems. Saimon. Dé talimba genge gaayémba yéte wandén, “Nak képmaana du nana néma du téndénngé kalik yawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemsna nyaan, Judas. Judas Iskariot. Kukmba wa Jisas maamat kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas déku dunyanale sékét daawuliye yéku viyaatakan taalé nakmba téndarén. Déku dunyan késépéri dale sékét téndaka némaamba du dakwa wa de waak yaae tén. De Jerusalem, Judia distrikmba tékwa nak gaayé, Tair, Saidonmba waak yaandarén. Tair, Saidon waak bét solwara wutépmba tékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wani du dakwa ras Jisasna kundi vékuké yaandarén. Ras du dakwa baat yandéka ras sépémaalé, maan taamba kapére yandéka Jisas det kururéndénngé wa yaandarén. Wani du dakwa rasét kutakwa wa kulure kure yaténdaka de waak yaandarén. Yaandaka kutakwa wandéka yaange yéndaka de wani du dakwa yékun yawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yaandaka wandéka wa véndarén. Jisasna mayé apa némaan yandéka dé det kururéndén. Wunga véte dé akwi pulak det taamba kutndénngé mawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas déku dunyansat vététe det wandén, “Guné musé asé kapuk du, guné Gotna kémba téngunénga Got néma du rate gunéké yékunmba véndékwa. Véréndékwanngé guné mawulé tawulé yénga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Guné bulaa kaandale yarékwa du, sérémaa kakému némaamba kakangunéngwa. Kaké yangunéngwanngé mawulé tawulé yénga yangunu. “Guné bulaa géraarékwa du, sérémaa waangikangunéngwa. Waangiké yangunéngwanngé mawulé tawulé yénga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ma véku. Wuné Duna Nyaan rawutéka guné wuna jémbaamba wa yaalangunén. Du ras wunat maama yate gunéké kalik yate gunat anga wakandakwa, ‘Guné kapérandi musé yakwa du wa.’ Wunga waké yandakwanngé guné mawulé tawulé yénga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Talimba wani duna gwaal waaranga maandéka bakamu de Gotna yémba kundi kwayétan dunyansat wunga yaavan kutndarén. Det wunga yaavan kutndarénngé vékulakate de gunat wunga yaavan kutndaru guné mawulé tawulé yénga yangunu. Sérémaa Got gunat yékun yakandékwa, déku yémba kundi kwayétan dunyansat yékun yandén pulak. Yandu guné dale yékunmba yarésékéyak-ngangunéngwa. Yarésékéyakngé mawulé yate guné mawulé tawulé yénga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Guné némaamba yéwaa kure yarékwa du, bulaa yéku musé kéraasotake yékun yaréngunéngwa. Sérémaa kapérandi musé gunéké yaandu guné katik kurkale yaréké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Guné kakému kate biyaa sékérékndéka yarékwa du, bulaa kurkale kangunéngwa. Sérémaa kapérandi musé gunéké yaandu kaandale yarékangunéngwa. “Guné waangikwa du, bulaa dusék yangunéngwa. Sérémaa kapérandi musé gunéké yaandu guné némaamba géraakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Du dakwa akwi guna yé kusondaru ma jéraawu yangunék. Talimba guna gwaal waaranga maandéka bakamu papukundi watan duna yé kavérékndarén. Bulaa a tékwa du guna yé kavérékndaru kalmu guné waak papukundi waké guné? Bulaa a tékwa du guna yé kavérék-munaandaru kukmba kapérandi musé gunéké wa yaaké yakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wani kundi watake Jisas det anga wandén, “Guné, wuna kundi vékukwa du, gunat wawutékwa. Guné guna maamaké ma néma mawulé yangunék. Gunéké kalik yakwa duwat ma yékun ya. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gunat kapérandi kundi wakwa duké Gorét ma waatakungunék, det yékun yandénngé. Gunat kapérandi musé yakwa duké Gorét ma waatakungunék, det yéku mawulé kwayéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dunyan ras guna yékutuwa saku kupmimba viyaandaru waalakwe akituwa sakwat ma kwayé viyaandaru. Guné det waambule viyaaké yambak. Dunyan ras guna laplap kéraandaru guné laplap nak waak ma kwayé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dunyan ras guna muséké waatakundaru guné wani musé ma kwayé. De guna musé kéraandaru, guné wani musé waambule kwayékata-ndarénngé waaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nak du gunat yékun yamuké mawulé yangunéngwa pulak, det wunga ma yékun yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kapérandi musé yakwa du dakwa, yéku musé yakwa du dakwa, akwi du dakwa de deku du dakwaké mawulé yandakwa. Guné guna du dakwaké male mawulé yamunaae, guné kapérandi musé yakwa du dakwat katik taalékéraké guné. Guné wunga male yangunu Got wunga yangunéngwanngé, ‘Wa yékun wa,’ katik naaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akwi du dakwa waambule yakatate yéku musé yandakwa, det yéku musé yakwa du dakwat. Guné gunat yéku musé yakwa du dakwat male yéku musé yamunaae wa guné kapérandi musé yakwa du dakwat katik taalékéraké guné. Guné wunga yangunu Got wunga yangunéngwanngé, ‘Wa yékun wa,’ katik naaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Akwi du dakwa, kapérandi musé yakwa du dakwa waak, de nak du dakwat musé kwayéte deku mawuléké anga wandakwa, ‘De nanat wani waambu waambule tiyaakandakwa.’ Naandakwa. Guné wunga musé kwayéte wani kundi wate, guné kapérandi musé yakwa du dakwat katik taalékéraké guné. Guné wunga male yamunaangunu, Got wunga yangunéngwanngé, ‘Wa yékun wa,’ katik naaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","“Guné kapérandi musé yakwa du dakwa yakwa pulak yaké yambak. Guné det taalékére anga yangunék. Guné guna maamaké waak ma néma mawulé yangunék. Yate det ma yékun yangunék. Ye guné det musé asé kwayétake wani musé nakapuk waambule kéraaké vékulakaké yambak. Guné wunga yangunu apa tapa yakwa du Got gunéké anga wakandékwa, ‘Wa wuna nyambalésé wa yarékésndakwa.’ Naate gunéké kurkale vékandékwa. Yandu guné yékunmba yarésékéyak-ngangunéngwa. Guna aapa Got mawulé sémbéraa yandékwa, déké vékulaka-kapuk yate kapérandi musé yakwa du dakwaké. Dé deké mawulé sémbéraa yandékwa pulak, guné waak deké mawulé ma sémbéraa yangunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wani kundi watake Jisas det anga wandén, “Nak du dakwa yan muséké vékulakate guné kot vékukwa néma du pulak deké ye det bari anga wambakate, ‘Wani du dakwa wan kapérandi musé yakwa du dakwa wa.’ Wunga yakapuk yangunu wa Got yangunén muséké vékulakate anga bari katik waké dé, ‘Guné kapérandi musé yakwa du dakwa wa.’ Wunga katik waké dé. Guné wani du dakwat wunga bari wakapuk ye wani yandarén kapérandi muséké katik vékulakaké guné. Wunga yangunu Got yangunén kapérandi musé yasnyéputiye wani muséké nakapuk katik vékulakaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Guné nak du dakwat yékun yaké wate det musé asé ma kwayéngunék. Kwayéngunu Got gunat yékun yate gunat kwayékandékwa. Kwayéngunu Got gunat yakélak yakélak katik yékun yaké dé. Kwayéngunu wa Got gunat némaamba yékun yakandékwa. Yékun yandu guné yékunmba yarésékéyakngangunéngwa. Guné nak du dakwat yékun yangunéngwa pulak, Got gunat yékun yakandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wani kundi watake Jisas det ani gwaaménja kundi wandén, “Méni kiyaan du nak baan méni kiyaan duwat yaambu wakwasnyéké dé, kapuk? Yamba wa. Dat wakwasnyéké watake ye bét véréti kavérémba vaakérkambérékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skulkwa nyambalésé de baka du wa yaréndakwa. Det yakwasnyékwa du, de deku néma du wa téndakwa. De det yakwasnyéndaru kurkale skule sérémaa wani nyambalésé det yakwasnyan du pulak wa néma du tékandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wani gwaaménja kundi watake Jisas det anga wandén: “Nak du dakwa yan kapérandi musé wa ménimba wulaae rakwa makalkéri musé pulak wa. Yangunén néma kapérandi musé wa ménimba rakwa néma baangé pulak wa. Kamuké guné nak du dakwana ménimba wulaae rakwa makalkéri musé véte gunékét guna ménimba rakwa néma baangé yamba véngunéngwe? Wunga yate guné nak du dakwa yan kapérandi muséké wate guné yangunén néma kapérandi muséké yamba vékulaka-ngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Guné néma kapérandi musé yatake kamuké guné ayélapkéri kapéremusé yan du dakwat anga wo? ‘Guné kapérandi musé wa yangunén. Guné kurkale yaréngunénngé wuné gunat yékun yakawutékwa.’ Guné wunga waké yambak. Guné kapérandi musé yatake wunga wangunu, wa paapu yakwa du wa guné. Taale guné yangunén néma kapérandi muséké ma kuk kwayéngunu. Kwayétake guné ayélapkéri kapéremusé yan du dakwat yénga yékun yangunu.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wani kundi watake Jisas det anga wandén: “Ani gwaaménja kundi nak ma vékungunu. Yéku miyémba kapérandi sék yamba vaakundékwe wa. Kapérandi miyémba yéku sék yamba vaakundékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nané miyé sékét véte anga wanangwa, ‘Wani miyé yéku miyé wa. Ani miyé a kapérandi miyé a.’ Naanangwa. Anga vékuséknangwa. Raamény baangwimba nané miyé sék yamba gélénangwe wa. Kapérandi waaramba nané yéku miyé sék yamba gélénangwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Bulaa wani kundiké ma vékulaka. Nané miyé sékét véte miyéké wanangwa. Miyéké vénangwa pulak wa nak du dakwana jémbaa véte deku mawuléké vénangwa. Yéku duna mawulémba yéku mawulé male yaalandéka yéku kundi bulte yéku musé yandakwa. Kapérandi duna mawulémba kapérandi mawulé male yaalandéka kapérandi kundi bulte kapérandi musé male yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas anga wandén: “Guné wunat anga wangunéngwa, ‘Méné, nana Néman Du wa.’ Wunga wate wuna kundi yamba vékungunéngwe wa. Kamuké guné wunga wate wuna kundi vékumuké kalik yo? ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wunéké yaae wuna kundi vékute wawutékwa pulak yakwa du dakwa wan ani du pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dé yéku gaa kaaké we néma kwaawu vaandén. Vaae matu taakumba kwaat taawundén. Taawutake yéku apamama yan gaa kutndén. Kutndéka maas viyaae kwayé kwe wani gaamba viyaandéka wani gaa yamba vaakére wa. Yénga ye vaakétndék? Néma jémbaa ye yéku gaa kutndénmba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wuna kundi baka vékute wawutékwa pulak yakapuk yakwa du dakwa de wan ani du pulak wa. Dé gaa bari kurké watake apamama yakapuk bumbu képmaamba kwaat waayéngwandén. Kwaat yékunmba téndénngé vékulake matumba yamba vaandékwe wa. Yandéka maas viyaae kwayé kwe wani gaamba viyaandéka wani gaa bari vaakérén. Vaakétndéka kwayé wa kure yén wani gaa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas wani kundi wasékéyaktake Kaperneamét yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wani gaayémba Romna waariyakwa dunyanséna néma du nak yaran. Déku jémbaa yakwa duké asa mawulé wa yandén. Yaréndéka déku jémbaa yakwa duwat baat yan. Yandéka kiyaaké yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yandéka wani néma du vékundén Jisas wani gaayémba yaréndéka. Vékutake Judana néma du rasét wandéka Jisaské yéndarén, dé wandaru dele ye déku jémbaa yakwa du kururéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Yaae Jisasét anga wandarén, “Dé wani du dé yéku du wa. Dé nané Judaséké asa mawulé wa yandékwa. Dé nanéké Gotna kundi bulndakwa gaa kutndén. Kutndénngé méné déku duwat kururé-ménénngé mawulé yanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naandaka Jisas deku kundi vékutake dele yéndén. Ye gaamba saambakngé yaténdaka waariyakwa dunyanséna néma du déku naawindu rasét wandéka de yaae Jisasét déku kundi anga wandarén, “Néman Du, wuné baka du a téwutékwa. Méné néma du wa. Wunga téte méné wuna gaat yaalaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wunga téménéngwanngé vékulakate wuné ménéké yamba yaawutékwe wa. Méné baka waménu wuna du nakapuk yékun yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nak du wuna néma du téndékwa. Téte wandékwa pulak wuné yawutékwa. Wuné du nakét, ‘Méné ma yé,’ naawutéka yéndékwa. Du nakét, ‘Méné ma yaa,’ naawutéka yaandékwa. Wunémba jémbaa yakwa duwat, ‘Ani jémbaa ma ya,’ naawutéka wani jémbaa yandékwa. Méné yawutékwa pulak ma yaménu. Yate baka ma waménu wuna du nakapuk yékun yakandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wani duna kundi wunga wandaka vékutake Jisas vékulaka vékulaka naandén. Ye waalakwe déku kukmba yétékésén du dakwat anga wandén, “Dé wani du wunéké yékunmba vékulakandékwa. Wuné wawutu du dakwa yékun yamuké wa vékusékndékwa. Guné Israel du dakwa, guné wunéké ayélapkéri sékéyak wa yékunmba vékulaka-ngunéngwa. Rom du téndéka déku yéku mawulé wa guné Israel du dakwa guné yakwa yéku mawulat wa taalékéra-sandandén. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wunga wandéka waariyakwa dunyanséna néma du wandéka yaan wani dunyansé nakapuk waambule gaat yéndarén. Ye wulaae véndarén néma dumba jémbaa yakwa du nakapuk baat yéput ye randéka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kukmba Jisas nak gaayét yéndén. Wani gaayéna yé Nain wa. Yéndéka du dakwa némaamba wa, déku dunyansé waak wunga dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ye wani gaayéna aatmu pétémba saambakngé yaténdaka kiyaan dunyanngu nyaan nak yaate kure yaalandarén. Aasa nakurak dé male wa kéraalén. Nyaan ras yamba yé wa. Léku du dé talimba wa kiyaan. Wani gaayémba yarékésén du dakwa némaamba, wani taakwale yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yaandaka vétake Néman Du Jisas mawulé sémbéraa yandén wani taakwaké. Yate lat anga wandén, “Nyéno, géraaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naatake ye kiyaae kwaan duna jaambémba kutndén. Kutndéka wani jaambé yaatan dunyansé de wunga tékésén. Téndaka kiyaae kwaan duwat anga wandén, “Méno, wuna kundi ma véku. Ma waarap.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naandéka kiyaan du nakapuk taamale waarape rate bulréndén. Bulréndéka Jisas dé déku aasat kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yandéka akwi du dakwa bérute wup yandarén. Yate Gotna yé kusoréndarén. Kusote anga wandarén, “Gotna yémba kundi kwayékwa du nak dé nanale a tékwa. Wa néma du wa. Bulaa Got dé a yaan, déku du dakwat yékun yaké.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Watake Jisas yan muséké saapé yeyé yaayandarén. Yandaka de wani gaayale tékwa gaayémba, akwi Judiana gaayémumba waak, vékundarén Jisaské. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Baptais kwayétan du Jon kalapusmba kwaandéka déku dunyan yaae dat wandarén Jisas yan muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wandaka Jon wandéka déku du vétik yaambéréka bérét anga wandén, “Béné ma yé Jisaské. Ye anga ma waatakumbénék, ‘Talimba Gotna nyéngaamba viyaatakandarén, nanat yékun yaké sérémaa yaaké yakwa duké. Wani du méné ani méné, kapuk wa nak duké kaavéréké nané?’ Dat wunga béné waké ya.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wandéka bét ye Jisas yaranmba saambake anga wambérén, “Baptais kwayékwa du Jon aanat wandéka yaatékwa ménéké. Ani kundi ménat waatakuké yaatékwa: Talimba Gotna nyéngaamba kundi viyaatakandarén, nanat yékun yaké kukmba yaaké yakwa duké. Wani du méné ani méné, kapuk wa nak duké kaavéréké nané?” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wani nyaa Jisas asapéri du dakwa baat yandaka, sépémaalé kapére yan du dakwat waak kururéndén. Yate wandéka de wani du dakwat kulure kure yatékésén kutakwasé de yaale yaange wunga yékéraan. Ménimbo yan du dakwa asa wa, wandéka nakapuk kurkale véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas wunga yatéte Jonna du vétikét anga wandén, “Béné waambule ye béné wani vémbénén, vékumbénén muséké Jonét ma wambénu. Ménimbo yan du dakwa nakapuk véndakwa. Maan kapére yan du dakwa nakapuk yékun ye yeyé yaayandakwa. Lepro waasé yan du dakwa nakapuk yékun yandakwa. Waangété ye waan vékukapuk yan du dakwa nakapuk waan vékundakwa. Wani du dakwat akwi wa kururé-wuréwutén. Wuné wawutéka kiyaan du dakwa nakapuk taamale waarape yarékéskwa. Musé asé kure rakapuk du dakwat Gotna kundi wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Du dakwa ras wunéké anga wandakwa, ‘Wa Got dat wa wandén, nanat yékun yandénngé. Yi wan wanana wa.’ Naate wunga wate de wunéké yékunmba vékulakandakwa. Wunéké wunga vékulakakwa apu, de mawulé tawulé yénga yandaru. Jonét wunga béné waké ya.” Naandén Jisas Jonna du vétikét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisas wunga wandéka bét Jonna du vétik bét yén. Yémbéréka Jisas wamba rakésén du dakwat Jonngé anga wandén: “Guné du yarékapuk taalémba ye, yénga pulak du véké guné yék? Wimut kutndéka apamama yakapuk yate viyékngwa séwaa pulak yakwa du véké guné yék, kapuk yénga pulak du véké? Jon wani séwaa pulak wunga yamba yé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yéku laplap saawan du véké guné yék, kapuk yénga pulak du? Jon wani du wunga pulak yamba yé wa. Yéku laplap saawukwa dunyan de néma duna yéku gaamba wa randakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gotna yémba kundi kwayékwa du nakét véké guné yék, kapuk? Yi, Jon wan Gotna yémba kundi kwayékwa du wa. Gunat wawutékwa. Dé néma du wa téndékwa. Gotna yémba kundi kwayétan nak néma duwat wa taalékéra-sandandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jonngé ani kundi Gotna nyéngaamba wa kwaakwa: Got déku nyaanét anga wandén, ‘An wuna kundi kure yékwa du a. Wuné wawutu dé taale yéte ména yaambu kurkandékwa.’ Nané wani kundi vékute vékuséknangwa. Jon wan Gotna kundi kure yaate taale yaakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Wunga vékusékte gunat wawutékwa. Jonna jémbaa ani képmaamba talimba tan duna jémbaat wa taalékéran. Taalékérandéka gunat yékun yaké yawutékwa jémbaaké yamba kurkasale vékundékwe wa. Yandéka de Gotna kémba téte du dakwat yékun yaké yawutékwa jémbaaké vékusékngwa du dakwa akwi deku yéku mawulé wa déku yéku mawulat taalékérasandan. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wani kundi wandéka de takis kéraakwa du, wamba tékésén du dakwa waak wani kundi vékutake mawulé wa yandarén. Jon talimba det baptais kwayéndénngé wa Jisasna kundiké mawulé yandarén. Yate Gotna yé kavérékte anga wandarén, “Déku kundi wan yéku kundi wa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naandaka de Farisi dunyan, apakundiké vékusékngwa dunyan waak de wani kundiké kalik yandarén. Gotna kundiké kuk kwayéndaka Jon det talimba baptais kwayékapuk yandénngé Jisasna kundiké kalik yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wunga watake Jisas det anga wandén, “Bulaa a tékwa du dakwa yénga pulak daré? Gunat wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bulaa a tékwa du dakwa de aamemba kétikwa nyambalésé pulak wa yaténdakwa. De téte rasét waandakwa. Waate anga wandakwa, Nané gwaaré waate kaang viyaananga guné yamba kétingunéngwe wa. Nané mawulé sémbéraa yate géraananga guné yamba géraangunéngwe wa. Guné nanale nakurakmawulé yamba yangunéngwe wa. Wunga waakwa nyambalésé pulak, bulaa a tékwa du dakwa wunga wa yaténdakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“De Jonale nakurakmawulé yamba yandakwe wa. De wunale nakurakmawulé yamba yandakwe wa. Baptais kwayékwa du Jon yaae a kangunéngwa kakému kate a kangunéngwa wain kulak yamba kandékwe wa. Yandéka guné déké kalik yate anga wangunén, ‘Kutakwa déku mawulémba wulaae téndéka wa waangété wa yandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wunga wangunénga wuné Duna Nyaan yaae wuné a kangunéngwa kakému kate, a kangunéngwa wain kulak kawutékwa. Kawutéka wuné kalik yate anga wangunéngwa, ‘Ma véna. Wani du némaamba kakému kate némaamba wain kulak wa kandékwa. Kate dé takis kéraakwa dunyanale yaréte, kapérandi musé yakwa ras dunyanale yaréte dele bulndékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Naangunénga nak kundi wawutékwa. Got dé akwi pulak musé vékuwuréndén wa. Déku yapaté wa yéku yapaté wa. Yi wan wanana wa. Wani kundiké vékulakate guné aané déku du vétikngé ma yékunmba vékulakangunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi du nak déku yé Saimon Jisasét wandén, dale kakému kandénngé. Wandéka ye wani duna gaamba wulaae rate kakému kandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jisas Farisi duna gaamba rate kakému karéndéka lé kapérandi musé yakwa taakwa nak wani gaayémba yare vékulén. Vékutake matumba yandarén yéku botol kure yaalén. Yéku yaama yakwa gu wani botolmba tén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kure yaae Jisasna maanale kwaati séte géraalén. Géraaléka léku méniyangu Jisasna maanmba putangsandan. Putangndéka léku sémény némbat létéklén. Létéktake déku maanmba késépéri apu taama rénglén. Yate yéku yaama yakwa gu déku maanmba sévilén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Séviléka vétake Jisasét wandéka wani yaandén Farisi du, déku mawuléké anga wandén, “Wani du Gotna yémba kundi kwayékwa du ramunaae akwi musé vésékte dat kurkwa taakwa waak vésékngatik dé. Lé kapérandi musé yakwa taakwa wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wani du wunga wandéka dat Jisas anga wandén, “Saimon, ménat nak kundi nak wakwate yawutékwa.” Naandéka wandén, “Nanat Gotna kundiké yakwasnyékwa du wa, ma wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naandéka ani gwaaménja kundi wandén: “Du vétik, du nakmba yéwaa kéraambérén. Nak du néma yéwaa (100 kina pulak) kéraan. Nak du ayélapkéri yéwaa (10 kina pulak) kéraan. Kéraambéréka kukmba kaavéndén wani du, déku yéwaa nakapuk waambule kwayémbérénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wani du vétik bét déku yéwaa nakapuk waambule kwayékataké yambérén. Yambéréka bérét anga wandén, ‘Yénga yakét. Béno, tiyaaké yambak.’ Wunga wandénngé méné yénga méné vékulako? Wani du vétikmba kandé yéwaa kwayén duké néma mawulé yaké ya?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naandéka Saimon wa wan, “Néma yéwaa kéraan du wa. Wunga vékulakawutékwa.” Naandéka Jisas wa wan, “Ména kundi yékun wa. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wani kundi watake Jisas wani taakwaké waalakwe Saimonét anga wandén, “Ani taakwat ma vé. Wuné ména gaat yaalawutéka méné nana apakundi wakwa pulak yamba yaménéngwe wa. Ye gu ras yamba tiyaaménéngwe, wuna maan yakwasnyéwuténngé. Ani taakwa lékét léku méniyangwat wa wuna maan yakwasnyélén. Ye lékét léku némbat gu létéklén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Méné wunat yamba taama réngménéngwe. Wuné amba yaale taale rawutéka wani taakwa wa yaae wuna maanmba taama rénglén, késépéri apu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Méné wuna maakamba yéku gu yamba séviménéngwe. Lé wa sévin yéku yaama yakwa gu wuna maanmba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wunga yaléka ménat wawutékwa. Yalén kapérandi musé wa yakwasnyé-putiwutén. Yakwasnyé-putiwutéka lé wunéké asa mawulé wa yalékwa. Ras du dakwa kapérandi musé ayélapkéri yandaka wani kapérandi musé yakwasnyéputiwutéka de wunéké mawulé ayélapkéri yandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wani kundi watake wani taakwat anga wandén, “Yanyénén kapérandi musé wa yakwasnyéputiwutén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wunga wandéka dale sékét rate kakému karan dunyansé dekét deku kapmang bulte anga wandarén, “Wani yalén kapérandi musé wa yakwasnyé-putindékwa. Wan yénga pulak du dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naandaka Jisas wani kundi waambule wakapuk yate wani taakwat anga wandén, “Nyéna kapérandi mawulé kururékwate yawutékwa mayé apaké yékunmba vékulaka-nyénénga wa nyéna mawulé wa kururéwutén. Bulaa nyéna mawulé yénga yékunmba téndu yékunmba yénga yényénu.” Naandén Jisas lat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kukmba Jisas asapéri gaayémba saawe yéndén. Yéte Got néma du rate du dakwaké kurkale véké yandékwanngé du dakwat kundi kwayéndén. Déku dunyansé tambavétik maanmba kaayék vétik (12) wunga yéndarén dale sékét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Dakwa ras waak dale sékét yéndarén. Talimba wani dakwa rasét wa baat yan. Rasét kutakwa wa kulure kure yatékésén. Yaténdaka wa Jisas wani dakwasat akwi kururéndén. Wani dakwasé dekét deku yéwaamba kwayéte kakému kéraate yaakéte kwayéndarén, Jisas, déku dunyansat waak. Wani dakwa, nak Maria wa. Léké wandarén, “Wa Makdalamba yaan taakwa Maria wa.” Talimba lat kutakwa taambak kaayék vétik (7) wa kulure kure yaténdaka, Jisas wandéka lé yaasékatake yaange yéndarén. Nak taakwa Herotna gaaké séngitékwa du déku yé Kusa, déku taakwa wa. Léku yé Joana. Nak Susana wa. Dakwa ras waak sékét wunga wa yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Asa du dakwa wa Jisaské yaae jaawundarén. Wani du dakwa genge gaayémba wa yaandarén. Yaandaka ani gwaaménja kundi wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Du nak déku yaawimba wit sék yaasnyéké yéndén. Ye yaasnyéndéka wit sék ras yaambumba vaakérén. Vaakétndaka du dakwa wa yeyé yaayate maanét vaakindarén yaambumba rakésén wit sék. Vaakindaka api wa yaae kéraae kawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wit sék ras matumba vaakérén, képmaa ayélap tanmba. Matumba vaakére taakwe waare, képmaa rékandang yandéka méngi kurkasale kurkapuk ye wa bari rékaa ye kiyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit sék ras néma waaramba vaakérén. Vaakére randaka raamény waara wa wuttépe waare taakatépan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit sék ras yéku képmaamba vaakérén. Vaakére wamba re yékunmba wure waaréndarén. Waare yéku sék vaakundarén rékaamba.” Naandén Jisas. Naatake anga wandén, “Guné vékusékngé mawulé ye kurkale waan taake ma kurkale vékungunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas det wani kundi wandéka déku dunyansé wani gwaaménja kundiké dat waatakundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Waatakundaka det anga wandén, “Got néma du rate du dakwaké yékunmba vékandékwa. Véréndu de déku kémba tékandakwa. Wani muséké talimba Got paakundén kundi wa. Paakutake wandén, guné bulaa wani musé vékute véngunénngé. Nak du dakwa véte katik vésékngé daré. Ve kurkasale katik véké daré. Kundi vékute wani kundiké katik vékusékngé daré. Yandarénngé wa ani gwaaménja kundi det wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bulaa ani gwaaménja kundina wambukundi wakawutékwa. Anga wa. Wani wit sék wa Gotna kundi pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Du dakwa ras Gotna kundi vékundakwa. Vékundaka Satan wa yaae wani kundi deku mawulémba kéraae kure yékwa. De Gorké kurkasale vékwe Gorké yéndakwa yaambumba yéndarénngé kalik yate, wa wani kundi kéraandékwa. Kéraae kure yéndéka wani kundiké wa yékéyaak yandakwa. Wani du dakwa de wan yaambumba vaakérén wit sék pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Du dakwa ras Gotna kundi bari vékundakwa. Vékwe wani kundiké mawulé yate mawulé tawulé yandakwa. Yate kurkasale yamba vékulakandakwe wa. Wani kundi deku mawulémba daawulikapuk yandéka de yékunmba yamba vékulakandakwe wa. Yaténdaka vakmi ras deké yaandéka, Gotna kundi bari yaasékandakwa. Wani du dakwa de wan matumba vaakérén wit sék pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ras du dakwa taale Gotna kundi yékunmba vékundakwa. Vékute de ani képmaana muséké male vékulakandaka deku mawulé yéwaaké, salmu walmuké génngwa. Wani musé wa Gotna kundit taakatépékwa. Taakatépéndéka wani du dakwa Gotna jémbaa yamba yandakwe wa. Wani du dakwa de raamény waara ténmba vaakérén wit sék pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ras du dakwa de Gotna kundi kurkasale vékute, wandékwa pulak yate déku kundiké mawulé yandakwa. Yate déku kundi kurkale vékuréte, mawulé yaréte Gorké yéku jémbaa yapékaréndakwa. De wani du dakwa, wa yéku képmaamba vaakérén wit sék pulak wa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas wani kundi watake anga wandén, “Ani gwaaménja kundi nak ma véku. Dunyan téwaayé yaa takngére kure ye sapngutaka-ndarén aké arulamba daré kusolatako, kapuk jaambé atndamba daré taako? Yamba wa. De jaambé taakumba wa taakandakwa, wani gaat wulaaké yakwa du dakwa téwaayé vérékte kaaléndu de kurkasale véndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Paakwe rakwa musé sérémaa vékangunéngwa. Yakélak wandarén kundi sérémaa kaapamba randu vékukangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ma véku. Wani kundiké ma vékulaka naa. Guné yékunmba vékulakate, wuna kundi kurkasale vékukangunéngwa. Wuna kundi yékunmba vékukwa du dakwa de sérémaa Gotna kundi yékunmba vékukandakwa. Wuna kundi yékunmba vékukapuk yakwa du dakwa anga wandakwa, ‘Nané vékuwuran wa Gotna kundi.’ Wunga watake sérémaa de déku kundiké yékéyaak yatake baka rakandakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wani nyaa Jisasna aasa déku waayékanje waak sékét déké yaandarén. Asa du dakwa wa yaae wulaandaka gaa taalé vékulékndéka de dé ténét wulaaké yapatindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yandaka dunyansé ras wa dat wan, “Ména aasa, ména waayékanje de a yaae angwandé kaapamba téte méné vékwate yandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naandaka det anga wandén, “Gotna kundi vékute wandékwa pulak yakwa du dakwa wan de wuna aasa, wuna waayékanje wa téndakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nak nyaa Jisas bot nakmba déku dunyan sékét kure waaréndén. Waare det anga wandén, “Ma yékwak, néma gu kwaawuna nak sakwat.” Naandéka botmba yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yéréndaka, Jisas yundé yandéka daae kwaaran. Kwaandéka néma wimut kutndéka gu waare botmba gwaande vékulékngé yan. Yandéka lambiyakngé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yate ye Jisasét sérkiyaate anga wandarén, “Néma du, nané a lambiyakngwa.” Naandaka vélérkiyaae waarape wandéka wimut késndéka, gu daae yékunmba tén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yatake det anga wandén, “Wuné gunat yékun yaké yawutékwa mayé apaké guné kamuké guné yamba yékunmba vékulaka-ngunéngwe?” Naandéka de vatvat naate dekét deku kapmang bulte anga wandarén, “Yéki. Wandéka gu wimut waak déku kundi vékute wandékwa pulak yambérékwa. Wa yénga pulak du dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisas déku dunyansale sékét botmba ye Gerasaséna taalémba saambakndarén. Wani taalé néma gu kwaawuna nak sakumba téndéka Galili distrik nak sakumba tékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wamba saambake bot taakatake néma gu kwaawuna wutépét wulaaké yaténdaka wani gaayémba yaan du nak Jisas véké yaandén. Talimba, wani du kutakwa kulure kure yaténdaka waangété yandén. Ye laplap yamba gindékwe wa. Baka male yaténdén. Bapmu bapmu baapmu wunga yaténdén. Gaamba yamba randékwe. Yamba wa. Dé wani kiyaandaka rémndarén kwaawumba male yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Dat kulure kure yatékésén kutakwasé, dat apapu viyaandarén. Viyaandaka waangété yandéka dunyansé ras wa déku maan taamba sen baangwit gindarén. Gitake dat véténdarén. Véténdaka wani sen bérélndéka kutakwasé dé kure yéndarén du yarékapuk taalat. Wani du wa Jisas véké yaandén. Yaandéka Jisas wa wan, dat kulure kure yatan kutakwasé yaange yéndarénngé. Wandéka vékwe dat véte némaanmba waate dat kwaati se waandé daate dat anga wandén, “Jisas, méné anjorémba rakwa du Gotna nyaan wa. Méné wunat yénga pulak yaké méné? Méné wunat kaangél tiyaaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naandéka dat anga wandén, “Ména yé yénga dé?” Waatakundéka wandén, “Wuna yé Késépéri wa.” Késépéri kutakwa kulure kure yaténdakwanngé wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wani kutakwasé Jisasét anga waandarén, “Nané kapérandi taalat yéké kalik yanangwa. Ménat waatakunangwa. Nané wunga yénanénngé méné nanat waké yambak.” Naandarén dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Téndarén némbumba baalé asa wa téte kakému katékésén. Katéndaka de wani duwat kulure kure yatékésén kutakwasé, Jisasét anga wandarén, “Méné nanat kewuréké mawulé yamunaae ma waménu, nané wani baaléna mawulémba wulaakanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wunga wandaka wandén, “Ma yaange yéngunu wunga.” Naandéka wani du yaasékatake ye baaléna mawulémba wulaandarén. Wulaae kulure kure yéndaka wani balémbalé néma némbuna kutmba yaange daae gumba vaakére kulak ke kiyaatondarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wani baaléké kaavéte séngitan dunyansé wunga yandaka vétake yaange yéndarén. Ye akwi gaayémba yarékésén du dakwat wani muséké wayé yaayandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wandaka du dakwa wani musé véké yéndarén. Ye Jisas tanmba saambake kutakwa yaasékatake yén duwat véndarén. Dé yéku mawulé vékwe laplap giye Jisasna maanale randéka véndarén. Vétake wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wup yandaka, Jisas wani musé yandéka vén gaayé wa det saapan, kutakwa kulure kure yatan du yékun yanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Saapéndaka Gerasana taalémba yarékésén akwi du dakwa wup nékéti ye Jisasét wandarén, de taakatake yéndénngé. Wandaka Jisas de yaasékatake yéké watake botmba waaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Talimba kutakwa kulure kure yatan wani du dat waate anga wandén, “Wuné ménale yéké mawulé yawutékwa.” Naandéka Jisas dat anga wandén, “Méné ma waambule yé ména gaayét. Ye Got ménat yékun yandénngé ma saapé.” Wunga wandéka dé gaayét waambule ye déku gaayémba yarékésén akwi du dakwat saapéndén, Jisas dat yandén muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas néma gu kwaawuna nak sakumba waambule ye saambakndéka akwi du dakwa déké kaavére dé vétake mawulé tawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Yaténdaka du nak Jisaské yaandén. Déku yé Jairus wa. Dé wani gaayémba kwaakwa Gotna kundi bulndakwa gaana néma du téndén. Dé ye Jisasét waandé daae kwaati séte anga wandén, “Wuna takwanyan ani kiyaaké yarékwa. Léku kaa rékaamba yamba wa (12). Wuna nyaan nakurak male wa. Méné ma yaa wunale sékét. Ye lé kururéménék.” Naandéka dale sékét yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Jisas yéndéka asa du dakwa wa dale sékét yéndarén. Yaambu vékulékén. Yéténdaka taakwa nak Jisasna kukmba yaae déku laplap waambumba vatndékulén. Kaa késépéri (12) wa lé waaléramu yarélén. Némaamba apu wa doktaké yélén lé kururéndarénngé. Yéléka dokta yapatin. Yandaka wani taakwa Jisas kundi wandaka vékute lékét léku mawuléké anga walén, “Wuné Jisasna laplapmba vatndékumunaae, wuné nakapuk yékun yakawutékwa.” Naatake déku kukmba yaae déku laplap waambumba vatndékulén. Wani taakwa wunga vatndékuléka waaléramu bari wurétékndéka nakapuk yékun yalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Vatndékuléka Jisas wa wan, “Wunat kandé vatndékwak?” Naandéka de akwi anga wandarén, “Nané yamba wa.” Wunga wandaka Pita wa wan, “Néman Du, asa du dakwa a ménale tékéskwa, méné yanyaweye. De ras ménat baka vatndéku daré yak, kapuk yénga véké?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naandéka Jisas wa wan, “Yamba wa. Nak baan nak wuna mayé apa kéraaké watake wa vatndékundén wunat. Yandaka vékuwutén wuna mayé apa ras yéndéka.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wunga wandéka lé wani taakwa léku mawuléké anga walén, “Jisas wuna mawulé véndén wa.” Wunga watake lé bérutéte yaae Jisas ténale képmaamba waandé daae kwaati sélén. Yate akwi du dakwana ménimba anga walén, “Kaa késépéri (12) waaléramu yare wuné yékun yaké watake wa taambat vatndékuwutén ména laplapmba. Vatndékwe wa bari nakapuk yékun yawutén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wunga waléka lat anga wandén, “Nyéno, wuné nyénat kururéké yawutékwa mayé apaké yékunmba vékulakate wa bulaa nyénékét wa yékun yanyénén. Nyéna mawulé yénga yékun téndu yékunmba ma yényénu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wayéka téte waténdéka du nak Jairusna gaamba yaandén. Yaae Jairusét anga wandén, “Ména takwanyan wa kiyaan. Méné wani néma du yaandénngé waké yambak. Dé déku nak jémbaa yénga yandu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wunga wandéka Jisas wani kundi vékute Jairusét anga wandén, “Wup yaké yambak. Wuné lé yékun yaké yawutékwa mayé apaké yékunmba vékulakaménu ména takwanyan yékun yakalékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naatake ye wani duna gaamba saambake wandén, “Pita, Jon, Jems, guné léku aapa aasa waak, guné male wunale sékét wulaa-kangunéngwa gaat. Nak du dakwa katik wulaaké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Naandéka akwi wamba tékésén du dakwa wani takwanyanngé mawulé sémbéraa yatéte géraaténdarén. Géraandaka det anga wandén, “Géraaké yambak. Lé yamba kiyaae wa. Lé yundé wa kwaalékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kiyaasékéyaklén vétake wa wunga wandéka dat waangindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Waangindaka dé wulaae léku taambamba kutte lat anga wandén, “Nyéno, ma waarap.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naandéka léku kwaminyan nakapuk waambule yaandéka bari waaraplén. Waarapléka Jisas det anga wandén, “Kakému ras ma kwayéngunu kalu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naandéka bét léku aapa aasa lat vétake vatvat naambérén. Naambéréka bérét anga wandén, “Ani muséké nak du dakwat waké yambak.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas déku dunyanét waandéka yaandaka det mayé apa kwayéndén, de wandaru akwi kutakwa yaange yéndarénngé. Nak mayé apa waak kwayéndén de wandaru baat yakwa du dakwa, sépémaalé maan taamba kapére yan du dakwat waak kururéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kwayéte det anga wandén, “Guné ye du dakwat ma wangunék Got néma du rate deké yékunmba véké yandékwanngé. Yate guné de kururéké ya.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Watake det anga wandén, “Guné yeyé yaayate rékaamba musé kure yéké yambak. Wani saawungunén musé male kwaandu guné yéké ya. Sétongunéngwa baangé, kaluwut, kakému, yéwaa, guné wani musé asé kure yéké yambak. Guné laplap vétik kure yémbak. Du dakwat yékun yangunu de gunat yékun yate wani musé kwayékandakwa gunat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gaa nakmba wulaae wani gaamba male guné yaréké ya. Naknga nakngat yéngunu taale yaréngunén gaamba yarékwa du wani muséké rakarka yamuké taale wulaangunén gaamba male guné yaréké ya. Yare wani gaayémba jémbaa yatake wani gaa yaasékatake guné nak gaayét yéké ya. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Guné gaayé nakét yéngunu wani gaayémba yarékwa du dakwa guna kundi vékukapuk yate, gunat kuk kwayéndaru, wani gaayé ma yaasékangunék. Yaasékaké yate guna maanmba kwaakwa baawu yasnyéputitake guné yéké ya. Wunga yangunu de vétake wakandakwa, ‘Nané det kapére wa yananén. Sérémaa Got yananén kapéremusé yakata-kandékwa nanat.’ Naakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wunga wandéka ye akwi gaayémba yeyé yaayaténdarén. Yeyé yaayate Gotna kundi kwayéte baat yan du dakwa, sépémaalé kapére yan du dakwat waak kururé-wuréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Galili distrik du dakwana néma du Herot Jisas yan jémbaaké kundi vékundén. Déku jémbaa yandéka du dakwa ras déké anga wandarén, “Wa baptais kwayétake kiyaan du Jon wa nakapuk taamale wa waarapndén.” Wandaka ras wa wan, “Wa talimba yatan du Elaija wa.” Ras wa wan, “Gotna yémba kundi kwayétan du nak wa talimba kiyaae bulaa wa nakapuk taamale waarapndén.” Wunga wandaka Herot wani kundi vékundén. Vékundéka déku mawulé kapére yandéka vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yate wandén, “Wuné wawutéka wa Jonna maaka sékundarén. Bulaa nak duké a kundi vékuwutékwa. Wani du kiya du dé?” Wunga wate dé Jisas véké wate mawulé yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisasna dunyansé waambule yaae Jisasét yandarén akwi muséké wandarén. Wandaka de kure wani taalé yaasékatake dekét de male Betsaidat yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yéndaka asa du dakwa wa wani muséké kundi vékutake déku kukmba yéndarén. Ye déké yaandaka dé vétake deké mawulé yate det wandén, Got néma du rate du dakwaké yékunmba véké yandékwanngé. Watake baat yan du dakwat kururé-wuréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Garambu yandéka déku dunyansé yaae dat anga wandarén, “An du dakwa yarékapuk taalé a. Ma waménu ani du dakwa gaayémba ye kakému ras kéraae katakekét kwaandarék.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naandaka det wandén, “Det kakému gunékét guné wa kwayéké yakwa.” Naandéka wandarén, “Nané kakému rékaamba yamba yé wa. Makal bret taambak rakwa. Gumba kutndarén gukwami vétik wungat male rakwa. Nané ye wani du dakwaké akwi kakému ras kéraananénngé méné mawulé yo, kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Némaamba (5,000 pulak) du téndaka wa wunga wandarén. Dakwale nyambalésale waak némaamba wa téndarén wamba. Jisasna dunyan wunga wandaka det anga wandén, “Det ma wangunu kémba kémba (50, 50) pulak kutetéke rakésndaru.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naandéka wandén pulak yandaka akwi du dakwa kémba kémba (50, 50 pulak) kutetéke randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rakésndaka Jisas makal bret taambak gukwami vétik wunga kéraae nyérét yaasore véte Gorét wandén, “Yéku musé a tiyaaménén. Yékun wa.” Naatake bret bulésote gukwami jémbusote déku dunyanét kwayéndén, de du dakwat muni waate kwayéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kwayéndaka du dakwa de akwi kurkasale kandarén. Kandaka bret gukwami ras baka randéka kémbi tambavétik maanmba kaayék vétik (12) waandandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nak nyaa Jisas kapmang rate Gorale kundi bulréndén. Yaréndéka déku dunyansé déké yaandarén. Yaandaka det waatakundén, “Du dakwa wunéké yénga daré wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wunga waatakundéka wandarén, “Ménéké ras wa wakwa, ‘Wa baptais kwayétan du Jon wa.’ Naandaka ras wa wakwa, ‘Wa talimba yatéte Gotna yémba kundi kwayétan du Elaija wa.’ Naandaka ras wa wakwa, ‘Gotna yémba talimba kundi kwayétan du nak kiyaae wa taamale waarapndén.’ Naandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naandaka det wandén, “Wa guné? Wunéké yénga guné wo?” Naandéka Pita wa wan dat, “Méné nanat yékun yaménénngé Got wan du Krais wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita wunga wandéka Jisas déku dunyansat anga wandén, “Ma vékusék naangunu. Guné nak duwat anga waké yambak, ‘Jisas wan nanat yékun yandénngé Got wan du Krais wa.’ Wunga waké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naatake det anga wandén, “Wuné Duna Nyaan a téwutékwa. Wunat kapérandi musé yandaru Israelna néma dunyan, Gotna gaamba jémbaa yakwa dunyanna néma dunyan, apakundiké vékusékngwa dunyan, de wunga wunat kuk kwayékandakwa. Kwayéndaru wuné viyaandaru kiyaakawutékwa. Kiyaawutu nyaa vétik yéndu kupuk yambanmba nakapuk taamale waarap-kawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Watake det akwi anga wandén, “Guné wunale yaate wuna jémbaa yaké mawulé yamunaae, anga ma yangunék. Apapu nyaa guna mawulé ma yaasékangunék. Yaasékate guné wunéké vékulakate anga ma wangunék, ‘Nané déku jémbaa yapéka-kanangwa. Yate nané kaangél kutte takwemimba kiyaamunaananu wa baka musé wa. Yénga yakét. Wan néma musé yamba wa.’ Wunga wate wuna jémbaa ma yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wunéké vékukwa du dakwa wuna jémbaa yaréndaru wuna maama det viyaamunaandaru de wunale yékunmba yarépéka-kandakwa apapu apapu. Wunéké vékulakakapuk yakwa du dakwa deku sépéké male vékute deku jémbaa male yamunaate wa lambiyak-ngandakwa. Wunale katik yarépékaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ani képmaana musé asé kéraaké yakwa du dakwa, deku jémbaa male yamunaate, kiyaae yénga pulak téké daré? Yamba wa. Kurkale katik téké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","De wuna kundi kalik yate wunat kuk kwayékwa apu sérémaa Duna Nyaan wuné waambule yaae det kuk kwayékawutékwa. Wani sapak wuné wuna aapamba mayé apa kéraae déku kundi kure gaayakwa dumba waak mayé apa kéraae nyaa yaalate kaalékwa pulak ye gaayakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gunat a wawutékwa. Guné amba tékwa du ras wayéka kiyaakapuk téte vékangunéngwa, Got néma du rate déku du dakwaké yékunmba véndu.” Naandén déku dunyansat Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas wani kundi watake kukmba nyaa taambak kaayék kupuk (8) pulak yéndéka Pita, Jon, Jems de kéraae kure némbat waaréndén. Jisas Gorale kundi bulké watake wa waaréndén némbat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waare Gorale kundi bulréndéka déku méni taama saawi waalakwe nak pulak yaalan. Déku laplap waamamale yasékéyake kalkal naatan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yandéka talimba yatéte Gotna yémba kundi kwayétan du Moses ambét Elaija, Gotna gaayémba bari gaaye bét mayé apa ye nyaa véte kaalékwa pulak téte Jisasale sékét bultémbérén. Dé Gotna kundi vékute Jerusalemmba kiyaaké yandékwanngé wa bulténdarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yaténdaka Pita ambét dale sékét yaan du vétik waak deku ménimba yundé yandéka de yundé kwaan. Kwaae vélérkiyaae waarape véndarén Jisasna sépé nyaa kaalékwa pulak véte kaaléndéka wani du vétik dale sékét témbéréka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ye bét yéké yatémbéréka Pita wani kundi yékunmba vékusékngapuk ye wa Jisasét anga wandén, “Néman Du, nané amba yarénanu yékun yaké yakwa. Gaa kupuk kaakanangwa. Ménan nak, Mosesnan nak, Elaijanan nak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wunga waréndéka buwi nak taawe yaae det taakatépéndén. Yandéka wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yandaka kundi nak awula buwimba anga waan, “Wan wuna nyaan wa. Wuné dat wawutéka wa yéndén gunéké. Guné déku kundi ma véku.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wani kundi wandéka vékutake véndarén Jisas kapmang téndéka. Vétake kundi mu ras yamba bulndakwe. Ye wani nyaa véndarén muséké akwi du dakwat yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nak nyaa némbu yaasékatake daawulindaka asa du dakwa wa Jisaské yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yaae dele sékét yaan du nak némaanmba waandén, “Néman Du, ménat waatakuwutékwa, wuna dunyanngu nyaanét véménénngé. Wuné nyaan nakurak male wa. Nyambalésé ras yamba yé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kutakwa wa dat kulure kure yatéte viyaaléka rékaamba waawakndékwa. Yate dat yaavan kutléka biyaat déku tépngémba yaalakwa. Dé yaasékatake yémuké kalik yate, déku sépé yaavan kutlékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yaléka ména dunyansat waatakuwutén, wani kutakwa wandaru yaange yélénngé. Wawutéka wunga yaké yapatindarén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Naandéka Jisas wa wan, “Yénga pulak dé? Guné wunéké yékunmba yamba vékulaka-ngunéngwe wa. Guna mawulé yékunmba yamba te wa. Késépéri baapmu gunale yatéwutéka wunéké yamba yékunmba vékulaka-ngunéngwe wa. Ma kure yaa ména nyaan.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wunga wandéka wani nyaan wayéka yéténdéka lé wani kutakwa dat viyaate taakusorak-léka daae képmaamba vaakétndén. Vaakétndéka Jisas wani kutakwat waarute nyaarang naae lat wandén, lé wani nyaan yaasékatake yaange yélénngé. Wandéka yaange yéléka wani nyaan yékun yandéka déku aapat kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yandéka wamba tékésén du dakwa wani jémbaa vétake Gotna mayé apaké vatvat naate vékulaka vékulaka naandarén. Wani du dakwa Jisas yan akwi muséké wayéka vékulaka vékulaka naaténdaka, Jisas déku dunyansat anga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Guné waan taake kurkale ma vékusék naangunu. Yaréyaré naae wuné Duna Nyaan maamat kwayéndaru maamana taambamba rakawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wunga wandéka Got wani wambukundi paakundéka de wani kundiké ras mu ras yamba vékusékndakwe wa kurkasale. Ye wani kundiké Jisasét waatakuké wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisasna dunyansé dekét deku kapmang bulte deku néma duké waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Waarundaka Jisas deku mawulé véwurésékéyaktake nyaanét nak kure yaae kure téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Téte det anga wandén, “Ma véku. Guné wunéké vékulakate ani nyaanét yékun yate, wa wunat waak wa yékun yangunéngwa. Guné wunat yékun yate, wunat wandéka yaawutén duwat waak wa yékun yangunéngwa. Gunale yaréte dékét déku yé kavérékngapuk yate gunéké jémbaa yakwa du Gotna ménimba dé néma du wa téndékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas wani kundi wandéka Jon dat anga wandén, “Néma du, du nak ména yémba wandéka kutakwa yaange yéndaka vénanén. Dé nanale yamba yeyé yaayaténdékwe wa. Yandéka dat watépénanén, wani jémbaa yakapuk yandénngé.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naandaka Jisas det wandén, “Guné wani jémbaa yandénngé watépéké yambak. Gunat kuk kwayékapuk yakwa du, wa guna du wa yaréndékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Got Jisas déku gaayét kure waaréké yandékwa nyaa yaaké yandéka Jisas dékét déku mawulémba vékulakate Jerusalemét yéké mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ye du rasét wandéka de taale déku kundi kure yéndarén. Ye Samariamba tékwa gaayé nakmba waaréndarén, déké musé asé kéraatakaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yandaka wani gaayémba tékwa du dakwa vékuwuréndarén Jisas Jerusalemét yaaké yandékwanngé. Vékutake de Jisaské kalik yate wandarén, “Yamba yé wa. Dé nana gaayét katik yaaké dé.” Naandarén. Samaria du dakwa Juda du dakwa deku néma gaayé Jerusalemngé waak kalik yate wa wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wandaka Jisasna du vétik Jems ambét Jon vékutake Jisasét anga wambérén, “Néman Du, mawulé yaménu aané watu Gotna gaayémba yaa gaaye ani du dakwat yaanngandékwa. Aané wunga yaténngé méné mawulé yo kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wunga wambéréka waalakwe bérét wandén, “Yamba wa. Wunga yaké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Watake déku dunyan sékét nak gaayét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas déku dunyansale sékét yaambumba yéténdaka du nak yaae Jisasét anga wandén, “Wuné ménale yeyé yaayatéké mawulé yawutékwa. Yéména akwi taalé wuné yékawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naandéka Jisas déku mawuléké wandén, “Wani du wandén pulak kalmu yaké dé?” Wunga vékulakate dat anga wandén, “Ma vékulaka kurkale. Waaléwasa képmaamba tékwa képmakwawumba wa kwaandakwa. Api deku kwaatmba wa kwaandakwa. Duna Nyaa wuné kwaana gaa nak yamba te wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naatake nak duwat anga wandén, “Méné ma yaa wunale.” Naandéka wandén, “Néman Du, taale ma yi naaménu ye yaréwutu wuna aapa kiyaandu déku pusaa kéraae rémngawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Naandéka dat wandén, “Yamba wa. Méné bulaa male ma yaa wunale. Wuna kundi vékukapuk yakwa du dakwa de kiyaan du pulak wa yaténdakwa. De wani apu kiyaan du dakwat yénga rémndaru. Méné bulaa male wuna jémbaa yate du dakwat kundi ma kwayéménu, Got néma du rate deké yékunmba véké yandékwanngé.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wunga wandéka dé nak du wa wan Jisasét, “Néman Du, wuné ménale yékawutékwa. Ma yi naaménu taale wuné wuna gaayét ye wuna kémét taamba kurkawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naandéka dat wandén, “Du dakwa Gorké jémbaa taale baasnyé ye kukmba nak nak jémbaaké vékulakamunaae, wa de Gotna jémbaa yaké yapati-kandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kukmba dunyan rékaamba (72) waak Jisas wakandéng-ndéka yaandarén. Yaandaka det anga wandén, “Guné taale vétik vétik wunga ma yéngunu. Wuné kukmba yéké yawutékwa akwi gaayét guné taale ma yéngunu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wunga watake det anga wandén, “Yaawimba asa kakému wa yékun ye tékéskwa. Téndéka dunyansé ayélapkéri male wa jémbaa yaréndakwa. Yékun yan kakému wan Gotna kundi vékuké mawulé yakwa du dakwa pulak wa. Got dé wani yaawina du pulak wa. Guné Gorét ma waataku, dé wandu jémbaa yakwa du rékaamba waak gunale jémbaa yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Bulaa gunat wawutékwa, wuna jémbaa yangunénngé. Waaléwasa sipsipét yaavan kutndakwa pulak, du ras gunat wunga yaavan kurkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Guné yéwaa, wut waak kure yéké yambak. Guné su saawuké yambak. Guné yaambumba yéte bari yéngunék. Nak du dakwale baka bulké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Guné gaat nak wulaae, taale wamba rakwa du dakwat anga guné waké ya, ‘Guna mawulé yénga yékun téndu.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wunga wangunu de wamba rakwa du dakwa gunéké mawulé yandaru, Got det yékun yandu de yékunmba yarékandakwa. Wamba yarékwa du dakwa gunéké mawulé yakapuk yate gunat kuk kwayéndaru, wa Got det katik yékun yaké dé. Got gunat yékun yandu guné yékunmba yarékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Taale wulaangunén gaamba male ma rapékangunu. Nak nak gaat wulaaké yambak. Wani gaamba rate de kwayékwa kakému kulak ma kangunék. Wani kakému kulak kéraakangunéngwa, dele yangunén jémbaaké. Wani gaamba re kukmba ma yéngunu nak gaayét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Guné gaayé nakmba ye waaréngunu wamba yarékwa du dakwa gunéké mawulé yandaru, guné kwayéndakwa kakému ma kangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yate wani gaayémba baat ye rakwa du dakwat ma kururéngunu. Yate det ma wangunék, ‘Got néma du rate du dakwaké véké yandékwa nyaa a yaae kwambalikwa.’ Ma naangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","“Guné gaayé nakmba ye waaréngunu wani gaayémba yarékwa du dakwa gunéké kalik yamunaandaru, guné ye wani gaayéna yaambumba téte anga guné waké ya, ‘Nané guné kuk kwayénangwa. Got waak gunat kuk kwayéndékwa. Kuk kwayé-ndékwanngé guné vékusék-ngunénngé wa nané ani gaayémba tékwa baawu nana maanmba kwaandéka viyaaputénanga wa véngunéngwa. Guné ani muséké vékusék-ngangunéngwa. Got néma du rate du dakwaké yékunmba véréké yandékwa nyaa a yaae kwambalikwa. Yandéka guné déku kémba gwaandéké wa kalik yangunéngwa.’ Det wunga ma naangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wani gaayémba yarékwa du dakwaké gunat wawutékwa. Talimba Sodommba tan du dakwa kapéremusé yandarén. Kukmba Got néma kot vékute néma du randa nyaa dé wandu Sodommba tan du dakwa kaangél kurkandakwa. Du dakwa nanat kuk kwayémunaandaru, wani nakurak kapéremusé wa Sodommba tan du dakwa yan kapéremusat taalékéra-kandékwa. Wani nyaa Got wandu nanat kuk kwayén du dakwa néma kaangél kurkandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wani kundi watake Jisas anga wandén: “Guné Korasinmba tékwa du dakwaké sémbéraa yawutékwa. Guné Betsaidamba tékwa du dakwaké sémbéraa yawutékwa. Wuné guna gaayémba yaréte vékapuk yangunén kulé apanjémba wa yawutén. Yawutéka wa véngunén. Vétake Gorké yékunmba yamba vékulaka-ngunéngwe wa. Tairmba talimba tan du dakwa Saidonmba talimba tan du dakwa waak Gorké vékusékngapuk ye, wani kulé apanjémba vémunaae, wa de talimba yandarén kapéremuséké kalik yatake, wani kapéremusé yaaséka-katik daré. Yandarén kapéremuséké kalik yate nak du dakwa deku mawuléké véndarénngé de jaangwa laplap saawuwe baawumba rakatik daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kukmba Got néma kot vékute néma du randa nyaa dé wandu de wani talimba Tairmba tan du dakwa, Saidonmba talimba tan du dakwa waak de kaangél kurkandakwa. Guné Korasinmba tékwa du dakwa Betsaidamba tékwa du dakwa waak, guné wuna jémbaa vétake wunat kuk kwayéngunén. Kuk kwayéngunénga wani nakurak kapérandi musé de yan akwi kapérandi musat wa taalékérandén. Wani nyaa Got wandu guné néma kaangél wa kurkangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Guné Kaperneammba tékwa du dakwa guné apapu anga wangunéngwa, ‘Nané Gotna gaayét waarékanangwa.’ Wunga wangunénga gunat wawutékwa. Got wandu guné kapérandi taalat daawuli-kangunéngwa. Guné Gotna gaayét katik waaréké guné.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wunga watake déku dunyansat anga wandén, “Guna kundi vékuna du dakwa wa de wuna kundi vékukandakwa. Gunéké kuk kwayéna du dakwa wa de wunat kuk kwayékandakwa. Wunat kuk kwayéna du dakwa wa de wuné wani wandéka gaayawutén duwat kuk kwayékandakwa.” Naandén. Wunga wandéka wa déku dunyansé déku kundi kwayéké yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kukmba wani késépéri (72) dunyan Jisas wan jémbaa yatake mawulé yate nakapuk waambule yaandarén. Yaae dat wandarén, “Néman Du, nané ména yémba wananga akwi kutakwa nana kundi vékundarén. Vékute du dakwa yaasékate yaange yékéraandarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Naandaka det wandén, “Guné wunga yangunénga nyétmba kusnyérak yandéka yaa gaayakwa pulak, Satan anjorémba re gaayandéka véwutén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ma véku. Gunat mayé apa wa kwayéwutén. Kwayéwutén mayé apat guné kaambe, kulaapati waak vaakingunu gunat katik yaavan kurké daré. Gunat kwayéwutén mayé apa wa Satanna mayé apat taalékéra-kandékwa. Yandu dé gunat katik yaavan kurké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Akwi kutakwa guna kundi vékundaka guné wani muséké mawulé yangunéngwa. Wani muséké guné vékulaka vékulaka naaké yambak. Ani muséké ma vékulaka. Guné Gotna kémba yaalangunénga dé guna yé déku nyéngaamba wa viyaandén. Wani muséké vékulakate mawulé tawulé ma yangunék.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wani sapak Gotna Yaamambi Jisasna mawulémba wulaandéka dé mawulé yate Gorét anga wandén, “Méné wuna aapa, méné nyét béré képmaana néma du wa. Ména jémbaa ras paakuménénga némaamba muséké vékusékngwa du dakwa ména jémbaa yamba kurkale vékusékndakwe wa. Némaamba muséké vékusékngapuk yakwa du dakwa, deku mawulé nyambaléséna mawulé tékwa pulak téndéka yékéyaakmba wa yaréndaka det ména jémbaa wa wakwasnyéménén. Ména mawulémba vékulakate wa wunga yaménén. Yékun wa wunga yaménén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Gorét wunga watake anga wandén, “Wuna aapa déku jémbaa, déku mayé apa waak wa tiyaandén wunat. Wuné déku nyaan yatéwutéka du dakwa wuné kurkale yamba vésékndakwe wa. Dé male wa vésékndén wuné. Du dakwa déké kurkasale yamba vékusékndakwe wa. Wuné male wa dé vésékwutén. Déké wawutén du dakwa waak dé vésékndarén wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Wunga watake déku dunyan male téndaka waalakwe det anga wandén, “Gotna jémbaaké gunat wawutékwa. Gotna yémba talimba kundi kwayétan dunyan, néma du waak, de a yawutéka véngunéngwa jémbaa véké mawulé ye, yamba véndakwe wa. Yate a wawutéka vékungunéngwa kundi de yamba vékundakwe wa. Got gunat yékun yandéka wa wani jémbaa véngunén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wani kundi wandéka apakundi yakwasnyékwa du nak déku mawuléké anga wandén, “Jisas wuna kundi waambule wate kalmu sépélak waké dé?” Wunga vékulakate dat anga wandén, “Gotna jémbaaké nanat yakwasnyékwa du, yénga pulak ye wuné kulémawulé kéraae apapu kurkale yarésékéyakngé wuté?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wunga waatakundéka dat wandén, “Kamu kundi dé guna apakundimba kwaau? Gotna nyéngaamba yénga daré viyaatakak?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naandéka wandén, “Guné guna Néman Du Gorké néma mawulé ma yangunu. Yate dat wangunu guna sépé, guna mayé apa, guna mawulé, guna kwaminyan, guna yaamambiké dé néma du rakandékwa. Guné guna sépéké mawulé yangunéngwa pulak, nak du dakwaké wunga ma mawulé yangunu. Yate det ma yékun yangunu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wunga wandéka dat wandén, “Wan yékun wa waménéngwa. Méné wunga ye wa kulémawulé kéraae apapu yékunmba yarésékéyak-ngaménéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas wunga wandéka wani du mawulé yandén, du dakwa déku yé kavérék-ndarénngé. Yate Jisasét anga waatakundén, “Yani du dakwat yékun yaké wuté?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wandéka Jisas déku kundi waambule wate anga wandén, “Juda du nak Jerusalem taakatake Jerikot daawuliké watake yéndén yaambumba. Yéténdéka sél yakwa du ras dé yaambumba véndarén. Ve dé kulkiye déku musé asé kéraate dé viyaae kapére ye yaambumba taakandarén. Viyaatake yéndaka dé yaambumba kwaae kiyaaké yakwandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yakwandéka wani sapak Gotna gaamba jémbaa yakwa du nak wani yaambumba yéndén. Ye wani duwat vétake dé aarkémba tepuwe dé yaasékatake dé yén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yéndéka Gotna gaamba jémbaa yakwa nak du, Livai du waak ye dat vétake yaasékatake aarkémba tepuwe yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Yéndéka Samaria du nak wani yaambumba ye wani du kwaanmba saambakndén. Wa vékusék-ngunéngwa. Juda du dakwa de kalik yandakwa Samaria du dakwaké. Samaria du saambake Juda du wamba kwaandéka vétake déké mawulé sémbéraa yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yate ye dat wani viyaandarénmba waasé yakwasnye marasin kure waasé gindén. Giye wani du kéraae déku donkimba kusore kure yéndén. Kure yéndéka yaambumba gaan yandéka saayéngat nak kure ye wamba taakatake dat yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gaan kwaae ganmba yéte wani gaana duwat yéwaa ras kwayéte dat anga wandén, ‘Méné ani duké kurkale ma véménék. Yate dat yékun yaké, ména yéwaa ras kwayéménu wuné waambule yaae ména yéwaa kwayékata-kawutékwa.’ Naatake yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Bulaa yénga méné vékwo? Du kupuk wa wani yaambumba yéndarén. Ye sél yakwa du viyaan duwat kandé yékun yak?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wunga wandéka dat wandén, “Déké mawulé sémbéraa yan du wa dat yékun yan.” Naandéka wandén, “Méné ma ye wunga ya dé yan pulak.” Naandén Jisas dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Jisas déku dunyansale sékét yéndarén. Ye gaayé nakmba waaréndarén. Wani gaayémba taakwa nak léku yé Marta, léku waayéka Mariale sékét yarémbérén. Yaréte Marta Jisasét walén, dé yaae bérku gaamba kakému kandénngé. Waléka yaae wulaae randéka léku waayéka Maria yaae Néman Du Jisasna maanale rate déku kundi vékurélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Vékuréléka Marta lé néma jémbaa yate kakému yaakélén. Yate Maria baka raléka véléka Martana mawulé kapére yan. Yandéka Marta yaae Jisasét anga walén, “Néman Du, wuna waayéka baka raléka wuné kapmang jémbaa yate kakému yaakéwutékwa. Yawutékwanngé yamba vékuménéngwe, yi? Ma waménu yaalu sékét yaakékatékwa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wunga waléka Néman Du wa wan lat, “Nyéno, Marta, nyéné rékaamba muséké vékulaka-nyénéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nyéné nakurak ani yéku muséké yamba vékulaka-nyénéngwe wa. Wuna kundi vékuké yanyénéngwa musé, wan yéku musé wa. Maria lé wani yéku muséké wa mawulé yalékwa. Yalu wuné lé yélénngé katik waké wuté. Lé wuna kundi vékuké mawulé yalékwa.” Naandén Jisas Martat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nak nyaa Jisas nak taalémba Gorale kundi bulréndén. Kundi bulsékéyaktake randéka déku du nak yaae dat anga wandén, “Talimba baptais kwayétan du Jon déku dunyansat yakwasnyéndén Gorét waataku-ndarénngé. Det yakwasnyéndén pulak méné nanat ma yakwasnyéménu, Gorét waataku-nanénngé. Wunga yaménénngé mawulé yanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naandaka det wandén, “Guné Gorét waatakuké mawulé yate anga ma wangunu: ‘Nana aapa, nané ména yé kavérékngé mawulé yanangwa. Méné néma du rate akwi du dakwaké kurkale véménénngé mawulé yanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yapatinangwa kakému nyaambanaku tiyaaménénngé ménat waatakunangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Du dakwa kapéremusé nanat yandaka nané wani muséké nakapuk vékulake yamba yakatanangwe wa. Yananu méné yananén kapéremusé wunga yasnyéputiye méné wani muséké nakapuk vékulakate yakataké yamarék. Méné nanat yékun yaménu nané nakapuk kapéremusé katik yaké nané. Wunga ménat waatakunangwa.’ Naangunu.” Wunga wandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Watake det anga wandén, “Guna du nak kalmu anga yaké dé? Du nak gaan yandéka nyéndéngan dé déku naawinduké yéndén. Ye gaa pétémba téte anga waandén, ‘Naawindu, kakému ras ma tiyaaménék. Wuna du nak bulaa nak gaayét yéké watake yaambumba yéte yaae wuna gaamba saambakndén. Yaandéka wuné kakému ras yamba rakése wa. Méné kakému ras wunat tiyaaménu méné nakapuk waambule kwayékata-kawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wunga waandéka déku naawindu awula gaamba kwaate wandén, ‘Bulaa wani musé aséké wunat waatakuké yambak. Pété tépéwutén wa. Wuna nyambalésé wunale yundé kwaakésndakwa. Wuné waarape bulaa kakému katik kwayéké wuté.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Guné a wawutékwa. Dé ‘Naawindu wa,’ naatake, waarape dat kakému katik kwayéké dé. Wani du déku pétémba téte waapékaténdu dé yundé kwaaké yate, waarape wani du mawulé yandékwa kakému dat kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Gunat a wawutékwa. Guné Gorét waataku-pékangunu dé gunat kwayékandékwa. Ani gwaaménja kundi ma véku. Guné waake waake vékangunéngwa. Guné pétémba viyaangunu viyaangunu pété naapikandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Du dakwa Gorét waatakundaru, det kwayékandékwa. Du dakwa waake waake vékandakwa. Du dakwa pétémba viyaandaru, pété naapikandékwa. Guné wani gwaaménja kundi vékute Gorét ma waataku-pékangunék. Waatakungunu dé guna kundi vékukandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ani kundi waak ma véku. Guné, aapambéré, guna nyambalésé gukwamiké waandaru, guné kaambet kéraae kwayéké guné det, kapuk? Yamba wa. Guné det gukwami wa kwayékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Guna nyambalésé sérangék kwayéngunénngé wandaru guné kulaapatit kéraae kwayéké guné, kapuk? Yamba wa. Guné det sérangék wa kwayékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bulaa wani kundiké ma vékulaka. Guné kapére mawulé yakwa dunyansé rate guna nyambalésat yéku musé wa kwayéngunéngwa. Anjorémba rakwa du guna aapa yéku mawulé yakwa du rate gunat akwi taalékérasande déku Yaamambi kwayékandékwa, dat waatakukwa du dakwat.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Du nakét kutakwa kulure kure yatéléka dé kundi yamba bulndékwe. Yandéka Jisas wani kutakwat wandéka wani du yaasékatake yaange yélén. Yaange yéléka dé nakapuk kundi bulndén. Bulndéka du dakwa wani muséké vékulaka vékulaka naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yandaka de du ras wa wan, “Akwi kutakwana néma du déku yé Belsebul wa Jisasna mawulémba wulaae tékwa. Téte mayé apa kwayéndéka wa wandéka kutakwa yaange yéndakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wunga wandaka ras dat anga wandarén, “Méné talimba vékapuk yananén kulé apanjémba nak yaménu vétake wakanangwa, ‘Méné Got déku jémbaa yaménénngé ménat wa wandén.’ Naakanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wunga wandaka Jisas deku mawulé vésékte det anga wandén, “Ani kundi ma véku. Néma gaayémba yarékwa dunyan mawulé vétik ye kém kutéke kémba kém rate waariyamunaae, de katik tésékéyakngé daré. Nakurak gaamba yarékwa du dakwa mawulé vétik ye deku kapmang waariyamunaae, de waak katik tésékéyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wani kundiké vékulakate akwi kutakwana néma du Satan, déku dunyan waak deké ma vékulaka. De mawulé vétik ye deku du dakwale waariyamunaae, de katik tésékéyakngé daré. Guné wunat wangunén pulak Satan déku du dakwa yaange yéndarénngé wamunaandu de katik tésékéyakngé daré. Satan wunga jémbaa yamba yandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Guné wunéké anga wangunéngwa. Akwi kutakwana néma du Belsebul wuna mawulémba wulaae téte wunat mayé apa tiyaandéka wa wawutéka kutakwa yaange yéndakwa. Naangunéngwa. Guna du ras waak wandaka kutakwa yaange yéndakwa. Wan paapu wa yangunéngwa. Guna du wunga yandaka guné det anga yamba wangunéngwe, ‘Belsebul guna mawulémba téte apa kwayéndéka guné wangunénga kutakwa yaange yéndakwa.’ Det wunga wakapuk yate wunat kamuké guné wunga wo? Wuné dele nakurak jémbaa yawutéka wuné wa véndarén. Guné wunéké paapu wa yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma véku. Got wunat mayé apa wa tiyaandékwa. Tiyaandéka wa wawutéka kutakwa yaange yéndakwa. Got wunat wunga mayé apa tiyaandénngé véte anga vékusék-ngangunéngwa. Got néma du rate du dakwaké véké yandékwa sapak wa yaan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","“Ani kundi ma véku. Kaawundu déku waariyandékwa musé kure déku gaaké séngiye ramunaandu déku musé asé akwi yékunmba rakéskandakwa. Yaréndu nak kaawundu dat taalékére kaawumama yakwa du yaae wani duwale waariye déku vi waariyandékwa ras musé waak kéraae déku musé asé waak kéraakandékwa. Kéraae wani musé asé nak duwat muni waate kwayékandékwa. Satan wani kaawundu pulak wa. Wuné dé taalékéran kaawumama du pulak wa. Wuna mayé apa wa Satanna mayé apat taalékéran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Wunale jémbaa yakapuk yakwa du dakwa de wuna maama wa. Wuné du dakwat wawutéka de wuna kémba téndakwa. Wuna du dakwat yékun yakapuk yakwa du dakwa de wuna du dakwat yaavan kutndakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wani kundi watake det anga wandén, “Ani kundi ma véku. Kutakwa du nakna mawulémba wulaae te yaasékatake yaale yélén. Ye maas viyaakapuk taalémba yarémuké taaléké waaklén. Waakpatiye walén, ‘Wuné talimba rawutén gaat waambule yékawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wunga watake waambule yaae vélén wani duna mawulé yékun yasékéyake baka téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Vétake ye kutakwa taambak kaayék vétik (7) we kure sékét yaalén. Kukmba kure yaalén kutakwasé yan kapéremusé wa taale yaan kutakwa yan kapéremusat taalékéran. Wani kutakwasé akwi wani duna mawulémba wulaakére tékésndarén. Talimba kutakwa nakurak déku mawulémba wulaae téléka wani du kapéremusé ayélap yandén. Kutakwa késépéri wulaakérandaka asa kapéremusé wa yandén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas wani kundi wandéka dale sékét tékésén némaamba du dakwa wani kundi vékundarén. Vékuténdaka wamba tan taakwa nak némaanmba waalén anga, “Talimba méné kéraae ménat munyaa kwayén taakwat Got yékun yandu lé mawulé tawulé yénga yarélu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wunga waaléka Jisas wa wan, “Yi wan wanana wa. Wani muséké vékulakaké yambak. Ani muséké ma vékulaka. Gotna kundi vékute wandékwa pulak yakwa du dakwat Got yékun yandu de mawulé tawulé yénga yaréndaru.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Asa du dakwa wa yaate jaawuténdaka wa Jisas det anga wandén, “Ani sapakmba tékwa du dakwa kapéremusé wa yatépékandakwa. Wunat waatakundakwa, wuné talimba vékapuk yandarén kulé apanjémba yate Gotna mayé apaké det wakwasnyéwuténngé. Gotna yémba kundi kwayétan du Jona yan pulak, nakpulak kulé apanjémba pulak male wuné waak yakawutékwa. Nak kulé apanjémba deké katik yaké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Talimba Jona Ninivet ye de yan kapéremuséké det wandén. Jona yan pulak yawutékwa. Duna Nyaan wuné ani sapakmba yatékwa du dakwat wawutékwa, de yandarén kapéremuséké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Talimba néma taakwa nak ani sékaa gaayémba yaae néma du Solomonna kundi vékuké kulémba yélén. Dé nyaangét pukaakwa du yaréndéka wuné amba téte gunale kundi bulkwa du wuné nyaangét pukaakwa du yatéte Solomonét wa taalékérawutén. Sérémaa Got néma kot vékute néma du randa nyaa wani néma taakwa waarape Gotna ménimba téte gunat anga wakalékwa, ‘Wuné animba sékaamba yaawutén. Yaae Solomonna kundi vékuwutén. Jisasna kundi wa taalékéran Solomonna kundit. Guné Jisasna kundi yamba vékungunéngwe wa. Wunga yate néma kapéremusé wa yangunén.’ Naakalékwa wani taakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Talimba Ninivemba tan du dakwa de Jonana kundi vékute yandarén kapéremusé yaasékandarén. Jona néma du téndéka wuné amba yatéte kundi bulkwa du wuné néma du yatéte Jonat wa taalékérawutén. Sérémaa Got néma kot vékute néma du randa nyaa Ninivemba tékésén du dakwa Gotna ménimba téte gunat anga wakandakwa, ‘Jona nanat Gotna kundi wandéka nané vékute yananén kapéremusé yaasékatake Gotna kundi kurkasale vékunanén. Jisas wa Jonat taalékéran. Ye gunat Gotna kundi kwayéndéka guné yangunén kapéremusé yaasékatake Gotna kundi yamba vékungunéngwe wa. Wunga ye guné néma kapéremusé wa yangunén.’ Gunat wunga wakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wani kundi watake det anga wandén, “Ani gwaaménja kundi ma véku. Du dakwa téwaayé yaa véréksowe kure yaae aké arulamba yamba kusole sapngutépéndakwe wa. De jaambétakumba wa taakandakwa. Taakandaka wamba yarékwa du dakwa de akwi kurkale véndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guna méni gaamba tékwa gaana pété pulak wa. Wani pété naapindaka gaamba nyaa kaaléndékwa. Guné yéku musé male vémunaangunu guna mawulé kurkale tékandékwa. Yandu guna sépé yékun téndu guné nyaa kaalétékwanmba yarékangunéngwa. Guné kapéremusé male vémunaangunu guna mawulé katik yékun téké dé. Guna mawulé yékun tékapuk yandu guna sépé yékun tékapuk yandu guné ganngumba yarékés-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Guné wunga yarékapuk yamuké ma jéraawu yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Guna mawulé kurkasale male témunaandu guné nyaa kaalékwanmba male yaréte yéku musé yate yékunmba yarékangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas wani kundi wasékéyakndéka wa Farisi du nak dat wandén, dé yaae dale sékét kakému kandénngé. Wandéka yaae déku gaamba wulaae dale sékét kaké watake randén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Deku apakundi wakwa pulak déku taamba taale yamba yakwasnyéndékwe wa. Jisas wunga yandéka wani Farisi du vétake vékulaka vékulaka naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yandéka Néman Du Jisas dat anga wandén, “Guné Farisi dunyan, aké, kasnya kuksaku male yakwasnyé-ngunéngwa. Biyaasaku yamba yakwasnyé-ngunéngwe wa. Yangunénga arula awula kapére yandékwa. Guné guna sépéké male vékute salmu walmu nak du dakwamba baka kéraate kapéremusé ras waak yangunénga guna mawulé kapére yandékwa, wani kasnyana biyaasaku kapére yakwa pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Guné waangété yakwa dunyan wa. Got guna sépé yatake guna mawulé waak yandén. Wunga yandénngé guné kurkale yamba vékungunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Guné yéku mawulé kéraae, musé asékapuk yan du dakwat musé asé ma kwayéngunék. Kwayéngunu guna mawulé yékun yakandékwa Gotna ménimba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Guné Farisi dunyansé guné vésék naa. Kapérandi musé gunéké wa yaakandékwa. Guné akwi musé asé muni waate tambék tambavétik (10) taakate nakurak tambék Gorké kwayéngunéngwa. Wunga kwayéte akwi nyénganyam waak muni waate yém tambavétik (10) taakatake nakurak yém Gorké kwayéngunéngwa. Nyénganyam wa néma musé yamba yé wa. Wan makalkéri musé wa. Guné wani makal muséké vékulakate guné ani néma muséké yamba vékulakangunéngwe wa. Guné nak du dakwat ma yékun yangunék. Guné Gorké néma mawulé ma yangunék. Guné guna salmu walmu muni waate yém tambavétik (10) taakatake nak yém Gorké kwayéngunéngwan wan yékun wa. Wani musé yaasékaké yambak. Wani makal musé yate wawutén néma musé waak yamunaae, yékun yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Guné Farisi dunyansé, guné vésék naa. Kapérandi musé gunéké wa yaakandékwa. Guné Gotna kundi bulnangwa gaamba wulaae néma duna taalémba raké mawulé yangunéngwa. Guné du dakwa jaawundakwa taalémba yeyé yaayangunu nak du dakwa gunat vétake anga wandarénngé wate yangunéngwa: ‘Wan de nana néma du wa.’ Wunga wandarénngé mawulé yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Guné vésék naa. Kapérandi musé gunéké wa yaakandékwa. Guné talimba kiyaandaka rémndarén kwaawu pulak wa. Kukmba yarékwa du wani kwaawu tékwa képmaatakumba yeyé yaayate rémndarén kwaawu vékapuk yandakwa pulak, wa nak du dakwa guna kapére mawulé yamba véndakwe wa. Yate de gunale sékét yaténdakwa. Yatéte Gotna ménimba kapére yandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas wani kundi wandéka apakundiké vékusékngwa du nak dat anga wandén, “Néma du, méné wunga wate nanat waak waaruménéngwa wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naandéka dat anga wandén, “Guné apakundiké vékusékngwa dunyan, guné ma vésék naa. Gunéké waak kapérandi musé yaakandékwa. Du nak néma vaak yakwa musé késépéri yaate téndéka, nak du yaae ras waak vaakutakandékwa pulak, wa guné néma jémbaa ras waak du dakwat kwayéngunéngwa. Kwayéte det anga wangunéngwa, ‘Guné ani apakundi akwi vékute wandékwa pulak ma yangunu.’ Wunga wangunénga de wani kundi vékute wandékwa pulak yaké néma jémbaa wa yandakwa. Yandaka deké mawulé sémbéraa yamba yangunéngwe wa. Yate det yékun yamba yangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Guné ma vésék naa. Kapérandi musé gunéké yaakandékwa. Talimba guna gwaal waaranga maandéka bakamu de Gotna yémba kundi kwayétan dunyansat viyaandékndarén. Ye rémndarén taalémba wa guné yéku musé yakusongunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Guna gwaal waaranga maandéka bakamu viyaandéke rémndarén duna taalémba wunga yéku musé yakusote anga wangunéngwa, ‘Nana gwaal waaranga maandéka bakamu yandarén muséké mawulé yanangwa.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wunga wangunéngwanngé, nyaangét vékupukaakwa du Got anga wandén, ‘Wuné wuna yémba kundi kwayékwa dunyan wuna kundi kure yékwa dunyansat waak wawutu de Israel du dakwaké yékandakwa. Yéndaru rasét yaavan kutte rasét viyaandék-ngandakwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Wandéka wunga yandaka wa véngunén. Talimba guna gwaal waaranga maandéka bakamungu Gotna yémba kundi kwayétan dunyansat wa viyaandékndarén. Taale Kein déku waayéka Abelét viyaandékndén. Got ani képmaa yatake yaréyaré naandéka Kein déku waayéka Abelét viyaandékndén. Viyaandékndéka de guna gwaal waaranga maandéka bakamu yéku musé yakwa dusat viyaandékndarén. Viyaandék-laakét viyaandék-laakét ye kukmba Sekaraiat viyaandékndarén. Dé Gotna gaa nyéndémba téndéka dé viyaandékndarén. Viyaandék-ndarénngé bulaa guné ani nyaa tékwa dunyan gunat wawutékwa. Got yandarén kapérandi muséké vékulakate guné deku gwaal waaranga maandéka bakamungu wunga kapérandi musé yangunénngé waak vékulakate, gunat némaamba yakata-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Guné apakundiké vékusékngwa dunyan, guné ma vésék naa. Kapérandi musé gunéké yaakandékwa. Guné Gorké yéndakwa yaambuké ayélap wa vékungunén. Vékute guné wani yaambumba yémuké kélik yangunén. Yate guné wani yaambumba yéké mawulé yakwa du dakwat watépéngunénga de wani yaambumba yamba yéndakwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Watake yéndéka de apakundiké vékusékngwa dunyan, Farisi dunyan waak deku mawuléké anga wandarén, “Dé nana kundi waambule wate kalmu kapére kundi ras waké dé? Wandu dé kotim-nganangwa.” Wunga wate dat waarute dale nakpulak nakpulak kundi bulndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Asa du dakwa wa yaae jaawuwe téndaka taalé vékulékén. Ye ras du wa vaakin ras duna maanmba. Vaakindaka Jisas taale ani kundi déku dunyansat wandén, “Ma vésék naangunék. Farisi dunyanséna yismba guné kurké yambak. Ani kundi wate paapu yandakwa yapatéké wa wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Paakundarén akwi musé asé sérémaa némaamba du dakwa vékandakwa. Yakélak wandarén akwi kundi sérémaa némaamba du dakwa vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ganngumba bulngunén kundi nyaa du dakwa vékukandakwa. Gaamba awula rate yakélak bulngunén kundi sérémaa kaapamba saapéndaru akwi du dakwa vékukandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wuna du dakwa, gunat anga wakawutékwa. Guné képmaana du nakngé wup yaké yambak. De guné viyaandéktake kukmba gunat katik yaavan kurké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anjorémba rakwa du Gorké ma wup yangunék. Képmaana du gunat viyaandékndaru Got guné yaanpékatékwa yaat vaanjandaké mayé apa yandékwa. Wanngé vékulakate Gorké ma wup yangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Anga wa vékusékngunéngwa. Du dakwa makalkéri yéwaa vétik kwayéte api taambak (5) kéraandakwa. Wani api wa makalkéri musé wa. Got wani apiké wa vékundékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Got gunéké waak wa vékulakandékwa. Guna maakamba tékwa némbé akwi naakiye wani némbéké waak wa véndékwa. Akwi musé asé wa véwuréndékwa. Véte gunéké yékunmba véndékwa. Véndékwanngé vékulakate guné wup yaké yambak. Api wan makalkéri musé wa. Du daakwa wan néma musé wa. Got makal sakal apiké yékunmba véte gunéké yékunmbaa-sékéyak wa vékandékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Watake det anga wandén, “Gunat wawutékwa. Du nak, du dakwana ménimba téte anga wamunaandu, ‘Wuné Jisasna du a.’ Wunga wandu sérémaa Duna Nyaan wuné Gotna gaayémba déku kundi kure gaayakwa dunyanséna ménimba téte det anga wakawutékwa, ‘Ani du an wuna du a.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Du ras, du dakwana ménimba téte nakurak nakurak anga wandaru, ‘Wuné Jisasna du yamba yé wa.’ Naandaru wuné Gotna gaayémba rate déku kundi kure gaayakwa dunyanséna ménimba téte det anga wakawutékwa, ‘Wani dunyansé wan wuna dunyansé yamba wa.’ Naakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Wuné Duna Nyaan wa rawutékwa. Du dakwa wunat wasélékte wunat kapére kundi watake wani kapére kundiké kalik ye sémbéraa yate yaaséka-munaandaru, Got wani kapéremusé yasnyéputi-kandékwa. Gotna Yaamambit wasélékte kapére kundi wamunaandaru, wa Got wani kapéremusé katik yakwasnyéputiké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Du ras gunat Gotna kundi bulndakwa gaat kure ye néma duké waak kure yéndaru guné deku ménimba téte, wup yakapuk yate, guna mawuléké anga waké yambak, ‘Yénga waké nané? Deku kundi yénga pulak waambule waké nané?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Guné wunga waké yambak. Wani nyaa Gotna Yaamambi gunat kwayékandékwa, waké yangunéngwa kundi.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Asa du dakwa wa Jisasale sékét tékésndarén. Dele tan du nak Jisasét anga wandén, “Néma du, wuna aanyat ma waménu dé aana aapana musé asé muni waate tambék wunat tiyaandénngé mawulé yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wunga wandéka wandén Jisas, “Kandé wak, wuné wani jémbaa bénéké yawuténngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naatake det anga wandén, “Guné vésék naa. Guné nak duna musé aséké jaambiké yambak. Némaamba musé kurerékwa duna mawulé katik yékun yaké dé. Du dakwa kulémawulé kéraae yékunmba yarésékéyakngé, de némaamba musé aséké katik vékulakaké daré.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wunga watake det gwaaménja kundi nak anga wandén, “Néma yéwandu nakna yaawimba asa kakému wa yékun ye tén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Téndéka wani yéwandu déku mawuléké anga wandén, ‘Wuna taanngét gaa némaamba yamba kwaakése wa. A bulaa yénga pulak yaké wuté?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wunga vékulakate wandén, ‘Bulaa anga yakawutékwa. Wuna taanngét gaa akwi péraae néma gaat kurkawutékwa. Kure akwi kakému, salmu walmu wamba taakakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taakatake wuna mawuléké wakawutékwa: Wuna asa yéku musé wa. Késépéri kaa wa téké yakwa. Témuké vékulakate bulaa yaap rakawutékwa. Wuné kulak kakému kate dusék yarékawutékwa. Wunga wate wuné yékunmba rakawutékwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Wunga wandéka Got dat anga wandén, ‘Méné waangété du wa. Bulaa ani gaan kwaae kiyaakaménéngwa. Kiyaaménu taakaménén musé asé akwi kandé kéraaké ya?’ Naandén Got dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Bulaa gunat wawutékwa. Ani képmaamba téte késépéri musé kéraae waawarkwa du dakwa de ani du pulak wa yaténdakwa. Yatéte Gotna ménimba gandéndu gandéndakwa pulak wa yaténdakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wani kundi watake Jisas déku dunyansat anga wandén, “Wani muséké vékulakate gunat wawutékwa. Guné wup yate kulak kakému laplapké waak vékula-laakaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kulak, kakému, laplap wan baka musé wa. Néma musé yamba yé wa. Guné wani muséké vékula-laakaké yambak. Got wandéka wa yaréngunéngwa. Guna sépé guna mawulé, guna kwaminyan yatakandéka wa yaréngunéngwa. Wan néma musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Guné apit ma vé. De kakému yamba yaanandakwe wa. De kakému yamba kéraandakwe wa. De kakému gaamba yamba taakandakwe wa. Yandaka Got wa det kakému kwayékwa. Api wan makalkéri musé wa. Guné du dakwa wan néma musé wa. Got apit wunga kakému kwayéndu, guné anga wakangunéngwa. ‘Nanat waak tiyaakandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma véku. Guna du nak, kwaaré ras waak yaréké vékula-laakamunaae, watake kwaaré ras waak kalmu yaréké dé, kapuk? Yamba yé wa. Déku kapmang watake kwaaré ras waak yaréké yapati-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Guné wani makalkéri musé yaké yapatite kamuké guné nak muséké vékulalaako? Guné wunga yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Guné maaweké ma vékulaka. Nané wani maawe yamba taawunangwe wa. De baka wa waaréndakwa. De jémbaa yamba yandakwe wa. De laplap yamba samapndakwe wa. Yandaka Got wa det yékun yandékwa. Det yéku nyaap wa kwayéndékwa. Talimba késépéri musé asé kure yatan néma du nak déku yé Solomon yéku laplap saawundén. Yate wani maawe saawukwa pulak yéku musé yamba saawundékwe wa. Maawe saawukwa yéku musé wa Solomon saawan yéku musat taalékéran. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Got wani maaweké kurkale véndékwa. Wani maawe ayélap tété naakandakwa. Bulaa téndakwa. Séré kiyaakandakwa. Kiyaandaru du dakwa wani maawe péle yaamba tukandakwa. Wan makalkéri musé wa wani maawe. Guné du dakwa néma musé wa. Guné Gorké yamba yékunmba vékulaka-ngunéngwe wa. Yate wup yate wangunéngwa, ‘Nanéké kurkasale kalmu véké dé kapuk?’ Wunga wate bulaa ma vékulakangunék. Got maawet wunga saawutakandu véte wakangunéngwa, ‘Nanat laplap tiyaakandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wunga wate guné wup yakapuk yate kanguna kakému, kanguna kulakngé, vékulaka vékulaka naaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","“Guné wunga yaké yambak. Anjorémba rakwa du guna aapa guné wani muséké yapati-ngunéngwanngé wa véndén. Baka yatékwa du dakwa wa wani muséké vékulaka vékulaka naandakwa. Guné de yakwa pulak wani muséké vékulaka vékulaka naaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ye guné Gotna kémba yaale déku jémbaa yaké mawulé tawulé yakangunéngwa. Wunga yangunu dé wani musé gunat kwayékandékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Watake déku dunyansat anga wandén, “Guné wuna dunyan, guné du ayélap wa. Guna aapa Got dé mawulé tawulé yandékwa, guné déku kémba téngunu dé néma du rate gunéké kurkale vémuké. Yandékwanngé guné wup yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guné guna musé asé kwayéte yéwaa ma kéraae musé asékapuk du dakwat kwayéngunu. Ani képmaamba wut jaangwa yandéka sél yakwa dunyan musé asé sél yandakwa. Biyaak musé asé kérék taakundakwa. Wunga yandaru guna musé akwi késkandékwa. Guné Gotna jémbaa kutte yéku jémbaa yangunu, sérémaa Got gunat waambule kwayékatate gunat yékun yandu guné dale yékunmba yarésékéyak-ngangunéngwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ani képmaamba musé asé waawattékwa du dakwa de ani képmaana musé aséké wa mawulé tawulé yakandakwa. Gotna gaayémba raké vékulakakwa du dakwa de dale sékét yékunmba rasékéyakngé wa mawulé tawulé yandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Ma vékusék naa. Wuné waambule yaawuta nyaaké ma kurkale kaavéréngunék. Ani gwaaménja kundi ma véku. Jémbaa yakwa dunyanna néma du dé taakwa kéraakwa duwale kakému kaké yéndén. Yéndéka déké jémbaa yakwa dunyansé déké vékulakate laplap giye yaa yamungate déké yékunmba kaavéréndarén, dé waambule yaae pétémba viyaandu de déké pété bari naapiké. Guné, wani dunyan pulak wa, wuné guna néma duké yékunmba ma kaavéréngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Deku néma du waambule yaamuké, déku jémbaa yakwa dunyan yékunmba kaavéréte de mawulé tawulé yate yékunmba rakandakwa. Deku néma du déké yékunmba kaavéré-ndarénngé vékundu déku mawulé det yékun yaké yakwa. Ye wandu rakandakwa. Randaru dékét déku kapmang jémbaa yakwa dunyanna jémbaa yate det kakému kwayékandékwa, de kurkale kandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dé nyéndéngan waambule yaae de kurkale kaavéréndaru véndu de mawulé tawulé yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Guné ani kundiké ma vékulaka. Gaana du sél yakwa du yaaké yakwa nyaaké vékusékmunaae, wa dé wani nyaa gaaké yékunmba séngiye kaavéré-munaandu, déku gaat katik wulaaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Guné, dé yanda pulak, guné waak ma kurkale kaavéréngunu. Guné yamba vékuséke wa. Wuné Duna Nyaan, yani nyaa waambule yaaké wuté? Vékusékngapuk yanguna nyaa wa waambule yaakawutékwa. Guné wunéké ma kurkale kaavéréngunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas wani kundi wandéka Pita anga wandén, “Néman Du, nanéké méné vékulakate wani gwaaménja kundi wo, kapuk akwi du dakwaké méné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naandéka Jisas wa wan, “Jémbaa yakwa dunyanngé kurkale séngite kaavétékwa du yéku mawulé vékute anga yakandékwa. Déku néma du dat anga wakandékwa, ‘Méné wuna jémbaa yakwa dunyanséké séngite kaavététe det kakému ma kwayéménu.’ Naatake yéndu dé wunga yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yaténdu kukmba déku néma du waambule yaae vétake wakandékwa, ‘Méné yéku jémbaa wa yaménén. Yékun wa.’ Wunga wandu dé mawulé tawulé ye yékunmba rakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Déku néma du yandén yéku jémbaat véte wakandékwa, ‘Méné waambule yaaké yawutékwa nyaaké vékusékngapuk ye, méné yéku jémbaa wa yaménén. Yékun wa. Bulaa méné wuna akwi musé aséké yékunmba vérékaménéngwa.’ Naakandékwa, yéku jémbaa yan duwat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Kapére mawulé yate kapére jémbaa yakwa du déku mawulémba anga wakandékwa, ‘Wuna néma du nak gaayét ye bari katik waambule yaaké dé.’ Wunga wate dé jémbaa yakwa du dakwat viyaate kakému némaamba kate, waangété kulak kate, waangété yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yate dé néma duké vékulakakapuk yaténdu wani sapak wa déku néma du waambule yaakandékwa. Vékukapuk yandékwa sapak wa waambule yaakandékwa. Yaae yandén kapérandi musé vétake det watakandu dé viyaandaru kiyaakandékwa. Kiyaae dé kapéremusé yan du dakwale kapérandi taalémba tékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Déku néma du mawulé yandékwa jémbaaké vékusékngwa du, dé wani jémbaa yakapuk yandu déku néma du watakandu dat némaamba viyaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Déku néma du mawulé yandékwa jémbaaké vékusékngapuk yan du, dé wani jémbaa yakapuk yandu déku néma du watakandu dat aal viyaakandakwa. Got du dakwa rasét késépéri jémbaa kwayéndéka késépéri jémbaa yandarénngé wa mawulé yandékwa. Got du dakwa rasét rékaamba jémbaa kwayéndéka déké rékaamba jémbaa yandarénngé wa mawulé yandékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wunga watake det anga wandén, “Wuné yaae ani képmaamba yaa pulak taakngawutékwa. Wani jémbaa yaké wa yaawutén. Wani jémbaa bari yasékéyakngé mawulé yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taale néma kaangél kurkawutékwa. Anga bari kurké mawulé yawutékwa. Kure yékunmba rakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Guné yénga guné vékulako? Akwi képmaamba tékwa du dakwa waariyakapuk ye baka yékunmba téndarénngé wuné yaak, kapuk? Yamba wa. Wuné yaanngé du dakwa ras wuna kundi vékundaru deku kém rakarka ye dele waariyakandakwa. Du dakwa ras wuné yaanngé wuna kundiké mawulé yandaru, ras wuna kundi kalik yate kémba kém kutéke tékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ye bulaa, sérémaa waak nakurak gaamba yarékwa du taambak, de nakpulak nakpulak mawulé yate kém vétik kutéke tékandakwa. Du kupuk nak kém pulak téndaru, du vétik nak kém pulak tékambérékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aapambéré deku dunyanngu nyaansale waariya-kandakwa. Aasambéré deku takwanyanngu nyaansale waariya-kandakwa. Yaawumbéré deku méyaasgwale waariya-kandakwa.” Naandén Jisas de déku kundiké mawulé yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wunga watake dale tékésén du dakwat anga wandén, “Néma wimut kutndéka vékute wangunéngwa, ‘Bulaa maas viyaakandékwa.’ Naangunénga maas viyaandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Guné gaan kun némaamba yaale téndéka véte vékulakate wangunéngwa, ‘Séré asa nyaa wa vékandékwa.’ Wunga wangunénga wa néma nyaa véndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Guné paapu yakwa du dakwa wa. Guné nyétmba yaalakwa musé képmaamba yaalakwa musé asat véte wangunéngwa, ‘Maas viyaakandékwa. Nyaa vékandékwa.’ Wunga wate kamuké guné yawutékwa néma jémbaa véte wunéké yamba wangunéngwe, ‘Dé nana Néman Du wa.’?” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisas wunga watake anga wandén, “Kamuké guné yéku muséké vékusékngapuk yo? Guné guna kapmang ma kurkale vékulake yéku muséké wangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Du ras gunat kotimngé yandaru guné dele sékét yaambumba yététe dele ma kundi bule yawuréngunu. Nakurakmawulé ma yangunu. Guné dele kundi yawurékapuk yangunu de gunat kot vékukwa néma duké kalmu kure yéndaru watakandu kalapusmba taakaké daré? Taakandaru guné wamba kwaasékéyak-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kot vékukwa néma du wani wandén yéwaa akwi gunat kotimngé yan duwat kwayétake, wani nyaa male kalapus yaasékatake yaale baka yékangunéngwa. Guné a wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wani sapak du ras Jisaské yaae dat anga wandarén, “Néma du Pailat wandéka déku dunyan Galili dunyan rasét viyaandékndarén. Wani du Gorké kwaami viyaae tuwe kwayéténdaka wani sapak wa Pailatna dunyan det viyaandék-wuréndarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wunga wandaka Jisas det anga wandén, “Galili dunyansé wunga kiyaandarénngé guné yénga guné vékwo? Wani dunyan némaamba kapéremusé yandaka, yandarén musé dé nak du yan kapéremusat taalékérak kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yamba yé wa. Guné a wawutékwa. Guné yan kapéremusé yaasékakapuk ye de kiyaan pulak guné waak wunga kiyaakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wa vékusék-ngunéngwa. Talimba Siloammba kwaan sémény gaa du rékaamba (18) tékésndarénmba vaakére det tendékndén. Bulaa yénga guné vékwo? Wunga tendékndén du yan kapéremusé dé Jerusalemmba tékwa nak du yan kapéremusat taalékérak, kapuk yénga pulak dé? ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yamba yé wa. Guné a wawutékwa. Guné yangunén kapéremusé yaasékakapuk yamunaae, wa de kiyaan pulak wa guné waak wunga kiyaakangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wani kundi watake Jisas ani gwaaménja kundi det anga wandén, “Kwambasék pulak miyé wa du nakna wain yaawimba tén. Téndéka késépéri apu wani du yaandén, sék ras géléké we. Yaate vépatikndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Vépatike wani wain yaawimba jémbaa yakwa duwat anga wandén, ‘Kwaaré kupuk sék vaakukwa sékétmba wuné ani miyémba sék ras géléké we wa yaawutén. Yaae vépatikwutén. Wani miyé ma vélé. Yéku képmaamba baka katik téké dé.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wunga wandéka wandén, ‘Néma du, wunga katik yaké té. Ani kwaaré waak déku mukét tékwak. Téndu wuné wani miyé maawumba képmaa vaae, képmaa yékun yandénngé bulmakauna diyé taakakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Taakawutu kalmu nak kwaaré sék vaakuké dé? Wunga vaakundu wan yékun wa. Vaakukapuk yandu vélékaménéngwa.’ Naandén.” Jisas wunga wandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yaap yaré nyaa nak Jisas Gotna kundi bulndakwa gaamba rate du dakwat Gotna jémbaaké kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kwayéréndéka kutakwa kulure kure yatan taakwa nak wamba yarélén. Wani kutakwa lat kulure kure yatéléka léku sépémaalé apa yakapuk yandéka léku bungul viyékén. Yandéka lé kayéndéng téké yapatilén. Asapéri (18) kwaaré wa wunga yarélén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yaréléka Jisas vétake wandéka yaaléka lat wandén, “Nyéno, bulaa wa yékun yanyénén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wunga watéte déku taamba wani taakwat kurké naandéka bari kayéndéng télén. Téte Gotna yé kavéréklén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisas yaap yaré nyaamba lat wunga yékun yatakandénngé Gotna kundi bulndakwa gaana néma du rakarka yandén. Ye wamba tékésén du dakwat anga wandén, “Nané jémbaa yanana nyaa taambak kaayék nakurak (6) wa. Guna sépémaalé kapére yandu gunat yékun yatakandénngé mawulé ye guné jémbaa yanangwa nyaamba ma yaangunu. Guné yaap yaré nyaamba wunga yaké yambak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wani du wunga wandéka Jisas anga wandén, “Guné wan paapu yakwa dunyansé wa. Akwi nyaa guné yéte bulmakau, donki, tékéskwa gaamba wulaate baangwi lékuyasnyéte det kure gwaandéngunéngwa, kulak kandarénngé. Yaap yaré nyaamba waak wani jémbaa yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abraham nana sékét gwaal waaranga maandéka bakamu wa lé waak nané waak. Satan kéraandéka lé déku taambamba asapéri (18) kwaaré yaréléka léku bungul wa rangwa yan. Yandéka wa yaap yaré nyaamba wuné lat yékun ye lé Satanna taambamba kéraawutékwan, wan yékun wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wunga wandéka de déku maama nékéti némbat yate yakélak rakésén. Rakésndaka wamba tékésén ras du dakwa wani yandén akwi yéku jémbaaké mawulé tawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Du dakwa wunga yandaka Jisas det anga wandén, “Got néma du rate du dakwaké kurkale véké yandékwanngé yénga wawutu vékusékngé guné? Yénga pulak ye déku makalkéri kém némaan ye néma kém téké dé? Wani muséké gunat wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wani kém wan miyé nakna sék pulak wa. Wani miyé sékna yé mastet wa. Mastet sék nak miyé sék pulak yamba wa. Wani miyé sék wan makalkéri sék wa. Du nak wani miyé sék kéraae yaawimba taawundén. Taawundéka wure némaan ye waare wani yaawimba tékéskwa miyat taalékérandén. Némaan ye téndéka api yaate wani miyé gaalémba kwaat séte randarén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wani kundi watake anga wandén, “Got néma du rate du dakwaké kurkale vékandékwa. Wani du dakwa kulémawulé kéraae kulé du dakwa yaalakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wani du dakwa wan de yis pulak wa. Taakwa nak yis kéraae plauale kulotlén. Kulotléka wani plaua akwi nak pulak yaalandén. Nak pulak musé yaalan pulak, Gotna du dakwa kulé du dakwa wunga yaalakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Watake wani gaayé taakatake Jerusalemét yéké yandén. Yatake wani yaambumba ye késépéri gaayét yéndén. Ye wamba némaamba du dakwat yakwasnyéndén Gotna jémbaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Yandéka du nak dat anga wandén, “Néman Du, késépéri du dakwa Gotna kémba wulaaké daré, kapuk ayélapkéri du dakwa male wulaaké daré?” Wunga waatakundéka wamba tékésan du dakwat anga wandén, “Apapu apapu yékunmba yarésékéyakna du dakwa deku gaayé aatmuna pété némaan yamba wa. Wani pété makalkéri wa. Gunat wawutékwa. Guné wani pétémba wulaaké we ma apa tapa yate néma jémbaa yangunék. Némaamba du dakwa wa wani pétémba wulaaké mawulé yate wulaaké yapatindakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wani gaayéna néma du waarape wani pété tépékandékwa. Tépéndu guné yaae kaapamba téte pétémba viyaate anga wakangunéngwa, ‘Néman Du, pété ma naapitaka nanéké.’ Wunga wangunu gunat anga wakandékwa, ‘Wuné yamba ve wa guné. Yani gaayé guné?’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Wunga wandu anga wakangunéngwa, ‘Nané ménale kulak kakému wa karénanén. Méné nana gaayéna yaambumba téte nanat kundi yakwasnyéménén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wunga wangunu gunat anga wakandékwa, ‘Gunat wawutékwa. Wuné guné yaan gaayé yamba véwutékwe wa. Guné kapéremusé yakwa du dakwa wa. Guné akwi wuné yaasékatake ma yéngunu.’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Wunga wandu kaapamba téte géraaté-kangunéngwa. Nana gwaal waaranga maandéka bakamu Abraham, Aisak, Jekop de wani Gotna yémba talimba kundi kwayétan akwi du waak det vékangunéngwa Gotna gaayémba rakésndaru. Véte guné wani gaayémba raké mawulé yate kaapamba téte némaamba géraaté-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yaténgunu de nyaa yaalakwa sakumba yaana du dakwa, nyaa daawulikwa sakumba yaana du dakwa, akwi taalémba yaana du dakwa yaae Gotna gaayémba wulaae rate kakému kakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gunat a wawutékwa. Bulaa baka yarékéskwa du dakwa sérémaa néma du dakwa tékéskandakwa. Bulaa ani sapak néma du dakwa tékéskwa apu sérémaa baka du dakwa tékéskandakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wani sapak Farisi dunyan ras yaae Jisasét anga wandarén, “Galilina néma du Herot méné viyaandékngé wate yandékwa. Wunga yandékwanngé méné ani gaayé ma yaasékatake méné ma yé nak gaayét.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wunga wandaka det anga wandén, “Guné ye wani paapu yakwa duwat guné anga waké ya, ‘Ma véku. Jisas anga wandékwa: Bulaa, séré, kutakwa wawutu yaange yékandakwa. Baat yakwa du dakwa, sépémaalé kapére yan du dakwat waak, wuné yékun yawurékawutékwa. Nyaa kupuk yandu wuna jémbaa yasékéyak-ngawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bulaa, séré, maa, wuné Jerusalemét yéndakwa yaambat yékawutékwa. Talimba Gotna yémba kundi kwayétan du Jerusalemmba viyaandékndarén. Wuné waak Gotna yémba kundi kwayétéwutékwanngé wunat Jerusalemmba viyaandék-ngandakwa.’ Guné wuna kundi wunga Herorét ma ye wangunék.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wunga watake wandén, “Guné Jerusalemmba tékwa du dakwa, guné Gotna yémba kundi kwayétan dunyansat viyaandékngunén. Got wandéka déku kundi kure yén dunyan gunéké wa yéndarén. Yéndaka guné det matut viyaangunénga kiyaandarén. Wuné mawulé sémbéraa yawutékwa gunéké. Séraa léku nyaanngé yékngaat taakatépe rate deké yékunmba vélékwa pulak, wuné apapu gunat yékun yate gunéké yékunmba véké mawulé yawutén. Yawutéka guné kalik yangunén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yangunénngé sérémaa dunyan ras yaae guna gaayé yaavan kurkandakwa. Yaavan kutndaru guné katik yaréké guné. Guna gaayé baka taalé male téké yakwa. Guné wunat bari katik véké guné. Sérémaa guné wunéké anga wakangunéngwa, ‘Got wandéka wa wani du yaandékwa. Nané déku yé kavérék-nganangwa.’ Wunga wangunu wuné yaawutu vékangunéngwa. Gunat wawutékwa. Yi wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yaap yaré nyaa nak Jisas Farisina néma du nakna gaamba kaké yéndén. Yéndéka déku gaamba rakésén dunyan vésék naaréte deku mawulémba anga wandarén, “Jisas kalmu jémbaa yaké dé yaap yaré nyaamba? Jémbaa yamunaandu, wan kapére wa.” Wunga wate dat véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yaténdaka maan taamba wulén du nak Jisasna ménimba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Téndéka Jisas wani duwat vététe apakundiké vékusékngwa dunyansé, Farisi dunyansat waak waatakundén, “Nana apakundi yénga dé wo? Yaap yaré nyaamba nané sépémaalé kapére yan du dakwa kururéké nané kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wunga waatakundéka de yakélak yakélak tékésén. Yandaka Jisas wani duwat kururétake wandéka dé yén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yéndéka det anga wandén, “Guné waak yaap yaré nyaamba jémbaa yangunéngwa. Guna nyaan nak yaap yaré nyaamba gu vékuléke téndu wani kavérémba ye vaakére daawuliye téndu bari kéraaké guné dé kapuk? Guna bulmakau yaap yaré nyaamba gu vékuléke tékwa kavérémba ye vaakére daawuliye téndu yaap yaré nyaamba dé bari kéraaké guné kapuk? Yaap yaré nyaamba kéraakangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wunga wandéka déku kundi waambule kaataké yapatindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas véndén, wani kakému kaké yaan dunyan yaate néma duna taalémba male raké mawulé yandaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Vétake ani gwaaménja kundi det wandén, “Du nak taakwa kéraate kakému yaake kaké yate gunat waandu guné ye kurkale ma vékulakangunék. Vékulakate néma duna taalémba raké yambakate. Guné néma duna taalémba ramunaangunu kalmu néma du ras kukmba yaandaru, gunat wani waan du yaae gunat anga waké dé? ‘Guné wani yéku taalé ani duwat ma kwayéngunék.’ Wunga wandu guné nékéti némbat yate wani taalé néma duwat kwayétake guné du dakwana kuksékéyakmba rakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Guné dele kakému kaké ye kurkale vékulaka naae ma du dakwana kuksékéyakmba rangunu. Wunga yangunu gunat wani waan du yaae gunat anga wakandékwa, ‘Wuna du, guné ma yaae néma duna taalémba ra.’ Wunga wandu guné ye néma duna taalémba rangunu wani gaamba yarékéskwa dunyan de guna yé kusorékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ani muséké vékulakate wani muséké wa wawutékwa. Dekét deku yé kavérékngwa du dakwa sérémaa Got wandu de baka du dakwa wa tékandakwa. Deku yé kavérékngapuk yakwa du dakwa sérémaa de Got wandu néma du dakwa wa tékandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wani kundi watake dale kakému kandénngé wani waan duwat anga wandén, “Méné kakému yaake kaké yate ména du dakwa, ména aanyémbéré, ména waayékanjet, ména du kémét, ména gaayémba rakwa yéwandu baléndut waaké yambak, de yaandarénngé. Méné wunga dunyansat waaménu de sérémaa yaakéte ménat waandaru yéménu wani waambu kwayékata-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Méné wunga yaké yambakate. Méné kakému yaake kaké yate wani musé asé kurerékapuk du, sépémaalé kapére yan du, maan taamba kapére yan du, méni kiyaan duwat ma waa, de yaandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wani dunyan de ménat kakému kwayékataké yapati-kandakwa. Méné det wunga yaménéngwanngé sérémaa Got ménat yékun yakandékwa. Got wandu yéku musé yatake kiyaan du dakwa nakapuk taamale waarapngé yandakwa sapak dé ménat yékun yandu méné yékunmba rakaménéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dele rate kakému karan du nak wani kundi vékutake Jisasét anga wandén, “Gotna gaayémba rate kakému kaké yakwa dunyan de yénga mawulé tawulé yandaru.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wunga wandéka Jisas wa wan, “Du nak néma paat yaakékwate we yandén. Ye késépéri duwat waandén, de yaae wani kaawungwiya kandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yatake kakému kandara sapak yaandéka déku jémbaa yakwa duwat wandén, talimba waandén dunyanséké ye ani kundi wandénngé, ‘Musé asé akwi kéraae waawattakananga tékwa. Guné ma yaa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Dé ye det wandéka de akwi yéké kalik yandarén. Ye du nak wa wan dat, ‘Wuné képmaa tambék kéraawutén wa. Kéraatake bulaa wanngé véké yékawutékwa. Wuné wunga katik yaaké wuté.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wunga wandéka nak du wa wan, ‘Wuné jémbaa yamuké bulmakau tambavétik (10) kéraawutén wa. Kéraatake wuné a ye de yakwe vékawutékwa. Wuna jémbaa kurkale kalmu yaké daré, kapuk yénga pulak yaké daré? Wuné wunga katik yaaké wuté.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wunga wandéka nak du wa wan, ‘Wuné bulaa kakét a taakwa kéraaréwutékwa. Yénga pulak ye yaawuték, taakwa kéraawuténmba?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“De wunga wandaka dé wani jémbaa yakwa du nakapuk waambule ye déku néma duwat wani muséké wandén. Wandéka wani du rakarka yandén. Ye déku jémbaa yakwa duwat anga wandén, ‘Méné ani gaayémba rakéskwa akwi yaambumba ye méné musé asé kurerékapuk du, sépémaalé kapére yan du, méni kiyaa du, maan taamba kapére yan du det ma kure yaa.’ Wunga wandéka wani jémbaa yakwa du ye wandén pulak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ye waambule yaae déku néma duwat wandén, ‘Néma du, wuné ména kundi vékutake waménén pulak wa yawutén. Yawutéka taalé ras baka tékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wunga wandéka dat anga wandén, ‘Méné akwi yaambumba, némbumba waak yéte baka du dakwat ma we kure yaaménu. We kure yaaménu wuna gaa taalé vékulékndénngé mawulé yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bulaa gunat a wawutékwa. Talimba waawutén du dakwa de akwi wuna kakému katik kaké daré. De wuna kakému kandarénngé kalik yawutékwa.’ Néma du wunga wandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Némaamba du dakwa Jisasale yéténdaka waalakwe det anga wandén, “Guné wuna jémbaa yate wuna du dakwa raké mawulé ye guné wunéké néma mawulé ma yangunék. Guné guna aasa aapa, guna du dakwa, guna nyambalé, guna aanyé waayéka nyangenguké néma mawulé yate wunéké ayélapkéri mawulé yamunaae wuna jémbaa katik yaké guné. Wunéké yanguna mawulé nak du dakwaké yangunéngwa mawulat taalékérandu, wa guné wuna jémbaa ye wuna du dakwa tékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Guné anga wangunu, ‘Jisasna jémbaa yapéka-kanangwa. Yate kaangél kutte takwemimba kiyaananu wan baka musé wa. Wan néma musé yamba wa.’ Wunga watake guné wungat male ye wa guné wuna du dakwa tékangunéngwa. Guné wunga wakapuk ye, wunga yakapuk ye guné katik wuna du dakwa téké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wuna jémbaa yaké yate taale ma kurkale vékulaka. Ani kundi ma véku. Guna du nak néma sémény gaa nak kurké mawulé ye taale dé rate kurkale vékulaka-kandékwa, wani gaana yéwaaké. Kalmu wani gaa késké dé, kure randékwa akwi yéwaamba, kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Taale wunga kurkasale vékulakakapuk ye kwaat taawundu yéwaa késndu gaa baka kutsékéyakngapuk téndu akwi dunyan véte wasélékte waangikandakwa wani duwat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Waangite anga wakandakwa, ‘Wani gaa baasnyé ye kutténdéka yéwaa késndéka kutsékéyakngé yapatindén.’ Naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ani kundi waak ma véku. Néma du nak vékundén. Nak néma du déku waariyakwa dunyansale yaandarén, dele waariyaké. Vékutake dele waariyaké yate taale kamu musé yaké dé? Taale rate dé anga wakandékwa, ‘Wuna waariyakwa du ayélapkéri wa. Déku waariyakwa du némaamba wa. Yénga pulak ye det viyaaké nané? De kalmu nanat viyaaké daré?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wunga vékulake wakandékwa, ‘Nané dele waariyaké yapati-kanangwa.’ Wunga we kurkale vékulake dé du rasét wandu de ye wani yaaké yakwa néma duwale kundi bulkandakwa, de kundi bule giye ye waariyakapuk yamuké. Wani néma du ani sékaa taalémba téndu dé du rasét wandu deké yaae kundi bulkandakwa, de kundi bule giye ye waariyakapuk yamuké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wunga watake Jisas det anga wandén, “Wani du yan pulak guné ma yangunék. Guné wuna jémbaa yate wuna du dakwa raké mawulé ye taale ma kurkale vékulaka. Guné guna musé asé kuk kwayétake wani muséké nakapuk katik mawulé yaké guné.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisas wunga watake anga wandén, “Ma véku. Dakwa sol yaasnyéndakwa, kakému résék yandénngé. Sol wan yéku musé wa. Sol résék yakapuk yandu yénga pulak yandaru nakapuk résék yaké dé? Yamba wa. Nakapuk katik résék yaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yandu kakémumba katik yaasnyéké daré. Résék yakapuk yakwa sol wan yéku musé yamba yé wa. Képmaamba yaasnyémunaandaru kakému kurkale katik waaréké dé. De wani sol baka vaanjati-kandakwa. Guné baka vaanjatindara sol pulak ramuké kalik ye, wani kundiké vékusékngé mawulé ye kurkasale waan taake ma kurkale vékungunék.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nak nyaa takis kéraakwa dunyanale, kapéremusé yakwa du dakwa ras waak Jisas ténét yéndarén, déku kundi vékuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yéndaka Farisi dunyan apakundiké vékusékngwa dunyan waak wani muséké kalik yate anga wandarén, “Wani du dé kapéremusé yakwa du dakwale yatéte dele kakému kandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wunga wandaka det ani gwaaménja kundi wandén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kalmu guna du nak anga yaké dé? Du nak sipsip dumi taambak (100) kureréndén. Kureréndéka nak lambiyakén. Yandéka ras sipsip yéku taalémba taakandéka téte katéndaka det yaasékatake ye wani lambiyakén nakurak sipsipké waakndén. Waake waake véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Vétake kéraae déku taanmba taake yaate mawulé tawulé yalakét yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ye gaayémba saambake du dakwat wandéka yaae jaawundarén. Jaawundaka det anga wandén, ‘Guné wunale ma mawulé tawulé yangunék, wuna sipsip nak lambiyakndéka waake ve kéraawuténngé.’ Naandén det.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wunga watake Jisas anga wandén, “Gunat wawutékwa. Wunga yandén pulak Gotna kundi kure gaayakwa du mawulé yakandakwa. Yéku musé yate Gotna ménimba kurkasale yarékwa némaamba du dakwaké Gotna kundi kure gaayakwa dunyansé mawulé yakandakwa. Kapéremusé yan du wani yandén kapéremusé yaasékandu Gotna kundi kure gaayakwa dunyansé mawulé tawulé yakandakwa.” Jisas kapéremusé yakwa du dakwale téndéka dunyan ras dat waarundaka det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wani kundi watake Jisas det gwaaménja kundi nak waak anga wandén, “Kalmu guna taakwa nak anga yaké lé? Lé yéwaa tambavétik (10) kure yarélu nak lambiyakndu lé téwaayénngéra yavéréke taake gaa yaakwe taapiye waake waake wani yéwaa vékalékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ve kéraae wani gaayémba yarékwa du dakwat waalu yaae jaawukandakwa. Jaawundaru det wakalékwa, ‘Guné wunale ma mawulé tawulé ya, wuna yéwaa nak lambiyakndéka waake ve nakapuk kéraawuténngé.’ Wunga det wakalékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wunga watake Jisas det anga wandén, “Gunat wawutékwa. Wunga yalén pulak Gotna kundi kure gaayakwa dunyan mawulé yakandakwa. Kapéremusé yakwa du wani yandén kapéremusé yaasékandu, de Gotna kundi kure gaayakwa dunyansé mawulé tawulé wa yakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Watake Jisas gwaaménja kundi nak anga wandén: “Du nak nyaan vétik kureréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kukmba kéraandén nyaan bérku aapat anga wandén, ‘Méno, sérémaa kiyaaménu aané ména musé asé kéraakatékwa. Kéraamuké wa ménat wawutékwa. Ména yéwaa, musé asé muniye wunat tiyaaké waménén musé asé bulaa male wunat ma tiyaaménu.’ Naandén. Wunga wandéka déku yéwaa, akwi musé asé muniye bérét kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kwayéndéka déku wani kukmba kéraan nyaan yaré yaré naae déku musé asé akwi nak duwat kwayéte yéwaa kéraandén. Kéraae kure sékaamba tékwa gaayé nakét yéndén. Ye wani gaayémba yaréte déku yéwaa akwi yaasnyéwuréndén, yandén kapérandi musé asémba. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yaasnyéndéka déku yéwaa akwi késndéka yaréndéka kukmba wani gaayémba néma kaandé yan. Yandéka dé kakémuké yapatindén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yapatiye ye wani gaayémba yaran du nakmba jémbaa yandén. Yaténdéka wandéka ye déku baalat kakému kwayéténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Akwi du dakwa dat kakému yamba kwayéndakwe. Yandaka kaandale yaréte baalé wani kakwa kakému kaké wate yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wunga yate déku mawulémba vékulakandén. Vékulakate anga wandén, ‘Wuna aapaké jémbaa yakwa akwi dunyan de asa kakému wa kandakwa. Kandaka biyaa yandéka kakému ras baka tékwa. Téndéka wuné amba yaréwutéka wunat asa kaandé wa yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yénga yakét, a waarape wuna aapaké waambule yékawutékwa. Ye dat anga wakawutékwa: “Wuné Gorét kapéremusé wa yate, ménat waak kapéremusé wa yawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yawuténngé vékulakate méné wunat, ‘Wuna nyaan wa,’ naaké yamarék. Yéku musé yakwa nyaan ramunaawutu wunat wunga wakatik méné. Kapéremusé yawuténngé méné wunat anga ma wa, ‘Wuna jémbaa yakwa du wa.’ Naaménu wuné ména jémbaa yakwa dunyanale ména jémbaa yakawutékwa.” Wunga wakawutékwa wuna aapat.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wunga watake déku aapaké waambule yéké mawulé ye yaambumba yéndén. “Wani du ye awula apakmba yaaténdéka déku aapa dat véndén. Véndéka déku mawulé sémbéraa yan déké. Sémbéraa yandéka pétépété ye déku nyaanét kaarangwe méni réng taama réng yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yandéka déku nyaan wa wan dat, ‘Aapa, wuné Gorale ménale bénat wa kapéremusé yawutén. Yawuténngé vékulakate méné wunéké, “Wuna nyaan wa,” naaké yambak. Yéku musé yakwa nyaan yarémunaawutu wunat wunga wakatik méné.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Wunga wandéka déku aapa déku jémbaa yakwa dunyansat waandéka yaandaka det anga wandén, ‘Wuna nyaan a waambule yaan. Wuné déké mawulé tawulé yawutékwa. Guné yéku laku laplapét ma bari kéraae kure yaae dat gitakangunu. Yate ring déku taambamba kusolatakate su déku maanmba saawutaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yatake guné wulén bulmakau nyaanét nak ma kure yaae viyaangunu. Viyaae yaake katéte mawulé tawulé yate dusék yakanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wuné déké wuna mawulémba anga wawutén, “Dé wa kiyaan.” Wunga waréwutéka bulaa dé wa waambule yaan. Talimba anga wawutén, “Dé wa lambiyakén.” Wunga watake bulaa vénanén yaandéka. Vétake waambule yaandénngé nané kate mawulé tawulé yakanangwa.’ Wunga wandéka déké mawulé tawulé yate kakému kure yaae waawatndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wani duna néma nyaan dé yaawimba tén. Te kukmba waambule yaae gaamba saambakngé yatéte vékundén kaang viyaate kétindaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Vékutake jémbaa yakwa du nakét waandéka yaandéka dat anga waatakundén, ‘De kamu musé daré yo?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wunga waatakundéka wani jémbaa yakwa du wa wan, ‘Ména waayéka nakapuk waambule yaandéka wa ména aapa déké mawulé tawulé yate wandéka wulén baan bulmakau nyaan nak wa viyaandarén. Viyaae katéte wa mawulé tawulé yandakwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wunga wandéka néma nyaan dé rakarka ye wulaaké kalik yandén. Yandéka déku aapa ye gwaande dat gaat wulaandénngé wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wandéka aapat anga wandén, ‘Ma véku. Késépéri kwaaré wa wuné baka jémbaa yakwa du pulak ména jémbaa yawutén. Yate ména kundi kurkasale wa vékuwutén. Ména kundi nak yamba kalik ye kuk kwayéwutékwe. Yawuténngé méné wunat yéku musé nak yamba tiyaaménéngwe wa. Meme nyaan nak yamba tiyaaménéngwe, wuna du dakwale kate mawulé tawulé yananénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wunga pulak makal musé wunat tiyaakapuk ye ména nak nyaan waambule yaandéka déké mawulé tawulé yate wulén baan bulmakau wa viyaaménén. Dé ména musé asé, yéwaa wani yaambumba yatékéskwa dakwat kwayéte akwi yéwaa yaasnyéwuréndén. Wunga yandénngé méné déké mawulé ye wulén baan bulmakau nyaanét wa viyaaménén, de kate mawulé tawulé yandarénngé.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wunga wandéka aapa wa wan, ‘Nyaan, apapu nyaa gaan aané vétik male a yarétékwa. Wuna akwi musé asé wan ména musé male wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ména waayéka dé ye késépéri kwaaré wa nak taalémba yaténdén. Yaténdéka wuna mawuléké anga wawutén, “Dé lambiyakék, kapuk dé kiyaak?” Wunga wate vékulakaréwutéka dékét bulaa waambule yaandéka wa vénanén. Wanngé vékulakate mawulé yate mawulé tawulé yakanangwa yékun wa.’ Aapa déku néma nyaanét wunga wandén.” Naandén Jisas. Jisas kapéremusé yakwa du dakwale téndéka du ras waarundaka wa wani gwaaménja kundi kupuk det wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kukmba Jisas déku dunyansat ani gwaaménja kundi wandén: “Du nak némaamba yéwaa saawule ran duna muséké séngite véténdén. Yaténdéka du ras yaae wani néma duwat déku muséké wani séngite vétékwa duké anga wandarén, ‘Ména muséké vététe tékwa du dé kurkasale yamba jémbaa yandékwe wa. Yate ména yéwaa nak du dakwat baka kwayéndékwa.’ Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naandaka déku muséké wani séngite vétékwa duwat wandéka yaandéka dat anga waatakundén, ‘Ménéké vékuwutén kundi ras yénga pulak dé? De wa wakwa, méné kurkasale jémbaa yakapuk yate wuna yéwaa nak du dakwat baka kwayéménéngwanngé. Yéku kundi daré wo, kapuk papukundi daré wo? Méné wuna musé, wuna yéwaa akwi naakiye nyéngaamba viyaae wani nyéngaa wunéké ma kure yaa. Yatake méné wuna jémbaa nakapuk katik yaké méné.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Wunga wandéka dé wani muséké séngite vétékwa du déku mawuléké anga wandén, ‘Wuna néma du dé wuné déku muséké nakapuk séngite vétéwuténngé kalik yandékwa. Bulaa kamu yaké wuté? Wuné kaambi vaaké yamba apamama yawutékwe. Wuné nak duwat yéwaaké yaawimuké wup yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A vékulakawutén. Nak pulak ye wuna néma du déku jémbaa yaasékatake yéwuténngé wandu ye de wuna dunyansé yaréte wandaru wuné deku gaamba wulaae dele yarékawutékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naatake déku néma dumba yéwaa kéraan dunyansat waandéka de nak nak yaandarén. Yaandaka taale yaan duwat anga wandén, ‘Méné wuna néma dumba musé katik méné kéraak? Katik kwayékataké méné?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wunga wandéka wandén, ‘Némaamba (100) kulak tékwa néma aké.’ Wunga wandéka muséké séngite vétékwa wani du dat anga wandén, ‘Wani musé akwi kwayékataké yambak. Kwayékataména yéwaaké viyaandén nyéngaa dé a rakwa amba. Méné rate bari nak kundi nak wani nyéngaamba ma viyaa. Méné ayélapkéri (50) male ma viyaaménék.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Wunga watake nak duwat wandén, ‘Méné wuna néma dumba musé katik méné kéraak? Katik kwayékataké méné?’ Wunga wandéka wandén, ‘Késépéri (100) bek wit.’ Naandéka wandén, ‘Wani musé akwi kwayékataké yambak. Kwayékataména yéwaaké viyaandén nyéngaa dé a rakwa amba. Méné nak kundi nak wani nyéngaamba ma viyaa. Ayélapkéri (80) male ma viyaaménék.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wunga wandéka yandéka kukmba wani néma du kundi vékundén, déku muséké séngite vétékwa du, du vétik bét dat kukmba yékun yambérénngé, wunga paapu yandéka. Vékutake wandén, ‘Yéki. Wani kapéremusé yakwa du déku sépat yékun yaké watake wa yékunmba vékulakandén.’ Déké wunga wandén.” Wani kundi watake Jisas déku dunyansat anga wandén, “Anga vékuséknangwa. Ani képmaana muséké mawulé yakwa du deku sépéké male vékulakandakwa. Vékulakate de nak du dakwat yékun yandakwa, de waambule yakatate det yékun yandakwanngé. Wunga yate yékunmba vékulakandakwa. Wani muséké deku yéku mawulé Gotna du dakwana yéku mawulat wa taalékérandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Gunat a wawutékwa. Guné yéku jémbaa yakangunéngwa guna yéwaale, ani képmaana nak musale waak. Guné wani musé asale jémbaa yate du dakwat yékun yangunu de guna du dakwa rakandakwa. Randaru sérémaa guné kiyaae Gotna gaayémba wulaae yékunmba rakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Makalkéri jémbaa yékunmba yakwa du dakwa de néma jémbaa waak yékunmba yakandakwa. Makalkéri jémbaa sépélak yakwa du dakwa de néma jémbaa waak sépélak yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Guné ani képmaana yéwaaké jémbaa sépélak aapélak yare yénga pulak Gotna muséké jémbaa yékunmba yaké guné? Yamba wa. Gotna muséké jémbaa yékunmba yaké yapati-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Guné nak duna muséké jémbaa sépélak yare yénga pulak ye Got gunat rapékakwa musé kwayéké dé? Yamba yé wa. Katik kwayéké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Du nak néma du vétikngé jémbaa yaké yapati-kandékwa. Wunga jémbaa yare, wa dé nak néma duké mawulé tawulé yate nak baanngé kalik yakandékwa. Guné wani du pulak wa yaréngunéngwa. Guné néma du Gorké jémbaa yate déké male vékulaka-munaare, wa guné déké apapu mawulé tawulé yakangunéngwa. Yate guné yéwaa kéraaké katik vékulakaké guné. Guné apapu apapu yéwaa kéraaké male vékulakamunaare, wa guné néma du Gorké wa kalik yakangunéngwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi dunyansé wani kundi vékutake yéwaaké néma mawulé yate Jisasét wasélékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yandaka det anga wandén, “Guné duna ménimba apapu yéku musé yangunéngwa, de gunat véte anga wandarénngé, ‘Guné yéku musé yakwa apu wa.’ Naandarénngé wunga yangunénga Got guna mawulé wa véndén. Guna mawulé yékun tékapuk yandéka véte wa gunat kuk kwayéndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Talimba Moses ani képmaamba yaténdén sapakmba yaae yaae baptais kwayétan du Jon yatan sapak waak akwi du dakwa de Moses wan apakundi vékute Gotna yémba kundi kwayétan duna kundi waak vékute wandén pulak wa yandarén. Bulaa wuné du dakwat waak wa wawutén, Got néma du rate du dakwaké yékunmba véké yandékwanngé. Wawutéka némaamba du dakwa wa déku kémba yaalaké wate néma jémbaa wa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moses wan apakundi katik késké dé. Sérémaa nyét béré képmaa késndu wani kundi katik késké dé. Yamba yé wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Dunyan deku taakwa kewuréndaka yéndaka nak taakwa kéraandakwan wa de kukmba kéraandakwa taakwale kapéremusé wa yandakwa. Dunyan deku taakwa kewuréndaka yéndaka nak du wani taakwa kéraandakwan de wani taakwale kapéremusé wa yandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wani kundi watake Jisas anga wandén det, “Talimba némaamba musé kure yaran du nak yaréndén. Déku waayékanje taambak (5) yaréndarén. Akwi nyaa dé yéku yéku siot yéku gwaavé laplap waak saawundén. Yate akwi nyaa yéku yéku kakému kandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Musé asé kurerékapuk du nak waak yaran. Déku yé Lasarus. Apapu nyaa déku du wa dat yaatate yéndarén wani némaamba musé kure yaran duna gaat. Yaate kure yéte gaa pétale taakandaka kwaaréndén. Déku sépé waasémama wurésape téndéka apapu waasa ras wa yaate déku waasémba biyaakndarén. Dé némaamba musé kure yaran duna gaa pétale kwaate wani du kakému kandéka wani képmaamba vaakére rakéskwa kéla kakému kaké wa mawulé yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kukmba dé wani gandéndu Lasarus kiyaan. Kiyaandéka Gotna kundi kure gaayakwa du dé kure ye Abrahamale taakandarén. Yandaka dé wani némaamba musé kure yaran du waak kiyaandéka rémndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yandaka dé ye wani yaa yaanpékatékwa taalémba téte kaangél kutténdén. Kuttéte yaasawure véndén Abraham Lasarusale anjoré kulémba rambéréka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Vétake némaanmba waandén, ‘Wuna gwaal waaranga maandéka bakamu Abraham, ani taalémba yaa wuna sépémba yaandéka wuné asa kaangél a kuréwutékwa. Kuréwutékwanngé méné wunéké ma mawulé sémbéraa yate Lasarusét waménu dé kulak ras kure yaae wuna tékiyaalémba taakandu.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wandéka Abraham wa wan, ‘Méno, méné ma vékulaka. Talimba képmaamba téte asa yéku yéku musé wa kure téménén. Yatéménénga Lasarus wunga yamba yandékwe wa. Déké kapérandi musé male yaan. Bulaa dé yéku taalémba yékunmba randéka méné kapérandi taalémba téte kaangél wa kuttéménéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ani muséké waak ma vékulaka. Aané rakwanale méné rakwanale nyéndémba Got néma kaambi nak taakandéka wa tékwa. Yandéka amba rakwa du méné rakwanét yéké naate yapatindakwa. Wamba rakwa du waak anga yaaké yapatindakwa.’ Naandén Abraham. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Wani kundi vékute némaamba musé talimba kure ran du wa wan, ‘Wunga ye wunéké vékulakaké yambak. Wuna waayékanje taambak (5) wa ani yaréndakwa wuna aapana gaamba. Méné wuna gwaal waaranga maandéka bakamu, ménat waatakutékwa. Lasarusét ma waménu deké yéndu. Ye det ani rawutékwa kapérandi taaléké kundi kwayéndu. De waak ani taalat yaae néma kaangél ka kutndara.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wunga wandéka Abraham wa wan, ‘Yamba wa. Moses wan apakundi, Gotna yémba kundi kwayétan duna kundi waak Gotna nyéngaamba wa kwaakwa. Wani kundi véte de yénga vékusékndaru.’ Naandén Abraham. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Wani kundi wandéka Abrahamét anga wandén, ‘Wuna gwaal waaranga maandéka bakamu, yamba wa. De deku kundi katik vékuké daré. Kiyaan du nak taamale waarape ye det saapéndu, wa vékukandakwa. Vékute wani yandarén kapérandi musé yaaséka-kandakwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wunga wandéka Abraham wa wan, ‘De Moses wan apakundi Gotna yémba talimba kwayétan duna kundi waak vékukapuk ye de kiyaae taamale waarapén duna kundi waak katik vékuké daré.’ Naandén Abraham.” Jisas wunga wandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Jisas déku dunyansat anga wandén, “Anga véwutén wa. Sérémaa du dakwa ras Gotna kundi yaasékatake kapéremusé yakandakwa. Paapu yakwa dunyan ras yaae wandaru Gotna kundi vékukwa du dakwa deku kundimba vékwe Gorét kuk kwayémunaandaru, néma kapéremusé wunga wan dunyanngé wa yaaké yakwa. Wunga waké yakwa dunyansat taale deku kwaalémba néma matut giye vaanjandandaru de anda solwaramba kulak ke kiyaamunaandaru, wan kapére wa. De wandaru Gotna kundi vékukwa du dakwa deku kundi vékute Gorét kuk kwayémunaandaru, Got wunga wan dunyansat yandarén kapérandi musé, némaanmba wa yakatandékwa. Wan néma kapérandi musé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Guné wani duké ma jéraawu yangunu. “Du nak kapéremusé yamunaandu dat ma waarungunu. Waarungunu wani yandén kapéremuséké kalik yate yaaséka-munaandu guné nakapuk wani muséké vékulakaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dé nakurak nyaamba kapéremusé apu taambak kaayék vétik (7) gunat yatake gunat yaae anga wamunaandu, ‘Wani gunat yawutén kapéremuséké kalik yate bulaa wani musé yaasékawutékwa.’ Wunga wamunaandu apapu ma wangunék, ‘Wani yaménén kapéremuséké nakapuk katik vékulakaké nané. Dékumukét yénga yakét.’ Wunga guné waké ya.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisasna kundi kure yékwa dunyansé dat anga wandarén, “Néman Du, méné nanat ma yékun yaménu nané Gorké yékunmba vékulakate ména jémbaaké kurkale vékusék-nganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wunga wandaka Néman Du Jisas anga wandén, “Guné Gorké yékunmba vékulakangunéngwa mawulé makal ramunaandu guné néma jémbaa yakangunéngwa. Amba tékéskwa miyat ma vé. Guné Gorké yékunmba vékulakangunéngwa mawulé makalkéri miyéna sék pulak makalkéri male téndu, ani miyé bétngiale saape ye solwaramba daawulindénngé Gorét waamunaangunu, ani miyé saapuwe ye solwaramba daawulikandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wani kundi watake Jisas det anga wandén, “Guna du nak déku jémbaa yakwa du képmaa vaatémunaae, sipsipké séngiye kaavétémunaae, garambu jémbaa yasékéyaktake déku néma duna gaat yéndu kalmu dat anga waké dé? ‘Méné ma yaa. Bari rate kakému katu.’ Naaké dé? ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Katik wunga waké dé. Wa anga wakandékwa, ‘Wuna kakému ma yaakéménu. Ye kakému saakwe wunéké ma kure yaa. Kure yaaménu wuné taale kawutu méné kukmba kaménu.’ Néma du wunga wakandékwa, déku jémbaa yakwa duwat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wandu déku jémbaa yakwa du wunga yandu, wani néma du wani muséké déku jémbaa yakwa duna yé yénga pulak kavérékngé dé? Dé déké jémbaa yakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Guné wani jémbaa yakwa du pulak Gotna jémbaa ma yangunu. Yate ma wangunu, ‘Nané baka jémbaa yakwa du wa ténangwa. Got tiyaan jémbaa wa yanangwa. Yananén jémbaaké guné nana yé katik kavérékngé guné.’ Wunga ma wangunu.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalemét yéndakwa yaambumba yéndén. Samaria distrik aangakmba téndéka Galili distrik aangakmba tén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jisas nyéndémba ye gaayé nakmba saambakndéka de wani lepro yan dunyansé tambavétik (10) de yaambumba apak awulaka téte véténdarén dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Véte némaanmba anga waandarén, “Néma du, Jisas, nanéké ma mawulé sémbéraa yaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naandaka det yaasatiye véte anga wandén, “Guné ma ye Gotna gaamba jémbaa yakwa duwat guna sépé wakwasnyéngunu.” Naandéka de déku kundi vékutake yéténdaka deku sépé nakapuk yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yandéka wani du nak déku sépé yékun yandéka vétake nakapuk waambule yaandén. Yaae némaanmba waate Gotna yé kavérékndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kavérékte Jisasna maanale kwaati se waandé daate Jisaské mawulé tawulé yate déku yé kavérékndén. Wani du dé Samaria du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yandéka Jisas wani duwat vétake wandén, “Du tambavétik (10) wa deku sépé yékun yan. Du taambak kaayék vétik vétik (9) yamba daré to? ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kamuké dé nakurak male wani nak gaayémba yaan du dékét déku kapmang waambule yaak, Gotna yé kavérékngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naatake wani duwat anga wandén, “Méné wunéké yékunmba vékulakate ménat yékun yaké apamama yawutékwanngé wate méné bulaa wa yékun yaménéngwa. Méné ma waarape yé.” Naandén Jisas, wani duwat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi du ras Jisasét anga waatakundarén, “Yani sapak Got néma du rate du dakwaké yékunmba véké dé?” Waatakundaka det anga wandén, “Got néma du rate du dakwaké yékunmba véké yandékwa sapak yaandu guné katik véké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yangunu du dakwa anga katik waké daré, ‘Ma vé. Got deku néma du rate amba wa randékwa.’ Wunga katik waké daré. Yandaru nak du dakwa anga katik waké daré, ‘Ma vé. Got deku néma du rate, wani taalémba wa randékwa.’ Wunga katik waké daré. Got néma du rate awula guna mawulémba wa randékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wani kundi watake Jisas déku dunyansat anga wandén, “Sérémaa guné Duna Nyaan wuné véké mawulé yakangunéngwa. Ye wunat katik véké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wani sapak du ras gunat anga wakandakwa, ‘Ani duwat ma vé. Duna Nyaan a rakwa.’ Naandaru ras wa waké yakwa, ‘Yamba yé wa. Wamba wa randékwa.’ Naandaru guné deku kundi vékumarékate. De paapu wa yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wuné Duna Nyaan waambule gaayawutu akwi du dakwa vékandakwa. Nyétmba kusnyérak yandéka akwi du dakwa véndakwa pulak, wa guné akwi wuné gaayawutu vékangunéngwa. Wunga vémuké vékute, guné deku paapu yandakwa kundiké vékuké yamarékate. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Taale a tékwa du dakwa wunat kapérandi musé yate wunat kuk kwayékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Talimba Noa yatan sapak du dakwa yan pulak, Duna Nyaan wuné waambule yaawuta sapak du dakwa wungat male yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa yatan sapak du taakwa de Gorké yamba vékundakwe. De ani képmaana musé aséké male vékulaka-téndarén. Vékulakatéte kakému kandarén, kulak kandarén, taakwa kéraandarén, wunga yaténdaka Noa dékét néma sip ye dé wani sipmba wulaandén. Wulaandéka néma gu yaale vékulékndéka kulak ke kiyaatondarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Talimba Abrahamna waayéka déku nyaan Lot yatan sapak waak Sodommba tan du dakwa wungat male wa yatéte téndarén. De Gorké vékukapuk yate ani képmaana muséké male vékulaka-téndarén, musé yandarén, musé asé kwayéndarén, kakému yaanandarén, gaa kaandarén, wunga yaténdarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yaténdaka Lot Sodom yaasékatake yéndén. Yéndéka wani nyaamba male néma yaa matuale maas viyaakwa pulak wunga vaakétte akwi du dakwat kélé bélawe viyaae yaavan kutndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wani du dakwa yan pulak, wuné Duna Nyaan gaayawuta sapak du dakwa wungat male wa yakandakwa. De wunéké vékukapuk yate, deku muséké male vékulaka-téndaru wa gaayakawutékwa. Gaayawutu vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wani nyaa kaapamba rakwa du dakwa ma bari yaange yéndarék. Deku musé asé kéraaké deku gaat nakapuk katik wulaaké daré. Baka ma yaange yéndarék. Yaawimba ye tékwa du dakwa gaayét waambule ye deku laplap katik kéraaké daré. Bari ma yaange yéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Guné Lotna taakwaké ma vékulaka. Talimba léku gaayé véké waalakwe wa kiyaalén. Guné waalakukapuk ye baka yaange ma yéngunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Du dakwa wuna jémbaa yaténdaru wuna maama det viyaandékndaru de apapu apapu yékunmba rasékéyak-ngandakwa. Du dakwa wuna jémbaa yakapuk yate, dekét deku sépéké male vékulakate, deku jémbaa male yamunaate, wa de kiyaae akwi yalambiyak-ngandakwa. Katik kurkale rapékaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Gunat anga wawutékwa. Waambule yaaké yawutékwa sapak du vétik nakurak jaambémba kwaambéru Gotna kundi kure gaayakwa du nakét kéraate nak yaaséka-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wani sapak taakwa vétik kakému kéraae waawatrémbéru Gotna kundi kure gaayakwa du nakét kéraate nak yaaséka-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wani sapak du vétik yaawimba jémbaa yarémbéru Gotna kundi kure gaayakwa du nakét kéraate nak yaaséka-kandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wani kundi wandéka vékutake déku dunyansé wa wan, “Néman Du, wani musé yamba yaké dé?” Naandaka Jisas det anga wandén, “Kwaarkandi yaae wuréngwandéndaka vétake wangunéngwa, ‘Kwaami nak amba wa kiyaae rakwa.’ Naangunéngwa. Wani musé véte wangunéngwa pulak, guné wawutén musé véte, anga ma wangunék, ‘A yaakandékwa.’ Naangunék.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ani gwaaménja kundi det anga wandén. De Gorét waatakumuké saalakukapuk yandarénngé det anga wandén. De Gorét waataku-pékaréndaru dé deku kundi vékundénngé det ani gwaaménja kundi wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anga wandén, “Néma gaayémba kot vékukwa néma du nak yaréndén. Wani du dé Gorké wup yakapuk yate dé du dakwaké waak yamba vékulakandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Du kiyaan kwawitakwa nak wani gaayémba yarélén. Yaréte apapu nyaa kot vékukwa néma duké yéte, dat apapu anga walén, ‘Wuna maama wunat yaavan kurké wate yandékwa. Yandékwanngé méné wunat yékun yaké méné, kapuk yénga pulak yaké méné?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naaléka wani du wa wan, ‘Yamba wa.’ Naatake lat yékun yamuké taale kalik yandén. Yandéka apapu yéte yéte dat waatakuléka kukmba déku mawulémba vékulake anga wandén, ‘Wuné Gorké wup yakapuk yate, du dakwaké waak yamba vékulakawutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yate wani taakwa apapu nyaa wunat yaate yaate waataku male, waataku male yamuké wuné saalaku yawutékwa. Lé wunga yate wuna mawulé yaavan kurkapuk yamuké, wuné léku kundi vékute lat yékun yakawutékwa.’ Kot vékukwa néma du wunga wandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Néman Du Jisas wani kundi watake det anga wandén, “Guné kot vékukwa néma duké ma vékulaka. Dé kapéremusé yakwa du téte wani taakwana kundi vékuténdén. Wani muséké vékulakate, vékusék-ngangunéngwa. Got yéku musé male yakwa du rate, dé déku du dakwana kundi vékukandékwa. De apapu nyaa gaan det yékun yandénngé waatakute, dat waataku male, waataku male yamunaandaru, wa dé deku kundi vékukandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Vékute det bari yékun yakandékwa. Wunga véte vékusékngunénngé gunat wawutékwa. Guné ma vékulaka. Sérémaa wuné Duna Nyaan ani képmaat waambule gaaye Gorké yékunmba vékulakakwa du dakwat véké wuté kapuk?” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas wa vésékndén. Du dakwa ras deku mawulémba anga wandarén, “Nané Gotna ménimba yéku du dakwa a ténangwa. Ras du dakwa déku ménimba gaandé yan du dakwa wa téndakwa.” Naatake yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wunga vésékte det ani gwaaménja kundi wandén: “Du vétik Gorale kundi bulké we Gotna kundi bulndakwa néma gaat waarémbérén. Wani du vétik nak Farisi du wa. Nak takis kéraakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi du waare dékét kapmang téte Gorét anga wandén, ‘Méno Got, wuné yéku du yatéwutékwanngé, ména yé kavérékwutékwa. Wuné ras du dakwa yakwa pulak yakapuk yate, wuné ménat waatakutékwa. De ras duna muséké mawulé yandakwa, paapu yandakwa, du ras duna taakwale kapéremusé yandakwa, wunga yate kapéremusé wa yandakwa. Wuné a tékwa takis kéraakwa du kapéremusé yakwa pulak, yamba yawutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wuné akwi wikmba nyaa vétik kakému kakapuk baka yaréwutékwa. Yaréte kéraawutékwa akwi musé tambavétikmba (10) muni waatate nak tambék ménat kwayéte tambék taambak kaayék vétik vétik (9) wunéké taakawutékwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wunga wandéka dé wani takis kéraakwa du awula apak téndén. Téte wani yandén muséké nékéti yatéte, nyérét yamba yaasore véndékwe wa. Ye waandé daae Gorét anga wandén, ‘Méno Got, wuné kapéremusé yakwa du a. Wunéké ma mawulé sémbéraa yaménu.’ Naandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wani kundi watake Jisas det anga wandén, “Gunat wawutékwa. Takis kéraakwa du yan kapéremusé Got wa yasnyéputindén. Yasnyéputindéka dé Gotna ménimba yéku du yare yékun yéndén dékét déku gaat. Farisi du dé Gotna ménimba yéku du yamba yaréndékwe wa. Deku yé kavérékngwa du dakwa, sérémaa Got wandu, de baka du dakwa tékandakwa. Deku yé kavérékngapuk yakwa du dakwa sérémaa Got wandu, de néma du dakwa tékandakwa.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Du dakwa makalkéri nyambalésé Jisaské kure yéndarén, det taamba kutte deké Gorét waatakundénngé. Kure yéndaka de Jisasna dunyan véte det waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Waarundaka Jisas wani nyambalésat waandén, déké yaandarénngé. Waatake déku dunyansat anga wandén, “Makal nyambalésé ma taaka de wunéké yénga yaandaru. Yaandaru guné det watépéké yambak. Gotna kémba tékwa du dakwa de wani makal nyambalésé pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Got néma du rate déku du dakwaké kurkale vékandékwa. Dé wunga yaké yandékwanngé makal nyambalésé mawulé yandakwa. Makal nyambalé yakwa pulak, du dakwa deké kurkale véké yandékwanngé mawulé yamunaae, wa de déku kémba yaalakandakwa. Makal nyambalé yakwa pulak mawulé yakapuk yakwa du dakwa de déku kémba katik yaalaké daré.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Némaamba musé kure yaran néma du nak Jisasét anga wandén, “Méné yéku du wa. Gotna jémbaaké nanat yakwasnyé-ménéngwa. Méné ma wa wunat. Kamu ye wuné kulémawulé kéraae apapu apapu kurkale yarépékaké wuté?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Naandéka Jisas wa wan, “Kamuké méné wunat, ‘Yéku du,’ wo? Dékét Got nakurak wa yéku du randékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Got wandéka Moses wan apakundi wa vékuménén. Vékute méné vékuték naaké ya. ‘Méné nak duna taakwale kapéremusé yambak. Du dakwat viyaandékngé yambak. Sél yaké yambak. Nak du dakwat paapu yaké yambak. Ména aapa aasat ma yékun yaménék.’ Moses wani kundi wandéka wa vékuménén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wunga wandéka wandén, “Wuné makalnyan yaréwutén sapak wani apakundi vékuwutén. Ani sapak waak a vékuwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Naandéka wandén, “Méné anga waak ma ya. Méné taakaménén musé asé akwi nak duwat kwayéte yéwaa kéraae yéwaa kure yarékapuk du dakwat ma kwayé. Kwayéménu sérémaa Got ménat yékun yandu méné Gotna gaayét ye wamba yékunmba rapéka-kaménéngwa. Méné yéwaa kure yarékapuk du dakwat yéwaa kwayétake waambule yaae wuna jémbaamba ma yaala.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wunga wandéka wani kundi vékutake dé némaamba yéwaa kure yare nak du dakwat kwayémuké kalik yandéka déku mawulé kapére yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas wani duwat véte anga wandén, “Rékaamba musé kure yarékwa du dakwa de yakélak yare Gotna kémba katik yaalaké daré. De apamama ye wa néma jémbaa yakandakwa Gotna kémba yaalamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ani kundi waak ma véku. Néma bulmakau nak laplap samapndakwa raaményna yaambumba wulaaké mawulé yaamunaae, apamama wa yakandékwa. Rékaamba musé kure yarékwa du dakwa Gotna kémba yaalaké mawulé yate de ma apa tapa yapékandarék.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wunga wandéka de wani kundi vékutake wandarén, “Rékaamba musé kure yarékwa du dakwa Gotna kémba wulaaké wate apa tapa yamunaandaru yénga pulak musé kure yarékapuk du dakwa Gotna kémba wulaae kurkale rapékaké daré apapu apapu? Yamba wa. Gotna kémba wulaaké yapati-kandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naandaka wandén, “Du dakwa dekét deku kapmang apamama yate Gotna kémba yaale yékunmba raké yapatindakwa. Got nakurak wa wani muséké apamama yandékwa. Got akwi musé yaké wa apa tapa yandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wani kundi wandéka Pita anga wandén, “Ma véku. Nané nana gaa nana akwi musé waak yaasékatake nané ména jémbaa yate ménale yeyé yaayaténangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Naandéka Jisas wa wan, “Yi wan wanana wa. Ma véku. Wunéké yékunmba vékulakakwa du dakwa Gotna jémbaa yaké watake deku gaa, du, taakwa, aanyé, waayéka, aasa, aapa, nyambalé yaasékandaru Got bulaa det yékun yandu yékunmbaa-sékéyak yarépéka-kandakwa apapu apapu. Yi wan wanana wa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas déku dunyansé tambavétik maanmba kaayék vétik (12) det anga wandén, “Ma véku. Bulaa Jerusalemét waarénangwa. Waarénanu Gotna yémba kundi kwayétan du Duna Nyaan wunéké Gotna nyéngaamba viyaandarén kundi sékérék-ngandékwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jerusalemmba wunat nak gaayéna dunyansat kwayéndaru wuné deku taambamba rakawutékwa. Rawutu wunat wasélékte kapérandi kundi wate sépmany sévaate kapérandi musé yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yate wunat raamény baangwit viyaae wuné viyaandék-ngandakwa. Yandaru kiyaawutu nyaa vétik yéndu kupuk yambanmba nakapuk taamale waarapkawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wunga wandéka déku dunyan wani kundi kurkale yamba vékundakwe. Got wani musé paakundéka de Jisas wani wan kundiké yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas déku dunyansale sékét ye Jerikomba saambakngé yaténdarén. Yaténdaka méni kiyaan du nak yaambumba rate du dakwat yéwaaké yaawiréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yaawire vékundén némaamba du dakwa yéndaka. Vékutake dunyan rasét waatakundén, “Wa kamu daré yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naandéka dat wandarén, “Nasaret du Jisas dé a yaakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naandaka waandén, “Méno, Devitna gwaal waaranga maandéka bakamu Jisas, ma véku. Méné Devit pulak néma du téte wunéké ma mawulé sémbéraa yaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wunga waandéka de taale yétan du dat wandarén, “Yakélak ra.” Naandaka yamba randékwe yakélak. Nakapuk waate wandén, “Méno, Devitna gwaal waaranga maandéka bakamu, wunéké ma mawulé sémbéraa yaménu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Wunga wandéka Jisas det wandén, “Dé ma kure yaa wunéké.” Naandéka dé ye Jisas ténmba saambakndéka dat waatakundén, “Wuné ménat kamu yawuténngé méné mawulé yo?” Waatakundéka wandén, “Néman Du, wuné véké mawulé yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naandéka dat wandén, “Ménat kururéké yawutékwa mayé apaké yékunmba vékulaka-ménénga wa bulaa ména méni yékun yan. Bulaa ma véménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wunga wandéka déku méni nakapuk bari yékun yandéka véndén. Vététe Jisasale yéte dé waak Gotna yé kavérékndén. Yandéka wani musé vén du dakwa de waak Gotna yé kavérékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jerikot wulaandén. Wulaae nak gaayét yéké we yaambumba yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Takis kéraakwa du nak déku yé Sakius wani gaayémba yaréndén. Dé takis kéraakwa duna néma du téte asa yéwaa wa taakaténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dé Jisas vésékngé mawulé yandén. Dé pavéték du wa. Késépéri du dakwa yatékésénmba Jisas véké naae yapatindén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yapatiye taale pétépété ye miyé nakmba waaréndén Jisas véké. Jisas ani yaambumba yaakandékwa. Wunga vékulakate miyémba waaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Waare téndéka Jisas yaae wani taalémba téte yaasore vététe dat wandén, “Sakius, bulaa ménale ména gaamba rakawutékwa. Méné ma gaaya bari.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wunga wandéka dé mawulé tawulé yate bari gaayandén. Ye Jisas déku gaat kure yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yéndéka akwi du dakwa véte wandarén, “Jisas kapéremusé yakwa duwale raké wa yéndékwa, déku gaat. Wan kapére wa yandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakius Néman Du Jisasét wandén, “Néman Du, ma véku. Bulaa wuné wuna musé nyéndémba munikawutékwa. Muniye nak tambék musé asékapuk dunyansat kwayékawutékwa. Kwayéte anga waak yakawutékwa. Wuné talimba du rasét paapu yate deku musé kéraawuténngé musé det nakapuk waambule kwayéte apu kupuk waak baka kwayékawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Wunga wandéka Jisas wa wan, “Ani du waak dé Abrahamna gwaal, waaranga, maandéka, bakamu wa téndékwa. Talimba yatéte Gorké yékunmba vékulakakapuk ye dé wa lambiyakén. Bulaa guné déku kundi vékute anga wa vékusékngunéngwa. Bulaa Got dat déku gaamba rakwa du dakwat waak Satanna taambamba wa kéraandén. Kéraandén apu de déku taambamba yékunmba rapéka-kandakwa. Lambiyakén du dakwaké waake véte de Satanna taambamba kéraae det yékun yaké watake wa wuné Duna Nyaan ani képmaat gaayawutén.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas ye Jerusalemmba saambakngé yaténdén. Yaténdéka du dakwa deku mawuléké anga wandarén, “Got néma du rate nanéké kurkale vérénda nyaa bari wa yakandékwa.” Wunga wandaka Jisas det gwaaménja kundi nak anga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","“Néma du nak sékaa gaayét yéké watake, taale déku jémbaa yakwa dunyansé tambavétik waandéka yaandaka det nak nak yéwaa ras kwayéndén (20 kina, 20 kina pulak). Kwayéte det anga wandén, ‘Ani yéwaa kure jémbaa yaréngunu wuné nakapuk waambule yaae kéraakawutékwa.’ Naatake sékaa gaayét yéndén, wamba rakwa néma du dat wandu déku gaayémba tékwa du dakwaké néma du randénngé. Ye wani kundi vékwe bari waambule yaaké vékulakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dé yéndéka de wani déku gaayémba yaran du dakwa de dé kalik yate, dunyan rasét wandaka déku kukmba yéndarén. Ye wani sékaa gaayémba ran néma duwat anga wandarén, ‘Nané wani du nana néma du randénngé kalik yanangwa.’ Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kukmba wani néma du wani duwat wa wandén, déku gaayémba tékwa du dakwaké néma du randénngé. Wandéka vékutake yare nakapuk waambule yaandén. Yaae wandén, ‘Talimba yéwaa kwayéwutén duwat ma waa yaandaru. Wani kwayéwutén yéwaamba kure ye jémbaa ye katik yéwaa daré kéraak?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Naandéka du nak taale yaae dat anga wandén, ‘Néma du, wuné ména yéwaa kure ye jémbaa ye rékaamba (200) yéwaa kéraawutén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naandéka néma du dat wandén, ‘Méné yéku jémbaa yakwa du wa. Yéku jémbaa wa yaménén. Méné makalkéri muséké wa kurkale véménén. Véménénngé wuné wawutu méné gaayé tambavétikngé (10) néma du rakaménéngwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Naandéka nak du waak yaae wandén, ‘Néma du, wuné ména yéwaa kure ye jémbaa ye yéwaa rékaamba (100) ras wanale kéraawutén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wunga wandéka wani néma du wa wan, ‘Wan yékun wa. Bulaa wawutu méné gaayé taambakngé (5) deku néma du rakaménéngwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Naandéka nak du yaae wandén, ‘Néma du, wuné méné véwutén wa. Méné du dakwaké mawulé yamba sémbéraa yaménéngwe wa. Méné musé asé waak baka kéraaké mawulé yate, méné nak du dakwat yékun yamba yaménéngwe wa. Wuné ménéké wup ye wani wunat tiyaaménén yéwaa laplapmba giye baka taakawutén. Ména yéwaa a rakwa amba. Bulaa nakapuk ménat kwayékawutékwa.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Naandéka wani néma du anga wandén, ‘Méné kapérandi jémbaa yakwa du wa. Waménén kundi vékutake yaménén kapéremusé ménat yakata-kawutékwa. Wuné apamama yate nak du dakwat mawulé sémbéraa yakapuk yate musé asé waak baka kéraaké mawulé yate, wuné nak du dakwat yamba yékun yawutékwe wa. Yi wan wanana wa. Wa waménén. Wunga yawutékwanngé wa vésékménén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Vésékte kamuké méné wuna yéwaa wani yéwaa taakandakwa gaamba taakakapuk yak? Méné wamba taakamunaaménu, wa wuné waambule yaae wani yéwaa kéraate ras waak wanale kéraakatik wuté.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naatake wamba tékésén dunyansat wandén, ‘Guné dat kwayéwutén yéwaa ma kéraae némaamba yéwaa kure rakwa duwat kwayéngunu. Wani jémbaa yakwa du dé wani kwayéwutén yéwaa kure ye yéku jémbaa wa yandén.’ Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Wunga wandéka dat anga wandarén, ‘Néma du, kamu yakwate méné yo? Dé asa yéwaa wa kure randékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Naandaka det wandén, ‘Yéku jémbaa ye némaamba musé kéraan du dakwa sérémaa musé ras waak kéraakandakwa. Yéku jémbaa yakapuk ye musé ayélap kure rakéskwa du dakwa sérémaa kukmba baka wa rakéskandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wuna maama wuné deku néma du rawuténngé kalik yandarénngé guné det ma kure yaae wuna ménimba de viyaandékngunu.’ Naandén néma du.” Wunga wandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas wani kundi watake dé taale ye déku dunyansale Jerusalemét waaréndakwa yaambumba waaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Waare Betfage tékwan Betani waak tékwan ye kwambaliténdarén. Wani gaayé vétik Oliv némbumba wa témbérékwa, Jerusalem tékwanmba. Vétake saambakngé yatéte Jisas déku du vétikét wandén, “Wani gaayét ma wulaambénu. Wulaae vékambénéngwa donki nyaan nak. Miyémba lékitakandaka wa téndékwa. Talimba du nak déku kukmba yamba waare randékwe wa. Dé ma lepékwe kure yaambénék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yambénu du nak anga waatakumunaandu, ‘Kamu yaké béné wani donki nyaan lepékwo?’ Naandu anga ma wambénu, ‘Néman Du wani donkiké mawulé yandékwa.’ Dat wunga wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wandéka déku kundi vékutake ye vémbérén donki miyémba lékitakandaka téndéka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Vétake wani donkina baangwi lepékumbéréka de wani donkina aapa yaae bérét waatakundarén, “Kamu yaké béné wani donki nyaan lepékwo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naandaka wambérén, “Néman Du wani donkiké mawulé yandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naambéréka de mawulé yate wandaka wani donki nyaan Jisaské kure yémbérén. Ye bérku laplap ras donkina bungulmba kusorétaka-mbéréka Jisas wan taakumba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wani donkimba waare yéndéka du dakwa deku laplapét yaambu yakusote vélésaki-laakét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Vélésaki-takandaka ye Oliv némbu taakatake daawuliye Jerusalemmba saambakngé yaténdéka wani déké yékunmba vékulakakwa du dakwa akwi déké mawulé tawulé yate dusék takwasék yandarén. Yate talimba wani vékapuk yandarén kulé apanjémba véndarénngé vékulakate némaanmba waate Gotna yé kavérékndarén. Yate anga wandarén: ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Nana néma du nanéké wa yaandékwa. Néman Du Got wandéka wa yaandékwa. Wan yékun wa. Got dat yékun yénga yandu. Gotna gaayémba tékéskwa du dakwa mawulé tawulé yate yékunmba yarékandakwa. Nané mawulé tawulé yate anjorémba rakwa du Gotna yé ma kavérékngwak.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisi dunyan ras wani du dakwale te vékutake Jisasét anga wandarén, “Néma du, méné ména du dakwat ma wa. De wunga némaamba waaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naandaka det wandén, “Gunat anga wawutékwa. De kundi bulkapuk yamunaandaru, wa matu dekét de wuna yé kavérék-ngandakwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas ye Jerusalemmba saambakngé yatéte gaayét vétake wamba tékwa du dakwaké mawulé sémbéraa yate géraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Géraate anga wandén, “Bulaa guné Gorale nakurakmawulé ye raké vékusék-munaangunu, wan yékun yakatik. Bulaa wani musé paakundéka yamba yékunmba vésékngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Got gunat yékun yate Satanna taambamba guné kéraandékwa nyaaké yamba kurkale vékusékngunéngwe wa. Yangunéngwanngé sérémaa guna maama yaae guna gaayé yanyaweye tékandakwa. Téte képmaa vaae yénguna yaambumba taakatépé-kandakwa. Yate gaayét wulaae gunat, guna nyambalésat waak viyaandék-ngandakwa. Viyaandékte akwi gaa yaavan kutwurékandakwa. Yaavan kutndaru gaa kaangunén matu akwi vaakére kapmang kapmang ye rakandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Jisas ye Jerusalemét wulaae Gotna kundi bulndakwa néma gaat wulaandén. Wulaae véndén dunyan ras musé asé kwayéte yéwaa kéraaténdaka. Vétake de kewurésalete anga wandén, “Ani kundi Gotna nyéngaamba wa kwaakwa: ‘Got wa wandén, “Du dakwa wuna gaat yaale wunale kundi bulkandakwa.” Naandén Got.’ Wani kundiké yamba vékulakangunéngwe wa. Guné ani gaamba Gorale yamba bulngunéngwe wa. Guné a musé asé kwayéte yéwaa kéraaténgunénga ani gaa an sél yakwa du paakwe rakwa gaa pulak a gérékén.” Naandén det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Apapu nyaa Gotna kundi bulndakwa néma gaamba du dakwat Gotna jémbaaké yakwasnyéndén. Yandéka Gotna gaamba jémbaa yakwa dunyanna néma dunyan, apakundiké vékusékngwa dunyan, néma du ras waak anga wandarén, “Yénga pulak dé viyaandékngé nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wunga wate bulte akwi du dakwa déké mawulé yate déku kundi vékuké wate yandarénmba dé viyaandékngé yapatindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nak nyaa Jisas Gotna kundi bulndakwa néma gaamba téte du dakwat Gotna jémbaaké yakwasnyététe Gotna kundi kwayéndéka Gotna gaamba jémbaa yakwa dunyanna néma dunyan, apakundiké vékusékngwa dunyan, Israelna maaka dunyan, wunga déké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yaae dat anga wandarén, “Kamu mayé apa kéraae méné wani jémbaa yo? Kandé wak wani jémbaa yaménénngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naandaka det wandén, “Wuné waak gunat kundi nak waatakukwate yawutékwa. Guné wunat ma wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kandé Jonét wak dé du dakwat baptais kwayéndénngé? Got dé wak, kapuk ani képmaana du nak dé wak?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wunga waatakundéka dekét deku kapmang bulte anga wandarén, “Nané anga wamunaananu, ‘Got wa wunga wan.’ Naamunaananu nanat anga wakandékwa, ‘Kamuké guné déku kundi vékukapuk yo?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anga wamunaananu, ‘Ani képmaana du nak wa wan.’ Wunga wamunaananu akwi du dakwa vékute nanat rakarka yate nanat matut viyaakandakwa. Jonngé anga wandakwa, ‘Gotna yémba kundi kwayétan du nak wa. Yi wan wanana wa.’ Wunga wandakwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wunga bule paapu yate Jisasét anga wandarén, “Yamba vékuséknangwe wa. Wani muséké katik waké nané.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wunga wandaka det wandén, “Wuné waak katik waké wuté, wunat wandéka yaae ani jémbaa yawutékwa duké.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wani kundi watake du dakwat ani gwaaménja kundi wandén; “Du nak wain yaawi nak yandén. Ye wain miyé taawundén. Ye wain yaawiké séngite yaawimba jémbaa yate yéwaa kéraaké mawulé yan dunyansat kwayéndén. Kwayétake dé nak taalat yén. Ye wamba kwaaré késépéri yaténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yaténdéka miyé sék géléké yandakwa sékét yaaké yandéka dale yaréte déku jémbaa yakwa du nakét wandén, dé wani yaawiké kaavéte séngirékwa duké yéndénngé. Dé miyé sék ras kwayéndaru kure yaandénngé mawulé yandén. Ye wandéka déku jémbaa yakwa du yéndéka de wani yaawiké séngirékwa dunyansé déku kundi yamba vékundakwe. Yate wani duwat viyaae kewuréndaka baka male waambule yaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yaandéka déku jémbaa yakwa nak duwat wandéka yéndén. Yéndéka dat waak wungat male viyaae kapére ye kewuréndaka baka male waambule yaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaandéka déku jémbaa yakwa du nak duwat wandén. Wandéka dé waak yéndéka dat viyaae kapére ye kaapat vaanjalendarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Yandaka waambule yéndéka wani yaawina néma du wa wan, ‘Wuné yénga pulak yaké wuté? Wuné wuna mawulé tawulé yawutékwa nyaanét wawutu yékandékwa. Dé ye wandu kalmu déku kundi vékuké daré?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Naatake wandéka déku dunyanngu nyaan yén. Yéndéka de wani yaawiké séngiran dunyan vétake dekét deku kapmang bulte anga wandarén, ‘Yaawina néma du kiyaandu wani nyaan wa déku aapana musé asé akwi kéraaké yakwa. Nané dé viyaandéktake ani yaawi kéraakanangwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naatake yaawi taakatake dé baka taalat kure gwaande dé wamba viyaandékndarén.” Wunga watake Jisas det anga wandén, “Guné yénga guné vékulako? De wunga yandarénngé wani yaawina néma du yénga yaké dé? ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dé yaae wani wain yaawiké séngirékwa dunyansat viyaandékwuré-kandékwa. Viyaatake wani wain yaawi nak duwat kwayékandékwa, de wani yaawiké séngiréndarénngé.” Naandén Jisas. Wamba tékésén du dakwa wani kundi vékute wandarén, “Yamba yé wa. Dé wunga katik yaké dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naandaka Jisas det véte wandén, “Gotna nyéngaamba ani kundi wa kwaakwa: Gaa kaakwa du yéku matuké waakte matu nakurakngé kalik yatakandaka baka randén. Randéka Got wani matut vétake wandén, ‘Wan yéku matu wa. Wani matu randu gaa yékunmba kwaakandékwa.’ Naatake wani matu kéraae taakandéka yékunmba kwaandén gaa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wani kundiké gunat waatakuwutékwa. Kandéké dé wo? Wani matu taakumba du nak vaakétmunaandu déku sépé maalé maan taamba akwi ayélap ayélap yaké yakwa. Wani matu du nakna sépétakumba vaakétmunaae wani duwat takunyémndu képmaamba gérék yakandékwa.” Naandén Jisas det. Wani matuké wunga wate dékét déké wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wani kundi wandéka de apakundiké vékusékngwa dunyan, Gotna gaamba jémbaa yakwa dunyanna néma dunyan de waak wa vékundarén, Jisas dekét deké wa wani kundi wandén. Vékutake dat bari kulkiye kure yéké yandarén. Yare du dakwa kalik yate det waarumuké we wup ye wa dé yamba kutndakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ye dé kulkindara nyaaké kaavéréndarén. Yate deku mawulémba anga wandarén, “Paapu yakwa dunyan dale kundi bulte késmu nakmuké dat waatakundaru kalmu waambule wate kapérandi kundi ras waké dé? Wandu dé kotimnganangwa. Kotime dé Romna néma duwat kwayékanangwa.” Naatake dunyanét ras yéwaa kwayéndarén, de paapu ye dale kundi bulndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wani paapu yakwa dunyansé yaae Jisasét anga wandarén, “Néma du, méné det Gotna jémbaaké yakwasnyé-ménéngwa. Méné yéku kundi male wate det Gotna kundiké yékunmba yakwasnyéménéngwa. Méné nakurak kundi male waménéngwa néma du dakwa, baka du dakwat waak. Wunga wanangwa véte. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Méné wunga yate bulaa ma wa nanat. Nana apakundi yénga dé wo? Nané Romna néma duwat takis kwayéké nané, kapuk yamba yé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Naandaka Jisas wa vékusékndén. De deku mawulémba anga wandarén, “Dé bulaa kapérandi kundi wandu dé kotimnganangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Wunga wandaka Jisas vékusékte det anga wandén, “Wani takis kwayéngunéngwa yéwaa nak ma wakwasnyé wunat véwutu.” Naandéka wani yéwaa nak kure yéndarén déké. Kure yéndaka det wandén, “Ani yéwaamba kwaakwa nyaap an kéna nyaap dé? Kéna yé daré ani yéwaamba viyaatakak?” Wunga waatakundéka wandarén, “Wa Romna néma du Sisarnan wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naandaka det wandén, “Yi wan wanana wa. Romna néma du Sisarna musé dékét dat ma kwayéngunu. Gotna musé dékét Gorét ma kwayéngunu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wunga wandéka de déku kundiké vékulaka vékulaka naandarén. De du dakwana ménimba téte wa wani kapérandi kundiké dé kotimngé wate ye yapatikndarén. Dé kapérandi kundi yamba wandékwe wa. Yapatiye wa kundi bulkapuk vékulék naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Sadyusi dunyansé deku mawulémba anga wandakwa, “Kiyaan du dakwa nakapuk katik taamale waarapké daré.” Naandakwa. Yandaka de ras Jisaské ye anga wandarén, “Néman Du, méné du dakwat Gotna jémbaaké wa yakwasnyé-ménéngwa. Méné ani muséké ma wa nanat. Talimba Moses anga viyaatakandén: Du nak taakwa kéraae nyaan kéraakapuk ye baka kiyaamunaandu, déku waayéka wani taakwa kéraakandékwa. Ye nyaan kéraalu wani nyaanngé wakandékwa, ‘Wuna aanyéna nyaan wa.’ Naakandékwa. Moses wunga viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bulaa ma véku. Talimba nakurak kémba du taambak kaayék vétik (7) yaréndarén. Aanyé taakwa kéraae nyaan kéraakapuk baka kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kiyaandéka déku waayéka wani taakwa kéraae nyaan kéraakapuk ye dé waak kiyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kiyaandéka nak waayéka wani taakwa kéraae nyaan kéraakapuk ye dé waak kiyaan. Kiyaandéka akwi waayékanje wungat male ye de akwi nyaan kéraakapuk yate baka kiyaatondarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yandaka yaak wani taakwa lé waak kukmba kiyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bulaa méné nanat ma wa. Kiyaan du dakwa nakapuk taamale waarapndara sapakngé waménéngwa. Wani sapak lé wani taakwa kéna taakwa raké lé? Talimba wani nakurak kémna aanyémbéré waayékanje de akwi lat male kéraandarén.” Sadyusi dunyansé Jisasét wunga waatakundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Waatakundaka Jisas deku kundi vékutake det anga wandén, “Bulaa ani sapakmba tékéskwa du dakwa anga yandakwa. Dunyan taakwa kéraandakwa. Dakwa du kumbindakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sérémaa Got wan du dakwa kiyaae taamale waarape dunyan taakwa kéraakapuk yandaru, dakwa waak de katik du kumbiké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Got wandu de déku nyambalésé wa rakandakwa. De Gotna kundi kure gaayakwa dunyansé pulak rakandakwa. Gorale yaréte nakapuk katik kiyaaké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kiyaan du dakwa nakapuk taamale waarapké yandakwanngé wa Moses wandén. Wandéka wani muséké wa vékuséknangwa. Makalkéri miyé yaa yaanénngé wate wa ani kundi Gotna nyéngaamba viyaatakandéka wa vékungunén: Néman Du Got wan Abraham, Aisak, Jekop béra Got wa. Dé deku néma du wa randékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moses talimba wani kiyaan duké viyaatakandén kundi wa vénanén. Got kiyaan du dakwana néma du yamba randékwe wa. Got baka kulé tékwa du dakwana néma du wa randékwa. Got wan du dakwa wa kiyaan du dakwa yamba wa. Got wan du dakwa wa kiyaae taamale waarape rakéskwa du dakwa wa. Wunga vékuséknangwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Naandéka de apakundiké vékusékngwa dunyan ras dat anga wandarén, “Néma du, yéku kundi wa waménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wunga watake dat waambule waatakumuké wup ye nak kundi waak yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wani nyaa Jisas det anga wandén, “Apakundiké vékusékngwa dunyan anga wandakwa, ‘Gunat yékun yandénngé Got wan du Krais Devitna gwaal waaranga maandéka bakamu dé.’ Kamuké daré wunga wo? ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Talimba Devit Kraiské kundi ras Gotna nyéngaamba viyaatakandén. Devit viyaatakan kundiké wanangwa, Gwaaré. Wani gwaarémba ani kundi anga wa kwaakwa: Néman Du Got wuna Néma Duwat anga wandén, ‘Méné néma du rate wuna yékutuwa saku taambamba ma raménék. Raménu wawutu ména maama ména taambamba rakandakwa. Randaru méné deku néma du rate deké vérékaménéngwa.’ Got wunga wandén. Gunat wawutékwa. Devit wunga wate Kraiské, ‘Wuna Néman Du wa,’ naandén. Kamuké we dé Devit Kraiské wunga wak? ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit Got wan du Kraiské, ‘Wuna Néman Du wa,’ naandéka yénga pulak dé Krais nakapuk Devitna gwaal waaranga maandéka bakamu to? Krais Devitna gwaal, waaranga, maandéka bakamu téte, Devitna néma du waak dé to, kapuk?” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Du dakwa akwi rate Jisasna kundi vékuré-késndarén. Vékuréndaka dé déku dunyansat kundi kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Kwayéte anga wandén, “Guné wani apakundiké vékusékngwa dunyanséké ma jéraawu yangunék. De sémény laplap saawuwe du dakwa jaawundakwa taalémba yeyé yaayaké wa mawulé yandakwa. Yeyé yaayaténdaru du dakwa det véte anga wandarénngé wa mawulé yandakwa: ‘Wan de nana néma dunyansé wa.’ Naandarénngé wa yandakwa. De Gotna kundi bulnangwa gaamba wulaae néma duna taalémba raké wa mawulé yandakwa. De du nakale kakému kate, yéku taaléké waake, du dakwana ménimba raké mawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","De du kiyaan kwawitakwana musé asé akwi kéraandakwa. De paapu yate Gorale kundi kulémba bulténdakwa, du dakwa det véte deku yé kusoréndarénngé. Yandakwanngé Got wandu néma vakmi wa deké yaakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas Gotna kundi bulndakwa néma gaamba téte véténdén, rékaamba musé kurerékésén du dakwa Gorké yéwaa kwayéndaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Véte véndén musé asékapuk yaran du kiyaan kwawitakwa nak yaae makalkéri yéwaa vétik Gorké kwayéléka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Vétake anga wandén, “Rékaamba musé kurerékwa du dakwa Gorké yéwaa ras kwayéndarén. Kwayéndaka deku yéwaa ras waak gaamba wa rakwa. Ani taakwa makalkéri yéwaa vétik kurerélén pulak akwi wa kwayélén. Ye lé kakému kéraala yéwaa nak yamba yé wa. Gorké kwayéndakwa yéku yapatat lé kwayén yéku yapaté wa taalékéran. Yi wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Jisasna du ras Gotna kundi bulndakwa néma gaaké bulte anga wandarén, “An yéku gaa a. Yéku yéku matut wa yandarén. Du dakwa Gorké wani kwayéndarén yéku yéku musat wa yékunmba yakusondarén.” Naandaka Jisas det anga wandén, “Bulaa a véngunéngwa musé asé sérémaa dunyan yaae yaavan kurkandakwa. Yaavan kutte akwi matu kéraae vaanjandandaru nak matu, nak matu taakumba katik kwaaké dé.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wani kundi wandéka dat anga waatakundarén, “Néma du, yani nyaa wani gaa yaavan kurké daré? Taale kamu musé yaandu vétake wani musé a yaakandékwa naaké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naandaka Jisas wa wan, “Guné jéraawu ma yangunék. Yate guné paapu yakwa dunyanna kundimba vékuké yambak. Kundi guné a wawutékwa. Késépéri dunyan yaate gunat paapu yakandakwa. Paapu yate wuna yémba nak nak yaate gunat anga wakandakwa, ‘Got wan du Krais a waambule yaakwa. Wuné anana Krais.’ Naandaru guné deku kundi vékuké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dunyan waariya-kandakwa. Waariyandaru wani waariyandakwanngé ras wakandakwa. Yandaru guné vékute wup yambak. Taale wunga musé wa yakandakwa. Yandaru sésékuk sékéyakmba yaana nyaa kukmba wa yaakandékwa. Bari katik yaaké dé.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Watake det anga wandén, “Nak kantrimba tékwa du dakwa nak kantrimba tékwa du dakwale waariya-kandakwa. Nak néma duna kém nak néma duna kémale waariya-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Apapu néma néma waalé gén-ngandékwa. Késépéri kantrimba néma kaandé yandu néma baat waak yaké yakwa. Nyétmba késpulak nakpulak musé yaandu guné véte asa wup wa yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Wani musé wayéka yaakapuk téndu taale du ras gunat kulkiye kapérandi musé yakandakwa, guné wuna dunyan rangunu de wuna jémbaaké kalik yate. Ye Gotna kundi bulndakwa gaamba gunat kotimngandakwa. De gunat kalapusmba taakakandakwa. Gunat kure yéndaru deku néma duna ménimba tékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","De wunga yandaru guné wani sapak wuna kundi det kwayékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Guné taale, guna mawulémba anga waké yambak, ‘Nané deku kundi yénga pulak waambule waké nané?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Guné wunga waké yambak. Wani nyaa wuné gunat yéku mawulé, waké yangunéngwa kundi waak gunat kwayékawutékwa. Kwayéwutu, kwayéwutékwa kundi guna maama waké yakwa kundit taalékéra-kandékwa. Taalékérandu de guna kundi waambule waké yapatikandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Guna aasa aapa, guna aanyé waayéka, guna kémna du ras, guna du dakwa wunga de wa gunat maamat kwayéké yakwa. Kwayéndaru guné ras viyaandék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Guné wuna dunyan téngunénngé akwi du dakwa kalik yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Guné guna mawulémba apamama ye wuna jémbaa yasékéyakmunaae, wa guné wunale apapu yékunmba yarésékéyak-ngangunéngwa. Katik lambiyakngé guné.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wani kundi watake Jisas det anga wandén, “Sérémaa waariyakwa dunyansé Jerusalem gaayé yanyaweye téndaru vétake wakangunéngwa, ‘Jerusalem yaavan kurké yandakwa sapak a yaakwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wunga wate guné Judiamba tékwa du dakwa guna gaayé yaasékatake némbat bari ma yaange yéngunék. Guné Jerusalemmba tékwa du dakwa wani gaayé yaasékatake bari ma yaange yéngunék. Guné yaawimba yarékwa du dakwa wani gaayét waambule ye wulaaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wani sapak wan Got wani Jerusalemmba yarékéskwa du dakwa yandarén kapéremusé yakataké yandékwa nyaa wa. Talimba du ras wani muséké kundi ras wa viyaatakandarén Gotna nyéngaamba. Wawutékwa nyaa wani kundi sékérék-ngandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wani kapérandi nyaamba nyaan biyaa rakwa dakwa, nyambalé munyaa kwayétékwa dakwa waak bari yaange yéké yapati-kandakwa. Deké mawulé sémbéraa yawutékwa. Wani nyaa Got rakarka yate wandu néma kapérandi vakmi Judamba tékwa du dakwaké wa yaaké yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yaandu maama yaae Judasat waariyandakwa néma kulaat viyaandaru kiyaakandakwa. Rasét kulkiye kure ye nak gaayémba taakakandakwa. Ye wani maama de nak gaayémba yaae Jerusalem yaavan kurkandakwa. Yaavan kuttake Jerusalemmba néma du tékandakwa. Yate Got wani wan nyaa nakapuk waambule yékandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wani kundi watake Jisas det anga wandén, “Nyaa, baapmu, nyétmba tékéskwa kun késpulak nakpulak yandu du dakwa vékandakwa. Solwara némaamba waarapte wutndu ani képmaamba tékwa akwi du dakwa vétake wup yate géraakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yandaru nyétmba tékwa musé akwi sénga génte yeyé yaayakandakwa. Yandaru du dakwa génte wup nékéti yate vékulaka vékulaka naate wakandakwa, ‘Yéki. Yénga kapérandi musé dé nanéké yaakwate yo?’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wunga watake Duna Nyaan vékandakwa wuné apa tapa yate nyaa véte kaalékwa pulak yate buwimba rate gaayawutu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gunat wawutékwa. Wani musé taale baasnyé ye yaandu anga vékusék-ngangunéngwa. Wuné yaré yaré naae guné kéraae Gotna gaayét kure yékawutékwa. Wunga vékusékte guné yéku mawulé vékute ma waarape yaasawure véténgunu.” Jisas det wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Watake det anga wandén, “Miyéké kurkasale ma vékulaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Miyé ras gaanga péraae ye vény yaalandéka véte wangunéngwa, ‘A kakému naaré yakwa sékét a.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wani miyat véte wani sékérké vékusékngunéngwa pulak, wungat male guné wawutén musé véte vékusékte anga wa wakangunéngwa, ‘Got néma du rate du dakwaké kurkale véréké yandékwa nyaa a yaakwa. Yi wan wanana wa.’ Naakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gunat a wawutékwa. Bulaa ani sapak a yatékéskwa du dakwa ras kiyaakapuk ye wayéka yatéte wa wawutén akwi musé vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nyét képmaa késkandékwa. Wuna kundi katik késké dé. Rapéka-kandékwa. Yi wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Watake det anga wandén, “Guné ma jéraawu yangunék. Ras dunyan rékaamba kakému kandakwa, waangété kulak kate waangété yandakwa, ani képmaana muséké male vékundakwa, wunga yate de yamba yékunmba vékulakandakwe wa. Guné de yakwa pulak yaké yambak. Guné de yakwa pulak ye wunéké vékulakakapuk yanguna sapak wa wuné waambule yaakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ani képmaamba a tékwa akwi du dakwat wuné waambule yaawuta nyaa bari yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Guné apapu nyaa wunéké ma kaavéréngunék. Kaavéréte apapu apapu ma Gorét male waatakungunék, gunat mayé apa kwayéndénngé. Waatakungunu mayé apa kwayékandékwa. Kwayéndu kapérandi musé gunat yaavan kurkapuk yandu guné Duna Nyaan wuna ménimba yékunmba tékangunéngwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Apapu nyaa Jisas awula Gotna kundi bulndakwa néma gaamba téte du dakwat Gotna jémbaaké yakwasnyéndén. Yandéka gaan yandéka yéte Oliv némbumba kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yandéka apapu ganmba wani du dakwa Gotna kundi bulndakwa néma gaat yaandarén, déku kundi vékuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yis kurkapuk yandarén bret kandakwa nyaa yaaké yandu wani nyaa Judasé Pasova waandakwa nyaana kakému kakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wani sapak Gotna gaamba jémbaa yakwa dunyanna néma dunyan, apakundiké vékusékngwa dunyan waak de Jisasét viyaandékngé mawulé yandarén. Ye du dakwa kalik yate waariyamuké wup yate anga wandarén, “Nané Jisas yénga pulak ye viyaaké?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wani sapak wa Satan Judasna mawulémba wulaandén. Déku nak yé waandarén Iskariot. Dé Jisasna du nak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan wulaandéka Judas ye Gotna gaamba jémbaa yakwa dunyanna néma dunyan, Gotna kundi bulndakwa néma gaaké séngite kaavétékwa dunyanna néma dunyan waak, dele wa kundi bulndén, Jisas det kwayémuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bule wandéka de mawulé yate dat yéwaa ras kwayéké bule kundi gindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas yi naae kundi giye ye Jisas yakélak det kwayéké yandékwa sapakngé kaavéréndén. Némaamba du dakwa Jisasale yarékapuk yandara nyaaké nak kaavéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis kurkapuk yandarén bret kandakwa nyaa yaan. Wani nyaa wa sipsip nyaan viyaandakwa, Pasova waandakwa nyaana kakémuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Viyaandakwanngé vékulakate Jisas Pita ambét Jonét anga wandén, “Béné ma ye Pasova waanangwa nyaana kakému kéraae waawatmbénu nanéké.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naandéka wambérén, “Yamba kéraae waawaténngé méné mawulé yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wunga waatakumbéréka wandén, “Ma véku. Béné ye wulaae Jerusalemmba, kulak tékwa aké yaatan du nak vékambénéngwa. Vétake déku kukmba ye wulaandékwa gaat ma wulaambénu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wulaae wani gaana duwat anga ma wambénék, ‘Gotna kundi nanat yakwasnyékwa du ménat anga wandékwa, “Wuné wuna dunyansale Pasova waanangwa nyaana kakému kanana gaa yani taalémba dé kwaau?” Naandékwa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wunga wambénu anjorémba kwaakwa néma rum nak wakwasnyé-kandékwa. Wani rummba kakému kanana jaambé, ranana musé waak wa tékéskwa. Béné wani rummba kakému kéraae ma waawatmbénék.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naandéka bét ye Jisas wan pulak vémbérén. Vétake wani Pasova waanangwa nyaana kakému kéraae waawatmbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jisas déku dunyansale yaae rakésndarén kakému kaké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rate Jisas det anga wandén, “Taale ani kakému, Pasova waanangwa nyaana kakému, gunale kaké mawulé tawulé yawutékwa. Kukmba wuné néma kaangél wa kurkawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gunat wawutékwa. Wuné nakapuk gunale téte ani képmaamba ani kakému katik kaké wuté. Sérémaa Got du dakwaké néma du randa sapak yaandu wa nakapuk kakawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wunga watake wain kulak tékwa kasnya nak kéraae Gorét anga wandén, “Yéku kulak wa tiyaaménén. Wan yékun wa.” Naatake déku dunyansat wandén, “Guné kéraae muni waate nak nak ma kangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gunat wawutékwa. Wuné ani képmaamba téte wani kulak nakapuk katik kaké wuté. Sérémaa Got du dakwaké néma du randa sapak yaandu wuné wani kulak nakapuk kakawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wunga watake bret kéraae Gorét wandén, “Yéku musé wa tiyaaménén. Yékun wa.” Naatake bret bule déku dunyansat kwayéte anga wandén, “An wuna sépé a. Gunat yékun yaké wa wuna sépé kwayéwutékwa. Guné wunéké vékulakate wunga ma yapékaténgunék.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naatake kakému akwi kasékéyaktake Jisas wain kulak tén kasnya kéraae wungat male yate wandén, “Ani wain kulak wuna nyéki a. De wuné viyaandaru wuna nyéki vaakundu guné vétake anga wakangunéngwa, ‘Got du dakwat yékun yaké wandén kulé kundi wa sékérék-ngandékwa. Yi wan wanana wa.’ Naakangunéngwa. Naandén Jisas.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wani kundi watake Jisas det anga wandén, “Ma véku. Wuné maamat kwayéké yakwa du dé bulaa wunale kakému rate a karékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Talimba Gotna nyéngaamba kundi wa viyaatakandarén, maama wuné viyaandarénngé. Viyaatakandarén pulak Duna Nyaan wuné viyaandaru kiyaakawutékwa. Kiyaawutu néma vakmi wuné maamat kwayékwa duké wa yaakandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wunga wandéka de deku kapmang bulte dekét waatakundarén, “Kandé wunga yakwate yo?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasna dunyansé kundi bulte waarundarén. Waarute anga wandarén, “Nanémba nana néma du kandé?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wunga wandaka Jisas det anga wandén, “Akwi gaayémba tékwa du dakwana néma du, de apamama yate wa deku du dakwaké véndakwa. Véndaka deku du dakwa anga wandakwa, ‘De wan nanat yékun yakwa du wa.’ Naandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wunga wandaru guné wani néma du pulak yaké yambak. Guna du nak néma du témunaandu dé du dakwana kukmba yaakwa du pulak téte, dékét déku yé katik kavérékngé dé. Dé néma du téte, dé jémbaa yakapuk baka yarékwa du pulak katik yatéké dé. Dé guna jémbaa yakwa du wa yarékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nak gaayémba yarékwa dunyan yénga pulak daré yo? Deku néma du yénga pulak du dé? Rate kakému karékwa du dé, kapuk wani déké kakému kure yaae kwayéte jémbaa yakwa du dé? Wani rate kakému karékwa du dékét dé wa néma du. Wuné gunale yaréte wunga yamba yawutékwe wa. Wuné gunale yaréte guna jémbaa yakwa du wa yaréwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Guné wunale wa yarésékéyakngunén. Kapérandi musé wunéké yaandéka guné wuné yamba yaasékangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Wuna aapa mayé apa wa tiyaandén, wuné néma du rate du dakwaké kurkale véwuténngé. Tiyaandén mayé apa kéraae gunat kwayékawutékwa, guné wunale yaréte wunale kakému kulak kate, Israelna kém tambavétik maanmba kaayék vétikngé (12) néma du téte véngunénngé.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas Saimon Pitat anga wandén, “Saimon, méné ma véku. Satan apamama yandu guné yaange ye kapma kapma yaréte lambiyakngunénngé mawulé yandékwa. Kakému muni waatandakwa pulak, guné wunga muni waataké wa mawulé yandékwa. Satan guné yaavan kurkwate yandékwa. Yate Gorét waatakundén, dé wunga yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wuné Gorét wa waatakuwutén. Méno, Saimon, ménéké Gorét wa waatakuwutén, méné wunéké yékunmba vékulakaménu ména mawulé kurkale tésékéyakndénngé. Téndu méné wunat kuk kwayétake sérémaa waambule yaae méné wuna dunyanna mawulé yékun yaménu deku mawulé waak kurkale tésékéyak-ngandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wunga wandéka Pita dat anga wandén, “Néman Du, wuné ménale yéké mawulé yawutékwa. Wuné ménale yéte kalapus yakawutékwa wan yékun wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Naandéka Jisas dat wandén, “Pita, a vékusékwutékwa. Bulaa gaan séraa waakapuk téndu méné apu kupuk anga wakaménéngwa, ‘Wuné yamba ve wa Jisas.’ Wunga waménu séraa waaké yakwa.” Naandén Jisas Pitat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas déku dunyansat anga wandén, “Talimba guné wawutéka ye yéwaa, wut, su yamba kure yéngunéngwe. Wani sapak muséké nak guné yapatik kapuk?” Naandéka wandarén, “Yamba wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wunga wandaka det anga wandén, “Bulaa gunat anga wawutékwa. Guné yéwaa kure témunaae yéwaa ma kure yéngunék. Guné wut kure témunaae wut ma kure yéngunék. Waariyangunéngwa kulaa kurerékapuk ye, guna laplap nak kwayéte yéwaa kéraae waariyangunéngwa kulaa ma kéraangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wa wawutékwa. Wunga yangunu Gotna nyéngaamba kwaakwa ani kundi wa sékérék-ngandékwa. Kundi anga wa kwaakwa: Déké wandarén, ‘Wa kapéremusé yakwa du wa. Dé viyaakanangwa.’ Wani kundi wunéké wa viyaatakandarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wunga wandéka wandarén, “Néman Du, ma véménu. Nané waariyanangwa kulaa vétik kure ranangwa.” Naandaka anga wa vékusékndén. De déké yaaké yakwa kapérandi muséké yékunmba yamba vékusékndakwe. Wunga vékusékte wa deku kundi waambule wate wandén, “Yaak wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wani kundi watake Jisas gwaande Oliv némbat yéndén, apapu talimba yandén pulak. Déku dunyansé waak dale yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ye wani taalémba saambake det anga wandén, “Guné Gorét ma waatakungunék, gunat yékun yandu kapérandi musé gunat yaavan kurkapuk yamuké.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Wunga wandéka de rakésndaka dé ayélap yépulak naandén. Matu kéraae vaanéndaka ye vaakérkwa pulak, wulka yéndén. Ye kwaati se Gorét anga waatakundén, “Wuna aapa, méné akwi muséké wa apamama yaménéngwa. Yaakwate yakwa muséké waké mawulé yamunaae waménu wunéké yaakwate yakwa vakmi wunéké katik yaaké dé. Wunga waatakuwutékwa ménat. Méné wuné mawulé yakwa pulak yaké yambak. Ménékét mawulé yaménéngwa pulak ma yaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Naandéka Gotna kundi kure gaayakwa du nak Gotna gaayémba gaaye déku mawulémba yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisasna kwaminyan kapére yasékéyakndéka Gorét nakapuk waatakundén. Waataku-pékaréndéka waangét nyéki pulak vaakwe képmaamba vaakérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas Gorale bulte waatakutake waarape déku dunyanséké yéndén. Ye véndén de yundé kwaakésndaka. De mawulé sémbéraa yate vékundaka deku mawulémba kapére yate deku ménimba yundé yandéka wa kwaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kwaandaka vétake det sérkiyaate anga wandén, “Guné kamuké guné yundé kwaakésu? Guné yundé kwaaké yambakate. Ma waarape Gorét waatakungunu, kapérandi musé asé gunat yaavan kurkapuk yamuké.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wayéka téte bulténdéka wa némaamba dunyansé yaakéran. Jisasna du nak Judas yaambu taaléndéka yaandarén. Judas Jisasét taama réng-ngé we Jisas ténét yaae kwambali-sékéyakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kwambali-sékéyakndéka Jisas dat anga wandén, “Judas, méné Duna Nyaan wunat taama rénge maamat kwayéké méné, kapuk yénga pulak yaké méné?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisasna dunyansé dale téte véndarén wa, wani deké yaan dunyansé Jisas kulkiye kure yéké yandakwan. Wunga vétake Jisasét anga wandarén, “Néman Du, de waariyanangwa kulaat viyaaké nané, kapuk méné yénga méné vékwo?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Naatake deku du nak Gotna gaamba jémbaa yakwa dunyanna néma duké jémbaa yakwa duwat viyaate déku yékutuwa sakuna waan satékyasnyéndéka vaakérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yandéka Jisas vétake wandén, “Yaak. Guné wunga yaké yambakate.” Naatake wani duna waanmba kutndéka nakapuk yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gotna gaamba jémbaa yakwa dunyanna néma dunyan, Gotna kundi bulndakwa gaaké séngite kaavétékwa dunyanna néma dunyan, Israelna maaka dunyan, wunga wa yaandarén, Jisas kulkiye kure yéké. Yaae Jisas wunga yandéka vétake téndaka Jisas det anga wandén, “Guné wuné kurké yaate kamuké guné waariyangunéngwa kulaa baangé waak kure yaau? Guné sél yakwa duwat viyaaké guné wani musé kure yaau, kapuk yénga pulak yaké? ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Apapu nyaa Gotna kundi bulndakwa néma gaamba gunale wa yaréwutén. Yaréwutéka wuné yamba kutngunéngwe. Bulaa guna jémbaa a yakangunéngwa. Bulaa ganngunganna néma du Satan apamama yakandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas wani kundi wandéka dé kulkiye kure yéndarén. Kure ye Gotna gaamba jémbaa yakwa akwi dunyanna néma duna gaat kure wulaandarén. Kure wulaandaka Pita deku kukmba ye lakasatiye apakmba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Téndéka de wani Jisas kure yén dunyan aatmu gisangwandéndarén taalémba wulaae yaa yamungandarén. Yamunge randaka Pita dele yaamba randén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Randéka jémbaa yakwa taakwa nak dat vélén. Vétake déku saawit vésék vésék naate wa anga walén, “Ani du waak Jisasale wa yaténdén.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naaléka Pita wa wan, “Nyéno, wuné dé yamba vésékwutékwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wunga wandéka raré naae kukmba nak du dat vététe wandén, “Méné waak Jisasna du wa.” Naandéka wandén, “Méno, wuné yamba wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naandéka raré naae kukmba nak du waak dat véte némaanmba wandén, “Ani du waak dé Galili du a. Dé waak Jisasale wa yaténdén. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wunga wandéka Pita wa wan, “Méno, wa waménéngwa kundi wuné yamba vékwe wa.” Wunga waké naaténdéka séraa nak bari waan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Waandéka Néman Du Jisas awulaka apakmba pulak téte waalakwe Pitat véndén. Véndéka dat wani takamba Jisas wan kundiké vékulakandén. Takamba Jisas dat anga wandén, “Wuné vékusékwutékwa wa. Bulaa gaan séraa waakapuk téndu méné apu kupuk wakaménéngwa, ‘Wuné yamba véwutékwe wa Jisas.’ Wunga waménu séraa waaké yakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wani kundiké vékulake Jisasét kuk kwayétake wa Pita gwaande mawulé sémbéraa yate némaamba géraandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisas kurin dunyansé dat waangite wasélékte viyaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Viyaate déku méni laplapét gitépétake dat anga wandarén, “Méné Gotna kundi kwayékwa du rate akwi muséké wa vékusékménéngwa. Vékusékte ma wa nanat. Ménat kandé viyaak?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wunga wate némaamba kapérandi kundi ras waak wandarén dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nyaa yaalandéka Israelséna maaka dunyan, Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan, de wunga yaae jaawundarén. Jaawuwe téndaka Jisaské séngiye kaavétan dunyan dé kure yaandarén deké. Kure yaae taakandaka deku ménimba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Téndéka dat anga wandarén, “Méné ma wa nanat. Méné Got wan du Krais méné kapuk?” Naandaka det wandén, “Gunat wamunaawutu yékunmba vékulakamuké kalik yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wuné gunat waataku-munaawutu guné wuna kundi waambule wamuké kalik yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sérémaa Duna Nyaan wuné néma du rate, apa tapa yakwa du Gotna yékutuwa taambamba rakawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wunga wandéka de akwi wandarén, “Yénga méné wo? Méné Gotna nyaan méné, kapuk yénga méné?” Naandéka wandén, “Yi. Gunékét guné wa wunga wakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naandéka wandarén, “Dékét déku kapmang wa kapérandi kundi wandéka vékunanén. Vékutake yandén musé aséké ras waak katik vékuké nané.” Naandarén Israelséna néma dusé Jisaské. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wunga ye de wani néma dunyansé akwi waarape Jisas Romna néma du déku yé Pailat, déké kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kure ye Jisaské dat anga wandarén, “Ani du dé kapérandi muséké wa nana du dakwat yakwasnyéndén. Yate nanat anga wandén, ‘Guné Romna néma duwat takis kwayéké yambak.’ Naandén. Wunga watake anga wandén, ‘Wuné néma du a rawutékwa. Wuné Got wan du Krais wuné anana.’ Naandéka wa dé ménéké kure yaananén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wunga wandaka Pailat Jisasét waatakundén, “Méné Judaséna néma du méné kapuk?” Naandéka Jisas wa wan, “Yi. Ménékét ména kapmang wa waménéngwa wunga.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naandéka Pailat Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, dele tékésén némaamba du dakwat anga wandén, “Ani du kapérandi musé nak yamba yandékwe wa. Wunga vékusékwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Naandéka de némaanmba nyaarang naate anga wandarén, “Déku kundi Judiamba tékwa akwi du dakwat kwayéndéka kurkale yarékapuk yate waariyaké yandakwa. Taale Galilimba kundi kwayétake bulaa anga yaae nanat wunga kundi kwayéndékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat wani kundi vékutake det anga waatakundén, “Ani du Galili du dé, yi?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wunga wandéka yi naandarén. Yi naandaka Pailat wa vékusékndén. Talimba Romna néma du wandéka Herot néma du téndén Galili distrikmba. Jisas Galili du wa. Yaténdéka Herot Jisasna néma du téndén. Wani sapak Herot waak Jerusalemmba wa yaréndén. Wunga vékuséktake Pailat wandéka Jisas Herotké kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Talimba Herot Jisaské kundi vékutake dé véké wa mawulé yaréndén. Ye késépéri baapmu Jisas vékapuk yaréndéka wani sapak dé déké kure yaandaka Herot dat véte mawulé tawulé wa yandén. Jisas talimba vékapuk yandén kulé apanjémba nak déku ménimba yandu véké wa mawulé yate dusék yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yate Jisasét késépéri muséké waatakundén. Waatakundéka Jisas déku kundi nak yamba waambule wandékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yandéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, apakundiké vékusékngwa dunyan waak wamba téte némaamba saték naate kapérandi kundi Jisaské wandarén Herorét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Wandaka Jisas Herotna kundi waambule wakapuk yandéka Herot déku waariyakwa dunyansale Jisasét waangite wasélékndarén. Dat “Gandéndu” waate Herot dat waangite wasélékndén. Yate anga wandén, “Du dakwana néma du dé yéku laplap male wa saawundékwa.” Naatake wandéka paapu ye yéku laplap kéraae Jisasét saawutake dat waangiye waambule Pailatké dé kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Talimba Pailat Herorale maama yaténdén. Pailat Herotna yé kavérékte wandéka Jisas Herotké kure yéndarén sapak, Herot wani muséké dusék yate Pailarale naawi kure yékunmba yarémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat wandéka de Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Israelséna néma dunyan, némaamba du dakwa waak yaae jaawundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jaawundaka det wandén, “Guné ani du wunéké kure yaae anga wangunén, ‘Dé du dakwana yéku mawulé yaavan kutndékwa. Dé asa kapérandi musé wa yandén.’ Naangunénga wuné guna ménimba téte dat ani muséké waatakuwutén. Waatakutake gunat anga wawutékwa. Dé wani wangunén kapérandi musé yamba yandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot waak wungat male wandékwa. Wunga wandéka wa dé waambule nanéké kure yaandarén. Ma véku. Kapérandi musé nak yamba yandékwe wa. Dat katik viyaandékngé nané. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Watakawutu wuna dunyan dat viyaandaru baka yékandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akwi kwaaré Pasovana kakému kandakwa sapak Romna néma du Pailat kalapusmba kwaan du nak watakandéka kalapus yaasékatake baka gwaande yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailat wani kundi wandéka wamba tékésén du dakwa de akwi némaanmba nyaarangte anga waandarén, “Wani duwat viyaandéktake ma Barabasét waménu kalapus yaasékatake yaale baka yékandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Talimba wani du Barabas Romna dunyanngé kalik yate Jerusalemmba tékwa du dakwat watakandéka Romna dunyansale waariyandarén. Nakapuk Barabas du nakét viyaandékndén. Wunga yandéka wa dé kalapusmba taakandaka kwaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wamba tékésén du dakwa wunga waandaka Pailat Jisas baka yéndénngé mawulé yandén. Ye det nakapuk wandén, Jisas baka yéndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wandéka de kalik yan. Yate némaamba waate anga wandarén, “Dé takwemimba ma baangtaka. Dé takwemimba ma baangtaka.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naandaka det nakapuk wandén, “Kamuké? Kamu kapérandi musé dé yak? Dat katik viyaandékngé nané. Kapérandi musé nak yamba yandékwe wa. Watakawutu wuna dunyan dat viyaae taakandaru yaale yékandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wunga wandéka de kalik yate némaamba waate wandarén, dé watakandu de Jisas takwemimba baangndarénngé. Wunga wate Pailatna kundi yamba vékundakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yandaka Pailat deku kundimba vékwe wa wandarén pulak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ye wandéka wani mawulé yandarén du Barabas kalapus yaasékatake gwaande baka yéndén. Talimba Barabas Romna dunyanngé kalik ye du dakwat watakandéka Romna dunyansale waariyandarén. Nakapuk Barabas du nakét viyaandékndén. Wunga yandéka wa dé kalapusmba taakandaka kwaandén. Pailat Barabas baka yéndénngé watake wa Jisas takwemimba baangndarénngé watakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Romna waariyakwa dunyansé Jisas kure yéte véndarén Sairini du nak déku yé Saimon Jerusalemét wulaaké yaandéka. Vétake dé kulkiye Jisas baangtakandara takwemi yaate Jisasna kukmba yéndénngé wandarén. Wandaka yaate dele yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yéténdaka némaamba du dakwa wa Jisasna kukmba yéténdarén. Yététe dakwa ras mawulé sémbéraa yate déké géraandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Géraandaka Jisas waalakwe det anga wandén, “Guné Jerusalemmba yarékwa dakwa, guné wunéké géraaké yambak. Gunékét gunéké, guna nyambaléké waak ma géraangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kapérandi sapak yaandu du dakwa anga wakandakwa, ‘Ani kapérandi sapak dakwa deku nyambaléséké néma sémbéraa yandakwa. Sémbéraa yandakwanngé vékulakate nyaan kéraaké yapatikwa dakwa, nyaan kéraakapuk yan dakwa, nyambalé munyaa kwayékapuk yan dakwa, wani dakwa ani kapérandi sapak deku nyambalé yarékapuk yandaru mawulé tawulé yénga yandaru.’ Naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wani kapérandi sapak du dakwa deké yaaké yakwa kapérandi muséké wup yate anga wakandakwa, ‘Némbu ma vaakére nanat tekéténdaru.’ Naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wuné kapérandi musé nak yamba yawutékwe wa. De wunat ani kapérandi musé baka yate yénga pulak yaké daré, Jerusalemmba yaréte kapérandi musé yakwa du dakwat? Det némaamba kapérandi musé wa yakandakwa.” Wani dakwat wunga wandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Waariyakwa dunyan kapérandi musé yan du vétik waak kure yéndarén. Bét Jisasale sékét viyaaké we kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kure ye Duna Maaka Apa waandakwa taalémba saambakndarén. Saambake wamba Jisas takwemimba baangndarén. Yatake wani kapérandi musé yan du vétik waak takwemimba baangndarén. Nak du Jisasna yékutuwa sakumba baangtakandarén. Nak du déku akituwa sakumba baangtakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas takwemimba baangtakandaka anga wandén, “Aapa, ani wunat yandakwa kapérandi muséké vékulakate méné det waambule yakataké yambak. De yamba vékusékndakwe wa yandakwa muséké.” Naandén Jisas. Jisas takwemimba baangtake de rate déku laplap muni waataké satu pulak pilai yandarén. Yandaka det taalékéran du wa déku laplap kéraan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yaténdaka du dakwa téte vésékndarén. Véténdaka Israelna néma dunyan Jisasét waangite wasélékte anga wandarén, “Dé du dakwat yékun yandén. Dé nanat yékunmba yandénngé Got wani wan du Krais yarémunaae, wa dé dékét déku sépat déku kapmang yékun yakandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Naandaka de waariyakwa dunyansé waak dat waangite wasélékte yaae dat nyéngi yakwa wain kulak kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kwayéte wandarén, “Méné Judaséna néma du témunaae ma ména kapmang ména sépat yékun yaménu.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisas baangtakandarén wani takwemina waambumba anjoré anga viyaatakandarén: Ani du an Judaséna néma du a. Naatakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jisasale takwemimba baangtakandarén du nak Jisasét waarute anga wandén, “Méné waménén, ‘Wuné gunat yékun yawuténngé Got wan du a.’ Waménén wani kundi sékérékmunaandu, ma ména kapmang ména sépat yékun yate aana sépat waak yékun yaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wunga wandéka Jisasale takwemimba baangtakandarén nak du wani kundi vékutake dat waarute anga wandén, “Jisas kiyaana pulak méné kiyaaké yate Gorké wup yakapuk yate méné wani kapérandi kundi wo, yi? ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kapérandi musé yaténngé aané viyaandaru wan yékun wa. Ani du kapérandi musé nak yamba yandékwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naandéka wandén, “Jisas, méné apamama ye du dakwaké néma du raké waambule yaate wunéké ma vékulakaménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wunga wandéka Jisas wa wan, “Bulaa ani nyaa méné wunale yéku taalémba rakaménéngwa. Yi wan wanana wa.” Naandén Jisas dat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nyaa naawure kayéndéng téndéka akwi képmaa gaan yan. Ye téndéka nyaa yamba ve wa. Kukmba nyaa tépatekwe daawuliké yaténdéka (3 klok) Gotna kundi bulndakwa néma gaamba wani lékitakandarén sémény laplap nyéndémba gérike aangé vétik yan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yandéka Jisas némaanmba anga waandén, “Aapa wa, wuna kwaminyan ména taambamba a taakawutékwa.” Watake wunga kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kiyaandéka waariyakwa dunyanséna néma du vétake Gotna yé kavérékte wandén, “Ani du yéku musé male yan du a. Yi wan wanana wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wani musé véké yaae jaawuwe tékésén akwi du dakwa Jisas kiyaandéka vétake mawulé sémbéraa yate deku gaayét waambule yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yéndaka de wani Jisas vésékén dunyansé, dakwa ras waak de wunga apakmba pulak téte wani musé yandéka véndarén. Talimba Jisas Galili taakatake yéndéka de wani dakwasé wa dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Du nak yaréndén. Déku yé Josep wa. Judamba tékwa gaayé Arimatea du wa. Dé yéku musé yakwa du yaréte, Got néma du rate du dakwaké vérénda sapakngé wa kaavéréndén. Dé néma du téte talimba nak néma dunyansale jaawuwe rate Jisas viyaandékngé bulndarén kundi dele bulte dé yamba yi naandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wani du ye Romna néma du Pailarét waatakundén Jisasna pusaa kéraamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Waatakundéka yi naandéka ye Jisasna pusaa lepékwe kure gaaye waama laplapét saape kwaawumba taakandén. Wani kwaawu talimba Josep dékét déku jémbaa yakwa dunyansé wa matumba vaae wulaan. Talimba wani kwaawumba kiyaan duna pusaa nak yamba taakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Garambu Josep Jisasna pusaa kwaawumba taakandén. Judana yaap yaré nyaa yaaké yandéka wa wunga yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilimba Jisasale yaan dakwasé Josepna kukmba ye véndarén dé Jisasna pusaamba yéku yaama yakwa musé kurkapuk baka taakandéka. Taakandén taalé waak véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vétake gaayét waambule ye pusaamba kurké watake yéku yaama yakwa musé kéraatakandarén. Kéraae taakatake yaap yaré nyaa Moses wan apakundi wandékwa pulak wa yaap yaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yaap yaré nyaa yéndéka Sande ganmbamba nyaa yaalaké yaténdéka wani dakwasé taakandarén yéku yaama yakwa musé kéraae kure yéndarén, Jisasna pusaa rémndarén taalat. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ye véndarén wani kwaawumba kétaaktépéndarén matu varémansati-takandaka randéka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vétake kwaawumba wulaae Néman Du Jisasna pusaaké vépatikndarén. Yamba re. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yatake wani muséké wamba téte vékulaka vékulaka naaténdaka du vétik gaaye dele témbérén. Bérku laplap wamatama ye kalkal naan. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Témbéréka de wup ye kwaati se saawi képmaat tindarén. Yandaka anga wambérén, “Kamu yaké guné waaku kiyangambana taalémba taamale waarape kulé rakwa duké? ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dé amba yamba re wa. Dé wa nakapuk taamale waarapén. Dé Galilimba yatéte gunat wani wandén kundiké ma vékulakangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dé anga wa wandén, ‘De Duna Nyaan wuné kwayékandakwa kapérandi musé yakwa dunyanét. Kwayéndaru wuné takwemimba baangtakandaru kiyaawutu nyaa vétik yéndu kupuk yambanmba nakapuk taamale waarapkawutékwa.’ Wunga wandén kundiké ma vékulakangunu.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bérku kundi vékutake wani dakwasé Jisas talimba wandén kundiké vékulakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vékulake pusaa rémndarén kwaawu taakatake nakapuk waambule yéndarén. Ye Jisasna dunyan tambavétik maanmba kaayék nakurak (11) det wani muséké wandarén. De Jisasna jémbaamba yaalan ras du dakwat waak wani muséké wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wani kundi Jisasna dunyansat saapan dakwasé, wan Makdala taakwa Maria, Joana, nak Maria lé Jemsna aasa, ras dele sékét yaréndarén dakwa waak. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wani kundi saapéndaka vékutake de Jisasna dunyan wa wan, “Wa paapu wa yandakwa. Wa yaambumba kundi wa.” Naatake deku kundi yamba vékundakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yandaka Pita waarape pétépété yéndén Jisasna pusaa rémndarén kwaawut. Ye kwaatambe yaasole véndén pusaamba saaptakandarén laplap male randéka. Vétake waambule déku gaat yéte vékulaka vékulaka naayéndén wani muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wani nyaa talimba Jisasale yeyé yaayatan du vétik bét Emeusét yéndakwa yaambumba yémbérén. Du dakwa Jerusalem taakatake wani gaayét yéte kulémba pulak wa yékandakwa (11 kilomita pulak). ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bét yéte Jisas kiyaanngé saapélaakét yétémbérén. Saapéte Jisaské dakwasé wan muséké waak saapé yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Saapélaakét yétémbéréka Jisas dékét déku kapmang yaae bérale yéténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yéténdéka dat véte yamba vésékmbérékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yambéréka bérét anga wandén, “Béné kamuké béné bulaakét yu?” Wunga wandéka bét Jisas kiyaanngé vékulakate mawulé sémbéraa yatémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Téte du nak déku yék Kliopas déku kundi waambule anga wandén, “Késpulak nakpulak gaayémba yaan némaamba du dakwa Jerusalemmba bulaa rate wa vékusékndakwa wani yandarén muséké. Méné, nak gaayémba yaan du, méné nakurak méné ani nyaa Jerusalemmba yandarén muséké vékusékngapuk yo kapuk?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wani kundi wandéka Jisas bérét anga waatakundén, “Kamu daré yak?” Wunga waatakundéka bét yékéyaakmba téte dat wambérén, “Nasaret du Jisasét wa wani musé yandarén. Dé Gotna yémba kundi kwayétan du nak wa. Dé Gotna ménimba, akwi du dakwana ménimba waak téte dé yéku apanjémba yate néma kundi waténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yaténdéka Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, nana néma dunyan waak dé kwayéndarén Romna duwat, dé viyaandékndaru kiyaandénngé. Kwayéndaka dé takwemimba baangndaka kiyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Talimba nana mawulémba anga wananén, ‘Wani du nané Israelsat kéraae yékun yakandékwa.’ Wunga warénanga dé wa viyaandékndarén. Wani muséké wa bulte ani muséké waak watékwa. Dékény Jisasét viyaandékndaka nyaa vétik yéndéka bulaa a nyaa kupuk yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nak muséké waak bultékwa. Bulaa nanale Jisasna jémbaamba yaalan dakwa ras wan kundiké vatvat naananén. Ganmbamba déku pusaa rémndarén taalat yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ye déku pusaa yamba véndakwe. Yatake waambule yaae nanat anga wandarén, ‘Nané ye Gotna kundi kure gaayakwa duwat vénanga anga wambérén, “Dé wa nakapuk taamale waarapén.” Naambérén.’ ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wani dakwasé yaae nanat wunga saapéndaka nana du ras yén, Jisasna pusaa rémndarén taalat. Ye wani dakwa saapan pulak véndarén. Ye vétake Jisas yamba véndakwe wa.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wani kundi wambéréka Jisas bérét anga wandén, “Béné yamba yékunmba vékulaka-mbénéngwe wa. Béna mawulé yékunmba tékapuk yandéka wa béné Gotna yémba talimba kundi kwayétan dunyanna kundi ayélapkéri wa vékumbénén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wani dunyan anga wandarén, ‘Taale kapérandi musé Got wan du Kraiské yaandu kukmba dé néma du randu de déku yé kavérék-ngandakwa.’ Wunga wandén kundi béné yamba kurkale vékumbénéngwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wunga watake Moses déké viyaatakandén kundi, Gotna yémba kundi kwayétan akwi dunyan déké viyaatakandarén kundiké waak bérét wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yambuyambu bulaakét ye bét yéké yén gaayémba saambakngé yaténdarén. Ye saambake Jisas nakapuk yékwate yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yandéka dat wambérén, “Yémbak. Nyaa daawulindu gaan a yaké yakwa. Yandu méné aanale kwaaké ya.” Wunga wambéréka wulaae bérale randén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rate kakému kaké yate bret kéraae Gorét anga wandén, “Yéku kakému a tiyaaménén nanat. Wan yékun wa.” Wunga watake bret bule bérét kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kwayéndéka bét bari dé vésék naambérén. Vésékmbéréka wamba yamba randékwe. Bét dé yamba vémbérékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yatake bérku kapmang bulte anga wambérén, “Aané yaambumba yaatéka Gotna nyéngaamba kwaakwa kundiké aanat wandéka, wa aana mawulé yékun yan. Yi wan wanana wa.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wunga watake bari waarape Jerusalemét nakapuk waambule yémbérén. Ye vémbérén Jisasna dunyan tambavétik maanmba kaayék nakurak (11), déku jémbaamba gwaandan du dakwale jaawuwe randaka. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vémbéréka bérét wandarén, “Nana Néman Du dé wa nakapuk taamale waarapén. Yi wan wanana wa. Taamale waarapndéka Saimon wa vén dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wunga wandaka bét yaambumba yétémbéréka Jisas bérké yaandénngé saapémbérén. Jisas bérale rate bret buléndéka wani nyaa male dé vésékmbérénngé waak det wani kundi saapémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bét wani kundi watémbéréka dékét Jisas déku kapmang yaae deku nyéndémba téndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Téndéka de vatvat naae wup yate deku mawulémba anga wandarén, “Wa gaamba dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wunga wandaka det wandén, “Kamuké guné vatvat naau? Kamuké guné guna mawulémba vékulaka vékulaka naau? ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wuna maan taambat ma véngunu raaményét baangndarén katak. Véte guné vésékngé ya. A wuné a tékwa. Wunat ma kutte guné véké ya. Véte vésék-ngangunéngwa. Gaamba yamba wa. A wuné a tékwa. Gaamba de sépémaalé yamba kure téndakwe wa, wuné kure tékwa pulak. An wunat a véténgunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wunga watake déku maan taamba det wakwasnyéndén, raaményét baangndarén wani katak véndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jisasna dunyan dat vétake vékulaka vékulaka naandarén. Yate mawulé tawulé yate deku mawulémba anga wandarén, “Yénga véké? A kiyaae taamale waarapén du Jisas dé, kapuk kandé?” Wunga vékulakandaka det waatakundén, “Guné amba kakému ras guné taakak?” ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wunga waatakundéka tutakandaka ran gukwami dat kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kwayéndaka kéraae kandéka véndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wani kwaami katake det anga wandén, “Talimba wuné gunale yatéte gunat anga wa wawutén, ‘Talimba Moses kundi wunéké wandéka, Gotna yémba kundi kwayétan dunyan waak wunéké wa kundi kwayéténdarén. Talimba gwaaré waatan dunyan de waak wunéké wa wandarén. Wandarén kundi Gotna nyéngaamba wa kwaakwa. Wunéké viyaatakandarén kundi akwi sékérék-ngandékwa.’ Wunga wawutéka bulaa wani kundi wa sékérékén. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wunga wate deku mawulé kutélangndén, de Gotna nyéngaamba kwaakwa kundi yékunmba vékusék naandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yate det anga wandén, “Gotna nyéngaamba ani kundi wa kwaakwa: Got wan du Krais néma kaangél kure kiyaakandékwa. Kiyaae nyaa vétik yéndu kupuk yambanmba wa nakapuk taamale waarapkandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Déku apu déku yémba ani kundi ma kwayéndarék akwi du dakwat: ‘Guné yangunén kapéremuséké kalik ye ma yaasékangunu. Yaasékangunu Got yangunén kapéremusé yasnyéputi-kandékwa.’ Wani kundi Jerusalemmba tékwa du dakwat taale baasnyé ye kwayéte nak gaayémba tékwa du dakwa, képmaana akwi taalémba tékwa du dakwat waak ma kwayéndarék. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Guné wani musé akwi wa véngunén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Talimba wuna aapa anga wandén, ‘Sérémaa wuna Yaamambi gunat kwayékawutékwa. Yi wan wanana wa.’ Wunga wandénngé wuné wawutu wuna aapana Yaamambi guna mawulémba wulaae rakandékwa. Taale Jerusalemmba ma kaavéréngunu déké. Kaavéréngunu Gotna Yaamambi anjorémba gaaye gunat mayé apa kwayéndu nak gaayét yékangunéngwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas wunga watake de kure Jerusalem taakatake ayélap yépulak naae Betanimba saambakndarén. Saambake déku taamba kusoréte Gorét waatakundén, det yékun yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Waatakutéte de yaasékandéka Got dé déku gaayét kure waaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Waaréndéka de mawulé tawulé yate waambule yéndarén Jerusalemét. ");
INSERT INTO abt_wosera_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ye apapu Gotna kundi bulndakwa néma gaamba téte Gotna yé kavérék-téndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Talimba nyét képmaa akwi musé yaalakapuk téndéka Gotna nyaan wa ran. Déku yé Kundi wa. Dé Gorale wa randén. Dékét dé Got wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Talimba, taale Kundi Gorale wa randén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Randéka Got wandéka dékét déku kapmang wa nyét képmaa akwi musé yandén. Musé nak déku kapmang yamba yaalandékwe wa. Akwi musé asé salmu walmu dékét déku kundi male wa yawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dé kulémawulé kwayékwa du wa. Kulémawulé kwayéndu du dakwa kulémawulé kéraae yékunmba yatépéka-kandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kulémawulé kwayéte vérékngwa yaa pulak wa randékwa. Du dakwana kapére mawulé ganngungan pulak wa tékéskwa. Yandéka wani yaa ganngumba vérékte kaaléndéka, de kapére mawulé yakwa du dakwa ganngumba téte vélékéyaakngé yapatindakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Got du nakét wandéka wa yaandén. Wani duna yé Jon wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dé du dakwat wani yaaké kundi bulké wa yaandén. De wani yaa pulak duké deku mawulémba anga wakandakwa, “Wani du wan Gotna nyaan wa. Yi wan wanana wa.” Naakandakwa. Wunga wandarénngé wa Jon wani kundi bulndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dé wani yaa pulak duké wa du dakwat kundi kwayéké yaandén. Jon dé wani yaa pulak du yamba wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Du dakwana kapére mawulé ganngu ye tékwa. Yaa pulak du yaa ganngumba vérékte kaalékwa pulak, deku mawulémba kaaléndu deku mawulé yékun yandénngé wa dé ani képmaat gaayandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Talétalé wani du wa ani képmaa yan. Yatake dé ani képmaat gaayandéka de ani képmaamba tékwa du dakwa déké yamba vékusékndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dékét déku gaayét wa yaandén. Yaandéka déku gaayé du dakwa déku kundi vékukapuk yate wa dé kalik yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","De ras déku kundi yékunmba vékundarén. Vékute wandarén, “Dé nana néma du wa.” Wunga wandaka dé wandéka de Gotna nyambalésé wa téndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Deku aasa aapa deké mawulé yandaka aasa de kéraatakandaka daré Gotna nyambalésé yarékésu, kapuk képmaana du nak wandéka daré Gotna nyambalésé yaro? Yamba wa. Got nakurak déku kapmang wandéka wa déku nyambalésé yarékésndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gotna nyaan, déku yé Kundi, dusépé ye wa nana képmaat gaayandén. Gaaye nanale yaténdén. Yatéte papukundi yamba wandékwe wa. Nanéké sémbéraa yate yéku yéku kundi male waténdén. Yi wan wanana wa. Wandéka dat véte wananén, “Got déku mayé apa wa kwayéndén dat. Kwayétake wandéka wa gaayandén. Dékét dé wan Gotna nyaan wa. Du nak dé yakwa pulak katik yaké dé.” Wunga wananén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Baptais kwayékwa du Jon wani du yaandéka wa vétake wandén, “Dat ma vé. Talimba ani duké wa gunat wawutén, ‘Wuna kukmba yaakwa du dé néma du wa. Wuné baka du a taale yaakwa. Wuna aasa talimba wuné kéraakapuk yalén sapak wani du wa Gorale ran.’ Wunga wa wawutén gunat.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kundi, déku nak yé Jisas Krais wa. Apamama yate déké yékunmba vékukwa du dakwa nanat yékun yakandékwa. Nanéké mawulé sémbéraa yate nanéké vékute dé néma du rate nanat yékun yarépéka-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Talimba Got wandéka Moses Gotna apakundi du dakwat kwayéndén. Kukmba Got wandéka Jisas Krais yaae dé nak kundi kwayéndén. Dé Gorké papukundi yamba wandékwe wa. Yéku kundi wa kwayéndén. Yi wan wanana wa. Got nanéké mawulé sémbéraa yandékwanngé wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Du nak Got yamba véndékwe wa. Véte déku jémbaaké yamba vékundékwe wa. Déku nyaan Jisas male wa nakurak dale re vétake déku jémbaaké vékusékndén. Vékuséke gaaye wa nanat yéku kundi wandén, déku aapa Gorké. Wandéka wa nané Gotna jémbaaké vékuséknangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Baptais kwayékwa du Jon yaténdéka Judana néma dunyansé, de Gotna gaamba jémbaa yakwa dunyan ras, Livai dunyan ras, wunga det wandaka Jerusalemmba yaae Jonét waatakundarén, “Méné kandé?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wunga waatakundaka Jon wa wan, “Wuné Got wan du Krais yamba wa. Wuné du dakwat yékun yaké yakwa du yamba wa.” Wunga watake yéku kundi wandén. Kundi yamba paakundékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yandéka dat nakapuk waatakundarén, “Méné kandé? Méné Elaija, kiyaae méné nakapuk taamale waarapék kapuk?” Wunga waatakundaka Jon wa wan, “Yamba wa. Wuné Elaija yamba wa.” Naandéka nakapuk waatakundarén, “Nané Gotna kundi tiyaaké yakwa kulé duké wa kaavérénangwa. Kaavérénangwa du méné wani méné?” Naandaka Jon wa wan, “Yamba wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wunga wandéka dat nakapuk waatakundarén, “Méné kandé? Du ras nanat wandaka yaananén. Nané waambule ye det yénga waké nané? Méné ménékét ména jémbaaké yénga méné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wunga waatakundaka Jon wa wan, “Wuné kundi bulkwa du a. Wuné du dakwa yarékapuk taalémba yatéte anga wawutékwa, ‘Néman Du yaanda yaambu ma kururéngunék.’ Wuné Aisaiana kundi vékute wa ani kundi wawutékwa. Talimba wani kundi Gotna nyéngaamba viyaatakandéka bulaa wuné yaae wani kundi a bulwutékwa.” Gwaaménja kundi wunga wandén det, deku mawulé yékun téndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Talimba Farisi dunyan det wandaka wa yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","De yaae Jonna kundi vékute dat waatakundarén, “Du dakwa deku kapére mawulé yaasékandaka méné det Gotna yémba baptais kwayéménéngwa. Kamuké méné wunga yo? Méné Elaija yamba wa. Méné kaavérénangwa du yamba wa. Méné baka du wa, kamuké méné det Gotna yémba baptais kwayu?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wunga waatakundaka Jon wa wan, “Wuné Gotna yémba det baptais kwayéwutékwa. Wa makal jémbaa wa. Néma du nak gunale wa téndékwa. Guné dé yamba véngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dé wuna kukmba wa yaandékwa. Dé yaae néma jémbaa yakandékwa. Dé néma du wa randékwa. Wuné baka du a téwutékwa. Yénga pulak ye déku jémbaa yaké wuté? Baka du téwutékwanmba.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betanimba yatéte Jon wani kundi bulndén. Jordan kaambélé téndéka wani gaayé nak sakumba tékwa. Wamba yatéte du dakwat Gotna yémba baptais kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kukmba nak nyaa Jon téte véndén Jisas dé yaran taalat yaandéka. Yaandéka Jon dat vétake wandén, “Guné akwi ani duwat ma vé. Dé Gotna sipsip nyaan wa. Talimba yandarén kapéremusé yasnyéputimuké, de sipsip nyaanét viyaate wa Gorké tuwe kwayéndarén. Nyansipsip viyaandarén pulak, dat wunga viyaandaru kiyaakandékwa, ani képmaana du dakwana kapére mawulé yasnyéputimuké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dékénykakét wani duké vékutake wa gunat anga wawutén, ‘Wuna kukmba du nak yaakandékwa. Dé wuna néma du wa. Wuna aasa wuné kéraakapuk yaléka talimba dé wa yaran.’ Naawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Talimba wuné dé yamba véwutékwe wa. Bulaa male a véwutékwa. Déké wa gunat kundi bulte Gotna yémba guné baptais kwayéwutén. Guné Israelsé ani duké vésékngunénngé wa wunga yawutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Wunga watake wandén, “Got wandéka yaae wa gunat wuné déku yémba baptais kwayéwutén. Talimba Got wunat anga wandén, ‘Wuna Yaamambi gaaye du nakale téndu vékaménéngwa. Wani du wandu wuna Yaamambi du dakwana mawulémba wulaakandékwa.’ Wandén pulak, déku Yaamambi nyaamiyo pulak ye gaaye duwale téndéka véwutén. Taale ani du yamba véwutékwe wa. Yaréwutéka Gotna Yaamambi déké gaaye téndéka wa wuné dé vésékwutén. An dé Gotna nyaan a. Wuné vésékte wa gunat wawutékwa.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nak nyaa kukmba, Jon nakapuk téndéka déku du vétik dale sékét témbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te Jon wa vén Jisas yéndéka. Vétake wandén, “Ma vé. Wan Gotna nyansipsip wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wunga wandéka bét Jisasna kukmba yémbérén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","39","Yémbéréka Jisas waalakwe véndén déku kukmba yaatémbéréka. Vétake bérét wandén, “Kamuké béné waaku?” Naandéka wambérén, “Rabai, yani gaamba méné yaro?” Wunga wambéréka wandén, “Ma yaae béné véké ya.” Wunga wandéka ye yaréndékwa gaa kwaandéka vémbérén. Vétake dale yarémbérén. Yamba yémbérékwe, garambu yandéka. Wani kundi Rabai, nana kundimba anga wanangwa, “Gotna kundi yakwasnyékwa du wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jonna kundi vékutake wa Jisasna kukmba yémbérén. Du nak déku yé Andru wan Saimonna waayéka wa. Saimonna nak yé Pita wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru Jisas yaasékatake bari ye Saimonét vétake wandén, “Aané Mesaia a vétén.” Naandén. Wani yé Mesaia nana kundimba wanangwa: Got wan du Krais wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naatake Andru Saimon we Jisaské kure yéndén. Kure yéndéka Jisas Saimonét wandén, “Méné Saimon wa. Méné Jonna nyaan wa. Sérémaa ména yé anga waakanangwa, Sifas.” Naandén Jisas. Wani yé Sifas, nak gaayéna kundimba wandakwa, Pita. Nana kundimba wanangwa, Matu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Nak nyaa Jisas nak taalat yémuké vékulakandén. Wani taaléna yé Galili wa. Vékulake ye Filipét véndén. Filip dé Betsaida du wa. Betsaida wan Filip, Andru, Pita deku gaayé wa. Jisas Filipét vétake wandén, “Ma yaa méné wunale.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naandéka Filip Jisasna jémbaa yatéte ye Natanielké waakndén. Waake ye dat vétake wandén, “Talimba nana gwaal waaranga maandéka bakamu Moses, de Gotna yémba kundi kwayétan dunyansé waak, de kulé duké Gotna nyéngaamba viyaatakandarén. Wani du wa vénanén. Nasaret du Jisas wa. Dé Josepna nyaan wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wunga wandéka Nataniel wa wan, “Nasaret wan kapérandi gaayé wa. Yénga pulak ye yéku du Nasaretmba yaaké dé?” Naandéka Filip wa wan, “Ma yaae vé.” Naandéka yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel yaandéka Jisas vétake déké anga wandén, “Ma vétake. Nané Israelna du nak wa yaatékwa. Dé yéku du wa. Papukundi yamba bulndékwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naandéka Nataniel wa wan, “Yénga pulak ye méné vésékék wuné?” Wunga waatakundéka Jisas wa wan, “Filip yamba waae wa méné wani miyé maawumba yaréménénga, wuné wa méné ve vésékwutén.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Wunga wandéka Nataniel wa wan, “Néma du, méné Gotna nyaan wa. Méné nané Israelséna néma du wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wunga wandéka Jisas wa wan, “Méné wani miyé maawumba yaréménénga véwuténngé wa wawutén. Wawutéka bulaa méné wunéké yékunmba vékulaka-ménéngwa. Sérémaa véména musé wa yaae a véménéngwa musat taalékére yasandaké yakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wunga watake wandén, “Kukmba sérémaa vékangunéngwa Gotna gaayé téndu déku kundi kure gaayakwa dunyansé Duna Nyaan wunéké waaré gaayandaru. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Nyaa vétik yéndéka nak nyaamba du nak taakwa kéraandén Kanamba. Wani gaayé Galili distrikmba téndékwa. De waandaka Jisasna aasa ye taakwa kéraakwa duna gaamba yaréléka Jisasét wandaka déku dunyansale sékét wani musé véké watake yéndarén. Ye rakésndaka kukmba wani wain kulak késén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Késndéka Jisasna aasa dat walén, “De wain kulak yamba yé wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Naaléka Jisas wa wan, “Nyéné wuna jémbaaké waké yambak. Wuna jémbaa yaké yawutékwa sapak wayéka yamba yaae wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naandéka lé déku aasa jémbaa yakwa dunyansat walén, “Gunat wandékwa kundi vékute wandékwa pulak ma yangunék.” Naalén det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nané Judasé nana apakundi vékute maan taamba kurkale yakwasnyénangwa. Wani gaamba rakwa du wunga maan taamba yakwasnyé-ndarénngé wa matumba yandarén aké taambak kaayék nakurak (6) wunga tén. Wani aké néma néma apu wa (100 lita pulak). ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas jémbaa yakwa dunyanét wandén, “Wani akémba gumbés kulak ma tuwe wukaasandangunu.” Naandéka gumbés kulak tuwe wukaasanda-ndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wukaasanda-ndaka det wandén, “Ras ma tuwe kure ye ani kakému yaakékwa mawunduwat kwayé.” Wunga wandéka tuwe kure yéndarén. Kure yéndaka dé kakému yaakékwa mawundu wani kulak kakwe véndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Wani gumbés kulak wa wain kulak yan. Kakwe véte wain kulakngé vékusékngapuk yandéka de jémbaa yakwa dunyan wa vékusékndarén, wani wain kulakngé. Vékusékngapuk yate dé kakému yaakékwa mawundu dé taakwa kéraakwa duwat waandéka yaandéka dat wandén, “Akwi du yéku wain kulak taale kwayéndakwa. Kwayéndaka dunyan rékaamba wani kulak kandaka kukmba kapére pulak wain wa kwayéndakwa. Méné yéku wain kulak taakatake bulaa kure yaaménénga a yékun kanangwa. A yékun a.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wani nyaa wa Jisas kulé apanjémba taale baasnyé ye yandén. Got dat mayé apa kwayéndéka wa wani kulé apanjémba Galili distrikmba tékwa gaayé Kanamba yandéka véndarén. Vétake déku dunyan déké yékunmba vékulakate wandarén, “Ani du dé Gotna nyaan wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wani kakému katake Jisas, deku aasa, déku waayékanje, déku dunyan wunga yéndarén, Kaperneamét. Ye nyaa ras wani gaayémba yaréndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Néma nyaa nak yaké yandéka Jisas déku dunyansale Jerusalemét yéndarén. Nané Judasé wani nyaaké waanangwa, Pasova. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ye Jisas Gotna kundi bulndakwa néma gaat wulaae véndén dunyan ras musé asé waatakiténdaka. De yéwaa kéraate sipsip bulmakau api kwayéténdarén, de Gotna gaamba jémbaa yakwa dunyansé viyaae Gorké tuwe kwayéndarénngé. Dunyan ras de nak gaayéna yéwaa kéraate de pulak wani gaayéna yéwaa det kwayéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wunga yaténdaka véndén Jisas. Vétake kalik yandén. Ye makal baangwi kéraae apa jorik léngwiyenydén. Léngwiyenye kure téte wamba rakésén dunyan, sipsip, bulmakau, akwi kewurésalendén. Kewurésaletéte wani yéwaa kéraaréndarén jaambé taakungéru yasnyéndéka wani yéwaa guriksandan. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Guriksandandéka api kure tékésén dunyanét wandén, “Wani api ma kure yéngunék. Guné wuna aapana gaa musé asé waatakindakwa gaa pulak yaké yambakate.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas wunga yandénngé déku dunyan Gotna nyéngaamba kwaakwa ani kundiké vékulakandarén: Got, wuné ména gaaké néma mawulé yawutékwa. Yawutéka wuna mawulé yaa pulak vérékndékwa. Vérékténdéka ména gaa yékunmba kwaandénngé néma jémbaa yawutékwa. Wani kundiké vékulakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisas wunga yandéka de néma dunyansé wani musé vétake wandarén, “Got ménat mayé apa kwayéte wandéka méné wunga yak, kapuk yénga pulak dé? Yénga baan kulé apanjémba yaménu vétake ména mayé apaké vékusékngé nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naandaka Jisas det wandén, “Guné ani gaa yaavan kutngunu nyaa kupukmba nakapuk waayéngwe kaakawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wunga wandéka wandarén, “Kwaaré rékaamba (46) wa de ani Gotna kundi bulndakwa néma gaa kutndarén. Bulaa méné nyaa kupukmba nakapuk kurké yapati-kaménéngwa.” Naandarén néma dunyansé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas wani gaaké wunga wandén, wan dékét déku sépéké wa wandén. Dékét déké wa gwaaménja kundi wandén. Gotna kundi bulndakwa néma gaaké yamba wandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yatake kukmba kiyaae nyaa vétik yéndéka kupuk yambanmba wa Got wandéka nakapuk taamale waarapndén. Waarapndéka déku dunyan wani sapak wandén kundiké nakapuk vékulakandarén. Yate Gotna nyéngaamba kwaakwa talimba viyaatakandarén kundiké waak vékulakate wandarén, “Wani kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wani sapak Jisas Jerusalemmba yaréndén. Yaréte kulé apanjémba yandéka némaamba du dakwa wa vén. Véte wandarén, “Wan Gotna nyaan wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wunga wandaka Jisas deku mawulé wa vésékwuréndén. Deku kundi wan baka kundi wa. Déké yamba yékunmba vékulakandakwe wa. Wunga vétake dele yamba téndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dé akwi du dakwana mawulé wa vésékéyakwuréndén. Deku mawuléké du nakét yamba waatakundékwe wa. Dékét déku kapmang wa véndén deku mawulé akwi pulak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Du nak yaréndén. Déku yé Nikodemus. Dé Judana néma du nak wa. Wani du dé Farisi du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wani du nak gaan Jisaské ye dat wandén, “Néma du, ménat Got wandéka wa yaaménén, déku kundi nanat yakwasnyéké. A vénangwa. Baka du talimba vékapuk yananén kulé apanjémba méné yakwa pulak katik yaké dé. Got ménale randéka wa méné wani apanjémba yaménéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wunga wandéka Jisas dat wandén, “Wawutékwa kundi kurkale ma vékuménu. Du dakwa vatpuniye nakapuk kulé du dakwa yaalakapuk yamunaandaru Got néma du rate deké katik yékunmba véké dé. Yandu de Gotna du dakwa katik yaréké daré.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naandéka vékusékngapuk ye waatakundén, “Aanyapa yan du dakwa yénga pulak ye nakapuk vatpuniye kulé du dakwa yaréké daré? Kalmu makalkéri nyaan ye aasana biyaamba wulaandaru aasa nakapuk waambule kéraaké daré, kapuk yénga pulak yaké daré?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Wunga wandéka wandén, “Aasambéré kéraandaka de nyambalésé yaalandakwan, wa baka du dakwa wa yaalandakwa. Kulémawulé yamba kéraandakwe wa. De Gotna yémba baptais kéraakapuk yandaru Gotna Yaamambi deku mawulémba wulaae rakapuk yandu de kulémawulé katik kéraaké daré. Ye kulé du dakwa yarékapuk yandaru, Got néma du rate deké katik yékunmba véké dé. Gotna Yaamambi deku mawulémba wulaandu de kulémawulé kéraae kulé du dakwa yakandakwa. Yi wan wanana wa. Ménat wa wawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naatake nakapuk wandén, “Ménat wa wawutén, guné kulé du dakwa yaténgunénngé. Wani kundi vékute vat naate méné vékulaka vékulaka naambak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wimut kutte dékét déku kapmang yeyé yaayandékwa. Yeyé yaayate waandéka wa vékuménéngwa. Vékute yamba vésékménéngwe wa. Yamba dé yaakwo? Yamba dé yékwaau? Wimut vésékngapuk yaménéngwa pulak, wa Gotna Yaamambi yakwa jémbaa katik vésékngé méné. Gotna Yaamambi deku mawulémba wulaandu de kulé du dakwa yandakwanngé katik vésékngé méné.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naandéka wandén, “Wani musé yénga pulak yaké dé?” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nikodemus wunga waatakundéka wandén, “Méné Judana néma du wa téménéngwa. Yénge méné wani muséké vékukapuk yak? ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ani kundi ma véku. Méné a wawutékwa. Wuné vékusékéyakwutén muséké wa ménat wawutékwa. Véwutén muséké waak wa wawutékwa. Wawutéka guné wuna kundi vékumuké kalik yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Got ani képmaamba jémbaa yandéka véngunéngwa wani jémbaaké wa wawutékwa. Wawutéka guné wuna kundi yamba vékungunéngwe wa. Got déku gaayémba yandékwa jémbaaké wamunaawutu, wani kundi waak katik vékuké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Du nak Gotna gaayét yamba waaréndékwe wa. Ye Got yakwa jémbaa yamba véndékwe wa. Wuné déku gaayémba yaréte wunékét wuné male wa vén déku jémbaa. Wuné déku gaayé taakatake wa ani képmaat gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Talimba nana gwaal waaranga maandéka bakamu du dakwa yarékapuk taalémba yatéte Moses bras ainét yandarén kaambe nak miyémba kusoréndén, de ve yékun yandarénngé. Yandén pulak, wuné Duna Nyaan wunat wunga yakandakwa. Wuné miyémba kusorékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kusoréndaru de wunat ve wunéké yékunmba vékulakate wuna kundiké, ‘Yi wan wanana wa,’ naamunaae de kulémawulé kéraae Gorale yékunmba tékandakwa apapu apapu.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Got ani képmaamba tékwa du dakwaké néma mawulé ye wa déku nakurak male nyaanét wandéka gaayandén. Wunga wandén, déku nyaanngé yékunmba vékulakakwa du dakwa kulémawulé kéraae dale yékunmba tépékaa-ndarénngé, apapu apapu. Katik lambiyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Got déku nyaanét wandéka wa gaayandén, du dakwa yan kapéremusé kururémuké. Got dat yamba wandékwe wa, yandarén kapéremusé waambule ye kaatandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Déku nyaanngé yékunmba vékulakakwa du dakwat wa Got wakandékwa, “Guné yéku du dakwa wa. Yékunmba tépékaa-kangunéngwa.” Déku nyaanngé yékunmba vékulaka-kapuk yakwa du dakwat anga wakandékwa, “Guné kapéremusé yakwa du dakwa wa. Wuna nyaanngé yékunmba vékulaka-kapuk yangunénngé, wa yangunén kapéremusé yakatawutékwa.” Naakandékwa Got. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jisas yéku yaa vérékngwa téwaayé pulak téte wa ani képmaat yaandén. Yaandéka du dakwa kapéremusé yate ganngumba téké wa mawulé yandarén. Wani yaa kalik yandarén. Wani yaa kalik yandarénngé, Got waarukandékwa det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kapéremusé yakwa du dakwa de wani yaaké kalik yate yaa kaalékwa taalat katik yéké daré. Yaa vérékte ganngumba kaaléndu nak du yandakwa kapéremusé kurkale vémuké kalik yate, wa yaa vérékngwa taalat katik yéké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gotna kundi yékunmba vékukwa du dakwa de wani du dakwa pulak yamba yandakwe wa. De Got mayé apa kwayéndéka yéku jémbaa wa yandakwa. Yate yaa vérékngwa taalat yéndaka nak du kurkale vésék kéraasékndakwa, yandarén yéku jémbaat. Véte Got det mayé apa kwayéndékwanngé vékusékndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kukmba Jisas déku dunyansé sékét yéndarén Judiat. Ye wani taalémba yaréte du dakwat Gotna yémba baptais kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Baptais kwayékwa du Jon dé Ainonmba yaréndén. Wani gaayé Salimale wa téndékwa. Késépéri gu wa wani taalémba tékésndéka némaamba du dakwa yaakérandaka det Gotna yémba baptais kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wani sapak néma du Herot Jon kalapusét kusolakapuk yandéka dé baka kaapamba yatéte wa déku jémbaa yaténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jonna dunyansé de Juda du nakale waarundarén. Judasé deku apakundi vékute gu yaakundakwanngé wa waarundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Waaruwe Jonna dunyansé dat ye anga wandarén, “Néma du, du nak ménale Jordan kaambélé anjatikéna sakumba wa téndén. Déku jémbaaké nanat talimba wa waménén. Wani du wa yaae téte du dakwat Gotna yémba baptais kwayéténdéka akwi du dakwa nané yaasékatake déké yéndakwa. De akwi déké male yéndarénngé kalik yanangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naandaka Jon det anga wandén, “Got nanat wamunaandu nané déku kundi vékute déku jémbaa yakanangwa. Got nanat wakapuk yamunaandu déku jémbaa katik yaké nané. Wuné ani jémbaa katik yaasékaké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ani jémbaa yate gunat wawutéka wa vékungunén. Anga wa wawutén, ‘Wuné Got wan du Krais yamba wa. Wuné akwi du dakwat yékun yakwa du yamba wa. Wuné Got wandéka wani duna yaambu kururémuké wa taale yaawutén. Dé wuna kukmba wa yaakandékwa.’ Naate wuna jémbaa yawutén, du dakwa akwi wani duna kundi vékundarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Du nak taakwa kéraaké yandu déku naawindu téte véténdu dé wani taakwa kéraandu dale sékét mawulé tawulé yakambérékwa. Wuné wani taakwa kéraakwa duna naawindu pulak wa. Késépéri du dakwa Jisaské yéte déku kundi vékundaka wuné yéku mawulé vékute mawulé tawulé yasékéyakwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dé néma du rakandékwa. Wuné yamba wa. Wuné baka du tékawutékwa. Némaamba du dakwa déku yé kavérék-ngandakwa. Wuna yé katik kavérékngé daré. Wanngé mawulé yawutékwa.” Naandén Jon. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Anjorémba yaae képmaat gaayan du dé akwi du dakwana néma du wa. Ani képmaamba tékwa du de képmaana musé aséké male wa vékusékndakwa. Anjorémba gaayan du det yasandawure dé akwi muséké vékusékéyak-wuréndékwa wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Gotna jémbaaké vésékéyake, vékusékéyaktake wa det wandékwa. Wandéka de déku kundi vékumuké kalik yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Got déku Yaamambi wani duwat wa kwayéndén. Kwayéndéka wulaae déku mawulémba rate wa dale jémbaa yandékwa. Yandéka wa wani du Gotna kundi male kwayéndékwa. Kwayéndéka du dakwa déku kundi vékute wandakwa, “Gotna kundi wa tiyaandékwa nanat. Gotna kundi wan yéku kundi wa. Yi wan wanana wa.” Naandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Déku aapa Got déké néma mawulé yandékwa. Yate dat wa wandén, dé néma du rate akwi du dakwa, salmu walmuké waak yékunmba véndénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gotna nyaanngé yékunmba vékulakakwa du dakwa kulémawulé kéraae apapu apapu yékunmba yatépéka-kandakwa. Déku kundi vékukapuk yakwa du dakwa kulémawulé katik kéraaké daré. Got apapu apapu wani du dakwat rakarka yandu de katik yékunmba yatésékéyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","4","Wani sapak dunyan ras wa wan, “Némaamba dunyan Jisasna kundi vékundakwa. Vékundaka Jisas det Gotna yémba baptais kwayéndékwa. Wunga yandéka déku jémbaa wa taalékéran baptais kwayékwa du Jonna jémbaat.” Wunga wate yamba vékusékndakwe wa. Jisasna dunyansé male wa du dakwat Gotna yémba baptais kwayéndarén. Jisas baptais yamba kwayéndékwe wa det. Jisasna jémbaaké wunga wandaka de Farisi dunyansé wani kundi vékute bulndaka vékundén Jisas. Vékutake Judia distrik taakatake Galili distrikét nakapuk yémuké watake Samaria distrikét yéndakwa yaambumba déku dunyansé dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ye Samariana gaayé nakmba saambakndarén. Wani gaayéna yé Sikar wa. Wani gaayé tékwanmba, néma baan némbu nak tékwa. Talimba nana gwaal, waaranga, maandéka bakamu Jekop wa déku nyaan Josepét kwayén wani képmaa. Sikar wani képmaa tékwanmba wa téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wani taalémba kulak tundakwa vaakulak nak tékwa. Talimba Jekop wa vaan wani vaakulak. Jisas kulémba yaae wani vaakulak tékwanmba saambake yaap yandéka wani vaakulak tékwanmba randén. Nyaa nyéndényaa yakwate yaténdéka wa randén wamba. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisas wamba randéka déku dunyan gaayét yéndarén, kakému ras kéraaké. Yéndaka randéka Samaria taakwa nak kulak tuké yaalén. Yaaléka lat wandén, “Kulak ras ma tiyaa. Kakwate yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naandéka lé Samaria taakwa wa wan, “Méné Juda du wa. Wuné Samaria taakwa a. Yénge kulak kwayéwuténngé méné yaawiyu?” Naalén. Judasé Samariasale yamba yeyé yaaténdakwe wa. Wanngé wa walén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Waléka Jisas wa wan, “Bulaa nyénat kulakngé yaawiwutén. Got kwayékwa yéku musé vésékte wuné waak vésékmunaae nyéné wunat nak pulak kulakngé wakanyénéngwa. Nyéné wani kulak katake yékunmba yarépéka-kanyénéngwa.” Wunga wate du dakwa kulémawulé kéraae yékunmba yatépékamuké wa gwaaménja kundi wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wunga wandéka lé déku kundi vékusékngapuk ye anga walén, “Néma du, méné kulak tu musé nak yamba yé wa. Ani vaakulak andalamba wa rakwa. Wa waménéngwa kulak yamba tuké méné? ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nana gwaal waaranga maandéka bakamu Jekop wa tiyaan ani vaakulak nanat. Déku nyambalé, sipsip bulmakau, dé waak ani kulakmba wa kandarén. Ména jémbaa déku jémbaat taalékérandénngé méné wunga wo, kapuk yénga pulak yandénngé?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Naaléka wandén Jisas, “Akwi du dakwa wani kulak kandaru deku kwaalé rékandang yawuréké yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","De wani wuné kwayéké yakwa kulak kéraamunaandaru, wa dé deku mawulémba yékun yaténdu de kulémawulé kéraae yékunmba yatésékéyak-ngandakwa apapu apapu.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naandéka dat walén, “Néma du, wani kulak bulaa ma tiyaaménu wunat. Tiyaaménu séré, maa, wunat katik kwaalé rékandang yaké dé. Nakapuk katik yaae ani vaakulakmba tuké wuté.” Naate lé déku gwaaménja kundi yamba kurkale vékuséklékwe. Lé kulakngé wa walén. Dé kulémawuléké wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lé wunga waléka wandén, “Ma ye nyéna du waanyénu yaandu kure yaa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naandéka walén, “Wuné du yamba yé wa.” Naaléka wandén, “Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Talimba du taambakale (5) yatényénén. Bulaa a ranyénéngwa du wan nyéna du yamba wa. Wunga wa wanyénén. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naandéka walén, “Néma du, wuné wa vésékménéngwa. Méné Gotna yémba kundi kwayékwa du wa. Bulaa wunga wa vékusékwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wuna gwaal waaranga maandéka bakamu de ani némbumba wa waaréte wa Gotna yé kavérékndarén. Guné Judasé anga wangunéngwa, ‘Guné Gotna yé kavérékngunéngwa taalé Jerusalemmba male tékwa.’ Wunga wangunéngwan yénga pulak yaké nané?” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wunga waléka lat wandén, “Nyéné wuna kundi ma yékunmba véku. Nak nyaa nak yaandu guné akwi taalémba nana aapa Gotna yé kavérék-ngangunéngwa. Ani némbumba male katik kavérékngé guné Gotna yé. Jerusalemmba male katik kavérékngé guné Gotna yé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Guné Samariasé Gorké vékusékngapuk ye wa déku yé kavérékngunéngwa. Nané Judasé nané Gorké vékuséke wa déku yé kavéréknangwa. Du dakwana kapérandi mawulé kururéna baan Juda du wuné anana. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nana aapa Gotna kundi yékunmba vékukwa du dakwa de déku kundiké, ‘Yi wan wanana wa,’ naate deku mawulémba déku yé kavérék-ngandakwa. Wani du dakwa déku yé kavérékndarénngé wa mawulé yandékwa. Déku yé wunga kavérékndara sapak a yaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Got kwaminyan pulak wa randékwa. Déku sépé yamba yé wa. Du dakwa dé yamba véndakwe wa. Gorké yékunmba vékulakakwa du dakwa déku kundiké, ‘Yi wan wanana wa,’ naate deku mawulémba déku yé kavérék-ngandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wunga wandéka walén, “Got wan du Mesaia déku nak yé Krais dé yaakandékwa, nanat yékun yaké. Wuné wunga vékuwutén. Dé yaae akwi kundi kwayékandékwa nanat.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naaléka Jisas lat wandén, “Wuné anana a bultékwa nyénale.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas wunga waténdéka wa déku dunyan kakému kéraae kure nakapuk waambule yaandarén. Yaae taakwa nakale bulténdéka vétake vat naae vékulaka vékulaka naandarén. Ye yamba wandakwe, “Kamu musé kéraakwate nyéné yo? Kamuké méné lale bulto?” Wunga yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Yandaka wani taakwa kulak tulékwa mu taakatake gaayét waambule yélén. Ye gaayé du dakwa rasét walén, “Ma yaae véngunu du nak. Wuné yamba véndékwe. Ye talimba yawutén akwi muséké wunat wandékwa. Dé Got wan du Krais dé, kapuk kandé?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wunga waléka gaayé taakatake Jisaské yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yaambumba yaaténdaka Jisasna dunyan dat anga wandarén, “Néma du, méné kakému ma kana.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naandaka wandén, “Wuna kakému wa rakwa. Guné yamba ve wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Naandéka déku dunyan dekét deku kapmang bulte anga wandarén, “Du nak dat kakému ras ka kure yaae kwayéna?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wunga wandaka det wandén, “Wuna kakému anga wa. Wuné wandéka yaan duna kundi vékukawutékwa. Vékute tiyaandén jémbaa ye yasékéyak-ngawutékwa. Wan wuna kakému pulak wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guné kakému yaanantake wangunéngwa, ‘Kakému kéraaké yanangwa baapmu vétik vétik wa tékwa.’ Wangunénga gunat wawutékwa: Bulaa kéraakangunéngwa. Ma véngunu. Samaria du dakwa némaamba wa, de wa yaakwa. Bulaa deku mawulé wa yékunmba tékwa, kéraangunéngwa kakému yékun ye tékwa pulak. Bulaa wunéké vékulakate wuna kundiké, ‘Yi wan wanana wa,’ naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","38","“Kakému kéraakwa dunyan nak dumba jémbaa yate déku kakému kéraae waawatte wa yéwaa kéraandakwa. Guné Gorké jémbaa yate kakému kéraakwa dunyan pulak wa yaténgunéngwa. Guné wani jémbaa yate wuna kundi kwayéngunu, némaamba du dakwa jaawuwe wunéké yékunmba vékulakate kulémawulé kéraae, yékunmba yatépéka-kandakwa apapu apapu. Yaténdaru Got guna yéku jémbaa waambule kaatakandékwa. Talimba ani kundi du nak anga wa wandén, ‘Du nak kakému yaanandékwa. Yaanandéka du nak wani kakému kéraandékwa.’ Naandén. Wandéka bulaa wa sékérékén wani wandén kundi. Ras dunyan talimba wa du dakwat Gotna kundi kwayéte de kakému yaananén du pulak wa yaténdakwa. Ras dunyan kukmba yaae wuna kundi wani du dakwat kwayékandakwa, de wunéké yékunmba vékulaka-ndarénngé. Wani kundi kwayékwa dunyan de kakému kéraakwa du pulak wa yaténdakwa. Talimba kundi kwayétan dunyan kukmba kundi kwayétékwa dunyansale sékét mawulé tawulé yakandakwa. Gunat wawutén, guné wuna kundi kwayéngunu némaamba du dakwa wunéké yékunmba vékulaka-ndarénngé. Talimba du ras det Gotna kundi kwayéndarén wa. Kukmba guné yaae deku mawulé yékun yangunu de wunéké yékunmba vékulaka-kandakwa. Gotna kundi talimba kwayén dunyan guné wuna kundi kwayékwa dunyansale guné akwi Gotna jémbaa wa yangunéngwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria taakwa lé takamba wani gaayé du dakwat wa walén, “Wani du wuné talimba yawutén akwi muséké wunat wandén.” Wunga waléka Samaria du dakwa rékaamba de Jisaské yékunmba vékulakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yate Jisasét yaae waatakundarén, dé ye dele yaréndénngé. Waatakundaka dele nyaa vétik yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yaréte kundi kwayéndéka késépéri du dakwa ras waak déku kundi vékute déké yékunmba vékulakandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yate wani taakwat anga wandarén, “Taale nyéna kundimba vékunanén. Vékute Jisaské yékunmba vékulakananén. Yatake kukmba Jisasna kundi vékunanén. Déku kundi vékwe wa bulaa anga vékuséknangwa. Dé ani képmaamba tékwa du dakwa Satanna taambamba kéraaké yakwa du wa. Yi wan wanana wa.” Naandarén Samaria du dakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Nak nyaa Jisas wa wan, “Gotna yémba kundi kwayékwa duké déku gaayé du dakwa anga wandakwa, ‘Dé nané pulak du wa. Dé néma du yamba wa. Wa baka du wa.’ Wunga wandaka de nak gaayé du dakwa déké wandakwa, ‘Wa néma du wa dé.’ Naandakwa.” Naandén Jisas. Sikarmba nyaa vétik yare wani gaayé taakatake Galili distrikét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Talimba yis kurkapuk yandakwa bret kanangwa sapak de Galili du dakwa ras Jerusalemét yéndarén. Ye véndarén wa Jisas talimba vékapuk yandarén kulé apanjémba yandéka. Vétake deku gaayét waambule ye yare véndarén Jisas deku gaayét yaandéka. Vétake déké mawulé tawulé yandarén. Yate déku kundi vékundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","De Galilimba yeyé yaayate Kanamba saambakndarén. Jisas talimba wani gaayémba yaréte wandéka wa gumbés kulak waalakwe wain kulak yaalan. Jisas déku dunyansale Judia taakatake Galilit ye Kanamba saambake yaréndaka néma du nak vékundén. Wani néma duna nyaan baat ye Kaperneammba kwaan. Kwaandéka néma du Jisaské yaandén. Yaae dat wandén, “Wuna nyaan ani kiyaakwate yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Méné wunale ma yaae wuna nyaanét yékun yaménu.” Naandéka wandén Jisas, “Wuné talimba vékapuk yangunén kulé apanjémba yawutu wani sapak male wa guné Got wunat tiyaan mayé apaké yékunmba vékulaka-kangunéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naandéka néma du wa wan, “Néma du, ma yaa bari. Yaakapuk yamunaaménu wuna nyaan kiyaakandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Naandéka Jisas wa wan, “Ma yé. Ména nyaan yékun yakandékwa.” Naandéka wani du Jisasna kundi yékunmba vékute wa yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yéndéka déku jémbaa yakwa dunyansé yaae yaambumba vétake wandarén, “Ména nyaan dé wa yékun yan.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naandaka det waatakundén, “Yani sapak dé yékun yak?” Waatakundéka wandarén, “Nalé nyaa tépatekundéka wa baat yéput yandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Wunga wandaka aapa vékusék naandén. Nalé Jisasale bulndén sapak male wa déku nyaan yékun yandén. Wunga vékusékte déku kémale sékét akwi Jisaské yékunmba vékulakate déku kundiké anga wandarén, “Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas Judia taakatake Galilimba ye wandéka wani nyaan yékun yan. Jisas talimba vékapuk yandarén kulé apanjémba yatake wani sapak kulé apanjémba nak waak yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kukmba Judana néma nyaa nak yaandéka Jisas Jerusalemét yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem talimba matut aatmu giye taakandaka awula nyéndémba téndén. Wani aatmumba néma pété ras tékésén. Nakurak male pétémba wa sipsip wulaaténdarén. Wani pété ténale makal gu kwaawu nak wamba tén. Wani gu kwaawuké Hibruna kundimba wandakwa, Betesda. Wani gu wutépmba barenga pulak gaa taambak (5) kwaakésén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Némaamba du dakwa baat yate wani gaamba kwaakésndarén. Du dakwa ras méni kiyaan, ras maan kapére yan, du dakwa ras deku sépémaaléna apa akwi liwuréndéka baka kwakwamale kwaakwa apu, wunga kwaakésndarén wani gaamba. Wani gu maakulakndu véké watake kwaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Talimba ras nyaa ras nyaa Gotna kundi kure gaayakwa du nak gaayate wani gumba daawulindéka gu maakulakén. Gu vatmakulakndéka ve wani gumba taale daakwa baan wa yékun yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kwaakésndarénmba du nak déku sépé kapére yandéka kwaaré késépéri (38) wa randén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas wani duwat vétake wa vékusékndén. Dé kaa némaamba wa kwaandén wamba. Yatake Jisas dat anga waatakundén, “Méné yékun yaké méné mawulé yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wunga waatakundéka wani sépé kapére yan du wa wan, “Néma du, gu maakulakndu wunat kéraae gumba kusandana du nak yamba wa. Yénga pulak yaké wuté? Wuna kapmang daaké yawutéka nak du wa taale daakwa wuné taalékérate.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Naandéka Jisas wa wan, “Méné ma waarape kwaaménén ara kéraae kure yé.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naandéka wani du yékun yandén. Yandéka déku ara kéraae kure yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wani nyaa wan nané Judaséna yaap yaré nyaa wa. Wanngé de néma du wani yékun yan duwat anga wandarén, “Nana apakundi vékutake wa wananén, ‘Yaap yaré nyaamba du nak déku musé katik yaate yéké dé.’ Wunga wananén. Bulaa méné katik yaate yéké méné ména ara, yaap yaré nyaamba.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naandaka det wandén, “Du nak wa wandéka yékun yawutéka wunat watakandén, ‘Ména ara ma kéraae kure yé.’ Naandéka wa kure yéwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naandéka dat waatakundarén, “Ména ara kure yaaménénngé kandé wak?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naandaka yamba vésékndékwe wa. Wani taalémba némaamba du dakwa yatanmba yénge véké? Jisas dé wa yén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kukmba Jisas dat Gotna kundi bulndakwa néma gaamba véndén. Vétake wandén, “Ma véku. Bulaa wa yékun yaménén. Kapérandi musé nakapuk yaké yambak. Wuna kundi vékukapuk yamunaaménu néma kapérandi musé ras waak yaakandékwa ménéké.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wunga wandéka wani du ye Judana néma dusat anga wandén, “Wuné wandéka yékun yan du wan Jisas wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wunga wandéka vékutake de taale ye Jisasét yaavan kutmuké vékulakandarén, yaap yaré nyaamba wani musé yandénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yandaka Jisas det anga wandén, “Wuna aapa akwi nyaa wa jémbaa yandékwa. Yandéka wuné waak jémbaa yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wunga wate déku aapa Gorké wa wandén. Wate dé Got pulak randékwanngé wa wandén. Yaap yaré nyaamba wani du kururétake wunga wandéka vékutake de Judana néma dunyan dé viyaandékngé wa mawulé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wunga yandaka Jisas det anga wandén, “Gunat a wawutékwa. Wuna mawulémba vékulakate jémbaa nak katik yaké wuté. Wuna aapa jémbaa yandéka, wa wuné déku nyaan véte wani jémbaa yawutékwa. Yi wan wanana wa. Wuna aapa yakwa akwi jémbaa wuné waak wa yakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wuna aapa wunéké mawulé tawulé yate wa déku jémbaa wunat wakwasnyéndékwa. Wunat kukmba wakwasnyéké yandékwa jémbaa wa bulaa a yawutékwa jémbaat taalékéraké yakwa. Wuné wani kulé jémbaa yawutu guné ve vatvat naate vékulaka vékulaka naakangunéngwa, wani jémbaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wuna aapa kiyaan du dakwa wandéka taamale waarape yékunmba yatépékandakwa. Yandékwa pulak wa wuné mawulé yawutékwa du dakwa wawutu de yékunmba yatépéka-kandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wuna aapa néma kot vékukwa néma du rate, du dakwa yandarén muséké det katik kundi waké dé. Wani jémbaa wa tiyaandén wunat. Wuné néma kot vékukwa néma du rate wa yandarén muséké wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Akwi du dakwa wuna aapana yé kavérékndakwa pulak, wa wuna yé kavérék-ndarénngé wa wani jémbaa wunat tiyaandén. Wuna yé kavérékngapuk yakwa du dakwa wa de wuné wandéka yaan duna yé waak yamba kavérékndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wuna kundi kurkale vékute wuné wandéka yaan duké yékunmba vékulakakwa du dakwa wa de akwi kulémawulé kéraandarén wa. Kéraae de apapu apapu Gorale yékunmba yatépékakandakwa. Sérémaa wuné néma du rate deku kundi vékute yandarén kapérandi muséké kundi katik waké wuté. De kapérandi taalat katik yéké daré. De kiyaandakwa yapaté yaasékatake bulaa kulémawulé kéraandarén wa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wunga watake Jisas anga wandén, “Gunat a wawutékwa. Gotna kundi vékukapuk yakwa du dakwa yéku mawulé yamba vékundakwe wa. Yate de kiyangamba pulak wa yaténdakwa. Yatéte wuna kundi vékumunaae wa kulémawulé kéraae yékunmba yatépéka-kandakwa. Wuna kundi vékundara sapak a yaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wuna aapa apamama yandékwa, du dakwa kulémawulé kéraae apapu yékunmba yatépékandarénngé. Dé mayé apa wunat tiyaate wa wandén. Wanngé wuné wawutu du dakwa kulémawulé kéraae apapu yékunmba tépékaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wuné Duna Nyaan a. Got wunat mayé apa tiyaandénngé sérémaa wuné kot vékukwa néma du rate, akwi du dakwana kundi vékute wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wani muséké vat naate vékulaka vékulaka naaké yambak. A yaakwate yakwa sapak kiyaan du dakwa rémndarén kwaawumba kwaate wuna kundi vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Vékwe taamale waarape yaalakandakwa. Yéku musé yatan du dakwa taamale waarape yékunmba yatékandakwa apapu apapu. Kapéremusé yan du dakwa taamale waarapndaru, wuné néma du rate det wate yandarén kapéremusé waambule yakata-kawutékwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas wunga watake Judana néma dunyansat nakapuk anga wandén, “Wuné baka wuna mawulémba wani jémbaa katik yaké wuté. Wunat wandéka yaawutén duna kundi vékute wa du dakwa yandarén kapérandi muséké wawutékwa. Wani kundi wuna mawulémba vékulakate yamba wawutékwe wa. Wuna jémbaaké wawutékwa kundi wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Wuné nakurak wuna kapmang wuna jémbaaké wamunaawutu anga wakangunéngwa, ‘Déku kundi papukundi wa.’ Naate guné wunéké katik yékunmba vékulakaké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wuna aapa waak wuna jémbaaké wa wandékwa. Wandéka anga vékusék-wutékwa. Wuna jémbaaké wandékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Talimba Jonét kundi wasatingunén. Wangunénga dé gunat wunéké kundi kwayéndén. Kwayéndén kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wuné képmaana duna kundiké yamba vékulakawutékwe wa. Yate Got gunat yékun ye waambule guné kéraandénngé wate wa Jonna kundiké wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaa vérékte kaaléndéka wa du dakwa kurkale véndakwa. Jon yaa pulak vérékte kwaaré vétik kupukngé wa yatéte yéku jémbaa yandéka guné véte mawulé tawulé yangunén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon wunéké kundi kwayéndéka wunéké wa vékusékngunéngwa. Wuna néma jémbaa wa déku kundit taalékéran. Wuna aapa yawuténngé tiyaandén jémbaa a yawutékwa. Wani jémbaa yawutéka ras du dakwa véte anga wandakwa, ‘Déku aapa Got wandéka wa yaandén. Wunga véte wanangwa.’ Naandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wuna aapa wandéka yaawutéka dé waak wunéké wandén. Guné déku kundi yamba vékungunéngwe wa. Déku saawi yamba véngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Got wandéka wa a yaawutén. Guné wunéké yékunmba vékulakakapuk yangunénga déku kundi guna mawulémba yamba randékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Guné kulémawulé kéraae kurkale yatépékamuké vékulakate, guné Gotna nyéngaamba viyaatakandarén kundiké waakngunéngwa. Wani kundi viyaatakan dunyansé waak wunéké wa wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kulémawulé kéraae kurkale yatépékaké mawulé yangunéngwa. Wunéké yaae wuna kundi vékumunaangunu wuné wawutu wa kulémawulé kéraae kurkale yatépéka-kangunéngwa. Wuna kundi vékumuké kalik yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Du dakwa wuna yé kavérékmuké kalik yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Guna mawulé wa vésékéyak-wutékwa. Guné Gorké yamba mawulé yangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wuna aapa Got wandéka yaae wa déku jémbaa yawutékwa. Yawutéka guné wuna kundi yamba vékungunéngwe wa. Du nak déku kapmang yaae dékét déku jémbaa yamunaandu déku kundi vékukangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Du dakwa guna yé kavérék-ndarénngé wate wa yangunéngwa. Got guna yé kavérékmuké kalik yangunéngwa. Wunga yate wunéké yénga pulak yékunmba vékulakaké guné? ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Guna mawuléké anga waké yambak, ‘Jisas yananén kapérandi muséké Gorét wate nanat kotim-ngandékwa.’ Wunga wambak. Guné nana gwaal waaranga maandéka bakamu Moseské anga wangunéngwa, ‘Dé nanat yékun yakandékwa.’ Guné wunga wate ani kundi ma vékungunu. Moses yangunén kapérandi muséké Gorét wate gunat wa kotim-ngandékwa. Talimba wunéké Moses wa viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Guné Moses viyaatakan kundi vékumunaate wuna kundi vékukatik guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Guné viyaandén kundi vékukapuk yate yénga pulak wuna kundi yékunmba vékuké guné? Wuna kundi yékunmba vékuké wa yapati-ngunéngwa.” Naandén Jisas Judana néma dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wani kundi kwayétake Jisas néma gu kwaawu nak aangé sakwat yéndén. Wani néma gu kwaawuna yé Galili wa. Nak yé Taiberias wa. Déku dunyansé dale sékét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Talimba némaamba du dakwa Jisas kulé apanjémba késépéri yandéka wa véndarén. Wunga yandéka sépémaalé kapére yan du dakwa yékun yandarén. Vétake déku kukmba kwaaréte yéténdarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisasna dunyan dale némbumba nak waare sékét rakésndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasova waanangwa néma nyaa yaaké yandéka wa wamba randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yare Jisas véndén némaamba du dakwa déké yaandaka. Vétake Filipét wandén, “Kakému yamba kéraae kwayénanu wani du dakwa kaké daré?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filipna mawulé yakwe véké wa wunga wandén. Jisas dékét yaké yandékwa musé wa vékusékndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Vékusékte wunga wandéka dé Filip wa wan dat, “Néma (200) yéwaat kakému kéraamunaananu ani du dakwa wa ayélap ayélap a kakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naandéka Jisasna du nak Andru wamba téndén. Wani du wan dé Saimon Pitana waayéka wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Te anga wandén, “Nyaan nak amba téndékwa. Wani dunyanngu nyaan makalkéri bret taambak (5), gumba kutndarén gukwami vétik wunga wa kure téndékwa. Wani makalkéri bret gukwami vétik yénga pulak kwayéké nané, némaamba du dakwamba?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Naandéka det anga wandén, “Ma wa, wani du dakwa rakésndaru.” Naandéka wandaka waaratakumba rakésndarén. Némaamba du dakwa wa. (Dunyan 5,000) ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Rakésndaka Jisas wani bret kéraae Gorét anga wandén, “Yékun a tiyaaménén bret. Yékun wa.” Naatake du dakwat muni waate kwayéndéka kandarén. Bret yandén pulak gukwami vétik waak wungat male yandén. Mawulé yandarén pulak kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kwayéndéka ke biyaa yawuréndaka Jisas déku dunyansat anga wandén, “Kandaka biyaa yandéka taakandakwa kakému ma kéraangunu. Kéraakapuk yangunu ras baka ka kapére yana.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naandéka de du dakwa kandaka biyaa yandéka taakandarén bret kéraae kémbi tambavétik maanmba kaayék vétik (12) waandandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yandaka Jisas yan kulé apanjémba vétake wani du dakwa wa wan, “Gotna yémba kundi bulkwa du nak yaakandékwa nana képmaat. Déké kaavénangwa. Wani kaavénangwa du, wan Jisas wa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wunga wandaka Jisas wa vékusékndén. Dat kulkiye watépe kure yare wani gaayémba néma du téndénngé wate yaréndaka. Dé wani gaayémba néma du témuké kalik yatake dékét déku kapmang nakapuk waambule némbat yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Garambu Jisasna dunyan néma gu kwaawu wutépét daawulindarén. Daawuliye botmba waare Kaperneamét yéké yandarén. Yandaka Jisas yamba yaae wa deké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yandéka gaan yandéka yéndarén. Yéréndaka néma wimut kutndéka gu némaamba wimbalakute waaran. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Waaréndéka bot yéndénngé kéraaléwiye yéndarén. Wunga ye kulémba yéndarén (6 kilomita pulak). Ye véndarén Jisas gutakumba yaaténdéka. Vétake wup yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wup yandaka det wandén, “An wuné a yaatékwa. Guné wup yaké yambak.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Naandéka mawulé tawulé yandarén. Yandaka botmba waaréndén. Waaréndéka botmba ye wani gaayémba bari saambakndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yé gétndéka némaamba du dakwa néma gu kwaawu nak sakumba yarépékandarén. Yaréte deku mawulémba anga wandarén, “Nalé bot nakurak wa tan. Téndéka Jisasna dunyan wani botmba wa waare yéndarén. Yéndaka Jisas dele yamba waare yéndékwe wa. Dé amba ka yaréna?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wunga watake Jisaské waake yapatindarén. Yaréndaka bot ras waak Taiberiasmba yaandarén. Yaae du dakwa nalémba bret kandarén taalé tékwanale yaréndarén. Wani taalémba nalé Jisas bret kéraae Gorét watake det kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jisas déku dunyansale wani taalémba yarékapuk yandaka du dakwa vépatiktake, botmba waare néma gu kwaawu nak sakwat yéndarén. Jisaské waake véké wa Kaperneamét yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ye saambake Jisas vétake dat anga waatakundarén, “Néma du, anga yani sapak méné yaak?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wunga waatakundaka det wandén, “Ma véku. Gunat wawutékwa. Bret kangunénga wa biyaa yan. Yandéka wa wunéké waakngunéngwa, bret ras waak kwayéwuténngé. Kulé apanjémba yawutéka véngunénngé yamba vékulakangunéngwe wa. Wawutékwa kundi wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Guné jémbaa yate bari késkwate yakwa kakémuké vékulakaké yambak. Guné jémbaa yate nak pulak kakémuké ma vékulakangunék. Wani kakému rapéka-kandékwa. Guné wani kakému katake yékunmba yatépéka-kangunéngwa, apapu apapu. Wuna aapa Got wandéka wuné Duna Nyaan anjomba wa gaayawutén. Wani yéku kakému wuné wa kwayéké yakwa. Got wunat mayé apa wa tiyaawuréndén, kulé apanjémba yawuténngé. Yawutu guné wani jémbaat véte wakangunéngwa, ‘Got wandéka wa yaandén Jisas.’ Naakangunéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naandéka wandarén, “Kamu ye Gotna jémbaa yaké nané?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wunga waatakundaka wandén, “Wunéké yékunmba vékulakangunénngé wa Got mawulé yandékwa. Guna mawulémba anga ma wangunék, ‘Jisas wan néma du wa. Got wandéka wa gaayandén. Yi wan wanana wa.’ Wunga wate wa Gotna jémbaa yakangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wunga wandéka wandarén, “Yénga pulak kulé apanjémba yaménu vétake ménéké wunga vékulakaké nané? Kamu jémbaa yaké méné? ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Talimba nana gwaal waaranga maandéka bakamusé du dakwa yarékapuk taalémba yeyé yaayatéte nak pulak bret wa kandarén. Wani bretké wandarén mana. Talimba yatan dunyan wani bretké nyéngaamba anga viyaatakandarén: Du dakwat Gotna gaayémba gaayan bret kwayéndéka kandarén. Wunga viyaatakandarén.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Naandaka det anga wandén Jisas, “Talimba Moses wani bret yamba kwayéndékwe wa. Wuna aapa male wa wani bret kwayén. Bulaa gunat Gotna gaayémba gaayan bret wa kwayéndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wuné Gotna gaayémba gaayan bretké bulte, duké wa wawutékwa. Got dat wandéka wa Gotna gaayémba yaae ani képmaat gaayandén, du dakwat yékun yaké. Yandu de yékunmba yatékandakwa apapu apapu. Yi wan wanana wa. Gunat wa wawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naandéka Jisasét wandarén, “Néman Du, nané wani yéku bret kéraaké mawulé yanangwa. Apapu ma tiyaa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naandaka Jisas det anga wandén, “Wani bretké bulte wa wunékét wunéké wa wawutékwa. Guné wuna kundi kurkale vékute guné katik kaandéké kiyaaké guné. Guné yékunmba yarékangunéngwa. Wunéké yékunmba vékulake guné kulakngé katik kiyaaké guné. Wa kulémawulé kéraae yékunmba yatékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gunat wa wawutén, ‘Guné kulé apanjémba yawutéka véte yamba yékunmba vékulakangunéngwe wa.’ Naawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wuna aapa du dakwa némaamba wa tiyaandén wunat. Wani du dakwa akwi wuna kundi vékwe de yaakandakwa wunéké. Yaandaru nakét katik kewuréké wuté. De wunéké yaae wuna du dakwa wa tékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wuné Gotna gaayémba re wa ani képmaat gaayawutén. Wunékét wuna mawulémba jémbaa yaké yamba gaayawutékwe wa. Yamba wa. Wuna aapa wandéka wa gaayawutén, dé mawulé yandékwa jémbaa yamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wunéké yaakwa du dakwaké yékunmba vékawutékwa. Yawutu wuna du dakwa tékandakwa. Nak katik lambiyakngé dé. Sésékuk sékéyakmba yaaké yakwa nyaa yaandu wuné néma du rate, du dakwat kundi wawuta sapak, wuné wawutu wuna du dakwa kiyaawuran apu nakapuk taamale waarapkandakwa. Got wunga mawulé yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wunat véte wunéké yékunmba vékulakate wuna kundiké, ‘Yi wan wanana wa,’ naakwa apu akwi kulémawulé kéraae apapu apapu yékunmba yatékandakwa. Wani nyaa du dakwa wawutu de nakapuk taamale waarapkandakwa. Wuna aapa wunga mawulé yandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas wunga wandéka Judana néma dunyan wani kundi vékutake wani kundi kalik yandarén. Jisas anga wandén, “Wuné Gotna gaayémba wa gaayawutén, du dakwat yékun yawutu de yékunmba téndarénngé.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Naandéka kalik yate wandarén, “Gotna gaayémba yamba gaayandékwe wa. Dé Josepna nyaan wa. Déku yé Jisas wa. Déku aasa aapa wa vénanén. Wa nana gaayé du wa. Dé anga wandékwa, ‘Gotna gaayémba gaayawutén.’ Naandékwa. Kamuké dé wunga wo? Wa paapu wa yandékwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wunga wandaka Jisas det anga wandén, “Guné wuna kundi kalik yate gunékét guna kapmang wunga bulmbak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Du dakwa dekét deku kapmang vékwe wunéké katik yaaké daré. Got wandu wa wunéké yaakandakwa. Sérémaa wuné néma du rate akwi du dakwat kundi bulwuta nyaa wawutu wuna kundi vékwe kiyaan du dakwa nakapuk taamale waarapkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Talimba Gotna yémba kundi kwayétan du Gotna nyéngaamba anga viyaatakandarén, ‘Got akwi du dakwat déku jémbaaké yakwasnyé-kandékwa.’ Wunga viyaatakandarén. Du dakwa Gotna kundi vékwe déku jémbaaké vékusékmunaae, wa wunéké yaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Du dakwa Got véndarénngé yamba wawutékwe wa. Déku kundi vékungunénngé wa wawutékwa wunga. Du nak Got yamba véndékwe wa. Wuné nakurak dé véwutén wa. Wuné wuna aapana gaayémba rate dé véwutén wa. Vétake wa ani képmaat gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ma véku. Wunéké yaae wuna kundiké, ‘Yi wan wanana wa,’ naakwa du dakwa de kulémawulé wa kéraandarén. Kéraae apapu apapu yékunmba yatékandakwa. Yi wan wanana wa. Gunat wa wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wunékét wuné Gotna gaayémba gaayan bret pulak rate det yékun yawutu de yékunmba tépékaa-kandakwa, apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Talimba guna gwaal waaranga maandéka bakamu du dakwa yarékapuk taalémba yeyé yaayatéte mana waandakwa bret kandarén. Katake yamba yaténdakwe wa. Kukmba de wani du dakwa wa kiyaawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wuné Gotna gaayémba gaayan bret pulak wa. Du dakwa wani bret kamunaae de apapu apapu yékunmba yarékandakwa. Katik lambiyakngé daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wuné wani bret pulak wa. Wuné akwi du dakwat yékun yakawutékwa. Wuné Gotna gaayémba wa gaayawutén. Ani képmaamba tékwa du dakwat yékun yaké wa gaayawutén. Det yékun yaké wuna sépé kwayékawutékwa. Kwayéwutu de wani bret kamunaae wa apapu apapu yékunmba tékandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judana néma dunyan wani kundi vékutake rakarka ye dekét deku kapmang waarute anga wandarén, “Wan yénga kundi dé wo? Yénga pulak déku sépé tiyaandu kaké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Naandaka Jisas det wandén, “Wuna kundi papukundi yamba wa. An yéku kundi a. Yi wan wanana wa. Ani kundi ma vékusék naangunu. Wuné Duna Nyaan. Wuna sépé wuna nyéki kakapuk yamunaae guné katik yékunmba tépékaaké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wuna sépé wuna nyéki kakwa du dakwa de kulémawulé kéraae yékunmba tékandakwa apapu apapu. Kukmba kiyaandaru sésékuk sékéyakmba yakwa nyaa yaandu wuné néma du rate, akwi du dakwat kundi wawuta sapak, wa wawutu de nakapuk taamale waarapkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wuna sépé nakpulak yéku kakému wa. Wuna nyéki nakpulak yéku kulak wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wuna sépé wuna nyéki kana du dakwa de wunéké yékunmba vékulakate kulémawulé kéraae, wuna du dakwa tékandakwa. Téndaru wuné deku mawulémba wulaae rakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wuna aapa Got dé apapu rapékandékwa. Rate wandéka wa gaayawutén. Gaaye déku kundi vékute wuné apapu rasékéyak-ngawutékwa. Rate wawutu wuna sépé kana du taakwa tésékéyak-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wuné Gotna gaayémba gaayan bret wa. Yi wan wanana wa. Ani bret wan talimba Gotna gaayémba gaayandéka guna gwaal waaranga maandéka bakamusé kan bret pulak, wunga yamba yé wa. De wani bret katake yamba téndakwe. Kukmba wa kiyaatondarén. Du dakwa a wawutékwa bret katake, wa kulémawulé kéraae apapu yékunmba tépékaa-kandakwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas kiyaaké yandékwanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dé wani kundi Kaperneammba wa wandén. Gotna kundi bulndakwa gaamba téte wa wani kundi wandén, dé kiyaandu de kulémawulé kéraamuké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasna késépéri dunyansé déku kundi vékute anga wandarén, “Jisas wakwa kundi yénge vékuké? Wan néma kundi wa. Vékwe yénga pulak ye vékusékngé nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Naandaka Jisas deku mawuléké vékuséke det anga waatakundén, “Wuna kundi kalik guné yo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wuné Duna Nyaan anjorémba wa gaayawutén. Nakapuk waambule waaréwutu vétake guné wanngé waak kalik yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Gotna Yaamambi dékét déku kapmang kulémawulé kwayéndu du dakwa kulémawulé kéraae de apapu yékunmba tépékaa-kandakwa. Baka du katik kwayéké dé. Guné kulémawulé kéraae yékunmba tépékaangunénngé wa wani kundi kwayéwutén. Gotna Yaamambi guna mawulémba wulaandu guné wunéké yékunmba vékulakate kulémawulé kéraae apapu apapu yékunmba tépékaa-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Guné ras wunéké yamba yékunmba vékulakangunéngwe wa. Somba wani muséké anga wawutén: Du dakwa dekét deku mawulémba vékwe, wunéké yaae wuna kundi katik vékuké daré. Wuna aapa Got wandu wunéké yaae wa wuna kundi vékukandakwa.” Naandén Jisas. Déké yékunmba vékulakakapuk yakwa dunyan wa vésékndén. Dé maamat kwayéké yakwa du waak wa vésékndén. Véséktake wa wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wunga wandéka némaamba dunyan dé yaasékatake yéndarén. Yéndaka déku dunyan tambavétik maanmba kaayék vétik (12) wunga téndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Téndaka Jisas det anga wandén, “Guné yénga pulak dé? Guné wuné yaasékatake yékwate guné yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Wunga waatakundéka Saimon Pita wa wan, “Néman Du, méné yaasékatake ye kandéké yéké nané? Méné male wa nanat yéku kundi wakwa, nané kulémawulé kéraae apapu yékunmba ténanénngé. Méné nakurak wa wani kundi vékusékménéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ménéké yékunmba vékulakanangwa. Wa véséknanén. Méné Gorale re wa gaayaménén. Got wandéka wa yaaménén. Méné dékét déku yéku du wa.” Naandén Simon Pita. ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wunga wandéka Jisas det anga wandén, “Wuné wawutéka wa guné yaae wunale yaténgunéngwa. Yaténgunénga guna du nak wa Satanna jémbaamba yétékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Naate Saimon Iskariotna nyaan Judaské wa wandén. Judas wan déku du nak wa. Kukmba Judas Jisas maamasat kwayékandékwa. Judas wunga yaké yandékwanngé wa wandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nyaa ras kukmba Jisas Galili distrikmba yatéte déku jémbaa yandén. Judana néma dunyan de Judia distrikmba yaréte Jisas viyaaké wate yaréndarén. Wunga yandaka deku taalémba yamba yaréndékwe wa. Galilimba yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nané Judasé nana néma nyaa nak yaakwate yandéka, wani sapak nané mawulé tawulé yate nana gaa yaasékatake ye Jerusalemmba bare gaamba yarénangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wani sapak de Jisasna waayékanje dat waarute anga wandarén, “Ani taalé ma yaasékatake yéménu Judiat. Wani taalat yéménéngét ména kundi vékuké mawulé ye de wamba tékwa du dakwa yaménéngwa nakpulak jémbaa vékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Méné néma du téké mawulé yamunaae, du dakwana ménimba téte ma jémbaa yaménék. Néma du téké yamunaae ye katik paakwe jémbaa yaké méné. Judiat ye wani jémbaa ma yaménék.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jisasna waayékanje wunga wandarén. De déké yamba yékunmba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wunga wandaka Jisas det anga wandén, “Apapu nyaa wa guna nyaa wa, Judiat yémuké. Wuné yéna nyaa wayéka yamba yaae wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ani képmaamba yékéyaakmba tékwa du dakwa wuné kalik yandakwa. Det anga wawutékwa, ‘Guné kapérandi mawulé kéraate wa kapéremusé yangunéngwa.’ Wunga wawutéka wa wuné kalik yandakwa. Wuné kalik yate de gunéké mawulé yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gunékét Jerusalemét ye guné véké ya wani néma nyaa yakwate yandakwa musé. Wuné katik yéké wuté. Wuné yéna nyaa yamba yaae wa, wayéka.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas wunga wandéka yéndaka dé Galilimba yarépékandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisasna waayékanje paat yakwate yandakwan véké watake Jerusalemét yéndaka Jisas deku kukmba yéndén. Kaapamba yamba yéndékwe wa. Paakwe yéndén. Yéndéka yamba véndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wani néma nyaa yandéka Judana néma dunyan Jisaské waakte anga wandarén, “Ani du yamba dé ro?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Naandaka du dakwa dekét deku kapmang bulndarén. Bulte, ras wa wan, “Wa kapérandi musé yakwa du wa. Du dakwat paapu wa yandékwa.” Naandaka ras wa wan, “Yamba wa. Wa yéku du wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wunga wate Judana néma dunyan vékumuké kalik yate bulte némaanmba yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wani paatna sapak nyéndé nyaandémba téndéka Jisas Gotna kundi bulndakwa néma gaamba wulaae du dakwat kundi kwayéténdén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yaténdéka Judana néma dunyan vékulaka vékulaka naate anga wandarén, “Yénga pulak ye dé Gotna jémbaaké vékusékéyakék? Nana du dat yamba yakwasnyéndakwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wunga wandaka Jisas det wandén, “Gunat kwayéwutékwa kundi wan wuna kundi yamba yé wa. Wan wunat wandéka yaawutén du Gotna kundi wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Guné déku kundi vékuké mawulé ye kwayéwutékwa kundi kurkale vékukangunéngwa. Vékwe anga vékusék-ngangunéngwa. Gotna kundi wa kwayéwutékwa. Wuna mawulémba vékulakate yamba wawutékwe wa. Wunga vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nak du dakwa deku yé kavérék-ndarénngé wate wa du ras deku mawulémba vékulakate kundi kwayéndakwa. Wuné wunga yamba yawutékwe wa. Wuné aapa Got wandéka wa yaawutén. Nak du dakwa Gotna yé kavérék-ndarénngé wate Got mawulé yandékwa pulak yate wa kundi kwayéwutékwa. Guné wuna kundi vékute anga vékusékngangunéngwa. Wuné paapu yakwa du yamba wa. Wuna kundi yékun wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Talimba Moses gunat apakundi wa wandén. Wandéka gunémba nak déku kundi yamba vékungunéngwe wa. Wunéké anga wangunéngwa, ‘Dé Mosesna apakundi yamba vékundékwe wa.’ Wunga wate a wuné viyaandékngé mawulé yangunéngwa. Kamuké guné wunga yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wunga wandéka wandarén, “Ména mawulémba kutakwa wa tékwa. Téndéka wa waangété yaménéngwa. Kandé ménat viyaandékngwate yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naandaka Jisas det anga wandén, “Yaap yaré nyaamba kulé apanjémba nak yawutéka vétake akwi vatvat naate vékulaka vékulaka naangunén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Talimba Moses dunyanngu nyaanna sépé sékungunénngé wa yakwasnyéndén. Aasa kéraalu nyaa taambak kaayék kupuk (8) yéndu dunyanngu nyaanna sépé sékungunénngé wa yakwasnyéndén. “Wani musé Moses yamba taale baasnyé ye wa. Déku gwaal waaranga maandéka bakamusé wa wani musé taale baasnyé yan. Yi wan wanana wa. “Guné Mosesna kundi vékute aasambéré kéraandaka nyaa taambak kaayék kupuk (8) yéndéka guna dunyanngu nyaanna sépé sékungunéngwa. Yate naknya naknya yaap yaré nyaamba sékungunéngwa. Sékute nyaa taambak kaayék kupuk (8) yénngé vékulakangunéngwa. Yaap yaré nyaaké yamba vékulakangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Guné Mosesna kundi kurkasale vékute yaap yaré nyaa guna dunyanngu nyaanna sépé sékungunéngwa. Yaap yaré nyaamba wuné duwat nak kururéwutén. Kururéwuténngé kamuké guné wunat rakarka yo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guné vékusékngapuk ye wuna jémbaa vétake wunat bari waaruké yambak nakapuk. Kurkasale vékutake guné wuna jémbaaké waké ya.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemmba tékwa du dakwa ras wa wan, “Yénga pulak dé? Ani du an viyaandékngé yandakwa du ani dé, yi? ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma véku. Dé akwi duna ménimba téte kundi kwayéndékwa. Kwayéndéka néma du dat véte kundi nak yamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dé Got wan du Krais wa? Wanngé daré vékusékék? Wani duna gwalnge wa vénanén. Nanat yékun yandénngé Got wan du Krais yaandu déku gwalepange katik véké nané. Got wan du yénga pulak raké dé?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wunga wandaka Jisas Gotna kundi bulndakwa néma gaamba téte du dakwat kundi kwayéténdén. Kwayéte anga wandén, “Guné wunat vésékte wuna gwalepangeké wa vékusék-ngunéngwa. Guné wuna aapa yamba véngunéngwe wa. Dé wandéka wa yaawutén. Wuna mawulémba yamba yaawutékwe wa. Dé paapu yamba yandékwe wa. Déku kundi wan yékun wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wuné dé véwutén wa. Wuné dale rawutéka wa wandéka yaawutén.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wunga wandéka dé kulkiye kure yékwate yandarén. Ye dé yamba kutndakwe. Dé kiyaaké yandékwa nyaa wayéka yamba yaae wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yandaka némaamba du dakwa déké yékunmba vékulakate anga wandarén, “Got wan du Krais talimba vékapuk yananén kulé apanjémba yandu, ani du yakwa jémbaat taalékéraké dé? Yamba yé wa. Ani du an Got wan du Krais a. Naate wanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jisaské wunga kundi bulndaka de Farisi dunyan wa vékwan. Vékutake de waak Gotna gaamba jémbaa yakwa duna néma dunyan waak polisét watakandaka yéndarén, Jisas kulkiye kure ye kalapusmba taakaké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ye saambakndaka Jisas anga wandén, “Wuné gunale yaré yaré naae wuné wani wandéka gaayan duké nakapuk waambule yékawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yéwutu guné wunéké waake waake yapati-kangunéngwa. Yatake wuné rakwa gaayét katik yéké guné.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wunga wandéka Judana néma dunyan dekét deku kapmang bulte anga wandarén, “Dé yénga yéndu déké waakpatiké nané? Grik kantrimba tékwa nana tambék Judaséké yéké dé? Ye Grik du dakwat déku jémbaaké yakwasnyéké dé det kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anga wandékwa, ‘Guné wunéké waakpati-kangunéngwa. Guné wuné rakwa gaayét katik yaaké guné.’ Wan yénga kundi dé wo?” Dekét deku kapmang bulte wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Wani paat kandakwa sapak késké yandéka némaamba du dakwa wa yaae rakésén. Wani nyaa néma nyaa wa. Randaka Jisas waarape waatéte anga wandén, “Guné kulakngé kiyaamunaae wunéké yénga yaangunu. Yaae kulak kakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Guné wunéké yékunmba vékulaka-munaangunu wa kulémawulé kwayékwa kulak némaamba wa guna mawulémba wiye yaalaténdu yékunmba tésékéyakngangunéngwa. Wani muséké wa talimba kundi viyaatakandarén Gotna nyéngaamba.” Jisas wunga wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Déké yékunmba vékulakakwa du dakwana mawulémba Gotna Yaamambi wulaae ramuké wa Jisas wani kundi kwayéndén. Gotna Yaamambi randu de kulémawulé kéraae yékunmba tépékaakandakwa. Yatéte nak du dakwaké yékandakwa, wani muséké kundi kwayéké. Kukmba Jisas kiyaae nakapuk taamale waarape Gotna gaayét waaréndu wa Got wandu déku Yaamambi yaakandékwa. Jisas wunga wandén sapak wan wayéka Gotna Yaamambi yaakapuk téndéka wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Du dakwa ras wani kundi vékutake anga wandarén, “An Gotna yémba kundi kwayékwa du a. Kaavérénangwa du wa. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Naandaka ras wa wan, “Yamba wa. Got wan du Krais wa.” Yandaka ras wa wan, “Yamba wa. Wan Galili du wa. Got wan du Krais Galilimba katik yaaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Talimba Gotna nyéngaamba déké anga viyaatakandarén: Got wan du Krais Devitna kémba wa téndékwa. Dé talimba Devit yatan gaayé Betlehemmba wa yaalakandékwa. Wunga viyaatakandarén.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wunga kundi vékutake késmawulé nakmawulé vékute du dakwa kutéke kém vétik randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Rate de ras Jisas kulkiye kure kalapusmba taakaké mawulé yandarén. Ye du nak yamba kure wa dé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wunga ye polis nakapuk waambule yéndarén. Farisi dunyan béré Gotna gaamba jémbaa yakwa duna néma dunyanséké yéndaka det anga waatakundarén, “Yénga pulak ye guné dé yamba kulkiye kure yaangunéngwe?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Waatakundaka de polis wa wan, “Talimba anga pulak du nak yamba yatéte wunga kundi bulténdékwe wa, ani du bulkwa pulak. An yéku du a.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Naandaka de Farisi dunyan wa wan, “Yénga pulak dé? Wan gunat waak paapu dé yak? ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nana néma dunyan nané Farisi dunyan waak akwi nané déké wanangwa, ‘Wan Got wan du Krais yamba wa. Paapu wa yandékwa.’ Nané wunga wanangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yékéyaakmba tékwa du dakwa wa de déku kundi vékundakwa. De Moses wan nana apakundi yamba vékusékndakwe wa. Gotna ménimba de akwi wa kapére yawuran. Sérémaa Got wandu kiyaae kapérandi gaayét yékandakwa. Guné deku kundi vékumbak.” Naandarén Farisi dunyansé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus waak dé Farisi du wa. Talimba Jisas véké yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nikodemus deku kundi vékutake anga wandén, “Nana apakundi vékute du nakét baka kotimngé nané? Yamba yé wa. Nané anga yanangwa. Duna kundi vékutake yandén kapérandi muséké waak vékutake néma du anga wakandékwa, ‘Wan kapérandi musé yan du wa. Wani yandén musé dat waambule yakata-kanangwa.’ Naakandékwa. Wani du yakwate yandékwa pulak, nané ma yakwak. Nané taale Jisasna kundi ma vékukwak. Dat baka katik kotimngé nané.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Wunga wandéka dat waarute wandarén, “Méné waak yékéyaakmba tékwa Galilimba yaan du méné, yi? Gotna nyéngaamba kwaakwa kundi kurkasale ma vé. Ve vékusék-ngaménéngwa. Gotna yémba kundi kwayékwa du katik Galilimba yaaké dé.” Naandarén dat. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wani kundi watake akwi dunyansé deku gaat yékéraandarén. Yéndaka Jisas Oliv waandakwa némbat waaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waare re ganmbamba waambule daawuliye Gotna kundi bulndakwa néma gaat yéndén. Yéndéka akwi du dakwa déké yéndarén. Yéndaka rate det Gotna kundi yakwasnyéréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yaréndéka apakundiké vékusékngwa dunyansé, Farisi du ras, taakwa nak kure yéndarén. Wani taakwa lé nak taakwana duwale kapéremusé yaléka véndarén. Vétake kure ye watakandaka nyéndémba télén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","6","Téléka de Farisi dunyansé anga wandarén, “Jisas kapérandi kundi ras bulmunaandu dé kotimnganangwa.” Wunga watake Jisasét paapu yaké yandarén. Yate dat wandarén, “Néma du, ani taakwa lé nak taakwana duwale kapéremusé yaléka vénanén. Talimba Moses Gotna nyéngaamba wunga yakwa dakwaké anga viyaatakandén: Wunga yakwa dakwa matut ma viyaangunu. Viyaangunu yénga kiyaandaru. Moses wunga viyaatakandén. Méné yénga méné wo, ani taakwaké?” Naandaka Jisas kwaatambe déku séktambat viyaatakandén képmaamba. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaténdéka wamba téte nakapuk waatakundaka waatakundaka Jisas waarape det anga wandén, “Amba téngunéngwanmba du nak talimba kapéremusé yakapuk yan du, dé taale yénga vaanéndu matu.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wunga watake nakapuk kwaatambe képmaamba viyaatakandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yandéka déku kundi vékutake nak nak gwaandékérandarén. Aanyapa yan du taaléndaka baka dunyan kukmba gwaandan. Gwaande yékéraandaka Jisas male wamba ran. Wani taakwa waak wamba tépékaatén Jisasna ménimba. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Téléka Jisas waarape wani taakwat anga wandén, “Nyéno, wani dunyansé yénga daré yék? Nyénat kotimngé yakwa du nak dé yaro?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naandéka walén, “Néma du, wunat kotimna du nak yamba yare wa.” Wunga waléka wandén, “Wuné waak nyénat katik kotimngé wuté. Ma yényénu. Sérémaa wani kapérandi musé nakapuk yaké yambak.” Wunga wandéka yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas Gotna kundi bulndakwa néma gaamba téte du dakwat kundi bulte nakapuk anga wandén, “Ani képmaamba tékwa du dakwat wawutékwa, de kulémawulé kéraandarénngé. Wunga yate wuné vérékngwa yaa pulak wa téwutékwa. Ganngumba yaa vérékte kaaléndéka wa du dakwa kurkale véte yaréndakwa. Wunéké yékunmba vékulakakwa du dakwa ganngumba katik yaréké daré. De deku kapérandi mawulé yaasékatake kulémawulé kéraae nyaa kaalékwanmba yatéte kurkale tékandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wunga wandéka de Farisi dunyansé wa wan, “Méné ménékét ménéké wa waménéngwa. Nané ména kundi katik vékuké nané, ménékét ména kundi male waménéngwanmba.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Naandaka Jisas wa wan, “Wunéké wawutékwa. Yi wan wanana wa. Wuna gwalepange guné yamba vésékngunéngwe wa. Wuné yékwate yawutékwa yaambu waak yamba vésékngunéngwe wa. Wuné yare yaawutén taalé wuné wa vésékwutén. Yékwate yawutékwa yaambu waak vésékwutén wa. Véséke wa wunékét wawutékwa. Wawutékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Guné wunat sawuré sanda véte wuné vésékngapuk yate wa wunat waarungunéngwa. Bulaa a wuné néma du téwutékwan du dakwa nakét yamba waaruwutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wuna kapmang yamba jémbaa yawutékwe wa. Got wunat wandéka yaae ani jémbaa yawutéka dé wunale sékét jémbaa yandékwa. Yandékwanngé wuné néma du téte gunat sawuré sanda véte kundi wamunaawutan, wa yéku kundi wakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Guna apakundi anga wandékwa: Du vétik nakurak kundit male wamunaambéru, wani du vétikna kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wani kundi vékute, ani kundiké ma vékulakangunék. Wuné wunékét wunéké wa kundi bulwutékwa. Bulwutéka wuna aapa waak wa wandékwa. Aané nakurak wani kundit male wa watékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naandéka anga wandarén, “Ména aapa yamba dé yaro?” Naandaka wandén, “Guné kurkasale yamba vésékngunéngwe wa wuné. Wuna aapaké waak yamba kurkasale vésékngunéngwe. Wuné vésékmunaate, wuna aapaké waak kurkasale vésékngatik guné.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas det wani kundi kwayéndén Gotna kundi bulndakwa néma gaamba. Yéwaa taakandakwa taalémba téte det wani kundi bulndén. Bulndéka dat yamba kulkiye kure yéndakwe. Déku kiyaanda sapak wayéka yamba yaae wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas nakapuk det anga wandén, “Wuné yékawutékwa. Yéwutu guné wunéké waakngangunéngwa. Waakpatiye kiyaangunu, yangunén kapéremusé tépékaa-kandékwa. Guné wuné yékwa gaayét katik yéké guné.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naandéka Judana néma dunyansé wa wan, “Yénga pulak dé? Anga wandékwan, dé yékwa gaayét nané katik yéké nané. Dé dékét déku kapmang déku sépat viyaae kiyaaké dé wunga wo kapuk?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wunga wandaka wandén, “Guné képmaana du dakwa wa. Wuné yamba wa. Wuné anjoré Gotna gaayémba yare wa gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Guné kiyaangunu wani yangunén kapéremusé katik késké dé. Wanngé wa wawutékwa gunat. Wuné du dakwat yékun yawuténngé Got wan du wuné anana. Wunéké yékunmba vékulakakapuk yamunaangunu, yangunén kapéremusé katik késké dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Naandéka wandarén, “Ména jémbaaké yénga méné wo?” Wunga waatakundaka Jisas anga wandén, “Talimba wunéké apapu wa wawutén gunat. Kundi nak waak katik waké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wuna némaamba kundi a tékwa. Waké mawulé ye, yangunéngwa kapérandi mawulé, gunéké waak wa wakawutékwa. Yénga yakét, katik waké wuté wunga. Ani kundi male wakawutékwa. Wuné wandéka yaan duna kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Wuné déku kundi vékute wa ani képmaamba tékwa du dakwat wawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wunga wandéka vékutake de déku aapaké wandénngé yamba vékusékndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yandaka Jisas anga wandén, “Kukmba Duna Nyaan wuné kusoré-kangunéngwa. Kusorétake wunéké vésék-ngangunéngwa. Wuné wuna mawulémba kundi nak yamba kwayéwutékwe wa. Wuné wuna aapa wan kundi male wa gunat kwayéwutékwa. Wunga vésék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuna aapa wandéka yaawutéka dé waak yaae wunale randékwa. Dé mawulé yandékwa jémbaa male yawutékwanngé wate dé wuné yamba yaasékandékwe wa. Yandéka wuné kapmang yamba yaréwutékwe wa. Yamba wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wunga wandéka némaamba du dakwa déké yékunmba vékulakate déku kundiké wandarén, “Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yandaka Jisas wani Judasat anga wandén, “Guné wuna kundi vékute wuna jémbaa yate wa guné wuna dunyan yaréngunéngwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wuna dunyan yaréte guné wuna yéku kundiké vékusék-ngangunéngwa. Vékusékte guné kalapusmba kwaakwa du pulak katik yaréké guné. Guné baka kaapamba yatékwa yéku du pulak wa yarékangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wunga wandéka wandarén, “Nané Abrahamna gwaal waaranga maandéka bakamusé a. Talimba du nak nanat kalapusmba yamba taakandékwe wa. Nané yékunmba yarépékanangwa. Méné anga waménéngwa, ‘Guné kalapusmba kwaakwa du pulak katik yaréké guné. Guné baka kaapamba yatékwa yéku du pulak yarékangunéngwa.’ Kamuké méné wunga wo?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Wunga wandaka Jisas det anga wandén, “Papukundi yamba wawutékwe wa. A wawutékwa kundi an yéku kundi a. Yi wan wanana wa. Du dakwa kapéremusé yandakwa. Yandaka wani kapéremusé wa det kalapus pulakmba kusolakwa. Yandéka wani du dakwa akwi kurkale yamba yaténdakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Du ras nak duké apa tapa yandaka wa de deku kundi vékute wandakwa pulak jémbaa wa yandakwa. Yate det apa tapa yan duna kémba yamba tépékaandakwe wa. Kalapusmba kwaakwa du pulak wa téndakwa. Apa tapa yan wani duna nyaan male deku kémba tépékaa-kandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wuné Gotna nyaan a. Wuné guné yékun téngunénngé wamunaawutu kapéremusé gunat nakapuk katik kalapus pulakmba taakaké dé. Guné baka yékunmbaa-sékéyak yatékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Guné Abrahamna gwaal waaranga maandéka bakamusé wa. Wa vésékwuréwutén. Abrahamna kém téte déku kundi yamba kure yaréngunéngwe wa. Yate wuna kundi kalik yate wunat viyaandékngé yangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wuné wuna aapa wunat wakwasnyéndén jémbaaké wa gunat wawutékwa. Wawutéka guné guna aapa wan kundi male vékungunéngwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jisas wunga wandéka anga wandarén, “Nana aapa Abraham wa.” Naandaka Jisas wa wan, “Guné Abrahamna gwaal waaranga maandéka bakamusé wa. Yi wan wanana wa. Ye yénga pulak dé? Kamuké watake guné dé yan jémbaa kaapuk yo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gotna kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Got wandéka vékuwutén kundi akwi wa wawutén. Wanngé a wuné viyaandékngé yangunéngwa. Abraham wunga yamba yandékwe. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Guné guna aapa yan pulak wa yangunéngwa.” Naandén. Det wunga wandéka wandarén, “Nana aasa yaambumba yate yamba kéraalékwe wa nané. Nané aapa dé nakurak male, Got wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Naandaka Jisas wa wan, “Wuné wuna mawulémba yamba yaawutékwe wa. Gorale rawutéka wandéka wa gaayawutén. Got guna aapa ramunaandu, wuné gaayanngé mawulé tawulé yakatik guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kamuké guné wuna kundi yékunmba vékulakakapuk yo? Wuna kundi kalik yate yamba yékunmba vékulakangunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Guné Satanna nyambalésé wa. Wunga yatéte wa guné guna aapana mawulémba jémbaa yangunéngwa, wandékwa pulak. Talimba du dakwat viyaandén. Dé du dakwat viyaakwa du wa. Wunga yate yéku kundi yamba vékundékwe wa. Dé papukundi male wa bulndékwa. Papukundi wan déku kundi wa. Dé paapu yate akwi du dakwat papukundi wa wandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wawutékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Wawutéka guné wuna kundi kalik yate papukundiké male mawulé yangunéngwa. Yate guné wuna kundi yamba vékungunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wuné kapéremusé yamba yawutékwe wa. Kapéremuséké guna du nak wunat kotimngé yapatindékwa. Wawutékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Kamuké guné wawutékwa yéku kundi vékukapuk yo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gotna nyambalésé de akwi déku kundi vékundakwa. Guné Gotna nyambalésé yamba yé wa. Déku kundi yamba vékungunéngwe wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wunga wandéka Juda dunyansé Jisasét waarute anga wandarén, “Somba anga wananén, ‘Méné Samaria du wa. Kutakwa ména mawulémba wa tékwa. Téndéka wa waangété yaménéngwa.’ Naananén. Yi wan wanana wa. Bulaa wunga vékuséknangwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Naandaka Jisas wa wan, “Wuna mawulémba kutakwa nak yamba te wa. Wuné wuna aapana yé kavérékwutéka guné wuna yé yamba kavérékngunéngwe wa. Wunéké wangunéngwa, ‘Wan kapéremusé yakwa du wa.’ Naangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wuné wuna yé kavérékmuké kalik yawutékwa. Du nak néma du rate wuna yé kavérék-ngandékwa. Kavérékte wunat anga wakandékwa, ‘Méné yéku musé yakwa du wa.’ Naakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wuna kundi yékunmba vékukwa du dakwa Gorale apapu yarékandakwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wunga wandéka de Judana néma dunyan wa wan, “Ména mawulémba kutakwa wa tékwa. Bulaa wunga vékuséknangwa. Abraham dé wa kiyaan. Kiyaandéka Gotna yémba kundi kwayétan dunyansé de wa kiyaawuran. Kiyaandaka méné wa wakwa, ‘Wuna kundi yékunmba vékukwa du dakwa katik kiyaaké daré.’ Kamuké méné wunga wo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nana gwaal waaranga maandéka bakamu Abraham dé wa kiyaan. Méné méné dat taalékérak kapuk? Gotna yémba kundi kwayétan dunyansé waak de wa kiyaawuran. Ménéké yénga méné wo? Méné kandé?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Naandaka Jisas anga wandén, “Wuné wuna yé kavérékmunaawutu wa wuné baka du wa. Wuna aapa wa dékét wuna yé kavérékngwa. Déké wangunéngwa, ‘Got wan nana néma du wa.’ ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wunga wate guné dé yamba vésékngunéngwe wa. Wuné anga wamunaawutu, ‘Wuné dé yamba vésékwutékwe wa.’ Wunga wamunaawutu wa wuné waak guné paapu yakwa pulak wuné paapu yakwa du wa. Wuné dé vésékwutén wa. Véséktake wa déku kundi kurkale vékuwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Guna gwaal waaranga maandéka bakamu Abraham jémbaa yawuta sapak véké wa dusék yandén. Ye vétake mawulé tawulé yandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Naandéka de néma dunyan wa wan, “Késépéri kaakwaré wa Abraham talimba wa yaréndén. Méné késépéri kaa yamba yaréménéngwe wa. Yénga pulak méné vék Abraham?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wunga wandaka Jisas anga wandén, “Talimba Abraham yarékapuk sapak taale wuné wa yaran. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wunga wandéka de rakarka ye matu kéraandarén dat viyaaké. Yate dé yamba véndakwe wa. Dé Gotna kundi bulndakwa néma gaa yaasékatake kaapat gwaandan. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas déku dunyansale yaambumba ye ménimbo yan du nak véndarén. Wani du dé aasana biyaamba wunga yandéka wa kéraalén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vétake Jisasna dunyansé Jisasét anga waatakundarén, “Néma du, wani duna aasa kéraaléka wa déku méni kiyaan. Kandé kapéremusé yandaka dé déku méni kiyaak? Wani du dékét dé dé yak, kapuk déku aasa aapa béré yak?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Waatakundaka Jisas wa wan, “Wani du yamba yandékwe wa kapéremusé. Déku aasa aapa waak bét yamba ye wa. Dat Got yaké yakwa kulé apanjémba véngunénngé wa déku méni kiyaan. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Got wunat wandéka wa yaawutén. Yaae tiyaandén jémbaa bulaa a yakawutékwa. Kukmba ani jémbaa yamuké yapati-kawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wuné ani képmaamba yatéte vérékngwa yaa pulak wa yatéwutékwa. Yatéte du dakwat kulémawulé kwayéwutu de yékunmba vékusék-ngandakwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wunga watake képmaamba sépmany sévaandén. Sévaae ras képmaale kuséke wani duna ménimba kutndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kuttake dat anga wandén, “Ma ye Siloammba tékwa gumba méni yakwasnyé.” Naandéka ye wani gumba déku méni yakwasnyéndén. Yakwasnyéndéka déku méni nakapuk yékun yandéka vététe nakapuk waambule yaandén. Wani guké wandarén, Siloam, deku kundimba. Nana kundimba anga wa: Wandaka yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wani du waambule yaandéka déku gaayé dunyan, talimba wani dé vén dunyansé waak, dat vétake wandarén, “Talimba wani du dé yaambumba rate du dakwat yéwaaké yaawirak kapuk? Wan nak du dé?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Naandaka ras wa wan, “Wani du wa. Yi wan wanana wa.” Naandaka ras wa wan, “Yamba wa. Dé wani du pulak wa. Wan dé nak du wa.” Wunga wandaka dékét wani du wa wan, “Wuné anana. Wuné wa yaambumba rate yéwaaké yaawiran.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wunga wandéka dat wandarén, “Yénga pulak yaménénga dé ména méni yékun yak?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Waatakundaka wandén, “Wani du déku yé Jisas wa, képmaa kéraae sépmany sévaae wa wuna ménimba kutndén. Kutte wunat anga wandén, ‘Ma ye Siloammba tékwa gumba méni yakwasnyé.’ Naandéka ye gumba wuna méni yakwasnyéwutéka wuna méni yékun yandéka véwutékwa yékunmba.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wunga wandéka dat wandarén, “Wani du yamba dé yaro?” Wunga waatakundaka wandén, “Wuné yamba ve wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Talimba wani ménimbo ye yare yékun yan du Farisi dunyanngé kure yéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yaap yaré nyaa wa Jisas képmaa kéraae sépmany sévaae wani duna ménimba kutndéka yékun yandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kure yéndaka Farisi dunyan dat nakapuk waatakundarén, “Méno, ména méni yénga pulak yandéka dé yékun yak?” Wunga waatakundaka wandén, “Képmaa kéraae sépmany sévaae ménimba kuttake wandéka ye gumba yakwasnyéwutéka wa wuna méni yékun yan.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wunga wandéka de Farisi dunyan ras wa wan, “Wani du yaap yaré nyaaké nana apakundi yamba vékundékwe wa. Yandéka anga vékuséknangwa. Dé Got wandéka yamba yaandékwe wa.” Naandaka de ras wa wan, “Yéku musé yakwa du male wa wani kulé apanjémba yakandékwa.” Naatake vétik mawulé yate kém kutéke kém vétik randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yate wani ménimbo yan duwat nakapuk anga wandarén, “Ména méni kururan duké yénga méné wo?” Wunga waatakundaka wandén, “Wa Gotna yémba kundi kwayékwa du nak wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Talimba wani duna méni kiyaan. Ye bulaa a déku méni nakapuk yékun yan. Yi wan wanana wa. Yandéka Judana néma dunyansé wani muséké wunga waké kalik yandarén. Kalik yate wani ménimbo yan duna aapa aasat waandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Waandaka yaambéréka bérét waatakundarén, “An béna nyaan dé? Aasana biyaamba méni kiyaandéka wa kéraalén. Béné wunga béné wo? Ye a yénga pulak ye dé méni véto?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","22","Naandaka déku aapa aasa anga wambérén, “Dat ma waatakungunu. Dé wa némaan yan. Dékét déku kapmang ma kundi bulndék. Aané wa véséktén. Wan aana nyaan wa. Aasa kéraaléka ménimbo ye yaréndénngé wa vétén. Bulaa a méni véndékwan, wan aané yamba vékuséke wa. Kandé yatakandéka dé déku méni yékun yak? Aané yamba vékwe wa.” Paapu ye wunga wambérén. Judana néma dunyansé bérét ka waarundara naatake wa paapu yambérén. Talimba de néma dunyansé anga wandarén, “Du nak anga wamunaandu, ‘Jisas wan Got wan du Krais wa.’ Naandu wananu wani du kundi bulnangwa gaa taakatake gwaande ye nakapuk katik yaalaké dé.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","De bérét wunga wamuké bét wani duna aapa aasa wup yambérén. Wup ye wa anga wambérén, “Dé wa néma du yan. Dat ma waatakungunu.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wunga wambéréka néma dusé wani duwat nakapuk waandarén. Waandaka yaandéka dat anga wandarén, “Méné papukundi wakapuk yate Gotna yé ma kavérékménu. Wa vénanén. Jisas kapérandi mawulé yakwa du wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naandaka det wandén, “Wuné yamba vékuséke wa. Dé kapérandi mawulé yakwa du dé, kapuk yénga du dé? Angat male vékusékwutékwa. Talimba wuna méni kiyaan. Bulaa wuna méni yékun yandéka yékunmba a véwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naandéka wandarén, “Ménat kamu dé yak? Yénga yandéka dé ména méni yékun yak?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Waatakundaka anga wandén, “Wa wawutén. Wawutéka yamba vékungunéngwe. Nakapuk kamu yandéka guné vékukwate yo? Guné waak déku jémbaamba gwaandéké guné mawulé yo, kapuk?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naandéka dat kenakte anga wandarén, “Méné déku jémbaamba gwaandan déku du wa. Nané Mosesna jémbaamba wa gwaandénanén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Got Mosesale kundi bulndéka wa vékuséknangwa. Moseské wa vékuséknangwa. Wani kapérandi gandéndu yamba dé yaak? Yénga véké? Dé yaan taalé yamba vénangwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naandaka wandén, “Wan yénga pulak dé? Dé wandéka wuna méni yékun yan. Ye guné dé yaandén taalé yamba véngunéngwe. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anga wa vékuséknangwa. Got kapére mawulé yakwa duna kundi yamba vékundékwe wa. Déké yékunmba vékute déku jémbaa yakwa duna kundi wa vékundékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Talimba nak yamba vékunangwe wa, aasa kéraaléka ménimbo yan du nak nakapuk véndéka wandaka. Talimba ménimbo yan du dakwat nak kururéndéka du nak yamba wandéka vékunangwe. Bulaa male a vékunangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wunat wunga yéku jémbaa yandéka wawutén. A Got wandéka a yaandén. Wunga vékusékwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Naandéka dat rakarka yate wandarén, “Ména aasa kapérandi musé yate wa méné kéraalén. Kéraatakaléka méné kapérandi musé yakwa du a téménéngwa. Wunga yatéte nanat yakwasnyéké yambak.” Naatake dat anga wandarén, “Gotna kundi bulnangwa gaa taakatake ma gwaande yé. Nakapuk yaalaké yambak.” Naandaka yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Wani du kewuréndaka yéndéka Jisas vékutake déké waake vétake dat anga wandén, “Méné Duna Nyaanngé méné yékunmba vékulako?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naandéka wandén, “Néma du, wani du wan kandé? Wunat ma waménu wuné déké yékunmba vékulaka-kawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Naandéka Jisas wa wan, “Méné dé wa véménén. Wani du bulaa ménale dé a bultékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naandéka wandén, “Néman Du, méné Duna Nyaan wa. Yi wan wanana wa. Bulaa a vésékwutékwa méné.” Naatake Jisasét kwaati séte waandé daandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wunga yandéka Jisas anga wandén, “Du dakwa mawulé vétik yate kém vétikmba randarénngé wa wuné ani képmaat gaayawutén. Ras du dakwa wa wakwa, ‘Nané Gorké yamba vékuséknangwe wa.’ Wunga wate ménimbo yan du pulak wa téndakwa. Yaténdaru wuné yaae wawutu wa Gotna jémbaa vékandakwa. Ras du dakwa anga wandakwa, ‘Nané Gorké vékuséknangwa wa.’ Wunga wate déké yamba vékusékndakwe wa. Yaténdaru wuné yaae wawutu de ménimbo yan du pulak yatéte Gotna jémbaa katik véké daré.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wunga wandéka de Farisi du ras wamba téte wani kundi vékutake dat anga wandarén, “Wa yénga méné wo? Nané Gorké vékusékngapuk ye ménimbo yan du pulak nané yaro? Wunga méné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wunga waatakundaka wandén, “Guné Gorké vékusékngapuk yate ménimbo yan du pulak yarémunaae kapére mawulé katik yaké guné. Guné anga wangunéngwa, ‘Nana méni yamba ménimbo ye wa. Nané Gorké vékuséknangwa.’ Wunga wate Gorké vékusékngapuk yangunénga wa guna kapére mawulé wa tépékaakwa.” Naandén Jisas Farisi dunyanét. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas anga wandén, “Gunat a wawutékwa. Sipsip tékwa séndat wulaaké mawulé yate pété yaasékatake, gindarén aatmumba waaréte daawulikwa du, wan musé asé sél yate baka kéraakwa du wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pétémba wulaa yaalakwa du wan sipsipké séngite vétékwa du wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wulaaké yandéka pétémba tékwa wani du pété naapindékwa. Naapindéka wulaandéka sipsip déku kundi vékundakwa. Déku sipsipna yémba waandékwa. Waalakét yéndéka vékute kaapat gwaandéndakwa. Gwaandéndaka sipsipké séngite vétékwa du dé taale yéndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yéndéka déku sipsip déku kundi vékute déku kukmba yéndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","De nak duna kukmba yamba yéndakwe wa. Wani duna kundi vékuké yapatite déké wup yate yaangéndakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas gwaaménja kundi wunga wandén. Néma du téte déké yékunmba vékulakakwa du dakwaké yékun yaké vékulakate wa wani gwaaménja kundi wandén. Wandéka de wani kundi yamba kurkasale vékusékndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yandaka Jisas nakapuk anga wandén, “Gunat a wawutékwa. Wuné sipsip wulaakwa pété pulakmba wa téwutékwa. Wuna du dakwa de wani sipsip pulak wa yaténdakwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taale yaan dunyansé wa musé sél yakwa du pulak yate wa paapu yandarén. Yandaka sipsip deku kundi yamba vékundakwe. Wuné sél yakwa duna kukmba wa yaawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wuné pété pulak wa. Du dakwa yaae wani pétémba wulaae wa de yékunmba rasékéyak-ngandakwa apapu apapu. De wani pétémba wulaa yaalate kakému kéraakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Paapu yakwa du paapu yate du dakwana mawulé yaavan kurké wa yaandarén. Wuné du dakwat yékun yate kulémawulé kwayéwutu mawulé yate apapu yékunmba rapéka-ndarénngé, wa yaawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Wuné sipsipké kurkale séngite vétékwa du a. Wuna sipsipét yékun yaké yi naawutu wuna maama wuné viyaandaru kiyaakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Wani paapu yakwa du, yéwaa kéraaké jémbaa yakwa du pulak yate, de sipsipké yamba kurkale séngiye véténdakwe wa. Waaléwasa yaandaka vétake sipsip yaasékatake yaange yéndakwa. Yaangéndaka waaléwasa sipsipét tiké wulkutndaka yaange yé yaayandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Wuné sipsipké yékunmba séngite vétéwutékwa. Wuna aapa wuné wa véndékwa. Véndéka wuné dé véwutékwa. Wunga male wa wuné wuna sipsip véwutéka wuna sipsip wuné vésékndakwa. Wuna sipsipét yékun yaké yi naawutu wuna maama wuné viyaakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wuna sipsip ras waak wa tékwa. Wuna kundi yamba vékundakwe wa. Ani sipsipale yamba téndakwe wa. Wuné de waak kure yaakawutékwa. Wuna sipsip akwi wunale nakurakmawulé yandaru wuné kapmang deké séngite vétékawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Yate yi naawutu wuné viyaandaru kiyaae nakapuk taamale waarapkawutékwa. Wunga yaké yawutékwanngé wuna aapa mawulé tawulé yandékwa wunéké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wuné kalik yamunaawutu wunat katik viyaaké daré. Wuné mawulé ye yi naawutu viyaandék-ngandakwa. Wuna jémbaa wa. Wuné apamama yate yi naawutu wuné viyaandaru kiyaae apamama ye nakapuk taamale waarapkawutékwa. Wani jémbaa yawuténngé wa wuna aapa wunat wandén.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wandéka de Judana néma dunyansé wani kundi vékutake vétik mawulé yate nakapuk kém kutéke kém vétik randarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Rate némaamba dunyansé wa wan, “Déku mawulémba kutakwa téléka wa wunga yandékwa. Guné déku kundi vékuké yambak.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","De ras wunga wandaka, de ras wa wan, “Yamba wa. Déku mawulémba kutakwa témunaalu wani kundi katik bulké dé. Talimba wandéka ménimbo yan du yékun yandén. Kutakwa walu ménimbo nakapuk katik véké dé.” Judana néma dunyansé wunga wandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalemmba néma nyaa nak yaakandékwa. Wani sapak nané nana gwaal, waaranga, maandéka bakamusé talimba Gotna kundi bulndakwa néma gaa nakapuk kaandarénngé vékulakanangwa. Wani sékét wan yépmaa yakwa sékét wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wani sapak Jisas Gotna kundi bulndakwa néma gaana maaléngamba yeyé yaayaténdén. Wani maaléngaké wananén, Solomonna maalénga wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wani maaléngamba yeyé yaayaténdéka Judana néma dunyansé yaae jaawuwe téte dat anga wandarén, “Yénga sapak méné nanat waménu nané ménéké kurkale vékusékngé nané? Méné Got wan du Krais témunaae ma wa nanat.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wandaka Jisas wa wan, “Wuné gunat wa wawutén. Wawutéka guné yamba yékunmba vékulakangunéngwe wa. Wuna aapa mayé apa tiyaandéka wa déku jémbaa yawutékwa. Yawutu guné wani jémbaa kurkale vémunaae wa wunéké vékusékngatik guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Guné wuna sipsip yamba wa. Guné wuna kundi yamba vékungunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wuna sipsip de wuna kundi vékundakwa. Vékundaka wuné de vésékwurétake taale yéwutéka wa wuna kukmba yaandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yaandaka wuné det kulémawulé kwayéwutékwa, apapu apapu yékunmba rapékandarénngé. Nak katik lambiyakngé dé. Nak du det kwayéwutén kulémawulé yaaséka-ndarénngé det wandu de wuna sipsipsé déku kundi katik vékuké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wuna aapa de wunat wa tiyaandén. Dé néma du rate akwi duké wa apa tapa yandékwa. Déku mayé apa wa akwi duna mayé apat taalékéran. Dé apa tapa ye téndu du nak wuna sipsip déku taambamba kéraae kure yéké yapatikandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wuna aapale aané nakurak wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wunga wandéka Judana néma dunyansé nakapuk matu kéraandarén dat viyaaké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yandaka Jisas det anga wandén, “Wuné wuna aapana yéku jémbaa késépéri wa yawutéka véngunén. Yénga baan jémbaaké vékulakate guné wunat matut viyaakwate yo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Naandéka wandarén, “Nané yéku jémbaaké yamba vékulakate ménat matut viyaaké yanangwe wa. Méné kundi sépélak aapélak bulte Gorét wasélékménéngwa. Méné néma du yamba wa. Méné baka du wa. Yate anga waménéngwa, ‘Aané Gorale nakurak wa.’ Wunga waménénga wa méné matut viyaaké yanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naandaka anga wandén, “Yénga véké? Guna apakundimba ani kundi wa kwaakwa nyéngaamba: Guné Got pulak rangunéngwanngé wa wawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Talimba yatéte déku kundi vékutan duwat wa Got wani kundi wandén. Wandén kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Got det wunga wandén pulak wuné wani kundi wawutéka kamuké guné wunat rakarka yo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wuna aapa wunat wandéka wa ani képmaat gaayawutén, du dakwat yékun yaké. Gaaye anga wawutén, ‘Wuné Gotna nyaan a.’ Wawutéka wangunéngwa, ‘Méné wani kundi wate Gorét wa wasélékménéngwa.’ Naangunéngwa. Kamuké guné wunga wo? ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuné wuna aapana jémbaa yakapuk yawutu guné wuna kundi vékumbak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wuné déku jémbaa wa yawutékwa. Yawutu guné wuna kundi vékuké kalik yamunaae, wa yawutékwa jémbaaké ma yékunmba vékulakangunu. Wunga yangunénngé mawulé yawutékwa. Wunga yate anga vékusék-ngangunéngwa. Wuné wuna aapale nakurakmawulé yate dé wuna mawulémba randéka wuné dale yaréwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wunga wandéka dé nakapuk kulkiye kalapusmba taakaké yandarén. Ye dé yéndéka yamba kulkiye kure yéndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas nakapuk waambule ye Jordan kaambélé saaye nak aangat yéndén. Ye Jon det baptais kwayétan taalémba saambake dé wani taalémba yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yaréndéka némaamba du dakwa wa déké yaandarén. Yaae vétake dekét deku kapmang bulte anga wandarén, “Jon talimba vékapuk yananén kulé apanjémba yamba yandékwe wa. Yate wani duké wate yéku kundi male wandén. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wunga watake wani gaayémba yarékwa du dakwa némaamba déké yékunmba vékulakate wandarén, “Jisas wan Gotna nyaan wa. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betanimba yaran du nak baat yandén. Déku yé Lasarus wa. Betani wan Maria ambét léku aanyé Martana gaayé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lé wani taakwa Maria wa yéku yaama yakwa gu Néman Du Jisasna maanmba sévin. Sévitake léku némbat létéklén. Wan léku kaayé Lasarus wa baat yan. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yandéka wa Jisas ani kulémba yaréndéka bét Lasarusna nyange vétik ani kundi anga wakwesatimbérén, “Néman Du, néma mawulé yaménéngwa du a baat yakwa.” Naambérén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Waambéréka Jisas wani kundi vékutake wandén, “Wani baat yandu dé katik kiyaaké dé. Wuné Gotna nyaan. Wuné dé kururéwutu guné dat ve Gotna yé kavérék-ngangunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Jisas Maria ambét Marta, Lasarus béréké waak néma mawulé yandén. Lasarus baat yandékwanngé vékutake yaréndén gaayémba nyaa vétik waak yaréndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yare kukmba wandén, “Ma yékwak waambule Judia distrikét.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Naandéka déku dunyansé wa wan, “Néma du, bulaakakét wa ménat matut viyaaké yandarén. Yandaka kamu yaké nakapuk waambule wani taalat yéké méné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Naandaka Jisas anga wandén, “Du nyaamba yéte katik vaakérké dé. Wa nyaa véténdéka kurkale ve wa yéténdékwa. Gaan yékwa du wa vaakérkandékwa. Gaan kurkale yamba ve yéténdékwe wa. Du nyaamba jémbaa yate yéku jémbaa yakandékwa. Jémbaa yawutékwa nyaa baka tékwa. Wuné viyaandékndara sapak yamba yaae wa. Bulaa wuna jémbaa wayéka a yatéwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wunga watake anga wandén, “Nana naawindu Lasarus ani yundé kwaakwa. Wuné ye sérkiyaawutu waarapkandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Naate Lasarus kiyaanngé wa wandén. Wandéka de déku dunyansé deku mawuléké anga wandarén, “Wa ani baka yundé kwaandékwanngé wa wandékwa.” Naate wandarén, “Néman Du, dé baka yundé kwaamunaae wa dé yékun yakandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naandaka det wandén, “Lasarus dé kiyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kiyaandéka wuné dale yamba yaréwutékwe. Guné wuna mayé apa véngunénngé watake wa wuné déké yékapuk yawutéka wa wuna mawulé a yékun yakwa. Bulaa déké ma yékwak.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Wunga wandéka déku du nak Tomas, déku nak yé Didimus, wa wan det, “Ma yékwak. Ye dale kiyaakanangwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisasale wunga yéndarén. Ye saambake Jisas vékundén Lasaruské. Lasarus nyaa vétik vétik wa kwaandén rémtakandarén kwaawumba. Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani Jerusalemale wa tékwa (3 kilomita pulak wa). Kulémba yamba wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Marta ambét Mariana kaayé kiyaandéka némaamba du dakwa wa Jerusalem taakatake Betanit yékéraandarén, bérale sékét raké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jisas déku dunyansale yaambumba yéténdaka wa Marta wandaka vékulén. Vékutake Jisas yaambumba véké watake yélén. Yéléka Maria lé gaamba yaran. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta yaae Jisasét vétake walén, “Néman Du, méné amba ramunaaménu wuna kaayé katik kiyaakatik dé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Méné bulaa musé nakngé Gorét waataku-munaaménu, wa mawulé yaménéngwa musé akwi yakandékwa. Wan wa vékusékwutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Naaléka Jisas wa wan, “Nyéna kaayé nakapuk taamale waarapkandékwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wunga wandéka Marta wa wan, “Wa vékusék-wutékwa. Kiyaan du dakwa taamale waarapna sapak wa waarapkandékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Naaléka Jisas anga wandén, “Wuna kapmang wakawutékwa. Wunéké yékunmba vékulakate kiyaan du dakwa wawutu nakapuk taamale waarapkandakwa. Waarape kulémawulé kéraae yékunmba rapéka-kandakwa apapu apapu. Wunéké yékunmba vékulakakwa du dakwa de kulémawulé kéraae yékunmba rapéka-kandakwa apapu apapu. Katik lambiyakngé daré. Ani wawutékwa kundiké, ‘Yi. Wan wanana wa,’ nyéné naau?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naandéka walén, “Néman Du, yi wan wanana wa. Méné Got wan du Krais wa. Méné Gotna nyaan wa. Méné kaavérénangwa du wa. Yi wan wanana wa.” Naalén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta wunga watake ye léku waayéka Mariat waalén. Waaléka yaaléka lat yakélak waanmba anga walén, “Nanat Gotna kundiké yakwasnyékwa du a yaae nyénat waakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wunga waléka vékutake Maria bari waarape Jisas véké yélén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","32","Mariana mawulé yékun yandénngé wa du dakwa ras Jerusalemmba takamba yaae lale sékét randarén gaamba. Re véndarén lé waarape kaapat bari gwaandéléka. Gwaandéléka vétake anga wandarén, “Wa Lasarus rémndarén déku kwaawut wa yélékwa, géraaké.” Naatake waarape léku kukmba yéndarén. Jisas déku dunyansale Marta de taale vélén taalémba wamba tépékaandarén. Gaayémba saambakngapuk téndaka Maria ye saambake wa Jisasét vélén. Vétake kwaati se dat anga walén, “Néman Du, méné amba ramunaaménu, wuna kaayé katik kiyaakatik dé.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wunga wate géraaléka Jerusalemmba yaan du dakwa waak yaate lale sékét géraandaka véndén Jisas. Vétake mawulé sémbéraa yandéka déku kwaminyan bérun. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bérundéka wandén, “Dé yani taalémba guné rémék?” Naandéka wandarén, “Néman Du, ma yaae vé.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Naandaka géraandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Géraandéka vétake anga wandarén, “Ma véna. Wani duké néma mawulé wa yandén.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wunga wandaka de ras wa wan, “Talimba wandéka ménimbo yan du nakapuk véndén. Dé Jisas wamunaandu Lasarus katik kiyaakatik dé kapuk? Kamuké dé Lasarusét wunga wakapuk yak?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas mawulé sémbéraa yasékéyak-téndéka dale sékét ye Lasarus rémndarén taalémba saambakndarén. Talimba wa wani taalé, néma matumba kwaawu vaae wulaandarén. Lasarus kiyaandéka déku pusaa wani kwaawumba taakatake matut nak wani kwaawu kétaak-tépéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas saambake anga wandén, “Wani matu ma varémansati.” Naandéka kiyaan duna nyange Marta, kalik yate dat walén, “Néman Du, kiyaandéka nyaa vétik vétik yén wa. Kapérandi yaama wa yaké yakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naaléka Jisas wa wan, “Nyéné takamba wa wawutén, ‘Wunéké yékunmba vékulakamunaae, nyéné Gotna mayé apa vékanyénéngwa.’ Wani kundiké ma vékulaka.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wunga wandéka wani matu varémansati-ndarén. Yandaka Jisas nyérét vaanjawure vététe anga wandén, “Aapa, wuna kundi wa vékuménén. Vékuménénga wuna mawulé yékun yandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wa vékusékwutékwa. Apapu wa wuna kundi vékuménéngwa. Amba tékwa du dakwaké vékulakate wa ménat wawutékwa. Ménat wawutékwa kundi vékute wakandakwa, ‘Got wandéka wa Jisas gaayandén. Yi wan wanana wa.’ Wunga wandarénngé mawulé yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Naatake némaanmba waandén, “Lasarus, ma waarape yaala.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wunga waandéka kiyaan du nakapuk taamale waarape yaalandén. Déku maan, taamba, saawi akwi laplapét gindarén. Yatakandaka wa kwaandén. Kwaae taamale waarape yaalandéka wandén Jisas, “Laplap ma lapattaka yéndu.” Naandéka lapattakandaka yéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Némaamba du dakwa wa Mariaké yaae lale yare véndarén, Jisas wunga yandéka. Véte wandarén, “Got wandéka wa gaayandén Jisas. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Naandaka ras Farisi dunyanét ye Jisas yan muséké saapéndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Saapéndaka de Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Farisi dunyansé waak waandaka akwi maaka dunyan yaandaka Jisaské anga wandarén, “Wani du talimba vékapuk yananén kulé apanjémba késépéri wa yandékwa. Nané yénga pulak yaké? ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nané déku jémbaaké dat watépékapuk yananu wa dé yatéte wungat male yandu akwi du dakwa dat wakandakwa, ‘Nana néma du wa.’ Naakandakwa. Yandaru néma du téte Romna néma duna taalé kéraandu Romna dunyansé kalik ye yaae Gotna kundi bulnangwa gaa yaavan kutte nana du dakwa waak viyaakandakwa.” Naandarén néma dunyansé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wani kwaaré Kaiafas Gotna gaamba jémbaa yakwa akwi dunyanna néma du wa téndén. Téte wani néma dunyanséna kundi vékutake det anga wandén, “Guné yamba vékusékngunéngwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma véku. Nané wani du Jisas viyaandéknanu de Romsé nané Judasat katik viyaaké daré. Dé nakurak kiyaandu nané katik kiyaaké nané. Wan yékun wa.” Naandén Kaiafas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wani kundi wate, déku mawuléké wunga yamba vékulakandékwe. Wani kwaaré dé Gotna gaamba jémbaa yakwa akwi dunyanséna néma du téndéka Got dat wandéka wa wandén, Jisas kiyaae Juda du dakwat yékun yakwate yandékwanngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas kiyaae Judasat male katik yékun yaké dé. Genge gaayémba tékwa Gotna nyambalésat waak yékun yakandékwa. Kiyaae taamale waarape wandu de akwi nakurak kémba tékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiafas wunga wandéka de Judana néma dunyansé kundi bule gindarén, Jisas viyaandékngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yandaka Jisas Jerusalem gaayéna ménimba, deku nyéndémba nakapuk yamba yeyé yaayaténdékwe. Yandéka déku dunyansé sékét Jerusalem taakatake Efraimét yéndarén. Ye wani gaayémba wa yaréndarén. Wani gaayé du yarékapuk baka taalé tékwanmba wa téndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pasova waanangwa sapak yaaké yandéka némaamba Judasé wa Jerusalemét yéndarén. Deku apakundi vékute, yandarén kapéremusé yasnyéputiye kururémuké, wa yéndarén Jerusalemét. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ye saambake Jisaské waakndarén. Waakpatiye Gotna kundi bulndakwa néma gaamba téte dekét deku kapmang bulte anga wandarén, “Yénga pulak dé? Guné yénga guné vékwo? Pasovana néma nyaa véké kalmu yaaké dé kapuk?” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gotna gaamba jémbaa yakwa dunyanséna néma dunyan, Farisi dunyansé waak, anga wandarén, “Du nak Jisas yarékwa taalé vétake yaae nanat wandu. Nané Jisas kure kuriye kalapusmba taakakanangwa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nyaa taambak kaayék nak (6) yéndu wa Pasova waanangwa nyaa yaaké yakwa. Wani sapak Jisas déku dunyansale sékét Betanit yéndarén. Wani gaayé wan Lasarusna gaayé wa. Talimba wani du Lasarus kiyaandéka Jisas wandéka nakapuk taamale waarapndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jisasna kakému Lasarusna gaamba yaakéréndaka Jisas déku dunyansale sékét wulaae gaamba rakésndarén. Randaka Lasarusna nyange Marta kakému yaake kwayéléka kandarén. Lasarus dé dele rate karéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Déku nyange nak léku yé Maria yéku yaama yakwa gu ras kure ralén. Kure re Jisasna maanmba sévitake léku némbat létéklén. Wunga yaléka wani yéku yaama gaamba yaama yandéka gaamba ran du akwi vékundarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisasna du nak déku yé Judas Iskariot dé dele sékét randén wani gaamba. Wani du kukmba Jisas maamasat kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Maria wunga yaléka Judas vétake wandén, “Kamuké lé wunga yo? Wani gu wan yéku gu wa. Lé wani gu kwayéte néma (300 kina pulak) yéwaa kéraae musékapuk du dakwat kwayémunaalu yékun yakatik.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wan dé sél yakwa du wa. Dé Jisasna dunyanséna yéwaa kure re ras sél yandén. Dé wani yéku gu kéraamuké yéwaa ras sél yaké watake wa wunga wandén. Dé musékapuk du dakwaké yamba vékulakandékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wunga wandéka Jisas anga wandén, “Lat waaruké yambak. Kukmba wuné kiyaawutu kwaawumba rémngandakwa. Wanngé vékulakate wa wunga yalén.” Wanngé wate de Judasé pusaa rémngé yate yandakwanngé wa wandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Watake anga wandén, “Musékapuk du dakwa gunale sékét wa yarépéka-kandakwa. Yaréndaru mawulé yangunéngwa sapak apapu guné det yékun yakangunéngwa. Wuné gunale katik yarépékaké wuté.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jerusalemmba tékwa némaamba du dakwa vékundarén wa Jisas déku dunyan sékét Betanimba yaréndaka. Vékutake dé véké yaandarén. Jisas male véké yamba yaandakwe. Lasarus waak véké wa yaandarén. Lasarus kiyaandéka Jisas wandéka taamale waarapndénngé wandaka vékundarén. Wunga vékutake dé véké yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Wani taalémba yatékwa du dakwa kundi vékundarén Lasaruské. Vékute némaamba du dakwa de Jisaské yékunmba vékulakandarén. Yate deku néma dunyanséna kundi kalik yandarén. Yandaka de Gotna gaamba jémbaa yakwa dunyanséna néma dunyan Lasarusét waak viyaandékngé kundi gindarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Némaamba du dakwa Jerusalemét yéndarén, Pasova waanangwa nyaa yandakwa musé véké. Ye randarén. Re kwaae ganmba vékundarén Jisas Jerusalemét yaaké yandéka. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","15","Jisas donki nyaanmba waare yéndén. Jisas wunga yandénngé du nak talimba Gotna nyéngaamba anga viyaatakandén: Guné Saionmba tékwa du dakwa guné wup yaké yambak. Ma vé. Guna néma du dé a yaakwa. Donki nyaanmba waare yaandékwa. Wunga viyaatakandén. Jisas yaaké yandéka vékute némaamba du dakwa wa déku yé kavérékngé wate yaambumba yéte maawulak gaanga pulak musé satékndarén. Satéke kure ye yaambumba Jisas vétake déké mawulé tawulé yate anga waandarén, Néman Du Got wandéka wa yaandékwa. Wan yékun wa. Dé wan nané Israelséna néma du wa. Got dat yékun yénga yandu. Nané Gotna yé ma kavérékngwak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wunga waandaka Jisasna dunyansé wani muséké yamba vékusékndakwe wa. Kukmba Jisas Gotna gaayét waaréndéka wa vékulakandarén, wani yandarén muséké, talimba viyaatakandén kundiké waak. Vékulakate wa vékusékndarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Talimba némaamba du dakwa véndarén, Jisas wandéka Lasarus nakapuk taamale waarapndéka. Vétake wa yé yaayandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wandaka némaamba du dakwa de waak wani vékapuk yandarén kulé apanjémba yandénngé vékundarén. Vékutake wa Jisas véké yaambat yaandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yaae déku yé kavérékndaka Farisi dunyansé kalik yandarén. Yate dekét deku kapmang bulte anga wandarén, “Ma véna. Akwi du dakwa de Jisaské male wa néma mawulé yandakwa. Nana kundi yamba vékundakwe wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Juda du dakwa Pasova waanangwa nyaa yandakwa musé véte Gorét waatakuké wa Jerusalemét yéndarén. Nak gaayémba yaan dunyan ras waak yéndarén wunga yaké. De Grik dunyansé wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wani dunyansé ras ye Jisasna du nak Filipale bulndarén. Filip dé Betsaida du wa. Betsaida Galili distrikmba téndékwa. Wani dunyansé Filipét anga wandarén, “Néma du, nané Jisas vékwate yakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Naandaka Filip ye Andru we sékét yémbérén, wani muséké Jisasét waké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ye wambéréka Jisas anga wandén, “Duna Nyaan wuné. Got wuna yé kavérékngé yandékwa nyaa a yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ani kundi ma vékusék naa. Gunat a wawutékwan. An wanana wa. Raisna sék képmaamba nakurak male taawutakananu kukmba wani sék waare rékaamba sék vaakukandékwa. Wani sék taawukapuk yananu, wani sék nakurak male wunga raké yakwa. Wuné viyaandaru, wunéké yékunmba vékulakakwa du dakwa wa rékaamba yatékandakwa. Wuné viyaakapuk yandaru, wa taawukapuk baka rakwa raisna sék pulak kapmang wuné male téké yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Deku sépéké male vékulakakwa du dakwa lambiyak-ngandakwa. Katik kulémawulé kéraae yékunmba yatéké daré apapu apapu. Deku sépéké vékulakakapuk yate wuna jémbaaké male vékukwa apu, wa de kulémawulé kéraae yékunmba yatékandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Du dakwa wuna jémbaa yaké mawulé ye, wa de wuna kundi vékukandakwa. Vékwe de wuné rana taalémba de waak rakandakwa. Wuna aapa wuna jémbaa yakwa du dakwana yé kavérékngandékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wunga watake nakapuk anga wandén, “Bulaa wuna kwaminyan a bérukwa. Kiyaawuta nyaa a yakwa. Yandu Gorét anga waatakuké wuté? ‘Aapa, wuné kandé kiyaaké ya. Wunéké yaaké yakwa musé ma ve kusati.’ Wunga waké wuté? Yamba wa. Wuné kiyaae du dakwat yékun yaké wa gaayawutén ani képmaat.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Naatake Gorét anga wandén, “Aapa, méné waménu ména yé kavérék-ngandakwa.” Wunga wandéka ani kundi Gotna gaayémba gaayan anga: “Wuné wawutéka wuna yé wa kavérékndarén. Nakapuk wawutu kavérékngandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naandéka wamba tékésén du dakwa vékutake ras wa wan, “Jatndu wa yakwa.” Ras wa wan, “Gotna kundi kure gaayakwa du nak Jisasale wa bulndékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wunga wandaka Jisas det wandén, “Gotna gaayémba gaayakwa kundi wuné vékuwuténngé yamba wandékwe wa. Guné vékungunénngé wa wandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bulaa Got néma du rate ani képmaamba tékwa du dakwa yandarén muséké wakandékwa. Bulaa wandu ani képmaana néma du Satan yaange yékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wuné kusoréndaru kukmba ani képmaamba tékwa du dakwat wawutu wunéké yaakandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wunga wate dékét dé viyaandékngé yandakwanngé wa wandén. De wani kundi vékwe vékusékngandakwa, dé kiyaandu yandara muséké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jisas wunga wandéka dat wandarén, “Nané talimba Gotna nyéngaamba viyaatakandarén apakundimba vénanén. Got wan du Kraiské ani kundi anga viyaataka-ndarén: Dé katik kiyaaké dé. Apapu apapu rapéka-kandékwa. Viyaataka-ndarén apakundi vénanga méné wa wakwa, ‘Duna Nyaanét kusorékandakwa.’ Naaménéngwa. Kamuké méné wunga wo? Wunga kandéké méné wate wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Naandaka anga wandén Jisas, “Yaréyaré naae vérékngwa téwaayé nakapuk katik vérékngé dé. Bulaa a téwaayé vérékte ganngumba kaaléndékwa. Kaaléndéka guné kurkale vésékte yékunmba yaténgunéngwa. Kurkale yatéte yénguna yaambu vésék naakangunéngwa. Vésékte ganngumba katik yatéké guné. Ganngétémba yatékwa du dakwa de yéndara yaambu yamba vésékndakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bulaa wani téwaayé vérékte gunale yaténdékwa. Bulaa guné wani téwaayéké yékunmba ma vékulakangunék. Yékunmba vékulakate guné yaa kaalékwanmba yékunmba yatékangunéngwa.” Naate Jisas gwaaménja kundi wandén. Dé téwaayé vérékte kaalékwa pulak ye du dakwat yékun yandékwanngé wa wani gwaaménja kundi wandén. Wani sapak déku kundi vékute déku du dakwa yaténdarénngé wa wani gwaaménja kundi wandén. Jisas wunga watake ye paakwe yaréndén. Wani du dakwana ménimba yamba yaréndékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Talimba vékapuk yandarén kulé apanjémba késépéri wa yandéka véndarén. Vétake déké yamba yékunmba vékulakandakwe wa. Deku mawulé wa yékéyaak yawuran. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Talimba Gotna yémba kundi kwayétan du Aisaia deké anga viyaatakandén Gotna nyéngaamba: Néman Du, wananén kundi kandé yékunmba vékwak? Méné apa tapa yaménénga kandé vék? Wunga pulak du nak yamba re wa. Talimba Aisaia wunga viyaatakandéka wani du dakwa Jisaské yékunmba vékulakakapuk yandaka wa déku kundi wandén pulak wa sékérékén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Talimba Aisaia ani kundi waak anga viyaandén Gotna nyéngaamba: Got deku méni kuttépéwurétake wandéka deku mawulé wa kapére yawuran. Deku méni kuttépékapuk yandu wa kurkasale vékatik daré. Wunga wakapuk yandu déku kundi vékusékngatik daré. De wuna kundi kurkasale vékundaru wuné det yékun yakatik wuté. Aisaia Gotna kundi wunga viyaatakandén. Du dakwana mawuléké vékulakate wa wunga viyaatakandén. Talimba viyaatakandéka kukmba wani du dakwa Jisaské yamba yékunmba vékulakandakwe. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia Jisasna mayé apa vétake wa déké wani kundi viyaandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judana néma du ras wunga yamba yandakwe wa. De Jisaské yékunmba vékulakandarén. Vékulakate Farisi dunyanngé wup yate, Jisaské yékunmba vékulaka-ndakwanngé yamba kaapamba wandakwe wa. Wani kundi kaapamba wamunaandaru Farisi dunyansé watépéndaru de Gotna kundi bulndakwa gaat katik wulaaké daré. Farisi dunyan watépémuké wup yate wa wani kundi yamba kaapamba wandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yate nak du dakwa deku yé kavérék-ndarénngé wa vékulakandarén. Got deku yé kavérékndénngé yamba vékulakandakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas némaanmba waate anga wandén, “Guné wuna kundi yékunmba vékulakate, wa wuna kundi male yamba vékulakangunéngwe wa. Wan wunat wandéka gaayawutén wani du Gotna kundi waak wa yékunmba vékulaka-ngunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wuné véte wuna aapa Gorké waak wa vésékngunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wuné guna kapérandi mawulé kururéké wa gaayawutén ani képmaat. Gaaye gunat yéku mawulé kwayéte yéku téwaayé vérékte kaalékwa pulak wa téwutékwa. Téwaayé vérékte kaaléndu ganngumba katik raké daré. Guné wuna kundi yékunmba vékulakangunu yéku mawulé kwayéwutu yékunmba yatépéka-kangunéngwa. Kapérandi mawulé nakapuk katik vékuké guné. Wunga yate katik ganngumba yatéké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Wuné néma du rate wuna kundi vékukapuk yakwa du dakwaké anga katik waké wuté, ‘Wa kapérandi musé yakwa du dakwa wa.’ Wunga katik waké wuté. Wuné wani jémbaa yaké yamba gaayawutékwe wa ani képmaat. Wuné du dakwana kapérandi mawulé kururéké wa gaayawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Sésékuk sékéyakmba yaana nyaa wa Got néma du rate du dakwa yan muséké wakandékwa. Wani nyaa, wunat wani kuk kwayén du dakwat waarukandékwa, wuna kundi vékukapuk yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yékun wa. Yi wan wanana wa. Wuna mawulémba vékulakate ani kundi yamba wawutékwe wa. Wuna aapa wandéka yaawutéka, waké yawutékwa kundi akwi wunat wa wandén. Wandéka wani kundi male wa gunat a wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wuné wa vékusék-wutékwa. Guné wani kundi kurkasale vékwe, wa kulémawulé kéraae apapu apapu yékunmba yatésékéyakngangunéngwa. Wunga vékusékte Got wunat wandén pulak wa gunat wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova waanangwa néma nyaa wayéka yaakwate yandéka Jisas anga vékusékndén. Kiyaae ani képmaa yaasékatake déku aapaké yéké yandékwa sapak a yaakwa. Yate déku dunyansale rate deké néma mawulé yasékéyakndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Garambu Jisas déku dunyansé sékét kakému karéndaka Satan yaae Judas Iskariotna mawulémba wulaandén. Wulaae dat watakandén Jisas déku maamasat kwayéndénngé. Judas dé Saimon Iskariotna nyaan wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas dé vékusékndén wa. Déku aapa akwi musé dat kwayétake wandéka wa gaayandén. Gaaye déku jémbaa yasékéyaktake wa nakapuk déku aapaké waambule yékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wunga vékusékte kakému karéndaka Jisas waarape téte déku yé kavérékngapuk yate jémbaa yakwa du pulak yakwate yandén. Yate yépmaa yandéka saape téndén laplap laaritake gu létékndakwa laplapét kéraae gindén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yatake dismba gu wukaae deku maan yanjangndén. Yanjangte wani giye téndén gu léték laplapét gu létékndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wunga yalakét ye Saimon Pita ranmba saambakndén. Saambakndéka Pita wa dat wan, “Néman Du, kamuké méné yanjangu wuna maan? Méné wunga yamuké wuné kalik yawutékwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Naandéka Jisas wa wan, “Bulaa a yawutékwa musé yamba vékusékngunéngwe wa. Kukmba wa vékusék-ngangunéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wunga wandéka Pita wa wan, “Yamba wa. Wuna maan yanjangngé yambak.” Naandéka Jisas wa wan, “Ména maan yanjang-ngapuk yawutu, wuna jémbaa nakapuk katik yaké méné.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wunga wandéka Saimon Pita Jisasna jémbaa yaké néma mawulé yate wandén, “Néman Du, wuna maan male yanjang-ngé yambak. Wuna maan, taamba, maaka waak akwi ma yanjangménu.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naandéka Jisas wa wan, “Gu wa yaakuménén. Ména maanmba male wa kwaakwa képmaa. Ména maan yanjangtakawutu méné yékunmba yatékaménéngwa. Bulaa guné akwi wa yékun yangunén. Yangunénga guna du nakurak male wa kapérandi mawulé vékuréndékwa. Yate dé yékun yamba yandékwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wunga wate Jisas vékusékndén wa. Déku du nak, Judas, wa kwayékwate yakwa dé déku maamasat. Wunga vékusékte wa wandén, “Guna du nak yamba yékun yandékwe wa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas deku maan yanjangwurétake yépmaa yandéka saape téndén laplap nakapuk saawuwe rate det anga wandén, “Gunat wani yawutén muséké guné vékuséku? Bulaa kundi ras wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Guné wunat anga wangunéngwa, ‘Néman Du. Gotna kundiké yakwasnyékwa du wa.’ Yékun wa wangunéngwa. Wuné guna néma du a. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wuné guna néma du rate guna maan wa yanjangwutén. Baka duna jémbaa wa yawutén. Yate wuna yé yamba kavérékwutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Guné waak wunga yate nak duna maan ma yanjang-ngunék. Wuné guna néma du wani yéku jémbaa gunat wakwasnyéwutéka wa véngunén. Guné wuna jémbaa yakwa du ve wuné yan pulak yangunénngé wa yawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jémbaa yakwa du néma du yamba téndékwe wa. Wan dé néma du kalik yakwa jémbaa wa yandékwa. Dat jémbaa kwayékwa du wa déku néma du tékwa. Kundi wandéka vékwe wandén pulak yakwa du, dé néma du yamba wa. Dat kundi wan du wan néma du wa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Guné wani kundi vékusékte wuné guna néma du yan pulak yamunaangunu, wan yékun wa. Guna yé kavérékngapuk yate baka du dakwana jémbaa yate nak du dakwat yékun yamunaae wa guné mawulé tawulé yénga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Guné akwi wunga katik yatéké guné. Wuna wawutén dunyansat akwi wa vésékwutén. Gunémba du nak wunat kapéremusé yakandékwa. Wan wa vésékwutékwa. Talimba du nak wani duké Gotna nyéngaamba anga viyaatakandén: Du nak wunale rate kakému katake wunat yaavan kurkandékwa. Viyaatakandén kundi bari a sékérék-ngandékwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Taale gunat wawutékwa. Wawutékwa musé kukmba yaandu guné véte anga wakangunéngwa, ‘Jisas néma du wa. Got wandéka wa gaayandén. Yi wan wanana wa.’ Wunga wate wunéké yékunmba vékulaka-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wawutén dunyansé ye wuna kundi kwayéndaru guné wani kundi yékunmba vékute det yékun yamunaae, wa wunat waak wa yékun yangunéngwa. Wuna kundi vékute wunat yékun yamunaae, wa guné wunat wandéka yaawutén duna kundi vékute dat waak wa yékun yangunéngwa. Yi wan wanana wa. Gunat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas wunga wandéka déku kwaminyan bérundéka wandén, “Gunat a wawutékwa. Gunémba du nak wuné kwayékandékwa wuna maamasat. Yi wan wanana wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wunga wandéka déku dunyansé de yamba vékuséke wa. Jisas kandéké dé wak? Vékusékngapuk ye dekét deku kapmang bulte dat vé, dat vé yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisasna du nak, déku mawulé yasékéyakndékwa du, dale sékét randén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Randéka Saimon Pita dat maakat yate anga wandén, “Méno, Jisasét ma waatakwe vé. Kandéké dé wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naandéka dé lakasati naae Jisasale rate dat anga waatakundén, “Néman Du, kandéké méné wo?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Naandéka Jisas wa wan, “Bret kumbingumba kusande taawuwe wani duwat kwayékawutékwa.” Wunga watake bret ayélap kéraae kumbingumba kusande taawuwe Saimon Iskariotna nyaan Judasét kwayéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kwayéndéka Judas kéraandéka Satan déku mawulémba wulaandén. Wulaandéka Jisas Judasét anga wandén, “Yaké vékulaka-ménéngwa musé bari ma ya.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wunga wandéka kakému karékésén dunyansé wani muséké yamba vékundakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yate ras deku mawuléké anga wandarén, “Judas nana yéwaa kure randéka wa Jisas dat wandékwa, kakému ras kéraandénngé.” Yate ras wa wan, “Wa Judas nana yéwaa kure randéka wa Jisas dat wandékwa yéwaakapuk du rasét kwayéndénngé.” Wunga wate kurkale yamba vékusékndakwe wa, Jisas Judasét wandén kundiké. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas Jisas kwayén kakému kéraae katake bari gwaandéndén. Gaan ye téndéka ganngumba gwaandéndén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas waarape gwaandéndéka Jisas anga wandén, “Duna Nyaan wuné. Bulaa wuna mayé apa vékangunéngwa. Véte wuna aapa Got néma du randékwanngé vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wuna mayé apa véte Gorké vékusékngunu, Got wandu wuné bari dale rate néma du rakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Guné wuna nyambalésé pulak wa. Gunéké mawulé yasékéyakwutékwa. Wuné gunale kulémba katik yaréké wuté. Wuné guné yaasékatake bari yéwutu guné wunéké waakngangunéngwa. Talimba Judana néma dunyansat anga wawutén, ‘Wuné yékwa yaambumba guné katik yaaké guné.’ Wunga wawutén pulak wani kundi male gunat a wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bulaa kulé apakundi kwayékawutékwa gunat. Guné ani kundi kurkale ma vékungunu. Wuné gunéké mawulé yasékéyakte gunat yékun yawutékwa. Gunat yawutékwa pulak, guné wuna dunyanséké akwi ma mawulé yasékéyakngunu. Yate det wunga ma yékun yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wunga yangunu nak du véte anga wakandakwa, ‘Wani dunyansé nak dunyanséké mawulé yasékéyakte wa det yékun yandakwa. Wunga yate de Jisaské yékunmba vékulakate déku dunyan wa yaténdakwa. Yi wan wanana wa.’ Naakandakwa gunéké.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jisas wunga wandéka Saimon Pita wa wan, “Néman Du, nak taalat yéké méné wo. Yénga yéké méné?” Wunga waatakundéka Jisas wa wan, “Wuné yéké yakwa taalat méné katik yaaké méné. Kukmba wa yaakaménéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naandéka Pita wa wan, “Néman Du, wuné ménale yékawutékwa. Wuné ménale yaréké mawulé yawutékwa. Wunga yawutu wuné viyaandék-munaandaru wan yékun wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wunga wandéka Jisas wa wan, “Méné wunat yékun yaké we kiyaaké méné wo kapuk? Yamba wa. Wa vékusékwutékwa. Bulaa gaan méné apu kupuk anga wakaménéngwa, ‘Wuné yamba véwutékwe wa Jisas.’ Wunga waménu wa kukmba séraa waaké yakwa. Yi wan wanana wa. Ménat wa wawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas déku dunyansat anga wandén, “Guné wuné yéké yakwanngé vékulakate mawulé sémbéraa yaké yambak. Guné wuna aapa Gorké ma yékunmba vékulakate wunéké waak yékunmba vékulakangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Talimba gunat anga wa wawutén, ‘Wuné ye yarénguna gaa kururé-kawutékwa.’ Naawutén kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Wuna aapana gaayé wan néma gaayé wa. Némaamba gaa wa kwaakéskwa wani gaayémba. Guné yarénguna gaa wamba wa kwaakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Wuné ye guna gaa kururé-kawutékwa. Yatake nakapuk waambule yaae guné kéraawutu wunale yékangunéngwa. Ye wunale yarékangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wuné yéké yakwa gaayéna yaambuké guné wa vékusék-ngunéngwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wunga wandéka Tomas wa wan Jisasét, “Néman Du, méné yéké yakwa gaayéké yamba vékuséknangwe wa. Wani gaayét yéména yaambuké waak yamba vékuséknangwe wa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Naandéka Jisas wa wan, “Wuné wani gaayét yénguna yaambu anana. Wawutékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Guné kurkale rapékangunénngé wa kulémawulé kwayéwutékwa. Guné wuna kundi yékunmba vékute kwayéwuta mawulé kéraamunaae, wa wuna aapana gaayét yékangunéngwa. Wuna kundi yékunmba vékukapuk ye, wuna aapana gaayét katik yéké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wunéké vésékmunaae, wa wuna aapaké waak vésékngangunéngwa. Bulaa wunat véte déké wa vésékngunéngwa. Sérémaa waak wuna aapaké vésék-ngangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jisas wunga wandéka Filip wa wan, “Néman Du, nané nana aapa Got véké mawulé yanangwa. Méné dé nanat wakwasnyéménu, nané ménat katik waatakuké nané déké.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Naandéka Jisas Filipét anga wandén, “Késépéri baapmu wa gunale yatéwutén. Yénga méné wunéké vékusékngapuk yak? Wuné vén dunyansé, Got waak wa véndarén. Kamuké méné anga wo? ‘Nana aapa Got nanat ma wakwasnyé.’ Méné wunga waké yambak. Méné dé wa véménéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aané wuna aapa Gorale nakurakmawulé wa yatékwa. Wani kundiké méné yékunmba vékulako kapuk? Gunat wawutén akwi kundi wuna mawulémba vékulakate yamba wawutékwe wa. Got wuna mawulémba rate déku jémbaa yandéka wa wani kundi wawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Guné guna mawulémba anga ma wangunék, ‘Jisas déku aapa Gorale bét nakurakmawulé wa yambérékwa. Yi wan wanana wa.’ Wunga ma wangunék. Wunga wakapuk yate, wa yawutén kulé apanjémba véte wunéké ma yékunmba vékulakangunék. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Gunat a wawutékwa. Guné wunéké yékunmba vékulakakwa dunyan, guné waak wuné yakwa kulé apanjémba yakangunéngwa. Guné yawutéka véngunén kulé apanjémba yaténgunu, wuné bari kiyaae wuna aapa Gorké yéwutu guna jémbaa wa wuna jémbaat taalékéraké yakwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wuné gunat yékun yawuténngé mawulé ye wuna yémba waate Gorét waamunaangunu wa mawulé yangunéngwa jémbaa yakawutékwa. Wunga yawutu akwi du dakwa véte Gotna yé kavérék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Guné wuna yémba waate wunat waatakungunu, wuné mawulé yangunéngwa musé yakawutékwa.” Naandén Jisas det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas nakapuk anga wandén, “Guné wunéké mawulé yasékéyakmunaate, wa wuna apakundi yékunmba vékute wawutékwa pulak yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yangunu wuna aapat waatakuwutu nak duwat wandu yaae wuna taalé kéraakandékwa. Kéraae gunat yékun yate gunale yatépéka-kandékwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wani kundi wawutékwan, wan Gotna Yaamambiké wa wawutékwa. Dé wandékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Wuna jémbaamba yaalan du dakwa male dé vékandakwa. Baka du dakwa dat véte vésékngé yapatikandakwa. De déku kundi katik vékuké daré. Dé guna mawulémba rapékandu dé vésék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wuné guné yaasékatake yéwutu, guné aapakiyaa aasakiyaa nyambalésé pulak katik yaréké guné. Wuné gunéké waambule yaakawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yaréyaré naae wuné ani képmaa yaasékatake ye waambule yaawutu wuna jémbaamba yaalakapuk yan du dakwa, wunéké waake wuné katik véké daré. Yandaru guné wuna jémbaamba yaalan du dakwa nakapuk wuné vékangunéngwa. Wuné apapu apapu yékunmba yarésékéyakwutu guné kulémawulé kéraae yékunmba yarésékéyak-ngangunéngwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Waambule yaawuta nyaa yaandu wa guné wunéké kurkale vékusék-ngangunéngwa. Wuné wuna aapana kundi kurkale vékute wa aané dale nakurakmawulé yatékwa. Wuné gunéké yaae guna mawulémba rawutu guné wuna kundi vékute wunale nakurakmawulé yakangunéngwa. Wuna kundi vékute wawutékwa pulak yakwa du dakwa, wa de wunéké mawulé yasékéyakndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wunéké mawulé yasékéyakngwa du dakwaké wuna aapa Got mawulé yasékéyakndékwa. Wuné waak wani du dakwaké mawulé yasékéyakwutékwa. Yate rawutu de wuné véte vésékngandakwa.” Naandén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas wunga wandéka, Judas dat wandén. Wan Judas Iskariot yamba wa. Nak Judas wa. Anga wandén, “Néman Du, a waménéngwa kundi wuné yamba vékuséke wa. Nané ménat ve véséknganangwa. Naaménén. Yénga pulak yaménu, de ména jémbaamba yaalakapuk yan du dakwa de méné vékapuk yandaru, nané méné véké nané?” ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Naandéka dat Jisas wa wan, “Wunéké mawulé yasékéyakngwa du dakwa de wuna kundi yékunmba vékute wawutékwa pulak yandakwa. Wunga yana du dakwaké wuna aapa mawulé yasékéyakngandékwa. Yandu aané wuna aapa sékét ye wani du dakwana mawulémba wulaae rakatékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Deku mawulémba wulaae ratu baka du dakwa aané katik véké daré. De wuné kalik yate wuna kundi yamba vékundakwe wa. Ani kundi wuna mawulémba vékulakate yamba wawutékwe wa. Wuna aapa wandéka vékute wa gunat wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bulaa gunale yatéte wa gunat ani kundi wawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kukmba kulé du nak gunéké yaakandékwa. Wani du wan Gotna Yaamambi wa. Wuna aapa wandu dé yaae wuna taalé kéraae guna mawulé yékun yakandékwa. Dé yaae gunat késépéri kundi kwayékandékwa. Kwayéndu guna mawulé kutélangndu guné wawutén akwi kundiké nakapuk vékulaka-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Wuné guné yaasékatake yéké yate yéku mawulé kwayéwutékwa gunat. Kwayéwutu guna mawulé yékun tékandékwa. Wuna mawulé yékun tékwa pulak, wa guna mawulé tékandékwa. Ani képmaamba képakmba yatékwa du dakwa, deku mawulé wunga pulak yamba te wa. De ani képmaana musé aséké male wa vékundakwa. De kwayéké yawutékwa mawuléké yamba vékusékndakwe wa. Wuné yéké yakwanngé vékulakate guné mawulé sémbéraa yate wup yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gunat anga wa wawutén, ‘Wuné guné yaasékatake ye nakapuk waambule yaakawutékwa.’ Wunga wawutéka wani kundi wa vékungunén. Vékute wunéké mawulé yasékéyakmunaate, aapaké yéké yawutékwanmba wa guné mawulé tawulé yakangunéngwa. Wuna aapa néma du wa randékwa. Wuné wa taalékérandén. Taalékérandéka wa yéwutékwa dé véké. Wan yékun wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bulaa wuné yéké yakwanngé gunat wa wawutén. Kukmba wuné yéwutu anga ma wangunu, ‘Jisas yéké yate nanat wa wandén. Got wandéka wa gaayandén nanéké. Yi wan wanana wa.’ Naangunénngé wa wani kundi wawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Gunale némaamba kundi ras waak katik bulké wuté. Ani képmaana néma du Satan a yaakwa. Yaae wuna néma du katik raké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yandu ani képmaamba tékwa du dakwa vékusék-ngandakwa, wuna aapaké mawulé yasékéyak-wutékwanngé. Wunga yandarénngé wa mawulé yawutékwa. Mawulé yate wuna aapa wunat wandén jémbaa wa yawutékwa. Yaak wa. Ma waarape yékwak.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas déku dunyanét anga wandén, “Wuné yéku wain miyé pulak a téwutékwa. Wuna aapa Got dé wani miyéké vérékwa du pulak wa randékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wani miyémba késépéri gaalé wa tékéskwa. Wuna jémbaamba yaalan du dakwa, de wani miyé gaalé pulak wa. Yéku jémbaa yakapuk yakwa apu wan sék vaakukapuk yakwa miyé gaalé pulak téndaka, yéku mawulé vékute yéku jémbaa yakwa du dakwa wan de sék vaakukwa miyé gaalé pulak wa téndakwa. Wani miyéké vérékwa du sék vaakukapuk yakwa gaalé satékyasnyéndékwa. Sék vaakukwa gaalé véte saal sénaandékwa, de yékun yate rékaamba sék vaakundarénngé. Wani du yakwa pulak wuna aapa wunga yandékwa. Yéku jémbaa yakapuk apu, wandéka yéndakwa. Yéku jémbaa yakwa apuna mawulé kururéndékwa, deku mawulé yékun téndu de késépéri yéku jémbaa yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Guné wuna dunyansé wawutén kundi yékunmba vékungunénga, dé guna mawulé kururéndéka guna mawulé wa yékun yan. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Guné wunale nakurakmawulé yate wunale rakangunéngwa. Wungaké mawulé yawutékwa. Wani satékyasnyéndékwa gaalé kapmang rate, wa sék katik vaakuké dé. Guné wunale nakurakmawulé yakapuk yate, wa wani miyé gaalé rakwa pulak kapmang ramunaae, wa guné yéku mawulé vékute yéku jémbaa katik yaké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wuné wani miyé apa pulak wa téwutékwa. Guné wani miyéna gaalé pulak wa téngunéngwa. Guné wunale nakurakmawulé yate, wa yéku mawulé vékute késépéri yéku jémbaa yakangunéngwa. Guné wuné yaasékatake yémunaae, yéku jémbaa katik yaké guné. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Miyé gaalé satékyasnyéndaru rékaa yakandékwa. Wunale nakurakmawulé yakapuk yakwa du dakwa rékaa yakwa gaalé pulak kapére ye rakandakwa. Randaru sérémaa wani rékaa gaalé yapike yaamba waarkate tukandakwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Guné wunale nakurakmawulé yate rangunu wuna kundi guna mawulémba randu Gorét waatakungunu, wa dé mawulé yangunéngwa musé kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Guné yéku mawulé vékute yéku jémbaa késépéri yangunu némaamba du dakwa véte anga wakandakwa, ‘Jisasna jémbaa wa yandakwa. De déku dunyan wa. Yi wan wanana wa.’ Naate wuna aapana yé kavérék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wuna aapa wunéké mawulé yasékéyakndékwa pulak wa wuné gunéké wunga mawulé yasékéyakwutékwa. Wuné gunéké mawulé yasékéyak-wutékwanngé apapu ma vékulaka-pékaténgunék. Yékéyaak yaké yambak. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Apapu wuné wuna aapana kundi vékuwutéka dé wunéké mawulé yasékéyakndékwa. Yandékwanngé wuné yamba yékéyaak yawutékwe wa. Yawutékwa pulak, guné wuna kundi vékute wuné gunéké mawulé yasékéyak-wutékwanngé yékéyaak yakapuk yate ma yékunmba yatépékangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Guné mawulé tawulé yate dusék yangunénngé wa gunat wani kundi wawutékwa. Wuna yéku mawulé kéraae wuna dunyan tésékéyakngunénngé wa mawulé yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ani kundi wawutu kurkale ma vékungunu. Wuné gunéké mawulé yasékéyakwutékwa pulak, guné wuna du dakwaké ma wunga yangunu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Guné guna du dakwaké mawulé yasékéyakte det yékun yaké we kiyaamunaangunu, wan yéku yapaté wa. Deké we kiyaanguna mawulé wa taalékéran akwi yéku mawulat. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Guné wuna kundi vékumunaate, wa guné wuna mawulé yasékéyakwutékwa dunyan yatépéka-kangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bulaa gunat anga wawutékwa: Guné wuna mawulé yasékéyakwutékwa dunyan wa. Wunga wate gunat nakapuk anga katik waké wuté: Guné wuna jémbaa yakwa dunyan wa. Wunga katik waké wuté. Jémbaa yakwa dunyan deku néma duna mawuléké yamba vékusékndakwe wa. Wuna aapa wan akwi kundi vékutake guna néma du wuné gunat wa wawutén. Wawutéka guné wuna mawuléké wa vékusékngunéngwa. Yangunénga bulaa gunat anga wawutékwa: Guné wuna mawulé yasékéyakwutékwa dunyan wa. Naawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Guné guna mawulémba yamba yaangunéngwe wa, wunale jémbaa yaké. Wuné wawutéka wa yaangunén. Yaae wuna yéku jémbaa yangunéngwa. Wani jémbaa katik késké dé. Guné wani jémbaa yate wuna yémba wate wuna aapat waataku-munaangunu, wa wangunéngwa musé wunga yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bulaa gunat anga wawutékwa. Guné guna dunyanngé ma mawulé yasékéyakngunék. Wawutékwa kundi kurkale ma vékungunék.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas wani kundi watake det anga wandén, “Ani képmaamba téte yékéyaakmba yatékwa du dakwa gunéké kalik yamunaandaru wan baka musé wa. Taale wunéké kalik yandarén. Wunga wa vékusékngunéngwa. Wunéké kalik ye kukmba gunéké waak kalik yakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Guné dele nakurak jémbaamba wulaamunaangunu, wa de gunéké mawulé yakatik daré. Guné nakpulak jémbaamba wa yaalangunén. Wuné gunat wawutéka wa deku jémbaa yaasékatake wa wuna jémbaamba yaalangunén. Yaalangunénga wa guné kalik yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Talimba gunat anga wa wawutén, ‘Jémbaa yakwa du néma du yamba wa. Dat jémbaa kwayén du wa néma du rakwa.’ Wunga wawutén kundi ma vékulaka kurkasale. Guna néma dunyan wunat yaavan kutndarén pulak, gunat wunga yaavan kurkandakwa. De wuna kundi vékumunaate, wa guna kundi waak vékukandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","De Gorké yamba vékusékndakwe wa. Got wuné wandéka gaayawuténngé vékusékngapuk yate, wa guné wuna dunyan yaténgunéngwanngé gunat yaavan kurkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Wuné yaae det kundi kwayékapuk yamunaawutu, wa de yandarén kapéremuséké katik vékusékngatik daré. Wuné yaae det wawutéka wa yandarén kapéremuséké vékusékndakwa. Vékuséktake anga katik waké daré, ‘Vékusékngapuk yatéte wa kapéremusé yananén.’ Wunga katik waké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wunéké kalik yakwa du dakwa, wa wuna aapa Gorké waak wa kalik yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Talimba nak du nak yaae wuné yakwa pulak kulé apanjémba yamba yandékwe wa. Wunékét wuna kapmang yaae wa wani jémbaa yawutén. Wuné wani jémbaa yakapuk yamunaawutu, de ani képmaamba téte yékéyaakmba yatékwa du dakwa de yandarén kapéremuséké katik vékusékngatik daré. Wuné wani jémbaa yawutéka wa véndarén. Vétake de yandarén kapéremuséké vékusékte de wuna aapale aanéké kalik yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wuné kapéremusé nak yakapuk yawutéka wunéké baka kalik yandaka Gotna nyéngaamba kwaakwa kundi nak bulaa wa sékérékén. Du nak talimba nyéngaamba anga viyaatakandén: Wunat baka kalik yandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kukmba kulé du nakét nak wawutu gunéké yaae guna mawulé yékun yakandékwa. Bulaa wuna aapa Gorale wa randékwa. Wuné Gorét waatakuwutu dé wandu yaakandékwa. Wani du dé Gotna Yaamambi wa. Dé kwayékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Dé yaae wunéké kundi kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Guné waak wunéké ma kundi kwayéngunék. Wuné ani képmaamba yatéte taale jémbaa baasnyé ye yawutéka wunale yatéte wa véngunén. Bulaa wunale yatéte wuna jémbaa wa véngunéngwa. Vétake guné wunéké det ma kundi kwayéngunék.” Naandén Jisas déku dunyansat. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas wani kundi watake déku dunyanét nakapuk anga wandén, “Bulaa wunéké yékunmba vékulakangunéngwa. Guné wuna kundi yaaséka-ngunénngé kalik yawutékwa. Yate wani kundi gunat wa wawutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kukmba néma du ras wandaru guné kundi bulndakwa gaa yaasékatake wani gaat nakapuk katik wulaaké guné. Yangunu dunyan ras anga wakandakwa, ‘Wan kapéremusé yakwa dunyan wa. Nané det viyaandékte Gotna jémbaa yékunmba yakanangwa.’ Naatake guné viyaandék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wani dunyansé wuna aapale aané yamba vésékndakwe wa. Yate wa gunat yaavan kurkandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bulaa gunat wani muséké wa wawutén. Kukmba gunat yaavan kutndaru wakangunéngwa, ‘Talimba Jisas wandén pulak a yandakwa.’ Naate wuna kundiké vékulaka-kangunéngwa.” Naandén Jisas. Wani kundi watake nakapuk anga wandén, “Talimba gunale yatéte gunat wani kundi yamba wawutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bulaa guné yaasékatake yéké yate, wa ani kundi wawutékwa. Yaréyaré naae wunat wandéka yaawutén duké nakapuk waambule yékawutékwa. Yékwate yawutékwanngé guna du nak wunat anga yamba waatakundékwe, ‘Méné yénga yu?’ Wunga yamba waatakundékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wawutén kundi vékungunénga bulaa guna mawulémba wa kapére yakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Gunat a wawutékwa. Wuné yéké yawutékwan wan yékun wa. Yi wan wanana wa. Yékapuk yawutu guna mawulémba Yékun Yana Du katik yaaké dé gunéké. Wuné yéwutu wa yaakandékwa. Yaaké yandékwanngé vékulakangunu, wa guna mawulé katik kapére yaké dé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Wani du yaae ani képmaamba téte yékéyaakmba yatékwa du dakwat anga wakandékwa, ‘Guné kapére mawulé yate wa kapéremusé yangunéngwa. Jisaské yékunmba vékulakakapuk yate wa kapéremusé yangunéngwa. Jisas yéku musé male wa yandén. Yatake wa waambule yéndén déku aapaké. Dé nakapuk katik véké guné. Déku aapaké yéndéka bulaa anga wa vékusékngunéngwa. Wan dé yéku musé yan du wa. Wunga wa vékusékngunéngwa. Got néma du rate Satanna jémbaaké wa wandén. Watake yandén kapéremusé yakatakandékwa. Yakatandu guné véte anga vékusék-ngangunéngwa. Got néma du rate yananén kapéremuséké waak wakandékwa. Wunga vékusék-ngangunéngwa.’ Naakandékwa. Guna mawulémba Yékun Yana Du wunga wakandékwa, ani képmaamba téte yékéyaakmba yatékwa du dakwat.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Jisas wunga watake anga wandén, “Wuné rékaamba kundi ras waak gunat waké mawulé yawutékwa. Ye bulaa wawutu katik vékuké guné. Yékéyaak yakangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kukmba Gotna Yaamambi yaae gunat kundi kwayékandékwa. Dé kwayékwa kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Yaae wani kundi kwayéte guna mawulat yékun yandu guné kwayéndékwa akwi kundiké vékusék-ngangunéngwa. Déku mawulémba vékulakate katik waké dé. Wuné ye wawutu dé yaae kwayéwutén kundi gunat kwayékandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wuna kundi vékwe kwayéwutén kundi gunat kwayéte, wa dé wuna yé kavérékngandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wuna aapa Gotna mawulé akwi wa vékusékwutékwa. Yate Gotna Yaamambiké wa wunga wawutén. Gotna Yaamambi yaae kwayéwutén kundi gunat kwayéndu guné kurkale vékukangunéngwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisas wani kundi watake anga wandén, “Yaréyaré naae wuné katik véké guné. Kukmba yaréyaré naae wuné nakapuk vékangunéngwa.” ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Wunga wandéka déku dunyansé ras dekét deku kapmang bulte anga wandarén, “Wan Jisas wa wandékwa kundi yénga pulak kundi dé wo? Wani kundi nané yamba vékuséke wa. Anga wandén, ‘Yaréyaré naae wuné katik véké guné. Kukmba yaréyaré naae wuné nakapuk vékangunéngwa.’ Wunga wate nak kundi waak anga wandén, ‘Wuné wuna aapaké wa yékawutékwa.’ Jisas kamuké dé wunga wak? Wani kundi nané yamba vékuséke wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Wani kundiké Jisasét waatakuké yandaka Jisas deku mawulé vékusék-wurétake det anga wandén, “Gunat anga wa wawutén, ‘Yaréyaré naae katik véké guné wuné. Kukmba yaréyaré naae vékangunéngwa wuné.’ Wunga wawutéka guné wuna kundi vékusék-ngapuk ye, wani kundiké guné gunékét guna kapmang bulu, yi? ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Gunat a wawutékwa. Wuné guné yaasékatake yéwutu guna mawulé kapére yandu géraakangunéngwa. Géraangunu ani képmaamba téte yékéyaakmba yatékwa du dakwa de dusék takwasék yakandakwa. Taale kapére mawulé vékute sémbéraa yakangunéngwa. Kukmba yéku mawulé vékute mawulé tawulé yakangunéngwa. Yi wan wanana wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Taakwa nyaan kéraaké yate taale kaangél vékulékwa. Vékute mawulé tawulé yamba yalékwe wa. Ye wani nyaan kéraatake wani kaangélké nakapuk yamba vékulakalékwe wa. Wa wani kéraalén nyaanét véte mawulé tawulé yalékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Guna mawulé wani taakwana mawulé pulak wa. Bulaa guna mawulé kapére yandéka yamba mawulé tawulé yangunéngwe wa. Kukmba wuné nakapuk waambule yaawutu guné mawulé tawulé yate dusék yakangunéngwa. Yangunu wani yéku mawulé guna mawulémba katik kéraasnyéké daré. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Guné mawulé tawulé yate wani nyaa musé nakngé wunat katik waatakuké guné. Gunat a wawutékwa. Guné wuna aapat wuna yémba waatakungunu dé vékute mawulé yangunéngwa musé yakandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Talimba Gorét wuna yémba yamba waatakungunéngwe wa. Bulaa wunga ma waatakungunék. Waatakungunu mawulé yangunéngwa musé yandu guné mawulé tawulé yate dusék yakangunéngwa. Yi wan wanana wa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas wunga watake det anga wandén, “Gunat wawutén kundi wa gwaaménja kundimba wa wawutén. Sérémaa gwaaménja kundi nakapuk katik waké wuté. Yate wuna aapaké baka kundimba wawutu déké bari vékusék-ngangunéngwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Wawutu guné wuna yémba wuna aapat waataku-kangunéngwa. Dé gunéké néma mawulé yasékéyakndékwa. Yandu dat guna kapmang waataku-kangunéngwa, dé gunat yékun yamuké. Wuné dat katik waatakuké wuté, dé gunat yékun yamuké. Guné wunat véte anga wangunéngwa, ‘Jisas Got yaasékatake wa gaayandén nanéké. Yi wan wanana wa.’ Wunga wate guné wunéké mawulé yasékéyak-ngunéngwa. Wunga yangunénga wuna aapa gunéké mawulé yasékéyakndékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Talimba wuna aapa yaasékatake wa ani képmaat gaayawutén. Gaaye yare ani képmaa yaasékatake wuna aapaké waambule yékawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dé wunga wandéka wandarén, “Méné gwaaménja kundimba wakapuk yaménénga bulaa ména kundi vékute a vékuséknangwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Méné akwi musé, akwi jémbaa, akwi du dakwaké waak vékusék-wuréménén wa. Deku mawulému waak wa vékusékménéngwa. De kulé kundi nak katik ménat waatakuké daré. Nané wunga vékusékte ménéké yékunmba vékulakanangwa. Méné Gorale re wa gaayaménén. Yi wan wanana wa.” Naandarén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wandaka anga wandén, “Bulaa wunéké guné yékunmba vékulako kapuk? ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Anga wa vékusékwutékwa. Nané yaavan kurké yandakwa nyaa a yaakwa. Yaandu guné kapmang kapmang yaange yékangunéngwa guna gaayét. Guné yaange yéte wuné yaasékangunu kapmang téké yakwa. Téwutu wuna aapa dé wunale sékét tékandékwa. Téndu wuné male kapmang katik téké wuté. ");
INSERT INTO abt_wosera_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Guné wunale nakurakmawulé ye yéku mawulé vékute kurkasale téngunénngé wa wani kundi wawutén. Ani képmaamba téte yékéyaakmba yatékwa du dakwa gunat yaavan kurkandakwa. Yaavan kurké yandakwanngé vékulakate guné wup yaké yambak. Wuné néma du rawutéka wuna mayé apa wa deku mayé apat taalékéran. Taalékéranngé guna mawulé yékun yénga téndu.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas wunga watake Gotna gaayét yaasore vététe anga wandén, “Aapa, wuné kiyaaké yawutékwa sapak a yaakwa. Bulaa det ma waménu vékusékndaru. Wuné ména nyaan néma du a téwutékwa. Wunga vékusék-ngandakwa. Wuné kiyaawutu de méné néma du raménéngwanngé vékusék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wunat waménénga wuné ani képmaana du dakwana néma du wa téwutékwa. Téte wunat tiyaaménén akwi du dakwat kulémawulé kwayéwutu de kurkale tésékéyak-ngandakwa apapu apapu. Kwayéwutu méné wunéké waménu vékusékte de ména yé kavérék-ngandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","De kulémawulé kéraae anga vékusék-ngandakwa: Méné nakurak male wa méné néma du Got raménéngwa. Yi wan wanana wa. Méné waménénga wa wuné Jisas Krais yaawutén. Wunga vékusékte kurkale tésékéyak-ngandakwa apapu apapu. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Ani képmaamba yatéte yawuténngé waménén jémbaa wa yasékéyakwutén. Yate ména yé wa kavérékwutén. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Talimba ani képmaa baka téndéka wuné ménale rate wa nyaa véte kaalékwa pulak wa rawutén. Ménéké nakapuk waambule yéwutu waménu nakapuk nyaa véte kaalékwa pulak rakawutékwa.” Naandén Jisas. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jisas wunga watake anga wandén, “Wunat tiyaaménén dunyansat kundi wa kwayéwutén, ména jémbaaké. Talimba ani képmaamba baka yare wa ména jémbaamba yaalandarén. Yaale ména dunyan yaréndaka de wunat tiyaaménénga wa ména kundi kurkale vékundakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Vékute tiyaaménén mawuléké waak wa kurkale vékusékte wuna jémbaa véte anga wandakwa, ‘Wan Got wandéka wa yaandén Jisas. Got wandéka wa Jisas apamama yate wani jémbaa yandékwa. Yi wan wanana wa.’ Naandakwa. Tiyaaménénga kwayéwutén kundi vékwe wa wunga wandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Bulaa ménat waatakuwutékwa wani dunyanséké. Ani képmaamba téte yékéyaakmba yatékéskwa dunyanngé yamba waatakuwutékwe wa. Tiyaaménén apuat yékun yaménénngé wa waatakuwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ména dunyansé wa wuna dunyansé wa. Wuna dunyansé wa ména dunyansé wa. De wuna jémbaa yandaka nak du dakwa véte wa wuna yé kavérékndakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aapa, méné yékun wa. Ménat waatakuwutékwa wani dunyanséké. Wuné bulaa ani képmaamba katik yatéké wuté. Wuné ménéké yaakawutékwa. De a téké yakwa ani képmaamba. Ména mayé apa wa tiyaaménén wunat. Bulaa apamama yate det yékun ma yaménu. Yaménukét aané nakurakmawulé yatékwa pulak de nakurakmawulé yate yékunmba yatékandakwa. Wanngé mawulé yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ména mayé apa tiyaaménénga wa wuné dele yatéte det yékun yawutén. Yékun yawutéka du nak det yamba yaavan kutndékwe wa. De yékunmba yaténdarén. Nakurak du male lambiyak-ngandékwa. Lambiyakndu Gotna nyéngaamba wani duké viyaatakandarén kundi sékérékngandékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Bulaa yaakawutékwa ménéké. Wuné ani képmaamba téte ani kundi wawutén, wuna dunyan wup yakapuk yate wuna mawulé pulak kéraae mawulé tawulé yandarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ména kundi det kwayéwutéka vékundarén wa. De ani képmaamba téte yékéyaakmba yatékwa du pulak yamba wa. Wuné waak yékéyaakmba yatékwa du pulak yamba wa. Nané de yatékwa pulak yatékapuk yananga wa de nané kalik yandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ménat waatakuwutékwa. Tiyaaménén dunyansé ani képmaamba yaténdaru Satan det katik yaavan kurké dé. Méné det kurkale yakaménéngwa. De ani képmaa yaasékandaru méné de ména gaayét kuriménénngé yamba waatakuwutékwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","De wunale ani képmaamba yékéyaakmba yatékwa du pulak yamba yaténdakwe wa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ména kundi wan papukundi yamba wa. Wan yéku kundi wa. Yi wan wanana wa. Méné waménu wuna dunyansé ména yéku kundi yékunmba vékute ména dunyansé yatékandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Talimba méné waménénga wa wuné ani képmaamba tékwa du dakwaké gaayawutén. Gaaye wa wawutén, de ye ani képmaamba téte yékéyaakmba yatékwa du dakwat wuna kundi kwayéndarénngé. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wuné ména kundi vékute ména jémbaa male yawutékwa. Wuna dunyansé ve ména kundi vékwe ména jémbaa yandarénngé, wa wunga yawutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aapa, ménat ani dunyanngé male yamba waatakuwutékwe wa. Ani dunyan yéte wuna kundi kwayékandakwa, nak du dakwat. Kwayéndaru vékwe wunéké yékunmba vékulakana du dakwaké waak wa ménat waatakuwutékwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","De akwi nakurakmawulé yénga yandaru. Wunga mawulé yawutékwa. Méné wuna mawulémba raménénga wuné ménale nakurakmawulé yawutékwa. Yawutékwa pulak, de aanale nakurakmawulé yakandakwa. Wunga yananu ani képmaamba téte yékéyaakmba yatékwa du dakwa véte anga wakandakwa, ‘Got wandéka wa gaayandén Jisas. Yi wan wanana wa.’ Naakandakwa. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wuné jémbaa yawuténngé tiyaaménén wani mayé apa wa kwayéwutén, de jémbaa yandarénngé. Aané nakurakmawulé yakwa pulak, de nakurakmawulé yandarénngé, wa mayé apa kwayéwutén det. ");
INSERT INTO abt_wosera_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Méné wuna mawulémba raménénga wuné deku mawulémba wa rawutékwa. Yatékwa pulak de nakurakmawulé yakandakwa. Yandaru ani képmaamba téte yékéyaakmba yatékwa du dakwa det véte v