﻿USE sofia;
DROP TABLE IF EXISTS sofia.abt_maprik_vpl;
CREATE TABLE abt_maprik_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES abt_maprik_vpl WRITE;
INSERT INTO abt_maprik_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kén Jisas Kraisna képmawaara deku yé. Jisas Devitna kémba dé yaalak. Devit Ebrayamna kémba dé yaalak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebrayam wan Aisakna yaapa. Aisak wan Jekopna yaapa. Jekop wan Juda déku némaadugu wayéknaje wale deku yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda wan Peres bét Sirana yaapa. Bétku néwaa wan Tema. Peres wan Yesronna yaapa. Yesron wan Ramna yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram wan Aminadapna yaapa. Aminadap wan Nasonna yaapa. Nason wan Salmonna yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon wan Boasna yaapa. Boasna néwaa wan Reyap. Boas wan Obetna yaapa. Obetna néwaa wan Rut. Obet wan Jesina yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi wan Isrelna du taakwa deku némaan ban Devit déku yaapa. Ebrayamét taale naaknwukére ye ye Devirét kukba naaknwute naané du taaba vétik sékérékne maanba kayék wan véti wan véti (14) naaknwu. Devit wan Solomonna yaapa. Solomonna néwaa taale Yuraiana taakwa lé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon wan Riaboamna yaapa. Riaboam wan Abaisana yaapa. Abaisa wan Esana yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa wan Jeyosapatna yaapa. Jeyosapat wan Joramna yaapa. Joram wan Asaiana yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia wan Jotamna yaapa. Jotam wan Eyasna yaapa. Eyas wan Yesekaiana yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yesekaia wan Manasana yaapa. Manasa wan Emosna yaapa. Emos wan Josaiana yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia wan Jekonaia déku némaadu wayékna wale deku yaapa. Wani tulé Isrelna maama Babilonba yae de Isrel wale waariyak. Waariyadaka Babilonna apa Isrelna apat talaknadéka de Babilonba yaan du Isrelna du taakwat de kérae kure yék Babilonét. Devirét taale naaknwukére ye ye Jekonaiat kukba naaknwute naané du taaba vétik sékérékne maanba kayék wan véti wan véti (14) naaknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isrelna du taakwa Babilonba radan tulé Jekonaia wan Sialtielna yaapa. Sialtiel wan Serababelna yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel wan Abaiatna yaapa. Abaiat wan Elaiakimna yaapa. Elaiakim wan Esona yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso wan Sedokna yaapa. Sedok wan Ekimna yaapa. Ekim wan Elaiatna yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat wan Eleasana yaapa. Eleasa wan Matanna yaapa. Matan wan Jekopna yaapa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop wan Josepna yaapa. Josep wan Mariana du. Maria Jisasnyét lé kéraak. Déké naané wo, “Naanat kutkalé yaduké Got wadén ban Krais.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Déknyényba de Isrelna du taakwat kure yék Babilonét. Wani tulé Jekonaia dé rak. Jekonaiat taale naaknwukére ye ye Got wadén ban Kraisnyét kukba naaknwute naané du taaba vétik sékérékne maanba kayék wan véti wan véti (14) naaknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria Jisas Kraisnyét kéraalén kudi kéga dé kwao. Taale Mariana néwepa de wak, lé Josep wale raluké. Wadaka kukba bét nakurakba wekna ramarék yabétka Gotna Yaamabi giyae léké apa kwayédéka lé nyaan ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lérét kukba yaran ban, déku yé Josep, wan yéknwun mu male yakwa du. Lé nyaan téléka dé wani muké véknwute déku mawuléba dé wak, “Lé nak du wale bét kwaak. Bulaa lérét yamarék yaké wuné yo.” Naate watakne dé tépa wak, “Wuné lérét yamarék yate akwi du taakwana méniba téte lérét waatiwuréran lé nyékéri yaké lé yo. Wuné akélak lérét kulaknyényké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naate watakne wani muké sanévéknwute dé yégan nak yak. Yadéka Némaan Ban Gotna kudi kure giyaakwa du nak giyae dé dérét wak, “Méné Josep, Devitna képmawaara, mé véknwu. Méné wup yamarék yate Mariat yaké méné yo. Gotna Yaamabi giyae léké apa kwayédéka lé nyaan tu. Gotna Yaamabi waga kwayédénké méné wup yamarék yate lérét yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lé du nyaan kéraaké lé yo. Kéraalu dé déku du taakwat Setenna taababa kérae yadan kapéredi mu yatnyéputiké dé yo. Yadéranké sanévéknwute méné déku yé Jisas waaké méné yo.” Naate dé Josepmét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Déknyényba Némaan Ban Got déku yéba kudi wakwekwa dut kéni kudi wakwedéka dé Gotna nyégaba kéga kavik: Du ramarék taakwa nak nyaan téké lé yo. Te kéraalu de déku yé Emanyuel waaké de yo. Waga kavidéka wani tulé wani kudi adél dé yak. Wani yé Emanyuel kéga dé wo: Got naané wale dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep yégan yatakne ligéne raapme dé Némaan Ban Gotna kudi kure giyaakwa du wadén pulak dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yate dé Mariat yak. Wani tulé dé lé wale kaapuk kwaadén. Yadéka kukba nyaan kéraaléka dé déku yé waak, Jisas. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yerot Judana du taakwa deku némaan ban radén tulé Maria lé Jisasnyét kéraak, Betleyemba. Betleyem Judiaba dé tu. Kéraaléka kukba de nyétba tékwa kunké kutdéngkwa du nyaa yaalakwa taaléba yae de Jerusalemét yék. Ye saabe de wak, “Naané nyaa yaalakwaba rate nyétba tékwa kulé kunét naanébu vék. Véte naané kutdéngék. Kubusaaku nyaan débu yaalak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dé Judana du taakwa deku némaan ban raké dé yo. Kutdéngte kunét vétakne déké naané yao, déké kwati yaane waadé daaké. Dé yaba dé ro?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Naate wadaka némaan ban Yerot véknwutakne rékaréka yate dé wak, “Sal wani nyaan kukba wuna waagu tawuké dé yo?” Naate watakne wani muké kélik dé yak. Yadéka Jerusalemba rakwa wupmalemu du taakwa de wani muké sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yerot kélik yate wadéka de Gotna gaba jébaa yakwa nyédé duna akwi némaan du, Moses wakwen apa kudiké kutdéngkwa du akwi waga de yaak. Yaadaka dé derét waatak, “Got wadén ban Krais yaba yaalaké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Naate wadéka de dérét wak, “Judiaba tékwa gayé, Betleyemba yaalaké dé yo. Wani muké déknyényba Gotna yéba kudi wakwen du nak Gotna nyégaba Gotna kudi kéga dé kavik: ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Guné Betleyemba rakwa du taakwa, mé véknwu. Kukba guna gayéna du nak némaan ban raké dé yo. Rate dé wuna du taakwa Isrelké miték véké dé yo. Védéranké sanévéknwute de guna makwal gayé Judiana képmaaba tékwa gayé Betleyemké wamarék yaké de yo, ‘Wan bakna gayé.’ Waga wamarék yate guna gayéké waké de yo, ‘Némaa gayé.’ Waga dé kavik Gotna nyégaba.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Judana némaan ban Yerot wani kudi véknwutakne dé wak, nyaa yaalakwa taaléba yaan du déké yaadoké. Wadéka yaadaka nak du véknwumarék yadoké dé de wale akélak kudi bulék. Bulte dé derét waatak, “Yani tulé dé wani kun nyétba batnyé yaalak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naate waatadéka dérét wakwedaka dé wak, “Betleyemét yéké guné yo. Ye miték mé sékal wani nyaanké. Sékale vétakne gwaamale yae guné wunat wakweké yo. Wakwegunu wuné wawo ye kwati yaane déké waadé daaké wunék.” Naate wate dé derét yénaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yerot waga wadéka véknwutakne de yék. Yéte nyaa yaalakwaba déknyényba védan kunét de tépa vék. Wani kun nyétba taale yédéka de déku kukba yék. Yédaka dé wani kun nyaan kwaan gaba awuréba dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tédéka véte yéknwun mawulé yate de duséknét kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yate de gat wulae de vék wani nyaan déku néwaa Maria wale rabétka. Vétakne kwati yaane de waadé daak déké. Yate de deku wutba tén gwalmu jaarék. Jaare de déké yéknwun gwalmu kwayék. Gol matu, yaa sérakdaka yéknwun yaama yakwa mu, yéknwun yaama yakwa gu, waga de déké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kwayétakne re kwae de yégan yak. Yadaka dé Got derét wak, “Guné Yerotké gwaamale yémarék yaké guné yo.” Naate wadéka ligéne raapme de nak yaabuba gwaamale yék deku gayét. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wani du yédaka Josep yégan yadéka Némaan Ban Gotna kudi kure giyaakwa du nak giyae dé dérét wak, “Yerot wani nyaanké sékale vétakne dérét viyaaké dé yo. Waga yadu méné raapme wani nyaan déku néwaa wale kure yéké méné yo. Isipmét yaage yéké guné yo. Yaage ye guné wani képmaaba rasaakuké guné yo. Kukba wuné gunat wawuru guné gwaamale yaaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Naate wadéka dé Josep bari ligéne raapme wani nyaan déku néwaa wale kure de yaage yék. Nyédé gubés dé bérét kure yaage yék Isipmét. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ye saabe de Isipba rak. Yerot kiyaadéran tulé deku gayét tépa gwaamale yédaranké déknyényba rate Gotna yéba kudi wakwekwa du kavin kudi adél dé yak. Wani du Némaan Ban Gotna kudi véknwute wani kudi Gotna nyégaba kéga dé kavik: Wuna nyaan Isipba radu wuné dérét waawuru dé Isip kulaknyénytakne gwaamale yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Judana némaan ban Yerot Jerusalemba rate nyaa yaalakwaba yaan du déké gwaamale yédoké dé rapatik. Rapatiye rékarékat kapére yate dé wak, “Wunat yénaa debu yak.” Naate watakne dé déku mawuléba wak, “Nyaa yaalakwaba yaan du de wak, ‘Kwaaré vétik pulak déknyényba naané wani nyétba tékwa kunét batnyé vék.’ Naate de wak.” Naate watakne deku kudiké sanévéknwute dé déku waariyakwa duwat wak, “Guné Betleyemét ye, Betleyem tékwaba tékwa taalat wawo ye akwi du baadit viyaasadaké guné yo. Kwaaré vétik yan du baadi, kwaaré nakurak yan du baadi, kéraadan kulé du baadi wawo, derét akwi viyaasadaké guné yo.” Naate wadéka de ye wani baadit akwi de viyaasadak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Déknyényba Gotna yéba kudi wakwen du nak, déku yé Jeremaia, dé kéni kudi Gotna nyégaba kavik: ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramaba de wupmalemu du taakwa de némaanba gérao. Wani gayéba némaanba de gérao. Reselna képmawaara deku baadi debu kiyaak. Kiyaasadadak de deku baadiké de gérao. Deké némaa mawulé lékte de gérao. Yerot wadéka déku waariyakwa du Betleyemba baadit viyaasadadan tulé Jeremaia kavin kudi adél dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kukba Yerot dé kiyaak. Kiyaadéka Josep déku taakwa, nyaan wale Isipba de rak. Waba rate Josep yégan yadéka dé Némaan Ban Gotna kudi kure giyaakwa du giyae dé Josepmét wak, ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wani nyaanét viyaapérekgé mawulé yan du debu kiyaak. Bulaa méné raapme wani nyaan déku néwaa wale kure Isrelna képmaat gwaamale yéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naate wadéka Josep ligéne raapme wani nyaan déku néwaa wale kure de Isrelna képmaat gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep Isrelna képmaa saabe dé véknwuk, Akeleas déku yaapa Yerotna waagu tawe Judiaba rakwa du taakwaké némaan ban radéka. Véknwutakne Judiaba ramuké wup dé yak. Yate nak yégan yadéka Got dérét wadéka dé wani nyaan déku néwaa wale kure de Galilina taalat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ye de Nasaretba rak. Josep, Maria, Jisas wani gayéba radaka Gotna yéba kudi wakwen du déknyényba kavin kudi adél dé yak. Jisaské de kéga kavik: Déké waké de yo, Nasaret ban. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wani tulé gu yaakutaknakwa du Jon dé du ramarék Judiana taaléba dé batnyé Gotna kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wani taalat yaan du taakwat dé kéga wakwek, “Got némaan ban rate gunéké véran tulé kéni dé yao. Yaadékwaké sanévéknwute guné Gotna kémba raké mawulé yate guné kapéredi muké kuk kwayéké guné yo.” Naate dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Déknyényba Gotna yéba kudi wakwen du nak déku yé Aisaia Jonké Gotna nyégaba kéga dé kavik: Du nak dé wao du ramarék taaléba. Waate dé kéga wo, “Némaan Banna yaabu kutké guné yo. Kutgunu yaabu miték kwaaké dé yo déké.” Naate dé wo. Wani kudi Aisaia dé kavik, Jonna néwaa dérét kéraamarék yalén tulé. Kavidéka kukba Jon yae dé du taakwat wakwek, deku mawulé miték tédu de Jisas yaadéranké miték sanévéknwudoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon yéknwun baapmu wut, yéknwun kadémuké kaapuk sanévéknwudén. Dé kwaami sépéna yéwit yaatédan baapmu wut dé gik. Gitakne dé bulmakawu sépat yadan nyaamégi dé gipatak. Dé kwamijok dé kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Samgék pulak mu dé jélipme kak. Dé Gotna kudi wakwedéka de Jerusalemba rakwa du taakwa, Judiana képmaaba rakwa du taakwa, Jodanna kaabélé yékwaba rakwa du taakwa waga de wupmalemu du taakwa de déké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ye yadan kapéredi muké kélik yate wakwedaka dé derét Gotna yéba gu yaakutaknak Jodan kaabéléba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Judana du deku némaan du wupmalemu wawo de yék, Jon derét Gotna yéba gu yaakutaknaduké. Parisina du, Sadyusina du, waga de yék. Yédaka dé Jon derét waatite dé wak, “Guné kapéredi mawulé yakwa du guné. Got apakélé kot véknwute némaan ban raran nyaa kéni dé yao. Wani nyaa Got du taakwa yadan kapéredi muké rékaréka yaké dé yo. Wani nyaaké sanévéknwute guné du yaawi tudaka yaage yékwa kaabe pulak guné wunéké yaage yao. Wunéké yaamarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Taale guné yagunén kapéredi mu kulaknyénytakne guné yéknwun mu male yaké guné yo. Yagunu nak du taakwa véte waké de yo, ‘De kapéredi mu kulaknyénytakne bulaa yéknwun mu de yo.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Guné guna mawuléba guné wo, ‘Naané Ebrayamna képmawaara naané ro. Dé Gotna méniba yéknwun mu yakwa du radék naané wawo Gotna méniba yéknwun mu yakwa du naané ro.’ Naate wate yénaa guné yo. Guné yéknwun mu kaapuk yagunékwa. Got mawulé yadéran dé wadu kéni matu du ye de Ebrayamna képmawaara pulak raké de yo. Ebrayamna képmawaara ragunékwaké Got kaapuk sanévéknwudékwa. Yagunékwa muké dé sanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Aja kudi nak wakweké wunék. Du sék akumarék yakwa miké sanévéknwute kwajélek kérae wani mi véléké dé yo. Véle yaaba tuké dé yo. Bulaa wani aja kudiké mé sanévéknwu. Bulaa Got déku kudi véknwumarék yaran du taakwat yadan kapéredi mu yakataké dé yo. Yakatadu de yaa yaansaakukwa taalat yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Guné guna kapéredi mawulé kulaknyénygunéran wuné gunat Gotna yéba gu yaakutaknaké wuné yo. Wuna kukba yaaran du wan némaan du. Wuné bakna du wuné ro. Déku apa wuna apat dé talaknak. Yaga pulak déku jébaa yaké wuné yo, wuné bakna du rawurékwa bege? Dé némaan du radéka wuné déku gwalmu déké kure yéké wuné yapatiyu, wuné bakna du rawurékwa bege. Wuna kukba yaaran du Gotna Yaamabi gunéké kwayéké dé yo. Guna kapéredi mu kérae yaaba tuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Du wit kérae yéknwun wit sék kéraaké de gériyu. Géritakne de yéknwun wit sék gaba takne de apa yatjado. Yadakwa pulak wuna kukba yaaran du waga yaké dé yo. Dé déku du taakwat kérae kure ye déku gayéba takne kapéredi mu yan du taakwat kérae yaansaakukwa yaaba yatjadaké dé yo.” Naate dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wani tulé Jisas Galilina képmaa kulaknyénytakne dé Jodan kaabélat dé yék. Jon dérét Gotna yéba gu yaakutaknaduké dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ye saabadéka Jon kélik yate dé wak, “Méné némaan ban méné ro. Wuné bakna du wuné ro. Samuké méné wunéké yao, wuné ménat gu yaakutaknawuruké? Méné wunat gu yaakutaknaménéran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Naate wadéka Jisas dé wak, “Aya. Méné wunat gu yaakutaknaké méné yo. Waga yaménéran méné Got wadén pulak yaké méné yo.” Naate wadéka dé kusékérék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kusékéttakne Jisasnyét gu yaakutaknadéka dé bari guba yaalak. Yaaladéka nyét kepukadéka dé vék Gotna Yaamabi nyaamiyo pulak déké giyaadéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Giyaadéka de Gotna gayéba giyaakwa kudi kéga véknwuk, “Kén wuna nyaan. Déké wuné mawulat kapére yo. Déké wuna mawulé yéknwun dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon Jisasnyét gu yaakutaknadéka Gotna Yaamabi Jisasnyét dé kérae kure yék du ramarék taalat. Seten Jisasna mawulé yaknwuduké Gotna Yaamabi dérét wani taalat dé kérae kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kure yédéka Jisas wani taaléba rate kadému gu kaapuk kadén. Wupmalemu (40) gaan nyaa bakna dé rak. Re kukba kaadéké dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yadéka Seten yae dé dérét wak, “Méné kéga méné wo, ‘Wuné Gotna nyaan.’ Naate wate bulaa wani muké wunat wakwatnyéké méné yo. Méné waménu kéni wupmalemu matu walaakwe kadému yaké dé yo. Waga yadu wuné ménéké kutdéngké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Naate wadéka dé wak, “Aya kaapuk. Wani muké kéni kudi Gotna nyégaba dé kwao: Du taakwa kadémuké male sanévéknwute de miték ramarék yaké de yo. De Gotna kudi véknwudo deku mawulé miték tédu de miték raké de yo. Wani kudi véknwute matu kadému yaduké wuné wamarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas wani kudi wadéka Seten dé dérét kérae kure yék Jerusalemét. Kure waare dé dérét Gotna kudi buldakwa némaa gana madulba taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Takne dé dérét wak, “Méné kéga méné wo, ‘Wuné Gotna nyaan.’ Naate wate méné mé akére dawuli. Wani muké kéni kudi Gotna nyégaba dé kwao: Got déku kudi kure giyaakwa duwat wadu de ménéké miték véké de yo. Védo méné deku taababa rate ména maan matuba viyaamarék yaké méné yo. Méné wani kudi véknwute akére dawuliye miték raménu akwi du taakwa véte kutdéngké de yo. Méné Gotna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Naate wadéka dé Jisas wak, “Aya kaapuk. Wani muké kéni kudi Gotna nyégaba dé kwao: Got wan ména Némaan Ban. Dé apa yate ménat kutkalé yaduké waagété yakwa du pulak yamarék yaké méné yo. Wani kudi véknwute wuné akére dawulimarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jisas wani kudi wadéka Seten dérét dé kérae kure waarék apakélé nébat. Kure waare dé kéni képmaaba rakwa akwi gayé, wani gayéba rakwa akwi yéknwun gwalmu wawo dé Jisasnyét wakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wakwatnyétakne dé wak, “Méné kwati yaane wunéké waadé daate wuna yéba kevérékménéran wuné wani gayé, waba rakwa gwalmu wawo kwayéwuru méné deké némaan ban raké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Naate wadéka dé wak, “Méné, Seten, méné mé yaage yé. Kéni kudi Gotna nyégaba dé kwao: Ména némaan ban wan Got male. Méné déké waadé daate dérét waataké méné yo. Déku yéba male kevérékgé méné yo. Wani kudi véknwute wuné ménéké waadé daamarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naate wadéka dé Seten dérét kulaknyénytakne yék. Yédéka de Gotna kudi kure giyaakwa du giyae Jisasnyét kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gu yaakutaknan du Jon wani képmaana némaan ban kapéredi mu yadénké dérét waatidéka dé wadéka de dérét raamény gaba taknak. Taknadaka kwaadéka Jisas wani muké kudi véknwutakne dé Galilina képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ye déku gayé Nasaret kulaknyénytakne dé Kapaneamét yék. Wani gayé Galilina kwawu nak maaléba dé ték. Wani gayé Sebiulan bét Naptalaina taaléba dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas wani gayét ye Gotna kudi wakwedéka déknyényba rate Gotna yéba kudi wakwen du déku yé Aisaia déku kudi adél dé yak. Aisaia déknyényba kéni kudi Gotna nyégaba dé kavik: ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebiulanna taalé Naptalaina taalé wawo bét kusnyét yédakwa yaabuba bét tu. Jodan kaabélé nak saknwuba bét tu. Galilina képmaaba wupmalemu nak geba yaan du taakwa de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Waba rakwa du taakwa Setenna taababa rate gaankétéba de ro. Rate yalakgé yate de apakélé téwayé yaankwa pulak yaandu véké de yo. Véte miték sanévéknwudaran de nyaakaba raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas wani taalat ye saabe dé batnyé Gotna kudi wakwek. Wakwete dé wak, “Got némaan ban rate gunéké véran tulé kéni dé yao. Yaadékwaké sanévéknwute guné guna kapéredi mawulé kulaknyényké guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Galilina kwawu nak maaléba yéte dé vék Saimon, déku nak yé Pita, déku wayékna Andru wale bétku jébaa yabétka. Bét akwi nyaa yabérén pulak wani kwawuba bét laaké tawuk gukwamiké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Vétakne dé bérét wak, “Béné mé yaa wuné wale. Yaabénu wuné bénat nak jébaaké yakwatnyéké wuné yo. Yakwatnyéwuru béné gukwami kutbénén pulak du taakwat kéraaké béné yo. Kéraabénu de wuna kudi véknwuké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Naate wadéka bari laaké kulaknyénytakne raapme bét dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","De walkamu ye dé Jisas vék Sebedina nyaan vétik Jems bét déku wayékna Jonét. Bétku yaapa Sebedi wale de botba rak. Rate laaké miték yadaka dé Jisas bérét wak, dé wale yébéruké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wadéka bét bétku yaapa botba radéka kulaknyénytakne bét Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas yeyé yeyate dé Galiliba tékwa akwi gayét yék. Ye saabe dé Gotna kudi buldakwa gaba rate du taakwat dé yakwatnyék, Gotna jébaaké. Akwi du taakwat dé kudi wakwek, Got némaan ban rate déku du taakwaké miték védéranké. Kiyakiya yakwa du taakwa, sépékwaapa kapére yan du taakwat wawo dé kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Waga yadéka de Siriana akwi képmaaba déké kudi wakwekéreyék. Wakwekéreyédaka de wani kudi véknwute wupmalemu du taakwat déké kure yék. Kiyakiya yakwa du taakwa baadi, sépékwaapa kapére yan du taakwa baadi, kutakwa kure tén du taakwa baadi, ménigan yadéka akéréte sépélak génkwa du taakwa baadi, maan kapére yadéka yémarék yakwa du taakwa baadi, wani du taakwa baadit de kure yék Jisaské. Kure yédaka dé derét kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kutnébuldéka wupmalemu du béré taakwa béré de dé wale yék. Galiliba yaan du taakwa, Dekapolisba yaan du taakwa, Jerusalemba yaan du taakwa, Judiaba yaan du taakwa, Jodan kaabélé aniké saknwuba yaan du taakwa, waga de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wupmalemu du béré taakwa béré yaadaka Jisas véte dé nébat nak waarék. Waare radéka déku du de déké yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yaadaka dé derét Gotna jébaaké batnyé yakwatnyék. Yakwatnyéte dé kéga wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Du taakwa las deku apaké sanévéknwumarék yate Gotna apaké sanévéknwute de déku jébaa yo. Wani du taakwa Gotna kémba radaka dé némaan ban rate deké dé miték vu. Védékwaké yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Du taakwa las de gérao. Wani du taakwana mawulat Got kutkalé yaké dé yo. Yadéranké yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Du taakwa las deku yéba kevérékmarék yate nak du taakwat waatimarék yate miték de ro. Wani du taakwat Got kutkalé yadu de kéni képmaaba némaan du taakwa rasaakuké de yo. Rasaakudaranké yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Du taakwa las Gotké sanévéknwute yéknwun mawulé yate yéknwun mu male yaké de mawulat kapére yo. Kadémuké kiyaakwa du kadému kaké mawulat kapére yadakwa pulak, de yéknwun mu male yaké de mawulat kapére yo. Wani du taakwat Got miték yadu deku mawulé miték tédu de miték male rasaakuké de yo. Rasaakudaranké yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Du taakwa las de nak du taakwaké mawulé léknu. Wani du taakwaké Got mawulé lékgé dé yo. Lékdékwaké yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Du taakwa las deku mawuléba yéknwun mawulé male dé tu. Wani du taakwa Gorét véte dé wale miték rasaakuké de yo. Rasaakudaranké sanévéknwute yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Du taakwa las nak du taakwa waaru waariyadaka de nyédéba de tu. Tédaka de kaapuk waaru waariyadakwa. Wani nyédéba tékwa du taakwaké Got waké dé yo, ‘De wuna baadi.’ Naate wadéranké sanévéknwute wani nyédéba tékwa du taakwa yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Du taakwa las Gotna jébaa yadaka nak du taakwa kélik yate derét de yaalébaanu. Yaalébaandakwa du taakwa Gotna kémba radaka Got némaan ban rate deké dé miték vu. Védékwaké sanévéknwute yéknwun mawulé de mé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mé véknwu. Guné wuna jébaaba gunébu yaalak. Du las wunéké kélik yate gunat wasélékte kapéredi mu gunat yate gunéké yénaa kudi wakwedaran guné yéknwun mawulé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Déknyényba de Gotna yéba kudi wakwekwa duwat waga de yaalébaanék. Derét waga yaalébaandanké sanévéknwute de gunat waga yaalébaando guné yéknwun mawulé yaké guné yo. Kukba Got gunat kutkalé yadu guné dé wale miték male rasaakuké guné yo. Rasaakugunéranké guné yéknwun mawulé yate dusék yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wani kudi watakne dé Jisas kéga wakwek: “Kéni aja kudi mé véknwu. Taakwa de sol takno, kadému lisék yaduké. Sol lisék yamarék yadéran yaga pulak yado lisék tépa yaké dé yo? Kaapuk. Lisék tépa yamarék yaké dé yo. Yadu kadémuba taknamarék yaké de yo. De wani sol bakna yatjadaké de yo. Bulaa wani kudiké mé sanévéknwu. Guné, wuna du, guné kadémuba taknadakwa sol pulak. Guné nak du taakwat kutkalé yagunu de kapéredi mu tépa yamarék yaké de yo. Guné nak du taakwat kutkalé yamarék yagunéran lisék yamarék yakwa sol bakna yatjadatakne kulaknyénydakwa pulak, Got gunat kulaknyényké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Guné, wuna du, guné yaankwa téwayé pulak guné ro. Ragunéka nak du taakwa gunat de vu. Guné nébuba tékwa gayé pulak guné ro. Ragunéka nak du taakwa gunat de miték vu, nébuba tékwa gayét miték védakwa pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Kéni aja kudi mé véknwu. Du téwayé sérakne kure yae sapgutaknadan awu gwaléba de takno, kapu kaapuk? Kaapuk. De jaabé takuba de takno. Taknadaka waba rakwa akwi du taakwa de miték vu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bulaa wani kudiké mé sanévéknwu. Guné wani téwayé pulak guné ro. Guné Gotké yéknwun jébaa yaké guné yo. Wani jébaa paakumarék yaké guné yo. Du taakwana méniba yaké guné yo. Yagunu de miték véké de yo. Véte awuréba rakwa ban guna yaapa Gotna yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Guné kéga wamarék yaké guné yo, ‘Moses wakwen apa kudiké kuk kwayéké nae Jisas dé yaak. Déknyényba rate Gotna yéba kudi wakwen du deku kudiké kuk kwayéké nae Jisas dé yaak.’ Waga wamarék yaké guné yo. Moses wakwen apa kudi Gotna yéba kudi wakwen duna kudi wawo miték véknwute wadan pulak yaké wuné yaak. Guné wani kudiké miték kutdénggunuké wuné yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kéni kudi mé véknwu. Nyét képmaa wekna tédu Moses wakwen akwi apa kudi rasaakuké dé yo. Radu guné wani kudi véknwute wadékwa pulak yaké guné yo. Kukba nyét képmaa kaapuk yaké dé yo. Yadu Moses wakwen apa kudi wawo kaapuk yaké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Du las Moses wakwen apa kudiké nak kéga wadaran, ‘Wani apa kudi wan makwal kudi male. Naané wani kudi kulaknyénynaran wan yéknwun.’ Waga wadaran Got némaan ban rate deké waké dé yo, ‘Wan bakna du. De wuna taababa bakna de ro. Deku yéba kevérékmarék yaké wuné yo.’ Naate wadu de nak du wani apa kudi véknwute wadékwa pulak yate kéga wakwedaran, ‘Wani apa kudi akwi miték véknwuké naané yo. Nak kudi kulaknyénymarék yaké naané yo.’ Naate wadaran Got némaan ban rate deké waké dé yo, ‘Wan némaan du. De wuna taababa miték de ro. Deku yéba kevérékgé wuné yo.’ Naate waké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Guné Moses wakwen apa kudiké miték kutdénggunuké wuné gunat wakweyo. Apa kudiké kutdéngkwa du, Parisina du wawo, de Moses wakwen apa kudi akwi miték véknwute wadékwa pulak yaké de apa jébaa yo. Yadaka nak du derét véte de wo, ‘De yéknwun mu yakwa du de ro.’ Naate wadaka Got deku mawulé kutdéngte dé deké wo, ‘Wan kaapuk.’ Naate wadéka gunat wuné wo. Guné yéknwun mawulé yate yéknwun mu yaké guné yo. Yagunu guna yéknwun paaté deku paatat talaknadéran guné Gotna kémba yaalaké guné yo. Guna yéknwun paaté deku paatat talaknamarék yadéran guné Gotna kémba yaalamarék yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wani kudi watakne dé derét kéga wakwek: “Déknyényba ran du kéni kudi wakwedaka gunébu véknwuk. Kéga de wak, ‘Guné du taakwat viyaapérekmarék yaké guné yo. Guné derét viyaapérekgunéran de gunat kot véknwukwa némaan banké kure yédo dé wani kapéredi muké gunat yakataké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naate wadaka bulaa wuné nak kudi gunat wakweyo. Mé véknwu. Du las nak dut rékaréka yadaran Got wani kapéredi muké derét yakataké dé yo. Du las nak dut waatite kéga wadaran, ‘Guné waagété du.’ Naate wadaran Got kot véknwukwa némaan ban rate wani kapéredi muké waga wakwa dut némaanba yakataké dé yo. Du las nak dut némaanba waatite kéga wadaran, ‘Guné bakna gweba du. Kapéredi taalat yéké guné yo.’ Naate wadaran Got wadu waga wakwa du yaa yaansaakukwa taalat yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Wani muké sanévéknwute guné nak nak kéga yaké guné yo. Guné Gotké gwalmu kwayéké yate, déké gwalmu kwayédakwa jaabé tékwaba téte, nak du taakwat yagunén kapéredi muké sanévéknwugunéran, taale guné Gotké kwayégunéran gwalmu jaabéna saknwuba takne, wani du taakwaké bari yéké guné yo. Ye guné de wale kudi bulte de wale nakurak mawulé yate de wale miték raké guné yo. Re kukba gwaamale yae taknagunén gwalmu Gotké kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Du las gunat kotké yadaran guné de wale yaabuba yéte de wale kudi bulte de wale kudi giké guné yo. Guné nakurak mawulé yaké guné yo. Guné de wale wani kudi gimarék yagunéran sal de gunat kot véknwukwa némaan banké kure yédo dé wadu de gunat raamény gaba taknaké de yo? Taknado guné waba kwaasaakuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kot véknwukwa némaan ban wadén akwi yéwaa gunat waatin duké kwayégunu, wani tulé male raamény ga kulaknyénytakne yaale miték yéké guné yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Déknyényba ran du kéni kudi wakwedaka gunébu véknwuk. Kéga de wak, ‘Guné nak duna taakwa wale kapéredi mu yamarék yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naate wadaka bulaa wuné gunat kéga wakweyo. Du nak duna taakwat véte lérét kéraaké géndéran déku mawuléba dé lé wale kwao. Yadéka déku mawulé sépélak dé tu. Dé waga lérét véte lérét kéraaké génte dé kapéredi mu yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Guné guna yéknwun tuwa saknwuba tékwa méni nak duna taakwat véte, de wale kapéredi mu yaké mawulé yagunéran, wani méni pékwe yatjadaké guné yo. Guna nakurak méni male tédu wani kapéredi mu yamarék yate kukba Gotna gayét yégunéran wan yéknwun. Guna méni vétik tédu guné wani kapéredi mu yagunu Got wadu guné kapéredi taalat yégunéran wan kapéredi. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Guna yéknwun tuwa taabat kapéredi mu yaké yagunéran guné wani taaba tépakne yatjadaké guné yo. Guna nakurak taaba male tédu wani kapéredi mu yamarék yate kukba Gotna gayét yégunéran wan yéknwun. Guna taaba vétik tédu guné wani kapéredi mu yatakne kukba guné kapéredi taalat yégunéran wan kapéredi. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Déknyényba ran du kéni kudi wawo wakwedaka gunébu véknwuk. Kéga de wak, ‘Du nak déku taakwa dérét kulaknyénytakne yéluké mawulé yadéran dé wani muké nyéga kaviké dé yo. Kaviye léké kwayédu lé wani nyéga kure yéké lé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naate wadaka bulaa wuné gunat kéga wakweyo. Taakwa nak duké yémarék yate nak du wale kapéredi mu yamarék yalu, léku du lé dérét kulaknyénytakne yéluké wadéran wan kapéredi mu. Lé dérét kulaknyénytakne yéluké wadu lé ye nak du wale raléran lé wani du wale kapéredi mu bét yo. Taale ralén du kapéredi mu yadék bét wawo kapéredi mu bét yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wani kudi watakne dé Jisas kéga wakwek: “Déknyényba ran du kéni kudi wawo wakwedaka gunébu véknwuk. Kéga de wak, ‘Guné jébaa nak yaké wate guna kudit apa yate Némaan Ban Gotna yéba wakwegunéran guné wani jébaa yaké guné yo. Wani jébaa kulaknyénymarék yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naate wadaka bulaa wuné gunat kéga wakweyo. Guné guna kudit apa yaké wamarék yaké guné yo. Wani jébaa bakna yaké guné yo. Guné Gotna gayéna yéba wamarék yaké guné yo, Got rakwa taalé bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Képmaana yéba wamarék yaké guné yo, Got képmaaba déku maan akidékwa bege. Guné Jerusalemna yéba wamarék yaké guné yo, naana Némaan Ban Gotna taalé bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Guné guna maaknaba wamarék yaké guné yo, guné gélé nébé waama yadu waama nébé gélé yaduké yaké yapatigunékwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De gunat jébaaké waatado guné kusékétgunéran guné kéga waké guné yo, ‘Ao, wani jébaa yaké naanék.’ Waga yamuké kélik yate guné kéga waké guné yo, ‘Kaapuk. Wani jébaa yamarék yaké naané yo.’ Naate waké guné yo. Wan yaak. Nak kudi wamarék yaké guné yo. Guna kudit apa yaké deku yéba wamarék yaké guné yo. Guna kudit apa yaké deku yéba wagunéran guné Setenna kudi véknwute wadékwa pulak yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Déknyényba ran du kéni kudi wakwedaka gunébu véknwuk. Kéga de wak, ‘Du vétik waariyate du nak duna méni takupékudu dé yakataké yate takupékun dut déku méni takupékuké dé yo. Du vétik waariyate du nak duna nébi nak takugwapdu dé yakataké yate wani dut déku nébi nak takugwapké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naate wadaka bulaa wuné gunat kéga wakweyo. Du las gunat kapéredi mu yadaran guné derét kapéredi mu yakatakaapuk yaké guné yo. Du las guna ménidaamaba yéknwun tuwa saknwuba gunat viyaadaran guné yakatakaapuk yate walaakwe bakna téké guné yo, de guna ménidaamaba aki tuwa saknwuba viyaadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Du las guna baapmu wut kéraaké, gunat kotimdaran kot véknwukwa némaan ban wani muké kusékétdu guné kwayéte baapmu wut nak wawo deké kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Du las guné de wale yéte deku gwalmu walkamu yaabuba kure yégunuké apa yate wadaran guné de wale yéte deku gwalmu séknaa yaabuba kure yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Du las gunat gwalmuké waatado guné wani gwalmu deké kwayéké guné yo. Du las guna gwalmuké mawulé yate gunéké wani gwalmu kukba kaatakweké wado guné wani gwalmu deké kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Déknyényba ran du kéni kudi wakwedaka gunébu véknwuk. Kéga de wak, ‘Guné guna du taakwaké mawulat kapére yate guna maamaké kélik yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naate wadaka bulaa wuné gunat kéga wakweyo. Guné guna maamaké mawulat kapére yaké guné yo. Du las gunat kapéredi mu yadaran guné Gorét waataké guné yo, dé derét kutkalé yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Guné waga yagunéran guné awuréba rakwa ban guna yaapa Got wale nakurak mawulé yaké guné yo. Yate guné déku baadi raké guné yo. Got nakurak jébaa dé yo akwi du taakwaké. Got wadéka dé nyaa vu. Védéka kadému miték dé yaalo, yéknwun mu yakwa du taakwana képmaaba, kapéredi mu yakwa du taakwana képmaaba wawo. Got wadéka dé maas viyao. Viyaadéka kadému miték dé yaalo, yéknwun mu yakwa du taakwana képmaaba, kapéredi mu yakwa du taakwana képmaaba wawo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Takis nyégélkwa du, deké guné wo, ‘Kapéredi mu yakwa du.’ Naate wagunékwa du de deku du taakwaké mawulat kapére yo. Guné de yakwa pulak, guna du taakwaké male mawulat kapére yagunéran, Got gunat kutkalé yamarék yaké dé yo. Gunéké mawulat kapére yakwa du taakwa, gunéké kélik yakwa du taakwa wawo, akwi du taakwaké mawulat kapére yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Gotna kudi véknwumarék yakwa du taakwa de deku du taakwaké male yéknwun mawulé yate de wale de kudi bulu. Guné de yakwa pulak, guna du taakwaké male yéknwun mawulé yate, de wale kudi bulgunéran guné miték yakaapuk yaké guné yo. Akwi du taakwaké yéknwun mawulé yate, de wale kudi bulké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Awuréba rakwa ban guna yaapa dé yéknwun mu male yasaakukwa ban dé ro. Guné dé rakwa pulak yéknwun mu male yasaakukwa du raké guné yo.” Naate dé Jisas wak déku duwat. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas kudi las wawo dé kéga wakwek: “Guné Gotké yéknwun jébaa yate déké male sanévéknwuké guné yo. Guné Gotké yéknwun jébaa yate nak du taakwa de waga yagunu vétakne guna yéba kevérékdoké mawulé yate deku méniba wani jébaa yagunéran guné gunéké guné sanévéknwu. Waga sanévéknwute deku méniba yagunéran awuréba rakwa ban guna yaapa kukba guna yéba kevérékmarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","“Yénaa yakwa du las deku yéba kevérékte de Gotna kudi buldakwa gat wulae téte yaabuba wawo téte de gwalmu yamarék du taakwaké gwalmu kwayu. Wupmalemu du taakwa véte wani yénaa yakwa duna yéba kevérékdoké, de yénaa yakwa du gwalmu yamarék du taakwaké gwalmu de kwayu. Waga kwayédaka wupmalemu du taakwa véte wani yénaa yakwa duna yéba de kevéréknu. Kukba Got wani yénaa yakwa duna yéba kevérékmarék yaké dé yo, wupmalemu du taakwa deku yéba bulaa kevérékdakwa bege. Adél wuné gunat wakweyo. Guné yénaa yakwa du kwayédakwa pulak kwayémarék yaké guné yo. Guné gwalmu yamarék du taakwaké gwalmu kwayéké yagunéran nak du taakwat wani muké wakwemarék yaké guné yo. Akélak kwayéké guné yo. Waga kwayégunu nak du taakwa wani muké kutdéngmarék yado guné wale rakwa du taakwa wawo wani muké kutdéngmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Guné waga akélak kwayégunu awuréba rakwa ban guna yaapa véké dé yo. Vétakne kukba dé yagunén yéknwun mu kaataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yénaa yakwa du Gorét waataké, de Gotna kudi buldakwa gat wulae téte yaabuba wawo téte de Gorét waato. Wupmalemu du taakwa derét védoké de waba Gorét waato. Wupmalemu du taakwa derét véte deku yéba kevérékdoké de waba Gorét waato. Waga yadaka wupmalemu du taakwa deku yéba de kevéréknu. Waga yate yadan yéknwun mu de kaato. Yénaa yakwa du wani du taakwat yéknwun mu debu nyégélék. Kukba Got yadan yéknwun mu kaatamarék yaké dé yo. Adél wuné gunat wakweyo. Guné yénaa yakwa du Gorét waatadakwa pulak Gorét waatamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Guné Got wale kudi bulké yate guné nak nak guna gat wulae gwés miték tépétakne kapmu rate dé wale kudi bulké guné yo. Bulgunu guna yaapa Got guné waga rate bulgunu véte guna kudi véknwuké dé yo. Dérét kaapuk vénakwa. Dé guna kudi véknwute kukba dé yagunén yéknwun mu kaataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Gotké kutdéngmarék yakwa du taakwa de wo, Naané wupmalemu kudi bulte naana némaan duwat waatanaran de véknwuké de yo. Naate wate wupmalemu yaamabi kudi de bakna bulte waato. Guné wupmalemu yaamabi kudi buldakwa pulak guné Got wale bulmarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Guné dérét waatamarék yagunén tulé guna yaapa Got débu kutdéngék, yapatigunékwa muké. Kutdéngdénké sanévéknwute guné dé wale kudi bulte guné wupmalemu yaamabi kudi bulmarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Guné dérét kéga waataké guné yo: Naana yaapa, méné ména gayéba méné ro. Naané ména yéba kevérékgé naané mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Méné némaan ban rate akwi du taakwaké miték véménuké naané mawulé yo. Ména gayéba rakwa du ména kudi miték véknwudakwa pulak, naané kéni képmaaba rakwa du taakwa wawo ména kudi miték véknwuké naané mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kéni nyaa yapatinakwa kadému tiyaaménuké naané ménat waato. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Du taakwa naanat kapéredi mu yadaka naané wani muké tépa kaapuk sanévéknwunakwa. Yano méné yanan kapéredi mu yatnyéputiye méné wani muké tépa sanévéknwumarék yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Méné naanat kutkalé yaménu naané kapéredi mu yakwa banna kudi véknwumarék yate kapéredi mu tépa yamarék yaké naané yo. Waga ménat naané waato. Méné naané akwi du taakwaké miték vésaakute apa yasaakute némaan ban rasaakuké méné yo apuba apuba. Adél. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Guné wani kudiké mé sanévéknwu. Guné nak du taakwa gunat yadan kapéredi muké sanévéknwumarék yagunéran awuréba rakwa ban guna yaapa Got yagunén kapéredi mu yatnyéputiye wani muké tépa sanévéknwumarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Guné nak du taakwa gunat yadan kapéredi muké wekna sanévéknwute derét yakataké mawulé yagunéran guna yaapa Got yagunén kapéredi muké wekna sanévéknwute wani kapéredi mu yatnyéputimarék yate gunat yakataké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wani kudi watakne dé derét tépa wakwek: “Yénaa yakwa du Got wale kudi bulké, de nak apu nak apu kadémuké yaakéru. Yaakétte nak du taakwa kadémuké yaakétdanké kutdéngdoké de deku ménidaamaba waama képmaa lépmu. Lépdaka deku ménidaama waama dé yo. Yadéka nak du taakwa véte de wo, ‘Wani du Gotké sanévéknwute de kaadéké kiyao. Wan yéknwun mu yakwa du de.’ Naate wate deku yéba de kevéréknu. Waga yate yadan yéknwun mu de kaato. Yénaa yakwa du wani du taakwat yéknwun mu debu nyégélék. Kukba Got yadan yéknwun mu kaatamarék yaké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Guné de yakwa pulak yamarék yaké guné yo. Guné Got wale kudi bulké yate, kadémuké yaakétte guna ménidaama yakutnyéké guné yo. Ye nébé viyaaké guné yo, akwi nyaa yagunékwa pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Guné waga yagunéran nak du taakwa gunat véte kutdéngmarék yaké de yo, guné Got wale kudi bulké yate kadémuké yaakétgunénké. De wani muké kutdéngmarék yadoké guné guna ménidaama yakutnyéké guné yo. Waga yagunéran guna yaapa Got male wani muké kutdéngké dé yo. Dérét naané kaapuk vénakwa. Guné kadémuké yaakétte dé wale kudi bulte kapmu ragunu dé véte kukba yagunén yéknwun mu gunat kaataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Guné apuba apuba némaa muké guné sanévéknwu wanévéknwu. Yate wani muké guné mawulé yo. Mé véknwu. Guné waga yate guné kéni képmaana wupmalemu gwalmu kéraaké sanévéknwumarék yaké guné yo. Kéni képmaana gwalmu wan némaa mu kaapuk. Biyaak wani mu de kérépaknu. Résépu wani mu dé yaalébaanu. Sél yakwa du nak duna ga pérae wulae wani mu de sél yo. Wani mu rasaakumarék yadéranké sanévéknwute guné Gotna gayéba miték rasaakugunéranké sanévéknwuké guné yo. Sanévéknwute guné yéknwun mu male yaké guné yo. Gotna gayéba rate yagunéran mu wan némaa mu. Wani mu wan kéni képmaana gwalmu pulak kaapuk. Gotna gayéba rate yagunéran mu rasaakuké dé yo. Biyaak wani mu kérépakmarék yaké de yo. Résépu wani mu yaalébaanmarék yaké dé yo. Sél yakwa du wani gayét wulaamarék yate wani mu sél yamarék yaké de yo. Kéni képmaaba gwalmu jawutaknakwa du taakwa de kéni képmaana muké male de mawulat kapére yo. Gotna gayéba raké sanévéknwukwa du taakwa de dé wale miték rasaakuké de mawulat kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Guna méni wan gaba tékwa gwés pulak. Wani gwés naapidaka gaba nyaaka dé yo. Guné yéknwun mu male végunéran guna mawulé miték téké dé yo. Yadu guna sépé miték tédu guné nyaakaba raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Guné kapéredi mu male végunéran guna mawulé miték témarék yaké dé yo. Guna mawulé miték témarék yadéran, guna sépé miték témarék yadu, guné gaankétéba raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Du nak némaan du vétikgé jébaa yaké dé yapatiyu. Waga jébaa yadéran dé nak némaan duké yéknwun mawulé yate nakgé kélik yaké dé yo. Guné wani du pulak guné ro. Guné némaan ban Gotké jébaa yate déké male sanévéknwugunéran guné déké apuba apuba yéknwun mawulé yaké guné yo. Yate guné yéwaa kéraaké sanévéknwumarék yaké guné yo. Guné yéwaa kéraaké male apuba apuba sanévéknwugunéran guné némaan ban Gotké kélik yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wani kudi wakwetakne dé Jisas derét tépa wakwek: “Nakurak némaan banké jébaa yagunéranké sanévéknwute wuné gunat wakweyo. Guné wup yate kadému gu baapmu wutké wawo sanévéknwu wanévéknwumarék yaké guné yo. Kadému, gu, baapmu wut wan bakna mu. Némaa mu kaapuk. Guné wani muké sanévéknwu wanévéknwumarék yaké guné yo. Got wadék guné ro. Guna sépé guna mawulé guna wuraanyan yadék guné ro. Wan némaa mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Guné apit mé vé. De kadému kaapuk yaanandakwa. De kaapuk kadému kéraate kaadi gaba taknadakwa. Yadaka awuréba rakwa ban guna yaapa dé deké kadému kwayu. Api wan makwal. Guné du taakwa guné némaan. Got waga apiké kadému kwayédu guné kutdéngké guné yo. Gunéké wawo kadému kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mé véknwu. Guna du nak wupmalemu kwaaré las wawo raké sanévéknwu wanévéknwudéran dé watakne wupmalemu kwaaré las wawo raké apa yaké dé yo, kapu kaapuk? Wan kaapuk. Déku kapmu watakne wupmalemu kwaaré las wawo raké yapatiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Samuké guné baapmu wutké guné sanévéknwu wanévéknwu? Waga yamarék yaké guné yo. Guné maaweké mé sanévéknwu. Naané wani maawe kaapuk yaanannakwa. De bakna de yaalo. De jébaa kaapuk yadakwa. De baapmu wut kaapuk kétaapadakwa. Yadaka Got dé deké miték vu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Deké dé yéknwun nyaap dé kwayu. Déknyényba wupmalemu gwalmu yan némaan ban nak déku yé Solomon yéknwun baapmu wut dé kusok. Yate wani maawe pulak kusokwa yéknwun mu kaapuk kusodén. Maawe kusokwa yéknwun mu Solomon kuson yéknwun mat débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Got wani maaweké dé miték vu. Wani maawe walkamu male téké de yo. Bulaa de tu. Séré kiyaaké de yo. Kiyaado du taakwa wani maawe péle yaa tuké de yo. Wani maawe wan makwal mu male. Guné du taakwa guné némaan. Guné Gotké kaapuk miték sanévéknwugunékwa. Yate wup yate guné wo, ‘Naanéké miték véké dé yo, kapu kaapuk?’ Naate wagunéka bulaa wuné gunat wo. Got maawe waga kusodu véte guné kutdéngké guné yo. Gunéké baapmu wut kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Waga kutdéngte guné wup yamarék yate kéga wamarék yaké guné yo, ‘Samu mu kaké naané yo? Samu gu kaké naané yo? Samu baapmu wut kusadaké naané yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Waga wamarék yaké guné yo, awuréba rakwa ban guna yaapa guné wani muké yapatigunékwaké kutdéngdén bege. Gotna kudi véknwumarék yakwa du taakwa de wani muké de sanévéknwu wanévéknwu. Guné de yakwa pulak wani muké sanévéknwu wanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yate guné Gotna kémba yaale déku kudi miték véknwute wadékwa pulak yate déku jébaa yaké mawulat kapére yaké guné yo. Waga yagunéran dé gunéké wani mu kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwayédéranké sanévéknwute guné séré yaaran muké wup yamarék yaké guné yo. Séré yaaran muké sanévéknwu wanévéknwumarék yaké guné yo. Bulaa yaaran muké male sanévéknwuké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wani kudi watakne dé Jisas tépa wakwek: “Nak du taakwa yadan muké sanévéknwute guné bari kéga wamarék yaké guné yo, ‘Wani du taakwa wan kapéredi mu yakwa du taakwa.’ Waga wamarék yaké guné yo. Guné waga wagunéran Got yagunén mu véte gunat waké dé yo, ‘Guné kapéredi mu yakwa du.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Naate wadéranké sanévéknwute, guné deké ‘Wan kapéredi mawulé yakwa du taakwa’ bari wamarék yaké guné yo. Got nak du taakwat yagunén mu véte gunat kaataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nak du taakwa yan makwal kapéredi mu wan méniba kwaakwa mukut pulak. Yagunén némaa kapéredi mu wan méniba kwaakwa apakélé baagé pulak. Samuké guné nak du taakwana méniba kwaakwa mukut véte guné guna méniba kwaakwa apakélé baagé kaapuk végunékwa? Guné waga yate guné nak du taakwa yan makwal kapéredi muké wakwete guné yagunén némaa kapéredi muké kaapuk sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Guné némaa kapéredi mu yatakne samuké guné makwal kapéredi mu yan du taakwat guné kéga wo? ‘Guné kapéredi mu gunébu yak. Guné miték ragunuké wuné gunat kutkalé yaké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Waga wamarék yaké guné yo. Guné waga wagunéran guné yénaa yakwa du guné ro. Taale guné yagunén némaa kapéredi muké kuk kwayéké guné yo. Kwayétakne guné makwal kapéredi mu yan du taakwat kutkalé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Guné Gotna kudiké kélik yakwa du taakwat Gotna kudi wakwemarék yaké guné yo. Guné derét Gotna kudi wakwegunéran de dut tikwa waasa du taakwat yaalébaankwa pulak gunat yaalébaanké de yo. Du taakwa las de Gotna kudiké kuk kwayu. Derét wawo Gotna kudi wakwemarék yaké guné yo. Du kusodakwa mu baaléké kaapuk kwayédakwa. Waga kwayédaran baalé kwatkwa rate wani muba bakna akiké de yo. Gotna kudi wan yéknwun kudi. Guné kusodakwa mu baaléké kwayémarék yakwa du pulak yate, Gotké kuk kwayékwa du taakwat Gotna kudi wakwemarék yaké guné yo. Guné derét déku kudi wakwegunéran sal de baalé akikwa pulak yate kapéredi mu gunat yaké de yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Guné Gorét waatasaakugunéran dé gunéké kwayéké dé yo. Kéni aja kudi mé véknwu. Guné sékalte sékalte véké guné yo. Guné gwésba viyaasaakugunéran gwés naapiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Du taakwa Gorét waatadaran dé deké akwi kwayéké dé yo. Du taakwa sékalte sékalte de akwi véké de yo. Du taakwa gwésba viyaadaran gwés naapiké dé yo. Guné wani aja kudi véknwute guné Gorét waatasaakuké guné yo. Waatagunu dé guna kudi véknwuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kéni kudi wawo mé véknwu. Guné yaapa, guna baadi kadému kwayégunuké wado, guné matu kwayéké guné yo, kapu kaapuk? Kaapuk. Guné deké kadému kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","De gukwami kwayégunuké wado guné kaabe kérae kwayéké guné yo, kapu yaga pulak? Wan kaapuk. Guné deké gukwami kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bulaa wani kudiké mé sanévéknwu. Guné kapéredi mawulé yakwa du rate guné guna baadiké yéknwun mu guné kwayu. Awuréba rakwa ban guna yaapa yéknwun mawulé yakwa du rate gunat talakne némaa yéknwun mu kwayéké dé yo, dérét waatakwa du taakwaké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Guné nak du taakwa gunat kutkalé yadoké mawulé yagunékwa pulak, guné derét kutkalé yaké guné yo. Moses wakwen apa kudi Gotna yéba wakwen duna kudi wawo guné waga yagunéranké dé wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Kapéredi taalat yédakwa yaabu wan némaa yaabu. Wan dawulidakwa yaabu. Wani yaabuba némaa gwéspété dé tu. Du taakwa wani némaa gwéspétéba wulaaké apa jébaa yamarék yaké de yo. Wupmalemu du taakwa wani némaa gwéspétéba wulae de wani yaabuba yu. De yalakgé de yo. Got wale rasaakumarék yaké de yo. Guné wani yaabuba yémarék yaké guné yo. Gotna gayét yédakwa yaabu wan makwal yaabu. Wan waarédakwa yaabu. Wani yaabuba makwal gwéspété dé tu. Walkamu du taakwa male wani makwal gwéspétéba wulae wani makwal yaabuba de yu. De Got wale rasaakuké de yo apuba apuba. Guné wani makwal yaabuba yéké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Wani kudi watakne dé kéga wakwek: “Guné jérawu yaké guné yo. Du las gunéké yae yénaa yate kéga waké de yo, ‘Naané Gotna yéba naané kudi wakweyo.’ Naate wate kés kudi nak kudi wakwete guna mawulat yaalébaando, nak du taakwa kwatkwa rate deké waké de yo, ‘Wan yéknwun mu yakwa du. Sipsip miték radakwa pulak de miték ro. Deku kudi véknwuké naané yo.’ Naate watakne de kutdéngmarék yaké de yo. Kwatbosa kapéredi mawulé yadakwa pulak de kapéredi mawulé de yo. Waga kutdéngmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Guné deku jébaa miték véké guné yo. Vétakne deku mawuléké kutdéngké guné yo. Képmaaba tékwa kéni muké mé sanévéknwu. Raamény baagwiba misék kaapuk akukwa. Kapéredi waaraba yéknwun sék kaapuk akukwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Apa yakwa yéknwun miba yéknwun sék dé aku. Apa yamarék yakwa kapéredi miba kapéredi sék dé aku. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Apa yakwa yéknwun miba kapéredi sék kaapuk akukwa. Apa yamarék yakwa kapéredi miba yéknwun sék kaapuk akukwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yéknwun sék akumarék yakwa mi véle de yaaba tu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Guné wani muké sanévéknwute miséknét véte kutdéngké guné yo. Nak mi wan yéknwun mi. Nak mi wan kapéredi mi. Bulaa wani duké mé sanévéknwu. Guné deku kapéredi jébaa véte kutdéngké guné yo. Wan kapéredi mu yate yénaa yakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wupmalemu du taakwa yénaa yate de wunat wo, ‘Méné naana Némaan Ban.’ Naate wate bakna yaamabi kudi bulte de awuréba rakwa ban wuna yaapa Got déku kudi kaapuk véknwudakwa. Wani du taakwa de Gotna kémba yaalamarék yaké de yo. Gotna kudi véknwute wadékwa pulak yakwa du taakwa male de Gotna kémba yaalaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wuné apakélé kot véknwukwa némaan ban raran nyaa wupmalemu du taakwa wunat kéga waké de yo, ‘Naana Némaan Ban, ména yéba naané Gotna kudi wakwek. Ména yéba wanaka de kutakwa yaage yék. Ména yéba wate naané wupmalemu déknyényba vémarék yadan apa jébaa yak. Naané ména du taakwa naané ro.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naate wado wuné derét waké wuné yo: Wan kaapuk. Yénaa guné yo. Wuné gunat las kaapuk kutdéngwurén. Guné wuné wale nakurak mawulé kaapuk yagunén. Guné kapéredi mawulé yakwa du taakwa. Guné mé yaage yé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Kéni aja kudi mé véknwu. Yéknwun mawulé pukaakwa du nak dé matuba ga kaak. Kaadéka kukba apakélé wimut kutdéka apa maas viyaadéka apakélé kwayé kwaléka wani ga miték dé kwaak, matuba kaadén bege. Wani aja kudiké mé sanévéknwu. Wuna kudi véknwute wawurékwa pulak yaran du taakwa de matuba yéknwun ga kaan du pulak de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Kéni aja kudi mé véknwu. Miték sanévéknwumarék yakwa du nak dé yawusaba ga kaak. Kaadéka kukba apakélé wimut kutdéka apakélé maas viyaadéka apakélé kwayé kwaléka wani ga dé akérék. Akérédéka kwayé yae lé wani ga yaate yék. Wani kudiké mé sanévéknwu. Wuna kudi bakna véknwute wawurékwa pulak yamarék yaran du taakwa, de yawusaba ga kaan du pulak de ro.” Naate Jisas dé derét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas waga wakwedéka wupmalemu du taakwa de déku kudiké kwagénék, dé apa yate derét Gotna kudi wakwedén bege. Kwagénte de wak, “Aki. Dé Gotna jébaaké dé miték kutdéngék. Kutdéngte dé naanat yakwatnyu. Apa kudiké kutdéngkwa du de naanat Gotna jébaaké waga kaapuk yakwatnyédakwa.” Naate wate déku kudi véknwute kwagénte de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas nébu kulaknyénytakne dawulidéka de wupmalemu du taakwa déku kukba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yédaka dé lepéro yan du nak déké yae kwati yaane waadé daate dé wak, “Némaan Ban, wuné yéknwun yawuruké méné mawulé yaménéran waménu wuné yéknwun yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Naate wadéka dé déku taababa kutte dé wak, “Wuné yéknwun yaménuké wuné mawulé yo. Méné yéknwun yaké méné yo.” Naate wadéka dé wani lepéro kaapuk yadéka dé wani du yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yadéka dé dérét wak, “Mé véknwu. Ménat yawurén muké nak du taakwat wakwemarék yaké méné yo. Méné Gotna kudi bulnakwa gaba jébaa yakwa nyédé duké ye déku méniba téménu dé ména sépat véké dé yo. Védu méné Moses déknyényba wakwedén pulak Gotké kwaami kwayéké méné yo. Kwayéménu nak du taakwa véte kutdéngké de yo, lepéro kaapuk yadéka méné yéknwun yaménénké.” Naate dé Jisas dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisas Kapaneamét yédéka dé Romna waariyakwa duna némaan du nak yae dé dérét wak, “Némaan Ban, mé véknwu. Wunéké jébaa yakwa duna maan kapére yadéka dé kaapuk yédékwa. Apa kaagél kutte dé gaba male dé kwao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Naate wadéka dé wak, “Wuné yae dérét kutnébulké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naate wadéka dé wak, “Némaan Ban, wan kaapuk. Wuné bakna du wuné ro. Méné némaan ban méné ro. Waga rate méné ye wuna gat wulaamarék yaké méné yo. Méné kéba rate bakna waménu dé wuna du tépa yéknwun yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nak du wunéké dé némaan ban ro. Radéka wuné wadékwa pulak wuné yo. Wuné waariyakwa duna némaan ban wuné ro. Wuné dut nak, ‘Méné yéké méné yo,’ naawuréka dé yu. Nak dut, ‘Méné mé yaa,’ naawuréka dé yao. Wunéké jébaa yakwa dut, ‘Wani jébaa mé ya,’ naawuréka dé wani jébaa yo. Méné yawurékwa pulak yaké méné yo. Méné bakna waménu wuna du tépa yéknwun yaké dé yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas wani kudi véknwute dé sanévéknwu wanévéknwuk. Yate dé déku kukba yaan du taakwat wak, “Kéni du dé wunéké miték male sanévéknwu. Wuné wawuru du taakwa yéknwun yadaranké dé kutdéngék. Guné Isrelna du taakwa las guné walkamu male guné wunéké miték sanévéknwu. Dé Romna du radéka déku yéknwun mawulé guné Isrelna du taakwa guna yéknwun mawulat débu talaknak. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mé véknwu. Isrelna du taakwa las de Gotna gayét wulaaké de yo. De male kaapuk. Gege gayéba yaan wupmalemu du taakwa las wawo déku gayét wulaaké de yo. Wupmalemu nyaa yaalakwaba yaado wupmalemu nyaa dawulikwaba yae de wupmalemu du béré taakwa béré déku gayét wulaaké de yo. Wulae de Gotna kémba rate naana képmawaara Ebrayam, Aisak, Jekop wale, waga rate kadému kaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Isrelna wupmalemu du taakwa Gotna gayét wulaamarék yaké de yo. Wani du taakwaké Got kuk kwayéké dé yo. Kwayéte wadu de kapéredi taalat yéké de yo. Wani taaléba gaankété male ye dé tu. Nyaa kaapuk vékwa. Wani taaléba rakwa du taakwa némaa kaagél kutké de yo. Kutte de yéknwun taaléba raké mawulé yate némaanba géraaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naate watakne dé Romna waariyakwa du deku némaan banét wak, “Ména gayét gwaamale yéké méné yo. Ye saabe wunéké miték sanévéknwute wuna kudiké ‘Adél’ naaménénké méné waménén mu waga véké méné yo.” Naate dé Jisas wak. Waga wadén tulé Romna waariyakwa duké jébaa yakwa du dé tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ye Pitana gat wulae dé vék Pitana naakuma kiyakiya yadéka kwaaléka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Vétakne dé léku taababa kutdéka kiyakiya débu kaapuk yak. Yadéka yéknwun ye lé raapme kadému kawu saakére lé Jisaské kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Garabu yadéka de kutakwa kure tén wupmalemu du taakwa baadit de kure yaak Jisaské. Kure yaadaka dé wadéka de kutakwa yaage yék. Kiyakiya yakwa du taakwa baadi, sépékwaapa kapére yan du taakwa baadit wawo de déké kure yaak. Kure yaadaka dé derét kutnébuldéka de akwi tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas waga yadéka dé Gotna yéba déknyényba kudi wakwen du Aisaia déku kudi adél dé yak. Déku kudi Gotna nyégaba kéga dé kwao: Kiyakiya naanat yadéka dé naanat kutnébulék. Naana kapéredi mu dé kutnébulék. Sépékwaapa kapére yadéka dé apa yate wadéka naané tépa yéknwun yak. Wani kudi Aisaia dé kavik, Jisasna néwaa dérét kéraamarék yalén tulé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wupmalemu du taakwa jawe tédaka Jisas véte dé déku duwat wak, “Botba waare kwawu nak saknwat yéké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Naate wadéka dé apa kudiké kutdéngkwa du nak yae dé dérét wak, “Némaan Ban, méné naanat Gotna jébaaké méné yakwatnyu. Wuné méné wale yeyé yeyaké wuné mawulé yo. Yéménéran akwi taalat wuné wawo yéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Naate wadéka dé Jisas wak, “Miték mé sanévéknwu. Kwatbosa de képmaaba tékwa waaguba de kwao. Api deku kwaatba de kwao. Wuné Akwi Du Taakwana Nyaan kwaawuréran ga nak kaapuk tékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Naate wadéka dé déku du nak dérét wak, “Némaan Ban, méné kusékétménéran taale wuné ye rawuru wuna yaapa kiyaadu wuné déku gaaba ségwi kérae rémké wuné yo. Rémtakne wuné méné wale yeyé yeyaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Naate wadéka dé wak, “Aya. Bulaa wuné wale mé yaa. Wuna kudi véknwumarék yakwa du taakwa de kiyaan du taakwa pulak de ro. Wani du taakwa kiyaan du taakwat rémké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wani kudi wakwetakne Jisas botba waarédéka de déku du wawo waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Waare yédaka némaa wimut kutdéka dé gu raapme waare botba gwaade dé sékérékgé yak. Yadéka Jisas widé dé kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kwaadéka déku du ye de dérét waaséligénék. Waaséligénte de wak, “Némaan Ban, kén naané yalaknu. Méné mé raapme naanat kutkalé ya.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naate wadaka dé derét wak, “Guné samuké guné wup yo? Yate guné wo, ‘Déku apa makwal apa male, kapu yaga pulak?’ Naate wate wunéké guné kaapuk miték sanévéknwugunékwa.” Naate watakne dé raapme wadéka wimut kaapuk yadéka dé gu tépa miték ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tédéka de akwi kwagénte de wak, “Aki. Dé wadéka dé wimut gu déku kudi véknwute wadékwa pulak dé yo. Wan yaga pulak ban dé?” Naate watakne de Jisas wale miték yék botba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas déku du wale botba ye de kwawu nak saknwu saabak. Gadarana képmaa de saabak. Saabadaka bét du vétik du taakwa kiyaadaka rémdan taaléba re bét dérét véké yék. Kutakwa de wani du vétit kure ték. Kure tédaka bét waagété yate nak dut saaki viyaaké mawulé yabétka nak du taakwa kaapuk wani yaabuba yédan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bét ye Jisasnyét véte bét némaanba waate bét wak, “Méné, Gotna nyaan, anat samu yaké méné yo? Anat kaagél tiyaaké nae méné yaak, kapu yaga pulak? Kot véknwukwa némaan ban raménéran tulé wekna kaapuk yaan. Bulaa anat kaagél tiyaamarék yaké méné yo.” Naate bét dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wani taaléba wupmalemu baalé de kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kadaka de wani du vétit kure tén kutakwa de Jisasnyét wak, “Méné naanat kéléké mawulé yaménéran méné waménu naané wani baaléna mawuléba wulaaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naate wadaka dé derét wak, “Guné wanét mé yaage yégunu.” Waga wadéka de wani du vétit kulaknyénytakne ye de wani baaléna mawuléba wulae ték. Tédaka wani baalé némaa tépaaba yaage dawuliye guba akére gu ke de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yadaka de baaléké téségén du yaage ye némaa gayé saabe de wani muké du taakwat kudi wakwek. Wakwete de kutakwa kure tén du vétikgé wawo kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Waga wakwedaka véknwutakne de wani gayéba rakwa du taakwa yaak, Jisasnyét véké. Yae dérét véte de wak, dé deku képmaa kulaknyénytakne yéduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas botba nak waare dé kwawu nak saknwat ye dé déku gayé saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Saabadéka de maan kapére yadéka yeyé yeyamarék yan dut déké yaate yék. Dé jaabéba kwaadéka de déké yaate yék. Yédaka Jisas dé kutdéngék. De deku mawuléba de wak, “Jisas apa yate naana dut kutnébulké dé yo.” Naate wadaka Jisas kutdéngte dé maan kapére yan dut wak, “Wuna du, ména mawulé miték téké dé yo. Yaménén kapéredi mu wunébu yatnyéputik.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naate wadéka de apa kudiké kutdéngkwa du deku kapmu bulte de wak, “Got male dé du yadén kapéredi mu yatnyéputiké dé yo. Wani du dé wak, ‘Wuné yadén kapéredi mu wunébu yatnyéputik.’ Naate wate dé Gorét waséléknu, bakna du bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naate wadaka Jisas deku mawulé kutdéngte dé derét wak, “Samuké guné guna mawuléba wani kapéredi mawulé yo? Waga yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Wuné Akwi Du Taakwana Nyaan kéni képmaaba rate yadan kapéredi mu yatnyéputiké wuné apa yo. Guné wani muké kaapuk kutdénggunén. Yadén kapéredi mu yatnyéputiwurénké wakwete bakna kudi wuné wakwek, kapu némaa kudi wuné wakwek? Dé raapme yéduké wawuréran wan némaa kudi wakweké wuné yo, kapu yaga pulak? Guné wuna apaké miték kutdénggunuké wuné kéni kudi dérét wakweké wuné yo.” Naate watakne dé maan kapére yan dut dé wak, “Méné raapme ména jaabé kérae kure méné ména gat yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naate wadéka dé raapme déku gat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yédéka waba téte vén du taakwa wup yate Gotna yéba de kevéréknék. Kevérékte de Jisaské wak, “Got wani duké apa kwayédéka dé waga yak.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas wani taalé kulaknyénytakne dé yék. Yéte dé vék takis nyégélkwa du nak déku yé Matyu takis nyégéldékwa gaba radéka. Véte dé dérét wak, “Méné wuné wale mé yaa.” Naate wadéka raapme dé Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas déku du wale Matyuna gaba rate kadému kadaka de takis nyégélén wupmalemu du, wupmalemu kapéredi mu yakwa du las wawo waga de yaak. Yae de wale rate de kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Rate kadaka Parisina du las véte de Jisasna duwat wak, “Samuké dé guna némaan ban takis nyégélkwa du, kapéredi mu yakwa du las wawo dé de wale kadému ko?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Waga wadaka Jisas véknwute dé wak, “Yéknwun yakwa du taakwa doktaké kaapuk yédakwa. Sépékwaapa kapére yan du taakwa de doktaké yu. Yédaka dokta dé deku sépé kutnébulu. Wuné du taakwana kapéredi mawulé wuné kutnébulu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gotna nyégaba kéni kudi dé kwao: Got dé wak, ‘Guné wunéké kwaami tuwe tiyaamuké kélik wuné yo. Guné nak du taakwaké mawulé lékte derét kutkalé yagunuké wuné mawulé yo.’ Got waga wadéka déku kudi déku nyégaba dé kwao. Guné ye wani kudiké miték sanévéknwuké guné yo. Kapéredi mawulé yakwa du taakwa wunéké yae wuna kudi véknwudoké wuné giyaak. Yéknwun mawulé yakwa du taakwaké kaapuk sanévéknwurén.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gu yaakutaknan du Jonna du de Jisaské ye dérét wak, “Naané, Parisina du wawo Got wale kudi bulké yate naané wupmalemu nyaa kadémuké yaakéru. Samuké ména du naané yakwa pulak kadémuké yaakétmarék yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Naate wadaka dé Jisas derét aja kudi kéga wak: “Du nak taakwa yaké yadu de kadému sérakne yéknwun mawulé yate kadému kaké de yo, kapu kaapuk? De kaké de yo. Taakwa yaran du de wale radu de yéknwun mawulé yate kaké de yo. Kukba de nak du yae wani dut kure yédo de déku du taakwa déké mawulé lékte kadému kamarék yaké de yo. Wuné wuna du wale wekna rawuréka de yéknwun mawulé yate kadému de ko.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Naate watakne dé derét aja kudi vétik wawo kéga wakwek: “Du taakwa kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba kaapuk takne kétaapadakwa. De kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba takne kétaapadaran kukba gu yakutnyédo kulé baapmu wut makwal pulak yadu jégwaa baapmu wut gétbiyaadu apakélé yaabu téké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Déknyény kwaaré viyae putidan meme sépéba kulé wain gu kaapuk wuknasadadakwa. Waga yadaran wani meme sépé rékaa ye jégwaa ye wukdu gu akwi yékéraké dé yo. Yékéradu wani meme sépé yéknwun yamarék yaké dé yo. Kulé meme sépéba wuknasadadaran kulé gu meme sépé wawo miték téké dé yo.” Waga dé aja kudi wakwek, déknyényba ran du wakwen kudi déku kulé kudi wale vététi miték kwaamarék yadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wani kudi wekna wakwedéka dé Judana némaan du nak yae Jisaské kwati yaane waadé daate dé wak, “Wuna takwanyan bulaa male lébu kiyaak. Méné yae ména taaba lérét kutménu lé tépa nébélké lé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naate wadéka dé raapme déku kukba yédéka de déku du wawo dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Yédaka lé taakwa nak Jisasna kukba yaak. Wupmalemu (12) kwaaré wény yaaladéka lé rak. Lé Jisaské kudi véknwute léku mawuléba lé wak, “Déku baapmu wutba taaba kutwuréran wuné tépa yéknwun yaké wuné yo.” Naate watakne lé yae lé déku baapmu wutna waabuba kurék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kutléka Jisas walaakwe lérét véte dé wak, “Nyéné, yéknwun mawulé yaké nyéné yo. Nyéné nyénat kutnébulwuréran apaké sanévéknwute bulaa yéknwun nyénébu yak.” Naate wadéka lé wani taakwa bari yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisas waga watakne dé némaan duna gat yék. Ye dé vék du las kiyaan takwanyanké mawulé lékte kaany yapévudaka wupmalemu du taakwa némaanba géraadaka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Véte kaapaba téte dé wak, “Wani takwanyan kaapuk kiyaalén. Lé bakna widé lé kwao. Guné akwi mé yaale yékéra.” Naate wadéka de dérét waagik. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Waagidaka dé wadéka de akwi du taakwa yédaka dé wani takwanyan kwaan taalat wulaak. Wulae dé léku taababa kutdéka lé raapmék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Raapléka de wupmalemu du taakwa gege gayét yéte wani muké de kudi wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas wani taalé kulaknyénytakne yédéka bét méni kiyaan du vétik Jisasna kukba yék. Yéte némaanba waate bét wak, “Ménawa, Devitna képmawaara. Méné némaan ban Devit pulak rate anéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Waga wabétka dé Jisas gat wulaak. Wulaadéka bét déké yék. Yaabétka dé bérét kéga waatak, “Yaga béné wo wunéké? Wuné béna méni kutnébulké wuné apa yo, kapu kaapuk?” Naate waatadéka bét wak, “Ao. Némaan Ban, méné waga yaké méné apa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naate wabétka dé déku taaba bétku méniba kutte dé wak, “Bénat kutnébulwuréran apaké miték sanévéknwubénénké béna méni tépa yéknwun yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naate wadéka bétku méni dé tépa yéknwun yak. Yadéka dé Jisas bérét némaanba wak, “Béné wani muké nak dut wakwemarék yaké béné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Naate wadéka bét déku kudi véknwumarék yate ye akwi gayéba bét wani muké kudi wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wani du vétik yébétka de Jisaské dut nak kure yék. Wani du kutakwa déku mawuléba wulae téléka dé kudi kaapuk buldén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","De wani dut Jisaské kure yédaka dé Jisas wadéka wani kutakwa yaage yéléka dé wani du kudi bulék. Buldéka de waba tén du béré taakwa béré sanévéknwu wanévéknwute de wak, “Aki. Wan yéknwun mu. Déknyényba waga pulak mu kaapuk Isrelba yadaka vénan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Waga wadaka de Parisina du nak pulak mawulé yate de wak, “Wan yéknwun mu kaapuk. Kutakwana némaan ban Seten dé déké apa kwayédéka dé wadéka de akwi kutakwa yaage yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas dé akwi gayéba yeyé yeyak. Yeyé yeyate nak gayé saabe dé Gotna kudi buldakwa gat wulae Gotna kudi dé derét wakwek. Got némaan ban rate deké miték védéranké dé kudi wakwek. Wakwete dé kiyakiya yan du taakwa baadi, sépékwaapa kapére yan du taakwa baadit wawo dé kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wupmalemu du béré taakwa béré déké yédaka dé deké mawulé léknék. Sipsipké téségékwa du sipsipké téségémarék yadéka, sipsip bakna yeyé yeyadaka, deku mawulé yékéyaak yadékwa pulak, deku mawulé yékéyaak dé yak. Yadéka dé Jisas deké mawulé léknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Lékte dé déku duwat aja kudi kéga wak, “Kadému yaanannan képmaaba wupmalemu kadému ak yate dé tu. Tédéka walkamu du male de jébaa yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Guné wani képmaana bapadut waatagunu dé wupmalemu jébaa yakwa duwat wadu de yae déku kadému kéraaké de yo.” Naate dé Jisas aja kudi wakwek, wupmalemu du taakwa Gotna kudi véknwuké mawulé yadaka Gotna jébaa yate déku kudi wakwekwa du walkamu male radakwaké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas déku du taaba vétik sékét maanba kayék vétiknét waadéka yaadaka dé deké apa kwayék, de wado akwi kutakwa yaage yédoké. Deké nak apa wawo dé kwayék, de kiyakiya yan akwi du taakwa baadi, sépékwaapa kapére yan akwi du taakwa baadit wawo kutnébuldoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","De déku kudi kure yédoké dé derét wak. Deku yé kéga: Saimon, déku nak yé Pita. Déku wayékna Andru. Sebedina nyaan vétik Jems déku wayékna Jon wale. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip. Batolomyu. Tomas. Matyu. Déknyényba takis dé nyégélék. Alpiasna nyaan Jems. Tadias. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nak Saimon. Déknyényba gege gayét yéte dé wak, “Nak képmaana du naanéké némaan du ramuké kélik wuné yo.” Nak du déku yé Judas Iskariot. Kukba Jisasnyét dé kwayék déku maamaké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas wani duwat kéga dé kudi wakwek, “Guné Sameriaba tékwa gayét yémarék yaké guné yo. Nak képmaaba tékwa gayét wawo yémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Guné naana gayé Isrelba tékwa gayét male yéké guné yo. Isrelna du taakwa deku mawulé yékéyaak débu yak. Yalaknén sipsip deku mawulé yékéyaak yakwa pulak, Isrelna du taakwa Gotna kudiké kuk kwayédak deku mawulé yékéyaak débu yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Deké yéte guné kéga derét kudi wakweké guné yo, ‘Némaan Ban Got gunéké védéran tulé yaamale yaké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Waga wakwetakne guné kiyakiya yan du taakwa baadi, sépékwaapa kapére yan du taakwa baadit wawo kutnébulké guné yo. Kiyaan du taaakwat wagunu de tépa nébéle raapké de yo. Lepéro yan du taakwat kutnébulké guné yo. Du taakwana mawuléba tékwa kutakwat wagunu de yaage yéké de yo. Wuné gunéké apa bakna wuné kwayék. Kwayéwurénké guné wani jébaa bakna yaké guné yo. Wani jébaaké yéwaa nyégélmarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Guné yéwaa las kérae kure yémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Guné yéte kusadagunén mu male kwaadu yéké guné yo. Wut nak wawo, baapmu wut las wawo, su, sétogunékwa baagé, waga kure yémarék yaké guné yo. Guné du taakwat kutkalé yagunu de gunat kutkalé yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Guné gayét nak wulae guné miték véké guné yo. Végunu yéknwun du guné wale kudi buldéran guné déku gaba male raké guné yo. Kés ga nak gat yémarék yaké guné yo. Déku gaba re yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Guné gaba nak wulae waba rakwa du taakwat kéga waké guné yo, ‘Yéknwun mawulé yate raké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Guné waga wagunu waba rakwa du taakwa gunéké yéknwun mawulé yadaran Got derét kutkalé yadu de miték raké de yo. Waba rakwa du taakwa gunéké yéknwun mawulé yamarék yate gunéké kuk kwayédaran Got derét kutkalé yamarék yaké dé yo. Got gunat kutkalé yadu guné miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Guné gayét nak wulaagunu waba rakwa du taakwa guna kudi véknwumarék yate, gunéké kuk kwayédaran, guné wani gayé kulaknyényké guné yo. Kulaknyényké yate guna maanba kwaakwa bawusa yatputétakne guné yéké guné yo.” Naate dé Jisas wak. Jisas wani kudi wate dé kéni muké wakwek. Naané Juda kéga naané yo. Gotna kudiké kuk kwayékwa du taakwat Got yadan kapéredi mu yakatadéranké kutdéngdoké naané deku gayé kulaknyényké yate naana maanba kwaakwa bawusa naané yatputu. Yatakne naané yu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jisas dé déku duwat tépa wate dé kéga wakwek, “Gunéké kuk kwayéran du taakwaké wuné gunat wakweyo. De naanéké waga kuk tiyaate apakélé kapéredi mu de yo. Déknyényba Sodomba ran du taakwa, Gomoraba ran du taakwa wawo de kapéredi mu yak. Kukba Got apakélé kot véknwute némaan ban raran nyaa dé wadu de Sodomba ran du taakwa, Gomoraba ran du taakwa kaagél kutké de yo. Du taakwa naanéké kuk tiyaadaran wani nakurak kapéredi mu Sodomba ran du taakwa, Gomoraba ran du taakwa yadan kapéredi mat talaknaké dé yo. Wani nyaa Got wadu naanéké kuk tiyaaran du taakwa apakélé kaagél kutké de yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mé véknwu. Wawuru guné gege gayét yéké guné yo. Kwatbosa sipsipmét yaalébaandakwa pulak, wani gayéba rakwa du taakwa de gunat yaalébaanké mawulé yaké de yo. Kaabe yéte kapéredi mu dérét yaalébaanmuké jérawu yadékwa pulak, guné kapéredi muké jérawu yaké guné yo. Nyaamiyo waariyamarék yate yalagi radakwa pulak, guné waariyamarék yate miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Guné jérawu yaké guné yo. Du las gunat kérae gunat kotimké de yo. Du las Gotna kudi buldakwa gaba gunat viyaaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Guné wuna du ragunékwaké du las wuna jébaaké kélik yate gunat kure yédo guné deku némaan duna méniba téké guné yo. De waga yado guné derét wuna kudi wakweké guné yo. Nak gena du taakwat wawo wuna kudi wakweké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Du las gunat kotimdo guné wup yamarék yate guna mawuléba kéga wamarék yaké guné yo, ‘Naané samu kudi wakweké naané yo? Deku kudi yaga pulak kaataké naané yo?’ Waga wamarék yaké guné yo, wani tulé Got wakwegunéran kudi gunéké kwayédéran bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wani tulé guna yaapa Gotna Yaamabi guna mawuléba wulae tédu guné déku kudi véknwute wakweké guné yo. Guna mawuléba sanévéknwute kudi wakwemarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kukba wupmalemu du deku némaadugu wayéknajet kotimdo de némaadugu wayéknajet viyaapérekgé de yo. Yaapa deku baadit kotimdo de wani baadit viyaapérekgé de yo. Baadi wawo néwepat kotimdo de néwepat viyaaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Guné wuna du ragunékwaké akwi du taakwa gunéké kélik yaké de yo. Guné guna mawuléba apa yate wuna jébaa kutsaakugunu kukba Got gunat kéraadu guné dé wale miték rasaakuké guné yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nak geba gunat yaalébaandaran guné nak get yaage yéké guné yo. Isrelna akwi gayéba jébaa yabutimarék yagunu wuné Akwi Du Taakwana Nyaan gwaamale yaaké wuné yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kéni aja kudi mé véknwu. Yakwatnyékwa du sékulkwa baadit talakne de némaan du de ro. Jébaa kwayékwa du de deku jébaa yakwa duwat talakne de deké némaan du de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nak du yakwatnyékwa duwat yadaran pulak, de baadit wawo yaké de yo. Nak du jébaa kwayékwa duwat yadaran pulak, de deké jébaa yakwa duwat wawo yaké de yo. Bulaa wani kudiké mé sanévéknwu. Nak du wuné guna némaan banét yadakwa pulak, de guné wuna duwat wawo yaké de yo. Nak du wunéké kapéredi kudi wakwete de wo, ‘Guna némaan ban wan akwi kutakwana némaan ban, déku yé Bielsebul.’ De wunéké waga wakwete guné wuna du gunéké apakélé kapéredi kudi wakweké de yo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wani kudi watakne dé Jisas déku duwat kéni kudi wakwek, “Du las gunat kapéredi mu yado guné deké wup yamarék yaké guné yo. Yatakne paakugunén mu kukba wupmalemu du taakwa véké de yo. Akélak wakwegunén kudi kukba wupmalemu du taakwa véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gaan rate wakwewurén kudi guné nyaa wakweké guné yo. Bulaa wuné guné wale rate akélak wuné kudi wakweyo. Wupmalemu du wuna kudi kaapuk véknwudakwa. Guné male guné véknwu. Kukba guné kaapaba téte wani kudi némaanba wakwegunu de véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Du las de wo, gunat viyaapérekdaranké. Deké wup yamarék yaké guné yo. De gunat viyaapérekte de guna wuraanyanét viyaaké yapatiké de yo. Guné Gotké wup yaké guné yo. Dé male wani muké dé apa yo. Dé du taakwana sépé du taakwana wuraanyanét wawo viyaaké dé apa yo. Derét yaa yaansaakukwa taalat yatjadaké dé apa yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kéni kudi mé véknwu. Du taakwa de makwal yéwaa nak kwayétakne makwal api vétik de kérao. Makwal api nak képmaaba akéréléka guna yaapa Got wani muké dé kutdéngék. Api nak képmaaba akérémarék yaluké wadéran wani api akérémarék yaké lé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gunéké wawo dé kutdéngék. Akwi muké dé kutdéngék. Guna maaknaba tékwa nébé akwi naaknwe wani muké wawo dé kutdéngék. Kutdéngte dé gunéké miték vu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Védékwaké sanévéknwute guné wup yamarék yaké guné yo. Api wan makwal mu. Du taakwa wan némaa mu. Guna yaapa Got makwal apiké waga miték véte gunéké miték male véké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Du las wupmalemu du taakwana méniba téte nak nak kéga wadaran, ‘Wuné Jisasna du.’ Naate wadaran kukba wuné wuna yaapana gayéba rate déku méniba téte wuné dérét waké wuné yo, ‘Kéni du wan wuna du.’ Naate waké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Du las wupmalemu du taakwana méniba téte nak nak kéga wadaran, ‘Wuné Jisasna du kaapuk.’ Naate wadaran wuné wuna yaapana gayéba rate déku méniba téte wuné dérét waké wuné yo, ‘Wani du wan wuna du kaapuk.’ Naate waké wuné yo Gorét. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yaga guné wo? Akwi képmaaba rakwa akwi du taakwa waariyamarék yate miték radoké wuné yaak, kapu kaapuk? Wan kaapuk. Yaawurénké du las wuna kudi miték véknwudo deku kém rékaréka yate de wale waariyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yaawurénké du taakwa las wuna kudi miték véknwudo du taakwa las wuna kudiké kuk kwayéké de yo. Yate baadi deku yaapa wale waariyaké de yo. Takwanyangu deku néwaa wale waariyaké de yo. Méyaasgu deku yawutakwa wale waariyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nakurak gaba rakwa du taakwa de wawo waariyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Guné guna néwepaké mawulat kapére yate wunéké walkamu mawulé yagunéran guné wuna du ramarék yaké guné yo. Guné guna baadiké mawulat kapére yate wunéké walkamu mawulé yagunéran guné wuna du ramarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Guné kéga wagunéran, ‘Jisasna jébaa kutsaakuké naané yo. Yate kaagél kutte miba kiyaanaran wan bakna mu. Némaa mu kaapuk.’ Waga wagunéran guné waga yate guné wuna du raké guné yo. Guné waga wamarék yate waga yamarék yagunéran guné wuna du ramarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Guné wunéké sanévéknwute wuna jébaa kutsaakugunu de wuna maama gunat viyaapérekdaran guné wuné wale apuba apuba miték rasaakuké guné yo. Guné guna sépéké male sanévéknwute guna jébaa male yagunéran guné kiyae yalakgé guné yo. Wuné wale miték rasaakumarék yaké guné yo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wani kudi watakne dé Jisas déku duwat kéga dé wakwek, “Du taakwa gunat kutkalé yate de wunat wawo kutkalé yo. Yate wunat wadéka yaawurén ban Gorét wawo de kutkalé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Guné Gotna yéba kudi wakwekwa dut nak véte kéga wagunéran, ‘Wani du dé Gotna yéba kudi wakweyo. Wuné déké radéran taalé, kadému wawo kwayéké wuné yo.’ Naate wagunéran guné waga yagunu kukba Got gunat kutkalé yaké dé yo, déku yéba kudi wakwekwa dut kutkalé yadéran pulak. Guné yéknwun mu yakwa dut nak véte kéga wagunéran, ‘Wani du dé yéknwun mu male yasaaku. Wuné déké radéran taalé, kadému wawo kwayéké wuné yo.’ Naate wagunéran guné waga yagunu kukba Got gunat kutkalé yaké dé yo, yéknwun mu male yasaakukwa dut kutkalé yadéran pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Kéni kudi wawo mé véknwu. Du taakwa wuna duwat véte kéga wadaran, ‘Wani du de némaan du kaapuk radakwa. Bakna du de ro. Rate de Jisasna jébaa kuru. Derét kutkalé yaké naané yo. Derét gutak yadu deké gu kwayéké naané yo.’ Naate wadaran de wani makwal jébaa yado Got wani makwal jébaaké yékéyaak yamarék yaké dé yo. Kukba wani yéknwun jébaa kaataké dé yo derét. Adél wuné gunat wakweyo.” Naate dé Jisas déku duwat wak. Wadéka de déku jébaa yaké nae de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","2","Jisas Krais déku du taaba vétik sékét maanba kayék vétiknét kudi wakwebutitakne wani gayé kulaknyénytakne dé wani képmaaba tékwa gayét yéte dé du taakwat Gotna kudi wakwek. Wakwete Gotna jébaa yadéka dé gu yaakutaknan du Jon raamény gaba rate dé yadén jébaaké kudi véknwuk. Véknwute déku duwat wadéka de Jisaské yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ye de Jisasnyét wak, “Déknyényba Gotna nyégaba de kudi kavik, naanat kutkalé yaké kukba yaaran duké. Méné wani du méné, kapu nak duké raségéké naané yo? Wani muké kutdéngké dé Jon mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Naate wadaka dé derét wak, “Guné gwaamale ye guné végunén mu véknwugunén kudiké Jonét wakweké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Méni kiyaan du taakwa védaka maan kapére yan du taakwa yéknwun ye de yeyé yeyo. Lepéro yan du taakwa yéknwun yadaka waan waagété yadéka kudi véknwumarék yan du taakwa de kudi véknwu. Wani du taakwat wunébu kutnébulék. Wuné wawurék kiyaan du taakwa de tépa nébéle raapme ro. Gwalmu yamarék du taakwat wuné Gotna kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Du taakwa las de wunéké wo, ‘Got dérét débu wak, dé naanat kutkalé yaduké. Wan adél.’ Naate wate de wunéké miték sanévéknwu. Wunéké waga sanévéknwukwa du taakwa de yéknwun mawulé yate miték raké de yo. Waga Jonét wakweké guné yo.” Naate dé Jonna duwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jisas waga wadéka Jonna du yédaka dé Jisas waba ran du taakwat Jonké kéga wakwek, “Guné du ramarék taalat ye yaga pulak dut véké guné yék? Apa yamarék yate wimut kutdéka ségénkwa séwaa pulak yakwa dut véké guné yék, kapu yaga pulak? Jon wan wani mu pulak kaapuk. Jon wan apa yakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yéknwun baapmu wut kusadan dut véké guné yék, kapu yaga pulak? Jon wani du pulak kaapuk radén. Yéknwun baapmu wut kusadan du de némaan banna gaba de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gotna yéba kudi wakwekwa dut nak véké guné yék, kapu yaga pulak? Ao, Jon wan Gotna yéba kudi wakwekwa du. Dé némaan du dé ro. Gotna yéba kudi wakwen nak némaan duwat talakne dé némaan du dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jonké kéni kudi Gotna nyégaba dé kwao: Got déku nyaanét dé wak, ‘Kén wuna kudi kure yékwa du. Wuné wawuru dé taale yéte ména yaabu kutké dé yo.’ Naané wani kudi véte naané kutdéngék. Jon wan Gotna kudi kure yéte taale yaakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Waga kutdéngte gunat wuné wo. Gu yaakutaknan du Jonna jébaa kéni képmaaba déknyényba ran duna jébaat débu talaknak. Talaknadéka dé gunat kutkalé yawuréran jébaaké kaapuk miték kutdéngdén. Yadéka de Gotna kémba rate du taakwat kutkalé yawuréran jébaaké kutdéngkwa du taakwa akwi deku yéknwun mawulé déku yéknwun mawulat débu talaknak. Wuné gunat adél kudi wuné wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Naate watakne Jisas dé kéga kudi wakwek, “Jon yae dé du taakwat Gotna kudi wakwek. Batnyé wakwedén tulé bulaa wawo wupmalemu du taakwa Gotna kémét yaalébaanké, de apat kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Got némaan ban rate du taakwaké miték véké dé yo. Moses déknyényba wani muké dé kudi wakwek. Gotna yéba wakwen nak du wawo wani muké de kudi wakwek. Jon wawo wani muké dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Guné deku kudi véknwugunéran wan yéknwun. Déknyényba ran du de kéga wak, ‘Ilaija kukba yaaké dé yo.’ Naate wadaka bulaa gunat wuné wakweyo. Wani kudi wate de Jonké de wakwek. Wakwedaka Jon débu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bulaa rakwa du taakwa yaga pulak de? Gunat wakweké wunék. Bulaa rakwa du taakwa de ameba kutkwa baadi pulak de ro. De kutte de nak baadit wao. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Waate de wo: Naané gwaaré waate kaang viyaanaka guné kaapuk kétigunén. Naané mawulé lékte géraanaka guné kaapuk géraagunén. Guné naané wale nakurak mawulé kaapuk yagunén. Waga waakwa baadi pulak, bulaa rakwa du taakwa waga de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“De Jon wale nakurak mawulé kaapuk yadan. De wuné wale nakurak mawulé kaapuk yadakwa. Jon yae kagunékwa kadému kamarék yate kagunékwa wain gu kaapuk kadén. Yadéka guné akwi déké kélik yate guné wo, ‘Kutakwa déku mawuléba wulae téléka dé waagété yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naate wagunéka wuné Akwi Du Taakwana Nyaan yae kagunékwa kadému kate kagunékwa wain gu wuné ko. Kawuréka guné wunéké kélik yate guné wo, ‘Mé vé. Wani du wupmalemu kadému kate wupmalemu wain gu dé ko. Kate dé takis nyégélkwa du wale rate, kapéredi mu yakwa nak du taakwa wale rate dé de wale kudi bulu.’ Naate wagunéka wuné gunat wo. Got dé akwi muké kutdéngék. Déku jébaa wan yéknwun jébaa. Wan adél. Wani kudiké sanévéknwute guné Gotké yatékwa jébaaké miték sanévéknwuké guné yo.” Naate dé Jisas wani du taakwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas némaa gayéba las dé déknyényba vémarék yadan wupmalemu apa jébaa dé yak. Yadéka de waba ran du taakwa yadan kapéredi mu kulaknyénymarék ye Gotké kaapuk miték sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yadanké Jisas dé derét kéga wakwek, “Kape du taakwa, guné Korasinba rakwa du taakwa! Kape du taakwa, guné Betsaidaba rakwa du taakwa! Wuné guna gayéba rate wuné apa jébaa wuné yak. Yawuréka guné vék. Véte guné Gotké kaapuk miték sanévéknwugunén. Taiaba déknyényba ran du taakwa, Saidonba déknyényba ran du taakwa wawo, Gotké kutdéngmarék ye wani apa jébaa védo mukatik, déknyényba de yadan kapéredi muké kélik yate, wani kapéredi mu kulaknyénykatik de yak. Yadan kapéredi muké kélik yate, nak du taakwa deku mawuléké kutdéngdoké de jégwaa baapmu wut kusade bawuba rakatik de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Guné mé véknwu. Kukba Got apakélé kot véknwute némaan ban raran nyaa dé wadu de Taiaba déknyényba ran du taakwa, Saidonba déknyényba ran du taakwa wawo de kaagél kutké de yo. Guné, Korasinba rakwa du taakwa, Betsaidaba rakwa du taakwa wawo, guné wuna jébaa véte guné wunéké kuk tiyaak. Kuk tiyaagunéka wani nakurak kapéredi mu de yan akwi kapéredi mat débu talaknak. Wani nyaa Got wadu guné apakélé kaagél kutké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Guné Kapaneamba rakwa du taakwa, guné saaki guné wo, ‘Naané Gotna gayét waaréké naané yo.’ Naate wagunéka gunat wuné wo. Got wadu guné kapéredi taalat dawuliké guné yo. Guné Gotna gayét waarémarék yaké guné yo. Wuné guna gayéba rate wuné apa jébaa wuné yak. Yawuréka guné vék. Véte guné Gotké kaapuk miték sanévéknwugunén. Déknyényba Sodomba ran du taakwa wupmalemu kapéredi mu ye wani apa jébaa védo mukatik de yadan kapéredi mu kulaknyénydo Got wani gayé yaalébaanmarék yakatik dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Guné mé véknwu. Kukba Got apakélé kot véknwute némaan ban raran nyaa dé wadu de Sodomba ran du taakwa kaagél kutké de yo. Guné Kapaneamba rakwa du taakwa, guné wuna jébaa wunéké wawo guné kuk tiyaak. Kuk tiyaagunéka wani nakurak kapéredi mu de yadan akwi kapéredi mat débu talaknak. Wani nyaa Got wadu guné apakélé kaagél kutké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wani kudi watakne Jisas kéga dé Gorét wak, “Wuna yaapa, méné nyét képmaaké némaan ban méné ro. Ména jébaaké las paakuménéka wupmale muké kutdéngkwa du ména jébaaké kaapuk miték kutdéngdan. Wupmale muké kutdéngmarék yakwa du taakwa, deku mawulé baadina mawulé tékwa pulak tédéka kwatkwa radaka derét ména jébaaké ménébu wakwatnyék. Waga yaménén wan yéknwun. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wuna yaapa, ména mawuléba sanévéknwute méné waga ménébu yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wani kudi watakne dé derét kéga wakwek, “Wuna yaapa dé wunéké déku jébaa apa wawo débu tiyaak. Wuné déku nyaan rawuréka de du taakwa wunéké kaapuk miték kutdéngdan. Dé male dé wunéké kutdéngék. Du taakwa déké kaapuk miték kutdéngdan. Wuné male wuné déké kutdéngék. Déké wakwewurén du taakwa wawo de déké kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Guné guna mawuléba sanévéknwu wanévéknwute miték raké apa jébaa yakwa du taakwa, guné wunéké yaagunéran wuné wawuru guna mawulé miték téké dé yo. Yaap rakwa du taakwana mawulé miték tékwa pulak tédu guné miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wuné jébaa yawurékwa pulak guné jébaa yaké guné yo. Guné wuna jébaaba yaalagunu wuné wani jébaaké gunat yakwatnyéké wuné yo. Yakwatnyéwuru naané nakurak mawulé yate wani jébaa yaké naané yo. Wuné wuna yéba kevérékmarék yate guna mawulat kutkalé yawuru guna mawulé miték téké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwayéwurékwa jébaa wan mawulé yagunéran jébaa. Wup yagunéran jébaa kaapuk. Guné wani jébaa yaké apa yaké guné yo. Guné wuna jébaa yagunéran guna mawulé miték téké dé yo. Tédu guné miték raké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kukba Judana yaap ra nyaa nak Jisas déku du wale de wit tékwa képmaaba nak yék. Yédaka déku duwat kaadé yadéka de wit kubu las sékwe de sék kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kadaka de Parisina du véte de Jisasnyét wak, “Mé vé. Ména du wit kubu de séku, yaap ra nyaa. Naana apa kudi kéga dé wo, ‘Guné yaap ra nyaa jébaa yamarék yaké guné yo.’ Wani apa kudi ména du kaapuk véknwudakwa. De wit kubu sékute de jébaa yo yaap ra nyaa. Wan kapéredi mu de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Naate wadaka dé derét wak, “Déknyényba naana képmawaara Devit yadén muké de Gotna nyégaba kavik. Wani kudiké guné kaapuk sanévéknwugunékwa. Déknyényba Devit déku du wale kaadé yadéka de Gotna kudi buldakwa gat wulae wani gaba jébaa yakwa nyédé duwat dé waatak, Gotké kwayéte taknadan kadému deké kwayédoké. Waatadéka kwayédaka Devit déku du wale de wani kadému kak. Waga yate de naana apa kudi kaapuk véknwudan. Naana apa kudi kéga dé wo, ‘Gotna gaba jébaa yakwa nyédé du male Gotké kwayédan kadému kaké de yo. Nak du wani kadému kamarék yaké de yo.’ Naate wadéka Devit déku du wale waga yadaka guné deké kéga kaapuk wagunékwa, ‘Wan kapéredi mu de yak.’ Naate wamarék yate samuké guné wuna duké guné kéga wo? ‘De naana apa kudi véknwumarék yate kapéredi mu de yo.’ Guné waga wate kaapuk miték kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nak kudi wawo mé véknwu. Gotna gaba jébaa yakwa nyédé du de yaap ra nyaa de Gotna gaba jébaa yo. Moses wakwen apa kudi dé kéga wo, ‘Gotna gaba jébaa yakwa nyédé du yaap ra nyaa wawo déku gaba wani jébaa yaké de yo. Wan yéknwun.’ Naate wadéka de yaap ra nyaa wani jébaa yadaka guné derét kaapuk waatigunékwa. Yagunékwaké samuké guné wuna duwat guné waatiyu? ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mé véknwu. Wuné némaan ban wuné ro, Gotna kudi bulnakwa gaké. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Gotna nyégaba kéni kudi dé kwao: Got dé wak, ‘Guné nak du taakwaké mawulé lékte derét kutkalé yagunuké wuné mawulé yo. Guné kwaami viyae wunéké tiyaamuké wuné kélik yo.’ Naate dé Got wak. Wadéka wani kudi déku nyégaba kwaadéka guné wani kudiké kaapuk miték kutdénggunén. Guné wani kudiké miték kutdénggunu mukatik guné kapéredi mu yamarék yan duwat waatimarék yakatik guné yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wani kudi wuné Akwi Du Taakwana Nyaan wuné wo, yaap ra nyaaké némaan ban rawurékwa bege. Wuné du taakwana jébaaké kusékétwuru de kusékétwurén pulak yaké de yo, yaap ra nyaa.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wani kudi watakne dé Jisas wani taalé kulaknyénytakne dé Gotna kudi buldakwa gat wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wulaadéka taaba léknén du dé nak waba ték. Tédéka Jisaské kélik yakwa du deku mawuléba de wak, “Jisas yaap ra nyaa jébaa yadéran naané dérét kotimké naané yo.” Naate wate de Jisasnyét wak, “Yaap ra nyaa du kiyakiya yakwa duwat kutnébuldaran de naana apa kudiké de kuk kwayu, kapu yaga pulak? Wani muké yaga méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naate wadaka dé derét wak, “Guna du nak déku sipsip yaap ra nyaa waaguba akérédéran dé wani sipsip kérae kusalaké de yo, kapu yaga pulak? Dé déku sipsip kérae kusalaké dé yo. Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipsip wan makwal mu. Du taakwa wan némaa mu. Yaap ra nyaaba du de nak duwat kutkalé yadaran naana apa kudi wani muké derét waatimarék yaké dé yo. Wuné yaap ra nyaaba duwat kutkalé yawuréran naana apa kudi wani muké wunat waatimarék yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naate watakne dé taaba léknén dut wak, “Ména taaba mé kedéng.” Naate wadéka dé déku taaba kedéngdéka dé nak taaba tén pulak miték dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tédéka de Parisina du rékaréka yate wani ga kulaknyénytakne de kudi bulék, Jisasnyét viyaapérekgé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas wani muké kutdéngte dé wani gayé kulaknyénytakne dé yék. Yédéka de wupmalemu du taakwa déku kukba de yék. Yédaka dé wadéka kiyakiya yan du taakwa akwi, sépékwaapa kapére yan du taakwa akwi de yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yadaka dé derét némaanba wak, de déké nak du taakwat kudi wakwemarék yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","18","Waga wadéka Gotna yéba kudi wakwen du Aisaia déku kudi wani tulé adél dé yak. Déknyényba Aisaia kéni kudi dé Gotna nyégaba kavik: Got dé wak, “Wuné wani dut wawurék dé wuna jébaa yakwa du dé ro. Wuné déké mawulat kapére yawuréka wuna mawulé yéknwun dé yo déké. Wuné wawuru wuna Yaamabi déku mawuléba wulae téké dé yo. Tédu dé némaa kot véknwukwa némaan ban rate wuna kudi akwi du taakwat wakweké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dé waarumarék yaké dé yo. Dé némaanba waamarék yaké dé yo. Dé yaabuba téte derét némaanba wakwemarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dé mukgé yan séwaa nak mukmarék yaké dé yo. Yatjadamarék yate dé wani séwaat kutkalé yaké dé yo. Dé walkamu yaankwa yaa sékusmarék yaké dé yo. Dé tépa sérakdu apakélé yaa yaanké dé yo. Dé waga yate déké walkamu sanévéknwukwa du taakwat kutkalé yadu de apa yate déké miték sanévéknwuké de yo. Dé jébaa yadu yéknwun mu male téké dé yo. Kapéredi mu kaapuk yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Akwi képmaaba rakwa du taakwa déké miték sanévéknwute waké de yo, ‘Dé naanat kutkalé yaké dé yo.’ Naate wate déké raségéké de yo.” Naate dé Got wak. Wadéka Aisaia wani kudi dé Jisaské kavik Gotna nyégaba, déku néwaa kéraamarék yalén tulé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Du las de dut nak Jisaské kure yék. Wani dut kutakwa lé kure ték. Téléka déku méni kiyaadéka dé kudi kaapuk buldén. Yadéka dé Jisas dérét kutnébuldéka dé kudi bulte méni vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yadéka de wupmalemu du taakwa véte kwagénte de wak, “Aki. Wani du wan Devitna képmawaara, kapu yaga pulak? Dé naanat kutkalé yaduké Got wadén ban, kapu yaga pulak?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisina du wani muké véknwute de deku kapmu kudi bulte de wak, “Wani du wan Got wadén ban kaapuk. Kutakwana némaan ban déku yé Bielsebul déku mawuléba dé wulae tu. Téte apa kwayédéka wani du wadéka de kutakwa yaage yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naate wadaka Jisas deku mawulé kutdéngte dé derét wak, “Kéni kudi mé véknwu. Némaa gayéba rakwa du mawulé vétik yate kémba kémba rate waariyadaran de rasaakumarék yaké de yo. Nakurak gaba rakwa du taakwa mawulé vétik yate deku kapmu waariyadaran de wawo rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wani kudiké mé sanévéknwu. Kutakwana némaan ban Seten déku du wale waga de ro. De mawulé vétik yate deku du wale waariyadaran de rasaakumarék yaké de yo. Guné wunat wagunén pulak, Seten déku kém yaage yédoké wadéran de rasaakumarék yaké de yo. Seten waga jébaa kaapuk yadékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guné wunéké kéni kudi guné wo. Kutakwana némaan ban, Bielsebul wuna mawuléba téte wunéké apa tiyaadéka wuné wawuréka de kutakwa yaage yu. Wan yénaa kudi guné wo. Guna du las de wawo wadaka de kutakwa yaage yu. Guna du waga yadaka guné derét kéga kaapuk wagunékwa, ‘Bielsebul guna mawuléba téte apa kwayédéka guné wagunéka de kutakwa yaage yu.’ Derét waga wamarék yate samuké guné wunat wani kudi guné wo? Wuné de wale nakurak jébaa yawuréka de de kutdéngék. Guné wunéké yénaa kudi guné wo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mé véknwu. Gotna Yaamabi wuna mawuléba téte dé wunéké apa tiyao. Tiyaadéka wuné kutakwat wawuréka de yaage yu. Guné wani mu véte kéga kutdéngké guné yo. Got némaan ban rate du taakwaké miték védéran tulé débu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kéni kudi mé véknwu. Du nak apa yakwa duna gat wulae déku gwalmu bakna kéraaké nae taale dé wani dut kure baagwit giké dé yo. Gitakne déku gat wulae déku gwalmu bakna kéraaké dé yo. Wani kudiké mé sanévéknwu. Seten wan wani apa yakwa du pulak. Wuné wani dut baagwit gikwa du pulak. Wuna apa Setenna apat débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wuné wale jébaa yamarék yakwa du taakwa de wuna maama de ro. Wuné du taakwat wawuréka de wuna kémba de ro. Wuna du taakwat kutkalé yamarék yakwa du taakwa de wuna du taakwat yaalébaanu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Wani muké sanévéknwute wuné gunat wakweyo. Du taakwa kapéredi mu ye wani kapéredi muké kélik ye kulaknyénydaran, Got yadan kapéredi mu yatnyéputiké dé yo. Du taakwa kapéredi kudi wakwetakne wani kapéredi kudiké kélik ye kulaknyénydaran Got wani kapéredi mu yatnyéputiké dé yo. De wasélékte kapéredi kudi Gotna Yaamabiké wakwedaran Got wani kapéredi mu yatnyéputimarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wuné Akwi Du Taakwana Nyaan wuné ro. Du taakwa wunat wasélékte wunéké kapéredi kudi wakwetakne wani kapéredi kudiké kélik ye kulaknyénydaran, Got wani kapéredi mu yatnyéputiké dé yo. De wasélékte Gotna Yaamabiké kapéredi kudi wakwedaran Got wani kapéredi mu yatnyéputimarék yaké dé yo. Bulaa yatnyéputimarék yaké dé yo. Kukba wawo yatnyéputimarék yaké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wani kudi wakwetakne dé Jisas derét kéga wakwek, “Yéknwun miba dé yéknwun sék aku. Kapéredi miba dé kapéredi sék aku. Naané miséknét véte naané kutdéngék, yéknwun mi, kapéredi miké wawo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Guné Parisina du, guné duwat tikwa kaabe pulak guné ro. Guné kapéredi mawulé male guné yo. Yate yaga pulak guné yéknwun kudi wakweké guné yo? Du taakwa deku mawuléba sanévéknwute kudi de bulu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yéknwun mawulé yakwa du taakwa de yéknwun mu yate yéknwun kudi de bulu. Kapéredi mawulé yakwa du taakwa de kapéredi mu yate kapéredi kudi de bulu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mé véknwu. Gunat wuné wakweyo. Got némaa kot véknwute némaan ban radéran nyaa akwi du taakwat Got waatadu de buldan némaa kudi, buldan bakna kudi, buldan akwi kudiké dérét kaataké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kukba dé guna kudi akwi véknwutakne dé lasnyét waké dé yo, ‘Guné yéknwun mu yakwa du.’ Watakne lasnyét waké dé yo, ‘Guné kapéredi mu yakwa du.’ Waga Got waké dé yo.” Naate dé Jisas Parisina duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wani kudi wadéka de apa kudiké kutdéngkwa du las, Parisina du las waga de Jisasnyét wak, “Némaan du, naané déknyényba vémarék yanan apa jébaa nak yaménu véké naané mawulé yo. Méné yaménu naané véte kutdéngké naané yo. Got wadéka méné yaak. Waga kutdéngké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naate wadaka dé derét wak, “Kéni tulé rakwa du taakwa kapéredi mu de yasaaku. De kuk debu kwayék, Gotké. Wunat wagunén apa jébaa, déknyényba vémarék yagunén apa jébaa, yamarék yaké wuné yo. Gotna yéba kudi wakwen du Jona déknyényba yadén pulak male yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Déknyényba Jona gaan kupuk nyaa kupuk waga apakélé gukwamina yaaléba kwaadén pulak, wuné Akwi Du Taakwana Nyaan rémdaran waaguba gaan kupuk nyaa kupuk waga kwaaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Déknyényba Ninivaba ran du taakwa de Jonana kudi véknwutakne yadan kapéredi mu de kulaknyényék. Jona némaan du radéka wuné kéba téte kudi bulkwa du wuné némaan ban rate Jonat wunébu talaknak. Kukba Got némaa kot véknwute némaan ban radéran tulé Ninivaba ran du taakwa raapme Gotna méniba téte waké de yo, ‘Jona naanat Gotna kudi wakwedéka naané véknwute yanan kapéredi mu kulaknyénytakne naané Gotna kudi miték véknwuk. Jisas Jonat talakne gunat Gotna kudi wakwedéka guné yagunén kapéredi mu kulaknyénymarék yatakne guné Gotna kudi kaapuk véknwugunén. Waga yate guné némaa kapéredi mu yak.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Déknyényba némaa taakwa nak, séknaa képmaaba yae lé némaan ban Solomonna kudi véknwuké lé séknaaba yaabuba yék. Dé yéknwun mawulé pukaakwa du radéka wuné kéba téte guné wale kudi bulkwa du wuné yéknwun mawulé pukaakwa du rate Solomonét wunébu talaknak. Kukba Got némaa kot véknwute némaan ban radéran tulé wani némaa taakwa raapme Gotna méniba téte lé gunat waké lé yo, ‘Wuné séknaa taaléba wuné yaak. Yae Solomonna kudi wuné véknwuk. Jisasna kudi Solomonna kudit débu talaknak. Guné Jisasna kudi kaapuk véknwugunén. Waga yate némaa kapéredi mu guné yak.’ Waga wani taakwa waké lé yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wani kudi watakne dé Jisas derét kéga wakwek, “Kéni kudi mé véknwu. Kutakwa ye lé nak duna mawuléba wulae te kulaknyénytakne lé yék. Maas viyaamarék yakwa taaléba yeyé yeyate raléran taaléké lé sékalék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sékalpatiye lé wak, ‘Wuné déknyényba rawurén gat gwaamale yéké wuné yo.’ Naate watakne gwaamale ye lé vék wani duna mawulé yéknwun ye bakna tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vétakne ye lé kutakwa nak taaba sékét nak taababa kayék vétiknét kwole yaak. Kwole yaalén kutakwa yadan kapéredi mu taale yaan kutakwa yalén kapéredi mat débu talaknak. Wani kutakwa akwi de wani duna mawuléba wulae ték. Déknyényba nak kutakwa déku mawuléba wulae téléka walkamu kapéredi mu dé yak. Wupmalemu kutakwa déku mawuléba wulae tédaka dé wani du wupmalemu kapéredi mu dé yak. Wani kudiké mé sanévéknwu. Wupmalemu kapéredi mu yan du radén pulak, bulaa rakwa du taakwa wunéké miték sanévéknwumarék yate bakna rate wupmalemu kapéredi mu yaran du taakwa raké de yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas du taakwat wekna kudi wakwedéka déku néwaa, déku wayéknaje wawo ye de kaapaba ték. Téte de dé wale kudi bulké mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yadaka dé du nak wulae Jisasnyét wak, “Mé véknwu. Ména néwaa, ména wayéknaje yae kaapaba téte de méné wale kudi bulké de mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Waga wadéka dé Gotna kémké derét yakwatnyéké mawulé yate dé dérét wak, “Wuna néwaa wayéknaje yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Naate watakne dé déku duwat déku taabat wakwatnyéte dé wak, “Mé vé. Kén wuna néwaa, wuna wayéknaje. ");
INSERT INTO abt_maprik_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Awuréba rakwa ban wuna yaapa déku kudi véknwute wadékwa pulak yakwa du taakwa wan wuna wayéknaje, wuna nyangegu, wuna néwaa pulak de ro.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wani nyaa Jisas kudi wakwebutitakne ga kulaknyénytakne dé kwawut yék. Ye dé kwawu tékwaba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Radéka de wupmalemu du béré taakwa béré yae de dé ranba jawuk. Jawudaka, de déku kudi miték véknwudoké mawulé yate, dé botba waare awulaga dé rak, kwawuba. Radéka de du béré taakwa béré kwawu maaléba de ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tédaka dé derét wupmalemu aja kudi wakwek. Taale dé derét kéga wakwek: “Du nak dé déku képmaaba wit sék yaatnyéké nae dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye yaatnyédéka de wit sék las yaabuba de akérék. Akére bakna radaka de api yae kérae de akwi kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wit sék las de matu wale ran walkamu képmaaba akérék. Akére de bari buréle waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Waarédéka apakélé nyaa védéka mégi miték kutmarék ye rékaa ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit sék las de raamény waara ténba akérék. Akére radéka raamény waara wure dé kakutapmék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wit sék las de yéknwun képmaaba akérék. Akére waba re de miték wurék. Wure de yéknwun sék akuk. Las de walkamu sék akuk (30). Las de wupmale sék akuk (60). Las de wupmalemu sék akuk (100).” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Naate watakne dé Jisas wak, “Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wani kudi wakwedéka Jisasna du déké yae de wak, “Samuké méné derét aja kudi wakweyo? Méné derét aja kudi wakwesaakuménéran de ména kudi miték véknwuké de yapatiyu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naate wadaka dé derét wak, “Got némaan ban rate du taakwaké miték véké dé yo. Védu de déku kémba raké de yo. Wani muké déknyényba Got kudi dé paakuk. Paakutakne bulaa dé kusékéru, guné wani muké kutdénggunuké. Nak du taakwa kutdéngmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yéknwun mawulé yakwa du taakwa wuna kudi de véknwu. Wuna kudi miték véknwukwa du taakwa kukba Gotna akwi kudiké miték kutdéngké de yo. Wuna kudi miték véknwumarék yakwa du taakwa de wo, ‘Naané Gotna kudi naanébu kutdéngék.’ Naate watakne kukba déku kudiké yékéyaak yate bakna raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wani du taakwa méni véte de védan muké kaapuk miték kutdéngdan. Wani du taakwa waan véknwute de véknwudan kudiké kaapuk miték kutdéngdan. Yadaka wuné derét aja kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Deké Gotna yéba kudi wakwen du Aisaia déknyényba Gotna nyégaba kavidén kudi bulaa adél débu yak. Got wadéka Aisaia du taakwaké déku kudi kéga dé kavik: Guné wuna kudi véknwute véknwute wani kudiké kutdéngmarék yaké guné yo. Véte véte miték vémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Naate watakne Got dé Aisaiat wakwek: Wani du taakwa wuna kudiké kutdéngmuké kélik yadaka deku mawulé kapéredi dé yo. Deku waan debu kuttépék. Deku méni debu kusnyék. De wuna kudiké kutdéngké mawulé yado mukatik wuna kudiké kutdéngdo. Deku waan kuttépémarék yado mukatik miték véknwudo. Deku méni laapiyakdo mukatik miték védo. Waga yado mukatik, wuna kudi miték véknwudo derét kutnébulwuru. Waga Got deku mawuléké dé Aisaiat wakwek. Wakwedéka Aisaia déku kudi déku nyégaba dé kavik.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Naate watakne Jisas dé déku duwat wak, “Guna mawulé wan deku mawulé pulak kaapuk. Got gunat débu kutkalé yak. Yadéka guna mawulé yéknwun dé yo. Yadéka guné miték véte, miték véknwute, miték guné kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kéni kudi mé véknwu. Gotna yéba kudi wakwen wupmalemu du, Gotna wupmalemu du taakwa las wawo, déknyényba rate de yawuréka végunékwa jébaa véké mawulat kapére yate de kaapuk védan. De wakwewuréka véknwugunékwa kudi véknwuké mawulat kapére yate de kaapuk véknwudan. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wani kudi wakwetakne dé Jisas kéga wakwek, “Wit sék yaatnyén duké wakwewurén aja kudiké las wakwewuru guné mé véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Got némaan ban rate du taakwaké miték védéran kudi, wani kudi du taakwa las bakna de véknwu. Véknwute de wani kudiké kaapuk miték kutdéngdan. Wani du taakwa wan yaabuba akérén wit sék pulak. De taale wani kudi de miték véknwu. Véknwudaka Seten yae dé wani kudi kérae kure yu. Yédéka de wani kudiké yékéyaak de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Du taakwa las de matu wale ran képmaaba akérén wit sék pulak. De wani kudi de bari véknwu. Véknwute taale wani kudiké yéknwun mawulé yate dusék takwasék de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yate de kaapuk miték sanévéknwudakwa. Wani kudi deku mawuléba dawulimarék yadéka de kaapuk miték sanévéknwudakwa. Yadaka de nak du Gotna kudiké kélik yate derét yaalébaandaka kapéredi mu las deké yaadéka de Gotna kudi bari kulaknyényu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Du taakwa las wan raamény waaraba akérén wit sék pulak. De Gotna kudi taale de miték véknwu. Véknwute de kéni képmaana muké male sanévéknwudaka deku mawulé yéwaa gwalmu kéraaké dé génu. Wani mu dé Gotna kudit taknatépu. Taknatépédéka de wani du taakwa Gotna jébaa kaapuk yadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Du taakwa las wan yéknwun képmaaba akérén wit sék pulak. De Gotna kudi miték véknwute, wadékwa pulak yate, de déku kudi miték kutdéngék. Kutdéngte de yéknwun jébaa yo déké. Las de déké walkamu yéknwun jébaa yadaka, las de déké wupmale yéknwun jébaa yadaka, las de déké wupmalemu yéknwun jébaa de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wani kudi wakwetakne dé Jisas aja kudi nak wawo kéga wakwek, “Kéga Got némaan ban rate du taakwaké miték véké dé yo. Du nak dé kadému yaanandékwa képmaaba yéknwun wit sék yaatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yaatnyédéka du taakwa gaan widé kwaadaka dé wani duna maama yae kapéredi waara sék yéknwun wit sékna nyédéba yaatnyétakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yédéka kukba wit sék buréle waare sék akuké yadéka de vék kapéredi waara wani wit wale tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vétakne de jébaa yakwa du ye de wani képmaana bapadut wak, ‘Némaan du, déknyényba méné yéknwun wit sék méné yaatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yaga pulak ye wani kapéredi waara dé waaru?’ Naate wadaka dé derét wak, ‘Naana maama nak yae dé wani mu yak.’ Naate wadéka de jébaa yakwa du dérét wak, ‘Wani kapéredi waara pélnoké méné mawulé yo, kapu yaga pulak?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naate wadaka dé derét wak, ‘Kaapuk. Kapéredi waara pélte sal yéknwun wit wale las pélké guné yo? Kapéredi waara pélmarék yaké guné yo. Bakna déku mé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yéknwun wit kapéredi waara wale vététi waaréké bét yo. Waare sék akubéru wuné sékuké yakwa duwat kéga waké wuné yo, Taale guné wani kapéredi waara pélte guné taanba giké yo. Gitakne guné yaaba tuké yo. Yatakne guné wit sékwe wuna kaadi gaba taknaké yo. Naate waké wuné yo wit sékuran duwat.’ Naate dé bapadu wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Wani kudi watakne dé Jisas kudi nak wawo kéga dé wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa taale makwal kém male raké de yo. Kukba apakélé kém raké de yo. Wani kém wan misék nak pulak. Wani misékna yé mastet. Mastet sék nak misék pulak kaapuk. Wani misék wan makwali sék male. Naana képmaaba tékwa akwi nak sék wan apakélé. Du nak wani misék kérae dé kadému yaanandékwa képmaaba pukaak. Pukaadéka bari bari waare apakélé ye dé wani képmaaba tékwa mit débu talaknak. Apakélé mi tédéka de api yae de wani mi gaaléba kwaat sétakne de rak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wani kudi watakne dé nak kudi kéga wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa kulé mawulé yate kulé du taakwa yaalaké de yo. Wani du taakwa wan yis pulak. Taakwa nak yis kérae pélawa wale lé sélorék. Sélotléka dé wani pélawa nak pulak mu dé yaalak. Nak pulak mu yaalan pulak, Gotna du taakwa kulé du taakwa yaalaké de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas wupmalemu aja kudi dé du taakwat wakwek. Wani kudiké derét kaapuk wakwedén. Aja kudiba male dé derét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Derét aja kudi waga wakwedéka Gotna yéba kudi wakwen du nak déku kudi adél dé yak. Wani du déknyényba Jisaské kéga dé Gotna nyégaba kavik: Wuné aja kudi derét wakweké wuné yo. Déknyényba Got képmaa kuttaknadén tulé déku kudi las dé paakuk. Paakutaknadéka ran kudiké bulaa wuné wakweké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas jawe tén du taakwat kulaknyénytakne dé gat nak wulaak. Wulaadéka déku du déké wulae de dérét wak, “Wani kapéredi waaraké méné aja kudi wakwek. Bulaa wani muké méné wakweménu naané miték kutdéngké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Naate wadaka dé Jisas derét wak, “Yéknwun wit sék yaatnyén du wan wuné. Wuné Akwi Du Taakwana Nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wani képmaa wan képmaaba tékwa akwi gayé. Yéknwun wit sék wan Gotna kémba yaalan du taakwa. Kapéredi waara wan Setenna du taakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kapéredi waara yaatnyén du wan Seten. Wit sékudakwa tulé wan kukba yaaran tulé, kéni képmaa kaapuk yaran tulé. Wit sékukwa du wan Gotna kudi kure giyaakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kapéredi waara péle yaaba tudan pulak, kukba kéni képmaa kaapuk yaran tulé, de kapéredi mu yakwa du taakwat yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wuné Akwi Du Taakwana Nyaan wuné wawuru wuna kudi kure giyaakwa du gege gayét yéte Gotna du taakwa wale rate kapéredi mu yakwa du taakwat kéraaké de yo. Akwi kapéredi mu, du taakwana mawulat yaalébaankwa akwi mu wawo kéraaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kérae de wani du taakwa, wani kapéredi mu wawo apakélé yaaba yatjadaké de yo. Yatjadado kapéredi mu yan du taakwa wani yaaba yaante de apakélé kaagél kutké de yo. Kutte géraaké de yo. Yéknwun taaléba raké mawulé yate némaanba géraaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wani tulé Gotna du taakwa dé wale raké de yo, déku gayéba. Deku yaapa Got pulak raké de yo. Rate de nyaa vékwa pulak raké de yo. Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” Naate dé Jisas déku duwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wani kudi watakne dé kéga wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa déku kémba yaalaké de yo. Déku kémba radaran paaté wan némaa mu. Du taakwa waga raké mawulat kapére yaké de yo. Yado deku mawulé kéni duna mawulé pulak téké dé yo. Wani du ye kadému yaanandan képmaaba nak dé vék, wupmalemu yéwaa paakutakne rémtépétaknadaka radéka. Véte yéknwun mawulé yate, duséknét kapére yate, dé wani yéwaa kéraaké mawulat kapére yak. Yate dé tépa rémtépétakne ye déku gwalmu akwi kwayétakne yéwaa nyégéle wani yéwaa kwayétakne wupmalemu yéwaa védén képmaa dé kéraak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wani kudi watakne dé Jisas kéga wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa déku kémba yaalaké de yo. Déku kémba radaran wan némaa mu. Du taakwa waga raké mawulat kapére yate nak muké sanévéknwumarék yaké de yo. Yado deku mawulé kéni duna mawulé pulak téké dé yo. Du nak déku jébaa yate kusodakwa yéknwun muké dé sékalék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sékale yéknwun mu nak vétakne wani mu kéraaké dé mawulat kapére yak. Yate nak muké sanévéknwumarék yate dé déku gwalmu akwi kwayétakne dé wupmalemu yéwaa nyégélék. Nyégéle wani yéwaa akwi kwayétakne dé wani yéknwun mu kéraak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Wani kudi watakne dé Jisas nak kudi kéga wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa déku kémba raké de yo. Kukba déku du taakwa déku kémba yaalamarék yan du taakwat wawo kéga pévéké dé yo. Kukba kéni du yadan pulak yaké dé yo. Du nak laaké kwawuba kusadataknadéka kwaadéka de kés pulak nak pulak gukwami wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wulaadaka laaké sékérékdéka de nébat tébétsalak. Tébétsalatakne de rate gukwami pévék. Pévéwe de yéknwun gukwami kérae agérapba taknak. Takne de kapéredi gukwami yatjadak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Kukba kéni képmaa kaapuk yaran tulé Got wadu déku kudi kure giyaakwa du waga yaké de yo. De giyae Gotna du taakwa wale rate kapéredi mu yakwa du taakwat kérae apakélé yaaba yatjadaké de yo. Yatjadado kapéredi mu yan du taakwa wani yaaba yaante apakélé kaagél kutké de yo. Kutte géraaké de yo. Yéknwun taaléba raké mawulé yate némaanba géraaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wani kudi watakne Jisas dé derét waatak, “Guné wani kudiké akwi guné miték kutdéngék?” Waga waatadéka de wak, “Ao. Naané kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naate wadaka dé derét wak, “Apa kudiké kutdéngkwa du wuna jébaaba yaale de apakélé gana bapadu pulak. Dé déku gaba wulae déknyényba taknadén mu kulé mu wawo dé kure yao. Kure yaadékwa pulak, de deku mawuléba véknwute déknyényba véknwudan kudi, Gotna kémké kulé kudi wawo de wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wani kudi watakne dé Jisas wani gayé kulaknyénytakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ye déku néwaage saabe dé du taakwat Gotna jébaaké yakwatnyék, Gotna kudi buldakwa gaba. Yakwatnyédéka de kwagénte de wak, “Aki. Yaga pulak dé wani muké kutdéngék? Yaga pulak ye dé déknyényba vémarék yanan apa jébaa yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dé ga jébaa yakwa banna nyaan. Déku néwaa wan Maria. Déku wayéknaje wan Jems, Josep, Saimon, Judas. ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Déku nyangegu akwi naané wale de ro. Dé némaan du kaapuk. Wan bakna du. Waga naané kutdéngék. Yaba dé wani kudi kéraak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naate watakne déku apaké kutdéngmarék yate de déké kélik yak. Yadaka dé Jisas derét wak, “Gotna yéba kudi wakwekwa duké de nak gena du taakwa wo, ‘Wan némaan ban. Dé yéknwun jébaa dé yo.’ Waga wadaka déku kém déku néwaageba rakwa du taakwa wawo de déké wo, ‘Wan bakna du. Naané pulak du.’ Naate de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Waga watakne dé Jisas déknyényba vémarék yadan wupmalemu apa jébaa déku néwaageba kaapuk yadén, déké miték sanévéknwumarék yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wani tulé Galilina képmaaba rakwa du taakwa deku némaan ban déku yé Yerot Jisaské kudi wakwedaka dé véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Véknwute dé déku jébaa yakwa duwat wak, “Wani du wan gu yaakutaknan du Jon dé. Déknyényba wuné wawuréka de déku maakna tépaknék. Tépakdaka kiyae bulaa débu nébéle raapmék. Nébéle raapme dé némaa apa kérae wani apa jébaa dé yo.” Naate dé Yerot wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Déknyényba Yerot dé déku némaadu Pilipna taakwat yak. Wani taakwana yé Yerodias. Yadéka dé Jon dérét wak, “Ména némaadu radéka déku taakwat yaménén wan sépélak méné yak. Got wani muké dé waatiyu.” Naate wadéka Yerodias Jonna kudiké kélik yate waléka Yerot léku kudi véknwute wadéka de déku du yae Jonét kulékiye baagwit gitakne dérét de kure yék raamény gat. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kure yédaka raamény gaba kwaadéka Yerot dérét viyaapérekgé mawulé dé yak. Judana du taakwa de wak, “Jon wan Gotna yéba kudi wakwekwa du dé.” Naate wadaka Yerot dé Jonét viyaapérekmuké wup dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nak nyaa de du las yae Yerot wale jawe rate Yerotna néwaa dérét kéraalén nyaaké sanévéknwute de kadému kak. Kadaka Yerodiasna takwanyan yae wani duna méniba téte lé kétik. Kétiléka Yerot véte dé mawulat kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yate dé lérét wak, “Gwalmu las kwayéwuruké mawulé yanyénéran wani gwalmu kwayéké wuné yo. Wawurén pulak yaké wuné yo. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naate wadéka lé ye léku néwaat wak, “Dé wunéké gwalmu tiyaaké dé wak. Samu gwalmuké wakweké wuné yo?” Naate waléka lé léku néwaa Jon déknyényba wadén kudiké wekna kélik yate lé wak, “Gu yaakutaknakwa du Jon, déku maakna. Waga kéraanyénu wuné kiyaadénké kutdéngké wuné yo.” Naate waléka léku takwanyan yae lé Yerotnét wak, “Gu yaakutaknakwa du Jonna maakna tépakne agérapba takne méné wunéké tiyaaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Naate waléka dé Yerot waga yamuké kélik yate dé sanévéknwu wanévéknwuk, taknaba adél kudi wadéka dé wale rate kadému kan du véknwudan bege. Sanévéknwute, nak pulak kudi wakwemuké kélik yate dé kusékérék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kusékéttakne dé wadéka déku du ye raamény gat wulae de Jonna maakna tépaknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tépakne maakna agérapba takne de wani taakwaké kure yékwek. Kure yékwedaka lé léku néwaaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Waga yadaka Jonna du yae déku gaaba ségwi kérae kure ye de rémék. Rémtakne ye de Jisasnyét wani muké saapék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas wani kudi véknwutakne dé wani gayé kulaknyénytakne botba waare dé du ramarék taalat yék. Dé kapmu dé yék, botba. Yédéka du taakwa déké kudi véknwutakne deku gayé kulaknyénytakne de képmaaba dé yénét de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yédaka Jisas kwawu maalat yae bot kulaknyénytakne dé vék wupmalemu du béré taakwa bérat. Véte deké mawulé lékte dé kiyakiya yan du taakwa baadi, sépékwaapa kapére yan du taakwa baadit wawo kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Garabu yadéka de Jisasna du déké yae de dérét wak, “Garabu déwa yakwa. Kén du ramarék taalé. Méné waménu kéni du béré taakwa béré de gayét yéké yo. Ye de deku kadému kéraaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naate wadaka dé derét wak, “De yédoké wuné wamarék yaké wuné yo. Guné deké kadému kwayéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naate wadéka de wak, “Naané wupmalemu kadému kaapuk. Makwal béret naktaba guba kutdan gukwami vétik waga male dé ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naate wadaka dé wak, “Mé kure yaa wunéké.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Waga wadéka kure yédaka dé waba tén du taakwat wak, waaraba radoké. Wadéka radaka dé makwal béret naktaba gukwami vétik kérae kure téte nyérét kwaasawuré véte dé Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayék. Kwayédéka de du taakwaké munikwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Munikwedaka de akwi du béré taakwa béré mitékne kak. Kadaka béret las radéka de Jisasna du de kébi taaba vétik sékét maanba kayék vétik (12) waga de laakwa sékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wani béret kan du wupmalemu (5,000 pulak). Wupmalemu taakwa baadi wawo waba de rate kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisasna du waga yadaka Jisas dé derét wak, “Guné botba waare guné taale yéké yo, kwawu nak saknwat.” Naate wadéka déku du yédaka dé wani du taakwat wak, deku gayét yédoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wadéka yédaka Got wale kudi bulké nae dé kapmu dé nébat waarék. Waarédéka nyaa dawulidéka dé kapmu dé rak nébuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Radéka déku du ran bot ye lé nyédé kwawuba téléka wimut kutdéka lé bot némaanba lé waaré giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yaléka yé tékgé yadéka dé Jisas gu takuba déku duké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yédéka de dérét véte kwagénék. Kwagénte de wak, “Wan gaababan dé nak yao.” Waga wate wupmét kapére yate de némaanba gureknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gurekdaka dé Jisas derét bari wak, “Kén wuné wuné yao. Guné wup yamarék yaké guné yo. Yéknwun mawulé yaké guné yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wani kudi wadéka dé Pita Jisasnyét wak, “Némaan Ban, wan méné yaaménéran méné wunat waménu wuné gu takuba ménéké yaaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Naate wadéka dé wak, “Méné mé yaa.” Naate wadéka dé bot kulaknyénytakne dawuliye gu takuba batnyé yéte dé Jisas ténét yéké mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yate wimut kutdéka apakélé gu raapdéka véte dé wup yak. Wup yate dé guba dawuliké yak. Yate némaanba dé wak, “Némaan Ban, wunat mé kuttiyaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Naate wadéka dé dérét bari kutte dé wak, “Samuké méné ména mawuléba wak, ‘Jisas wunat kuttiyaaké apa dé yo, kapu kaapuk?’ Waga wamarék yate wunéké mé miték sanévéknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Naate watakne dérét kwole ye botba waarébétka dé wimut kaapuk yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yadéka botba ran du de déku yéba kevérékte de wak, “Méné Gotna nyaan. Wan adél.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas déku du wale kwawu nak saknwat botba ye de Genesaretna képmaa saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Saabadaka de wani gayéba rakwa du taakwa Jisaské kutdéngék. Kutdéngte wani képmaaba rakwa du taakwat kudi wakwesatidaka de kiyakiya yan du taakwa baadi, sépékwaapa kapére yan du taakwa baadi wawo, derét de kure yék Jisaské. ");
INSERT INTO abt_maprik_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kure yédaka de deku mawuléba de wak, “Naané déku sépéba kutte yéknwun yaké naané yo. Déku sépéba kutké yapatite déku baapmu wutba male kutnaran yéknwun yaké naané yo.” Naate wate de Jisasnyét wak, “Méné kusékétménéran naané ména baapmu wutna waabuba male kutké naané yo.” Naate watakne de déku baapmu wutba kutte de yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wani tulé de Parisina du las, apa kudiké kutdéngkwa du las, waga de Jerusalem kulaknyénytakne Jisas wale kudi bulké de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ye de dérét wak, “Naana képmawaara de wak, ‘Kadému kaké yate taale wanan pulak guna taaba miték yakutnyéké guné yo. Waga yatakne guné Gotna méniba miték raké guné yo.’ Naate wadaka naané kadému kaké yate taale naané naana taaba wadan pulak miték yakutnyu. Samuké de ména du naana képmawaara wakwedan kudi véknwumarék yo? De kaké yate taale deku taaba naana képmawaara wadan pulak kaapuk miték yakutnyédakwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Naate wadaka dé derét wak, “Guné yaga pulak? Samuké guné guna képmawaarana kudi male véknwute guné Gotna kudiké kuk kwayu? ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Got kéga dé wak, ‘Guné guna néwepat kutkalé yaké guné yo.’ Naate watakne kéga wawo dé wak, ‘Du nak déku néwepaké kapéredi kudi buldéran guné wani dut viyaagunu dé kiyaaké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naate wadéka guné Gotna kudiké kuk kwayéte nak kudi guné wo. Guné kéga guné wo, ‘Du nak déku néwepat kéga wadéran, Kéni gwalmu Gotké wunébu kwayék. Gotké kwayémarék yawuru mukatik bénéké kwayékatik wuné yak. Bénat kutkalé yaké wuné yapatiyu. Naate wadéran déku néwepat kutkalé yamarék yadékwa wan yéknwun, Gotké kwayédén bege.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Guné waga wate guna képmawaarana kudi véknwute guné Gotna kudiké kuk kwayu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Guné yénaa yakwa du guné. Déknyényba Gotna yéba kudi wakwen du Aisaia kéni kudi wakwete dé adél kudi wakwek gunéké. Kéga dé wak: ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Got dé wak, ‘Kéni du taakwa de wunéké yéknwun kudi wakweyo. Waga wakwete de wunéké deku mawuléba kaapuk miték sanévéknwudakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","De deku apa kudi véknwute wadékwa pulak yate de wani kudiké wo: Wan Gotna kudi. Naate wate wuna yéba kevérékte de yaamabi kudi bulu.’ Naate Got wadéka Aisaia dé kavik.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wani kudi watakne Jisas dé du béré taakwa bérat waadéka yaadaka dé derét kéga kudi wakwek, “Guné wuna kudi mé miték véknwu. Véknwute kéni muké miték kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kagunékwa muké sanévéknwute Got wamarék yaké dé yo, ‘Guné kapéredi mu yakwa du taakwa guné.’ Bulgunékwa kapéredi kudiké sanévéknwute Got kéga waké dé yo, ‘Guné kapéredi mu yakwa du taakwa guné.’ Naate waké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Waga wadéka déku du déké yae de wak, “Parisina du de wakweménén kudiké kélik yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naate wadaka dé Jisas kéni aja kudi wakwek, “Awuréba rakwa ban wuna yaapa apakélé yaawi dé nak yak. Wupmalemu mi débu tawuk wani yaawiba. Tawumarék yadéka bakna wurén mi dé mégi wale pélké dé yo.” Naate dé Parisina duké wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wakwetakne dé kéga wakwek, “Guné Parisina duké sanévéknwu wanévéknwumarék yaké guné yo. De méni kiyaan du pulak de ro. Méni kiyaan du nak dé nak méni kiyaan dut yaabu wakwatnyéké mawulé yadéran bét ye vététi waaguba akéréké bét yo. Yadéran pulak Parisina du nak duwat Gotké yédakwa yaabu wakwatnyéké de yapatiyu.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wadéka dé Pita dérét wak, “Kanakwa muké wakweménén aja kudiké naanat wakweménu naané wani kudiké miték kutdéngké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naate wadéka dé wak, “Guné wawo wani kudiké kaapuk kutdénggunén, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mé véknwu. Du taakwa kadakwa mu deku biyaat dawuliye walkamu te dé yu. Kadakwa mu deku mawulé kaapuk yaalébaankwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Buldaran kudi taale du taakwana mawuléba dé tu. Du taakwana mawuléba yaalakwa muké sanévéknwute Got waké dé yo, ‘Wan kapéredi mu yakwa du taakwa.’ Naate waké dé yo, kéni muké kutdéngdén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Du taakwana mawuléba kapéredi mawulé dé yaalo. Yaaladéka de kapéredi mawulé véknwudakwa, du taakwat viyaapérekdakwa, du nak duna taakwa yadakwa, taakwa nak taakwana duké yédakwa, du taakwa wale kapéredi mu yadakwa, taakwa du wale kapéredi mu yadakwa, sél yadakwa, yénaa kudi wakwedakwa, nak du taakwaké kapéredi kudi wakwedakwa, waga de kapéredi mu yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wani kapéredi mawulé dé du taakwana mawuléba yaalo. Yaaladéka de wani kapéredi mu yo. Kapéredi mu yadaka Got dé deké wo, ‘Wan kapéredi mu yakwa du taakwa de.’ Naate wate dé yadan kapéredi mawuléké sanévéknwu. De képmawaarana kudi véknwumarék yate deku taaba miték yakutnyémarék yadanké kaapuk sanévéknwudékwa.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wani kudi watakne dé Jisas déku du wale waga de wani gayé kulaknyénytakne de nak taalat yék. Taia tédéka Saidon tédéka wani taalat de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yédaka lé Kenanba yaan taakwa nak lé yaak. Lé Judana taakwa ramarék yate nak geba yaan taakwa rate lé Jisaské yaak. Yae lé némaanba waate lé wak, “Némaan Ban, méné Devitna képmawaara méné ro. Méné wunéké mé mawulé lékménu. Kutakwa nak wuna takwanyanna mawuléba wulae téte lérét lé yaalébaanu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Waga waléka dé Jisas kudi las kaapuk buldén. Yadéka déku du de dérét wak, “Wani taakwa naana kukba yaate némaanba lé waasaaku. Méné waménu lé léku gayét yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Naate wadaka dé wani taakwat wak, “Isrelna du taakwa wan sipsip deku mawulé yékéyaak yadéka bakna yeyé yeyadakwa pulak. Got wadék wuné derét male kutkalé yaké wuné yaak. Nyéné nak gena taakwa nyéné ro. Isrelna taakwa kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naate wadéka lé yae déké kwati yaane waadé daate lé wak, “Némaan Ban, wunat kutkalé yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Naate waléka dé déku mawuléba wak, “Naané Juda nak gena du taakwaké ‘Waasa’ naate naana du taakwaké ‘Baadi’ naané nao.” Naate watakne dé kéni aja kudi lérét wakwek, “Naané baadi kakwa kadému kérae makwal waasaké kwayénaran wan yéknwun mu kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Waga wadéka lé wak, “Némaan Ban, wan adél kudi méné wo. Wuné kéga wuné wo. Baadi kadému kadaka las képmaaba akérédéka de deku waasa kérae ko. Méné wunat kutkalé yaménéran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naate waléka dé wak, “Wuné nyéna takwanyanét kutkalé yaké apa yawurékwaké wate nyéné wunéké nyéné miték male sanévéknwu. Wan yéknwun. Mawulé yanyénékwa mu bulaa yaké wuné yo.” Waga wadén tulé lé léku takwanyan yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas wani gayé kulaknyénytakne dé képmaaba yék. Galilina kwawu tékwaba dé yék. Ye dé nébat nak waare dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Radéka de wupmalemu du béré taakwa béré déké yaak. Maan kapére yan du taakwa baadi, méni kiyaan du taakwa baadi, apa anygwa yan du taakwa baadi, kudi bulmarék du taakwa baadi, sépékwaapa kapére yan wupmalemu du taakwa baadi las wawo, wani du taakwa baadit akwi kérae yaate de Jisaské yaak. Yae de wani du taakwa baadit Jisasna maan wale taknak. Taknadaka dé derét kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kutnébuldéka de waba ran du béré taakwa béré de vék. Kudi bulmarék yan du taakwa baadi de kudi bulék. Apa anygwa yan du taakwa baadi deku apa kedéng dé ték. Maan kapére yan du taakwa baadi de yék. Méni kiyaan du taakwa baadi de vék. De waga yéknwun yadaka véte de sanévéknwu wanévéknwuk. Waga yate de wak, “Isrelna némaan ban Got derét débu mitékne yak.” Naate wate de Gotna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wupmalemu du taakwa waba tédaka Jisas déku duwat waadéka yaadaka dé derét wak, “Wuné wani du taakwaké wuné mawulé léknu. Nyaa kupuk de wuné wale rak. Deku kadému debu kawurék. De kaadé wale de ro. De kaadé wale re deku gayét yédoké wamuké kélik wuné yo. Kaadé wale ye yaabuba kiyaaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naate wadéka de déku du wak, “Kéni taaléba du las kaapuk radakwa. Wani du taakwa wan wupmalemu. Yaba béret las kérae wani du taakwaké kwayéno kaké de yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Naate wadaka dé derét wak, “Béret yagap dé ro?” Naate wadéka de wak, “Makwal béret nak taaba sékét nak taababa kayék vétik, guba kutdan makwal gukwami walkamu dé ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naate wadaka dé wani du béré taakwa bérat wak, képmaaba radoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wadéka radaka dé wani makwal béret gukwami wawo kérae dé Gorét wak, “Yéknwun mu naanéké ménébu tiyaak. Wan yéknwun.” Waga watakne wani béret gukwami wawo bule dé déku duké kwayék. Kwayédéka de akwi du taakwaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kwayédaka de akwi mitékne kak. Kadaka kadému las radéka de kébi nak taaba sékét nak taababa kayék vétik waga de laakwa sékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wani kadému kan du wan wupmalemu (4,000). Wupmalemu taakwa baadi wawo de waba rate kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","De akwi waga kabutidaka dé Jisas du béré taakwa bérat wadéka de deku gayét yék. Yédaka dé botba nak waare dé Magadanna képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisina du las Sadyusina du las waga de yék Jisaské. Ye deku mawuléba de wak, “Got wadék dé Jisas yaak, kapu bakna naané pulak du dé?” Naate sanévéknwute de dérét wak, “Méné déknyényba vémarék yanan apa jébaa nak yaménu naané véké naané yo. Waga véte naané kutdéngké naané yo. Got wadéka méné yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naate wadaka dé derét wak, “Garabu yadéka nyaa dawulidéka nyét gwaavé yadéka véte guné wo, ‘Nyét gwaavé dé yo. Yadu séré yéknwun nyaa véké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Naate watakne guné ganbaba nyét gélé yadéka véte guné wo, ‘Nyét gélé dé yo. Bulaa wimut kutdu maas viyaaké dé yo.’ Naate guné wo. Guné nyérét véte guné kutdéngék wimut maaské. Guné yawurékwa apa jébaa véte guné wunéké kutdéngké guné yapatiyu. Guna mawulé yékéyaak dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kéni tulé rakwa du taakwa de kapéredi mu de yasaaku. De kuk debu kwayék Gotké. Wunat wagunén apa jébaa, déknyényba vémarék yagunén apa jébaa, yamarék yaké wuné yo. Kéga male yaké wuné yo. Déknyényba ran du Jona yadén pulak wuné yaké wuné yo.” Naate watakne dé Jisas derét kulaknyénytakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas déku du wale de kwawu nak saknwat yék. Ye saabe déku du de wak, “Naané béret kaapuk kure yaanan. Yékéyaak naané yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Naate wadaka Jisas dé derét kéni aja kudi wakwek, “Guné jérawu yaké guné yo. Parisina du Sadyusina du wawo deku yis kutmarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naate wadéka de deku kapmu bulte de wak, “Naané béret las kaapuk kure yaanan. Waga yananké dé béret apakélé yaduké kutdakwa mu yiské dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Waga buldaka dé kutdéngte dé wak, “Samuké guné kéga wo? ‘Naané béret kaapuk.’ Wuné gunat kutkalé yawuréranké kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Guné wuna apaké kaapuk wekna miték kutdénggunén. Déknyényba wupmalemu (5,000) duké makwal béret naktaba kwayéwuréka mitékne kadaka béret las radéka wupmalemu kébi laakwagunénké guné sanévéknwu, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nak apu wupmalemu (4,000) duké makwal béret nak taaba sékét nak taababa kayék vétik kwayéwuréka béret las radéka wupmalemu kébi laakwagunénké guné sanévéknwu, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Miték sanévéknwute kutdéngké guné yo. Wuné wupmalemu béret yaaladuké wuné apa wuné yak. Yate wuné yiské wekna wakwete wuné béretké kaapuk sanévéknwurén. Parisina du Sadyusina du deku yiské jérawu yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naate wadéka de kutdéngék. Dé béretba kutdakwa yiské kaapuk wakwedén. Dé Parisina du Sadyusina du deku kapéredi kudi véknwumarék yadoké dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas déku du wale de Sisaria Pilipaina képmaat yék. Ye dé Jisas déku duwat wak, “Wuné Akwi Du Taakwana Nyaan wuné ro. Wunéké du taakwa yaga de wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Naate wadéka de wak, “Ménéké las de wo, ‘Wan gu yaakutaknan du Jon dé.’ Las de wo, ‘Wan déknyényba rate Gotna yéba kudi wakwen du Ilaija.’ Las de wo, ‘Wan Gotna yéba déknyényba kudi wakwen du déku yé Jeremaia.’ Las de wo, ‘Jeremaia kaapuk. Gotna yéba déknyényba kudi wakwen nak du.’ Naate de ménéké wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naate wadaka dé derét wak, “Guné yaga pulak? Guné wunéké yaga guné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Naate wadéka dé Saimon Pita wak, “Méné naanat kutkalé yaménuké Got wadén ban Krais. Méné apuba apuba rasaakukwa ban Gotna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Naate wadéka dé wak, “Jonana nyaan Saimon, méné yéknwun mawulé méné yo. Kéni képmaaba rakwa du wunéké wakweménén kudi ménat kaapuk wakwedan. Awuréba rakwa ban wuna yaapa Got déku kapmu dé ménat wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kén ménat wuné wakweyo. Ména yé Pita. Naana kudi kéga: Matu. Wani apakélé matu takuba wuna jébaaba yaalan du taakwat taknaké wuné yo. Taknawuru du taakwa kiyaadakwa paaté nak kapéredi mu wawo wuna du taakwat yaalébaanmarék yaké dé yo. De miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wuna apa ménéké kwayéké wuné yo. Kwayéwuru méné waménu nak du taakwa Gotna kémba yaalaké de yo. Méné kéni képmaaba téte ‘Kaapuk’ naaménékwa muké Got déku gayéba rate wani muké ‘Kaapuk’ naaké dé yo. Méné kéni képmaaba téte, kusékétménékwa muké Got déku gayéba rate, wani muké kusékétké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naate watakne dé déku duwat wak, “Mé véknwu. Guné nak duwat kéga wamarék yaké guné yo, ‘Jisas wan naanat kutkalé yaduké Got wadén ban Krais.’ Waga wamarék yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wani tulé dé Jisas taale kéni kudi dé déku duwat wakwek, “Wuné Jerusalemét waaréwuru de kubu du, nyédé duna némaan du, apa kudiké kutdéngkwa du, waga de wunat kapéredi mu yaké de yo. Ye wunat viyaapérekdo kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu Got wadu wuné tépa nébéle raapké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naate wadéka Pita dérét kure ye bét kapmu téte dé wak, “Némaan Ban, méné waga wamarék yaké méné yo. Got wani kapéredi muké kusékétmarék yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naate wadéka dé walaakwe dé Pitat wak, “Méné Seten, méné mé yaage yé. Méné wuna jébaa méné taknatépu. Méné Gotna kudi kaapuk véknwuménékwa. Méné kéni képmaaba rakwa duna kudi méné véknwu.” Naate dé Jisas Pitat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wani kudi watakne Jisas déku duwat dé wak, “Guné wuné wale yaate wuna jébaa yaké mawulé yagunéran kéga yaké guné yo. Guné guna mawulé kulaknyényké guné yo. Kulaknyénye guné wunéké sanévéknwute kéga waké guné yo, ‘Naané déku jébaa kutsaakuké naané yo. Yate naané kaagél kutte miba kiyaanaran wan bakna mu. Némaa mu kaapuk.’ Naate wate wuna jébaa kutké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wunéké sanévéknwukwa du taakwa wuna jébaa kutsaakudo wuna maama derét viyaapérekdaran de wuné wale miték rasaakuké de yo apuba apuba. Wunéké sanévéknwumarék yakwa du taakwa deku sépéké male sanévéknwute deku jébaa male yadaran de kiyae yalakgé de yo. Wuné wale rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Du taakwa kéni képmaana gwalmu akwi kéraaké sanévéknwute, deku jébaa male yadaran, kiyae yaga pulak de miték rasaakuké de yo? Kaapuk. Miték rasaakumarék yaké de yo. De Gotna gayét yéké mawulé yadaran yéwaa kwayéké de yo, kapu yaga pulak? Kaapuk. De yémarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kukba wuna yaapa Got wunéké apa tiyaate wadu wuné Akwi Du Taakwana Nyaan nyaa vékwa pulak rate giyaaké wuné yo. Gotna kudi kure giyaakwa du wale giyaaké wuné yo. Giyae akwi du taakwa yadan mu kaataké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kéni kudi mé véknwu. Guné kéba tékwa du las kiyaamarék ye wekna rate véké guné yo, wuné némaan ban rate apa yate yaawuru. Akwi Du Taakwana Nyaan wuné yaawuru véké guné yo. Adél wuné gunat wakweyo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nyaa nak taaba sékét nak taababa kayék nakurak yédéka dé Jisas, Pita, Jems, Jemsna wayékna Jonét waga kwole de apakélé nébat nak waarék. Waare de kapmu de waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Rate védaka Jisasna sépé walaakwe dé nak pulak yak. Yadéka déku ménidaama nyaa pulak dé vék. Védéka déku baapmu wut waamat kapére yate dé kayénarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yadéka déknyényba rate Gotna yéba kudi wakwen du Moses bét Ilaija Gotna gayéba giyae Jisas wale kudi buldaka de Jisasna du kupuk vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita derét véte dé Jisasnyét wak, “Némaan Ban, naané kéba ranakwa wan yéknwun. Méné mawulé yaménéran wuné ga kupuk kéba kaaké wuné yo. Ménéké nak, Moseské nak, Ilaijaké nak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wani kudi wekna wadéka dé waamat kapére yakwa buwi nak giyae dé derét taknatépék. Taknatépédéka dé kudi nak buwiba gwaade dé wak, “Kén wuna nyaan. Déké wuné mawulat kapére yo. Déké wuna mawulé yéknwun dé yo. Guné déku kudi mé véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wani kudi véknwutakne Jisasna du de wupmét kapére yate kwati yaane waadé daate képmaaba de vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Védaka dé Jisas deké yae derét kutte dé wak, “Guné mé raap. Wup yamarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naate wadéka raapme nak duwat kaapuk védan. Jisasnyét male de vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","De wani nébu kulaknyénytakne dawulite dé Jisas derét wak, “Mé véknwu. Guné végunén muké nak duwat bulaa wakwemarék yaké guné yo. Wuné Akwi Du Taakwana Nyaan kiyaawuru Got wadu wuné nébéle raapwuru guné wani tulé wani muké wakweké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naate wadéka de déku du dérét wak, “Apa kudiké kutdéngkwa du de kéga wo, ‘Gotna yéba déknyényba kudi wakwen du Ilaija taale yaaké dé yo. Yaadu Got wadén ban Krais kukba yaaké dé yo.’ Samuké de waga wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naate wadaka dé wak, “Wan adél kudi de wo. Ilaija taale yaaké dé yo. Yae dé Kraisna yaabu kutké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gunat wuné wakweyo. Ilaija débu yaak. Yaadéka du taakwa déké kutdéngmarék yate de dérét kapéredi mu de yak. Dérét yadan pulak wuné Akwi Du Taakwana Nyaan wunat kapéredi mu yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naate wadéka de wak, “Dé Ilaijaké wakwete dé gu yaakutaknan du Jonké dé wakwek.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas, Pita, Jems, Jon, waga dawuliye de déku du las wawo wupmalemu du béré taakwa béré wawo jawe tén saabak. Saabadaka dé du nak Jisaské yae dé déké kwati yaane waadé daak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Waadé daate dé wak, “Némaan Ban, méné wuna nyaanké mawulé lékgé méné yo. Nak apu nak apu dé waagété yate dé aki kiyao. Aki kiyae wupmalemu apu dé yaaba akére dé guba wawo dé akéru. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yadéka wuné ména duké kure yéwuréka de dérét kutnébulké de yapatik.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Naate wadéka dé Jisas wak, “Yaga pulak? Guné wunéké miték kaapuk sanévéknwugunékwa. Guna mawulé kaapuk miték tékwa. Wuné wupmalemu baapmu guné wale rawuréka guné wunéké kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Guné wani nyaanét wunéké mé kure yaa.” Naate wadéka kure yédaka dé Jisas wani nyaanét kure tén kutakwat waatidéka lé wani nyaanét bari kulaknyénytakne yaage yék. Yaage yéléka dé wani nyaan yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kukba Jisas kapmu radéka de déku du déké ye de dérét wak, “Naané wani kutakwat wanaka lé yaage yémarék yak. Samuké naané wani jébaa yaké naané yapatik?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Naate wadaka dé derét wak, “Guné waga yaké guné yapatik, guné Gotké miték sanévéknwumarék yagunékwa bege. Mé véknwu. Guné Gotké walkamu sanévéknwugunéran guné déké walkamu yéknwun mawulé yaké guné yo. Guné Gotké walkamu yéknwun mawulé yagunéran guné apa jébaa yaké guné yo. Kéni nébu mé vé. Guné Gotké walkamu yéknwun mawulé yagunu, guna yéknwun mawulé makwali sék pulak makwali male tédu, kéni nébu raapme yéduké Gorét waatagunéran, kéni nébu raapme yéké dé yo. Guné déké miték sanévéknwusaakute dérét waatagunéran guné déknyényba vémarék yadan apa jébaa las wawo yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Guné kutakwa yaage yédoké waké mawulé yagunéran guné kadému kamarék yate wani muké Gorét waataké guné yo. Waga yagunu de yaage yéké de yo. Waga yamarék yagunéran de yaage yémarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas déku du wale Galilina taaléba yeyé yeyate Jisas dé derét wak, “Kukba de wuné Akwi Du Taakwana Nyaanét maamaké kwayédo wuné deku taababa raké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rawuru wunat viyaapérekdo kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu Got wadu wuné tépa nébéle raapké wuné yo.” Naate wadéka de wani muké némaa mawulé léknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas déku du wale de Kapaneamét de yék. Ye saabadaka de Gotna kudi buldakwa némaa gaké takis nyégélkwa du Pitaké yae de dérét wak, “Guna némaan ban Gotna kudi buldakwa némaa gaké takis las dé kwayu, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naate wadaka dé Pita wak, “Ao. Dé kwayu.” Naate watakne gaba wulae Jisasnyét wani kudi wekna wakwemarék yadéka Jisas dé dérét waatak, “Saimon, yaga méné sanévéknwu? Kéni képmaaba rakwa némaan du kiyadat de takis nyégélu? Deku kémna du taakwat de nyégélu, kapu nak gena du taakwat de nyégélu?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naate wadéka dé Pita wak, “Nak gena du taakwat male de takis nyégélu.” Naate wadéka dé Jisas wak, “Wan adél. Némaan duna kém deku du taakwa takis deké kaapuk kwayédakwa. Wuné Gotna nyaan wuné ro. Wuné déku gaké takis kwayémarék yawuréran wuné déku nyaan rawurékwaké sanévéknwute dé wunat waatimarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wuné déku gaké kwayémarék yawuréran nak du taakwa de wunéké kapéredi mawulé yate wunat waatiké de yo. Deku mawulé miték témarék yamuké wuné wawo takis kwayéké wuné yo. Méné ye méné kwawuba gukwami wuréké yo. Taale wuréménéran gukwami kérae méné léku kudiba yéwaa nak véké méné yo. Vétakne kérae kure yae méné deké kwayéké yo. Kwayéménéran yéwaa wan ana takis, Gotna kudi buldakwa némaa gaké.” Naate dé Jisas Pitat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wani tulé de Jisasna du déké yae de dérét wak, “Kiyadé akwi némaan duwat talakne némaan ban ro, Gotna kémba?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naate wadaka dé Jisas deku nyaanét nak waadéka yae dé deku nyédéba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tédéka dé derét wak, “Mé véknwu. Guna kapéredi mawulé kulaknyénye guné yéknwun mawulé yaké guné yo. Guna mawulé makwal baadina mawulé pulak témarék yadéran, guné Gotna kémba yaalamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kéni nyaan dé déku yéba kaapuk kevérékdékwa. Déku mawulé miték dé tu. Déku mawulé tékwa pulak deku mawulé miték tékwa du taakwa, de deku yéba kevérékmarék yate Gotna kémba rate, némaan du némaa taakwa raké de yo. De nak némaan du némaa taakwat wawo talaknaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Du taakwa wunéké miték sanévéknwute kéga pulak nyaanét kutkalé yate de wunat wawo kutkalé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wani kudi watakne dé kéga wakwek: “Kéni makwal baadi de wuna kudi miték véknwu. De dut nak déku kwaaléba apakélé matu gitakne dérét yatjadado dé géléguba dawuliye gu ke kiyaadu mukatik wan kapéredi mu. Du nak wakwedu wani baadi nak déku kudi véknwute wuna kudi kulaknyénydéran Got waga wakweran dut yadén kapéredi mu némaanba yakataké dé yo. Wan apakélé kapéredi mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Wupmalemu du taakwa de kéni képmaana kapéredi muké male sanévéknwute de wuna kudiké yékéyaak yo. Wani du taakwaké wuné mawulé léknu. Du las wado wuna kudi véknwukwa du taakwa deku kudi véknwute wunéké kuk tiyaadaran derét waga wan du deku mawulé de yaalébaanu. Wan apakélé kapéredi mu. Got waga wakweran duwat yadan kapéredi mu némaanba yakataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Guna maan taaba kapéredi mu yaké yadéran guné wani maan taaba tépakne yatjadaké guné yo. Guna nakurak maan nakurak taaba male tédu wani kapéredi mu yamarék yate Gotna kémba yaalagunéran wan yéknwun. Guna maan vétik taaba vétik tédu guné wani kapéredi mu yatakne kukba yaa yaansaakukwa taalat dawuligunéran wan kapéredi mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Guné guna méni kapéredi mat véte wani kapéredi mu yaké mawulé yagunéran wani méni pékwe yatjadaké guné yo. Guna nakurak méni male tédu wani kapéredi mu yamarék yate Gotna kémba yaalagunéran wan yéknwun. Guna méni vétik tédu guné wani kapéredi mu yatakne kukba yaa yaansaakukwa taalat dawuligunéran wan kapéredi mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mé véknwu. Wani makwal baadiké kuk kwayémarék yaké guné yo. Deké kéga wamarék yaké guné yo, ‘De makwal baadi male. Deké sanévéknwumarék yaké naané yo.’ Naate wamarék yaké guné yo, awuréba rakwa ban wuna yaapa Gotna kudi kure giyaakwa du deké miték védakwa bege. Wani du déku méniba rasaakudaka dé wani baadit kutkalé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wuné Akwi Du Taakwana Nyaan yalaknén du taakwat Setenna taababa kérae derét kutkalé yaké wuné kéni képmaat giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kéni aja kudiké mé sanévéknwu. Du nak dé wupmalemu (100) sipsipké téségu. Nakurak sipsip yalakdéran wani du samu yaké dé yo? Dé yalaknén sipsipké sékalké dé yo, kapu yaga pulak? Déku nak sipsip nébuba waara wekna kado dé derét kulaknyénytakne ye yalaknén sipsipké sékalké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sékale vétakne dé wani sipsipké duséknét kapére yaké dé yo. Dé wale ran sipsipké dusék yate yalaknén sipsipmét véte dé duséknét kapére yaké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wani kudiké sanévéknwute guné kutdéngké guné yo. Wani du sipsipké miték védékwa pulak, awuréba rakwa wuna yaapa dé du taakwaké miték vu. Véte wani makwal baadi nak yalakne kapéredi taaléba rasaakumuké dé kélik yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wani kudi watakne dé Jisas kéga wakwek: “Guné wuna jébaaba yaalan du, guné nak nak mé véknwu. Wuna jébaaba yaalan nak du ménat kapéredi mu yadéran méné déké ye béné kapmu rate méné dérét waké méné yo, ‘Méné wunat kapéredi mu ménébu yak.’ Naate waké méné yo dérét. Nak du taakwat wani muké wakwemarék yaké méné yo. Méné déké ye dérét waménu dé ména kudi véknwute ménat yadén kapéredi mu kulaknyénydéran wan yéknwun. Béné vététi nakurak mawulé yate miték raké béné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dé ména kudi véknwumarék yadéran méné wuna jébaaba yaalan du vétiknét wawo kwole guné déké tépa yé dérét tépa waké méné yo, ménat yadén kapéredi muké. Waga yaménéranké déknyényba du nak kéni kudi Gotna nyégaba dé kavik: Du vétik kupuk nakurak kudi wakwedaran wan yéknwun. Nak du wani kudi véknwuké de yo. Kavidén kudiké sanévéknwute méné du vétiknét kwole guné akwi ménat kapéredi mu yan duna kudi véknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Méné bérét kwole ménat kapéredi mu yan dut kudi wagunu dé guna kudi véknwumuké kélik yadéran méné wuna jébaaba yaale jawe rakwa du taakwat wakweké méné yo, ménat yadén kapéredi muké. Wakweménu de wani muké dérét wakwedo dé deku kudi wawo véknwumuké kélik yadéran guné akwi dérét waké guné yo, dé gunat kulaknyénytakne yéduké. Nak gena du, takis nyégélte kapéredi mu yakwa du wawo wuna jébaaba yaalamarék yate séknaaba radakwa pulak, dé wawo gunat kulaknyénytakne ye séknaaba raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Gunat wuné wakweyo. Guné kéni képmaaba téte ‘Kaapuk’ naagunékwa muké Got déku gayéba rate wani muké ‘Kaapuk’ naaké dé yo. Guné kéni képmaaba téte kusékétgunékwa muké Got déku gayéba rate wani muké kusékétké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nak kudi wawo gunat wuné wakweyo. Guna du vétik nakurak mawulé yate awuréba rakwa ban wuna yaapa Gorét waatabéru dé bétku kudi véknwute waatabérén pulak yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wani kudi wuné wo, du vétik kupuk wunéké sanévéknwute nakurak mawulé yate nakurak taaléba radaka wuné de wale rawurékwa bege.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisaské ye dé dérét wak, “Némaan Ban, wuna du wunat kapéredi mu yasaakudu wuné dérét waké wuné yo, ‘Wani muké tépa sanévéknwumarék yaké wuné yo. Dékumuk.’ Wani kudi apu nak taaba sékét nak taababa kayék vétik waké wuné yo, kapu apu yagap?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Naate wadéka dé Jisas dérét wak, “Wuné apu nak taaba sékét nak taababa kayék vétik waga waménuké kaapuk wawurékwa. Ména du wupmalemu apu ménat kapéredi mu yadu méné apuba apuba dérét waké méné yo, ‘Wani muké tépa sanévéknwumarék yaké wuné yo. Dékumuk.’ Naate wate wani kudi kulaknyénymarék yaké méné yo. Waga waménéran apu naaknwuké méné yapatiké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wani kudi Pitat watakne dé kéni aja kudi wakwek: “Got némaan ban rate déku kémké miték véte kéga yaké dé yo. Némaan ban nak dé wak, ‘Wupmalemu jébaa yakwa duké wuné yéwaa kwayék. Kwayéwuréka de wani kwaabu kaapuk tiyaakatadan. Bulaa de wuna yéwaa tiyaakatadoké wuné mawulé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Naate watakne dé derét wak, waga kwayékatadoké. Wadéka de dut nak déké kure yék. Wani du wupmalemu yéwaa dé nyégélék. (10 milion kina). ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wani du yéwaa las kaapuk kure yédén. Wani yéwaa kwayékataké dé yapatik. Yapatidéka dé némaan ban wak, de wani du, déku taakwa, déku baadi, déku akwi gwalmu nak duké kwayétakne yéwaa nyégéle déku yéwaa kwayékatadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Waga wadéka dé wani du némaan ban ranba kwati yaane waadé daate dé wak, ‘Némaan ban, méné wunéké mawulé lékte wunéké raségéké méné yo. Kukba wuné ména yéwaa akwi kwayékataké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naate wadéka dé wani jébaa yakwa duna némaan ban déké mawulé lékte dé dérét wak, ‘Dékumuk. Wani kwaabu tiyaakatamarék yaké méné yo. Méné bakna yéké méné yo.’ Naate dé némaan ban wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wani jébaa yakwa du kaapat gwaade dé dé wale jébaa yakwa dut nak vék. Wani du dérét walkamu yéwaa nyégéle dé wani kwaabu kaapuk kwayékatadén. Vétakne dé dérét kulékiye dé déku kwaaléba némaanba kutte dé wak, ‘Méné wunat nyégélménén yéwaa akwi bulaa tiyaakataké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naate wadéka dé wani du kwati yaane waadé daate dé wak, ‘Méné wunéké mawulé lékte wunéké raségéké méné yo. Kukba wuné ména yéwaa kwayékataké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naate wadéka dé kélik yak. Kélik yate dé dérét kure ye kotimtakne raamény gaba taknak. Takne dé dérét wak, ‘Méné wuna yéwaa tiyaakatatakne méné raamény ga kulaknyénytakne yaalaké méné yo.’ Naate wadéka dé raamény gaba kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Dé wale jébaa yan du véte de déké némaa mawulé léknék. Mawulé lékte de deku némaan banét wani muké akwi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wakwedaka dé némaan ban waadéka wani du yaadéka dé dérét wak, ‘Méné kapéredi mu male yakwa du. Taale méné wunat waataménéka wunat nyégélménén apakélé yéwaaké wuné wak, Dékumuk. Wani kwaabu tiyaakatamarék yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naate wate ménéké wuné mawulé léknék. Samuké méné wuné yan pulak méné wale jébaa yan duké mawulé lékmarék yak? Méné déké mawulé lékmarék ye méné kapéredi mu yakwa du méné ro.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naate watakne dé rékaréka yate wani dut dé raamény gaba taknak. Takne dé dérét wak, ‘Wuna yéwaa akwi tiyaakatatakne méné raamény ga kulaknyénytakne yaalaké méné yo.’ Naate dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Wani kudi watakne dé Jisas wak, “Guné wani kudiké mé sanévéknwu. Nak du gunat kapéredi mu yado guné waké guné yo, ‘Dékumuk. Wani kapéredi muké tépa sanévéknwumarék yaké naané yo.’ Guné waga wamarék yagunéran Got yagunén kapéredi muké apuba apuba sanévéknwuké dé yo. Sanévéknwute wani kapéredi mu yatnyéputimarék yaké dé yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas wani kudi wakwebutitakne dé Galilina képmaa kulaknyénytakne dé Jodan kaabéléba atiye Judiana képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yédéka wupmalemu du béré taakwa béré de déku kukba yék. Yédaka dé wani taaléba kiyakiya yan du taakwa, sépékwaapa kapére yan du taakwat wawo dé kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisina du las de Jisaské yék. Deku mawuléba de wak, “Naané dérét nak muké waatanaran sal dé kapéredi kudi wadu naané dérét kotimké naané yo?” Naate sanévéknwute de dérét wak, “Naana apa kudi yaga dé wo? Du nak déku taakwa dérét kulaknyénytakne yéluké wadéran wan yéknwun, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naate wadaka dé derét wak, “Samuké guné wunat waato wani muké? Déknyényba Gotna nyégaba du nak wani muké kudi kavidéka gunébu vék. Kéga dé kavik: Déknyényba batnyé Got akwi mu kuttakne dé du taakwat wawo dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yatakne dé wak, ‘Du déku néwepat kulaknyénytakne taakwa ye bét nakurakba raké bét yo. Rate nakurak sépé ye raké bét yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wani kudiké sanévéknwute naané kutdéngék. Du taakwa ye bét nakurakba bét ro. Nakurak sépé ye bét ro. Sépé vétik kaapuk. Got bétké dé wo, ‘Nakurak sépé ye bét ro.’ Naate wadékwaké du nak déku taakwat wamarék yaké dé yo, lé dérét kulaknyénytakne yéluké.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wani kudi wadéka de Parisina du wak, “Moses nak pulak kudi dé wakwek. Déknyényba dé kéga wakwek, ‘Du nak déku taakwa dérét kulaknyénytakne yéluké wadéran dé taale nyéga nak kaviké dé yo wani muké. Kavitakne léké kwayétakne wadu lé dérét kulaknyénytakne yéké lé yo.’ Waga dé Moses wakwek. Samuké dé Moses waga wakwek?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Naate wadaka dé derét wak, “Guné akwi kapéredi mawulé yakwa du taakwa ragunéka dé Moses gunéké wani kudi wakwek. Déknyényba batnyé du deku taakwat waga kaapuk wadan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wuné gunat kéga wuné wakweyo. Duna taakwa nak du wale kapéredi mu yamarék yalu, léku du lé dérét kulaknyénytakne yéluké bakna watakne, dé nak taakwa yadéran, wani du dé kukba yadén taakwa wale bét kapéredi mu yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wani kudi wadéka Jisasna du de dérét wak, “Naana du taakwa kéga de yo. Du nak taakwa ye kukba lé dérét kulaknyénytakne yéluké mawulé yadéran, dé wadu lé dérét kulaknyénytakne yéké lé yo. Méné méné wo, ‘Du déku taakwa dérét kulaknyénytakne yéluké bakna wamarék yaké dé yo.’ Méné waga waménékwaké naané bulaa naana mawuléba naané wo: Du taakwa yamarék yate bakna tédaran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naate wadaka dé derét wak, “Du las waga yaké de apa yo. Bakna tédoké Got deké dé apa kwayu. Wupmalemu du bakna téké de yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kéni du de taakwa yamarék yo. Du las deku néwaa kéraadaka deku sépé kapéredi yadéka de taakwa yaké de yapatiyu. Du las deku sépé nak du sékudak de taakwa yaké de yapatiyu. Du las Gotna jébaaké male sanévéknwute de taakwa kaapuk yadakwa. Wani kudi véknwute waga yaké mawulé yaran du de wani kudi miték véknwuké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Du taakwa las de makwal baadit Jisaské kure yék, dé derét taabat kutte deké Gorét waataduké. Kure yédaka de Jisasna du derét waatik. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Waatidaka dé Jisas derét wak, “Makwal baadi wunéké de mé yao. Yaado guné derét waatimarék yaké guné yo. Gotna kémba rakwa du taakwa wan wani makwal baadi pulak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naate wate dé deku maaknaba taaba kurék. Kuttakne dé wani taalé kulaknyénytakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nébikara du nak dé Jisaské ye dé wak, “Méné, Gotna jébaaké naanat yakwatnyékwa ban, samu yéknwun mu ye wuné kulé mawulé kérae apuba apuba miték rasaakuké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Naate wadéka dé Jisas wak, “Samuké méné yéknwun muké wunat waato? Got male dé yéknwun mu yakwa ban ro. Méné apuba apuba miték rasaakuké mawulé yaménéran Got wakwedéka Moses wakwen apa kudi mé véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naate wadéka dé wani du wak, “Samu kudi?” Naate wadéka dé Jisas wak, “Kéni kudi. Du taakwat viyaapérekmarék yaké méné yo. Nak duna taakwa wale kapéredi mu yamarék yaké méné yo. Sél yamarék yaké méné yo. Nak duké yénaa kudi wakwemarék yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Méné ména néwepat kutkalé yaké méné yo. Ména sépéké mawulat kapére yaménékwa pulak, nak du taakwaké mawulat kapére yaké méné yo. Yate derét kutkalé yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wani kudi véknwutakne dé wani nébikara du dérét wak, “Wani kudi akwi véknwute wadékwa pulak wunébu yak. Samu nak mu wawo yaké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Naate wadéka dé wak, “Kéga wawo yaké méné yo. Yéknwun mawulé yate miték rasaakuké mawulé yaménéran méné taknaménén akwi gwalmu nak duké kwayétakne yéwaa nyégéle méné yéwaa yamarék du taakwaké kwayéké méné yo. Kwayéménu Got ménat kutkalé yadu kukba méné Gotna gayét ye waba miték male rasaakuké méné yo. Méné yéwaa yamarék du taakwaké yéwaa kwayétakne gwaamale yae wuna jébaaba yaalaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naate wadéka wani nébikara du véknwutakne déku wupmalemu gwalmu kwayémuké kélik yadéka déku mawulé kapére dé yak. Yadéka Jisasnyét kulaknyénytakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dé yédéka dé Jisas déku duwat wak, “Wupmalemu gwalmu yan du kwekére ye de Gotna kémba yaalamarék yaké de yo. De apa ye Gotna kémba yaalaké de yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kéni kudi wawo wuné wo: Apakélé bulmakawu nak baapmu wut kétaapadakwa raaményna yaabuba wulaaké mawulé yadéran apa yaké dé yo. Wupmalemu gwalmu yan du Gotna kémba yaalaké mawulé yate apat kapére yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wani kudi véknwutakne Jisasna du sanévéknwu wanévéknwute de wak, “Naané Juda naané wo, ‘Got duwat las kutkalé yadék de wupmalemu gwalmu yan du de ro.’ Wani kudiké bulaa naané sanévéknwu. Wupmalemu gwalmu yan du Gotna kémba wulaaké nae apat kapére yadaran, yaga pulak gwalmu yamarék du taakwa Gotna kémba wulae miték rasaakuké de yo apuba apuba?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Naate wadaka dé derét véte dé wak, “Du taakwa deku kapmu apa yate de Gotna kémba yaale miték rasaakuké de yapatiyu. Got kapmu wani muké dé apa yo. Got akwi mu yaké dé apa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wani kudi véknwutakne dé Pita wak, “Mé véknwu. Naané naana gwalmu akwi kulaknyénytakne naané ména jébaa yate méné wale yeyé yeyo. Waga yanakwaké, samu mu kéraaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Naate wadéka dé Jisas dérét wak, “Gunat wuné wakweyo. Kukba nyét képmaa akwi gwalmu wawo kulé yadu wuné Akwi Du Taakwana Nyaan némaan banna yéknwun jaabéba rate du taakwaké némaan ban raké wuné yo. Wani tulé guné wuna du taaba vétik sékérékne maanba kayék vétik, guné némaan duna jaabéba rate, Isrelna kém taaba vétik sékérékne maanba kayék vétik wani kémké guné némaan du rate véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wunéké miték sanévéknwukwa du taakwa wuna jébaa yaké de deku ga, némaadugu wayéknaje, néwaa, yaapa, baadi, képmaa kulaknyénydaran Got derét kutkalé yadu de miték male rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bulaa rakwa wupmalemu némaan du taakwa kukba bakna du taakwa raké de yo. Bulaa bakna rakwa wupmalemu bakna du taakwa de kukba némaan du taakwa raké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas dé derét kéni kudi wakwek: “Got némaan ban rate du taakwaké kéga miték véké dé yo. Du nak apakélé wain mi tékwa yaawi dé nak yak. Yatakne ganbaba nak, nyaa yaalamarék yadéka ye dé wani yaawiba jébaa yaran duké dé sékalék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sékale vétakne dé derét wak, ‘Guné kéni akwi nyaa jébaa yagunéran wuné gunéké nak nak yéwaa taaba vétik kwayéké wuné yo.’ Naate wadéka de kusékérék. Kusékétdaka dé wadéka de déku yaawit yék, déku jébaa yaké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kukba nyaa yaaladéka dé wani yaawiba jébaa yaran duké las wawo sékalte dé du jawudakwa taalat yék. Ye dé vék du las bakna tédaka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Véte dé derét wak, ‘Guné wawo ye wuna yaawiba jébaa yaké guné yo. Yagunu wuné gunéké nak nak yéwaa taaba vétik kwayéké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naate wadéka de déku yaawit yék. Nyaa nawurédéka ye dé déku yaawiba jébaa yaran duké las wawo sékale vék. Vétakne wadéka de wawo déku jébaa yadaka nyaa tégéruwe dawuliké yadéka dé duké las wawo sékale vék. Vétakne wadéka de wawo de déku jébaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yadaka garabu nyaa dawuliké yadéka dé du jawudakwa taalat tépa ye dé vék du las wawo bakna tédaka. Véte dé derét wak, ‘Samu yate guné akwi nyaa kéba bakna tu?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Naate waatadéka de wak, ‘Naanat du nak kaapuk jébaa yanoké wadén.’ Naate wadaka dé derét wak, ‘Guné wawo ye wuna yaawiba jébaa yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kukba nyaa dawulidéka yaawina bapadu dé jébaa yakwa duké téségékwa duwat wak, ‘Méné jébaa yakwa duwat waaménu yaado méné deké yéwaa kwayéké yo. Taale méné kukba yae jébaa yan duké kwayéké yo. Kwayétakne méné nyédé nyaa yae jébaa yan duké kwayétakne, sésékukba méné ganbaba yae jébaa yan duké kwayéké yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naate wadéka dé waga kwayédéka de garabu yae jébaa yan du déké yae de nak nak yéwaa taaba vétik nyégélék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nyégéldaka taale yae jébaa yan du yéwaa nyégélké yaate vétakne de deku mawuléba de wak, ‘Sal naané némaa yéwaa nyégélké naané yo?’ Waga sanévéknwute de wawo de nak nak yéwaa taaba vétik nyégélék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nyégélte de yaawina bapadu wale waaruk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Waarute kéga de wak, ‘Wani du garabu yae walkamu tulé male de jébaa yak. Naané taale yae naané ganbaba jébaa batnyé yatakne apakélé jébaa yanaka nyaa dé naana sépéba viyaak. Samuké méné ména jébaa yan akwi duké nakurak yéwaa kwayu? Wan sépélak méné yak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naate wadaka dé waba tén dut nak wak, ‘Wuna du, mé véknwu. Wuné gunat kapéredi mu kaapuk yawurén. Ganbaba wuné gunat wak, Guné wuna jébaa yagunéran wuné gunéké yéwaa taaba vétik kwayéké wuné yo. Naate wawuréka guné wani yéwaaké guné kusékérék. Wawurén pulak wunébu gunéké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guné guna yéwaa nyégéle kure gayét yéké guné yo. Wuné wuna mawuléba véknwute kukba jébaa yan duké gunéké kwayéwurén yéwaa pulak male kwayéké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wan wuna jébaa. Wan wuna yéwaa. Deké kwayéwurén yéwaaké guné bulmarék yaké guné yo. Wuné derét kutkalé yate yadan makwal jébaaké apakélé yéwaa kwayéké mawulé yawuréran samuké guné wunat waatiyu?’ Naate dé yaawina bapadu wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Waga watakne dé Jisas derét wak, “Got némaan ban rate déku kémba yaalan du taakwaké waga miték véké dé yo. Déku kémba kukba yaalan du taakwat taale kutkalé yaké dé yo. Yatakne déku kémba taale yaalan du taakwat kukba kutkalé yaké dé yo. Deké nakurak mawulé yate derét akwi kutkalé yaké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Jisas Jerusalemét waaréte dé déku du taaba vétik sékérékne maanba kayék vétik derét male kwole de yék. Yéte dé derét wak, “Mé véknwu. Bulaa Jerusalemét naané waaru. Waaréno de Akwi Du Taakwana Nyaan wunat kérae nyédé duna némaan du, apa kudiké kutdéngkwa du wawo deké wunat kwayédo wuné deku taababa raké wuné yo. Rawuru de wunat viyaapérekdoké waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wado nak gena du wunat kérae wunat wasélékte raamény baagwit viyaatakne wunat miba viyaapata taknado kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu Got wadu tépa nébéle raapké wuné yo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedina nyaan vétik bétku néwaa lé bérét kwole yék Jisaské. Ye képmaaba kwati yaane waadé daate lé dérét waatak, dé lérét kutkalé yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Waataléka dé Jisas wak, “Samuké nyéné mawulé yo?” Naate wadéka lé dérét wak, “Kukba méné du taakwaké némaan ban rate méné waménu bét wuna nyaan vétik nak ména yéknwun tuwa taababa, nak ména aki tuwa taababa raké bét yo. Bét waba rate nak du taakwaké némaan du raké bét yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Naate waléka dé wak, “Guné wunat waatagunékwa muké kaapuk kutdénggunén. Wuné apakélé kaagél kutké wuné yo. Béné wani kaagél kutké béné apa yo, kapu yaga pulak?” Naate wadéka bét wak, “Ao. Waga kutké ané apa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naate wabétka dé wak, “Kaagél kutwuréran pulak béné kaagél kutké béné yo. Wan adél. Kukba kiyadé wuna yéknwun tuwa taaba, kiyadé wuna aki tuwa taababa raké yo? Wuné wani muké wamarék yaké wuné yo. Wan wuna kudi kaapuk. Waba raran duké wuna yaapa déknyényba déku mawuléba débu wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wani kudi wadéka de Jisasna du taaba vétik wani muké véknwute de bérét rékaréka yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yadaka dé Jisas waadéka yaadaka dé derét wak, “Guné kutdéngék. Nak gena némaan du de du taakwaké apa yate de wo, deku kudi miték véknwute deku jébaa yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Guné de yakwa pulak yamarék yaké guné yo. Guné wale rakwa du nak Gotna méniba némaan ban raké mawulé yadéran, dé guna jébaa yakwa du raké dé yo. Rate dé guna kudi véknwute wagunékwa pulak yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wuné Akwi Du Taakwana Nyaan waga wuné yo. Nak du taakwaké jébaa yate derét kutkalé yaké wuné yaak. Du taakwa wunéké jébaa yadaranké sanévéknwumarék yate wuné yaak. Wuné kiyae wupmalemu du taakwat Setenna taababa kéraawuru de Got wale miték rasaakudoké wuné yaak.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas déku du wale Jeriko kulaknyénytakne de yék. Yédaka wupmalemu du béré taakwa béré de déku kukba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yédaka bét méni kiyaan du vétik yaabuba bét rak. Rate bét kudi véknwuk Jisas yaabuba yédéka. Véknwute bét waak, “Ménawa, Devitna képmawaara. Méné Devit pulak némaan ban rate anéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naate waabétka de wani du taakwa bérét waatik, bét akélak rabéruké. Waatidaka bét némaanba tépa waak, “Némaan Ban, Devitna képmawaara, anéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Naate waabétka dé Jisas waak, déké yaabéruké. Waadéka déké yébétka dé wak, “Bénat samu yawuruké béné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Naate wadéka bét wak, “Némaan Ban, méné anat kutnébulménu ané tépa véké ané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naate wabétka dé bétké mawulé lékte déku taabat bétku méniba kutdéka dé bétku méni bari yéknwun yak. Yadéka bét miték véte bét Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas déku du wale Jerusalemét waaréké yate de Betpasi saabak. Wani gayé Oliv nébuba dé tu. Jerusalem tékwaba dé tu. Saabe dé Jisas déku du vétiknét wak, “Béné wani gayét wulae véké béné yo, donki vétik tébéru. Néwaa donki léku nyaan wale miba lékitaknadak bét tu. Vétakne béné wani donki vétik lépmwénye béné kure yaaké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yabénu du nak wani muké bénat waatadéran béné kéga waké béné yo, ‘Naana Némaan Ban dé wani donkiké mawulé yo.’ Naate béné waké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas waga wadéka déknyényba rate Gotna yéba kudi wakwen du Gotna nyégaba kavidén kudi adél dé yak. Kéga dé kavik: ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guné ye Saionba rakwa du taakwat kéga wakweké guné yo, “Mé vé. Guna némaan ban gunéké dé yao. Dé déku yéba kevérékmarék yate yéknwun mawulé yate dé yao. Dé donki nyaanna butgulba rate dé yao.” Wani kudi déknyényba Jisasna néwaa dérét kéraamarék yalén tulé kavidéka kukba dé Jisas Jerusalemba rakwa du taakwaké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisasna du vétik déku kudi véknwute bét wakwedén pulak yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ye bét néwaa donki léku nyaan wale lépmwénye kure yék déké. Ye bét yépmaa yadéka saapme tébérén baapmu wut putiye bét donkina butgulba akutaknak. Akutaknabétka dé Jisas donki nyaanna butgulba waare rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Rate yédéka de wupmalemu du taakwa baapmu wut las de yaabuba taknate de yaabu kusok. Yadaka du las de tépmaa tu pulak mu yaabuba taknate de yaabu kusok. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yatakne de du taakwa las taale yédaka de las Jisasna kukba yaate némaanba de waak, Devitna képmawaara naanéké dé yao. Wan yéknwun. Némaan Ban Got wadék dé yao. Wan yéknwun. Got dérét kutkalé yaké dé yo. Awuréba rakwa ban Gotna yéba kevérékgé naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Naate waadaka dé Jisas Jerusalemét wulaak. Wulaadéka wani gayéba rakwa akwi du taakwa dérét véte kwagénte de wak, “Wani du wan kiyadé?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Naate wadaka dé wale yaan du taakwa de wak, “Kén Gotna yéba kudi wakwekwa du déku yé Jisas. Dé Galilina képmaaba dé yao. Déku gayé Nasaret.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas Gotna kudi buldakwa némaa gat wulae dé vék du las gwalmu kwayéte yéwaa nyégéldaka. Vétakne dé derét kélésalak. Kélésalate dé nak gena yéwaa nyégélte wani gayéna yéwaa kwayékwa duna jaabé takugérutnyék. Yate dé viyae Gotké kwayédaran api kwayékwa du ran mi tabé takubalaakuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yate dé derét wak, “Kéni kudi Gotna nyégaba dé kwao: Got dé wak, ‘Du taakwa wuna gat yaale wuné wale kudi bulké de yo.’ Naate dé Got wak. Wani kudiké guné kaapuk sanévéknwugunékwa. Guné kéni gaba Got wale kudi kaapuk bulgunékwa. Guné gwalmu kwayéte yéwaa nyégélgunéka kéni ga kén sél yakwa du paakwe rakwa ga pulak.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas awula Gotna gaba tédéka de méni kiyaan du taakwa las, maan kapére yan du taakwa las waga de déké yaak. Yaadaka dé derét kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kutnébuldéka de Gotna gaba jébaa yakwa nyédé duna némaan du, apa kudiké kutdéngkwa du wawo de vék. Véte de véknwuk baadi Gotna gaba némaanba waadaka. Kéga de waak, “Devitna képmawaara naanéké dé yao. Wan yéknwun.” Naate waadaka de véknwute Jisas wani du taakwat kutnébuldéka vétakne de dérét rékaréka yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yate de dérét wak, “Waadakwa kudi méné véknwu kapu kaapuk? Wan sépélak de yo.” Naate wadaka dé Jisas wak, “Ao. Wuné véknwu. Wan miték de yo. Waga yadakwaké kéni kudi Gotna nyégaba dé kwao: Méné Got, makwal baadi munyaa kakwa baadi wawo derét ménébu wak, ména yéba miték kevérékdoké. Wani kudiké yékéyaak guné yak, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naate watakne Jisas Jerusalem kulaknyénytakne dé Betanit yék. Ye dé waba kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas waba kwae ganbaba dé Jerusalemét gwaamale yéké nae yaabuba yédéka dé dérét kaadé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yadéka yéte dé vék yéknwun sék akukwa mi nak apa yaabuba tédéka. Wupmalemu gaga wani miba tédéka véte déku mawuléba dé wak, “Wupmalemu gaga tédéka sék dé akuk. Las géle kaké wunék.” Naate watakne dé wani misék géle kaké yék. Ye wani misék las akwe tédéka kaapuk védén. Gaga male tédéka dé vék. Véte dé wak, “Kéni miba tépa sék akumarék yaké dé yo.” Naate wadéka dé wani mi bari rékaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yadéka Jisasna du véte kwagénte de wak, “Aki. Yaga pulak ye dé wani mi bari rékaa yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Naate wadaka dé Jisas derét wak, “Gunat wuné wakweyo. Guné Gotké miték sanévéknwute mawulé vétik yamarék yagunéran guné wani mit yawurén pulak yaké guné yo. Guné wagunu mi rékaa yaké dé yo. Wani mu male yamarék yaké guné yo. Nak mu wawo yaké guné yo. Kéni nébu ye kusba dawuliduké wagunéran, dé ye kusba dawuliké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Guné Gotké miték male sanévéknwute dérét waatagunéran pulak, gunéké yaké apa yadékwaké guna mawuléba wagunéran, guné dérét waatagunu dé gunéké waga yaké dé yo. Adél wuné gunat wakweyo.” Naate dé déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas Jerusalem saabe dé Gotna kudi buldakwa némaa gat wulaak. Wulae dé du taakwat Gotna jébaaké yakwatnyék. Yakwatnyédéka dé Gotna gaba jébaa yakwa nyédé duna némaan du, kubu du wawo waga Jisaské yae de dérét wak, “Samu apa kérae méné wani jébaa yo? Kiyadé wak méné wani jébaa yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Naate wadaka dé derét wak, “Wuné wawo nak kudi gunat waataké wuné yo. Waatawuru guné wuna kudi kaatagunéran wuné guna kudi kaataké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Guné mé wakwe. Kiyadé Jonét wak dé du taakwat gu yaakutaknak? Got dé waga wak, kapu képmaaba rakwa du dé nak waga wak?” Naate waatadéka de deku kapmu bulte waarute de wak, “Naané kéga wanaran, ‘Got dé waga wak.’ Naate wanaran dé naanat kéga waké dé yo, ‘Samuké guné déku kudi kaapuk véknwugunén?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sal naané kéga waké naané yo? ‘Képmaaba rakwa du dé nak wak.’ Naate wamarék yaké naané yo, du taakwaké wup yanakwa bege. Wupmalemu du taakwa de Jonké wo, ‘Gotna yéba kudi wakwen du nak. Wan adél.’ Naate de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Waga bultakne de yénaa yate Jisasnyét wak, “Naané las kaapuk kutdéngnan. Wani muké wakwemarék yaké naané yo.” Naate wadaka dé derét wak, “Wuné wawo wunat wadék yae kéni jébaa yawurékwa banké wakwemarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wani kudi watakne dé Jisas kéni aja kudi wakwek: “Yaga guné sanévéknwu? Du nak nyaan vétik déknyényba dé kéraak. Nak nyaa dé maknanyanké ye dé wak, ‘Wuna nyaan, bulaa méné ye wuna wain mi tékwa yaawiba jébaa yaké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naate wadéka dé déku nyaan wak, ‘Wuné kélik wuné yo.’ Naate watakne kukba nak mawulé yate dé wani yaawiba jébaa yaké dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wani du ye dé maknanyanét wadén pulak dé déku wayékna nyaanét wak. Wadéka dé nyaan wak, ‘Ao. Bulaa yéké wuné yo.’ Naate watakne yaawiba jébaa yaké kaapuk yédén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wani nyaan vétik kiyadé yaapana kudi véknwuk?” Naate wadéka de wak, “Maknanyan.” Naate wadaka dé Jisas derét wak, “Gunat wuné wakweyo. Takis nyégélén kapéredi du, yaabuba tén taakwa, de taale Gotna kémba de yaalo. Wan adél. De yaalado guné kukba yaalaké guné yo, kapu yaalamarék yaké guné yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gu yaakutaknan du Jon yae dé wak, ‘Guné kapéredi mawulé kulaknyénytakne Gotna kudi miték véknwuké guné yo.’ Naate wadéka guné déku kudi kaapuk véknwugunén. Yagunéka de takis nyégélkwa kapéredi du, yaabuba tékwa taakwa wawo de déku kudi véknwuk. Véknwute yadan kapéredi mu kulaknyénytakne de Gotna kudi miték véknwuk. Yadaka véte guné yadan pulak kaapuk yagunén. Guné yagunén kapéredi mu kulaknyénymarék yate déku kudi kaapuk véknwugunén.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wani kudi watakne dé Jisas derét kéga wakwek: “Guné kéni aja kudi wawo mé véknwu. Du nak dé wain mi tékwa yaawi nak yak. Raatmu gitakne dé wain mi tawuk. Tawutakne dé kukba wain gu kérae kaké nae wain sék guriksade akibésdaran waagu dé matuba vaak. Vaatakne dé yaawiké téségédaran sémény ga dé nak kaak. Yawurétakne dé wani yaawiké téségéte yaawiba jébaa yate yéwaa nyégélké mawulé yan duké kwayék. Kwayétakne dé nak képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Misék gélédaran tulé yaaké yadéka dé dé wale rate déku jébaa yakwa duwat las wak, de yaawiké téségékwa duké yédoké. Dé misék las kwayédo kure yaadoké dé mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yate wadéka déku jébaa yakwa du yédaka de yaawiké téségékwa du derét véte naknét viyae, naknét viyaapérekne, de naknét matut viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yadaka kukba dé yaawina bapadu déku jébaa yakwa du lasnyét wawo wadéka de yék. Wupmalemu duwat wadéka de yék. Yédaka de yaawiké téségékwa du derét waga male de viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Yadaka kukba dé yaapa déku mawuléba dé wak, ‘De wuna nyaanna kudi véknwuké de yo.’ Naate watakne dé déku nyaanét wadéka dé yaawiké téségékwa duké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yédéka de yaawiké téségékwa du déku nyaanét véte de deku kapmu kudi bulék. Bulte de kéga wak, ‘Yaawina bapadu kiyaadu wani nyaan déku yaapana akwi gwalmu kéraaké dé yo. Naané dérét viyaapérektakne kéni yaawi kéraaké naané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Waga watakne de dérét kure yaawi kulaknyénytakne kaapat kure gwaade de dérét viyaapéreknék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wani kudi watakne Jisas dé derét wak, “Guné yaga guné sanévéknwu? Kukba yaawina bapadu yae yaawiké téségén duwat yaga pulak yaké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Naate waatadéka de dérét wak, “Dé yae wani kapéredi mu yan duwat viyaapérekgé dé yo. Waga yaké dé yo. Viyaapérekne nak duké wani yaawi kwayéké dé yo, de yaawiké téségédoké. Kwayédu kukba misék gélédaran tulé de wani misék géle déké kwayéké de yo.” Naate de Jisasnyét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wani kudi watakne dé derét kéga wak: “Viyaapérekdan nyaanké kéni kudi Gotna nyégaba dé kwao: Ga kaakwa du yéknwun matuké sékalte nakurak matuké kélik yadaka dé bakna rak. Radéka Némaan Ban Got wani matut véte dé wak, ‘Wan yéknwun matu. Wani matu radu ga miték kwaaké dé yo.’ Naate watakne wani matu kérae taknadéka dé ga miték kwaak. Kwaadéka naané véte naané yéknwun mawulé yo. Wani kudi Gotna nyégaba vétakne guné kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wani kudiké gunat wuné wakweyo. Déknyényba guné Juda Gotna kémba guné rak. Rate guné déku jébaaké kélik yak. Yagunénké Got wadu guné déku kémba ramarék yagunu nak gena du taakwa déku kémba yaalaké de yo. Wani du taakwa déku jébaa miték yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wani matu takuba akéréran du deku sépékwaapa kapére yaké dé yo. Wani matu duna sépéba akérédéran wani duwat takupérekgé dé yo.” Naate dé Jisas wak. Wani matuké waga wakwete dé déké dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wani kudi wadéka de Gotna gaba jébaa yakwa nyédé duna némaan du, Parisina du wawo wani aja kudi vétik véknwute de kutdéngék. Jisas deké dé wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Waga kutdéngte de wak, “Naané dérét kure raamény gaba taknaké naané yo.” Naate wate de kéga wawo de wak, “Akwi du taakwa de wo, ‘Jisas wan Gotna yéba kudi wakwekwa du nak.’ Naate wadakwaké naané dérét kure raamény gaba taknanaran de naanat waatiké de yo.” Naate watakne wani du taakwa derét waga waatimuké wup yate de Jisasnyét kaapuk kulékidan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas dé derét aja kudi nak wawo kéga wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Got némaan ban rate du taakwaké kéga miték véké dé yo. Némaan ban dé nak rak. Déku nyaan taakwa yaké yadéka dé wadéka de apakélé yaa sérakne kaké yak. Yadaka wani némaan ban dé wupmalemu du taakwat wakwek, de kukba yae de wale kadému kadoké. Wakwedéka déku du taakwa de kadému kawu saakérak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawu saakéradaka dé déku jébaa yakwa duwat kéga wak, ‘Guné gege gayét yéte wakwewurén du taakwat waké guné yo, de bulaa yae kadému kadoké.’ Naate wadéka de ye wadaka wani du taakwa yaamuké kélik de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yadaka wani némaan ban dé déku jébaa yakwa du lasnyét wawo wak, ‘Guné ye guné déknyényba wakwewurén du taakwat kéga wakweké guné yo: Mé véknwu. Naané kadému naanébu kawu saakérak. Apakélé bulmakawu, yéknwun bulmakawu nyaan wawo naanébu viyae tuk. Akwi gwalmu naanébu kawu saakérataknanak dé ro. Guné yae kaké guné yo. Naate guné derét wakweké yo.’ Naate wadéka de wadén pulak yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“De waga yadaka de ye wani kadému kamuké kélik de yak. Deku jébaaké male de sanévéknwuk. Yate nak du raapme dé kadému yaanandén képmaat yék. Yédéka nak raapme yéwaa nyégéldéran jébaa yaké dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yédéka las raapme de némaan banna jébaa yan duwat kulékiye derét kapéredi mu yate de derét viyaapéreknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Viyaapérekdaka dé némaan ban rékaréka yate déku waariyakwa duwat wadéka ye de déku jébaa yan dut viyaapéreknén duwat akwi viyaasadak. Yate de deku gayé ga yaa tuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Yadaka dé némaan ban déku jébaa yakwa duwat wak, ‘Naané kadému kawu saakérataknanak dé ro. Yaadoké wakwewurén du taakwa de kapéredi mu de yak. Yatakne de naana kadému kamarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yado guné ye akwi yaabuba téte nak du taakwat véte derét kéga waké guné yo: Guné yae guné kawu saakéranan kadému kaké yo. Waga wakweké guné yo derét.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naate wadéka de jébaa yakwa du raapme ye yaabuba yéte de védan du taakwat wakwek, yaadoké. Yéknwun mu yakwa du taakwa, kapéredi mu yakwa du taakwat wawo de wakwek. Wakwedaka yae de taakwa yan duna yaapa déku gaba rak. Radaka wani ga dé sékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wani némaan ban kadému kakwa du taakwat véké dé wani gat wulaak. Wulae dé vék kwayédén yéknwun baapmu wut kusadamarék yan du nak radéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jégwaa baapmu wut male dé kusadak. Yadéka dé némaan ban dérét wak, ‘Méné, yaga pulak ye méné yéknwun baapmu wut kusadamarék ye méné kénét yaalak?’ Waga wadéka wani du kudi las kaapuk buldén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yadéka dé némaan ban déku jébaa yakwa duwat wak, ‘Guné wani dut kulékiye déku maan taaba giye guné kaapat yatjagwadéké guné yo. Yagunu dé gaankétéba raké dé yo. Waba rate dé némaa kaagél kutte yéknwun taaléba raké mawulé yate némaanba géraaké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Wani aja kudiké mé sanévéknwu. Got wan wani némaan ban pulak. Got wupmalemu du taakwat débu wak, de déku kémba yaaladoké. Wadéka de wupmalemu du taakwa déku kudiké debu kuk kwayék. Kwayétakne de déku kémba yaalamarék yaké de yo. Dé wupmalemu du taakwat wadéka walkamu du taakwa de déku kudi véknwute déku kémba yaalo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wani kudi wadéka de Parisina du las ye de deku kapmu kudi bulék. Bulte de wak, “Naané Jisasnyét kés mu nak muké waatanaran sal dé kapéredi kudi kaataké dé yo, kapu kaapuk? Dé kapéredi kudi wadéran naané dérét kure raamény gaba taknaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Naate watakne de deku du las Yerotna du las wawo derét wadaka de Jisaské ye dérét wak, “Némaan du, méné derét Gotna jébaaké méné yakwatnyu. Méné adél kudi male wakwete derét Gotna kudiké miték méné yakwatnyu. Méné nakurak kudi male méné wakweyo, némaan du taakwa, bakna du taakwat wawo. Méné deké wup kaapuk yaménékwa. Waga naané kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Méné waga yate bulaa méné naanat mé wakwe. Yaga méné sanévéknwu? Naana apa kudi yaga dé wo? Naané takis Romna némaan banké kwayéké naané yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naate wadaka dé Jisas deku mawulé dé kutdéngék. De deku mawuléba kéga de wak, “Bulaa dé kapéredi kudi wadu naané dérét raamény gaba taknaké naané yo.” Naate wadaka Jisas kutdéngte dé derét wak, “Guné yénaa yakwa du guné. Samuké nae guné wunat waga waato? ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Guné takis kwayégunékwa yéwaa nak wunat mé wakwatnyé véwuru.” Naate wadéka de wani yéwaa nak kure yék déké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kure yédaka dé derét wak, “Kéni yéwaaba kwaakwa nyaap kén kiyadéna nyaap? Kiyadéna yé de kéni yéwaaba kavik?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Naate waatadéka de wak, “Wan Romna némaan bannan.” Naate wadaka dé derét wak, “Wan adél. Romna némaan banna mu guné déké kwayéké guné yo. Gotna mu guné Gotké kwayéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naate wadéka de wani kudi véknwute kwagénte de sanévéknwu wanévéknwuk. Yate de dérét kulaknyénytakne de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusina du deku mawuléba de kéga wak, “Kiyaan du taakwa tépa nébéle raapmarék yaké de yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","De las Jisaské ye de dérét kéga wak: “Némaan du, méné du taakwat Gotna jébaaké méné yakwatnyu. Méné kéni muké naanat mé wakwe. Déknyényba Moses kéga dé wakwek, ‘Du nak taakwa ye nyaan kéraamarék ye kiyaadéran déku wayékna wani taakwa yaké dé yo. Yadu nyaan kéraalu wani nyaanké waké de yo, Némaaduna nyaan. Naate waké de yo.’ Waga dé Moses wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bulaa mé véknwu. Déknyényba némaadugu wayéknaje nak taaba sékét nak taababa kayék vétik de rak. Némaadu taakwa ye baadi kéraamarék ye dé kiyaak. Kiyaadéka déku wayékna wani taakwa ye baadi kéraamarék ye dé kiyaak. Kiyaadéka nak wayékna wani taakwa ye baadi kéraamarék ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kiyaadéka akwi wayékna waga male ye de akwi baadi kéraamarék ye de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yadaka kukba lé wani taakwa kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bulaa naanat mé wakwe. Kiyaan du taakwa nébéle raapdaran tuléké méné wakweyo. Wani tulé wani taakwa kiyadé wale raké lé yo? Déknyényba wani némaadugu wayéknaje akwi de lérét yak.” Naate de Sadyusina du Jisasnyét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas deku kudi véknwute dé derét wak, “Guné Gotna nyégaba kwaakwa kudi las kaapuk kutdénggunén. Kutdéngmarék yate Gotna apaké wawo kaapuk kutdénggunén. Yagunéka guna mawulé sépélak dé yo. Mé véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kukba Got wadu kiyaan du taakwa nébéle raapme de Gotna gayéba rate déku kudi kure giyaakwa du pulak raké de yo. Rate du de taakwa yamarék yaké de yo. Taakwa de du ramarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kudi las wawo wakweké wunék, kiyaan du taakwa nébéle raapdaranké. Got gunat wakwedéka déku nyégaba kwaakwa kudi las vétakne guné kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Got dé wak, ‘Wuné Ebrayamna némaan ban. Wuné Aisakna némaan ban. Wuné Jekopna némaan ban. Wuné deku némaan ban Got wuné ro.’ Naate wadéka déku kudi déku nyégaba kwaadéka naané kutdéngék. Dé kiyaan duna némaan ban kaapuk radékwa. Wani du déknyényba de kiyaak. Taale de kiyaak. Kukba Got dé wani kudi wak. De kiyae tépa nébéle raapme radaka dé Got wani kudi wak. Got kiyae nébéle raapme rakwa duna némaan ban dé ro. Got wan kulé rakwa duna némaan ban. Waga naané kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Naate wadéka waba tén du béré taakwa béré wani kudi véknwute déku kudiké kwagénte de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wani kudi wadéka de Sadyusina du kudi bulmarék rak. Radaka Parisina du véknwutakne yae de de wale jawe rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Radaka de wale rate apa kudiké yakwatnyékwa du nak déku mawuléba dé wak, “Dé wuna kudi kaatate sal kapéredi kudi waké dé yo?” Naate sanévéknwute dé Jisasnyét wak, “Némaan du, méné Gotna kudiké méné naanat yakwatnyu. Naana apa kudiba samu némaa kudi dé akwi némaa kudit talaknak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Naate waatadéka dé dérét wak, “Guné guna Némaan Ban Gotké mawulat kapére yaké guné yo. Yate guné dérét wagunu dé guna mawulé, guna wuraanyan, guna yaamabiké dé némaan ban raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wani kudi wan némaa kudi. Akwi némaa kudit débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nak némaa kudi wan waga male. Kéga dé wo, ‘Guné guna sépéké mawulat kapére yagunékwa pulak nak du taakwaké mawulat kapére yaké guné yo. Yate derét kutkalé yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wani kudi vétik wan némaa kudi. Akwi némaa kudit débu talaknak. Guné wani kudi véknwute wadékwa pulak yate guné Moses wakwen apa kudi Gotna yéba wakwekwa duna kudi wawo guné véknwu.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Parisina du yae nakurakba jawe tédaka dé Jisas derét waatak, “Gunat kutkalé yaduké Got wadén ban Krais yaga pulak ban dé? Yaga guné déké sanévéknwu? Dé kiyadéna képmawaara?” Naate waatadéka de dérét wak, “Wan Devitna képmawaara.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Naate wadaka dé derét wak, “Déknyényba Krais kéni képmaaba ramarék yadéka Gotna Yaamabi Devitna mawuléba wulae tédéka Devit dé Kraiské kéga wak, ‘Wuna Némaan Ban.’ Naate wate dé kéga wak: Némaan Ban Got wuna Némaan Banét dé wak, ‘Méné némaan ban rate wuna yéknwun tuwa taababa raké méné yo. Raménu wuné wawuru ména maama ména taababa raké de yo. Rado méné némaan ban rate deké véké méné yo.’ Naate dé Got wak. Devit wani kudi wakwete dé Kraiské ‘Wuna Némaan Ban’ dé naak. Samuké nae dé Devit Kraiské waga wak? ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit Got wadén ban Kraiské ‘Wuna Némaan Ban’ naadéka yaga pulak dé Krais Devitna képmawaara ro? Krais Devitna képmawaara rate Devitna némaan ban wawo dé ro, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Waga wadéka de Jisasna kudi kaataké de yapatik. Wani nyaa de dérét kudi las wawo waatamuké de wup yak. Kukba wawo de dérét kudi las tépa kaapuk waatadan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas dé déku du, wupmalemu nak du taakwat wawo dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kéga dé wakwek: “Apa kudiké kutdéngkwa du, Parisina du wawo de Moses déknyényba wakwen apa kudiké de miték kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kutdéngdanké sanévéknwute guné deku kudi véknwute wakwedakwa pulak yaké guné yo. Yate guné yadakwa pulak yamarék yaké guné yo. De wupmalemu kudi wakwete de wadan pulak kaapuk yadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Du nak wupmalemu gwalmu yaatadéka nak du yae las wawo akutaknadékwa pulak, Parisina du apa kudiké kutdéngkwa du wawo de apa jébaa las wawo du taakwaké de kwayu. Kwayéte de derét kéga wakweyo, ‘Guné kéni apa kudi akwi véknwute wadékwa pulak yaké guné yo.’ Naate wadaka de wani kudi véknwute wadékwa pulak yaké apakélé jébaa de yo. Yadaka de deké mawulé lékmarék yate derét kutkalé kaapuk yadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Akwi du taakwa derét véte deké ‘Yéknwun du’ naadoké de mawulé yo. Yate Gotna kudi las nyégaba kaviye de wani nyéga deku lékwés deku taababa wawo de giyu. Gite deku baapmu wutna waabuba de kuso. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","De nak du wale kadému kate de yéknwun taaléké sékalte du taakwana méniba raké de mawulé yo, de véte deku yéba kevérékdoké. De Gotna kudi bulnakwa gat wulae némaan duna taaléba raké de mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","De du taakwa jawudakwa taaléba yeyé yeyado nak du taakwa derét véte kéga wadoké de mawulé yo: ‘Wan naana némaan du dewa yaakwa. Naanat Gotna kudiké yakwatnyékwa du.’ Naate wadoké de mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Guné wuna du rate guné waga yamarék yaké guné yo. Guné akwi wuna jébaaba yaale némaadugu wayéknaje guné ro. Ragunu guna némaadugu wayéknaje gunéké wamarék yaké de yo, ‘Naanat Gotna kudiké yakwatnyékwa du.’ Naate wamarék yaké de yo, wuné kapmu gunat Gotna kudiké yakwatnyékwa du rawurékwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Awuréba rakwa ban guna yaapa wan nakurak male dé ro. Radékwaké guné nak duké ‘Naana némaan ban’ naamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Guna némaan ban wan wuné Got wadén ban Krais. Waga kutdéngte guné nak duké, ‘Naana némaan ban’ naamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Guna du nak némaan ban raké mawulé yadéran dé guna jébaa yakwa du raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Deku yéba kevérékgwa du taakwaké kukba Got wadu de bakna du taakwa raké de yo. Deku yéba kevérékmarék yakwa du taakwaké kukba Got wadu de némaan du taakwa raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wani kudi watakne dé Jisas apa kudiké kutdéngkwa du, Parisina duwat wawo dé kéga wakwek: “Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné miték rasaakumarék yaké guné yo. Guné yénaa yakwa du guné. Wupmalemu du taakwa Gotna kémba yaalaké de mawulé yo. Yadaka guné kudi wakwegunéka véknwute de Gotna kémba yaalaké de yapatiyu. Guné wawo Gotna kémba kaapuk yaalagunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Guné dukiyaataakwana gwalmu akwi guné kérao. Kérae guné yénaa yate apakélé kudi Gorét wakweyo, nak du taakwa gunat véte guna yéba kevérékdoké. Yagunékwaké apakélé kapéredi mu gunéké yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Guné séknaa yaabuba yéte kusba yéte nébuba wawo yéte guné guna kudi véknwuran duké nak guné sékalu. Sékale végunéka wani du guna jébaaba wulaadéka dérét yakwatnyégunéka dé wupmalemu kapéredi mu yo. Yadékwa kapéredi mu yagunékwa kapéredi mat débu talaknak. Guné wawo dé wawo guné akwi kapéredi taalat yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Méni kiyaan du dé nak dut yaabu wakwatnyéké yapatidékwa pulak, guné nak du taakwat yéknwun yaabu wakwatnyéké guné yapatiyu. Gunéké kapéredi mu yaaké dé yo. Guné kéga guné wo, ‘Du las jébaa nak yaké yate Gotna kudi buldakwa némaa gana yéba adél ye kudi wakwedaran wan bakna mu. Kukba de mawulé yadaran wani kudi kulaknyényké de yo. De jébaa yaké yate Gotna kudi buldakwa némaa gaba taknadan gol matut yadan gwalmuna yéba adél ye kudi wakwedaran wan némaa mu. Wadan pulak yaké de yo. Kukba de wani kudi kulaknyénymarék yaké de yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Guné waga wate guné waagété yo. Méni kiyaan du yaabuké miték kutdéngmarék yadakwa pulak, guné Gotké kaapuk miték kutdénggunén. Samu mu wan némaa mu, Gotna kudi buldakwa némaa ga, kapu wani gaba rakwa gwalmu? Gotna kudi buldakwa némaa gaba rakwa gwalmu, Gotna kudi buldakwa némaa ga wawo, akwi wan némaa mu. Wani ga wan Gotna ga. Wani gaba rakwa gwalmu wan Gotna gwalmu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Guné kéga wawo guné wo, ‘Du las jébaa nak yaké yate kwaami tuwe Gotké kwayédakwa jaabéna yéba adél ye kudi wakwedaran wan bakna mu. Kukba de mawulé yadaran wani kudi kulaknyényké de yo. De jébaa nak yaké yate wani jaabéba kwaakwa kwaamina yéba adél ye kudi wakwedaran wan némaa mu. Wadan pulak yaké de yo. Wani kudi kulaknyénymarék yaké de yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Guné waga wate méni kiyaan du yaabuké miték kutdéngmarék yadakwa pulak, guné Gotké kaapuk miték kutdénggunén. Samu mu wan némaa mu, Gotké kwayédakwa kwaami, kapu Gotké kwayédakwa kwaami kwaakwa jaabé? Wani mu vététi wan némaa mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwaami tuwe Gotké kwayédakwa jaabé wan Gotna mu. Wani jaabéba kwaakwa kwaami wan wawo wan Gotna mu. Du wani jaabéna yéba adél ye kudi wakwedaran de wani jaabéba kwaakwa kwaamina yéba wawo adél ye kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Got déku gaba dé ro. Du Gotna kudi buldakwa némaa gana yéba adél ye kudi wakwedaran de Gotna yéba wawo adél ye kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Got déku gayéba dé ro. Du Gotna gayéna yéba adél ye kudi wakwedaran de Got rakwa jaabéna yéba adél ye kudi wakweyo. Waga yate de Gotna yéba wawo adél ye kudi wakweyo. Guné jébaa nak yaké yate adél ye kudi wakwegunéran guné wagunén pulak yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Guné akwi gwalmu muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne guné nakurak tabé Gotké kwayu. Waga kwayéte guné akwi kutjo wawo muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne guné nakurak tabé Gotké kwayu. Kutjo wan némaa mu kaapuk. Wan makwal mu. Guné wani makwal muké sanévéknwute guné Moses wakwen apa kudiba kwaakwa némaa muké kaapuk sanévéknwugunékwa. Guné nak du taakwat kutkalé kaapuk yagunékwa. Guné nak du taakwaké mawulé kaapuk lékgunékwa. Guné Gotké miték sanévéknwumarék yate guné yaké wagunékwa pulak kaapuk yagunékwa. Guné guna gwalmu muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne nakurak tabé Gotké kwayégunékwa wan yéknwun. Wani mu kulaknyénymarék yaké guné yo. Wani makwal mu yate guné wekna wakwewurén némaa mu wawo yagunu mukatik guné miték yakatik guné yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Méni kiyaan du dé nak dut yaabu wakwatnyéké yapatidékwa pulak, guné nak du taakwat yéknwun yaabu wakwatnyéké guné yapatiyu. Guné makwal mu yaké guné apa jébaa yate miték yo. Némaa mu yaké guné yékéyaak yo. Yate kéni du pulak guné yo. Dé gu tuwe kaké yate makwal saat guba kwaadéka kutdéngte dé kérae kure ye guriksado. Yate bulmakawu guba kwaadéka kutdéngmarék yate dé bulmakawu gu wale ko. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Guné awu yakutnyéte kapasaknwu male guné yakutnyu. Yaalésaknwu kaapuk yakutnyégunékwa. Yagunéka yaalé kapéredi dé yo. Guné guna sépéké sanévéknwute wupmalemu gwalmu nak du taakwat nyégéle gwalmu las sél ye bakna kéraagunéka guna mawulé kapéredi dé yo, wani awuna yaalésaknwu kapéredi yadékwa pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Guné Parisina du, méni kiyaan du yaabuké miték kutdéngmarék yadakwa pulak, guné kaapuk miték kutdénggunén. Guné awu yakutnyéte taale awulaba yakutnyéké guné yo. Waga yagunu kapasaknwu yéknwun yaké dé yo. Waga yagunéran pulak guné kapéredi mawulé kulaknyénye yéknwun mawulé yagunu guna mawulé miték tédu guné yéknwun mu yakwa du raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Guné gaaba ségwi rémdan waagu pulak guné ro. Du taakwa wani waagu takuba de yéknwun mu takno. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taknadaka nak du taakwa véte wani muké male sanévéknwute de wo, ‘Wan yéknwun.’ Naate wate de ada waaguba kwaakwa kiyaan duna apa kapéredi muké wawo kaapuk kutdéngdan. Guné waga pulak. Du taakwa gunat véte de wo, ‘Wan yéknwun mu yakwa du.’ Naate wate de kaapuk kutdéngdan. Guna mawulé kapéredi dé yo. Yadéka guné yénaa yate kapéredi mu guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Guné apa kudiké kutdéngkwa du, Parisina du wawo, gunéké kapéredi mu yaaké dé yo. Guné yénaa yakwa du guné. Gotna yéba kudi wakwen du, nak yéknwun mu yakwa du wawo déknyényba re kiyaadaka rémdaka guné rémdan taaléba yéknwun mu takno. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Takne guné wo, ‘Naané naana képmawaara radan tulé rano mukatik, naané, de yadan pulak, Gotna yéba kudi wakwen duwat viyaapérekmarék yakatik naané yak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naate wate guné derét viyaapéreknén duna képmawaara ragunékwaké guné wo. Waga wate ragunéka guna mawulé deku mawulé pulak dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tédéka de kapéredi mu yadan pulak, guné wawo kapéredi mu yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guné kapéredi mu yakwa du. Duwat tikwa kaabe pulak rate guné kapéredi mu yo. Got wadu guné kapéredi taalat yéké guné yo. Nak taalat yaage yéké yapatiké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Wuné wawuru Gotna yéba kudi wakwekwa du, yéknwun mawulé pukaakwa du, Gotna kudiké yakwatnyékwa du gunéké yaaké de yo. Wuné kutdéngék. De yaado guné lasnyét viyaapérekgé guné yo. Lasnyét miba viyaapata taknaké guné yo. Lasnyét guné Gotna kudi bulgunékwa gaba raamény baagwit viyaaké guné yo. Lasnyét kélékére yéké guné yo kés gayé nak gayét. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Guné waga yagunu Got yagunén kapéredi mu gunat yakataké dé yo. Déknyényba guna képmawaara wupmalemu yéknwun mu yan duwat de viyaapéreknék. Taale Ken déku wayékna Ebelét dé viyaapéreknék. Viyaapérekdéka guna képmawaara yéknwun mu yakwa duké kélik yate derét de viyaapéreknék. Viyaapérekgére ye viyaapérekgére ye kukba de Berekaiana nyaan déku yé Sekaraia dérét de viyaapéreknék. Dé Gotna gana nyédéba tédéka de dérét viyaapéreknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Viyaapérekdanké Got yadan kapéredi muké sanévéknwute guné deku képmawaarat némaanba yakataké dé yo. Guné kéni tulé rakwa du, yadan kapéredi mu gunat némaanba yakataké dé yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas wani kudi watakne dé waba tén du taakwat véte dé wak, “Guné Jerusalemba rakwa du taakwa, guné Gotna yéba kudi wakwen duwat guné viyaapéreknék. Got wadéka déku kudi kure yén du gunéké de yék. Yédaka guné derét matut viyaagunéka de kiyaak. Gunéké wuné mawulé léknu. Séraa kéraalén nyaanké sarépgwe rate deké miték vélékwa pulak, wuné wupmalemu apu gunat kutkalé yate gunéké miték véké wuné mawulé yak. Mawulé yawuréka guné kélik guné yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yagunénké kukba du yae guna gayé yaalébaanké de yo. Yaalébaando guné waba ramarék yaké guné yo. Guna gayé bakna taalé téké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wuné kutdéngék. Guné wunat tépa bari vémarék yaké guné yo. Kukba guné wunéké waké guné yo, ‘Got wadéka dé wani du yaak. Naané déku yéba kevérékgé naané yo.’ Naate wagunu wuné gwaamale yaawuru guné wunat tépa véké guné yo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas Gotna kudi buldakwa némaa ga kulaknyénytakne yéké yadéka de déku du déké yaak. Yae de dérét wak, “Mé vé. Kéni ga wan yéknwun ga.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Naate wadaka dé derét wak, “Ao, bulaa wan yéknwun ga. Yéknwun matut yadaka naané vu. Kukba du yae kéni ga akwi yaalébaanké de yo. Yaalébaante de kéni matu kérae yatjadado kéni matu nak matuba kwaamarék yaké dé yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wani kudi watakne Jisas wani ga kulaknyénytakne ye dé Oliv nébat waarék. Waare radéka déku du male déké ye de dérét wak, “Naanat mé wakwe. Yani nyaa Gotna kudi buldakwa némaa ga yaalébaanké de yo? Samu mu taale yaadu vétakne kéga waké naané yo, ‘Ao, bulaa Jisas gwaamale yaaran nyaa bari yaaké dé yo. Yaadu kéni képmaa bari kaapuk yaké dé yo.’ Yani nyaa naané waga waké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Naate waatadaka dé Jisas wak, “Guné jérawu yaké guné yo. Yate yénaa yakwa duna kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wani kudi wuné wo, wupmalemu du yae de gunat yénaa yaké mawulé yadaran bege. Yénaa yate wuna yéba wakwete de nak nak kéga waké de yo, ‘Wuné Got wadén ban Krais wuné.’ Naate wado wupmalemu du taakwa yénaa yadan kudi véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wupmalemu du waariyaké de yo. Waariyado nak du waariyadakwaké bulké de yo. Yado véknwute guné wup yamarék yaké guné yo. Taale waga yaké de yo. Sésékukba yaaran tulé kukba yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nak képmaaba rakwa du taakwa de nak képmaaba rakwa du taakwa wale waariyaké de yo. Nak némaan banna kém nak némaan banna kém wale waariyaké de yo. Wupmalemu képmaaba du taakwa kaadé wale re kiyaaké de yo. Wupmalemu képmaaba wupmalemu apu apakélé anyék kutké lé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wani kapéredi mu wan taakwa nyaan batnyé kéraaké yate kaagél kutdakwa pulak. Wani taakwa kaagél las wawo kutdaran pulak, kukba kapéredi mu las wawo yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Guné wuna du ragunékwaké akwi képmaaba rakwa du taakwa gunéké kélik yaké de yo. Yate gunat kérae kure ye kapéredi mu gunat yate gunat viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wani tulé wupmalemu du taakwa wunéké kuk tiyaaké de yo. Wupmalemu du taakwa deku du taakwaké kélik yate derét deku maamaké kwayéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kukba wupmalemu du yae nak nak yénaa yate kéga waké de yo, ‘Wuné Gotna yéba kudi wakwekwa du wuné.’ Naate wate yénaa yado wupmalemu du taakwa deku kudi véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wupmalemu du taakwa wupmalemu kapéredi mu yaké de yo. Yate de yéknwun mawulé kulaknyénytakne de nak du taakwaké mawulat kapére yamarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wani tulé wuna du taakwa deku mawuléba apa yate wuna jébaa kutsaakudaran kukba Got derét kéraadu de dé wale miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wuna du taakwa gege gayét yéte akwi képmaaba rakwa du taakwat wuna kudi kéga wakweké de yo, ‘Got némaan ban rate du taakwaké miték véké dé yo.’ Naate wakwedo kukba sésékukba yaaran nyaa yaaké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Guné kéni nyégaba véte kéni muké miték sanévéknwuké guné yo. Wani kudi watakne dé Jisas kéga wakwek: “Déknyényba Gotna yéba kudi wakwen du nak déku yé Danyel dé kéni kudi kavik: Kukba du nak yae Gotna kudi buldakwa némaa gaba Got waatidén mu nak taknaké dé yo. Taknadu de wani gaké ‘Kapéredi ga’ naaké de yo. Waga kavidén mu yaaladu guné véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Véte wani tulé guné Judiaba rakwa du taakwa guna gayé kulaknyénytakne nébat bari yaage yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wani tulé kaapaba rakwa du taakwa bari yaage yéké de yo. Deku gwalmu kéraaké deku gat tépa wulaamarék yaké de yo. Bakna yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yaawiba tékwa du taakwa gayét gwaamale ye baapmu wut las wawo kéraamarék yaké de yo. Bari yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wani kapéredi tulé nyaan tékwa taakwa, baadiké munyaa kwayékwa taakwa bari yaage yéké yapatiké de yo. Deké wuné mawulé léknu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wani kapéredi tulé maas viyaakwa tuléba yaadéran yaga pulak guné bari yaage yéké guné yo? Wani kapéredi tulé yaap ra nyaaba yaadéran yaga pulak guné bari yaage yéké guné yo, Moses wakwen apa kudi yaap ra nyaaba guné séknaa yaabuba yémuké waatidékwa bege? Yégunéranké sanévéknwute guné Gorét waataké guné yo, wani kapéredi tulé wani tuléba yaamarék yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wani tulé wupmalemu kapéredi mu yaaké dé yo. Wani kapéredi mu akwi kapéredi mat talaknaké dé yo. Déknyényba Got akwi mu kuttaknadén tulé waga pulak kapéredi mu las kaapuk yaan. Bulaa wawo kukba wawo waga pulak kapéredi mu tépa yaamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wani kapéredi mu yaadu Got déku du taakwaké mawulé lékte wadu wani mu bari kaapuk yaké dé yo. Waga wamarék yadu mukatik akwi du taakwa kiyaado. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wani tulé du las gunat kéga wadaran, ‘Wani dut mé vé. Wan Got wadén ban Krais waba dé ro.’ Naate wadaran guné deku kudi véknwumarék yaké guné yo. De yénaa de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wupmalemu du yae Gotna du taakwat yénaa yate nak nak kéga waké de yo, ‘Wuné Got wadén ban Krais wuné.’ Waga wado las yénaa yate nak nak kéga waké de yo, ‘Wuné Gotna yéba kudi wakwekwa du wuné.’ Naate watakne de yénaa taknate kés pulak nak pulak apa jébaa, déknyényba vémarék yagunén apa jébaa wawo yaké de yo. Guna mawulé yaalébaanké waga yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gunat wunébu wakwek, kukba yaaran muké. Kukba wani mu yaadu guné véte kutdéngte guné deku kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Du taakwa las gunat waké de yo, ‘Mé vé. Got wadén ban Krais dé du ramarék taaléba dé ro.’ Naate wadaran guné wani taalat yémarék yaké guné yo. De gunat waké de yo, ‘Mé vé. Got wadén ban Krais wani gaba dé awula ro.’ Naate wadaran guné deku kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wuné Akwi Du Taakwana Nyaan gwaamale giyaawuru akwi du taakwa véké de yo. Nyét kulabidéka akwi du taakwa védakwa pulak, guné akwi wuné giyaawuru véké guné yo. Waga végunéranké sanévéknwute guné deku yénaa kudi véknwumarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Naate watakne dé Jisas kéni kudi wakwek, “Kwarékadi yaate jawudaka véte guné kiyaan kwaami nak radékwaké kutdéngék. Wani muké kutdénggunékwa pulak, guné wakwewurén mu véte kutdéngké guné yo, wuné yaawuréranké.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wani kudi watakne dé Jisas kéga wakwek: “Wani kapéredi mu yédu bari nyaa vémarék yadu gaan yaké dé yo. Yadu baapmu wawo vémarék yalu kun nyétba akéréké de yo. Akérédo nyétba tékwa akwi mu ségénte yeyé yeyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yado kéni képmaaba rakwa akwi du taakwa déknyényba vémarék yadan apa mu véké de yo nyétba. Véte wunéké kutdéngké de yo. Kutdéngte de géraaké de yo. Géraate de wuné Akwi Du Taakwana Nyaan wunat véké de yo. Wuné apat kapére yate nyaa vékwa pulak yate buwiba rate giyaawuru véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Védo nyétba rakwa du nak kaany némaanba yapévudu wuné wawuru wuna kudi kure giyaakwa du akwi képmaaba tékwa gege gayét ye Gotna du taakwat kure yéte nakurakba taknaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wani kudi watakne dé Jisas kéga wakwek: “Miké miték mé sanévéknwu. Mi las gaga périye kwény lépidéka véte guné kutdéngék. Kadému naaré yakwa tulé bulaa dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wani mit véte tuléké kutdénggunékwa pulak, guné wakwewurén mu véte kutdéngké guné yo. Wuné bari bari gwaamale yaaké wuné yo. Waga kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gunat wuné wakweyo. Bulaa rakwa du taakwa las kiyaamarék yate wekna rate wakwewurén akwi mu véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nyét képmaa wawo kaapuk yaké dé yo. Wuna kudi kaapuk yamarék yaké dé yo. Rasaakuké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yani nyaa gwaamale yaaké wuné yo? Kéni képmaaba rakwa du taakwa wani nyaaké kaapuk kutdéngdan. Gotna kudi kure giyaakwa du wani nyaaké kaapuk kutdéngdan. Wuné Gotna nyaan rate wuné wawo las kaapuk kutdéngwurén. Wuna yaapa dé kapmu dé gwaamale yaawuréran nyaaké kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Déknyényba Noa ran tulé du taakwa yadan pulak, gwaamale yaawuréran tulé du taakwa waga male yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa ran tulé apakélé kwayé kwamarék yaléka du taakwa de Gotké sanévéknwumarék yate kéni képmaana muké male de sanévéknwuk. Sanévéknwute kadému kadan, gu kadan, taakwa yadan, waga yadaka dé Noa apakélé sip yatakne dé wani sipba wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wani du taakwa Gotké sanévéknwumarék yate apakélé kwayéké kaapuk sanévéknwudan. Yadaka apakélé kwayé kwaléka de gu ke akwi kiyaasadak. Wuné Akwi Du Taakwana Nyaan gwaamale yaawuréran tulé wupmalemu du taakwa wani du taakwa yadan pulak, kéni képmaana muké male sanévéknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gwaamale yaawuréran tulé du vétik kadému yaananbérén képmaaba jébaa yabéru Gotna kudi kure giyaakwa du naknét kéraate naknét kulaknyényké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wani tulé taakwa vétik kadému kawu saakérabéru Gotna kudi kure giyaakwa du naknét kéraate naknét kulaknyényké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","De waga yado guné wunéké raségéte miték véké guné yo. Wuné guna Némaan Ban yaawuréran nyaaké kaapuk kutdénggunén. Yate guné wunéké raségéte miték véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Kéni aja kudi mé miték véknwu. Sél yakwa du yaaran tuléké gana bapadu kutdéngdu mukatik dé widé kwaamarék yate miték védu sél yakwa du déku ga pérae wulaamarék yakatik dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wani kudiké sanévéknwute guné wunéké raségéte miték véké guné yo. Guné kaapuk kutdénggunén. Yani tulé wuné Akwi Du Taakwana Nyaan gwaamale yaaké wuné yo? Kutdéngmarék yagunéran tulé wuné gwaamale yaaranké sanévéknwute guné wunéké raségéte miték véké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wani kudi watakne dé Jisas kéga wakwek: “Yéknwun mawulé yate yéknwun jébaa yakwa du kéga yaké dé yo. Déku némaan ban dérét kéga waké dé yo, ‘Méné wuna jébaa yakwa duké téségéké méné yo. Yate méné deké kadému kwayéké méné yo.’ Naate watakne yédu dé waga yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yadu kukba déku némaan du gwaamale yae véte waké dé yo, ‘Méné jébaa miték ménébu yak. Wan yéknwun.’ Naate wadéran yéknwun jébaa yakwa du yéknwun mawulé yate miték raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Déku némaan ban yadén yéknwun jébaa véte waké dé yo, ‘Méné gwaamale yaawuréran nyaaké kutdéngmarék yate, méné yéknwun jébaa ménébu yak. Wan yéknwun. Bulaa méné wuna akwi gwalmuké miték véké méné yo.’ Naate waké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kapéredi mawulé yate kapéredi jébaa yakwa du déku mawuléba kéga waké dé yo, ‘Wuna némaan ban nak gayét ye dé bari gwaamale yaamarék yaké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naate watakne dé dé wale jébaa yakwa duwat viyaaké dé yo. Viyaatakne dé waagété gu kakwa du wale rate kadému kate waagété gu kate dé waagété yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yate déku némaan banké sanévéknwumarék yadu wani tulé déku némaan ban gwaamale yaaké dé yo. Kutdéngmarék yadéran tulé gwaamale yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yae wani jébaa yakwa du yan kapéredi mu véte dérét némaanba viyaaké dé yo. Viyae wadu dé ye yénaa yakwa du wale raké dé yo, kapéredi taaléba. Wani taaléba raran du taakwa némaa kaagél kutte géraaké de yo. Yéknwun taaléba raké mawulé yate de némaanba géraaké de yo.” Naate dé Jisas aja kudi wakwek, de yéknwun mawulé yate gwaamale yaadéranké raségédoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wani kudi watakne dé Jisas kéga kudi wakwek: “Gwaamale yaawuréran nyaa Got wadu du taakwa las dé wale rado du taakwa las dé wale ramarék yaké de yo. Got némaan ban rate kéga yaké dé yo. Du nak taakwa yaké dé yak. Yadéka taakwa taaba vétik deku lam kérae kure de dérét véte kwole ye du bét taakwa wale kadému kaké de yaabuba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wani taakwa naktaba de yéknwun mawulé yak. Yadaka taakwa naktaba de kaapuk miték sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yate de deku lam kure yéte de yaa sérak gu las wawo kaapuk kure yédan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yadaka de yéknwun mawulé yan taakwa deku lam kure yéte yaa sérak gu las wawo de kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ye yaabuba radaka dé taakwa yaran du bari kaapuk yaadén. Yadéka wani taakwana méni widé yadéka de kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nyédé gubés yadéka dé du nak kéga waak, ‘Taakwa yaran du kéni dé yao. Guné ye yaabuba dérét véte guné kwole yaaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Naate waadéka wani kudi véknwutakne de wani taakwa akwi ligéne raapme de deku lam séraknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sérakdaka de miték sanévéknwumarék yan taakwa de yéknwun mawulé yan taakwat wak, ‘Guné naanéké yaa sérak gu las tiyaaké guné yo. Naana lam kiyaakgé dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Naate wadaka de yéknwun mawulé yan taakwa derét wak, ‘Kaapuk. Kéni yaa sérak gu walkamu male dé tu. Naané gunéké gu las kwayénaran sal naana lam akwi kiyaakgé dé yo? Guné sétuwat ye guné las kéraaké yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Naate wadaka de wani gu kéraaké yédaka dé taakwa yaran du yaak. Yaadéka de yéknwun mawulé yan taakwa dérét kwole ye de kadému kadaran gat wulaak. Wulaadaka de gwés tépék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kukba miték sanévéknwumarék yan taakwa yae de waak, ‘Némaan ban, méné mé gwés naapi. Naané yaalaké naané.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naate waadaka dé taakwa yaran du derét wak, ‘Kaapuk. Wuné gunat las kaapuk kutdéngwurén. Adél wuné wo.’ Naate dé miték sanévéknwumarék yan taakwat wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wani kudi watakne Jisas dé derét wak, “Wani kudiké sanévéknwute wunéké wawo mé sanévéknwu. Gwaamale yaawuréran nyaaké guné kaapuk kutdénggunén. Yate guné wunéké raségéte miték véké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wani kudi watakne dé Jisas kéni aja kudi wakwek: “Gwaamale yaawuréran nyaa Got némaan ban rate kéga yaké dé yo. Némaan ban nak dé nak gayét yéké yate déku jébaa yakwa duwat waadéka yaadaka dé derét wak, de déku yéwaa kérae wani yéwaa wale jébaa yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Watakne deku apaké kutdéngte dé deké nak nak yéwaa munikwek. Nakgé dé wupmalemu yéwaa kwayék (5,000). Nakgé dé wupmale yéwaa kwayék (2,000). Nakgé dé walkamu yéwaa kwayék (1,000). Waga kwayétakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yédéka wupmalemu yéwaa nyégélén du bari ye wani yéwaa wale jébaa ye dé wupmalemu yéwaa las wawo nyégélék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wupmale yéwaa nyégélén du dé wawo wani yéwaa wale jébaa ye dé wupmale yéwaa las wawo nyégélék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Walkamu yéwaa nyégélén du dé wani yéwaa wale jébaa las kaapuk yadén. Dé ye waagu vae wani yéwaa dé waaguba rémék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kukba wupmalemu kwaaré yédéka dé némaan ban tépa gwaamale yaak, déku jébaa yakwa duké. Yae dé deké kwayédén yéwaaké de wale kudi bulké mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yadéka dé wupmalemu (5,000) yéwaa nyégélén du wani yéwaa kure yae kwayéte dé wak, ‘Némaan ban, méné wunéké wupmalemu (5,000) yéwaa méné tiyaak. Bulaa mé vé. Wani yéwaa wale jébaa yawuréka tiyaadan yéwaa kén kén. Wupmalemu (5,000) yéwaa las wawo wuné nyégélék.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Naate watakne akwi yéwaa (10,000) kwayédéka dé déku némaan ban wak, ‘Méné yéknwun jébaa yakwa du méné. Yéknwun jébaa ménébu yak. Méné makwal muké ménébu miték vék. Véménénké wuné wawuru méné wupmalemu muké némaan ban raké méné yo. Méné wuné wale rate, ané yéknwun mawulé yate miték raké ané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Dé waga wadéka dé wupmale (2,000) yéwaa nyégélén du yae dé wak, ‘Némaan ban, méné wunéké wupmale (2,000) yéwaa méné tiyaak. Bulaa mé vé. Wani yéwaa wale jébaa yawuréka tiyaadan yéwaa kén kén. Wupmale (2,000) yéwaa las wawo wuné nyégélék.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naate watakne akwi yéwaa (4,000) kwayédéka dé déku némaan ban wak, ‘Méné yéknwun jébaa yakwa du méné. Yéknwun jébaa ménébu yak. Méné makwal muké ménébu miték vék. Véménénké wuné wawuru méné wupmale muké némaan ban raké méné yo. Méné wuné wale rate, ané yéknwun mawulé yate miték raké ané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dé waga wadéka dé walkamu (1,000) yéwaa nyégélén du yae dé wak, ‘Némaan ban, wuné ménéké wuné kutdéngék. Méné du taakwaké mawulé kaapuk lékménékwa. Méné gwalmu las wawo kéraaké mawulé yate jébaa yate méné nak du taakwat kutkalé kaapuk yaménékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wuné ménéké wup yate wuné képmaaba waagu vae ména yéwaa rémék. Tépa kérae wuné ména yéwaa ménéké wuné kure yao. Mé kut.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naate wadéka dé némaan ban dérét wak, ‘Méné kapéredi jébaa yate wulkiyaa yakwa du méné. Wuné nak du taakwaké mawulé lékmarék yate, gwalmu las wawo kéraaké mawulé yate, jébaa yate, wuné nak du taakwaké kaapuk sanévéknwurékwa. Wan adél méné wak. Waga yawurékwaké ménébu kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kutdéngte samuké méné wuna yéwaa kure ye yéwaa taknadakwa gaba taknamarék yak? Méné waba taknaménu mukatik wuné gwaamale yae wani yéwaa kéraate yéwaa las wawo kéraakatik wuné yak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naate watakne dé jébaa yakwa nak duwat wak, ‘Guné déké kwayéwurén yéwaa dérét nyégéle guné wupmalemu (10,000) yéwaa yan duké kwayéké yo.’ Naate dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jisas wani kudi watakne dé derét wak, “Yéknwun jébaa ye wupmalemu gwalmu kéraan du taakwa kukba gwalmu las wawo kéraaké de yo. Yéknwun jébaa yamarék ye walkamu gwalmu yan du taakwa kukba bakna raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naate watakne dé Jisas wak, “Wani némaan ban dé déku jébaa yakwa duwat wak, ‘Guné kapéredi jébaa yan dut kérae kaapat yatjagwadéké guné yo. Yagunu dé gaankété yakwa kapéredi taaléba raké dé yo. Wani taaléba du taakwa némaa kaagél kutte géraaké de yo. Yéknwun taaléba raké mawulé yate de némaanba géraaké de yo.’ Naate dé némaan ban wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wani kudi watakne dé Jisas kéga wakwek: “Kukba wuné Akwi Du Taakwana Nyaan gwaamale yaaké wuné yo. Gotna kudi kure giyaakwa du wuné wale yaado wuné akwi du taakwaké némaan ban raké wuné yo. Apat kapére yate némaan ban rate deké wakweké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kéni képmaaba rakwa akwi du béré taakwa béré wuna méniba jawe saakiké de yo. Saakido wawuru de kém vétik téké de yo. Sipsipké téségékwa du yadékwa pulak wuné yaké wuné yo. Dé jébaa yate sipsip meme pévédéka de sipsip nak taalat yédaka de meme nak taalat de yu. Wani du yadékwa pulak wuné yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yate wuné du taakwat wawuru de du taakwa las wuna yéknwun tuwa taababa tédo de las wuna aki tuwa taababa téké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tédo wuné némaan ban rate wuna yéknwun tuwa taababa tékwa du taakwat kéga waké wuné yo, ‘Wuna yaapa Got gunat débu kutkalé yak. Bulaa guné mé yaala. Miték rasaakugunéran taalé débu miték yak. Déknyényba kéni képmaa batnyé yadén tulé dé miték rasaakugunéran taaléké dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Déknyényba wuné kaadé wale rawuréka guné wunéké kadému tiyaak. Gutak yadéka guné wunéké gu tiyaagunéka wuné kak. Wuné nak geba yaawuréka guné wunat guna gat kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wuné baapmu wut yamarék bakna téwuréka guné wunéké baapmu wut tiyaagunéka wuné gik. Kiyakiya yadéka guné wunat kutkalé yak. Wuné raamény gaba kwaawuréka guné yaate guné wunat vék. Waga yagunénké bulaa yéknwun taaléba miték rasaakuké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wuné waga wawuru yéknwun mu yakwa du taakwa kéga waké de yo, ‘Némaan Ban, yani nyaa méné kaadé wale raménéka naané ménéké kadému kwayék? Yani nyaa méné guké kiyaaménéka naané ménéké gu kwayék? ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yani nyaa méné nak geba yaaménéka naané ménat naana gat kure yék? Yani nyaa méné baapmu wut yamarék bakna téménéka naané ménéké baapmu wut kwayék? ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yani nyaa ménat kiyakiya yadéka naané ménat kutkalé yak? Yani nyaa méné raamény gaba kwaaménéka naané ménat véké yék?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Waga waatado wuné némaan ban rate derét kéga waké wuné yo, ‘Guné wuna jébaaba yaalan du taakwat nak kutkalé yate guné wunat wawo kutkalé guné yak. Adél wuné gunat wakweyo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wuné waga watakne wuné wuna aki tuwa taababa téran du taakwat kéga waké wuné yo, ‘Got gunéké débu kuk kwayék. Bulaa guné wunat kulaknyénytakne yaa yaansaakukwa taalat yéké guné yo. Wani yaa kiyaakmarék yaké dé yo. Déknyényba Got wani taalé yatakne dé wak, Seten déku du wale wani kapéredi taaléba raké de yo. Naate wadén taalat guné yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Déknyényba wuné kaadé wale rawuréka guné wunéké kadému kaapuk tiyaagunén. Gutak wunat yadéka guné wunéké gu kaapuk tiyaagunén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wuné nak geba yaawuréka guné wunat kaapuk kure yégunén guna gat. Wuné baapmu wut yamarék bakna téwuréka guné wunéké baapmu wut kaapuk tiyaagunén. Wunat kiyakiya yadéka, raamény gaba wawo kwaawuréka guné wunat kaapuk yae végunén.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wuné waga wawuru de wawo waké de yo, ‘Némaan Ban, yani nyaa méné kadému guké kiyaaménéka véte naané ménéké kadému gu kaapuk kwayénan? Yani nyaa méné nak geba yaaménéka, baapmu wut yamarék bakna téménéka, ménat kiyakiya yadéka, raamény gaba kwaaménéka, véte naané ménat kutkalé kaapuk yanan?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naate wado wuné némaan ban rate derét kéga waké wuné yo: ‘Guné wuna jébaaba yaalan du taakwat nak kutkalé yamarék yate guné wunat wawo kutkalé kaapuk yagunén. Deké kuk kwayéte wunéké wawo guné kuk tiyaak. Adél wuné gunat wakweyo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Wuné waga wawuru wuna jébaaba yaalan du taakwat kutkalé yamarék yan du taakwa de kapéredi taalat yéké de yo. Ye waba rate apakélé kaagél kutsaakuké de yo. Yado wuna jébaaba yaalan du taakwat kutkalé yan du taakwa yéknwun gayét ye apuba apuba miték rasaakuké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas wani kudi wakwebutitakne dé déku duwat kéni kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Guné kutdéngék. Nyaa vétik male re naané Juda Pasova waanakwa kadému sérakne kaké naané yo. Wani tulé de wuné Akwi Du Taakwana Nyaan wunat wuna maamaké kwayédo de wunat miba viyaapata taknaké de yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wani tulé Gotna gaba jébaa yakwa nyédé duna némaan du, kubu du wawo ye nyédé duna némaan ban déku némaan gaba jawe de rak. Wani némaan banna yé Kaiapas. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rate kudi de bulék, de akélak ye Jisasnyét kulékiye viyaapérekdaranké. Bulte waga yaké de kudi gik. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kudi gite de wak, “Dérét viyaapérekgé naané yo. Kadému sérakne kanaran nyaa dérét kulékimarék yaké naané yo. Bulaa wupmalemu du taakwa wani kadému kaké kéni gayét debu yaak. Bulaa naané Jisasnyét kulékinaran de rékaréka yate naanat némaanba waatiké de yo. De yédo naané dérét kulékiye viyaapérekgé naané yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Jerusalem kulaknyénytakne dé Betanit yék. Ye saabe dé déknyényba lepéro yan du déku yé Saimon déku gaba dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rate de kadému kadaka lé taakwa nak matut yadan makwal agérap kure yaak. Wani agérapba yéknwun yaama yakwa gu dé ték. Du wani gu kéraaké wupmalemu yéwaa kwayéké de yo. Wani taakwa yae lé Jisas ranba téte lé déku maaknaba wani gu sévik. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Séviléka de Jisasna du véte de rékaréka yak. Yate de wak, “Samuké lé wani gu bakna sévik? ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wani gu wan yéknwun gu. Lé wani gu kwayétakne wupmalemu yéwaa nyégéle gwalmu yamarék du taakwaké kwayélu mukatik miték yakatik lé yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas deku kudi véknwute dé derét wak, “Samuké guné wani taakwat waatiyu? Waga yamarék yaké guné yo. Wan yéknwun mu lé yak wunéké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gwalmu yamarék du taakwa de guné wale de rasaaku. Apuba apuba guné derét kutkalé yaké guné yo. Wuné guné wale rasaakumarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wani taakwa wuné kiyaawuru waaguba rémdaranké sanévéknwute lé wani gu wuna sépéba sévik.” Naate wate dé Juda gaaba ségwi rémké yate yadakwaké dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wakwetakne dé derét kéga wak, “Kukba de wuna kudi akwi képmaaba wakwete kéni taakwa yan muké wawo wakweké de yo. Wakwete léké sanévéknwuké de yo. Adél wuné gunat wakweyo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wani tulé dé Jisasna du nak déku yé Judas Iskariot dé Gotna gaba jébaa yakwa nyédé duna némaan duké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ye dé derét wak, “Guné wunéké samu tiyaagunu wuné Jisasnyét gunéké kwayéké wuné yo?” Naate wadéka de déké yéwaa las (30) kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kwayédaka ye dé Jisasnyét deké kwayédéranké sanévéknwuk. Sanévéknwute dé wani muké bulmarék yate dérét kwayédéran tuléké dé raségék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pasova waanakwa tuléna kadému sérakne kanakwa tulé naané Juda béret kate yis kutmarék yadan béret male naané ko. Wani tulé yadéka yis kutmarék yadan béret batnyé sérakdan nyaa Jisasna du déké yae de wak, “Yaba gwalmu las kawu saakérano Pasova waanakwa tuléna kadému rate kaké méné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Naate wadaka dé wak, “Guné Jerusalemét wulae déknyényba wakwewurén dut véte guné dérét waké yo, ‘Naana némaan ban, Gotna kudiké naanat yakwatnyékwa ban kéga dé wo, Wuné kiyaaran tulé kéni dé yao. Wuné wuna du wale ména gaba Pasova waanakwa tuléna kadému kaké naané yo.’ Naate guné dérét waké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naate wadéka de Jisasna du wakwedén pulak ye de kadému kawu saakérak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nyaa dawulidéka dé Jisas yae déku du taaba vétik sékérékne maanba kayék vétik waga de wale rate de kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kate dé derét wak, “Naané wale rakwa du nak wunat wuna maamaké kwayéké dé yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Naate wadéka deku mawulé kapére yadéka kwagénte de nak nak dérét waatak, “Némaan Ban, wan wunéké méné wo, kapu kiyadéké méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Naate waatadaka dé wak, “Wuné wale agérapba tékwa guba béret tawun du wunat maamaké kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wuné Akwi Du Taakwana Nyaan kiyaaké wuné yo. Gotna nyégaba kiyaawuréranké déknyényba de kudi kavik. Kiyaawuru kapéredi mu yaaké dé yo, wunat maamaké kwayéran duké. Wani dut déku néwaa kéraamarék yalu mukatik wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Naate wadéka dé Jisasnyét maamaké kwayéran du Judas dé wak, “Némaan ban, wan wunéké méné wo, kapu yaga pulak?” Naate wadéka dé Jisas dérét wak, “Ao. Wan adél méné wo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisas déku du wale rate kadému kate dé béret kérae dé Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayéte dé wak, “Guné kérae guné kaké yo. Kén wuna sépé.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Naate watakne dé wain gu tén agérap nak kérae dé Gorét wak, “Yéknwun gu ménébu tiyaak. Wan yéknwun.” Naate watakne dé déku duké kwayéte dé wak, “Guné akwi kéni gu kaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kén wuna wény. De wunat viyaapérekdo wuna wény akudu guné véte kutdéngké guné yo, Got du taakwat kutkalé yaké wakwedén kudi adél yadéranké. Wuna wény akudu Got wupmalemu du taakwa yadan kapéredi mu yatnyéputiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gunat wuné wakweyo. Kéni képmaaba wekna rate wuné wain gu tépa kamarék yaké wuné yo. Kukba wuna yaapa Got du taakwaké némaan ban radu, naané déku gayéba dé wale rate wuné guné wale kulé wain gu kaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wani kudi wadéka de Gotna nyégaba kwaakwa gwaaré waatakne raapme gwaade de Oliv nébat waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","De yaabuba yéte dé Jisas déku duwat wak, “Bulaa gaan guné akwi wunéké kuk tiyaate yaage yéké guné yo. Waga wuné kutdéngék. Yaage yégunéranké Gotna kudi déku nyégaba kéga dé kwao: Wuné sipsipké téségékwa duwat viyaawuru de sipsip yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wani kudi wadékwa pulak yaage yégunu wuné kiyaaké wuné yo. Kiyae kukba tépa nébéle raapme wuné Galilit taale yéké wuné yo. Yéwuru guné kukba yaaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naate wadéka dé Pita dérét wak, “Wuné ménéké kuk kwayémarék yaké wuné yo. Wuné yaage yémarék yaké wuné yo. Nak du ménéké kuk kwayéte yaage yédaran, wuné waga yamarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Naate wadéka dé Jisas wak, “Wuné kutdéngék. Bulaa gaan séraa waamarék yadu méné apu kupuk waké méné yo, ‘Wuné Jisasnyét las kaapuk kutdéngwurén.’ Naate waménu séraa waaké dé yo. Waga kutdéngte wuné ménat wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naate wadéka dé Pita wak, “Kaapuk. Waga wamarék yaké wuné yo. Wuné méné wale kiyaawuréran wuné wup yamarék yaké wuné yo. Wani kudi wamarék yaké wuné yo.” Naate wadéka Jisasna nak du akwi waga male de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wani kudi watakne Jisas déku du wale waga de taalat nak wulaak. Wani taaléna yé Getsemani. Waba rate dé derét wak, “Guné kéba mé ra. Wuné ye Got wale kudi bulké wunék.” Naate watakne dé Pita, Sebedina nyaan vétiknét waga kwole de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yédaka dé déku mawulé kapére yadéka dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yate dé derét wak, “Wuna wuraanyan dé génu. Kén kiyaaké wuné yo. Guné kéba raké guné yo. Widé kwaamarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naate wadéka de radaka dé walkamu ye képmaaba kwaate dé Gorét wak, “Wuna yaapa, méné akwi muké méné apa yo. Méné yaaran muké waké mawulé yaménéran méné waménu wunéké yaaran kapéredi mu wunéké yaamarék yaké dé yo. Waga ménat wuné waato. Méné mawulé yawurékwa pulak yamarék yaké méné yo. Méné mawulé yaménékwa pulak yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wani kudi watakne dé déku duké gwaamale ye dé vék de widé kwaadaka. Véte dé derét waaséligénte dé Pitat wak, “Yaga pulak? Guné makwal tulé wuné wale raké guné yapatiyu. Guné widé guné kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Guné widé kwaamarék yate miték sanévéknwute Gorét waataké guné yo, kapéredi mu gunat yaalébaanmarék yaduké. Wuné kutdéngék. Guné widé kwaamuké kélik yagunéka guna sépé apa yamarék yadéka gunat widé yadéka guné widé kwaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naate watakne tépa derét kulaknyénytakne walkamu ye dé Gorét kéga wak, “Wuna yaapa, wunéké yaaran kapéredi mu wunéké yaadu wuné wani muké kuk kwayémarék yaké wuné yo. Wani muké kusékétké wuné yo. Méné mawulé yaménékwa pulak yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Naate watakne déku duké tépa gwaamale ye dé vék de tépa widé kwaadaka. Deku méni widat kapére yadéka de widé kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Déku duwat tépa kulaknyénytakne ye dé Gorét tépa waatak. Taale Gorét waatadén kudi male dé tépa waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Waatatakne déku duké gwaamale yae derét waaséligénte dé wak, “Yaga pulak? Guné wekna guné widé kwao? Mé véknwu. Wuné Akwi Du Taakwana Nyaan wunat kapéredi mu yakwa duké kwayédéran tulé kéni dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mé raapgunu yéno. Mé vé. Wunat maamaké kwayéran du déwa yaakwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wekna téte buldéka dé déku du nak Judas yaak. Wupmalemu du de waariyadakwa kulaa baagé wawo kure de dé wale yaak. Gotna gaba jébaa yakwa nyédé duna némaan du, Isrelna kubu du wawo taknaba waga wadaka de yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Taknaba Jisasnyét maamaké kwayéran du Judas dé Jisasnyét kulékiran duwat wak, “Wuné taama véran (daama réngran) du wan Jisas. Guné dérét kulékiké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Jisaské bari yae dé wak, “Némaan ban, méné miték raké méné yo.” Naate watakne dé dérét taama vék (daama réngék). ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yadéka dé Jisas dérét wak, “Méno, yaké mawulé yate yaké yaaménén mu bari yaké méné yo.” Naate wadéka de déké yae dérét kulékik. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kulékidaka dé Jisas wale tén du nak waariyadékwa kulaa kelikne dé nyédé duna némaan banké jébaa yakwa dut viyaate déku waan takutépakdéka dé akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Akérédéka dé Jisas dérét wak, “Waariyaménékwa kulaa tékwa wutba mé laakwa. Waariyadakwa kulaat du waariyado nak du derét waariyadakwa kulaat viyaado de kiyaaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wuné mawulé yawuru mukatik wuné wuna yaapat waatawuru dé bari wadu déku kudi kure giyaakwa wupmalemu du yae wunat kutkalé yado. Wani muké méné kaapuk sanévéknwuménén. Wuné wuna yaapat waga waatamarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Déknyényba du las Gotna nyégaba de kavik, nak du yae wunat kulékiye kure ye viyaapérekdaranké. Wuna yaapa wunat kutkalé yaduké waatawuru mukatik kavidan kudi adél yamarék yadu. Wuné wuna yaapa wunat kutkalé yaduké waatamarék yawuru de déku kudi kure giyaakwa du wunat kutkalé yaké yaamarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wani kudi watakne dé Jisas dérét kulékiké yaan duwat wak, “Guné wunat kulékiké yaate samuké guné waariyagunékwa kulaa baagé wawo kure yao? Guné sél yakwa dut viyaaké guné wani mu kure yao, kapu yaga pulak? Wupmalemu nyaa wuné Gotna kudi bulnakwa némaa gaba rate wuné du taakwat Gotna kudiké yakwatnyék. Waba rawuréka guné wunat kaapuk kulékigunén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wunat yagunékwa muké déknyényba du las Gotna nyégaba de kavik. Kavidaka bulaa deku kudi adél dé yo.” Naate wadéka déku du akwi dérét kulaknyénytakne de yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisasnyét kulékin du de dérét kure yék Kaiapasna gat. Kaiapas wan Gotna gaba jébaa yakwa akwi nyédé du deku némaan ban. Apa kudiké kutdéngkwa du, Isrelna kubu du wawo Kaiapasna gaba jawe radaka de Jisasnyét wani gat kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yédaka dé Pita Jisasna kukba ye dé séknaaba ték. Téte dé vék Jisasnyét kulékin du dérét kure wani gaba wulaadaka. Véte dé kwabugi du wale kaapaba dé rak. Jisasnyét yadaran mu véké nae dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nyédé duna némaan du, Isrelna nak némaan du wawo de Jisasnyét viyaapérekgé de mawulé yak. Yate de wak, “Jisas yadén kapéredi muké kiyadé waké yo?” Naate wate de yénaa kudiké kélik kaapuk yadan. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yate wadaka de wupmalemu yénaa yakwa du yae de Jisas yan muké wakwek. Wakwedaka némaan du de yadén kapéredi muké las kaapuk véknwudan. Yadaka bét du vétik yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Yae bét wak, “Wani du kéga dé wak, ‘Wuné Gotna kudi bulnakwa némaa ga yaalébaanké wuné yo. Yaalébaane nyaa kupuk yédu wuné tépa kaaké wuné yo.’ Naate wani du dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wani kudi wabétka dé nyédé duna némaan ban raapme téte dé Jisasnyét wak, “Samuké méné bétku kudi kaatamarék yo? Bétku kudi yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Naate wadéka Jisas kudi las kaapuk buldén. Yadéka dé nyédé duna némaan ban dérét wak, “Wuné rasaakukwa ban Gotna yéba wakwete wuné wo, méné wunat adél kudi wakweménuké. Méné Got wadén ban Krais méné, kapu yaga pulak? Méné Gotna nyaan méné, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wani kudi wadéka dé wak, “Ao. Wani méné wak. Kén gunat akwi wuné wakweyo. Kukba guné véké guné yo, wuné Akwi Du Taakwana Nyaan némaan ban rate apat kapére yakwa ban Gotna yéknwun tuwa taababa re buwi wale awuré nyétba giyaawuru.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas waga wadéka dé nyédé duna némaan ban rékaréka yate dé déku baapmu wut gétbiyaate dé wak, “Dé waga wate Gotké kapéredi kudi bulte dé Gorét waséléknék. Guné déku kudi gunébu véknwuk. Wan kapéredi kudi. Nak duwat waatamarék yaké naané yo, yadén kapéredi muké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yaga guné wo déké?” Naate wadéka de wak, “Dé kapéredi mu débu yak. Dé mé kiyao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wani kudi watakne Jisasna ménidaamaba sépmeny sévaavidaka de las dérét taabat viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Viyaate dérét wasélékte de wak, “Méné Got wadén ban Krais, Gotna yéba kudi wakwekwa du rate méné akwi muké méné kutdéngék. Kutdéngte, naanat mé wakwe. Kiyadé ménat viyaak?” Naate wate de dérét waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita kaapaba dé rak. Gaké raatmu gisagwadédanba dé rak. Radéka lé wani gaba jébaa yakwa taakwa nak yae lé dérét wak, “Méné wawo wan Galiliba yaan ban Jisas wale méné ték.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naate waléka dé Pita waba rakwa du taakwana méniba téte dé wak, “Kaapuk. Wuné wanyénékwa kudi las kaapuk kutdéngwurén.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naate watakne gwaade dé gwéspétéba rak. Radéka jébaa yakwa taakwa nak wawo dérét véte lé lé wale tén du taakwat wak, “Kéni du Nasaret ban Jisas wale dé ték.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naate waléka dé némaanba wak, “Kaapuk. Wani dut las kaapuk kutdéngwurén. Adél wuné wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naate wadéka walkamu re de waba tén du las déké yae de wak, “Galiliba yaan du kudi buldakwa pulak méné kudi bulu. Méné wawo Galiliba yaan du méné. Méné Jisasna du nak. Wan adélna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Naate wadaka dé Pita derét némaanba wak, “Kaapuk. Wani dut las kaapuk kutdéngwurén. Adél wuné wo. Adél kudi wamarék yawuréran Got wunat dé mé viyao.” Waga wadéka dé séraa waak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Waadéka dé Jisas dérét wakwedén kudiké dé sanévéknwuk. Taknaba Jisas dé wak, “Wuné kutdéngék. Séraa waamarék yadu méné apu kupuk waké méné yo, ‘Wuné dérét las kaapuk kutdéngwurén.’ Naate waménu séraa waaké dé yo.” Wani kudiké sanévéknwute Pita gwaade némaa mawulé lékte dé géraak, dé Jisaské kuk kwayédén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yé tékdéka de nyédé duna némaan du, Isrelna kubu du waga de kudi gik, Jisasnyét viyaapérekgé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kudi gite dérét baagwit gitakne de Romna némaan du Pailatké de dérét kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisasnyét maamaké kwayén du Judas dé kudi véknwuk de Jisasnyét viyaapérekgé kudi buldaka. Véknwutakne dé nak mawulé yate nyédé duna némaan du, Isrelna kubu du waga radaka dé deké gwaamale yék. Ye dé déké kwayédan yéwaa deké tépa kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kwayéte dé wak, “Wuné kapéredi mu wunébu yak. Wuné kapéredi mu las yamarék dut déku maamaké wunébu kwayék. Kwayéwurén de dérét viyaado dé kiyaaké dé yo.” Naate wadéka de wak, “Wan naana jébaa kaapuk. Wan ména jébaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naate wadaka dé wani yéwaa Gotna kudi buldakwa némaa gaba yatjawulatakne dé yék. Ye dé baagwiba kwalak ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nyédé duna némaan du yatjawuladén yéwaa kéraate de wak, “Kén dut viyaapérekdoké kwayénan yéwaa. Kéni yéwaa Gotna kudi bulnakwa némaa gaba rakwa yéwaa wale taknanaran Moses wakwen apa kudiké kuk kwayéké naané yo. Wani yéwaa wale taknamarék yaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Waga kudi bultakne de wani yéwaa kérae képmaat awu yan duké kwayétakne déku képmaa de kéraak. Kérae de wak, “Nak geba yaan du taakwa naana gayéba kiyaadaran naané derét kéni képmaaba rémké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naate watakne waga yadaka du taakwa wani képmaaké de yé kéga waak, “Wény képmaa.” Bulaa wawo wani képmaaké waga naané yé wao. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nyédé duna némaan du waga yadaka dé Gotna yéba déknyényba rate kudi wakwen du nak déku yé Jeremaia kavin kudi adél dé yak. Jeremaia Gotna nyégaba kéga dé kavik: Isrelna du taakwa kéga de wak, “Dérét kéraaké naané yo. Yéwaa las (30) kwayétakne naané dérét kéraaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naate watakne de wani yéwaa kérae képmaat awu yan duké kwayétakne déku képmaa de kéraak. Némaan Ban Got wunat dé wak wani muké. Waga dé Jeremaia kavik, Jisasna néwaa dérét kéraamarék yalén tulé. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasnyét kure yédaka dé Romna némaan du Pailatna méniba ték. Tédéka dé Pailat dérét waatak, “Méné Judana némaan ban kapu kaapuk?” Naate waatadéka dé Jisas wak, “Ao. Méné kapmu méné waga wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Naate wadéka de nyédé duna némaan du, Isrelna kubu du wawo de yénaa kudi wakwek, Jisas yan muké. Jisas wani kapéredi mu kaapuk yadén. De déké yénaa kudi wakwedaka dé deku kudi kaapuk kaatadén. Kudi las kaapuk buldén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yadéka dé Pailat dérét wak, “Méné ménéké wakwedakwa akwi kudi las méné véknwu, kapu yaga pulak? Samuké méné kudi bulmarék téte vu?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naate wadéka dé Pailarét kaapuk kudi las wakwedén. Yadéka dé Pailat sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akwi kwaaré Pasova waanakwa kadému kanakwa tulé dé Romna némaan du raamény gaba kwaakwa dut nak wadéka dé raamény ga kulaknyénytakne gwaade dé miték yék. Jerusalemba rakwa du taakwa deku mawuléba sanévéknwute Romna némaan dut waadaka dé mawulé yadakwa dut wadéka dé raamény ga kulaknyénytakne gwaade dé miték yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wani tulé kapéredi mu yan du nak raamény gaba dé kwaak. Déku yé Jisas Barabas. Wupmalemu du taakwa déké de kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat dé kutdéngék. Jisas kapéredi mu las kaapuk yadén. Némaan du de Jisaské kélik yate de dérét gitakne kure yaak déké. Waga kutdéngte déku mawuléba dé wak, “Sal kéba jawe tékwa du taakwa Jisaské mawulé yaké de yo, kapu yaga pulak?” Naate wate dé wani du taakwat wak, “Yaga pulak guné mawulé yo? Kiyadat wawuru dé miték yéké dé yo? Barabasnyét wawuru dé raamény ga kulaknyénytakne yaale miték yéké dé yo, kapu Got wadén ban Krais waadakwa ban Jisasnyét wawuru dé miték yéké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat kudi véknwudékwa taaléba radéka lé déku taakwa kudi wakwesatite lé wak, “Méné wani yéknwun mu yakwa dut yaalébaanmarék yaké méné yo. Gaan kwae wuné déké yégan yak. Yawuréka wuna mawulé kapére dé yo.” Naate lé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nyédé duna némaan du, Isrelna kubu du wawo waga de waba tén du taakwat wak, de Pailarét wado dé wadu Barabas raamény ga kulaknyénytakne yaale miték yédu de Jisasnyét viyaapérekdoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Waga wadaka dé némaan du Pailat derét tépa dé waatak, “Kéni du vétikgé yaga pulak guné mawulé yo? Kiyadat wawuru dé gunéké yaale miték yéké dé yo?” Naate wadéka de wak, “Barabas.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naate wadaka dé Pailat wak, “Krais waadakwa ban Jisasnyét yaga pulak yaké wuné yo?” Naate waatadéka de akwi wak, “Dérét miba mé viyaapata takna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naate wadaka dé wak, “Samuké? Samu kapéredi mu dé yak.” Naate wadéka de némaanba waak, “Dérét miba mé viyaapata takna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","De waga waadaka dé Pailat déku mawuléba wak, “De wuna kudi kaapuk véknwudakwa. Wuné deku kudi véknwumarék yawuréran de waariyaké de yo.” Naate watakne dé gu las kérae dé akwi du taakwana méniba téte déku taaba yakutnyék. Yakutnyéte dé wak, “Wuné guna méniba taaba wunébu yakutnyék, guné véte kéga kutdénggunuké. Wuné kéni dut viyaapérekmuké kélik wuné yo. Guné dérét viyaapérekgunéran wan guna jébaa. Wuna jébaa kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Naate wadéka de waba tén du taakwa wak, “Naané véknwu. Dé kiyaaduké naané mawulé yo. Got wani muké ‘Kapéredi mu’ naadéran dé naanat naana baadit wawo viyaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naate wadaka dé Pailat wak, Barabas raamény ga kulaknyénytakne gwaade miték yéduké. Watakne déku waariyakwa duwat dé wak, de Jisasnyét raamény baagwit némaanba viyaatakne dérét miba viyaapata taknadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailatna waariyakwa du de deku némaa gat de Jisasnyét kure yék. Kure yédaka de akwi waariyakwa du de dé ténba jawuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Jawe de deku mawuléba wak, “Némaan du de gwaavé baapmu wut kusade yéknwun maakna saap de saaptakno.” Naate wate dérét waagite wasélékte de Jisasna baapmu wut putitakne gwaavé baapmu wut kusadak. Kusadatakne de raamény baagwi nak kérae maakna saap pulak séwayékwe de déku maaknaba kusadak. Kusadatakne baagé nak kérae de déku yéknwun tuwa taababa taknak. Takne déké kwati yaane waagite wasélékte de wak, “Méné Judana némaan ban, miték raké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naate wate dérét sépmeny sévaavite de wani baagé kérae de déku maaknaba viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Waga yabutitakne de kusadadan gwaavé baapmu wut putitakne de déku baapmu wut kusadak. Kusadatakne dérét miba viyaapata taknaké nae de dérét kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yaabuba yéte de waariyakwa du Sairiniba yaan ban déku yé Saimonét vék. Véte de dérét wak, dé Jisasnyét viyaapata taknadaran mi yaataduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wadaka yaatadéka ye de Golgota waadakwa taalé saabak. Wan Judana kudi. Naana kudi Maakna Apa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Waare de marasin wale yadan wain gu Jisaské kwayék, dé ke apakélé kaagél kutmarék yaduké. Kwayédaka dé kaknwutakne dé kaapuk kadén. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yadéka de dérét miba viyaapata taknak. Viyaapata takne de rate déku baapmu wut muniké de makwal matu yatjawurék. Yatjawurédaka waare giyaa akére derét talaknan du dé déku baapmu wut kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kéraadéka de wani taaléba rate Jisaské vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisasnyét viyaapata taknadan mi awuréba kaviye taknadan kudi wan kéga: Kén Judana némaan ban Jisas. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasnyét miba viyaapata takne de waariyate sél yan du vétiknét mi vétikba viyaapata taknak. Naknét de déku yéknwun tuwa saknwuba viyaapata taknak. Naknét de déku aki tuwa saknwuba viyaapata taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Du las yeyé yeyate Jisasnyét miba viyaapata taknadaka tédéka véte de dérét waagite waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Yate de wak, “Ménawa. Yaga pulak? Méné Gotna kudi bulnakwa némaa ga yaalébaane nyaa kupuk yédu méné tépa kaaké nae méné wak. Bulaa méné ména kapmu ména sépat kutkalé yaké méné yo. Méné Gotna nyaan raménéran méné wani mi kulaknyénytakne giyaaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Naate wadaka de nyédé duna némaan du, apa kudiké kutdéngkwa du, Isrelna kubu du waga de wawo de Jisasnyét waagite waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yate de wak, “Dé nak duwat dé kutkalé yak. Déku sépat kutkalé yaké dé yapatiyu. Dé Isrelna némaan ban radéran dé viyaapata taknadan mi kulaknyénytakne giyaadu naané véte déké ‘Got wadén ban Krais’ naaké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dé dé wak, ‘Wuné Gotna nyaan. Got wunat kutkalé yaké dé yo.’ Naate dé wak. Bulaa naané véké naané yo. Got déké mawulé yate dérét kutkalé yaké dé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naate wadaka bét Jisas wale miba viyaapata taknadan du vétik bétku miba téte bét wawo wani kudi male wate dérét bét waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nyaa nawurédéka dé akwi képmaaba gaan yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ye tédéka kukba nyaa tégéruwe dawuliké yadéka Jisas Yibruna kudiba némaanba dé kéga waak, “Eli, Eli, lema sabaktani.” Wani kudi naana kudiba kéga: “Wuna némaan ban Got, samuké méné wunéké kuk tiyao?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waga waadéka waba tén du las wani kudi véknwute de wak, “Wani du dé déknyényba rate Gotna yéba kudi wakwen du Ilaijat dé wao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naate watakne dé waba tén du nak bari pétépété ye nyabiyas pulak mu las kérae dé nyégi yakwa wain guba tawuk. Tawudéka gubés yadéka baagéba takne dé Jisas kaduké kusawurékwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yadéka las téte de wak, “Wekna mé téte véno. Sal Ilaija yae dérét kutkweké dé yo kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naate wadaka dé Jisas némaanba tépa waatakne dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jisas kiyaadéka Gotna kudi buldakwa némaa gaba lékidan sémény baapmu wut awuréba gétbiyae ye dé adawuli saabak. Yadéka dé taakwi vétik yak. Yadéka anyék kutléka de apakélé matu nyédéba pukaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yadaka dé kiyaan du taakwat rémdan waagu kepukadéka de déknyényba kiyaan Gotna du taakwa wupmalemu de tépa nébéle raapmék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kukba Jisas nébéle raapdéka de Jerusalemét wulaak. Wulaadaka wupmalemu du taakwa de derét vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Waariyakwa du deku némaan du wawo waga de Jisaské téte vék. Védaka dé kiyaadéka anyék kutléka yaalan nak mu wawo véte de wupmét kapére yak. Yate de wak, “Wani du wan Gotna nyaan. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wupmalemu taakwa yae séknaaba pulak téte de wawo de vék. Déknyényba Jisas Galili kulaknyénytakne yaadéka de dé wale yae déké de kadému kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wani taakwa nak wan Makdalaba yaan taakwa Maria. Nak wan Jems bét Josepna néwaa Maria. Nak Sebedina nyaan vétikna néwaa. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Garabu yadéka Arimatiaba yaan du nak déku yé Josep dé yaak. Dé wupmalemu gwalmu yan du dé. Dé wawo wan Jisasna du nak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yae dé Romna némaan du Pailatké yék. Ye dé Jisasna gaaba ségwi kéraaké dé dérét waatak. Waatadéka wadéka de Josepké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kwayédaka dé nyégéle dé yéknwun waama baapmu wurét kusépmék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kusépme kure ye dé déku waaguba taknak. Déknyény wani waagu déku jébaa yakwa du de matuba vaakére wulaak. Dé Jisasna gaaba ségwi wani waaguba takne apakélé matu nak yatbalaakukére ye dé yaabuba taknatépék. Taknatépétakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yédéka bét Makdalaba yaan taakwa Maria, Jems bét Josepna néwaa Maria Jisasnyét taknadan waagu ténba bét rate vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas kiyaadéka kwae ganba de nyédé duna némaan du, Parisina du wawo, waga de Pailatké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ye de dérét wak, “Némaan ban, naané wani yénaa yan du wekna rate wadén kudiké naané sanévéknwu. Kéga dé wak, ‘Nyaa kupuk yédu wuné tépa nébéle raapké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wani kudiké sanévéknwute naané ménat waato. Méné waménu de waariyakwa du ye dérét taknadan waaguké nyaa kupuk miték téségéte véké de yo. Vémarék yadaran sal déku du ye déku gaaba ségwi sél ye kure yéte du taakwat kéga waké de yo? ‘Kiyae débu tépa nébéle raapmék.’ Waga wakwedaran kukba yadaran yénaa kudi taale yadan yénaa kudit talaknaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naate wadaka dé Pailat derét wak, “Guné waariyakwa duwat kéraagunu de ye wani taaléké téségéké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Waga wadéka ye de waaguba taknatépédan matuba baagwi gitakne bi pulak mu taknak, du akélak paakwe ye wulaamarék yadoké. Yatakne waariyakwa duwat las wadaka de wani waaguké téségék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judana yaap ra nyaa yédéka Sande ganbaba nyaa yaalaké yadéka lé Makdalaba yaan taakwa Maria, Jems bét Josepna néwaa Maria wale waga bét Jisasna gaaba ségwi taknadan taalé véké bét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yébétka lé apakélé anyék kurék. Kutléka dé Némaan Ban Gotna kudi kure giyaakwa du nak Gotna gayéba dé giyaak. Giyae waaguba taknatépédan matu yatbalaakutakne dé wani matu takuba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Déku ménidaama nyét kulabikwa pulak dé yak. Yadéka déku baapmu wut buwi pulak waamat dé kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yadéka waba tén waariyakwa du wupmét kapére yate képmaaba akére de kiyaan du pulak kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wani taakwa vétik ye vébétka dé Gotna kudi kure giyaakwa du bérét wak, “Béné wup yamarék yaké béné yo. Wuné kutdéngék. Béné miba viyaapata taknadan ban Jisaské sékale véké béné yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dé déknyényba wadén pulak débu tépa nébéle raapmék. Dé kéba kaapuk radékwa. Béné yae béné taknadaka kwaadén taalé véké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vétakne béné bari bari ye béné déku duwat kéga wakweké yo, ‘Jisas déknyény kiyae bulaa débu tépa nébéle raapmék. Raapme dé Galilit dé taale yu. Guné ye dérét waba véké guné yo.’ Naate béné derét wakweké yo. Bénat wani wuné wakwek.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naate wadéka bét wup yate yéknwun mawulé yate takwasék yate bét wani taalé kulaknyénytakne bét bari pétépété yék, déku duwat wani kudi wakweké. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yébétka dé Jisas bérét yaabuba véte dé wak, “Bénéwa yékwa.” Naate wadéka bét déké yae kwati yaane déku maanba kutte bét déké waadé daak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yabétka dé Jisas bérét wak, “Béné wup yamarék yaké béné yo. Béné ye wuna duwat wakwebénu de Galilit yéké de yo. Ye wani taaléba wunat véké de yo.” Naate dé Jisas bérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wani taakwa vétik wekna yébétka de Jisasna gaaba ségwi taknadan taaléké téségén du las Jerusalemét wulae de yaadéka védan muké nyédé duna némaan duwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wakwedaka de nyédé duna némaan du Isrelna kubu du wale jawe rate kudi bultakne de kudi nak gik. Gite de téségén duké wupmalemu yéwaa kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kwayéte de derét wak, “Guné kéga du taakwat wakweké guné yo, ‘Gaan naané widé kwaanaka de Jisasna du yae de déku gaaba ségwi sél ye kure yék.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Waga wagunu Romna némaan du wani kudi véknwute rékaréka yadéran naané dérét kudi wakweno dé gunat waatimarék yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naate wadaka de téségén du wani yéwaa nyégéle kure ye de nyédé duna némaan du wakwedan pulak wakwek. Wakwedaka de Judana du taakwa wani kudi véknwuk. Bulaa wawo wani kudi male de véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisasna du taaba vétik sékét maanba kayék nakurak waga de Galilit yék. Ye de Jisas yédoké wakwedén nébat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ye Jisasnyét waba véte de déké kwati yaane waadé daak. Yate de las déké miték sanévéknwumarék yate de wak, “Kéni du kén kiyae nébéle raapmén ban Jisas, kapu kiyadé?” Naate de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas yae dé déku duwat wak, “Got wunéké akwi apa débu tiyaak. Tiyaadénké wuné nyét képmaaké wawo némaan ban raké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rawuréranké sanévéknwute wuné gunat wakweyo. Guné ye akwi képmaaba rakwa du taakwat wakwegunu de wuna jébaaba yaalaké de yo. Yaalado guné Gotna yéba wakwete derét gu yaakutaknagunu de wuna yaapa, wuné déku nyaan, Gotna Yaamabi wawo waga de Gotna du taakwa raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wuné gunat wakwewurén akwi kudi derét wakwegunu de wuna kudi miték véknwuké de yo. Véknwute wakwewurén pulak yaké de yo. Guné kéni muké yékéyaak yamarék yaké guné yo. Wuné gunat kulaknyénymarék yaké wuné yo. Akwi gaan nyaa wuné guné wale rasaakuké wuné yo. Kéni képmaa kaapuk yaran tulé wuné wekna guné wale rasaakuké wuné yo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kén yéknwun kudi Gotna nyaan Jisas Kraiské. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Taale Gotna yéba kudi wakwen du nak déku yé Aisaia dé Gotna nyégaba kéga kavik: Got déku nyaanét dé wak, “Kén wuna kudi kure yékwa du. Wuné wawuru dé taale yéte ména yaabu kutké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Du nak dé wao du rakaapuk taaléba. Waate dé kéga wo, “Némaan Banna yaabu kutké guné yo. Kutgunu yaabu miték kwaaké dé yo déké.” Wani aja kudi déknyényba Aisaia dé kavik. Du taakwana mawulé miték tédu, de Jisas yaadéranké miték sanévéknwudaranké, dé wani kudi kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jonna néwaa dérét kéraakaapuk yalén tulé Aisaia waga kavidéka kukba gu yaakutaknakwa du Jon dé ték du rakaapuk taaléba. Téte dé déké yaan du taakwat wakwek, “Guné yagunén kapéredi mawulé kulaknyénygunu wuné Gotna yéba gunat gu yaakutaknaké wunék. Guné waga kulaknyénytakne Gotna yéba gu yaakugunu Got guna kapéredi mawulé yatnyéputiké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Naate wadéka de Jerusalemba rakwa du taakwa, Judiana nak képmaaba rakwa du taakwa wawo, waga de wupmalemu du taakwa déké yék. Ye yadan kapéredi muké kélik yate wakwedaka dé Gotna yéba derét gu yaakutaknak Jodan kaabéléba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon yéknwun baapmu wut yéknwun kadémuké kaapuk sanévéknwudén. Dé kwaami sépéna yéwit yaatédan baapmu wut dé gik. Gitakne dé bulmakawu sépat yadan nyaamégi dé gipatak. Dé kwamijok dé kak. Samgék pulak mu dé jélipme kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dé du taakwat kéga dé kudi wakwek, “Wuna kukba du nak dé yao. Déku apa wuna apat dé talaknak. Dé némaan du dé ro. Wuné bakna du wuné ro. Yaga pulak déku jébaa yaké wuné yo, wuné bakna du rawurékwa bege? Dé némaan du radéka wuné déké jébaa yaké wuné yapatiyu, wuné bakna du rawurékwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wuné gunat Gotna yéba gu wunébu yaakutaknak. Dé Gotna Yaamabi gunéké kwayéké dé yo.” Naate dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wani tulé Jisas Nasaretba dé yaak. Wani gayé Galiliba dé tu. Yaadéka dé Jon Jodan kaabéléba dé dérét Gotna yéba gu yaakutaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yaakutaknadéka dé guba yaalate dé vék nyét bari kepukadéka Gotna Yaamabi nyaamiyo pulak ye déké giyaadéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Giyaadéka kudi nak Gotna gayéba dé wak, “Méné wuna nyaan. Ménéké mawulat wuné kapére yo. Ménéké wuna mawulé yéknwun dé yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gotna Yaamabi bari wadéka dé Jisas du rakaapuk taalat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kwatbosa male tén taalat. Ye saabe wupmalemu (40) nyaa waba kapmu radéka Seten yae dé déku mawulé yaknwuk. Yadéka Gotna kudi kure giyaakwa du giyae de Jisasnyét kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kukba némaan du wadéka dé Jon raamény gaba kwaadéka Jisas dé yék Galilina képmaat. Ye dé Gotna kudi kéga wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Déknyényba Got dé wak, dé némaan ban rate gunéké védéranké. Bulaa Got némaan ban rate gunéké véran tulé kéni dé yao. Yaadékwaké sanévéknwute guné guna kapéredi mawulé kulaknyénytakne Gotna kudi mé véknwu.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Galilina kwawu nak maaléba yéte dé vék Saimon déku wayékna Andru wale bétku jébaa yabétka. Bétku jébaa yate bét wani kwawuba laaké tawuk gukwamiké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Vétakne dé wak, “Béné mé yaa wuné wale. Yaabénu wuné bénat nak jébaaké yakwatnyéké wuné yo. Yakwatnyéwuru béné gukwami kutbénén pulak du taakwat kéraaké béné yo. Kéraabénu de wuna kudi véknwuké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Naate wadéka bari laaké kulaknyénytakne raapme bét dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","De walkamu ye dé Jisas vék Sebedina nyaan vétik Jems bét déku wayékna Jonét. Bétku yaapa Sebedi wale déku jébaa yakwa du wale waga de bétku botba rak. Rate laaké miték yabétka dé Jisas bérét wak, dé wale yébéruké. Wadéka bét bétku yaapa déku du wale botba radaka bari kulaknyénytakne bét Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas déku du wale de yék Kapaneamét. Ye saabe re yaap ra nyaa dé Gotna kudi buldakwa gat wulae dé du taakwat Gotna kudiké yakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Apa yate dé derét Gotna kudi wakwek. Waga wakwedéka apa kudiké kutdéngkwa du waga wakwekaapuk yadaka du taakwa déku kudi véknwute kwagénte de déké sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Yadaka dé kutakwa kure tékwa du nak wani gat wulaak. Wulae dé Jisasnyét waate dé wak, “Méné Nasaret ban Jisas, méné naanat samu yaké méné yaak? Naanat yaalébaanké méné yaak, kapu yaga pulak? Wuné ménat wuné kutdéngék. Méné Gotna yéknwun ban.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Naate wadéka dé Jisas kutakwat wak, “Nyéné kudi bulkaapuk. Wani dut kulaknyénytakne mé yaage yé.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Naate wadéka lé wani dut takubalaakutakne némaanba waatakne lé yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yaage yéléka akwi du taakwa véte kwagénte deku kapmu bulte de wak, “Aki. Kéni du samu kulé kudi dé wakweyo? Dé apa yate kutakwat wadéka de déku kudi véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naate wadaka de Galilina képmaaba tékwa akwi gayéba Jisaské kudi wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas Gotna kudi buldakwa ga bari kulaknyénytakne dé yék. Jems, déku wayékna Jon, du las wawo, de Jisas wale de yék. Ye Saimon bét Andruna gat de wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonna naakuma kiyakiya yadéka lé kwaak. Kwaaléka de Jisasnyét bari léké kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wakwedaka dé wulae léku taababa kutkwedéka raapléka dé kiyakiya kaapuk yak. Yadéka lé kadému kawu saakére lé deké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Garabu nyaa dawulidéka yaap ra nyaa yédéka de kiyakiya yakwa du taakwa baadi, sépékwaapa kapére yan du taakwa baadi, kutakwa kure tén du taakwa baadit wawo de Jisaské kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kure ye de wani gayéba rakwa nak du taakwa wale téte de jawuk ga maaknaba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jawudaka dé wupmalemu du taakwa baadit kutnébulék. Yatakne dé wadéka de wupmalemu kutakwa du taakwa baadit de kulaknyényék. Kulaknyénytakne yaage yéké yadaka dé kutakwat waatik, de déké kudi wakwekaapuk yadoké. Derét dé waatik, déké kutdéngdan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ganbaba yé tékmarék yadéka dé Jisas raapme gwaade yék, du taakwa rakaapuk taalat. Ye dé waba Got wale kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Buldéka Saimon béré de déké sékalék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sékale véte de dérét wak, “Akwi du béré taakwa béré ménéké de sékalpatiyu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naate wadaka dé wak, “Wuné deké tépa gwaamale yékaapuk yaké wuné yo. Nak gayét yéké naané yo. Wani gayéba wawo Gotna kudi wakweké wuné yo. Wani jébaa yaké wuné yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naate watakne dé yék Galiliba tékwa gege gayét. Yéte dé kudi wakwek, Gotna kudi buldakwa wupmalemu gaba. Wakwete wadéka de du taakwat kure tén kutakwa yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepéro yan du dé nak yék Jisaské. Ye kwati yaane waadé daate dé dérét wak, “Wuné yéknwun yawuruké méné mawulé yaménéran méné waménu wuné yéknwun yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naate wadéka dé déké mawulé lékte déku taabat kutte dé wak, “Wuné yéknwun yaménuké wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Naate wadéka dé lepéro bari kaapuk yadéka dé yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yadéka dé dérét némaanba wak, “Mé véknwu. Ménat yawurén muké nak duwat wakwekaapuk yaké méné yo. Méné Gotna kudi buldakwa gaba jébaa yakwa nyédé duké bari ye déku méniba téménu dé ména sépat véké dé yo. Védu méné yéknwun yaménénke méné Moses déknyényba wakwedén pulak Gotké kwaami kwayéké méné yo. Kwayéménu nak du taakwa véte lepéro kaapuk yadéka méné yéknwun yaménénké kutdéngké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naate wadéka dé Jisasna kudi véknwukaapuk yate dé wani muké wakwek, gege gayéba. Wakwedéka wupmalemu du taakwa Jisas wale jawuké mawulé yadaka dé Jisas kélik yate deku gayét kaapuk gwaadédén. Dé du taakwa rakaapuk taalat dé yék. Ye radéka de du béré taakwa béré dérét véké de yaak gayéba gayéba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kukba Jisas dé gwaamale yék Kapaneamét. Gwaamale ye gaba radéka déké kudi buldaka de véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Véknwute wupmalemu du taakwa de wani gat wulae tédaka taalé débu sékéréknék. Sékérékdéka gwéspété yaabu kaapuk kwaan. Yadéka dé Jisas Gotna kudi wakwek derét. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wakwedéka de du wan véti wan véti maan taaba kapére yan dut nak jaabéba yaate yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yaate ye Jisas tén saabaké de yapatik, wupmalemu du taakwa jawudan bege. Yadaka gaba waare de nak tabé Jisas tén wale péraak awuréba. Pérae de wani du kwaadén jaabéba baagwi lékiye de wani yaabuba kusadak, du taakwana nyédéba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kusade Jisas ténba taknadaka dé véte dé kutdéngék. De deku mawuléba de wak, dé wani dut kutnébulké apa yadéranké. Waga kutdéngte dé wani dut wak, “Wuna du, wuné yaménén kapéredi mu wunébu yatnyéputik.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jisas wani kudi wadéka de apa kudiké kutdéngkwa du las waba rate deku mawuléba de kéga wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wani du samuké nae dé waga wak? Got kapmu du yadan kapéredi mu yatnyéputiké dé yo. Wani du dé wak, ‘Wuné yadén kapéredi mu wunébu yatnyéputik.’ Naate wate dé Gorét waséléknu, bakna du bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Waga wadaka Jisas deku mawulé kutdéngte dé derét wak, “Samuké guné guna mawuléba waga sanévéknwu? Waga yakaapuk yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Wuné Akwi Du Taakwana Nyaan kéni képmaaba rate yadan kapéredi mu yatnyéputiké wuné apa yo. Guné wani muké kaapuk kutdénggunén. Yadén kapéredi mu yatnyéputiwurénké wakwete bakna kudi wuné wakwek, kapu némaa kudi wuné wakwek? Dé raapme déku jaabé kérae kure yéduké wawuréran wan némaa kudi wakweké wuné yo, kapu yaga pulak? Guné wuna apaké miték kutdénggunuké wuné wani kudi bulaa dérét wakweké wuné yo.” Naate watakne dé maan taaba kapére yan dut wak, “Ménat wuné wakweyo. Méné raapme ména jaabé kérae kure méné ména gat yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naate wadéka dé raapme kwaadén jaabé bari kérae kure dé akwi du taakwana méniba bari gwaadék. Gwaadédéka véte de akwi du taakwa kwagénék. Kwagénte Gotna yéba kevérékdaka deku mawulé géndéka de wak, “Aki. Waga pulak mu déknyényba kaapuk vénan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas tépa gwaade dé kwawu maaléba ték. Tédéka de wupmalemu du béré taakwa béré déké yae jawudaka dé derét Gotna kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wakwetakne yéte dé vék Alpiasna nyaan déku yé Livai takis nyégéldékwa gaba radéka. Véte dé wak, “Méné wuné wale mé yaa.” Naate wadéka raapme dé Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas yédéka wupmalemu du taakwa de dé wale yék. Yédaka takis nyégélén wupmalemu du, kapéredi mu yakwa wupmalemu du las wawo de dé wale yék. Ye Jisas déku du wawo Livai wale kadému kate radaka de yae de wawo de wale kadému kate rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kate radaka véte de apa kudiké kutdéngkwa Parisina du las Jisasna duwat wak, “Samuké dé takis nyégélkwa du, kapéredi mu yakwa du las wawo de wale dé kadému ko?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naate wadaka dé derét aja kudi kéga wak, “Yéknwun yakwa du taakwa doktaké kaapuk yédakwa. Sépékwaapa kapére yan du taakwa de doktaké yu. Yadaka dokta de deku sépé kutnébulu.” Naate watakne dé wak, “Wuné du taakwana kapéredi mawulé wuné kutnébulu. Kapéredi mawulé yakwa du taakwa wunéké yae wuna kudi véknwudoké wuné giyaak. Yéknwun mawulé yakwa du taakwaké kaapuk sanévéknwurén.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nak apu nak apu gu yaakutaknan du Jonna du Parisina du wawo Got wale kudi bulké yate de kadémuké yaakérék. Yaakétdanké sanévéknwute du taakwa las Jisaské ye de wak, “Jonna du Parisina du wawo wupmalemu apu de kadémuké yaakéru. Yaakétte bakna rate de Got wale kudi bulu. Ména du waga kaapuk yadakwa. De akwi nyaa kadému de ko. Samuké ména du de kadémuké yaakétkaapuk yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naate wadaka dé Jisas derét aja kudi kéga wakwek: “Du nak taakwa yaké yadu de kadému sérakne yéknwun mawulé yate kadému kaké de yo, kapu kaapuk? De kaké de yo. Taakwa yaran du de wale radu de yéknwun mawulé yate kaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kukba de nak du yae wani dut kure yédo wani tulé de déku du taakwa déké mawulé lékte kadému kakaapuk yaké de yo. Wuné wuna du wale wekna rawuréka de yéknwun mawulé yate kadému de ko.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wani kudi watakne dé derét aja kudi vétik wawo kéga wakwek: “Du taakwa kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba kaapuk takne kétaapadakwa. De kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba takne kétaapadaran kukba gu yakutnyédo kulé baapmu wut makwal pulak yadu jégwaa baapmu wut gétbiyaadu apakélé yaabu téké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Déknyény kwaaré viyae putidan meme sépéba kulé wain gu kaapuk wuknasadadakwa. Waga yadaran wani meme sépé rékaa ye jégwaa ye wukdu gu akwi yékéraké dé yo. Yékéradu wani meme sépé yéknwun yakaapuk yaké dé yo. Kulé meme sépéba wuknasadadaran kulé gu miték téké dé yo.” Waga dé aja kudi wakwek, déknyényba ran du wakwen kudi déku kulé kudi wale vététi miték kwaakaapuk yadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yaap ra nyaa nak dé Jisas déku du wale de wit tékwa képmaaba nak yék. Yéte déku du wit sék kaké nae de wit kubu las sékuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sékudaka de Parisina du las véte de Jisasnyét wak, “Mé vé. De wit kubu de séku yaap ra nyaaba. Naana apa kudi kéga dé wo. ‘Guné yaap ra nyaaba jébaa yakaapuk yaké guné yo.’ Wani apa kudi de kaapuk véknwudakwa. De wit kubu sékute de jébaa yo, yaap ra nyaaba. Wan kapéredi mu de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Naate wadaka dé derét wak, “Déknyényba naana képmawaara Devit yadén muké de Gotna nyégaba kavik. Wani kudiké guné kaapuk sanévéknwugunékwa. Déknyényba Devit déku du wale kaadé yadéka dé Gotna kudi buldakwa gat wulae wani gaba jébaa yakwa nyédé dut dé waatak, Gotké kwayéte taknadan kadému deké kwayéduké. Wani tulé Abaiata dé nyédé duna némaan ban rak. Waatadéka kwayédéka Devit wani kadému déku duké kwayédéka de akwi kak. Waga yate de naana apa kudi kaapuk véknwudan. Naana apa kudi kéga dé wo, ‘Gotna gaba jébaa yakwa nyédé du male Gotké kwayédan kadému kaké de yo. Nak du wani kadému kakaapuk yaké de yo.’ Naate wadéka Devit déku du wale waga yadaka guné deké kéga kaapuk wagunékwa, ‘Wan kapéredi mu de yak.’ Naate wakaapuk yate samuké guné wuna duwat waatiyu, naana apa kudi véknwukaapuk yadanké? Guné waga wate kaapuk miték kutdénggunén.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Watakne dé derét wak, “Du taakwat miték yaké Got dé yaap ra nyaa kuttaknak. Du taakwa de yaap ra nyaat miték yadoké Got kaapuk wadén. ");
INSERT INTO abt_maprik_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Waga yadénké sanévéknwute wuné gunat wo. Wuné Akwi Du Taakwana Nyaan, wuné yaap ra nyaaké némaan ban wuné ro. Wuné du taakwana jébaaké kusékétwuru de yaap ra nyaaba kusékétwurén pulak yaké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nak apu yaap ra nyaa dé Jisas Gotna kudi buldakwa gat wulaadéka taaba léknén du nak dé waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Radéka Jisasna kudiké kélik yakwa du las wani gaba rate de Jisasnyét vék. Deku mawuléba de wak, “Jisas yaap ra nyaa wani dut kutnébulké dé yo, kapu kaapuk? Dérét kutnébuldéran dé naana apa kudiké kuk kwayédu naané dérét kotimké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naate wadaka dé taaba léknén dut wak, “Mé raapme yae méné kéba téké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Naate wadéka dé raapme waba tédéka dé derét wak, “Naana apa kudi yaga dé wo? Yaap ra nyaa naané yéknwun mu yaké naané yo, kapu kapéredi mu yaké naané yo? Yaap ra nyaa kiyaaké yakwa du taakwat kutkalé yaké naané yo, kapu derét viyaapérekgé naané yo?” Naate wadéka kudi kaapuk buldan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yate déku kudi véknwumuké kélik yadaka dé rékaréka yate deké dé mawulé léknék. Mawulé lékte dé wani dut wak, “Ména taaba mé kedéng.” Naate wadéka dé déku taaba kedéngdéka dé tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yadéka de Parisina du gwaade ye Jisasnyét viyaapérekgé de Yerotna du wale kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas déku du wale de kwawu maalat yék. Yédaka wupmalemu du taakwa yadén muké kudi véknwutakne de déké yék. Galili, Jerusalem, Judiaba tékwa gayé las wawo, Idumia, Jodan kaabélé nak saknwu, Taiana taalé, Saidonna taalé, wani gayéba yae de déké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ye saabadaka dé kiyakiya yakwa wupmalemu du taakwa baadi, sépékwaapa kapére yan wupmalemu du taakwa baadit dé kutnébulék. Kutnébuldéka de waga pulak du taakwa tépa yéknwun yaké nae déku sépéba kutké mawulé yate jawudaka taalé dé sékéréknék. Sékérékdéka dé déku duwat wak, “Rawuréran bot nak kéraaké guné yo, wupmalemu du taakwa jawudan bege.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kutakwa kure tén du taakwa Jisasnyét véte de déku méniba akére kwaate de waak, “Méné Gotna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Naate wadaka dé Jisas derét némaanba wak, de déké kudi wakwekaapuk yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas dé nébat waarék. Waare dé mawulé yadékwa duwat waadéka de déké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yédaka dé du taaba vétik sékét maanba kayék vétik waga derét dé wak, de déku jébaa yadoké. De dé wale yeyé yeyate déku kudi véknwe ye du taakwat Gotna kudi wakwete apa kérae wado kutakwa yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Déku duna yé kéga: Saimon. Dérét dé nak yé waak, Pita. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedina nyaan vétik Jems bét déku wayékna Jon. Bérét dé nak yé waak, Boanesis. Naana kudiba wani kudi kéga dé wo, jaat pulak nyaarangte waakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru. Pilip. Batolomyu. Matyu. Tomas. Alpiasna nyaan Jems. Tadias. Nak Saimon. Dé déknyényba gege gayét yéte dé wak, “Nak képmaana du naanéké némaan du ramuké kélik wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot. Kukba dé Jisasnyét maamaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kukba Jisas dé gwaamale yék gat. Ye saabe déku du wale kadému kaké de yapatik, wupmalemu du taakwa jawe tédan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yadaka de du taakwa las de Jisaské wak, “Dé waagété débu yak.” Naate wadaka de Jisasna kém véknwutakne de dérét kwole yéké nae de déké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Apa kudiké kutdéngkwa du las Jerusalemba déknyényba de yék. Ye saabe Jisasnyét véte de déké wak, “Déku mawuléba akwi kutakwana némaan ban déku yé Bielsebul dé wulae tu. Téte apa kwayédéka dé wadéka de kutakwa yaage yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naate wadaka dé derét waak, yaadoké. Waatakne dé derét aja kudi kéga wakwek, “Kéni kudi mé véknwu. Guné wunat wagunén pulak yate kutakwana némaan ban Seten déku du yaageyédoké wadéran de rasaakukaapuk yaké de yo. Seten waga jébaa kaapuk yadékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Némaa gayéba rakwa du mawulé vétik yate kémba kémba rate waariyadaran de rasaakukaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nakurak gaba rakwa du taakwa mawulé vétik yate deku kapmu waariyadaran de wawo rasaakukaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seten déku du wale waga de ro. De mawulé vétik yate deku du wale waariyadaran de rasaakukaapuk yaké de yo. Deku jébaa kaapuk yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Du nak apa yakwa duna gat wulae déku gwalmu bakna kéraaké nae taale dé wani dut kure baagwit giké dé yo. Gitakne déku gat wulae déku gwalmu bakna kéraaké dé yo.” Naate watakne dé wak, “Seten wani apa yakwa du pulak. Wuné wani dut baagwit gikwa du pulak. Wuna apa Setenna apat débu talaknak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jisas waga watakne dé wak, “Kéni kudi mé véknwu. Du taakwa kapéredi mu ye wani kapéredi muké kélik ye kulaknyénydaran Got yadan kapéredi mu yakutnyéputiké dé yo. Du taakwa Gorét wasélékte kapéredi kudi wakwetakne wani kapéredi kudiké kélik ye kulaknyénydaran Got wani kapéredi mu yakutnyéputiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","De wasélékte kapéredi kudi Gotna Yaamabiké wakwedaran Got wani kapéredi mu yakutnyéputikaapuk yaké dé yo. Wani kapéredi mu rasaakuké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Naate dé wak, de Gotna Yaamabit wasélékdan bege. Taknaba de las Gotna Yaamabiké sanévéknwukaapuk yate de wak, “Kutakwana némaan ban dé Jisasna mawuléba wulae tu.” Naate wate de Gotna Yaamabit waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wani tulé Jisasna néwaa déku wayéknaje wawo de déké yék. Ye kaapaba téte de kudi wakwesatik déké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wakwesatidaka wupmalemu du taakwa Jisas wale rate de dérét wak, “Ména néwaa, ména wayéknaje yae kaapaba téte de ménat véké de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Naate wadaka dé wak, “Wuna néwaa wayéknaje yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naate watakne akwi du taakwat véte dé wak, “Kén wuna néwaa, wuna wayéknaje. ");
INSERT INTO abt_maprik_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gotna kudi véknwute wadékwa pulak yakwa du taakwa wan wuna néwaa, wuna nyangegu, wuna wayéknaje pulak de ro.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas tépa dé kudi wakwek kwawu maaléba. Wakwedéka wupmalemu du béré taakwa béré ye de dé ranba jawuk. Jawudaka, de déku kudi miték véknwudoké mawulé yate dé botba waare awulaga kwawuba dé rak. Radéka de kwawu maaléba de rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Radaka dé derét wupmalemu aja kudi wakwete derét Gotké dé yakwatnyék. Yakwatnyéte dé derét kéga wakwek: ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mé véknwu. Du nak dé déku képmaaba wit sék yaatnyéké nae dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ye yaatnyédéka de wit sék las yaabuba de akérék. Akére bakna radaka de api yae kérae de akwi kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wit sék las de matu wale ran walkamu képmaaba akérék. Akére de bari buréle waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waarédaka mégi miték kutkaapuk yadéka nyaa védéka képmaa yépidéka de bari rékaa ye de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit sék las de raamény waara ténba akérék. Akére radaka raamény waara wure dé kakutapmék. Kakutapdéka de wit sék kaapuk akudan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wit sék las de yéknwun képmaaba akérék. Akére waba re de miték wurék. Wure de yéknwun sék akuk. Las de walkamu sék akuk (30). Las de wupmale sék akuk (60). Las de wupmalemu sék akuk (100).” ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naate watakne dé Jisas wak, “Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wani du taakwa yédaka dé wale yeyé yeyakwa du déku du las wawo de Jisasnyét wani aja kudiké waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Waatadaka dé derét wak, “Got némaan ban rate du taakwaké miték véké dé yo. Védu de déku kémba raké de yo. Wani muké déknyényba Got dé kudi paakuk. Paakutakne bulaa dé kusékéru, guné wani muké kutdénggunuké. Nak du taakwat wani muké aja kudi wuné wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wakwewuréka de Gotna nyégaba kwaakwa kéni kudi wadékwa pulak de yo: De véte véte miték vémarék yaké de yo. De kudi véknwute véknwute wani kudiké kutdéngmarék yaké de yo. Kutdéngdo mukatik Gotna kudi véknwudo dé Got yadan kapéredi mu yakutnyéputidu.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas waga watakne dé derét wak, “Wani aja kudiké guné kaapuk kutdénggunén, kapu yaga pulak? Kutdéngkaapuk yagunéran yaga pulak akwi aja kudiké kutdéngké guné yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Bulaa wani aja kudiké wakweké wunék. Wit sék yaatnyén du wit sék yaatnyéte dé Gotna kudi wakwedakwa pulak dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Du taakwa las Gotna kudi de miték véknwu. Véknwudaka Seten bari yae dé wani kudi kure yu. Yédéka de wani kudiké yékéyaak de yo. Wani du taakwa wan yaabuba akérén wit sék pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Du taakwa las de matu wale ran képmaaba akérén wit sék pulak. Taale Gotna kudi de bari véknwu. Véknwute taale wani kudiké yéknwun mawulé yate dusék takwasék de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yate de kaapuk miték sanévéknwudakwa. Wani kudi deku mawuléba dawulikaapuk yadéka de kaapuk miték sanévéknwudakwa. Yadaka de nak du Gotna kudiké kélik yate derét yaalébaandaka kapéredi mu las deké yaadéka de Gotna kudi bari kulaknyényu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Du taakwa las wan raamény waara ténba akérén wit sék pulak. De Gotna kudi taale de miték véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Véknwute de kéni képmaana muké male sanévéknwudaka deku mawulé yéwaa gwalmu kéraaké dé génu. Géndéka gwalmuké las wawo de mawulé yo. Wani mu dé Gotna kudit taknatépu. Taknatépédéka de wani du taakwa Gotna jébaa kaapuk yadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Du taakwa las wan yéknwun képmaaba akérén wit sék pulak. De Gotna kudi miték véknwute, wadékwa pulak yate, déku kudi de miték kutdéngék. Kutdéngte de yéknwun jébaa yo déké. Las de déké walkamu yéknwun jébaa yadaka las déké wupmale yéknwun jébaa yadaka las de déké wupmalemu yéknwun jébaa yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wani kudi watakne dé Jisas wak, “Mé sanévéknwu. Du téwayé sérakne kure yae sapgutaknadan awu gwaléba de takno, kapu jaabé gwaléba de takno? Wan kaapuk. De jaabé takuba de takno. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Paakwe rakwa mu kukba véké guné yo. Akélak wakwedan kudi kukba kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Watakne dé derét wak, “Wani kudiké mé miték sanévéknwu. Guné miték sanévéknwe wuna kudi véknwuké guné yo. Guné walkamu véknwugunéran walkamu kutdéngké guné yo. Miték véknwugunéran miték kutdéngké guné yo. Kutdénggunu Got gunéké yéknwun mawulé las wawo kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wuna kudi miték véknwukwa du taakwa kukba Gotna kudiké miték kutdéngké de yo. Wuna kudi miték véknwukaapuk yakwa du taakwa de wo, ‘Naané Gotna kudi naanébu kutdéngék.’ Naate watakne kukba déku kudiké yékéyaak yate bakna raké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Wani kudi watakne dé wak, “Got némaan ban rate du taakwaké miték véké dé yo. Véte dé kapmu jébaa yadu nak du taakwa kwatkwa rado Gotna kém apakélé yaké de yo, kéni wit sék pulak. Du nak dé wit sék képmaaba yaatnyétakne gaan kwae nyaa raapme waga yasaakudéka dé wit sék buréle waaru. Waarédéka dé kaapuk kutdéngdén. Yaga pulak dé wit sék buréle waaru? ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Képmaa déku kapmu yadéka dé wani wit sék buréle waare gaga ye akwe dé ak yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yadéka sékudakwa tulé yaadéka dé wani du véte dé kulaat séku.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wani kudi watakne dé wak, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwaké yaga pulak wakweké wuné yo? Samu aja kudi wakwewuru guné wani du taakwaké kutdéngké guné yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kéga wakweké wunék. Wani du taakwa taale makwal kém raké de yo. Kukba apakélé kém raké de yo. Wani kém wan misék nak pulak. Wani misékna yé mastet. Wani misék wan makwali sék male. Naana képmaaba tékwa akwi nak sék wan apakélé. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Du wani misék pukaadéka dé wure waare némaa gaalé badéka apakélé mi dé tu. Tédéka apangba de wupmalemu api yae kwaat sétakne ro.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Waga dé wupmalemu aja kudi du taakwat wakwek. De véknwute kutdéngké apa yadaka dé derét waga wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aja kudi male dé derét wakwek. Wakwetakne kukba déku du male tédaka dé derét wani kudiké wakwek, de miték kutdéngdoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nyaa daadéka gaan yadéka dé Jisas déku duwat wak, “Mé yaagunu yéno kwawu nak saknwat.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Naate wadéka de waba ran wupmalemu du taakwat kulaknyénytakne de Jisas ran botba waarék. Waare de dérét kure yék. Yédaka de du las nak botba wawo de yék, de wale. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yédaka némaa wimut kutdéka dé gu raapme waare botba gwaade dé sékérékgé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yadéka dé Jisas bot kuktabéba dé widé kwaak. Kwabutékba dé maakna kwatiye kwaak. Kwaadéka de dérét waaséligénék. Waaséligénte de wak, “Némaan du, kén naané yalaknu. Naanéké méné kaapuk sanévéknwuménékwa, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naate wadaka ligéne raapme wadéka dé wimut kaapuk yadéka dé gu miték ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tédéka dé déku duwat wak, “Samuké guné wup yo? Gunat kutkalé yawuréran apaké kaapuk miték sanévéknwugunékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naate wadéka de wupmét kapére yak. Yate deku kapmu bulte de wak, “Aki. Dé wadéka dé wimut gu déku kudi véknwute wadékwa pulak dé yo. Wan yaga pulak ban dé?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas déku du wale kwawu nak saknwat ye de Gerasana képmaa saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Saabe dé Jisas bot kulaknyénydéka dé kutakwa kure tén du nak waagété ye dé dérét vék. Wani du dé du taakwa kiyaadaka rémdan taaléba dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Radéka du las wupmalemu apu déku maan taaba baagwit de gik. Gidaka wani baagwi périkne dé yaage yék. Apa baagwit wawo gidaka dé wani baagwi périkne yaage yék. Yédéka de dérét kutké apa kaapuk yadan. Dérét baagwit tépa giké de yapatik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gaan nyaa du taakwa kiyaadaka rémdan taalé nébuba wawo rate ye saaki waasaakute déku kapmu dé déku sépéba matut sékuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisas saabadéka dé wani du Jisasnyét séknaaba vék. Véte dé déké pétékére ye kwati yaane waadé daak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yadéka Jisas véte dé wak, “Ména mawuléba tékwa kutakwa mé yaage yé.” Naate wadéka dé némaanba waate dé wak, “Jisas, méné awuréba rakwa ban Gotna nyaan. Méné wunat samu yaké méné yo? Gotna yéba wuné ménat waato. Méné wunat kaagél tiyaakaapuk yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naate wadéka dé dérét wak, “Ména yé yaga?” Naate wadéka dé dérét wak, “Wuna yé Wupmalemu, wupmalemu kutakwa wunat kure tédakwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Naate watakne dé wak, “De nak képmaat yémuké wuné kélik yo. Ménat wuné waato. De wanét yédoké wakaapuk yaké méné yo.” Naate dé kutakwa kure tén du wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wani nébuba wupmalemu baalé de tén wale téte de kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kadaka de wani dut kure tén kutakwa Jisasnyét wak, “Méné naanat kéléké mawulé yaménéran méné waménu naané wani baaléna mawuléba wulaaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naate wadaka dé derét wak, “Guné wanét mé yaage yégunu.” Waga wadéka de wani dut kulaknyénytakne ye de wani baaléna mawuléba wulaak. Wulaadaka wani baalé némaa tépaaba yaage dawuliye guba akére gu ke de akwi (2,000 pulak) kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wani baaléké téségén du waga yadaka vétakne de yaage yék. Ye de akwi gayéba ran du taakwat wani muké wakwek. Wakwedaka de du taakwa wani mu véké de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ye Jisas tén saabe de wupmalemu kutakwa kulaknyénytakne yén dut de vék. Dé baapmu wut gitakne yéknwun mawulé yate Jisasna maan wale radéka de vék. Véte de wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yadaka Jisas wani mu yadéka vén du taakwa de derét wakwek, kutakwa kure tén du yéknwun yadéka baalé kiyaadanké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wakwedaka de Jisasnyét wak, dé deku képmaa kulaknyénytakne yéduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wadaka Jisas derét kulaknyénytakne yéké yate botba waarédéka dé kutakwa kure téléka yéknwun yan du dérét wak, “Wuné méné wale yéké wuné mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Naate wadéka dé dérét wak, “Méné ména gayé ména duké gwaamale ye derét kudi wakweké méné yo, Némaan Ban ménéké mawulé lékne ménat yéknwun mu yadénké.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naate wadéka dé kulaknyénye ye dé kudi wakwek, Dekapolisna képmaaba tékwa wupmalemu gayéba. Jisas dérét yan muké dé kudi wakwek. Wakwedéka akwi du taakwa véknwute de kwagénte de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas déku du wale botba ye kwawu nak saknwu saabadaka de wupmalemu du béré taakwa béré jawe de dé wale ték. Dé kwawu maaléba dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Tédéka du nak déku yé Jairas dé déké yék. Dé némaan du dé rak, wani gayéba kwaakwa Gotna kudi buldakwa gaba. Dé ye kwati yaane Jisaské waadé daate dé dérét wak, “Wuna takwanyan kiyaamale yaké lék. Méné yae ména taaba lérét kutménu lé tépa yéknwun yaké lé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naate wadéka dé dé wale yék. Jisas yaabuba yédéka de wupmalemu du taakwa déku kukba yék. Yédaka yaabu dé sékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yadéka lé taakwa nak lé de wale yék. Wupmalemu (12) kwaaré wény yaaladéka lé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wupmalemu apu déknyényba lé wupmalemu doktaké yék, de lérét kutnébuldoké. Ye léku akwi yéwaa kwayéléka wani mu dé yasaakuk. Kaapuk yéknwun yalén. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yate lé Jisaské kudi véknwutakne lé léku mawuléba wak, “Wuné déku baapmu wutba taaba kutwuréran wuné tépa yéknwun yaké wuné yo.” Naate watakne lé wupmalemu du taakwa wale ye déku kukba ye lé déku baapmu wutba kurék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kutléka dé wény bari kaapuk yadéka lé kutdéngék, yéknwun yalénké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yaléka Jisas dé kutdéngék, déku apa las yédénké. Kutdéngte walaakwe dé déku kukba yén du taakwat waatak, “Kiyadé wuna baapmu wutba kurék?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naate waatadéka déku du de wak, “Wupmalemu du béré taakwa béré de méné wale yaadaka taalé sékérékdéka méné vu. De las ménat de kurék, kapu yaga pulak? Samuké méné naanat waato, ménat kurén banké?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naate wadaka dé deku kudi véknwukaapuk yate dé dérét kurén banké sékalék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sékaldéka wani taakwa léké yaan muké kutdéngte wupmét kapére yate déké ye kwati yaane waadé daate lé wani muké kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wakweléka dé wak, “Nyéné, nyénat kutnébulwuréran apaké miték sanévéknwute bulaa yéknwun nyénébu yak. Yéknwun ye yéknwun mawulé yate miték yéké nyéné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dé wekna téte kudi buldéka dé du nak Jairasna gaba dé yék. Ye saabe dé wani némaan dut wak, “Ména takwanyan lébu kiyaak. Méné waménu wani némaan ban yaakaapuk yate déku nak jébaa yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Naate wadéka dé Jisas wani kudi véknwute dé Gotna kudi buldakwa gana némaan dut wak, “Méné wup yakaapuk. Wuné ména takwanyanét kutkalé yawuréran apaké miték sanévéknwuké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Naate watakne dé Pita, Jems, Jemsna wayékna Jon derét dé wak, “Guné kapmu wuné wale mé yaa. Nak du taakwa yaamarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naate wadéka de dé wale yék, wani némaan duna gat. Ye de vék wupmalemu du taakwa jawe téte wani takwanyanké mawulé lékte némaanba géraadaka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Vétakne gat wulae dé wak, “Samuké guné waga gérao? Lé kaapuk kiyaalén. Bakna widé lé kwao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Naate wadéka de dérét waagik. Waagidaka dé deku kudi véknwukaapuk yate wadéka de akwi gwaadék kaapat. Gwaadédaka dé takwanyanna néwepa déku du kupuk wale waga de wulaak, takwanyan kwaanét. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wulae dé léku taababa kutte dé déku kudiba lérét wak, “Talita kumi.” Wani kudi naana kudi kéga: “Nyéné, mé raap.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas adéka lé bari raapme yeyé yeyak. Léku kwaaré taaba vétik sékét maanba kayék vétik. Yeyé yeyaléka véte de kwagénék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kwagéndaka dé wak, “Mé véknwu. Wani muké bulkaapuk. Nak du taakwa kutdéngkaapuk yaké de yo. Kadému las kwayégunu lé kaké yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas wani gayé kulaknyénytakne dé déku néwaaget yék. Yédéka déku du de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ye saabe yaap ra nyaa dé Gotna kudi buldakwa gat wulaak. Wulae dé Gotna kudiké du taakwat yakwatnyék. Yakwatnyédéka de wupmalemu du taakwa véknwute kwagénte de wak, “Aki. Wani du yaba dé wani kudi kéraak? Yaga pulak dé wani mu kutdéngék? Dé déknyényba vékaapuk yanan wupmalemu apa jébaa dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wan ga jébaa yakwa ban. Maria wan déku néwaa. Jems, Josis, Judas, Saimon wan déku wayéknaje. Déku nyangegu akwi kéba de ro, naané wale. Derét naané kutdéngék. Wan némaan du kaapuk. Wan bakna du. Yaga pulak dé wani kudi wakweyo?” Waga wate de déké kélik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kélik yadaka dé Jisas wak, “Gotna yéba kudi wakwekwa du néwaageba rate kudi wakwedaka deku kém, deku gaba rakwa du taakwa, deku néwaageba rakwa du taakwa deku kudi véknwumuké kélik de yo. Nak gayéba radaka wani gayéna du taakwa deku kudi de véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naate watakne dé déknyényba vékaapuk yadan apa jébaa kaapuk yadén wani gayéba. Kéni jébaa male dé yak. Kiyakiya yakwa walkamu du taakwat déku taaba kutdéka de yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wani gayéba rakwa du taakwa déku kudi véknwukaapuk yadaka dé Jisas sanévéknwu wanévéknwuk. Kukba dé gege gayét yéte dé Gotna kudi du taakwat wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas déku du taaba vétik sékét maanba kayék vétiknét waadéka yaadaka dé deké apa kwayék, de wado duna mawuléba tékwa kutakwa yaage yédoké. Kwayétakne dé derét wak, “Du vétik du vétik waga yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kadému, wut, yéwaa kure yékaapuk yaké guné yo. Sétowe yégunékwa baagé male kure yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su kusadaké guné yo. Baapmu wut nakurak male kusadaké guné yo. Vétik kaapuk. Guné du taakwat kutkalé yagunu de gunat kutkalé yate wani mu gunéké kwayéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Guné ye gayé nak saabe gat nak wulae wani gaba male raké guné yo. Wani gaba re kukba nak gayét yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Guné gayét nak wulaagunu wani gayéba rakwa du taakwa guna kudi véknwukaapuk yate gunéké kuk kwayédaran guné wani gayé kulaknyényké yate guna maanba kwaakwa bawusa yatputétakne guné yéké guné yo. Guné waga yagunu de véte waké de yo, ‘Naané derét kapéredi mu naanébu yak. Kukba Got yanan kapéredi mu naanat yakataké dé yo.’ Naate waké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Waga wadéka de déku du yék. Ye de du taakwat wak, “Yagunén kapéredi mu kulaknyényké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Naate watakne de duna mawuléba tékwa kutakwat wadaka de yaage yék. Kiyakiya yakwa du taakwa Gotké miték sanévéknwudoké de deku sépéba de sépéba kutdakwa wel kurék. Kutdaka de yéknwun yak. Waga de Jisasna du yakéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisasna du waga yadaka némaan ban Yerot dé kudi véknwuk, akwi gayéba de Jisaské kudi buldakwa bege. Du taakwa de las wak, “Gu yaakutaknan du Jon kiyae débu nébéle raapmék. Nébéle raapme némaa apa kérae dé wani apa jébaa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naate wadaka de las wak, “Wan déknyényba ran du Ilaija.” Naate wadaka de las wak, “Wan Gotna yéba kudi wakwekwa du, déknyényba ran du pulak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Naate wadaka dé Yerot wani muké véknwute dé wak, “Déknyényba wuné wawuréka de Jonna maakna tépaknék. Tépakdaka kiyae bulaa débu tépa nébéle raapmék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Déknyényba Yerot dé déku némaadu Pilipna taakwa yak. Wani taakwana yé Yerodias. Yadéka dé Jon wak, “Ména némaadu radéka déku taakwa yaménén wan sépélak méné yak. Got wani muké dé waatiyu.” Naate wadéka dé Yerot Jonna kudiké kélik yate wadéka déku du ye de Jonét kulékiye baagwit gitakne dérét de kure yék raamény gat. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yédaka raamény gaba kwaadéka lé Yerodias rékaréka yate lé Jonét viyaapérekgé mawulé lé yak. Yatakne dérét viyaapérekgé lé yapatik, Yerot wani muké kélik yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yerot dé kutdéngék. Jon wan Gotna kudi véknwute yéknwun mu yakwa du. Waga kutdéngte dé wup yate Yerodias Jonét viyaapérekmuké dé déké miték vék. Véte nak apu nak apu Jon wale kudi bulte déku kudiké mawulé yate dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kukba lé Yerodias Jonét viyaapérekléran tulé dé yaak. Yerot wadéka déku du de apakélé yaa séraknék, déku néwaa dérét kéraalén nyaa yadéka. Sérakdaka kadému kadoké wadéka de déku jébaa yakwa némaan du, waariyakwa duna némaan du, Galiliba rakwa némaan du, waga de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ye radaka Yerodiasna takwanyan gwaade lé kétik. Kétiléka Yerot wale kadému kan du véte de akwi mawulat kapére yak. Yate dé némaan ban Yerot wani taakwat waatak, “Samuké nyéné mawulé yo? Wakwenyénu kwayéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naate watakne dé tépa wak, “Gwalmuké nak mawulé yanyénéran kwayéké wuné yo. Wuna képmaa, wuna ga, wuna gwalmu nyédéba muniwuruké mawulé yanyénéran waga yaké wuné yo. Waga male yaké wuné yo. Wan adél.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dé waga wadéka lé wani taakwa gwaade lé léku néwaat waatak, “Samu gwalmuké wakweké wuné yo?” Naate waataléka lé léku néwaa wak, “Gu yaakutaknan du Jonna maaknaké wakweké nyéné yo. Wakwetakne kéraanyénu wuné kiyaadénké kutdéngké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naate waléka lé bari bari némaan ban ranét yék. Ye lé wak, “Bulaa gu yaakutaknan du Jonna maakna tépakne agérapba takne méné wunéké tiyaaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naate waléka dé Yerot waga yamuké kélik yate dé sanévéknwu wanévéknwuk, taknaba lérét adél kudi wadéka de dé wale rate kadému kan du véknwudan bege. Sanévéknwute nak pulak kudi wakwemuké kélik yate dé kusékérék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kusékéttakne dé wadéka déku du nak ye raamény gat wulae dé Jonna maakna tépaknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tépakne maakna agérapba takne dé wani taakwaké kure yék. Kure ye wani taakwaké kwayédéka lé léku néwaaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waga yadaka Jonna du véknwutakne ye de Jonna gaaba ségwi kérae kure ye de rémék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisasna du de tépa gwaamale yék déké. Ye dé wale rate de yadan akwi jébaa, wakwedan akwi kudiké wawo de dérét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wakwedaka de wupmalemu du taakwa yeyé yeyak. Yeyé yeyadaka Jisas déku du wale kaapuk yaap rate kadému kadan. Waga yate dé derét wak, “Naané kapmu du taakwa rakaapuk taalat ye guné yaap raké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naate watakne de bot kérae kure de du taakwa rakaapuk taalat de kapmu de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","De yédaka wupmalemu du taakwa véte de derét kutdéngék. Kutdéngte de akwi gayéba yae képmaaba bari pétépété ye de taale saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Saabadaka dé Jisas botba yae kwawu maaléba téte dé wupmalemu du béré taakwa bérat vék. Véte déku mawuléba dé wak, “Sipsipké téségékwa du rakaapuk yadéran de sipsip mitékne tékaapuk yaké de yo. Wani du taakwa wan wani sipsip pulak.” Waga wate dé deké mawulé léknék. Mawulé lékte dé derét wupmalemu kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wakwedéka garabu yadéka déku du yae de dérét wak, “Kén du rakaapuk taalé. Nyaa déwa dawulikwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Méné waménu kéni du béré taakwa béré gege gayét ye de deku kadému kéraaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naate wadaka dé Jisas derét wak, “Kaapuk. Guné deké kadému kwayéké guné yo.” Naate wadéka de wak, “Naané deké béret kéraaké wupmalemu (200) yéwaa kwayéké naané yo. Naané ye wani du taakwaké akwi kadému las kérae deké kwayénoké méné mawulé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naate wadaka dé wak, “Béret yagap dé ro? Ye véké guné yo.” Naate wadéka de sékale vék. Vétakne gwaamale yae de wak, “Makwal béret naktaba guba kutdan gukwami vétik waga dé ro.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wadaka dé akwi du taakwat wak, “Guné mé yéknwun waaraba saakiye ragunu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naate wadéka de las apakélé kém las makwal kém waga de saakiye rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Radaka dé wani makwal béret naktaba gukwami vétik kérae dé nyérét kwaasawuré véte Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayék, du taakwaké munikwedoké. Kwayétakne dé wani gukwami vétik wawo dé kwayék, munikwedoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kwayédéka munikwedaka de akwi du taakwa mitékne kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kadaka béret las gukwami las radéka de Jisasna du kébi taaba vétik sékérék maanba kayék vétik waga de laakwa sékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wupmalemu (5,000) du de wani béret kak. Wupmalemu taakwa wupmalemu baadi wawo waba de rate kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisasna du waga yadaka dé derét wak, “Guné botba waare guné taale yéké yo, kwawu nak saknwat, Betsaidat.” Naate wadéka déku du yédaka dé dé wale tén du taakwat wak, deku gayét yékéradoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wadéka yédaka dé Got wale kudi bulké nae dé nébat waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gaan yadéka déku du botba rate kwawu nyédéba tédaka Jisas kapmu dé rak nébuba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rate dé vék wimut kutdéka bot gwaamal gwaamal yaléka déku du botba yéké apa jébaa yadaka. Vétakne yé tékgé yadéka dé gu takuba deké yék. Ye dé derét talaknaké nae dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ye gu takuba yédéka de véte wak, “Wan gaababan dé nak yao.” Naate watakne de akwi dérét véte wupmét kapére yate de némaanba gureknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gurekdaka dé bari wak, “Wup yakaapuk. Kén wuné wuné yao. Yéknwun mawulé yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naate watakne dé botba waarék. Waare de wale radéka dé wimut kaapuk yak. Yadéka kwagénte de wak, “Aki. Wan yaga pulak du?” Naate wate de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Naléba Jisas wani du taakwaké wani béret kwayédénké de kaapuk miték sanévéknwudan. Wani muké yékéyaak yate kwagénte de waga wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas déku du wale kwawu nak saknwat botba ye de Genesaretna képmaa saabak. Saabe de bot tébétsawurék nébat. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yatakne yédaka de du taakwa Jisasnyét véte de dérét bari kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kutdéngte de gege gayét pétépété yéte de sépékwaapa kapére yan du taakwa baadit kérae de jaabéba taknak. Takne de derét kérae yaate yék, Jisas tékwa akwi taalat. ");
INSERT INTO abt_maprik_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas yédén akwi gayét de kiyakiya yakwa du taakwa baadi, sépékwaapa kapére yan du taakwa baadit kérae yaatak. Kérae yaate de jawudakwa taaléba taknak. Takne de dérét wak, “Méné kusékétménéran de ména baapmu wutna waabuba male kutké de yo.” Naate wadaka de déku baapmu wutba kutte de yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Apa kudiké kutdéngkwa du las de Jerusalemba re ye de Parisina du wale waga de jawuk Jisas ténba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jawute de vék Jisasna du las Parisina du taaba yakutnyédakwa pulak yakaapuk yate deku taaba bakna yakutnyétakne kadému kadaka. Du deku taaba bakna yakutnyédaka de Parisina du derét véte wo, “Naana apa kudi kaapuk véknwudakwa. Wan kapéredi mu yakwa du.” Naate de wo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisina du wupmalemu Judana nak du wawo deku képmawaara wadan pulak waga male taaba miték yakutnyétakne de kadému ko. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","De gwalmu kure yédaka kéraadakwa taaléba yae de taale gu yaaku. Gu yaakwe de kadému ko. Deku képmawaara wadan pulak de awu, agérap, jaabé wawo de waga male miték yakutnyu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De waga yadaka Jisasna du képmawaara wadan pulak yakaapuk yadaka de Parisina du apa kudiké kutdéngkwa du wawo de Jisasnyét waatak, “Samuké de ména du naana képmawaara wadan kudi véknwukaapuk yate deku taaba bakna yakutnyétakne de kadému ko?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Naate waatadaka dé Jisas wak, “Guné yénaa yakwa du guné. Déknyényba Gotna yéba kudi wakwen du Aisaia kéni kudi kavite dé adél kudi kavik gunéké. Kéga dé kavik: Got dé wak, ‘Kéni du taakwa de wunéké yéknwun kudi wakweyo. Waga wakwete de wunéké deku mawuléba kaapuk miték sanévéknwudakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","De deku apa kudi véknwute wadékwa pulak yate de wani kudiké wo, Wan Gotna kudi. Naate wate wuna yéba kevérékte de yaamabi kudi bulu.’ Naate Got wadéka Aisaia dé kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Guné wani du pulak guné ro. Guné Gotna kudi véknwukaapuk yate guné duna kudi male guné véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wani kudi watakne dé Jisas wak, “Guné Gotna kudi véknwukaapuk yate naana képmawaara wadan kudi male véknwute guné wo, ‘Naané yéknwun mawulé pukaakwa du.’ Waga wagunéka guna mawulé sépélak dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Déknyényba Moses Gotna kudi dé kéga wakwek, ‘Guné guna néwepat kutkalé yaké guné yo.’ Naate wakwetakne kéni kudi wawo dé wak, ‘Du nak déku néwepaké kapéredi kudi wakwedéran wani dut viyaagunu dé kiyaaké dé yo.’ Waga wadéka wani kudi Gotna nyégaba dé kwao. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Guné wani kudi véknwukaapuk yate guné wo, ‘Du nak déku néwepat kéga wadéran, Kéni gwalmu Gotké wunébu kwayék. Gotké kwayékaapuk yawuru mukatik bénéké kwayékatik wuné yak. Bénat kutkalé yaké wuné yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Naate wadéran déku néwepat kutkalé yakaapuk yadékwa wan yéknwun, Gotké kwayédén bege.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Guné waga wate guné Gotna kudi véknwukaapuk yate guna képmawaarana kudi male véknwute kudi wagunéka de du taakwa wawo waga de sépélak yo. Yadaka guné kapéredi mu las wawo guné waga yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas wani kudi watakne du taakwat wadéka de déké yék. Yédaka dé derét wak, “Guné wuna kudi mé miték véknwu. Véknwute kéni muké guné miték kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Du taakwana biyaaba wulaakwa muké sanévéknwute Got wakaapuk yaké dé yo, ‘Wan kapéredi mu yakwa du taakwa.’ Du taakwana mawuléba yaalakwa muké sanévéknwute Got waké dé yo, ‘Wan kapéredi mu yakwa du taakwa.’ Naate waké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Watakne du taakwat kulaknyénytakne dé déku du wale de gat wulaak. Wulae déku du de dérét waatak wani kudiké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Waatadaka dé derét wak, “Guné wawo wani kudiké kaapuk kutdénggunén, kapu yaga pulak? Mé véknwu. Du taakwa kadakwa mu deku biyaat dawuliye walkamu te dé yu. Kadakwa mu deku mawulat kaapuk yaalébaandékwa.” Naate dé wak. Jisas waga wadéka naané kutdéngék. Akwi kadému kwaami wan yéknwun. Naané kadému kwaamiké las yaakétkaapuk yaké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas dé tépa wak, “Du taakwana mawuléba yaalakwa muké sanévéknwute Got waké dé yo, ‘Wan kapéredi mu yakwa du taakwa.’ Naate waké dé yo, kéni muké kutdéngdén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Du taakwana mawuléba kapéredi mawulé dé yaalo. Yaaladéka de kapéredi mawulé yate radakwa, du de taakwat tébétte kapéredi mu yadakwa, taakwa de dut tébétte kapéredi mu yadakwa, sél yadakwa, du taakwat viyaapérekdakwa, du nak duna taakwa wale kapéredi mu yadakwa, taakwa nak taakwana du wale kapéredi mu yadakwa, nak duna gwalmuké géndakwa, kés kapéredi mu nak kapéredi mu yadakwa, yénaa kudi wakwedakwa, kudi véknwukaapuk yate sépélak yadakwa, yéknwun mu nak du taakwaké yaadéka deké yaakaapuk yadéka wani du taakwaké kapére mawulé yadakwa, nak du taakwaké kapéredi kudi wakwedakwa, deku yéba kevérékdakwa, waagété yadakwa, waga yate de kapéredi mu yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wani kapéredi mu akwi du taakwana mawuléba dé yaalo. Yaaladéka de kapéredi mu yo. Kapéredi mu yadaka Got deké dé wo, ‘Wan kapéredi mu yakwa du taakwa.’ Naate dé wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wani kudi watakne Jisas wani gayé kulaknyénytake dé Taiana képmaat yék. Ye gayé saabe dé gat nak wulaak. Wulae dé déku mawuléba wak, “Wuné kéni gaba rawuru de du taakwa kutdéngkaapuk yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Waga wadéka de dérét vék. Véte kutdéngte kudi buldaka lé taakwa nak véknwutakne lé déké bari yék. Lé Judana taakwa rakaapuk yate nak geba yaan taakwa rate lé déké yék. Léku néwaage Pinisia Siriana képmaaba dé tu. Léku takwanyanna mawuléba kutakwa nak wulae téléka lé néwaa Jisaské yék. Ye kwati yaane waadé daate lé dérét wak, “Kutakwa lé nak tu, wuna takwanyanna mawuléba. Méné waménu lé yaage yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Naate waléka dé déku mawuléba wak, “Naané Juda nak gena du taakwaké ‘Waasa’ naate naana du taakwaké ‘Baadi’ naané nao.” Naate watakne dé kéni aja kudi lérét wakwek, “Naané baadi kakwa kadému kérae makwal waasaké kwayénaran wan yéknwun mu kaapuk. Naané taale baadiké kwayéké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Waga wadéka lé wak, “Némaan Ban, wan adél kudi méné wo. Wuné kéga wuné wo. Baadi kadému kadaka las képmaaba akérédéka de deku waasa kérae ko. Méné wunat kutkalé yaménéran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naate waléka dé lérét wak, “Waga miték watakne bulaa nyéna gayét yéké nyéné yo. Kutakwa nyéna takwanyanna mawulé kulaknyénytakne lébu yaage yék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naate wadéka léku gayét gwaamale ye lé vék takwanyan yéknwun ye jaabéba kwaaléka. Véte lé kutdéngék kutakwa lérét kulaknyénytakne yaage yélénké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kukba Taiana képmaa kulaknyénytakne Saidonna képmaaba yéte Dekapolisna képmaaba ye dé Jisas Galilina kwawu saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ye saabadéka de dut nak kure yék déké. Wani du waagété ye kudi kaapuk véknwudén. Yate kudi kaapuk mitékne buldén. Wani dut kure ye de Jisasnyét wak, dérét taaba kutduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wadaka Jisas wani dut kure du taakwat kulaknyénytakne walkamu ye bét kapmu ték. Téte dé Jisas déku tabasék wani duna waanba yatdute sépmeny sévae dé déku tabasék wani duna téknayéléngba yatduk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yatdute dé nyérét kwaasawuré vék. Kwaasawuré véte mawulé lékte dé némaanba yaap jaate dé déku kudiba wak, “Epata.” Naate dé wak. Naana kudi kéga: Ména waan mé véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jisas waga wadéka dé mitékne véknwuk. Véknwudéka téknayéléng yéknwun yadéka dé mitékne bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Buldéka dé Jisas du taakwat walaakwe véte dé derét wak, “Wani muké wakwekaapuk yaké guné yo.” Naate wadéka de déku kudi véknwukaapuk yate apa ye de wani muké kudi wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wakwekéreyédaka véknwute kwagénte de wak, “Aki. Wan yaga pulak ban? Miték male dé yo. Yadéka de kudi véknwukaapuk yan du taakwa de miték véknwu. De kudi bulkaapuk yan du taakwa de kudi bulu.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Wani tulé nak nyaa wupmalemu du taakwa ye de jawuk, Jisas ténba. Jawe re kadémuké yapatidaka Jisas wadéka déku du déké yaadaka dé derét wak, “Wani du taakwa nyaa kupuk wuné wale rate deku akwi kadému kabutitakne bulaa kaadé wale radaka deké wuné mawulé léknu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Las de séknaa saaknaba de yaak. Wuné deké kadému kwayékaapuk yate yédoké wawuréran de deku gayét gwaamale yéte yaabuba kaadéké kiyaaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naate wadéka de déku du dérét wak, “Kéni taalé du rakaapuk taalé. Yaga pulak naané wupmalemu du taakwaké kadému kwayéké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naate wadaka dé derét waatak, “Béret yagap dé ro?” Naate waatadéka de wak, “Béret nak taaba sékét nak taababa kayék vétik dé ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","De waga wadaka dé akwi du taakwat wak, “Guné mé ra képmaaba.” Naate wadéka radaka dé wani makwal béret kérae dé Gorét wak, “Yéknwun kadému ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayék, du taakwaké munikwedoké. Kwayédéka de munikwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Guba kutdan walkamu makwal gukwami wawo de rak. Jisas wani gukwami kérae dé Gorét wak, “Yéknwun kwaami ménébu tiyaak. Wan yéknwun.” Naate watakne dé déku duké kwayék, du taakwaké munikwedoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kwayédéka munikwedaka de akwi mitékne kak. Wupmalemu (4,000 pulak) du taakwa de waba rate kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kabutidaka Jisas bulédén béret las gukwami las radéka de Jisasna du kébi nak taaba sékét nak taababa kayék vétik waga de laakwa sékéréknék. Yadaka Jisas wadéka de du taakwa yékérak deku gayét. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yékéradaka Jisas déku du wale botba waare de Dalmanutana képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisina du las ye de Jisas wale waaruké nae de yak. Ye deku mawuléba de wak, “Got wadéka dé Jisas yaak, kapu bakna du dé?” Waga sanévéknwute de dérét wak, “Méné déknyényba vékaapuk yanan apa jébaa nak yaké méné yo. Yaménu naané véte kutdéngké naané yo. Got wadéka méné yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Naate wadaka dé Jisas kélik yate dé waatak, “Samuké guné bulaa rakwa du taakwa guné déknyényba vékaapuk yagunén apa jébaaké waato? Kaapuk. Waga vékaapuk yaké guné yo. Adél wuné gunat wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naate watakne derét kulaknyénytakne déku du wale botba tépa waare de kwawu nak saknwat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisasna du béretké yékéyaak ye de nakurak béret male de kérae kure yék botba. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yadaka dé Jisas derét kéni aja kudi wak, “Mé véknwu. Jérawu yaké guné yo. Parisina du, Yerot wawo, deku yis kutkaapuk yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naate wadéka de deku kapmu bulte de wak, “Naané béret las kaapuk kure yaanan. Waga yananké dé béret apakélé yaduké kutdakwa mu yiské dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Waga buldaka dé kutdéngte dé wak, “Guné guné wo, ‘Naané béret kaapuk.’ Samuké guné waga wo? Guné waga wate guné wuna apaké kaapuk wekna miték kutdénggunén. Guna mawulé yékéyaak dé yo, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Guna méni dé tu. Samuké guné vékaapuk yo? Guna waan dé tu. Samuké guné kudi véknwukaapuk yo? Samuké guné guna mawuléba miték sanévéknwukaapuk yo? ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Déknyényba wupmalemu (5,000) duké béret naktaba bulékwewuréka de kak. Kadaka las radéka kébi yagap guné laakwak?” Naate waatadéka de wak, “Kébi taaba vétik sékérékne maanba kayék vétik naané laakwak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Naate wadaka dé wak, “Déknyényba nak tulé wupmalemu (4,000) du béré taakwa béréké béret nak taaba sékét nak taababa kayék vétik bulékwewuréka de kak. Kadaka las radéka kébi yagap guné laakwak?” Naate waatadéka de wak, “Kébi nak taaba sékét nak taababa kayék vétik naané laakwak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naate wadaka dé derét wak, “Wan adél. Waga wate samuké guné wuna apaké kaapuk kutdénggunén? Wuné yiské wakwete wuné béretké kaapuk sanévéknwurén.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kukba Jisas déku du wale ye de Betsaida saabak. Saabadaka de méni kiyaan dut nak kure yék Jisaské. Kure ye de Jisasnyét wak, déku taaba wani dut kutduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wadaka dé wani duna taababa kutdéka bét gayé kulaknyénytakne bét walkamu yék. Ye yaabuba téte dé sépmeny déku taababa sévaatakne dé wani duna méniba kurék. Kuttakne taabat kutte dé waatak, “Las méné vu?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Waatadéka wani du véte dé wak, “Duwat mi pulak wuné vu. Véwuréka de yeyé yeyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naate wadéka dé tépa taabat kurék déku méniba. Kutdéka déku méni yéknwun yadéka dé mitékne vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mitékne védéka dé Jisas wak, “Ména gat yéké méné yo. Wani gayét tépa gwaamale yékaapuk yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas waga watakne déku du wale waga de yék, Sisaria Pilipaiba tékwa gayét. Yaabuba yéte dé derét waatak, “Du taakwa wunéké yaga de wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naate waatadéka de wak, “Ménéké las de wo, ‘Wan gu yaakutaknan du Jon.’ Las de ménéké wo, ‘Wan déknyényba rate Gotna yéba kudi wakwen du Ilaija.’ Las de ménéké wo, ‘Gotna yéba kudi wakwen nak du.’ Naate de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Waga wadaka dé derét waatak, “Guné yaga pulak? Guné wunéké yaga guné wo?” Naate waatadéka dé Pita wak, “Méné naanat kutkalé yaménuké Got wadén ban Krais méné.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Naate wadéka dé derét wak, “Wani kudi nak du taakwat wakwekaapuk yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas waga watakne dé déku duwat kéga wakwek, “Akwi Du Taakwana Nyaan wunat kapéredi mu yado de kubu du, nyédé duna némaan du, apa kudiké kutdéngkwa du waga wunéké kuk tiyaaké de yo. Tiyaado wunat viyaapérekdo kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu wuné tépa nébéle raapké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Naate wate dé aja kudi kaapuk wakwedén. Yadéka de miték véknwuk. Véknwute dé Pita dérét kure walkamu ye kélik yate dé wak, “Waga bulkaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Naate wadéka dé Jisas walaakwe déku duwat véte dé Pitat wak, “Méné Seten, méné mé yaage yé. Méné Gotna kudi kaapuk véknwuménékwa. Méné kéni képmaaba rakwa duna kudi méné véknwu.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Watakne dé tépa wadéka de wupmalemu du taakwa déku du wawo de déké yék. Yédaka dé derét wak, “Guné wuné wale yaate wuna jébaa yaké mawulé yagunéran kéga yaké guné yo. Guné guna mawulé kulaknyényké guné yo. Kulaknyénye guné wunéké sanévéknwute kéga waké guné yo, ‘Naané déku jébaa kutsaakuké naané yo. Yate naané kaagél kutte miba kiyaanaran wan bakna mu. Némaa mu kaapuk.’ Naate wate wuna jébaa kutké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wunéké sanévéknwukwa du taakwa wuna jébaa kutsaakudo wuna maama derét viyaapérekdaran de wuné wale miték rasaakuké de yo apuba apuba. Wunéké sanévéknwukaapuk yakwa du taakwa deku sépéké male sanévéknwute deku jébaa male yadaran de kiyae yalakgé de yo. Wuné wale rasaakukaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Du taakwa kéni képmaana gwalmu akwi kéraaké sanévéknwute, deku jébaa male yadaran kiyae yaga pulak de miték rasaakuké de yo? Kaapuk. Miték rasaakukaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","De Gotna gayét yéké mawulé yadaran yéwaa kwayéké de yo, kapu yaga pulak? Kaapuk. De yékaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bulaa rakwa wupmalemu du taakwa de kapéredi mu yate de Gotna kudi kaapuk véknwudakwa. Kukba wuna yaapa wunéké apa tiyaate wadu wuné Akwi Du Taakwana Nyaan nyaa vékwa pulak rate giyaaké wuné yo. Gotna kudi kure giyaakwa du wale giyaaké wuné yo. Giyae wuné kuk kwayéké wuné yo, wunéké kuk tiyaan du taakwaké.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas dé derét wak, “Kéni kudi mé véknwu. Guné kéba tékwa du taakwa las kiyaakaapuk ye wekna rate véké guné yo Got apa yate némaan ban rate déku du taakwaké miték védu. Adél wuné gunat wakweyo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nyaa nak taaba sékét nak taababa kayék nakurak yédéka dé Jisas, Pita, Jems, Jonét waga kwole de apakélé nébat nak waarék. Waare de kapmu de waba rak. Rate védaka Jisasna sépé walaakwe dé nak pulak yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Déku baapmu wut dé waamat kapére yak. Kéni képmaaba rakwa du waga pulak waama yaké de yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yadéka déknyényba rate Gotna yéba kudi wakwen du Moses bét Ilaija bét Jisas wale kudi buldaka de Jisasna du kupuk vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Véte de wupmét kapére yak. Yate Pita kudi wakweké miték kutdéngkaapuk yate dé Jisasnyét wak, “Némaan ban, naané kéba ranakwa wan yéknwun. Naané ga kupuk kaaké naané yo. Ménéké nak, Moseské nak, Ilaijaké nak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naate wadéka buwi nak giyae dé derét taknatépék. Taknatépédéka dé kudi nak buwiba gwaade dé wak, “Kén wuna nyaan. Déké wuné mawulat kapére yo. Guné déku kudi mé véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Naate wadéka véknwutakne de vék Jisas kapmu tédéka. Nak duwat kaapuk védan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","De wani nébuba dawulite dé Jisas derét wak, “Mé véknwu. Guné végunén muké nak duwat bulaa wakwekaapuk yaké guné yo. Wuné Akwi Du Taakwana Nyaan kiyaawuru Got wadu wuné nébéle raapwuru guné wani tulé wani muké wakweké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Naate wadéka de nak duwat kaapuk wakwedan wani muké. De kapmu bulte de waatak, “Kiyae nébéle raapdéran kudi wan samu kudi?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jisasna du de dérét waatak, “Apa kudiké kutdéngkwa du de kéga wo, ‘Gotna yéba déknyényba kudi wakwen du Ilaija taale yaaké dé yo. Yaadu Got wadén ban Krais kukba yaaké dé yo.’ Samuké de waga wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naate wadaka dé wak, “Wan adél kudi de wo. Ilaija taale yaaké dé yo. Yae dé Kraisna yaabu kutké dé yo. Wani kudiké sanévéknwute wunéké wawo mé sanévéknwu. Gotna nyégaba kwaakwa kudi nak wadékwa pulak Akwi Du Taakwana Nyaan wunat kapéredi mu yate wunéké kuk tiyaaké de yo. Samuké nae de wani kudi kavik? ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wuné gunat wuné wakweyo. Ilaija débu yaak. Yaadéka du las de dérét kapéredi mu yak. Déknyényba wani muké wawo de Gotna nyégaba kavik.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas, Pita, Jems, Jon wale waga de dawulik Jisasna nak duké. Dawuliye de vék wupmalemu du taakwa de wale jawe téte apa kudiké kutdéngkwa du de wale waarudaka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Védaka de akwi du béré taakwa béré Jisasnyét véte de kwagénék. Kwagénte déké pétépété ye de dérét wak, “Ménéwa yaakwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naate wadaka dé Jisas déku duwat waatak, “Samu kudi guné de wale bulu?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Naate waatadéka dé du nak wak, “Némaan ban, wuna nyaan wunébu kure yaak ménéké. Kutakwa lé nak tu déku mawuléba. Téléka dé kudi kaapuk buldékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wani kutakwa dérét kure apa yaléka dé képmaaba akéru. Akérédéka dé waama sépmeny déku kudiba yaalo. Yaaladéka nébi tidéka déku sépé apa dé yo. Bulaa ména duwat wuné wak, de wado kutakwa yaage yéluké. Wawuréka de waga yaké de yapatik.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wadéka dé Jisas wani du taakwat wak, “Yaga pulak? Guné wunéké kaapuk miték sanévéknwugunékwa. Wuné wupmalemu baapmu guné wale rawuréka guné wunéké kaapuk miték sanévéknwugunékwa. Guné wani nyaanét wunéké mé kure yaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naate wadéka dérét kure yédaka dérét kure tén kutakwa Jisasnyét véte lé nyaanét takubalaakuk. Yaléka dé képmaaba akére pératékétdéka dé waama sépmeny déku kudiba yaalak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaaladéka dé Jisas déku yaapat waatak, “Kwaaré yagap dé waga rak?” Naate waatadéka dé wak, “Makwal du radéka dé batnyé waga yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wupmalemu apu lé wani kutakwa dérét kure téte dérét yaalébaante viyaaléka dé guba, yaaba wawo dé akérék. Méné apa yaménéran méné anéké mawulé lékte waménu dé yéknwun yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naate wadéka dé Jisas wak, “Méné wawo apa yaké méné yo. Du taakwa Gotké miték sanévéknwudaran de akwi mu yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naate wadéka dé wani nyaanna yaapa wak, “Gotké wuné walkamu sanévéknwu. Méné wunat kutkalé yaménu wuné Gotké miték sanévéknwuké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Naate wadéka dé Jisas vék wupmalemu du taakwa pétépété yae jawudaka. Véte dé wani kutakwat wak, “Nyéné dérét kure tényénéka dé wani nyaan kudi bulkaapuk yate kudi kaapuk véknwudékwa. Nyéné dérét kulaknyénytakne yaage yéké nyéné yo. Yaage ye tépa déku mawulat wulaakaapuk yaké nyéné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Naate wadéka lé némaanba waatakne wani nyaanét lé némaanba takubalaakuk. Takubalaakutakne lé dérét kulaknyénytakne lé yaage yék. Yéléka dé wani nyaan kiyaan du pulak kwaak. Kwaadéka de du las wak, “Débu kiyaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naate wadaka dé Jisas déku taababa kutkwedéka dé yéknwun ye raapmék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dé yéknwun ye raapdéka Jisas déku du wale de gat wulaak. Wulae de kapmu rate déku du de dérét wak, “Naané wani kutakwat wanaka lé yaage yékaapuk yak. Samuké naané wani jébaa yaké yapatik?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naate waatadaka dé wak, “Wani muké Gorét waataké guné yo. Gorét taale waatagunéran guné wagunu de kutakwa yaage yéké de yo. Guné Gorét waatakaapuk yagunéran kutakwa guna kudi véknwukaapuk yate yaage yékaapuk yaké de yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas déku du wale wani gayé kulaknyénytakne de Galilina képmaaba yeyé yeyak. Yeyé yeyate dé déku duwat wak, “Wupmalemu du taakwa naanéké kutdéngkaapuk yadoké naané akélak yéké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Waga yéte kudi las gunat wakweké wuné yo.” Naate watakne dé derét kéni kudi wakwek, “Kukba de wuné Akwi Du Taakwana Nyaanét maamaké kwayédo wuné deku taababa raké wuné yo. Rawuru wunat viyaapérekdo kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu tépa nébéle raapké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naate wadéka de wani kudi kaapuk miték kutdéngdan. Yate wani kudiké dérét waatamuké wup de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kukba de Kapaneamét yék. Ye saabe de gat wulaak. Wulae dé Jisas déku duwat waatak, “Yaabuba yaate samu kudiké guné bulék?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Naate waatadéka de kudi kaapuk buldan. Yaabuba yaate deku kapmu bulte de wak, “Kiyadé naana duwat talakne naanéké némaan ban ro?” Naate watakne nyékéri yate de Jisasnyét kudi kaapuk buldan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yadaka dé rate dé derét wak, “Guné mé yaale véknwu. Guné nak nak du taakwaké némaan ban raké mawulé yagunéran guné guna yéba kevérékmarék yate akwi du taakwaké jébaa yakwa ban raké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Naate watakne dé deku nyaanét nak kure wadéka dé deku nyédéba ték. Tédéka dé wani nyaanét kutte dé derét wak, “Mé véknwu. Du taakwa wunéké sanévéknwute kéga pulak nyaanét kutkalé yate de wunat wawo kutkalé yo. De wunat kutkalé yate wunat wadéka yaawurén banét wawo de kutkalé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jisas wani kudi wadéka dé Jon dérét wak, “Némaan ban, du nak ména yéba kutakwat wadéka yaage yédaka naané vék. Dé naané wale kaapuk yeyé yeyadékwa. Yadéka naané dérét wak, wani jébaa yakaapuk yaduké.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naate wadéka dé Jisas dérét wak, “Guné wani jébaa yakaapuk yaduké dérét waatikaapuk yaké guné yo. Wuna yéba apa jébaa yakwa du wunéké bari kapéredi kudi wakaapuk yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Naanéké kuk tiyaakaapuk yakwa du wan naana du de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kéni kudi wawo mé véknwu. Du taakwa guné wuna duwat véte kéga wadaran, ‘Wani du de Jisasna jébaa kuru. Derét kutkalé yaké naané yo. Derét gutak yadu deké gu kwayéké naané yo.’ Naate wadaran de wani makwal jébaa yado Got wani makwal jébaaké yékéyaak yakaapuk yaké dé yo. Kukba wani yéknwun jébaa kaataké dé yo derét. Adél wuné gunat wakweyo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wani kudi watakne dé kéga wakwek: “Kéni makwal baadi de wuna kudi miték véknwu. De dut nak déku kwaaléba apakélé matu gitakne dérét yatjadado dé géléguba dawuliye gu ke kiyaadu mukatik wan kapéredi mu. Du nak wakwedu wani baadi nak déku kudi véknwute wuna kudi kulaknyénydéran Got waga wakwen dut némaanba yakataké dé yo. Wan apakélé kapéredi mu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Guna taaba kapéredi mu yaké yadéran guné wani taaba tépakne yatjadaké guné yo. Guna nakurak taaba male tédu wani kapéredi mu yakaapuk yate Gotna kémba yaalagunéran wan yéknwun. Guna taaba vétik tédu guné wani kapéredi mu yatakne kukba kapéredi taalat dawuligunéran wan kapéredi. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wani taaléba yaa dé yaansaaku apuba apuba. Yaansaakudéka de gaaba ségwiba kakwa kaawiya kaapuk kiyaadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Guna maan kapéredi mu yaké yadéran guné wani maan tépakne yatjadaké guné yo. Guna nakurak maan male tédu wani kapéredi mu yakaapuk yate Gotna kémba yaalagunéran wan yéknwun. Guna maan vétik tédu guné wani kapéredi mu yatakne kukba kapéredi taalat dawuligunéran wan kapéredi. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wani taaléba yaa dé yaansaaku apuba apuba. Yaansaakudéka de gaaba ségwiba kakwa kaawiya kaapuk kiyaadakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Guné guna méni kapéredi mat véte wani kapéredi mu yaké mawulé yagunéran wani méni pékwe yatjadaké guné yo. Guna nakurak méni male tédu wani kapéredi mu yakaapuk yate Gotna kémba yaalagunéran wan yéknwun. Guna méni vétik tédu guné wani kapéredi mu yatakne kukba kapéredi taalat dawuligunéran wan kapéredi. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wani taaléba yaa dé yaansaaku apuba apuba. Yaansaakudéka de gaaba ségwiba kakwa kaawiya kaapuk kiyaadakwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wani kudi watakne dé wak, “Naané sol kadémuba taknanaran yéknwun yaké dé yo. Waga pulak Got wadu yaa pulak yaandu guné akwi kaagél kure kukba yéknwun yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kadému lisék yaduké naané sol takno. Sol yéknwun yakaapuk yadéran yaga pulak yano tépa yéknwun yaké dé yo? Kaapuk. Yéknwun tépa yakaapuk yaké dé yo. Kadémuba yéknwun sol taknanaran wani kadému yéknwun yaké dé yo. Guné sol pulak yate guné akwi du taakwat yéknwun yaké guné yo. Yate guné de wale nakurak mawulé yate miték raké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wani gayé kulaknyénytakne Judiana képmaat ye kulaknyénytakne Jisas déku du wale Jodan kaabéléba de atik. Atiye nak saknwuba tédaka de wupmalemu du taakwa Jisaské ye de jawuk. Jawudaka dé saaki yadékwa pulak dé tépa derét Gotna kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dé waga wakwedéka de Parisina du las déké yék. Ye deku mawuléba de wak, “Naané dérét nak muké waatanaran sal dé kapéredi kudi wadu naané dérét kotimké naané yo?” Naate sanévéknwute de dérét wak, “Naana apa kudi yaga dé wo? Du nak déku taakwa dérét kulaknyénytakne yéluké wadéran wan yéknwun, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Naate wadaka dé derét wak, “Wani muké naana képmawaara Moses yaga dé wak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Naate wadéka de wak, “Moses dé wak, ‘Du nak déku taakwa dérét kulaknyénytakne yéluké wadéran dé taale nyéga nak kaviké dé yo wani muké. Kavitakne léké kwayétakne wadu lé dérét kulaknyénytakne yéké lé yo.’ Waga dé Moses wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Naate wadaka dé derét wak, “Guné akwi kapéredi mawulé yakwa du taakwa ragunéka dé Moses gunéké wani kudi kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Déknyényba batnyé du deku taakwat waga kaapuk wadan. Déknyényba Gotna nyégaba du nak kéga dé kavik: Déknyényba batnyé Got akwi mu kuttakne dé du taakwat wawo yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kavitakne kéni kudi wawo dé kavik: Du déku néwepat kulaknyénytakne taakwa ye bét nakurakba raké bét yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Rate nakurak sépé ye raké bét yo. Wani kudiké sanévéknwute naané kutdéngék. Du taakwa ye bét nakurakba bét ro. Nakurak sépé ye bét ro. Sépé vétik kaapuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Got bétké dé wo, ‘Nakurak sépé ye bét ro.’ Naate wadékwaké du nak déku taakwat wakaapuk yaké dé yo, lé dérét kulaknyénytakne yéluké.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Watakne dé déku du wale de gat wulaak. Wulae de wani kudiké Jisasnyét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Waatadaka dé derét wak, “Du deku taakwa derét kulaknyénytakne yédoké watakne nak taakwa yadaran de taale yadan taakwat kapéredi mu de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Taakwa deku du kulaknyénytakne nak duké yédaran de wani du wale kapéredi mu de yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Du taakwa de makwal baadit Jisaské kure yék, dé derét taaba kutduké. Kure yédaka de Jisasna du véte de derét waatik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Waatidaka dé véte rékaréka yate dé déku duwat wak, “Makwal baadi wunéké deku mé yao. Yaado guné derét waatikaapuk yaké guné yo. Gotna kémba rakwa du taakwa wan wani makwal baadi pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Got némaan ban rate déku du taakwaké miték véké dé yo. Dé waga yadéranké makwal baadi de yéknwun mawulé yo. Makwal baadi yakwa pulak, du taakwa dé deké miték védéranké yéknwun mawulé yadaran de déku kémba yaalaké de yo. Makwal baadi yadakwa pulak yéknwun mawulé yakaapuk yakwa du taakwa de déku kémba yaalakaapuk yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naate watakne dé baadit nak nak kérae kusawuréte taabat kutte dé wak, “Got gunat kutkalé yaké dé yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas tépa yaabuba yéké yadéka dé du nak déké ye dé déké kwati yaane waadé daak. Daate dé wak, “Méné yéknwun du rate méné Gotna jébaaké naanat yakwatnyu. Méné mé wakwe. Samu mu ye wuné kulé mawulé kérae apuba apuba miték rasaakuké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Naate wadéka dé Jisas wak, “Samuké méné wunat ‘Yéknwun du’ wo? Got kapmu dé yéknwun ban dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Got wakwedéka Moses wakwen kéni apa kudi méné kutdéngék: Du taakwat viyaapérekmarék yaké méné yo. Méné nak duna taakwa wale kapéredi mu yakaapuk yaké méné yo. Sél yakaapuk yaké méné yo. Nak duké yénaa kudi wakwekaapuk yaké méné yo. Yénaa yate nak duna gwalmu kéraakaapuk yaké méné yo. Méné ména néwepat kutkalé yaké méné yo. Moses wani kudi wakwedéka méné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naate wadéka dé wak, “Némaan du, wuné baadi rawurén tulé wani apa kudi wuné véknwuk. Kéni tulé wawo wuné véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naate wadéka dé déké mawulat kapére yate dé wak, “Méné nak mu wawo yaké méné yo. Méné taknaménén akwi gwalmu nak duké kwayétakne yéwaa nyégéle méné yéwaa yakaapuk du taakwaké kwayéké méné yo. Kwayéménu Got ménat kutkalé yadu kukba méné Gotna gayét ye waba miték male rasaakuké méné yo. Méné yéwaa yakaapuk du taakwaké yéwaa kwayétakne gwaamale yae wuna jébaaba yaalaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Waga wadéka wani kudi véknwudéka déku mawulé kapére dé yak, dé wupmalemu yéwaa ye nak duké kwayémuké kélik yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wani du yédéka Jisas déku duwat véte dé wak, “Wupmalemu gwalmu yan du taakwa kwekére ye de Gotna kémba yaalakaapuk yaké de yo. De apa ye Gotna kémba yaalaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naate wadéka de déku kudi véknwute de kwagénék. Kwagéndaka dé wak, “Gunawa, mé véknwu. Du taakwa apa ye Gotna kémba yaalaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Apakélé bulmakawu nak baapmu wut kétaapadakwa raaményna yaabuba wulaaké mawulé yadéran apa yaké dé yo. Wupmalemu gwalmu yan du taakwa Gotna kémba yaalaké mawulé yate apat kapére yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naate wadéka de kwagénte deku kapmu bulte de wak, “Aki. Wupmalemu gwalmu yan du taakwa Gotna kémba wulaaké nae apat kapére yadaran yaga pulak gwalmu yakaapuk yakwa du taakwa Gotna kémba wulae miték rasaakuké de yo apuba apuba? Wan kaapuk. Gotna kémba wulaaké de yapatiké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Naate wadaka dé wak, “Du taakwa deku kapmu apa yate, de Gotna kémba yaale miték rasaakuké de yapatiyu. Got kapmu wani muké dé apa yo. Got akwi mu yaké dé apa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wani kudi wadéka dé Pita wak, “Mé véknwu. Naana akwi gwalmu kulaknyénytakne naané ména jébaa yate méné wale yeyé yeyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Naate wadéka dé wak, “Wan adél. Wunéké miték sanévéknwukwa du taakwa Gotna kudi wakweké nae de deku ga, némaadugu wayéknaje, nyangegu kayégu, néwaa yaapa, baadi, képmaa kulaknyénydaran Got bulaa derét kutkalé yadu de wupmalemu ga, némaadugu wayéknaje, nyangegu kayégu, néwaa, baadi, képmaa wawo kéraaké de yo. De wuna kudi wakwedo du las derét yaalébaanké de yo. Kukba de miték rasaakuké de yo apuba apuba. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kéni kudi wawo mé véknwu. Bulaa rakwa wupmalemu némaan du taakwa kukba bakna du taakwa raké de yo. Bulaa bakna rakwa wupmalemu du taakwa de kukba némaan du taakwa raké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kukba Jisas déku du wale waga de Jerusalemét yék. Dé yaabuba taale yédéka véte kwagénte de déku du wak, “Aki. Wani gayét yéte dé wup kaapuk yadékwa.” Naate wadaka de deku kukba yékwa du taakwa dérét véte de wup yak. Yaabuba yéte Jisas déku duwat male dé kudi wakwek, déké yaaran muké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Dé wak, “Mé véknwu. Bulaa Jerusalemét naané waaru. Waaréno de Akwi Du Taakwana Nyaan wunat kérae nyédé duna némaan du, apa kudiké kutdéngkwa du wawo deku taababa wunat taknaké de yo. Taknado de wunat viyaapérekdoké waké de yo. Wado nak gena du wunat kéraaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kérae wunat wasélékte wunat sépmeny sévaavite raamény baagwit viyaatakne wunat viyaapérekgé de yo. Yado kiyaawuru nyaa kupuk yédu tépa nébéle raapké wuné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jisas waga wadéka Sebedina nyaan vétik Jems bét Jon bét déké yék. Ye bét wak, “Némaan du, watéran pulak anéké yaménuké ané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naate wabétka dé wak, “Samu yawuruké béné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Naate wadéka bét wak, “Kukba méné apat kapére yate du taakwaké némaan ban rate méné waménu ané nak ména yéknwun tuwa taababa, nak ména aki tuwa taababa raké ané yo. Ané waba rate nak du taakwaké némaan du raké ané yo. Waga ané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naate wabétka dé wak, “Béné wunat waatabénékwa muké kaapuk kutdéngbénén. Wunat kapéredi mu yaké de yo. Wuné apakélé kaagél kutké wuné yo. Béné wani kapéredi muké apa yaké béné yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Naate wadéka bét wak, “Ao. Waga yaké ané apa yo.” Naate wabétka dé wak, “Kapéredi mu wunat yadaran pulak bénat yaké de yo. Kaagél kutwuréran pulak béné kaagél kutké béné yo. Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kukba kiyadé wuna yéknwun tuwa taaba, kiyadé wuna aki tuwa taababa raké yo? Wuné wani muké wakaapuk yaké wuné yo. Wan wuna kudi kaapuk. Waba raran duké Got déknyényba déku mawuléba débu wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wani kudi wadéka de Jisasna du taaba vétik wani muké véknwute de Jems bét Jonét rékaréka yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yadaka dé Jisas waadéka yaadaka dé derét wak, “Guné kutdéngék. Nak gena némaan du de du taakwaké apa yate de wo, deku kudi miték véknwute deku jébaa yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Guné de yakwa pulak yakaapuk yaké guné yo. Guné wale rakwa du nak Gotna méniba némaan ban raké mawulé yadéran, dé guna jébaa yakwa du raké dé yo. Rate dé guna kudi véknwute wagunékwa pulak yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wuné Akwi Du Taakwana Nyaan waga wuné yo. Nak du taakwaké jébaa yate derét kutkalé yaké wuné yaak. Du taakwa wunéké jébaa yadaranké sanévéknwukaapuk yate wuné yaak. Wuné kiyae wupmalemu du taakwat Setenna taababa kéraawuru de Got wale miték rasaakudoké wuné yaak.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kukba Jisas déku du wale Jerikot de yék. Ye saabe Jeriko kulaknyénytakne de wupmalemu du taakwa wale de yaabuba yék. Yédaka dé méni kiyaan du nak yaabuba rate dé du taakwat yéwaaké yaawik. Wani du wan Timiasna nyaan Batimias. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yaawite dé kudi véknwuk Nasaret ban Jisas yédéka. Véknwute dé Jisasnyét waate dé wak, “Ménawa, Devitna képmawaara. Méné Devit pulak némaan ban rate wunéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Naate wadéka wupmalemu du taakwa dérét waatite de wak, “Akélak mé ra.” Naate wadaka dé kaapuk akélak radén. Tépa waate dé wak, “Némaan Ban, Devitna képmawaara, wunéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Naate wadéka Jisas véknwutakne yaabuba téte dé wak, “Wani dut mé wakwe wunéké yaadu.” Naate wadéka de méni kiyaan dut wak, “Jisas dé wo, déké yéménuké. Méné mé raap. Yéknwun mawulé yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naate wadaka dé yépmaa yadéka saapme radén baapmu wut yasétakne dé raapme yék Jisaské. ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ye saabadéka dé dérét waatak, “Ménat samu yawuruké méné mawulé yo?” Naate waatadéka dé méni kiyaan du wak, “Némaan du, méni tépa véké wuné mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Naate wadéka dé wak, “Méné bulaa yéké méné yo. Ménat kutnébulwuréran apaké miték sanévéknwuménék bulaa ména méni yéknwun dé yo.” Naate wadéka déku méni bari yéknwun yadéka dé miték vék. Véte dé Jisas wale yaabuba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisas déku du wale de Jerusalemét waarédakwa yaabuba waarék. Waaréte Betpasi tédéka Betani wawo tédéka de vék. Wani gayé vétik Oliv nébuba bét tu. Jerusalem tékwaba bét tu. Véte saabaké yate Jisas dé déku du vétiknét wak, “Béné wani gayét wulae béné véké yo donki nyaanét nak. Miba lékitaknadak dé tu. Déknyényba du déku butgulba kaapuk radén. Béné dérét lépmwénye béné kure yaaké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yabénu du nak bénat kéga waatadéran, ‘Samu yaké béné wani donki nyaan lépmwényék?’ Naate wadéran béné kéga waké béné yo, ‘Némaan Ban dé wani donkiké mawulé yo. Dé bari kwayésatiké dé yo.’ Waga béné dérét waké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wani kudi véknwutakne bét ye bét vék donki ga maaknaba miba lékitaknadaka yaabuba tédéka. Vétakne bét wani donkina baagwi lépmwényék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lépmwénybétka de du las waba téte de wak, “Wani donki nyaan lépmwénye samu yaké béné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","7","Naate waatadaka bét Jisas wakwen pulak wakwek. Wakwebétka de kusékétdaka bét donki nyaan kure yék Jisaské. Ye bét bétku baapmu wut las donkina butgulba bét akutaknak. Akutaknabétka dé Jisas waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Rate yédéka de wupmalemu du taakwa baapmu wut las de yaabuba taknate de yaabu kusok. Yadaka du las de tépmaa tu pulak mu yaabuba taknate de yaabu kusok. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yatakne de du taakwa baadi las taale yédaka de las Jisasna kukba yéte némaanba de waak: Némaan Ban Got wadék dé yao. Wan yéknwun. Got dérét kutkalé yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Naana képmawaara Devit déknyényba némaan ban radén pulak, dé némaan ban rate naanéké miték véké dé yo. Némaan ban radéran tulé bari dé yao. Wan yéknwun. Awuréba rakwa ban Gotna yéba kevérékgé naané yo. Naate de waak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Waadaka Jisas dé Jerusalemét wulaak. Wulae dé Gotna kudi buldakwa némaa gat wulaak. Wulae dé akwi gwalmat vék. Vétakne nyaa dawuliké yadéka dé wani tulé jébaa yamuké kélik yate déku du wale Jerusalem kulaknyénytakne de Betanit tépa yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jisas Betaniba kwae ganbaba dé Jerusalemét gwaamale yéké nae yaabuba yédéka dé dérét kaadé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yadéka yéte dé vék yéknwun sék akukwa mi nak apa séknaaba tédéka. Wupmalemu gaga wani miba tédéka véte déku mawuléba dé wak, “Wupmalemu gaga tédéka sék dé akuk. Las géle kaké wunék.” Naate watakne dé wani misék géle kaké yék. Ye wani misék las akwe tédéka kaapuk védén. Wani misék akukwa tulé wekna kaapuk yaan. Gaga male tédéka dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Véte dé wak, “Du taakwa kéni miba tépa sék géle kakaapuk yaké de yo.” Naate wadéka déku du de déku kudi véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas déku du wale de Jerusalemét yék. Ye saabe dé Gotna kudi buldakwa némaa gat wulae dé vék du las gwalmu kwayéte yéwaa nyégéldaka. Vétakne dé derét kélésalak. Kélésalate dé nak gena yéwaa nyégélte wani gayéna yéwaa kwayékwa duna jaabé takugérutnyék. Yate dé viyae Gotké kwayédaran api kwayékwa du ran mi tabé takubalaakuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yate dé derét wak, “Guné kéni gaba gwalmu las kérae kure yeyé yeyakaapuk yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naate watakne dé wak, “Kéni kudi Gotna nyégaba dé kwao: Got dé wak, ‘Akwi képmaaba yaan du taakwa wuna gat yaale wuné wale kudi bulké de yo.’ Naate dé Got wak. Wani kudiké guné kaapuk sanévéknwugunékwa. Guné kéni gaba Got wale kudi kaapuk bulgunékwa. Guné gwalmu kwayéte yéwaa nyégélgunéka kéni ga kén sél yakwa du paakwe rakwa ga pulak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Naate wadéka de akwi du taakwa déku kudi véknwute de kwagénék. Kwagéndaka de nyédé duna némaan du, apa kudiké kutdéngkwa du wawo de wani muké kudi véknwuk. Véknwute wup de yak Jisaské. Wup yate de wak, “Yaga pulak dérét viyaapérekgé naané yo, wupmalemu du taakwa déku kudi véknwute mawulé yate kwagéndakwa bege?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nyaa dawulidéka Jisas déku du wale de Jerusalem kulaknyénytakne de tépa yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nak gayéba kwae ganbaba raapme Jisas déku du wale Jerusalemét gwaamale yéte de vék wani mi rékaa ye tédéka. Gaga, apa, mégi wawo, akwi dé rékaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yadéka Pita vétakne dé Jisas wadén kudiké sanévéknwute dé dérét wak, “Némaan du, mé vé. Wani mi débu rékaa yak. Nalé méné wani miké méné wak, ‘Du taakwa kéni miba tépa sék géle kakaapuk yaké de yo.’ Naate waménék bulaa débu rékaa yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Dé waga wadéka Jisas dé derét wak, “Gunat wuné wakweyo. Guné Gotké miték sanévéknwute mawulé vétik yakaapuk yate kéga wagunéran, ‘Got wuna kudi véknwuké dé yo.’ Naate wagunéran guné kéni nébu ye kusba dawuliduké wagunu dé ye kusba dawuliké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wani muké sanévéknwute gunat wuné wakweyo. Guné Gorét waatate dé waatagunéran pulak gunéké apa yaduké guna mawuléba wagunéran guné dérét waatagunu dé gunéké waga yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Guné Got wale kudi bulte téte yéknwun mawulé yaké guné yo. Nak du taakwa gunat kapéredi mu yadaran guné yadan kapéredi muké tépa sanévéknwukaapuk yaké guné yo. Waga yagunéran awuréba rakwa ban guna yaapa Got yagunén kapéredi mu yatnyéputiye dé wani muké tépa sanévéknwukaapuk yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Guné nak du taakwa gunat yadan kapéredi muké wekna sanévéknwute derét yakataké mawulé yagunéran awuréba rakwa ban guna yaapa Got yagunén kapéredi muké wekna sanévéknwute dé wani kapéredi mu yatnyéputikaapuk yate gunat yakataké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas déku du wale de tépa gwaamale yék Jerusalemét. Ye saabe dé Gotna kudi buldakwa némaa gat tépa wulaak. Wulae yeyé yeyadéka de nyédé duna némaan du, apa kudiké kutdéngkwa du, kubu du, waga de déké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ye de dérét wak, “Samu apa kérae méné wani jébaa yo? Kiyadé wak méné wani jébaa yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Naate wadaka dé derét wak, “Wuné wawo nak kudi gunat waataké wuné yo. Waatawuru guné wuna kudi kaatagunéran wuné guna kudi kaataké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Guné mé wakwe. Kiyadé Jonét wak dé du taakwat gu yaakutaknak? Got dé waga wak, kapu képmaaba rakwa du dé nak waga wak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naate waatadéka de deku kapmu bulte waarute de wak, “Naané kéga wanaran, ‘Got dé waga wak.’ Naate wanaran dé naanat kéga waké dé yo, ‘Samuké guné déku kudi kaapuk véknwugunén?’ ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sal naané kéga waké naané yo? ‘Képmaaba rakwa du dé nak wak.’ Naate wakaapuk yaké naané yo, du taakwaké wup yanakwa bege. Wupmalemu du taakwa de Jonké wo, ‘Gotna yéba kudi wakwen du nak. Wan adél.’ Naate de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Waga bultakne de yénaa yate Jisasnyét wak, “Naané las kaapuk kutdéngnan. Wani muké wakwekaapuk yaké naané yo.” Naate wadaka dé derét wak, “Wuné wawo wunat wadék yae kéni jébaa yawurékwa banké wakwekaapuk yaké wuné yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas dé kéni aja kudi derét wakwek: “Du nak dé wain mi tékwa yaawi nak yak. Raatmu gitakne dé wain mi tawuk. Tawutakne dé kukba wain gu kérae kaké nae wain sék guriksade akibésdaran waagu dé matuba vaak. Vaatakne dé yaawiké téségédaran sémény ga dé nak kaak. Yawurétakne dé wani yaawiké téségéte yaawiba jébaa yate yéwaa nyégélké mawulé yan duké dé kwayék. Kwayétakne dé nak képmaat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Misék gélédaran tulé yaadéka dé dé wale rate jébaa yakwa dut nak wak, dé déku yaawit yéduké. Dé misék las kwayédo kure yaaduké dé mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yate wadéka déku du yédéka de yaawiké téségékwa du dérét viyaak. Viyaate de dérét wak, dé misék kéraakaapuk ye bakna yédoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wadaka yaawina bapaduké gwaamale yédéka dé déku dut nak wawo wadéka dé deké yék. Yédéka de déku maaknaba viyaate de dérét kapéredi mu yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yadaka dé yaawina bapadu déku jébaa yakwa dut nak wawo wadéka dé yék. Yédéka de dérét viyaapéreknék. Yadaka dé bapadu duwat las wawo wadéka de yék. Yédaka de derét las viyaate lasnyét de viyaapéreknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yadaka kukba dé yaapa déku mawuléba dé wak, ‘Wuna nyaan male dé ro. Déké wuné mawulat kapére yo. Déku kudi véknwuké de yo.’ Naate watakne dé déku nyaanét wadéka dé yaawiké téségékwa duké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yédéka de yaawiké téségékwa du dérét véte de deku kapmu kudi bulék. Bulte de kéga wak, ‘Yaawina bapadu kiyaadu wani nyaan déku yaapana akwi gwalmu kéraaké dé yo. Naané dérét viyaapérektakne kéni yaawi kéraaké naané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Waga watakne de dérét kure viyaapéreknék. Viyaapérektakne de déku gaaba ségwi kérae yaawi kulaknyénytakne kaapat yatjagwadék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas waga watakne dé derét wak, “Guné yaga guné sanévéknwu? Yaawina bapadu yae yaawiké téségén duwat yaga pulak yaké dé yo? Dé yae wani duwat viyaapérekgé dé yo. Viyaapérekne nak duké wani yaawi kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Viyaapérekdan nyaanké kéni kudi Gotna nyégaba dé kwao: Ga kaakwa du yéknwun matuké sékalte nakurak matuké kélik yadaka dé bakna rak. Radéka Némaan Ban Got wani matut véte dé wak, ‘Wan yéknwun matu. Wani matu radu ga miték kwaaké dé yo.’ Naate watakne wani matu kérae taknadéka dé ga miték kwaak. Kwaadéka naané véte naané yéknwun mawulé yo. Wani kudi Gotna nyégaba vétakne guné kaapuk miték sanévéknwugunékwa.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wani kudi wadéka de némaan du de kutdéngék. Jisas deké dé wani kudi wakwek. Waga kutdéngte de wak, “Naané dérét kure raamény gaba taknaké naané yo.” Naate watakne de dérét kaapuk kutdan, du taakwa derét waatimuké wup yadan bege. Yate de dérét kulaknyénytakne de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Némaan du las deku kapmu bulte de wak, “Naané Jisasnyét kés mu nak muké waatanaran sal dé kapéredi kudi kaataké dé yo, kapu kaapuk? Dé kapéredi kudi wadéran naané dérét kure raamény gaba taknaké naané yo.” Naate wate de Parisina du las, Yerotna du wawo derét wadaka de Jisaské yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ye de dérét wak, “Némaan du, méné Gotna jébaaké derét méné yakwatnyu. Méné adél kudi male wakwete derét Gotna kudiké miték méné yakwatnyu. Méné nakurak kudi male méné wakweyo, némaan du taakwa, bakna du taakwat wawo. Méné deké wup kaapuk yaménékwa. Waga naané kutdéngék. Méné waga yate bulaa méné naanat mé wakwe. Yaga méné sanévéknwu? Naana apa kudi yaga dé wo? Naané takis Romna némaan banké kwayéké naané yo, kapu kaapuk? ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Naané takis kwayénaran wan yéknwun, kapu kaapuk?” Naate wadaka dé Jisas deku mawulé dé kutdéngék. De deku mawuléba kéga de wak, “Bulaa dé kapéredi kudi wadu naané dérét kure raamény gaba taknaké naané yo.” Naate wadaka Jisas kutdéngte dé derét wak, “Guné yénaa yakwa du guné. Samuké nae guné wunat waga waato? Guné wunéké yéwaa nak mé kure yaa véwuru.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naate wadéka de déké yéwaa nak kure yék. Kure yédaka dé wak, “Kéni yéwaaba kwaakwa nyaap wan kiyadéna nyaap? Kiyadéna yé de kéni yéwaaba kavik?” Naate waatadéka de wak, “Wan Romna némaan bannan.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naate wadaka dé derét wak, “Wan adél. Romna némaan banna mu guné déké kwayéké guné yo. Gotna mu guné Gotké kwayéké guné yo.” Naate wadéka de wani kudi véknwute déké kwagénte de sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusina du deku mawuléba de kéga wak, “Kiyaan du taakwa tépa nébéle raapkaapuk yaké de yo.” Naate de wak. De las Jisaské ye de dérét kéga wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Némaan du, méné du taakwat Gotna jébaaké méné yakwatnyu. Méné kéni muké naanat mé wakwe. Déknyényba Moses kéga dé kavik: Némaadu taakwa ye nyaan kéraakaapuk ye kiyaadu déku taakwa raléran déku wayékna wani taakwa yaké dé yo. Yadu nyaan kéraalu wani nyaanké waké de yo, ‘Némaaduna nyaan.’ Naate waké de yo. Waga dé Moses kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bulaa mé véknwu. Déknyényba némaadugu wayéknaje nak taaba sékét nak taababa kayék vétik de rak. Némaadu taakwa ye baadi kéraakaapuk ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kiyaadéka déku wayékna wani taakwa ye baadi kéraakaapuk ye, dé wawo kiyaak. Kiyaadéka nak wayékna wani taakwa ye baadi kéraakaapuk ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kiyaadéka akwi wayéknaje waga male ye de akwi baadi kéraakaapuk ye de kiyaak. Yadaka kukba lé wani taakwa kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bulaa naanat mé wakwe. Kiyaan du taakwa nébéle raapdaran tuléké méné wakweyo. Wani tulé wani taakwa kiyadé wale raké lé yo? Déknyényba wani némaadugu wayéknaje akwi de lérét yak.” Naate de Sadyusina du Jisasnyét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas deku kudi véknwute dé derét wak, “Guné Gotna nyégaba kwaakwa kudi las kaapuk kutdénggunén. Kutdéngkaapuk yate Gotna apaké wawo kaapuk kutdénggunén. Yagunéka guna mawulé sépélak dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mé véknwu. Kukba Got wadu kiyaan du taakwa nébéle raapme de Gotna gayéba rate déku kudi kure giyaakwa du pulak raké de yo. Rate du de taakwa yakaapuk yaké de yo. Taakwa de du rakaapuk yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kudi las wawo wakweké wunék, kiyaan du taakwa nébéle raapdaranké. Déknyényba makwal mi nak yaa yaandéka dé Moses téte védéka dé Got dérét kudi wakwek. Wakwedén kudi Moses Gotna nyégaba kéga dé kavik: Wuné Ebrayamna némaan ban. Wuné Aisakna némaan ban. Wuné Jekopna némaan ban. Wuné deku némaan ban Got wuné ro. Waga kavidéka guné wani kudi déku nyégaba vétakne guné kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wani kudiké sanévéknwute naané kutdéngék. Dé kiyaan duna némaan ban kaapuk radékwa. Wani du déknyényba de kiyaak. Taale de kiyaak. Kukba Got dé wani kudi wak. De kiyae tépa nébéle raapme radaka dé Got wani kudi wak. Got kiyae nébéle raapme rakwa duna némaan ban dé ro. Got wan kulé rakwa duna némaan ban. Waga naané kutdéngék. Guné nak kudi wagunéka guna mawulé sépélak dé yo.” Naate dé Sadyusina duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","De kudi buldaka dé apa kudiké kutdéngkwa du nak dé waba téte dé véknwuk. Véknwudéka Jisas Sadyusina kudi miték kaatadéka dé véknwutakne yae dé Jisasnyét waatak, “Naana apa kudiba samu némaa kudi dé akwi némaa kudit talaknak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Naate waatadéka dé Jisas wak, “Kéni kudi dé akwi némaa kudit talaknak: Isrelna du taakwa, guné mé véknwu. Naana Némaan Ban Got wan nakurak male. Dé kapmu némaan ban dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guné guna Némaan Ban Gotké mawulat kapére yaké guné yo. Yate guné dérét wagunu dé guna mawulé, guna wuraanyan, guna yaamabi, guna apaké dé némaan ban raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nak némaa kudi kéga: Guné guna sépéké mawulat kapére yagunékwa pulak, nak du taakwaké mawulat kapére yaké guné yo. Yate derét kutkalé yaké guné yo. Wani kudi vétik wan némaa kudi. Akwi némaa kudit débu talaknak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dé waga wadéka dé wak, “Némaan du, méné miték ménébu wakwek. Naana Némaan Ban Got dé kapmu naana némaan ban dé ro. Nak némaan ban kaapuk. Méné adél kudi ménébu wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wakweménén pulak, du taakwa Gotké mawulat kapére yaké de yo. Yate de dérét wadu dé deku mawulé, deku wuraanyan, deku yaamabi, deku apaké dé némaan ban raké dé yo. Radu de deku sépéké mawulat kapére yadakwa pulak, de nak du taakwaké mawulat kapére yaké de yo. Naané wani kudi vétik véknwute naané miték yaké naané yo. Wani kudi vétik déknyényba wakwedan kudit débu talaknak. Déknyényba wadaka naané kwaami viyae matu jaabéba tuwe naané Gotké kwayék. Kadému wawo naané Gotké kwayék. Ména kudi Gotké kwaami kadému kwayénakwa kudit dé talaknak. Wakweménén kudi wan némaa kudi.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wani du miték sanévéknwute dé waga wak. Wadéka dé Jisas véknwute dé dérét wak, “Sal walkamu re méné Gotna kémba yaalaké méné yo?” Naate wadéka de nak kudi Jisasnyét waatamuké de wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas Gotna kudi buldakwa némaa gaba kudi wakwete dé derét wak, “Apa kudiké kutdéngkwa du de wo, ‘Got wadén ban Krais wan Devitna képmawaara.’ Samuké de waga wo? ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Déknyényba Krais kéni képmaaba rakaapuk yadéka Gotna Yaamabi Devitna mawuléba wulae tédéka Devit dé Kraiské kéga wak, ‘Wuna Némaan Ban.’ Naate wate dé kéga wak: Némaan Ban Got wuna Némaan Banét dé wak, ‘Méné némaan ban rate wuna yéknwun tuwa taababa raké méné yo. Raménu wuné wawuru ména maama ména taababa raké de yo. Rado méné némaan ban rate deké véké méné yo.’ Naate dé Got wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit wani kudi wakwete dé Kraiské ‘Wuna Némaan Ban’ dé naak. Samuké dé Devit Kraiské waga wak? Devit Got wadén ban Kraiské ‘Wuna Némaan Ban’ naadéka yaga pulak dé Krais Devitna képmawaara ro? Krais Devitna képmawaara rate Devitna némaan ban wawo dé ro, kapu yaga pulak?” Waga Jisas wadéka de wupmalemu du béré taakwa béré déku kudi véknwute de déké yéknwun mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas kéni kudi wawo dé derét wakwek: “Guné apa kudiké kutdéngkwa duké jérawu yaké guné yo. De sémény baapmu wut kusadatakne du taakwa jawudakwa taaléba yeyé yeyaké de mawulé yo. Yeyé yeyate du taakwa derét véte kéga wadoké de mawulé yo: ‘Wan naana némaan du dewa yaakwa.’ Naate wadoké de mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","De Gotna kudi bulnakwa gat wulae de némaan duna taaléba raké de mawulé yo. De wupmalemu du wale kadému kate de yéknwun taaléké sékalte du taakwana méniba raké de mawulé yo, de véte deku yéba kevérékdoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","De dukiyaataakwana gwalmu akwi de kérao. De yénaa yate némaa kudi Gorét wakweyo, nak du derét véte deku yéba kevérékdoké. Yadakwaké Got wadu apakélé kapéredi mu deké yaaké dé yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas Gotna kudi buldakwa némaa gaba rate dé vék wupmalemu du taakwa Gotké yéwaa kwayédaka. Wupmalemu gwalmu yan wupmalemu du taakwa apakélé yéwaa kwayédaka dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Védéka gwalmu yakaapuk dukiyaataakwa nak yae makwal yéwaa vétik Gotké kwayéléka dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Véte déku duwat waatakne dé derét wak, “Wupmalemu gwalmu yan du taakwa de Gotké yéwaa las de kwayék. Kwayédaka deku yéwaa las wawo dé ro gaba. Wani taakwa makwal yéwaa vétik kwayéte lé kure ralén yéwaa akwi lé kwayék. Kwayétakne lé kadému kéraaléran yéwaa kaapuk. Gotké kwayélékwa yéknwun paaté kwayédakwa paatat débu talaknak. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas Gotna kudi buldakwa némaa ga kulaknyényké yadéka déku du dé nak dérét wak, “Némaan du, kéni yéknwun ga mé vé. Yéknwun matut male de yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Naate wadéka dé Jisas dérét wak, “Ao, bulaa wan yéknwun ga. Yéknwun matut yadaka naané vu. Kukba du yae kéni ga akwi yaalébaanké de yo. Yaalébaante de kéni matu kérae yatjadado kéni matu nak matuba kwaakaapuk yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Wani kudi watakne Jisas wani ga kulaknyénytakne ye dé Oliv nébat waarék. Waare rate dé Gotna kudi buldakwa némaa gat vék. Védéka de déku du Pita, Jems, Jon, Andru, de male déké ye de dérét wak, “Naanat mé wakwe. Yani nyaa Gotna ga yaalébaanké de yo? Samu mu taale yaadu vétakne naané kéga waké naané yo? ‘Bulaa wani kapéredi mu yaaké dé yo.’ Yani nyaa naané waga waké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Naate waatadaka dé wak, “Guné jérawu yaké guné yo. Yate yénaa yakwa duna kudi véknwukaapuk yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wupmalemu du yae wuna yéba wakwete yénaa yate nak nak kéga waké de yo, ‘Wuné Got wadén ban Krais wuné.’ Naate wado wupmalemu du taakwa yénaa yadan kudi véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wupmalemu du waariyaké de yo. Waariyado nak du waariyadakwaké kudi bulké de yo. Yado véknwute guné wup yakaapuk yaké guné yo. Taale waga yaké de yo. Sésékukba yaaran tulé kukba yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nak képmaaba rakwa du taakwa de nak képmaaba rakwa du taakwa wale waariyaké de yo. Nak némaan banna kém nak némaan banna kém wale waariyaké de yo. Wupmalemu képmaaba wupmalemu apu anyék kutké lé yo. Du taakwa kaadé wale re kiyaaké de yo. Wani kapéredi mu wan taakwa nyaan batnyé kéraaké yate kaagél kutdakwa pulak. Wani taakwa kaagél las wawo kutdaran pulak, kukba kapéredi mu las wawo yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Guné jérawu yaké guné yo. Guné wuna du ragunékwaké du las wuna jébaaké kélik yate gunat kulékiye gunat kotimké de yo. Gotna kudi buldakwa gaba gunat viyaaké de yo. Gunat kure yédo guné deku némaan duna méniba téké guné yo, wuna jébaa kutgunékwa bege. Téte guné wuna kudi derét wakweké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wuna du taakwa taale de akwi képmaaba rakwa du taakwat wuna kudi wakweké de yo. Wakwedo sésékukba yaaran tulé yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gunat kure kotimdo guné taale guna mawuléba kéga wakaapuk yaké guné yo, ‘Naané deku kudi yaga pulak kaataké naané yo?’ Naate wakaapuk yaké guné yo, wani tulé Gotna Yaamabi wakwegunéran kudi gunéké kwayédéran bege. Gotna Yaamabi guna mawuléba téte gunat kudi wakweké dé yo. Wakwedu guné véknwute wani kudi derét wakweké guné yo. Guna mawuléba sanévéknwute kudi wakwemarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wani kapéredi tulé wupmalemu du deku némaadugu wayéknajet kotimdo de némaadugu wayéknajet viyaapérekgé de yo. Yaapa deku baadit kotimdo de wani baadit viyaapérekgé de yo. Baadi wawo deku néwepat kotimdo de néwepat viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Guné wuna du ragunékwaké akwi du taakwa gunéké kélik yaké de yo. Wani muké wup yakaapuk yaké guné yo. Deku mawuléba apa yate wuna jébaa kutsaakuran du taakwat Got kéraadu de dé wale apuba apuba miték rasaakuké de yo. Yalakmarék yaké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Guné kéni nyégaba véte kéni muké miték sanévéknwuké guné yo. Wani kudi watakne dé Jisas kéga wakwek: “Déknyényba Gotna yéba kudi wakwen du nak dé kéni kudi kavik: Kukba du nak yae Gotna kudi buldakwa némaa gaba Got waatidén mu nak taknaké dé yo. Taknadu de wani gaké ‘Kapéredi ga’ naaké de yo. Waga kavidén mu yaaladu guné véké guné yo. Véte wani tulé guné Judiaba rakwa du taakwa guna gayé kulaknyénytakne nébat bari yaage yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wani tulé kaapaba rakwa du taakwa bari yaage yéké de yo. Deku gwalmu kéraaké deku gat tépa wulaakaapuk yaké de yo. Bakna yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yaawiba tékwa du taakwa gayét gwaamale ye baapmu wut las wawo kéraakaapuk yaké de yo. Bari yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wani kapéredi tulé nyaan tékwa taakwa, baadiké munyaa kwayékwa taakwa bari yaage yéké yapatiké de yo. Deké wuné mawulé léknu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wani kapéredi tulé maas viyaakwa tuléba yaadéran yaga pulak guné bari yaage yéké guné yo? Yégunéranké sanévéknwute guné Gorét waataké guné yo, maas viyaakwa tuléba wani kapéredi tulé yaakaapuk yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wani tulé wupmalemu kapéredi mu yaaké dé yo. Wani kapéredi mu akwi kapéredi mat talaknaké de yo. Déknyényba Got akwi mu kuttaknadén tulé waga pulak kapéredi mu las kaapuk yaan. Bulaa wawo kukba wawo waga pulak kapéredi mu tépa yaakaapuk yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wani kapéredi mu yaadu Got déku du taakwaké mawulé lékte wadu wani kapéredi mu bari kaapuk yaké dé yo. Waga wakaapuk yadu mukatik akwi du taakwa kiyaado. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wani tulé du las gunat kéga wadaran, ‘Kéni dut mé vé. Kén Got wadén ban Krais.’ Naate wadaran guné deku kudi véknwukaapuk yaké guné yo. De kéga wadaran, ‘Wani dut mé vé. Wan Got wadén ban Krais waba dé ro.’ Naate wadaran guné deku kudi véknwukaapuk yaké guné yo. De yénaa de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wupmalemu du yae Gotna du taakwat yénaa yate nak nak kéga waké de yo, ‘Wuné Got wadén ban Krais wuné.’ Waga wado las yénaa yate nak nak kéga waké de yo, ‘Wuné Gotna yéba kudi wakwekwa du wuné.’ Naate watakne de yénaa taknate kés pulak nak pulak apa jébaa, déknyényba vékaapuk yagunén apa jébaa wawo yaké de yo. Guna mawulé yaalébaanké de waga yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Guné jérawu yaké guné yo. Gunat wunébu wakwek, kukba yaaran muké. Kukba wani mu yaadu guné véte kutdéngte guné deku kudi véknwukaapuk yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wani kudi watakne dé Jisas kéga wakwek: “Wani kapéredi mu yédu bari nyaa vékaapuk yadu gaan yaké dé yo. Yadu baapmu wawo vékaapuk yaké lé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yalu akwi kun nyétba akéréké de yo. Akérédo nyétba tékwa akwi mu ségénte yeyé yeyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yado kéni képmaaba rakwa du taakwa de Akwi Du Taakwana Nyaan wunat véké de yo. Wuné apat kapére yate nyaa vékwa pulak yate buwiba rate giyaawuru véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Védo wuné wawuru wuna kudi kure giyaakwa du akwi képmaaba tékwa gege gayét ye wuna du taakwat kure yéte nakurakba taknaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wani kudi watakne dé Jisas kéga wakwek: “Miké miték mé sanévéknwu. Mi las gaga périye kwény lépidéka véte guné kutdéngék. Kadému naaré yakwa tulé bulaa dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wani mit véte tuléké kutdénggunékwa pulak, guné wakwewurén mu véte kutdéngké guné yo. Wuné bari bari gwaamale yaké wuné yo. Waga kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gunat wuné wakweyo. Bulaa rakwa du taakwa las kiyaakaapuk yate wekna rate wakwewurén akwi mu véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nyét képmaa wawo kaapuk yaké dé yo. Wuna kudi kaapuk yamarék yaké dé yo. Rasaakuké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yani nyaa gwaamale yaaké wuné yo? Kéni képmaaba rakwa du taakwa wani nyaaké kaapuk kutdéngdan. Gotna kudi kure giyaakwa du wawo wani nyaaké kaapuk kutdéngdan. Wuné Gotna nyaan rate wuné wawo las kaapuk kutdéngwurén. Wuna yaapa dé kapmu dé gwaamale yaawuréran nyaaké kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Guné wunéké raségéte miték véké guné yo. Wuné guna Némaan Ban yaawuréran nyaaké kaapuk kutdénggunén. Yate guné wunéké raségéte miték véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Kéni kudiké mé sanévéknwu. Némaan du nak gayét yéké yate taale dé déku jébaa yakwa duké nak nak jébaa kwayék. Kwayétakne dé gwéspétéké téségékwa dut wak, ‘Méné wuna gaké miték téségéké méné yo.’ Naate watakne déku ga kulaknyénytakne dé séknaa gayét yék. Wani du yéknwun jébaa yate gwaamale yaadéranké sanévéknwute miték raségéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Guné wani du pulak jébaa yate miték raségéké guné yo. Guné kaapuk kutdénggunén. Yani nyaa wuné guna némaan ban tépa yaaké wuné yo? Garabu yaaké wuné yo, kapu nyédé gubés yaaké wuné yo? Yé tékgé yadu yaaké wuné yo, kapu ganbaba yaaké wuné yo? Wani muké guné kaapuk kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wuné bari yaaké wuné yo, kapu kaapuk? Yaawuréranké sanévéknwute miték raségéké guné yo. Guné wunéké yékéyaak ye widé kwaamuké guné miték raségéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gunat wakwewurén kudi akwi du taakwat wuné wakweyo. Guné akwi gwaamale yaawuréranké sanévéknwute miték raségéké guné yo.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nyaa vétik yédu yis kutkaapuk yadakwa béret kadaran nyaa yaaké dé yo. Wani nyaa de Juda apakélé kadému sérakne kaké de yo. Wani kadémuké de wo Pasova. Wani tulé de nyédé duna némaan du, apa kudiké kutdéngkwa du wawo de mawulé yak, de akélak ye Jisasnyét kulékiye dérét viyaapérekgé. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yate de wak, “Dérét viyaapérekgé naané yo. Kadému sérakne kanaran nyaa dérét kulékikaapuk yaké naané yo. Bulaa wupmalemu du taakwa wani kadému kaké kéni gayét debu yaak. Bulaa naané Jisasnyét kulékinaran de rékaréka yate naanat némaanba waatiké de yo. De yédo naané dérét kulékiye viyaapérekgé naané yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas dé Betanit yék. Ye saabe dé déknyényba lepéro yan du déku yé Saimonna gaba dé rak. Rate dé wale kadému kadéka lé taakwa nak matut yadan makwal agérap kure yaak. Wani agérapba yéknwun yaama yakwa gu dé ték. Du wani gu kéraaké wupmalemu yéwaa kwayéké dé yo. Wani taakwa yae lé Jisas ranba téte lé agérap pulaapme déku maaknaba wani gu sévik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Séviléka de du las véte deku kapmu bulte de lérét rékaréka yak. Rékaréka yate de wak, “Samuké lé wani gu bakna sévik? ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wani gu wan yéknwun gu. Lé wani gu kwayétakne wupmalemu yéwaa nyégéle gwalmu yakaapuk du taakwaké kwayélu mukatik wan yéknwun.” Naate watakne de lérét waatik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas deku kudiké mawulé yakaapuk yate dé derét wak, “Samuké guné wani taakwat waatiyu? Waga yakaapuk yaké guné yo. Wan yéknwun mu lé yak wunéké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gwalmu yakaapuk du taakwa de guné wale de rasaaku. Rado mawulé yagunéran tulé apuba apuba guné derét kutkalé yaké guné yo. Wuné guné wale rasaakukaapuk yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wani taakwa lé wunat miték lé yak. Wuné kiyaawuru waaguba rémdaranké sanévéknwute lé bulaa wani gu wuna sépéba sévik.” Naate wate dé Juda gaaba ségwi rémké yate yadakwaké dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wakwetakne dé derét kéga wak, “Kukba de wuna kudi akwi képmaaba wakwete kéni taakwa yan muké wawo wakweké de yo. Wakwete léké sanévéknwuké de yo. Adél wuné gunat wakweyo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wani tulé dé Jisasna du nak déku yé Judas Iskariot dé Gotna gaba jébaa yakwa nyédé duna némaan duké yék, Jisasnyét deké kwayéké kudi bulké nae. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Buldéka de déku kudi véknwute dusék yate de mawulé yak. Yate de déké yéwaa las kwayéké de kudi gik. Kudi gidaka dé ye deké Jisasnyét kwayédéran tuléké dé raségék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis kutkaapuk yadakwa béret kadakwa tulé dé yaak. Wani béret batnyé sérakdakwa nyaa de sipsip nyaanét las viyao, Pasova waadakwa tuléna kadémuké. Wani nyaa Jisasna du déké ye de wak, “Yaba ye gwalmu kawu saakérano Pasova waanakwa tuléna kadému rate kaké méné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naate waatadaka dé du vétiknét wak, “Béné ye Jerusalemét wulae gu tékwa awu yaataran dut nak véké béné yo. Véte béné déku kukba yéké béné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ye wulaadéran gat wulaaké béné yo. Wulae wani gana bapadut kéga waké béné yo, ‘Gotna kudiké naanat yakwatnyékwa ban dé ménat kéga dé wo: Wuné wuna du wale Pasova waanakwa tuléna kadému kanaran ga yaba dé tu? Naate dé wo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Waga wabénu dé awuréba tékwa némaa ga nak wakwatnyéké dé yo. Wani gaba kadému kanakwa jaabé, ranakwa mu wawo dé tu. Béné wani gaba kadému kawu saakéraké béné yo naanéké.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naate wadéka bét ye Jerusalemét wulae Jisas wakwen pulak bét vék. Vétakne bét Pasova waanakwa tuléna kadému kawu saakérak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nyaa dawulidéka dé Jisas déku du taaba vétik maanba kayék vétik wale waga de yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yae rate de kadému kak. Kate dé derét wak, “Naané wale rate kakwa du nak wunat wuna maamaké kwayéké dé yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Naate wadéka deku mawulé kapére yadéka kwagénte de nak nak dérét waatak, “Wan wunéké méné wo, kapu kiyadéké méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naate waatadaka dé wak, “Wuna du nak. Wuné wale agérapba tékwa guba béret tawukwa du wunat maamaké kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wuné Akwi Du Taakwana Nyaan kiyaaké wuné yo. Gotna nyégaba kiyaawuréranké déknyényba de kudi kavik. Kiyaawuru kapéredi mu yaaké dé yo, wunat maamaké kwayéran duké. Wani dut déku néwaa kéraakaapuk yalu mukatik wan yéknwun.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","De rate kadému kate dé Jisas béret kérae dé Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayéte dé wak, “Guné kéraaké guné yo. Kén wuna sépé.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naate watakne dé wain gu tén agérap nak kérae dé Gorét wak, “Yéknwun gu ménébu tiyaak. Wan yéknwun.” Naate watakne deké kwayédéka de kak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kadaka dé derét wak, “Kén wuna wény. De wunat viyaapérekdo wuna wény akudu guné véte kutdéngké guné yo, Got du taakwat kutkalé yaké wakwedén kudi adél yadéranké. Wuné kiyae wupmalemu du taakwat kutkalé yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gunat wuné wakweyo. Kéni képmaaba wekna rate wuné wain gu tépa kakaapuk yaké wuné yo. Kukba wuna yaapa Got du taakwaké némaan ban radu naané déku gayéba dé wale rate wuné guné wale kulé wain gu kaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naate wadéka de Gotna nyégaba kwaakwa gwaaré waatakne raapme gwaade de Oliv nébat waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas dé déku duwat wak, “Wuné kutdéngék. Guné akwi wunéké kuk tiyaate yaage yéké guné yo. Yaage yégunéranké Gotna kudi déku nyégaba kéga dé kwao: Wuné sipsipké téségékwa duwat viyaawuru de sipsip yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wani kudi wadékwa pulak yaage yéké guné yo. Yégunu wuné kiyaaké wuné yo. Kiyae kukba tépa nébéle raapme wuné Galilit taale yéké wuné yo. Yéwuru guné kukba yaaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naate wadéka dé Pita dérét wak, “Wuné ménéké kuk kwayékaapuk yaké wuné yo. Wuné yaage yékaapuk yaké wuné yo. De ménéké kuk kwayéte yaage yédaran wuné waga yakaapuk yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Naate wadéka dé wak, “Wuné kutdéngék. Bulaa gaan séraa apu vétik waakaapuk yadu méné apu kupuk waké méné yo, ‘Wuné Jisasnyét las kaapuk kutdéngwurén.’ Waga waménu séraa waaké dé yo. Adél wuné ménat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naate wadéka dé wak, “Aya kaapuk. Waga wakaapuk yaké wuné yo. Wuné méné wale kiyaawuréran wuné wup yakaapuk yaké wuné yo. Wani kudi wakaapuk yaké wuné yo.” Naate wadéka Jisasna du akwi waga male de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wani kudi watakne de Jisas wale taalat nak wulaak. Wani taaléna yé Getsemani. Wulae dé déku duwat wak, “Guné kéba mé ra. Wuné Got wale kudi bulké wunék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Naate watakne dé Pita, Jems, Jonét kwole de yék. Yédaka déku mawulé kapére yadéka dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yate dé derét wak, “Wuna wuraanyan dé génu. Kén kiyaaké wuné yo. Guné kéba raké guné yo. Widé kwaakaapuk yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Naate wadéka de radaka dé walkamu ye képmaaba kwaate dé Gorét wak, “Wuna yaapa, méné akwi muké méné apa yo. Méné yadaran muké waké mawulé yaménéran méné waménu wunat kapéredi mu yakaapuk yaké de yo. Waga ménat wuné waato. Méné mawulé yawurékwa pulak yaakaapuk yaké méné yo. Méné mawulé yaménékwa pulak yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wani kudi watakne dé déku duké gwaamale ye dé vék de widé kwaadaka. Véte dé derét waaséligénte dé Pitat wak, “Saimon, wan widé méné kwao, kapu yaga pulak? Méné makwal tulé wuné wale raké méné yapatiyu. Méné widé méné kwaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Naate watakne dé derét wak, “Guné widé kwaakaapuk yate miték sanévéknwute Gorét waataké guné yo, kapéredi mu gunat yaalébaankaapuk yaduké. Wuné kutdéngék. Guné widé kwaamuké kélik yagunéka guna sépé apa yakaapuk yadéka gunat widé yadéka guné widé kwaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naate watakne tépa derét kulaknyénytakne walkamu ye dé Gorét tépa waatak. Taale Gorét waatadén kudi male dé tépa waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Waatatakne déku duké tépa gwaamale ye dé vék de tépa widé kwaadaka. Deku méni widat kapére yadéka de widé kwaak. Kwae ligéne dérét tépa véte de kaapuk kutdéngdan. Samu kudi dérét wakweké de yo? Kutdéngkaapuk yate de akélak rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dé tépa ye Gorét waatatakne déku duké gwaamale yae derét waaséligénte dé wak, “Yaga pulak? Guné wekna guné widé kwao? Yaak. Mé vé. Wuné Akwi Du Taakwana Nyaan wunat kapéredi mu yakwa duké kwayédéran tulé débu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mé raapgunu yéno. Mé vé. Wunat maamaké kwayékwa du déwa yaakwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas wekna wadéka bari dé déku du nak Judas yaak. Wupmalemu du de waariyadakwa kulaa baagé wawo kure de dé wale yaak. Gotna gaba jébaa yakwa nyédé duna némaan du, kubu du, apa kudiké kutdéngkwa du wawo taknaba waga wadaka de yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Taknaba Jisasnyét maamaké kwayéran du Judas dé Jisasnyét kulékiran duwat wak, “Wuné taama véran (daama réngran) du wan Jisas. Guné dérét kulékiye miték téségéte kure yéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Jisaské bari ye dé wak, “Némaan ban.” Naate watakne dé dérét kure taama vék (daama réngék). ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yadéka dé wale yaan du de Jisaské ye dérét kulékik. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kulékidaka dé waba tén du nak waariyadékwa kulaa kelikne dé nyédé duna némaan banké jébaa yakwa dut viyaate déku waan takutépakdéka dé akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yadéka dé Jisas derét wak, “Guné wunat kulékiké yaate samuké guné waariyagunékwa kulaa baagé wawo kure yao? Guné sél yakwa dut viyaaké guné wani mu kure yao, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wupmalemu nyaa wuné Gotna kudi bulnakwa némaa gaba rate wuné du taakwat Gotna kudiké yakwatnyék. Waba rawuréka guné wunat kaapuk kulékigunén. Wunat yagunékwa muké déknyényba du las Gotna nyégaba de kavik. Kavidan kudi bulaa adél yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Naate wadéka déku du akwi dérét kulaknyénytakne de yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Déku du yaage yédaka de Jisasnyét kure yék. Kure yédaka nakurak baapmu wut male kusadan du nak dé Jisasna kukba yék. Yédéka de dérét kulékiké yate de déku baapmu wutba kurék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kutdaka dé baapmu wut lépattakne dé bakna yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisasnyét kulékin du de dérét kure yék, nyédé duna némaan banké. Nyédé duna akwi némaan du, kubu du, apa kudiké kutdéngkwa du wawo de nyédé duna némaan ban déku gaba jawe de rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita séknaa pulak Jisasna kukba ye dé némaan banna gaké raatmu gisagwadédan taalat wulaak. Wulae dé kwabugi du wale kaapaba rak. Yépmaa yadéka dé de wale yaaba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nyédé duna némaan du, Isrelna nak némaan du wawo de Jisasnyét viyaapérekgé de mawulé yak. Yate de wak, “Jisas yadén kapéredi muké kiyadé waké yo?” Naate wadaka du nak waga kaapuk wadén. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wupmalemu yénaa yakwa du yae de Jisas yan muké wakwek. Wakwete nakurak kudi kaapuk wakwedan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Du las téte yénaa yate de Jisaské wak, “Wani du kéga dé wak, ‘Du kaadan kéni ga, Gotna kudi bulnakwa némaa ga wuné yaalébaanké wuné yo. Yaalébaane nyaa kupuk yédu wuné nak pulak ga kaaké wuné yo.’ Naate wadéka naané véknwuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Waga wate de kés kudi nak kudi wakwek. Nakurak kudi kaapuk wakwedan. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wani kudi wadaka dé nyédé duna némaan ban raapme téte dé Jisasnyét wak, “Samuké nae méné deku kudi kaatakaapuk yo? Deku kudi yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Naate wadéka dé kudi las kaapuk buldén. Yadéka dé nyédé duna némaan ban dérét wak, “Méné Got wadén ban Krais méné? Méné némaan ban Gotna nyaan méné?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Naate wadéka dé wak, “Ao. Kukba guné véké guné yo, wuné Akwi Du Taakwana Nyaan némaan ban rate apat kapére yakwa ban Gotna yéknwun tuwa taababa re buwi wale awuré nyétba giyaawuru.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naate wadéka dé nyédé duna némaan ban rékaréka yate déku baapmu wut gétbiyaate dé wak, “Guné déku kudi gunébu véknwuk. Wan kapéredi kudi. Nak duwat waatakaapuk yaké naané yo, yadén kapéredi muké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dé waga watakne Gotké kapéredi kudi bulte dé Gorét waséléknék. Yaga guné wo déké?” Naate wadéka de wak, “Dé kapéredi mu débu yak. Dé mé kiyao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wani kudi watakne de las Jisasna sépéba sépmeny sévaavik. Sévaavite de déku méniba baapmu wut nak gik. Gitakne dérét de viyaak. Viyaate dérét wasélékte de wak, “Méné Gotna yéba kudi wakwekwa du rate méné akwi muké méné kutdéngék. Kutdéngte, naanat mé wakwe. Kiyadé ménat viyaak?” Naate wadaka de kwabugi du dérét kure de dérét viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita adaba dé rak. Gaké gisagwadédanba dé rak. Radéka lé nyédé duna némaan ban déku jébaa yakwa taakwa nak yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yae lé vék Pita yaaba radéka. Véte lé dérét wak, “Méné wawo Nasaretba yaan ban Jisas wale méné ték.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naate waléka dé wak, “Kaapuk. Wuné wanyénékwa kudi las kaapuk kutdéngwurén.” Naate watakne gwaade dé gwéspétéba rak. Radéka dé séraa waak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Waadéka wani taakwa dérét tépa véte lé lé wale tén du taakwat wak, “Kéni du wawo wan déku jébaaba wulaan du.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naate waléka dé tépa wak, “Kaapuk.” Naate wadéka walkamu re de waba tén du de tépa wak, “De Galiliba de yao. Méné wawo Galiliba yaan du méné. Méné Jisasna du nak. Wan adélna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Naate wadéka dé Pita derét némaanba wak, “Kaapuk. Wakwegunékwa dut las kaapuk kutdéngwurén. Adél wuné wo. Adél kudi wakaapuk yawuréran Got wunat dé mé viyao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naate wadéka dé séraa tépa waak. Waadéka dé Jisas dérét wakwedén kudiké dé sanévéknwuk. Nalé Jisas dé wak, “Wuné kutdéngék. Séraa apu vétik waakaapuk yadu méné apu kupuk waké méné yo, ‘Wuné dérét las kaapuk kutdéngwurén.’ Naate waaménu séraa tépa waaké dé yo. Waga wuné kutdéngék.” Wani kudiké sanévéknwute dé Pita némaa mawulé lékte géraak, dé Jisaské kuk kwayédén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yé tékdéka de nyédé duna némaan du, Isrelna kubu du, apa kudiké kutdéngkwa du, akwi némaan du wawo jawe de kudi bulék. Bultakne wadaka de Jisasnyét baagwit gitakne Romna némaan du Pailatké de dérét kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kure yédaka dé Pailat Jisasnyét waatak, “Méné Judana némaan ban kapu kaapuk?” Naate waatadéka dé wak, “Ao. Méné kapmu méné waga wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Naate wadéka de nyédé duna némaan du de wupmale yénaa kudi wakwek, Jisas yan muké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wakwedaka dé Pailat dérét wak, “De ménéké wupmalemu kudi de wakweyo, yaménén muké. Samuké méné deku kudi kaatakaapuk yate méné kudi bulkaapuk téte vu?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Naate wadéka dé Pailarét kudi las wawo kaapuk wakwedén. Yadéka dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akwi kwaaré Pasova waadakwa kadému kadakwa tulé dé Romna némaan du wadéka du taakwa mawulé yadan du nak raamény ga kulaknyénytakne gwaade dé miték yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wani tulé kapéredi mu yan du las de raamény gaba kwaak. Déknyényba de Romna duké kélik yate Jerusalemba rakwa du taakwat wakwedaka de Romna du wale waariyak. Nak apu de duwat viyaapéreknék. Wani kapéredi mu yan du nak wan Barabas. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akwi du béré taakwa béré yae de Pailarét waatak, akwi kwaaré wadén pulak tépa waduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Waatadaka Pailat dé kutdéngék. Jisas kapéredi mu las kaapuk yadén. Nyédé duna némaan du de Jisaské kélik yate dérét gitakne de kure yaak déké. Waga kutdéngte déku mawuléba dé wak, “Sal kéba jawe tékwa du taakwa Jisaské mawulé yaké de yo, kapu yaga pulak?” Naate wate dé wani du taakwat wak, “Judana némaan banét wawuru dé miték yéduké guné mawulé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naate wadaka de nyédé duna némaan du de waba tén du taakwat wak, de Pailarét wado dé Jisasnyét wakaapuk yate Barabasnyét waduké. Wadu Barabas raamény ga kulaknyénytakne gwaade miték yéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wadaka de Pailarét waga wadaka dé derét tépa wak, “Waagunékwa Judana némaan banét yaga pulak yaké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Naate wadéka de akwi waate de wak, “Dérét miba mé viyaapata takna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Naate waadaka dé wak, “Samuké? Samu kapéredi mu dé yak?” Naate wadéka de némaanba waak, “Dérét miba mé viyaapata takna.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Waga waadaka Pailat déku mawuléba dé wak, “Wuné deku kudi véknwuréran de wunéké mawulé yaké de yo.” Naate watakne dé wak, Barabas raamény ga kulaknyénytakne gwaade miték yéduké. Watakne déku waariyakwa duwat dé wak, de Jisasnyét raamény baagwit némaanba viyaatakne dérét miba viyaapata taknadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailatna waariyakwa du de deku némaa gat de Jisasnyét kure yék. Kure yédaka de waadaka de akwi waariyakwa du yae de dé ténba jawuk. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jawe de deku mawuléba wak, “Némaan du de gwaavé baapmu wut kusade yéknwun maakna saap de saaptakno.” Naate wate Jisasnyét waagite wasélékte de déku baapmu wut putitakne de gwaavé baapmu wut kusadak. Kusadatakne de raamény baagwi nak kérae maakna saap pulak séwayékwe de déku maaknaba kusadak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kusadatakne de dérét wak, “Méné, Judana némaan ban, miték raké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Naate wate baagé nak kérae de déku maaknaba viyaak. Viyaate dérét sépmeny sévaavite de dérét wasélékte déké kwati yaane waadé daak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Waga yabutitakne de kusadadan gwaavé baapmu wut putitakne de déku baapmu wut tépa kusadak. Kusadatakne dérét miba viyaapata taknaké nae de dérét kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yaabuba yéte de waariyakwa du Sairiniba yaan du nak déku yé Saimonét vék. Déku nyaan vétik Aleksanda bét Rupas. Dé nak taaléba yae Jerusalemét wulaaké yadéka de vék. Véte de dérét wak, dé Jisasnyét viyaapata taknadaran mi yaataduké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wadaka yaatadéka ye de Golgota waadakwa taalé saabak. Wan Judana kudi. Naana kudi Maakna Apa. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Saabe de marasin wale yadan wain gu Jisaské kwayék, dé ke apakélé kaagél kutkaapuk yaduké. Kwayédaka dé kaapuk kadén. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yadéka de dérét miba viyaapata taknak. Viyaapata takne de rate déku baapmu wut muniye déku baapmu wut kéraaké de makwal matu yatjawurék. Yatjawurédaka waare giyaa akére derét talaknan du dé wani baapmu wut kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ganba de Jisasnyét miba viyaapata taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dérét viyaapata taknadan mi awuréba kaviye taknadan kudi wan kéga: Kén Judana némaan ban. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisasnyét miba viyaapata takne de waariyate sél yan du vétiknét mi vétikba viyaapata taknak. Naknét de déku yéknwun tuwa saknwuba viyaapata taknak. Naknét de déku aki tuwa saknwuba viyaapata taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Waga yadaka Gotna nyégaba déknyényba kavidan kudi wani tulé adél dé yak. Kéga de kavik: Dérét de vék kapéredi mu yan du wale tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Du las yeyé yeyate Jisasnyét miba viyaapata taknadaka tédéka véte de dérét waagite waséléknék. Yate de wak, “Ménawa. Yaga pulak? Méné Gotna kudi bulnakwa némaa ga yaalébaane nyaa kupuk yédu méné tépa kaaké nae méné wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bulaa méné ména kapmu ména sépat kutkalé yaké méné yo. Méné apa yate wani mi kulaknyénytakne giyaaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naate wadaka de nyédé duna némaan du, apa kudiké kutdéngkwa du wawo deku kapmu bulte de Jisasnyét waagite waséléknék. Yate de wak, “Dé nak duwat dé kutkalé yak. Déku sépat kutkalé yaké dé yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dé Got wadén ban Krais rate Isrelna némaan ban radéran dé viyaapata taknadan mi kulaknyénytakne giyaadu naané véte déku kudiké ‘Adél’ naaké naané yo.” Naate wadaka bét Jisas wale miba viyaapata taknadan du vétik bétku miba téte bét wawo bét dérét waséléknék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nyaa nawurédéka dé akwi képmaaba gaan yak. Ye tédéka kukba nyaa tégéruwe dawuliké dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yadéka Jisas déku kudiba némaanba dé kéga waak, “Eloi, Eloi, lama sabaktani.” Wani kudi naana kudiba kéga: “Wuna némaan ban Got, samuké méné wunéké kuk tiyao?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Waga waadéka waba tén du las wani kudi véknwute de wak, “Mé véknwu. Wani du dé déknyényba rate Gotna yéba kudi wakwen du Ilaijat dé wao.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naate watakne dé du nak pétépété ye nyabiyas pulak mu las kérae dé nyégi yakwa wain guba tawuk. Tawudéka gubés yadéka baagéba takne dé Jisas kaduké kusawurékwek. Yate dé wak, “Wekna mé téte véno. Sal Ilaija yae dérét kutkwedu dé giyaaké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naate wadéka dé Jisas némaanba waatakne dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas kiyaadéka Gotna kudi buldakwa némaa gaba lékidan sémény baapmu wut awuréba gétbiyae ye dé adawuli saabak. Yadéka dé taakwi vétik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisas waga kiyaadéka waariyakwa duna némaan du dé téte vék. Véte dé wak, “Wani du wan Gotna nyaan. Wan adél.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Wupmale taakwa yae séknaaba pulak téte de wawo de vék. Déknyényba Jisas Galiliba déku du wale jébaa yadaka de de wale yeyé yeyate deké de kadému kwayék. Wani taakwa nak wan Makdalaba yaan taakwa Maria. Nak wan nak Jems bét Josepna néwaa Maria. Nak wan Salomi. Jisas Galili kulaknyénytakne yaadéka wani taakwa, wupmale taakwa las wawo waga de dé wale yaak Jerusalemét. Wani taakwa de séknaaba pulak téte de vék Jisas kiyaadéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yaap ra nyaa yaaké yadéka de wani nyaa gwalmu kawu saakérak. Garabu yadéka Arimatiaba yaan du déku yé Josep wup yakaapuk yate dé Romna némaan du Pailatké yék. Dé Isrelna némaan du nak rate akwi duna méniba yéknwun du dé rak. Dé wawo dé Got némaan ban rate du taakwaké miték véran tuléké dé raségék. Dé Jisasna gaaba ségwi kéraaké dé Pailatké yék. Ye dé Pailarét waatak, déku gaaba ségwiké. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Waatadéka dé Pailat kaapuk kutdéngdén. Jisas dé kiyaak, kapu wekna kiyaaké dé yo? Kutdéngkaapuk yate wadéka waariyakwa duna némaan du yaadéka dé Pailat dérét waatak, “Jisas débu kiyaak, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Naate waatadéka dé wak, “Ao.” Naate wadéka dé Pailat Josepmét wak, “Méné déku gaaba ségwi kéraaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Waga wadéka dé yéknwun waama baapmu wut kérae Jisasna gaaba ségwi lépmwénye kure giyae dé baapmu wurét kusépmék. Kusépme kure ye dé waaguba nak taknak. Déknyényba wani waagu de jébaa yakwa du matuba vaakére wulaak. Josep Jisasna gaaba ségwi wani waaguba takne dé matu nak yatbalaakukére ye dé yaabuba taknatépék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Taknatépédéka bét Makdalaba yaan taakwa Maria bét Josepna néwaa Maria bét Jisasnyét taknadén waagu vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judana yaap ra nyaa yédéka de taakwa kupuk, Makdalaba yaan taakwa Maria, Jemsna néwaa Maria, Salomi, waga de Jisasna gaaba ségwiba kutké yéknwun yaama yakwa mu kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kérae Sande ganbaba nyaa yaaladéka de Jisasna gaaba ségwi taknadén taalat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yaabuba yéte de deku kapmu bulte de wak, “Kiyadé waaguba taknatépédan matu yatbalaakutiyaaké yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Naate de wak, wani matu apakélé matu bege. Watakne de vék waaguba taknatépédan matu yatbalaaku taknadaka radéka. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vétakne waaguba wulae de vék du nak waama baapmu wut kusade yéknwun tuwa saknwuba radéka. Véte de kwagénék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kwagéndaka dé wak, “Guné wup yakaapuk yaké guné yo. Wuné kutdéngék. Guné Nasaretba yaadéka miba viyaapata taknadan ban Jisaské guné sékalu. Débu tépa nébéle raapmék. Dé kéba kaapuk radékwa. Guné yae guné taknadaka kwaadén taalé véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bulaa guné ye guné déku du, Pitat wawo, kéga wakweké yo, ‘Jisas dé Galilit taale yu. Guné ye déknyényba wakwedén pulak dérét waba véké guné yo.’ Naate derét wakweké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dé waga wadéka de kwagénte sanévéknwu wanévéknwute de waagu kulaknyénytakne gwaade yaage yék. Ye wupmét kapére yate de wani muké kudi kaapuk wakwedan.  ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande ganbaba Jisas dé tépa nébéle raapmék. Raapme yaadéka lé Makdalaba yaan taakwa lé dérét taale vék. Déknyényba kutakwa nak taaba sékét nak taababa kayék vétik léku mawuléba wulae tédaka Jisas wadéka de lérét kulaknyénytakne yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisas nébéle raapdéka lé dérét vétakne lé déku duké yék. Yéléka de déké mawulé lékte géraadaka lé derét wak, “Jisas débu tépa nébéle raapmék. Raapdéka dérét wunébu vék.” ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Naate waléka de véknwute de wak, “Kaapuk. Wan yénaa nyéné yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kukba Jisasna du vétik Jerusalem kulaknyénytakne yaabuba bét yék. Yébétka Jisas nak du pulak ye bétké yaadéka bét dérét vék. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Véte dérét kutdéngte gayét gwaamale ye bét Jisasna duwat wak, “Dérét anébu vék.” Naate wabétka de wak, “Kaapuk. Wan yénaa béné yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kukba Jisasna du taaba vétik sékérék maanba kayék nakurak kadému kadaka dé Jisas deké yék. Ye dé derét wak, “Nébéle raapwuréka de wunat vétakne gunat kudi wakwek. Samuké guné deku kudi kaapuk véknwugunén? Samuké guné wunéké kaapuk miték sanévéknwugunékwa?” ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naate watakne dé derét wak, “Guné ye akwi képmaaba rakwa akwi du taakwat wuna kudi wakweké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wunéké miték sanévéknwute wuna kudiké ‘Adél’ naate wuna yéba gu yaakun du taakwat Got Setenna taababa kéraadu de miték rasaakuké de yo. Wunéké miték sanévéknwukaapuk yakwa du taakwa Got wadu de yalakgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wunéké miték sanévéknwute wuna kudiké ‘Adél’ naakwa du taakwa déknyényba vékaapuk yadan apa jébaa kéga yaké de yo. De wuna yéba wado du taakwana mawuléba wulae tékwa kutakwa yaage yéké de yo. De véknwukaapuk yadakwa kulé kudiba wakweké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","De du taakwat tikwa kaabet kutdaran de miték raké de yo. De kapéredi gu kadaran de miték raké de yo. De kiyakiya yakwa du taakwat taaba kutdo de tépa yéknwun yaké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Némaan Ban Jisas waga wadéka kukba Got wadéka dé Gotna gayét waare némaan ban rate dé déku yéknwun tuwa taababa rak. ");
INSERT INTO abt_maprik_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Déku du gege gayét yéte déku kudi de wakwek. Wakwedaka Némaan Ban de wale jébaa yate deké apa kwayédéka de deku kudi véknwukwa du taakwa déknyényba vékaapuk yadan apa jébaa de vék. Véte de wak, “Deku kudi wan adél kudi.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Némaan du Tiopilas, ménéké wuné kéni kudi kaviyu. Méné kutdéngék. Du las naané wale rate de nak pulak apa jébaa yak. Yadaka nak du wani jébaa batnyé yadaka vétakne wani jébaa yasaakudaka véte de wani jébaaké naanat kudi wakwek. Waga kutdéngte kéga wawo méné kutdéngék. Wupmalemu du wani jébaaké saapéte nyégaba kudi kaviké de mawulé yak. Yate de naanat taale wakwen duna kudi pulak de kudi kavik. Waga méné kutdéngék. De waga yadanké wuné wawo wani muké kaviké wuné mawulé yo. Méné miték kutdéngménuké wuné miték kaviké wuné yo. Wupmalemu apu wani muké miték kutdéngké nae derét wuné waatak. Waate bulaa kutdéngte miték sanévéknwe miték kaviké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kaviwuru méné miték kutdéngké méné yo. Wani muké ménat yakwatnyédan kudi wan adél kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yerot Judiana némaan ban radén tulé Gotna gaba jébaa yakwa nyédé du dé nak rak. Déku yé Sekaraia. Dé Abaisana kémba dé rak. Déku taakwa léku yé Ilisabet lé Eronna kémba lé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Déknyényba Eron akwi nyédé duna némaan ban dé rak. Re kiyaadéka déku képmawaara wupmalemu de wawo nyédé du de rak. Bét Némaan Ban Gotna méniba yéknwun mu yakwa du taakwa bét rak. Bét déku apa kudi miték véknwute wadékwa pulak yate bét kapéredi mu las kaapuk yabérén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lé baadi las kaapuk kéraalén. Yaléka bét kapmu bét rak. Baadi kaapuk. Bét gwalepa bétbu yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nyaa nak Sekaraia béré Gotna gaba nyédé duna jébaa de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yate de akwi nyédé du yadan pulak yate de nyédé duna jébaaké kudi bulte de wak, Sekaraia Némaan Ban Gotna gat wulae yéknwun yaama yakwa mu sérakdu yaatnyé waaréduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wadaka dé wulaadéka yéknwun yaama yakwa yaatnyé yadakwa tulé de wupmalemu du taakwa kaapaba jawe téte de Gorét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Waatadaka dé Sekaraia awulaba téte dé vék Némaan Ban Gotna kudi kure giyaakwa du nak yéknwun yaama yaalakwa yaatnyé tékwa jaabéna yéknwun tuwa saknwuba tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Vétakne kwagénte dé wupmét kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yadéka dé Gotna kudi kure giyaakwa du dérét wak, “Sekaraia, méné wup yamarék. Got ména kudi débu véknwuk. Véknwute débu wak, ména taakwa Ilisabet du nyaan kéraaluké. Kéraalu méné déku yé Jon waaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ména taakwa wani nyaan kéraalu méné wupmalemu du taakwa wale guné yéknwun mawulé yate dusék takwasék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wani nyaan néwaana biyaaba wekna kwaadu dé Gotna Yaamabi déku mawuléba wulae téké dé yo. Dé wain gu waagété gu wawo kamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dé Gotna méniba némaan du raké dé yo. Radu guné déké yéknwun mawulé yate dusék takwasék yaké guné yo. Dé wadu déknyényba Gotké kuk kwayén Isrelna wupmalemu du taakwa de deku Némaan Ban Gotna kudi tépa véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dé Gotna yéba kudi wakwen du Ilaija rate apa yadén pulak, dé rate apa yaké dé yo. Yate dé wadu yaapa deku baadiké tépa yéknwun mawulé yado Gotna kudiké kuk kwayékwa du nak mawulé yate Gotna kudi véknwukwa du taakwa yadakwa pulak yéknwun mawulé yaké de yo. Dé taale yéte wadu du taakwa miték sanévéknwute Némaan Ban yaadéranké raségéké de yo.” Naate dé Gotna kudi kure giyaakwa du wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wadéka dé Sekaraia dérét wak, “Yaga pulak ye wuné wani kudi adél yadéranké kutdéngké wuné yo, ané taakwa wale gwalepa yatén bege?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Naate wadéka dé Gotna kudi kure giyaakwa du wak, “Wuné Gotna kudi kure giyaakwa duna némaan du nak. Wuna yé Gebriel. Wuné Gotna méniba wuné tu. Téwuréka Got wunat wadék wuné déku kudi kure giyao. Dé wadék wuné wani yéknwun kudi ménat wakweké nae wuné giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bulaa mé véknwu. Méné wuna kudi kaapuk véknwuménén. Bulaa méné kudi bulmarék raké méné yo. Raménu wakwewurén akwi mu yaaké dé yo. Yaadu wani tulé wuna kudi adél yadu méné tépa kudi bulké méné yo.” Naate watakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Du taakwa kaapaba téte Sekaraiaké téségéte de sanévéknwu wanévéknwuk, dé Gotna kudi buldakwa gat wulae bari yaalamarék yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yadaka dé kukba kaapat yaale de wale kudi bulké dé yapatik. Yadéka de kutdéngék. Dé Gotna gaba yégan pulak yate dé nak pulak mu dé nak vék. Waga kutdéngdaka dé kudi bulké yapatiye dé kudi bulké mawulé yate déku taabat male dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dé nyaa las re déku jébaa yabutitakne dé déku gayét tépa gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ye re kukba déku taakwa Ilisabet lé nyaan ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Téte lé baapmu naktaba léku gaba rak. Rate lé wak, “Déknyényba wuné nyaan kéraamarék yan taakwa rawuréka du taakwa de wunat waséléknék. Yadaka wuné nyékéri yak. Bulaa Némaan Ban Got wunéké mawulé lékte wunat débu kutkalé yak.” Naate lé Ilisabet wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet nyaan téléka baapmu nak taaba sékét nak taababa kayék nakurak yédéka, Got wadéka dé déku kudi kure giyaakwa du nak déku yé Gebriel dé Nasaretnét giyaak. Nasaret Galiliba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wani tulé taakwa nak léku yé Maria lé waba rak. Déknyényba lé du wale kaapuk kwaalén. Déknyényba léku néwepa Josepna kém wale kudi debu gik, lé kukba Josepké yéluké. Josep déknyényba ran némaan ban Devit déku kémba dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Got wadéka Gebriel giyae dé Mariat wak, “Nyénéwa rakwa. Némaan Ban Got nyénéké mawulé lékte nyéné wale dé tu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Naate wadéka wani kudi véknwute wani kudiké kutdéngmarék yate wup yate lé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yaléka dé lérét wak, “Nyéna Maria, wup yamarék yaké nyéné yo. Got nyénéké dé yéknwun mawulé yo. Yate nyénat kutkalé yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mé véknwu. Nyéné nyaan te du nyaan nak kérae déku yé Jisas waaké nyéné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dé némaan ban raké dé yo. Apat kapére yasaakukwa ban Got dérét waké dé yo, ‘Méné wuna nyaan.’ Naate watakne Némaan Ban Got wadu déku képmawaara Devit némaan ban rate Judana du taakwaké védén pulak, dé némaan ban rate deké véké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dé némaan ban apuba apuba rasaakuké dé yo Isrelna du taakwaké. Rate deké miték vésaakuké dé yo apuba apuba.” Naate dé Gebriel wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wadéka lé Maria dérét wak, “Yaga pulak nyaan téké wuné yo, du ramarék yawurékwa bege?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naate waléka dé wak, “Gotna Yaamabi nyénéké giyaaké dé yo. Giyaadu Got nyénéké apa kwayéké dé yo. Yadu nyaan te kéraaké nyéné yo. Kéraanyénu wani nyaanké waké de yo, ‘Dé wan yéknwun nyaan. Wan Gotna nyaan.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","“Kéni kudi wawo mé véknwu. Got akwi mu yaké dé apa yo. Nyéna kémna taakwa nak Ilisabetké de wak, ‘Wan baadi kéraamarék yakwa taakwa.’ Naate wadaka gwalepa yaléka Got wadék lé nyaan lé tu. Baapmu nak taaba sékét nak taababa kayék nakurak lé nyaan tu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Naate wadéka lé Maria wak, “Wuné véknwu. Wuné Némaan Ban Gotna jébaa yakwa taakwa. Wunat wakweménén pulak Némaan Ban yaké dé yo. Wan yéknwun.” Naate waléka dé wani du Gotna gayét gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria walkamu re gwalmu kawu saakére lé Judana nébuba tékwa gayét nak bari yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ye lé Sekaraiana gat wulae lé Ilisabet wale kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bulléka Ilisabet Mariana kudi véknwuléka léku biyaaba kwaan nyaan dé génék. Géndéka dé Gotna Yaamabi Ilisabetna mawuléba wulae ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tédéka lé némaanba waate lé wak, “Got nyénat débu kutkalé yak. Wan adél. Nyénat kutkalé yadén mu nak taakwat kutkalé yadén mat débu talaknak. Got nyéna biyaaba kwaakwa nyaanét wawo débu kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyéné wuna Némaan Banna néwaa nyéné ro. Nyéné wunéké yaanyénén wan yéknwun. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nyéné yae wuné wale kudi bulnyénéka wuné nyéna kudi véknwuréka wuna biyaaba kwaakwa nyaan dusék yate géndéka wuné véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyéné Némaan Ban Gotna kudi miték véknwute nyéné wak, ‘Wakwedén pulak yaké dé yo. Wan adél.’ Waga watakne nyéné yéknwun mawulé yate miték raké nyéné yo.” Waga lé Ilisabet wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria wani kudi véknwutakne lé gwaaré kéga waak: ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wuné yéknwun mawulé yate wuné Némaan Banna yéba kevéréknu. Got wunat kutkalé yate wunat déku taababa débu taknak. Taknadénké wuné déké yéknwun mawulé wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Wuné némaa taakwa kaapuk. Wuné bakna taakwa rate déku jébaa yakwa taakwa wuné ro. Rawuréka dé yéknwun mu yasaakukwa ban rate wunéké débu sanévéknwuk. Sanévéknwute dé apat kapére yakwa ban rate wunat némaa mu débu yak. Yadénké bulaa, kukba wawo, akwi du taakwa waké de yo, ‘Got Mariat débu kutkalé yak. Wan adél.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gotna kudi miték véknwukwa du taakwa deké Got mawulé dé léknu. Bulaa, kukba wawo, Got waga pulak yakwa du taakwaké mawulé lékgé dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Got apat kapére yate dé wupmalemu apa jébaa dé yo. Dé wadéka deku sépé deku gwalmuké sanévéknwute deku yéba kevérékgwa du taakwa de yaage yu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dé wadéka kés képmaa nak képmaaba ran némaan du de bakna du de ro. Dé wadéka bakna du taakwa némaan du taakwa de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gwalmu yamarék du taakwaké dé yéknwun mu kwayu. Wupmalemu gwalmu yan du taakwat wadéka de gwalmu yamarék yate bakna de yu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Déknyényba Got dé Ebrayam naana képmawaarat las wawo dé wak, ‘Guné Isrelna du taakwa, gunéké mawulé lékte bulaa, kukba wawo, gunat kutkalé yaké wuné yo.’ Naate watakne wani kudiké sanévéknwute dé déké jébaa yakwa Isrelna du taakwat dé kutkalé yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wani gwaaré waga waatakne Maria Ilisabet wale lé rak. Baapmu kupuk re lé léku gat gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kukba Ilisabet nyaan kéraaléran tulé yaadéka lé du nyaan kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kéraaléka Ilisabetna kém léku du taakwa wawo véknwute de lé wale yéknwun mawulé yate dusék takwasék yak. Yate de wak, “Némaan Ban Got yéknwun mu débu yak Ilisabetké.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nyaa nak taaba sékét nak taababa kayék vétik yédéka nak nyaa de du taakwa yae de jawuk, déku kémna du, ‘Gotna du’ naate, wani nyaanna sépé sékudoké. Jawudaka déku sépé sékwe de wani nyaanna yé Sekaraia waaké de mawulé yak. Sekaraia wan déku yaapana yé. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mawulé yadaka lé déku néwaa lé wak, “Aya, kaapuk. Déku yé Jon waaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Naate waléka de lérét wak, “Déknyényba béna kémna duwat wani yé kaapuk waadan.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naate watakne de déku yaapa Sekaraiat waatak. Sekaraia wekna kudi bulmarék radéka de dérét taabat yate kéga waatak, “Samu yé waaké naané yo dérét?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naate waatadaka dé taabat yate déké nyéga kwayédoké dé derét wak. Wadéka kwayédaka dé nyégaba kavik, “Déku yé Jon.” Waga kavidéka de akwi sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yadaka déku kudi bari yéknwun yadéka dé Sekaraia tépa kudi bulék. Bulte dé Gotna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yadéka de wani gayéba ran du taakwa akwi de wupmét kapére yak. Yadaka de wani muké kudi bulkére yék, Judiana nébuba tékwa akwi gayéba. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yadaka wani kudi véknwukwa du taakwa de kutdéngék. Némaan Ban Got wani nyaanké dé apa kwayék. Waga kutdéngte sanévéknwu wanévéknwute de wak, “Kukba wani nyaan yaga pulak raké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gotna Yaamabi dé wani nyaanna yaapa Sekaraiana mawuléba wulae ték. Tédéka dé Gotna kudi kéga wakwek: ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Naané Isrelna du taakwa, naana Némaan Ban Gotna yéba kevérékgé naané yo. Naanat kutkalé yaké débu giyaak. Giyae dé Setenna taababa naanat kéraaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dé débu wak, naanat kutkalé yaran ban apa yate naanéké yaaduké. Wani ban Gotna jébaa yan du Devit déku kémba yaalaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Déknyényba Got wadéka déku yéba kudi wakwen du de kéni kudi wakwek, “Naana maama naanéké kélik yakwa du wawo naanat viyaapérekgé mawulé yado Got naanat kéraaké dé yo deku taababa.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Déknyényba Got dé naana képmawaarat wak, “Wuné gunéké mawulé lékgé wuné yo. Yate wuné gunat kutkalé yaké wuné yo. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wani adél kudi Got dé naana képmawaara Ebrayam déku kémét wawo dé wak. Wadén pulak yate dé naanat kutkalé yate naanat naana maamana taababa kéraaké dé yo. Kéraadu naané déké wup yamarék yate déké yéknwun jébaa yaké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yate naané kéni képmaaba rate akwi nyaa déku kudi miték véknwute yéknwun mu male yaké naané yo. Yate déku méniba miték raké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wani kudi watakne dé Sekaraia déku nyaanét kéga wak: Méné wuna nyaan, kukba du taakwa ménéké waké de yo, “Némaan Ban Gotna yéba kudi wakwekwa du.” Naate waké de yo, méné taale yéte Némaan Banna yaabu kutménéran bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yate méné déku du taakwat wakweké méné yo, dé yadan kapéredi mu yatnyéputiye derét kérae déku taababa taknadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Wupmalemu du taakwa kapéredi mu yate de gaankétéba de ro. Rate kukba de yalakgé de yo. Naana Némaan Ban Got naanéké némaa mawulé lékte débu wak, wadén du déku gayéba re kéni képmaat naanéké giyaaduké. Giyae naanat kérae naanat yéknwun yaabuba taknaké dé yo, naané Got wale nakurak mawulé yate dé wale miték ranoké. Naate dé Sekaraia wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kukba wani nyaan Jon némaan yadéka déku mawulé miték dé ték. Dé du ramarék taaléba dé rak. Rate dé Isrelna du taakwat Gotna kudi wakwedéran tuléké dé raségék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wani tulé Romna némaan ban déku yé Ogastas wupmalemu képmaaba rakwa du taakwaké némaan ban rate dé wak, déku du déku képmaaba rakwa akwi du taakwana yé kavidoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Déknyényba de akwi du taakwana yé kaapuk kavidan. Wani jébaa batnyé yadaka dé Sairinias Romna némaan banké jébaa yate Siriana képmaaba dé némaan ban rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Akwi du taakwa deku néwaaget de yék, deku yé kaviké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep Isrelna némaan ban Devitna kémba dé rak. Devitna néwaage wan Betleyem. Betleyem Judiaba dé tu. Josep Galiliba tékwa gayé Nasaret kulaknyénytakne dé déku kémna néwaage Betleyemét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Déku néwepa wadan taakwa wale bét Betleyemét yék, bétku yé kaviké. Wani taakwa léku yé Maria lé nyaan ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Bét ye Betleyem saababétka wupmalemu du taakwa kwaa gaba radaka ga sékérékdéka taalé kaapuk tén bétké. Yadéka lé nyaan kéraaké yate lé bulmakawu kwaadakwa gaba wulaak. Wulae lé maknanyan kéraak. Kérae lé baapmu wurét kusépmék. Kusépme bulmakawu kan kwaamba taknaléka dé kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wani gaan du las nak taaléba deku sipsipké de téségék. Wani taalé Betleyem tékwaba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Téségédaka dé Némaan Ban Gotna kudi kure giyaakwa du nak Gotna gayéba giyae tédéka apakélé yaa pulak yaante dé kayénarék. Kayénarédéka véte de wupmét kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yadaka dé Gotna gayéba giyaakwa du derét wak, “Guné wup yamarék yaké guné yo. Mé véknwu. Yéknwun kudi wakweké wunék. Akwi du béré taakwa béré kéni kudi véknwute yéknwun mawulé yate dusék takwasék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bulaa taakwa nak nyaan lébu kéraak Devitna gayéba. Kéraalén nyaan wan gunat Setenna taababa kérae gunat kutkalé yaran ban. Wan Got wadén ban Krais. Wan naana Némaan Ban. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bulaa ye wani nyaanét véké guné yo. Néwaa baapmu wurét kusépme bulmakawu kadému kan kwaamba taknalék dé kwao. Ye véte kutdéngké guné yo wuna kudi adél yadékwaké.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wadéka de Gotna kudi kure giyaakwa wupmalemu du bari giyae de wani ban wale ték. Téte kéga de gwaaré waak: ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Got awuré déku gayéba rate miték débu yak. Déku yéba kevérékno. Got yéknwun mawulé yadékwa du taakwa miték raké de yo kéni képmaaba. Naate de waak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wani du waga gwaaré waatakne de derét kulaknyénytakne gwaamale waarék Gotna gayét. Waarédaka de sipsipké téségén du deku kapmu bulte de wak, “Betleyemét yéno. Ye Némaan Ban wakwedén nyaanké sékale véké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Naate watakne de bari bari yék. Ye gayé saabe de Maria bét Josep, wani nyaanét wawo de vék. Nyaan bulmakawu kadému kan kwaamba dé kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nyaanét vétakne de Gotna kudi kure giyaakwa du wani nyaanké wakwedén kudiké de du taakwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wakwedaka véknwute de akwi kwagénte de wak, “Aki. Wan yaga pulak mu?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Naate wadaka lé Maria sipsipké téségén duna kudi véknwute lé léku mawuléba sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsipké téségén du gwaamale yéte Gotna yéba kevérékte de déké yéknwun mawulé yak. Yate de wak, “Némaan Ban Got naanat kudi wakwedéka véknwutakne naané wani mu akwi naanébu vék.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nyaa nak taaba sékét nak taababa kayék vétik yédéka nak nyaa de “Gotna du” naate wani nyaanna sépé sékuk. Sékwe de déku yé Jisas waak. Déknyényba Maria nyaan témarék yan tulé Gotna kudi kure giyaakwa du dé wani yé lérét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria nyaan kérae lé Moses wakwen apa kudi wadékwa pulak yaké lé mawulé yak, léku sépé Gotna méniba tépa yéknwun yaduké. Yate nakurak baapmu pulak yédéka lé Josep wale bét Jerusalemét yék. Némaan Ban Gotké kwayéké nae bét Jisasnyét kure yék Jerusalemét. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Némaan Ban Gotna apa kudi nak kéga dé wo, “Taakwa kéraadaran akwi maknadut de Gotké kwayéké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Némaan Ban Gotna apa kudi nak wawo kéga dé wo, “Du bét taakwa bétku du nyaan Gotké kwayéte bét nyaamiyo vétik viyae déké kwayéké bét yo. Nyaamiyo kwayémarék yate nyaamiyo pulak api kwayéké bét yo.” Maria bét Josep wani kudi wadékwa pulak yaké yate bét Jerusalemét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wani tulé du nak déku yé Simion dé Jerusalemba rak. Dé yéknwun mu male yate dé Gorét waatakwa du dé rak. Got Isrelna du taakwat kutkalé yadéran tuléké dé raségék. Gotna Yaamabi déku mawuléba dé wulae ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Déknyényba Gotna Yaamabi dé Simionét wak, “Méné kiyaamarék yate wekna rate méné Némaan Ban Got wadén ban Kraisnyét véké méné yo.” Naate wadéka dé wani muké dé raségék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gotna Yaamabi déku mawuléba wulae téte wadéka dé Gotna kudi buldakwa némaa gat wulaak. Wulaadéka bét Jisasna néwepa dérét kure wulaak, Gotna apa kudi wadékwa pulak maknanyanét yaké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kure wulaabétka dé Simion wani nyaanét nyégéle déku taababa kure téte, dé Gotna yéba kevérékte dé kéga wak: ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Némaan Ban, déknyényba waménén kudi bulaa adél dé yo. Bulaa wunébu vék naanat kutkalé yate naanat kérae Gotna taababa taknaran banét. Bulaa méné ména jébaa yakwa du wunat waménu wuné yéknwun mawulé yate kiyaaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kéni banét ménébu wak, dé wani jébaa yadu akwi képmaaba rakwa du taakwa védoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yaa yaante gaan yaabuba kayénarédékwa pulak kéni ban nak gena du taakwana mawuléba kayénaréké dé yo. Kayénarédu de Gotké miték sanévéknwuké de yo. Sanévéknwute de Isrelna du taakwa deku yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasna néwepa Simion wadén kudiké bét sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Yabétka dé Simion Gorét waatak, dé bérét kutkalé yaduké. Waatatakne dé nyaanna néwaa Mariat kéga wak: Mé véknwu. Got débu wak, kéni du jébaa yadu Isrelna wupmalemu du taakwa déké kuk kwayédo Isrelna wupmalemu du taakwa déku kudi véknwudoké. Dé Gotna jébaa yadu wupmalemu du taakwa déké kuk kwayéké de yo. Kuk kwayédo nak du taakwa deku mawuléké kutdéngké de yo. Du las dérét kapéredi mu yado nyéné vényénu nyéna mawulé sépélak génké dé yo. Naate dé Simion wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Gwalepa taakwa nak léku yé Ana, lé Gotna kudi buldakwa némaa gaba lé rak. Lé Panyuelna takwanyan. Asana kémba lé rak. Lé Gotna yéba kudi wakwekwa taakwa lé rak. Déknyényba lé du rak. Raléka kwaaré nak taaba sékét nak taababa kayék vétik yédéka dé léku du kiyaak. Kiyaadéka lé wupmalemu (84) kwaaré lé kawi taakwa lé rak. Rate lé Gotna kudi buldakwa gaba rak. Rate wani ga kulaknyénymarék yate gaan nyaa lé Got wale kudi bulék. Nak apu nak apu kadémuké yaakétte lé Got wale kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion kudi wakwebutidéka Josep bét Maria wekna tébétka lé yae wani nyaanét véte lé Gotna yéba kevéréknék. Kevérékte lé Jerusalemba ran du taakwat kudi wakwek, wani nyaanké. Déknyényba Got dé wak, du nak yae derét kutkalé yate derét kérae déku taababa taknadéranké. Déknyényba wadén kudi adél yadékwaké lé Ana wani tuléké raségékwa du taakwat kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Némaan Ban Gotna apa kudi wadékwa pulak yabutitakne bét Jisasna néwepa dérét kure bét Nasaretnét tépa gwaamale yék. Nasaret Galiliba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wani nyaan némaan ye dé apa yak. Yadéka déku mawulé yéknwun yadéka dé wupmalemu muké kutdéngék. Got dé déké miték véte dérét kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Akwi kwaaré Jisasna néwepa bét Jerusalemét yék Pasova waadakwa tuléna kadému kaké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasna kwaaré taaba vétik sékérék maanba kayék vétik yadéka bét dérét kwole de yék, akwi kwaaré yabérén pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kukba Pasova waadakwa tuléna kadému kadan nyaa yédéka de deku gayét yédakwa yaabuba gwaamale yék. Yédaka dé Jisas Jerusalemba dé wekna rak. Radéka déku néwepa kaapuk las kutdéngbérén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bét bétku mawuléba bét wak, “Jisas ana kém wale dé yu.” Waga wate bét nyaa nak bét yaabuba yék. Ye garabu yaap rate bét yaabuba yén bétku kém bétku du taakwat waatak déké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Waatatakne dérét vémarék yate bét déké sékalék. Sékale sékale bét sékalpatik. Sékalpatitakne bét Jerusalemét gwaamale yék, déké sékale véké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ye nyaa kupuk bét déké sékalék. Sékale kukba bét vék dé Gotna kudi buldakwa némaa gaba radéka. Dé nak duwat Gotna kudiké yakwatnyékwa némaa du wale rate deku kudi véknwute dé derét kés mu nak muké waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yadéka déku kudi véknwun du de kwagénte sanévéknwu wanévéknwuk, dé miték kutdéngte deku kudi miték kaatadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Déku néwepa dérét véte bét sanévéknwu wanévéknwuk. Yate lé déku néwaa dérét wak, “Wuna nyaan, samuké méné anat waga yo? Ané ména yaapa wale wup yate ané ménéké gege gayéba sékalék.” Naate lé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Waléka dé bérét wak, “Samuké béné wunéké sékalék? Wuné wuna yaapana gaba rawuréran wan yéknwun. Kéba rawuréranké kaapuk kutdéngbénén, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Naate wadéka bét wani kudiké las kaapuk miték kutdéngbérén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yabétka dé bét wale tépa gwaamale ye de Nasaret saabak. Saabe rate dé bétku kudi véknwute dé wabérén pulak yak. Yadéka déku néwaa wani muké léku mawuléba lé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas apa du yadéka déku mawulé yéknwun yadéka dé wupmalemu muké kutdéngék. Got, du taakwa wawo, de akwi déké yéknwun mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taibirias Romba némaan ban wupmalemu (14) kwaaré radéka aniké kwaaré Got dé Jonét kudi wakwek. Wani tulé Taibirias wekna Romba némaan ban radéka Pontias Pailat dé Judiana némaan ban dé rak. Wani tulé Yerot Galiliba rakwa du taakwaké némaan ban radéka, déku némaadu Pilip Ituriaba rakwa du taakwaké, Trakonaitisba rakwa du taakwaké wawo némaan ban radéka Laisenias Abiliniba rakwa du taakwaké dé némaan ban rak. Yadaka Anas bét Kaiapas akwi nyédé duna némaan du bét rak. Wani tulé Sekaraiana nyaan Jon du ramarék taaléba radéka Got dé dérét kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wakwedéka Jon déku kudi véknwute dé Jodan kaabélé yékwaba yeyé yeyak. Yeyé yeyate dé du taakwat kéga wakwek, “Guné yagunén kapéredi mu kulaknyénygunu wuné Gotna yéba gunat gu yaakutaknaké wunék. Guné waga kulaknyénytakne Gotna yéba gu yaakugunu dé guna kapéredi mawulé yatnyéputiké dé yo.” Naate dé Jon wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon waga yadénké déknyényba Gotna yéba kudi wakwen du déku yé Aisaia Gotna nyégaba kéga dé kavik: Du nak dé wao du ramarék taaléba. Waate dé kéga wo, “Némaan Banna yaabu kutké guné yo. Kutgunu yaabu miték kwaaké dé yo déké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Akwi kérém sérémké guné yo, yaabu dawulimarék yaduké. Akwi némaa nébu akwi makwal nébu wawo miték vaaké guné yo, yaabu waarémarék yaduké. Anygwa yan yaabu kutgunu yaabu kedéng yéké dé yo. Matu rakwa yaabu matu kéraasolagunu yaabu miték kwaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Waga yagunu akwi du taakwa véké de yo derét kutkalé yaduké Got wadén banét.” Wani aja kudi déknyényba Aisaia dé kavik. Du taakwana mawulé miték tédu, de Jisas yaadéranké miték sanévéknwudaranké, dé wani kudi kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Du taakwana mawulé miték téduké Jon dé derét kudi wakwek. Wupmalemu du taakwa Jon derét gu yaakutaknaduké yaadaka dé derét kudi wakwek. Kéga dé wak, “Guné kapéredi mawulé yakwa du taakwa guné. Got apakélé kot véknwute némaan ban raran nyaa kéni dé yao. Wani nyaa Got du taakwa yadan kapéredi muké rékaréka yaké dé yo. Wani nyaaké sanévéknwute guné, du yaawi tudaka yaage yékwa kaabe pulak, guné wunéké yaage yao. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wunéké yaamarék. Taale guné yagunén kapéredi mu kulaknyénytakne yéknwun mu male yaké guné yo. Yagunu nak du taakwa véte waké de yo, ‘De kapéredi mu kulaknyénytakne bulaa yéknwun mu de yo.’ Naate waké de yo. Guné guna mawuléba guné wo, ‘Naané Ebrayamna képmawaara naané ro. Dé Gotna méniba yéknwun mu yakwa du radék naané wawo Gotna méniba yéknwun mu yakwa du taakwa naané ro.’ Naate wate guné yénaa guné yo. Guné yéknwun mu kaapuk yagunékwa. Got mawulé yadéran dé wadu kéni matu du ye de Ebrayamna képmawaara pulak raké de yo. Ebrayamna képmawaara ragunékwaké Got kaapuk sanévéknwudékwa. Yagunékwa muké dé sanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Aja kudi nak wakweké wunék. Du sék akumarék yakwa miké sanévéknwute kwajélek kérae wani mi véléké dé yo. Véle yaaba tuké dé yo. Bulaa wani aja kudiké mé sanévéknwu. Bulaa Got déku kudi véknwumarék yaran du taakwat yadan kapéredi mu yakataké dé yo. Yakatadu de yaa yaansaakukwa taalat yéké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon waga wadéka de déku kudi véknwute wup yate de dérét waatak, “Naané samu yaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Naate wadaka dé derét wak, “Guné baapmu wut vétik yagunéran, guné baapmu wut las yamarék du taakwaké kwayéké guné yo. Guné kadému taknagunéran, guné kadému yamarék du taakwaké kwayéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wani kudi wadéka de takis nyégélkwa du las de déké yaak, dé derét gu yaakutaknaduké. Yae de dérét wak, “Némaan du, méné Gotké méné naanat yakwatnyu. Naané samu yaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naate wadaka dé derét wak, “Guné Romna gapman gunat wakwen pulak male takis nyégélké guné yo. Yate yéwaa las wawo nyégélmarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wani kudi wadéka de waariyakwa du las dérét waatak, “Naané yaga pulak? Naané samu yaké naané yo?” Naate wadaka dé derét wak, “Guné du taakwaké apa yate deku yéwaa bakna kéraamarék yaké guné yo. Guné du taakwaké yénaa kudi wakwete deku yéwaa kéraamarék yaké guné yo. Guné jébaa ye nyégélgunéran yéwaaké yéknwun mawulé yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon waga yate waga wadéka akwi du taakwa sanévéknwu wanévéknwute deku mawuléba de wak, “Jon wan naanat kutkalé yaduké Got wadén ban Krais dé, kapu yaga pulak du dé?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Naate sanévéknwudaka dé Jon derét wak, “Wuné gunat Gotna yéba gu wuné yaakutakno. Wuna kukba yaaran du wan némaan du. Wuné bakna du wuné ro. Déku apa wuna apat dé talaknak. Yaga pulak déku jébaa yaké wuné yo, wuné bakna du rawurékwa bege? Dé némaan du radéka wuné déké jébaa yaké wuné yapatiyu, wuné bakna du rawurékwa bege. Wuna kukba yaaran du Gotna Yaamabi gunéké kwayéké dé yo. Guna kapéredi mu kérae yaaba tuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Du wit kérae yéknwun wit sék kéraaké de gériyu. Géritakne de yéknwun wit sék gaba takne de apa yatjado. Yadakwa pulak wuna kukba yaaran du waga yaké dé yo. Dé déku du taakwat kérae kure ye déku gayéba takne, kapéredi mu yan du taakwat kérae yaansaakukwa yaaba yatjadaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon wani kudi du taakwat wakwete dé Gotna kudi las wawo dé wakwek, deku mawulé miték téduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galiliba rakwa du taakwana némaan ban Yerot dé déku némaadu wekna radéka dé déku taakwa kéraak. Léku yé Yerodias. Wupmalemu kapéredi mu las wawo dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yadéka Jon dérét waatidéka Yerot dé kéni kapéredi mu wawo dé yak. Dé wadéka déku du de Jonét raamény gaba taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Déknyényba Yerot Jonét raamény gaba taknadoké wamarék yadén tulé Jon déké yaan akwi du taakwat dé Gotna yéba gu yaakutaknak. Yaakutakne dé Jisasnyét wawo Gotna yéba gu yaakutaknak. Yaakutaknadéka téte Got wale kudi buldéka nyét kepukadéka dé Gotna Yaamabi nyaamiyo pulak ye dé Jisaské giyaak. Giyaadéka kudi nak Gotna gayéba dé wak, “Méné wuna nyaan. Ménéké wuné mawulat kapére yo. Ménéké wuna mawulé yéknwun dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas déku kwaaré wupmalemu (30) yadéka dé déku jébaa batnyé yak. Du taakwa de déké wak, “Wan Josepna nyaan.” Naate de wak. Josep wan Yilaina nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yilai wan Matatna nyaan. Matat wan Livaina nyaan. Livai wan Melkaina nyaan. Melkai wan Janaina nyaan. Janai wan Josepna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep wan Matataiasna nyaan. Matataias wan Emosna nyaan. Emos wan Neamna nyaan. Neam wan Eslaina nyaan. Eslai wan Nagaina nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai wan Meatna nyaan. Meat wan Matataiasna nyaan. Matataias wan Semenna nyaan. Semen wan Josekna nyaan. Josek wan Jodana nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda wan Joananna nyaan. Joanan wan Resana nyaan. Resa wan Serababelna nyaan. Serababel wan Sialtielna nyaan. Sialtiel wan Neraina nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai wan Melkaina nyaan. Melkai wan Edaina nyaan. Edai wan Kosamna nyaan. Kosam wan Elmadamna nyaan. Elmadam wan Erna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wan Josuana nyaan. Josua wan Eliesana nyaan. Eliesa wan Jorimna nyaan. Jorim wan Matatna nyaan. Matat wan Livaina nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai wan Simionna nyaan. Simion wan Judana nyaan. Juda wan Josepna nyaan. Josep wan Jonamna nyaan. Jonam wan Elaiakimna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim wan Meliana nyaan. Melia wan Menana nyaan. Mena wan Matatana nyaan. Matata wan Netanna nyaan. Netan wan Devitna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit wan Jesina nyaan. Jesi wan Obetna nyaan. Obet wan Boasna nyaan. Boas wan Salmonna nyaan. Salmon wan Nasonna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason wan Aminadapna nyaan. Aminadap wan Atminna nyaan. Atmin wan Anaina nyaan. Anai wan Yesronna nyaan. Yesron wan Peresna nyaan. Peres wan Judana nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda wan Jekopna nyaan. Jekop wan Aisakna nyaan. Aisak wan Ebrayamna nyaan. Ebrayam wan Tirana nyaan. Tira wan Neyona nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyo wan Serakna nyaan. Serak wan Reuna nyaan. Reu wan Pelekna nyaan. Pelek wan Ebena nyaan. Ebe wan Selana nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela wan Kenanna nyaan. Kenan wan Apaksatna nyaan. Apaksat wan Siemna nyaan. Siem wan Noana nyaan. Noa wan Lamekna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wan Metusalana nyaan. Metusala wan Inokna nyaan. Inok wan Jaretna nyaan. Jaret wan Mayalalelna nyaan. Mayalalel wan Kenanna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wan Inosna nyaan. Inos wan Setna nyaan. Set wan Adamna nyaan. Adam wan Gotna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gotna Yaamabi Jisasna mawuléba wulae téte apa yate wadéka dé Jodan kaabélé kulaknyénytakne dé yék. Yédéka Gotna Yaamabi dé dérét kérae kure yék du ramarék taalat. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kure yédéka dé wani taaléba wupmalemu (40) nyaa radéka dé Seten déku mawulé yaknwuk. Wani tulé dé kadému las kaapuk kadén. Yadéka wani nyaa yédéka kukba dé Jisasnyét kaadé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yadéka dé Seten dérét wak, “Méné kéga méné wo, ‘Wuné Gotna nyaan.’ Naate wate bulaa wani muké wunat wakwatnyéké méné yo. Méné waménu kéni matu walaakwe kadému yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yadu wuné ménéké kutdéngké wuné yo.” Naate wadéka dé wak, “Aya kaapuk. Wani muké kéni kudi Gotna nyégaba dé kwao: Du taakwa kadémuké male sanévéknwute de miték ramarék yaké de yo. Wani kudi véknwute matu kadému yaduké wamarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jisas wani kudi wadéka Seten dérét dé kérae kure waarék. Kure waare dé dérét kéni képmaaba tékwa akwi gayé bari wakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wakwatnyéte dé dérét wak, “Got kusékétdék kéni képmaaba tékwa akwi gayé, wani gayéba rakwa akwi du taakwa akwi gwalmu wawo wan wuna taababa de ro. Wuné wani mu duké nak kwayéké mawulé yawuréran wuné wani duké kwayéké wuné yo, dé deké némaan ban raduké. Wuné wani mu ménéké kwayéké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Méné kwati yaane wunéké waadé daate wuna yéba kevérékménéran wuné ménéké kwayéké wuné yo. Kwayéwuru méné deké némaan ban raké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naate wadéka dé wak, “Aya kaapuk. Kéni kudi Gotna nyégaba dé kwao: Ména némaan ban wan Got male. Méné déké waadé daate dérét waataké méné yo. Déku yéba male kevérékgé méné yo. Wani kudi véknwute wuné ménéké waadé daamarék yaké wuné yo. Yate ména yéba kevérékmarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas wani kudi wadéka Seten dé dérét kérae kure yék Jerusalemét. Kure waare dérét dé Gotna kudi buldakwa némaa gana madulba taknak. Takne dé dérét wak, “Méné kéga méné wo, ‘Wuné Gotna nyaan.’ Naate wate méné mé akére dawuli. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Wani muké kéni kudi Gotna nyégaba dé kwao: Got déku kudi kure giyaakwa duwat wadu de ménéké miték véké de yo. Méné deku taababa miték raké méné yo. Rate ména sépékwaapa matuba viyaamarék yaké méné yo. Ména maan wawo matuba viyaamarék yaké méné yo. Méné wani kudi véknwute akére dawuliye miték raménu akwi du taakwa véte kutdéngké de yo. Méné Gotna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naate wadéka dé wak, “Aya kaapuk. Wani muké kéni kudi Gotna nyégaba dé kwao: Got wan ména Némaan Ban. Dé apa yate ménat kutkalé yaduké méné waagété yakwa du pulak yamarék yaké méné yo. Wani kudi véknwute wuné akére dawulimarék yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Naate wadéka dé Seten nak jébaa yaduké Jisasnyét kaapuk wadén. Yate dérét kulaknyénytakne dé wak, “Nak nyaa gwaamale yaaké wuné yo. Sal nak apu dé wuna kudi véknwuké dé yo?” Naate watakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gotna Yaamabi Jisasna mawuléba téte apa yadéka dé Galilit tépa gwaamale yék. Yédéka wani képmaaba tékwa akwi gayéba de du taakwa déké kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dé Gotna kudi buldakwa gat wulae du taakwat dé Gotna kudi wakwek. Wakwedéka de akwi Jisasna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas waga yate dé Nasaretnét yék. Déknyényba makwal baadi rate dé néwepa wale wani gayét yék. Ye wani gayéba re dé némaan du yak. Ye kulaknyénytakne dé yék. Wani tulé Nasaretnét gwaamale ye dé wani gayéba rak. Rate yaap ra nyaa dé Gotna kudi buldakwa gat wulaak. Akwi yaap ra nyaa wulaadén pulak ye dé Gotna kudi buldakwa gat wulaak. Wulae re dé Gotna kudi nyégaba véte wakweké nae dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tédéka de Gotna yéba déknyényba kudi wakwen du Aisaia kavin nyéga déké kwayék. Kwayédaka laapiyakne dé vék kéni kudi kavitaknadéka. Véte dé derét kéga wakwek: ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Némaan Ban Got wunat débu wak, wuné déku kudi gwalmu yamarék du taakwat wakwewuruké. Watakne déku Yaamabi tiyaadék dé wuna mawuléba wulae tu. Got wunat débu wak, wuné yae kéni kudi derét wakwewuruké. De raamény ga pulakba kwaakwa du taakwa bulaa miték raké de yo. De méni kiyaan pulak yan du taakwa bulaa miték kutdéngké de yo. Kaagél kutkwa du taakwa tépa kaagél kutmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bulaa Némaan Ban Got du taakwat kutkalé yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas waga wakwetakne wani nyéga kusépme dé wani gaké téségékwa duké kwayék. Kwayétakne wani kudiké derét yakwatnyéké nae dé rak. Radéka wani gaba rakwa akwi du taakwa de dérét male vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Védaka dé derét wak, “Bulaa Gotna nyégaba kwaakwa kudi adél débu yak. Yadéka gunébu véknwuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Naate wadéka de wani kudi véknwute de kwagénte déku kudiké sanévéknwu wanévéknwuk. Yate de wak, “Aki. Wan yéknwun kudi dé wakweyo.” Naate watakne de wak, “Wani du wan Josepna nyaan. Yaga pulak dé wani yéknwun kudi wakweyo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","De waga wadaka dé Jisas derét wak, “Sal guné saaki wagunékwa kudi wunat kéga waké guné yo? ‘Dokta, méné ména sépat kutkalé yaké méné yo.’ Waga wate sal guné kéga wawo waké guné yo? ‘Kapaneamba yaménén jébaaké naanébu véknwuk. Yaménén pulak méné ména néwaageba rate waga male yaké méné yo.’ Naate wagunéran kudi kéga wuné kaato. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Gunat wuné wakweyo. Gotna yéba kudi wakwekwa du deku néwaageba rate kudi wakwedaka deku néwaageba rakwa du taakwa deku kudi véknwumuké kélik de yo. Adél wuné gunat wo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mé véknwu. Déknyényba Gotna yéba kudi wakwekwa du Ilaija radéka Isrelba wupmalemu dukiyaataakwa de rak. Wani tulé kwaaré kupuk baapmu las wawo radaka maas kaapuk viyaan. Yadéka akwi gayé apakélé kaadé wale de rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Radaka Got Ilaijat kaapuk wadén, dé ye Isrelba rakwa dukiyaataakwat kutkalé yaduké. Got Ilaijat dé wak, dé ye nak képmaaba rakwa dukiyaataakwat nak kutkalé yaduké. Lé Saidonba tékwa gayé déku yé Sarepatba lé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kéni kudi wawo mé véknwu. Gotna yéba kudi wakwekwa nak du déku yé Ilaisa radéka wupmalemu lepéro yan du Isrelba de rak. Radaka Ilaisa derét kaapuk kutnébuldén. Nakurak dut male dé kutnébulék. Wani du wan Siriana képmaaba yaan du nak déku yé Neman. Wan Isrelna du kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gotna kudi buldakwa gaba ran du taakwa Jisas wakwen kudi véknwutakne de kutdéngék. Jisas waga wakwete derét dé waatik. Waga kutdéngte de rékarékat kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yate raapme de Jisasnyét kulékiye gayé kulaknyénytakne kaapat tébétsagwadék. Deku gayé awuré nébuba dé nak tu. Jisasnyét tébétsagwadéte de dérét wani nébuba tén tépaat kure yék. Dérét tépaaba yatjadaké nae de dérét wanét kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kure ye waga yaké de yapatik. Dé deku nyédéba ye derét kulaknyénytakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas dé Kapaneamét dawulik. Wani gayé Galiliba dé ték. Dawuliye saabe dé rak. Rate yaap ra nyaa dé Gotna kudi buldakwa gat wulae dé du taakwat Gotna kudiké yakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Apa yate dé derét Gotna kudi wakwek. Waga wakwedéka de véknwute kwagénte de déké sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yadaka dé kutakwa kure tékwa du nak rak wani gaba. Radéka lé kutakwa némaanba waak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Waate lé wak, “Méné Nasaret ban Jisas. Méné naanat samu yaké méné yaak? Naanat yaalébaanké méné yaak, kapu yaga pulak? Wuné ménat wuné kutdéngék. Méné Gotna yéknwun du.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naate waléka dé wak, “Nyéné kudi bulmarék. Wani dut kulaknyénytakne mé yaage yé.” Naate wadéka lé wani dut takubalaakuléka dé képmaaba akérék. Akérédéka lé dérét yaalébaanmarék ye dérét kulaknyénytakne lé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yéléka akwi du taakwa véte kwagénte deku kapmu bulte de wak, “Aki. Kéni du samu kudi dé wakweyo? Dé apa yate du taakwa kure tékwa kutakwat wadéka de wani du taakwat kulaknyénytakne de yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Naate wadaka de wani képmaaba tékwa akwi gayéba Jisaské kudi wakwekéreyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas Gotna kudi buldakwa ga kulaknyénytakne dé Saimonna gat wulaak. Saimonna naakuma apakélé kiyakiya yadéka lé kwaak. Kwaaléka de Jisasnyét wak, dé yae lérét kutnébulduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wadaka wulae lé kwaan wale téte wadéka dé kiyakiya kaapuk yak. Yadéka wani taakwa bari raapme lé kadému kawu saakére deké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","41","Garabu nyaa dawulidéka yaap ra nyaa yédéka de kiyakiya yakwa du taakwa baadi, sépékwaapa kapére yan du taakwa baadi, kutakwa kure tén du taakwa baadit wawo de Jisaské kure yék. Kure yédaka dé déku taabat wani du taakwa baadit kutdéka de tépa yéknwun yak. Yadaka dé kutakwat wadéka de wupmalemu du taakwat kulaknyényék. Kulaknyényte de waak, “Méné Gotna nyaan.” Naate waate de kutdéngék. Dé Got wadén ban Krais dé. Waga kutdéngdaka dé derét némaanba wak, de wani muké kudi wakwemarék yadoké. Wadéka de yaage yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ganbaba raapme dé Jisas wani gayé kulaknyénytakne dé du ramarék taalat yék, Got wale kudi bulké. Yédéka de du taakwa déké sékalte de déké yék. Ye dérét véte de wak, “Méné naané wale raké méné yo. Nak gayét yémarék yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naate wadaka dé derét wak, “Wuné nak gayét ye Gotna kudi wakweké wuné yo, Got némaan ban rate du taakwaké védéranké. Got wani jébaa yawuruké nae wadék wuné yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naate watakne Galilina képmaa kulaknyénytakne ye dé Judiana képmaaba yeyé yeyate dé Gotna kudi buldakwa gaba Gotna kudi du taakwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nak nyaa Jisas Genesaretna kwawu nak maaléba tédéka de wupmalemu du béré taakwa béré yae jawe dé wale de ték, Gotna kudi véknwuké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Téte dé vék bot vétik kwawu maaléba rabétka. Gukwami wurékwa du taknaba bot kulaknyénytakne de laaké yakutnyék. Yakutnyédaka deku bot vétik rabétka dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Véte dé botba nak waarék. Wani bot wan Saimonna bot. Waare rate dé Saimonét wak, dé bot yaanésapmédu walkamu yéluké. Wadéka waga yadéka dé awulaga botba rate dé maaléba tén du taakwat Gotna kudiké yakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kudi wakwebutitakne dé Saimonét wak, “Bot mé nyédé kwawut kure wulae méné ména du wale guné laaké yatjade guné gukwami las wuréké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Naate wadéka dé wak, “Némaan Ban, bulaa gaan naané apa jébaa naané yak. Yate naané gukwami las kaapuk wurénan. Waménénké sanévéknwute wuné laaké tépa yatjadaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Waga watakne laaké yatjade de wupmalemu gukwami wurék. Wurédaka laaké périkgé nae dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yadéka de nak botba ran duwat waak, de yae derét kutkwedoké. Waadaka yaadaka de bot vétikba gukwami kéraasagwadék. Yadaka bét bot vétik guba dawuliké nae yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Yadéka véte wupmalemu gukwami wurédanké sanévéknwute dé Saimon Pita kwagénék. Dé wale botba ran du wawo de kwagénék. Sebedina nyaan vétik Jems bét Jon bét wawo bét kwagénék. Bét Saimon wale bét jébaa yak. Kwagénte dé Saimon Jisasna maan wale kwati yaane dé dérét wak, “Némaan Ban, méné wunat kulaknyénytakne yéké méné yo. Wuné wale ramarék yaké méné yo, kapéredi mu yakwa du rawurékwa bege.” Naate wadéka dé dérét wak, “Méné wup yamarék. Méné gukwami kutménén pulak méné wuna jébaa yate méné du taakwat kéraaké méné yo, de wuna jébaaba yaaladoké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naate wadéka de botba maalat ye maaléba tébétsawurétakne de deku akwi gwalmu kulaknyénytakne de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas ye dé gayéba nak rak. Wani gayéba lepéro yan du dé nak rak. Wupmalemu waasé dé ték déku sépéba. Wani du Jisasnyét véte dé yae kwati yaane waadé daate dé dérét wak, “Némaan Ban, wuné yéknwun yawuruké méné mawulé yaménéran méné waménu wuné yéknwun yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Naate wadéka dé dérét taabat kutte dé wak, “Wuné yéknwun yaménuké wuné mawulé yo. Méné yéknwun yaké méné yo.” Naate wadéka dé wani lepéro kaapuk yadéka dé wani du yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yadéka dé dérét wak, “Mé véknwu. Ménat yawurén muké nak duwat wakwemarék yaké méné yo. Méné Gotna kudi buldakwa gaba jébaa yakwa nyédé duké ye déku méniba téménu dé ména sépat véké dé yo. Védu méné yéknwun yaménénké méné Moses déknyényba wakwedén pulak Gotké kwaami kwayéké méné yo. Kwayéménu nak du taakwa véte lepéro kaapuk yadéka méné yéknwun yaménénké kutdéngké de yo.” Naate wadéka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisas waga yadéka gege gayéba wupmalemu du taakwa de déku apaké kudi bulék. Bulte wupmalemu du béré taakwa béré de Jisaské yaak, Gotna kudi véknwute Jisasnyét waatado dé sépékwaapa kapére yan du taakwat kutnébulduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yaadaka dé wupmalemu apu derét kulaknyénytakne dé du ramarék taalat ye waba dé Got wale kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nak nyaa dé Jisas du taakwat Gotna kudiké yakwatnyédéka de Parisina du las, apa kudiké kutdéngkwa du las, waga de rak. Wani du Galilina képmaaba tékwa akwi gayé, Jerusalem, Judiana képmaaba tékwa nak gayé wawo, wani gayéba de yaak. Yae radaka dé Némaan Ban Gotna apa Jisasna mawuléba wulae tédéka dé kiyakiya yakwa du taakwa, sépékwaapa kapére yan du taakwat wawo dé kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yadéka du las de maan taaba kapére yan dut nak jaabéba yaate yaak. Yaate yae de gat wulae Jisas ténba taknaké de mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yadaka wupmalemu du taakwa tédaka taalé dé sékéréknék. Sékérékdéka dérét kure wulaadaran yaabu kaapuk kwaan. Yadéka gaba waare de ga nak nyédé péraak. Pérae de wani du kwaadén jaabéba baagwi lékiye de wani yaabuba kusadak du taakwana nyédéba. Kusade de Jisasna méniba taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Taknadaka Jisas dé kutdéngék. De deku mawuléba de wak, dé wani dut kutnébulké apa yadéranké. Waga kutdéngte dé wani dut wak, “Wuna du, wuné yaménén kapéredi mu wunébu yatnyéputik.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas wani kudi wadéka de apa kudiké kutdéngkwa du, Parisina du wawo waga de deku kapmu bulte de wak, “Wani du wan yaga pulak? Got kapmu du yadan kapéredi mu yatnyéputiké dé yo. Wani du dé wak, ‘Wuné yadén kapéredi mu wunébu yatnyéputik.’ Naate wate dé Gorét waséléknu, bakna du bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naate wadaka Jisas deku mawulé kutdéngte dé derét wak, “Samuké guné guna mawuléba waga sanévéknwu? Waga yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Wuné Akwi Du Taakwana Nyaan kéni képmaaba rate yadan kapéredi mu yatnyéputiké wuné apa yo. Guné wani muké kaapuk kutdénggunén. Yadén kapéredi mu yatnyéputiwurénké wakwete bakna kudi wuné wakwek, kapu némaa kudi wuné wakwek? Dé raapme yéduké wawuréran wan némaa kudi wakweké wuné yo, kapu yaga pulak? Guné wuna apaké miték kutdénggunuké wuné wani kudi bulaa dérét wakweké wuné yo.” Naate watakne dé maan kapére yan dut wak, “Méné raapme ména jaabé kérae kure méné ména gat yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Naate wadéka dé akwi du taakwana méniba bari raapmék. Raapme dé kwaadén jaabé kérae Gotna yéba kevérékte dé déku gat kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yédéka véte de akwi du taakwa kwagénék. Kwagénte Gotna yéba kevérékdaka deku mawulé géndéka de wak, “Aki. Bulaa nak pulak apa mu naanébu vék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kukba Jisas ye dé vék takis nyégélén du nak takis nyégéldékwa gaba radéka. Wani duna yé Livai. Véte dé Jisas dérét wak, “Méné wuné wale mé yaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naate wadéka dé raapme akwi gwalmu kulaknyénytakne dé Jisas wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai ye dé Jisaské apakélé kadému séraknék déku gaba. Séraktakne wadéka de takis nyégélkwa wupmalemu du, kapéredi mu yakwa nak wupmalemu du, Jisasna du wawo, waga de bét wale kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kadaka de Parisina du las, deku jébaaba wulae apa kudiké kutdéngén du las, waga de Jisasna duwat waatite de wak, “Samuké guné takis nyégélén du, kapéredi mu yakwa du las wawo, de wale guné kadému gu ko?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Naate wadaka dé Jisas derét aja kudi kéga wak, “Yéknwun yakwa du taakwa doktaké kaapuk yédakwa. Sépékwaapa kapére yan du taakwa de doktaké yu. Yédaka dokta dé deku sépé kutnébulu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naate watakne dé wak, “Wuné du taakwana kapéredi mawulé wuné kutnébulu. Kapéredi mawulé yakwa du taakwa yadan kapéredi mawulé kulaknyénytakne wunéké yae wuna kudi véknwudoké wuné giyaak. Yéknwun mawulé yakwa du taakwaké kaapuk sanévéknwurén.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Du las yae de Jisasnyét wak, “Gu yaakutaknakwa du Jonna du de Got wale kudi bulké yate wupmalemu apu de kadémuké yaakéru. Yaakétte bakna rate de Got wale kudi bulu. Parisina du waga male de yo. Ména du waga kaapuk yadakwa. De akwi nyaa de kadému gu ko. Samuké ména du de kadémuké yaakétmarék yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Naate wadaka dé Jisas derét aja kudi kéga wakwek, “Du nak taakwa yaké yadu de kadému sérakne yéknwun mawulé yate kadému kaké de yo, kapu du nak wadu de kadémuké yaakétké de yo? De kaké de yo. Taakwa yaran du de wale radu de yéknwun mawulé yate kaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kukba de nak du yae wani dut kure yédo wani tulé de déku du taakwa déké mawulé lékte kadému kamarék yaké de yo. Wuné wuna du wale wekna rawuréka de yéknwun mawulé yate kadému de ko.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wani kudi watakne dé derét aja kudi vétik wawo kéga wakwek: “Du taakwa kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba kaapuk takne kétaapadakwa. De kulé baapmu wut nak taakwi kérae jégwaa baapmu wutba tékwa yaabuba takne kétaapadaran kulé baapmu wut jégwaa baapmu wut vététi gétbiyaaké bét yo. Kulé baapmu wut nak taakwi jégwaa baapmu wutba miték kwaamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Déknyény kwaaré viyae putidan meme sépéba kulé wain gu kaapuk wuknasadadakwa. Waga yadaran wani meme sépé rékaa ye jégwaa ye wukdu gu akwi yékéraké dé yo. Yékéradu wani meme sépé yéknwun yamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kulé meme sépéba wuknasadadaran kulé gu miték téké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Déknyényba yadan wain gu kakwa du taale de kulé wain gu kamuké kélik yaké de yo. Yate de wo, ‘Déknyényba yadan gu wan yéknwun.’ Naate wate de déknyényba yadan muké mawulé yo.” Waga dé aja kudi wakwek, déknyényba ran duna kudi véknwukwa du déku kulé kudiké kélik yadaranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yaap ra nyaa nak dé Jisas déku du wale de wit tékwa képmaaba nak yék. Yéte déku duwat kaadé yadéka de wit kubu las sékwe de deku taabat gérite de wit sék kak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kadaka de Parisina du las véte de derét wak, “Guné wit kubu sékwe taabat gériyu yaap ra nyaa. Naana apa kudi kéga dé wo, ‘Guné yaap ra nyaa jébaa yamarék yaké guné yo.’ Wani apa kudi kaapuk véknwugunékwa. Guné wit kubu sékwe taabat gériye guné jébaa yo, yaap ra nyaa. Wan kapéredi mu guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Naate wadaka dé derét wak, “Déknyényba naana képmawaara Devit yadén muké de Gotna nyégaba kavik. Wani kudiké guné kaapuk sanévéknwugunékwa. Déknyényba Devit déku du wale kaadé yadéka dé Gotna kudi buldakwa gat wulae wani gaba jébaa yakwa nyédé duwat dé waatak, Gotké kwayéte taknadan kadému deké kwayédoké. Waatadéka kwayédaka Devit wani kadému déku duké kwayédéka de akwi de kak. Waga yate de naana apa kudi kaapuk véknwudan. Naana apa kudi kéga dé wo, ‘Gotna gaba jébaa yakwa nyédé du male Gotké kwayédan kadému kaké de yo. Nak du wani kadému kamarék yaké de yo.’ Naate wadéka Devit déku du wale waga yadaka guné deké kéga kaapuk wagunékwa, ‘Wan kapéredi mu de yak.’ Naate wamarék yate samuké guné naanéké guné kéga wo? ‘Guné naana apa kudi véknwumarék yate kapéredi mu guné yak.’ Guné waga wate guné kaapuk miték kutdénggunén.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naate watakne dé derét wak, “Wuné Akwi Du Taakwana Nyaan wuné yaap ra nyaaké némaan ban wuné ro. Wuné du taakwana jébaaké kusékétwuru de kusékétwurén pulak yaké de yo, yaap ra nyaa.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nak apu, yaap ra nyaa dé Jisas Gotna kudi buldakwa gat wulae dé du taakwat Gotna kudiké yakwatnyék. Wani gaba yéknwun tuwa taaba léknén du dé nak rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Radéka de apa kudiké kutdéngkwa du, Parisina du wawo, wani gaba waga rate de Jisasnyét vék. Deku mawuléba de wak, “Jisas yaap ra nyaa wani dut kutnébulké dé yo, kapu kaapuk? Dérét kutnébuldéran dé naana apa kudiké kuk kwayéké dé yo. Waga yadéran naané dérét kotimké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naate wadaka déku kapmu dé deku mawulé kutdéngék. Kutdéngte dé taaba léknén dut wak, “Mé raapme méné kéba téké yo.” Naate wadéka dé raapme dé waba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tédéka dé Jisas derét wak, “Wuné gunat kudi nak waataké wunék. Naana apa kudi yaga dé wo? Yaap ra nyaa naané yéknwun mu yaké naané yo, kapu kapéredi mu yaké naané yo? Yaap ra nyaa kiyaaké yakwa du taakwat kutkalé yaké naané yo, kapu derét viyaapérekgé naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naate watakne derét nak nak vétakne dé wani dut wak, “Ména taaba mé kedéng.” Naate wadéka dé déku taaba kedéngdéka dé tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yadéka de rékarékat kapére yak. Yate de deku kapmu bulte de wak, “Naané Jisasnyét samu yaké naané yo?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wani tulé dé Jisas Got wale kudi bulké nae dé nébat waarék. Waare gaan dé Got wale kudi bulék. Wekna kudi buldéka dé yé téknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yé tékdéka nyaa yaaladéka dé déku duwat waadéka de yaak. Yaadaka dé du taaba vétik sékérékne maanba kayék vétik waga derét dé wak, de déku kudi kure yékwa du radoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Deku yé kéga. Saimon. Déké Jisas dé nak yé kwayék, Pita. Saimonna wayékna, Andru. Jems. Jon. Pilip. Batolomyu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu. Tomas. Alpiasna nyaan, Jems. Saimon. Dé déknyényba gege gayét yéte dé wak, “Nak képmaana du naanéké némaan du ramuké kélik wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemsna nyaan, Judas. Judas Iskariot. Kukba dé Jisasnyét maamaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas déku du wale dawuliye dé tépiyaa yan taaléba nak dé ték. Déku wupmalemu du dé wale tédaka wupmalemu du béré taakwa béré de wawo de ték. De Jerusalem, Judiana képmaaba tékwa nak gayé, Taia, Saidonba wawo de yaak. Taia, Saidon wawo kus maaléba bét tu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wani du taakwa las Jisasna kudi véknwuké nae de yaak. Wani du taakwa las kiyakiya yadéka las sépékwaapa kapére yadéka dé derét kutnébulduké de yaak. Wani du taakwat las kutakwa kure tédaka de wawo de yaak. Yaadaka dé wadéka yaage yédaka de wani du taakwa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yaadaka dé wadéka de kutdéngék. Jisasna apa apakélé yadéka dé derét kutnébulék. Waga kutdéngte de akwi derét taaba kutduké de mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas déku duwat véte dé derét wak, “Guné gwalmu yamarék du, guné Gotna kémba ragunéka Got némaan ban rate gunéké dé miték vu. Védékwaké guné yéknwun mawulé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Guné bulaa kaadé wale rakwa du, kukba guné wupmalemu kadému kaké guné yo. Kagunéranké guné yéknwun mawulé yaké guné yo. “Guné bulaa géraakwa du, kukba guné waagiké guné yo. Waagigunéranké guné yéknwun mawulé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mé véknwu. Wuné Akwi Du Taakwana Nyaan rawuréka guné wuna jébaaba gunébu yaalak. Du las wuna maama rate gunéké kélik yate gunéké kuk kwayéte gunat wasélékte gunat kéga waké de yo, ‘Guné kapéredi mu yakwa du.’ Naate wadaran guné yéknwun mawulé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Déknyényba wani duna képmawaara de Gotna yéba kudi wakwen duwat waga de yaalébaanék. Derét waga yaalébaandanké sanévéknwute de gunat waga yaalébaando guné yéknwun mawulé yaké guné yo. Kukba Got gunat kutkalé yaké dé yo, déku yéba kudi wakwen duwat kutkalé yadén pulak. Yadu guné dé wale miték male rasaakuké guné yo. Rasaakugunéranké guné yéknwun mawulé yate duséknét kapére yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Guné wupmalemu yéwaa yan du, bulaa guné yéknwun mu kéraabutitakne guné miték ro. Kukba kapéredi mu gunéké yaadu guné miték ramarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Guné kadému kate biyaa sékérékdéka rakwa du, bulaa guné miték ko. Kukba kapéredi mu gunéké yaadu guné kaadé wale raké guné yo. “Guné waagikwa du, bulaa guné dusék yo. Kukba kapéredi mu gunéké yaadu guné némaanba géraaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Akwi du taakwa guna yéba kevérékdo guné jérawu yaké guné yo. Déknyényba guna képmawaara yénaa kudi wakwen duna yéba de kevéréknék. Bulaa rakwa du guna yéba kevérékdo sal guné wawo yénaa kudi wakweké guné yo? Bulaa rakwa du guna yéba kevérékdaran kapéredi mu kukba gunéké yaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wani kudi watakne dé Jisas derét kéga wak, “Guné, wuna kudi véknwukwa du, gunat wuné wakweyo. Guné guna maamaké mawulat kapére yaké guné yo. Gunéké kélik yakwa duwat kutkalé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gunat kapéredi kudi wakwekwa duwat guné Gorét waataké guné yo, dé derét kutkalé yaduké. Gunat kapéredi mu yakwa duké guné Gorét waataké guné yo, dé deké yéknwun mawulé kwayéduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Du las guna ménidaamaba yéknwun tuwa saknwuba gunat viyaadaran guné kaatamarék yate walaakwe bakna téké guné yo, de guna ménidaamaba aki tuwa saknwuba viyaadoké. Du las guna baapmu wut kéraadaran guné baapmu wut las wawo deké kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Du las gunat gwalmuké waatadaran guné wani gwalmu deké kwayéké guné yo. De guna gwalmu kéraadaran guné wani gwalmu kaatadoké derét waatamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nak du gunat kutkalé yadoké mawulé yagunékwa pulak, guné derét waga kutkalé yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kapéredi mu yakwa du taakwa, yéknwun mu yakwa du taakwa, akwi du taakwa de deku du taakwaké de mawulat kapére yo. Guné guna du taakwaké male mawulat kapére yagunéran guné kapéredi mu yakwa du taakwat talaknamarék yaké guné yo. Guné waga male yagunéran Got waga yagunéranké dé ‘Wan yéknwun’ naamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akwi du taakwa kaatate de yéknwun mu yo, derét yéknwun mu yakwa du taakwat. Guné gunat yéknwun mu yakwa du taakwat male yéknwun mu yagunéran guné kapéredi mu yakwa du taakwat talaknamarék yaké guné yo. Guné waga male yagunéran Got dé waga yagunéranké dé ‘Wan yéknwun’ naamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Akwi du taakwa, kapéredi mu yakwa du taakwa wawo de nak du taakwaké gwalmu kwayéte de deku mawuléba de wo, ‘De naanéké tépa tiyaaké de yo.’ Guné waga gwalmu kwayéte wani kudi wagunéran guné kapéredi mu yakwa du taakwat talaknamarék yaké guné yo. Guné waga male yagunéran, Got waga yagunéranké dé ‘Wan yéknwun,’ naamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Guné kapéredi mu yakwa du taakwa yadakwa pulak yamarék yaké guné yo. Guné derét talakne kéga yaké guné yo. Guné guna maamaké wawo mawulat kapére yaké guné yo. Yate guné derét kutkalé yaké guné yo. Yate guné deké gwalmu kwayéte wani gwalmu tépa nyégélké sanévéknwumarék yaké guné yo. Guné waga yagunéran apat kapére yakwa ban Got gunéké waké dé yo, ‘Wuna baadi de ro.’ Naate wate gunat miték male yaké dé yo. Yadu guné miték rasaakuké guné yo. Guna yaapa Got dé mawulé léknu, déké sanévéknwumarék yate kapéredi mu yakwa du taakwaké. Dé deké mawulé lékdékwa pulak, guné wawo deké mawulé lékgé guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wani kudi watakne dé Jisas kéga wak, “Nak du taakwa yadan muké sanévéknwute guné derét waatimarék yate bari kéga wamarék yaké guné yo, ‘Wani du taakwa wan kapéredi mu yakwa du taakwa.’ Naate wamarék yagunéran Got yagunén muké sanévéknwute bari gunat waatimarék yate kéga wamarék yaké dé yo, ‘Guné kapéredi mu yakwa du guné.’ Naate wamarék yaké dé yo. Guné wani du taakwat bari wamarék yate guné de yadan kapéredi muké sanévéknwumarék yaké guné yo. Waga yagunéran Got yagunén kapéredi mu yakutnyéputiye dé wani muké tépa sanévéknwumarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Guné nak du taakwat kutkalé yaké nae deké gwalmu kwayéké guné yo. Kwayégunéran Got gunat kutkalé yate gunéké kwayéké dé yo. Kwayégunéran Got gunat kwekére kutkalé yamarék yaké dé yo. Kwayégunéran Got gunat némaanba kutkalé yaké dé yo. Kutkalé yadu guné miték male rasaakuké guné yo. Guné nak du taakwat kutkalé yagunékwa pulak Got gunat kutkalé yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wani kudi watakne dé Jisas derét kéni aja kudi wakwek, “Méni kiyaan du dé nak méni kiyaan dut yaabu wakwatnyéké dé yo, kapu kaapuk? Wan kaapuk. Dérét wakwatnyéké yédéran bét vététi waaguba akéréké bét yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sékulkwa baadi de bakna du de ro. Derét yakwatnyékwa du de deku némaan du de ro. De derét yakwatnyédo miték sékulte kukba wani baadi derét yakwatnyén du pulak némaan du raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wani aja kudi watakne dé Jisas derét kéga wakwek: “Nak du taakwa yan makwal kapéredi mu wan méniba kwaakwa mukut pulak. Yagunén némaa kapéredi mu wan méniba kwaakwa apakélé baagé pulak. Samuké guné nak du taakwana méniba kwaakwa mukut véte guné guna méniba kwaakwa apakélé baagé kaapuk végunékwa? Guné waga yate nak du taakwa yan kapéredi muké wakwete guné yagunén némaa kapéredi muké kaapuk sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Guné némaa kapéredi mu yatakne samuké guné makwal kapéredi mu yan du taakwat guné kéga wo? ‘Guné kapéredi mu gunébu yak. Guné miték ragunuké wuné gunat kutkalé yaké wuné yo.’ Waga wamarék yaké guné yo. Guné kapéredi mu yatakne waga wagunéran guné yénaa yakwa du guné ro. Taale guné yagunén némaa kapéredi muké kuk kwayéké guné yo. Kwayétakne guné makwal kapéredi mu yan du taakwat kutkalé yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wani kudi watakne dé Jisas derét kéga kudi wakwek: “Kéni aja kudi mé véknwu. Yéknwun miba kapéredi sék kaapuk akukwa. Kapéredi miba kaapuk yéknwun sék akukwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Naané miséknét véte naané kutdéngék. Samu mi wan yéknwun mi? Samu mi wan kapéredi mi? Naané kutdéngék. Raamény baagwiba naané misék kaapuk gélénakwa. Kapéredi waaraba naané yéknwun misék kaapuk gélénakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bulaa wani kudiké mé sanévéknwu. Naané miséknét véte naané kutdéngék. Wani mi wan yéknwun mi, kapu kapéredi mi? Miké kutdéngnakwa pulak, naané nak du taakwana jébaa véte naané deku mawuléké naané kutdéngék. Yéknwun du deku mawuléba yéknwun mawulé male yaaladéka de yéknwun kudi bulte yéknwun mu yo. Kapéredi du deku mawuléba kapéredi mawulé male yaaladéka de kapéredi kudi bulte kapéredi mu yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Guné wunat guné wo, ‘Méné, naana Némaan Ban méné.’ Naate wate guné wuna kudi véknwumarék yo. Samuké guné waga wate wuna kudi véknwumuké guné kélik yo? ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wunéké yaate wuna kudi véknwute wawurékwa pulak yakwa du taakwa wan kéni du pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dé yéknwun ga kaaké nae dé apakélé waagu vaak. Vaatakne matuba dé kwaat yaanék. Yaanétakne apa yan yéknwun ga dé kaak. Kaadéka maas viyaadéka kwayé kwe wani gaba sapurukléka wani ga kaapuk akérédén, apa jébaa ye yéknwun ga kaadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wuna kudi bakna véknwute wawurékwa pulak yamarék yakwa du taakwa wan kéni du pulak. Dé ga bari kaaké nae dé apa yamarék yakwa képmaaba dé kwaat bakna yaanék. Kwaat miték téduké sanévéknwumarék yate dé matuba kaapuk vaadén. Yadéka maas viyaadéka kwayé kwe wani gaba sapurukléka dé wani ga bari akérék. Akérédéka kwayé yae lé wani ga yaate yék.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas du taakwat wani kudi wakwebutitakne dé Kapaneamét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wani gayéba dé Romna waariyakwa duna némaan du nak rak. Déku jébaa yan duké nak dé mawulat kapére yak. Yadéka dé déku jébaa yan dut kiyakiya yadéka dé kiyaaké yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yadéka wani némaan du dé véknwuk Jisas wani gayéba radékwaké. Véknwutakne dé Judana némaan duwat las wadéka de Jisaské yaak, dé de wale ye déké jébaa yan dut kutnébulduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Yae de dérét wak, “Wani du dé yéknwun du dé. Dé naané Judaké dé mawulat kapére yo. Dé Gotna kudi bulnakwa ga dé kaak naanéké. Kaadénké méné déku dut kutnébulménuké naané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naate wadaka dé Jisas deku kudi véknwutakne dé de wale yék. Ye ga saabaké yadéka waariyakwa duna némaan du duwat las wadéka de yae Jisasnyét déku kudi kéga wak, “Némaan Ban, wuné bakna du wuné ro. Méné némaan ban méné ro. Waga rate méné wuna gat yaalamarék yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Waga raménékwaké sanévéknwute wuné ménéké kaapuk yaawurén. Méné bakna waménu wuna du tépa yéknwun yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nak du wunéké dé némaan ban ro. Radéka wuné wadékwa pulak wuné yo. Wuné dut nak, ‘Méné yéké méné yo,’ naawuréka dé yu. Nak dut, ‘Méné mé yaa,’ naawuréka dé yao. Wunéké jébaa yakwa dut, ‘Méné jébaa mé ya,’ naawuréka dé wani jébaa yo. Méné yawurékwa pulak yaké méné yo. Yate méné bakna waménu dé wuna du tépa yéknwun yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wani némaan duna kudi waga wadaka Jisas véknwutakne dé wani duké sanévéknwu wanévéknwuk. Yate dé walaakwe déku kukba yaan wupmalemu du taakwat dé wak, “Wani du dé wunéké miték male sanévéknwu. Wuné wawuru du taakwa yéknwun yadaranké dé kutdéngék. Guné Isrelna du taakwa, guné walkamu male guné wunéké miték sanévéknwu. Dé Romna du radéka déku yéknwun mawulé guné Isrelna du taakwa guna yéknwun mawulat débu talaknak. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Naate wadéka waariyakwa duna némaan du déku du de gat tépa gwaamale yék. Ye wulae de vék némaan duké jébaa yan du tépa yéknwun ye radéka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kukba dé Jisas nak gayét yék. Wani gayéna yé Nen. Wupmalemu du taakwa, déku du wawo, waga de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ye wani gayéna gwéspété saabaké yadaka de kiyaan kwinébé dut nak yaate yaalak. Déku néwaa dérét male lé kéraak. Nak baadi kaapuk. Léku du déknyényba dé kiyaak. Wani gayéba ran wupmalemu du taakwa de wani taakwa wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yédaka Némaan Ban Jisas véte dé mawulé léknék wani taakwaké. Lékte dé lérét wak, “Nyéné géraamarék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naate watakne ye dé kiyae kwaan duna jaabéba dé kure ték. Tédéka de jaabé yaatan du ték. Tédaka dé kiyaan dut wak, “Méné, wuna kudi mé véknwu. Méné mé raap.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naate wadéka dé kiyaan du nébéle raapme rate dé kudi bulék. Buldéka Jisas dé dérét déku néwaaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yadéka de akwi du taakwa kwagénte wup de yak. Yate de Gotna yéba kevéréknék. Kevérékte de wak, “Gotna yéba kudi wakwekwa du nak dé naané wale ro. Wan némaan du dé. Bulaa Got déku du taakwat débu kutkalé yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Naate de Jisas yan muké wakwekéreyék. Yadaka de wani gayé wale tékwa gayéba, akwi Judiana gayéba wawo de Jisaské kudi véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gu yaakutaknan du Jon raamény gaba kwaadéka déku du yae de dérét Jisas yan muké wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wakwedaka dé Jon wadéka déku du vétik yaabétka dé bérét wak, “Béné Jisaské ye béné dérét kéga waataké yo, ‘Déknyényba Gotna nyégaba de kudi kavik, naanat kutkalé yaké kukba yaaran duké. Méné wani du méné, kapu nak duké raségéké naané yo?’ Naate dérét waké béné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naate wadéka ye bét Jisas ran saabe bét wak, “Gu yaakutaknan du Jon anat wadék ané ménéké yao. Kéni kudi ménat waataké ané yao: Déknyényba Gotna nyégaba de kudi kavik, naanat kutkalé yaké kukba yaaran duké. Méné wani du méné, kapu nak duké raségéké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wani tulé dé Jisas kiyakiya yakwa wupmalemu du taakwa, sépékwaapa kapére yan wupmalemu du taakwat wawo dé kutnébulék. Kutnébule wadéka de du taakwat kure tén wupmalemu kutakwa waga de yaale yaage yék. Wupmalemu méni kiyaan du taakwat wadéka de tépa miték vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas waga yate dé Jonna du vétiknét wak, “Béné gwaamale ye béné véte véknwugunén muké Jonét wakweké yo. Méni kiyaan du taakwa tépa védaka de maan kapére yan du taakwa yéknwun ye de yeyé yeyo. Lepéro yan du taakwa yéknwun yadaka de waan waagété yadéka kudi véknwumarék yan du taakwa de kudi véknwu. Wani du taakwat wunébu kutnébulék. Wuné wawurék kiyaan du taakwa de tépa nébéle raapme ro. Gwalmu yamarék du taakwat wuné Gotna kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Du taakwa las de wunéké wo, ‘Got dérét débu wak, dé naanat kutkalé yaduké. Wan adél.’ Naate wate de wunéké miték sanévéknwu. Wunéké waga sanévéknwukwa du taakwa de yéknwun mawulé yate miték raké de yo. Waga béné Jonét wakweké yo.” Naate dé Jonna duwat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisas waga wadéka bét Jonna du vétik bét yék. Yébétka dé Jisas waba ran du taakwat Jonké kéga kudi wakwek: “Guné du ramarék taalat ye yaga pulak dut véké guné yék? Apa yamarék yate wimut kutdéka ségénkwa séwaa pulak yakwa dut véké guné yék, kapu yaga pulak? Jon wan wani mu pulak kaapuk. Jon wan apa yakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yéknwun baapmu wut kusadan dut véké guné yék, kapu yaga pulak? Jon wani du pulak kaapuk radén. Yéknwun baapmu wut kusadan du de némaan banna yéknwun gaba de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gotna yéba kudi wakwekwa dut nak véké guné yék, kapu yaga pulak? Ao, Jon wan Gotna yéba kudi wakwekwa du. Gunat wuné wakweyo. Dé némaan du dé ro. Gotna yéba kudi wakwen nak némaan duwat talakne dé némaan du dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jonké kéni kudi Gotna nyégaba dé kwao: Got déku nyaanét dé wak, ‘Kén wuna kudi kure yékwa du. Wuné wawuru dé taale yéte ména yaabu kutké dé yo.’ Naané wani kudi véknwute naané kutdéngék. Jon wan Gotna kudi kure yéte taale yaakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Waga kutdéngte gunat wuné wo. Jonna jébaa kéni képmaaba déknyényba ran duna jébaat débu talaknak. Talaknadéka dé gunat kutkalé yawuréran jébaaké kaapuk miték kutdéngdén. Yadéka de Gotna kémba rate du taakwat kutkalé yawuréran jébaaké kutdéngkwa du taakwa akwi deku yéknwun mawulé déku yéknwun mawulat débu talaknak. Wuné gunat adél kudi wuné wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wani kudi wadéka de takis nyégélkwa du waba tékwa nak du taakwa wawo wani kudi véknwutakne de yéknwun mawulé yak, Jon derét déknyényba gu yaakutaknadén bege. Yéknwun mawulé yate Gotna yéba kevérékte de wak, “Déku kudi adél kudi.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naate wadaka de Parisina du, apa kudiké kutdéngkwa du wawo de wani kudiké kélik yak, Gotna kudiké kuk kwayédaka Jon derét déknyényba gu yaakutaknamarék yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wani kudi watakne dé Jisas derét kéga wakwek, “Bulaa rakwa du taakwa yaga pulak de? Gunat wakweké wunék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bulaa rakwa du taakwa de ameba kutkwa baadi pulak de ro. De kutte de nak baadit wao. Waate de wo, Naané gwaaré waate kaang viyaanaka guné kaapuk kétigunén. Naané mawulé lékte géraanaka guné kaapuk géraagunén. Guné naané wale nakurak mawulé kaapuk yagunén. Waga waakwa baadi pulak, bulaa rakwa du taakwa de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“De Jon wale nakurak mawulé kaapuk yadan. De wuné wale nakurak mawulé kaapuk yadakwa. Gu yaakutaknan du Jon yae kagunékwa kadému kamarék yate kagunékwa wain gu kaapuk kadén. Yadéka guné déké kélik yate guné wo, ‘Kutakwa déku mawuléba wulae téléka dé waagété yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Naate wagunéka wuné Akwi Du Taakwana Nyaan yae kagunékwa kadému kate kagunékwa wain gu wuné ko. Kawuréka guné wunéké kélik yate guné wo, ‘Mé vé. Wani du wupmalemu kadému kate wupmalemu wain gu dé ko. Kate dé takis nyégélkwa du wale rate, kapéredi mu yakwa nak du taakwa wale rate dé de wale kudi bulu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Naate wagunéka wuné nak kudi wuné wo. Got dé akwi muké kutdéngék. Déku paaté wan yéknwun paaté. Wan adél. Wani kudiké sanévéknwute guné ané déku duké miték sanévéknwuké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisina du nak déku yé Saimon Jisasnyét dé wak, dé yae dé wale kadému kaduké. Wadéka yae wani duna gat wulae rate dé kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Parisina duna gaba rate kadékwaké lé wani gayéba rate kapéredi mu yakwa taakwa nak lé kudi véknwuk. Véknwutakne lé matut yadan makwal agérap kure yaak. Wani agérapba yéknwun yaama yakwa gu dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kure yae lé Jisasna maan wale kwati yaanéte lé géraak. Géraaléka dé léku méniba giyaan gu Jisasna maanba akérék. Akérédéka lé léku maaknaba tén sémény nébat yatnyék. Yatnyétakne wupmale apu lé déku maanba taama vék (daama réngék). Yate lé yéknwun yaama yakwa gu lé déku maanba sévik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Séviléka Jisasnyét waadéka yaan Parisina du véte dé déku mawuléba kéga wak, “Wani du Gotna yéba kudi wakwekwa du radu mukatik dé akwi muké kutdéngte dérét kutkwa taakwaké kutdéngdu. Lé kapéredi mu yakwa taakwa ralékwaké dé kutdéngdu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wani kudi wadéka Jisas dé dérét wak, “Saimon, wuné ménat nak kudi wakweké wuné mawulé yo.” Naate wadéka dé wak, “Naanat Gotna kudiké yakwatnyékwa ban, méné mé wakwe.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naate wadéka dé kéni aja kudi wakwek: “Du vétik bét nak duwat yéwaa bakna nyégélék. Nak du dé wupmalemu yéwaa nyégélék (100 kina). Nak du dé walkamu yéwaa nyégélék (10 kina). Nyégélbétka kukba dé raségék, wani yéwaa kwayékatabéruké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wani du vétik bét déku yéwaa kwayékataké bét yapatik. Yabétka dé bérét wak, ‘Dékumuk. Tiyaakatamarék yaké béné yo.’ Naate wadénké méné yaga méné sanévéknwu? Wani du vétik kiyadé yéwaa kwayén duké mawulat kapére yaké yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naate wadéka dé Saimon wak, “Wupmalemu yéwaa nyégélén du. Waga wuné sanévéknwu.” Naate wadéka dé wak, “Wan adél kudi méné wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wani kudi watakne Jisas wani taakwaké walaakwe dé Saimonét wak, “Kéni taakwat mé vé. Wuné ména gat yaalawuréka méné naana apa kudi wadékwa pulak kaapuk yaménén. Yate méné gu las kaapuk tiyaaménén, wuna maan yakutnyéwuruké. Kéni taakwa lé léku ménegwat wuna maan lébu yakutnyék. Yate lé léku nébat lébu yatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Méné wunat kaapuk taama véménén (daama réngménén). Wuné kéba yaale taale rawuréka wani taakwa yae lé wuna maanba taama vék (daama réngék). Wupmale apu lé waga yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Méné wuna maaknaba yéknwun gu kaapuk séviménén. Lé yéknwun yaama yakwa gu wuna maanba lébu sévik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Waga yalék wuné ménat wo. Yalén wupmalemu kapéredi mu wunébu yatnyéputik. Yatnyéputiwurék lé wunéké mawulat kapére yo. Du taakwa walkamu kapéredi mu yadaka wuné wani kapéredi mu yatnyéputiwuréka de wunéké walkamu mawulé de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wani kudi watakne dé wani taakwat wak, “Yanyénén kapéredi mu wunébu yatnyéputik.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naate wadéka de dé wale rate kadému kan du deku kapmu bulte de wak, “Wani du dé yalén kapéredi mu yatnyéputiyu. Wan yaga pulak du dé?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naate wadaka dé Jisas wani kudi kaatamarék yate dé wani taakwat wak, “Nyéna kapéredi mawulé kutnébulwurékwa apaké miték sanévéknwunyénék wuné nyéna mawulat wunébu kutnébulék. Bulaa yéknwun mawulé yate miték yéké nyéné yo.” Naate dé lérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kukba Jisas dé wupmale gayéba yeyé yeyak. Yeyé yeyate dé du taakwat Gotna kudi wakwek, Got némaan ban rate du taakwaké miték védéranké. Déku du taaba vétik sékét maanba kayék vétik waga de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Taakwa wawo de las dé wale yék. Déknyényba wani taakwa lasnyét dé kiyakiya yak. Lasnyét kutakwa de kure ték. Yadaka Jisas wani taakwat akwi dé kutnébulék. Wani taakwa deku yéwaa kwayéte kadému kérae sérakne de Jisas déku duké wawo kwayék. Wani taakwa nak wan Maria. Léké de wak Makdalaba yaan taakwa Maria. Déknyényba kutakwa nak taaba sékét nak taababa kayék vétik lérét kure tédaka, Jisas wadéka de lérét kulaknyénytakne yaage yék. Nak taakwa wan Yerotna gaké téségén du déku yé Susa déku taakwa. Léku yé Joana. Nak taakwa wan Susana. Taakwa las wawo waga de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wupmalemu du béré taakwa béré de Jisaské yae jawuk. Wani du taakwa wupmalemu gayéba de yaak. Yaadaka dé derét kéni aja kudi wakwek: ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Du nak dé déku képmaaba wit sék yaatnyéké nae dé yék. Ye yaatnyédéka de wit sék las yaabuba de akérék. Akérédaka du taakwa yeyé yeyate de yaabuba ran wit sékba akik. Akidaka de api yae kérae de kak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wit sék las matuba de akérék. Walkamu képmaa male dé waba ték. Matuba akére buréle waarédaka mégi miték kutmarék yadéka képmaa yépidéka de bari rékaa ye de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit sék las de raamény waara ténba akérék. Akére radaka raamény waara wure dé kakutapmék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit sék las de yéknwun képmaaba akérék. Akére waba re de miték wurék. Wure de wupmalemu yéknwun sék akuk.” Naate watakne dé Jisas wak, “Guné kutdéngké mawulé yate waan kwekére miték véknwuké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas wani kudi wadéka de déku du wani aja kudiké dérét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Waatadaka dé derét wak, “Got némaan ban rate du taakwaké miték véké dé yo. Védu de déku kémba raké de yo. Wani muké déknyényba Got dé kudi paakuk. Paakutakne dé kusékéru, guné bulaa wani muké kutdénggunuké. Nak du taakwa kutdéngmarék yaké de yo. Véte miték vémarék yaké de yo. De kudi véknwute de wani kudiké kutdéngmarék yaké de yo. Yadaranké derét wuné aja kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bulaa wani aja kudiké wakweké wunék. Wani wit sék wan Gotna kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Du taakwa las de Gotna kudi debu véknwuk. Véknwudaka Seten yae dé wani kudi deku mawuléba kérae kure yu. De Gotké miték sanévéknwute Gotké yédakwa yaabuba yémuké kélik yate dé wani kudi kérae kure yu. Kure yédéka de wani kudiké yékéyaak yo. Wani du taakwa wan yaabuba akérén wit sék pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Du taakwa las de Gotna kudi bari véknwu. Véknwute wani kudiké yéknwun mawulé yate dusék takwasék de yo. Yate de kaapuk miték sanévéknwudakwa. Wani kudi deku mawuléba dawulimarék yadéka de kaapuk miték sanévéknwudakwa. Yadaka kapéredi mu las deké yaadéka de Gotna kudi bari kulaknyényu. Wani du taakwa wan matuba akérén wit sék pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Du taakwa las taale de Gotna kudi miték véknwu. Véknwute de kéni képmaana muké male sanévéknwudaka deku mawulé yéwaa gwalmu kéraaké dé génu. Wani mu dé Gotna kudit taknatépu. Taknatépédéka de wani du taakwa Gotna jébaa kaapuk yadakwa. Wani du taakwa wan raamény waara ténba akérén wit sék pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Du taakwa las de Gotna kudi miték véknwute wadékwa pulak yate de déku kudiké mawulat kapére yo. Yate déku kudi miték véknwusaakute yéknwun mawulé yate Gotké yéknwun jébaa de yasaaku. Wani du taakwa wan yéknwun képmaaba akérén wit sék pulak.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wani kudi watakne dé Jisas wak, “Kéni aja kudi mé véknwu. Du téwayé sérakne kure yae sapgutaknadan awu gwaléba de takno, kapu jaabé gwaléba de takno? Wan kaapuk. De jaabé takuba de takno, wani gat wulaaran du wani téwayé yaante kayénarédu miték védoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Paakwe rakwa mu kukba véké guné yo. Akélak wakwedan kudi kukba kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wani kudiké mé sanévéknwu. Guné miték sanévéknwe wuna kudi miték véknwuké guné yo. Wuna kudi miték véknwukwa du taakwa kukba Gotna kudiké miték kutdéngké de yo. Wuna kudi miték véknwumarék yakwa du taakwa de wo, ‘Naané Gotna kudi naanébu kutdéngék.’ Naate watakne kukba de déku kudiké yékéyaak yate bakna raké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wani tulé Jisasna néwaa déku wayéknaje wawo de déké yaak. Yaadaka wupmalemu du taakwa gat wulae sékérékne tédaka de dé ténét wulaaké de yapatik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yapatidaka du las de dérét wak, “Ména néwaa, ména wayéknaje yae kaapaba téte de ménat véké de mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naate wadaka dé derét wak, “Gotna kudi véknwute wadékwa pulak yakwa du taakwa wan wuna néwaa, wuna wayéknaje pulak de ro.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nyaa nak dé Jisas déku du wale de botba nak waarék. Waare dé derét wak, “Naané kwawu nak saknwat yéké naané yo.” Naate wadéka de botba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yéte dé Jisas widé kwaak. Kwaadéka némaa wimut kutdéka dé gu raapme waare botba gwaade dé sékérékgé yak. Yadéka yalakgé de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yate ye Jisasnyét waaséligénte de dérét wak, “Némaan du, kén naané yalaknu.” Naate wadaka ligéne raapme wadéka wimut kaapuk yadéka dé gu dawuliye dé miték ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tédéka dé derét wak, “Samuké wuné gunat kutkalé yawuréran apaké guné kaapuk miték sanévéknwugunén?” Naate wadéka de wup yate kwagénte deku kapmu bulte de wak, “Aki. Dé wadéka dé wimut gu déku kudi véknwute wadékwa pulak dé yo. Wan yaga pulak ban dé?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisas déku du wale botba ye de Gegesana képmaa saabak. Wani taalé kwawu nak saknwuba tédéka Galilina képmaa nak saknwuba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Saabe bot kulaknyénytakne kwawu maaléba yéké yadaka wani gayéba yaan du nak dé Jisasnyét véké yaak. Déknyényba kutakwa de wani dut kure tédaka dé waagété débu yak. Yate dé baapmu wut las kaapuk gidén. Bakna dé rak. Wupmalemu baapmu waga male dé rak. Dé gaba kaapuk radén. Dé du taakwa kiyaadaka rémdan taaléba male dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Dérét kure tén kutakwa wupmalemu apu de dérét viyaak. Viyaadaka dé waagété yadéka du las déku maan taaba apa baagwit de gik. Giye déké de téte vék. Védaka dé wani baagwi périkdéka de kutakwa du ramarék taalat dérét kure yék. Wani du dé Jisasnyét véké yaak. Yaadéka dé Jisas wak, dérét kure tén kutakwa yaage yédoké. Wadéka dé dérét vétakne némaanba waate dé dérét kwati yaane waadé daate dé wak, “Jisas, méné awuréba rakwa ban Gotna nyaan. Méné wunat samu yaké méné yo? Wuné ménat wuné waato. Méné wunat kaagél tiyaamarék yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naate wadéka dé dérét wak, “Ména yé yaga?” Naate wadéka dé wak, “Wuna yé Wupmalemu.” Naate dé wak, wupmalemu kutakwa kure tédakwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wani kutakwa de Jisasnyét wak, “Naané kapéredi taalat yémuké naané kélik yo. Ménat naané waato. Naané wanét yénoké méné wamarék yaké méné yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wani nébuba wupmalemu baalé de, de tén wale téte, kadému kak. Kadaka de wani dut kure tén kutakwa Jisasnyét wak, “Méné naanat kéléké mawulé yaménéran méné waménu naané wani baaléna mawuléba wulaaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Naate wadaka dé derét wak, “Guné wanét mé yaage yégunu.” Waga wadéka de wani dut kulaknyénytakne ye de wani baalat kure ték. Kure tédaka wani baalé némaa tépaaba yaage dawuliye guba akére gu ke de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wani baaléké téségén du waga yadaka vétakne de yaage yék. Ye de akwi gayéba ran du taakwat wani muké wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wakwedaka de du taakwa wani mu véké de yék. Ye Jisas tén saabe de kutakwa kulaknyénytakne yén dut de vék. Dé baapmu wut gitakne yéknwun mawulé yate Jisasna maan wale radéka de vék. Véte de wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yadaka Jisas wani mu yadéka vén du taakwa de derét kudi wakwek, kutakwa kure tén du yéknwun yadénké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wakwedaka Gegesana képmaaba ran akwi du taakwa wupmét kapére yate de Jisasnyét wak, dé derét kulaknyénytakne yéduké. Wadaka dé Jisas derét kulaknyénytakne yéké yate dé botba waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Waarédéka dé déknyényba kutakwa kure tén du dé dérét wak, “Wuné méné wale yéké wuné mawulé yo.” Naate wadéka dé Jisas dérét wak, “Méné ména gayét gwaamale ye méné Got ménat yan muké kudi wakweké yo.” Naate wadéka ye dé déku gayéba ran akwi du taakwat Jisas dérét yan muké dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas kwawu nak saknwat gwaamale ye saabadéka akwi du taakwa dérét véte de dusék takwasék yak, déké raségédan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Yadaka du nak déku yé Jairas dé Jisaské yék. Dé némaan du dé rak, wani gayéba kwaakwa Gotna kudi buldakwa gaba. Dé ye kwati yaane Jisasnyét waadé daate dé dérét wak, “Wuna takwanyan kiyaamale yaké lék. Léku kwaaré wupmalemu kaapuk (12). Wuné baadi nakurak male. Méné wuné wale yaaké méné yo, lérét kutnébulké.” Naate wadéka dé dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Jisas yaabuba yédéka de wupmalemu du taakwa dé wale yék. Yédaka yaabu dé sékéréknék. Yadéka lé taakwa nak déku kukba yae lé déku baapmu wutna waabuba kurék. Wupmalemu (12) kwaaré wény yaaladéka lé rak. Yadéka wupmalemu apu déknyényba wani taakwa lé doktaké yék, de lérét kutnébuldoké. Ye de lérét kutnébulké de yapatik. Yapatidaka wani taakwa Jisaské kudi véknwute lé léku mawuléba wak, “Wuné Jisasna baapmu wutba taaba kutwuréran wuné tépa yéknwun yaké wuné yo.” Naate watakne lé déku kukba yae lé déku baapmu wutna waabuba kurék. Wani taakwa waga kutléka dé wény bari kaapuk yadéka lé yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yaléka dé Jisas wak, “Kiyadé wunat kurék?” Naate wadéka de akwi wak, “Naané kaapuk.” Waga wadaka dé Pita wak, “Némaan Ban, wupmalemu du taakwa de méné wale tu. De las ménat bakna de kurék, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naate wadéka dé Jisas wak, “Kaapuk. Nak ban wunat apa kéraaké nae dé wunat kurék. Yadéka wuna apa las yédéka wuné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naate wadéka lé wani taakwa kutdéngék. Jisas dé léké kutdéngék. Waga kutdéngte lé génte yae lé Jisas tén wale képmaaba kwati yaane waadé daak. Daate akwi du taakwana méniba lé kéga wak, “Wupmalemu (12) kwaaré wunat wényét kapére yadéka wuné tépa yéknwun yaké nae wuné ména baapmu wutba taaba kurék. Kure wuné bari tépa yéknwun yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Naate waléka dé lérét wak, “Nyéna, wuné nyénat kutnébulwuréran apaké miték sanévéknwute bulaa nyénébu yéknwun yak. Nyéné yéknwun mawulé yate miték yéké nyéné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wekna téte kudi buldéka dé du nak Jairasna gaba dé yaak. Yae dé wani némaan dut wak, “Ména takwanyan lébu kiyaak. Méné waménu wani némaan ban yaamarék yate déku nak jébaa yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Naate wadéka dé Jisas wani kudi véknwute dé Jairasnyét wak, “Méné wup yamarék. Méné wuné lérét kutkalé yawuréran apaké miték sanévéknwuménu ména takwanyan yéknwun yaké lé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naate watakne dé ye wani duna ga saabe dé wak, “Pita, Jon, Jems, béné léku néwepa wawo, guné kapmu wuné wale wulaaké guné yo. Nak du taakwa de wulaamarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Naate wadéka waba tén akwi du taakwa wani takwanyanké mawulé lékte de téte géraak. Géraadaka dé derét wak, “Guné géraamarék yaké guné yo. Lé kaapuk kiyaalén. Lé bakna widé lé kwao.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Naate wadéka de dérét waagik, kiyaalénké kutdéngdan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Waagidaka dé wulae léku taababa kutte dé lérét wak, “Nyéné mé raap.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naate wadéka léku wuraanyan tépa gwaamale yaadéka lé bari raapmék. Raapléka dé Jisas derét wak, “Kadému las kwayégunu lé kaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naate wadéka bét léku néwepa lérét véte bét kwagénte yéknwun mawulé yak. Yabétka dé bérét wak, “Béné nak du taakwat wani muké wakwemarék yaké béné yo.” Naate dé léku néwepat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas déku duwat waadéka yaadaka dé deké apa kwayék, de wado akwi kutakwa yaage yédoké. Deké nak apa wawo dé kwayék, de kiyakiya yan du taakwa sépékwaapa kapére yan du taakwat wawo kutnébuldoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kwayétakne dé derét wak, “Guné ye du taakwat Got némaan ban rate deké miték védéranké kudi wakweké guné yo. Yate guné derét kutnébulké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naate watakne dé derét kéga wakwek, “Guné yeyé yeyate wupmalemu gwalmu kure yémarék yaké guné yo. Guné kusadagunén mu male kwaadu yéké guné yo. Sétogunékwa baagé, wut, kadému, yéwaa, wani mu kure yémarék yaké guné yo. Baapmu wut vétik kure yémarék yaké guné yo. Guné du taakwat kutkalé yagunu de gunat kutkalé yate wani mu gunéké kwayéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Guné gat nak wulae wani gaba male raké guné yo. Guné kés ga nak gat yégunu taale ragunén gaba rakwa du wani muké rékaréka yamuké guné taale wulaagunén gaba male raké guné yo. Re wani gayéba jébaa yatakne wani ga kulaknyénytakne nak gayét yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Guné gayét nak yégunu wani gayéba rakwa du taakwa guna kudi véknwumarék yate, gunéké kuk kwayédaran, guné wani gayé kulaknyényké guné yo. Kulaknyényké yate guna maanba kwaakwa bawusa yatputétakne guné yéké guné yo. Guné waga yagunu de véte waké de yo, ‘Naané derét kapéredi mu naanébu yak. Kukba Got yanan kapéredi mu naanat yakataké dé yo.’ Naate waké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naate wadéka ye de gege gayéba yeyé yeyak. Yeyé yeyate Gotna kudi wakwete de kiyakiya yan du taakwa, sépékwaapa kapére yan du taakwat wawo de kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Galilina képmaaba rakwa du taakwana némaan ban Yerot dé Jisas yadén jébaaké kudi véknwuk. Dé déku jébaa yadéka de du taakwa las de déké kéga wak, “Gu yaakutakne kiyaan du Jon débu tépa nébéle raapmék.” Wadaka las de wak, “Wan déknyényba ran du Ilaija.” Las de wak, “Gotna yéba kudi wakwen nak du déknyényba kiyae bulaa débu tépa nébéle raapmék.” Naate wadaka Yerot wani kudi dé véknwuk. Véknwudéka déku mawulé kapére yadéka dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yate dé wak, “Wuné wawuréka de Jonna maakna tépaknék. Bulaa nak duké wuné kudi véknwu. Wani du wan kiyadé?” Naate wate dé Jisasnyét véké dé mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisasna du gwaamale yae de Jisasnyét yadan akwi muké wakwek. Wakwedaka dé derét kwole wani taalé kulaknyénytakne de deku kapmu Betsaidat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yédaka wupmalemu du béré taakwa béré wani muké kudi véknwute de déku kukba yék. Ye déké yaadaka dé véte deké yéknwun mawulé yate dé derét kudi wakwek, Got némaan ban rate du taakwaké miték védéranké. Wakwetakne dé kiyakiya yan du taakwat kutnébulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Garabu yadéka de déku du déké yae de wak, “Kén du ramarék taalé. Méné waménu kéni du béré taakwa béré de gege gayét ye kadému las kérae katakne de kwaaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naate wadaka dé derét wak, “Guné deké kadému kwayéké guné yo.” Naate wadéka de wak, “Naané wupmalemu kadému kaapuk. Makwal béret naktaba guba kutdan gukwami vétik waga male dé ro. Naané ye wani du taakwaké akwi kadému las kéraanoké méné mawulé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Naate de wak, wupmalemu (5,000 pulak) du waba radan bege. Wupmalemu taakwa wupmalemu baadi wawo waba de rak. Jisasna du waga wadaka dé derét wak, “Guné derét wagunu de kémba kémba (50 pulak 50 pulak) raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naate wadéka de wadén pulak yadaka de akwi du taakwa kémba kémba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Radaka dé Jisas béret naktaba gukwami vétik waga kérae nyérét kwaasawuré véte dé Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne dé béret gukwami bule dé déku duké kwayék, de du taakwaké munikwedoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Munikwedaka de akwi du béré taakwa béré mitékne kak. Kadaka béret gukwami las radéka de kébi taaba vétik sékét maanba kayék vétik waga de laakwak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nak nyaa dé Jisas Got wale kudi bulte dé kapmu dé rak. Radéka de déku du déké yaak. Yaadaka dé derét waatak, “Du taakwa wunéké yaga de wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Naate waatadéka de wak, “Ménéké las de wo, ‘Wan gu yaakutaknan du Jon.’ Las de wo, ‘Wan déknyényba rate Gotna yéba kudi wakwen du Ilaija.’ Las de wo, ‘Gotna yéba kudi wakwen nak du déknyényba kiyae débu nébéle raapmék.’ Naate de wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naate wadaka dé derét wak, “Guné yaga pulak? Guné wunéké yaga guné wo?” Naate wadéka dé Pita dérét wak, “Méné naanat kutkalé yaménuké Got wadén ban Krais méné.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita waga wadéka dé Jisas déku duwat wak, “Mé véknwu. Guné nak duwat kéga wamarék yaké guné yo, ‘Jisas wan naanat kutkalé yaduké Got wadén ban Krais.’ Waga wamarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naate watakne dé derét wak, “Wuné Akwi Du Taakwana Nyaan wuné ro. Wunat kapéredi mu yado kubu du, Gotna gaba jébaa yakwa nyédé duna némaan du, apa kudiké kutdéngkwa du waga de wunat kuk tiyaaké de yo. Tiyaado wunat viyaapérekdo kiyaaké wuné yo. Kiyaawuru nyaa kupuk yédu Got wadu wuné tépa nébéle raapké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wani kudi watakne dé derét kéga wakwek, “Guné wuné wale yaate wuna jébaa yaké mawulé yagunéran kéga yaké guné yo. Akwi nyaa guné guna mawulé kulaknyényké guné yo. Kulaknyénye guné wunéké sanévéknwute kéga waké guné yo, ‘Naané déku jébaa kutsaakuké naané yo. Yate naané kaagél kutte miba kiyaanaran wan bakna mu. Némaa mu kaapuk.’ Naate wate wuna jébaa kutké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wunéké sanévéknwukwa du taakwa wuna jébaa kutsaakudo wuna maama derét viyaapérekdaran de wuné wale miték rasaakuké de yo apuba apuba. Wunéké sanévéknwumarék yakwa du taakwa deku sépéké male sanévéknwute deku jébaa male yadaran de kiyae yalakgé de yo. Wuné wale rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Du taakwa kéni képmaana gwalmu akwi kéraaké sanévéknwute, deku jébaa male yadaran, kiyae yaga pulak de miték rasaakuké de yo? Kaapuk. Miték rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Du taakwa wuna kudiké kélik yate wunéké kuk tiyaadaran kukba wuné Akwi Du Taakwana Nyaan gwaamale yae deké kuk kwayéké wuné yo. Wani tulé wuné wuna yaapat apa kérae déku kudi kure giyaakwa duwat wawo apa kérae nyaa vékwa pulak rate giyaaaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gunat wuné wakweyo. Guné kéba tékwa du las kiyaamarék yate wekna rate véké guné yo, Got némaan ban rate déku du taakwaké miték védu.” Naate dé déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kukba nyaa nak taaba sékét nak taababa kayék kupuk pulak yédéka dé Jisas Pita, Jon, Jemsnyét wawo waga kwole de nébat waarék. Jisas Got wale kudi bulké mawulé yate dé nébat waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waare rate Got wale kudi buldéka déku ménidaama walaakwe dé nak pulak yak. Yadéka déku baapmu wut waamat kapére yate dé kayénarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yadéka déknyényba rate Gotna yéba kudi wakwen du Moses bét Ilaija, Gotna gayéba bari giyae bét apa yate nyaa vékwa pulak téte Jisas wale kudi de bulék. Dé Gotna kudi véknwute Jerusalemba rate kiyaadéranké de kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Buldaka Pita dé wale yaan du vétik deku méni widé yadéka de widé kwaak. Kwae ligéne raapme de vék Jisasna sépé nyaa pulak védéka wani du vétik dé wale tébétka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Védaka bét yéké yabétka dé Pita miték kutdéngmarék yate dé Jisasnyét wak, “Némaan Ban, naané kéba ranakwa wan yéknwun. Naané ga kupuk kaaké naané yo. Ménéké nak, Moseské nak, Ilaijaké nak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naate wadéka buwi nak giyae dé derét taknatépék. Taknatépédéka de wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yadaka dé kudi nak wani buwiba gwaade dé wak, “Kén wuna nyaan. Wuné dérét wawurék dé gunéké yék. Guné déku kudi mé véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wani kudi wadéka véknwutakne de vék Jisas kapmu tédéka. Véte kudi las kaapuk buldan. Yate wani tulé védan muké akwi duwat kaapuk wakwedan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nak nyaa kulaknyénytakne giyaadaka de wupmalemu du béré taakwa béré Jisaské yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yae de wale yaan du nak dé némaanba waak, “Némaan du, wuné ménat wuné waato, méné wuna du nyaanét véménuké. Wuné nyaan nakurak male. Nak baadi kaapuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kutakwa nak dérét kure téte dérét viyaaléka dé némaanba gureknu. Yadéka lé dérét yaalébaanléka dé waama sépmeny déku kudiba yaalo. Déku sépé yaalébaante lé dérét kulaknyénytakne yémuké kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yaléka wuné ména duwat waatak, de wado wani kutakwa yaage yéluké. Waatawuréka de waga yaké de yapatik.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Naate wadéka dé Jisas wak, “Yaga pulak? Guné wunéké kaapuk miték sanévéknwugunékwa. Guna mawulé kaapuk miték tékwa. Wuné wupmalemu baapmu guné wale rawuréka guné wunéké kaapuk miték sanévéknwugunékwa. Méné ména nyaanét mé kure yaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naate wadéka wani nyaan wekna yaadéka lé wani kutakwa dérét viyaate takubalaakuléka dé képmaaba akérék. Akérédéka dé Jisas wani kutakwat waatite dé lérét wak, lé wani nyaanét kulaknyénytakne yaage yéluké. Wadéka yaage yéléka nyaan yéknwun yadéka dé Jisas dérét dé déku yaapaké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yadéka de waba tén du taakwa wani jébaa vétakne Gotna apaké sanévéknwu wanévéknwute de akwi kwagénék. Wani du taakwa Jisas yadén akwi muké wekna sanévéknwu wanévéknwudaka dé Jisas déku duwat kudi dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kéga dé wak, “Guné guna waan kwekére miték mé véknwu. Kukba de wuné Akwi Du Taakwana Nyaanét maamaké kwayédo wuné deku taababa raké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Naate wadéka Got wakwedéka de wani kudiké las kaapuk miték kutdéngdan. Yate de wani kudiké Jisasnyét waatamuké wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisasna du deku kapmu bulte deku némaan banké de waaruk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Waarudaka dé Jisas deku mawulé kutdéngte dé nyaanét nak kure yaadéka dé wale dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tédéka dé derét wak, “Mé véknwu. Guné wunéké sanévéknwute kéni nyaanét kutkalé yate guné wunat wawo guné kutkalé yo. Guné wunat kutkalé yate guné wunat wadéka yaawurén banét wawo guné kutkalé yo. Guné wale rate déku yéba kevérékmarék yate gunéké jébaa yaran ban Gotna méniba dé némaan ban dé ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas wani kudi wadéka Jon dé dérét wak, “Némaan ban, du nak ména yéba kutakwat wadéka yaage yédaka naané vék. Dé naané wale kaapuk yeyé yeyadékwa. Yadéka naané dérét wak, wani jébaa yamarék yaduké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naate wadéka dé Jisas dérét wak, “Guné wani jébaa yamarék yaduké dérét waatimarék yaké guné yo. Gunéké kuk kwayémarék yakwa du wan guna du de ro.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Got Jisasnyét déku gayét kure waarédéran tulé yaaké yadéka dé Jisas déku mawuléba sanévéknwute dé Jerusalemét yéké mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yate duwat las wadéka de taale déku kudi kure yék. Ye de Sameriaba tékwa gayéba nak wulaak, déké gwalmu kawu saakéraké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yadaka de wani gayéba rakwa du taakwa Jisas Jerusalemét yédéranké de kutdéngék. Kutdéngte de déké kélik yate de wak, “Kaapuk. Dé naana gayéba yaalamarék yaké dé yo.” Naate de wak, Sameriana du taakwa Judana du taakwa, deku némaa gayé Jerusalemké wawo kélik yadakwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wadaka Jisasna du vétik Jemés bét Jon véte bét Jisasnyét wak, “Némaan Ban, méné mawulé yaménéran ané watu dé Gotna gayéba yaa giyae dé wani du taakwat yaanké yo. Ané waga watuké méné mawulé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Naate wabétka dé walaakwe dé wak, “Kaapuk. Waga yamarék yaké béné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naate watakne dé déku du wale de nak gayét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas déku du wale yaabuba yédaka dé du nak yae dérét wak, “Wuné méné wale yeyé yeyaké wuné mawulé yo. Yéménéran akwi taalat wuné wawo yéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naate wadéka dé déku mawuléba dé wak, “Wani du wadén pulak yaké dé yo kapu kaapuk?” Naate sanévéknwute dé dérét wak, “Miték mé sanévéknwu. Kwatbosa de képmaaba tékwa waaguba de kwao. Api deku kwaatba de kwao. Wuné Akwi Du Taakwana Nyaan kwaawuréran ga nak kaapuk tékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naate watakne dé nak dut wak, “Méné wuné wale yaaké méné yo.” Naate wadéka dé wak, “Némaan Ban, méné kusékétménéran taale wuné ye rawuru wuna yaapa kiyaadu wuné déku gaaba ségwi kérae rémké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Naate wadéka dé dérét wak, “Aya. Bulaa wuné wale mé yaa. Wuna kudi véknwumarék yakwa du taakwa de kiyaan du taakwa pulak de ro. Wani du taakwa kiyaan du taakwat rémké de yo. Méné bulaa wuna jébaa yate ye du taakwat kudi wakweké méné yo, Got némaan ban rate deké miték védéranké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naate wadéka dé nak du Jisasnyét wak, “Némaan Ban, wuné méné wale yéké wuné yo. Méné kusékétménéran taale wuné wuna gayét ye wuna kémét taaba kutké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naate wadéka dé dérét wak, “Du taakwa Gotké jébaa batnyé yate kukba kés jébaa nak jébaaké sanévéknwudaran de Gotna jébaa yaké de yapatiké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kukba dé Jisas wupmalemu (72) duwat las wawo wadéka de yaak. Yaadaka dé derét wak, “Guné vétik vétik waga taale yéké guné yo. Wuné kukba yéwuréran akwi gayét guné taale yéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naate watakne dé derét wak, “Kadému yaanannan képmaaba wupmalemu kadému ak yate dé tu. Tédéka walkamu du male de jébaa yo. Ak yan kadému wan Gotna kudi véknwuké mawulé yaran du taakwa pulak. Got wan képmaana bapadu pulak. Guné Gorét waataké guné yo, dé wadu wupmalemu jébaa yakwa du las wawo guné wale jébaa yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bulaa gunat wuné wakweyo, wuna jébaa yagunuké. Kwatbosa sipsipmét yaalébaandakwa pulak, du las gunat yaalébaanké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Guné yéwaa, wut wawo kure yémarék yaké guné yo. Su kusadamarék yaké guné yo. Guné yaabuba yéte bari yéké guné yo. Nak du taakwa wale kudi bulké bakna témarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Guné gat nak wulae taale guné waba rakwa du taakwat kéga waké guné yo, ‘Gunéwa rakwa. Yéknwun mawulé yaké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Naate wagunu waba rakwa du taakwa gunéké yéknwun mawulé yadaran Got derét kutkalé yadu de miték raké de yo. Waba rakwa du taakwa gunéké yéknwun mawulé yamarék yate gunéké kuk kwayédaran, Got derét kutkalé yamarék yaké dé yo. Got gunat kutkalé yadu guné miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Guné taale wulaagunén gaba male raké guné yo. Kés ga nak gat wulaamarék yaké guné yo. Wani gaba rate de kwayéran kadému gu kaké guné yo. Wani kadému gu nyégélké guné yo, de wale yagunéran jébaaké. Wani gaba re kukba yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Guné gayét nak wulaagunu waba raran du taakwa gunéké yéknwun mawulé yadaran guné kwayédaran kadému kaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yate gayéba kiyakiya ye raran du taakwat kutnébulké guné yo. Yate derét waké guné yo, ‘Got némaan ban rate du taakwaké miték védéran tulé kéni dé yao.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","“Guné gayét nak wulaagunu wani gayéba rakwa du taakwa gunéké kélik yadaran guné ye wani gayéna yaabuba téte guné kéga waké guné yo, ‘Naané gunéké naané kuk kwayu. Got wawo gunéké dé kuk kwayu. Kuk kwayédékwaké guné kutdénggunuké naané kéni gayéba rakwa bawusa naana maanba kwaadéka yatputétaknanaka guné vu. Guné kéni muké kutdéngké guné yo. Got némaan ban rate du taakwaké miték védéran tulé kéni dé yao. Yaadéka guné déku kémba wulaamuké guné kélik yo.’ Naate guné derét waké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wani gayéba rakwa du taakwaké wuné gunat wakweyo. Déknyényba Sodomba ran du taakwa de kapéredi mu yak. Kukba Got apakélé kot véknwute némaan ban raran nyaa dé wadu Sodomba ran du taakwa kaagél kutké de yo. Du taakwa naanéké kuk tiyaadaran wani nakurak kapéredi mu Sodomba ran du taakwa yadan kapéredi mat talaknaké dé yo. Wani nyaa Got wadu naanéké kuk tiyaaran du taakwa apakélé kaagél kutké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wani kudi watakne dé Jisas kéga wakwek: “Kape du taakwa, guné Korasinba rakwa du taakwa. Kape du taakwa, guné Betsaidaba rakwa du taakwa. Wuné guna gayéba rate wuné apa jébaa wuné yak. Yawuréka guné vék. Véte guné Gotké kaapuk miték sanévéknwugunén. Taiaba déknyényba ran du taakwa, Saidonba déknyényba ran du taakwa wawo, Gotké kutdéngmarék ye wani apa jébaa védo mukatik, déknyényba de yadan kapéredi muké kélik yate, wani kapéredi mu kulaknyénykatik de yak. Yadan kapéredi muké kélik yate nak du taakwa deku mawuléké kutdéngdoké de jégwaa baapmu wut kusade bawuba rakatik de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kukba Got apakélé kot véknwute némaan ban raran nyaa dé wadu de Taiaba déknyényba ran du taakwa, Saidonba déknyényba ran du taakwa wawo, de kaagél kutké de yo. Guné Korasinba rakwa du taakwa, Betsaidaba rakwa du taakwa wawo, guné wuna jébaa véte guné wunéké kuk tiyaak. Kuk tiyaagunéka wani nakurak kapéredi mu de yan akwi kapéredi mat débu talaknak. Wani nyaa Got wadu guné apakélé kaagél kutké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Guné Kapaneamba rakwa du taakwa, guné saaki guné wo, ‘Naané Gotna gayét waaréké naané yo.’ Naate wagunéka gunat wuné wo. Got wadu guné kapéredi taalat dawuliké guné yo. Guné Gotna gayét waarémarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wani kudi watakne dé déku duwat kéga wak, “Guna kudi véknwuran du taakwa de wuna kudi véknwuké de yo. Gunéké kuk kwayéran du taakwa de wunéké kuk tiyaaké de yo. Wunéké kuk tiyaaran du taakwa de wunat wadéka giyaawurén banké kuk kwayéké dé yo.” Naate wadéka déku kudi wakweké de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kukba wani wupmalemu (72) du Jisasna jébaa ye yéknwun mawulé yate de gwaamale yaak. Yae de dérét wak, “Némaan Ban, naané ména yéba wanaka de akwi kutakwa naana kudi véknwuk. Véknwutakne du taakwat kulaknyénytakne de yaage yék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Naate wadaka dé derét wak, “Guné waga yagunéka nyét kulabidéka yaa giyaadékwa pulak, Seten awuréba rate giyaadéka wuné vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mé véknwu. Wuné gunéké apa wunébu kwayék. Kwayéwurén guné kaabe kulamagat wawo akigunu de gunat yaalébaanmarék yaké de yo. Kwayéwurén guna apa Setenna apat talaknaké dé yo. Talaknadu dé gunat yaalébaanmarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Akwi kutakwa guna kudi véknwudaka guné wani muké yéknwun mawulé guné yo. Wani muké guné sanévéknwu wanévéknwumarék yaké guné yo. Kéni muké mé sanévéknwu. Guné Gotna kémba yaalagunéka dé guna yé déku nyégaba débu kavik. Wani muké sanévéknwute guné yéknwun mawulé yate dusék yaké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wani tulé dé Gotna Yaamabi Jisasna mawuléba wulae tédéka dé yéknwun mawulé yate dé wak, “Méné wuna yaapa, méné nyét képmaaké némaan ban méné ro. Ména jébaaké las paakuménéka wupmale muké kutdéngkwa du taakwa ména jébaaké kaapuk miték kutdéngdan. Wupmale muké kutdéngmarék yakwa du taakwa, deku mawulé baadina mawulé tékwa pulak tédéka kwatkwa radaka derét ména jébaa ménébu wakwatnyék. Ména mawuléba sanévéknwute ménébu waga yak. Waga yaménén wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Naate Gorét watakne dé wak, “Wuna yaapa dé wunéké déku jébaa apa wawo débu tiyaak. Wuné déku nyaan rawuréka de du taakwa wunéké kaapuk miték kutdéngdan. Dé male dé wunéké kutdéngék. Du taakwa déké kaapuk miték kutdéngdan. Wuné male wuné déké kutdéngék. Déké wakwewurén du taakwa wawo de déké kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Wani kudi wadéka déku du male dé wale radaka dé deké walaakwe dé derét wak, “Gunat wunébu wakwek Gotna jébaaké. Gotna yéba déknyényba kudi wakwen du némaan du wawo de yawuréka végunékwa jébaa véké mawulé yate de kaapuk védan. Yate de wakwewuréka véknwugunékwa kudi véknwuké mawulé yate de kaapuk véknwudan. Got gunat kutkalé yadéka guné wani jébaa gunébu vék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wani kudi wadéka dé apa kudiké yakwatnyékwa du nak déku mawuléba dé wak, “Jisas wuna kudi kaatate sal kapéredi kudi waké dé yo?” Naate sanévéknwute dé dérét wak, “Gotna jébaaké naanat yakwatnyékwa du, wuné samu ye kulé mawulé kérae apuba apuba miték rasaakuké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naate waatadéka dé dérét wak, “Samu kudi guna apa kudiba dé kwao? Gotna nyégaba yaga de kavik?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naate wadéka dé wak, “Guné guna Némaan Ban Gotké mawulat kapére yaké guné yo. Yate guné dérét wagunu dé guna sépé, guna apa, guna mawulé, guna wuraanyan, guna yaamabiké dé némaan ban raké dé yo. Guné guna sépéké mawulat kapére yagunékwa pulak, nak du taakwaké mawulat kapére yaké guné yo. Yate derét kutkalé yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Naate wadéka dé dérét wak, “Wan miték méné wo. Méné waga yaménéran méné kulé mawulé kérae apuba apuba miték rasaakuké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas waga wadéka wani du dé mawulé yak, nak du taakwa déku yéba kevérékdoké. Yate dé Jisasnyét waatak, “Yani du taakwat kutkalé yaké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas déku kudi kaatate dé kéni kudi wakwek: “Judana du nak Jerusalem kulaknyénytakne dé Jerikot dawuliké nae yaabuba yék. Yédéka de sél yakwa du dérét yaabuba vék. Véte dérét kulékiye déku gwalmu kéraate de dérét némaanba viyaak. Viyaatakne yédaka dé yaabuba kwae dé kiyaaké yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yadéka wani tulé dé Gotna gaba jébaa yakwa nyédé du nak wani yaabuba yék. Ye wani dut vétakne yaabuna nak saknwuba yéte dérét talaknatakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yédéka dé Gotna gaba jébaa yakwa nak du Livaina kémna du nak ye dérét vétakne dé wawo dérét kulaknyénytakne yaabu nak saknwuba dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yédéka dé Sameriana du nak wani yaabuba ye dé wani du kwaan saabak. Guné kutdéngék. Judana du de Sameriana duké de kélik yo. Sameriana du saabe Judana du waba kwaadéka véte dé déké mawulé léknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mawulé lékte déké ye viyaadanba waasé yakutnyétakne marasin kavitakne dé gik. Gitakne dé wani dut kérae déku donkiba taknadéka dé rak. Radéka dé yaabuba yéte gaan yadéka yéwaa kwayéte kwaadakwa gat nak kure ye dé waba dérét kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yate gaan kwae ganba yéte yéwaa las wani gana bapaduké kwayéte dé dérét wak, ‘Méné kéni duké miték véké méné yo. Yate wani dut kutkalé yaké, ména yéwaa las kwayéménéran wuné gwaamale yae ména yéwaa kaataké wuné yo.’ Naate watakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Bulaa yaga méné sanévéknwu? Du kupuk de wani yaabuba yék. Ye kiyadé sél yakwa du viyaadan dut kutkalé yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naate wadéka dé wak, “Déké mawulé léknén du dé dérét kutkalé yak.” Naate wadéka dé dérét wak, “Méné ye méné waga male yaké yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Jisas déku du wale de yék. Ye gayét nak de wulaak. Wani gayéba taakwa nak léku yé Mata, léku wayékna Maria wale bét rak. Rate lé Mata Jisasnyét wak, dé yae bétku gaba kadému kaduké. Waléka wulae radéka léku wayékna Maria yae lé Némaan Ban Jisasna maan wale rate lé déku kudi véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Véknwuléka lé Mata wupmalemu jébaa yate lé kadému kawu saakérak. Yate Maria bakna raléka véléka léku mawulé kaapuk miték yan. Yadéka lé Mata Jisaské yae lé dérét wak, “Némaan Ban, wuna wayékna bakna raléka wuné kapmu jébaa yate kadému wuné séraknu. Yawurékwaké méné sanévéknwu, kapu kaapuk? Méné lérét waménu lé yaalu ané kadému sérakgé ané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Naate waléka dé Némaan Ban lérét wak, “Nyéné, Mata, nyéné wupmalemu gwalmuké nyéné sanévéknwu wanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nyéné kéni nakurak yéknwun muké kaapuk sanévéknwunyénékwa. Wuna kudi véknwunyénéran mu wan yéknwun mu. Maria wani yéknwun muké lé mawulé yo. Yalu wuné lé yéluké wamarék yaké wuné yo. Lé wuna kudi véknwuké lé yo.” Naate dé Jisas Matat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nak nyaa Jisas nak taaléba dé Got wale kudi bulte rak. Kudi bulbutitakne radéka dé déku du nak yae dé dérét wak, “Déknyényba gu yaakutaknan du Jon dé déku duwat yakwatnyék, Gorét waatadaranké. Derét yakwatnyédén pulak méné naanat yakwatnyéké méné yo, Gorét waatanaranké. Waga yaménuké naané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naate wadéka dé dérét wak, “Guné Gorét waataké mawulé yate kéga waké guné yo: Naana yaapa, naané ména yéba kevérékgé naané mawulé yo. Méné némaan ban rate akwi du taakwaké miték véménuké naané mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akwi nyaa yapatinakwa kadému tiyaaménuké naané ménat waato. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Du taakwa naanat kapéredi mu yadaka naané wani muké tépa kaapuk sanévéknwunakwa. Yano méné yanan kapéredi mu yatnyéputiye méné wani muké tépa sanévéknwumarék yaké méné yo. Méné naanat kutkalé yaménu naané kapéredi mu tépa yamarék yaké naané yo. Waga naané ménat waato.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Watakne dé derét kéga wak, “Sal guna du nak kéga yaké dé yo? Du nak gaan yadéka nyédé gubés dé déku duké yék. Ye dé gana gwésba téte dé waak, ‘Wuna du, wunéké kadému las tiyaaké méné yo. Bulaa wuna du nak dé nak gayét yéké yate yaabuba yéte dé wuna ga saabak. Saabadéka wuna kadému las kaapuk rakwa. Méné wunéké kadému las tiyaaménu wuné kukba kwayékataké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naate waadéka dé awula gaba ran du wak, ‘Bulaa wani muké wunat waatamarék yaké méné yo. Gwés wunébu tépék. Wuna baadi wuné wale widé de kwao. Bulaa wuné raapme ménéké kadému kwayémarék yaké wuné yo.’ Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gunat wuné wakweyo. Dé ‘Wuna du’ naate, dé raapme kadému déké kwayémarék yaké dé yo. Wani du déku gwésba téte waasaakudu dé widé kwaaké mawulé yate, dé raapme wani du mawulé yadékwa kadému déké kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Gunat wuné wakweyo. Guné Gorét waatasaakugunéran dé gunéké kwayéké dé yo. Kéni aja kudi mé véknwu. Guné sékalte sékalte véké guné yo. Guné gwésba viyaasaakugunéran gwés naapiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Du taakwa Gorét waatadaran dé deké akwi kwayéké dé yo. Du taakwa sékalte sékalte de akwi véké de yo. Du taakwa gwésba viyaadaran gwés naapiké dé yo. Guné wani aja kudi véknwute guné Gorét waatasaakuké guné yo. Waatagunu dé guna kudi véknwuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kéni kudi wawo mé véknwu. Guné yaapa, guna baadi gukwami kwayégunuké wado, guné kaabe kérae kwayéké guné yo, kapu yaga pulak? Wan kaapuk. Guné deké gukwami kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Guna baadi séraa gék kwayégunuké wado guné kulamagu kérae kwayéké guné yo, kapu yaga pulak? Wan kaapuk. Guné deké séraa gék kwayéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bulaa wani kudiké mé sanévéknwu. Guné kapéredi mawulé yakwa du rate guné guna baadiké yéknwun mu guné kwayu. Awuréba rakwa ban guna yaapa yéknwun mawulé yakwa du rate gunat talakne déku Yaamabi kwayéké dé yo, dérét waatakwa du taakwaké.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kutakwa dut nak kure téléka dé kudi kaapuk buldén. Yadéka Jisas wani kutakwat wadéka lé wani dut kulaknyénytakne lé yaage yék. Yaage yéléka dé tépa kudi bulék. Buldéka de du taakwa wani muké sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yadaka de du las wak, “Jisasna mawuléba akwi kutakwana némaan ban déku yé Bielsebul dé wulae tu. Téte apa kwayédéka dé wadéka de kutakwa yaage yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naate wadaka las de dérét wak, “Méné déknyényba vémarék yanan apa jébaa nak yaménu naané véte kutdéngké naané yo, Got déku jébaa yaménuké ménat wadénké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Naate wadaka Jisas deku mawulé kutdéngte dé derét wak, “Kéni kudi mé véknwu. Némaa gayéba rakwa du mawulé vétik yate kémba kémba rate waariyadaran de rasaakumarék yaké de yo. Nakurak gaba rakwa du taakwa mawulé vétik yate deku kapmu waariyadaran de wawo rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wani kudiké sanévéknwute akwi kutakwana némaan ban Seten déku du waleké mé sanévéknwu. De mawulé vétik yate deku du taakwa wale waariyadaran de rasaakumarék yaké de yo. Guné wunat wagunén pulak Seten déku du taakwa yaage yédoké wadéran de rasaakumarék yaké de yo. Seten waga jébaa kaapuk yadékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Guné wunéké kéni kudi guné wo. Akwi kutakwana némaan ban Bielsebul wuna mawuléba téte wunéké apa tiyaadéka wuné wawuréka de kutakwa yaage yu. Wan yénaa kudi guné wo. Guna du las de wawo wadaka de kutakwa yaage yu. Guna du waga yadaka guné derét kéga kaapuk wagunékwa, ‘Bielsebul guna mawuléba téte apa kwayédéka guné wagunéka de kutakwa yaage yu.’ Derét waga wamarék yate samuké guné wunat wani kudi guné wo? Wuné de wale nakurak jébaa yawuréka de de kutdéngék. Guné wunéké yénaa kudi guné wo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mé véknwu. Got wunéké apa dé tiyao. Tiyaadéka wuné kutakwat wawuréka de yaage yu. Got wunéké waga apa tiyaadénké guné véte kutdéngké guné yo. Got némaan ban rate du taakwaké miték védéran tulé débu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","“Kéni kudi mé véknwu. Apa yakwa du waariyadékwa mu kure déku gaké téségédéran déku gwalmu akwi miték raké dé yo. Radu apat kapére yakwa du nak yae wani du wale waariye déku vi waariyadékwa nak mu wawo kérae déku gwalmu wawo kéraaké dé yo. Kérae dé wani gwalmu nak duké munikweké dé yo. Seten wani apa yakwa du pulak. Wuné apat kapére yakwa du pulak. Wuna apa Setenna apat débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Wuné wale jébaa yamarék yakwa du taakwa de wuna maama de ro. Wuné du taakwat wawuréka de wuna kémba de ro. Wuna du taakwat kutkalé yamarék yakwa du taakwa de wuna du taakwat yaalébaanu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wani kudi watakne dé Jisas derét kéga wakwek, “Kéni kudi mé véknwu. Kutakwa ye lé nak duna mawuléba wulae te kulaknyénytakne lé yék. Maas viyaamarék yakwa taaléba yeyé yeyate raléran taaléké lé sékalék. Sékalpatiye lé wak, ‘Wuné déknyényba rawurén gat gwaamale yéké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Naate watakne gwaamale yae lé vék wani duna mawulé yéknwun ye bakna tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Vétakne ye lé kutakwa nak taaba sékét nak taababa kayék vétiknét kwole yaak. Kwole yaalén kutakwa yadan kapéredi mu taale yaan kutakwa yalén kapéredi mat débu talaknak. Wani kutakwa akwi de wani duna mawuléba wulae ték. Déknyényba nakurak kutakwa déku mawuléba wulae téléka dé wani du walkamu kapéredi mu dé yak. Wupmalemu kutakwa déku mawuléba wulae tédaka dé wupmalemu kapéredi mu yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas wani kudi wakwedéka de dé wale tén wupmalemu du taakwa wani kudi véknwuk. Véknwute lé taakwa nak némaanba kéga dérét waak, “Déknyényba ménat kérae ménéké munyaa kwayén taakwat Got kutkalé yadu lé yéknwun mawulé yate miték raké lé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naate waléka dé Jisas wak, “Wan adél. Wani muké sanévéknwumarék yate kéni muké mé sanévéknwu. Gotna kudi véknwute wadékwa pulak yaran du taakwat Got kutkalé yadu de yéknwun mawulé yate miték male raké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wupmalemu du béré taakwa béré yaate jawudaka dé derét kéga wakwek, “Kéni tulé rakwa du taakwa kapéredi mu de yasaaku. Wunat de waato, wuné déknyényba vémarék yadan apa jébaa yate Gotna apaké derét wakwatnyéwuruké. Gotna yéba kudi wakwen du Jona yadén apa jébaa pulak male yaké wuné yo. Nak apa jébaa deké yamarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Déknyényba Jona Ninivat ye dé yadan kapéredi muké derét kudi wakwek. Jona yadén pulak wuné yo. Wuné Akwi Du Taakwana Nyaan wuné kéni tulé rakwa du taakwat yadan kapéredi muké kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Déknyényba némaa taakwa nak, séknaa képmaaba yae lé némaan ban Solomonna kudi véknwuké lé séknaa yaabuba yék. Dé yéknwun mawulé pukaakwa du radéka wuné kéba téte guné wale kudi bulkwa du wuné yéknwun mawulé pukaakwa du rate Solomonét wunébu talaknak. Kukba Got némaa kot véknwute némaan ban radéran tulé wani némaa taakwa raapme Gotna méniba téte lé gunat waké lé yo, ‘Wuné séknaa saaknaba wuné yaak. Yae Solomonna kudi wuné véknwuk. Jisasna kudi Solomonna kudit débu talaknak. Guné Jisasna kudi kaapuk véknwugunén. Waga yate némaa kapéredi mu guné yak.’ Waga wani taakwa waké lé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Déknyényba Ninivaba ran du taakwa de Jonana kudi véknwutakne yadan kapéredi mu de kulaknyényék. Jona némaan du radéka wuné kéba téte kudi bulkwa du wuné némaan ban rate Jonat wunébu talaknak. Kukba Got némaa kot véknwute némaan ban radéran tulé Ninivaba ran du taakwa Gotna méniba téte de gunat waké de yo, ‘Jona naanat Gotna kudi wakwedéka naané véknwute yanan kapéredi mu kulaknyénytakne naané Gotna kudi miték véknwuk. Jisas Jonat talakne gunat Gotna kudi wakwedéka guné yagunén kapéredi mu kulaknyénymarék yatakne guné Gotna kudi kaapuk véknwugunén. Waga yate guné némaa kapéredi mu yak.’ Naate waké de yo gunat.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wani kudi watakne dé derét kéga wakwek, “Kéni aja kudi mé véknwu. Du téwayé sérakne kure yae sapgutaknadan awu gwaléba kaapuk paakutaknadakwa. De jaabéba de akutakno. Akutaknadaka waba rakwa akwi du taakwa de miték vu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guna méni wan gaba tékwa gwés pulak. Wani gwés naapidaka gaba nyaaka dé yo. Guné yéknwun mu male végunéran guna mawulé miték téké dé yo. Yadu guna sépé miték tédu guné nyaakaba raké guné yo. Guné kapéredi mu male végunéran guna mawulé miték témarék yaké dé yo. Guna mawulé miték témarék yadéran guna sépé miték témarék yadu guné gaankétéba raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Guné waga ramuké guné jérawu yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Guna mawulé miték male tédéran guné nyaakaba male rate yéknwun mu yate miték male raké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas wani kudi wakwebutidéka dé Parisina du nak dérét wak, dé yae dé wale kadému kaduké. Wadéka dé yae déku gat wulae dé wale kaké nae dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Radéka dé Parisina du vék. Védéka dé deku apa kudi wadén pulak déku taaba taale yakutnyémarék yadéka dé sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yadéka dé Némaan Ban Jisas dérét wak, “Guné Parisina du, guné awu yakutnyéte kapasaknwu male guné yakutnyu. Yaalésaknwu kaapuk yakutnyégunékwa. Yagunéka yaalé kapéredi dé yo. Guné guna sépéké sanévéknwute wupmalemu gwalmu nak du taakwat bakna nyégéle wupmalemu kapéredi mu las wawo yagunéka guna mawulé kapéredi dé yo, wani awuna yaalésaknwu kapéredi yadékwa pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Guné waagété yakwa du guné. Got guna sépé kuttakne guna mawulé wawo dé kuttaknak. Waga yadénké guné kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Guné yéknwun mawulé yate gwalmu yamarék du taakwaké gwalmu kwayéké guné yo. Kwayégunu guna mawulé miték téké dé yo Gotna méniba. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Guné Parisina du, kapéredi mu gunéké yaaké dé yo. Guné akwi gwalmu muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne guné nakurak tabé Gotké kwayu. Waga kwayéte guné akwi kutjo wawo muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne guné nakurak tabé Gotké guné kwayu. Kutjo wan némaa mu kaapuk. Wan makwal mu. Guné wani makwal muké sanévéknwute guné kéni némaa muké kaapuk sanévéknwugunékwa. Guné nak du taakwat kutkalé yaké guné yo. Guné Gotké mawulat kapére yaké guné yo. Guné guna gwalmu muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne nakurak tabé Gotké kwayégunékwa wan yéknwun. Wani mu kulaknyénymarék yaké guné yo. Wani makwal mu yate wakwewurén némaa mu wawo yagunu mukatik miték yakatik guné yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Guné Parisina du, gunéké kapéredi mu yaaké dé yo. Guné Gotna kudi bulnakwa gat wulae némaan duna taaléba raké guné mawulé yo. Guné du taakwa jawudakwa taaléba yeyé yeyagunu nak du taakwa gunat véte kéga wadoké guné mawulé yo: ‘Wan naana némaan du dewa yaakwa.’ Naate wadoké guné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Gunéké kapéredi mu yaaké dé yo. Guné déknyényba kiyaadaka rémdan waagu pulak. Kukba ran du wani waagu tékwa képmaa takuba yeyé yeyate rémdan waaguké kutdéngmarék yadakwa pulak, nak du taakwa guna kapéredi mawuléké kaapuk kutdéngdan. Yate de guné wale tu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas wani kudi wakwedéka dé apa kudiké kutdéngkwa du nak dé dérét wak, “Némaan du, méné waga wate naanat wawo méné waatiyu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naate wadéka dé kéga wakwek, “Guné apa kudiké kutdéngkwa du, gunéké wawo kapéredi mu yaaké dé yo. Du nak wupmalemu apakélé mu yaatadéka nak du yae las wawo akutaknedékwa pulak, guné apa jébaa las wawo du taakwaké guné kwayu. Kwayéte derét guné kéga wakweyo, ‘Guné kéni apa kudi akwi véknwute wadékwa pulak yaké guné yo.’ Naate wagunéka de wani kudi véknwute wadékwa pulak yaké apakélé jébaa de yo. Yadaka guné deké mawulé lékmarék yate derét kutkalé kaapuk yagunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Gunéké kapéredi mu yaaké dé yo. Déknyényba guna képmawaara de Gotna yéba kudi wakwen duwat viyaapéreknék. Yadaka guné rémdan taaléba yéknwun mu takno. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Guna képmawaara viyaapérekne rémdan duna taaléba waga yéknwun mu takne guné wo, ‘Naana képmawaara yadan muké naané kusékéru.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Naate wagunékwaké yéknwun mawulé pukaakwa ban Got dé wak, ‘Wuné wuna yéba kudi wakwekwa du wuna kudi kure yékwa duwat wawo wawuru de Isrelna du taakwaké yéké de yo. Yédo lasnyét yaalébaante lasnyét viyaapérekgé de yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Naate wadéka waga yadaka guné kutdéngék. Déknyényba guna képmawaara Gotna yéba kudi wakwen duwat de viyaapéreknék. Taale Ken déku wayékna Ebelét dé viyaapéreknék. Got kéni képmaa kuttakne walkamu radéka Ken dé Ebelét viyaapéreknék. Viyaapérekdéka de guna képmawaara viyaapérekgére ye ye kukba de Sekaraiat viyaapéreknék. Dé Gotna gana nyédéba tédéka de dérét viyaapéreknék. Viyaapérekdanké bulaa guné kéni tulé rakwa du gunat wuné wakweyo. Got yadan kapéredi muké sanévéknwute guné deku képmawaara waga kapéredi mu yagunénké wawo sanévéknwute gunat némaanba yakataké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Guné apa kudiké kutdéngkwa du, gunéké kapéredi mu yaaké dé yo. Guné Gotké yédakwa yaabuké walkamu guné kutdéngék. Kutdéngte guné wani yaabuba yémuké guné kélik yak. Yate guné wani yaabuba yéké mawulé yakwa du taakwat waatigunéka de wani yaabuba kaapuk yédan.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Watakne yédéka de apa kudiké kutdéngkwa du Parisina du wawo deku mawuléba de wak, “Sal dé naana kudi kaatate kapéredi kudi las waké dé yo? Wadu naané dérét kotimké naané yo.” Naate wate dérét waatite de wupmalemu kudi dé wale bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wupmalemu du béré taakwa béré yae jawe tédaka taalé dé sékéréknék. Yadéka las de las duna maanba akik. Akidaka dé Jisas déku duwat taale kéni kudi wak, “Jérawu yaké guné yo. Parisina duna yis kutmarék yaké guné yo. Wani kudi wakwete wuné yénaa yadakwa kudiké wuné wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Paakudan mu kukba wupmalemu du taakwa de véké de yo. Akélak wakwedan kudi kukba wupmalemu du taakwa véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Guné gaan rate bulgunén kudi du taakwa nyaa véknwuké de yo. Guné gaba rate akélak bulgunén kudi kukba kaapaba wakwedo akwi du taakwa kutdéngké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wuna du, gunat kéga wakweké wunék. Guné képmaaba rakwa duké wup yamarék yaké guné yo. De gunat viyaapérekne kukba gunat yaalébaanké yapatiké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Guné awuréba rakwa ban Gotké wup yaké guné yo. Képmaaba rakwa du gunat viyaapérekdo Got gunat yaa yaansaakukwa taalat yatjadaké dé apa yo. Yadékwaké sanévéknwute guné déké wup yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Guné kutdéngék. Du taakwa makwal yéwaa vétik kwayéte de api naktaba kérao. Wani api wan makwal mu male. Got wani apiké dé sanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Got gunéké wawo dé sanévéknwu. Akwi muké dé kutdéngék. Guna maaknaba tékwa nébé akwi naaknwe wani muké wawo dé kutdéngék. Kutdéngte dé gunéké miték vu. Védékwaké sanévéknwute guné wup yamarék yaké guné yo. Api wan makwal mu. Du taakwa wan némaa mu. Got makwal apiké waga miték véte gunéké miték male véké dé yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Watakne dé derét wak, “Gunat wuné wakweyo. Du las wupmalemu du taakwana méniba téte nak nak kéga wadaran, ‘Wuné Jisasna du.’ Naate wadaran kukba wuné Akwi Du Taakwana Nyaan Gotna gayéba rate déku kudi kure giyaakwa duna méniba téte wuné derét waké wuné yo, ‘Kéni du wan wuna du.’ Naate waké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Du las wupmalemu duna méniba téte nak nak kéga wadaran, ‘Wuné Jisasna du kaapuk.’ Naate wadaran wuné Gotna gayéba rate déku kudi kure giyaakwa duna méniba téte wuné derét waké wuné yo, ‘Wani du wan wuna du kaapuk.’ Naate waké wuné yo derét. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Wuné Akwi Du Taakwana Nyaan wuné ro. Du taakwa wunat wasélékte wunéké kapéredi kudi wakwetakne, wani kapéredi kudiké kélik ye kulaknyénydaran, Got wani kapéredi mu yatnyéputiké dé yo. De wasélékte Gotna Yaamabiké kapéredi kudi wakwedaran Got wani kapéredi mu yatnyéputimarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Du las gunat Gotna kudi buldakwa gat kure yéte, némaan duké wawo kure yédo, guné deku méniba téte, guné wup yamarék yate, guna mawuléba kéga wamarék yaké guné yo, ‘Naané samu kudi wakweké naané yo? Deku kudi yaga pulak kaataké naané yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Waga wamarék yaké guné yo, wani tulé Gotna Yaamabi wakwegunéran kudi gunat wakwedéran bege.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jisas wale wupmalemu du taakwa de ték. De wale tén du nak dé Jisasnyét wak, “Némaan du, méné wuna némaadut waménu dé ana yaapana gwalmu muniye dé wunéké las tiyaaké yo. Waga wuné mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Naate wadéka dé Jisas wak, “Kiyadé wak wuné wani jébaa bénéké yawuruké?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naate watakne dé derét wak, “Guné jérawu yaké guné yo. Guné nak duna gwalmuké génmarék yaké guné yo. Wupmale gwalmu duna mawulé kutkalé yaké dé yapatiyu. Du taakwa kulé mawulé kérae miték rasaakuké, de wupmale gwalmuké sanévéknwumarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naate watakne dé derét aja kudi nak kéga wakwek, “Yéwaamama du nak déku képmaaba dé wupmalemu kadému yéknwun ye dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tédéka dé yéwaamama du déku mawuléba dé wak, ‘Wuna kaadi ga wupmalemu kaapuk kwaakwa. Bulaa samu yaké wuné yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naate sanévéknwute dé wak, ‘Bulaa kéga yaké wuné yo. Wuné kaadi ga akwi pérae apakélé ga kaaké wuné yo. Kaatakne akwi kadému nak gwalmu wawo wuné waba taknaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Takne wuné wuna wuraanyanét waké wuné yo: Méné, ména wupmalemu yéknwun gwalmu wupmalemu kwaaré raké dé yo. Radéranké sanévéknwute méné bulaa yaap raké méné yo. Méné kadému gu kate dusék yate raké méné yo. Naate wate wuné miték male raké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naate wadéka dé Got dérét wak, ‘Méné waagété du. Bulaa gaan kwae kiyaaké méné yo. Kiyaaménu taknaménén gwalmu kiyadé kéraaké yo?’ Waga dé Got dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bulaa gunat wuné wakweyo. Kéni képmaaba rate wupmalemu gwalmu kéraakwa du taakwa de wani du pulak de ro. Rate Gotna méniba de gweba du taakwa de ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wani kudi watakne dé Jisas déku duwat wak, “Wani muké sanévéknwute wuné gunat wo. Guné wup yate kadému gu baapmu wutké wawo sanévéknwu wanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kadému, gu, baapmu wut wan bakna mu. Némaa mu kaapuk. Guné wani muké sanévéknwu wanévéknwumarék yaké guné yo. Got wadék guné ro. Guna sépé guna mawulé guna wuraanyan yadék guné ro. Wan némaa mu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Guné apit mé vé. De kadému kaapuk yaanandakwa. De kadému kaapuk kéraadakwa. De kadému kaadi gaba kaapuk taknadakwa. Yadaka Got dé deké kadému kwayu. Api wan makwal mu. Guné du guné némaa mu. Got waga apiké kadému kwayédu guné kutdéngké guné yo. Gunéké wawo kadému kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mé véknwu. Guna du nak kwaaré las wawo raké sanévéknwu wanévéknwudéran dé watakne kwaaré las wawo raké apa yaké dé yo, kapu kaapuk? Wan kaapuk. Déku kapmu watakne kwaaré las wawo raké yapatiké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Guné wani makwal mu yaké yapatite samuké guné nak muké guné sanévéknwu wanévéknwu? Guné waga yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Guné maaweké mé sanévéknwu. Naané wani maawe kaapuk yaanannakwa. De bakna de yaalo. De jébaa kaapuk yadakwa. De baapmu wut kaapuk kétaapadakwa. Yadaka Got dé deké miték vu. Deké dé yéknwun nyaap dé kwayu. Déknyényba wupmalemu gwalmu yan némaan ban nak déku yé Solomon yéknwun baapmu wut dé kusok. Yate wani maawe pulak kusokwa yéknwun mu kaapuk kusodén. Maawe kusokwa yéknwun mu Solomon kuson yéknwun mat débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Got wani maaweké dé miték vu. Wani maawe walkamu male téké de yo. Bulaa de tu. Séré kiyaaké de yo. Kiyaado du taakwa wani maawe péle yaa tuké de yo. Wani maawe wan makwal mu male. Guné du guné némaa mu. Guné Gotké kaapuk miték sanévéknwugunékwa. Yate guné wup yate guné wo, ‘Naanéké miték véké dé yo kapu kaapuk?’ Naate wate bulaa guné mé sanévéknwu. Got maawe waga kusodu véte guné kutdéngké guné yo. Gunéké baapmu wut kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Waga kutdéngte guné wup yamarék yate kagunéran kadému, kagunéran guké, sanévéknwu wanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Waga yamarék yaké guné yo, awuréba rakwa ban guna yaapa guné wani muké yapatigunékwaké kutdéngdén bege. Kwatkwa du taakwa de wani muké de sanévéknwu wanévéknwu. Guné de yakwa pulak wani muké sanévéknwu wanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yate guné Gotna kémba yaale déku jébaa yaké mawulat kapére yaké guné yo. Waga yagunéran dé gunéké wani mu kwayéké dé yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Watakne dé déku duwat wak, “Guné, wuna du, guné walkamu du guné ro. Guna yaapa Got dé yéknwun mawulé yo, guné déku kémba ragunu dé némaan ban rate gunéké miték védéranké. Yadékwaké guné wup yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guné guna gwalmu kwayéte yéwaa nyégéle gwalmu yamarék du taakwaké kwayéké guné yo. Kéni képmaaba wut jégwaa yadéka sél yakwa du gwalmu sél yadaka biyaak gwalmu de kérépaknu. Waga yado guna gwalmu akwi kaapuk yaké dé yo. Guné Gotna jébaa kutte yéknwun jébaa yagunéran kukba Got gunat kaatate gunat kutkalé yadu guné dé wale miték rasaakuké guné yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kéni képmaaba gwalmu jawutaknakwa du taakwa de kéni képmaana muké de mawulat kapére yo. Gotna gayéba raké sanévéknwukwa du taakwa de dé wale miték rasaakuké de mawulat kapére yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Mé véknwu. Wuné gwaamale yaawuréran tuléké miték raségéké guné yo. Kéni aja kudi mé véknwu. Jébaa yakwa duna némaan ban dé taakwa yaran du wale kadému kaké dé yék. Yédéka de déku jébaa yakwa du déké sanévéknwute baapmu wut gitakne yaa sérakne déké de miték raségék, dé gwaamale yae gwésba viyaadu de déké gwés bari naapikweké. Guné, wani du pulak, wuné guna némaan banké miték raségéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Deku némaan ban gwaamale yaaduké, déku jébaa yakwa du miték raségédaran de yéknwun mawulé yate miték raké de yo. Deku némaan ban déké miték raségédaranké kutdéngdu déku mawulé deké yéknwun yaké dé yo. Yadu dé wadu de raké de yo. Rado déku kapmu jébaa yakwa duna jébaa yate dé deké kadému kwayéké dé yo, de miték kadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dé nyédé gaan gwaamale yae de déké miték raségédo védu de yéknwun mawulé yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Guné kéni kudiké mé sanévéknwu. Gana bapadu sél yakwa du yaaran tuléké kutdéngdu mukatik de déku gat wulaamarék yadoké dé wani tulé miték raségékatik dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Guné, dé yadéran pulak, guné wawo miték raségéké guné yo. Guné kaapuk kutdénggunén. Wuné Akwi Du Taakwana Nyaan, yani tulé gwaamale yaaké wuné yo? Guné wunéké miték raségéké guné yo, kutdéngmarék yagunéran tulé gwaamale yaawuréran bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas wani kudi wadéka dé Pita wak, “Némaan Ban, naanéké male sanévéknwute méné wani kudi wakwek, kapu akwi du taakwat méné wakwek?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naate wadéka dé Némaan Ban Jisas wak, “Jébaa yakwa duké miték téségékwa du yéknwun mawulé yate kéga yaké dé yo. Déku némaan ban dérét kéga waké dé yo, ‘Méné wuna jébaa yakwa duké téségéte deké kadému kwayéké méné yo.’ Naate watakne yédu dé waga yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yadu kukba déku némaan ban gwaamale yae véte waké dé yo, ‘Méné jébaa miték ménébu yak. Wan yéknwun.’ Naate wadu dé yéknwun mawulé yate miték raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Déku némaan ban yadén yéknwun jébaa véte waké dé yo, ‘Méné gwaamale yaawuréran nyaaké kutdéngmarék yate, méné yéknwun jébaa ménébu yak. Wan yéknwun. Bulaa méné wuna akwi gwalmuké miték véké méné yo.’ Naate waké dé yo, yéknwun jébaa yan dut. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kapéredi mawulé yate kapéredi jébaa yakwa du déku mawuléba kéga waké dé yo, ‘Wuna némaan ban nak gayét ye dé bari gwaamale yaamarék yaké dé yo.’ Naate watakne dé jébaa yakwa du taakwat viyae wupmalemu kadému kate, waagété gu kate, waagété yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yate déku némaan banké sanévéknwumarék yadu wani tulé déku némaan ban gwaamale yaaké dé yo. Kutdéngmarék yadéran tulé gwaamale yaaké dé yo. Yae yadén kapéredi mu véte dé wadu dérét viyaado kiyaaké dé yo. Kiyae dé kapéredi mu yan nak du taakwa wale kapéredi taaléba raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Déku némaan ban mawulé yadékwa jébaaké kutdéngén du, dé wani jébaa yamarék yadéran déku némaan ban wadu de dérét némaanba viyaaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Déku némaan ban mawulé yadékwa jébaaké kutdéngmarék yan du, dé wani jébaa yamarék yadéran déku némaan ban wadu de dérét kwekére viyaaké de yo. Got du taakwaké las wupmale jébaa kwayédéka de déké wupmale jébaa yakwedoké dé mawulé yo. Got du taakwaké las wupmalemu jébaa kwayédéka de déké wupmalemu jébaa yakwedoké dé mawulé yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Watakne dé derét wak, “Wuné yae kéni képmaaba yaa pulak sérakgé wuné yo. Wani jébaa yaké wuné yaak. Wani jébaa bari yabutiké wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taale apakélé kaagél kutké wuné yo. Bari kutké wuné mawulé yo. Kure wuné miték raké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yaga guné wo? Akwi képmaaba rakwa akwi du taakwa waariyamarék yate miték radoké wuné yaak, kapu kaapuk? Wan kaapuk. Yaawurénké du taakwa las wuna kudi miték véknwudo deku kém rékaréka yate de wale waariyaké de yo. Yaawurénké du taakwa las wuna kudiké mawulé yado las wuna kudiké kélik yate kémba kémba raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yate kéni tulé kukba wawo nak gaba rakwa du taakwa kés mawulé nak mawulé yate kém vétikba raké de yo. Du kupuk nak kém pulak rado du vétik nak kém pulak raké bét yo. Taakwa vétik nak kém pulak rabéru taakwa kupuk nak kém pulak raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yaapa deku baadi wale waariyaké de yo. Néwaa deku takwanyangu wale waariyaké de yo. Yawutakwa deku méyaasgu wale waariyaké de yo.” Naate dé Jisas wak, de déku kudiké mawulé yadaranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wani kudi watakne dé wale tén du taakwat dé wak, “Guné apakélé wimut kutdéka véte kutdéngte guné wo, ‘Bulaa maas viyaaké dé yo.’ Naate wagunéka dé maas viyao. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Guné gaan wupmale kun kwaarat véte kutdéngte guné wo, ‘Séré apakélé nyaa véké dé yo.’ Waga wagunéka dé apakélé nyaa vu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Guné yénaa yakwa du taakwa guné. Guné nyétba kwaakwa mu képmaaba yaalakwa mu véte guné kutdéngék. Maas viyaaké dé yo. Nyaa véké dé yo. Waga kutdéngte samuké guné yawurékwa apa jébaa véte guné wunéké kaapuk miték kutdénggunén? ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Samuké guné yéknwun muké kaapuk kutdénggunén? Guné kapmu miték sanévéknwe yéknwun muké wakweké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Du las gunat kotké yadaran guné de wale yaabuba yéte de wale kudi bulte de wale kudi giké guné yo. Nakurak mawulé yaké guné yo. Guné de wale wani kudi gimarék yagunéran sal de gunat kot véknwukwa némaan banké kure yédo dé wadu de gunat raamény gaba taknaké de yo? Taknado guné waba rasaakuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kot véknwukwa némaan ban wadén akwi yéwaa gunat waatin duké kwayégunu, wani tulé male raamény ga kulaknyénytakne yaale miték yéké guné yo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wani tulé du las Jisaské yae de dérét wak, “Némaan du Yerot wadéka déku du Galilina képmaat yae de Galilina duwat las viyaapéreknék. Wani du Gotké kwaami viyae tuwe kwayédaka wani tulé Yerotna du de derét viyaapéreknék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naate wadaka Jisas dé derét wak, “Galilina du waga kiyaadanké yaga guné sanévéknwu? Wani du wupmalemu kapéredi mu yadaka yadan kapéredi mu nak du yan kapéredi mat débu talaknak, kapu kaapuk? ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wan kaapuk. Gunat wuné wo. Guné yagunén kapéredi mu kulaknyénymarék yagunéran de kiyaadan pulak guné wawo kiyaaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Guné kutdéngék. Déknyényba Siloamba kwaan sémény ga wupmale (18) du ténba akére dé derét takupéreknék. Bulaa yaga guné sanévéknwu? Waga takupérekdén du yadan kapéredi mu dé Jerusalemba rakwa nak du yan kapéredi mat débu talaknak, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wan kaapuk. Gunat wuné wakweyo. Guné yagunén kapéredi mu kulaknyénymarék yagunéran de kiyaadan pulak guné wawo kiyaaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wani kudi watakne dé Jisas kéni aja kudi derét wakwek, “Kwaabi pulak mi nak dé duna wain yaawiba ték. Tédéka wupmalemu apu wani du dé yaak, sék las géléké. Yae dé vépatik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Vépatite dé wain yaawiba jébaa yakwa dut wak, ‘Kwaaré kupuk sék akukwa tulé wuné kéni miba sék las géléké wunébu yaak. Yae wuné vépatik. Méné wani mi véléké méné yo. Yéknwun képmaaba bakna témarék yaké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naate wadéka dé wak, ‘Némaan du, waga yamarék yaké ané yo. Kéni kwaaré wawo dé mé tu. Tédu wuné wani mi baapaba képmaa vae, képmaa yéknwun yaduké bulmakawuna di taknaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Taknawuru sal aniké kwaaré sék akuké dé yo? Waga akudéran wan yéknwun. Akumarék yadu méné véléké méné yo.’ Naate dé wak.” Waga dé Jisas derét wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yaap ra nyaa nak dé Jisas Gotna kudi buldakwa gaba rate du taakwat Gotna jébaaké dé yakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yakwatnyédéka lé kutakwa kure tén taakwa lé nak waba rak. Wani kutakwa lérét kure téléka léku sépékwaapa apa yamarék yadéka léku butgul dé anygwa yak. Yadéka lé kedéng téké lé yapatik. Wupmalemu (18) kwaaré lé waga rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Raléka Jisas lérét véte waadéka yaaléka dé lérét wak, “Nyéna, bulaa nyénébu yéknwun yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naate wate déku taaba wani taakwat kutdéka lé bari kedéng ték. Téte lé Gotna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisas yaap ra nyaa lérét waga kutnébuldénké dé Gotna kudi buldakwa gana némaan ban rékaréka yak. Yate dé waba tén du taakwat wak, “Naané jébaa yanaran nyaa nak taaba sékét nak taababa kayék nakurak. Guna sépékwaapa kapére yadu dé gunat kutnébulduké mawulé yagunéran guné jébaa yanakwa nyaa yaaké guné yo. Guné yaap ra nyaa waga yamarék yaké guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wani du waga wadéka dé Jisas wak, “Guné wan yénaa yakwa du guné. Akwi nyaa guné ye bulmakawu donki tékwa gat wulae baagwi lépmwénye guné derét kure gwaadu, gu kadoké. Yaap ra nyaa wawo guné wani jébaa yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naana képmawaara Ebrayam wan léku képmawaara wawo. Seten wadéka lé déku taababa raléka wupmalemu (18) kwaaré léku butgul anygwa dé yak. Yadénké yaap ra nyaa wuné lérét kutkalé yate lérét Setenna taababa kéraawurékwa wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naate wadéka de déku maama nyékéri yate de akélak rak. Radaka waba tén nak du taakwa yadén akwi yéknwun jébaaké de yéknwun mawulé yate dusék takwasék yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Du taakwa waga yadaka dé Jisas derét wak, “Got némaan ban rate du taakwaké miték védéranké yaga wakwewuru guné kutdéngké guné yo? Yaga yate déku makwal kém apakélé kém raké dé yo? Wani muké gunat wakweké wunék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wani kém wan misék nak pulak. Wani misékna yé mastet. Mastet sék wan nak misék pulak kaapuk. Wani misék wan makwali sék. Du nak wani misék kérae dé kadému yaanandékwa képmaaba pukaak. Pukaadéka wure apakélé ye dé wani képmaaba tékwa mit débu talaknak. Apakélé mi tédéka de api yae de wani mi gaaléba kwaat sétakne rak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wani kudi watakne dé kéga wakwek, “Got némaan ban rate du taakwaké miték véké dé yo. Wani du taakwa kulé mawulé yate kulé du taakwa yaalaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wani du taakwa wan yis pulak. Taakwa nak yis kérae lé pélawa wale sélorék. Sélotléka dé wani pélawa nak pulak mu dé yaalak. Nak pulak mu yaalan pulak, Gotna du taakwa kulé du taakwa yaalaké de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Watakne wani gayé kulaknyénytakne Jerusalemét yéké dé mawulé yak. Yate wani yaabuba yéte dé wupmalemu gayét yék. Ye dé wupmalemu du taakwat Gotna jébaaké dé yakwatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Yadéka dé du nak dérét wak, “Némaan Ban, wupmalemu du taakwa Gotna kémba wulaaké de yo, kapu walkamu du taakwa male déku kémba wulaaké de yo?” Naate waatadéka dé waba tén du taakwat dé wakwek, “Du taakwa apuba apuba miték rasaakudaran gayéna gwés wan apakélé gwés kaapuk. Wan makwal gwés. Gunat wuné wakweyo. Guné wani gwésba wulaaké guné apa jébaa yate apat kapére yaké guné yo. Wupmalemu du taakwa wani gwésba wulaaké mawulé yate de yapatiké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wani gayéna némaan ban raapme wani gwés tépéké dé yo. Tépédu guné yae kaapaba téte gwésba viyaate kéga waké guné yo, ‘Némaan Ban, naanéké mé gwés naapitiyaa.’ Waga wagunu gunat kéga waké dé yo, ‘Guné yani gayéba guné yaak? Wuné gunat las kaapuk kutdéngwurén.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Waga wadu guné kéga waké guné yo, ‘Naané méné wale kadému gu naané kak. Méné naana gayéna yaabuba téte méné naanat kudi wakwek.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Waga wagunu dé gunat kéga waké dé yo, ‘Gunat wuné wakweyo. Wuné guné yaagunén gayé wuné las kaapuk kutdéngwurén. Guné kapéredi mu yakwa du taakwa guné. Guné akwi wunat kulaknyénytakne yéké guné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Naate wadu kaapaba téte géraaké guné yo. Guné véké guné yo naana képmawaara Ebrayam, Aisak, Jekop, Gotna yéba déknyényba kudi wakwen akwi du wawo Gotna gayéba rado. Véte guné wani gayéba raké mawulé yate kaapaba téte némaanba géraaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yagunu de nyaa yaalakwa taaléba yaaran du taakwa, nyaa dawulikwa taaléba yaaran du taakwa, akwi taaléba yaaran du taakwa yae Gotna gayét wulae rate kadému kaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gunat wuné wakweyo. Bulaa bakna rakwa du taakwa de las kukba némaan du taakwa raké de yo. Bulaa rakwa némaan du taakwa de las kukba bakna du taakwa raké de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wani tulé de Parisina du las yae de Jisasnyét wak, “Galilina némaan ban Yerot ménat viyaapérekgé dé mawulé yo. Waga yadékwaké méné kéni gayé kulaknyénytakne méné nak gayét yéké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naate wadaka dé derét wak, “Guné ye wani yénaa yakwa dut kéga waké guné yo, ‘Mé véknwu. Jisas kéga dé wo: Bulaa, séré kutakwat wawuru de yaage yéké de yo. Kiyakiya yakwa du taakwa, sépékwaapa kapére yan du taakwat wawo, wuné kutnébulké wuné yo. Nyaa kupuk yédu wuna jébaa yabutiké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bulaa, séré, maa, wuné Jerusalemét yédakwa yaabuba yéké wuné yo. Déknyényba Gotna yéba kudi wakwen duwat Jerusalemba de viyaapéreknék. Wuné wawo Gotna yéba kudi wakwekwa du rawurékwaké wunat Jerusalemba viyaapérekgé de yo.’ Guné wuna kudi waga Yerotnét waké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Naate watakne dé wak, “Guné Jerusalemba rakwa du taakwa, guné Gotna yéba kudi wakwen duwat guné viyaapéreknék. Got wadéka déku kudi kure yén du gunéké de yék. Yédaka guné derét matut viyaagunéka de kiyaak. Gunéké wuné mawulé léknu. Séraa kéraalén nyaanké sarépgwe rate deké miték vélékwa pulak, wuné wupmalemu apu gunat kutkalé yate gunéké miték véké wuné mawulé yak. Mawulé yawuréka guné kélik guné yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yagunénké kukba du yae guna gayé yaalébaanké de yo. Yaalébaando guné waba ramarék yaké guné yo. Guna gayé bakna taalé téké dé yo. Wuné kutdéngék. Guné wunat bari vémarék yaké guné yo. Kukba guné wunéké waké guné yo, ‘Got wadéka dé wani du yaak. Naané déku yéba kevérékgé naané yo.’ Naate wagunu wuné yaawuru guné wunat véké guné yo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yaap ra nyaa nak dé Jisas Parisina du nak déku gaba kaké dé yék. Wani du wan némaan du. Yédéka déku gaba ran du deku mawuléba de wak, “Sal Jisas jébaa yaké dé yo yaap ra nyaa? Jébaa yadéran wan kapéredi mu.” Naate wate de dérét vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Védaka maan taaba waarén du nak dé Jisasna méniba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tédéka Jisas wani dut véte dé apa kudiké kutdéngkwa du Parisina duwat wawo dé waatak, “Naana apa kudi yaga dé wo? Yaap ra nyaa naané sépékwaapa kapére yan du taakwat kutnébulké naané yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Naate waatadéka de kudi las kaapuk buldan. Yadaka dé Jisas wani dut kutnébultakne wadéka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yédéka dé derét wak, “Guné wawo yaap ra nyaa guné jébaa yo. Guna nyaan yaap ra nyaa gu tékwa waaguba akére dawulidéran guné dérét bari kutkweké guné yo, kapu yaga pulak? Guna bulmakawu yaap ra nyaa gu tékwa waaguba akére dawulidéran yaap ra nyaa guné dérét bari kutkweké guné yo, kapu yaga pulak? Ao, yaap ra nyaa guné kutkweké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naate wadéka de déku kudi kaataké de yapatik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas dé vék wani kadému kaké yaan du yaate némaan duna taaléba radaka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Véte dé derét wak, “Du nak taakwa yate kadému sérakne kaké yate gunat waadu guné ye miték sanévéknwuké guné yo. Sanévéknwute guné némaan duna taaléba ramarék yaké guné yo. Guné némaan duna taaléba ragunéran sal némaan du las yaado gunat waan du yae gunat kéga waké dé yo? ‘Guné wani yéknwun taalé kéni duké kwayéké guné yo.’ Dé waga wadu guné nyékéri yate némaan duna taalé kulaknyénytakne du taakwana kukba raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Guné de wale kadému kaké ye miték sanévéknwute du taakwana kukba raké guné yo. Waga yagunu gunat waan du yae gunat waké dé yo, ‘Wuna du, guné yae némaan duna taaléba raké guné yo.’ Naate wadu guné ye némaan duna taaléba ragunu wani gaba rakwa du de guna yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kéni muké sanévéknwute wuné wani muké wo. Deku yéba kevérékgwa du taakwaké kukba Got wadu de bakna du taakwa raké de yo. Deku yéba kevérékmarék yakwa du taakwaké kukba Got wadu de némaan du taakwa raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wani kudi watakne dé dé wale kadému kaduké waan dut wak, “Méné kadému sérakne kaké yate ména du taakwa, ména némaadugu wayéknaje, ména kém, ména gayéba rate wupmalemu yéwaa yan duwat waga waamarék yaké méné yo, de yaadoké. Méné waga pulak duwat waaménéran kukba de sérakte ménat waado yaaménu de ménéké kadému kwayékataké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Méné waga yamarék yaké méné yo. Méné kadému sérakne kaké yate méné gwalmu yamarék du, sépékwaapa kapére yan du, maan kapére yan du, méni kiyaan duwat waaké méné yo, de yaadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wani du de ménéké kadému kwayékataké dé yapatiyu. Méné deké waga kwayéménéranké kukba Got ménat kutkalé yaké dé yo. Got wadu yéknwun mu yatakne kiyaan du taakwa tépa nébéle raapdaran tulé dé ménat kutkalé yadu méné miték raké méné yo.” Naate dé Jisas dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","De wale rate kadému kan du nak wani kudi véknwutakne dé Jisasnyét wak, “Gotna gayéba rate kadému karan du de yéknwun mawulé yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naate wadéka dé Jisas wak, “Du nak apakélé kadému sérakgé dé yak. Yate wupmalemu duwat dé wakwek, de yae wani kadému kadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakwedéka kadému kadaran tulé yaadéka déku jébaa yakwa dut dé wak, dé déknyényba wakwedén duké ye kéni kudi waduké, ‘Akwi gwalmu kawu saakérataknanak dé ro. Guné mé yaa.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Dé deké ye wadéka de akwi du yémuké de kélik yak. Yate du nak dé dérét wak, ‘Wuné képmaa nakatak wunébu kéraak. Kéraatakne bulaa véké wuné yu. Wuné yaamarék yaké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Naate wadéka dé nak wak, ‘Wuné bulmakawu taaba vétik wunébu kéraak. Kéraatakne wuné ye derét yaknwuké wunék. De wuna jébaa miték yaké de yo, kapu yaga pulak? Wuné yaamarék yaké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naate wadéka dé nak wak, ‘Wuné bulaa male taakwa nak wunébu kéraak. Kéraawurén bege, wuné yaamarék yaké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“De waga wadaka dé jébaa yakwa du tépa gwaamale ye dé déku némaan dut wani muké wakwek. Wakwedéka dé wani du rékaréka yak. Yate dé déku jébaa yakwa dut wak, ‘Méné kéni gayéba kwaakwa akwi yaabuba yéte méné gwalmu yamarék du, sépékwaapa kapére yan du, méni kiyaan du, maan kapére yan duwat méné wuna gat kwole kure yaaké yo.’ Naate wadéka dé jébaa yakwa du ye wadén pulak dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ye gwaamale yae dé déku némaan dut wak, ‘Némaan du, wuné ména kudi véknwute waménén pulak wunébu yak. Yawurék taalé las bakna dé tu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Naate wadéka dé dérét wak, ‘Méné akwi yaabuba yéte nébuba wawo yéte méné bakna du taakwat kwole kure yaaké yo. Kwole kure yaaménu wuna ga sékérékduké wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bulaa gunat wuné wakweyo. Déknyényba waawurén akwi du wuna kadému kamarék yaké de yo. De wuna kadému kamuké bulaa kélik wuné yo.’ Naate dé némaan du wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Wupmalemu du béré taakwa béré Jisas wale yédaka dé walaakwe dé derét wak, “Guné wuna jébaaba yaalaké mawulé yate guné wunéké némaa yéknwun mawulé yaké guné yo. Guné guna néwepa, guna du, guna taakwa, guna baadi, guna némaadugu wayéknaje nyangeguké némaa yéknwun mawulé yate wunéké walkamu male yéknwun mawulé yagunéran guné wuna jébaaba yaalamarék yaké guné yo. Guné guna sépéké némaa yéknwun mawulé yate wunéké walkamu male yéknwun mawulé yagunéran wuna jébaaba yaalamarék yaké guné yo. Wunéké yagunéran yéknwun mawulé nak du taakwaké yagunékwa yéknwun mawulat talaknadéran guné wuna jébaaba yaale wuna du taakwa raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Guné kéga wagunéran, ‘Jisasna jébaa kutsaakuké naané yo. Yate kaagél kutte miba kiyaanaran wan bakna mu. Némaa mu kaapuk.’ Waga wagunéran guné waga yate guné wuna du taakwa raké guné yo. Guné waga wamarék yate waga yamarék yagunéran guné wuna du taakwa ramarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wuna jébaaba yaalaké yate taale mé miték sanévéknwu. Kéni kudi mé véknwu. Guna du nak sémény ga nak kaaké mawulé yadéran taale dé rate miték sanévéknwuké dé yo, wani gana yéwaaké. Sal dé kure radékwa yéwaat wani ga kaabutiké dé yo, kapu kaapuk? ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Taale waga miték sanévéknwumarék ye dé kwaat yaanédu yéwaa kaapuk yadu ga kaabutimarék yadéran akwi du véte wani dut wasélékte waagiké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Waagite de waké de yo, ‘Wani ga batnyé kaadéka yéwaa kaapuk yadéka bulaa kaabutiké dé yapatiyu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kéni kudi wawo mé véknwu. Némaan ban nak dé véknwuk. Nak némaan ban déku waariyakwa du wale de yaak, de wale waariyaké. Véknwute de wale waariyaké mawulé yate taale samu yaké dé yo? Taale rate dé kéga waké dé yo, ‘Wuna waariyakwa du wan walkamu. Déku waariyakwa du wan wupmalemu. Yaga pulak naané derét viyaaké naané yo? Sal de naanat viyaapérekgé de yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Naate sanévéknwe dé waké dé yo, ‘Naané de wale waariyaké naané yapatiyu.’ Naate wate miték sanévéknwe dé duwat las wadu de ye yaaran némaan ban wale kudi bulké de yo, de kudi giye ye waariyamarék yadoké. Wani némaan ban séknaa taaléba wekna tédu dé duwat wadu de deké yae kudi bulké de yo, de kudi giye ye waariyamarék yadoké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Naate watakne Jisas dé derét wak, “Wani du yadén pulak guné yaké guné yo. Guné wuna jébaaba yaale wuna du taakwa raké mawulé yagunéran taale miték mé sanévéknwu. Guné guna gwalmuké kuk kwayégunéran wani muké tépa mawulat kapére yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mé véknwu. Taakwa de sol takno, kadému lisék yaduké. Sol wan yéknwun mu. Sol lisék yamarék yadéran yaga pulak yado lisék tépa yaké dé yo? Kaapuk. Lisék tépa yamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yadu kadémuba taknamarék yaké de yo. Lisék yamarék yakwa sol yéknwun képmaaba taknadaran kadému miték yaalamarék yaké dé yo. De wani sol bakna yatjadaké de yo. Guné bakna yatjadadaran sol pulak ramuké guné wani kudi miték kutdéngké mawulé yate miték véknwuké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nak nyaa takis nyégélkwa du, nak kapéredi mu yakwa du taakwa wawo de Jisas ténét yék, déku kudi véknwuké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yédaka de Parisina du apa kudiké kutdéngkwa du wawo wani muké kélik yate de wak, “Wani du kapéredi mu yakwa du taakwa wale téte dé de wale kadému ko.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naate wadaka dé derét kéni aja kudi wakwek: ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sal guna du nak kéga yaké dé yo? Du nak wupmalemu (100) sipsip dé yak. Yadéka dé nak yalaknék. Yadéka nak sipsip yéknwun taaléba téte kadaka dé derét kulaknyénytakne ye yalaknén nakurak sipsipké dé sékalék. Sékale sékale dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Vétakne kérae déku tangaléba akutakne dusék yate dé yaate yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ye gayé saabe dé du taakwat waadéka yae de jawuk. Jawudaka dé derét wak, ‘Guné wuné wale yéknwun mawulé yate dusék takwasék yaké guné yo, wuna sipsip nak yalakdék sékale vétakne kéraawurén bege.’ Naate dé derét wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Waga watakne dé Jisas wak, “Gunat wuné wakweyo. Waga yadén pulak Gotna kudi kure giyaakwa du dusék yaké de yo. Yéknwun mu yate Gotna méniba miték rakwa wupmalemu du taakwaké de Gotna kudi kure giyaakwa du yéknwun mawulé yate dusék yaké de yo. Kapéredi mu yan du yadén kapéredi mu kulaknyénydéran de Gotna kudi kure giyaakwa du yéknwun mawulé yate duséknét kapére yaké de yo.” Naate dé derét wakwek, du las kapéredi mu yakwa du taakwa wale tédénké dérét waatidan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wani kudi watakne dé Jisas derét aja kudi nak wawo kéga wakwek: “Sal guna taakwa nak kéga yaké lé yo? Taakwa nak yéwaa taaba vétik kure raléka nak yalakdéka lé téwayé sérakne takne ga taapiye lé sékale sékale lé wani yéwaa vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vétakne kérae lé wani gayéba ran du taakwat waaléka yae de jawuk. Jawudaka lé derét wak, ‘Guné wuné wale dusék takwasék yaké guné yo, wuna yéwaa nak yalakdék sékale vétakne tépa kéraawurén bege.’ Naate lé derét wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Waga watakne dé Jisas derét wak, “Gunat wuné wakweyo. Waga yalén pulak Gotna kudi kure giyaakwa du dusék yaké de yo. Kapéredi mu yakwa du yadén kapéredi mu kulaknyénydéran, de Gotna kudi kure giyaakwa du yéknwun mawulé yate dusék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Watakne dé Jisas nak aja kudi kéga wakwek: “Du nak dé nyaan vétik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kukba kéraadén nyaan dé déku yaapat wak, ‘Ména, kukba kiyaaménu wuné ména gwalmu las kéraaké wuné yo. Kéraawuréranké ménat wuné wo. Bulaa méné ména yéwaa gwalmu anéké munitiyaaké méné yo. Muniye wunéké tiyaaké waménén mu bulaa tiyaaké méné yo.’ Naate wadéka dé déku yéwaa gwalmu muniye dé bétké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kwayédéka dé kukba kéraadén nyaan walkamu re déku gwalmu akwi nak duké kwayétakne dé yéwaa nyégélék. Nyégéle kure dé séknaa gayét yék. Ye wani gayéba rate dé déku yéwaa kéraasolak, yadén kapéredi muké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yadéka déku yéwaa akwi kaapuk yadéka kukba dé wani képmaaba apakélé kaadé yak. Yadéka déku kadému dé kaapuk yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yadéka ye dé wani képmaaba ran duké nak jébaa yak. Yadéka wadéka ye dé déku baalé yaakwak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Akwi du de déké kadému kaapuk kwayédan. Yadaka kaadé wale rate dé baalé kadakwa kadému kaké dé mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Waga yatakne dé déku mawuléba miték sanévéknwuk. Sanévéknwute dé wak, ‘Wuna yaapaké jébaa yakwa wupmalemu du de wupmalemu kadému de ko. Kadaka biyaa yadéka kadému las bakna dé ro. Radéka wuné kéba rawuréka wunat kaadat dé kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bulaa wuné raapme wuna yaapaké gwaamale yéké wuné yo. Ye dérét waké wuné yo: Wuné Gorét kapéredi mu wunébu yak. Ménat wawo kapéredi mu wunébu yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yawurénké sanévéknwute méné wunéké wuna nyaan naamarék yaké méné yo. Yéknwun mu yakwa du rawuru mukatik méné wunéké waga naaménu. Méné wunéké wuna jébaa yakwa du naaké méné yo, kapéredi mu yawurén bege. Naaménu wuné ména jébaa yakwa du wale ména jébaa yaké wuné yo. Naate wuné wuna yaapat waké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naate watakne déku yaapaké gwaamale yéké mawulé yate dé yaabuba yék. “Wani du ye séknaaba tédéka dé déku yaapa dérét vék. Védéka déku mawulé dé léknék déké. Lékdéka dé pétépété ye déku nyaanét rawute dé taama vék (daama réngék). ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yadéka dé déku nyaan dérét wak, ‘Wuna yaapa, wuné Gorét ménat wawo kapéredi mu wunébu yak. Yawurénké sanévéknwute méné wunéké wuna nyaan naamarék yaké méné yo. Yéknwun mu yakwa du rawuru mukatik méné wunéké waga naaménu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Naate wadéka dé déku yaapa jébaa yakwa duwat waadéka yaadaka dé derét wak, ‘Wuna nyaan débu gwaamale yaak. Wuné déké yéknwun mawulé wuné yo. Guné yéknwun baapmu wut bari kérae kure yae guné dérét gikweké yo. Yate guné awu déku taababa kusolakwetakne su déku maanba kusadakweké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yatakne guné wulén bulmakawu nyaan nak kure yae guné viyaaké guné yo. Viyae tuwe naané kate dusék yaké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wuna mawuléba wuné déké wuné wak: Débu kiyaak. Naate wawuréka bulaa débu gwaamale yaak. Déknyényba wuné wak: Débu yalaknék. Waga watakne bulaa dérét naané vu. Véte gwaamale yaadénké naané kate dusék yaké naané yo.’ Naate wadéka de déké dusék yate kadému kawu saakérak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wani duna maknanyan yaawiba dé ték. Te kukba gwaamale yae ga saabaké yate dé véknwuk kaang viyaate kétidaka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Véknwute dé jébaa yakwa dut nak waadéka yaadéka dé dérét waatak, ‘De samu de yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Naate waatadéka dé jébaa yakwa du wak, ‘Ména wayékna tépa gwaamale yaadék ména yaapa déké yéknwun mawulé yate wadék de wulén bulmakawu nyaan nak viyaak. Viyae kate de dusék yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Naate wadéka dé maknanyan rékaréka yate dé wulaamuké kélik yak. Yadéka déku yaapa gwaade dé dérét wak, gat wulaaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wadéka dé yaapat wak, ‘Mé véknwu. Wupmalemu kwaaré wuné bakna jébaa yakwa du pulak wuné ména jébaa wunébu yak. Yate ména kudi miték wunébu véknwuk. Ména kudiké kaapuk kuk kwayéwurén. Yawurénké méné wunéké yéknwun mu kaapuk tiyaaménén. Méné meme nyaan nak kaapuk tiyaaménén, wuné wuna du taakwa wale kate dusék takwasék yanoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Waga pulak makwal mu wunéké tiyaamarék yate ména nak nyaan gwaamale yaadék méné déké yéknwun mawulé yate wulén bulmakawu nyaan ménébu viyaak. Dé ména gwalmu yéwaa yaabuba tékwa taakwaké kwayétakne akwi yéwaa dé kéraasolak. Waga yadénké méné déké yéknwun mawulé yate wulén bulmakawu nyaan ménébu viyaak, de kate dusék takwasék yadoké.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Naate wadéka dé yaapa dérét wak, ‘Wuna nyaan, akwi nyaa ané vététi ané ro. Wuna akwi gwalmu wan ména gwalmu male. ");
INSERT INTO abt_maprik_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ména wayékna dé ye wupmalemu kwaaré nak taaléba dé rak. Radéka wuné wuna mawuléba wuné wak: Débu yalaknék, kapu débu kiyaak? Naate sanévéknwuréka dé gwaamale yaadék bulaa naané dérét vu. Wani muké sanévéknwute naané yéknwun mawulé yate dusék takwasék yanakwa wan yéknwun’. Naate dé yaapa déku maknanyanét wak.” Waga dé Jisas wak. Wani aja kudi kupuk dé derét wak, du las kapéredi mu yakwa du taakwa wale tédénké dérét waatidan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kukba Jisas déku duwat kéni aja kudi dé wakwek: “Du nak dé wupmalemu yéwaa yan duna gwalmuké dé téségék. Yadéka de du las némaan duké yae de déku gwalmuké téségékwa duké de wak, ‘Ména gwalmuké téségékwa du dé yéknwun jébaa kaapuk yadékwa. Yate dé ména yéwaa kés du nak duké kwayu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naate wadaka dé déku gwalmuké téségékwa duwat waadéka yaadéka dé dérét wak, ‘Ménéké véknwurén kudi yaga pulak? De de wo, méné yéknwun jébaa yamarék yate wuna yéwaa kés du nak duké kwayéménékwaké. Wani kudi wan adél kapu kaapuk? Méné wuna gwalmu, wuna yéwaa akwi naaknwe nyégaba kavitakne wani nyéga wunéké mé kure yaa. Kure yae méné wuna jébaa tépa yamarék yaké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Naate wadéka dé gwalmuké téségékwa du déku mawuléba dé wak, ‘Wuna némaan ban dé wuné déku gwalmuké tépa téségémuké dé kélik yo. Wuné samu yaké wuné yo? Wuné kabi vaaké wuné apa kaapuk yawurékwa. Wuné nak duwat yéwaaké yaawimuké nyékéri wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bulaa wuné kutdéngék. Wuné kéga ye wuna némaan ban déku jébaa kulaknyénytakne yéwuruké wadu, de wuna du rate wado wuné deku gat wulae de wale raké wuné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naate watakne dé déku némaan banét yéwaa nyégélén duwat waadéka de nak nak de yaak. Yaadaka dé taale yaan dut wak, ‘Méné wuna némaan banké gwalmu yagap nyégéle méné kwayékataké méné yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naate wadéka dé wak, ‘Wupmalemu (100) gu tékwa apakélé awu.’ Naate wadéka dé gwalmuké téségékwa du dérét wak, ‘Wani gwalmu akwi kwayékatamarék yaké méné yo. Kwayékataménéran yéwaa kavidén nyéga kéba dé ro. Méné rate bari nak kudi wani nyégaba mé kavi. Méné walkamu (50) male kaviké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Naate watakne dé nak dut wak, ‘Méné wuna némaan banké gwalmu yagap nyégéle kwayékataké méné yo?’ Naate wadéka dé wak, ‘Wupmalemu (100) bek wit.’ Naate wadéka dé wak, ‘Wani gwalmu akwi kwayékatamarék yaké méné yo. Kwayékataménéran yéwaa kavidén nyéga kéba dé ro. Méné nak kudi wani nyégaba mé kavi. Méné walkamu (80) male kaviké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Naate wadéka yadéka kukba wani némaan ban dé kudi véknwuk, déku gwalmuké téségékwa du bét dérét kukba kutkalé yabéruké waga yénaa yadéka. Véknwute dé wak, ‘Aki. Wani kapéredi mu yakwa du dé déku sépat kutkalé yaké nae dé miték sanévéknwuk.’ Naate dé déké wak.” Wani kudi watakne Jisas dé déku duwat kéga wakwek, “Naané kutdéngék. Kéni képmaana muké mawulé yakwa du de deku sépéké sanévéknwu. Sanévéknwute de nak du taakwat kutkalé yo, de kaatate derét kutkalé yadoké. Waga yate de miték sanévéknwu. Wani muké deku yéknwun mawulé Gotna du taakwa deku yéknwun mawulat débu talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gunat wuné wakweyo. Guné yéknwun jébaa yaké guné yo guna yéwaa wale, kéni képmaana nak mu wale wawo. Guné wani mu wale jébaa yate du taakwat kutkalé yagunu de guna du taakwa raké de yo. Rado kukba guné kiyae Gotna gayéba wulae miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Makwal jébaa miték yakwa du taakwa de némaa jébaa wawo miték yaké de yo. Makwal jébaa sépélak yakwa du taakwa de némaa jébaa wawo sépélak yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Guné kéni képmaana yéwaaké jébaa sépélak yagunéran yaga pulak guné Gotna muké jébaa miték yaké guné yo? Kaapuk. Gotna muké jébaa miték yaké guné yapatiké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Guné nak duna muké jébaa sépélak yagunéran yaga pulak Got gunéké rasaakukwa mu kwayéké dé yo? Kaapuk. Kwayémarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Du nak némaan du vétikgé jébaa yaké dé yapatiyu. Waga jébaa yadéran dé nak némaan duké yéknwun mawulé yate nakgé kélik yaké dé yo. Guné wani du pulak guné ro. Guné némaan ban Gotké jébaa yate déké male sanévéknwugunéran guné déké apuba apuba yéknwun mawulé yaké guné yo. Yate guné yéwaa kéraaké sanévéknwumarék yaké guné yo. Guné yéwaa kéraaké male apuba apuba sanévéknwugunéran guné némaan ban Gotké kélik yaké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisina du wani kudi véknwute de Jisasnyét waséléknék, yéwaaké mawulat kapére yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yadaka dé derét wak, “Guné duna méniba guné saaki yéknwun mu guné yo, de gunat véte kéga wadoké, ‘Guné yéknwun mu yakwa du guné.’ Naate wadoké waga yagunéka dé Got guna mawulé dé kutdéngék. Guna mawulé miték témarék yadékwaké kutdéngte dé gunéké dé kuk kwayu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Déknyényba Moses kéni képmaaba radén tulé yakéreye yakéreye gu yaakutaknan du Jon ran tulé wawo akwi du taakwa de Moses wakwen apa kudi véknwute Gotna yéba kudi wakwen duna kudi wawo véknwute wadan pulak de yak. Bulaa wuné du taakwat wunébu wakwek, Got némaan ban rate du taakwaké miték védéranké. Wakwewuréka wupmalemu du taakwa déku kémba yaalaké nae de apa jébaa de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moses wakwen apa kudi kaapuk yamarék yaké dé yo. Kukba nyét képmaa kaapuk yadu wani kudi kaapuk yamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Du deku taakwa derét kulaknyénytakne yédoké watakne nak taakwa yadaran de kukba yadan taakwa wale kapéredi mu de yo. Du deku taakwa derét kulaknyénytakne yédoké wado nak du wani taakwa yadaran de wani taakwa wale kapéredi mu de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wani kudi watakne dé Jisas derét kéga wakwek, “Déknyényba gwalmumama du dé nak rak. Déku wayéknaje naktaba de rak. Akwi nyaa dé yéknwun baapmu wut male kusadak. Yate akwi nyaa dé wupmalemu yéknwun kadému kak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Gwalmu yamarék du wawo dé rak. Déku yé Lasaras. Wupmalemu nyaa déku du de dérét yaate yék gwalmumama duna gat. Yaate ye gana gwés wale taknadaka dé kwaak. Déku sépé waasat kapére ye tédéka wupmalemu apu de waasa yaate de déku waaséba kénybiyaknék. Dé gwalmumama duna gwés wale kwaate dé gwalmumama du kadému kadéka akére képmaaba rakwa régén kadému kaké dé mawulé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kukba dé wani gwalmu yamarék du Lasaras dé kiyaak. Kiyaadéka de Gotna kudi kure giyaakwa du dérét kure ye de Ebrayam wale taknak. Yadaka dé gwalmumama du wawo kiyaadéka de rémék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Rémtaknadaka dé ye yaa yaansaakukwa taaléba rate dé kaagél kurék. Kutte kwaasawure dé vék Ebrayam Lasaras wale awuré séknaaba rabétka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Véte dé némaanba waak, ‘Wuna képmawaara Ebrayam, kéni taaléba yaa wuna sépéba yaandéka wuné apa kaagél kuru. Kutwurékwaké méné wunéké mawulé lékte méné Lasarasnyét waménu dé gu las kure yae dé wuna téknayéléngba taknaké yo.’ Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wadéka dé Ebrayam wak, ‘Ména, méné mé sanévéknwu. Déknyényba méné képmaaba rate wupmalemu yéknwun gwalmu méné taknak. Taknaménéka Lasaras waga kaapuk taknadén. Kapéredi mu male dé déké yaak. Bulaa dé yéknwun taaléba miték radéka méné kapéredi taaléba rate kaagél méné kuru. ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kéni muké wawo mé sanévéknwu. Ané rakwa méné rakwa nyédéba Got apakélé kabi dé nak taknak. Taknadék kéba rakwa du méné rakwat yéké de yapatiyu. Waba rakwa du wawo kénét yaaké de yapatiyu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Wani kudi véknwute dé wupmalemu gwalmu déknyényba yan du wak, ‘Waga yaran wunéké sanévéknwumarék. Wuna wayéknaje naktaba de ro wuna yaapana gaba. Méné, wuna képmawaara, ménat wuné waato. Méné Lasarasnyét waménu dé deké yéké dé yo. Ye dé derét rawurékwa kapéredi taaléké wakweké dé yo. De wawo kéni taalat yae apa kaagél kutmuké dé derét wakweké dé yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Naate wadéka dé Ebrayam wak, ‘Kaapuk. Moses wakwen apa kudi, Gotna yéba wakwen duna kudi wawo dé Gotna nyégaba kwao. Wani kudi véte de mé véknwu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Wani kudi wadéka dé Ebrayamét wak, ‘Wuna képmawaara, wan kaapuk. De deku kudi véknwumarék yaké de yo. Kiyaan du nak nébéle raapme deké yédéran de véknwuké de yo. Véknwute yadan kapéredi mu kulaknyényké de yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naate wadéka dé Ebrayam wak, ‘De Moses wakwen apa kudi Gotna yéba déknyényba wakwen duna kudi wawo véknwumarék yadaran de kiyae nébéle raapmén banna kudi wawo véknwumarék yaké de yo.’ Naate dé Ebrayam wak.” Waga dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Jisas dé déku duwat wak, “Wuné kutdéngék. Kukba du taakwa las Gotna kudi kulaknyénye kapéredi mu yaké de yo. Yénaa yakwa du las wakwedo Gotna kudi véknwukwa du taakwa deku kudi véknwute Gotké kuk kwayédaran apakélé kapéredi mu waga wakwen duké yaaké dé yo. Waga wakweké yaran duwat de taale deku kwaaléba apakélé matu gitakne derét yatjadado de géléguba dawuliye gu ke kiyaado mukatik wan kapéredi mu. De wakwedo Gotna kudi véknwukwa du taakwa deku kudi véknwute Gotké kuk kwayédaran Got waga wakweran duwat yadan kapéredi mu némaanba yakataké dé yo. Wan apakélé kapéredi mu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Guné wani duké jérawu yaké guné yo. “Du nak kapéredi mu yadéran guné dérét waatiké guné yo. Waatigunu dé yadén kapéredi mu kulaknyénydéran guné wani muké tépa sanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dé nakurak nyaa wupmalemu apu gunat kapéredi mu ye gunéké yae kéga wadéran, ‘Gunat yawurén kapéredi muké kélik ye bulaa wuné wani mu kulaknyényké wuné yo.’ Naate wadéran akwi apu guné waké guné yo, ‘Yaak. Yaménén kapéredi muké tépa sanévéknwumarék yaké naané yo.’ Naate waké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisasna du de dérét wak, “Némaan Ban, méné naanat kutkalé yaménu naané Gotké miték sanévéknwute ména jébaaké miték kutdéngké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naate wadaka dé Némaan Ban Jisas dé wak, “Guné Gotké walkamu yéknwun mawulé yagunéran guné apa jébaa yaké guné yo. Kéba tékwa mi mé vé. Guné Gotké walkamu yéknwun mawulé yagunu, guna yéknwun mawulé makwali sék pulak makwali male tédu, kéni mi raapme ye kusba dawuliduké Gorét waatagunéran, kéni mi raapme ye kusba dawuliké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wani kudi watakne dé Jisas derét wak, “Guna du nak déku jébaa yakwa du képmaa dé vao, kapu sipsipké dé téségu? Dé garabu jébaa yabutitakne déku némaan duna gat yédu sal déku némaan du dérét kéga waké dé yo? ‘Méné bari mé yae ra kadému katu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Waga wamarék yate kéga waké dé yo, ‘Méné wuna kadému mé kawu saakéra. Yatakne méné wuna kadému wunéké tiyaaké yo. Tiyaaménu wuné taale kawuru méné méné kukba kaké yo.’ Naate némaan du waké dé yo, déku jébaa yakwa dut. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wadu déku jébaa yakwa du waga yadu, wani némaan du wani muké déku jébaa yakwa duna yéba kevérékmarék yaké dé yo, dé déku jébaa male yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Guné wani jébaa yakwa du pulak Gotna jébaa yaké guné yo. Gotna jébaa yate guné waké guné yo, ‘Naané bakna jébaa yakwa du naané ro. Got tiyaadén jébaa naané yo. Yanan jébaaké guné naana yéba kevérékmarék yaké guné yo.’ Waga waké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalemét yédakwa yaabuba dé yék. Yédéka Sameriana képmaa nak saknwuba tédéka Galilina képmaa nak saknwuba dé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jisas yaabuba ye gayé nak saabadéka de lepéro yan du taaba vétik waga de séknaaba téte dérét de yaabuba vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Véte de némaanba waak, “Némaan du, Jisas, naanéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naate waadaka dé derét véte dé wak, “Guné ye guné Gotna gaba jébaa yakwa nyédé duwat guna sépé wakwatnyéké guné yo.” Naate wadéka de déku kudi véknwute yédaka dé deku sépé tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yadéka dé wani du nak déku sépé yéknwun yadéka véte dé tépa yaak. Yae némaanba waate dé Gotna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kevérékne Jisasna maan wale kwati yaane waadé daate, dé Jisaské yéknwun mawulé yate dé déku yéba kevéréknék. Wani du wan Sameriaba yaan ban. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yadéka Jisas dé wak, “Du taaba vétik deku sépé yéknwun dé yak. Du nak taaba sékét nak taababa kayék wan véti wan véti de yaba de? ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Samuké dé nakurak du male, nak geba yaan du dé déku kapmu gwaamale yaak, Gotna yéba kevérékgé?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naate watakne dé wani dut wak, “Méné wunéké miték sanévéknwute, wuné ménat kutnébulké apa yawurékwaké waménék bulaa méné tépa yéknwun ménébu yak. Méné mé raapme méné yéké yo.” Naate dé Jisas wani dut wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisina du las de Jisasnyét waatak, Got némaan ban rate du taakwaké miték védéran tulé yaaranké. Waatadaka dé derét wak, “Got némaan ban rate du taakwaké miték védéran tulé yaadu guné vémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yagunu du las kéga wamarék yaké de yo, ‘Mé vé. Got deku némaan ban rate, kéba dé ro.’ Naate wamarék yado nak du kéga wamarék yaké de yo, ‘Mé vé. Got deku némaan ban rate, wani taaléba dé ro.’ Naate wamarék yaké de yo, Got némaan ban rate guna mawuléba radékwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wani kudi watakne dé Jisas déku duwat kéga wakwek, “Kukba guné Akwi Du Taakwana Nyaan wunat véké mawulé yaké guné yo. Yate guné wunat vémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wani tulé du las gunat kéga waké de yo, ‘Wani dut mé vé. Akwi Du Taakwana Nyaan kéba dé ro.’ Naate wado las waké de yo, ‘Kaapuk. Waba dé ro.’ Naate wado guné deku kudi véknwumarék yaké guné yo. De yénaa de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wuné Akwi Du Taakwana Nyaan gwaamale giyaawuru akwi du taakwa véké de yo. Nyét kulabidéka akwi du taakwa védakwa pulak, guné akwi wuné giyaawuru véké guné yo. Waga végunéranké sanévéknwute, guné deku yénaa kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Taale bulaa rakwa du taakwa wunat kapéredi mu yate, wunéké kuk tiyaaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Déknyényba Noa ran tulé du taakwa yadan pulak, Akwi Du Taakwana Nyaan wuné gwaamale yaawuréran tulé du taakwa waga male yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa ran tulé du taakwa de Gotké sanévéknwumarék yate, kéni képmaana muké male de sanévéknwuk. Sanévéknwute kadému kadan, gu kadan, taakwa yadan, waga yadaka dé Noa apakélé sip yatakne dé wani sipba wulaak. Wulaadéka apakélé kwayé kwaléka de akwi gu ke kiyaasadak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Déknyényba Ebrayamna wayékna déku nyaan Lot ran tulé Sodomba ran du taakwa waga male yate de rak. De Gotké sanévéknwumarék yate kéni képmaana muké male de sanévéknwuk. Sanévéknwute, kadému kadan, gu kadan, gwalmu kéraadan, gwalmu kwayédan, kadému yaanandan, ga kaadan, waga de yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yadaka dé Lot Sodom kulaknyénytakne yédéka dé apakélé yaa matu wale maas viyaakwa pulak akére dé akwi du taakwat yaalébaanék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wani du taakwa yadan pulak, wuné Akwi Du Taakwana Nyaan giyaawuréran tulé du taakwa waga male yaké de yo. De wunéké sanévéknwumarék yate, deku muké male sanévéknwudo wuné giyaaké wuné yo. Giyaawuru de véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wani tulé kaapaba rakwa du taakwa bari yaage yéké de yo. Deku gwalmu kéraaké deku gat tépa wulaamarék yaké de yo. Bakna yaage yéké de yo. Yaawiba tékwa du taakwa gayét gwaamale ye baapmu wut las wawo kéraamarék yaké de yo. Bari yaage yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Guné Lotna taakwaké sanévéknwuké guné yo. Déknyényba lé léku gayét véké walaakwe lé kiyaak. Guné walaakumarék yate, bakna yaage yéké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Du taakwa wuna jébaa yado wuna maama derét viyaapérekdaran de miték rasaakuké de yo apuba apuba. Du taakwa wuna jébaa yamarék yate, deku sépéké male sanévéknwute, deku jébaa male yadaran de kiyae yalakgé de yo. Miték rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gunat wuné wakweyo. Gwaamale yaawuréran tulé du vétik nakurak jaabéba kwaabéru Gotna kudi kure giyaakwa du naknét kéraate naknét kulaknyényké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wani tulé taakwa vétik kadému kawu saakérabéru Gotna kudi kure giyaakwa du naknét kéraate naknét kulaknyényké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wani tulé du vétik yaawiba jébaa yabéru Gotna kudi kure giyaakwa du naknét kéraate naknét kulaknyényké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wani kudi wadéka véknwute déku du de wak, “Némaan Ban, wani mu yaba yaké dé yo?” Naate wadaka dé Jisas derét wak, “Kwarékadi yaate jawudaka véte guné kiyaan kwaami nak radékwaké kutdéngék. Wani muké kutdénggunékwa pulak, guné wakwewurén mu véte, kutdéngké guné yo, wuné yaawuréranké.” Waga dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas kéni aja kudi dé déku duwat wakwek. De Gorét waatamuké wulkiyaa yamarék yadoké dé derét kéga wakwek. De Gorét waataasaakudo dé deku kudi véknwudéranké dé derét kéni aja kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kéga dé wak: “Némaa gayéba dé kot véknwukwa némaan ban nak rak. Wani du dé Gotké wup yamarék yate, dé du taakwaké wawo kaapuk sanévéknwudén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dukiyaataakwa nak lé wani gayéba rak. Rate akwi nyaa lé kot véknwukwa némaan banké yéte, lé saaki saaki kéga dérét wakwesaakuk, ‘Wuna maama wunat kapéredi mu débu yak. Yadénké méné wunat kutkalé yaké méné yo, kapu yaga pulak?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naate waléka wani du dé wak, ‘Kaapuk.’ Watakne taale lérét kutkalé yamuké kélik dé yak. Yadéka lé wupmalemu apu yéte dérét waataléka kukba dé déku mawuléba wak, ‘Wuné Gotké wup yamarék yate, du taakwaké wawo kaapuk sanévéknwurékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yate wuné wani taakwa akwi nyaa wunéké yaate saaki saaki wunat waatasaakumuké wuné wulkiyaa yo. Lé waga yate wuna mawulé yaalébaanmuké, wuné léku kudi véknwute lérét kutkalé yaké wuné yo.’ Waga dé kot véknwukwa némaan ban wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Némaan Ban Jisas wani kudi watakne dé derét wak, “Guné kot véknwukwa némaan banké mé sanévéknwu. Dé kapéredi mu yakwa du rate dé wani taakwana kudi véknwuk. Wani muké sanévéknwute, kutdéngké guné yo. Got yéknwun mu male yakwa ban rate, dé déku du taakwana kudi véknwuké dé yo. De akwi nyaa akwi gaan dé derét kutkalé yaduké waatate, dérét waatasaakudaran, dé deku kudi véknwuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Véknwute derét bari kutkalé yaké dé yo. Waga kutdénggunuké wuné gunat wakweyo. Guné mé sanévéknwu. Kukba wuné Akwi Du Taakwana Nyaan gwaamale giyae Gotké miték sanévéknwukwa du taakwat véké wuné yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas dé kutdéngék. Du taakwa las deku mawuléba de wak, “Naané Gotna méniba yéknwun du taakwa naané ro. Nak du taakwa déku méniba gweba du taakwa de ro.” Naate wate de kaapuk miték sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Waga kutdéngte dé derét kéni aja kudi wakwek: “Du vétik Got wale kudi bulké nae bét Gotna kudi buldakwa némaa gat waarék. Wani du nak wan Parisina du. Nak wan takis nyégélén du. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisina du waare dé kapmu téte dé Gorét kéga wak, ‘Méné Got, wuné yéknwun du rawurékwaké, wuné ména yéba kevéréknu. Wuné nak du taakwa yakwa pulak yamarék yate, wuné ménat waato. De nak duna gwalmuké mawulat kapére yadakwa, yénaa kudi wakwedakwa, du nak duna taakwa wale kapéredi mu yadakwa waga yate de kapéredi mu yo. Wuné kéba tékwa takis nyégélkwa du kapéredi mu yakwa pulak, kaapuk yawurékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wuné akwi wik wuné nyaa vétik kadému kamarék wuné ro. Rate wuné kéraawurékwa akwi mu muniye tabé nak taaba sékét nak taababa kayék wan véti wan véti takne nakurak tabé wuné ménéké kwayu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naate wadéka dé takis nyégélén du séknaaba dé ték. Téte yadén kapéredi muké nyékéri yate, dé nyérét kaapuk kwaasawuré védén. Yate waadé daate dé Gorét kéga wak, ‘Méné Got wuné kapéredi mu yakwa du. Méné wunéké mé mawulé lékménu.’ Naate dé wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wani kudi watakne dé Jisas derét wak, “Gunat wuné wakweyo. Takis nyégélén du yadén kapéredi mu Got dé yatnyéputik. Yatnyéputidéka dé Gotna méniba yéknwun du rate dé miték yék déku gat. Parisina du dé Gotna méniba yéknwun du kaapuk radén. Deku yéba kevérékgwa du taakwaké kukba Got wadu de bakna du taakwa raké de yo. Deku yéba kevérékmarék yakwa du taakwaké kukba Got wadu de némaan du taakwa raké de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Du taakwa de makwal baadit Jisaské kure yék, dé derét taaba kutte deké Gorét waataduké. Kure yédaka de Jisasna du véte de derét waatik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Waatidaka dé Jisas wani baadit waak, déké yaadoké. Waatakne dé déku duwat wak, “Makwal baadi wunéké de mé yao. Yaado guné derét waatimarék yaké guné yo. Gotna kémba rakwa du taakwa wan wani makwal baadi pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Got némaan ban rate déku du taakwaké miték véké dé yo. Dé waga yadéranké makwal baadi de yéknwun mawulé yo. Makwal baadi yakwa pulak, du taakwa dé deké miték védéranké yéknwun mawulé yadaran de déku kémba yaalaké de yo. Makwal baadi yadakwa pulak yéknwun mawulé yamarék yakwa du taakwa de déku kémba yaalamarék yaké de yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wupmalemu gwalmu yan némaan du nak dé Jisasnyét wak, “Méné yéknwun du rate méné Gotna jébaaké naanat yakwatnyu. Méné mé wakwe. Samu mu ye wuné kulé mawulé kérae apuba apuba miték rasaakuké wuné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Naate wadéka dé Jisas wak, “Samuké méné wunat ‘Yéknwun du’ wo? Got kapmu dé yéknwun ban dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Got wakwedéka Moses wakwen apa kudi méné kutdéngék. Kutdéngte méné véknwuké yo. ‘Méné nak duna taakwa wale kapéredi mu yamarék yaké méné yo. Du taakwat viyaapérekmarék yaké méné yo. Sél yamarék yaké méné yo. Nak duké yénaa kudi wakwemarék yaké méné yo. Méné ména néwepat kutkalé yaké méné yo.’ Moses wani kudi wakwedéka méné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naate wadéka dé wak, “Wuné baadi rawurén tulé wuné wani apa kudi wuné véknwuk. Kéni tulé wawo wuné véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Naate wadéka dé wak, “Méné nak mu wawo yaké méné yo. Méné taknaménén akwi gwalmu nak duké kwayétakne yéwaa nyégéle méné yéwaa yamarék du taakwaké kwayéké méné yo. Kwayéménu kukba Got ménat kutkalé yadu méné Gotna gayét ye waba miték male rasaakuké méné yo. Méné yéwaa yamarék du taakwaké yéwaa kwayétakne gwaamale yae wuna jébaaba yaalaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Waga wadéka wani kudi véknwudéka déku mawulé kapére dé yak, dé wupmalemu yéwaa ye nak duké kwayémuké kélik yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas wani dut véte dé déku duwat wak, “Wupmalemu gwalmu yan du taakwa kwekére ye de Gotna kémba yaalamarék yaké de yo. De apa ye Gotna kémba yaalaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kéni kudi wawo mé véknwu. Apakélé bulmakawu nak baapmu wut kétaapadakwa raaményna yaabuba wulaaké mawulé yadéran apa yaké dé yo. Wupmalemu gwalmu yan du taakwa Gotna kémba yaalaké mawulé yate apat kapére yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Naate wadéka de wani kudi véknwutakne de wak, “Wupmalemu gwalmu yan du taakwa Gotna kémba wulaaké nae apat kapére yadaran yaga pulak gwalmu yamarék yakwa du taakwa Gotna kémba wulae miték rasaakuké de yo apuba apuba? Wan kaapuk. Gotna kémba wulaaké de yapatiké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naate wadaka dé wak, “Du taakwa deku kapmu apa yate, Gotna kémba yaale miték rasaakuké de yapatiyu. Got kapmu wani muké dé apa yo. Got akwi mu yaké dé apa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wani kudi wadéka dé Pita wak, “Mé véknwu. Naané naana ga naana gwalmu wawo kulaknyénytakne naané ména jébaa yate méné wale yeyé yeyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Naate wadéka dé Jisas wak, “Wan adél. Mé véknwu. Wunéké miték sanévéknwukwa du taakwa Gotna jébaa yaké nae deku ga, du, taakwa, némaadugu wayéknaje, néwaa yaapa, baadit kulaknyénydaran Got bulaa derét kutkalé yadu de miték rasaakuké de yo apuba apuba. Adél wuné gunat wakweyo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas déku du taaba vétik sékérék maanba kayék vétik de wale kudi bulte dé derét wak, “Mé véknwu. Bulaa Jerusalemét naané waaru. Waaréno Gotna yéba kudi wakwen du Akwi Du Taakwana Nyaan wunéké Gotna nyégaba kavidan kudi adél yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jerusalemba de wunat nak gena duké kwayédo wuné deku taababa raké wuné yo. Rawuru de wunat wasélékte kapéredi mu yate sépmeny sévaaviké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yate wunat raamény baagwit viyaatakne wunat viyaapérekgé de yo. Yado kiyaawuru nyaa kupuk yédu wuné tépa nébéle raapké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Waga wadéka déku du wani kudiké kaapuk miték kutdéngdan. Got wani mu paakudéka de Jisas wakwedén kudiké kaapuk miték kutdéngdan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas déku du wale de Jeriko saabaké yak. Yadaka méni kiyaan du nak dé yaabuba rate dé du taakwat yéwaaké yaawik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yaawite dé véknwuk wupmalemu du taakwa yédaka. Véknwute dé duwat las waatak, “Wan samu de yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naate waatadéka de dérét wak, “Nasaret ban Jisas dé yao.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naate wadaka dé waak, “Ménawa, Devitna képmawaara Jisas, mé véknwu. Méné Devit pulak némaan ban rate wunéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Naate wadéka de taale yén du dérét waatite de wak, “Akélak mé ra.” Naate wadaka dé kaapuk akélak radén. Tépa waate dé wak, “Méné, Devitna képmawaara, wunéké mé mawulé lékménu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Naate wadéka dé Jisas téte dé derét wak, “Dérét mé kure yaa wunéké.” Naate wadéka dé ye Jisas tén saabadéka dé dérét waatak, “Wuné ménat samu yawuruké méné mawulé yo?” Naate wadéka dé wak, “Némaan Ban, wuné véké wuné mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naate wadéka dé dérét wak, “Ménat kutnébulwuréran apaké miték sanévéknwuménék bulaa ména méni yéknwun dé yo. Bulaa méni mé vé.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Waga wadéka dé déku méni bari tépa yéknwun yadéka dé vék. Véte dé Jisas wale yéte dé wawo Gotna yéba kevéréknék. Yadéka wani mu vén du taakwa de wawo Gotna yéba de kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas dé Jerikot wulaak. Wulae dé nak get yéké nae dé yaabuba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Takis nyégélén du nak déku yé Sakias dé wani gayéba rak. Dé takis nyégélén duna némaan ban rate dé wupmalemu yéwaa taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dé Jisasnyét véké dé mawulé yak. Yadéka wupmalemu du taakwa tédaka dé Jisasnyét véké dé yapatik, dé wap du bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yapatiye dé taale pétépété ye dé miba nak waarék, Jisasnyét véké. Jisas wani yaabuba yaadéranké kutdéngte dé miba nak waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Waare radéka Jisas yae wani taalé saabe dérét kwaasawuré véte dé dérét wak, “Sakias, bulaa méné wale ména gaba raké wuné yo. Méné bari méné giyaaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Waga wadéka dé bari giyaate dé dusék yak. Yate dé Jisasnyét déku gat kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yédéka de akwi du taakwa véte de wak, “Jisas dé kapéredi mu yakwa du wale raké dé déku gat yu. Wan sépélak dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakias dé Némaan Ban Jisasnyét wak, “Némaan Ban, mé véknwu. Bulaa wuné wuna gwalmu nyédéba muniké wuné yo. Muniye nak tabé gwalmu yamarék duké kwayéké wuné yo. Kwayéte kéga wawo yaké wuné yo. Wuné déknyényba duwat las yénaa ye deku gwalmu nyégélwuréran wuné deké tépa kwayéte tabé kupuk wawo kwayéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Naate wadéka dé Jisas wak, “Kéni du dé wawo Ebrayamna képmawaara dé ro. Rate déknyényba Gotké miték sanévéknwumarék yate débu yalaknék. Bulaa guné déku kudi véknwute guné kutdéngék. Bulaa Got dérét déku gaba rakwa du taakwat wawo Setenna taababa débu kéraak. Kéraadénké de déku taababa miték rasaakuké de yo. Yalaknén du taakwaké sékale véte derét Setenna taababa kérae derét kutkalé yaké wuné Akwi Du Taakwana Nyaan kéni képmaat giyaak.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas Jerusalem saabaké dé yak. Yadéka du taakwa de deku mawuléba wak, “Got némaan ban rate naanéké miték védéran tulé bari yaaké dé yo.” Naate wadaka dé Jisas derét aja kudi kéga wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","“Némaan du nak séknaa get yéké yate, taale déku jébaa yakwa du taaba vétiknét waadéka yédaka dé deké nak nak dé yéwaa las kwayék (20 kina, 20 kina pulak). Kwayéte dé derét wak, ‘Kéni yéwaa kure jébaa yagunu wuné tépa gwaamale yae kéraaké wuné yo.’ Naate watakne dé séknaa get yék, waba rakwa némaan ban dérét wadu dé déku gayéba rakwa du taakwaké némaan ban raduké. Ye wani kudi véknwe bari bari gwaamale yaaké dé sanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dé yédéka de déku gayéba ran du taakwa déké kélik yate, de duwat las wadaka de déku kukba yék. Ye de séknaa geba ran némaan banét wak, ‘Naané wani du naanéké némaan ban ramuké kélik naané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kukba wani némaan ban dé wani dut wak, dé déku gayéba rakwa du taakwaké némaan ban raduké. Wadéka véknwutakne re dé tépa gwaamale yaak. Yae dé wak, ‘Déknyényba yéwaa kwayéwurén duwat mé waa yaado. Kwayéwurén yéwaa kure jébaa ye yéwaa yagap de nyégélék?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Naate wadéka du nak taale yae dé dérét wak, ‘Némaan ban, wuné ména yéwaa kure jébaa ye wuné wupmalemu yéwaa nyégélék (200).’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naate wadéka dé némaan du dérét wak, ‘Méné yéknwun jébaa yakwa du méné. Yéknwun jébaa ménébu yak. Méné makwal muké ménébu miték vék. Véménénké wuné wawuru méné gayéké taaba vétik némaan ban raké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Naate wadéka dé nak du wawo yae dé wak, ‘Némaan ban, wuné ména yéwaa kure jébaa ye wuné wupmalemu yéwaa las wawo nyégélék (100).’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naate wadéka dé némaan du wak, ‘Wan yéknwun. Bulaa wuné wawuru méné gayéké naktaba némaan ban raké méné yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Naate wadéka nak du yae dé wak, ‘Némaan ban, wuné ménéké wuné kutdéngék. Méné du taakwaké mawulé kaapuk lékménékwa. Méné gwalmu las wawo bakna kéraaké mawulé yate, méné nak du taakwat kutkalé kaapuk yaménékwa. Wuné ménéké wup yate wuné tiyaaménén yéwaa baapmu wutba kusépme wuné taknak. Ména yéwaa kéba dé ro. Bulaa ménéké tépa wuné kwayu.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naate wadéka dé némaan du wak, ‘Méné kapéredi jébaa yakwa du. Wakweménén kudi véknwute wuné yaménén kapéredi mu ménat yakataké wuné yo. Wuné apa yate nak du taakwaké mawulé lékmarék yate gwalmu las wawo bakna kéraaké mawulé yate, wuné nak du taakwat kaapuk kutkalé yawurékwa. Wan adél méné wak. Waga yawurékwaké ménébu kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kutdéngte samuké wuna yéwaa méné yéwaa taknadakwa gaba taknamarék yak? Méné waba taknaménu mukatik wuné gwaamale yae wani yéwaa kérae yéwaa las wawo kéraakatik wuné yak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naate watakne dé waba tén duwat wak, ‘Guné déké kwayéwurén yéwaa dérét nyégéle guné wupmalemu yéwaa yan duké kwayéké yo.’ Wani jébaa yakwa du dé kwayéwurén yéwaa kure yéknwun jébaa dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naate wadéka de dérét wak, ‘Némaan ban, samu méné yo? Dé wupmalemu yéwaa débu yak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naate wadaka dé derét wak, ‘Yéknwun jébaa ye wupmalemu gwalmu kéraan du taakwa kukba gwalmu las wawo kéraaké de yo. Yéknwun jébaa yamarék yate walkamu gwalmu yan du taakwa kukba bakna raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wuna maama wuné deku némaan ban ramuké kélik yadanké guné derét kure yae wuna méniba viyaapérekgé guné yo.’ Naate dé némaan du wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas wani kudi watakne dé taale ye dé déku du wale Jerusalemét waarédakwa yaabuba waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Waare Betpasi tédéka Betani wawo tédéka dé vék. Wani gayé vétik Oliv nébuba bét tu. Jerusalem tékwaba bét tu. Vétakne saabaké yate dé déku du vétiknét wak, “Béné wani gayét wulae béné véké yo donki nyaanét nak. Miba lékitaknadak dé tu. Déknyényba du déku butgulba kaapuk radén. Béné dérét lépmwénye béné kure yaaké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yabénu du nak bénat kéga waatadéran, ‘Samu yaké béné wani donki nyaan lépmwényu?’ Naate wadéran béné kéga waké béné yo, ‘Némaan Ban dé wani donkiké mawulé yo.’ Waga waké béné yo dérét.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wani kudi véknwutakne bét ye bét vék donki miba lékitaknadaka tédéka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Vétakne wani donkina baagwi lépmwénybétka de wani donkina yaapa yae de bérét wak, “Samu yaké béné wani donki nyaan lépmwényu?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naate wadaka bét wak, “Némaan Ban dé wani donkiké mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naate wabétka kusékétdaka bét donki nyaan kure yék Jisaské. Ye bét bétku baapmu wut las donkina butgulba akutaknak, Jisas waba raduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wani donkiba rate yédéka de du taakwa deku baapmu wurét yaabu kusok. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kusodaka dé ye Oliv nébu kulaknyénytakne dawuliye Jerusalem saabaké yadéka déké miték sanévéknwukwa wupmalemu du taakwa de déké yéknwun mawulé yate dusék takwasék yak. Yate déknyényba vémarék yadan apa jébaa védanké sanévéknwute de némaanba waate de Gotna yéba kevéréknék. Yate de wak: ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Naana némaan ban naanéké dé yao. Némaan Ban Got wadék dé yao. Wan yéknwun. Got dérét kutkalé yaké dé yo. Gotna gayéba rakwa du yéknwun mawulé yate miték raké de yo. Naané yéknwun mawulé yate awuréba rakwa ban Gotna yéba kevérékgé naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisina du las wani du taakwa wale téte véknwute de Jisasnyét wak, “Némaan du, méné du taakwat waatiké méné yo, de waga némaanba waamarék yadoké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naate wadaka dé derét wak, “Gunat wuné wakweyo. De kudi bulmarék yadaran matu deku kapmu wuna yéba kevérékgé de yo.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas ye Jerusalem saabaké yate gayét véte waba rakwa du taakwaké mawulé lékte dé géraak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Géraate dé wak, “Bulaa guné Got wale nakurak mawulé yate raké kutdénggunu mukatik wan yéknwun. Bulaa wani mu paakudék guné kaapuk miték kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Guné Got gunat kutkalé yate Setenna taababa gunat kéraadékwa tuléké kaapuk miték kutdénggunén. Yagunékwaké kukba guna maama yae guna gayé tényéwe téké de yo. Téte de képmaa vae yégunéran yaabuba taknatépéké de yo. Yate de gayét wulae gunat, guna baadit wawo viyaapérekgé de yo. Viyaapérekte akwi ga yaalébaanké de yo. Yaalébaando ga kaagunén akwi matu akére kapmu kapmu raké de yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Jisas ye Jerusalemét wulae dé Gotna kudi buldakwa némaa gat wulaak. Wulae dé vék du las gwalmu kwayéte yéwaa nyégéldaka. Véte dé derét kélésalate dé wak, “Kéni kudi Gotna nyégaba dé kwao: Got dé wak, ‘Du taakwa wuna gat yaale wuné wale kudi bulké de yo.’ Naate dé Got wak. Wani kudiké guné kaapuk sanévéknwugunékwa. Guné kéni gaba Got wale kaapuk bulgunékwa. Guné gwalmu kwayéte yéwaa nyégélgunéka kéni ga wan sél yakwa du paakwe rakwa ga pulak.” Naate dé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Akwi nyaa Gotna kudi buldakwa némaa gaba dé du taakwat Gotna jébaaké yakwatnyék. Yadéka de Gotna gaba jébaa yakwa nyédé duna némaan du, apa kudiké kutdéngkwa du, némaan du las wawo de wak, “Yaga pulak dérét viyaapérekgé naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Waga wate dérét viyaapérekgé de yapatik, akwi du taakwa déké yéknwun mawulé yate déku kudi véknwuké mawulé yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nyaa nak dé Jisas Gotna kudi buldakwa némaa gaba téte du taakwat Gotna jébaaké yakwatnyéte Gotna kudi wakwedéka Gotna gaba jébaa yakwa nyédé duna némaan du, apa kudiké kutdéngkwa du, Isrelna kubu du, waga de déké yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yae de dérét wak, “Samu apa kérae méné wani jébaa yo? Kiyadé wak méné wani jébaa yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naate wadaka dé derét wak, “Wuné wawo gunat nak kudi waataké wunék. Guné wunat mé wakwe. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kiyadé Jonét wak dé du taakwat gu yaakutaknak? Got dé waga wak, kapu képmaaba rakwa du dé nak waga wak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naate waatadéka de deku kapmu bulte de wak, “Naané kéga wanaran, ‘Got dé waga wak.’ Naate wanaran dé naanat kéga waké dé yo, ‘Samuké guné déku kudi kaapuk véknwugunén?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naané kéga wanaran, ‘Képmaaba rakwa du dé nak wak.’ Naate wanaran akwi du véknwute naanat rékaréka yate naanat matut viyaaké de yo, Jonké ‘Gotna yéba kudi wakwen du nak’ naadakwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Waga bultakne de yénaa yate Jisasnyét wak, “Naané las kaapuk kutdéngnan. Wani muké wakwemarék yaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Waga wadaka dé derét wak, “Wuné wawo wakwemarék yaké wuné yo, wunat wadék yae kéni jébaa yawurékwa banké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wani kudi watakne dé du taakwat kéni aja kudi wakwek: “Du nak dé wain yaawi nak yak. Ye dé wain mi tawuk. Ye dé wani yaawiké téségéte yaawiba jébaa yate yéwaa nyégélké mawulé yan duké kwayék. Kwayétakne dé nak képmaat yék. Ye dé wupmalemu kwaaré waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Radéka misék gélédaran tulé yaaké yadéka dé wale rate déku jébaa yakwa dut nak dé wak, dé yaawiké téségékwa duké yéduké. Dé misék las kwayédo kure yaaduké dé mawulé yak. Yate wadéka déku jébaa yakwa du yédéka de yaawiké téségékwa du déku kudi kaapuk véknwudan. Yate de wani dut viyaate wadaka dé bakna gwaamale yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yaadéka déku jébaa yakwa nak dut wadéka, yédéka, dérét wawo viyaate kapéredi mu yate wadaka dé bakna gwaamale yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaadéka déku jébaa yakwa nak dut wawo wadéka, yédéka, dérét némaanba viyaate de dérét kaapat yatjagwadék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yadaka gwaamale yaadéka yaawina bapadu dé wak, ‘Wuné samu yaké wuné yo? Wuné mawulat kapére yawurékwa wuna nyaanét wawuru dé yéké dé yo. Dé ye wadu sal de déku kudi véknwuké de yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Naate watakne dé déku du nyaanét wadéka, yédéka, de yaawiké téségékwa du véte deku kapmu bulte kéga de wak, ‘Yaawina bapadu kiyaadu wani nyaan déku yaapana gwalmu akwi kéraaké dé yo. Naané dérét viyaapérektakne kéni yaawi kéraaké naané yo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Waga watakne de dérét kure yaawi kulaknyénytakne kaapat kure gwaade de dérét viyaapéreknék.” Naate watakne dé Jisas derét wak, “Guné yaga guné sanévéknwu? De waga yadanké wani yaawina bapadu derét samu yaké dé yo? ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dé yae wani wain yaawiké téségékwa duwat viyaapérekgé dé yo. Viyaapérekne nak duké wani yaawi kwayéké dé yo, de yaawiké téségédoké.” Waba tén du taakwa wani kudi véknwute de wak, “Kaapuk. De waga yamarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naate wadaka dé derét véte dé wak, “Gotna nyégaba kéni kudi dé kwao: Ga kaakwa du yéknwun matuké sékalte nakurak matuké kélik yadaka dé bakna rak. Radéka Got wani matut véte dé wak, ‘Wan yéknwun matu. Wani matu radu ga miték kwaaké dé yo.’ Naate watakne wani matu kérae taknadéka dé ga miték kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wani kudiké gunat wuné waato. Kiyadéké dé wo? Wani matu takuba akéréran du deku sépékwaapa kapére yaké dé yo. Wani matu duna sépéba akérédéran wani duwat takupérekgé dé yo.” Naate dé Jisas wak. Wani matuké waga wakwete dé déké dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wani kudi wadéka de apa kudiké kutdéngkwa du Gotna gaba jébaa yakwa nyédé duna némaan du wawo de kutdéngék, Jisas deké dé wani kudi wakwek. Kutdéngte dérét bari kulékiye kure yéké de mawulé yak. Yate du taakwa kélik yate derét waatimuké wup yate de dérét kaapuk kulékidan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yate de dérét kulékidaran tuléké de raségék. Yate deku mawuléba de wak, “Yénaa yakwa du dé wale kudi bulte kés mu nak muké dérét waatadaran sal dé kaatate kapéredi kudi las waké dé yo? Wadu naané dérét kotimké naané yo. Kotimtakne naané dérét Romna duké kwayéké naané yo.” Naate wate de duké las yéwaa kwayék, de yénaa yate dé wale kudi buldoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wani yénaa yakwa du yae de Jisasnyét wak, “Némaan du, méné derét Gotna jébaaké méné yakwatnyu. Méné adél kudi male wakwete derét Gotna kudiké miték méné yakwatnyu. Méné nakurak kudi male méné wakweyo némaan du taakwa, bakna du taakwat wawo. Waga naané kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Méné waga yate bulaa méné naanat mé wakwe. Naana apa kudi yaga dé wo? Naané takis Romna némaan banké kwayéké naané yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Naate wadaka dé Jisas kutdéngék. De deku mawuléba kéga de wak, “Bulaa dé kapéredi kudi wadu naané dérét kotimké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Naate wadaka Jisas kutdéngte dé derét wak, “Guné takis kwayégunékwa yéwaa nak wunat mé wakwatnyé véwuru.” Naate wadéka de wani yéwaa nak kure yék déké. Kure yédaka dé derét wak, “Wani yéwaaba kwaakwa nyaap wan kiyadéna nyaap? Kiyadéna yé de wani yéwaaba kavik?” Naate waatadéka de wak, “Wan Romna némaan bannan.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naate wadaka dé derét wak, “Wan adél. Romna némaan banna mu guné déké kwayéké guné yo. Gotna mu guné Gotké kwayéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naate wadéka de déku kudiké sanévéknwu wanévéknwuk. De du taakwana méniba téte kapéredi kudiké dérét kotimké mawulé yate de waga yaké de yapatik, dé kapéredi kudi wakwemarék yadén bege. Yapatite de kudi kaapuk buldan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Sadyusina du deku mawuléba de kéga wo, “Kiyaan du taakwa tépa nébéle raapmarék yaké de yo.” Naate de wo. De las Jisaské ye de dérét kéga wak, “Némaan du, méné du taakwat Gotna jébaaké méné yakwatnyu. Méné kéni muké naanat mé wakwe. Déknyényba Moses kéga dé kavik: Du nak taakwa ye nyaan kéraamarék ye kiyaadéran déku wayékna wani taakwa yaké dé yo. Yadu nyaan kéraalu wani nyaanké waké dé yo, ‘Wuna némaaduna nyaan.’ Naate waké dé yo. Waga dé Moses kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bulaa mé véknwu. Déknyényba némaadugu wayéknaje nak taaba sékét nak taababa kayék vétik de rak. Némaadu taakwa ye baadi kéraamarék ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kiyaadéka déku wayékna wani taakwa ye baadi kéraamarék ye dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kiyaadéka nak wayékna wani taakwa ye baadi kéraamarék ye dé kiyaak. Kiyaadéka akwi wayéknaje waga male ye de akwi baadi kéraamarék ye de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yadaka kukba lé wani taakwa wawo kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bulaa naanat mé wakwe. Kiyaan du taakwa tépa nébéle raapdaran tuléké méné wakweyo. Wani tulé wani taakwa kiyadéna taakwa raké lé yo? Déknyényba wani némaadugu wayéknaje akwi de lérét yak.” Naate de Sadyusina du Jisasnyét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas deku kudi véknwute dé derét wak, “Bulaa rakwa du taakwa de kéga yo. Du de taakwa yo. Taakwa de du ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kukba Got wadén du taakwa kiyae nébéle raapme du de taakwa yamarék yado taakwa de du ramarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Got wadu de déku baadi raké de yo. De Gotna kudi kure giyaakwa du pulak raké de yo. Got wale rate tépa kiyaamarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kiyaan du taakwa tépa nébéle raapdaranké naané kutdéngék, Moses wani muké kudi wakwedén bege. Makwal mi yaa yaanénké wakwete kéni kudi Gotna nyégaba kavidéka gunébu véknwuk: Némaan Ban Got wan Ebrayamna némaan ban. Wan Aisakna némaan ban. Wan Jekopna némaan ban. Dé deku némaan ban dé ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moses wani kudi déknyényba kiyaan duké kavidéka naané kutdéngék. Got kiyaan du taakwana némaan ban kaapuk radékwa. Got kulé rakwa du taakwana némaan ban dé ro. Got wadén du taakwa wan kiyaan du taakwa kaapuk. Got wadén du taakwa wan kiyae nébéle raapme rakwa du taakwa. Waga naané kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Waga wadéka de apa kudiké kutdéngkwa du las de dérét wak, “Némaan du, méné yéknwun kudi méné wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Naate watakne de kudi las wawo kaapuk buldan, dérét tépa waatamuké wup yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wani tulé Jisas dé derét wak, “Apa kudiké kutdéngkwa du de wo, ‘Got wadén ban Krais wan Devitna képmawaara.’ Samuké de waga wo? ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Déknyényba Devit Kraiské kudi las dé kavik Gotna nyégaba. Devit kavin kudiké naané wo, Sam. Wani kudiba kéni kudi dé kwao: Némaan Ban Got wuna Némaan Banét dé wak, ‘Méné némaan ban rate wuna yéknwun tuwa taababa raké méné yo. Raménu wuné wawuru ména maama ména taababa raké de yo. Rado méné némaan ban rate deké véké méné yo.’ Naate dé Got wak. Gunat wuné wakweyo. Devit wani kudi wakwete dé Kraiské, ‘Wuna Némaan Ban,’ dé naak. Samuké nae dé Devit Kraiské waga wak? ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit Got wadén ban Kraiské ‘Wuna Némaan Ban’ naadéka yaga pulak dé Krais Devitna képmawaara ro? Krais Devitna képmawaara rate, Devitna némaan ban wawo dé ro, kapu yaga pulak?” Naate dé derét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Akwi du taakwa wekna rate de Jisasna kudi véknwuk. Véknwudaka dé déku duwat dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Wakwete dé wak, “Guné apa kudiké kutdéngkwa duké jérawu yaké guné yo. De sémény baapmu wut kusadatakne du taakwa jawudakwa taaléba yeyé yeyaké de mawulé yo. Yeyé yeyate nak du taakwa derét véte kéga wadoké de mawulé yo: ‘Wan naana némaan du dewa yaakwa.’ Naate wadoké de mawulé yo. De Gotna kudi bulnakwa gat wulae de némaan duna taaléba raké de mawulé yo. De nak du wale kadému kate de yéknwun taaléké sékalte, du taakwana méniba raké de mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","De dukiyaataakwana gwalmu akwi de kérao. De yénaa yate apakélé kudi Gorét wakweyo, nak du derét véte deku yéba kevérékdoké. Yadakwaké Got wadu apakélé kapéredi mu deké yaaké dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas Gotna kudi buldakwa némaa gaba téte dé vék wupmalemu gwalmu yan du taakwa Gotké yéwaa kwayédaka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Védéka gwalmu yamarék dukiyaataakwa nak yae makwal yéwaa vétik Gotké kwayéléka dé vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Véte dé wak, “Wupmalemu gwalmu yan du taakwa de Gotké yéwaa las de kwayék. Kwayédaka deku yéwaa las wawo dé ro deku gaba. Wani taakwa makwal yéwaa vétik kwayéte lé kure ralén yéwaa akwi lé kwayék. Kwayétakne lé kadému kéraaléran yéwaa kaapuk. Gotké kwayélékwa yéknwun paaté kwayédakwa paatat débu talaknak. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Jisasna du las de Gotna kudi buldakwa némaa gaké bulte de wak, “Kén yéknwun ga. Yéknwun matut de yak. Du taakwa Gotké kwayédan yéknwun gwalmat miték de kusok.” Naate wadaka dé Jisas derét wak, “Bulaa végunékwa gwalmu kukba nak du yae yaalébaanké de yo. Yaalébaante akwi matu kérae yatjadado matu nak matuba kwaamarék yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wani kudi wadéka de dérét waatak, “Némaan du, yani nyaa wani ga yaalébaanké de yo? Samu mu taale yaadu naané véte wani mu yaamale yadéranké kutdéngké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naate wadaka dé Jisas wak, “Guné jérawu yaké guné yo. Yate yénaa yakwa duna kudi véknwumarék yaké guné yo. Wani kudi wuné wo, wupmalemu du yae de gunat yénaa yaké mawulé yadaran bege. Yénaa yate wuna yéba wakwete de nak nak kéga waké de yo, ‘Got wadén ban Krais bulaa gwaamale yaaké dé yo. Wuné Krais wuné.’ Naate wado guné deku kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wupmalemu du waariyaké de yo. Waariyado nak du waariyadakwaké kudi bulké de yo. Yado véknwute guné wup yamarék yaké guné yo. Taale waga yaké de yo. Sésékukba yaaran tulé kukba yaaké dé yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Watakne dé derét wak, “Nakurak képmaaba rakwa du taakwa de nak képmaaba rakwa du taakwa wale waariyaké de yo. Nak némaan banna kém nak némaan banna kém wale waariyaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wupmalemu apu apakélé anyék kutké lé yo. Wupmalemu képmaaba apakélé kaadé yadu apakélé kiyakiya wawo yaké dé yo. Nyétba wup yadakwa kés pulak nak pulak mu yaadu guné véké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Wani mu wekna yaamarék yadu taale du las, guné wuna du ragunékwaké de wuna jébaaké kélik yate, gunat kulékiye kapéredi mu yaké de yo. Yate de Gotna kudi buldakwa gaba gunat kotimké de yo. De gunat raamény gaba taknaké de yo. Gunat kure yédo guné deku némaan duna méniba téké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","De waga yado wani tulé guné derét wuna kudi wakweké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wakwegunéranké guné taale guna mawuléba kéga wamarék yaké guné yo, ‘Naané deku kudi yaga pulak kaataké naané yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naate wamarék yaké guné yo, wani tulé wuné gunéké yéknwun mawulé, wakwegunéran kudi wawo gunéké kwayéwuréran bege. Wuné waga kwayéwuru wakwegunéran kudi guna maama wakweran kudit talaknaké dé yo. Talaknadu de guna kudi kaataké yapatiké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Guna néwepa, guna némaadugu wayéknaje, guna kémna nak du, guna du taakwa waga de gunat maamaké kwayéké de yo. Kwayédo gunat las viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Guné wuna du ragunékwaké akwi du taakwa gunéké kélik yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Guné guna mawuléba apa yate wuna jébaa kutsaakugunéran guné wuné wale apuba apuba miték rasaakuké guné yo. Yalakmarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wani kudi watakne dé Jisas derét kéga wakwek, “Kukba waariyakwa du Jerusalemét tényéwe tédo véte kutdéngké guné yo. Jerusalemét yaalébaandaran tulé kéni dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kutdéngte guné Judiaba rakwa du taakwa guna gayé kulaknyénytakne nébat bari yaage yéké guné yo. Guné Jerusalemba rakwa du taakwa wani gayé kulaknyénytakne bari yaage yéké guné yo. Guné yaawiba tékwa du taakwa wani gayét wulaamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Waga wuné wo, wani tulé wan Got Jerusalemba rakwa du taakwa yadan kapéredi mu derét yakatadéran tulé bege. Déknyényba du las wani muké de kudi las kavik Gotna nyégaba. Wakwewurékwa tulé wani kudi adél yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wani kapéredi tulé nyaan tékwa taakwa, baadiké munyaa kwayékwa taakwa wawo bari yaage yéké yapatiké de yo. Deké wuné mawulé léknu. Wani tulé Got rékaréka yate wadu wupmalemu kapéredi mu Judana du taakwaké yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yaadu maama yae de Judana du taakwat las waariyadakwa kulaat viyaado de kiyaaké de yo. Lasnyét de kulékiye kure ye nak geba taknaké de yo. Ye wani maama nak geba yae de Jerusalemét yaalébaanké de yo. Yaalébaantakne de Jerusalemba némaan du raké de yo. Re Got wadén tulé tépa yéké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nyaa, baapmu, nyétba tékwa kun kés pulak nak pulak mu yadu du taakwa véké de yo. Kus némaanba raapte wilu wupmalemu képmaaba rakwa du taakwa véte wup yate géraaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yado nyétba tékwa akwi mu ségénte yeyé yeyaké de yo. Yado wupmalemu du taakwa génte wupmét kapére yate sanévéknwu wanévéknwute waké de yo, ‘Yéwe. Samu kapéredi mu dé naanéké yaaké dé yo?’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naate watakne de Akwi Du Taakwana Nyaan wunat véké de yo. Wuné apat kapére yate nyaa vékwa pulak yate buwiba rate giyaawuru véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gunat wuné wakweyo. Wani mu batnyé yaadu guné kutdéngké guné yo. Walkamu re wuné gunat kérae Gotna gayét kure yéké wuné yo. Waga kutdéngte guné yéknwun mawulé yate raapme kwaasawuré véké guné yo.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Watakne dé derét kéga wak, “Miké miték mé sanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mi las gaga périye kwény lépidéka véte guné kutdéngék. Kadému naaré yakwa tulé bulaa dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wani mit véte tuléké kutdénggunékwa pulak, guné wakwewurén mu véte kutdéngké guné yo. Got némaan ban rate du taakwaké miték védéran tulé kéni dé yao. Waga kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gunat wuné wakweyo. Bulaa rakwa du taakwa las kiyaamarék yate wekna rate wakwewurén akwi mu véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nyét képmaa wawo kaapuk yaké dé yo. Wuna kudi kaapuk yamarék yaké dé yo. Rasaakuké dé yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Guné jérawu yaké guné yo. Du las wupmalemu kadému kadakwa, waagété gu kate waagété yadakwa, kéni képmaana muké male sanévéknwudakwa, waga yate de kaapuk miték sanévéknwudakwa. Guné de yakwa pulak yamarék yaké guné yo. Guné de yakwa pulak yagunéran guné wunéké sanévéknwumarék yagunéran tulé gwaamale yaaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gwaamale yaawuréran tulé kéni képmaaba rakwa akwi du taakwaké bari yaaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Guné akwi nyaa wunéké raségéké guné yo. Raségéte guné Gorét apuba apuba waataké guné yo, dé gunéké apa kwayéduké. Waatagunu apa kwayéké dé yo, yaaran kapéredi mu gunat yaalébaanmarék yadu guné wuné Akwi Du Taakwana Nyaan wuna méniba miték tégunuké.” Naate dé Jisas derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Akwi nyaa Jisas Gotna kudi buldakwa némaa gaba téte dé Gotna jébaaké du taakwat yakwatnyék. Yadéka gaan yadéka yéte dé Oliv nébuba kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yadéka akwi ganbaba akwi du taakwa de Gotna kudi buldakwa némaa gat yék, déku kudi véknwuké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yis kutmarék yadakwa béret kadaran nyaa dé yaaké yak. Wani nyaa de Juda apakélé kadému sérakne kaké de yo. Wani kadémuké de wo Pasova. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wani tulé de Gotna gaba jébaa yakwa nyédé duna némaan du, apa kudiké kutdéngkwa du wawo waga de Jisasnyét viyaapérekgé mawulé yak. Yate de du taakwa kélik yate waariyamuké wup yate de wak, “Naané Jisasnyét yaga pulak viyaaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wani tulé dé Seten Judasna mawuléba wulaak. Déku nak yé Iskariot. Dé wan Jisasna du nak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wulaadéka dé Judas ye dé nyédé duna némaan du, Gotna kudi buldakwa némaa gaké téségékwa duna némaan du wawo de wale dé kudi bulék, Jisasnyét deké kwayédéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Buldéka de dusék yate de déké yéwaa las kwayéké kudi gik. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Gidaka dé Judas kusékéttakne ye dé Jisasnyét deké akélak kwayédéran tuléké dé raségék. Wupmalemu du taakwa Jisas wale ramarék yadaran tuléké dé raségék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis kutmarék yadakwa béret kadakwa nyaa dé yaak. Wani nyaa de sipsip nyaanét viyao, Pasova waadakwa tuléna kadémuké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Viyaapérekdakwaké sanévéknwute Jisas dé Pita bét Jonét wak, “Béné ye Pasova waanakwa tuléna kadému kawu saakérabénu naané kaké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naate wadéka bét dérét wak, “Ané yaba kawu saakératuké méné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Naate waatabétka dé wak, “Mé véknwu. Béné ye Jerusalemét wulae gu tékwa awu yaataran dut nak véké béné yo. Véte béné déku kukba ye wulaadéran gat wulaaké béné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wulae béné wani gana bapadut kéga waké béné yo, ‘Gotna kudiké naanat yakwatnyékwa ban dé ménat kéga dé wo, Wuné wuna du wale Pasova waanakwa tuléna kadému kanaran ga yaba dé tu? Naate dé wo.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Waga wabénu dé awuréba tékwa némaa ga wakwatnyéké dé yo. Wani gaba kadému kanaran jaabé, ranaran mu wawo dé tu. Béné wani gaba kadému kawu saakéraké béné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naate wadéka bét ye bét Jisas wakwen pulak bét vék. Vétakne bét Pasova waanakwa tuléna kadému kawu saakérak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jisas déku nak du wale yae de akwi de kadému kaké de rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rate dé Jisas derét wak, “Kukba wuné apa kaagél kutké wuné yo. Taale wuné kéni kadému, Pasova waanakwa tuléna kadému, guné wale kaké wuné mawulat kapére wunébu yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gunat wuné wakweyo. Wuné kéni képmaaba rate guné wale kéni kadému tépa kamarék yaké wuné yo. Kukba Got du taakwaké némaan ban raran tulé yaadu wuné tépa kaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naate watakne dé wain gu tén agérap nak kérae dé Gorét wak, “Yéknwun gu ménébu tiyaak. Wan yéknwun.” Naate watakne dé déku duwat wak, “Guné kérae nak nak kaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gunat wuné wakweyo. Wuné kéni képmaaba rate wani gu tépa kamarék yaké wuné yo. Kukba Got du taakwaké némaan ban raran tulé yaadu wuné wani gu tépa kaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naate watakne dé béret kérae dé Gorét wak, “Yéknwun mu ménébu tiyaak. Wan yéknwun.” Naate watakne béret bule dé déku duké kwayéte wak, “Kén wuna sépé. Gunat kutkalé yaké wuné wuna sépé kwayu. Guné wunéké sanévéknwute waga yasaakuké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naate watakne de akwi kadému kabutitakne dé Jisas wain gu tén agérap kérae waga male yate dé wak, “Kéni wain gu wan wuna wény. De wunat viyaapérekdo wuna wény akudu guné véte kutdéngké guné yo, Got du taakwat kutkalé yaké wakwedén kulé kudi adél yadéranké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wani kudi watakne dé Jisas derét wak, “Mé véknwu. Wunat maamaké kwayéran du bulaa dé wuné wale rate kadému ko. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Déknyényba de Gotna nyégaba kudi kavik, maama wunat viyaadaranké. Kavidan pulak de Akwi Du Taakwana Nyaan wunat viyaado wuné kiyaaké wuné yo. Kiyaawuru apakélé kapéredi mu dé wunat maamaké kwayéran duké yaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Naate wadéka deku kapmu bulte de waatak, “Kiyadé waga yaké yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasna du de kudi bulte waaruk. Waarute de wak, “Naané wale rakwa du kiyadé wan naana némaan ban?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Naate wadaka dé derét wak, “Nak geba rakwa du taakwana némaan du de apa yate deku du taakwaké de vu. Védaka deku du taakwa de deké wo, ‘Wan naanat kutkalé yakwa du.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Naate wadaka guné wani némaan du pulak yamarék yaké guné yo. Guna du nak némaan ban radéran dé du taakwana kukba yaaran du pulak rate, déku yéba kevérékmarék yaké dé yo. Dé némaan ban rate, dé jébaa yamarék yate bakna rakwa ban pulak ramarék yate, guna jébaa yakwa du raké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nak geba rakwa du yaga pulak de yo? Deku némaan ban yaga pulak du dé? Rate kadému kakwa ban, kapu déké kadému kure yaakwete jébaa yakwa ban? Wan rate kadému kakwa ban dé kapmu dé némaan ban ro. Wuné guné wale rate wuné waga kaapuk yawurékwa. Wuné guné wale rate guna jébaa yakwa du wuné ro. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Guné wuné wale gunébu rasaakuk. Kapéredi mu wunéké yaadéka guné wunat kaapuk kulaknyénygunén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Wuna yaapa débu apa tiyaak, wuné némaan ban rate du taakwaké miték véwuruké. Tiyaadén apa kérae wuné gunéké apa kwayéké wuné yo, guné wuné wale rate wuné wale kadému gu kate, Isrelna kém taaba vétik sékét maanba kayék vétikgé némaan du rate végunuké.” Naate dé Jisas déku duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas dé Saimon Pitat wak, “Saimon, méné mé véknwu. Seten dé gunéké apa yadu guné yaage ye kapmu kapmu rate yalakgunuké dé mawulé yo. De kadému munidakwa pulak dé gunat muniké dé mawulé yo. Seten gunat yaalébaanké dé mawulé yo. Yate Gorét dé waatak, dé waga yadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wuné Gorét wunébu waatak. Méné, Saimon, ménéké Gorét wunébu waatak, méné wunéké miték sanévéknwuménu ména mawulé miték tésaakuduké. Tédu méné wunéké kuk tiyae kukba gwaamale yae méné wuna duna mawulat kutkalé yaménu deku mawulé wawo miték tésaakuké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naate wadéka dé Pita dérét wak, “Némaan Ban, wuné méné wale yéké wuné mawulé yo. Wuné méné wale yéte raamény gaba kwaawuréran wan yéknwun. Wuné méné wale yéte kiyaawuréran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Naate wadéka dé Jisas dérét wak, “Pita, wuné kutdéngék. Bulaa gaan séraa waamarék yadu méné apu kupuk kéga waké méné yo, ‘Wuné Jisasnyét las kaapuk kutdéngwurén.’ Waga waménu séraa waaké dé yo.” Naate dé Jisas Pitat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas dé déku duwat kéga wak, “Déknyényba gunat wawuréka yéte guné yéwaa, wut, su kaapuk kure yégunén. Wani tulé gwalmuké nak guné yapatik kapu kaapuk?” Naate wadéka de wak, “Kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naate wadaka dé derét kéga wak, “Bulaa wuné gunat kéga wo. Guné yéwaa kure tégunéran guné yéwaa kure yéké guné yo. Guné wut kure tégunéran guné wut kure yéké guné yo. Waariyagunékwa kulaa yamarék yagunéran guné guna baapmu wut nak kwayétakne yéwaa nyégéle guné waariyagunékwa kulaa kéraaké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wani kudi wuné wo, Gotna nyégaba kwaakwa kéni kudi adél yaké yadékwa bege. Wani kudi kéga dé kwao: Déké de wak, ‘Wan kapéredi mu yakwa ban. Dérét viyaaké naané yo.’ Wani kudi kavite de wunéké de kavik.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naate wadéka de wak, “Némaan ban, méné mé vé. Naané waariyanakwa kulaa vétik naané kure ro.” Naate wadaka dé kutdéngék. De déké yaaran kapéredi muké kaapuk miték kutdéngdan. Waga kutdéngte deku kudi kaatate dé wak, “Wan yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wani kudi watakne Jisas gwaade dé Oliv nébat yék, wupmalemu apu déknyényba yadén pulak. Déku du wawo de dé wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ye wani taalé saabe dé derét wak, “Guné Gorét waataké guné yo, dé gunat kutkalé yadu kapéredi mu gunat yaalébaanmarék yaduké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Naate wadéka de radaka dé matu kwekére yatjatidaka akérékwa pulak dé walkamu yék. Ye dé kwati yaane Gorét kéga waatak, “Wuna yaapa, méné akwi muké méné apa yo. Yaaran muké waké mawulé yaménéran méné waménu wunéké yaaran kapéredi mu wunéké yaamarék yaké dé yo. Waga ménat wuné waato. Méné mawulé yawurékwa pulak yamarék yaké méné yo. Méné mawulé yaménékwa pulak yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Naate wadéka dé Gotna kudi kure giyaakwa du nak Gotna gayéba giyae dé déku mawulat kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisasna wuraanyan kapére yate géndéka dé Gorét tépa waatasaakuk. Waatasaakudéka dé waagéré wény pulak akwe dé képmaaba akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas Gorét waatatakne dé raapme te déku duké yék. Ye dé vék de widé kwaadaka. De némaa mawulé lékdaka deku mawulé kapére yadéka deku méniba widé yadéka de kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kwaadaka véte derét waaséligénte dé derét wak, “Guné samuké guné widé kwao? Widé kwaamarék yaké guné yo. Guné raapme Gorét waataké guné yo, kapéredi mu gunat yaalébaanmarék yaduké.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wani kudi wekna wadéka de wupmalemu du yaak. Jisasna du nak Judas yaabu taalédéka de wani du yaak. Judas Jisasna taama véké (daama réngké) nae dé Jisas tén saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Saabadéka dé Jisas dérét wak, “Judas, wan méné Akwi Du Taakwana Nyaan wunat taama véte (daama réngte) méné maamaké kwayu, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisasna du dé wale téte de kutdéngék, deké yaan du Jisasnyét kulékiye kure yédaranké. Waga kutdéngte de Jisasnyét wak, “Némaan Ban, naané derét waariyanakwa kulaat viyaaké naané yo, kapu yaga pulak yanoké méné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Naate watakne deku du nak dé nyédé duna némaan banké jébaa yakwa dut viyaate déku yéknwun tuwa saknwuba tén waan takutépakdéka dé akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yadéka Jisas véte dé wak, “Yaak. Waga yamarék yaké guné yo.” Naate watakne dé wani duna waanba kutdéka dé tépa yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nyédé duna némaan du, Gotna kudi buldakwa némaa gaké téségékwa duna némaan du, Isrelna kubu du, waga de yaak, Jisasnyét kulékiye kure yéké. Yae Jisas waga yadéka vétakne tédaka dé Jisas derét wak, “Guné wunat kulékiké yaate samuké guné waariyagunékwa kulaa baagé wawo kure yao? Guné sél yakwa dut viyaaké guné wani mu kure yao, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wupmalemu nyaa wuné Gotna kudi buldakwa némaa gaba guné wale wuné rak. Rawuréka guné wunat kaapuk kulékigunén. Bulaa guné guna jébaa yaké guné yo. Bulaa gaankétéké rakwa némaan ban Seten apa yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas wani kudi wadéka de dérét kulékiye kure yék. Kure ye de nyédé duna némaan ban déku gat kure wulaak. Wulaadaka dé Pita deku kukba ye dé séknaaba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tédéka de Jisasnyét kure yén du las raatmu gisagwadédan taalat wulae kaapaba rate de yaa séraknék. Séraktakne radaka dé Pita de wale yaaba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Radéka lé jébaa yakwa taakwa nak dérét vék. Véte déku ménidaamat vésék naate lé wak, “Kéni du wawo Jisas wale dé ték.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naate waléka dé Pita wak, “Nyéna, wuné dérét las kaapuk kutdéngwurén.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Naate wadéka walkamu re kukba dé du nak dérét véte dé wak, “Méné wawo Jisasna du méné.” Naate wadéka dé wak, “Ména, wuné kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naate wadéka walkamu re kukba dé du nak wawo dérét véte dé némaanba wak, “Kéni du wawo dé Galiliba yaan du dé. Dé wawo dé Jisas wale ték. Wan adélna.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naate wadéka dé Pita wak, “Ména, wuné bulménékwa kudiké las kaapuk kutdéngwurén.” Waga wekna wadéka dé séraa nak bari waak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Waadéka dé Némaan Ban Jisas séknaa pulakba téte walaakwe dé Pitat vék. Védéka dé Jisas dérét taknaba wakwen kudiké dé sanévéknwuk. Taknaba Jisas dé dérét wak, “Wuné kutdéngék. Bulaa gaan séraa waamarék yadu méné apu kupuk waké méné yo, ‘Wuné Jisasnyét las kaapuk kutdéngwurén.’ Waga waménu séraa waaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wani kudiké sanévéknwute Pita gwaade némaa mawulé lékte dé géraak, dé Jisaské kuk kwayédén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisasnyét kurén du dérét waagite wasélékte de dérét viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Viyaate déku méniba baapmu wurét gitakne de dérét wak, “Méné Gotna yéba kudi wakwekwa du rate méné akwi muké méné kutdéngék. Kutdéngte, naanat mé wakwe. Kiyadé ménat viyaak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Naate wate de wupmalemu kapéredi kudi las wawo dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nyaa yaaladéka de Isrelna kubu du, nyédé duna némaan du, apa kudiké kutdéngkwa du waga yae de jawuk. Jawe radaka de Jisaské téségékwa du dérét kure yaak deké. Kure yaadaka dé deku méniba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tédéka de dérét wak, “Méné naanat mé wakwe. Méné Got wadén ban Krais, kapu kaapuk?” Naate wadaka dé derét wak, “Wuné gunat wakwewuréran guné miték véknwumuké kélik yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wuné gunat kudi waatawuréran guné wuna kudi kaatamuké kélik yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kukba wuné Akwi Du Taakwana Nyaan némaan ban rate, apat kapére yakwa ban Gotna yéknwun tuwa taababa raké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naate wadéka de akwi wak, “Yaga méné wo? Méné Gotna nyaan méné ro, kapu kaapuk?” Naate wadaka dé wak, “Ao. Guné kapmu guné waga wak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Waga wadéka de wak, “Déku kapmu dé kapéredi kudi wakwedéka naanébu véknwuk. Véknwutakne naané yadén muké kudi las wawo véknwumarék yaké naané yo.” Naate de Isrelna némaan du wak Jisaské. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wani némaan du de akwi raapme de Jisasnyét Romna némaan du déku yé Pailatké kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kure ye de Jisaské dérét kéga wak, “Kéni du dé kapéredi muké naana du taakwat yakwatnyék. Naanat débu wak, ‘Guné Romna némaan banké takis kwayémarék yaké guné yo.’ Naate wate dé wak, ‘Wuné némaan ban wuné ro. Wuné Got wadén ban Krais wuné.’ Naate wadéka dérét ménéké naanébu kure yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Naate wadaka dé Pailat Jisasnyét waatak, “Méné Judana némaan ban, kapu yaga pulak?” Naate wadéka dé Jisas wak, “Ao. Méné kapmu méné waga wak,” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naate wadéka dé Pailat nyédé duna némaan du, de wale tén wupmalemu du béré taakwa bérat wawo dé wak, “Kéni du kapéredi mu las kaapuk yadén. Waga wuné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Waga wadéka de némaanba waate de wak, “Déku kudi Judiaba rakwa akwi du taakwat wakwedéka de miték ramarék yate waariyaké de mawulé yo. Taale Galiliba kudi wakwetakne bulaa kénét yae dé naanat waga wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat wani kudi véknwutakne dé derét waatak, “Kéni du kén Galilina du, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Naate wadéka de kusékérék. Kusékétdaka Pailat dé kutdéngék. Déknyényba Romna némaan ban wadéka dé Yerot némaan ban dé rak Galilina taaléba. Jisas Galilina du radéka Yerot Jisaské dé némaan ban rak. Wani tulé Yerot wawo Jerusalemba dé rak. Waga kutdéngte Pailat wadéka de Jisasnyét kure yék Yerotké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Déknyényba Yerot Jisaské kudi véknwutakne dérét véké dé mawulé yak. Wupmalemu baapmu re Jisasnyét vémarék yadéka wani tulé dérét déké kure yaadaka dé Yerot véte dé dusék yak. Jisas déknyényba vémarék yadén apa jébaa nak déku méniba yaduké mawulé yate dé dusék yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yate dé Jisasnyét wupmalemu muké waatak. Waatadéka Jisas déku kudi las kaapuk kaatadén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yadéka de nyédé duna némaan du, apa kudiké kutdéngkwa du wawo waba téte de némaanba Jisasnyét waatite Yerotnét kapéredi kudi wakwek Jisaské. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Wakwedaka Jisas Yerotna kudi kaatamarék yadéka dé Yerot déku du wale de Jisasnyét waagite waséléknék. Déké “Gweba du” naate dé Yerot dérét waagite waséléknék. Yate dé wak, “Du taakwana némaan ban dé yéknwun baapmu wut male dé kusado.” Naate wate dé wadéka de yénaa yate yéknwun baapmu wut kérae Jisasnyét kusadatakne dérét waagite, dérét de gwaamale kure yék Pailatké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Déknyényba Pailat Yerotna maama dé rak. Pailat Yerotna yéba kevérékte wadéka Jisasnyét Yerotké kure yédan tulé, Yerot wani muké dusék yate dé Pailat wale nakurak mawulé yate bét miték rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat wadéka de nyédé duna némaan du, Isrelna némaan du wupmalemu du taakwa wawo yae de jawuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jawudaka dé derét wak, “Guné kéni dut wunéké kure yae guné wak, ‘Dé du taakwana yéknwun mawulé dé yaalébaanu. Dé wupmalemu kapéredi mu débu yak.’ Naate wagunéka wuné guna méniba téte wuné dérét wani muké waatak. Waatatakne wuné gunat kéga wo. Dé wakwegunén kapéredi mu las kaapuk yadén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yerot wawo waga male dé wo. Waga wadék de dérét gwaamale kure yaak wunéké. Mé véknwu. Naané dérét viyaapérekmarék yaké naané yo, kapéredi mu las yamarék yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wuné wawuru wuna du dérét bakna male viyaado dé miték yéké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akwi kwaaré Pasova kadému kadakwa tulé dé Romna némaan du raamény gaba kwaakwa dut nak wadéka dé raamény ga kulaknyénytakne dé miték yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailat wani kudi wadéka de waba tén du taakwa de akwi némaanba kéga waak, “Wani dut viyaapérektakne méné Barabasnyét waménu dé raamény ga kulaknyénytakne yaale miték yéké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Déknyényba wani du Barabas Romna duké kélik yate Jerusalemba rakwa du taakwat wakwedéka de Romna du wale waariyak. Nak apu Barabas dut nak dé viyaapéreknék. Waga yadéka de dérét raamény gaba taknadaka dé waba kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Waba tén du taakwa waga waadaka dé Pailat Jisas miték yéduké dé mawulé yak. Yate dé derét tépa wak, Jisas miték yédéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wadéka de kélik yak. Yate de némaanba waate de wak, “Dérét miba mé viyaapata takna. Dérét miba mé viyaapata takna.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naate wadaka dé derét tépa wak, “Samuké? Samu kapéredi mu dé yak? Naané dérét viyaapérekmarék yaké naané yo, kapéredi mu las yamarék yadén bege. Wuné wawuru wuna du dérét viyaado dé miték yéké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Naate wadéka de kélik yate némaanba waate de wak, dé wadu de Jisasnyét miba viyaapata taknadoké. Waga wate de Pailatna kudi kaapuk véknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yadaka dé Pailat kusékéttakne dé de wan pulak yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yate dé wadéka mawulé yadan du Barabas raamény ga kulaknyénytakne gwaade dé miték yék. Déknyényba Barabas Romna duké kélik yate, du taakwat wakwedéka de Romna du wale waariyak. Nak apu Barabas dut nak dé viyaapéreknék. Waga yadéka de dérét raamény gaba taknadaka dé waba kwaak. Pailat Barabas miték yéduké watakne dé wak, de Jisasnyét miba viyaapata taknadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Romna waariyakwa du Jisasnyét kure yéte de vék Sairiniba yaan ban déku yé Saimon Jerusalemét wulaaké yadéka. Véte dérét kulékiye de wak, dé Jisasnyét viyaapata taknadaran mi yaate Jisasna kukba yéduké. Wadaka yaate dé de wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yédaka de wupmalemu du taakwa de Jisasna kukba yék. Yéte de taakwa las némaa mawulé lékte de déké némaanba géraak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Géraadaka Jisas walaakwe dé derét wak, “Guné Jerusalemba rakwa taakwa, guné wunéké géraamarék yaké guné yo. Guné guna sépéké, guna baadiké wawo géraaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kapéredi tulé yaadu du taakwa kéga waké de yo, ‘Kéni kapéredi tulé taakwa deku nyaanké de némaa mawulé léknu. Lékdakwaké sanévéknwute nyaan kéraaké yapatikwa taakwa, nyaan kéraamarék yan taakwa, baadiké munyaa kwayémarék yan taakwa, wani taakwa yéknwun mawulé yaké de yo, kéni kapéredi tulé deku nyaan ramarék yadaran bege.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wani kapéredi tulé du taakwa deké yaaran kapéredi muké wup yate kéga waké de yo, ‘Nébu dé mé akére naanat saaptépu.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wuné kapéredi mu las kaapuk yawurén. De wunat kéni kapéredi mu bakna yadaran yaga pulak yaké de yo, Jerusalemba rate kapéredi mu yakwa du taakwat? Derét wupmalemu kapéredi mu yaké de yo.” Naate dé Jisas wani taakwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kapéredi mu yan du vétiknét wawo de waariyakwa du kure yék. Bérét Jisas wale viyaapérekgé nae de kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kure ye de Maakna Apa waadakwa taalé saabak. Saabe waba de Jisasnyét miba viyaapata taknak. Yatakne de wani kapéredi mu yan du vétiknét wawo mi vétikba viyaapata taknak. Naknét de Jisasna yéknwun tuwa saknwuba viyaapata taknak. Naknét de déku aki tuwa saknwuba viyaapata taknak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisasnyét miba viyaapata taknadaka dé Jisas wak, “Wuna yaapa, méné wunat yadakwa kapéredi muké sanévéknwumarék yate méné derét yakatamarék yaké méné yo. De yadakwa muké kaapuk kutdéngdan.” Naate dé wak. Jisasnyét miba viyaapata takne de rate déku baapmu wut muniké de makwal matu yatjawurék. Yatjawurédaka waare giyaa akére derét talaknan ban dé déku baapmu wut kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yadaka de du taakwa téte de vék. Védaka de Isrelna némaan du Jisasnyét waagite wasélékte de wak, “Dé nak duwat dé kutkalé yak. Dé naanat kutkalé yaduké Got wadén ban Krais radéran déku kapmu déku sépat kutkalé yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Naate wadaka de waariyakwa du wawo dérét waagite wasélékte déké yae nyégi yakwa wain gu de kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kwayéte de wak, “Méné Judana némaan ban raménéran méné ména kapmu ména sépat kutkalé yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisasnyét viyaapata taknadan mi awuréba kaviye taknadan kudi wan kéga: Kéni du kén Judana némaan ban. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jisas wale miba viyaapata taknadan du nak dé Jisasnyét waatite dé wak, “Méné méné wak, méné naanat kutkalé yaménuké Got wadén ban raménékwaké. Méné adél kudi wakweménéran bulaa ména kapmu ména sépat kutkalé yate anat wawo mé kutkalé ya.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Naate wadéka dé Jisas wale miba viyaapata taknadan nak du dérét waatite dé wak, “Jisas kiyaadéran pulak méné kiyaaké méné yo. Yate Gotké wup yamarék yate méné wani kapéredi kudi wakweyo, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kapéredi mu yaténké de anat viyaapérekdaran wan yéknwun. Kéni du kapéredi mu las kaapuk yadén.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naate watakne dé wak, “Jisas, méné apa yate du taakwaké némaan ban raké gwaamale yaate méné wunéké sanévéknwuké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Naate wadéka dé Jisas wak, “Bulaa méné wuné wale yéknwun taaléba raké méné yo. Adél wuné ménat wakweyo.” Naate dé Jisas dérét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nyaa nawurédéka dé akwi képmaaba gaan yak. Ye tédéka nyaa kaapuk védén. Kukba nyaa tégéruwe dawuliké yadéka dé Gotna kudi buldakwa némaa gaba lékitaknadan sémény baapmu wut nyédéba gétbiyae dé taakwi vétik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yadéka dé Jisas kéga némaanba waak, “Wuna yaapa, wuna wuraanyan ména taababa wuné takno.” Waga watakne dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kiyaadéka dé waariyakwa duna némaan du véte Gotna yéba kevérékte dé wak, “Wani du wan yéknwun mu male yan du. Wan adél.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wani mu véké yae jawe tén akwi du taakwa Jisas kiyaadéka véte némaa mawulé lékte de deku gayét gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yédaka Jisasnyét kutdéngén du, taakwa las wawo waga de séknaa pulak téte de wani mu yadéka de vék. Déknyényba Jisas Galili kulaknyénytakne yédéka de wani taakwa dé wale de yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Arimatiaba yaan du dé nak rak. Déku yé Josep. Déku gayé wan Judana gayé nak. Dé yéknwun mu male yakwa du rate, dé Got némaan ban rate du taakwaké véran tuléké dé raségék. Déknyényba dé kubu du rate nak kubu du wale jawe rate, Jisasnyét viyaapérekgé buldan kudiké kaapuk kusékétdén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dé Romna némaan du Pailatké ye dé Jisasna gaaba ségwi kéraaké waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Waatadéka dé kusékétdéka ye dé Jisasna gaaba ségwi lépmwénye kure giyae dé waama baapmu wurét kusépme dé waaguba nak taknak. Déknyényba wani waagu déku jébaa yakwa du de matuba vaakére wulaak. Déknyényba wani waaguba kiyaan dut nak kaapuk taknadan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Garabu dé Josep Jisasna gaaba ségwi waaguba taknak. Judana yaap ra nyaa yaaké yadéka dé Josep waga yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galiliba Jisas wale yaan taakwa de Josepna kukba ye de vék dé Jisasna gaaba ségwiba yéknwun yaama yakwa mu kutmarék ye bakna taknadéka. Taknadén taalé wawo de vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vétakne gayét gwaamale ye de gaaba ségwiba kutké nae yéknwun yaama yakwa mu kawu saakérak. Yaap ra nyaa de Moses wakwen apa kudi wadén pulak de yaap rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yaap ra nyaa yédéka Sande ganbaba nyaa yaalaké yadéka wani taakwa de kawu saakéradan yéknwun yaama yakwa mu kérae kure de yék. Jisasna gaaba ségwi taknadén taalat de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ye de vék waaguba taknatépédan matu yatbalaaku taknadaka radéka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vétakne de waaguba wulae de Némaan Ban Jisasna gaaba ségwi radéka kaapuk védan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yatakne wani muké sanévéknwu wanévéknwute waba tédaka du vétik bari giyae bét de wale ték. Bétku baapmu wut waamat kapére yate dé kayénarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tébétka de wup yate de kwati yaane deku ménidaama képmaaba taknak. Taknadaka bét wak, “Samu yaké guné kiyaan duna taaléba nébéle raapme rakwa duké sékalu? ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dé kéba kaapuk radékwa. Débu tépa nébéle raapmék. Dé Galiliba wekna rate gunat wakwedén kudiké sanévéknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dé kéga dé wak, ‘De Akwi Du Taakwana Nyaan wunat kapéredi mu yakwa duké kwayédo de wunat miba viyaapata taknado wuné kiyaawuru nyaa kupuk yédu tépa nébéle raapké wuné yo.’ Naate wadén kudiké sanévéknwuké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bétku kudi véknwutakne de wani taakwa Jisas déknyényba wakwedén kudiké sanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sanévéknwute de gaaba ségwi taknadan waagu kulaknyénytakne de tépa gwaamale yék. Ye de Jisasna du taaba vétik sékét maanba kayék nakurak derét wani muké wakwek. Jisasna jébaaba yaalan nak du taakwat wawo de wakwek wani muké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jisasna duwat wani kudi wakwen taakwa wan Makdalaba yaan taakwa Maria, Joana, Jemsna néwaa Maria, taakwa las wawo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","De wani kudi wakwedaka de Jisasna du wak, “Wan yénaa de yo. Wan yaamabi kudi male de bulu.” Naate watakne de deku kudi kaapuk véknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yadaka dé Pita raapme dé Jisasna gaaba ségwi taknadan taalat pétépété yék. Ye kwaatabe kwaasawule dé vék gaaba ségwi kusépdan baapmu wut male radéka. Vétakne déku gat gwaamale ye dé wani muké sanévéknwu wanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wani nyaa bét déknyényba Jisas wale yeyé yeyan du vétik Emeasnyét yédakwa yaabuba yék. Du Jerusalem kulaknyénytakne wani gayét yéte séknaa pulak yéké de yo (11 kilomita). ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bét yéte bét Jisas kiyaadénké kudi bulte déké taakwa wawedan muké wawo bét kudi bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bulte yébétka dé Jisas kapmu yae dé bét wale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yédéka dérét véte bét dérét kaapuk kutdéngbérén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yabétka dé bérét wak, “Béné samuké béné bulkére yu?” Waga wadéka bét Jisas kiyaadénké sanévéknwute némaa mawulé lékte bét ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Téte du nak déku yé Kliopas dé déku kudi kaatate dé wak, “Nak geba yaan wupmalemu du taakwa Jerusalemba bulaa rate de kutdéngék yadan muké. Méné, nak geba yaan du, méné kapmu kéni tulé Jerusalemba yadan muké kutdéngmarék yak, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wani kudi wadéka dé Jisas bérét waatak, “Samu mu de yak?” Naate wadéka bét kwatkwa téte dérét wak, “Nasaret ban Jisasnyét de wani mu yak. Dé wan Gotna yéba kudi wakwen du nak. Dé Gotna méni wupmalemu du taakwana méniba wawo téte dé kubusaaku apa jébaa yate némaa kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yadéka de Gotna gaba jébaa yakwa nyédé duna némaan du, naana némaan du wawo dérét de kwayék Romna duké, de dérét viyaapérekdoké. Kwayédaka de dérét miba viyaapata taknadaka dé kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Déknyényba naana mawuléba kéga naané wak, ‘Wani du naané Isrelna du taakwa naanat kérae naanat kutkalé yaké dé yo.’ Naate wanaka de dérét viyaapéreknék. Wani muké kudi bulte kéni muké wawo ané bulu. Déknyény de Jisasnyét viyaapérekdaka nyaa vétik yédéka bulaa nyaa kupuk dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nak muké wawo ané kudi bulu. Bulaa naané wale Jisasna jébaaba yaalan taakwa las kudi wakwedak naané kwagénu. Ganbaba de déku gaaba ségwi taknadan taalat de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ye de déku gaaba ségwit kaapuk védan. Yatakne gwaamale yae de naanat kéga wak, ‘Naané ye Gotna kudi kure giyaakwa duwat vénaka bét kéga wak, Dé débu tépa nébéle raapmék. Naate bét wak.’ ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wani taakwa yae naanat waga wadaka de naana du las yék, Jisasna gaaba ségwi taknadan taalat. Ye de wani taakwa wakwen pulak vék. Véte Jisasnyét las kaapuk védan.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wani kudi wabétka dé Jisas bérét wak, “Béné las kaapuk miték sanévéknwubénékwa. Béna mawulé miték témarék yadéka béné Gotna yéba déknyényba kudi wakwen duna kudi walkamu male béné miték véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wani du de kéga wak, ‘Taale kapéredi mu Got wadén ban Kraiské yaadu kukba dé némaan ban radu de déku yéba kevérékgé de yo.’ Naate wadan kudi béné kaapuk miték véknwubénén.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naate watakne dé Moses déké kavidén kudi, Gotna yéba kudi wakwen akwi du déké kavidan kudiké wawo dé bérét kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yaabuba yéte bét yéran gayé de saabaké yak. Ye saabe dé Jisas tépa yéké dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yadéka bét dérét wak, “Nyaa dawulidu gaan yaamale yaké dé yo. Yadu méné ané wale raké méné yo.” Naate wabétka dé wulae dé bét wale rak. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rate kadému kaké yate dé béret kérae dé Gorét wak, “Yéknwun kadému ménébu tiyaak naanéké. Wan yéknwun.” Waga watakne dé béret bule dé bétké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kwayédéka bét bari dérét kutdéngék. Kutdéngbétka dé waba kaapuk radén. Bét dérét kaapuk vébérén. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yate bét kudi bulte kéga wak, “Ané yaabuba yétéka dé Gotna nyégaba kwaakwa kudiké anat wakwedéka, dé ana mawulé yéknwun yak. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naate watakne bari raapme bét Jerusalemét tépa gwaamale yék. Ye bét vék Jisasna du taaba vétik sékét maanba kayék nakurak, déku jébaaba yaalan nak du taakwa wale jawe radaka. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vébétka de bérét wak, “Naana Némaan Ban débu tépa nébéle raapmék. Wan adél. Nébéle raapdéka Saimon débu dérét vék.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Waga wadaka bét yaabuba yéte Jisas bétké yaadénké bét kudi wakwek. Jisas bét wale rate béret bulédéka wani tulé male dérét kutdéngbérénké wawo bét derét kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bét wani kudi wekna wakwebétka dé Jisas déku kapmu yae dé deku nyédéba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tédéka de kwagénte wup yate de deku mawuléba wak, “Wan gaababanét naané vu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naate wadaka dé derét wak, “Samuké guné kwagénu? Samuké guné guna mawuléba sanévéknwu wanévéknwu? ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wuna maan taabat véte raaményét viyaadan mé vé. Véte guné kutdéngké yo. Kén wuné wuné tu. Wunat kutte guné véké yo. Véte guné kutdéngké yo. Gaababan kaapuk. Kén wuné wuné tu. Gaababan de sépékwaapa kwaami kaapuk kure tédakwa, wuné kure tékwa pulak. Kén wunat guné vu.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Naate watakne déku maan taaba dé derét wakwatnyék, de raaményét viyaadan védoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jisasna du dérét véte de sanévéknwu wanévéknwuk. Yate yéknwun mawulé yate dusék yate de deku mawuléba wak, “Yaga pulak? Kén kiyae nébéle raapmén ban Jisas, kapu kiyadé?” Waga sanévéknwudaka dé derét waatak, “Guné kéba kadému las guné taknak?” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Naate waatadéka de tuwe taknadan gukwami déké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kwayédaka dé nyégéle kadéka de vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wani gukwami katakne dé derét wak, “Déknyényba wuné guné wale rate gunat wuné kéga wakwek, ‘Déknyényba Moses wunéké kudi wakwedéka, Gotna yéba kudi wakwen du wawo wunéké de kudi wakwek. Déknyényba gwaaré waan du, deku gwaaréké naané wo Sam, de wawo de wunéké wakwek. Wakwedaka deku kudi Gotna nyégaba dé kwao. Wunéké kavidan kudi akwi adél yaké dé yo.’ Naate wawuréka bulaa wani kudi adél débu yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naate watakne dé deku mawulat kutkalé yak, de Gotna nyégaba kwaakwa kudiké miték kutdéngdoké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yate dé derét wak, “Gotna nyégaba kéni kudi dé kwao: Got wadén ban Krais apa kaagél kure kiyaaké dé yo. Kiyaadu nyaa kupuk yédu tépa nébéle raapké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Déku du déku yéba kéni kudi wakweké de yo nak du taakwat: ‘Guné yagunén kapéredi muké kélik ye kulaknyénygunu, Got yagunén kapéredi mu yatnyéputiké dé yo.’ Wani kudi Jerusalemba rakwa du taakwat batnyé wakwete de nak geba rakwa du taakwa, akwi képmaaba rakwa du taakwat wawo wani kudi wakweké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Guné wani mu akwi gunébu vék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Déknyényba wuna yaapa kéga dé wak, ‘Kukba wuna Yaamabi gunéké kwayéké wuné yo. Wan adél.’ Naate wadénké wuné wawuru wuna yaapana Yaamabi guna mawuléba wulae téké dé yo. Taale guné Jerusalemba déké raségéké guné yo. Raségégunu Gotna Yaamabi awuréba giyae gunéké apa kwayédu guné nak get yéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wani kudi watakne dé Jisas derét kwole Jerusalem kulaknyénytakne walkamu ye de Betanit yék. Ye Betani saabe dé déku taaba kusawuréte dé Gorét waatak, dé derét kutkalé yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wekna waatate derét kulaknyénydéka dé Got dérét déku gayét kure waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Waarédéka de yéknwun mawulé yate duséknét kapére yate de Jerusalemét gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ye akwi nyaa Gotna kudi buldakwa némaa gaba téte de Gotna yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Déknyényba nyét képmaa akwi mu yaalamarék yadéka Gotna nyaan dé rak. Déku yé Kudi. Dé Got wale dé rak. Dé kapmu Got pulak dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Déknyényba batnyé dé Kudi Got wale rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Radéka Got wadéka dé kapmu dé nyét képmaa akwi mu kuttaknak. Gwalmu nak kaapuk déku kapmu yaaladén. Akwi gwalmu Kudi male dé kuttaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dé kulé mawulé kwayékwa ban dé. Kulé mawulé kwayédu du taakwa kulé mawulé kérae miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kulé mawulé kwayéte dé yéknwun téwayé pulak dé ro. Du taakwana kapéredi mawulé gaankété pulak dé tu. Yadéka wani téwayé gaankétéba yaante kayénarédéka, de kapéredi mawulé yakwa du taakwa gaankétéba rate dérét yaanékiyakgé de yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Got dut nak wadéka dé yaak. Wani duna yé Jon. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dé du taakwat wani téwayéké kudi wakweké nae dé yaak. De wani téwayé pulak duké deku mawuléba waké de yo, “Wani du wan Gotna nyaan. Wan adél.” Naate wadoké dé Jon wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dé wani téwayé pulak duké dé du taakwat kudi wakweké yaak. Dé wani téwayé pulak du kaapuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Du taakwana kapéredi mawulé gaankété ye dé tu. Téwayé pulak du, yaa gaankétéba kayénarékwa pulak, deku mawuléba kayénarédu deku mawulé yéknwun yaduké dé kéni képmaat giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Taale wani du kéni képmaa dé kuttaknak. Kuttakne kéni képmaat giyaadéka de kéni képmaaba rakwa du taakwa déké kaapuk kutdéngdan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Déku gayét dé yaak. Yaadéka déku gayéna du taakwa déku kudi véknwumarék yate déké de kélik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Las de déku kudi miték véknwuk. Véknwute de wak, “Dé naana némaan ban.” Waga wadaka dé wadék de Gotna baadi de ro. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Deku néwaa yaapa deké mawulé yadaka néwaa derét kéraadak de Gotna baadi ro, kapu képmaaba rakwa du nak wadék de Gotna baadi ro? Wan kaapuk. Got kapmu wadék naané déku baadi naané ro. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kudi duna sépé ye dé naana képmaat giyaak. Giyae dé naané wale rak. Rate naanéké mawulé lékte dé adél kudi male wakwek. Wakwedéka dérét véte naané wak, “Got déku apa dé kwayék déké. Kwayétakne wadéka dé giyaak. Dé kapmu dé Gotna nyaan. Du nak dé yakwa pulak yamarék yaké dé yo.” Naate naané wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Gu yaakutaknakwa du Jon wani du yaadéka véte dé wak, “Dérét mé vé. Déknyényba kéni duké nae wuné gunat wakwek, ‘Wuna kukba yaaran du dé némaan ban. Wuné bakna du wuné taale yao. Wunat néwaa kéraamarék yaléka déknyényba wani du Got wale dé rak.’ Naate wuné déké wakwek”. Waga dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kudi déku nak yé Jisas Krais apa yate dé déké miték sanévéknwukwa du taakwa naanat kutkalé yaké dé yo. Naanéké mawulé lékte naanéké sanévéknwute némaan ban rate naanat dé kutkalé yasaaku. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Déknyényba Got wadéka dé Moses Gotna apa kudi dé du taakwat wakwek. Kukba Got wadéka Jisas Krais yae dé nak kudi naanat wakwek. Adél kudi dé wakwek Gotké. Got naanéké mawulé lékdékwaké dé kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Du nak kaapuk Gorét véte déku jébaaké kutdéngdén. Déku nyaan Jisas male dé wale re vétakne déku jébaaké dé kutdéngék. Kutdéngte giyae dé naanat yéknwun kudi wakwek déku yaapa Gotké. Wakwedéka naané Gotna jébaaké kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gu yaakutaknan du Jon tédéka de Judana némaan du de nyédé du las Livaina duwat las waga wadaka de Jerusalemba yae de Jonét waatak, “Méné kiyadé?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Waga waatadaka dé Jon wak, “Wuné Got wadén ban Krais kaapuk. Wuné du taakwat kutkalé yaran du kaapuk.” Naate wate adél kudi dé wakwek. Kudi kaapuk paakudén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yadéka de dérét tépa waatak, “Méné yani du? Méné Ilaija kiyae méné tépa nébéle raapmék, kapu yaga pulak?” Waga waatadaka dé Jon wak, “Kaapuk. Wuné Ilaija kaapuk.” Naate wadéka de tépa wak, “Naané Gotna kudi wakweran kulé duké naané raségu. Raségénakwa du wani méné?” Naate waatadaka dé Jon wak, “Kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Naate wadéka de dérét tépa waatak, “Méné kiyadé? Du las de naanat wadaka naané yaak. Naané gwaamale ye derét yaga wakweké naané yo? Ména jébaaké yaga méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Naate waatadaka dé Jon wak, “Wuné téte kudi wakwekwa du wuné. Wuné du ramarék taaléba téte wuné wo, ‘Némaan Ban yaaran yaabu kutké guné yo.’ Wuné Aisaiana kudi véknwute wuné wani kudi wakweyo. Déknyényba wani kudi Gotna nyégaba kavidéka bulaa wuné yae wuné wani kudi wakweyo.” Naate dé aja kudi wakwek, deku mawulé yéknwun yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Déknyényba Parisina du derét wadaka de yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yae de Jonna kudi véknwutakne de dérét waatak, “Du taakwa deku kapéredi mawulé kulaknyénydaka méné Gotna yéba derét gu yaakutakno. Samuké méné waga yo? Méné Ilaija kaapuk. Méné Got wadén ban Krais kaapuk. Méné raségénakwa du kaapuk. Méné bakna du, samuké méné Gotna yéba derét gu yaakutakno?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Waatadaka dé Jon wak, “Wuné Gotna yéba derét wuné gu yaakutakno. Wan makwal jébaa male. Némaan ban nak guné wale dé ro. Guné dérét kaapuk kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dé wuna kukba yaaké dé yo. Yae dé apa jébaa yaké dé yo. Dé némaan ban dé ro. Wuné bakna du wuné ro. Yaga pulak déku jébaa yaké wuné yo, wuné bakna du rawurékwa bege?” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betaniba rate dé Jon wani kudi bulék. Wani gayé Jodan kaabélé nak saknwuba dé tu. Waba rate dé Gotna yéba du taakwat gu yaakutaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nak nyaa Jon téte dé vék Jisas dé ran taaléba yaadéka. Yaadéka Jon dérét véte dé naanat wak, “Guné akwi kéni dut mé vé. Dé Gotna sipsip nyaan. Déknyényba yadan kapéredi mu kutnébulké de sipsip nyaanét viyae Gotké tuwe kwayék. Sipsip nyaanét viyaadan pulak dérét viyaaké de yo. Viyaado dé kiyaaké dé yo, kéni képmaaba rakwa du taakwana kapéredi mawulé kutnébulké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nalé wani duké nae wuné gunat wakwek. Kéga wuné wak, ‘Wuna kukba du nak yaaké dé yo. Dé wuna némaan ban. Wunat néwaa kéraamarék yaléka dé dé rak.’ Naate wuné wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Déknyényba dérét kaapuk kutdéngwurén. Bulaa male dérét wuné kutdéngék. Déké gunat kudi wakwete wuné Gotna yéba gunat gu yaakutaknak. Guné Isrel kéni duké kutdénggunuké wuné waga yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Naate watakne dé naanat wak, “Got wadéka yae wuné déku yéba gunat gu yaakutaknak. Déknyényba wunat kéga dé Got wak, ‘Wuna Yaamabi giyae du nak wale tédu véké méné yo. Wani du wadu wuna Yaamabi du taakwana mawuléba wulaaké dé yo.’ Wakwedén pulak dé déku Yaamabi nyaamiyo pulak giyae kéni du wale tédéka wuné vék. Taale wuné kéni dut las kaapuk kutdéngwurén. Yawuréka Gotna Yaamabi déké giyae tédéka wuné déké kutdéngék. Kéni du wan Gotna nyaan. Wuné kutdéngte wuné gunat kudi wakweyo.” Naate dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nak nyaa Jon tépa tédéka wuné kéni nyéga kavin du Jon déku du nak wawo ané dé wale ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tétéka dé Jon vék Jisas yédéka. Véte dé wak, “Mé vé. Wan Gotna sipsip nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Waga wadéka ané Jisasna kukba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","39","Yétéka Jisas walaakwe dé vék déku kukba yaatéka. Véte dé anat wak, “Samuké béné sékalu?” Naate waatadéka ané wak, “Rabai, samu gaba méné ro?” Naate watéka dé wak, “Mé yae béné véké yo.” Naate wadéka ye ané vék radékwa ga kwaadéka. Vétakne wani nyaa ané dé wale rak. Kaapuk yétén. Garabu yan bege. Wani kudi Rabai naana kudiba kéga de wo, “Gotna kudiké yakwatnyékwa ban.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ané Jonna kudi véknwutakne ané Jisasna kukba yék. Du nak déku yé Andru wan Saimonna wayékna. Saimonna nak yé Pita. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru Jisasnyét kulaknyénytakne bari ye dé Saimonét véte dé wak, “Ané Mesaiat anébu vék.” Naate dé wak. Wani yé Mesaia naana kudiba kéga: Got wadén ban Krais. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Watakne dé Andru Saimonét kwole yék Jisaské. Kwole yédéka Jisas Saimonét véte dé wak, “Méné Jonna nyaan. Méné Saimon. Kukba ménat kéga waaké naané yo, Sipas.” Naate dé Jisas wak. Wani yé, Sipas, nak gena kudiba kéga, Pita. Naana kudiba kéga, Matu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Nak nyaa dé Jisas nak képmaat yéké dé sanévéknwuk. Wani képmaana yé Galili. Sanévéknwute yéte dé Pilipmét vék. Pilip Betsaidaba dé yaak. Betsaida wan Pilip, Andru, Pita deku néwaage. Jisas Pilipmét véte dé wak, “Méné wuné wale mé yaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naate wadéka dé Pilip Jisasna jébaa yate ye dé Natanielké sékalék. Sékale véte dé dérét wak, “Déknyényba naana képmawaara Moses Gotna yéba kudi wakwen du wawo de kulé duké Gotna nyégaba kavik. Wani dut naanébu vék. Wan Nasaret ban Jisas. Dé Josepna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naate wadéka dé Nataniel dérét wak, “Nasaret wan kapéredi gayé. Yaga pulak yéknwun du Nasaretba yaalaké dé yo?” Naate wadéka dé Pilip wak, “Méné yae méné véké yo.” Naate wadéka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel yaadéka Jisas véte dé déké kéga wak, “Mé vé. Naané Isrelna du nak déwa yaakwa. Yéknwun du dé. Kudi las kaapuk yénaa yadékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naate wadéka dé Nataniel wak, “Yaga pulak ye méné wunat kutdéngék?” Naate waatadéka dé Jisas dérét wakwek, “Pilip ménat waamarék yadéka méné wani mi bapéba séknaaba raménéka wuné véte ménat wuné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Waga wadéka dé Nataniel wak, “Némaan du, méné Gotna nyaan. Méné naané Isrelna némaan ban.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Naate wadéka dé wak, “Ménat wani mi bapéba raménéka véwurénké wuné wak. Wawuréka bulaa wunéké méné miték sanévéknwu. Kukba véménéran mu yae bulaa véménékwa mat talaknaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Naate watakne dé naanat wak, “Kukba guné véké guné yo Gotna gayé tédu déku kudi kure giyaakwa du wuné Akwi Du Taakwana Nyaanké giyaate waarédo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Nyaa vétik yédéka nak nyaa dé du nak taakwa yak Kenaba. Wani gayé Galiliba dé tu. De waadaka Jisasna néwaa ye lé taakwa yakwa duna gaba raléka Jisas déku du wale wani mu véké nae naané yék. Ye ranaka kukba dé wain gu kaapuk yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yadéka lé Jisasna néwaa dérét wak, “De wain gu kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Naate waléka dé Jisas wak, “Nyéné, wuna jébaaké wamarék yaké nyéné yo. Jébaa yate kiyaawuréran tulé kaapuk wekna yaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naate wadéka lé Jisasna néwaa jébaa yakwa duwat wak, “Gunat kudi wadu guné déku kudi véknwute guné wadékwa pulak yaké guné yo.” Naate lé derét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naané Juda naana apa kudi véknwute maan taaba miték naané yakutnyu. Wani gaba rakwa du waga maan taaba yakutnyédoké de matut yadan awu nak taaba sékét nak taaba kayék nakurak waga de ték. Wani awu apakélé (30 galen pulak). ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas dé jébaa yakwa duwat wak, “Wani awuba mé kulé gu tuwe wuknasadagunu.” Naate wadéka de gu tuwe wuknasékéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wuknasékérékdaka dé derét wak, “Las mé tuwe kure ye guné yaa sérakgwa bapaduké kwayéké yo.” Waga wadéka de tuwe kure yék. Kure yédaka dé yaa sérakgwa bapadu dé wani gu kaknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Wani kulé gu wain gu dé yak. Kaknwute wani wain guké kutdéngmarék yadéka de jébaa yakwa du de kutdéngék wani guké. Kutdéngmarék yate dé yaa sérakgwa bapadu dé taakwa yan dut waadéka yaadéka dé dérét wak, “Akwi du yéknwun wain gu de taale kwayu. Kwayédaka du wupmalemu wain gu kadaka kukba de kapére wain gu kwayu. Méné yéknwun wain gu takne méné bulaa kure yaaménéka naané miték ko. Wan yéknwun.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wani nyaa dé Jisas batnyé déknyényba vémarék yadan apa jébaa yak. Kenaba dé wani apa jébaa yak. Got déké apa kwayédéka wani apa jébaa yadéka naané vék. Véte déké kutdéngte naané déku du déké mitékne sanévéknwute naané wak, “Wani du wan Gotna nyaan. Wan adél.” Naate naané wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wani kadému katakne dé Jisas, déku néwaa, déku wayéknaje, naané déku du, waga naané yék Kapaneamét. Ye nyaa las naané wani gayéba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Apakélé yaa nak sérakgé yadaka naané Jisas wale Jerusalemét yék. Naané Juda wani yaaké naané wo Pasova. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ye Gotna kudi buldakwa némaa gat wulae dé Jisas vék du las jébaa yadaka. De yéwaa kéraate de sipsip bulmakawu api kwayék, de nyédé du viyae tuwe Gotké kwayédoké. Du las de nak gena yéwaa kéraate de wani gayéna yéwaa deké kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","De waga yadaka dé Jisas vék. Vétakne kélik yate dé makwal baagwi las kérae dé apa baagwi yak. Yatakne kure téte dé waba ran du, sipsip, bulmakawu, akwi dé kélésalak. Kélésalate dé yéwaa kéraadan jaabé takugérutnyédéka wani yéwaa bakna dé akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akérédéka dé api kure tén duwat wak, “Wani api mé kure yé. Guné wuna yaapana ga gwalmu kéraadakwa ga pulak yamarék yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas waga yadéka naané déku du Gotna nyégaba kwaakwa kéni kudiké naané sanévéknwuk: Got, wuné ména gaké wuné mawulat kapére yo. Yawuréka wuna mawulé yaa pulak dé yaanu. Yaandéka ména ga miték kwaaduké apa jébaa wuné yo. Wani kudiké naané sanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisas waga yadéka de némaan du wani mat véte de wak, “Got ménéké apa kwayéte wadéka méné waga yak, kapu yaga pulak? Samu nak pulak apa jébaa yaménu véte ména apaké kutdéngké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naate wadaka dé Jisas derét wak, “Guné kéni yéknwun ga yaalébaangunu nyaa kupuk yédu wuné tépa kaaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Naate wadéka de wak, “Wupmalemu (46) kwaaré de Gotna kudi buldakwa némaa ga kaak. Bulaa nyaa kupuk méné tépa kaaké yapatiké méné yo.” Naate de némaan du wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas waga wate déku sépéké dé aja kudi wakwek. Gotna kudi buldakwa némaa gaké kaapuk wakwedén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yatakne kukba kiyaadéka nyaa kupuk yédéka Got wadéka dé tépa nébéle raapmék. Raapdéka naané déku du wani tulé wadén kudiké tépa sanévéknwuk. Yate naané Gotna nyégaba déknyényba kavidan kudi Jisas wakwen kudiké wawo sanévéknwute naané wak, “Wan adél kudi.” Waga naané wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wani yaa sérakdan tulé Jisas Jerusalemba dé rak. Rate déknyényba vémarék yadan apa jébaa yadéka de wupmalemu du taakwa de vék. Véte de wak, “Wan Gotna nyaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Naate wadaka dé Jisas deku mawulé kutdéngék. Deku kudi bakna kudi. Déké kaapuk miték sanévéknwudan. Waga kutdéngte dé de wale kaapuk tédén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dé akwi du taakwana mawulé dé kutdéngék. Dut kaapuk waatadén deku mawuléké. Déku kapmu dé deku mawulé kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Judana némaan du dé nak rak. Déku yé Nikodimas. Wani du wan Parisina du. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gaan nak wani du Jisaské ye dé dérét wak, “Némaan du, Got ménat wadéka méné yaak, déku kudiké naanat yakwatnyéké. Naané naanébu kutdéngék. Bakna du méné yakwa pulak déknyényba vémarék yanan apa jébaa yamarék yaké naané yo. Got méné wale radéka méné wani apa jébaa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dé waga wadéka dé Jisas dérét wak, “Wakwewurékwa kudi miték méné véknwuké yo. Du taakwa kulé tépa yamarék yadaran dé Got némaan ban rate deké miték vémarék yaké dé yo. Yadu de Gotna du taakwa ramarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naate wadéka dé kutdéngmarék yate dé waatak, “Du taakwa gwalepa yate yaga pulak ye kulé tépa yaké de yo? Kapu sal de makwali ye néwaana biyaaba wulaado néwaa tépa kéraaké de yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Dé waga wadéka dé wak, “Néwaa kéraadaka de nyaan bakna du taakwa de yaalo. Kulé mawulé kaapuk kéraadakwa. Gotna Yaamabi dé kapmu wadu de kulé mawulé kérae kulé du taakwa raké de yo. De Gotna yéba gu yaakudo Gotna Yaamabi deku mawuléba wulae tédéran de kulé mawulé kéraaké de yo. Kérae kulé du taakwa rado Got némaan ban rate deké miték védu, de Gotna du taakwa raké de yo. Adél wuné ménat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naate watakne dé tépa wak, “Ménat wunébu wakwek, guné kulé du taakwa ragunuké. Wani kudi véknwute kwagénmarék yaké méné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wimut kutte déku kapmu dé yeyé yeyo. Yeyé yeyate waadéka méné véknwu. Véknwute méné kaapuk kutdéngménén. Yaba dé yao? Yaba yéké dé yo? Wimutké kutdéngmarék yaménékwa pulak, méné Gotna Yaamabi yakwa jébaaké kutdéngmarék yaké méné yo. Gotna Yaamabi deku mawuléba wulaadu de kulé du taakwa radaranké kutdéngmarék yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naate wadéka dé wak, “Wani mu yaga pulak yaaké dé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nikodimas waga wadéka dé wak, “Méné Judana némaan du méné ro. Samuké méné wani muké kutdéngmarék yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kéni kudi mé véknwu. Wuné kutdéngwurén muké wuné ménat wakweyo. Véwurén muké wawo wuné kudi wakweyo. Wakwewuréka guné wuna kudi véknwumuké kélik guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Got kéni képmaaba jébaa yadéka guné végunéka wuné wani jébaaké kudi wakweyo. Wakwewuréka guné wuna kudi kaapuk véknwugunékwa. Got déku gayéba yakwa jébaaké wakwewuréran wani kudi wawo véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Du nak Gotna gayét kaapuk waarédén. Waarémarék ye Got yakwa jébaa kaapuk védén. Wuné déku gayéba rate wuné kapmu wuné vék déku jébaa. Wuné déku gayé kulaknyénytakne wuné kéni képmaat giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Déknyényba naana képmawaara du ramarék taaléba yeyé yeyate dé Moses bras ainét yadan kaabe nak miba kusawurék, de véte yéknwun yadoké. Yadén pulak, de wuné Akwi Du Taakwana Nyaan wunat waga yaké de yo. Wunat miba kusawuréké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kusawurédo de wunat véte wunéké miték sanévéknwute wuna kudiké ‘Adél’ naadaran de kulé mawulé kérae Got wale apuba apuba miték rasaakuké de yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Got kéni képmaaba rakwa du taakwaké mawulat kapére yate déku nyaanét wadéka dé giyaak. Got wupmalemu baadi kaapuk. Nakurak male. Got waga dé wak, déku nyaanké miték sanévéknwukwa du taakwa kulé mawulé kérae dé wale apuba apuba miték rasaakudoké. Yalakmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Got déku nyaanét wadéka dé giyaak, du taakwa yadan kapéredi mu kutnébulké. Yadan kapéredi mu derét yakataduké, Got dérét kaapuk wadén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Déku nyaanké miték sanévéknwukwa du taakwat Got waké dé yo, “Guné yéknwun du taakwa. Miték rasaakuké guné yo.” Watakne dé déku nyaanké miték sanévéknwumarék yakwa du taakwat waké dé yo, “Guné kapéredi mu yakwa du taakwa. Yagunén kapéredi mu wuné yakato, wuna nyaanké miték sanévéknwumarék yagunén bege.” Naate Got waké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jisas yéknwun téwayé yaankwa pulak rate kéni képmaat débu yaak. Yaadéka de du taakwa kapéredi mu yate de gaankétéké mawulé yak. Wani téwayéké de kélik yak. Got derét waatiké dé yo, wani téwayéké kélik yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kapéredi mu yakwa du taakwa wani téwayéké kélik yate téwayé yaankwa taalat yémarék yaké de yo. Yaa yaante gaankétéba kayénarédu de nak du yadakwa kapéredi mat miték vémuké kélik yate, de téwayé yaankwa taalat yémarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Adél kudi véknwukwa du taakwa wani du taakwa pulak kaapuk yadakwa. Got deké apa kwayédéka de yéknwun jébaa yo. Yate de téwayé yaankwa taalat yédaka de nak du yadakwa yéknwun jébaa miték vu. Véte Got deké apa kwayédékwaké de kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kukba Jisas déku du wale naané Judiat yék. Ye wani képmaaba rate naané Gotna yéba derét gu yaakutaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Gu yaakutaknakwa du Jon Inonba dé rak. Wani gayé Selim wale dé tu. Wani taaléba wupmalemu gu tédéka wupmalemu du taakwa yaadaka dé Gotna yéba derét gu yaakutaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wani tulé Yerot némaan ban Jonét kaapuk raamény gaba kusoladén. Dé wekna kaapaba rate dé jébaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jonna du de du nak wale waaruk. Juda deku apa kudi véknwute de gu yaakudakwaké de waaruk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Waarutakne Jonna du déké ye de dérét wak, “Némaan du, du nak méné wale Jodan kaabélé nak saknwuba dé ték. Déknyényba déku jébaaké méné naanat wakwek. Wani du yae téte Gotna yéba du taakwat gu yaakutaknadéka de akwi du taakwa naanat kulaknyénytakne de déké yu. De akwi dékéba male yémuké naané kélik yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naate wadaka dé Jon derét wak, “Got naanat wadéran naané déku kudi véknwute déku jébaa yaké naané yo. Got naanat wamarék yadéran déku jébaa yamarék yaké naané yo. Wuné kéni jébaa kulaknyénymarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kéni jébaa yate wuné gunat wakwewuréka gunébu véknwuk. Kéga wuné wak, ‘Wuné Got wadén ban Krais kaapuk. Wuné akwi du taakwat kutkalé yakwa ban kaapuk. Got wadéka wuné wani banna yaabu kutké nae wuné taale yaak. Dé wuna kukba yaaké dé yo.’ Naate wate wuné wuna jébaa yak, akwi du taakwa wani banna kudi véknwudoké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Du nak taakwa kéraaké mawulé yadu déku du téte védu wani du taakwa kéraadu dé wale dusék yaké dé yo. Wuné wan taakwa kéraakwa duna du pulak. Wupmalemu du taakwa Jisaské yéte déku kudi véknwudaka wuné véte yéknwun mawulé yate dusék wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dé némaan du raké dé yo. Wuné kaapuk. Wuné bakna du raké wuné yo. Wupmalemu du taakwa déku yéba kevérékgé de yo. Wuna yéba kevérékmarék yaké de yo. Waga wuné mawulé yo.” Naate dé Jon wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Awuréba yae képmaat giyaan ban dé akwi du taakwana némaan ban. Kéni képmaaba rakwa du képmaana muké male de kutdéngék. Awuréba giyaan ban akwi muké kutdéngte derét dé talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Gotna jébaaké kutdéngte dé derét wakweyo. Wakwedéka de déku kudi véknwumuké kélik de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Got déku Yaamabi wani banké débu kwayék. Kwayédék Gotna Yaamabi déku mawuléba wulae tésaakute dé wani ban Jisas wale jébaa yo. Yadéka dé wani ban Gotna kudi male dé wakweyo. Wakwedéka du taakwa déku kudi véknwute de wo, “Gotna kudi dé wakweyo. Gotna kudi wan adél kudi. Wan adél.” Naate de wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Déku yaapa Got déké dé mawulat kapére yo. Mawulat kapére yate dérét débu wak, dé némaan ban rate akwi du taakwa, gwalmuké wawo miték véduké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gotna nyaanké miték sanévéknwukwa du taakwa kulé mawulé kérae apuba apuba miték rasaakuké de yo. Déku kudi véknwumarék yakwa du taakwa kulé mawulé kéraamarék yaké de yo. Got wani du taakwat apuba apuba rékaréka yadu de miték rasaakumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","4","Wani tulé du de las wak, “Wupmalemu du de Jisasna kudi miték véknwu. Véknwudaka dé Jisas Gotna yéba derét gu yaakutakno. Waga yadéka déku jébaa gu yaakutaknakwa du Jonna jébaat dé talaknak.” Naate wate kaapuk kutdéngdan. Jisasna du male de Gotna yéba duwat gu yaakutaknak. Jisas kaapuk derét gu yaakutaknadén. Jisasna jébaaké waga wadaka de Parisina du wani kudi véknwute buldaka dé Jisas véknwuk. Véknwutakne dé Jisas déku du wale waga naané Judia kulaknyénytakne Galilit tépa yéké nae naané yédakwa yaabuba ye naané Sameriat yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yéte naané Sameriana gayé nak saabak. Wani gayéna yé Saika. Apakélé nébu nak dé tu, Saika tékwaba. Déknyényba naana képmawaara Jekop dé déku nyaan Josepké wani képmaa kwayék. Saika wani képmaa tékwaba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wani taaléba gu tuwe kadakwa waagu dé nak tu. Déknyényba Jekop dé vaak wani waagu. Jisas séknaaba yae wani waagu tékwa saabadéka yaap yadéka dé wani waagu tékwaba rak. Nyaa nawuréké yadéka dé waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisas waba radéka déku du gayét naané yék, kadému las kéraaké. Yénaka radéka lé Sameriana taakwa nak gu tuké yaak. Yaaléka dé Jisas lérét wak, “Gu las mé kure yaa. Kaké wunék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naate wadéka lé Sameriana taakwa dérét wak, “Méné Judana du. Wuné Sameriana taakwa. Yaga pulak gu kwayéwuru kaké méné yaawiyu?” Naate lé wak, Juda Sameria wale yeyé yeyamarék yadakwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Waléka dé Jisas wak, “Bulaa nyénat wuné guké yaawik. Nyéné Got kwayédékwa yéknwun gwalmuké kutdéngte wunéké wawo kutdéngnyénu mukatik, nyéné wunat nak pulak guké wanyénu. Nyéné wani gu kanyénéran nyéné miték rasaakuké nyéné yo.” Naate wate du taakwa kulé mawulé kérae miték rasaakudaranké dé aja kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dé waga wakwedéka lé déku kudiké kutdéngmarék yate lé wak, “Némaan du, méné gu tu mu kaapuk. Kéni waagu gu adaba dé tu. Waménén gu yaba tuké méné yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naana képmawaara Jekop dé kéni gu tékwa waagu tiyaak naanéké. Déku nyaangu, déku sipsip bulmakawu, dé wawo, kéni guba de kak. Ména jébaa déku jébaat talaknaduké méné waga wo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Naate waléka dé Jisas wak, “Akwi du taakwa wani guba kadaran tépa gutak yaké dé yo derét. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","De kwayéwuréran gu nyégéldaran dé deku mawuléba yéknwun yadu de kulé mawulé kérae apuba apuba miték rasaakuké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naate wadéka lé dérét wak, “Némaan du, bulaa wunéké wani gu tiyaaké méné yo. Tiyaaménu kukba wunat tépa gutak yamarék yaké dé yo. Tépa yae kéni waaguba tumarék yaké wuné yo.” Naate wate lé déku aja kudi kaapuk kutdénglén. Lé guké lé wak. Dé kulé mawuléké dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lé waga waléka dé wak, “Ye nyéné nyéna dut kwole béné yaaké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naate wadéka lé wak, “Wuné du kaapuk.” Naate waléka dé wak, “Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Déknyényba du naktaba wale nyéné rak. Bulaa ranyénékwa du wan nyéna du kaapuk. Nyéna kudi wan adél kudi.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naate wadéka lé wak, “Némaan du, wunéké méné kutdéngék. Méné Gotna yéba kudi wakwekwa du méné. Bulaa waga wuné kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wuna képmawaara kéni nébuba waare de Gotna yéba kevéréknék. Guné Juda guné wo, ‘Gotna yéba kevéréknakwa taalé Jerusalemba dé tu.’ Naate wagunékwaké yaga pulak yaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lé waga waléka dé lérét wak, “Nyéné wuna kudi mé miték véknwu. Nak nyaa yaadu guné akwi taaléba naana yaapa Gotna yéba kevérékgé guné yo. Guné kéni nébuba male Gotna yéba kevérékmarék yaké guné yo. Jerusalemba male Gotna yéba kevérékmarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Guné Sameria Gotké miték kutdéngmarék yate, guné déku yéba kevéréknu. Naané Juda Gotké kutdéngte naané déku yéba kevéréknu. Wuné du taakwana kapéredi mawulé kutnébulran ban wan Judana du wuné. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gotna kudi miték véknwukwa du taakwa de naana yaapa Gorét adél kudi wakwete deku mawuléba déku yéba kevérékgé de yo. Wani du taakwa déku yéba kevérékdoké dé mawulé yo. Déku yéba waga kevérékdaran tulé kéni dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Got wuraanyan pulak dé ro. Dé sépé kaapuk. Du taakwa dérét kaapuk védakwa. Gotna kudi miték véknwukwa du taakwa adél kudi wakwete deku mawuléba déku yéba kevérékdaran wan yéknwun.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wadéka lé wak, “Got wadén ban Mesaia déku nak yé Krais yaaké dé yo, naanat kutkalé yaké. Waga wuné kutdéngék. Dé yae akwi kudi naanat wakweké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naate waléka dé Jisas lérét wak, “Kéni wuné nyéné wale bulu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas waga wadéka naané déku du kadému kérae kure tépa gwaamale yaak. Yae taakwa wale buldéka véte naané kwagénék. Yate naané kaapuk wanan, “Samu kéraaké nyéné mawulé yo? Samuké méné lé wale kudi bulu?” Waga kaapuk wanan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Yanaka lé wani taakwa gu tulékwa mu kulaknyénytakne lé gayét gwaamale yék. Ye lé du taakwat las wak, “Yae guné dut nak véké yo. Déknyényba wunat kaapuk védén. Yate déknyényba yawurén akwi muké dé wunat wakwek. Dé Got wadén ban Krais, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naate waléka de gayé kulaknyénytakne de Jisaské yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yaabuba yaadaka naané Jisasna du dérét wak, “Némaan du, kadému mé ka.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naate wanaka dé wak, “Wuna kadému dé ro. Kutdéngmarék yagunén kadému.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Naate wadéka naané déku du naana kapmu bulte naané wak, “Du dé nak déké kadému kwayék, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Naané waga wanaka dé naanat wak, “Wuna kadému kéga. Wunat wadéka yaawurén banna kudi véknwuké wuné yo. Véknwute tiyaadén jébaa yate yabutiké wuné yo. Wan wuna kadému pulak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guné kadému yaanane kéga guné wo, ‘Kadému kéraanaran baapmu wan véti wan véti dé tu.’ Wagunéka wuné gunat wo: Bulaa kéraamale yaké guné yo. Mé vé. Wupmalemu Sameriana du taakwa dewa yaakwa. Bulaa deku mawulé yéknwun dé tu, kéraagunékwa kadému yéknwun ye tékwa pulak. Bulaa wunéké sanévéknwute wuna kudiké ‘Adél’ naaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","38","“Kadému kéraakwa du nak duké jébaa yate de déku kadému kérae jawute de yéwaa nyégélu. Guné Gotké jébaa yate kadému kéraakwa du pulak guné ro. Guné wani jébaa yate wuna kudi wakwegunu, de wupmalemu du taakwa jawe wunéké miték sanévéknwute kulé mawulé kérae, miték rasaakuké de yo apuba apuba. Rado Got guna yéknwun jébaa kaataké dé yo. Déknyényba kéni kudi du dé nak wak, ‘Du nak dé kadému yaananu. Yaanandéka nak du dé wani kadému kérao.’ Wadéka bulaa wani kudi adél dé yak. Du las déknyényba du taakwat Gotna kudi wakwete kadému yaananén du pulak de tu. Nak du kukba yae wuna kudi wani du taakwat wakweké de yo, de wunéké miték sanévéknwudoké. Wani kudi wakweran du kadému kéraakwa du pulak de tu. Déknyényba wakwen du kukba wakweran du de akwi yéknwun mawulé yate dusék yaké de yo. Gunat wuné wak, guné wuna kudi wakwegunu wupmalemu du taakwa wunéké miték sanévéknwudoké. Déknyényba nak du de Gotna kudi derét wakwek. Kukba guné yae deku mawulat kutkalé yagunu de wunéké miték sanévéknwuké de yo. Gotna kudi déknyényba wakwen du guné wuna kudi wakwekwa du wale akwi guné Gotna jébaa yo.” Naate dé Jisas naanat kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Taknaba Sameriana taakwa lé wani gayéba rakwa du taakwat wak, “Wani du déknyényba yawurén akwi muké dé wunat wakwek.” Naate waléka de wupmalemu Sameriana du taakwa de Jisaské miték sanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sanévéknwute Jisaské yae de dérét waatak, dé de wale raduké. Waga waatadaka dé de wale nyaa vétik dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Rate de wale kudi buldéka de wupmalemu du taakwa las wawo déku kudi véknwute de déké miték sanévéknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sanévéknwute de wani taakwat wak, “Taale naané nyéna kudi véknwuk. Véknwutakne naané Jisaské miték sanévéknwuk. Sanévéknwute kukba naané Jisasna kudi véknwuk. Déku kudi véknwutakne bulaa naané kutdéngék. Dé kéni képmaaba rakwa du taakwat Setenna taababa kéraaran ban. Wan adél.” Naate de Sameriana du taakwa wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Nak nyaa Jisas dé wak, “Gotna yéba kudi wakwekwa duké déku gayéna du taakwa de wo, ‘Dé naané pulak du. Dé némaan du kaapuk. Wan bakna du.’ Waga wadaka de nak gena du taakwa déké de wo, ‘Wan némaan du dé.’ Waga de wo.” Naate Jisas dé wak. Saikaba nyaa vétik re wani gayé kulaknyénytakne naané Jisasna képmaa Galilit yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Déknyényba yis yamarék yadakwa béret kanakwa tulé de Galilina du taakwa las Jerusalemét yék. Ye de vék Jisas déknyényba vémarék yadan apa jébaa yadéka. Vétakne deku képmaat gwaamale ye re de vék Jisas deku gayét yaadéka. Véte de déké mawulé yate dusék takwasék yak. Yate de déku kudi véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Naané Galiliba yeyé yeyate naané Kena saabak. Déknyényba Jisas wani gayéba rate wadéka dé kulé gu wain gu yak. Jisas Judia kulaknyénytakne Galilit ye Kena saabe radéka dé némaan du nak véknwuk. Wani némaan duna nyaan kiyakiya yate dé Kapaneamba kwaak. Kwaadéka dé némaan du Jisaské yaak. Yae dérét dé wak, “Wuna nyaan kiyaamale yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Méné wuné wale yae wuna nyaanét kutkalé yaménu, dé yéknwun yaké yo.” Naate wadéka dé Jisas wak, “Wuné déknyényba vémarék yagunén apa jébaa las wawo yawuréran tulé male, guné Got wunéké apa tiyaadénké miték sanévéknwuké guné yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naate wadéka dé némaan du wak, “Némaan du, bari méné yaaké yo. Yaamarék yaménéran wuna nyaan kiyaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Naate wadéka dé Jisas wak, “Méné yéké méné yo. Ména nyaan yéknwun yaké dé yo.” Naate wadéka dé Jisasna kudi miték véknwutakne dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Déku jébaa yakwa du yae dérét yaabuba véte de wak, “Ména nyaan débu yéknwun yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naate wadaka dé derét waatak, “Yani tulé dé yéknwun yak?” Waatadéka de wak, “Nalé nyaa nawurédéka dé kiyakiya kaapuk yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Waga wadaka dé yaapa kutdéngék. Nalé Jisas dé wale kudi bulén tulé dé déku nyaan yéknwun dé yak. Waga kutdéngte dé déku kém wale akwi de Jisaské miték sanévéknwute déku kudiké de “Adél” naak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas déknyényba Judia kulaknyénytakne Galilit ye wadéka dé wani nyaan yéknwun yak. Jisas déknyényba vémarék yadan apa jébaa yatakne wani tulé dé apa jébaa nak wawo yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kukba apakélé yaa sérakdaran nyaa yaaké yadéka dé Jisas Jerusalemét waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Déknyényba matut raatmu gitaknadaka dé Jerusalem nyédéba ték. Wani raatmuba apakélé gwéspété dé las ték. Nakurak gwéspétéba de sipsip wulaak. Wani gwéspété ténba dé makwal kwawu nak ték. Yibruna kudiba wani kwawuké kéga de wo, Betesda. Wani kwawu maaléba surél pulak ga naktaba dé kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wupmalemu du taakwa de wani gaba rak. Méni kiyaan du taakwa, maan kapére yan du taakwa, apa yamarék bakna kwaakwa du taakwa, waga de rak. Wani gu ségéndu véké nae de rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Déknyényba nak apu nak apu Gotna kudi kure giyaakwa du nak giyae dé wani guba dawulidéka dé gu ségénék. Gu ségéndéka véte dé guba taale dawulin ban dé yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Du nak wupmalemu (38) kwaaré déku sépé kapére dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dé wani gaba kwaadéka Jisas dérét véte dé kutdéngék, wupmalemu kwaaré waba kwaadénké. Waga kutdéngte dé Jisas dérét waatak, “Méné yéknwun yaké méné mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Naate waatadéka dé sépékwaapa kapére yan du wak, “Némaan du, yaga pulak yaké wuné yo? Gu ségéndu wunat kérae kwawuba kusadaran du kaapuk radékwa. Wuné kapmu dawuliké yawuréka nak du male taale dawulite dé wunat talaknak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Naate wadéka dé Jisas wak, “Méné mé raapme kwaaménén ara kérae kure méné yéké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Waga wadéka dé wani du tépa yéknwun yak. Yadéka dé déku ara kérae kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wani nyaa wan naané Judana yaap ra nyaa. Yadéka de némaan du yéknwun yan dut wak, “Naana apa kudi véknwute naanébu wak, ‘Yaap ra nyaa du deku gwalmu kure yémarék yaké de yo.’ Waga naanébu wak. Bulaa ména ara kure yémarék yaké méné yo, yaap ra nyaa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naate wadaka dé derét wak, “Du nak wadéka yéknwun yawuréka dé wunat wak, ‘Ména ara kérae kure méné yéké yo.’ Waga wadéka wuné kérae kure yu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naate wadéka de waatak, “Ména ara kérae kure yéménuké kiyadé wak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naate wadaka kaapuk kutdéngdén. Wani taaléba wupmalemu du taakwa tédaka Jisas débu yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kukba dé Jisas dérét Gotna kudi buldakwa némaa gaba vék. Véte dé wak, “Mé véknwu. Bulaa ménébu yéknwun yak. Kapéredi mu tépa yamarék yaké méné yo. Wuna kudi véknwumarék yaménéran kapéredi mu las wawo ménéké yaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Waga wadéka wani du ye dé némaan duwat wakwek, “Wunat wadéka yéknwun yawurén du wan Jisas.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dé waga wadéka véknwute de batnyé Jisasnyét yaalébaanké sanévéknwuk, wani mu yaap ra nyaaba yadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Waga yadaka dé Jisas derét wak, “Wuna yaapa akwi nyaa dé jébaa yo. Yadéka wuné wawo wuné jébaa yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Waga wate dé déku yaapa Gotké wakwek. Waga wakwete dé Got pulak radékwaké dé wakwek. Wakwedéka véknwutakne de némaan du dérét viyaapérekgé mawulé yak, wani dut yaap ra nyaa kutnébultakne Got pulak radékwaké wadén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","De waga yadaka dé Jisas derét wak, “Mé véknwu. Wuna yaapa jébaa yadéka, wuné déku nyaan véte wani jébaa wuné yo. Wuné wuna mawuléba sanévéknwute jébaa nak wuné kapmu yamarék yaké wuné yo. Wuna yaapa yakwa akwi jébaa wuné wawo yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wuna yaapa wunéké mawulat kapére yate dé déku jébaa wunat wakwatnyu. Kukba wunat wakwatnyédéran jébaa bulaa yawurékwa jébaat talaknaké dé yo. Wuné wani kulé jébaa yawuru guné véte kwagénte sanévéknwu wanévéknwuké guné yo wani jébaaké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wuna yaapa kiyaan du taakwat wadéka de nébéle raapme miték rasaaku. Yadékwa pulak wuné mawulé yawurékwa du taakwat wawuru de miték rasaakuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wuna yaapa apakélé kot véknwukwa némaan ban rate, du taakwa yan muké kudi wakwemarék yaké dé yo. Wani jébaa débu tiyaak wunéké. Wuné apakélé kot véknwukwa némaan ban rate yadan muké kudi wakweké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Akwi du taakwa wuna yaapana yéba kevérékdakwa pulak, wuna yéba kevérékdoké dé wani jébaa wunéké tiyaak. Wuna yéba kevérékmarék yakwa du taakwa de wunat wadéka yaawurén banna yéba wawo kaapuk kevérékdakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wuna kudi miték véknwute wunat wadéka yaawurén banké miték sanévéknwukwa du taakwa akwi kulé mawulé debu kéraak. Kérae apuba apuba Got wale miték rasaakuké de yo. Kukba wuné némaan ban rate deku kudi véknwute yadan kapéredi muké kudi wakwemarék yaké wuné yo. Kapéredi taalat yémarék yaké de yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Naate watakne dé Jisas tépa wak, “Mé véknwu. Gotna kudi véknwumarék yakwa du taakwa yéknwun mawulé kaapuk yadakwa. Yate kiyaan du taakwa pulak de ro. Rate wuna kudi véknwudaran de kulé mawulé kérae miték rasaakuké de yo. Wuna kudi véknwudaran tulé kéni dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wuna yaapa du taakwa kulé mawulé kérae miték rasaakudaranké dé apa yo. Dé apa tiyaate débu wunat wak. Wadénké wuné wawuru de du taakwa kulé mawulé kérae miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wuné Akwi Du Taakwana Nyaan wuné. Got wunéké apa tiyaadénké kukba wuné kot véknwukwa némaan ban rate, akwi du taakwa yan muké kudi véknwute wakweké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wani muké kwagénmarék yaké guné yo. Nak tulé yaadu kiyaan du taakwa rémdan waaguba kwaate wuna kudi véknwuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Véknwute nébéle raapme yaalaké de yo. Yéknwun mu yan du taakwa nébéle raapme apuba apuba miték rasaakuké de yo. Kapéredi mu yan du taakwa nébéle raapdo, wuné némaan ban rate derét waatite yadan kapéredi mu yakataké wuné yo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas waga watakne dé Judana némaan duwat tépa wak, “Wuné wuna mawuléba sanévéknwute wani jébaa yamarék yaké wuné yo. Wunat wadéka yaawurén banna kudi véknwute wuné du taakwa yan muké kudi wakweyo. Wuna mawuléba sanévéknwute wani kudi kaapuk wakwewurékwa. Waga yate miték wuné wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Wuné kapmu wuna jébaaké kudi wakwewuréran guné waké guné yo, ‘Déku kudi yénaa kudi.’ Naate wate guné wunéké miték sanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wuna yaapa wawo wuna jébaaké dé kudi wakweyo. Wakwedéka wuné kutdéngék. Wuna jébaaké wakwedékwa kudi wan adél kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Déknyényba guné Jonké kudi wakwesatik. Wakwesatigunéka dé gunat adél kudi wakwek wunéké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wuné duna kudiké kaapuk sanévéknwurékwa. Yate Got gunat kutkalé yaduké mawulé yate wuné Jonna kudiké wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Téwayé yaante kayénarédéka de du miték vu. Jon téwayé pulak téte walkamu kwaaré rate yéknwun jébaa yadéka guné véte guné dusék yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon wunéké kudi wakwedéka guné wunéké kutdéngék. Wuna apa jébaa déku kudit dé talaknak. Wuna yaapa yawuruké tiyaadén jébaa kéni wuné yo. Wani jébaa yawuréka du taakwa las véte de wo, ‘Déku yaapa Got wadéka dé yaak. Waga naané kutdéngék.’ Naate de wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wuna yaapa wunat wadéka yaawuréka dé wawo dé wunéké wakwek. Guné déku kudi las kaapuk véknwugunén. Déku ménidaama las kaapuk végunén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Got wunat wadék wunébu yaak. Déku kudi guna mawuléba kaapuk radékwa, guné wunéké miték sanévéknwumarék yagunékwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Guné kulé mawulé kérae miték rasaakugunéranké sanévéknwute, guné Gotna nyégaba kavidan kudiké sékalu. Wani kudi kavin du de wawo de wunéké wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kulé mawulé kérae miték rasaakuké guné mawulé yo. Wunéké yae wuna kudi véknwugunéran, wuné wawuru guné kulé mawulé kérae miték rasaakuké guné yo. Wuna kudi véknwumuké guné kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Du taakwa wuna yéba kevérékmuké kélik wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Guna mawulé wuné kutdéngék. Guné Gotké kaapuk mawulat kapére yagunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wuna yaapa Got wunat wadéka yae wuné déku jébaa yo. Yawuréka guné wuna kudi kaapuk véknwugunékwa. Nak du dé kapmu mawulé yate yae déku jébaa yadéran guné déku kudi véknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Du taakwa guna yéba kevérékdoké guné mawulé yo. Got guna yéba kevérékmuké guné kélik yo. Waga yate wunéké miték sanévéknwuké guné yapatiyu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Guna mawuléba wamarék yaké guné yo, ‘Jisas yanan kapéredi muké Gorét kudi wakweké dé yo.’ Waga wamarék yaké guné yo. Guné naana képmawaara Moseské guné wo, ‘Dé naanat kutkalé yaké dé yo.’ Waga wagunékwaké guné kéni kudi mé véknwu. Moses yagunén kapéredi muké Gorét wakweké dé yo. Déknyényba Moses dé kavik wunéké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Guné Moses kavin kudi véknwugunu mukatik guné wuna kudi véknwugunu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Guné kavidén kudi véknwumarék yate yaga pulak wuna kudi miték véknwuké guné yo? Wuna kudi miték véknwuké guné yapatiyu.” Naate dé Jisas Judana némaan duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wani kudi wakwetakne dé Jisas kwawu nak saknwat yék. Wani kwawuna yé Galili. Nak yé Taibirias. Naané déku du dé wale naané yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Déknyényba wupmalemu du taakwa de vék Jisas wupmalemu apa jébaa yadéka. Yadéka de sépékwaapa kapére yan du taakwa yéknwun yak. Vétakne de déku kukba yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Naané Jisas wale nébuba nak waare naané rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasova waanakwa apakélé yaa sérakne kanaran tulé yaaké yadéka naané waba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Rate dé Jisas vék wupmalemu du taakwa déké yaadaka. Vétakne dé Pilipmét wak, “Kadému yaba kérae wani du taakwaké kwayéno kaké de yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pilipna mawulé yaknwuké nae dé waga wak. Jisas yadéran muké dé kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jisas waga wadéka dé Pilip dérét wak, “Wupmalemu (200) yéwaat kadému las kéraanaran wani du taakwa walkamu walkamu male kaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naate wadéka naana du nak Andru dé waba ték. Wani du wan Saimon Pitana wayékna. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Téte dé wak, “Nyaan nak kéba dé tu. Wani nyaan makwal béret naktaba guba kutdan gukwami vétik waga dé kure tu. Wani makwal béret makwal gukwami wupmalemu du taakwat yaga pulak kwayéké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Naate wadéka dé Jisas naanat wak, “Wani du taakwat mé wakwe rado.” Naate wadéka wanaka yéknwun waara takuba de rak. Wupmalemu du taakwa de waba rak (Du 5000). ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Radaka dé Jisas wani béret kérae Gorét wak, “Yéknwun béret ménébu tiyaak. Wan yéknwun.” Naate watakne du taakwaké munikwedéka de kak. Béret yadén pulak male dé gukwami véti wawo waga yak. Mawulé yadan pulak male dé munikwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Munikwedéka kabutidaka dé Jisas naanat wak, “Kadaka rakwa kadému mé kéraa. Kéraamarék yagunu las bakna raké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naate wadéka naané du taakwa kadaka ran béret kébi taaba vétik sékét maanba kayék vétik waga naané kérae laakwak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yanaka de Jisas yan apa jébaa véte de wak, “Gotna yéba kudi wakwekwa du nak naana képmaat yaaké dé yo. Déké naané raségu. Raségénakwa du wan Jisas. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Waga wadaka dé Jisas kutdéngék. Dérét kure apa yate dé wani gayéba némaan ban raduké de mawulé yak. Waga kutdéngte wani gayéba némaan ban ramuké kélik yate dé kapmu nébat tépa gwaamale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Garabu yadéka naané Jisasna du dawulik kwawu maalat. Dawuliye botba waare naané Kapaneamét yéké mawulé yak. Yanaka Jisas naanéké kaapuk yaadén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yadéka gaan yadéka naané yék. Yénaka apakélé wimut kutdéka dé gu némaanba raapte waarék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Waarédéka bot yéluké naané kwalutte naané yék. Waga yate séknaaba naané yék (6 kilomita pulak). Ye naané vék Jisas gu takuba yaadéka. Véte naané wup yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wup yanaka dé naanat wak, “Kén wuné wuné yao. Guné wup yamarék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Naate wadéka naané yéknwun mawulé yate dusék yak. Yanaka dé botba yaalak. Yaaladéka rate naané botba ye wani gayé bari saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yé tékdéka de wupmalemu du taakwa kwawu nak saknwuba wekna rak. Rate deku mawuléba de wak, “Nalé nakurak bot lé rak. Raléka Jisasna du wani botba waare de yék. Yédaka Jisas kaapuk de wale yédén. Dé kéni taaléba dé ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Waga wate de Jisaské sékalpatik. Sékalpatidaka Taibiriasba de bot las wawo yaak. Yae de nalé rate béret kadan taalé tékwaba de rak. Nalé Jisas béret kérae Gorét wakwetakne dé deké kwayék, wani taaléba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jisas déku du wawo wani taaléba ramarék yadaka de du taakwa vépatitakne, wani botba waare de kwawu nak saknwat yék, Kapaneamét. Jisaské sékale véké nae de yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wani du taakwa ye saabe Jisasnyét véte de dérét waatak, “Némaan du, yani nyaa méné kénét yaak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naate waatadaka dé Jisas derét wak, “Mé véknwu. Béret kagunéka guna biyaa dé apa yak. Yadéka guné wunéké sékale vu, béret las wawo kwayéwuruké. Apa jébaa yawuréka végunénké guné kaapuk miték sanévéknwugunékwa. Guné jébaa yate guné biyaapran kadémuké sanévéknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Guné jébaa yate nak pulak kadémuké sanévéknwuké guné yo. Wani kadému rasaakuké dé yo. Guné wani kadému katakne miték rasaakuké guné yo apuba apuba. Wuna yaapa Got wadéka wuné Akwi Du Taakwana Nyaan awuréba wuné giyaak. Wuné wani yéknwun kadému kwayéké wuné yo. Got débu wunéké apa tiyaak, apa jébaa yawuruké. Yawuru guné wani jébaat véte kutdéngké guné yo. Got wadéka dé Jisas giyaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naate wadéka de wak, “Samu ye Gotna jébaa yaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naate wadaka dé wak, “Wunéké miték sanévéknwugunuké dé Got mawulé yo. Guna mawuléba waké guné yo, ‘Jisas wan némaan ban. Got wadéka dé giyaak. Wan adél.’ Waga wate guné Gotna jébaa yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Waga wadéka de wak, “Samu apa jébaa yaménu véte naané ménéké waga sanévéknwuké naané yo? Samu yaké méné yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Déknyényba naana képmawaara du ramarék taaléba yeyé yeyate de nak pulak kadému kak. Wani kadémuké de wak, ‘Mana.’ Déknyényba ran du de Gotna nyégaba wani kadémuké kéga kavik: Dé du taakwaké Gotna gayéba giyaan kadému kwayédéka de kak. Waga de kavik.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","De waga wadaka dé Jisas derét wak, “Déknyényba Moses wani kadému kaapuk kwayédén. Wuna yaapa male dé wani kadému kwayék. Bulaa dé gunéké Gotna gayéba giyaan nak pulak kadému dé kwayu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wuné Gotna gayéba giyaan kadémuké wakwete wuné duké wuné wakweyo. Got dérét wadéka dé Gotna gayéba yae dé kéni képmaat giyaak, du taakwat kutkalé yaké. Dé derét kutkalé yadu de miték rasaakuké de yo apuba apuba. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naate wadéka de Jisasnyét wak, “Némaan Ban, naané wani yéknwun kadému kéraaké naané mawulé yo. Apuba apuba mé tiyaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","De waga wadaka dé Jisas derét wak, “Wani kadémuké wakwete wuné wunéké kudi wakwek. Guné wuna kudi miték véknwute guné miték raké guné yo. Guné wunéké miték sanévéknwute kulé mawulé kérae miték rasaakuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Guné apa jébaa yawuréka véte guné wunéké kaapuk miték sanévéknwugunékwa. Déknyényba gunat waga wuné wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wuna yaapa wupmalemu du taakwa wunéké débu tiyaak. Wani du taakwa akwi wuna kudi véknwute wunéké yaaké de yo. Yaado naknét kélémarék yaké wuné yo. Wawuru de wunéké yae wuna du taakwa raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wuné Gotna gayéba re wuné kéni képmaat giyaak. Wuna mawuléba sanévéknwute jébaa yaké kaapuk giyaawurén. Wuna yaapa wadéka wuné giyaak, dé mawulé yadékwa jébaa yaké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wunéké yaaran du taakwaké miték rate véké wuné yo. Véwuru wuna du taakwa rasaakuké de yo. Nak yalakmarék yaké dé yo. Sésékukba yaaran nyaa wuné némaan ban rate, du taakwat kudi wakwewuréran tulé, wuné wawuru de kiyaan wuna du taakwa tépa nébéle raapké de yo. Waga dé Got mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wunat véte wunéké miték sanévéknwute wuna kudiké ‘Adél’ naakwa akwi du taakwa kulé mawulé kérae apuba apuba miték rasaakuké de yo. Wani nyaa wani du taakwat wawuru de tépa nébéle raapké de yo. Waga dé wuna yaapa mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas waga wadéka de Judana némaan du wani kudi véknwute de wani kudiké kélik yak. Jisas dé wak, “Wuné Gotna gayéba wuné giyaak, du taakwat kutkalé yawuru miték rasaakudoké.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Waga wadéka véknwute de kélik yak. Kélik yate de wak, “Gotna gayéba kaapuk giyaadén. Wan Josepna nyaan dé. Déku yé Jisas. Déku néwepat naané kutdéngék. Wan naana gayéba rakwa du. Dé wak, ‘Gotna gayéba wuné giyaak.’ Samuké dé waga wak? Déku kudi wan yénaa kudi.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wadaka dé Jisas derét wak, “Guné wuna kudiké kélik yate guné waga guna kapmu bulmarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Du taakwa deku mawuléba sanévéknwute wunéké yaamarék yaké de yo. Taale Got wadu de wunéké yaaké de yo. Kukba wuné némaan ban rate akwi du taakwat kudi wakwewuréran nyaa, wunéké yae kiyaan du taakwat wawuru de tépa nébéle raapké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Déknyényba Gotna yéba kudi wakwen du Gotna nyégaba kéga de kavik: Got akwi du taakwat déku jébaaké yakwatnyéké dé yo. Waga de kavik. Du taakwa Gotna kudi véknwute déku jébaaké kutdéngdaran, wani du taakwa akwi wunéké yaaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Du taakwa Gorét védanké kaapuk wakwewurékwa. Déku kudi véknwugunuké wuné waga wo. Du nak kaapuk Gorét védén. Wuné kapmu wuné vék. Wuné wuna yaapana gayéba rate wuné dérét vék. Vétakne wuné kéni képmaat giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Mé véknwu. Wunéké yae miték sanévéknwute wuna kudiké ‘Adél’ naakwa du taakwa de kulé mawulé debu kéraak. Kérae apuba apuba miték rasaakuké de yo. Adél wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wuné Gotna gayéba giyaan kadému pulak rate derét kutkalé yawuru de miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Guna képmawaara du ramarék taaléba yeyé yeyate mana waadakwa kadému de kak. Katakne kaapuk rasaakudan. Kukba wani du taakwa de kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wuné Gotna gayéba giyaan kadému pulak. Du taakwa wani kadému kadaran de apuba apuba miték rasaakuké de yo. Yalakmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wuné wani kadému pulak rate wuné akwi du taakwat kutkalé yo. Wuné Gotna gayéba wuné giyaak. Kéni képmaaba rakwa du taakwat kutkalé yaké wuné giyaak. Derét kutkalé yaké wuna sépé kwayéké wuné yo. Kwayéwuru de wani kadému kadaran de apuba apuba miték rasaakuké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judana némaan du wani kudi véknwute rékaréka yate deku kapmu waarute de wak, “Wan samu kudi? Yaga pulak wani du déku sépé tiyaadu naané kaké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","De waga wadaka dé Jisas derét wak, “Kéni kudi mé véknwu. Wuné Akwi Du Taakwana Nyaan. Wuna sépé wuna wény kamarék yagunéran miték rasaakumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Du taakwa wuna sépé wuna wény kadaran de kulé mawulé kérae miték rasaakuké de yo apuba apuba. Kukba kiyaado sésékukba yaaran nyaa wuné némaan ban rate, akwi du taakwat kudi wakwewuréran tulé, wuné wawuru de tépa nébéle raapké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wuna sépé wan nak pulak kadému. Wuna wény wan nak pulak gu. Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wuna sépé wuna wény karan du taakwa de wunéké miték sanévéknwute yéknwun mawulé kérae, wuna du taakwa raké de yo. Rado wuné deku mawuléba téké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wuna yaapa Got dé rasaaku apuba apuba. Rasaakute wunat wadéka wuné giyaak. Giyae déku kudi véknwute wuné rasaakuké wuné yo apuba apuba. Rasaakute wawuru de wuna sépé karan du taakwa rasaakuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wuné Gotna gayéba giyaan kadému pulak. Wan adél. Wani kadému wan Gotna gayéba giyaadéka guna képmawaara déknyényba kadan kadému pulak kaapuk. De wani kadému katakne kaapuk rasaakudan. Kukba de kiyaak. Du taakwa kudi wakwewurékwa kadému kadaran, kulé mawulé kérae miték rasaakuké de yo apuba apuba. Adél wuné gunat wakweyo.” Naate dé Jisas némaan duwat wak, kiyaadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kapaneamba dé wani kudi wakwek. Kudi buldakwa gaba téte dé wani kudi wakwek, dé kiyaadu de kulé mawulé kéraadaranké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasna du wupmalemu déku kudi véknwute de wak, “Jisas bulkwa kudi wan apa kudi. Yaga pulak wani kudi kutdéngké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Waga wadaka dé Jisas deku mawulé kutdéngte dé waatak, “Wuna kudiké guné kélik yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wuné awuréba wuné giyaak. Tépa gwaamale waaréwuru guné véte wani muké wawo kélik yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Gotna Yaamabi kapmu kulé mawulé kwayédu du taakwa kulé mawulé kérae de miték rasaakuké de yo apuba apuba. Bakna du kulé mawulé kwayémarék yaké dé yo. Guné kulé mawulé kérae miték rasaakugunuké wuné wani kudi wakwek. Gotna Yaamabi guna mawuléba wulaadu guné wunéké miték sanévéknwute kulé mawulé kérae miték rasaakuké guné yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Guné las wunéké kaapuk miték sanévéknwugunékwa. Taknaba wuné wani muké kéga wak: Du taakwa deku mawuléba sanévéknwute, de wunéké yae wuna kudi véknwumarék yaké de yo. Wuna yaapa Got derét wadéran de wunéké yae wuna kudi véknwuké de yo.” Naate dé Jisas wak. Déké miték sanévéknwumarék yakwa duwat dé kutdéngék. Dérét maamaké kwayéran banét wawo dé kutdéngék. Kutdéngte dé waga wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wadéka de wupmalemu du dérét kulaknyénytakne de yék. Yédaka naané du taaba vétik sékét maanba kayék vétik waga naané ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ténaka dé Jisas naanat wak, “Guné yaga pulak? Wunat kulaknyénytakne guné wawo yéké guné yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Naate waatadéka dé Saimon Pita wak, “Némaan Ban, ménat kulaknyénytakne ye kiyadé wale yeyé yeyaké naané yo? Méné kapmu méné naanat yéknwun kudi wakweyo, naané kulé mawulé kérae miték rasaakunoké. Méné kapmu méné wani kudi kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ménéké naané miték sanévéknwu. Naanébu kutdéngék. Méné Got wale re méné yaak. Dé wadéka ménébu yaak. Déku yéknwun ban méné.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naate wadéka dé Jisas naanat wak, “Wuné wawurék guné yae guné wuné wale yeyé yeyo. Yeyé yeyate guna du nak wan Setenna jébaa dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Naate wate dé Saimon Iskariotna nyaan Judaské wak. Judas wan déku du nak. Kukba dé Jisasnyét déku maamaké kwayéké dé yo. Judas waga yadéranké dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kukba Jisas dé Galiliba yeyé yeyate dé déku jébaa yak. Judana némaan du Judiaba rate de Jisasnyét viyaapérekgé de yak. Waga yadaka deku képmaaba kaapuk yé radén. Galiliba dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naané Juda apakélé yaa séraknaran tulé nak yaaké dé yak. Wani tulé naana ga kulaknyénytakne yéknwun mawulé yate Jerusalemét ye surél pulak gaba naané ro. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wani tulé de Jisasna wayéknaje dérét waatite de wak, “Kéni képmaa kulaknyénytakne méné Judiat yéké yo. Wani képmaat yéménu de ména kudi véknwuké mawulé yate waba rakwa du taakwa de yaménékwa jébaa véké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Méné némaan du raké mawulé yaménéran, akwi du taakwana méniba téte jébaa yaké méné yo. Némaan du raké mawulé yaménéran méné ye paakwe jébaa yamarék yaké méné yo. Judiat ye wani jébaa yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Naate Jisasna wayéknaje de wak. De déké kaapuk miték sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wadaka dé Jisas derét wak, “Akwi tulé guné Judiat yéké mawulé yate yéké guné yo. Wuné yéran tulé wekna kaapuk yaan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kéni képmaaba rakwa kwatkwa du taakwa wunéké de kélik yo. Derét wuné wakweyo, ‘Guné kapéredi mawulé yate guné kapéredi mu yo.’ Waga wakwewuréka de wunéké kélik yo. Wunéké kélik yate de gunéké de mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Guné Jerusalemét ye guné wani apakélé yaa sérakdakwa véké yo. Bulaa wuné yémarék yaké wuné yo. Wuné yéran tulé wekna kaapuk yaan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas waga wadéka véknwutakne de yék. Yédaka Jisas Galiliba dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisasna wayéknaje apakélé yaa sérakdakwa véké nae Jerusalemét yédaka dé Jisas deku kukba yék. Jisas yédéka dérét las kaapuk védan, dé paakwe yédén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Apakélé yaa sérakte surél pulak gaba ranakwa tulé yaadéka de Judana némaan du Jisaské sékalte de wak, “Wani du yaba dé ro?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Naate wadaka de du taakwa deku kapmu kéga bulék. Las de wak, “Wan kapéredi mu yakwa du. Du taakwat dé yénaa kudi wakweyo.” Wadaka las de wak, “Kaapuk. Wan yéknwun du.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Waga wate némaan du véknwumuké kélik yate némaanba kaapuk buldan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kadému sérakte kadaka dé Jisas Gotna kudi buldakwa némaa gat wulae dé du taakwat kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wakwedéka de Judana némaan du sanévéknwu wanévéknwute de wak, “Yaga pulak ye dé Gotna jébaaké kutdéngék? Naana du dérét kaapuk yakwatnyédan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Naate wadaka dé Jisas derét wak, “Gunat wakwewurékwa kudi wan wuna kudi kaapuk. Wan wunat wadéka yaawurén ban Gotna kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Guné déku kudi véknwuké mawulé yagunéran wakwewurékwa kudi miték véknwuké guné yo. Véknwute kutdéngké guné yo. Gotna kudi wuné wakweyo. Wuna mawuléba sanévéknwute kudi kaapuk wakwewurékwa. Waga kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nak du deku yéba kevérékdoké mawulé yate de du las deku mawuléba sanévéknwute kudi wakweyo. Wuné waga kaapuk yawurékwa. Wuna yaapa Got wadéka wuné yaak. Nak du Gotna yéba kevérékdoké mawulé yate wuné Got mawulé yadékwa pulak yate kudi wakweyo. Guné wuna kudi véknwute kutdéngké guné yo. Wuné yéknwun mawulé yakwa du. Yénaa yamarék yakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Déknyényba Moses dé gunat apa kudi wakwek. Wakwedék guné déku kudi kaapuk véknwugunékwa. Wunéké guné wo, ‘Dé Mosesna apa kudi kaapuk véknwudékwa.’ Naate wate guné wunat viyaapérekgé mawulé yo. Samuké guné waga yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Waga wadéka de wak, “Kutakwa lé ména mawuléba tu. Téléka méné waagété yo. Kiyadé ménat viyaapérekgé mawulé yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naate wadaka dé Jisas wak, “Yaap ra nyaa apa jébaa nak yawurék guné kwagénte sanévéknwu wanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Déknyényba Moses dé du nyaanna sépé sékugunuké yakwatnyék. Néwaa kéraalu nyaa nak taaba sékét nak taababa kayék kupuk yédu du nyaanna sépé sékugunuké dé yakwatnyék. “Wani mu Moses kaapuk batnyé yadén. Déku képmawaara de wani mu batnyé yak. Wan adél. “Guné Mosesna kudi véknwute néwaa kéraadaka nyaa nak taaba sékét nak taababa kayék kupuk yédéka guné guna du nyaanna sépé séku. Yate nak apu nak apu yaap ra nyaa guné séku. Sékute nyaa nak taaba sékét nak taababa kayék kupuk yénké guné sanévéknwu. Yaap ra nyaaké kaapuk sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Guné Mosesna kudi miték véknwute guné yaap ra nyaa guna du nyaanna sépé séku. Yaap ra nyaa wuné dut nak kutkalé yak. Yawurék samuké guné wunat rékaréka yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guné kutdéngmarék yate wuna jébaa véte guné bari wunat tépa waatimarék yaké guné yo. Miték kutdéngte yéknwun mawulé yate wuna jébaaké kudi wakweké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemba rakwa du taakwa de las wak, “Yaga pulak? Kéni du wan viyaapérekdaran ban, kapu kaapuk? ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mé vé. Dé akwi duna méniba téte dé kudi wakweyo. Wakwedéka némaan du dérét kaapuk waatidakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dé Got wadén ban Krais radékwaké de kutdéngék, kapu kaapuk? Naané wani duna néwaage naané kutdéngék. Naanat kutkalé yaduké Got wadén ban Krais yaadu naané déku néwaageké kutdéngmarék yaké naané yo. Yaga pulak Got wadén ban raké dé yo?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wadaka dé Jisas Gotna kudi buldakwa némaa gaba téte dé du taakwat kudi wakwek. Wakwete dé wak, “Guné wunat kutdéngte wuna néwaage guné kutdéngék. Guné wuna yaapat las kaapuk kutdénggunén. Dé wadéka wuné yaak. Wuna mawuléba sanévéknwute kaapuk yaawurén. Dé adél kudi male dé wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wuné dérét wuné kutdéngék. Wuné dé wale rawuréka dé wadéka wuné yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Waga wadéka de dérét kulékiye kure yéké nae de yak. Yate dérét kaapuk kulékidan. Dé kiyaaran tulé kaapuk wekna yaan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yadaka wupmalemu du taakwa déké miték sanévéknwute de wak, “Got wadén ban Krais déknyényba vémarék yanan apa jébaa yadu, kéni du yakwa jébaat talaknamarék yaké dé yo. Kéni du kén Got wadén ban Krais. Waga naané sanévéknwu.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jisaské wani kudi buldaka de Parisina du véknwuk. Véknwutakne de nyédé duna némaan du wale kwabugi duwat wadaka de yék, Jisasnyét kulékiye raamény gaba taknaké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ye saabadaka dé Jisas wak, “Wuné walkamu tulé re wunat wadéka giyaawurén banké tépa gwaamale yéké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yéwuru guné wunéké sékale sékalpatiké guné yo. Yate wuné rakwa gayét yaamarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Waga wadéka de Judana némaan du deku kapmu bulte de wak, “Dé yaba yédu naané déké sékalpatiké naané yo? Gérikna képmaaba rakwa Judana du taakwaké yéké dé yo? Ye Gérikna du taakwat déku jébaaké yakwatnyéké dé yo, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dé kéga dé wak, ‘Guné wunéké sékale sékalpatiké guné yo. Guné wuné rakwa gayét yaamarék yaké guné yo.’ Naate wate samu kudi dé bulu?” Waga de deku kapmu bulék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Apakélé yaa sérakte kanakwa tulé yéké yadéka wupmalemu du taakwa de rak. Wani nyaa wan némaa nyaa. Re ganba yéké de yo deku gayét. Radaka dé Jisas téte némaanba waate dé wak, “Guné guké kiyaagunéran wunéké yae guné gu kaké yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Guné wunéké miték sanévéknwugunéran wupmale gu guna mawuléba yaaladu guné miték rasaakuké guné yo. Wani muké de déknyényba kavik Gotna nyégaba.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Gotna Yaamabi déké miték sanévéknwukwa du taakwana mawuléba wulae tédéranké dé Jisas wani kudi wakwek. Gotna Yaamabi tédu de kulé mawulé kérae miték rasaakuké de yo. Rate nak duké yéké de yo, wani muké kudi wakweké. Kukba Jisas kiyae tépa nébéle raapme Gotna gayét waarédu Got wadu déku Yaamabi yaaké dé yo. Jisas waga wadén tulé Gotna Yaamabi kaapuk wekna yaan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Du taakwa las wani kudi véknwute de wak, “Adélna. Kén Gotna yéba kudi wakwekwa du. Raségénakwa du dé.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wadaka las de wak, “Kaapuk. Wan Got wadén ban Krais.” Naate wadaka las de wak, “Kaapuk. Wani du Galiliba dé yao. Got wadén ban Krais Galiliba yaamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Déknyényba Gotna nyégaba déké kéga de kavik: Got wadén ban Krais Devitna kémba dé ro. Dé déknyényba Devit ran gayé Betleyemba yaalaké dé yo. Waga de kavik.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wani kudi véknwutakne kés mawulé nak mawulé yate de kémba kémba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Rate de las Jisasnyét kulékiye raamény gaba taknaké mawulé yak. Yate de kaapuk dérét kulékiye kure yédan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Waga yadaka de kwabugi du de Parisina du, nyédé duna némaan duké tépa gwaamale yék. Yédaka de derét waatak, “Yaga pulak ye guné dérét kulékiye kure yaamarék yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Waatadaka de kwabugi du wak, “Déknyényba waga pulak du nak kaapuk téte waga pulak kudi buldén, kéni du bulkwa pulak. Wan yéknwun du dé.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Waga wadaka de Parisina du wak, “Yaga pulak? Wan gunat wawo dé yénaa yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Naana némaan du naané Parisina du wawo akwi naané déké wo, ‘Wan Got wadén ban Krais kaapuk. Yénaa dé yo.’ Waga naané wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wani kwatkwa du taakwa de déku kudi véknwu. De naana apa kudiké kaapuk kutdéngdan. Kukba Got wadu de yalakte kapéredi taalat yéké de yo. Deku kudi véknwumarék yaké guné yo.” Naate de Parisina du wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas wawo wan Parisina du. Déknyényba Jisaské dé yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nikodimas deku kudi véknwutakne dé wak, “Naana apa kudi véknwute kéga naané yo. Duna kudi véknwute yadén kapéredi muké wawo véknwutakne némaan ban waké dé yo, ‘Wan kapéredi mu yakwa ban. Yadén kapéredi mu dérét yakataké naané yo.’ Naate waké dé yo. Taale dé wani duna kudi véknwuké dé yo. Véknwutakne dérét waatiké dé yo. Dérét bakna waatimarék yaké dé yo. Wani du wadén pulak, naané Jisasnyét bakna waatimarék yaké naané yo. Taale déku kudi véknwuké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Naate wadéka de dérét waatite de wak, “Galiliba yaan kwatkwa du pulak méné kwatkwa ro. Gotna nyégaba kwaakwa kudi miték mé vé. Véte kutdéngké méné yo. Gotna yéba kudi wakwekwa du Galiliba yaamarék yaké dé yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wani kudi watakne de deku gat yék. Yédaka dé Jisas nébat nak waarék. Wani nébuna yé Oliv. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waare re ganbaba dé dawuliye Gotna kudi buldakwa némaa gat tépa gwaamale yék. Yédéka de akwi du taakwa déké yék. Yédaka dé rate dé derét kudi wakwek Gotké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wakwedéka de apa kudiké kutdéngkwa du Parisina du las waga de taakwat nak kure yék. Wani taakwat de vék nak taakwana du wale kapéredi mu yaléka. Kure ye de wadaka lé nyédéba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","6","Téléka de Parisina du kéga wak, “Jisas kapéredi kudi las buldéran naané dérét kotimké naané yo.” Waga wate de Jisasnyét yénaa yaké yak. Yate de dérét wak, “Némaan du, kéni taakwa nak taakwana du wale kapéredi mu yaléka naané vék. Déknyényba Moses Gotna nyégaba waga yakwa taakwaké dé kéga kavik: Waga yakwa taakwat matut viyaaké guné yo. Viyaagunu de kiyaaké de yo. Waga dé Moses kavik. Méné yaga méné wo wani taakwaké?” Naate wadaka dé Jisas kwaatabe dé déku taaba séknét képmaaba kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yadéka waba téte tépa waatadaka Jisas raapme dé derét wak, “Kéba tékwa du nak déknyényba kapéredi mu las yamarék yadéran dé lérét matut viyaaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Waga watakne tépa kwaatabe dé képmaaba kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waga yadéka déku kudi véknwutakne de nak nak gwaadék. Gwalepa du de taale gwaadék. Bakna du de kukba gwaadék. Gwaade yédaka dé Jisas male dé rak. Wani taakwa waba lé ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas raapme téte dé wani taakwat wak, “Nyéna, wani du yaba de yék? Nyénat waatiran du nak dé ro, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naate wadéka lé wak, “Némaan ban, wunat waatiran du kaapuk radékwa.” Naate waléka dé wak, “Wuné wawo nyénat waatimarék yaké wuné yo. Nyéné yéké nyéné yo. Kukba wani kapéredi mu tépa yamarék yaké nyéné yo.” Naate wadéka lé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas Gotna kudi buldakwa némaa gaba téte dé du taakwat tépa wak, “Kéni képmaaba rakwa du taakwat wuné kudi wakweyo, de kulé mawulé kéraadoké. Waga yate wuné yaankwa téwayé pulak wuné ro. Yaa yaante gaankétéba kayénarédéka de du taakwa miték véte ro. Wunéké miték sanévéknwukwa du taakwa gaankétéba ramarék yaké de yo. De deku kapéredi mawulé kulaknyénytakne kulé mawulé kérae nyaakaba rate miték raké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Waga wadéka de Parisina du wak, “Méné ménéké méné wakweyo. Naané ména kudi miték véknwumarék yaké naané yo, ména kudi male wakweménén bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Naate wadaka dé Jisas wak, “Wan adél. Wan wunéké wuné wakweyo. Guné wuna néwaageké kaapuk kutdénggunén. Guné yéwuréran yaabuké wawo kaapuk kutdénggunén. Wuné raapme yaawurén taalé wuné kutdéngék. Yéwuréran yaabu wawo wuné kutdéngék. Kutdéngte wuné wunéké wakweyo. Wakwewurékwa kudi wan adél kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Guné wunat véte wunéké kutdéngmarék yate guné wunat waatiyu. Bulaa wuné némaan du rate akwi du taakwat kaapuk las waatiwurékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wuné kapmu kaapuk jébaa yawurékwa. Got wunat wadék wuné yae kéni jébaa yawuréka dé wuné wale dé jébaa yo. Yadékwaké wuné némaan du rate gunat waatite kudi wakwewuréran yéknwun kudi wakweké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Guna apa kudiba kéga dé wo: Du vétik nakurak kudi male wakwebéréran wani duna kudi wan adél kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wadékwa kudiké sanévéknwute guné kéni kudiké sanévéknwuké guné yo. Wuné wuna kudi wuné wakweyo. Wakwewuréka wuna yaapa wawo wuna kudi dé wakweyo. Ané nakurak kudi male ané wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","De waga wadéka de wak, “Ména yaapa yaba dé ro?” Naate wadaka dé wak, “Guné wunéké kaapuk miték kutdénggunén. Yate wuna yaapaké wawo kaapuk miték kutdénggunén. Wunat kutdénggunu mukatik wuna yaapaké wawo miték kutdénggunu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas wani kudi dé derét wakwek Gotna kudi buldakwa némaa gaba. Yéwaa taknadakwa taaléba téte dé derét wani kudi wakwek. Wakwedéka de dérét kaapuk kulékiye kure yédan, dé kiyaaran tulé wekna yaamarék yan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas derét dé tépa wak, “Wuné yéké wunék. Yéwuru guné wunéké sékalpatiké guné yo. Sékalpatiye kiyaagunu yagunén kapéredi mu kaapuk yamarék yaké dé yo. Guné wuné yéran gayét yémarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Waga wadéka de Judana némaan du wak, “Yaga pulak? Kéga dé wak, dé yéran gayét naané yémarék yaké naané yo. Dé déku sépé viyae kiyaaké dé waga wo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","De waga wadaka dé wak, “Guné képmaaba rakwa du guné. Wuné kaapuk. Wuné awuré Gotna gayéba re wuné giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Guné kiyaagunu yagunén kapéredi mu kaapuk yamarék yaké dé yo. Wani muké wuné wakwek gunat. Wuné du taakwat kutkalé yawuruké Got wadén ban wuné. Wunéké miték sanévéknwumarék yagunéran kiyaagunu yagunén kapéredi mu kaapuk yamarék yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Naate wadéka de wak, “Yaga méné wo ména jébaaké?” De waga waatadaka dé Jisas wak, “Déknyényba gunat wunébu wupmalemu apu wakwek wunéké. Wuné nak kudi wakwemarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wuné mawulé yawuru mukatik wupmalemu kudi yagunén kapéredi mawulé gunéké wawo wakwewuru. Waga wakwemarék yaké wuné yo. Kéni kudi male wuné wakweyo. Wunat wadéka yaawurén banna kudi wan adél kudi. Wuné déku kudi véknwute wuné kéni képmaaba rakwa du taakwat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Naate wadéka de déku yaapaké wakwedénké kaapuk kutdéngdan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yadaka dé Jisas wak, “Kukba Akwi Du Taakwana Nyaan wunat miba kusawuréké guné yo. Kusawurétakne wunéké kutdéngké guné yo. Wuna mawuléba kudi nak kaapuk gunat wakwewurén. Wuna yaapa wakwen pulak véknwute wuné wakwek. Waga wawo kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuna yaapa wunat wadéka yaawuréka dé wawo yae wuné wale dé tu. Dé wunat kaapuk kulaknyénydén. Yadéka wuné kapmu kaapuk rawurékwa, dé mawulé yakwa jébaa male yawurékwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Waga wadéka de wupmalemu du taakwa déké miték sanévéknwute déku kudiké “Adél” de naak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisas dé wani Judana duwat wak, “Guné wuna kudi véknwute wuna jébaa yate guné wuna du guné ro. Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wuna du rate guné adél kudi véknwuké guné yo. Véknwute guné baagwit gidan du pulak yamarék yaké guné yo. Guné miték raké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Naate wadéka de dérét wak, “Naané Ebrayamna képmawaara naané ro. Déknyényba du las naanat baagwit kaapuk gidan. Naané miték naané ro. Méné wo, ‘Guné baagwit gidan du pulak ramarék yaké guné yo. Guné miték raké guné yo.’ Samuké méné waga wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","De waga wadaka dé Jisas wak, “Kéni kudi mé véknwu. Du taakwa de kapéredi mu yo. Wani kapéredi mu dé derét gik. Gidéka wani du taakwa akwi kaapuk miték radakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Du las apa yate nak duwat baagwit gidaka de derét gin duna jébaa yo. Yate derét gin duna kém wale kaapuk rasaakudakwa. Derét gin duna nyaan male wani kém wale rasaakuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wuné Gotna nyaan wuné ro. Wuné miték ragunuké wawuréran kapéredi mu gunat tépa gimarék yaké dé yo. Guné miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Guné Ebrayamna képmawaara. Waga wuné kutdéngék. Ebrayamna képmawaara rate guné déku kudi kaapuk véknwugunékwa. Yate wuna kudiké kélik yate guné wunat viyaapérekgé guné wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wuna yaapa wunat wakwatnyédén jébaaké wuné gunat wakweyo. Wakwewuréka guné guna yaapa wakwen kudi male guné véknwu.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jisas waga wadéka de wak, “Naana yaapa wan Ebrayam.” Naate wadaka dé Jisas wak, “Guné Ebrayamna képmawaara. Wan adél. Samuké nae guné yadén jébaa yamarék yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Got wakwedéka véknwurén adél kudi akwi wunébu wakwek. Wakwewurénké bulaa wunat viyaapérekgé guné wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ebrayam kaapuk waga yadén. Guné guna yaapa yan pulak male guné yo.” Dé waga wadéka de wak, “Naané yaabuba tékwa taakwana baadi kaapuk. Naana yaapa wan nakurak male. Wan Got.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Naate wadaka dé Jisas wak, “Wuné Got wale re wuné giyaak. Wuna mawuléba sanévéknwute kaapuk giyaawurén. Got wadéka wuné giyaak. Giyaawurénké Got guna yaapa radu mukatik wunéké mawulat kapére yagunu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Samuké guné wuna kudiké miték sanévéknwumarék yo? Wuna kudiké kélik yate guné kaapuk miték sanévéknwugunékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Guné Setenna nyaangu guné. Waga rate guné guna yaapana mawuléba jébaa yo. Déknyényba dé du taakwat viyaapéreknék. Dé du taakwat viyaapérekgwa ban dé rasaaku. Waga yate adél kudi kaapuk véknwudékwa. Dé yénaa kudi male dé wakweyo. Yénaa kudi wan déku kudi. Dé yénaa kudi wakwete dé akwi du taakwat yénaa yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wuné adél kudi male wuné wakweyo. Wakwewuréka guné wuna kudiké kélik yate guné yénaa kudiké mawulé yo. Yate guné wuna kudi véknwumarék yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wuné kapéredi mu kaapuk yawurékwa. Kapéredi muké guna du nak wunat waatiké dé yapatiyu. Wuné adél kudi wuné wakweyo. Wakwewuréka samuké guné wuna kudi véknwumarék yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gotna nyaangu akwi de déku kudi véknwu. Guné Gotna nyaangu kaapuk. Yate déku kudi kaapuk miték véknwugunékwa.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wadéka de Judana némaan du Jisasnyét waatite de wak, “Taknaba naané wak, ‘Méné Sameriana du. Kutakwa ména mawuléba lé tu. Téléka méné waagété yo.’ Naate wate naané adél kudi naané wak. Bulaa waga naané kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","aate wadaka dé Jisas wak, “Wuné kutakwa nak kaapuk wuna mawuléba télékwa. Wuné wuna yaapana yéba kevérékwuréka guné wuna yéba kaapuk kevérékgunékwa. Guné wunéké guné wo, ‘Wan kapéredi mu yakwa ban.’ Naate guné wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wuné wuna yéba kevérékmuké kélik wuné yo. Du nak némaan ban rate dé wuna yéba kevérékgé dé yo. Kevérékte dé wunat waké dé yo. ‘Yéknwun mu yakwa ban méné.’ Naate waké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wuna kudi miték véknwukwa du taakwa Got wale apuba apuba rasaakuké de yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dé waga wadéka de némaan du wak, “Ména mawuléba kutakwa lé tu. Bulaa waga naanébu kutdéngék. Ebrayam débu kiyaak. Kiyaadéka Gotna yéba kudi wakwen du wawo debu kiyaak. Kiyaadaka méné wak, ‘Wuna kudi miték véknwukwa du taakwa kiyaamarék yaké de yo.’ Samuké méné waga wo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Naana képmawaara Ebrayam débu kiyaak. Méné dérét méné talaknak, kapu yaga pulak? Gotna yéba kudi wakwen du wawo debu kiyaak. Méné kiyadé? Yaga méné wo ménéké?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dé waga wadaka dé Jisas wak, “Wuné wuna yéba kevérékwuru mukatik wuné némaan du ramarék yawuru. Wuna yaapa kapmu dé wuna yéba kevéréknu. Déké guné wo, ‘Got wan naana némaan ban.’ ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Naate wate guné déké kaapuk kutdénggunén. Wuné dérét wuné kutdéngék. Wuné kéga wawuru mukatik, ‘Wuné dérét kaapuk kutdéngwurén.’ Waga wawuru mukatik wuné wawo guné yénaa yakwa pulak yénaa yawuru. Wuné dérét wuné kutdéngék. Kutdéngte wuné déku kudi miték véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Guna képmawaara Ebrayam jébaa yawuréran tuléké kutdéngte dé dusék yak. Yate védéka déku mawulé yéknwun dé yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Naate wadéka de némaan du wak, “Wupmalemu kwaaré déknyényba Ebrayam dé rak. Méné wupmalemu kwaaré kaapuk raménén. Yaga pulak méné Ebrayamét vék?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Naate wadaka dé Jisas wak, “Déknyényba Ebrayam ramarék yadéka wuné wuné rak. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Waga wadéka de rékaréka yate de matu kéraak, dérét viyaaké. Yadaka dé Jisas paakwe ye Gotna kudi buldakwa némaa ga kulaknyénytakne dé kaapat gwaadék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Naané Jisas wale yaabuba yéte naané vék méni kiyaan dut. Wani du néwaa dérét kéraaléka dé waga yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yadéka naané Jisasna du dérét wak, “Némaan du, wani duna néwaa kéraaléka déku méni dé kiyaak. Kiyadé kapéredi mu yak dé déku méni kiyaak? Wani du dé kapéredi mu yak, kapu déku néwepa bét kapéredi mu yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Naate wanaka dé Jisas wak, “Wani du kaapuk kapéredi mu yadén. Déku néwepa wawo kaapuk kapéredi mu yabérén. Déku méni dé kiyaak, guné dérét Got yaran apa jébaa végunuké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Got wunat wadéka wuné yaak. Yae tiyaadén jébaa bulaa yaké wuné yo. Kukba wani jébaa yaké yapatiké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wuné kéni képmaaba rate téwayé yaankwa pulak wuné ro. Rate du taakwaké kulé mawulé kwayéwuru de miték kutdéngké de yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Watakne dé képmaaba sépmeny sévaak. Sévaatakne dé képmaa wale las kérae dé wani duna méniba kurék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kutte dé dérét wak, “Ye méné Siloamba tékwa kwawuba méni yakutnyéké yo.” Naate wadéka ye dé wani kwawuba méni yakutnyék. Yakutnyédéka déku méni yéknwun yadéka miték véte dé tépa gwaamale yaak. Wani kwawuké de yé waak, Siloam. Wan deku kudi. Naana kudi kéga: Wadaka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wani du gwaamale yaadéka déku gayéba rakwa du déknyényba dérét vén du taakwa wawo dérét véte de wak, “Déknyényba wani du yaabuba rate dé du taakwat yéwaaké yaawik, kapu kaapuk? Wan nak du, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Naate wadaka de las wak, “Adél, wan wani du dé.” Las de wak, “Kaapuk. Dé wani du pulak. Wan nak du dé.” Waga wadaka dé wani du wak, “Kén wuné wuné. Wuné yéwaaké yaawite yaabuba ran du wuné.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naate wadéka de dérét wak, “Yaga pulak yaménék dé ména méni yéknwun yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naate waatadaka dé wak, “Wani du déku yé Jisas dé képmaa kérae sépmeny sévaatakne dé wuna méniba kurék. Kutte dé wunat wak, ‘Ye méné Siloamba tékwa kwawuba méni yakutnyéké yo.’ Naate wadéka ye wuné kwawuba méni yakutnyéwuréka dé wuna méni yéknwun yadéka wuné miték vu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Naate wadéka de dérét wak, “Wani du yaba dé ro?” Waga waatadaka dé wak, “Wuné kaapuk kutdéngwurén.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","De méni kiyae yéknwun yan dut Parisina duké kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yaap ra nyaa dé Jisas képmaa kérae sépmeny sévaatakne dé wani duna méniba kutdéka dé yéknwun yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kure yédaka Parisina du de dérét tépa waatak, “Ména méni yaga pulak ye dé yéknwun yak?” Naate waatadaka dé wak, “Képmaa kérae sépmeny sévaatakne wadéka méni yakutnyéwurék dé wuna méni yéknwun yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Waga wadéka de Parisina du las wak, “Wani du yaap ra nyaaké naana apa kudi kaapuk véknwudékwa. Yadéka naané kutdéngék. Got kaapuk dérét wadéka yaadén.” Naate wadaka de las wak, “Yéknwun mu yakwa du male dé wani apa jébaa yaké dé yo.” Waga watakne de mawulé vétik yate de kémba kémba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yate de méni kiyaan dut tépa wak, “Ména ménit kutkalé yan duké yaga méné wo?” Naate waatadaka dé wak, “Wan Gotna yéba kudi wakwekwa du nak.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Déknyényba wani duna méni dé kiyaak. Bulaa déku méni yéknwun débu yak. Yadéka de Judana némaan du wani muké “Adél” naamuké kélik de yak. Kélik yate de méni kiyaan duna néwepat waak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Waadaka yaabétka de bérét waatak, “Wan béna nyaan dé, kapu kaapuk? Néwaa kéraaléka dé méni kiyaak. Béné waga béné wo, kapu kaapuk? Yaga pulak ye dé méni vu?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","22","Waga wadaka dé déku yaapa wak, “Guné dérét guné waataké yo. Némaan débu yak. Dé kapmu kudi bulké dé yo. Ané ané kutdéngék. Wan ana nyaan dé. Néwaa kéraaléka méni kiyae radénké ané kutdéngék. Bulaa méni védékwaké ané las kaapuk kutdéngtén. Kiyadé wak dé déku méni yéknwun yak? Kaapuk las kutdéngtén.” Waga wate dé yénaa yak. Judana némaan du bérét waatimuké dé yénaa yak. Déknyényba de némaan du kéga wak, “Du nak ‘Jisas wan Got wadén ban Krais’ naadéran wano wani du kudi bulnakwa ga kulaknyénytakne ye tépa yaalamarék yaké dé yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","De bérét waga wamuké bét wani duna néwepa wup yak. Wup yate dé wak, “Némaan débu yak. Guné dérét guné waataké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dé waga wadéka de némaan du wani dut tépa waak. Waadaka yaadéka de dérét wak, “Méné adél kudi wakwete Gotna yéba kevérékgé méné yo. Naané naané kutdéngék. Jisas wan kapéredi mawulé yakwa du.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naate wadaka dé derét wak, “Wuné kaapuk kutdéngwurén. Dé kapéredi mawulé yakwa du, kapu kaapuk? Kéga male wuné kutdéngék. Déknyényba wuna méni dé kiyaak. Bulaa wuna méni yéknwun yadéka wuné miték vu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naate wadéka de wak, “Samu dé ménat yak? Yaga pulak yadék dé ména méni yéknwun yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naate waatadaka dé wak, “Wuné wakwewuréka guné kaapuk véknwugunén. Samuké guné tépa véknwuké mawulé yo? Guné wawo déku jébaaba wulaaké guné mawulé yo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naate wadéka de dérét waatite de wak, “Méné déku jébaaba wulaan du. Naané Mosesna jébaaba naanébu wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Naané Got Moses wale kudi buldénké naané kutdéngék. Moseské naané kutdéngék. Wani gweba duké kaapuk kutdéngnan. Yaadén taaléké wawo kaapuk kutdéngnan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naate wadaka dé wak, “Yaga pulak? Dé wadéka dé wuna méni yéknwun yak. Yadéka guné dé yaadén taaléké kaapuk kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Naané kutdéngék. Got kapéredi mawulé yakwa duna kudi kaapuk véknwudékwa. Déké miték sanévéknwute déku jébaa yakwa duna kudi dé véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Déknyényba néwaa kéraadaka méni kiyaan du kaapuk védan. Déknyényba deku méni kutkalé yan banké kudi kaapuk véknwunan. Bulaa male naané déké véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dé wunat yéknwun jébaa yadéka wuné kutdéngék. Got wadéka dé yaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Waga wadéka de rékaréka yate de wak, “Ména néwaa kapéredi mu ye lé ménat kéraak. Kéraalék méné kapéredi mawulé yakwa du méné ro. Waga rate méné naanat yakwatnyémarék yaké méné yo.” Waga watakne de wak, “Gotna kudi bulnakwa ga mé kulaknyénytakne ye tépa yaalamarék yaké méné yo.” Naate wadaka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Wani du yédéka Jisas véknwutakne déké sékale véte dé dérét wak, “Méné Akwi Du Taakwana Nyaanké miték méné sanévéknwu, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naate wadéka dé wak, “Némaan ban, wani ban wan kiyadé? Méné wunat wakweménu wuné déké miték sanévéknwuké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Naate wadéka dé Jisas wak, “Méné dérét ménébu vék. Wani du bulaa méné wale kéni dé bulu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naate wadéka dé wak, “Némaan Ban, méné Akwi Du Taakwana Nyaan méné. Wan adél. Bulaa waga wuné kutdéngék.” Naate watakne dé képmaaba kwati yaane dé waadé daak, Jisasnyét. ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Waga yadéka dé Jisas wak, “Du taakwa mawulé vétik yate kémba kémba radoké wuné kéni képmaat giyaak. Du taakwa de las wo, ‘Naané Gotké kaapuk kutdéngnan.’ Naate wate méni kiyaan du pulak de ro. Rado wuné yae wawuru de Gotna jébaa véké de yo. Du taakwa las kéga de wo, ‘Naané Gotké naané kutdéngék.’ Waga wate déké kaapuk kutdéngdan. Yado wuné yae wawuru de méni kiyaan du pulak rate Gotna jébaa vémarék yaké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Naate wadéka de Parisina du las waba rate wani kudi véknwute de dérét wak, “Yaga méné wo? Naané Gotké kaapuk kutdéngnan. Yate méni kiyaan du pulak naané ro. Méné waga méné wo, kapu yaga pulak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Naate waatadaka dé wak, “Guné Gotké kutdéngmarék yate méni kiyaan du pulak ragunu mukatik kapéredi mawulé yamarék yagunu. Guné guné wo, ‘Naana méni kaapuk kiyaan. Naané Gotké naané kutdéngék.’ Waga wate Gotké kutdéngmarék yagunéka guna kapéredi mawulé wekna dé ro.” Naate dé Jisas Parisina duwat wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas dé wak, “Kéni kudi mé véknwu. Sipsip tékwa taalat wulaaké mawulé yate, gwéspétéké kélik yate, gidan raatmuba waaréte dawulikwa du, wan gwalmu sél yate bakna kéraakwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gwéspétéba wulaakwa du wan sipsipké téségékwa du. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wani du wulaaké yadéka dé gwéspétéba tékwa du gwés naapiyu. Naapidéka wulaadéka de sipsip déku kudi véknwu. Déku sipsipna yéba male dé wao. Waate yédéka véknwute de kaapat gwaadu. Gwaadédaka dé sipsipké téségékwa du taale yu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yédéka déku sipsip déku kudi véknwute de déku kukba yu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","De nak duna kukba kaapuk yédakwa. De wani duké wup yate de yaage yu, déku kudi véknwumarék yadakwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Naate dé Jisas aja kudi wakwek. Némaan ban rate déké miték sanévéknwukwa du taakwaké miték véké sanévéknwute dé wani aja kudi wakwek. Wakwedéka de wani kudiké kaapuk miték kutdéngdan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yadaka dé Jisas tépa wak, “Mé véknwu. Wuné sipsip wulaakwa gwéspété pulak wuné tu. Wuna du taakwa wani sipsip pulak de tu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taale yaan du wan gwalmu sél yakwa du pulak yate de yénaa yak. Yadaka sipsip deku kudi kaapuk véknwudan. Wuné sél yakwa duna kukba wunébu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wuné gwéspété pulak. Du taakwa yae wani gwéspétéba wulaadaran de apuba apuba miték rasaakuké de yo. De wani gwéspétéba wulaa yaalate kadému kérae kaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yénaa yakwa du yénaa kudi wakwete deku mawulé yaalébaanké de yaak. Wuné derét kutkalé yate kulé mawulé kwayéwuru yéknwun mawulé yate apuba apuba miték rasaakudoké, wunébu yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Wuné sipsipké miték téségékwa du wuné. Wuna sipsipmét kutkalé yaké wuné kusékétwuru wuna maama wunat viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Wani yénaa yakwa du, yéwaa kéraaké jébaa yakwa du pulak yate, de sipsipké kaapuk miték téségédakwa. Kwatbosa yaadaka véte de sipsipmét kulaknyénytakne yaage yu. Sipsipké mawulé lékmarék yate yéwaaké male sanévéknwute de yaage yu. Yaage yédaka de kwatbosa sipsipmét tiké kélédaka de sipsip yaage yu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Wuné sipsipké miték wuné téségu. Wuna yaapa dé wunat kutdéngék. Kutdéngdéka wuné dérét wuné kutdéngék. Waga pulak wuné wuna sipsipmét kutdéngwuréka wuna sipsip wunat de kutdéngék. Wuna sipsipmét kutkalé yaké wuné kusékétwuru de wuna maama wunat viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wuna sipsip las wawo de tu. Wuna kudi kaapuk wekna miték véknwudakwa. Kéni sipsip wale kaapuk tédakwa. Wuné derét wawo kure yaaké wuné yo. Kure yaawuru de wuna kudi véknwuké de yo. Wuna sipsip akwi wuné wale nakurak mawulé yado wuné kapmu deké téségéké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wuné kusékétwuru de wunat viyaado kiyae tépa nébéle raapké wuné yo. Waga yawuréranké wuna yaapa dé wunéké mawulat kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wuné kélik yawuru mukatik de wunat viyaapérekmarék yado. Wuné mawulé yate kusékétwuru de wunat viyaapérekgé de yo. Wan wuna jébaa. Wuné apa yate kusékétwuru wunat viyaado kiyae apa yate tépa nébéle raapké wuné yo. Wani jébaa yawuruké wuna yaapa débu wunat wakwek.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wadéka de Judana némaan du wani kudi véknwutakne mawulé vétik yate de kémba kémba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Rate de wupmalemu du wak, “Kutakwa déku mawuléba téléka dé waagété yo. Guné déku kudi véknwumarék yaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","De waga wadaka de las wak, “Kaapuk. Kutakwa déku mawuléba télu mukatik wani kudi bulmarék yakatik dé yak. Déknyényba dé wadéka dé méni kiyaan du miték vék. Kutakwa walu méni kiyaan du tépa vémarék yaké de yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalemba de apakélé yaa sérakgé de yak. Wani yaa sérakdakwa tulé naané naana képmawaara déknyényba Gotna kudi buldakwa némaa ga tépa kaadanké naané sanévéknwu. Wani tulé wan yépmaa yakwa tulé. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wani tulé Gotna kudi buldakwa némaa gaba dé Jisas yeyé yeyak. Malégaba dé yeyé yeyak. Wani maaléké naané wak, Solomonna maalé. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wani maaléba yeyé yeyadéka de Judana némaan du yae jawe téte de dérét wak, “Yani nyaa méné naanat wakweménu naané ménéké miték kutdéngké naané yo? Méné Got wadén ban Krais raménéran naanat miték mé wakwe.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wadaka dé Jisas wak, “Wuné gunat wunébu wakwek. Wakwewuréka guné kaapuk miték véknwugunékwa. Wuna yaapa apa tiyaadéka wuné déku jébaa yo. Yawuru guné wani jébaa miték végunu mukatik wunéké kutdénggunu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Guné wuna sipsip kaapuk. Guné wuna kudi véknwumarék yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wuna sipsip wuna kudi de véknwu. Véknwudaka wuné derét kutdéngte taale yéwuréka de wuna kukba yao. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yaadaka wuné deké kulé mawulé kwayu, apuba apuba miték rasaakudoké. Nak yalakmarék yaké dé yo. Nak du de kwayéwurén kulé mawulé kulaknyénydoké derét kudi wakwedaran de wuna sipsip deku kudi véknwumarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wuna yaapa dé derét wunéké tiyaak. Dé némaan ban rate akwi duké apa dé yo. Déku apa akwi duna apat dé talaknak. Dé apa yate tédu nak du wuna sipsipmét kulékiye kure yémarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ané wuna yaapa wale nakurak ané ro.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dé waga wadéka de Judana némaan du matu tépa kérae de dérét viyaaké yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yadaka dé Jisas derét wak, “Wuné wuna yaapana wupmalemu yéknwun jébaa yawuréka gunébu vék. Guné samu jébaaké sanévéknwute guné wunat matut viyaaké yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dé waga wadéka de némaan du wak, “Naané yéknwun jébaaké sanévéknwumarék yate naané ménat matut viyaaké yo. Méné Gorét wasélékte méné kapéred kudi bulu. Méné némaan du kaapuk. Méné bakna du méné ro. Rate méné wo, ‘Ané Got wale nakurak ané ro.’ Waga waménénké naané ménat matut viyaaké yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Wadaka dé wak, “Yaga pulak? Guna apa kudiba kéni kudi dé kwao nyégaba: Guné Got pulak ragunékwaké wunébu wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Déknyényba rate déku kudi véknwun duwat Got dé wani kudi wakwek. Wakwedén kudi wan adél kudi. Got derét waga wakwedék wuné wani kudi pulak wakwewuréka samuké guné wunat waatiyu? ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wuna yaapa dé wunat wak, du taakwat kutkalé yawuruké. Wunat wadéka wuné kéni képmaat giyaak. Giyae wuné wak, ‘Wuné Gotna nyaan.’ Waga wawuréka guné wo, ‘Méné wani kudi wakwete méné Gorét waséléknu.’ Samuké guné waga wo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuné wuna yaapana jébaa yamarék yawuréran guné wuna kudi véknwumarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wuné déku jébaa wuné yo. Yawuru guné wuna kudi véknwumuké kélik yagunéran yawurékwa jébaaké miték sanévéknwuké guné yo. Waga wuné mawulé yo. Guné waga yate kutdéngké guné yo. Wuné wuna yaapa wale nakurak mawulé ané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Naate wadéka de dérét tépa kulékiye raamény gaba taknaké mawulé yak. Mawulé yadaka dé yédéka de dérét kaapuk kulékiye kure yédan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas tépa gwaamale ye dé Jodan kaabélé nak saknwat yék. Ye dé Jon derét gu yaakutaknan taalé saabak. Saabe dé wani taaléba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Radéka de wupmalemu du taakwa déké yaak. Yae vétakne deku kapmu bulte de wak, “Jon déknyényba vémarék yanan apa jébaa kaapuk yadén. Yate wani duké wakwete adél kudi male dé wakwek.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naate watakne wani gayéba rakwa du taakwa wupmalemu de déké miték sanévéknwute de wak, “Jisas wan Gotna nyaan. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betaniba ran du nak dé kiyakiya yak. Déku yé Lasaras. Betani wan Maria bét léku némaadu Matana néwaage. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nak nyaa wani taakwa Maria lé yéknwun yaama yakwa gu Némaan Ban Jisasna maanba sévik. Sévitakne lé léku nébat yatnyék. Wan léku kayé Lasaras dé kiyakiya yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yadéka Jisas séknaaba radéka bét Lasarasna nyange vétik kéni kudi Jisasnyét wakwesatik: “Némaan Ban, mawulat kapére yaménékwa du kiyakiya dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisas wani kudi véknwute dé wak, “Wani kiyakiya yadu dé kiyaamarék yaké dé yo. Wuné Gotna nyaan. Wuné dérét kutnébulwuru guné dérét véte Gotna yéba kevérékgé guné yo. Yate guné wuna yéba wawo kevérékgé guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Jisas dé Maria, Mata, Lasaraské mawulat kapére yak. Lasaras kiyakiya yadékwaké véknwutakne dé radén gayéba nyaa vétik wawo rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Re kukba dé naanat wak, “Judiat tépa gwaamale yéké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Naate wadéka naané déku du wak, “Némaan du, bulaa male de ménat matut viyaaké yak. Yadaka samuké méné wani képmaat tépa gwaamale yéké méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Naate wanaka dé Jisas wak, “Du nyaaba yédaran akérémarék yaké de yo, nyaa védéka véte miték yédakwa bege. Gaan yéran du wani akéréké de yo, gaan yadéka miték vémarék yadakwa bege. Du nyaaba jébaa yate yéknwun jébaa yaké de yo. Jébaa yawurékwa tulé wekna dé ro. Wunat viyaapérekdaran tulé kaapuk wekna yaan. Bulaa wuna jébaa yaké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Waga watakne dé tépa naanat wak, “Naana du Lasaras widé dé kwao. Wuné ye wawuru tépa raapké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Naate wate dé Lasaras kiyaanké dé wakwek. Wakwedéka naana mawuléba naané wak, “Wan bakna widé kwaadékwaké dé wakweyo.” Waga wate naané wak, “Némaan Ban, dé bakna widé kwaadéran dé yéknwun yaké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Waga wanaka dé naanat wak, “Lasaras débu kiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kiyaadéka wuné dé wale kaapuk rawurén. Guné wuna apaké kutdénggunuké nae wuné déké yémarék yawurék dé wuna mawulé yéknwun yo. Bulaa déké yéké naané yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Naate wadéka déku du nak Tomas, déku nak yé Didimas dé naanat wak, “Naané dé wale ye naané dé wale kiyaaké yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas wale waga naané yék. Ye saabe dé Jisas kudi véknwuk Lasaraské. Lasaras nyaa wan véti wan véti dé rémdan waaguba kwaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani Jerusalem tékwaba dé tu (3 kilomita pulak). Séknaaba kaapuk tékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mata bét Mariana kayé kiyaadéka de wupmalemu du taakwa Jerusalem kulaknyénytakne de Betanit yék, bét wale raké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Naané Jisas wale yaabuba yénaka lé Mata kudi véknwuk. Véknwutakne Jisasnyét yaabuba véké nae lé yék. Yéléka Maria gaba lé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Raléka yae Jisasnyét véte lé Mata wak, “Némaan Ban, méné kéba raménu mukatik wuna kayé kiyaamarék yakatik dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Méné bulaa Gorét waataménéran mawulé yaménékwa jébaa akwi yakweké dé yo. Waga wuné kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Naate waléka dé Jisas wak, “Nyéna kayé tépa nébéle raapké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naate wadéka lé Mata wak, “Wuné kutdéngék. Kiyaan akwi du taakwa nébéle raapran tulé nébéle raapké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Naate waléka dé Jisas wak, “Wuné kapmu waké wuné yo. Wunéké miték sanévéknwute kiyaan du taakwat wuné wawuru de tépa nébéle raapké de yo. Raapme kulé mawulé yate apuba apuba miték rasaakuké de yo. Wunéké miték sanévéknwukwa du taakwa kulé mawulé kérae apuba apuba miték rasaakuké de yo. Yalakmarék yaké de yo. Kén wakwewurékwa kudiké ‘Adél’ nyéné nao, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naate wadéka lé wak, “Némaan Ban, wan adél. Méné Got wadén ban Krais. Méné Gotna nyaan. Méné raségénakwa ban. Wan adél.” Naate lé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata waga watakne ye lé léku wayékna Mariat waak. Waaléka yaaléka kure ye maaléba téte lé akélak wak, “Naanat Gotna kudiké yakwatnyékwa ban yae dé nyénat wao.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naate waléka lé bari raapme lé Jisasnyét véké yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","32","Mariana mawulé yéknwun yaduké de du taakwa las Jerusalemba taknaba yaak. Yae de lé wale rak gaba. Rate de vék lé raapme kaapat bari gwaadéléka. Gwaadéléka véte de wak, “Lasarasnyét rémdanba géraaké lé gwaadu.” Waga wate de léku kukba raapme yék. Naané Jisas wale gayét kaapuk wekna yaanan. Taale Mata naanat vélén taaléba naané ték. Ténaka Maria ye saabe lé Jisasnyét vék. Vétakne kwati yaane lé dérét wak, “Némaan Ban, kéba raménu mukatik wuna kayé kiyaamarék yakatik dé yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Waga wate géraaléka dé Jisas vék. Jerusalemba yaan du taakwa wawo lé wale yaate géraadaka dé vék. Vétakne mawulé lékdéka dé déku wuraanyan génék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Géndéka dé wak, “Dérét yaba guné rémék?” Naate waatadéka de wak, “Némaan Ban, méné yae méné véké yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Naate wadaka Jisas dé géraak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Géraadéka véte de wak, “Mé vé. Wani duké dé mawulat kapére yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waga wadaka de las wak, “Déknyényba wadéka dé méni kiyaan du tépa vék. Dé Jisas wadu mukatik Lasaras kiyaamarék yakatik dé yak, kapu kaapuk? Samuké dé kaapuk wadén?” Naate de las wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas némaa mawulé lékdéka naané dé wale ye Lasarasnyét taknadan taalé saabak. Déknyényba wani taalé apakélé matuba de waagu vaakére wulaak. Lasaras kiyaadéka de déku gaaba ségwi wani waaguba takne matu nak kérae de yaabuba taknatépétaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas saabe dé wak, “Wani matu mé yatbalaaku.” Naate wadéka lé kiyaan duna nyange Mata kélik yate lé dérét wak, “Némaan Ban, kiyaadén nyaa wan véti wan véti débu yék, kapéredi yaama yaalakwa bege.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naate waléka dé Jisas wak, “Taknaba wuné nyénat wak, ‘Wunéké miték sanévéknwunyénéran Gotna apa jébaa véké nyéné yo.’ Wani kudiké mé sanévéknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Naate wadéka de matu yatbalaakuk. Yadaka Jisas nyérét kwaasawuré véte dé wak, “Wuna yaapa, wuna kudi ménébu véknwuk. Véknwuménéka wuna mawulé yéknwun dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wuné kutdéngék. Apuba apuba wuna kudi méné véknwu. Kéba tékwa du taakwaké sanévéknwute wuné ménat wakweyo. De ménat wakwewurén kudi véknwute waké de yo, ‘Got wadéka dé Jisas giyaak. Wan adél.’ Waga wadoké wuné mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Waga watakne dé némaanba waak, “Lasaras, méné mé raapme yaala.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Waga waadéka dé kiyaan ban tépa nébéle raapme yaalak. Déknyényba baapmu wurét de déku maan taaba mayék. Déku ménidaama wawo baapmu wurét maye taknadaka dé waga kwaak. Kwae nébéle raapme yaaladéka dé Jisas wak, “Baapmu wut mé lépat dé yédu.” Naate wadéka waga yadaka dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariaké yae lé wale ran wupmalemu du taakwa de vék Jisas waga yadéka. Véte kéga de wak, “Got wadéka dé Jisas giyaak. Wan adél.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wadaka las Parisina duké ye de Jisas yan muké wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wakwedaka de nyédé duna némaan du Parisina du wawo waadaka akwi kubu du yaadaka de Jisaské kéga wakwek, “Wani du déknyényba vémarék yanan wupmalemu apa jébaa dé yo. Samu yaké naané yo? ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Naané déku jébaaké dérét waatimarék yanaran dé téte waga male yadu akwi du taakwa déké ‘Naana némaan ban’ naaké de yo. Yado némaan ban rate Romna némaan banna waagu tawudu Romna du kélik yate yae Gotna kudi bulnakwa némaa ga yaalébaante naana du taakwat wawo viyaaké de yo.” Naate de némaan du wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wani kwaaré Kaiapas akwi nyédé duna némaan ban dé rak. Rate wani némaan duna kudi véknwutakne dé derét wak, “Guné las kaapuk kutdénggunén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mé véknwu. Naané wani ban Jisasnyét viyaapéreknaran de Romna du naané Judana du taakwat viyaapérekmarék yaké de yo. Dé kapmu kiyaadéran naané akwi kiyaamarék yaké naané yo. Wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wani kudi wate, déku mawuléba kaapuk sanévéknwudén. Dé wani kwaaré nyédé duna némaan ban radéka Got dérét wadéka dé kudi wakwek, Jisas kiyae Judana du taakwat kutkalé yadéranké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas kiyae Judana du taakwat male kutkalé yamarék yaké dé yo. Gege gayéba rakwa Gotna baadit wawo kutkalé yaké dé yo. Yate kiyae nébéle raapme wadu de akwi nakurak kémba raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiapas waga wadéka de Judana némaan du kudi gik, Jisasnyét viyaapérekgé. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Gidaka Jisas Jerusalemba rakwa duna méniba kaapuk tépa yeyé yeyadén. Yate déku du wale waga naané Jerusalem kulaknyénytakne naané Ipremét yék. Wani gayéba naané rak. Wani gayé du ramarék taalé tékwaba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pasova waanakwa yaa sérakne kanaran tulé yaaké yadéka de Judana du taakwa wupmalemu Jerusalemét yék. Deku apa kudi véknwute yadan kapéredi mu kutnébulké de Jerusalemét yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ye saabe de Jisaské sékalék. Sékalpatiye Gotna kudi buldakwa némaa gaba téte de deku kapmu bulte de wak, “Yaga pulak guné sanévéknwu? Pasova kadému kaké yaaké dé yo, kapu kaapuk?” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Déknyényba nyédé duna némaan du Parisina du wawo kéga de wak, “Jisasnyét kure ye raamény gaba taknaké naané yo.” Waga watakne de wak, “Jisas rakwa taalé du nak kutdéngdéran dé yae naanat wakweké dé yo.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nyaa nak taaba sékét nak taababa kayék nakurak yédu Pasova waanakwa yaa sérakne kanaran tulé yaaké dé yo. Wani tulé naané Jisas wale Betanit yék. Wani gayé wan Lasarasna gayé. Déknyényba wani du kiyaadéka Jisas wadéka dé tépa nébéle raapme rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lasarasna gaba de naana kadému sérakdaka naané Jisas wale wulae rak. Ranaka lé Lasarasna nyange Mata kadému sérakne lé naanéké tiyaak. Tiyaaléka kanaka dé Lasaras naané wale rate kak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Déku nyange nak léku yé Maria lé yéknwun yaama yakwa gu lé las kure rak. Kure re lé Jisasna maanba sévitakne lé léku maaknaba tén sémény nébat yatnyék. Waga yaléka naané gaba ran akwi du taakwa naané yéknwun yaama véknwuk. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisasna du nak déku yé Judas Iskariot dé naané wale wani gaba rak. Kukba wani du Jisasnyét déku maamaké kwayéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Maria waga yaléka véte dé wak, “Samuké lé waga yo? Waga yate sépélak lé yo. Wan yéknwun gu. Lé wani gu kwayétakne wupmalemu (300) yéwaa kérae gwalmu yamarék du taakwaké kwayélu mukatik wan yéknwun paaté.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naate dé wak, sél yakwa du bege. Dé naané Jisasna duna yéwaa kure rate dé las sél yak. Wani yéknwun guké nyégéldéran yéwaa las sél yaké nae dé waga wak. Dé gwalmu yamarék du taakwaké kaapuk sanévéknwudén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dé waga wadéka dé Jisas wak, “Lérét waatikaapuk. Kukba kiyaawuru waaguba rémdaranké sanévéknwute lé waga yak.” Naate wate dé Juda gaaba ségwi rémké yate yanakwaké dé wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wakwetakne dé wak, “Gwalmu yamarék du taakwa guné wale de rasaaku. Apuba apuba guné derét kutkalé yaké guné yo. Wuné guné wale rasaakumarék yaké wuné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jerusalemba rakwa wupmalemu du taakwa de véknwuk Jisas déku du wale Betaniba ranaka. Véknwutakne de dérét véké yaak. Jisasnyét male véké kaapuk yaadan. Lasarasnyét wawo véké de yaak. Lasaras kiyaadéka Jisas wadéka dé tépa nébéle raapdénké de kutdéngék. Waga kutdéngte de dérét véké yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Wani taaléba rakwa du taakwa de kudi véknwuk Lasaraské. Véknwute wupmalemu du de Jisaské miték sanévéknwuk. Sanévéknwute de deku némaan duna kudiké kélik yak. Yadaka de nyédé duna némaan du Lasarasnyét wawo viyaapérekgé de kudi gik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wupmalemu du taakwa de Jerusalemét yék, Pasova waanakwa yaa sérakne kaké. Ye de rak. Re kwae ganba de véknwuk Jisas Jerusalemét yaaké yadéka. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","15","Jisas donki nyaanna butgulba rate dé yék. Jisas waga yate du nak Gotna nyégaba déknyényba kavidén pulak dé yak. Kéga dé kavik: Guné Saionba rakwa du taakwa wup yamarék yaké guné yo. Mé vé. Guna némaan ban kéni dé yao. Donki nyaanna butgulba rate dé yao. Waga dé kavik. Jisas yaaké yadéka véknwute de wupmalemu du taakwa déku yéba kevérékgé nae de yaabuba yéte de tépmaa tu pulak mu tépaknék. Tépakne kure ye yaabuba naanat véte déké dusék takwasék yate de kéga waak, Némaan Ban Got wadék dé yao. Wan yéknwun. Dé wan naané Isrelna némaan ban. Got dérét kutkalé yaké dé yo. Gotna yéba kevérékgé naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Waga waadaka naané Jisasna du wani muké kaapuk miték kutdéngnan. Kukba Jisas Gotna gayét waarédéka naané yadan muké, déknyényba kavidén kudiké wawo naané sanévéknwuk. Sanévéknwute naané kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Déknyényba wupmalemu du taakwa de vék Jisas wadéka Lasaras tépa nébéle raapdéka. Vétakne de kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wakwedaka wupmalemu du taakwa las wawo de wani apa jébaa yadénké de véknwuk. Véknwute de Jisasnyét véké yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yae déku yéba kevérékdaka de Parisina du kélik yak. Kélik yate deku kapmu bulte de wak, “Mé vé. Akwi du béré taakwa béré Jisaské de mawulat kapére yo. Naana kudi kaapuk véknwudakwa.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Judana du taakwa wupmalemu de Pasova waanakwa yaa sérakne kate Gorét waataké de Jerusalemét yék. Nak geba yaan du wawo waga yaké de Jerusalemét yék. De Gérikna du de. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wani du las yae de Jisasna du wale nak bulék. Wani duna yé Pilip. Pilipna néwaage wan Betsaida. Galiliba dé tu. Wani du de Pilipmét wak, “Némaan du, naané ye Jisasnyét véké naané mawulé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Waga wadaka dé Pilip ye dé Andrut wakwedéka bét yék, wani muké Jisasnyét wakweké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ye wakwebétka dé Jisas bérét wak, “Wuné Awi Du Taakwana Nyaan. Got wuna yéba kevérékdéran tulé kéni dé yao. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Kéni adél kudi mé véknwu. Buraamaaku sék képmaaba pukaanaran kukba wani sék wupmalemu buraamaaku sék buréle yaale téké dé yo. Buraamaaku sék képmaaba pukaamarék yanaran dé kapmu téké dé yo. Wunat viyaapérekdaran wunéké miték sanévéknwukwa du taakwa wupmalemu téké de yo. Wunat viyaapérekmarék yadaran, pukaamarék yanan buraamaaku sék pulak wuné kapmu téké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Deku sépéké male sanévéknwukwa du taakwa yalakgé de yo. Kulé mawulé kérae apuba apuba miték rasaakumarék yaké de yo. Deku sépéké sanévéknwumarék yate wuna jébaaké male sanévéknwukwa du taakwa de kulé mawulé kérae apuba apuba miték rasaakuké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Du taakwa wuna jébaa yaké mawulé yadaran de wuna kudi véknwuké de yo. Véknwute de wuné raran taaléba raké de yo. Wuna yaapa wuna jébaa yakwa du taakwana yéba kevérékgé dé yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wani kudi watakne dé tépa wak, “Bulaa wuna wuraanyan dé génu. Kiyaawuréran tulé kéni dé yao. Wuné kiyaamarék yawuréranké wuna yaapa Gorét waatamarék yaké wuné yo. Du taakwat kutkalé yate kiyaaké nae wuné kéni képmaat giyaak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Naate watakne dé Gorét wak, “Wuna yaapa, méné waménu du taakwa de ména yéba kevérékgé de yo.” Naate wadéka dé Gotna gayéba kéni kudi giyaak: “Wuné wawuréka wuna yéba debu kevéréknék. Tépa wawuru kevérékgé de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naate wadéka de waba ran du taakwa véknwute las de wak, “Nyét dé bulu.” Las de wak, “Gotna kudi kure giyaakwa du nak dé Jisas wale kudi bulu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Naate wadaka dé Jisas derét wak, “Gotna gayéba giyaakwa kudi wuné véknwuruké kaapuk wakwedékwa. Guné véknwugunuké dé wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bulaa Got némaan ban rate kéni képmaaba rakwa du taakwa yadan muké wakweké dé yo. Bulaa wadu kéni képmaana némaan ban Seten yaage yéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wunat miba kusawurédo kukba kéni képmaaba rakwa du taakwat wawuru wunéké yaaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Waga wate dé dérét viyaapérekdaranké kudi wakwek. De wani kudi véknwute kutdéngké de yo, dé kiyaadu yadaran muké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jisas waga wadéka de dérét wak, “Naané déknyényba Gotna nyégaba kavidan kudi naanébu vék. Got wadén ban Kraiské kéni kudi de kavik: Dé kiyaamaarék yate apuba apuba rasaakuké dé yo. Kavidan kudi vénaka méné wo, ‘Akwi Du Taakwana Nyaanét miba kusawuréké de yo.’ Samuké méné waga wo? Waga wate kiyadéké méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","De waga wadaka dé Jisas wak, “Nyaa vétik kupuk re yéknwun téwayé tépa yaanmarék yaké dé yo. Bulaa téwayé yaante gaankétéba dé kayénaru. Kayénarédu guné miték véte miték raké guné yo. Miték rate yégunéran yaabu kutdéngké guné yo. Kutdéngte gaankétéba ramarék yaké guné yo. Gaankétéba rakwa du yédaran yaabu kaapuk kutdéngdan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bulaa wani yéknwun téwayé guné wale dé rate yaanu. Bulaa guné wani téwayéké miték sanévéknwuké guné yo. Sanévéknwute guné nyaakaba miték raké guné yo.” Naate dé Jisas aja kudi wakwek. Dé yaankwa yéknwun téwayé pulak yate naanat kutkalé yadékwaké dé wani aja kudi wakwek. Naané wadén tulé déku kudi véknwute déku du taakwa ranoké dé wani aja kudi wakwek. Jisas waga wakwetakne ye dé paakwe rak. Wani du taakwana méniba kaapuk radén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dé déknyényba vémarék yadan wupmalemu apa jébaa yadéka de vék. Véte déké kaapuk miték sanévéknwudan. Yate Got wadéka Jisas giyaadénké kaapuk kutdéngdan. Deku mawulé yékéyaak dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Déknyényba Gotna yéba kudi wakwen du Aisaia dé deké kéga kavik Gotna nyégaba: Némaan Ban, kiyadé wakwenan kudi véknwuk? Méné apa yaménéka kiyadé vék? Waga pulak du nak kaapuk radékwa. Déknyényba Aisaia waga kavidéka wani du taakwa Jisaské miték sanévéknwumarék yadaka déku kudi adél dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Déknyényba Aisaia kéni kudi wawo dé kavik Gotna nyégaba: Got deku méni kuttépéte wadéka deku mawulé débu kapéredi yak. Deku méni kuttépémarék yadu mukatik miték védo. Waga wamarék yadu mukatik déku kudiké kutdéngdo. Waga yado mukatik wuna kudi miték véknwudo wuné derét kutnébulwuru. Waga dé Aisaia Gotna kudi kavik. Du taakwana mawuléké sanévéknwute dé waga kavik. Déknyényba kavidéka kukba de wani du taakwa Jisaské kaapuk miték sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia Jisasna apa vétakne déké wakwete dé wani kudi kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judana némaan du las waga kaapuk yadan. De Jisaské miték sanévéknwuk. Sanévéknwute Parisina duké wup yate, Jisaské miték sanévéknwudakwaké kaapuk kudi wakwedan. Wani kudi wakwedo mukatik Parisina du waatido de Gotna kudi buldakwa gat wulaamarék yado. Parisina du waga waatimuké wup yate de wani kudi kaapuk wakwedan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yate nak du deku yéba kevérékdaranké de sanévéknwuk. Got deku yéba kevérékdéranké kaapuk sanévéknwudan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas némaanba waate dé wak, “Mé véknwu. Guné wuna kudi miték véknwute wuna kudi male kaapuk miték véknwugunékwa. Wunat wadéka giyaawurén ban Gotna kudi wawo guné miték véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wunat véte wuna yaapa Gotké guné kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wuné guna kapéredi mawulé kutnébulké nae wuné kéni képmaat giyaak. Giyae gunéké yéknwun mawulé kwayéte yéknwun téwayé yaankwa pulak wuné ro. Téwayé yaante gaankétéba kayénaréké dé yo. Kayénarédu de gaankétéba ramarék yaké de yo. Guné wuna kudi miték véknwugunéran wuné yéknwun mawulé kwayéwuru miték rasaakuké guné yo. Kapéredi mawulé tépa yamarék yaké guné yo. Waga yate gaankétéba ramarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Wuné némaan ban rate wuna kudi véknwumarék yakwa du taakwaké kéga wakwemarék yaké wuné yo, ‘Wan kapéredi mu yakwa du taakwa.’ Waga wakwemarék yaké wuné yo. Wuné wani jébaa yaké kaapuk kéni képmaat giyaawurén. Wuné kapéredi mawulé kutnébulké nae wuné giyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Sésékukba yaaran nyaa Got némaan ban rate du taakwa yadan muké kudi wakweké dé yo. Wani nyaa wunéké kuk tiyaan du taakwat waatiké dé yo, wuna kudi véknwumarék yadan bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wan yéknwun. Wuna mawuléba sanévéknwute kudi kaapuk wakwewurén. Wuna yaapa wunat wadéka yaawuréka dé wakwewuréran kudi wunat débu wakwek. Wakwedéka wuné gunat wani kudi male wuné wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wakwete wuné kutdéngék. Guné wani kudi miték véknwugunéran kulé mawulé kérae miték rasaakuké guné yo apuba apuba. Waga kutdéngte Got wunat wakwen pulak wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova waanakwa yaa sérakne kanaran nyaa yaaké yadéka dé Jisas kutdéngék. Kiyae kéni képmaa kulaknyénytakne déku yaapaké yédéran tulé kéni dé yao. Kutdéngte dé naané déku du wale rate naanéké sanévéknwu wanévéknwute dé naanéké mawulat kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Garabu Jisas naané déku du wale rate kadému kanaka dé Seten yae dé Judas Iskariotna mawuléba wulaak. Wulae dé dérét wak, Jisasnyét déku maamaké kwayéduké. Judas wan Saimon Iskariotna nyaan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas dé kutdéngék. Déku yaapa akwi du taakwa gwalmu wawo déké kwayétakne wadéka dé giyaak. Giyae déku jébaa yabutitakne déku yaapaké tépa gwaamale yéké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Waga kutdéngte naané rate kadému kanaka dé raapme téte déku yéba kevérékmarék yate jébaa yakwa du pulak yaké nae dé yak. Yate yépmaa yadéka saapme radén baapmu wut putitakne dé gu yatnyédakwa baapmu wut kérae dé nyaaméba gik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Gitakne agérapba gu las wuknae dé naana maan yakutnyék. Yakutnyétakne dé gidén baapmu wurét yatnyék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Waga yakéreye dé Saimon Pita ran saabak. Saabadéka dé Pita dérét wak, “Némaan Ban, samuké méné wuna maan yakutnyu? Méné waga yamuké kélik wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Naate wadéka dé Jisas wak, “Bulaa yawurékwa muké kaapuk kutdéngménén. Kukba wani kutdéngké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Naate wadéka dé Pita wak, “Kaapukna. Wuna maan yakutnyémarék yaké méné yo.” Waga wadéka dé Jisas wak, “Wuné ména maan yakutnyémarék yawuréran méné wuna jébaa tépa yamarék yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Naate wadéka dé Pita Jisasna jébaa yaké mawulat kapére yate dé wak, “Némaan Ban, méné wuna maan, taaba, maakna, akwi yakutnyéké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naate wadéka dé Jisas wak, “Ménébu gu yaakuk. Ména maan male dé képmaa kwao. Wuné ména maan yakutnyéwuru méné miték rate yéknwun yaké méné yo. Bulaa guné akwi yéknwun yo. Guna du nakurak male kapéredi mawulé dé yo. Yate dé yéknwun kaapuk yadékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Naate wate Jisas dé kutdéngék. Déku du nak, Judas, déku maamaké dérét kwayéké dé yo. Waga kutdéngte dé naanat wak, “Guna du nak yéknwun kaapuk yadékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas naana maan yakutnyétakne dé déku baapmu wut tépa kusadatakne dé tépa rate dé naanat wak, “Mé véknwu. Bulaa kudi las wakweké wunék yawurén muké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Guné wunat guné wo, ‘Némaan Ban.’ Waga wagunékwa wan yéknwun. Wuné guna némaan ban. Wan adél. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wuné guna némaan ban rate guna maan wunébu yakutnyék. Waga yate bakna duna jébaa wuné yak. Yate wuna yéba kaapuk kevérékwurén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Guné wawo waga yate nak duna maan yakutnyéké guné yo. Guné végunéka wuné guna némaan ban wani yéknwun jébaa wuné yak gunéké. Guné wuna jébaa yakwa du véte wuné yan pulak yagunuké wuné waga yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jébaa yakwa du némaan ban kaapuk radékwa. Dé némaan ban kélik yadékwa jébaa dé yo. Déké jébaa kwayékwa du dé némaan ban ro. Kudi véknwutakne yén du némaan ban kaapuk radékwa. Dérét kudi wakwen du dé némaan ban ro. Wan adél kudi. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Guné wani kudiké kutdéngte wuné guna némaan ban yawurén pulak yagunéran wan yéknwun. Guna yéba kevérékmarék yate bakna duna jébaa yate nak duwat kutkalé yagunéran guné yéknwun mawulé yate miték raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Guné akwi waga ramarék yaké guné yo. Wuné wawurén wuna duwat akwi wuné kutdéngék. Guna du nak wunat kapéredi mu yaké dé yo. Waga wuné kutdéngék. Déknyényba du nak Gotna nyégaba wani duké kéga dé kavik: Du nak wuné wale rate kadému katakne wunat yaalébaanké dé yo. Kavidén kudi bari adél yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Taale gunat wuné wakweyo. Wakwewurékwa mu kukba yaadu guné véte waké guné yo, ‘Jisas wan némaan ban. Got wadéka dé giyaak. Wan adél.’ Waga wate wunéké miték sanévéknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wawurén du ye wuna kudi wakwedo guné wani kudi miték véknwute derét kutkalé yagunéran guné waga yate wunat wawo guné kutkalé yo. Wuna kudi véknwute wunat kutkalé yagunéran guné wunat wadéka yaawurén banna kudi véknwute dérét wawo guné kutkalé yo. Adél wuné gunat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas waga wadéka déku wuraanyan géndéka dé wak, “Miték mé véknwu. Guna du nak wuna maamaké wunat kwayéké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Naate wadéka naané déku du kaapuk kutdéngnan. Kiyadéké dé Jisas wak? Kutdéngmarék yate naana kapmu bulte naané nak nak naana ménidaamat vék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas wunéké mawulat kapére yadéka wuné dé wale rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Rawuréka dé Saimon Pita maaknat yate dé wunat wak, “Méné Jisasnyét mé waata. Kiyadéké dé wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naate wadéka wuné Jisas wale kusati rate wuné dérét waatak, “Némaan Ban, kiyadéké méné wo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Naate waatawuréka dé Jisas wak, “Kadému kubi guba kusade tawe wani duké kwayéké wuné yo.” Naate watakne walkamu kadému kérae dé kubi guba kusade tawe dé Saimon Iskariotna nyaan Judaské kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yadéka Judas nyégéldéka dé Seten déku mawuléba wulaak. Wulaadéka dé Jisas Judasnyét wak, “Yaké sanévéknwuménékwa mu bari yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naate wadéka naané rate kadému kan du wani muké las kaapuk kutdéngnan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yate las naané naana mawuléba wak, “Judas dé naana yéwaa kure radéka dé Jisas dérét wo, kadému las kéraaduké.” Las naané wak, “Judas naana yéwaa kure radéka dé Jisas dérét wo, yéwaamarék duké las kwayéduké.” Naate wate naané kaapuk miték kutdéngnan, Jisas Judasnyét wakwen kudiké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas Jisas kwayén kadému nyégéle katakne dé naanat kulaknyénytakne dé bari gwaadék. Gaan yadéka dé gwaadék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas raapme gwaadédéka dé Jisas naanat wak, “Wuné Akwi Du Taakwana Nyaan. Bulaa wuna apa véké guné yo. Véte wuna yaapa Got némaan ban radékwaké kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wuna apa véte Gotké kutdénggunu Got bari wadu wuné dé wale rate némaan ban raké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Guné wuna baadi pulak. Gunéké wuné mawulat kapére yo. Wuné guné wale rasaakumarék yaké wuné yo. Wuné bari gunat kulaknyénytakne yéwuru guné wunéké sékalké guné yo. Déknyényba Judana némaan duwat wuné kéga wak, ‘Wuné yéwuréran yaabuba guné yaamarék yaké guné yo.’ Waga wawurén kudi male wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bulaa gunat kulé kudi wakweké wuné yo. Guné kéni kudi miték véknwuké guné yo. Wuné gunéké mawulat kapére yate wuné gunat kutkalé yo. Gunat yawurén pulak, wuna duké akwi mawulat kapére yate waga yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Waga yagunu nak du véte waké de yo, ‘Wani du nak duké mawulat kapére yate de derét kutkalé yo. Waga yate de Jisaské miték sanévéknwute de déku du ro. Wan adél.’ Waga waké de yo gunéké.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jisas waga wadéka dé Saimon Pita wak, “Némaan Ban, nak taalat yéké méné wo. Yaba yéké méné wo?” Naate waatadéka dé Jisas wak, “Wuné yéran taalat méné yaamarék yaké méné yo. Kukba wani méné yaaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naate wadéka dé Pita wak, “Némaan Ban, wuné méné wale yéké wuné yo. Wuné méné wale raké wuné mawulé yo. Waga yawuru wunat viyaapérekdaran wan yéknwun.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Naate wadéka dé Jisas wak, “Méné wunat kutkalé yaké nae kiyaaké méné yo, kapu kaapuk? Wan kaapuk. Wuné kutdéngék. Bulaa gaan méné apu kupuk kéga waké méné yo, ‘Wuné Jisasnyét las kaapuk kutdéngwurén.’ Waga waménu kukba séraa waaké dé yo. Adél wuné ménat wakweyo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas naané déku duwat dé wak, “Guné wuné yéranké sanévéknwute, mawulé lékmarék yaké guné yo. Guné wuna yaapa Gotké mé miték sanévéknwu. Wunéké wawo mé miték sanévéknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Déknyényba gunat wuné wakwek, ‘Wuné ye ragunéran ga miték yaké wuné yo.’ Waga wakwete gunat adél kudi wuné wak. Wuna yaapa rakwa gayé wan némaa gayé. Wupmalemu ga dé waba kwao. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Guné ragunéran ga waba dé kwao. Wuné ye guna ga miték yaké wuné yo. Miték yatakne wuné tépa gwaamale yae gunat kwolawuru wuné wale ye wuné wale raké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wuné yéran yaabu gunébu kutdéngék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Naate wadéka dé Tomas Jisasnyét wak, “Némaan Ban, méné yéménéran gayéké las kaapuk kutdéngnan. Wani gayét yéménéran yaabuké wawo kaapuk kutdéngnan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Naate wadéka dé Jisas wak, “Wuné wani gayét yégunéran yaabu pulak wuné ro. Wuné adél kudi wuné wakweyo. Guné miték rasaakugunuké wuné kulé mawulé kwayu. Guné wuna kudi miték véknwute kwayéwuréran mawulé kéraagunéran wuna yaapana gayét yéké guné yo. Guné wuna kudi miték véknwumarék yagunéran wun yaapana gayét yémarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wunéké kutdénggunu mukatik wuna yaapaké wawo kutdénggunu. Bulaa wunat véte guné déké kutdéngék. Kukba wawo wuna yaapaké kutdéngké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jisas waga wadéka dé Pilip wak, “Némaan Ban, naané naana yaapa Gorét véké naané mawulé yo. Méné naanat dérét wakwatnyéménu naané ménat tépa waatamarék yaké naané yo déké.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Naate wadéka dé Jisas Pilipmét wak, “Méné mé véknwu. Wupmalemu baapmu wuné guné wale wuné rak. Samuké méné wunat kutdéngmarék yo? Wunat vén du wan Gorét wawo debu vék. Samuké méné kéga wo? ‘Naana yaapa Gorét naanat mé wakwatnyé.’ Waga wamarék yaké méné yo. Méné dérét méné vu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wuna yaapa Got wale ané nakurak mawulé ané yo. Wani kudi méné miték véknwu, kapu kaapuk? Gunat wakwewurén akwi kudi wuna mawuléba sanévéknwute kaapuk wakwewurén. Got wuna mawuléba téte déku jébaa yadéka wuné wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Guné guna mawuléba waké guné yo, ‘Jisas déku yaapa Got wale bét nakurak mawulé yo. Wan adél.’ Naate waké guné yo. Waga wamarék yagunéran guné yawurén apa jébaat véte, wunéké miték sanévéknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Kéni kudi mé véknwu. Guné wuna kudi miték véknwukwa du guné wawo wuné yakwa apa jébaa yaké guné yo. Guné yawuréka végunén apa jébaa yagunu guna jébaa wuna jébaat talaknaké dé yo, wuné bari kiyae wuna yaapa Gotké yéwuréran bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wuné gunat kutkalé yawuruké mawulé yate wuna yéba wakwete Gorét waatagunéran wuné mawulé yagunékwa jébaa yaké wuné yo. Waga yawuru akwi du taakwa véte Gotna yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Guné wuna yéba wakwete wunat waatagunéran wuné mawulé yagunékwa pulak yaké wuné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas dé naanat tépa wak, “Guné wunéké mawulat kapére yagunéran guné wuna kudi miték véknwute wawurékwa pulak yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yagunu wuné wuna yaapat waatawuru nak ban yae wuna waagu tawuké dé yo. Tawe gunat kutkalé yate guné wale apuba apuba rasaakuké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wan wawurékwa kudi Gotna Yaamabiké wuné wo. Adél kudi male dé wakweyo. Wuna jébaaba yaalan du taakwa male dérét kutdéngké de yo. Bakna du taakwa dérét véte kutdéngmarék yaké de yo. Yate de déku kudi véknwumarék yaké de yo. Dé guna mawuléba tésaakudu guné dérét kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wuné gunat kulaknyénywuru guné néwepa kiyae kulaknyényén baadi pulak ramarék yaké guné yo. Wuné gunéké gwaamale yaaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taale walkamu re kéni képmaa kulaknyénytakne ye gwaamale yaawuru wuna jébaaba yaalamarék yan du taakwa wunéké sékalpatiké de yo. Yado guné wuna jébaaba yaalan du wunat tépa véké guné yo. Guné kulé mawulé kérae apuba apuba miték rasaakuké guné yo, wuné apuba apuba miték rasaakuwuréran bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gwaamale yaawuréran tulé guné wunéké miték kutdéngké guné yo. Wuné wuna yaapana kudi miték véknwute wuné dé wale ané nakurak mawulé yo. Wuné gunéké yae guna mawuléba téwuru guné wuna kudi véknwute wuné wale nakurak mawulé yaké guné yo. Wuna kudi véknwute wawurékwa pulak yakwa du taakwa wan wunéké de mawulat kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wuna yaapa Got wunéké mawulat kapére yaran du taakwaké dé mawulat kapére yaké dé yo. Wuné wawo wani du taakwaké mawulat kapére yaké wuné yo. Yate téwuru de wunat véte kutdéngké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas waga wadéka dé Judas dérét wak. Wani du wan Judas Iskariot kaapuk. Wan nak Judas. Kéga dé wak, “Némaan Ban, wuné wani kudiké las kaapuk kutdéngwurén. Naané ménat véte kutdéngké naané yo. Waga méné wak. Yaga pulak yaménu de ména jébaaba yaalamarék yan du taakwa ménat vémarék yado naané ménat véké naané yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Naate wadéka dé Jisas dérét wak, “Wunéké mawulat kapére yakwa du taakwa de wuna kudi miték véknwu. Waga yaran du taakwaké wuna yaapa mawulat kapére yaké dé yo. Yadu ané wuna yaapa wale ye wani du taakwana mawuléba wulae téké ané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Deku mawuléba wulae tétu bakna du taakwa anat vémarék yaké de yo. De wunat kélik yate wuna kudi kaapuk véknwudakwa. Wani kudi wuna mawuléba kaapuk sanévéknwute wakwewurékwa. Wuna yaapa wakwedéka véknwute wuné gunat wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bulaa guné wale wekna rate wuné wani kudi wakweyo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kukba kulé ban nak gunéké yaaké dé yo. Wani ban wan Gotna Yaamabi. Wuna yaapa Got wadu dé yae wuna waagu tawe guna mawulat kutkalé yaké dé yo. Dé yae wupmalemu kudi gunat wakweké dé yo. Yae wakwedu guna mawulé yéknwun yadu guné wakwewurén akwi kudiké sanévéknwuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Wuné gunat kulaknyénytakne yéké yate yéknwun mawulé gunéké kwayéké wuné yo. Kwayéwuru guna mawulé miték téké dé yo. Wuna mawulé miték tékwa pulak, guna mawulé miték téké dé yo. Kéni képmaaba rakwa kwatkwa du taakwa deku mawulé waga pulak kaapuk tékwa. De kéni képmaana gwalmuké male de sanévéknwu. De kwayéwuréran mawuléké kaapuk kutdéngdan. Guné wuné yéranké sanévéknwute guné mawulé lékte wup yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gunat kéga wuné wakwek, ‘Wuné gunat kulaknyénytakne ye tépa gwaamale yaaké wuné yo.’ Wuné waga wawuréka wani kudi guné véknwuk. Véknwute wunéké mawulat kapére yagunu mukatik guné yéknwun mawulé yakatik guné yak, wuna yaapaké yéwuréran bege. Wuna yaapa némaan ban dé ro. Dé némaan ban rate dé wunat talaknak. Talaknadéka wuné yu, dérét véké. Wan yéknwun. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bulaa wuné yéranké gunat wunébu wakwek. Kukba wuné yéwuru guné kéga waké guné yo. ‘Jisas yédéranké débu naanat wakwek. Got wadéka dé naanéké giyaak. Wan adél.’ Waga wagunuké wuné wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Gunat wupmalemu kudi las wawo wakwemarék yaké wuné yo. Kéni képmaana némaan ban Seten kéni dé yao. Yae wunéké némaan ban ramarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yadu kéni képmaaba rakwa du taakwa kutdéngké de yo, wuna yaapaké mawulat kapére yawurékwaké. De waga kutdéngdoké wuné mawulé yo. Mawulé yate wuna yaapa wunat wakwen jébaa wuné yo. Yaak. Mé raapme yéno.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas dé naané déku duwat kéga wakwek, “Wuné kubusaaku wain mi pulak wuné tu. Wuna yaapa Got wani miké téségékwa du pulak dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wupmalemu migalé wani miba dé tu. Wuna jébaaba yaalan du taakwa wani migalé pulak de tu. Téte yéknwun jébaa yamarék yakwa du taakwa sék akumarék yakwa migalé pulak tédaka yéknwun jébaa yakwa du taakwa sék akukwa migalé pulak de tu. Miké téségékwa du sék akumarék yakwa migalé véte dé tépaknu. Sék akukwa migalé véte dé saal sénao, dé yéknwun yate wupmalemu sék akuduké. Wani du yadékwa pulak wuna yaapa dé yo. Yéknwun jébaa yamarék yakwa du taakwat dé wo, yédoké. Yéknwun jébaa yakwa du taakwana mawulé dé kutnébulu, deku mawulé yéknwun yadu de wupmalemu yéknwun jébaa yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Dé guna mawulé kutnébuldéka guna mawulé yéknwun débu yak, guné wuna du wakwewurén kudi miték véknwugunén bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Guné wuné wale nakurak mawulé yate raké guné yo. Waga wuné mawulé yo. Migalé tépakdu wani migalé kapmu rate sék las akumarék yaké dé yo. Guné wuné wale nakurak mawulé yamarék yate wani migalé raran pulak kapmu ragunéran yéknwun jébaa yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wuné wani mi apa pulak wuné tu. Téwuréka guné migalé pulak guné tu. Guné wuné wale nakurak mawulé yagunéran guné wupmalemu yéknwun jébaa yaké guné yo. Guné wunat kulaknyénytakne yégunéran guné yéknwun jébaa yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Migalé tépakdo rékaa yaké dé yo. Wuné wale nakurak mawulé yamarék yakwa du rékaa yaran migalé pulak kapéredi ye raké de yo. Kukba wani migalé taatme yaaba tuké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Naate watakne dé Jisas naanat tépa wak, “Guné wuné wale nakurak mawulé yate ragunu wuna kudi guna mawuléba tédéran Gorét waatagunu dé mawulé yagunékwa jébaa akwi yakweké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Guné wupmalemu yéknwun jébaa yagunu wupmalemu du taakwa véte waké de yo, ‘Jisasna jébaa de yo. Déku du de. Wan adél.’ Waga wate wuna yaapana yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wuna yaapa wunéké mawulat kapére yadékwa pulak waga wuné gunéké mawulat kapére yo. Wuné gunéké mawulat kapére yawurékwaké apuba apuba sanévéknwuké guné yo. Guné yékéyaak yamarék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Apuba apuba wuné wuna yaapana kudi véknwuréka dé wunéké mawulat kapére yo. Wunéké mawulat kapére yadékwaké yékéyaak kaapuk yawurékwa. Yawurékwa pulak guné wuna kudi véknwugunéran, wuné gunéké mawulat kapére yawurékwaké yékéyaak yamarék yate guné miték rasaakuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Guné yéknwun mawulé yate dusék yagunuké wuné gunat wani kudi wakweyo. Wuna yéknwun mawulé kérae wuna du rasaakugunuké wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Kéni kudi wakwewuru guné miték véknwuké guné yo. Wuné gunéké mawulat kapére yawurékwa pulak, guné guna du taakwaké waga mawulat kapére yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Guné guna du taakwaké mawulat kapére yate derét kutkalé ye kiyaagunéran wan yéknwun paaté. Deké kiyaagunéran mawulé akwi yéknwun mawulat dé talaknak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Guné wuna kudi véknwugunéran guné mawulat kapére yawurékwa du rasaakuké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bulaa wuné gunat wo: Guné mawulat kapére yawurékwa du guné. Waga wate gunat tépa wamarék yaké wuné yo: Guné wuna jébaa yakwa du. Waga wamarék yaké wuné yo. Jébaa yakwa du deku némaan banna mawulé kaapuk kutdéngdan. Wuna yaapa wakwen akwi kudi véknwutakne wuné guna némaan ban wuné gunat wakwek. Wakwewuréka guné wuna mawulé kutdéngék. Kutdénggunéka bulaa wuné wo: Guné mawulat kapére yawurékwa du guné. Naate wuné gunat wo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Kéni kudi mé véknwu. Guna mawuléba sanévéknwute kaapuk yaagunén, wuné wale jébaa yaké. Wuné wawuréka guné yaak. Yae yéknwun jébaa yagunu wani jébaa kaapuk yamarék yaké dé yo. Guné wani jébaa yate wuna yéba wakwete wuna yaapat waatagunéran waga yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bulaa gunat wuné kéga tépa wakweyo. Guné guna duké mawulat kapére yaké guné yo. Wakwewurékwa kudi miték véknwuké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas wani kudi watakne dé naané déku duwat wak, “Kéni képmaaba rakwa kwatkwa du taakwa gunéké kélik yadaran wan bakna mu. Taale wunéké kélik de yak. Waga guné kutdéngék. Wunéké kélik yate kukba gunéké wawo kélik yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Guné de wale nakurak jébaaba wulaagunu mukatik de gunéké kélik yamarék yado. Guné nak jébaaba gunébu yaalak. Wuné gunat wakwewuréka guné deku jébaa kulaknyénytakne guné wuna jébaaba yaalak. Yaalagunéka de gunéké kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Déknyényba gunat wuné kéga wak, ‘Jébaa yakwa du némaan ban kaapuk radékwa. Déké jébaa kwayékwa du dé némaan ban ro.’ Waga wawurén kudiké mitékne sanévéknwuké guné yo. Guna némaan ban wunat yaalébaandan pulak, gunat yaalébaanké de yo. Wuna kudi véknwudo mukatik guna kudi wawo véknwudo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","De Gotké kaapuk miték kutdéngdan. Got wunat wadéka giyaawurénké kutdéngmarék yate de gunat yaalébaanké de yo, wuna du ragunékwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Wuné yae derét kudi wakwemarék yawuru mukatik, de deku kapéredi mawuléké kutdéngmarék yakatik de yak. Wuné yae derét kudi wakwewuréka yadan kapéredi mawuléké de kutdéngék. Kutdéngte wamarék yaké de yo, ‘Kutdéngmarék yate naané kapéredi mawulé yak.’ Waga wamarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wunéké kélik yakwa du taakwa wan wuna yaapa Gotké wawo de kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Déknyényba du las yae yawurén apa jébaa pulak kaapuk yadan. Wuné yae kapmu wuné wani jébaa yak. Wuné wani jébaa yamarék yawuru mukatik, de kéni képmaaba rakwa kwatkwa du taakwa deku kapéredi mawuléké kutdéngmarék yakatik de yak. Wuné wani jébaa yawuréka de vék. Vétakne deku kapéredi mawuléké kutdéngte de wuna yaapa wale anéké de kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wuné kapéredi mu las yamarék yawuréka de wunéké bakna kélik yadaka Gotna nyégaba kwaakwa kéni kudi nak bulaa adél dé yo. Déknyényba du nak kéga dé kavik: Wunéké bakna de kélik yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kukba kulé banét nak wawuru gunéké yae guna mawulat kutkalé yaké dé yo. Bulaa wuna yaapa Got wale dé ro. Wuné Gorét waatawuru dé wadu yaaké dé yo. Wani ban wan Gotna Yaamabi. Adél kudi male wakwete dé wunéké du taakwat wakweké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Guné wawo wunéké derét wakweké guné yo. Wuné kéni képmaaba rate batnyé jébaa yawuréka guné wuné wale rate vék. Véte guné wuné wale wekna rate wuna jébaa guné vu. Vétakne guné wunéké derét wakweké guné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas wani kudi watakne dé naané déku duwat tépa wak, “Bulaa guné wunéké miték sanévéknwu. Guné wuna kudi kulaknyénymarék yagunuké wuné mawulé yo. Yate wuné gunat wani kudi wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kukba némaan du las wado guné kudi buldakwa ga kulaknyénytakne wani gat tépa wulaamarék yaké guné yo. Yagunu du las waké de yo, ‘Wan kapéredi mu yakwa du. Naané derét viyaapéreknaran naané Gotna jébaa miték yaké naané yo.’ Waga wate de gunat viyaapérekgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wani du wuna yaapa wale anat kaapuk kutdéngdan. Kutdéngmarék yate de gunat yaalébaanké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bulaa gunat wunébu wakwek wani muké. Kukba de gunat yaalébaando guné waké guné yo, ‘Déknyényba Jisas dé naanat kudi wakwek, de naanat yaalébaandaranké. Wakwedén pulak bulaa waga de yo.’ Naate wate wuna kudiké sanévéknwuké guné yo.” Naate dé Jisas wak. Wani kudi watakne dé naanat tépa wak, “Déknyényba guné wale téte wuné gunat wani kudi kaapuk wakwewurén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bulaa gunat kulaknyényké yate wuné gunat wani kudi wakweyo. Walkamu re wunat wadéka giyaawurén banké tépa gwaamale yéké wuné yo. Yéwuréranké guna du nak wunat kaapuk kéga waatadékwa, ‘Yaba méné yu?’ Waga kaapuk waatadékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wakwewurén kudi véknwugunéka bulaa guna mawulé kapéredi dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Bulaa kéni kudi mé véknwu. Wuné yéwuréran wan yéknwun. Wuné yémarék yawuréran guna mawulat Kutkalé Yaran Ban gunéké yaamarék yaké dé yo. Wuné ye wawuru wani ban yaaké dé yo. Yaadéranké sanévéknwugunu guna mawulé kapéredi yamarék yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Wani ban yae dé kéni képmaaba rakwa kwatkwa du taakwat waké dé yo, ‘Guné kapéredi mawulé yate guné kapéredi mu yo. Guné Jisaské miték sanévéknwumarék yate guné kapéredi mawulé yakwa du taakwa guné. Jisas yéknwun jébaa male dé yak. Ye déku yaapaké débu yék. Dérét tépa vémarék yaké guné yo. Déku yaapaké yédéka bulaa guné kutdéngék. Wan yéknwun jébaa yan ban. Waga guné kutdéngék. Got némaan ban rate Setenna jébaaké kudi débu wakwek. Wakwetakne yadén kapéredi mu yakataké dé yo. Yakatadu guné véte kutdéngké guné yo. Got némaan ban rate yanan kapéredi muké wawo kudi wakweké dé yo. Waga kutdéngké guné yo.’ Naate dé guna mawulat Kutkalé Yaran Ban waké dé yo, kéni képmaaba rakwa kwatkwa du taakwat.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dé waga watakne dé naanat wak, “Wuné wupmalemu kudi las wawo gunat wakweké wuné mawulé yo. Mawulé yate bulaa wakwemarék yaké wuné yo, guna mawulé yékéyaak yadéran bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kukba Gotna Yaamabi gunéké yaaké dé yo. Dé adél kudi male dé wakweyo. Yae adél kudi wakwete guna mawulat kutkalé yadu guné akwi adél kudiké kutdégké guné yo. Déku mawuléba sanévéknwute wakwemarék yaké dé yo. Wuné ye wakwewuru dé yae wakwewurén kudi gunat wakweké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wuna kudi véknwe wakwewurén kudi gunat wakwete dé waga yate wuna yéba kevérékgé dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wuna yaapa Gotna mawulé akwi wunébu kutdéngék. Kutdéngte Gotna Yaamabiké wuné wani kudi wakwek. Gotna Yaamabi yae wakwewurén kudi gunat wakwedu guné miték véknwuké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Wani kudi watakne dé Jisas naanat kéga wak, “Walkamu re guné wunat vémarék yaké guné yo. Kukba walkamu re wunat tépa véké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Naate wadéka naané déku du las naana kapmu kéga bulék, “Wan Jisas bulkwa kudi wan yaga pulak kudi? Naané wani kudiké las kaapuk kutdéngnan. Kéga dé wak, ‘Walkamu re guné wunat vémarék yaké guné yo. Kukba walkamu re wunat tépa véké guné yo.’ Naate watakne nak kudi wawo dé wak, ‘Wuné wuna yaapaké yéwuréran bege.’ Jisas samuké sanévéknwute dé waga wak? Wani kudiké naané kaapuk las kutdéngnan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisasnyét wani kudiké las waataké mawulé yanaka dé Jisas naana mawulé kutdéngte dé naanat wak, “Gunat wuné wak, ‘Walkamu re guné wunat vémarék yaké guné yo. Kukba walkamu re wunat tépa véké guné yo.’ Waga wawuréka guné wuna kudiké kutdéngmarék yate, wani kudiké guné guna kapmu kudi bulu, kapu yaga pulak? ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kéni kudi mé miték véknwu. Wuné gunat kulaknyénytakne yéwuru guna mawulé kapéredi yadu géraaké guné yo. Géraagunu de kéni képmaaba rakwa kwatkwa du taakwa dusék takwasék yaké de yo. Taale guné mawulé lékgé guné yo. Kukba guné yéknwun mawulé yate dusék yaké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Taakwa nyaan kéraaké yate taale kaagél lé kuru. Kutte takwasék kaapuk yalékwa. Ye wani nyaan kéraatakne wani kaagélké tépa sanévéknwumarék yaké lé yo. Kéraalén léku nyaanét véte takwasék lé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Guna mawulé wan wani taakwana mawulé pulak. Bulaa guna mawulé kapéredi yadéka guné dusék kaapuk yagunékwa. Kukba wuné gunéké tépa gwaamale yaawuru guné yéknwun mawulé yate dusék yaké guné yo. Yagunu de guna yéknwun mawulé yaalébaanmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Guné yéknwun mawulé yate wani nyaa wunat las waatamarék yaké guné yo. Guné wuna yaapat wuna yéba waatagunu dé véknwutakne mawulé yagunéran jébaa yakweké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Déknyényba Gorét wuna yéba las kaapuk waatagunén. Bulaa waga waatasaakuké guné yo. Waatagunu mawulé yagunéran jébaa yakwedu guné yéknwun mawulé yate duséknét kapére yaké guné yo. Adél wuné gunat wakweyo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas waga watakne dé naanat wak, “Gunat wakwewurén kudi wan aja kudi wuné wakwek. Kukba aja kudi tépa wakwemarék yaké wuné yo. Yate wuna yaapaké wakwewuru déké bari kutdéngké guné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Waga wakwewuru guné wuna yéba wuna yaapat waataké guné yo. Dé gunéké dé mawulat kapére yo. Yadu guné dérét kapmu waataké guné yo, gunat kutkalé yaduké. Wuné dérét waatamarék yaké wuné yo, dé gunat kutkalé yaduké. Guné wunat véte guné wo, ‘Jisas Gorét kulaknyénytakne dé naanéké giyaak. Wan adél.’ Waga wate guné mawulat kapére yo wunéké. Waga yagunéka wuna yaapa gunéké dé mawulat kapére yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Déknyényba wuna yaapat kulaknyénytakne wuné kéni képmaat giyaak. Giyae re kéni képmaa kulaknyénytakne wuna yaapaké gwaamale yéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dé waga wadéka naané wak, “Méné aja kudi wakwemarék yaménéka bulaa naané ména kudi véknwute naané kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Méné akwi mu, akwi jébaa, akwi du taakwaké wawo méné kutdéngék. Deku mawuléké wawo méné kutdéngék. De kulé kudi nak ménat waatamarék yaké de yo, deku kudi akwi kutdéngménén bege. Waga kutdéngte naané ménéké miték sanévéknwu. Méné Got wale re méné giyaak. Wan adél.” Naate naané wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wanaka dé wak, “Bulaa wunéké guné miték sanévéknwu, kapu kaapuk? ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wuné kutdéngék. Naanat yaalébaanké yadaran tulé kéni dé yao. Yaadu guné nak nak yaage yéké guné yo guna gayét. Guné wunat kulaknyénytakne yaage yégunu wuné téké wuné yo. Téwuru wuna yaapa wuné wale téké dé yo. Tédu wuné kapmu témarék yaké wuné yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Guné wuné wale nakurak mawulé yate yéknwun mawulé yate miték ragunuké wuné wani kudi wakwek. Kéni képmaaba rakwa kwatkwa du taakwa gunat yaalébaanké de yo. Yaalébaandaranké sanévéknwute guné wup yamarék yaké guné yo. Wuné némaan ban rawuréka wuna apa deku apat débu talaknak. Talaknadénké guné yéknwun mawulé yaké guné yo.” Naate dé Jisas wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas waga watakne Gotna gayét kwaasawuré véte dé kéga wak, “Wuna yaapa, wuné kiyaawuréran tulé kéni dé yao. Bulaa derét wakweménu de kutdéngké de yo. Wuné ména nyaan némaan ban wuné ro. Waga kutdéngké de yo. Wuné kiyaawuru de méné némaan ban raménékwaké kutdéngké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wunat waménék wuné kéni képmaaba rakwa du taakwaké némaan ban ro. Rate wunéké tiyaaménén akwi du taakwaké kulé mawulé kwayéwuru de miték rasaakuké de yo apuba apuba. Kwayéwuru méné wunéké wakweménu de kutdéngte ména yéba kevérékgé de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","De kulé mawulé kérae kéga kutdéngké de yo. Méné kapmu méné némaan ban Got méné ro. Méné waménéka wuné Jisas Krais wuné yaak. Waga kutdéngké de yo. Kutdéngte miték rasaakuké de yo apuba apuba. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kéni képmaaba rate yawuruké waménén jébaa wunébu yabutik. Yate wuné ména yéba kevéréknék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Déknyényba kéni képmaa bakna tédéka wuné méné wale rate nyaa vékwa pulak wuné rak. Ménéké tépa gwaamale yéwuru waménu wuné nyaa vékwa pulak tépa raké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jisas waga watakne dé wak, “Tiyaaménén duwat kudi wunébu wakwek, ména jébaaké. Déknyényba kéni képmaaba bakna du re de ména jébaaba yaalak. Yaale de ména du radaka derét wunéké tiyaaménéka de ména kudi miték véknwu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Véknwute de tiyaaménén mawuléké wawo kutdéngte wuna jébaa véte de wo, ‘Got wadéka dé Jisas giyaak. Got wadéka Jisas apa yate dé wani jébaa yo. Wan adél.’ Naate de wo, tiyaaménéka wakwewurén kudi véknwudakwa bege. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Bulaa ménat wuné waato wani duké. Kéni képmaaba rakwa kwatkwa duké kaapuk waatawurékwa. Tiyaaménén duwat kutkalé yaménuké wuné ménat waato. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ména du wan wuna du. Wuna du wan ména du. De wuna kudi véknwute wuna jébaa yadaka nak du taakwa véte de wuna yéba kevéréknu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wuna yaapa, méné yéknwun. Ménat wuné waato wani duké. Bulaa kéni képmaaba ramarék yaké wuné yo. Wuné ménéké yaaké wuné yo. De kéni képmaaba raké de yo. Ména apa méné tiyaak wunéké. Bulaa méné apa yate derét kutkalé yaké méné yo. Yaménu de ané nakurak mawulé yatékwa pulak nakurak mawulé yate miték raké de yo. Waga wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ména apa tiyaaménéka wuné de wale rate wuné derét kutkalé yak. Kutkalé yawuréka nak du derét kaapuk yaalébaandan. De miték de rak. Nakurak du male yalakgé dé yo. Yalakdu Gotna nyégaba wani duké kavidan kudi adél yaké dé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Bulaa ménéké yaaké wuné yo. Wuné kéni képmaaba wekna rate wani kudi wuné wakwek, wuna du wup yamarék yate wuna mawulé kérae yéknwun mawulé yadoké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ména kudi derét wakwewuréka de véknwuk. De kéni képmaaba rakwa kwatkwa du pulak kaapuk radakwa. Wuné wawo kwatkwa du pulak kaapuk rawurékwa. Naané de rakwa pulak ramarék yanaka de naanéké kélik yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tiyaaménén duwat kéni képmaaba rado Seten derét yaalénbaanmarék yadu, méné derét kutkalé yaménuké, wuné ménat waato. De kéni képmaa kulaknyénydo méné ména gayét kure yéménuké, kaapuk ménat waatawurékwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","De wuné wale kéni képmaaba rakwa kwatkwa du pulak kaapuk ranakwa. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ména kudi adél kudi. Méné waménu wuna du adél kudi miték véknwute ména du raké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Déknyényba méné waménéka wuné kéni képmaaba rakwa du taakwaké giyaak. Giyae wuné wak, de kéni képmaaba rakwa kwatkwa du taakwaké ye wuna kudi derét wakwedoké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wuné ména kudi véknwute ména jébaa male wuné yo. Wuna du véte ména kudi véknwute ména jébaa male yadoké wuné waga yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Wuna yaapa, wani duké male ménat kaapuk waatawurékwa. Wani du yéte wuna kudi wakweké de yo, nak du taakwat. Wakwedo kudi véknwutakne wunéké miték sanévéknwuran du taakwaké wawo ménat wuné waato. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","De akwi nakurak mawulé yaké de yo. Waga wuné mawulé yo. Méné wuna mawuléba téménéka wuné méné wale nakurak mawulé yo. Yawurékwa pulak, de ané wale nakurak mawulé yaké de yo. Waga yano kéni képmaaba rakwa kwatkwa du taakwa véte waké de yo, ‘Got wadéka dé Jisas giyaak. Wan adél.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wuné jébaa yawuruké apa tiyaaménéka, wuné de jébaa yadoké wani apa kwayék. Ané nakurak mawulé yatékwa pulak, de nakurak mawulé yadoké, wuné deké apa kwayék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Méné wuna mawuléba téménéka wuné deku mawuléba wuné tu. Yatékwa pulak de nakurak mawulé yaké de yo. Yado kéni képmaaba rakwa kwatkwa du taakwa derét véte kutdéngte waké de yo, ‘Got wadéka dé Jisas kéni képmaat giyaak. Got Jisaské mawulat kapére yadékwa pulak, Jisasna du taakwaké wawo dé mawulat kapére yo.’ Naate waké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Wuna yaapa, yéknwun jébaa male méné yo. Tiyaaménén duké wuné ménat waato. De wuné wale ména gayéba radoké wuné mawulé yo. Déknyényba kéni képmaa bakna tédéka méné wunéké mawulat kapére yate waménéka wuné nyaa vékwa pulak rate wuné ména gayéba rak. Nyaa vékwa pulak tépa rawuru de ména gayét yae védoké wuné mawulé yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kéni képmaaba rakwa kwatkwa du taakwa ménéké kaapuk kutdéngdan. Wuné ménat kutdéngwuréka de wuna du wawo ménéké de kutdéngék. Méné waménéka wuné giyaak. Waga wawo de kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Wuné ménéké derét wunébu kudi wakwek. Wakwewuréka de ménéké kutdéngék. Tépa wawo wakwewuru las wawo kutdéngké de yo. Wakwewuru méné wunéké mawulat kapére yaménékwa pulak, de deku duké nak nak mawulat kapére yaké de yo. Yado wuné deku mawuléba téké wuné yo.” Naate dé Jisas Gorét waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas wani kudi watakne naané déku du wale naané Kidron waadakwa kuté atiye naané nak saknwat yék. Yéknwun mi tawudan yaawi dé nak waba tédéka naané Jisas wale wani yaawit wulaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wani apu Jisasnyét maamaké kwayéran du Judas naané wale kaapuk yaadén. Wupmalemu apu déknyényba Jisas naané déku du wale naané wulae rak wani yaawiba. Déknyényba Judas Jisas wale yeyé yeyate dé wani yaawiké dé kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Waga kutdéngtakne dé Romna waariyakwa duwat las, kwabugi duwat las waga kwole de yaak wani taalat. Nyédé duna némaan du las, Parisina du las wawo wani kwabugi duwat wadaka de yaak. Kulaa, tépménéng, téwayé pulak mu wawo de kure yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kure yaadaka dé Jisas kutdéngék dérét yadaran akwi muké. Kutdéngtakne ye dé derét wak, “Kiyadéké guné sékalu?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Naate waatadéka de wak, “Nasaret ban Jisaské naané sékalu.” Naate wadaka dé Jisasnyét maamaké kwayékwa ban Judas dé de wale ték. Tédéka wadaka dé Jisas wak, “Kéni wuné.” Naate wadéka wup yate kuk kuk ye de képmaaba akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Akérédaka dé derét tépa waatak, “Kiyadéké guné sékalu?” Naate waatadéka de wak, “Nasaret ban Jisaské naané sékalu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Naate wadaka dé Jisas derét wak, “Kéni wuné. Waga gunat wunébu wakwek. Wunéké sékalgunéran wuna duwat wagunu de bakna yéké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Waga wadéka wakwedén kudi dé adél yak: “Wunéké tiyaaménén duwat nak kaapuk yaalébaandan.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Du nak déku yé Malkas dé kwabugi du wale ték. Dé wan nyédé duna némaan duké jébaa yakwa du nak. Tédéka dé Saimon Pita waariyadakwa kulaa nak kure te dé wani dut viyaate déku yéknwun tuwa saknwuba tén waan takutépakdéka dé akérék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Akérédéka dé Jisas Pitat wak, “Waga yamarék yaké méné yo. Ména kulaa mé laakwa wutba. Wuné kaagél kutte wuna yaapa tiyaadén jébaa yaké wunébu kusékérék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas waga wadéka de Romna waariyakwa du las, deku némaan ban, Judana kwabugi du las waga de dérét kulékiye de baagwit gik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gitakne de Anaské kure yék. Anas wan Kaiapasna naakuma. Wani kwaaré Kaiapas nyédé duna némaan ban dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Déknyényba Kaiapas dé Judana némaan duwat kéga wak, “Romna du de dut nak viyaado kiyaadéran naané Judana du taakwat kutkalé yaké dé yo. Dé kiyaadéran de Romna du naanat viyaapérekmarék yaké de yo. Wan yéknwun.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","De Jisasnyét kure yédaka ané Saimon Pita wale déku kukba yék. Ye ané nyédé duna némaan banna ga saabak. Wani némaan ban dé wunat kutdéngék. Kutdéngdéka wuné Jisasna kukba ye wuné némaan banna gat wulaak. Wulaawuréka Pita kaapaba dé ték. Tédéka wuné gwaade gwéspétéba tékwa taakwat wak, Pitat wakwelu yaaladuké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wawuréka yaaladéka lé wani taakwa Pitat waatak, “Méné wawo Jisasna du méné?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Naate waataléka dé Pita wak, “Wuné kaapuk.” Naate watakne dé jébaa yakwa du kwabugi du wale waga de ték. Taknaba de jébaa yakwa du kwabugi du wale de yaa séraknék. Yépmaa yadéka de yaa séraknék, deku sépé yaa yaduké. Pita wawo de wale dé ték, déku sépé yaa yaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nyédé duna némaan ban dé Jisasnyét déku duké waatak. Nak duwat wakwedén kudiké wawo dé waatak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Waatadéka dé Jisas wak, “Wuné akwi du taakwana méniba téte wuné derét kudi wakwek. Got wale kudi bulnakwa gaba, kudi bulnakwa némaa gaba wawo téte wuné du taakwat kudi wakwek. Wuné paakwe téte kudi las kaapuk wakwewurén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Samuké méné wunat waato? Wuna kudi véknwun du taakwat waataké méné yo. Wakwewurén kudi de véknwuk. Véknwudanké ménat wakweké de yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wadéka dé kwabugi du nak waba téte Jisasnyét ménidaamaba viyaate dé wak, “Nyédé duna némaan banét waga wamarék yaké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Naate wadéka dé Jisas wak, “Wuné kapéredi kudi wakwewuru mukatik méné wunat wani kudiké wakweménu. Wuné yéknwun kudi wakwewuréka samuké méné wunat viyaak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Naate wadéka Anas wadéka de Jisasnyét kure yék, nyédé duna némaan ban Kaiapaské. Dérét gidan baagwi wekna tédéka de kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita déku sépé yaa yaduké dé yaa rate yaanénba ték. Tédéka véte de wak, “Méné wawo Jisasna du méné. Waga naané sanévéknwu. Méné déku du kapu kaapuk?” Naate waatadaka dé wak, “Wuné kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Waga wadéka dé Pita waan tépaknén duna wayékna véknwuk. Dé wawo jébaa dé yak nyédé duna némaan banké. Véknwutakne dé wak, “Adélna. Taknaba Jisas wale mi tawudan yaawiba tégunéka wuné ménat vék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Naate wadéka dé Pita tépa wak, “Kaapuk.” Naate wadéka dé bari séraa waak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ganbaba Jisasnyét kure Kaiapasnyét kulaknyénytakne de Romna némaan duna gat yék. Yédaka de Judana du wak, “Naana apa kudi kéga dé wo, ‘Naané nak gena duna gat wulaanarn Got naanat waké dé yo, Wan kapéredi mu guné yak. Ye apakélé yaa sérakne wuna kadému kamarék yaké guné yo. Naate waké dé yo.’ Wani kudi véknwute naané wulaamarék yanaran garabu yaa sérakne kadému kaké naané yo.” Waga wate Pasova waanakwa yaa sérakne kadému kaké mawulé yate de Romna némaan duna gat kaapuk wulaadan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yate kaapaba tédaka dé Romna némaan du Pailat deké ye dé derét wak, “Wani duké samu kudi wakweké guné yo?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Naate wadéka de wak, “Kéni du kapéredi mu débu yak. Dé kapéredi mu las yamarék yadu mukatik ménéké kure yaamarék yakatik naané yak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naate wadaka dé Pailat wak, “Guné dérét kure ye guna kapmu bulké guné yo. Bultakne guna apa kudi véknwe guné dérét kotimké guné yo.” Naate wadéka de wani Judana du wak, “Déknyényba guné Rom guné naanat waatik, naané wano de kapéredi mu yan dut kotimtakne dérét viyaapérekmuké. Naané Jisasnyét viyaapéreknaranké waké naané yapatiyu.” Naate de wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Déknyényba Jisas miba kiyaadéranké de kudi wakwek. Wakwete dé Rom viyaapérekgwa muké wakwek. Romna némaan du las wadaka de kapéredi mu yan duwat miba viyaapata taknadaka de kiyaak. Judana du waga kaapuk viyaapérekdan. Wani du Pailarét waga wadaka wani tulé Jisas wakwen kudi dé adél yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wani du waga wadaka dé Pailat tépa gwaamale wulaak gat. Wulae gaba rate dé Jisasnyét waadéka wulaadéka dé dérét waatak, “Méné Judana némaan ban, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Naate waatadéka dé wak, “Méné kapmu sanévéknwute méné waga wo, kapu nak du dé ménat wakwek?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Waga waatadéka dé wak, “Wuné Judana du kaapuk. Wuné ménéké kaapuk kutdéngwurén. Ména gayéna du nyédé duna némaan du wawo de ménat wunéké kure yaak. Samu méné yak?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Naate waatadéka dé wak, “Wuné kéni gayéba némaan ban rawuru mukatik wuna du waariyado nak du wunat kure ye Judana duké kwayémarék yado. Bulaa wuné kéni gayéké némaan ban kaapuk rawurékwa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Naate wadéka dé waatak, “Méné némaan ban méné ro? Wan adél kapu kaapuk?” Naate waatadéka dé wak, “Wan méné kapmu méné wo. Wuné kéga wuné wo. Adél kudi wakweké wuné kéni képmaat giyaak. Adél kudi wakwewuruké lé wuna néwaa wunat kéraak. Adél kudi véknwukwa du taakwa de wuna kudi véknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Naate wadéka dé waatak, “Adél kudi wan samu kudi?” Pailat waga watakne dé Judana duké tépa gwaadék. Gwaade dé derét wak, “Wani du kapéredi mu las kaapuk yadén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Akwi kwaaré Pasova waagunékwa yaa sérakne kagunékwa tulé guné wunat wo, raamény gaba rakwa dut nak wawuru dé yaaladuké. Bulaa Judana némaan banét wawuru dé yaaladuké guné mawulé yo, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Naate waatadéka némaanba waate de wak, “Kaapuk. Déké kélik naané yo. Barabasnyét waménu yaaladuké naané mawulé yo.” Naate de wak. Barabas wan dut viyaate gwalmu sél yan du. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Judana du waga wadaka dé Pailat wadéka Romna waariyakwa du de Jisasnyét viyaak némaa raamény baagwit. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Viyaatakne kéga de wak, “Némaan du de gwaavé baapmu wut kusade yéknwun maakna saap de saaptakno.” Waga wate raamény baagwi kérae de maakna saap pulak séwayékwe de déku maaknaba kusadak. Kusadatakne de gwaavé baapmu wut dérét kusadak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yatakne dérét wasélékte de waagik. Waagite de waatak, “Judana némaan ban, miték méné ro?” Waga wate de dérét taabat viyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yadaka Pailat gwaade dé Judat wak, “Mé vé. Dérét wuné gunéké kure yaalo. Guné véte kutdéngké guné yo. Dé kapéredi mu las kaapuk yadén.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Waga wadéka dé Jisas yaalak. Séwayékudan raamény baagwi dé déku maaknaba kwaak. Kusadadan gwaavé baapmu wut wawo déku sépéba dé ték. Yadéka dé Pailat derét wak, “Kéni dut mé vé.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Naate wadéka dérét véte de nyédé duna némaan du kwabugi du las waga de némaanba waate de wak, “Dérét miba mé viyaapata takna. Dérét miba mé viyaapata takna.” Naate wadaka dé Pailat derét wak, “Kaapuk. Wuné yadén kapéredi muké las kaapuk véknwurén. Guné kapmu dérét kure ye miba viyaapata taknaké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Naate wadéka de Juda dérét wak, “Wani du dé mé kiyao. Dé kéga dé wak, ‘Wuné Gotna nyaan.’ Naate watakne dé naana apa kudi kaapuk véknwudén. Wani kudi kéga dé wo, ‘Du nak waga Gotké kapéredi kudi wakwedéran guné dérét viyaapérekgé guné yo.’ Waga wani apa kudi dé wo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat wani kudi véknwute dé déku mawuléba wak, “Wani du wan Gotna nyaan kapu kaapuk?” Naate sanévéknwute dé wupmét kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wup yate dé gat tépa wulaak. Wulae wadéka Jisas tépa wulaadéka dé dérét waatak, “Méné yaba méné yaak?” Waga waatadéka Jisas las kaapuk buldén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bulmarék yadéka dé Pailat wak, “Yaga pulak ye méné wuné wale bulmarék yo? Wuné mawulé yate wawuréran miték yéké méné yo. Wuné mawulé yate wawuréran de ménat miba viyaapata taknaké de yo. Wuné kéba wuné némaan ban ro. Wani muké las méné kutdéngék, kapu kaapuk?” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Naate wadéka dé Jisas wak, “Got ménéké apa kwayémarék yadu mukatik méné kéba némaan ban ramarék yaménu. Wunat ménéké kwayén ban némaa kapéredi mu dé yak. Dé yadén kapéredi mu méné yaran kapéredi mat dé talaknak.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat wani kudi véknwutakne dé Jisas miték yéduké mawulé yak. Mawulé yate dé Judat wakwek, Jisasnyét wadu dé miték yédéranké. Wakwedéka de waate de wak, “Wani du dé wak, ‘Wuné némaan ban wuné ro.’ Naate wate dé Romna némaan banét talaknaké dé sanévéknwu. Waga sanévéknwute dé Romna némaan banna maama dé ro. Méné dé miték yéduké waménéran méné wawo Romna némaan banna maama raké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat wani kudi véknwutakne Romna némaan banna maama ramuké kélik yate wadéka de Jisasnyét kure yaalak. Yaaladaka dé Pailat kot véknwukwa némaan banna jaabéba rak. Wani jaabéké de wak, Matut yadan jaabé. Yibruna kudiba kéga de wak, Gabata. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wani nyaa Judana du taakwa Pasova waadakwa yaa sérakne kadému kaké de kawu saakérak. Nyaa nawuréké yadéka dé Pailat némaan banna jaabéba rate Judat wak, “Guna némaan banét mé vé.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Naate wadéka némaanba waate de wak, “Déké kélik naané yo. Dérét viyaapérekgé guné yo. Dérét miba viyaapata taknaké guné yo.” Waga wadaka dé Pailat waatak, “Guna némaan banét miba viyaapata taknawuruké guné mawulé yo?” Naate wadéka de nyédé duna némaan du wak, “Dé naana némaan ban kaapuk. Romna némaan ban dé male wan naana némaan ban.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Waga wadaka dé Pailat Judana némaan duna kudi véknwutakne wadéka de Romna waariyakwa du Jisasnyét kure yék, miba viyaapata taknaké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisasnyét kure yédaka dé dérét viyaapata taknadaran mi yaatak. Yaatadéka Judana némaa gayé Jerusalem kulaknyénytakne de Maakna Apa waadakwa taalat yék. Yibruna kudiba kéga de wo, Golgota. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wani taaléba de Romna waariyakwa du Jisasnyét miba viyaapata taknak. Du vétiknét wawo de mi vétikba viyaapata taknak. Naknét de aki tuwa saknwuba viyaapata taknak. Naknét de yéknwun tuwa saknwuba viyaapata taknak. Viyaapata taknadaka dé Jisas nyédéba tén miba ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat kavin kudi de viyaapata taknak, Jisasnyét viyaapata taknadan miba. Kéga dé kavik: Nasaret ban Jisas. Judana némaan ban. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailat wani kudi Yibruna kudiba, Romna kudiba, Gérikna kudiba wawo waga dé kavik. Jisasnyét miba viyaapata taknadan taalé Judana némaa gayé tékwaba dé tu. Tédéka de wupmalemu Juda wani kudi de vék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Vétakne de Judana nyédé duna némaan du de Pailarét wak, “Judana némaan ban. Waga kavimarék yaké méné yo. Kéga méné kaviké yo, ‘Kéni du kéga dé wak, Wuné Judana némaan ban.’ Waga kaviké méné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Naate wadaka dé Pailat wak, “Wuné kavin kudi wan wunébu kavik. Nak kudi tépa kavimarék yaké wuné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Romna waariyakwa du wan véti wan véti de Jisasnyét miba viyaapata taknak. Yatakne déku baapmu wut kérae de deku kapmu munik. Waga yate de nak nak kéraak. Kéraate déku yéknwun baapmu wut kaapuk munidan. Wani baapmu wut déknyényba yaatédaka dé sékétnyé ték. Déknyényba de kaapuk kétaapadan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wani yéknwun baapmu wurét véte de waariyakwa du wak, “Naané kéni baapmu wut gétbiyaamarék yaké naané yo. Makwal matu yatjawuréno waare giyaa akére talaknaran ban wani baapmu wut kéraaké dé yo.” Naate watakne waga yatakne dé nak ban talaknak. Wani ban baapmu wut dé kéraak. Kéraadéka Gotna nyégaba kwaakwa kudi nak adél dé yak. Wani kudi kéga: De makwal matu yatjawurédaka waare giyaa akére derét talaknan ban wuna baapmu wut nak dé kéraak. De wuna baapmu wut las munite nak nak de kéraak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas ténba de Jisasna néwaa Maria, léku wayékna, Klopasna taakwa Maria, Makdalaba yaan taakwa Maria waga de ték. Wani taakwa Jisasnyét miba viyaapata taknadan wale de ték. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tédaka wuné Jisasna du nak kéni nyéga kavin du wuné wawo waba téwuréka dé Jisas déku néwaa wale anat vék. Véte dé déku néwaat wak, “Maria, dé nyéna nyaan pulak raké dé yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Watakne dé wunat wak, “Lé wan ména néwaa pulak.” Waga wadéka wuné lérét kwole kure yék wuna gat. Kure ye wuna néwaat kutkalé yawurén pulak wuné lérét wawo kutkalé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas waga watakne dé kutdéngék. Déku jébaa débu yabutik. Kutdéngte dé wak, “Wunat gutak yadéka wuné.” Naate dé wak. Déknyényba Gotna nyégaba du nak dé kavik, Jisasnyét gutak yaranké. Kavidéka Jisas waga wadéka wani kudi adél dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jisasnyét miba viyaapata taknadanba agérap dé nak rak. Wani agérapba nyégi yakwa wain gu dé las ték. Kusba kwaan nyabiyas pulak mu kérae de wani guba tawuk. Tawe baagéba takne de kusawurék, Jisas jélipme kaduké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kusawurédaka dé wani gu jélipme katakne dé wak, “Wan yaak.” Waga watakne dé waadé daadéka dé déku yaamabi yaale yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Judana némaan du Pasova waanakwa yaa sérakne kadému kaké mawulé yate de kéga wak, “Séré yaap ra nyaa yaa sérakne kadému kaké naané yo. Wani nyaa wan némaa nyaa. Séré deku gaaba ségwi miba témarék yaké dé yo.” Waga wate de Pailarét wak, “Méné waménu guna du miba viyaapata taknadan duna maan mukgé de yo. Mukdo de bari kiyaado de deku gaaba ségwi kure ye rémké de yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Naate wadaka Pailat wadéka de waariyakwa du ye Jisas wale miba viyaapata taknadan du vétik bétku maan de muknék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Muktakne Jisaské ye de vék kiyaasaakwe tédéka. Vétakne déku maan kaapuk mukdan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yadaka dé Romna waariyakwa du nak Jisasna malapaba vit viyaak. Viyaadéka dé wény gu wale bari dé sapurak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sapuradéka wuné kéni nyéga kavin du wuné vék. Véwurén muké wuné gunat kudi wakweyo, guné wawo Jisaské miték sanévéknwugunuké. Wakwewurén kudi wan adél kudi. Waga wuné kutdéngék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Waariyakwa du waga yadaka Gotna nyégaba kwaakwa kudi vétik adél dé yak. Wani kudi nak kéga: Déku apa nak mukmarék yaké de yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nak kudi kéga: Vit viyaadan dut téte véké de yo. Wani tulé wani kudi adél dé yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Romna waariyakwa du waga yadaka dé Arimatia ban Josep ye Pailarét waatak, Jisasna gaaba ségwi lépmwényké. Josep wan Jisasna du nak. Dé Judana nak némaan duké wup yate paakute dé wak, “Jisas wan Gotna nyaan. Wan adél.” Naate wate dé Jisaské miték sanévéknwuk. Josep waatadéka Pailat kusékétdéka dé Josep yék, Jisasna gaaba ségwi lépmwényké. Yédéka dé Nikodimas Josep wale dé yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Déknyényba gaan nak wani du dé Jisaské yék, dé wale kudi bulké. Dé yéknwun yaama yakwa mu vétik kérae nakurakba takne dé kure yék. Wani mu aknét dé kapére yak (30 kilo pulak). ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wani du vétik ye Jisasna gaaba ségwi bét lépmwénye kure giyaak. Kure giyae bét Judana du rémké yanakwa pulak, bét yéknwun yaama yakwa mu gaaba ségwiba takne bét baapmu wurét kusépmék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisasnyét miba viyaapata taknadan taalé wale dé mi tawudan yaawi nak ték. Wani taalé du kiyaadu taknadaran kulé waagu dé nak ték. Déknyényba apakélé matuba de wani waagu vaak. Wani waaguba kiyaan dut nak kaapuk déknyényba taknadan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wani waagu séknaaba kaapuk tén. Yadéka bét Jisasna gaaba ségwi kure ye bét wulae wani waaguba taknak, Juda Pasova waanakwa yaa sérakne kanaran nyaa yaaké yan bege. Wani nyaa naané Juda kiyaan duwat waaguba taknamarék yaké naané yo. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande yé tékgé yadéka lé Makdalaba yaan taakwa Maria raapme lé yék. Jisasna gaaba ségwi taknadan taalat lé yék, gaan wekna tédéka. Ye lé vék wani waaguba taknatépédan matu wani waaguba témarék yadéka. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Vétakne lé Saimon Pita wale tétéka anéké pétépété yaak. Yae lé anat wak, “Naana Némaan Banét debu kure yék. Kérae kure ye taknadan taalé kaapuk kutdéngnan.” Naate lé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ané Pita wale véknwutakne gayé kulaknyénytakne ané Jisasna gaaba ségwi taknadan waagwat pétépété yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ye wuné Pitat talaknatakne wuné taale yék. Taale ye wuné Jisasna gaaba ségwi taknadan waagu saabak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Saabe kwaatabe kwaasawule wuné vék gaaba ségwi kusépdan baapmu wut male radéka. Vétakne kaapuk wulaawurén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita kukba yae dé Jisasnyét taknadan waagwat wulaak. Wulae dé vék gaaba ségwi kusépdan baapmu wut radéka. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jisasna maaknaba gidan baapmu wut wawo radéka dé vék. Wani baapmu wut nak baapmu wut wale kaapuk radén. Dé kapmu dé rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Radéka védéka wuné taknaba taale yaan du wuné wawo wulaak. Wulae wuné wak, “Jisas débu nébéle raapmék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","10","Waga wate Pita wale ané gayét tépa gwaamale yék. Déknyényba de Jisas kiyae tépa nébéle raapdéranké kudi kavik Gotna nyégaba. Wani tulé ané wani kudi kaapuk miték kutdéngtén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria kaapaba téte lé géraak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Géraate kwaatabe lé waagwat kwaasawule lé vék Gotna kudi kure giyaakwa du vétik waama baapmu wut kusade rabétka. Jisasna gaaba ségwi taknadan taaléba bét rak. Nak dé maakna ran taaléba rak. Nak dé maan ran taaléba rak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Rate bét Mariat wak, “Nyéno, samuké nyéné gérao?” Naate waatabétka lé bérét wak, “Wuna Némaan Banét debu kérae kure yék. Kérae kure ye taknadan taalé kaapuk kutdéngwurén.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Waga watakne walaakwe lé vék Jisas tédéka. Véte dérét kaapuk kutdénglén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yaléka dé Jisas lérét wak, “Nyéno, samuké nyéné gérao? Kiyadéké nyéné sékalu?” Waga waatadéka lé Maria léku mawuléba wak, “Wan kéni taaléna bapadu dé, kapu kaapuk?” Naate sanévéknwute lé wak, “Méno, dérét méné kérae kure yék, kapu kaapuk? Waga ye taknaménén taalé wakweménu wuné ye dérét kérae kure yéké wuné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Naate waléka dé Jisas wak, “Maria.” Naate wadéka lé walaakwe dérét kutdéngte lé Yibruna kudiba kéga wak, “Rabonai.” Wani kudi naana kudiba kéga dé wo, “Méné Gotna kudiké yakwatnyékwa ban.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maria waga waléka dé Jisas wak, “Wuna yaapaké kaapuk wekna waaréwurén. Nyéné wunat kutmarék yaké nyéné yo. Nyéné wuna duké ye kéga wakweké nyéné yo, ‘Dé déku yaapa guna yaapa Gotké waaréké dé yo.’ Waga wakweké nyéné yo derét.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Waga wadéka véknwutakne lé Makdalaba yaan taakwa Maria yae lé naané déku duwat wak, “Wuné naana Némaan Banét wunébu vék.” Waga watakne lé Jisas wakwen kudi naanat wakwek. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naané Jisasna du Judana némaan duké wup yate naané ranan gana gwéspété miték tépék. Sande nyaa dawulidéka kukba Jisas yae dé naana nyédéba ték. Téte dé naanat wak, “Guna mawulé miték téké dé yo. Guné wup yamarék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Waga wate dé taaba, malapaba vit viyaadan wawo naanat wakwatnyék. Wakwatnyédéka naana Némaan Banét véte yéknwun mawulé yate naané duséknét kapére yak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yanaka dé Jisas naanat tépa wak, “Guna mawulé miték téké dé yo. Wuna yaapa wadéka déku jébaa yaké wuné yaak. Wadén pulak wuné wawuru wuna jébaa yaké guné yéké guné yo.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","Waga watakne dé déku yaamabi naanat yapévute dé naanat wak, “Guné Gotna Yaamabi nyégélké guné yo. Kapéredi mu yakwa du taakwa yadan kapéredi mu kulaknyénydo guné derét wagunéran, ‘Got yagunén kapéredi mu yatnyéputiké dé yo. Yatnyéputite wani muké tépa sanévéknwumarék yaké dé yo.’ Waga wagunéran Got waga yaké dé yo. Kapéredi mu yakwa du taakwa yadan kapéredi mu kulaknyénymarék yado guné derét wagunéran, ‘Got yagunén kapéredi mu yatnyéputimarék yaké dé yo.’ Waga wagunéran Got yadan kapéredi mu yatnyéputimarék yaké dé yo.” Naate watakne dé Jisas yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas naanéké yaadén tulé déku du nak kaapuk radén. Déku yé Tomas. Déku nak yé Didimas. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Naané dérét wekna véte naané wak, “Naana Némaan Ban Jisas kiyae tépa nébéle raapdéka naanébu vék.” Naate wanaka dé Tomas wak, “Wuné déku taababa raaményét viyaadanba véte, wuna tabasék waba kusolate, déku malapaba viyaadanba wawo wuna tabasék kusolawuru mukatik, guna kudi miték véknwuru. Bulaa guna kudi véknwumarék yaké wuné yo.” Naate dé wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nyaa nak taaba sékét nak taababa kayék kupuk re naané Jisasna du tépa gaba rak. Tomas wawo naané wale dé rak. Akwi gwéspété miték tépétakne ranaka Jisas yae dé naana nyédéba ték. Téte dé wak, “Guna mawulé miték téké dé yo. Guné wup yamarék.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Watakne dé Tomasnyét wak, “Ména tabasék kéba mé kusolate méné wuna taabat véké yo. Ména tabasék kure yae méné wuna malapaba kusolaké yo. Méné deku kudi kaapuk miték véknwuménén. Bulaa méné waké méné yo, ‘Jisas kiyae dé tépa nébéle raapmék. Wan adél.’ Waga wate wunéké mé miték sanévéknwu.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Naate wadéka dé Tomas Jisaské miték sanévéknwute dé wak, “Méné wuna Némaan Ban Got méné.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Naate wadéka dé Jisas wak, “Méné wunat véte méné wunéké miték sanévéknwu. Wunat vémarék yate wunéké miték sanévéknwukwa du taakwa yéknwun mawulé yate miték raké de yo.” Naate dé Jisas Tomasnyét wak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas déknyényba vémarék yanan wupmalemu apa jébaa laswawo naana méniba téte dé yak. Yadén jébaa kéni nyégaba kaapuk akwi kaviwurén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kén kaviwurén kudi véte Jisaské miték sanévéknwugunuké wuné kavik. Guné waké guné yo, “Dé wan naanat kutkalé yaduké Got wadén ban Krais. Dé wan Gotna nyaan. Wan adél.” Guné waga wate déké miték sanévéknwute kwayédéran kulé mawulé kérae apuba apuba miték rasaakugunuké wuné kavik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kukba naané Jisasna du Taibirias waanakwa kwawu tépétba ténaka dé Jisas naanéké tépa yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas, déku nak yé Didimas, Kenaba yaan du Nataniel, Sebedina nyaan vétik ané Jems wale, Jisasna du vétik las wawo waga naané wani kwawu maaléba ték. Natanielna gayé Galiliba dé tu. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita dé naanat wak, “Wuné gukwami wuréké wuné yu.” Naate wadéka naané dérét wak, “Naané wawo méné wale yéké naané yo.” Naate watakne akwi ye naané botba nak waarék. Waare botba ye wani gaan akwi naané jébaa yate gukwami las kaapuk wurénan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nyaa yaalaké yadéka Jisas yae dé kwawu maaléba ték. Tédéka naané déku du botba wekna rate dérét véte naané dérét kaapuk kutdéngnan. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yanaka dé naanat waate dé wak, “Gunawa, gukwami las guné wurék?” Naate waatadéka naané wak, “Kaapuk.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Waga wanaka dé wak, “Guné guna yéknwun tuwa saknwuba laaké yatjade wani gukwami las wuréké guné yo.” Waga wadéka naané laaké yatjadanaka de wupmalemu gukwami laakéba gwaadédaka naané tébére kure yaalaké yapatik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yate wuné Saimon Pitat wak, “Wan naana Némaan Ban dé.” Wawuréka véknwutakne Pita jébaa yaké putidén baapmu wut tépa kusade dé gwat dawulik. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Maalé guba naané ték. Séknaaba kaapuk ténan (100 mita pulak). Dé yédéka naané botba yéte laaké gukwami wale tébére kure yék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Naané ye nébu saabe naané vék yaa nak rate yaandéka. Gukwami, béret waga dé wani yaaba yaanék. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yaandéka dé Jisas naanat wak, “Bulaa wurégunén gukwami las mé kérae kure yaa.” ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Naate wadéka Saimon Pita botba waare dé laaké nak tabéba kérae kure dawuliye dé nébat tébére kure yaak. Wupmalemu (153) apakélé gukwami de laakéba kwaak. Kwaadaka laaké kaapuk périknén. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yadéka dé Jisas naanat wak, “Guné yae guné kaké yo.” Naate wadéka du nak kaapuk kéga waatadén, “Méné kiyadé?” Waga kaapuk waatadén. Naané kutdéngék. Wan naana Némaan Ban. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas yae dé béret gukwami wawo kérae dé naanéké tiyaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas kiyae nébéle raapme apu vétik déknyényba yae dé naané déku duna méniba ték. Wani tulé dé tépa naanéké yaak. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Béret gukwami katakne dé Jisas Saimon Pitat wak, “Jonna nyaan Saimon, mé véknwu. Kéba tékwa du de wunéké mawulat kapére yo. Derét talakne méné wunéké méné mawulat kapére yo, kapu kaapuk?” Naate waatadéka dé Pita wak, “Ao. Némaan Ban, méné kutdéngék. Wuné ménéké wuné mawulat kapére yo.” Naate wadéka dé Jisas wak, “Méné wuna sipsip nyaanké kadému kwayéké méné yo.” Naate wate dé aja kudi wakwek, Pita Jisasna kudi Jisasna du taakwat wakweduké. ");
INSERT INTO abt_maprik_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Waga watakne dé tépa wak, “Jonna nyaan Saimon, wunéké méné mawulat kapére yo, kapu kaapuk?” Naate wadéka dé wak, “Ao. Némaan Ban, méné kutdéngék. Wuné ménéké wuné m