﻿USE sofia;
DROP TABLE IF EXISTS sofia.abp_vpl;
CREATE TABLE abp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES abp_vpl WRITE;
INSERT INTO abp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ha kaunaunaan, pinalhowa nan Apo Namalyadi ye luwang boy babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hiyay babe-luta, homain po kapatonongan boy homain po hinyaman a makit ha babe-luta. Pawa maliteh ye babe nin maalale a lanom. Ket hiyay Ihpiditon Apo Namalyadi, anti ya ha babe nin lanom. ");
INSERT INTO abp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hinabi nan Apo Namalyadi, “Magkamain nin henag!” Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakit nan Apo Namalyadi a hiyay henag, ket manged ya. Ket in-ilbo nay henag ha maliteh. ");
INSERT INTO abp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Hiyay henag, ket hinabtan na yan “kaamotan.” Ket hiyay maliteh, hinabtan na yan “madeglem.” Nalabah ye madeglem, ket naabot ye mahanib. Yati ye unan mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hinabi nan Apo Namalyadi, “Magkamain nin pietan ye lanom ta-omen mapayngihyay ye lanom!” ");
INSERT INTO abp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ket dinyag nan Apo Namalyadi ye pietan, ket in-ilbo nay lanom ha tagay boy lanom ha aypa. Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ket hiyay pietan, hinabtan na yan “luwang.” Nalabah ye madeglem, ket naabot ye mahanib. Yati ye ikalwan mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hinabi nan Apo Namalyadi, “Maytipon ha maghay pahen ye lanom ha aypa nin luwang ta-omen makit ye namal-an a pahen.” Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ket hiyay namal-an a pahen, hinabtan na yan luta. Ket hiyay naytipon a lanom, hinabtan na yan dagat. Nakit nan Apo Namalyadi a hiyay pinalhowa na ket manged ya. ");
INSERT INTO abp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hinabi nayna man Apo Namalyadi, “Tumubo ha luta ye nakahinadi a tatanaman, tanaman boy kakayo a ampanawa nin main but-o. Ket hilayatin kaganaan, manawa hila nin omen ha kalahi lan tanaman.” Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ket tinumubo ya ha luta ye kaganaan a kalahi nin tatanaman, hiyay tanaman boy kakayo a ampanawa nin main but-o. Ket hilayatin kaganaan, nanawa hila nin omen ha kalahi lan tanaman. Nakit nan Apo Namalyadi a hiyay pinalhowa na ket manged ya. ");
INSERT INTO abp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nalabah ye madeglem ket naabot ye mahanib. Yati ye ikatlon mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hinabi nan Apo Namalyadi, “Magkamain nin hehenag ha luwang ta-omen mailbo ye kaamotan boy madeglem. Ket hilayatin hehenag ye pagkakitan nin panaon, mangaamot boy taon. ");
INSERT INTO abp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Hilayatin hehenag ha luwang ye mamahnag ha babe-luta.” Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Pinalhowa nan Apo Namalyadi ye luway mangayadet a hehenag. Hiyay makhaw a henag ye mamahnag nin kaamotan. Ket hiyay makapey a henag ye mamahnag nin madeglem. Pinalhowa na hila met ye bibitoen. ");
INSERT INTO abp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Ket hilayatin hehenag, impuhto-puhto nan Apo Namalyadi ha katatagayan a luwang ta-omen mamahnag ha babe-luta ha kaamotan boy ha madeglem ta-omen mailbo ye mahnag ha maliteh. Nakit nan Apo Namalyadi a hiyay pinalhowa na ket manged ya. ");
INSERT INTO abp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nalabah ye madeglem ket naabot ye mahanib. Yati ye ikaapat a mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hinabi nan Apo Namalyadi, “Magkamain nin nipaydupong-dupong a angkabi-ay ha lanom. Boy magkamain met nin mamanokmanok a anlumpad ha luwang.” ");
INSERT INTO abp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Pinalhowa na hilan Apo Namalyadi ye didigdig a angkabi-ay ha dagat, napaydupong-dupong a angkabi-ay boy ampaggalaw ha lanom, boy kaganaan a kalahi nin mamanokmanok. Nakit nan Apo Namalyadi a hiyay pinalhowa na ket manged ya. ");
INSERT INTO abp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","In-inged na hilan Apo Namalyadi, a wana, “Hikawon angkabi-ay ha lanom, magpakalabong kawo boy patepean yoy dagat. Boy hikawon mamanokmanok, magpakalabong kawo met ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nalabah ye madeglem ket naabot ye mahanib. Yati ye ikaliman mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Hinabi nan Apo Namalyadi, “Magkamain nin kaganaan a kalahi nin aayop, hiyay maamo, mahilib, boy andumakap ha luta.” Ket napalyadibay. ");
INSERT INTO abp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Pinalhowa na hilayatin kaganaan. Nakit nan Apo Namalyadi a hiyay pinalhowa na ket manged ya. ");
INSERT INTO abp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hinabi nan Apo Namalyadi, “Manyag kitawon tao a katuwad tawo. Hilabay ye mamaala nin mamalanghit ha dagat boy mamanokmanok ha luwang boy kaganaan a aayop, hiyay maamo, mahilib, boy andumakap ha luta!” ");
INSERT INTO abp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Pinalhowa nan Apo Namalyadi ye tao a katuwad na. Ket pinalhowa nay laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ket in-inged na hila, a wana, “Magpakalabong kawo boy patepean yoy babe-luta. Ket mamaala kawo ha babe-luta boy kanlan mamalanghit ha dagat, mamanokmanok ha luwang boy kaganaan a aayop a angkumodang ha luta.” ");
INSERT INTO abp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hinabi nan Apo Namalyadi, “Bilewen yo! Nangitaladan akon kanen yon dawa nin kaganaan a tatanaman a ampanawa nin main but-o boy kalahin kakayo a ampanawa nin omen met ateed ha kakayowan la. ");
INSERT INTO abp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ket nangitaladan ako po nin kaganaan a malambot a iilamon a kanen nin kaganaan a mamanokmanok a anlumpad boy aayop a andumakap ha luta.” Ket wanabay ye nalyadi. ");
INSERT INTO abp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nakit nan Apo Namalyadi a hiyay pinalhowa na, ket pawa manganged. Nalabah ye madeglem ket naabot ye mahanib. Yati ye ikaanem a mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ket nayadi ye pamalhowa nan Apo Namalyadi nin luwang boy babe-luta boy kaganaan a anti kanlan hilayati. ");
INSERT INTO abp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Niyadi na ye pamalhowa na ha loob nin anem a mangaamot. Ket ha ikapiton mangaamot, tinumgen yayna. ");
INSERT INTO abp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","In-inged nay ikapiton mangaamot boy induma naya ha kanayon a mangaamot. Ta ha nayadi yan namalhowa nin kaganaan, tinumgen yayna. ");
INSERT INTO abp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Wanabay ye pamalhowa nan Apo Dioh a Namalyadi nin luwang boy babe-luta. Ha pinalhowa na ye babe-luta boy luwang, ");
INSERT INTO abp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","homain po hinyaman a iilamon o tatanaman a tinumubo ha luta, ulita ahe ya po namaudan ye Apo Dioh a Namalyadi boy homain po tao a mag-obda nin bangkag ha hatew. ");
INSERT INTO abp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Noba agya homain po udan, main met huhubol a ampamatepe a ampamaha nin luta. ");
INSERT INTO abp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Haanin, hiyay Apo Dioh a Namalyadi, nangwa ya nin luta, ket dinimeng na yan tao. Ket in-eyep nan Apo Dioh a Namalyadi ha balungoh nan tao ye angeh a ampakaibyay bi-ay, ket nabyayan yan bi-ay. ");
INSERT INTO abp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hiyay Apo Dioh a Namalyadi ket nangitaladan yayna nin pananamanan ha Eden, ha dapit daya. Ket ihtew naya ingkonin ye tao a pinalhowa na. ");
INSERT INTO abp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pinatubo nan Apo Dioh a Namalyadi ha luta ye kaganaan a kalahin kakayo a makapaaliket bilewen boy ampanawa nin malahap a kanen. Ha bunak nin pananamanan, main kayo a ampakaibyay bi-ay, boy main met kayo a ampakaibyay nin tinanda tungkol ha manged boy maloke. ");
INSERT INTO abp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Main kabatowan a ampamalanom nin tatanaman a papalwah ha Eden. Ket ihtew yan naghanga nin apat a dakay. ");
INSERT INTO abp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hiyay ngalan nin unan hanga ket Pishon boy andumawoy ya ha matiboen lugal nin Havilah no way-ihtew main balitok. ");
INSERT INTO abp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Manganged ye kalahi nin balitok ihtew. Main met mangablin pabango ihtew a anhabtan bedilyum, boy mablin kalahi nin dapah a anhabtan oniks. ");
INSERT INTO abp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hiyay ngalan nin ikalwan hanga ket Gihon boy andumawoy ya ha matiboen lugal nin Cush. ");
INSERT INTO abp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hiyay ngalan nin ikatlon hanga ket Tigris boy andumawoy ya ha dapit daya nin Asiria. Ket hiyay ngalan nin ikaapat a hanga nin kabatowan ket Eufrates. ");
INSERT INTO abp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ingkonin nan Apo Dioh a Namalyadi ye tao ha pananamanan ha Eden ta-omen ya mag-obda boy manayhay. ");
INSERT INTO abp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hinabi nan Apo Dioh a Namalyadi kanan laki, “Malyadi mon kanen ye dawa nin hinyaman a kayo ha pananamanan, ");
INSERT INTO abp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","powidan bengat ye dawan kayon ampakaibyay nin tinanda tungkol ha manged boy maloke. Adey moya kanen yain a dawan kayo. Ta no kanen mo, homain hapo a matey ka.” ");
INSERT INTO abp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hinabi nan Apo Dioh a Namalyadi, “Aliwan manged a mambukod ye laki. Idiyagan ko yan kalamo a kahaglap na boy huhton bengat kana.” ");
INSERT INTO abp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ibat ha luta, dinyag naynan Apo Dioh a Namalyadi ye kaganaan a aayop boy mamanokmanok. Ket inlakew na hila kanan laki ta-omen na ipabilew. Ket no hinyay ipangalan na kanla, yabaytew yaynay ngalan la. ");
INSERT INTO abp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ket hiyay laki, pinangalanan na ye kaganaan a aayop a hilay maamo boy mahilib, dayon ha mamanokmanok ha luwang. Noba homain yan nakit ye laki a kahaglap na boy huhto bengat kana. ");
INSERT INTO abp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kaya-bay pinakatuloy na yan maiplek Apo Dioh a Namalyadi ye laki. Ket legan angkatuloy ya, nangoyoh yay Apo Dioh a Namalyadi nin maghay tagyang nan laki. Pangayadi, pinonitan na ye nangoyohan na. ");
INSERT INTO abp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ket hiyay tagyang a inoyoh na kanan laki, dinyag na a babayi. Ket inlakew na yan Apo Dioh a Namalyadi kanan laki. ");
INSERT INTO abp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Hinabi nan laki, “Ah! Main akoynan lamo a huhto kangko! But-o a ibat ha but-o ko boy laman a ibat ha laman ko. Mahabtan yan ‘babayi’, ta ibat ya ha laki.” ");
INSERT INTO abp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yabay-in ye hangkan a lakwanan nin laki ye bapa boy indo na ta-omen yayna makimamagha kanan ahawa na, ket mamagha hilayna. ");
INSERT INTO abp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hiyay laki boy hiyay ahawa na, ket padiho hilan loh-ok hatew, noba ahe hila angkading-ey. ");
INSERT INTO abp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Hiyay bikat ye mapanalingo ha kaganaan a aayop a pinalhowa nan Apo Dioh a Namalyadi. Minghan, nanepet yay bikat kanan babayi, “Peteg nayi a hinabi nan Apo Namalyadi a adi kawo mangan nin dawa nin hinyaman a kakayo ha pananamanan?” ");
INSERT INTO abp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nakibat yay babayi ha bikat, “Malyadi min kanen ye dawa nin hinyaman a kakayo ha pananamanan, ");
INSERT INTO abp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","powidan bengat ye dawa nin kayon anti ha bunak nin pananamanan. Ta hinabi nan Apo Namalyadi a no kanen mi ye dawa na o kimpaan man bengat, ket matey kayi.” ");
INSERT INTO abp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Hinabi nan bikat, “Hi! Aliwan peteg a matey kawo. ");
INSERT INTO abp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Hinabi nan bengat yain Apo Namalyadi, ta tanda na a no kanen yoy dawa nin yain a kayo, ket maboknakan ye ihip yo. Mag-ilyadi kawon omen kana a nagtanda no hinyay manged boy maloke.” ");
INSERT INTO abp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Binilew nan babayi ye dawa nin kayo ket manged ya ha pamilew na boy ba-mon malahap kanen. Boy labay na met ye mag-ilyadin madunong. Kaya-bay namoti ya nin dawa, ket kinan na. Binyanan naya met ye ahawa na a kalamo na, ket kinan na met yati. ");
INSERT INTO abp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pangayadi lan kinan, naboknakan anay ihip la boy natandaan layna met a loh-ok hila. Kaya-bay nangwa hila nin bōng igoh, ket tinayi la yan pamahanip nin laman la. ");
INSERT INTO abp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ha anhuhumilem ana, nange lan miahawa a angkumodang ya ha pananamanan ye Apo Dioh a Namalyadi. Kaya-bay nagtayo hila ha kakayowan ta-omen na hila ahe makitan Apo Dioh a Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Noba iningat na yan Apo Dioh a Namalyadi ye laki boy tinepet naya, “Adan, way-ihtew ka?” ");
INSERT INTO abp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nakibat yay Adan, “Nange koy pangumodang mo ha pananamanan. Ket nalimo ko kamo, ta loh-ok ako. Kaya-bay nagtayo ako.” ");
INSERT INTO abp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tinepet na yan Apo Dioh a Namalyadi, a wana, “Ayay nangihabi kamo a loh-ok ka? Nangan ka nayi nin dawa nin kayon imbawal kon kanen mo?” ");
INSERT INTO abp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“Hiyay babayi a in-ibyay mo kangko, binyan nako nin dawan kayo. Kaya-bay kinan ko met,” wanan laki. ");
INSERT INTO abp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ket tinepet naya met Apo Dioh a Namalyadi ye babayi, “Taket ta dinyag mo yatew?” “Tinalingo na kon bikat. Kaya-bay kinan koy dawa,” wanan babayi. ");
INSERT INTO abp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hinabi nan Apo Dioh a Namalyadi ha bikat, “Uli ha dinyag mo, ihumpa kata. Ha kaganaan a aayop, hikan bengat ye makadiha nin yatin humpa. Legan angkabi-ay ka, dumakap ka, boy towapok ye kanen mo. ");
INSERT INTO abp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Paykapooten ko yay babayi boy hika. Ket hiyay lahi mo boy hiyay lahi na, paykapooten ko hila met. Hiyay lahi na ye mamokpok nin ō mo, ket tokaen moya met ye boe na.” ");
INSERT INTO abp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hinabi na met Apo Dioh a Namalyadi kanan babayi, “Uli ha dinyag mo, pahanan ko ye idap a madihaan mo ha pagbuktot mo, boy mananam kan tubat a ilab ha panganak mo. Noba labay mo yan teed ye ahawa mo, ket hiyabay ye manakop kamo.” ");
INSERT INTO abp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Hinabi na met Apo Dioh a Namalyadi kanan Adan, “Ulita lingnge mo yay ahawa mo, boy kinan mo ye dawan kayon imbawal kon kanen mo, ihumpa ko ye luta. Ket legan angkabi-ay ka, magteeh kan mag-obda ha luta ta-omen ka main mapupol a kanen. ");
INSERT INTO abp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tumubo ha luta ye iilamon boy madiwin tatanaman. Ket hiyay kanen mo, mangibat ya ha tatanaman ha nikabalang. ");
INSERT INTO abp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Panayngetan moy mag-obda ha luta ta-omen main kan pamamangan angga lano miudong ka met ateed ha luta a ibatan mo. Ket ulita ha luta ye ibatan mo, miudong ka met ateed ha luta.” ");
INSERT INTO abp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ket hiyay Adan, pinangalanan na yan Eva ye ahawa na ulita hiyabay ye indo nin kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ket hiyay Apo Dioh a Namalyadi, in-idyagan na yay Adan boy ahawa na nin bado a katat ayop boy pinahootan na hila. ");
INSERT INTO abp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hinabi nan Apo Dioh a Namalyadi, “Hiyay tao, katuwad tawo yayna a nagtanda nin manged boy maloke. Ahe tawoyna paolayan a mamoti ya nin dawan kayon ampakaibyay nin bi-ay, ta no makan na, ket mabi-ay yayna makanoman.” ");
INSERT INTO abp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kaya-bay hiyay Apo Dioh a Namalyadi, pinaalih na yay Adan ha pananamanan nin Eden ta-omen na bangkagen ye luta a ibatan na. ");
INSERT INTO abp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pangayadi na yan pinaalih Apo Dioh a Namalyadi, nangikonin ya nin aanghil a anhabtan kerubim ha dapit daya nin pananamanan nin Eden. Nangikonin ya po nin kampilan a andumlag a ampanliwed ta-omen homain makahaley ha poon-kayon ampakaibyay nin bi-ay. ");
INSERT INTO abp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nilalay na yan Adan ye ahawa na a hiyay Eva, ket binumuktot ya. Nanganak yan laki, ket pinangalanan na yan Cain. Hinabi nan Eva, “Nagkamain ako nin anak a laki uli ha haglap nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Haanin, ha nanganak yayna man ye Eva nin laki, ket pinangalanan na yan Abel. Ha nilumake hilayna, hiyay Abel ket māgpahtol ya nin tutupa boy kakambing, ket hiyay Cain met, mānanaman ya. ");
INSERT INTO abp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Minghan, hiyay Cain, nangihagpa ya kanan Apo Dioh nin dadawan pupol na ha tanaman na. ");
INSERT INTO abp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ket hiyay Abel, nangwa ya nin pawa punganay a tutupa na. Hinapo na hila boy kingwa nay tataba la haka na inhagpa kanan Apo Dioh. Ket kinaaliketan na yan Apo Dioh ye Abel boy hiyay hagpa na, ");
INSERT INTO abp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","noba hiyay Cain boy hiyay hagpa na, ket ingkahwil nan Apo Dioh. Kaya-bay napoot yan tubat ye Cain boy inumahem ye lupa na. ");
INSERT INTO abp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Haanin, tinepet na yan Apo Dioh, “Taket ta angkapoot kan tubat? Taket ta inumahem ye lupa mo? ");
INSERT INTO abp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","No manged ye dinyag mo, kinumaimeng ka dayi. Noba no maloke ye dinyag mo, mag-alla ka. Ta hiyay kahalanan ket ba-mo yan matubag a ayop a lanang ampangiapa kamo ta-omen naka kayaten. Noba katapulan a labanan moya boy hamboten ye kahalanan.” ");
INSERT INTO abp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ha maghay mangaamot, hinabi nan Cain kanan katongno na, “Abel, tayna ha pananamanan!” Nakilakew ya met ye Abel. Ket pamiabot la ihtew, hiyay Cain, dinokloh na yan pinatey ye Abel. ");
INSERT INTO abp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Haanin, tinepet na yan Apo Dioh ye Cain, “Way-ihtew yay Abel a katongno mo?” “Tawan,” wana. “Hiko nayi ye māngalingay nan katongno ko?” ");
INSERT INTO abp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hinabi nan Apo Dioh kana, “Hinyay dinyag mo? Hiyay daya nan katongno mo ha luta, ket angkange ko yan ba-mon ampangha a ampakiiingalon paduhaan ko yay namatey kana. ");
INSERT INTO abp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Haanin met ateed, ihumpa kata. Umalih kayna kananyatin luta a nakaibohbohan nin daya nan katongno mo a pinatey mo. ");
INSERT INTO abp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mananem ka man, homain kan mapupol. Magbalangbalang kayna ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","“Mabyat a tubat ye paduha mo kangko!” wanan Cain kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","“Ampaalihen moko haanin a tumaang ihtin lugal boy ha adapan mo. Magbalangbalang ako ihti ha babe-luta. Ket ayaman a makakit kangko, ket homain hapo a pateyen lako,” wanan Cain. ");
INSERT INTO abp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Noba hinabi nan Apo Dioh kana, “Ahe! Ta ayaman a mamatey kamo, ket baeen ko yan piton ukdo.” Kaya-bay minalkaan na yan Apo Dioh ye Cain nin pagkakitan ta-omen laya ahe pateyen nin ayaman a makakit kana. ");
INSERT INTO abp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ket inumalih yaynay Cain ha adapan nan Apo Dioh. Ket kinumonin ya ha lugal nin Nod, maghay lugal ha dapit daya nin Eden. ");
INSERT INTO abp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nilalay na yan Cain ye ahawa na ket binumuktot ya. Nanganak yan maghay laki, ket pinangalanan na yan Enoc. Kananyatew a panaon, ampangipaideng yay Cain nin maghay banwa. Ket pinangalanan na yan Enoc a kangalan met ateed nin anak na. ");
INSERT INTO abp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hiyay Enoc ye bapa nan Irad a bapa nan Mahujael. Hiyay Mahujael ye bapa nan Metusael a bapa nan Lamec. ");
INSERT INTO abp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Hiyay Lamec ket luway ahawa na, hilan Ada boy Zilla. ");
INSERT INTO abp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Hiyay Ada, nanganak yan laki, ket pinangalanan yan Jabal. Hiyabay ye nangibatan lan tataon angkumonin ha hongab boy māgpahtol nin aayop. ");
INSERT INTO abp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Main yan katongno a laki ye Jabal. Hiyay ngalan na ket Jubal. Hiyabay met ye nangibatan lan mānugtog nin gitada boy patutot. ");
INSERT INTO abp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Hiyay Zilla, nanganak ya met nin laki, ket pinangalanan yan Tubal Cain. Hiyay Tubal Cain ye māmanday nin kahangkapan a tanho boy bakal. Main yan katongno a babayi ye Tubal Cain, hiyay ngalan na ket Naama. ");
INSERT INTO abp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ha maghay mangaamot, hinabi nan Lamec kanlan luway aahawa na, “Ada boy Zilla a aahawa ko, leng-en yoy habiyen ko. Main akon pinatey a maghay bayontao. Pinatey koya ta pinahakitan nako. ");
INSERT INTO abp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","No piton ukdo yan mabae ye mamatey kanan Cain, pitompo boy piton ukdo ya met mabae ye mamatey kangko.” ");
INSERT INTO abp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nilalay na yayna man Adan ye Eva a ahawa na, ket nanganak yayna man nin maghay laki. Hinabi nan Eva, “Binyan na kon Apo Namalyadi nin kahagili nan Abel a pinatey nan Cain.” Ket pinangalanan na yan Set. ");
INSERT INTO abp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Hiyay Set, nagkaanak yan laki, ket pinangalanan na yan Enosh. Kananyatew a panaon ye pandugi nin tao a manggalang kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yati ye nakahulat a panongtongen nin lalahi nan Adan. Ha pinalhowa nan Apo Namalyadi ye tao, dinyag na yan katuwad na. ");
INSERT INTO abp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Laki boy babayi ye pinalhowa na. Ket in-inged na hila boy hinabtan na hilan tao. ");
INSERT INTO abp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Hiyay Adan ket 130 anay taon na ha nagkaanak yan katuwad na. Ket pinangalanan na yan Set. ");
INSERT INTO abp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ha naianak yaynay Set, nabi-ay ya po ye Adan nin 800 a taon boy nagkaanak ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","930 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hiyay Set ket 105 anay taon na ha nagkamain yan anak a hiyay Enosh. ");
INSERT INTO abp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ha naianak yaynay Enosh, nabi-ay ya po ye Set nin 807 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","912 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Hiyay Enosh ket 90 anay taon na ha nagkamain yan anak a hiyay Kenan. ");
INSERT INTO abp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ha naianak yaynay Kenan, nabi-ay ya po ye Enosh nin 815 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","905 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Hiyay Kenan ket 70 anay taon ha nagkamain yan anak a hiyay Mahalalel. ");
INSERT INTO abp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ha naianak yaynay Mahalalel, nabi-ay ya po ye Kenan nin 840 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","910 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Hiyay Mahalalel ket 65 anay taon na ha nagkamain yan anak a hiyay Jared. ");
INSERT INTO abp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ha naianak yaynay Jared, nabi-ay ya po ye Mahalalel nin 830 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","895 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hiyay Jared ket 162 anay taon na ha nagkamain yan anak a hiyay Enoc. ");
INSERT INTO abp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ha naianak yaynay Enoc, nabi-ay ya po ye Jared nin 800 a taon ket nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","962 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hiyay Enoc 65 anay taon na ha nagkamain yan anak a hiyay Matusela. ");
INSERT INTO abp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ha naianak yaynay Matusela, nabi-ay ya po ye Enoc nin 300 a taon a kalamo na yay Apo Namalyadi, ket nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Naabot na po ye 365 a taon. ");
INSERT INTO abp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hiyay Enoc ket nagbi-ay yan mapatayaan kanan Apo Namalyadi. Pangayadi ket naplak ya, ulita kingwa na yan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Hiyay Matusela ket 187 anay taon na ha nagkamain yan anak a hiyay Lamec. ");
INSERT INTO abp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ha naianak yaynay Lamec, nabi-ay ya po ye Matusela nin 782 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","969 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hiyay Lamec ket 182 anay taon na ha nagkamain yan anak a laki. ");
INSERT INTO abp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Hinabi na, “Yatin anak ko ye mamaimonaw kantawon ibat ha kaidapan, uli ha pangihumpa nan Apo Dioh ha luta.” Kaya-bay pinangalanan na yan Noe ye anak na. ");
INSERT INTO abp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ha naianak yaynay Noe, nabi-ay ya po ye Lamec nin 595 a taon boy nagkamain ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","777 a taon nayna ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Hiyay Noe ket 500 a taon nayna ha nagkamain yan aanak a hiyay Shem, Ham, boy Jafet. ");
INSERT INTO abp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Haanin, anlumabong hilaynay tatao ha babe-luta boy main hilan aanak a babayi. ");
INSERT INTO abp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ha nakit lan lalakin aanak nan Apo Namalyadi a mangaada hilay babayin aanak nin tatao, namili hila kanla nin mapag-ahawa la. ");
INSERT INTO abp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Hinabi nan Apo Dioh, “Adi ko ipaluboh a mikakaanti kanlan tatao makanoman ye angeh ko a ampakaibyay bi-ay, ulita main kamateyan ye laman nin tao. Kaya-bay paibat haanin, ahe naynan labhan ye magatoh boy luwampo a taon ye bi-ay nin tao.” ");
INSERT INTO abp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kananyatew a panaon boy pangayadi nin yatew a panaon, hilay mangayadet a tatao ket aanak hilan babayin aanak nin tatao a inahawa lan lalakin aanak nan Apo Namalyadi. Hilayatin mangayadet a tatao ye mangagaling a makilaban boy ambigbigen nin tatao ha kapanaonan la. ");
INSERT INTO abp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nakit nan Apo Dioh a tubat anay kalok-an nin tatao ha babe-luta, boy pawa maloke ye an-ihipen la. ");
INSERT INTO abp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kaya-bay hiyay Apo Dioh, ampaghehean nan tubat ye pamalhowa na nin tao ha babe-luta boy ingkalele na. ");
INSERT INTO abp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hinabi na, “Hipeten ko ye kaganaan a tataon pinalhowa ko dayon kaganaan a aayop a angkumodang ha luta boy mamanokmanok ha luwang, ta ampaghehean koy pamalhowa ko kanla.” ");
INSERT INTO abp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noba hiyay Noe ye ampakapaaliket kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Yati ye ihtolya tungkol ha pamilya nan Noe. Hiyay Noe, ket matoynong ya, homain yan pakaidlawan kanlan tatao ha kapanaonan na boy manged ye pamakilamo na kanan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Hiyay Noe ket main yan tatloy aanak a laki, hilan Shem, Ham, boy Jafet. ");
INSERT INTO abp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hilay kanayon a tatao ket tubat anay kalok-an la ha pamilew nan Apo Namalyadi boy nitayak anay kahamaan ha kaganaan a lugal. ");
INSERT INTO abp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakit nan Apo Namalyadi a tubat anay kalok-an ha kaganaan a lulugal ihti ha babe-luta. Ta lanang hilan ampanyag nin maloke ye kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kaya-bay hinabi nan Apo Namalyadi kanan Noe, “Hipeten koynay kaganaan a tatao ha babe-luta. Ta uli kanla, nitayak ye kahamaan ha kaganaan a lugal. Kaya-bay hipeten ko hilayna boy damaen koynay babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Manyag ka nin mayadet a daong a kayon sipres boy main hihilid. Ket polanitan moya nin pamayket ye loob boy ilwah nin daong. ");
INSERT INTO abp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hiyay daong, diyagen mo yan 135 a mitodo ye kakadang na, 22 a mitodo ye kawayan na boy 13 a mitodo ye katagay na. ");
INSERT INTO abp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atepan moya yati, noba mangipatla ka nin kagitna mitodo a pietan ha tampoh nin lingling boy atep. Diyagen mon 3 palapag ye daong boy manyag kan ilwangan a main leneb ha tagililan nin daong. ");
INSERT INTO abp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tanepen koy babe-luta ta-omen mahipet ye kaganaan a angkabi-ay ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Noba habiyen ko kamo ye kahundoan ta. Lumoob ka ha daong dayon ahawa mo, hilay aanak mon laki dayon ahawa nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mangiloob ka met ha daong nin maghay padih nin balang kalahin ayop ta-omen magpahulong ye lahi la. ");
INSERT INTO abp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Makew hila kamo ye timaghay padih nin balang kalahin mamanokmanok boy ayop a angkumodang ha luta ta-omen ahe mahipet ye lahi la. ");
INSERT INTO abp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mangiloob ka nin kaganaan a kalahi nin pamangan yo boy pamangan nin balang aayop.” ");
INSERT INTO abp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ket dinyag nan Noe ye kaganaan a imbilin nan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hinabi nan Apo Dioh kanan Noe, “Lumoob kawoynan mitapamilya ha daong, ta ha kaganaan a tatao kananyatin panaon, ket hikan bengat ye nakit kon ampagbi-ay a matoynong. ");
INSERT INTO abp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mangilamo ka nin pitoy padih nin balang kalahi nin ayop a naibilang a malinih, boy maghay padih met nin naibilang a madinat. ");
INSERT INTO abp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mangilamo ka met nin pitoy padih nin balang kalahi nin mamanokmanok. Diyagen mo yati ta-omen magpahulong ye lahi la. ");
INSERT INTO abp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pangalabah nin pitoy mangaamot, udanen koyna ye babe-luta ha loob nin apatapo a mangaamot boy madeglem. Ket hipeten ko ye kaganaan a pinalhowa ko ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ket dinyag nan Noe ye kaganaan a imbilin nan Apo Dioh kana. ");
INSERT INTO abp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Hiyay Noe ket 600 anay taon na ha nandogin matanep ye babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ket nilumoob ya ha daong a lamo na yay ahawa na, hilay aanak na a laki dayon mamanuyang na ta-omen hila maligtah ha tanep. ");
INSERT INTO abp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ket balang kalahi nin aayop, naibilang man a malinih o ahe, boy balang kalahi nin mamanokmanok boy aayop a andumakap ha luta, ");
INSERT INTO abp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ket nakew hilan mipapadih kanan Noe ha loob nin daong a omen ha imbilin nan Apo Namalyadi kana. ");
INSERT INTO abp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pangalabah nin pitoy mangaamot, ket dogiyan naynan tanepen ye babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Hiyay Noe ket 600 anay taon na hatew. Ha ika-17 mangaamot nin ikalwan bowan, hinumopwak ye kaganaan a hubol ha lale luta. Ket paibat ha langit, ampibohboh ye lanom ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ket pangudan-udan nayna ha babe-luta ha loob nin 40 a mangaamot boy madeglem. ");
INSERT INTO abp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ket kananyatew met ateed a mangaamot a mangudan, nilumoob hilayna ha daong ye miahawan Noe, lamo la hilay tatlon aanak na a laki, hiyay Shem boy Ham boy Jafet dayon ahawa nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kalamo la ye kaganaan kalahin aayop, mahilib man o maamo, angkumodang man o andumakap, boy balang kalahi nin mamanokmanok. ");
INSERT INTO abp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Maghay padih ha balang angkabi-ay ye nakew kanan Noe ha daong, ");
INSERT INTO abp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","a omen ha imbilin nan Apo Namalyadi. Ha nakaloob hilaynan kaganaan, hiyay Apo Dioh, inleneb nayna ye ilwangan nin daong. ");
INSERT INTO abp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","40 a mangaamot a pangudan-udan na ha babe-luta. Inumalale ye lanom ket nilumpaw yayna met ye daong. ");
INSERT INTO abp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lalo a inumalale ye lanom boy pahulong met ye panlumpaw nin daong ha tanep. ");
INSERT INTO abp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pahulong yan an-umalale ye lanom angga ha nalipoh hilaynay mangatagay a matundol. ");
INSERT INTO abp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Pahulong yan an-umalale ket inumigit ya po ye lanom nin manga pitoy mitodo ha babe nin pinakamatagay a matundol. ");
INSERT INTO abp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nahipet ye kaganaan angkabi-ay ha babe-luta, hilay mamanokmanok, aayop a maamo man o mahilib, kaganaan a andumakap boy kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nangamatey ye kaganaan angkabi-ay ha luta. ");
INSERT INTO abp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ket nahipet hilay kaganaan a tatao, aayop, aayop a andumakap boy mamanokmanok ha luwang. Hiyay Noe boy hilay kalamo nan bengat ha loob nin daong ye napatla. ");
INSERT INTO abp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ket ha loob nin 150 a mangaamot, maalale ya po ateed ye lanom. ");
INSERT INTO abp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Angkaihipan na yan Apo Namalyadi ye Noe boy hilay kaganaan a aayop a maamo boy mahilib a kalamo na ha loob nin daong. Kaya-bay pinaangin na ha babe-luta, ket nandugi yaynan umyak ye lanom. ");
INSERT INTO abp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pinatgen nay panupwak nin huhubol ha lale luta boy tinumgen ana met ye udan. ");
INSERT INTO abp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pahulong yan an-umyak ye lanom. Ket pangalabah nin magatoh boy limampo a mangaamot, maaypa yayna ye lanom. ");
INSERT INTO abp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ha ika-17 mangaamot nin ika-7 bowan, nipatanghad yay daong ha mapantay nin Ararat. ");
INSERT INTO abp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pahulong ye panumyak nin lanom. Ket ha unan mangaamot nin ika-10 a bowan, makit yaynay pituktokan nin mamapantay. ");
INSERT INTO abp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pangalabah nin 40 a mangaamot, inlukat nan Noe ye panamulawan ha daong. ");
INSERT INTO abp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ket nangibuhan yay Noe nin maghay uwak. Paudong-udong nan panlulumpad ye uwak angga ha naagad na a namal-an yay luta. ");
INSERT INTO abp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Haanin, nangibuhan ya met nin maghay kalapati ta-omen na bilewen no inumyak anay lanom. ");
INSERT INTO abp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Noba homain yan maaponan ye kalapati ta pawa po lanom ye angkakit na. Kaya-bay nag-udong ya met ateed. Impanat nan Noe ye gamet na, ket inumapon yay kalapati ha gamet na, ket inloob naya ha daong. ");
INSERT INTO abp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Namalabah yay Noe nin pitoy mangaamot, ket nangibuhan yayna man nin kalapati. ");
INSERT INTO abp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Madeglem yaynan nakaudong ye kalapati boy main yan kaget a mabuyong a bōng nin olibo. Kaya-bay nahigudo naynan Noe a inumyak yaynay lanom. ");
INSERT INTO abp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Namalabah ya po nin pitoy mangaamot ye Noe, ket nangibuhan yayna man nin kalapati. Noba ahe yayna nag-udong. ");
INSERT INTO abp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ha 601 anay taon nan Noe, ha unan mangaamot nin unan bowan, nilukatan nan Noe ye bobongan nin daong, ket nakit na a namal-an yaynay luta. ");
INSERT INTO abp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ha ika-27 mangaamot nin ikalwan bowan, mamala yaynay luta. ");
INSERT INTO abp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ket hinabi nan Apo Namalyadi kanan Noe, ");
INSERT INTO abp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lumwah kawoyna ha daong, hika boy hiyay ahawa mo boy hilay aanak mon lalaki dayon ahawa nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ibohan mo hilayna met ye kaganaan a mamanokmanok boy aayop a kalamo mo, hilay maamo man o mahilib, hilay kaganaan a angkumodang ha luta ta-omen hila lumabong boy patepean lay babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ket nilumwah hilaynan Noe boy hiyay ahawa na, hilay aanak na dayon ahawa nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nilumwah hilayna met ha daong ye kaganaan a aayop, hilay andumakap o angkumodang ha luta, dayon mamanokmanok. Nilumwah hilan kalamo lay lahi la. ");
INSERT INTO abp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hiyay Noe, nanyag yan pangihagpaan, ket nangwa yan magha ha balang kalahin naibilang a malinih a ayop boy mamanokmanok. Ket pinatey na hilan inulam ha pangihagpaan bilang hagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ha nadaep nan Apo Dioh ye mabango a bawo nin hagpa a angkaulam, hinabi na ha hadili na, “Ahe koyna ihumpa uman ye babe-luta uli ha didiyag lan tatao agya tanda kon maloke ye an-ihipen la paibat ha kaanak-anakan la. Ahe koyna hipeten uman ye kaganaan a angkabi-ay a omen ha dinyag ko. ");
INSERT INTO abp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Legan anti ye babe-luta, homain tegen ye panaon nin pananem boy pamupol, kaingitan boy kaudanan, pangalay-ep boy amot, kaamotan boy madeglem.” ");
INSERT INTO abp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","In-inged na yan Apo Namalyadi ye Noe boy hilay aanak na. Hinabi na, “Magpakalabong kawo boy patepean yoy babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kalimowan la kawon kaganaan a aayop, hilay angkumodang, andumakap, anlumpad boy kaganaan a mamalanghit ha dagat. Ipabaala ko hilan kaganaan kanyo. ");
INSERT INTO abp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hilay kaganaan a angkabi-ay boy angkumodang, an-ibyay ko hila kanyo a kena yo. Hatew, in-ibyay ko kanyo ye malambot a tatanaman a kanen yo. Noba haanin, an-ibyay ko hilayna kanyo ye kaganaan a kena yo. ");
INSERT INTO abp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Noba adi yo kena ye ayop a ahe napalwah ye daya na, ulita hiyay daya ye bi-ay. ");
INSERT INTO abp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ket hiyay tungkol ha daya nin tao, makibat ya kangko ye ayaman a tao a mamatey nin kapadiho nan tao. Wanabay met ha ayop a makapatey nin tao, makibat ya kangko ye agya hinyaman a mamatey nin tao.” ");
INSERT INTO abp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ayaman a mamatey nin kapadiho nan tao, ket pateyen ya met nin kapadiho nan tao, ta pinalhowa nan Apo Namalyadi ye tao a katuwad na. ");
INSERT INTO abp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Noba Noe, magpakalabong kawo boy patepean yoy babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hinabi nan Apo Namalyadi kanan Noe boy kanlan aanak na, ");
INSERT INTO abp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Yati ye kahundoan ko kanyo boy kanlan lalahi yo, ");
INSERT INTO abp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","boy kanlan kaganaan a angkabi-ay a ayop a kalamo yon nilumwah ha daong a hilay mamanokmanok boy aayop, maamo man o mahilib. ");
INSERT INTO abp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yati ye kahundoan ko kanyo. An-ipangako ko a adi koyna tanepen uman ye kaganaan a angkabi-ay ha babe-luta boy adi koyna tanepen ye babe-luta ta-omen damaen.” ");
INSERT INTO abp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Hinabi na po Apo Namalyadi, “Yati ye pagkakitan nin homain anggaan a kahundoan ko kanyo boy ha kaganaan a angkabi-ay a aayop a kalamo yo. ");
INSERT INTO abp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mangipakit akon buwakaw ha owep. Ket yatin buwakaw ye pagkakitan nin kahundoan ko ha kaganaan a angkabi-ay ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tepe diyagen ko yan maowep ye luwang boy makit ye buwakaw ha owep, ");
INSERT INTO abp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","maihipan koy kahundoan ko kanyo boy ha kaganaan a aayop a agkoynan tanepen uman ye babe-luta ta-omen damaen ye kaganaan a angkabi-ay. ");
INSERT INTO abp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tepe makit ye buwakaw ha owep, ket maihipan koy homain anggaan a kahundoan ko ha kaganaan a angkabi-ay ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kaya-bay hinabi nan Apo Namalyadi kanan Noe, “Hiyay buwakaw ye pagkakitan nin kahundoan ko ha kaganaan a angkabi-ay ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Hilayati ye aanak nan Noe a kalamo na ha daong, hiyay Shem, Ham boy Jafet. (Hiyay Ham ye bapa nan Canaan.) ");
INSERT INTO abp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hilayatin tatlon lalakin aanak nan Noe ye nangibatan nin kaganaan a tatao a nangaitayak ihti ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hiyay Noe ket māgtalon ya boy hiyabay ye unan nananem nin obah. ");
INSERT INTO abp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ha maghay mangaamot, hiyay Noe ket ninom yan alak ubah ket nalahing ya. Nipakatuloy yan loh-ok ha loob nin hongab na. ");
INSERT INTO abp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haanin, hiyay Ham a bapa nan Canaan ket nilumoob ya ha hongab, ket nakit na yan loh-ok ye bapa na. Nilumwah ya ha hongab, ket hinabi na kanlan luway katongno na ye nakit na. ");
INSERT INTO abp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kaya-bay hiyay Shem boy Jafet, nangwa hilan oweh a ingkonin la ha bantaw la haka hila nayngidlan a lumoob a patalingkukol ha hongab. Inowehan la yay laman nan bapa la. Ahe la pinalingayan ta ahe la labay makit a loh-ok yay bapa la. ");
INSERT INTO abp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ha naimahmahan yaynay Noe boy ha natandaan na ye dinyag nan anak na a bonho, ");
INSERT INTO abp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","hinabi na, “An-ihumpa kata Canaan. Mag-ilyadi kan ipoh lan kakatongno mo.” ");
INSERT INTO abp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Boy hinabi na po, “Galangen yay Apo Dioh, a Namalyadi nan Shem. Mag-ilyadi ya dayin ipoh nan Shem ye Canaan. ");
INSERT INTO abp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Pawayen naya dayin Apo Namalyadi ye lugal nan Jafet boy mag-ilyadi ya dayin manged ye paylamo nin lalahi na kanlan lalahi nan Shem. Boy mag-ilyadi ya met dayin ipoh nan Jafet ye Canaan.” ");
INSERT INTO abp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pangayadi nin tanep, nabi-ay ya po ye Noe nin 350 a taon. ");
INSERT INTO abp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Inumabot ya ha 950 a taon bayo yan natey. ");
INSERT INTO abp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hilayati ye lalahi nan Shem, Ham, boy Jafet a tatlon aanak nan Noe. Ket nagkaanak hila ha pangayadi nin tanep. ");
INSERT INTO abp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Hilay lalakin aanak nan Jafet ket hilan Gomer, Magog, Madai, Javan, Tubal, Meshec boy Tiras. ");
INSERT INTO abp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Hilay lalakin aanak nan Gomer ket hilan Ashkenaz, Rifat boy Togarma. ");
INSERT INTO abp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Hilay lalakin aanak nan Javan met ket hilan Elisha, Tarshish, Kitim boy Dodanim. ");
INSERT INTO abp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hilayati ye lalahi nan Jafet. Hilabay ye nangibatan lan tataon angkumonin ha ambay dagat boy ha aalipoteh. Balang magha kanla ket nagkamain nin hadilin lugal boy habi. ");
INSERT INTO abp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hilay lalakin aanak nan Ham ket hilan Cush, Egipto, Put, boy Canaan. ");
INSERT INTO abp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ket hilay lalaki met a aanak nan Cush ket hilan Sheba, Havilah, Sabta, Raama boy Sabteca. Hilay aanak nan Raama ket hilan Sheba boy Dedan. ");
INSERT INTO abp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Hiyay Cush ket main ya po anak a laki, hiyay Nimrod. Hiyay Nimrod ye kaunaunaan a magaling a makilaban boy ambigbigen a tao. ");
INSERT INTO abp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tanda nan Apo Dioh a magaling ya ha pamanti. Kaya-bay main kahabiyan, a wanae, “Magaling ya ha pamanti a omen kanan Nimrod.” ");
INSERT INTO abp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hilay unan panakopan a pinamaalaan nan Nimrod ket Babilonia, Erec, Akad boy Calne. Kaganaan hilayain ket hakop nin Shinar. ");
INSERT INTO abp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Paibat ihtew, nakew ya ha Asiria, ket impaideng nay babanwa a Nineve, Rehobot Ir, Cala, ");
INSERT INTO abp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","boy Resen a anti ha pietan nin Nineve boy Cala, magha yan angkabalitaan a banwa. ");
INSERT INTO abp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hiyay Egipto ye bapa lan Ludeo, Anameo, Lehabeo boy Naftu, ");
INSERT INTO abp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","hilay Patruseo, Caslu, boy Caftoreo a pinangibatan lan Filisteo. ");
INSERT INTO abp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Hiyay Canaan ye bapa nan Sidon boy Het. Hiyay Sidon ye punganay. ");
INSERT INTO abp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Hiyay Canaan met ye nangibatan lan Jebuseo, Amoreo, Gergaseo, ");
INSERT INTO abp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiveo, Arkeo, Sineo, ");
INSERT INTO abp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadeo, Zemareo, boy Hamateo. Ha kabuyotan, nangaitayak hilaynay lalahi nan Canaan. ");
INSERT INTO abp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Hiyay anggaan nin lugal la ket paibat ha Sidon paabagatan ha Gerar anggan Gaza. Ha dapit daya ket inumabot ya ha Sodoma, Gomora, Adma boy Zeboyim anggan Lasha. ");
INSERT INTO abp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hilabaytew ye lalahi nan Ham a angkumonin ha nakahinadi a lulugal a hakop nin nahyon la boy main hilan hadihadilin habi. ");
INSERT INTO abp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Hiyay Shem a ali nan Jafet ye pinangibatan nin lalahi nan Eber. ");
INSERT INTO abp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Hilay lalakin aanak nan Shem ket hilan Elam, Ashur, Arfaxad, Lud, boy Aram. ");
INSERT INTO abp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ket hilay aanak na met nin Aram ket hilan Uz, Hul, Geter, boy Meshec. ");
INSERT INTO abp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Hiyay Arfaxad ye bapa nan Shela a bapa nan Eber. ");
INSERT INTO abp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Luwa ye aanak nan Eber. Hiyay magha ket napangalanan yan Peleg, ulita ha kapanaonan na nayngingihyay ye tatao ha babe-luta. Hiyay ikalwa ket Joktan. ");
INSERT INTO abp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Hiyay Joktan ye bapa lan Almodad, Shelef, Hazarmavet, Jera, ");
INSERT INTO abp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO abp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO abp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila boy Jobab. Hilabay ye lalakin aanak nan Joktan. ");
INSERT INTO abp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Hiyay lugal a angkunaan la ket paibat ha Mesha angga ha Sefar a anti ha mamapantay ha dapit daya. ");
INSERT INTO abp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hilayati ye lalakin aanak nan Shem boy lalahi la, hahabi boy lulugal a hakop nin nahyon la. ");
INSERT INTO abp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hilayain ye lalahi nin aanak nan Noe a angkumonin ha hadihadili lan nanahyon. Hilabay ye pinangibatan nin kaganaan a nanahyon ha babe-luta, pangayadi nin tanep. ");
INSERT INTO abp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ha hatew, mamaghan bengat ye habi nin kaganaan a tatao ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ha panguman-uman la nin kunaan, paibat ha dapit daya, nakakit hilan kapatalan ha Shinar. Ket ihtew hila kinumonin. ");
INSERT INTO abp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Haanin, hinabi la ha magha boy magha, “Makew kawo di! Mandimeng kitawon luta, ta pakawotoen tawo yan manged ta-omen ya bumyang.” Tana-tana dapah ye gawien la, ket luta a pinabyang ye ginawi la boy ihpalto ye ginawi lan pamayket. ");
INSERT INTO abp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Hinabi la, “Makew kawo di, ta manyag kitawon maghay banwa a main todi a miabot ha luwang ta-omen kitawo mag-ilyadin angkabalitaan boy ahe mapaykatak-katak ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Haanin, inumaypa yay Apo Dioh ta-omen na bilewen ye banwa boy todi a andiyagen lan tatao. ");
INSERT INTO abp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Hinabi nan Apo Dioh, “Haanin, ampaymamagha hilan kaganaan boy mamaghay habi la. Hiyay kalalakwan na, ket diyagen laynay hinyaman a labay lan diyagen. ");
INSERT INTO abp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kaya-bay umaypa kitawo ta-omen tawo paylulumboen ye hahabi lan tatao ta-omen hilayna ahe mapaykataloh.” ");
INSERT INTO abp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kaya-bay hiyay Apo Dioh, pinaytayak-tayak na hilay tatao ha kaganaan a lulugal ha babe-luta, ket in-itgen lay panyag la nin banwa. ");
INSERT INTO abp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kaya-bay pinangalanan yan Babel yatew a banwa, ulita ihtewbay na pinaylulumbo Apo Dioh ye habi lan tatao. Ket paibat ihtew, pinaytayak-tayak na hilay tatao ha nakahinadi a lulugal ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hilayati ye lalahi nan Shem. Pangalabah nin luway taon paibat ha tanep, hiyay Shem a 100 anay taon na ket nagkaanak yan laki, hiyay Arfaxad. ");
INSERT INTO abp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Hiyay Shem ket nabi-ay ya po nin 500 a taon, boy nagkaanak ya po nin aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ha 35 taon naynan Arfaxad, nagkaanak yan laki, hiyay Shela. ");
INSERT INTO abp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nabi-ay ya po nin 403 a taon ye Arfaxad, boy nagkaanak ya po nin kanayon a aanak a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ha 30 a taon naynan Shela, nagkaanak yan laki, hiyay Eber. ");
INSERT INTO abp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nabi-ay ya po nin 403 a taon ye Shela, boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ha 34 anay taon nan Eber, nagkaanak yan laki, hiyay Peleg. ");
INSERT INTO abp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nabi-ay ya po nin 430 a taon ye Eber, boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ha 30 a taon naynan Peleg, nagkaanak yan laki, hiyay Reu. ");
INSERT INTO abp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nabi-ay ya po nin 209 a taon ye Peleg boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ha 32 a taon naynan Reu, nagkaanak yan laki, hiyay Serug. ");
INSERT INTO abp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nabi-ay ya po nin 207 a taon ye Reu, boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ha 30 a taon naynan Serug, nagkaanak yan laki, hiyay Nahor. ");
INSERT INTO abp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nabi-ay ya po nin 200 a taon ye Serug, boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ha 29 a taon naynan Nahor, nagkaanak yan laki, hiyay Terah. ");
INSERT INTO abp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nabi-ay ya po nin 119 a taon ye Nahor, boy nagkaanak ya po nin kanayon a aanak. ");
INSERT INTO abp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ha 70 a taon naynan Terah, nagkaanak yan tatlon lalaki, hilan Abram, Nahor, boy Haran. ");
INSERT INTO abp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hilayati ye lalahi nan Terah a bapa nan Abram boy Nahor. Boy hiyay Haran ye bapa nan Lot. ");
INSERT INTO abp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Angkabi-ay ya po ye Terah ha matey yay Haran ha kinaanakan na a banwan Ur a hakop lan Caldeo. ");
INSERT INTO abp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Napag-ahawa na yan Abram ye Sarai, ket napag-ahawa naya met Nahor ye Milca a anak nan Haran a bapa nan Isca. ");
INSERT INTO abp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hiyay Sarai, homain yan anak, ulita bawog ya. ");
INSERT INTO abp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Inumalih yay Terah ha banwan Ur a hakop lan Caldeo, kalamo na yay anak na a hiyay Abram boy ahawa nan Abram a hiyay Sarai boy hiyay Lot a anak nan Haran. Palakew hila ha lugal Canaan. Noba ha nilumateng hilayna ha Haran, ket ihtew hilayna kinumonin. ");
INSERT INTO abp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ket ihtew yaynan natey ye Terah. 205 anay taon na ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Hinabi nan Apo Dioh kanan Abram, “Lakwanan moy lugal mo, papaltido mo boy hilay kabaey nan bapa mo, ket makew ka ha lugal a ipakit ko kamo. ");
INSERT INTO abp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Pakalabongen koy lalahi mo boy diyagen ko hilan maghay angkabalitaan a nahyon. Inged kata boy diyagen kon angkabalitaan ye ngalan mo, ket makauli kamo minged hilay kanayon a tatao. ");
INSERT INTO abp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Inged ko ye ayaman a manginged kamo, noba ihumpa ko ye ayaman a mangihumpa kamo. Ket makauli kamo, inged ko ye kaganaan a lalahi ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kaya-bay inumalih yay Abram ha Haran a omen ha hinabi nan Apo Dioh kana. Nakilakew ya met ye Lot kana. 75 anay taon nan Abram ha inumalih ya ha Haran. ");
INSERT INTO abp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ha inumalih ya ha Haran palakew ha Canaan, kalamo na yay Sarai a ahawa na boy hiyay Lot a angken na. Kalamo na hila met ye kaganaan a iipoh na boy babandi a natipon na ha Haran. Ha nilumateng hilayna ha Canaan, ");
INSERT INTO abp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","nagpahulong yay Abram anggan Shekem, ha maghay mayadet a kayon Moreh. (Kananyatew a panaon, anti hila po ye Cananeo ihtew.) ");
INSERT INTO abp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Haanin, napakit yay Apo Dioh kanan Abram, ket hinabi na kana, “Ibyay ko yatin lugal kanlan lalahi mo.” Ket hiyay Abram, nanyag ya ihtew nin pangihagpaan nin ihagpa kanan Apo Dioh a napakit kana. ");
INSERT INTO abp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pangayadi, nagpahulong hila ha mamapantay nin Betel. Ket ihtew hila nagpondo, ha dapit daya nin Betel a dapit laud nin Ai. Nanyag ya ihtew nin pangihagpaan ket nanggalang ya kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Pangayadi, nagpahulong hila palakew ha Negev. ");
INSERT INTO abp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kananyatew a panaon, nagkamain nin tubat a bitil ha Canaan. Kaya-bay hiyay Abram, ket nakew yan kinumonin ha Egipto, ta tubat anay bitil ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bayo ya hinumlep ye Abram ha anggaan nin Egipto, hinabi na kanan Sarai a ahawa na, “Maada kan babayi. ");
INSERT INTO abp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ket no makit la kan Egipsio, habiyen la a ahawa kata, ket pateyen lako, noba hika, paolayan la kan mabi-ay. ");
INSERT INTO abp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kaya-bay habiyen mo kanla a mikatongno kita ta-omen lako ahe pateyen uli kamo.” ");
INSERT INTO abp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ha niabot hilayna ha Egipto, nakit lan Egipsio a maada yan tubat ye Sarai. ");
INSERT INTO abp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ha nakit la yan oopihyal nan Faraon ye Sarai, imbalita la kanan Faraon no way-omen ya kaada ye Sarai. Ket imbilin nan Faraon a kowen la yay Sarai. Ket kingwa la yay Sarai boy inlakew laya ha palahyo. ");
INSERT INTO abp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Uli kanan Sarai, manged ye pananggap nan Faraon kanan Abram. Binyan naya po Faraon ye Abram nin tutupa, kakambing, babaka, aahno, kakamilyo boy iipoh. ");
INSERT INTO abp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Noba uli kanan Sarai, hiyay Apo Dioh, pinahakit na yan mabyat a tubat ye Faraon boy hilay kalalamoan na ha palahyo. ");
INSERT INTO abp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kaya-bay impadakit na yay Abram boy tinepet naya, “Hinyatin dinyag mo kangko? Taket ta ahe mo hinabi kangko a ahawa mo yay Sarai? ");
INSERT INTO abp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Taket ta hinabi mo a mikatongno kawo? Kaya-bay kingwa ko yan mapag-ahawa ko. Haanin, anti ya ihti ye ahawa mo. Kowen moya boy umalih kawoyna!” ");
INSERT INTO abp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Imbilin nan Faraon kanlan huhundaloh na a paalihen la hilaynay miahawa. Kaya-bay intonda la yay Abram papalwah ha Egipto, kalamo na yay ahawa na, kaget nay kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kaya-bay paibat ha Egipto, nakew yay Abram ha Negev, lamo na yay ahawa na boy kaget lay kaganaan a babandi la. Nakilakew ya met ye Lot a angken na. ");
INSERT INTO abp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Mabatnang yaynan tubat ye Abram kananyatew. Malabong hilaynay tutupa na, kakambing, boy babaka na boy malabong ana met ye balitok boy mital na. ");
INSERT INTO abp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Paibat ha Negev, nanguman-uman hilan lugal angga ha nakaudong hilayna ha lugal a alan lan nangipaidengan nin hongab la. Anti hila ha pietan nin Betel boy Ai, ");
INSERT INTO abp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ihtew ha alan a nanyagan na nin pangihagpaan nin ihagpa kanan Apo Dioh. Ket ihtew ya nanggalang uman kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Hiyay Lot a lanang nan kalamo Abram, ket malabong ana met ye tutupa na, kakambing boy babaka. Main yayna met hadilin pamilya boy iipoh. ");
INSERT INTO abp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ket ulita malabong anay aayop la boy kanayon po a babandi la, ket kulang yaynay pagpahtolan nin aayop lan luwa yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kaya-bay ampay-away hilay māgpahtol la. (Kananyatew hilay Cananeo boy Perezeo ket angkumonin hila po ihtew a lugal.) ");
INSERT INTO abp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kaya-bay hinabi nan Abram kanan Lot, “Adi kita may-away boy hilay māgpahtol ta, ta mipapaltido kitawo. ");
INSERT INTO abp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Manged po no mayngihyay kita, ulita maway man ye lugal malyadi tan lakwen. No labay mo ha dapit odi ka, ha dapit wanan ako. Ket no ha dapit wanan ye labay mo, ha dapit odi ako.” ");
INSERT INTO abp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ket ha in-iwah nan Lot ye pamilew na, nakit na ye matiboen kapatalan nin Jordan angga ha Zoar a malanom a omen ha pananamanan nan Apo Dioh ha Eden boy ha lugal a Egipto. (Kananyatew ahe na po inapo Apo Dioh ye Sodoma boy Gomora.) ");
INSERT INTO abp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kaya-bay pinili na yan Lot ye matiboen kapatalan nin Jordan. Ket nag-aligwat yaynan palakew ha dapit daya, ket nayngihyay hilayna kanan Abram. ");
INSERT INTO abp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kinumonin ya po ye Abram ha Canaan, noba hiyay Lot, kinumonin ya ha babanwa ha kapatalan. Ket impaideng nay hohongab na ha haley nin Sodoma. ");
INSERT INTO abp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hilay tatao ha banwan Sodoma ket mangaloke hila, ampagkahalanan hilan tubat laban kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ha nakaalih yaynay Lot, hinabi nan Apo Dioh kanan Abram, “Paibat ha an-idengan mo, bilewen mon manged ye palibot mo, ha dapit amyanan, abagatan, daya boy laod. ");
INSERT INTO abp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Kaganaan a luta a angkakit mo, ket ibyay ko kamo boy kanlan lalahi mo makanoman. ");
INSERT INTO abp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Pakalabongen ko hilay lalahi mo nin omen ha kalabong nin ahe mabilang-bilang a towapok ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lakwen mon liweden yain a matiboen lugal, ta ibyay ko yain kamo.” ");
INSERT INTO abp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kaya-bay nakew yay Abram ha Hebron, ket ihtew ya kinumonin ha haley nin mayadet a poon-kayo nan Mamre. Ket nanyag ya ihtew nin pangihagpaan nin ihagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kananyatew a panaon, hiyay Poon Amrafel nin Shinar, Poon Arioc nin Elasar, Poon Kedorlaomer nin Elam boy Poon Tidal nin Goyim, ");
INSERT INTO abp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ket ampakigubat hila kanlan Poon Bera nin Sodoma, Poon Birsha nin Gomora, Poon Shinab nin Adma, Poon Shemeber nin Zeboyim boy Poon Zoar nin Bela. ");
INSERT INTO abp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Naymamagha hilatin liman popoon, ket tinipon lay huhundaloh la ha alagoog nin Sidim a anhabtan haanin nin Dagat a Natey. ");
INSERT INTO abp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ha loob nin labinluway taon, nahakop lan Kedorlaomer hilay limay popoon, noba ha ikalabintatloy taon, naymamagha hilaynan nilumaban kanan Kedorlaomer ye limay popoon. ");
INSERT INTO abp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ha ikalabinapat a taon, hilan Poon Kedorlaomer boy hilay popoon a ampakitupig kana, ket hinambot la hilay Refaimeo ha Ashtarot Karnaim, hilay Zuzita ha Ham boy hilay Emita ha Save Kiriataim. ");
INSERT INTO abp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hinambot la hila met Kedorlaomer ye Horita ha mamapantay nin Seir angga ha El Paran a anti ha gilid nin wangwang. ");
INSERT INTO abp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Paibat ihtew, nagbawit hilan palakew ha En Mishpat a anhabtan Kadesh. Ket hinakop lay matiboen lugal lan Amalekita dayon lan Amoreo a angkumonin ha Hazazon Tamar. ");
INSERT INTO abp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Haanin, hilay popoon nin Sodoma, Gomora, Adma, Zeboyim boy Bela, tinipon la hilay huhundaloh la ha alagoog nin Sidim. Ket ihtew la hilan inhadya a makigubat ye huhundaloh la ");
INSERT INTO abp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","laban kanlan Poon Kedorlaomer nin Elam, Poon Tidal nin Goyim, Poon Amrafel nin Shinar boy Poon Arioc nin Elasar. Limay popoon laban ha apat a popoon. ");
INSERT INTO abp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nahambot hilay limay popoon. Ket ha panumakah lan poon nin Sodoma boy poon nin Gomora boy huhundaloh la, naampag hilay kanayon kanla ha maalale a lubot a pangwaan nin ihpalto ha alagoog nin Sidim, ta malabong ye lubot ihtew a lugal. Hilay kanayon, nakatakah hilan palakew ha mamapantay. ");
INSERT INTO abp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kaya-bay hinamham lan apat a popoon ye kaganaan a babandi ha Sodoma boy Gomora boy kaganaan a pamangan ihtew haka hilan inumalih. ");
INSERT INTO abp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kinapyol laya met ye Lot a angkumonin ha Sodoma a angken nan Abram boy kingwa lay kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Noba nakatakah yay maghay laki, ket nakew ya kanan Abram a maghan Hebreo. Ket imbalita na kanay nalyadi. Hiyay Abram ket angkumonin ya hatew ha haley nin mayadet a poon-kayo nan Mamre a maghan Amoreo. Hiyay Mamre boy kakatongno na a hilan Eshcol boy Aner, ket katagem na hilan Abram. ");
INSERT INTO abp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pamakange nan Abram ha nalyadi kanan Lot a angken na, tinipon na hilay tatao na a nakahadya a makilaban. Ket nakatipon ya nin 318 a katao. Kinamat la hilay kalaban la a popoon angga ha banwan Dan. ");
INSERT INTO abp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ha madeglem ana, hiyay Abram, dinyag na hilan luway pangkat ye tatao na. Ket dinawohong la hilay kakaaway la, ket hinambot la hila. Hilay kanayon kanlan kakaaway la, ket tinumakah, noba kinamat na hilan Abram angga ha Hoba ha dapit amyanan nin Damasco. ");
INSERT INTO abp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Naudong lan kaganaan ye nahamham a babandi boy nailigtah laya po ye Lot, kalamo hilay babayi boy hilay kanayon po a tatao. ");
INSERT INTO abp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ha nahambot na yan Abram ye Poon Kedorlaomer boy hilay popoon a katagem na, nag-udong hilayna ha pondowan la. Ket hinagana na yan Poon nin Sodoma ye Abram ha alagoog nin Save a anhabtan alagoog nin Poon. ");
INSERT INTO abp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Hinagana naya met Abram ye Melkizedek a Poon ha Salem boy padi nin Katatagayan a Dioh. Impangaget na yan pamangan boy alak. ");
INSERT INTO abp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","In-inged na yay Abram, a wana, “Abram, inged naka dayin Katatagayan a Dioh a namalhowa nin langit boy babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Galangen ye Katatagayan a Dioh a nanaglap ha panambot mo kanlan kakaaway mo!” Ket hiyay Abram, in-ibyay na kanan Melkizedek ye ikamapo nin kaganaan a nahamham na. ");
INSERT INTO abp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Hinabi nan Poon nin Sodoma kanan Abram, “Konin moynay kaganaan a babandi ko a naudong mo, noba iudong mo hila kangko ye kaganaan a tatao ko.” ");
INSERT INTO abp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Noba hinabi nan Abram kanan Poon nin Sodoma, “Nagpangako ako ha adapan nan Apo Namalyadi a Katatagayan a Dioh a namalhowa nin langit boy luta, ");
INSERT INTO abp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","a ahe ako mangwa nin hinyaman a konin mo agya kaputoh bengat nin bekah o gawot nin ihtiping ta-omen mo ahe mahabi a hika ye namabatnang kangko. ");
INSERT INTO abp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Agko mananggap kamo nin agya hinyaman, powidan bengat ha nakan lan tatao ko. Noba ibyay mo met kanlan Aner, Eshcol boy Mamre ye dakay la, ulita kalamo ko hila.” ");
INSERT INTO abp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pangayadi yatew, impaleplep nan Apo Dioh kanan Abram, a wana, “Abram, adi ka angkalimo. Hikoy kalahag mo boy biyan kata nin mayadet a plimyo.” ");
INSERT INTO abp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Noba hinabi nan Abram, “Apo Dioh a Makapalyadiyan, hinyay hilbi nin ibyay mo kangko, ket homain ako met anak! Hiyay mag-ilyadin mānawid nin babandi ko ket hiyay ipoh kon Eliezer a taga Damasco. ");
INSERT INTO abp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ahe moko binyanan nin anak. Kaya-bay hiyay ipoh ko ye manawid nin babandi ko.” ");
INSERT INTO abp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Hinabi nan Apo Dioh, “Aliwan hiyay ipoh mo ye manawid nin kaganaan a babandi mo, no aliwan hadili mon anak ye manawid.” ");
INSERT INTO abp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Haanin, pinalwah na yan Apo Dioh ye Abram ha hongab. Ket hinabi na kana, “Bilewen mo hilay bibitoen ha luwang, ket bilangen mo hila no mababa mon bilangen. Wanabay hila met lano kalabong ye lalahi mo.” ");
INSERT INTO abp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Namteg yay Abram kanan Apo Dioh. Kaya-bay imbilang na yan matoynong Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hinabi na po Apo Dioh kanan Abram, “Hikoy Apo Dioh a naghabi kamo a alihan mo ye Ur a lugal lan Caldeo ta-omen ko ibyay kamo yatin lugal a pagkonin mo.” ");
INSERT INTO abp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Noba hinabi nan Abram, “Apo Dioh a Makapalyadiyan, way-omen ko matandaan a mapagkonin ko yatin lugal?” ");
INSERT INTO abp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Hinabi nan Apo Dioh kana, “Mangilakew ka kangko nin maghay dumalaga a baka, babayin kambing, boy lakin tupa a pawa manitatloy taon. Mangaget ka met nin maghay kalapati boy maghay kulokulok.” ");
INSERT INTO abp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Hiyay Abram, inlakew na hilayatin aayop kanan Apo Dioh. Ket pinatey na hilan ginitna Abram haka na hila pinay-eteb-eteb ye balang kagitna. Noba hilay mamanokmanok, ket ahe naynan ginitna. ");
INSERT INTO abp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Hinumagpa hilay uuwak ha lalaman nin pinatey a aayop ta-omen la kena. Noba binuyaw na hilan Abram. ");
INSERT INTO abp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ha ampitangheb yaynay mangaamot, nipakatuloy yan maiplek ye Abram. Ket nilumateng kanay ampakalilimon kalitehan. ");
INSERT INTO abp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Hinabi nan Apo Dioh kanan Abram, “Katapulan a matandaan mo a ha loob nin 400 a taon hilay lalahi mo, ket kumonin hila lano ha kanayon a lugal a ahe la pagkonin. Ket maipoh hila lano ihtew boy mapatiyatiyaan. ");
INSERT INTO abp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Noba hilay tataon mangipoh kanla, ket paduhaan ko hila. Pangayadi, alihan lan lalahi mo yatew a lugal, ket malabong a babandi ye makaget la. ");
INSERT INTO abp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Noba hika Abram, matey ka lano ha pangatoa mo boy mailbeng ka a main katanaan boy mapagkalamo mo hilay nangaunan tutoa mo. ");
INSERT INTO abp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Malabah po ye apat a lahi bayo hila makaudong ihti, ulita agaden ko po anggan tubat anay kalok-an lan Amoreo haka ko hila paduhaan boy paalihen.” ");
INSERT INTO abp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ha nitangheb anay mangaamot boy anlulumiteh ana, kapipikhaan napakit ye maghay koden a an-umanoh, boy andumlag a kingki ket nagdān ya ha pietan nin ginitna a aayop. ");
INSERT INTO abp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ket kananyatew a mangaamot, nanyag yan kahundoan ye Apo Dioh kanan Abram, a wana, “An-ipangako ko a ibyay ko kanlan lalahi mo yatin lugal, paibat ha kabatowan a anggaan nin Egipto angga ha mayadet a kabatowan nin Eufrates. ");
INSERT INTO abp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Yati ye lugal lan Keneo, Kenizeo, Kadmoneo, ");
INSERT INTO abp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Heteo, Perezeo, Refaimeo, ");
INSERT INTO abp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoreo, Cananeo, Gergaseo boy Jebuseo.” ");
INSERT INTO abp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hiyay Sarai a ahawa nan Abram, ket ahe ya nagkaanak kana. Noba hiyay Sarai, main yan ipoh a babayi a taga Egipto a hiyay Hagar. ");
INSERT INTO abp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hinabi nan Sarai kanan Abram, “Ahe nako pinalubohan Apo Dioh a magkaanak kamo. Lalayen mo yay Hagar a ipoh ko. Maka magkaanak ako makauli kana.” Inawo nan Abram ye hinabi nan Sarai. ");
INSERT INTO abp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ket impabaala na yan Sarai ye Hagar kanan Abram a pag-ahawa naya. Nalyadi yati pangayadi nin mapo a taon nin pangumonin nan Abram ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nilalay na yan Abram ye Hagar, ket binumuktot ya. Ha natandaan nan Hagar a mabuktot yayna, hinita na yay Sarai. ");
INSERT INTO abp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ulin yati, hinabi nan Sarai kanan Abram, “Hika ye nagkahalanan no taket ta anhitaen na kon Hagar! Impabaala koya kamo ye ipoh ko. Noba taket ta anhitaen na koyna haanin ulita natandaan na a mabuktot yayna? Hiyaynay Apo Dioh ye manuhga no hinya kantan luwa ye nagkahalanan,” wanan Sarai. ");
INSERT INTO abp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Noba hinabi nan Abram kanan Sarai, “Main kan katulidan ha ipoh mo. Diyagen moy labay mon diyagen kana.” Ket hiyay Sarai, pinatiyatiyaan na yay Hagar. Kaya-bay tinumakah yay Hagar. ");
INSERT INTO abp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nakitan na yan anghil nan Apo Dioh ye Hagar ha haley nin maghay hubol a anti ha wangwang. Yatin hubol ket anti ya ha gilid nin dān palakew ha Shur. ");
INSERT INTO abp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Hinabi nin anghil, “Hagar, ipoh nan Sarai, way-ihtew ka ibat boy way-ihtew ka makew?” “Tinakahan ko yay amo kon Sarai,” wanan Hagar. ");
INSERT INTO abp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Hinabi nin anghil kana, “Mag-udong ka kanan amo mo boy pahakop ka kana.” ");
INSERT INTO abp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Hinabi na po nin anghil, “Pakalabongen ko hilay lalahi mo anggan ahe mo hila mabilang-bilang ye kalabong la. ");
INSERT INTO abp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mabuktot kayna, ket manganak ka lano nin laki. Pangalanan mo yan Ishmael, ta lingnge nan Apo Dioh ye aleng-eng mo ha kaidapan mo. ");
INSERT INTO abp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Noba hiyay anak mo, ket omen ya lano ha mahilib a ahno. Kalabanen nay kaganaan a tatao ket kalabanen laya met nin kaganaan a tatao. Ket legan angkabi-ay ya, ampipaylaban hila kanlan papaltido na.” ");
INSERT INTO abp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hiyay Dioh a nakitongtong kanan Hagar ket hinabtan naya, “Hika ye Dioh a Ampakakit”, ta hinabi nan Hagar, “Nakit ko yaynay Apo Dioh a ampakakit kangko.” ");
INSERT INTO abp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kaya-bay yatin libon a anti ha pietan nin Kadesh boy Bered, ket anhabtan lan tatao nin “Beer Lahai Roi.” ");
INSERT INTO abp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nanganak yay Hagar nin maghay laki. Ket hiyay Abram, pinangalanan na yan Ishmael ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","86 anay taon nan Abram ha in-anak na yan Hagar ye Ishmael. ");
INSERT INTO abp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ha 99 anay taon nan Abram, napakit yay Apo Dioh kana, a wana, “Hikoy Apo Namalyadi a Makapalyadiyan. Magbi-ay kan mapatayaan kangko boy homain pakaidlawan. ");
INSERT INTO abp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Manyag akon kahundoan kamo boy pakalabongen ko hilan tubat ye lalahi mo.” ");
INSERT INTO abp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pamakange nan Abram ye hinabi nan Apo Namalyadi, nilumukob ya ha luta. Hinabi nan Apo Namalyadi kana, ");
INSERT INTO abp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Yati ye kahundoan ko kamo. Mag-ilyadi kan bapa nin malabong a nanahyon. ");
INSERT INTO abp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ket paibat haanin, aliwaynan Abram ye ngalan mo, no aliwan Abraham, ulita diyagen katan bapa nin malabong a nanahyon. ");
INSERT INTO abp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Pakalabongen ko hilay lalahi mo boy diyagen ko hilan nanahyon boy main mag-ilyadin popoon a ibat ha lahi mo. ");
INSERT INTO abp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Hiyay kahundoan ta dayon lalahi mo, ket hikoy Dioh mo boy Dioh lan lalahi mo. Mikakaanti yatin kahundoan ta makanoman. ");
INSERT INTO abp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ibyay ko lano kamo boy kanlan lalahi mo yatin lugal a Canaan a ampakilugalan yo haanin. Mapagkonin yo yan makanoman ye kaganaan a hakop nin Canaan boy hiko ye mag-ilyadin Dioh yo.” ");
INSERT INTO abp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hinabi nan Apo Namalyadi kanan Abraham, “Hika boy hilay lalahi mo, ket katapulan a humbongen yo yatin kahundoan. ");
INSERT INTO abp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yati ye kahundoan ko kamo boy kanlan lalahi mo a humbongen yo. Hika boy hilay kaganaan a lalaki a lalahi mo, ket katapulan hilan tulien. ");
INSERT INTO abp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Magpatuli kawo, ta yain ye pagkakitan nin kahundoan ko kanyo. ");
INSERT INTO abp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Paibat haanin angga kanlan lalahi mo lano, kaganaan a lalakin maianak, ket katapulan a tulien ha ikawalon mangaamot paibat ha in-anak ya. Wanabay met kanlan maianak a lalakin ipoh a kabaey mo dayon kanlan dadayohan a ipoh a hinaliw mo. Yatin pagkakitan ha laman yo ye pamapteg nin homain anggaan a kahundoan ko kanyo. ");
INSERT INTO abp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ayaman a lakin ahe patuli, ket adi yoyna ibilang a kalahi yo, ulita ahe na hinumbong ye kahundoan ko.” ");
INSERT INTO abp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hinabi nan Apo Namalyadi kanan Abraham, “Aliwaynan Sarai ye ngalan nan ahawa mo, no aliwan Sara. ");
INSERT INTO abp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Inged koya boy magkaanak kawo. Inged koya boy mag-ilyadi yan indo nin nanahyon. Main mag-ilyadin popoon a ibat ha lahi na.” ");
INSERT INTO abp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nilumukob ya ha luta ye Abraham, noba kinumaili ya boy hinabi na ha hadili na, “Malyadi po nayi a magkaanak ye lakin magatoh anay taon na? Manganak ya po lagi ye Sara a hiyamapo anay taon na?” ");
INSERT INTO abp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Hinabi nan Abraham kanan Apo Namalyadi, “Hiya tanay Ishmael ye inged mo boy manawid nin babandi ko.” ");
INSERT INTO abp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Noba hinabi nan Apo Namalyadi kana, “Ahe. Manganak ya lano nin laki ye Sara, ket pangalanan moya nin Isaac. Mikakaanti makanoman ye kahundoan ko kanan Isaac boy kanlan lalahi na. ");
INSERT INTO abp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tungkol met kanan Ishmael, nange koy awok mo. Inged koya boy pakalabongen ko ye lalahi na. Magkamain yan labinluway aanak a mamoon boy diyagen kon angkabalitaan a nahyon ye lalahi na. ");
INSERT INTO abp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Noba mikakaanti ye kahundoan ko kanan Isaac boy kanlan lalahi na. Ha omen met ateed kananyatin panaon ha dumondon a taon, ianak na yan Sara ye Isaac.” ");
INSERT INTO abp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pangayadi lan naytongtong Apo Namalyadi, inalihan na yaynay Abraham. ");
INSERT INTO abp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kananyatew met ateed a mangaamot, hinagyat na yay Ishmael boy hilay kaganaan a lalakin kabaey na, boy hilay iipoh a nianak ihtew dayon hilay hinaliw na. Tinupad nan Abraham ye imbilin nan Apo Namalyadi. Ket tinuli na hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Hiyay Abraham ket 99 anay taon na ha tinuli ya. ");
INSERT INTO abp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ket hiyay Ishmael met 13 anay taon na. ");
INSERT INTO abp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tinuli hila ha mamaghay mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tinuli hila met ye kaganaan a lalakin kabaey na, boy hilay iipoh a nianak ihtew dayon hilay hinaliw na kanlan dadayohan. ");
INSERT INTO abp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ha maghay mangaamot ha kaoogtowan, legan anti yan ampikno ye Abraham ha dapit ilwangan nin hongab na ha haley nin mangayadet a popoon-kayo nan Mamre, napakit yay Apo Dioh kana. ");
INSERT INTO abp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Legan ampangiwah-iwah ya ha aliwan minga mataang, nakit na hilay tatlon lalakin ampideng. Tampol yan nideng ye Abraham ket nayew yan nanagana kanla paibat ha ilwangan nin hongab na. Ket nilumukob ya ha luta ha adapan la. ");
INSERT INTO abp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Hinabi nan Abraham kanla, “Apo, no malyadi dayi, kadan kawo po kammi. ");
INSERT INTO abp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mamakwa kon dumali nin makandin lanom a panguyah nin bibitih yo. Ket ihti kawo po magpainawa ha hilong nin kayo. ");
INSERT INTO abp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mangitaladan ako met nin pamangan a kanen yo ta-omen kawo makhaw ha pagpahulong yon kumodang. An-ikaaliket kon paghilbiyan katawo legan anti kawo po kammi.” Hinabi lan tatlon lalaki, “Hali awod, halamat.” ");
INSERT INTO abp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kaya-bay hiyay Abraham, mapadah yan nilumoob ha hongab. Ket hinabi na kanan Sara, “Padah mo! Mangwa kan maghan halop a manged a kalahin tapok, ta pakawotoen mon tinapay.” ");
INSERT INTO abp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nayew yay Abraham palakew ha kawan babaka na ket namili ya nin maghay oybon a mataba. Pangayadi, in-ibyay na ha maghay bayontao a ipoh na, ket mapadah naya met impakawoto. ");
INSERT INTO abp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","In-apag na kanlan tatloy lalaki ye keso, gatah boy kena a baka a naitaladan. Legan ampangan hila, ampideng yay Abraham ha haley la ha hilong nin kayo. ");
INSERT INTO abp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Haanin, tinepet la yay Abraham, “Way-ihtew yay Sara a ahawa mo?” “Anti ya ha loob nin hongab,” wanan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Haanin, hinabi nin magha kanlan lalaki, “Ha pag-udong ko ihti kanyo a omen met ateed kananyatin panaon ha dumondon a taon, hiyay ahawa mo, ket main yaynan anak a laki.” Hiyay Sara, ampanlenge ya ha ilwangan nin hongab a anti ha likol nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","(Matoa hilaynan padiho ye Abraham boy Sara. Agyaynan andayaen ye Sara.) ");
INSERT INTO abp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kaya-bay kinumaili yay Sara boy inihip na, “Matoa kayi nan ahawa ko. Maaliket ako po lagi a makitalig kanan ahawa ko?” ");
INSERT INTO abp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tinepet na yan Apo Dioh ye Abraham, “Taket ta kinumaili yay Sara boy anhabiyen na, ‘Peteg lagi a manganak ako po, ket matoa akoyna?’ ");
INSERT INTO abp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Main nayi ahe na madyag Apo Dioh? Mag-udong ako ha dumondon a taon ha panaon a hinabi ko kamo. Ket ha pag-udong ko, main yaynan anak ye Sara.” ");
INSERT INTO abp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nalimo yay Sara. Kaya-bay nagbudi ya. Hinabi na, “Ahe ako kinumaili.” Noba hinabi nan Apo Dioh, “Adi kaynan magbudi, kinumaili ka.” ");
INSERT INTO abp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pangayadi, nideng hilaynay tatlon lalaki boy tinamolaw lay Sodoma. Ket intonda na hilan Abraham ha dān palakew ha Sodoma. ");
INSERT INTO abp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Hinabi nan Apo Dioh, “Ahe ko itayo kanan Abraham ye diyagen ko. ");
INSERT INTO abp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Homain hapo a mag-ilyadi yan bapa nin maghay mayadet boy makapalyadiyan a banwa. Ket makauli kana, inged ko ye kaganaan a nanahyon ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ta pinili koya ta-omen na hila bilinan ye aanak na boy lalahi na a manumbong kangko boy manyag nin huhto boy matoynong. Ha wanabay, tupaden koy kaganaan a impangako ko kana.” ");
INSERT INTO abp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Haanin, hinabi nan Apo Dioh kanan Abraham, “Main mangabyat a aleng-eng laban ha Sodoma boy Gomora, ta tubat ana ye kalok-an a andiyagen la. ");
INSERT INTO abp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kaya-bay umaypa ako ha Sodoma boy Gomora ta-omen ko makit no peteg o ahe ye aleng-eng tungkol kanla.” ");
INSERT INTO abp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pangayadi, inumalih hilay luway lalaki, ket nakew hilayna ha Sodoma. Noba hiyay Abraham, anti ya po a ampideng ha adapan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hinumaley yay Abraham kanan Apo Dioh, a wana, “Apo, idaman mo hila nayin apoen ye mangatoynong a tatao kanlan mangaloke? ");
INSERT INTO abp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Alimbawa, main 50 a mangatoynong a tataon angkumonin ihtew a banwa. Apoen mo po nayi yatew a banwa? Ahe mo nayi kalunohan yatew a banwa, uli kanlan 50 a mangatoynong a tatao? ");
INSERT INTO abp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ampamtegan ko a ahe mo hila idaman ye mangatoynong. Ta no diyagen mo yatew, padiho hilaynan mapaduhaan ye mangatoynong boy mangaloke. Ahe dayi malyadi yain Apo! Tanda mi a matoynong ye panuhga mo ha kaganaan a tatao ha babe-luta!” ");
INSERT INTO abp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hinabi nan Apo Dioh, “No main akon makitan a 50 a mangatoynong a tatao ha Sodoma, ahe ko apoen yatew a banwa uli kanlan 50 a mangatoynong.” ");
INSERT INTO abp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hinabi nan Abraham, “Apo, agya tao kon bengat, palubohan moko po dayin manepet kamo. ");
INSERT INTO abp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","No 45 bengat ye tataon mangatoynong, apoen mo po nayi yatew a banwa?” “Ahe ko apoen no main akon makitan a 45 mangatoynong a tatao,” wanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nanepet yan uman ye Abraham, “Ket no 40 anan bengat?” “Ahe ko apoen yatew a banwa uli kanlan 40 a mangatoynong,” wanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hinabi nan Abraham, “Adi ka dayi angkapoot, manepet ako po. No 30 anan bengat ye taon mangatoynong ihtew?” “Ahe ko apoen yatew a banwa no main akon makitan a 30 a taon mangatoynong,” wanan Apo. ");
INSERT INTO abp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hinabi nan Abraham, “Patawaden moko dayi Apo ha kaoplitan ko. No 20 anan bengat ye mangatoynong a anti ihtew?” “Ahe ko apoen yatew a banwa uli kanlan 20 a mangatoynong,” wanan uman Apo. ");
INSERT INTO abp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hinabi nan Abraham, “Apo, adi ka dayi angkapoot kangko. Maghay nan bengat ye tepet ko, ‘No 10 anan bengat ye mangatoynong a anti ihtew?’ ” “Adi koya apoen yatew a banwa uli kanlan 10 a mangatoynong a tatao,” wanan Apo. ");
INSERT INTO abp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pangayadi lan naytongtong, inumalih yaynay Apo Dioh. Ket nuli yayna met ye Abraham. ");
INSERT INTO abp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ha madeglem ana, nilumateng ye luway anghil ha Sodoma. Ampikno yay Lot hatew ihtew ha ilwangan nin banwa. Pamakakit nan Lot kanla, nideng ya, ket hinagana na hila boy nilumukob ya ha adapan la. ");
INSERT INTO abp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Hinabi na kanlan luway anghil, “Apo, no malyadi dayi, kadan kawo po ha baey nin ipoh yo ta-omen yo mauyahan ye bibitih yo boy ihtew kawoyna met matuloy haanin a madeglem. Mabekah kawoynan bengat magpahulong ha pangumodang yo.” “Halamat, noba ihtew kayi nan bengat matuloy ha palaha,” wanlan aanghil. ");
INSERT INTO abp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Noba impakiiingalo nan Lot kanla a ihtew hilayna matuloy ha baey na. Kaya-bay nakilakew hilay luway anghil kanan Lot ha baey na. Ket hiyay Lot, nangihadya yan pamangan boy namakawoto ya met nin tinapay a homain pamalbag. Ket nangan hilay luway anghil. ");
INSERT INTO abp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ha matuloy hilayna, nilumateng ye kaganaan a bayontao boy māmaala nin banwa. Ket pinalibotan lay baey nan Lot. ");
INSERT INTO abp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nangha hilan nanepet kanan Lot, a wanla, “Way-ihtew hilay luway lalakin nakidagoh kamo haanin a madeglem? Palwahen mo hila, ta labay mi hilan lalayen.” ");
INSERT INTO abp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nilumwah yay Lot, ket inleneb na ye ilwangan. ");
INSERT INTO abp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Hinabi na kanlan tatao, “Gagayyem, an-ipakiiingalo ko kanyo a adi yo andiyagen ye maloke a an-ihipen yo. ");
INSERT INTO abp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Main akon luway anak a balatang ihti. No labay yo, hilabay tana ye ibyay ko kanyo boy diyagen yoy labay yo kanla. Noba adi yo hila panowen hilatin luway lalaki. Ta bihita ko hila, ket katapulan ko hilan ibiha ta-omen hila ahe mapano.” ");
INSERT INTO abp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Noba hinabi la, “Umalih ka ihen ha ilwangan!” Hinabi la ha magha boy magha, “Yain a tao, ket nakew ya ihti bilang dayohan, ket haanin labay nay manuhga kantawo.” Kaya-bay hinabi la kanan Lot, “Umalih ka ihen! Ta no ahe, diyagen mi kamo ye maloloke po ha diyagen mi kanla.” Ket intudon la yay Lot, ta labay lan agwaten ye leneb nin ilwangan. ");
INSERT INTO abp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Noba nilukatan lan luway anghil ye ilwangan haka la yan ingguloy paloob ye Lot boy inleneb lay ilwangan. ");
INSERT INTO abp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pangayadi, pinakapkap la hilan luway aanghil ye tatao ha ilwah nin baey, aanak man o mangatoa ta-omen layna ahe makit ye ilwangan. ");
INSERT INTO abp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Pangayadi, hinabi lan luway aanghil kanan Lot, “Main ka po nayi kanayon a aanak, mamanuyang o papaltido a angkumonin ihtin banwa? No main po, ilamo mo hilan kaganaan boy umalih kawoyna ihtin banwa, ");
INSERT INTO abp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ulita apoen mina. Nange nan Apo Dioh ye mabyat a pamakahalanan laban kanlan naglugal ihti, ket intubol na kayin Apo Dioh ta-omen mi apoen yatin banwa.” ");
INSERT INTO abp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kaya-bay nilakew na hilan Lot ye mapag-ahawa lan aanak na a babayi. Ket hinabi na, “Padah yoynay umalih ihtin banwa, ta damaen naynan Apo Dioh.” Noba ahe la yan pinamtegan ye Lot, ta nabaan la a ampangalolog yan bengat. ");
INSERT INTO abp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ha palbangon ana, hinabi lan aanghil kanan Lot, “Padah mo! Tampol kaynan umalih ihtin banwa. Ilamo mo yay ahawa mo boy hilay luway aanak mo ta-omen kawo ahe midaman a mapaduhaan kananyatin banwa.” ");
INSERT INTO abp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ampagluwaluwa yay Lot, noba uli ha ingalo nan Apo Dioh kana, ginemgeman nin luway aanghil ye gagamet lan mitapamilyan Lot haka la hilan inlakew papalwah ha banwa. ");
INSERT INTO abp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ha anti hilayna ha ilwah nin banwa, hinabi nin magha kanlan luway anghil, “Tumakah kawoyna ta-omen kawo maligtah. Mayew kawo palakew ha mamapantay. Adi kawo mamalingay o tumgen man legan anti kawo ha kapatalan ta-omen kawo ahe matey!” ");
INSERT INTO abp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Noba impakiiingalo nan Lot, “Apo, adi yoko dayin ampapayewen palakew ha mamapantay. ");
INSERT INTO abp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Iningalowan moko boy impakit moy tubat a kangedan mo kangko ha pangiligtah mo nin bi-ay ko. Noba ahe koyna mababa ye mayew palakew ha mamapantay, ta bayo kon miabot ihtew, ket mabonan akon pakalok-an. ");
INSERT INTO abp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bilewen mo yay makandin banwa ha dongla. Mababa kon aboten yain, ulita mahaley yan bengat. Malyadi nayi Apo a yatew anan bengat ye payewen ko ta-omen ako maligtah?” ");
INSERT INTO abp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Hinabi nin magha kanlan luway anghil, “Higi, ihtew kawoyna makew. Ahe koyna apoen yatew a banwa. ");
INSERT INTO abp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mayew kawoynan makew ihtew, ulita homain akon madyag legan ahe kawo po miabot kananyatew a banwa.” Kaya-bay hinabtan yan Zoar yatew a banwa, ulita hinabi nan Lot a makandi yan banwa. ");
INSERT INTO abp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Matagay anay mangaamot ha nakalateng yay Lot ha Zoar. ");
INSERT INTO abp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kapipikhaan, paibat ha langit, pinaudanan nan Apo Dioh nin manliyab-liyab a ahopli ye banwan Sodoma boy Gomora. ");
INSERT INTO abp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Inapo nan Apo Dioh ye luway banwa dayon matiboen kapatalan. Inapo na hilay kaganaan a angkumonin ihtew dayon tatanaman la. ");
INSERT INTO abp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Noba hiyay ahawa nan Lot, ket namalingay ya ta-omen na bilewen no hinyay angkalyadi. Kaya-bay nag-ilyadi yan kalintataon ahin. ");
INSERT INTO abp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kabekahan, hiyay Abraham, ket magagah yan nag-udong ha pahen a in-idengan na hatew ha adapan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ket tinamolaw nay Sodoma boy Gomora boy kaganaan a kapatalan. Ket nakit na ye makogpan anoh a ampitagay a ba-mon ampangibat ha mayadet a pogon. ");
INSERT INTO abp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ha dinama nan Apo Dioh hilayatew a babanwa ha kapatalan, naihipan na yay Abraham. Kaya-bay inligtah na yay Lot ta-omen ya ahe midaman ha pagkadama nin hilatew a babanwa. ");
INSERT INTO abp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Malimo yan kumonin ye Lot ha Zoar. Kaya-bay inumalih ya ihtew lamo na hilay luwan aanak na. Ket nakew hilan kinumonin ha maghay yukib ha mapantay. ");
INSERT INTO abp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ha maghay mangaamot, naytongtong hilay mikatongno. Hinabi nan makaagat kanan makaydeng, “Matoa yaynay bapa ta boy homain anan nipatla a laki ihti a mapag-ahawa ta ta-omen kita magkamain nin anak a omen ha andiyagen nin kaganaan a tao ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kaya-bay lahingen ta yay bapa ta haka ta yan lalayen ta-omen kita magkaanak boy mikakaanti ye lahi tawo makauli kanan bapa ta.” ");
INSERT INTO abp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ket kananyatew a madeglem, nilahing la yay bapa la. Ket nilalay na yan makaagat ye bapa la. Noba uli ha kalahingan nan Lot, ahe na naedepan ye nalyadi. ");
INSERT INTO abp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kabekahan hinabi nan makaagat kanan makaydeng, “Nadeglem, nilalay ko yay bapa ta. Kaya-bay lahingen ta yan uman papainghan, ket hika met ye manlalay kana ta-omen ka magkaanak boy mikakaanti ye lahi tawo makauli kanan bapa ta.” ");
INSERT INTO abp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kaya-bay kananyatew a madeglem, nilahing la yan uman ye Lot. Ket hiyay makaydeng met ye nanlalay kanan bapa la. Noba ahe nayna man naedepan Lot ye nalyadi. ");
INSERT INTO abp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kaya-bay padiho hilan binumuktot ye mikatongno makauli kanan bapa la. ");
INSERT INTO abp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nanganak yan laki ye makaagat, ket pinangalanan na yan Moab. Hiyabay ye nangibatan nin lalahi lan Moabita haanin. ");
INSERT INTO abp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nanganak ya met nin laki ye makaydeng, ket pinangalanan na yan Ben Ami. Hiya met ye nangibatan nin lalahi lan Ammonita haanin. ");
INSERT INTO abp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Inumalih yay Abraham ha lugal a Mamre, ket nakew ya ha lugal a Negev, ket kinumonin ya ha pietan nin Kadesh boy Shur. Ket ha ahe nabuyot, nakew yan kinumonin ha Gerar. ");
INSERT INTO abp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Legan anti ya ihtew, an-ipatanda nan Abraham kanlan tatao a katongno na yay Sara a ahawa na. Kaya-bay hiyay Abimelec a poon ha Gerar, ket impakwa na yay Sara. ");
INSERT INTO abp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ha maghay madeglem, napakit yay Apo Namalyadi kanan Abimelec ha taynep. Ket hinabi na, “Matey ka, ulita yain a babayin impakwa mo, ket main yaynan ahawa.” ");
INSERT INTO abp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kananyatew, ahe naya po nilalay nin Abimelec ye Sara. Kaya-bay hinabi na kanan Apo Dioh, “Apo, pateyen moko nayi dayon tatao ko agya homain kayin kahalanan? ");
INSERT INTO abp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ket hinabi na met Abraham a katongno na yay Sara. Wanabay met ye hinabi nan Sara tungkol kanan Abraham. Kaya-bay kingwa koya ta hiyay pagkatanda ko, ket balatang ya boy homain ako met maloke a ihip ha pangwa ko kanan Sara.” ");
INSERT INTO abp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Haanin, hinabi nan Apo Namalyadi kana ha taynep, “Awo, tanda kon homain kan maloke a ihip. Kaya-bay binenben katan manige kana ta-omen ka ahe magkahalanan kangko. ");
INSERT INTO abp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Haanin, iudong mo yan tampol kanan ahawa na, ta podopita yay ahawa na. Ket ipakigwang naka ta-omen ka ahe matey. Noba no ahe mo yan iudong kana, homain hapo a matey ka dayon papamilya mo.” ");
INSERT INTO abp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kabekahan, impadakit na hilan Abimelec ye oopihyal na. Ket hinabi na kanla ye taynep na. Ket nalimowan hilan tubat. ");
INSERT INTO abp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pangayadi, impadakit na yay Abraham boy tinepet naya, “Hinyatin dinyag mo kammi? Taket ta ingkonin mo ha pakalok-an ye panakopan ko? ");
INSERT INTO abp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Taket ta wanabay ye dinyag mo?” ");
INSERT INTO abp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nakibat yay Abraham, “Nabaan kon homain kanyo ye main limo kanan Apo Dioh. Kaya-bay naihipan ko a maka pateyen yoko ta-omen yoya makwa ye ahawa ko. ");
INSERT INTO abp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hiyay kaptegan, katongno koya ha bapa, noba lumbo ye indo na, ket hiyaynabay ye napag-ahawa ko. ");
INSERT INTO abp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ha hinabi nan Apo Dioh kangko a alihan koy lugal nan bapa ko, hinabi ko kanan ahawa ko, ‘Agya way-ihtew man a lugal ye lakwen ta, hiyay habiyen mo kanlan tatao ket mikatongno kita. Wanabay mon ipakit ye pangado mo kangko.’ ” ");
INSERT INTO abp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ket in-udong na yan Abimelec ye Sara kanan Abraham boy binyanan naya po ye Abraham nin tutupa, babaka boy iipoh a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Pangayadi, hinabi na kanan Abraham, “Malyadi kan kumonin ha luta ko, ha agya way-ihtew man a pahen a labay mon kunaan.” ");
INSERT INTO abp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Hinabi na met Abimelec kanan Sara, “Biyan ko yay katongno mo nin malibon palatan mital, bilang pamapteg ko kanlan tataon kalamo mo a ahe kata natige boy ahe ka met nagkahalanan.” ");
INSERT INTO abp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Uli ha pangwa nan Abimelec kanan Sara, ahe na impaluboh Apo Dioh a magkaanak ye kaganaan a babayi ha baey nan Abimelec. Kaya-bay impakigwang na hilan Abraham kanan Apo Dioh, ket pinaitaah na yan Apo Dioh ye ahawa nan Abimelec dayon hilay iipoh na a babayi ta-omen hila magkaanak. ");
INSERT INTO abp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","In-inged na yan Apo Dioh ye Sara a omen ha hinabi na boy tinupad nay impangako na kana. ");
INSERT INTO abp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ket kananyatew a panaon a hinabi nan Apo Namalyadi, hiyay Sara ket binumuktot ya boy nanganak yan laki, agya matoa yaynay Abraham hatew. ");
INSERT INTO abp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Hiyay Abraham, pinangalanan na yan Isaac ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ha kinawalowan yaynay ongi, tinuli na yan Abraham, ta wanabay ye imbilin nan Apo Dioh kana. ");
INSERT INTO abp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ha in-anak yay Isaac, ket 100 anay taon nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Hinabi nan Sara, “Pinakaili na kon Apo Namalyadi boy ayaman a makabalita nin pangianak ko kanan Isaac ket makakaili ya met. ");
INSERT INTO abp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Aya po nayi ye makapaghabi kanan Abraham a makapahuho ko po haanin? Noba nagkaanak ako po kana agya matoa yaynay ahawa ko.” ");
INSERT INTO abp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nilumake yay anak, ket ha mangaamot a ipuhot yayna, nagpahayaghag yay Abraham. ");
INSERT INTO abp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Minghan, nakit na yan Sara ye Ishmael a an-ilongolongo na yay Isaac. (Hiyay Ishmael ket anak nan Abraham kanan Hagar a taga Egipto.) ");
INSERT INTO abp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kaya-bay hinabi nan Sara kanan Abraham, “Paalihen mo yain a ipoh boy hiyay anak na, ulita hiyay anak nin babayin ipoh, ket ahe yan malyadin makidakay ha tawiden nan Isaac a anak ko!” ");
INSERT INTO abp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nayoot yan tubat ye Abraham, ta anak naya met ye Ishmael. ");
INSERT INTO abp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Noba hinabi nan Apo Namalyadi kanan Abraham, “Adey mo ikayoot ye tungkol kanan Ishmael boy hiyay ipoh mo a indo na. Leng-en mo ye hinabi nan Sara, ulita hilay lalahi nan Isaac bengat ye maibilang a lalahi mo. ");
INSERT INTO abp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ket hiyay tungkol met kanan Ishmael, pakalabongen koya lano ye aanak na a mag-ilyadin maghay nahyon, ulita anak moya met.” ");
INSERT INTO abp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kabekahan ha mahanibhanib po, hiyay Abraham ket nangwa yan bawon a pamangan boy lanom a naikonin ha balayong a katat ayop. Ket impahaklili naya kanan Hagar. Pangayadi, pinaalih na hilaynay mitaindo. Ket nagbalangbalang hila ha wangwang nin Beer Sheba. ");
INSERT INTO abp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ha nauboh yaynay lanom ha balayong la, imbantak na yan Hagar ye anak na ha hilong nin mahipok a poon-kayo. ");
INSERT INTO abp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ket nakew yan nikno ye Hagar ha manga 100 a mitodo kataang kanan anak na. Ta hinabi na ha hadili na, “Ahe ko mikpen bilewen a matey yay anak ko.” Legan ampikno ya ket antumangih ya. ");
INSERT INTO abp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nange nan Apo Namalyadi ye tangih nan anak. Ket paibat ha langit, hinabi nin anghil nan Apo Namalyadi kana, “Hagar, hinyay angkahindakan mo? Adi ka angkalimo. Nange nan Apo Namalyadi ye tangih nan anak mo ha nangibantakan mo. ");
INSERT INTO abp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lakwen mo yan liwaliwaen, ulita diyagen ko yan maghay angkabalitaan a nahyon ye lalahi na.” ");
INSERT INTO abp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pangayadi, impakit nan Apo Namalyadi kanan Hagar ye maghay libon. Kaya-bay hinaleyan naya, ket pinno na nin lanom ye balayong na boy pinainom na yay Ishmael. ");
INSERT INTO abp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Legan anlumake yay Ishmael, ahe na yan pinaolayan Apo Namalyadi. Kinumonin ya ha wangwang nin Paran, ket nag-ilyadi yan mahipat a mamana. Hiyay Hagar a indo na, impangwa na yay Ishmael nin pag-ahawa na a taga Egipto. ");
INSERT INTO abp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kananyatew a panaon, nakew yay Poon Abimelec kanan Abraham, lamo na yay Picol a mānguna nin huhundaloh na. Hinabi nan Poon Abimelec kanan Abraham, “Naimatonan ko a an-inged na kan Apo Namalyadi ha kaganaan a andiyagen mo. ");
INSERT INTO abp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kaya-bay manumpa ka kangko ha adapan nan Apo Namalyadi a adi moko tagowen dayon aanak ko boy lalahi ko, no aliwan ipakit mo kangkoy kangedan mo dayon kananyatin lugal a angkunaan yo a omen ha kangedan a impakit ko kamo.” ");
INSERT INTO abp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“An-ihumpa ko,” wanan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Noba indiklamo nan Abraham kanan Abimelec ye tungkol ha libon a inam-am lan iipoh nan Abimelec. ");
INSERT INTO abp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Hinabi nan Abimelec, “Ahe ko tanda no ayay nanyag nin yain. Haanin ko yan bengat natandaan ha hinabi mo kangko.” ");
INSERT INTO abp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ket binyanan na yan Abraham ye Abimelec nin tutupa boy babaka. Ket napaykahundo hilan luwa. ");
INSERT INTO abp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Haanin, nangilbo yay Abraham nin pitoy oybon a babayin tupa ha kawan na. ");
INSERT INTO abp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","“Taket ta nangilbo kan pitoy tupa?” wanan Abimelec. ");
INSERT INTO abp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hinabi nan Abraham, “Ibyay ko hilayati kamo bilang pamapteg a yatin libon ket konin ko.” ");
INSERT INTO abp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kaya-bay hinabtan yan Beer Sheba yatin lugal ulita ihtewbay hila nanumpa ha magha boy magha. ");
INSERT INTO abp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pangayadi lan nanyag nin kahundoan ha Beer Sheba, hiyay Abimelec boy hiyay Picol a mānguna lan huhundaloh na, ket nag-udong hilayna ha lugal lan Filisteo. ");
INSERT INTO abp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Haanin, nangitanem yay Abraham nin kayon tamarisko ha Beer Sheba boy nanggalang ya kanan Apo Namalyadi a Dioh makanoman. ");
INSERT INTO abp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ket hiyay Abraham, nabuyot yan kinumonin ha lugal lan Filisteo. ");
INSERT INTO abp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Pangayadi yatew, hinubok na yan Apo Namalyadi ye Abraham. Iningat na yan Apo Namalyadi, a wana, “Abraham.” Nakibat yay Abraham, “Anti ko ihti, Apo.” ");
INSERT INTO abp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Hinabi nan Apo Namalyadi, “Ilakew moya ha lugal nin Moria ye bubugtong boy ampakaadoen mon anak a hiyay Isaac. Ket makew kawo ha mapantay a habiyen ko kamo, ket ihagpa moya kangko bilang hagpa a ulamen.” ");
INSERT INTO abp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kabekahan, ha mahanibhanib po, nimata yay Abraham, ket namotoh yan kakayo a gawien la ha pangihagpa, ket inhakay naya ha ahno na. Pangayadi, nag-aligwat yaynan palakew ha lugal a hinabi nan Apo Namalyadi. Lamo na yay Isaac boy luway ipoh na. ");
INSERT INTO abp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ha ikatlon mangaamot nin pangumodang la, natamolaw naynan Abraham ye lugal a hinabi nan Apo Namalyadi kana. ");
INSERT INTO abp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Hinabi nan Abraham kanlan luway ipoh na, “Ihti kawoynan bengat, ket pakabantayan yo ye ahno, ta hikayinan Isaac ye makew ihtew. Ihtew kayin manggalang kanan Apo Dioh, ket mag-udong kayi met ateed.” ");
INSERT INTO abp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ket impabatay nan Abraham kanan Isaac ye kayon gawien la ha pangihagpa, kaget na met Abraham ye bayah boy keya. Ket ha nagpahulong hilaynan luwa ha pangumodang, ");
INSERT INTO abp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","hinabi nan Isaac, “Tatang.” “Taket, anak ko?” wanan Abraham. “Main kitan bayah boy kayon pangulam nin hagpa, noba way-ihtew ye tupan hagpa a ulamen?” wanan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nakibat yay Abraham, “Anak ko, hiyay Apo Namalyadi ye mamyay nin tupan hagpa a ulamen.” Ket nagpahulong hila ha pangumodang la. ");
INSERT INTO abp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ha niabot hilayna ha lugal a hinabi nan Apo Namalyadi kana, nanyag yay Abraham nin pangihagpaan. Ha nayadi nayna, in-uyon na ye kakayo ha babe nin yati. Pangayadi, binalol na yay Isaac haka naya impaida ha babe nin kakayo. ");
INSERT INTO abp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ha kingwa nan Abraham ye keya, ta pateyen na yaynay anak na, ");
INSERT INTO abp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","iningat yan anghil nan Apo Dioh paibat ha langit, a wana, “Abraham, Abraham!” “Anti ko ihti, Apo”, wanan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Adi moya pateyen ye anak. Adi moya pahakitan! Ta tanda koyna haanin a main kan limo kanan Apo Namalyadi, ulita ahe moya inhiblet kana ye bubugtong mon anak.” ");
INSERT INTO abp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tinumangal yay Abraham, ket nakit na ye bolog a tupa a nakahaet ye hongay na ha hanga nin mahipok a kayo. Kingwa na yan Abraham ye tupa, ket inhagpa naya bilang hagpa a ulamen kanan Apo Dioh bilang kahagili nan anak na. ");
INSERT INTO abp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kaya-bay yatew a lugal, ket hinabtan na yan Abraham nin “Hiyay Apo Dioh ye mamyay.” Ket anggayna haanin, anhabtan lan tatao nin, “Ha mapantay nan Apo Dioh ket main yan ibyay.” ");
INSERT INTO abp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Paibat ha langit, hiyay anghil nan Apo Dioh, iningat na yayna man ye Abraham. ");
INSERT INTO abp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Hinabi na, “Yati ye hinabi nan Apo Dioh. Ulita ahe mo inhiblet kangko ye bubugtong mon anak, an-ihumpa ko kamo ha ngalan ko, ");
INSERT INTO abp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","inged kata boy pakalabongen ko hilay lalahi mo nin omen ha bibitoen ha langit boy langhi ha ambay dagat ye kalabong la. Hakopen lay babanwa lan kakaaway la. ");
INSERT INTO abp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Makauli ha lahi mo, inged koy kaganaan a nanahyon ha babe-luta ulita hinumbong moy bilin ko kamo.” ");
INSERT INTO abp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pangayadi, nag-udong hilaynan Abraham kanlan iipoh na, ket nuli hilaynan kaganaan ha Beer Sheba. Ket ihtew yayna kinumonin ye Abraham. ");
INSERT INTO abp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Pangayadi yatew, nabalitaan nan Abraham a hiyay Milca a ahawa nan Nahor a katongno na ket main yaynan anak. ");
INSERT INTO abp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Hiyay punganay na ket hiyay Uz. Hiyay ikalwa, hiyay Buz. Hiyay ikatlo, hiyay Kemuel (a bapa nan Aram). ");
INSERT INTO abp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Hilay kapahanan po a aanak nan Nahor ket hilan Kesed, Hazo, Pildas, Jidlaf boy Betuel. ");
INSERT INTO abp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hiyay Betuel ye bapa nan Rebeka. Hilayati ye walon aanak nan Milca kanan Nahor a katongno nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Main ya po aanak a laki ye Nahor ha ipoh a ahawa na a hiyay Reuma. Hilay aanak la ket hilan Teba, Gaham, Tahas boy Maaca. ");
INSERT INTO abp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","127 anay taon nan Sara ha natey ya. ");
INSERT INTO abp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Natey ya ha Kiriat Arba a anhabtan laynan Hebron haanin a hakop nin Canaan. Hinumlep yay Abraham ha hongab nan Sara, ket tinangihan boy inandangan naya. ");
INSERT INTO abp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nilakwanan nan Abraham ye bangkay nan ahawa na ket nakew yan nakihabi kanlan Heteo, a wana, ");
INSERT INTO abp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Dayohan akon bengat a ampakilugal kanyo. An-ipakihabi ko kanyo a lakoan yoko dayi nin luta a pangilbengan ko nin bangkay nan ahawa ko.” ");
INSERT INTO abp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nakibat hilay Heteo kanan Abraham, ");
INSERT INTO abp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Apo, leng-en mo kayi po. Katatanda mika a makapalyadiyan a mānguna a ampakilugal kammi. Kaya-bay mamili ka nin pinakamanged a pangilbengan nin bangkay nan ahawa mo. Homain ayaman kammi ye mangihiblet kamo nin pangilbengan ta-omen ya mailbeng ye ahawa mo.” ");
INSERT INTO abp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Haanin, hiyay Abraham, nideng yan niyumoko ha adapan lan Heteo. ");
INSERT INTO abp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ket hinabi na kanla, “No ipaluboh yon peteg a ilbeng koy bangkay nan ahawa ko, an-ipakihabi ko kanyo a haglapan yo kon makitongtong kanan Efron a anak nan Zohar, ");
INSERT INTO abp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","a ilako na kangkoy yukib a anti ha haley nin bangkag na ha Macpela, ta haliwen ko ha huhton alaga a diyagen kon pangilbengan. Konin nan Efron yain a yukib a anti ha dapit anggaan nin bangkag na.” ");
INSERT INTO abp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Anti ya met manayti ye Efron ihtew, kalamo lan kapadiho na a Heteo a ampikno ha dapit ilwangan nin banwa. Kaya-bay hinabi nan Efron kanan Abraham a anleng-en nin kaganaan, ");
INSERT INTO abp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Leng-en yoko! Ha adapan lan kalugal ko, ibyay ko kamo ye yukib dayon bangkag ko. Adi moynan bayadan. Kaya-bay malyadi mo yaynan ilbeng ihtew ye bangkay nan ahawa mo.” ");
INSERT INTO abp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ket niyumoko yan uman ye Abraham ha adapan lan tataon angkumonin ihtew ");
INSERT INTO abp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","boy hinabi na kanan Efron a anleng-en nin kaganaan, “No malyadi dayi, leng-en yo po yatin habiyen ko. Bayadan ko ha huhton alaga yatin bangkag. Tanggapen moynay pamayad ko ta-omen ko yayna mailbeng ye ahawa ko.” ");
INSERT INTO abp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nakibat yay Efron kanan Abraham, ");
INSERT INTO abp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Apo, leng-en moko dayi. Hiyay alaga nin bangkag ko ket apat a gatoh a mital. Adi taynan paytongtongan yain, ta makandin bengat a bagay kantan luwa. Kaya-bay ilbeng mo yaynay ahawa mo.” ");
INSERT INTO abp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ket inawo nan Abraham ye alaga a hinabi nan Efron. Kaya-bay nanimbang ya nin apat a gatoh a mital nin omen ha alaga lan māglako. Ket in-ibyay na yati kanan Efron ha adapan lan Heteo. ");
INSERT INTO abp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Kaya-bay hiyay bangkag nan Efron ha Macpela ha dapit daya nin Mamre dayon yukib boy kakayo a hakop nin bangkag, ket napagkonin nan Abraham. Boy pinaptegan nin kaganaan a Heteo a anti ihtew a napaytipon ha dapit ilwangan nin banwa. ");
INSERT INTO abp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","In-ilbeng na yan Abraham ye bangkay nan Sara a ahawa na ha yukib a anti ha bangkag ha Macpela ha haley nin Mamre a hakop nin Canaan. Yatin lugal ket anhabtan yaynan Hebron haanin. ");
INSERT INTO abp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kaya-bay napagkonin nan Abraham ye yukib boy bangkag a konin lan Heteo hatew. Ket dinyag na yaynan pangilbengan. ");
INSERT INTO abp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Matoa yaynan tubat hatew ye Abraham boy in-inged na yan Apo Dioh ha kaganaan a dinyag na. ");
INSERT INTO abp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ha maghay mangaamot, hinabi na kanan pinakamatoan ipoh na a ampabaalaen na nin babandi na, “Ikonin mo ye gamet mo ha hilong nin paa ko. ");
INSERT INTO abp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Manumpa ka kangko ha ngalan nan Apo Dioh a Apo Namalyadi nin langit boy luta a agka mamili nin mapag-ahawa nan anak ko ha lahi lan Cananeo a ampakilugalan tawo. ");
INSERT INTO abp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Makew ka ha lugal a kinalakean ko. Ket ihtew ka mamili kanlan papaltido ko nin mapag-ahawa nan Isaac a anak ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nanepet yay ipoh, “No ahe na labay makilakew kangko ihti ye mapili ko, malyadi koya nayi ilamo ye Isaac ihtew?” ");
INSERT INTO abp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nakibat yay Abraham, “Ahe, adi moya ilakew ihtew ye anak ko. ");
INSERT INTO abp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hiyay Apo Dioh a Apo Namalyadi nin langit, pinalakew nako ihtibay ibat ha baey nan bapa ko, dayon luta lan papaltido ko. Inhumpa na kangko a ibyay na yatin lugal kanlan lalahi ko. Mangitubol yay Apo Dioh nin anghil na a mauna kamo ta-omen naka haglapan a mamili ihtew nin mapag-ahawa nan anak ko. ");
INSERT INTO abp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","No agna labay makilakew kamo ye babayin mapili mo, homain kaynan pakibatan ha humpa mo kangko. Noba adi moya an-ilakew ihtew ye anak ko!” ");
INSERT INTO abp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kaya-bay ingkonin nan ipoh ye gamet na ha hilong nin paa nan amo na a hiyay Abraham, ket nanumpa yan humbongen nay imbilin nan amo na. ");
INSERT INTO abp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Haanin, hiyay ipoh, nangihadya yan mapo a kakamilyo. Pangayadi la yan kalgaan nin mangablin digalo, nag-aligwat yaynan palakew ha Aram Naharaim, ha banwa a angkunaan nan Nahor. ");
INSERT INTO abp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pamiabot na ha ilwah nin banwa, tinumgen yay ipoh ha haley nin libon. Ket pinatalimukod na hilay kakamilyo na. Minamahilem, ha wanabay a odah ye panlumwah lan babayin makew manayeb. ");
INSERT INTO abp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ket nakigwang ya, a wana, “Apo Dioh a Apo Namalyadi nan amo kon Abraham, haglapan moko dayin mamili nin mapag-ahawa nan anak nan amo ko. Ipakit moy kangedan mo kanan amo ko. ");
INSERT INTO abp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Anti ko ihtin ampideng ha talig nin libon. Ket anlumateng hilaynay babayin nilumwah ha banwa a makew manayeb. ");
INSERT INTO abp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ket habiyen ko lano ha magha kanla, ‘Malyadi lagin makiinom ha hinayeb mo?’ Ket no habiyen na kangko, ‘Awo, malyadi kan minom boy painomen ko hila met ye kakamilyo mo’, ket no wana, hiyabay ana ye babayin intaladan mo a mapag-ahawa nan Isaac a ipoh mo. Ha wanabay a papadan, ket matandaan ko a impakit moy kangedan mo kanan amo ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Legan ampakigwang yay ipoh, nilumateng ya ihtew ye Rebeka a ampanlonto nin halaw. Hiyay Rebeka, anak na yan Betuel boy apo na yan Milca a ahawa nan Nahor a katongno nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Maada yay Rebeka boy balatang ya po. Ket nakew ya ha libon boy pinno nay halaw na. Ha an-umalih yayna, ");
INSERT INTO abp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","dinandan na yan ipoh boy hinabi na kana, “Malyadi lagin makiinom ha hinayeb mo?” ");
INSERT INTO abp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Awo kaka,” wanan Rebeka. Tampol nan in-aypa ye halaw na, ket pinainom na yay ipoh nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ha nayadi yaynan ninom ye ipoh, hinabi nan balatang, “Painomen ko hila met ye kakamilyo mo angga ha mapainom ko hilan kaganaan.” ");
INSERT INTO abp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tampol nan imbohboh ye lanom ha paminoman ayop. Ket pag-udong-udong naynan nanayeb angga ha napainom na hilan kaganaan ye kakamilyo nan ipoh. ");
INSERT INTO abp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Hiyay ipoh, an-imatonan na yay balatang ha andiyagen na. Labay nan matandaan no hiyay na lagi ye pakibat nan Apo Dioh ha pakigwang na ha pamakew na ihtew. ");
INSERT INTO abp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pangayadi lan ninom ye kakamilyo, in-ilwah nan ipoh ye kaget na a mablin tingga boy luway polhila a balitok, ket in-ibyay na kanan balatang. ");
INSERT INTO abp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Haanin, tinepet na yan ipoh ye babayi, “Ayay bapa mo? Malyadi kayi lawen makidagoh ha baey nan bapa mo haanin a madeglem?” ");
INSERT INTO abp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nakibat yay babayi, “Hiyay ngalan nan bapa ko ket Betuel a anak lan Nahor boy Milca. ");
INSERT INTO abp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Malyadi kawon mamalabah nin madeglem ha baey mi boy main met dayami ihtew boy main met makan nin kamilyo.” ");
INSERT INTO abp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Haanin, nanalimukod yay ipoh, ket nanggalang ya kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Hinabi na, “Galangen yay Apo Dioh, a Apo Namalyadi nan amo kon Abraham! Lanang nan an-ipakit ye kangedan na kanan amo ko. Inggaygay na kon umabot ha baey nan katongno nan amo ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hiyay Rebeka, magagah yan nuli, ket imbalita na kanlan kabaey nan indo na ye kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Hiyay Rebeka, ket main yan katongnon laki a nagngalan Laban. Nayew yay Laban palakew kanan ipoh nan Abraham ihtew ha libon. ");
INSERT INTO abp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Pamakange nan Laban nin kaganaan a hinabi nan katongno na a Rebeka boy ha nakit na ye tingga boy hiyay luway polhila a balitok a anti ha takyay na, nayew yan nakew kanan ipoh nan Abraham a ampideng ha talig nin kakamilyo na ha haley nin libon. ");
INSERT INTO abp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hinabi nan Laban, “Kadi! Hika ye in-inged nan Apo Dioh. Taket nayi ta pamipideng mo po ihen? Tayna ha baey mi. Nakataladan ana ye hilid pagpainawaan mo boy hiyay pohton kunaan nin kakamilyo mo.” ");
INSERT INTO abp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ket nakilakew yay ipoh nan Abraham kanan Laban. Pamilateng la ha baey, inlumbah nan Laban ye kakalga nin kakamilyo haka na hilan binyanan nin dayami boy makan ye kakamilyo. Binyan naya met nin lanom ye ipoh boy kalalamoan na a panguyah nin bibitih la. ");
INSERT INTO abp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Inapagan na yan pamangan ye ipoh nan Abraham, noba hinabi nan ipoh, “Habiyen ko po muna ye tikih ko bayo ko mangan.” “Higi, habiyen moyna,” wanan Laban. ");
INSERT INTO abp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hinabi nan ipoh, “Ipoh na kon Abraham. ");
INSERT INTO abp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Luhbo na yan in-inged Apo Dioh ye amo ko. Ket tubat yaynan mabatnang haanin. Pinalabong nay tutupa, kakambing boy babaka na. Binyanan naya po nin malabong a mital boy balitok, iipoh a babayi boy lalaki, kakamilyo boy aahno. ");
INSERT INTO abp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Agya matoa yaynay ahawa nan amo ko a hiyay Sara, ket nanganak ya po ateed nin laki kanan Abraham. Ket in-ibyay nan Abraham ye kaganaan a babandi na kananyatin anak na a laki. ");
INSERT INTO abp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pinahumpa na kon amo ko a humbongen koy bilin na, a wana, ‘Adi ka mamili nin mapag-ahawa nan anak ko ha lugal a Canaan a ampakilugalan tawo haanin. ");
INSERT INTO abp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","No aliwan makew ka ha lugal lan bapa ko boy papaltido ko, ket ihtew ka mamili nin mapag-ahawa nan anak ko.’ ");
INSERT INTO abp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tinepet ko yay amo ko, ‘Way-omen nayi no agna labay ye makilakew?’ ");
INSERT INTO abp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hinabi nan amo ko, ‘Hiyay Apo Dioh a lanang kon anhumbongen, ket mangitubol yan anghil na a manlamo kamo a makew kanlan papaltido nan bapa ko. Hiyabay ye managlap kamo ha pamili mon babayin mapag-ahawa nan anak ko. ");
INSERT INTO abp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","No makew ka kanlan papaltido ko, ket ahe la ipaluboh a mapag-ahawa nin anak ko ye anak la, homain kaynan pakibatan ha humpa mo kangko.’ ” ");
INSERT INTO abp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Kaya-bay pamiabot ko ha haley nin libon nangon, nakigwang ako, ‘Apo Dioh a Dioh nan amo kon Abraham, haglapan moko dayin mamili nin mapag-ahawa nan anak nan amo ko. ");
INSERT INTO abp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Anti ko ihtin ampideng ha talig nin libon. No lumateng yay balatang a manayeb, ket makiinom ako kana. ");
INSERT INTO abp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ket no habiyen na, “Awo, minom ka boy painomen ko hila po ye kakamilyo mo”, hiyabay ana ye babayin intaladan mo a mapag-ahawa nan anak nan amo ko.’ ” ");
INSERT INTO abp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ket legan ampakigwang ako, nilumateng yay Rebeka a ampanlonto nin halaw. Nakew ya ha libon boy nanayeb yan lanom. Hinabi ko kana, ‘Malyadi lagi ye makiinom?’ ");
INSERT INTO abp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tampol na yan in-aypa ye halaw na, a wana, ‘Awo, boy painomen ko hila po ye kakamilyo mo.’ ");
INSERT INTO abp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Haanin, tinepet koya, ‘Ayay bapa mo?’ Hinabi na, ‘Hiyay bapa ko ket hiyay Betuel a anak lan miahawan Nahor boy Milca.’ Ket tininggaan ko ye balungoh na boy pinahootan ko yan polhila ye takyay na. ");
INSERT INTO abp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Niyumoko akon nanggalang kanan Apo Dioh a Apo Namalyadi nan amo kon Abraham. Inggaygay nako ha huhton lugal. Ket ihti ko yan nakitan ye anak nin paltido nan amo ko a mapag-ahawa nan anak nan amo ko. ");
INSERT INTO abp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ket haanin, labay kon matandaan no ipakit yoy kangedan yo kanan amo ko. Habiyen yoyna kangko ta-omen ko matandaan no hinyay diyagen ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nakibat hilay mitabapa a Betuel boy Laban, “Yati ye peteg a kalabayan nan Apo Dioh. Kaya-bay homain kayinan mahabi. ");
INSERT INTO abp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ti ye yay Rebeka. Ilamo moya ha pamuli mo ta-omen naya mapag-ahawa nin anak nan amo mo a omen ha hinabi nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pamakange nan ipoh, nanalimukod yan nanggalang kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ket in-ilwah nan ipoh ye kaget na a babado boy aalahah a yadi ha mital boy balitok, ket in-ibyay na kanan Rebeka. Binyanan na hila met nin mangablin digalo ye Laban a katongno nan Rebeka boy hiyay indo na. ");
INSERT INTO abp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ket haanin, nangan boy ninom hilaynay ipoh boy kalalamoan na boy ihtew hilayna natuloy kananyatew a madeglem. Ha mahanib ana, hinabi nan ipoh kanla, “Muli akoyna kanan amo ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Noba hinabi nan indo boy katongno nan Rebeka, “Paolayan mo po a kumonin yay Rebeka ihti kammi nin mapo o nangaanon mangaamot. Pangayadi, malyadi kawoynan muli.” ");
INSERT INTO abp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Noba hinabi nan ipoh, “Adi yo koynan abaen, ulita in-inged nan Apo Dioh yatin pamakew ko ihti kanyo. Palubohan yo koynan mag-udong kanan amo ko.” ");
INSERT INTO abp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Hinabi la, “Hagyaten tawo yay Rebeka, ket tepeten tawo ya no hinyay labay na.” ");
INSERT INTO abp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kaya-bay hinagyat la yay Rebeka boy tinepet laya, “Makilakew ka nayi haanin kananyatin laki?” wanla kana. “Awo, makilakew ako,” wanan Rebeka. ");
INSERT INTO abp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaya-bay hiyay Rebeka dayon māngalingay na, ket impakilakew laya kanan ipoh nan Abraham boy kalalamoan na. ");
INSERT INTO abp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bayo hilan inumalih, in-inged la yay Rebeka, a wanla, “Katongno mi, biyan naka dayin Apo Dioh nin linibo-libon lalahi. Boy hamboten la dayin lalahi mo ye kakaaway la.” ");
INSERT INTO abp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Pangayadi, hiyay Rebeka boy hiyay māngalingay na, ket hinumakay hilayna ha kakamilyo. Kaya-bay nakilakew hilayna kanan ipoh nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kananyatew a panaon, kapipilateng nan Isaac ha Negev a angkunaan na a ibat ha Beer Lahai Roi. ");
INSERT INTO abp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ha maghay madeglem, nakew yay Isaac ha bangkag ta-omen ya mangihip-ihip. Ket nakit na a main kakamilyo a anhumaley kana. ");
INSERT INTO abp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Hiyay Rebeka, legan ampanamolaw ya, nakit na yay Isaac. Kaya-bay nilumumbah ya ha kamilyo na, ");
INSERT INTO abp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ket nanepet ya kanan ipoh, “Ayatew a laki a anti ha bangkag a anhumaley kantawo?” “Hiyabay ye amo ko,” wanan ipoh. Kaya-bay kingwa nan Rebeka ye kepkep na, ket hinalimbengan nay lupa na. ");
INSERT INTO abp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hinabi nan ipoh kanan Isaac ye tungkol ha kaganaan a dinyag na. ");
INSERT INTO abp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inlamo na yan Isaac ye Rebeka ha hongab nan indo na a hiyay Sara, ket pinag-ahawa na yayna. An-adoen na yan Isaac ye ahawa na. Kaya-bay uli kanan Rebeka, ket naliwaliwa yay Isaac ha pagkamatey nan indo na. ");
INSERT INTO abp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nangahawa yan uman ye Abraham nin babayin nagngalan Ketura. ");
INSERT INTO abp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","In-anak na yay Zimran, Jokshan, Medan, Midian, Ishbak boy Shua. ");
INSERT INTO abp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Hiyay Jokshan ye bapa lan Sheba boy Dedan. Hilay lalahi nan Dedan ket hilay Asureo, Letuseo boy Leumeo. ");
INSERT INTO abp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Hilay aanak nan Midian ket hilan Efa, Efer, Hanoc, Abida boy Eldaa. Hilan kaganaan ket lalahi nan Ketura. ");
INSERT INTO abp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Impatawid nan Abraham ye kaganaan a babandi na kanan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Noba bayo yan natey, binyanan na hilan didigalo ye aanak na kanlan iipoh a ahawa na. Ket pinalakew na hila ha dapit daya ta-omen na hila mailbo kanan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Hiyay Abraham ket 175 anay taon na ha matey ya. ");
INSERT INTO abp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Matoa yaynan tubat boy matana anay nakem na ha natey ya. Ket nakalamo na hilaynay tutoa na. ");
INSERT INTO abp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","In-ilbeng la yan Isaac boy Ishmael ye bangkay nan bapa la a hiyay Abraham ha yukib a anti ha lugal a Macpela ha haley nin Mamre, ha bangkag a pagkonin nan Efron hatew a anak nan Zohar a Heteo. ");
INSERT INTO abp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yatin bangkag, ket hinaliw nan Abraham hatew kanlan Heteo. Ihtew hilan nailbeng ye Abraham boy Sara a ahawa na. ");
INSERT INTO abp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pangamatey nan Abraham, in-inged na yan Apo Dioh ye anak na a hiyay Isaac. Ket ihtew yaynan kinumonin ye Isaac ha Beer Lahai Roi. ");
INSERT INTO abp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hilayati ye lalahi nan Ishmael a anak nan Abraham kanan Hagar a taga Egipto a ipoh nan Sara. ");
INSERT INTO abp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Hilayati ye ngangalan nin aanak nan Ishmael a napaydodondon paibat ha punganay, hiyay Nebayot, Kedar, Abdeel, Mibsam, ");
INSERT INTO abp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO abp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish boy Kedema. ");
INSERT INTO abp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hilabay ye labinluwan aanak nan Ishmael a nag-ilyadin mānguna nin labinluwan lalahi na. Hiyay ngangalan la ye impangalan la ha balang lugal a angkunaan la. ");
INSERT INTO abp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hiyay Ishmael ket 137 anay taon na ha natey ya, ket nakalamo na hilaynay tutoa na. ");
INSERT INTO abp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hilay lalahi nan Ishmael, ket kinumonin hila ihtew ha lugal a anti ha pietan nin Havilah boy Shur. Mahaley yati ha dān a palakew ha Asiria boy eteb nin Egipto. Nakilbo hila kanlan kanayon a lalahi nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hilayati met ye lalahi nan Isaac a anak nan Abraham. ");
INSERT INTO abp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","40 a taon naynan Isaac ha napag-ahawa na yay Rebeka a anak nan Betuel, maghan Arameo a taga Padan Aram. Hiyay Rebeka ket katongno na yan Laban a maghan Arameo. ");
INSERT INTO abp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Hiyay Rebeka, ket baug ya. Kaya-bay impakigwang na yan Isaac. Ket lingnge na met Apo Dioh ye pakigwang nan Isaac. Ket binumuktot yay Rebeka. ");
INSERT INTO abp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kambal ye buktot na ket legan anti hila po ha bitoka nan Rebeka, ampaytudon hila. Hinabi na, “Taket ta ampaytudon hilay oongi ha bitoka ko?” Kaya-bay nanepet ya kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Hinabi nan Apo Dioh kana, “Mangibat kanlan luwan ongi mo a anti ha loob nin bitoka mo ye luway nahyon. Luway lahi nin tatao a mapaylaban. Hiyay magha ket mag-ilyadi yan makapalyadiyan dinan ha magha. Hiyay makaagat ket maghilbi ya kanan makaydeng.” ");
INSERT INTO abp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ha nanganak yaynay Rebeka ket kambal yay in-anak na. ");
INSERT INTO abp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Hiyay makaagat ket matibya ye luti na boy malabok ye laman na. Kaya-bay pinangalanan la yan Esau. ");
INSERT INTO abp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ha nilumwah yay ikalwa, anggemgeman na yay bitih nan Esau. Kaya-bay pinangalanan la yan Jacob. Kananyatew ket 60 anay taon nan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ha nilumake hilaynay kambal, nag-ilyadi yan mahipat manganop ye Esau. Kaya-bay maheheg yan anti ha lale. Hiyay Jacob met ket mal-em yan tao boy lanang yan anti ha hongab. ");
INSERT INTO abp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kalalabay na yan Isaac ye Esau, ulinan kalalabay nan kena ye angkakwa nan Esau ha pamanti na. Noba hiyay Rebeka, kalalabay naya met ye Jacob. ");
INSERT INTO abp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ha maghay mangaamot, ampamakawoto yay Jacob nin habaw a main matibya a lahi kamanya. Nilumateng yay Esau a ibat ha lale, ket nabannog yan tubat boy mabitil ya. ");
INSERT INTO abp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Hinabi na kanan Jacob, “Biyan moko dayi nin man-ipakaowto mon matibya a habaw ta mabitil akoynan tubat.” (Kaya-bay napangalanan yan Edom ye Esau.) ");
INSERT INTO abp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Hinabi nan Jacob, “Awo, biyan kata, dapot tana ibyay mo kangko ye katulidan mo bilang makaagat.” ");
INSERT INTO abp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Awo, hige,” wanan Esau. “Hinyay hilbi nin katulidan ko bilang makaagat no matey ako met nin bitil?” ");
INSERT INTO abp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Hinabi nan Jacob, “Manumpa ka po muna.” Ket nanumpa yan peteg ye Esau a ibyay na kanan Jacob ye katulidan na bilang makaagat. ");
INSERT INTO abp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ket binyanan naya met tampol nin Jacob ye Esau nin tinapay boy habaw nin matibya a lahi kamanya. Pangayadi nan nangan boy ninom, inumalih yaynan tampol ye Esau. Wanabay kakumpang kana ye alaga nin katulidan na bilang makaagat. ");
INSERT INTO abp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nagkamain ana nin bitil ihtin lugal, a omen ha nalyadi ha panaon nan Abraham. Kaya-bay nakew yay Isaac kanan Abimelec a poon lan Filisteo ha Gerar. ");
INSERT INTO abp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Napakit yay Apo Dioh kanan Isaac ket hinabi na, “Adi ka ampakew ha Egipto. Kumonin ka ha lugal a habiyen ko kamo. ");
INSERT INTO abp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ihti ka po bengat kumonin. Lamoan kata boy inged kata. Ibyay ko kamo boy kanlan lalahi mo hilatin kaganaan a lugal. Tupaden koy inhumpa ko kanan bapa mon Abraham. ");
INSERT INTO abp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Pakalabongen ko hilay lalahi mo a omen ha kalabong nin bibitoen ha luwang boy ibyay ko kanla hilatin kaganaan a lugal. Ket makauli ha lahi mo, inged ko hilay kaganaan a nanahyon ha babe-luta, ");
INSERT INTO abp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ulita hinumbong na kon Abraham boy tinupad nay kaganaan a bibilin boy aadal ko.” ");
INSERT INTO abp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kaya-bay kinumonin yayna ha Gerar ye Isaac. ");
INSERT INTO abp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tinepet la yan lalakin angkumonin ihtew ye tungkol kanan Rebeka, ket hinabi na, “Katongno koya.” Angkalimo yan maghabi kanla a ahawa naya, ta nabaan na a pateyen laya ta-omen laya makwa ye Rebeka, ta maada ya. ");
INSERT INTO abp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nabuyot yan kinumonin ye Isaac ihtew. Ha maghay mangaamot, hiyay Abimelec a poon lan Filisteo, ket nanamulaw ya ha panamulawan ket nakit na yay Isaac a an-amokien na yay Rebeka. ");
INSERT INTO abp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kaya-bay impadakit na yan tampol Abimelec ye Isaac boy hinabi na kana, “Ahawa moya met manayti ye Rebeka! Taket ta hinabi mo a katongno moya?” Hinabi nan Isaac, “Angkalimo ko, Apo, ta nabaan ko a main mamatey kangko no habiyen ko a ahawa koya.” ");
INSERT INTO abp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Hinabi nan Abimelec, “Taket ta dinyag mo yatew kammi? No main magha kanlan lalaki kammi ye manlalay kanan ahawa mo, ket hikay hangkan nin pagkahalananan mi.” ");
INSERT INTO abp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kaya-bay hiyay Abimelec, binabalaan na hilay kaganaan a tatao, a wana, “Ayaman a manyag nin maloke kanan Isaac o kanan ahawa na, ket homain hapo a pateyen ya.” ");
INSERT INTO abp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nananem yay Isaac ihtew a lugal. Ket kananyatew met ateed a taon, nakapupol yan luhbo, ulita in-inged na yan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pahulong yan inumando ha pagbi-ay na anggan ha binumatnang yaynan tubat. ");
INSERT INTO abp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Naibeg hilay Filisteo kana, ta malabong anan tubat ye tutupa, kakambing boy babaka, dayon iipoh na. ");
INSERT INTO abp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kaya-bay tinagpenan lan Filisteo ye lilibon a kinali lan iipoh nan Abraham hatew ha angkabi-ay ya po. ");
INSERT INTO abp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Haanin, hinabi nan Abimelec kanan Isaac, “Umalih kayna ihti kammi, ulita igit kaynan makapalyadiyan dinan mi.” ");
INSERT INTO abp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kaya-bay inumalih yay Isaac ihtew a lugal, ket nakew yan kinumonin ha pilkongan nin Gerar. ");
INSERT INTO abp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ha angkabi-ay ya po ye Abraham, namakali yan lilibon kanlan iipoh na. Noba ha natey yayna, tinagpenan lan Filisteo. Kaya-bay impakali na yan uman Isaac hilatin lilibon. Ket hilatin lilibon, pinangalanan na nin omen ateed ha impangalan nan bapa na a Abraham hatew. ");
INSERT INTO abp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ha maghay mangaamot, nangali hilay iipoh nan Isaac nin libon ha pilkongan, ket nakatuklah hila nin hubol. ");
INSERT INTO abp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Noba nakingatngat hilay māgpahtol a taga Gerar kanlan iipoh nan Isaac, a wanla, “Kammi yatin hubol!” Kaya-bay yatew a libon, ket pinangalanan nan Isaac nin “Esek”, ulita nakingatngat hila kana ye taga Gerar. ");
INSERT INTO abp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Haanin, nangali hilan uman ye iipoh nan Isaac nin kanayon a libon, noba nayngatngatan lay naman nin taga Gerar. Kaya-bay pinangalanan laya met ye libon nin Sitnah. ");
INSERT INTO abp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Inalihan lan Isaac yatew a lugal, ket nakew hila ha kanayon a lugal. Nangali hilayna man nin kanayon a libon. Ket ahe layna pinayngatngatan. Kaya-bay pinangalanan nan Isaac nin “Rehobot.” Hinabi na, “Binyan na kitawon Apo Dioh nin maway a lugal, ket umando boy lumabong kitawo ihtin lugal.” ");
INSERT INTO abp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ha ahe nabuyot, inumalih yay Isaac ihtew a lugal, ket nakew ya ha Beer Sheba. ");
INSERT INTO abp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ket kananyatew a madeglem, napakit yay Apo Dioh kana boy hinabi na, “Hiko ye Dioh nan bapa mo a hiyay Abraham. Adi ka angkalimo, ta kalamo moko. Inged kata boy pakalabongen ko hilay lalahi mo uli kanan Abraham a ipoh ko.” ");
INSERT INTO abp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kaya-bay nanyag yay Isaac nin pangihagpaan ihtew boy nanggalang ya kanan Apo Dioh. Ket ihtew hilan nagpondo. Ket hilay iipoh na, nangali hilan uman nin libon ihtew. ");
INSERT INTO abp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kananyatew met ateed a panaon, nakew yay Abimelec kanan Isaac ibat ha Gerar kalamo na yay Ahuzat a māmabala na boy hiyay Picol a mānguna nin huhundaloh na. ");
INSERT INTO abp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tinepet na yan Isaac, “Taket ta nilakew moko? Aliwa nayi a angkapoot ka kangko boy pinaalih moko ha lugal yo?” ");
INSERT INTO abp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Hinabi la, “Makinang ana kammi haanin a kalamo mo yay Apo Dioh. Kaya-bay labay min manyag kitawo nin kahundoan. Payhumpaan tawo a ");
INSERT INTO abp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","adi ka manyag nin maloke kammi a omen ha ahe mi pangipaloke kamo hatew ha anti ka po ha lugal mi boy pinaalih mi kan main katanaan. Ket haanin, an-inged na kan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kaya-bay nagpahayaghag yay Isaac. Ket nangan boy ninom hila. ");
INSERT INTO abp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kabekahan ha mahanib-hanib po, nayhumpa hila. Pangayadi, nayngihyay hilaynan main katanaan. ");
INSERT INTO abp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kananyatew met ateed a mangaamot, imbalita lan iipoh nan Isaac kana ye tungkol ha angkaliyen la a libon. Hinabi la kana, “Nakatuklah kayi nin lanom!” ");
INSERT INTO abp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ket pinangalanan nan Isaac yain a libon nin Shiba. Kaya-bay angga haanin, anhabtan la yan Beer Sheba yatew a banwa. ");
INSERT INTO abp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","40 anay taon nan Esau ha napag-ahawa na yay Judit a anak nan Beeri a maghan Heteo boy hiyay Basemat a anak nan Elon a magha met a Heteo. ");
INSERT INTO abp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Hilatin luwan babayi ye hangkan nin kalelean nan Isaac boy Rebeka. ");
INSERT INTO abp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Hiyay Isaac ket matoayna boy makolapo yaynay pamilew na. Ha maghay mangaamot, impadakit na yay makaagat a anak na a hiyay Esau. Hinabi na, “Anak ko.” Nakibat yay Esau, “Anti ko ihti, tatang.” ");
INSERT INTO abp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Hinabi na kana, “Anak ko, matoa koynan tubat boy madanon akoynan matey. ");
INSERT INTO abp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kaya-bay kowen moy yawo mo, ket iakalan moko. ");
INSERT INTO abp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ket pamakawoto moko nin kalalabay kon kena boy ilakew mo kangko. Pangayadi kon mangan, inged kata bayo kon matey.” ");
INSERT INTO abp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ampanlenge ya met manayti ye Rebeka legan angkatongtongen na yan Isaac ye Esau a anak na. Kaya-bay ha nakew yaynan mangakal ye Esau, ");
INSERT INTO abp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","hinabi nan Rebeka kanan Jacob a anak na, “Nange ko a hinabi nan bapa mo kanan katongno mo a Esau, ");
INSERT INTO abp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Makew kan mangakal ket pamakawoto mo kon kalalabay kon kena ta-omen katayna mainged ha adapan nan Apo Dioh, bayo ko matey.’ ");
INSERT INTO abp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Anak ko, leng-en moko boy diyagen mo yatin habiyen ko kamo. ");
INSERT INTO abp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Makew ka ha kawan ket mangwa kan luway pinakamanged a oybon a kambing, ta pamakawoto ko yan malahap a omen ha kalalabay nan bapa mo. ");
INSERT INTO abp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Pangayadi, ilakew moy kena kanan bapa mo ta-omen naka inged bayo ya matey!” ");
INSERT INTO abp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Hinabi nan Jacob kanan indo na, “Noba malabok yay Esau, ket hiko ahe. ");
INSERT INTO abp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Way-omen no kimpaan nako? Ket matandaan nan tatang a antalingowen koya, kainghon inged nako, ket ihumpa na koyna ingat.” ");
INSERT INTO abp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hinabi nan Rebeka kanan Jacob, “Paolayan mon hikoy maihumpa no ihumpa naka! Anak ko, diyagen moyna ingat ye hinabi ko kamo. Makew kaynan mangwa nin oybon kakambing boy ilakew mo hila kangko.” ");
INSERT INTO abp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kaya-bay nakew yan nangwa nin luwan oybon kambing ye Jacob, ket inlakew na kanan indo na. Impakawoto nan Rebeka a omen ha kalalabay nan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pangayadi, kingwa nan Rebeka ye pinakamatampa a bado nan makaagat a anak na a anti ha baey la. Ket impabado na kanan makaydeng a anak na. ");
INSERT INTO abp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Pinonggoh nan Rebeka nin katat nin kakambing ye takyay dayon leey nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ket in-ibyay na kanan Jacob ye malahap a pamangan boy tinapay a impakawoto na. ");
INSERT INTO abp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hinumaley yay Jacob kanan Isaac haka na hinabi, “Tatang.” “Awo. Aya ka anak ko?” wanan Isaac. ");
INSERT INTO abp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Hinabi nan Jacob kanan bapa na, “Hiko yay Esau a makaagat mon anak. Nadyag koynay hinabi mo kangko. Ti yaynay kalalabay mon kena. Mikno kayna, ta tawayan moynay naakalan ko ta-omen mo koynan mainged.” ");
INSERT INTO abp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","“Kadudumali mo man nakakwa, anak ko?” wanan Isaac. “Hinaglapan na kon Apo Dioh mon Namalyadi,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Hinabi nan Isaac kanan Jacob, “Anak ko, humaley ka awod kangko, ta kimpaan kata ta-omen ko matandaan no hikan peteg ye anak ko a Esau.” ");
INSERT INTO abp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Hinumaley ya met ye Jacob, ket kinimpaan na yan bapa na. Ket hinabi na, “Hiyay bihnga ket bihnga nan Jacob. Noba hiyay takyay ket takyay nan Esau.” ");
INSERT INTO abp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ahe naya nabalayan Isaac ye Jacob, ulita hiyay takyay na ket malabok ya a omen kanan Esau. Ket ha inged na yayna dayi nin Isaac ye Jacob, ");
INSERT INTO abp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tinepet na yayna man, “Peteg lagin hikayna ye Esau a anak ko?” “Hikobayna, tatang,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Hinabi nan Isaac, “Anak ko, ihaley moyna kangkoy pinakawoto mo ta-omen pangayadi kon mangna, inged katayna.” Kaya-bay inggawang nan Jacob ye kena, ket pangayadi nan nangna, binyan naya po nin alak, ket ininom na. ");
INSERT INTO abp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hinabi nan Isaac kanan Jacob, “Anak ko, kuka di, ta umaan moko.” ");
INSERT INTO abp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Hinumaley yay Jacob, ket inumaan na yay bapa na. Ha nadaep nan Isaac ye bawo nin bado nan Esau, in-inged na yaynay Jacob, a wana, “Hiyay bawo nan anak ko, ket omen ya ha bawo bangkag a in-inged nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Biyan naka dayin Apo Dioh nin ambon ket mag-ilyadin mabona ye bangkag mo boy luhboy pupol boy bayon alak. ");
INSERT INTO abp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hilay nanahyon ket maghilbi boy pahakop hila dayi kamo. Mamoon ka kanlan kakatongno mo boy manalimokod hila bilang pagpahakop la kamo. Hilay mangihumpa kamo ket maihumpa hila met dayi. Ket hilay manginged kamo, minged hila met dayi.” ");
INSERT INTO abp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ha nayadi na yan in-inged Isaac ye Jacob boy ha inumalih yaynay Jacob, nilumateng yayna met ye Esau a ibat nangakal. ");
INSERT INTO abp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ket namakawoto ya met nin malahap boy inlakew na kanan bapa na. Hinabi na, “Tatang, mikno kayna, ta kena moynay naakalan ko ta-omen mo koynan inged.” ");
INSERT INTO abp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Aya ka?” wanan Isaac. “Hiko yay Esau a makaagat mon anak,” wanan Esau. ");
INSERT INTO abp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pamakange nan Isaac, namigpig yan tubat, a wana, “Aya awod ye naunan nangakal a namyay kangkon kena? Kapipiyadi kon bengat nangna nin wanabay ha nilumateng ka. In-inged ko yayna, ket homain hapo a minged yayna.” ");
INSERT INTO abp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pamakange nan Esau ha hinabi nan bapa na, nangandang yan makhaw boy malaem boy impakiiingalo na, a wana, “Tatang, inged moko met dayi!” ");
INSERT INTO abp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Noba hinabi nan Isaac kanan Esau, “Tinalingo na kon katongno mo. Kaya-bay nakwa na yay panginged a nakataladan dayi kamo.” ");
INSERT INTO abp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Hinabi nan Esau, “Nikalwa na koynan tinalingo. Kaya-bay manaytin Jacob ye ngalan na. Kingwa nayna ye katulidan ko bilang makaagat, ket haanin kingwa na po ye panginged a nakataladan kangko! Homain kayna nayi kanayon a panginged kangko?” ");
INSERT INTO abp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Hinabi nan Isaac kanan Esau, “Hinabi koyna kana a hiyaynay mamoon kamo haanin. Boy dinyag ko hilayna met a ipoh na ye kaganaan papaltido na. Boy hinabi koyna met a inged na yan Apo Dioh makauli ha malabong a pupol boy bayon alak. Kaya-bay anak ko, hinya po nayi ye malyadi kon diyagen kamo?” ");
INSERT INTO abp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Noba hinabi nan Esau kanan bapa na, “Tatang, mamagha laweh ye panginged mo? Inged moko met, Tatang.” Ket lalo na po impakakhaw ye panumangih na. ");
INSERT INTO abp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Hinabi nan Isaac kana, “Kumonin ka ha lugal a mataang ha mabona a luta boy homain ambon. ");
INSERT INTO abp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Lanang kan makilaban kanlan kanayon a tatao, boy maghilbi ka kanan katongno mo. Noba no lumaban ka kanla, ket mapalihway ka ha kapalyadiyan la.” ");
INSERT INTO abp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ket kinahulog na yan Esau ye Jacob, ulita hiyabay ye in-inged nan bapa na. Ket inihip na, “Madanon yaynan matey ye bapa ko. Lano ha matey yayna, pateyen ko yay Jacob a katongno ko!” ");
INSERT INTO abp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ha natandaan nan Rebeka ye maloke a ihip nan Esau kanan katongno na, impadakit na yan tampol ye Jacob boy hinabi na kana, “Hiyay katongno mon Esau, ket ampantaan na kan pateyen bilang pamae na kamo. ");
INSERT INTO abp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Haanin anak ko, diyagen moy habiyen ko. Umalih kaynan tampol! Makew ka ha Haran, ket ihtew ka kumonin kanan katongno kon Laban. ");
INSERT INTO abp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ihtewbay ka po kumonin angga ha maalih ye poot nan katongno mo kamo. ");
INSERT INTO abp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Lano maalih yaynay poot na boy naliwaan nayna ye dinyag mo kana, ket mangitubol akon mangipatanda kamo a malyadi kaynan mag-udong ihti. Agko labay a maahe kawon luwa kangko ha mamaghay mangaamot.” ");
INSERT INTO abp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hinabi nan Rebeka kanan Isaac, “Angkahulog ako kanlan Heteo a aahawa nan Esau. Ket no Heteo met ye mapag-ahawa nan Jacob, mamanged po a matey akoyna.” ");
INSERT INTO abp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kaya-bay impadakit na yan Isaac ye Jacob. Ket in-inged boy binilinan naya, “Adi ka ampangahawa nin babayin taga Canaan. ");
INSERT INTO abp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Makew ka ha Padan Aram, ha banwa nan aking mo a Betuel. Ket ihtew ka mamili nin babayin mapag-ahawa mo kanlan kakahinhin mo a aanak nan ama mon Laban. ");
INSERT INTO abp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Inged naka dayi nin Apo Namalyadi a Makapalyadiyan, boy palabongen na hila dayi ye lalahi mo, ket mag-ilyadi kan bapa nin malabong a nanahyon. ");
INSERT INTO abp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Inged naka dayin Apo Namalyadi, dayon lalahi mo a omen ha panginged na kanan Abraham. Ket mapagkonin mo yatin lugal a ampakilugalan mo a in-ibyay nan Apo Namalyadi kanan Abraham hatew.” ");
INSERT INTO abp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ket intubol na yan Isaac ye Jacob ha Padan Aram, ha angkunaan nan Laban a anak nan Betuel a maghan Arameo. Hiyay Laban ket katongno na yan Rebeka a indo nan Jacob boy Esau. ");
INSERT INTO abp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Natandaan nan Esau a in-inged na yan Isaac ye Jacob boy intubol naya ha Padan Aram ta-omen ya mangahawa ihtew. Boy natandaan na met Esau a pangayadi na yan in-inged Isaac ye Jacob, ket binawalan na yan mangahawa nin babayin taga Canaan. ");
INSERT INTO abp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Boy natandaan na po Esau a hinumbong nan Jacob ye bilin lan bapa boy indo na boy nakew ya ha Padan Aram. ");
INSERT INTO abp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Natandaan nan Esau a adey-adey nan bapa na a Isaac ye babayin taga Canaan a napag-ahawa na. ");
INSERT INTO abp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kaya-bay nakew ya kanan ama na a Ishmael a anak nan Abraham kanan Hagar. Ket powida kanlan luway aahawa na, nangahawa ya po nin magha, hiyay kahinhin na a hiyay Mahalat a katongno nan Nebayot a anak nan Ishmael. ");
INSERT INTO abp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Inumalih yay Jacob ha Beer Sheba boy palakew yayna ha Haran. ");
INSERT INTO abp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nitanghob yaynay mangaamot ha niabot ya ha maghay lugal, ket ihtew yaynan nikahumda. Dapah ye pinag-onan na ha pangatuloy na. ");
INSERT INTO abp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nanaynep yan aydan a paibat ha luta ket niabot ha langit ye katagay na. Ket manik monaoy hilay aanghil nan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nakit naya met ye Apo Dioh a ampideng ha babe nin aydan boy hinabi na kana, “Hiko yay Apo Dioh a Apo Namalyadi nan aking mon Abraham boy bapa mon Isaac. Yatin lugal a an-id-an mo, ket ibyay ko kamo boy kanlan lalahi mo. ");
INSERT INTO abp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Hilay lalahi mo ket omen hila lanon kalabong ha towapok ha luta. Ket mitayak hila ha kaganaan a ugoten. Makauli kamo boy ha lahi mo, minged ye kaganaan a nanahyon ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Pakaihipen mo, kalamo mo kon lanang boy ibiha kata agya way-ihtew ka man makew boy iudong katan uman ihtin lugal. Ahe kata lakwanan angga ha matupad ye kaganaan a impangako ko kamo.” ");
INSERT INTO abp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ha nakaimukat yay Jacob, hinabi na, “Anti yan peteg manayti ye Apo Dioh ihti, noba agko bengat tanda!” ");
INSERT INTO abp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nalimowan yay Jacob boy hinabi na, “Ampakalilimo yatin lugal! Yati ye angkunaan nan Apo Dioh boy ilwangan palakew ha langit.” ");
INSERT INTO abp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nihimbak yan nimata ye Jacob kananyatew a mahanib. Kingwa na yay dapah a pinag-onan na, ket impaideng naya bilang pangihipan boy binohbohan na yan ladak. ");
INSERT INTO abp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Pinangalanan na yan Betel yatew a banwa a alan lan anhabtan nin Luz. ");
INSERT INTO abp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Haanin, nanumpa yay Jacob kanan Apo Dioh, a wana, “Apo Namalyadi, no lanang mo kon lamoan boy ibiha moko kananyatin pangumodang ko boy biyan mo kon makan boy bado, ");
INSERT INTO abp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","boy makaudong a maligha ha baey nan bapa ko, ket hikayna Apo Dioh ye mag-ilyadin Apo Namalyadi ko. ");
INSERT INTO abp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ket yatin dapah a impaideng kon pangihipan ket mag-ilyadin panggalangan kamo. Boy ibyay ko kamo ye ikamapo a dakay nin kaganaan a ibyay mo kangko.” ");
INSERT INTO abp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ket nagpahulong yay Jacob ha pangumodang na angga ha nilumateng ya ha lugal lan tatao ha dapit daya. ");
INSERT INTO abp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Haanin, nakakit yan maghay libon ha bunak nin bangkag, ket ha palibot nin libon main tatloy kawan nin tutupa a ampagpainawa, ta ihtew la hilan ampainomen. Hiyay libon ket nahakeban nin mayadet a dapah. ");
INSERT INTO abp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","No anti hilaynan natipon ye kaganaan a kakawan nin tutupa ihtew, ket an-itolin laynay dapah a hakeb nin libon haka la hila painomen ye kakawan la. Pangayadi, iudong la met ateed ye dapah a ihakeb ha libon. ");
INSERT INTO abp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tinepet na hilan Jacob ye māgpahtol, “Gagayyem, taga way-ihtew kawo?” “Taga Haran kayi,” wanla. ");
INSERT INTO abp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Katatanda yoya laweh ye Laban a apo nan Nahor?” wanan Jacob. “Awo, katatanda miya,” wanla. ");
INSERT INTO abp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Way-omen yaynay Laban?” wanan Jacob. “Manged ya met,” wanla kana. “Ti yaynan andumaho ye Raquel a balatang nan Laban dayon kawan nin tutupa.” ");
INSERT INTO abp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hinabi nan Jacob, “Kaamotan po, aliwa po odah a tiponen ye tutupa. Painomen yo hila tana haka yo hilan ipahtol uman.” ");
INSERT INTO abp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Hinabi lan māgpahtol, “Yo, ahe malyadi yain. Katapulan a anti yaynan natipon ye kaganaan kawan a tutupa bayo mi itolin ye dapah a inhakeb ha libon. Pangayadi, malyadi minan painomen ye tutupa.” ");
INSERT INTO abp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Legan angkatongtongen na hilan Jacob ye māgpahtol, nilumateng ya met ye Raquel dayon kawan nan bapa na, ulita hiyabay ye ampanayhay. ");
INSERT INTO abp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pamakakit nan Jacob kanan Raquel a balatang nan ama na a Laban dayon tutupa nan Laban, ket hinumaley ya ha libon boy intolin nay hakeb a dapah. Ket pinainom na ye tutupa nan ama na a Laban. ");
INSERT INTO abp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pangayadi, inumaan na yay Raquel, ket nipatangih yan makhaw ye Jacob ha aliket na. ");
INSERT INTO abp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Hinabi nan Jacob, “Hiko yay angken nan bapa mo boy anak nan Rebeka!” Kaya-bay nipapayew yan nuli ye Raquel, ket imbalita na yati kanan bapa na. ");
INSERT INTO abp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pamakange nan Laban ye tungkol kanan Jacob a anak nan katongno na, tampol na yan hinagana. Tinakeh naya boy inumaan, ket inlakew naya ha baey la. Hinabi nan Jacob ye kaganaan a nalyadi. ");
INSERT INTO abp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Hinabi nan Laban kana, “Peteg a mamaghay puhel ta.” Ket hiyay Jacob, ihtew yayna kinumonin nin makabowan. Pangalabah nin makabowan, ");
INSERT INTO abp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","hinabi nan Laban kanan Jacob, “Aliwan manged a paobdaen katan homain upa, ulita angken kata. Habiyen mo kangko no hinyay labay mon iupa ko kamo.” ");
INSERT INTO abp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hiyay Laban ket main yan luway aanak a balatang. Hiyay ngalan nin makaagat ket Lea. Ket hiyay ngalan na met nin makaydeng ket Raquel. ");
INSERT INTO abp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Hiyay Lea ket makulaey ye mata na, noba hiyay Raquel, maaada boy mayembe ye laman na. ");
INSERT INTO abp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","An-adoen na yan Jacob ye Raquel. Kaya-bay hinabi na kanan Laban, “No ipaluboh mo a mapag-ahawa ko yay Raquel a anak mon makakaydeng, humuyo akon pitoy taon kamo.” ");
INSERT INTO abp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Hinabi nan Laban, “Mamanged po a hikay mapag-ahawa na dinan lan kanayon. Hali, ihti kayna kumonin kangko.” ");
INSERT INTO abp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Pitoy taon yan hinumuyo ye Jacob kanan Laban ta-omen na yan bengat mapag-ahawa ye Raquel, noba ba-mon anoy mangaamot bengat kanan Jacob, ulita an-adoen na yan tubat ye Raquel. ");
INSERT INTO abp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pangalabah nin pitoy taon, hinabi nan Jacob kanan Laban, “Nayadi koynay panumuyo ko kamo. Kaya-bay ibyay mo yaynay Raquel kangko ta-omen kayinan maylamo.” ");
INSERT INTO abp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kaya-bay hiyay Laban, nangihadya yan hayaghagan, ket tinipon na hilay kaganaan a angkumonin ihtew. ");
INSERT INTO abp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Noba ha madeglem ana, tana-tana hiyay Raquel ye mapagkaida nan Jacob, hiyay Lea a anak na ye impadadag nan Laban kana. ");
INSERT INTO abp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(In-ibyay naya met Laban ye Zilpa bilang babayin pag-ipoh nan Lea.) ");
INSERT INTO abp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kabekahan, natandaan nan Jacob a hiyay Lea met manayti ye napagkalamo na. Kaya-bay hinabi na kanan Laban, “Aliwan huhto ye dinyag mo kangko! Aliwa nayi a hinumuyo ako kamo ta-omen koya mapag-ahawa ye Raquel? Taket ta tinalingo moko?” ");
INSERT INTO abp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nakibat yay Laban, “Aliwa min ugali ihti a muna yan makiahawa ye makaydeng dinan ha makaagat. ");
INSERT INTO abp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Paolayan mo po a maiyadi ye maghay dominggo a pangihayaghag nin kahal mo. Pangayadi, ibyay koya met ateed kamo ye Raquel a mapag-ahawa mo, dapot tana humuyo kayna man nin pitoy taon kangko.” ");
INSERT INTO abp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Inawo naya met Jacob, ket pangayadi nin maghay dominggo nin pangihayaghag nin kahal na kanan Lea, in-ibyay na yan Laban ye Raquel kanan Jacob a mapag-ahawa na. ");
INSERT INTO abp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","In-ibyay naya met Laban ye Bilha a bilang babayin pag-ipoh nan Raquel. ");
INSERT INTO abp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kaya-bay pinagkalamo na yan Jacob ye Raquel. Maaado yay Jacob kanan Raquel dinan kanan Lea. Ket hinumuyo yayna man ye Jacob kanan Laban nin pitoy taon. ");
INSERT INTO abp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tanda nan Apo Dioh a ahe na yan an-adoen Jacob ye Lea. Kaya-bay pinalyadi nan Apo Dioh a bumuktot yay Lea, noba hiyay Raquel ket ahe. ");
INSERT INTO abp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Binumuktot yay Lea ket nanganak yan laki. Hinabi na, “Nakit nan Apo Dioh ye ampakayootan ko. Haanin, homain hapo a adoen na koynan ahawa ko.” Kaya-bay Reuben ye impangalan na ha ongi. ");
INSERT INTO abp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Binumuktot yayna man, ket laki yayna man ye in-anak na. Hinabi na, “In-ibyay na po kangkon Apo Dioh yatin anak, ta nange na a ahe nako an-adoen nin ahawa ko.” Kaya-bay pinangalanan na yan Simeon ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Binumuktot yan uman ye Lea, ket laki yayna man ye in-anak na. Hinabi na, “Homain hapo a adoen na koynan ahawa ko haanin, ta tatloy nan lalaki ye anak mi.” Kaya-bay pinangalanan na yan Levi ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Binumuktot yayna man ye Lea boy nanganak ya nin laki. Hinabi na, “Haanin, galangen ko yay Apo Dioh.” Kaya-bay pinangalanan na yan Juda. Ket paibat hatew, ahe yayna nanganak. ");
INSERT INTO abp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hiyay Raquel, homain ya po anak. Kaya-bay angkaibeg ya kanan katongno na a Lea. Ha maghay mangaamot, hinabi na kanan Jacob, “Palyadiyen mo met a magkaanak ako, ta ipatey ko no ahe ako magkaanak.” ");
INSERT INTO abp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Napoot yay Jacob kanan Raquel ket hinabi na, “Taket, Dioh ako nayi a ampanaad a magkaanak ka?” ");
INSERT INTO abp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Hinabi nan Raquel, “Ti yay Bilha a ipoh ko. Lalayen moya ta-omen ako magkamain nin anak makauli kana.” ");
INSERT INTO abp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ket in-ibyay naya kanan Jacob ye ipoh na a hiyay Bilha bilang pag-ahawa na, ket nilalay na yan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Binumuktot yay Bilha ket nanganak yan laki. ");
INSERT INTO abp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Hinabi nan Raquel, “Pinaptegan nan Apo Dioh a huhto ye dinyag ko, ta lingnge nay pakigwang ko, ket binyan na kon anak a laki.” Kaya-bay Dan ye impangalan na ha ongi. ");
INSERT INTO abp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Binumuktot yan uman ye Bilha a ipoh nan Raquel, ket nanganak yayna man nin ikalwan anak a laki. ");
INSERT INTO abp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Hinabi nan Raquel, “Tubat ye paylaban min mikatongno, ket nanambot ako.” Kaya-bay pinangalanan na yan Naftali ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ha natandaan nan Lea a ahe yayna manganak, in-ibyay na yay Zilpa a ipoh na kanan Jacob bilang pag-ahawa na, ");
INSERT INTO abp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ket nanganak yan laki ye Zilpa a ipoh nan Lea. ");
INSERT INTO abp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Hinabi nan Lea, “In-inged nako.” Kaya-bay Gad ye impangalan na ha ongi. ");
INSERT INTO abp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nanganak yan ikalwan anak a laki ye Zilpa a ipoh nan Lea. ");
INSERT INTO abp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Hinabi nan Lea, “Tubat anay kaaliketan ko! Ket haanin habtan la kon kanayon a babayi nin angkaaliket.” Kaya-bay pinangalanan na yan Asher ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Panaon anan pamupol nin tidigo hatew. Ket hiyay Reuben, nakew ya ha bangkag, ket nakakit yan ilamon a hihidet. Ket kingwa naya boy in-ibyay na kanan Lea a indo na. Ha nakit nan Raquel, hinabi na kanan Lea, “Biyan moko met dayi nin dawa nin hihidet a kaget nan anak mo.” ");
INSERT INTO abp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Hinabi nan Lea, “Ahe ka po nayi napda a nakwa mo yaynay ahawa ko, ket haanin, labay mo po kowen ye hihidet nan anak ko?” Hinabi nan Raquel, “Biyan moko nin hihidet ket makalamo mo yay Jacob haanin a madeglem.” ");
INSERT INTO abp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Madeglem ana hatew ha nilumateng yay Jacob ibat ha bangkag. Hinagana na yan Lea boy hinabi na, “Katapulan mapagkaida kata haanin a madeglem, ta binayadan kata kanan Raquel nin hihidet a kaget nan anak ko.” Kaya-bay napaglamo na yan Jacob ye Lea kananyatew a madeglem. ");
INSERT INTO abp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ket lingnge nan Apo Namalyadi ye pakigwang nan Lea, ket binumuktot ya. Ket nanganak yan ikaliman anak a laki kanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kaya-bay hinabi nan Lea, “Binyan na kon plimyo nin Apo Namalyadi ulita in-ibyay koya kanan ahawa ko ye ipoh ko.” Ket pinangalanan na yan Isacar ye anak na. ");
INSERT INTO abp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Binumuktot yayna man ye Lea, ket nanganak yan ikaanem a anak na kanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Hinabi nan Lea, “Binyanan na kon Apo Namalyadi nin plimyo! Haanin, padangalan na koynan ahawa ko, ulita anem anay lalakin aanak ko kana.” Kaya-bay pinangalanan na yan Zebulun ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pangayadi, nanganak yan babayi ye Lea, ket pinangalanan na yan Dina. ");
INSERT INTO abp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ahe naya met niliwaan Apo Namalyadi ye Raquel, ket pinalyadi na yan manginaw. ");
INSERT INTO abp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Binumuktot ya boy nanganak nin maghay laki. Ket hinabi na, “Inalih nan Apo Namalyadi ye kamading-eyan ko.” ");
INSERT INTO abp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ket pinangalanan na yan Jose ye anak na. Hinabi na, “Biyan nako po dayin Apo Dioh nin maghan anak.” ");
INSERT INTO abp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ha in-anak na yan Raquel ye Jose, hinabi nan Jacob kanan Laban, “Palubohan mo koynan muli ha lugal mi. ");
INSERT INTO abp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Palubohan mo met a iuli ko hilaynay aahawa ko boy hilay aanak ko, ulita pinaghilbiyan ko hila kamo. Tanda moyna bay met no way-omen kabuyot ye panumuyo ko kamo uli kanla. Ket haanin, umalih kayina.” ");
INSERT INTO abp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Hinabi nan Laban, “No malyadi dayi, ihti ka po. Ta makauli ha paltep, natandaan ko a an-inged na kon Apo Dioh uli kamo. ");
INSERT INTO abp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Habiyen mo bengat no anoy iupa ko kamo, ket ibyay ko kamo.” ");
INSERT INTO abp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Hinabi nan Jacob, “Tanda mo no way-omen ako nanuyo kamo boy no way-omen hilan nilumabong ye aayop mo uli ha panayhay ko kanla. ");
INSERT INTO abp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nangaano hilan bengat ha nilumateng ako ihti ket haanin, malabong hilaynan tubat. In-inged na kan Apo Dioh agya way-ihtew ako. Ket haanin, katapulan a kalingayen ko hilayna met ye pamilya ko.” ");
INSERT INTO abp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hinabi nan Laban, “Hinya awod ye labay mon iupa ko kamo?” Hinabi nan Jacob, “Ahe mo koyna katapulan upaan. Pahulong ko hilan hayhayen ye kakawan ayop mo, no umayon ka ha habiyen ko kamo. ");
INSERT INTO abp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Palubohan mo kon lakwen ko haanin ye kawan mo, ket ilbo koy kaganaan a bayakan a tupa dayon mangitit a oybon tupa boy kaganaan a bayakan a kakambing. Hilayatew ye iupa mo kangko. ");
INSERT INTO abp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ha lumateng ye panaon, mataloh mon matandaan no mapatayaan ako o ahe. No bilewen mo hilay in-upa mo kangko a tutupa boy kakambing, ket no main kan makit a aliwan mangitit o bayakan, mahabi mon tinakaw ko hila kamo.” ");
INSERT INTO abp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Manged yain! Wanabay awod ye diyagen ta,” wanan Laban. ");
INSERT INTO abp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Noba kananyatew met ateed a mangaamot, in-ilbo nan Laban ye kaganaan a kambing a bayakan, laki man o babayi. In-ilbo na po Laban ye tutupa a mangitit. Ket impapahtol na hilayati kanlan aanak na a lalaki. ");
INSERT INTO abp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ket intaang na hilan Laban ye aayop na kanan Jacob. Kinumodang hila nin tatloy mangaamot pataang kanan Jacob. Ket hiyay nipatla anan bengat ha kawan a anhayhayen nan Jacob ye imbantak nan Laban kana. ");
INSERT INTO abp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ket hiyay Jacob, namotoh ya met nin hadiwa a hanga nin kakayo a alamo, almendra boy kastanyo haka na yan tinatapyahan a main pietan ta-omen ya ba-mon bayakan. ");
INSERT INTO abp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pangayadi, ingkonin na ye ba-mon bayakan a kayo ha adapan nin paminoman nin kakawan ta-omen la makit nin ampagmaya tepe minom hila ihtew. ");
INSERT INTO abp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","No haklangan la hilaynay ampagmaya ha adapan nin kayon ba-mon bayakan, ket ampanganak hila met nin bayakan. ");
INSERT INTO abp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","In-ilbo na hilay oybon tupa, noba hilay napatla, legan anhaklangan lay ampagmaya, pinaadap na kanlan bayakan boy mangitit a aayop nan Laban. Kaya-bay nakatipon yay Jacob nin hadili nan kawan, ket ahe na hilayna impakilamo ha kawan nan Laban. ");
INSERT INTO abp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","No anhaklangan nin bobolog hilay ampagmaya a mangataba a aayop, an-ikonin nan tampol Jacob ye bayakan a hanga nin kayo ha paminoman ha adapan la. ");
INSERT INTO abp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Noba no anhaklangan la hilay mangabeng a ayop, ket ahe na yan an-ikonin ye ba-mon bayakan a hanga nin kayo ha adapan la. Kaya-bay mangataba hilay kawan nan Jacob, noba hilay kanan Laban ket mangabeng. ");
INSERT INTO abp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kaya-bay binumatnang yan tubat ye Jacob. Nilumabong ye kawan na boy hilay iipoh na dayon kakamilyo boy aahno na. ");
INSERT INTO abp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nabalitaan nan Jacob a anhabiyen nin babayaw na, “Hinamham nan Jacob ye kaganaan a babandi nan bapa tawo. Kaya-bay binumatnang ya.” ");
INSERT INTO abp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Naimatonan na met Jacob a aliwaynan omen ha alan ye pamakilamo nan Laban kana. ");
INSERT INTO abp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hinabi nan Apo Dioh kanan Jacob, “Mag-udong kayna ha lugal lan nangaunan tutoa mo boy kanlan papaltido mo, ket lamoan kata.” ");
INSERT INTO abp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nangitubol yay Jacob nin mangihabi kanan Raquel boy Lea a mayngingikit hila ihtew ha ampagpahtolan na. ");
INSERT INTO abp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ha anti hilayna ihtew, hinabi na kanla, “Naimatonan kon lumbo anay pamakilamo nan bapa yo kangko, aliwaynan omen ha alan. Noba anlamoan na kon Dioh nan bapa ko. ");
INSERT INTO abp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tanda yo a in-ibyay koy kaganaan a mababa ko ha panumuyo ko kanan bapa yo. ");
INSERT INTO abp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Noba nikano na koynan kinuhit. Mapo anan ukdo a inuman nay napaykahundoan min upa ko. Noba ahe na impaluboh Apo Dioh a mapahakitan na kon bapa yo. ");
INSERT INTO abp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ha hinabi nan Laban a hiyay iupa na kangko ket hilay bayakan a ayop, ket pawa bayakan ye an-ianak nin kawan. ");
INSERT INTO abp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kaya-bay inalih nan Apo Namalyadi ye aayop nan bapa yo, ket in-ibyay na kangko.” ");
INSERT INTO abp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ha panaon nin anhaklangan lay aayop, nanaynep ako. Nakit ko ha taynep ko a pawa bayakan hilay bobolog a kambing. ");
INSERT INTO abp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ha taynep ko, hinabi nin anghil nin Dioh kangko, ‘Jacob,’ wana. ‘Anti ko ihti, Apo,’ wangko met kana. ");
INSERT INTO abp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Hinabi na met kangko nin anghil, ‘Bilewen mo! Hilay kaganaan a bolog a kambing ket anhaklangan la hilay pawa bayakan. Dinyag ko yati ulita nakit ko ye kaganaan a didinyag nan Laban kamo. ");
INSERT INTO abp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Hiko ye Apo Namalyadi a napakit kamo ha Betel. Ihtew ka nanumpa kangko boy binohbohan mon ladak ye maghay dapah a impaideng mo bilang pangihipan. Haanin, mag-aligwat ka, ket alihan moyna yatin lugal. Mag-udong kayna ha lugal a kinaanakan mo.’ ” ");
INSERT INTO abp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hinabi na met Raquel boy Lea, “Homain kayinan matawid kanan tatang. ");
INSERT INTO abp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","An-ibilang na kayinan dayohan. Aliwan bengat inlako na kayi kamo, no aliwan in-uboh na po ye napaglakoan na kammi. ");
INSERT INTO abp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Homain hapo a hiyay kaganaan a babandin inalih nan Apo Namalyadi kanan tatang, ket konin mi boy kanlan aanak mi. Kaya-bay humbongen moy hinabi nan Apo Namalyadi kamo.” ");
INSERT INTO abp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Inhakay na hila ha kakamilyo ye aahawa na boy aanak na. ");
INSERT INTO abp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Imbalunbon nay kaganaan a kawan na boy kinaget nay kaganaan a babandin natipon na ha Padan Aram. Ket nag-aligwat hilaynan palakew ha Canaan a lugal nan bapa na a Isaac. ");
INSERT INTO abp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Noba bayo hilan umalih boy nigena met a nakew yan nangodog nin tupa na ye Laban, tinakaw nan Raquel ye kakalintatao a andiohen nan bapa na. ");
INSERT INTO abp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Tinalingo naya met Jacob ye Laban a Arameo, ta ahe na impatanda kana ye pangumalih na. ");
INSERT INTO abp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tinumakah yay Jacob, kaget nay kaganaan a babandi na. Nilipay lay kabatowan Eufrates palakew ha mamapantay nin Gilead. ");
INSERT INTO abp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Pangalabah nin tatloy mangaamot, nabalitaan nan Laban a tinumakah ye Jacob. ");
INSERT INTO abp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kaya-bay hinagyat na hilay papaltido na, ta kamaten la yay Jacob. Pangalabah nin piton mangaamot, nabunan la yay Jacob ha mamapantay nin Gilead. ");
INSERT INTO abp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ket kananyatew a madeglem, hinabi nan Apo Namalyadi kanan Laban a Arameo ha taynep na, a wana, “Mag-alla ka! Adi moya ampantaan ye Jacob.” ");
INSERT INTO abp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ha nabonan na yan Laban hilan Jacob, nakapondo hilayna ha mamapantay nin Gilead. Ihtew ya met nagpondo ye Laban lamo na hilay papaltido na. ");
INSERT INTO abp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hinabi nan Laban kanan Jacob, “Taket ta dinyag mo yati kangko? Tinalingo moko boy intakah mo hilan ba-mon kapyol ye aanak ko. ");
INSERT INTO abp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Taket ta tinalingo moko boy inumalih kan ahe nagpatanid kangko? In-atel katawo dayi a main hayaghagan, kantaan boy tigtigan nin kahingkahing boy gitada. ");
INSERT INTO abp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ahe mo koyna met pinalubohan a maumaan ko hilay aanak boy aapo ko bayo hilan umalih. Kamotawan ye dinyag mo. ");
INSERT INTO abp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Malyadi katan pahakitan, noba ahe ko diyagen yain. Ta nadeglem hinabi na kangkon Apo Namalyadi nan bapa mo a ahe kata ampantaan. ");
INSERT INTO abp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tanda kon makauli-uli kayna. Noba taket ta tinakaw mo hila po ye kakalintataon andiohen ko?” ");
INSERT INTO abp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nakibat yay Jacob kanan Laban, “Nalimo ko, ta nabaan kon piliten mo hilan kowen ye aanak mon babayi. ");
INSERT INTO abp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Noba no makit mo yay kakalintatao mo ha agya ayaman kammi, pateyen ya. Hilay papaltido tan anti ihti ye manihtigo. Bilewen mo no main kan makit a konin mo, ket kowen mo.” Ahe na tanda Jacob a hiyay Raquel met manayti ye nangwa nin kakalintataon andiohen nan Laban. ");
INSERT INTO abp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tinapol nan Laban ye kakalintataon andiohen na ha hongab nan Jacob boy hongab nan Lea dayon hongab lan luway iipoh a babayi, noba homain yan nakitan. Pangayadi, nilumoob ya met ha hongab nan Raquel, ");
INSERT INTO abp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","noba naitayo naynan Raquel ye kakalintatao ha kubot a pangapay ha kamilyo, ket iniknoan naya. Pinakatapol na yan manged Laban ha hongab, noba homain yan nakitan. ");
INSERT INTO abp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Hinabi nan Raquel kanan bapa na, “Tatang, adi ka dayi mapoot kangko no ahe ako makaideng ha adapan mo, ulita andayaen ako.” Pahulong yan nanapol ye Laban, noba ahe naya nakitan ye kakalintatao na. ");
INSERT INTO abp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Magaynan lumtoh ye pagaw nan Jacob uli ha tubat a poot na. Tinepet na yay Laban, “Hinya nayi ye kahalanan ko? Nakadyag ako nayi nin maloke kamo? Taket ta kinamat moko? ");
INSERT INTO abp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","No main ka man nakitan a konin yo ha ayaman kammi, ipakit moyna ha adapan lan papaltido ko boy papaltido mo ket hilaynay baala a manuhga kanta! ");
INSERT INTO abp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","20 a taon kitawon napaylamo. Ket kananyatew a panaon, agya nakanoman ket homain nakwaan kanlan tutupa boy kakambing mo. Ket agya maghay tupan bolog ha kawan mo, homain akon kinna. ");
INSERT INTO abp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","No main tupa a pinatey nin ayop tawon, ket ahe koyna an-ipakit kamo no aliwan anhagiliyan ko yan tampol. Pinilit mon pinabayadan kangko ye hinyaman a natakaw ha madeglem man o mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Wanae ye kahahaad ko. Nabuyot a panaon a tineeh koy tubat a amot ha mangaamot boy lay-ep ha madeglem. Lanang kulang ye pangatuloy ko. ");
INSERT INTO abp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yain ye nadihaan ko ha loob nin 20 a taon a pangumonin ko kanyo. 14 a taon akon hinumoyo kamo, uli kanlan luway aanak mon babayi boy hilatin aayop a in-upa mo kangko ket 6 a taon ko hilan hinuyoan kamo. Noba hiyay dinyag mo kangko, mapo a ukdo mon inuman ye huhton iupa mo kangko. ");
INSERT INTO abp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Noba nilamoan na kon Apo Namalyadi a Namalyadi nan bapa ko, a Namalyadi nan Abraham a anggalangen nan Isaac. No aliwa dayin wanabay, homain hapo a intaboy mo kon homain hinyaman a kaget. Noba nakit nan Apo Namalyadi ye kaidapan a nadihaan ko boy hiyay pag-idap ko ha pag-obda. Kaya-bay nadeglem hinaad na kan Apo Namalyadi.” ");
INSERT INTO abp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Hinabi nan Laban kanan Jacob, “Hilayain a babayi, aanak ko. Hilayain a aanak, aapo ko. Hilayain a kakawan, kakawan ko. Hilayain kaganaan ket kangko. Noba hinya po ye madyag ko haanin? ");
INSERT INTO abp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kaya-bay mamanged po, manyag kita tana nin kahundoan. Mangipaideng kitawon dapah bilang pangihipan ha kahundoan ta.” ");
INSERT INTO abp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kaya-bay nanapol yay Jacob nin mayadet a dapah, ket impaideng na bilang pangihipan. ");
INSERT INTO abp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Hinabi nan Jacob kanlan papaltido na, “Manipon kawon dadapah.” Kaya-bay nanipon hilan dadapah ye papaltido nan Jacob boy imbonton la. Ket ihtew hila nangan Jacob, Laban boy papaltido la ha haley nin imbonton a dadapah. ");
INSERT INTO abp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ket hilatin imbonton a dadapah, hinabtan na yan Laban nin Jegar Sahaduta noba hiyay Jacob, hinabtan naya met nin Galeed. ");
INSERT INTO abp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Hinabi nan Laban, “Hilatin imbonton a dapah ye pangihipan kanta nin kahundoan ta kananyatin mangaamot.” Kaya-bay hinabtan na yan Galeed. ");
INSERT INTO abp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Anhabtan ya met nin Mizpa yatew a lugal ulita hinabi nan Laban, “Legan ampaykataang kita, bantayan na kitawo dayin Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","No pahakitan mo hilay aanak ko, o mangahawa ka po nin kanayon, pakaihipen mo a agya homain taon ampakakit, hiyay Apo Dioh ye māmapteg nin kahundoan ta.” ");
INSERT INTO abp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hinabi na po Laban kanan Jacob, “Anti ya ha pietan ta ye nabonton a dadapah boy anti ya met ye impaideng a dapah. ");
INSERT INTO abp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Hilayatin imbonton a dadapah boy yatin dapah a impaideng ye pangihipan. Hilayati ye dōn nin lugal ta ta-omen ahe kita mapayloob. ");
INSERT INTO abp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hiyay Apo Namalyadi nan Abraham, hiyay Apo Namalyadi nan Nahor boy hiyay Apo Namalyadi nan bapa la a hiyay Tera ye manuhga dayi kanta.” Ket nanumpa yay Jacob ha ngalan nan Apo Namalyadi a anggalangen nan bapa na a hiyay Isaac. ");
INSERT INTO abp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hiyay Jacob, namatey yan ayop bilang hagpa kanan Apo Namalyadi ihtew ha mamapantay. Pangayadi lan nangan Laban boy papaltido la, ket ihtew hilayna met nikahumda. ");
INSERT INTO abp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kabekahan, ha mahanib-hanib po, nimata yaynay Laban, ket inumaan na hila in-inged ye aanak na boy aapo na, ket nagtige yaynan pauli ha baey na. ");
INSERT INTO abp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Legan ampagpahulong hilan Jacob ha pangumodang la, ket hinagana hilan aanghil nan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pamakakit nan Jacob kanla, hinabi na, “Yati ye pondowan lan huhundaloh nan Apo Namalyadi.” Kaya-bay pinangalanan na yan Mahanaim yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hiyay Jacob, nangitubol yan nangaanon tatao na a makew kanan katongno na a Esau ha lugal a Seir a hakop nin Edom. ");
INSERT INTO abp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wanae ye impahabi na kanlan tatao na, “Kaka, hiko yay Jacob a ali mo, ampagmakaaypa a māghilbi mo. Nabuyot akon kinumonin kanan ama tan Laban. Ket haanin akon bengat muli. ");
INSERT INTO abp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Malabong hilay babaka ko, aahno, tutupa, kakambing, boy lalaki boy babayin iipoh. Haanin, impauna kon impabalita kamo, kaka ko, ta-omen mo koyna tanggapen.” ");
INSERT INTO abp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ha pag-udong lan intubol nan Jacob, hinabi la, “Niabot kayina kanan katongno mo a Esau. Ket haanin, anti yayna ha dān palakew ihti a managana kamo, kalamo nay 400 a lalaki.” ");
INSERT INTO abp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nalimowan yan tubat ye Jacob boy nahindak ya. Kaya-bay pinayluwa na hilan pangkat ye tatao na dayon tutupa, babaka, kakambing boy kakamilyo na. ");
INSERT INTO abp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ta an-ihipen na, “No dawohongen na yan Esau ye maghay pangkat, ket makatakah ye maghay pangkat.” ");
INSERT INTO abp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ket nakigwang yay Jacob, “Apo Namalyadi nan aking kon Abraham a Apo Namalyadi na met bapa kon Isaac, hinabi mo a mag-udong akoyna ha lugal lan tutoa ko boy papaltido ko, boy inged moko. ");
INSERT INTO abp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Aliwa kon katanggap-tanggap ha kaganaan a kangedan boy kapatayaan mo kangko a ipoh mo. Ha nilumipay ako ha kabatowan Jordan, ket homain akon kaget no aliwan teken bengat. Noba haanin, ha pag-udong koyna, ket luwaynay pangkat ko. ");
INSERT INTO abp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","An-ipakigwang ko a iligtah moko dayi kanan katongno kon Esau. Ta angkalimo ko a maka dawohongen na kon pateyen dayon hilay aahawa ko boy aanak ko. ");
INSERT INTO abp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Impangako mo po kangko Apo a pawa manganged ye diyagen mo kangko. Hinabi mo po a palabongen mo ye lalahi ko a omen ha kalabong nin langhi ha ambay dagat a ahe makwan bilangen.” ");
INSERT INTO abp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kananyatew a madeglem, ihtew yan natuloy ye Jacob. Kabekahan, namili ya nin aayop a idigalo na kanan Esau a katongno na. ");
INSERT INTO abp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Namili ya nin 200 a babayin kambing boy 20 a bolog a kambing, 200 a babayin tupa boy 20 a bolog a tupa, ");
INSERT INTO abp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 a ampamahuhon kamilyo dayon ooybon la, 40 a babayin baka boy 10 a bolog a baka boy 20 a babayin ahno boy 10 a lalakin ahno. ");
INSERT INTO abp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ket impabaala na kanlan iipoh na ye balang pangkat nin aayop. Hinabi na kanla, “Mauna kawo kangko boy maytaang-taang ye balang pangkat.” ");
INSERT INTO abp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hinabi nan Jacob ha naunan ipoh, “No mahagana mo yay katongno ko a Esau, ket tepeten naka, ‘Ayay nag-ipoh kanyo? Way-ihtew kawo makew? Ayay nagkonin kanlan hilatin aayop a an-ibalunbon mo?’ ");
INSERT INTO abp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","habiyen mo, ‘Konin nan ipoh mo a hiyay Jacob. Impaatel na hilayati a idigalo na kamo a kaka na. Ket anti ya ha huyot mi.’ ” ");
INSERT INTO abp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Wanabay met ye hinabi na ha ikalwa, ikatlo boy kanlan kaganaan a ipoh a ampangibalonbon ha kawan. ");
INSERT INTO abp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Hinabi na po kanla, “Adi yo anliwaan a habiyen a anti yay Jacob a ipoh mo, a angkahuyot a anhumumbong kammi.” Ta an-ihipen nan Jacob a no makit nan Esau ye idigalo na kana, ket tanggapen na yayna. ");
INSERT INTO abp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kaya-bay hiyay Jacob, impauna nay idigalo na, noba kananyatew a madeglem, nagbantak ya ha pondowan la. ");
INSERT INTO abp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kananyatew met ateed a madeglem, nimata yay Jacob, ket inlipay na hila ha kabatowan Jabok ye luway aahawa na, luway iipoh a babayi boy hilay labinmaghay aanak na. ");
INSERT INTO abp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pangayadi, impalipay na met kanlan iipoh na ye kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kaya-bay bubukod naynan bengat. Haanin, nilumateng ye maghay laki kanan Jacob, ket naydakep hila anggan ha anhumda ana. ");
INSERT INTO abp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ha natanam nan laki a ahe naya mahambot ye Jacob, kinimpaan nay pipilpoan nin balakang nan Jacob, ket nabloan ya. ");
INSERT INTO abp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hinabi nan laki, “Ibol-ihan mo koyna ta anhumda yayna!” “Ahe kata ibol-ihan anggan ahe moko inged,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tinepet na yan laki, “Hinyay ngalan mo?” “Jacob,” wana. ");
INSERT INTO abp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hinabi nan laki kana, “Paibat haanin, aliwaynan Jacob ye ngalan mo, no aliwan Israel ana. Ta nakilaban ka kanan Apo Namalyadi boy kanlan tatao, ket nanambot ka.” ");
INSERT INTO abp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“Habiyen mo man kangko ye ngalan mo,” wanan Jacob. “Taket ta labay mon matandaan ye ngalan ko?” wana met nin laki. Pangayadi, in-inged na yay Jacob ihtew. ");
INSERT INTO abp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ket hiyay Jacob, pinangalanan na yan Peniel yatew a lugal boy hinabi na, “Nakit ko yay lupa nan Apo Namalyadi, noba ahe ako natey.” ");
INSERT INTO abp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Anhumila yaynay mangaamot ha inumalih yay Jacob ha Peniel, ket ampagpilay-pilay yan angkumodang, ta nabloan yan balakang. ");
INSERT INTO abp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yabay-in ye hangkan no taket ta angga haanin, ket ahe la angkena nin Israelita ye taked nin pilpoan balakang nin ayop, ulita hiyay taked nin pipilpoan nin balakang nan Jacob ye kinimpaan nin laki. ");
INSERT INTO abp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Tinumangal yay Jacob, ket nakit na a anlumateng yaynay Esau kalamo na hilay 400 a tatao na. Kaya-bay pinayngilbo na hilan impalakew ye aanak na kanlan iindo la. Hiyay Lea, kalamo nay aanak na. Hiyay Raquel, kalamo na met ye aanak na. Ket hilay luway iipoh la, kalamo la hila met ye aanak la. ");
INSERT INTO abp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ha pangumodang la, pinauna na hilay luway ipoh a babayi boy aanak la, anhumumbong yay Lea boy aanak na, ket ha huyotan, hiyay Raquel boy hiyay Jose a anak na. ");
INSERT INTO abp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nuna yay Jacob kanlan kaganaan. Ket ha anhumaley yayna kanan katongno na, nikapito yan ukdon nilumukob ha luta. ");
INSERT INTO abp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Noba nayew yan nanagana kanan Jacob ye Esau, tinakeh boy inumaan naya. Ket tinumangih hilan mikatongno. ");
INSERT INTO abp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ha nakit na hilan Esau ye babayi boy aanak, tinepet na yay Jacob, “Aya hilayatin kalamo mo?” “Yabay-in hilaynay aanak a in-ibyay nan Apo Namalyadi kangko, kaka,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hinumaley hilay babayin ipoh kalamo la hilay aanak la, ket nilumukob hila ha adapan nan Esau. ");
INSERT INTO abp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Wanabay met ye dinyag nan Lea boy hilay aanak na, pangayadi hiyay Raquel boy Jose met. Nilumukob hilan kaganaan kanan Esau. ");
INSERT INTO abp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“Hinyay labay habiyen nin kakawan a nahagana ko?” wanan Esau. “Hilayatew ket idigalo ko kamo ta-omen moko tanggapen, kaka,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Noba hinabi nan Esau, “Katongno ko, malabong anay babandi ko. Kammoy nan bengat hilayain.” ");
INSERT INTO abp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Noba hinabi nan Jacob, “Hige na kaka, no peteg a tinanggap mo koyna, tanggapen moynay digalo ko kamo. Ta ha pamakakit ko ha lupa mo boy ha tinanggap moko, ket ba-mon nakit koy lupa nan Apo Namalyadi! ");
INSERT INTO abp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kaya-bay tanggapen moynay digalo ko kamo ulita in-inged na kon Apo Namalyadi boy antina kangko ye kaganaan a matapul ko.” Piaamlogan na yan Jacob ye Esau anggan ha tinanggap nay digalo na kana. ");
INSERT INTO abp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hinabi nan Esau, “Tawoyna! Magpahulong kitawoyna, ket hiko ye mauna ha pangumodang.” ");
INSERT INTO abp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Noba hinabi nan Jacob kanan Esau, “Tanda moyna met, Kaka, a makapey hilan kumodang ye aanak. Boy katapulan ko hila met hayhayen ye tutupa boy babaka a nangoybon. No gagahen hilan ibalunbon ha agya maghay mangaamot bengat, ket maka no matey hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kaka, mamanged po no muna kayna. Ket ino-ino kayin manumbong kamo ha mababa lan aanak boy aayop. Kaka, ihtew kitawo tana mayngikit ha Seir.” ");
INSERT INTO abp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“No wanabay awod, palamoan katawo kanlan tatao ko,” wanan Esau. “Ahe ana katapulan, Kaka! Hiyay maalaga kangko ket tinanggap moko,” wana met Jacob. ");
INSERT INTO abp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kananyatew met ateed a mangaamot, hiyay Esau ket nag-aligwat yaynan palakew ha Seir. ");
INSERT INTO abp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Noba hiyay Jacob, ket nakew ya ha Sucot. Ket ihtew na yan impaideng ye hongab na boy nanyag ya nin kukulongan nin aayop na. Kaya-bay nahabtan yan Sucot yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Paibat ha Sucot, hiyay Jacob boy pamilya na, ket niabot hila ha banwa nin Shekem a hakop nin Canaan. Ket ihtew hilan nagpondo ha haley nin banwa. Ha kabuyotan nin panaon, nakaudong yayna ha Canaan pangayadi nin pangumonin na nin nabuyot a panaon ha Padan Aram. ");
INSERT INTO abp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hiyay luta a nangipaidengan nan hongab na, ket hinaliw na yan Jacob kanan aanak nan Hamor a bapa nan Shekem ha alaga nin 100 a mital. ");
INSERT INTO abp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nangipaideng ya ihtew nin pangihagpaan nin ihagpa kanan Apo Namalyadi, ket pinangalanan na nin El Elohe Israel. ");
INSERT INTO abp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ha maghay mangaamot, hiyay Dina a balatang lan Lea boy Jacob, ket kinewahan na hilay nangaanon babayi a angkumonin ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nakit na yan Shekem ye Dina, ket pinilit na yan nilalay. Hiyay Shekem ket anak na yan Hamor a maghan Hiveo. Hiyay Hamor ket mānguna ya nin yatin lugal. ");
INSERT INTO abp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Kinaibegan na yan Shekem ye Dina. Ket ampakaadoen na yay Dina boy anliwaliwaen naya. ");
INSERT INTO abp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Hinabi nan Shekem kanan bapa na a Hamor, “Kowen mo yain a balatang ta-omen koya mapag-ahawa.” ");
INSERT INTO abp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Natandaan nan Jacob ye pandamog nan Shekem kanan Dina a anak na, noba ahe ya po tinumnoy ye Jacob ulita anti hila po ye aanak na a lalaki ha bangkag a ampagpahtol nin aayop la. ");
INSERT INTO abp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nakew yay Hamor a bapa nan Shekem kanan Jacob ta-omen naya katongtongen a labay nan Shekem a mapag-ahawa na yay Dina. ");
INSERT INTO abp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ha nabalitaan lan aanak nan Jacob ye nalyadi, nuli hilan tampol. Angkapoot hilan tubat kanan Shekem uli ha maloke a dinyag na kanan Dina. Magha yan panumhak ha lahi nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Noba hinabi nan Hamor kanla, “An-adoen na yan tubat Shekem ye Dina. Kaya-bay an-ipakiiingalo koya kanyo a palubohan yo yayna a mapag-ahawa na yan anak ko. ");
INSERT INTO abp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Boy manged met no palubohan tawoynan mapag-ahawa lan babayontao mi ye babalatang yo. Wanabay met kanyo. Malyadin mapag-ahawa nin babayontao yo ye babalatang mi. ");
INSERT INTO abp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Malyadi kawoynan kumonin ihti kammi. Malyadi kawon mamili nin kunaan yo ha agya way-ihtew a labay yo. Malyadi kawon magpanapolan boy malyadi kawon manaliw nin luta.” ");
INSERT INTO abp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Haanin, hinabi na met Shekem kanlan mitatalabapa, “No tanggapen yoy an-ipakikwa ko, ibyay ko lano kanyo ye hinyaman a awoken yo kangko. ");
INSERT INTO abp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Habiyen yo agya hinyaman a ihambong boy idigalo ko kanyo, ket ibyay ko, dapot tana mapag-ahawa ko yay Dina.” ");
INSERT INTO abp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Uli ha pandamog nan Shekem kanan Dina, hilay lalakin aanak nan Jacob, makapitoglabo ye hebat la kanlan mitabapa a Shekem boy Hamor. ");
INSERT INTO abp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Hinabi la, “Agmi ipaluboh a makapag-ahawa yay Dina nin aliwan tuli, ta kamading-eyan kammi no aliwan tuli ye mapag-ahawa nin babalatang mi. ");
INSERT INTO abp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ipaluboh min bengat no hika boy hilay kaganaan a lalaki ihti kanyo, ket patuli a omen kammin natuli. ");
INSERT INTO abp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","No magpatuli kawo, malyadi kawoynan mangahawa kanlan babalatang mi boy malyadi kayi met mangahawa kanlan babalatang yo. Ket kumonin kayina ihti kanyo, ket mapaymamagha kitawoyna. ");
INSERT INTO abp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Noba no ahe yo labay, umalih kayiyna ihtin lugal boy kowen mi yay katongno min Dina.” ");
INSERT INTO abp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nakit lan Hamor boy Shekem a ba-mon manged yay hinabi lan aanak nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ket ulita an-adoen na yan tubat Shekem ye Dina, tampol yaynan nuli ta-omen na diyagen ye hinabi lan aanak nan Jacob. Hiyay Shekem ket ampakadangalen la yan tubat nin pamilya nan Hamor. ");
INSERT INTO abp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kaya-bay hiyay Hamor boy Shekem, ket nakew hila ha dapit ilwangan nin banwa ta-omen na hila katongtongen ye lalakin kabanwa la. ");
INSERT INTO abp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hinabi la, “Hilatin tatao, manged hilan makigayyem kantawo. Palubohan tawo hilan kumonin ihti boy magpanapolan. Maway ya met yatin lugal tawo. Malyadi tawo hilan mapag-ahawa ye babalatang la. Ket malyadi la met mapag-ahawa ye babalatang tawo. ");
INSERT INTO abp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Noba mapalyadi bengat a kumonin hila ihti ta-omen kitawoyna maymamaghan banwa dapot tana kaganaan a lalaki kantawo ket patuli met a omen kanla a natuli. ");
INSERT INTO abp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ket no ihti hilaynan kumonin, kaganaan a aayop boy babandi la, ket mapagkonin tawo hilayna met. Kaya-bay humbongen tawoyna ingat ye labay la ta-omen ihti hilayna kumonin.” ");
INSERT INTO abp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Inawo lan kaganaan a lalaki ha banwa ye hinabi nan Hamor boy Shekem. Ket nagpatuli hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pangalabah nin tatloy mangaamot, legan mailab po ye tuli lan lalaki, hilay luwa kanlan aanak nan Jacob a hiyay Simeon boy Levi a kakatongno nan Dina, kingwa lay etak la. Ket nilumoob hila ha banwa a ahe la tanda nin tatao ihtew ye tikih la, ket pinatey la hilay kaganaan a lalaki ihtew. ");
INSERT INTO abp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pinatey la hila met ye mitabapa a Hamor boy Shekem. Pangayadi, kingwa la yaynay Dina ha baey nan Shekem, ket inumalih hilayna ha banwa. ");
INSERT INTO abp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Hilay kanayon a aanak nan Jacob a laki, ket nilumoob hila ha banwa, ket hinamham lay mangaalaga a babandi lan tataon nangamatey ihtew. Dinyag la yati bilang pangibae nin pandamog nan Shekem kanan Dina a katongno la. ");
INSERT INTO abp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hinamham lay kaganaan a tutupa, kakambing, babaka, aahno boy kaganaan a babandi ha banwa boy ha bangkag. ");
INSERT INTO abp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Hinamham lay kaganaan a kabandiyan, boy kinapyol la hilay babayi boy aanak. Hinamham lay kaganaan a anti ha loob nin babaey. ");
INSERT INTO abp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Haanin, hinabi nan Jacob kanan Simeon boy Levi, “Binyan yo kon mayadet a kagulowan. Ket haanin, pag-inakitan la kitawoynan Cananeo boy hilay Perezeo a angkumonin ihti. No maymamagha hilan mandawohong kantawo, ket matey kitawon kaganaan ta nangaano kitawon bengat.” ");
INSERT INTO abp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Noba hinabi lan Simeon boy Levi, “Paolayan mina nayi a ituwad na yan Shekem kanlan babayin babayadan ye katongno mi?” ");
INSERT INTO abp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hinabi nan Apo Namalyadi kanan Jacob, “Mag-aligwat ka, ta makew ka ha Betel. Ket kumonin ka ihtew. Manyag ka ihtew nin pangihagpaan nin ihagpa mo kangko a Apo Namalyadi a napakit kamo ha panumakah mo kanan Esau a katongno mo.” ");
INSERT INTO abp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kaya-bay hinabi nan Jacob kanlan pamilya na boy ha kaganaan a lamo na, “Itapon yoy kalintatao lan dadayohan a anti kanyo, linihan yoy lalaman yo boy maghagili kawon malinih a bado. ");
INSERT INTO abp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pangayadi, makew kitawoyna ha Betel. Manyag ako ihtew nin pangihagpaan nin ihagpa kanan Apo Namalyadi a nanaglap kangko ha angkaidapan ako boy lanang na kon anlamoan ha agya way-ihtew man a lakwen ko.” ");
INSERT INTO abp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaya-bay in-ibyay la kanan Jacob ye kaganaan a kalintatao lan dadayohan boy titingga la. Ket kaganaan hilayatew, ingkali na yan Jacob ha talig nin poon kayon terebinto ha haley nin Shekem. ");
INSERT INTO abp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ket ha umalih hilayna ihtew, pinalimo na hilan Apo Namalyadi ye tatao ha kaganaan a babanwa ha palibot nin yatew a lugal. Kaya-bay homain nangamat kanlan Jacob ha pangumalih la. ");
INSERT INTO abp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Niabot hilan Jacob boy kalalamoan na ha Luz a anhabtan met Betel, ha lugal a Canaan. ");
INSERT INTO abp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ket ihtew ya nanyag ye Jacob nin pangihagpaan. Ket hinabtan na yan El Betel yatew a lugal, ulita ihtew yan napakit ye Apo Namalyadi kana ha antakahan na yay Esau a katongno na. ");
INSERT INTO abp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kananyatew a panaon, natey yay Debora a māngalingay nan Rebeka. Ket in-ilbeng lay bangkay na ha hilong nin poon kayon terebinto ha haley nin Betel. Ket yatew a lugal, hinabtan yan Allon Bacut. ");
INSERT INTO abp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ha nag-udong yaynay Jacob ibat ha Padan Aram, napakit yan uman kana ye Apo Namalyadi boy in-inged naya, ");
INSERT INTO abp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","a wana, “Jacob ye ngalan mo, noba paibat haanin aliwaynan Jacob ye ngalan mo, no aliwan Israel.” Kaya-bay hiyay Jacob, pinangalanan na yan Israel. ");
INSERT INTO abp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Hinabi na po Apo Namalyadi kana, “Hikoy Apo Namalyadi a Makapalyadiyan. Magkamain kan malabong a aanak boy hika lano ye bapa nin maghay lahi a pangibatan nin malabong a lalahi boy mag-ilyadi hilan popoon ye kanayon kanlan lalahi mo. ");
INSERT INTO abp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Hiyay lugal a in-ibyay ko kanan Abraham boy kanan Isaac, ket ibyay ko met kamo boy kanlan lalahi mo.” ");
INSERT INTO abp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pangayadi, inumalih yaynay Apo Namalyadi ha lugal no way-ihtew naya napagkatongtong ye Jacob. ");
INSERT INTO abp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nangipaideng yay Jacob nin dapah a pangihipan ha lugal a napagkatongtong na yay Apo Namalyadi. Boy tiniihan na yan alak boy ladak ye dapah bilang hagpa kanan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Pinangalanan na yan Betel yatew a lugal no way-ihtew naya napagkatongtong ye Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Pangayadi, inumalih hilaynan Jacob ha Betel. Mataang hila po ha Efrata, natanam nan Raquel a anlamlaman yayna boy angkaidapan ya. ");
INSERT INTO abp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ha tubat anay panlamlam na, hinabi nan māngilot na, “Adi ka angkalimo, ta laki yayna man ye ianak mo.” ");
INSERT INTO abp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ha angkakamatey yayna, bayo yan naboytoan nin angeh, ket pinangalanan na yan “Ben Oni” ye ongi na. Noba Benjamin ye impangalan nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Natey yay Raquel, ket in-ilbeng laya ha gilid nin dān palakew ha Efrata a anhabtan met Betlehem haanin. ");
INSERT INTO abp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nangipaideng yay Jacob nin dapah a pangihipan ha nakailbengan nan Raquel. Ket angga haanin, anti ya po ye pangihipan. ");
INSERT INTO abp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nagpahulong yay Israel ha pangumodang na, ket ihtew na yan impaideng ye hongab na ha kagmang nin Migdal Eder. ");
INSERT INTO abp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Legan anti hilan angkumonin ihtew a lugal, hiyay Reuben, ket nilalay na yay Bilha a magha kanlan ipoh a ahawa nan bapa na a hiyay Israel. Ket natandaan nan Israel yatew. Hilayati ye 12 lalakin aanak nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Hilay aanak na kanan Lea ket hiyay Reuben a punganay, Simeon, Levi, Juda, Isacar, boy Zebulun. ");
INSERT INTO abp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Hilay aanak na kanan Raquel ket hiyay Jose boy Benjamin. ");
INSERT INTO abp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Hilay aanak na kanan Bilha a ipoh nan Raquel ket hiyay Dan boy Naftali. ");
INSERT INTO abp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Hilay aanak na kanan Zilpa a ipoh nan Lea ket hiyay Gad boy Asher. Hilan kaganaan ket naianak hila ha Padan Aram. ");
INSERT INTO abp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kinewahan na yan Jacob ye bapa na a hiyay Isaac ha Mamre, ha haley nin Kiriat Arba a anhabtan Hebron haanin. Ihti ya met kinumonin ye Abraham boy Isaac hatew. ");
INSERT INTO abp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Hiyay Isaac ket naabot nay 180 a taon. ");
INSERT INTO abp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Natey yan kinatoa, ket napagkalamo na hilaynay nangaunan tutoa na a nangamatey ana. Hiyay Esau boy Jacob ye nangilbeng kana. ");
INSERT INTO abp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hilayati ye lalahi nan Esau a anhabtan met nin Edom. ");
INSERT INTO abp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Hilay taga Canaan a napag-ahawa nan Esau ket hiyay Ada a anak nan Elon a Heteo, hiyay Oholibama a anak nan Ana boy apo nan Zibeon a Hiveo, ");
INSERT INTO abp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","hiyay Basemat a anak na met Ishmael boy katongno nan Nebayot. ");
INSERT INTO abp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Hiyay anak nan Esau kanan Ada ket hiyay Elifaz. Hiyay anak na kanan Basemat ket hiyay Reuel. ");
INSERT INTO abp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ket hilay aanak nan Esau kanan Oholibama ket hilan Jeush, Jalam boy Kora. Hilan kaganaan lahi nan Esau ket nianak ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Hiyay Esau, ket inlakew na hilay aahawa na, aanak na, kaganaan a kabaey na, aayop na boy kaganaan babandin natipon na ha Canaan, ket nakew yan kinumonin ha mataang a lugal kanan katongno na. ");
INSERT INTO abp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Uli ha kalabong nin babandi boy aayop la, ahe hilayna mihadang ha maghay lugal. ");
INSERT INTO abp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kaya-bay nakew yan kinumonin ye Esau ha nagmamapantay nin Seir. Hiyay Esau ket anhabtan met Edom. ");
INSERT INTO abp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hilayati ye aanak nan Esau a pinangibatan lan Edomita ha nagmamapantay nin Seir, ");
INSERT INTO abp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","hiyay Elifaz a anak nan Esau kanan Ada boy hiyay Reuel a anak na kanan Basemat. ");
INSERT INTO abp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Hilay aanak na met nin Elifaz ket hilan Teman, Omar, Zefo, Gatam boy Kenaz. ");
INSERT INTO abp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ket hiyay anak nan Elifaz kanan Timna a ipoh a ahawa na ket hiyay Amalek. Hilayain ye aapo nan Esau kanan Ada. ");
INSERT INTO abp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Hilayati met ye aapo nan Esau kanan Reuel a anak na kanan Basemat ket hilan Nahat, Zera, Shama boy Miza. ");
INSERT INTO abp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Hilay aanak nan Esau kanan Oholibama a anak nan Ana boy aapo nan Zibeon ket hilan Jeush, Jalam boy Kora. ");
INSERT INTO abp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hilayati ye mānguna ha lalahi nan Esau. Hilay lalahi nan punganay nan Esau a hiyay Elifaz ket hilan Teman, Omar, Zefo, Kenaz, ");
INSERT INTO abp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam boy Amalek. Hilabay ye aanak nan Elifaz ha Edom boy aapo nan Ada a ahawa nan Esau. ");
INSERT INTO abp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hilay mānguna ha lugal a Edom a aanak nan Reuel ket hilan Nahat, Zera, Shama, boy Miza. Hilabay ye aapo nan Esau kanan Basemat. ");
INSERT INTO abp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Hilay mānguna kanlan anak nan Esau kanan Oholibama a anak nan Ana ket hilan Jeush, Jalam boy Kora. ");
INSERT INTO abp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hilayain ye lalahi nan Esau a namoon ha Edom. ");
INSERT INTO abp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hilayati ye aanak nan Seir a Horeo a unan kinumonin ha Edom, hilan Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO abp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer boy Dishan. Hilabay ye aanak nan Seir a mānguna kanlan Horeo ha Edom. ");
INSERT INTO abp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Hilay lalakin aanak nan Lotan ket hilan Hori boy Heman. Ket hiyay Timna ye babayin katongno nan Lotan. ");
INSERT INTO abp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Hilayati met ye lalakin aanak nan Shobal, hilan Alvan, Manahat, Ebal, Shefo boy Onam. ");
INSERT INTO abp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Hilay lalakin aanak nan Zibeon ket hilan Aya boy Ana. (Hiyay Ana ye nakatuklah nin maamot a hubol ha wangwang legan an-ipahtol na hilay aahno nan bapa na.) ");
INSERT INTO abp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Hilay luway aanak nan Ana, ket hiyay Dishon boy hiyay babayin nagngalan Oholibama. ");
INSERT INTO abp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Hilay lalakin aanak nan Dishon ket hilan Hemdan, Eshban, Itran boy Keran. ");
INSERT INTO abp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Hilay lalakin aanak nan Ezer ket hilan Bilhan, Zaavan boy Akan. ");
INSERT INTO abp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Hilay lalakin aanak na met Dishan ket hilan Uz boy Aran. ");
INSERT INTO abp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Hilayain ye mānguna a ibat ha lalahi lan Horeo, ket hiyay Lotan, Shobal, Zibeon, Ana, Dishon, Ezer boy Dishan ha lugal a Seir. ");
INSERT INTO abp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hilayati ye nag-ilyadin poon ha Edom bayo hilan nagkamain nin poon ye Israelita. ");
INSERT INTO abp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Hiyay Bela a anak nan Beor ye namoon ha banwa nin Dinhaba ha Edom. ");
INSERT INTO abp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pangamatey nan Bela, hiyay Jobab a anak nan Zera a taga Bozra ye nanagili kana a namoon. ");
INSERT INTO abp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pangamatey nan Jobab, hiyay Husham a taga Teman ye nanagili kana a namoon. ");
INSERT INTO abp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pangamatey nan Husham, hiyay Hadad a taga Avit a anak nan Bedad ye nanagili kana a namoon. Hiyay Hadad ye nanambot kanlan Midianita ha lugal a Moab. ");
INSERT INTO abp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pangamatey nan Hadad, hiyay Samla a taga Masreka ye nanagili kana a namoon. ");
INSERT INTO abp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pangamatey nan Samla, hiyay Saul a taga Rehobot ha ambay kabatowan ye nanagili kana a namoon. ");
INSERT INTO abp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ket ha pangamatey nan Saul, hiyay Baal Hanan a anak nan Acbor ye nanagili kana a namoon. ");
INSERT INTO abp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pangamatey nan Baal Hanan a anak nan Acbor, hiyay Hadad a taga Pau ye nanagili kana a namoon. Hiyay ahawa nan Hadad ket hiyay Mehetabel a anak nan Matred boy apo nan Mezahab. ");
INSERT INTO abp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hilayati ye lalahi nan Esau a nag-ilyadin mānguna nin lahi boy ha banwa a pinangalanan nin ngalan la, Timna, Alva, Jetet, ");
INSERT INTO abp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Elah, Pinon, ");
INSERT INTO abp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO abp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel boy Iram. Hilayain ye mānguna ha lalahi nin Edom ha balang lugal la. Hiyay Esau ye pinangibatan nin lalahi lan Edomita. ");
INSERT INTO abp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kinumonin yay Jacob ha Canaan a lugal a kinunaan nan bapa na hatew. ");
INSERT INTO abp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yati ye panongtongen nin tungkol ha pamilya nan Jacob. Ha 17 nay taon nan Jose, ampanayhay ya nin kawan nin tutupa nan bapa na, kalamo na hilay kakatongno na a hilay aanak lan Bilha boy Zilpa a aahawa nan bapa la. Tanda nan Jose ye mangaloke a andiyagen lan kakatongno na. Kaya-bay inhumbong na kanan bapa la. ");
INSERT INTO abp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Maiigit ye pangado nan Israel kanan Jose dinan kanlan kanayon a aanak na, ulita matoa yaynay Israel ha nianak yay Jose. Kaya-bay intayian na yan bado a matampa boy makadang. ");
INSERT INTO abp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Naimatonan lan kakatongno nan Jose a maiigit ye pangado nan bapa la kana. Kaya-bay kinaholog laya boy pinaghabiyan la yan mangahakit. ");
INSERT INTO abp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ha maghay madeglem, nanaynep yay Jose. Ket ha intongtong na kanlan kakatongno na ye taynep na, lalo hilaynan nahulog kana. ");
INSERT INTO abp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Hinabi na kanla, “Pakaleng-en yoy taynep ko. ");
INSERT INTO abp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Legan anti kitawo ha bangkag a ampamalot nin tidigo, ket kapipikhaan nideng yay pinteh ko, ket pinalibotan ya nin pinteh yo boy nanalimukod hila ha pinteh ko.” ");
INSERT INTO abp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Haanin, hinabi lan kakatongno nan Jose kana, “Hiyay labay mon habiyen mag-ilyadi kan poon boy mamoon ka kammi?” Ket lalalo hilayna ingat nahulog kanan Jose uli ha tataynep na boy ha hinabi na. ");
INSERT INTO abp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ha ahe nabuyot, nanaynep yayna man ye Jose, ket intongtong na kanlan kakatongno na, a wana, “Pakaleng-en yo po ye ikalwan taynep ko. Nakit ko ye mangaamot, bowan boy labin maghan bibitoen a ampanalimukod kangko.” ");
INSERT INTO abp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Hinabi na met Jose ye taynep na kanan bapa na, ket kinapootan na yan bapa na boy hinabi na kana, “Hinyay labay mon habiyen ha taynep mo? Hikayi kanan indo mo boy kakatongno mo, ket manalimukod kamo?” ");
INSERT INTO abp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Angkaibegan la yan tubat ye Jose nin kakatongno na, noba hiyay bapa na, ket ampakaihipen nan manged ye taynep nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ha maghay mangaamot, nakew hilay kakatongno nan Jose ha Shekem ta-omen la ipahtol ye kawan nan bapa la. ");
INSERT INTO abp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Hinabi nan Israel kanan Jose, “Mag-aligwat ka, ta lakwen mo hilay kakatongno mo a anti ha Shekem a ampagpahtol nin aayop.” “Awo,” wanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Hinabi na po bapa na, “Makew ka ihtew, ta bilewen mo no maawong ye kahahaad lan kakatongno mo boy hilay kawan. Pangayadi, mag-udong ka kangko ta-omen ko matandaan.” Kaya-bay intubol na yan bapa na ye Jose paibat ha alagoog nin Hebron palakew ha Shekem. ");
INSERT INTO abp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ha pangukumodang nan Jose ha bangkag, nakit ya nin maghay laki, ket tinepet naya, “Hinyay antapolen mo?” ");
INSERT INTO abp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Hinabi nan Jose, “Antapolen ko hilay kakatongno ko. Tanda mo laweh, apo, no way-ihtew hilan ampagpahtol?” ");
INSERT INTO abp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hinabi nan laki, “Ahe hilayna ihti. Nange ko a makew hila kano ha Dotan.” Kaya-bay nilakew na hilan Jose, ket nakit na hilan peteg ihtew ha Dotan ye kakatongno na. ");
INSERT INTO abp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mataang ya po ye Jose, ket natamolaw la yaynan kakatongno na. Ket bayo ya miabot kanla, pinay-oopitan la yan pateyen. ");
INSERT INTO abp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Hinabi la ha magha boy magha, “Ah! Anti yaynay mapanaynep! ");
INSERT INTO abp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tawoyna! Pateyen tawo ya. Pangayadi, iampag tawo ya ha libon ye bangkay na. Habiyen tawo lanon pinatey ya nin matubag a ayop. Bilewen tawo man no magkapeteg ye taynep na.” ");
INSERT INTO abp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ha nange nan Reuben ye anhabiyen la, ket pinaghehpetan na yan iligtah ye Jose. Hinabi na, “Ahe. Ahe tawo yan pateyen. ");
INSERT INTO abp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Adi yo yan pateyen. Iampag tawo yayna tana ha libon ha wangwang, noba adi tawo ya pahakitan.” Hinabi na yatew, ulita an-ihipen na yan iligtah lano ye Jose kanlan katongno la haka naya iudong kanan bapa la. ");
INSERT INTO abp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kaya-bay ha nilumateng yaynay Jose kanlan kakatongno na, linoh-ok la ye matampa boy makadang a bado na, ");
INSERT INTO abp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ket in-ampag laya ha mamalan libon ye Jose. ");
INSERT INTO abp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ha nikno hila, ta mangan hilayna, ket main hilan natamolaw a maghay pangkat nin Ishmaelitan māgpanapolan a ibat ha Gilead. Hilay kakamilyo la ket main kakalgan didikado, tatambal boy pabango a an-ilakew la ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Haanin, hinabi nan Juda kanlan kakatongno na, “Homain kitawon pakinabang no pateyen tawo yay katongno tawo boy itayo ye pagkamatey na. ");
INSERT INTO abp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mamanged po, ilako tawo yayna tana kanlan Ishmaelita. Adi tawo yan pahakitan, ta mamaghay puhel tawo.” Ket inawo la. ");
INSERT INTO abp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ha mahaley hilaynay Ishmaelitan māgpanapulan, in-awah la yay Jose, ket inlako laya ha alaga a luwampo a mital. Ket kinaget la yaynan Ishmaelita palakew ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ha nag-udong yay Reuben ha libon, ahe na yayna nakit ye Jose. Ket uli ha tubat a lele na, giniwak nay bado na. ");
INSERT INTO abp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nag-udong ya kanlan kakatongno na boy hinabi na, “Ahe yayna ha libon ye katongno tawo! Hinyay diyagen ko haanin?” ");
INSERT INTO abp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Haanin, nanapo hila nin kambing, ket kingwa lay bado nan Jose haka la yan intamhaw ha daya ye bado na. ");
INSERT INTO abp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pangayadi, inlakew lan impakit kanan bapa la ye matampa boy makadang a bado nan Jose, ket hinabi la, “Nakit mi yatin bado. Bilewen moya man no yabayti ye bado nan anak mo.” ");
INSERT INTO abp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nabalayan na yan tampol Jacob ye matampa boy makadang a bado, a wana, “Awo, bado nan anak ko yain! Pinatey yan matubag a ayop ye anak ko! Homain hapo a pinaytbayitan yan matubag a ayop ye laman na.” ");
INSERT INTO abp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ket giniwak nan Jacob ye bado na boy nagbado ya nin pampaneh. Inandangan na yay Jose nin makadang a panaon. ");
INSERT INTO abp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Niliwaliwa la yan kaganaan a aanak na, noba pahulong ateed ye pangandang na, a wana, “Paolayan yo koynan bengat! Ikamatey koy kalelean ko uli ha pagkamatey nan anak ko.” Ket tinangihan na yay Jose. ");
INSERT INTO abp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ha nilumateng hilaynay Ishmaelitan māgpanapolan ha Egipto, inlako la yay Jose kanan Potifar, magha yan kapitan lan māgbantay ha palahyo nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kananyatew a panaon, hiyay Juda, nilakwanan na hilay kakatongno na, ket nakew yan nakidagoh kanan Hira a maghan Adulamita. ");
INSERT INTO abp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ket ihtew na yan nakatatanda ye babayin anak nan Shua a Cananeo, ket pinag-ahawa naya. ");
INSERT INTO abp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Binumuktot yay babayi, ket nanganak yan laki. Ket hiyay Juda, pinangalanan na yan Er ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Binumuktot yayna man, ket nanganak yan laki. Ket pinangalanan na yan Onan ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nanganak yayna man nin laki, ket pinangalanan na yan Shela. Hiyay Shela, ket nianak ya ha Kezib. ");
INSERT INTO abp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Hiyay Juda, pinili na yay Tamar a pag-ahawa nin punganay na a hiyay Er. ");
INSERT INTO abp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Noba nakit nan Apo Dioh a maloke ye andiyagen nan Er. Kaya-bay pinatey naya. ");
INSERT INTO abp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Haanin, hinabi nan Juda kanan Onan, “Katungkolan mo yan lalayen ye bawo nan katongno mo ta-omen ya magkamain nin lahi makauli kamo ye katongno mon natey.” ");
INSERT INTO abp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Noba tanda nan Onan a ahe ya maibilang a anak na ye ianak nan Tamar no mapabuktot naya. Kaya-bay tepe lalayen naya, an-ilwah nay bini na ta-omen ya ahe magkaanak ye katongno na makauli kana. ");
INSERT INTO abp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Maloke ye andiyagen nan Onan ha pamilew Apo Dioh. Kaya-bay pinatey naya met. ");
INSERT INTO abp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Haanin, hinabi nan Juda kanan manuyang na a Tamar, “Muli ka po ha baey nan bapa mo boy magteeh ka po a bawo angga ha magbayon-tao yay Shela a anak ko.” Hinabi nan Juda yatew uli ha limo na a maka matey ya met ye Shela a omen ha nalyadi kanlan kakatongno na. Kaya-bay nuli yay Tamar ha baey nan bapa na. ");
INSERT INTO abp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pangalabah nin anoy taon, natey yay anak nan Shua a ahawa nan Juda. Pangayadi nin paglele na, nakew ya kanlan ampangodog nin tutupa na ha Timna. Kalamo na yay gayyem na a hiyay Hira a Adulamita. ");
INSERT INTO abp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Main nangihabi kanan Tamar, “Hiyay ampo mo ket palakew yayna haanin ha Timna ta-omen na paodogan ye tutupa na.” ");
INSERT INTO abp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pamakange nan Tamar, hinagiliyan nay hoot na a badon pambawo. Hinalimbengan nay lupa na, ket nakew yan nikno ha gilid ilwangan nin banwan Enaim a angkadanan palakew ha Timna. Wanabay ye dinyag na, ulita nakit na a bayontao yaynay Shela, noba hiyay Juda, ahe naya po impaahawa kana. ");
INSERT INTO abp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ha nakit na yan Juda ye Tamar, nabaan nan magha yan babayin babayadan, ulita nahalimbengan ye lupa na. ");
INSERT INTO abp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ahe na nabalayan a hiyabay ye manuyang na. Hinaleyan naya boy hinabi na, “Kadi, ta maylalay kita.” “Hinyay ibayad mo kangko no maylalay kita?” wanan Tamar. ");
INSERT INTO abp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Hinabi nan Juda, “Paatelan kata nin maghay oybon kambing ha kawan ko.” Hinabi nan babayi, “Malabay ako no biyan moko nin pangemgeman ta-omen ko mahigudo a paatelan moko nin maghay oybon kambing.” ");
INSERT INTO abp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Hinabi nan Juda, “Hinyay ibyay ko kamo a pangemgeman mo?” Nakibat yay Tamar, “Ibyay mo kangkoy pāgmalka mo dayon gawot na boy hiyay teken mo.” Ket in-ibyay nan Juda ye hinabi nan babayi, ket naylalay hila. Ket napabuktot na yay Tamar. ");
INSERT INTO abp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ha nuli yaynay Tamar ha baey na, inalih nay halimbeng nin lupa na, ket naghoot yan uman nin badon pambawo. ");
INSERT INTO abp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ha ahe nabuyot, intubol na yan Juda ye gayyem na a hiyay Hira a Adulamita a mangiatel nin oybon kambing ta-omen na ballawien ye ampangemgeman nan Tamar, noba ahe na yan nakitan ye Tamar. ");
INSERT INTO abp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nanepet-tepet yay Hira kanlan lalakin angkumonin ha Enaim, “Way-ihtew yay babayin babayadan a nakaikno hatew ha gilid dān?” Noba hinabi la, “Homain babayin babayadan ihti.” ");
INSERT INTO abp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kaya-bay nag-udong yay Hira kanan Juda, ket hinabi na, “Agko ya nakitan boy hinabi la met lalakin angkumonin ihtew, ‘Homain babayin babayadan ihti.’ ” ");
INSERT INTO abp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Hinabi nan Juda, “Paolayan ta yayna ingat a pagbandi nay babagay a in-ibyay ko kana. Maka kailiyan la kitawon bengat. Inlakew moyna kana yatin oybon kambing, noba ahe moya met nakitan!” ");
INSERT INTO abp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Pangalabah nin tatloy bowan, main nangihabi kanan Juda, “Hiyay manuyang mon Tamar, ket nag-ilyadi yan babayin babayadan, ta mabuktot yayna.” Kaya-bay hinabi nan Juda, “Ilakew yoya ha ilwah nin banwa, ta ulamen ya!” ");
INSERT INTO abp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Legan an-ilakew la yan papalwah nin banwa, impahabi nan Tamar kanan ampo na, “Hiyay nagkonin kanlan hilati ye nakapabuktot kangko. Bilewen yo no ayay nagkonin kanlan hilatin pāgmalka dayon gawot na boy teken.” ");
INSERT INTO abp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nabalayan nan Juda a bandi na hilatew. Kaya-bay hinabi na, “Homain yan kahalanan. Hiko ye nagkahalanan, ta agko impaluboh a mapag-ahawa na yay Shela.” Ket ahe na yaynan nilalay uman ye Tamar. ");
INSERT INTO abp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ket ha kabowanan naynan Tamar, natandaan na a kambal ye buktot na. ");
INSERT INTO abp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ket ha manganak yayna, nilumwah ye gamet nin magha, ket ginawotan nin māmaanak nin bekah a matibya ye takyay na, a wana, “Yati ye unan nilumwah.” ");
INSERT INTO abp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Noba ingkotet nan ongi ye gamet na, ket nauna yan nilumwah ye kambal na. Ket hinabi nan māmaanak, “Nakiuna kan nilumwah.” Kaya-bay pinangalanan na yan Perez ye ongi. ");
INSERT INTO abp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pangayadi, nilumwah yayna met ye kakambal na a nagawotan nin bekah a matibya ye takyay na. Ket pinangalanan yan Zera. ");
INSERT INTO abp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ha inlakew la yan Ishmaelita ye Jose ha Egipto, ket hinaliw na yan Potifar a maghay Egipsio a kapitan lan māgbantay ha palahyo nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hiyay Apo Dioh ket lanang na yan anlamoan ye Jose. Kaya-bay manganged ye dadapat na. Angkumonin ya ha baey nin amo na a Egipsio a hiyay Potifar. ");
INSERT INTO abp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Naimatonan nan Potifar a anlamoan na yan Apo Dioh ye Jose boy an-inged naya ha kaganaan a dadapat na. ");
INSERT INTO abp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Naaliket yay Potifar kanan Jose. Kaya-bay dinyag na yan hadili nan kahaglap boy mamaala kanlan tataon kabaey na boy ha kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Paibat ha dinyag na yan Potifar a mamaala ye Jose kanlan kabaey na boy ha kaganaan a babandi na, ket in-inged nan Apo Dioh ye kaganaan a bandi nan Potifar ha baey boy ha bangkag na, uli kanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Impataya nan Potifar ye kaganaan kanan Jose. Kaya-bay homain yaynan an-ihipen a kanayon, powidan bengat ha pamili nin pamangan na. Hiyay Jose ket makhaw boy manged yan laki. ");
INSERT INTO abp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ha ahe nabuyot, nalabayan na yan ahawa nan amo na ye Jose. Hinabi nan babayi kana, “Lalayen moko.” ");
INSERT INTO abp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Noba agna inawo Jose, a wana, “Ahe malyadi yain! Impataya na kangko ye kaganaan a konin nan amo ko. Kaya-bay homain yan pakahindakan. ");
INSERT INTO abp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Boy homain anan umiigit kangko ihtin baey. Impataya na kangkoy kaganaan powidan bengat kamo, ta ahawa naka. Ahe ko malyadin diyagen yain, ta tubat yan maloke boy agko labay ye magkahalanan kanan Apo Namalyadi.” ");
INSERT INTO abp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Agya minangaamot na yan ampakitongtongan nin babayi ye Jose a lalayen naya, ket an-adeyan na yan teed boy anliklikan na yayna. ");
INSERT INTO abp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Maghay mangaamot, hiyay Jose, hinumlep ya ha baey nan Potifar ta-omen na dapaten ye obda na. Kananyatew, homain kanayon a ipoh ha loob nin baey. ");
INSERT INTO abp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ginemgeman na yan babayi ye Jose ha kepkep na boy hinabi na, “Lalayen moko!” Noba nagbulatog yan nilumwah ha baey ye Jose. Ket nabantak ha gamet nan babayi ye kepkep na. ");
INSERT INTO abp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ha nakit nan babayi a gemgem nay kepkep nan Jose a tinumakah ha ilwah nin baey, ");
INSERT INTO abp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","pinanghaan na hilay iipoh na, a wana, “Bilewen yo! Nangilakew yay ahawa ko ihti nin Hebreon mangipading-ey kantawo. Niloob nako ha hilid ko ta labay na kon lalayen! Noba nangha ako. ");
INSERT INTO abp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ha nange nay pangha ko, nayew yan nilumwah ha baey, ket nabantak nay kepkep na.” ");
INSERT INTO abp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hiyay babayi, inhagpa na ha talig na ye kepkep nan Jose anggan ha nilumateng yay ahawa na. ");
INSERT INTO abp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hinabi na kanan ahawa na, “Hiyay Hebreon ipoh a inlakew mo ihti, ket niloob nako ha hilid ko ta-omen nako ipading-ey. ");
INSERT INTO abp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Noba ha nangha ako, tampol yan nayew papalwah nin baey, ket nabantak nay kepkep na.” ");
INSERT INTO abp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Pamakange nan Potifar ye hinabi nan ahawa na tungkol ha dinyag nan Jose a ipoh na, napoot yan tubat. ");
INSERT INTO abp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kaya-bay impadakep na yay Jose, ket impapidiho na yan inlamo kanlan impapidiho nan Faraon. Noba agya nakapidiho yay Jose, ");
INSERT INTO abp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","anlamoan naya po ateed Apo Dioh. Ket uli ha pangipakit nan Apo Dioh nin kangedan na kanan Jose, pinag-ilyadi na yan maanoh kanan Jose ye mānguna lan māgbantay ha pidihowan. ");
INSERT INTO abp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kaya-bay impabaala na kanan Jose ye kaganaan a nakapidiho boy hiyay kaganaan a obda ha loob nin pidihowan. ");
INSERT INTO abp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Hiyay mānguna lan māgbantay ha pidihowan, ket ahe na yayna ampakibalabalaan ye Jose ha pamaala na, ulita anlamoan na yan Apo Dioh ye Jose boy an-inged naya ha kaganaan a dadapat na. ");
INSERT INTO abp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Pangayadi yatew, hiyay māmaala nin alak nan Faraon boy hiyay māmaala kanlan mamakawto nin tinapay nan Faraon, ket nagkahalanan hila kana. ");
INSERT INTO abp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kaya-bay napoot yan tubat ye Faraon kanla. ");
INSERT INTO abp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ket impapidiho na hila ha pangipidihowan nan kapitan lan māgbantay no way-ihtew ya nakapidiho ye Jose. ");
INSERT INTO abp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ket hiyay kapitan, impakalingay na hila kanan Jose ye luway māmaala. Nabuyot hilay māmaala ha pidihowan. ");
INSERT INTO abp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ha maghay madeglem, hiyay māmaala nin alak nan Faraon boy hiyay māmaala kanlan mamakawto nin tinapay nan Faraon, ket padiho hilan nanaynep, noba aliwan padiho ye labay habiyen nin tataynep la. ");
INSERT INTO abp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kabekahan ha mahanib, nilakew na hilan Jose, ket naimatonan na a angkahindak hilan luwa. ");
INSERT INTO abp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tinepet na hila, “Taket ta angkahindak kawo?” ");
INSERT INTO abp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ket hinabi la, “Padiho kayin nanaynep nadeglem, noba homain ayaman ye makaipalinaw nin labay habiyen nin taynep mi.” Hinabi nan Jose, “Hiyay Apo Namalyadi ye makaipalinaw nin labay habiyen nin taynep. Habiyen yo man kangko ye tataynep yo.” ");
INSERT INTO abp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kaya-bay hinabi nan māmaala nin alak nan Faraon ye taynep na, a wana, “Nataynepan kon main poon kawat ubah ha adapan ko ");
INSERT INTO abp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","a main tatloy hanga. Ha panumbek na, namulak ya, nanawa ya, ket tampol yaynan naom. ");
INSERT INTO abp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Anggemgeman ko ye baho nan Faraon hatew. Pinoti koy dawa nin ubah boy impehpeh ko ha baho nan Faraon, ket in-ibyay ko kana.” ");
INSERT INTO abp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Hinabi nan Jose, “Wanae ye labay habiyen nin taynep mo. Hiyay tatlon hanga ket tatloy mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ha loob nin tatloy mangaamot, palihwayen na kan Faraon boy iudong na kan teed ha alan mon katungkolan bilang māmaala nin alak na. ");
INSERT INTO abp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Noba lano ha manged anay kahahaad mo, pangiingalo mo, ta ihipen moko. Habiyen mo met kanan Faraon ye tungkol kangko ta-omen nako met palihwayen ihti ha pidihowan. ");
INSERT INTO abp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hiyay kaptegan, pinakaaplat la kon bengat in-alih ihtew ha lugal lan Hebreo. Ket agya haanin a anti ko ihti ha Egipto, homain ako met nadyag a kalok-an a ikapidiho ko.” ");
INSERT INTO abp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pamakange nan māmaala kanlan mamakawto nin tinapay nan Faraon a manged ye labay habiyen nin taynep, hinabi na kanan Jose, “Nanaynep ako met a ampanlonto kon tatloy naypapalonto a bagyah nin tinapay. ");
INSERT INTO abp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ket hiyay dapit babe a bagyah, main yan laman a nakahinadi a tinapay nan Faraon, noba antoktoken hilan mamanokmanok.” ");
INSERT INTO abp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Hinabi nan Jose, “Wanae ye labay habiyen nin taynep mo. Hiyay tatlon bagyah ket tatloy mangaamot. Ha loob nin tatloy mangaamot, ");
INSERT INTO abp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ket ipakwa na kan Faraon ta-omen naka paputohan nin leey. Pangayadi, ibitin na ha kayo ye bangkay mo, ket toktoken lano nin mamanokmanok.” ");
INSERT INTO abp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Haanin, hiyay ikatlon mangaamot ket kompalanyoh nan Faraon. Ket nangihadya yan poniyan lan kaganaan a māghilbi na. Pangayadi, impakwa na yay māmaala nin alak na boy māmaala kanlan mamakawto nin tinapay na. ");
INSERT INTO abp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ket hiyay māmaala nin alak na, in-udong naya ha katungkolan na. ");
INSERT INTO abp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Noba hiyay māmaala kanlan mamakawto nin tinapay, ket pinabikke na yan Faraon boy impabitin nay bangkay na a omen ha hinabi nan Jose kanla. ");
INSERT INTO abp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Noba hiyay māmaala nin alak nan Faraon, ket naliwaan nan habiyen kanan Faraon ye tungkol kanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Pangalabah nin luway taon, nataynep nan Faraon a nakaideng ya ha gilid nin kabatowan Nilo. ");
INSERT INTO abp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kapipikhaan, main nilumakat a pitoy manganged boy mangataba a baka ha kabatowan, ket nangihib hilan iilamon. ");
INSERT INTO abp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pangayadi, nilumakat hila met ye piton mangadawa boy mangabeng a baka. Ket hinumaley hila boy nagpaked ha talig nin mangataba a baka ha gilid nin kabatowan. ");
INSERT INTO abp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ket hilay piton mangadawa boy mangabeng a baka, imbulon la hilay piton manganged boy mangataba a baka. Haanin, nakaimukat yay Faraon. ");
INSERT INTO abp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nakatuloy yan uman ye Faraon, ket nanaynep yayna man. Ket ha taynep na, nakakit ya nin pitoy inuway a mangayadet boy mangalaman ye pinahi na a hinumwak ha maghay powawok. ");
INSERT INTO abp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Pangayadi yatew, kananyain met ateed a powawok, main met hinumwak a piton inuway a mangabeng a kinumpit ye pinahi na a pinayango nin maamot a angin a ampangibat ha dapit daya. ");
INSERT INTO abp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ket imbulon lan mangabeng a inuway ye mangayadet a inuway. Haanin, nakaimukat yay Faraon, ket natandaan na a taynep nan bengat manayti. ");
INSERT INTO abp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ha mahanib ana, angkayoot ye ihip nan Faraon. Kaya-bay impadakit na hilay kaganaan a māghalimangka na boy kaganaan a mangadunong a tatao ha Egipto. Ket intongtong na kanla ye taynep na, noba homain kanla ye makaipalinaw kana nin labay habiyen nin taynep na. ");
INSERT INTO abp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Haanin, hiyay māmaala nin alak nan Faraon, hinabi na kana, “Haanin ko yan bengat naihipan ye pagkamali ko, ta main akon ahe hinabi kamo. ");
INSERT INTO abp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hatew napoot ka kammin māmaala kanlan mamakawto nin tinapay mo boy impapidiho mo kayi ha baey nan kapitan lan māgbantay ha palahyo. ");
INSERT INTO abp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ha maghay madeglem, nanaynep kayin luwa, ket aliwan padiho ye labay habiyen nin taynep mi. ");
INSERT INTO abp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ket main kayi met lamo ihtew a maghay bayontaon Hebreo a ipoh nan kapitan lan māgbantay ha palahyo. Hinabi mi kanay nataynepan mi, ket impalinaw na kammi ye labay habiyen nin taynep mi. ");
INSERT INTO abp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ket nalyadibay ye kaganaan a hinabi na kammi. In-udong mo kon māmaala, noba hiyay māmaala kanlan mamakawto nin tinapay, ket impapatey moya boy impabitin moy bangkay na ha kayo.” ");
INSERT INTO abp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kaya-bay impadakit na yan Faraon ye Jose. Ket tampol la yan in-ilwah ha pidihowan. Pangayadi nan nagpaudog boy naggumi, hinagiliyan nay bado na, ket nakew yaynan inumadap kanan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Hinabi nan Faraon kanan Jose, “Nanaynep ako noba homain makaipalinaw kangko no hinyay labay habiyen nin taynep ko. Main nangihabi kangko a maipalinaw mo no hinyay labay habiyen nin taynep.” ");
INSERT INTO abp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Hinabi nan Jose, “Aliwan hiko, Apo Faraon, noba hiyay Apo Namalyadi, maipalinaw na kamo ye labay habiyen nin taynep mo.” ");
INSERT INTO abp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hinabi nan Faraon kanan Jose, “Ha taynep ko, nakaideng ako ha gilid nin kabatowan Nilo. ");
INSERT INTO abp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kapipikhaan, main nilumakat a pitoy manganged boy mangataba a baka ha kabatowan, ket nangihib hilan iilamon. ");
INSERT INTO abp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Pangayadi, main met nilumakat a piton mangadawa, mangabeng boy main hakit a baka. Homain ako po nakit a wanabay kadawa nin baka ihti ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ket hilay mangadawa boy mangabeng a baka, imbulon la hilay pitoy mangataba a baka a naunan nilumakat. ");
INSERT INTO abp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Noba ba-mon homain nalyadi, ta pangayadi lan imbulon ye manganged boy mangataba a baka, ket mangabeng hila po ateed boy mangadawa. Haanin, nakaimukat ako.” ");
INSERT INTO abp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ket nakatuloy akoyna man boy nanaynep uman. Nakakit ako nin pitoy inuway a mangayadet boy mangalaman ye pinahi na a anhumwak ha maghay powawok. ");
INSERT INTO abp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ket kananyatew met ateed a powawok, main met hinumwak a piton inuway a mangabeng a kinumpit ye pinahi na a pinayango nin maamot a angin a ampangibat ha dapit daya. ");
INSERT INTO abp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ket hilay mangabeng a inuway, imbulon la hilay pitoy mangayadet a inuway. Hinabi ko kanlan māghalimangka ye taynep ko, noba homain kanla ye makaipalinaw no hinyay labay nan habiyen.” ");
INSERT INTO abp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hinabi nan Jose kanan Faraon, “Apo Faraon, hilay tataynep mo ket padiho ye labay nan habiyen. An-ipatanda nan Apo Namalyadi kamo ye madanon naynan diyagen. ");
INSERT INTO abp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Hilay piton mangataba a baka boy pitoy mangayadet a inuway ket pitoy taon. Padiho ye labay habiyen nin luway tataynep. ");
INSERT INTO abp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hilay pitoy mangadawa boy mangabeng a baka a nilumakat boy hilay pitoy inuway a mangabeng a kinumpit ye pinahi na a pinayango nin maamot a angin a ampangibat ha dapit daya, ket pitoy taon a bitil.” ");
INSERT INTO abp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Apo Faraon, omen ha hinabi koyna kamo, wanabay lano ye malyadi. An-ipatanda nan Apo Namalyadi kamo ye madanon naynan diyagen. ");
INSERT INTO abp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Magkamain nin pitoy taon nin kaandoan ha matiboen Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Noba pangayadi nin pitoy taon a kaandoan, magkamain nin pitoy taon a bitil. Uli ha tubat a pangabitil boy homain pupol ha matiboen Egipto, maliwaan lan tatao ha Egipto ye nalabah a panaon nin kaandoan la. ");
INSERT INTO abp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ahe layna tanda ye kaandoan uli ha tubat a kaidapan a madihaan la ha panaon nin bitil. ");
INSERT INTO abp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Luway ukdo kan nanaynep, Apo Faraon, ta-omen mo matandaan ye intaning nan Apo Namalyadi a madanon na yaynan diyagen.” ");
INSERT INTO abp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Kaya-bay haanin, Apo Faraon, katapulan moy mamili nin madunong boy magaling a tao a mamaala ha matiboen Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mandutok ka met nin oopihyal ha matiboen Egipto, ket kowen lay ikalimay dakay nin kaganaan a pupol ha Egipto ha loob nin pitoy taon nin kaandoan. ");
INSERT INTO abp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kananyatew a panaon, katapulan a tiponen lan oopihyal mo ye kaganaan a ikaliman dakay nin pupol lan tatao. Ket makauli ha bilin mo, ikamalig lan oopihyal mo ha balang banwa nin Egipto boy pabantayan la yan manged. ");
INSERT INTO abp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Hilatin matipon ket italadan a pamangan lan tatao ha lumateng a pitoy taon a bitil ha Egipto. Ha wanabay, ahe hila matey nin bitil ye tatao ha Egipto.” ");
INSERT INTO abp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nalabayan nan Faraon boy oopihyal na ye monikala nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ket hinabi nan Faraon kanlan oopihyal na, “Homain kitawoynan makitan a tao a omen kanan Jose a anlamoan nin Ihpidito nan Apo Namalyadi.” ");
INSERT INTO abp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kaya-bay hinabi nan Faraon kanan Jose, “Ulita impatanda nan Apo Namalyadi kamo yatin kaganaan, homain anan kanayon a tao a madudunong boy magagaling a omen kamo. ");
INSERT INTO abp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Hikaynay pabaalaen ko ha panakopan ko, ket manumbong hilan kaganaan kamo ye tatao ko. Noba umiigit ako po kamo, ta hikoy poon ihti ha Egipto.” ");
INSERT INTO abp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Hinabi nan Faraon kanan Jose, “Ket haanin, diyagen kataynan gobilnadol ha matiboen Egipto.” ");
INSERT INTO abp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inoh-pok nan Faraon ha galamay na ye hinghing na a pagmalka na, ket impahinghing na kanan Jose. Ket pinabadowan na yan mablin bado boy pinaonoan naya po nin balitok a ono. ");
INSERT INTO abp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pinahakay na yan Faraon ye Jose ha kaliha nin ikalwa ha kapalyadiyan na. Main tataon nuna kanan Jose ha pagdanan na a ampangipangha nin wanae, “Manalimukod kawo kanan Gobilnadol!” Ket paibat ana kananyatew, hiyaynay Jose ye gobilnadol ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hinabi nan Faraon kanan Jose, “Hiko ye Faraon ha Egipto, noba homain ayaman ye malyadin manyag nin hinyaman ha Egipto, no homain kan paluboh.” ");
INSERT INTO abp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pangayadi, hiyay Faraon, pinangalanan na yan Zafenat Panea ye Jose. Boy impakahal naya kanan Jose ye Asenat a anak nan Potifera a padi ha On. Ket hiyay Jose, bilang gobilnadol, namaala yayna ha matiboen Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Hiyay Jose ket 30 ye taon na ha nandugi yan naghilbi kanan Faraon. Inumalih ya ha adapan nan Faraon a poon ha Egipto, ket niliwed nay matiboen Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ket ha loob nin pitoy taon, luhbo ye pupol ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ket kananyatew a pitoy taon nin kaandoan, impatipon nan Jose ye kaganaan a dakay a nakwa na ha pupol ha Egipto, ket ingkamalig la ha balang banwa a nakapupolan la. ");
INSERT INTO abp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hiyay luhbo a tidigo a natipon na, ket omen ha langhi ha dagat ye kalabong na. Ket uli ha kalabong nin tidigo, in-itgen laynay paglihta, ta ahe layna mahbaan takalen. ");
INSERT INTO abp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bayo lumateng ye panaon nin bitil, nagkaanak yay Jose nin luway laki kanan Asenat a anak nan Potifera a padi ha On. ");
INSERT INTO abp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Pinangalanan na yan Manase ye makaagat, ket hinabi na, “Hinaglapan na kon Apo Namalyadi a maliwaan koy kaidapan a nadihaan ko boy liyew ko kanlan kabaey nan bapa ko.” ");
INSERT INTO abp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Efraim met ye impangalan na ha ikalwan anak na, ket hinabi na, “Binyan na kon Apo Namalyadi nin aanak ha lugal a nakapatiyatiyaan ko.” ");
INSERT INTO abp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nayadi ye pitoy taon nin kaandoan ha Egipto, ");
INSERT INTO abp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ket nanduginay pitoy taon a panaon nin bitil, a omen ha hinabi nan Jose. Nagkamain nin bitil ha kaganaan a lulugal, noba ha matiboen Egipto, ket main pamangan. ");
INSERT INTO abp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ha homain hilaynan pamangan ye tatao ha Egipto, nakew hilan nakihabi kanan Faraon. Noba hinabi nan Faraon kanla, “Makew kawo kanan Jose, ket humbongen yoy habiyen na kanyo.” ");
INSERT INTO abp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nitayak anay bitil ha matiboen Egipto, ket pinalukatan nan Jose ye kaganaan a kamalig, ket pinahaliw na hilan pamangan ye Egipsio. ");
INSERT INTO abp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tubat ye bitil ha matiboen babe-luta. Kaya-bay hilay tataon ibat ha kaganaan a nanahyon, ket ampakew hila ha Egipto a manaliw nin pamangan kanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nabalitaan nan Jacob a main tidigo ha Egipto. Kaya-bay hinabi na kanlan aanak na a laki, “Yo! Ampamano kawo po nayi? ");
INSERT INTO abp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nabalitaan ko a main pamangan ha Egipto. Kaya-bay makew kawo ihtew, ket manaliw kawon pamangan ta-omen kitawo ahe matey bitil.” ");
INSERT INTO abp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kaya-bay nakew hilan peteg ha Egipto ye mapo a katongno nan Jose ta-omen hila manaliw nin pamangan. ");
INSERT INTO abp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Noba hiyay Jacob, ahe na yan impakilakew ye Benjamin a ali nan Jose, ulita angkalimo yan maka main maloke a malyadi kana. ");
INSERT INTO abp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kaya-bay nakew hilaynay aanak nan Jacob ha Egipto ta-omen hila manaliw nin pamangan. Main met kanayon a taga Canaan ye nakew manaliw nin pamangan ha Egipto, ta main bitil ha matiboen Canaan. ");
INSERT INTO abp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Hiyay Jose, bilang Gobilnadol ha Egipto, hiyabay ye ampaglako nin pamangan ha kaganaan a tatao. Kaya-bay ha nilumateng hilay kakatongno na ha Egipto, nilumukob hila ha adapan na. ");
INSERT INTO abp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pamakakit nan Jose kanlan kakatongno na, nabigbig na hilan tampol, noba nagkonwadi yan ahe na hila katatanda boy matubag yan nanepet kanla, “Taga way-ihtew kawo?” “Taga Canaan kayi, Apo. Nakew kayi ihti ta-omen manaliw nin pamangan,” wanla. ");
INSERT INTO abp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nabigbig na hilan Jose ye kakatongno na, noba ahe la yan nabigbig. ");
INSERT INTO abp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Naihipan nan Jose ye taynep na tungkol kanla, ket hinabi na kanla, “Māniem kawo! Kaya-bay nakew kawo ihti, ta labay yon matandaan no way-ihtew ha nahyon mi ye homain māgbantay, kali?” ");
INSERT INTO abp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Hinabi la, “Ahe, Apo. Aliwa kayin māniem. Nakew kayi ihtin manaliw bengat nin pamangan. ");
INSERT INTO abp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mikakatongno kayin kaganaan ha bapa, Apo, boy peteg ye anhabiyen mi. Aliwa kayin māniem, Apo.” ");
INSERT INTO abp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Hinabi nan Jose kanla, “Aliwan peteg yain! Nakew kawo ihti ha lugal mi ta-omen yo matandaan no way-ihtew ye homain māgbantay.” ");
INSERT INTO abp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Noba hinabi lan mikakatongno, “Labinluwa kayin mikakatongno, Apo, boy mamaghan bengat ye bapa mi, ket anti ya ha Canaan haanin. Ket hiyay bonho mi, nabantak ya kana. Ket hiyay magha po a katongno mi, Apo, natey yayna.” ");
INSERT INTO abp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hinabi nan Jose kanla, “Wangko bayna, māniem kawo! ");
INSERT INTO abp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Huboken katawo no peteg ye anhabiyen yo. An-ihumpa ko ha ngalan nan Faraon a ahe kawo makaalih ihti no ahe yoya mailakew ihti ye katongno yon bonho. ");
INSERT INTO abp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hali! Paulien yoy magha kanyo, ta ilakew naya ihti, noba hilay mabantak, ket ikulong hila angga ha mapaptegan ye anhabiyen yo. Ta no ahe, an-ihumpa ko ha ngalan nan Faraon a māniem kawon peteg!” ");
INSERT INTO abp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ket impakulong na hilan kaganaan ha loob nin tatloy mangaamot. ");
INSERT INTO abp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ha ikatlon mangaamot, hinabi nan Jose kanla, “Main akon limo kanan Apo Namalyadi. Kaya-bay ahe katawo ipapatey, no humbongen yoy habiyen ko. ");
INSERT INTO abp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","No peteg ye anhabiyen yo, magbantak ye magha kanyo ha kulongan, noba hilay kanayon, muli ana. Kadten lay pamangan lan angkabitil a papamilya yo. ");
INSERT INTO abp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Noba katapulan a mag-udong kawon tampol, lamo yo yay bonho a katongno yo ta-omen mapaptegan ye anhabiyen yo, ket ahe kawo matey.” Ket wanabay ye dinyag la. ");
INSERT INTO abp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hinabi la ha magha boy magha, “Homain hapo a angkapaduhaan kitawo haanin uli ha dinyag tawo kanan katongno tawo. Nakit tawoy pag-idap na hatew ha nakiiingalo ya kantawo, noba ahe tawo yan iningalowan. Kaya-bay ampagdiha kitawoyna haanin nin kaidapan.” ");
INSERT INTO abp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hinabi nan Reuben kanla, “Aliwa nayi a hinabi ko kanyo hatew a adi yoya ampahakitan ye anak, noba ahe yoko lingnge! Kaya-bay angkapaduhaan kitawoyna haanin ha pagkamatey na.” ");
INSERT INTO abp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ahe la tanda a angkatalohan nan Jose ye anhabiyen la, ulita ha pamakitongtong na kanla, ket main ampangipataloh nin anhabiyen na. ");
INSERT INTO abp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Inalihan na hilan Jose, ket tinumangih ya. Noba nag-udong ya boy nakitongtong yayna man kanla. Imbilin nan Jose kanlan iipoh na a ilbo la yay Simeon kanlan kakatongno na haka na yan ipabalol ha adapan la. ");
INSERT INTO abp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Pangayadi, imbilin nan Jose kanlan iipoh na a pon-en lan tidigo ye lalanggothi lan kakatongno na boy ikonin lay pilak a imbayad lan kakatongno na ha langgothi nin balang magha kanla. Imbilin na po a pabawonan la hilan pamangan ha pangumodang la. Ket nahumbong ye kaganaan a bilin nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pangayadi, ingkalga lan mikakatongno ha aahno la ye hinaliw la a pamangan, ket inumalih hilayna. ");
INSERT INTO abp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ha andudumeglem ana, tinumgen hila ha pangumodang la ta-omen hila magpainawa. Magha kanla ye nanlukat nin langgothi na ta-omen na pakanen ye ahno na, ket nakit nay pilak a pinamayad na a nakapahababe ha pamangan. ");
INSERT INTO abp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hinabi na kanlan kakatongno na, “In-udong lay pilak a pinamayad ko! Anti ya ha langgothi ko!” Nilumopta hilan kaganaan boy nalimowan. Naytepet-tepet hila ha balang magha, “Hinya ket ye dinyag nan Apo Namalyadi kantawo?” ");
INSERT INTO abp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pamiabot la ha Canaan, tinongtong la kanan bapa la a Jacob ye kaganaan a nalyadi kanla. Hinabi nin magha kanla, ");
INSERT INTO abp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Tatang, hiyay gobilnadol nin Egipto, ket matubag yan naghabi kammi boy binadaan na kayin māniem. ");
INSERT INTO abp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Noba hinabi mi kana, ‘Peteg ye anhabiyen mi. Aliwa kayin māniem. ");
INSERT INTO abp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Labinluwa kayin mikakatongnon lalaki boy mamagha ye bapa mi.’ Hinabi mi po kana a hiyay magha min katongno ket natey yayna, ket hiyay bonho mi, kalamo na yan bapa mi ha Canaan.” ");
INSERT INTO abp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Hinabi nan Gobilnadol nin Egipto kammi, ‘Wanae ko yan mapaptegan ye anhabiyen yo! Mabantak ya ihti kangko ye magha kanyo, ket muli kawoyna. Kadten yoy pamangan kanlan angkabitlan a papamilya yo. ");
INSERT INTO abp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Noba ilakew yoya ihti kangko ye bonho a katongno yo ta-omen ko matandaan a aliwa kawon māniem boy ampaghabi kawon kaptegan. Pangayadi, iudong koya kanyo ye katongno yo boy malyadi kawoynan magpanapolan ihti ha Egipto,’ wana kammi.” ");
INSERT INTO abp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ha an-ibohboh laynay laman nin lalanggothi la, nakit nin balang magha kanla ye pilak a pinamayad la a nakakobot. Ha nakit lan mitatalabapa ye nakakobot a pilak, ket nalimowan hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Hinabi nan Jacob kanla, “Labay yon maalihan akoyna nin anak! Ahe yaynay Jose. Ahe yayna met ye Simeon. Ket haanin, labay yoya po kowen ye Benjamin? Angkaidapan ako baynan tubat!” ");
INSERT INTO abp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hinabi nan Reuben kanan bapa na, “Tatang, no ahe koya maiudong kamo ye Benjamin, malyadi mo hilan pateyen ye luwa kon aanak. Ipataya moya kangkoy Benjamin, ket iudong koya met ateed kamo.” ");
INSERT INTO abp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Noba hinabi nan Jacob, “Ahe koya ipakilakew kanyo ye anak ko. Natey yaynay katongno na, ket hiyaynan bengat ye napatla a anak ko kanan Raquel. Maka main maloke a malyadi kana ha dān. Ket no mapetegan yatew, yati nan kapotian nin labok ko, ket ikamatey koynay tubat a kalelean ko.” ");
INSERT INTO abp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tubat po ye pangabitil ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ha nauboh laynan pamilya nan Jacob ye pamangan a hinaliw la ha Egipto, hinabi nan Jacob kanlan aanak na, “Mag-udong kawon manaliw uman nin makandin pamangan ha Egipto.” ");
INSERT INTO abp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Noba hinabi nan Juda kana, “Mahehpet ye bilin nan Gobilnadol kammi a ahe na kayi adapen no ahe mi yan mailamo ye katongno min bonho. ");
INSERT INTO abp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","No ipakilakew moya kammi ye Benjamin, mag-udong kayin manaliw nin pamangan ihtew. ");
INSERT INTO abp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Noba no ahe mo yan ipakilakew, ahe kayi makew, ta hinabi nan Gobilnadol kammi a ahe na kayi adapen no ahe mi yan mailamo ye katongno min bonho.” ");
INSERT INTO abp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Hinabi nan Jacob, “Ahe yoyna dayi hinabi kana a main kawo po ali. Binyanan yo kon mabyat a gotgot.” ");
INSERT INTO abp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Hinabi la, “Pinakatepet nan manged ye tungkol kammi boy ha pamilya tawo. Tinepet na kammi no angkabi-ay ya po ye bapa mi boy no main kayi po kanayon a katongno. Ket pinakibatan min bengat ye tetepet na. Ahe mi tanda a ipakwa na yay Benjamin kammi boy iadap kana.” ");
INSERT INTO abp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Hinabi nan Juda kanan bapa na, “Tatang, ipakilakew mo yaynay Benjamin kangko, ket tampol kayinan makew ta-omen kitawo ahe matey bitil. ");
INSERT INTO abp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Hikoy makibat no main maloke a malyadi kana. No ahe ko yan maiudong kamo a angkabi-ay, hikoy heheen mo legan angkabi-ay ako. ");
INSERT INTO abp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","No ahe kayi naaba, nikalwa kayina dayin nakalakew boy nakaudong haanin.” ");
INSERT INTO abp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Haanin, hinabi nan bapa la a Jacob kanla, “No wanabay awod, kokawoyna. Mangitukoy kawo ha lalanggothi yo nin pinakamanged a pagbi-ay ihti ha lugal tawo, ket idigalo yo kanan Gobilnadol nin Egipto nangaanon balhamo, pulot panilan, pampalahap, pabango, dawa nin pihtahyo boy almendra. ");
INSERT INTO abp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dobliyen yoy kadten yon alaga nin pilak, ulita katapulan yon iudong ye pilak a pinamayad yo a in-udong la ha lalanggothi yo. Maka nagkamali hilan bengat. ");
INSERT INTO abp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hali awod, ilamo yo yaynay katongno yon Benjamin boy tampol kawoynan mag-udong kanan Gobilnadol. ");
INSERT INTO abp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Paingalowen naya dayin Apo Namalyadi a Makapalyadiyan ye Gobilnadol kanyo ta-omen naya iudong kanyo ye Simeon boy Benjamin. No ahe hila man miudong, ket tanggapen koynan luboh ha nakem ko ye kalelean ko.” ");
INSERT INTO abp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kaya-bay nangaget hilay mikakatongno nin idigalo la boy dinobli lay kaget la a alaga nin pilak. Pangayadi, inumalih hilayna paudong ha Egipto lamo la yay Benjamin, ket nakikit hila kanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ha nakit nan Jose a kalamo la yaynay Benjamin, hinabi na kanan māmaala nin baey na, “Ilakew mo hilayatin tatao ha baey ko. Manapo kan ayop boy mamakawto kan pamangan, ta kalamo ko hilan mangugto.” ");
INSERT INTO abp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Hinumbong nan māmaala ye bilin nan Jose, ket inggaygay na hilay mikakatongno palakew ha baey nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ha an-ilakew na hila ha baey nan Jose, angkahindakan hila ulita an-ihipen la, “Mapalyadin ilakew la kitawo ihtew uli ha pilak a in-udong la ha langgothi tawo ha una kitawon nakew ihti. Maka dakpen na kitawoyna boy kowen nay aahno tawo, ket diyagen na kitawoynan ipoh na.” ");
INSERT INTO abp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kaya-bay ha anti hilayna ha ilwangan nin baey, hinaleyan la yay māmaala nin baey nan Jose, ket kinatongtong laya. ");
INSERT INTO abp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Hinabi la, “Apo, nakew kayina ihti ha Egipto a nanaliw nin tidigo hatew. ");
INSERT INTO abp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Noba ha tinumgen kayi ha maghay lugal ulita madeglem ana, nilukatan mi ye lalanggothi mi, ket nakit nin magha boy magha kammi ye huhton alaga a pinamayad mi nin tidigo a hinaliw mi. Tiya, ket iudong mi yayna kamo. ");
INSERT INTO abp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Main kayin kanayon a pilak a panaliw nin pamangan. Ahe mi tanda, Apo, no ayay nangikonin nin pilak ha langgothi mi.” ");
INSERT INTO abp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hinabi nan māmaala, “Adi kawo angkahindak boy adi kawo angkalimo. Hiyay Apo Namalyadi yo a Apo Namalyadi na met ateed bapa yo ye nangikonin nin pilak ha lalanggothi yo. Natanggap koy pinamayad yo hatew.” Pangayadi, in-ilwah na yan māmaala ye Simeon, ket inlakew naya kanlan kakatongno na. ");
INSERT INTO abp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Pinaloob na hilan māmaala ha baey nan Jose, ket binyan na hilan lanom ta-omen la uyahan ye bibitih la boy binyan na hilan ipakan la ha aahno la. ");
INSERT INTO abp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Haanin, intaladan lan mikakatongno ye idigalo la kanan Jose ha panlumateng na. Ta nange la a ihtew hila mangugto ha baey nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ha nilumateng yay Jose ha baey na, inlakew la kana ye didigalo la boy nilumukob hilan kaganaan ha adapan na. ");
INSERT INTO abp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kinumohta na hilan Jose. Pangayadi, tinepet na hila, “Kumohta ya met ye bapa yo a hinabi yo kangko hatew a matoayna? Angkabi-ay ya po nayi?” ");
INSERT INTO abp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Hinabi la, “Angkabi-ay ya po, Apo, boy makhaw ya po ye bapa mi.” Ket nanalimukod hila boy nilumukob ha luta ha adapan na. ");
INSERT INTO abp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pamakakit nan Jose kanan Benjamin a katongno na ha mamaghay puhel, nanepet ya, “Yabayti ya nayi ye katongno yon bonho a hinabi yo kangko?” Hinabi na kanan Benjamin, “Inong, inged naka dayin Apo Namalyadi!” ");
INSERT INTO abp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Natanggil ye tanam nan Jose ha pamakakit na kanan katongno na. Mapadah yan nilumwah ulita ampakatangih-tangih yayna. Kaya-bay nilumoob ya ha hilid na, ket ihtew yayna tinumangih. ");
INSERT INTO abp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pangayadi, nag-olameh ya, ket nag-udong yayna kanla a ampakabenbenen nay tanam na. Ket hinabi na kanlan iipoh na, “Iapag yoynay pamangan.” ");
INSERT INTO abp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hiyay Jose, inapagan la yan pamangan a bubukod na ha maghay lamihaan. Ket hilay kakatongno na, inapagan la hilan pamangan ha kanayon a lamihaan. Lumbo met ye lamihaan lan Egipsio, ulita an-ikading-ey la hilan makadongo ye Hebreo. ");
INSERT INTO abp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Hilay kakatongno nan Jose, ket ampikno hila ha adapan nan Jose. Napaybilew-bilew hila boy ampagtaka, ta pinaikno la hilan napay-adaad paibat ha punganay anggan bonho. ");
INSERT INTO abp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Inapagan la hilan iipoh nin pamangan ibat ha lamihaan nan Jose, noba hiyay pamangan a in-apag la kanan Benjamin ket liman okdo ye kalabong na dinan kanlan kakatongno na. Mahayaghag hilan nangan boy ninom. ");
INSERT INTO abp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Haanin, imbilin nan Jose kanan māmaala nin baey na, “Pon-en mon pamangan ye langgothi la angga ha mababa lan kadten, boy ipahababe mo ha loob nin langgothi nin balang magha ye pilak a pinamayad la. ");
INSERT INTO abp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pangayadi, ipahababe mo po ye mital a pinoman ko ha langgothi nan bonho kalamo ye pilak a imbayad na nin pamangan.” Ket hinumbong na met māmaala ye hinabi nan Jose kana. ");
INSERT INTO abp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kabekahan, ha mahanib-hanib po, hilay mikakatongno dayon aahno la, ket pinalubohan na hilaynan muli. ");
INSERT INTO abp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ha ahe hila po nipakataang ha banwa, hinabi nan Jose kanan māmaala, “Padah mo! Kamaten mo hilayatew a tatao! Ket no mabon mo hilayna, habiyen mo kanla, ‘Taket ta maloke ye imbae yo ha manged a dinyag mi kanyo? ");
INSERT INTO abp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Taket ta tinakaw yoy mital a pinoman nan amo ko a anggawien na ha pamaltep? Maloke a tubat yatin dinyag yo!’ ” ");
INSERT INTO abp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ha nabonan na hilaynan māmaala, ket hinabi na kanla ye impahabi nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Noba hinabi la kanan māmaala, “Way-omen mo mahabi yain, Apo? Hikayin ipoh mo, agya makanoman ahe mi madyag yain! ");
INSERT INTO abp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tanda yoynabay met a agya niabot kayi ha Canaan, ket in-udong mi kanyo ye pilak a nakit mi ha loob nin langgothi mi. Taket ta manakaw kayi po nin pilak o balitok ha baey nan amo mo? ");
INSERT INTO abp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Apo, no makitan mo ye pinoman a anhabiyen mo ha ayaman kammi, ket pateyen moya boy hikayin kaganaan, ket diyagen moynan ipoh na.” ");
INSERT INTO abp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Hinabi nan māmaala, “Hige! Ayaman kanyo ye pakakitan ko nin pinoman, ket diyagen ko yan ipoh ko. Ket hilay kanayon, homain hilan pakibatan.” ");
INSERT INTO abp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kaya-bay dinandali nin balang magha a ilumbah ye langgothi na boy nilukatan la. ");
INSERT INTO abp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ket hiyay māmaala, titimagha na yan binokitkit ye lalanggothi la paibat ha punganay anggan bonho, ket nakitan na yay mital a pinoman ha langgothi nan Benjamin. ");
INSERT INTO abp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pamakakit lan kakatongno na, giniwak lay babado la uli ha tubat a lele la. Ket ingkalga lan uman ha aahno la ye langgothi la, ket nag-udong hila ha banwa. ");
INSERT INTO abp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Hiyay Jose, anti ya po ha baey na ha nilumateng yay Juda boy hilay kakatongno na. Ket nilumukob hila ha adapan nan Jose. ");
INSERT INTO abp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Hinabi nan Jose kanla, “Hinyatin dinyag yo? Ahe yo nayi tanda a matandaan koy dinyag yo makauli ha paltep? Kaya-bay homain kawon maitayo kangko!” ");
INSERT INTO abp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Hinabi nan Juda, “Homain kayin mahabi, Apo. Homain kayin maikatulidan ha nalyadi. Hiyay Apo Namalyadi ye nangipatanda nin kahalanan mi. Kaya-bay hikayin kaganaan dayon yay kinakitan nin pinoman mo, ket ipoh moyna haanin.” ");
INSERT INTO abp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hinabi nan Jose, “Ahe! Ahe ko madyag yain. Hiyay kinakitan bengat nin pinoman ko ye diyagen kon ipoh ko. Hilay kanayon ket malihway hilaynan muli kanan bapa yo.” ");
INSERT INTO abp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Haanin, hiyay Juda, hinumaley ya kanan Jose boy hinabi na, “Apo Gobilnadol, an-ipakiiingalo ko kamo. No malyadi dayi, ket leng-en mo kon dumali. Adi ka dayi mapoot kangko agya padiho ye kapalyadiyan mo kanan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Apo, tinepet mo hatew no main kayi po bapa o katongnon laki. ");
INSERT INTO abp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ket hinabi mi met a main kayi po bapa a matoayna boy main kayin katongno a laki a nianak ha pangatoay na. Hinabi mi po a natey yaynay katongno na, ket hiyaynan bengat ye angkabi-ay a anak nan indo na. Ket ampakaadoen na yan bapa mi.” ");
INSERT INTO abp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Pangayadi, hinabi mo kammin iipoh mo, Apo, a ilamo miya ihti ta-omen mo yan makit. ");
INSERT INTO abp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Hinabi mi met kamo hatew a ahe na yan malyadin lakwanan Benjamin ye bapa mi, ta no lakwanan naya, ket ikamatey nan bapa mi. ");
INSERT INTO abp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Noba, Apo, hinabi mo met kammin iipoh mo a agmo kayin adapen no ahe mi yan kalamo ye katongno min bonho. ");
INSERT INTO abp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ket ha nuli kayina kanan bapa ko, Apo, hinabi ko met kana ye hinabi mo. ");
INSERT INTO abp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ha ahe nabuyot, hinabi na kammin bapa mi a mag-udong kayi ihti ta-omen manaliw uman nin makandin pamangan. ");
INSERT INTO abp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Noba hinabi mi kana, ‘Ahe kayi malyadin makew ha Egipto no ahe mi yan kalamo ye katongno min bonho, ulita ahe kayi malyadin makikit kanan Gobilnadol no ahe mi yan kalamo.’ ” ");
INSERT INTO abp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Hinabi na kammin bapa mi a ipoh mo, ‘Tanda yobayna met a luluwa ye anak ko kanan Raquel. ");
INSERT INTO abp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ahe yaynay magha, ket homain hapo a pinaybayitbayitan yan matubag a ayop. Ket paibat hatew ahe ko yaynan nakit. ");
INSERT INTO abp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ket no kowen yoya po kangko ye bonho ko, ket no mipaloke ya, yati nan kapotian nin labok ko, ket ikamatey koyna ye tubat a kalelean ko.’ ” ");
INSERT INTO abp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Kaya-bay Apo Gobilnadol, no muli ako kanan bapa ko a ahe mi yan kalamo ye Benjamin, ket hiyay bi-ay nan bapa mi, nipalabon ya kana, ");
INSERT INTO abp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ket no ahe naya makit ye Benjamin, Apo, yatew a kapotian nin labok na, ket ikamatey nayna ye tubat a kalelean na. ");
INSERT INTO abp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Hikon ipoh mo, impangako ko kanan bapa ko a no ahe koya maiudong kana yatin anak, hikoy heheen na legan angkabi-ay ako.” ");
INSERT INTO abp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Haanin, no ipaluboh mo Apo Gobilnadol, hikoynay diyagen mon ipoh mo bilang kahagiliyan nan bonho mi. Ket palubohan mo yayna dayi a muli ye bonho mi kalamo la yan kakatongno na. ");
INSERT INTO abp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ahe ako malyadin muli kanan bapa ko a ahe koya kalamo ye bonho mi. Ahe ko mikpen bilewen ye maloke a malyadi kanan bapa mi.” ");
INSERT INTO abp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ahe nayna angkabenbenan Jose ye tanam na ha adapan lan iipoh na. Kaya-bay pinaalih na hila. Ket ha hila-hilaynan bengat a mikakatongno, impatanda na yaynay hadili na kanla. ");
INSERT INTO abp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tinumangih yan makhaw, ket nange la yan Egipsio boy nabalitaan lan kabaey nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Hinabi nan Jose kanlan kakatongno na, “Hiko yay Jose! Angkabi-ay ya po lagi ye bapa ko?” Noba ahe hila nakatnoy ye kakatongno na, ulita naoblakan boy nalimowan hilan tubat. ");
INSERT INTO abp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kaya-bay hinabi nan Jose kanlan kakatongno na, “Humaley kawo kangko.” Ha hinumaley hilayna, hinabi na, “Hiko yay Jose a katongno yo a inlako yo a nipalakew ihti ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Adi kawo angkahindak boy adi yo anheheen ye hadili yo ha pangilako yo kangko, ulita impauna na kon Apo Namalyadi kanyo ihti ta-omen miligtah ye bi-ay lan tatao. ");
INSERT INTO abp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ta kakalwan taon po bengat nin pangabitil haanin. Main po limay taon a homain pananem boy homain pamupol. ");
INSERT INTO abp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pinauna na kon Apo Namalyadi ihti ta-omen kawo miligtah boy magpahulong a lumabong ye lalahi yo ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Kaya-bay aliwan hikawoy nangipalakew kangko ihti no aliwan hiyay Apo Namalyadi. Dinyag na kon mamabala kanan Faraon, māmaala nin baey na boy gobilnadol nin matiboen Egipto. ");
INSERT INTO abp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Haanin, mag-udong kawon tampol kanan bapa ko boy habiyen yo kana a dinyag na kon gobilnadol ha matiboen Egipto nin Apo Namalyadi. Boy habiyen yo kana a tampol ko yan ampalakwen ihti. ");
INSERT INTO abp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ihtew ya kumonin ha lugal a Goshen ta-omen ya mahaley kangko, kalamo na hilay kaganaan a aanak na boy aapo na, aayop na a tupa, kambing, baka, boy kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","No anti yayna ha Goshen, hikoynay mamyay nin matapul na ulita main po limay taon nin pangabitil. Ahe ko labay a mabitlan ya, hilay papamilya na boy kaganaan a aayop na.” ");
INSERT INTO abp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hinabi na po Jose, “Pakabalayen yoko man, lalalo ana kamo, Benjamin. Hiko yan peteg ye Jose a ampaghabi kanyo. ");
INSERT INTO abp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Habiyen yo kanan bapa ko no way-omen lako ambihaen ihti ha Egipto boy hilay kaganaan a nakit yo. Ket ilakew yo yan tampol ihti kangko ye bapa ko.” ");
INSERT INTO abp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Pangayadi, tinakeh na yan Jose ye katongno na a hiyay Benjamin boy tinumangih ya. Tinumangih ya met ye Benjamin a nakatakeh kanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Pahulong yan antumangih legan an-umaan na hilay kaganaan a kakatongno na. Pangayadi, nakitongtong hilayna kana ye kakatongno na. ");
INSERT INTO abp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ha nakalateng ye balita ha palahyo nan Faraon a nilumateng hilaynay kakatongno nan Jose, naaliket yay Faraon boy hilay oopihyal na. ");
INSERT INTO abp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Hinabi nan Faraon kanan Jose, “Habiyen mo kanlan kakatongno mo a kalgaan lan pamangan ye aayop la boy mag-udong hila ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ilakew laya ihti ye bapa yo boy pamilya yo. Ibyay ko kanla ye pinakamanged a luta ihti ha Egipto boy pakinabangan lay pinakamanged a pamangan ihti. ");
INSERT INTO abp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Habiyen mo met kanla a mangitaban hilan kakaliha ibat ihti ha Egipto ta-omen main hilan hakayan ye aahawa la dayon aanak la ha pamakew la ihti. Boy ilakew laya ihti ye bapa la. ");
INSERT INTO abp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Adi layna angkawaenen ye mabantak a babandi la ihtew, ulita mapagkonin lay pinakamanged a babagay ihti ha matiboen Egipto.” ");
INSERT INTO abp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ket wanabay ye dinyag lan aanak nan Jacob. Ket uli ha bilin nan Faraon, binyan na hilan Jose nin kakaliha ye kakatongno na dayon bawon la ha pangumodang la. ");
INSERT INTO abp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Binyanan na hila met nin bayon bado ye balang magha kanla. Noba hiyay Benjamin, binyanan na yan 300 a palatan mital boy liman padih a bado. ");
INSERT INTO abp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pinawitan naya met ye bapa na nin mapo a aahno a nakalgaan nin pinakamanged a babagay ha Egipto boy mapo a babayin aahno a nakalgaan nin pamangan boy tinapay boy kanayon po a pamangan a kanen nan bapa la ha pangumodang na palakew ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pangayadi, intubol na hilaynan Jose ye kakatongno na paudong ha Canaan. Ket ha pangumalih la, hinabi na kanla, “Adi kawo ampay-away ha dān.” ");
INSERT INTO abp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kaya-bay inumalih hilayna ha Egipto boy nag-udong hilayna kanan bapa la ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Hinabi la kana, “Tatang, angkabi-ay ya po ye Jose! Ket hiyabay manayti ye gobilnadol nin matiboen Egipto!” Naoblakan yay Jacob. Ahe na pinamtegan. ");
INSERT INTO abp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Noba ha hinabi la kana ye kaganaan a hinabi nan Jose kanla boy ha nakit na ye kakaliha a impataban nan Jose a hakayan na a palakew ha Egipto, ket nilumigha ya. ");
INSERT INTO abp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hinabi nan Jacob, “Ah! Angkabi-ay ya po manayti ye anak kon Jose! Lakwen koya bayo ko matey.” ");
INSERT INTO abp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kaya-bay hiyay Jacob, nakew yayna kaget nay kaganaan a babandi na. Ha niabot hila ha Beer Sheba, nangihagpa ya kanan Apo Namalyadi a Apo Namalyadi nan Isaac a bapa na. ");
INSERT INTO abp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ha madeglem ana, naghabi yay Apo Namalyadi kanan Jacob makauli ha leplep, a wana, “Jacob, Jacob!” “Anti ko ihti, Apo,” wanan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Hinabi nan Apo Namalyadi, “Hiko yay Apo Namalyadi a Apo Namalyadi nan bapa mo. Adi ka angkalimon makew ha Egipto. Ta diyagen ko hilan angkabalitaan a nahyon ihtew ye lalahi mo. ");
INSERT INTO abp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Hiko ye lamo mo ha pamakew mo ha Egipto boy iudong katan uman ihti ha Canaan. Ket lano matey ka, anti yay Jose ha talig mo.” ");
INSERT INTO abp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hiyay Jacob, inhakay la yan aanak na ha kaliha a impataban nan Faraon a hakayan na. Inhakay la hila met ye aahawa boy aanak la. Ket inumalih hilayna ha Beer Sheba. ");
INSERT INTO abp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kaya-bay hiyay Jacob boy hilay lalahi na, ket nakew hila ha Egipto. Kinaget la hila met ye aayop boy babandi la a natipon la ha Canaan. ");
INSERT INTO abp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kinaget nan Jacob ha Egipto ye kaganaan a aanak na boy aapo na boy kaganaan a lalahi na. ");
INSERT INTO abp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Hilayati ye ngangalan lan Israelita a nakew ha Egipto. Hiyay Reuben ye punganay nan Jacob. ");
INSERT INTO abp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Hilay aanak nan Reuben ket hilan Hanoc, Palu, Hezron boy Carmi. ");
INSERT INTO abp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Hilay aanak nan Simeon ket hilan Jemuel, Jamin, Ohad, Jakin, Zohar, boy hiyay Shaul a anak na ha babayin Cananea. ");
INSERT INTO abp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Hilay aanak nan Levi ket hilan Gershon, Kohat boy Merari. ");
INSERT INTO abp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Hilay aanak nan Juda ket hilan Er, Onan, Shela, Perez boy Zera. (Hiyay Er boy Onan ket natey hila ha Canaan.) Hilay aanak nan Perez ket hilan Hezron boy Hamul. ");
INSERT INTO abp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Hilay aanak nan Isacar ket hilan Tola, Pua, Iob boy Shimron. ");
INSERT INTO abp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Hilay aanak nan Zebulun ket hilan Sered, Elon boy Jaleel. ");
INSERT INTO abp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hilayain ye aanak boy aapo nan Jacob kanan Lea a ahawa na. Nianak hilan kaganaan ha Padan Aram, powida yay Dina a anak na a babayi. 33 hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Hilay aanak nan Gad ket hilan Zefon, Hagi, Shuni, Ezbon, Eri, Arodi boy Areli. ");
INSERT INTO abp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Hilay aanak nan Asher ket hilan Imna, Ishva, Ishvi, Beria boy hiyay babayin katongno la a hiyay Sera. Hilay aanak nan Beria a hilan Heber boy Malkiel. ");
INSERT INTO abp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hilayain ye aanak boy aapo nan Jacob kanan Zilpa a ipoh nan Lea a in-ibyay nan Laban. 16 hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Hilay aanak nan Jacob kanan Raquel a hilan Jose boy Benjamin. ");
INSERT INTO abp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Hilay aanak nan Jose kanan Asenat a anak nan Potifera a padi ha banwa nin On ket hilan Manase boy Efraim. Nianak hilan luwa ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Hilay aanak nan Benjamin ket hilan Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim boy Ard. ");
INSERT INTO abp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hilayain ye aanak boy aapo nan Jacob kanan Raquel a ahawa na. 14 hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Hiyay anak nan Dan ket hiyay Hushim. ");
INSERT INTO abp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Hilay aanak nan Naftali ket hilan Jahzeel, Guni, Jezer boy Shilem. ");
INSERT INTO abp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hilayain ye aanak boy aapo nan Jacob kanan Bilha. Hiyay Bilha ket ipoh nan Raquel a in-ibyay nan Laban. 7 hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Hiyay bilang lan kaganaan a aanak boy aapo nan Jacob a nakew ha Egipto ket 66 powida hilay mamanuyang na. ");
INSERT INTO abp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kalamo hilay luwa a anak nan Jose a in-anak ha Egipto, ket 70 hilan kaganaan ye lalahi nan Jacob a naytipon ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Haanin, hiyay Jacob, intubol na yay Juda a munan makew kanan Jose ta-omen ya manepet no way-ihtew ye dān palakew ha Goshen. Ket ha niabot hilaynan Jacob ihtew ha Goshen, ");
INSERT INTO abp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","hinumakay yay Jose ha kaliha na, ket nakew ya ha Goshen ta-omen naya haganaen ye bapa na. Ha nayngikit hilayna, tinakeh na yan Jose ye bapa na, ket nabuyot yan tinumangih. ");
INSERT INTO abp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hinabi nan Jacob kanan Jose, “Haanin nakahadya akoynan matey ulita nakit kataynan angkabi-ay po.” ");
INSERT INTO abp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hinabi nan Jose kanlan kakatongno na boy kanlan kaganaan a kabaey nan Jacob, “Makew ako kanan Faraon boy habiyen ko kana, ‘Hilay kakatongno ko dayon kabaey nan bapa ko a kinumonin ha Canaan, ket nakew hila ihti kangko. ");
INSERT INTO abp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Habiyen ko met kana a māgpahtol kawo, boy kaget yoy kakawan yo, boy kaganaan a babandi yo.’ ");
INSERT INTO abp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","No ipaingat na kawon Faraon boy tepeten na no hinyay abala yo, ");
INSERT INTO abp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","habiyen yo, ‘Hikayin ipoh mo ket māgpahtol kayin aayop paibat po ha anak kayi a omen kanlan tutoa mi.’ Ha wanabay, palubohan na kawon kumonin ha Goshen.” Hinabi na yati kanla, ulita hilay Egipsio, ket kahulog la hilay māgpahtol. ");
INSERT INTO abp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kaya-bay hiyay Jose, nakew ya kanan Faraon boy hinabi na, “Hiyay bapa ko boy hilay kakatongno ko, ket nilumateng hilaynan ibat ha Canaan, kaget lay kakawan boy babandi la. Anti hilayna haanin ihtew ha plobinhiya nin Goshen.” ");
INSERT INTO abp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Namili ya nin lima kanlan kakatongno na, ket in-adap na hila kanan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tinepet na hilan Faraon, “Hinyay abala yo?” “Hikayin ipoh mo, Apo Faraon, ket māgpahtol kayi nin aayop a omen kanlan tutoa mi,” wanla. ");
INSERT INTO abp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hinabi la po kana, “Nakew kayi ihti Apo Faraon, ulita tubat anay pangabitil ha Canaan boy homain kayinan pagpahtolan nin aayop mi ihtew. Ampakikwaen mi kamo, Apo Faraon, a palubohan mo kayi dayin kumonin ha Goshen.” ");
INSERT INTO abp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Hinabi nan Faraon kanan Jose, “Haanin, anti hilayna ihti ye bapa mo boy hilay katongno mo. ");
INSERT INTO abp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Malyadi kan mamili nin kunaan lan papamilya mo ha agya way-ihtew man a lugal ihti ha Egipto. Patintiyen mo yay bapa boy hilay kakatongno mo ha Goshen, a maghan pinakamanged a lugal ihti ha Egipto. No main kan tanda kanla a magaling magpahtol nin aayop, diyagen mo hilan māmaala ha kakawan ko.” ");
INSERT INTO abp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Inlamo na yan Jose ye bapa na a hiyay Jacob boy in-adap naya kanan Faraon. Ket in-inged na yan Jacob ye Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tinepet na yan Faraon ye Jacob, “Anoy nay taon mo?” ");
INSERT INTO abp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Hinabi nan Jacob kanan Faraon, “130 anay taon ko. Matekbe boy maidap ye bi-ay ko ihti ha babe-luta. Aliwan omen kakadang ha bi-ay lan nangaunan tutoa ko.” ");
INSERT INTO abp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pangayadi, in-inged na yan uman ye Faraon, ket inumalih yayna ha adapan nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ket pinatinti na hilan Jose ye bapa na boy kakatongno na ha Rameses a pinakamanged a lugal ha Egipto a omen ha imbilin nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Hiyay Jose, ambiyan na hilan pamangan ye bapa na, kakatongno na boy hilay kaganaan a kabaey nan bapa la, ha kaeteban nin bilang nin aanak la. ");
INSERT INTO abp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kananyatew a panaon, homain hilaynan makan ye tatao ha agya way-ihtew a lugal ulita tubat anay pangabitil. Malupta hilaynay tatao ha Canaan boy ha Egipto uli ha bitil. ");
INSERT INTO abp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ket hiyay Jose, inhinop nay kaganaan a pilak a impanaliw lan pamangan nin taga Egipto boy taga Canaan. Ket inlakew na ha palahyo nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Homain hilaynan pilak a panaliw ye taga Egipto boy taga Canaan. Nakew hilay Egipsio kanan Jose boy hinabi la, “Homain kayinan pilak. Biyan mo kayi dayin pamangan, ulita matey kayinan bitil.” ");
INSERT INTO abp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Hinabi nan Jose, “Ilakew yo awod ihti ye aayop yo, ket biyan katawo nin pamangan a kahagiliyan nin aayop yo, ulita homain kawoynan pilak.” ");
INSERT INTO abp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kaya-bay inlakew la kanan Jose ye aayop la, ket binyan na hilan pamangan bilang kahagili nin kakabayo, tutupa, kakambing, babaka boy aahno la. Kananyatew a taon, ambiyan na hilan Jose nin pamangan bilang kahagili nin aayop la. ");
INSERT INTO abp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pangayadi nin yatew a taon, hilay tatao, nakew hilayna man kanan Jose boy hinabi la, “Apo, ahe mi maibudi kamo a homain kayinan pilak boy hilay aayop mi, ket antinan kaganaan kamo. Homain anan napatla kammi no aliwan hiyay lalaman mi boy luluta mi. ");
INSERT INTO abp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Haglapan mo kayi dayi ta-omen kayi ahe matey bitil ha adapan yo, boy ahe mi mapaolayan ye luluta mi. Haliwen mo kayi dayon luluta mi bilang kahagili nin pamangan. Malabay kayin paipoh kanan Faraon boy mapagkonin nay luluta mi. Biyan mo kayin bini ta-omen kayi ahe matey boy ahe mi mapaolayan ye luluta mi.” ");
INSERT INTO abp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kaya-bay inlako lan Egipsio ye kaganaan a babangkag la uli ha tubat a pangabitil ihtew. Hinaliw nan Jose ye kaganaan a luluta ha Egipto bilang pagkonin nan Faraon. Kaya-bay napagkonin nan Faraon hilatew a luluta ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ket hilay tatao ha Egipto, dinyag na hila met Jose a pag-ipoh nan Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hiyay luluta laynan bengat papadi ye ahe na hinaliw Jose, ulita ambiyan na hilan Faraon nin pamangan. Kaya-bay ahe la katapulan ilako ye luluta la. ");
INSERT INTO abp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hinabi nan Jose kanlan tatao, “Haanin, ta nahaliw katawoyna, dayon luluta yo, ket konin na kawoynan Faraon. Ti hilay bibini a itanem yo. ");
INSERT INTO abp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","No mamupol kawoyna, ibyay yo kanan Faraon ye ikaliman dakay nin pupol yo. Ket hiyay mapatla, konin yoyna ta-omen kawon main pangwaan nin bini a itanem yon uman boy pamangan yon mitapamilya.” ");
INSERT INTO abp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Hinabi lan tatao, “Apo, ampahalamat kayi kamo. Inligtah mo ye bi-ay mi. Pag-ipoh na kayinan Faraon.” ");
INSERT INTO abp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kaya-bay hiyay Jose, dinyag na yan bilin ha matiboen Egipto a hiyay ikaliman dakay nin pupol lan tatao, ket ibyay la kanan Faraon. Ket yatin bilin, an-ipatupad ya po angga haanin. Hiyay luta lan papadi bengat ye ahe na napagkonin Faraon. ");
INSERT INTO abp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kinumonin hilay Israelita ha Goshen a hakop nin Egipto. Nagkamain hila ihtew nin luluta boy malabong anay aanak la. ");
INSERT INTO abp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Hiyay Jacob, ket kinumonin ya ha Egipto ha loob nin 17 a taon. Inumabot ya ha 147 ye taon na. ");
INSERT INTO abp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ha angkatanam naynan Israel a madanon yaynan matey, impaingat na yay Jose, ket hinabi na, “No an-adoen mo kon peteg, ikonin mo ha hilong nin paa ko ye gamet mo boy ipangako mo kangko a pahulong mon ipakit kangko ye kangedan boy kapatayaan mo. Adi moko ilbeng ihti ha Egipto. ");
INSERT INTO abp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Lano matey akoyna, ilwah moko ha Egipto boy ilakew mo kon ilbeng ha nakailbengan lan nangaunan tutoa ko.” “Humbongen ko ye hinabi mo,” wanan Jose. ");
INSERT INTO abp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Hinabi nan Jacob, “Manumpa ka kangko a humbongen mo.” Kaya-bay nanumpa yay Jose. Ket hiyay Jacob, dinumeeng ya ha owan nin pamid-an na a nanggalang kanan Apo Namalyadi. ");
INSERT INTO abp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ha ahe nabuyot, main nangibalita kanan Jose a ampaghakit yay bapa na. Kaya-bay inlamo na yay luwan aanak na a laki a hilan Manase boy Efraim ta-omen laya kewahan ye bapa na. ");
INSERT INTO abp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ha natandaan nan Jacob a nilumateng yay anak na a Jose, pinilit nay nikno ha an-id-an na. ");
INSERT INTO abp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Hinabi nan Jacob kanan Jose, “Ha anti ko po ha Luz ha lugal a Canaan, napakit ya kangkoy Apo Namalyadi a Makapalyadiyan. Ket in-inged nako. ");
INSERT INTO abp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Hinabi na kangko, ‘Pakalabongen koy lalahi mo boy diyagen katan bapa nin malabong a lalahi. Ibyay ko kanla yatin lugal a Canaan a pagkonin la makanoman.’ ” ");
INSERT INTO abp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Hinabi na po Jacob, “Hilay luway anak mo a hilan Efraim boy Manase a nianak ihti ha Egipto bayo ko nilumateng, ket ibilang ko hilan hadili kon anak a omen kanlan Reuben boy Simeon. ");
INSERT INTO abp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Noba hilay dumondon a aanak mo, ket aanak mo hilayna. Makatanggap hilan tawid ibat kanlan Manase boy Efraim. ");
INSERT INTO abp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Naihipan koy pagkamatey nan Raquel a indo mo. Ha pag-udong ko ibat ha Padan Aram, natey ya ha Canaan, ha haley nin Efrata. Ket ingkalele ko yan tubat ye pangamatey na. Ihtew ko yayna in-ilbeng ha gilid nin dān ha haley nin Efrata.” (Hiyay Efrata ket anhabtan yan Betlehem haanin.) ");
INSERT INTO abp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Pamakakit nan Israel kanlan aanak nan Jose, tinepet naya, “Aya hilatin aanak?” ");
INSERT INTO abp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Hinabi nan Jose kanan bapa na, “Hilabay ye aanak ko a in-ibyay nan Apo Namalyadi kangko ihti ha Egipto.” Hinabi nan Israel, “Ihaley mo hila kangko ta-omen ko hila inged.” ");
INSERT INTO abp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Makolapo yaynay pamilew nan Israel hatew ulita matoa yayna. Inhaley na hilan peteg Jose ye aanak na kanan Israel. Ket tinakeh na hilan Israel boy inumaan. ");
INSERT INTO abp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hinabi nan Israel kanan Jose, “Agkoynan inihip a makit kata po uman. Noba haanin, aliwan bengat hika ye nakit ko, impaluboh na po Apo Namalyadi a makit ko hilay aanak mo.” ");
INSERT INTO abp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kingwa na hilan Jose ye aanak na ha haley nin tuol nan Israel, ket nilumukob ya bilang pamiha kanan bapa na. ");
INSERT INTO abp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pangayadi, inhaley na hilan uman kanan Israel ye luway aanak na, hiyay Efraim ha dapit-odi nan Israel, ket hiyay Manase ha dapit wanan na. ");
INSERT INTO abp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Noba pinaykodoh nan Jacob ye gamet na, ket impalonto nay wanan a gamet na ha ō nan makaydeng a hiyay Efraim, ket hiyay odi a gamet na, impalonto na ha ō nan Manase a makaagat. ");
INSERT INTO abp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ket in-inged na hilayna, a wana, “Hiyay Apo Namalyadi a pinaghilbiyan nan Isaac boy Abraham a nangaunan tutoa ko, Apo Namalyadi a nangalingay kangko paibat ha in-anak ako anggayna haanin, ket inged na kawo dayi. ");
INSERT INTO abp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Inged na hila met dayin anghil a nangiligtah kangko ha kaganaan a nakabiliyan ko. Makauli kanlan hilatin aanak, ket maihipan lako dayin tatao boy hiyay ngalan lan Abraham boy Isaac a tutoa ko, boy malabong lano dayi ye lalahi la ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pamakakit nan Jose a hiyay wanan gamet nan Jacob ye impalonto na kanan Efraim, agna yan nalabayan. Kaya-bay ginemgeman nay wanan a gamet nan bapa na ha ō nan Efraim, ket ingkonin naya ha ō nan Manase. ");
INSERT INTO abp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Hinabi na, “Tatang, aliwan hiyabay ye makaagat. Ti ye yay makaagat ha wanan a gamet mo.” ");
INSERT INTO abp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Noba hinabi nan Jacob, “Tanda ko yain, anak ko. Tanda kon mag-ilyadi yan angkabalitaan a tao ye Manase, dayon lalahi na. Noba maiigit ya lano ye makaydeng a katongno na. Mag-ilyadin malabong ye nanahyon lano ye lalahi na.” ");
INSERT INTO abp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kaya-bay maiigit yay Efraim dinan kanan Manase. Ket kananyatew a mangaamot, in-inged na hila, a wana, “Hilay Israelita, gawien lay ngangalan yo ha panginged la. Wanae ye habiyen la, ‘Inged naka dayin Apo Namalyadi a omen kanlan Efraim boy Manase.’ ” Wanabay ye hangkan no taket ta nuna yay Efraim kanan Manase ha panginged nan Israel. ");
INSERT INTO abp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Pangayadi, hinabi nan Israel, “Jose, madanon akoynan matey, noba adi ka angkahindak. Lamoan na kan Apo Namalyadi boy iudong na kawo lano ha lugal lan nangaunan tutoa yo. ");
INSERT INTO abp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ket hika ye manawid nin Shekem, aliwan hilay kakatongno mo. Yain a lugal, ket napagkonin ko ibat kanlan Amoreo makauli ha kampilan boy yawo ko.” ");
INSERT INTO abp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Pangayadi, impaingat na hilan Jacob ye aanak na, ket hinabi na, a wana, “Humaley kawo kangko, ta habiyen ko kanyo ye malyadi lano kanyo. ");
INSERT INTO abp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Aanak ko, humaley kawo kangko boy leng-en yoko a bapa yo. ");
INSERT INTO abp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Hika Reuben a punganay ko, ket nianak ha panaon nin kakakhawan ko. Maiigit kan angkabalitaan boy makapalyadiyan dinan kanlan kakatongno mo. ");
INSERT INTO abp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Noba ba-mo kan lanab, ulita agmo nabenben ye maloke a kalabayan nin laman mo, ta nilalay mo yay ahawa kon ipoh. Ket uli yain a dinyag mo, agkaynan maiigit kanlan kanayon. ");
INSERT INTO abp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Hikawo Simeon boy Levi a mikatongnon ampaytagem, anggawien yoy almah yo ha pamaidap kanlan kanayon. ");
INSERT INTO abp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ahe ako makilakew o makew ha paytitipon yo, ulita no mapoot kawo, tampol kawon mamatey, boy ampilayen yo hilay aayop no labay yo. ");
INSERT INTO abp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maihumpa kawo, ulita matubag kawo boy mahama. Payngihyayen katawo boy paytayaken ha Israel. ");
INSERT INTO abp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Hika met Juda, ket galangen boy dangalen la kan kakatongno mo, ta hamboten mo hila lanoy kakaaway mo. ");
INSERT INTO abp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ba-mo kan anak nin liyon pangayadi nan mamatey nin ayop, ket ampag-udong a mida ha yukib na. Ket homain ayaman a magngaya a makibalabala kana. ");
INSERT INTO abp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Pahulong kan mamoon. Mangibat ya lano ha lalahi mo ye mag-ilyadin poon. Kaya-bay mamayad hila nin bowih ye nanahyon boy pahakop hila kamo. ");
INSERT INTO abp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mahbol lanoy pupol ha lugal mo. Kaya-bay agya ih-el yay ahno ha haley nin pinakamanged a tanaman a kawat obah, ket ahe na mauboh uli ha kalabong na. Ket agya pag-ilbah ye habaw ubah, ket ahe ya mauboh. ");
INSERT INTO abp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Uli ha paminom mo nin alak ubah, tumibya ye mata mo, ket uli ha paminom mo nin gatah, ampumoti ye ngingipen mo. ");
INSERT INTO abp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ket hika Zebulun, ihtew ka kumonin ha gilid dagat. Hiyay lugal mo ket mag-ilyadin tanghadan nin daong. Hiyay lugal mo, miabot ya anggan ha Sidon. ");
INSERT INTO abp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Hika Isacar, ba-mo kan maghay makhaw a ahno, a ampagpainawa ha kulongan nin tutupa. ");
INSERT INTO abp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Anteehen moy paipoh boy mag-obda nin mabyat, dapot tana manged ye kunaan mo. ");
INSERT INTO abp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Hika Dan, manuhga ka lano kanlan tatao mo, bilang magha kanlan lalahi nin Israel. ");
INSERT INTO abp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ba-mo kan bikat a madita a anti ha gilid nin dān a ampanuka nin bibitih nin kakabayo a anhumapid. Kaya-bay angkaampag hilay nakahakay.” ");
INSERT INTO abp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Pangayadi hinabi nan Jacob, “Apo Dioh, an-agaden koynay pangiligtah mo.” ");
INSERT INTO abp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ket nagpahulong ya ha paghabi na, “Hika Gad ket dawohongen laka lanon tutulihan, noba dawohongen mo hila boy kamaten mo hila met. ");
INSERT INTO abp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Hika Asher, luhbo ya lanoy pamangan mo. Hiyay pupol mo ket katanggap-tanggap a kanen nin poon. ");
INSERT INTO abp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Hika Naftali, ba-mo kan maghay naibohan a oyha a ampanganak nin manganged a ooybon. ");
INSERT INTO abp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Hika met Jose, ket malabong hila lanoy lalahi mo a omen ha poon kawat ubah a naitanem ha haley nin hubol, ket hiyay kawat na, kumayapkap ya ha babe alad. ");
INSERT INTO abp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dawohongen laka lanon kakaaway mo a mahipat a mamana, ket uli ha poot la, panaen laka. ");
INSERT INTO abp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Noba pamanapana mo met kanla boy pahulong a makhaw ye takyay mo makauli ha haglap nan Makapalyadiyan a Dioh nan Jacob, a māgpahtol boy kalahag nin Israel. ");
INSERT INTO abp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Hiyabay ye Makapalyadiyan a Apo Namalyadi lan nangaunan tutoa mo a ampanaglap boy ampanginged kamo. Inged na kan Apo Namalyadi nin udan boy lanom ibat ha huhubol. Biyan na kan malabong a aanak boy aayop. ");
INSERT INTO abp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Hiyay panginged nan bapa mo, ket igit yan manged dinan ha kangedan a ampangibat ha alan a nagmamapantay. Matanggap mo hila dayi hilatin kangedan, Jose, hika a umiigit kanlan kakatongno mo. ");
INSERT INTO abp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Hika Benjamin ket ba-mo kan ahontawon a ampamatey, ampangamoyok nin ayop ha mahanib, ket ha madeglem, andakayen nay nahamham na.” ");
INSERT INTO abp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hilayain ye 12 aanak nan Israel a nangibatan nin lalahi lan Israelita. Ket yain ye kapohpohan a panginged nan Jacob a kaeteban nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Pangayadi, binilinan na hilan Jacob ye aanak na, hinabi na kanla, “Haanin, madanon ko hilaynan mapagkalamo ye papaltido ko a nangamatey ana. Ihtew yo kon ilbeng ha nakailbengan lan nangaunan tutoa ko, ha yukib a anti ha bangkag nan Efron a Heteo. ");
INSERT INTO abp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Yain a bangkag, ket anti ya ha Macpela, ha Mamre, ha lugal a Canaan. Hinaliw na yan aking kon Abraham yatew a bangkag kanan Efron ta-omen na yan diyagen a pangilbengan. ");
INSERT INTO abp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ket ihtew ya nailbeng agya yay baing kon Sara a ahawa na. Ihtew la hila met in-ilbeng ye tutoa kon Isaac boy Rebeka boy ihtew koya met in-ilbeng ye Lea. ");
INSERT INTO abp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Hiyay bangkag boy yukib, ket hinaliw kanlan Heteo.” ");
INSERT INTO abp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pangayadi nan maghabi ye Jacob kanlan aanak na, nida yayna man, ket naboytoan yaynan angeh. Ket napagkalamo na hilaynay papaltido na a nangamatey ana. ");
INSERT INTO abp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Hiyay Jose, antumangih yan nanakeh nin bangkay nan bapa na boy inumaan naya. ");
INSERT INTO abp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Pangayadi, imbilin na kanlan māghilbi na a mānambal a balhamowen lay bangkay nan bapa na. Kaya-bay binalhamo laya. ");
INSERT INTO abp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ket inumabot ya ha 40 a mangaamot ye pamalhamo la ha bangkay nan Jacob, ta wanabay kabuyot ye pamalhamo lan Egipsio. Ket 70 a mangaamot la yan impaglele nin Egipsio. ");
INSERT INTO abp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Pangayadi nin paglele la, hinabi nan Jose kanlan oopihyal nan Faraon, “No malyadi dayi, ipakihabi yo man kanan Faraon ye wanae, ");
INSERT INTO abp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Pinahumpa na kon bapa ko bayo yan natey a ihtew koya ilbeng ha pangilbengan a intaladan na ha Canaan. Kaya-bay ampakikwaen ko a palubohan mo kon ilakew ko yan ilbeng ihtew ye bangkay nan bapa ko. Pangayadi, mag-udong akon tampol,’ wanyo.” ");
INSERT INTO abp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nakibat yay Faraon, “Hali, kokayna, ket ilbeng mo yaynay bapa mo a omen ha impahumpa na kamo.” ");
INSERT INTO abp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kaya-bay inumalih yaynay Jose ta-omen naya ilbeng ye bapa na. Nakilakew hila met ha pangilbengan ye kaganaan a oopihyal nan Faraon, hilay māmaala ha palahyo boy hilay mangatoaynan mānungkolan ibat ha kaganaan a lugal nin Egipto. ");
INSERT INTO abp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nakilakew hila met ye papamilya nan Jose, hilay kakatongno na boy kabaey nan bapa na. Hilay nabantak bengat ha Goshen ket hilay mangakandin aanak, hilay kawan nin tutupa, kakambing boy babaka. ");
INSERT INTO abp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Main met nakilakew kanla a ampangabayo boy main met nakahakay ha kaliha. Malabong hilan tubat. ");
INSERT INTO abp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pamiabot la ha panggiekan ha Atad, ha lipay nin kabatowan Jordan, tinumgen hila. Nangandang hila ihtew boy tubat ye paglele la ha pangamatey nan Jacob. Ket pitoy mangaamot yan naglele ye Jose ihtew. ");
INSERT INTO abp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ha nakit lan Cananeo a angkumonin ihtew ye paglele la ha panggiekan ha Atad, hinabi la, “Tubat ye paglele lan Egipsio!” Kaya-bay hinabtan la yan Abel Mizraim yatew a lugal ha lipay ha kabatowan Jordan. ");
INSERT INTO abp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tinupad lan aanak nan Jacob ye imbilin na kanla. ");
INSERT INTO abp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Inlakew laya ha Canaan ye bangkay na, ket ihtew la yan in-ilbeng ha yukib a anti ha bangkag ha Macpela, ha haley nin Mamre. Yatin bangkag, ket hinaliw na yan Abraham hatew kanan Efron a Heteo. ");
INSERT INTO abp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pangayadi nin pangilbeng kanan bapa na, nag-udong yaynay Jose ha Egipto, kalamo na hilay kakatongno na boy hilay kaganaan a nakipangilbeng kanan bapa na. ");
INSERT INTO abp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Haanin, ta natey yaynay bapa la, hinabi lan kakatongno nan Jose, “Maka main ya po hakit nakem kantawo ye Jose, ket baeen na kitawo ha maloke a dinyag tawo kana.” ");
INSERT INTO abp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kaya-bay nangitubol hilan mangihabi kanan Jose nin wanae, “Bayo ya matey ye bapa tawo, main yan imbilin kammi, a wana, ");
INSERT INTO abp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Habiyen yo kanan Jose, “An-ipakihabi kon patawaden mo hilaynay kakatongno mo ha dinyag la a maloke kamo,” wanan bapa tawo. Ket haanin, an-ipakiiingalo mi kamo a patawaden mo kayina dayi a iipoh nan Apo Namalyadi nan bapa mo.’ ” Pamakange nan Jose ye hinabi la, nipatangih ya. ");
INSERT INTO abp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ket hilay kakatongno nan Jose, nakew hilan kaganaan kana, ket nilumukob hila ha adapan na, a wanla, “Iipoh mo kayina.” ");
INSERT INTO abp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Noba hinabi nan Jose kanla, “Adi kawo angkalimo. Aliwa kon Apo Namalyadi a malyadin manuhga boy mamaduha kanyo. ");
INSERT INTO abp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Awo, peteg a nangihip kawon maloke laban kangko, noba pinalyadi na yan Apo Namalyadi a manged ye kinalakwan na a omen ha angkalyadi haanin, ta labay na hilan iligtah ye malabong a tatao ha kamateyan uli ha bitil. ");
INSERT INTO abp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kaya-bay adi kawo angkalimo. Hikoynay mangalingay kanyo dayon aanak yo.” Uli ha manganged a hinabi nan Jose kanlan kakatongno na, ket kinumhaw ye nakem lan mikakatongno. ");
INSERT INTO abp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nikakaanti yay Jose ha Egipto kalamo na hilay mitapapamilya nan bapa na. Hiyay bi-ay nan Jose, ket naabot na po ye 110 a taon. ");
INSERT INTO abp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ket nakit na hila po ye aapo na ha tuol kanan Efraim a anak na boy naagad na hila po ye aapo na kanan Makir a anak nan Manase. Imbilang na hilan hadili nan aanak ye aanak nan Makir. ");
INSERT INTO abp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Haanin, hinabi nan Jose kanlan kakatongno na, “Madanon akoynan matey, noba adi kawo angkahindak. Agna na kawo paolayan Apo Namalyadi boy ilakew na kawo ha lugal a impangako na kanlan Abraham, Isaac boy Jacob.” ");
INSERT INTO abp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pangayadi, hinabi na kanlan Israelita, “Ihumpa yo kangko a lano ha ilwah na kawon Apo Namalyadi ihtin lugal, kadten yoy bobot-o ko.” ");
INSERT INTO abp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hiyay Jose ket 110 a taon nayna ha natey ya ha Egipto. Binalhamo lay bangkay na boy ingkabaong laya.");
INSERT INTO abp_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Hatew ha panaon a hilay mānuhga ye ampamoon ha Israel, nagkabitil ihtew. Kaya-bay hiyay Elimelec a taga Betlehem ha plobinhiyan Juda, ket nakew ya ha Moab dayon ahawa na boy hilay luway aanak la ta-omen hila kumonin ihtew. Hiyay ngalan nin ahawa na ket Naomi. Ket hilay luway aanak la, hilan Mahlon boy Kilion. Lalahi na hilan Efrata a taga banwan Betlehem. ");
INSERT INTO abp_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ket legan angkumonin hila ha Moab, natey yay Elimelec. Kaya-bay hiyaynay Naomi boy luway aanak na ye napatla. ");
INSERT INTO abp_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ket hilay luway aanak na, nangahawa hilan babayin taga Moab. Hiyay ngalan nin ahawa nin magha ket Orpa. Hiyay magha met ket Ruth. Noba pangalabah nin mapo a taon nin pangumonin la ihtew, ");
INSERT INTO abp_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","natey yay Mahlon boy Kilion. Kaya-bay homain yaynan anak boy ahawa ye Naomi. ");
INSERT INTO abp_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Legan anti yay Naomi ha Moab, nabalitaan na a in-inged na hilan Apo Dioh ye tatao na ha Israel makauli ha mahbol a pupol la. Kaya-bay nag-aligwat hilan Naomi boy mamanuyang na ta-omen hilayna umalih ha Moab. ");
INSERT INTO abp_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ha anti hilayna ha dān palakew ha plobinhiyan Juda, ");
INSERT INTO abp_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","hinabi nan Naomi kanlan luwan mamanuyang na, “Mag-udong kawoyna tana kanlan iindo yo. No way-omen kanged ye dinyag yo kanlan aahawa yo, wanabay met dayi kanged ye diyagen nan Apo Dioh kanyo. ");
INSERT INTO abp_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ipaluboh na dayin Apo Dioh a makaahawa kawon uman ta-omen kawo magkamain nin manged a kahahaad nin pagbi-ay ha bayo yon papamilya.” Pangayadi, inumaan na hilan Naomi ye mamanuyang na bilang patanid na kanla. Ket nakatangih hila. ");
INSERT INTO abp_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Hinabi la kana, “Makilakew kayi kammo ha pag-udong mo kanlan lalahi mo.” ");
INSERT INTO abp_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Noba hinabi nan Naomi, “Aanak ko, adi kawoynan makilakew kangko. Mag-udong kawoyna tana kanlan tutoa yo. Ahe akoynan magkaanak nin mapag-ahawa yo. ");
INSERT INTO abp_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Aanak ko, muli kawoyna tana. Ahe koyna mababa ye makiahawan uman, ta matoa akoyna. Ket agya po makaahawa ko boy manganak nin lalaki haanin a madeglem, ");
INSERT INTO abp_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","maagad yo hila po nayi? Mateeh yo po nayi ye ahe makiahawan uman nin kanayon uli ha pangagad yo kanla? Ahe ana malyadi yain. Aanak ko, malelele ako kanyo ta ampaduhaan na kon Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Pangahabi na yatew, tinumangih hilayna man nin makhaw, ket inumaan na yan Orpa ye ampo na bilang patanid na kana. Noba hiyay Ruth, tinakeh na yay ampo na. ");
INSERT INTO abp_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Hinabi nan Naomi kanan Ruth, “Bilewen mo, muli yaynay Orpa kanlan lalahi na boy kanlan andiohen na. Kaya-bay makilakew kayna kana.” ");
INSERT INTO abp_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Noba hinabi nan Ruth, “Adi mo koyna dayin piliten a lakwanan kata. Paolayan mo koyna dayin makilakew kammo. Agya way-ihtew man a lugal ye lakwen mo ket makilakew ako. No way-ihtew ka kumonin, ihtew ako met kumonin. Ket hilay papaltido mo, bilang koyna met paltido. Ket hiyay Apo mon Namalyadi, Apo Namalyadi koyna met. ");
INSERT INTO abp_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","No way-ihtew ka man matey, ihtew akoyna met ilbeng. Paduhaan nako dayin mabyat Apo Dioh no makihyay ako kammo, powidan bengat no kamateyan yaynay mangihyay kanta.” ");
INSERT INTO abp_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ha naimatonan nan Naomi a mahehpet yan makilakew kana ye Ruth, ahe yayna tinumnoy. ");
INSERT INTO abp_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ket impahulong lay pangumodang la anggan ha nilumateng hila ha Betlehem. Nahabekan hilay tatao ihtew ha panlumateng nan Naomi. “Hiyayna lagi ye Naomi?” wanlan babayi. ");
INSERT INTO abp_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Haanin, hinabi nan Naomi kanla, “Adi yo koyna ingaten nin Naomi, no aliwan Mara tana, ulita dinyag na kon malele Apo Namalyadi a Makapalyadiyan. ");
INSERT INTO abp_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Hatew inumalih ako ihti a mainan. Haanin, hiyay Apo Dioh, in-udong nakoyna ihti a homainan. Kaya-bay adi yo koynan ingaten nin Naomi, ulita ampaidapan nakon Apo Namalyadi a Makapalyadiyan.” ");
INSERT INTO abp_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Wanabay ye nalyadi kanan Naomi. Kaya-bay nag-udong ya ibat ha Moab a kalamo na yay Ruth a Moabita a manuyang na. Ha nilumateng hila ha Betlehem ket kapelhan hilan ampamupol nin sebada ye tatao ihtew. ");
INSERT INTO abp_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Hiyay Naomi ket main yan paltido kanan Elimelec a imbawo na. Hiyay ngalan na ket Boaz. Mabatnang ya boy andangalen ya nin tatao. ");
INSERT INTO abp_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ha maghay mangaamot, hinabi nan Ruth a Moabita kanan Naomi, “Malyadi lagin makew akon makipamulot nin inuway a nangatugnoh lan ampamalot? Ihtew ako mamulot ha dapit gulotan nin ayaman a mamaluboh kangkon mamulot nin inuway a nangatugnoh.” “Awo anak ko,” wana met Naomi. ");
INSERT INTO abp_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kaya-bay nakew yaynay Ruth ihtew ha bangkag, ket namulot yaynan inuway a nangatugnoh lan ampamalot. Hiyay bangkag a namulotan na, ket bangkag na met manaytin Boaz a paltido nan Elimelec. Hiyay Boaz ket mabatnang yan tao boy andangalen ya nin tatao. ");
INSERT INTO abp_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Haanin, nilumateng yaynay Boaz ibat ha Betlehem. Hinabi na kanlan ampamalot, “Mikakaanti ya dayi kanyoy Apo Dioh.” “Inged na kawo met dayin Apo Dioh”, wanla met ampamalot. ");
INSERT INTO abp_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Pangayadi, tinepet nan Boaz kanan ampamaala nin pamupol, “Ayay nagbalatang yain?” ");
INSERT INTO abp_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Hinabi nan māmaala, “Magha yan Moabita a nakilakew kanan Naomi ha pag-udong na ihti ibat ha Moab. ");
INSERT INTO abp_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Hinabi na kangko, ‘Malyadi lawen makipamulot akon inuway a nangatugnoh lan ampamalot?’ Nangon ya po ha mahanib a ampamulot nin inuway. Ket haanin yan bengat tinumgen ta-omen ya magpainawa.” ");
INSERT INTO abp_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Haanin, hinaleyan na yan Boaz ye Ruth boy hinabi na, “Leng-en moko, inang. Adi kayna makipamulot ha kanayon a bangkag boy adi kayna umalih ihti. Ihti kaynan bengat mamulot lamo mo hilay ipoh kon babayi. ");
INSERT INTO abp_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Bilewen mo no way-ihtew hilan ampamalot ye tatao ko ket humbongen mo hilay iipoh kon babayi. Hinabi koyna kanlan tatao ko a adi laka ampakibalabalaan. Ket no angkaplangan ka, malyadi kan mangwa nin inumen mo ha hahalaw a pinno lan lanom nin tatao ko.” ");
INSERT INTO abp_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Nilumukob yay Ruth ha adapan nan Boaz boy hinabi na, “Kanged mo man kangko agya dayohan akon bengat!” ");
INSERT INTO abp_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Nakibat yay Boaz, “Main nangihabi kangko nin tungkol ha kaganaan a manganged a dinyag mo kanan ampo mon babayi paibat po ha natey yaynay ahawa mo. Nilakwanan mo hila kano ye tutoa mo boy hiyay lugal a nangianakan kammo. Ket nakew kan kinumonin ha lugal lan tataon ahe mo katatanda. ");
INSERT INTO abp_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ingalowan naka dayin Apo Namalyadi nin omen ha pangingalo mo kanan Naomi. Ta hiyay Apo Namalyadi a Namalyadi nin Israel ye nagpahalokoban mo!” ");
INSERT INTO abp_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Hinabi nan Ruth, “Pahulong ako dayin ampakaaliket kamo, ama. Pinakhaw moy nakem ko ha maanoh a paghabi mo kangko, agya po maaypa ako kanlan iipoh mon babayi.” ");
INSERT INTO abp_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ha odah ana nin pangan, hinabi nan Boaz kanan Ruth, “Ka di! Mangwa kan tinapay ket idede mo ha maahem a alak.” Kaya-bay nakidongo yay Ruth kanlan māmalot ket binyanan na yan Boaz nin dinedemen a sebada. Nangan yay Ruth angga ha nabhoy ya. Main ya po tela. ");
INSERT INTO abp_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ha nideng yay Ruth, ta makew yayna man mamulot nin inuway, imbilin nan Boaz kanlan tatao na, “Paolayan yo yan mamulot ha haley nin pinteh boy adi yoya bawalan. ");
INSERT INTO abp_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mangoyoh kawo ingat nin inuway ha pinteh ket ibol-ihan yo ta-omen yan main puloten boy adi yoya andelawen.” ");
INSERT INTO abp_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Namulot yay Ruth nin inuway anggan madeglem. Ha nagiek na yaynay pinolot nan tinipon, ket manga kagitna belyag. ");
INSERT INTO abp_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kinaget nan in-uli ha banwa ket impakit na kanan ampo na. In-ibyay na met kana ye tela na a pamangan a in-ibyay nan Boaz kana. ");
INSERT INTO abp_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tinepet na yan Naomi, “Way-ihtew ka namulot nin inuway nangon? Ayay nagbangkag nin namulotan mo? Inged naya dayin Apo Dioh ye taon nangingalo kamo.” Hinabi nan Ruth kanan Naomi, “Hiyay namulotan kon bangkag ket konin nan nagngalan Boaz.” ");
INSERT INTO abp_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Hinabi nan Naomi kana, “Inged naya dayin Apo Dioh ye Boaz. An-ipakit na po Apo Dioh ye kangedan na kanlan tataon angkabi-ay po boy kanlan natey ana.” Hinabi na po, “Hiyay Boaz ket magha yan paltido tawo a main katungkolan a mangalingay kanta.” ");
INSERT INTO abp_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Pangayadi, hinabi nan Ruth a Moabita kanan Naomi, “Hinabi na po kangkon Boaz a magpahulong akon mamulot kalamo lan tatao na anggan ha mayadi ye pamalot ha bangkag na.” ");
INSERT INTO abp_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Hinabi na met Naomi kanan Ruth, “Awo anak ko, mamanged po a ihtew kaynan makilakew kanlan iipoh na a babayi, ta maka mipaloke ka no makew ka ha kanayon a bangkag.” ");
INSERT INTO abp_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kaya-bay nakilakew yay Ruth kanlan babayin iipoh nan Boaz ha pamulot nin nangatugnoh a inuway anggan ha nayadi ye pamupol nin sebada boy tidigo. Ket pahulong yan kinumonin kanan ampo na a Naomi. ");
INSERT INTO abp_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ha maghay mangaamot, hinabi nan Naomi kanan Ruth, “Anak ko, katapulan a ipilian kata nin mangahawa kammo a mangalingay kammo. ");
INSERT INTO abp_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Hiyay Boaz a amo lan babayin nakalamo mon nag-obda ha bangkag na ket paltido ta ya. Leng-en mo kon manged. Haanin a madeglem ket magpagiek ya nin sebada. ");
INSERT INTO abp_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Kaya-bay malyo ka boy magpabango ket ihoot moy pinakamatampa a bado mo. Pangayadi, makew ka ha panggiekan na, noba adi ka ampakit kanan Boaz anggan ha mayadi yan mangan boy minom. ");
INSERT INTO abp_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Lano mida yayna, pakaedepan mo ya no way-ihtew yan mida. Ket no nakatuloy yayna, lakwen mo ya ket ilukay moy oweh na ha dapit bitih na, haka kaynan mida ha aphayan na bilang pangipakit a labay moy pakalingay kana. Ket habiyen na kammo no hinyay diyagen mo.” ");
INSERT INTO abp_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","“Diyagen ko ye kaganaan a hinabi mo kangko,” wanan Ruth. ");
INSERT INTO abp_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kaya-bay nakew yay Ruth ha panggiekan ket dinyag nay kaganaan a imbilin nan ampo na. ");
INSERT INTO abp_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Pangayadi nan mangan boy minom yay Boaz, ket manged ye tanam na. Haanin, nakew yaynan nida ha talig nin nabonton a sebada ta-omen yayna matuloy. Namapakana yan hinumaley ye Ruth ket inlukay nay oweh nan Boaz ha dapit bitih na ket nida yayna ha aphayan na. ");
INSERT INTO abp_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ha bunak anan madeglem, nakaimukat yay Boaz. Binumaling ya ket pamakakit na a main babayin ampida ha aphayan na, naigat ya. ");
INSERT INTO abp_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Aya ka?” wanan Boaz. “Hiko yay Ruth a ipoh mo,” wanan Ruth. “Magha ka kanlan mahaley a paltido ko a main katungkolan a mangalingay kangko. Pakepkepan mo ko bilang pagkakitan a ikahal mo ko boy kalingayen.” ");
INSERT INTO abp_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Hinabi nan Boaz, “Inged naka dayin Apo Dioh. Yatin kangedan a dinyag mo haanin ket mamanged ya dinan ha dinyag mo hatew kanan ampo mo, ulita ahe ka nanapol nin bayon tao, mabatnang man o maidap. ");
INSERT INTO abp_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ket haanin, adi ka angkahindak, inang. Diyagen koy kaganaan a an-awoken mo. Tanda lan kaganaan a kabanwa ko a manged kan babayi. ");
INSERT INTO abp_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Peteg pa a magha kon mahaley a paltido mo a main katungkolan a mangalingay kammo, noba main po maaahaley a paltido mo dinan ko. ");
INSERT INTO abp_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ihti kayna matoloy haanin a madeglem ket lano mahanib, no labay na yan diyagen ye katungkolan na kammo bilang māngalingay mo, manged ya. Noba no ahe na labay, hikoyna. An-ipangako ko ha ngalan nan Apo Namalyadi a angkabi-ay a hikoy mangalingay kammo. Hali awod, ihti kaynan mikahumda.” ");
INSERT INTO abp_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kaya-bay natuloy yay Ruth ha aphayan nan Boaz anggan mahanib. Noba bayo hilan nimata ye kanayon, nuna yaynan nimata ye Ruth ta-omen laya ahe mabalayan nin tatao. Ta hinabi nan Boaz, “Ahe ko labay a main makatanda a main babayin nakew ihti ha panggiekan.” ");
INSERT INTO abp_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Hinabi nan Boaz kanan Ruth, “Ilakew mo di ye kepkep mo boy ibiklal mo.” Imbiklal nan Ruth ye kepkep na ket binohbohan nan Boaz nin sebada angga ha mababa nan kadten. Ket impalonto na ha ō nan Ruth. Ket nuli yayna met ha banwa ye Boaz. ");
INSERT INTO abp_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Panlumateng nan Ruth ha angkunaan la, tinepet na yan ampo na, “Way-omen yay nilakew mo anak ko?” Ket hinabi nan Ruth ye kaganaan a dinyag nan Boaz. ");
INSERT INTO abp_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Hinabi na po Ruth, “Binyan nako nin sebada angga ha mababa kon kadten, ta hinabi na, ‘Agko labay a muli kan homain kaget kanan ampo mo.’ ” ");
INSERT INTO abp_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Hinabi nan Naomi, “Mangagad ka tana, anak ko, anggan ha matandaan moy kalalakwan nin yati. Ahe yan makatana ye Boaz haanin a mangaamot anggan ha maipatonong na ye awok mo kana.” ");
INSERT INTO abp_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Nakew yay Boaz ha dapit ilwangan nin banwa, ket nikno ya ihtew. Ha anhumapid yaynay maaahaley a paltido la a andektan nan Boaz, hinabi na kana, “Gayyem! Ka di po boy mikno ka.” Ket hinumaley yan peteg boy nikno ya. ");
INSERT INTO abp_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Hinagyat na hilan Boaz ye mapo a māmaala nin banwa ket hinabi na kanla, “Mikno kawo di.” Ha nakaikno hilayna, ");
INSERT INTO abp_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","hinabi nan Boaz kanan paltido na, “Nag-udong yaynay Naomi ibat ha Moab ket labay na yan ilako ye bangkag nan Elimelec a paltido ta. ");
INSERT INTO abp_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ket ha ihip ko katapulan mon matandaan yati. No labay mo, haliwen mo ha adapan lan māmapteg a māmaala nin banwa. Noba no ahe mo labay, habiyen mon bengat kangko ta-omen ko matandaan. Ta hiyay kaptegan ket hikay unan main katulidan a manaliw, ikalwa kon bengat.” “Awo, haliwen ko,” wanan paltido na. ");
INSERT INTO abp_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Noba hinabi nan Boaz, “No haliwen mo kanan Naomi ye bangkag, ket katapulan a ikahal mo yay Ruth a Moabitan bawo. Ha wanabay, no magkaanak kawoyna, hiyay bangkag ket mikakaantin pagkonin nin pamilya nan paltido ta a natey ana.” ");
INSERT INTO abp_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Pamakange nan paltido na, hinabi na, “No wanabay awod, ahe koyna haliwen ye bangkag. Ta no magkamain kayin anak a laki, ket kumandi ye bangkag a tawiden lan aanak ko. Hikaynan bengat ye manaliw nin bangkag. Agkoyna haliwen.” ");
INSERT INTO abp_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Kananyatew a panaon ha Israel, bilang pamapteg nin panaliw o panagili nin nagkonin nin luta, hiyay alan a nagkonin ket an-alihen nay ihtiping na ket ibyay na kanan manaliw nin luta. Wanabay ye andiyagen lan Israelita bilang pamapteg ha napaykahundoan la. ");
INSERT INTO abp_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kaya-bay ha pangahabi nan maaahaley a paltido la a, “Hikaynan bengat Boaz ye manaliw nin bangkag,” ket inalih nay ihtiping na ket in-ibyay na kanan Boaz. ");
INSERT INTO abp_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Hinabi nan Boaz kanlan māmaala nin banwa boy kanlan kaganaan a anti ihtew, “Haanin a mangaamot, hikawo ye makapipapteg a hinaliw koyna kanan Naomi ye kaganaan a bangkag nan Elimelec a tawid lan Kilion boy Mahlon. ");
INSERT INTO abp_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Boy magha po, ikahal ko yay Ruth a Moabita a imbawo nan Mahlon ta-omen ya mikakaantin pagkonin nin pamilya nin natey ye bangkag. Ha wanabay, ahe laya maliwaan nin papaltido na boy kabanwa na ye ngalan na. Haanin a mangaamot, hikawo ye makapipapteg kananyati.” ");
INSERT INTO abp_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Hinabi la met māmaala nin banwa boy hilay kanayon a anti ihtew, “Awo! Hikayi ye māmapteg. Diyagen na dayin Apo Dioh kanan mapag-ahawa mo ye omen ha dinyag na kanlan Raquel boy Lea a nanganak nin malabong a nag-ilyadin lalahi nin Israel. Hika dayi ye makapalyadiyan ha Efrata boy angkabalitaan a tao ha Betlehem. ");
INSERT INTO abp_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Makauli kananyatin babayi, biyan naka dayin Apo Dioh nin malabong a aanak yo. Ket hiyay pamilya mo, omen hila dayi kalabong ha pamilya nan Perez a anak lan Juda boy Tamar.” ");
INSERT INTO abp_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kaya-bay hiyay Boaz, ingkahal na yay Ruth, ket in-uli naya ha baey na. Nilalay naya, ket makauli ha kapalyadiyan nan Apo Dioh, binumuktot ya. Ket nanganak yan laki. ");
INSERT INTO abp_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Hinabi lan babayi kanan Naomi, “Galangen yay Apo Dioh! Ta haanin a mangaamot ket binyan na ka nin apo a mangalingay kammo. Mag-ilyadi ya dayin angkabalitaan ha Israel! ");
INSERT INTO abp_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Hiyabay ye mamakhaw boy mangalingay kammo, lano matoa kayna. Minged ka ta hiyay nag-anak kana ket hiyay manuyang mo a ampangado kammo. Ket igit yan mamanged dinan ha piton aanak a laki.” ");
INSERT INTO abp_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Haanin, kingwa na yan Naomi ye ongi ket binibi naya. Ket hiyaynay ampangalingay kanan ongi. ");
INSERT INTO abp_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Hinabi lan babayin kakaaluba nan Naomi, “Main yaynan apo a laki ye Naomi!” Ket pinangalanan la yan Obed. Hiyay Obed ye bapa nan Jesse a bapa nan David. ");
INSERT INTO abp_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Hilati ye lalahi nan Perez. Hiyay Perez ye bapa nan Hezron. ");
INSERT INTO abp_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hiyay Hezron ye bapa nan Ram, hiyay Ram ye bapa nan Aminadab. ");
INSERT INTO abp_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Hiyay Aminadab ye bapa nan Nashon. Hiyay Nashon ye bapa nan Salmon. ");
INSERT INTO abp_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Hiyay Salmon ye bapa nan Boaz. Hiyay Boaz ye bapa nan Obed. ");
INSERT INTO abp_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Hiyay Obed ye bapa nan Jesse. Hiyay Jesse ye bapa nan David.");
INSERT INTO abp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yati ye lihtaan nin nangaunan tutoa nan Apo Jesu Cristo a lahi nan David a lahi nan Abraham. ");
INSERT INTO abp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Hiyay Abraham ye bapa nan Isaac. Hiyay Isaac ye bapa nan Jacob. Hiyay Jacob ye bapa lan Juda boy kakatongno na. ");
INSERT INTO abp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Hiyay Juda ye bapa lan Perez boy Zera a aanak na kanan Tamar. Hiyay Perez ye bapa nan Esrom. Hiyay Esrom ye bapa nan Aram. ");
INSERT INTO abp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Hiyay Aram ye bapa nan Aminadab. Hiyay Aminadab ye bapa nan Naason. Hiyay Naason ye bapa nan Salmon. ");
INSERT INTO abp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Hiyay Salmon ye bapa nan Boaz a anak na kanan Rahab. Hiyay Boaz ye bapa nan Obed a anak na kanan Ruth. Hiyay Obed ye bapa nan Jesse. ");
INSERT INTO abp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Hiyay Jesse ye bapa nan Poon David. Hiyay Poon David ye bapa nan Solomon a anak na kanan bawo nan Urias. ");
INSERT INTO abp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hiyay Solomon ye bapa nan Rehoboam. Hiyay Rehoboam ye bapa nan Abias. Hiyay Abias ye bapa nan Asa. ");
INSERT INTO abp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Hiyay Asa ye bapa nan Jehoshafat. Hiyay Jehoshafat ye bapa nan Joram. Hiyay Joram ye bapa nan Uzias. ");
INSERT INTO abp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Hiyay Uzias ye bapa nan Jotam. Hiyay Jotam ye bapa nan Acaz. Hiyay Acaz ye bapa nan Ezekias. ");
INSERT INTO abp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiyay Ezekias ye bapa nan Manase. Hiyay Manase ye bapa nan Amos. Hiyay Amos ye bapa nan Josias. ");
INSERT INTO abp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hiyay Josias ye bapa lan Jeconias boy kakatongno na. Kananyatew a panaon, hilay Israelita, kinapyol hilan taga Babilonia. ");
INSERT INTO abp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ket legan kapyol hilaynan taga Babilonia ye Israelita, hiyay Jeconias ket nagkaanak ya. Hiyay Jeconias ye bapa nan Salatiel. Hiyay Salatiel ye bapa nan Zerubabel. ");
INSERT INTO abp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Hiyay Zerubabel ye bapa nan Abiud. Hiyay Abiud ye bapa nan Eliaquim. Hiyay Eliaquim ye bapa nan Azor. ");
INSERT INTO abp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hiyay Azor ye bapa nan Zadoc. Hiyay Zadoc ye bapa nan Akim. Hiyay Akim ye bapa nan Eliud. ");
INSERT INTO abp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Hiyay Eliud ye bapa nan Eleazar. Hiyay Eleazar ye bapa nan Matan. Hiyay Matan ye bapa nan Jacob. ");
INSERT INTO abp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Hiyay Jacob ye bapa nan Jose a ahawa nan Maria. Hiyay Maria ye indo nan Jesus a anhabtan Cristo. ");
INSERT INTO abp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kaya-bay paibat kanan Abraham angga kanan Poon David, main labin-apat a lahi. Ket paibat met kanan Poon David angga ha nakapyol hilan taga Babilonia, labin-apat met a lahi. Ket paibat ha nakapyol hilan taga Babilonia anggan nianak yay Apo Jesus a anhabtan Cristo, main met labin-apat a lahi. ");
INSERT INTO abp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wanae ye nangalyadi ha in-anak yay Apo Jesu Cristo. Hiyay Maria a indo na, ket nakataning yaynan ikahal kanan Jose hatew. Noba bayo hila po naylalay, natandaan nan Maria a mabuktot yayna makauli ha kapalyadiyan nin Ihpiditon Dioh. ");
INSERT INTO abp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hiyay Jose a mapag-ahawa nan Maria, ket magha yan matoynong a tao. Kaya-bay inihip na a ihyay na yay Maria a homain kanayon a nagtanda ta-omen ahe ya mipading-ey. ");
INSERT INTO abp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Noba legan an-ihipen na yatew Jose, napakit ya kana ye anghil nin Dioh makauli ha leplep. Ket hinabi na kana, “Jose a lahi nan David, adi ka ampagluwaluwa a mangikahal kanan Maria, ta binumuktot ya makauli ha kapalyadiyan nin Ihpiditon Dioh. ");
INSERT INTO abp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Manganak yan maghay laki. Ket pangalanan mo yan Jesus, ta iligtah na hilay tatao na ta-omen hila ahe mapaduhaan uli ha kakahalanan la.” ");
INSERT INTO abp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ket nalyadi hilatin kaganaan ta-omen matupad ye hinabi nan Apo makauli kanlan popodopita na a wanae, ");
INSERT INTO abp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Bumuktot ya lano ye maghay balatang. Ket manganak ya nin maghay laki. Ket ingaten la yan Emmanuel.” (Hiyay labay habiyen, “Lamo tawo yay Dioh.”) ");
INSERT INTO abp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Haanin ha nimata yay Jose, hinumbong nay hinabi nin anghil nin Dioh kana, ket tinanggap na yay Maria bilang ahawa na. ");
INSERT INTO abp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Noba ahe naya nilalay legan mabuktot ya po. Ha nanganak yayna, hiyay Jose, pinangalanan na yan Jesus ye ongi. ");
INSERT INTO abp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hiyay Apo Jesus, nianak ya ha banwan Betlehem ha plobinhiyan Judea ha panaon nan Poon Herodes. Ha maghay mangaamot, main nilumateng ha Jerusalem a nangibat ha daya a mangadunong ha titige nin bibitoen. ");
INSERT INTO abp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ket nanepet hila kanlan tatao ihtew, “Way-ihtew yan in-anak ye ongi a mag-ilyadin poon yon Jujudio? Antepeten miya, ta nakit mi ha daya ye bitoen a pagkakitan a nianak yayna. Ket nakew kayi ihti ta-omen kayi manggalang kana.” ");
INSERT INTO abp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ha nabalitaan nan Poon Herodes yati, nayoot ye ihip na. Wanabay hila met ye kaganaan a tatao ha Jerusalem. ");
INSERT INTO abp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaya-bay hiyay Poon Herodes, impadakit na hilay mānguna a papadi boy hilay mamaihtodo nin Bibilin. Ket tinepet na hila, “Way-ihtew ya ianak ye Cristo?” ");
INSERT INTO abp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ket nakibat hila kana, “Ha banwan Betlehem ha plobinhiyan Judea, ta wanae ye impahabi nan Apo Dioh kanan podopita na hatew, ");
INSERT INTO abp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hikawon tatao ha banwan Betlehem a hakop nin Juda, aliwa kawon maaaypa kanlan kanayon a tatao ha babanwa nin Juda. Ta mangibat ya lano ha banwa yo ye maghay poon a mangalingay kanlan tatao kon Israelita.’ ” ");
INSERT INTO abp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Haanin, hiyay Poon Herodes, impadakit na hilan homain kanayon a nagtanda ye mangadunong ha titige nin bibitoen. Ket tinepet na hila, “Nakano yo yan nakit yatew a bitoen?” Nakibat hila, “Luwaynay taon ye nalabah.” ");
INSERT INTO abp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pangayadi, intubol na hilayna ha Betlehem. Ket binilinan na hila, “Makew kawoyna ha Betlehem, ta pakatapulen yo yan manged ye anak. Ket no makitan yo yayna, ipatanda yon tampol kangko ta-omen ako met makew manggalang kana.” ");
INSERT INTO abp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pamakange la nin bilin nan Poon Herodes, nakew hilayna ha Betlehem. Legan angkumodang hila palakew ihtew, nakit la yayna man yatew a bitoen. Ket imbagnoh hila nin bitoen ha angkunaan nin anak. ");
INSERT INTO abp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Uli ha pamakakit la ha bitoen, ket naaliket hilan tubat. ");
INSERT INTO abp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ket ha hinumlep hilayna ha baey, nakit la yay anak ha talig nan Maria a indo na. Ket nilumukob hilan nanggalang kana. Pangayadi, niloat lay kakaget la haka la in-ibyay kana ye didigalo la a balitok, insenso, boy makapabango a mira. ");
INSERT INTO abp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Haanin, hinabi nan Apo Dioh ha taynep lan mangadunong ha titige nin bibitoen, “Adi kawoyna ampag-udong kanan Poon Herodes.” Kaya-bay ha nuli hilayna, lumbo anay dinanan la. ");
INSERT INTO abp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ha nakaalih hilaynay mangadunong ha titige nin bibitoen, napakit ya ha taynep nan Jose ye maghay anghil nin Dioh. Ket hinabi nan anghil kana, “Mimata ka, ta hilay mitaindo mo, itakah mo hilan ilakew ha Egipto. Kumonin kawo po ihtew anggan ahe ko habiyen kanyon mag-udong kawoyna, ta an-ipatapul na yan Poon Herodes ye anak ta-omen naya ipapatey.” ");
INSERT INTO abp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kaya-bay nimata yay Jose. Ket kananyatew met ateed a madeglem, intakah na hilay mitaindo palakew ha Egipto. ");
INSERT INTO abp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ket kinumonin hila ihtew angga ha matey yay Poon Herodes. Uli yatin nalyadi, natupad ye hinabi nan Apo Dioh makauli kanlan popodopita na hatew a wanae, “Hiyay anak kon laki, hinagyat ko yan umalih ha Egipto.” ");
INSERT INTO abp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ha natandaan nan Poon Herodes a nahiliban la yan mangadunong ha titige nin bibitoen, napoot yan tubat. Kaya-bay intubol na hilay huhundaloh nan makew ha banwan Betlehem boy ha kaganaan a lulugal a mahaley ihtew. Ket imbilin na a pateyen la hilay kaganaan a lalakin aanak a nagtaon nin luwa paaypa. Ta luwaynay taon ye nalabah paibat ha nakit laya ye bitoen nin mangadunong ha titige nin bibitoen. ");
INSERT INTO abp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Uli yatin nalyadi, natupad ana ye hinabi nan podopitan Jeremias a wanae, ");
INSERT INTO abp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Main angkange a makhaw a pangandang boy panumangih ha banwan Rama. Hiyay Raquel, antangihan nay aanak na. Ket ahe ya maliwaliwa, ta natey hilaynay aanak na.” ");
INSERT INTO abp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ha natey yaynay Poon Herodes boy anti ya po ha Egipto ye Jose, napakit yayna man ha taynep na ye anghil nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hinabi nin anghil kana, “Jose, mimata ka, ta iuli mo hilaynay mitaindo mo ha Israel, ta natey yaynay malabay mamatey kanan anak.” ");
INSERT INTO abp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kaya-bay nimata yay Jose. Ket in-uli na hilaynay mitaindo na ha Israel. ");
INSERT INTO abp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Noba ha nabalitaan nan Jose a hiyay Arquelao a anak na met ateed nin Poon Herodes ye hinumagili a ampanakop, nalimowan yan makew ihtew. Haanin, ta binabalaan na yan Apo Dioh ye Jose ha taynep na, ket naglaloh hilaynan nakew ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ket kinumonin hila ha banwan Nazaret. Ha wanabay, natupad ye hinabi lan popodopita, “Ingaten laya lanon Nazareno” ye Cristo. ");
INSERT INTO abp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kananyatew a panaon, hiyay Juan a Māmawtihmo, nakew yan nangipatanda ha wangwang nin Judea ");
INSERT INTO abp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nin wanae, “Paghehean boy itgen yoynay panyag nin kahalanan, ta madanon anay panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hiyay Juan a Māmawtihmo ye andektan nin hinabi nan podopita Isaias ha hinabi na, “Main maghay ampangipangha ha wangwang nin wanae, ‘Ihadya yoy dān nan Apo. Itoynong yoy pagdanan na.’ ” ");
INSERT INTO abp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Hiyay bado nan Juan, ket yadi ha labok nin kamelyo. Boy hiyay akeh na, yadi met ha katat ayop. Hiyay pamangan na, ket kowangey boy pulot panilan. ");
INSERT INTO abp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Malabong a tatao ha banwan Jerusalem, ha hakop nin plobinhiyan Judea boy ha lulugal a mahaley ha kabatowan Jordan ye nakew kanan Juan. ");
INSERT INTO abp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ket inhabi lay kakahalanan la. Kaya-bay binawtihmowan na hilan Juan ha kabatowan nin Jordan. ");
INSERT INTO abp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noba ha nakit nan Juan a malabong a Papariseo boy Sasaduseo ye anhumaley kana a pabawtihmo met, hinabi na kanla, “Hikawon ba-mon bibikat, ayay naghabi kanyo a takahan yoy anlumateng a pamaduha nin Dioh? ");
INSERT INTO abp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","No peteg a pinaghehean yo ye kakahalanan yo, ipakit yo awod ha didiyag yo. ");
INSERT INTO abp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Adi yo an-ihipen, ‘Hi! Ahe kayi mapaduhaan, ta lalahi na kayin Abraham.’ Pakaihipen yo a agya hilatin dadapah, mababa na yan diyagen Apo Dioh a aanak nan Abraham. ");
INSERT INTO abp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Haanin met ateed, ket nakahadya yaynay Apo Dioh a mamaduha kanyo a ba-mon nakahapda anay wahay ha poon-kayo a palagen na. Ket hiyay balang poon-kayo a ahe ampanawa nin manged, putohen naya boy itapon ha apoy.” ");
INSERT INTO abp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Bawtihmowan katawo nin lanom bilang pagkakitan a pinaghehean yoynay kakahalanan yo. Noba main lumateng a igit a makapalyadiyan dinan ko, ta agya mangaget bengat nin hapatoh na, ket ahe ako katanggap-tanggap. Ket lano, bawtihmowan na kawo nin Ihpiditon Dioh boy apoy. ");
INSERT INTO abp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mailalayi ya ha maghay mamalohboh nin giniek. Hiyay ilik, ket ikamalig na. Noba hiyay apah, iulam naya ha apoy a ahe angkalep makanoman.” ");
INSERT INTO abp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hiyay Apo Jesus a ibat ha plobinhiyan Galilea, nilumateng ya ha kabatowan nin Jordan ta-omen ya pabawtihmo kanan Juan. ");
INSERT INTO abp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Noba hinabi nan Juan, “Hiko dayi ye hukat mon bawtihmowan. Taket ta pabawtihmo ka kangko?” ");
INSERT INTO abp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Noba nakibat yay Apo Jesus kana, “Higina, ta yabayti ye huhton diyagen ta-omen matupad ye kalabayan nan Apo Dioh.” Kaya-bay binawtihmowan na yan Juan. ");
INSERT INTO abp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pangayadi yan nabawtihmowan ye Apo Jesus, ket inumawah yayna ha lanom. Ket tampol yan naglukat ye langit. Ket nakit na ye Ihpiditon Dioh ha kadih kalapati a inumaypa yan inumapon kana. ");
INSERT INTO abp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ket main bihnga a nangibat ha langit a naghabi nin wanae, “Yati ye Anak kon ampakaadoen ko a angkaaliketan kon tubat.” ");
INSERT INTO abp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pangayadi, hiyay Apo Jesus, in-ugot na yan Ihpiditon Dioh ha wangwang ta-omen na yan tukhoen nin Satanas. ");
INSERT INTO abp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pangayadi nin apatapo a mangaamot a pagpalta nan mangan Apo Jesus, nabitlan yan tubat. ");
INSERT INTO abp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Haanin, nilumateng yay Satanas a manukho kana. Ket hinabi na, “No peteg a hika ye Anak nin Dioh, diyagen mo man awod a makan hilatin dadapah.” ");
INSERT INTO abp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Noba nakibat yay Apo Jesus, “Yati ye naihulat a Habi nin Dioh, ‘Aliwan bengat makan ye pagbi-ay nin tao, no aliwan tepe Habi nin Dioh.’ ” ");
INSERT INTO abp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pangayadi yatew, hiyay Satanas, inlakew na yay Apo Jesus ha banwan Jerusalem. Ket pinaideng naya ha pinakamatagay a pahen nin bobongan nin Timplo ");
INSERT INTO abp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","haka na hinabi kanan Apo Jesus, “No peteg a hika ye Anak nin Dioh, magtaboy ka man awod. Ahe ka mapano, ta wanae ye naihulat a Habi nin Dioh, ‘Itubol na hilan Apo Dioh ye aanghil na a manalima kammon manampopo ta-omen ahe mahugatan ha dadapah ye bibitih mo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Noba nakibat yay Apo Jesus kanan Satanas, “Yati ye naihulat a Habi nin Dioh, ‘Adi mo anhuboken ye Apo mon Dioh.’ ” ");
INSERT INTO abp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pangayadi, inlakew na yayna man nin Satanas ha pinakamatagay a mapantay, ta ipakit na kanay kaganaan a panakopan ihti ha babe-luta boy hiyay kabatnangan lan hilati. ");
INSERT INTO abp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hinabi nan Satanas kanan Apo Jesus, “Kaganaan yain, ibyay ko kammo dapot tana, manalimukod kan manggalang kangko.” ");
INSERT INTO abp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Noba hinabi nan Apo Jesus kana, “Umalih kayna ihti Satanas, ta yati ye naihulat a Habi nin Dioh, ‘Hiyay Apo mon Dioh ye galangen mo boy hiyan bengat ye paghilbiyan mo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pangayadi yatew, nilakwanan na yaynan Satanas ye Apo Jesus. Ket nilumateng hilay aanghil nin Dioh, ket kinalingay laya. ");
INSERT INTO abp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ha nabalitaan nan Apo Jesus a napidiho yay Juan, nag-udong ya ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Noba ahe ya kinumonin ha Nazaret, no aliwan ha Capernaum, ha ambay dagatdagatan nin Galilea ha dōn nin Zabulun boy Naftali. ");
INSERT INTO abp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uli yatin nalyadi, natupad ye hinabi nan podopita Isaias a wanae, ");
INSERT INTO abp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Hiyay luwan lugal a anhabtan Zabulun boy Naftali, madanan yan palakew ha gilid dagatdagatan boy anti ha lipay nin kabatowan nin Jordan. Hilatin luwan lugal ket hakop nin Galilea boy angkunaan nin malabong a aliwan Judio. ");
INSERT INTO abp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hilay tatao ihtew, ampagbi-ay hila ha kalitehan, noba makakit hilan tubat a kahnagan. Agya anti hila ha kalitehan boy paugot hila ha kamateyan, ket mahnagan hila met ateed.” ");
INSERT INTO abp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Paibat hatew, hiyay Apo Jesus, ket nandugi yaynan nangipatanda nin wanae, “Paghehean boy itgen yoynay panyag nin kahalanan, ta madanon anay panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Legan angkumodang yay Apo Jesus ha ambay dagatdagatan nin Galilea, nakit na hilay mikatongno a Simon a anhabtan Pedro boy Andres. Ampangikatkat hilan higay la, ta mānlapet hila. ");
INSERT INTO abp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Kilakew kawo kangko,” wanan Apo Jesus, “ta diyagen katawoynan māngumbinyo nin tatao a mamteg kangko a ba-mo kawon ampanlapet nin malanghit.” ");
INSERT INTO abp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ket tampol laynan nilakwanan ye higay la boy nakilakew hilayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Legan ampagpahulong yay Apo Jesus ha pangumodang na, nakit naya met ye mikatongno a Santiago boy Juan a anti ha bangka a ampangayuma nin higay la. Lamo la yay Zebedeo a bapa la. Ket hinagyat na hila met ye mikatongno a makilakew kana. ");
INSERT INTO abp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ket tampol lan nilakwanan ye bangka boy bapa la. Ket nakilakew hilayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Haanin, hiyay Apo Jesus, nakew yan nangiadal ha pāytiponan lan Jujudio ha kaganaan a lulugal nin plobinhiyan Galilea. Impatanda nay Manged a Balita tungkol ha panakop nan Apo Dioh boy pinaitaah na hilay tatao ha kaganaan a kalahin hakit la. ");
INSERT INTO abp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Haanin, hiyay balita tungkol kanan Apo Jesus, nitayak ana ha kaganaan a lulugal nin plobinhiyan Siria. Kaya-bay hilay kaganaan a tatao ihtew a ampaghakit nin nakahinadi, hilay hinelpan nin maloke a ihpidito, hilay angkumdey ye laman la, hilay lulumpo, inlakew la hila kanan Apo Jesus. Ket pinaitaah na hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ket agya way-ihtew ya makew, anhumbongen la yan malabong a tataon nangibat ha plobinhiyan Galilea, babanwa ha Decapolis, banwan Jerusalem boy ha kanayon a lulugal ha plobinhiyan Judea boy hilay angkumonin ha lipay kabatowan nin Jordan. ");
INSERT INTO abp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ha nakit nan Apo Jesus ye malabong a tatao, hinumaka ya ha nagmamapantay boy ihtew ya nikno. Ha hinumaley hilay mānumbong na kana, ");
INSERT INTO abp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nandugi yaynan mangiadal, a wana, ");
INSERT INTO abp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Minged hilay tataon ampamalay a katapulan la yay Apo Dioh, ta maibilang hila kanlan anhakopen na. ");
INSERT INTO abp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Minged hilay tataon antumangih, ta liwaliwaen na hilan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Minged hilay tataon ampagmakaaypa, ta tawiden lay babe-luta. ");
INSERT INTO abp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Minged hilay tataon angkahabek a manyag nin katoynongan a omen ha taon angkabitil o angkaplangan, ta pabhoyen na hilan katoynongan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Minged hilay tataon mapangingalo, ta ingalowan na hila met Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Minged hilay tataon malinih ye puho la, ta makit la yay Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Minged hilay tataon ampanyag nin paykahundo, ta mahabtan hilan aanak nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Minged hilay tataon ampipaloke uli ha panumbong la ha kalabayan nan Apo Dioh, ta maibilang hila kanlan anhakopen na. ");
INSERT INTO abp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Minged kawo no an-umihen la kawo, an-ipaloke, boy andamaen uli ha panumbong yo kangko. ");
INSERT INTO abp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wanabay met ateed ye nalyadi kanlan popodopita nin Dioh hatew. Kaya-bay maghayaghag kawo boy mag-aliket, ta mayadet ye plimyo yo ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Hinabi na po Apo Jesus, “Hikawo ye pagkaahin nin kaganaan a tatao ihti ha babe-luta. Noba no maalih anay apgad na, ahe yayna maiudong. Ha wanabay, homain anan hilbi. Kaya-bay itapon yayna tana ha dān boy tudak-tudakan anan bengat nin tatao.” ");
INSERT INTO abp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hikawo ye pinagkakingki nin kaganaan a tatao ihti ha babe-luta a omen ha maghay banwa a anti ha babe nin mapantay a makit nin kaganaan.” ");
INSERT INTO abp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Homain taon mamaet nin kingki haka na hakeban nin panakalan, no aliwan ikonin naya ha hadya a pangikunaan ta-omen ya mahnagan ye kaganaan a anti ha loob nin baey. ");
INSERT INTO abp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wanabay met kanyo. Katapulan a humnag kawo kanlan tatao makauli ha manganged a didiyag yo. Ha wanabay, igalang la yay Bapa yon Dioh a anti ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Hinabi na po Apo Jesus, “Nabaan yo nayi a nakew ako ihti ha babe-luta a mangalih nin hilbi nin Bibilin a impahulat kanan Moises boy ha huhulat lan popodopita hatew? Ahe! Nakew ako ihti ta-omen ko hila tupaden. ");
INSERT INTO abp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pakaleng-en yon manged ye habiyen ko. Legan anti po ye langit boy luta, agya hiyay pinakamakandin pahen nin Bibilin, ahe maanam anggan ahe matupad kaganaan. ");
INSERT INTO abp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaya-bay ayaman a ahe manupad ha agya po ha pinakamakandin pahen nin Bibilin boy iadal na met kanlan kanayon a ahe la tupaden, ket maibilang ya a pinakamaaypa kanlan anhakopen nan Apo Dioh. Noba ayaman a manupad nin Bibilin boy iadal na met kanlan tatao a tupaden la yatew, ket maibilang yan matagay kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta yati ye habiyen ko kanyo. Katapulan a igitan yoy panumbong lan mamaihtodo nin Bibilin boy Papariseo ha kalabayan nan Apo Dioh. Ta no ahe, ahe kawo bega maibilang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hinabi na po Apo Jesus, “Nange yoyna a hinabi hatew po kanlan nangaunan tutoa tawo, ‘Adi kawo mamatey nin tao, ta ayaman a mamatey, ket mauhgaan a mapaduhaan.’ ");
INSERT INTO abp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Noba haanin, yati ye habiyen ko kanyo, ‘Ayaman a angkapoot kanan katongno na, ket mauhgaan a mapaduhaan.’ Boy ayaman a maghabi kanan katongno na nin ‘Homain kan hilbi!’ ket maiadap ya met ha Panuhgaan lan Jujudio. Ayaman a maghabi kanan katongno na nin ‘Mutaw ka!’ ket maipalakew ya ha impilno. ");
INSERT INTO abp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kaya-bay no ampangihagpa ka nin digalo mo kanan Apo Dioh, ket maihipan mo yay hakit nakem nan katongno mo kammo, ");
INSERT INTO abp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lakwanan mo po ye hagpa mo ha pangihagpaan ta makew ka po makikahundo kana. Pangayadi, mag-udong ka boy mangihagpa kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“No main mangidalom kammo, tampol kan makikahundo kana legan ahe naka po indalom. Ta no ahe kawo mapaykahundo, ket uhgaan na kan uhgado. Pangayadi, igawang naka ha polih a mangipidiho kammo. ");
INSERT INTO abp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pakaleng-en mon manged ye habiyen ko. No nakapidiho kayna, ket ahe kayna milwah anggan ahe mo mabayadan ye kaganaan a multa mo.” ");
INSERT INTO abp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nange yoynabay met a hinabi hatew po, ‘Adi ka mamabayi o makilaki.’ ");
INSERT INTO abp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Noba haanin, yati ye habiyen ko kanyo, ‘Ayaman a mamudek a main kaotoyan ha babayi o laki, ket nagkahalanan yayna nin pamakilaki o pamabayi.’ ");
INSERT INTO abp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kaya-bay no hiyay dapit wanan a mata mo ye hangkan nin pagkahalananan mo, luowen mo yan itapon. Mamanged po a mamaghay mata mo dinan luwa noba mipalakew ka met ha impilno. ");
INSERT INTO abp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No hiyay dapit wanan gamet mo ye pagkahalananan mo, putohen mo yan itapon. Ta mamanged po a mamaghay gamet mo dinan luwa noba mipalakew ka met ha impilno.” ");
INSERT INTO abp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hinabi na po ha Bibilin, ‘No labay nin maghay laki a ihyay ye ahawa na, katapulan a biyan na yan kahulatan nin payngihyay.’ ");
INSERT INTO abp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Noba haanin, yati ye habiyen ko kanyo, ‘Ayaman a lakin mangihyay nin ahawa na, powidan bengat no nakilaki ye ahawa na, ket hiyaynabay met ye nangitudon kanan ahawa na a magkahalanan ya no mangahawa yan lumbo. Ket hiyay lakin mangahawa kanan babayin in-ihyay, magkahalanan yayna met nin pamabayi.’ ” ");
INSERT INTO abp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nange yoyna met a hinabi kanlan nangaunan tutoa tawo hatew, ‘No magpangako ye maghay tao boy hinumpaan na po ha ngalan nan Apo Dioh, katapulan a tupaden nay pangako na.’ ");
INSERT INTO abp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Noba haanin, yati met ye habiyen ko kanyo, ‘No magpangako kawo, adi kawo ampanumpa. Adi yo an-idamit ha pangako yo ye langit, ta anti ya ihtew ye pamiknoan nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Adi yo met an-idamit ye babe-luta, ta yati ye tukdoan nin bibitih na. Boy adi yo met an-idamit ye banwan Jerusalem, ta yati ye banwa nan Makapalyadiyan a Poon. ");
INSERT INTO abp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Boy adi yo met an-idamit ye laman yo, ta agya po maghay labok yon bengat, ket ahe yo mababa a paputien o pangititen. ");
INSERT INTO abp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Habiyen yoynan bengat, “Awo” no awo o “Ahe” no ahe. Ta no manumpa kawo po, ket ibat ana kanan Satanas.’ ” ");
INSERT INTO abp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nange yoyna met a hinabi hatew, ‘No binuwag na kan kapadiho mo, buwagen moya met. Boy no binongitan na kan kapadiho mo, bongitan moya met.’ ");
INSERT INTO abp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Noba haanin, yati ye habiyen ko kanyo. No main taon manyag nin maloke kanyo, adi yoya ambaeen. No main manikpa nin pingipingi mo, iadap mo po kana ye kahampad. ");
INSERT INTO abp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No main mangidalom kammo ta labay nan kowen ye bado mo, ibyay mo, dayon hamda mo. ");
INSERT INTO abp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No main hundaloh a mamilit kammon mangipakaget nin kalga na ha maghay kilomitodo, igitan mo po anggan luway kilomitodo. ");
INSERT INTO abp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No main met makikwa kammo, biyan moya. Ket no main mandam, padaman moya.” ");
INSERT INTO abp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nange yoyna met a hinabi hatew, ‘Adoen moy gayyem mo noba kahulog moy kaaway mo.’ ");
INSERT INTO abp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Noba haanin, yati ye habiyen ko kanyo, ‘Adoen yo hilay kaaway yo boy ipakigwang yo hilay ampangipaloke kanyo.’ ");
INSERT INTO abp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No wanabay ye diyagen yo, mapaptegan a aanak na kawoynan Bapa yon Dioh a anti ha langit. Ta hiyay Apo, ket padipadiho na hilan ampahnagan nin mangaamot boy ampaudanan ye mangaloke boy matoynong. ");
INSERT INTO abp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","No hilay ampangado bengat kanyo ye adoen yo, homain kawon plimyo a maagad kanan Apo Dioh. Ta wanabay met ye andiyagen lan mangakuhit a māningil nin bowih. ");
INSERT INTO abp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Boy no hilay gagayyem yon bengat ye an-idlaw yo, homain kawon nakaidumaan kanlan kanayon a tatao. Ta wanabay met ateed ye andiyagen lan tataon ahe ampamteg kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaya-bay katapulan a mag-ilyadi kawon genap a omen kanan Bapa yon Dioh a anti ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mag-alla kawo awod, ta aliwa dayin padangal nin tao ye hangkan nin panyag yon manged. No wanabay ye andiyagen yo, homain kawoyna lanon matanggap a plimyo kanan Bapa yon Dioh a anti ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaya-bay no ampanaglap kawo kanlan mangaidap, adi yo hila antuwaden ye ampagmamangedan. Ta no managlap hila kanlan mangaidap, ket an-ibabagwa la ha pāytiponan boy ha dādān ta-omen la hila dangalen nin tatao. Pakaleng-en yon manged ye habiyen ko. Natanggap laynay plimyo la. ");
INSERT INTO abp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","No managlap kawo kanlan mangaidap, adi yoynan anhabiyen ha agya ayaman ");
INSERT INTO abp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta-omen homain makatanda. Ha wanabay, hiyay Bapa yon Dioh a ampakakit ha dinyag yon homain nagtanda, ket biyan na kawo lanon plimyo yo.” ");
INSERT INTO abp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No makigwang kawo, adi yo hila antuwaden ye ampagmamangedan. Ta kalalabay lay ampideng a ampakigwang ha loob nin pāytiponan boy ha pihangaan nin dādān, ta labay lan bengat a makit hilan tatao. Pakaleng-en yon manged ye habiyen ko. Natanggap laynay plimyo la. ");
INSERT INTO abp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Noba hikawo, no makigwang kawo kanan Bapa yon Dioh, lumoob kawo ha hilid haka yo ileneb ta-omen la kawo ahe makit. Ha wanabay, hiyay Bapa yon Dioh a ampakakit nin hikliton andiyagen yo, biyan na kawo lano nin plimyo yo.” ");
INSERT INTO abp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kaya-bay no makigwang kawo, adi yo pieel-el ye hahabi a omen ha andiyagen lan ampakigwang ha diohdiohan. Ta nabaan la a leng-en nin diohdiohan ye pakigwang la no makadang. ");
INSERT INTO abp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adi yo hila antuwaden, ta bayo kawo po makikwa kanan Bapa yon Dioh, ket tanda nayna ye matapul yo. ");
INSERT INTO abp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kaya-bay no makigwang kawo, wanae ye habiyen yo, ‘Bapa mi a anti ha langit, galangen laka dayin kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apo, hakopen mo kayinan kaganaan. Matupad dayi ye kalabayan mo ihti ha babe-luta a omen ha langit. ");
INSERT INTO abp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyan mo kayin pamangan mi ha minamangaamot. ");
INSERT INTO abp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Boy patawaden mo kayi ha kakahalanan mi a omen ha pamatawad mi kanlan nagkahalanan kammi. ");
INSERT INTO abp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Adi mo kayi ampaolayan a matukho, no aliwan iligtah mo kayi kanan Satanas.’ ");
INSERT INTO abp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","No patawaden yo hilay nagkahalanan kanyo, patawaden na kawo met nin Bapa yon Dioh a anti ha langit. ");
INSERT INTO abp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Noba no ahe, ahe na kawo met patawaden.” ");
INSERT INTO abp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Hinabi na po Apo Jesus, “No magpalta kawon mangan, adi yo hila antuwaden ye ampagmamangedan. Ta ahe hila ampag-olameh boy ahe hila ampagtalaytay ta-omen la matandaan nin tatao a ampagpalta hilan mangan. Pakaleng-en yon manged ye habiyen ko. Natanggap layna ye plimyo la. ");
INSERT INTO abp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Noba hikawo, no magpalta kawon mangan, ket mag-olameh kawo boy magtalaytay ");
INSERT INTO abp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta-omen la ahe matandaan nin tatao a ampagpalta kawon mangan. Ket hiyay Bapa yon Dioh a ahe makit a anti ha langit a ampakakit nin andiyagen yon hiklito, ket biyan na kawon plimyo yo.” ");
INSERT INTO abp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Adi kawo ampanipon nin kabatnangan ihti ha babe-luta, ta ihtibay, ket anagen, taeyen, boy matakaw. ");
INSERT INTO abp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","No aliwan manipon kawo nin kabatnangan yo ha langit. Ta ihtewbay, ket homain anag o taey a makadama boy homain makahlep a manakaw. ");
INSERT INTO abp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta no way-ihtew ye kabatnangan yo, ket anti ya met ihtew ye ihip yo.” ");
INSERT INTO abp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Hiyay mata ye pinagkatillag a mamahnag nin laman. Kaya-bay no makinang ye pamilew mo, ket angkapahnagan ye matiboen laman mo. ");
INSERT INTO abp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Noba no aliwan makinang ye pamilew mo, ket angkalitehan ye matiboen laman mo. Ket no hiyay kahnagan a anti kammo, ket kalitehan met manayti, maliteh yaynan tubat ye pagbi-ay mo.” ");
INSERT INTO abp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Homain taon mapayngidlan nan paghilbiyan ye luway amo. Ta no adoen na yay magha, katapulan kahulogan na yay magha. Ket no mag-ilyadi yan mapatayaan ha magha, katapulan a umihen naya met ye magha. Wanabay met ateed, ahe yo malyadin payngidlanen a paghilbiyan ye Apo Dioh boy hiyay kabatnangan.” ");
INSERT INTO abp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaya-bay pakaleng-en yon manged yatin habiyen ko. Adi yo angkayootan ye tungkol ha pamangan yo o inomen yo o maihoot yo. Ta hiyay bi-ay, maaalaga ya dinan ha pamangan. Boy hiyay laman, maaalaga ya dinan ha bado. ");
INSERT INTO abp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bilewen yo hilay mamanokmanok a anlumpad ha luwang. Ahe hila ampananem o ampamupol boy ahe hila met ampanipon nin pamangan la ha kamalig. Noba hiyay Bapa yon Dioh a anti ha langit, ket ampakanen na hila. Hikawo po lagi! Maaalaga kawo po dinan ha mamanokmanok. ");
INSERT INTO abp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Homain ayaman a makapakadang nin bi-ay na, agya maghay odah bengat, makauli ha pangayoot na.” ");
INSERT INTO abp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Adi kawo angkayoot tungkol ha ihoot yo. Bilewen yo hilay bubulak nin ilamon a antumubo ha nikabalang. Ahe hila ampag-obda o ampanyag nin maihoot la. ");
INSERT INTO abp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Noba yati ye habiyen ko kanyo. Hiyay Poon Solomon hatew, agya mabatnang yan tubat, ahe ya bega nakaihoot nin tapih a omen ha katampa nin bulak ilamon. ");
INSERT INTO abp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No hilay iilamon a angkabi-ay haanin boy maulam kabekahan ket angkalingayen nan Apo Dioh, hikawo po lagi? Koynan kakandi ye pamteg yo kana! ");
INSERT INTO abp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kaya-bay adi yo ampagkayootan ye pamangan, inomen o maihoot yo. ");
INSERT INTO abp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta hilain a babagay ye ampakaapehen lan tataon ahe ampamteg kanan Apo Dioh. Hiyay Bapa yon Dioh a anti ha langit, tanda naynabay met a matapul yo hilain. ");
INSERT INTO abp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Noba unaen yo po ye pahakop kana boy hiyay panumbong ha kalabayan na, ket ibyay nay kaganaan a matapul yo. ");
INSERT INTO abp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Haanin awod, adi yoyna angkayootan ye matapul yo ha kabekahan, ta lumbo a naman ye kabekahan. Huhtoyna ye an-ihipen yo ha minamangaamot.” ");
INSERT INTO abp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hinabi nan Apo Jesus, “Adi kawo ampanuhga nin kapadiho yon tao ta-omen na kawo met ahe uhgaan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta no way-omen ye panuhga yo kanlan kanayon, wanabay met ateed ye panuhga nan Apo Dioh kanyo. ");
INSERT INTO abp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Taket ta andelawen moy kahalanan nin katongno mo a ba-mon bengat makandin buwag ha mata na, noba ahe mo an-ibabano ye kahalanan mo a ba-mon mayadet a buwag ha mata mo? ");
INSERT INTO abp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Way-omen mo habiyen kana, ‘Katongno, paolayan mon alihen koy buwag ha mata mo’, noba mayayadet met ye buwag mo? ");
INSERT INTO abp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hikan ampagmamangedan! Muna mo po alihen ye mayadet a buwag mo a ba-mon batang a nipabanlag ha mata mo ta-omen mo makit a manged ye makandin buwag nan katongno mo.” ");
INSERT INTO abp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Adi yo an-ipilit iadal ye tungkol kanan Apo Dioh kanlan tataon ahe malabay manlenge, ta ba-mo kawoynan bengat ampangibyay nin maalaga a bagay ha aaho ket maka balingan la kawon kayaten, o ampangibyay nin mangablin dapah ha bababoy ket tudak-tudakan laynan bengat.” ");
INSERT INTO abp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hinabi na po Apo Jesus, “Mangawok kawo kanan Apo Dioh, ket biyan na kawo. Tapulen yo kana ye matapul yo, ket matapulan yo. Paapo kawo kana, ket palooben na kawo. ");
INSERT INTO abp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta hilay kaganaan a ampangawok kanan Apo Dioh, ket ambiyan na hila. Hilay kaganaan a ampanapul kana nin matapul la, ket ampakatapul. Hilay kaganaan a ampaapo, ket ampalooben na. ");
INSERT INTO abp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hikawon mangatoa, no makikwa yan tinapay ye anak yo, ahe yoya biyan nin dapah, kali? ");
INSERT INTO abp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Boy no makikwa yan malanghit, ahe yoya biyan nin bikat, kali? ");
INSERT INTO abp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No hikawo po man a mangaloke ket tanda yoy mamyay nin manganged kanlan aanak yo, lalalo yayna ingat ye Bapa yon Dioh a anti ha langit! Ta biyan na yan manged a babagay ye ampakikwa kana.” ");
INSERT INTO abp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kaya-bay diyagen yo kanlan kanayon ye labay yon diyagen la kanyo. Ta wanabay ye huhton panumbong nin Bibilin a impahulat kanan Moises boy ha impahabi kanlan popodopita.” ");
INSERT INTO abp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Humlep kawo ha mahepey a ilwangan, ta hiyay mahepey a ilwangan boy makpit a dān, ket palakew ya ha bi-ay a homain anggaan noba nangaano hilan bengat ye anhumlep ihtew. Hiyay maway a ilwangan boy mabilal a dān, ket malabong hilay anhumlep ihtew, noba palakew met manayti ha kapaduhaan a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-alla kawo kanlan ampagkonwadin popodopita, ta humaley hila kanyon ba-mon tupa a maanoh. Noba hiyay kaptegan, ba-mo hilan ahontawon a mangatubag. ");
INSERT INTO abp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Matandaan yo hila ha didiyag la, ta hiyay madiwin tanaman, ahe ya ampanawan ubah o igoh. ");
INSERT INTO abp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Wanabay hila met ye kaganaan a manged a poon-kayo. Manawa hila met nin manged. Noba hilay aliwan manged, ket manawa hila met nin aliwan manged. Hiyay manged a poon-kayo, ket ahe ya manawa nin aliwan manged boy hiyay aliwan manged a poon-kayo, ket ahe ya met manawa nin manged. ");
INSERT INTO abp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hilay kaganaan a poon-kayon ahe ampanawa nin manged, ket mapalag haka itapon ha apoy. ");
INSERT INTO abp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kaya-bay matandaan yo hilay māgkonwadin podopita ha didiyag la.” ");
INSERT INTO abp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Malabong hilay ampangingat kangkon ‘Apo’, noba aliwan kaganaan ket maibilang kanlan anhakopen nan Apo Dioh, no aliwan hilay ampanumbong bengat ha kalabayan nan Bapa kon anti ha langit. ");
INSERT INTO abp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ha mangaamot nin panuhga, malabong hila lanoy maghabi kangko nin wanae, ‘Apo, aliwa nayi a makauli ha ngalan mo, ket impatanda mi ye hahabi mo, pinaalih mi ye mangaloke a ihpidito boy nanyag kayin malabong a kapagtakaan?’ ");
INSERT INTO abp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Noba habiyen ko lano kanla, ‘Ahe katawo katatanda! Pakataang kawo kangko, hikawon ampanyag nin maloke.’ ” ");
INSERT INTO abp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kaya-bay ayaman a ampanlenge boy anhumbongen nay anhabiyen ko, ket mailalayi ya ha lakin madunong a nangipaideng nin baey na ha pundahyon a dapah. ");
INSERT INTO abp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Agya nangudan yan makhaw boy nanlanab boy dinugoh yan makhaw a angin ye baey na, ket ahe ya bega naagwat, ta naipaideng ya ha mapah-ey a pundahyon. ");
INSERT INTO abp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Noba ayaman a nakange nin hahabi ko a ahe na met anhumbongen, ket mailalayi ya ha taon mutaw a nangipaideng nin baey na ha kalanghian. ");
INSERT INTO abp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ket ha nangudan yan makhaw, nanlanab boy dinugoh yan makhaw a angin ye baey na, tampol yan naagwat boy nangaiwahag ye kakahangkapan na.” ");
INSERT INTO abp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pangayadi nan in-adal Apo Jesus, nagtaka hilay tatao ha pangiadal na, ");
INSERT INTO abp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta main yan kapalyadiyan ha pangiadal na, aliwan omen ha pangiadal lan mamaihtodo nin Bibilin. ");
INSERT INTO abp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ha andumuong yay Apo Jesus ha mapantay, hinumbong la yan malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Haanin, hinumaley ya kana ye maghay lakin kinating haka yan nanalimukod ha adapan na a ampakiiingalo, a wana, “Apo, no labay mo, mapaitaah moko.” ");
INSERT INTO abp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ket hiyay Apo Jesus, kinimpaan naya boy hinabi na, “Awo, labay ko. Mitaah kayna!” Ket tampol yaynan naalih ye kating na. ");
INSERT INTO abp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ket hinabi nan Apo Jesus kana, “Adi mo anhabiyen ha agya ayaman ye nalyadi kammo, no aliwan makew ka tana ha padi. Ket ipabilew moy luti mo kana. Pangayadi, mangihagpa ka nin omen ha imbilin nan Moises bilang pamapteg a nitaah kayna.” ");
INSERT INTO abp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ha niabot yaynay Apo Jesus ha banwan Capernaum, nakew ya kana ye maghan kapitan nin huhundalon Romano. Ket nakihabi yay kapitan kana, ");
INSERT INTO abp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apo, hiyay ipoh ko, ampida ya ha baey, ta nalumpo ya boy angkaidapan yan tubat.” ");
INSERT INTO abp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hinabi nan Apo Jesus kana, “Awo! Lakwen ko yan paitaahen.” ");
INSERT INTO abp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Noba hinabi na met nin kapitan nin huhundaloh kana, “Apo, aliwa kon katanggap-tanggap a lakwen mo ha baey ko. Agya habiyen moynan bengat a mitaah yay ipoh ko, ket mitaah ya! ");
INSERT INTO abp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tanda ko yain, ulita anti kobay met ha hilong nin kapalyadiyan nin matatagay kangko. Boy main met huhundaloh a anti ha hilong nin kapalyadiyan ko. Ket no habiyen ko ha magha, ‘Makew ka ihtew’, ket makew ya ihtew. No habiyen ko met ha magha, ‘Makew ka ihti’, ket makew ya ihti. Boy no habiyen ko ha ipoh ko, ‘Diyagen mo yati!’ ket diyagen naya.” ");
INSERT INTO abp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pamakange nan Apo Jesus nin hinabi nan kapitan nin huhundaloh, nagtaka ya boy hinabi na kanlan anhumumbong kana, “Pakaleng-en yon manged ye habiyen ko. Homain ako po nakit ha Israel nin main wanabay a pamteg. ");
INSERT INTO abp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kaya-bay pakaihipen yo yatin habiyen ko kanyo. Malabong hila lanoy aliwan Judio a mangibat ha nakahinadi a lulugal ihti ha babe-luta ye makidungon mangan kanlan Abraham, Isaac boy Jacob ha poniyan nan Apo Dioh ha panakopan na ha langit. ");
INSERT INTO abp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Noba malabong a Jujudio a hakop na dayin Apo Dioh ye maitapon ha kalitehan. Ket ihtew hilan tumangih boy manginaet uli ha ilab.” ");
INSERT INTO abp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Haanin, hinabi nan Apo Jesus kanan kapitan, “Muli kayna. Uli ha pamteg mo, mitaah yay ipoh mo.” Ket kananyatew met ateed, nitaah yaynay ipoh nan kapitan. ");
INSERT INTO abp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nakew yay Apo Jesus ha baey nan Pedro. Panlumateng na ihtew, nakit na yay babayi a ampo nan Pedro a ampida, ta angkahalot ya. ");
INSERT INTO abp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kinimpaan nan Apo Jesus ye gamet na. Kapipikhaan, nitaah yayna. Pangayadi, nideng ya. Ket inapagan na hilayna. ");
INSERT INTO abp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ha anlulumiteh ana, malabong a tataon hinelpan nin mangaloke a ihpidito ye inlakew la kanan Apo Jesus. Ket makaulin bengat ha habi nan Apo Jesus, pinaalih na ye mangaloke a ihpidito boy pinaitaah na hilay kaganaan a ampaghakit. ");
INSERT INTO abp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dinyag nan kaganaan yati ta-omen matupad ye hinabi nan podopita Isaias, “Pinaitaah nay hahakit tawo boy inalih nay kakapeyan tawo.” ");
INSERT INTO abp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pamakakit nan Apo Jesus kanlan malabong a tatao ha palibot na, hinabi na kanlan mānumbong na, “Lumipay kitawo ha dagatdagatan.” ");
INSERT INTO abp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Haanin, main maihtodo nin Bibilin ye hinumaley kana. Ket hinabi na, “Maihtodo, makilakew ako kammo, agya way-ihtew ka makew.” ");
INSERT INTO abp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Noba nakibat yay Apo Jesus kana, “Hilay ahontawon, main hilan lubot a angkunaan boy hilay mamanokmanok, main hilan hāy. Noba hiko a ibat ha langit a in-Anak nin Tao, ket homain akon hadilin baey a mapagpainawaan.” ");
INSERT INTO abp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Haanin, magha kanlan mānumbong na ye naghabi kana, “Apo, palubohan moko po dayin muli ta-omen koya po ipailbeng ye bapa ko.” ");
INSERT INTO abp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Noba hinabi nan Apo Jesus kana, “Kilakew ka kangko boy ipailbeng moya tana ye minatey mo kanlan nangamatey ha pamilew nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Haanin, nilumugan yay Apo Jesus ha mayadet a bangka lamo na hilay mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Legan anlumipay hila, kapipikhaan kinumhaw ye angin. Ket angkahipwak-hipwakan ana nin mangayadet a dawyon ye bangka la. Noba angkatuloy yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kaya-bay hilay mānumbong na, pinokaw laya, a wanla, “Apo! Apo! Iligtah mo kayi! Lumdeg kitawoyna!” ");
INSERT INTO abp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ket hinabi nan Apo Jesus kanla, “Taket ta angkalimo kawo? Koynan kakandi ye pamteg yo.” Haanin, nideng yay Apo Jesus. Ket pinaghabiyan na yay angin boy dawyon, a wana, “Tumgen kawo!” Ket kapipikhaan, tinumana ana. ");
INSERT INTO abp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nagtaka hilay mānumbong na, a wanla, “Aya ya lagi yatin tao? Ta agya angin boy dawyon, ket angkapatgen na!” ");
INSERT INTO abp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ha nilumateng ya ha lugal lan tataon anhabtan Gadareno, hinagana yan luway lakin nilumwah ha yukib a pangilbengan. Yatin luway lalaki, ket hinelpan hila nin mangaloke a ihpidito. Matubag hilan tubat. Kaya-bay homain bega angkadān ihtew. ");
INSERT INTO abp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Haanin, impangha la kanan Apo Jesus, a wanla, “Hika a Anak nin Dioh, aya ka nayi kammi? Nakew ka nayi ihti ta-omen mo kayinan paduhaan, agya ahe po panaon?” ");
INSERT INTO abp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ha mataang makandi, main malabong a bababoy ye ampambok. ");
INSERT INTO abp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Haanin, hilay mangaloke a ihpidito, nakiiingalo hila kanan Apo Jesus, a wanla, “No paalihen mo kayi, palakwen mo kayina tana ha kawan nin bababoy.” ");
INSERT INTO abp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Higi, kokawoyna,” wanan Apo Jesus. Kaya-bay inumalih hila kanlan luway laki. Ket nakew hilaynan hinumlep ha bababoy. Haanin, hilay bababoy, nipapayew hilan nipataboy ha bengaw dagatdagatan. Ket ihtew hilaynan nangaalimeh. ");
INSERT INTO abp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Haanin, hilay ampanayhay nin bababoy, nayew hilan nangibalita kanlan tatao ha banwa nin nalyadi ha bababoy boy kanlan luway lalakin hinelpan nin mangaloke a ihpidito. ");
INSERT INTO abp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kaya-bay hilay kaganaan a tataon anti ha banwa a nakange nin yati, nakew hila kanan Apo Jesus. Ket impakihabi la kana, a wanla, “Umalih kayna dayi ihti ha lugal mi.” ");
INSERT INTO abp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaya-bay hiyay Apo Jesus boy hilay mānumbong na, nilumugan hilayna ha bangka. Ket nilumipay hila ha dagatdagatan nin Galilea. Ha nakalipay hilayna, nuli yay Apo Jesus ha banwa na. ");
INSERT INTO abp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Haanin, ha anti yayna ihtew, main nilumateng a nangaanon lakin ampanambayok nin maghay lakin lumpo. Ket inlakew laya kanan Apo Jesus. Ha nakit nan Apo Jesus ye kayadet nin pamteg la kana, hinabi na kanan lumpo, “Inong, pakhawen moy nakem mo. Napatawad anay kakahalanan mo.” ");
INSERT INTO abp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pamakange lan mamaihtodo nin Bibilin ye hinabi nan Apo Jesus, ket inihip lay wanae, “Yatin tao, ampahalumbangan na yay Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Noba hiyay Apo Jesus, tanda nay an-ihipen la. Kaya-bay hinabi na kanla, “Koynan kalok-an ye ihip yo. ");
INSERT INTO abp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Matataloh a habiyen kananyatin lumpo, ‘Napatawad kayna ha kakahalanan mo’, ta ahe yo makit no napatawad o ahe. Noba habiyen ko kana, ‘Mideng ka ta kumodang kayna’ ");
INSERT INTO abp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ta-omen yo makit a hiko a ibat ha langit a in-Anak nin Tao ket main kapalyadiyan a mamatawad nin kakahalanan ihti ha babe-luta.” Ket hinabi na kanan lumpo, “Mideng ka. Ket kadten moy apay mo, ta muli kayna.” ");
INSERT INTO abp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ket nideng ya boy nuli yayna. ");
INSERT INTO abp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ha nakit lan tatao a ampakakodang yayna, nagtaka hilan tubat. Ket inggalang la yay Apo Dioh a namyay nin wanabay a kapalyadiyan ha maghay tao. ");
INSERT INTO abp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ha umalih yaynay Apo Jesus ihtew, nakit na yay Mateo a ampikno ha pamayadan nin bowih. Ket hinabi na kana, “Kilakew ka kangko.” Ket nideng yay Mateo boy nakilakew ya kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ha ampangan yay Apo Jesus boy hilay mānumbong na ha baey nan Mateo, nilumateng hilay malabong a māningil nin bowih boy hilay kanayon a naibilang a māgkahalanan. Ket nakidungo hilan mangan. ");
INSERT INTO abp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ha nakit lan Papariseo a kadungo na hilan mangan, nanepet hila kanlan mānumbong nan Apo Jesus, “Taket ta ampakidungo yan mangan ye maihtodo yo kanlan māningil nin bowih boy kanlan kanayon a māgkahalanan?” ");
INSERT INTO abp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pamakange nan Apo Jesus nin tepet la, hinabi na kanla, “Hilay homain hakit, ahe la katapulan ye doktol, no aliwan hilay ampaghakit ye ampagkatapulan. ");
INSERT INTO abp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Balotboten yoy labay habiyen nin yatin anti ha kahulatan, ‘Aliwan hiyay ihagpa yo kangko ye labay ko, no aliwan labay kon mapangingalo kawo.’ Ta nakew ako ihti a managyat kanlan māgkahalanan, aliwa kanlan tataon ampangibaan nin hadili la a matoynong hila.” ");
INSERT INTO abp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Haanin, main nangaanon mānumbong nan Juan a Māmawtihmo ye nakew nanepet kanan Apo Jesus nin wanae, “Hikayi boy hilay Papariseo ket ampagpaltan mangan. Haanin, taket ta hilay mānumbong mo, ket ahe?” ");
INSERT INTO abp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Inlalayi nan Apo Jesus ye hadili na ha maghay lakin nagkahal, a wana, “Legan kalamo laya po nin kinumbida ha poniyan ye lakin nagkahal, ahe hila malyadin magpaltan mangan, kali? Noba maabot lano ye panaon a maialih yayna kanla ye lakin nagkahal. Ket kananyatew hila po magpaltan mangan uli ha kalelean la.” ");
INSERT INTO abp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hinabi na po Apo Jesus, “Homain taon mangitakop nin bayon tapih ha alan a bado. Ta no wanabay ye diyagen na, ket mailbah, magkotet yay bayon tapih, ket lalo yayna ingat umway ye ginit nin alan a bado. ");
INSERT INTO abp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Homain met taon mangikonin nin bayon alak ha alan a kubot a katat. Ta no diyagen na yatew, lumtoh yay alan a kubot boy mabullog yay alak. Ha wanabay, padiho hilayna lanon mahayang. No aliwan hiyay bayon alak, ket ikonin ya ha bayon kubot a katat. Ha wanabay, padiho hilan ahe mahayang.” ");
INSERT INTO abp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Legan anhabiyen nan Apo Jesus yatew, nilumateng yay maghay mānguna ha pāytiponan lan Jujudio. Ket nanalimukod ya ha adapan nan Apo Jesus, a wana, “Hiyay balatang ko, kamamatey nan bengat. Lakwen moya dayi, ta tanda ko a mabi-ay yan uman no kimpaan moya.” ");
INSERT INTO abp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kaya-bay hiyay Apo Jesus, nakilakew ya kana, lamo na hilay mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Legan angkumodang hila po, main maghay babayi a nakipaletpet met kanlan tatao angga ha niabot ya ha golotan nan Apo Jesus. Yatin babayi, ket labinluway taon yaynan andayaen. An-ihipen nan babayi, “No makiwit kon bengat ye laylay nin bado na, ket mitaah akoyna.” Kaya-bay kiniwit na ye laylay nin bado nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Haanin, namalingay yay Apo Jesus, ket nakit na yay babayi. Hinabi na kana, “Inang, pakhawen moy nakem mo. Nitaah ka uli ha pamteg mo.” Ket kananyatew met ateed, nitaah yayna. ");
INSERT INTO abp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Haanin, ha niabot yaynay Apo Jesus ha baey nan mānguna ha pāytiponan lan Jujudio, nalatngan na hilay ampanigtigan boy hilay ampangandang. ");
INSERT INTO abp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Haanin, hinabi nan Apo Jesus kanla, “Lumwah kawon kaganaan! Ta yain a anak, ket ahe ya natey, no aliwan angkatuloy yan bengat!” Ket kinailiyan laya, ta tanda la a natey yaynay anak. ");
INSERT INTO abp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ket ha nakalwah hilaynay tatao, nilumoob yayna met ye Apo Jesus. Ginemgeman nay gamet nan anak, ket nimata ya. ");
INSERT INTO abp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yatew a nalyadi, nabalitaan nin kaganaan a tatao nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ha umalih yaynay Apo Jesus ha baey nan mānguna ha pāytiponan lan Jujudio, nanumbong hila kana ye luway lakin kapkap a ampangha, a wanla, “Apo a Lahi nan Poon David, ingalowan mo kayi!” ");
INSERT INTO abp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Haanin, ha nilumateng yaynay Apo Jesus ha baey a angkunaan na, hinumaley hilay luway lakin kapkap. Ket tinepet na hila, “Pamtegan yo nayi a mapaitaah katawo?” “Awo, Apo. Ampamteg kayi,” wanla. ");
INSERT INTO abp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Haanin, hiyay Apo Jesus, kinimpaan nay mamata la boy hinabi na kanla, “Uli ha pamteg yo kangko, makakit kawoyna.” ");
INSERT INTO abp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ket kananyatew met ateed, ampakakit hilayna. Pangayadi, mahehpet na hilan binilinan Apo Jesus, “Adi yo anhabiyen ha agya ayaman ye nalyadi kanyo.” ");
INSERT INTO abp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Noba ha inumalih hilaynay luwa, ket imbabalita la ha kaganaan a tatao nin yatew a lugal ye dinyag nan Apo Jesus kanla. ");
INSERT INTO abp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Haanin, ha an-umalih hilaynan Apo Jesus, main nangilakew kana nin lakin pinaangang nin maloke a ihpidito. ");
INSERT INTO abp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ha napaalih na yaynan Apo Jesus ye maloke a ihpidito, ampakahabi yaynay laki. Ket hilay tatao, nagtaka hila, a wanla, “Yo! Ahe kitawo po bega nakakit nin wanabay ihti ha Israel.” ");
INSERT INTO abp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Noba hinabi lan Papariseo, “Ah! Ampakapaalih yan mangaloke a ihpidito, ta hiyay Satanas a poon nin mangaloke a ihpidito ye namyay kana nin kapalyadiyan a manyag nin wanabay.” ");
INSERT INTO abp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Haanin, hiyay Apo Jesus, nilakew nay babanwa boy babadiyo. Ket nangiadal ya ha pāytiponan lan Jujudio. Impatanda nay Manged a Balita tungkol ha panakop nan Apo Dioh boy pinaitaah na hilay tatao ha kaganaan a kalahin hakit. ");
INSERT INTO abp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ha nakit nan Apo Jesus ye malabong a tatao, nalunoh ya kanla, ta nakit na a malabong a tubat ye gotgot la boy homain bega ampanaglap kanla a ba-mo hilan tupa a homain pahtol. ");
INSERT INTO abp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kaya-bay hinabi nan Apo Jesus kanlan mānumbong na, “Bilewen yo hilay malabong a tataon nakahadya anan pahakop kanan Apo Dioh a ba-mon paday a malyadinan pupolen, noba kulang ye māmupol. ");
INSERT INTO abp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kaya-bay ipakigwang yo kanan Apo a nagkonin nin pupolen a mangitubol yan malabong a māmupol.” ");
INSERT INTO abp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Haanin, hiyay Apo Jesus, hinagyat na hilay labinluwan mānumbong na a humaley kana. Ket binyan na hilan kapalyadiyan a mamaalih nin mangaloke a ihpidito boy kapalyadiyan a mamaitaah nin hinyaman a hakit. ");
INSERT INTO abp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hilayati ye ngangalan nin labinluwan mānumbong nan Apo Jesus a anhabtan nan apohtol. Hiyay nuna, hiyay Simon a anhabtan Pedro, hiyay Andres a katongno nan Pedro, hiyay Santiago boy Juan a mikatongno a aanak nan Zebedeo, ");
INSERT INTO abp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","hiyay Felipe, hiyay Bartolome, hiyay Tomas, hiyay Mateo a māningil nin bowih, hiyay Santiago a anak nan Alfeo, hiyay Tadeo, ");
INSERT INTO abp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hiyay Simon a ampangimahakit kanlan Israelita boy hiyay Judas Iscariote a nangiopit kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hiyay Apo Jesus, intubol na hilay labinluwan mānumbong na boy binilinan na hila, “Adi kawo ampakew kanlan aliwan Judio o ha babanwa lan Samaritano, ");
INSERT INTO abp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","no aliwan makew kawo kanlan kapadiho tawon Israelita a ba-mon tupan ampipakat. ");
INSERT INTO abp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ipatanda yo kanla a madanon anay panakop nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paitaahen yo hilay ampaghakit boy hilay kinating. Bi-ayen yo hilay nangamatey boy paalihen yo hilay mangaloke a ihpidito kanlan tatao. Yatin kapalyadiyan a tinanggap yo, ket homain bayad. Kaya-bay adi yo hila met ampabayaden ye tataon mahaglapan yo. ");
INSERT INTO abp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Adi kawo ampangaget nin pilak. ");
INSERT INTO abp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Boy ha pangumodang yo, adi kawo met ampangaget nin bakoto, bado a paghagiliyan, ihtiping, o teken. Ta hiyay māg-obda, katapulan a biyan yan matapul na.” ");
INSERT INTO abp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pamiabot yo ha maghan banwa o badiyo, manapul kawon taon malabay mamadagoh kanyo. Ket ihtewbay kawoyna kumonin kana angga ha umalih kawo nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ha panhumlep yo ha baey la, habiyen yoy wanae, ‘Magkamain hila dayin katanaan ye nagbaey.’ ");
INSERT INTO abp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No manged ye pananggap la kanyo, peteg a magkamain hilan katanaan nan Apo Dioh. Noba no aliwan manged ye pananggap la kanyo, ahe hila magkamain. ");
INSERT INTO abp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No ahe la kawo tanggapen o leng-en nin tatao ha maghay baey o banwa, ikampag yo po ye tuwapok ha bibitih yo bilang pangipatanda kanla a maloke ye dinyag la. Ket alihan yo hilayna. ");
INSERT INTO abp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pakaleng-en yon manged ye habiyen ko. Ha Mangaamot nin Panuhga, mamabyat ye ipaduha kanla dinan kanlan taga Sodoma boy taga Gomorra a nanyag nin kalok-an hatew.” ");
INSERT INTO abp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Hinabi na po Apo Jesus kanlan mānumbong na, “Leng-en yoko. Itubol katawo a ba-mon tupa kanlan tataon ba-mon ahontawon. Kaya-bay pakahidi kawo a ba-mon bikat boy magpakaamo a ba-mon kalapati. ");
INSERT INTO abp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-alla kawo, ta dakpen la kawon ilakew kanlan mānungkolan boy hibladen la kawo ha loob nin pāytiponan lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ket uli ha panumbong yo kangko, dakpen la kawon iadap kanlan gogobilnadol boy kanlan popoon. Ket yabaytew yaynay panaon yo a mangipapteg kanla boy kanlan aliwan Judio nin tungkol kangko. ");
INSERT INTO abp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ket no dakpen la kawon iadap ha panuhgaan, adi yo angkahindakan no way-omen kawo makibat o no hinyay habiyen yo. Ta kananyatew met ateed, ket ipaihip nan Ihpiditon Dioh kanyo ye habiyen yo. ");
INSERT INTO abp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta aliwan hikawo ye maghabi, no aliwan hiyay Ihpidito nan Bapa yon Dioh ye maghabi makauli kanyo.” ");
INSERT INTO abp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kananyatew a panaon, main tataon mangiopit nin kakatongno la ta-omen pateyen. Main met tutoan mangiopit nin aanak la. Boy main met aanak a lumaban ha tutoa la boy mangipapatey. ");
INSERT INTO abp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Uli ha panumbong yo kangko, pag-inakitan la kawon kaganaan a tatao. Noba ayaman a mikakaantin mapatayaan anggan kalampuhan, ket miligtah ya. ");
INSERT INTO abp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No ipaloke la kawo ha maghay banwa, makew kawo ha kanayon a banwa. Pakaleng-en yon manged ye habiyen ko. Ahe yo po lano nayadi a lakwen ye kaganaan a babanwa ha Israel, ket hiko a ibat ha langit a in-Anak nin Tao, mag-udong akoyna ihti.” ");
INSERT INTO abp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Homain ampag-adal a umiigit kanan maihtodo na. Boy homain met ipoh a umiigit kanan amo na. ");
INSERT INTO abp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaya-bay no hiyay an-adalan, ket makadiha yan omen ha nadihaan nan maihtodo na, huhto bengat yain. Boy no hiyay ipoh, ket makadiha yan omen ha nadihaan nan amo na, huhto bengat yain. No hikon mānguna yo, ket hinabtan la kon Satanas, hikawo po lagi?” ");
INSERT INTO abp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kaya-bay adi kawo angkalimo kanlan tatao. Ta homain nakatayo a ahe lano mibagwa boy homain met hiklito a ahe lano matandaan. ");
INSERT INTO abp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hinyaman ye anhabiyen ko kanyo ha maliteh, ket habiyen yo ha mahnag. Ket hilay an-ionanah ko, ipangha yo ha kaganaan. ");
INSERT INTO abp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Adi yo hila angkalimowan ye malabay mamatey kanyo, ta hiyay laman yon bengat ye mababa lan pateyen, noba aliwan kalelwa yo. Hiyay Apo Dioh ye kalimowan yo, ta hiyabay ye malyadin mamatey boy mangitapon kanyo ha impilno. ");
INSERT INTO abp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aliwa nayi a mamoda bengat ye alaga nin luway piliw? Noba homain kanla ye matey a ahe na kamatandaan nin Bapa yon Dioh. ");
INSERT INTO abp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hikawo po lagi, ket agya bilang nin labok yo, ket tanda na. ");
INSERT INTO abp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaya-bay adi kawo angkalimo, ta mamabli kawo ha pamilew nan Apo Dioh dinan ha malabong a piliw.” ");
INSERT INTO abp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hinabi na po Apo Jesus, “Ayaman a ahe mangikading-ey kangko ha adapan lan tatao, ket ahe koya met ikading-ey ha adapan nan Bapa kon Dioh a anti ha langit. ");
INSERT INTO abp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Noba ayaman a mangikading-ey kangko ha adapan lan tatao, ket ikading-ey koya met ha adapan nan Bapa ko ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Adi yo an-ihipen a nakew ako ihti ha babe-luta ta-omen ko hila paykakahundoen ye tatao. Nakew ako ihti ta-omen ko hila paykukuntadaen. ");
INSERT INTO abp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Uli kangko, hiyay anak a laki, kuntadaen na yay bapa na. Hiyay anak a babayi, kuntadaen naya met ye indo na. Ket hiyay manuyang a babayi, kuntadaen naya met ye ampo na a babayi. ");
INSERT INTO abp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hiyay mag-ilyadin kaaway nin maghay tao ket hiyay pamilya na met ateed.” ");
INSERT INTO abp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ayaman a umiigit ye pangado na kanlan tutoa na dinan kangko, ket ahe yan katanggap-tanggap a mag-ilyadin mānumbong ko. Wanabay met kanan taon umiigit ye pangado na kanan anak na dinan kangko. ");
INSERT INTO abp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ayaman a ahe nakahadya a matey ha panumbong na kangko a ba-mo yan ampamatay nin kodoh, ket ahe yan katanggap-tanggap a mag-ilyadin mānumbong ko. ");
INSERT INTO abp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ayaman a taon ampangihilib nin bi-ay na, ket maanam na. Noba ayaman a nakahadya a matey uli ha panumbong na kangko, ket mabyayan yan bi-ay a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ayaman a ampananggap kanyo, ket antanggapen na koyna met. Ket ayaman a ampananggap kangko, ket antanggapen na yayna met ye Bapa kon Dioh a nangitubol kangko. ");
INSERT INTO abp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ayaman a ampananggap nin maghay podopita uli ha pagkapodopita na, ket makatanggap ya met lano nin omen ha plimyo nin podopita. Ayaman a ampananggap nin taon matoynong ulita matoynong ya, ket makatanggap ya met lano nin omen ha plimyo nin taon matoynong. ");
INSERT INTO abp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pakaleng-en yon manged ye habiyen ko. Ayaman a mamyay nin agya maghay bahon lanom a malay-ep ha maghay pinakamaaypa a mānumbong ko ulita magha yan mānumbong ko, ket homain hapo a makatanggap yan plimyo a ibat kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pangayadi na hilan binilinan Apo Jesus ye labinluway mānumbong na, nakew yan nangiadal boy nangipatanda nin Manged a Balita ha mangahaley a babanwa ihtew. ");
INSERT INTO abp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hiyay Juan a Māmawtihmo, legan anti ya ha pidihowan, nangean nay tungkol ha andiyagen nan Apo Jesu Cristo. Kaya-bay nangitubol yan ano kataon mānumbong na ");
INSERT INTO abp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","a makew manepet kanan Apo Jesus. Ket ha niabot hilayna kana, hinabi la, “Intubol na kayin Juan a Māmawtihmo a manepet kammo no hikayna ye Cristo a impangako nan Apo Dioh a lumateng, o mangagad kayi po nin lumbo?” ");
INSERT INTO abp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nakibat yay Apo Jesus kanla, “Mag-udong kawoyna kanan Juan. Ket ibalita yo kana ye nange boy nakit yo. ");
INSERT INTO abp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hilay kakapkap, ampakakit hilayna. Hilay lulumpo, ampakakodang hilayna. Hilay kinating, nitaah hilayna. Hilay teteek, ampakange hilayna. Hilay natey, nabi-ay hilan uman boy hiyay Manged a Balita, an-ipatanda ana met kanlan mangaidap. ");
INSERT INTO abp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Boy habiyen yo met kana a minged ye taon ahe ampagluwaluwa kangko.” ");
INSERT INTO abp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ha umalih hilaynay mānumbong nan Juan, hinabi nan Apo Jesus kanlan malabong a tatao, “Ha nakew kawo ihtew ha wangwang, hinyay anhigudowen yon makit? Maghay malawak a ampiangin-angin? Ahe! ");
INSERT INTO abp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Maghay taon nakabado nin matampa? Ahe, ta hilay tataon ampagbado nin matampa, ket ihtew yo hila makit ha mangayadet a baey lan popoon. ");
INSERT INTO abp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nakew kawo kana, ta labay yon makakit nin maghay podopita nin Dioh, kali? Awo, peteg a magha yan podopita ye Juan a Māmawtihmo. Ket habiyen ko kanyo a umiigit ya po ha maghay podopita. ");
INSERT INTO abp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta hiyabay ye andektan nan Apo Dioh ha naihulat a Habi na, ‘Mangitubol akon māngihabi ko a mauna kammo ta-omen na italadan ye danan mo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hinabi na po Apo Jesus, “Pakaleng-en yon manged ye habiyen ko. Ha kaganaan a tatao ihti ha babe-luta, homain umiigit kanan Juan a Māmawtihmo. Noba agya wanabay man, hiyay pinakamaaypa kanlan anhakopen nan Apo Dioh, ket umiigit ya po kanan Juan. ");
INSERT INTO abp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ket impaibat ha nangiadal yay Juan a Māmawtihmo anggayna haanin, an-ipilit lan tatao ye hadili la a maibilang ha panakopan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta ha ahe ya po nilumateng ye Juan a Māmawtihmo, hiyay tungkol ha panakop nin Dioh, ket impatanda laynan kaganaan a popodopita boy anti ya met ha Bibilin a impahulat kanan Moises. Noba angga yan bengat yain ha panaon nan Juan a Māmawtihmo. ");
INSERT INTO abp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ket no ampamtegan yoy anhabiyen la, hiyay Juan ye Elias a an-agaden yon lumateng. ");
INSERT INTO abp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hinabi na po Apo Jesus, “Hinya lagi ye pangilalayian ko kanlan tatao kananyatin panaon? Ilalayi ko hila ha aanak a ampikno ha paydagawan a ampanghaan lay kadagaw la, a wanla, ");
INSERT INTO abp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tinigtigan mi kawon pangkahal, noba ahe kawo tinumalek! Kinantaan mi kawon kanta no main natey, noba ahe kawo met tinumangih!’ ” ");
INSERT INTO abp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Wanabay hila met ye tatao haanin. Ta ha nilumateng yay Juan a Māmawtihmo, nakit la yan ampagpaltan mangan boy ahe ampinom nin alak. Noba hinabi lan tatao, ‘Hi! Hinelpan yan maloke a ihpidito.’ ");
INSERT INTO abp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ket hiko a ibat ha langit a in-Anak nin Tao, ha nilumateng ako, nakit la kon ampangan boy ampinom nin alak. Noba hilay tataon nakakit kangko, hinabi la met, ‘Mahiba yan mangan, māglahing, boy gayyem lan mangakuhit a māningil nin bowih boy kanayon po a māgkahalanan.’ Agya wanabay man, hiyay kadunongan nin Dioh, ket angkakit ha didiyag lan ampanumbong ha kalabayan na.” ");
INSERT INTO abp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Haanin, hiyay Apo Jesus, pinaghabiyan na hilay tataon angkumonin ha babanwan nanyagan nan malabong a kapagtakaan, ta ahe hila naghehe ha kakahalanan la. ");
INSERT INTO abp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Hinabi na, “Hikawon taga Corazin boy taga Bethsaida, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta no hiyay kapagtakaan a dinyag ko kanyo, ket ihtew koyna dayin dinyag ha Tiro boy ha Sidon, ket nabuyot hilayna dayin naghoot nin tapih a mangitit a pamaneh ye angkumonin ihtew boy nagbodobod nin tubog ha ō la bilang pagkakitan a ampaghehe hilayna ha kakahalanan la. ");
INSERT INTO abp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Noba pakaleng-en yon manged ye habiyen ko. Ha Mangaamot nin Panuhga, mamabyat ye ipaduha kanyo dinan kanlan taga Tiro boy taga Sidon. Ta agya nakit yoynay kapagtakaan a dinyag ko, ket ahe kawon teed naghehe ha kakahalanan yo. ");
INSERT INTO abp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ket hikawo met a taga Capernaum, nabaan yo nayi a midangal kawo angga ha langit? Ahe! Itapon na kawon Apo Dioh ha impilno! Ta no hiyay kapagtakaan a dinyag ko kanyo, ket ihtew koyna dayin dinyag ha banwan Sodoma, ket ahe na dayin inulam Apo Dioh ye banwa la boy anti ya po dayi angga haanin. ");
INSERT INTO abp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaya-bay pakaleng-en yon manged ye habiyen ko. Ha Mangaamot nin Panuhga, mamabyat ye ipaduha kanyo dinan kanlan taga Sodoma.” ");
INSERT INTO abp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kananyatew a odah, nakigwang yay Apo Jesus nin wanae, “Bapa ko a Apo ha langit boy ihti ha babe-luta, ampahalamatan kata, ta hilatin kaptegan, ket ahe mo impatanda kanlan tataon ampangibaan nin hadili la a mangahidi boy mangadunong, no aliwan kanlan tataon mangakandin bengat ye tinanda a omen kanlan mangakandin aanak. ");
INSERT INTO abp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Awo, Bapa ko, dinyag mo yatew, ta yabaytew ye kalabayan mo.” ");
INSERT INTO abp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Haanin, hinabi nan Apo Jesus kanlan tatao, “Impabaala naynan Bapa kon Dioh kangko ye kaganaan a babagay. Ket homain nagtanda kangko, no aliwan hiyay Bapa kon Dioh bengat. Homain met nagtanda kanan Bapa kon Dioh, no aliwan hikon bengat a Anak na boy hilay tataon labay kon pangipatandaan kana.” ");
INSERT INTO abp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hikawon kaganaan a angkabyatan boy angkaidapan, humaley kawo kangko, ta hikoy mamainawa kanyo. ");
INSERT INTO abp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Humbongen yoy bibilin ko boy paadal kawo kangko, ta maanoh ako boy mapagmakaaypa. Ket pakatanaen koy ihip yo. ");
INSERT INTO abp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta mataloh man a humbongen ye bibilin ko boy makumpang bengat a diyagen ye an-ipadyag ko.” ");
INSERT INTO abp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ha maghay Mangaamot nin Pagpainawa, hiyay Apo Jesus boy hilay mānumbong na, nipadān hila ha katidigowan. Ket legan ampagdān hila ihtew, hilay mānumbong na, nandayon hilan nante nin tidigo. Ket an-itatangay lan antim-en, ta mabitil hilayna. ");
INSERT INTO abp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ha nakit lan Papariseo yatew, hinabi la kanan Apo Jesus, “Bilewen moy andiyagen lan mānumbong mo! Ampante hilan tidigo. Bawal yain ha Mangaamot nin Pagpainawa!” ");
INSERT INTO abp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nakibat yay Apo Jesus kanla, “Ahe yo po nayi nabaha ye dinyag nan David hatew? Ha nabitlan ya boy hilay kalalamoan na, ");
INSERT INTO abp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","hinumlep ya ha Toldan Panggalangan kanan Apo Dioh. Ket nangwa yan tinapay a inhagpa kanan Apo Dioh. Kinan na boy pinakan na hila met ye kalalamoan na. Noba ahe ya nagkahalanan agya po man bawal yatew ha Bibilin, ta hilay papadi bengat ye malyadin mangan nin inhagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Boy ahe yo met nayi nabaha ha impahulat kanan Moises a hilay papadi, ket ampag-obda hila ha Timplo agya Mangaamot nin Pagpainawa, noba ahe hila ampagkahalanan? ");
INSERT INTO abp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Habiyen ko kanyo a anti ya ihti haanin ye umiigit po dinan ha Timplo. ");
INSERT INTO abp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Ta hiko a ibat ha langit a in-Anak nin Tao ket main kapalyadiyan a mangihabi no hinyay huhton diyagen ha Mangaamot nin Pagpainawa. Hinabi nan Apo Dioh ha naihulat a Habi nin Dioh, ‘Aliwan hiyay ihagpa yo kangko ye labay ko, no aliwan labay kon mapangingalo kawo.’ No natalohan yon bengat ye labay habiyen nin yatew, adi yo hila dayi an-uhgaan ye tataon homain kahalanan.” ");
INSERT INTO abp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Inumalih yay Apo Jesus ihtew. Ket nakew ya ha pāytiponan lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Haanin, main maghay laki ihtew a kinumpit ye maghay gamet na. Main met nangaanon Papariseo ihtew a ampagbantay no paitaahen na yan Apo Jesus ta-omen laya maidalom. Nanepet hila kanan Apo Jesus, “An-ipaluboh nayi ha Bibilin ye mamaitaah nin ampaghakit ha Mangaamot nin Pagpainawa?” ");
INSERT INTO abp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nakibat yay Apo Jesus kanla nin wanae, “No hiyay maghan tupa yo, ket maampag ya ha lubot ha Mangaamot nin Pagpainawa, ahe yoya nayi iawah?” ");
INSERT INTO abp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“No maalaga yay tupa yo, lalalo ana ingat a maalaga yay tao. Kaya-bay an-ipaluboh nin Bibilin ye panyag nin manged ha Mangaamot nin Pagpainawa.” ");
INSERT INTO abp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ket haanin, hinabi nan Apo Jesus kanan lakin kinumpit ye gamet na, “Ipanat moy gamet mo.” Impanat nay gamet na, ket nitaah yayna. Ket padihoyna ha maghay gamet na. ");
INSERT INTO abp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Haanin hilay Papariseo, nilumwah hilayna ha pāytiponan. Ket pinaytongtongan la no way-omen laya maipapatey ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Noba tanda nan Apo Jesus ye tikih lan Papariseo kana. Kaya-bay inumalih ya ihtew. Malabong hilay tataon hinumumbong kana. Ket hilay kaganaan a ampaghakit, pinaitaah na hila. ");
INSERT INTO abp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Noba impahehpet nan imbilin kanla, “Adi yo an-ibalita kanlan kanayon a tatao no aya ko.” ");
INSERT INTO abp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yabayti ye katupadan nin hinabi nan Apo Dioh kanan podopita Isaias hatew, ");
INSERT INTO abp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yabayti ye pinili kon māghilbi ko. An-adoen koya boy angkaaliketan ko yan tubat. Itubol ko kanay Ihpidito ko, boy ipatanda na ha kaganaan a tatao ihti ha babe-luta ye katoynongan. ");
INSERT INTO abp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Adi ya ampakingatngat, adi ya ampamalingha boy ahe mange ye bihnga na ha dān. ");
INSERT INTO abp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hilay tataon mangakapey ye pamteg la, ket pakhawen na hila. Boy hilay angkaalihan nin kahigudowan, ket angkalingayen na hila. Ahe ya tumgen anggan ahe na maipanambot ye katoynongan. ");
INSERT INTO abp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ket hiyabay ye kahigudowan lan kaganaan a tatao ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Haanin, main ano kataon nangilakew kanan Apo Jesus nin maghay lakin pinakapkap boy pinaangang nin maloke a ihpidito. Haanin, pinaitaah na yan Apo Jesus ye laki. Kaya-bay ampakakit boy ampakahabi yayna. ");
INSERT INTO abp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ket hilay tatao ihtew, nagtaka hila boy hinabi la, “Ah! Hiyabay ana laweh ye impangako nan Apo Dioh a Māngiligtah a lahi nan Poon David?” ");
INSERT INTO abp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pamakange lan Papariseo yatew, hinabi la, “Ah! Ampakapaalih yan mangaloke a ihpidito, ta hiyay Satanas a poon lan mangaloke a ihpidito ye namyay kana nin kapalyadiyan a manyag nin wanabay.” ");
INSERT INTO abp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Noba tanda nan Apo Jesus ye an-ihipen la. Kaya-bay hinabi na kanla, “No hilay tataon angkumonin ha maghay panakopan ket mapay-away-away, madama ye panakopan. Wanabay met ha maghay banwa o pamilya. No mapay-away-away hila, ket ahe hila magbuyot. ");
INSERT INTO abp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kaya-bay no paalihen na hilan Satanas ye anhakopen na, ket ahe ya magbuyot ye panakop na, kali? ");
INSERT INTO abp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Haanin, no hiyay Satanas ye namyay kangko nin kapalyadiyan a mamaalih nin mangaloke a ihpidito, aya met awod ye namyay kanlan mānumbong yo nin kapalyadiyan, ta ampamaalih hila met nin mangaloke a ihpidito? Hilay mānumbong yoyna met ye makapipapteg a aliwan huhto ye an-ihipen yo. ");
INSERT INTO abp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Noba ulita ampamaalih akon maloke a ihpidito makauli ha Ihpiditon Dioh, hiyay labay habiyen, nilumateng yaynay panakop nan Apo Dioh kanyo.” ");
INSERT INTO abp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Inlalayi na yan Apo Jesus ye Satanas ha maghay lakin makhaw, “Homain taon makababa a lumoob manakaw ha babandi nin makhaw a laki, no aliwan hiyay mamakhaw po kana. Ket no mabalol na yaynay makhaw a laki, malyadi naynan kowen ye hinyaman a malabayan na ha loob nin baey.” ");
INSERT INTO abp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Haanin, ayaman a ahe ampakitupig kangko, ket angkumuntada ya kangko. Ayaman a ahe ampanaglap kangkon mangihaley nin tatao kanan Apo Dioh, ket ampangitaang ya kana. ");
INSERT INTO abp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pakaleng-en yon manged ye habiyen ko! Kaganaan a kakahalanan boy pangumih ha ayaman, ket mapatawad ya. Noba ayaman a mangumih kanan Ihpiditon Dioh, ket ahe ya mapatawad. ");
INSERT INTO abp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ayaman a mangumih kangko a ibat ha langit a in-Anak nin Tao, ket mapatawad ya. Noba ayaman a mangumih kanan Ihpiditon Dioh, ahe ya mapatawad haanin o makanoman.” ");
INSERT INTO abp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hinabi na po Apo Jesus, “Matandaan ye poon-kayo ha dawa na. No manged ye poon-kayo, manged met ye dawa na. Noba no aliwan manged ye poon-kayo, aliwa met manged ye dawa na. ");
INSERT INTO abp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hikawon lalahi nin bikat, mangaloke kawo! Way-omen kawon makapaghabin manganged? Ta no hinyay anti ha puho nin maghay tao, ket wanabay ya met ye anhabiyen na. ");
INSERT INTO abp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hiyay taon manged, ket ampaghabi yan kangedan, ta pawa kangedan ye anti ha puho na. Noba hiyay taon maloke, ampaghabi yan mangaloke, ta pawa mangaloke ye anti ha puho na. ");
INSERT INTO abp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pakaihipen yon manged yatin habiyen ko. Lano ha mangaamot nin panuhga nin Dioh, ket pakibatan nin balang tao ye kaganaan a hinabi na a homain kowinta. ");
INSERT INTO abp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta matandaan makauli ha hahabi mo no paduhaan na kan Apo Dioh o ahe.” ");
INSERT INTO abp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Haanin, main nangaanon mamaihtodo nin Bibilin boy Papariseo ye naghabi kanan Apo Jesus nin wanae, “Maihtodo, mangipakit ka man awod nin kapagtakaan bilang pagkakitan a hikan peteg ye intubol nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nakibat yay Apo Jesus kanla, “Hikawon tatao kananyatin panaon, tubat ye kalok-an yo boy ahe na kawo mapatayaan Apo Dioh. Ampakikwa kawon kapagtakaan bilang pagkakitan a hiko ye intubol nan Apo Dioh. Noba homain akon ipakit kanyo, no aliwan hiyay kapagtakaan a omen ha nalyadi kanan podopitan Jonas hatew. ");
INSERT INTO abp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","No way-omen yan nagbuyot nin tatloy mangaamot boy madeglem ye Jonas ha loob nin bitoka nin digdig a malanghit, hiko a ibat ha langit a in-Anak nin Tao, tatloy mangaamot boy madeglem ko met lano a nakailbeng. ");
INSERT INTO abp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha Mangaamot nin Panuhga nan Apo Dioh, hilay taga Nineve a naghehe, ket mideng hilan manihtigon laban kanyon tatao kananyatin panaon. Ta hatew ha nange lay impatanda nan Jonas, ket pinaghehean lay kakahalanan la. Ket haanin, anti ko ihti a madadangal po kanan Jonas. Noba agya po man nange yoy impatanda ko, ahe kawon teed naghehe ha kakahalanan yo. ");
INSERT INTO abp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ha Mangaamot nin Panuhga nan Apo Dioh, hiyay Reyna ha Abagatan, mabi-ay ya met uman. Ket mideng yan manihtigon laban kanyon tatao kananyatin panaon. Ta hatew, agya angkumonin ya ha mataang a lugal, ket nakew yan teed nanlenge nin kadunongan nan Poon Solomon. Ket haanin, anti ko ihti a madadangal po kanan Solomon, noba ahe yoko met anleng-en.” ");
INSERT INTO abp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Hinabi na po Apo Jesus, “No alihan na yan maloke a ihpidito ye maghay tao, hiyay maloke a ihpidito, ket makew yan magpahyal ha maklang a lugal ta-omen ya manapul nin pagpainawaan na. Ket no homain yan makitan, ");
INSERT INTO abp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","habiyen na ha hadili na, ‘Hi! Udongen ko yaynan bengat ye taon ibatan ko hatew.’ Ha pag-udong na kanan taon ibatan na, ket malatngan naya a ba-mon maghay baey a homain angkumonin kana, malinih boy malimpeh. ");
INSERT INTO abp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kaya-bay umalih yayna man, ta managyat ya po nin pitoy ihpidito a maloloke po kana. Ket humlep hila kana. Kaya-bay maloloke po ye kahahaad na lano dinan ha una. Wanabay met ye malyadi kanyon mangaloke a tatao kananyatin panaon.” ");
INSERT INTO abp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Haanin, legan ampaghabi ya po ye Apo Jesus kanlan tatao, nilumateng yay indo na boy hilay kakatongno na a lalaki. Ket ampideng hila ha ilwah, ta labay la yan katongtongen ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Haanin, main tao a naghabi kanan Apo Jesus, “Hiyay indo mo boy hilay kakatongno mon laki, anti hila ha ilwah. Ket labay la kan makatongtong.” ");
INSERT INTO abp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nakibat yay Apo Jesus kana, “Aya hila lagi ye indo ko boy kakatongno ko?” ");
INSERT INTO abp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Haanin, intamudo na hilay mānumbong na. Ket hinabi na, “Hilati ye kakatongno ko boy indo ko, ");
INSERT INTO abp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ta ayaman a ampanumbong ha kalabayan nan Bapa kon anti ha langit, ket hilabay ye kakatongno ko boy indo ko.” ");
INSERT INTO abp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kananyatew a mangaamot, hiyay Apo Jesus, inumalih ya ihtew ha baey a naytiponan lan tatao. Ket nakew yan nikno ha ambay dagatdagatan. ");
INSERT INTO abp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Malabong a tubat ye tataon namalibot kana. Kaya-bay nakew yan nilumampat ha bangka. Ket nikno ya, ta ihtew yan mangiadal. Hilay tatao met, ket ampideng hilan ampanlenge kana ha gilid lanom. ");
INSERT INTO abp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Malabong ye in-adal na kanla makauli ha pangilalayi. Hinabi na kanla, “Main maghay māgtalon ye nakew nanabwag nin bini ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ha panabwag na, main nangaanon bini ye naampag ha dān. Ket hilatin bibini, kinan nin mamanokmanok. ");
INSERT INTO abp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Main met nangaanon bini ye naampag ha kadapahan a main maimpih a luta. Ket mapadah yan tinumubo ye bibini, ta maimpih ye luta. ");
INSERT INTO abp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Noba ha naamotan hilayna, ket nangalangey boy nangayango, ta mangaababe ye yamot la. ");
INSERT INTO abp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Main met nangaampag ha antuboan nin madiwin iilamon. Ket ha tinumubo hilatew a bini, tinumubo hilayna met ye madiwin iilamon. Ket tinugpawan lay tinumubo a bibini. ");
INSERT INTO abp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Main met bibini a naampag ha mabona a luta. Ket malambot ye tubo la boy nanawa hila. Main nanawan magatoh, anemapo, boy main tatlompo.” ");
INSERT INTO abp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hinabi na po Apo Jesus, “Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Haanin, hinumaley hila kanan Apo Jesus ye mānumbong na. Ket tinepet laya, “Apo, taket ta no mangiadal ka kanlan tatao, ket pawa makauli ha pangilalayi ye paghabi mo kanla?” ");
INSERT INTO abp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nakibat yay Apo Jesus kanla, “Nabyayan kawon pagkataloh nin hiklito nin tungkol ha panakop nan Apo Dioh, noba hilay kanayon, ahe. ");
INSERT INTO abp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta hiyay taon ampanumbong nin nange na a kaptegan, ket lalo ya po mabyayan nin pagkataloh. Noba hiyay taon ahe ampanumbong nin nange na a kaptegan, agya po hiyay makandin pagkataloh na, ket kowen ya po kana. ");
INSERT INTO abp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaya-bay pawa makauli ha pangilalayi ye paghabi ko kanlan kanayon. Ta agya po man mamilew hilan mamilew, ket ahe hila makabalay boy agya po man manlenge hilan manlenge, ket ahe hila makataloh. ");
INSERT INTO abp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natupad kanla ye impahulat nan Apo Dioh kanan podopita Isaias hatew, ‘Agya po man manlenge kawon manlenge, ket ahe kawo makataloh boy agya po man mamilew kawon mamilew, ket ahe kawo makabalay.’ ");
INSERT INTO abp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta hilatin tatao, ket mabyang ye ō la. Hinakeban lay talinga la boy in-ipleng lay mata la. No aliwa dayin wanabay, ket makakit ye mata la boy makange ye talinga la, ket makataloh hilayna. Ha wanabay, mag-udong hilayna kangko, ket paitaahen ko hila.” ");
INSERT INTO abp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hinabi na po Apo Jesus kanlan mānumbong na, “Noba minged kawo, ta angkakit yoy andiyagen ko boy angkatalohan yoy anhabiyen ko. ");
INSERT INTO abp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pakaleng-en yon manged ye habiyen ko! Hatew, malabong hilay popodopita boy matoynong a tatao ye malabay makakit boy makange nin nakit boy nange yo haanin. Noba ahe nalyadi yati ha panaon la.” ");
INSERT INTO abp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hinabi nan Apo Jesus, “Leng-en yoy labay habiyen nin pangilalayi tungkol ha mānabwag. ");
INSERT INTO abp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hiyay bini ket Habi nin Dioh. Hiyay dān a kinaampagan nin bini, ket hilabay ye tataon nakange nin Habi nin Dioh a tungkol ha panakop na, noba ahe la natalohan. Haanin, nilumateng yay Satanas. Ket inalih na ha puho la ye nange la.” ");
INSERT INTO abp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ket hiyay kadapahan a main maimpih a luta, ket hilabay ye tataon angkaaliket a nakange boy nananggap nin Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Noba ahe ya nanyamot ha puho la. Kaya-bay ha nilumateng ye kaidapan o pangipaloke uli ha pananggap la nin Habi nin Dioh, ket tampol la yaynan tinalingkukolan ye pamteg la. ");
INSERT INTO abp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hiyay luta a antuboan nin madiwin iilamon a kinaampagan nin bibini, ket hilabay ye tataon nakange nin Habi nin Dioh. Noba uli ha malabong a babagay a ampakayootan la boy uli ha pagkapulag la ha kabatnangan, naliwaan laynay Habi nin Dioh a nange la. Kaya-bay ahe ya nakapanawa ye Habi nin Dioh ha bi-ay la. ");
INSERT INTO abp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Noba hiyay mabona a luta a kinaampagan nin bibini, ket hilabay ye tataon nakange boy nakataloh nin Habi nin Dioh. Kaya-bay nanawa ya ha bi-ay la. Main nanawan magatoh, main anemapo, boy main nanawan tatlompo.” ");
INSERT INTO abp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hiyay Apo Jesus, naghabi yayna man nin pangilalayi kanla, “Hiyay panakop nan Apo Dioh, mailalayi ya ha dinyag nin maghay tao a nanabwag nin manged a bini ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Noba ha madeglem ana, legan angkatuloy hilay tatao, nilumateng yay kaaway na. Ket hinabwagan na met nin lahi nin iilamon ye pananeman haka ya inumalih. ");
INSERT INTO abp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ha tinumubo yaynay bini boy nanawa, nakit met a main iilamon. ");
INSERT INTO abp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaya-bay nakew hilay iipoh kanan amo la. Ket magha kanla ye naghabi kana, ‘Apo, aliwa nayi a manged ye inhabwag mon bibini? Taket ta main ana met iilamon ha nananeman mo? Way-ihtew ibat ye iilamon?’ ” ");
INSERT INTO abp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nakibat yay amo kana, ‘Ah! Dapat nan kaaway ko yatew.’ ” “Haanin, nanepet hilay iipoh kana, ‘Labay mo nayi, Apo, a uloten mi yaynay iilamon?’ ” ");
INSERT INTO abp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Adey, ta no uloten yo, maka midaman yon maulot ye tidigo. ");
INSERT INTO abp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Paolayan yo po angga ha pamupol. Ket kananyatew a panaon, habiyen ko kanan māmupol, “Uloten yo po muna ye iilamon boy pethen haka yo iulam. Pangayadi, pupolen yoynay tidigo, ket ikonin yo ha kamalig ko.” ’ ” ");
INSERT INTO abp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Naghabi yayna man ye Apo Jesus nin maghay pangilalayi, “Hiyay panakop nan Apo Dioh, ket mailalayi ya ha pinakamakandin lahi' a intanem nin maghay tao ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Agya pinakamakandi yan lahi', noba no tumubo yan lumake a poon-kayo, ket paghayan yan mamanokmanok ye hahanga na.” ");
INSERT INTO abp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Magha po a pangilalayi ye hinabi nan Apo Jesus, “Hiyay panakop nan Apo Dioh, ket mailalayi ya ha makandin pamalbag a inggameh nin maghay babayi ha tatloy takal nin tapok, ta diyagen nan tinapay. Ket napalbag nan kaganaan yatew.” ");
INSERT INTO abp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pawa pangilalayi ye anggawien nan Apo Jesus ha pangiadal na kanlan tatao tungkol ha panakop nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ha wanabay a pangiadal na, natupad anay impahulat nan Apo Dioh hatew kanan podopita na, “Maghabi ko kanlan tatao makauli ha pangilalayi. Habiyen ko kanla ye babagay a nakatayo paibat po ha pinalhowa ye babe-luta.” ");
INSERT INTO abp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Haanin, hiyay Apo Jesus, nilakwanan na hilay tatao. Ket nilumoob ya ha maghay baey. Hinumaley hilay mānumbong na kana. Ket hinabi la, “Apo, habiyen mo man kammi no hinyay labay habiyen nin pangilalayi mo tungkol ha iilamon ha pananeman.” ");
INSERT INTO abp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nakibat yay Apo Jesus, “Hiyay nanabwag nin manged a bini ket hiko a ibat ha langit a in-Anak nin Tao. ");
INSERT INTO abp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hiyay pananeman ket babe-luta. Hiyay manged a bini ket hilay tataon anhakopen nan Apo Dioh. Ket hilay iilamon ket hilay tataon anhakopen nan Satanas. ");
INSERT INTO abp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hiyay kaaway a nangihabwag nin lahi iilamon ket hiyay Satanas met ateed. Hiyay labay habiyen nin pamupol ket kapopohan nin babe-luta. Hilay māmupol ket hilay aanghil. ");
INSERT INTO abp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","No way-omen lan inulot boy inulam ye iilamon, ket wanabay met ateed lano ye malyadi kanlan hakop nan Satanas ha kapopohan nin babe-luta. ");
INSERT INTO abp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ket hiko a ibat ha langit a in-Anak nin Tao, mangitubol akon aanghil ko. Ket alihen la ha panakopan ko ye kaganaan a pagkahalananan boy hilay kaganaan a ampanyag nin kalok-an. ");
INSERT INTO abp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Maitapon hila ha manliyabliyab a apoy. Ket ihtew hilaynan tumangih boy mangiinaet. ");
INSERT INTO abp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noba hilay mangatoynong, kuminlab hila a ba-mon henag nin mangaamot ha panakopan nan Bapa la a Dioh. Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Hinabi na po Apo Jesus, “Hiyay panakop nan Apo Dioh, ket mailalayi ya ha maalaga a babandi a ingkali ha luta. Ha nakali yan maghay tao, tinagpenan na yan uman. Ket angkaaliket yan nuli boy inlako nay kaganaan a babandi na. Ket hinaliw na yay luta a kinakitan nan maalaga a babandi ta-omen naya mapagkonin.” ");
INSERT INTO abp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hinabi na po Apo Jesus, “Hiyay panakop nan Apo Dioh, mailalayi ya met ha dinyag nin maghan mānaliw a ampanapul nin mablin dapah. ");
INSERT INTO abp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Haanin, ha nakatapul yan maghay mablin dapah, inlako nay kaganaan a babandi na. Ket hinaliw na yay mablin dapah.” ");
INSERT INTO abp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hinabi na po Apo Jesus, “Hiyay panakop nan Apo Dioh, ket mailalayi ha kalinah a nakakwa nin hadihadi a malanghit. ");
INSERT INTO abp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ha napno anay kalinah, ingguloy lan mānlapet ha gilid dagatdagatan. Ket nikno hila, ta payngilboen lay nakwa lan malanghit. Pinili la hilay makna, ket ingkonin la hila ha pangikunaan. Noba hilay ahe makna, ket intapon la. ");
INSERT INTO abp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wanabay met ateed ye malyadi lano ha kapopohan nin babe-luta. Lumateng hila lanoy anghil, ta ilbo la hilay matoynong a tatao kanlan mangaloke. ");
INSERT INTO abp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hilay mangaloke a tatao, ihapog la hila ha manliyabliyab a apoy. Ket ihtewbay hilan tumangih boy mangiinaet.” ");
INSERT INTO abp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hinabi nan Apo Jesus kanla, “Natalohan yo laweh ye labay habiyen nin kaganaan a hinabi kon pangilalayi?” Nakibat hila kana, “Awo Apo, natalohan mina.” ");
INSERT INTO abp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Haanin, hinabi nan Apo Jesus kanla, “Kaya-bay balang maihtodo nin Bibilin a naadalan nin tungkol ha panakop nan Apo Dioh, ket mailalayi ya ha maghay taon nagkonin nin baey a mangilwah nin bayo boy alan a babandi ha nangihinopan na.” ");
INSERT INTO abp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pangayadi nan in-adal Apo Jesus hilatin pangilalayi, inumalih yayna nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nakew ya ha Nazaret a lugal a kinalakean na. Ket nangiadal ya ha pāytiponan lan Jujudio. Ket hilay ampanlenge kana, ampagtaka hila, a wanla, “Way-ihtew nangibat ye kadunongan na boy kapalyadiyan a nanyag nin kapagtakaan? ");
INSERT INTO abp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aliwa nayi a hiyabay ye anak nan māg-alowagi boy hiyay Maria ye indo na? Aliwa nayi a hiyay Santiago, Jose, Simon, boy Judas ye kakatongno na a laki? ");
INSERT INTO abp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Boy aliwa nayi a hilay kakatongno nan babayi, ket angkumonin hila met ihti? Way-ihtew na awod nakwa ye wanabay a kadunongan boy kapalyadiyan?” ");
INSERT INTO abp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ket hilay tatao ihtew, ahe la yan biniha ye Apo Jesus. Kaya-bay hinabi nan Apo Jesus kanla, “Hiyay podopita, ambihaen laya ha agya way-ihtew man a lugal, powidan bengat ha lugal na boy papamilya na.” ");
INSERT INTO abp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ket hiyay Apo Jesus, nangaanon bengat a kapagtakaan ye dinyag na nin yatew a lugal, ta ahe hila ampamteg kana. ");
INSERT INTO abp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kananyatew a panaon, nabalitaan nan Gobilnadol Herodes Antipas ye tungkol kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kaya-bay hinabi na kanlan oopihyal na, “Hiyabay ye Juan a Māmawtihmo a nabi-ay uman! Kaya-bay ampakadyag yan kapagtakaan.” ");
INSERT INTO abp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yati ye nalyadi ha ahe ya po natey ye Juan a Māmawtihmo. Hiyay Gobilnadol Herodes Antipas, impadakep na yay Juan a Māmawtihmo haka naya impabalol boy impapidiho, ta maheheg nan anhabiyen kana, “Apo Gobilnadol, aliwan huhto ye dinyag mo, ta pinag-ahawa mo yay Herodias a ahawa nan Felipe a katongno mo.” ");
INSERT INTO abp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiyay Gobilnadol Herodes Antipas, labay naya dayin ipapatey ye Juan. Noba angkalimo ya kanlan Jujudio, ta ampamtegan la a podopita na yan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ha kompalanyoh nan Gobilnadol Herodes Antipas, tinumalek yay balatang nan Herodias ha adapan lan bibihita na. Uli ha panumalek na, naaliket yay Gobilnadol. ");
INSERT INTO abp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kaya-bay impangako na boy nanumpa ya po, a wana, “Hinyaman a awoken mo, ket ibyay ko kammo.” ");
INSERT INTO abp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uli ha hinabi nan Gobilnadol Herodes Antipas, nakew yay balatang kanan indo na. Ket tinepet naya no hinyay awoken na. Ket hinabi na kanan balatang, “Hiyay ō nan Juan a Māmawtihmo ye labay kon ibyay mo kangko a naikonin ha bandihado.” Kaya-bay nag-udong ya kanan Gobilnadol Herodes Antipas. Ket hinabi na yatew. ");
INSERT INTO abp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pamakange nan Gobilnadol Herodes Antipas, nalele ya. Noba ulita nagpangako ya ha adapan lan bibihita na, inawo nay awok nan balatang. ");
INSERT INTO abp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ket haanin, hiyay Gobilnadol Herodes Antipas, nangitubol yan mamutoh nin leey nan Juan a anti ha pidihowan. ");
INSERT INTO abp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ket ingkonin layna ha bandihado. Pangayadi, inggawang naya kanan balatang. Ket hiyay balatang, inggawang naya met kanan indo na. ");
INSERT INTO abp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Haanin, hilay mānumbong nan Juan, kingwa lay bangkay na boy in-ilbeng laya. Pangayadi, imbalita la kanan Apo Jesus ye nalyadi kanan Juan. ");
INSERT INTO abp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pamakange nan Apo Jesus ye nalyadi kanan Juan, inumalih ya ihtew. Nilumugan ya ha bangka. Ket nakew ya wangwang. Noba ha natandaan lan tatao ha babanwa a inumalih yay Apo Jesus, kinumodang hilan hinumumbong kana. ");
INSERT INTO abp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ha nilumumbah yay Apo Jesus ha bangka, nakit na hilay malabong a tatao. Ket nalunoh ya kanla. Ket hilay ampaghakit, pinaitaah na hila. ");
INSERT INTO abp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ha andudumeglem ana, hilay mānumbong na, hinumaley hila kana. Ket hinabi la, “Apo, anti kitawo ha wangwang boy andudumeglem ana. Kaya-bay Apo, habiyen moyna kanlan tatao a makew hilayna ha babadiyo ta-omen hila po makahaliw nin pamangan la.” ");
INSERT INTO abp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Noba hinabi nan Apo Jesus kanla, “Ahe hilayna katapulan a makew. Hikawoy mamyay nin pamangan la.” ");
INSERT INTO abp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nakibat hila kanan Apo Jesus, “Yo! Limay tinapay boy luway malanghit bengat ye anti ihti.” ");
INSERT INTO abp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hinabi nan Apo Jesus kanla, “Igawang yo kangko.” ");
INSERT INTO abp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Haanin, pinaikno na hilay tatao ha kailamonan. Pangayadi, kingwa nay limay tinapay boy luway malanghit. Tinumangal ya ha langit. Ket pinahalamatan naya kanan Apo Dioh. Binih-ilbih-il na yay tinapay boy pinutoh-putoh na yay malanghit. Ket in-ibyay na kanlan mānumbong na. Ket impatped la met kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangan hilan kaganaan boy nangabhoy. Pangayadi lan nangan, hilay mānumbong na, tinipon lay tela lan tatao. Ket nakapno hila po nin labinluwan belyag. ");
INSERT INTO abp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hiyay bilang nin lalakin nangan, mangalimay libo, powida hila po ye babayi boy aanak. ");
INSERT INTO abp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Legan ampaulien na hilan Apo Jesus ye tatao, pinalugan na hilaynay mānumbong na ha bangka. Ket pinauna na hilaynan lumipay ha dagatdagatan. ");
INSERT INTO abp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ket ha nakaalih hilaynay tatao, hinumaka yan bubukod na ye Apo Jesus ha mapantay ta-omen ya makigwang. Ket nadegleman ya ihtew. ");
INSERT INTO abp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Haanin, hiyay bangka a anluganan lan mānumbong na, ket anti yayna ha bunak nin dagatdagatan a ampihahanggiyap, ta angkadupag hilan angin boy mangakhaw a dawyon. ");
INSERT INTO abp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ha palbangon ana, kinumodang yay Apo Jesus ha babe lanom palakew kanla. ");
INSERT INTO abp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ha natamulaw la a main angkumodang ha babe lanom, nalimowan hilan tubat. Ket kinumolih hila, a wanla, “Anito!” ");
INSERT INTO abp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Noba hinabi nan tampol Apo Jesus kanla, “Adi kawo angkalimo, ta hiko yati! Pakatana kawon bengat!” ");
INSERT INTO abp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Haanin, nakibat yay Pedro, “Apo! No peteg a hika yain, palakwen moko man awod ihen a kumodang ha babe lanom!” ");
INSERT INTO abp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nakibat yay Apo Jesus kanan Pedro, “Awo, makew ka ihti.” Nilumumbah yay Pedro ha bangka. Ket kinumodang yan peteg ha babe lanom palakew kana. ");
INSERT INTO abp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Noba ha natanam nan Pedro ye makhaw a angin, nalimowan ya. Ket anlumdeg yayna. Kaya-bay impangha nay, “Apo! Apo! Iligtah moko!” ");
INSERT INTO abp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hiyay Apo Jesus, tampol na yan ginawang boy hinabi na kana, “Koynan kakandi ye pamteg mo! Taket ta ampagluwaluwa ka?” ");
INSERT INTO abp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Haanin, ha nakalampat hilayna ha bangka, tinumgen anay makhaw a angin. ");
INSERT INTO abp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hilay mānumbong na a anti ha bangka, ha nakit laynan tinumgen ye makhaw a dawyon boy angin, ket inggalang laya, a wanla, “Apo, hikan peteg ye Anak nin Dioh!” ");
INSERT INTO abp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Haanin, ha nakalipay hilayna ha dagatdagatan, nilumateng hila ha Genesaret. ");
INSERT INTO abp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hilay tatao ihtew, ha nabalayan la yay Apo Jesus, ket tampol hilan nangitubol nin mangibalita kanlan tatao ha palibot nin yatew a lugal. Ket hilay ampaghakit, inlakew la hila kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Impakiiingalo la kana a no malyadi, agya makiwit lan bengat ampaghakit ye laylay nin bado na. Ket hilay kaganaan a nangiwit, nitaah hila. ");
INSERT INTO abp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Haanin, main nangaanon Papariseo boy mamaihtodo nin Bibilin a ibat ha banwan Jerusalem ye nakew kanan Apo Jesus. Ket tinepet laya, ");
INSERT INTO abp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Taket ta ahe la anhumbongen nin mānumbong mo ye kaugalian lan tutoa tawo tungkol ha pag-ibano bayo mangan?” ");
INSERT INTO abp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nakibat yay Apo Jesus kanla, “Ket hikawo met lagi, taket ta anlabagen yoy Bibilin nan Apo Dioh ta-omen yon bengat mahumbong ye naiknaan yon kaugalian lan tutoa yo? ");
INSERT INTO abp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Alimbawa, imbilin nan Apo Dioh, ‘Bihaen moy bapa mo boy indo mo’ boy imbilin na po, ‘Ayaman a maghabin maloke kanlan tutoa na, ket hukat a pateyen.’ ");
INSERT INTO abp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Noba lumbo ya met ye an-iadal yo kanlan tatao, ta anhabiyen yo a malyadi yon habiyen kanlan tutoa yo, ‘Hikawon tutoa ko, biyan katawo dayin pilak, noba ibyay ko tana kanan Apo Dioh.’ ");
INSERT INTO abp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ulin yain, an-iadal yoyna met a ahe layna bihaen ye tutoa la. Ha wanabay, andiyagen yon homain hilbi ye Bibilin nan Apo Dioh uli ha panumbong yo ha kaugalian lan tutoa yo. ");
INSERT INTO abp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hikawon ampagmamangedan! Petegbay ye impahulat nan Apo Dioh kanan podopita Isaias hatew a tungkol kanyo, ");
INSERT INTO abp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hilatin tatao, anggalangen lako ha habi bengat, noba mataang ya met ye puho la kangko. ");
INSERT INTO abp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Homain hilbi ye panggalang la kangko, ta hiyay an-iadal la ket bibilin bengat nin tao.’ ” ");
INSERT INTO abp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Haanin, hiyay Apo Jesus, hinagyat na hilay tataon humaley kana. Ket hinabi na, “Leng-en yoko boy ihipen yon manged ye habiyen ko. ");
INSERT INTO abp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aliwan hiyay an-ipahlep nin tao ha bebey na ye ampakapadinat kana, no aliwan hiyay habi a anlumwah ha bebey na.” ");
INSERT INTO abp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Haanin, hilay mānumbong na, hinumaley hila kana. Ket hinabi la, “Apo, ahe mo nayi tanda a nahakitan hilay Papariseo ha hinabi mo?” ");
INSERT INTO abp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Noba nakibat yay Apo Jesus kanla, “Hinyaman a tanaman a ahe na intanem nin Bapa ko a anti ha langit, ket maulot ya. ");
INSERT INTO abp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paolayan yo hila, ta ba-mo hilan kapkap a ampangakay nin kapadiho lan kapkap. Ha wanabay, padiho hilan maampag ha lubot.” ");
INSERT INTO abp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Haanin, hinabi nan Pedro, “Apo, habiyen mo man kammi no hinyay labay habiyen nin yain a pangilalayi mo.” ");
INSERT INTO abp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hinabi nan Apo Jesus kanla, “Agya hikawo nayi, ahe kawo ampakataloh? ");
INSERT INTO abp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ahe yo nayi tanda a agya hinyaman a an-ipahlep ha bebey, ket ampilaloh ya ha bitoka, ket mailwah ya met ateed? ");
INSERT INTO abp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Noba hiyay habi a anlumwah ha bebey nin tao, ket ibat ya ha puho. Ket yati ye ampakapadinat kana, ");
INSERT INTO abp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ta ibat ha puho na ye mangaloke a ihip. Ket yatin mangaloke a ihip ye ampangitudon kana a mamatey, makilaki o mamabayi, mandamog, manakaw, manago, boy mandama nin kanayon. ");
INSERT INTO abp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hilayati ye ampakadinat, noba hiyay mangan a ahe mag-ibano, ket aliwa yain ye ampakapadinat ha tao.” ");
INSERT INTO abp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Haanin, hiyay Apo Jesus, inumalih ya nin yatew a lugal. Ket nakew ya ha lulugal a mahaley ha banwan Tiro boy Sidon. ");
INSERT INTO abp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Main babayin Cananea a angkumonin ihtew ye nakew nakiingalo kana, a wana, “Apo a Lahi nan Poon David, ingalowan moko! Ta hiyay anak kon babayi, ket hinelpan yan maloke a ihpidito boy angkaidapan yan tubat.” ");
INSERT INTO abp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Noba ahe naya pinakibatan Apo Jesus. Haanin, hinumaley hilay mānumbong na. Ket hinabi la kana, “Apo, paalihen mo yayna yain a babayi, ta pihuhumbong na kitawo boy mahneg ya.” ");
INSERT INTO abp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Haanin, hinabi nan Apo Jesus kanan babayi, “Naitubol ako ihti ulin bengat kanlan Israelita a ba-mon tutupa a nangaipakat.” ");
INSERT INTO abp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Noba hiyay babayi, hinumaley yan nanalimukod kanan Apo Jesus, a wana, “Apo, haglapan moko dayi!” ");
INSERT INTO abp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Noba hinabi nan Apo Jesus kana makauli ha kahabiyan, “Aliwan huhto a kowen ye pamangan lan aanak haka ipakan ha aaho.” ");
INSERT INTO abp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hinabi na met babayi kanan Apo Jesus, “Awo, peteg yain, Apo. Noba hilay aaho, angkanen la met ye mumom angkaampag a ibat ha lamihaan nin amo la.” ");
INSERT INTO abp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Haanin, hinabi nan Apo Jesus, “Koynan kayadet ye pamteg mo! Mapalyadi ye an-awoken mo.” Ket kananyatew met ateed, nitaah yay anak na. ");
INSERT INTO abp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Haanin, hiyay Apo Jesus, inumalih ya nin yatew a lugal. Ket nakew ya ha ambay dagatdagatan nin Galilea boy hinumaka ya ha mapantay. Ket nikno ya ihtew. ");
INSERT INTO abp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Malabong hilay tataon nangilakew kana nin pipilay, kakapkap, lulumpo, angang boy malabong po a ampaghakit. Inhaley la hila ha aphayan nan Apo Jesus, ket pinaitaah na hila met. ");
INSERT INTO abp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ha nakit lan tatao a ampakahabi hilaynay angang, ampakakodang hilaynay pipilay boy lulumpo, boy ampakakit hilaynay kakapkap, nagtaka hilan tubat. Kaya-bay inggalang la yay Dioh lan Israelita. ");
INSERT INTO abp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Haanin, hiyay Apo Jesus, pinahaley na hilay mānumbong na boy hinabi na kanla, “Angkalunoh akon tubat kanlan hilatin tatao, ta tatloynan mangaamot a kalamo tawo hila, ket haanin, homain hilaynan pamangan. Ahe ko hila malyadin paulien a angkabitil, ta maka mawe hila ha dān.” ");
INSERT INTO abp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hinabi lan mānumbong na kana, “Apo, way-ihtew kitawo nayi mangwa nin pamangan ihti ha wangwang a mignap kanlan hilatin kalabong a tatao?” ");
INSERT INTO abp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tinepet na hilan Apo Jesus, “Anoy tinapay ye anti kanyo?” “Pito,” wanla, “boy main met nangaanon mangakandin malanghit.” ");
INSERT INTO abp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Haanin, hiyay Apo Jesus, pinaikno na hilay tatao ha luta. ");
INSERT INTO abp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ha nakaikno hilayna, kingwa nay pitoy tinapay boy nangaanon malanghit haka naya pinahalamatan kanan Apo Dioh. Pangayadi, binih-ilbih-il naya haka na in-ibyay kanlan mānumbong na ta-omen la ipatped kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Haanin, nangan hilan kaganaan boy nangabhoy. Pangayadi lan nangan, hilay mānumbong na, tinipon lay tela lan tatao. Ket nakapno hila po nin piton belyag. ");
INSERT INTO abp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hiyay bilang nin lakin nangan, mangaapat a libo, powida hila po ye babayi boy aanak. ");
INSERT INTO abp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ha napauli na hilaynan Apo Jesus ye tatao, nilumugan yayna met ha bangka boy nakew ya ha lugal a Magadan. ");
INSERT INTO abp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ha maghay mangaamot, main Papariseo boy Sasaduseo ye nakew kanan Apo Jesus ta-omen laya huboken. Ket nakikwa hilan kapagtakaan kana bilang pagkakitan a hiyabay ye intubol nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Noba hinabi nan Apo Jesus kanla, “No ampitanghob yayna ye mangaamot boy makit yo a matibya ye luwang, anhabiyen yon ‘Manged ye panaon mabekah.’ ");
INSERT INTO abp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Boy no mahanib ket makit yon matibya boy maowep ye lowang, anhabiyen yon ‘Mangudan ya haanin.’ Tanda yon italohan ye angkakit yo ha lowang. Noba ahe yo met tanda a italohan ye pagkakitan a andiyagen nan Apo Dioh makauli kangko kananyatin panaon? ");
INSERT INTO abp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hikawon tatao kananyatin panaon, tubat ye kalok-an yo boy ahe na kawo mapatayaan Apo Dioh. Ampakikwa kawon kapagtakaan bilang pagkakitan a hiko ye intubol nan Apo Dioh. Noba homain akon ipakit kanyo, no aliwan hiyay kapagtakaan a omen ha nalyadi kanan podopitan Jonas hatew.” Pangayadi nan hinabi yatew, nilakwanan na hilayna. ");
INSERT INTO abp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ha nakalipay hilayna ha dagatdagatan, natandaan lan mānumbong a naliwaan lay nagbawon nin tinapay. ");
INSERT INTO abp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Haanin, hinabi nan Apo Jesus kanla, “Mag-alla kawo ha pamalbag lan Papariseo boy Sasaduseo.” ");
INSERT INTO abp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pamakange lan mānumbong na, hinabi la ha magha boy magha, “Hinabi na yatew, ta naliwaan tawon nagbawon nin tinapay.” ");
INSERT INTO abp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Noba tanda nan Apo Jesus ye ampaytongtongan la. Kaya-bay tinepet na hila, “Taket ta ampaytongtongan yoy ahe yo pagbawon nin tinapay? Kakandi ye pamteg yo! ");
INSERT INTO abp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ahe kawo po nayi ampakataloh? Naliwaan yoyna nayi ye pamih-ilbih-il ko nin limay tinapay a impakan ha limay libo katao, ket nangabhoy hila? Anoy belyag ye natipon yon tela lan tatao? ");
INSERT INTO abp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wanabay met ateed ha pitoy tinapay a impakan ha apat a libo katao. Anoy belyag ye natipon yon tela lan tatao? ");
INSERT INTO abp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taket ta ahe yo po angkatalohan a aliwan tinapay ye labay kon habiyen ha hinabi ko a mag-alla kawo ha pamalbag lan Papariseo boy Sasaduseo?” ");
INSERT INTO abp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ket kananyatew la po bengat natalohan a aliwa manaytin pamalbag ha tinapay ye labay nan habiyen Apo Jesus a pag-allaan la, no aliwan hiyay aadal lan Papariseo boy Sasaduseo. ");
INSERT INTO abp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ha niabot hilaynan Apo Jesus boy mānumbong na ha haley nin banwan Cesarea Filipos, tinepet na hilay mānumbong na, “Ha ihip lan tatao, aya ko kano a ibat ha langit a in-Anak nin Tao?” ");
INSERT INTO abp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nakibat hila, “Anhabiyen lan kanayon a hika ye Juan a Māmawtihmo. Hilay kanayon met, anhabiyen la a hika ye podopitan Elias. Ket hilay kanayon po, anhabiyen la met a hika ye podopitan Jeremias o magha ka kanlan popodopita.” ");
INSERT INTO abp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tinepet na hilay mānumbong na, “Hikawo nayi, aya ko?” ");
INSERT INTO abp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nakibat yay Simon Pedro, “Hika ye Cristo a Anak nan Apo Dioh a angkabi-ay.” ");
INSERT INTO abp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hinabi nan Apo Jesus kanan Simon, “Minged ka, Simon a anak nan Jonas! Ta aliwan tao ye nangipatanda kammo yati, no aliwan hiyay Bapa kon Dioh ha langit. ");
INSERT INTO abp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ket haanin, hika ye Pedro boy kananyatin dapah, ipaideng koy pangkat lan māmteg ko a ahe mahambot, agya po man kapalyadiyan nin kamateyan. ");
INSERT INTO abp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ibyay ko kammo ye kapalyadiyan ha panakopan ha langit a omen ha tulbek a malyadin panleneb boy panlukat. Hinyaman a ibawal mo ihti ha babe-luta, ket ibawal na met Apo Dioh ha langit. Boy hinyaman a ipaluboh mo ihti ha babe-luta, ket ipaluboh na met Apo Dioh ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pangayadi, mahehpet na hilan binilinan Apo Jesus ye mānumbong na, “Adi yo anhabiyen ha agya ayaman a hiko ye Cristo a impangako nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Paibat kananyatew, impatanda naynan Apo Jesus kanlan mānumbong na, “Katapulan akon makew ha banwan Jerusalem. Ket ihtew akon magdiha nin tubat a pamaidap lan tutoan Jujudio a mānungkolan, mānguna a papadi boy mamaihtodo nin Bibilin. Ipapatey lako, noba mabi-ay akon uman ha ikatlon mangaamot.” ");
INSERT INTO abp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pamakange nan Pedro yatew, intaang na yan makandi ye Apo Jesus haka na yan pinaghabiyan, “Ahe na dayin ipaluboh Apo Dioh yatew! Ahe malyadi yain kammo, Apo.” ");
INSERT INTO abp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Haanin, hiyay Apo Jesus, inadap na yay Pedro. Ket hinabi na kana, “Pakataang ka kangko, Satanas. Ta anhaaden moy panumbong ko ha kalabayan nin Dioh. Hiyay an-ihipen mo, aliwan kalabayan nin Dioh, no aliwan ihip bengat nin tao.” ");
INSERT INTO abp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Ayaman a malabay manumbong kangko, ket katapulan a liwaan nay hadili nan kalabayan boy maghadya yan matey ha panumbong na kangko a ba-mo yan ampamatay nin kodoh. ");
INSERT INTO abp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta ayaman a ampangihilib nin bi-ay na, maanam na. Noba ayaman a matey uli kangko, ket mabyayan yan bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Agya mapagkonin nin maghay tao ye kaganaan a babandi ihti ha babe-luta, no mipalakew ya met ha kapaduhaan a homain anggaan ye kalelwa na, main ya nayi pakinabang kana ye babandi na? Main nayi malyadin pamayad ye tao ta-omen ya mabyayan nin bi-ay a homain anggaan? ");
INSERT INTO abp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta hiko a ibat ha langit a in-Anak nin Tao ket mag-udong a main kapalyadiyan nan Bapa kon Dioh, lamo ko hilay aanghil na. Ket kananyatew a mangaamot, ibyay ko ye kaeteban nin didiyag nin balang magha. ");
INSERT INTO abp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pakaleng-en yon manged ye habiyen ko. Main nangaano kanyo ihti ye ahe po matey anggan makit la ye panlumateng kon ibat ha langit a in-Anak nin Tao bilang Poon.” ");
INSERT INTO abp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pangalabah nin anem a mangaamot, hiyay Apo Jesus, inlamo na yay Pedro boy hilay mikatongno a Santiago boy Juan ha matagay a mapantay a hilahilan bengat. ");
INSERT INTO abp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ket legan anti hila ihtew, nakit la a nauman ye kadih nan Apo Jesus. Hinumnag ye lupa na a omen ha mangaamot boy hiyay bado na, ampakapulag a ba-mon henag. ");
INSERT INTO abp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kapipikhaan, nakit la yay Moises boy Elias a ampakitongtong kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Haanin, hinabi nan Pedro kanan Apo Jesus, “Apo, manged, ta anti kitawo ihti. No labay mo, manyag akon tatlon hongab ihti. Hiyay maghan hongab, kammo. Hiyay ikalwa, kanan Moises. Boy hiyay ikatlo, kanan Elias.” ");
INSERT INTO abp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Legan ampaghabi ya po ye Pedro, inameyan hilan ampakapulag a owep boy main hilan nange a bihnga ha owep a ampaghabin wanae, “Yabayti ye ampakaadoen kon Anak a luboh kon angkaaliketan. Leng-en yoy habiyen na!” ");
INSERT INTO abp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ha nange lan mānumbong na ye bihnga, nalimowan hilan tubat. Ket nilumukob hila ha luta. ");
INSERT INTO abp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Noba hinumaley yay Apo Jesus kanla. Ket dinapikpik na hila, a wana, “Mideng kawo! Adi kawo angkalimo.” ");
INSERT INTO abp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ha namilew hilayna, homain hilaynan nakit a kanayon, no aliwan hiyay Apo Jesus anan bengat. ");
INSERT INTO abp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ha anlumohan hilayna ha mapantay, binilinan na hilan Apo Jesus, a wana, “Adi yo anhabiyen ha agya ayaman ye nakit yo anggan hiko a ibat ha langit a in-Anak nin Tao, ket mabi-ay uman.” ");
INSERT INTO abp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Haanin, hilay mānumbong na, tinepet la yay Apo Jesus, “Taket ta anhabiyen lan mamaihtodo nin Bibilin a hiyay Elias a podopita hatew, ket katapulan a muna yan lumateng kanan Cristo?” ");
INSERT INTO abp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nakibat yay Apo Jesus kanla, “Peteg yain. Katapulan a muna ya po lumateng ye Elias ta-omen na italadan ye kaganaan. ");
INSERT INTO abp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noba leng-en yoy habiyen ko. Nilumateng yaynay Elias, noba ahe la yan nabalayan nin tatao. Ket dinyag lay labay lan diyagen kana. Wanabay met ateed ye malyadi kangkon ibat ha langit a in-Anak nin Tao, ta paidapan lako met lano.” ");
INSERT INTO abp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ket natalohan lan mānumbong na a hiyay Juan a Māmawtihmo ye andektan na. ");
INSERT INTO abp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ha nag-udong hilaynan Apo Jesus ihtew kanlan tatao, main maghay lakin hinumaley a nanalimukod ha adapan na, a wana, ");
INSERT INTO abp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, ingalowan mo yay anak kon laki, ta ampamaktong ya. Ket angkaidapan yan tubat. Maheheg yan ampihapog ha apoy boy angkapuang ha lanom. ");
INSERT INTO abp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inlakew ko yayna kanlan mānumbong mo, noba ahe la yan napaitaah.” ");
INSERT INTO abp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Haanin, hinabi nan Apo Jesus, “Hikawon tatao haanin a panaon, homain kawon pamteg kanan Apo Dioh boy matiko ye ihip yo. Anggan makano katawo po lagin pag-anohan? Ilakew yoya ihti ye anak.” ");
INSERT INTO abp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Haanin, hiyay Apo Jesus, pinaghabiyan na yay maloke a ihpidito. Ket kananyatew met ateed, inalihan na yan maloke a ihpidito ye anak. Ket nitaah yayna. ");
INSERT INTO abp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ha hilahilaynan bengat, hinumaley hilay mānumbong na kana. Ket tinepet laya, “Taket ta ahe miya napaalih ye maloke a ihpidito kanan anak?” ");
INSERT INTO abp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nakibat yay Apo Jesus kanla, “Ulita kulang ye pamteg yo! Pakaleng-en yon manged ye habiyen ko. No main kawon pamteg, agya bengat omen ha lahi muhtaha kakandi, malyadi yon habiyen kananyatin mapantay, ‘Makew ka ihtew’, ket makew ya. Homain babagay a ahe yo madyag. ");
INSERT INTO abp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Noba yatin kalahin maloke a ihpidito, mapaalih yo yan bengat makauli ha pamakigwang boy pagpaltan mangan.” ");
INSERT INTO abp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Haanin, ha ampaytipon hilay mānumbong na boy Apo Jesus ha Galilea, hinabi na kanla, “Hiko a ibat ha langit a in-Anak nin Tao, ket maigawang lano kanlan mānungkolan. ");
INSERT INTO abp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pateyen lako, noba ha ikatlon mangaamot, mabi-ay akon uman.” Haanin, uli ha hinabi na, nilumele hilan tubat ye mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ha niabot yaynay Apo Jesus boy hilay mānumbong na ha banwan Capernaum, hilay māningil nin bowih ha Timplo, ket nakew hilan nanepet kanan Pedro, “Hiyay maihtodo yo, ampamayad ya nayi nin bowih ha Timplo?” ");
INSERT INTO abp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nakibat yay Pedro, “Awo, ampamayad ya.” Haanin, ha nag-udong yaynay Pedro ha baey a ampagdagohan la, tinepet na yan Apo Jesus, “Pedro, ha ihip mo, aya hilay ampamayad nin bowih kanlan popoon? Hilay aanak la o hilay dadayohan?” ");
INSERT INTO abp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nakibat yay Pedro, “Hilay dadayohan, Apo.” Ket hinabi nan Apo Jesus kana, “No wanabay awod, aliwan aanak lan poon ye mamayad nin bowih. ");
INSERT INTO abp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Noba agya wanabay man, kokaynan mamaniwit ha dagatdagatan. Ket hiyay una mon makwan malanghit, bengaen moy bebey na. Ket main kan makit a palata a mignap a bowih tan luwa. Kowen moya, ket ibayad mo kanlan māningil nin bowih ha Timplo ta-omen la kitawo ahe pag-inakitan.” ");
INSERT INTO abp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kananyatew a odah, hinumaley hilay mānumbong nan Apo Jesus kana. Ket tinepet laya, “Apo, ayay pinakamatagay kanlan anhakopen nan Apo Dioh?” ");
INSERT INTO abp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Haanin, hiyay Apo Jesus, nanagyat yan maghay anak. Ket pinaideng naya ha adapan lan mānumbong na haka na hinabi, ");
INSERT INTO abp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Pakaleng-en yon manged ye habiyen ko. No ahe yo umanen ye pangugali yo a omen ha pangugali nin makandin anak a mapagmakaaypa, ahe kawo maibilang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaya-bay ayaman a ampagmakaaypa nin omen kananyatin anak, ket hiya ye pinakamatagay kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ket ayaman a ampananggap nin omen kananyatin anak uli ha panumbong na kangko, ket hikoynay antanggapen na.” ");
INSERT INTO abp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Noba ayaman a manyag nin pagkahalananan lan hilatin aanak a ampamteg kangko, ket mamanged po a bitinan yan mayadet a gilingan a dapah ye leey na haka ya iampag ha bunak nin dagat.” ");
INSERT INTO abp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kakaingalo hilay tatao ihti ha babe-luta, ta malabong a tukho ye pagkahalananan la. Katapulan a lumateng hilayatin pagkahalananan, noba kakaingalo ye malyadi ha taon ampanyag nin pagkahalananan nin kapadiho nan tao.” ");
INSERT INTO abp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“No hiyay maghay gamet mo o bitih mo ye pagkahalananan mo, putohen mo tanan itapon. Mamanged po a mamaghay gamet mo o bitih mo, noba mabyayan kan bi-ay a homain anggaan dinan ha luway gamet mo o bitih mo, noba mipalakew ka met ha apoy a ahe angkalep. ");
INSERT INTO abp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No hiyay maghay mata mo ye hangkan nin pagkahalananan mo, luowen moyna ingat haka itapon. Mamanged po a mamaghay mata mo, noba mabyayan kan bi-ay a homain anggaan dinan ha luway mata mo, noba maihapog ka met ha impilno.” ");
INSERT INTO abp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Pakahigudowen yon adi yo anyamo-yamoen ye agya magha man kanlan hilain a aanak. Pakaleng-en yon manged yatin habiyen ko. Hilay aanghil a ampagbantay kanla, ket anti hilan anti ha adapan nan Bapa kon Dioh ha langit. ");
INSERT INTO abp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ta hiko a ibat ha langit a in-Anak nin Tao, nakew ako ihti ha babe-luta ta-omen ko hila tapulen boy iligtah ye tataon nipakat.” ");
INSERT INTO abp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ha ihip yo, hinyay diyagen nin taon main magatoh a tupa, no mipakat yay magha? Yo! Ket katapulan pa a lakwanan na hilay hiyamapo boy hiyam ha nagmamapantay, ta tapulen na yay maghay tupa a nipakat? ");
INSERT INTO abp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pakaleng-en yon manged ye habiyen ko. No makitan na yay nipakat a tupa, ket maaaliket ya po ha magha dinan kanlan hiyamapo boy hiyam a ahe nipakat. ");
INSERT INTO abp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wanabay met ateed ye tanam nan Bapa yon Dioh ha langit, ta ahe na labay a mipakat ye agya magha kanlan hilain a aanak.” ");
INSERT INTO abp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“No magkahalanan ya kammo ye katongno mo kanan Apo, lakwen mo yan bubukod na, ta ipalinaw mo kana ye dinyag na a kahalanan. No leng-en naka, maiudong ye alan yon paymamagha bilang mikatongno ha pamteg. ");
INSERT INTO abp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Noba no ahe naka leng-en, managyat kan magha o luwa a katongno mo ha pamteg ta-omen ‘paptegan nin luwa o tatloy tihtigo ye kaganaan a paytongtongan yo.’ ");
INSERT INTO abp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ket no adi yan teed manlenge, ipatanda mo yayna ha pangkat lan māmteg nan Apo Jesus. No ahe ya po ateed manlenge kanlan kakatongno ha pamteg, ibilang mo yaynan ahe ampamteg kanan Apo Dioh o maghan makuhit a māningil nin bowih.” ");
INSERT INTO abp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Pakaleng-en yon manged ye habiyen ko. Hinyaman a ibawal yo ihti ha babe-luta, ket ibawal na met nin Apo Dioh ha langit. Boy hinyaman a ipaluboh yo ihti ha babe-luta, ket ipaluboh na met ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Pakaleng-en yon manged ye habiyen ko a no mapaykahundoan nin luwa kanyo ye hinyaman a ipakigwang yon awoken, ket ibyay na kanyon Bapa kon Dioh a anti ha langit. ");
INSERT INTO abp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta no main luwa o tatlo kataon ampaytipon uli kangko, ket anti ko met kanla.” ");
INSERT INTO abp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Haanin, hinumaley yay Pedro kanan Apo Jesus. Ket tinepet naya, “Apo, mikano koya nayi patawaden ye katongno kon maheheg a ampagkahalanan kangko? Mikapito nayi a ukdo?” ");
INSERT INTO abp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nakibat yay Apo Jesus kanan Pedro, “Aliwan bengat mikapito, no aliwan pitompo boy piton ukdo. ");
INSERT INTO abp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ta hiyay panakop nan Apo Dioh, ket mailalayi ya ha panakop nin maghay poon a namadakit kanlan iipoh na, ta hingilen na hilayna ha uutang la. ");
INSERT INTO abp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ha ikana nayna ye maningil, in-adap la yayna kana ye maghay ipoh a nakautang nin milyon-milyon kana. ");
INSERT INTO abp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ulita ahe ya makabayad, hinabi nan poon, ‘Ilako yo hilan mitapamilya boy hiyay kabandiyan na ta-omen ya makabayad nin inutang na.’ ” ");
INSERT INTO abp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Haanin, hiyay ipoh, nanalimukod yan nakiiingalo kanan poon, ‘Apo, pangiingalo mo. Biyan moko po dayin makandin panaon ta-omen ako makabayad ha kaganaan a utang ko.’ ");
INSERT INTO abp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Haanin, hiyay poon, ket kinalunohan naya. Kaya-bay ahe na yayna pinabayadan ye utang na. Ket pinauli na yayna.” ");
INSERT INTO abp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Noba ha ampuli yaynay ipoh, nahagana na yay maghay ipoh a nakautang kana nin makandin alaga. Ket hiyay dinyag na kana, dinakep na yan binikke. Ket hinabi na, ‘Bayadan moynay utang mo kangko!’ ” ");
INSERT INTO abp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Haanin, nanalimukod yan nakiiingalo kana ye kapadiho nan ipoh a nakautang kana, ‘Pangiingalo mo. Biyan moko po dayin makandin panaon ta-omen ako makabayad ha kaganaan a utang ko kammo.’ ");
INSERT INTO abp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Noba ahe naya kinalunohan, no aliwan impapidiho naya anggan mabayadan nay utang na.” ");
INSERT INTO abp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Haanin, hilay kanayon a iipoh a nakakit ha nalyadi, nalele hila. Kaya-bay nakew hila kanan poon. Ket hinabi lay kaganaan a nalyadi.” ");
INSERT INTO abp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Haanin, hiyay poon, impadakit na yain a ipoh. Ket hinabi na, ‘Maloke kan tubat a ipoh! Ahe koynabay pinabayadan ye utang mo ulita nakiiingalo ka kangko. ");
INSERT INTO abp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Taket ta ahe moya met iningalowan ye kapadiho mon ipoh a omen ha pangingalo ko kammo?’ ");
INSERT INTO abp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uli ha tubat a poot nan poon, ket impapidiho naya angga ha mabayadan nay kaganaan a utang na.” ");
INSERT INTO abp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Haanin, hinabi nan Apo Jesus, “No ahe yo yan luboh patawaden ye kapadiho yo, wanabay met ateed ye diyagen na kanyon Bapa kon Dioh a anti ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pangayadi nan in-adal Apo Jesus yatew a babagay, inumalih ya ha plobinhiyan Galilea. Ket nakew ya ha plobinhiyan Judea ha lipay nin kabatowan Jordan. ");
INSERT INTO abp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Malabong hilay tataon hinumumbong kana. Ket pinaitaah na hilay ampaghakit. ");
INSERT INTO abp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Haanin, nilumateng hilay nangaanon Papariseo. Ket hinumaley hila kanan Apo Jesus, ta huboken laya. Kaya-bay tinepet laya, “An-ipaluboh nayi nin Bibilin a ihyay nin laki ye ahawa na ha agya hinyaman a hangkan?” ");
INSERT INTO abp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nakibat yay Apo Jesus kanla, “Ahe yo po nayi nabaha ye anti ha naihulat a Habi nin Dioh a ha pamalhowa nan babe-luta, ket pinalhowa na ye laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Boy naihulat met, ‘Kaya-bay lakwanan nan laki ye bapa boy indo na ta-omen hilayna mapaylamo a miahawa. Ket mag-ilyadi hilaynan mamaghan laman.’ ");
INSERT INTO abp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ha wanabay, aliwa hilaynan luwa, no aliwan mamagha. Kaya-bay hiyay pinaylamo nan Apo Dioh, ket aliwan hukat payngihyayen nin tao.” ");
INSERT INTO abp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Haanin, nanepet hilayna man ye Papariseo kanan Apo Jesus, a wanla, “No wanabay awod, taket ta hinabi nan Moises hatew a malyadi na yan ihyay nin laki ye ahawa na, no biyan na yan kahulatan nin payngihyay?” ");
INSERT INTO abp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nakibat yay Apo Jesus kanla, “Uli ha kabyangan nin ō yo, impaluboh nan Moises a ihyay nan laki ye ahawa na. Noba ha pinalhowa nan Apo Dioh ye laki boy babayi, aliwan wanabay ye labay nan malyadi. ");
INSERT INTO abp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kaya-bay pakaleng-en yon manged ye habiyen ko. Ayaman a lakin mangihyay nin ahawa na, ket mangahawa yan lumbo, magkahalanan yan pamabayi, powidan bengat no nakilaki ye ahawa na. Ket ayaman a mangahawa met kanan babayin in-ihyay na, magkahalanan yayna met nin pamabayi.” ");
INSERT INTO abp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Haanin, hinabi lan mānumbong nan Apo Jesus, “Ah, no wanabay ye tungkol ha main ahawa, mamanged po a ahe ana mangahawa.” ");
INSERT INTO abp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nakibat yay Apo Jesus, “Aliwan kaganaan a tatao ket mababa lan tanggapen yain, no aliwan hilay tataon bengat a intaladan nin Dioh a ahe mangahawa. ");
INSERT INTO abp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Main nakahinadi a hahangkan no taket ta ahe hila nangahawa ye nangaanon tatao. Hilay kanayon, in-anak hilaynan kulang ye hangkap la. Hilay kanayon met, tinatala lay nagpakapon. Hilay kanayon po, ahe nakiahawa uli ha paghilbi la ha panakop nan Apo Dioh. Hilay makababa a manyag nin yati, diyagen la awod.” ");
INSERT INTO abp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ha maghay mangaamot, main ano kataon nangilakew nin mangakandin aanak la kanan Apo Jesus ta-omen la awoken kana a ipalonto na ye gamet na kanla boy ipakigwang. Noba pinaghabiyan la hilan mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Paolayan yo hilay mangakandin aanak a humaley kangko. Adi yo hila anhaaden, ta hilay tataon main pangugali a omen kanlan hilatin aanak ye maibilang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pangayadi nan impalonto ye gamet na ha ō nin balang magha kanla boy in-inged, ket inumalih yayna. ");
INSERT INTO abp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ha maghay mangaamot, main maghay lakin nakew nanepet kanan Apo Jesus nin wanae, “Maihtodo, hinyay manged a diyagen ko ta-omen ako mabyayan nin bi-ay a homain anggaan?” ");
INSERT INTO abp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nakibat yay Apo Jesus, “Taket ta antepeten moko no hinyay manged? Mamaghan bengat ye manged, homain kanayon, no aliwan hiyay Apo Dioh. No labay mo ye mabyayan nin bi-ay a homain anggaan, humbongen moy Bibilin.” ");
INSERT INTO abp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nanepet yayna man ye laki, “Hinya kanlan hilain a bibilin ye humbongen ko?” Nakibat yay Apo Jesus, “Adi ka mamatey nin tao, adi ka mamabayi o makilaki, adi ka manakaw, adi ka manihtigoh nin katagowan, ");
INSERT INTO abp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bihaen moy bapa boy indo mo, boy adoen moy kapadiho mo a omen ha pangado mo nin hadili mo.” ");
INSERT INTO abp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hinabi nan laki, “Kaganaan hilain a bibilin, ket anhumbongen koyna. Hinya po nayi ye hukat kon diyagen?” ");
INSERT INTO abp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nakibat yay Apo Jesus, “No labay moy mag-ilyadin genap, muli ka, ta ilako moy babandi mo. Ket hiyay mapaglakoan mo, ibyay mo kanlan mangaidap. Ha wanabay, magkamain kan kabatnangan ha langit. Pangayadi, mag-udong ka ihti, ket manumbong kayna kangko.” ");
INSERT INTO abp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pamakange nan laki ye hinabi nan Apo Jesus, malele yan inumalih, ta mabatnang yan tubat. ");
INSERT INTO abp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hinabi nan Apo Jesus kanlan mānumbong na, “Pakaleng-en yon manged ye habiyen ko. Koynan kaidap a maibilang ye mabatnang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Matataloh ya po a humlep ye maghay kamelyo ha lubot nin kadayem dinan ha maibilang ye taon mabatnang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pamakange lan mānumbong nan Apo Jesus ye hinabi na, nagtaka hilan tubat. Kaya-bay nanepet hila kana, “No wanabay awod Apo, aya hilaynay miligtah?” ");
INSERT INTO abp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ket binilew na hilan Apo Jesus boy hinabi na, “Ahe na mapalyadi nin tao, noba mapalyadi nan kaganaan nin Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Haanin, hiyay Pedro, hinabi na met, “Hikayi nayi, Apo? Ket nilakwanan mi ye kaganaan ta-omen kayi manumbong kammo. Hinya met awod ye pakinabang mi lano?” ");
INSERT INTO abp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hinabi nan Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko! Lano ha bayowen nan Apo Dioh ye kaganaan a babagay, hiko a ibat ha langit a in-Anak nin Tao, ket mikno akoyna ha madangal a pamiknoan nin poon. Ket hikawon mānumbong ko, mikno kawo met lano ha labinluwan pamiknoan a mamoon kanlan labinluwan lalahi nin Israel. ");
INSERT INTO abp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ket ayaman a nanlakwan nin baey na, kakatongno na, tutoa na, aanak na, o luta na uli ha panumbong na kangko, ket malalabong po ye matanggap na dinan ha nilakwanan na boy mabyayan ya po nin bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Malabong a angkauna haanin ye mipahuyot lano boy malabong met a angkahuyot haanin ye miuna lano.” ");
INSERT INTO abp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hinabi na po Apo Jesus kanla, “Hiyay diyagen nan Apo Dioh ha panakopan na, mailalayi ya ha dinyag nin maghay taon main pananeman nin ubah. Ha mahanibhanib po, nakew yan nanapul nin upaan nan mag-obda ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ket ha nakatapul yayna, nakikahundo ya kanla a upaan na hilan alaga nin upa ha maghay mangaamot. Pangayadi, intubol na hilaynan mag-obda ha pananeman na nin ubah. ");
INSERT INTO abp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ha magaynan ikahiyam nin mahanib, nakew ya ha haley nin palingki. Ket nakakit yan anoy lakin ampideng, ta homain hilan obda.” ");
INSERT INTO abp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Hinabi na kanla, ‘Makew kawon mag-obda ha pananeman kon ubah. Ket upaan katawon huhton upa.’ ‘Awo’, wanla. Kaya-bay nakew hilaynan mag-obda. ");
INSERT INTO abp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ha magaynan miugtoy mangaamot, nakew yayna man ha haley nin palingki. Ha nakakit yan nangaanon katao ihtew, ket pinaobda na hila met. Wanabay met ateed ye dinyag na ha ikatloyna nin mahilem.” ");
INSERT INTO abp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ha magaynan ikalima nin mahilem, nakew yayna man. Ket nakakit yayna man nin ano kataon homain obda. In-idlaw na hila, ‘Taket ta ampikahilem kawoynan bengat ihti a homain andiyagen?’ ” ");
INSERT INTO abp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nakibat hila kana, ‘Homain kaya-bay ampamaobda kammi.’ ” “Hinabi na kanla, ‘Kokawoynan mag-obda ha pananeman kon ubah.’ ” ");
INSERT INTO abp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ha andumeglem ana, hinabi nan nagkonin nin pananeman kanan ampabaalaen na, ‘Hagyaten mo hilaynay māg-obda, ta ibyay moynay upa la. Ket hiyay unaen mon biyan, hilay nahuyot a nag-obda.’ ");
INSERT INTO abp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Haanin, nilumateng hilay pinaobda na ha odah nin ikalima nin mahilem. Ket inupaan na hilan upa nin maghay mangaamot.” ");
INSERT INTO abp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Ha nilumateng hilaynay nauna nan pinaobda, nabaan la a malalabong ye upa la dinan kanlan nahuyot a pinaobda na. Noba ahe, ta padiho met ateed ye in-upa na kanla. ");
INSERT INTO abp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pamakatanggap lay upa la, nagdiklamo hila kanan nagkonin nin pananeman ubah, ");
INSERT INTO abp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a wanla, ‘Hi! Hilay nahuyot kammi a pinaobda mo, maghay odah bengat ye pag-obda la. Noba hikayi, nikahilem kayin nag-obda boy nangikpe nin amot. Taket ta padihoy upa mi?’ ” ");
INSERT INTO abp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Hiyay nagkonin nin pananeman ubah, nakibat ya kanan magha kanla, ‘Gayyem, ahe kata kinuhit. Aliwa nayi a napaykahundoan ta a biyan katan upa nin maghay mangaamot? ");
INSERT INTO abp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kaya-bay kowen moynay upa mo. Ket muli kayna. Kalabayan ko a ipadiho kanyo ye upa lan nag-obda a nahuyot kanyo. ");
INSERT INTO abp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taket, homain ako nayi katulidan a manyag nin labay ko ha pilak ko o angkaibeg kan bengat kanla ha dinyag kon manged?’ ” ");
INSERT INTO abp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pangayadi, hinabi nan Apo Jesus, “Wanabay met lano ye malyadi ha huyot a mangaamot. Hilay angkahuyot haanin, ket miuna hila lano. Ket hilay angkauna haanin, mipahuyot hila lano.” ");
INSERT INTO abp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Legan angkumodang yay Apo Jesus palakew ha banwan Jerusalem, in-ilbo na hilay labinluway mānumbong na kanlan tatao. Ket hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Leng-en yo yatin habiyen ko. Makew kitawo haanin ha Jerusalem. Ket hiko a ibat ha langit a in-Anak nin Tao, maigawang kanlan mānguna a papadi boy mamaihtodo nin Bibilin. Uhgaan la kon matey. ");
INSERT INTO abp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pangayadi, igawang lako kanlan aliwan Judio. Umih-umihen lako, hibladen boy ipako ha kodoh. Noba ha ikatlon mangaamot, mabi-ay akon uman.” ");
INSERT INTO abp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hiyay ahawa nan Zebedeo, hinumaley ya kanan Apo Jesus, lamo na hilay luway aanak na a laki. Ket nanalimukod ya ha adapan na boy hinabi na, “Apo, main ako dayin labay awoken kammo.” ");
INSERT INTO abp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tinepet na yan Apo Jesus, “Hinyay labay mo?” Nakibat ya, “No malyadi dayi, Apo, lano ha mamoon kayna, paiknoen mo hilatin luwan aanak ko ha talig mo. Hiyay magha, ha dapit wanan mo. Boy hiyay magha met, ha dapit odi mo.” ");
INSERT INTO abp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Noba hinabi nan Apo Jesus kanla, “Ahe yo tanda ye an-awoken yo. Mababa yo nayi a ikpe ye pamaidap a dihaen ko?” Nakibat hila, “Awo Apo, mababa mi!” ");
INSERT INTO abp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hinabi nan Apo Jesus kanla, “Peteg a madihaan yo met ye pamaidap a dihaen ko. Noba aliwan hikoy mamili no ayay mikno ha dapit wanan o odi ko, ta yabay-in a iknoan, ket kanlan tataon nangitaladanan nan Bapa ko.” ");
INSERT INTO abp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ha natandaan lan mapo a mānumbong na ye an-awoken lan mikatongno, napoot hila kanla. ");
INSERT INTO abp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaya-bay hinagyat na hilan kaganaan Apo Jesus a humaley kana. Ket hinabi na kanla, “Tanda yoynabay met a hilay aliwan Judion mānungkolan, an-ipilit lay labay la kanlan tataon angkahakopan la. Ket agya hinyaman a labay la, ket angkahumbong. ");
INSERT INTO abp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Noba kanyo, aliwan wanabay. No aliwan, ayaman kanyo ye malabay a mag-ilyadin matagay, katapulan a mag-ilyadi yan māghilbi yo. ");
INSERT INTO abp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Boy ayaman kanyo ye malabay mag-ilyadin mānguna, katapulan a mag-ilyadi yan ipoh yo. ");
INSERT INTO abp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tuwaden yoko, ta agya hiko a ibat ha langit a in-Anak nin Tao, ket nakew ako ihti ha babe-luta ta-omen maghilbi boy ibyay koy bi-ay ko a pambeh ha malabong a tatao. Ahe ako nakew ihti ta-omen paghilbiyan nin tatao.” ");
INSERT INTO abp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ha umalih hilaynan Apo Jesus ha banwan Jerico, hinumbong hilan malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Haanin, main luway lakin kapkap a ampikno ha gilid dān. Ha nange lan anhumapid yaynay Apo Jesus, nangha hila, “Apo, Lahi nan Poon David, ingalowan mo kayi!” ");
INSERT INTO abp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Noba hilay tatao, pinaghabiyan la hilay kapkap, “Pakal-em kawo!” Noba inlalo layna ingat impangha, “Apo, Lahi nan Poon David, ingalowan mo kayi!” ");
INSERT INTO abp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pamakange nan Apo Jesus nin pangha la, tinumgen ya haka na hila pinahaley. Ket tinepet na hila, “Hinyay labay yo a diyagen ko kanyo?” ");
INSERT INTO abp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nakibat hila, “Apo, labay mi ye makakit.” ");
INSERT INTO abp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nalunoh yay Apo Jesus kanla. Kaya-bay kinimpaan nay mamata la. Tampol hilaynan ampakakit boy nanumbong hilayna kana. ");
INSERT INTO abp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Haanin, ha maga hilaynan miabot ye Apo Jesus ha banwan Jerusalem, tinumgen hila ha mahaley nin Betfage ha Mapantay nin Oolibo. Ket pinauna na hilay luway mānumbong na, ");
INSERT INTO abp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a wana, “Makew kawo ha dongla a badiyo. Ket pamiabot yo ihtew, main kawon makit a mitaindo a ahnon nakah-el. Loaten yoya boy tengtengen yo hila kangko. ");
INSERT INTO abp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No main manepet kanyo, ‘Uy! Taket ta anloaten yo yay ahno?’ habiyen yo kana, ‘Matapul na yan Apo.’ Ket palubohan na kawo.” ");
INSERT INTO abp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nalyadi yati ta-omen matupad ye hinabi nin podopita nin Dioh hatew, ");
INSERT INTO abp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Habiyen yo kanlan tataon angkumonin ha banwan Zion, ‘Bilewen yo! Anlumateng yaynay Poon yo. Mapagmakaaypa ya, ta oybon ahno bengat ye anhakayan na.’ ” ");
INSERT INTO abp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Haanin, hilay luway mānumbong nan Apo Jesus, nakew hilayna. Ket dinyag lay hinabi na kanla. ");
INSERT INTO abp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hilay luwan mānumbong, tinengteng la hilay mitaindo a ahno kanan Apo Jesus. In-apay lay kepkep la ha golot nin oybon ahno. Ket hinakayan na yayna met Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Malabong hilay tataon nangiamlak nin kepkep la ha pagdanan nan Apo Jesus. Hilay kanayon met, nanlahngi hilan papalapa a mablong. Ket in-amlak la met ha pagdanan na. ");
INSERT INTO abp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ket hilay tatao a anti ha unaan boy huyotan nan Apo Jesus, an-ipapangha la, a wanla, “Galangen tawo yatin Lahi nan Poon David! Inged na yan Apo Dioh ye anlumateng ha ngalan na! Galangen yay Apo Dioh a anti ha langit!” ");
INSERT INTO abp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pamiabot nan Apo Jesus ha banwan Jerusalem, naahwag ye kaganaan a tataon anti ha banwa. Ket napaytepet-tepet hila, “Aya yain a tao?” ");
INSERT INTO abp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hinabi la met anhumumbong kana, “Ah! Hiyay Apo Jesus yain. Hiyabay ye podopita a ibat ha banwan Nazaret ha plobinhiyan Galilea.” ");
INSERT INTO abp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Haanin, nakew yay Apo Jesus ha mahlang nin Timplo. Ket intaboy na hilay tataon ampaglako boy ampanaliw ihtew. Imbabalintog nay lalamihaan lan mānagilin pilak lan dadayohan boy iknoan lan māglako nin kalapati a an-ihagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Haanin, hinabi na kanla, “Hiyay naihulat a Habi nin Dioh, ‘Hiyay baey ko, mahabtan yan baey pamakigwangan.’ Noba dinyag yo yan payngikbengan nin mānakaw.” ");
INSERT INTO abp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Legan anti ya po ye Apo Jesus ha Timplo, main kakapkap boy pipilay a hinumaley kana. Ket pinaitaah na hila. ");
INSERT INTO abp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Noba hilay mānguna a papadi boy hilay mamaihtodo nin Bibilin, ha nakit lay kapagtakaan a dinyag nan Apo Jesus boy ha nange lay an-ipapangha lan aanak ha Timplo a wanae, “Galangen tawo yay Lahi nan Poon David,” ket napoot hila. ");
INSERT INTO abp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kaya-bay hinabi la kanan Apo Jesus, “Ahe mo nayi angkange ye an-ipapangha lan hilain a aanak? Taket ta ahe mo hila haaden?” Inhebat nan Apo Jesus, “Awo, angkange ko. Noba ahe yo nayi nabaha ye naihulat a Habi nin Dioh a wanae, ‘Hilay mangakandin aanak, ket inadalan na hilan Apo Dioh a manggalang kana’?” ");
INSERT INTO abp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pangayadi, nilakwanan na hilan Apo Jesus. Ket nakew ya ha badiyon Betania. Ket ihtew yan kinaid-an. ");
INSERT INTO abp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kabekahan, ha ampag-udong hilayna ha banwan Jerusalem, nabitlan yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Haanin, nakakit yan poon-kayon igoh ha gilid dān. Ket hinaleyan naya. Noba homain yan nakit a dawa, no aliwan kabobong bengat. Kaya-bay hinabi nan Apo Jesus ha poon-kayon igoh, “Paibat haanin, agkayna makapanawa makanoman.” Ket tampol yan nayango. ");
INSERT INTO abp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hilay mānumbong na, pamakakit la ha nalyadi, nagtaka hila, a wanla, “Yo! Way-omen yan tampol nayango ye poon-kayon igoh?” ");
INSERT INTO abp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nakibat yay Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. No main kawon pamteg boy adi kawo ampagluwaluwa, ket madyag yo met ye dinyag ko kananyatin poon-kayon igoh. Aliwan bengat yain. Malyadi yo po habiyen kananyatin mapantay, ‘Kokayna ha dagat’, ket mapalyadi ye hinabi yo. ");
INSERT INTO abp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hinyaman a awoken yo kanan Apo Dioh makauli ha pamakigwang, no pamtegan yo a ibyay na kanyo, ket homain hapo a matanggap yo.” ");
INSERT INTO abp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Haanin, hiyay Apo Jesus, nag-udong yayna man ha Timplo. Ket legan ampangiadal ya ha mahlang nin Timplo, hinaleyan la yan mānguna a papadi boy tutoan Jujudio a mānungkolan. Tinepet laya, “Hinyay katulidan mon manyag nin didinyag mo naapon? Ayay namyay kammo nin katulidan?” ");
INSERT INTO abp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nakibat yay Apo Jesus kanla, “Tepeten katawo met. No pakibatan yoko, habiyen ko kanyo no ayay namyay kangko nin katulidan a manyag nin wanabay. ");
INSERT INTO abp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yati ye tepet ko kanyo, ‘Ayay namyay kanan Juan nin katulidan a mamawtihmo? Hiyay Apo Dioh o tao?’ ” Ket pinaytongtongan la, a wanla, “No habiyen tawo a hiyay Apo Dioh, ket habiyen na met kantawo, ‘Taket awod ta ahe yoya pinamtegan ye Juan?’ ");
INSERT INTO abp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Noba no habiyen tawo met a tao, kapootan la kitawon tatao, ta ampamtegan lan kaganaan a hiyay Juan, ket podopita na yan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaya-bay hinabi la, “Ahe mi tanda.” Hinabi na met Apo Jesus kanla, “No wanabay awod, ahe ko met habiyen kanyo no ayay namyay kangko nin katulidan a manyag nin andyagen ko.” ");
INSERT INTO abp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hinabi na po Apo Jesus kanla, “Ha ihip yo, hinyay labay habiyen nin yati? Main maghay bapa a main luway anak a laki. Haanin, hinumaley ya kanan makaagat. Ket hinabi na, ‘Anak ko, kokaynan mag-obda haanin ha pananeman tawon ubah.’ ");
INSERT INTO abp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Hi! Agko’, wanan anak na. Noba nauman ye ihip na. Kaya-bay nakew ya met ateed a nag-obda. ");
INSERT INTO abp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hinabi na met bapa kanan makaydeng, ‘Anak ko, kokaynan mag-obda haanin ha pananeman tawon ubah.’ ” “Inhebat nan makaydeng, ‘Awo, Tatang’, noba ahe ya met nakew.” ");
INSERT INTO abp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Haanin, hiyay Apo Jesus, tinepet na hilay mānguna a papadi boy hilay tutoan Jujudio a mānungkolan, “Aya awod kanlan mikatongno ye nanumbong ha kalabayan nan bapa la?” Nakibat hila kana, “Hiyay makaagat.” Hinabi nan Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Hilay an-ibilang yon mangaloke a omen kanlan mangakuhit a māningil nin bowih boy babayin babayadan, muna hila po a maibilang kanlan anhakopen nan Apo Dioh dinan yo. ");
INSERT INTO abp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta ha nakew yan nangiadal kanyo ye Juan a Māmawtihmo no way-omen kawo magbi-ay a matoynong, ahe yo pinamtegan. Noba hilay mangakuhit a māningil nin bowih boy hilay babayin babayadan, ket namteg hila kana. Ket agya nakit yobayna, ahe kawo po naghehe ha kakahalanan yo boy namteg kana.” ");
INSERT INTO abp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hinabi na po Apo Jesus, “Leng-en yo po yatin pangilalayi. Main maghay laki a nananem nin ubah ha pananeman na. Pinaaladan naya boy namadyag yan pamihnakan ubah. Namadyag ya po nin baag a matagay a kunaan nin māgbantay. Pangayadi, pinaabangan nay ubahan na kanlan māmakitalon. Ket nakew yayna ha mataang a lugal. ");
INSERT INTO abp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ket ha panaon anan pamupol nin ubah, nangitubol yan tatloy iipoh na a mangwa nin dakay na kanlan māmakitalon. ");
INSERT INTO abp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Noba hilay māmakitalon, dinakep la hilay iipoh a intubol na. Ket hiyay magha, binogbog laya. Hiyay magha met, pinatey laya. Hiyay ikatlo, tinapontapon la yan dadapah angga ha natey ya. ");
INSERT INTO abp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Haanin, nangitubol yayna man nin kanayon a iipoh na a malalabong dinan ha nauna. Ket ha niabot hilayna kanlan māmakitalon, wanabay met ateed ye dinyag la kanla. ");
INSERT INTO abp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ha kalinghuyotan, intubol nay anak na, ta an-ihipen na a bihaen la yay anak na. ");
INSERT INTO abp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Noba ha natamulaw la yan māmakitalon ye anak na a andumaho, hinabi la, ‘Anti yaynay manawid! Pateyen tawo ya ta-omen tawo mapagkonin ye tawiden na.’ ");
INSERT INTO abp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kaya-bay hiyay dinyag la kana, dinakep la yan ingguloy a pinatey ha ilwah nin ubahan.” ");
INSERT INTO abp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Haanin, nanepet yay Apo Jesus, “Lano ha mag-udong yaynay nagkonin nin ubahan, hinya lagi ye diyagen na kanlan māmakitalon?” ");
INSERT INTO abp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nakibat hilay mānguna a papadi boy tutoan Jujudio, “Homain hapo a pateyen na hilay mangaloke a māmakitalon haka na ipaupa kanlan kanayon a māmakitalon a mamyay nin dakay na ha panaon nin pamupol.” ");
INSERT INTO abp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hinabi nan Apo Jesus kanla, “Ahe yo nayi nabaha yati ha naihulat a Habi nin Dioh, ‘Hiyay dapah a ingkahwil lan māmaideng nin baey, hiyabay ye ginawi a pundahyon nin baey. Diyag nin Dioh yati ket koynan kapagtakaan kantawo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hinabi na po Apo Jesus, “Leng-en yo yati. Aliwaynan hikawo ye anhakopen nan Apo Dioh, no aliwan hilay tataon ampanumbong ha kalabayan na. ");
INSERT INTO abp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ayaman a maampag kananyatin dapah, ket mapha ya. Ket ayaman a maondagan na, ket matamek ya.” ");
INSERT INTO abp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pamakange lan mānguna a papadi boy Papariseo ye pangilalayi nan Apo Jesus, natalohan la a hilabay ye andektan na. ");
INSERT INTO abp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kaya-bay labay la yayna dayin dakpen. Noba angkalimo hila kanlan tatao, ta ampamtegan la a magha yan podopita nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naghabi yayna man ye Apo Jesus kanla makauli ha pangilalayi, ");
INSERT INTO abp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hiyay panakop nan Apo Dioh, mailalayi ya ha dinyag nin maghay poon a nangitaladan nin poni ha banhal nin anak na a laki. ");
INSERT INTO abp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Haanin, intubol na hilay iipoh na a managyat kanlan kinumbida na. Noba ahe la labay ye makibanhal.” ");
INSERT INTO abp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ulita ahe hila nakew, hiyay poon, nangitubol yayna man nin kanayon a iipoh na a managyat kanlan nakumbidayna boy habiyen kanla, ‘Nakahadya anan kaganaan. Nahapo ana ye bobolog a baka boy kanayon a aayop a pinataba. Nakaapag ana ye pamangan. Kaya-bay makew kawoyna!’ ");
INSERT INTO abp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Noba ahe la hila imbabano. Hiyay magha, nakew yan nag-obda ha pananeman na. Ket hiyay magha, nakew ya ha pagpanapulan na. ");
INSERT INTO abp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hilay kanayon, dinakep la hilay intubol nan poon, pinapading-eyan la hila haka la hila pinatey.” ");
INSERT INTO abp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Uli ha dinyag lan nakumbidayna, napoot yan tubat ye poon. Kaya-bay nangitubol yan huhundaloh na a mamatey kanlan namatey nin iipoh na boy mangulam nin banwa la.” ");
INSERT INTO abp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Haanin, hinabi nan poon kanlan kanayon a iipoh na, ‘Nakahadya anay poniyan ha banhal. Noba ahe hilayna malyadin dumongo ye kinumbida ko. ");
INSERT INTO abp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kaya-bay makew kawo ha dādān. Ket balang makit yon tao, hagyaten yo hila a makew ihti.’ ");
INSERT INTO abp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ket hilay iipoh, nakew hila ha dādān. Hinagyat la hilay kaganaan a tataon nakit la, mangaloke man o manganged. Ket napno yan bibihita ye banhalan.” ");
INSERT INTO abp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Haanin, hinumlep yay poon ha banhalan ta-omen na hila bilewen ye bibihita na. Nakakit yan maghay lakin ahe nakabado nin pambanhal. ");
INSERT INTO abp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kaya-bay tinepet naya, ‘Gayyem, way-omen ka nakahlep ihti a ahe nakabadon pambanhal?’ Ket hiyay laki, ahe ya nakatnoy.” ");
INSERT INTO abp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Haanin, hinabi nan poon kanlan māghilbi na, ‘Higi! Gapohen yoy gamet boy bitih na, ta itapon yoya ha ilwah ha kalitehan. Ta ihtew yan tumangih boy manginaet.’ ” ");
INSERT INTO abp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pangayadi, hinabi nan Apo Jesus, “Hiyay labay habiyen nin yatin pangilalayi, ket malabong hilay tataon hinagyat nan Apo Dioh a maibilang kanlan anhakopen na, noba nangaanon bengat kanla ye napili.” ");
INSERT INTO abp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Haanin, inumalih hilay Papariseo, ta mangihip hilan papadan no way-omen laya makalot ye Apo Jesus makauli ha hahabi na. ");
INSERT INTO abp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaya-bay nangitubol hilan mānumbong la boy nangaanon tatao nan Gobilnadol Herodes Antipas a makew manepet kanan Apo Jesus, “Maihtodo, tanda mi a pawa peteg ye anhabiyen mo. Hiyay kaptegan tungkol ha kalabayan nan Apo Dioh ye an-iadal mo kanlan tatao. Homain kan antupigan a tao, ta padipadiho ye pamilew mo ha kaganaan. ");
INSERT INTO abp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haanin, habiyen mo man kammi. Ha ihip mo, huhto laweh a mamayad kitawon bowih ha Emperador nin Roma o ahe?” ");
INSERT INTO abp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Noba tanda nan Apo Jesus a maloke ye tikih la. Kaya-bay hinabi na kanla, “Hikawon māgkonwadi, taket ta labay yo kon kaloten? ");
INSERT INTO abp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gawangan yoko man nin palatan Roma.” Ket ginawangan la yan palata. ");
INSERT INTO abp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Haanin, hiyay Apo Jesus, impakit nay palata boy tinepet na hila, “Ayay naglupa boy nagngalan ye nakadokit ihti?” ");
INSERT INTO abp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Hiyay Emperador Cesar,” wanla. Haanin, hinabi nan Apo Jesus kanla, “No wanabay awod, hiyay kanan Emperador Cesar, ibyay yo kana. Ket hiyay kanan Apo Dioh, ibyay yo met kana.” ");
INSERT INTO abp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pamakange lan pakibat nan Apo Jesus, nagtaka hila. Kaya-bay nilakwanan la yayna. ");
INSERT INTO abp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kananyatew met ateed a mangaamot, hilay Saduseo, nakew hilan nanepet kanan Apo Jesus. Hilabay ye pangkat nin tatao a ahe ampamteg a mabi-ay uman ye nangamatey. Hinabi la kanan Apo Jesus, ");
INSERT INTO abp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maihtodo, hiyay anti ha Bibilin a impahulat kanan Moises, wanae ya, ‘No matey yay ahawan laki, ket ahe ya nagkaanak kanan ahawa na, katapulan a ikahal nin katongno nan laki ye bawo. Ket no magkaanak hila, maibilang yan anak nin katongno na a natey.’ ");
INSERT INTO abp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Haanin, main pitoy lalaki a mikakatongno. Hiyay punganay, nangahawa ya. Noba natey yan ahe hila nagkaanak kanan ahawa na. Ket haanin, hiyay ali na, inahawa naya met ye ipag na. Noba natey ya met ateed a ahe hilan nagkaanak. ");
INSERT INTO abp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wanabay met ateed ye nalyadi ha kakatlo angga ha ikapiton katongno na. Kaganaan hilatin mikakatongno, napag-ahawa laya yatin babayi, noba ahe hila nagkaanak kana. ");
INSERT INTO abp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ha kalinghuyotan, natey ya met ye babayi. ");
INSERT INTO abp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haanin, wanae ye tepet mi kammo, ‘Ha panaon a mabi-ay uman ye nangamatey, aya lagi kanlan pitoy mikakatongno ye ahawa nan babayi, ta napag-ahawa na hilan kaganaan?’ ” ");
INSERT INTO abp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nakibat yay Apo Jesus kanla, “Aliwan huhto ye ihip yo, ta ahe yo angkatalohan ye naihulat a Habi nin Dioh boy hiyay kapalyadiyan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta hilay nabi-ay uman, ahe hilaynan mangahawa. Mag-ilyadi hilaynan omen kanlan aanghil ha langit a ahe ampangahawa. ");
INSERT INTO abp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ket hiyay tungkol met ha pagkabi-ay uman, ahe yo po nayi nabaha ye naihulat a Habi nin Dioh a wanae, ");
INSERT INTO abp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Hikoy Dioh nan Abraham, Dioh nan Isaac boy Dioh nan Jacob.’ Hiyay labay habiyen, angkabi-ay hila po. Ta hiyay Apo Dioh, ket Dioh nin angkabi-ay, aliwan nangamatey.” ");
INSERT INTO abp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pamakange lan tatao yatew, nagtaka hila ha pangiadal na. ");
INSERT INTO abp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ha nabalitaan lan Papariseo a homain hilan maihebat ye Saduseo kanan Apo Jesus, naytitipon hilayna man. Ket hinumaley hila kana. ");
INSERT INTO abp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ket hiyay magha kanla a maihtodo nin Bibilin, nanepet ya kanan Apo Jesus ta-omen naya kaloten ha hahabi na, ");
INSERT INTO abp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maihtodo, ha kaganaan a bilin nan Apo Dioh, hinyay pinakamaalaga?” ");
INSERT INTO abp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nakibat yay Apo Jesus kana, “ ‘Adoen mo yay Apo mon Dioh a luboh ha puho, luboh ha kalelwa boy luboh ha ihip.’ ");
INSERT INTO abp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yabay-in ye pinakamaalaga ha kaganaan a bibilin. ");
INSERT INTO abp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wanabay ya met ateed kaalaga ye kakalwa, ‘Adoen moy kapadiho mon tao a omen ha pangado mo nin hadili mo.’ ");
INSERT INTO abp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hilay kaganaan a bibilin a impahulat nan Apo Dioh kanan Moises boy hilay kaganaan a inhulat lan popodopita, ket anti hila kananyatin luwan bibilin.” ");
INSERT INTO abp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Legan napaytipon hila po ye Papariseo, nanepet yay Apo Jesus kanla, ");
INSERT INTO abp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Hinyay pagkatanda yo kanan Cristo? Hinyay lahi ye pangibatan na?” Nakibat hila kana, “Lahi na yan Poon David.” ");
INSERT INTO abp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hinabi na met Apo Jesus kanla, “No lahi na yan Poon David, taket awod ta hiyay David, hinabtan na yan ‘Apo’ ye Cristo. Ta makauli ha Ihpiditon Dioh, hinabi nan Poon David ye tungkol kanan Cristo, ");
INSERT INTO abp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Hinabi nan Apo Dioh kanan Apo ko, “Mikno ka ha dapit wanan ko angga ha mapahuko ko hila kammo ye kakaaway mo.” ’ ” ");
INSERT INTO abp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“No hiyay Poon David ket hinabtan na yan ‘Apo’ ye Cristo, way-omen la yan mahabi nin tatao a lahi na yan bengat nin David ye Cristo?” ");
INSERT INTO abp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Agya maghan bengat, homain bega nakahebat ha tepet nan Apo Jesus. Ket paibat ana kananyatew, homain anan bega nagngaya a manepet kana. ");
INSERT INTO abp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pangayadi, hinabi nan Apo Jesus kanlan tatao boy kanlan mānumbong na, ");
INSERT INTO abp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hilay mamaihtodo nin Bibilin boy hilay Papariseo ye nabyayan nin katulidan a mangipalinaw nin Bibilin a impahulat kanan Moises. ");
INSERT INTO abp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaya-bay leng-en boy humbongen yo ye kaganaan a iadal la kanyo. Noba adi yo antuwaden ye andiyagen la, ta ahe la andiyagen ye an-iadal la kanyo. ");
INSERT INTO abp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","An-ipahumbong la kanyo ye impahan la a bibilin a maidap humbongen. Noba ahe la kawo met anhaglapan ha panumbong nin yatew a bibilin. ");
INSERT INTO abp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kalalabay lay dangalen nin tatao. Kaya-bay pinabilal lay natopitopi a papil a main hulat a habi nin Dioh a naipaklap ha kiding la boy takyay la. Boy pinakadang la ye laylay nin hoot la. ");
INSERT INTO abp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Boy kalalabay lay mikno ha pamiknoan a nakataladan kanlan mangadangal a tatao ha poniyan boy ha pāytiponan lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kalalabay la met ye maidlaw nin tataon angkadanan la boy mahabtan ‘maihtodo’.” ");
INSERT INTO abp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Noba hikawo, adi kawo pahabtan ‘Maihtodo’, ta mikakatongno kawo boy hikon bengat ye Maihtodo yo. ");
INSERT INTO abp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Boy adi yo hila habtan ‘Bapa’ ye ayaman a tao ihti ha babe-luta, ta mamagha yan bengat ye Bapa yo, hiyay Bapa yo ha langit. ");
INSERT INTO abp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Boy adi kawo met pahabtan ‘Apo’, ta mamagha yan bengat ye Apo yo a homain kanayon no aliwan hiko a ‘Cristo’. ");
INSERT INTO abp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ayaman kanyo ye malabay mag-ilyadin pinakamatagay, katapulan a hiyabay ye māghilbi yo. ");
INSERT INTO abp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta ayaman a ampagmatagay, ket iaypa na yan Apo Dioh. Boy ayaman a ampagmaaypa, ket itagay na yan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hinabi na po Apo Jesus, “Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Hikawo ye hangkan no taket ta hilay tatao, ket ahe hila maibilang kanlan anhakopen nan Apo Dioh. Ahe yobayna labay ye maibilang kanlan anhakopen na. Ket antapaen yo hila po ye malabay maibilang kanlan anhakopen na.” ");
INSERT INTO abp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Ampaglanganan yo hilay bawon babayi ta-omen yon bengat makwa ye babandi la. Boy anhakban yo po yatin andiyagen yo makauli ha makadang a pamakigwang yo ha adapan lan tatao. Kaya-bay mamabyat lano ye ipaduha nan Apo Dioh kanyo. ");
INSERT INTO abp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Anlipayen yoy dagat boy anhoyhoyen yo po ye mangataang a lulugal ta-omen kawon bengat makakumbinyo nin aliwan Judio a manumbong ha pamteg yo. Ket no mapahumbong yo hilayna, andiyagen yo hilan maloloke po dinan yo. Kaya-bay lalalo hilayna ingat maipalakew ha impilno.” ");
INSERT INTO abp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakaingalo kawo. Ba-mo kawon kapkap a ampangakay nin kanayon, ta an-iadal yo, ‘No idamit yoy Timplo ha panumpa yo, homain bali. Noba no idamit yoy balitok ha loob nin Timplo, hukat yon tupaden.’ ");
INSERT INTO abp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hikawon mumutaw a kapkap, nabaan yo nayi a maaalaga ye balitok dinan ha Timplo nan Apo Dioh? Ahe, ta hiyay balitok, mag-ilyadi yan maalaga kanan Apo Dioh no anti yayna ha loob nin Timplo. ");
INSERT INTO abp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Boy an-iadal yo po, ‘No idamit yoy pangihagpaan nin digalo kanan Apo Dioh ha panumpa yo, homain bali. Noba no idamit yoy digalo ha pangihagpaan, hukat yon tupaden.’ ");
INSERT INTO abp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Petegbay a kapkap kawo! Nabaan yo nayi a maaalaga ye digalo dinan ha pangihagpaan? Ahe, ta mag-ilyadin maalaga ye digalo no anti yayna ha pangihagpaan. ");
INSERT INTO abp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kaya-bay pakaihipen yo. No idamit yoy pangihagpaan nin digalo kanan Apo Dioh ha panumpa yo, an-idamit yoyna met ye kaganaan a digalo a nakahagpa ihtew. ");
INSERT INTO abp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ket no idamit yoy Timplo ha panumpa yo, ket an-idamit yoyna met ye Apo Dioh a angkumonin ihtew. ");
INSERT INTO abp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ket no idamit yoy langit ha panumpa yo, ket an-idamit yoyna met ye pamiknoan nin Dioh boy hiyay Apo Dioh a ampikno ihtew.” ");
INSERT INTO abp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Ta agya po man an-ihagpa yo kanan Apo Dioh ye ikamapo nin pupol yon dikado ha tanaman yo, ampaolayan yo met ye maaalaga po a bibilin tungkol ha katoynongan, pangingalo boy pag-ilyadin mapatayaan. Huhto a ibyay yoy ikamapo yo. Noba adi yo ampaolayan ye maaalaga a bibilin. ");
INSERT INTO abp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hikawon kapkap a ampangakay. Mahehpet yon anhumbongen ye aliwan minga maalaga a bibilin, noba ampaolayan yoy maaalaga. Ba-mon anhagaten yoy ilek ha inomen yo, noba an-ibolon yo met ye kamelyo.” ");
INSERT INTO abp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Ta anlinihan yoy ilwah nin babaho boy pipinggan yo, noba napno met nin babagay a kinuhit yo kanlan tatao uli ha kaakokohan yo. ");
INSERT INTO abp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hikawon kakapkap a Papariseo, pakahigudowen yon manged a aliwan kinuhit ye an-ikonin yo ha babaho boy pipinggan yo, ket mag-ilyadi ya met a malinih ye ilwah.” ");
INSERT INTO abp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Ta ba-mo kawon bibito a pinaputi boy matampa ye ilwah na, noba ha loob, pawa bobot-o boy dinat. ");
INSERT INTO abp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wanabay kawo met, ta ha pamilew lan tatao, matoynong kawo. Noba hiyay anti ha puho yo, pawa kalok-an boy pagkonwadi.” ");
INSERT INTO abp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Hinabi na po Apo Jesus, “Kakaingalo kawon Papariseo boy mamaihtodo nin Bibilin, hikawon ampagmamangedan, ta paduhaan na kawon Apo Dioh! Ta hilay tutoa yo, pinatey la hilay unan popodopita boy mangatoynong a tatao. Ket haanin, ampamadyag kawo nin bilang pagkakitan nin nakailbengan lan popodopita boy ampatampaen yoy bibito lan pinatey la. Boy anhabiyen yo po, ‘No anti kayina dayi ha panaon lan tutoa mi hatew, ket ahe mi dayi pinaolayan a pateyen la hilay popodopita.’ ");
INSERT INTO abp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Makauli yatin hinabi yo, ampaptegan yo a lalahi la kawon namatey kanlan popodopita. ");
INSERT INTO abp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Higina, iyadi yoyna awod ye indugi lan tutoa yo!” ");
INSERT INTO abp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Hikawon lalahi nin bikat! Ahe yo bega maliklikan ye kapaduhaan ha impilno. ");
INSERT INTO abp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaya-bay manlenge kawo! Mangitubol ako lano kanyo nin popodopita, mangadunong boy mamaihtodo nin Bibilin. Hilay nangaano kanla, pateyen yo. Ket hilay kanayon, ipako yo ha kodoh. Hilay kanayon met, badogen yo hila ha loob nin pāytiponan yo boy hilay kanayon po, pakikamatan yo hilan paidapan ha agya way-ihtew hila man makew. ");
INSERT INTO abp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaya-bay mapaduhaan kawo uli ha pamatey yo. Aliwan bengat yain. Pakibatan yo po ye pamatey kanlan kaganaan a tataon mangatoynong paibat kanan Abel angga kanan Zacarias a anak nan Baraquias. Ta hilay tutoa yoynabay met ye namatey kanan Zacarias a pinatey la ha pietan nin Timplo boy pangihagpaan nin digalo kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pakaleng-en yon manged ye habiyen ko. Kaganaan yatin kakahalanan, ket pakibatan la lanon tatao kananyatin panaon.” ");
INSERT INTO abp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hinabi na po Apo Jesus, “Hikawon tatao ha Jerusalem, leng-en yo yati. Pinatey yo hilay popodopita nin Dioh boy binegbaan yo hilan dadapah angga ha natey hilay kanayon a intubol na kanyo. Nikanon ukdo katawoynan labay halokoban a omen ha panalokob nin toan manok ha hihiwhiw na, noba ahe yo labay. ");
INSERT INTO abp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaya-bay agya main mangagwat nin kunaan yo, baala kawoyna. ");
INSERT INTO abp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pakaleng-en yon manged ye habiyen ko. Ahe yo koynan makit uman anggan ahe yo habiyen, ‘Inged na yan Apo Dioh ye anlumateng ha ngalan na.’ ” ");
INSERT INTO abp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hiyay Apo Jesus, legan antumaang ya ha Timplo, hinumaley hila kana ye mānumbong na. Ket intamudo la kana ye mangayadet a dowag nin Timplo. ");
INSERT INTO abp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hinabi nan Apo Jesus kanla, “Awo! Angkakit yo hilan kaganaan yain. Noba pakaleng-en yon manged ye habiyen ko. Mangaagwat hilan kaganaan. Ket homain lanon bega mabantak a dadapah a naypalingping.” ");
INSERT INTO abp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Legan ampikno yay Apo Jesus ha gilid Mapantay nin Oolibo, hinumaley hilay mānumbong na kana. Ket hiklito la yan tinepet, “Apo, habiyen mo man kammi no makano ya lumateng yain a panaon a hinabi mo boy hinyay pagkakitan lano nin pag-udong mo boy hiyay kalampuhan nin babe-luta?” ");
INSERT INTO abp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nakibat yay Apo Jesus kanla, “Mag-alla kawo ta-omen la kawo ahe matalingo nin agya ayaman, ");
INSERT INTO abp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ta malabong hila lanoy lumateng a manggawi nin ngalan ko, a wanla, ‘Hiko ye Cristo a impangako nan Apo Dioh.’ Ket ulin yati, malabong hila lanoy tataon matalingo. ");
INSERT INTO abp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makange kawo lanon gubat ha mahaley kanyo boy ha mataang a lulugal. Noba adi kawo angkahindak, ta katapulan a malyadi hilatew. Noba aliwa po yain ye kalampuhan nin babe-luta. ");
INSERT INTO abp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta maygugubat lano ye nanahyon boy wanabay met ye papanakopan. Ket magkamain nin bitil boy manlayon nin mangakhaw ha nakahinadi a lulugal. ");
INSERT INTO abp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Noba yatin kaganaan ket pandugi po bengat nin kaidapan a omen ha pandugi nin panlamlam nin babayin manganak.” ");
INSERT INTO abp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kananyatew a panaon, uli ha panumbong yo kangko, pag-inakitan la kawon kaganaan a tatao. Dakpen la kawon ipaloke boy pateyen. ");
INSERT INTO abp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ket malabong hilay manalingkukol nin pamteg la kangko. Mapaykahulog hila boy iopit lay kapadiho lan māmteg. ");
INSERT INTO abp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Malabong lanoy lumateng a ampagkonwadin podopita. Ket malabong met lanoy matalingo la. ");
INSERT INTO abp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lumabong ye kalok-an ihti ha babe-luta. Ket ulin yati, malabong lanon māmteg ye lumay-ep ye pangado la. ");
INSERT INTO abp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Noba ayaman a mikakaantin mapatayaan anggan kalampuhan, ket miligtah ya. ");
INSERT INTO abp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maipatanda ya po muna ha kaganaan a nanahyon ihti ha babe-luta ye Manged a Balita tungkol ha panakop nan Apo Dioh bilang pamapteg kanla bayo lumateng ye kalampuhan.” ");
INSERT INTO abp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hinabi na po Apo Jesus, “Hinabi nan podopitan Daniel hatew a makit ye ampakailoy a makapadinat nin Timplo. Hikawon ampamaha nin yati, katapulan a pakaihipen yo yatin manged. No makit yo a ampideng yayna ha lugal a bawal nan pidengan, ");
INSERT INTO abp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","hilay anti ha plobinhiyan Judea, katapulan laynan tumakah palakew ha mamapantay. ");
INSERT INTO abp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hiyay anti ha ilwah nin baey na, ket adi yayna lumoob a mangwan hinyaman a bagay ha baey na. ");
INSERT INTO abp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ket hiyay anti ha talon, adi yayna muli a mangwan kepkep na. ");
INSERT INTO abp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kananyatew a mangaamot, kakaingalo hilay mangabuktot boy hilay iindo a ampamahoho, ta maidapan hilan mayew. ");
INSERT INTO abp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipakigwang yo kanan Apo Dioh a hiyay pamayew yo, ket ahe dayin maigena ha panaon nin kaudanan o Mangaamot nin Pagpainawa. ");
INSERT INTO abp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta kananyatew a panaon, madihaan lan tatao ye tubat a kaidapan a ahe po nalyadi paibat ha pinalhowa ye babe-luta angga haanin boy ahe yayna lano mauman. ");
INSERT INTO abp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ket no ahe na tekbean Apo Dioh yatew a panaon, homain taon mapatla a angkabi-ay. Noba uli kanlan tataon pinili na, ket tekbean na yatew a panaon.” ");
INSERT INTO abp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ket kananyatew a panaon, no main maghabi kanyo nin wanae, ‘Bilewen yo! Anti ya ihti ye Cristo!’ o ‘Anti ya ihtew!’ ket adi yoya ampamtegan. ");
INSERT INTO abp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta lumtaw hila lano ye ampagkonwadin Cristo boy ampagkonwadin popodopita. Ket mangipakit hilan pagkakitan boy kapagtakaan, ta labay la hilan talingowen ye kaganaan a tatao boy no malyadi bengat, agya hilay pinili nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaya-bay mag-alla kawo awod! Hinabi koyna kanyo yatin babagay bayo ya po malyadi ta-omen kawo ahe matalingo.” ");
INSERT INTO abp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kaya-bay no main taon maghabi kanyo, ‘Anti ya ihtew ha wangwang ye Cristo’, adi yo anlakwen boy no main maghabi kanyo, ‘Anti ya ha hilid ye Cristo’, adi yo ampamtegan. ");
INSERT INTO abp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta hiko a ibat ha langit a in-Anak nin Tao, ket mag-udong lano ihti ha babe-luta a makit nin kaganaan a tatao. Ta ba-mo kon kilat a kuminlab paibat ha daya angga ha laod.” ");
INSERT INTO abp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“No way-ihtew ye bangkay, ket matandaan lan kaganaan, ta anti hila ihtew ye oowak a naytitipon.” ");
INSERT INTO abp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hinabi na po Apo Jesus, “Pangalabah nin hilatew a mangaamot nin tubat a kaidapan, tampol yan lumiteh ye mangaamot boy ahe yayna bega humnag ye bowan. Hilay bibitoen, mangaampag hila boy eyegen nan Apo Dioh ye kaganaan a babagay a anti ha lowang anggayna ha mapaywahagwahag hilayna. ");
INSERT INTO abp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pangayadi, makit yoyna ha lowang ye pagkakitan nin pag-udong ko. Uli kananyatin pagkakitan, ket kumolih hilay kaganaan a tatao ihti ha babe-luta. Ta hiko a ibat ha langit a in-Anak nin Tao, makit la kon anti ha owep a an-umaypa a main kapalyadiyan boy tubat a kahnagan. ");
INSERT INTO abp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kadlan nin makhaw a tonoy nin tamboyok, itubol ko hilay aanghil ko ha kaganaan a pahen nin babe-luta ta-omen la hila tiponen ye tataon pinili ko.” ");
INSERT INTO abp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hinabi na po Apo Jesus, “Pakatalohan yon manged yatin adal tungkol ha poon-kayon igoh. No tumbek yaynay bayon bōng ha hahanga na, tanda yoyna a madanon anay kaingitan. ");
INSERT INTO abp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wanabay met ateed lano. No makit yoynan angkalyadina yatin anhabiyen ko, tanda yoyna a madanon akoynan lumateng a ba-mo koynan anti ha ilwangan. ");
INSERT INTO abp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pakaleng-en yon manged ye habiyen ko. Bayo hila po matey ye kaganaan a tataon angkabi-ay kananyatin panaon, matupad ana hilatin kaganaan a hinabi ko. ");
INSERT INTO abp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hiyay lowang boy babe-luta, ket maanam ya. Noba hilay hahabi ko, ket mikakaanti yan makanoman.” ");
INSERT INTO abp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hinabi na po Apo Jesus, “Homain kanayon a nagtanda nin mangaamot o odah nin pag-udong ko, agya po hilay aanghil ha langit o hiko man a Anak nin Dioh, no aliwan hiyay Bapa a Dioh bengat. ");
INSERT INTO abp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Ha panaon nan Noe, bayo po malanab ye babe-luta, hilay tatao, ahe la tanda a manlanab. Ampangan hila, ampinom boy ampangahawa a omen ha alan a andiyagen la angga ha hinumlep yaynay Noe ha daong. Wanabay met ateed ye andiyagen lan tatao lano ha mag-udong ako a ibat ha langit a in-Anak nin Tao. ");
INSERT INTO abp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hilay tatao, homain hilan kamatandaan ha malyadi anggan nilumateng ye lanab a nangalimeh kanla. Wanabay met ateed lano ha mag-udong ako a ibat ha langit a in-Anak nin Tao, ta hilay tatao, homain hilan kamatandaan ha panlumateng ko. ");
INSERT INTO abp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ta lano ha mag-udong ako, main lanon luway laki a ampag-obda ha talon. Hiyay magha, mipalakew ya ha langit. Noba hiyay magha, mabantak ya. ");
INSERT INTO abp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Boy main met lanon luway babayi a ampanggiling. Hiyay magha, mipalakew ya ha langit. Noba hiyay magha, mabantak ya.” ");
INSERT INTO abp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaya-bay lanang kawon nakahadya, ta ahe yo tanda ye mangaamot nin panlumateng nin Apo yo. ");
INSERT INTO abp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pakaihipen yo yati. No tanda nan nagbaey ye odah nin panlumateng nin mānakaw, magbantay yayna ta-omen ahe maloob nin mānakaw ye baey na. ");
INSERT INTO abp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaya-bay lanang kawo met a nakahadya, ta hiko a ibat ha langit a in-Anak nin Tao, ket mag-udong ihti ha babe-luta ha odah a ahe yo an-ihipen a lumateng ako.” ");
INSERT INTO abp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hinabi na po Apo Jesus, “Hiyay ipoh a mapatayaan boy madunong, hiya ye pabaalaen nan amo na kanlan kaganaan a ipoh na. Ket hiya ye mamakan kanla ha huhton odah. ");
INSERT INTO abp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Minged yay ipoh a malatngan a andyagen nay imbilin nan amo na. ");
INSERT INTO abp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pakaleng-en yon manged ye habiyen ko. Hiyabay lano ye pabaalaen nan amo na nin kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Noba yain a ipoh, kakaingalo ya no mag-ilyadi yan maloke boy habiyen na ha hadili na, ‘Ah, mabuyot ya po lumateng ye amo ko’, ");
INSERT INTO abp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ket bogbogen na hilay kapadiho nan ipoh boy makipangan boy makiinoman kanlan maglahing. ");
INSERT INTO abp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lumateng yay amo na ha mangaamot a ahe na tanda. ");
INSERT INTO abp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yatew a ipoh, paduhaan na yan amo na nin mabyat boy itapon naya ha lugal a nakaitaponan lan māgkonwadi. Ket ihtew yan tumangih boy mangiinaet.” ");
INSERT INTO abp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hinabi nayna man Apo Jesus, “Kananyatew a panaon, hiyay pagkaibilang kanlan anhakopen nan Apo Dioh, ket mailalayi ya ha nalyadi kanlan mapo a babalatang a ampangaget nin kingki a makew managana kanan lakin magkahal. ");
INSERT INTO abp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hilay lima kanla, mumutaw. Hilay lima met, mangadunong. ");
INSERT INTO abp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hilay mumutaw, nangaget hilan kingki, noba homain hilan pakalan a hedden. ");
INSERT INTO abp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Noba hilay mangadunong, main hilan pakalan a hedden. ");
INSERT INTO abp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Haanin, ulita nibuyot yan nilumateng ye lakin magkahal, ket nipakatuloy hilay babalatang.” ");
INSERT INTO abp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ha bunak anan madeglem, nange lay pangha a wanae, ‘Anti yaynay lakin ikahal! Haganaen yo yayna!’ ");
INSERT INTO abp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Haanin, hilay mapo a babalatang, nimata hila. Ket intaladan lay kikingki la. ");
INSERT INTO abp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Noba hilay limay mutaw a babalatang, hinabi la kanlan limay mangadunong, ‘Atagan yo kayi man nin hedden yo, ta angkalep ana ye kingki mi.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Noba nakibat hilay mangadunong a babalatang, ‘Agi! Ahe malyadi, ta huhton bengat kammi ye hedden mi. Makew kawoyna tanan manaliw.’ ");
INSERT INTO abp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ket hilay limay mumutaw a balatang, nakew hilan manaliw nin hedden a gawien la. Legan ampanaliw hila, nilumateng ya met ye lakin magkahal. Ket hilay limay mangadunong, inlamo na hilan lakin magkahal a hinumlep ha pagponiyan. Pamakahlep la, naileneb anay ilwangan.” ");
INSERT INTO abp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ha ahe nabuyot, nilumateng hilayna met ye limay balatang a mumutaw. Anti hila ha ilwah nin ilwangan a ampangha nin wanae, ‘Kaka, Kaka, ilukatan mo kayi dayi ta-omen kayi makahlep!’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Noba nakibat yay lakin magkahal, ‘Aya kawo yain? Ahe katawo katatanda.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Haanin, hinabi na po Apo Jesus, “Kaya-bay lanang kawon nakahadya, ta ahe yo tanda ye mangaamot o odah nin pag-udong ko.” ");
INSERT INTO abp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hinabi na po Apo Jesus, “Hiyay pag-udong ko, ket mailalayi ya ha dinyag nin maghay taon mabatnang a makew ha mataang a lugal. Noba bayo ya inumalih, impadakit na hila po ye iipoh na boy impataya na kanlay pilak na. ");
INSERT INTO abp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Balang magha kanlan iipoh na, binyan nan alaga a mababa lan ipagpanapulan. Hiyay magha, binyan na yan liman libon palatan balitok. Hiyay magha, luway libo boy hiyay magha, malibo. Pangayadi, inumalih yayna. ");
INSERT INTO abp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hiyay ipoh a binyanan nan limay libon palatan balitok, tampol na yan impanapulan. Ket nakatubo ya nin limay libo. ");
INSERT INTO abp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wanabay met ye dinyag nan nabyayan nin luway libo. Nakatubo ya met nin luway libo. ");
INSERT INTO abp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Noba hiyay ipoh a nabyayan nin malibo, ket ingkutkot na ha luta ye palatan balitok a naipataya kana.” ");
INSERT INTO abp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pangalabah nin nabuyot a panaon, nag-udong ya ye amo la. Ket impadakit na hilay iipoh na ta-omen na hila tepeten tungkol ha palatan balitok a impataya na kanla. ");
INSERT INTO abp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hinumaley ya kana ye ipoh a pinatayaan nan limay libo. Hinabi na, ‘Apo, tiya ye liman libo a impataya mo kangko boy hiyay tubo na a liman libo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Hinabi nan amo na, ‘Manged boy mapatayaan a ipoh, manged ye dinyag mo! Ulita mapatayaan ka nin makandin alaga, patayaan kata po nin mayayadet a alaga. Kaya-bay tayna ta maghayaghag kita.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Pangayadi, hiyay ipoh a pinatayaan nan luway libo, hinumaley ya met kana. Ket hinabi na, ‘Apo, tiya ye pilak mo a luway libo boy hiyay tubo na a luway libo.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Hinabi na met amo na, ‘Manged ye dinyag mo, mapatayaan kan ipoh! Ulita mapatayaan ka ha makandin alaga, ket patayaan kata po nin mayayadet a alaga. Kaya-bay tayna, ta maghayaghag kita.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Haanin, hiyay maghay ipoh a pinatayaan nan malibo, hinumaley ya met kanan amo na. Ket hinabi na kana, ‘Apo, tanda kobay a homain kan ingalo, ampamupol ka nin ahe mo intanem boy ampakinabangan moy ahe mo nagbannogan. ");
INSERT INTO abp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ket angkalimo ko kammo. Kaya-bay hiyay palata mon balitok, ingkutkot ko hila ha luta. Tiya ye palata mon balitok, bilewen mo!’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hinabi nan amo na, ‘Maloke boy mahado kan ipoh! Tanda mo manayti a ampamupol akon ahe ko intanem boy ampakinabangan koy ahe ko nagbannogan. ");
INSERT INTO abp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Taket ta ahe mo imbangko ye palata kon balitok ta-omen ha pag-udong ko, main yayna dayin tubo?’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Haanin, hinabi nan amo kanlan kanayon a iipoh, ‘Kowen yoya kana ye papalata kon balitok, ta ibyay yo kanan main mapo a libo. ");
INSERT INTO abp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta hiyay taon mainan, ket mabyayan ya po nin malalabong boy umando ya po. Noba hiyay taon homainan, agya hiyay makandin anti kana, kowen ya po kana. ");
INSERT INTO abp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ket yain a ipoh a homain hilbi, itapon yoya ha ilwah ha kalitehan, ta ihtew ya tumangih boy mangiinaet.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hinabi nan Apo Jesus, “Hiko a ibat ha langit a in-Anak nin Tao, mag-udong ako lano a main kapalyadiyan a kalamo ko hilay kaganaan a anghil. Ket mikno ako ha madangal a pamiknoan. ");
INSERT INTO abp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tiponen ko hila ha adapan ko ye kaganaan a tatao ihti ha babe-luta, ta payngilboen ko hila a omen ha pangilbo nin māgpahtol ha kambing boy tupa. ");
INSERT INTO abp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hilay tatao a nailalayi ha tupa, ket ikonin ko hila ha dapit wanan ko. Noba hilay nailalayi ha kambing, ket ikonin ko hila ha dapit odi ko.” ");
INSERT INTO abp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pangayadi, hiko a Poon, habiyen ko kanlan tataon anti ha dapit wanan ko, ‘Makew kawo ihti, hikawon in-inged nan Bapa kon Dioh. Tawiden yo ye panakopan a naitaladan kanyo paibat po ha napalhowa ye babe-luta. ");
INSERT INTO abp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta ha nabitlan ako, pinakan yoko. Ha naplangan ako, pinainom yoko. Ha dinumayo ako kanyo, pinadagoh yoko ha baey yo. ");
INSERT INTO abp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ha loh-ok ako, binadowan yoko. Ha naghakit ako, hinayhay yoko. Boy ha napidiho ko, kinewahan yoko.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Haanin, habiyen lan mangatoynong, a wanla, ‘Apo, nakano mi kan nakit a nabitlan, ket pinakan mika? Nakano mi kan nakit a naplangan, ket pinainom mika? ");
INSERT INTO abp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nakano ka dinumayo kammi, ket pinadagoh mika boy nakano ka loh-ok, ket binadowan mika? ");
INSERT INTO abp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nakano met a nakit mi kan ampaghakit, ket hinayhay mika boy nakapidiho, ket kinewahan mika?’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Hiko a Poon, habiyen ko kanla, ‘Pakaleng-en yon manged ye habiyen ko! Ha dinyag yo yati kanlan pinakamaaypa a kakatongno ko, ket dinyag yoyna met kangko.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pangayadi, habiyen ko met kanlan tataon anti ha dapit odi ko, ‘Hikawon tinuboyan nan Apo Dioh, pakataang kawo kangko! Ihtew kawo ha apoy a ahe angkalep a naitaladan kanan Satanas boy kanlan aanghil na. ");
INSERT INTO abp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta ha nabitlan ako, ahe yoko pinakan. Ha naplangan ako, ahe yoko pinainom. ");
INSERT INTO abp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ha dinumayo ako kanyo, ahe yoko pinadagoh ha baey yo. Ha loh-ok ako, ahe yoko binadowan. Ha ampaghakit ako boy nakapidiho, ahe yoko kinewahan.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Haanin, habiyen la met, ‘Apo, nakano mi kan nakit a nabitlan, naplangan, dinumayo kammi, loh-ok, ampaghakit o nakapidiho, ket ahe mi kan hinaglapan?’ ");
INSERT INTO abp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ket ipakibat ko met kanla, ‘Pakaleng-en yon manged ye habiyen ko. Ha ahe yo hila hinaglapan ye pinakamaaypa a kakatongno ko, ket hikoyna ye ahe yo hinaglapan.’ ” ");
INSERT INTO abp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hinabi na po Apo Jesus, “Ulin yati, hilatin tatao, ipalakew ko hila ha kapaduhaan a homain anggaan. Noba hilay mangatoynong, biyan ko hilan bi-ay a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hiyay Apo Jesus, pangayadi nan iadal yatin kaganaan, hinabi na kanlan mānumbong na, ");
INSERT INTO abp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tanda yo a luluwa tanan mangaamot ket Pihtayna nin Pangihipan nin Pangiligtah. Hiko a ibat ha langit a in-Anak nin Tao, ket maigawang lano kanlan tatao a angkahulog kangko ta-omen lako ipako ha kodoh.” ");
INSERT INTO abp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kananyatew a odah, hilay mānguna a papadi boy hilay tutoan Jujudio a mānungkolan, napaytipon hila ha mayadet a baey nan Caifas a pinakapoon a padi, ");
INSERT INTO abp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta ampaytotongtongan la no way-omen laya dakpen ye Apo Jesus a homain kanayon a makatanda haka laya ipapatey. ");
INSERT INTO abp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hinabi la, “Noba ahe tawo igena ha pihta, ta maka magkagulo hilay tatao.” ");
INSERT INTO abp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Anti yay Apo Jesus ha badiyon Betania ha baey nan Simon a kinating hatew. ");
INSERT INTO abp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Legan ampakidungo yay Apo Jesus, hinumaley ya kana ye maghay babayin ampangaget nin pabangon mablin tubat a naikonin ha maghay botin alabahtodo. Ket intiih na yay pabango ha ō nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hilay mānumbong na, ha nakit lay dinyag nan babayi, napoot hila, a wanla, “Taket ta hinayang na yain a pabango? ");
INSERT INTO abp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mailako ya dayi yain ha mayadet a alaga. Ket hiyay mapaglakoan, maibyay kanlan mangaidap.” ");
INSERT INTO abp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Noba tanda nan Apo Jesus ye ampaytotongtongan la. Kaya-bay hinabi na kanla, “Taket ta ampakibalabalaan yo yatin babayi? Manged ye dinyag na kangko. ");
INSERT INTO abp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hilay mangaidap, lanang hilan anti kanyo noba hiko, ahe. ");
INSERT INTO abp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Intiih nay pabango ha laman ko bilang pangitaladan ha pagkailbeng. ");
INSERT INTO abp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pakaleng-en yon manged ye habiyen ko. Agya way-ihtew man a lugal ihti ha babe-luta maipatanda ye Manged a Balita, ket maipatanda ya met ye dinyag nin yatin babayi kangko bilang pangihipan kana.” ");
INSERT INTO abp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Haanin, hiyay Judas Iscariote a magha kanlan labinluway mānumbong nan Apo Jesus, nakew ya kanlan mānguna a papadi. ");
INSERT INTO abp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hinabi na, “Hinyay ibyay yo kangko no haglapan katawon mandakep kanan Jesus?” Nakibat hila, “Biyan mi kan tatlompo a mital.” Haanin, binyanan la yan tatlompo a mital. ");
INSERT INTO abp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Impaibat ana kananyatew, ampangagad yayna nin panaon a mahaglapan na hilan mandakep kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ha unan mangaamot nin Pihtan Tinapay a Homain Pamalbag, hilay mānumbong nan Apo Jesus, ket hinumaley hila kana, a wanla, “Way-ihtew nayi ye labay mon pangitaladanan min pandem ha Pihtan Pangihipan nin Pangiligtah?” ");
INSERT INTO abp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nakibat yay Apo Jesus kanla, “Makew kawo ha banwan Jerusalem kanan taon hinabi ko kanyo. Ket habiyen yo kana, ‘Hinabi nan Maihtodo a madanon ana ye odah na. Ket ihti ha baey mo ye labay na a pandeman ha Pihtan Pangihipan nin Pangiligtah a kadungo na hilay mānumbong na.’ ” ");
INSERT INTO abp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ket hilay mānumbong na, hinumbong la ye bilin nan Apo Jesus. Ket intaladan lay pandeman la ha Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ha madeglem ana, hiyay Apo Jesus boy hilay labinluwan mānumbong na, dinumongo hilaynan mangan ha lamihaan. ");
INSERT INTO abp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Legan ampangan hila, hinabi nan Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Magha lano kanyo ye mangiopit kangko.” ");
INSERT INTO abp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hilay mānumbong na, nalele hila. Ket balang magha kanla, nanepet kana, “Apo, hiko nayi yatew?” ");
INSERT INTO abp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nakibat yay Apo Jesus kanla, “Hiyay kadlan kon ampangidede nin tinapay ha kulo, hiyabay ye mangiopit kangko. ");
INSERT INTO abp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hiko a ibat ha langit a in-Anak nin Tao ket katapulan a matey a omen ha naihulat a Habi nin Dioh. Noba kakaingalo yay taon mangiopit kangko. Mamanged po dayi a ahe yayna nianak.” ");
INSERT INTO abp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Haanin, hiyay Judas a nangiopit kana, nanepet ya met, “Maihtodo, hiko nayi yatew?” Nakibat yay Apo Jesus kana, “Hinabi moyna.” ");
INSERT INTO abp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Legan ampangan hila, hiyay Apo Jesus, nangwa yan tinapay. Ket pinahalamatan naya kanan Apo Dioh. Pangayadi, binih-ilbih-il na haka na inggawang kanlan mānumbong na, a wana, “Kowen yo yati boy kanen yo. Yati ye pinagkalaman ko.” ");
INSERT INTO abp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pangayadi, nangwa ya po nin maghay bahon alak ubah. Pinahalamatan naya kanan Apo Dioh haka na inggawang kanlan mānumbong na, “Hikawon kaganaan, inomen yo yati. ");
INSERT INTO abp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta yati ye pinagkadaya ko a maibuhboh ha kapatawadan nin kakahalanan nin malabong a tatao. Yati ye pamapteg nin bayon kahundoan nan Apo Dioh ha tao. ");
INSERT INTO abp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Habiyen ko kanyo a ahe akoynan minom nin alak ubah angga ha mangaamot a mapagkalamo katawo ha panakopan nan Bapa kon Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ket nagkanta hilan panggalang kanan Apo Dioh. Pangayadi, nakew hilayna ha Mapantay nin Oolibo. ");
INSERT INTO abp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Legan angkumodang hila, hinabi nan Apo Jesus kanlan mānumbong na, “Kananyatin madeglem, hikawon kaganaan, ket lakwanan yoko, ta wanae ye naihulat a Habi nin Dioh, ‘Pateyen ko yay pahtol, ket maahwag hilay tutupa.’ ");
INSERT INTO abp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Noba lano ha mabi-ay akon uman, mauna ko kanyo ha plobinhiyan Galilea.” ");
INSERT INTO abp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Haanin, hinabi nan Pedro kanan Apo Jesus, “Apo, agya lakwanan la kan kaganaan, noba hiko, ahe kata bega lakwanan!” ");
INSERT INTO abp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hinabi nan Apo Jesus kana, “Pakaleng-en mon manged ye habiyen ko kammo. Bayo ya tumnoy ye tandang haanin a madeglem, nikatlo mo koynan imbudi.” ");
INSERT INTO abp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Noba hinabi nan Pedro, “Agya lamo mo kon matey, ahe kata bega ibudi.” Wanabay met ateed ye hinabi lan kaganaan a mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pangayadi, hiyay Apo Jesus boy hilay mānumbong na, nakew hilayna ha lugal a anhabtan Getsemani. Ha niabot hilayna ihtew, hinabi na kanlan mānumbong na, “Mikno kawo ihti, ta makew akon makigwang ihtew.” ");
INSERT INTO abp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inlamo na yay Pedro boy hilay luway aanak nan Zebedeo. Haanin, hiyay Apo Jesus, tubat ye kalelean na boy angkayoot yayna. ");
INSERT INTO abp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hinabi na kanla, “Ba-mon ikamatey koynay kalelean ko. Ihti kawo po boy lamoan yo kon magpoyat.” ");
INSERT INTO abp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ha nitaang yaynan makandi ye Apo Jesus, nilumukob yan nakigwang, a wana, “Bapa ko, no malyadi dayi, alihen mo yatin pamaidap a dihaen ko. Noba aliwan kalabayan ko ye mahumbong, no aliwan hiyay kalabayan mo.” ");
INSERT INTO abp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pangayadi, inudong na hilan Apo Jesus ye tatlon mānumbong na. Ket nalatngan na hilan angkatuloy. Hinabi nan Apo Jesus kanan Pedro, “Ahe yo nayi maikpe ye ahe matuloy, agya maghay odah bengat? ");
INSERT INTO abp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpoyat kawo boy makigwang ta-omen kawo ahe mahambot nin tukho. Ha nakem yo, nakahadya kawon manumbong, noba makapey ye laman yo.” ");
INSERT INTO abp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tinumaang yan uman ye Apo Jesus. Ket nakigwang ya, “Bapa ko, no katapulan a madihaan ko yatin pamaidap, kalabayan mo ye mahumbong.” ");
INSERT INTO abp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pangayadi, inudong na hilayna man ye mānumbong na. Ket nalatngan na hilayna man a angkatuloy, ta makakatuloy hilaynan tubat. ");
INSERT INTO abp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ha ikatlon ukdo, hiyay Apo Jesus, tinumaang yayna man. Ket nakigwang ya nin omen met ateed ha unan pakigwang na. ");
INSERT INTO abp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pangayadi, inudong na hilayna man ye mānumbong na. Ket hinabi na kanla, “Angkatuloy kawo po boy ampagpainawa? Bilewen yo! Naabot ana ye odah a hiko a ibat ha langit a in-Anak nin Tao, ket maigawang kanlan tataon māgkahalanan. ");
INSERT INTO abp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mimata kawo! Tawoyna! Ta anti yayna ye taon nangiopit kangko.” ");
INSERT INTO abp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Legan ampaghabi ya po ye Apo Jesus, hiyay Judas a magha kanlan labinluwan mānumbong na, ket nilumateng yan main lamo a malabong a tataon ampangaget nin keya boy pamadog. Intubol la hilan mānguna a papadi boy tutoan Jujudio a mānungkolan. ");
INSERT INTO abp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yati ye pagkakitan a hinabi nan Judas kanlan kalalamoan na no ayay dakpen la, “Hiyay umaan ko ye dakpen yo.” ");
INSERT INTO abp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ket hiyay Judas, hinaleyan na yay Apo Jesus. Ket hinabi na kana, “Manged a madeglem, Maihtodo.” Ket inumaan nay pingipingi na. ");
INSERT INTO abp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hinabi nan Apo Jesus kana, “Diyagen moyna ye tikih mo.” Haanin, hilay kalalamoan nan Judas, hinaleyan la yaynan dinakep ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ket hiyay magha kanlan mānumbong nan Apo Jesus, binagot nay keya na. Tinaya na yay ipoh nin pinakapoon a padi. Ket napunggohan yan talinga. ");
INSERT INTO abp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hinabi nan Apo Jesus, “Igoma moy keya mo. Ta hiyay ampanggawi nin keya, matey ya met ha keya. ");
INSERT INTO abp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ahe mo nayi tanda a no makigwang ako kanan Bapa kon Dioh, ket tampol nan itubol ye libo-libon anghil na? ");
INSERT INTO abp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Noba no diyagen ko yatew, way-omen po matupad ye anti ha naihulat a Habi nin Dioh a katapulan malyadi?” ");
INSERT INTO abp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Haanin, hiyay Apo Jesus, hinabi na kanlan tatao, “Tolihan ako nayi, ta impangaget yo kon keya boy pamadog? Minamangaamot akon ampangiadal ha mahlang nin Timplo. Taket ta ahe yoko dinakep ihtew? ");
INSERT INTO abp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Noba nalyadi yatin kaganaan ta-omen matupad ye impahulat nan Apo Dioh kanlan popodopita na hatew.” Haanin, hilay kaganaan a mānumbong na, nilakwanan la yay Apo Jesus boy tinumakah hilayna. ");
INSERT INTO abp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pangayadi, inlakew la yay Apo Jesus ha baey nan Caifas a pinakapoon a padi. Ket hilay mamaihtodo nin Bibilin boy tutoan Jujudio a mānungkolan, naytipon hila ihtew. ");
INSERT INTO abp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hiyay Pedro, anhumumbong ya ha aliwan minga mataang. Ket ha anti yayna ha mahlang nin baey nin pinakapoon a padi, nakiikno ya kanlan māgbantay, ta an-imatonan na no hinyay diyagen la kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Haanin, hilay mānguna a papadi boy hilay kaganaan a mānungkolan ha Panuhgaan lan Jujudio, nanapul hilan tihtigo a maghabin katagowan laban kanan Apo Jesus ta-omen laya maipapatey. ");
INSERT INTO abp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Noba homain hilan nakit a hangkan nin pamateyan la kana, agya malabong hilay tihtigo a naghabin katagowan laban kana. Ha kalampuhan, main luway tao a hinumaley. ");
INSERT INTO abp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ket hinabi la, “Yatin tao, hinabi na, ‘Mababa kon agwaten yatin Timplo nan Apo Dioh. Ket ha loob nin tatloy mangaamot, ipaideng ko yan uman.’ ” ");
INSERT INTO abp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Haanin, hiyay pinakapoon a padi, nideng ya. Ket tinepet na yay Apo Jesus, “Homain ka lawen maipakibat ha bada la a laban kammo?” ");
INSERT INTO abp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noba ahe ya nakibat ye Apo Jesus. Ket hinabi nayna man nin pinakapoon a padi, “Ha ngalan nan Apo Dioh a angkabi-ay, habiyen mo kammi haanin no hika ye Cristo a Anak nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nakibat yay Apo Jesus kana, “Hinabi moyna! Ket yati ye habiyen ko kanyon kaganaan. Hiko a ibat ha langit a in-Anak nin Tao, makit yoko a ampikno ha dapit wanan nan Makapalyadiyan a Dioh. Boy ha pag-udong ko, makit yoko ha owep a an-umaypa a ibat ha langit.” ");
INSERT INTO abp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pamakange nan pinakapoon a padi yatew, napoot yan tubat, giniwak nay bado na, ket hinabi na, “Ampahalumbangan na yay Apo Dioh! Ahe tawoyna katapulan nin kanayon po a mamapteg. Nange yoyna a ampahalumbangan na yay Apo Dioh, ta impadiho nay hadili na kana. ");
INSERT INTO abp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hinya awod ye iuhga yo kana?” Nakibat hilay tatao kana, “Katapulan yan matey.” ");
INSERT INTO abp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Haanin, linod-an lay lupa nan Apo Jesus boy dinihmog laya. Legan napedengan ya, tinampaling la yan kanayon ");
INSERT INTO abp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","haka la hinabi kana, “No hika ye Cristo, pal-eban mo man kammi no ayay nanampaling kammo!” ");
INSERT INTO abp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hiyay Pedro, anti yan ampikno ha mahlang nin baey nan pinakapoon a padi. Haanin, main met maghay babayi ihtew a ipoh. Hinumaley yan naghabi kana, “Kalamo naka met Jesus a taga Galilea.” ");
INSERT INTO abp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Noba hiyay Pedro, imbudi naya ha adapan lan kaganaan a anti ihtew, a wana, “Ahe ko tanda ye anhabiyen mo.” ");
INSERT INTO abp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Haanin, hiyay Pedro, nakew ya ha gilid ilwangan nin alad. Ket nakit yan kanayon a babayin ipoh. Hinabi nan babayi kanlan tataon anti ihtew, “Yatin tao, kalamo na yay Jesus a taga Nazaret.” ");
INSERT INTO abp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ket imbudi na yayna man Pedro, “Agya matey ako, ahe koya katatanda yain a tao!” ");
INSERT INTO abp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ha ahe nabuyot, hilay tataon anti ihtew a ampideng, hinumaley hila kanan Pedro. Ket hinabi la kana, “Petegbay a magha ka met kanlan kalamo nan Jesus, ta angkatandaan miya ha paghabi mo.” ");
INSERT INTO abp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hiyay Pedro, hinabi na, “Hi, ahe! Agya matey ako haanin, ahe koya katatanda yain a tao.” Kapipikhaan, tinumnoy yay tandang. ");
INSERT INTO abp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ket naihipan nay hinabi nan Apo Jesus hatew, “Bayo ya tumnoy ye tandang, ket nikatlo mo koynan imbudi.” Ket hiyay Pedro, inumalih ya ha mahlang. Ket tinumangih yan malaem. ");
INSERT INTO abp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kabekahan, ha mahanibhanib po, hilay kaganaan a mānguna a papadi boy hilay tutoan Jujudio a mānungkolan, naytongtongan la no way-omen la yan ipapatey ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Binalol lay gamet nan Apo Jesus. Ket inlakew laya kanan Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Haanin, hiyay Judas Iscariote a nangiopit kanan Apo Jesus, ha natandaan nan nauhgaan yan matey ye Jesus, naghehe ya ha dinyag na. Kaya-bay in-udong nay tatlompo a mital kanlan mānguna a papadi boy kanlan tutoan Jujudio a mānungkolan. ");
INSERT INTO abp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hinabi na kanla, “Nagkahalanan ako, ta in-opit ko yay maghay taon homain kahalanan.” Noba hinabi la kana, “Hi! Baala ka payna ha hadili mo. Homain kayinan pakibalabalaan kammo.” ");
INSERT INTO abp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Haanin, hiyay Judas, inhabol nay tatlompo a mital ihtew ha Timplo. Pangayadi, inumalih yayna. Ket nagbikke ya. ");
INSERT INTO abp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ket hilay mānguna a papadi, pinulot lay mital boy hinabi la, “Ahe tawo malyadin ikonin yati ha pangikunaan nin pilak ha Timplo, ta bayad nin bi-ay nin maghay tao yati. Ket bawal yain ha Bibilin.” ");
INSERT INTO abp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kaya-bay napaykahundoan la a ihaliw laynan bengat nin luta nan mānyag nin koden, ta diyagen lan pangilbengan nin nangamatey a dadayohan. ");
INSERT INTO abp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kaya-bay anggayna haanin, yatin luta ket anhabtan yan “Luta nin Daya.” ");
INSERT INTO abp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ha wanabay, natupad ye hinabi nan podopita Jeremias hatew, a wanae, “Kingwa lay tatlompo a mital, ta yati ye napaykahundoan lan Israelita a alaga nin bi-ay na. ");
INSERT INTO abp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ket inhaliw lan luta nan mānyag nin koden, ta yatew ye imbilin nan Apo Dioh kangko.” ");
INSERT INTO abp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ket ha in-adap la yaynay Apo Jesus kanan Gobilnadol Pilato, tinepet naya, “Hika nayi ye Poon lan Jujudio?” Nakibat yay Apo Jesus, “Hikaynay naghabi.” ");
INSERT INTO abp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Noba ha binadaan la yan tutoan Jujudio a mānungkolan boy mānguna a papadi ye Apo Jesus, ahe yan bega nakibat. ");
INSERT INTO abp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kaya-bay hiyay Gobilnadol Pilato, tinepet na yayna man, “Malabong ye bada la laban kammo. Ahe mo nayi nange?” ");
INSERT INTO abp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Noba hiyay Apo Jesus, ahe ya nakibat. Kaya-bay nagtaka yan tubat ye Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hiyay Gobilnadol Pilato, tepe Pihtan Pangihipan nin Pangiligtah, ket ugali nayna ye mamalihway nin maghay pidiho a awoken lan tatao. ");
INSERT INTO abp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ket kananyain a panaon, main met maghay pidiho a nagngalan Barabbas a kamatandaan ha panyag na nin maloke. ");
INSERT INTO abp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ha naytitipon hilayna ye tatao, nanepet yay Gobilnadol Pilato kanla, “Ayay labay yon palihwayen ko? Hiyay Barabbas o hiyay Jesus a anhabtan Cristo?” ");
INSERT INTO abp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wanabay ye tepet nan Gobilnadol Pilato, ta tanda na a inlakew la yay Apo Jesus kana uli ha ibeg la. ");
INSERT INTO abp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Haanin, legan ampikno ya po ye Gobilnadol Pilato ha pamiknoan nin mānuhga, impahabi nan ahawa na kana ye wanae, “Adi mo ampakibalabalaan yain a taon homain kahalanan, ta nanaynep ako. Ket ha taynep ko, angkayoot akon tubat uli kana.” ");
INSERT INTO abp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Noba hilay mānguna a papadi boy hilay tutoan Jujudio a mānungkolan, inggaygay la hilay malabong a tatao a hiyay Barabbas ye awoken lan palihwayen nan Gobilnadol Pilato. Ket hiyay Apo Jesus, ipapatey naya. ");
INSERT INTO abp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Haanin, hiyay Gobilnadol Pilato, tinepet na hilayna man, “Aya kanlan luwa ye labay yon palihwayen ko?” “Hiyay Barabbas,” wanla. ");
INSERT INTO abp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tinepet na hilayna man, “Hinya awod ye diyagen ko kanan Jesus a anhabtan Cristo?” Nakibat hilan kaganaan, “Ipako ya ha kodoh!” ");
INSERT INTO abp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Taket? Hinyay kalok-an a dinyag na?” wanan Gobilnadol Pilato. Noba lalo layna ingat impakakhaw ye nangha, a wanla, “Ipako ya ha kodoh!” ");
INSERT INTO abp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ha naimatonan nan Gobilnadol Pilato a homain yaynan madyag, ta angkagulo hilaynay tatao, namakwa yan lanom. Ket inuyahan nay gamet na ha adapan lan tatao boy hinabi na, “Homain akon pakibalabalaan ha pagkamatey na yatin tao. Hikawoy makibat.” ");
INSERT INTO abp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nakibat hilay tatao, “Awo, hikayi boy hilay aanak mi ye makibat ha pagkamatey na.” ");
INSERT INTO abp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Haanin, hiyay Gobilnadol Pilato, pinalihway na yay Barabbas. Noba hiyay Apo Jesus, impalatiko naya haka na inggawang kanlan huhundaloh ta-omen laya ipako ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Haanin, hilay huhundaloh, inlakew la yay Apo Jesus ha palahyo nan Gobilnadol. Ket pinalibotan la yan kaganaan a kalalamoan lan huhundaloh. ");
INSERT INTO abp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niloh-okan la yay Apo Jesus haka la yan pinabadowan nin kadih matibya a omen ha badon poon. ");
INSERT INTO abp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nangwa hilan kawat a madiwi. Ket dinyag la yan ba-mon kodona haka la ingkodona kana. Boy pinagemgeman laya po ha dapit wanan gamet na nin tambo a ba-mon teken nin poon. Pangayadi, nanalimukod hila ha adapan na haka la yan inlungolungo, a wanla, “Yehey! Minged ye Poon lan Jujudio!” ");
INSERT INTO abp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pangayadi, linulud-an laya boy kingwa lay pinagkateken na haka la piuman-uman a pinatok ye ō na. ");
INSERT INTO abp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pangayadi la yan inlungolungo ye Apo Jesus, niloh-ok la ye impabado la kana haka la yan imbadon uman kana ye bado na. Pangayadi, inlakew laya ha ilwah nin banwa ta-omen la yayna ipako ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ha anlumwah hilayna ha banwa, nahagana la yay maghay laki a nagngalan Simon a taga Cirene. Ket impilit lan impabatay kana ye pagkodoh nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ket niabot hila ha lugal a anhabtan Golgotha. Hiyay labay habiyen, “Lugal nin Bungo.” ");
INSERT INTO abp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hiyay Apo Jesus, binyan la yan alak a nahalean aplo. Noba ha natawayan naya, ahe na in-itlen. ");
INSERT INTO abp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hilay huhundaloh, ha impako la yaynay Apo Jesus ha kodoh, pinaydadakayan lay babado na makauli ha pandaw-an ta-omen la matandaan no ayay makwa nin magha boy magha kanla. ");
INSERT INTO abp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pangayadi, nikno hila, ta bantayan la yaynay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ket ha dapit tagay nin ō na, nangikonin hila nin nakaihulatan nin bada kana a wanae, “YATI YE JESUS A POON LAN JUJUDIO.” ");
INSERT INTO abp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Main met luway tulihan a kadlan nan Apo Jesus a impako la ha timaghay kodoh. Hiyay magha, ha dapit wanan na. Ket hiyay magha met, ha dapit odi na. ");
INSERT INTO abp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hilay tataon anhumapid ihtew, ampameyeng-peyeng hilan ampangilungolungo kana, a wanla, ");
INSERT INTO abp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Aliwa nayi a hinabi mo a agwaten moy Timplo, ket ha loob nin tatloy mangaamot, ipaideng mo yan uman? Higi man awod! No peteg a hika ye Anak nin Dioh, lumumbah ka man ihen ha kodoh, ta iligtah moy hadili mo!” ");
INSERT INTO abp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hilay mānguna a papadi, mamaihtodo nin Bibilin boy tutoan Jujudio a mānungkolan, an-ilungolungo laya met, a wanla, ");
INSERT INTO abp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nangiligtah yan kanayon, noba ahe na mababa a iligtah ye hadili na. Aliwa nayi a hiya ye Poon nin Israel? No makalumbah ya ihen ha kodoh, mamteg kayina kana. ");
INSERT INTO abp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Napataya ya kanan Apo Dioh boy anhabiyen na a hiyabay ye Anak nin Dioh. Higi man awod, bilewen tawo man no peteg a iligtah na yan Apo Dioh haanin.” ");
INSERT INTO abp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ket agya hilay tutulihan a kadlan nan naipako ha kokodoh, ket inlungolungo laya met ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ha kauugtowan ana, nilumiteh yan kaganaan yatew a lugal anggayna ha alah tidih nin mahilem. ");
INSERT INTO abp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ha alah tidih ana nin mahilem, nangha yan makhaw ye Apo Jesus ha habin Aramaic, a wana, “Eli, Eli, lema sabachthani?” Hiyay labay habiyen, “Dioh ko, Dioh ko, taket ta pinaolayan moko?” ");
INSERT INTO abp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pamakange la yatew nin tatao a ampideng ihtew, hinabi la, “An-ingaten na yay podopita Elias.” ");
INSERT INTO abp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hiyay magha kanla, nayew yan nangwa nin ihpongha haka na indede ha maahem a alak haka na inhipit ha tampoh nin palat haka na impahephep kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Noba hinabi lan kanayon, “Paolayan moya, ta bilewen tawo man no lumateng yay Elias ta-omen naya iligtah.” ");
INSERT INTO abp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Haanin, hiyay Apo Jesus, nangha yayna man nin makhaw. Pangayadi, naboytoan yaynan angeh. ");
INSERT INTO abp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ket kananyatew met ateed, hiyay makugpan tabing ha loob nin Timplo, ket nagiwak yan nagitna paibat ha tagay anggan aypa. Nanlayon boy nangapapaka ye dadapah. ");
INSERT INTO abp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nangalukatan ye bibito boy nabi-ay hilan uman ye malabong a pagtao nin Dioh a nangamatey hatew. ");
INSERT INTO abp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ket nilumwah hila ha bibito. Ket ha nabi-ay yan uman ye Apo Jesus, nakew hila ha banwan Jerusalem. Ket malabong a tatao ye nakakit kanla. ");
INSERT INTO abp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ket hiyay kapitan boy hilay huhundaloh na a ampagbantay kanan Apo Jesus, ha nanlayon boy ha nakit lay kaganaan a nalyadi, nalimowan hilan tubat. Kaya-bay hinabi la, “Petegbay a Anak yan Dioh!” ");
INSERT INTO abp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ha aliwan minga mataang, main malabong a babayi ye ampangimaton nin angkalyadi kanan Apo Jesus. Hilabay ye hinumumbong boy naghilbi kana paibat ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kabilang kanla ye Maria a taga Magdala, Maria a indo nan Santiago boy Jose boy hiyay ahawa nan Zebedeo. ");
INSERT INTO abp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ket ha andudumeglem ana, nilumateng yay maghay mabatnang a tao a nagngalan Jose a taga Arimatea. Magha ya met a mānumbong nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nakew ya kanan Gobilnadol Pilato boy inawok na kana a hiyayna ye mangilbeng ha bangkay nan Apo Jesus. Ket imbilin na met nin Gobilnadol Pilato a ibyay la kana. ");
INSERT INTO abp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaya-bay kingwa naynan Jose ye bangkay. Ket pinutot na yan tapih a lino a malinih ");
INSERT INTO abp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","haka na in-ihlep ha bayon inyukib a pangilbengan. Pangayadi, intulin naynan inleneb ye mayadet a dapah ha ilwangan nin pangilbengan haka ya inumalih. ");
INSERT INTO abp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hiyay Maria a taga Magdala boy hiyay maghay Maria, anti hila met ihtew a ampikno ha adapan nin pinangilbengan. ");
INSERT INTO abp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kabekahan ha Mangaamot nin Pagpainawa, hilay mānguna a papadi boy hilay Papariseo, nakew hila kanan Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ket hinabi la, “Gobilnadol, naihipan mi a ha angkabi-ay ya po yain a mānalingo, hinabi na, ‘Pangalabah nin tatloy mangaamot, mabi-ay akon uman.’ ");
INSERT INTO abp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kaya-bay awoken mi kammo a bilinan mo hilay huhundaloh mo a pakabantayan la yan manged ye nangilbengan kana anggan malabah ye tatloy mangaamot. Ta maka takawen la yan mānumbong na ye bangkay na haka la ibalita a nabi-ay yan uman. No wanabay ye malyadi, ket lumalo yatin panalingo dinan ha una.” ");
INSERT INTO abp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Noba hinabi nan Gobilnadol Pilato kanla, “Kokawoyna. Mangwa kawon huhundaloh boy pabantayan yon manged ye nangilbengan.” ");
INSERT INTO abp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ket nakew hilayna ha nangilbengan. Ha niabot hilayna ihtew, minalkaan la yay dapah a pinanleneb ha nangilbengan ta-omen la matandaan no main manlukat. Boy nangibantak hila nin nangaanon bantay. ");
INSERT INTO abp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pangalabah nin Mangaamot nin Pagpainawa, ha pahanib nin Dominggo, hiyay Maria a taga Magdala boy hiyay maghay Maria, nakew hila ha nangilbengan kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Haanin, kapipikhaan nanlayon nin makhaw, ta hiyay anghil nin Dioh, inumaypa yan ibat ha langit. Ket intulin na yay mayadet a dapah a pinanleneb ha nangilbengan haka naya iniknoan. ");
INSERT INTO abp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hiyay lupa na, ampakapulag ya a ba-mon henag kilat boy hiyay bado na, tubat ye kaputian. ");
INSERT INTO abp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ket hilay māgbantay, ha nakit la yay anghil, namigpig hilan nangapuang a ba-mon natey, uli ha tubat a limo la. ");
INSERT INTO abp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Haanin, hiyay anghil, hinabi na kanlan babayi, “Adi kawo angkalimo. Tanda ko a antapulen yo yay Apo Jesus a impako ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ahe yayna ihti. Nabi-ay yaynan uman a omen ha hinabi na kanyo hatew. Higi, makew kawo ihti, ta bilewen yoy nangikunaan nin bangkay na. ");
INSERT INTO abp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kokawoyna kanlan mānumbong na, ta habiyen yo kanla a nabi-ay yaynan uman boy muna yayna ha Galilea. Ihtewbay yo yayna makit. Wanabay tana ye mahabi ko kanyo.” ");
INSERT INTO abp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Haanin, tampol hilaynan inumalih ha nangilbengan. Ket agya angkalimo hila, angkaaliket hila uli ha imbalita nin anghil. Nayew hilan nakew kanlan mānumbong nan Apo Jesus ta-omen la ibalita ye nalyadi. ");
INSERT INTO abp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Legan ampayew hila, hinagana na hilan Apo Jesus. Hinabi na kanla, “Kumohta kawoyna?” Hinumaley hila kana. Ket ginemgeman lay bitih na a nanggalang kana. ");
INSERT INTO abp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Haanin, hinabi nan Apo Jesus kanla, “Adi kawo angkalimo. Kokawoyna kanlan kakatongno ko. Ket habiyen yo kanla a makew hilayna ha Galilea. Ket ihtew lako makit.” ");
INSERT INTO abp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pamikuyot lan luway babayi, hilay ano kanlan māgbantay ha nangilbengan, ket nakew hila met ha banwan Jerusalem. Ket imbalita la kanlan mānguna a papadi ye kaganaan a nalyadi. ");
INSERT INTO abp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Haanin, hilay mānguna a papadi, nakitipon hila kanlan tutoan Jujudio a mānungkolan. Ket naytotongtongan la a oy-oyen la hilan mayadet a alaga nin pilak ye māgbantay. ");
INSERT INTO abp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hinabi la kanla, “Ibalita yo a legan angkatuloy kawo ha madeglem, nilumateng hilay mānumbong nan Jesus. Ket tinakaw la yay bangkay na. ");
INSERT INTO abp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ket no matandaan nan Gobilnadol yati, hikayinay baala a mangipalinaw kana ta-omen kawo ahe mapano.” ");
INSERT INTO abp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Haanin, hilay māgbantay, tinanggap lay mayadet a alaga nin pilak a pinangoy-oy la kanla. Pangayadi, hinabi la met nin māgbantay ye impahabi la kanla. Kaya-bay angga haanin, wanabay po ye anhabiyen lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Haanin, hilay labinmaghan mānumbong nan Apo Jesus, nakew hilayna ha Galilea ha mapantay a hinabi nan Apo Jesus a lakwen la. ");
INSERT INTO abp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ket ha nakit la yay Apo Jesus, nanggalang hila kana. Noba main nangaano kanla ye ampagluwaluwa a hiyabay ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Haanin, hiyay Apo Jesus, hinumaley ya kanla. Ket hinabi na, “In-ibyay nayna kangkon Bapa ko ye kaganaan a kapalyadiyan ha langit boy ihti ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaya-bay lakwen yo hilay tatao ha kaganaan a nanahyon ihti ha babe-luta, ket diyagen yo hilan mānumbong ko. Bawtihmowan yo hila ha ngalan nan Bapa, Anak, boy Ihpiditon Dioh. ");
INSERT INTO abp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Adalan yo hilan manumbong ha kaganaan a imbilin ko kanyo. Pakaihipen yo yati. Lanang yo kon kalamo angga ha kalampuhan nin babe-luta.”");
INSERT INTO abp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Yati ye Manged a Balita a tungkol kanan Apo Jesu Cristo a Anak nin Dioh. Nandugi ya ha natupad ye inhulat nan podopita Isaias a diyagen na lanon Apo Dioh, “Mangitubol akon māngihabi ko a mauna kammo ta-omen na italadan ye danan mo. ");
INSERT INTO abp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hiyabay ye ampangipangha ha wangwang nin wanae, ‘Ihadya yoy dān nan Apo. Itoynong yoy pagdanan na.’ ” ");
INSERT INTO abp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ket natupad yati ha nilumateng yay Juan ha wangwang a ampangipatanda nin wanae, “Paghehean boy itgen yoynay panyag nin kahalanan boy pabawtihmo kawo ta-omen na kawo patawaden Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ket malabong a tatao ye nakew kana a taga banwan Jerusalem boy kaganaan a lulugal ha plobinhiyan Judea. Ket inhabi lay kakahalanan la. Kaya-bay binawtihmowan na hilan Juan ha kabatowan nin Jordan. ");
INSERT INTO abp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hiyay bado nan Juan, ket yadi ha labok nin kamelyo. Boy hiyay akeh na, yadi met ha katat ayop. Hiyay pamangan na ket kowangey boy pulot panilan. ");
INSERT INTO abp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yati ye an-ipatanda na, “Main taon lumateng a igit a makapalyadiyan dinan ko, ta agya mangaget bengat nin hapatoh na, ket ahe ako katanggap-tanggap. ");
INSERT INTO abp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bawtihmowan katawo nin lanom. Noba hiya, bawtihmowan na kawo nin Ihpiditon Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kananyatew a panaon, legan ampamawtihmo yay Juan ha kabatowan nin Jordan, nilumateng yay Apo Jesus ihtew a ibat ha banwan Nazaret ha plobinhiyan Galilea. Ket binawtihmowan na yan Juan. ");
INSERT INTO abp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ha an-umawah yaynay Apo Jesus ha lanom, nakit na a ba-mon naglukat ye langit. Ket hiyay Ihpiditon Dioh ha kadih kalapati, inumaypa yan inumapon kana. ");
INSERT INTO abp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ket main bihnga a nangibat ha langit a naghabi nin wanae, “Hika ye Anak kon ampakaadoen ko a angkaaliketan kon tubat.” ");
INSERT INTO abp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ket kananyatew met ateed, hiyay Apo Jesus, impalakew na yan Ihpiditon Dioh ha wangwang. ");
INSERT INTO abp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ket apatapo a mangaamot a antukhoen na yan Satanas ihtew. Ket main met mangatubag a aayop ihtew boy main met aanghil nin Dioh a nangalingay kana. ");
INSERT INTO abp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ha napidiho yaynay Juan, hiyay Apo Jesus, nakew ya ha plobinhiyan Galilea. Ket impatanda na ihtew ye Manged a Balita a ibat kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nilumateng anay naitaning a panaon a mamoon yaynay Apo Dioh. Kaya-bay paghehean boy itgen yoynay panyag nin kahalanan boy pamtegan yoy Manged a Balita,” wanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ha maghay mangaamot, legan angkumodang yay Apo Jesus ha ambay dagatdagatan nin Galilea, nakit na hilay mikatongno a nagngalan Simon boy Andres a ampangikatkat nin higay la, ta mānlapet hila. ");
INSERT INTO abp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Kilakew kawo kangko,” wanan Apo Jesus, “ta diyagen katawoynan māngumbinyo nin tatao a mamteg kangko a ba-mo kawon ampanlapet nin malanghit.” ");
INSERT INTO abp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ket tampol laynan nilakwanan ye higay la boy nakilakew hilayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","Inhulong nan Apo Jesus ye pangumodang na. Ha aliwan minga mataang, anti yay Santiago boy Juan a lamo la yay bapa la a Zebedeo a ampangayuma nin higay ha bangka la. Ket ha nakit na hilan Apo Jesus, hinagyat na hilan makilakew kana. Haanin, hilay mikatongno, nilakwanan la yay bapa la ha bangka boy hilay tataon an-upaan. Ket nakilakew hilayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Haanin, hiyay Apo Jesus boy kalalamoan na, nakew hila ha banwan Capernaum. Ha naabot anay Mangaamot nin Pagpainawa, nakew hila ha pāytiponan lan Jujudio. Ket hiyay Apo Jesus, nangiadal ya ihtew. ");
INSERT INTO abp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nagtaka hilay tatao ha pangiadal na, ta main yan kapalyadiyan ha pangiadal na, aliwan omen ha pangiadal lan mamaihtodo nin Bibilin. ");
INSERT INTO abp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ket legan ampangiadal ya, main maghay taon hinelpan nin maloke a ihpidito ye ");
INSERT INTO abp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nangha nin wanae, “Aya ka nayi kammi, Jesus a taga Nazaret? Nakew ka nayi ihti ta-omen mo kayi apoen? Tanda ko no aya ka! Hika ye Pinili nan Apo Dioh a intubol na!” ");
INSERT INTO abp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Noba pinaghabiyan na yan Apo Jesus, “Pakal-em ka! Umalih kayna kana!” ");
INSERT INTO abp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ket haanin, hiyay maloke a ihpidito, pinapigpig na yay laki boy angkumolih yan an-umalih kana. ");
INSERT INTO abp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ket nagtaka hilay kaganaan a anti ihtew. Kaya-bay napaytepet-tepet hila, “Hinyati? Bayon adal a main kapalyadiyan! Ampaalihen nay mangaloke a ihpidito, ket an-umalih hila met!” wanla. ");
INSERT INTO abp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ket hiyay balita tungkol kanan Apo Jesus, mapadah yan nitayak ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hiyay Apo Jesus boy kalalamoan na, ha inumalih hilayna ha pāytiponan lan Jujudio, nakew hila ha baey lan Simon boy Andres. Hiyay Santiago boy hiyay Juan, nakilakew hila met kanla. ");
INSERT INTO abp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ha nilumateng hilayna ihtew, tampol lan hinabi kanan Apo Jesus a hiyay babayi a ampo nan Simon, ket ampida ya, ta angkahalot ya. ");
INSERT INTO abp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Haanin, hinaleyan na yan Apo Jesus ye angkahalot, ket ginemgeman nay gamet na boy in-imata naya. Ket nitaah yayna. Ket inapagan na hilayna. ");
INSERT INTO abp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kananyatew met ateed a mangaamot, ha nitanghob yaynay mangaamot, malabong a ampaghakit boy hinelpan nin mangaloke a ihpidito ye inlakew la kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ket hilay tatao nin yatew a banwa, naytipon hila ha adapan nin baey. ");
INSERT INTO abp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ket malabong hilay tataon ampaghakit nin nakahinadi ye pinaitaah nan Apo Jesus. Malabong met a mangaloke a ihpidito ye pinaalih na kanlan hinelpan la. Noba binawalan na hilay mangaloke a ihpidito a maghabi, ta tanda la a hiyabay ye Anak nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kabekahan, ha palbangon po, inumalih yay Apo Jesus ha baey. Ket nakew yan nakigwang ha wangwang. ");
INSERT INTO abp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Haanin, hiyay Simon boy kalalamoan na, tinapul la yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ha nakitan la yayna, hinabi la kana, “Antapulen la kan malabong a tatao!” ");
INSERT INTO abp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Noba hinabi nan Apo Jesus kanla, “Lakwen tawo po ye dongla a babanwa ta-omen ko met ipatanda kanla ye Manged a Balita, ta yabayti ye nakaitubolan ko ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ket hiyay Apo Jesus, nakew yan nangipatanda nin Manged a Balita ha pāytiponan lan Jujudio ha kaganaan a lulugal ha plobinhiyan Galilea boy namaalih nin mangaloke a ihpidito kanlan hinelpan la. ");
INSERT INTO abp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Main maghay lakin kinating ye hinumaley kanan Apo Jesus. Nanalimukod yan nakiiingalo kana, a wana, “Apo, no labay mo, mapaitaah moko.” ");
INSERT INTO abp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nalunoh yay Apo Jesus kana. Kaya-bay kinimpaan naya boy hinabi na, “Awo, labay ko. Mitaah kayna!” ");
INSERT INTO abp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ket tampol yan naalih ye kating na. Ket niluminih anay luti na. ");
INSERT INTO abp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Haanin, hiyay Apo Jesus, binilinan boy pinaalih na yaynan tampol ye laki, a wana, ");
INSERT INTO abp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Adi mo anhabiyen ha ayaman ye nalyadi kammo, no aliwan makew ka tana ha padi. Ket ipabilew moy luti mo kana. Pangayadi, mangihagpa ka nin omen ha imbilin nan Moises bilang pamapteg a nitaah kayna.” ");
INSERT INTO abp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Noba ha inumalih yayna, imbabalita nan teed ye nalyadi kana. Kaya-bay hiyay Apo Jesus, ahe yayna makalakew ha babanwa, ta ampaypapaletpetan la yan tatao. Kaya-bay ihtew yaynan bengat ha wangwang. Noba nilakew la yan teed nin tatao a ibat ha kanayon a lulugal. ");
INSERT INTO abp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pangalabah nin nangaanon mangaamot, hiyay Apo Jesus, nag-udong ya ha banwan Capernaum. Ket nabalitaan lan tatao a anti yayna ha baey a ampagdagohan na. ");
INSERT INTO abp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kaya-bay napaytipon ye malabong a tatao ha baey a angkunaan na. Ket homain anan letletan, agya ha ilwah nin ilwangan. Ket legan an-ipatanda nan Apo Jesus ye Manged a Balita, ");
INSERT INTO abp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","main nilumateng a apat a kataon ampanambayok nin lakin lumpo, ta ilakew laya kana. ");
INSERT INTO abp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Noba uli ha kalabong nin tatao, ahe laya maihaley kanan Apo Jesus. Kaya-bay nanik hila ha bobongan nin baey. Ket nanlabkat hilan atep ha eteb nan Apo Jesus a nangiloyloyan la kanan lakin lumpo ha adapan na. ");
INSERT INTO abp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ha nakit nan Apo Jesus ye kayadet nin pamteg la kana, hinabi na kanan lumpo, “Inong, napatawad anay kakahalanan mo.” ");
INSERT INTO abp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Main met nangaanon mamaihtodo nin Bibilin ye anti ihtew. Pamakange lay hinabi nan Apo Jesus, ket inihip lay wanae, ");
INSERT INTO abp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Taket ta wanabay ye anhabiyen na yatin tao? Ampahalumbangan na yay Apo Dioh, ta homain anan ayaman a makapatawad nin kakahalanan no aliwan hiyay Apo Dioh bengat!” ");
INSERT INTO abp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Noba hiyay Apo Jesus, tanda nay an-ihipen la. Kaya-bay hinabi na kanla, “Taket ta wanabay ye ihip yo? ");
INSERT INTO abp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Matataloh a habiyen kananyatin lumpo, ‘Napatawad kayna ha kakahalanan mo’, ta ahe yo makit no napatawad o ahe. Noba habiyen ko kana, ‘Mideng ka, kadten moy inid-an mo boy kumodang kayna’ ");
INSERT INTO abp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ta-omen yo makit a hiko a ibat ha langit a in-Anak nin Tao ket main kapalyadiyan a mamatawad nin kakahalanan ihti ha babe-luta.” Ket hinabi na kanan lumpo, ");
INSERT INTO abp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mideng ka. Ket kadten moy apay mo, ta muli kayna.” ");
INSERT INTO abp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ket nideng yay lumpo, kinaget nayna ye apay na boy nilumwah ya ha baey a ambilewen nin kaganaan. Nagtaka hilan kaganaan. Ket inggalang la yay Apo Dioh, a wanla, “Yoh! Haanin kayin bengat nakakit nin wanabay!” ");
INSERT INTO abp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Haanin, hiyay Apo Jesus, nakew yayna man ha ambay dagatdagatan nin Galilea. Nilakew la yan malabong a tatao. Ket inadalan na hila. ");
INSERT INTO abp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Legan angkumodang ya, nakit na yay Levi a māningil nin bowih a anak nan Alfeo. Ampikno yay Levi ha pamayadan nin bowih. Ket hinabi nan Apo Jesus kana, “Kilakew ka kangko.” Ket nideng ya met ye Levi boy nakilakew ya kana. ");
INSERT INTO abp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hinagyat na hilan Levi ye Apo Jesus boy mānumbong na a makew mangan ha baey na. Malabong a māningil nin bowih boy kanayon a naibilang a māgkahalanan ye nakidungon mangan kanan Apo Jesus boy kanlan mānumbong na, ta malabong hilay anhumumbong kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Main met mamaihtodo nin Bibilin a Papariseo ihtew. Ket ha nakit la yay Apo Jesus a ampakidungo kanlan māningil nin bowih boy kanlan kanayon a naibilang a māgkahalanan, tinepet la hilay mānumbong na, “Taket ta ampakidungo yan mangan kanlan māningil nin bowih boy kanlan kanayon a māgkahalanan?” ");
INSERT INTO abp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pamakange nan Apo Jesus nin tepet la, hinabi na kanla, “Hilay homain hakit, ahe la katapulan ye doktol, no aliwan hilay ampaghakit ye ampagkatapulan. Nakew ako ihti a managyat kanlan māgkahalanan, aliwa kanlan tataon ampangibaan nin hadili la a matoynong.” ");
INSERT INTO abp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Minghan, legan ampagpalta hilan mangan ye mānumbong nan Juan a Māmawtihmo boy mānumbong lan Papariseo, main nangaanon tatao ye nakew nanepet kanan Apo Jesus nin wanae, “Hilay mānumbong nan Juan boy mānumbong lan Papariseo, ket ampagpalta hilan mangan. Noba hilay mānumbong mo, ket ahe?” ");
INSERT INTO abp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Inlalayi nan Apo Jesus ye hadili na ha maghay lakin nagkahal, a wana, “Legan kalamo laya po nin kinumbida ha poniyan ye lakin nagkahal, ahe hila malyadin magpaltan mangan, kali? ");
INSERT INTO abp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Noba maabot lano ye panaon a maialih kanla ye lakin nagkahal. Ket kananyatew hila po magpaltan mangan uli ha kalelean la.” ");
INSERT INTO abp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hinabi na po Apo Jesus, “Homain taon mangitakop nin bayon tapih ha alan a bado. Ta no wanabay ye diyagen na ket mailbah, magkotet yay bayon tapih, ket lalo yayna ingat umway ye ginit nin alan a bado. ");
INSERT INTO abp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Homain met taon mangikonin nin bayon alak ha alan a kubot a katat, ta lumtoh yay alan a katat. Ha wanabay, padiho hilayna lanon mahayang. No aliwan hiyay bayon alak, ket katapulan a ikonin ya ha bayon kubot a katat.” ");
INSERT INTO abp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ha maghay Mangaamot nin Pagpainawa, nipadān hilan Apo Jesus ha katidigowan. Ket legan ampagdān hila ihtew, hilay mānumbong na, nante hilan tidigo. Ket an-itatangay lan antim-en. ");
INSERT INTO abp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Haanin, main met Papariseo ihtew a nakakit kanla. Kaya-bay hinabi lan Papariseo kanan Apo Jesus, “Bilewen moy andiyagen lan mānumbong mo. Ampante hilan tidigo. Ket bawal yain ha Mangaamot nin Pagpainawa!” ");
INSERT INTO abp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hinabi nan Apo Jesus, “Ahe yo nayi nabaha ye dinyag nan David hatew? Ha nabitlan ya boy hilay kalalamoan na ta homain hilan makan, ");
INSERT INTO abp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","hinumlep ya ha Toldan Panggalangan kanan Apo Dioh. Ket nangwa yan tinapay a inhagpa kanan Apo Dioh. Kinan na boy pinakan na hila met ye kalalamoan na. Noba ahe ya nagkahalanan agya po man bawal yatew ha Bibilin, ta hilay papadi bengat ye malyadin mangan nin inhagpa kanan Apo Dioh. Nalyadi yati ha panaon a hiyay Abiatar ye pinakapoon a padi.” ");
INSERT INTO abp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hinabi na po Apo Jesus, “Dinyag na yan Apo Dioh ye Mangaamot nin Pagpainawa ha ikanged nin tao. Ahe na yan pinalhowa ye tao ha ikanged nin Mangaamot nin Pagpainawa. ");
INSERT INTO abp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaya-bay hiko a ibat ha langit a in-Anak nin Tao, ket main kapalyadiyan a mangihabi no hinyay huhton diyagen ha Mangaamot nin Pagpainawa.” ");
INSERT INTO abp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ha maghay Mangaamot nin Pagpainawa, nakew yayna man ye Apo Jesus ha pāytiponan lan Jujudio. Main maghay laki ihtew a kinumpit ye maghay gamet na. ");
INSERT INTO abp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Main tatao ihtew a ampagbantay no paitaahen na yan Apo Jesus ha Mangaamot nin Pagpainawa. Ta no diyagen na yain, ket main hilaynan pangidaloman kana. ");
INSERT INTO abp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hinabi nan Apo Jesus kanan laki a kinumpit ye gamet na, “Makew ka ihti ha adapan.” ");
INSERT INTO abp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pangayadi, tinepet na hilay tatao, “Hinyay an-ipaluboh nin Bibilin a malyadin diyagen ha Mangaamot nin Pagpainawa? Manyag nayin manged o maloke? Mangiligtah nayi o mamatey?” Noba nilong-em hilan bengat. ");
INSERT INTO abp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Angkapoot ya boy angkalelean na hilan binilew ye kaganaan uli ha kabyangan nin ō la. Ket inumadap ya kanan lakin kinumpit ye gamet. Hinabi na, “Ipanat moy gamet mo.” Impanat nay gamet na, ket nitaah yayna. ");
INSERT INTO abp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Haanin, hilay Papariseo, tampol hilan nilumwah ha pāytiponan. Ket nakew hilan nakitupig kanlan tatao nan Gobilnadol Herodes Antipas. Ket pinaytongtongan la no way-omen laya maipapatey ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Inumalih yay Apo Jesus boy mānumbong na. Ket nakew hila ha ambay dagatdagatan nin Galilea. Malabong a tatao ye hinumumbong kana. Main nangibat ha plobinhiyan Galilea, ha Judea, ");
INSERT INTO abp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ha banwan Jerusalem, ha plobinhiyan Idumea, ha lipay nin kabatowan Jordan boy ha palibot nin banwan Tiro boy Sidon. Nakew hilan kaganaan kanan Apo Jesus, ulita nabalitaan lay kaganaan a andiyagen na. ");
INSERT INTO abp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ket uli ha kalabong nin tatao, nagpahadya yay Apo Jesus kanlan mānumbong na nin bangka a iknoan na ta-omen ya ahe mapidit. ");
INSERT INTO abp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Malabong hilay pinaitaah nan Apo Jesus. Kaya-bay pinaypaletpetan la yan kaganaan a ampaghakit ta-omen la yan bengat makimpaan. ");
INSERT INTO abp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hilay mangaloke a ihpidito, balang makakit kanan Apo Jesus, ket ampatalimukoden la yay taon hinelpan la boy an-ikolih lay wanae, “Hika ye Anak nin Dioh!” ");
INSERT INTO abp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Noba impahehpet nan imbilin kanla, “Adi yo an-ibalita kanlan kanayon a tatao no aya ko.” ");
INSERT INTO abp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pangayadi, hinumaka yay Apo Jesus ha mapantay. Hinagyat na hilay tataon labay nan pilien. Ket hinaleyan laya. ");
INSERT INTO abp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namili ya nin labinluwa a hinabtan na nin apohtol a pagkalamo na boy itubol na a mangipatanda nin Manged a Balita ");
INSERT INTO abp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","boy binyan na hilan kapalyadiyan a mamaalih nin mangaloke a ihpidito. ");
INSERT INTO abp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hilabayti ye labinluwan pinili na, hiyay Simon a pinangalanan na nin Pedro, ");
INSERT INTO abp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hilay aanak nan Zebedeo a hilay Santiago boy Juan a pinangalanan na nin Boanerges a hiyay labay habiyen aanak nin kodol, ");
INSERT INTO abp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","hiyay Andres, hiyay Felipe, hiyay Bartolome, hiyay Mateo, hiyay Tomas, hiyay Santiago a anak nan Alfeo, hiyay Tadeo, hiyay Simon a magha kanlan ampangimahakit kanlan Israelita, ");
INSERT INTO abp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","boy hiyay Judas Iscariote a nangiopit kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ha nuli yaynay Apo Jesus ha angkunaan na, malabong a naman a tatao ye naytitipon ihtew. Kaya-bay hiyay Apo Jesus boy mānumbong na, ahe layna angkaadap ye mangan. ");
INSERT INTO abp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ha nabalitaan lan papaltido na ye angkalyadi, nilakew la yan iuli, ta anhabiyen lan tatao a angkaengew ya. ");
INSERT INTO abp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anhabiyen la met mamaihtodo nin Bibilin a nilumateng ibat ha Jerusalem, “Hinelpan na yan Satanas a poon lan mangaloke a ihpidito. Ampakaalih yan mangaloke a ihpidito, ta hiyay Satanas ye namyay kana nin kapalyadiyan a manyag nin wanabay.” ");
INSERT INTO abp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaya-bay hiyay Apo Jesus, pinahaley na hilay tatao kana. Ket hinabi na kanla makauli ha pangilalayi, a wana, “Ahe na malyadin paalihen Satanas ye hadili na. ");
INSERT INTO abp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ta no hilay angkumonin ha maghay panakopan ket mapay-away-away, ahe magbuyot ye panakopan. ");
INSERT INTO abp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wanabay met ye malyadi ha maghay pamilya. No mapay-away-away hila, ket ahe magbuyot ye paylamo la. ");
INSERT INTO abp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ket no kalabanen na hilan Satanas ye anhakopen na, ket ahe ya magbuyot ye panakop na, kali?” ");
INSERT INTO abp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Inlalayi na yan Apo Jesus ye Satanas ha maghay makhaw a laki, “Homain taon makababa a lumoob manakaw ha babandi nin makhaw a laki, no aliwan hiyay mamakhaw po kana. Ket no mabalol na yaynay makhaw a laki, malyadi naynan kowen ye hinyaman a malabayan na ha loob nin baey.” ");
INSERT INTO abp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pakaleng-en yon manged ye habiyen ko! Kaganaan a kakahalanan nin tao boy pangumih ha ayaman, ket mapatawad ya. ");
INSERT INTO abp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Noba ayaman a mangumih kanan Ihpiditon Dioh, ket ahe ya mapatawad makanoman, ta nakadyag yan kahalanan a mikakaanti makanoman.” ");
INSERT INTO abp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hinabi nan Apo Jesus yatew, ta anhabiyen lan mamaihtodo nin Bibilin, “Hinelpan yan maloke a ihpidito.” ");
INSERT INTO abp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Haanin, nilumateng yay indo boy kakatongno nan Apo Jesus. Ampideng hila ha ilwah nin baey boy impaingat la yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ha loob nin baey, malabong a tatao ha palibot nan Apo Jesus ye ampikno a ampanlenge nin an-iadal na. Ket main naghabi kana, “Hiyay indo mo boy hilay kakatongno mon laki, anti hila ha ilwah. Ket an-ipahagyat laka.” ");
INSERT INTO abp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nakibat yay Apo Jesus, “Aya hila lagi ye indo ko boy kakatongno ko?” ");
INSERT INTO abp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Binilew na hilay tataon ampikno ha palibot na. Ket hinabi na, “Hilati ye indo ko boy kakatongno ko, ");
INSERT INTO abp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ta ayaman a ampanumbong ha kalabayan nan Apo Dioh, ket hilabay ye kakatongno ko boy indo ko.” ");
INSERT INTO abp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ha maghay mangaamot, hiyay Apo Jesus, nakew yayna man nangiadal ha ambay dagatdagatan nin Galilea. Malabong a tubat ye tataon namalibot kana. Kaya-bay nilumampat ya ha bangka. Ket nikno ya, ta ihtew yan mangiadal. Ket hilay tatao, anti hila met ha gilid lanom a ampanlenge. ");
INSERT INTO abp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Malabong ye in-adal na kanla makauli ha pangilalayi. Hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Leng-en yo yati! Main maghay māgtalon ye nakew nanabwag nin bini ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ha panabwag na, main nangaanon bini ye naampag ha dān. Ket hilatin bibini, kinan nin mamanokmanok. ");
INSERT INTO abp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Main met nangaanon bini ye naampag ha kadapahan a main maimpih a luta. Ket mapadah yan tinumubo ye bibini, ta maimpih ye luta. ");
INSERT INTO abp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Noba ha naamotan hilayna, ket nangalangey boy nangayango, ta mangaababe ye yamot la. ");
INSERT INTO abp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Main met nangaampag ha antuboan nin madiwin iilamon. Ket ha tinumubo hilatew a bini, tinumubo hilayna met ye madiwin iilamon. Ket tinugpawan lay tinumubo a bibini. Kaya-bay ahe hilayna nakapanawa. ");
INSERT INTO abp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Main met bibini a naampag ha mabona a luta. Ket malambot ye tubo la boy nanawa hila. Main nanawan magatoh, anemapo, boy main met tatlompo.” ");
INSERT INTO abp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pangayadi, hinabi nan Apo Jesus, “Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ha nuli hilaynay kalabongan a tatao, hilay labinluwan mānumbong nan Apo Jesus boy nangaanon tataon anti ha haley na, tinepet laya no hinyay labay habiyen nin pangilalayi na. ");
INSERT INTO abp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hinabi nan Apo Jesus kanla, “Nabyayan kawon pagkataloh nin hiklito tungkol ha panakop nan Apo Dioh. Noba kanlan kanayon, ampaghabi kon bengat makauli ha pangilalayi ");
INSERT INTO abp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta-omen matupad ye naihulat a Habi nin Dioh a wanae, ‘Agya po man mamilew hilan mamilew, ket ahe hila makabalay boy agya po man manlenge hilan manlenge, ket ahe hila makataloh. Ta no makataloh hila dayi, maghehe hila ha kakahalanan la. Ket ha wanabay, patawaden na hila met Apo Dioh.’ ” ");
INSERT INTO abp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Haanin, hinabi nan Apo Jesus kanla, “No ahe yo natalohan yatin pangilalayi, way-omen yo matalohan ye kanayon po a pangilalayi? ");
INSERT INTO abp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wanae ye labay nan habiyen. Hilay bibini a inhabwag nan māgtalon ket Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hiyay dān a kinaampagan nin bibini, ket hilabay ye tataon nakange nin Habi nin Dioh. Noba pamakange la, nilumateng yay Satanas. Ket inalih na kanla ye Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ket hiyay kadapahan a main maimpih a luta, ket hilabay ye tataon angkaaliket a nakange boy tampol nananggap nin Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Noba ahe ya nanyamot ha puho la. Kaya-bay ha nilumateng ye kaidapan o pangipaloke uli ha pananggap la nin Habi nin Dioh, ket tampol la yaynan tinalingkukolan ye pamteg la.” ");
INSERT INTO abp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Hiyay luta a antuboan nin madiwin iilamon a kinaampagan nin bibini, ket hilabay ye tataon nakange nin Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Noba uli ha malabong a babagay a ampakayootan la, pagkapulag la ha kabatnangan boy kalabayan a mapagkonin ye kanayon po a babagay, ket naliwaan laynay Habi nin Dioh a nange la. Kaya-bay ahe ya nakapanawa ye Habi nin Dioh ha bi-ay la. ");
INSERT INTO abp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Noba hiyay mabona a luta a kinaampagan nin bibini, ket hilabay ye tataon nanlenge boy nananggap nin Habi nin Dioh. Kaya-bay nanawa ya ha bi-ay la. Main nanawan tatlompo, main anemapo boy main nanawan magatoh.” ");
INSERT INTO abp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hinabi na po Apo Jesus, “Homain taon mamaet nin kingki haka na hakeban nin takalan o ikonin ha hilong nin papag, no aliwan ikonin naya ha hadya a pangikunaan. ");
INSERT INTO abp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta homain nakatayo a ahe lano mibagwa boy homain met hiklito a ahe lano matandaan. ");
INSERT INTO abp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hinabi na po Apo Jesus, “Pakaihipen yon manged ye nange yo. Hiyay panukad a anggawien yo kanlan kanayon, ket hiya met ateed ye gawien nan Apo Dioh a panukad nin ibyay na kanyo boy malalabong po ihtew. ");
INSERT INTO abp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ta hiyay taon ampanumbong nin nange na a kaptegan, ket mapahanan ya po ye tinanda na. Noba hiyay taon ahe ampanumbong nin nange na a kaptegan, agya hiyay makandin tinanda na, ket maalih po kana.” ");
INSERT INTO abp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hinabi na po Apo Jesus, “Hiyay panakop nan Apo Dioh, ket mailalayi ya ha dinyag nin maghay māgtalon a nanabwag nin bini ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ha mangaamot boy madeglem, angkatuloy man o ampag-obda ya, hiyay bini, ket anlumgi boy antumubo ya. Noba hiyay māgtalon, ahe naya tanda no way-omen. ");
INSERT INTO abp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ket hiyay luta ye ampamatubo boy ampamadawa nin tatanem. Ha una, bōng. Hiyay dumondon, dawayna. Hiyay huyot, maglaman yaynay dawa na. ");
INSERT INTO abp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ket no naom yayna, baloten naynan māgtalon, ta panaon anan pamupol.” ");
INSERT INTO abp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hinabi na po Apo Jesus, “Hinyay pangilalayian tawo nin panakop nan Apo Dioh? Hinyay pangipadihowan ko? ");
INSERT INTO abp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ipadiho koya ha pinakamakandin lahi' ha kaganaan a lahi'. ");
INSERT INTO abp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Noba no maitanem boy tumubo yayna, ket mag-ilyadi yan mayadet a kayo ha pananeman. Maghanga ya nin malyadin paghayan nin mamanokmanok.” ");
INSERT INTO abp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Malabong po a pangilalayi a omen kananyati ye ginawi nan Apo Jesus ha pangiadal na kanlan tatao ha kaeteban nin pagkataloh la. ");
INSERT INTO abp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ha pangiadal na kanla, ket pawa pangilalayi ye anggawien na. Noba an-ipalinaw na met ye kaganaan kanlan mānumbong na no hilahilaynan bengat. ");
INSERT INTO abp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kananyatew a mangaamot, ha andudumeglem ana, hinabi nan Apo Jesus kanlan mānumbong na, “Lumipay kitawoyna.” ");
INSERT INTO abp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ket hilay mānumbong na, nilakwanan la hilay tatao. Ket nakew hilaynan nilumampat ha mayadet a bangka a anluganan nan Apo Jesus. Main nangaanon mayadet a bangka a hinumumbong kanla. ");
INSERT INTO abp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Legan anlumipay hila, kapipikhaan kinumhaw ye angin. Ket angkahipwak-hipwakan ana nin mangayadet a dawyon ye mayadet a bangka la. Ket magaynan mapno nin lanom ye mayadet a bangka la. ");
INSERT INTO abp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ket hiyay Apo Jesus, nakaunan yan angkatuloy ha dapit golotan nin mayadet a bangka. Ket hilay mānumbong na, pinokaw laya, a wanla, “Maihtodo! Lumdeg kitawoyna! Homain nayi bali kammo no maalimeh kitawo?” ");
INSERT INTO abp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nimata yay Apo Jesus. Ket pinaghabiyan na yay angin, a wana, “Tumgen ka!” Boy hinabi na ha dawyon, “Pakatana ka!” Ket tinumgen ye angin boy tinumana yaynay dawyon. ");
INSERT INTO abp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pangayadi, tinepet na hilay mānumbong na, “Taket ta angkalimo kawo? Homain kawo po nayi pamteg kangko?” ");
INSERT INTO abp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nalimowan hilan tubat. Ket napayhahabi hila, a wanla, “Aya ya lagi yatin tao? Ta agya angin boy dawyon, ket angkapatgen na!” ");
INSERT INTO abp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nilumateng yay Apo Jesus boy mānumbong na ha lipay nin dagatdagatan ha lugal lan tataon anhabtan Geraseno. ");
INSERT INTO abp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ha nakalumbah yaynay Apo Jesus ha bangka, hinagana yan maghay lakin hinelpan nin maloke a ihpidito. Yatin laki, ket nilumwah ya ha yukib a pangilbengan, ");
INSERT INTO abp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ta ihtew yayna angkumonin. Ahe yayna maibalol nin mabuyot, agya tanikala anay pamalol kana. ");
INSERT INTO abp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Malabong anan ukdo a binalol la yan tanikala ye gagamet boy bibitih na, noba angkaboyto naya. Ket uli ha kakhawan na, homain makabenben kana. ");
INSERT INTO abp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Minamangaamot boy dinedeglem yan angkumolih ha pangilbengan boy ha mamapantay. Boy anhugat-hugaten nan dapah ye laman na. ");
INSERT INTO abp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Haanin, ha natamulaw na yan laki ye Apo Jesus, nayew yan nanagana kana. Ket nanalimukod ya ha adapan na. ");
INSERT INTO abp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hinabi nan Apo Jesus ha maloke a ihpidito, “Hikan maloke a ihpidito, alihan mo yatin laki!” Impangha nan laki, a wana, “Jesus a Anak nin Pinakamakapalyadiyan a Dioh, aya ka nayi kammi? An-ipakiiingalo ko kammo ha ngalan nan Apo Dioh a adi moko dayi paidapan!” ");
INSERT INTO abp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tinepet na yan Apo Jesus, “Hinyay ngalan mo?” Nakibat yay maloke a ihpidito, “ ‘Kawan’, ta malabong kayi.” ");
INSERT INTO abp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ket nakiiingalo hilan tubat kanan Apo Jesus, a wanla, “Adi mo kayi dayi itaboy ihtin lugal.” ");
INSERT INTO abp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ket ihtew ha haley la, main malabong a bababoy ye ampambok ha aling nin mapantay. ");
INSERT INTO abp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Haanin, hilay mangaloke a ihpidito, nakiiingalo hila kanan Apo Jesus, a wanla, “Palakwen mo kayina tana ha bababoy boy palubohan mo kayi dayin humlep kanla.” ");
INSERT INTO abp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“Higi, kokawoyna,” wanan Apo Jesus. Haanin, hilay mangaloke a ihpidito, inumalih hila kanan laki. Ket nakew hilaynan hinumlep ha luwan libon bababoy. Ket hilay bababoy, nipapayew hilan nipataboy ha bengaw dagatdagatan. Ket ihtew hilaynan nangaalimeh. ");
INSERT INTO abp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hilay ampanayhay nin bababoy, nayew hila ha banwa boy babadiyo. Ket imbabalita lay nalyadi. Kaya-bay hilay tatao, nakew hila met ihtew ta-omen la bilewen ye nalyadi. ");
INSERT INTO abp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pamiabot la kanan Apo Jesus, hiyay lakin inalihan nin mangaloke a ihpidito, nakit la yayna a ampikno a nakabadoyna boy matino yayna. Ket nalimowan hilay tatao uli ha nalyadi. ");
INSERT INTO abp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ket hilay tataon nakakit nin dinyag nan Apo Jesus, imbalita la kanlan tataon kapipilateng ye nalyadi kanan lakin inalihan nin mangaloke a ihpidito boy hiyay nalyadi ha bababoy. ");
INSERT INTO abp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ket hilay tatao, impakihabi la kanan Apo Jesus, a wanla, “Umalih kayna dayi ihti ha lugal mi.” ");
INSERT INTO abp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ket ha anlumugan yaynay Apo Jesus ha bangka, hiyay lakin inalihan nin mangaloke a ihpidito, nakiiingalo ya, a wana, “Makilakew ako met dayi kammo!” ");
INSERT INTO abp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Noba ahe na inawo Apo Jesus, no aliwan hinabi na kana, “Muli kayna ha pamilya mo, ket hiyay kapagtakaan a dinyag nan Apo Dioh kammo boy no way-omen na kan iningalowan, ibalita mo kanla.” ");
INSERT INTO abp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ket nuli yan peteg ye laki. Ket imbalita na ha Decapolis ye kapagtakaan a dinyag nan Apo Jesus kana. Ket hilay kaganaan a tataon nakange, nagtaka hila. ");
INSERT INTO abp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ket ha nag-udong yay Apo Jesus ha lipay dagatdagatan, pinaytitiponan la yan malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Haanin, nilumateng ye maghay lakin nagngalan Jairo a maghay mānguna ha pāytiponan lan Jujudio. Pamakakit na kanan Apo Jesus, nanalimukod ya ha adapan na ");
INSERT INTO abp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","boy nakiiingalo yan tubat, a wana, “Hiyay anak kon balatang, angkakamatey yayna. Pangiingalo mo, Apo. Lakwen moya dayin kimpaan ye anak ko ta-omen yan mitaah boy ahe matey.” ");
INSERT INTO abp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Haanin, hiyay Apo Jesus, nakilakew ya kanan Jairo. Malabong a tatao ye ampakilakew kanla boy ampaypapaletpet kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Main met maghay babayi kanla a labinluway taon anan andayaen. ");
INSERT INTO abp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tubat yaynan angkaidapan boy malabong anan dodoktol ye nagpatambalan na. Ket nauboh anay kabandiyan na. Noba ahe yan teed nitaah, no aliwan nilumalo ya po ye hakit na. ");
INSERT INTO abp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ha nange nay anhabiyen lan tatao a tungkol ha kapagtakaan a andiyagen nan Apo Jesus, ket nakipaletpet ya met kanlan tatao angga ha niabot ya ha golotan nan Apo Jesus. Ket kiniwit nay bado na. ");
INSERT INTO abp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta an-ihipen na, “No makiwit kon bengat ye bado na, ket mitaah akoyna.” ");
INSERT INTO abp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ket ha nakiwit na yayna, tampol anan tinumgen ye pandumaya na boy natanam na a nitaah yayna. ");
INSERT INTO abp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Haanin, hiyay Apo Jesus, tampol na met natanam a main kapalyadiyan a nilumwah kana. Kaya-bay nagpeyeh yan inumadap kanlan tatao. Ket tinepet na hila, “Ayay nangiwit nin bado ko?” ");
INSERT INTO abp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hinabi lan mānumbong na kana, “Angkakit moynan malabong a tatao ye ampaypapaletpet kammo. Taket ta antepeten mo po no ayay nangiwit nin bado mo?” ");
INSERT INTO abp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Noba hiyay Apo Jesus, iniwah na hilay tatao ta-omen na matandaan no ayay nangiwit nin bado na. ");
INSERT INTO abp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ket hiyay babayi, ulita tanda nay nalyadi, ampamigpig yan angkalimo a hinumaley kanan Apo Jesus boy nilumukob ya ha adapan na. Ket inhabi nay dinyag na boy hiyay nalyadi kana. ");
INSERT INTO abp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hinabi nan Apo Jesus kana, “Inang, nitaah ka uli ha pamteg mo. Muli kaynan main katanaan, ta nitaah kayna.” ");
INSERT INTO abp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Legan angkatongtongen naya po Apo Jesus ye babayi, main nangaanon lalaki ye nilumateng a ibat ha baey nan Jairo. Hinabi la kanan Jairo, “Adi mo yayna an-abaen ye Maihtodo, ta natey yaynay anak mo.” ");
INSERT INTO abp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Noba hiyay Apo Jesus, ahe na imbabano ye hinabi la, no aliwan hinabi na kanan Jairo, “Adi ka angkalimo. Mamteg kan bengat.” ");
INSERT INTO abp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Haanin, nagpahulong hilaynan palakew ha baey nan Jairo, noba homain yan kanayon a inlamo no aliwan hiyay Pedro boy mikatongnon Santiago boy Juan. ");
INSERT INTO abp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ha niabot hilayna ha baey nan Jairo, nakit nan Apo Jesus a angkagulo hilay tatao. Main antumangih boy main ampangandang. ");
INSERT INTO abp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hinumlep yay Apo Jesus. Ket tinepet na hila, “Taket ta angkagulo boy ampangandang kawo? Ahe yan natey ye anak, no aliwan angkatuloy yan bengat.” ");
INSERT INTO abp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ket kinailiyan la yan tatao ye Apo Jesus, ta tanda la a natey yaynay anak. Haanin, pinalwah na hilan kaganaan, powida kanlan tutoa nan anak boy hilay mānumbong na. Ket hinaleyan la yay anak a nakaida. ");
INSERT INTO abp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ginemgeman na yan Apo Jesus ye gamet nan anak boy hinabi na kana, “Talitha koum!” hiyay labay habiyen, “Inang, mimata ka!” ");
INSERT INTO abp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ket tampol yan nimata ye anak boy kinumodang-kodang yayna. Labinluway taon naynan anak. Ket hilay tatao ihtew, nagtaka hilan tubat. ");
INSERT INTO abp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Impahehpet nan imbilin Apo Jesus kanla, a wana, “Yatin nalyadi, adi yo yan bega anhabiyen ha agya ayaman.” Pangayadi, hinabi na kanla, “Pakanen yoya.” ");
INSERT INTO abp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Haanin, inumalih yay Apo Jesus ihtew. Ket nuli yayna ha lugal a nilakean na, kalamo na hilay mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pangaabot nin Mangaamot nin Pagpainawa, hiyay Apo Jesus, nakew ya ha pāytiponan lan Jujudio. Ket ihtew ya nandugin nangiadal. Kalabongan kanlan nakange kana, ket ampagtaka, a wanla, “Way-ihtew nangibat ye kadunongan na? Hinyatin kadunongan a naibyay kana? Way-omen yan ampakadyag nin kapagtakaan? ");
INSERT INTO abp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aliwa nayi a hiyabay ye māg-alowagi a anak nan Maria boy katongno nan Santiago, Jose, Judas boy Simon? Aliwa nayi a hilay kakatongno nan babayi, ket angkumonin hila met ihti?” Kaya-bay napoot hila kana boy ahe laya pinamtegan. ");
INSERT INTO abp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hinabi nan Apo Jesus kanla, “Hiyay podopita, ambihaen laya ha agya way-ihtew man a lugal, powidan bengat ha lugal na, ha papaltido na boy pamilya na.” ");
INSERT INTO abp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hiyay Apo Jesus, ahe ya nakadyag nin kapagtakaan ha lugal na, powidan bengat kanlan nangaanon ampaghakit a nangipalontoan na nin gamet na boy pinaitaah. ");
INSERT INTO abp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nagtaka ya ulita ahe hila namteg kana. Haanin, nakew yan nangiadal ha binabadiyo. ");
INSERT INTO abp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hinagyat na hilay labinluwan mānumbong na a humaley kana. Ket intubol na hilan maniluwa. Binyan na hilan kapalyadiyan a mamaalih nin mangaloke a ihpidito kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Binilinan na hila, “Ha pangumodang yo, adi kawo ampangaget nin hinyaman, agya pamangan, bakoto o pilak, no aliwan teken bengat. ");
INSERT INTO abp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Malyadi kawon mag-ihtiping, noba ahe kawo ampangaget nin bado a paghagiliyan yo.” ");
INSERT INTO abp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hinabi na po Apo Jesus, “No main mamadagoh kanyo, ihtewbay kawo tana kumonin angga ha umalih kawo nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Noba no main lugal a ahe mananggap o manlenge kanyo, ikampag yo po ye tuwapok ha bibitih yo bilang pangipatanda kanla a maloke ye dinyag la. Ket alihan yo hilayna.” ");
INSERT INTO abp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaya-bay nakew hilaynay labinluwa. Ket impatanda la kanlan tatao, “Maghehe kawoyna ha kakahalanan yo!” ");
INSERT INTO abp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pinaalih la ye malabong a mangaloke a ihpidito a hinumlep kanlan tatao boy tiniihan lan ladak ye malabong a tataon ampaghakit, ket nitaah hila. ");
INSERT INTO abp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nabalitaan nan Gobilnadol Herodes Antipas ye tungkol kanan Apo Jesus, ta angkabalitaan yayna ha kaganaan a lugal. Anhabiyen lan tatao, “Hiyabay ye Juan a Māmawtihmo a nabi-ay uman. Kaya-bay ampakadyag yan kapagtakaan.” ");
INSERT INTO abp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Noba anhabiyen lan kanayon, “Hiyabay ye podopita Elias a nabi-ay uman.” Anhabiyen la met nin kanayon, “Magha yan podopita a omen kanlan popodopita hatew.” ");
INSERT INTO abp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Noba ha nangean nan Gobilnadol Herodes Antipas ye anhabiyen lan tatao, hinabi na, “Hiyabay ye Juan a pinaputohan kon leey hatew noba nabi-ay uman.” ");
INSERT INTO abp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yati ye nalyadi ha ahe ya po natey ye Juan a Māmawtihmo. Hiyay Gobilnadol Herodes Antipas, impadakep na yay Juan a Māmawtihmo haka naya impapidiho, ta maheheg nan anhabiyen kana, “Apo Gobilnadol, aliwan huhto ye dinyag mo, ta pinag-ahawa mo yay Herodias a ahawa nan Felipe a katongno mo.” ");
INSERT INTO abp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ket hiyay Herodias, tubat ye poot na kanan Juan boy labay naya dayin ipapatey, noba ahe na madyag. ");
INSERT INTO abp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ta hiyay Gobilnadol Herodes Antipas, ket an-allaan na yay Juan boy ambihaen naya, ta tanda na a matoynong ya boy ampanumbong ya ha kalabayan nan Apo Dioh. Agya po man angkayootan yay Gobilnadol Herodes Antipas uli ha anhabiyen nan Juan kana, labay naya po ateed ye manlenge ha an-iadal na. ");
INSERT INTO abp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Noba naabot met ateed ye panaon a ampakaagaden nan Herodias a maipapatey na yay Juan. Ha naabot ye kompalanyoh nan Gobilnadol Herodes Antipas, nangihadya yan mayadet a poniyan. Kinumbida na hilay mānungkolan, hilay mānguna nin huhundalon Romano boy hilay ambigbigen a tataon taga Galilea. ");
INSERT INTO abp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ha odah ana nin hayaghagan, nilumoob yay balatang nan Herodias. Ket tinumalek ya ha adapan lan kaganaan. Naaliket yay Gobilnadol Herodes Antipas boy hilay bibihita na. Ket uli ha kaaliketan na, hinabi na kanan balatang, “Awoken mo kangko ye hinyaman a labay mo, ket ibyay ko.” ");
INSERT INTO abp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Boy impangako na boy nanumpa ya po, a wana, “Hinyaman a awoken mo, ibyay ko kammo, agya po yay kagitna nin panakopan ko!” ");
INSERT INTO abp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Haanin, nilumwah yay balatang. Ket nakew yan nanepet kanan indo na, “Indang, hinyay awoken ko?” “Hiyay ō nan Juan a Māmawtihmo,” wanan indo na. ");
INSERT INTO abp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ket hiyay balatang, dinandali nay nag-udong kanan Gobilnadol Herodes Antipas. Ket hinabi na kana, “Hiyay labay kon ibyay mo kangko haanin met ateed, ket hiyay ō nan Juan a Māmawtihmo a naikonin ha bandihado.” ");
INSERT INTO abp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pamakange nan Gobilnadol Herodes Antipas yatew, nalele yan tubat. Noba ulita nagpangako ya ha adapan lan bibihita na, ahe yayna makaadey kana. ");
INSERT INTO abp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaya-bay tampol yan nangitubol nin maghay māmatey a mamutoh nin leey nan Juan. Kaya-bay nakew yay māmatey ha pidihowan. Ket pinutoh nay leey nan Juan. ");
INSERT INTO abp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ha naputoh na yayna, ingkonin naya ha bandihado. Pangayadi, inggawang naya kanan balatang. Ket hiyay balatang, inggawang naya met kanan indo na. ");
INSERT INTO abp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ha nabalitaan lan mānumbong nan Juan ye nalyadi kana, nilakew la yan kingwa ye bangkay na. Ket in-ilbeng laya. ");
INSERT INTO abp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Haanin, hilay aapohtol nan Apo Jesus a intubol na a mangiadal, ket nag-udong hilayna kana. Ket imbalita la ye kaganaan a didinyag boy in-adal la. ");
INSERT INTO abp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Noba uli ha kalabong nin tatao a anlumateng boy man-umalih, ahe layna maadap ye mangan. Kaya-bay hinabi nan Apo Jesus kanlan mānumbong, “Lakwanan tawo hilatin tatao, ta makew kitawo ha wangwang ta-omen kitawo makapagpainawa.” ");
INSERT INTO abp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaya-bay nilumugan hila ha bangka. Ket nakew hilayna ha wangwang. ");
INSERT INTO abp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Noba malabong ye nakakit nin pangumalih la. Ket tanda la no way-ihtew hila makew. Kaya-bay hilatin tatao a nangibat ha binabanwa, ket nayew hilan nakew ha lakwen lan Apo Jesus. Ket nuna hila po a nilumateng ihtew. ");
INSERT INTO abp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ha nilumumbah yay Apo Jesus ha bangka, nakit na hilay malabong a tatao. Nalunoh ya kanla, ta ba-mo hilan tupa a homain pahtol. Ket inadalan na hilan malabong a babagay. ");
INSERT INTO abp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ha ampitanghob anay mangaamot, hilay mānumbong na, hinumaley hila kanan Apo Jesus. Ket hinabi la kana, “Apo, anti kitawo ihti ha wangwang boy ampitanghob anay mangaamot. ");
INSERT INTO abp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kaya-bay habiyen moyna kanlan tatao a makew hilayna ha mangahaley a pananamanan boy babadiyo ta-omen hila po makahaliw nin pamangan la.” ");
INSERT INTO abp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Noba hinabi nan Apo Jesus kanla, “Ahe, hikawoy mamyay nin pamangan la.” Hinabi lan mānumbong na, “Hiyay labay mon habiyen nayi makew kayin manaliw nin tinapay a ipakan kanla? Alaga nin waloy bowan a howildo nin magha katao ye alaga a panaliw nin tinapay a ipakan kanla.” ");
INSERT INTO abp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nanepet yay Apo Jesus kanla, “Anoy tinapay ye bawon yo? Bilewen yo man.” Ket binilew la yan peteg. Pangayadi, hinabi la kana, “Main kitawon limay tinapay bengat boy luway malanghit.” ");
INSERT INTO abp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hinabi nan Apo Jesus kanla, “Paiknoen yo hilan puhto-puhto ha kailamonan.” ");
INSERT INTO abp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ket nikno hilan puhto-puhto. Main manilimampo boy main met manigatoh. ");
INSERT INTO abp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Haanin, kingwa nan Apo Jesus ye limay tinapay boy luway malanghit. Tinumangal ya ha langit. Ket pinahalamatan naya kanan Apo Dioh. Binih-ilbih-il na yay tinapay boy pinutoh-putoh na yay malanghit, ket in-ibyay na kanlan mānumbong na. Ket impatped la met kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangan hilan kaganaan boy nangabhoy. ");
INSERT INTO abp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pangayadi lan nangan, hilay mānumbong na, tinipon lay tela lan tatao a tinapay boy malanghit. Ket nakapno hila po nin labinluwan belyag. ");
INSERT INTO abp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hiyay bilang nin lalakin nangan, mangalimay libo. ");
INSERT INTO abp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Legan ampaulien na hilan Apo Jesus ye tatao, pinalugan na hilaynay mānumbong na ha bangka. Ket pinauna na hilaynan lumipay palakew ha banwan Bethsaida. ");
INSERT INTO abp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ket ha nakaalih hilaynay tatao, hinumaka yay Apo Jesus ha mapantay ta-omen ya makigwang. ");
INSERT INTO abp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ket nadegleman ya ihtew. Haanin, hiyay bangka a anluganan lan mānumbong na, ket anti yayna ha bunak nin dagatdagatan. Ket hiyay Apo Jesus, bubukod nayna ha mapantay. ");
INSERT INTO abp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Angkakit na a hilay mānumbong na, ket angkaidapan hilan ampaggaod nin bangka la, ta angkadupag hilan angin. Ha palbangon ana, kinumodang yay Apo Jesus ha babe lanom palakew kanla. Labhan na hila dayi, ");
INSERT INTO abp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","noba ha natamulaw la yan mānumbong na a angkumodang ya ha babe lanom, nabaan la yan anito. Kinumolih hila, ");
INSERT INTO abp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ta nalimowan hilan tubat. Noba hinabi nan tampol Apo Jesus kanla, “Adi kawo angkalimo, ta hiko yati! Pakatana kawon bengat!” ");
INSERT INTO abp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Haanin, hiyay Apo Jesus, nilumampat ya ha bangka. Ket tinumgen ye angin. Ampagtaka hilan tubat ye mānumbong na, ");
INSERT INTO abp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ta ahe la angkatalohan agya nakit lay kapagtakaan a dinyag nan Apo Jesus ha tinapay. Ahe la makwan ihipen, ta mangabyang ye puho la. ");
INSERT INTO abp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Haanin, ha nakalipay hilayna ha dagatdagatan, nilumateng hila ha Genesaret. Ket ihtew laya intanghad ye bangka la. ");
INSERT INTO abp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ha nakalumbah hilayna, hilay tatao ihtew, tampol la yan nabalayan ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kaya-bay hilay tatao, nayew hilan nakew nangipatanda ha kaganaan a pahen nin yatew a lugal a nilumateng yay Jesus. Ket hilay ampaghakit, ingkonin la ha apay haka la hila inlakew kanan Apo Jesus agya way-ihtew man a lugal a pakabalitaan la kana. ");
INSERT INTO abp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Agya way-ihtew man a badiyo, banwa, o lugal umabot ye Apo Jesus, hilay tatao a ampaghakit, ket an-ilakew la hila ha palingki. Ket an-ipakiiingalo la kana a no malyadi, agya makiwit lan bengat ampaghakit ye laylay nin bado na. Ket hilay kaganaan a nangiwit, nitaah hila. ");
INSERT INTO abp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ha maghay mangaamot, main nangaanon Papariseo boy mamaihtodo nin Bibilin a ibat ha banwan Jerusalem ye nakitipon kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakit la hilay nangaanon mānumbong nan Apo Jesus a ahe nanumbong ha kaugalian lan tutoa tungkol ha pag-ibano bayo mangan. ");
INSERT INTO abp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hilay Jujudio, lalo ana kanlan Papariseo, mag-ibano hila po bayo hilan mangan, bilang panumbong la ha naiknaan la a kaugalian lan tutoa la. ");
INSERT INTO abp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Boy no ibat hila ha palingki, mag-ibano hila po muna bayo hila mangan nin agya hinyaman a hinaliw la. Malabong po a naiknaan a kaugalian ye anhumbongen la a omen ha panguyah nin paminoman, pithil boy takodi. ");
INSERT INTO abp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaya-bay hilay Papariseo boy mamaihtodo nin Bibilin, tinepet la yay Apo Jesus, “Taket ta hilay mānumbong mo, ket ahe hila ampanumbong ha kaugalian lan tutoa tawo tungkol ha pag-ibano bayo mangan?” ");
INSERT INTO abp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nakibat yay Apo Jesus, “Petegbay ye impahulat nan Apo Dioh kanan podopita Isaias hatew a tungkol kanyon ampagmamangedan, ‘Hilatin tatao, anggalangen lako ha habi bengat, noba mataang ya met ye puho la kangko. ");
INSERT INTO abp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Homain hilbi ye panggalang la kangko, ta hiyay an-iadal la ket bibilin bengat nin tao.’ ” ");
INSERT INTO abp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Pinaolayan yoynay Bibilin nan Apo Dioh, ket hiyay anhumbongen yo, hiyay naiknaan yon kaugalian lan tutoa yo.” ");
INSERT INTO abp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hinabi na po Apo Jesus, “Kanged ye papadan yon nangalih nin hilbi nin Bibilin nan Apo Dioh ta-omen yon bengat mahumbong ye naiknaan yon kaugalian lan tutoa yo! ");
INSERT INTO abp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Alimbawa, impahulat nan Apo Dioh kanan Moises, ‘Bihaen moy bapa mo boy indo mo’ boy ‘Ayaman a maghabin maloke kanlan tutoa na, ket hukat a pateyen.’ ");
INSERT INTO abp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Noba lumbo ya met ye an-iadal yo kanlan tatao, ta anhabiyen yo a malyadi yon habiyen kanlan tutoa yo, ‘Hikawon tutoa ko, biyan katawo dayin pilak, noba ibyay ko tana kanan Apo Dioh.’ ");
INSERT INTO abp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ulin yain a an-iadal yo, anhaaden yo hilayna a managlap kanlan tutoa la. ");
INSERT INTO abp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ha wanabay, andiyagen yon homain hilbi ye Bibilin nan Apo Dioh uli ha panumbong yo ha naiknaan yo a kaugalian lan tutoa yo. Aliwan bengat yain, malabong po ye kanayon a andiyagen yo a omen kananyati.” ");
INSERT INTO abp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Haanin, hiyay Apo Jesus, hinagyat na hilay tataon humaley kana. Ket hinabi na, “Hikawon kaganaan, leng-en yoko boy ihipen yon manged ye habiyen ko. ");
INSERT INTO abp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aliwan hiyay an-ipahlep nin tao ha bebey na ye ampakapadinat kana, no aliwan hiyay habi a anlumwah ha bebey na. ");
INSERT INTO abp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pakaihipen yon manged yatin nange yo.” ");
INSERT INTO abp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pangayadi, inalihan na hilaynay tatao haka yan nilumoob ha baey kalamo hilay mānumbong na. Ha nakaloob yayna, tinepet la yan mānumbong na, no hinyay labay habiyen nin pangilalayi na. ");
INSERT INTO abp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hinabi nan Apo Jesus kanla, “Agya hikawo nayi, ahe kawo ampakataloh? Ahe yo nayi tanda a hiyay pamangan a angkanen nin tao, aliwan yatew ye ampakapadinat kana. ");
INSERT INTO abp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta hinyaman a kanen na, ahe ya humlep ha puho na, no aliwan ha bitoka na. Pangayadi, itaka naya met ateed.” Ha wanabay a hinabi nan Apo Jesus, an-ipatanda na a malyadin kanen ye agya hinyaman a pamangan. ");
INSERT INTO abp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hinabi na po Apo Jesus, “Hiyay habi a anlumwah ha bebey nin tao ye ampakapadinat kana, ");
INSERT INTO abp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ta ibat ha puho na ye mangaloke a ihip. Ket yatin mangaloke a ihip ye ampangitudon kana a manyag nin kadamogan, manakaw, mamatey, ");
INSERT INTO abp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","makilaki o mamabayi, mangakokoh, manyag nin kaganaan a kalahin kalok-an a omen ha panguhit, mangadinat a didiyag, pangaibeg, pandama ha kanayon, kalambongan, boy kamutawan. ");
INSERT INTO abp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yatin kaganaan a kalok-an, ket ampangibat ya ha puho nin tao. Hilayati ye ampakapadinat kana.” ");
INSERT INTO abp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pangayadi, inumalih yay Apo Jesus. Ket nakew ya ha lulugal a mahaley ha banwan Tiro. Ket nakidagoh ya ihtew. Ahe na dayi labay a matandaan lan tatao a anti ya ihtew, noba natandaan lan teed tatao. ");
INSERT INTO abp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Main maghan babayi a main anak a babayin hinelpan nin maloke a ihpidito. Yatin babayi, ket Griego ya a taga Sirofenicia. Ha nabalitaan na yan nilumateng ye Apo Jesus ihtew, tampol yan nakew kana. Ket nanalimukod yan nakiiingalo a paalihen na dayi ye maloke a ihpidito kanan anak na. ");
INSERT INTO abp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Noba hinabi nan Apo Jesus kana makauli ha kahabiyan, “Katapulan a muna hila po pakanen ye aanak, ta aliwan huhto a kowen ye pamangan lan aanak haka ipakan ha aaho.” ");
INSERT INTO abp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hinabi na met babayi kanan Apo Jesus, “Awo, peteg yain, Apo. Noba hilay aaho a anti ha hilong nin lamihaan, angkanen la met ye mumom angkaampag a ibat ha angkanen lan aanak.” ");
INSERT INTO abp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hinabi nan Apo Jesus kana, “Uli ha wanabay a pakibat mo, malyadi kaynan muli, ta hiyay maloke a ihpidito, inalihan na yaynay anak mo.” ");
INSERT INTO abp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ket nuli yay babayi boy nalatngan na yaynay anak na a mayaman anan ampida, ta inalihan na yaynan maloke a ihpidito. ");
INSERT INTO abp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pangayadi yatew, inumalih yay Apo Jesus ha banwan Tiro. Ket nagdān ya ha banwan Sidon boy ha lulugal a Decapolis angga ha inumabot ya ha dagatdagatan nin Galilea. ");
INSERT INTO abp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ha anti yaynay Apo Jesus ihtew, main nangaanon tatao ye nangilakew kana nin lakin teek boy angang ya. Impakiiingalo la kana a kimpaan naya ta-omen yan mitaah. ");
INSERT INTO abp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Intaang na yan makandin Apo Jesus ye laki kanlan tatao. Pangayadi, impuhek nay tatamudo na ha mitaligmang a talinga nan laki haka na nilod-an ye maghay gamet na haka na in-aploh ha dila nan laki. ");
INSERT INTO abp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ket tinumangal yay Apo Jesus ha langit, inumingah ya haka na hinabi, “Effata!” Hiyay labay habiyen, “Maglukat ka!” ");
INSERT INTO abp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ket tampol yaynan makange boy ampakahabet ye laki. ");
INSERT INTO abp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Imbilin nan Apo Jesus kanlan tatao a ahe la yan man-ibalita ha agya ayaman ye nakit la. Noba agya binilinan na hila, ket lalo layna ingat imbabalita. ");
INSERT INTO abp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tubat ye pagtaka lan tataon nakange nin yatin balita boy anhabiyen la, “Koynan kanged ye dinyag na! Ampakange yaynay teek boy ampakahabet yaynay angang!” ");
INSERT INTO abp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pangalabah nin anoy mangaamot, main ana man malabong a tatao ye nakitipon kanan Apo Jesus. Ha homain hilaynan makan, pinahaley na hilay mānumbong na boy hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Angkalunoh akon tubat kanlan hilatin tatao, ta tatloynan mangaamot a kalamo tawo hila, ket haanin, homain hilaynan makan. ");
INSERT INTO abp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No paulien ko hilan mabitil, maka mawe hila ha dān, ta hilay kanayon kanla, ket mataang met awod ye ulien la.” ");
INSERT INTO abp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hinabi lan mānumbong na kana, “Apo, way-ihtew kitawo nayi mangwa nin pamangan ihti ha wangwang a mignap kanla?” ");
INSERT INTO abp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tinepet na hilan Apo Jesus, “Anoy tinapay ye anti kanyo?” “Pito,” wanla. ");
INSERT INTO abp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Haanin, hiyay Apo Jesus, pinaikno na hilay tatao ha luta. Ha nakaikno hilayna, kingwa nay pitoy tinapay haka naya pinahalamatan kanan Apo Dioh. Pangayadi, binih-ilbih-il naya haka na in-ibyay kanlan mānumbong na ta-omen la ipatped kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Main hila met nangaanon mangakandin malanghit. Pinahalamatan naya kanan Apo Dioh. Pangayadi, hinabi na kanlan mānumbong na a ipatped la kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangan hilay tatao boy nangabhoy. Pangayadi lan nangan, hilay mānumbong na, tinipon lay tela lan tatao. Ket nakapno hila po nin pitoy belyag. ");
INSERT INTO abp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hiyay bilang nin tataon nangan, mangaapat a libo. Haanin, pinauli na hilaynan Apo Jesus ye tatao. ");
INSERT INTO abp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pangayadi, tampol yan nilumugan ha bangka lamo na hilay mānumbong na. Ket nakew hilayna ha lugal a Dalmanuta. ");
INSERT INTO abp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ha nangean lan Papariseo a niabot yaynay Apo Jesus ihtew, nakew hilan nakingatngat kana. Labay la yan huboken. Kaya-bay nakikwa hilan kapagtakaan kana bilang pagkakitan a hiyabay ye intubol nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Inumingah ya boy hinabi na, “Taket ta hilatin tatao kananyatin panaon, ket ampakikwa hilan kapagtakaan bilang pagkakitan a hiko ye intubol nan Apo Dioh? Pakaleng-en yon manged ye habiyen ko. Homain akon ipakit kanyo a hinyaman a kapagtakaan bilang pagkakitan.” ");
INSERT INTO abp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pangayadi, nilakwanan na hilayna. Ket nilumugan ya ha bangka lamo na hilay mānumbong na. Ket nilumipay hilayna ha dagatdagatan. ");
INSERT INTO abp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hilay mānumbong nan Apo Jesus, naliwaan lay nagbawon nin tinapay, noba main hilan maghay tinapay a anti ha bangka la. ");
INSERT INTO abp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Haanin, legan anlumipay hila, hinabi nan Apo Jesus kanla, “Mag-alla kawo ha pamalbag lan Papariseo boy Gobilnadol Herodes Antipas.” ");
INSERT INTO abp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Uli ha hinabi nan Apo Jesus, hinabi la ha magha boy magha, “Hinabi na yatew, ta homain kitawon bawon a tinapay.” ");
INSERT INTO abp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Noba tanda nan Apo Jesus ye ampaytongtongan la. Kaya-bay tinepet na hila, “Taket ta ampaytongtongan yoy ahe yo pagbawon nin tinapay? Ahe kawo po nayi ampakataloh? Koynan kabyang ye puho yo! ");
INSERT INTO abp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Main kawon mata, kali? Noba ahe kawo ampakakit. Main kawon talinga, kali? Noba ahe kawo ampakange. Naliwaan yoyna nayi ");
INSERT INTO abp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ye pamih-ilbih-il ko nin limay tinapay a impakan ha limay libo katao, ket nangabhoy hila? Anoy belyag ye natipon yon tela lan tatao?” “Labinluway belyag Apo,” wanla. ");
INSERT INTO abp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Boy hiyay pamih-ilbih-il ko nin pitoy tinapay a impakan ha apat a libo katao, anoy belyag ye natipon yon tela lan tatao?” “Pitoy belyag Apo!” wanla. ");
INSERT INTO abp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hinabi nan Apo Jesus, “Ahe yo po nayi angkatalohan?” ");
INSERT INTO abp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ha nilumateng hilaynan Apo Jesus boy mānumbong na ha Bethsaida, main nangaanon tatao ihtew ye nangilakew kana nin maghay lakin kapkap. An-ipakiiingalo la kana a no malyadi dayi, ket kimpaan na yan paitaahen. ");
INSERT INTO abp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ket hiyay Apo Jesus, inakay na yan palakew ha ilwah nin Bethsaida ye lakin kapkap. Ket ha anti hilayna ihtew, nilawayan na ye mata nan lakin kapkap haka na kinimpaan boy tinepet naya, “Main kan angkakit?” ");
INSERT INTO abp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Namilew yay laki ha palibot na. Ket hinabi na, “Awo, angkakit ko hilan angkumodang ye tatao, noba ba-mo hilan popoon-kayo.” ");
INSERT INTO abp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kinimpaan na yan uman Apo Jesus ye mata nan laki. Pangayadi, impudek nan laki ye mata na. Ket nitaah yayna boy makinang anay pamilew na. ");
INSERT INTO abp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bayo na yan pinauli Apo Jesus ye laki, binilinan naya, “Adi kaynan angkadān ha Bethsaida.” ");
INSERT INTO abp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pangayadi, hiyay Apo Jesus boy mānumbong na, ket nakew hilayna ha binabadiyo a hakop nin banwan Cesarea Filipos. Legan angkumodang hila, hiyay Apo Jesus, tinepet na hilay mānumbong na, “Aya ko kano ha ihip lan tatao?” ");
INSERT INTO abp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nakibat hila, “Anhabiyen lan kanayon a hika ye Juan a Māmawtihmo. Hilay kanayon met, anhabiyen la a hika ye podopitan Elias. Ket hilay kanayon po, magha ka kanlan popodopita.” ");
INSERT INTO abp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Haanin, tinepet na hila met Apo Jesus, “Hikawo nayi, aya ko?” Nakibat yay Pedro, “Hika ye Cristo.” ");
INSERT INTO abp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mahehpet na hilan binilinan Apo Jesus, “Adi yoyna anhabiyen ha agya ayaman.” ");
INSERT INTO abp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Paibat kananyatew, indugi naynan Apo Jesus a ipatanda kanlan mānumbong na, a wana, “Hiko a ibat ha langit a in-Anak nin Tao ket katapulan a magdiha nin malabong a pamaidap. Ikahwil la kon tutoan Jujudio a mānungkolan, mānguna a papadi boy mamaihtodo nin Bibilin. Ipapatey lako noba ha ikatlon mangaamot, mabi-ay akon uman.” ");
INSERT INTO abp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Impalinaw na yatin kaganaan kanlan mānumbong na. Ulin yati, intaang na yan makandi Pedro ye Apo Jesus haka naya pinaghabiyan. ");
INSERT INTO abp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Noba inumadap yay Apo Jesus kanlan mānumbong na haka na pinaghabiyan ye Pedro, “Pakataang ka kangko, Satanas! Hiyay an-ihipen mo, aliwan kalabayan nin Dioh, no aliwan ihip bengat nin tao!” ");
INSERT INTO abp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pangayadi, hiyay Apo Jesus, hinagyat na hilan humaley kana ye tatao boy hilay mānumbong na. Hinabi na kanla, “Ayaman a malabay manumbong kangko, ket katapulan a liwaan nay hadili nan kalabayan boy maghadya yan matey ha panumbong na kangko a ba-mo yan ampamatay nin kodoh. ");
INSERT INTO abp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta ayaman a ampangihilib nin bi-ay na, ket maanam na. Noba ayaman a matey uli kangko boy ha Manged a Balita, ket mabyayan yan bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Agya mapagkonin nin maghay tao ye kaganaan a babandi ihti ha babe-luta, no mipalakew ya met ha kapaduhaan a homain anggaan ye kalelwa na, main ya nayi pakinabang kana ye babandi na? ");
INSERT INTO abp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Main nayi malyadin pamayad ye tao ta-omen ya mabyayan nin bi-ay a homain anggaan? ");
INSERT INTO abp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ayaman a mangikading-ey kangko boy hahabi ko haanin kanlan hilatin tatao a māgkahalanan boy ahe mapatayaan kanan Apo Dioh, hiko a ibat ha langit a in-Anak nin Tao, ket ikading-ey koya met lano ha pag-udong ko a main kapalyadiyan nan Bapa boy kalamo ko hilay aanghil nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hinabi na po Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Main nangaano kanyo ihti ye ahe po matey anggan makit la ye makapalyadiyan a panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pangalabah nin anem a mangaamot, hiyay Apo Jesus, inlamo na yay Pedro, Santiago boy Juan ha matagay a mapantay a hilahilan bengat. Ket legan anti hila ihtew, nakit la a nauman ye kadih nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ket hiyay bado na, ampakapulag uli ha tubat a kaputian. Homain hinyaman ihti ha babe-luta ye makapaputi nin wanabay. ");
INSERT INTO abp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ket nakit la yay Elias boy Moises a ampakitongtong kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hinabi nan Pedro kanan Apo Jesus, “Maihtodo! Manged, ta anti kitawo ihti. Manyag kayin tatlon hongab. Hiyay magha, kammo. Hiyay ikalwa, kanan Moises. Boy hiyay ikatlo, kanan Elias.” ");
INSERT INTO abp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nahabi nan Pedro yatew, ta ahe na tanda no hinyay habiyen na, ulita nalimo hilan tubat. ");
INSERT INTO abp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kapipikhaan, inameyan hilan owep boy main hilan nange a bihnga ha owep a ampaghabin wanae, “Yabayti ye ampakaadoen kon Anak. Leng-en yoy habiyen na!” ");
INSERT INTO abp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pamakange la nin bihnga, in-iwah lay pamilew la, noba homain hilaynan nakit a kanayon, no aliwan hiyay Apo Jesus anan bengat. ");
INSERT INTO abp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ha anlumohan hilayna ha mapantay, binilinan na hilan Apo Jesus, a wana, “Adi yo anhabiyen ha agya ayaman ye nakit yo anggan hiko a ibat ha langit a in-Anak nin Tao, ket mabi-ay uman.” ");
INSERT INTO abp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ket tinupad la met ye bilin na, noba naytepet-tepet hila no hinyay labay habiyen nin hinabi nan Apo Jesus a mabi-ay uman. ");
INSERT INTO abp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ket hilay mānumbong na, tinepet la yay Apo Jesus, “Taket ta anhabiyen lan mamaihtodo nin Bibilin a hiyay Elias a podopita hatew, ket katapulan a muna yan lumateng kanan Cristo?” ");
INSERT INTO abp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Nakibat yay Apo Jesus, “Peteg a muna ya po lumateng ye Elias ta-omen na italadan ye kaganaan. Noba anhabiyen ko kanyo a nilumateng yayna. Ket dinyag lay labay lan diyagen kana a omen ha nakahulat tungkol kana. Noba nakahulat met a hiko a ibat ha langit a in-Anak nin Tao, ket magdiha nin tubat a pamaidap boy umih-umihen lako.” ");
INSERT INTO abp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ha nag-udong hilayna kanlan kanayon po a mānumbong, nakit lay malabong a tataon naytipon ihtew kanla. Anti hila met ihtew ye mamaihtodo nin Bibilin a ampakingatngat kanla. ");
INSERT INTO abp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ha nakit la yan tatao ye Apo Jesus, nagtaka hilan tubat. Ket nayew hilan nanagana kana. Ket in-idlaw laya. ");
INSERT INTO abp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Haanin, hiyay Apo Jesus, tinepet na hilay mānumbong na, “Hinyay ampayngatngatan yo?” ");
INSERT INTO abp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nakibat yay maghan laki kanlan kalabongan nin tatao, “Maihtodo, inlakew koya kammoy anak kon laki, ta hinelpan yan maloke a ihpidito. Ket ahe yayna makahabi. ");
INSERT INTO abp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No anhigiyan yan maloke a ihpidito, ket ampipuang ya boy ampagbola-bola ye bebey na, ampanginaet ya boy ampamaktong. Impakihabi ko kanlan mānumbong mo a paalihen lay maloke a ihpidito kana, noba ahe la yan mapaalih.” ");
INSERT INTO abp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hinabi nan Apo Jesus kanla, “Hikawon tatao haanin a panaon a homain pamteg kanan Apo Dioh, anggan makano katawo po lagin pag-anohan? Ilakew yoya kangko ye anak!” ");
INSERT INTO abp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ket inhaley la yan peteg kanan Apo Jesus. Noba ha nakit na yan maloke a ihpidito ye Apo Jesus, tampol na yan pinakolimpatang ye anak. Ket napuang ya ha luta, pinatulin-tulin naya boy pinabola-bola nay bebey na. ");
INSERT INTO abp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tinepet na yan Apo Jesus ye bapa nan anak, “Nakano ya po nandugi yain?” Nakibat yay bapa na, “Impaibat po ha makandi ya. ");
INSERT INTO abp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maheheg na yan ipuang nin maloke a ihpidito ha apoy o ha lanom ta-omen naya pateyen. Kaya-bay Apo, no main kan madyag, pangiingalo mo, haglapan mo kayi dayi.” ");
INSERT INTO abp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hinabi nan Apo Jesus kana, “Taket ta hinabi mon no main akon madyag? Mapalyadi ye kaganaan ha taon ampamteg kangko.” ");
INSERT INTO abp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Haanin, hiyay bapa, tampol na yan impakakhaw a hinabi, “Ampamteg ako Apo, noba kulang po! Pahanan mo dayi!” ");
INSERT INTO abp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ha nakit nan Apo Jesus a anlumabong hilaynay tatao, pinaghabiyan na yay maloke a ihpidito, “Hikan ihpidito a ampamateek boy ampamaangang kana, ambilinan kata. Umalih ka kana, ket ahe kaynan bega mag-udong kana.” ");
INSERT INTO abp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kinumolih yay maloke a ihpidito, pinapigpig na yay anak, ket inumalih yayna kana. Ket ba-mo yaynan natey ye anak. Kaya-bay hinabi lan tatao, “He, natey yayna!” ");
INSERT INTO abp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Noba hiyay Apo Jesus, ginemgeman nay gamet nan anak, hinaglapan na yan mideng. Ket nideng yay anak. ");
INSERT INTO abp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pangayadi yatew, ha nakaloob hilaynan Apo Jesus ha baey boy hilahilaynan bengat, tinepet la yan mānumbong na, “Taket ta ahe miya napaalih ye maloke a ihpidito kanan anak?” ");
INSERT INTO abp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nakibat yay Apo Jesus, “Hiyay wanabay a kalahin ihpidito, ket mapaalih yan bengat makauli ha pamakigwang.” ");
INSERT INTO abp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Haanin, inumalih hilayna ihtew. Ket ha pangumalih la, nagdān hila ha plobinhiyan Galilea. Hiyay Apo Jesus, ahe na labay a matandaan lan tatao a anti ya ihtew, ");
INSERT INTO abp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ulita ampangiadal ya kanlan mānumbong na. Hinabi na kanla, “Hiko a ibat ha langit a in-Anak nin Tao, ket maigawang lano kanlan mānungkolan. Pateyen lako, noba mabi-ay akon uman ha ikatlon mangaamot.” ");
INSERT INTO abp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ahe la natalohan ye hinabi na, noba angkalimo hilan manepet kana. ");
INSERT INTO abp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Haanin, nilumateng hila ha banwan Capernaum. Ha anti hilayna ha loob nin baey, nanepet yay Apo Jesus kanlan mānumbong na, “Hinyay ampayngatngatan yo nangon ha anti kitawo po ha dān?” ");
INSERT INTO abp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Noba nilong-em hila, ta hiyay pinayngatngatan la, ket no ayay pinakamatagay kanla. ");
INSERT INTO abp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Haanin, nikno yay Apo Jesus haka na hila hinagyat a humaley kana ye mānumbong na. Hinabi na kanla, “Ayaman a malabay mag-ilyadin mānguna, katapulan a mag-ilyadi yan pinakamaaypa boy ipoh ya nin kaganaan.” ");
INSERT INTO abp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Haanin, hiyay Apo Jesus, nanagyat yan maghay makandin anak. Ket pinaideng naya ha adapan la. Pangayadi, binibi naya boy hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ayaman a ampananggap nin omen kananyatin anak uli ha panumbong na kangko, ket antanggapen na koyna met. Ket ayaman a ampananggap kangko, aliwan hikon bengat ye antanggapen na, no aliwan antanggapen na yayna met ye Bapa ko a nangitubol kangko.” ");
INSERT INTO abp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hinabi nan Juan kanan Apo Jesus, “Maihtodo, main kayin nakit a taon ampamaalih nin mangaloke a ihpidito ha ngalan mo. Binawalan miya, ta ahe tawo yan kalamo.” ");
INSERT INTO abp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Noba hinabi nan Apo Jesus, “Adi yoya ambawalan, ta hiyay taon ampanyag nin kapagtakaan ha ngalan ko, ahe ya maghabin maloke laban kangko. ");
INSERT INTO abp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta ayaman a ahe angkumuntada kantawo, ket katupig tawo ya. ");
INSERT INTO abp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pakaleng-en yon manged ye habiyen ko. Ayaman a mamyay kanyon agya maghay bahon lanom bengat ulita mānumbong katawo, ket homain hapo a makatanggap yan plimyo a ibat kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Noba ayaman a manyag nin pagkahalananan lan hilatin aanak a ampamteg kangko, ket mamanged po a bitinan yan mayadet a dapah ye leey na haka ya iampag ha dagat. ");
INSERT INTO abp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No hiyay gamet mo ye pagkahalananan mo, putohen mo yayna. Mamanged po a mamaghay gamet mo, noba mabyayan kan bi-ay a homain anggaan dinan luwa, noba mipalakew ka met ha impilno a ahe angkalep ye apoy. ");
INSERT INTO abp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ket ihtew, hilay oowel a ampangna nin laman la, ahe angkatey boy ahe met angkalep ye apoy.” ");
INSERT INTO abp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“No hiyay bitih mo ye pagkahalananan mo, putohen mo yayna. Mamanged po a mamaghay bitih mo, noba mabyayan kan bi-ay a homain anggaan dinan luwa, noba mipalakew ka met ha impilno. ");
INSERT INTO abp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ket ihtew, hilay oowel a ampangna kanla, ahe hila angkatey boy hiyay apoy ihtew, ket ahe ya angkalep.” ");
INSERT INTO abp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Ket no hiyay mata mo ye hangkan nin pagkahalananan mo, luowen moyna. Mamanged po a mamaghay mata mo a maibilang kanlan anhakopen nan Apo Dioh dinan luwa, noba mipalakew ka met ha impilno. ");
INSERT INTO abp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ket ihtew hilay oowel a ampangna kanla, ahe hila angkatey boy hiyay apoy ihtew, ket ahe ya angkalep. ");
INSERT INTO abp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ta kaganaan a ampamteg, ket magdiha nin kaidapan a omen ha hagpa a kena a ahinan bayo ya ipadan ha apoy.” ");
INSERT INTO abp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Manged ye ahin. Noba no maalih anay apgad na, ahe yayna maiudong. Mag-ilyadi kawo dayin mahilbi ha magha boy magha a omen ha ahin a mahilbi ha kena. Ha wanabay, magkamain kawon paykahundo ha balang magha.” ");
INSERT INTO abp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pangayadi, inumalih yay Apo Jesus ha banwan Capernaum. Ket nakew ya ha plobinhiyan Judea. Nilumipay ya ha kabatowan nin Jordan. Legan anti ya ihtew, malabong ana man a tatao ye nakew nakitipon kana. Ket inadalan na hila a omen ha alan naynan andiyagen. ");
INSERT INTO abp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Legan ampangiadal yay Apo Jesus, main nangaanon Papariseo ye hinumaley kana, ta huboken laya. Kaya-bay tinepet laya, “An-ipaluboh nayi nin Bibilin a ihyay nin laki ye ahawa na?” ");
INSERT INTO abp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tinepet na hila met Apo Jesus, “Hinyay imbilin nan Moises kanyo tungkol ha payngihyay nin miahawa?” ");
INSERT INTO abp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nakibat hila, “Impaluboh nan Moises a malyadin manyag ye laki nin kahulatan nin payngihyay. Pangayadi, malyadi na yaynan ihyay ye ahawa na.” ");
INSERT INTO abp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hinabi nan Apo Jesus kanla, “Inhulat nan Moises yatew a bilin uli ha kabyangan nin ō yo. ");
INSERT INTO abp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Noba ha pamalhowa nan Apo Dioh nin babe-luta, pinalhowa nay tao a laki boy babayi. ");
INSERT INTO abp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kaya-bay lakwanan nan laki ye bapa boy indo na ta-omen hilayna mapaylamo a miahawa. ");
INSERT INTO abp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ket mag-ilyadi hilaynan mamaghan laman. Ha wanabay, aliwa hilaynan luwa, no aliwan mamagha.’ ");
INSERT INTO abp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaya-bay hiyay pinaylamo nan Apo Dioh, ket aliwan hukat payngihyayen nin tao.” ");
INSERT INTO abp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ha anti hilayna ha baey, hilay mānumbong na, tinepet la yayna man ye Apo Jesus tungkol ha payngihyay nin miahawa. ");
INSERT INTO abp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hinabi na kanla, “Ayaman a lakin mangihyay nin ahawa na ket mangahawa yan lumbo, magkahalanan yan pamabayi boy magkahalanan ya kanan unan ahawa na. ");
INSERT INTO abp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wanabay met ateed ye babayi. No makihyay ya kanan ahawa na ket makiahawa yan kanayon a laki, ampakilaki yayna.” ");
INSERT INTO abp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ha maghay mangaamot, main ano kataon nangilakew nin mangakandin aanak la kanan Apo Jesus ta-omen la awoken kana a ipalonto na ye gamet na kanlan aanak boy inged. Noba pinaghabiyan la hilan mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ha nakit nan Apo Jesus ye angkalyadi, napoot ya kanlan mānumbong na, a wana, “Paolayan yo hilay mangakandin aanak a humaley kangko. Adi yo hila anhaaden, ta hilay tataon main pangugali a omen kanlan hilatin aanak ye maibilang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pakaleng-en yon manged ye habiyen ko. Ayaman a ahe ampahakop kanan Apo Dioh a omen ha pagpahakop nin makandin anak, ahe ya bega maibilang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pangayadi, inapnon na hilay aanak boy impalonto nay gamet na ha ō nin balang magha kanla. Ket in-inged na hila. ");
INSERT INTO abp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ha an-umalih yaynay Apo Jesus, main maghan laki ye nayew a nakew nanalimukod ha adapan na. Ket tinepet naya, “Manged a Maihtodo, hinyay hukat kon diyagen ta-omen ako mabyayan nin bi-ay a homain anggaan?” ");
INSERT INTO abp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nakibat yay Apo Jesus kana, “Taket ta anhabtan mo kon manged? Hiyay Apo Dioh bengat ye manged, homain anan kanayon. ");
INSERT INTO abp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Haanin, hiyay tungkol ha tepet mo, tanda moy Bibilin nan Apo Dioh, ‘Adi ka mamatey nin tao. Adi ka makilaki o mamabayi. Adi ka manakaw. Adi ka manihtigoh nin katagowan. Adi ka manguhit. Bihaen moy bapa boy indo mo.’ ” ");
INSERT INTO abp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nakibat yay laki, “Maihtodo, kaganaan hilain, anhumbongen koyna paibat po ha anak ako.” ");
INSERT INTO abp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Maado na yan binilew Apo Jesus. Ket hinabi na kana, “Magha po ye hukat mon diyagen. Muli ka, ta ilako moy kaganaan a babandi mo. Ket hiyay mapaglakoan mo, ibyay mo kanlan mangaidap. Ha wanabay, magkamain kan kabatnangan ha langit. Pangayadi, mag-udong ka ihti, ket manumbong kayna kangko.” ");
INSERT INTO abp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pamakange nan laki ye hinabi nan Apo Jesus, nilumele ye lupa na. Ket malele yan inumalih, ta mabatnang yan tubat. ");
INSERT INTO abp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Haanin, hiyay Apo Jesus, iniwah na hilay tatao haka na hinabi kanlan mānumbong na, “Koynan kaidap maibilang ye mabatnang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nagtaka hilay mānumbong na ha hinabi na. Noba naghabi yayna man Apo Jesus, “Iinong ko, koynan kaidap ye maibilang kanlan anhakopen nan Apo Dioh! ");
INSERT INTO abp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Matataloh ya po a humlep ye maghay kamelyo ha lubot nin kadayem dinan ha maibilang ye taon mabatnang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalalo hilayna man nagtaka ye mānumbong na. Kaya-bay nanepet hila, “No wanabay awod Apo, aya hilaynay miligtah?” ");
INSERT INTO abp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Binilew na hilan Apo Jesus boy hinabi na, “Ahe na mapalyadi nin tao, noba mapalyadi na yan Apo Dioh, ulita mapalyadi nay kaganaan.” ");
INSERT INTO abp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Haanin, hinabi nan Pedro kanan Apo Jesus, “Hikayi nayi, Apo? Ket nilakwanan mi ye kaganaan ta-omen kayi manumbong kammo.” ");
INSERT INTO abp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nakibat yay Apo Jesus, “Pakaleng-en yon manged ye habiyen ko. Ayaman a nanlakwan nin baey na o kakatongno na o tutoa na o aanak na o luta na uli kangko boy ha pangipatanda na nin Manged a Balita, ");
INSERT INTO abp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ket makatanggap ya haanin met ateed a panaon nin magatoh a ukdo ha nilakwanan na a babaey, kakatongno, iindo, aanak boy luta, kalakhip ye pangipaloke. Ket ha lumateng a panaon, mabyayan ya po nin bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Noba malabong a angkauna haanin ye mipahuyot lano boy malabong met a angkahuyot haanin ye miuna lano.” ");
INSERT INTO abp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ha palakew hilayna ha banwan Jerusalem a angkauna yay Apo Jesus kanla, ampagtaka hilay mānumbong na boy angkalimo hilay kanayon a anhumumbong kanla. Haanin, hiyay Apo Jesus, in-ilbo na hilay labinluwan mānumbong na. Ket hinabi nayna man kanla ye malyadi kana. ");
INSERT INTO abp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hinabi na, “Leng-en yo yatin habiyen ko! Makew kitawo haanin ha Jerusalem. Ket hiko a ibat ha langit a in-Anak nin Tao, maigawang kanlan mānguna a papadi boy mamaihtodo nin Bibilin. Uhgaan la kon matey. Pangayadi, igawang lako kanlan aliwan Judio. ");
INSERT INTO abp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Umih-umihen lako, luda-ludaan, hibladen boy pateyen. Noba ha ikatlon mangaamot, mabi-ay akon uman.” ");
INSERT INTO abp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pangayadi, hiyay Santiago boy Juan a aanak nan Zebedeo, hinumaley hila kanan Apo Jesus. Ket hinabi la kana, “Maihtodo, main kayi dayin labay awoken kammo.” ");
INSERT INTO abp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Hinyay awoken yo?” wanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nakibat hila, “No malyadi dayi, Apo, lano ha mamoon kayna, hikayin luwan mikatongno ye mikno ha talig mo. Hiyay magha, ha dapit wanan mo. Hiyay magha met, ha dapit odi mo.” ");
INSERT INTO abp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Noba hinabi nan Apo Jesus kanla, “Ahe yo tanda ye an-awoken yo. Mababa yo nayi a ikpe ye pamaidap a dihaen ko? Boy nakahadya kawoyna lagi a magdiha nin kamateyan a omen ha dihaen ko?” ");
INSERT INTO abp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Awo Apo, mababa mi!” Hinabi nan Apo Jesus kanla, “Hiyay kaptegan, mangikpe kawon pamaidap a omen ha pangikpe ko boy magdiha kawon kamateyan a omen ha dihaen ko, ");
INSERT INTO abp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","noba aliwan hikoy mamili no ayay mikno ha dapit wanan o odi ko, ta yabay-in a iknoan, ket kanlan tataon nangitaladanan nan Bapa ko.” ");
INSERT INTO abp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ha natandaan lan mapo a mānumbong na ye an-awoken lan Santiago boy Juan, napoot hila kanla. ");
INSERT INTO abp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaya-bay hinagyat na hilan kaganaan Apo Jesus a humaley kana. Ket hinabi na kanla, “Tanda yoynabay met a hilay aliwan Judion mānungkolan, ket an-ipilit lay labay la kanlan tataon angkahakopan la. Ket agya hinyaman a labay la, ket angkahumbong. ");
INSERT INTO abp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Noba kanyo, aliwan wanabay. No aliwan, ayaman kanyo ye malabay mag-ilyadin matagay, katapulan a mag-ilyadi yan māghilbi yo. ");
INSERT INTO abp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ket ayaman kanyo ye malabay mag-ilyadin mānguna, katapulan a mag-ilyadi yan ipoh nin kaganaan. ");
INSERT INTO abp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta hiko, agya ibat ako ha langit a in-Anak nin Tao, ket nakew ako ihti ha babe-luta ta-omen maghilbi boy ibyay koy bi-ay ko a pambeh ha malabong a tatao. Ahe ako nakew ihti ta-omen paghilbiyan nin tatao.” ");
INSERT INTO abp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ha ahe nabuyot, hiyay Apo Jesus boy hilay mānumbong na, niabot hilayna ha banwan Jerico. Ket ha an-umalih hilayna ihtew a lamo la hilay malabong a tatao, ha danan la, main maghay kapkap a ampikno a ampagpalimoh ha gilid nin dān. Hiyay ngalan na ket Bartimeo a anak nan Timeo. ");
INSERT INTO abp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Haanin, ha nange nan Bartimeo a hiyay Jesus a taga Nazaret, ket anhumapid yayna ha eteb na, nangha ya, a wana, “Apo Jesus a Lahi nan David, ingalowan moko!” ");
INSERT INTO abp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pinaghabiyan la yan tatao, a wanla, “Pakal-em ka!” Noba inlalo nayna ingat impangha, a wana, “Lahi nan David, ingalowan moko!” ");
INSERT INTO abp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pamakange nan Apo Jesus nin pangha na, tinumgen ya. Ket hinabi na, “Hagyaten yo yan makew ihti.” Ket hinagyat la yay kapkap, a wanla, “Pakhawen moy nakem mo! Mideng ka, ta man-ipahagyat na kan Jesus!” ");
INSERT INTO abp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Haanin, inwahik nay kepkep na. Ket tampol yan nideng. Ket hinumaley ya kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tinepet na yan Apo Jesus, “Hinyay labay mo a diyagen ko kammo?” Nakibat yay Bartimeo, “Apo, labay koy makakit.” ");
INSERT INTO abp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hinabi nan Apo Jesus kana, “Muli kayna. Nitaah kayna uli ha pamteg mo kangko!” Ket tampol yaynan ampakakit boy nanumbong yayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Haanin, ha maga hilaynan miabot ye Apo Jesus ha banwan Jerusalem, tinumgen hila ha Mapantay nin Oolibo a mahaley met ha Betfage boy Betania. Pinauna na hilay luway mānumbong na, ");
INSERT INTO abp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a wana, “Makew kawo ha dongla a badiyo. Ket pamiabot yo ihtew, main kawon makit a maghay oybon ahnon nakah-el a ahe po bega nahakayan. Loaten yoya boy tengtengen yoya ihti. ");
INSERT INTO abp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No main manepet kanyo, ‘Uy! Taket ta anloaten yo yay ahno?’ habiyen yo kana, ‘Matapul na yan Apo, ket tampol naya met iudong.’ ” ");
INSERT INTO abp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaya-bay nakew hilaynay luwa. Ket nakit la yan peteg ye oybon ahno ha gilid dān a nakah-el ha ilwangan nin baey. Ha anloaten layna, ");
INSERT INTO abp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tinepet hilan nangaanon tataon ampideng ihtew, “Uy! Taket ta anloaten yo yay oybon ahno?” ");
INSERT INTO abp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Haanin, hinabi lay impahabi nan Apo Jesus kanla. Ket pinalubohan la hilayna. ");
INSERT INTO abp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Haanin, hilay luwan mānumbong, tinengteng la yay oybon ahno kanan Apo Jesus. In-apay lay kepkep la ha golot nin oybon ahno. Ket hinakayan na yayna met Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Malabong a tatao ye nangiamlak nin kepkep la ha pagdanan nan Apo Jesus. Hilay kanayon met, nanlahngi hilan papalapa a mablong ha pananeman. Ket in-amlak la met ha pagdanan na. ");
INSERT INTO abp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ket hilay tatao a anti ha unaan boy huyotan nan Apo Jesus, an-ipapangha la, a wanla, “Galangen yay Apo Dioh! Inged na yan Apo Dioh ye anlumateng ha ngalan na. ");
INSERT INTO abp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Inged na yan Apo Dioh ye anlumateng a panakopan nan unan tutoa tawon Poon David! Galangen tawo yay Apo Dioh a anti ha langit!” ");
INSERT INTO abp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pamiabot nan Apo Jesus ha banwan Jerusalem, nakew ya ha mahlang nin Timplo. Binilew nay kaganaan ihtew. Ket ulita andudumeglem ana, nilumwah ya. Ket nag-udong yayna ha Betania, lamo na hilay labinluwan mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kabekahan, ha an-umalih hilayna ha Betania paudong ha Jerusalem, nabitlan yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Haanin, natamulaw nay mablong a poon-kayon igoh. Hinaleyan na yan binilew no main yan dawa. Noba homain yan nakit, no aliwan kabobong bengat, ta aliwa po panaon nin panawa nin poon-kayon igoh. ");
INSERT INTO abp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hinabi nan Apo Jesus ha poon-kayo, “Agya makanoman, agkayna makapanawa.” Ket hilay mānumbong na, nange lay hinabi na. ");
INSERT INTO abp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ha nakaudong hilayna ha Jerusalem, nakew yay Apo Jesus ha mahlang nin Timplo. Ket intaboy na hilay ampaglako boy ampanaliw ihtew. Imbabalintog nay lalamihaan lan mānagilin pilak lan dadayohan boy imbabalintog nay iknoan lan māglako nin kalapati a an-ihagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Binawalan na hilaynan mangaget nin lalako la ha mahlang nin Timplo. ");
INSERT INTO abp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Boy inadalan na hilay tatao ihtew, a wana, “Hiyay naihulat a Habi nin Dioh, ‘Hiyay baey ko, mahabtan yan baey pamakigwangan nin kaganaan a nanahyon.’ Noba dinyag yo yan payngikbengan nin mānakaw!” ");
INSERT INTO abp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hilay mānguna a papadi boy mamaihtodo nin Bibilin, nangean lay dinyag nan Apo Jesus. Kaya-bay paibat kananyatew, ampangihip hilaynan papadan no way-omen la yan maipapatey. Angkalimo hila kana, ulita ampagtaka hilay malabong a tatao ha pangiadal na. ");
INSERT INTO abp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ha madeglem ana, hiyay Apo Jesus boy hilay mānumbong na, inumalih hilayna ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kabekahan ha mahanib, ha ampag-udong hilayna man ha banwan Jerusalem, nadanan la yay poon-kayon igoh. Ket nakit lan mānumbong a nayango yayna. ");
INSERT INTO abp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Haanin, naihipan nan Pedro ye hinabi nan Apo Jesus ha poon-kayon igoh. Kaya-bay hinabi na kanan Apo Jesus, “Maihtodo, bilewen mo ye poon-kayon igoh a tinuboyan mo naapon. Nayango yayna.” ");
INSERT INTO abp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hinabi nan Apo Jesus kanla, “Mamteg kawo kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pakaleng-en yon manged ye habiyen ko. No main kawon pamteg boy adi kawo ampagluwaluwa, malyadi yon habiyen kananyatin mapantay, ‘Kokayna ha dagat’, ket mapalyadi ye hinabi yo. ");
INSERT INTO abp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kaya-bay pakaihipen yo. Hinyaman a awoken yo kanan Apo Dioh makauli ha pamakigwang, pamtegan yo a ibyay na kanyo, ket homain hapo a matanggap yo. ");
INSERT INTO abp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","No makigwang kawo, patawaden yo hila po ye nagkahalanan kanyo ta-omen na kawo met patawaden Bapa yon anti ha langit. ");
INSERT INTO abp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta no ahe kawo mamatawad, hiyay Apo Dioh a Bapa tawo ha langit, ahe na kawo met patawaden.” ");
INSERT INTO abp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ha niabot hilaynan Apo Jesus ha Jerusalem, nakew yayna man ha Timplo. Ket legan angkumodang ya ha mahlang nin Timplo, hinaleyan la yan mānguna a papadi, mamaihtodo nin Bibilin boy tutoan Jujudio a mānungkolan. ");
INSERT INTO abp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tinepet laya, “Hinyay katulidan mon manyag nin didinyag mo naapon? Ayay namyay kammo nin katulidan?” ");
INSERT INTO abp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nakibat yay Apo Jesus kanla, “Tepeten katawo met. No pakibatan yoko, habiyen ko kanyo no ayay namyay kangko nin katulidan a manyag nin wanabay. ");
INSERT INTO abp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yati ye tepet ko kanyo, ‘Ayay namyay kanan Juan nin katulidan a mamawtihmo? Hiyay Apo Dioh o tao? Hinyay mahabi yo?’ ” ");
INSERT INTO abp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ket pinaytongtongan la, a wanla, “No habiyen tawo a hiyay Apo Dioh, habiyen na met kantawo, ‘Taket awod ta ahe yoya pinamtegan ye Juan?’ ");
INSERT INTO abp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Noba no habiyen tawo met a tao, kapootan la kitawon tatao!” Angkalimo hila kanlan tatao, ta ampamtegan lan kaganaan a hiyay Juan, ket podopita na yan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaya-bay hinabi la, “Ahe mi tanda!” Hinabi na met Apo Jesus kanla, “No wanabay awod, ahe ko met habiyen kanyo no ayay namyay kangko nin katulidan a manyag nin andyagen ko.” ");
INSERT INTO abp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pangayadi yatew, impahulong nan Apo Jesus ye paghabi na kanlan tatao makauli ha pangilalayi, a wana, “Main maghay laki a nananem nin ubah ha pananeman na. Pinaaladan naya boy namadyag yan pamihnakan ubah. Namadyag ya po nin matagay a baag a kunaan nin māgbantay. Pangayadi, pinaabangan nay ubahan na kanlan māmakitalon. Ket nakew yayna ha mataang a lugal. ");
INSERT INTO abp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ha panaon anan pamupol nin ubah, nangitubol yan maghay ipoh na a mangwa nin dakay na kanlan māmakitalon. ");
INSERT INTO abp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Noba dinakep la yan māmakitalon ye intubol na, binogbog laya haka la yan pinaalih a homain kaget. ");
INSERT INTO abp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ket nangitubol yayna man nin kanayon a ipoh na ye nagkonin nin ubahan, noba binadog lay ō na haka laya pinapading-eyan. ");
INSERT INTO abp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nangitubol yayna man nin kanayon a ipoh na, noba pinatey laya. Malabong hila po ye intubol na, noba binogbog la hilay kanayon. Ket hilay kanayon met, pinatey la hila.” ");
INSERT INTO abp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Haanin, mamagha yaynan bengat ye malyadi nan itubol, hiyay ampakaadoen na a anak. Ket intubol naya, ta an-ihipen na a bihaen lay anak na. ");
INSERT INTO abp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Noba ha natamulaw la yan māmakitalon ye anak na a andumaho, hinabi la, ‘Anti yaynay manawid! Pateyen tawo ya ta-omen tawo mapagkonin ye tawiden na.’ ");
INSERT INTO abp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaya-bay hiyay dinyag la kana, dinakep la yan ingguloy a pinatey ha ilwah nin ubahan.” ");
INSERT INTO abp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Haanin, nanepet yay Apo Jesus, “Hinya lagi ye diyagen nan nagkonin nin ubahan? Homain hapo a lakwen na hilan pateyen. Pangayadi, ipaupa nayna ha kanayon ye ubahan na. ");
INSERT INTO abp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ahe yo po nayi nabaha ye naihulat a Habi nin Dioh a wanae, ‘Hiyay dapah a ingkahwil lan māmaideng nin baey, hiyabay ye ginawi a pundahyon nin baey. ");
INSERT INTO abp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Diyag nin Dioh yati, ket koynan kapagtakaan kantawo!’ ” ");
INSERT INTO abp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Natalohan lan māngunan Jujudio a hilabay ye andektan nin pangilalayi nan Apo Jesus. Kaya-bay labay la yayna dayin dakpen. Noba angkalimo hila kanlan tatao. Kaya-bay pinaolayan la yayna. Ket inumalih hilayna. ");
INSERT INTO abp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ha ahe nabuyot, hilay māngunan Jujudio, nangitubol hilan nangaanon Papariseo boy tatao nan Gobilnadol Herodes Antipas a makew manepet kanan Apo Jesus, ta labay la yan kaloten ha hahabi na. ");
INSERT INTO abp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hinumaley hila kanan Apo Jesus. Ket hinabi la, “Maihtodo, tanda mi a pawa peteg ye anhabiyen mo boy homain kan antupigan a tao, ta padipadiho ye pamilew mo ha kaganaan. Boy hiyay kaptegan tungkol ha kalabayan nan Apo Dioh ye an-iadal mo kanlan tatao. Haanin, main kayin tepet kammo. Ha ihip mo, huhto laweh a mamayad kitawon bowih ha Emperador nin Roma o ahe?” ");
INSERT INTO abp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Noba tanda nan Apo Jesus a ampagkonwadi hilan bengat. Kaya-bay hinabi na kanla, “Taket ta labay yo kon kaloten? Gawangan yoko man nin palatan Roma, ta bilewen ko man!” ");
INSERT INTO abp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ket ginawangan la yan palata. Haanin, hiyay Apo Jesus, impakit nay palata boy tinepet na hila, “Ayay naglupa boy nagngalan ye nakadokit ihti?” “Hiyay Emperador Cesar,” wanla. ");
INSERT INTO abp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hinabi nan Apo Jesus kanla, “Hiyay kanan Emperador Cesar, ibyay yo. Ket hiyay kanan Apo Dioh, ibyay yo met.” Ket nagtaka hila kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Haanin, hilay Sasaduseo, nakew hilan nanepet kanan Apo Jesus. Hilabay ye pangkat nin tatao a ahe ampamteg a mabi-ay uman ye nangamatey. Hinabi la kanan Apo Jesus, ");
INSERT INTO abp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maihtodo, hiyay anti ha Bibilin a impahulat kanan Moises, wanae ya. No matey yay ahawan laki, ket ahe ya nagkaanak kanan ahawa na, katapulan a ikahal nin katongno nan laki ye bawo. Ket no magkaanak hila, maibilang yan anak nin katongno na a natey.” ");
INSERT INTO abp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Haanin, main pitoy lalaki a mikakatongno. Hiyay punganay, nangahawa ya. Noba natey yan ahe nagkaanak kanan ahawa na. ");
INSERT INTO abp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ket hiyay ikalwa, inahawa na yay ipag na a bawo. Noba natey ya met ateed a ahe hila nagkaanak. Wanabay met ateed ye nalyadi ha ikatlo. Natey ya met ateed a ahe nagkaanak. ");
INSERT INTO abp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kaganaan hilatin mikakatongno, napag-ahawa la yay ipag la, noba ahe hila nagkaanak kana. Ha kalinghuyotan, natey ya met ye babayi. ");
INSERT INTO abp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haanin, wanae ye tepet mi kammo, ‘Ha panaon a mabi-ay uman ye nangamatey, aya lagi kanlan pitoy mikakatongno ye ahawa nan babayi, ta napag-ahawa na hilan kaganaan?’ ” ");
INSERT INTO abp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nakibat yay Apo Jesus kanla, “Aliwan huhto ye ihip yo, ta ahe yo angkatalohan ye naihulat a Habi nin Dioh boy hiyay kapalyadiyan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta lano ha mabi-ay hilaynan uman ye nangamatey, ket ahe hilaynan mangahawa. Mag-ilyadi hilaynan omen kanlan aanghil ha langit a ahe ampangahawa. ");
INSERT INTO abp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ket hiyay tungkol met ha pagkabi-ay uman nin nangamatey, ahe yo nayi nabaha ye impahulat kanan Moises? Ha anti yay Moises ha haley nin mahipok a poon-kayon andumlag, hinabi nan Apo Dioh kana, ‘Hikoy Dioh nan Abraham, Dioh nan Isaac boy Dioh nan Jacob.’ ");
INSERT INTO abp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hiyay labay habiyen, angkabi-ay hila po. Ta hiyay Apo Dioh, ket Dioh nin angkabi-ay, aliwan nangamatey. Kaya-bay nagkamali kawo.” ");
INSERT INTO abp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Haanin, main maghay maihtodo nin Bibilin a anti ihtew. Ket nange nay payngangatngat la. Nange na met a manged ye pakibat nan Apo Jesus kanlan Saduseo. Kaya-bay nanepet ya met, “Hinyay pinakamaalaga kanlan kaganaan a bibilin nan Apo Dioh?” ");
INSERT INTO abp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nakibat yay Apo Jesus, “Hiyay pinakamaalaga a bilin nin Dioh, ket wanae ya, ‘Leng-en yon lahin Israel. Hiyay Apo tawon Dioh, mamagha ya boy homain anan kanayon. ");
INSERT INTO abp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kaya-bay adoen mo yay Apo mon Dioh nin luboh ha puho mo, luboh ha kalelwa mo, luboh ha ihip mo boy ha kaganaan a kakhawan mo.’ ");
INSERT INTO abp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hiyay ikalwa, wanae ya, ‘Adoen moy kapadiho mon tao nin omen ha pangado mo nin hadili mo.’ Homain anan kanayon a bilin ye maaalaga po kanlan hilatin luwa.” ");
INSERT INTO abp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hinabi nan maihtodo nin Bibilin kanan Apo Jesus, “Huhto ye hinabi mo, Maihtodo, a mamaghan bengat ye Apo Dioh boy homain anan kanayon, no aliwan hiyabay bengat. ");
INSERT INTO abp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Boy katapulan yan adoen nin luboh ha puho, luboh ha ihip, boy ha kaganaan a kakhawan. Boy hiyay kapadiho tawon tao met, katapulan tawo yan adoen nin omen ha pangado tawo nin hadili tawo. Igit hilan maalaga hilatin luwan bibilin dinan ha kaganaan a hagpa a iulam boy hilay kanayon po a hahagpa.” ");
INSERT INTO abp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pamakange nan Apo Jesus a huhto ye pakibat na, hinabi na kana, “Madanon kaynan maibilang kanlan anhakopen nan Apo Dioh!” Ket paibat ana kananyatew, homain anan bega nagngaya a manepet kana. ");
INSERT INTO abp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Minghan, legan ampangiadal yay Apo Jesus ha mahlang nin Timplo, tinepet na hilay tatao, “Taket ta anhabiyen lan mamaihtodo nin Bibilin a hiyay Cristo, ket lahi na yan Poon David? ");
INSERT INTO abp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ket hinabi na met David makauli ha haglap nin Ihpiditon Dioh ye tungkol kanan Cristo, ‘Hinabi nan Apo Dioh kanan Apo ko, “Mikno ka ihti ha dapit wanan ko angga ha mapahuko ko hila kammo ye kakaaway mo!” ’ ” ");
INSERT INTO abp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Haanin, hinabi nan Apo Jesus kanlan tatao, “No hiyay Poon David ket hinabtan na yan ‘Apo’ ye Cristo, way-omen la yan mahabi nin tatao a lahi na yan bengat nin David ye Cristo?” Ket hilay malabong a tatao, naaliket hilan nanlenge kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hinabi na po Apo Jesus ha pangiadal na, “Mag-alla kawo kanlan mamaihtodo nin Bibilin. Kalalabay lay magpahyal a nakahoot nin makadang a tapih ta-omen la ihipen nin tatao a mangatoynong hilan tatao. Kalalabay la met ye maidlaw nin tataon angkadanan la ");
INSERT INTO abp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","boy kalalabay la po ye mikno ha pamiknoan a nakataladan kanlan mangadangal a tatao ha pāytiponan lan Jujudio boy ha poniyan. ");
INSERT INTO abp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ampaglanganan la hilay bawon babayi. Ampagmamangedan hila ha adapan lan malabong a tatao makauli ha makadang a pakigwang la. Kaya-bay mamabyat lano ye ipaduha nan Apo Dioh kanla.” ");
INSERT INTO abp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pangayadi yatew, hiyay Apo Jesus, nikno ya ha haley nin pangitukoyan nin pilak a magawi ha Timplo. Nakit na hilay tataon ampangitukoy nin pilak. Ket malabong a mangabatnang ye nangitukoy nin malabong a pilak. ");
INSERT INTO abp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Haanin, main maghay maidap a bawon babayi a nangitukoy nin luway palatan tanho. ");
INSERT INTO abp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Haanin, hiyay Apo Jesus, hinagyat na hilan humaley kana ye mānumbong na. Ket hinabi na, “Pakaleng-en yon manged ye habiyen ko. Hiyay intukoy nan maidap a bawon babayi, ket maiigit ya dinan ha intukoy lan kaganaan a nangitukoy. ");
INSERT INTO abp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta hiyay intukoy lan kaganaan a mangabatnang, ket hiyay ahe layna minga katapulan ha bi-ay la. Noba hiyay maidap a bawon babayi, ket inlumpoh nan intukoy ye ikabi-ay na.” ");
INSERT INTO abp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ha an-umalih hilaynan Apo Jesus boy mānumbong na ha Timplo, hinabi nin magha kanlan mānumbong na, “Maihtodo, bilewen mo hilatin impaideng ha palibot nin Timplo! Koynan kaada hilatin babaey boy kangayadet a dadapah ye ginawi lan nanyag!” ");
INSERT INTO abp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hinabi nan Apo Jesus, “Angkakit yo hilain a mangayadet a babaey. Lumateng lanoy panaon a mangaagwat hilan kaganaan. Ket homain lanon bega mabantak a dadapah a naypalingping.” ");
INSERT INTO abp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Haanin, ha ampikno hilaynan Apo Jesus ha gilid nin Mapantay nin Oolibo a nakaadap ha Timplo, hiklito la yan tinepet Pedro, Santiago, Juan, boy Andres, a wanla, ");
INSERT INTO abp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Apo, habiyen mo man kammi no makano lumateng yain a panaon a hinabi mo boy hinyay pagkakitan no madanon anan malyadi?” ");
INSERT INTO abp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hinabi nan Apo Jesus kanla, “Mag-alla kawo ta-omen la kawo ahe matalingo nin agya ayaman, ");
INSERT INTO abp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ta malabong hila lanoy lumateng a manggawi nin ngalan ko, a wanla, ‘Hiko ye Cristo a impangako nan Apo Dioh.’ Ket ulin yati, malabong hila lanoy tataon matalingo. ");
INSERT INTO abp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","No mangean yoynay gubat ha mahaley kanyo boy ha mataang a lulugal, adi kawo angkahindak, ta katapulan a malyadi hilatew, noba aliwa po yain ye kalampuhan nin babe-luta. ");
INSERT INTO abp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta maygugubat lano ye nanahyon boy wanabay met ye papanakopan. Manlayon nin mangakhaw ha nakahinadi a lulugal boy magkamain met nin bitil. Noba yatin kaganaan ket pandugi po bengat nin kaidapan a omen ha pandugi nin panlamlam nin babayin manganak.” ");
INSERT INTO abp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mag-alla kawo, ta dakpen la kawon ilakew kanlan mānungkolan boy hibladen la kawo ha loob nin pāytiponan lan Jujudio. Ket uli ha panumbong yo kangko, dakpen la kawon iadap kanlan gogobilnadol boy kanlan popoon. Ket yabaytew yaynay panaon yo a mangipapteg kanla nin tungkol kangko. ");
INSERT INTO abp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Katapulan po a maipatanda ye Manged a Balita ha kaganaan a nanahyon bayo ya maabot ye kalampuhan.” ");
INSERT INTO abp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“No dakpen la kawon iadap ha panuhgaan, adi yo angkahindakan no hinyay habiyen yo. Kananyatew met ateed, habiyen yoyna bengat ye an-ipahabi nin Ihpiditon Dioh kanyo, ulita aliwan hikawo ye maghabi, no aliwan hiyay Ihpiditon Dioh makauli kanyo. ");
INSERT INTO abp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kananyatew a panaon, main tataon mangiopit nin kakatongno la ta-omen pateyen. Main met tutoan mangiopit nin aanak la ta-omen pateyen. Boy main met aanak a lumaban ha tutoa la boy mangipapatey. ");
INSERT INTO abp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Uli ha panumbong yo kangko, pag-inakitan la kawon kaganaan a tatao. Noba ayaman a mikakaantin mapatayaan anggan kalampuhan, ket miligtah ya.” ");
INSERT INTO abp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hinabi na po Apo Jesus, “Makit yoya lano ye ampakailoy a makapadinat nin Timplo a ampideng ha lugal a bawal nan pidengan. Hikawon ampamaha nin yati, katapulan a pakaihipen yo yatin manged. No malyadi yayna yati, hilay anti ha plobinhiyan Judea, katapulan laynan tumakah palakew ha mamapantay. ");
INSERT INTO abp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hiyay anti ha ilwah nin baey na, ket adi yayna lumoob a mangwan hinyaman a bagay ha baey na. ");
INSERT INTO abp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ket hiyay anti ha talon, adi yayna muli a mangwan kepkep na. ");
INSERT INTO abp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kananyatew a mangaamot, kakaingalo hilay mangabuktot boy hilay iindo a ampamahoho, ta maidapan hilan mayew! ");
INSERT INTO abp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipakigwang yo kanan Apo Dioh a hilatin mangalyadi, ket ahe dayin maigena ha panaon nin kaudanan. ");
INSERT INTO abp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta kananyatew a mangaamot, madihaan lan tatao ye tubat a kaidapan a ahe po nalyadi paibat ha pinalhowa nan Apo Dioh ye babe-luta angga haanin a panaon boy ahe yayna lano mauman. ");
INSERT INTO abp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ket no ahe na tekbean Apo Dioh yatew a panaon, homain taon mapatla a angkabi-ay. Noba uli kanlan tataon pinili na, intekbe na yatew a panaon.” ");
INSERT INTO abp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ket kananyatew a panaon, no main maghabi kanyo nin wanae, ‘Bilewen yo, anti ya ihti ye Cristo!’ o ‘Bilewen yo, anti ya ihtew ye Cristo!’ ket adi yoya ampamtegan. ");
INSERT INTO abp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta lumtaw hila lano ye ampagkonwadin Cristo boy ampagkonwadin popodopita. Ket mangipakit hilan pagkakitan boy kapagtakaan, ta labay la hilan talingowen ye kaganaan a tatao boy no malyadi bengat, agya hilay pinili nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaya-bay mag-alla kawo awod! Hinabi koyna kanyo yatin kaganaan a babagay bayo ya po malyadi ta-omen kawo ahe matalingo.” ");
INSERT INTO abp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hinabi na po Apo Jesus, “Pangayadi nin yatew a panaon nin tubat a kaidapan, tampol yan lumiteh ye mangaamot boy ahe yayna bega humnag ye bowan. ");
INSERT INTO abp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hilay bibitoen, mangaampag hila boy eyegen nan Apo Dioh ye kaganaan a babagay a anti ha lowang anggayna ha mapaywahag-wahag hilayna. ");
INSERT INTO abp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pangayadi, hiko a ibat ha langit a in-Anak nin Tao, ket makit la kon anti ha owep a an-umaypa a main tubat a kapalyadiyan boy kahnagan. ");
INSERT INTO abp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ket itubol ko hilay aanghil ko ha kaganaan a pahen nin babe-luta ta-omen la hila tiponen ye tataon pinili ko.” ");
INSERT INTO abp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Haanin, hinabi na po Apo Jesus, “Pakatalohan yon manged yatin adal tungkol ha poon-kayon igoh. No tumbek yaynay bayon bōng ha hahanga na, tanda yoyna a madanon anay kaingitan. ");
INSERT INTO abp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wanabay met ateed lano. No makit yoynan angkalyadina yatin anhabiyen ko, tanda yoyna a madanon akoynan lumateng a ba-mo koynan anti ha ilwangan. ");
INSERT INTO abp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pakaleng-en yon manged ye habiyen ko. Bayo hila po matey ye kaganaan a tataon angkabi-ay kananyatin panaon, matupad ana hilatin kaganaan a hinabi ko. ");
INSERT INTO abp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hiyay lowang boy babe-luta, ket maanam ya. Noba hilay hahabi ko, ket mikakaanti yan makanoman.” ");
INSERT INTO abp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hinabi na po Apo Jesus, “Homain kanayon a nagtanda nin mangaamot o odah nin pag-udong ko, agya po hilay aanghil ha langit o hiko man a Anak nin Dioh, no aliwan hiyay Bapa a Dioh bengat. ");
INSERT INTO abp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaya-bay mag-alla kawo boy lanang kawon nakahadya, ta ahe yo tanda no makano kon lumateng.” ");
INSERT INTO abp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Hiyay pag-udong ko, ket mailalayi ya ha dinyag nin maghay taon nakew ha mataang a lugal. Noba bayo ya inumalih ha baey na, binyan na hilan obdaen ye balang ipoh na boy binilinan na yay māgbantay ha ilwangan nin baey na a katapulan yan lanang a nakahadya ha panlumateng na.” ");
INSERT INTO abp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kaya-bay lanang kawon nakahadya, ta ahe yo tanda no makano yan lumateng ye nagkonin nin baey. Mapalyadin madeglem o bengay madeglem, palbangon o mahanib. ");
INSERT INTO abp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Maka mioblak akon lumateng, ket malatngan katawon angkatuloy. ");
INSERT INTO abp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kaya-bay hiyay anhabiyen ko kanyo, anhabiyen ko met ha kaganaan a tatao, ‘Lanang kawo dayin nakahadya!’ ” ");
INSERT INTO abp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Haanin, luluwa tanan mangaamot, ket Pihtayna nin Pangihipan nin Pangiligtah boy Pihtan Tinapay a Homain Pamalbag. Hilay mānguna a papadi boy hilay mamaihtodo nin Bibilin, ket ampangihip hilan papadan no way-omen la yan dakpen boy ipapatey ye Apo Jesus a homain bega kanayon a makatanda. ");
INSERT INTO abp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hinabi la, “Noba ahe tawo igena ha pihta, ta maka magkagulo hilay tatao.” ");
INSERT INTO abp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Haanin, anti yay Apo Jesus ha badiyon Betania ha baey nan Simon a kinating hatew. Legan ampakidungo yay Apo Jesus, hinumaley ya kana ye maghay babayin ampangaget nin pabangon mablin tubat a naikonin ha maghay botin alabahtodo. Yatin pabango ket pudon nardo. Linokatan na yan babayi ye boti haka na yan intiih ha ō nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ket hilay nangaanon tatao a anti ihtew, napoot hila, a wanla, “Taket ta hinayang na yain a pabango? ");
INSERT INTO abp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mailako ya dayi yain ha alaga nin howildo nin maghay tao ha maghay taon. Ket hiyay mapaglakoan, maibyay kanlan mangaidap.” Ket tubat ye pangapoot la kanan babayi. ");
INSERT INTO abp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Noba hinabi nan Apo Jesus kanla, “Taket ta ampakibalabalaan yoya? Manged ye dinyag na kangko. ");
INSERT INTO abp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hilay mangaidap, lanang hilan anti kanyo boy hinyaman a odah a labay yo, ket malyadi yo hilan haglapan noba hiko, ahe. ");
INSERT INTO abp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yatin babayi, dinyag nay kaganaan mababa nan diyagen kangko. Intiih nay pabango ha laman ko bilang pangitaladan ha pagkailbeng. ");
INSERT INTO abp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pakaleng-en yon manged ye habiyen ko. Agya way-ihtew man a lugal ihti ha babe-luta maipatanda ye Manged a Balita, ket maipatanda ya met ye dinyag nin yatin babayi kangko bilang pangihipan kana.” ");
INSERT INTO abp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Haanin, hiyay Judas Iscariote a magha kanlan labinluway mānumbong nan Apo Jesus, nakew ya kanlan mānguna a papadi ta-omen naya iopit ye Apo Jesus kanla. ");
INSERT INTO abp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ha natandaan lay tikih nan Judas Iscariote, naaliket hila. Ket impangako la kana a biyan la yan pilak. Kaya-bay impaibat ana kananyatew, ampangagad yayna nin panaon a mahaglapan na hilan mandakep kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ha unan mangaamot nin Pihtan Tinapay a Homain Pamalbag, hilay Jujudio, katapulan lay manapo nin oybon tupa a kena la ha Pihtan Pangihipan nin Pangiligtah. Kaya-bay hilay mānumbong nan Apo Jesus, tinepet laya, “Way-ihtew nayi ye labay mon pangitaladanan min pandem ha Pihtan Pangihipan nin Pangiligtah?” ");
INSERT INTO abp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Haanin, hiyay Apo Jesus, nangitubol yan luway mānumbong na, a wana, “Makew kawo ha banwan Jerusalem. Ket makahagana kawon maghay lakin ampangaget nin halaw a main lanom. Humbongen yoya ");
INSERT INTO abp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ha baey a looben na. Ket habiyen yo kanan nagbaey, ‘An-ipatepet nan Maihtodo no way-ihtew ye hilid a malyadi nan pandeman ha Pihtan Pangihipan nin Pangiligtah a kadungo na hilay mānumbong na?’ ");
INSERT INTO abp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ket ipakit na kanyo ye maghay maway a hilid ha tagay a main anan nakataladan a kahangkapan. Ihtewbay kawo mangitaladan nin pandeman tawo.” ");
INSERT INTO abp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ket hilay luway mānumbong na, inumalih hilayna. Ket ha niabot hilayna ha banwan Jerusalem, nakit lay kaganaan a omen ha hinabi nan Apo Jesus kanla. Ket intaladan lay pandeman la ha Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ha madeglem ana, hiyay Apo Jesus boy hilay labinluwan mānumbong na, nakew hilayna ihtew ha maway a hilid. ");
INSERT INTO abp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ha ampangan hilayna, hinabi nan Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Magha kanyo a kadungo kon ampangan ye mangiopit kangko.” ");
INSERT INTO abp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pamakange lan mānumbong na, nalele hila. Ket balang magha kanla, nanepet kana, “Hiko nayi yatew?” ");
INSERT INTO abp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nakibat yay Apo Jesus kanla, “Magha ya kanyon labinluwan mānumbong ko, hiyay kakidlan kon ampangidede nin tinapay ha kulo. ");
INSERT INTO abp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta hiko a ibat ha langit a in-Anak nin Tao, ket katapulan a matey a omen ha naihulat a Habi nin Dioh. Noba kakaingalo yay taon mangiopit kangko. Mamanged po dayi a ahe yayna nianak.” ");
INSERT INTO abp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Legan ampangan hila, hiyay Apo Jesus, nangwa yan tinapay. Ket pinahalamatan naya kanan Apo Dioh. Pangayadi, binih-ilbih-il na haka na inggawang kanlan mānumbong na, a wana, “Kowen yo yati boy kanen yo. Yati ye pinagkalaman ko.” ");
INSERT INTO abp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pangayadi, nangwa ya po nin maghay bahon alak ubah. Ket pinahalamatan naya kanan Apo Dioh. Inggawang na kanlan mānumbong na. Ket ninom hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hinabi na kanla, “Yatin alak ye pinagkadaya ko a maibuhboh ha ikanged nin malabong a tatao. Yati ye pamapteg nin bayon kahundoan nan Apo Dioh ha tao. ");
INSERT INTO abp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pakaleng-en yon manged ye habiyen ko. Ahe akoynan minom nin alak ubah angga ha mangaamot a minom akon bayon alak ha panakopan nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ket nagkanta hilan panggalang kanan Apo Dioh. Pangayadi, nakew hilayna ha Mapantay nin Oolibo. ");
INSERT INTO abp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Legan angkumodang hila, hinabi nan Apo Jesus kanlan mānumbong na, “Hikawon kaganaan, lakwanan yoko lano, ta wanae ye naihulat a Habi nin Dioh, ‘Pateyen ko yay pahtol, ket maahwag hilay tutupa.’ ");
INSERT INTO abp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Noba lano ha mabi-ay akon uman, mauna ko kanyo ha plobinhiyan Galilea.” ");
INSERT INTO abp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hinabi nan Pedro, “Apo, agya lakwanan la kan kaganaan, noba hiko, ahe kata lakwanan!” ");
INSERT INTO abp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hinabi nan Apo Jesus kana, “Pakaleng-en mon manged ye habiyen ko kammo. Pedro, haanin met ateed a madeglem, bayo yan tumnoy nin mikalwa ye tandang, nikatlo mo koynan imbudi.” ");
INSERT INTO abp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Noba mahehpet nan hinabin Pedro, “Agya lamo mo kon matey, ahe kata bega ibudi.” Wanabay met ateed ye hinabi lan kaganaan a mānumbong na. ");
INSERT INTO abp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pangayadi yatew, hiyay Apo Jesus boy mānumbong na, nakew hilayna ha lugal a anhabtan Getsemani. Ha niabot hilayna ihtew, hinabi na kanlan mānumbong na, “Mikno kawo ihti, ta makew akon makigwang.” ");
INSERT INTO abp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inlamo na yay Pedro, Santiago boy hiyay Juan. Haanin, hiyay Apo Jesus, angkalele boy angkayoot yayna. ");
INSERT INTO abp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hinabi na kanla, “Ba-mon ikamatey koynay kalelean ko. Ihti kawo po boy magpoyat kawo.” ");
INSERT INTO abp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tinumaang yan makandi ye Apo Jesus. Ket nilumukob yan nakigwang kanan Apo Dioh a no malyadi dayi, ket ahe nayna dihaen ye pamaidap a lumateng kana. ");
INSERT INTO abp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ket hinabi na, “Bapa, Bapa ko! Mapalyadi moy kaganaan. Pangiingalo mo, no malyadi dayi, alihen mo yatin pamaidap a dihaen ko. Noba aliwan kalabayan ko ye mahumbong, no aliwan hiyay kalabayan mo.” ");
INSERT INTO abp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pangayadi, inudong na hilan Apo Jesus ye tatlon mānumbong na. Ket nalatngan na hilan angkatuloy. Hinabi na kanan Simon Pedro, “Simon, angkatuloy ka nayi? Ahe mo nayi maikpe ye ahe matuloy, agya maghay odah bengat? ");
INSERT INTO abp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpoyat kawo boy makigwang ta-omen kawo ahe mahambot nin tukho. Ha nakem yo, nakahadya kawon manumbong, noba makapey ye laman yo.” ");
INSERT INTO abp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pangayadi, tinumaang yayna man ye Apo Jesus boy nakigwang ya nin omen ha unan pakigwang na. ");
INSERT INTO abp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pangayadi, inudong na hilayna man ye mānumbong na. Ket nalatngan na hilayna man a angkatuloy, ta makakatuloy hilaynan tubat. Ket ha nimata hilayna, ahe la tanda ye habiyen la. ");
INSERT INTO abp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ha ikatlon pag-udong na kanla, hinabi na kanla, “Angkatuloy kawo po boy ampagpainawa? Huhtoyna yain! Naabot ana ye odah a hiko a ibat ha langit a in-Anak nin Tao, ket maigawang kanlan tataon māgkahalanan. ");
INSERT INTO abp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mimata kawo! Tawoyna! Ta anti yayna ye taon nangiopit kangko.” ");
INSERT INTO abp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Legan ampaghabi ya po ye Apo Jesus, hiyay Judas a magha kanlan labinluwan mānumbong na, ket nilumateng yan main lamo a malabong a tataon ampangaget nin keya boy pamadog. Intubol la hilan mānguna a papadi, mamaihtodo nin Bibilin boy tutoan Jujudio a mānungkolan. ");
INSERT INTO abp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yati ye pagkakitan a hinabi nan Judas kanlan kalalamoan na no ayay dakpen la, “Hiyay umaan ko ye dakpen boy kadten yo. Pakabantayan yon manged.” ");
INSERT INTO abp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaya-bay ha nilumateng yaynay Judas, tampol yan hinumaley kanan Apo Jesus. Ket in-idlaw naya, “Maihtodo!” Ket inumaan nay pingipingi na. ");
INSERT INTO abp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ket hilay tatao, dinakep la yay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Haanin, hiyay maghay mānumbong nan Apo Jesus a ampideng ha haley na, binagot nay keya na. Ket tinaya na yay ipoh nan pinakapoon a padi. Ket napunggohan yan talinga. ");
INSERT INTO abp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hinabi nan Apo Jesus kanlan tatao, “Tolihan ako nayi, ta impangaget yo kon keya boy pamadog a mandakep kangko? ");
INSERT INTO abp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Minamangaamot akon ampangiadal ha mahlang nin Timplo. Ket anti kawo met ihtew. Taket ta ahe yoko dinakep ihtew? Noba katapulan malyadi yati ta-omen ya matupad ye naihulat a Habi nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Haanin, hilay kaganaan a mānumbong na, nilakwanan la yay Apo Jesus boy tinumakah hilayna. ");
INSERT INTO abp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Haanin, main maghay binatilyo a anhumumbong kanan Apo Jesus a nakapatapat yan bengat nin makadang a tapih a lino. Dinep-an la yan tatao, ");
INSERT INTO abp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","noba nabokangan laya. Ket tinumakah yan loh-ok ta nahagep la ye patapat na. ");
INSERT INTO abp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ket inlakew la yay Apo Jesus ha baey nin pinakapoon a padi. Ket hilay mānguna a papadi, tutoan Jujudio a mānungkolan boy hilay mamaihtodo nin Bibilin, naytipon hilan kaganaan ihtew. ");
INSERT INTO abp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hiyay Pedro, anhumumbong ya ha aliwan minga mataang. Ket ha anti yayna ha mahlang nin baey nin pinakapoon a padi, nikno yan nakiimodo kanlan māgbantay. ");
INSERT INTO abp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Haanin, hilay mānguna a papadi boy hilay kaganaan a mānungkolan ha Panuhgaan lan Jujudio, nanapul hilan tihtigo a maghabin laban kanan Apo Jesus ta-omen laya maipapatey. Noba homain hilan nakit a hangkan nin pamateyan la kana. ");
INSERT INTO abp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Malabong hilay tihtigo a naghabin katagowan laban kanan Apo Jesus, noba aliwan padipadiho ye hinabi la. ");
INSERT INTO abp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Haanin, main nangaanon nideng a nanihtigoh nin katagowan laban kanan Apo Jesus, a wanla, ");
INSERT INTO abp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nange mi a hinabi na, ‘Agwaten ko yatin Timplo a dinyag nin tao. Ket ha loob nin tatloy mangaamot, mangipaideng akon kanayon a timplo a aliwan dinyag nin tao.’ ” ");
INSERT INTO abp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Noba aliwa met padipadiho ye anhabiyen la. ");
INSERT INTO abp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Haanin, hiyay pinakapoon a padi, nideng ya ha adapan. Ket tinepet na yay Apo Jesus, “Homain ka lawen maipakibat ha bada la laban kammo?” ");
INSERT INTO abp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Noba ahe ya nakibat ye Apo Jesus. Kaya-bay hiyay pinakapoon a padi, tinepet na yayna man ye Apo Jesus, “Hika nayi ye Cristo a Anak nin Anggalangen a Dioh?” ");
INSERT INTO abp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nakibat yay Apo Jesus, “Awo, hikobayna! Ket hiko a ibat ha langit a in-Anak nin Tao, makit yoko lano a ampikno ha dapit wanan nan Makapalyadiyan a Dioh. Boy ha pag-udong ko, makit yoko lano ha owep a an-umaypa a ibat ha langit.” ");
INSERT INTO abp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pamakange nan pinakapoon a padi yatew, napoot yan tubat, giniwak nay bado na, ket hinabi na, “Ahe tawoyna katapulan nin kanayon po a mamapteg! ");
INSERT INTO abp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nange yoyna a ampahalumbangan na yay Apo Dioh, ta impadiho nay hadili na kana. Hinya awod ye iuhga yo kana?” Ket hilay kaganaan, inuhgaan la yan kamateyan ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Haanin, hilay nangaano kanla, linod-an la yay Apo Jesus. Pinedengan boy tinampaling laya haka la hinabi, “Pal-eban mo man kammi no ayay nanampaling kammo!” Pangayadi, hilay māgbantay, kingwa la yay Apo Jesus haka laya binogbog. ");
INSERT INTO abp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Legan anti ya po ye Pedro ha mahlang nin baey nan pinakapoon a padi, magha kanlan babayi a ipoh nan pinakapoon a padi ye manhumapid ha haley nan Pedro. ");
INSERT INTO abp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ha nakit na yay Pedro a ampakiimodo, ket pinudek na yan manged haka na hinabi kana, “Kalamo naka met Jesus a taga Nazaret.” ");
INSERT INTO abp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Noba hiyay Pedro, nagbudi ya, a wana, “Ahe ko tanda ye anhabiyen mo.” Pangayadi, inumalih yaynan palakew ha ilwangan. Haanin, tinumnoy ye tandang. ");
INSERT INTO abp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Haanin, ha nakit na yayna man babayin ipoh ye Pedro, hinabi na kanlan tataon ampideng ihtew, “Yatin tao, ket magha ya kanlan mānumbong nan Jesus.” ");
INSERT INTO abp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noba hiyay Pedro, nagbudi yayna man. Ha ahe nabuyot, hilay tataon anti ihtew a ampideng, hinabi la kanan Pedro, “Peteg a magha ka kanlan mānumbong nan Jesus, ta taga Galilea ka met.” ");
INSERT INTO abp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Noba hinabi nan Pedro, “Hi, ahe! Agya matey ako haanin, ahe koya katatanda yain a taon anhabiyen yo!” ");
INSERT INTO abp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pangahabi nan Pedro yatew, kapipikhaan tinumnoy yayna man ye tandang. Ket naihipan nay hinabi nan Apo Jesus kana a wanae, “Bayo ya tumnoy nin ikalwa ye tandang, ket nikatlo mo koynan imbudi.” Ket hiyay Pedro, tubat ye panumangih na uli ha lele na. ");
INSERT INTO abp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kabekahan, ha mahanibhanib po, naytongtong hilay mānguna a papadi, hilay tutoan Jujudio a mānungkolan, mamaihtodo nin Bibilin boy hilay kaganaan a mānungkolan ha Panuhgaan lan Jujudio. Impabalol lay gamet nan Apo Jesus. Ket inlakew laya kanan Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Haanin, tinepet na yan Gobilnadol Pilato ye Apo Jesus, “Hika nayi ye Poon lan Jujudio?” Nakibat yay Apo Jesus, “Hikaynay naghabi.” ");
INSERT INTO abp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hilay mānguna a papadi, malabong ye an-ibada la kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaya-bay hiyay Gobilnadol Pilato, tinepet na yayna man, “Homain ka nayin maipakibat? Malabong ye bada la laban kammo.” ");
INSERT INTO abp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Noba hiyay Apo Jesus, ahe ya nakibat. Kaya-bay nagtaka yay Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hiyay Gobilnadol Pilato, tepe Pihtan Pangihipan nin Pangiligtah, ket ugali nayna ye mamalihway nin maghay pidiho a awoken lan tatao. ");
INSERT INTO abp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Haanin, magha kanlan lalakin nakapidiho ye nagngalan Barabbas. Naipidiho ya ulita nakilamo ya kanlan kinumuntada ha gobilno boy nakapatey yan tao. ");
INSERT INTO abp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Haanin, hilay tatao, nilakew la yay Gobilnadol Pilato. Ket inawok la kana a diyagen nayna man ye nakaugalian na a pamalihway nin maghay pidiho. ");
INSERT INTO abp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ket hiyay Gobilnadol Pilato, tinepet na hila, “Labay yo nayi a hiyay Poon yon Jujudio ye palihwayen ko?” ");
INSERT INTO abp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wanabay ye tepet nan Gobilnadol Pilato, ta tanda na a inlakew la yay Apo Jesus kana uli ha ibeg la. ");
INSERT INTO abp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Noba hilay mānguna a papadi, inggaygay la hilay malabong a tatao a hiyay Barabbas ye awoken lan mapalihway. ");
INSERT INTO abp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kaya-bay hiyay Gobilnadol Pilato, tinepet na hilayna man, “Hinya awod ye diyagen ko kanan taon anhabiyen yon Poon nin Jujudio?” ");
INSERT INTO abp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ket impangha lan tatao, a wanla, “Ipako ya ha kodoh!” ");
INSERT INTO abp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Taket? Hinyay kalok-an a dinyag na?” wanan Gobilnadol Pilato. Noba lalo layna ingat impakakhaw ye nangha, a wanla, “Ipako ya ha kodoh!” ");
INSERT INTO abp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Haanin, hiyay Gobilnadol Pilato, pinalihway na yay Barabbas ta-omen na hila mapaaliket ye tatao. Ket hiyay Apo Jesus, impalatiko naya haka na inggawang kanlan huhundaloh ta-omen laya ipako ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Haanin, hilay huhundaloh, inlakew la yay Apo Jesus ha mahlang nin palahyo nan Gobilnadol. Ket tinipon la hilay kaganaan a kalalamoan lan huhundaloh. ");
INSERT INTO abp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinabadowan la yay Apo Jesus nin kadih obi a omen ha badon poon. Boy nangwa hilan kawat a madiwi. Ket dinyag la yan ba-mon kodona haka la ingkodona kana. ");
INSERT INTO abp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pangayadi, inlungolungo laya, a wanla, “Yehey! Minged ye Poon lan Jujudio!” ");
INSERT INTO abp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","haka la yan piuman-uman a pinatok ye ō na nin tambo boy nilulud-an laya. Nanalimukod hila konwadi ha adapan na boy naggalang-galangan kana. ");
INSERT INTO abp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pangayadi la yan inlungolungo ye Apo Jesus, niloh-ok la ye kadih obi a imbado la kana haka la yan imbadon uman kana ye bado na. Pangayadi, inlakew laya ha ilwah nin banwa ta-omen la yayna ipako ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Legan angkumodang hilaynan papalwah ha banwa, nahagana la yay maghay laki a ibat ha baytan, hiyay Simon a taga Cirene a bapa nan Alejandro boy Rufo. Ket impilit lan impabatay kana ye pagkodoh nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ket haanin, hiyay Apo Jesus, inlakew laya ha lugal a anhabtan Golgotha. Hiyay labay habiyen, “Lugal nin Bungo.” ");
INSERT INTO abp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ket ihtew, binyan la yan alak a main hale a mira, noba ahe na ininom Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Haanin, impako la yayna ha kodoh. Ket pinaydadakayan lay babado na makauli ha pandaw-an ta-omen la matandaan no hinyay makwa nin magha boy magha kanla. ");
INSERT INTO abp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikahiyam nin mahanib hatew, ha impako la yay Apo Jesus ha kodoh. ");
INSERT INTO abp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ha dapit tagay nin ō na, main naipako a nakaihulatan nin bada kana a wanae, “HIYAY POON LAN JUJUDIO.” ");
INSERT INTO abp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Main met luway tulihan a kadlan nan Apo Jesus a impako ha timaghay kodoh. Hiyay magha, ha dapit wanan na. Ket hiyay magha, ha dapit odi na. ");
INSERT INTO abp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ha wanabay, natupad ye naihulat a Habi nin Dioh a wanae, “Imbilang la yan mapanlabag nin Bibilin.” ");
INSERT INTO abp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ket hilay tataon anhumapid ihtew, ampameyeng-peyeng hilan ampangilungolungo kana, a wanla, “Hi! Aliwa nayi a hinabi mo a agwaten moy Timplo, ket ipaideng mo yan uman ha loob nin tatloy mangaamot? ");
INSERT INTO abp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Higi man awod, lumumbah ka man ihen ha kodoh, ta iligtah moy hadili mo!” ");
INSERT INTO abp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wanabay met ye dinyag lan mānguna a papadi boy mamaihtodo nin Bibilin. An-ilungolungo laya met boy anhabiyen la ha magha boy magha, “Nangiligtah yan kanayon, noba ahe na mababa a iligtah ye hadili na. ");
INSERT INTO abp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bilewen tawo man awod no makalumbah ya ha kodoh yatin Cristo a poon kanon Jujudio! No makalumbah ya, mamteg kitawoyna kana.” Ket hilay kanayon po a nakapako ha kokodoh, ket inlungolungo laya met ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ha kauugtowan ana, nilumiteh yan kaganaan yatew a lugal anggayna ha alah tidih nin mahilem. ");
INSERT INTO abp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ha alah tidih ana nin mahilem, nangha yan makhaw ye Apo Jesus ha habin Aramaic, a wana, “Eloi, Eloi, lema sabachthani?” Hiyay labay habiyen, “Dioh ko, Dioh ko, taket ta pinaolayan moko?” ");
INSERT INTO abp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pamakange la yatew nin tatao a ampideng ihtew, hinabi la, “Leng-en yo! An-ingaten na yay podopita Elias.” ");
INSERT INTO abp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Haanin, magha kanlan lalaki a anti ihtew ye nayew nangwa nin ihpongha haka na indede ha maahem a alak haka na inhipit ha tampoh nin palat haka na impahephep kanan Apo Jesus. Pangayadi, hinabi na, “Paolayan tawo ya, ta bilewen tawo man no lumateng yay Elias a mangilumbah kana.” ");
INSERT INTO abp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Haanin, hiyay Apo Jesus, nangha yayna man nin makhaw. Ket naboytoan yaynan angeh. ");
INSERT INTO abp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Haanin, hiyay makugpan tabing ha loob nin Timplo, ket nagiwak yan nagitna paibat ha tagay anggan aypa. ");
INSERT INTO abp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Haanin, hiyay maghay kapitan nin huhundaloh a anti ihtew a nakaadap kanan Apo Jesus, ha nange nay pangha na boy nakit na no way-omen yan naboytoan angeh, hinabi na, “Petegbay a Anak yan Dioh yatin tao!” ");
INSERT INTO abp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ha aliwan minga mataang, main nangaanon babayi ye ampangimaton nin angkalyadi. Kabilang kanla ye Maria a taga Magdala, Maria a indo nan Jose boy Santiago a ali na, boy anti ya met ihtew ye Salome. ");
INSERT INTO abp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hilabay ye babayin hinumumbong boy naghilbi kanan Apo Jesus ha plobinhiyan Galilea hatew. Anti hila met ihtew ye kanayon a babayin nakilakew kanan Apo Jesus ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nangalyadi yatin kaganaan ha mangaamot nin paghadya bayo Mangaamot nin Pagpainawa. Haanin, ha andudumeglem ana, ");
INSERT INTO abp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","hiyay Jose a taga Arimatea a maghay ambihaen a matoan mānungkolan ha Panuhgaan lan Jujudio boy magha kanlan tataon ampangagad nin panakop nan Apo Dioh, makhaw ye nakem na a nakew kanan Gobilnadol Pilato. Ket inawok na a hiyayna ye mangilbeng nin bangkay nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ha nange nan Gobilnadol Pilato a natey yaynay Apo Jesus, nagtaka ya. Haanin, impadakit na yay kapitan lan huhundaloh. Ket tinepet na kana no peteg a natey yaynay Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ha natandaan nan Gobilnadol Pilato kanan kapitan a natey yaynay Apo Jesus, pinalubohan na yaynay Jose a kowen na yaynay bangkay nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Haanin, hiyay Jose, nanaliw yan tapih a lino. Pangayadi, nilakew na yaynan inlumbah ye bangkay nan Apo Jesus ha kodoh. Ket pinutot na yan tapih a lino haka naya in-ihlep ha inyukib a pangilbengan. Pangayadi, intulin naynan inleneb ye mayadet a dapah ha ilwangan nin pangilbengan. ");
INSERT INTO abp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hiyay Maria a taga Magdala boy hiyay Maria a indo nan Jose, nakit la ye nangilbengan nin bangkay nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ha madeglem ana pangalabah nin Mangaamot nin Pagpainawa, hiyay Maria a taga Magdala, Salome boy Maria a indo nan Santiago, ket nakew hilan nanaliw nin pabango a itiih la ha bangkay nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ket ha Dominggo, ha anhumila anay mangaamot, nakew hila ha nangilbengan kana. ");
INSERT INTO abp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ket legan angkumodang hila, ampaytepet hila, a wanla, “Aya lagi ye mangitulin ha mayadet a dapah a pinanleneb ha ilwangan nin nangilbengan?” ");
INSERT INTO abp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Noba ha angkatamulaw la yaynay nangilbengan, nakit la a naitulin yaynay mayadet a dapah a pinanleneb. ");
INSERT INTO abp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ket ha hinumlep hila ha nangilbengan, nalimowan hila, ta main lakin nakabadon maputi a ampikno ha dapit wanan la. ");
INSERT INTO abp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Noba hinabi nan laki kanla, “Adi kawo angkalimo. Tanda ko a antapulen yo yay Jesus a taga Nazaret a impako ha kodoh! Ahe yayna ihti. Nabi-ay yaynan uman! Bilewen yoy nangikunaan nin bangkay na. ");
INSERT INTO abp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kokawoyna kanlan mānumbong na boy Pedro, ta habiyen yo kanla a muna yaynay Apo Jesus ha Galilea. Ihtewbay yo yayna makit a omen ha hinabi na kanyo hatew.” ");
INSERT INTO abp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Haanin, ampamigpig boy ampagtaka hilan nayew a inumalih ihtew ha nangilbengan. Ket uli ha tubat a limo la, homain hilan bega nangihabiyan nin nalyadi. ");
INSERT INTO abp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hiyay Apo Jesus, nabi-ay yan uman ha mahanib nin Dominggo. Ket hiyay Maria a taga Magdala ye nuna nan nagpakitan. Hiyabay ye babayin hinelpan nin piton mangaloke a ihpidito a pinaalih nan Apo Jesus hatew. ");
INSERT INTO abp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Haanin, nakew ya kanlan mānumbong nan Apo Jesus. Ket nalatngan na hilan malele boy antumangih. Haanin, hinabi na kanla ");
INSERT INTO abp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","a angkabi-ay yay Apo Jesus boy napakit ya kana. Noba ahe la yan pinamtegan. ");
INSERT INTO abp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pangayadi, napakit yayna man ye Apo Jesus ha luwan mānumbong na a angkumodang palakew ha badiyo, noba lumbo ye kadih na. ");
INSERT INTO abp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Haanin, ha nabalayan la a hiyabay ye Apo Jesus, mapadah hilan nag-udong kanlan kalalamoan la ha banwa. Ket imbalita la kanla a napakit yay Apo Jesus kanla. Noba ahe la hila met pinamtegan. ");
INSERT INTO abp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ha ahe nabuyot, legan ampangan hilay labinmaghan mānumbong, napakit ya met kanla ye Apo Jesus. Ket pinaghabiyan na hila, uli ha ahe la pamteg boy kabyangan nin ō la, ta ahe la pinamtegan ye hinabi lan nagpakitan na a nabi-ay yaynan uman. ");
INSERT INTO abp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Haanin, hinabi nan Apo Jesus kanla, “Makew kawo ha kaganaan a lulugal ihti ha babe-luta boy ipatanda yoy Manged a Balita ha kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ket ayaman a mamteg boy pabawtihmo, miligtah ya ha kapaduhaan. Noba ayaman a ahe mamteg, ket paduhaan na yan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ayaman a mamteg kangko, mabyayan hilan kapalyadiyan a manyag nin kapagtakaan bilang pagkakitan. Ket makauli ha ngalan ko, mapaalih la hilay mangaloke a ihpidito boy makapaghabi hila nin bayon habi. ");
INSERT INTO abp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","No mangemgem hilan bikat o makainom hilan makapatey, ahe hila mapano. Boy no palontowan la hilan gagamet la ye ampaghakit, ket mitaah hila.” ");
INSERT INTO abp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pangayadi nan naghabi ye Apo Jesus kanlan mānumbong na, nipatagay yayna ha langit. Ket ihtew ya nikno ha dapit wanan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Haanin, hilay mānumbong na, nakew hilayna ha kaganaan a lulugal, ket impatanda lay Manged a Balita. Ket hiyay Apo Jesus, hinaglapan na hila boy pinaptegan na ye an-iadal la makauli ha in-ibyay na kanla a kapalyadiyan a manyag nin malabong a kapagtakaan bilang pagkakitan.");
INSERT INTO abp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Anggalangen kon Teofilo, hatew, ha anti ya po ye Apo Jesus kantawo, malabong hilay nakakit nin didinyag na. Ket impatanda la ye nangalyadi paibat ha una yan nangiadal nin Habi nin Dioh. Malabong hila met ye kanayon a tataon nanulat nin yatin impatanda la. ");
INSERT INTO abp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ket pangayadi kon pinag-adalan a manged yatin kaganaan a nangalyadi impaibat ha una, naihipan ko met a ihulat kammo nin matunong ye nangalyadi kanan Apo Jesus, anggalangen a Teofilo ");
INSERT INTO abp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta-omen luboh mon mahigudo a peteg ye naiadal ana kammo. ");
INSERT INTO abp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ha panaon nin pamoon nan Herodes ha plobinhiyan Judea, main maghay padi a nagngalan Zacarias. Kabilang ya ha pangkat lan papadi a anhabtan pangkat nan Abias. Ket hiyay ngalan nin ahawa na, Elisabet a lahi na met Aaron. ");
INSERT INTO abp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hiyay Zacarias boy Elisabet, padiho hilan matoynong ha pamilew nan Apo Dioh boy luboh ye panumbong la ha kaganaan a bibilin nan Apo. ");
INSERT INTO abp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Homain hilan anak, ta baug yay Elisabet boy padiho hilaynan matoa. ");
INSERT INTO abp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Haanin, naabot anay mangaamot a hiyay pangkat nan Zacarias ye maghilbi ha Timplo nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hiyay kaugalian lan papadi, ampaydawoan la no ayay humlep a mangulam nin insenso ha Timplo nan Apo Dioh. Ket hiyay ngalan nan Zacarias ye nadawo. Kaya-bay hinumlep yayna met ha Timplo. ");
INSERT INTO abp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Legan an-ulamen nay insenso, main met malabong a tataon ampakigwang ha ilwah nin Timplo. ");
INSERT INTO abp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ket kapipikhaan, napakit ya kanan Zacarias ye maghay anghil nin Dioh a ampideng ha dapit wanan nin pangihagpaan a pangulaman nin insenso. ");
INSERT INTO abp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pamakakit nan Zacarias kana, naigat ya boy nalimowan ya. ");
INSERT INTO abp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Noba hinabi nan anghil kana, “Adi ka angkalimo, Zacarias! Ta linnge nan Apo Dioh ye pakigwang mo. Ket hiyay Elisabet a ahawa mo, manganak ya lanon maghay lakin pangalanan mon Juan. ");
INSERT INTO abp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ket no mianak yayna, maaliket kan tubat boy malabong hila met ye tataon maaliket. ");
INSERT INTO abp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta hiyay anak mo, mag-ilyadi yan madangal ha pamilew nan Apo Dioh. Katapulan a ahe ya minom nin alak o hinyaman a makalahing. Ket paibat ha ibuktot ya po, naheb yaynan Ihpiditon Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ket makauli kana, malabong hilay Israelita a maghehe ha kakahalanan la boy mag-udong kanan Apo lan Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Boy muna ya lano kanan Apo ta-omen na hila ihadya ye tatao ha panlumateng nan Apo. Diyagen na yati ha haglap nin Ihpiditon Dioh boy ha kapalyadiyan a omen kanan podopita Elias hatew. Boy ipaudong nay pangado lan babapa kanlan aanak la boy ipaudong na hila ha matoynong a pangihip ye tataon ahe ampanumbong kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Haanin, nanepet yay Zacarias kanan anghil, “Way-omen kayi po magkamain nin anak, ket padiho kayinan matoan ahawa ko?” ");
INSERT INTO abp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nakibat yay anghil, “Hiko yay Gabriel a lanang ampaghilbi kanan Apo Dioh. Ket hiyabay ye nangitubol kangkon mangihabi kammo nin yatin manged a balita. ");
INSERT INTO abp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hilatin hinabi ko kammo, ket homain hapo a malyadi lano ha panaon a intaning nan Apo Dioh. Noba ulita ahe mo pinamtegan, maumel ka. Ket ahe ka makahabi angga ha manganak yay ahawa mo.” ");
INSERT INTO abp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Haanin, hilay tatao, an-agaden la yan lumwah ye Zacarias ha Timplo. Ampagtaka hila, ta nabuyot ya ha loob. ");
INSERT INTO abp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ha nilumwah yayna, ket ahe yayna makahabi. Ampaghinyah yaynan bengat kanlan tatao. Kaya-bay inihip la a main yan impakit ye Apo Dioh kana ihtew ha loob nin Timplo. ");
INSERT INTO abp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ha nayadi anay panaon nin paghilbi nan Zacarias ha Timplo, ket nuli yayna. ");
INSERT INTO abp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ket ha ahe nabuyot, binumuktot yaynay Elisabet a ahawa na. Ket ha loob nin limay bowan, ahe ya nilumwah ha baey la. ");
INSERT INTO abp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Haanin, hinabi na ha hadili na, “Yati ye kangedan nan Apo Dioh kangko, ta inalih nay kamading-eyan ko kanlan tatao a ahe ako magkaanak.” ");
INSERT INTO abp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ha anem anan bowan ye buktot nan Elisabet, intubol na yan Apo Dioh ye anghil na a hiyay Gabriel a makew ha banwan Nazaret ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Intubol naya kanan Maria a maghay balatang a homain po diha a naitaning anan ikahal nan Jose. Ket hiyay Jose, magha ya kanlan lalahi nan David a poon hatew. ");
INSERT INTO abp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Haanin, hiyay Gabriel, nakew ya kanan Maria. Ket hinabi na kana, “Mag-aliket ka, ta in-inged na kan Apo Dioh! Ket anti yayna kammo.” ");
INSERT INTO abp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ket uli ha hinabi nan anghil, nayoot yay Maria boy inihip na yan manged no hinyay labay nan habiyen. ");
INSERT INTO abp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Noba hinabi nan anghil kana, “Adi ka angkalimo, Maria, ta kinaaliketan na kan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Leng-en moko! Bumuktot ka boy manganak ka lano nin maghay lakin pangalanan mon Jesus. ");
INSERT INTO abp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mag-ilyadi yan madangal boy mahabtan yan ‘Anak nin Katatagayan a Dioh.’ Ibyay nan Apo Dioh kana ye katulidan a manakop a omen ha panakop nan Poon David hatew a unan tutoa na. ");
INSERT INTO abp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Manakop ya kanlan lalahi nan Jacob. Ket hiyay panakop na, homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Haanin, nanepet yay Maria kanan anghil, “Way-omen ako nayi manganak, ket homain ako po diha?” ");
INSERT INTO abp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nakibat yay anghil, “Hiyay Ihpiditon Dioh, makew ya kammo. Ket makauli ha kapalyadiyan nan Katatagayan a Dioh, bumuktot ka. Kaya-bay hiyay ianak mo, ket homain bega kahalanan boy mahabtan yan Anak nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hiyay paltido mon Elisabet, tanda lan tatao a baug ya. Noba haanin, mabuktot ya agya matoa yayna. Ket anem anan bowan ye buktot na. ");
INSERT INTO abp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta homain babagay a ahe na mapalyadin Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nakibat yay Maria, “Ipoh na kon Apo Dioh. Magkapeteg yain a hinabi mo kangko.” Haanin, inumalih yaynay anghil. ");
INSERT INTO abp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ha ahe nabuyot, nag-aligwat yay Maria, ta makew ya ha baey nan Zacarias boy Elisabet a anti ha maghay banwa ha mapantay nin plobinhiyan Judea. Ha niabot yayna ha baey nan Elisabet, in-idlaw naya, “Oh! Kumohta kayna?” ");
INSERT INTO abp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pamakange nan Elisabet ye pangumohta nan Maria, ket naggalaw yay ongi ha loob nin bitoka na. Ket hiyay Elisabet, naheb yan Ihpiditon Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ket impakakhaw nan hinabi kanan Maria, “Igit na kan in-inged Apo Dioh dinan kanlan kaganaan a babayi boy in-inged naya met ye ianak mo! ");
INSERT INTO abp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yo! Aya ko nayi, ta kinewahan na kon indo nan Apo ko? ");
INSERT INTO abp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ta pamakange koy pangidlaw mo kangko, naggalaw yay ongi ha loob nin bitoka ko uli ha aliket na. ");
INSERT INTO abp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Minged ka, ta pinamtegan mo a matupad ye hinabi nan Apo Dioh kammo!” ");
INSERT INTO abp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ket hinabi nan Maria, “Anggalangen ko yay Apo Dioh nin luboh ha puho ko. ");
INSERT INTO abp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ket angkaaliket ako kanan Apo Dioh a Māngiligtah ko. ");
INSERT INTO abp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ta in-inged nako a maaypa a ipoh na. Kaya-bay paibat haanin, habtan lako nin kaganaan a tatao a minged. ");
INSERT INTO abp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anhabtan la kon minged uli ha kangedan a didinyag na kangkon Makapalyadiyan a Dioh. Homain yan kapadiho! ");
INSERT INTO abp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","An-ingalowan na hilay kaganaan a tataon main limo kana paibat po ha unan panaon anggan makanoman. ");
INSERT INTO abp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impakit nay kapalyadiyan na makauli ha kapagtakaan a didinyag na. Ket pinaykatak-katak na hilay tataon mapangitagay nin hadili la. ");
INSERT INTO abp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inalih na hilay makapalyadiyan a popoon ha katungkolan la. Ket hilay ampagmakaaypa ye intagay na. ");
INSERT INTO abp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ket hilay tataon angkabitlan, pinabhoy na hila. Noba hilay mangabatnang, pinaalih na hilan homain bega kaget. ");
INSERT INTO abp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Hinaglapan na kitawon Israelita a māghilbi na, ulita ahe na naliwaan ye pangako na kanan Abraham boy kanlan lalahi na a ingalowan na makanoman,” wanan Maria. ");
INSERT INTO abp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ket hiyay Maria, kinumonin ya po nin mangatatloy bowan kanlan Elisabet bayo ya nuli. ");
INSERT INTO abp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Haanin, naabot anay odah nin panganak nan Elisabet. Ket nanganak yan maghay laki. ");
INSERT INTO abp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nabalitaan lan kakaaluba na boy papaltido na no way-omen na yan iningalowan Apo ye Elisabet. Kaya-bay nakihayaghag hila kana. ");
INSERT INTO abp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Haanin, ha kinawalowan yaynay ongi, hilay kakaaluba boy hilay papaltido nan Elisabet, nakew hilan nakitipon ha baey lan Elisabet, ta panaon yaynan matuli ye ongi. Pangalanan laya dayin Zacarias, ta wanabay ye ngalan nan bapa na. ");
INSERT INTO abp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Noba hinabi nan Elisabet, “Yoh! Ahe malyadi yain! Juan ye ipangalan kana.” ");
INSERT INTO abp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hinabi la kanan Elisabet, “Noba homain wanabay a ngalan ha papaltido yo.” ");
INSERT INTO abp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Haanin, tinepet la yay Zacarias makauli ha hinyah no hinyay labay na a ipangalan kanan anak na. ");
INSERT INTO abp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naninyah yan makikwa nin panulatan. Ket inhulat na, “Juan ye ipangalan kana.” Uli ihti, ket nagtaka hilan tubat. ");
INSERT INTO abp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ket kapipikhaan, nakapaghabi yaynan uman ye Zacarias. Ket nanggalang ya kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hilay kakaaluba la, nalimowan hilan kaganaan. Ket hilayatin babagay a nalyadi, pinaytotongtongan lan tataon angkumonin ha mamapantay nin plobinhiyan Judea. ");
INSERT INTO abp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ket hilay kaganaan a tataon nakange nin balita, ampangihip boy ampanepet, “Hinya lagi ye kalakwan na lano nin yatin anak?” Angkaihip la yatew, ta angkatanam la a anti ya kanay kapalyadiyan nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Haanin, hiyay Zacarias a bapa nan Juan, naheb yan Ihpiditon Dioh. Ket impatanda nay impahabi nin Dioh a wanae, ");
INSERT INTO abp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Galangen tawo yay Apo a Dioh tawon Israelita, ta nilakew na hilan hinaglapan ye tatao na boy pinalihway na hila. ");
INSERT INTO abp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Intubol naya kantawo ye makapalyadiyan a Māngiligtah a ibat ha lahi nan Poon David a māghilbi na. ");
INSERT INTO abp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ket makauli kanlan popodopita na hatew, impangako na a ");
INSERT INTO abp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","iligtah na kitawo kanlan kakaaway tawo boy kanlan kaganaan a ampag-inakit kantawo. ");
INSERT INTO abp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Impangako na met a ingalowan na hilay nangaunan tutoa tawo boy tupaden nay nahantowan a pangako na kanla. ");
INSERT INTO abp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yatew ye impangako na kanan Abraham a toa tawo. ");
INSERT INTO abp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iligtah na kitawo kanlan kakaaway tawo ta-omen kitawo makapaghilbi kana a homain limo. ");
INSERT INTO abp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ket mag-ilyadi kitawon homain kahalanan boy matoynong ha pamilew nan Apo Dioh legan angkabi-ay kitawo po. ");
INSERT INTO abp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ket hika, anak ko, habtan la kan podopita nin Katatagayan a Dioh, ta muna ka kanan Apo ta-omen mo hila italadan ye tatao ha panlumateng na. ");
INSERT INTO abp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ipatanda mo kanla ye tungkol ha kaligtahan makauli ha pamatawad nin kakahalanan la. ");
INSERT INTO abp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ulita mapangingalo yay Apo tawon Dioh, itubol nay Māngiligtah kantawo a omen ha panhumila nin mangaamot a mamahnag nin kaganaan a tatao ");
INSERT INTO abp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ta-omen hila mapahnagan ye tataon ampagbi-ay ha kalitehan a angkaampoling matey. Boy iugot na kitawo palakew ha dān nin katanaan.” ");
INSERT INTO abp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Haanin, hiyay Juan, nilumake yan makhaw ye nakem na. Kinumonin ya ha wangwang angga ha nandugi yaynan mangiadal kanlan tatao ha Israel. ");
INSERT INTO abp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kananyatew a panaon, hiyay Emperador Augusto a pinakamatagay a poon ha Roma, impabalita nay wanae ha kaganaan a tatao ha lulugal a angkahakopan na, “Makew kawoyna ha lugal lan nangaunan tutoa yo ta-omen kawo magpalihta!” ");
INSERT INTO abp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yabayti ye kaunaunaan a pagpalihta ha panaon a hiyay Cirenio ye gobilnadol ha plobinhiyan Siria. ");
INSERT INTO abp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaya-bay hilay kaganaan a tatao, nakew hilaynan peteg ha lugal lan nangaunan tutoa la ta-omen hila magpalihta. ");
INSERT INTO abp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ket hiyay Jose, ulita ibat ya ha lahi nan Poon David a taga Betlehem, inumalih ya ha banwan Nazaret ha plobinhiyan Galilea. Ket nakew ya ha banwan Betlehem ha plobinhiyan Judea ");
INSERT INTO abp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","a lamo na yay Maria a kabaang na ta-omen ya met magpalihta. Ket kananyatew, hiyay Maria, madanon yaynan manganak. ");
INSERT INTO abp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ket legan anti hila ha banwan Betlehem, naabot anay odah nin panganak na. ");
INSERT INTO abp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ket namunganay yan maghay laki. Haanin, nilampinan na yay ongi na haka naya impaida ha lambangan, ta homain anan kanayon a hilid a malyadi lan kunaan. ");
INSERT INTO abp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kananyatew a madeglem, main papahtol a ampagbantay nin tutupa la ha pagpahtolan nin aayop. ");
INSERT INTO abp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kapipikhaan napakit ye maghay anghil nin Dioh kanla. Boy nahnagan hilan kahnagan nan Apo. Ket nalimowan hilan tubat. ");
INSERT INTO abp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Noba hinabi nin anghil kanla, “Yeh! Adi kawo angkalimo! Ta nakew ako ihtibay a mangipatanda kanyo nin manged a balita a makaibyay nin tubat a kaaliketan ha kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Haanin a madeglem, nianak ya ha banwa nan David ye Māngiligtah, hiyay Cristo a Apo nin kaganaan. ");
INSERT INTO abp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yati ye pagkakitan ta-omen yoya mabalayan. Makit yo yay ongi a nalampinan a impaida ha lambangan.” ");
INSERT INTO abp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kapipikhaan, malabong anay aanghil a kapadiho nan nangibat ha langit. Ket hilan kaganaan, naymamagha hilan nanggalang kanan Apo Dioh, ");
INSERT INTO abp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Galangen yay Apo Dioh a anti ha langit! Ket ihti ha babe-luta, main anan katanaan kanlan tataon angkaaliketan nan Apo Dioh,” wanlan aanghil. ");
INSERT INTO abp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ha inumalih hilaynay aanghil paudong ha langit, pinaytongtongan lan papahtol, a wanla, “Yo! Tawoyna ha banwan Betlehem, ta bilewen tawoy nangalyadi a impabalita nan Apo kantawo.” ");
INSERT INTO abp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kaya-bay magagah hilan nanige. Ket ha niabot hilayna ha Betlehem, nakit la yay Maria boy Jose a nakaikno ha talig nan ongi a impaida ha lambangan. ");
INSERT INTO abp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ket imbalita la kanan Maria boy Jose ye hinabi nin anghil kanla tungkol kanan ongi. ");
INSERT INTO abp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ket nagtaka hilan kaganaan a nakange nin hinabi lan papahtol. ");
INSERT INTO abp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Noba hiyay Maria, intanem na ha puho na ye hinabi la boy ampakaihipen na yan manged. ");
INSERT INTO abp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Haanin, nag-udong hilaynay papahtol ha pagpahtolan la. Ampanggalang hila kanan Apo Dioh uli ha nange boy nakit la, ta peteg ye kaganaan a hinabi nin anghil kanla. ");
INSERT INTO abp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ha kinawalowan yaynay ongi, impatuli la yan tutoa na kanlan papadi boy pinangalanan la yan Jesus, ta bayo ya po in-inaw, yabay-in a ngalan ye hinabi nin anghil. ");
INSERT INTO abp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ket ha naabot anay mangaamot nin panlinih kanan Maria, nakew hilan miahawa ha banwan Jerusalem. Nakew hila ihtew ta-omen la tupaden ye anti ha Bibilin nan Apo Dioh a impahulat kanan Moises. Kinaget laya met ye ongi ta-omen laya ihagpa kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta wanae ye anti ha Bibilin nan Apo Dioh, “Balang punganay a anak a laki, katapulan yan maihagpa kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ket hiyay Maria boy Jose, nakew hila ha Timplo ta-omen laya tupaden ye anti ha Bibilin nan Apo Dioh a mangihagpa hilan “maghay padih nin bato-bato o hiwhiw kalapati.” ");
INSERT INTO abp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Haanin, main maghay laki ha Jerusalem a nagngalan Simeon. Matoynong ya boy main yan limo kanan Apo Dioh boy anti kana ye Ihpiditon Dioh. Mahabek yan ampangagad nin panlumateng nan Cristo a mangiligtah kanlan Israelita. ");
INSERT INTO abp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Impatanda nin Ihpiditon Dioh kana, “Ahe ka matey legan ahe moya makit ye Cristo a impangako nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kananyatew a mangaamot, hiyay Simeon, impalakew na yan Ihpiditon Dioh ihtew ha mahlang nin Timplo. Ket nahagana na hilay Maria boy Jose a kaget la yay ongi la a nakew ha Timplo ta-omen la tupaden ye anti ha Bibilin a tungkol ha punganay a anak. ");
INSERT INTO abp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Haanin, inawok na yan Simeon ye ongi kanan Maria. Ket inggawang naya met. Ket hiyay Simeon, ginawang na yan inapnon ye ongi boy nanggalang ya met kanan Apo Dioh, a wana, ");
INSERT INTO abp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Makapalyadiyan a Dioh, magha kon māghilbi mo. Haanin, nakit ko yaynay impangako mon Māngiligtah a intaladan mo ha kaganaan a nanahyon. Ket hiya ye makapahnag nin ihip lan aliwan Judio boy mamyay kadangalan kanlan tatao mon Israelita. Ket haanin awod Apo, palubohan mo koynan matey a main katanaan a omen ha impangako mo.” ");
INSERT INTO abp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nagtaka yay Maria boy Jose ha hinabi nan Simeon tungkol ha anak la. ");
INSERT INTO abp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Haanin, in-inged na hilan Simeon boy hinabi na kanan Maria, “Uli kananyatin anak mo, malabong a tatao ha Israel ye maitagay boy malabong met ye maiaypa. Agya hiyabay ye pagkakitan a ibat kanan Apo Dioh, malabong hila po ateed ye kumuntada kana. ");
INSERT INTO abp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kaya-bay hikan mihmo, ket mahakitan a ba-mon antoyhoken nin manawing a keya ye puho mo. Ta uli ha diyagen na, ket mibagwa ye anti ha ihip lan malabong a tao.” ");
INSERT INTO abp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kananyatew met ateed a mangaamot, anti ya met ihtew ha Timplo ye maghay matoan babayin podopita a nagngalan Ana. Anak na yan Fanuel a ibat ha lahi nan Aser. Pitoy taon hilan bengat a naylamo kanan ahawa na, ");
INSERT INTO abp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ket nabawo yayna. Ket haanin, walompo boy apat a taon yayna. Lanang yan ampakew ihtew ha Timplo. Ket mangaamot boy madeglem yan ampanggalang kanan Apo Dioh makauli ha pamakigwang boy pagpaltan mangan. ");
INSERT INTO abp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kananyatew met a odah, hiyay Ana, hinumaley ya kanan Maria boy Jose. Ket nagpahalamat ya met kanan Apo Dioh. Ket hinabi nan Ana kanlan tataon ampangagad nin panlumateng nan Cristo, “Yabayti yaynay Māngiligtah a impangako nan Apo Dioh! Hiyabay ye Cristo a mambeh nin kakahalanan tawon Israelita!” ");
INSERT INTO abp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ha nadyag laynan Maria boy Jose ye kaganaan a hukat lan diyagen a anti ha Bibilin nan Apo Dioh, nag-udong hilayna ha Nazaret a banwa la ha plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Haanin, hiyay Jesus, nilumake yan makhaw ye laman na. Madunong ya boy kinaaliketan na yan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hilay tutoa nan Jesus, tinaon hilan ampakipihta ha Jerusalem ha Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Haanin, ha labinluwaynay taon nan Apo Jesus, inlamo la yan tutoa na a makipihta, ta wanabay ye kaugalian la. ");
INSERT INTO abp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pangayadi nin pihta, ha muli hilayna, nagbantak yay Apo Jesus ha Jerusalem a ahe la naedepan nin tutoa na. ");
INSERT INTO abp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nabaan lan tutoa na a lamo la yay Apo Jesus ha pangumodang lan ampuli. Kaya-bay pahulong ye pangumodang la ha loob nin maghay mangaamot. Ha mahilem ana, tinapul laya kanlan papaltido la boy kanlan gagayyem la. ");
INSERT INTO abp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ket ha ahe laya nakitan, nag-udong hila ha Jerusalem, ta ihtew la yan tapulen. ");
INSERT INTO abp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pangalabah nin tatloy mangaamot, nakitan la yay Jesus a ampikno ha mahlang nin Timplo a kalamo na hilay mamaihtodo nin Bibilin. Ampanlenge boy ampanepet ya kanla. ");
INSERT INTO abp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hilay kaganaan a ampanlenge, ampagtaka hila kana, ta mataloh yan makataloh boy makibat ha tetepet lan mamaihtodo nin Bibilin. ");
INSERT INTO abp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ha nakitan la yan tutoa na, nagtaka hila. Kaya-bay hinabi nan indo na kana, “Yo! Anti ka met manayti ihtibay, anak ko! Taket ta wanabay ye dinyag mo kammi? Angkahindak kayinan bapa mon ampanapul kammo.” ");
INSERT INTO abp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nakibat yay Jesus, “Taket ta antapulen yoko? Ahe yo nayi tanda a katapulan a anti ko ihti ha baey nan Bapa ko?” ");
INSERT INTO abp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Noba ahe la natalohan nin tutoa na ye labay nan habiyen. ");
INSERT INTO abp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Haanin, nakilakew yaynay Jesus kanlan tutoa na a muli ha banwan Nazaret. Ket mapanumbong ya kanla. Ket hilatin kaganaan, in-it-em nan indo na ha puho na. ");
INSERT INTO abp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ket hiyay Jesus, pahulong yan nilumake boy dinumunong. Kinaaliketan na yan Apo Dioh boy tatao. ");
INSERT INTO abp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ha ikalabinliman taon nin panakop nan Emperador Tiberio ha Roma, hiyay Poncio Pilato ye gobilnadol ha Judea, hiyay Herodes Antipas ye gobilnadol ha Galilea, hiyay Felipe a katongno nan Herodes Antipas ye gobilnadol ha Iturea boy Traconite, ket hiyay Lisanias ye gobilnadol ha Abilinia. ");
INSERT INTO abp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hatew hilan Anas boy Caifas ye pinakapoon a padi lan Jujudio. Kananyatew met a panaon, hiyay Juan a anak nan Zacarias, angkumonin ya ha wangwang. Ket impatanda nan Apo Dioh ye hahabi na kana. ");
INSERT INTO abp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kaya-bay nilakew nay kaganaan a lulugal ha mitaligmang a pahen nin kabatowan Jordan. Ket impatanda nay wanae, “Paghehean boy itgen yoynay panyag nin kahalanan boy pabawtihmo kawo ta-omen na kawo patawaden Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ha wanabay, natupad ye nakahulat ha libdo nan podopita Isaias. Yati ye hinabi na, “Main maghay ampangipangha ha wangwang, ‘Ihadya yoy pagdanan nan Apo. Itoynong yoy pagdanan na. ");
INSERT INTO abp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tagpenan yoy nagkokolih-ong. Tebagen yoy mamatundol boy patalen yoy mangabakil. Itoynong yoy dādān a mangatiko boy dimengen yoy madapah a dādān. ");
INSERT INTO abp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ket makit nin kaganaan a tao ye pangiligtah a diyagen nan Apo Dioh!’ ” ");
INSERT INTO abp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Malabong hilay tataon nakew kanan Juan ta-omen pabawtihmo. Noba hinabi na kanla, “Hikawon ba-mon bibikat, ayay naghabi kanyo a takahan yoy anlumateng a pamaduha nin Dioh? ");
INSERT INTO abp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","No peteg a pinaghehean yo ye kakahalanan yo, ipakit yo awod ha didiyag yo. Adi yo an-ihipen, ‘Hi! Ahe kayi mapaduhaan, ta lalahi na kayin Abraham.’ Pakaihipen yo a agya hilatin dadapah, mababa na yan diyagen Apo Dioh a aanak nan Abraham. ");
INSERT INTO abp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Haanin met ateed, ket nakahadya yaynay Apo Dioh a mamaduha kanyo a ba-mon nakahapda anay wahay ha poon-kayo a palagen na. Ket hiyay balang poon-kayo a ahe ampanawa nin manged, putohen naya boy itapon ha apoy.” ");
INSERT INTO abp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tinepet la yan tatao ye Juan, “Hinya awod ye katapulan min diyagen?” ");
INSERT INTO abp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nakibat ya kanla, “No main kawon luway bado, ibyay yo ye magha ha homain bado. Wanabay met a no main kawon pamangan, biyan yo yay taon homain pamangan.” ");
INSERT INTO abp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Main met māningil nin bowih ye nilumateng ta-omen pabawtihmo. Nanepet hila met kana, “Maihtodo, hinya met nayi ye katapulan min diyagen?” ");
INSERT INTO abp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nakibat yay Juan, “Adi kawo ampaningil nin igit dinan ha an-ipahingil kanyo nin gobilno.” ");
INSERT INTO abp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Main met huhundalon nanepet kana, “Hikayi nayi? Hinyay katapulan min diyagen?” Hinabi nan Juan kanla, “Adi yo ampiliten a mamyay kanyo nin pilak ye kanayon o mamada nin aliwan peteg. Mapda kawoyna ha howildo yo.” ");
INSERT INTO abp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hilay tatao, angkahabek hilaynan ampangagad nin panlumateng nan Cristo a impangako nan Apo Dioh. Ket an-ihipen la, “Hiyayna lagi ye Cristo?” ");
INSERT INTO abp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaya-bay hinabi nan Juan kanla, “Bawtihmowan katawo nin lanom bilang pagkakitan a pinaghehean yoynay kakahalanan yo. Noba main lumateng a igit a makapalyadiyan dinan ko, ta agya mangaget bengat nin hapatoh na, ket ahe ako katanggap-tanggap. Ket lano, bawtihmowan na kawo nin Ihpiditon Dioh boy apoy. ");
INSERT INTO abp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mailalayi ya ha maghay mamalohboh nin giniek. Hiyay ilik, ket ikamalig na. Noba hiyay apah, iulam naya ha apoy a ahe angkalep makanoman.” ");
INSERT INTO abp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ha pangipatanda nan Juan nin Manged a Balita, malabong po ye in-aadal na kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ket hiyay Gobilnadol Herodes Antipas, malabong ye andiyagen na a mangaloke boy pinag-ahawa naya met ye Herodias a ipag na. Kaya-bay hiyay Juan a Māmawtihmo, dinlaw naya, “Apo Gobilnadol, aliwan huhto ye dinyag mo, ta pinag-ahawa mo yay Herodias a ahawa nan katongno mo!” ");
INSERT INTO abp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ket hiyay Gobilnadol Herodes Antipas, impapidiho na yay Juan. Ulin yati, napahanan yayna man ye kakahalanan na. ");
INSERT INTO abp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ha ahe ya po napidiho ye Juan, ampamawtihmo ya kanlan tatao. Binawtihmowan naya met ye Apo Jesus. Ket legan ampakigwang yay Apo Jesus, ba-mon naglukat ye langit. ");
INSERT INTO abp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ket hiyay Ihpiditon Dioh ha kadih kalapati, inumaypa yan inumapon kana. Ket main bihnga a nangibat ha langit a naghabi nin wanae, “Hika ye Anak kon ampakaadoen ko a angkaaliketan kon tubat.” ");
INSERT INTO abp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hiyay Apo Jesus, ha mandugi yan mangiadal, magtatlompo a taon nayna. Agya nianak ya makauli ha kapalyadiyan nin Ihpiditon Dioh, ha pagkatanda lan tatao, ket anak na yan Jose a anak nan Eli. ");
INSERT INTO abp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hiyay Eli ket anak nan Matat. Hiyay Matat ket anak nan Levi. Hiyay Levi ket anak nan Melqui. Hiyay Melqui ket anak nan Janai. Hiyay Janai ket anak nan Jose. ");
INSERT INTO abp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Hiyay Jose ket anak nan Matatias. Hiyay Matatias ket anak nan Amos. Hiyay Amos ket anak nan Nahum. Hiyay Nahum ket anak nan Esli. Hiyay Esli ket anak nan Nagai. ");
INSERT INTO abp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Hiyay Nagai ket anak nan Maat. Hiyay Maat ket anak nan Matatias. Hiyay Matatias ket anak nan Semei. Hiyay Semei ket anak nan Josec. Hiyay Josec ket anak nan Joda. ");
INSERT INTO abp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Hiyay Joda ket anak nan Joanan. Hiyay Joanan ket anak nan Resa. Hiyay Resa ket anak nan Zerubabel. Hiyay Zerubabel ket anak nan Salatiel. Hiyay Salatiel ket anak nan Neri. ");
INSERT INTO abp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Hiyay Neri ket anak nan Melqui. Hiyay Melqui ket anak nan Adi. Hiyay Adi ket anak nan Cosam. Hiyay Cosam ket anak nan Elmadam. Hiyay Elmadam ket anak nan Er. ");
INSERT INTO abp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Hiyay Er ket anak nan Josue. Hiyay Josue ket anak nan Eliezer. Hiyay Eliezer ket anak nan Jorim. Hiyay Jorim ket anak nan Matat. Hiyay Matat ket anak nan Levi. ");
INSERT INTO abp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Hiyay Levi ket anak nan Simeon. Hiyay Simeon ket anak nan Juda. Hiyay Juda ket anak nan Jose. Hiyay Jose ket anak nan Jonam. Hiyay Jonam ket anak nan Eliaquim. ");
INSERT INTO abp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Hiyay Eliaquim ket anak nan Melea. Hiyay Melea ket anak nan Menna. Hiyay Menna ket anak nan Matata. Hiyay Matata ket anak nan Natan. Hiyay Natan ket anak nan David. ");
INSERT INTO abp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Hiyay David ket anak nan Jesse. Hiyay Jesse ket anak nan Obed. Hiyay Obed ket anak nan Boaz. Hiyay Boaz ket anak nan Salmon. Hiyay Salmon ket anak nan Naason. ");
INSERT INTO abp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Hiyay Naason ket anak nan Aminadab. Hiyay Aminadab ket anak nan Admin. Hiyay Admin ket anak nan Arni. Hiyay Arni ket anak nan Esrom. Hiyay Esrom ket anak nan Farez. Hiyay Farez ket anak nan Juda. ");
INSERT INTO abp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Hiyay Juda ket anak nan Jacob. Hiyay Jacob ket anak nan Isaac. Hiyay Isaac ket anak nan Abraham. Hiyay Abraham ket anak nan Terah. Hiyay Terah ket anak nan Nahor. ");
INSERT INTO abp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Hiyay Nahor ket anak nan Serug. Hiyay Serug ket anak nan Reu. Hiyay Reu ket anak nan Peleg. Hiyay Peleg ket anak nan Eber. Hiyay Eber ket anak nan Sala. ");
INSERT INTO abp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Hiyay Sala ket anak nan Cainan. Hiyay Cainan ket anak nan Arfaxad. Hiyay Arfaxad ket anak nan Shem. Hiyay Shem ket anak nan Noe. Hiyay Noe ket anak nan Lamec. ");
INSERT INTO abp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Hiyay Lamec ket anak nan Matusalem. Hiyay Matusalem ket anak nan Enoc. Hiyay Enoc ket anak nan Jared. Hiyay Jared ket anak nan Mahalaleel. Hiyay Mahalaleel ket anak nan Kenan. ");
INSERT INTO abp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Hiyay Kenan ket anak nan Enos. Hiyay Enos ket anak nan Set. Hiyay Set ket anak nan Adan. Hiyay Adan ket anak nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Haanin, hiyay Apo Jesus a naheb nin Ihpiditon Dioh, inumalih ya ha kabatowan nin Jordan. Ket in-ugot na yan Ihpiditon Dioh ha wangwang. ");
INSERT INTO abp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ket ha loob nin apatapo a mangaamot, antukhoen na yan Satanas. Kananyatew a panaon, ahe yan bega nangan. Kaya-bay nabitlan yaynan tubat. ");
INSERT INTO abp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hinabi nan Satanas kanan Apo Jesus, “No peteg a hika ye Anak nin Dioh, diyagen mo man awod a makan yatin dapah.” ");
INSERT INTO abp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nakibat yay Apo Jesus, “Yati ye naihulat a Habi nin Dioh, ‘Aliwan bengat makan ye pagbi-ay nin tao.’ ” ");
INSERT INTO abp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Haanin, hiyay Satanas, inlakew na yay Apo Jesus ha matagay a lugal. Ket impahiglap na kana ye kaganaan a panakopan ihti ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hinabi nan Satanas kana, “Kaganaan a kapalyadiyan boy kabatnangan nin hilatin panakopan, ket naibyay ana kangko. Ket maibyay ko ha ayaman a labay kon pamyayan. ");
INSERT INTO abp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ibyay ko kammo hilatin kaganaan dapot tana manggalang ka kangko.” ");
INSERT INTO abp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nakibat yay Apo Jesus, “Yati ye naihulat a Habi nin Dioh, ‘Hiyay Apo mon Dioh ye galangen mo boy hiyan bengat ye paghilbiyan mo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Haanin, hiyay Satanas, inlakew na yay Apo Jesus ha banwan Jerusalem. Ket pinaideng naya ha pinakamatagay a pahen nin bobongan nin Timplo haka na hinabi kanan Apo Jesus, “No peteg a hika ye Anak nin Dioh, magtaboy ka man awod. ");
INSERT INTO abp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ahe ka mapano, ta wanae ye naihulat a Habi nin Dioh, ‘Itubol na hilan Apo Dioh ye aanghil na a manalima kammon ");
INSERT INTO abp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","manampopo ta-omen ahe mahugatan ha dadapah ye bibitih mo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Noba nakibat yay Apo Jesus, “Yati ye naihulat a Habi nin Dioh, ‘Adi mo anhuboken ye Apo mon Dioh.’ ” ");
INSERT INTO abp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pangayadi na yan tinukhon Satanas, nilakwanan na yayna, ta mangagad yayna man nin manged a panaon a tukhoen na yayna man. ");
INSERT INTO abp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pangayadi, hiyay Apo Jesus a naheb nin kapalyadiyan nin Ihpiditon Dioh, nag-udong ya ha plobinhiyan Galilea. Kananyatew nitayak anay balita tungkol kana ha kaganaan a lulugal ihtew. ");
INSERT INTO abp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ket ampakew yan ampangiadal ha pāytiponan lan Jujudio. Ket ginalang yan kaganaan a tatao ihtew. ");
INSERT INTO abp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Haanin, nag-udong yay Apo Jesus ha Nazaret a lugal a kinalakean na. Ket ha Mangaamot nin Pagpainawa, nakew ya ha pāytiponan lan Jujudio, ta wanabay ye kinalmawan na. Ket haanin, nideng ya ta-omen ya mamaha nin Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ket inggawang la kana ye nakehkeh a nakaihulatan nin hahabi nan podopita Isaias. Biniklal na yatew. Ket ha nakit nay pahen a antapulen na, wanae ye imbaha na, ");
INSERT INTO abp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hiyay Ihpidito nan Apo, anti ya kangko. Ta pinili na kon mangipatanda nin Manged a Balita kanlan mangaidap. Intubol na kon mangipatanda kanlan nakapidiho a mapalihway hilayna, ket hilay kakapkap, makakit hilayna. Intubol nako met a mamalihway kanlan tataon an-apiyen ");
INSERT INTO abp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","boy mangipatanda a nilumateng anay panaon nin pangiligtah nan Apo.” ");
INSERT INTO abp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pangayadi nin pamaha na, kinehkeh na yan uman ye kahulatan haka naya inggawang kanan māghilbi. Ket nikno yayna ta-omen mangiadal. Ket hilay kaganaan a tatao ihtew, ket ampamilew hila kana. ");
INSERT INTO abp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hinabi nan Apo Jesus kanla, “Haanin met ateed, legan ampanlenge kawo, natupad ana yatin naihulat a Habi nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ket hilay kaganaan a anti ihtew, nagtaka hila. Ket hinabi la, “Kanged nan maghabi! Noba aliwa nayi a anak na yan Jose?” ");
INSERT INTO abp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hinabi nan Apo Jesus kanla, “Homain hapo a habiyen yo kangko yatin kahabiyan, ‘Doktol, tambalan moy hadili mo.’ Ta labay yo a diyagen ko ihti ha hadili kon banwa ye nabalitaan yo a didinyag kon kapagtakaan ha Capernaum.” ");
INSERT INTO abp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hinabi na po Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Homain podopita a ambihaen ha lugal na. ");
INSERT INTO abp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Leng-en yo. Hatew, ha panaon nan podopitan Elias, peteg a malabong hilay bawon babayi ha nahyon Israel. Ket kananyatew a panaon, ahe ya nangudan ha loob nin tatloy taon boy anem a bowan. Kaya-bay nagkamain nin tubat a bitil ha kaganaan a lulugal ha Israel. ");
INSERT INTO abp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Noba hiyay podopitan Elias, ahe naya intubol Apo Dioh a managlap kanlan babawo ha Israel. No aliwan intubol na yan managlap ha maghay bawon babayi ha banwan Sarepta a hakop nin Sidon. ");
INSERT INTO abp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ket ha panaon nan podopitan Eliseo, malabong hilay tataon ampaghakit nin kating ihtew ha Israel. Noba agya magha, homain yan pinaitaah kanla, no aliwan hiyay Naaman a maghan aliwan Judio a taga Siria.” ");
INSERT INTO abp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ket hilay kaganaan a anti ha pāytiponan lan Jujudio, pamakange lay hinabi nan Apo Jesus a hinaglapan na hilan Apo Dioh ye aliwan Judio, napoot hilan tubat. ");
INSERT INTO abp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kaya-bay nideng hila. Ket intudon-tudon la yan papalwah ha banwa la a anti ha babe matundol, ta iampag laya dayi ha maalale a bengaw. ");
INSERT INTO abp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Noba hiyay Apo Jesus, nagdān ya ha pibunakan la. Ket nilakwanan na hilayna. ");
INSERT INTO abp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ket paibat ihtew, hiyay Apo Jesus, nakew ya ha banwan Capernaum ha plobinhiyan Galilea. Ket ha Mangaamot nin Pagpainawa, nangiadal ya ha pāytiponan lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ampagtaka hilay tatao ha pangiadal na, ta main yan kapalyadiyan ha hahabi na. ");
INSERT INTO abp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kananyatew, main maghay laki ihtew a hinelpan nin maloke a ihpidito. Nangha ya, a wana, ");
INSERT INTO abp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus a taga Nazaret, aya ka nayi kammi? Nakew ka nayi ihti ta-omen mo kayi apoen? Tanda ko no aya ka! Hika ye Pinili nan Apo Dioh a intubol na.” ");
INSERT INTO abp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Noba pinaghabiyan na yan Apo Jesus, “Pakal-em ka! Umalih kayna kana!” Ket haanin, hiyay maloke a ihpidito, impuang na yay tao ha pibunakan lan kaganaan haka naya inalihan a ahe bega pinahakitan. ");
INSERT INTO abp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hilay kaganaan a nakakit, ket nagtaka hila boy napaytepet-tepet, a wanla, “Hinyati? Tubat yan makapalyadiyan ye habi na! Ampaalihen nay mangaloke a ihpidito, ket an-umalih hila met!” ");
INSERT INTO abp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kaya-bay hiyay balita tungkol kanan Apo Jesus, ket nitayak ya ha kaganaan a pahen nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Haanin, hiyay Apo Jesus, inumalih ya ha pāytiponan lan Jujudio. Ket nakew ya ha baey nan Simon. Hiyay babayi a ampo nan Simon, ket tubat ye halot na. Kaya-bay impakihabi laya kanan Apo Jesus a paitaahen naya. ");
INSERT INTO abp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Haanin, hiyay Apo Jesus, hinumaley yan nideng ha talig nan ampaghakit. Ket pinaghabiyan na yay halot na. Kapipikhaan, nitaah yayna boy tampol yan nideng. Ket inapagan na hilayna. ");
INSERT INTO abp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ha ampitanghob anay mangaamot, hilay tatao, malabong a ampaghakit nin nakahinadi ye inlakew la kanan Apo Jesus. Ket hiyay balang magha kanla, kinimpaan na hilan pinaitaah. ");
INSERT INTO abp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Boy pinaalih na met Apo Jesus ye mangaloke a ihpidito kanlan malabong a tatao. Ket legan an-alihan la hilay tatao, an-ipangha lan mangaloke a ihpidito, “Hika ye Anak nin Dioh!” Noba hiyay Apo Jesus, pinaghabiyan na hila boy binawalan na hilan maghabi, ta tanda la a hiyabay ye Cristo a impangako nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kabekahan, ha mahanibhanib po, inumalih yay Apo Jesus. Ket nakew ya ha wangwang. Haanin, tinapul la yan tatao. Ket ha natapulan la yayna, impakihabi la kana, “Apo, no malyadi dayi, adi ka po an-umalih.” ");
INSERT INTO abp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noba hinabi nan Apo Jesus kanla, “Ahe malyadi, ta katapulan ko met ipatanda kanlan tatao ha kanayon a lulugal ye Manged a Balita tungkol ha panakop nan Apo Dioh, ta yabayti ye nakaitubolan ko ihti ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kaya-bay hiyay Apo Jesus, nagpahulong yan nangipatanda nin Manged a Balita ha kanayon po a pāytiponan lan Jujudio ha plobinhiyan Judea. ");
INSERT INTO abp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ha maghay mangaamot, legan ampangiadal yay Apo Jesus ha ambay dagatdagatan nin Genesaret, malabong hilay tataon ampaipaletpet kana a manlenge nin Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ket ha gilid lanom, nakit nay luway bangka a homain tao. Ta hilay nagkonin, ket ampangiwahwah hilan hihigay la. ");
INSERT INTO abp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Haanin, hiyay Apo Jesus, nilumampat ya ha bangka nan Simon. Ket hinabi na kana, “Itaang mo yan makandi ha gilid yatin bangka.” Ha nitaang na yaynan makandi ha gilid, nikno yaynay Apo Jesus. Ket nangiadal yayna kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pangayadi nan nangiadal, hinabi na kanan Simon, “Ilakew yoya yatin bangka ha maalale, ket ikatkat yoy higay yo ta-omen kawo makakwa nin malanghit.” ");
INSERT INTO abp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nakibat ya, “Maihtodo, mikahumda kayin nanlapet, ket homain kayin bega nakwa. Noba ulita hinabi mo, ket ikatkat kon uman ye higay mi.” ");
INSERT INTO abp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kaya-bay inlakew lay bangka la ha maalale. Ingkatkat lay higay la. Ket malabong a malanghit ye nakwa la. Magaynan maginit ye higay la. ");
INSERT INTO abp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kaya-bay kinawey la hilay kalalamoan la a anti ha kanayon a bangka, ta pahaglap hila kanla. Nakew hila met a managlap kanla. Ket napno nin malanghit ye luway bangka la anggan magaynan lumdeg. ");
INSERT INTO abp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ha nakit nan Simon Pedro ye nalyadi, nanalimukod ya ha adapan nan Apo Jesus. Ket hinabi na kana, “Taangan moko Apo, ta māgkahalanan ako.” ");
INSERT INTO abp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hinabi nan Simon Pedro yatew, ta hiya boy hilay kalamoan na, ket ampagtaka ha kalabong nin malanghit a nakwa la. ");
INSERT INTO abp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nagtaka hila met ye Santiago boy Juan a anak nan Zebedeo boy katag-op nan Simon Pedro. Ket hinabi nan Apo Jesus kanan Simon Pedro, “Adi ka angkalimo. Ket paibat haanin, diyagen kataynan māngumbinyo nin tatao a mamteg kangko a ba-mo kawon ampanlapet nin malanghit.” ");
INSERT INTO abp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kaya-bay ha naigilid laynay babangka la, nilakwanan layna ye kaganaan boy nakilakew hilayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Legan anti yay Apo Jesus ha maghay banwa, hinumaley ya kana ye maghay lakin napampoh nin kating. Nilumukob ya ha luta ha adapan na. Ket nakiiingalo ya, a wana, “Apo, no labay mo, mapaitaah moko.” ");
INSERT INTO abp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ket hiyay Apo Jesus, kinimpaan naya boy hinabi na, “Awo, labay ko. Mitaah kayna!” Ket tampol yaynan naalih ye kating na. ");
INSERT INTO abp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pangayadi, binilinan na yan Apo Jesus, “Adi mo anhabiyen ha agya ayaman ye nalyadi kammo, no aliwan makew ka tana ha padi. Ket ipabilew moy luti mo kana. Pangayadi, mangihagpa ka nin omen ha imbilin nan Moises bilang pamapteg a nitaah kayna.” ");
INSERT INTO abp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Noba lalo ya po naitayak ye balita tungkol kanan Apo Jesus. Kaya-bay nilumateng ye malabong po a tatao ta-omen hila manlenge nin an-iadal na boy mapaitaah ha hakit la. ");
INSERT INTO abp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Agya wanabay man, lanang ya po ampakew ye Apo Jesus ha wangwang ta-omen ya makigwang. ");
INSERT INTO abp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ha maghay mangaamot, legan ampangiadal yay Apo Jesus, anti hila met ihtew a ampikno ye nangaanon Papariseo boy mamaihtodo nin Bibilin. Main nangibat ha banwan Jerusalem boy ha kaganaan a lulugal ha plobinhiyan Galilea boy ha plobinhiyan Judea. Ket hiyay kapalyadiyan nan Apo Dioh a mamaitaah, anti ya kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Haanin, main nilumateng a nangaanon lakin ampanambayok nin maghay lakin lumpo. An-apehen la yan iloob ha baey ta-omen laya maihaley kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Noba uli ha kalabong nin tatao, ket ahe hila makaloob. Kaya-bay nanik hila ha bobongan nin baey. Ket nanlabkat hilan atep a nangiloyloyan la kanan lakin lumpo ha adapan nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pamakakit nan Apo Jesus nin kayadet nin pamteg la kana, ket hinabi na kanan lumpo, “Gayyem, napatawad anay kakahalanan mo.” ");
INSERT INTO abp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hilay Papariseo boy hilay mamaihtodo nin Bibilin, inihip lay wanae, “Yatin tao, ampahalumbangan na yay Apo Dioh, ta homain anan ayaman a makapatawad nin kakahalanan no aliwan hiyay Apo Dioh bengat!” ");
INSERT INTO abp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Noba hiyay Apo Jesus, tanda nay an-ihipen la. Kaya-bay tinepet na hila, “Taket ta wanabay ye ihip yo? ");
INSERT INTO abp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Matataloh a habiyen kananyatin lumpo, ‘Napatawad kayna ha kakahalanan mo’, ta ahe yo makit no napatawad o ahe. Noba habiyen ko kana, ‘Mideng ka ta kumodang kayna’ ");
INSERT INTO abp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ta-omen yo makit a hiko a ibat ha langit a in-Anak nin Tao ket main kapalyadiyan a mamatawad nin kakahalanan ihti ha babe-luta.” Ket hinabi na kanan lumpo, “Mideng ka. Ket kadten moy apay mo, ta muli kayna!” ");
INSERT INTO abp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ket tampol yan nideng ye lumpo ha adapan lan kaganaan boy kinaget nay apay na. Ket nuli yaynan ampanggalang kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaganaan lan tataon nakakit nin nalyadi, nagtaka hilan tubat. Ket inggalang la yay Apo Dioh, a wanla, “Koynan kapagtakaan a babagay ye nakit tawo haanin!” ");
INSERT INTO abp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pangayadi nin pamaitaah nan Apo Jesus, inumalih yayna. Haanin, nakit na yay maghay lakin māningil nin bowih a nagngalan Levi a ampikno ha pamayadan nin bowih. Hinabi nan Apo Jesus kana, “Kilakew ka kangko.” ");
INSERT INTO abp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nideng yay Levi, imbantak nay kaganaan, ket nakilakew yayna kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Haanin, bilang pamadangal nan Levi kanan Apo Jesus, nangihadya yan mayadet a poniyan ha baey na. Ket malabong a māningil nin bowih boy kanayon po a tatao ye nakidungon mangan kanla. ");
INSERT INTO abp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Noba ha nakit la hilan Papariseo boy hilay kalalamoan la a mamaihtodo nin Bibilin, ket hinaleyan la hilan dinlaw ye mānumbong nan Apo Jesus, “Taket ta ampakidungo kawon mangan boy minom kanlan māningil nin bowih boy kanlan kanayon a māgkahalanan?” ");
INSERT INTO abp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pinakibatan na hilan Apo Jesus, “Hilay homain hakit, ahe la katapulan ye doktol, no aliwan hilay ampaghakit. ");
INSERT INTO abp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nakew ako ihti a managyat kanlan māgkahalanan a maghehe, aliwa kanlan tataon ampangibaan nin hadili la a matoynong hila.” ");
INSERT INTO abp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Haanin, hinabi nin ano katao kanan Apo Jesus, “Hilay mānumbong nan Juan a Māmawtihmo, ket maheheg hilan magpaltan mangan boy makigwang. Wanabay met kanlan mānumbong lan Papariseo. Noba hilay mānumbong mo, maheheg hilan mangan boy minom.” ");
INSERT INTO abp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Inlalayi nan Apo Jesus ye hadili na ha maghay lakin nagkahal, a wana, “Legan kalamo laya po nin kinumbida ha poniyan ye lakin nagkahal, ahe hila malyadin magpaltan mangan, kali? ");
INSERT INTO abp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Noba maabot lano ye panaon a maialih yayna kanla ye lakin nagkahal. Ket kananyatew hila po magpaltan mangan uli ha kalelean la.” ");
INSERT INTO abp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hinabi na po Apo Jesus kanla ye maghay pangilalayi tungkol ha bayon adal na, “Homain taon mangginit ha bayon bado nin itakop na ha alan a bado. Ta no diyagen na yatew, mahayang yay bayon bado boy hiyay intakop, aliwa yan padiho ha nakaitakopan na.” ");
INSERT INTO abp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hinabi na po Apo Jesus, “Homain met taon mangikonin nin bayon alak ha alan a kubot a katat. Ta no diyagen na yatew, lumtoh yay alan a kubot boy mabullog yay alak. Ha wanabay, padiho hila lanon mahayang. ");
INSERT INTO abp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","No aliwan hiyay bayon alak, ket katapulan a ikonin ya ha bayon kubot a katat. ");
INSERT INTO abp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Homain met taon nakainom nin alan a alak ye malabay minom nin bayon alak, ta habiyen na, ‘Malalahap ye alan a alak.’ ” ");
INSERT INTO abp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ha maghay Mangaamot nin Pagpainawa, hiyay Apo Jesus boy hilay mānumbong na, nipadān hila ha katidigowan. Haanin, hilay mānumbong na, nandayon hilan nante nin tidigo. Ket an-itatangay lan antim-en. ");
INSERT INTO abp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Haanin, main met nangaanon Papariseo ihtew. Ket hinabi la, “Taket ta andiyagen yoy wanabay? Ampante kawon tidigo, ket bawal yain ha Mangaamot nin Pagpainawa!” ");
INSERT INTO abp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nakibat yay Apo Jesus kanla, “Ahe yo po nayi nabaha ye dinyag nan David hatew? Ha nabitlan ya boy hilay kalalamoan na, ");
INSERT INTO abp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","hinumlep ya ha Toldan Panggalangan kanan Apo Dioh. Ket nangwa yan tinapay a inhagpa kanan Apo Dioh. Kinan na boy pinakan na hila met ye kalalamoan na. Noba ahe ya nagkahalanan agya po man bawal yatew ha Bibilin, ta hilay papadi bengat ye malyadin mangan nin inhagpa kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hinabi na po Apo Jesus, “Hiko a ibat ha langit a in-Anak nin Tao, ket main kapalyadiyan a mangihabi no hinyay huhton diyagen ha Mangaamot nin Pagpainawa.” ");
INSERT INTO abp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha kanayon a Mangaamot nin Pagpainawa, hiyay Apo Jesus, nakew ya ha pāytiponan lan Jujudio, ta mangiadal ya. Main maghay laki ihtew a kinumpit ye dapit wanan a gamet na. ");
INSERT INTO abp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kananyatew a mangaamot, hilay Papariseo boy hilay mamaihtodo nin Bibilin, ambantayan laya no paitaahen na yan Apo Jesus agya Mangaamot nin Pagpainawa. Ta no diyagen na yain, ket main hilaynan pangidaloman kana. ");
INSERT INTO abp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Noba tanda nan Apo Jesus ye an-ihipen la. Kaya-bay hinabi na kanan laki a kinumpit ye gamet na, “Mideng ka, ket makew ka ihti ha adapan.” Ket nideng ya met ye laki haka ya nakew ha adapan la. ");
INSERT INTO abp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pangayadi, hinabi nan Apo Jesus kanlan Papariseo boy kanlan mamaihtodo nin Bibilin, “Tepeten katawo. Hinyay an-ipaluboh nin Bibilin a malyadin diyagen ha Mangaamot nin Pagpainawa? Manyag nayin manged o maloke? Mangiligtah nayi o mamatey?” ");
INSERT INTO abp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Binilew na hilan kaganaan ye anti ha palibot na haka na hinabi kanan lakin kinumpit ye gamet na, “Ipanat moy gamet mo.” Impanat nay gamet na, ket nitaah yayna. ");
INSERT INTO abp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Noba napoot hilan tubat ye Papariseo boy mamaihtodo nin Bibilin, ta namaitaah yay Apo Jesus ha Mangaamot nin Pagpainawa. Kaya-bay pinaytotongtongan la no hinyay diyagen la kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ha maghay mangaamot, hiyay Apo Jesus, hinumaka ya ha mapantay. Ket mikahumda yan nakigwang kanan Apo Dioh ihtew. ");
INSERT INTO abp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kabekahan, hinagyat na hilay mānumbong na. Ket namili ya kanla nin labinluwan lalaki a hinabtan nan apohtol. ");
INSERT INTO abp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hilabayti ye Simon a anhabtan Pedro, hiyay Andres a katongno nan Pedro, hiyay Santiago, hiyay Juan, hiyay Felipe, hiyay Bartolome, ");
INSERT INTO abp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","hiyay Mateo, hiyay Tomas, hiyay Santiago a anak nan Alfeo, hiyay Simon a magha kanlan ampangimahakit kanlan Israelita, ");
INSERT INTO abp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","hiyay Judas a anak nin lumbo a Santiago boy hiyay Judas a anhabtan Iscariote a nangiopit kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Haanin, hiyay Apo Jesus boy hilay aapohtol na, dinumoong hilayna. Ket tinumgen hila ha napo, ta anti hila ihtew ye malabong a mānumbong na boy malabong a tataon nangibat ha kaganaan a lulugal nin plobinhiyan Judea, banwan Jerusalem, boy ha lulugal ha ambay dagat nin banwan Tiro boy banwan Sidon. ");
INSERT INTO abp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nakew hila ihtew ta-omen manlenge kanan Apo Jesus boy mapaitaah hila ha hahakit la. Ket hilay tataon hinelpan nin maloke a ihpidito, pinaitaah na hila met. ");
INSERT INTO abp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kaganaan lan ampaghakit, ket ampakaapehen la yan makimpaan ye Apo Jesus, ta main kapalyadiyan a ampangibat kana a mamaitaah nin agya hinyaman a hakit. ");
INSERT INTO abp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Haanin, binilew na hilan Apo Jesus ye mānumbong na boy hinabi na kanla, “Minged kawon mangaidap, ta maibilang kawo kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Minged kawon angkabitlan haanin, ta mabhoy kawo lano. Minged kawon antumangih haanin, ta kumaili kawo lano. ");
INSERT INTO abp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Minged kawo no uli ha panumbong yo kangko a ibat ha langit a in-Anak nin Tao, ket pag-inakitan la kawo, ikahwil la kawo, umihen la kawo boy damaen la kawo. ");
INSERT INTO abp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ta wanabay met ateed ye dinyag lan nangaunan tutoa yo hatew kanlan popodopita nin Dioh. Kaya-bay no diyagen la yati kanyo, ket maghayaghag kawo boy umugto-ugto ha kaaliketan yo, ta mayadet ye plimyo yo ha langit. ");
INSERT INTO abp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Noba kakaingalo kawon mangabatnang, ta napakinabangan yoynay kainomayan yo. ");
INSERT INTO abp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kakaingalo kawon angkabhoy haanin, ta mabitlan kawo lano. Kakaingalo kawon angkumaili haanin, ta lumele boy tumangih kawo lano. ");
INSERT INTO abp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kakaingalo kawo no andangalen la kawon kaganaan a tatao, ta wanabay met ateed hatew ye dinyag lan nangaunan tutoa kanlan aliwan peteg a popodopita.” ");
INSERT INTO abp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Noba yati ye habiyen ko kanyon ampanlenge kangko,” wanan Apo Jesus. “Adoen yo hilay kakaaway yo boy manyag kawon kangedan kanlan ampangahulog kanyo. ");
INSERT INTO abp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Inged yo hilay ampanuboy kanyo. Ket hilay ampangapi kanyo, ipakigwang yo hila met. ");
INSERT INTO abp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No main manikpa nin pingipingi mo, iadap mo po kana ye kahampad. No main manamham nin hamda mo, ket ibyay mo, dayon bado mo. ");
INSERT INTO abp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No main met makikwa kammo, biyan moya. Ket no main mangwa nin bandi yo, adi yoyna an-ipaudong. ");
INSERT INTO abp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Diyagen yo kanlan kanayon ye labay yon diyagen la kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“No hilay ampangado bengat kanyo ye adoen yo, homain kawon plimyo a maagad kanan Apo Dioh. Ta agya hilay māgkahalanan, ket ampangado hila met kanlan ampangado kanla. ");
INSERT INTO abp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ket no hilay manged kanyon bengat ye panyagan yon manged, homain kawon plimyo a maagad kanan Apo Dioh. Ta agya hilay māgkahalanan, ket andiyagen la met yain. ");
INSERT INTO abp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No hilay makabayad bengat kanyo ye padaman yo, homain kawon maagad a plimyo kanan Apo Dioh. Ta agya hilay māgkahalanan, ket ampamadam hila met kanlan kapadiho lan māgkahalanan a angkahigudo lan makabayad kanla. ");
INSERT INTO abp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aliwan wanabay ye diyagen yo, no aliwan adoen yo hilay kakaaway yo, manyag kawo kanla nin manged boy padaman yo hila a ahe yoyna an-ihipen no makabayad hila kanyo o ahe. No wanabay ye diyagen yo, ket mayadet ye plimyo yo boy mapaptegan a aanak na kawon Katatagayan a Dioh. Ta mapangingalo yay Apo Dioh agya kanlan ahe ampagpahalamat boy kanlan mangaloke. ");
INSERT INTO abp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mag-ilyadi kawon mapangingalo a omen kanan Bapa yon Dioh a mapangingalo.” ");
INSERT INTO abp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Adi kawo ampanuhga nin kapadiho yon tao ta-omen na kawo met ahe uhgaan Apo Dioh. Mamatawad kawo ta-omen na kawo met patawaden Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mamyay kawo ta-omen na kawo met biyan nin Apo Dioh. Biyan na kawon huhton takal, hekhek, hedhed boy anhumwa ha takalan. Ulita no way-omen ye pamyay yo kanlan kanayon, ket wanabay met ateed ye pamyay nan Apo Dioh kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hinabi na po Apo Jesus makauli ha pangilalayi, “Hiyay kapkap, malyadi na nayi akayen ye kapadiho nan kapkap? Ahe, ta padiho hilan maampag ha lubot. ");
INSERT INTO abp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Homain ampag-adal a umiigit kanan maihtodo na. Noba no maadalan yan luboh, mag-ilyadi yan omen kanan maihtodo na.” ");
INSERT INTO abp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Taket ta andelawen moy kahalanan nin katongno mo a ba-mon bengat makandin buwag ha mata na, noba ahe mo an-ibabano ye kahalanan mo a ba-mon mayadet a buwag ha mata mo? ");
INSERT INTO abp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Way-omen mo habiyen ha katongno mo, ‘Katongno, paolayan mon alihen koy buwag ha mata mo’, noba ahe moya met angkakit ye mayayadet a buwag a ba-mon batang a nipabanlag? Hikan ampagmamangedan! Muna mo po alihen ye mayadet a buwag mo ta-omen mo makit a manged ye makandin buwag nan katongno mo.” ");
INSERT INTO abp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hiyay manged a poon-kayo, ket manged ya met ye dawa na. Noba hiyay aliwan manged a poon-kayo, aliwa ya met manged ye dawa na. ");
INSERT INTO abp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Balang poon-kayo, ket matandaan ya ha dawa na. Ta hiyay poon-kayon madiwi, ahe yan manawa nin igoh o ubah. ");
INSERT INTO abp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wanabay met ye tao. Hiyay taon manged, ket ampaghabi yan kangedan, ta pawa kangedan ye anti ha puho na. Noba hiyay taon maloke, ampaghabi yan mangaloke, ta pawa mangaloke ye anti ha puho na.” ");
INSERT INTO abp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hinabi na po Apo Jesus, “Taket ta anhabtan yo kon ‘Apo’, noba ahe yo met anhumbongen ye anhabiyen ko? ");
INSERT INTO abp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hiyay taon anhumaley kangko, ampanlenge boy anhumbongen nay anhabiyen ko. Ket ilalayi koya ");
INSERT INTO abp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ha taon nangipaideng nin baey. Nangali yan maalale a lubot. Ket impaideng nay baey na ha pundahyon a dapah. Ket ha nayadi na yaynay baey, nilumateng ye lanab. Ket nadugoh ye baey, noba ahe ya naagwat, ta maghen ye pagkadyag na. ");
INSERT INTO abp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Noba ayaman a nakange nin hahabi ko a ahe na anhumbongen, ilalayi koya ha taon nangipaideng nin baey a homain pundahyon. Kaya-bay ha nadugoh yan lanab ye baey a impaideng na, ket napuang ya boy nangaagwat kaganaan.” ");
INSERT INTO abp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pangayadi nan in-adal Apo Jesus yatew kanlan tatao, nakew yayna ha banwan Capernaum. ");
INSERT INTO abp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ket ihtew, main maghay kapitan nin huhundalon Romano. Yatin kapitan, main yan ipoh a ampakaadoen na. Ket yatin ipoh na, ampaghakit ya boy angkakamatey yayna. ");
INSERT INTO abp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ha nabalitaan nan kapitan ye tungkol kanan Apo Jesus, nangitubol yan nangaanon tutoan Jujudio a mānungkolan a makew kanan Apo Jesus. Ket imbilin na kanla, “Makew kawo kanan Apo Jesus. Ket ipakiiingalo yo kana a lakwen naya ihtin paitaahen ye ipoh ko.” ");
INSERT INTO abp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ket hilay intubol na, ha niabot hilayna kanan Apo Jesus, impakihabi la kana, “Apo, pangiingalo mo. No malyadi dayi, haglapan mo yay kapitan, ta manged yan tao. ");
INSERT INTO abp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta agya aliwa yan Judio, ket maado ya kantawon Jujudio boy nangipaideng ya po nin pāytiponan tawo.” ");
INSERT INTO abp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Haanin, hiyay Apo Jesus, nakilakew ya kanla. Ha mahaley hilayna ha baey nan kapitan nin huhundaloh, impahagana na yan kapitan kanlan gagayyem na ta-omen la habiyen kana, “Apo, agya adi kawoyna kano magbannog a umabot ha baey na. Ta ahe ya kano katanggap-tanggap a lakwen mo ha baey na. ");
INSERT INTO abp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaya-bay ahe ya nakew kammo. Noba agya wanabay man, habiyen moynan bengat kano a mitaah yay ipoh na, ket mitaah yan peteg, wanan kapitan kammi. ");
INSERT INTO abp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tanda na a main madyag ye bilin nin maghay main kapalyadiyan, ta anti ya met ha hilong nin kapalyadiyan lan matatagay po kana. Boy main met huhundaloh a anti ha hilong nin kapalyadiyan na. Ket no habiyen na ha magha, ‘Makew ka ihtew!’ ket makew ya ihtew, boy no habiyen na met ha magha, ‘Makew ka ihti!’ ket makew ya. Boy no habiyen na ha ipoh na, ‘Diyagen mo yati!’ ket diyagen naya.” ");
INSERT INTO abp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pamakange nan Apo Jesus nin impahabi nan kapitan, nagtaka ya boy inumadap ya kanlan malabong a tataon anhumumbong kana. Ket hinabi na kanla, “Yo! Haanin akon bengat nakange nin wanabay a kayadet a pamteg! Agya kanlan Israelita, homain ako po nange nin main wanabay a pamteg.” ");
INSERT INTO abp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Haanin, ha nag-udong hilaynay intubol nan kapitan, ket nakit la a nitaah yaynay ipoh. ");
INSERT INTO abp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pangayadi yatew, nakew yay Apo Jesus ha lugal a Nain. Ket nakilakew hila kana ye mānumbong na boy hilay malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ha mahaley hilayna ha ilwangan nin Nain, ket nahagana la hilay malabong a tataon anlumwah nin yatew a lugal a makew mangilbeng nin bugtong a lakin anak nin bawon babayi. ");
INSERT INTO abp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ha nakit na yan Apo Jesus ye bawon babayi, nalunoh ya. Kaya-bay hinabi na kana, “Dada, adi kayna tumangih.” ");
INSERT INTO abp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Haanin, hinaleyan na yan Apo Jesus ye ampamatayan lan bangkay. Ket kinimpaan naya. Ket nagpaked hilayna met ye ampamatay. Hinabi nan Apo Jesus kanan lakin natey, “Inong, mimata ka.” ");
INSERT INTO abp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nimata yan peteg haka yan naghabi. Haanin, hinabi nan Apo Jesus kanan indo, “Ti yaynay anak mo.” ");
INSERT INTO abp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Uli ha nalyadi, nalimowan hilay kaganaan boy inggalang la yay Apo Dioh. Hinabi la, “Anti yayna kantawo ye makapalyadiyan a podopita. Ket hiyay Apo Dioh, anhaglapan na hilaynay tatao na.” ");
INSERT INTO abp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ket nitayak ye tungkol kanan Apo Jesus ha kaganaan a lulugal ha plobinhiyan Judea boy ha palibot na. ");
INSERT INTO abp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Haanin, hilay mānumbong nan Juan a Māmawtihmo, imbalita la kana ye didinyag nan Apo Jesus. Kaya-bay hiyay Juan, intubol na hilay luwan mānumbong na a makew manepet kanan Apo Jesus nin wanae, “Hikayna lagi ye Cristo a impangako nan Apo Dioh a lumateng, o mangagad kayi po nin lumbo?” ");
INSERT INTO abp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ket ha niabot hilayna kanan Apo Jesus, hinabi la, “Intubol na kayin Juan a Māmawtihmo a manepet kammo no hikayna ye Cristo a impangako nan Apo Dioh, o mangagad kayi po nin lumbo?” ");
INSERT INTO abp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kananyatew, hiyay Apo Jesus, nalatngan la yan ampamaitaah nin malabong a tataon ampaghakit. Ampamaalih ya po nin maloke a ihpidito kanlan tatao boy ampaitaahen na hilay kakapkap. ");
INSERT INTO abp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaya-bay hinabi nan Apo Jesus kanlan intubol nan Juan, “Mag-udong kawoyna kanan Juan. Ket ibalita yo kana ye nange boy nakit yo. Hilay kakapkap, ampakakit hilayna. Hilay lulumpo, ampakakodang hilayna. Hilay kinating, nitaah hilayna. Hilay teteek, ampakange hilayna. Hilay natey, nabi-ay hilan uman boy hiyay Manged a Balita, an-ipatanda ana met kanlan mangaidap. ");
INSERT INTO abp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Minged yay taon ahe ampagluwaluwa kangko.” ");
INSERT INTO abp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pamikuyot lan intubol nan Juan, hinabi nan Apo Jesus kanlan malabong a tatao, “Ha nakew kawo ihtew ha wangwang, hinyay anhigudowen yon makit? Maghay malawak a ampiangin-angin? Ahe! ");
INSERT INTO abp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Maghay taon nakabado nin matampa? Ahe, ta hilay tataon nakabado nin matampa boy ampagbi-ay nin pagpapakapda, ket ihtew yo hila makit ha mangayadet a baey. ");
INSERT INTO abp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nakew kawo kana, ta labay yon makakit nin maghay podopita nin Dioh, kali? Awo, peteg a magha yan podopita ye Juan a Māmawtihmo. Ket habiyen ko kanyo a umiigit ya po ha maghay podopita. ");
INSERT INTO abp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta hiyay Juan ye andektan nan Apo Dioh ha naihulat a Habi na, ‘Mangitubol akon māngihabi ko a mauna kammo ta-omen na italadan ye danan mo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hinabi na po Apo Jesus, “Pakaleng-en yon manged ye habiyen ko. Ha kaganaan a tatao ihti ha babe-luta, homain umiigit kanan Juan a Māmawtihmo. Noba agya wanabay man, hiyay pinakamaaypa kanlan anhakopen nan Apo Dioh, ket umiigit ya po kanan Juan.” ");
INSERT INTO abp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ket hilay kaganaan a tatao, agya hilay māningil nin bowih, pamakange lan hinabi nan Apo Jesus, hinabi la, “Huhto ye man-ipadyag nan Apo Dioh.” Hinabi la yatew, ta napabawtihmo hila kanan Juan. ");
INSERT INTO abp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Noba hilay Papariseo boy hilay mamaihtodo nin Bibilin, ahe la inawo ye man-ipadyag nan Apo Dioh ha bi-ay la, ta ahe hila napabawtihmo kanan Juan. ");
INSERT INTO abp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hinabi na po Apo Jesus, “Hinya lagi ye pangilalayian ko kanlan tatao kananyatin panaon? Boy hinya lagi ye pangipadihowan ko kanla? ");
INSERT INTO abp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ipadiho ko hila ha aanak a ampikno ha paydagawan a ampanghaan lay kadagaw la, a wanla, ‘Tinigtigan mi kawon pangkahal, noba ahe kawo tinumalek! Kinantaan mi kawon kanta no main natey, noba ahe kawo met tinumangih!’ ");
INSERT INTO abp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wanabay ya met ateed ye dinyag yo kammin Juan a Māmawtihmo, ta padiho yo kayin impwida. Ta ha nilumateng yay Juan kanyo, ket nakit yo yan ampagpaltan mangan boy ahe ampinom nin alak. Noba hinabi yo, ‘Hi! Hinelpan yan maloke a ihpidito.’ ");
INSERT INTO abp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ket hiko a ibat ha langit a in-Anak nin Tao, ha nilumateng ako ihti ha babe-luta, nakit yo kon ampangan boy ampinom. Noba hinabi yo met, ‘Mahiba yan mangan, māglahing, boy gayyem lan mangakuhit a māningil nin bowih boy kanayon po a māgkahalanan.’ ");
INSERT INTO abp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Agya wanabay man, hiyay kadunongan nan Apo Dioh, ket angkakit ha didiyag lan kaganaan a aanak nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ha maghay mangaamot, magha kanlan Papariseo a nagngalan Simon ye nanagyat kanan Apo Jesus a makew makipangan ha baey na. Kaya-bay hiyay Apo Jesus, nakew ya met. Ket nakidungo yan mangan. ");
INSERT INTO abp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kananyatew a lugal, main maghay babayin katatanda nin kaganaan a māgkahalanan ya. Ha nabalitaan na a anti yay Apo Jesus ha baey nan Simon, ket nilakew naya boy nangaget ya nin pabangon mablin tubat a naikonin ha maghay botin alabahtodo. ");
INSERT INTO abp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ket nakew yan nideng ha golotan nan Apo Jesus. Antumangih ya ha aphayan na. Impatulo nay luwa na ha bitih nan Apo Jesus. Ket pinunahan na nin labok na haka na inumaan boy tiniihan nin pabango. ");
INSERT INTO abp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pamakakit nan Simon ha andiyagen nan babayi ha bitih nan Apo Jesus, inihip na, “No peteg a podopita ya yatin tao, tanda na dayi a māgkahalanan yatin babayi a ampangimpa kana.” ");
INSERT INTO abp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Noba tanda nan Apo Jesus ye an-ihipen nan Simon. Kaya-bay hinabi na kana, “Simon, main akon habiyen kammo.” Nakibat yay Simon, “Hinyatew, Maihtodo?” ");
INSERT INTO abp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hinabi nan Apo Jesus, “Main luway taon nangutang ha maghay taon māmautang. Hiyay inutang nan magha ket limanggatoh. Ket hiyay magha met, limampo. ");
INSERT INTO abp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ha ahe hilayna makabayad, pinaulayan naynan māmautang ye utang la. Haanin, aya kanlan luwa ye igit a mangado kanan māmautang?” ");
INSERT INTO abp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nakibat yay Simon, “Kadihko, hiyay nakautang nin malalabong.” “Huhto ye pakibat mo,” wanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Haanin, pinalingayan na yan Apo Jesus ye babayi. Ket hinabi na kanan Simon, “Angkakit mo nayi yatin babayi? Ha hinumlep ako ihti ha baey mo, ket ahe moko bega binyan nin lanom a panguyah nin bibitih ko. Noba yatin babayi, luwa na ye pinanguyah nan bibitih ko boy labok nay pinamunah na. ");
INSERT INTO abp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Boy ahe moko inumaan bilang pagkakitan nin aliket mon nananggap kangko. Noba yatin babayi, paibat po ha hinumlep ako ihti ha baey mo, ket homain tegen ye panguma na ha bibitih ko. ");
INSERT INTO abp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ahe mo tiniihan nin ladak ye ō ko. Noba yatin babayi, tiniihan nay bibitih ko nin mablin pabango. ");
INSERT INTO abp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaya-bay hiyay mayadet a pangado na a impakit na kangko ye ampamapteg a napatawad anay malabong a kakahalanan na. Noba hiyay taon makandi ye kahalanan na a napatawad, ket makandi met ye pangado na a ipakit na.” ");
INSERT INTO abp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Haanin, hinabi nan Apo Jesus kanan babayi, “Napatawad anay kakahalanan mo.” ");
INSERT INTO abp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ket hilay kadungo nan Apo Jesus ha panganan, wanla ha ihip la, “Aya ya lagi yatin tao a ampagngaya a mamatawad nin kakahalanan?” ");
INSERT INTO abp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hinabi nan Apo Jesus kanan babayi, “Inligtah na kan pamteg mo. Muli kaynan main katanaan.” ");
INSERT INTO abp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ha ahe nabuyot, hiyay Apo Jesus, nilakew nay babanwa boy babadiyo. Ket impatanda nay Manged a Balita tungkol ha panakop nan Apo Dioh. Kalamo na hilay labinluwan mānumbong na ");
INSERT INTO abp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","boy nangaanon babayin pinaitaah na ha hahakit la boy hilay namaalihan na nin mangaloke a ihpidito. Magha ya kanla ye Maria a anhabtan Magdala ye namaalihan na nin piton mangaloke a ihpidito. ");
INSERT INTO abp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kalamo laya met ye Juana a ahawa nan Cusa a mamaala ha mayadet a baey nan Gobilnadol Herodes Antipas, hiyay Susana, boy hilay kanayon po a babayi. Hilabay ye ampangalingay kanan Apo Jesus boy kanlan mānumbong na. Ket hadili lan babandi ye anggawien la ha pangalingay la. ");
INSERT INTO abp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Haanin, malabong a tataon nangibat ha kanayon a babanwa ye ampakew kanan Apo Jesus. Ket in-adal na kanla yatin pangilalayi, ");
INSERT INTO abp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Main maghay māgtalon ye nakew nanabwag nin bini ha pananeman na. Ha panabwag na, main nangaanon bini ye naampag ha dān. Ket hilatin bibini, natudakan lan tatao boy kinan nin mamanokmanok. ");
INSERT INTO abp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Main met nangaanon bini ye naampag ha kadapahan a main maimpih a luta. Tinumubo hila noba kadudumali hilan nalangey, ta mamala ye luta. ");
INSERT INTO abp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Main met nangaampag ha antuboan nin madiwin iilamon. Ket ha tinumubo hilatew a bini, kadlan lan nilumake ye madiwin iilamon. Ket tinugpawan lay tinumubo a bibini. ");
INSERT INTO abp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Noba main met bibini a naampag ha mabona a luta. Ket malambot ye tubo la boy nanawa hilan titigatoh.” Pangayadi, impakakhaw nan hinabin Apo Jesus, “Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Haanin, hilay mānumbong nan Apo Jesus, nanepet hila kana, “Hinyay labay habiyen nin pangilalayi mo?” ");
INSERT INTO abp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nakibat yay Apo Jesus, “Nabyayan kawon pagkataloh nin hiklito nin tungkol ha panakop nan Apo Dioh. Noba kanlan kanayon, ampaghabi kon bengat makauli ha pangilalayi ta-omen agya po man ‘mamilew hilan mamilew, ket ahe hila makabalay boy agya po man manlenge hilan manlenge, ket ahe hila makataloh.’ ” ");
INSERT INTO abp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hinabi nan Apo Jesus kanlan mānumbong na, “Wanae ye labay habiyen nin pangilalayi tungkol ha mānabwag. Hiyay bini ket Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ket hiyay dān a kinaampagan nin bibini, ket hilabay ye tataon nakange nin Habi nin Dioh. Noba nilumateng yay Satanas. Ket inalih na ha puho la ye Habi nin Dioh ta-omen hila ahe mamteg boy ahe miligtah. ");
INSERT INTO abp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ket hiyay kadapahan a main maimpih a luta, ket hilabay ye tataon angkaaliket a nakange boy nananggap nin Habi nin Dioh. Noba ahe ya nanyamot ha puho la. Kaya-bay ahe nagbuyot ye pamteg la, ta ha nilumateng ye papanubok kanla, ket tinalingkukolan la yaynay pamteg la. ");
INSERT INTO abp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hiyay luta a antuboan nin madiwin iilamon a kinaampagan nin bibini, ket hilabay ye tataon nakange nin Habi nin Dioh. Noba hiyay Habi nin Dioh a nange la, ket natugpawan yan malabong a babagay a ampakayootan la, kalabayan a bumatnang boy panumbong ha kalabayan nin laman la. Kaya-bay ahe ya nakapanawa ye Habi nin Dioh ha bi-ay la. ");
INSERT INTO abp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Noba hiyay mabona a luta a kinaampagan nin bibini, ket hilabay ye tataon luboh a nanlenge nin Habi nin Dioh. Ket intanem la ha puho la boy pinaghehpetan la yan hinumbong anggaynan nanawa ha bi-ay la.” ");
INSERT INTO abp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hinabi na po Apo Jesus, “Homain taon mamaet nin kingki haka na hakeban nin koden o ikonin ha hilong nin papag, no aliwan ikonin naya ha hadya a pangikunaan ta-omen mahnag ye loob nin baey kanlan lumoob. ");
INSERT INTO abp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta homain nakatayo a ahe lano mibagwa boy homain hiklito a ahe lano matandaan.” ");
INSERT INTO abp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kaya-bay pakaleng-en yon manged ye anhabiyen ko. Ta hiyay taon ampanumbong nin nange na a kaptegan, ket mapahanan ya po ye tinanda na. Noba hiyay taon ahe ampanumbong nin nange na a kaptegan, ket agya po man hiyay nibaan na a anti kana, ket maalih po kana.” ");
INSERT INTO abp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Haanin, hiyay indo nan Apo Jesus boy hilay kakatongno na a lalaki, ket nakew hila kana. Noba ahe hila makahaley kana uli ha kalabong nin tatao. ");
INSERT INTO abp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kaya-bay main tao a nangihabi kanan Apo Jesus, “Hiyay indo mo boy hilay kakatongno mon laki, anti hila ha ilwah. Ket labay lay makikit kammo.” ");
INSERT INTO abp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Noba hinabi nan Apo Jesus kanla, “Hilay ampanlenge boy ampanumbong nin Habi nin Dioh, ket hilabay ye kakatongno ko boy indo ko.” ");
INSERT INTO abp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ha maghay mangaamot, hiyay Apo Jesus boy hilay mānumbong na, ket nilumugan hila ha mayadet a bangka. Hinabi nan Apo Jesus kanla, “Lumipay kitawo ha dagatdagatan.” Ket ginaodan laynay mayadet a bangka la. ");
INSERT INTO abp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ket legan anlumipay hila, hiyay Apo Jesus, ket nipakatuloy ya. Haanin, kinumhaw ye angin. Ket hiyay mayadet a bangka la, magaynan mapno nin lanom. Kaya-bay ampipaloke hilayna, ta lumdeg yaynay mayadet a bangka la. ");
INSERT INTO abp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Haanin, hilay mānumbong na, pinokaw la yay Apo Jesus, a wanla, “Apo! Apo! Lumdeg kitawoyna!” Nimata yay Apo Jesus. Ket pinaghabiyan na yay angin boy dawyon, a wana, “Tumgen kawo!” Ket tinumgen ye angin boy dawyon. Ket tinumana ana. ");
INSERT INTO abp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Way-ihtew ye pamteg yo?” Ket hilay mānumbong na, nagtaka hila boy nangalimowan. Kaya-bay napaytepet-tepet hila, “Aya ya lagi yatin tao? Ta agya angin boy dawyon, ket angkapatgen na.” ");
INSERT INTO abp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Haanin, hiyay Apo Jesus boy hilay mānumbong na, ket niabot hilayna ha lugal lan tataon anhabtan Geraseno, ha lipay nin dagatdagatan Galilea. ");
INSERT INTO abp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ha nakalumbah yaynay Apo Jesus ha bangka, hinagana yan maghay laki a angkumonin ana ihtew a hinelpan nin maloke a ihpidito. Nabuyot anan panaon a loh-ok ya boy ahe yayna angkumonin ha baey, no aliwan angkumonin yaynan bengat ha yukib a pangilbengan. ");
INSERT INTO abp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Agya ikulong laya man o balolen nin tanikala ye gagamet boy bibitih na, ket angkaboyto na. Maheheg yan anhigiyan nin mangaloke a ihpidito boy an-iugot ha wangwang. Hinabi nan Apo Jesus kana, “Hikan maloke a ihpidito, alihan mo yayna!” Pamakange nan laki ye hinabi nan Apo Jesus, nangha ya boy nilumukob ya ha adapan na. Ket angkumolih yan ampaghabi, “Jesus, tanda ko a hika ye Anak nan Pinakamakapalyadiyan a Dioh. Aya ka nayi kangko? Pangiingalo mo, adi moko dayi paidapan!” ");
INSERT INTO abp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Haanin, tinepet na yan Apo Jesus, “Hinyay ngalan mo?” “Kawan.” Wanabay ye inhebat na, ta malabong a maloke a ihpidito ye hinumlep kana. ");
INSERT INTO abp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Haanin, hilay mangaloke a ihpidito, impakiiingalo la kanan Apo Jesus, a wanla, “Adi mo kayi dayi palakwen ha maalale a tubat a kulongan ha lale-luta! ");
INSERT INTO abp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","No aliwan palubohan mo kayi tana a humlep ha malabong a bababoy a ampambok ha aling nin mapantay.” Ket hinabi nan Apo Jesus, “Higi, kokawoyna!” ");
INSERT INTO abp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kaya-bay inumalih hilay mangaloke a ihpidito kanan laki. Ket nakew hilaynan hinumlep ha bababoy. Haanin, hilay bababoy, nipapayew hilan nipataboy ha bengaw nin dagatdagatan. Ket ihtew hilaynan nangaalimeh. ");
INSERT INTO abp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ha nakit lan ampanayhay nin bababoy ye nalyadi, ket nayew hilan nangibalita kanlan tatao ha banwa boy babadiyo. ");
INSERT INTO abp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kaya-bay hilay tataon nakange, nakew hila ihtew ta-omen la bilewen ye nalyadi. Pamiabot la kanan Apo Jesus, hiyay lakin inalihan nin mangaloke a ihpidito, nakit la a matino yayna boy nakabadoyna a ampikno ha haley bitih nan Apo Jesus. Ket nalimowan hilay tatao uli ha nakit la. ");
INSERT INTO abp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Haanin, hilay tataon nakakit nin nalyadi, imbalita la kanlan tataon kapipilateng, “Hiyay Apo Jesus, pinaalih na hilay mangaloke a ihpidito kanan laki.” ");
INSERT INTO abp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ket hilay tataon taga Geraseno, impakihabi la kanan Apo Jesus, a wanla, “Umalih kayna ihti ha lugal mi, ta angkalimo kayinan tubat kammo.” Kaya-bay hiyay Apo Jesus boy hilay mānumbong na, nilumugan hilayna ha bangka. Ket inumalih hilayna nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bayo yan inumalih ye Apo Jesus, hiyay lakin inalihan nin mangaloke a ihpidito, ket nakiiingalo ya kana, a wana, “Makilakew ako met dayi kammo.” Noba ahe na inawo Apo Jesus, no aliwan pinauli na yaynan ingat, a wana, ");
INSERT INTO abp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muli kayna ha angkunaan yo. Ket hiyay kapagtakaan a dinyag nan Apo Dioh kammo, ibalita mo kanlan tatao.” Ket nuli yan peteg ye laki. Ket imbalita na kanlan kaganaan a tatao nin yatew a banwa ye kapagtakaan a dinyag nan Apo Jesus kana. ");
INSERT INTO abp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ha nag-udong yay Apo Jesus ha lipay dagatdagatan, hilay tatao ihtew, ket angkaaliket hilan nananggap kana, ta an-agaden laya. ");
INSERT INTO abp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Haanin, main nilumateng a maghay lakin nagngalan Jairo a maghay mānguna ha pāytiponan lan Jujudio. Nanalimukod ya ha adapan nan Apo Jesus. Ket hinabi na, “Pangiingalo mo, Apo, ta makew ka dayi ha baey ko. ");
INSERT INTO abp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ta hiyay bugtong a anak kon balatang a nagtaon labinluwa, ket angkakamatey yayna.” Ket legan anlakwen na yan Apo Jesus ye anak nan Jairo, malabong hilay tataon ampaypapaletpet kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Haanin, main met maghay babayi kanla ihtew ye labinluway taon anan andayaen. Ket nauboh nayna ye babandi na ha pagpapatambal na. Noba homain bega nakapaitaah kana. ");
INSERT INTO abp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ket nakipaletpet ya met kanlan tatao angga ha niabot ya ha golotan nan Apo Jesus. Ket kiniwit nay laylay nin bado na. Ket kapipikhaan, tinumgen anay pandumaya na. ");
INSERT INTO abp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ket haanin, nanepet yay Apo Jesus, “Ayay nangiwit kangko?” Noba hinabi lan kaganaan, “Aliwan hiko!” Kaya-bay hinabi nan Pedro, “Apo, tanda moynabay met a malabong ye tataon ampaypapaletpet kammo.” ");
INSERT INTO abp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noba hinabi nan Apo Jesus kanan Pedro, “Main nangiwit kangko, ta natanam kon main kapalyadiyan a nilumwah kangko.” ");
INSERT INTO abp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Haanin, ha natandaan nan babayi a ahe na maitayo kanan Apo Jesus ye dinyag na, ampamigpig yan hinumaley kana boy nilumukob ya ha adapan na. Ket hinabi na kanlan kaganaan a tatao a anti ihtew no taket ta kiniwit na yay Apo Jesus boy no way-omen yan nitaah. ");
INSERT INTO abp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Haanin, hinabi nan Apo Jesus kana, “Inang, nitaah ka uli ha pamteg mo. Muli kaynan main katanaan.” ");
INSERT INTO abp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Legan angkatongtongen naya po Apo Jesus ye babayi, main nilumateng a taon nangibat ha baey nan Jairo. Hinabi na, “Adi mo yayna an-abaen ye Maihtodo, ta natey yaynay anak mo.” ");
INSERT INTO abp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pamakange nan Apo Jesus ye hinabi nan tao, hinabi na kanan Jairo, “Adi ka angkalimo. Mamteg kan bengat, ket mabi-ay yan uman ye anak mo.” ");
INSERT INTO abp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pamiabot nan Apo Jesus ha baey nan Jairo, homain yan kanayon a inlamo ha loob nin baey, no aliwan hiyay Pedro, Santiago, Juan, boy hilay tutoa nan anak bengat. ");
INSERT INTO abp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hilay kaganaan a tataon anti ihtew, antangihan boy an-andangan la yay anak a natey. Noba hinabi nan Apo Jesus kanla, “Adi kawo antumangih, ta ahe yan natey ye anak, no aliwan angkatuloy yan bengat.” ");
INSERT INTO abp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ket kinailiyan laya, ta tanda la a natey yaynay anak. ");
INSERT INTO abp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Haanin, ginemgeman na yan Apo Jesus ye gamet nan anak. Ket hinabi na, “Inang, mimata ka.” ");
INSERT INTO abp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ket kananyatew met ateed, nabi-ay yay anak boy nimata ya. Hinabi nan Apo Jesus kanla, “Pakanen yoya.” ");
INSERT INTO abp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Haanin, nagtaka hilan tubat ye tutoa nan anak. Noba imbilin nan Apo Jesus kanla, “Yatin nalyadi, ket adi yo anhabiyen ha agya ayaman a tao.” ");
INSERT INTO abp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ha maghay mangaamot, hinagyat na hilay labinluwan mānumbong na a humaley kana. Ket binyan na hilan kapalyadiyan boy katulidan a mamaalih nin kaganaan a mangaloke a ihpidito boy mamaitaah kanlan ampaghakit. ");
INSERT INTO abp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ket intubol na hilaynan mangipatanda nin tungkol ha panakop nan Apo Dioh boy mamaitaah hilan ampaghakit. ");
INSERT INTO abp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Binilinan na hila, “Ha pangumodang yo, adi kawo ampangaget nin hinyaman, agya teken, bakoto, pamangan, pilak o bado a paghagiliyan yo. ");
INSERT INTO abp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Makidagoh kawo kanlan ayaman a mamadagoh kanyo. Ket ihtewbay kawo tana kumonin angga ha umalih kawo nin yatew a lugal. ");
INSERT INTO abp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Noba no ahe la kawo tanggapen, ikampag yo po ye tuwapok ha bibitih yo bilang pangipatanda kanla a maloke ye dinyag la. Ket alihan yo hilayna.” ");
INSERT INTO abp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Haanin, nanige hilaynay mānumbong nan Apo Jesus. Ket nakew hila ha binabadiyo a nangipatanda nin Manged a Balita boy namaitaah hilan ampaghakit ha agya way-ihtew man a anlakwen la. ");
INSERT INTO abp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Haanin, hiyay Herodes Antipas a gobilnadol ha plobinhiyan Galilea, ha nabalitaan nay kaganaan a andiyagen nan Apo Jesus, nayoot ye ihip na, ta main ampaghabi, “Nabi-ay yan uman ye Juan a Māmawtihmo.” ");
INSERT INTO abp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ket hilay kanayon met, anhabiyen la, “Hiyabay ye podopita Elias a nabi-ay uman. Ket napakit yayna man!” Ket anhabiyen la met nin kanayon, “Ah, hiyabay ye magha kanlan podopita hatew a nabi-ay uman!” ");
INSERT INTO abp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Noba hinabi nan Gobilnadol Herodes Antipas, “Hiyay Juan, natey yayna, ta pinaputohan ko yan leey. Noba aya yatin taon angkabalitaan kon ampanyag nin kapagtakaan?” Kaya-bay hiyay Gobilnadol Herodes Antipas, pinakikwanan na yan makit ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ha nag-udong hilaynay apohtol, imbalita la kanan Apo Jesus ye kaganaan a didinyag la. Pangayadi, pinagkalamo na hilan nakew ha banwan Bethsaida a hilahilan bengat. ");
INSERT INTO abp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Noba ha natandaan lan tatao a inumalih hilayna, hinumumbong hila kanla. Ket ha panlumateng la ihtew, tinanggap na hila met Apo Jesus. Ket in-adal na kanla ye tungkol ha panakop nan Apo Dioh boy pinaitaah na hilay ampaghakit. ");
INSERT INTO abp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ha ampitanghob anay mangaamot, hinumaley hilay labinluwan apohtol kana. Ket hinabi la, “Maihtodo, anti kitawo ha wangwang. Kaya-bay habiyen moyna kanlan tatao a makew hilayna ha mangahaley a babadiyo boy pananamanan ta-omen hila manapul nin pamangan la boy pagdagohan la.” ");
INSERT INTO abp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Noba hinabi nan Apo Jesus kanla, “Ahe, hikawoy mamyay nin pamangan la.” Nakibat hila, “Limay tinapay boy luway malanghit bengat ye anti ihti. Makew kayi lawen manaliw nin pamangan la?” ");
INSERT INTO abp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hiyay bilang lan lalaki ihtew, mangalimay libo. Noba hinabi nan Apo Jesus kanlan mānumbong na, “Paiknoen yo hilan puhto-puhto nin manilimampo.” ");
INSERT INTO abp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ket pinaikno la hilan kaganaan. ");
INSERT INTO abp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Haanin, kingwa nan Apo Jesus ye limay tinapay boy luway malanghit. Tinumangal ya ha langit. Ket pinahalamatan naya kanan Apo Dioh. Binih-ilbih-il na yay limay tinapay boy pinutoh-putoh na yay luway malanghit. Ket in-ibyay na kanlan mānumbong na. Ket impatped la met kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangan hilan kaganaan boy nangabhoy. Pangayadi lan nangan, hilay mānumbong na, tinipon lay tela lan tatao. Ket nakapno hila po nin labinluwan belyag. ");
INSERT INTO abp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ha maghay mangaamot, legan ampakigwang yay Apo Jesus a bubukod na, hinumaley hilay mānumbong na kana. Haanin, tinepet na hila, “Aya ko kano ha ihip lan tatao?” ");
INSERT INTO abp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nakibat hila, “Anhabiyen lan kanayon a hika ye Juan a Māmawtihmo. Hilay kanayon met, anhabiyen la a hika ye podopitan Elias. Ket hilay kanayon po, anhabiyen la met a hika ye magha kanlan podopita hatew a nabi-ay uman.” ");
INSERT INTO abp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Haanin, tinepet na hilan Apo Jesus, “Hikawo nayi, aya ko?” Nakibat yay Pedro, “Hika ye Cristo a impangako nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Noba mahehpet na hilan binilinan Apo Jesus ye mānumbong na, “Adi yoyna anhabiyen ha agya ayaman.” ");
INSERT INTO abp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hinabi na po kanla, “Hiko a ibat ha langit a in-Anak nin Tao, ket katapulan a magdiha nin malabong a pamaidap. Ikahwil la kon tutoan Jujudio a mānungkolan, mānguna a papadi, boy mamaihtodo nin Bibilin. Ipapatey lako, noba ha ikatlon mangaamot, mabi-ay akon uman.” ");
INSERT INTO abp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Haanin, hinabi na kanlan kaganaan a anti ihtew, “Ayaman a malabay manumbong kangko, ket katapulan a liwaan nay hadili nan kalabayan boy minamangaamot yan nakahadya a matey ha panumbong na kangko a ba-mo yan ampamatay nin kodoh. ");
INSERT INTO abp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta ayaman a taon ampangihilib nin bi-ay na, ket maanam na. Noba ayaman a taon matey uli kangko, ket mabyayan yan bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Main nayi pakinabang ha maghay tao, no mapagkonin nay kaganaan a babandi ihti ha babe-luta, noba mipalakew ya met ha kapaduhaan a homain anggaan ye kalelwa na? ");
INSERT INTO abp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta ayaman a mangikading-ey kangko boy hahabi ko, ikading-ey koya met lano ha pag-udong ko. Hiko a ibat ha langit a in-Anak nin Tao, ha pag-udong ko, main akon kahnagan boy anti kangko ye kahnagan nan Apo Dioh boy kalamo ko hilay aanghil nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pakaleng-en yon manged ye habiyen ko. Main nangaano kanyo ihti ye ahe po matey anggan makit la ye panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pangalabah nin mangawaloy mangaamot, hiyay Apo Jesus, hinumaka ya ha mapantay ta-omen ya makigwang. Inlamo na yay Pedro, Juan boy Santiago. ");
INSERT INTO abp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Haanin, legan ampakigwang ya, ket nauman ye kadih na. Ket hiyay bado na, ampakapulag uli ha tubat a kaputian. ");
INSERT INTO abp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kapipikhaan, main luway laki a napakit kanla a ampakitongtong kanan Apo Jesus, hiyay Moises boy Elias a podopita hatew. ");
INSERT INTO abp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ket ampakapulag hila met a omen kanan Apo Jesus. Hinabi la kana, “Madanon kaynan matey. Ket ihtew ka matey ha banwan Jerusalem.” ");
INSERT INTO abp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hiyay Pedro boy hilay kalalamoan na, ket maiplek hilan angkatuloy, noba nakaimukat hila. Ket nakit lay ampakapulag a kahnagan nan Apo Jesus boy nakit laya met ye Moises boy Elias a ampideng ha talig na. ");
INSERT INTO abp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Haanin, legan an-umalih yaynay Moises boy Elias ha talig nan Apo Jesus, hinabi nan Pedro kanan Apo Jesus, “Maihtodo! Manged, ta anti kitawo ihti. Manyag kayin tatlon hongab ihti. Hiyay maghan hongab, kammo. Hiyay ikalwa, kanan Moises. Boy hiyay ikatlo, kanan Elias.” Nahabi na yatew, ta ampangalimokaw ya. ");
INSERT INTO abp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Legan ampaghabi ya po ye Pedro, inameyan hilan owep. Ket nalimowan hila. ");
INSERT INTO abp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Haanin, main bihnga a ibat ha owep a ampaghabin wanae, “Yabayti ye Anak kon pinili ko. Leng-en yoy habiyen na.” ");
INSERT INTO abp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ha tinumgen yaynay bihnga, nakit lan mānumbong na a bubukod naynan Apo Jesus. Ket yatin nakit la, ahe la po hinabi ha agya ayaman kananyatew a panaon. ");
INSERT INTO abp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kabekahan, ha nakaduong hilaynan Apo Jesus boy mānumbong na paibat ha mapantay, hinagana hilan malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Haanin, main maghay lakin nangha kanan Apo Jesus nin wanae, “Maihtodo, bilewen moya man ye bugtong kon anak a laki. ");
INSERT INTO abp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","No anhigiyan na yan maloke a ihpidito, kapipikhaan ket angkumolih, ampangolimpatang boy ampagbola-bola ye bebey na. Ahe na yaynan an-alihan nin maloke a ihpidito boy tubat na yaynan ampatiyatiyaan. ");
INSERT INTO abp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Impakihabi ko kanlan mānumbong mo, ‘Pangiingalo yo man, ta paalihen yo yay maloke a ihpidito kanan anak ko.’ Noba ahe la yan mapaalih.” ");
INSERT INTO abp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nakibat yay Apo Jesus, “Hikawon tatao haanin a panaon, homain kawon pamteg kanan Apo Dioh boy matiko ye ihip yo. Anggan makano katawo po lagin pag-anohan? Ilakew moya ihti ye anak mo.” ");
INSERT INTO abp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ha anhumaley yaynay anak kanan Apo Jesus, impuang na yan pinakolimpatang nin maloke a ihpidito. Noba hiyay Apo Jesus, pinaghabiyan na yay maloke a ihpidito boy pinaitaah na yay anak. Ket inggawang na yayna kanan bapa na. ");
INSERT INTO abp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ket hilay tatao, nagtaka hilan tubat ha nakit lay kapalyadiyan nan Apo Dioh. Legan ampagtaka hilay tatao ha dinyag nan Apo Jesus, hinabi na kanlan mānumbong na, ");
INSERT INTO abp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pakaleng-en boy pakaihipen yon manged yatin habiyen ko. Hiko a ibat ha langit a in-Anak nin Tao, ket maigawang lano kanlan mānungkolan.” ");
INSERT INTO abp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Noba hilay mānumbong na, ahe la natalohan ye hinabi na, ta ahe na impaluboh Apo Dioh a matalohan la. Ket angkalimo hila met a manepet kana. ");
INSERT INTO abp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ha maghay mangaamot, hilay mānumbong nan Apo Jesus, ket pinayngatngatan la no aya kanlay maibilang a pinakamatagay. ");
INSERT INTO abp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Noba tanda nan Apo Jesus ye ihip la. Kaya-bay nanagyat yan maghay makandin anak haka na yan pinaideng ha talig na. ");
INSERT INTO abp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ket hinabi nan Apo Jesus kanla, “Ayaman a ampananggap nin omen kananyatin anak uli ha panumbong na kangko, ket antanggapen na koyna met. Ket ayaman a ampananggap kangko, ket antanggapen na yayna met ye Bapa kon Dioh a nangitubol kangko. Ta ayaman kanyon kaganaan ye mapagmakaaypa a omen kananyatin anak, ket hiyayna ye pinakamatagay.” ");
INSERT INTO abp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Haanin, hinabi nan Juan kanan Apo Jesus, “Apo, main kayin nakit a taon ampamaalih nin mangaloke a ihpidito ha ngalan mo. Ket binawalan miya, ta aliwa tawo yan kalamo.” ");
INSERT INTO abp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Noba hinabi nan Apo Jesus, “Adi yoya ambawalan, ta ayaman a ahe angkumuntada kantawo, ket katupig tawo ya.” ");
INSERT INTO abp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Haanin, ha madanon yaynan mag-udong ha langit ye Apo Jesus, imbuton na ha ihip na ye makew ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kaya-bay nangitubol yan ano kataon mauna kana ha maghay badiyo ha plobinhiyan Samaria ta-omen hila mangihadya nin pagdagohan na. ");
INSERT INTO abp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Noba hiyay Apo Jesus, ahe laya tinanggap nin tatao ha plobinhiyan Samaria, ta tanda lan palakew ya ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ha natandaan lan Santiago boy Juan a homain nananggap kanan Apo Jesus ihtew, nanepet hila kana, “Apo, labay mo nayi a paudanan mi hilan apoy ta-omen hila maulam?” ");
INSERT INTO abp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Noba pinalingayan na hilan Apo Jesus boy pinaghabiyan. ");
INSERT INTO abp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ket nakew hilayna ingat ha kanayon a badiyo. ");
INSERT INTO abp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ket legan angkumodang hila, main maghay lakin hinumaley boy naghabi kanan Apo Jesus nin wanae, “Kilakew ako kammo, agya way-ihtew ka makew.” ");
INSERT INTO abp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Noba nakibat yay Apo Jesus kana, “Hilay ahontawon, main hilan lubot a angkunaan boy hilay mamanokmanok, main hilan hāy. Noba hiko a ibat ha langit a in-Anak nin Tao, ket homain akon hadilin baey a mapagpainawaan.” ");
INSERT INTO abp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Haanin, hinabi nan Apo Jesus kanan magha po a laki, “Kilakew ka kangko.” Noba nakibat yay laki, “Apo, palubohan moko po dayin muli ta-omen koya po ipailbeng ye bapa ko.” ");
INSERT INTO abp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nakibat yay Apo Jesus kana, “Ipailbeng moya tana ye minatey mo kanlan nangamatey ha pamilew nan Apo Dioh. Noba hika, makew kayna. Ket ipatanda moy tungkol ha panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Main po kanayon a naghabi kanan Apo Jesus, “Kilakew ako kammo, Apo. Noba paolayan moko po muli, ta magpatanid ako po kanlan pamilya ko.” ");
INSERT INTO abp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Noba nakibat yay Apo Jesus kana, “Ayaman a malabay makilakew kangko noba pamapalingay na, ket ahe ya malyadin maghilbi kanan Apo Dioh ha panakopan na. Nailalayi ya ha taon ampangadado a pamapalingay. Kaya-bay tiko-tiko ye dinanan na.” ");
INSERT INTO abp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pangayadi yatew, namili yay Apo Jesus nin pitompo boy luwa katao. Ket intubol na hilan maniluwa a mauna kana ha balang banwa boy lulugal a lakwen na. ");
INSERT INTO abp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hinabi na kanla, “Bilewen yo hilay malabong a tataon nakahadya anan pahakop kanan Apo Dioh a ba-mon paday a malyadinan pupolen, noba kulang ye māmupol. Kaya-bay ipakigwang yo kanan Apo a nagkonin nin pupolen a mangitubol yan malabong a māmupol. ");
INSERT INTO abp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Higi, manige kawoyna! Itubol katawo a ba-mon tupa kanlan tataon ba-mon ahontawon. ");
INSERT INTO abp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Adi kawo ampangaget nin pitaka, kubot, o pakalan a ihtiping. Ket ha pangumodang yo, adi kawo tumgen uli ha pangidlaw yo ha agya ayaman ha dān. ");
INSERT INTO abp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ket ha panhumlep yo ha maghay baey, habiyen yoy wanae, ‘Magkamain hila dayin katanaan ye nagbaey.’ ");
INSERT INTO abp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ket no manged ye pananggap la kanyo, peteg a magkamain hilan katanaan nan Apo Dioh. Noba no aliwan manged ye pananggap la kanyo, ahe hila magkamain. ");
INSERT INTO abp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ihtew kawoyna kumonin kanlan mamadagoh kanyo. Adi kawoyna pamakew-pakew kanlan kanayon. Kanen yo boy inomen yoy agya hinyaman a iapag la kanyo. Ta hiyay māg-obda, katapulan a biyan yan matapul na. ");
INSERT INTO abp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","No makew kawo ha maghay banwa boy tanggapen la kawo ihtew, kanen yoy hinyaman a iapag la kanyo. ");
INSERT INTO abp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paitaahen yo hilay ampaghakit ihtew boy habiyen yo kanla, ‘Madanon anay panakop nan Apo Dioh kanyo.’ ");
INSERT INTO abp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Noba no ahe la kawo tanggapen ha maghay banwa, ket makew kawo ha dān nin yatew a banwa, ket habiyen yoy wanae, ");
INSERT INTO abp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ulita ahe yo labay tanggapen ye ipatanda mi kanyo, agya tuwapok nin banwa yo a nipayket ha bibitih mi, ket ikampag mi bilang pangipatanda kanyo a maloke ye dinyag yo. Noba pakaihipen yo yati. Madanon anay panakop nan Apo Dioh.’ ");
INSERT INTO abp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pakaleng-en yon manged ye habiyen ko. Ha Mangaamot nin Panuhga, mamabyat ye ipaduha kanlan tatao kananyatin banwa dinan kanlan taga Sodoma a nanyag nin kalok-an hatew.” ");
INSERT INTO abp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hinabi na po Apo Jesus, “Hikawon taga Corazin boy hikawon taga Bethsaida, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta no hiyay kapagtakaan a dinyag ko kanyo, ket ihtew koyna dayin dinyag ha Tiro boy ha Sidon, ket nabuyot hilayna dayin naghoot nin tapih a mangitit a pamaneh ye angkumonin ihtew boy nikno ha tubog bilang pagkakitan a ampaghehe hilayna ha kakahalanan la. ");
INSERT INTO abp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Noba ha Mangaamot nin Panuhga, mamabyat ye ipaduha kanyo dinan kanlan taga Tiro boy taga Sidon. ");
INSERT INTO abp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ket hikawon taga Capernaum, nabaan yo nayi a midangal kawo angga ha langit? Ahe! Itapon na kawon Apo Dioh ha impilno!” ");
INSERT INTO abp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Ayaman a ampanlenge kanyo, ket hikoynay anleng-en na. Ayaman a ampangikahwil kanyo, ket hikoynay an-ikahwil na. Ket hiyay ampangikahwil kangko, an-ikahwil na yayna met ye Bapa a Dioh a nangitubol kangko.” ");
INSERT INTO abp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Haanin, hilay pitompo boy luwa kataon intubol nan Apo Jesus, mahayaghag hilan nag-udong kana. Ket hinabi la kana, “Apo, agya hilay maloke a ihpidito, angkapaalih mi hila makauli ha ngalan mo.” ");
INSERT INTO abp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nakibat yay Apo Jesus kanla, “Nakit ko yay Satanas a naalih kana ye kapalyadiyan na a omen ha kapadah nin kilat. ");
INSERT INTO abp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Binyanan katawon kapalyadiyan ta-omen yoya hamboten ye kaganaan a kapalyadiyan nan Satanas a kaaway tawo a ba-mon pangitutudak nin bibikat boy kokoninipit, noba ahe kawo mapano. ");
INSERT INTO abp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Noba agya wanabay man, adi yo an-ikaaliket ye pamaalih yon mangaloke a ihpidito, no aliwan hiyay ikaaliket yo, ket nakalihtaynay ngangalan yo ha libdo nin bi-ay ha langit.” ");
INSERT INTO abp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kananyatew met ateed a odah, hiyay Apo Jesus, ket naheb yan kaaliketan nin Ihpiditon Dioh. Ket nakigwang yan wanae, “Bapa ko a Apo ha langit boy ihti ha babe-luta, ampahalamatan kata, ta hilatin kaptegan, ket ahe mo impatanda kanlan tataon ampangibaan nin hadili la a mangahidi boy mangadunong, no aliwan kanlan tataon mangakandin bengat ye tinanda a omen kanlan mangakandin aanak. Awo, Bapa ko, dinyag mo yatew, ta yabaytew ye kalabayan mo.” ");
INSERT INTO abp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pangayadi nan nakigwang, hinabi nan Apo Jesus kanlan tatao, “Impabaala naynan Bapa kon Dioh kangko ye kaganaan a babagay. Ket homain nagtanda kangko, no aliwan hiyay Bapa kon Dioh bengat. Homain met nagtanda kanan Bapa kon Dioh, no aliwan hikon bengat a Anak na boy hilay tataon labay kon pangipatandaan kana.” ");
INSERT INTO abp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Haanin, hiyay Apo Jesus, inadap na hilay mānumbong na. Ket hinabi na kanla a hilabay bengat ye ampakange, “Minged kawo, ta nakit yo ye didinyag ko. ");
INSERT INTO abp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pakaleng-en yon manged ye habiyen ko! Hatew, malabong hilay popodopita boy popoon ye malabay makakit boy makange nin nakit boy nange yo haanin. Noba ahe nalyadi yati ha panaon la.” ");
INSERT INTO abp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ha maghay mangaamot, legan ampangiadal yay Apo Jesus kanlan tatao, main maghay maihtodo nin Bibilin ihtew. Nideng yan nanepet, ta labay na yan kaloten ye Apo Jesus ha hahabi na. Hinabi na, “Maihtodo, hinyay hukat kon diyagen ta-omen ako mabyayan nin bi-ay a homain anggaan?” ");
INSERT INTO abp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nakibat yay Apo Jesus kana, “Hinyay anti ha Bibilin? Hinyay angkabaha mo ihtew?” ");
INSERT INTO abp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nakibat yay maihtodo nin Bibilin, “Hiyay Apo mon Dioh, ket adoen mo yan luboh ha puho, luboh ha kalelwa, luboh ha kakhawan boy luboh ha ihip mo. Boy hiyay kapadiho mon tao met, katapulan mo yan adoen nin omen ha pangado mo nin hadili mo.” ");
INSERT INTO abp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hinabi nan Apo Jesus kana, “Huhto ye pakibat mo. Kaya-bay wanabay ye diyagen mo ta-omen ka mabyayan nin bi-ay a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Noba hiyay maihtodo nin Bibilin, ket ahe na labay a mipading-ey ya. Kaya-bay nanepet yayna man, “Aya yain a kapadiho kon tao a katapulan kon adoen?” ");
INSERT INTO abp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nakibat yay Apo Jesus kana makauli ha pangilalayi, “Main maghay taon ibat ha banwan Jerusalem a palakew ha banwan Jerico. Legan angkumodang ya, hinagana yan tutulihan. Niloh-okan laya, kingwa lay bado na boy pilak na, boy binogbog laya angga ha angkakamatey yayna haka la yayna inalihan. ");
INSERT INTO abp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haanin, main padi a nipadān ihtew. Ha nakit na yay lakin nabogbog, niliklikan naya. Ket nagpahulong yayna ha pangumodang na. ");
INSERT INTO abp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Haanin, nipadān ya met ihtew ye maghay lakin lahi nan Levi. Noba ha nakit na yay lakin nabogbog, niliklikan naya met. Ket nagpahulong yayna ha pangumodang na. ");
INSERT INTO abp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Haanin, main met maghay Samaritano a nipadān ihtew. Ket ha nakit na yay lakin nabogbog, nalunoh ya kana. ");
INSERT INTO abp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hinaleyan naya haka na inuyahan nin ladak boy alak ye huhugat na haka na binelbelan nin tapih. Pangayadi, inhakay naya ha ahno na. Ket inlakew na yayna ha baey a an-abangan. Ket ihtew naya hinayhay. ");
INSERT INTO abp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kabekahan, hiyay Samaritano, binyanan na yan luway palata a mital ye nagbaey haka na hinabi, ‘Hayhayen mo yan manged. Ket no magkulang man yati, ket bayadan ko lano ha pag-udong ko.’ ” ");
INSERT INTO abp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Haanin, nanepet yay Apo Jesus kanan maihtodo nin Bibilin, “Aya lagi kanlan tatlo ye main pangado kanan taon binogbog lan tutulihan?” ");
INSERT INTO abp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nakibat yay maihtodo nin Bibilin, “Hiyay nangingalo kana.” Hinabi nan Apo Jesus kana, “Kokayna awod, ket wanabay met ateed ye diyagen mo.” ");
INSERT INTO abp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ha pangumodang lan Apo Jesus boy mānumbong na, ket niabot hila ha maghay badiyo. Main babayi ihtew a nagngalan Marta. Ket angkaaliket yan nananggap kanlan Apo Jesus ha baey na. ");
INSERT INTO abp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hiyay Marta, main yan katongno a nagngalan Maria. Hiyay Maria, ampikno yan bengat ha aphayan nan Apo Jesus, ta ampanlenge ya ha an-iadal na. ");
INSERT INTO abp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Noba hiyay Marta, ket angkagagah ya ha pangihadya nan pamangan boy inomen nan Apo Jesus boy hilay mānumbong na. Kaya-bay hinumaley ya kanan Apo Jesus. Ket hinabi na kana, “Apo, homain nayi bali kammo a hiyay katongno ko, ket ampikno yan bengat boy ampaolayan na kon ampangihadya? Habiyen mo man kana a haglapan nako met.” ");
INSERT INTO abp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Noba hinabi nan Apo Jesus kana, “Marta, angkayoot ka boy angkagagah ka ha malabong a babagay. ");
INSERT INTO abp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Noba mamaghan bengat ye katapulan. Ket yati ye pinili nan Maria, hiyay manlenge kangko. Ket yabayti ye mamanged. Ket ahe yayna maalih kana agya makanoman.” ");
INSERT INTO abp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ha maghay mangaamot, hiyay Apo Jesus, nakew yan nakigwang ha maghay lugal. Pangayadi nan nakigwang, hinabi nin magha kanlan mānumbong na, “Apo, adalan yo kayi man no hinyay habiyen mi ha pamakigwang mi a omen ha dinyag nan Juan a Māmawtihmo kanlan mānumbong na.” ");
INSERT INTO abp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hinabi nan Apo Jesus kanla, “No makigwang kawo, wanae ye habiyen yo, ‘Bapa min Dioh, galangen laka dayin kaganaan a tatao. Apo, hakopen mo kayinan kaganaan. ");
INSERT INTO abp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Biyan mo kayin pamangan mi ha minamangaamot. ");
INSERT INTO abp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Boy patawaden mo kayi ha kakahalanan mi, ta pinatawad mi hilayna met ye kaganaan a nagkahalanan kammi. Adi mo kayi ampaolayan a matukho.’ ” ");
INSERT INTO abp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Haanin, hinabi na po nin Apo Jesus kanla, “Alimbawa, ha bunak madeglem, magha kanyo ye makew ha baey nin gayyem na. Ket nakihabi ya, ‘Gayyem, padaman moko man nin tatloy tinapay mo. ");
INSERT INTO abp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ta hiyay gayyem ko a ibat ha mataang, ket anti ya ha baey ko. Ket homain akon maipakan kana.’ ");
INSERT INTO abp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Haanin, wanae ya met ye pakibat nan gayyem mo a anti ha loob nin baey na, ‘Adi mo koyna an-abaen, ta ampida kayinan aanak ko boy nakaleneb yaynay ilwangan. Kaya-bay ahe koynan labay ye mimatan mamyay kammo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hinabi nan Apo Jesus kanla, “Habiyen ko kanyo, agya po man mitagayyem kawo, ahe na kan imataen. Noba ulita mauplit ka, imataen na kan teed ta-omen na ibyay ye ampakikwaen mo kana.” ");
INSERT INTO abp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kaya-bay wanae ye habiyen ko. Mangawok kawo kanan Apo Dioh, ket biyan na kawo. Tapulen yo kana ye matapul yo, ket matapulan yo. Paapo kawo kana, ket palooben na kawo. ");
INSERT INTO abp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta hilay kaganaan a ampangawok kanan Apo Dioh, ket ambiyan na hila. Hilay kaganaan a ampanapul kana nin matapul la, ket ampakatapul. Hilay kaganaan a ampaapo, ket ampalooben na. ");
INSERT INTO abp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hikawon babapa, no makikwa yan malanghit ye anak yo, ahe yoya biyan nin bikat, kali? ");
INSERT INTO abp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ket no makikwa yan talay, ahe yoya biyan nin koninipit, kali? ");
INSERT INTO abp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Haanin no hikawo po man a mangaloke ket tanda yoy mamyay nin manganged a babagay kanlan aanak yo, lalalo yaynay Bapa yon Dioh a anti ha langit! Ta ibyay nay Ihpidito na kanlan ampakikwa kana.” ");
INSERT INTO abp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ha maghay mangaamot, hiyay Apo Jesus, namaalih yan maloke a ihpidito a ampamaangang nin maghay laki. Ha inumalih yaynay maloke a ihpidito kanan laki, ket ampakahabi yayna. Ket hilay tatao ihtew, nagtaka hila. ");
INSERT INTO abp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Noba hinabi lan kanayon, “Ah! Ampakaalih yan mangaloke a ihpidito, ta hiyay Satanas a poon lan mangaloke a ihpidito ye namyay kana nin kapalyadiyan a manyag nin wanabay.” ");
INSERT INTO abp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hilay kanayon kanla, labay la yan huboken ye Apo Jesus. Kaya-bay nakikwa hilan kapagtakaan kana bilang pagkakitan a hiyabay ye intubol nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Noba tanda nan Apo Jesus ye an-ihipen la. Kaya-bay hinabi na kanla, “No hilay tataon angkumonin ha maghay panakopan ket mapay-away-away, madama ye panakopan. Wanabay met ye malyadi ha maghay pamilya a ampay-away-away. ");
INSERT INTO abp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kaya-bay no kalabanen na hilan Satanas ye anhakopen na, ket ahe ya magbuyot ye panakop na, kali? Anhabiyen yon ampamaalih akon maloke a ihpidito makauli ha kapalyadiyan nan Satanas, noba aliwan peteg yain a anhabiyen yo! ");
INSERT INTO abp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Haanin, no hiyay Satanas ye namyay kangko nin kapalyadiyan a mamaalih nin mangaloke a ihpidito, aya met awod ye namyay nin kapalyadiyan kanlan mānumbong yo, ta ampamaalih hila met nin mangaloke a ihpidito? Hilay mānumbong yoyna met ye makapipapteg a aliwan huhto ye an-ihipen yo. ");
INSERT INTO abp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Noba ulita ampamaalih akon maloke a ihpidito makauli ha kapalyadiyan nin Dioh, hiyay labay habiyen, nilumateng yaynay panakop nan Apo Dioh kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Inlalayi na yan Apo Jesus ye Satanas ha maghay lakin makhaw, “No hiyay makhaw a laki a main genap a almah, ket ambantayan nay baey na, homain makatakaw nin babandi na. ");
INSERT INTO abp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Noba no main lumateng a mamakhaw po kana, ket mahambot ya. Kowen nan mamakhaw a laki ye aalmah a anhigudowen nan nagbaey a makapiligtah kana. Pangayadi, kowen nay kaganaan a labay nan hamhamen haka na idakay.” ");
INSERT INTO abp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ayaman a ahe ampakitupig kangko, ket angkumuntada ya kangko. Ayaman a ahe ampanaglap kangkon mangihaley nin tatao kanan Apo Dioh, ket ampangitaang ya kana.” ");
INSERT INTO abp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Haanin, hinabi na po Apo Jesus, “No alihan na yan maloke a ihpidito ye maghay tao, hiyay maloke a ihpidito, ket makew yan magpahyal ha maklang a lugal ta-omen ya manapul nin pagpainawaan na. Ket no homain yan makitan, habiyen na ha hadili na, ‘Hi! Udongen ko yaynan bengat ye taon ibatan ko hatew.’ ");
INSERT INTO abp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ha pag-udong na kanan taon ibatan na, ket malatngan naya a ba-mon maghay baey a malinih boy malimpeh. ");
INSERT INTO abp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaya-bay umalih yayna man, ta managyat ya po nin pitoy ihpidito a maloloke po kana. Ket humlep hila kana. Kaya-bay maloloke po ye kahahaad na lano dinan ha una.” ");
INSERT INTO abp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Haanin, legan ampaghabi ya po ye Apo Jesus, main maghay babayi ha kalabongan lan tatao ihtew ye nangipangha kana nin wanae, “Minged yay babayin nangianak boy namahoho kammo!” ");
INSERT INTO abp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Noba nakibat yay Apo Jesus kana, “Awo, noba lalalo hilaynan minged ye tataon ampanlenge boy ampanumbong nin Habi nin Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ha anlumabong hilaynay tataon anhumaley kanan Apo Jesus, hinabi na, “Koynay kalok-an yon tatao kananyatin panaon! Ampakikwa kawon kapagtakaan bilang pagkakitan a hiko ye intubol nan Apo Dioh. Noba homain akon ipakit kanyo, no aliwan hiyay kapagtakaan a omen ha nalyadi kanan podopitan Jonas hatew. Tatloy mangaamot boy madeglem na ha bitoka nin digdig a malanghit, noba ha impagtol na yan malanghit, ket angkabi-ay ya po. ");
INSERT INTO abp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ta hiyay nalyadi kanan Jonas, ket nag-ilyadi yan pagkakitan a intubol na yan Apo Dioh kanlan taga Nineve. Wanabay met kangko a ibat ha langit a in-Anak nin Tao. Mag-ilyadi kon pagkakitan kanlan tatao kananyatin panaon. ");
INSERT INTO abp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ha Mangaamot nin Panuhga nan Apo Dioh, hiyay Reyna ha Abagatan, mabi-ay ya met uman. Ket mideng yan manihtigon laban kanyon tatao kananyatin panaon. Ta hatew, agya angkumonin ya ha mataang a lugal, ket nakew yan teed nanlenge nin kadunongan nan Poon Solomon. Ket haanin, anti ko ihti a madadangal po kanan Solomon, noba ahe yoko met anleng-en. ");
INSERT INTO abp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ha Mangaamot nin Panuhga nan Apo Dioh, hilay taga Nineve a naghehe, ket mideng hilan manihtigon laban kanyon tatao kananyatin panaon. Ta hatew ha nange lay impatanda nan Jonas, ket pinaghehean lay kakahalanan la. Ket haanin, anti ko ihti a madadangal po kanan Jonas. Noba agya po man nange yoy impatanda ko, ahe kawon teed naghehe ha kakahalanan yo.” ");
INSERT INTO abp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hinabi na po Apo Jesus, “Homain taon mamaet nin kingki haka na itayo o hakeban nin takalan. No aliwan ikonin naya ha hadya a pangikunaan ta-omen mahnag ye loob nin baey kanlan lumoob.” ");
INSERT INTO abp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hinabi nan Apo Jesus, “Hiyay mata ye pinagkatillag a mamahnag nin laman mo. Kaya-bay no makinang ye pamilew mo, ket angkapahnagan ye matiboen laman mo. Noba no aliwan makinang ye pamilew mo, ket angkalitehan ye matiboen laman mo. ");
INSERT INTO abp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaya-bay pakahigudowen mon peteg a kahnagan ye anti kammo. Ta maka hiyay nabaan mon kahnagan a anti kammo, ket kalitehan ya met manayti. ");
INSERT INTO abp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","No pawa yan kahnagan ye anti kammo boy homain bega maliteh, angkahnagan ye bi-ay mo a ba-mon angkahnagan kan tillag.” ");
INSERT INTO abp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pangayadi nan naghabin Apo Jesus, main maghay Pariseo ye nanagyat kana a makew mangan ihtew ha baey na. Ket nakilakew ya met ye Apo Jesus kana. Ket ha niabot hilayna ha baey nan Pariseo, nakidungo yan nangan. ");
INSERT INTO abp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hilay Papariseo, main hilan kaugalian no way-omen mag-ibano bayo mangan, noba ahe na yan hinumbong Apo Jesus yatew. Kaya-bay nagtaka yay Pariseo. ");
INSERT INTO abp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hinabi nan Apo Jesus kana, “Hikawon Papariseo, anlinihan yoy ilwah nin babaho boy pipinggan yo, noba napno met nin babagay a kinuhit yo kanlan tatao uli ha kaakokohan yo. ");
INSERT INTO abp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mutaw kawobay! Ahe yo nayi tanda a hiyay Apo Dioh ye nanyag nin laman boy puho. ");
INSERT INTO abp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaya-bay ingalowan yo hilay mangaidap boy haglapan yo hila ha matapul la ta-omen ya maibilang a malinih ye puho boy laman yo ha pamilew nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Hikawon Papariseo, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta agya po man an-ihagpa yo kanan Apo Dioh ye ikamapo nin pupol yon dikado ha tanaman yo boy agayep yo, ampaolayan yoy matoynong a pamakilamo ha kapadiho yon tao boy pangado kanan Apo Dioh. Huhto a ibyay yoy ikamapo yo. Noba adi yo ampaolayan ye maaalaga a bibilin.” ");
INSERT INTO abp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Hikawon Papariseo, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta no anlumoob kawo ha pāytiponan yo, kalalabay yoy mikno ha pamiknoan a nakataladan kanlan mangadangal a tatao. Ket no ampagpahyal kawo ha banwa, kalalabay yoy maidlaw nin tataon angkadanan yo.” ");
INSERT INTO abp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Hikawon Papariseo, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta nabaan lan tatao a malinih kawo. Noba madinat kawo met a omen ha nangilbengan a angkatudakan lan tatao, ta homain pagkakitan.” ");
INSERT INTO abp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Haanin, hinabi nan maghan maihtodo nin Bibilin kanan Apo Jesus, “Maihtodo, ulin yain a hinabi mo, pinading-eyan mo kayi met.” ");
INSERT INTO abp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nakibat yay Apo Jesus kana, “Hikawon mamaihtodo nin Bibilin, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta an-ipahumbong yo kanlan tatao ye impahan yo a bibilin a maidap humbongen. Noba hikawo, homain kawon bega andiyagen ta-omen yo hila mahaglapan ha panumbong nin yatew a bibilin. ");
INSERT INTO abp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta ampamadyag kawo nin bilang pagkakitan nin nakailbengan lan popodopita a pinatey lan nangaunan tutoa yo. ");
INSERT INTO abp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kaya-bay hikawoynabay met ye ampamapteg a an-umayon kawo ha dinyag lan nangaunan tutoa yo. Ta hilabay ye namatey kanlan popodopita, ket hikawo met ye ampamadyag nin bilang pagkakitan nin nangilbengan kanla. ");
INSERT INTO abp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaya-bay hiyay Apo Dioh a madunong, ket hinabi na, ‘Mangitubol ako kanla nin popodopita boy aapohtol ko. Hilay nangaano kanla, pateyen la. Ket hilay kanayon, ipaloke la.’ ");
INSERT INTO abp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaya-bay hikawon tatao kananyatin panaon, paduhaan na kawo met Apo Dioh uli ha pamatey kanlan popodopita paibat po ha pinalhowa ye babe-luta anggayna haanin ");
INSERT INTO abp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","boy paibat po ha pinatey la yay Abel angga kanan Zacarias a pinatey la ha pietan nin Timplo boy pangihagpaan nin digalo kanan Apo Dioh. Pakaleng-en yon manged ye habiyen ko. Hikawon tatao kananyatin panaon, homain hapo a paduhaan na kawon Apo Dioh uli ha dinyag lan nangaunan tutoa yo.” ");
INSERT INTO abp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Hikawon mamaihtodo nin Bibilin, kakaingalo kawo lano, ta paduhaan na kawon Apo Dioh! Ta ahe yo impatanda kanlan tatao ye kaptegan tungkol kanan Apo Dioh. Ba-mon kingwa yoynay tulbek nin baey. Ahe yobayna labay ye humlep ha baey. Ket anhaaden yo hila po ye malabay humlep.” ");
INSERT INTO abp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ha inumalih yaynay Apo Jesus ihtew ha baey nan Pariseo a nanagyat kana, hilay mamaihtodo nin Bibilin boy hilay Papariseo, ket tubat anay panguntada la kana. Ket pinanepetan la yan malabong a babagay, ");
INSERT INTO abp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ta labay la yan bengat makalot ha hehebat na. ");
INSERT INTO abp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Haanin, linibo-libo hilay tataon ampakitipon kanan Apo Jesus. Ket ampaypapaletpet hilayna. Hinabi nan Apo Jesus kanlan mānumbong na, “Mag-alla kawo a adi kawo ampagkonwadi a omen kanlan Papariseo. Ta hiyay pagkonwadi la, mailalayi ha pamalbag a mapalbag nay kaganaan a nakaihalean na. ");
INSERT INTO abp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta homain nakatayo a ahe lano mibagwa boy homain met hiklito a ahe lano matandaan. ");
INSERT INTO abp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kaya-bay hinyaman ye hinabi yo ha maliteh, ket mange ya ha mahnag. Boy hinyaman ye in-onanah yo ha loob nin hilid yo, ket ipangha ya ha kaganaan.” ");
INSERT INTO abp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Hinabi nan Apo Jesus, “Gagayyem ko, pakaleng-en yon manged ye habiyen ko. Adi yo hila angkalimowan ye malabay mamatey kanyo, ta hiyay laman yon bengat ye mababa lan pateyen. Pangayadi, homain hilaynan madyag. ");
INSERT INTO abp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Noba habiyen ko kanyo a hiyay Apo Dioh ye kalimowan yo, ta hiyabay ye main kapalyadiyan a mamatey boy mangitapon kanyo ha impilno. Kaya-bay katapulan yo yan kalimowan.” ");
INSERT INTO abp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Aliwa nayi a mamoda bengat ye alaga nin limay piliw? Noba agya magha kanla, ket ahe na naliwaan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agya bilang nin labok yo, ket tanda na. Kaya-bay adi kawo angkalimo, ta mamabli kawo ha pamilew nan Apo Dioh dinan ha malabong a piliw.” ");
INSERT INTO abp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hinabi na po Apo Jesus, “Pakaleng-en yon manged ye habiyen ko. Ayaman a ahe mangikading-ey kangko ha adapan lan tatao, hiko a ibat ha langit a in-Anak nin Tao, ket ahe koya met ikading-ey ha adapan lan anghil nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Noba ayaman a mangikading-ey kangko ha adapan lan tatao, ket ikading-ey koya met ha adapan lan anghil nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Boy ayaman a mangumih kangko a ibat ha langit a in-Anak nin Tao, ket mapatawad ya. Noba ayaman a mangumih ha Ihpiditon Dioh, ket ahe ya mapatawad.” ");
INSERT INTO abp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“No ilakew la kawon litihen ha pāytiponan lan Jujudio o kanlan mānungkolan uli ha panumbong yo kangko, adi yo angkahindakan no way-omen yo ikatulidan ye hadili yo o no hinyay habiyen yo. ");
INSERT INTO abp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta kananyatew met ateed, ket ipaihip nin Ihpiditon Dioh kanyo ye hukat yon habiyen.” ");
INSERT INTO abp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Haanin, magha kanlan kalabongan a tatao ye naghabi kanan Apo Jesus, “Maihtodo, habiyen yo man kanan katongno ko a ibyay nayna kangko ye atag ko ha tawid mi kanan bapa mi.” ");
INSERT INTO abp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Noba nakibat yay Apo Jesus kana, “Agi! Homain akon katulidan a mamietan kanyo o mangatag nin babandi yo.” ");
INSERT INTO abp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Haanin, hinabi na kanlan kaganaan, “Mag-alla kawo ha kaganaan a kalahi nin kaakokohan. Ta hiyay bi-ay nin tao, ket ahe yan nakaeteb ha kalabong nin kabatnangan na.” ");
INSERT INTO abp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Haanin, in-ihtolya nan Apo Jesus ye maghay pangilalayi kanla a wanae, “Main taon mabatnang a nakapupol nin malabong ha pananeman na. ");
INSERT INTO abp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Noba kulang ye kamalig na a pangikunaan nan pupol na. Kaya-bay inihip na, ‘Hinya lagi ye diyagen ko? Homain akoynan pangikunaan nin pupol ko. ");
INSERT INTO abp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ah, tanda koyna! Ipaagwat koya man ye kakamalig ko, ket mamadyag akon mayayadet po a pangikunaan kon pupol ko boy kaganaan a babandi ko. ");
INSERT INTO abp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pangayadi, habiyen ko ha hadili ko, “Inumando akoyna, ta antina kangko ye kaganaan a babagay a matapul ko ha mabuyot a panaon. Kaya-bay haanin, magpainawa koynan bengat. Mangan ako, minom boy maghayaghag ako.” ’ ” ");
INSERT INTO abp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Noba hinabi nan Apo Dioh kana, ‘Mutaw ka! Haanin met ateed a madeglem, ket kowen koynay bi-ay mo. Aya awod haanin ye makinabang nin tinipon mo ha hadili mo?’ ” ");
INSERT INTO abp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hinabi nan Apo Jesus, “Wanabay ye malyadi ha taon ampanipon nin kabatnangan ha hadili na, noba maidap ya met ha pamilew nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Kaya-bay pakaleng-en yon manged yatin habiyen ko. Adi yo angkayootan ye tungkol ha pamangan yo o maihoot yo. ");
INSERT INTO abp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta hiyay bi-ay, maaalaga ya dinan ha pamangan. Boy hiyay laman, maaalaga ya dinan ha bado. ");
INSERT INTO abp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ihipen yo hilay oowak. Ahe hila ampananem o ampamupol boy homain hilan kamalig, noba ampakanen na hilan Apo Dioh. Maaalaga kawo po dinan ha mamanokmanok. Kaya-bay homain hapo a kalingayen na kawon Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Homain ayaman a makapakadang nin bi-ay na, agya maghay odah bengat, makauli ha pangayoot na. ");
INSERT INTO abp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kaya-bay adi yoyna angkayootan ye kanayon po a babagay, ta agya maghay odah bengat, ahe yo met mapakadang ye bi-ay yo.” ");
INSERT INTO abp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ihipen yo man ye bubulak ha nikabalang no way-omen hila antumubo. Ahe hila ampag-obda o ampanyag nin maihoot la. Noba yati ye habiyen ko kanyo. Hiyay Poon Solomon hatew, agya mabatnang yan tubat, ahe ya bega nakaihoot nin tapih a omen ha katampa nin bulak ilamon. ");
INSERT INTO abp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","No hilay iilamon a angkabi-ay haanin boy maulam kabekahan ket angkalingayen nan Apo Dioh, hikawo po lagi? Koynan kakandi ye pamteg yo kana! ");
INSERT INTO abp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kaya-bay adi yo ampagkayootan ye pamangan o inomen yo. ");
INSERT INTO abp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta hilain a babagay ye ampakaapehen lan tataon ahe ampanumbong kanan Apo Dioh. Noba hikawo, tanda nan Bapa yon Dioh a matapul yo hilain. ");
INSERT INTO abp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kaya-bay unaen yo po ye pahakop kanan Apo Dioh, ket ibyay nay kaganaan a matapul yo.” ");
INSERT INTO abp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hinabi na po Apo Jesus, “Kaya-bay agya nangaano kawon bengat a mānumbong ko, adi kawo angkalimo. Ta hiyay Bapa yon Dioh, angkaaliket ya a mananggap kanyon maibilang kanlan anhakopen na. ");
INSERT INTO abp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilako yoy babandi yo, ket ibyay yoy napaglakoan yo kanlan mangaidap. No diyagen yo yain, makatipon kawo nin kabatnangan ha langit a ahe angkabaakan, ahe angkauboh, boy ahe matakaw nin agya ayaman boy ahe maanag. ");
INSERT INTO abp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta no way-ihtew ye kabatnangan yo, ket anti ya met ihtew ye ihip yo.” ");
INSERT INTO abp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Hinabi na po Apo Jesus, “Katapulan a lanang kawon nakahadya ha panlumateng ko a omen kanlan iipoh a nikakakaantin andumlag ye kingki la a ampangagad nin pamuli nin amo lan nakew nakibanhal. Ta no mag-apo yayna ha ilwangan, ket tampol la yan mailukatan. ");
INSERT INTO abp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Minged hilay iipoh a malatngan a nakaimukat a ampangagad nin amo la. Peteg a minged hila. Pakaleng-en yon manged ye habiyen ko. Yatew a amo la, maghadya ya boy padungowen na hilan mangan. Ket apagan na hila. ");
INSERT INTO abp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Minged hilay iipoh a malatngan nin amo la a nakahadya ha hinyaman a odah, bunak man nin madeglem o palbangon.” ");
INSERT INTO abp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hinabi na po Apo Jesus, “Pakaihipen yo yati. No tanda nan nagbaey ye odah nin panlumateng nin mānakaw, ket ahe yayna matuloy boy ahe naya paolayan a makahlep ha baey na. ");
INSERT INTO abp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wanabay met kanyo. Katapulan a lanang kawon nakahadya, ta hiko a ibat ha langit a in-Anak nin Tao, ket mag-udong ihti ha babe-luta ha odah a ahe yo an-ihipen a lumateng ako.” ");
INSERT INTO abp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Haanin, nanepet yay Pedro, “Apo, hikayi nayi ye inlalayi mo ha ipoh o kaganaan a tatao?” ");
INSERT INTO abp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nakibat yay Apo Jesus, “Hiyay ipoh a mapatayaan boy madunong, hiya ye pabaalaen nan amo na kanlan kaganaan a ipoh na. Ket hiya ye mamakan kanla ha huhton odah. ");
INSERT INTO abp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Minged yay ipoh a malatngan nan amo na a andyagen nay imbilin nan amo na. ");
INSERT INTO abp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pakaleng-en yon manged ye habiyen ko. Hiyabay lano ye pabaalaen nan amo na nin kaganaan a babandi na. ");
INSERT INTO abp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Noba yain a ipoh a pinabaala na, kakaingalo ya no habiyen na ha hadili na, ‘Ah, mabuyot ya po lumateng ye amo ko’, ket bogbogen na hilay kapadiho nan iipoh a lalaki boy babayi haka yan magpapakapda a mangan, minom boy maglahing. ");
INSERT INTO abp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Haanin, lumateng yay amo na ha mangaamot a ahe na tanda. Yatew a ipoh, paduhaan na yan amo na nin mabyat boy itapon naya ha lugal a nakaitaponan lan tataon ahe mapatayaan.” ");
INSERT INTO abp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Hiyay ipoh a nagtanda nin an-ipadyag nin amo na, noba ahe ya met naghadya o ahe na dinyag, ket paduhaan na yan mabyat nin amo na. ");
INSERT INTO abp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Noba hiyay ipoh a ahe nagtanda nin an-ipadyag nan amo na, ket ampakadyag yan ikaduha na, makumpang bengat lanoy paduha na. Hiyay taon nabyayan nin malabong, ket panapulan ya met lano nin malabong. Ket hiyay taon pinabaalaan nin malabong, lalo ana ingat a malabong ye babagay a pakibatan na lano.” ");
INSERT INTO abp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hinabi na po Apo Jesus, “Nakew ako ihti ha babe-luta ta-omen mangilakew nin apoy. Ket hiyay labay ko, dumlag ana yati! ");
INSERT INTO abp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Noba bayo yain, main pamaidap a katapulan kon madihaan. Ket angkayoot akon tubat anggan ahe ko madihaan yatin pamaidap!” ");
INSERT INTO abp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Nabaan yo nayi a nakew ako ihti ha babe-luta ta-omen ko hila paykakahundoen ye tatao? Ahe! Nakew ako ihti ta-omen ko hila paykukuntadaen. ");
INSERT INTO abp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Paibat haanin, hiyay lima katao ha maghay pamilya, maykukuntada hila. Hilay tatlo, kuntadaen lay luwa boy hilay luwa, kuntadaen la met ye tatlo. ");
INSERT INTO abp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hiyay bapa, kuntadaen na yay anak na a laki. Ket hiyay anak a laki, kuntadaen naya met ye bapa na. Hiyay indo, kuntadaen na yay anak na a babayi. Ket hiyay anak a babayi, kuntadaen naya met ye indo na. Hiyay ampo a babayi, kuntadaen na yay manuyang na a babayi. Ket hiyay manuyang a babayi, kuntadaen naya met ye ampo na a babayi.” ");
INSERT INTO abp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hinabi nan Apo Jesus kanlan tatao, “No makakit kawon makugpan owep ha dapit laod, anhabiyen yo, ‘Mangudan ya!’ Ket angkalyadi ya met yatew. ");
INSERT INTO abp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No angkatanam yoy angin a ampangibat ha dapit abagatan, anhabiyen yo, ‘Maamot ya haanin!’ Ket angkalyadi ya met. ");
INSERT INTO abp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hikawon ampaggaling-galingan, tanda yon italohan ye angkakit yo ha lowang boy ihti ha babe-luta. Noba ahe yo met tanda a italohan ye pagkakitan a andiyagen nan Apo Dioh makauli kangko kananyatin panaon.” ");
INSERT INTO abp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hinabi na po Apo Jesus, “Ihipen yo no hinyay huhto yon diyagen. ");
INSERT INTO abp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","No main mangidalom kammo, bayo na kan idalom, muna kaynan makikahundo kana. Ta no ahe kawo mapaykahundo, ket uhgaan na kan uhgado. Pangayadi, igawang naka ha polih a mangipidiho kammo. ");
INSERT INTO abp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pakaleng-en mon manged ye habiyen ko. No nakapidiho kayna, ket ahe kayna milwah anggan ahe mo mabayadan ye kaganaan a multa mo.” ");
INSERT INTO abp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Haanin, main ano kataon anti ihtew ye nangibalita kanan Apo Jesus nin tungkol kanlan taga plobinhiyan Galilea a impapatey nan Gobilnadol Pilato legan ampangihagpa hila kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hinabi nan Apo Jesus kanla, “Uli ha nalyadi kanla, ket nabaan yo laweh a malalabong ye kakahalanan la dinan lan kanayon a taga Galilea a ahe na impapatey Gobilnadol Pilato? ");
INSERT INTO abp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ahe! Pakaleng-en yon manged ye habiyen ko. No ahe yo paghehean ye kakahalanan yo, ket mipalakew kawo met ha kapaduhaan a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ket hilay labinwalo kataon natey a naondagan nin todi ha Siloe, nabaan yo met laweh a malalabong ye kakahalanan la dinan kanlan kanayon a angkumonin ha banwan Jerusalem a ahe natey? ");
INSERT INTO abp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pakaleng-en yon manged ye habiyen ko. No ahe yo paghehean ye kakahalanan yo, agya hikawo met, ket mipalakew kawon kaganaan ha kapaduhaan a homain anggaan a omen kanla.” ");
INSERT INTO abp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pangayadi, in-ihtolya nan Apo Jesus yatin pangilalayi, “Main maghay taon nananem nin poon-kayon igoh ha pananamanan nan ubah. Haanin, nilakew na yan binilew no main yan dawa, noba homain yan nakit. ");
INSERT INTO abp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaya-bay hinabi na kanan mānayhay nin tanaman na, ‘Bilewen mo. Tatloy taon akoynan pag-udong-udong ihtin mamilew no main yaynan dawa yatin poon-kayon igoh. Noba homain akon nakit. Putohen mo yayna! Angkahayang bengat ye luta a pinangitaneman.’ ");
INSERT INTO abp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Noba nakibat yay mānayhay, ‘Apo, paolayan yo po kananyatin taon, ta kaliyen ko yan abonowan ye palibot nin yatin poon-kayo. ");
INSERT INTO abp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No manawa ya ha dumondon a taon, manged ya. Noba no ahe, putohen ko yayna.’ ” ");
INSERT INTO abp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ha maghay Mangaamot nin Pagpainawa, hiyay Apo Jesus, ampangiadal ya ha maghay pāytiponan lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Main maghay babayi ihtew a labinwaloy taon anan pinakayo-ko nin maloke a ihpidito. Kaya-bay ahe na yaynan maitoynong ye golot na. ");
INSERT INTO abp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ha nakit na yan Apo Jesus, ket pinahaley naya boy hinabi na, “Nitaah kayna ha hakit mo.” ");
INSERT INTO abp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Haanin, impalonto nan Apo Jesus ye gamet na kanan babayi. Ket tampol yaynan tinumoynong ye golot na. Ket nanggalang ya kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Noba hiyay mānguna ha pāytiponan lan Jujudio ihtew, ket napoot ya, ta namaitaah yay Apo Jesus ha Mangaamot nin Pagpainawa. Kaya-bay hinabi na kanlan tatao, “Ha maghay dominggo, main anem a mangaamot a malyadin mag-obda. Kanlan hilain a mangaamot kawon makew ihtin mamaitaah, aliwan ha Mangaamot nin Pagpainawa.” ");
INSERT INTO abp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nakibat yay Apo Jesus kana, “Hikawon māgkonwadin ampanumbong ha kalabayan nan Apo Dioh! No main kawon baka o ahnon nakagawot a angkaplangan ana, ahe yoya nayi loaten a ipainom, agya po man Mangaamot nin Pagpainawa? ");
INSERT INTO abp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","No an-ingalowan yoy aayop yo, lalalo yo yaynan ingalowan yatin babayi a ginapoh nan Satanas ha loob nin labinwaloy taon, ket lahi naya met Abraham. Ahe koya nayi malyadin palihwayen ha Mangaamot nin Pagpainawa?” ");
INSERT INTO abp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Uli ha hinabi nan Apo Jesus, nading-eyan hilay kaganaan a tataon angkumuntada kana. Noba angkaaliket hila met ye kanayon uli ha kapagtakaan a dinyag na. ");
INSERT INTO abp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Haanin, nagpahulong yay Apo Jesus ha pangiadal na, “Habiyen ko ye kalalayian nin panakop nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ilalayi koya ha pinakamakandin lahi' a intanem nin maghay tao ha pananeman na. Tinumobo yan nilumake a poon-kayo. Ket pinaghayan yan mamanokmanok ye hahanga na.” ");
INSERT INTO abp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Haanin, hinabi na po Apo Jesus, “Habiyen ko ye kalalayian nin panakop nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ilalayi koya ha makandin pamalbag a inggameh nin maghay babayi ha tatloy takal nin tapok, ta diyagen nan tinapay. Ket napalbag nan kaganaan yatew.” ");
INSERT INTO abp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nagpahulong yay Apo Jesus ha pangiadal na ha babanwa boy ha babadiyo a angkadanan na palakew ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Haanin, main nanepet kana, “Apo, makandin bengat nayi ye tataon miligtah?” Nakibat yay Apo Jesus makauli ha pangilalayi, ");
INSERT INTO abp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Paghehpetan yoy makahlep ha mahepey a ilwangan, ta malabong hilay mangapeh a humlep ihtew, noba ahe hila makahlep. ");
INSERT INTO abp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","No ileneb naynan nagbaey ye ilwangan, ket ahe kawoyna makahlep. Mideng kawo tana ha ilwah a paapo, ‘Apo, ilukatan mo kayi dayi ta-omen kayi makahlep.’ Noba habiyen na kanyo, ‘Ahe katawo katatanda.’ ");
INSERT INTO abp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Haanin, habiyen yo met, ‘Kalamo mi kan nangan boy ninom boy nangiadal ka po ha lugal mi.’ ");
INSERT INTO abp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Noba habiyen na kanyo, ‘Ahe katawo katatanda. Pakataang kawo kangko, hikawon kaganaan a ampanyag nin maloke!’ ");
INSERT INTO abp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tumangih boy manginaet kawo lano ha ilwah no makit yo yay Abraham, Isaac, Jacob, boy hilay kaganaan a popodopita a anti ha panakopan nan Apo Dioh, noba hikawo, ket mitaboy kawo. ");
INSERT INTO abp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Makit yo hila lanon lumateng ye aliwan Judio a mangibat ha nakahinadi a lulugal ihti ha babe-luta a makidungon mangan ha poniyan nan Apo Dioh ha panakopan na ha langit. ");
INSERT INTO abp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ket peteg a main angkahuyot a miuna lano boy main met angkauna a mipahuyot lano.” ");
INSERT INTO abp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kananyatew met ateed, main anon Papariseo ye nakew kanan Apo Jesus. Ket hinabi la kana, “Umalih kawoyna ihti, ta hiyay Gobilnadol Herodes Antipas, labay na kan pateyen.” ");
INSERT INTO abp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nakibat yay Apo Jesus kanla, “Makew kawo kananyain a māgkonwadi. Ket habiyen yo kana a ihulong koy pamaalih kon mangaloke a ihpidito kanlan tatao boy pamaitaah ko kanlan ampaghakit anggan mabekah. Ket ha ikatlon mangaamot, mayadi koynay abala ko. ");
INSERT INTO abp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Noba katapulan kon ihulong ye pamakew ko ha Jerusalem haanin, mabekah boy makalwa a mangaamot, ta malabong a popodopita ye pinatey la hatew ha banwan Jerusalem. Ket ulita magha ko met a podopita, ahe ako malyadin matey ha ilwah nin Jerusalem.” ");
INSERT INTO abp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Haanin, hinabi nan Apo Jesus, “Hikawon tatao ha Jerusalem, leng-en yo yati. Pinatey yo hilay popodopita nin Dioh boy hilay kanayon a intubol na kanyo, binegbaan yo hilan dadapah angga ha natey. Nikanon ukdo katawoynan labay halokoban a omen ha panalokob nin toan manok ha hihiwhiw na, noba ahe yo labay. ");
INSERT INTO abp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaya-bay agya main mangagwat nin kunaan yo, baala kawoyna. Pakaleng-en yon manged ye habiyen ko. Ahe yo koynan makit uman anggan ahe yo habiyen, ‘Inged na yan Apo Dioh ye anlumateng ha ngalan na.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ha maghay Mangaamot nin Pagpainawa, main maghay mānguna lan Pariseo ye nanagyat kanan Apo Jesus a makew mangan ha baey na. Ket hilay tataon angkumuntada kana, ambantayan la yan manged. ");
INSERT INTO abp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Haanin, hinumaley ya kanan Apo Jesus ye maghay lakin angkabaya. ");
INSERT INTO abp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hiyay Apo Jesus, tinepet na hilay mamaihtodo nin Bibilin boy Papariseo, “An-ipaluboh nayi nin Bibilin ye mamaitaah nin ampaghakit ha Mangaamot nin Pagpainawa?” ");
INSERT INTO abp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Noba ahe hila nakibat kana. Haanin, ginemgeman na yan Apo Jesus ye taon angkabaya. Ket pinaitaah naya boy pinauli na yayna. ");
INSERT INTO abp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Haanin, tinepet na hila, “No maampag yay anak yo o baka yo ha maalale a libon ha Mangaamot nin Pagpainawa, ahe yoya nayi dandanen a iawah?” ");
INSERT INTO abp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Noba homain hilan maihebat kana, ta peteg ye hinabi na. ");
INSERT INTO abp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Haanin, naedepan nan Apo Jesus a ampilien lan bibihita ye pamiknoan a naitaladan kanlan tataon andangalen. Kaya-bay hinabi na makauli ha pangilalayi, a wana, ");
INSERT INTO abp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No main mangumbida kammo ha banhal, adi ka mikno ha pamiknoan a naitaladan kanlan tataon andangalen, ta maka main nakumbida a madadangal po kammo. ");
INSERT INTO abp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ket no nakaikno kayna ihtew, humaley ya kammo ye nangumbida boy habiyen na, ‘Pangingalo mo, ta main nakataladan a mikno ihen.’ Ha wanabay, mading-eyan ka. Ket mikno kaynan bengat ha pamiknoan lan aliwan andangalen a tatao. ");
INSERT INTO abp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaya-bay no nakumbida ka ha banhal, mamanged a ihtew kawo mikno ha pamiknoan lan tataon aliwan andangalen. Ta no lumateng yay nangumbida kanyo, ket habiyen na kanyo, ‘Makew ka ihti, gayyem. Ihti ka mikno ha manged a pamiknoan.’ Ha wanabay, midangal kawo ha adapan lan kaganaan a nakumbida a anti ihtew. ");
INSERT INTO abp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta ayaman a ampagmatagay, ket iaypa na yan Apo Dioh. Boy ayaman a ampagmaaypa, ket itagay na yan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Haanin, hinabi na po nin Apo Jesus kanan Pariseon nanagyat kana, “No mangitaladan kan poniyan, aliwan hilay gagayyem mo o kakatongno mo o papaltido mo o kakaaluba mon mangabatnang ye kumbidaen mo. Ta no hilabay ye kumbidaen mo, diyagen la met lano kammo ye dinyag mo kanla. Ket ha wanabay, naitumbae layna kammo ye manged a dinyag mo. ");
INSERT INTO abp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No aliwan hilay kumbidaen mo, ket hilay mangaidap, hilay lulumpo, hilay pipilay, boy hilay kakapkap. ");
INSERT INTO abp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ket no diyagen moy wanabay, minged ka, ta ahe la mitumbae kammo ye manged a dinyag mo kanla. Hiyaynay Apo Dioh ye mamyay kammo nin plimyo lano ha bi-ayen na hilan uman ye mangatoynong a tatao.” ");
INSERT INTO abp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Haanin, pamakange nan magha kanlan kadungo nan Apo Jesus yatew, hinabi na kana, “Minged yay taon makidungon mangan ha poniyan ha panakopan nan Apo Dioh!” ");
INSERT INTO abp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nakibat yay Apo Jesus makauli ha pangilalayi, “Main maghay taon nangitaladan nin mayadet a poniyan. Ket nangumbida yan malabong a tatao. ");
INSERT INTO abp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ha naihadya anay kaganaan, intubol na yay ipoh na a managyat kanlan kinumbida na. Hinabi na kanla, ‘Tawoyna, ta nakataladan anan kaganaan!’ ");
INSERT INTO abp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Noba hilan kaganaan a nakumbida, nagbadaan hila. Hinabi nin magha, ‘Nakahaliw akon luta. Ket katapulan ko yan bilewen. Kaya-bay pahinhiya kayna.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Hinabi na met nin magha, ‘Nanaliw akon mapo a baka. Ket huboken ko hilan pang-adado. Kaya-bay pahinhiya kayna.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Hinabi na met nin magha po, ‘Kapipiyadi kon bengat nagkahal. Kaya-bay ahe ako makalakew.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Haanin, nag-udong yaynay ipoh. Ket hinabi na kanan amo na ye nalyadi. Napoot yay amo na. Ket intubol na yayna man ye ipoh na, ‘Manandali kan makew ha dādān boy ha makpit a dādān nin banwa. Ket ilakew mo hila ihti ye mangaidap, pipilay, kakapkap, boy hilay lulumpo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ha nag-udong yaynay ipoh, hinabi na kanan amo na, ‘Apo, nadyag koynay hinabi mon diyagen ko, noba malabong po ye iknoan a homain tao.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kaya-bay hinabi nayna man nin amo ha ipoh na, ‘Manige kayna man, ta makew ka ha dādān boy ha makpit a dādān ha ilwah nin banwa. Ta piliten mo hilan makew ihti ye tatao ta-omen ya mapno nin bihita ye baey ko. ");
INSERT INTO abp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pakaleng-en yon manged ye habiyen ko. Agya maghan bengat kanlan kinumbida ko, ket ahe la matawayan ye intaladan kon pamangan.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Malabong hilay tataon ampakilakew kanan Apo Jesus. Haanin, nagpeyeh yan inumadap kanla. Ket hinabi na, ");
INSERT INTO abp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ayaman a taon makilakew kangko a ampangado kangko nin igit ha pangado na kanan bapa na boy indo na, kanan ahawa na boy aanak na, kanlan kakatongno na boy ha hadili na, ket malyadi yan mānumbong ko. ");
INSERT INTO abp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ayaman a ahe nakahadya a matey ha panumbong na kangko a ba-mo yan ampamatay nin kodoh, ket ahe ya malyadin mānumbong ko.” ");
INSERT INTO abp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ayaman a malabay manumbong kangko, ihipen na po nin manged no mababa na ye kaidapan a madihaan na ha panumbong na kangko. Ilalayi koya ha taon mamaideng nin matagay a baey a panamulawan nin māgbantay. Bayo na yan dugiyan, mikno ya po ta-omen na ihipen no anoy magahtoh na boy no mignap ya ye pilak nan pangiyadi na. ");
INSERT INTO abp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta no ahe na diyagen yatew, maka pundahyon bengat ye maikonin na. Ket ahe na yayna maiyadi ye todi. Ket balang makakit nin yatew, umihen la yay mamaideng, a wanla, ");
INSERT INTO abp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Hi! Bilewen mo man yain a tao. Dinugiyan naynan manyag nin todi, noba ahe naya met manayti maiyadi.’ ” ");
INSERT INTO abp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Wanabay met ha maghay poon a malabay makilaban ha kapadiho nan poon. Ihipen na po muna no mababa lan hamboten nin mapo a libo a huhundaloh na ye luwampo a libo a huhundaloh nin kalaban na. ");
INSERT INTO abp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ket no ha ihip na, ahe la hilan mababa hamboten, legan mataang hila po ye kalaban na, ket mangitubol yaynan ano kataon maunan managana a makikahundo kanan kalaban na. ");
INSERT INTO abp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wanabay met ateed kanyo. Pakaihipen yo po nin manged no mababa yoy manumbong kangko. Ta no ahe yoya ihuko ye kaganaan ha bi-ay yo, ket ahe kawo malyadin mānumbong ko.” ");
INSERT INTO abp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hinabi na po Apo Jesus, “Manged ye ahin. Noba no maalih anay apgad na, ahe yayna maiudong ye apgad na. ");
INSERT INTO abp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Homain yaynan hilbi agya ihale ya ha luta o ha dinat a pang-abono nin luta. Kaya-bay itapon yayna tana nin tatao. Hikawon ampanlenge, pakaihipen yo yatin manged.” ");
INSERT INTO abp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Haanin, hilay māningil nin bowih boy hilay kanayon po a māgkahalanan, ket nakew hilan manlenge kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Haanin, hilay Papariseo boy hilay mamaihtodo nin Bibilin, ket naytatalabotob hila, “Bilewen yo yain a tao! Ampakihale ya kanlan māgkahalanan boy ampakidungo yan mangan kanla.” ");
INSERT INTO abp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kaya-bay in-ihtolya nan Apo Jesus kanla yatin alimbawa, ");
INSERT INTO abp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“No hiyay maghay tao a main magatoh a tupa, ket mipakat ye magha, hinyay diyagen na? Ahe na hila nayi lakwanan ye hiyamapo boy hiyam ha pagpahtolan na, ta tapulen na yay tupa a nipakat anggan makitan naya? ");
INSERT INTO abp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ket no makitan na yayna, mahayaghag na yan ibatay a iuli yatew a tupa. ");
INSERT INTO abp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ket no miabot yayna ha baey na, hagyaten na hilay gagayyem na boy kakaaluba na. Ket habiyen na kanla, ‘Makihayaghag kawo kangko, ta nakitan ko yaynay tupa ko a nipakat!’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hinabi na po Apo Jesus kanlan ampaytatalabotob, “Wanabay met ateed kanlan anti ha langit. Mahayaghag hila uli ha hiyamapo boy hiyam a tataon matoynong a homain paghehean. Noba mahahayaghag hila po no main maghay māgkahalanan a maghehe ha kakahalanan na.” ");
INSERT INTO abp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Haanin, in-ihtolya na po nin Apo Jesus yatin pangilalayi, “No hiyay maghay babayi a main mapo a palatan mital, ket mikatak ye magha, hinya nayi ye diyagen na? Aliwa nayi a mamaet yan kingki a pamaliwag na haka na yan kaykayan ye baey na, ket maalla na yan tapulen ye nikatak angga ha makitan naya? ");
INSERT INTO abp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ket no makitan na yayna, hagyaten na hilay gagayyem na boy kakaaluba na. Ket habiyen na kanla, ‘Makihayaghag kawo kangko, ta nakitan ko yaynay palata kon nikatak!’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hinabi nan Apo Jesus, “Wanabay met ateed ha langit. Ampaghayaghag hilay aanghil nin Dioh uli ha maghay taon māgkahalanan a naghehe ha kakahalanan na.” ");
INSERT INTO abp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hinabi na po Apo Jesus, “Main maghay bapa a main luway anak a laki. ");
INSERT INTO abp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hinabi nan makaydeng kanan bapa na, ‘Tatang, ibyay moyna kangko ye atag ko a tawiden ko.’ Kaya-bay hiyay bapa la, inatag nay babandi na kanlan luway aanak na.” ");
INSERT INTO abp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Pangalabah nin anoy mangaamot, hiyay makaydeng, inlako nay kaganaan a atag na. Ket nakew yayna ha mataang a lugal. Ket hiyay napaglakoan na, ginahtoh na ha bihyo boy ha palugad a pagbi-ay. ");
INSERT INTO abp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Haanin, ha nauboh na yaynay pilak na, nagkamain nin tubat a bitil nin yatew a lugal a nilakew na. Ket angkabitlan yayna met. ");
INSERT INTO abp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hiyay dinyag na, nakew yan nakiupa kanan maghay tao ihtew. Haanin, intubol na yan taon nakiupaan na ihtew ha baboyan na. Ket dinyag na yan mānayhay nin bababoy. ");
INSERT INTO abp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ulita homain namyay kana nin kanen, angkabitlan yaynan tubat. Ket agya pamangan nin bababoy, labay nayna dayin kanen.” ");
INSERT INTO abp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ha naihipan nay kaganaan a dinyag na, hinabi na ha hadili na, ‘Ihtew kammi, hilay iipoh nan bapa ko, angkabhoy hila boy luhbo ye pamangan la. Noba hiko, anti ko ihtin angkakamatey anan bitil. ");
INSERT INTO abp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ah, mamanged po a mag-udong akoyna kanan bapa ko. Ket habiyen ko lano kana, “Tatang, nagkahalanan ako kanan Apo Dioh boy kammo. ");
INSERT INTO abp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ahe akoyna katanggap-tanggap a ibilang mon anak. No malyadi dayi, agya ibilang mo koynan bengat a magha kanlan iipoh mo.” ’ ");
INSERT INTO abp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kaya-bay nuli yayna kanan bapa na. Ha mataang-taang ya po ha baey la, natamulaw na yaynan bapa na. Ket nalunoh ya kana. Kaya-bay nayew yan nanagana kana. Ket tinakeh boy inumaan naya.” ");
INSERT INTO abp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Hinabi nan anak, ‘Tatang, nagkahalanan ako kanan Apo Dioh boy kammo. Ket ahe akoyna katanggap-tanggap a ibilang mon anak.’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Noba hinabi nan bapa na kanlan iipoh na, ‘Padah yo! Ilakew yo ihti ye pinakamatampa a bado, ket ihoot yo kana. Pahinghingan yoya boy paihtipingan. ");
INSERT INTO abp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Boy kowen yo yay pinataba a oybon baka, ket hapoen yoya, ta mangan boy maghayaghag kitawo! ");
INSERT INTO abp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta yatin anak kon nabaan koynan natey, ket angkabi-ay ya met manayti! Nagbalangbalang ya, noba nag-udong ya met ateed!’ Ket haanin, ingkana laynay maghayaghag.” ");
INSERT INTO abp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kananyatew a odah, hiyay makaagat a katongno na, ket anti ya ha padayan. Ha ampuli yayna boy mahaley yayna ha baey la, nange nay tigtigan boy talekan ha baey la. ");
INSERT INTO abp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kaya-bay iningat na yay magha kanlan iipoh la. Ket tinepet naya, ‘Taket ta main tigtigan?’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Nakibat yay ipoh, ‘Nag-udong yaynay katongno mo a angkabi-ay boy maligha. Kaya-bay impahapo na yan bapa mo ye pinataba a oybon baka.’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Haanin, nagpoot yay makaagat. Ket ahe nayna labay ye lumoob ha baey la. Kaya-bay nilakew na yan bapa na. Ket inamuyot na, a wana, ‘Inong, lumoob kayna.’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Noba hinabi na kanan bapa na, ‘Nabuyot akoynan ampaghilbi kammo boy antupaden koy kaganaan a bilin mo. Noba nakakanoman, ahe moko binyan nin agya maghan oybon kambing bengat ta-omen ako makapaghayaghag a lamo ko hilay gagayyem ko. ");
INSERT INTO abp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Noba ha nilumateng yain a anak mon nangilumpoh nin babandi mo kanlan babayin babayadan, ket impahapoan moya po nin oybon baka a pinataba.’ ” ");
INSERT INTO abp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Nakibat yay bapa na, ‘Anak ko, hika ye lanang kon kalamo. Ket hilay kaganaan a babandi ko, pagkonin moyna. ");
INSERT INTO abp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Noba katapulan tawoy maghayaghag boy mag-aliket haanin, ta hiyay katongno mo a nabaan koynan natey, ket angkabi-ay ya met manayti! Nagbalangbalang ya, noba nag-udong ya met ateed!’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Main maghay taon mabatnang. Impataya nay babandi na ha maghay ampatayaan na. Haanin, main naghumbong kana, ‘Hiyay ampatayaan mo, ket an-iuboh nay babandi mo.’ ");
INSERT INTO abp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kaya-bay impadakit na yay ampatayaan na. Ket tinepet naya, ‘Hinyatin humbong kangko a tungkol kammo? Ibyay mo kangko ye lihtaan nin kaganaan a babandi ko a impataya ko kammo. Ta paibat haanin, ket ahe kataynan patayaan nin babandi ko.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Haanin, hiyay ampatayaan na, nangihip yan wanae, ‘Hinya lagi ye diyagen ko? Alihen na koynan amo ko ha obda ko. Ket ahe koynan mababa ye mag-obda nin mabyat boy angkading-ey akon magpalimoh. ");
INSERT INTO abp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, tanda koyna! Manyag akon papadan ta-omen lako tanggapen nin tatao ha baey la no maalih akoyna ha obda ko.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Haanin, hiyay ampatayaan na, bayo naya in-ibyay ye lihtaan kanan amo na, tinitimagha na hilan kinatongtong ye kaganaan a tataon nakautang kanan amo na. Tinepet na yay naunan nakautang, ‘Anoy utang mo kanan amo ko?’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nakibat yay nakautang, ‘Hiyay utang ko ket magatoh a halaw nin ladak olibo.’ ” “Hinabi nan ampatayaan na, ‘Yati ye lihtaan nin utang mo. Diyagen mo tanan limampo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Haanin, tinepet naya met nin ampatayaan ye kakalwan nakautang, ‘Hika? Anoy utang mo?’ ” “Nakibat yay tao, ‘Hiyay utang ko ket magatoh a kaban nin tidigo.’ ” “Ket hinabi nan ampatayaan, ‘Yati ye lihtaan nin utang mo. Diyagen mo tanan walompo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ha natandaan nan amo ye dinyag nan makuhit a nangipatayaan nan babandi na, hinabi na, ‘Kagaling mon manyag nin papadan!’ Ta peteg a hilay tataon ahe ampanumbong kanan Apo Dioh, ket mahihidi hilan mangihip nin papadan dinan kanlan tataon ampagbi-ay ha kahnagan.” ");
INSERT INTO abp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ket nagpahulong yay Apo Jesus ha paghabi na, “Pakaleng-en yon manged ye habiyen ko. Hilay kabatnangan yo ihti ha babe-luta, ket gawien yo ha panyag nin manged kanlan kapadiho yon tao. Ta agya po man mauboh ye kabatnangan yo, matanggap kawo ha angkunaan a mikakaanti makanoman.” ");
INSERT INTO abp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Hiyay taon mapatayaan ha makandin bagay, ket mapatayaan ya met ateed ha malabong a babagay. Ket hiyay taon ahe mapatayaan ha makandin bagay, ahe ya met mapatayaan ha malabong a babagay. ");
INSERT INTO abp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaya-bay no ahe kawo mapatayaan ha kabatnangan ihti ha babe-luta, ket ahe na met maipataya nin Apo Dioh kanyo ye peteg a kabatnangan. ");
INSERT INTO abp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No ahe kawon mapatayaan ha kabatnangan nin kanayon, homain lanoy mamyay kanyo nin kabatnangan a nakataladan ana kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Homain ipoh a mapayngidlan nan paghilbiyan ye luway amo. Ta no adoen na yay magha, katapulan a kahulogan na yay magha. Ket no mag-ilyadi yan mapatayaan ha magha, katapulan a umihen naya met ye magha. Wanabay met ateed, ahe yo malyadin payngidlanen a paghilbiyan ye Apo Dioh boy hiyay kabatnangan.” ");
INSERT INTO abp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Haanin, hilay Papariseo a lupan pilak, pamakange lay pangiadal nan Apo Jesus tungkol ha kabatnangan, ket inlungolungo laya. ");
INSERT INTO abp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kaya-bay hinabi nan Apo Jesus kanla, “Ampagmamangedan kawo kanlan tatao. Noba tanda nan Apo Dioh ye kaganaan a anti ha puho yo. Ta hiyay an-ibilang lan tatao a maalaga, ket adi-adi nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hiyay Bibilin a impahulat kanan Moises boy impahulat kanlan popodopita hatew ye anhumbongen lan tatao angga ha namabala yay Juan a Māmawtihmo. Ket paibat ha panaon nan Juan, an-ipatanda ana ye Manged a Balita a tungkol ha panakop nan Apo Dioh. Ket malabong hilay tataon mauplit a maibilang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Noba aliwan labay habiyen a homain anan hilbi ye Bibilin nan Apo Dioh. Ta agya po man maanam ye langit boy luta, ket ahe ya maalihan hilbi ye pinakamakandin pahen nin Bibilin.” ");
INSERT INTO abp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Alimbawa, ayaman a lakin mangihyay nin ahawa na ket mangahawa yan lumbo, magkahalanan yan pamabayi. Ket hiyay lakin mangahawa kanan babayin in-ihyay nin ahawa na, magkahalanan yayna met nin pamabayi.” ");
INSERT INTO abp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hinabi na po Apo Jesus kanlan Papariseo, “Main maghay taon mabatnang a nakahoot nin mablin bado boy palugad ye pagbi-ay na ha minamangaamot. ");
INSERT INTO abp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Main met maghay maidap a nagngalan Lazaro. Ket hiyay laman na, napampoh yan delat. An-ilakew la yan tatao ha talig ilwangan nin alad nin baey nan mabatnang. ");
INSERT INTO abp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta labay nay makakan agya mumom bengat a angkaampag ha hilong lamihaan nan mabatnang. Ket agya hilay aaho, anlakwen laya met a andil-an ye dedelat na.” ");
INSERT INTO abp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Haanin, ha natey yaynay Lazaro, inlakew la yan aanghil ha langit ha talig nan Abraham. Ket ha natey yayna met ye mabatnang, in-ilbeng laya. ");
INSERT INTO abp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ket legan ampagdiha yan tubat a idap ha impilno, natangal na yay Lazaro a lamo na yan Abraham ihtew ha langit. ");
INSERT INTO abp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kaya-bay pinanghaan na yay Abraham, ‘Bapa a Abraham, ingalowan moko! Itubol moya dayi ye Lazaro a mangidede nin tamudo na ha lanom ta-omen na ipatulo ha dila ko, ta tubat anay pagkalanglang kon apoy.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Noba nakibat yay Abraham kanan mabatnang, ‘Anak, pakaihipen mo a ha angkabi-ay ka po ha babe-luta, ket pawa palugad ye pagbi-ay mo, noba hiyay Lazaro, pawa kaidapan ye nadihaan na. Ket haanin, anti ya ihtin mahayaghag noba hika, anti ka ihen a ampag-idap. ");
INSERT INTO abp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ket magha po, main maway a pietan kantawo. Kaya-bay ahe ya makalakew ihen ye anti ihti. Wanabay ya met ye anti ihen. Ahe ya makalakew ihti.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Haanin, hinabi nan mabatnang, ‘No wanabay awod, an-ipakihabi ko kammo, Bapa a Abraham a itubol moya dayi ye Lazaro a makew ha baey nan bapa ko. ");
INSERT INTO abp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta main ako po katongnon limay lalaki. Babalaan na hila dayi ta-omen hila ahe mipalakew ihtin lugal nin kapaduhaan.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Noba hinabi nan Abraham kana, ‘Agya ahe ana, ta anti yayna kanla ye impahulat kanan Moises boy impahulat kanlan popodopita. Katapulan lan bengat a humbongen ye nakahulat.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nakibat yay mabatnang, ‘Kulang po yatew, Bapa a Abraham! Ahe la humbongen yatew, noba no main anan natey a mabi-ay uman a makew kanla, ket paghehean laynay kakahalanan la.’ ” ");
INSERT INTO abp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Noba hinabi nan Abraham, ‘No ahe la pamtegan ye impahulat kanan Moises boy hiyay impahulat kanlan popodopita, ahe la met ateed pamtegan agya po man main makew kanla a nabi-ay uman.’ ” ");
INSERT INTO abp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Homain hapo a lumateng ye pagkahalananan, noba kakaingalo ye malyadi ha taon ampanyag nin pagkahalananan nin kapadiho nan tao. ");
INSERT INTO abp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ayaman a manyag nin pagkahalananan lan hilatin aanak a ampamteg kangko, ket mamanged po a bitinan yan mayadet a gilingan a dapah ye leey na haka ya iampag ha dagat. ");
INSERT INTO abp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaya-bay mag-alla kawo!” “No hiyay katongno mo, ket magkahalanan ya kammo, babalaan moya. Ket no maghehe ya, patawaden moya. ");
INSERT INTO abp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","No ha loob nin maghay mangaamot, ket mikapito yan magkahalanan kammo ket mikapito ya met a humaley kammo a makikwa nin patawad, patawaden moya.” ");
INSERT INTO abp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Haanin, hinabi lan aapohtol nan Apo Jesus, “Pahanan mo po ye pamteg mi!” ");
INSERT INTO abp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nakibat yay Apo Jesus kanla, “No main kawon pamteg kanan Apo Dioh, agya bengat omen ha lahi' muhtaha kakandi, malyadi yon habiyen kananyatin poon-kayo, ‘Maulot ka boy maitanem ha dagat.’ Ket manumbong ya kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Hinabi na po Apo Jesus kanlan aapohtol na, “Alimbawa, main kan ipoh a nilumateng ibat ha padayan a nangadado o nagpahtol nin tupa. Aliwan hika ye mangitaladan nin pamangan nan ipoh, no aliwan habiyen mo kana, ‘Maghagili ka, ta italadanan mo kon pandeman ko boy paghilbiyan moko legan ampangan ako. Pangayadi kon mangan, mangan kayna met.’ ");
INSERT INTO abp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ahe moyna katapulan pahalamatan ye ipoh, ta andiyagen nan bengat ye katungkolan na. ");
INSERT INTO abp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wanabay met ateed kanyo. No natupad yoynay kaganaan a imbilin kanyo, katapulan a habiyen yo, ‘Ipoh kayin bengat. Ahe kayi katapulan a pahalamatan, ta andiyagen min bengat ye katungkolan mi.’ ” ");
INSERT INTO abp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Haanin, legan angkumodang yay Apo Jesus boy hilay mānumbong na a palakew ha banwan Jerusalem, nagdān hila ha pietan nin plobinhiyan Samaria boy plobinhiyan Galilea. ");
INSERT INTO abp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ha anhumlep hilayna ha maghay badiyo, hinagana hilan mapo kataon kinating. Tinumgen hila ha aliwan minga mataang ");
INSERT INTO abp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","haka hila nangha, “Apo Jesus, ingalowan mo kayi!” ");
INSERT INTO abp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pamakakit nan Apo Jesus kanla, hinabi na, “Makew kawo kanlan papadi, ta ipakit yoy laman yo kanla a nitaah kawoyna.” Ket legan ampakew hila kanlan papadi, kapipikhaan nitaah hilayna. ");
INSERT INTO abp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ket ha naedepan nan magha kanla a nitaah yayna, nag-udong ya kanan Apo Jesus a ampangha yan panggalang kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nilumukob ya ha aphayan nan Apo Jesus. Ket nagpahalamat ya kana. Yatin tao ket magha yan Samaritano. ");
INSERT INTO abp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Haanin, hinabi nan Apo Jesus, “Mapo kawon pinaitaah ko, noba way-ihtew hilay hiyam? ");
INSERT INTO abp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Malele ako, ta yatin dayohan a Samaritano bengat ye nag-udong a manggalang kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Haanin, hinabi nan Apo Jesus kanan Samaritano, “Mideng ka ket muli kayna, ta nitaah ka uli ha pamteg mo.” ");
INSERT INTO abp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ha maghay mangaamot, tinepet la yan Papariseo ye Apo Jesus no makano yan mandugi ye panakop nan Apo Dioh. Nakibat yay Apo Jesus kanla, “Hiyay panakop nan Apo Dioh, ket homain pagkakitan no makano yan mandugi. ");
INSERT INTO abp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaya-bay homain makapaghabi, ‘Ihtibay yan manakop ye Apo Dioh!’ o ‘Ihtewbay yan manakop!’ ta ampanakop yaynay Apo Dioh ha puho yo.” ");
INSERT INTO abp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Lumateng lano ye panaon a hiko a ibat ha langit a in-Anak nin Tao, ket labay yo koynan makit a mag-udong a manakop, noba ahe yo makit. ");
INSERT INTO abp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ket no main maghabi kanyo, ‘Anti ya ihtew!’ o ‘Anti ya ihti!’ adi yo hila ampamtegan o makilakew kanla. ");
INSERT INTO abp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta hiko a ibat ha langit a in-Anak nin Tao, ket mag-udong ako ihti ha babe-luta a omen ha kilat a angkapahnagan nay kaganaan a pahen nin lowang. ");
INSERT INTO abp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Noba haanin, katapulan ako po a magdiha nin malabong a idap boy ikahwil lan tatao kananyatin panaon.” ");
INSERT INTO abp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Hiyay andiyagen la lanon tatao ha mangaamot nin panlumateng ko a ibat ha langit a in-Anak nin Tao, ket omen met ateed ha andiyagen lan tatao ha panaon nan Noe. ");
INSERT INTO abp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ha panaon nan Noe, bayo po malanab ye babe-luta, hilay tatao, ahe la tanda a manlanab. Ampangan hila, ampinom boy ampangahawa a omen ha alan a andiyagen la angga ha hinumlep yaynay Noe ha daong. Ket ha anti hilayna ha loob nin daong, nilumateng ana met ye lanab. Ket nangaalimeh hilan kaganaan ye tatao ha babe-luta.” ");
INSERT INTO abp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Wanabay met ateed ye nalyadi ha panaon nan Lot. Hilay tatao, ampangan hila boy ampinom, ampanaliw hila boy ampaglako, ampananem hila boy ampangipaideng hilan babaey. ");
INSERT INTO abp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Noba ha mangaamot a inumalih yaynay Lot ha banwan Sodoma, namaudan yan apoy boy ahopli ye Apo Dioh. Ket hilay tatao ihtew, naulam hilan kaganaan.” ");
INSERT INTO abp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Wanabay met ateed lano ha mag-udong ako a ibat ha langit a in-Anak nin Tao. ");
INSERT INTO abp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kananyatew a mangaamot, hiyay anti ha ilwah nin baey na, ket adi yayna lumoob a mangwan hinyaman a bagay ha baey na. Ket hiyay anti ha talon, adi yayna muli a mangwan hinyaman a babagay. ");
INSERT INTO abp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pakaihipen yoy nalyadi hatew kanan ahawa nan Lot. ");
INSERT INTO abp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ayaman a ampangihilib nin bi-ay na, ket maanam na. Noba ayaman a nakahadya a matey uli ha panumbong na kangko, ket mabyayan yan bi-ay a homain anggaan. ");
INSERT INTO abp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Habiyen ko kanyo a ha panaon nin panlumateng ko, main lanon luway tao a angkatuloy ha maghay pamid-an. Hiyay magha, mipalakew ya ha langit. Noba hiyay magha, mabantak ya. ");
INSERT INTO abp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Main lanon luway babayi a ampanggiling. Hiyay magha, mipalakew ya ha langit. Noba hiyay magha, mabantak ya. ");
INSERT INTO abp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Main lanon luway lakin ampag-obda ha padayan. Hiyay magha kanla, mipalakew ya ha langit. Noba hiyay magha, mabantak ya.” ");
INSERT INTO abp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Haanin, hilay mānumbong nan Apo Jesus, nanepet hila kana, “Apo, way-ihtew yan malyadi yain?” Nakibat yay Apo Jesus kanla makauli ha kahabiyan, “No way-ihtew ye bangkay, ket matandaan lan kaganaan, ta anti hila ihtew ye oowak a naytitipon.” ");
INSERT INTO abp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Haanin, hinabi nan Apo Jesus kanlan mānumbong na ye maghay pangilalayi, ta labay nan ipalinaw kanla a katapulan a lanang hilan makigwang boy ahe hila humawa a makigwang. ");
INSERT INTO abp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hinabi na, “Ha maghay banwa, main uhgado a homain limo kanan Apo Dioh boy homain yan ambihaen a tao. ");
INSERT INTO abp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ket ha banwan yatew, main met maghay bawon babayi a panguoyaoy kanan uhgado. Ket ampakiiingalo ya kana, a wana, ‘Ikatulidan moko dayi kanlan kakaaway ko!’ ");
INSERT INTO abp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ha una yan nakew kanan uhgado, ket ahe naya hinaglapan. Noba ha kabuyotan nin panguoyaoy na, inihip nan uhgado ha hadili na, ‘Agya homain akon limo kanan Apo Dioh boy homain akon bega ambihaen a tao, ");
INSERT INTO abp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ket ikatulidan ko yayna yatin bawon babayi. Ta no ahe, maka humawa ako ha panguoyaoy na.’ ” ");
INSERT INTO abp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pangayadi, hinabi nan Apo Jesus, “Pakaihipen yoy hinabi nan maloke a uhgado. ");
INSERT INTO abp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta agya maloke ya, ket hinaglapan na yan teed ye bawon babayi. Hiyay Apo Dioh po nayi ye ahe managlap kanlan pinili na a mangaamot boy madeglem a ampakiiingalo kana? Paagaden na hila nayi nin mabuyot? ");
INSERT INTO abp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Habiyen ko kanyo a tampol na hilan haglapan. Noba hiko a ibat ha langit a in-Anak nin Tao, ha pag-udong ko ihti ha babe-luta, main ako lagin malatngan a ampamteg kangko?” ");
INSERT INTO abp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Haanin, main ano katao ihtew a ampangibaan a mangatoynong hilayna. Ket hiyay pamilew la kanlan kanayon, maaypa bengat. Kaya-bay hinabi nan Apo Jesus kanla yatin pangilalayi, ");
INSERT INTO abp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Main luway lakin hinumlep a makigwang ha Timplo. Hiyay magha, Pariseo ya. Ket hiyay magha met, māningil bowih. ");
INSERT INTO abp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Haanin, hiyay Pariseo, nideng ya. Ket nakigwang yan tungkol ha hadili na. Hinabi na, ‘Apo Dioh, ampahalamat ako kammo, ta aliwa kon omen kanlan tataon mānakaw, mapanyag nin maloke, māmabayi o omen kananyatin makuhit a māningil nin bowih. ");
INSERT INTO abp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ha loob nin maghay dominggo, ampikalwa kon ampagpaltan mangan boy an-ibyay koy ikamapo nin kaganaan a tapul ko.’ ” ");
INSERT INTO abp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Noba hiyay māningil nin bowih, nideng ya ha main kataangan kanlan tatao, ta angkading-ey ya. Angkading-ey yan tumangal boy andogdogen nay pagaw na a anhabiyen na, ‘Apo kon Dioh, ingalowan moko, ta magha kon māgkahalanan.’ ” ");
INSERT INTO abp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Hinabi nan Apo Jesus, “Habiyen ko kanyo a yatin māningil nin bowih, nuli yan matoynong ha pamilew nan Apo Dioh. Noba hiyay Pariseo, ahe. Ta ayaman a ampagmatagay, ket iaypa na yan Apo Dioh. Boy ayaman a ampagmaaypa, ket itagay na yan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ha maghay mangaamot, main ano kataon nangilakew nin mangakandin aanak la kanan Apo Jesus ta-omen la awoken kana a ipalonto na ye gamet na kanlan aanak boy inged. Ket hilay mānumbong na, ha nakit la hilay tataon ampangilakew nin aanak la kanan Apo Jesus, pinaghabiyan la hila. ");
INSERT INTO abp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Noba hiyay Apo Jesus, hinagyat na hilay aanak. Ket hinabi na kanlan mānumbong na, “Paolayan yo hilay mangakandin aanak a humaley kangko. Adi yo hila anhaaden, ta hilay tataon main pangugali a omen kanlan hilatin aanak ye maibilang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pakaleng-en yon manged ye habiyen ko. Ayaman a ahe ampahakop kanan Apo Dioh a omen ha pagpahakop nin makandin anak, ket ahe ya bega maibilang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Haanin, main maghay lakin mānungkolan ye nanepet kanan Apo Jesus, “Manged a Maihtodo, hinyay hukat kon diyagen ta-omen ako mabyayan nin bi-ay a homain anggaan?” ");
INSERT INTO abp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nakibat yay Apo Jesus kana, “Taket ta anhabtan mo kon manged? Hiyay Apo Dioh bengat ye manged, homain anan kanayon. ");
INSERT INTO abp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tanda moy Bibilin nan Apo Dioh, ‘Adi ka makilaki o mamabayi, adi ka mamatey nin tao, adi ka manakaw, adi ka manihtigoh nin katagowan, boy bihaen moy bapa boy indo mo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nakibat yay mānungkolan, “Kaganaan hilain a bibilin, anhumbongen koyna paibat po ha anak ako.” ");
INSERT INTO abp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pamakange nan Apo Jesus yatew, hinabi na kana, “Main po magha a hukat mon diyagen. Ilako moy kaganaan a babandi mo. Ket hiyay mapaglakoan mo, ibyay mo kanlan mangaidap. Ha wanabay, magkamain kan kabatnangan ha langit. Pangayadi, mag-udong ka ihti, ket manumbong kayna kangko.” ");
INSERT INTO abp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Noba pamakange nan mānungkolan ye hinabi nan Apo Jesus, ket nilumele ya, ta mabatnang yan tubat. ");
INSERT INTO abp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ha nakit na yan Apo Jesus a nilumele yay mānungkolan a mabatnang, hinabi na, “Koynan kaidap a maibilang ye mabatnang kanlan anhakopen nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Matataloh ya po a humlep ye maghay kamelyo ha lubot nin kadayem dinan ha maibilang ye taon mabatnang kanlan anhakopen nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Haanin, hilay nakange, tinepet la yay Apo Jesus, “No wanabay awod Apo, aya hilaynay miligtah?” ");
INSERT INTO abp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nakibat yay Apo Jesus kanla, “Hiyay ahe mapalyadi nin tao, ket mapalyadi nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ket haanin, hinabi nan Pedro, “Hikayi nayi, Apo? Ket nilakwanan mi ye kaganaan ta-omen kayi manumbong kammo.” ");
INSERT INTO abp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hinabi nan Apo Jesus kanla, “Pakaleng-en yon manged ye habiyen ko. Malabong ye matanggap yo, ta ayaman a nanlakwan nin baey na o ahawa na o kakatongno na o tutoa na o aanak na uli ha pangipatanda na nin panakop nan Apo Dioh, ");
INSERT INTO abp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ket makatanggap ya haanin met ateed a panaon nin malalabong po ha nilakwanan na. Ket ha lumateng a panaon, mabyayan ya po nin bi-ay a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Haanin, in-ilbo na hilan Apo Jesus ye labinluway mānumbong na. Ket hinabi na kanla, “Leng-en yo yatin habiyen ko. Makew kitawo haanin ha Jerusalem. Ket ihtewbay ana matupad ye kaganaan a inhulat lan popodopita hatew tungkol kangko a ibat ha langit a in-Anak nin Tao. ");
INSERT INTO abp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta maigawang ako kanlan aliwan Judio. Ket umih-umihen la kon papading-eyan, luda-ludaan, ");
INSERT INTO abp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hibladen boy pateyen. Noba ha ikatlon mangaamot, mabi-ay akon uman.” ");
INSERT INTO abp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Noba hilay mānumbong nan Apo Jesus, homain hilan natalohan ha hinabi na, ta naitayo kanla ye labay habiyen nin yatew. Kaya-bay ahe la tanda no hinyay andektan nin hinabi nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ha mahaley hilaynan Apo Jesus boy mānumbong na ha banwan Jerico, main maghay lakin kapkap a ampikno ha gilid dān a ampagpalimoh. ");
INSERT INTO abp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ha nange na hilay malabong a tataon anhumapid ha haley na, tinepet na hila, “Hinyay angkalyadi?” ");
INSERT INTO abp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hinabi lan tatao kana, “Anhumapid yay Apo Jesus a taga Nazaret.” ");
INSERT INTO abp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Haanin, nangha yay lakin kapkap, “Apo Jesus a Lahi nan Poon David, ingalowan moko!” ");
INSERT INTO abp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ket hilay tataon ampuna kanan Apo Jesus, pinaghabiyan la yay kapkap, a wanla, “Pakal-em ka!” Noba inlalo nayna ingat impangha, a wana, “Lahi nan Poon David, ingalowan moko!” ");
INSERT INTO abp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pamakange nan Apo Jesus nin pangha na, tinumgen ya. Ket hinabi na, “Ilakew yoya ihti kangko.” Ha anti yaynay kapkap ha adapan nan Apo Jesus, tinepet naya, ");
INSERT INTO abp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hinyay labay mo a diyagen ko kammo?” Nakibat yay kapkap, “Apo, labay koy makakit.” ");
INSERT INTO abp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Haanin, hinabi nan Apo Jesus kana, “Makakit kayna! Nitaah kayna uli ha pamteg mo kangko.” ");
INSERT INTO abp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ket tampol yaynan ampakakit ye laki. Ket legan anhumumbong ya kanan Apo Jesus, ampanggalang ya kanan Apo Dioh. Ha nakit lan kaganaan a tataon anti ihtew ye nalyadi, nanggalang hila met kanan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Haanin, hiyay Apo Jesus, nilumateng yayna ha banwan Jerico, ta ihtewbay ya magdān palakew ha Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ket kananyatew a banwa, main maghay lakin mabatnang a nagngalan Zaqueo. Magha ya kanlan mānguna lan māningil nin bowih. ");
INSERT INTO abp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Labay na yan makit ye Apo Jesus, noba ulita pandak ya boy malabong hilay tatao, ket ahe naya makit. ");
INSERT INTO abp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaya-bay hiyay dinyag na, nayew yan nakew ha unaan haka ya nanik ha poon-kayon anhabtan sikamoro ta-omen naya makit ye Apo Jesus a magdān. ");
INSERT INTO abp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ha niabot yaynay Apo Jesus ha eteb nan Zaqueo, ket tinangal naya boy hinabi na, “Zaqueo, padah moy lumumbah, ta katapulan koy makidagoh ha baey mo haanin.” ");
INSERT INTO abp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Haanin, hiyay Zaqueo, mapadah yan nilumumbah. Ket angkaaliket yan nananggap kanan Apo Jesus ha baey na. ");
INSERT INTO abp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kaganaan lan tataon nakakit nin pamakew na ha baey nan Zaqueo, ket naytatalabotob hila, “Yo! Nakew yan napahangaili ha maghay māgkahalanan.” ");
INSERT INTO abp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Haanin, legan ampangan hila, nideng yay Zaqueo. Ket hinabi na kanan Apo Jesus, “Apo, hiyay kagitna nin babandi ko, ibyay koyna kanlan mangaidap. Ket no main ako man nakuhit, iudong kon mikapat a ukdo kanla.” ");
INSERT INTO abp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hinabi nan Apo Jesus kana, “Haanin a mangaamot, naligtah hilaynay nagbaey. Ta yatin tao, ket namteg ya met kanan Apo Dioh a omen ha dinyag nan Abraham. ");
INSERT INTO abp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta hiko a ibat ha langit a in-Anak nin Tao, ket nakew ako ihti ha babe-luta a manapul boy mangiligtah kanlan nitaang kanan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","12","Legan anhumaley yay Apo Jesus ha banwan Jerusalem, anleng-en lan tatao ye pangiadal na. Ket ha ihip la nabaan la, a wanla, “Ha lumateng yay Apo Jesus ha Jerusalem, ket manakop yayna.” Kaya-bay in-ihtolya nan Apo Jesus kanla yatin pangilalayi, “Main maghay laki a mabatnang boy ambalayen a nakew ha mataang a lugal ta-omen na tanggapen ye katungkolan na bilang poon. Ket no matanggap naynay katungkolan na, mag-udong ya met ateed. ");
INSERT INTO abp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Noba bayo ya inumalih, impadakit na hila po ye mapo kanlan iipoh na. Ket balang magha kanla, binyanan na hilan titimaghan palata a balitok. Hinabi na kanla, ‘Legan ahe ako po, ipanapulan yo yati.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Noba kahulog la yan kalugalan na. Kaya-bay ha inumalih yayna, nangitubol hilan tatao ha lakwen na ta-omen la habiyen, ‘Hi! Ahe miya labay yatin tao a mamoon kammi.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Agya wanabay man, nadyag ya po ateed a poon. Ket ha nag-udong yayna ha lugal la, impadakit na hilay iipoh na a binyan nan palatan balitok hatew ta-omen na hila tepeten no anoy natubo nin balang magha kanla. ");
INSERT INTO abp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Haanin, hinumaley kana ye nauna. Ket hinabi na, ‘Apo, hiyay maghan palata mon balitok a in-ibyay mo kangko hatew, ket nakatubo yan mapo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Hinabi nan poon kana, ‘Manged a ipoh, manged ye dinyag mo! Ket ulita mapatayaan ka nin makandin bagay, diyagen katan māmaala nin mapo a banwa.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Haanin, hinumaley ya met kana ye ikalwan ipoh. Ket hinabi na, ‘Apo, hiyay palata mon balitok a in-ibyay mo kangko hatew, nakatubo yan lima.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Hinabi nan poon kana, ‘Manged! Diyagen katan māmaala nin limay banwa.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Haanin, hinumaley yayna met ye ikatlon ipoh kana. Ket hinabi na, ‘Apo, anti yay palata mon balitok a in-ibyay mo kangko hatew. Pinutot ko yan panyo haka ko yan inhinop, ");
INSERT INTO abp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ta angkalimo ko kammo. Tanda ko a homain kan ingalo boy ampakinabangan moy ahe mo nagbannogan boy ampamupol ka nin ahe mo intanem.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Hinabi nan poon, ‘Maloke kan ipoh! Uhgaan kata makauli ha hinabi mo. Tanda mo manayti a homain akon ingalo, ampangwa kon aliwa kon konin, boy ampamupol akon ahe ko intanem. ");
INSERT INTO abp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Taket man awod ta ahe mo imbangko ye palata kon balitok ta-omen ha pag-udong ko, ket main akon makwan tubo nin pilak ko?’ ");
INSERT INTO abp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Haanin, hinabi na kanlan tataon anti ihtew, ‘Kowen yoya kana ye palata kon balitok, ta ibyay yo kanan main mapo a palatan balitok.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Noba hinabi la kana, ‘Apo, main yaynabay mapo a palatan balitok!’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Nakibat yay poon, ‘Habiyen ko kanyo a hiyay taon mapatayaan ha makandin bagay, ket biyan ya po nin malalabong. Noba hiyay taon ahe mapatayaan, agya hiyay makandi a anti kana, ket kowen ya po kana. ");
INSERT INTO abp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ket hiyay tungkol met kanlan kaaway ko a ahe malabay pahakop kangko, ilakew yo hila ihti. Ket pateyen yo hila ha adapan ko.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pangayadi nan nag-ihtolya Apo Jesus, ket nagpahulong yayna palakew ha banwan Jerusalem a angkauna ya kanlan mānumbong na. ");
INSERT INTO abp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ha maga hilaynan miabot ye Apo Jesus ha Betfage boy Betania ha anhabtan Mapantay nin Oolibo, pinauna na hilay luway mānumbong na, ");
INSERT INTO abp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","a wana, “Makew kawo ha dongla a badiyo. Ket pamiabot yo ihtew, main kawon makit a maghay oybon ahnon nakah-el a ahe po bega nahakayan. Loaten yoya boy tengtengen yoya ihti. ");
INSERT INTO abp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No main manepet kanyo, ‘Uy! Taket ta anloaten yo yay ahno?’ habiyen yo kana, ‘Matapul na yan Apo.’ ” ");
INSERT INTO abp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Haanin, nakew hilaynay luway mānumbong na ha badiyon hinabi nan Apo Jesus. Ket nakit la yan peteg ye oybon ahno a nakah-el. ");
INSERT INTO abp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ket ha anloaten la yayna, tinepet na hilan nagkonin, “Uy! Taket ta anloaten yo yay oybon ahno?” ");
INSERT INTO abp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nakibat hila, “Matapul na yan Apo.” ");
INSERT INTO abp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Haanin, tinengteng la yay oybon ahno kanan Apo Jesus. Ket ha niabot hilayna kana, in-apay lay kepkep la ha golot nin oybon ahno haka laya pinahakay ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Legan nakahakay yay Apo Jesus ha ahno palakew ha banwan Jerusalem, hilay tatao, an-iamlak lay kekepkep la ha pagdanan na. ");
INSERT INTO abp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ha mahaley yaynay Apo Jesus ha palohan nin Mapantay nin Oolibo, hilay kaganaan a mānumbong na, ingkana laynay pangipangha nin aliket boy panggalang la kanan Apo Dioh uli ha kaganaan a nakit la a kapagtakaan a dinyag na. ");
INSERT INTO abp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","An-ipapangha la, a wanla, “Inged na yan Apo Dioh ye poon a anlumateng ha ngalan na! Main katanaan ha langit! Galangen yay Apo Dioh a anti ha langit!” ");
INSERT INTO abp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Haanin, hilay nangaanon Pariseo a nakihale kanlan malabong a tataon anhumumbong kanan Apo Jesus, hinabi la kana, “Maihtodo, patgenen mo hila man ye mānumbong mo.” ");
INSERT INTO abp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nakibat yay Apo Jesus, “Habiyen ko kanyo a no pakal-em hila, hilayatin dadapah ye mangha nin panggalang kangko.” ");
INSERT INTO abp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ha mahaley yaynay Apo Jesus ha banwan Jerusalem boy angkatamulaw nayna, tinangihan na hilay tatao ihtew, ta angkalunoh ya kanla. ");
INSERT INTO abp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hinabi na, “Kakaingalo kawon angkumonin ha Jerusalem. No nabalayan yon bengat ye makaibyay kanyon katanaan, agkawo dayin kakaingalo! Noba ahe yo nabalayan. ");
INSERT INTO abp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lumateng lano ye panaon a kobkoben la kawo nin kakaaway yo boy liktopen la kawon dawohongen. ");
INSERT INTO abp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hipeten la kawo boy damaen lay banwa yo. Homain lanon bega mabantak a dadapah a naypalingping. Madihaan yo yatin kaganaan, ta ahe yoya imbabano ye panlumateng nan Apo Dioh a mangiligtah kanyo!” ");
INSERT INTO abp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Haanin, hiyay Apo Jesus, nakew ya ha mahlang nin Timplo. Ket intaboy na hilay ampaglako. ");
INSERT INTO abp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hinabi na, “Hiyay naihulat a Habi nin Dioh, ‘Hiyay baey ko, ket baey pamakigwangan.’ Noba dinyag yo yan payngikbengan nin mānakaw!” ");
INSERT INTO abp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Paibat kananyatew, minamangaamot yaynan ampangiadal ha mahlang nin Timplo ye Apo Jesus. Noba hilay mānguna a papadi, mamaihtodo nin Bibilin boy hilay mānungkolan, labay la yan maipapatey ye Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Noba ahe la madyag, ulita kalalabay lan leng-en tatao ye pangiadal na. ");
INSERT INTO abp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ha maghay mangaamot, legan ampangiadal yay Apo Jesus kanlan tatao ha mahlang nin Timplo boy an-ipatanda nay Manged a Balita, hinaleyan la yan mānguna a papadi boy mamaihtodo nin Bibilin a lamo la hilay tutoan Jujudio a mānungkolan. ");
INSERT INTO abp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Haanin, hinabi la kana, “Hika! Habiyen mo man kammi no hinyay katulidan mon manyag nin didinyag mo naapon. Ayay namyay kammo nin katulidan?” ");
INSERT INTO abp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nakibat yay Apo Jesus, “Tepeten katawo met. Habiyen yo man kangko ");
INSERT INTO abp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","no ayay namyay kanan Juan nin katulidan a mamawtihmo? Hiyay Apo Dioh o tao?” ");
INSERT INTO abp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ket pinaytongtongan la, a wanla, “No habiyen tawo a hiyay Apo Dioh, ket habiyen na met kantawo, ‘Taket awod ta ahe yoya pinamtegan?’ ");
INSERT INTO abp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Noba no habiyen tawo a tao, ket tataponen la kitawon dadapah hilatin malabong a tao, ta ampamtegan la a hiyay Juan, ket podopita na yan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaya-bay hinabi la, “Ahe mi tanda.” ");
INSERT INTO abp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hinabi na met Apo Jesus kanla, “No wanabay awod, ahe ko met habiyen kanyo no ayay namyay kangko nin katulidan a manyag nin andyagen ko.” ");
INSERT INTO abp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Haanin, in-ihtolya nan Apo Jesus kanlan tatao ye maghay pangilalayi, “Main maghay laki a nananem nin ubah ha pananeman na. Pangayadi, pinaabangan nay ubahan na kanlan māmakitalon, ta makew ya ha mataang a lugal. Ket kumonin ya ihtew nin mabuyot a panaon. ");
INSERT INTO abp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ha panaon anan pamupol nin ubah, nangitubol yan maghay ipoh na a mangwa nin dakay na kanlan māmakitalon. Noba hiyay ipoh, ket binabadog la yan māmakitalon haka la yan pinaalih a homain kaget. ");
INSERT INTO abp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Haanin, nangitubol yayna man nin kanayon a ipoh na. Noba binogbog laya met ateed boy pinading-eyan laya haka la yan pinauli a homain kaget. ");
INSERT INTO abp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ket haanin, intubol naya po ye kakatlon ipoh na. Noba hinugat-hugatan laya haka laya intaboy. ");
INSERT INTO abp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kaya-bay nangihip yay nagkonin nin ubahan, ‘Hinya lagi ye diyagen ko? Ah! Itubol ko yay ampakaadoen kon anak. Kadihko bihaen laya.’ ” ");
INSERT INTO abp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Noba ha natamulaw la yan māmakitalon ye anak na a andumaho, hinabi la, ‘Anti yaynay manawid! Pateyen tawo ya ta-omen tawo mapagkonin ye tawiden na.’ ");
INSERT INTO abp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kaya-bay hiyay dinyag la kana, dinakep la yan ingguloy a pinatey ha ilwah nin ubahan.” Haanin, nanepet yay Apo Jesus, “Hinya lagi ye diyagen nan nagkonin nin ubahan kanlan māmakitalon? ");
INSERT INTO abp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Homain hapo a lakwen na hilan pateyen. Pangayadi, ipaabang nayna ha kanayon ye ubahan na.” Pamakange lan tatao nin hinabi nan Apo Jesus, hinabi la, “Ahe na dayin ipaluboh Apo Dioh a malyadi yatew.” ");
INSERT INTO abp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Noba hiyay Apo Jesus, pinakabilew na hilay tatao haka na hinabi kanla, “No wanabay ye ihip yo, hinya awod ye labay habiyen nin yatin naihulat a Habi nin Dioh? ‘Hiyay dapah a ingkahwil lan māmaideng nin baey, hiyabay ye ginawi a pundahyon nin baey.’ ” ");
INSERT INTO abp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hinabi na po Apo Jesus, “Ayaman a maampag kananyain a dapah, mapha ya. Ket ayaman a maondagan na, ket matamek ya.” ");
INSERT INTO abp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Haanin, natalohan lan mamaihtodo nin Bibilin boy mānguna a papadi a hilabay ye andektan nin pangilalayi nan Apo Jesus. Kaya-bay kananyatew met ateed, labay la yayna dayin dakpen. Noba angkalimo hila kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kaya-bay nangagad hilan mamanged a panaon. Haanin, nangupa hilan ano kataon manepet kanan Apo Jesus a konwadi manged ye tikih la kana. Ta labay la yan kaloten ha hahabi na ta-omen laya maidalom kanan Gobilnadol. ");
INSERT INTO abp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ket hilatin inupaan la, hinabi la kana, “Maihtodo, tanda mi a huhto ye kaganaan a anhabiyen mo boy an-iadal mo. Homain kan antupigan a tao boy hiyay kaptegan tungkol ha kalabayan nan Apo Dioh ye an-iadal mo kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Haanin, main kayin tepet kammo. Ha ihip mo, huhto laweh a mamayad kitawon bowih ha Emperador nin Roma o ahe?” ");
INSERT INTO abp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Noba tanda nan Apo Jesus a ampagkonwadi hilan bengat. Kaya-bay hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Gawangan yoko man nin palatan Roma.” Ket ha ginawangan la yan palata, tinepet na hila, “Ayay naglupa boy nagngalan ye nakadokit ihti?” “Hiyay Emperador Cesar,” wanla. ");
INSERT INTO abp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Haanin, hinabi nan Apo Jesus kanla, “No wanabay awod, hiyay kanan Emperador Cesar, ibyay yo kana. Ket hiyay kanan Apo Dioh, ibyay yo met kana.” ");
INSERT INTO abp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ahe laya nakalot ye Apo Jesus ha hinabi na ha adapan lan tatao. Ket uli ha pagtaka la ha pakibat na, napakal-em hila. ");
INSERT INTO abp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Haanin, main anoy Saduseo ye hinumaley a manepet kanan Apo Jesus. Hilabay ye pangkat nin tatao a ahe ampamteg a mabi-ay uman ye nangamatey. ");
INSERT INTO abp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hinabi la kanan Apo Jesus, “Maihtodo, hiyay anti ha Bibilin a impahulat kanan Moises, wanae ya, ‘No matey yay ahawan laki, ket ahe ya nagkaanak kanan ahawa na, katapulan a ikahal nin katongno nan laki ye bawo. Ket no magkaanak hila, maibilang yan anak nin katongno na a natey.’ ");
INSERT INTO abp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Haanin, main pitoy lalaki a mikakatongno. Hiyay punganay, nangahawa ya. Noba natey yan ahe nagkaanak kanan ahawa na. ");
INSERT INTO abp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ket hiyay ikalwa, inahawa na yay ipag na a bawo. Noba natey ya met ateed a ahe nagkaanak. ");
INSERT INTO abp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wanabay met ateed ye nalyadi ha ikatlo. Natey ya met ateed a ahe nagkaanak kana. Kaganaan hilatin mikakatongno, napag-ahawa la yay ipag la, noba ahe hila nagkaanak kana. ");
INSERT INTO abp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ha kalinghuyotan, natey ya met ye babayi. ");
INSERT INTO abp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haanin, wanae ye tepet mi kammo, ‘Ha panaon a mabi-ay uman ye nangamatey, aya lagi kanlan pitoy mikakatongno ye ahawa nan babayi, ta napag-ahawa na hilan kaganaan?’ ” ");
INSERT INTO abp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nakibat yay Apo Jesus kanla, “Hilay tatao haanin, ket ampangahawa hila. ");
INSERT INTO abp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Noba lano ha lumateng a panaon, hilay pinili nan Apo Dioh a bi-ayen nan uman a mapagkalamo na ha langit, ket ahe hilayna mangahawa. ");
INSERT INTO abp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ahe hilayna met matey a omen kanlan aanghil. Aanak na hilan Apo Dioh, ta bini-ay na hilan uman. ");
INSERT INTO abp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Agya hiyay Moises, ket ampaptegan na met a mabi-ay uman ye nangamatey. Ta hiyay hulat na tungkol ha mahipok a poon-kayon andumlag, hinabtan na yay Apo Dioh a ‘Dioh nan Abraham, Dioh nan Isaac, boy Dioh nan Jacob.’ ");
INSERT INTO abp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hiyay labay habiyen, angkabi-ay hila po, ta hiyay Apo Dioh, ket Dioh nin angkabi-ay, aliwan nangamatey. Ta ha pamilew nan Apo Dioh, ket angkabi-ay ye kaganaan a tatao.” ");
INSERT INTO abp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Haanin, hinabi nin anoy mamaihtodo nin Bibilin, “Maihtodo, manged ye pakibat mo.” ");
INSERT INTO abp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ket paibat ana kananyatew, homain anan bega nagngaya a manepet kana. ");
INSERT INTO abp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Haanin, tinepet na hila met Apo Jesus, “Way-omen lan mahabi nin tatao a hiyay Cristo, ket lahi na yan Poon David? ");
INSERT INTO abp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta hiyaynabay met Poon David ye nangihabi ha libdon Kakanta nin wanae tungkol kanan Cristo, ‘Hinabi nan Apo Dioh kanan Apo ko, “Mikno ka ha dapit wanan ko ");
INSERT INTO abp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","angga ha mapahuko ko hila kammo ye kakaaway mo.” ’ ” ");
INSERT INTO abp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Haanin, hinabi nan Apo Jesus, “No hiyay Poon David ket hinabtan na yan Apo ye Cristo, way-omen la yan mahabi nin tatao a lahi na yan bengat nin David ye Cristo?” ");
INSERT INTO abp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Legan ampanlenge hilay kaganaan a tatao kanan Apo Jesus, hinabi na kanlan mānumbong na, ");
INSERT INTO abp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-alla kawo kanlan mamaihtodo nin Bibilin. Kalalabay lay magpahyal a nakahoot nin makadang a tapih ta-omen la ihipen nin tatao a mangatoynong hilan tatao. Kalalabay la met ye maidlaw nin tataon angkadanan la boy kalalabay la po ye mikno ha pamiknoan a nakataladan kanlan mangadangal a tatao ha pāytiponan lan Jujudio boy ha poniyan. ");
INSERT INTO abp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ampaglanganan la hilay bawon babayi. Ampagmamangedan hila ha adapan lan malabong a tatao makauli ha makadang a pakigwang la. Kaya-bay mamabyat lano ye ipaduha nan Apo Dioh kanla.” ");
INSERT INTO abp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Legan anti ya po ye Apo Jesus boy hilay mānumbong na ha mahlang nin Timplo, nakit na hilay mangabatnang a ampangitukoy nin pilak ha pangitukoyan nin pilak a magawi ha Timplo. ");
INSERT INTO abp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ket nakit naya met ye maghay maidap a bawon babayi a nangitukoy nin luway palatan tanho. ");
INSERT INTO abp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hinabi nan Apo Jesus kanlan mānumbong na, “Pakaleng-en yon manged ye habiyen ko. Hiyay intukoy nan maidap a bawon babayi, ket maiigit ya dinan ha intukoy lan kaganaan. ");
INSERT INTO abp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta hiyay intukoy lan kaganaan a mangabatnang, ket hiyay ahe layna minga katapulan ha bi-ay la. Noba hiyay maidap a bawon babayi, ket inlumpoh nan intukoy ye ikabi-ay na.” ");
INSERT INTO abp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Haanin, hilay nangaanoy mānumbong nan Apo Jesus, ampaytotongtongan lay tungkol ha Timplo nan Apo Dioh. Anhabiyen la, “Kangaada ye mangablin dadapah a ginawi la ha Timplo boy hiyay indigalo lan tatao a in-aalkoh la ha lingling.” Pamakange nan Apo Jesus ye ampaytongtongan la, hinabi na kanla, ");
INSERT INTO abp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Hilain a mangaada a angkakit yo, lumateng lanoy panaon a mangaagwat hilan kaganaan. Ket homain lanon bega mabantak a naypalingping a dadapah.” ");
INSERT INTO abp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nanepet hilay mānumbong nan Apo Jesus kana, “Maihtodo, makano ya lumateng yain a panaon a hinabi mo boy hinyay pagkakitan no madanon anan malyadi?” ");
INSERT INTO abp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nakibat yay Apo Jesus kanla, “Mag-alla kawo ta-omen la kawo ahe matalingo nin agya ayaman. Ta malabong hila lanoy lumateng a manggawi nin ngalan ko, a wanla, ‘Hiko ye Cristo a impangako nan Apo Dioh!’ Boy habiyen la po, ‘Nilumateng anay kalampuhan nin panaon!’ Adi yo hila ampamtegan, ta aliwan peteg yatew. ");
INSERT INTO abp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kaya-bay no mangean yoynay gubat boy paylalaban, ket adi kawo angkalimo. Ta katapulan a malyadi hilatew, noba aliwa po yain ye kalampuhan nin babe-luta.” ");
INSERT INTO abp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Haanin, hinabi na po Apo Jesus kanla, “Maygugubat lano ye nanahyon boy wanabay met ye papanakopan. ");
INSERT INTO abp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kananyatew a panaon, manlayon nin mangakhaw ha nakahinadi a lulugal. Magkamain nin bitil boy mitayak ye hahakit a makapatey ha nakahinadi a lulugal. Ket makakit kawo lanon ampakalilimo boy kapagtakaan a pagkakitan a ibat ha langit.” ");
INSERT INTO abp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Noba bayo ya lumateng yatew a panaon, ket dakpen la kawo boy ipaloke uli ha panumbong yo kangko. Ilakew la kawo lano kanlan mānungkolan ha pāytiponan lan Jujudio ta-omen la kawo litihen boy ipapidiho. Iadap la kawo kanlan popoon boy kanlan gogobilnadol. ");
INSERT INTO abp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ket yabaytew yaynay panaon yo a mangipapteg kanla nin tungkol kangko. ");
INSERT INTO abp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Itanem yo ha ihip yo a adi yo angkahindakan no way-omen yo ikatulidan ye hadili yo. ");
INSERT INTO abp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ta ipaihip ko lano kanyo ye huhton habiyen yo boy biyan katawon kadunongan a ahe la mababa a kuntadaen o hamboten nin kakaaway yo. ");
INSERT INTO abp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Lano agya hilay tutoa yo boy kakatongno yo, hilay papaltido yo boy hilay gagayyem yo, ket hila met ateed ye mangiopit boy mangipapatey nin nangaano kanyo. ");
INSERT INTO abp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ket uli ha panumbong yo kangko, pag-inakitan la kawon kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Noba adi kawo angkalimo. Ta agya maghay labok nin ō yo, ket homain mikatak. ");
INSERT INTO abp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ket no mateeh yo, mabyayan kawon bi-ay a homain anggaan.” ");
INSERT INTO abp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hinabi na po Apo Jesus ye malyadi lano ha Jerusalem, “No makit yo yaynan naliktop nin huhundaloh ye banwan Jerusalem, tanda yoynan madanon anay pagkadama nin banwa. ");
INSERT INTO abp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kananyatew a panaon, hilay anti ha plobinhiyan Judea, katapulan laynan tumakah palakew ha mamapantay. Ket hilay anti ha loob nin banwan Jerusalem, katapulan laynay umalih. Ket hilay anti ha ilwah nin yatew a banwa, ahe hilaynan mag-udong ihtew. ");
INSERT INTO abp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta yabaytew anay panaon nin pamaduha nan Apo Dioh ta-omen matupad ye naihulat a Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kananyatew a mangaamot, kakaingalo hilay mangabuktot boy hilay iindo a ampamahoho, ta maidapan hilan mayew. Magkamain nin tubat a kaidapan kananyatin lugal uli ha tubat a poot nan Apo Dioh kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Main matey nin keya. Ket hilay kanayon met, dakpen la hilan ilakew ha mataang a lulugal. Ket hiyay banwan Jerusalem, hakopen lan aliwan Judio anggan mayadi ye panaon a intaning nan Apo Dioh a panakop la.” ");
INSERT INTO abp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hinabi na po Apo Jesus, “Makakit kawo lanon kapagtakaan a pagkakitan ha mangaamot, bowan, boy ha bibitoen. Kaganaan a nanahyon ihti ha babe-luta, ket mahindakan hila boy mapaygulo-gulo uli ha heneg boy mangatagay a dawyon ha dagat. ");
INSERT INTO abp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hilay tatao ket mangabatang uli ha angkalyadi ha babe-luta. Ta eyegen nan Apo Dioh ye kaganaan a anti ha lowang anggayna ha mapaywahag-wahag hilayna. ");
INSERT INTO abp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kananyatew met ateed a panaon, hiko a ibat ha langit a in-Anak nin Tao, ket makit la kon anti ha owep a an-umaypa a main kapalyadiyan boy tubat a kahnagan. ");
INSERT INTO abp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","No mandugi hilaynan malyadi hilatin babagay, mideng kawon tumangal, ta madanon anay pangiligtah nan Apo Dioh kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","In-ihtolya nan Apo Jesus kanla ye maghay pangilalayi, “Bilewen yoy poon-kayon igoh boy hilay kanayon po a poon-kayo. ");
INSERT INTO abp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No tumbek yaynay bayon bōng ha hahanga na, tanda yoyna a madanon anay kaingitan. ");
INSERT INTO abp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wanabay met ateed lano. No makit yoynan angkalyadina yatin anhabiyen ko, tanda yoyna a madanon anay panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Pakaleng-en yon manged ye habiyen ko. Bayo hila po matey ye kaganaan a tataon angkabi-ay kananyatin panaon, matupad ana hilatin kaganaan a hinabi ko. ");
INSERT INTO abp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hiyay lowang boy babe-luta, ket maanam ya. Noba hilay hahabi ko, ket mikakaanti yan makanoman.” ");
INSERT INTO abp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hinabi na po Apo Jesus, “Lumateng lanoy panaon a mioblak akon mag-udong ihti ha babe-luta. Kaya-bay mag-alla kawo, ta maka malmaw kawo ha palugad a pagbi-ay, paglahing boy ha kaabalaan ha kapanapulan. No wanabay, malatngan katawon ahe nakahadya ");
INSERT INTO abp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","a omen ha taon nakalot. Ta kananyatew a panaon, maoblakan ha panlumateng ko ye kaganaan a tataon angkabi-ay ihti ha babe-luta. ");
INSERT INTO abp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaya-bay lanang kawon nakahadya. Ipakigwang yo a magkamain kawon kinhawan ta-omen yo maligtahan ye kaganaan a kaidapan a malyadi lano boy makaadap yoko a ibat ha langit a in-Anak nin Tao a homain kawon man-ikading-ey.” ");
INSERT INTO abp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hiyay Apo Jesus, minamangaamot yan ampakew mangiadal ha mahlang nin Timplo. Noba ha madeglem, hiya boy hilay mānumbong na, ampakew hila ha Mapantay nin Oolibo. Ket ihtew hilayna matuloy. ");
INSERT INTO abp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ket ha mahanibhanib po, hilay kaganaan a tatao, ampakew hilayna ha mahlang nin Timplo ta-omen hila manlenge kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kananyatew, madanon anay Pihta nin Tinapay a Homain Pamalbag a anhabtan met Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hilay mānguna a papadi boy hilay mamaihtodo nin Bibilin, ket ampangihip hilan papadan no way-omen laya maipapatey ye Apo Jesus a homain bega kanayon a makatanda, ta angkalimo hila kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hiyay Judas a anhabtan Iscariote, magha ya kanlan labinluway mānumbong nan Apo Jesus, noba hinelpan na yan Satanas. ");
INSERT INTO abp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ket hiyay Judas, nakew ya kanlan mānguna a papadi boy kanlan mānguna lan gowaldiya ha Timplo. Ket in-ihtolya na kanla no way-omen naya iopit ye Apo Jesus kanla. ");
INSERT INTO abp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ket naaliket hila boy impangako la kana a biyan la yan pilak. ");
INSERT INTO abp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ket inawo naya met Judas. Kaya-bay impaibat ana kananyatew, ampangagad yayna nin panaon a mahaglapan na hilan mandakep kanan Apo Jesus a homain kanayon a makatanda. ");
INSERT INTO abp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Haanin, naabot anay unan mangaamot nin Pihtan Tinapay a Homain Pamalbag. Kananyain a mangaamot, hilay Jujudio, katapulan lay manapo nin oybon tupa a kena la ha Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kaya-bay hiyay Apo Jesus, intubol na yay Pedro boy Juan, a wana, “Makew kawon mangitaladan nin pandeman tawo ha Pihtan Pangihipan nin Pangiligtah.” ");
INSERT INTO abp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nanepet yay Pedro boy Juan kana, “Way-ihtew kayi mangitaladan nin pandem?” ");
INSERT INTO abp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nakibat yay Apo Jesus kanla, “Makew kawo ha banwan Jerusalem. Ket makahagana kawon maghay lakin ampangaget nin halaw a main lanom. Humbongen yoya ha baey a looben na. ");
INSERT INTO abp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ket habiyen yo kanan nagbaey, ‘An-ipatepet nan Maihtodo no way-ihtew ye hilid a malyadi nan pandeman ha Pihtan Pangihipan nin Pangiligtah a kadungo na hilay mānumbong na.’ ");
INSERT INTO abp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ket ipakit na kanyo ye maghay maway a hilid ha tagay a main anan nakataladan a kahangkapan. Ihtewbay kawo mangitaladan nin pandeman tawo.” ");
INSERT INTO abp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Haanin, ha inumalih hilaynan Pedro boy Juan, nakit lay kaganaan a omen ha hinabi nan Apo Jesus kanla. Ket intaladan lay pandeman la ha Pihtan Pangihipan nin Pangiligtah. ");
INSERT INTO abp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ha odah anan pandem, hiyay Apo Jesus boy hilay aapohtol na, ket dinumongo hilaynan mangan ha lamihaan. ");
INSERT INTO abp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Haanin, hiyay Apo Jesus, hinabi na kanla, “Angkahabekan katawon mapagkadungon mangan nin yatin pandem ha Pihtan Pangihipan nin Pangiligtah bayo ko magdiha nin pamaidap. ");
INSERT INTO abp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta ahe akoyna mangan uman nin omen yatin pandem angga ha matupad ye labay habiyen nin yati ha panakop nan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Haanin, hiyay Apo Jesus, nangwa yan maghay bahon alak ubah, ket pinahalamatan naya kanan Apo Dioh. Pangayadi, hinabi na kanla, “Kowen yo yati, ket paytitikandiyan yon inomen. ");
INSERT INTO abp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta anhabiyen ko kanyo a paibat haanin, ket ahe akoynan minom uman nin yati anggan ahe ya po manakop ye Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Haanin, nangwa yan tinapay. Ket pinahalamatan naya kanan Apo Dioh. Pangayadi, binih-ilbih-il na haka na inggawang kanlan mānumbong na, a wana, “Yatin tinapay ye pinagkalaman ko a an-ihagpa ko ha ikanged yo. Diyagen yo yati bilang pangihipan kangko.” ");
INSERT INTO abp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pangayadi lan nangan, wanabay met ateed ye dinyag na ha bahon main laman a alak. Ket hinabi na kanla, “Yatin alak ye pinagkadaya ko a mibuhboh ha ikanged yo. Yati ye pamapteg nin bayon kahundoan nan Apo Dioh ha tao.” ");
INSERT INTO abp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hinabi na po Apo Jesus, “Noba pakaleng-en yo! Hiyay taon mangiopit lano kangko, ket anti ya ihtin kadungo ko! ");
INSERT INTO abp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta hiko a ibat ha langit a in-Anak nin Tao, ket intaning nin Dioh a matey. Noba kakaingalo yay taon mangiopit kangko!” ");
INSERT INTO abp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pamakange lan mānumbong na, napaytepet-tepet hila, “Yo! Aya lagi kantawo ye mangiopit kana?” ");
INSERT INTO abp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Haanin, hilay mānumbong na, pinayngatngatan la no aya kanlay maibilang a pinakamatagay. ");
INSERT INTO abp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Hinabi nan Apo Jesus kanla, “Hi! Aliwan huhto ye ihip yo. Hilay aliwan Judion mānungkolan, ket an-ipilit lay labay la kanlan tataon angkahakopan la boy labay lay pagalang boy habtan hilan tatao a ‘Mapanaglap’. ");
INSERT INTO abp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Noba hikawo, aliwan wanabay, ta ayaman a pinakamatagay, ket katapulan yan magmakaaypa boy ayaman a malabay manguna, katapulan a maghilbi ya. ");
INSERT INTO abp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ha ihip yo, ayay matatagay? Hiyay taon ampaghilbiyan pamangan o hiyay taon ampaghilbi? Hiyay ampaghilbiyan pamangan, kali? Noba hiko, agya po man Apo yoko, ket ampaghilbiyan katawo.” ");
INSERT INTO abp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ha nadihaan koy papanubok, ket nikakaanti kawon lamo ko. ");
INSERT INTO abp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ket haanin, ulita binyan na kon Bapa ko nin kapalyadiyan a mamoon, ambiyan katawo met nin wanabay a kapalyadiyan. ");
INSERT INTO abp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Diyagen ko yati ta-omen katawo makadungo lano a mangan boy minom ha lamihaan ko ha panakopan ko. Boy mikno kawo ha pamiknoan a mamoon kanlan labinluwan lalahi nin Israel.” ");
INSERT INTO abp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Haanin, hinabi nan Apo Jesus kanan Simon a anhabtan Pedro, “Simon, leng-en mon manged yatin habiyen ko! Hiyay Satanas, nakikwa yan paluboh kanan Apo Dioh a huboken na kawon kaganaan a omen ha pamalohboh ilik. ");
INSERT INTO abp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noba impakigwang kata, Simon, ta-omen ahe maanam ye pamteg mo kangko. Ket lano ha maghehe kayna boy mag-udong kangko, pakhawen moy pamteg lan lamo mon māmteg.” ");
INSERT INTO abp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hinabi nan Simon Pedro, “Apo, nakahadya akon makilakew kammo ha pidihowan o matey a lamo mo.” ");
INSERT INTO abp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Noba hinabi nan Apo Jesus kana, “Pedro, pakaleng-en mon manged ye habiyen ko kammo. Papainghan ha madeglem, bayo ya tumnoy ye tandang, nikatlo mo koynan imbudi.” ");
INSERT INTO abp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Haanin, hinabi nan Apo Jesus kanlan mānumbong na, “Ha intubol katawon homain kaget a pilak, pahiking boy ihtiping, ahe kawo nagkulang nin hinyaman a bagay, kali?” Nakibat hila, “Awo, Apo.” ");
INSERT INTO abp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hinabi nan Apo Jesus kanla, “Noba haanin, no main kawon pitaka o pahiking, katapulan yoynan kadten. Ket no homain kawon keya, ilako yoy bado yo. Ket manaliw kawon keya. ");
INSERT INTO abp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta habiyen ko kanyo a katapulan a matupad ye impahulat nan Apo Dioh tungkol kangko, a wanae, ‘Imbilang la yan magha kanlan mapanlabag nin Bibilin,’ ket angkatupad ana haanin.” ");
INSERT INTO abp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hinabi lan mānumbong na, “Apo, bilewen mo! Main kayin luway keya ihti!” “Huhtoyna yain,” wanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Haanin, hiyay Apo Jesus, nakew ya ha Mapantay nin Oolibo, ta wanabay ye nakailmawan na. Ket hilay mānumbong na, nakilakew hila met kana. ");
INSERT INTO abp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pamiabot la ihtew, hinabi nan Apo Jesus kanlan mānumbong na, “Makigwang kawo ta-omen kawo ahe mahambot nin tukho.” ");
INSERT INTO abp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Haanin, hiyay Apo Jesus, tinumaang yan makandi kanla haka yan nanalimukod nakigwang, a wana, ");
INSERT INTO abp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapa ko, no kalabayan mo, alihen mo yatin pamaidap a dihaen ko. Noba aliwan kalabayan ko ye mahumbong, no aliwan hiyay kalabayan mo.” ");
INSERT INTO abp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Haanin, napakit ya kana ye anghil a ibat ha langit, ket pinakhaw nay nakem nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ket ulita angkalelean yaynan tubat ye Apo Jesus, lalo yaynan nakigwang nin luboh anggaynan nanaynget yan ba-mon daya a tinumulo ha luta. ");
INSERT INTO abp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pangayadi nan nakigwang, nakew yayna man kanlan mānumbong na. Ket nalatngan na hilan angkatuloy, ta linumopta hila ha kalelean la. ");
INSERT INTO abp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hinabi nan Apo Jesus kanla, “Taket ta angkatuloy kawo? Mimata kawo boy makigwang ta-omen kawo ahe mahambot nin tukho.” ");
INSERT INTO abp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Legan ampaghabi ya po ye Apo Jesus, nilumateng ye malabong a tatao. Ket hiyay Judas a magha kanlan labinluwan mānumbong na ye ampanguna kanla. Hinumaley ya kanan Apo Jesus. Ket inumaan naya. ");
INSERT INTO abp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Noba hinabi nan Apo Jesus kana, “Judas, uma nayi ye pangiopit mo kangko a ibat ha langit a in-Anak nin Tao?” ");
INSERT INTO abp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ha naimatonan lan mānumbong na a lumbo anay malyadi, hinabi la kanan Apo Jesus, “Apo, manaya kayina laweh?” ");
INSERT INTO abp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Haanin, hiyay maghay mānumbong nan Apo Jesus, tinaya na yay maghay ipoh nin pinakapoon a padi. Ket napunggohan ye dapit wanan a talinga na. ");
INSERT INTO abp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Noba hinabi nan Apo Jesus, “Huhtoyna yain!” Haanin, hinaleyan na yay ipoh. Ket ginep-an nay talinga na. Ket pinaitaah naya. ");
INSERT INTO abp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hinabi nan Apo Jesus kanlan mānguna a papadi, kanlan kakapitan lan gowaldiya ha Timplo boy kanlan tutoan Jujudio a mānungkolan, “Tolihan ako nayi, ta impangaget yo kon keya boy pamadog? ");
INSERT INTO abp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Minamangaamot akon anti kanyo ha mahlang nin Timplo. Taket ta ahe yoko dinakep ihtew? Noba yati ye panaon a naibyay kanyo ta-omen yo koyna dakpen, ta hiyay kapalyadiyan nan Satanas ye ampamatige kanyo.” ");
INSERT INTO abp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Haanin, dinakep la yay Apo Jesus. Ket inlakew laya ha baey nin pinakapoon a padi. Hiyay Pedro, anhumumbong ya ha aliwan minga mataang. ");
INSERT INTO abp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ihtew ha bunak mahlang nin yatew a baey, namadlag hilay tatao nin apoy. Ket nikno hilan nimodo ha palibot nin apoy. Ket hiyay Pedro, nikno ya met a nakiimodo kanla. ");
INSERT INTO abp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Haanin, ha napaliwagan ye lupa nan Pedro, nabalayan yan maghay babayin ipoh ihtew. Ket pinudek naya, a wana, “Yatin laki, kalamo naya met Jesus.” ");
INSERT INTO abp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Noba hinabi nan Pedro, “Yo! Ahe koya katatanda yain a tao.” ");
INSERT INTO abp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ha ahe nabuyot, main ana man maghay nakakit kana. Ket tinepet naya, “Magha ka met kanlan kalalamoan na, kali?” Noba nakibat yay Pedro, “Hi, ahe!” ");
INSERT INTO abp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pangalabah nin maghay odah, an-ipilit na met nin magha kanla, “Peteg a yatin tao, kalamo na yan Jesus, ta taga Galilea ya met!” ");
INSERT INTO abp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Noba hinabi nan Pedro, “Hi, ahe ko tanda ye anhabiyen mo.” Legan ampaghabi ya po, tinumnoy yay tandang. ");
INSERT INTO abp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Haanin, hiyay Apo Jesus, nagpeyeh yan namilew kanan Pedro. Ket hiyay Pedro, naihipan nay hinabi nan Apo Jesus kana a wanae, “Papainghan ha madeglem, bayo ya tumnoy ye tandang, nikatlo mo koynan imbudi.” ");
INSERT INTO abp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ket hiyay Pedro, inumalih ya ha mahlang. Ket tinumangih yan malaem. ");
INSERT INTO abp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Haanin, hiyay Apo Jesus, an-umihen boy ambadogen la yan ampagbantay kana. ");
INSERT INTO abp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pinedengan laya haka la yan dinihmog. Hinabi la kana, “Pal-eban mo man kammi no ayay nandihmog kammo!” ");
INSERT INTO abp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Boy mikalabong la yan inumih-umih. ");
INSERT INTO abp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kabekahan, naytitipon hilay tutoan Jujudio a mānungkolan ha Panuhgaan lan Jujudio. Hilay ano kanla, ket mamaihtodo nin Bibilin boy hilay kanayon met, mānguna a papadi. Haanin, hiyay Apo Jesus, naiadap ya kanla. ");
INSERT INTO abp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hinabi la kana, “No hika ye Cristo a impangako nan Apo Dioh, habiyen mo kammi.” Nakibat yay Apo Jesus, “Agya po man habiyen ko kanyo, ahe yoko met ateed pamtegan. ");
INSERT INTO abp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ket no tepeten katawo, ahe yoko met pakibatan. ");
INSERT INTO abp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Noba paibat haanin, hiko a ibat ha langit a in-Anak nin Tao, mikno akoyna ha dapit wanan nan Makapalyadiyan a Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Haanin, hilay kaganaan a mānungkolan, hinabi la kana, “No wanabay awod, anhabiyen mo a hika ye Anak nan Apo Dioh?” Nakibat yay Apo Jesus, “Hikawoynabay met ye ampaghabi a hikobay.” ");
INSERT INTO abp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Haanin, hinabi la, “Nange tawoyna! Hiyayna ye naghabi a Anak yan Dioh. Kaya-bay ahe tawoyna katapulan nin kanayon po a mamapteg!” ");
INSERT INTO abp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Haanin, hilay mānungkolan a napaytipon, nideng hilan kaganaan. Ket inlakew la yan in-adap ye Apo Jesus kanan Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ket ingkana laynan hinabi ye pamada la kana. Hinabi la kanan Gobilnadol Pilato, “Yatin tao, nadulanan mi yan ampangumbinyo nin tatao a kumuntada ha gobilno. Anhabiyen na, ‘Adey kawoynan mamayad nin bowih kanan Emperador Cesar.’ Anhabiyen na po, ‘Hikobay ye Cristo a Poon a impangako nan Apo Dioh.’ ” ");
INSERT INTO abp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kaya-bay tinepet na yan Gobilnadol Pilato ye Apo Jesus, “Hika nayi ye Poon lan Jujudio?” Nakibat yay Apo Jesus, “Hikaynay naghabi.” ");
INSERT INTO abp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Haanin, hinabi nan Gobilnadol Pilato kanlan mānguna a papadi boy kanlan tatao, “Homain akon nakit a kahalanan nin yatin tao.” ");
INSERT INTO abp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Noba an-ipilit lan teed, a wanla, “Yain a tao, anggulowen na hilay tatao ha kaganaan a lulugal ha plobinhiyan Judea makauli ha an-iadal na. Indugi na ha Galilea ket haanin, niabot yayna ihti ha Jerusalem.” ");
INSERT INTO abp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pamakange nan Gobilnadol Pilato ye hinabi la, tinepet na hila, “Taga Galilea ya nayi yatin tao?” ");
INSERT INTO abp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Awo,” wanla met. Hiyay Herodes Antipas ye gobilnadol ha plobinhiyan Galilea boy anti ya met ha Jerusalem kananyatew a panaon. Kaya-bay ha natandaan nan Gobilnadol Pilato a taga Galilea yay Apo Jesus, hinabi na, “Higi, ilakew yoya kanan Gobilnadol Herodes Antipas.” ");
INSERT INTO abp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Haanin, hiyay Gobilnadol Herodes Antipas, pamakakit na kanan Apo Jesus, ket naaliket ya, ta nabuyot naynan angkangean ye tungkol kana. Kaya-bay angkahabekan na yan makit, ta labay nay makakit nin kapagtakaan a andiyagen na. ");
INSERT INTO abp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ket ha anti yayna ha adapan nan Gobilnadol Herodes Antipas, malabong ye tepet na kanan Apo Jesus, noba ahe yan bega nakibat. ");
INSERT INTO abp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hilay mānguna a papadi boy hilay mamaihtodo nin Bibilin, ampideng hilan ampangipangha nin bada la kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Haanin, hiyay Gobilnadol Herodes Antipas boy hilay huhundaloh na, inumih-umih la yay Apo Jesus. Pinakepkepan laya po nin matampa a bado a omen ha bado nin poon haka la yan impaudong kanan Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hiyay Gobilnadol Herodes Antipas boy Gobilnadol Pilato, ampaykabono hila hatew. Noba paibat kananyain a mangaamot, napaygayyem hilayna. ");
INSERT INTO abp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Haanin, hiyay Gobilnadol Pilato, impadakit na hilay mānguna a papadi, hilay Jujudion mānungkolan boy hilay tatao. ");
INSERT INTO abp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ket hinabi na kanla, “Inlakew yoya kangko yatin tao, ta anhabiyen yo a ampangumbinyo yan tatao a kumuntada ha gobilno. Noba ha panlitih ko kana ha adapan yo, napaptegan kon aliwan peteg ye bada yo laban kana. ");
INSERT INTO abp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Agya hiyay Gobilnadol Herodes Antipas, wanabay met ye napaptegan na. Kaya-bay impaudong naya ihti kantawo. Yatin tao, homain yan nadyag a kahalanan a pamateyan kana. ");
INSERT INTO abp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaya-bay ipapatok ko yaynan bengat haka ko yayna palihwayen.” ");
INSERT INTO abp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hinabi nan Gobilnadol Pilato yatew, ta tepe Pihtan Pangihipan nin Pangiligtah, ket ampamalihway ya nin maghay pidiho. ");
INSERT INTO abp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Noba nayngingidlan lan impangha nin malabong a tatao, a wanla, “Pateyen ya yain a tao! Hiyay Barabbas ye palihwayen mo!” ");
INSERT INTO abp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Hiyay Barabbas, napidiho ya ulita kinumuntada ya ha gobilno ha Jerusalem boy nakapatey yan tao.) ");
INSERT INTO abp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nakihabi yayna man ye Gobilnadol Pilato kanlan tatao, “Hiyay Jesus tana ye palihwayen ko!” ");
INSERT INTO abp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Noba hilay tatao, impapangha la, “Ipako ya ha kodoh! Ipako ya ha kodoh!” ");
INSERT INTO abp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ha ikatlon paghabi nan Gobilnadol Pilato kanla, hinabi na, “Taket? Hinyay kalok-an a dinyag na? Ket homain ako met nakit a kahalanan a pamateyan kana. Kaya-bay ipapatok ko yaynan bengat haka ko yan palihwayen.” ");
INSERT INTO abp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noba hilay tatao, lalo layna ingat impakakhaw ye nangha, a wanla, “Ipako ya ha kodoh!” Ket uli ha pahulong lan pangipangha nin tatao, homain yaynan madyag ye Gobilnadol Pilato. ");
INSERT INTO abp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kaya-bay hinumbong naynan bengat ye labay lan tatao. ");
INSERT INTO abp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pinalihway na yay Barabbas a napidiho ulita nangumbinyo yan tatao a kumuntada ha gobilno boy uli ha pamatey na nin tao. Noba hiyay Apo Jesus, impaolay na yaynan Gobilnadol Pilato kanlan tatao ta-omen layna diyagen ye labay lan diyagen kana. ");
INSERT INTO abp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Haanin, inlakew la yan huhundaloh ye Apo Jesus ha ilwah nin banwa. Legan angkumodang hila ha dān, nahagana la yay laki a nagngalan Simon a taga Cirene a ibat ha baytan. Impilit lan impabatay kana ye pagkodoh nan Apo Jesus haka la yan pinahumbong kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Malabong hilay tataon ampakilakew kanan Apo Jesus. Malabong hilay babayin antumangih boy ampangandang uli ha kalelean la ha angkalyadi kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Haanin, namalingay yay Apo Jesus kanlan babayi. Ket hinabi na kanla, “Hikawon babayi ha Jerusalem, adi yoko antangihan. Hiyay tangihan yo ket hiyay hadili yo boy hilay aanak yo. ");
INSERT INTO abp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta lumateng lano ye panaon a habiyen lan tatao, ‘Minged hilay babayin baug boy hilay ahe namahoho.’ ");
INSERT INTO abp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kananyatew a panaon, habiyen lan tatao ha mamatundol, ‘Yegmaan yo kayi!’ boy habiyen la met ha mamapantay, ‘Tagpenan yo kayi!’ ");
INSERT INTO abp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta no andiyagen la yati ha poon-kayon hadiwa, way-omen ana lagi no nayango yayna?” ");
INSERT INTO abp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Haanin, main luway tulihan a an-ilakew la met ihtew a pateyen. ");
INSERT INTO abp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ha niabot hilayna ha lugal a anhabtan Bungo, impako la yay Apo Jesus ha kodoh. Impako la hila met ye luway tulihan ha timaghay kodoh. Hiyay magha, ha dapit wanan nan Apo Jesus. Ket hiyay magha met, ha dapit odi na. ");
INSERT INTO abp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Haanin, hinabi nan Apo Jesus, “Bapa ko, patawaden mo hila, ta ahe la tanda ye andiyagen la.” Ket hilay huhundaloh, pinaydadakayan lay babado na makauli ha pandaw-an ta-omen la matandaan no hinyay makwa nin magha boy magha kanla. ");
INSERT INTO abp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Malabong hilay tataon anti ihtew a ampamuya. Hilay mānungkolan a anti ihtew, an-ilungolungo la yay Apo Jesus, “Hali man awod! Nangiligtah yan kanayon a tao. Ket no peteg a hiyabay ye Cristo a Pinili nan Apo Dioh, iligtah na met ye hadili na.” ");
INSERT INTO abp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hilay huhundaloh, an-umihen laya met ye Apo Jesus. Hinaleyan laya ta painomen la yan maahem a alak. ");
INSERT INTO abp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ket hinabi la kana, “No hikan peteg ye Poon lan Jujudio, iligtah moy hadili mo.” ");
INSERT INTO abp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Main naipako ha dapit tagay nin ō na a nakaihulatan nin wanae, “YATI YE POON LAN JUJUDIO.” ");
INSERT INTO abp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Haanin, hiyay maghay tulihan a nakapako ha kodoh, inlungolungo na yay Apo Jesus, “Aliwa nayi a hika ye Cristo a impangako nan Apo Dioh? Iligtah moy hadili mo boy iligtah mo kayi met!” ");
INSERT INTO abp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Noba dinlaw na yan maghay tulihan, “Adi mo anhabiyen yain. Ahe ka nayi angkalimo kanan Apo Dioh? Padipadiho kitawobaynan angkapaduhaan. ");
INSERT INTO abp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hikita ye hukat lan pateyen uli ha dinyag tan kalok-an. Noba yatin tao, homain yan bega dinyag a maloke.” ");
INSERT INTO abp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Haanin, hinabi na kanan Apo Jesus, “Apo Jesus, no anti kayna ha panakopan mo, adi moko dayi anliwaan.” ");
INSERT INTO abp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hinabi nan Apo Jesus kana, “Pakaleng-en mon manged ye habiyen ko. Haanin met ateed, ilamo katayna ha Pinakamanged a lugal.” ");
INSERT INTO abp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ha miugtoynay mangaamot, nilumiteh yan kaganaan yatew a lugal anggayna ha alah tidih nin mahilem. ");
INSERT INTO abp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Naanam ye henag nin mangaamot boy hiyay makugpan tabing ha loob nin Timplo, ket nagiwak yan nagitna. ");
INSERT INTO abp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Haanin, hiyay Apo Jesus, impangha na nin makhaw, “Bapa ko, an-ipataya koynay kalelwa ko kammo.” Pangahabi na yatew, naboytoan yaynan angeh. ");
INSERT INTO abp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hiyay kapitan nin huhundaloh, pamakakit nay nalyadi, dinangal na yay Apo Dioh, a wana, “Peteg a matoynong ya yatin tao.” ");
INSERT INTO abp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Haanin, hilay malabong a tataon naytitipon ihtew a ampamuya, ha naimatonan lay nalyadi, ket nuli hilan ampanogdog nin pagaw la uli ha tubat a kalelean la. ");
INSERT INTO abp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Noba hilay kaganaan a gayyem nan Apo Jesus boy hilay babayi a hinumumbong kana paibat po ha plobinhiyan Galilea, ampideng hila ha aliwan minga mataang. Ket nakit la met ye kaganaan a nalyadi kana. ");
INSERT INTO abp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Haanin, main maghay laki a nagngalan Jose a taga Arimatea ha plobinhiyan Judea. Manged yan tao boy matoynong ya. Agya magha ya kanlan mangatoan mānungkolan ha Panuhgaan lan Jujudio, ket ahe yan nakitupig kanlan namatey kanan Apo Jesus. Magha ya met kanlan tataon ampangagad nin panakop nan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Haanin, nakew yan nakihabi kanan Gobilnadol Pilato a hiyayna ye mangilbeng nin bangkay nan Apo Jesus. Ket pinalubohan naya met. ");
INSERT INTO abp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Haanin, in-aypa na yan Jose ye bangkay nan Apo Jesus. Pinutot na yan tapih a lino haka naya in-ihlep ha inyukib a pangilbengan a ahe po nangilbengan. ");
INSERT INTO abp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Biyelneh kananyatew boy dihpidah anan Mangaamot nin Pagpainawa, ta mahilem ana. ");
INSERT INTO abp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hilay babayi a nakilakew kanan Apo Jesus paibat ha plobinhiyan Galilea, ket nakilakew hila met kanan Jose. Nakit lay nangilbengan nin bangkay nan Apo Jesus boy no way-omen la yan in-ilbeng. ");
INSERT INTO abp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Haanin, hilay babayi, nuli hilayna. Ket nangihadya hilan malabong a pabango a itiih la ha bangkay nan Apo Jesus. Ket ha Mangaamot nin Pagpainawa, nagpainawa hila, ta wanabay ye anti ha Bibilin lan Jujudio. ");
INSERT INTO abp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ha mahanibhanib nin Dominggo, nakew hilay babayi ha nangilbengan kanan Apo Jesus. Ket kinaget lay pabango a inhadya la. ");
INSERT INTO abp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ha niabot hilayna ihtew, nakit la a naitulin yaynay mayadet a dapah a pinanleneb ha nangilbengan kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kaya-bay hinumlep hila ihtew, noba ahe la nakit ye bangkay nan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Legan angkayoot hila ha nalyadi, kapipikhaan nakakit hilan luway lakin ampideng ha talig la a ampakapulag ye hoot la. ");
INSERT INTO abp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ket uli ha tubat a limo la, nilumukob hila ha luta. Haanin, tinepet la hilan lalaki, “Taket ta antapulen yo ye angkabi-ay kanlan nangamatey? ");
INSERT INTO abp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ahe yayna ihti. Nabi-ay yaynan uman. Ihipen yoy hinabi na kanyo hatew. Ha anti ya po ha plobinhiyan Galilea, hinabi na, ");
INSERT INTO abp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Hiko a ibat ha langit a in-Anak nin Tao, ket katapulan akon maigawang kanlan māgkahalanan boy maipako ha kodoh. Noba ha ikatlon mangaamot, ket mabi-ay akon uman.’ ” ");
INSERT INTO abp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","10","Hilay babayi a nakew ha nangilbengan, ket hiyay Maria a taga Magdala, hiyay Juana, hiyay Maria a indo nan Santiago boy hilay kanayon po a babayin kalamo la. Haanin, naihipan lay hinabi nan Apo Jesus hatew. Kaya-bay inumalih hilayna ihtew. Ket nag-udong hilayna kanlan labinmaghay apohtol nan Apo Jesus boy kanlan kanayon po a kalalamoan la. Ket imbalita la kanla ye nakit la. ");
INSERT INTO abp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Noba hilay aapohtol nan Apo Jesus, ahe hila namteg, ta nabaan la a palbowat lan bengat babayi ye anhabiyen la. ");
INSERT INTO abp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Agya wanabay man, hiyay Pedro, ket nayew yan nakew ha nangilbengan. Ket ha niabot yayna ihtew, hinilip nay loob nin nangilbengan. Nakit na a hiyay tapih a pinamutot ha bangkay nan Apo Jesus bengat ye anti ihtew. Kaya-bay nuli yaynan ampagtaka ha nalyadi. ");
INSERT INTO abp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Haanin, kananyatew met ateed a mangaamot, main luwan mānumbong nan Apo Jesus ye angkumodang palakew ha badiyon Emaus. Manga labinmaghan kilomitodo ye kataang na ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Legan angkumodang hila, ampaytongtongan lay kaganaan a nalyadi kanan Apo Jesus. ");
INSERT INTO abp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Legan ampaytongtongan lay nalyadi, hiyay Apo Jesus, hinumaley ya kanla. Ket nakiadaad ya ha pangumodang la. ");
INSERT INTO abp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Noba agya ampay-adaad hilayna, ket ahe la yan teed nabalayan. ");
INSERT INTO abp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Haanin, tinepet na hilan Apo Jesus, “Hinyay ampaytongtongan yo?” Ket hilay luway mānumbong, nagpaked hila a angkalele. ");
INSERT INTO abp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hiyay magha kanla a nagngalan Cleopas, nakibat ya, “Yo! Ahe mo nayi tanda? Ha kalabong nin tataon ampakew ha banwan Jerusalem, hikan bengat laweh ye ahe nakatanda nin nalyadi?” ");
INSERT INTO abp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nanepet yay Apo Jesus, “Taket? Hinya ket ye nalyadi ha banwan Jerusalem?” Nakibat hila, “Hiyay nalyadi kanan Apo Jesus a taga Nazaret. Magha yan podopita a makapalyadiyan ha pamilew nan Apo Dioh boy kanlan tatao. Ket pinaptegan na yatew makauli ha makapalyadiyan a hahabi na boy ha panyag nan kapagtakaan. ");
INSERT INTO abp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Noba hilay mānguna a papadi boy hilay mānungkolan kammi, impadakep laya ta-omen yan mauhgaan nin kamateyan. Ket impapako laya ha kodoh. ");
INSERT INTO abp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ba-minan hiyabay ye mamalihway kantawon Israelita. Aliwan bengat yain, kinatlowan ana paibat ha pinatey laya. ");
INSERT INTO abp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Noba nagtaka kayi ha imbalita la kammin anoy babayi a kalalamoan mi. Nangon bengat ha mahanib, nakew hila ihtew ha nangilbengan kana. ");
INSERT INTO abp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ket hinabi la kammi a ahe layna nakit ye bangkay nan Apo Jesus ihtew. Boy nakakit hila nin aanghil a nangihabi kanla a hiyay Apo Jesus, ket nabi-ay yaynan uman. ");
INSERT INTO abp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nakew hila met ye nangaanon kalalamoan mi ha nangilbengan kana. Ket nakit la met a ahe yaynan peteg ye bangkay nan Apo Jesus ihtew a omen ha hinabi lan babayi.” ");
INSERT INTO abp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Haanin, hinabi nan Apo Jesus kanla, “Koynan kamumoan yo boy kaidap yon pamtegan ye kaganaan a hinabi lan popodopita hatew! ");
INSERT INTO abp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tanda yoynabay met a hiyay Cristo a impangako nan Apo Dioh, ket katapulan ya po a magdiha nin pamaidap bayo na yan padangalan Apo Dioh.” ");
INSERT INTO abp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ket hiyay Apo Jesus, impalinaw na kanla ye kaganaan a naihulat a Habi nin Dioh a tungkol kana, paibat ha impahulat kanan Moises anggayna ha inhulat lan kaganaan a popodopita. ");
INSERT INTO abp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ha mahaley hilayna ha badiyo a lakwen la, hiyay Apo Jesus, ampaglaloh-lalohan ya. ");
INSERT INTO abp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Noba impilit la, “Ihti kayna kammi matuloy, ta andudumeglem ana.” Kaya-bay hiyay Apo Jesus, nakilakew yayna kanla. ");
INSERT INTO abp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ha dinumongo hilaynan mangan, hiyay Apo Jesus, nangwa yan tinapay. Ket pinahalamatan naya kanan Apo Dioh. Pangayadi, binih-ilbih-il naya haka na inggawang kanla. ");
INSERT INTO abp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Haanin, ha dinyag na yatew, nabalayan la yaynay Apo Jesus, noba tampol yan naplak ha pamilew la. ");
INSERT INTO abp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hinabi la, “Kaya-bay manayti angkaaliket kitan tubat legan ampakitongtong ya kanta ha dān boy an-ipalinaw na kantay naihulat a Habi nin Dioh!” ");
INSERT INTO abp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ket kananyatew met ateed, hilay luway mānumbong na, nag-udong hilayna ha banwan Jerusalem. Ket nalatngan la hila ihtew ye labinmaghay mānumbong nan Apo Jesus boy hilay kanayon po a kalalamoan lan ampaytipon. ");
INSERT INTO abp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hinabi la kanlan luway mānumbong na, “Peteg awod a nabi-ay yan uman ye Apo Jesus, ta napakit ya kanan Simon Pedro!” ");
INSERT INTO abp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ket haanin, hilay luway mānumbong a nangibat ha Emaus, in-ihtolya lay nalyadi kanla ha dān boy no way-omen la yan nabalayan ye Apo Jesus ha binih-ilbih-il na yaynay tinapay. ");
INSERT INTO abp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Legan ampaytongtongan la po ye nalyadi, kapipikhaan, hiyay Apo Jesus, napakit yan ampideng ha pibunakan la. Ket hinabi na kanla, “Magkamain kawo dayin katanaan.” ");
INSERT INTO abp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Naigat hila boy nalimowan, ta nibaan la yan anito. ");
INSERT INTO abp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Haanin, hinabi nan Apo Jesus kanla, “Taket ta angkalimo kawo boy ampagluwaluwa? ");
INSERT INTO abp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hiko yati! Bilewen yoy gagamet boy bibitih ko. Kimpaan yoko boy bilewen. Hiyay anito, homain yan laman boy but-o. Noba hiko, main.” ");
INSERT INTO abp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pangahabi na yatew, impakit na kanlay gagamet boy bibitih na. ");
INSERT INTO abp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ket uli ha tubat a aliket boy pagtaka la, ahe la makwan pamtegan. Kaya-bay tinepet na hilan Apo Jesus, “Main kawo lawen makan ihen?” ");
INSERT INTO abp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","“Main,” wanla. Ket ginawangan la yan kaputoh a malanghit a iniyaw. ");
INSERT INTO abp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kingwa naya, ket kinan na ha adapan la. ");
INSERT INTO abp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Haanin, hinabi nan Apo Jesus kanla, “Hatew ha kalamo yoko po, hinabi koyna kanyo a katapulan yan matupad ye kaganaan a nakahulat tungkol kangko ha impahulat kanan Moises, ha inhulat lan kanayon a popodopita boy ha libdon Kakanta.” ");
INSERT INTO abp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Haanin, binyan na hilan pagkataloh ta-omen la matalohan ye naihulat a Habi nin Dioh. ");
INSERT INTO abp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hinabi na kanla, “Yati ye naihulat, ‘Hiyay Cristo a impangako nin Dioh, ket katapulan yan magdiha nin pamaidap boy matey. Noba ha ikatlon mangaamot, mabi-ay yan uman.’ ");
INSERT INTO abp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Boy naihulat po a katapulan maipatanda paibat ha Jerusalem angga ha kaganaan a nanahyon ihti ha babe-luta a makauli kangko, ket patawaden nan Apo Dioh ye kaganaan a ampaghehe ha kakahalanan la.” ");
INSERT INTO abp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hinabi na po Apo Jesus, “Ket hikawoynabay met ye nakakit nin kaganaan a nalyadi kangko. Kaya-bay katapulan a ipatanda yo yati kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Itubol koya lano kanyo ye Ihpiditon Dioh a impangako nan Bapa ko. Kaya-bay adi kawo po an-umalih ihtin banwa angga ha lumateng kanyoy Ihpiditon Dioh boy biyan na kawon kapalyadiyan a ibat ha langit.” ");
INSERT INTO abp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Haanin, hiyay Apo Jesus, inlakew na hilay mānumbong na ha badiyon Betania. Pamiabot la ihtew, intagay nan Apo Jesus ye gagamet na, ket in-inged na hila. ");
INSERT INTO abp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Legan an-inged na hilay mānumbong na, ket nipatagay yayna ha langit. ");
INSERT INTO abp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Haanin, hilay mānumbong na, ginalang la yay Apo Jesus. Ket angkaaliket hilan nag-udong ha banwan Jerusalem. ");
INSERT INTO abp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ket maheheg hilan anti ha Timplo a ampanggalang kanan Apo Dioh.");
INSERT INTO abp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ha ahe ya po pinalhowa ye kaganaan, hiyay anhabtan Habi, ket anti yayna. Ket hiyay Habi, kalamo na yan Apo Dioh. Boy yatin Habi, ket Dioh ya. ");
INSERT INTO abp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ket impaibat ha unan panaon, lamo na yaynan Apo Dioh. ");
INSERT INTO abp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hiyay kaganaan, ket impapalhowa nan Apo Dioh kanan Habi. Ket homain hinyaman a napalhowa a aliwan makauli kanan Habi. ");
INSERT INTO abp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ket hiyabay ye ampangibatan nin bi-ay. Ket yatin bi-ay ye tillag a ampamahnag kanlan tatao. ");
INSERT INTO abp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yatin tillag ye mamahnag kanlan tataon anti ha kalitehan boy ahe yan mahambot nin kalitehan. ");
INSERT INTO abp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Haanin, hiyay Apo Dioh, nangitubol yan maghay taon nagngalan Juan ");
INSERT INTO abp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","a mangipapteg a hiyay Apo Jesus ye tillag ta-omen hila mamteg kanan Apo Jesus ye kaganaan a tatao. ");
INSERT INTO abp_vpl VALUES ("JN1_8","073_1_8","JH