﻿USE sofia;
DROP TABLE IF EXISTS sofia.abc_vpl;
CREATE TABLE abc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES abc_vpl WRITE;
INSERT INTO abc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Atiyaꞌ Mahampataꞌ Balita tungkul kan Apu Jesu Cristo, Anak Apu Diyus. Nagꞌumpisay ati hin natupadaꞌ insulat tagapannunghung Apu Diyus ya hi Isaias. Hinlagi, insulat Isaias ya innunghung Apu Diyus kan Apu Jesus. Atiyaꞌ ambala na, “Ipagtan kuy minsahiru ku. Mauna ya kamu, takay inunghung na ha tawtawung ihanda lay sarili la ha paglatêng mu. ");
INSERT INTO abc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Malêngê yuy bungꞌu na ha kalinangan, ya mannunghung, ‘Pakahampatên yuy pusu yu para ha paglatêng Panginuun, Dapay ha paghandan danan para ha maalagan tawu!’ ” ");
INSERT INTO abc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Buy natupadaꞌ ati hin nakalatêng hi Juan ya Tagapagbawtismu istu ha kalinangan. Madlan tawtawung naku kana, ibat ha Jerusalem buy iba iban banwa ha Judea. Nangaral ya ha tawtawu, “Magsisi kawuy na ha kayung kawkasalanan ta magpabawtismu kawu takayꞌêmên patawarên kawun Apu Diyus.” Impagtapat lay kanlan kawkasalanan buy binawtismuan hilan Juan ha Ilug Jordan. ");
INSERT INTO abc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hay barun Juan gawa ha labuk kamilyu buy hay babat na, gawa ha balat ayêp. Hay kikinan na balanga insiktu buy pulut panilan. ");
INSERT INTO abc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ambala na, “Mayin pun gihay lumatêngaꞌ mas makapangyarian pun kangku. Ah ku man, karapat dapataꞌ maglingkud kana dapay gihay alipên. ");
INSERT INTO abc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bawtismuwan katawu ha lanêm, nuwa bawtismuwan na kawu ha Ispiritun Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hin panawên bantu, inlumatêng hi Apu Jesus ibat ha Nazaret, sakup prubinsiyan Galilea, buy nagpabawtismu kan Juan ha Ilug Jordan. ");
INSERT INTO abc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pagkalakat Apu Jesus ha lanêm, nagêangaꞌ langit. Naakit nay nagtabuy kanay Ispiritun Apu Diyus dapay gihay kalapati. ");
INSERT INTO abc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Buy mayin busisaꞌ nalêngê ibat ha langit ya nannunghung, “Hakay minamaal kun Anak, ya lubus kun kinatutulꞌan.” ");
INSERT INTO abc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nakun, agad yan pinalakun Ispiritun Apu Diyus ha kalinangan. ");
INSERT INTO abc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Namirmi ya istun apatnapuy allêw buy tinuksu yan Satanas. Mayin mangatapangaꞌ ayêp istu. Dilag mêt istuy awꞌanghil Apu Diyus ta pinagsilbiyan hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hin nakulung hi Juan ya tagapagbawtismu, naku hi Apu Jesus ha prubinsiyan Galilea. Buy impangaral na baistuy Mahampataꞌ Balitan ibat kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ambala na, “Lumatênganay takdan panawun! Madaniyanay paghaharin Apu Diyus. Pagsisiyan yuy nay kayung kasalanan buy maniwala kawu ha Mahampataꞌ Balita!” ");
INSERT INTO abc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gihay allêw, kaban nalliyaliyaku hi Apu Jesus ha pingit Dagat Galilea naakit nay mipatêlaꞌ mangingisda hilan Simon buy Andres. Mamitambuk hilan lambat. ");
INSERT INTO abc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ambalan Apu Jesus kanla, “Humunul kawu kangku ta gawꞌên katawun mamidanin tawu kan Apu Diyus nambuh ha pandakêp yu ha isda.” ");
INSERT INTO abc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Intayak la agadaꞌ kanlan lawlambat buy hinumunul kana. ");
INSERT INTO abc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nagpatuluy hi Apu Jesus ha paliyaliyaku. Ha alwan kadayuan naakit nay namêtaꞌ luway anak Zebedeo, hilan Santiago buy Juan. Impapakahampat lay lambat la ha kanlan bangka. ");
INSERT INTO abc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Agad hilan binawêg Apu Jesus, “Humunul kawu kangku.” Buy intayak lay kanlan bapan hi Zebedeo ha kanlan bangka, awyunaꞌ kanlan tawtauhan. Ta hinumunul hila kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Naku hilan Apu Jesus ha Capernaum. Hin nalatêngaꞌ Allêw Pamamahinga, naku hila ha biyag pamititipunan Hawjudio ta istun nanudu hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Namanghay tawtawu ha libun tudu na ta nanudu yan mayin kapangyarian, alwan katbuh tawtagapanudun kautuhan. ");
INSERT INTO abc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mayin gihay tawu baistu, sinuklutan anituy biglan nagpahuk buy nagbubungꞌu, ");
INSERT INTO abc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus ya taga Nazaret, hita pakialam mu kanyan? Naku ka kayti taêmên lipuhun kami? Kilala kita. Hakay Banalaꞌ impagtan Apu Diyus!” ");
INSERT INTO abc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nuwa binawalan Apu Jesus ya anitu, “Tênggên ka buy magꞌalih ka kana!” ");
INSERT INTO abc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pinamêgpêg anituy tawu buy nagbungꞌu kaban nagꞌaalihaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Namanghay laataꞌ dilag istu, ta ninununghung hila ha gihat giha, “Hita ati? Gihay bayun tudu, mayin kapangyarian! Hay anitu, nauutuhan na buy napapahunul na!” ");
INSERT INTO abc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kinumalat agadaꞌ balita tungkul kan Apu Jesus ha buun prubinsiyan Galilea. ");
INSERT INTO abc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ibat ha biyag pamititipunan Hawjudio, naku hi Apu Jesus ha biyag lan Simon buy Andres, awyun na hilan Santiago buy Juan. ");
INSERT INTO abc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nalatêng la, pakaundagaꞌ ampun Simonaꞌ babaying inlalagnat. Agad lan innunghungaꞌ ati kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dinaninan Apu Jesus ya mayin hakit, dinukpan nay gamêt ati buy impaibangun na. Naalih agadaꞌ kanan lagnat bayu pinagsilbiyan na hilan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Panlumbug allêw, gintan tawtawu kan Apu Jesus ya laat mayin hakit buy libun sinusuklutan anitu. ");
INSERT INTO abc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Buung banway nangapititipun ha luwahan. ");
INSERT INTO abc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Madlan mayin hakitaꞌ pinagaling Apu Jesus hitamanaꞌ kanlan karamdaman. Buy pinaalih na mêtaꞌ madlan anitu. Nuwa ah na pinaulayan mipannunghung libun anitu ta tanda lan hiyay Anak Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kinadatunan, nibangun hi Apu Jesus, naku ha kalinangan ta baistun nanalangin. ");
INSERT INTO abc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tingkap yan Simon buy kanan kawkaawyun. ");
INSERT INTO abc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hin naakit la hi Apu Jesus, ambala la, “Titingkap kawun laat.” ");
INSERT INTO abc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nuwa innunghung Apu Jesus kanla, “Maku kitamuy na ha kadanin banwa taêmên makapangaralaku mêt baistu. Ta atiyaꞌ dahilan kaya ku naku kayti.” ");
INSERT INTO abc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Buy inlibut Apu Jesus ya buung Galilea, nangaral ya ha libun biyag pamititipunan Hawjudio. Buy nagpaalih yan anitu ha tawtawung sinuklutan anitu. ");
INSERT INTO abc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nagdani kan Apu Jesus ya gihay liyaking mayin hakit ha balat. Nagluhudaꞌ ati kana buy nagmakaingalun pagalingin na. Ambala na, “Nu labay yu, pagalingin yu ku takay luminisaku.” ");
INSERT INTO abc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kinaingalwan yan Apu Jesus ta dinukpan ya. Buy ambala kana, “Labay kun, luminis kay na!” ");
INSERT INTO abc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ginumaling agadaꞌ hakit. ");
INSERT INTO abc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pinaalih ya agad Apu Jesus buy imbilin, “Andi mu nunghungunaꞌ ati ha kanayun. Ha halip, maku ka ha pari buy ipaakit muy balat mu ya ala kay nan hakit. Pagkayari, maghandug kan dapay ha inꞌutuh Moises, patunayaꞌ malinis kay na.” ");
INSERT INTO abc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nuwa pagkaalih na, impagnununghung nay nangyari kana. Ta kinumalataꞌ balitan ati, kaya ah yay na basta makalaku ha bawbanwa ta pagkagulwan yan tawtawu. Buy istu ya tanan namirmi ha kalinangan. Nuwa naku pun kanay tawtawu, ibat ha iba iban rugal. ");
INSERT INTO abc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Pagkalibah umnuy allêw, nagbalik hi Apu Jesus ha Capernaum. Imbalitan tawtawu, “Nakalatênganaꞌ hi Apu Jesus ha tinutuluyan na!” Kaya ban dêlan tawuy nititipun ha tinutuluyan na. Napnuy biyag angga ha mahawang. Kaban nangangaral hi Apu Jesus nunghung Apu Diyus, ");
INSERT INTO abc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","mayin umnuy tawung naku baistu. Hay apat kanla, pigigitanaꞌ lumpu takayꞌêmên idani hana kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nuwa ha kadlan tawu, ah hila makadani kan Apu Jesus, kaya naghampa hila palaku ha uhbung. Buy inlubka lay uhbung ta inꞌuguh lay lumpu ha tapat Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hin naakit Apu Jesus ya kanlan pananampalataya kana, ambala na ha lumpu, “Anak, pinatawadanay kamung kawkasalanan.” ");
INSERT INTO abc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mayin tagapanudun kautuhan, nangakaitnu baistu. Nalêngê lay habatu buy ambala la ha kanlan ihip, ");
INSERT INTO abc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Angkaya ya nannunghung habatu? Alwa yay naman hi Apu Diyus! Pinangungunahan nay Apu Diyus! Alan makakapagpatawad kasalanan nu alwan hi Apu Diyus dili!” ");
INSERT INTO abc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Agadaꞌ naman natandan Apu Jesus ya kanlan iniihip. Kaya ambala na, “Angkaya kawu nagꞌiihip habatu? ");
INSERT INTO abc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iniihip yu, mas madali nu sabin ku ha lumpu, ‘Pinatawadanay kawkasalanan mu’ kisa ha sabin kun, ‘Mêdêng ka, buwatên muy amak mu buy maliyaku ka.’ Ta ah yu nanakitaꞌ pagpapatawad. ");
INSERT INTO abc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nuwa hapaêg, pagalingin kuy tawung ati takay patunayan ku kayu, hakuy nangibat ha langitaꞌ Inꞌanak Tawuy mayin kapangyarian kayti ha lutang magpatawad kasalanan.” Buy ambala na ha lumpu, ");
INSERT INTO abc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mêdêng ka, buwatên muy kamung amak ta muli kay na.” ");
INSERT INTO abc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nêdêng bayaꞌ lumpu. Binwat agadaꞌ kanan amak. Buy naghalwang ya kaban nakabalayaꞌ laat. Talagan nagtakay laat buy pinuri lay Apu Diyus. Ambala la, “Hapaêg kamin dilin nakaakit dapay ati.” ");
INSERT INTO abc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nakun uman hi Apu Jesus ha pingit Dagat Galilea. Inlaku yan dêlan tawu buy tinudwanan na hila. ");
INSERT INTO abc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kaban nalyalyaku ya, naakit nay anak Alfeus ya hi Levi, manyinyingil buwis gubirnun Romano. Nakaitnu ya ha panyingilan buwis. Ambalan Apu Jesus kana, “Humunul ka kangku.” Nêdêng hi Levi buy hinumunul kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hin naku hi Apu Jesus buy tawtagahunul na ha biyag Levi, nangan hilan awyunaꞌ manyinyingil buwis buy kanayunaꞌ intuturing lan makasalanan ta dêla kanlay hinuhumunul kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mayin tagapanudun kautuhanaꞌ dilag baistu, kagiha hila ha Pawpariseo. Hin naakit lan nanangan hi Apu Jesus kaawyunaꞌ libun manyinyingil buwis buy kanayun punaꞌ makasalanan, ambala la ha kanan tagahunul, “Angkaya ya nanangan, kaawyun nay tawtawung ban in?” ");
INSERT INTO abc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nalêngên Apu Jesus ya habatu, kaya tinumbay ya, “Alwan hay alan hakitaꞌ nangangaylangan duktur, nu alwan hay mayin hakit. Nakuwaku kayti taêmên bawgênaꞌ mawmakasalanan alwan hay libun matuynung.” ");
INSERT INTO abc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hin nagtalagan ahê manganaꞌ tawtagahunul Juan ya Tagapagbawtismu buy Pawpariseo takay makanunghung mahampataꞌ Panginuun, nagdaniyaꞌ umnuy tawu kan Apu Jesus buy nagtanung, “Angkaya hay libun tagahunul Juan buy libun Pariseo nagtalagan ahê mangan nuwa hay kayung tagahunul, alwa?” ");
INSERT INTO abc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tinumbay hi Apu Jesus, “Maari kayan magtalagan ahê manganaꞌ libun awyun ha kasalan kaban awyun la punaꞌ liyaking ikasal? Simpri, ahê! ");
INSERT INTO abc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nuwa lumatêng mêtaꞌ allêw, kuwên kanlay liyaking ingkasal, baistu pun hilan magtalagan ahê mangan.” ");
INSERT INTO abc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Innunghung na pun ha pagꞌiitbuh, “Ala pun nanagpin bayun tila ha lumay baru ta nu mangulêtên, kumamhakaꞌ gihi. ");
INSERT INTO abc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ala mêt namisalin bayun alak ha daan balataꞌ pamiantiyan, pagal, paputukun alakaꞌ balat, mitambukaꞌ alak buy mahiray balataꞌ pamiantiyan. Ha halip, isalinaꞌ bayuy alak ha bayun balataꞌ pamiantiyan.” ");
INSERT INTO abc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gihay Allêw Pamamahinga, kaban nalyalyaku hilan Apu Jesus, napadan hila ha triguan, nipantên triguy kanan tagahunul buy kinan la. ");
INSERT INTO abc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naakit Pawpariseo kaya ambala la, “Balayên muy tawtagahunul mu! Ah la tanday impapagbawalaꞌ habatu ha Allêw Pamamahinga?” ");
INSERT INTO abc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tinumbay hi Apu Jesus kanla, “Ah yu nabasa ha kasulatanaꞌ ginawan ninunu tamung hi Haring David? Hin binitil hila buy kanan libun kaawyun buy ala hilan maêkan, ");
INSERT INTO abc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","nagpahuk hi Haring David ha Biyag Apu Diyus ta kinan nay tinapayaꞌ inꞌalay pari kan Apu Diyus. Bayu binyan na punaꞌ libun awyun na maski ayun pun ha kautuhan, hay libun pari diliyaꞌ mayin karapatan mangan habatu. Nangyariyaꞌ ati hin puun pari pun hi Abiatar.” ");
INSERT INTO abc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Buy sinabin Apu Jesus kanla, “Ginaway Allêw Pamamahinga para ha tawu, alwan ginaway tawu para ha Allêw Pamamahinga. ");
INSERT INTO abc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ta hakun nangibat ha langitaꞌ Inꞌanak Tawuy mayin kapangyarian mannunghung nu hita dapat gawꞌên ha Allêw Pamamahinga.” ");
INSERT INTO abc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nagpahuk uman hi Apu Jesus ha biyag pamititipunan Hawjudio. Mayin gihay liyaki istu, paralisaduy gihay gamêt. ");
INSERT INTO abc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Allêw Pamamahingan habatu, kaya binantayan mahampat hi Apu Jesus Pawpariseo, takayꞌêmên mayin hilan maibintang laban kana. Ta nu pagalingin nay liyakin bantu ha Allêw Pamamahinga, pan bawal ha kautuhan la. ");
INSERT INTO abc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ambalan Apu Jesus ha liyaking paralisaduy gihay gamêt, “Kalika kayti kangku.” ");
INSERT INTO abc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkayari, tinanung nay Pawpariseo, “Hita kaya impapahintulut kautuhan ha Allêw Pamamahinga, hay manggawan mahampat u manggawan malaêt? Hay magligtas biyay u mamati?” Nuwa alwa hilan tinumbay. ");
INSERT INTO abc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Matigasaꞌ u la kaya puut yan namalay kanla nuwa lungkutaꞌ natanam na. Binalay nay liyaki ta innunghung na, “Ituynung muy gamêt mu!” Ginumalingaꞌ gamêt na buy naituynung nay ati. ");
INSERT INTO abc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nagꞌalihaꞌ Pawpariseo. Nakipagkagiha agad ha tawtawung Haring Herodes nu pakapakun lan ipapati hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Naku hi Apu Jesus buy tawtagahunul na ha pingit Dagat Galilea. Hinumunul kanay kadlan tawu ibat ha prubinsiyan Galilea, Judea buy Idumea. Mayin mêt ha banwan Jerusalem, ha kalagpak Ilug Jordan, buy ha palibut bawbanwan Tiro buy Sidon. Ta nabalitꞌan tawtawuy ginagawa na. ");
INSERT INTO abc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta ha kadlan tawu, ambalan Apu Jesus ha tawtagahunul na, “Mamihanda kawu paraw gihay bangka taêmên mayinakun mapagtukluwan nu mandalêhêkhêkanaꞌ dêlan tawu.” ");
INSERT INTO abc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Madlan pinagaling hi Apu Jesus, kaya dinalêhêkhêk yan laat mayin hakit takayꞌêmên madukpan yan dili. ");
INSERT INTO abc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu nanakit yan libun tawung sinusuklutan anitu, naglulukub hila kana buy nagbubungꞌu, “Hakay Anak Apu Diyus!” ");
INSERT INTO abc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nuwa mahigpit hilan binawalan Apu Jesus, “Ah yu sabin ha kanayun nu hitalagyuwaku.” ");
INSERT INTO abc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkayari, hinumukpa hi Apu Jesus ha bungꞌuy. Nakun, binawêg nay labinluway tawung labay nan pilin, ambala na, “Kali kawu kayti.” Nagdani hila kana. ");
INSERT INTO abc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","“Hakawun labinluway napili ku, bawgên kun alagad takay makaawyun ku buy mautuhan kun mangaral. ");
INSERT INTO abc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Biyan katawun kapangyarihanaꞌ mamaalih anitu.” ");
INSERT INTO abc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ati ya labinluway pinili na, hi Simonaꞌ binawêg Pedro, ");
INSERT INTO abc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hilan Santiago buy Juan ya awꞌanak Zebedeo ya binawêg nan Boanerges hay labay sabin awꞌanak kilat. ");
INSERT INTO abc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Hay kanayun, hi Andres, hi Filipe, hi Bartolome, hi Mateo, hi Tomas, hi Santiago ya anak Alfeus, hi Tadeus, buy hi Simon ya makabanwa, ");
INSERT INTO abc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","buy hi Judas Iscariote ya naypakabili kan Apu Jesus hin bandan huli. ");
INSERT INTO abc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pangulin Apu Jesus buy tawtagahunul na ha biyagaꞌ pamirmiyan na, ah lay na maarap mangan, ta nanguman nipanlumatêngaꞌ dêlan tawu. ");
INSERT INTO abc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hin nabalitꞌan pamilyan Apu Jesus ya, ginagawa nan ati, sinundu yay na, ta ambalan tawtawu, “Nagꞌiibay nay kanan pangihipan.” ");
INSERT INTO abc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mayinanamêt nalatêng kanan tagapanudun kautuhan ibat ha Jerusalem, buy ambala la, “Sinusuklutan yan Beelzebul, pinakamatagꞌay ha awꞌanitu. Buy ati ya nanamꞌin kapangyarian kanan mamaalih awꞌanitu.” ");
INSERT INTO abc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaya, binawêg Apu Jesus ya libun tawu buy nakinunghung ya kanla ha pamimighitan pagꞌiitbuh, “Magawa kayan Satanas ya paalihinaꞌ kaparihu na? Simpri, ahê. ");
INSERT INTO abc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nu hay gihay puun, mipapati buy mimihiyay kanan nasasakupan, bumagsakaꞌ pamumunu na. ");
INSERT INTO abc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Habatu mêtaꞌ nangyayari nu nipapatiyaꞌ mitatalanak ha gihay biyag. ");
INSERT INTO abc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kaya nu hi Satanas buy kanan kawkaparihu mipapati buy mimihiyay, bumagsak ya mêt buy ahêy na makaibangun pun. ");
INSERT INTO abc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nuwa, hi Satanas maarin maitbuh ha malakasaꞌ tawu. Ah maarin pahukun magnanakawaꞌ biyag na nu ah ya pun gapuhun. Nu maigapuh yay na, maari yay nan matakawan.” ");
INSERT INTO abc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pakalêngꞌên yuy inunghung ku kayu, hay laat kasalanan buy hitalagyumanaꞌ mannunghung malaêt laban kan Apu Diyus, maarin mapatawad. ");
INSERT INTO abc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nuwa, hitalagyumanaꞌ mannunghung malaêt laban ha Ispiritun Apu Diyus, alway nan mapatawad. Hay dapay atiyaꞌ kasalanan, ahêy na mapatawad makanuman.” ");
INSERT INTO abc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Habatuy ambalan Apu Jesus ta ambalan tawtagapanudun kautuhan, “Naanitu hi Apu Jesus.” ");
INSERT INTO abc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Buy inlumatêngaꞌ indu buy pawpatêl Apu Jesus. Nakaêdêng hila ha mahawang buy impabawêg ya. ");
INSERT INTO abc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dêlan tawuy nangakaitnu ha paligid Apu Jesus. Mayin nannunghung kana, “Dilag ha mahawangaꞌ indu yu buy pawpatêl yu, impapabawêg kawu.” ");
INSERT INTO abc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tinumbay hi Apu Jesus, “Tanda yu, nu hita indu ku buy pawpatêl ku?” ");
INSERT INTO abc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Binalay nay tawtawu ha paligid na, buy ambala, “Hakawuy indu ku buy pawpatêl ku! ");
INSERT INTO abc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta hitalagyumanaꞌ hinuhumunul ha kaluuban Apu Diyus, habatuy indu ku buy pawpatêl ku.” ");
INSERT INTO abc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nanudun uman hi Apu Jesus ha pingit Dagat Galilea. Ta ha kadlan tawung nakapaikut kana, naghakay ya ha gihay bangka buy baistu yan nitnu. Pan hay tawtawuy naman natayak ha pingit dagat. ");
INSERT INTO abc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dêla yan intudun pagꞌiitbuh kanla. Ambala na, ");
INSERT INTO abc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Manlêngê kawu! Mayin gihay mananêm namibulaglag bini. ");
INSERT INTO abc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ha kanan pamibulaglag, mayin bawbinin nanabu ha diyan. Inlumatêngaꞌ awꞌibun ta tinuktukaꞌ binin bantu. ");
INSERT INTO abc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mayin mêt nanabuy bini ha kabatuwanaꞌ mayin makayêkaꞌ luta. Agad tinumubuy bini, ta manipisaꞌ luta. ");
INSERT INTO abc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nuwa hin nasikatan allêwaꞌ ati buy naumutan, nayanguy ati ta alwan malalêy yamut. ");
INSERT INTO abc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mayinanaman binin nanabu ha lamunaꞌ madiwi. Inlumabungaꞌ lamun, pinagkêhkêhanaꞌ tinumubuy bini kaya ah ya nanagêy. ");
INSERT INTO abc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hay kanayunaꞌ naman nanabu ha matabay luta. Tinumubuy ati, inlumagu buy nanagêy. Mayin katamtaman diliyaꞌ tagêy, hay kanayunaꞌ naman dêla, hay kanayunaꞌ naman matagêy.” ");
INSERT INTO abc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pagkayari, innunghung Apu Jesus, “Hakawun libun nanlêlêngê, dapat yun pakaihipinaꞌ innunghung kun ati.” ");
INSERT INTO abc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hin nakauliyanay tawtawu, nagtanungaꞌ labinluway tagahunul na buy umnuy awyun la, nu hita labay tutulun pagꞌiitbuh bantu. ");
INSERT INTO abc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ambalan Apu Jesus kanla, “Impatanda kuy na kayuy lihim ha paghaharin Apu Diyus, nuwa ha kanayun, impahayagaꞌ ati ha pagꞌiitbuh. ");
INSERT INTO abc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ginagawa kuy ati takay matupadaꞌ dilag ha kasulatan Apu Diyus, ‘Mamalay man hilan mamalay, ah hila makaakit. Manlêngê man hilan manlêngê, ah hila makatêbêk. Ta nu matêbêk la, dat magsisi hila ha kanlan kawsalanan Buy patawarên hilan Apu Diyus.’ ” ");
INSERT INTO abc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pagkayari, ambalan Apu Jesus kanla, “Nu ah yu matêbêkaꞌ pagꞌiitbuhaꞌ ati, pakapakun yun matêbêkaꞌ kanayun pun pagꞌiitbuh? ");
INSERT INTO abc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hay binin imbulaglag, inꞌitbuh ha nunghung Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hay diyanaꞌ kinanabwan bini, inꞌiitbuh ha libun tawung nanlêlêngên nunghung Apu Diyus nuwa agad nalatêng hi Satanas, inagawaꞌ nunghung Apu Diyus ya nalêngê la. ");
INSERT INTO abc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hay mabatuy rugalaꞌ namanaꞌ kinanabwan bini, inꞌiitbuh ha libun tawung hin nalêngêy nunghung Apu Diyus, natulan tinanggap la agad. ");
INSERT INTO abc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nuwa alwan mataimtim ha pusu lay pagtanggap haati. Kaya ah nagtagalaꞌ kanlan pananampalataya. Paglatêng kairapan u pagꞌuusig ta ha pananampalataya la ha nunghung Apu Diyus, agad hilan nagpatalibukut ha kanlan pananampalataya.” ");
INSERT INTO abc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Hay lutang mayin lamunaꞌ madiwi ya kinanabwan bini, inꞌiitbuh ha libun tawung nanlêlêngên nunghung Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nuwa ha libun alalahanin ha biyay, paghahangad yumaman buy paghahangad ha bawbagayaꞌ nanakit ha mundu, naliliwan lay nunghung Apu Diyus. Kaya ah nananagêyaꞌ nunghung Apu Diyus ha biyay la. ");
INSERT INTO abc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nuwa hay matabay lutang pinaybulaglagan bini, inꞌiitbuh ha tawtawung nanlêlêngên nunghung Apu Diyus buy nanananggap ati. Kaya nananagêyaꞌ ati. Mayin kanayun, katamtaman diliyaꞌ tagêy, hay kanayunaꞌ naman dêla, hay kanayunaꞌ naman matagêy.” ");
INSERT INTO abc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ambalan Apu Jesus kanla, “Alan magsindin dêkêt buy pagkayariy ihanip ha pamiantiyan u ha hilung pagꞌundagan. Alwa nan ipaluntuy dêkêt ha paypaluntuwan? ");
INSERT INTO abc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Habatu mêtaꞌ naman, alan nakatagung ahê malantad, buy alan lihimaꞌ ahê mabunyag ha mahawang. ");
INSERT INTO abc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hakawun nanlêlêngê, dapat yun pakaihipinaꞌ innunghung kun ati.” ");
INSERT INTO abc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ambala na pun, “Unawaên yun mahampataꞌ kayung nalêlêngê kangku. Hay panyukataꞌ ginamit yu ha kanayun, habatu mêtaꞌ gamitin kayu buy higit pun istu. ");
INSERT INTO abc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ta hay tawung hinuhumunul ha nalêngê nan kapêtêgan, biyan pun pagkatêbêk. Nuwa hay tawung ahê hinuhumunul ha kapêtêgan, maski hay makayêkaꞌ natêbêk na, kêwên pun kana.” ");
INSERT INTO abc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ambalan Apu Jesus, “Hay paghaharin Apu Diyus, maiitbuh ha tawung namibulaglag bini ha gahak na. ");
INSERT INTO abc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kaban magtarabahu ya ha allêw buy natutuluy ya ha yabi, hay binin imbulaglag nay tinutumubu, maski ah na tanda nu pakapakun. ");
INSERT INTO abc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hay lutay nagpapatubu buy nagpapatagêy ha tanêm. Sinumibulaꞌ bini bayu nagkauhay. ");
INSERT INTO abc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Buy pagnawtuy na, agad aniin ta panawunanan anian.” ");
INSERT INTO abc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ambala pun Apu Jesus, “Haantu tamu pun kayan maitbuhaꞌ paghaharin Apu Diyus? Hita pagꞌiitbuhaꞌ gamitin tamu haati? ");
INSERT INTO abc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dapay mêt atin butꞌun mustasa, pinakamakayêk ha laataꞌ butꞌu. ");
INSERT INTO abc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nuwa nu maitanêmana buy tumubu, tumagꞌayaꞌ ati, higit pun ha kanayun tanêm. Maski awꞌibun, makapaghalay ha lêpêt ati.” ");
INSERT INTO abc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Impangaral Apu Jesus ya nunghung Apu Diyus ha dêlan pagꞌiitbuhaꞌ dapay ati, nuwa ha kaya lan matêbêk. ");
INSERT INTO abc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Alwa yan nangangaral ha libun tawu nu alwa yan ginugumamit pagꞌiitbuh, nuwa impapaliwanag nay naman ha libun tagahunul na, nu kakapad la. ");
INSERT INTO abc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kinayabinan, ambala na ha tawtagahunul na, “Magbatah kitamu ha lipay dagat.” ");
INSERT INTO abc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kaya inibuwatan tawtagahunul nay tawtawu buy naghakay mêt hila ha bangkan hinahakyan Apu Jesus. Mayin pun bawbangkan hinuhumunul kanla. ");
INSERT INTO abc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Biglan inlumatêngaꞌ malakasaꞌ dawêp. Sinabungkay mangamhakaꞌ alunaꞌ bangkang hinahakyan la, halus mapnun lanêmaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hi Apu Jesus, dilag ha bukutan, natutuluy yan nakaunan. Buy pinukaw yan libun tagahunul na, “Mistru, lumbug kitamuy na! Ala ha ihip yuy ati?” ");
INSERT INTO abc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kaya napukaw ya buy ambala na ha dawêp, “Tênggên ka!” Buy ambala na ha dagat, “Tumining ka!” Ta tinênggên bayaꞌ dawêp buy tinuminingaꞌ dagat. ");
INSERT INTO abc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ambala na ha tagahunul na, “Angkaya kawu nalilimu? Awta, ala kawun pananampalataya kangku?” ");
INSERT INTO abc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nikalimu hila, buy ninununghung, “Hitalagyu kayay ati? Maski dawêp buy dagat, hinuhumunul ha utuh na.” ");
INSERT INTO abc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Inlumatêng hilan Apu Jesus buy tawtagahunul na ha lipay dagat ha lutang libun Geraseno. ");
INSERT INTO abc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagtabuy Apu Jesus ha bangka, hinalubung yan gihay liyaking sinuklutan anitu ibat ha liyangaꞌ lêbêngan. ");
INSERT INTO abc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Buy istu yay nan namimirmi ha lêbêngan. Alan makagapuh kana maski pun kadinay gamitin la. ");
INSERT INTO abc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Umnuy bisis yay nan kinadinaan ha gamêt buy bitih. Nuwa pinagbubuytu nay kadina buy pinaghihira nay tanikala ha gamêt na. Alay nan makabênbên kana. ");
INSERT INTO abc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allêw ta yabi, dilag ya ha lêbêngan buy kabungꞌuyanan, nagbubungꞌu buy pinaghuhugat nan bawbatuy nawini na. ");
INSERT INTO abc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hin natamulaw hi Apu Jesus liyaki, inlumukhu yan nagdani kana ta nagluhud. ");
INSERT INTO abc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ambalan Apu Jesus ha anitu, “Haka anitu, magꞌalih ka ha tawung in!” Malakasaꞌ imbungꞌun liyaki, “Hita pakialam mu kangku, Apu Jesus ya Anak Katagꞌay tagꞌayan Apu Diyus. Mangaku ka kangku, ha lagyun Apu Diyus, ah mu ku pairapan.” ");
INSERT INTO abc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tinanung yan Apu Jesus, “Hita lagyu mu?” Tinumbay ya, “Hakuy kawan ta dêla kami.” ");
INSERT INTO abc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nagmamakaingaluy anitu kan Apu Jesus, “Andi yu kami paalihin ha lutan ti.” ");
INSERT INTO abc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ha alwan kadayuan, mayin nanangana mamhakaꞌ kawan babuy, ha dalisdis bud. ");
INSERT INTO abc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nagmakaingalu hila, “Nu puwidi paulayan yu kami yanan magpahuk ha libun babuyaꞌ tu.” ");
INSERT INTO abc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kaya pinaulayan hilan Apu Jesus. Nagꞌalih hila ha liyaki ta nagpahuk ha libun babuy. Nipanlumukhuy luwan libuy babuy palunghun ha bud, patabuy ha dagat buy nangalêmêh. ");
INSERT INTO abc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hay mangalagan babuyaꞌ naman, nipanlumukhu buy imbalitay nangyari angga ha banwa. Kaya naku istuy tawtawu taêmên matandanaꞌ nangyari. ");
INSERT INTO abc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pangalatêng la kan Apu Jesus, naakit lay liyaking ibat sinuklutan anitu ya pakaitnu. Nakabaru yay na buy matinuy nay ihip. Buy nalimuy tawtawu ha kapangyarian Apu Jesus ya nakapagpaalih anitu. ");
INSERT INTO abc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hay nangyari ha tawung sinuklutan anitu buy ha bawbabuy, ingkuwintun nakaakit ha tawtawung kapilatêng. ");
INSERT INTO abc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kaya pinakinunghungan la hi Apu Jesus, “Magꞌalih kawuy na kayti kanyan.” ");
INSERT INTO abc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hin maghakayana hi Apu Jesus ha bangka, nakinunghung kanay liyaking ginumaling, “Makiawyun hakuy na kayu.” ");
INSERT INTO abc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nuwa alwan nalabay hi Apu Jesus. Nakun, ambala na ha liyaki, “Muli ka tana kayu, ta ibalita mu kanlay laataꞌ ginawa kamun Panginuun buy nu pakapakun kan kinaingalwan.” ");
INSERT INTO abc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaya nagꞌalihaꞌ liyaki, impamalita na ha sampung banwa nu bawgêniꞌ Decapolis, hay laataꞌ ginawa kanan Apu Jesus. Nalgangaꞌ laataꞌ nakalêngên nangyari. ");
INSERT INTO abc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hin nagbalik hi Apu Jesus ha lipay dagat, pinibubuntunan yan kadlan tawu ha pingit dagat. ");
INSERT INTO abc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hi Jairong namumunu ha biyag pamititipunan Hawjudio, naku mêt istu. Pagkaakit na kan Apu Jesus, nagluhud ya ha bitihan ati. ");
INSERT INTO abc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nagmakaingalu ya kana, “Apu Jesus, naghihingaluy anak kun dalagitaꞌ. Nu maari hana, maku kawu kanyan ta ipatung yuy gamêt yu kana takayꞌêmên gumaling ya buy mabyay ya.” ");
INSERT INTO abc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hin nakilaku ya kana, hinunul yan kadlan tawu buy dinalêhêkhêkan ya. ");
INSERT INTO abc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mayin gihay babayi istuy labinluwan tawunanan dinadaya. ");
INSERT INTO abc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Maski nagpapagamut ya ha iba iban duktur, nagꞌiirap ya pun. Naubuhaꞌ laat ari arian na ha pagpapagamut na. Nuwa, ha halipa gumaling ya, lalu pun inlumalay hakit na. ");
INSERT INTO abc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nabalitꞌan nay libun himalan ginawan Apu Jesus. Kaya nakipagdalêhêkhêkan ya ha tawtawu. Naku ya ha bukutan Apu Jesus taêmên madukpanaꞌ baru na. ");
INSERT INTO abc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta naihip babayi, “Nu madukpan kun diliyaꞌ baru na, gumalingakuy na.” ");
INSERT INTO abc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hin nadukpan na ba barun Apu Jesus, biglan tinênggênaꞌ kanan pagdadaya buy natanam nan ginumaling yay na. ");
INSERT INTO abc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Agadanaman natanam Apu Jesus ya mayin inlumabas kanay kapangyarian. Kaya namalingay ya buy nagtanung, “Hita nandukpa ha baru ku?” ");
INSERT INTO abc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ambala kanan tawtagahunul na, “Ha kadlan nakipagdalêhêkhêk kayu, angkaya kaw pun magtanung nu hita nandukpan baru yu?” ");
INSERT INTO abc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nuwa inêlêwꞌêlêw nay paligid, nu hita nandukpan baru na. ");
INSERT INTO abc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nuwa hay babayi, ta tanda nay nangyayari kana, nagdani yan nalilimu buy ginagalgal. Nagluhud ya kana, bayu innunghung kanay pêtêg. ");
INSERT INTO abc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pagkayari, ambala kanan Apu Jesus, “Anak, pinagaling kay nan kamung pananampalataya. Muli kay na. Ah kay na magꞌalala ta ala kay nan hakit.” ");
INSERT INTO abc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaban kanunghung pun Apu Jesus ya babayi, nalatêngaꞌ tawtawung ibat ha biyag Jairo. Ambala la kan Jairo, “Ah yuy na abalaênaꞌ Mistru ta natiyanay anak yu!” ");
INSERT INTO abc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nuwa hin nalêngên Apu Jesus ya innunghung la, ambala na kan Jairo, “Ah ka malimu, manampalataya kan dili.” ");
INSERT INTO abc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ah na pinaulayan manghunul kanay kanayun ha biyag Jairo, nu alwan hilan Pedro, mipatêlaꞌ Santiago buy Juan. ");
INSERT INTO abc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Paglatêng la istu ha biyag Jairo, naakit Apu Jesus ya libun tawung nagkakaingay, mayin nananangih buy nanyêyêngêyêng. ");
INSERT INTO abc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagpahuk na ha biyag, innunghung na ha libun tawu, “Kaya kawu nagkakaingay buy nananangih? Alwan natiyaꞌ anak, natutuluy dili.” ");
INSERT INTO abc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pinagkakayliyan yan tawtawu. Hin pinalabas na hilan laat, inꞌawyun na diliyaꞌ bapa buy indun anak buy tatluy tagahunul na bayu hila nagpahuk ha pagꞌundagan anak. ");
INSERT INTO abc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dinukpan nay gamêt anak, ambala na, “Talitha kum.” Hay labay tutulun habatu, “Anak, mibangun ka.” ");
INSERT INTO abc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Agad, nibangunaꞌ anak buy nallyakuꞌ. Kaya labis nalgangaꞌ tawtawu ha nangyari. (Hay habatuy anak, labinluway tawun.) ");
INSERT INTO abc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nuwa mahigpit inꞌutuh kanlan Apu Jesus ya, “Andi yu sabin maski ha hitalagyumanaꞌ nangyari.” Pagkayari, ambalan Apu Jesus kanla, “Pakanên yuy nay anak.” ");
INSERT INTO abc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nuli hi Apu Jesus ha kanan sariling banwa. Hinumunul kanay tawtagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Paglatêng Allêw Pamamahinga, naku ya ha biyag pamititipunan Hawjudio buy nanudu ya istu. Nalgangaꞌ tawtawung nanlêngê kana buy ambala, “Haantu na kayan nakuway katalinuwan nan in? Buy hita katalinuwanaꞌ atiyaꞌ inꞌibi kana? Pakapakun ya nanggagawan makapagtaka? ");
INSERT INTO abc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Alwa nan hiyay karpintirun anak Maria, pawpatêl na hilan Santiago, Jose, Judas buy Simon? Alwa nan kayti mêt namimirmiyaꞌ pawpatêl nan babayi?” Kaya ah ya pinanlêlêngꞌan. ");
INSERT INTO abc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ambalan Apu Jesus kanla, “Hay gihay tagapannunghung Apu Diyus, inggagalang maski haantu. Nuwa ha sarili nan banwa buy ha kanan kamagꞌanak buy ha pamilya, ah ya inggagalang.” ");
INSERT INTO abc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Habatuy dahilan kaya uumnuy nagawa nan himala istu. Ta hay ginawa na tana, impatung nay gamêt na ha umnuy mayin hakit taêmên mapagaling hila. ");
INSERT INTO abc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nagtaka ya ha kawalꞌan lan pananampalataya. Inlibut Apu Jesus ya bawbaryu ta nangaral ya ha tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Binawêg nay labinluwaꞌ nan tagahunul ta inutuhan nan luwa luwa. Binyan hilan kapangyarihanaꞌ magpaalih anitu. ");
INSERT INTO abc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Buy inbilin kanla, “Ah kawu mantan hitalagyuman ha kayung paliyaliyaku, maski hitalagyumanaꞌ maêkan, pira u bag. Mantan kawu tanan tukud. ");
INSERT INTO abc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Maari kawun magsuut sandalyas, nuwa ah kawu mantan pagpalitaꞌ baru. ");
INSERT INTO abc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nu pinatuluy kawu ha gihay biyag, baistu kawu tanan mamirmiꞌ angga ha magꞌalih kawu ha rugalaꞌ tu. ");
INSERT INTO abc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu ah kawu tanggapên u panlêngꞌan ha gihay rugal, magꞌalih kawu istu buy ipagpag yuy abu ha bitih yu bilang babala laban kanla.” ");
INSERT INTO abc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaya nagꞌalih hila takay mangaral ha tawtawu. Innunghung la, “Magsisi kawu ha kawkasalanan yu.” ");
INSERT INTO abc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Buy pinaalih lay madlan anitu ya sinumuklut ha tawtawu. Pinuyukan lan langisaꞌ dêlan mayin hakit buy ginumaling. ");
INSERT INTO abc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nabalitꞌan Herodes ya tungkul kan Apu Jesus ta kilalan kilala yay na maski haantu. Mayin umnuy nannununghung, “Hiya hi Juan, nabyay yan uman. Kaya nakakagawa yan hawhimala.” ");
INSERT INTO abc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ambalay naman kanayun, “Hiya hi Eliasaꞌ tagapannunghung Apu Diyus hinlagi.” Mayin nannununghung kanayun, “Giha ya ha tagapannunghung Apu Diyus, dapay tawtagapannunghung na hinlagi.” ");
INSERT INTO abc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nuwa hin nabalitꞌan Haring Herodesa habatuy innunghung tawtawu, ambala na, “Hi Juanaꞌ habayin, ya pinutuhan kun u nabyay uman.” ");
INSERT INTO abc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hinhatu kasi, pinupunan Juanaꞌ pakikitakpin Haring Herodes kan Herodias ya bayaw na, ya ahawan Felipe. ");
INSERT INTO abc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Panay yan pinannununghungan Juan, “Alwan tamay kuwên muy ahawan patêl mu.” Kaya impadakêp Haring Herodes hi Juan buy impakulung na. ");
INSERT INTO abc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nangimkim puut hi Herodias kan Juan, ta labay nan ipapati. Nuwa ah na magawa. Ta ahê malabay hi Haring Herodes. ");
INSERT INTO abc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nalilimu hi Haring Herodes kan Juan. Tanda nan matuynung buy banalaꞌ tawung ati, kaya impagtatanggul na. Maski naguguluy nakêm na ha tinutul Juan, natutula ya pun manlêngê kana. ");
INSERT INTO abc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nuwa inlumatêng mêtaꞌ pagkakatawunaꞌ inêêtêng Herodias. Kaallêwan hinhatun Haring Herodes kaya nagdaus yan mamhakaꞌ ukasyun. Kinumbida nay libun nanunungkulan ha Galilea, libun matagꞌay ha sawsundalung Romano, buy kanayun punaꞌ kilalan tawu istu. ");
INSERT INTO abc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hin urasanan kasiyaan, nagpahukaꞌ anakaꞌ dalagan Herodias ta naghayaw. Labisaꞌ tulan Haring Herodes buy bawbisita na, kaya ambalan Haring Herodes ha dalaga, “Mikikuwa ka kangkun maski hitalagyu, ibi ku kamu.” ");
INSERT INTO abc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Buy impangaku na kana, “Hitamanaꞌ ipikikuwa mu kangku, ibi ku, maski kalahati pun kayamanan kaharian ku.” ");
INSERT INTO abc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kaya naglabas punaꞌ dalaga, nagtanung ha indu na, “Hita ipikikuwa ku kana?” Buy ambalan indu na, “Hay un Juan ya Tagapagbawtismu.” ");
INSERT INTO abc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kaya nagmadalin nagbalikaꞌ dalaga kan Haring Herodes, “Labay ku hapaêg mêt, ipaluntu yu ha bandihaduy un Juan ya Tagapagbawtismu buy ibi yu kangku.” ");
INSERT INTO abc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Labisaꞌ atin ingkalungkut Haring Herodes, nuwa ah ya makatanggi ha dalaga ta nangaku ya ha mangalêngên bawbisita. ");
INSERT INTO abc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaya agad nan impalakuy gihay sundalu ha bilangguan takay kuwênaꞌ un Juan. Nakuy sundalu istu ta tinupadanay inꞌutuh Haring Herodes kana. ");
INSERT INTO abc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Impaluntu nay un Juan ha bandihadu. Inꞌabut na ha dalaga ta inꞌibi nay naman ha indu na. ");
INSERT INTO abc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hin nabalitꞌan libun tagahunul Juan ya nangyari, kinwa lay nawinin ati buy inꞌêlbêng. ");
INSERT INTO abc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nagbalikaꞌ libun inutuhan Apu Jesus ya mangaral, ta ingkuwintu la kanay laataꞌ ginawa buy impangaral la. ");
INSERT INTO abc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ha kadlan tawung inlulumatêng buy nagꞌaalih, alay na hilan uras mangan man. Kaya ambalan Apu Jesus ha tawtagahunul na, “Ibwatan tamu punaꞌ libun tawung ati. Maku kitamu ha kalinangan taêmên makapagpahinga kawun sandali.” ");
INSERT INTO abc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaya naghakay hila ha gihay bangka ta naku hila ha kalinangan. ");
INSERT INTO abc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nuwa hin nagꞌalih hila, dêlan nakaakit buy nakakilala kanla. Kaya mabilisa naman naliyakuy tawtawu ibat ha iba iban banwa, palaku ha rugalaꞌ lakwun lan Apu Jesus. Buy nauna pun hilan inlumatêng istu. ");
INSERT INTO abc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kaya hin nagtabuy hi Apu Jesus ha bangka, naakit nay kadlan tawu. Kinaingalwan na hila, ta dapay hilan tupan alan pastul. Buy tinudwanan hilan dêlan bagay. ");
INSERT INTO abc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hin bandan hapunana, nagdani kan Apu Jesus ya libun tagahunul na. Buy ambala la, “Mistru, kalinangananay ati buy inyuyumabiyana. ");
INSERT INTO abc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Paliyakunun yuy na hila ha kalagpak baryu taêmên makahaliw hilan maêkan.” ");
INSERT INTO abc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nuwa ambalan Apu Jesus kanla, “Hakawuy mamakan kanla.” Tinumbay hila, “Mistru, manyaliw kami pun ipakan kanla? Pan abut walun buyanaꞌ alagan sahudaꞌ panyaliw maêkan la!” ");
INSERT INTO abc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tinanung hilan Apu Jesus, “Umnuy tinapayaꞌ dilag kayu? Balayên yu paraw.” Hin binalay la, ambala kan Apu Jesus, “Lilimay tinapay buy luluway isda.” ");
INSERT INTO abc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pagkayari, inutuhan na hila, “Paitnun yu hilan guru gurupu ha kalamunan.” ");
INSERT INTO abc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kaya nitnu hilan guru gurupu tig lilimampu buy tig gigihandaan. ");
INSERT INTO abc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kinwan Apu Jesus ya limay tinapay buy luway isda, bayu naningal ya ha langit ta nagpasalamat kan Apu Diyus. Kaban pinagbihꞌil bihꞌil nay tinapay, kinumadlay ati, inꞌibi na ha tawtagahunul na takay iibi ha libun tawu. Habatu mêtaꞌ ginawa na ha luway isda. ");
INSERT INTO abc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangan hilan laat buy nangabhuy. ");
INSERT INTO abc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkayari lan nangan, tinipun lay nitlay tinapay buy isda ta nakapnu hilan labinluway baskit. ");
INSERT INTO abc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hay nakapangan tawtinapay, liman libuy kaliyakiyan. ");
INSERT INTO abc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkayari, pinahakay agad Apu Jesus ya tawtagahunul na ha bangka ta pinaunay na hila ha banwan Betsaida, ha lipay dagat. Kaban hay libun tawuy naman, pinauli nay na. ");
INSERT INTO abc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hin nakapagpatanda yay na ha libun tawu, hinumukpa yay na ha bungꞌuy takay manalangin. ");
INSERT INTO abc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hin yabiyana, gigihan nanalangin hi Apu Jesus. Dilagaꞌ naman ha gitnan dagataꞌ bangkang tawtagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naakit nay tawtagahunul nan irap manyagwan, ta nakasalungat hila ha dawêp. Hin hawang hawanganaꞌ, nanghunul kanla hi Apu Jesus ya nalliyaliyaku ha babun lanêm. Lampasan na hana hila. ");
INSERT INTO abc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nuwa, hin naakit tawtagahunul nan nalliyaliyaku ya ha babun lanêm, indap la anitu kaya nalimu hila buy nagbubungꞌu. Nuwa nannunghung agad hi Apu Jesus, “Hakuy ati, ah kawu malimu. Lakasan yuy luub yu.” ");
INSERT INTO abc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naghakay hi Apu Jesus ha bangka buy biglan tinênggênaꞌ dawêp. Kaya nalgang hila. ");
INSERT INTO abc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maski naakit la punaꞌ himalan ginawan Apu Jesus ha tinapay, alwa la pun natêtêbêkaꞌ kapangyarian na, ta matigasaꞌ pusu la. ");
INSERT INTO abc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hin nakabatahana hila ha dagat, nalatêng hila ha lutang Genesaret. Baistu lan insadsadaꞌ bangka. ");
INSERT INTO abc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagtabuy la, agad nakilala hi Apu Jesus libun tawu istu. ");
INSERT INTO abc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kaya nagꞌaapura hilan naku ha palibut rugal. Haantu la man mabalitꞌan dilag hi Apu Jesus, gigintan la kanay libun mayin hakitaꞌ dilag ha kalapayan. ");
INSERT INTO abc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nu haantu ya man maku, ha baryu, banwa u bukid, gigintan tawtawuy mayin hakit ha pinagtitipunan tawtawu. Nagmamakaingalu hila kan Apu Jesus, ambala la, “Mistru, nu maari madukpan yan hanay tampuh kayung baru.” Buy hay laat nakadukpa kana, ginumaling. ");
INSERT INTO abc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mayin nagdani kan Apu Jesus ya Pawpariseo buy libun tagapanudun kautuhanaꞌ ibat ha Jerusalem. ");
INSERT INTO abc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naakit lay umnuy tagahunul Apu Jesus, ah hila hinuhumunul ha nakaugaliyan ninunu la ta nanangan hilan ahê nagꞌuuyah gamêt. ");
INSERT INTO abc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hay Hawjudio laluy nay libun Pariseo, ahê pun mangan nu ahê pun magꞌuyah gamêt, bilang paghunul ha kaugaliyan kanlan ninunu. ");
INSERT INTO abc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Alwa pun hilan nanangan hitalagyumanaꞌ hinaliw la ha palingki anggan ah la pun ginagaway rituwal ha paglilinis. Madla pun hilan kaugaliyanaꞌ nambuh ati, pagꞌuuyah tawtasa, pagꞌuuyah pawpitsil buy pagꞌuuyah pamiantiyanaꞌ tansu. ");
INSERT INTO abc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaya tinanung yan Pawpariseo buy libun tagapanudun kautuhan, “Angkaya, ahê hinuhunul tawtagahunul muy libun kaugaliyan ninunu, ahê hila nagꞌuuyah gamêt bayu mangan.” ");
INSERT INTO abc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tinumbay hi Apu Jesus kanla, “Pêtêgaꞌ impasulat Apu Diyus kan Isaias tungkul kayung pakitan tawun dili, ‘Inggagalangakun tawtawung ati ha bêbêy la dili, nuwa hay pusu la, madayu kangku. ");
INSERT INTO abc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Alan alagay pagsamba la kangku, ta hay intutudu lay awꞌutuh dilin tawtawu.’ ");
INSERT INTO abc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pinaulayan yuy utuh Apu Diyus ta hay hinuhunul yuy kaugaliyan tawtawu.” ");
INSERT INTO abc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ambalan Apu Jesus, “Mahampat kawun mamaulay libun utuh Apu Diyus takayꞌêmên mahunul yuy libun kaugaliyan yu. ");
INSERT INTO abc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nambuh hin tinutul Moises, ‘Igalang yuy kayung mangatuwa’ buy ‘Hay mannunghung malaêt ha kanan mangatuwa, dapat patin!’ ");
INSERT INTO abc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nuwa intutudu yuy namanaꞌ hay ibi hana ha mangatuwa yu, ibi tana kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ah yuy na hila pinapaulayanaꞌ makatulung ha kanlan mangatuwa. ");
INSERT INTO abc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta ha paghunul yu ha kaugaliyanaꞌ minanaꞌ yu ha kayung ninunu, napaulayan yuy nay utuh Apu Diyus. Buy madla kaw pun ginagawan dapay ati.” ");
INSERT INTO abc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Binawêg uman Apu Jesus ya tawtawu buy ambala kanla, “Manlêngê kawun laat buy pakaihipin yun mahampataꞌ nunghungun ku kayu. ");
INSERT INTO abc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Alwan hay nagpapahuk ha bêbêy tawuy nagpaparumi kana ha pamalayan Apu Diyus nu alwan hay inlulumabas ha bêbêy na.” ");
INSERT INTO abc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hakawung libun nanlêlêngê pakaihipin yuy ati! ");
INSERT INTO abc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hin inibwatan nay dêlan tawu, nagpahuk ya ha biyag ta nagtanung kanay tawtagahunul na, “Hita labay tutulun pagꞌiitbuh bantu?” ");
INSERT INTO abc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ambalan Apu Jesus kanla, “Awta, kaya ah yu mêt natêbêk? Ta ah yu tanday hitalagyumanaꞌ kanên tawuy alwan habatuy makapagparumi kana? ");
INSERT INTO abc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta hitalagyumanaꞌ kanên na, alwan ha pusu nan nanaku nu alwan ha bituka na. Buy ilabas nay habatu.” Hin innunghungaꞌ atin Apu Jesus, impahayag na, “Puwidin kanênaꞌ laataꞌ maêkan.” ");
INSERT INTO abc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ambala na pun, “Hay nangingibat ha pusun tawu, habatuy nagpaparumi kana ha pamalayan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta ha pusun tawu nangingibataꞌ mangalaêtaꞌ pagꞌiihip, nagꞌuudyuk kanan makitakêh ha alwa nan ahawa, manakaw, mamati, ");
INSERT INTO abc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mamitêtêpêl, manyakim buy manggawan laataꞌ kamalaêtan nambuh pandaraya, kabastusan, pagkainggit, panghihira ha kaparihu, pagyayabang buy kamulalaan. ");
INSERT INTO abc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hay laat mangalaêtaꞌ ati, nangingibat ha pusun tawu buy nagpaparumi kana.” ");
INSERT INTO abc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hin nagꞌalih hi Apu Jesus, naku ya ha rugal madani ha banwan Tiro. Paglatêng na istu, nakituluy ya ha gihay biyag. Ahê na hana labay ipatanda ha tawtawung dilag ya istu, kayan dili nabalitꞌan mêt. ");
INSERT INTO abc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nakun, mayin gihay babaying alwan Judio. Taga Fenicia ya, sakup Syria. Buy mayin anakaꞌ babayi, sinuklutan anitu. Hin matandan nan dilag hi Apu Jesus, agad nan inlaku. Ta naglukub ya ha bitihan na, bayu nagmakaingalu, “Apu Jesus, paalihin yuy anitu ha anak ku.” ");
INSERT INTO abc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nuwa, tinumbay hi Apu Jesus ha gihay pagꞌiitbuh, “Dapat pun pakanênaꞌ anak ta alwan taman kuwênaꞌ maêkan anak ta itambuk ha dawdêwêng.” ");
INSERT INTO abc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nuwa tinumbayaꞌ babayi, “Tama kawuy, Apu Jesus. Kayan dili, maski dawdêwêng ha hilung panganan, nanangan mumun nananabun anak.” ");
INSERT INTO abc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaya ambalan Apu Jesus kana, “Ha innunghung mun in, muli kay na ta nagꞌalihanay anitu ha anak mu.” ");
INSERT INTO abc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nuli yay na, nalatêng nay anak na ha undagan, inibwatan yay nan anitu. ");
INSERT INTO abc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagbalik Apu Jesus ibat ha banwan Tiro, dinuman ya ha banwan Sidon buy ha Decapolis. Pagkayari, nagtuluy ya ha Dagat Galilea. ");
INSERT INTO abc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baistu, gintan kanan tawtawuy gihay liyaking pipiyana bingi pun. Nakinunghung hila kan Apu Jesus, “Apu Jesus, ipatung yuy gamêt yu ha liyaki takayꞌêmên gumaling ya.” ");
INSERT INTO abc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Indayu pun Apu Jesus ya liyaki ha tawtawu. Ta impahuk nay dawdaliri na ha luway têk liyaki. Bayu tinupayan nay daliri na ta impuyuk ha dilan ati. ");
INSERT INTO abc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naningal hi Apu Jesus ha langit, buy nakatipuhung inawanên buy ambala ha liyaki, “Effata!” Hay labay tutulun, “Mabuksan!” ");
INSERT INTO abc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nakalêngê agadaꞌ liyaki buy nakapannunghung yan mahampat. ");
INSERT INTO abc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pinagbilinan nay tawtawu, “Andi yu ipamalitay nangyari.” Nuwa maski innunghung na, lalu la pun ingkalataꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nalganganaꞌ libun tawu, buy ambala la, “Mahampataꞌ namanaꞌ laataꞌ ginagawa na! Nakapannunghunganay pawpipi, nakalêngêy nay bawbingi.” ");
INSERT INTO abc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pagkayarin umnuy allêw, nititipun umanaꞌ tawtawu kan Apu Jesus. Hin alay na hilan maêkan, binawêg nay tawtagahunul na, ambala na, ");
INSERT INTO abc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naiingaluwaku ha tawtawung ati. Ta tatluy allêw kuy na hilan awyun, alay na hilan maêkan. ");
INSERT INTO abc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu paulin kuy naman hilan bitilin, dat mahilu hila ha diyan ta madayu punaꞌ ibatan kanayun kanla.” ");
INSERT INTO abc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tinumbayaꞌ tawtagahunul na, “Haantu kitamun mangwan maêkan kayti ha kalinangan, maiibi ha kadlan tawtawung in?” ");
INSERT INTO abc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tinanung hilan Apu Jesus, “Umnuy tinapayaꞌ dilag bahên kayu?” Ambala la, “Pitu.” ");
INSERT INTO abc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pinaitnun Apu Jesus ya tawtawu ha luta. Kinwa nay pituy tinapay bayu nagpasalamat kan Apu Diyus. Pagkayari, binihꞌil bihꞌil nay ati buy kinumadla. Bayu inꞌibi na ha tawtagahunul na buy impagꞌiibi ha tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mayin mêt hilan umnuy mangkayêkaꞌ isda. Pinasalamatan mêt Apu Jesus ya habatu buy inꞌutuh nan ipagꞌiibi mêt ha tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangan hila buy nabhuy. Pagkayari, tinipun lay nitla ta nakapnu hilan pituy baskit. ");
INSERT INTO abc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Apatalibun tawuy nakapangan. Pagkayari, pinauli hilay nan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta agad yan naghakay ha bangka awyunaꞌ tawtagahunul na. Bayu naku hila ha banwan Dalmanuta. ");
INSERT INTO abc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Paglatêng la baistu, mayin nipanlumatêngaꞌ Pawpariseo ta nakipagtalu kan Apu Jesus. Labay yan subukan, kaya hiniling lan magpaakit yan himala ibat kan Apu Diyus takay mapapêtganaꞌ sugu yan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nuwa, nakatipuhung malalê hi Apu Jesus. Ambala na, “Angkaya nanangkap himalay tawtawu ha panawunaꞌ ati? Pakalêngꞌên yuy inunghung ku kayu, alan hitalagyumanaꞌ himalan ipaakit kayu.” ");
INSERT INTO abc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pagkayari, inibwatan nay na hila. Naghakay ya ha bangka buy nagbatah ha lipay dagat. ");
INSERT INTO abc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliwan tawtagahunul Apu Jesus ya mantan dêlan tinapay. Gigihay baun lan tinapay ha bangka. ");
INSERT INTO abc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nagbilin hi Apu Jesus kanla, “Magꞌingat kawu ha pampaalsan Pawpariseo buy Haring Herodes.” ");
INSERT INTO abc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ninununghungaꞌ tawtagahunul Apu Jesus, “Innunghung nay habatu ta ala kitamun gintanaꞌ tinapay.” ");
INSERT INTO abc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tandan Apu Jesus nu hitalagyuy pinununghungan la, kaya innunghung na kanla, “Angkaya yu pinununghunganaꞌ ala kawun gintanaꞌ tinapay? Ah yu pun natatandan u natêtêbêk? Matigas punaꞌ pusu yu? ");
INSERT INTO abc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Mayin kawun mata, nuwa ah yu nanaakit. Mayin kawun têk, nuwa ah yu nalêlêngê. Naliwan yuy na hin pinagbihꞌil bihꞌil kuy limay tinapay para ha liman libuy tawu? Umnuy baskitaꞌ napnu yu ha nitlay tinapay?” Tinumbay hila, “Labinluway baskit!” ");
INSERT INTO abc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Hin pinagbihꞌil bihꞌil kuy pituy tinapay para ha apatalibuy tawu, umnuy baskitaꞌ napnu yu ha nitlay tinapay?” Tinumbay hila, “Pituy baskit!” ");
INSERT INTO abc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Buy ambalan Apu Jesus kanla, “Ah yu pun natêtêbêkaꞌ labay kun tutulun kayu?” ");
INSERT INTO abc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Paglatêng la ha banwan Betsaida, mayin nantan gihay liyaking bulag kan Apu Jesus. Nagmakaingalu hila, “Apu Jesus ipatung yuy gamêt yu kana takayꞌêmên gumaling ya.” ");
INSERT INTO abc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kaya tinambay Apu Jesus ya liyaki palabas Betsaida. Paglatêng la ha mahawang, tinupayan nay gamêt na buy impuyuk na ha matan liyaki. Bayu impatung nay gamêt na ha liyaki buy nannunghung, “Mayin kay nan nanaakit?” ");
INSERT INTO abc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naningala liyaki buy ambala, “Nakakaakitakuy nan tawtawu, kayan dili dapay hilan pawpuun kayung nallyalyaku.” ");
INSERT INTO abc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kaya impatung uman Apu Jesus ya gamêt na ha matan liyaki. Pagkayari, namalay mahampataꞌ liyaki buy hinumawanganay kanan pamalayan. ");
INSERT INTO abc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pinauli yay nan Apu Jesus nuwa binilinan ya, “Ah kay na magbalik ha Betsaida.” ");
INSERT INTO abc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naku hi Apu Jesus buy kanan tagahunul ha bawbaryun sakup banwan Cesarea ha Filipos. Kaban nalliyaliyaku hila, tinanung Apu Jesus ya kanan tawtagahunul, “Hitalagyuwaku kanuh ambalan tawtawu?” ");
INSERT INTO abc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tinumbay hila, “Mayin nannununghung, hakawu kanuh hi Juan ya Tagapagbawtismu. Mayin mêt nannununghung, hakawu kanuh hi Elias ya tagapannunghung Apu Diyus hinlagi. Hay kanayunanaman nannununghung, giha kaw mêt kanuh ha tawtagapannunghung Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tinanung hilan Apu Jesus, “Nuwa para kayu, hitalagyuwaku?” Tinumbay hi Pedro, “Hakawuy Criston impangakun Tagapagligtas.” ");
INSERT INTO abc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ambalan Apu Jesus kanla, “Ah yu ipatanda maski ha hitalagyumanaꞌ hakuy Cristo.” ");
INSERT INTO abc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nagꞌumpisan mangaral hi Apu Jesus ha tawtagahunul na, “Hakuy nangibat ha langitaꞌ Inꞌanak Tawuy kaylangan magdanas madlan pagꞌiirap. Itakwilakun pawpuun Judio, libun namamaalan pari buy tawtagapanudun kautuhan. Ipapatiyaku, nuwa ha ikatlun allêw, mabyay uman.” ");
INSERT INTO abc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Impaliwanag nay laataꞌ ati kanla. Hin malêngên Pedroy habatu, tinambay na hi Apu Jesus ha gihay pingit buy pinannunghungan. ");
INSERT INTO abc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nuwa inumarap hi Apu Jesus ha kanan tawtagahunul buy ambala kan Pedro, “Magꞌalih ka kayti! Tinutuksu mu kun dapay kan hi Satanas! Hay iniihip muy alwan ha labay Apu Diyus nu alwan ha labay tawu!” ");
INSERT INTO abc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pagkayari, binawêg nay tawtawu buy tawtagahunul na. Ambala na kanla, “Hitalagyumanaꞌ labay humunul kangku, dapat liwanan nay kanan sariling labay. Buy handa nan arapênaꞌ maski kamatiyan dapay pamamasan krus alang alang ha paghunul na kangku. ");
INSERT INTO abc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta hay tawung naghahangad magligtas kanan biyay, mawalꞌan ati. Nuwa hay tawung naghahangad magꞌalay kanan biyay alang alang kangku buy ha Mahampataꞌ Balita, magkarun biyay ya alan anggan. ");
INSERT INTO abc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hita mapalan gihay tawu nu mapakana manaꞌ laataꞌ bagay ha mundu, nuwa ah nay naman makuway biyay ya alan anggan? ");
INSERT INTO abc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ta alan maiibiyaꞌ tawu takay makuwa nay biyay ya alan anggan. ");
INSERT INTO abc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nu haku buy tawtudu kuy ikadêngꞌêy hitalagyuman, ha panawunaꞌ atin makasalananaꞌ tawtawu buy alwan tapat kan Apu Diyus, ikadêngꞌêy ku ya mêt nu hakuy nangibat ha langitaꞌ Inꞌanak Tawuy mapakayti, taglayaꞌ kapangyarian kangkun Bapa buy awyunaꞌ bawbanalaꞌ anghil.” ");
INSERT INTO abc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ambalan Apu Jesus kanla, “Pakalêngꞌên yuy inunghung ku kayu. Mayin umnu kayuy ahê mati anggan ah la pun maakitaꞌ paghaharin Apu Diyus ya mayin kapangyarihan.” ");
INSERT INTO abc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkalibah animaꞌ allêw, inꞌawyun Apu Jesus hilan Pedro, Santiago buy Juan ha gihay matagꞌayaꞌ bungꞌuy, kakapad la istu. Kaban nakabalay hila kan Apu Jesus nagbayuy kanan anyu. ");
INSERT INTO abc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nagin puting putiyaꞌ baru na, makasilaw balayên. Alan hitalagyuman kayti ha munduy makapagpaputin dapay habatu. ");
INSERT INTO abc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Baistuy nagpakit kanla hi Elias buy hi Moises. Buy nakinunghung hila kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Innunghung Pedro kan Apu Jesus, “Mistru, mahampataꞌ dilag kitamu kayti! Manggawa kamin tatluy atêp. Giha para kayu, gihay para kan Moises, gihay para kan Elias!” ");
INSERT INTO abc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nanunghung nay ati ta ha subran limu la, ah na tanday kanan sabin. ");
INSERT INTO abc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pagkayari, tinakpan hilan ulap. Buy mayin hilan nalêngêy busisaꞌ nangibat ha ulapaꞌ nannunghung. “Atiyaꞌ minamaal kun anak. Panlêngꞌan yu ya!” ");
INSERT INTO abc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Agad hilan namalay ha paligid nuwa alay na hilan naakit nu alwan hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hin palunghunanaꞌ hila ha bungꞌuy, kinanunghung hilan Apu Jesus, “Ah yu sabinaꞌ naakit yu ha hitalagyuman anggan hakuy nangibat ha langitaꞌ Inꞌanak Tawuy ahê pun nabyay uman.” ");
INSERT INTO abc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kaya ah la innunghung ha hitalagyumanaꞌ pangyayarin ban tu. Hin kakapad lay na, ninununghung mêt hila nu hita labay nan nunghungun ha pagkabyay uman. ");
INSERT INTO abc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nagtanung hila kan Apu Jesus, “Angkaya innunghung tawtagapanudun kautuhanaꞌ magbalik pun hi Elias bayu lumatêngaꞌ Criston impangakun Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tinumbay ya kanla, “Pêtêgaꞌ habayin, kaylangan pun makalatêngaꞌ dapay kan Elias takayꞌêmên ihanday laataꞌ bagay. Nuwa sabin ku kayu, ‘Pêtêgaꞌ inlumatêngana hi Elias buy ginawan tawtawuy labay lan gawꞌên kana, dapay mêt ha nakasulat tungkul kana ha kasulatan.’ Nuwa, antakaya nasusulat mêt, hakuy nangibat ha langitaꞌ Inꞌanak Tawuy magtiis dêlan irap buy itakwil tawtawu?” ");
INSERT INTO abc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Paglatêng lan Apu Jesus ha kanayun nan tawtagahunul, naakit lan dêlan tawuy nititipun baistu. Dilag mêt baistuy umnuy tawtagapanudun kautuhan, nakikiribati ha tawtagahunul Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hin naakit la hi Apu Jesus, nalgangaꞌ tawtawu buy palukhung nagdani ta namati kana. ");
INSERT INTO abc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tinanung Apu Jesus ya tawtagahunul na, “Hita pinagriribatian yu?” ");
INSERT INTO abc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mayin gihay liyaking tinumbay, “Mistru, gintan ku kayti ya anak kun liyaki ta pinapipi yan anitu. ");
INSERT INTO abc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu sinusuklutan yan anitu, natutumba ya, nagbubulay bêbêy na, nangêngêrtêkêtaꞌ ngêpên na buy naninigasaꞌ buun nawini na. Nakinunghungaku ha tagahunul yun paalihin lay anitu nuwa ah la kaya.” ");
INSERT INTO abc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ambalan Apu Jesus kanla, “Hakawung lawlahin alan pananampalataya! Anggan makanuwaku pun magtiis kayu? Gitan yu kaytiya anak.” ");
INSERT INTO abc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaya gintan lay anak kan Apu Jesus. Nuwa, hin naakit anitu hi Apu Jesus, pinamêgpêg nay anak buy binumagsak ha luta, pinagulung gulung buy binubumulay bêbêy. ");
INSERT INTO abc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tinanung Apu Jesus ya bapan anak, “Nakanu ya pun nagkapakun?” Tinumbayaꞌ bapa, “Ibat pun hin makayêk ya. ");
INSERT INTO abc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma dalas yan intutumban anitu ha apuy buy ha lanêm takayꞌêmên mapati ya. Nuwa nu mayin kawun magawa, kaingalwan yu kami!” ");
INSERT INTO abc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tinumbay kana hi Apu Jesus, “Antakaya mu innunghung, nu mayin nakun magawa? Hay laataꞌ bagay magawa ha tawung mayin pananampalataya kangku.” ");
INSERT INTO abc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tinumbay agadaꞌ bapan anak, “Nananampalataya haku kayu, nuwa kulang pun. Dagdagan yu punaꞌ pananampalataya ku kayu!” ");
INSERT INTO abc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hin maakit Apu Jesus ya kinukumadlay nay tawung inlulumatêng, pinannunghungan nay anitu buy ambala, “Hakan anituy nagpapapipi buy nagpapabingi ha anakaꞌ ati, inuutuhan katan magꞌalih kana. Ah kay na magbalik kana!” ");
INSERT INTO abc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nagbungꞌuy anitu, pinamêgpêgaꞌ anak bayu nagꞌalih. Nambuh natiyaꞌ anak. Kaya ambalan kadlan, “Nati yay na!” ");
INSERT INTO abc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nuwa dinukpan Apu Jesus ya gamêt anak buy impaêdêng na. Nêdêngaꞌ anak. ");
INSERT INTO abc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hin nagpahuk hilan Apu Jesus ha biyagaꞌ inuulian la, tinanung yan tawtagahunul na, hin kakapadlay na, “Angkaya ah yan mapaalihaꞌ anitu?” ");
INSERT INTO abc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tinumbay kanla hi Apu Jesus, “Hay habatuy kalasin anitu, panalangin diliyaꞌ makapagpaalih kana.” ");
INSERT INTO abc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nagꞌalih hila ha rugal bantu buy dinuman ha prubinsiyan Galilea. Ahê labay Apu Jesus ya matandan tawtawung dilag ya istu ");
INSERT INTO abc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta tinutuduwanan nay tawtagahunul na. Ambala na kanla, “Hakuy nangibat ha langitaꞌ Inꞌanak Tawuy ipakabili ha tawtawu. Patin la ku nuwa mabiyayakun uman pagkalibah tatluy allêw.” ");
INSERT INTO abc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nuwa alwa lan natêbêkaꞌ ambala na buy nalimu hilan magtanung kana. ");
INSERT INTO abc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nakalatêng hila ha banwan Capernaum. Buy hin dilagana hila ha biyag, tinanung hilan Apu Jesus, “Hitalagyun pinagriribatian yu nangun ha diyan?” ");
INSERT INTO abc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Alwa hilan sinumagut ta hay pinagriribatian la nu hitalagyuy pinakadakila kanla. ");
INSERT INTO abc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kaya nitnu hi Apu Jesus ta binawêgaꞌ labinluway tagahunul buy ambala kanla, “Hitalagyuman kayuy labay magin pinakadakila ha laat, dapat magpakayêpa buy magin lingkud laat.” ");
INSERT INTO abc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nangwa hi Apu Jesus gihay makayêkaꞌ anak buy pinaêdêng ha gitna la. Inampun nay ati ta innunghung na kanla, ");
INSERT INTO abc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nu hitamanaꞌ mananggap ha anakaꞌ dapay ati ha pananampalataya na kangku, dapay hakuy nay tinanggap na. Buy hitamanaꞌ mananggap kangku, alwan hakun diliyaꞌ tinanggap na nu alwan hay naysugu mêt kangku.” ");
INSERT INTO abc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ambalan Juan kan Apu Jesus, “Mistru, nakaakit kamin tawung namamaalih anitu ha lagyu yu. Binawalan yan hiya ta alwa tamu yan kaawyun.” ");
INSERT INTO abc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nuwa ambalan Apu Jesus, “Ah yu ya bawalan ta alan nanggagawan himala ha lagyu ku bayu mannunghung malaêt tungkul kangku. ");
INSERT INTO abc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hay alwan laban kantamu, kagampi tamu. ");
INSERT INTO abc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pakalêngꞌên yuy inunghung ku kayu, hitamanaꞌ mamꞌin gihay basun lanêm kayu ta hakuy Criston hinuhunul yu, siguradun makakuwan gantimpala.” ");
INSERT INTO abc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nuwa hitalagyumanaꞌ pinangibatan pagkakasalan gihay makayêkaꞌ anakaꞌ nanampalataya kangku, mangêd punaꞌ itagkêh ha bêng nay mamhakaꞌ batu ta itambuk ya ha dagat. ");
INSERT INTO abc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nu gamêtaꞌ pinangibatan kamung pagkakasalaꞌ, putuhun mu! Mangêd punaꞌ gigihay gamêt mun magpahuk ha langitaꞌ mayin biyay ya alan anggan kisira ha luway gamêt mu nuwa maku kay naman ha impirnu, nu haantuy alan kamatiyanaꞌ apuy.” ");
INSERT INTO abc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Nu bitih muy namanaꞌ pinangibatan pagkakasalaꞌ, putuhun mu! Mangêd punaꞌ gihay bitih mun magpahuk ha langitaꞌ mayin biyay ya alan anggan kisira ha luway bitih mu nuwa itambuk kay naman ha impirnu.” ");
INSERT INTO abc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nu hay mata muy pinangibatan pagkakasalaꞌ, dukutun mu! Mangêd punaꞌ gigihay mata mun magpahuk ha langitaꞌ mayin biyay ya alan anggan kisira ha luway mata mu nuwa itambuk kay naman ha impirnu. ");
INSERT INTO abc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Baistu ha impirnu, hay libun êwêl ahê nanati buy hay apuy ahê napapalêng.” ");
INSERT INTO abc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ta balan gihay tawu, makaranas pagꞌiirap dapay kênan ahinan buy êwêkên ha apuy. ");
INSERT INTO abc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mangêd punaꞌ ahin ta malaha, nuwa nu tumabꞌangaꞌ namanaꞌ ati, hita pamalaha yun uman? Iitbuh yuy sarili yu ha ahinaꞌ pamalaha ha sangkatauhan takay magkarun kawun kapayapaan ha gihat giha.” ");
INSERT INTO abc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nagꞌalih hi Apu Jesus ha Capernaum, naku ha prubinsiyan Judea buy nagbatah ya ha Ilug Jordan. Buy baistu, inlaku yan madlan tawu. Dapay mêt daan, nanudu ya kanla. ");
INSERT INTO abc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mayin umnuy Pariseong naku kana taêmên subukan ya. Kaya nagtanung hila, “Pinauulayan kayan kautuhan Moises ya mikihiyayaꞌ liyaki ha kanan ahawa?” ");
INSERT INTO abc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tinanung mêt hilan Apu Jesus, “Hitalagyuy inꞌuutuh kayung Moises?” ");
INSERT INTO abc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tinumbayaꞌ Pawpariseo, “Pinaulayan Moises ya bayu mikihiyayaꞌ liyaki ha kanan ahawa, manggawa ya pun kasulatan pamikihiyay.” ");
INSERT INTO abc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Innunghung kanlan Apu Jesus, “Inꞌibin Moises kayuy kautuhan ban in gawan mangatigasaꞌ u yu. ");
INSERT INTO abc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nuwa ha umpisa punaꞌ inlikhan Apu Diyusaꞌ mundu, ginaway nay liyaki buy babayi. ");
INSERT INTO abc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gawan kayti, ibwatan liyakiyaꞌ kanan mangatuwa ta makiawyun ya ha kanan ahawa. ");
INSERT INTO abc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Buy hilan luway magin giha. Kaya alway na hilan luwa nu alwan giha tana. ");
INSERT INTO abc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaya hay piniawyun Apu Diyus, alwan dapat pihyayên tawu.” ");
INSERT INTO abc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Paglatêng la ha biyag, tinanung hi Apu Jesus tawtagahunul na tungkul ha pamihiyay miahawa. ");
INSERT INTO abc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ambala na kanla, “Nu hiyayan liyakiy kanan ahawa ta magꞌahawan kanayun, nakikitakpi ya buy nagkasala ya ha una nan ahawa. ");
INSERT INTO abc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Habatu mêtaꞌ babayi, nu mikihiyay ya ha kanan ahawa ta magꞌahawan kanayun, nakikitakpi ya mêt.” ");
INSERT INTO abc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gintan tawtawuy mangkayêkaꞌ anak kan Apu Jesus taêmên ipamanuy anak kana buy pagpalaên. Kayan dili, pinagbawalan hilan tawtagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hin naakit Apu Jesus ya nangyari, napuut ya ha tawtagahunul na. Ambala na, “Paulayan yun magdani kangkuy awꞌanak. Andi yu hila pagbawalan ta dapay kanlay pagharian Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pakalêngꞌên yuy inunghung ku kayu, “Hay ahê mananggap ha paghaharin Apu Diyus dapay pagtanggap ha anakaꞌ makayêk, ahê pagharian Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pagkayari, inampun nay awꞌanak, pinamanu buy pinagpala hila. ");
INSERT INTO abc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hin paalihana hi Apu Jesus, mayin gihay liyaking palukhung nagdani kana buy nagluhud. Nagtanung ya, “Mahampataꞌ Mistru, hitalagyuy gawꞌên ku takayꞌêmên magkarunakun biyay ya alan anggan?” ");
INSERT INTO abc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tinumbay hi Apu Jesus, “Angkaya mu tinutula mahampataku? Hi Apu Diyus diliyaꞌ mahampat. ");
INSERT INTO abc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tungkul ha tanung mu, tanda muy innununghung kautuhan. ‘Andi ka mamati. Andi ka makitakpi. Andi ka manakaw. Ah mu papêtêganaꞌ alwan pêtêg. Andi ka mandaya. Igalang muy kamung bapa buy indu.’ ” ");
INSERT INTO abc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sinumagutaꞌ liyaki, “Mistru, ibat hin anakaku pun, hinunul kuy nay laat ban in.” ");
INSERT INTO abc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Binalay yan Apu Jesus ya mayin pagmamaal buy ambala, “Gihay bagay punaꞌ kulang kamu. Muli ka buy ipaghaliw muy laataꞌ kayamanan mu buy ibi muy pira ha mangairap taêmên mabꞌiyan kan kayamanan ha langit. Pagkayari humunul ka kangku.” ");
INSERT INTO abc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Katangih tangihaꞌ liyaki hin nalêngê nay ati. Buy nagꞌalih yan malungkut ta napakayaman na. ");
INSERT INTO abc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Namalay hi Apu Jesus ha paligid buy ambala ha tawtagahunul na, “Napakairap ha mayamanaꞌ magpasakup ha paghaharin Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nagtaka hila ha innunghung Apu Jesus. Nuwa innunghung uman Apu Jesus, “Awꞌanak, napakairap talagan magpasakup ha paghaharin Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas madali pun magpahukaꞌ gihay kamilyu ha lubut karayum kisira ha magpasakupaꞌ mayaman ha paghaharin Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalu pun nagtakay tawtagahunul na kaya nagtanung hila, “Nu habatu, hita pun aludaꞌ miligtas?” ");
INSERT INTO abc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Binalay hilan Apu Jesus buy ambala, “Ahê kayan iligtas tawuy kanan sarili nuwa kayan gawꞌên Apu Diyus ta hitalagyuman, kaya nan gawꞌên.” ");
INSERT INTO abc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ambala kanan Pedro, “Magpakun kamiyaꞌ naman? Inibwatan yananay laat buy hinumunul kami kayu.” ");
INSERT INTO abc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tinumbay hi Apu Jesus, “Pakalêngꞌên yuy inunghung ku kayu. Hay tawung nangibwat biyag, pawpatêl, mangatuwa, awꞌanak u luta dahilan kangku buy ha Mahampataꞌ Balita, ");
INSERT INTO abc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gihandaan bisis nan matanggapaꞌ inibwatan na, kaawyunaꞌ pagꞌiirap, kaban dilag ya pun kayti. Nuwa ha lumatêngaꞌ panawun, mabꞌiyan yan biyay ya alan anggan. ");
INSERT INTO abc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nuwa hay tawung nagpapakatagꞌay hapaêg, lumatêngaꞌ allêw mipakayêpa. Buy hay tawung nipakayêpa hapaêg, hiyay mitagꞌay paglatêng allêw.” ");
INSERT INTO abc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kaban pahukpa hila palakun Jerusalem, nauuna kanla hi Apu Jesus. Nagtakay tawtagahunul na buy nalimuy naman ya kanayunaꞌ hinuhumunul kana. Impaalibun Apu Jesus ya labinluway tagahunul na, ta innunghung nan umanaꞌ mangyari kana. ");
INSERT INTO abc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Manlêngê kawu! Pahukpa kitamuy nan Jerusalem. Ta hakuy nangibat ha langitaꞌ Inꞌanak Tawuy iibi istu ha libun namamaalan pari buy ha tawtagapanudun kautuhan. Hatulan nakun kamatiyan buy iibi ha alwan Judio. ");
INSERT INTO abc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Insultuun la ku, tupayan, paghahampasên buy patin. Nuwa ha ikatluy allêw, mabiyayakun uman.” ");
INSERT INTO abc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nagdani kan Apu Jesus hilan Santiago buy Juanaꞌ anak Zebedeo. Nannunghung hila, “Mistru, mayin kami hanan kayêk labay.” ");
INSERT INTO abc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ambalan Apu Jesus, “Hita labay yu?” ");
INSERT INTO abc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sinumagut hila, “Hana, nu maghari kawuy na, makaitnu kami mêt ha dani yu, giha ha kanan buy giha ha kaliwa.” ");
INSERT INTO abc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nuwa innunghung kanlan Apu Jesus, “Ah yu tanda nu hita impipikikuwa yu. Kaya yu kayan tiisinaꞌ pagdurusan tiisin ku? Kaya yu kayay irapaꞌ danasên ku?” ");
INSERT INTO abc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sinumagut hila, “Awu, kaya yan.” Ambalan Apu Jesus, “Pêtêgaꞌ matiis yuy laataꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kayan dili, alwan hakuy mamili nu hita mitnu ha kanan ku buy ha kaliwa ku. Hay awꞌitnuwanaꞌ ati, para dili ha pinaglaanan kangkun Bapa.” ");
INSERT INTO abc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hin natandan sampuy tagahunul nu hita impipikikuwan mipatêl, napuut hila kan Santiago buy Juan. ");
INSERT INTO abc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaya binawêg Apu Jesus ya laataꞌ tagahunul na, ta innunghung, “Tanda yu, hay intuturing pawpinunun alwan Judio, impapaakit lay kapangyarihan la ha libun tawtawung nasasakupan la. Buy maski hitalagyun labay la, nahuhunul nasasakupan la. ");
INSERT INTO abc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nuwa alwa kawun dapat habatu. Ha halip, hitalagyu kayuy labay magin dakila, dapat magin lingkud yu. ");
INSERT INTO abc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Buy hitalagyuman kayuy labay magin pinunu, dapat magin alipên laat. ");
INSERT INTO abc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Haku bayaꞌ nangibat ha langitaꞌ Inꞌanak Tawuy naku kayti ha luta, alwan hakuy pinaglilingkuran nu alwan hakuy naglingkud kayu. Buy ibi kuy biyay ku takayꞌêmên mahagêp kuy madlan tawu ha kaparusaan.” ");
INSERT INTO abc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inlumatêng hilan Apu Jesus ha banwan Jerico. Buy hin paalih yay na istu, kaawyun nay kanan tawtagahunul buy madla pun kanayun, nadanan lay gihay bulagaꞌ, hi Bartimeo, anak Temeo. Nakaitnu ya ha pingit diyan buy namamalimus. ");
INSERT INTO abc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hin nalêngê nay dinuduman hi Apu Jesus ya tiga Nazaret, nagbubungꞌu ya, “Apu Jesus, lahin Haring David, kaingalwan yu ku!” ");
INSERT INTO abc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Binawalan yan tawtawu, “Tênggên kay na.” Nuwa lalu pun inlumakasaꞌ bungꞌu na, “Apun Haring David, kaingalwan yu ku!” ");
INSERT INTO abc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tinênggên hi Apu Jesus ta innunghung, “Bawgên yu ya.” Kaya binawêg la hi Bartimeo buy innunghung, “Matula ka. Mêdêng ka ta impapabawêg kan Apu Jesus.” ");
INSERT INTO abc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Imbalag Bartimeyoy kanan balabal ta agad nagdani kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tinanung yan Apu Jesus, “Hita labay mun gawꞌên ku kamu?” Tinumbay ya, “Mistru, labay kun makaakit.” ");
INSERT INTO abc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Innunghung Apu Jesus kana, “Pinagaling kay nan kamung pananampalataya, muli kay na.” Nakaakit ya agad bayu hinumunul ya kan Apu Jesus ha diyan. ");
INSERT INTO abc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hin palaku hilan Apu Jesus ha banwan Jerusalem, tinênggên hila ha Bungꞌuy Awꞌulibu, madani ha bawbaryun Betfage buy Betania. Pinaunan Apu Jesus ya luway tagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ambala na kanla, “Maku kawu ha humunulaꞌ baryu. Paglatêng yu istu, maakit yuy gihay bisirun asnu, nakatagkêh, ahê pun nahakyan hitalagyuman. Kalagên yuy ati ta gitan yu kayti. ");
INSERT INTO abc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu mayin magtanung nu angkaya yu kalagênaꞌ asnu, sabin yu kanla, ‘Kaylangan Panginuun ta ibalik yan agad.’ ” ");
INSERT INTO abc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaya, naliyakuy luwa, buy naakit la bayaꞌ asnu ha danin diyanaꞌ nakatagkêh ha luwahan biyag. Hin kinalagan lay ati, ");
INSERT INTO abc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tinanung hilan tawtawung nakaêdêng istu, “Antakaya yu kinakalaga asnu ban in?” ");
INSERT INTO abc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Innunghung lay ambalan Apu Jesus, kaya pinaulayan hilan tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gintan lay asnu kan Apu Jesus, buy sinapinan lan balabalaꞌ bukut asnu bayu naghakay hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Madlan tawuy nayꞌamak kanlan balabal ha diyan. Hay kanayunaꞌ naman, nayꞌamak mêt hawhangan pinutuh la ha bukid. ");
INSERT INTO abc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hay libun nauuna kan Apu Jesus buy hay libun hinuhumunul kanay nagbubungꞌu, “Purihin hi Apu Diyus! Pagpalaên nay impagtan Panginuun! ");
INSERT INTO abc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Buy pagpalaên Apu Diyusaꞌ inlulumatêngaꞌ hari, dapay ha nunu tamung hi Haring David. Purihin tamu hi Apu Diyus ya dilag ha langit!” ");
INSERT INTO abc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Paglatêng Apu Jesus ha Jerusalem, naku ya ha timplu. Tinatamulaw nan mahampataꞌ laataꞌ bagay istu. Gawan payabiyana, naku ya ha Betania, kaawyun nay labinluwaꞌ nan tagahunul. ");
INSERT INTO abc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kinaybukahan, hin nagꞌalih hila ha Betania, binitil hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mayin yan naakitaꞌ malabungaꞌ puun igus. Kaya dinaninan na buy binalay nu mayin tagêy. Nuwa ala yan naakit nu alwan puru dawên, ta ahê pun panawun igus. ");
INSERT INTO abc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Innunghung Apu Jesus ha puun, “Ibat hapaêg, alay nan makaêkan tagêy mu.” Nalêngên tawtagahunul nay habatu. ");
INSERT INTO abc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Paglatêng la ha Jerusalem, naku hi Apu Jesus ha timplu. Naakit nay nagtitinda buy nanyayaliw istu. Kaya intabuy na hila. Impagpapalukub nay lawlamisan mamalit pawpirang alwan tiga istu buy itnuwan nagtitindan kawkalapating inhahandug ha timplu. ");
INSERT INTO abc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Binawalan nay tawtawung nanantan paninda ha timplu. ");
INSERT INTO abc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pagkayari, tinudwanan nay tawtawu istu. Ambala na, “Alwa nan innunghung Apu Diyus ha kasulatan, ‘Hay kangkun biyag, magin biyag dalanginan laataꞌ bansa.’ Nuwa ginawa yun punduan manakaw.” ");
INSERT INTO abc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nabalitꞌan libun namamaalan pari buy tawtagapanudun kautuhanaꞌ ginawan Apu Jesus, kaya nangkap hilan paraan nu pakapakun yan patin. Nuwa nalilimu hila kana ta hinuhumangay libun tawu ha tudu na. ");
INSERT INTO abc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kinayabinan nagꞌalih hi Apu Jesus ha Jerusalem awyun nay tawtagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kinadatunan, hin pabalikanaꞌ hila ibat ha Jerusalem, nadanan lay puun igus ta naakit lay nayanguy nay ati. ");
INSERT INTO abc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naihipan Pedroy nangyari. Kaya innunghung na, “Mistru, balayên yuy puun igusaꞌ insumpa yu. Nayanguy na!” ");
INSERT INTO abc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Innunghung Apu Jesus kanla, “Manalig kawu kan Apu Diyus! ");
INSERT INTO abc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pakalêngꞌên yuy innununghung ku kayu, nu mayin kawun pananalig, maarin nunghungun yu ha bungꞌuyaꞌ ati, ‘Maglipat ka ha dagat!’ Nu ah kawu magluway ihip buy manalig kawun mangyariyaꞌ habatu, mangyari bayaꞌ innununghung yu. ");
INSERT INTO abc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tandaan yuy ati. Hitalagyumanaꞌ ipikikuwa yu ha panalangin, manalig kawun matanggap yuy nay ati ta matanggap yuy na bay. ");
INSERT INTO abc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nu manalangin kawu, patawarên yu punaꞌ nagkasala kayu takayꞌêmên patawarên kaw mêt kayung Bapan hi Apu Diyus ha kayung kawkasalanan. ");
INSERT INTO abc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta nu ah kawu magpatawad, ah kaw mêt patawarên kayung Bapan hi Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Paglatêng la ha Jerusalem, nagbalik hi Apu Jesus ha timplu. Kaban nalliyaliyaku ya istu, nagdani kanay namamaalan pawpari, tawtagapanudun kautuhan buy pawpuun Judio. ");
INSERT INTO abc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Innunghung la kan Apu Jesus, “Hita karapatan mun gawꞌênaꞌ ati ha timplu? Hita namꞌi kamun karapatanaꞌ in?” ");
INSERT INTO abc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tinumbay hi Apu Jesus kanla, “Tanungun kitaw mêt. Nu sagutun yu ku, nunghungun ku mêt kayu nu hita karapatan kun manggawan ati. ");
INSERT INTO abc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Haantun ibataꞌ karapatan Juanaꞌ magbawtismu? Sagutun yu ku, kan Apu Diyus u ha tawu?” ");
INSERT INTO abc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niriribati hila, “Nu sabin tamun ibataꞌ karapatan na kan Apu Diyus, sabin nay naman kantamu, ‘Kaya ah kawu naniwala kan Juan?’ ");
INSERT INTO abc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nuwa nu sabin tamung ibat ha tawu, mapuut kantamuy tawtawu.” (Nalilimu hila ha tawtawu ta naniniwalay laataꞌ hi Juanaꞌ tagapannunghung Apu Diyus.) ");
INSERT INTO abc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaya tinumbay hila, “Alwa yan tanda.” Innunghung Apu Jesus kanla, “Nu habatu, ah ku mêt sabin kayu nu haantun nangibataꞌ karapatan kun manggawan ati.” ");
INSERT INTO abc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nangaral hi Apu Jesus ha tawtawu ha gihay pagꞌiitbuh. Ambala na, “Mayin gihay tawung nagtanêm ubas. Pinabakuran nay habatu buy nagpagawa yan panggêêkan ubas. Nagtayu yan matagꞌayaꞌ biyag pamantayan. Buy pagkayari pinaupahan nay kanan ubasan ha libun manggagahak. Bayu, naku ya ha madayun rugal. ");
INSERT INTO abc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hin panawunanan pamiputin ubas, impalaku nay kanan utuhan ha libun manggagahakaꞌ nangungupaan ha kanan ubasan, takayꞌêmên kuwên nay dakay na. ");
INSERT INTO abc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nuwa kinuyug libun manggagahakaꞌ utuhan na, binugbug, buy pinaalih lan alan pigtan. ");
INSERT INTO abc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Namagtan yan uman gihay utuhan, nuwa impakadêngꞌêy lay ati bayu pinatukaꞌ u. ");
INSERT INTO abc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Namagtan yay namêt giha punaꞌ utuhan. Nuwa pinati lay ati. Madla ya pun impagtan, nuwa binugbug mêtaꞌ kanayun buy pinagpapati mêtaꞌ kanayun.” ");
INSERT INTO abc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Hin kahuli hulianana, ala yay nan maipagtan, kaya impagtan nay pinakamamaal nan anak. Inihip na, ‘Igalang lay anak ku.’ ” ");
INSERT INTO abc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nuwa hin naakit libun manggagahakaꞌ anak na, ambala la, ‘Dilaganay anakaꞌ tagapagmana. Kali kawu patin tamu ya, taêmên mapalaku kantamuy lutang manaên na.’ ");
INSERT INTO abc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaya kinuyug lay anak, pinati buy intambuk ha labas bakuran ubasan.” ");
INSERT INTO abc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pagkayari, nagtanung hi Apu Jesus, “Hitalagyu kayan gawꞌên mayin arin ubasan? Tiyakaꞌ lakwun nay libun manggagahak, ta patin. Pagkayari paupaan nay kanan ubasan ha kanayun. ");
INSERT INTO abc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ah yu nabasay talatan ati ha kasulatan? ‘Hay batun tinanggiyan tagapagpaêdêng biyag, Hiya aludaꞌ batun nagin pundasyun. ");
INSERT INTO abc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Panginuun ya mayin gawan ati, Buy hinuhumangaꞌ kitamu ha ginawa na.’ ” ");
INSERT INTO abc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hin nakaêhêbaꞌ pawpuun Judion hilay mahawun Apu Jesus ya naypaêdêng biyag ha pagꞌiitbuh, labay lan hiyay dakpên nuwa nalimu hila ha tawtawu. Kaya pinaulayan la tana hi Apu Jesus buy nagꞌalih hila. ");
INSERT INTO abc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Impalakun pawpuun Hawjudio kan Apu Jesus ya umnuy Pawpariseo buy umnuy tauhan Herodes, ta lêngꞌên la hiya takayꞌêmên madakêp ha sabin na. ");
INSERT INTO abc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nagdani hila buy ambala kana, “Mistru, tanda yana pêtêgaꞌ libun innununghung yu buy ala kawun kinakampian ta ah kawu namamalay ha katayuan gihay tawu nu alwan hay intutudu yuy nu hitalagyuy kapêtêgan tungkul ha kaluuban Apu Diyus. Hapaêg, tama kayan hakitamun Hawjudioy magbayad buwis ha Haring Roma? Dapat kitamu kayan magbayad u ahê?” ");
INSERT INTO abc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nuwa tandan Apu Jesus ya nagkakanwari hila, kaya innunghung na, “Kaya yu ku sinusubukan ha tanung yun in? Mantan kawu paraw pira haati ta balayên ku.” ");
INSERT INTO abc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nantan hilan pira kan Apu Jesus. Nagtanung hi Apu Jesus, “Hita nagdampal buy naglagyun nanaakit yu ha pirang ti?” Tinumbay hila, “Ha Haring Roma!” ");
INSERT INTO abc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kaya ambalan Apu Jesus kanla, “Ibi yu ha Haring Romay kana, buy ibi yu kan Apu Diyus ya kana.” Hinumangaꞌ hila ha kanan sagut. ");
INSERT INTO abc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mayin gihay grupun Hawjudio nu bawgêniꞌ Saduceo. Nagdani kan Apu Jesus buy nagtanung. (Hay libun tawung ati, ahê naniniwala ha pagkabiyay uman.) ");
INSERT INTO abc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ambala la, “Mistru, ha batas insulat Moises, nu mati ya gihay liyaking alan anak ha kanan ahawa, hay nabalꞌu dapat pakasalan bayaw na, taêmên magkaanak hilan para ha ahawa nan nati.” ");
INSERT INTO abc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Hapaêg, mayin pitun mipapatêlaꞌ kaliyakiyan. Nagꞌahaway panganay buy nati yan alan anak. ");
INSERT INTO abc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kaya hay balꞌu napagꞌahawan kabuhwan, nuwa nati mêtaꞌ kabuhwan alan anak. Habatu mêtaꞌ nangyari ha ikatlun patêl ");
INSERT INTO abc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","angga ha ikapitu. Naubuh hilan nating ala hilan anak ha babayi. Buy ha kahuli hulian, nati mêtaꞌ babayi. ");
INSERT INTO abc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hapaêg, ha allêw pagkabiyay uman nangamamati, hitalagyuy magin tunayaꞌ ahawa na ha pituy kaliyakiyanaꞌ mipapatêl?” ");
INSERT INTO abc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tinumbay hi Apu Jesus, “Maling mali kawu. Ta ah yu natêtêbêkaꞌ kasulatan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta ha pagkabiyay uman, alay nan pagꞌaahawa. Dapay mêt hilan awꞌanghil ha langitaꞌ alwan magꞌahawa. ");
INSERT INTO abc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tungkulaꞌ naman ha pagkabiyay uman, ah yu nabasay insulat Moises? Hin dilag hi Moises ha nagliliyabaꞌ mayêpang puun kayu, ambala kanan Apu Diyus, ‘Hakuy Apu Diyus lan Abraham, Isaac buy Jacob.’ ");
INSERT INTO abc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hay labay nunghungun, nanabiyay pun hila. Ta alwa yan Apu Diyus nawnati nu alwan Apu Diyus yan bawbiyay. Kaya maling mali kawu.” ");
INSERT INTO abc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mayin gihay tagapanudun kautuhan baistu, nanlêlêngên pagriribatian la. Nalêngê nan mahampataꞌ sagut Apu Jesus, kaya nagdani ya ta nagtanung mêt, “Hitalagyu kayay pinakamaalagan utuh?” ");
INSERT INTO abc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tinumbay hi Apu Jesus, “Ati ya pinakamaalagan utuh. ‘Lêngꞌên yuy ati, libun taga Israel. Hay Panginuun tamun Diyus, kagiha gihay Panginuun, ala yan katbuh. ");
INSERT INTO abc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kaya maalên muy kamun Panginuun Diyus, buung pusu, buung kalulwa, buung ihip, buy buung lakas.’ ");
INSERT INTO abc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Buy pangalaway ati, ‘Maalên muy kaparihu mu dapay pagmamaal mu ha sarili mu.’ Alay nan kanayunaꞌ utuh higit pun maalaga kisa ha luwan ti.” ");
INSERT INTO abc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ambalan tagapanudun kautuhan, “Mistru, pêtêgaꞌ innunghung yu. Gigihan diliyaꞌ Apu Diyus buy maliban kana, alay nan kanayun. ");
INSERT INTO abc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Buy kaylangan, maalên yan buung pusu, buung ihip buy buung lakas. Kaylangan tamu mêt maalênaꞌ kantamun kaparihu dapay pagmamaal tamu ha kantamun sarili. Higitaꞌ maalagay ati kisa ha laat kalasin handugaꞌ inêêwêk buy kanayun pun libun handug.” ");
INSERT INTO abc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hin nalêngên Apu Jesus ya mayin katalinuanaꞌ libun sagut na, ambala kana, “Madani kay nan mipasakup ha paghaharin Apu Diyus.” Ibat hin hatu, alay nan naglakas luubaꞌ magtanung kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hin nanunudu hi Apu Jesus ha timplu, tinanung nay tawtawu, “Angkaya innununghung tawtagapanudun kautuhanaꞌ hay Criston impangakun tagapagligtas, lahin dili kanun Haring David? ");
INSERT INTO abc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pan hi Haring David mêtaꞌ nannunghung ha patnubay Ispiritun Apu Diyus, ‘Ambalan Apu Diyus kan Criston Panginuun ku, “Mitnu ka ha kanan ku, Angga ha mapasuku ku kamuy kamun kawkapati!” ’ ");
INSERT INTO abc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hapaêg, nu binawêg Haring David Panginuun ya Cristo, pakapakun yan nagin lahi dilin Haring David?” Naliliway libun tawu ha panlêlêngê kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ambala pun Apu Jesus ha kanan panunudu, “Magꞌingat kawu ha tawtagapanudun kautuhan. Labayaꞌ labay lan mamasyalaꞌ nakasuut barun panudu. Buy labayaꞌ labay lan batiin hila ta igalang ha matawung rugal. ");
INSERT INTO abc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Labay lan mitnu ha itnuwan pandangal ha biyag pamititipunan Hawjudio buy ha libun handaan. ");
INSERT INTO abc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inluluku lay bawbalꞌu takay makuwa lay ari arian libun ati. Buy kinakadangan lay panalangin la ta impapaakit lan mahampat hila. Kaya mas mabiyataꞌ parusan tanggapên la.” ");
INSERT INTO abc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nitnu hi Apu Jesus ha danin pamiantiyan alay baistu ha timplu buy binabalay nay tawtawung naynanabun alay. Madlan mangayamanaꞌ naynabun mangamhakaꞌ alaga. ");
INSERT INTO abc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mayin gihay mairapaꞌ balꞌu baistun nagdani buy naynabun luway barya. ");
INSERT INTO abc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Binawêg Apu Jesus ya tawtagahunul na ta innunghung, “Pakalêngꞌên yuy inunghung ku kayu, mas mamhakaꞌ inꞌibin balꞌu kisa ha inꞌibi lan laat. ");
INSERT INTO abc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta hilan laat namꞌin dilin subran pira la. Nuwa hay balꞌu, inꞌibi nan laataꞌ panyaliw nan maêkan na.” ");
INSERT INTO abc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hin paalihana hilan Apu Jesus ha timplu, ambalan giha ha tawtagahunul na, “Mistru, balayên yuy pagkagawan bawbiyagaꞌ nakapagitnay timplu! Mangamhakaꞌ batu buy mangamhakaꞌ bawbiyag.” ");
INSERT INTO abc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ambalan Apu Jesus kana, “Nanakit yuy mangamhakaꞌ biyagaꞌ in. Nuwa lumatêngaꞌ panawun, matibagaꞌ laataꞌ ati, alan mitlay magkapatungaꞌ batu!” ");
INSERT INTO abc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kaban nakaitnu hi Apu Jesus ha Bungꞌuy Awꞌulibu, nakaarap ya ha timplu, tinanung yan lihim lan Pedro, Santiago, Juan buy Andres, ");
INSERT INTO abc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sabin yu paraw kanyan nu makanun mangyariyaꞌ innunghung yu buy hita palatandaanaꞌ madani yanan mangyariyaꞌ laataꞌ ati?” ");
INSERT INTO abc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kaya ambalan Apu Jesus kanla, “Magꞌingat kawu taêmên ah kawu mailêtêp hitalagyuman. ");
INSERT INTO abc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta madlan lumatêng buy mannunghungaꞌ, ‘Hakuy Cristo!’ Buy madla hilan mailêtêp. ");
INSERT INTO abc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nu makalêngê kawun gira ha madani kayu buy makabalita kawun gira ha madayu, ah kawu malimu. Dapat dilin mangyariyaꞌ habayin, nuwa alwa pun habatiyaꞌ katapusan mundu. ");
INSERT INTO abc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta milalabanaꞌ bawbansa buy milalaban mêtaꞌ kawkaharian. Magdayun ha iba iban rugal buy lumatêngaꞌ tagbitil. Hay libun ati, pasimulan dilin kairapanaꞌ lumatêng.” ");
INSERT INTO abc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Magꞌingat kawu, ta ha paghunul yu kangku, dakpên kawu, gitan kawu ha hukuman buy pagpapaluhun kawu ha biyag pamititipunan Hawjudio. Iarap kawu ha gawgubirnadur buy hawhari ta pagtatanungun kawu. Pagkakatawun yuy nay ati taêmên mapapêtgan yuy tungkul kangku. ");
INSERT INTO abc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bayu lumatêngaꞌ katapusan, dapat pun maipangaral ha laat bansay Mahampataꞌ Balita tungkul kangku.” ");
INSERT INTO abc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Nu dakpên kawu ta iarap kawu ha hukuman, ah kawu malimu nu hitalagyun nunghungun yu. Basta sabin yun diliy inunghung Ispiritun Apu Diyus ha uras bantu. Ta alwan hakawuy mannunghung nu alwan hay Ispiritun Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ha panawunaꞌ tu, ibin patêlaꞌ sarili lan patêl ta ipapati. Habatu mêtaꞌ bawbapa ha kanlan awꞌanak buy hay awꞌanak ha kanlan mangatuwa. ");
INSERT INTO abc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kapuutan kawun laat gawan ha paghunul yu kangku. Nuwa hay manatili kangkun tapat angga ha katapusan, habatuy miligtas.” ");
INSERT INTO abc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ambala pun Apu Jesus, “Maakit yuy kasuklamꞌsuklamaꞌ lumatêng, kaya intayak lay timplu. Impaêdêng lay ati ha rugalaꞌ alwan dapat pinaypaêdêngan. (Hakawung namamasa, pakaihipin yuy ati!) Nu mangyari yanay ati, dapat magtakahanay tawtaga Judea ha kabungꞌuyanan. ");
INSERT INTO abc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hay dilag ha uhbung biyag andiyana magpahuk mangwan hitalagyuman. ");
INSERT INTO abc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hay dilag ha gahak andiyana mulin mangwan baru. ");
INSERT INTO abc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Makaingaluy mangabuktut buy kawkulawan ha allêwaꞌ tu ta mairapan hilan magtakah. ");
INSERT INTO abc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipanalangin yuy andi hana mangyariyaꞌ ati ha panawun taglayꞌêp. ");
INSERT INTO abc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kasi ha panawun bantu, makadanas pagꞌiirapaꞌ tawtawung alwa pun nadadanasan ibat hin inlikhan Apu Diyus ya mundu angga hapaêg. Buy alay nan madanasaꞌ habatun pagꞌiirap makanuman. ");
INSERT INTO abc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nu alwan paêpêkên Apu Diyusaꞌ panawun bantu, alay nan mitlay mabyay. Nuwa alangꞌalang ha kanan pawpinili, pinaêpêk nay panawun bantu.” ");
INSERT INTO abc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nu mayin mannunghung kayung, ‘Dilag kaytiya Criston impangakun Apu Diyus!’ u ‘Dilag ya istu!’, ah kawu maniwala ");
INSERT INTO abc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ta lumtawaꞌ tubhunaꞌ Cristo buy tubhunaꞌ tagapannunghung Apu Diyus. Magpakit hilan hawhimala buy libun makapagtaka taêmên mamilêtêp. Nu maari, pati pawpinilin Apu Diyus magin kana. ");
INSERT INTO abc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaya magꞌingat kawu! Impapatanda kuy na kayuy ati kaban ahê pun nangyayari.” ");
INSERT INTO abc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pagkayarin allêwaꞌ tun matindin kairapan, magmadlêmaꞌ allêw, ahêy na maghawangaꞌ buyan. ");
INSERT INTO abc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Buy mangananabuy bawbêtêwên ibat ha langit. Mangatêgêy libun nanaakit ha langit buy mawala ha kanla kanlan puwistu. ");
INSERT INTO abc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Buy maakit lan hakuy nangibat ha langitaꞌ Inꞌanak Tawuy malatêngaꞌ nakahakay ha ulap, dilag kangkuy matagꞌayaꞌ kapangyarian buy kahawangan. ");
INSERT INTO abc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ipagtan kuy awꞌanghil ku ha laat rugal ha mundu taêmên tipununaꞌ pawpinili ku.” ");
INSERT INTO abc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Unawaên yuy aral ha puun igus. Nu magkadawênanay hawhangan igus, tanda yuy madani yanay pamitubun tanêm. ");
INSERT INTO abc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Habatu mêt nu mangyariyaꞌ libun innununghung kun ati kayu, matandan yuy madani hakuy nan lumatêng. ");
INSERT INTO abc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pakalêngꞌên yuy inunghung ku kayu, matupadaꞌ laataꞌ ati bayu mangamamatiyaꞌ tawtawu ha panawunaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hay langit buy lutay mayin angganan, nuwa hay libun nunghung kuy alan angganan.” ");
INSERT INTO abc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tungkul ha allêw u urasaꞌ kangkun pagbabalik, alan nakakatandan ati maski libun anghil ha langit u haku manaꞌ Anak Apu Diyus. Hay Bapan diliyaꞌ nakakatandan ati. ");
INSERT INTO abc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaya magꞌingat kawu buy maghanda ta ah yu tanda nu makanu hakun lumatêng.” ");
INSERT INTO abc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Maari atin iitbuh ha gihay tawung naku ha madayun rugal. Bayu ya nagꞌalih ha biyag, binyanan nay nan kanya kanyan tarabahuy kanan awꞌutuhan ta pinagbilinan nay guwardiya ha pintuan, ‘Magin handa ka ha kangkun paglatêng.’ ” ");
INSERT INTO abc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kaya magin handa kawu ta ah yu tanda nu hakun nagbiyag makanun lumatêng, maarin hapun, ha malalêy yabi, ha hawang hawang, u ha datu. ");
INSERT INTO abc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dat bigla kun lumatêng, malatngan katawun natutuluy. ");
INSERT INTO abc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kaya hay innununghung ku kayu, habatu mêtaꞌ innununghung ku ha laat, ‘Magin handa kawu!’ ” ");
INSERT INTO abc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Luway allêw tana bayu lumatêngaꞌ Allêw Pagꞌalaalan Kaligtasan ha Pagꞌiirap buy Kamatiyan buy Allêw Tinapayaꞌ Alan Pampaalsa. Hay libun namamaalan pari buy tawtagapanudun kautuhan, nanangkap hilan pagkakatawun taêmên lihim lan maipadakêp buy maipapati hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ambala la, “Andi tamu gawꞌên ha Allêw Pagꞌalala, lumbutaꞌ magkaguluy tawtawu.” ");
INSERT INTO abc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hin dilag hi Apu Jesus ha Betania, kaban nanangan ya ha biyag Simonaꞌ daan mayin matindin hakit ha balat, inlumatêngaꞌ gihay babayi. Mayin yan pigtanaꞌ mamaalênaꞌ pabangu. Hay pamiantiyan gawa ha batun alabastro. Hay pabangung ati, puru ibat ha katas halamanaꞌ nardu. Binahak nay bêng pamiantiyan pabangu bayu imbunlug nay pabangu ha un Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Napuutaꞌ umnuy tawu istu. Ambala la, “Angkaya na sinasayangaꞌ pabangung in? ");
INSERT INTO abc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Naipaghaliw hanay habayin ha mamhakaꞌ alaga, katumbas gihan tawunaꞌ suwildu. Naiibi hana ha mangairap.” Buy kinapuutan lay babayi. ");
INSERT INTO abc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nuwa ambalan Apu Jesus, “Paulayan yu ya. Angkaya yu ya ginugulu? Mahampataꞌ atiyaꞌ ginawa na kangku. ");
INSERT INTO abc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hay libun mangairap panay yun makaawyun buy maari kawun tumulung kanla maski hitalagyun uras. Nuwa haku, ah yu ku panay makaawyun. ");
INSERT INTO abc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginawa nay makaya nan gawꞌên na para kangku. Binunlugan nay nawini kun pabangu taêmên ipauna nay paghahanda ha kangkun pagꞌêlbêng. ");
INSERT INTO abc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pakalêngꞌên yuy inunghung ku kayu, haantu man ipangaralaꞌ Mahampataꞌ Balita ha buung mundu, ipamalita mêtaꞌ ginawa nan ati kangku taêmên ah ya maliwanan.” ");
INSERT INTO abc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hi Judas Iscariote, giha ya ha tawtagahunul Apu Jesus. Naku ya ha libun namamaalan pari takayꞌêmên makipagkasundun ipakabili hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hin natandan lay pakay Judas, natula hila buy nangaku hilan biyan yan pira. Kaya ibat hin habatu, nagꞌihip yay na, nu pakapakun nan ipakabili hi Apu Jesus kanla. ");
INSERT INTO abc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Inlumatêngaꞌ unan allêw ha Allêw Tinapayaꞌ Alan Pampaalsa. Atiyaꞌ allêw paghahandug tupan kikinan ha Allêw Pagꞌalaalan Kaligtasan ha Pagꞌiirap buy Kamatiyan. Kaya tinanung hi Apu Jesus tawtagahunul na, “Haantu yu labay kamin maghandan apunan para ha Allêw Pagꞌalaalan Kaligtasan?” ");
INSERT INTO abc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Inutuhan nay luwa ha kanan tagahunul, “Maku kawu ha banwan Jerusalem ta baistu mayin manyalubung kayuy gihay liyaki, mipapasan bangan lanêm. Hunulun yu ya ha biyagaꞌ pahukan na, buy sabin yu ha mayin biyag, ‘Impapatanung Mistru nu haantun kuwartu yan mangan apunan awyunaꞌ tawtagahunul na ha Allêw Pagꞌalaalan Kaligtasan.’ ");
INSERT INTO abc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Itudu na kayuy gihay mamhakaꞌ kuwartu ha tagꞌay, kumplituy nan kagamitan buy nakahanday na. Istu kawun maghandan apunan tamu.” ");
INSERT INTO abc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nagꞌalihaꞌ luwa nan tagahunul. Buy hin inlumatêng hila ha banwa, naakit lay laataꞌ innunghung Apu Jesus kanla. Buy inhanda la istuy apunan para ha Allêw Pagꞌalaalan Kaligtasan. ");
INSERT INTO abc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kinayabinan, inlumatêng hi Apu Jesus awyunaꞌ labinluway tagahunul na. ");
INSERT INTO abc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kaban nanangan hilay na ha lamisa, ambalan Apu Jesus kanla, “Pakalêngꞌên yuy ati. Giha kayuy kaawêm ku ha panganan, maypakabili kangku.” ");
INSERT INTO abc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hin nalêngê lay habatu, nalungkut hila. Gihaꞌgiha hilan nagtanung kana, “Mistru, alwan hakuy habatu, ani?” ");
INSERT INTO abc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ambalan Apu Jesus kanla, “Giha kayu ha labinluway kaawyun kun maysawsaw tinapay ha tasa. ");
INSERT INTO abc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta dilag ha kasulatan, hakuy nangibat ha langitaꞌ Inꞌanak Tawuy patin. Nuwa makaingaluy tawung maypakabili kangku. Mangêd pun ban, ah yay na impanganak.” ");
INSERT INTO abc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaban nanangan hila, nangwan tinapay hi Apu Jesus, nagpasalamat ya kan Apu Diyus buy pinagbihꞌil bihꞌil nay ati bayu inꞌibi na ha libun tawtagahunul na. “Kuwên yuy ati ta kanên yu, ati ya kangkun nawini.” ");
INSERT INTO abc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagkayari, nangwa yan inêmên, nagpasalamat kan Apu Diyus, inꞌibi na kanla bayu ninêm hilan laat. ");
INSERT INTO abc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ambala na kanla, “Ati ya kangkun daya, ibunlug ku para ha pagtubus kasalanan dêlan tawu. Atiyaꞌ mamapêtêg pangakun Apu Diyus ha tawtawu.” ");
INSERT INTO abc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Pakalêngꞌên yuy ati, ah kuy na mênêm uman alakaꞌ ibat ha katas ubas angga ha lumatêngaꞌ paghaharin Apu Diyus. Ha allêw bantu, mênêmakun bayun kalasin ênêmên.” ");
INSERT INTO abc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nagkantaan hilan papuri kan Apu Diyus bayu naku hila ha Bungꞌuy Awꞌulibu. ");
INSERT INTO abc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Innunghung Apu Jesus ha tawtagahunul na, “Innunghung Apu Diyus ha kasulatan, ‘Patin kuy pastul ta mimihiyayaꞌ tawtupa.’ Matupadaꞌ ati ta piibwatan yu kun laat. ");
INSERT INTO abc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nuwa pagkayari kun mabyay uman, mauna ku kayu ha prubinsiyan Galilea.” ");
INSERT INTO abc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Innunghung Pedro kan Apu Jesus, “Ibwatan kawu man laat, nuwa haku ah katawu ibwatan.” ");
INSERT INTO abc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tinumbay hi Apu Jesus kana, “Pakalêngꞌên yuy inunghung ku kayu, bayu manalangꞌayaꞌ manuk luway bisis ha yabin ti, tatluy bisis mu kun ipuglaun kilala mu ku.” ");
INSERT INTO abc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nuwa impagpilitan Pedro, “Ah katawu talaga ipuglau, maski patinaku punaꞌ awyun yu.” Habatu mêtaꞌ innunghung laat nan kaawyun. ");
INSERT INTO abc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pagkayari, naku hila ha rugalaꞌ Getsemane. Paglatêng la istu, innunghung Apu Jesus kanla, “Mitnu kawu haati kaban manalanginaku.” ");
INSERT INTO abc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inꞌawyun na hi Pedro, Santiago buy Juan. Nababaala ya ta tinatagam nay na ya mangyari kana. ");
INSERT INTO abc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Innunghung na kanla, “Dapayakun mati ha lungkut. Haati kawun dili, ah kawu matuluy.” ");
INSERT INTO abc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nagpakadayu yan bagya, ta nagluhud buy nanalangin, “Nu maari hana, ah kuy na danasinaꞌ pagꞌiirapaꞌ lumatêng kangku.” ");
INSERT INTO abc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Innunghung na, “Bapa, magawa yuy laataꞌ bagay. Nu maari ipakadayu yu kangkuy pagꞌiirapaꞌ atiyaꞌ lumatêng. Nuwa alwan labay kuy mahunul nu alwan labay yu.” ");
INSERT INTO abc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pinagbalikan Apu Jesus ya tatluy tagahunul na ta nalatngan nan natutuluy. Innunghung na kan Pedro, “Simon, natutuluy kaw pun? Ah kawu makapagpuyat maski gihay uras dili?” ");
INSERT INTO abc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ta innunghung na kanla, “Magpuyat kawu ta manalangin taêmên ah kawu maguluy tuksu. Hay nakêm yu labay lumaban ha tuksu, nuwa hay nawini maina.” ");
INSERT INTO abc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nagpakadayuy namêt hi Apu Jesus ta nanalangin yan uman, dapay ha una nan panalangin. ");
INSERT INTO abc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkayari, pinagbalikan nan umanaꞌ tawtagahunul na. Nalatngan nay namêt hilan natutuluy ta bêlêw bêlêwên hilan tandah. Hin napukaw hila, ah la tanda nu hita nunghungun la kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Buy nanalangin yan uman. Ha pangatlun pagbalik Apu Jesus, innunghung na kanla, “Natutuluy kaw pun buy nagpapahinga? Tamay nay habayin! Lumatênganay urasaꞌ hakuy nangibat ha langitaꞌ Inꞌanak Tawuy iibi ha makasalanan. ");
INSERT INTO abc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mibwat kitamuy na, halubungun tamu hila! Dilaganay maypakabili kangku.” ");
INSERT INTO abc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nannununghung pun hi Apu Jesus, biglan inlumatêng hi Judas ya giha ha labinluway tagahunul na. Madla yan awyunaꞌ armadun ispada buy pamaluh. Sinugu hilan namamaalan pari buy tawtagapanudun kautuhan buy pawpuun Judio. ");
INSERT INTO abc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Namꞌin palatandaan ha mandakêp kan Apu Jesus hi Judas ya naypakabili kana. Ambala na, “Nu hita daninan ku ta halikan ku, habatuy dakpên yu. Gitan yu buy ah yu paulayan makatakah.” ");
INSERT INTO abc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaya hin inlumatêng hi Judas, agad yan nagdani kan Apu Jesus. Kinanunghung na, “Mistru!”, bayu na hinalikanaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Agad dinakêp hi Apu Jesus tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nangublut ispaday gihay tagahunul Apu Jesus ta tinabtab nay gihay alipên puun pari, buy nalaplapaꞌ têk ati. ");
INSERT INTO abc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ambalan Apu Jesus ha libun nandakêp kana, “Tulisanaku kaya bay ta nipantan kawun ispada buy pamaluh takayꞌêmên dakpên yu ku? ");
INSERT INTO abc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Allêw allêwakun dilag ha timplu ta nanunudu buy dilag kaw mêt baistu. Angkaya ah yu ku dinakêp? Nuwa kaylangan mangyariyaꞌ ati taêmên matupadaꞌ innununghung ha kasulatan tungkul kangku.” ");
INSERT INTO abc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hin habatu mêt, inibwatan yan tawtagahunul na buy nipagtakah hila. ");
INSERT INTO abc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mayin gihay binata baistu, nanghunul kan Apu Jesus, nakabalabal yan dilin tilan linu. Dinakêp ya mêt tawtawu, ");
INSERT INTO abc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nuwa ha pagtakah na, nadukpan lay kanan balabal, kaya inlumukhu yan hubad. ");
INSERT INTO abc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gintan la hi Apu Jesus ha biyag puun pari. Nititipun baistuy laat namamaalan pari, pawpuun Judio buy tawtagapanudun kautuhan. ");
INSERT INTO abc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hinumunul mêt baistu hi Pedro nuwa madayu yan bagya kan Apu Jesus. Nagpahuk ya ha bakuran puun pari, nikiitnu ya ha gawguwardiya buy nagpakyang ya ha danin apuy. ");
INSERT INTO abc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Baistu ha luub, hay libun namamaalan pari buy pinakamatagꞌaya grupun pawpuun Hawjudio nananangkap ibidinsiyan laban kan Apu Jesus taêmên mahatulan yan kamatiyan. Nuwa ala hilan makuwan ibidinsiya. ");
INSERT INTO abc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dêlan nagsaksin alwan pêtêg laban kan Apu Jesus nuwa alway naman nagkakagihay innununghung la. ");
INSERT INTO abc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mayin umnuy nêdêng buy nagsaksin alwan pêtêg laban kana. Ambala la, ");
INSERT INTO abc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nalêngê yana sinabi na, ‘Gibaên kuy timplun atiyaꞌ gawan tawu, nuwa ha buun tatluy allêw iêdêng kuy timplun alwan gawan tawu!’ ");
INSERT INTO abc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nuwa, alwa mêt nagkakagihay innununghung la.” ");
INSERT INTO abc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nêdêng ha gitnay puun pari, tinanung hi Apu Jesus, “Ala ka kaya ban sabin ha imbibintang la laban kamu?” ");
INSERT INTO abc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ahê nagtêgê hi Apu Jesus, kaya tinanung yan uman puun pari, “Haka bayaꞌ Cristo, anak Apu Diyusaꞌ pinupuri tamu?” ");
INSERT INTO abc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tinumbay hi Apu Jesus, “Haku bay, buy hakuy nangibat ha langitaꞌ Inꞌanak Tawuy maakit yun nakaitnu ha kanan Makapangyarihan Apu Diyus. Buy paglatêng ku kayti ibat ha langit, maakit yu ku ha ulapaꞌ patabuy.” ");
INSERT INTO abc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hin nalêngêy atin puun pari, ha puut na, ginihi nay kanan baru buy ambala, “Angkaya tamu pun kaylanganaꞌ sawsaksi? ");
INSERT INTO abc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nalêngê yuy ah na inggagalangaꞌ Apu Diyus ta inꞌiitbuh nay sarili na kana. Hita labay yun gawꞌên kana?” Buy hinatulan la hi Apu Jesus, “Dapat yan patin.” ");
INSERT INTO abc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tinupayan yan umnu baistu. Tinakpan lay mata na buy sinuntuk ya bayu tinanung, “Sabin mu paraw nu hita nanyuntuk kamu?” Pagkayari, kinwa yan gawguwardiya buy pinagbubugbug. ");
INSERT INTO abc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hin dilag pun ha bakuran hi Pedro, dinumanaꞌ gihay babaying utuhan puun pari. ");
INSERT INTO abc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hin naakit na hi Pedro, nagpapakyang ha danin apuy, nangunênêg yan nakabalay kana buy innunghung na, “Awyun ka mêt Apu Jesus ya taga Nazaret, alwa nay?” ");
INSERT INTO abc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nuwa impuglaun Pedroy ati, “Ah ku tanday innununghung mu.” Pagkayari, nagꞌalih ya baistu ta naku ya ha luwahan. Hin habatu mêt, nanalangꞌayaꞌ manuk. ");
INSERT INTO abc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naakit yay na mêt istun babaying utuhan, kaya innunghung babayi ha tawtawung dilag istu, “Hay tawung ban in, giha ya mêt ha awyun Apu Jesus.” ");
INSERT INTO abc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nuwa, impuglaun uman Pedro. Papainghan, innunghung tawtawu baistu, “Giha ka bay ha kawkaawyun na, ta taga Galilea ka mêt.” ");
INSERT INTO abc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nuwa nagsumpa hi Pedro, “Matiyaku man, ah ku talagan kilalay tawung innununghung yu.” ");
INSERT INTO abc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hin habatu mêt, nanalangꞌay umanaꞌ manuk. Buy naihipan Pedroy innunghung kanan Apu Jesus, “Bayu manalangꞌayaꞌ manuk luway bisis, tatluy bisis mu kun ipaglaun kilala mu ku.” Nanghêmêkmêk yan tangih. ");
INSERT INTO abc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kinadatunan, ninununghung agadaꞌ libun namamaalan pari, pawpuun Hawjudio, tawtagapanudun kautuhan buy pinakamatagꞌaya grupun pawpuun Hawjudio, nagꞌihip hila nu hita gawꞌên la kan Apu Jesus. Impagapuh la hi Apu Jesus buy gintan kan Gubirnadur Pilato. ");
INSERT INTO abc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hin dilaganaꞌ hila, tinanung yan Pilato, “Haka kaya bayaꞌ, talagan Harin Hawjudio?” Tinumbay hi Apu Jesus, “Hakawuy nay nannunghung.” ");
INSERT INTO abc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Madlan bintangaꞌ libun namamaalan pari laban kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaya tinanung yan uman Pilato, “Ala ka kaya ban manunghung? Balayên mu, madla hilan imbibintang kamu!” ");
INSERT INTO abc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nuwa ahêy namêt nagtêgê hi Apu Jesus. Kaya nagtaka hi Pilato. ");
INSERT INTO abc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tuwing Allêw Pagꞌalaalan Kaligtasan ha Pagꞌiirap buy Kamatiyan, nakaugaliyan Pilato, magpalayan gihay bilanggun labay palayaên tawtawu. ");
INSERT INTO abc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mayin gihay bilanggu baistu, hay lagyu hi Barabas. Nabilanggu ya ta awyun ya ha nakilaban ha pamahalaan buy nakapati hin panawun bantu. ");
INSERT INTO abc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Madlan nagdani kan Pilato ta hiniling lay gawꞌênaꞌ nakaugaliyan magpalayan bilanggu. ");
INSERT INTO abc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kaya tinanung hilan Pilato, “Labay yuy palayaên kuy Harin Hawjudio?” ");
INSERT INTO abc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Innunghung nay ati ta tanda na, inggitaꞌ namitulak ha libun namamaalan pari kaya gintan kana hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sinulsulan libun namamaalan pariyaꞌ tawtawu, “Hi Barabas ya hilingin yun palayaên, alwan hi Apu Jesus.” ");
INSERT INTO abc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nagtanung uman hi Pilato ha tawtawu, “Hitalagyu hapaêgaꞌ gawꞌên ku ha binabawêg yun Harin Hawjudio?” ");
INSERT INTO abc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nagbungꞌu hila, “Ipaku ya ha krus!” ");
INSERT INTO abc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ambalan Pilato kanla, “Awta? Hitalagyu kaya ba nagawa nan kasalanan?” Nuwa lalu pun nagbungꞌuy tawtawu, “Ipaku ya ha krus!” ");
INSERT INTO abc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Labay Pilaton iibiyaꞌ kahilingan tawtawu, kaya pinalaya na hi Barabas. Buy impapaluh nay naman hi Apu Jesus bayu inꞌibi na ha sawsundalu taêmên ipaku ya ha krus. ");
INSERT INTO abc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gintan sawsundalu hi Apu Jesus ha luub mamhakaꞌ biyag gubirnadur ta tinipun la istuy laat kaawyun lan sundalu. ");
INSERT INTO abc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinasuutan la hi Apu Jesus tilan kulay ubi bayu nanggawa hilan kurunan diwi buy intugpaw kana. ");
INSERT INTO abc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pagkayari, nagbubungꞌu hila ta kanwari pinupuri la hi Apu Jesus, “Mabiyayaꞌ Harin Hawjudio!” ");
INSERT INTO abc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Buy inuman uman lan pinagpapaluh tukudaꞌ u na buy pinagbubulitan ya. Nagluhud hila kana, kanwari sinusumamba kana. ");
INSERT INTO abc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hin nayari lan uyamên hi Apu Jesus, inhubad lay kulay ubin tila bayu impasuutaꞌ kanan baru. Pagkayari, gintan la hiya ha labas banwa taêmên ipaku ha krus. ");
INSERT INTO abc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaban nanlyalyaku hila nahalubung lay gihay tawung ibat ha bukid. Hiya hi Simon, taga Cirene, bapan Alexander buy Rufus. Impilit lan impabwat kan Simon ya krus Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gintan la hi Apu Jesus ha binabawêgaꞌ Golgota, hay labay nunghungun “Rugal Bungu”. ");
INSERT INTO abc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Paglatêng istu, binyan la hi Apu Jesus alakaꞌ mayin halung gamutaꞌ binabawêg mira. Labay lan ipaênêmaꞌ ati takayꞌêmên ah na matanamaꞌ masyarung hakit nu ipaku lay na hiya. Nuwa ah na inênêmaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Impaku la hi Apu Jesus ha krus bayu pinagpalabunutan lay bawbaru na taêmên matandan lay dakay balan giha. ");
INSERT INTO abc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikasiyama datu hin impaku ya ha krus. ");
INSERT INTO abc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mayin karatula ha tagꞌay krus. Ati ya nakasulat bintang laban kana, “Hay Harin Hawjudio.” ");
INSERT INTO abc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mayin mêt luway tulisana impaku ha krus kadanin Apu Jesus, giha ha kanan na, giha ha kaliwa. ");
INSERT INTO abc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ha pangyayarin ati, napapêtgananay innunghung ha kasulatan Apu Diyus, “Napabilang ya ha libun makasalanan.” ");
INSERT INTO abc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ininsultu hi Apu Jesus tawtawung dinuduman istu. Napapalampêyêng hila, sabayaꞌ sabin, “Hita hapaêg? Indap ku, gibaên muy timplu buy iêdêng mun uman ha luub tatluy allêw? ");
INSERT INTO abc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Magtabuy ka ha krus ta iligtas muy sarili mu!” ");
INSERT INTO abc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Habatu mêtaꞌ panꞌiinsultun libun namamaalan pari buy tawtagapanudun kautuhan. Ambala la ha gihat giha, “Inligtas nay kanayun, nuwa alwa nan mailigtasaꞌ sarili na! ");
INSERT INTO abc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Balayên tamu, nu makatabuy ha krusaꞌ Criston ati, hari kanun Israel! Nu makatabuy ya, maniwala kitamuy na.” Maging hay luway nangakapakung awyun na, nangꞌinsultu mêt kana. ");
INSERT INTO abc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hin magꞌalas dusiyanan tanghali, nagmadlêmaꞌ buun kalutꞌan ha luub tatluy uras. ");
INSERT INTO abc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hin magꞌalas tris hapun, nagbungꞌun malakas hi Apu Jesus, “Eloi, Eloi, lêma sabachtani?” Hay labay nunghungun Apu Jesus, “Diyus ku, Diyus ku, kaya mu ku pinaulayan?” ");
INSERT INTO abc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hin nalêngên nangakaêdêng baistuy innunghung Apu Jesus ya “Eloi”, ah la natêbêk. Kaya ambala la, “Lêngꞌên yu, binabawêg na hi Elias.” ");
INSERT INTO abc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Inlumukhu agadaꞌ gihay tawu, nangwan ispungha, ingkabit ha tampuh bihlakan, ta intiltil ha maasimaꞌ alakꞌ, bayu impalkap ha bêbêy Apu Jesus takay hêphêpên na. Innunghung tawung ati, “Ibwatan tamu ya. Balayên tamu nu lumatêng hi Elias, nu itabuy ya ha krus.” ");
INSERT INTO abc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nagbungꞌun malakas hi Apu Jesus buy nabuytuwan yan inawanên. ");
INSERT INTO abc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hin habatu mêt, hay tabingaꞌ makapalaꞌ tila ha luub timplu, nagihi ha tagꞌay patabuy. ");
INSERT INTO abc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nakaêdêngaꞌ kapitan sundalu ha tapat krus, naakit na nu pakapakun nabuytuwan inawanên hi Apu Jesus. Innunghung na, “Pêtêg bayaꞌ, Anak yan Apu Diyus.” ");
INSERT INTO abc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ha madayun bagya, mayin babaying namamalay ha nangyayari, hi Salome, hi Maria taga Magdala, buy hi Marian indu lan Jose buy ali nan hi Santiago. ");
INSERT INTO abc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hay babaying ati, mamikilalaku kana, nanunulung kana hin dilag ya pun ha Galilea. Dilag mêt baistuy babaying nakilaku kana angga ha Jerusalem. ");
INSERT INTO abc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Padlêmanan habatu, uras paghanda ta dumahuy Allêw Pamamahinga. ");
INSERT INTO abc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kaya naglakas luub hi Jose, taga banwan Arimateang lakwun na hi Gubirnadur Pilato ta ipikikuway bangkay Apu Jesus. Hi Jose, giha ha inggagalang ha pinakamatagꞌaya grupun pawpuun Hawjudio. Ta giha ya ha nangêngêtêng paghaharin Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hin nalêngên Pilaton natiyana hi Apu Jesus, nagtaka ya. Kaya impabawêg nay kapitan sawsundalu, intanung na, “Natiyana hi Apu Jesus?” ");
INSERT INTO abc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hin nalêngên Pilato ha kapitanaꞌ natiyana hi Apu Jesus, pinaulayan nay na hi Josen kuwênaꞌ bangkay Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nanyaliw mamaalinaꞌ tilan linu hi Jose. Bayu, impakuway bangkay Apu Jesus ha krus. Ta imbalut nay ati ha hinaliw nan tilan linu buy inꞌêlbêng nay ati ha kinalin êlbêngan ha pingit bud. Bayu, intulid nay mamhakaꞌ batu taêmên panakêp ha pintun êlbêngan. ");
INSERT INTO abc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Naakit hinhatun Maria taga Magdala buy Marian indun Jose, nu haantun inꞌêlbêng hi Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagkalibah Allêw Pamamahinga, nanyaliw pabangu hilan Maria taga Magdala, Marian indun Santiago, buy hi Salome, ta maku hila ha pinayꞌêlbêngan Apu Jesus, ipuyuk lay pabangu ha bangkay na. ");
INSERT INTO abc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hin allêw Linggu pagkasikat allêw, nakuy na hila ha pinayꞌêlbêngan. ");
INSERT INTO abc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaban nallyalyaku hila, nagtatanungan hila, “Hitalagyu kayay mapikinunghungan tamung mamitulid batun pakatakêp ha êlbêngan?” ");
INSERT INTO abc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nuwa hin inlumatêng hila istu, naakit lan naitulidana ha pingitaꞌ mamhakaꞌ kahanaꞌ batu. ");
INSERT INTO abc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Buy nagpahuk hila ha êlbêngan, naakit la istuy gihay binatilyu, nakabarun putin makadang, pakaitnu ha bandan kanan. Nikakalimu hila. ");
INSERT INTO abc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nuwa ambalan binatilyu kanla, “Ah kawu malimu! Tanda kun titingkap yu hi Apu Jesus ya taga Nazaret ya impaku ha krus. Ala yay na kayti, nabyay yan uman! Balayên yuy pinagꞌundagan bangkay na. ");
INSERT INTO abc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mallyaku kawuy na ta nunghungun yu ha tawtagahunul na, laluy na kan Pedro, maunay na hi Apu Jesus ha Galilea. Baistu yu ya maakit dapay ha innunghung na.” ");
INSERT INTO abc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nalgangaꞌ babayi buy ginalgal kaya naghalwang ha êlbêngan buy inlumukhu. Ha subrang limu, ah lay na nainunghung ha hitalagyuman. ");
INSERT INTO abc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hin datun datu pun allêw Linggu, hin nabyay hi Apu Jesus, una yan nagpaakit kan Maria taga Magdala, hiyay babaying sinuklutan pituy anitung pinaalih Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Inlakun Mariay tawtagahunul Apu Jesus. Nalatêng nan nagluluksaꞌ buy nananangih hila buy imbalita nay nangyari. ");
INSERT INTO abc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nuwa, ah hila naniwala ha imbalita nan nabyay hi Apu Jesus buy nagpaakit kana. ");
INSERT INTO abc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkayarin habatu, nagpaakit uman hi Apu Jesus ha luwa nan tagahunul palaku ha bukid, nuwa ha iban anyu. ");
INSERT INTO abc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kaya nagbalikaꞌ luwa ha kaawyun la ha Jerusalem ta innunghung lan nagpaakit kanla hi Apu Jesus. Nuwa ahê mêt naniwalay libun ati. ");
INSERT INTO abc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hin bandan huli, kaban nanangana labinggiha nan tagahunul, nagpaakit mêt hi Apu Jesus kanla. Pinannunghungan nay libun ati ta ah hila nananampalataya buy mangatigasaꞌ pusu la. Ta alwa hilan naniniwala ha kuwintun nakaakit kanan nabyay yan uman. ");
INSERT INTO abc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ambalan Apu Jesus kanla, “Maku kawu ha buun kalutaan, ipangaral yuy Mahampataꞌ Balita tungkul kangku ha laat tawu. ");
INSERT INTO abc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hay laataꞌ manampalataya buy magpabawtismu, maligtas ha kaparusaan, nuwa hay laataꞌ ahê manampalataya, parusaan. ");
INSERT INTO abc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Buy atiyaꞌ palatandaanaꞌ maakit ha tawtawung nananampalataya kangku. Ha kangkun kapangyarian, magpaalih hilan anitu, mannunghung hilan kanayun salitan ahê pun naitudu kanla. ");
INSERT INTO abc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nu mandamput hilan awꞌutan u makaênêm hitalagyuman lasun, ah hila mapahamak. Nu patungan lan gamêt lay mayin hakit, gumaling hila.” ");
INSERT INTO abc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkayarin nannunghung Apu Jesus kanla, indakêy ya ha langit ta nitnu ya ha kanan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nakuy namanaꞌ tawtagahunul na ha iba iban rugal ha kalutaan ta nangaral. Tinulungan hilan Panginuun manggawan hawhimala. Haatin, pinapêtgan nay libun pangangaral Apu Jesus.");
INSERT INTO abc_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Haku hi Pabloy alagad Apu Jesu Cristo ayun ha kaluuban Apu Diyus. Nanyulataku kayun libun tiga Efeso ya pinilin Apu Diyus buy tapat kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Indadalangin kun mapakayuy kahampatan buy kapayapaanaꞌ ibat ha Bapa tamun hi Apu Diyus buy ha Panginuun tamun hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","4","Puriin tamu hi Apu Diyus ya Bapan Panginuun tamun hi Apu Jesu Cristo. Ta ha pakikigiha tamu kan Apu Jesus, inꞌibi na kantamuy laataꞌ pagpapalan ibat ha langit. Bayu na pun likhaênaꞌ mundu, ha pamêmêêtan pakikigiha tamu kan Apu Jesu Cristo, pinili nay na kitamu takay magin banal buy alan maakitaꞌ malaêt ha pamalayan na. Ta ha pagmamaal na kantamu, ");
INSERT INTO abc_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","hinhatu puniꞌ intalaga nay na kitamu takay magin awꞌanak na ha pamêmêêtan Apu Jesu Cristo. Ta habayinaꞌ labay na buy kaluuban na, ");
INSERT INTO abc_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","taêmên puriin tamu hi Apu Diyus ta ha makapagtaka nang biyayan inꞌibi na kantamu ha pamêmêêtan minamaal nan Anak. ");
INSERT INTO abc_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","8","Ha pamêmêêtan dayan Apu Jesus, tinubus kitamuy na, ya hay labay sabin pinatawadanay kawkasalanan tamu. Alan katbuhaꞌ biyayan impagkaluub kantamun Apu Diyus, ta binyanan na kitamun kabiyahaan buy pagkatêbêk, ");
INSERT INTO abc_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","takay matêbêkaꞌ lihimaꞌ planu na ya labay nan matupad ha pamêmêêtan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Atiyaꞌ planu na: paglatêng takdang panawun paggihaên nay dilag ha langit buy ha luta, ya magin sakupanan kapangyarian Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Ginagawan Apu Diyus ya laataꞌ bagay ayun ha planu buy kaluuban na. Buy ayun ha planu na hinhatu pun, pinili na kami takay magin kana ha pamêmêêtan pakikigiha kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Ginawa nay habatu takay hakamin ni unan nanampalataya kan Apu Jesus magpuri kana. ");
INSERT INTO abc_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Hakaw man nakigiha kawu kan Apu Jesu Cristo hin nalêngê yuy kapêtêgan, ya hay Mahampataꞌ Balita nu pakapakun kawun miligtas. Ta ha pananampalataya yu kana, inꞌibi nay Ispiritu na ya impangaku na bilang tanda ya pagꞌaari na kawu. ");
INSERT INTO abc_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Hay Banalaꞌ Ispirituy inꞌibi na kantamu taêmên magpatunayaꞌ matanggap tamuy ibat ha Apu Diyus ya impangaku na kantamun awꞌanak na, anggan ha matanggap tamuy lubusaꞌ kaligtasan. Dahilan kayti puriin ya ta ha kahampatan na! ");
INSERT INTO abc_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Kaya ban, hin nabalitꞌan kuy pananampalataya yu ha Panginuun Jesus buy hay pagmamaal yu ha pawpinilin Apu Diyus, ");
INSERT INTO abc_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","panayaꞌ pasasalamat ku kan Apu Diyus dahilan kayu. Buy panay kitawun impapanalangin. ");
INSERT INTO abc_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Impipikikwa ku kan Apu Diyus, ya dakilan Bapan Panginuun tamun hi Apu Jesu Cristo, ya biyan na kawun kabiyahaan buy pagkatêbêkaꞌ ibat ha Banalaꞌ Ispiritu takay lalu yu ya pun makilala. ");
INSERT INTO abc_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Impapanalangin ku mêtaꞌ pahawangên nay pusu yu buy ihipan takay matêbêk yuy pagꞌasan inlaan na kantamu, hay maalaga buy kasaganaanaꞌ pagpapala ya impangaku na ha libun pinili na. ");
INSERT INTO abc_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","20","Impapanalangin ku mêt kan Apu Diyus ya matandan yuy alan katbuhaꞌ kapangyarihan na para kantamun mananampalataya na. Hay kapangyarihanaꞌ atiyaꞌ ginamit na hin binyay nan uman hi Apu Jesus, buy hin pinaitnu nay na ha kanan na istu ha langit. ");
INSERT INTO abc_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Kaya dilag ha lalên kapangyarihan Apu Jesus ya laataꞌ anitun naghahari, namamaala, awꞌanitun namumunu buy mayin kapangyarihan. Hay tungkulin nay ahê mapantayan hitalagyuman, alwan dili ha panawunaꞌ ati, nu alwan ha lumatêng punaꞌ panawun. ");
INSERT INTO abc_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Impagkatiwalan Apu Diyus kan Apu Jesu Cristoy laataꞌ bagay, buy ginawa yan pinunun laat ha ikahampat mananampalatayan miaawyun, ");
INSERT INTO abc_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ya hiyan pinakanawinin Apu Jesus. Hay laataꞌ mananampalatayan miaawyun hilay pinakanawinin Apu Jesus ya hiyay kabuuan laat. ");
INSERT INTO abc_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Hin hatu, inturing kawun natin Apu Diyus ta ha ah yu paghunul buy ha libun kasalanan yu. ");
INSERT INTO abc_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Nanabiyay kawun nambuh ha tawtawung makamundu. Buy nagpasakup kawu ha kapangyarihan Satanas, ya harin libun anitu ha mundu ya hiya mêtaꞌ anitun manguna ha pusun tawtawu ya ahê hinuhumunul kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Hinhatu, nanabiyay kitamun mêt laat katbuh la. Nanabiyay kitamu ha malaêtaꞌ kalabayan nawini tamu, buy hinuhunul tamuy mangalaêtaꞌ labay nawini tamu buy kaihipan. Ha kalagayan tamun bantu, awyun kitamu mêt hana ha parusan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Nuwa maiingaluunaꞌ Apu Diyus buy talagan dakilay pagmamaal na kantamu, ");
INSERT INTO abc_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ta maski inturing na kitamun nati gawan ha libun kasalanan tamu, binyay na kitamun uman kaawyun Apu Jesus. Buy ha biyayan Apu Diyus, niligtas kitamu. ");
INSERT INTO abc_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Buy binyay kitamun Apu Diyus kaawyun Apu Jesu Cristo ta ha pakikigiha tamu kana, takay makaawyun na kitamun maghari ha kaharian na ha langit. ");
INSERT INTO abc_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Ginawa nay habaytu takay ha lumatêngaꞌ panawun, maipakit na ha laataꞌ ah mapantayanaꞌ kasaganaan biyaya na ha kahampatan na kantamu ha pamêmêêtan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ta ha pamêmêêtan biyayan Apu Diyus, niligtas kawu hin nanampalataya kawu kan Apu Jesus, alwan ibataꞌ ati ha sarili yu nu alwan kaluubaꞌ atin Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Ah kawu miligtas ha pamêmêêtan libun mangahampataꞌ gawa yu, takay alan maipagyabangaꞌ hitalagyuman. ");
INSERT INTO abc_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ta inlikha kitamun Apu Diyus. Buy ha pakikigiha tamu kan Apu Jesu Cristo, binyanan na kitamun bayun biyay, takay manggawa kitamun kahampatanaꞌ hinhatu puniꞌ intalagay nan Apu Diyus ya gawꞌên tamu. ");
INSERT INTO abc_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Kaya hakawun libun alwan Judio, ihipin yuy kalagayan yu hinhatu. Impanganak kawun alwan Judio buy innununghung libun Judio ya ah kawu nangingilala kan Apu Diyus ta ah la kawu katbuhaꞌ tuli. Nuwa hay pagkakatuli la, ha nawini dili ya gawan tawu. ");
INSERT INTO abc_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Pakaihipin yu mêtaꞌ hinhatun ah yu pun kilala hi Apu Jesu Cristo, ah kawu kabilang ha tiga Israel buy ah kawu sakup ha libun kasunduan Apu Diyus ayun ha pangaku na. Nabyay kawu ha mundun atin alan pagꞌasa buy alan kilalan Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Hinhatu madayu kawu kan Apu Diyus, nuwa hapaêg ha pamêmêêtan dayan Apu Jesus, naidani kawuy na kana. ");
INSERT INTO abc_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Hi Apu Jesu Cristoy pinangibatan kapayapaan tamu ta pinaggiha nay Hawjudio buy hay alwan Hawjudio. Buy ha pamêmêêtan pagkapaku na ha krus, inalih nay kapuutan ha balang giha nambuh pagkagiban padiraꞌ mamihiyay ha Hawjudio buy alwan Judio. ");
INSERT INTO abc_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Winalꞌan nan alagay kautuhan, kaawyunaꞌ libun utuh buy libun patakaran ati. Ginawa nay ati takay paggihaênaꞌ Hawjudio buy alwan Judio, ta baistu magkasunduy nay luwa. ");
INSERT INTO abc_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Hapaêgaꞌ gigihay nawini kitamuy na ha pamêmêêtan pagkamatiꞌ na ha krus, inalih nay nay patiyan tamu buy impagkasundu na kitamu kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Naku hi Apu Jesu Cristo kayti ha mundu takay ipangaral nay Mahampataꞌ Balitan naykasundu kayun alwan Hawjudio ya hin una madayu kawu kan Apu Diyus. Maski kanyan mêtaꞌ Hawjudio ya madani kan Apu Diyus, impangaral na mêt kanyanaꞌ Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Hapaêg, pariparihu kitamuy nan makadani kan Apu Diyus ha pamêmêêtan kagigihay Banalaꞌ Ispiritu ta ha ginawan Apu Jesu Cristo para kantamu. ");
INSERT INTO abc_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Kaya hakawun alwan Hawjudio, alwa kawuy nan dayuhan u tiga ibang bansa, nu alwan kabilang kawuy na ha pawpinilin Apu Diyus buy kabilang kawuy na ha pamilyan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Hakitamun libun mananampalataya, maiitbuh ha gihay biyagaꞌ batu ya hay haligi, hay awꞌalagad buy libun tagapannunghung, buy hay maalagan batun pundasyun hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Ha pamêmêêtan Apu Jesu Cristo, magkakatugnuy laat kagamitan ha biyagaꞌ batu buy magin gihay banalaꞌ timplun Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Hakawun alwan Hawjudio ta ha pakikigiha yu kan Apu Jesu Cristo, naitugnu kawuy na ha libun Judio, ya nambuh kagamitan ha Timplun pinamimirmiyan Ispiritun Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Ta habatuy ginawan Apu Diyus, hakun hi Pabloy nabilanggu ta ha paglilingkud ku kan Apu Jesu Cristo ha pamêmêêtan awun panunudu ku para kayun alwan Hawjudio. ");
INSERT INTO abc_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Siguradun nabalitꞌan yun impagkatiwala kangkun Apu Diyus ya panunudun Mahampataꞌ Balita kayu. ");
INSERT INTO abc_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Katbuh ha innunghung ku ha sulataꞌ ati, impatanda kangkun Apu Diyus ya lihimaꞌ planu na. ");
INSERT INTO abc_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Kaban binabasa yuy sulat kun ati, matandan yuy pagkatêbêk ku ha lihimaꞌ planun Apu Diyus tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Alwan impatandan Apu Diyus ya planun ati ha tawtawu hinhatu, nuwa hapaêg, ha pamêmêêtan Banalaꞌ Ispiritu, impangaral nay ati ha libun alagad na buy libun tagapannunghung na. ");
INSERT INTO abc_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Ati bayaꞌ planun Apu Diyus. Ha pamêmêêtan Mahampataꞌ Balita tungkul kan Apu Jesu Cristo, hay alwan Hawjudio, tagapagmana mêt pangakun Apu Diyus kaawyunaꞌ Hawjudio, buy nambuh mêtanaꞌ hilan gigihay nawini ta ha pakikigiha la kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Ta ha biyayan Apu Diyus buy ha pamêmêêtan kapangyarihan na, nagin tagapangaralakun Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Maski hakuy pinakamayêpa ha laat mananampalataya, piniliyaku pun Apu Diyus takay ipangaral ku ha alwan Hawjudioy ahê mapantayanaꞌ biyayan ibat kan Apu Jesu Cristo, ");
INSERT INTO abc_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","buy ipatanda ku ha laat nu pakapakun matupadaꞌ planun Apu Diyus. Hi Apu Diyusaꞌ naylikhan laataꞌ bagay, hin una inlihim nay planu na, ");
INSERT INTO abc_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","taêmên ha pamêmêêtan mananampalatayan miaawyun, maipatanda ha libun anghilaꞌ namumunu buy mayin katungkulan ha langit, hay kabiyahaan Apu Diyus ya naipangaral ha iba iban paraan. ");
INSERT INTO abc_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Ati ya planu na hin umpisa pun, buy natupadanay ati ha pamêmêêtan Apu Jesu Cristo ya Panginuun tamu. ");
INSERT INTO abc_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Ta ha pakikigiha kan Apu Jesu Cristo buy ha pananampalataya tamu kana, makadani kitamuy na kan Apu Diyus ya alan limu buy alan alinlangan. ");
INSERT INTO abc_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Kaya hinihiling kun ah kawu hana pangꞌinaan luub ta ha libun pagꞌiirapaꞌ dinadanas ku, ta para ha ikahampat yuy ati. ");
INSERT INTO abc_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Nu naaalala kuy planun Apu Diyus, magluhudaku ya magpupuri kana. ");
INSERT INTO abc_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Hiyay Bapan libun dilag ha langit buy dilag ha luta ya intuturing nan buung pamilya. ");
INSERT INTO abc_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Impapanalangin ku kana ya palakasên nay luub yu ha pamêmêêtan Ispiritu na, ayun ha alang angganaꞌ kahampatan buy kapangyarihan na, ");
INSERT INTO abc_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","taêmên mamirmi hi Apu Jesu Cristo ha pawpusu yu ha pamêmêêtan pananampalataya yu. Impapanalangin ku mêtaꞌ magin matibay kawu buy matatag ha pagmamaal Apu Diyus ");
INSERT INTO abc_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","takay matêbêk yu buy kanayun mêtaꞌ pinilin Apu Diyus nu antun kamhak, kakadang, katagꞌay buy nu pakapakun kalalêy pagmamaal Apu Jesu Cristo kantamu. ");
INSERT INTO abc_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Labay kun madanasan yuy alwan mapantayanaꞌ pagmamaal na taêmên magin ganap kawuy katangian Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Kaya puriin tamu hi Apu Diyus ya makagawan higit pun ha impipikikwa u inaasahan tamu ha pamêmêêtan kapangyarihan nan kinukumilus kantamu. ");
INSERT INTO abc_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Puriin tamu hi Apu Diyus makanuman ta ha ginawa na para ha mananampalatayan miaawyun ya dilag kan Apu Jesu Cristo. Amen. ");
INSERT INTO abc_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Kaya bilang gihay bilanggu ta ha paglilingkud ha Panginuun, hinihiling kun mabyay kawun karapatdapat bilang libun binawêg Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Magin mahinahun kawu, mapagpakayêpa, maunawaên buy mapagpasinsiya ha pagkukulang balan giha bilang pagpapakit pagmamaal ha balang giha. ");
INSERT INTO abc_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Pagsikapan yun ahê maalihaꞌ pagkakagiha yu ibat ha Ispiritun Apu Diyus ha pamêmêêtan mapayapan pamiaawyun yu. ");
INSERT INTO abc_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Ta gigihay nawini kitamun dili ya mayin gigihay Ispiritun Apu Diyus, buy gigiha mêtaꞌ pagꞌasang inꞌibi kantamu hin binawêg kitamun Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Gigihay Panginuun tamun hi Apu Jesus, gigihay pananampalataya, buy gigiha mêtaꞌ bawtismu. ");
INSERT INTO abc_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Gigiha hi Apu Diyus ya hiyay Bapa tamun laat. Naghahari ya ha laat, kinukumilus ya buy namimirmi kantamun laat. ");
INSERT INTO abc_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Nuwa maski bahagiꞌ kitamun gigihay nawini, binyanan nay balang giha kantamun kakayaan ayun ha kaluuban Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Katbuh ha innununghung ha Kasulatan, “Hin nagdakêy ya ha langit, gintan nay kanan nangadakêp buy binyanan nay naman biyayay tawtawu.” ");
INSERT INTO abc_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Hapaêg, hita kayay kaulugan awun, “Nagdakêy ya ha langit?” Hay labay sabin ati, bayu ya nagdakêy uman ha langit, nagtabuy ya pun kayti ha luta. ");
INSERT INTO abc_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Buy hay nagtabuy kayti ha luta, hiya mêtaꞌ nagdakêy ha katagꞌay tagꞌayan langit takay magin lubusaꞌ kapangyarihan na ha laataꞌ bagay. ");
INSERT INTO abc_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Hay kanayun ginawa nan alagad, hay kanayun ginawa nan tagapannunghung Apu Diyus, buy hay kanayun ginawa nan maypatandan Mahampataꞌ Balita, buy hay kanayunaꞌ naman ginawa nan mangalênggêp libun mananampalataya buy maytudu kanla. ");
INSERT INTO abc_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Ginawa nay ati takay ihanday pawpinili na ha paglilingkud, buy takay lumagu buy magin matatag hila bilang nawinin Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Ha paraanaꞌ ati, maabut tamun laataꞌ pagkakagiha ha pananampalataya buy pagkakilala ha Anak Apu Diyus, buy lumagu kitamun mananampalataya anggan ha magin ganap kitamun katbuh Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Ta nu maabut tamuy nay ati, alwa kitamuy nan katbuh anakaꞌ pabayuꞌbayuy ihip ya naaagkat tawtawu ha kamalaêtan, ya hay hangad la, gitanaꞌ tawtawu ha malukê. ");
INSERT INTO abc_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Ha halip, mannunghung kitamun kapêtêgan ya mayin pagmamaal takay ha laat bagay magin katbuh kitamun Apu Jesus ya hiyan pinakaꞌ u tamun libun mananampalataya. ");
INSERT INTO abc_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Ha pamêmêêtan na, pinitutugnu nay laataꞌ bahagin nawini na, ya alan kanayun nu alwan hay libun mananampalataya buy hay balang gihay mitutulung. Buy hay balan hinuhumunul ha impapagawan Apu Jesu Cristo ya mayin pagmamaal, inlulumagu buy tinutumatagaꞌ buun nawini. ");
INSERT INTO abc_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Ha lagyun Panginuun, impipilit kun ah kawuy na mamuhay katbuh tawtawung alwan nakakakilala kan Apu Diyus. Ta alan silbiyaꞌ inihip la, ");
INSERT INTO abc_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","buy ah la natêtêbêkaꞌ libun kapêtêganaꞌ tungkul kan Apu Diyus. Ta ha ala hilan tanda buy mangatigasaꞌ u la, ala hilan bayun biyay ya inꞌibin Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Alay na hilan kadêdêngꞌêyan, kaya nagpasakupanaꞌ hila ha mangaalaya kalabayan nawini la buy labay lan panay manggawan kadêmêkan. ");
INSERT INTO abc_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Nuwa hakawu, alwan habatuy natandan yu tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Nalêngê yuy nay tungkul kan Apu Jesus buy natuduwanan kawuy nan kapêtêganaꞌ dilag kana. ");
INSERT INTO abc_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Kaya alihin yuy nay daan yun pamumuhay ta gawꞌênaꞌ atin daan yung pagkatawu. Hay pagkatawu yun ati ya naypapahamak kayu ta ha mangalaêtaꞌ kalabayanaꞌ nanluluku kayu. ");
INSERT INTO abc_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Paulayên yun bayuun Apu Diyus ya ihip yu buy ugali yu. ");
INSERT INTO abc_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Ipakit yun binayu kawuy nan Apu Diyus buy binyan na kawun bayun biyay ya matuynung buy malinis katbuh Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Kaya ah kawuy na magsinungaling. Kapêtêgan tanay nunghungun yu ha pawpatêl yu, ta miaawyun kitamun laat ha gigihay nawini. ");
INSERT INTO abc_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Nu mapuut kawu, ah yu paulayênaꞌ magkasala kawu. Buy ah yu paulayên dumanaꞌ allêwaꞌ puut kawu pun ha pawpatêl yu. ");
INSERT INTO abc_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Ah yu biyan pagkakatawun hi Satanas. ");
INSERT INTO abc_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Hay magnanakaw, andi yana manakaw, nu alwan magtrabahu yan marangal takay makatulung ya mêt ha nangangaylangan. ");
INSERT INTO abc_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Ah kawu mannunghung malaêt nu alwan hay makahampat dili buy angkup ha kalagayan takay magin pakinabang ha nakakalêngê. ");
INSERT INTO abc_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Buy ah yu palungkutanaꞌ Ispiritun Apu Diyus. Ta hay Ispirituy tatak ya kan Apu Diyus kawu, buy hiyay katibayan kaligtasan yu pangalatêng allêw. ");
INSERT INTO abc_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Alihin yuy hitamanaꞌ hakit nakêm, puut, patiyan, pambubulas, panghihira ha kaparihu, pati laataꞌ kalasin mangalaêtaꞌ hangarên. ");
INSERT INTO abc_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Ha halip, magin mabait kawu buy magin maingaluun ha balang giha. Buy magpatawad kawu ha balang giha katbuh pagpapatawad Apu Diyus kayu, ta ha ginawan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Kaya tubhun yu hi Apu Diyus, ta hakawun laataꞌ minamaal nan awꞌanak. ");
INSERT INTO abc_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Mamuhay kawun mayin pagmamaal ha kaparihu yu katbuh pagmamaal kantamun Apu Jesus. Inꞌalay nay sarili na kantamu bilang kalugudlugudaꞌ handug kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Ta pinili na kawu, ah kawu dapat kalêngꞌan manggawan malaswa, mangaalay buy sakimaꞌ giha man kayu. ");
INSERT INTO abc_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Buy andi dapat malêngê kayuy mangalaswa u alan silbi ya nunghungan u mangalaêtaꞌ biru. Nu alwan panay kawun mapagpasalamat kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Tandaan yu, alan tawun mapaawyun ha kaharian Apu Jesu Cristo buy Apu Diyus ya nakikitakpi, mangaalay ya pamumuhay, u sakim. Ta hay tawun sakim katbuh mêt nanampalataya ha libun diyusdiyusan. ");
INSERT INTO abc_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Ah kawu magpaguluy ha alan silbin pangangatwiran kanayun tungkul ha mangalaêt lan gawaên. Ta ha bawbagayaꞌ ati, puutaꞌ puut hi Apu Diyus ha libun ah hinuhumunul kana. ");
INSERT INTO abc_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Kaya ah kawu makiawyun ha ginagawan tawtawung ati. ");
INSERT INTO abc_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Hinhatu nanabiyay kawu ha kadlêman, nuwa hapaêg, nahawangan kawuy na ta nakigiha kawuy na ha Panginuun. Kaya ipakit yu ha pamumuhay yuy nahawangan kawuy na. ");
INSERT INTO abc_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Ta nu hay gihay tawuy nahawanganana, maakit kanay kahampatan, katuynungan, buy kapêtêgan. ");
INSERT INTO abc_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Pakatandan yu nu hita kalugudlugud ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Ah kawu makiaawyun ha libun alan silbi ya ginagawan tawtawung dilag ha kadlêman, ha halip, ipatanda yu kanlay kamalaêtan la. ");
INSERT INTO abc_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ta kadêngꞌêy dêngꞌêy sabin maski pinununghungan diliyaꞌ bawbagayaꞌ ginagawa lan lihim. ");
INSERT INTO abc_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Nuwa nu patandan yu hila ha mangalaêtaꞌ gawaên la, mahawangan hila buy matandan lan malaêt bayaꞌ libun ginagawa la. ");
INSERT INTO abc_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Ta hay laat maabut kapêtêgan, mahawanganana. Kaya bay innununghung, “Mapukaw ka, hakan natutuluy, mibangun ka ibat ha nawnati buy hawangan kan Apu Jesus.” ");
INSERT INTO abc_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Kaya magꞌingat kawu nu pakapakun kawun mamuhay. Ah kawu mamuhay katbuh libun alwan biyaha, nu alwan mamuhay kawun katbuh bawbiyaha. ");
INSERT INTO abc_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Ah yu sayangênaꞌ panawun yu. Gamitin yuy ati ha panggawan mahampat, ta dêlay nanggagawan kamalaêtan ha panawunaꞌ ati. ");
INSERT INTO abc_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Kaya ah kawu magin muwmulala, nu alwan pakatandan yu nu hita kaluuban Panginuun ya gawꞌên yu. ");
INSERT INTO abc_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Ah kawu maglahing ta nakakahiday ati ha mahampataꞌ pamumuhay. Ha halip, paulayan yung mapuspus kawun Ispiritun Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Ha pamiaawyun yu, magkantaan kawun libun ibaꞌiban kalasin kanta para kan Apu Diyus. Buun pusu kawun magkanta buy magpuri ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Panay kawun magpasalamat kan Apu Diyus ya Bapa tamu ha laataꞌ bagay bilang mananampalatayan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Magpasakup kawu ha balan giha bilang paggalang kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Bawbabayi, magpasakup kawu ha kayung ahawa katbuh pagpapasakup yu ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Ta hay liyaki hiyay pinaka u awun ahawa na, katbuh Apu Jesus ya pinaka u awun mananampalataya ya hiyan pinakanawini na, buy hiya mêtaꞌ tagapagligtas mananampalatayan miaawyun. ");
INSERT INTO abc_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Kaya nu pakapakun nagpapasakupaꞌ mananampalatayan miaawyun kan Apu Jesus, habatu mêtaꞌ bawbabayi magpasakup mêt hila ha ahawa la ha laataꞌ bagay. ");
INSERT INTO abc_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Kaliyakyan, maalên yuy ahawa yu, katbuh pagmamaal Apu Jesu Cristo ha mananampalatayang miaawyun. Inꞌalay nay sarili na para ha mananampalatayang miaawyun ");
INSERT INTO abc_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","taêmên magin banal hila pagkayarin linisin ha pamêmêêtan pagbawtismu ha lanêm buy ha nunghung Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Ginawa nay ati takay maiarap nay kanang sarili ha libun mananampalatayan miaawyun ya banal, alan kapintasan, buy alan hitamanaꞌ bahid dungis. ");
INSERT INTO abc_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Habatu mêtaꞌ naman, dapat maalên liyaki hay kanang ahawa katbuh pagmamaal na ha kanang sarili. Ta hay nagmamaal ha kanang ahaway nagmamaal ha sarili na. ");
INSERT INTO abc_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","30","Alan tawun nasusuklam ha sarili nan nawini, ha halip, pinapakan nay ati buy inaalênggêp. Habatu mêtaꞌ ginagawan Apu Jesus kantamu ya binabawêgaꞌ mananampalatayan miaawyun ta bahagiꞌ kitamuy nan nawini na. ");
INSERT INTO abc_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Innununghung ha Kasulatan, “Itayak liyaki ya bapa na buy indu na buy makiawyun ya ha kanang ahawa buy hilan luway magin giha.” ");
INSERT INTO abc_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Malalêy kapêtêganaꞌ impahayag Apu Diyus. Impapakit kaytiya ugnayan awun Apu Jesus buy mananampalatayan miaawyun. ");
INSERT INTO abc_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Kaya hakawun libun kaliyakiyan, maalên yuy ahawa yu katbuh pagmamaal yu ha sarili yu. Buy hakawun bawbabayi, igalang yuy kayung ahawa. ");
INSERT INTO abc_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Hakawun awꞌanak, hunulun yuy mangatuwa yu ta habatuy dapat gawꞌên bilang libun mananampalataya ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“Igalang yuy bapa yu buy indu.” Atiyaꞌ unan utuh ya mayin kaawyunaꞌ pangaku. ");
INSERT INTO abc_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","“Nu igalang yuy mangatuwa yu magin mahampat buy kumadangaꞌ biyay yu kayti ha mundu.” ");
INSERT INTO abc_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Buy hakawuy namanaꞌ mangatuwa, ah kawu manggawan bagayaꞌ ikahakit nakêm awꞌanak yu. Ha halip, pakamhakên yu hilan mahampat buy tuduwanan yu hilan awꞌaralaꞌ ibat ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Hakawun awꞌalipên, hunulun yuy awꞌamu yu kayti ha luta ya mayin katapatan, paggalang buy pagkalimun dapay hi Apu Jesus ya pinaglilingkuran yu. ");
INSERT INTO abc_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Gawꞌên yuy atin mayin kusan luub nakabalay man hila u alwa takay matula hila, ta awꞌalipên kawun Apu Jesu Cristo ya buun pusun nanggagawan kaluuban Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Maglingkud kawun buun pusu dapay ha Panginuun ya talagan pinaglilingkuran yu buy alwan dilin hay tawu. ");
INSERT INTO abc_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Alalahanên yuy gantimpalan Panginuun ha balan giha kayu ayun ha ginawa nan kahampatan, alipên man u alwa. ");
INSERT INTO abc_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Buy hakawuy namanaꞌ awꞌamu, pakisamaan yun mahampataꞌ kayung awꞌalipên. Ah yu hila palimun, ta tanda yuy naman ya hakawu buy hila mayin gigihay amu ha langit, buy ah ya namimili. ");
INSERT INTO abc_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Atiyaꞌ pagtatapus sulat ku, magpakatatag kawu ha Panginuun ha pamêmêêtan dakilan kapangyarihan na. ");
INSERT INTO abc_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Gamitin yuy laataꞌ kagamitanaꞌ pandigma ya inꞌibi kayun Apu Diyus takay malabanan yuy libun mangalaêtaꞌ gawan Satanas. ");
INSERT INTO abc_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ta hay kalaban tamuy alwan tawtawu nu alwan awꞌanitu ha babun luta, pawpinunu, mayin kapangyarihan buy libun tagapamaalan kadlêmanaꞌ namamayaniꞌ ha mundun ati. ");
INSERT INTO abc_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Kaya gamitin yuy laataꞌ kagamitan pandigma ya inꞌibi kayun Apu Diyus, takay ha urasaꞌ lumatêngaꞌ kamalaêtan, matatag kawu, buy pagkayari yun makipaglaban, manatili kawun malakas. ");
INSERT INTO abc_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Kaya magin handa kawu. Gawꞌên yun sinturunaꞌ kapêtêgan. Isuut yuy pagkamatuynung yu bilang panyanga ha dêbdêb yu. ");
INSERT INTO abc_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Isuut yu bilang sapatus ya nakahandang manudun Mahampataꞌ Balitan nanamꞌin kapayapaan. ");
INSERT INTO abc_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Alwan dilin hayin, gamitin yu mêt bilang panyangay pananampalataya yu takay ah kawu tablan libun panunuksun Satanas ya dapay panaꞌ ya nagliliyab. ");
INSERT INTO abc_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Ihambalilu yuy tinanggap yun kaligtasan, buy gamitin yu bilang katanay nunghung Apu Diyus ya kaluub Ispiritu na. ");
INSERT INTO abc_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Buy manalangin kawu ha laataꞌ uras ha tulung Ispiritun Apu Diyus. Nu manalangin kawu magmakaingalu kawu buy mikikwa kana. Ah kawu magpabaya buy patuluy kawun manalangin laluy na para ha laataꞌ pinili na. ");
INSERT INTO abc_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Ipanalangin yu ku mêt amun mangaralaku, ya biyan nakun Apu Diyus taman pannungnunghung takay maipangaral kun buun tapangaꞌ Mahampataꞌ Balitan inlihim hinhatu. ");
INSERT INTO abc_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Ta inꞌutuhakun Apu Diyus takay mangaral awun Mahampataꞌ Balita ya dahilan pagkakakulung ku. Kaya ipanalangin yun maipangaral kun buung tapangaꞌ ati ta atiyaꞌ nararapat. ");
INSERT INTO abc_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Hi Tykicus, ya minamaal tamun patêl buy tapataꞌ lingkud Panginuun, ya maybalita kayun laat tungkul kangku, takay matandan yuy kalagayan ku buy nu hita panggawꞌên ku. ");
INSERT INTO abc_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Atiyaꞌ dahilan angkaya pinalaku ku ya kayu takay matandan yuy tungkul kanyan buy palakasên nay luub yu. ");
INSERT INTO abc_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Pawpatêl, dalangin kun mapakayuy kapayapaan, pagmamaal buy pananamapalatayang ibat kan Apu Diyus ya Bapa tamu buy kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Labay kun mamirmi ya kahampatan Apu Jesu Cristo ha laat nagmamaal kanan alang anggan.");
INSERT INTO abc_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Haku hi Pablo, kaawyun ku hi Timoteo ya kaparihu kun lingkud Apu Jesu Cristo. Nanyuyulataku kayun pinilin Apu Diyus ya tawtiga Filipos buy kagihan Apu Jesu Cristo, awyunaꞌ libun namumunu kayu buy libun manulung kanla buy ha libun mananampalataya. ");
INSERT INTO abc_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Indadalangin kun mapakayuy kahampatan buy kapayapaan Bapa tamun hi Apu Diyus buy Panginuun tamun hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Tuwin naiihip ku kawu, nagpapasalamataku kan Apu Diyus ya Panginuun ku. ");
INSERT INTO abc_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Panayakun natutula tuwin impapanalangin ku kawun laat. ");
INSERT INTO abc_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Ta ibat pun hinhatun nanampalataya kawu angga hapaêg, tinutulungan yu ku êmên makapagpalaganapakun Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Naniniwalakun ipagpatuluy Apu Diyus hay mahampataꞌ gawênaꞌ sinimulꞌan na kayu anggan matapus nay ati ha allêwaꞌ magbalik hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Pawpatêl ku, taman diliyaꞌ atiyaꞌ matanam ku kayu ta maala maal ku kawu. Miaawyun kitamun nakadanas kahampatan Apu Diyus hinhatu punaꞌ malayakun naytatanggul buy nagpapahayag Mahampataꞌ Balita tungkul kan Apu Jesus, maski hapaêgaꞌ nakakulungaku. ");
INSERT INTO abc_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Tandan Apu Diyus ya talagan labay ku kawuy nan makaawyun ta maal katawu katbuh pagmamaal kayun Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Nananalanginaku kan Apu Diyus ya lalu pun lumalêy pagmamaalan yu ha gihat giha ya mayin kabiyahaan buy pagkatêbêk nu hita mahampat buy malaêt ");
INSERT INTO abc_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","takay mapili yuy pinakamahampataꞌ gawꞌên. Nu habatu, ha allêw pagbalik Apu Jesu Cristo, maakit nan malinis kawuy na ha pamalayan Apu Diyus buy alay nan kamalaêtan ha biyay yu. ");
INSERT INTO abc_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Impapanalangin kun tulungan kawun Panginuun Jesu Cristo ya panay kawun mamuhayaꞌ matuynung êmên mapapurian buy maparangalan hi Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Pawpatêl ku, labay kun matandan yun hay pagkakulung kuy mamhakaꞌ nagawa takay kumalataꞌ Mahampataꞌ Balita tungkul kan Apu Jesus. ");
INSERT INTO abc_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Ta ha nangyari, natandan sawsundalun pakabantay ha palasyu buy kanayunaꞌ dilag kaytiya ingkulungaku ta nangangaralakun tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Buy alwan dilin habatu ta ha pagkakulung ku, madla ha pawpatêl tamu ha Panginuun ya lalu pun nagin matatagaꞌ kaluuban buy alan limun nangangaral Nunghung Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Pêtêgaꞌ mayin umnun nangangaral tungkul kan Apu Jesu Cristo ta naiinggit hilan dili buy labay lan ipaakitaꞌ mabiyaha pun hila kisira kangku. Nuwa mayin mêt nangangaralaꞌ talagan mahampataꞌ kaluuban la buy labay lan makatulung ha pagpapalaganap Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Impapangaral la hi Apu Jesu Cristo ta pêtêgaꞌ pagmamaal la kangku. Ta tanda lan kaluuban Apu Diyus ya pagkakulung ku takay maitanggul kuy Mahampataꞌ Balita ha tawtawung awyun kun nangakakulung kayti. ");
INSERT INTO abc_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Nuwa hay kanayun, alwan mahampataꞌ kaluuban la. Nangangaral hilan Mahampataꞌ Balita ha sarili la dilin kalabayan takay puriin hila. Indap la kaban nakakulungaku kayti, mapahkitan lay kaluuban ku. ");
INSERT INTO abc_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Nuwa ala kangkuy hatu. Pêtêg man u alway hangarên la, basta ipangaral lan dili hi Apu Jesu Cristo, natutula kuy na. Buy patuluyakun matula. ");
INSERT INTO abc_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Ta tanda kun ha pamêmêêtan panalangin yu, buy ha tulung Ispiritun nangibat kan Apu Jesu Cristo, makalayaku mêt kayti. ");
INSERT INTO abc_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Mamhakaꞌ hangarên ku buy pagꞌasan ah ku mapadêngꞌêy ha hitaman nu alwan katbuh hinhatu panayakun magin matatag takay maparangalan ku hi Apu Jesu Cristo ha biyay ku maski ikamati ku pun u alwa. ");
INSERT INTO abc_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Ta para kangku, hay mabiyayiꞌ taêmên maparangalan hi Apu Jesu Cristo, buy hay kamatiyaniꞌ mas mahampat ta tanda kun makaawyun ku yay na. ");
INSERT INTO abc_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Nuwa nu pakadangên pun Apu Diyus ya biyay ku, mahampat mêt ta dêla punakun magawa ha paglilingkud kana. Kaya ah ku tanda nu hita pilin ku. ");
INSERT INTO abc_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Nahahatiyaꞌ ihip ku ta labay ku hanan matiyana takay makaawyun kuy na hi Apu Jesu Cristo ta atiyaꞌ mas mahampat. ");
INSERT INTO abc_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Nuwa para ha ikahampat yu, kaylangan ku pun mabyay. ");
INSERT INTO abc_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Kaya siguraduwakun kumadang punaꞌ biyay ku buy makaawyun yu ku takay matulungan ku kawun magin matatag ha pananampalataya kan Apu Jesus buy magin masaya ta ha pananampalataya yu. ");
INSERT INTO abc_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Buy nu makabalikakuy na kayu, mas lalu yun puriin hi Apu Jesu Cristo ta imbalik na ku kayu. ");
INSERT INTO abc_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Kaya hapaêg, hitamanaꞌ mangyari kantamu, mamuhay kawun ayun ha Mahampataꞌ Balita tungkul kan Apu Jesu Cristo takayꞌêmên makaawyun yu ku u alwa, mabalitꞌan kun nagkakagiha kawu buy miaawyunaꞌ naytatanggul pananampalataya yun ayun ha Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Ah kawu malimu ha libun nanꞌuusig kayu. Ta nu ah kawu nalilimu kanla, matandan lan mipamalaêt hila ha alan angganaꞌ kaparusaan Apu Diyus nuwa kawu, iligtas na. ");
INSERT INTO abc_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Ta alwa kitamu dilin pinagkaluubanaꞌ manampalataya kan Apu Jesus nu alwan makadanas mêt pagtitiis alang alang kana. ");
INSERT INTO abc_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Hay pagꞌiirapaꞌ nadadanas yu hapaêg katbuh mêt ha pagꞌiirapaꞌ naakit yu kangku hinhatu buy angga hapaêg, nababalitꞌan yun nadadanas ku pun. ");
INSERT INTO abc_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Kaya ba pawpatêl ku, nu mayin kawun kasiglaan ta ha pakikigiha yu kan Apu Jesu Cristo, nu mayin kawun kaaliwan ha pagmamaal na, nu mayin kawun pakikigiha ha Ispiritun Apu Diyus, nu mayin kawun malasakit buy ingalu ha gihat giha, ");
INSERT INTO abc_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","lubusun yuy nay tula ku: mikakasundu kawu buy magmaalan, buy mikakagiha ha ihip buy layunin. ");
INSERT INTO abc_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Ah kawu manggawan hitaman ta labay yu dilin itagꞌay kawu buy magyabang nu alwan magpakayêpa kawu ha gihat giha buy ituring yun mas mahampataꞌ kanayun kisira kayu. ");
INSERT INTO abc_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Alwan dilin hay ikahampat sarili yuy ihipin yu nu alwan hay ikahampat mêt kanayun. ");
INSERT INTO abc_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Kaylanganaꞌ katbuh kaihipan Apu Jesu Cristoy kaihipan yu. ");
INSERT INTO abc_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Maski nanaakit kanay pagkaDiyus na, Ah na impilitaꞌ mamirmin kapantay Apu Diyus ");
INSERT INTO abc_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Nu alwan imbalag nay pagkaDiyus na. Buy hin impanganak ya kayti ha mundu, Naglingkud ya katbuh alipên. ");
INSERT INTO abc_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Nagpakayêpa ya Buy nagin mahunulun anggan kamatiyan, Magin kamatiyan ha krus. ");
INSERT INTO abc_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Kaya ban binyanan yan Apu Diyus pinakamatagꞌaya parangal Buy lagyun alan kapantay ");
INSERT INTO abc_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Takay ha lagyu na, hay laataꞌ dilag ha langit, dilag ha luta, buy dilag ha lalên luta, Magluhud buy magpuri kana. ");
INSERT INTO abc_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Buy ipahayag lan, “Hi Apu Jesu Cristoy Panginuun.” Ta baistu, maparangalanaꞌ Bapa tamun hi Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Kaya ban minamaal kun pawpatêl, hin miaawyun kitamu pun, panay yun hinuhunulaꞌ impapangaral ku kayu. Hapaêgaꞌ madayuwakuy na kayu, lalu kaw pun hanan humunulaꞌ mayin limu buy paggalang kan Apu Diyus takay malubusaꞌ kaligtasan yu. ");
INSERT INTO abc_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Ta hi Apu Diyus ya nanamꞌi kayun pagnanaisaꞌ makahunul kana buy kakayaanaꞌ magawa yu nu hita kaluuban na. ");
INSERT INTO abc_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Mamuhay kawun alan riklamu buy ribatiyan ");
INSERT INTO abc_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","takay alan maakitaꞌ malaêt kayu buy maakitaꞌ mahampataꞌ luub yu ta anak kawun Apu Diyus. Ta maski napapalibutan kawun subran mangalaêtaꞌ tawu kayti ha mundu, dapay kawun bêtêwên ha langitaꞌ magin dêkêt la ");
INSERT INTO abc_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","kaban impapangaral yu kanlay Mahampataꞌ Balita ya nanamꞌin biyay ya alan anggan. Gawꞌên yuy ati taêmên pagbalik Apu Jesu Cristo kayti ha mundu, maipagmalaki kun ah nasayangaꞌ pagtitiyaga ku. ");
INSERT INTO abc_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Buy nu kaylanganaꞌ ibunlugaꞌ daya ku ha panampalataya yu bilang handug kan Apu Diyus taêmên magin ganapaꞌ panampalataya yu kana, maligaya kuy na buy makitulaku kayu. ");
INSERT INTO abc_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Kaya matula kaw mêt buy makitula kangku. ");
INSERT INTO abc_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Hapaêg, nu ipahintulut Apu Jesu Cristo, palakwun ku bahên hi Timoteo ha madalin panawun takay pagbalik na kayti, mapanatagaꞌ kaluuban ku nu matandan kuy nay kalagayan yu. ");
INSERT INTO abc_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Ta maliban kan Timoteo, alay nan kanayunaꞌ katbuh kun pêtêgaꞌ nagmamalasakit kayun laat. ");
INSERT INTO abc_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ta hay kanayun, sarilin labay diliyaꞌ iniihip alwan hay labay Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Nuwa tanda yuy na nu pakapakun napapêtganaꞌ katapatan Timoteo. Tinulungan na ku ha pangangaral Mahampataꞌ Balita katbuh gihay anakaꞌ tinutumulung ha sarili nan bapa. ");
INSERT INTO abc_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Kaya nu matandan kuy na nu hita mangyari kangku kayti ha kulungan, palakwun ku ya bahên. ");
INSERT INTO abc_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Naniniwalakun ha tulung Panginuun, makalatêngaku mêt bahên kayu ha madalin panawun. ");
INSERT INTO abc_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Hapaêg, naihip kun paulinana bahên kayuy patêl tamun hi Epafrodito, kaparihu kun naglilingkud kan Apu Diyus buy naytatanggul ha Mahampataꞌ Balita. Pinalaku yu ya kayti takay gitanaꞌ tulung yu buy tulunganaku mêt. ");
INSERT INTO abc_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Labay nay na talagan makauli bahên ta nagꞌaalala ya hin nabalitꞌan nan nakalatênganaꞌ kayun nagkahakit ya. ");
INSERT INTO abc_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Pêtêg bayaꞌ nagkahakit ya buy kayêk tanan nati. Nuwa kinaingalwan yan Apu Diyus maski haku mêt ta pinagaling ya. Ta nu nati ya, subray lungkutaꞌ matanam ku. ");
INSERT INTO abc_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Kaya labay ku yay nan paulin talaga bahên takay matula kawu nu maakit yu yan uman buy mabawꞌahanaꞌ lungkut ku. ");
INSERT INTO abc_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Kaya ha pagbalik na bahên, tanggapên yu yan lubusaꞌ tula yu bilang patêl ha Panginuun Jesus. Igalang yu mêtaꞌ tawtawung katbuh na ");
INSERT INTO abc_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ta ha paglilingkud na kan Apu Jesu Cristo, kayêk tana hiyan nati. Insuung na ha panganibaꞌ biyay na takayꞌêmên tulunganaku ya gawꞌên yu mêt nu dilag kawu kayti. ");
INSERT INTO abc_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Hapaêg, pawpatêl ku, matula kawu ta ha pakikigiha yu ha Panginuun Jesus. Ah ku magsawang umanên kayuy impangaral kuy na hinhatu ta atiyaꞌ magpatatag kayu nu mayin mangaral kayun alwan pêtêg. ");
INSERT INTO abc_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Magꞌingat kawu ha tawtawung ugalin ayêp, mapanggawan malaêt buy impipilit lan dapat kawun tulin takay miligtas kawu. ");
INSERT INTO abc_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Nuwa hakitamuy pêtêgaꞌ tinuli ha pamalayan Apu Diyus ta nagpupuri kitamu kana ha tulung Ispiritu na buy impagmamalaki tamuy ginawan Apu Jesu Cristo. Buy ah kitamu nagtiwalan maligtas kitamu ha pamêmêêtan kaugaliyanaꞌ hinuhunul tawtawu. ");
INSERT INTO abc_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Ta nu habayin diliya pinununghungan, mayinaku mêt maipagmalaki. Kaya nu mayin mannunghungaꞌ maari yan magmalaki ta ha paghunul na ha nakaugaliyan libun Judio, lalu punaku. ");
INSERT INTO abc_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Ta hin walun allêwaku punaꞌ impanganak, tinuliyakuy na. Pêtêgaꞌ Hebreo haku ta Hebreoy mangatuwa ku buy pêtêgaꞌ Israelita ku ta ibataku ha lahin Benjamin. Buy nu ha paghunulaꞌ naman ha kautuhan Hawjudio, talagan hinuhunul kuy ati ta gihakun Pariseo. ");
INSERT INTO abc_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Buy talagan labay kun maparangalan hi Apu Diyus kaya inusig kuy libun nananampalataya kan Apu Jesus ta indap kun matula ya. Buy nu tungkulaꞌ naman ha paghunul ha kautuhan, alan mainunghung kangku ta hinunul kun laat. ");
INSERT INTO abc_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Habiyanaꞌ bawbagayaꞌ intuturing kun maalaga hin una nuwa hapaêg alay nan alaga kangku ta labay kun makilalan lubusan hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","9","Buy alwa dilin habayin ta hay laataꞌ bagay alan alaga nu ikumpara ha pagkakilala ku kan Apu Jesu Criston Panginuun ku. Inturing kuy nan alan alagay ati buy madumi hapaêg takayꞌêmên lubusan kun makilala hi Apu Jesu Criston Panginuun ku buy makagiha ku ya. Alwan ha paghunul ku ha kautuhan kaya inturingakun matuynung Apu Diyus nu alwan ha pananampalataya ku kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Hapaêg, labay kun lalu pun makilala hi Apu Jesu Cristo buy madanasanaꞌ kapangyarian pagkabiyay nan uman. Labay ku mêt makigiha ha kanan pagꞌiirap buy magin katbuh kana ha kanan kamatiyan ");
INSERT INTO abc_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","takayꞌêmên maski matiyaku, mabiyayakun uman. ");
INSERT INTO abc_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Alwa kun innununghungaꞌ natupad kuy nay laataꞌ habayin. Alwa ku mêt innununghungaꞌ talagan nagin katbuhakuy nan Apu Jesu Cristo. Nuwa sinisikap kun mas magin katbuh na ta habainaꞌ dahilan ha pamawêg na kangku. ");
INSERT INTO abc_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","14","Pawpatêl, alwa kun innununghungaꞌ mas nagin katbuh nakuy na nuwa gihay bagayaꞌ ginagawa ku. Ah kuy na iniihipaꞌ bawbagay ha nakaraan, buy sinisikap kun makuway bawbagayaꞌ papalatêng. Katbuh gihay manlulukhu, sinisikap kun malatêngaꞌ angganan takay makwa kuy gantimpala ya binawêgakun Apu Diyus ha langit ha pamêmêêtan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Kaya bay habayinaꞌ dapat tamun ihipin, hakitamun matatagana ha pananampalataya. Nuwa nu alwan habatuy iniihip yu, ipatêbêk Apu Diyus kayuy tama. ");
INSERT INTO abc_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Habatu man, hay maalaga, magpatuluy kitamu ha paghunul ha kapêtêganaꞌ impahayag Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Pawpatêl, tubhun yu ku buy tubhun yu mêtaꞌ tawtawung titimbuh kami. ");
INSERT INTO abc_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Ta madlan tawtawung nannununghungaꞌ nananampalataya hila kan Apu Jesus nuwa maakit ha malaêt lan pamumuhayaꞌ sinusumalungat hila ha pangangaral tungkul ha pagkamatin Apu Jesu Cristo ha krus. Panay kuy nan innununghungaꞌ habatu kayu hin una nuwa hapaêg innununghung kun umanaꞌ ati kayu kaban nananangihaku. ");
INSERT INTO abc_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Alan anggan kaparusaanaꞌ kalatngan la, hay diyus lay labay nawini la, buy impagyayabang lay bawbagayaꞌ dapat lan ikadêngꞌêy. Alay na hilan kanayunaꞌ iniihip nu alwan hay bawbagay dili kayti ha mundu. ");
INSERT INTO abc_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Nuwa hay pêtêgaꞌ rugal tamuy istu ha langit. Buy baistu mangibataꞌ Tagapagligtas tamun hi Apu Jesu Cristo ya inêêtêng tamun mayin pagkahabêk. ");
INSERT INTO abc_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Ha paglatêng nan uman, bayuun nay nawini tamun maina buy nanati buy gawꞌên nan katbuh ha nawini na hin binyay yan uman Apu Diyus. Gawꞌên nay ati ha pamêmêêtan kapangyarian nan nanyayakup ha laataꞌ bagay. ");
INSERT INTO abc_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Kaya bay pawpatêlaꞌ minamaal ku buy kinahahabêkan, hakawun nanamꞌin tula kangku buy gantimpala ku ha paglilingkud, magin tapat kawu ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Nakikinunghungaku kayu Eudia buy Sintique ya magkaayus kawuy na ta mipatêl kawu ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Nakikinunghungaku mêt kamun tapat kun kaawyun ha pangangaralaꞌ tulungan mun magkaayusaꞌ babayin ti. Ta kaawyun ku mêt hilan naytatanggul Mahampataꞌ Balita tungkul kan Apu Jesus. Kaawyun hilan Clemente buy kanayun punaꞌ kaawyun kun naglilingkud. Hay lagyu lay nakasulat ha librun biyay ya pinanyuyulatan libun lagyun mabꞌiyan biyay ya alan anggan. ");
INSERT INTO abc_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Panay kawun matula ha pakikigiha yu ha Panginuun Jesus. Umanên ku, matula kawu! ");
INSERT INTO abc_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Ipaakit yu ha laataꞌ mahampataꞌ kaluuban yu ta madaniyanan lumatêngaꞌ Panginuun Jesus. ");
INSERT INTO abc_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Ah kawu magꞌalala ha hitamanaꞌ bagay nu alwan manalangin kawu kan Apu Diyus buy makikwa kanan mayin pasasalamat. ");
INSERT INTO abc_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Nu habatuy gawꞌên yu, biyan kawun Apu Diyus kapayapaan ha pusu buy ha ihip yun ah kayan matêbêk tawtawu. Buy hay kapayapaanaꞌ atiyaꞌ magꞌingat kayu takay ah kawu magꞌalala ta nakigiha kawuy na kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Pawpatêl ku, bilang pagtatapus, panay yun ihipinaꞌ bawbagayaꞌ mangahampat buy kapuri puri: bawbagayaꞌ pêtêg, kagalang galang, mangatuynung, mangalinis, mangaganda, buy marangal. ");
INSERT INTO abc_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Gawꞌên yuy laataꞌ natandan yu, natanggap, nalêngê, buy naakit yu kangku. Buy mapakayu hi Apu Diyus ya nanamꞌin kapayapaan. ");
INSERT INTO abc_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Subray tula ku ha Panginuun ta maski matagalanay panawunanaꞌ nanlibah, impaakit yun umanaꞌ malasakit yu kangku. Tanda kun ah yu ku naliwan nuwa ala kawun dilin mautuhanaꞌ mantan tulung kangku. ");
INSERT INTO abc_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Alwa kun innununghungaꞌ ati ta nangangaylanganaku ta nagin sanayakuy nan mabyay maski hita punaꞌ kalagayan ku. ");
INSERT INTO abc_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Nadanas kuy nay kairapan buy kasaganaan. Tanda kuy nan magin masaya hitamanaꞌ mangyari kangku, maski mabhuy u mabitil, masagana u nangangaylangan. ");
INSERT INTO abc_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Buy maski hitamanaꞌ kalagayan ku, makaya ku ha tulung Apu Jesu Cristo ya nanamꞌin lakas kangku. ");
INSERT INTO abc_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Habatuman nagpapasalamataku kayu ta tinulungan yu ku ha kairapanaꞌ nadanas ku. ");
INSERT INTO abc_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Buy tanda yun libun tiga Filipos, hin unan naniwala kawu ha Mahampataꞌ Balita tungkul kan Apu Jesus, hakawun diliyaꞌ mananampalatayan nanulung ha libun kaylangan ku hin nagꞌalihaku ha Macedonia. ");
INSERT INTO abc_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Ta maski hin dilagaku ha Tesalonica, umnun bisis kaw mêt namamagtan tulung kangku. ");
INSERT INTO abc_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Innununghung kuy ati, alwan labay kun dilin makatanggap uman tulung ibat kayu nu alwan labay kun madagdagan punaꞌ pagpapala yu ta ha pagtulung yu kangku. ");
INSERT INTO abc_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Hapaêg, hay tulungaꞌ impagtan yu kangku ha pamêmêêtan Epafrodito, sapatana buy subra pun bay. Buy hay tulung yuy katbuh mabanguy handug kan Apu Diyus ya katanggap tanggap buy nanamꞌin tula kana. ");
INSERT INTO abc_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Buy ibat ha kayamanan nan ah nauubuh, ibin Apu Diyus ya pinaglilingkuran kuy laataꞌ kaylangan yu ta nakigiha kawu kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Puriin tamuy Bapa buy Apu Diyus tamu makanuman. Amen. ");
INSERT INTO abc_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Kumustaꞌ kawuy na bahên pawpinilin Apu Diyus ya nananampalataya kan Apu Jesu Cristo? Kinukumusta kaw mêt pawpatêl tamun kaawyun ku kayti. ");
INSERT INTO abc_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Kinukumusta kaw mêt laat mananampalataya kayti laluy nay libun naglilingkud ha palasyun Empiradur. ");
INSERT INTO abc_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Mamirmiꞌ kayun laataꞌ kahampatan Panginuun Jesu Cristo.");
INSERT INTO abc_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Haku hi Pablo ya insugun Apu Cristo Jesus ayun ha kaluuban Apu Diyus. Nanyuyulataku kayu kaawyun ku hi Timoteo ya patêl tamu ha pananampalataya. ");
INSERT INTO abc_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Pawpatêl ku, nanyulataku kayun dilag bahên ha Colosas ya pinilin Apu Diyus buy tapat kan Apu Jesu Cristo. Dalangin kun mapakayuy kahampatan buy kapayapaanaꞌ ibat kan Apu Diyus ya Bapa tamu. ");
INSERT INTO abc_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Ha laataꞌ panalangin yan para kayu, panay kamin nagpapasalamat kan Apu Diyus ya Bapan Panginuun tamun hi Apu Jesu Cristo, ");
INSERT INTO abc_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ta nabalitꞌan yana pananampalataya yu kan Apu Cristo Jesus buy hay pagmamaal yu ha laataꞌ pinilin Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Ginawa yuy habatu ta mayin kawun pagꞌasan iibin Apu Diyus kayuy inhanda na ha langit. Nagkamayin kawun pagꞌasan ati hin nalêngê yuy nay kapêtêgan ya hay Mahampataꞌ Balita tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Hay Mahampataꞌ Balitan ati kinumalat ha laat rugal ha mundu buy madlan biyay ya nabayu katbuh ha nangyari kayu hin nalêngê yu buy natêbêkaꞌ kapêtêgan tungkul ha kahampatan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Natandan yuy Mahampataꞌ Balitan ati kan Epafras. Giha yan mapagkatiwalꞌan buy minamaalaꞌ patêl ha pananampalataya ya kaawyun yan mêt naglilingkud kan Apu Jesu Cristo para ha ikahampat yu. ");
INSERT INTO abc_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Nabalitꞌan yan kan Epafras ya pagmamaal yu ha balang giha ya inꞌibin Ispiritun Apu Diyus kayu. ");
INSERT INTO abc_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Kaya ibat hin allêwaꞌ natandan yana tungkul kayu, panay kamin nananalangin para kayu. Impipikikwa yan kan Apu Diyus ya biyan na kawun kabiyahaan buy pagkatêbêkaꞌ ibat ha Ispiritu na takay lubus yun matandanaꞌ kaluuban na. ");
INSERT INTO abc_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Ha habatu, mamuhay kawun karapatdapat buy kalugudꞌlugud ha Panginuun, panay kawun manggawan mahampat buy lalun lumalêy pagkakilala yu kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Nananalangin kami mêt kan Apu Diyus ya panay patatagên nay pananampalataya yu ha pamêmêêtan makapagtakan kapangyarihan na takay tiisin yun mayin tula ya laataꞌ maranasan yu. ");
INSERT INTO abc_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Panay kawu mêt magpasalamat kan Apu Diyus ya Bapa, gawan ginawa na kawun karapatdapat takayꞌêmên manaên yuy inhanda na ha langit para ha libun tawung pinili na ya dilag ha kahawangan. ");
INSERT INTO abc_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Inligtas na kitamu ibat ha kadlêman kapangyarihan Satanas ta hapaêg dilag kitamuyna ha paghaharin minamaal nan Anak. ");
INSERT INTO abc_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Ha pamêmêêtan Anak na tinubus na kitamu, hay labay sabin, pinatawadanay libun kasalanan tamu. ");
INSERT INTO abc_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Hi Apu Jesu Cristo, maakit kana hi Apu Diyus ya ahê nanakit. Bayu pun inlikhay laat, dilagana hi Apu Jesus ya makapangyarihan ha laat. ");
INSERT INTO abc_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Ha pamêmêêtan Apu Jesu Cristo, ginawan Apu Diyus ya laataꞌ dilag ha langit buy dilag kayti ha mundu, hay libun nanakit buy ahê nanakit katbuh anghil buy anituy naghahari, mayin katungkulan, namumunu, buy mayin kapangyarihan. Inlikhay laat ha pamêmêêtan Apu Jesu Cristo buy para kana. ");
INSERT INTO abc_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Bayu pun inlikhay laat, dilagana hi Apu Jesu Cristo, buy ha pamêmêêtan na, panay maayusaꞌ laat. ");
INSERT INTO abc_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Hi Apu Jesu Cristoy u hay labay sabin hiyay puun ha libun mananampalatayan miaawyun ya inꞌiitbuh ha nawini na. Hiyay pinangibatan bayun biyay la ta hiyay unan nabyay ha nangangamati takay hiyay pinakamatagꞌay ha laat. ");
INSERT INTO abc_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Ta kaluuban Apu Diyus ya lubusan mamirmiꞌ kan Apu Jesu Cristo ya pagka Diyus na. ");
INSERT INTO abc_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Buy ha pamêmêêtan dayan Apu Jesu Cristo hin nipaku ya ha krus, impagkasundun Apu Diyus ha sarili nay laataꞌ inlikha na, ha langit buy ha mundu. ");
INSERT INTO abc_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Hinhatu, madayu kawu kan Apu Diyus buy nakapati na kawu, gawan ha malaêtaꞌ ihip yu buy ha libun gawa yu. ");
INSERT INTO abc_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Nuwa hapaêg, ha pamêmêêtan pagkamatin nawinin Apu Jesus ha krus, impagkasundu kawun Apu Diyus ha sarili na takay maiarap na kawun banal, malinis, buy alan maakitaꞌ malaêt ha pamalayan na. ");
INSERT INTO abc_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Nuwa kaylangan yun mamirmin tapat buy matatag ha pananampalataya yu. Buy ah yu paulayên maalih ya pagꞌasa yu ha libun impangaku ha Mahampataꞌ Balitan nalêngê yu. Hay Mahampataꞌ Balitan ati, impangaralanaꞌ ha laataꞌ rugal kayti ha mundu buy haku hi Pablo ya giha ha nangangaral ati. ");
INSERT INTO abc_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Natutula ku ha libun pagꞌiirapaꞌ nadadanasan ku para kayu buy ipagpatuluy kuy pagꞌiirapaꞌ ati katbuh nadanas Apu Jesu Cristo para ha libun mananampalatayan miaawyun ya hiyan nawini na. ");
INSERT INTO abc_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Intalaga kun Apu Diyus ya magin tagapaglingkud ha libun mananampalatayan miaawyun takay maipangaralaꞌ kabuuan nunghung na kayun alwan Hawjudio. ");
INSERT INTO abc_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Hay kabuuan nunghung na nakalihim hinhatu, ahê pun impatandan Apu Diyus ha libun ninunu tamu hinhatu. Nuwa hapaêg, impatanda nay na kantamun libun pinili na. ");
INSERT INTO abc_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Labay Apu Diyus ya ipatanda na ha libun pinili na ya dakila buy makapagtakan lihimaꞌ planu na kayun alwan Hawjudio. Ati ya lihimaꞌ planu na ya mamirmi kayu hi Apu Jesu Cristo. Buy ati bayaꞌ mamꞌin kasiguraduan kantamu ya maranasanaꞌ makabahagi ha kahampatan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Kaya impapangaral yan hi Apu Jesu Cristo ha laat tawu. Pinapaalalahanan yan buy tinutuduwananaꞌ balang giha ha pamêmêêtan kabiyahaanaꞌ inꞌibi kanyan Apu Diyus. Ha habatu, maiarap yan ya balang giha kan Apu Diyus ya ganapaꞌ kanlan pananampalataya ta ha pakikigiha la kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Kaya nagsisipag buy nagtitiyaga kun mangaral Mahampataꞌ Balita ha laat tawu ha pamêmêêtan kapangyarihan Apu Jesu Cristo ya mamꞌin lakas kangku. ");
INSERT INTO abc_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Labay kun matandan yu nu pakapakunaꞌ pagiirapaꞌ dinanas ku para kayu, buy ha libun tiga Laodicea, buy ha laataꞌ ahê pun nakakakilala kangkun arapan. ");
INSERT INTO abc_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Ginagawa kuy ati takay palakasênaꞌ luub yun laat buy magkagiha kawu ha pagmamaalan. Ha habatu, lubus yun matandan buy matêbêkaꞌ lihimaꞌ planun Apu Diyus ya hiya bayaꞌ Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Ta hi Apu Jesu Cristoy pinangingibatan laataꞌ kabiyahaan buy pagkatanda. ");
INSERT INTO abc_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Innununghung ku kayuy libun ati takay ah kawu mailêtêp hitalagyuman ha pamêmêêtan mangahampataꞌ pangangatuwiranaꞌ alwan pêtêg. ");
INSERT INTO abc_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Ta maski ala ku bahên kayu, panay kawun dilag ha ihip ku. Buy hin nabalitꞌan kuy maayusaꞌ pamiaawyun yu bilang mananampalataya buy matatagaꞌ pananampalataya yu kan Apu Jesu Cristo, natutula kuy na. ");
INSERT INTO abc_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Kaya bay ta tinanggap yu hi Apu Cristo Jesus bilang Panginuun yu, ipagpatuluy yun mamuhay kawu ayun ha kaluuban na. ");
INSERT INTO abc_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Matatagaꞌ pananampalataya yu buy nagtitiwala kana kaya ipagpatuluy yuy ati buy lumaguy pagkakilala yu kana. Tumatagaꞌ pananampalataya yu kana dapay naipangaral kayu. Buy panay kawun magpasalamat kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Magꞌingat kawu ha libun nanunudun alan silbi buy maylêtêp takay ah la kawu maagkat. Ta alwan ibat kan Apu Jesu Cristoy aralaꞌ ati, nu alwan ibat dili ha daan kaugaliyan buy ha libun paraan ha mundu. ");
INSERT INTO abc_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Kaya ah kawu palêtêp, ta hinhatun nagin tawu hi Apu Jesu Cristo, hay buun pagka Diyus, dilaganaꞌ kana. ");
INSERT INTO abc_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Nagin ganap kawuy na ta ha pakikigiha yu kan Apu Jesu Cristo ya hiyan manyakup ha laataꞌ anitun namumunu buy mayin kapangyarihan. ");
INSERT INTO abc_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Ta ha pakikigiha yu kan Apu Jesu Cristo, bilang tuli kawuy na. Hay pagtutulin ati ya alwan ayun ha gawan tawu nu alwan ayun ha Ispiritun Apu Diyus, hay payꞌalih mangalaêtaꞌ kalabayan nawini yu. Atiyaꞌ pagtutulin ibat kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Ha pamêmêêtan pagbawtismu kayu, nambuh kawuy nan inꞌêlbêng buy nabyay uman katbuh Apu Jesu Cristo, ta naniwala kawu ha kapangyarihan Apu Diyus ya namiyay kana. ");
INSERT INTO abc_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Hinhatu, hakawuy inturing Apu Diyus nati ta ha libun kasalanan yu buy ha paghunul yu ha mangalaêtaꞌ kalabayan nawini yu. Nuwa hapaêg, binyay kawuy nan Apu Diyus kaawyun Apu Jesu Cristo. Pinatawad nay laataꞌ kasalanan tamu. ");
INSERT INTO abc_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Mayin kitamun pananagutan ta ah tamu nahunulaꞌ Kautuhan nuwa inalihanan Apu Jesu Cristoy ati ha pamêmêêtan pagkamatiꞌ na ha krus. Kaya ah kitamu maparusaan. ");
INSERT INTO abc_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Ha pamêmêêtan pagkapakun Apu Jesu Cristo ha krus, tinalun Apu Diyus ya libun anituy maghari buy mayin kapangyarihan. Hay libun anitun ati dinakêp na buy imparada ha kadlan bilang patunayaꞌ nagtagumpay ya. ");
INSERT INTO abc_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Kaya andi yu paulayênaꞌ tawtawun manghatul kayu nu hita puwidin maêkan, mainêm, u nu hita dapat gawꞌên ha balang pista, ha bayun buyan u ha Allêw Pamamahinga. ");
INSERT INTO abc_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Hay libun utuhaꞌ ati palatandaan dili ha libun bagay ya palatêng. Nuwa hi Apu Jesu Cristo ya katuparan laataꞌ ati. ");
INSERT INTO abc_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Mayin nagpapakayêpa kanwari buy impipilit lay kaylangan mêt sambaênaꞌ libun anghil Apu Diyus. Innununghung lay mayin hilan karapatan ta ha nakit la ha libun hulêplêp la buy impagyayabang lay ati, nuwa alwan pêtêg, ta ibat dili ha sarili lan ihip. Andi kawu maniwala ha innununghung la, takay ahê maalih ya gantimpalan inhandan Apu Diyus para kayu. ");
INSERT INTO abc_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Ah hila nakatugnu kan Apu Jesu Cristo ya hiyay u hay labay sabin hiyay puun ha libun mananampalatayan miaawyun. Buy hiyay mamiugnay buy mangalênggêp kantamu bilang nawini na. Ha dapay habatu inlulumagu kitamu ayun ha kaluuban Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Hin nati hi Apu Jesu Cristo, nambuh nati kawu mêt kaawyun na buy pinalaya kawuy na ha libun paraan ha mundu. Angkaya yu pun hinuhunulaꞌ inꞌuutuh lan, ");
INSERT INTO abc_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“Andi dukpanaꞌ ati,” “Andi tawayana atu,” “Andi galawênaꞌ habayin”? ");
INSERT INTO abc_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Ta hay kapêtêgan, habayinaꞌ bawbagayaꞌ imbabawal la, tungkul dili ha libun bagay ya nauubuh nu maêkan u maênêm. Kaya andi yu hunulunaꞌ ati ya utuh buy aral ya gawaꞌgawan dilin tawu. ");
INSERT INTO abc_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Hay libun utuhaꞌ in, nu balayên yu, dapay pêtêgaꞌ kabiyahaan ta intutudu lan kaylangan humunul ha kanlan mahigpitaꞌ pagsamba, magpakayêpa kanwari, buy pairapanaꞌ nawini. Nuwa hay pêtêg, alan silbi ya ati, ta alay naman maitulung ya mapigilanaꞌ kalabayan nawini. ");
INSERT INTO abc_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Hin binyay uman hi Apu Jesu Cristo nambuh kaw mêtanan binyan bayun biyay, kaya hangarên yuy libun bagayaꞌ dilag ha langit, nu haantun nakaitnu hi Apu Jesu Cristo ya mayin karangalan buy kapangyarihan ha kanan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Hangarên yuy libun dilag ha langit, alwan libun bagayaꞌ dilag kayti ha mundu. ");
INSERT INTO abc_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Ta naituring kawuy nan nati ha daan yun pamumuhay. Buy mayin kawuy nan bayun biyay kaawyun Apu Diyus ta ha pakikigiha yu kan Apu Jesu Cristo ya alwa pun lubusaꞌ naipatanda. ");
INSERT INTO abc_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Hi Apu Jesu Cristoy pinangibatan bayun biyay yu buy nu lumatêngaꞌ panawunaꞌ mahayag ya, mahayag kawu mêt buy parangalan kawun kaawyun na. ");
INSERT INTO abc_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Kaya alihin yuy nay hitamanaꞌ kalabayan nawini yu katbuh pamitêpêltêpêl, kaalayan, malaêtaꞌ kalabayan, buy sakim, ta nu sakim ka, dapay ka mêtanan nagpuri ha diyusdiyusan. ");
INSERT INTO abc_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Ta hay libun manggawan habatu, parusaan hilan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Hinhatu, habatu mêtaꞌ ginagawa yu. ");
INSERT INTO abc_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Nuwa hapaêg, alihin yuy nay puut, hakit nakêm, pannununghung malaêt laban ha kaparihu, buy mangaalaya nunghung. ");
INSERT INTO abc_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Andi kawu magsinungaling ha balang giha, ta inalih yuy nay daanaꞌ pamumuhay yu ya mayin malaêtaꞌ gawa. ");
INSERT INTO abc_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","Buy bayuy nay pamumuhay yu ya panay mêt binabayun Apu Diyus ya naylikha kayu taêmên magin katbuh yu ya buy lalu yu ya pun makilala. ");
INSERT INTO abc_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Ha bayun pamumuhayaꞌ ati, alay nan pinagkaibay Hawjudio ha alwan Hawjudio, hay tuli ha alwan tuli, hay libun dayuhan ha libun alwan mahampataꞌ ugali hinhatu, buy alipên ha alwan alipên. Ta hi Apu Jesu Criston diliyaꞌ laat laat buy dilag yay na kantamun laat. ");
INSERT INTO abc_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Kaya ta pinili kawun Apu Diyus buy minaal na, dapat kawun maiingaluun, mahampataꞌ luub, magpakayêpa, mahinahunun, buy matiyaga. ");
INSERT INTO abc_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Mipagpasinsiyaan kawu buy nu mayin kawun hakit nakêm ha hitalagyuman, magpatawaran kawu, ta pinatawad kawu mêt Panginuun. ");
INSERT INTO abc_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Higit ha laat, magmaalan kawu takay ganapaꞌ pagkakagiha yu ha balang giha. ");
INSERT INTO abc_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Panatiliin yu ha pusu yuy kapayapaanaꞌ ibat kan Apu Jesu Cristo. Ta bilang bahagi kawu ha gigihay nawini na, binawêg kawun Apu Diyus takay mamuhay mapayapa. Buy panay kawu mêt magpasalamat. ");
INSERT INTO abc_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Panatiliin yun mahampat ha pusu yuy libun impangaral Apu Jesu Cristo. Patandan buy tuduwanan yuy balang giha ha pamêmêêtan kabiyahaanaꞌ inꞌibin Apu Diyus. Magkantaan kawun ibaibang kalasin kanta ya pang Apu Diyus ya mayin pasasalamat. ");
INSERT INTO abc_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Buy nu hitamanaꞌ ginagawa yu, ha nunghung man u ha gawa, gawꞌên yuy laataꞌ ati bilang parangal ha lagyun Panginuun Jesus buy magpasalamat kawu kan Apu Diyus ha pamêmêêtan na. ");
INSERT INTO abc_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Hakawun babayi, magpasakup kawu ha ahawa yu ta ati ya dapat yun gawꞌên bilang pakikigiha yu ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Hakawun kaliyakiyan, maalên yuy ahawa yu buy andi yu hila pakhitan. ");
INSERT INTO abc_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Hakawun kaanakan, hunulun yuy mangatuwa yu ha laat bagay, ta ati ya kalugud lugud ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Hakawun mangatuwa, andi kawu manggawan hitamanaꞌ bagayaꞌ ikahakit nakêm kaanakan yu takay ah hila pangꞌinaan nakêm. ");
INSERT INTO abc_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Hakawun alipên, panay yun hunulunaꞌ libun utuh amu yu. Magtarabahu kawun alwan dili ha maakit awꞌamu yu takay matula hila kayu. Maski ah la kawu maakit, gawꞌên yun buun pusu ya mayin limu ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Hitamanaꞌ ginagawa yu, gawꞌên yun buun pusu, para ha Panginuun alwan para ha tawu. ");
INSERT INTO abc_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Ta tanda yu mêtanamanaꞌ biyan na kawun impangaku na ha langit bilang gantimpala yu buy hay pêtêgaꞌ amu yu, hay Panginuung Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Hitalagyumanaꞌ manggawan malaêt, parusaan ya ayun ha ginawa na, ta alan pinipili hi Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Hakawun amu, pakiawyunan yun mahampat buy magin matuynung kawu ha libun alipên yu. Ihipin yun mayin kawu mêt Amu ha langit. ");
INSERT INTO abc_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Buun pusu yun ipagpatuluyaꞌ panalangin yu kan Apu Diyus buy ingatan yuy ihip yu kaban manalangin kawu buy panay kawun magpasalamat kana. ");
INSERT INTO abc_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Manalangin kawu kan Apu Diyus ya manggawa yan paraan takay maipahayag yana ahê pun naipahayag tungkul kan Apu Jesu Cristo. Ta hay pangangaral ku tungkul ha planu na ya dahilan pagkakulung ku. ");
INSERT INTO abc_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Manalangin kawu ya maipangaral kun malinawaꞌ ati ta habatuy dapat kun gawꞌên. ");
INSERT INTO abc_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Pakahampatên yuy pakikiawyun yu ha libun ahê mananampalataya kan Apu Jesus. Buy kaban dilag kawu kanla, sikapên yun ipatanda kanlay tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Nu kanunghung yu hila, dapat mahinahunaꞌ nunghung yu takay manlêngê hila kayu. Buy dapat tanda yu nu pakapakunaꞌ mahampataꞌ sagut yu maski hitamanaꞌ itanung la. ");
INSERT INTO abc_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Hi Tikiko ya minamaal tamun patêl ha pananampalataya, hiyay maybalita kayu tungkul ha kalagayan ku. Mapagkatiwalꞌan ya buy kaparihu yana naglilingkud ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Pinalaku ku ya kayu takay matandan yuy kalagayan yan buy takay palakasên nay luub yu. ");
INSERT INTO abc_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Ha paglaku na bahên kayu ha Colosas, kaawyun na hi Onesimo ya minamaal tamun patêl buy mapagkatiwalꞌanaꞌ kabanwa yu. Hilay maybalita kayu tungkul ha laataꞌ nangyayari kayti. ");
INSERT INTO abc_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Nagpakun kawuy na ambalan Aristarco ya kaawyun kun nakakulung. Nagpakun kawu mêtanaꞌ kanu ambalan Marcos ya pinsan Bernabe. Imbilin kuy na kayu hinhatu ya nu lumatêng bahên hi Marcos, tanggapên yu yan mahampat. ");
INSERT INTO abc_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Nagpakun kawu mêtana ambalan Jesus ya binabawêg Justo. Hi Aristarco, Marcos buy hi Justo, hilan dili ya kaparihu kun Hawjudion kaawyun kun mangaral kayu tungkul ha paghaharin Apu Diyus. Buy hilay nagpapalakas luub ku. ");
INSERT INTO abc_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Nagpakun kawu mêtanaꞌ kanu, ambalan kabanwa yun hi Epafras ya giha mêtaꞌ naglilingkud kan Apu Cristo Jesus. Panay yan nananalangin kan Apu Diyus buun pusu ya magin matatag buy ganapaꞌ paghunul yu ha kaluuban Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Napapêtgan kuy sipagaꞌ ginagawan Epafras para ha ikahampat yu buy ha ikahampat libun dilag ha Laodicea buy Hirapolis. ");
INSERT INTO abc_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Nagpakun kawu mêt ambalan Demas buy hi Lucas ya minamaal tamun duktur. ");
INSERT INTO abc_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Sabin yu mêtaꞌ impapanunghung kuy nagpakunanay pawpatêl ha Laodicea, kan Nimfa buy ha libun mananampalatayan miaawyun ya dilag ha biyag na. ");
INSERT INTO abc_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Pagkabasa yun sulataꞌ ati, ipagtan yu mêt ha libun mananampalatayan miaawyun ya dilag ha Laodicea takay mabasa la mêt. Hay insulat ku kanla, basaên yu mêt. ");
INSERT INTO abc_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Pakinunghung yu kan Arquipo ya yariin nay impapagawan Panginuun kana. ");
INSERT INTO abc_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Hakuy nay ati hi Pablo ya nanyuyulat ha hulin pagbati. Ihipin yun dilagaku ha kulungan buy panay kawun manalangin para kangku. Dalangin kuy mapakayuy kahampatan Apu Diyus.");
INSERT INTO abc_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Haku hi Pablo, lingkud Apu Diyus buy alagad Apu Jesu Cristo. Insuguwakun Apu Diyus taêmên patatagênaꞌ pananampalatayan pawpinili na buy ipatêbêk kanlay kapêtêgan tungkul ha pamumuhayaꞌ kalugud lugud kana. ");
INSERT INTO abc_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Hay pananampalataya buy pagkatêbêkaꞌ nanamꞌin pagꞌasa kantamun makatanggap kitamun biyay ya alan anggan. Hay biyay ya alan angganaꞌ atiyaꞌ impangakun Apu Diyus bayu pun likhaênaꞌ mundu, buy nakanumaniꞌ ah ya nagsinungaling. ");
INSERT INTO abc_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Hapaêg ha panawunaꞌ intakda na, naihayagana ha tawtawuy Mahampataꞌ Balita tungkul ha biyay ya alan anggan. Inꞌibi kangkun Apu Diyus ya Tagapagligtas tamuy tungkulinaꞌ ipangaral kuy ati ayun ha utuh na. ");
INSERT INTO abc_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Nanyulataku kamu maal kun Tito ya pêtêg kun anak ha gigihay pananampalataya. Indadalangin kun mamirmiꞌ kamuy kahampatan buy kapayapaan Bapa tamun hi Apu Diyus buy Tagapagligtas tamun hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Hin nagꞌalihaku ha Islan Creta, innunghung ku kamun mamirmiꞌ ka pun bahên taêmên ayusun muy bawbagayaꞌ ah ku pun naayus buy mamili kan libun mangatuwan mamunu ha libun mananampalataya ha balan rugal katbuh daan kun imbilin kamu. ");
INSERT INTO abc_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Hay pilin mun kaliyakiyanaꞌ mamunu, alan manunghungaꞌ malaêt kanla, gigihan diliyaꞌ ahawa, nananampalataya kan Apu Diyus ya awꞌanak, alwan mangalukêy awꞌanak u mangatigasaꞌ u. ");
INSERT INTO abc_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Ta hay libun namumunu, pinagkatiwalꞌan hilan Apu Diyus kanan gawaên, kaya dapataꞌ ala talagan maakitaꞌ malaêt ha biyay la. Dapat alwa hilan mayabang, mapupuutun, lasinggiru, malupit buy sakim ha pira. ");
INSERT INTO abc_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Nu alwan bukasaꞌ biyag la ha kaparihu, labay labayaꞌ lay kahampatan, biyahang magꞌihip nu hita mahampataꞌ gawꞌên, matuynung, malinisaꞌ pamumuhay buy mapagpigil ha sarili. ");
INSERT INTO abc_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Kaylanganaꞌ matatagaꞌ pananampalataya la ha pêtêgaꞌ aralaꞌ natandan la taêmên maitudu lay ati ha kanayun buy maituynung lay nanyayalungat haati. ");
INSERT INTO abc_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ta madlan tawu bahên ha Cretay alwan naniniwala ha pêtêgaꞌ tudun ati, laluy nay grupun impipilitaꞌ kaylanganaꞌ magpatuliyaꞌ libun nananampalataya kan Apu Jesus. Alan kabuluanaꞌ innununghung la buy inlêlêtêp lay kanayun. ");
INSERT INTO abc_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Dapat bênbênan mu hila ta nanggugulu hilan madlan pamilya ha pangangaral lan bawbagayaꞌ alwan dapat itudu taêmên makakuwa dili hilan pira. ");
INSERT INTO abc_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Innunghung ban giha ha libun mabiyaha kanlan tawtiga Cretay, “Sinungalingaꞌ libun tiga Creta, mangatamad, mangatakaw buy mangalupit katbuh mabangisaꞌ ayêp.” ");
INSERT INTO abc_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Pêtêgaꞌ innunghung na. Kaya talagan pannunghungan mu hila taêmên magin tamay pananampalataya la ");
INSERT INTO abc_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","buy ah lay na panlêngꞌênganaꞌ kawkuwintun gawa gawan dilin Hawjudio u libun kautuhanaꞌ gawa gawan dilin nagpatalibukut ha kapêtêgan. ");
INSERT INTO abc_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Ta ha tawtawung malinisaꞌ pagꞌiihip, malinisanay laat bagay. Nuwa para ha tawung mangalaêt buy alwan nananampalataya ha Panginuun, madumiyaꞌ laat bagay. Ta madumiyaꞌ kaluuban la buy ihip, ah la tanda nu hita mahampat buy malaêt. ");
INSERT INTO abc_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Innununghung lan kilala la hi Apu Diyus nuwa ah nanaakit ha gawa la. Mangalaêt hila, alwa la mêt hinuhunul hi Apu Diyus buy ah la magaway mahampat. ");
INSERT INTO abc_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Nuwa haka Tito, itudu muy ayun ha pêtêgaꞌ aral. ");
INSERT INTO abc_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Hay mangatuwan kaliyakiyan, tuduwanan mu hilan magin mahinahun, kagalang galang buy tandan magꞌihip nu hita mahampataꞌ gawꞌên. Dapat matatagaꞌ pananampalataya la, pêtêgaꞌ pagmamaal la, buy napagtitiisan lay irap. ");
INSERT INTO abc_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Habatu mêt ha mangatuwan babayi, tuduwanan mu mêt hilan mamuhayaꞌ malinis bilang mananampalatayan Apu Diyus. Andi hila manhidan kaparihu buy andi mêt hila mahilig ha alak nu alwan manudu hilan kahampatan ");
INSERT INTO abc_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","taêmên matuduwanan lay libun nakakaanakaꞌ babayi nu pakapakun lan maalênaꞌ awꞌahawa la buy kawkaanakan la. ");
INSERT INTO abc_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Tuduwanan la mêt hilan biyahan magꞌihip nu hita mahampataꞌ gawꞌên, mamuhayaꞌ malinis, maasikasu ha biyag, mabait, buy magpasakup ha ahawa taêmên alan mannunghungaꞌ malaêt ha Nunghung Apu Diyus ya intutudu tamu. ");
INSERT INTO abc_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Habatu mêtaꞌ libun nakakaanakaꞌ kaliyakiyan, tuduwanan mu mêt hilan mabiyahan magꞌihip nu hita mahampataꞌ gawꞌên. ");
INSERT INTO abc_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Buy haka Tito, magin mahampat kan halimbawa ha laataꞌ bagay. Magin tapat ka buy buun pusu kan manudu. ");
INSERT INTO abc_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Dapat tamay intutudu mu kanla buy alan mainunghungaꞌ malaêt kayti takayꞌêmên mipadêngꞌêyaꞌ libun nanyayalungat ta ala hilan manunghungaꞌ malaêt laban kantamu. ");
INSERT INTO abc_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Hay libun alipên, tuduwanan mu hilan magpasakup ha amu la ha laataꞌ bagay taêmên mamꞌi hilan tula ha awꞌamu la. Andi hila panay nagririklamu kanla. ");
INSERT INTO abc_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Buy andi mêt hila manakaw kanla nu alwan ipaakit lan mapagkatiwalꞌan hila takayꞌêmên ha laataꞌ ginagawa la, maipaakitaꞌ kahampatanaꞌ intutudu tamu tungkul kan Apu Diyus ya Tagapagligtas tamu. ");
INSERT INTO abc_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Ta impaakitanan Apu Diyus ya kahampatan na ha ginawa nan paraan taêmên miligtasaꞌ laat tawu. ");
INSERT INTO abc_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Ta ha kahampatan na, intutudu na kantamun ibwatan tamuy libun gawꞌênaꞌ alwan nakakatula kan Apu Diyus buy hay mangalaêtaꞌ labay nawini tamu. Buy mamuhay kitamu kayti ha mundun mangatuynung, biyahan magꞌihip nu hita mahampataꞌ gawꞌên, buy hinuhumunul ha kaluuban Apu Diyus ");
INSERT INTO abc_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","kaban inêêtêng tamuy inaasaanaꞌ nakakatulan paglatêng nan uman. Ha allêwaꞌ tu, maakit tamuy kahawangan Apu Jesu Criston dakilan Apu Diyus tamu buy Tagapagligtas. ");
INSERT INTO abc_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Inꞌibi nay biyay na para kantamu takay tubusun kitamun laat ha kamalaêtan buy linisin kitamu ha kasalanan taêmên mapakana kitamu ya nakahandan manggawan mahampat. ");
INSERT INTO abc_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Kaya habayinaꞌ itudu mu ha libun kapatêlan tamu bahên. Mayin kan karapatanaꞌ tuduwanan hilan humunul buy pannunghunganaꞌ libun nanyayalungat. Buy ah mu paulayênaꞌ baliwalaên hitalagyumanaꞌ innunghung mu. ");
INSERT INTO abc_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Ipaalala mu ha libun mananampalatayan pasakup hila buy humunul ha libun namumunu buy nanunungkulan. Dapat hilan panay nakahandan manggawan mahampat. ");
INSERT INTO abc_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Andi hila mannunghung malaêt laban ha hitalagyuman buy andi hila magribatian nu alwan dapat magpakabait hila buy magpakayêpa ha laat. ");
INSERT INTO abc_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Ta maski hakitamu mêt hinhatu, ah tamu pun kilala hi Apu Diyus. Ah kitamu hinuhumunul kana, agad kitamun naguguluy ha kamalaêtan buy naaalêpên laataꞌ kalasin malaêtaꞌ kalayawan buy kalabayan nawini. Panay kitamun nagꞌiihip malaêt ha gihat giha buy nagꞌiinggitan. Kinasusuklaman kitamun kanayun buy nasusuklam kitamu mêt kanla. ");
INSERT INTO abc_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Nuwa hi Apu Diyus ya Tagapagligtas tamu, impaakit nay kahampatan buy pagmamaal na kantamu ");
INSERT INTO abc_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","hin inligtas na kitamu ha kaparusaan ta ha kawkasalanan tamu. Inligtas na kitamu alwan dahilan ha mahampataꞌ gawa tamu nu alwan ha ingalu na kantamu buy ha pamêmêêtan Ispiritu na ya nanlinis buy namꞌi kantamun bayun biyay. ");
INSERT INTO abc_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Buun pusun iniibin Apu Diyus ya Ispiritu na kantamu ha pamêmêêtan Apu Jesu Criston Tagapagligtas tamu. ");
INSERT INTO abc_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Ginawan Apu Diyus ya habatu taêmên matanggap tamuy inaasahan tamun biyay ya alan anggan. Buy matanggap tamuy ati ta inturing na kitamun matuynung ta ha lubusaꞌ kahampatan na. ");
INSERT INTO abc_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Pêtêg buy mapagkatiwalꞌanaꞌ tudun in. Kaya labay kun buun pusu mun ituduy bawbagayaꞌ in ha libun mananampalataya kan Apu Diyus bahên taêmên ituun lay kanlan sarili ha panggawan mahampat. Mahampataꞌ libun aralaꞌ in buy makatulung ha laat tawu. ");
INSERT INTO abc_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Nuwa iwasan muy nunghunganaꞌ alan kabuluan, ah ka makihaluk ha pagꞌukilkil ha nawninunu buy iwasan mu mêtaꞌ pakikiribati tungkul ha kautuhan. Ta alan kabuluanaꞌ awꞌati buy alwan makatulung kayu. ");
INSERT INTO abc_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Nu mayin tawung nanhihida ha pagkakagiha yu, pannunghungan mu ya. Hapaêg, nu luway bisis mu yay nan pinannunghungan nuwa ah ya pun nanlêlêngê, ah kay na makiawyun kana. ");
INSERT INTO abc_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Ta tanda muy nan makasalananaꞌ tawung in buy nagdayu yay na ha kapêtêgan. Hay malaêtaꞌ ginawa nay magpapapêtêgaꞌ dapat yay nan parusaan. ");
INSERT INTO abc_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Tito, palakwên ku bahên hi Artimas u hi Tiquico. Nu lumatêngana bahênaꞌ hitaman kanla, pilitin mun mikaakit kita ha Necapolis ta iniihip kun baistuwaku pun mamalibah taglayꞌêp. ");
INSERT INTO abc_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Ha pagꞌalih lan Zenasaꞌ biyaha ha batas buy Apolos, gawꞌên muy makaya mu taêmên matulungan mu hila. Dapat ah hila magkulang ha kanlan kailanganên ha paglalakbay. ");
INSERT INTO abc_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Buy tuduwanan mun magsipag ha paggawan mahampataꞌ pawpatêl tamu ha pananampalataya kan Apu Jesus taêmên makatulung hila ha libun nangangaylangan. Nu habatuy gawꞌên la, magin pakinabangaꞌ biyay la. ");
INSERT INTO abc_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Kinukumusta kan laataꞌ awyun ku kayti buy ikumusta mu ku mêt ha laataꞌ pawpatêl tamun mananampalataya bahênaꞌ nagmamaal kanyan. Dalangin kun mamirmiꞌ kayun laataꞌ kahampatan Apu Diyus.");
INSERT INTO abc_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Haku hi Pablo ya nakakulung ta ha panunudu kun tungkul kan Apu Jesu Cristo. Nanyulataku kamu Filemon, kaawyun ku hi Timoteon patêl tamu ha Panginuun. Kumustaꞌ kay na minamaal yana Filemon ya katbuh yana maglingkud kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Buy kumustaꞌ mêt kan Apia ya patêl tamu ha pananampalataya, kan Arquipo ya katbuh yana alan limun nanunudu tungkul kan Apu Jesu Cristo buy ha libun mananampalatayan mititipun ha biyag mu. ");
INSERT INTO abc_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Indadalangin kun mapakayuy kahampatan buy kapayapaan Bapa tamun hi Apu Diyus buy Panginuun Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Panayakun nagpapasalamat kan Apu Diyus tuwin impapanalangin kita ");
INSERT INTO abc_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ta nabalitꞌan kun minamaal muy laataꞌ pinilin Apu Diyus buy nananampalataya ka ha Panginuun Jesus. ");
INSERT INTO abc_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Nananalanginaku kan Apu Diyus ya ipagpatuluy muy pakikigiha mu ha balan mananampalataya. Buy nu habatu lubus mun matêbêkaꞌ laataꞌ mangahampataꞌ bagayaꞌ inꞌibin Apu Diyus kantamu taêmên maparangalan tawtawu hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Minamaal kun patêl, lubusaꞌ tula ku buy sinumiglay kaluuban ku ta minamaal muy libun pinilin Apu Diyus buy pinasigla muy kaluuban la. ");
INSERT INTO abc_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Kaya bay bilang alagad Apu Jesu Cristo, malakasaꞌ luub kun mayꞌutuh kamu nu hita dapat mun gawꞌên. ");
INSERT INTO abc_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Nuwa ta maal kita, nakikinunghungaku tana kamu. Kaya ban ta mas matuwa ku kamu buy nakakulungaku ta ha panunudu ku tungkul kan Apu Jesu Cristo, ");
INSERT INTO abc_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","nakikinunghungakun mahampat kamu para kan Onesimo. Inturing ku yan anak ta kaban nakakulungaku kayti, nagin bapa na ku ha pananampalataya. ");
INSERT INTO abc_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Hin hatu, alan naitulung hi Onesimo kamu ta nagtakah ya. Nuwa hapaêg mamhakaꞌ maitulung na kantan luwa. ");
INSERT INTO abc_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Pinapabalik kuy na kamu hi Onesimo ya lubus kun minamaal. ");
INSERT INTO abc_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Labay ku hanan kayti ya pun kangku taêmên matulungan na kun dapay hakay nay nanunulung kangku kaban nakakulungaku pun ta ha panunudu kun Mahampataꞌ Balita. ");
INSERT INTO abc_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Nuwa ah ku labayaꞌ gawꞌênaꞌ habatu ya ala kan pahintulut taêmên kusang luub mu kun tulungan buy alwan sapilitan. ");
INSERT INTO abc_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Dat nihiyay ya kamun maêpêkaꞌ panawun taêmên ha pagbalik na kamu, makaawyun mu yay na makanuman. ");
INSERT INTO abc_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Maski alipên mu yan dili hinhatu, hapaêg giha yay na ha minamaal tamun patêl ha pananampalataya. Maal ku hi Onesimo nuwa mas lalun maal mu ya ta alwa mu yan dilin alipên nu alwan patêl mu yay na ha Panginuun. ");
INSERT INTO abc_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Kaya nu intuturing mu kun kaparihu mun maglingkud ha Panginuun, tanggapên mu hi Onesimo katbuh pagtanggap mu kangku. ");
INSERT INTO abc_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Nu nagkasala ya kamu u nagkautang, haku tanay baala kamu. ");
INSERT INTO abc_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Haku hi Pabloy mismun nanyulat ati. Haku tanay baala ha hitamanaꞌ nautang na kamu. Ah kuy na sabinaꞌ utang mu kangkuy nakilala mu hi Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Patêl ku, ta ha pananampalataya tamu ha Panginuun Jesus, nakikinunghungaku kamun gawꞌên muy kahilingan ku tungkul kan Onesimo. Pasiglaên muy luub ku bilang patêl mu kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Nanyulataku kamu Filemon ta naniniwala kun gawꞌên muy kahilingan ku kamu. Buy tanda kun higit pun kaytiya gawꞌên mu. ");
INSERT INTO abc_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Nakikinunghungaku mêt kamun ipaghanda mu kun mapagpirmiyan ta umaasa kun makabalikaku bahên ta impapanalangin yu ku. ");
INSERT INTO abc_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Kinukumusta kan Epafras ya kaawyun kun nakakulung ta ha panunudu na tungkul kan Apu Jesu Cristo. ");
INSERT INTO abc_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Buy kinukumusta ka mêt lan Marcos, Aristarco, Demas, buy Lucas ya kaawyun kun maglingkud kan Apu Diyus. ");
INSERT INTO abc_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Dalangin kun mapakayuy kahampatan Panginuun Jesu Cristo.");
ALTER TABLE abc_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
