﻿USE sofia;
DROP TABLE IF EXISTS sofia.aaz_vpl;
CREATE TABLE aaz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aaz_vpl WRITE;
INSERT INTO aaz_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nahunu te, Uisneno nmoeꞌ neno tunan ma pah-pinan. ");
INSERT INTO aaz_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Oras naan, pah-pinan ka mamoꞌek fa feꞌ, ma areꞌ saaꞌ-saaꞌ ii nbasiksakan. Suma nmuꞌi haa, oe. Ma meisꞌookn ii nꞌaum naan ee. Uisneno In Asmaan ee nabra-rae nbi oe je fafon. ");
INSERT INTO aaz_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Rarit Uisneno naꞌuab am nak, “Ro he nmuiꞌ meꞌu.” Naꞌuab anrair on naan ate, meuꞌ gui njair. ");
INSERT INTO aaz_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ankius meuꞌ gui te, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan ro reko. Rarit In nbatis meuꞌ gui naꞌko meisꞌokan, he es-es ate nmuiꞌ kuun in oras. ");
INSERT INTO aaz_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","In nakanab meuꞌ gui nak, ‘manas’, ma meisꞌookn ii nak, ‘fai’. Neno naan, neon goes namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Rarit Uisneno naꞌuab anteniꞌ mnak, “Ro he nmuiꞌ ruman he nbatis oe. Es naan ate, anmuiꞌ oe nbi faof, ma nmuiꞌ oe nbi ꞌpiin.” Naꞌuab anrair on naan ate, oe naan anbaits ok anjair bare nua, fafo ma ꞌpiin. ");
INSERT INTO aaz_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Rarit In nakanab baer ruman abit faofn ee, ‘neno’. Neno naan, neno nua namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Rarit Uisneno naꞌuab anteniꞌ mnak, “Oe abit aꞌpinan naan ro he nkaubuub ok nbi bare meseꞌ, maut he nmuiꞌ baer metoꞌ.” Naꞌuab anrair on naan ate, baer meot ii npoi neem. ");
INSERT INTO aaz_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Rarit In nakanab baer metoꞌ naan, ‘auf metoꞌ’; ma In nteek oe reꞌ ankaubuub on naan, ‘tasi’. Ankius areꞌ naan ate, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Rarit Uisneno naꞌuab anteniꞌ mnak, “Auf meot ii ro he natorob hau humaꞌ-humaꞌ. Ro he nmuiꞌ hau manoꞌo, hau masufaꞌ, ma hau mafuaf. Maut he hau meseꞌ-meseꞌ te, napoitan fini natuin in atrekan.” Naꞌuabaꞌ nrair on naan ate, areꞌ hau ngguin naan anjarin. ");
INSERT INTO aaz_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Anbi auf metoꞌ naan, hau ngguin napoitan fini natuin sin atreek ein meseꞌ-meseꞌ. Ankius on naan ate, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Neno naan, neno teun namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Rarit Uisneno naꞌuab anteniꞌ mnak, “Anbi fafon ne, ro he nmuiꞌ baer meꞌu humaꞌ-humaꞌ he ntanaꞌ pah-pinan. Ro he nmuiꞌ baer atanaꞌ nbi oras manas, ma nmuiꞌ baer atanaꞌ nbi oras fai. Baerꞌ ein naan anjarin on tanar henaꞌ tsoiꞌ tahiin neno, toon, ma oras.” Naꞌuab anrair on naan ate, baer meꞌun neon goe tnanan sin nboran. ");
INSERT INTO aaz_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","In nmoeꞌ baer meuꞌ humaꞌ nua reꞌ koꞌu. Es koꞌu nneis, ntanaꞌ nbi oras manas; es seor naꞌbau ntanaꞌ nbi oras fai. In nmoeꞌ kfuun-akfuun amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","In nakfirit baerꞌ ein naan nbi neon goe he ntanaꞌ pah-pinan. ");
INSERT INTO aaz_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Rarit sin ntaanꞌ ein nbi oras manas, ma oras fai. Nok ranan naan, sin nbatis meꞌu naꞌko meisꞌokan. Ankius niit sin ite, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Neno naan, neno haa namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Rarit Uisneno naꞌuab anteniꞌ mnak, “Ro he nmuiꞌ kaunaꞌ humaꞌ-humaꞌ reꞌ anmonin nbin oe. Ma ro he nmuiꞌ koro humaꞌ-humaꞌ reꞌ natpenen nbin neon goe tnanan.” ");
INSERT INTO aaz_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Rarit In nmoeꞌ ikaꞌ humaꞌ-humaꞌ ma kaunaꞌ bian reꞌ nmonin nbin oe. In nmoeꞌ koro humaꞌ-humaꞌ msaꞌ reꞌ natpenen nbin neon goe tnanan. Ankius saaꞌ reꞌ In nmoeꞌ sin naan ate, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Rarit In naꞌuab anfee tetus neu areꞌ kanan muiꞌt ein naan am nak, “Iikꞌ ein ro he namsaꞌin, he naheun oe nbin bare-bare. Ma koorn ein on naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Neno naan, neno niim namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Rarit Uisneno naꞌuab anteniꞌ mnak, “Ro he nmuiꞌ muꞌit humaꞌ-humaꞌ reꞌ anmonin nbin auf metoꞌ. Sin esan reꞌ muiꞌ aem, muiꞌ fui, ma anonok, es-es ate nok nain in atrekan.” Naꞌuab anrair on naan ate, muiꞌt ein naan anjarin. Ankius on naan ate, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Rarit Uisneno naꞌuab anteniꞌ mnak, “Iim he Hit tmoeꞌ mansian tatuin Hit huumk am Hit masak, Hit moeꞌk am Hit taok. Maut he sin es anpafaꞌ ma npainoet iikꞌ ein nbin tasi, areꞌ koro nbin neon goe tnanan, areꞌ muiꞌ aem, ma muꞌit bian reꞌ nmonin nbin pah-pinan.” ");
INSERT INTO aaz_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Onaim In nmoeꞌ mansian ii natai nok In human ma In masan, In moꞌen ma In taon. In nmoeꞌ sin, atoniꞌ ma bifee. ");
INSERT INTO aaz_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Onaim In naꞌuab anfeen sin tetus am nak, “Hi ro he mihoniꞌ ma mimsaiꞌ he miheun pah-pinan, mpafaꞌ ma mpainoet je msaꞌ. Au ꞌfee ki prenat he mꞌurus ikaꞌ-ikaꞌ, koro-koro, ma areꞌ kanan muiꞌt ein anbin auf metoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Amneen mirek-rekoꞌ! Au ꞌfee ki mnahat humaꞌ-humaꞌ nbi pah-pinan. Esan reꞌ: hau manoꞌo, hau masufaꞌ, ma hau mafuaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au ꞌfee haun reꞌ naan he njarin amnahat neu muiꞌt ein amsaꞌ. Anmuꞌi mnahat neu muiꞌ aem, muiꞌ fui, anonok, ma koorn ein msaꞌ.” Naꞌuab anrair on naan ate, areꞌ kanan amnaaht ii namtiis. ");
INSERT INTO aaz_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ankius niit sin on naan ate, In nmariin, natuin saaꞌ reꞌ In nmoeꞌ je naan, ro reko ꞌmaten. Neno naan, neno nee namsoup goen. ");
INSERT INTO aaz_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nok ranan naan, Uisneno nmoeꞌ naan neno tunan ma pah-pinan nok in aafn ii ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Anmoeꞌ narair sin arsin, nokaꞌ on naan ate, neon hiut ii ntea. Onaim In nasnaas naꞌko In meupn ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Es naan ate, In nbetis neon hituꞌ naan naꞌko neon biak ein ii, he njair neno snasat, natuin In narair In mepun naan, ma nbi neno naan, In nasnaas. ");
INSERT INTO aaz_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Retaꞌ reꞌ natoon nak Uisneno nmoeꞌ neno tunan ma pah-pinan, on reꞌ naan, tua. ");
INSERT INTO aaz_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Oras UISNENO feꞌ nmurai nmoeꞌ neno tunan ma pah-pinan naan ate, ");
INSERT INTO aaz_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","ka nmuiꞌ hau saaꞌ-saaꞌ fa feꞌ, natuin In ka nasanut uran fa feꞌ. Oras naan, suma nmuꞌi haa nipuꞌ reꞌ nsae naꞌko afu, ma napeet pah-pinan. Ma ka nmuiꞌ fa feꞌ mansian reꞌ nareen. ");
INSERT INTO aaz_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Rarit UISNENO nnau afu, ma nmoeꞌ je njair mansian. Rarit In nfuu nataam snasaf npeoꞌ in panan konan. Onaim mansian naan anmoin oras naan. ");
INSERT INTO aaz_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Rarit UISNENO nroe naan pooꞌn es anbi bare Eden, et pasaꞌ neon-saet. Onaim In natokob mansian naan anbi bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Anbi poꞌon naan In namonib areꞌ kanan roet, reꞌ tkisu te namasan, ma taah sin ate miin-oni. In namonib amsaꞌ hau ꞌuꞌu nua nbi pooꞌn ee tnanan. Karu mansian ii naah hau fuaꞌ naꞌko uuꞌ goes in fuan, in of anmoin piut. Ma karu mansian ii naah naꞌko uuꞌ goes anteniꞌ in fuan, in bisa nahiin rais reko ma rais reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Anbi naan, anmuiꞌ naan noe jes, nasai npoi naꞌko poꞌon naan. Noe naan aꞌsaif haa. ");
INSERT INTO aaz_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Aꞌsaif ahuunt ee, in kaan ee Pison. Aꞌsaif ia nasai nfuun naan pah Hawila. Anbi bare ia, nmuꞌi mnatuꞌ mfa-faun. ");
INSERT INTO aaz_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Anbi bare reꞌ ia, nmuiꞌ mnaut afaꞌ, nmuiꞌ hau reꞌ in oen ee foo meniꞌ, ma nmuiꞌ faut arimat. ");
INSERT INTO aaz_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Aꞌsaif es anteniꞌ, in kaan ee Gihon. Aꞌsaif ia, ansai nfuun naan pah Kus. ");
INSERT INTO aaz_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Aꞌsaif es anteniꞌ, in kaan ee Tigris. Aꞌsaif reꞌ ia njair nakat nbi pah Asur ntoom maans ee ꞌsaen. Ma in aꞌsain amuint ee, kaan ee, Efrat. ");
INSERT INTO aaz_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","UISNENO nreek mansian naan natua nbi Eden, he npairoir poꞌon naan rek-reko. ");
INSERT INTO aaz_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Onaim In naprenat mansian naan am nak, “Au ꞌkonan ko he muah hau fuaꞌ saaꞌ-saaꞌ ahaa, naꞌko areꞌ kanan roet anbi poꞌon ia. ");
INSERT INTO aaz_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mes anmuiꞌ naan hau uuꞌ goes, reꞌ Au ꞌtaar ko maꞌtaniꞌ, he kais muah in fuan. Hau naan es reꞌ hau roet reꞌ, karu mansian ii naah in fuan, in bisa nahiin rais reko ma rais reꞌuf. Mes karu ho muahn ee te, ho ro he mmaet.” ");
INSERT INTO aaz_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Rarit UISNENO naꞌuab anteniꞌ mnak, “Ka reko fa karu mansian ia nmoni nmes-mees. Onaim Au he ꞌmoꞌe ꞌfee ne atuurn am abaabt es reꞌ natai nok ne.” ");
INSERT INTO aaz_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Oras naan UISNENO nnau afu, ma nmoeꞌ muꞌit ma koro humaꞌ-humaꞌ. Rarit In nnao naat sin neu mansian naan, maut he in nakanab sin. Rarit mansian naan nakanab muꞌit ma koron naan, es-es ate nok kuun in kanan. Mes neu iin, ka nmuiꞌ fa atuurn am abaabt es, reꞌ natai nok ne. ");
INSERT INTO aaz_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Rarit UISNENO narour natupaꞌ mansian naan. Oras in ntuup anfiin ite, Uisneno nait naan in nui bnapaꞌ tuuk es, rarit In ntoeb narekoꞌ papaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma In nmoeꞌ bifee naꞌko nuif naan. Rarit In nnonaꞌ bifee naan neu atoniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Oras atoniꞌ ia niit bifee naan ate, in nak, “Haaa! Esai feꞌ! Ia ro natai nok kau! In nuif ein humaꞌ meseꞌ nok au nu. Ma in sisin humaꞌ meseꞌ nok au sisik. Natuin in njair naꞌko atoniꞌ, es naꞌ au ukaanb ee, ‘bifee’.” ");
INSERT INTO aaz_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Natuin rasi naan, es naꞌ atoin es ro he annao nasaitan in ainaf-amaf, he nmoin nabua nekaf meseꞌ ma ansaof meseꞌ nok in fee, henatiꞌ sin nua sin njarin meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oras naan sin aaf ein, mes sin ka nmuꞌin fa rais mae kreꞌo msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Naꞌko areꞌ kanan muꞌit reꞌ UISNENO nmoeꞌ nain sin nbin pah-pinan ia, kaun ii es aputa-kriu anesit. Anbi oors es, kaunaꞌ naan nataan neu bifee naan am nak, “Hoe! Batuur, aa oo? Uisneno ntaar ki mnak, ‘Ka nabeiꞌ fa he hi miah hau fuaꞌ naꞌko roet ein anbin poꞌon ia, aiꞌ kaah?’ ” ");
INSERT INTO aaz_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Bifee naan nataah am nak, “Kahaf! Hai bole miah! Mes anmuiꞌ naan roet uuꞌ goes et pooꞌn ee tnanan reꞌ Uisneno ntaar kai, he hai kais miah in fuan. In nak, hai kais miah in fuan, ma kais amreoꞌ goe msaꞌ, natuin hai of ammaet.” ");
INSERT INTO aaz_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mes kaunaꞌ naan nataah am nak, “Hoe, napoi! Hi ka mmaet fa, tua! ");
INSERT INTO aaz_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Uisneno batuur antaar ki on naan, natuin In nahiin, karu hi miah hau fuaꞌ naan, hi mahiinm ein namnees nok Ne. Hi of mihiin mee es reko, ma mee es reꞌuf.” ");
INSERT INTO aaz_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Rarit bifee naan ankisu te, hau roet naan reokn ii kaah. Ma in naben ate hau fuaꞌ naan miin ii kah een. Onaim in natenab am nak, “Karu au ꞌuah hau fuaꞌ ia, au of uhiin ma ꞌmanoe.” Rarit in nseu hau fuaꞌ naan, ma in naah. In neik ii ma nfeen in moen je msaꞌ, he naah nok. ");
INSERT INTO aaz_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Naah anrarin on naan ate, naꞌ sin nahinin nak sin aaf ein. Es naan ate, sin nkaton apas hau noꞌo he natain. ");
INSERT INTO aaz_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Maans ee nmaeb on naan ate, sin nneen UISNENO neem annoon poꞌon naan. Rarit sin naen naꞌkoor ein henatiꞌ UISNENO kais niit sin. ");
INSERT INTO aaz_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mes UISNENO nhaman atoniꞌ naan am nak, “Aupuu! Ho et mee, Adam?” ");
INSERT INTO aaz_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Atoniꞌ naan nataah am nak, “Au ꞌneen Ho ꞌfookm ii mbi ia. Mes au umaeb ok, natuin au ao afaꞌ kau. Etun au ꞌaen uꞌkoroꞌ, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Rarit Usiꞌ nataah am nak, “Sekau es natoon ko mnak ho mꞌao aaf om? On mee? Of oniꞌ ho muah amrair hau fuaꞌ reꞌ Au ꞌtaar ee naan, aiꞌ?” ");
INSERT INTO aaz_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","In nataah am nak, “Usiꞌ, bifee reꞌ Ho mfee je naan, in es anfee kau hau fua taras naan, ma au ꞌuah!” ");
INSERT INTO aaz_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Rarit UISNENO naꞌuab nok bifee naan am nak, “Nansaaꞌ am es ho mmoeꞌ on naan?” Onaim bifee naan nataah am nak, “Te kaunaꞌ naan es napoi kau, tua! Onaim es au ꞌuah hau fua taras naan, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Rarit UISNENO naꞌuab kasat neu kaunaꞌ naan am nak, “Natuin ho ꞌmoꞌem ia, Au ꞌhukun ko. Naꞌko areꞌ kanan muꞌit, suma ho mmes-mees kuum es reꞌ mupein kasat on nai: nmurai naꞌko oras ia tar antea ho mmaet, ho suma mnonok meiki haa ho ꞌbasam. Ma ho mnaaht ein maskuuk ein. ");
INSERT INTO aaz_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au of aꞌmoeꞌ ko mok bifee naan, ammamuus piut. Hi sufam-kauꞌm ein on naan amsaꞌ. Ho sufam-kauꞌm ein of anrau sin haek-tiik ein. Mes in sufan es, of antuut nakrat-ratiꞌ ho ꞌnakam.” ");
INSERT INTO aaz_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Rarit Uisneno naꞌuab neu bifee naan am nak, “Au of uꞌbabaꞌ ho susat oras ho muꞌapuꞌ, ma mumeen anneisi nteniꞌ oras ho muhoniꞌ. Mes maski on naan, ho mroim he mubua piut mok ho mone. Ma in es naprenat ko.” ");
INSERT INTO aaz_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Rarit Usiꞌ naꞌuab neu atoniꞌ naan am nak, “Ho ka mutuin fa Au prenat, mes mutuin ho fee ji in romin, tar antea ho muah hau fuaꞌ reꞌ Au ꞌtaar ee naan. Es naan ate, ho mupein kasat amsaꞌ. Ma auf gui msaꞌ napein kasat. Anmurai naꞌko oras ia tar antea ho mmaet, ho ro he mmepu mbain aetn om, ma mubaniꞌ auf gui, henaꞌ ho mupein he muah. Ammeup on naan ate, naꞌ ho mmoin. ");
INSERT INTO aaz_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Maski ho mseen ma mroe humaꞌ-humaꞌ, mes auf gui suma napoitan ꞌaik kiisn aa ma krabat. ");
INSERT INTO aaz_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Rarit ho ro he mmepu mbain aetn om maꞌtaniꞌ, henaꞌ auf gui nfee ko mnahat. Ho ro he mmeup ma puus ee nsai tar ho mmaet. Au ꞌmoeꞌ ko naꞌko afu. Onaim karu ho mmate te, ho mfani mrair afu.” ");
INSERT INTO aaz_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Rarit naiꞌ Adam nakanab in fee je nak ‘bi Hawa’ (in aꞌmoufn ii ‘reꞌ anmoin’), natuin bifee naan es reꞌ njair ainaf neu areꞌ mansian amonit anbin pah-pinan ia. ");
INSERT INTO aaz_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Rarit UISNENO nmoeꞌ tais naꞌko pasu, ma nfeen sin he npaken. ");
INSERT INTO aaz_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Rarit UISNENO naꞌuab am nak, “Oras ia mansian ein nahinin rais reko, ma rais reꞌuf, on reꞌ Hit. Kais-kaisaꞌ sin naah hau fuaꞌ reꞌ neiki ꞌhonis abar-barat.” ");
INSERT INTO aaz_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Rarit In nriuꞌ napoitan sin naꞌkon poꞌon Eden, he sin nua sin nnaon neun bare bian, ma nmonin on atoin tani, he sin amnaimt ein naꞌko afu. ");
INSERT INTO aaz_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Anriꞌu nrair sin on naan ate, Uisneno nreun In ameup maniin ein naꞌko sonaf neno tunan, he nnao npao poꞌon naan nbin pasaꞌ neon-saet. Sin nnaꞌan suniꞌ reꞌ npiin ma nrirok neu-mneem. Usiꞌ nreun sin he nhaken nꞌekaꞌ ranan, natuin In ka nroim fa he tuaf anseu naan hau fuaꞌ reꞌ neiki ꞌhonis abar-barat. ");
INSERT INTO aaz_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Neot es, naiꞌ Adam antuup nok in fee bi Hawa. Onaim bifee naan naꞌapuꞌ. Rarit in nahoniꞌ riꞌaan moen jes. Ma in nak, “Au uhoniꞌ upoitan aan riꞌaan moen jes, natuin UISNENO nturun kau.” Onaim in nakanab riꞌaan mone naan, naiꞌ Kain, (reꞌ in aꞌmoufn ii, ‘napoitan’). ");
INSERT INTO aaz_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Rarit bi Hawa nahoniꞌ ntein riꞌaan moen jes. Onaim in nakaanb ee, naiꞌ Habel. Oras sin nua sin naꞌnaen on naan ate, naiꞌ Habel natuuk muꞌit, ma naiꞌ Kain ameup rene. ");
INSERT INTO aaz_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Oors es ate, naiꞌ Kain neik in reen ee sin aafk ein bian, ma nafuataꞌ sin neun UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Naiꞌ Habel neik in aꞌbib-kaes ainf ein sin aan uun ein amsaꞌ. In nroro ꞌbib-kasen naan, rarit in natnaat neik sisi ꞌtuur arekot neu Uisneno. Ankius niit on naan ate, UISNENO nmarinan naiꞌ Habel in fuaꞌ-tuurꞌ ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mes In ka nroim fa naiꞌ Kain in fuaꞌ-tuurꞌ ein naan. Onaim naiꞌ Kain natoꞌo nmaet, tar antea in huum puut batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Onaim UISNENO naꞌuab nok naiꞌ Kain am nak, “Hoe, Kain! Nansaaꞌ am es ho mutooꞌ on naan? On mee mꞌes ho mhuum mpuut on naan? ");
INSERT INTO aaz_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bait ho mmoeꞌ reko te, Au ꞌtoup ko nok reko. Mes mumnau, goo! Karu ho mmoeꞌ reꞌuf ate, ꞌmoꞌet naan of naah nafaniꞌ ko, on reꞌ meo goan nnuuꞌ he nheke knafo. Onaim karu ho mutenab he mmoeꞌ reꞌuf ate, reko nneis ho mporiꞌ main tenab naan!” ");
INSERT INTO aaz_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Neot es, naiꞌ Kain anfuriꞌ naiꞌ Habel am nak, “Habel! Uum he nua kit atnao on rene.” Oras sin ntean ate, nok askeken naiꞌ Kain anbeos niis in orif. ");
INSERT INTO aaz_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Rarit UISNENO nataan naiꞌ Kain am nak, “Hoe, Kain! Ho oriꞌ et mee?” Naiꞌ Kain nataah am nak, “Au ka uhinif! Au es ka ꞌnaaꞌ fa in haen-niman!” ");
INSERT INTO aaz_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Onaim Uisneno naꞌuab am nak, “Nansaaꞌ am es ho mmoeꞌ rais maufinu on naan? Ho kais mutenab mak ho oriꞌ in naaꞌ ee nmeti nrari nbi auf gui ꞌpinan. Au ꞌiit urair saaꞌ reꞌ ho mmoeꞌ je meu ho oriꞌ! ");
INSERT INTO aaz_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Oras ia, naaꞌ ee nsaenaꞌ ko. Oras ho mroor miis ho oriꞌ, auf gui nmuis in naaꞌ. Es naan ate, auf gui ka nfee nteniꞌ ko fa in afan he ho mmoin. ");
INSERT INTO aaz_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Karu ho mureen, auf gui of ka nfee ko fa afaꞌ saaꞌ-saaꞌ. Anmurai oras ia, ho of amfain atoes reꞌ mpaisuun om tafiꞌ-tafiꞌ mbi pah-pinan ia.” ");
INSERT INTO aaz_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Mes naiꞌ Kain naꞌuab neik haan maꞌfenaꞌ neu UISNENO mnak, “Hae, Usiꞌ! Nansaaꞌ am es Ho mfee maan kau kasat maꞌtan-taniꞌ naan? Au ka usaah ubeiꞌ je fa! ");
INSERT INTO aaz_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Natuin Ho mriꞌu mrair kau uꞌko bare ia, au of uꞌroo Ko, tua. Au of aꞌtoe ꞌbi mee-mee on reꞌ anao-amnemat. Rarit sekau-sekau reꞌ nateef nok kau te, of anroor niis kau, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mes UISNENO nataah ee mnak, “Ka on naan fa! Sekau es anroor ko, Au ꞌhuukn ee maꞌfenaꞌ nneis no hiut!” Rarit UISNENO ntao tanar nbi naiꞌ Kain, henatiꞌ tuaf sekau-sekau reꞌ nateef nok ne te, nahinin nak sin ka nabeiꞌ fa he nroor niis ne. ");
INSERT INTO aaz_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Rarit naiꞌ Kain nnao nasaitan bare naan, naꞌroo naꞌko UISNENO. In nnao ntea baar jes, nbi poꞌon Eden in pasaꞌ neon-saet. Bare naan in kaan ee, Not, reꞌ in aꞌmoufn ii nak ‘npaisuun’. In natua nbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Rarit naiꞌ Kain anmatsao. In fee je naꞌapu. In nahoniꞌ riꞌaan moen jes, ma sin nakaanb ee, naiꞌ Henok. Ma naiꞌ Kain nafenaꞌ kuan es. Rarit in nakaanb ee, Henok, on reꞌ in aanh ee kanan. ");
INSERT INTO aaz_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Naiꞌ Henok in aanh ee, es reꞌ naiꞌ Irat. Naiꞌ Irat in aanh ee, es reꞌ naiꞌ Mehujaer. Naiꞌ Mehujaer in aanh ee, es reꞌ naiꞌ Metusael. Ma naiꞌ Metusael in aanh ee, es reꞌ naiꞌ Lamek. ");
INSERT INTO aaz_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Naiꞌ Lamek ansao bifee nua. Es kaan ee bi Ada; es anteniꞌ in kaan ee bi Sila. ");
INSERT INTO aaz_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ain Ada nahoniꞌ naiꞌ Jabar. In suufk ein anjarin atuuk muꞌit. Sin aꞌmoink ein natnan-nain naah, he namin huun neu sin muiꞌt ein. Sin naꞌumin nbin haa tenas. ");
INSERT INTO aaz_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Naiꞌ Jabar in oirf ee, naiꞌ Jubar. Naiꞌ Jubar in suufk ein anjarin atoin arekut, nfuun bobe, ma ꞌrekuꞌ humaꞌ bian antein. ");
INSERT INTO aaz_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Naiꞌ Lamek in fee bi Sila nahoniꞌ naiꞌ Tubal Kain. In suufk ein anjarin atuut besi. Sin nmoꞌen bareꞌ humaꞌ-humaꞌ naꞌko besi ma noin moroꞌ. Naiꞌ Tubal Kain in feotf ee, bi Naꞌama. ");
INSERT INTO aaz_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Neot es, naiꞌ Lamek anboiꞌs on anbi in fee ngguin nua sin. In nak, “Hi mneen rek-reko! Feꞌ ena riꞌ moen muinf es anbaan kau, mes au ꞌbaan uꞌmaet ee. ");
INSERT INTO aaz_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tuaf reꞌ nroor niis naiꞌ Kain, napein hukun no hiut. Mes karu nmuiꞌ tuaf reꞌ he nbaras in neek tenab amreꞌut neu kau, sin of napenin hukun no boꞌ hitu mhiut (77).” ");
INSERT INTO aaz_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Naiꞌ Adam in fee bi Hawa nahoniꞌ naan riꞌaan moen jes anteniꞌ. Sin nakaanb ee, naiꞌ Set (reꞌ in aꞌmoufn ii nak, ‘anfee’) natuin ain Hawa nak, “Uisneno nfee riꞌanaꞌ ia neu kau he nsenuꞌ naiꞌ Habel, reꞌ naiꞌ Kain anroor niis ne naan.” ");
INSERT INTO aaz_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nok-noki te, naiꞌ Set ansao. In napein riꞌaan moen jes, ma in nakaanb ee, naiꞌ Enos. Oras naan, mansian ii nmurai naꞌruriꞌ ma naꞌbesan neun UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Oras Uisneno nmoeꞌ mansian, In nmoeꞌ sin natuin In huumn am In masan In moeꞌn am In taon. In nmoeꞌ sin atoniꞌ ma bifee. Rarit In nteek sin nak “mansian”, ma In nfeen sin tetus nathoe msaꞌ. Mansian reꞌ ahun-hunut, kaan ee naiꞌ Adam. Naiꞌ Adam in sufan-kauꞌn ein esan reꞌ ia: ");
INSERT INTO aaz_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Oras naiꞌ Adam in nmoin naan toon nautn es boꞌ teun (130), in napein riꞌaan moen jes. Riꞌanaꞌ ia in noes naah in amaf. Onaim in nakanab riꞌanaꞌ naan, naiꞌ Set. ");
INSERT INTO aaz_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Rarit naiꞌ Adam nmoin feꞌ toon natun faun (800). In napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","In nmaet oras in nmoin naan toon natun seo mboꞌ teun (930). ");
INSERT INTO aaz_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Oras naiꞌ Set nmoin naan toon nautn es toon niim (105), in napein riꞌaan moen jes, es reꞌ naiꞌ Enos. ");
INSERT INTO aaz_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Rarit naiꞌ Set nmoin feꞌ toon natun fanu mtoon hiut (807), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","In nmaet oras in nmoin naan toon natun seo mboꞌ es am nua (912). ");
INSERT INTO aaz_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Oras naiꞌ Enos nmoin naan toon boꞌ seo (90), in napein riꞌaan moen jes, es reꞌ naiꞌ Kenan. ");
INSERT INTO aaz_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Rarit naiꞌ Enos nmoin feꞌ toon natun fanu mboꞌes am niim (815), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","In nmaet oras in nmoin naan toon natun seo mtoon niim (905). ");
INSERT INTO aaz_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Oras naiꞌ Kenan nmoin naan toon boꞌ hiut (70), in napein riꞌaan moen jes, es reꞌ naiꞌ Mahararel. ");
INSERT INTO aaz_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Rarit naiꞌ Kenan nmoin feꞌ toon natun fanu mboꞌ haa (840), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","In nmaet oras in nmoin naan toon natun seo mtoon boꞌes (910). ");
INSERT INTO aaz_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Oras naiꞌ Mahararel nmoin naan toon boꞌ nee mniim (65), in napein riꞌaan moen jes, es reꞌ naiꞌ Yaret. ");
INSERT INTO aaz_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Rarit naiꞌ Mahararel nmoin feꞌ toon natun fanu mboꞌ teun (830), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","In nmaet oras in nmoin naan toon natun fanu mtoon boꞌ seo mniim (895). ");
INSERT INTO aaz_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Oras naiꞌ Yaret nmoin naan toon nautn es boꞌ nee mnua (162), in napein riꞌaan moen jes, es reꞌ naiꞌ Henok. ");
INSERT INTO aaz_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Rarit naiꞌ Yaret feꞌ anmoni ntein toon natun faun (800), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","In nmaet oras in nmoin naan toon natun seo mboꞌ nee mnua (962). ");
INSERT INTO aaz_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Oras naiꞌ Henok nmoin naan toon boꞌ nee mniim (65), in napein riꞌaan moen jes, es reꞌ naiꞌ Metusalak. ");
INSERT INTO aaz_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Rarit naiꞌ Henok in nmoni nmafuut neek nok Uisneno tar antea toon natun tenu ntein. Ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","In nmoin ma anneek mees nok Uisneno. Oras in nmoin naan toon natun tenu mboꞌ nee mniim (365), in ka mamnitaꞌ fa, natuin Uisneno nait nasaeb ee. ");
INSERT INTO aaz_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Oras naiꞌ Metusalak in nmoin naan toon nautn es boꞌ fanu mhiut (187), in napein riꞌaan moen jes, es reꞌ naiꞌ Lamek. ");
INSERT INTO aaz_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Rarit naiꞌ Metusalak feꞌ anmoni ntein toon natun hitu mboꞌ fanu mnua (782), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","In nmaet oras in nmoin naan toon natun seo mboꞌ nee mseo (969). ");
INSERT INTO aaz_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Oras naiꞌ Lamek nmoin naan toon nautn es boꞌ fanu mnua (182), in napein riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Naiꞌ Lamek nakanab riꞌanaꞌ naan naiꞌ Noh (reꞌ in haan ee, on reꞌ kata es, reꞌ in aꞌmoufn ii, ‘nfee harinet ma haan maut’), natuin in nak, “Riꞌanaꞌ ia of anfee harinet ma haan maut neu hit neek suust ii nbi afu reꞌ napein kasat naꞌko Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Rarit naiꞌ Lamek nmoin feꞌ toon natun niim amboꞌ seo mniim (595), ma in napeni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","In nmaet oras in nmoin naan toon natun hitu mboꞌ hitu mhiut (777). ");
INSERT INTO aaz_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Oras naiꞌ Noh nmoin naan toon natun niim (500), in napein riꞌaan mone teun, es reꞌ naiꞌ Sem, naiꞌ Yafet, ma naiꞌ Ham. ");
INSERT INTO aaz_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Oras naan, mansian ii mfau-rutu. Ma sin nmonin nsisaeꞌn ok nbin areꞌ bare-bare. Sin nahoin ein riꞌaan feto msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Uisneno In aan monen niit riꞌ feot munif mansian ein ate, ro maas reuꞌ fein. Onaim sin es-es ate nnao nsao riꞌ feto mee reꞌ in romi. ");
INSERT INTO aaz_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Rarit UISNENO nak, “Au ꞌhae ꞌmaet jen nok mansian ii sin aꞌmonit amreꞌut. Au Smanak reꞌ namonib sin naan, ka nroim fa he sin nmonin piut. Sin ro he nmaten. Onaim sin nmoni ntuꞌun toon nautn es boꞌ nua goah (120).” ");
INSERT INTO aaz_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Naꞌko batan naan, tar batan-batan amunit, atoin hae-brako anmonin nbin pah-pinan. Oras naan Uisneno In aan moen ein ansao mansian ein sin aan feot muinf ein, ma nahoin ein atoin maꞌtaniꞌ, es reꞌ aꞌnaak makenat, reꞌ matekaꞌ nbin retaꞌ ahunut. ");
INSERT INTO aaz_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Oras naan, UISNENO nkisu te mansian anbin pah-pinan anmoꞌen reꞌuf bainesiꞌ. Sin nopaak ein ii arahaa nateenb ein rais amreꞌut piut. ");
INSERT INTO aaz_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Onaim UISNENO nmeꞌ-meiꞌ Jon, natuin In nmoꞌe nrair sin, ma natokob sin anbin pah-pinan ia. Rasi naan ro nasusab niis Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Etun In naꞌuab am nak, “Es naan ate, Au of ureuꞌ mansian reꞌ Au ꞌmoeꞌ urair sin anbin pah-pinan ia. Au of uꞌmaet areꞌ kanan koro ma muꞌit bian amsaꞌ. Au ꞌmeiꞌ Jok ma ꞌsain Jok, natuin Au ꞌmoꞌe ꞌrair sin.” ");
INSERT INTO aaz_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mes arahaa naiꞌ Noh, es reꞌ nhariin UISNENO In nekan. ");
INSERT INTO aaz_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Naiꞌ Noh in reetn ii, on nai: in nmuiꞌ aan mone teun, esan reꞌ: naiꞌ Sem, naiꞌ Yafet, ma naiꞌ Ham. Naiꞌ Noh anmoin nok neek amneꞌo neu Uisneno, ma ka nmoeꞌ fa ꞌmoeꞌ reꞌuf. Oras naan, arahaa in es reꞌ atoin reko. In nmoni nhaumaakb on nok Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Mes Uisneno nkisu te areꞌ kanan mansian ii amoeꞌ reꞌuf sapuꞌ-sapuꞌ. Anbi mee-mee jah mansian ii namreꞌu nmaet. Uisneno nkisu te mansian anbin pah-pinan naan, anmoeꞌn ahaa rais reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Rarit Uisneno naꞌuab neu naiꞌ Noh am nak, “Au ꞌiit aꞌrair mansian ii in aꞌmoeꞌ reꞌuf anbi bare mee-mee. Onaim Au ufeek urair ꞌak, Au ro he ureuꞌ ain pah-pinan ia nok in afan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Es naan ate, on nai, Noh! Oras ia ho mmoeꞌ maan abnao oe kouꞌ goes mpaek hau maꞌtaniꞌ. Ho mmoeꞌ keꞌen-keꞌen anbi bnao naan in nanan. Rarit ho mraep je koti-mnaan meik ter. ");
INSERT INTO aaz_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ho mmoeꞌ bnao naan in amnaun ii meter nautn es boꞌ tenu mteun (133); in mainuan tuuk am tuuk meter boꞌ nua mnua (22); ma in aꞌraatn ee meter boꞌes am teun (13). ");
INSERT INTO aaz_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mtefi bnao naan, ma mruip je mpaek hau ꞌbeen pisaꞌ. Mes mufreibaꞌ tefis naan on reꞌ mete steen es naꞌko ruip taan in fafon. Ho mbati bnao naan ktutaꞌ teun. Rarit ammoeꞌ eon es anbi in abnapan. ");
INSERT INTO aaz_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mumnau murek-rekoꞌ! Au of usanut uur noe sakoꞌ he nmemun niis areꞌ amonit anbi npah-pinan, tar antea saup tukiꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mes Au he ꞌmoeꞌ rais manbaꞌan ꞌok ko. Ho of amtaam meu bnao naan, mok ho fee-anah, ma ho aan naenf ein. ");
INSERT INTO aaz_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Naꞌko areꞌ kanan muꞌit pah-pinan ia, ho ro he meik mutaam pasan-pasan meu bnao naan in nanan, maut he sin nmonin amsaꞌ on reꞌ ho. Sin esan reꞌ: muiꞌ aem, koro, anonok, maut he sin nmonin. ");
INSERT INTO aaz_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ho ro he mutaam mnahat humaꞌ-humaꞌ meu bnao naan in nanan neu ki ma neu muiꞌt ein naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Rarit naiꞌ Noh nmoeꞌ natuin Uisneno In kabin ma prenat naan okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Rarit UISNENO naꞌuab neu naiꞌ Noh am nak, “Au ꞌkisu ꞌbi mee-mee, mes arahaa ho mmees-mees jah es neek amneꞌo. Onaim ho mok ho fee-anah sin mtaam nai meu bnao naan. ");
INSERT INTO aaz_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Naꞌko areꞌ kanan muꞌit reꞌ sin siisk ein nabeiꞌ he hi meuk sin, ma reꞌ nabeiꞌ he hi mifuat sin meu Kau, ho mutaam pasan hit-hiut meu bnao naan. Naꞌko areꞌ kanan koro ho mutaam pasan hit-hitu msaꞌ. Mes muꞌit bian anteniꞌ ho suma mutaam pasan mes-meesꞌ aah. Nok ranan naan, muiꞌt ein naan, anjarin on reꞌ fini neu sin suufk ein, he sin nmonin amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mumnau murek-rekoꞌ! Aar neno hitu te, Au of usanut uran reꞌ ka nasnaas niit fa, tar antea neno boꞌ haa ma fai boꞌ haa. Au ꞌpaek ranan naan, he uꞌmaet ꞌain areꞌ amoint ein nbin auf metoꞌ, reꞌ Au ꞌmoꞌe ꞌrair sin.” ");
INSERT INTO aaz_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Rarit naiꞌ Noh nmoeꞌ natuin on reꞌ UISNENO In aprenat naan okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Oras noe sakoꞌ naan nsae te, naiꞌ Noh nmoin naan toon natun nee jen (600). ");
INSERT INTO aaz_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Rarit naiꞌ Noh nok in fee, ma in aanh ein, ma in aan naenf ein, ntaman neun bnao naan, he sin nsoi naan ok. ");
INSERT INTO aaz_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Naiꞌ Noh natuin UISNENO In aprenat naan, onaim in nataam areꞌ kanan koro ma muꞌit, es-es ate nok nain in bian, naꞌko muꞌit reꞌ he mansian bole neuk sin siisk ein, ma naꞌko muꞌit reꞌ ka bole fa he neuk sin siisk ein. ");
INSERT INTO aaz_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Neno hiut namsopu te, noe sakoꞌ naan neem ma nmurai nmemun pah-piin ii no mes-meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Oras naiꞌ Noh anmoin naan toon natun nee (600) mfunan nua mneno boꞌes am hiut on naan ate, noe saok gui nmurai ntaam. Oras naan on reꞌ neon goe natfeꞌi, es naꞌ oe ji natꞌoop aah. Ma areꞌ oe maat ein anpeꞌen rafuꞌ-rafuꞌ ma npuran napoitn ein oe. ");
INSERT INTO aaz_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Onaim uran naan ansaun ka nasnaas niit fa, fai-manas, tar antea neno boꞌ haa. ");
INSERT INTO aaz_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mes neno naan, naiꞌ Noh, in fee, in aanh ein teun sin, esan reꞌ: naiꞌ Sem, naiꞌ Yafet, ma naiꞌ Ham, ma in aan naenf ein ntaman okeꞌ neun abnao naan. ");
INSERT INTO aaz_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Sin ntaam nabuan nok muiꞌ aem ein, muiꞌ fui ngguin, muiꞌ anoonk ein, koron, ma muꞌit bian reꞌ maniniꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Pasan meseꞌ-meseꞌ naꞌko areꞌ amoint ein, ntaam nabuan nok naiꞌ Noh nbin abnao, natai nok saaꞌ reꞌ Uisneno napreent ee. Oras sin ntaman nrarin okeꞌ te, UISNENO neikn On naꞌeek ma naꞌretuꞌ bnao naan in enon. ");
INSERT INTO aaz_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Uur koꞌu naan nsaun piut, tar antea neno boꞌ haa. Onaim noe sakoꞌ nsae piut tar antea bnao naan natboe. Oe ji nsae piut tar nmemun naneuk ꞌtoꞌe mnaun ein okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Oe naan nsae piut, tar in aꞌraatn ii meter hiut nneis naꞌko ꞌtoꞌe mnaun reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Onaim areꞌ kanan amoint ein nbin auf metoꞌ nmaet sapuꞌ. Amaets ein esan reꞌ: mansian, muiꞌ aem, muiꞌ fui, anonok, ma koro. Suma naiꞌ Noh ma sin abitan abnao goe nanan sin mesen nmonin. ");
INSERT INTO aaz_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oe naan ka nsaun niit fa tar antea neno nautn es boꞌ niim (150). ");
INSERT INTO aaz_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mes Uisneno ka nnikaꞌ fa naiꞌ Noh ma areꞌ muiꞌt ein anbin abnao naan. Onaim In npaek anin he nfuu nameit oe naan. ");
INSERT INTO aaz_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","In nkeeh nain oe maat ein, ma nasnasab uran. ");
INSERT INTO aaz_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Onaim oe naan ansaun piut. Neno nautn es boꞌ niim (150) namsoup on nai te, oe naan in asraatn ii nheer on aꞌkreꞌo. ");
INSERT INTO aaz_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nateef fuun hiut ii ntaam neno boꞌes am hiut on nai te, bnao naan naꞌraeꞌt on nbi ꞌtoeꞌ aꞌraats es, kaan ee, Ararat. ");
INSERT INTO aaz_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Oe naan ansaun piut. Oras naan fuun boꞌ ii ntaam neno meseꞌ, aꞌtoeꞌf ein sin aꞌpuupk ein mamniit ein een. ");
INSERT INTO aaz_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ankoon naꞌko neno boꞌ haa on naan ate, naiꞌ Noh nasoit abnao naan in eno sneer. ");
INSERT INTO aaz_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Rarit in nafetin kor-kaaꞌ es. Koro naan natpeen neu-mneem tar antea oe naan ansaun batuur-batuur. Ma in ka nfain fa on abnao naan. ");
INSERT INTO aaz_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Onaim naiꞌ Noh nafetiꞌ ntein kor-kefi he nriun ma nahiin niit kar-karu aiꞌ oe naan nmeit inrair. ");
INSERT INTO aaz_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mes oe naan feꞌ nmemun pah-pinan, etun koro naan ka napein fa bare he ntook. Onaim in nfain on abnao. Naiꞌ Noh annonaꞌ in aꞌniman, ma ntoup nataam koro naan anfain neu bnao. ");
INSERT INTO aaz_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Naiꞌ Noh anpao ntein neno hiut. Onaim in nafetiꞌ ntein kor-kefi naan. ");
INSERT INTO aaz_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Maans ee nmaeb on naan ate, kor-kefi naan anfain neem. In nteo neik hau noo saitun es. Rarit naiꞌ Noh nahiin nak oe naan ansaun batuur een. ");
INSERT INTO aaz_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","In npao ntein neno hiut. In nafetiꞌ ntein kor-kefi naan. Mes neot reꞌ ia, kor-kefi naan ka nfain neem af. ");
INSERT INTO aaz_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Fuun mees ii ntaam neno meseꞌ, oras naiꞌ Noh nmoin naan toon natun nee mtoon meseꞌ (601), oe naan anmeit inrair. Naiꞌ Noh nasoit antein eno sneer. In napeen ete, auf gui nmeto nrair. ");
INSERT INTO aaz_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Anbi fuun nuaꞌ ii ntaam neno boꞌ nua mhiut, afu naan anmeto nkoon goen. ");
INSERT INTO aaz_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Rarit Uisneno nreun naiꞌ Noh am nak, ");
INSERT INTO aaz_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Oras ia, hi msaun nai miꞌko bnao naan. ");
INSERT INTO aaz_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Misanut muiꞌt ein naan ok-okeꞌ! Esan reꞌ: muiꞌ aem, muiꞌ fui, anonok, ma koro. Maut he sin namsaꞌin, he naheun pah-pinan.” ");
INSERT INTO aaz_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Rarit naiꞌ Noh, in fee, in aanh ein, ma in aan naenf ein, ansanun okeꞌ naꞌkon abnao naan. Muiꞌt ein naan ansanun amsaꞌ, es-es ate natuin in nonot. ");
INSERT INTO aaz_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Rarit naiꞌ Noh nbakin fatu he ntao mei fuat neu UISNENO. Naꞌko muiꞌt ein reꞌ nabeiꞌ he npaek sin anjarin fuaꞌ-turuꞌ, naiꞌ Noh nheek mes-meseꞌ. Rarit in nroor sin ma nout sin anbin mei fuat, he njair tanar nak in nasaeb seun-banit neu UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Oras UISNENO nafoi niit fuaꞌ-tuurꞌ ein naan sin foo meink ein, In nmariin. Onaim In natenab am nak, “Anmurai oras ia, Au ka ꞌkaas aꞌteniꞌ fa pah-pinan natuin mansian ein sin ꞌmoeꞌ reꞌuf. Maski sin nateenb ahaa rais reꞌuf naꞌkon aanꞌ-anaꞌ, mes Au of ka ureꞌu ꞌtein fa areꞌ kanan amonit, on reꞌ Au feꞌ ureuꞌ urair je naan. ");
INSERT INTO aaz_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Anbi oras pah-pinan ia feꞌe nbi naa, oors ein nanaob ok piut, natuin ahaa sin atreek ein. Esan reꞌ: oras senat ma sekit, oras mainikin ma maputuꞌ, oras fauk-nais ma uur napu, fai ma manas.” ");
INSERT INTO aaz_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Uisneno nfee tetus-athoen neu naiꞌ Noh ma in fee-anah sin. In naꞌuab am nak, “Hi mihoniꞌ ma mimsaiꞌ he miheun pah-piin ii mtein. ");
INSERT INTO aaz_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Muiꞌ fui ngguin ma koro, ikaꞌ of namtausan ki. Au ꞌnonaꞌ sin ꞌeu ki. ");
INSERT INTO aaz_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hi bole meuk muiꞌt ein naan sin siisk ein on reꞌ hi bole miah aiꞌ meuk hau fuaꞌ sin. Au ꞌfee areꞌ saaꞌ-saaꞌ ein reꞌ ia ꞌeu ki. ");
INSERT INTO aaz_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mes hi kais meuk sisi reꞌ in naaꞌ ee ka nsai npoi fa feꞌ, natuin muiꞌt ein sin aꞌmoink ein et naaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Au ꞌmoeꞌ mansian ii natuin Au huumk am Au masak, Au moeꞌk am Au taos. Es naan ate, kais amroor mansian. Karu nmuiꞌ tuaf, aiꞌ muꞌit, naꞌmaet mansian, hi ro he miꞌmaet je msaꞌ. Prenat reꞌ ia, neem naꞌko Kau. ");
INSERT INTO aaz_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hi ro he mihoniꞌ ma mimsaiꞌ, he miheun pah-piin ii mtein.” ");
INSERT INTO aaz_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Uisneno ntuut In uaban naan am nak, ");
INSERT INTO aaz_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Oras ia, Au he uhakeꞌ manbaꞌan ꞌok ki tar antea hi sufam-kauꞌm ein imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Rais manbaꞌan reꞌ ia nmatoon nok areꞌ kanan amonit amsaꞌ. Esan reꞌ: muiꞌ aem, muiꞌ fui, ma koro. Paraꞌ te, apoit ein reꞌ nok ki naꞌko bnao naan in nanan. ");
INSERT INTO aaz_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au rais manbaꞌan naan, on nai: Au ka ꞌfee ꞌteniꞌ fa noe sakoꞌ he nmemun naꞌmaet areꞌ kanan amonit anbin pah-pinan ia. ");
INSERT INTO aaz_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Au ꞌtao Au eons ee ꞌbi neon goe he nfain tanar. Enous naan, of namnaubaꞌ Kau ꞌeu Au rais manbaꞌan ia reꞌ ka natfeek niit fa ꞌeu ki, ꞌeu amoint ein ok-okeꞌ, ma ꞌeu pah-pinan ia msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Karu nmuiꞌ nope nbi neno, rarit eons ee npoi, in of namnaubaꞌ Kau mnak: noe sakoꞌ of ka nareꞌu nteniꞌ fa areꞌ amoint ein nbin pah-pinan ia. Nok ranan naan, Au rais manbaꞌan abar-barat ia, nmafuut piut nok ki, ma nok areꞌ kanan amonit.” ");
INSERT INTO aaz_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Naiꞌ Noh in aanh ein reꞌ npoin naꞌkon abnao naan esan reꞌ: naiꞌ Sem, naiꞌ Yafet, ma naiꞌ Ham. (Naiꞌ Ham naan, es reꞌ naiꞌ Kanaꞌan in amaf). ");
INSERT INTO aaz_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mansian pah-pinan ia ok-okeꞌ, amneemk ein naꞌkon naiꞌ Noh in aan teun ein reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Naiꞌ Noh naan, atoin tani. In es reꞌ aroe hau anggur ahun-hunut. ");
INSERT INTO aaz_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Neot es, naiꞌ Noh niun raur anggur tar antea nmauf ka nahiin jon fa. Onaim in nhoroꞌ nain in paken, rarit in ntuup natneen af-aaf aah nbi in tenas. ");
INSERT INTO aaz_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Oras naiꞌ Ham antaam ate, in niit in aamf ee ntuup aaf aah. Onaim in naen anpoi, ma nnao natonan in tataf, naiꞌ Sem ma naiꞌ Yafet. ");
INSERT INTO aaz_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Rarit sin nua sin naitin tais ma npiraꞌ naꞌratan tais naan anbi sin haunk ein. Rarit sin nnaon ntet-kotin ntaman neun tenas naan, ma nkuub naan sin amaf. Sin ka niit fa sin aamf ee ꞌmaen. Rarit sin npoin nfanin. ");
INSERT INTO aaz_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Oras naiꞌ Noh in mauf goe okeꞌ, in nahiin in aan moen aheit suus goe in aꞌmoꞌen. ");
INSERT INTO aaz_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Rarit in naꞌuab am nak, “Hoe! Kanaꞌan amaf! Au ꞌkaas ko! Ho of amfain ate meu sin ho tataꞌ! ");
INSERT INTO aaz_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pures-boꞌis neu UISNENO, natuin naiꞌ Sem! Mes naiꞌ Kanaꞌan anjair naiꞌ Sem in aan renuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Maut he Uisneno anfeons am anhainua ntein naiꞌ Yafet in pah. Ma in suufk ein nmonin nbin mamut ma rameꞌ nok naiꞌ Sem in sufan. Mes maut he naiꞌ Kanaꞌan anjair naiꞌ Yafet in aan rekaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Anmurai naꞌko noe sakoꞌ naan anmeit, naiꞌ Noh anmoni ntein toon natun tenu mboꞌ niim (350). ");
INSERT INTO aaz_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","In nmaet oras in nmoin naan toon natun seo mboꞌ niim (950). ");
INSERT INTO aaz_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noe sakoꞌ naan namsau nrair on nai te, naiꞌ Noh in aanh ein nmurai nahoin ein. In napein sufaf naꞌko naiꞌ Sem, naiꞌ Yafet, ma naiꞌ Ham. ");
INSERT INTO aaz_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Naiꞌ Yafet in suufk ein esan reꞌ: naiꞌ Gomer, naiꞌ Magok, naiꞌ Madai, naiꞌ Jawan, naiꞌ Tubal, naiꞌ Mesek, ma naiꞌ Tiras. Es-es ate nok in uab, in uuf, ma in pah. Naiꞌ Gomer in suufk ein esan reꞌ: naiꞌ Askenas, naiꞌ Rifat, ma naiꞌ Togarma. Naiꞌ Jawan in suufk ein esan reꞌ: naiꞌ Elisa, naiꞌ Tarsis, abitan Kitim, ma abitan Dodanim reꞌ natuan et tais je ninin. ");
INSERT INTO aaz_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Naiꞌ Ham in suufk ein, esan reꞌ: naiꞌ Kus, naiꞌ Misraim, naiꞌ Put, ma naiꞌ Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Naiꞌ Kus in suufk ein esan reꞌ: naiꞌ Seba, naiꞌ Habira, naiꞌ Sapta, naiꞌ Raema, ma naiꞌ Sapteka. Naiꞌ Raema in suufk ein esan reꞌ: naiꞌ Seba ma naiꞌ Dedan. ");
INSERT INTO aaz_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Naiꞌ Kus in aan moen je, es reꞌ naiꞌ Nimrot. Atoniꞌ reꞌ ia, meo paꞌe ahun-hunut reꞌ maꞌtain besi. ");
INSERT INTO aaz_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","In maꞌtanin naan amneemn ii naꞌko UISNENO, tar antea in nfain aseok reok goes. Etun sin ntekan nee te, nak, “Maut he ho mjair aseok reok goes on reꞌ naiꞌ Nimrot, reꞌ napein in maꞌtain ee naꞌko UISNENO.” ");
INSERT INTO aaz_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nahunu te in pah ee nmurai naꞌko Babel, Erek Akat, ma Karne. Baren reꞌ ia sin etan pah koꞌu Sinear. ");
INSERT INTO aaz_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Naꞌko naan in nhainua ntein in kua-prenat antea Asur. Rarit in nafenaꞌ kota Niniwe, kota Rehobot-Ir, kota Kara, ");
INSERT INTO aaz_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma kota Resen, reꞌ et Niniwe ma Kara sin atnaank ein. Baren naan, pah koꞌun. ");
INSERT INTO aaz_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Naiꞌ Misraim in suufk ein, esan reꞌ: abitan Rudim, abitan Ananim, abitan Rehabim, abitan Naftuhim, ");
INSERT INTO aaz_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","abitan Patrusim, abitan Kasruhim, ma abitan Kaftorim. Abitan Kasruhim naan, esan reꞌ atoin Filistinas sin beif-naꞌif sin. ");
INSERT INTO aaz_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Naiꞌ Kanaꞌan in aan moen uun goe es reꞌ naiꞌ Sidon. Naiꞌ Kanaꞌan anfain aam uuf neu atoin Hetes, ");
INSERT INTO aaz_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","atoin Jebusis, atoin Amoris, atoin Girgasis, ");
INSERT INTO aaz_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","atoin Hibisas, atoin Arkis, atoin Sinis, ");
INSERT INTO aaz_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","atoin Arbadis, atoin Semaris, ma atoin Hamatis. Naiꞌ Kanaꞌan in suufk ein ansei jok ntean bare ꞌroo-ꞌroo, ");
INSERT INTO aaz_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","tar antea sin aꞌnaakt ein nmurai naꞌkon kota Sidon nkoon kuan Gerar ntean pah Gasa. Naꞌko naan, nkoon neun kota Sodom, kota Gomora, kota Atma, ma kota Seboim, tar antean kota Rasa. ");
INSERT INTO aaz_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sin arsin reꞌ naan, naiꞌ Ham in sufan. Es-es ate nok in uab, in uuf, ma in pah. ");
INSERT INTO aaz_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Naiꞌ Yafet in tataf naiꞌ Sem anjair abitan Eber sin aam uuf. ");
INSERT INTO aaz_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Naiꞌ Sem in suufk ein, esan reꞌ: naiꞌ Elam, naiꞌ Asur, naiꞌ Arpaksat, naiꞌ Lut ma naiꞌ Aram. ");
INSERT INTO aaz_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Naiꞌ Aram in suufk ein, esan reꞌ: abitan Us, abitan Hur, abitan Geter, ma abitan Mas. ");
INSERT INTO aaz_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Naiꞌ Arpaksat in aanh ee, es reꞌ naiꞌ Sera. Naiꞌ Sera in aanh ee, naiꞌ Eber. ");
INSERT INTO aaz_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Naiꞌ Eber napein riꞌaan mone nua. Atoin kouꞌ goe, kaan ee naiꞌ Pelek (reꞌ in aꞌmoufn ii ‘batis aiꞌ sisaꞌet’), natuin oras naan, mansian ein anbaits ok neu areꞌ bare-bare nbin pah-pinan. In oirf ee, kaan ee naiꞌ Joktan. ");
INSERT INTO aaz_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Naiꞌ Joktan in suufk ein, esan reꞌ: naiꞌ Armodat, naiꞌ Seref, naiꞌ Hasar-Mabet, naiꞌ Jera, ");
INSERT INTO aaz_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","naiꞌ Hadoram, naiꞌ Usar, naiꞌ Dikra, ");
INSERT INTO aaz_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","naiꞌ Obal, naiꞌ Abimaer, naiꞌ Seba, ");
INSERT INTO aaz_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","naiꞌ Ofir, naiꞌ Habira, ma naiꞌ Jobap. Sin arsin reꞌ ia, naiꞌ Joktan in sufan. ");
INSERT INTO aaz_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bare-bare reꞌ sin natua ngguin, anmurai naꞌkon Mesa nkono ntean Sefar, esan reꞌ baer maꞌtoeꞌf ein et pasaꞌ neon-saet. ");
INSERT INTO aaz_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sin arsin naiꞌ Sem in sufan. Es-es ate nok in uab, in uuf, ma in pah. ");
INSERT INTO aaz_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sin arsin ok-okeꞌ, naiꞌ Noh in sufan-kaꞌun, es-es ate nok in uuf akuun. Oras noe sakoꞌ naan namsau, sin reꞌ ia es reꞌ ansei jok ma nbaits ok ma naheun pah-pinan. ");
INSERT INTO aaz_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Un-unuꞌ feꞌe te, mansian pah-pinan naꞌuab ein neik uab meesꞌ aah. ");
INSERT INTO aaz_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Oras sin bian anmurai nanain ein neun pasaꞌ neon-saet, sin ntean mneer es et Sinear, onaim sin natuan nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Sin arsin anmaꞌakoran am nak, “Hoe! Aok-bian arki! Iim he hit tafenaꞌ kuuk kota kouꞌ goes. Onaim hit tmoeꞌ faut meꞌe, rarit hit tout sin tar naheran. Hit taktutaꞌ fatun naan ma traem sin tpaek ter. Rarit hit tahakeꞌ koat maꞌuim fatu mnaun es anbi kota koꞌu naan in nanan. Koat maꞌuim fatu naan, in aꞌpuupn ee ansutrai neno, henatiꞌ hit matekaꞌ kit. Ma maut he hit tjair uuf kouꞌ goes, ma kaisaꞌ tbaits ok.” ");
INSERT INTO aaz_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Onaim UISNENO nsaun neem ma nnoon kota ma koat maꞌuim faut maktuta mnaun aꞌratas reꞌ mansian ein naan nafeen ee. ");
INSERT INTO aaz_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Rarit In naꞌuab am nak, “Sin reꞌ ia, uuf meseꞌ ma uab meseꞌ. Saaꞌ reꞌ sin nmoeꞌ je oras ia, feꞌ nfaat noon. Nokaꞌ-nmeu, karu sin arsin nmafutun njarin meseꞌ on reꞌ oras ia, sin of nabeꞌin he nmoꞌen saaꞌ-saaꞌ ahaa. ");
INSERT INTO aaz_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Reko nneis Hit tsaun he trikrakan sin uab, he njair uabaꞌ humaꞌ-humaꞌ. Maut henatiꞌ es-es ate ka nahiin fa es in uaban.” ");
INSERT INTO aaz_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Rarit Uisneno nsanu ma nrikrakan sin uab. Nok ranan naan, In nmoeꞌ mansian ein ansiksakn ok neun areꞌ bare nbin pah-pinan. Onaim sin ka nafenaꞌ nakonob fa kota naan. ");
INSERT INTO aaz_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Natuin UISNENO nrikrakan sin uab, ma nsiksakan sin neun areꞌ bare nbin pah-pinan, etun sin nakanab kota naan Babel (reꞌ he noi humaꞌ meseꞌ on reꞌ kata es, reꞌ in oetn ii ‘takaꞌnanaꞌ’). ");
INSERT INTO aaz_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Naiꞌ Sem in suufk ein esan reꞌ ia: oras noe sakoꞌ naan namsau toon nua, naiꞌ Sem anmoin naan toon nautn es (100), in nahoniꞌ riꞌaan moen jes, ma nakaanb ee naiꞌ Arpaksat. ");
INSERT INTO aaz_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Rarit in nmoni ntein toon natun niim (500) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Oras naiꞌ Arpaksat nmoin naan toon boꞌ tenu mniim (35), in nahoniꞌ riꞌaan moen jes, ma nakaanb ee, naiꞌ Sera. ");
INSERT INTO aaz_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Rarit naiꞌ Arpaksat nmoni ntein toon natun haa mtoon teun (403) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Oras naiꞌ Sera nmoin naan toon boꞌ teun (30), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Eber. ");
INSERT INTO aaz_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Rarit naiꞌ Sera nmoni ntein toon natun haa mtoon teun (403) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Oras naiꞌ Eber nmoin naan toon boꞌ tenu mhaa (34), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Pelek. ");
INSERT INTO aaz_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Rarit naiꞌ Eber nmoni ntein toon natun haa mboꞌ teun (430) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Oras naiꞌ Pelek anmoin naan toon boꞌ teun (30), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Rehu. ");
INSERT INTO aaz_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rarit naiꞌ Pelek nmoni ntein toon natun nua mtoon seo (209) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Oras naiꞌ Rehu nmoin naan toon boꞌ tenu mnua (32), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Seruk. ");
INSERT INTO aaz_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rarit naiꞌ Rehu nmoni ntein toon natun nua mtoon hiut (207) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Oras naiꞌ Seruk anmoin naan toon boꞌ teun (30), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Nahor. ");
INSERT INTO aaz_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Rarit naiꞌ Seruk nmoni ntein toon natun nua (200) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Oras naiꞌ Nahor anmoin naan toon boꞌ nua mseo (29), in nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Tera. ");
INSERT INTO aaz_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Rarit naiꞌ Nahor nmoni ntein toon nautn es boꞌes am seo (119) feꞌ, ma in nahoni nteniꞌ riꞌaan mone ma riꞌaan feto. ");
INSERT INTO aaz_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Oras naiꞌ Tera nmoin naan toon boꞌ hitu nneis, in nahoniꞌ riꞌaan mone teun, esan reꞌ: naiꞌ Abram, naiꞌ Nahor, ma naiꞌ Haran. ");
INSERT INTO aaz_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Naiꞌ Tera in sufan-kauꞌn ein, esan reꞌ ia: naiꞌ Tera in aanh ein, naiꞌ Abram, naiꞌ Nahor, ma naiꞌ Haran. Naiꞌ Haran nahoniꞌ riꞌaan moen jes, es reꞌ naiꞌ Rot. ");
INSERT INTO aaz_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Naiꞌ Haran nmate nbi in kua mnasiꞌ Ur, et pah atoin Kasdimas. Oras in anmaet, in amaf naiꞌ Tera nmoin feꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Naiꞌ Abram ansao bi Sarai. Naiꞌ Nahor ansao naiꞌ Haran in aan feto, bi Milka. Naiꞌ Haran nahoniꞌ riꞌaan moen jes amsaꞌ, es reꞌ naiꞌ Jiska. ");
INSERT INTO aaz_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mes bi Sarai nkiu. ");
INSERT INTO aaz_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Neot es, naiꞌ Tera neik in anah naiꞌ Abram, in aan nanef bi Sarai, ma in upuf naiꞌ Rot. Sin npoin ma nnaon nasaitan sin kua-mnasiꞌ Ur. Oras naan, sin he nnaon neu pah Kanaꞌan. Mes antean pah Haran, sin natuan nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Anbin naan, naiꞌ Tera nmaet, oras in nmoin naan toon natun nua mtoon niim (205). ");
INSERT INTO aaz_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Oras naan, UISNENO naꞌuab neu naiꞌ Abram am nak, “Abram! Ho mnao musait ho nonot-asar, ho amaꞌ in umi, ma ho kuan. Ho mnao meu baer jes, reꞌ Au of ukriir ee ꞌeu ko. ");
INSERT INTO aaz_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Au of aꞌfee tetus-athoen ꞌeu ko. Ma ho sufam-kauꞌm ein of amfau-rutu, ma of anjarin uuf maꞌtaniꞌ, tar ho kanam naan of matekaꞌ. Rarit ho mjair atoin amneik tetus meu atoin sonaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Au of aꞌfee tetus ꞌeu tuaf-tuaf reꞌ nfee tetus neu ko. Mes Au of aꞌfee kasat ꞌeu tuaf-tuaf reꞌ nkaas ko. Amneen murek-rekoꞌ! Areꞌ uuf-uuf anbi pah-pinan ia of napenin tetus, natuin ho.” ");
INSERT INTO aaz_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Oras naan, naiꞌ Abram anmoin naan toon boꞌ hitu mniim (75). In neik in fee bi Sarai, ma orif naiꞌ Haran in anah naiꞌ Rot, ma in baer pusaak ein ok-okeꞌ, ma ameupt ein in uim je nanan reꞌ in napein sin anbin kota Haran. Onaim naiꞌ Abram annao nasaitan kota Haran, neu bare reꞌ UISNENO nbaꞌan anrair je he nakriir ee neu ne. Sin nnaon nkonon ntean pah es, in kaan ee, pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Antean bare naan ate, naiꞌ Abram sin annoon goe nfuun am nateef, tar sin mpaumakan ntean kuan Sikem. Rarit sin natuan ntaahn ein anpaumaak hau kouꞌ goes et More. Oras naan, abitan Kanaꞌan feꞌ natuan nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Anbi bare naan, UISNENO nakriir On neu naiꞌ Abram. In naꞌuab am nak, “Au of aꞌfee bare ia ꞌeu ho sufam-kaꞌum sin.” Rarit naiꞌ Abram nbakin mei fatu he njair mei fuat neu UISNENO reꞌ nakriir On anbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Rarit naiꞌ Abram sin nanain ein bare. Sin nnaon neun aꞌtoꞌef et pasaꞌ haaꞌ-nua. Rarit sin natua ntaahn ein nbin kuan Betel ma kuan Ai sin atnanak. Anbi bare naan, in nbaik mei fuat, ma naꞌbees neu UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Rarit sin natnan-nain bare, naꞌko baar jes neu baar jes, ntean pah Negep et Kanaꞌan pasaꞌ haaꞌ-nua. ");
INSERT INTO aaz_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Neot es, amnahas maꞌtaniꞌ antaman pah Kanaꞌan. Es naan ate, naiꞌ Abram sin nnaon naꞌroo nteinꞌ ein neu pasaꞌ haaꞌ-nua, ntean pah Masir. Sin natuan ntaahn ein anbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Oras sin he ntaman neun pah Masir, in naꞌuab neu in fee bi Sarai mnak, “Sarai, ho maas maan reokn ii kaah! ");
INSERT INTO aaz_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Onaim karu abitan pah Masir niit ho maasm ii te, sin of naꞌmaet kau, natuin au reꞌ ia ho mone. Onaim sin of ansao ko. ");
INSERT INTO aaz_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Onaim reko nneis, ho mutonan sin am mak, au reꞌ ia, ho naꞌo. Nok ranan naan, sin ka neu nroor kau fa, mes sin of nok kau te, reko, natuin sin nroim ko.” ");
INSERT INTO aaz_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Onaim oras naiꞌ Abram sin ntean pah Masir, abitan naan niit ain Sarai in masan arekot naan. ");
INSERT INTO aaz_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Oras usif pah Masir in atutaꞌ-abhaꞌet sin niit ee te, sin nboiꞌs ahaa bifee naan nbi uisf ee in matan. Onaim sin neik bifee naan neu uisf ee in sonaf. ");
INSERT INTO aaz_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Onaim usif naan nok naiꞌ Abram nmonin reko, natuin bi Sarai. Rarit uisf ee nfeen naiꞌ Abram bijae, bikaes keledai, bikaes unta, ꞌbibi, ma ꞌbib-kase. Uisf ee nfee sin ruum aah. In nfee ate neu naiꞌ Abram amsaꞌ, et bifee ma atoniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mes natuin uisf ee nataam atoniꞌ in fee nbi in sonaf, es naan ate, UISNENO nhukun usif naan. Etun uisf ee napein hukun humaꞌ-humaꞌ, et in ma in uim je naan ee msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Rarit uisf ee noꞌen naiꞌ Abram ma nataan ee mnak, “Abram! Ho mmoeꞌ kau on mee? Nansaaꞌ am es ho ka mutoon fa mmak bifee ia, ho fee ja? ");
INSERT INTO aaz_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mes ho mak in reꞌ ia, ho fetoꞌ! Aar akreꞌo te, au ꞌsao! Amtoup mufaniꞌ ho fee. Oras ia, meik je ma mpoi maen mimneuk nai! Au ka ꞌiit aꞌtein ki fa mbi bare ia!” ");
INSERT INTO aaz_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Rarit uisf ee naprenat in ameupt ein he nriuꞌ napoitan naiꞌ Abram ma in fee, ma sin baerꞌ ein ok-okeꞌ. Sin ro he nasaitan bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Rarit naiꞌ Abram nasaitan pah Masir, he ntebi nfain neun pah Negep. In neik in fee, ma in baer pusaak ein okeꞌ. In oirf ee anah naiꞌ Rot nok amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Naiꞌ Abram naan, atoin amuꞌit. In muiꞌt ein amfau-rutu. Noni mnatuꞌ msaꞌ, mfaun. ");
INSERT INTO aaz_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Naꞌko Negep in natnan-nain he nfain on kuan Betel ma kuan Ai sin atnaank ein. Unuꞌ te, in natua nbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ma in nbaik mei fuat amsaꞌ. Rarit in naꞌruriꞌ ma naꞌbees neu UISNENO nbi bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Naiꞌ Rot, reꞌ nok naiꞌ Abram naan, nmuiꞌ muꞌit amsaꞌ. In muiꞌt ein amfaun. Ma in nmuiꞌ ameput namfau msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Mes bare naan ka mainuan reko fa neu naiꞌ Abram ma naiꞌ Rot sin. Natuin sin aꞌmuiꞌk ein namfaun, etun sin ka bisa fa he nmoin nabuan. Onaim naiꞌ Abram ma naiꞌ Rot sin atuuks ein anmatoen, natuin huun reꞌ nbi bare naan ka nanokab fa neu sin muiꞌt ein. (Oras naan, atoin Kananas ma atoin Feris feꞌ natuan nbin naan amsaꞌ.) ");
INSERT INTO aaz_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Onaim naiꞌ Abram nak neu in anah naiꞌ Rot am, nak “Rot! Hit nua kit umi nanan. Natiꞌ hit nua kit kaisaꞌ tmatenab, ma hit atuuks ein amsaꞌ kaisaꞌ nmatoen piut. ");
INSERT INTO aaz_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Reko nneis hit nua kit atbaits ok. Bare ia, mainuan feꞌ. Onaim karu ho mpiir bare nbi pasaꞌ ponain, henat au ꞌait abit pasaꞌ haaꞌ-nua. Mes karu ho mpiir bare nbi pasaꞌ haaꞌ-nua, henat au ꞌait abit pasaꞌ ponain.” ");
INSERT INTO aaz_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Rarit naiꞌ Rot ankisu nfuun am nateef. Ma in niit karopu mneer koꞌu noe Yarden reꞌ oe ji nho-hoe, ntea kuan Soar. Bare naan in amrian ii on reꞌ UISNENO in poꞌon, ma on reꞌ pah Masir. (Oras naan, UISNENO feꞌ ka nareuꞌ fa kota Sodom ma kota Gomora. Etun bare naan reko feꞌ.) ");
INSERT INTO aaz_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Onaim naiꞌ Rot anpiir naan bare nbi karopu mneer koꞌu noe Yarden naan. Ma nua sin anbaits ok. Rarit naiꞌ Rot annao nꞌain pasaꞌ maans ee ꞌsaen. ");
INSERT INTO aaz_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Mes naiꞌ Abram natua nabaar anbi pah Kanaꞌan. Naiꞌ Rot annao natua nbi kuan-kuan reꞌ anhaumaak kota Sodom et karopu mneer koꞌu noe Yarden. ");
INSERT INTO aaz_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mes abitan kota Sodom naan, atoin aburaurt ein. Ma sin ka nfairoir fa UISNENO msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Oras naiꞌ Rot ma naiꞌ Abram anbaits ok, UISNENO nak naiꞌ Abram am nak, “Abram! Ho mkius mutef-tefan miit bare-bare muꞌko bare reꞌ ho mhaek naan. Amkius murek-rekoꞌ ꞌrii-ꞌneꞌu, koti-mmaat. ");
INSERT INTO aaz_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Au of aꞌfee afu bare-bare reꞌ ho mkius sin naan, ꞌeu ko ma ꞌeu ho sufam-kauꞌm ein, he njarin sin auf pusaak tar antea nabar-baar. ");
INSERT INTO aaz_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Au of aꞌmoeꞌ ho sufam-kauꞌm ein he nfain too mfaun on reꞌ snaen anbi tais je ninin. Tar atoniꞌ ka nsoiꞌ nabeiꞌ sin fa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Oras ia, ho mnao mnoon bare-bare reꞌ ho miit murair sin naan, natuin Au he ꞌfee sin ꞌeu ko!” ");
INSERT INTO aaz_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Rarit naiꞌ Abram sin natnanin, ma nfain natua nteinꞌ ein nbin hau kouꞌ guin Mamre, npaumaak kuan Hebron. Rarit in nbaik mei fuat, onaim naꞌruriꞌ ma naꞌbesan neun UISNENO nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Oras naan, usif haa nabuan. Sin esan reꞌ: Amrafel, usif pah Sinear; Ariok, usif pah Elasar; Kedarlaomer, usif pah Elam; ma Tidear, usif pah Goyim. ");
INSERT INTO aaz_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Oras naan amsaꞌ, usif niim antein nabuan. Sin esan reꞌ: Bera, usif pah Sodom; Birsa, usif pah Gomora; Sinap, usif pah Adema; Semeber, usif pah Seboim; ma Bela, usif pah Soar. Rarit uis haaꞌ ein naan anmakenan nok uis niimꞌ ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Uis niimꞌ ein naan nabuan nok sin soraurs ein anbin karopu mneer koꞌu Sidim, (reꞌ oras ia sin nteek ee nak, Tasi ꞌMaten). ");
INSERT INTO aaz_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Makenat naan, naꞌuub on naꞌko rasi reꞌ ia: unuꞌ te, usif Kedarlaomer naprenat uis niimꞌ ein naan, toon boꞌes am nua. Mes toon boꞌes am teun ii ntaam ate, sin nmurai nraban usif Kedarlaomer. ");
INSERT INTO aaz_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Oras toon boꞌes am haan ii ntaam ate, usif Kedarlaomer nok usif teun, neman nok sin soraurs ein. Onaim sin nmakenan ma niis pah-pah bian sin, esan reꞌ: atoin Refaimas et pah Asterot-Karnaim, atoin Susimas et pah Ham, atoin Emimas et pah Sawe-Kirjataim, ");
INSERT INTO aaz_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma atoin Horis reꞌ et aꞌtoꞌef Seir ntean baer ruman El Paran in ninin. ");
INSERT INTO aaz_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Rarit sin ntebi nfanin neun En Mispat (reꞌ oras ia, in kaan ee Kades). Rarit sin nkuaas atoin Amalekas sin pah, ma nkuaas atoin Amoris reꞌ natuan nbin pah Haseson-Tamar. ");
INSERT INTO aaz_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Rarit uis niimꞌ ein naan anꞌator sin soraurs ein nbin karopu mneraꞌ Sidim. Onaim sin nmakenan nraban uis haaꞌ ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Anbi mneraꞌ naan, anmuiꞌ tepas ter amfaun. Oras makenat naan, usif Sodom ma usif Gomora nok sin soraurs ein, anfeen naenan. Bian anmoufu ntaman neun tepas ter ein naan. Ma bian naenan neun aꞌtoeꞌf ein. ");
INSERT INTO aaz_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Onaim uis haaꞌ ein reꞌ nisan nbin makenat naan, nasiik naan ma neik areꞌ bareꞌ ma mnahat naꞌko Sodom ma Gomora. Rarit sin ntebin nfanin. ");
INSERT INTO aaz_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Oras naan, naiꞌ Abram in anah naiꞌ Rot natua et Sodom. Onaim uis haaꞌ ein naan anheek neik naiꞌ Rot sin, ma nasiik neik sin baerꞌ ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mes anmuiꞌ tuaf es anfosuk naan on. Onaim in naen natonan naiꞌ Abram, atoin Ibranis. Oras naan, anmuiꞌ atoin Amoris es, kaan ee naiꞌ Mamre. Naiꞌ Abram natua npaumaak naiꞌ Mamre in hau kouꞌ guin. Naiꞌ Mamre in aok-bian ein, esan reꞌ naiꞌ Eskor ma naiꞌ Aner. Sin nua sin, naiꞌ Abram in soob rekon. ");
INSERT INTO aaz_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Oras naiꞌ Abram ntoup hanaf nak atoin ein anheek neik in oirf ee aanh ee te, in nabuabaꞌ in atoin ameupt ein reꞌ nmakeen nahinin. Sin arsin natun tenu mboꞌes am faun (318). Rarit sin nriuꞌ natuin uis haaꞌ ein naan naꞌroon ntean kuan Dan, et pasaꞌ ponain. ");
INSERT INTO aaz_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Anbi naan naiꞌ Abram nbait in ameupt ein naan anjarin pukan-pukan. Oras fai on naan ate, sin ntaman ntaisibun atoin ein naan, mes bian naenan. Rarit naiꞌ Abram nok iin na, nriuꞌ sin ntean kuan Hoba, et kota Damsik in pasaꞌ ponain. ");
INSERT INTO aaz_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Rarit naiꞌ Abram napein nafaniꞌ naiꞌ Rot, in ameupt ein, ma in baerꞌ ein okeꞌ, ma nafetin tuaf bian amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Oras naiꞌ Abram anfain neem naꞌko makenat reꞌ in niis naan uis haaꞌ ein naan ate, usif Sodom neem anseun nggoe nbi karopu mneraꞌ Sabe (reꞌ atoin ein natiꞌ te, nteek ee nak, Mneraꞌ Usif). ");
INSERT INTO aaz_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Oras naan, naiꞌ Melkisedek usif kota Salem, ma in aꞌnaak pirsait amsaꞌ neu Uisneno reꞌ Aꞌraat reꞌuf. In neem neik utunuꞌ ma tua min-kase neu naiꞌ Abram. ");
INSERT INTO aaz_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Rarit in nfee tetus neu naiꞌ Abram am nak, “Maut he Uisneno reꞌ Aꞌraat reꞌuf naan, reꞌ nmoeꞌ neno tunan ma pah-pinan naan, anfee tetus-athoen neu ko. Pures ma boꞌis neu Uisneno, reꞌ nfee ko rasi mnisat naꞌko ho musu sin!” Rarit naiꞌ Abram nfeen usif Melkisedek baits es naꞌko bait boꞌ naꞌko areꞌ saaꞌ-saaꞌ reꞌ in nasiik nafaniꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Rarit usif Sodom anbaiseun naiꞌ Abram. In naꞌuab am nak, “Aam Abram. Baerꞌ ein reꞌ ho musiik meik sin muꞌko au musun naan, maut he ho mpaar sin. Mes au ꞌtoit ufain ahaa, au too ngguin.” ");
INSERT INTO aaz_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mes naiꞌ Abram nataah am nak, “Au ꞌsuup aꞌpaek Uisneno Aꞌraat reꞌuf, reꞌ nmoeꞌ neno tunan ma pah-pinan In kaan ee, ");
INSERT INTO aaz_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mꞌak, au of ka ꞌait fa baer saaꞌ-saaꞌ es uꞌko ho baerꞌ ein naan. Maski abas tukaꞌ meseꞌ msaꞌ, au of ka ꞌait fa, tua. Nok ranan naan, neot es ate, ho ka bisa muꞌuabaꞌ fa mmak, ‘Au es umuꞌib naiꞌ Abram.’ ");
INSERT INTO aaz_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Au ka ꞌroim fa saaꞌ-saaꞌ. Suma bareꞌ mee ja reꞌ au ameupt ein anpake nrair sin ate, ho kais mutenab amtein sin nai. Ma maut he au soob teun ein ia, naiꞌ Aner, naiꞌ Eskor, ma naiꞌ Mamre, nait neik sin sapaak ein, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Rarit UISNENO nakriir On neu naiꞌ Abram, ma naꞌuab am nak, “Abram! Ho kais mumtau. Au es aꞌpanat ko uꞌko ho musun. Ma Au ꞌfee ko mnisat koꞌu.” ");
INSERT INTO aaz_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Mes naiꞌ Abram nak, “Koi, Usiꞌ. Maski Ho mfee kau saaꞌ-saaꞌ nathoe, noki-noki te, ruman. Natuin au ka ꞌmuiꞌ fa anah he nfain au sufak. Onaim au ꞌmuiꞌ pusaak amfaun he saaꞌ? Namuni te, au ate naiꞌ Eliaser atoin Damsik naan es anpaar sin.” ");
INSERT INTO aaz_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mes UISNENO nataah am nak, “Ka on naan fa! Ho aanh aan kuum of es reꞌ antoup pusaak naan. Ka ho ate naan fa.” ");
INSERT INTO aaz_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Onaim In neik naiꞌ Abram anpoi, rarit In nak, “Ho mbaiseun miit on neon goe! Amkius miit akfuun ein naan. Ho msoiꞌ maan sin ii, oo? Ho sufam-kauꞌm ein of amfau-rutu on reꞌ kfuun ein naan!” ");
INSERT INTO aaz_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Onaim naiꞌ Abram antebes UISNENO In uaban naan, rarit UISNENO nsoiꞌ je ntaam atoin neek amneꞌo, natuin naiꞌ Abram anpirsai Je. ");
INSERT INTO aaz_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Rarit UISNENO ntuut antein In uaban naan am nak, “Au reꞌ ia, Uisneno. Au es reꞌ ꞌeik ko mpoi muꞌko ho kua-mnasiꞌ Ur et pah atoin Kasdimas sin. Ma Au es reꞌ ꞌfee bare reꞌ ia, njair ho auf pusaak.” ");
INSERT INTO aaz_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mes naiꞌ Abram nataan am nak, “Mes on mee, UISNENO? Nok ranan mee te, naꞌ au uhini mꞌak bare ia njair au auf pusaak aa?” ");
INSERT INTO aaz_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Onaim In nataah am nak, “On nai! Uum he hit ttao taan moeꞌt es, he tfuut saaꞌ reꞌ Au uꞌuab ee feꞌe na. Oras ia, ho mnao mait muꞌit meu Kau: mait bijae ainf es, ꞌbib ainf es, ma ꞌbib-kaes keos goes. Sin reꞌ naan ro he toon ten-teun goah. Rarit ho mheek maan kor-otos es, ma kor-keif jes.” ");
INSERT INTO aaz_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Onaim naiꞌ Abram annao nheek muiꞌt ein naan okeꞌ. Rarit in roor sin, ma nkaah anbait muiꞌt ein naan. Rarit sin siisk ein, in nꞌator sin ranan nua nmaktun-tuin ein anbin afu, es ate anbaniꞌ neu in bian. Mes koorn ein in ka nkaah sin fa. ");
INSERT INTO aaz_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Rarit koor amneuk siis puun ein neman he nroi neik naan sisin reꞌ naan. Mes naiꞌ Abram anriuꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Oras maans ee nmouf, naiꞌ Abram antuup anfiin. In namnei mnak, meisꞌookn ii nkuub naan ee. Ma in namtau nmaet. ");
INSERT INTO aaz_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Rarit Uisneno naꞌuab neu ne mnak, “Abram! Ho of ammoin tar amtea mumnais ma mnuꞌir reꞌ-reꞌuf, ma ho of ammate mbi neek mamut, onaim sin of ansuub ko nok rek-reko. Mes ho sufam-kauꞌm ein of annaon njarin atoin amnemat nbi uuf bian sin pah. Kua-tuaf abitan pah naan of naꞌaet sin, naꞌpeniꞌ ma nhaꞌmuiꞌ sin, tar antea toon natun haa. Mes Au of aꞌhukun abitan pah naan. Rarit Au of ꞌeik upoitan ho sufam-kauꞌm ein naꞌkon bare naan, ma sin of neikin baer pusaak amfau-rutu. ");
INSERT INTO aaz_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Au of aꞌator he ho uup-kaꞌum batan niim amneemt ein, sin anfain neman neun bare ia ntenin. Oras ia, atoin Amoris sin natuan esan bare ia. Atoin ein ia amoeꞌ reuꞌf ein, mes feꞌ ba-baun. Neot es ate, karu ho uup-kaꞌum sin anfain neman ntean bare ia te, Au of aꞌpaek sin he ꞌhukun ureuꞌ atoin Amoris sin. Natuin oras naan, sin maufiunk ein kah een.” ");
INSERT INTO aaz_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Anfai on naan ate, nok askeken, aꞌnai konat es napoitan masuꞌ, ma paku ꞌnopoꞌ es anpiin, sin nnaon npeoꞌ sisin naan sin atnaank ein. ");
INSERT INTO aaz_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Oras naan, UISNENO nahakeb rais manbaꞌan nok naiꞌ Abram nak, “Au ꞌbaꞌan ꞌain, Au of aꞌfee bare ia ꞌeu ho sufam-kauꞌm ein, nmurai naꞌko noe Masir tar antea noe Efrat, ");
INSERT INTO aaz_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ma atoin Kenis sin pah, atoin Kenas sin pah, atoin Katmons sin pah, ");
INSERT INTO aaz_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","atoin Hetes sin pah, atoin Feris sin pah, atoin Refaimas sin pah, ");
INSERT INTO aaz_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","atoin Amoris sin pah, atoin Kananas sin pah, atoin Girgasis sin pah, ma atoin Jebus sin pah.” ");
INSERT INTO aaz_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Oras naan, naiꞌ Abram anfain neem een naꞌko pah Masir, ma natua naan toon boꞌes een anbi pah Kanaꞌan. In fee bi Sarai, ka nahoniꞌ fa feꞌ. Bi Sarai nmuiꞌ aet bifee jes, naꞌko pah Masir, in kaan ee, bi Hagar. Neot es, bi Sarai nak in moen je mnak, “Aam! UISNENO nꞌeek au apuk. Reko nneis, ho mtuup mok au ate bi Hagar, maut he au ꞌmuiꞌ anah.” Onaim naiꞌ Abram natuin in fee je hanan. Rarit bi Sarai nfee bi Hagar he naiꞌ Abram anpanaꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Rarit naiꞌ Abram antuup nok bi Hagar. Ma bi Hagar naꞌapuꞌ. Mes oras bi Hagar nahiin neu in naꞌapuꞌ te, in nabeoꞌ. In ka naꞌpaarn on fa neu ain Sarai. ");
INSERT INTO aaz_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Onaim ain Sarai naꞌuab nok in moen je mnak, “Au es aꞌfee ko ate naan he njair ho fee. Mes oras in ntaiboko te, in ka nkisu ntoom kau fa. Ia ho ras-rasim! Anbain he UISNENO es nafeek hit rasi. Maut henaꞌ ho muhiin!” ");
INSERT INTO aaz_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Rarit naiꞌ Abram nataah am nak, “On nai! Au ꞌsao ko nahuun. In namuin. Onaim ho es reꞌ he mupreent ee. Es naan ate, ho he mmoeꞌ saaꞌ-saaꞌ meu ne te, es reꞌ ho!” Rarit ain Sarai nmurai nhaꞌmuiꞌ bi Hagar, tar antea bi Hagar naen nasaitn ee. ");
INSERT INTO aaz_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","In naen antea baer ruumn es. Onaim UISNENO In ameput neno tunan es neem nateef ee nbi bare reꞌ npaumaak oe mataꞌ nbi ranan he nnao neu Sur. ");
INSERT INTO aaz_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Rarit in nak, “Hoe! Hagar, ain Sarai in ate! Nansaaꞌ am es ho es ia? Ho muꞌko mee, ma he mnao meu mee?” Onaim bi Hagar nataah am nak, “Au ꞌaen usaitan au ain usiꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Rarit UISNENO In ameput naan naꞌuab nok ne rek-reko mnak, “On nai! Reko nneis ho mfain meu ho ain usiꞌ. In nmoeꞌ ko on mee msaꞌ, mtoup goe. ");
INSERT INTO aaz_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kais mumtau. Au of aꞌmoeꞌ ho sufam-kauꞌm ein amfau-rutu, tar antea ka masoꞌik fa. ");
INSERT INTO aaz_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Oras ia, ho muꞌapuꞌ. Ka ꞌroo fa te, ho of muhoniꞌ riꞌaan moen jes. Ho ro he mukaanb ee, naiꞌ Ismaꞌel (reꞌ he noi namnees nok kata es, reꞌ in aꞌmoufn ii nak ‘Uisneno nneen’), natuin UISNENO nahini nrair ho susat ma nanaꞌrenat. ");
INSERT INTO aaz_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mes oras riꞌanaꞌ naan naꞌnae, in of anmoin naꞌroo naꞌko in orif-tataf sin. Natuin in on reꞌ bikaes fui, reꞌ ka nroim fa he natuin aprenat. Sekau-sekau msaꞌ, in nraban sin. Ma areꞌ atoin ein of anraban nafainꞌ ee okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Anneen anrair on naan ate, bi Hagar natenab anbi in nekan, nak, “Au ꞌiit aꞌrair UISNENO, reꞌ In niit ma npanat kau.” Rarit in nmurai nteek Uisneno npaek kanaf, “Usiꞌ reꞌ nfairoir kau.” ");
INSERT INTO aaz_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Etun atoniꞌ nakanab oe mataꞌ naan, Beer Lahai Roi, (reꞌ in aꞌmoufn ii, “Oe mataꞌ naꞌko Usiꞌ Amonit, reꞌ anfairoir kau.”) In baern ee et kuan Kades ma kuan Beret sin atnaank ein. Oras ia, oe mataꞌ naan feꞌ etan. ");
INSERT INTO aaz_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Rarit bi Hagar antebi nfain. Onaim in nahoniꞌ riꞌaan moen jes. Naiꞌ Abram nakanab riꞌanaꞌ naan, naiꞌ Ismaꞌel. ");
INSERT INTO aaz_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Oras bi Hagar nahoniꞌ naiꞌ Ismaꞌel, naiꞌ Abram anmoin naan toon boꞌ fanu mnee (86). ");
INSERT INTO aaz_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Oras naiꞌ Abram anmoin naan toon boꞌ seo mseo (99), UISNENO neem nakriir On neu ne. Onaim In naꞌuab am nak, “Au reꞌ ia Uisneno reꞌ Akuaas Reꞌuf. Ho ro he mutuin Au roimk ii piut, ma mmoin nok neek amneot ma amnonot. ");
INSERT INTO aaz_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au he uhakeꞌ rais manbaꞌan ꞌok ko, ma ꞌmoeꞌ ho sufam-kauꞌm ein amfau-rutun.” ");
INSERT INTO aaz_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Onaim naiꞌ Abram nriꞌtuu ma naꞌruriꞌ tar ntea afu. Rarit Uisneno naꞌuab ankono mnak, ");
INSERT INTO aaz_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Au ꞌmoeꞌ rais manbaꞌan ꞌok ko, on nai: ho of amjair aam uuf meu uuf amfaun. Es naan ate, ho kanam naan ka naiꞌ Abram fa heen (reꞌ in oetn ii nak ‘amaf reꞌ matekaꞌ’), mes naiꞌ Abraham (reꞌ in oetn ii nak ‘aam uuf neu uuf amfaun’). ");
INSERT INTO aaz_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Au of aꞌmoeꞌ ho sufam-kauꞌm ein amfau-rutun. Au of uhakeb uuf namfau uꞌko sin, ma usif amfaun of anpoin ma nboran naꞌko sin. ");
INSERT INTO aaz_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au ꞌnaaꞌ uher-heran rais manbaꞌan ia ꞌok ko ma ho sufam-kauꞌm ein. Rais manbaꞌan ia nabar-baar, natuin Au reꞌ ia, Uisneno ꞌeu ko ma ꞌeu ho sufam-kaꞌum sin. ");
INSERT INTO aaz_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Au of aꞌfee pah Kanaꞌan ok-okeꞌ ꞌeu ko ma ꞌeu ho sufam-kaꞌum sin. Oras ia, ho suma mutua mtaah naah. Mes of ho sufam-kauꞌm ein npaar pah Kanaꞌan ia, tar antea nabar-baar. Ma Au of aꞌjair sin Uisneon goa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Mes ho mok ho sufam-kauꞌm ein ro he mnaaꞌ miher-heran rais manbaꞌan ia. Atoin ein ok-okeꞌ ro he naꞌheir ein. ");
INSERT INTO aaz_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Anmurai oras ia, areꞌ atoniꞌ reꞌ nmoin naan neno faun neiki nsae, ro he naꞌheir ein. Ho mok ho nonot-asar, ho ameupt ein okeꞌ, ho aten reꞌ ho msoos maan sin nbin pah bian, hi arki ro he miꞌheriꞌ. ꞌHeriꞌ naan, anjair tanar nak hit nua kit hit rais manbaꞌan ia mamarak anbi hi aom ein. ");
INSERT INTO aaz_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Atoniꞌ mee ja reꞌ ka naꞌheriꞌ fa te, ka napein fa paaꞌ ma namaꞌ anbi Au rais manbaꞌan, ma ka masoꞌik fa nbi Au too.” ");
INSERT INTO aaz_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Rarit Uisneno ntuut In uaban am nak, “Anmurai oras ia, ho kaisaꞌ mteek amtein ho fee je te mak Sarai, mes mak Saraꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Au of aꞌfee tetus-athoen ꞌeu ain Saraꞌ, he in nahoniꞌ nfee ko riꞌaan moen jes. Tebe! Ain Saraꞌ of anjair ain uuf neu uuf amfaun. Ma usif amfaun of anpoin ma nboran naꞌko in sufan.” ");
INSERT INTO aaz_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Onaim naiꞌ Abraham anriꞌtuu ma naꞌruriꞌ tar antea afu. Mes anbi in nekan naan ee te, in main. In natenab am nak, “Atoni mnais reꞌ-reꞌuf on reꞌ au, toon nautn es, of upein riꞌanaꞌ on mee? Ma ain Saraꞌ reꞌ nmoin toon boꞌ seo goen, ma namnais reꞌ-reuꞌf een amsaꞌ, in bisa nahoniꞌ on mee?” ");
INSERT INTO aaz_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Onaim in nbaiseun Uisneno mnak, “Usiꞌ. Maut he naiꞌ Ismaꞌel es anpaar au pusaak ein. Ka saaꞌ-saaꞌ fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mes Uisneno nataah am nak, “Kahaf! Ho fee bi Saraꞌ of nahoniꞌ riꞌaan moen jes. Ho mukaanb ee, naiꞌ Isak. Au rais manbaꞌan naan of nateab on neu ne, ma neu in sufan-kauꞌn ein, tar antea nabar-baar. ");
INSERT INTO aaz_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Au ꞌneen aꞌrari msaꞌ, saaꞌ reꞌ ho mtoit je meu naiꞌ Ismaꞌel. Es naan ate, Au ꞌfee ne tetus-athoen ma Au ꞌmoeꞌ in sufan-kauꞌn ein namfaun. Aꞌnaak uuf boꞌes am nua of anboran naꞌkon in sufan-kaꞌun sin. Ma in sufan-kaꞌun of anjarin pah kouꞌ goes. ");
INSERT INTO aaz_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maski on naan amsaꞌ, Au rais manbaꞌan ia, nmafuut nok ahaa ho anah naiꞌ Isak. Anmanfain on reꞌ ia te, bi Saraꞌ of nahoins ee.” ");
INSERT INTO aaz_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Naꞌuab anrair on naan ate, Uisneno naneuk Gon naꞌko naiꞌ Abraham. ");
INSERT INTO aaz_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Neno naan amsaꞌ, naiꞌ Abraham nmoeꞌ natuin Uisneno In aprenat. Onaim in naꞌheriꞌ. Rarit in naꞌheriꞌ naiꞌ Ismaꞌel, ma atoin ein abitan in uim je nanan. In naꞌheriꞌ atoin aten amsaꞌ. Oras naan naiꞌ Abraham anmoin naan toon boꞌ seo mseo (99), ma naiꞌ Ismaꞌel toon boꞌes am teun (13). ");
INSERT INTO aaz_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Oors es, naiꞌ Abraham natua npaumaak hau kouꞌ guin Mamre. UISNENO neem ma nakriir On neu ne. In reetn ii on nai: neno naan, maans ee mapuutn ii kah een, onaim naiꞌ Abraham ntook ma nmainenu nbi in teens ee in enon. ");
INSERT INTO aaz_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Oras naiꞌ Abraham nait matan on naan ate, in niit tuaf teun nhaken nbin naan. Onaim in naen anseun sin. In nriꞌtuu, ");
INSERT INTO aaz_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ma in naꞌuab neu sin am nak, “Sin aam ein! Karu reko te, au uskau he tkoen nok teem teu hi ate kau au tenas ia. Maski mbukae oe ruum-ruum ahaa msaꞌ, reko tua. ");
INSERT INTO aaz_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Sin amaꞌ ki arki misnaas akreꞌo mbi haun guin sin maofk ein. Maut he au aten sin neikin oe ma nafaun ki. ");
INSERT INTO aaz_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Au ꞌnao ubarab bukae ꞌeu ki, maut he hi mipein haꞌtanis akreꞌo, henaꞌ hi mkoen om amkoon. Au ꞌmariin, he ꞌtuthae ꞌaan ki, tua.” Rarit sin natahan am nak, “Reko, tua. Hai meis mok naan, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Rarit naiꞌ Abraham naen antaam neu tenas naan, ma natonan bi Saraꞌ mnak, “Rabah! Mait maan uut arekot, sauk goes. Ammoeꞌ maan kit utunuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Rarit in naen neu in bijae ngguin, ma npiir naan bijae apokat aan es. In nreun in ameupt es he nroor goe ma nahaan in sisin. ");
INSERT INTO aaz_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Rarit naiꞌ Abraham annao nait susu, suus aritas, ma siis hanaꞌ reꞌ feꞌ nahaan anrair je, rarit in neik sin neu amneem feꞌun naan. Oras sin nbukaen ate, in nhake nbi hau goes uun ma ntuthae sin. ");
INSERT INTO aaz_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Onaim sin nataan ee mnak, “Abraham! Ho fee bi Saraꞌ et mee?” Rarit in nataah am nak, “Et teens ee naan ee, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Onaim tuaf es naꞌko sin teun ein naan naꞌuab am nak, “Of anmanfain on reꞌ ia te, Au ꞌfain ꞌuum. Oras naan, ho fee bi Saraꞌ of nahoniꞌ nrair riꞌaan moen jes.” Oras sin naꞌuab ein on naan ate, bi Saraꞌ nneen naꞌko eonꞌ ee ꞌkain. ");
INSERT INTO aaz_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Oras naan, naiꞌ Abraham ma bi Saraꞌ sin namnasin reꞌ-reuꞌf een. Bi Saraꞌ ka napeni ntein fa funan. ");
INSERT INTO aaz_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Anneen sin uabk ein on naan ate, bi Saraꞌ nmain neek aah. In natenab am nak, “Hmmh! Au umnais reꞌ-reuꞌf een. Saaꞌ anteniꞌ, au moen je nmaꞌnuur reꞌ-reuꞌf een. Nok ranan mee kah, he hai aom ein anmonin on reꞌ amatsao feuꞌn ee, he mipein anah?” ");
INSERT INTO aaz_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rarit UISNENO nataan naiꞌ Abraham am nak, “Nansaaꞌ am es bi Saraꞌ nmain? In natenab nak aiꞌ saaꞌ reꞌ Au uꞌuab ee ia of ka njair fa, natuin in namnasi, oo? ");
INSERT INTO aaz_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au reꞌ ia, UISNENO! Ka tiit tain fa saaꞌ es reꞌ Au ka bisa ꞌmoeꞌ je fa. Mumnau murek-reok, oo! Karu Au ꞌfain ꞌuum toon amnemat, bi Saraꞌ of nahoniꞌ nrair riꞌaan moen jes.” ");
INSERT INTO aaz_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Anneen on naan ate, bi Saraꞌ namtau. Rarit in npeen mates am nak, “Au ka ꞌmain kuuk fa, tua!” Mes Uisneno nataah am nak, “Feꞌe na ho mmain batuur ate.” ");
INSERT INTO aaz_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Rarit tua teun ein naan nnaon nkonon neun kota Sodom. Naiꞌ Abraham annao nasain sin ntean raan atnanaꞌ. Antean naan ate, sin napeen niit kota Sodom. ");
INSERT INTO aaz_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Rarit UISNENO natenab am nak, “Reko nneis, Au utoon ꞌeu naiꞌ Abraham am ꞌak, Au he ureuꞌ kota Sodom. ");
INSERT INTO aaz_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Natuin naiꞌ Abraham in suufk ein of nmaꞌbaab ok tar namfaun, ma njarin uuf es, reꞌ maꞌtaniꞌ. In of anjair amneik tetus-athoen amsaꞌ neu areꞌ kanan uuf anbi pah-pinan ia. ");
INSERT INTO aaz_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Au ꞌpiri ꞌrair je, he in nanoniꞌ in aanh ein ma tuaf bian antein, he natuin UISNENO In raan ee piut, ma nmonin nok neek amneot ma amnonot. Karu sin nmoꞌen on reꞌ naan ate, Au rais manbaꞌan ꞌeu sin of nateab on.” ");
INSERT INTO aaz_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Onaim UISNENO naꞌuab neu naiꞌ Abraham am, nak “On nai! Au ꞌneen aꞌrair too mfaun ein nsakoinaꞌ abitan kota Sodom ma kota Gomora sin maufiunk ein. Sin baiseek ein een. ");
INSERT INTO aaz_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Etun Au ꞌsaun ꞌuum, he ꞌiit nok Au matak ma uhiin areꞌ saaꞌ-saaꞌ reꞌ Au ꞌneen sin naan, batuur, aa oo, aiꞌ kaah. Karu kaah fa te, Au of uhini msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Oras UISNENO feꞌ naꞌuab nok naiꞌ Abraham, tua nuaꞌ ein naan sin nnaon nkonon neun kota Sodom. ");
INSERT INTO aaz_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Naiꞌ Abraham nsiriꞌ npaumak-maak Uisneno, rarit in nbaisenu ntaabr Ee mnak, “Koi, Aam Usiꞌ! On mee? Ho he mureuꞌ atoin reko ma atoin reꞌuf no meseꞌ nani, oo? ");
INSERT INTO aaz_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Karu nmuiꞌ tua reko boꞌ niim (50) nbin kota naan, Ho he mureuꞌ sin okeꞌ msaꞌ, aa oo? Aiꞌ Ho ka mureuꞌ fa kota naan, natuin Ho mneek sin. ");
INSERT INTO aaz_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aam Usiꞌ! Kaisaꞌ mmoeꞌ on naan! Kais-kaisaꞌ atoin rekon naan nmaten amsaꞌ, oras Ho mureuꞌ atoin maufinus sin. Aam Usiꞌ, Ho es amjair Afeek Rasi et neno tunan ma pah-pinan. Es naan ate, Ho meikn Om muhiin mak reꞌ naan ka namneo fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","UISNENO nataah am nak, “Karu Au upein tua reko boꞌ niim anbin kota Sodom, Au ka ꞌhukun fa kota naan, natuin Au ꞌneek sin.” ");
INSERT INTO aaz_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Naiꞌ Abraham naꞌuab anteniꞌ mnak, “Aam Usiꞌ. Kais mutoꞌon kau, tua. Reko te, au he uꞌuab aꞌteniꞌ. Au reꞌ ia suma mansian amonot. Au ka uhiin fa saaꞌ-saaꞌ, tua. ");
INSERT INTO aaz_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Taretaꞌ, karu ka ntea fa tua reko boꞌ niim, mes suma tuaf boꞌ haa mniim aah, on mee, tua? Karu nkuurn ahaa tuaf niim ate, on mee? Ho he mureuꞌ kota naan feꞌe, oo?” Uisneno nataah am nak, “Karu Au upein tua reko boꞌ haa mniim anbin kota naan, Au ka ꞌeu he ureuꞌ goe fa.” ");
INSERT INTO aaz_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Rarit naiꞌ Abraham antabar anteniꞌ mnak, “Karu suma tua reko boꞌ haa te, on mee, Aam Usiꞌ?” In nataah am nak, “Karu Au upein tua reko boꞌ haa, Au ka ꞌhukun sin fa.” ");
INSERT INTO aaz_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Naiꞌ Abraham naꞌsitiꞌ ntein am nak, “Aam Usiꞌ, kais mutooꞌ, tua. Mes karu suma tua reko boꞌ teun goah, on mee, tua?” In nataah nak, “Karu Au upein tua reko boꞌ teun, Au ka ꞌhukun sin fa.” ");
INSERT INTO aaz_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Rarit naiꞌ Abraham naꞌsitiꞌ anteniꞌ mnak, “Aam Usiꞌ, kais mutooꞌ, tua. Au he utaan aꞌteniꞌ kreꞌo. Karu suma tua reko boꞌ nua goah, on mee, tua?” In nataah antein am nak, “Karu nmuiꞌ tua reko boꞌ nua, Au ka ꞌeu fa he ꞌhukun kota naan.” ");
INSERT INTO aaz_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Naiꞌ Abraham nasoup in haan totis am nak, “Aam Usiꞌ. Au uꞌsitiꞌ haef es anteniꞌ, mes kais mutoꞌon kau, tua. Karu suma nmuꞌi haa tua reko boꞌes, on mee, tua?” In nataah amsaꞌ am nak, “Karu Au upein tua reko boꞌes anbin naan, Au ka ureuꞌ fa kota naan.” ");
INSERT INTO aaz_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Naꞌuab anrair on naan ate, UISNENO nnao nkoon. Onaim naiꞌ Abraham antebi nfain. ");
INSERT INTO aaz_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Oras Uisneno feꞌ naꞌuab nok naiꞌ Abraham, In ameupt ein reꞌ tua nuaꞌ ein naan, annaon nkonon neun kota Sodom. Sin ntean ne te, maans ee he noi nmouf goen. Oras naan, naiꞌ Rot feꞌ ntoko nbi enoꞌ he ttaam teu kota naan. In niit tua nuaꞌ ein naan ate, in nnao nseun sin. In nriꞌtuu ma naꞌruriꞌ nbi sin maatk ein. ");
INSERT INTO aaz_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Rarit in naꞌuab am nak, “Sin amaꞌ arki! Au uskau ki he mkoen om iim meu au uim je feꞌ, tua. Maut he hi mifaun ma mtuup maan fai jes ambi ia. Nneis noi nmeu te, naꞌ hi mnao mkoon, tua.” Mes sin natahan am nak, “Makasi, tua. Mes ho kais muhaeb om! Maut he hai mtuup ambi kota ia in amneran.” ");
INSERT INTO aaz_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mes naiꞌ Rot anfuriꞌ sin piut, tar antea sin nromin he ntuup antaahn ein anbin in umi. Onaim naiꞌ Rot sin ntunun utunuꞌ, ma nabaarb ein bukae, ma sin nbukaen buꞌ-buaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Oras sin feꞌ ka ntupan fa feꞌe te, atoin ein Sodom, anaꞌ-koꞌu neman okeꞌ. Sin nhaken nfuun naan naiꞌ Rot in umi. ");
INSERT INTO aaz_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Sin nhuun ein ma nakan naiꞌ Rot tafiꞌ-tafiꞌ am nak, “Hoe, Rot! Atoin nuaꞌ ein feꞌe na, etan mee? Mupoit sin neman, hai he miꞌbabiꞌ sin!” ");
INSERT INTO aaz_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Onaim naiꞌ Rot anpoi, rarit naꞌeek enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","In naꞌuab am nak, “Aok-bian arki! Hi kaisaꞌ mmoeꞌ reꞌuf on naan meu au tamun ia. ");
INSERT INTO aaz_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Bait hi mneen feꞌ! Au aan feotn ii, tuaf nua. Sin muin rek-rekon, ma ao ꞌtemef feꞌ. Maut he au ꞌnonaꞌ ki sin. Hi he minsaaꞌ sin imsaꞌ, es reꞌ hi. Mes hi kaisaꞌ mmoeꞌ saaꞌ-saaꞌ meu au tamun ia. Tatuin hit haart ii te, au ro he ꞌpanat sin.” ");
INSERT INTO aaz_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mes atoin Sodom sin nkoaꞌ ein am nak, “Ho kaisaꞌ mseor mok! Ho atoin amnemat. Ho atoin sonaꞌ. Onaim ho ka mmuiꞌ fa hak he mꞌator kai. Reko nneis ho muꞌroo muꞌko bare ia. Karu kaah fa te, hai mmoeꞌ reꞌuf meu ko, anneis naꞌko meu tua nuaꞌ ein naan!” Rarit sin ntitar ma nsapar napasib naiꞌ Rot. Ma sin arsin buꞌ-buaꞌ nnaon he ntuut nareuꞌ enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mes taum nuaꞌ ein naan, nsoron napoitan sin aꞌniimk ein ma nheer nataam naiꞌ Rot neu uim je nanan, ma sin naꞌseniꞌ enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Rarit sin naforob atoin Sodom reꞌ abitan enoꞌ, etun sin nabre-reon goah he namin enoꞌ. Mes sin ka niit ee fa. ");
INSERT INTO aaz_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Rarit taum nuaꞌ ein naan, nak naiꞌ Rot am nak, “Rot! UISNENO nahini nrair abitan kota ia sin maufinun. Onaim In nreek kai he iim mireuꞌ main kota ia. Onaim ho mmuꞌi mteniꞌ asar bian et kota ia, aiꞌ kaah? Karu nmuiꞌ aan mone, aan feto, aan nanef, aiꞌ sekau-sekau. Meik sin ampoi nai miꞌko kota ia!” ");
INSERT INTO aaz_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Onaim naiꞌ Rot annao naꞌuab nok atoin munif nua reꞌ nafrei in aan feotn ee, mnak, “Amneen mirek-rekoꞌ! Oras ia, maen ampoi rabah miꞌko kota ia nai! Natuin UISNENO he nareuꞌ niis kota ia!” Mes sin nateenb ein nak aiꞌ naiꞌ Rot napoi. ");
INSERT INTO aaz_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Neis noi nmeu te, Uisneno In ameupt ein naan, naꞌsekeꞌ naiꞌ Rot sin he naen anpoin rab-raab nai. Sin naꞌuab ein am nak, “Rot! Amfeen nai! Meik ho fee, ma ho aan feot nuaꞌ ein naan, maen ampoi misaitan kota ia nai. Kais-kaisaꞌ hi mmaet ruum-ruum, ma mimreuꞌ buaꞌ-buaꞌ mok kota ia.” ");
INSERT INTO aaz_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mes naiꞌ Rot feꞌ he naꞌeokb on. Te kaah, amneon ii, UISNENO he nsoi nafetin naan ee. Etun es taum nuaꞌ ein naan ansaok naan naiꞌ Rot in aꞌniman, in fee, ma in aan feot nuaꞌ ein naan, he napoitan sin naꞌkon kota naan. ");
INSERT INTO aaz_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Onaim tuaf es naꞌko reꞌ taum nuaꞌ ein naan, nak, “Maen miheer, he mmoin! Kaisaꞌ mniik! Kais misnaas ambi mneraꞌ! Maen amsae meu ꞌtoꞌef nee he hi mmoin!” ");
INSERT INTO aaz_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mes naiꞌ Rot nataah am nak, “Koi, aam! Kais on naan, tua! ");
INSERT INTO aaz_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ho mturun kai he hai mmoin. Mes aꞌtoꞌef nee, naꞌroo! Kais-kaisaꞌ hai ka mtea maan fa nee te, amreuꞌt ii napein kai nbi raan atnanaꞌ, tua. ");
INSERT INTO aaz_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Amkius miit. Anmuiꞌ naan kuan aan es ka naꞌroo fa naꞌko ia. Kuan reꞌ nee, ka matekaꞌ fa, natuin in aanꞌ-anaꞌ. Onaim karu ho mromi te, maut he hai mꞌain naa, henaꞌ hai mmoin, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Onaim in nataah am nak, “Reko! Amnao nai! Au of ka ureuꞌ fa kuan reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Oras ia, hi maen nai meu kuan naan! Natuin au of ka ꞌmoeꞌ saaꞌ-saaꞌ fa feꞌ, karu hi ka mtea fa feꞌ.” Anmurai naꞌko oras naan, atoniꞌ nteek kuan naan nak, Soar, reꞌ in aꞌmoufn ii nak ‘anaꞌ’. ");
INSERT INTO aaz_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Oras maans ee nsae te, naiꞌ Rot sin ntean Soar. ");
INSERT INTO aaz_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nok askeken, UISNENO nꞌopaꞌ uur-ai ma bariri reꞌ anpiin, ansaun neem naꞌko neno neu kota Sodom ma kota Gomora. ");
INSERT INTO aaz_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","UISNENO nout nakratiꞌ koat ein naan ok-okeꞌ ma kuan ein reꞌ anbin bare naan, ma areꞌ kanan amonit, et mansian, muꞌit, ma hau anbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Oras naiꞌ Rot sin naenan, in fee je, anniik. Nok askeken ate, in njair nii masik. ");
INSERT INTO aaz_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nokaꞌ kik-kiku te, naiꞌ Abraham anfani nteniꞌ neu bare reꞌ afi naa in nhake ma ntabar UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Onaim in napene nsaun neu Sodom ma Gomora ma karopu mneer koꞌu naan okeꞌ. In nkisu te, maus ein nsaen on neon goe kboꞌes-akboꞌes anbi mee-mee. Ma ai pinaꞌ naan nout niis areꞌ saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Onaim oras Usiꞌ nout nakrat-ratiꞌ koat ein naan, In namnau In rais manbaꞌan neu naiꞌ Abraham. Etun In nturun ma napoit naiꞌ Rot naꞌko bare reꞌ In nareuꞌ goe naan. ");
INSERT INTO aaz_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Oras naan, naiꞌ Rot namtau he natua nabaar anbi kuan Soar. Es naan ate, in nok in aan feot nuaꞌ ein naan, nanain ein neun aꞌtoꞌef. Rarit sin natuan nbin nuat es. ");
INSERT INTO aaz_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Neot es, in aan feot unu, nak in oirf ee mnak, “Anbi bare ia, nfuun am nateef ka tiit-tiit fa atoniꞌ he nsao kit. Ma ka ꞌroo fa te, hit amaꞌ namnais kuun een, ma ka namsaꞌi ntein fa heen. ");
INSERT INTO aaz_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Onaim reko nneis, hit tamauf hit amaꞌ. Rarit hit ttuup tokn ee. Maut he hit tamsaꞌib hit amaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Fain ite, sin naꞌinuꞌ sin aamf ee nok tua min-kase, tar anmafu nmaet. Rarit feot uun ee nnao ma ntuup nok in amaf. Mes aꞌnaef ee nmafu nmaet, onaim in ka nahiin fa neu in nmoeꞌ saaꞌ nok in aan feto. ");
INSERT INTO aaz_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Anmeu nfiin ite, feot unu naan, natoon neu in oirf ee mnak, “Fiin ii na, au ꞌtuup aꞌrair ꞌok hit amaꞌ. Mabeꞌ ia, ho sapaam. Hit tamafu ttein hit amaꞌ, rarit ho mtaam amtuup mok ne. Nok ranan naan, hit nua kit of tahoniꞌ ma ttaur hit amaꞌ in sufan.” ");
INSERT INTO aaz_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mabeꞌ naan, sin namafu nteniꞌ ꞌnaef. Rarit aan feot aheit susu, nnao ma ntuup nok in amaf. Mes aꞌnaef ee nmafu nmaet, onaim in ka nahiin fa neu in nmoeꞌ saaꞌ nok in aan feto. ");
INSERT INTO aaz_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nok ranan naan, sin nua sin naꞌaup ein naꞌkon sin aam honif. ");
INSERT INTO aaz_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Rarit naiꞌ Rot in aan feot unu nahoniꞌ riꞌaan moen jes. Feot unu naan nakanab in anah naan, naiꞌ Moap (reꞌ he noi humaꞌ meseꞌ on reꞌ kata es anteniꞌ, in aꞌmoufn ii ‘neem naꞌko amaꞌ’). In es reꞌ njair aam uuf neu atoin Moapas oras ia. ");
INSERT INTO aaz_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Rarit aan feot aheit suus goe, nahoniꞌ riꞌaan moen jes. In nakaanb ee, naiꞌ Ben Ami (in aꞌmoufn ii ‘riꞌanaꞌ naꞌko au nggoa’). In es anjair aam uuf neu atoin Amonas sin oras ia. ");
INSERT INTO aaz_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Rarit naiꞌ Abraham nananiꞌ naꞌko Mamre, nnao neu pah Negep et pasaꞌ haaꞌ-nua. In natua nbi kuan Kades ma kuan Sur sin atnaank ein. Mes ka ꞌroo fa on naan ate, in natnani ntein neu kuan Gerar. ");
INSERT INTO aaz_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ma in natonan abitan kuan naan am nak, ain Saraꞌ naan, in fetof. Es naan ate, naiꞌ Abimerek, usif Gerar, nreek tuaf ma ntaam antoit bi Saraꞌ. Rarit sin neik je neu uisf ee in sonaf. Rarit UISNENO nasnasab bifee ahoniꞌ ma nakiubaꞌ bifee munif, naꞌko usif Abimerek in too ngguin, natuin in ntoup naan naiꞌ Abraham in fee. ");
INSERT INTO aaz_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Fai jes, Uisneno nakriir On anbi mneit neu usif naan. In naꞌuab am nak, “Ho he mmaet een! Natuin ho mtoup maan atoniꞌ in fee!” ");
INSERT INTO aaz_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Mes naiꞌ Abimerek nataah am nak, “Usiꞌ! Au ka ꞌreꞌ-reoꞌ ꞌiit fa bifee naan. Ma au ka ꞌsaan fa msaꞌ. Naiꞌ Abraham neikn on natoon am nak, in fetof! Bifee naan anmanakuꞌ on reꞌ naan amsaꞌ. Es naan ate, au ꞌreek tuaf ma ntaam antoit je nok neek akninuꞌ. Onaim Usiꞌ kais musaan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Onaim Uisneno nataah am nak, “Batuur. Au uhiin ꞌak ho nekam naan kninuꞌ. Ma Au es reꞌ aꞌkaheꞌ ko he kaisaꞌ mreoꞌ bifee naan. Nok ranan naan ate, ho ka musanab fa meu Kau. ");
INSERT INTO aaz_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Oras ia, mnonaꞌ mufaniꞌ bifee naan meu in mone. Atoniꞌ reꞌ naan, Au mafefa kninuꞌ. Onaim amtoit je he nꞌonen henatiꞌ ho kaisaꞌ mmaet. Mes karu ho ka mnonaꞌ mufaniꞌ fa bifee naan, ho mumnau murek-rekoꞌ! Ho mok ho too ngguin of anmaet sapuꞌ-sapuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kik-kiku te, uisf ee noꞌen in ameupt ein okeꞌ, ma naretaꞌ in amneit naan. Onaim sin arsin namtaun. ");
INSERT INTO aaz_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Rarit uisf ee noꞌen naiꞌ Abraham, ma nataan ee mnak, “Au ꞌtao ꞌsaan ko saaꞌ, es ho mmoeꞌ he hai msiraak om? Ho kais mupoi on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ho mutenab saaꞌ, es ho mmoeꞌ on reꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Onaim naiꞌ Abraham nataah am nak, “Aam usiꞌ! Au ꞌbaiseun. Au utenab ꞌak hi ar-arki ka mihiin fa Uisneno. Onaim hi of miꞌmaet kau, he msao au fee. ");
INSERT INTO aaz_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Au uꞌuab batuur, ꞌak bi Saraꞌ naan au fetoꞌ. Hai nua kai amaꞌ meseꞌ, mes es-es ate miꞌain kiim. Es naꞌ hai matsao on reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Onaim oras Uisneno nreek kai he mpoi miꞌko hai kuan, ma mnao miꞌroo-ꞌroo meu kua-ꞌtetaꞌ, au utoon ain ꞌeu au fee ji mꞌak, ‘Hit tbi mee-mee jah, karu atoniꞌ natanan anmatoom nok hit nua kit, ma karu ho mneek kau te, mutaah am mak, hit meu fetof-naof.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Rarit usif Abimerek nnonaꞌ nafani bi Saraꞌ. Onaim in naꞌuab nok bi Saraꞌ mnak, “Oras ia, au ꞌbaen roi mutiꞌ fuaꞌ niuf goes ꞌeu ho naꞌo, he njair tanar am nak, au ka ꞌsaan fa saaꞌ-saaꞌ ꞌeu ko. Maut he aar pah ii nahinin on reꞌ naan!” Rarit uisf ee naꞌuab neu naiꞌ Abraham am nak, “Abraham! Au pah ii mainuan neu ko. Ho mroim he mutua mbi mee-mee jah, es reꞌ ho.” Rarit in nfee ne bijae, ꞌbibi, ma ꞌbib-kase. In nfee ne ate msaꞌ, et atoniꞌ ma bifee. ");
INSERT INTO aaz_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Oras uisf ee nnonaꞌ nafaniꞌ bi Saraꞌ neu in mone, naiꞌ Abraham anꞌonen he Uisneno nfei bifeen ngguin naan sin ꞌaupk ein. Ma sin bisa nahoin ein antenin. ");
INSERT INTO aaz_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Rarit UISNENO nateabaꞌ neu ain Saraꞌ saaꞌ reꞌ In nbaꞌan anrair je. Naiꞌ Abraham namnais jen, mes ain Saraꞌ naꞌapuꞌ. Oras in he nahoniꞌ, naiꞌ Abraham anmoin naan toon nautn es (100). Antea in oors ate, in nahoniꞌ riꞌaan moen jes. Rarit naiꞌ Abraham nakanab riꞌanaꞌ naan, naiꞌ Isak (reꞌ in aꞌmoufn ii ‘in main’). Rarit ain Saraꞌ naꞌuab am nak, “Uisneno nmoeꞌ kau he ꞌmain, natuin oras ia au ꞌmariin. Biak ein nateenb ein, au ka neu he uhoniꞌ fa ꞌbi oras au umnais on reꞌ ia. Te kaah, amneon ii, maski au moen je namnais reꞌ-reuꞌf een, mes au feꞌ uhoniꞌ ꞌaan ne riꞌaan es. Onaim oras ia, sekau-sekau reꞌ anneen rasi ia te, sin of anmanin on reꞌ au msaꞌ.” Oras in nmoin naan neno faun, naiꞌ Abraham naꞌheriꞌ naiꞌ Isak, natuin Uisneno In aprenat. ");
INSERT INTO aaz_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Rarit naiꞌ Isak naꞌnae. Oras sin he nsoer je te, amaf naiꞌ Abraham nmoeꞌ fesat koꞌu. ");
INSERT INTO aaz_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Neot es, ain Saraꞌ nkius niit naiꞌ Abraham in fee muniꞌ ain Hagar in anah naiꞌ Ismaꞌel anmabuir nok naiꞌ Isak. Onaim ain Saraꞌ naꞌuab neu in moen je mnak, “Amriuꞌ mupoitan ate naꞌko Masir naan nok in anah! Natuin au ka ꞌroim fa he aet je in aanh ee napein pusaak saaꞌ-saaꞌ. Maut he au anah naiꞌ Isak anmees es reꞌ anpaar nain pusaak ein okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Anneen ain Saraꞌ in uaban naan ate, naiꞌ Abraham nnaben ate ka reko fa, natuin naiꞌ Ismaꞌel naan, in aanh aa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mes Uisneno naꞌuab neu naiꞌ Abraham am nak, “Abraham! Ho kais mutenab ho fee muin aan nok in aanh aan. Mutuin ain Saraꞌ in roim naan. Natuin Au ꞌbaꞌan aꞌrair ꞌak ho of musuuf muꞌko naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mes Au ꞌfee tetus amsaꞌ ꞌeu ho fee muniꞌ naan in anah. Natuin in ho sisim ho naam amsaꞌ. In suufk ein of anjarin uuf es.” ");
INSERT INTO aaz_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nokaꞌ kik-kiku on naan ate, naiꞌ Abraham nabarab oe-betiꞌ neu ain Hagar, ma nasniinb ee oe nbi baer es, reꞌ anmoeꞌ je naꞌko pasu. Rarit in nafetin bifee naan ma in anah he nnaon nmesen. Rarit sin nnaon nfuun baer ruman anpaumaak Beer Seba. ");
INSERT INTO aaz_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Oras sin oe mniun ee okeꞌ te, ain Hagar nasaitan riꞌanaꞌ naan anbi hau aan es in mafon. ");
INSERT INTO aaz_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Onaim in natenab am nak, “Karu in natfeek am au ꞌhak-hake te, au neek ii nsuus anmaet.” Rarit in ntet-koit, ma nnao ntook seor naꞌroo naꞌko riꞌanaꞌ naan of oniꞌ meter boꞌ niim. Rarit in nkae nmeꞌ-meꞌur. ");
INSERT INTO aaz_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Uisneno nneen naiꞌ Ismaꞌel ankae msaꞌ, rarit In ameupt es neem naꞌko sonaf neno tunan, ma nhaman ain Hagar am nak, “Hagar! Nansaaꞌ am es ho msuus on reꞌ naan? Kais mumtau, Uisneno nneen anrair ho aanh ee in kaet. ");
INSERT INTO aaz_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Oras ia, mfeen ma mnao mkius riꞌanaꞌ naan. Amhaan mau goe ma mhaꞌtain in nekan, natuin Au of aꞌmoeꞌ in sufan sin anjarin too uuf maꞌtain es.” ");
INSERT INTO aaz_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Rarit Uisneno nfei ain Hagar in maatk ein, ma in niit oe maat es anbi naan. Onaim in neik baer oe, ma nnao nakain oe, rarit in neik je ma naꞌinuꞌ riꞌanaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Onaim naiꞌ Ismaꞌel nok in ainaf natuan nbin baer ruman Paran. Naꞌko neno neu neno, in naꞌnae, ma in njair atoin akrao reok goes. Rarit in ainf ee nasaob ee nok bifee muinf es naꞌko pah Masir. Rasin ia njarin, natuin Uisneno nok naiꞌ Ismaꞌel. ");
INSERT INTO aaz_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Oras naan, usif Abimerek, nok in meo paeꞌ makenat, naiꞌ Fikor, neman ma natefan nok naiꞌ Abraham. Usif naan naꞌuab am nak, “Abraham! Hai mihiin mak Uisneno nok ko. Etun ho mmoeꞌ saaꞌ-saaꞌ aah, ro he njarin on naan. ");
INSERT INTO aaz_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Onaim oras ia, au ꞌtoit ko he msuup ambi Uisneno In matan, mak ho of ka mputa-kriu kau fa, ꞌok au anah-upuf sin ok-okeꞌ. Natuin au ꞌmoeꞌ reko ꞌok ko, es naan ate ho ro he mmoeꞌ reko mok kau nbi pah ia msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Onaim naiꞌ Abraham nataah am nak, “Reko, tua! Au ꞌsuup.” ");
INSERT INTO aaz_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mes rarit naiꞌ Abraham natraak neu usif naan am nak, “Aam usiꞌ, ho too ngguin nasiik naan au oe maat hain es.” ");
INSERT INTO aaz_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Anneen on naan ate, usif naan nataah am nak, “Ahh! Au feꞌ aꞌneen rasi ia. Nansaaꞌ am es ho ka mutoon fa naꞌko af-afi naa? Au ka uhiin fa neu sekau es anmoeꞌ on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Rarit naiꞌ Abraham ma naiꞌ Abimerek nmoꞌen rasi tfekaꞌ. Naiꞌ Abraham nait bijae ma ꞌbib-kase ma nfee sin neu usif. Rarit in npiir intein ꞌbib-kaes tipuꞌ manaꞌ hiut. ");
INSERT INTO aaz_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Rarit uisf ee nataan ee mnak, “Nansaaꞌ am es ho mmoeꞌ on naan?” ");
INSERT INTO aaz_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","On nai te, naiꞌ Abraham natoon am nak, “Aam usiꞌ. Amtoup aꞌbib-kaes tiup ein ia, he njarin tanar nak aam usiꞌ ho mmanakuꞌ mak au es aꞌhain oe haniꞌ reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Natuin sin nua sin nmoꞌen nrarin rasi tfekaꞌ nbin bare naan, es naꞌ sin nakanab bare naan Beer Seba. In aꞌmoufn ii nak ‘Oe ꞌHain Supat’. ");
INSERT INTO aaz_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Sin nsupan nrarin on naan ate, usif naiꞌ Abimerek nok in meo paeꞌ je nfanin on sin pah Filistin. ");
INSERT INTO aaz_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Rarit naiꞌ Abraham nseen hau tamareska uuꞌ goes nbi Beer Seba. Anmurai naꞌko oras naan, hau naan anjair tanar amnaubaꞌ neu naiꞌ Abraham, nak in naꞌbees neu UISNENO reꞌ Amonit Nabar-baar anbi bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Rarit naiꞌ Abraham natua on reꞌ anao-amnemat tar aꞌroo nbi atoin Filistinas sin pah. ");
INSERT INTO aaz_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Neot es ate, Uisneno nsuuꞌ naiꞌ Abraham, he nahiin nak in natniin Ee, aiꞌ kaah. Rarit In nhaamn ee mnak, “Abraham!” Onaim in nataah am nak, “Au es ia, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Rarit Uisneno nreun goe mnak, “Amneen murek-rekoꞌ! Mait ho aan moen meseꞌ reꞌ ho mneek miis ne naan. Meik je mnao meu pah Moria, he mout goe njari fuaꞌ-turuꞌ neu Kau. Amtea ne te, Au of naꞌ ukriraꞌ ko in baran et aꞌtoeꞌf es.” ");
INSERT INTO aaz_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Anmeu nfini te, naiꞌ Abraham ankeut hau metoꞌ. Rarit anfuut sin, ma nasaeb sin anbin bikaes keledai. Rarit in nok naiꞌ Isak, ma in ameput tuaf nua nnaon neu bare reꞌ Uisneno nteek ee naan. ");
INSERT INTO aaz_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sin nnaon neno nua goen. Ma nmeu te, naiꞌ Abraham napeen niit bare naan anbi ꞌroo. ");
INSERT INTO aaz_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Onaim in nak neu in tua ameup nuaꞌ ein naan am nak, “Hi nua ki mpao kai mbi ia, mok bikaes keledai ngguin! Au ꞌok au anah ia, meiki-msae meu ne, he mꞌonen ma miꞌbees meu Uisneno. Rarit of hai mfain iim meu ia.” ");
INSERT INTO aaz_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Rarit naiꞌ Abraham nait hau meot ein naan, ma nasahab naiꞌ Isak sin. Ma in nnaaꞌ neik besi ma ai nutaꞌ amsaꞌ. Oras sin nua sin nnaon buꞌ-buaꞌ ate, ");
INSERT INTO aaz_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","naiꞌ Isak nak in aamf ee mnak, “Aam!” Rarit naiꞌ Abraham nataah am nak, “Saaꞌ, Isak?” Onait naiꞌ Isak nataan am nak, “Aam, hit he totu ꞌturuꞌ. Hit teik hau metoꞌ nok ai. Mes aꞌbib-kase reꞌ he taꞌtuur ee ji, es mee?” ");
INSERT INTO aaz_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Naiꞌ Abraham nataah am nak, “Isak! Uisneno of neikn On anfee In aꞌbib-kaes anaꞌ he njari ꞌturuꞌ.” Onaim sin nua sin neiki nsaen piut. ");
INSERT INTO aaz_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Oras sin ntean bare reꞌ Uisneno nakriraꞌ nrair je naan, naiꞌ Abraham anbaik fatu he nmoeꞌ mei ꞌturuꞌ. Rarit in nꞌator hau meot ein anbin mei naan. Onaim in nfuut in aanh ee, natupaꞌ natneenb ee nbi hau meot ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Onaim in nait besi he nroor in anah. ");
INSERT INTO aaz_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mes nok askeken ate, UISNENO In ameput ankoaꞌ naꞌko neon goe mnak, “Hoe! Abraham! Kaisaꞌ feꞌ! Ampao kreꞌo feꞌ!” In nataah am nak, “Nansaaꞌ, Usiꞌ?” ");
INSERT INTO aaz_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Onait hanaf naan nak, “Kais amroor riꞌanaꞌ naan! Kais munsaaꞌ-saaꞌ ne! Oras ia Au uhiin namneo, ꞌak ho ro batuur-batuur mutuin Uisneno In romin, es naꞌ ho mubarab murair he mufuat ho aan moen meseꞌ naan neu Ne.” ");
INSERT INTO aaz_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Rarit naiꞌ Abraham niit aꞌbib-kaes keos goes, reꞌ in suunk ein naꞌheeb ok nbin hau aan es in taek ein. Rarit naiꞌ Abraham nnao nheke ꞌbib-kase naan, ma nout goe njari ꞌturuꞌ neu Uisneno, nsekaꞌ in anah. ");
INSERT INTO aaz_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Onaim naiꞌ Abraham nakanab bare naan Yehova Yire, (reꞌ in aꞌmoufn ii, ‘Uisneno of nabarab saaꞌ reꞌ hit tperluu’). Etun antea oras ia msaꞌ, biak ein naꞌuab ein am nak, “Anbi ꞌtoꞌef UISNENO naan, In of nabarab saaꞌ reꞌ hit tperluu.” ");
INSERT INTO aaz_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Rarit ameput Uisneno naan nkoaꞌ ntein naꞌko neon goe mnak, ");
INSERT INTO aaz_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“UISNENO neikn On nak, ‘Au ꞌsuup ꞌeik Au kanak, on nai: ho mubarab murair he mfee Kau ho aan fua meseꞌ naan, he njari fuaꞌ-turuꞌ. Es naan ate, ");
INSERT INTO aaz_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Au of aꞌfee tetus nathoe ꞌeu ko ma ꞌeu ho sufam-kaꞌum sin. Sin of anmasaot-baban piut, tar antea ka tsoiꞌ tabeiꞌ sin fa, on reꞌ kfuun ein et neno, ma snaen et tais je ninin. Ho anah-upuf sin of niis ma naprenat sin musun. ");
INSERT INTO aaz_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Naꞌko ho sufam sin, too uuf-uuf nbin pah-pinan ia of napenin tetus-athoen, natuin ho munaobaꞌ mrair Au prenat.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Rarit naiꞌ Abraham ma naiꞌ Isak nsanun nfanin ma natefan nok sin ameup nuaꞌ ein naan. Ma sin nfanin neun Beer Seba. Onaim sin natuan nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Neot es, naiꞌ Abraham anneen hanaf nak, in orif naiꞌ Nahor fee bi Milka nahoniꞌ riꞌanaꞌ mfaun. ");
INSERT INTO aaz_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Aan moen unu, kaan ee naiꞌ Us. In oirf ee, naiꞌ Bus. Rarit naiꞌ Kemuer (reꞌ njair amaf neu naiꞌ Aram). ");
INSERT INTO aaz_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Rarit naiꞌ Keset, naiꞌ Haso, naiꞌ Pirdas, naiꞌ Jitlaf, ma naiꞌ Betuel. ");
INSERT INTO aaz_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Naiꞌ Betuel naan, bi Ripka in amaf. ");
INSERT INTO aaz_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mes naiꞌ Nahor nahoniꞌ antein riꞌaan nasi naꞌko bifee jes, in kaan ee, bi Reuma. In nahoniꞌ naiꞌ Teba, naiꞌ Gaham, naiꞌ Tahas, ma naiꞌ Maꞌaka. ");
INSERT INTO aaz_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Ain Saraꞌ nmaet oras in nmoin naan toon nautn es boꞌ nua mhiut (127). Oras in nmate te, sin natuan nbin kuan Kiryat-Arba (es reꞌ Hebron), et pah Kanaꞌan. Naiꞌ Abraham ankae nsim-simak. Sin nbeꞌen amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Rarit naiꞌ Abraham nnao nateef nok atoin Hetes sin. In naꞌuab am nak, ");
INSERT INTO aaz_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au reꞌ ia suma atoin anao-amnemat. Au ka ꞌmuiꞌ fa bare he ꞌsuub au fee ji. Onaim karu hi mromi te, hi miꞌsosaꞌ maan kau afu piis es, he au ꞌsuub au fee je nbi naan.” ");
INSERT INTO aaz_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Sin natahan am nak, ");
INSERT INTO aaz_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“On nai, aam! Aꞌroo-ꞌroo reꞌ ia, hai maan ko mjair atoni mnasiꞌ. Hai mhormaat ko batuur-batuur, tua. Onaim ho mpiir kuum, bare mee es reꞌ reko nneis, reꞌ nmatoom nok ho romim. Hai mroim mituin ahaa ho roim maan, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Rarit naiꞌ Abraham anfeen anhaek ma naꞌbesan auf tuaf ein atoin Hetes sin naan. ");
INSERT INTO aaz_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Rarit in nak, “Karu hi mtoup au haan totis feꞌe na te, au ꞌtoit he hi mturun kau he miꞌuab mok aam Sohar in aan mone naiꞌ Efron. ");
INSERT INTO aaz_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Amtoit miit, he karu reko te, in naꞌsosaꞌ kau in nua fatu Makpera, reꞌ et in pooꞌn ee ninin. In ntoit fak-fauk aah, au ꞌbaen. Au he ꞌbaen ufeek in osan naan anbi hi matam, he njair au pusaak. Au he ubaarb ee he njair hai baer subat.” ");
INSERT INTO aaz_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Oras naan, naiꞌ Efron nok antoko nbi atoin Hetes sin naan. In neikn on anneen naiꞌ Abraham in haan totis naan. Rarit in nhaek ma nataah naiꞌ Abraham anbi atoni mnais ein sin maatk ein am nak, ");
INSERT INTO aaz_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kais on naan, aam! On nai. Au ꞌfee ko poꞌon naan ruum-ruum aah, nok nain in nuat Makpera naan. Aam, ho msuub ho fee je nbi naan. Au ꞌnonaꞌ afu naan ꞌbi au atoni mnais ein sin maatk ein. Maut he sin njarin saksii.” ");
INSERT INTO aaz_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Rarit naiꞌ Abraham naꞌbees antein neu atoin Hetes sin. ");
INSERT INTO aaz_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Onaim in naꞌuab nok naiꞌ Efron am nak, “On reꞌ naan amsaꞌ reko, mes hi ar-arki mneen miit au haan totis ia feꞌ. Au he ꞌsoos ufeek afu naan, maut he au ꞌsuub au ngguin nbin naan.” ");
INSERT INTO aaz_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Rarit naiꞌ Efron nataah am nak, “Afu naan in oosn ii, suma roi mutiꞌ natun haa goah. Hit he tmatabar osaf naan he saaꞌ? In oosn ii ka manenuꞌ fa. Amnao meik ho fee je he msuub ee nai.” ");
INSERT INTO aaz_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Naiꞌ Abraham nroim natuin osaf naan, on reꞌ naiꞌ Efron naꞌuab. Onaim naiꞌ Abraham nsoiꞌ roi mutiꞌ fuaꞌ natun haa, rarit annonaꞌ sin neu naiꞌ Efron, anbi atoin Hetes sin maatk ein he sin ok-okeꞌ njarin saksii. ");
INSERT INTO aaz_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Es naan ate, naiꞌ Abraham anpaar naiꞌ Efron in afu, njair in pusaak. Es reꞌ afu et Makpera, npaumaak kuan Mamre (es reꞌ Hebron). In nsoos nafeek afu naan nok nain in poꞌon, in nuat, ma in hau kouꞌn ee ok-okeꞌ. Atoni mnasiꞌ Hetes sin ok-okeꞌ njarin saksii nak, afu naan nok nain saaꞌ-saaꞌ reꞌ nbi nain naan, naiꞌ Abraham in npaar sin ok-okeꞌ. Rarit naiꞌ Abraham nsuub in fee, ain Saraꞌ, nbi nuat naan et pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nok ranan naan, oras ia, poꞌon naan, ma nuat reꞌ unuꞌ te atoin Hetes sin afu, njair naiꞌ Abraham iin ja. In npaek je njair baer subat neu in nonot-asar. ");
INSERT INTO aaz_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Naiꞌ Abraham in ua mnaun, tar antea in namnais reꞌ-reꞌuf. UISNENO npaant ee, ma nfee ne tetus-athoen. ");
INSERT INTO aaz_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Naiꞌ Abraham anmuiꞌ in atoin pirsaiꞌ jes, reꞌ nꞌurus areꞌ kanan in aꞌmuꞌin. Neot es, naiꞌ Abraham noeꞌn ee mnak, “Amneen murek-rekoꞌ! Au ꞌtoit ko, he ho msuup ampaek UISNENO reꞌ nmoeꞌ neno tunan ma pah-pinan In kanan mak, ho kaisaꞌ mtoit bifee munif naꞌko atoin Kananas sin he musaob ee nok au anah naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mes ho ro he mnao meu au kua-mnasiꞌ, meu au nonot-asar sin. Ho maim bifee muinf es ambi nee, he tasaob ee nok au anah.” ");
INSERT INTO aaz_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Rarit ate naan nataan naiꞌ Abraham am nak, “Reko, tua! Mes au he ꞌmoeꞌ on mee, karu bifee munif naan ka nroim fa he neem nok on ia? Karu on naan ate, au ro he ꞌeik naiꞌ Isak he tmatsaob ee on nee, aiꞌ on mee?” ");
INSERT INTO aaz_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Naiꞌ Abraham nataah am nak, “Ho mumnau murek-rekoꞌ! Maski on mee msaꞌ, ho ka mubeiꞌ fa he meik au aanh ee nnao neu nee! ");
INSERT INTO aaz_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mumnau, UISNENO reꞌ annaaꞌ kuasa et neno tunan, neik kau ꞌpoi ꞌrair uꞌko au kua-mnasiꞌ, ma neik kau ꞌtaam aꞌtea bare ia. Ma In nahakeb rais manbaꞌan nok kau msaꞌ am nak, ‘Au of aꞌfee ko bare ia ok-okeꞌ ꞌeu ho sufam-kaꞌum sin.’ Onaim kais ho nekam naan naꞌoniꞌ. Ho mnao. Uisneno of anreek In ameput naꞌko sonaf neno tunan he nfei ranan neu ko, he ho bisa muteef mok bifee munif, reꞌ he njair au aanh ee in fee. ");
INSERT INTO aaz_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mes karu bifee naan ka nroim fa he neem nok ko neu ia te, ho supat ia ka naah ko fa. Maski on mee msaꞌ, ka nabeiꞌ fa he ho meik naiꞌ Isak meu nee.” ");
INSERT INTO aaz_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Rarit ate naan ansuup anbi naiꞌ Abraham am nak, “Reko, tua. Au ꞌmoeꞌ utuin ho uabam naan ok-okeꞌ, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Onaim ate naan anpiir naan bikaes unta boꞌes. In nasaeb baer mamasaꞌ ma maꞌosaꞌ humaꞌ-humaꞌ anbi bikaes unta sin. Onaim in nok in aok-bian sin nnaon neun naiꞌ Nahor in kota et pah Mesopotamia. ");
INSERT INTO aaz_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ate naan in nnao piut tar antea kota naan in ninin. Rarit in nasnasab in bikaes unta sin anbin naan, anpaumaak oe hain es. Oras naan maans ee nmaeb jen. Natiꞌ te, bifee muinf ein neman he nkuin oe nbi oe haniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Rarit ate naan anꞌonen am nak, “UISNENO reꞌ au aam usiꞌ Abraham in Uisneno. Amturun amfei kau ranan, maut he au sairt ii ntea ma upein in afan nesan arekot. Mukriraꞌ Uisneno Ho nekam arekot meu au aam usiꞌ, ma mumnau in rais manbaꞌan meu kau. Maut he reko te, au uteef ꞌok naiꞌ Isak in fee nbi bare ia. ");
INSERT INTO aaz_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Usiꞌ, au ꞌhaek et oe hain ii ninin. Riꞌ feot muinf ein neman naꞌkon kota he nkuin ma nsuun oe naꞌkon oe haniꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Onaim au ꞌtoit Ko, tua, on nai: Karu au uꞌuab ꞌok bifee muinf es ꞌak, ‘Parmisi, tua. Karu reko te, musanut ho ꞌnai oe jan he au ꞌiun aan akreꞌo.’ Karu in nataah am nak, ‘Reko, tua. Ma au of uꞌinuꞌ ho unta sin imsaꞌ.’ Naa, reꞌ naan anjair tanar nak, bifee munif naan es reꞌ Uisneno Ho mpiir je njair naiꞌ Isak in fee! Nok tanar naan, au uhiin ꞌak, Uisneno mururuꞌ mrair Ho maneekm ii meu au aam usiꞌ, naiꞌ Abraham.” ");
INSERT INTO aaz_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","In ka nꞌonen anrair fa feꞌe te, riꞌ feot muinf es neem. In kaan ee, bi Ripka. In reꞌ naan naiꞌ Abraham in orif naiꞌ Nahor ma bi Milka sin upuf. In aamf ee, naiꞌ Betuel. Bi Ripka mamasaꞌ batuur, ma feꞌ ao-ꞌtemef. In nsaun neu oe haniꞌ naan, rarit in nkui oe neu in aꞌnai oe, rari te in nsae nfain. ");
INSERT INTO aaz_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Oras bi Ripka nsae nfani te, naiꞌ Abraham in ate naan naen neem anseun goe. Rarit in ntoti mnak, “Parmisi, tua! Amfee maan kau oe he au ꞌiun ꞌaan akreꞌo.” ");
INSERT INTO aaz_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rarit bifee munif naan nataah am nak, “Reko, tua!” Rarit in nasanut in aꞌnai oe naan rabah, ma nfeen ate naan he niun. ");
INSERT INTO aaz_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ninu nrair on naan ate, bifee munif naan naꞌuab am nak, “Maut he au ꞌkui oe he uꞌinuꞌ ho bikaes unta sin. Maut he sin ninun tar namsenan.” ");
INSERT INTO aaz_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Rarit in nnao nꞌopaꞌ oe nesif naan nbi ꞌbai oe. Rarit in nsae-nsaun he nkui oe naꞌko oe haniꞌ naan, ma naꞌinuꞌ unta sin ok-okeꞌ, tar antea namsenan. ");
INSERT INTO aaz_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Naiꞌ Abraham in ate naan anhake ma ntaaꞌ-taaꞌ kuun, mes ankius narek-rekoꞌ riꞌ feot munif naan anbiur. In naten-tenab am nak, “Reꞌ Uisneno npiir je ji, es reꞌ ia, oo?” ");
INSERT INTO aaz_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Unta sin ok-okeꞌ ninun tar namsenan. Onaim ate naan nait ikreni mnatuꞌ reꞌ sin natiꞌ te ntao goe nbi sin paank ein, ma niti mnatuꞌ paasn es ma nanitib bifee munif naan in aꞌniimn ein nua sin. ");
INSERT INTO aaz_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Rarit ate naan nataan am nak, “Ho amaꞌ in kaan ee, sekau? Karu reko te, mabeꞌ ia au ꞌtuup aꞌtahan ꞌbi ho amaꞌ in umi.” ");
INSERT INTO aaz_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Onaim bifee munif naan, nataah am nak, “Au amaꞌ, kaan ee naiꞌ Betuel. Au naꞌi, es reꞌ naiꞌ Nahor. Au beꞌi, es reꞌ bi Milka. ");
INSERT INTO aaz_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Anbi hai uim je nmuiꞌ haraꞌ tupaꞌ neu ki. Ma nmuiꞌ huun neu ho muiꞌt ein.” ");
INSERT INTO aaz_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Rarit ate naan naꞌruriꞌ ma naꞌbees neu UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Onaim in naꞌuab am nak, “Pures ma boꞌis neu Uisneno! Usiꞌ nfei ranan neu kau, tar antea au uteef ꞌok au aam usiꞌ in nonot-asar sin anbin ia. Nok ranan naan, Uisneno nakriraꞌ In nekan arekot neu au aam usiꞌ, naiꞌ Abraham, ma najarib in rais manbaꞌan neu kau.” ");
INSERT INTO aaz_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rarit bifee munif naan naen anfain rabah, he natoon rasi naan neu in uim je nanan. ");
INSERT INTO aaz_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Bi Ripka in naof ee, kaan ee naiꞌ Laban. Oras in niit mnaut ein, ma nneen bi Ripka in uaban naan ate, naiꞌ Laban naen anpoi rab-raab, he nateef nok ate, reꞌ nhaek nabaar feꞌ nok in bikaes unta sin npaumaak oe haniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Rarit naiꞌ Laban naꞌuab am nak, “Aam! UISNENO neik ko mtea ia goen nok ao-minaꞌ. Onaim kais amhaek mubaar ambi ia. Au uskau he tnao teu hai umi. Hai mibarab keꞌen, ma bukae neu ko ma neu ho unta sin, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Rarit naiꞌ Abraham in ate naan nnao natuin naiꞌ Laban, he nnaon neu naiꞌ Betuel in umi. Naiꞌ Laban sin nasanut anturun sin baerꞌ ein naꞌkon unta sin. Rarit sin naꞌekuꞌ unta sin nok huun. Sin neikin oe msaꞌ he ate naan nok in aok-biak ein nafanun. ");
INSERT INTO aaz_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Oras sin nꞌator bukaet anbi mei te, ate naan naꞌuab am nak, “Nahuun naꞌko hai he mbukae te, au ꞌtoit mainuan aꞌkreꞌo he utoon aan hai sairt ii feꞌ, tua.” Onaim naiꞌ Laban nataah am nak, “Neu! Reko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ate naan naꞌuab am nak, “Au reꞌ ia, hi naꞌi naiꞌ Abraham in ate. ");
INSERT INTO aaz_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","UISNENO nfee tetus nathoe neu au aam usiꞌ, tar antea in nmuiꞌ batuur-batuur. Uisneno nfee ne mutiꞌ-mnatuꞌ, ate (et bifee ma atoniꞌ), ma muꞌit amfau-rutu, es reꞌ: bijae, bikaes unta, bikaes keledai, ꞌbibi, ma ꞌbib-kase. ");
INSERT INTO aaz_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Oras au aam usiꞌ ma au ain usiꞌ namnasin on nai te, ain Saraꞌ nahoniꞌ naan riꞌaan moen jes. In es reꞌ he antoup aam usiꞌ Abraham in pusaak ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Onaim au aam usiꞌ naiꞌ Abraham anreun kau he ꞌsuup am ꞌak, ‘Ka mubeiꞌ fa he ho mait bifee munif Kananas, he musaob ee nok naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mes ho ro he mait bifee munif muꞌko au nonot-asar sin, he njair naiꞌ Isak in fee.’ ");
INSERT INTO aaz_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Rarit au utaan au aam usiꞌ mꞌak ‘Mes on mee karu riꞌ feot munif naan ka nroim fa he neem nok neu ia?’ ");
INSERT INTO aaz_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Rarit in nataah am nak, ‘UISNENO reꞌ au utuin In roimn ee piut naan, of anreek In ameput naꞌko sonaf neno tunan he nfei ranan neu ko, he ho bisa muteef mok riꞌ feot munif, reꞌ he njair au aanh ee in fee. ");
INSERT INTO aaz_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mes karu au nonot-asar sin ka nromin fa he nkonan riꞌ feot munif naan he neem nok ko neu ia te, ho supat ia ka naah ko fa.’ ");
INSERT INTO aaz_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Onaim feꞌe na au ꞌuum aꞌtea oe hain ee te, au ꞌonen aꞌbi au nekak ꞌak, ‘UISNENO reꞌ au aam usiꞌ Abraham in Uisneno. Amturun amfei kau ranan, maut he au sairt ii ntea ma upein in afan nesan arekot. Maut he reko te, au uteef ꞌok naiꞌ Isak in fee nbi bare ia. ");
INSERT INTO aaz_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Usiꞌ, au ꞌhaek et oe hain ii ninin. Ma riꞌ feot muinf ein neman naꞌkon kota he nkuin ma nsuun oe nbin ia. Onaim au ꞌtoit on nai: karu au uꞌuab ꞌok bifee muinf es ꞌak, “Parmisi, tua! Karu reko te, musanut ho ꞌnai oe jan he au ꞌiun ꞌaan akreꞌo.” ");
INSERT INTO aaz_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Karu in nataah am nak, “Reko, tua! Ma au of uꞌinuꞌ ho unta sin imsaꞌ.” Naa, reꞌ naan anjair tanar nak, bifee munif naan es reꞌ Uisneno Ho mpiir je njair naiꞌ Isak in fee!’ ");
INSERT INTO aaz_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Au ka ꞌonen urair fa feꞌe te, bi non Ripka neem neik in aꞌnai oe, ma nkui oe nbi oe haniꞌ naan. Oras in nsae nfain, au ꞌtoit ꞌak, ‘Parmisi, tua! Amfee maan kau oe he au ꞌiun ꞌaan akreꞌo.’ ");
INSERT INTO aaz_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Onaim in nasanut in aꞌnai oe naan rabah am nak, ‘Reko, tua! Maut he au ꞌkui oe he uꞌinuꞌ ho bikaes unta sin.’ Rarit au ꞌiun, ma au bikaes unta sin ninun amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Rarit au utaan ee mꞌak, ‘Ho amaꞌ in kaan ee, sekau?’ In nataah am nak, ‘Au amaꞌ, es reꞌ naiꞌ Betuel. Au naꞌi, es reꞌ naiꞌ Nahor. Ma au beꞌi, es reꞌ bi Milka.’ Rarit au ukrein je nbi in panan, ma uniitb ee niti mnatuꞌ paasn es. ");
INSERT INTO aaz_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Onaim au uꞌruriꞌ ma uꞌbees ꞌeu Uisneno, mꞌak ‘Pures-boꞌis ꞌeu Uisneno! Usiꞌ Ho mfei ranan meu kau, tar antea au uteef ꞌok au aam usiꞌ in nonot-asar sin anbin bare ia. Ma au uteef aꞌrair ꞌok naiꞌ Isak in fee msaꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Onaim oras ia, karu sin ama arki mneek au aam usiꞌ Abraham ate, mitoon kau kninuꞌ. Karu kaah fa te, mitoon kau kninuꞌ msaꞌ. Maut he au uhiin ꞌak, au he ꞌmoeꞌ on mee.” ");
INSERT INTO aaz_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ate naan naꞌuab anrair on naan ate, naiꞌ Laban ma naiꞌ Betuel natahan am nak, “Karu UISNENO es anꞌator on naan ate, hai he mak saaꞌ ntein. ");
INSERT INTO aaz_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Bi Ripka es ia. Mok ne mnao nai. Maut he in njair naꞌi naiꞌ Abraham in nanef, tatuin saaꞌ reꞌ UISNENO nꞌator nain je.” ");
INSERT INTO aaz_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Anneen on naan ate, naiꞌ Abraham in ate naan, naꞌbees antea afu, ma ntoit makasi neu UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Onaim in nait napoit noni mnatuꞌ ma noin mutiꞌ, ma baer paken amasat, rarit anfee sin neu bi Ripka. In nfee neu bi Ripka in naof ma ainaf amsaꞌ ook-sonuꞌ reꞌ maꞌosaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Rarit naiꞌ Abraham in ate naan, ma in aok-bian sin, nbukaen buꞌ-buaꞌ. Rarit sin ntupan nbin naan. Nokaꞌ on naan ate, sin nfenan. Rarit ate naan natoon neu uim tuaf ein am nak, “Au ꞌtoit mainuan he mkonan kau, karu reko te, hai mfain nai oras ia meu au aam usiꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mes bi Ripka in naof ma in ainaf nak, “Hi mmanaap miꞌsek-sekeꞌ he saaꞌ? Maut he bi Ripka namaik naan nok kai neno boꞌes aꞌsaaꞌ. Rarit naꞌ hi mkoen om mok ne.” ");
INSERT INTO aaz_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mes ate naan nataah am nak, “Koi, ain! Kaisaꞌ mtahan amtein kau! UISNENO nturun anrair kau, tar antea au uteef aꞌrair ꞌok naiꞌ Isak in fee. Onaim ain, hi mifetin kai he hai mfain ma meik rasi ia meu hai aam usiꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Onaim sin nataah ate naan nak, “Hena te, on nai! Hit taskau bi Ripka he tataan teu ne. In nroimn ii, on mee?” ");
INSERT INTO aaz_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Onaim sin nhaman bi Ripka ma nataan ee mnak, “Ripka! Oras ia, et reꞌ ho. Ho mroim he mok main atoniꞌ ia, oo, aiꞌ on mee?” Rarit bi Ripka nataah am nak, “Au ꞌroim he ꞌok, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Rarit sin nafetin bi Ripka, ma in ate reꞌ nꞌuurs ee naꞌko in aanꞌ-anaꞌ, he nnaon buꞌ-buaꞌ nok naiꞌ Abraham in aten naan. Onaim sin naseon bi Ripka neikin tetus-athoen am nak, “Ripka! Maut he reko te, Uisneno nfee ko anah mfa-faun, he ho sufam-kauꞌm ein namsaꞌin nifun-nifun. Ma hai mifneek henatiꞌ ho sufam-kauꞌm ein niis sin musun sin imsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rarit bi Ripka nok in ate naan, sin nakbuaꞌ sin abruaꞌ ein, ma nsaen bikaes unta, ma nnao nanin, natuin naiꞌ Abraham in ate sin. ");
INSERT INTO aaz_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Naiꞌ Isak natua et pah Negep. Oras naan, in feꞌ anfain neem naꞌko oe haniꞌ Beer Lahai Roi. ");
INSERT INTO aaz_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Neon maeb es ate, in npoi naꞌko in tenas he nna-nao kuun. In nait in matan, ma napen-peen kuun on naan ate, in niit unta puukn es annaon neman. ");
INSERT INTO aaz_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Oras bi Ripka nkius niit naiꞌ Isak te, in nsaun rabah naꞌko in unta. ");
INSERT INTO aaz_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Onaim in nataan naiꞌ Abraham in ate naan am nak, “Aam, atoniꞌ reꞌ annao neem reꞌ nee, sekau?” Ate naan nataah am nak, “Naiꞌ Isak es reꞌ nee.” Onaim bi Ripka nait in poꞌuk ma nsakteun he nkuub naan in human. ");
INSERT INTO aaz_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Rarit ate naan natoon rasin naan ok-okeꞌ neu naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Onaim naiꞌ Isak neik bi Ripka ntaam neu in ainf ee tenas. Sin nua sin nmatsaon. Naiꞌ Isak nneek niis bi Ripka. Es naan ate, in ka nsuus antein fa heen neu in ainf ee nmaet. ");
INSERT INTO aaz_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Naiꞌ Abraham ansao ntein bifee jes, kaan ee bi Ketura. ");
INSERT INTO aaz_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Bi Ketura nahoniꞌ riꞌaan ein reꞌ ia: naiꞌ Simran, naiꞌ Yoksan, naiꞌ Medan, naiꞌ Midian, naiꞌ Isbak, ma naiꞌ Sua. ");
INSERT INTO aaz_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Naiꞌ Yoksan in aanh ein, esan reꞌ naiꞌ Seba ma naiꞌ Dedan. Naiꞌ Dedan in suufk ein, esan reꞌ: atoin Asuras, atoin Retus, ma atoin Reumas. ");
INSERT INTO aaz_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Naiꞌ Midian in aanh ein esan reꞌ: naiꞌ Efa, naiꞌ Efer, naiꞌ Henok, naiꞌ Abida ma naiꞌ Erdaa. Sin ok-okeꞌ reꞌ ia, ain Ketura in sufan. ");
INSERT INTO aaz_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Oras naiꞌ Abraham anmoin feꞌ, in nbait nain neu ain Hagar ma ain Ketura sin aanh ein, es-es ate nok in aꞌmuꞌin. Rarit in nreun sin, he nnaon natuan nbin pah Kanaꞌan ntoom pasaꞌ neon-saet, he sin naꞌroon naꞌko in anah naiꞌ Isak. Mes in baer pusaak ein ok-okeꞌ, in nnonaꞌ sin neu naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Naiꞌ Abraham anmaet oras in nmoin naan toon nautn es boꞌ hitu mniim (175). ");
INSERT INTO aaz_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Rarit in anah naiꞌ Isak ma naiꞌ Ismaꞌel ansuub ee nbi nuat Makpera, reꞌ npaumaak kuan Mamre. Unuꞌ te, naiꞌ Abraham ansoos poꞌon naan naꞌko atoin Hetes es, reꞌ in kaan ee naiꞌ Efron, naiꞌ Sohar in anah. Sin nsuub nahunun ain Saraꞌ nbi nuat naan. ");
INSERT INTO aaz_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Naiꞌ Abraham anmate nrair. Uisneno nfee tetus-athoen neu naiꞌ Isak ma in nmoni nbi tetus ao-minaꞌ ma mamut. Oras naan, naiꞌ Isak natua npaumaak oe haniꞌ Beer Lahai Roi. ");
INSERT INTO aaz_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Naiꞌ Ismaꞌel in reetn ii on nai. In reꞌ naan, naiꞌ Abraham nok in fee tnanaꞌ ain Hagar sin anah. Ain Hagar naan, ain Saraꞌ in ate naꞌko pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Naiꞌ Ismaꞌel in aan moen ne tuaf boꞌes am nua. In aanh ein esan reꞌ ia, nmaktun-tuin ein naꞌko moen unu ntea aheit susu, esan reꞌ: naiꞌ Nebayot, naiꞌ Kedar, naiꞌ Atbeel, naiꞌ Mibsam, naiꞌ Misma, naiꞌ Duma, naiꞌ Masa, naiꞌ Hadat, naiꞌ Tema, naiꞌ Yetur, naiꞌ Nafis, ma naiꞌ Ketma. Riꞌaan monen reꞌ ia, sin njarin aam uuf neu too pah boꞌes am nua, es-es ate, nmuiꞌ kuun in pah. Sin nakanab sin pah, es-es ate natuin sin beꞌi-naꞌi sin kaank ein. ");
INSERT INTO aaz_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Naiꞌ Ismaꞌel anmaet oras in nmoin naan toon nautn es boꞌ tenu mhiut (137). ");
INSERT INTO aaz_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Mes in suufk ein naan, anmamusun es nok es. Rarit sin npeꞌen ma natuan nbaits ok nmurai naꞌko Habira tar antea Sur, reꞌ anmanaak nok pah Masir, nkono ntean pah Asur. ");
INSERT INTO aaz_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Naiꞌ Abraham in anah naiꞌ Isak in reetn ii, es reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Oras naiꞌ Isak ansao bi Ripka, naiꞌ Isak nmoin naan toon boꞌ haa. Bi Ripka in aamf ee, es reꞌ naiꞌ Betuel. In naof ee, es reꞌ naiꞌ Laban. Sin reꞌ naan atoin Aramas, naꞌkon pah Padan Aram. ");
INSERT INTO aaz_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bi Ripka ka nahoniꞌ fa. Etun naiꞌ Isak anꞌonen ma ntoit UISNENO he nfei bi Ripka in apun. UISNENO nneen in onen naan, es naꞌ bi Ripka naꞌapuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bi Ripka nnaben ate, in naꞌapuꞌ riꞌaan koen. Riꞌaan ein naan anmasaapn ein piut nbin sin ainf ee apun. Onaim bi Ripka natenab am nak, “Nansaaꞌ am es riꞌaan nuaꞌ ein ia, on reꞌ ia?” Rarit in nataan neu UISNENO. ");
INSERT INTO aaz_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ma UISNENO nataah ee mnak, “Anbi ho aup maan, anmuiꞌ naan riꞌanaꞌ nua reꞌ of he njarin uuf nua reꞌ sin of anmamusun piut-piut. Aan muin aan of naꞌbeꞌi nneis naꞌko aan uun aan. Ma taatf aan of anjair ameput neu in orif.” ");
INSERT INTO aaz_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Oras in neon ne ntea te, bi Ripka nahoniꞌ riꞌaan koen. Monen okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ahuunt ee meꞌ-meꞌe, ma in aon ee maꞌfunuꞌ. Es naꞌ sin nakaanb ee naiꞌ Esau (reꞌ he noi on reꞌ kata es, reꞌ in aꞌmoufn ii ‘maꞌfunuꞌ’). ");
INSERT INTO aaz_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Rarit naꞌ in orif. Mes oras in npoi, in nnaaꞌ in taatf ee in haen tikan. Es naꞌ sin nakaanb ee naiꞌ Yakop (reꞌ he noi on reꞌ kata es, reꞌ in aꞌmoufn ii ‘haen tikan’). Oras nahoniꞌ sin ite, naiꞌ Isak nmoin naan toon boꞌ nee jen (60). ");
INSERT INTO aaz_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Oras riꞌaan koen naan naꞌnaen ate, naiꞌ Esau njair asekot. In nroim he natua nbi nasi. Mes naiꞌ Yakop atoin ataꞌas. In nroim he nbi-bi haa umi. ");
INSERT INTO aaz_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Naiꞌ Isak biasa nroim he neuk siis fui. Es naan ate, in nneek nanes-nesib naiꞌ Esau. Mes bi Ripka nneek nanesib naiꞌ Yakop. ");
INSERT INTO aaz_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Neot es, oras naiꞌ Yakop nahaan oef aknaaꞌ, naiꞌ Esau nfain neem naꞌko sekot. In nhae nmaet ma namnaah anmate msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Onaim in naꞌuab neu naiꞌ Yakop am nak, “Ako! Ho msoon maan kau oef meꞌ-meꞌe reꞌ ho muhaan ee naan. Maski kreꞌ-reꞌo, he au ꞌhaꞌtain! Au umnaah ka ubeiꞌ fa heen.” (Etun sin nteek ee te Edom, reꞌ he noi on reꞌ kata es, reꞌ in aꞌmoufn ii, ‘meꞌe’.) ");
INSERT INTO aaz_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Rarit naiꞌ Yakop nataah am nak, “Reko, taat honiꞌ. Mes karu ho mfee kau ho hak aan moen unu naan feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Onaim naiꞌ Esau nataah am nak, “Ahh. Ma on saaꞌ naꞌ es reꞌ hak aan moen uun gui! Ho mpaar. Au umnaah ka ubeiꞌ fa heen. Ho msoon maan kau oef rabah he meik je neem. Au he ꞌuah een.” ");
INSERT INTO aaz_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mes naiꞌ Yakop naꞌuab anteniꞌ mnak, “Airoo, taat honiꞌ. Ampao kreꞌ-kreꞌo. Ho msuup feꞌ mak, ho mnonaꞌ kau hak naan.” Onaim naiꞌ Esau nsuup on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Rarit naiꞌ Yakop ansono nfeen ee oef aknaaꞌ naan ma nfee ne nok utunuꞌ. Naiꞌ Esau nbukae nrari te, in nfeen annao kuun. Nok ranan naan, naiꞌ Esau nnonaꞌ nain in hak aan moen unu. ");
INSERT INTO aaz_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Neot es, amnaahs ii ntaman pah naan, on reꞌ amnahas oras naiꞌ Abraham anmoin feꞌ. Onaim naiꞌ Isak antoit he karu reko te usif Abimerek, atoin Filistinas sin usif, anfee ne mainuan he in natuan nbi kuan Gerar. ");
INSERT INTO aaz_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","In nmoeꞌ on reꞌ naan, natuin UISNENO nakriir On neu ne mnak, “Ho kais amnao meu pah Masir. Au of ukriraꞌ ko bare ꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Karu ho mutua on reꞌ atoin anao-amnemat mbi bare naan, Au of ꞌok ko, ma ꞌfee ko teuts am athoen humaꞌ-humaꞌ. Au of aꞌmoeꞌ ho suufm ein amfau-rutu on reꞌ kfuun ein et neno. Ma Au ꞌfee ꞌeu ho sufam sin pah reꞌ ia ma in kuan ein okeꞌ. Naꞌko ho sufam-kauꞌm ein naan, of areꞌ uuf-uuf nbin pah-pinan ia napenin teuts am athoen. Nok ranan naan, Au uteabaꞌ Au rais manbaꞌan ꞌok ho amaꞌ naiꞌ Abraham. ");
INSERT INTO aaz_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Au ꞌmoeꞌ on reꞌ ia, natuin ho amaꞌ natuin Au romik, Au prenat, ma Au atoran.” ");
INSERT INTO aaz_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Onaim naiꞌ Isak natua ntahan nbi kuan Gerar. ");
INSERT INTO aaz_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bi Ripka naan mamasaꞌ. Onaim oras atoin ein reꞌ nbin bare naan niit ee, sin nmaktaan ein nok ne. Mes naiꞌ Isak nataah am nak, “Bi Ripka naan, au fetoꞌ.” In namtau karu in nmanakuꞌ nak in fee ja te, atoin ein naan of anroor goe ma ntoup neik bi Ripka. ");
INSERT INTO aaz_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Naiꞌ Isak natua suuk aꞌroo nbi naan. Neot es, uisf ee nasnekuꞌ niit naiꞌ Isak nok bi Ripka naꞌko in eno sneer. In niit sin anmahoon fee-mone. ");
INSERT INTO aaz_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Onaim in nreek tuaf he nnao noꞌen naiꞌ Isak, ma nakain ee mnak, “Isak! Au uhiin urek-rekoꞌ ꞌrair, bifee naan, ho fee ja! On nai te, neu saaꞌ am es ho mak ho fetoꞌ?” Onaim naiꞌ Isak nataah am nak, “On nai, aam usi. Au umtau karu au utoon am ꞌak au fee ja te, kais-kaisaꞌ biak ein anroor niis kau.” ");
INSERT INTO aaz_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Rarit uisf ee nataah am nak, “Karu nmuiꞌ tuaf anbi reꞌ ia reꞌ ntuup nok ho fee, ho ro he musaan kai! Nansaaꞌ am es ho mmoeꞌ on naan meu kai?” ");
INSERT INTO aaz_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Rarit naiꞌ Abimerek namnaub neik haan maꞌtaniꞌ neu in too ngguin am nak, “Hi arki mimnau mirek-rekoꞌ! Sekau-sekau reꞌ nmoeꞌ reꞌuf neu atoniꞌ ia aiꞌ in fee, au of aꞌhukun uꞌmate.” ");
INSERT INTO aaz_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Oras naan naiꞌ Isak narene nbi pah naan. In napein in reen ne aafk ein anfain no nautn es, natuin UISNENO nfee ne tetus-athoen. ");
INSERT INTO aaz_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","In aꞌmuiꞌn ein naꞌbaab ok piut, tar antea in nfain atoin amuꞌit batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","In bijae, ꞌbibi, ma ꞌbib-kase nmaꞌbaab ein amfaun. In ameupt ein namfaun amsaꞌ. Tar antea atoin Filistinas sin seor natenab reꞌuf neu ne. ");
INSERT INTO aaz_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Unuꞌ te, naiꞌ Isak in amaf naiꞌ Abraham sin nhanin oe haniꞌ mfaun. Mes oras ia, atoin Filistinas sin nkuub nareuꞌ oe hain ein naan neikin afu. ");
INSERT INTO aaz_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Rarit usif Abimerek naꞌuab nok naiꞌ Isak am nak, “Isak! Reko nneis ho mnao musaitan hai pah ii nai. Hai mkis-kisu te, ho maꞌtainm ii, nneisi nrair kai.” ");
INSERT INTO aaz_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Rarit naiꞌ Isak nnao nasaitan kuan naan, ma nfain natua nbi karopu mneraꞌ Gerar. ");
INSERT INTO aaz_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Onaim in nhain nafaniꞌ oe hain ein reꞌ sin nkuub sin naan. Ma in nakanab oe hain ein naan, natuin kaanf ein reꞌ unuꞌ te in aamf ee nakanab anrair sin. ");
INSERT INTO aaz_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Oras naiꞌ Isak in ameupt ein anhanin oe nbin mneraꞌ Gerar naan te, sin nhain napein oe maat es, reꞌ nasfurak anpoi. ");
INSERT INTO aaz_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mes atuuks ein naꞌkon Gerar anmatoen nok naiꞌ Isak in atuuks ein, natuin oe haniꞌ naan. Sin nak, “Ia hai oe!” Es naꞌ naiꞌ Isak nakanab oe haniꞌ naan Esek, reꞌ in aꞌmoufn ii, ‘matoes’. ");
INSERT INTO aaz_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Rarit naiꞌ Isak iin na, nhain oe jes anteniꞌ. Mes sin nmatoen nteinꞌ ein, natuin oe haniꞌ naan. Es naꞌ naiꞌ Isak nakanab oe haniꞌ naan Sitna, reꞌ in aꞌmoufn ii ‘anmaraabn ein’. ");
INSERT INTO aaz_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Rarit in nasaitan bare naan, ma nhani ntein oe hain es. Neot reꞌ ia, sin ka nmatoen fa. Es naꞌ naiꞌ Isak nakanab oe haniꞌ naan Rehobot, reꞌ in aꞌmoufn ii ‘baer mainuan’. Ma in naꞌuab am nak, “Oras ia, Uisneno nfee kai bare he mitua mbi baer mainuan ia. Anbi ia te, naꞌ hai bisa mihoniꞌ ma mimsaiꞌ he miꞌbaab om.” ");
INSERT INTO aaz_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Naꞌko naan ate, naiꞌ Isak sin nnaon nꞌanin Beer Seba, he natuan nbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mabeꞌ naan, UISNENO nakriir On neu ne, ma naꞌuab am nak, “Isak! Au reꞌ ia, ho amaꞌ naiꞌ Abraham in Uisneno. Onaim kais mumtau, natuin Au ꞌpao ma ꞌpanat ko. Au of aꞌfee ko teuts am athoen. Ma ho sufam-kauꞌm ein of naꞌbaab ok amfaun. Au ꞌmoeꞌ on reꞌ ia, natuin Au rais manbaꞌan ꞌok ho amaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Rarit naiꞌ Isak anbaik fatu he nafenaꞌ mei fuat anbi naan. Onaim in ntoit makasi neu UISNENO nbi bare naan. In natua nbi naan, ma in ameupt ein nmurai nhanin oe ntenin. ");
INSERT INTO aaz_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Oras naan, usif Abimerek neem naꞌko kuan Gerar. In nok in soob reko naiꞌ Ahusat, ma in meo paꞌe naiꞌ Fikor, neman ma nateef nok naiꞌ Isak. ");
INSERT INTO aaz_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Onaim naiꞌ Isak nataan am nak, “Aam usiꞌ! Unuꞌ te hi mriuꞌ kai mpoi miꞌko hi pah. Onaim oras ia hi iim he minsaaꞌ amtein?” ");
INSERT INTO aaz_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Rarit sin natahan am nak, “On nai! Oras ia hai mihiin mak Uisneno npao ma npanat ko, anhao ma nfait ko. Natuin rasi naan, hai miten-tenab ate, reko nneis hit nua kit tahakeb rais manbaꞌan. Ho msuup am mak, ");
INSERT INTO aaz_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","hi of ka mmoeꞌ fa rais reꞌuf meu kai, on reꞌ hai ka mmoeꞌ fa rais reꞌuf meu ki msaꞌ. Batuur hai neekm ein reko mok ki. Es naꞌ neon goes ii, hi misaitan hai pah ii nok mamut. Hai mihiin batuur-batuur, UISNENO es anfee ki tetus-athoen.” ");
INSERT INTO aaz_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Rarit naiꞌ Isak anmoeꞌ fesat neu sin. Sin nbukaen buꞌ-buaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Anmeu nfiin on naan ate, sin nsupan. Onaim naiꞌ Isak nafetin sin he nfanin nok mamut. ");
INSERT INTO aaz_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Neno naan, naiꞌ Isak in ameupt ein neman ma natonan am nak, “Aam! Hai mipeni mrair oe.” ");
INSERT INTO aaz_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Rarit naiꞌ Isak nakanab oe haniꞌ naan Seba, reꞌ in aꞌmoufn ii nak ‘supat’. Onaim sin nakanab kota naan Beer Seba ntea oras ia. ");
INSERT INTO aaz_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Naiꞌ Esau nmatsao, oras in nmoin naan toon boꞌ haa. In nsao bifee nua naꞌko uuf atoin Hetes. Es kaan ee, bi Yudit, naiꞌ Beri in aan feto. Es antein, kaan ee bi Basmat, naiꞌ Eron in aan feto. ");
INSERT INTO aaz_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bifee nuaꞌ ein naan nasusab naiꞌ Isak ma bi Ripka. ");
INSERT INTO aaz_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Oras naiꞌ Isak namnais inrair, in maatk ein ankupu nmaten. Onaim in noꞌen in aan moen unu reꞌ in nneek niis ne ji mnak, “Esau! Ho uum feꞌ!” Naiꞌ Esau nataah am nak, “On mee, tua?” ");
INSERT INTO aaz_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Naiꞌ Isak natoon ee mnak, “On nai! Au umnais jen. Au ka uhiin fa au neno ꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Onaim mait ho baer seokt ein naan, mnao nai he mseok maan kau muiꞌ fui jes. ");
INSERT INTO aaz_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Rarit ho muhaan maan kau mnaah amin-minat reꞌ au ꞌromi, rarit meik je neem. Au ꞌuah aꞌrari te, au ꞌfee ko tetus. Ma karu au ꞌfee ꞌrair ko tetus ate, au ꞌmate msaꞌ reko.” ");
INSERT INTO aaz_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rarit naiꞌ Esau nnao nseok. Mes bi Ripka nneen niit naiꞌ Isak in uaban naan. ");
INSERT INTO aaz_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rarit bi Ripka naꞌuab neu naiꞌ Yakop am nak, “Hoe, Ako! Amneen murek-rekoꞌ! Feꞌe na au ꞌneen ho amaꞌ naꞌuab nok ho tataꞌ naiꞌ Esau, mnak: ");
INSERT INTO aaz_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ho mnao mseok maan kau muiꞌ fui jes, he muhaan ee namin-miin neu kau. Karu au ꞌuah aꞌrari te, au ꞌfee ko tetus nbi UISNENO In matan.’ ");
INSERT INTO aaz_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Onaim ho mneen murek-rekoꞌ! Au uꞌuab saaꞌ ate, mutuin. ");
INSERT INTO aaz_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oras ia, mnao nai meu hit aꞌbib-kaesn ee, mpiir maan aꞌbib tiup apokat nua. Amroor sin, ma mait meik sin siisk ein naan neman neu kau. Au of uhaan sin utuin ho amaꞌ in romin. ");
INSERT INTO aaz_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Karu au uhaan aꞌrari te, ho meik sin meu ho amaꞌ he in nbukae. Rarit in nfee ko tetus feꞌ, henaꞌ in nmaet. Nok ranan naan, ho es mupein teuts ee. Ka ho tataꞌ fa.” ");
INSERT INTO aaz_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mes naiꞌ Yakop naꞌuab nok in ainf ee mnak, “Ain! Mes au tataꞌ naiꞌ Esau in aon ee maꞌfunuꞌ. Au aok ii kaah fa! ");
INSERT INTO aaz_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kais-kaisaꞌ amaꞌ nreoꞌ au aok ii, ma in nahiin nain nak au upoi. Onaim in nkaas kau!” ");
INSERT INTO aaz_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Onaim in ainf ee nak, “Ako. Kais neek maan nabait. Anbain he au es aꞌator! Karu ho amaꞌ nkaas ko, maut he au es reꞌ usaah. Oras ia, mnao nai he mroro ꞌbibin naan.” ");
INSERT INTO aaz_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Rarit naiꞌ Yakop annao npiir naan aꞌbibin naan. Onaim in nroor sin, ma neik sin siisk ein neun in ainaf. Onaim bi Ripka nahaan sin namin-minan on reꞌ naiꞌ Isak in romin. ");
INSERT INTO aaz_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rarit bi Ripka nnao nait naiꞌ Esau in baer paken reꞌ namasan, ma nfeen naiꞌ Yakop sin he npaek sin. ");
INSERT INTO aaz_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","In nꞌaum naiꞌ Yakop in aꞌniimk ein ma in neon, npaek pasu ꞌbibi naan. ");
INSERT INTO aaz_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Rarit in nfee sisi mtaas ein naan nok utunuꞌ neu naiꞌ Yakop. ");
INSERT INTO aaz_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Rarit naiꞌ Yakop neik sisi mtaas ein naan neu in amaf. In naꞌuab am nak, “Aam! Au ꞌuum een.” Naiꞌ Isak nataah am nak, “Hoe! Ho sekau ko?” ");
INSERT INTO aaz_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Onaim naiꞌ Yakop nataah am nak, “Au reꞌ ia, ho aan moen unuꞌ, naiꞌ Esau! Au ꞌtao utuin ho rekat. Amfeen nai he mbukae. Au uhaan sisi naꞌko muiꞌ fui reꞌ au ꞌheek ꞌaan. Ambukae nai, henaꞌ rari te muꞌuab amfee kau tetus, tua!” ");
INSERT INTO aaz_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Rarit naiꞌ Isak naꞌuab am nak, “Ho maꞌtain reꞌuf ko! Ho mseok rabah, oo!” On nai te, naiꞌ Yakop nataah am nak, “Au upein raab aah, natuin UISNENO reꞌ amaꞌ ho muꞌbees meu Na ji, es reꞌ anturun ma nbaab kau.” ");
INSERT INTO aaz_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Onaim naiꞌ Isak anhaman naiꞌ Yakop am nak, “Ho mpaumaak kau feꞌ, he au ꞌreoꞌ ꞌiit ko! Naiꞌ Esau es reꞌ ho, oo?” ");
INSERT INTO aaz_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Rarit naiꞌ Yakop ansiriꞌ ntaam ma npaumak-maak in amaf. Onaim aꞌnaef ee nreoꞌ goe, ma naꞌuab am nak, “In haan ii, on reꞌ naiꞌ Yakop in hanan! Mes in aꞌniim ii, on reꞌ naiꞌ Esau in aꞌniman.” ");
INSERT INTO aaz_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Mes naiꞌ Isak ka nahiin fa naiꞌ Yakop natuin in aꞌniimn ein maꞌfunuꞌ on reꞌ naiꞌ Esau. Mes oras in he nfee tetus neu naiꞌ Yakop, ");
INSERT INTO aaz_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","in nataan antein am nak, “Ho reꞌ ia, naiꞌ Esau batuur-batuur, aa oo?” Onaim naiꞌ Yakop nataah am nak, “Batuur, tua!” ");
INSERT INTO aaz_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Rarit naiꞌ Isak naꞌuab am nak, “Ho mnonaꞌ sisi naan he au ꞌeuk. Rarit naꞌ au ꞌfee ko tetus.” Onaim naiꞌ Yakop ansoron sisi ma tua min-kase neu in aamf ee, ma in nbukae. ");
INSERT INTO aaz_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Rarit in aamf ee naꞌuab am nak, “Airoo. Ampaumaak uum he mhoo ma mneek maan kau.” ");
INSERT INTO aaz_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Oras naiꞌ Yakop anpaumaak he nhoo ma nneek in aamf ee te, naiꞌ Isak nafoi nahiin naiꞌ Esau in paekn ein fook ein. Rarit in nfee tetus neu naiꞌ Yakop am nak, “Au aanh ii in foon ii, on reꞌ mneraꞌ huun reꞌ UISNENO nasanut tetus, ");
INSERT INTO aaz_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Maut he Uisneno nasanut pinis naꞌko neno, he namriab ma nasnaub ho renen! Maut he In nfee ko penaꞌ-makaꞌ nho-hoen, ma ho pooꞌ anggur sin nafuan nho-hoen. ");
INSERT INTO aaz_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Uuf-uuf of anjarin ho aten sin, Ma uuf-uuf naꞌko pah-pah of naꞌruriꞌ ma nhormaat ko. Maut he ho muprenat ho aom-bian sin ok-okeꞌ, ma sin arsin of anriꞌtuun nbin ho humam ma ho matam. Sekau es reꞌ ankaas ko, sin of napenin kasat amsaꞌ. Mes sekau es reꞌ anfee ko tetus, sin of napenin tetus amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Oras naiꞌ Isak anfee nrair tetus, ma naiꞌ Yakop feꞌ anpoi nasaitan in aamf ee te, in tataf naiꞌ Esau nfain neem ma neik muiꞌ fui reꞌ in nheek naan ee. ");
INSERT INTO aaz_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Onaim in nnao nahaan ee, rarit in neik je neu in amaf. In naꞌuab am nak, “Aam! Amfeen he mbukae nai, tua. Au uhaan aꞌrair siis fui reꞌ au ꞌnao ꞌseok ꞌaan. Ambukae mrari te, amfee kau tetus.” ");
INSERT INTO aaz_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Naiꞌ Isak naskeek. In nataan am nak, “Hoe! Ho sekau ko mtein?” Rarit naiꞌ Esau nataah am nak, “Au naiꞌ Esau kau! Au ho aan moen unu.” ");
INSERT INTO aaz_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Onaim naiꞌ Isak naꞌtaꞌi. Rarit aꞌnaef ee nataan am nak, “Karu on naan ate, feꞌe na sekau es reꞌ neik kau sisi ma au ꞌeuk? Au ꞌeku ꞌrair, ma ꞌfee ꞌrair tetus ꞌeu tuaf naan. Ma au ka ubeiꞌ fa he ꞌheer ufaniꞌ tetus reꞌ au ꞌfee je naan.” ");
INSERT INTO aaz_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Anneen in aamf ee naꞌuab on naan ate, naiꞌ Esau neekn ee nameen, ma nkae npin-pinus. Ma naꞌaub naher-heer am nak, “Koi, aam! Amfee kau tetus amsaꞌ, tua!” ");
INSERT INTO aaz_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mes naiꞌ Isak nak, “Ho oriꞌ neem am napoi nrair kau, ma nabaak naan ho tetus.” ");
INSERT INTO aaz_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Rarit naiꞌ Esau naꞌuab am nak, “In napoi kau no nua goen. Nahunu te, in napoi kau ma ntoup naan au hak aan moen unu. Oras ia, in napoi kau ntein ma ntoup naan au tetus. Etun in kaan ee ‘Yakop’. Mes ho mmuiꞌ tetus bian antein he mfee kau, oo?” (Kanaf Yakop in oetn ii ‘nnaaꞌ haen ꞌtikan’. Mes in oten bian ‘apoit’.) ");
INSERT INTO aaz_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Rarit naiꞌ Isak nataah am nak, “Au uꞌratan aꞌrair ho oriꞌ njair ho usiꞌ. Ma in aok-bian sin okeꞌ njarin in ate sin. Au ꞌfee ne penaꞌ-makaꞌ nho-hoen, ma hau fua anggur nho-hoen amsaꞌ. Onaim Esau! Oras ia au he ꞌfee ko tetus saaꞌ aꞌtein?” ");
INSERT INTO aaz_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Anneen on naan ate, naiꞌ Esau noik aamf ee piut am nak, “Aam, ho mmuꞌi haa tetus meseꞌ, aa oo? Au ꞌtebes, ho of ammuꞌi mtein bian. Maski aanꞌ-anaꞌ msaꞌ, reko!” Onaim in nmurai nkae ntein. ");
INSERT INTO aaz_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Rarit naiꞌ Isak nataah in anah naiꞌ Esau mnak, “Ho ꞌmoin maan of naꞌroo naꞌko reen amriat ein, ka tiit fa pinis nsaun naꞌko neno he napeet ho afun. ");
INSERT INTO aaz_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ho suin aan of es anfee ko he mmoin. Mes maski on mee-mee msaꞌ, ho mjair ate meu ho oriꞌ. Suma karu ho mraban mubeiꞌ je, of naꞌ ho mufetin maan om muꞌko in aꞌniman.” ");
INSERT INTO aaz_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Naiꞌ Esau natoꞌon naiꞌ Yakop reꞌ-reꞌuf, natuin naiꞌ Yakop nasiik naan in tetus. Mes in natenab am nak, “Ka ꞌroo fa te, amaꞌ nmaet. Onaim au ꞌpao. Beeꞌt ee okeꞌ te, au ꞌroro!” ");
INSERT INTO aaz_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Oras bi Ripka nneen naiꞌ Esau in sarit naan ate, in noꞌen naiꞌ Yakop am nak, “Ho mneen murek-rekoꞌ! Ho tataꞌ nareon anrair he nbaras in neek menas. In he nroor niis ko. Onaim ho maen nai meu ho babaꞌ naiꞌ Laban et Haran. ");
INSERT INTO aaz_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Amnao mutua mtahan ambi nee, tar antea ho tataꞌ in neekn ee nmuniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Karu in nnikan nain saaꞌ-saaꞌ reꞌ ho mmoeꞌ sin neu ne te, au of aꞌreek tuaf he neit naan ko. Natuin au ka ꞌroim fa he unekun au aanh ein nua sin no meseꞌ nain.” ");
INSERT INTO aaz_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rarit bi Ripka naꞌuab nok naiꞌ Isak am nak, “Au ꞌrenan naiꞌ Esau in fee nuaꞌ ein reꞌ naꞌkon atoin Hetes sin ia! Karu naiꞌ Yakop ansao riꞌ feot munif Hetes, reko nneis au ꞌmaet nai.” ");
INSERT INTO aaz_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rarit naiꞌ Isak noꞌen naiꞌ Yakop, ma nfee ne tetus ma fainekat am nak, “Amneen murek-rekoꞌ! Ho kaisaꞌ msao bifee munif naꞌko pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mes ho mnao meu Padan Aram, meu ho naꞌi naiꞌ Betuel in umi. Ho mnao ma msao ho babaꞌ naiꞌ Laban in aan feot goes. ");
INSERT INTO aaz_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Maut he Uisneno reꞌ Akuaas Reꞌuf naan, es anfee ko tetus, he ho anah-upuf sin namfaun, ma ho sufam-kauꞌm ein anjarin uuf-uuf amfaun reꞌ maꞌtain ein. ");
INSERT INTO aaz_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Maut he Uisneno In rais manbaꞌan neu naiꞌ Abraham naneet neu ko, ma neu ho sufam-kaꞌum sin. Maut he ho mpaar pah ia, reꞌ Uisneno nbaꞌan anrair je neu naiꞌ Abraham.” ");
INSERT INTO aaz_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Naꞌuab anrair on naan ate, nai Isak nafetin naiꞌ Yakop he nnao neu Padan Aram, neu in babaf naiꞌ Laban ma naꞌif naiꞌ Betuel sin umi. ");
INSERT INTO aaz_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Naiꞌ Esau nneen, nak naiꞌ Isak nfee nrair tetus neu naiꞌ Yakop, ma ntaar ee he kais ansao riꞌ feot munif naꞌko pah Kanaꞌan. In nneen amsaꞌ nak in aamf ee nreun goe he nnao nsao baabf ee aan feot goes et Padan Aram. ");
INSERT INTO aaz_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Rarit naiꞌ Yakop natuin in ainaf-amaf sin fainekat, onaim in nnao neu Padan Aram. ");
INSERT INTO aaz_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Naiꞌ Esau nahini msaꞌ nak, in aamf ee ka nroim fa in fee ngguin naꞌkon pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Onaim in nnao neu in aam kouf naiꞌ Ismaꞌel, rarit in nsao naiꞌ Ismaꞌel aan feto bi Maharat. Bi Maharat naan, naiꞌ Nebayot fetof. ");
INSERT INTO aaz_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Rarit naiꞌ Yakop annao nasaitan Beer Seba neu kuan Haran. ");
INSERT INTO aaz_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Oras maans ee nmouf, in ntea baer jes, ma in ntuup anbi naan. Oras in he ntuup ate, in nait faut goes he nꞌakaꞌnunuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mabeꞌ naan in namnei. In niit eraꞌ fuaꞌ es, reꞌ in tuun ne nasnait on anbi neno. Rarit Uisneno In ameput neno tunan sin ansae-nsanun nbin erak naan. ");
INSERT INTO aaz_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Anbi mneit naan, naiꞌ Yakop niit UISNENO nhake nbi in abnapan, rarit In naꞌuab am nak, “Au reꞌ ia, UISNENO, ho naꞌi naiꞌ Abraham ma ho amaꞌ naiꞌ Isak sin Uisneno. Au of aꞌfee ko pah ia ꞌeu ko ma ꞌeu ho sufam-kaꞌum sin. ");
INSERT INTO aaz_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ho sufam-kauꞌm ein of amfaun on reꞌ skukuꞌ. Ma sin of ansei jok ma nbaits ok neun bare-bare. Naꞌko ho sufam-kaꞌum, areꞌ uuf anbin pah-pinan of napenin tetus-athoen. ");
INSERT INTO aaz_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mumnau murek-rekoꞌ! Ho mnao meu mee-mee jah, Au ꞌok ko, ꞌpafaꞌ ma ꞌpanat ko. Au of ꞌeik ko mfain uum meu pah ia. Au ka ꞌkonan ko mmees fa. Ma Au of uteabaꞌ rais manbaaꞌn ein reꞌ Au ꞌfee ko sin.” ");
INSERT INTO aaz_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Oras naiꞌ Yakop anfeen naꞌko tupas naan, in naꞌuab am nak, “Au feꞌ uhiin ꞌak, UISNENO et bare reꞌ ia msaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Onaim in namtau. Ma in natenab am nak, “Bare ia nmoeꞌ kau mꞌau fuunk ein natoron. Namneo-namneo, Uisneno In uim ji et reꞌ ia! Ma enoꞌ he ttaam teu sonaf neno tunan, es reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kik-kiku te, naiꞌ Yakop anfeen. Rarit in nait faut akaꞌnunuꞌ naan, ma nahaek ee njair tanar. Rarit in nꞌoop minaꞌ nbi fatu naan, ma nꞌonen neu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","In nakanab bare naan Betel, reꞌ in aꞌmoufn ii nak ‘Umi Uisneno’. (Unuꞌ te bare naan, kaan ee, Lus). ");
INSERT INTO aaz_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Rarit naiꞌ Yakop ansuup am nak, “Karu Uisneno nok kau, npao ma npanat kau ꞌbi au ranan ia, ma nfee kau mnahat ma pake, ");
INSERT INTO aaz_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tar antea au ꞌfain ꞌuum ꞌbi mamut ma ao-minaꞌ, UISNENO of anjair au Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Fatu reꞌ au uhaek ee ia, njair baer onen neu Uisneno. Ma saaꞌ-saaꞌ reꞌ Uisneno nfee kau sin, au of aꞌfee ufaniꞌ sapaaf es naꞌko bait boꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Rarit naiꞌ Yakop annao nkono nꞌain pasaꞌ neon-saet. ");
INSERT INTO aaz_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","In nna-nao te, in niit oe hain es npaumaak kuan es. Anpaumaak oe haniꞌ naan, anmuꞌi ꞌbibi ma ꞌbib-kase, pukan teun, reꞌ anpaon he napenin oe mninuꞌ. Mes anmuiꞌ faut kouꞌ goes antoeb naan oe haniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Natiꞌ te, karu muiꞌt ein naan nabua nrarin ate, naꞌ atuuks ein antitar naꞌroob fatu naan, rarit ankuin oe ma naꞌ naꞌinuꞌ sin. Ninu nrarin ate, sin ntoeb nafainꞌ ee. ");
INSERT INTO aaz_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Onaim naiꞌ Yakop annao nataan atuuks ein naan am nak, “Hoore, tua! Hi miꞌko mee, tua?” Sin natahan am nak, “Hai miꞌko kuan Haran, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Rarit naiꞌ Yakop nataan antein am nak, “Hi mihiin au babaꞌ naiꞌ Laban, aa oo? In reꞌ naan, naiꞌ Nahor in anah.” Onaim sin natahan am nak, “Hai mihiin je, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Naiꞌ Yakop nataan piut am nak, “In nꞌao-minaꞌ, oo?” Sin natahan am nak, “Aꞌnaef ee et reꞌ nee. In reko. Amkius. In aan feto bi Rahel napooꞌ neik in muiꞌt ein neman he naꞌinuꞌ sin anbin reꞌ ia. Ho mpao mbi ia.” ");
INSERT INTO aaz_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Rarit naiꞌ Yakop naꞌuab antein am nak, “Maans ee naꞌpuup feꞌ. Onaim reko nneis muiꞌt ein reꞌ neem nabuan nrarin ia, hi miꞌinuꞌ sin nai. Rarit hi mipooꞌ meik sin he sin nekun huun.” ");
INSERT INTO aaz_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mes sin npenan mates, nak, “Hoe, ka on fa naan! Hai ro he mpao atuuks ein neman ok-okeꞌ neik sin muiꞌt ein ntean ia feꞌ. Henaꞌ hai mtitar fatu ne, he miꞌinuꞌ muiꞌt ein naan.” ");
INSERT INTO aaz_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Naiꞌ Yakop feꞌ naꞌub-uab nok atoin ein naan ate, bi Rahel neem antea nok in aamf ee muiꞌt ein. Natiꞌ te, in natuuk muiꞌt ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Oras naiꞌ Yakop niit bi Rahel nok in aꞌbibin ma ꞌbib-kasen naan ate, in nnao ntitar nain faut tobef naan. Rarit in naꞌinuꞌ in baabf ee in muiꞌt ein. ");
INSERT INTO aaz_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Rarit in nneek bi Rahel, ma nkae. ");
INSERT INTO aaz_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Rarit in naꞌaub neu bi Rahel am nak, “Au reꞌ ia, ho baab feto bi Ripka in anah.” Onaim bi Rahel naen anfain neu umi he natoon neu in amaf. ");
INSERT INTO aaz_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Oras naiꞌ Laban anneen haan tonas nak naiꞌ Yakop naan, in fetof bi Ripka anah, in naen anseun goe. Oras sin natefan ate, naiꞌ Laban nneek ma nhoo goe. Rarit in nok ne neu in umiꞌ. Onaim naiꞌ Yakop naretaꞌ areꞌ saaꞌ-saaꞌ neu in babaf. ");
INSERT INTO aaz_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Onaim naiꞌ Laban naꞌuab am nak, “Batuur! Hit nua kit umi nanan!” ");
INSERT INTO aaz_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Oras naiꞌ Yakop natua nok sin fuun es, ");
INSERT INTO aaz_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","naiꞌ Laban naꞌuab neu ne mnak, “Ako! Au ka ꞌroim fa he ho mmeup ruum-ruum meu kau, natuin hit nua kit umi nanan. Onaim ho mtoit fauk?” ");
INSERT INTO aaz_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Naiꞌ Laban anmuiꞌ aan feto nua. Ahuunt ee, in kaan ee bi Lea. Amuint ee, in kaan ee bi Rahel. ");
INSERT INTO aaz_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Bi Lea in maat firo. Mes bi Rahel in huumn ee mamasaꞌ, ma in aon ee msaꞌ ro reko. ");
INSERT INTO aaz_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Naiꞌ Yakop in ntaam nekan bi Rahel. Onaim in nataah naiꞌ Laban am nak, “Au ꞌmepu ꞌfee ko toon hiut, asar ho mroim he au ꞌsao bi Rahel.” ");
INSERT INTO aaz_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Rarit naiꞌ Laban nataah am nak, “Reko! Naan es reꞌ reko nneis, natuin hit nua kit umi nanan. Maut he au anah bi Rahel kais ansao atoin sonaꞌ. Onaim ho mutua mbi ia, he mbiur meu kau.” ");
INSERT INTO aaz_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Rarit naiꞌ Yakop nmeup toon hiut, henatiꞌ in bisa nsao bi Rahel. In nneek niis bi Rahel. Etun toon hiut reꞌ naan, on reꞌ neno fauk aah. ");
INSERT INTO aaz_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Toon hiut namsopu te, naiꞌ Yakop namnaubaꞌ babaf naiꞌ Laban am nak, “Baab! Au ꞌmeup toon hiut goen. Oras ia, mnonaꞌ kau bi Rahel he au ꞌsao.” ");
INSERT INTO aaz_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Onaim naiꞌ Laban nahoeb ma narais neu kabin naan. In naskau too mfaun anbin kuan naan. ");
INSERT INTO aaz_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Mabeꞌ naan, naiꞌ Laban ka nfee fa bi Rahel, mes in nfee bi Lea he ntaam neu naiꞌ Yakop in tenar. Onaim naiꞌ Yakop antuup nok bi Lea. Kik-kiku te, naꞌ naiꞌ Yakop nahiin nak in ntuup nok bi Lea. Onaim naiꞌ Yakop anmatoe in aam babaf naiꞌ Laban am nak, “Au ꞌaetn ok toon hiut he ꞌsao bi Rahel! Te ho mseun ee nok bi Lea! Nansaaꞌ am es ho muꞌeꞌob kau on reꞌ ia?” Rarit naiꞌ Laban nataah am nak, “Ho kais mutooꞌ! Tatuin hai harat anbi bare ia, feot muni ka nabeiꞌ fa he nsao nahunun feot unu. Onaim reko nneis on nai! Ho mpao he fesat neno hiut namsoup feꞌ, naꞌ ho mupein bi Rahel. Mes ho ro he mmepu mtein toon hiut meu kau.” Rarit naiꞌ Laban anfee in ate bi Silpa he njair bi Lea in ate. ");
INSERT INTO aaz_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Naiꞌ Yakop anroim natuin. Onaim fesat neno hiut namsopu te, naiꞌ Laban anfee bi Rahel he naiꞌ Yakop ansao. ");
INSERT INTO aaz_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Rarit naiꞌ Laban anfee in ate bi Bilha he njair bi Rahel in ate. ");
INSERT INTO aaz_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Onaim naiꞌ Yakop ansao bi Rahel amsaꞌ. In nneek nanesib bi Rahel. Onaim in nmepu ntein toon hiut neu in aam babaf. ");
INSERT INTO aaz_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mes UISNENO nahiin nak naiꞌ Yakop anneek nanesib bi Rahel. Es naan ate, In nkonan bi Lea he nahoniꞌ. Mes bi Rahel kahaf. ");
INSERT INTO aaz_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Bi Lea naꞌapuꞌ, ma nahoniꞌ riꞌaan moen jes. In nakanab riꞌanaꞌ naan naiꞌ Ruben (reꞌ in aꞌmoufn ii nak ‘mkius, nmuiꞌ anah’), natuin in naꞌuab am nak, “UISNENO nkius niit au susat. Etun es oras ia, au moen je he nkius kau.” ");
INSERT INTO aaz_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Rarit bi Lea naꞌapuꞌ ntein, ma nahoniꞌ riꞌaan moen jes. In nakaanb ee, naiꞌ Simeon (reꞌ in aꞌmoufn ii oniꞌ nak ‘atoniꞌ nneen anrair’), natuin in nak, “UISNENO nneen anrair nak au moen je ka nfairoir kau fa. Es naꞌ In nfee ntein kau riꞌanaꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Rarit bi Lea naꞌapuꞌ ntein, ma nahoniꞌ riꞌaan moen jes. In nakanab riꞌanaꞌ naan naiꞌ Lewi, natuin in naꞌuab am nak, “Nok reꞌ riꞌanaꞌ ia, au rais ji, okeꞌ nrair. Namneo, au moen ji of naꞌkiiꞌ inbi kau, natuin au uhoniꞌ riꞌaan mone teun goen ma ꞌfee ne sin.” ");
INSERT INTO aaz_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Rarit bi Lea naꞌapuꞌ ntein, ma nahoniꞌ riꞌaan moen jes. In nakanab riꞌanaꞌ naan naiꞌ Yahuda (reꞌ in aꞌmoufn ii oniꞌ nak ‘boꞌis’), natuin in naꞌuab am nak, “Neot reꞌ ia, au he ꞌboꞌis UISNENO!” Rarit bi Lea ka nahoniꞌ fa heen. ");
INSERT INTO aaz_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mes bi Rahel ka nahoniꞌ fa feꞌ. Etun in sero nmuiꞌ tenab neu in tataf. Onaim in naꞌuab neu in moen je mnak, “Aam! On mee mꞌes au ka uhoniꞌ fa? Karu ka mfee kau fa anah ate, reko nneis au ꞌmaet nai.” ");
INSERT INTO aaz_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Onaim naiꞌ Yakop naskaar ee mnak, “Ho mak au Uisneno kau? Au ka ꞌmoeꞌ uhiin fa riꞌanaꞌ he ꞌfee ko.” ");
INSERT INTO aaz_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rarit bi Rahel naꞌuab am nak, “On nai! Reko nneis ho mtuup mok au ate bi Bilha. Maut he on mee te, in nahoniꞌ riꞌanaꞌ nfee kau.” ");
INSERT INTO aaz_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rarit in nnonaꞌ bi Bilha neu in mone. Onaim naiꞌ Yakop antuup nokan. ");
INSERT INTO aaz_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Rarit bi Bilha naꞌapuꞌ, ma in nahoniꞌ riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Onaim bi Rahel naꞌuab am nak, “Uisneno nneen au onen. Etun In nfee kau riꞌaan moen jes. Uisneno nafeek nataib ahaa au rasi.” Onaim in nakanab riꞌanaꞌ naan naiꞌ Dan (reꞌ in aꞌmoufn ii nak ‘afeek rasi’). ");
INSERT INTO aaz_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rarit bi Bilha naꞌapu ntein, ma nahoniꞌ riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Onaim bi Rahel naꞌuab am nak, “Au ꞌok au tataꞌ mmariꞌun mahoint ii. Onaim au ꞌiis ꞌaan ee.” Etun in nakanab riꞌanaꞌ naan naiꞌ Naftali (reꞌ in aꞌmoufn ii nak ‘anmariꞌun’). ");
INSERT INTO aaz_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Oras bi Lea nnaben nahiin neu in ka nahoniꞌ fa heen, in nnonaꞌ bi Silpa he naiꞌ Yakop ansao. ");
INSERT INTO aaz_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Rarit bi Silpa nahoniꞌ riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Rarit bi Lea naꞌuab am nak, “Au ua reko kau.” Onaim in nakanab riꞌanaꞌ naan naiꞌ Gat (reꞌ in aꞌmoufn ii, nak ‘ua reko’). ");
INSERT INTO aaz_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Rarit bi Silpa nahoniꞌ ntein riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Onaim bi Lea naꞌuab am nak, “Hoe! Oras ia, naꞌ au ꞌmariin! Amkius kiim, of bifeen guin naꞌuab ein am nak, au ꞌiis mainenuꞌ.” Etun in nakanab riꞌanaꞌ naan, naiꞌ Aser (reꞌ in aꞌmoufn ii nak ‘marinet’). ");
INSERT INTO aaz_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Neot es, nateef oras amnonut, naiꞌ Ruben annao nbi nasi. In napein hau reꞌu reꞌ nturun tuaf he karu reko te nahoniꞌ. Rarit in neik je neu in ainaf bi Lea. Ankius niit on naan ate, bi Rahel antoit bi Lea mnak, “Airoo, taat! Amfee maan kau reꞌu kreꞌo reꞌ naiꞌ Ruben neik je naan.” ");
INSERT INTO aaz_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mes bi Lea nataah am nak, “Hoe! Ho bainesiꞌ ko! Ho musiik amrair au mone. Ma oras ia, he musiik amtein reꞌu naꞌko au anah. Ho ka mumaeb om fa, joo?” Mes bi Rahel naꞌuab am nak, “On nai taat. Karu au upein reꞌu naan ate, mabeꞌ ia ho mok hit mone.” Bi Lea nroim on naan. ");
INSERT INTO aaz_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Maans ee nmaeb on naan ate, naiꞌ Yakop anfain neem naꞌko rene. Onaim bi Lea nnao nateef nok ne, ma naꞌuab ee mnak, “Aam! Ho ro he mtuup mok kau mabeꞌ ia! Natuin au ꞌbaen aꞌrair ko ꞌeik au aanh ee in reꞌu.” Rarit mabeꞌ naan, naiꞌ Yakop antuup nok bi Lea. ");
INSERT INTO aaz_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Rarit Uisneno nneen bi Lea in onen. Onaim in naꞌapuꞌ, ma nahoniꞌ riꞌaan moen jes. Neot ia, in nahoniꞌ no niim een. ");
INSERT INTO aaz_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Rarit bi Lea nakanab riꞌanaꞌ naan naiꞌ Isaskar (reꞌ in aꞌmoufn ii nak ‘baenaꞌ haet’), natuin in naꞌuab am nak, “Uisneno nbaen anrair au haet, natuin au ꞌnonaꞌ ꞌrair bi Silpa he nsao au mone.” ");
INSERT INTO aaz_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Rarit bi Lea naꞌapuꞌ ntein, ma nahoniꞌ riꞌaan moen jes. Reꞌ ia, no nee jen. ");
INSERT INTO aaz_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","In naꞌuab am nak, “Uisneno nꞌook-soun kau. Onaim oras ia, au moen je ro he nhormaat kau, natuin au uhoniꞌ ꞌrair riꞌaan mone nee jen.” Etun in nakanab riꞌanaꞌ naan naiꞌ Sebulon (reꞌ in aꞌmoufn ii nak ‘nfee hormaat’). ");
INSERT INTO aaz_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Rarit bi Lea nahoniꞌ riꞌaan feot goes. Onaim in nakaanb ee, bi Dina. ");
INSERT INTO aaz_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mes Uisneno namnau bi Rahel amsaꞌ, ma In nneen in onen totis. Etun In nfei bi Rahel in apun. ");
INSERT INTO aaz_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Onaim in naꞌapuꞌ ma nahoniꞌ riꞌaan moen jes. In naꞌuab am nak, “Uisneno nait inporin au rais mae.” ");
INSERT INTO aaz_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Onaim in nakanab riꞌanaꞌ naan, naiꞌ Yusuf (reꞌ in aꞌmoufn ii oniꞌ nak ‘maut he in naꞌbabaꞌ’), natuin in naꞌuab am nak, “Au ꞌtoit he Uisneno naꞌbabaꞌ kau riꞌaan moen jes antein.” ");
INSERT INTO aaz_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Oras bi Rahel nahoniꞌ nrair naiꞌ Yusuf, naiꞌ Yakop naꞌuab nok naiꞌ Laban am nak, “Aam! Karu reko te, au ꞌfain ꞌeu au pah ee feꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Maut he au ꞌeik au fee ma au aanh ein amsaꞌ. Ho muhini mrair, au ꞌmeup maꞌtaniꞌ ꞌeu ko. Onaim au ꞌbaen ufeek sin een. Natuin rasi naan, oras ia sin nfanin au nggoa jen.” ");
INSERT INTO aaz_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Rarit in aam baabf ee nataah am nak, “Ako! Ho mneen feꞌ. Au uketiꞌ ma takseer aꞌsobaꞌ. Au ꞌiit aꞌrair, onaim au uhiin ꞌak Uisneno npaek ko he nfee kau tetus-athoen. ");
INSERT INTO aaz_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Onaim oras ia ho mtoit fak-fauk aah. Au ꞌbaen! Asar ho mutua mok kau mbi ia, ma mmepu mfee kau.” ");
INSERT INTO aaz_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Rarit naiꞌ Yakop nataah am nak, “Aam, ho miit kuum, au mepun. Nok ranan naan, ho muiꞌt ein naꞌbaab ok piut. ");
INSERT INTO aaz_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Oras au ka ꞌuum fa feꞌe te, ho ꞌmuiꞌm ein ka mfaun fa feꞌ. Mes oras ia, ho atoin amuꞌit. Uisneno nfee ko tetus, natuin au mepuk. Oras ia, ntea in oors aa goen he au ꞌmeup ꞌeu au fee-anah sin.” ");
INSERT INTO aaz_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Rarit naiꞌ Laban nataan am nak, “Reko. Onaim au he ꞌbaen on mee ꞌeu ko?” Naiꞌ Yakop nataah am nak, “Aam, ho kais musuusb om he mfee kau saaꞌ-saaꞌ. Au of utuuk ukonob ho muiꞌt ein, mes asar au ꞌmoeꞌ ꞌaan taos es. ");
INSERT INTO aaz_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Amfee kau mainuan, he neno ia au ꞌnao ꞌeu ho muiꞌt ein. Au he ꞌpiir ꞌaan aꞌbibi ma ꞌbib-kase reꞌ ka maꞌkotoꞌ fa. Sin reꞌ naan, ho nggoa, tua. Mes reꞌ maꞌkoot ein ee, au ngguin. Ma au ꞌheit areꞌ ꞌbib-kaes metan amsaꞌ. Maut he sin ok-okeꞌ naan, anjarin baen neu au suus-haet. ");
INSERT INTO aaz_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Anbi neon amuint ate, of naꞌ ho muhiin mak au neek ii kninuꞌ, aiꞌ kaah? Oras mee-mee jah, ho uum he muprikas au muiꞌt ein. Karu ho miit aꞌbibi reꞌ ka maꞌkotoꞌ fa, aiꞌ ꞌbib-kase reꞌ mutiꞌ te, ho muhiin mak au es reꞌ ubaak ꞌaan ho nggoan.” ");
INSERT INTO aaz_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Rarit naiꞌ Laban anroim natuin am nak, “On reꞌ naan ate, reko.” ");
INSERT INTO aaz_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mes anbi neno naan, naiꞌ Laban anbatis aꞌbib-kasen reꞌ maꞌkotoꞌ, ma aꞌbib-kasen reꞌ metan. Rarit in nreun in aanh ein he natuuk muiꞌt ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Rarit sin neik muiꞌt ein naan annaon naꞌroon naꞌkon naiꞌ Yakop, neu baer jes reꞌ in aꞌroon ii tnao hae te neno teun feꞌe te naꞌ attea. Rarit naiꞌ Yakop natuuk in aam baabf ee in aꞌbibin ma ꞌbib-kaes aneist ein naan feꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Rarit naiꞌ Yakop ankeut naan hau-taef naꞌko hau humaꞌ teun. In nsapi ntui raan hau-taef ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","In ntao hau-taef ein reꞌ in ntui raan sin naan, anbin aꞌbai oe. Muiꞌt ein naan natiꞌ te anmaꞌteinꞌ ein nbin bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Onaim oras muiꞌt ein naan anmaꞌteinꞌ ein npaumaak hau taef matui raanf ein naan ate, sin of nahoin ein anaꞌ ꞌkotoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Rarit karu naiꞌ Laban in muiꞌt ein esan reꞌ he anmaꞌteinꞌ ein ate, naiꞌ Yakop naꞌekab sin neu aꞌbibi aiꞌ aꞌbib-kase reꞌ maꞌkotoꞌ. Rarit sin nahoin ein aan maꞌkotoꞌ msaꞌ. Nok ranan naan, in muiꞌt ein kuun naꞌbaab ok piut. Rarit in nbetis sin naꞌkon naiꞌ Laban iin ein. ");
INSERT INTO aaz_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Oras muꞌit mee reꞌ maꞌtaniꞌ naꞌteniꞌ te, naiꞌ Yakop antao hau taef reꞌ in nruun sin naan, antoom aꞌbai oe, reꞌ nhaumaak sin maatk ein. ");
INSERT INTO aaz_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mes karu in nkisu ma muꞌit mee nꞌoer oras he naꞌteniꞌ te, in ka ntao fa hau taef ein naan. Onaim naiꞌ Laban in napein muiꞌ maknaꞌu ma aꞌoret. Mes naiꞌ Yakop iin na ok-okeꞌ esan reꞌ apokat ma maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nok ranan naan ate, naiꞌ Yakop anjair atoin amuꞌit. In nmuꞌi ꞌbibi, ꞌbib-kase, bikaes unta, bikaes keledai, ma ate, reꞌ mfaun ii kah een. ");
INSERT INTO aaz_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Neot es, naiꞌ Yakop anneen niit naiꞌ Laban in aanh ein naꞌuab ein am nak, “Oras ia, naiꞌ Yakop anmuiꞌ batuur-batuur oo! In naꞌsusuꞌ niis hit amaꞌ in aꞌmuꞌin.” ");
INSERT INTO aaz_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Onaim naiꞌ Yakop ankius in aam baabf ee huumn ee te namet-meot gon, ma ka on fa reꞌ natiꞌ he reko. ");
INSERT INTO aaz_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Rarit UISNENO naꞌuab nok naiꞌ Yakop am nak, “Antean in oors aa goen, es reꞌ ia. Onaim ho ro he mfain nai meu ho ainaꞌ-amaꞌ sin. Au of ꞌok ko.” ");
INSERT INTO aaz_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Rarit naiꞌ Yakop anreun noꞌen bi Rahel ma bi Lea, he neman ma nateef nok ne nbi mneraꞌ huun, reꞌ sin muiꞌt ein baark ein. ");
INSERT INTO aaz_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Rarit in naꞌuab neu sin am nak, “Muniꞌ ia, au ꞌkius hi amaꞌ te, huumn ee metoꞌ-metoꞌ neu kau. Ma in ka nkisu ntoom kau fa msaꞌ on reꞌ natiꞌ-natiꞌ. Mes Uisneno, reꞌ au amaꞌ naꞌbees neu Na ji, nok kau. ");
INSERT INTO aaz_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Hi nua ki mihiin, aꞌroo-ꞌroo reꞌ ia, au ꞌmeup maꞌtaniꞌ ꞌeu hi amaꞌ! ");
INSERT INTO aaz_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mes maski on naan amsaꞌ, in napoi kau fani-fani. In naꞌbaniꞌ au baen sebaꞌ no boꞌes een. Maski on naan amsaꞌ, Uisneno npafaꞌ ma npanat kau. ");
INSERT INTO aaz_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Oras hi amaꞌ naꞌuab am nak, ‘Muiꞌ maꞌkotoꞌ sin anjarin ho baen puse-haet,’ muiꞌt ein nahoin ein aan maꞌkotoꞌ okeꞌ. In nmoeꞌ on naan neu kau fani-fani. ");
INSERT INTO aaz_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Uisneno nmoeꞌ on naan, he In nait hi amaꞌ in muiꞌt ein ma nfee kau sin. ");
INSERT INTO aaz_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Neot es, oras muiꞌt ein naan antotin he naꞌteinꞌ ein ate, au umnei mnak, areꞌ keosn ein okeꞌ reꞌ naꞌteinꞌ ein naan, nmuiꞌ maꞌkotoꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Rarit Uisneno In ameput naꞌko neno tunan, anhaman kau nbi mneit am nak, ‘Yakop!’ Rarit au utaah am ꞌak, ‘On mee, tua?’ ");
INSERT INTO aaz_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Onaim in natoon kau mnak, ‘Amkius feꞌ! Areꞌ keson reꞌ naꞌteinꞌ ein ia, suma nmuꞌi haa maꞌkotoꞌ. Au ꞌator on naan, natuin Au ꞌiit areꞌ saaꞌ-saaꞌ reꞌ naiꞌ Laban anmoeꞌ sin neu ko. ");
INSERT INTO aaz_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au reꞌ ia, Uisneno reꞌ nakriir On neu ko nbi Betel. Anbi nee, ho muhakeꞌ fatu, rarit amꞌoop minaꞌ, ma mꞌonen meu Kau. Rarit ho muhakeꞌ rais manbaꞌan mok Kau nbi nee. Oras ia, ho ro he mnao musaitan pah reꞌ ia, ma mfain meu ho ainaꞌ ma ho amaꞌ sin pah.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rarit bi Rahel ma bi Lea natahan am nak, “Es reꞌ ho. Hai mituin aah! Hai ka mmuiꞌ fa paaꞌ ma namaꞌ mtein miꞌko hai amaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aꞌroo-ꞌroo reꞌ ia, hai amaꞌ in naan kai on reꞌ atoin buti. In naꞌsosaꞌ nrair kai. Rarit in npaek nonin naan. ");
INSERT INTO aaz_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Areꞌ kanan aꞌmuꞌif reꞌ Uisneno nait sin naꞌko aam Laban naan, oras ia njair pusaak neu kit ma neu hit aanh ein. Onaim karu Uisneno nak on mee te, tatuin aah!” ");
INSERT INTO aaz_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Rarit naiꞌ Yakop nmurai nakbuaꞌ in baerꞌ ein. In nasaeb in fee-anah neu bikaes unta sin, ma napooꞌ neik in muiꞌt ein ok-okeꞌ, ma nasaeb neik baerꞌ ein reꞌ in napein sin anbin Padan Aram, he nnaon neun pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Oras naan, naiꞌ Laban annao nkateer in ꞌbib-kaesn ein sin fuunk ein. Onaim bi Rahel nabaak neik in aamf ee in faut-fuat marunaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Naiꞌ Yakop sin nfeen annaon mninuꞌ-mninuꞌ. Sin ka natonan fa in aam babaf. ");
INSERT INTO aaz_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","In neik nain in aꞌmuiꞌn ein ok-okeꞌ, rarit sin nnaon nok manapat ma nraak noe Efrat, onaim sin nnaon nꞌanin aꞌtoeꞌf ein Gireat. ");
INSERT INTO aaz_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ansoꞌop neno teun on nai te, naiꞌ Laban napein hanaf nak, naiꞌ Yakop anfeen naen anrair. ");
INSERT INTO aaz_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Rarit naiꞌ Laban noꞌen naꞌbuaꞌ iin na, ma sin nriuꞌ natuin in aan moen feuf naan. Sin anriuꞌ sin tar antea neno hiut, naꞌ napein sin nbin aꞌtoeꞌf ein Gireat. ");
INSERT INTO aaz_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Fain ite, Uisneno nakriir On neu naiꞌ Laban anbi mneit. In naꞌuab am nak, “Laban! Natiꞌ mpanat ho feef maan, oras ho muꞌuab mok naiꞌ Yakop.” ");
INSERT INTO aaz_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mabeꞌ naan, naiꞌ Yakop nahakeꞌ nrair tenas nbi ꞌtoeꞌf ein Gireat. Naiꞌ Laban sin nahaek ein tenas amsaꞌ, ka naꞌroo fa naꞌko bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Rarit naiꞌ Laban neem nateef nok naiꞌ Yakop. Onaim in naꞌuab am nak, “Yakop! Anmoeꞌ on mee mꞌes ho maen meik au aan feotn ii mninuꞌ-mninuꞌ? Ho on reꞌ meik tuaf reꞌ ho mheek maan sin anbin makenat. ");
INSERT INTO aaz_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Airoo, ho maen amninuꞌ-mninuꞌ. Ho ka mpaek fa atoran aꞌkreꞌo he musee kau, go! Karu ho mutoon kau rek-reko te, bait au ꞌfesat he useon ki eik marinet ma sakanat. ");
INSERT INTO aaz_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ho saant es antein, ho ka mfee kau fa mainuan he au ꞌtaeb ma ꞌneek aan au anah-upuf sin henaꞌ au useon sin. Ho ꞌmoeꞌm ii on reꞌ amoont aan! ");
INSERT INTO aaz_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Au he ꞌsirakab ko te, rabah! Mes fini na, Uisneno, reꞌ ho amaꞌ naꞌbees neu Na ji, nakain kau mnak, karu au uꞌuab ꞌok ko, au ro he ꞌpanat au fefak. ");
INSERT INTO aaz_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Au uhiin ꞌak ho mumnau ho kuan ee, he mfain. Mes nansaaꞌ am es ho mubaak meik au faut-fuat reꞌ maruun ein?” ");
INSERT INTO aaz_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Rarit naiꞌ Yakop nataah am nak, “Aam, kais mutoꞌon kau! Au ꞌfena ꞌnao mninuꞌ-mninuꞌ natuin au utiun gok, karu ho ka mroim fa he mkonan kau riꞌaan ein he nok kau te, of on mee?” ");
INSERT INTO aaz_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mes naiꞌ Yakop ka nahiin fa neu in fee bi Rahel es nabaak neik faut-fuat reꞌ maruun ein naan. Onaim in naꞌuab am nak, “Aam, reꞌ faut-fuat maruun ein naan ate, ho maim kuum! Karu ho mupein sin anbin sekau te, muꞌmate he. Ampukai hai bruaꞌ ein okeꞌ! Karu mupein ho baer pusaak bian amsaꞌ ate, mait mufaniꞌ sin. Maut he tuaf ein reꞌ ia njarin saksii.” ");
INSERT INTO aaz_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Rarit naiꞌ Laban anpoi ma ntaman sin teens ein meseꞌ-meseꞌ. Nahunun naiꞌ Yakop in tenas. Rarit bi Lea. Rarit neu bi Bilha ma bi Silpa sin imsaꞌ. Mes ka niit fa baerꞌ ein naan. Namuni te, in ntaam neu bi Rahel in tenas. ");
INSERT INTO aaz_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mes bi Rahel ankonob naꞌkoroꞌ faut-fuat maruun ein naan anbin aꞌpein bikaes unta. Rarit in ntook natau ꞌpeniꞌ naan. Naiꞌ Laban nparikas bi Rahel in teens ee naan ne ok-okeꞌ, mes ka napein fa baerꞌ ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Onaim bi Rahel naꞌuab nok in aamf ee mnak, “Aam honiꞌ, kais mutooꞌ. Au ka ꞌfeen fa, tua, natuin au upein funan.” Onaim naiꞌ Laban naim piut, mes ka niit fa faut-fuat maruun ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Naiꞌ Yakop natooꞌ ma huumn ee npuut, onaim in naskarak in aam babaf naiꞌ Laban am nak, “Au ureuꞌ ho saaꞌ? Tar ho mriuꞌ mutuin kau, on reꞌ au atoin aburarut kau. ");
INSERT INTO aaz_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ho mpukai murair areꞌ au baerꞌ ein ok-okeꞌ. Onaim ho mupein saaꞌ? Mait meik je neem meu matan ia he hit ttiit ok-okeꞌ. Maut he hit aok-bian sin reꞌ ia, nafeek nitan nak bareꞌ naan, sekau iin ja. ");
INSERT INTO aaz_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Toon boꞌ nua goen au ꞌaetn ok aꞌbi ko. Oras au utuuk ho muiꞌt ein naan, ka ti-tiit fa es he nropoꞌ. Au ka ꞌtuun he ꞌeuk ꞌiit fa meseꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Karu nmuiꞌ muiꞌ fui naꞌmaet ho muiꞌt ein, au ka utoon ko fa, mes au ꞌsekaꞌ sin, tua. Karu nmuiꞌ tuaf nabaak naan ho ngguin, ho mreun kau he ꞌsenuꞌ, maski au ka ꞌsaan fa. ");
INSERT INTO aaz_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Man-mana te, maans ee nraar kau. Fa-fai te, au ꞌmaniik tar uꞌtaꞌi ꞌmaet. Au ꞌbeeꞌ, ma ka ꞌtuup reko fa, natuin au ꞌpanat ho muiꞌt ein naan, tua. ");
INSERT INTO aaz_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Toon boꞌ nua naan namneo! Au ꞌmeup toon boꞌes am haa he ꞌsao ho aan feton. Rarit aꞌkuri ꞌtein toon nee, he ꞌheit. Au ꞌaetn ok aꞌroo-ꞌroo reꞌ naan, mes ho mubanit au baen sebaꞌ naan no boꞌes. ");
INSERT INTO aaz_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ken-kenuꞌ te, anmuiꞌ Uisneno reꞌ au naꞌi naiꞌ Abraham ma au amaꞌ naiꞌ Isak naꞌbesan neu Ne. Karu In ka npanat kau fa te, ho mriꞌu mrair kau, ma au ꞌfeen aꞌnao ruum-ruum aah. Mes Uisneno ka nforon ma nkoson fa au susat. In niit kau neu au ꞌmeup maꞌtaniꞌ. Es naꞌ fini na, In neem ma nakain ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Anneen naiꞌ Yakop naꞌuab on naan ate, naiꞌ Laban nataah am nak, “Henat on nai! Bifee nuaꞌ ein naan, au aanh ein. Riꞌaan ein reꞌ sin nahoniꞌ sin naan, sin au upuꞌ ok-okeꞌ. Muiꞌt ein reꞌ ia, batuur au nggoa. Areꞌ saaꞌ-saaꞌ reꞌ ho miit sin nbin ia, au nggoa. Mes au he unsaaꞌ? Au ka ubeiꞌ fa he ꞌtahan sin. ");
INSERT INTO aaz_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Onaim reko nneis hit nua kit tahakeb rais manbaꞌan. Ma hit nua kit ro he tmoin tatuin hit rais manbaꞌan naan.” ");
INSERT INTO aaz_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Rarit naiꞌ Yakop nait faut kouꞌ goes, ma nahaekb ee nbi naan, he njair tanar. ");
INSERT INTO aaz_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Rarit naiꞌ Yakop anreun in ameupt ein he nkaubuub ein fatu, ma ntupuꞌ sin. Onaim sin ntokon ma nbukaen buꞌ-buaꞌ mpaumaak fatun naan. ");
INSERT INTO aaz_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Onaim naiꞌ Laban nakanab faut tunab naan am nak, Yegar Sahaduta. Mes naiꞌ Yakop nakaanb ee, Galeet. ");
INSERT INTO aaz_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Rarit naiꞌ Laban naꞌuab am nak, “Faut tunab ia, njair tanar reꞌ nsaksii hit rais manbaꞌan.” Es naan ate, bare naan, in kaan ee, Galeet. ");
INSERT INTO aaz_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Naiꞌ Laban nakanab bare naan amsaꞌ nak, Mispa (reꞌ he noi on reꞌ kata bian reꞌ in aꞌmoufn ii ‘baer paot reꞌ naꞌraat’), natuin in naꞌuab am nak, “UISNENO of neikn On ansuntiur kit, he maski hit nua kit atmakaꞌroon amsaꞌ, hit kais attanhai hit rais manbaꞌan ia. ");
INSERT INTO aaz_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Karu ho mmoeꞌ amreꞌut meu au aanh ein ii, aiꞌ amsao bifee sonaꞌ, au of ka uhiin fa. Mes mumnau! Uisneno njair saksii neu hit nua kit. ");
INSERT INTO aaz_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Amkius miit faut ahaket ia, ma faut tuunb ein ia. Mumnau! Fatun reꞌ ia amsaꞌ, njarin nakat. Ho ka mubeiꞌ fa he mtanhai fatun reꞌ ia, he mmoeꞌ amreꞌut meu kau. Ma au on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hit tahakeꞌ rais manbaꞌan ia, tpaek hit beꞌi-naꞌi sin Uisneno. Esan reꞌ ho naꞌi naiꞌ Abraham, ma au naꞌi naiꞌ Nahor sin Uisneno. In of neikn On anjair Afeek Rasi neu hit rasin.” Anneen anrair on naan ate, naiꞌ Yakop ansuup anpaek kanaf Uisneno reꞌ in amaf naiꞌ Isak naꞌruriꞌ ma naꞌbees neu Ne. ");
INSERT INTO aaz_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Rarit naiꞌ Yakop anroor muꞌit, in nait neik sin siisk ein ma nafuat sin neun Uisneno nbin aꞌtoeꞌf ein naan. Onaim in naskau tuaf ein reꞌ anbin naan, ma sin nbukaen buꞌ-buaꞌ, ma nbeꞌen tar anmeu nfiin. ");
INSERT INTO aaz_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kik-kiuk anaꞌ on naan ate, naiꞌ Laban nhoo ma nneek in anah-upuf sin ok-okeꞌ. Rarit in naꞌuab anfeen sin tetus, ma ntebi nfain neu in pah. ");
INSERT INTO aaz_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Rarit naiꞌ Yakop sin nnaon nkonon. Onaim Uisneno In ameupt ein naꞌkon neno tunan neman ma nateef nok ne. ");
INSERT INTO aaz_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Oras niit sin on naan ate, in naꞌuab am nak, “Reꞌ bare ia, Uisneno In soraurs ein bare snasat!” Etun sin nakanab bare naan, Mahanaim, (reꞌ in aꞌmoufn ii nak ‘bare snasat manaꞌ nua’). ");
INSERT INTO aaz_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Rarit naiꞌ Yakop anreun in ameput tuaf fauk nnaon nahunun neun pah Edom (es reꞌ Seir), he nfee hanaf neu in tataf naiꞌ Esau, nak in he neem. ");
INSERT INTO aaz_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Naiꞌ Yakop naꞌuab neu in ameupt ein naan am nak, “Hi mnao meik hanaf meu au tataꞌ naiꞌ Esau mmak, ‘Aam Esau! Ho ate naiꞌ Yakop kau aꞌsonuꞌ haan buseet ma hormaat ꞌeu ko, tua. Naꞌko afi unuꞌ tar antea oras ia, ho ate kau, utua ꞌbi hit baab mone naiꞌ Laban in umi. ");
INSERT INTO aaz_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Oras ia, ho ate kau gui, aꞌmuiꞌ bijae, bikaes keledai, ꞌbibi, ma ꞌbib-kase. Au ꞌmuiꞌ ate msaꞌ, et atoniꞌ ma bifee. Au ꞌreek tuaf ein reꞌ ia, he neik ko hanaf, nak au he ꞌuum. Au ufnekan aꞌbi au nekak, henatiꞌ ho mtoup kau ꞌnimaꞌ nua, tua.’ ” Onaim tuaf ein naan annaon. ");
INSERT INTO aaz_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Oras sin nfain neman neun naiꞌ Yakop, sin neikin hanaf am nak, “Hai mnao miteef amrair mok ho tataꞌ naiꞌ Esau. Oras ia in neem ma nok tuaf natun haa, he nateef nok ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Anneen on naan ate, naiꞌ Yakop in ansaon ee tepo-tepo, ma in namtau nmaet. Rarit in nbait in ameupt ein ma muiꞌt ein ok-okeꞌ, anjarin pukan nua. ");
INSERT INTO aaz_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","In natenab am nak, “Karu naiꞌ Esau neem ma nbaan pukan ahuunt ee, pukan amuint ee naenan he napenin fetin.” ");
INSERT INTO aaz_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Rarit naiꞌ Yakop anꞌonen am nak, “Koi, Uisneno! Usiꞌ reꞌ au naꞌi naiꞌ Abraham ma au amaꞌ naiꞌ Isak naꞌruriꞌ ma naꞌbees neu Ko! Amneen maan kau feꞌ, tua. Uisneno, neon goes ii, Ho es reꞌ amreek kau he ꞌfain ꞌuum ꞌeu au umi ma au nonot-asar, ꞌbi pah reꞌ ia. Ho es reꞌ ambaꞌan kau mmak, Ho of amꞌator he murekoꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au reꞌ ia, atoin ka masoꞌik fa, mes Ho manekam meu kau nabar-baar. Unuꞌ te, oras au ꞌraak noe Yarden reꞌ ia, au ꞌeiki haa teas. Mes oras ia, au ꞌfain ꞌuum ꞌeik tuaf pukan nua ma muꞌit amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au umtau, kais-kaisaꞌ au tataꞌ naiꞌ Esau neem ma nbaan niis kai. Onaim au ꞌtoit Ko Usiꞌ he mufetin maan kai naꞌko naiꞌ Esau in aꞌniman. Hai arkai es reꞌ: au, ma au fee-anah sin, ma au ate sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Usiꞌ, Ho es ambaꞌan mak, Ho es reꞌ mfee kau tetus anho-hoen, ma mfee kau sufaꞌ-kaꞌuf on reꞌ snaen ein et tais je ninin, reꞌ biak ein ka nsoik nabeiꞌ sin fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Rarit naiꞌ Yakop antuup anbi bare naan. Nokaꞌ on naan ate, in nabarab muꞌit he nꞌook-soun sin neun in tataf. ");
INSERT INTO aaz_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","In npiir naan aꞌbib ainaf natun nua, ꞌbib keso boꞌ nua, ꞌbib-kaes ainaf natun nua, ꞌbib-kaes keso boꞌ nua, ");
INSERT INTO aaz_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","bikaes unta ainaf boꞌ teun reꞌ nasuus ein feꞌ, bijae ainaf boꞌ haa, bijae keso boꞌes, bikaes keledai ainaf boꞌ nua, ma bikaes keledai mone boꞌes. ");
INSERT INTO aaz_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Rarit, in nbait muiꞌt ein naan, huum es ate neu puukn es. In nfee pukan es ate nok in atukus. In natonan sin am nak, “Hi mnao mihuun. Au utuin ki ꞌbi hi kotim. Hi mnao, mes pukan es nok pukan es ate sero mmakaꞌroon.” ");
INSERT INTO aaz_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Rarit naiꞌ Yakop naprenat aꞌnakat neu pukan ahuunt ee mnak, “Karu au tataꞌ naiꞌ Esau nateef nok ko, ma in nataan am nak, ‘Ho he mnao on mee? Sekau in ameupt ee, es reꞌ ho? Muiꞌt ein reꞌ ia, sekau iin na?’ ");
INSERT INTO aaz_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ho mutaah am mak, ‘Muiꞌt ein reꞌ ia, ho ate naiꞌ Yakop iin na, tua. In nsonuꞌ sin neu in tataf, aam usiꞌ naiꞌ Esau. In et reꞌ munin.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","In naprenat on reꞌ naan amsaꞌ neu atukus pukan bian am nak, “Karu hi miteef mok au tataꞌ naiꞌ Esau, hi mnoon ee muiꞌt ein reꞌ ia. Rarit hi mitoon ee mak, au et reꞌ munin.” Naiꞌ Yakop natenab am nak, karu in nfee muiꞌt ein reꞌ naan ok-okeꞌ te, naiꞌ Esau of neekn ee nsesuum ma nmuniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Onaim in nsonuꞌ muiꞌt ein naan nahunun. Mes mabeꞌ naan, in ntuup nabaar anbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mabeꞌ naan, naiꞌ Yakop anfeen ma nꞌator in fee ngguin nua sin, in aten reꞌ in npanaꞌ sin, ma in aanh ein boꞌes am meseꞌ, he sin nnaon nrakan neun noe Yabok in panin. ");
INSERT INTO aaz_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Oras sin arsin antean noe naan in panin, in nsonuꞌ in pusaak ein ok-okeꞌ neun ne. ");
INSERT INTO aaz_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mes naiꞌ Yakop namaik anmees anbi noe je panin. Rarit atoin es neem. Atoniꞌ naan nok naiꞌ Yakop anmaboon ein anbi naan, tar antea neis noi nmeu. ");
INSERT INTO aaz_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Oras atoniꞌ naan annaben nak, naiꞌ Yakop he niis ee jen ate, in ntuuf naiꞌ Yakop in aꞌbokon, tar antea in nuin pusun uun ne natposiꞌ npoi naꞌko in tarun. ");
INSERT INTO aaz_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Onaim atoniꞌ naan naꞌuab am nak, “Mufetiꞌ kau. Kreoꞌ goes te maans ee he npeeꞌ jen.” Mes naiꞌ Yakop nataah am nak, “Ho muꞌuab amfee kau tetus feꞌ, naꞌ au ufetiꞌ ko.” ");
INSERT INTO aaz_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Onaim atoniꞌ naan, nataan ee mnak, “Ho kaan maan sekau?” In nataah am nak, “Naiꞌ Yakop.” ");
INSERT INTO aaz_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Rarit atoniꞌ naan naꞌuab am nak, “Ho kanam naan, ka naiꞌ Yakop fa heen. Mes anmurai oras ia, atoniꞌ anteek ko nak, naiꞌ Israꞌel (reꞌ in aꞌmoufn ii, ‘nmabonan nok Uisneno’), natuin ho mmabonan maꞌtaniꞌ mok mansian ma mok Uisneno, tar antea ho miis.” ");
INSERT INTO aaz_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Onaim naiꞌ Yakop nataan am nak, “Ho kaan maan sekau?” Mes atoniꞌ naan nataah am nak, “Ho he mutaan au kaank ii he saaꞌ?” Rarit in naꞌuab anfee tetus neu naiꞌ Yakop anbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Onaim naiꞌ Yakop naꞌuab am nak, “Au ꞌiit aꞌrair Uisneno humaf nok humaf, mes au ꞌmoin feꞌ.” Natuin rasi naan ate, in nakanab bare naan, Peniꞌel (reꞌ in oetn ii, ‘Uisneno In human’). ");
INSERT INTO aaz_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Oras maans ee nsae nrari te, naiꞌ Yakop annao nkoon, nasaitan bare naan. Mes in nsereꞌ, natuin in pusun uun ee nasuir. ");
INSERT INTO aaz_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Etun antea oras ia, atoin Israelas sin ka nekun fa sisi naꞌko muiꞌt ein sin pusuk uuk ein, natuin Uisneno ntuuf nasurib sin aam uuf naiꞌ Yakop in nuin pusun uun. ");
INSERT INTO aaz_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Neno naan, naiꞌ Yakop niit naiꞌ Esau neem neik atoniꞌ tuaf natun haa. Rarit in nbait in aanh ein es-es ate nok sin ainaf. ");
INSERT INTO aaz_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","In nahunub in aten reꞌ in panaꞌ sin naan nok sin aanh ein antoman maat. Rarit bi Lea nok in aanh ein, naꞌ nbi muin ii te, bi Rahel nok in anah naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mes naiꞌ Yakop annao nahun-hunu nbi maat. Oras he noi npaumaak in taatf ee te, in nriꞌtuu ma naꞌbees nafan-fain no hiut. ");
INSERT INTO aaz_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mes oras naiꞌ Esau niit in orif naiꞌ Yakop, in nan-naen aah he nateef ee. Rarit in nhoo ma nneek ee suuk aꞌroo. Ma sin nua sin ankaen npin-piuns ein. ");
INSERT INTO aaz_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Oras naiꞌ Esau niit bifeen naan ma riꞌaan ein naan ate, in nataan am nak, “Tuaf amfa-faun ia, sekau ngguin aa?” Onaim naiꞌ Yakop nataah am nak, “Sin reꞌ ia, tuaf ein reꞌ Uisneno nfee sin neu ho ate kau.” ");
INSERT INTO aaz_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Rarit in fee paan ein naan, ma sin aanh ein neman ma naꞌbesan neun naiꞌ Esau. ");
INSERT INTO aaz_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Rarit bi Lea nok in aanh ein neman ma naꞌbesan neun naiꞌ Esau. Namuni te, naiꞌ Yusuf nok in ainaf bi Rahel neman ma naꞌbesan neun naiꞌ Esau. ");
INSERT INTO aaz_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Rarit naiꞌ Esau nataan am nak, “Pukan ahuunt ein reꞌ ho mreek sin neun nahuun am neikin muꞌit naan, ho sairt ii saaꞌ?” Rarit naiꞌ Yakop nataah am nak, “On nai, taat! Au ꞌfee ko sin ruum-ruum, henatiꞌ ho mtoup kau nok neek mainuan ma marine.” ");
INSERT INTO aaz_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mes naiꞌ Esau nataah ee mnak, “Ako! Au ꞌmuiꞌk ein amfaun amsaꞌ. Onaim kais amfee kau saaꞌ-saaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Rarit naiꞌ Yakop nataah am nak, “Taat honiꞌ, kais mutenab on naan. Ho ro he mtoup sin, he njair tanar nak, ho mtoup kau nok ꞌnimaꞌ nua. Natuin oras au ꞌiit ko mkumain feꞌe na, on reꞌ au ꞌiit Uisneno nkumain. ");
INSERT INTO aaz_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Onaim au ꞌtoit ko taat honiꞌ, maut he ho mtoup au ꞌook-soun ein naan, natuin baerꞌ ein naan sin ka maꞌoos ein fa. Uisneno nneek niis kau, es naꞌ In nfee kau areꞌ saaꞌ-saaꞌ, natuin au ꞌperluut ein.” Naiꞌ Yakop anfuriꞌ in tataf naiꞌ Esau, tar antea in nroim. Onaim naiꞌ Esau ntoup ook-soun ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Rarit naiꞌ Esau naꞌuab am nak, “Karu on naan ate, hi mibarab he tnao nai! Au of aꞌnao ꞌaat ki.” ");
INSERT INTO aaz_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mes naiꞌ Yakop nataah am nak, “Anbain kuun, taat. Amkius kuum. Riꞌaan ein feꞌ ba-baun ein. Onaim sin ka neu he nnaon fa rab-raab. Muꞌit bian feꞌ nahoin ein. Karu hit taksekeꞌ sin he nnaon rab-raab neno mees ahaa te, muiꞌt ein ia of anmaten okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Onaim reko nneis, ho muhuun. Hai mnao kreꞌo-kreꞌo ma mituin ki ambi hi kotim. Au of ꞌuum he ꞌmakius ko on Seir.” ");
INSERT INTO aaz_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Rarit naiꞌ Esau naꞌuab antein am nak, “Karu on naan ate, au umaikaꞌ au ameput bian he nok ko, he sin njarin maat ranan neu ki.” Mes naiꞌ Yakop nataah am nak, “Kais muhaeb om! Asar au uhini ꞌrair ꞌak ho mtoup kau goen.” ");
INSERT INTO aaz_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Anneen on naan ate, naiꞌ Esau nnao nasaitan sin, he nfain neu Seir. ");
INSERT INTO aaz_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mes naꞌko bare naan ate, naiꞌ Yakop annao neu Sukot. Anbi naan, in nmoeꞌ umi, ma nmoeꞌ oꞌof neu in muiꞌt ein ok-okeꞌ. Etun sin nakanab bare naan, Sukot (reꞌ in oetn ii nak, ‘umi reꞌ he natuan ntaah ein’). ");
INSERT INTO aaz_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Onaim naiꞌ Yakop sin ntean nok ao-minaꞌ neun kuan Sikem et pah Kanaꞌan, naꞌkon Padan Aram. Rarit sin paasn ein tenas, ma natuan npaumak-maak kuan naan. ");
INSERT INTO aaz_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Afu reꞌ sin natuan reꞌ naan, naiꞌ Yakop ansoos nafeek ee naꞌko naiꞌ Hemor, naiꞌ Sikem in amaf. In nbaen ee neik roi mutiꞌ fuaꞌ nautn es. ");
INSERT INTO aaz_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Anbi naan, in nbaik fatu he nmoeꞌ mei fuat. Rarit in nakanab bare naan, El-Elohe-Israꞌel (reꞌ in aꞌmoufn ii, ‘Uisneno naan, Israꞌel in Uisneno’). ");
INSERT INTO aaz_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Neot es, bi Dina, reꞌ naiꞌ Yakop ma in fee bi Lea sin aan feto, annao nmakius nok riꞌ feot muinf ein bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Anbi pah naan, in uisf ee, kaan ee naiꞌ Hemor, naꞌko uuf Hebis. In aan moen je, kaan ee naiꞌ Sikem. Neot es, naiꞌ Sikem niit bi Dina. Onaim in nheek je, rarit in nkoin je nok aꞌsekeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Naiꞌ Sikem antaam nekan bi Dina. Onaim naiꞌ Sikem ankopoꞌ bi Dina, he karu reko te, bi Dina nroim natuin. ");
INSERT INTO aaz_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Rarit naiꞌ Sikem naꞌuab neu in aamf ee mnak, “Aam! Reko te, ho mtaman mtoit bi Dina, he au ꞌsao.” ");
INSERT INTO aaz_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Oras Naiꞌ Yakop anneen nak anmuiꞌ atoin es ankoin in aan feto nok aꞌsekeꞌ, in ntaaꞌ-taaꞌ kuun, ma ka nmoeꞌ fa saaꞌ-saaꞌ. Natuin oras naan, in aan moen ein natukun muꞌit anbin amneraꞌ huun. Onaim in npao sin tar sin nfain neman ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Oras naan, naiꞌ Sikem in amaf naiꞌ Hemor, neem neu naiꞌ Yakop, he ntaam antoit bi Dina. ");
INSERT INTO aaz_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oras sin nua sin naꞌuab ein ate, naiꞌ Yakop in aan moen ein, anfain neman naꞌkon amneraꞌ huun. Onaim oras sin nnenan nak naiꞌ Sikem ankoin sin feotf ee nok aꞌsekeꞌ te, sin neek ein namenan, ma sin natoꞌon mates. Rarit sin naꞌuab ein am nak, “Rasi on reꞌ naan, ka nabeiꞌ fa he njari nbi pah Israꞌel! Onaim ka nabeiꞌ fa he hit tkonan moeꞌ reꞌuf on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Onaim naiꞌ Hemor nfuriꞌ naiꞌ Yakop am nak, “Aam Ako! Batuur, au anah naiꞌ Sikem antaam nekan ho aan feto bi Dina. In nroim he nsao. Onaim au ꞌtoit ko henatiꞌ karu reko te, mfee kai ho anah bi Dina he au anah naiꞌ Sikem ansao. ");
INSERT INTO aaz_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Karu reko te, hit aanh ein anmatsaon. Hi aan moen ii, ansao hai aan feton. Ma hai aan moen ein, ansao hi aan feton. ");
INSERT INTO aaz_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Maut he hi mitua mibua mok kai msaꞌ ambi reꞌ ia. Hi mroim kiim he mitua mbi mee-mee jah. Rarit hi mrakan, ma mipeni ꞌmuꞌif ambi ia.” ");
INSERT INTO aaz_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Rarit naiꞌ Sikem naꞌuab nok bi Dina in amaf, ma in naof ein am nak, “Hi mtoit saaꞌ-saaꞌ aah, au utuin ki. Hi he mtoit roit he utai ufaniꞌ bi Dina, ma noni fak-fauk aah, au ꞌbaen! Asar hi mroim he au ꞌsao hi fetoꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mes naiꞌ Yakop in aan moen ein nahini nrarin nak naiꞌ Sikem nkoin bi Dina nok aꞌsekeꞌ. Onaim sin naꞌuab anroroꞌ naiꞌ Sikem ma in amaf naiꞌ Hemor. ");
INSERT INTO aaz_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Sin natahan am nak, “Ka nabeiꞌ fa he hai misaob hai fetoꞌ nok atoniꞌ reꞌ ka maꞌheriꞌ fa! Rasi naan, antao namaeb kai! ");
INSERT INTO aaz_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mes in raan aꞌpoiꞌ ji on nai. Hi atoniꞌ bare ia, et anaꞌ-koꞌu, ro he miꞌheriꞌ on reꞌ hai. ");
INSERT INTO aaz_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Karu hi mmoeꞌ on naan ate, naꞌ hit matsao bian am bian. Ma hai of mitua mibua mok ki msaꞌ ambi ia, he hit arkit atjair on reꞌ pah meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mes karu hi ka mmoeꞌ mituin fa hai roim ein, ma ka mroim fa he miꞌheriꞌ te, hai mtoup mifaniꞌ hai fetoꞌ, rarit hai mnao misaitan bare ia.” ");
INSERT INTO aaz_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Naiꞌ Hemor ma naiꞌ Sikem antoup sin uabk ein naan nok reko. ");
INSERT INTO aaz_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mes naiꞌ Sikem ka nsabaar naan fa in tuan, natuin in ntaam nekan bi Dina. Amneon ii, abitan pah naan anhormaat naiꞌ Sikem. ");
INSERT INTO aaz_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Onaim naiꞌ Hemor ma naiꞌ Sikem annaon neun bare feek rasi kuan naan, et enoꞌ he ttaam teu kuan, ma nabuan am naꞌuab ein nok abitan pah naan. Sin naꞌuab ein am nak, ");
INSERT INTO aaz_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Aok-bian arki! Atoin Israelas sin reꞌ ia anromin he nmonin nabu-buan nok kit anbin mamut. Onaim maut he sin natuan nok kit nbin hit pah reꞌ ia. Hit pah reꞌ ia seor mainuan neu kit ok-okeꞌ. Hit aan moen ein bisa nsao sin aan feton. Ma sin aan moen ein msaꞌ bisa nsao hit aan feton. ");
INSERT INTO aaz_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sin suma ntotin rais aanꞌ-aanꞌ es naꞌko kit. Rasi naan es reꞌ, hit ar-arkit atoniꞌ et anaꞌ-koꞌu, mnasif-mainukiꞌ ro he taꞌheriꞌ on reꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Karu hit tmoin tabu-bua tok sin, sin muiꞌt ein, ma sin aꞌmuiꞌk ein ok-okeꞌ anjarin hit pusaak ein amsaꞌ, aiꞌ? Onaim reko nneis hit ttoup sin haan totis naan. Iim he ar-arkit taꞌheriꞌ ok-okeꞌ! On mee? Hi mromi, oo?” ");
INSERT INTO aaz_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Rarit atoin ein reꞌ nabuan nbin naan, nroim natuin naiꞌ Hemor ma naiꞌ Sikem sin uabk ein naan. Onaim atoin ein bare reꞌ naan, sin naꞌheir ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Neno tenu te, oras sin npaap ein feꞌ namenan, bi Dina in naof naiꞌ Simeon ma naiꞌ Lewi, nait neik sin suin ein ma ntaman amninuꞌ-mninuꞌ neu kuan naan. Onaim sin nroor niis atoin ein naan okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Naiꞌ Hemor ma naiꞌ Sikem amsaꞌ, sin nroor sin. Rarit sin nok nafaniꞌ sin fetof bi Dina naꞌko naiꞌ Sikem in umi, ma nfanin neun sin umi. ");
INSERT INTO aaz_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Rarit naiꞌ Yakop in anah bian sin, antaman neun pah naan, ma nasiik neik pah naan in afan. Sin natoꞌon, natuin anmuiꞌ tuaf ankoin sin feotf ee nok aꞌsekeꞌ nbi bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sin nasiik neik biak ein sin baerꞌ ein okeꞌ naꞌkon sin uimn ein naank ein. Ma sin napooꞌ neik biak ein sin muiꞌt ein amsaꞌ naꞌkon amneraꞌ huun. ");
INSERT INTO aaz_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Sin nheek neik bifee ngguin, riꞌaan ein, ma nasiik pah naan in baer maꞌoos ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Oras naiꞌ Yakop nahiin rasi naan ate, in naꞌuab neu naiꞌ Simeon am naiꞌ Lewi mnak, “Nansaaꞌ am es hi mtao maan kit rais reꞌuf ia? Hi misusab kau! Of abitan Kanaꞌan, abitan Peris, ma areꞌ abitan pah reꞌ ia, natoꞌon niis kau. Sin nmuꞌin tuaf amfaun. Hit suma fuaꞌ fauk aah. Karu sin neman nbaan kit ate, hit treꞌu tkoon.” ");
INSERT INTO aaz_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mes sin natahan nok haan toꞌos am nak, “Aam! Ho mutenab ate, mak aiꞌ hai he mkonan sin he nmoeꞌ hai fetoꞌ on reꞌ bifee aꞌhakeꞌ, aa oo?” ");
INSERT INTO aaz_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Rarit Uisneno naꞌuab nok naiꞌ Yakop am nak, “Au reꞌ ia, Uisneno reꞌ nakriir On neu ko, oras ho maen muꞌko ho tataꞌ naiꞌ Esau. Oras ia, ho mfooꞌ nai muꞌko bare ia meu Betel. Amtea nee te, ambaik mei fuat ma mfee fuaꞌ-turuꞌ meu Kau. Rarit ho mutua mubaar ambi naan nai.” ");
INSERT INTO aaz_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Rarit naiꞌ Yakop naꞌuab nok in uim je naan ee ok-okeꞌ mnak, “Oras ia, hit he tnao teu Betel. Unuꞌ te, oras au ꞌbi susat nanaꞌrenat, Uisneno nturun kau nbi nee. Au he ꞌmoeꞌ mei fuat aꞌbi bare naan. Onaim oras ia, hi mait imporin hi faut-fuat reꞌ maruun ein okeꞌ. Mikninuꞌ hi tuam, ma msekaꞌ hi baer paken, natuin hit he taꞌruriꞌ ma taꞌbees teu Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Onaim sin nnonaꞌ sin faut-fuat reꞌ maruun ein ma sin faorn ein amsaꞌ. Rarit naiꞌ Yakop antoup sin ma nsuub sin nbi hau kouꞌ goes in uun, anpaumaak kuan Sikem. ");
INSERT INTO aaz_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Oras naiꞌ Yakop sin nnaon nasaitan Sikem, Uisneno nfee rasi mtaus neu too pah anfuun am nateef, tar antea sin ka nabranin fa he ntaon rais reꞌuf neu naiꞌ Yakop sin. ");
INSERT INTO aaz_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Onaim naiꞌ Yakop nok in too pukan naan, antean nok mamut anbin Betel et pah Kanaꞌan. (Betel naan, unuꞌ feꞌe te, in kaan ee, Lus.) ");
INSERT INTO aaz_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Anbi naan, naiꞌ Yakop anbaik fatu njair mei fuat. Rarit in nakanab bare naan nak El Betel (reꞌ in oetn ii nak, ‘Betel in Uisneno’), natuin unuꞌ te Uisneno nakriir On neu naiꞌ Yakop anbi naan, oras in naen nasaitan in tataf. ");
INSERT INTO aaz_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Anpaumaak kuan Betel, anmuiꞌ hau uuꞌ kouꞌ goes reꞌ atoniꞌ nakaanb ee, Aron Bakut. In aꞌmoufn ii nak, ‘hau meꞌ-meꞌur’. In napein kanaf naan, natuin oras bi Ripka in bifee atitus, es reꞌ bi Debora nmaet, sin nsuub ee nbi hau naan in uun. ");
INSERT INTO aaz_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Neon goes ii, oras naiꞌ Yakop anfain neem naꞌko Padan Aram, Uisneno nakriir On antein, ma nfee ne tetus-athoen. ");
INSERT INTO aaz_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Uisneno naꞌuab am nak, “Anmurai oras ia, ho kaan maan ka naiꞌ Yakop antein fa goen. Mes Au ukanab ko ꞌeik kaan feꞌu es, es reꞌ Israꞌel. ");
INSERT INTO aaz_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au reꞌ ia, Uisneno reꞌ Akuaas Reꞌuf. Onaim ho muhoniꞌ ma musuuf amfa-faun. Uuf-uuf ma pah-pah of anpoin ma nboran naꞌkon ho sufam ma ho kaꞌum sin. Ma ho of muhoniꞌ maan usif-usif amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Pah reꞌ nahunu te Au ꞌfee je ꞌeu ho naꞌi naiꞌ Abraham ma ho amaꞌ naiꞌ Isak naan, oras ia Au ꞌfee ko goe, ma ho sufam-kaꞌum sin.” ");
INSERT INTO aaz_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Uisneno naꞌuab anrair on naan ate, naiꞌ Yakop nahakeꞌ fatu nbi naan, he njair tanar he namnau Uisneno In rais manbaꞌan. Rarit in nꞌoop tua min-kase, ma minaꞌ anbi fatu naan, ma nꞌonen neu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","In nakanab bare naan, Betel. ");
INSERT INTO aaz_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Rarit naiꞌ Yakop sin annaon nasaitan Betel. Oras sin he noi nhaumaak kuan Efrata (es reꞌ Betlehem), antea in oors aa goen he bi Rahel nahoniꞌ. Mes in nahoniꞌ nok susat. ");
INSERT INTO aaz_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Oras in nakes-kees feꞌ, bifee atuis ee natoon ee mnak, “Ain Rahel! Amhaꞌtain ho neek maan. Ho aanh ii mone!” ");
INSERT INTO aaz_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Oras bi Rahel he noi natfeek, in nakanab riꞌanaꞌ naan, naiꞌ Ben-Oni (reꞌ in aꞌmoufn ii, ‘riꞌanaꞌ naꞌko au susat-nanaꞌrenat’). Rarit in natfeek. Mes naiꞌ Yakop nakanab riꞌanaꞌ naan, naiꞌ Benjamin (reꞌ in oetn ii nak, ‘riꞌanaꞌ nbi au ꞌnimak aꞌneꞌu’). ");
INSERT INTO aaz_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rarit sin nsuub bi Rahel nbi ranan reꞌ he tnao teu Efrata in ninin, (reꞌ oras ia in kaan ee, Betlehem). ");
INSERT INTO aaz_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Rarit naiꞌ Yakop nahakeꞌ faut natef es anbi naan. Bi Rahel in faut natef naan, et na feꞌ, tar antea oras ia. ");
INSERT INTO aaz_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Rarit naiꞌ Yakop nananiꞌ bare piut-piut. Neot es, in nahakeꞌ tenas anbi tobe baik maꞌnopoꞌ Eder in aon bian. ");
INSERT INTO aaz_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Oras sin nbin naan ate, naiꞌ Ruben antuup nok in aamf ee in fee panaꞌ bi Bilha. Naiꞌ Yakop nahiin rasi naan. Naiꞌ Yakop in aan moen ein, tuaf boꞌes am nua. ");
INSERT INTO aaz_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bi Lea in aanh ein esan reꞌ: naiꞌ Ruben (naiꞌ Yakop in aan moen unu), naiꞌ Simeon, naiꞌ Lewi, naiꞌ Yahuda, naiꞌ Isaskar, ma naiꞌ Sebulon. ");
INSERT INTO aaz_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bi Rahel in aanh ein esan reꞌ: naiꞌ Yusuf ma naiꞌ Benjamin. ");
INSERT INTO aaz_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bi Rahel in ate bi Bilha in aanh ein esan reꞌ: naiꞌ Dan ma naiꞌ Naftali. ");
INSERT INTO aaz_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Rarit bi Lea in ate bi Silpa in aanh ein esan reꞌ: naiꞌ Gat ma naiꞌ Aser. Nahonis riꞌaan ein naan anbin Padan Aram. ");
INSERT INTO aaz_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Rarit naiꞌ Yakop nnao nmakius in amaf naiꞌ Isak anbi Mamre anpaumaak kuan Kiryat-Arba (kuan naan, oras ia, in kaan ee, Hebron). Unuꞌ te, in naꞌif naiꞌ Abraham natua nbi bare naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Naiꞌ Isak anmoin naan toon nautn es boꞌ fanu te (180), naꞌ in nmaet. Rarit in anah naiꞌ Esau ma naiꞌ Yakop, ansuub ee. ");
INSERT INTO aaz_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Naiꞌ Esau in sufan-kauꞌn ein esan reꞌ ia. In kanan es antein, es reꞌ naiꞌ Edom. ");
INSERT INTO aaz_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Naiꞌ Esau nsao riꞌ feot munif nua naꞌkon pah Kanaꞌan. Tuaf es, bifee naꞌko atoin Hetes, kaan ee bi Ada, naiꞌ Eron in aan feto. Es anteniꞌ atoin Hebis. In kaan ee, bi Ohoribama. In aamf ee, kaan ee naiꞌ Anah, ma in naiꞌf ee, kaan ee naiꞌ Sibeon. ");
INSERT INTO aaz_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Naiꞌ Esau nsao naiꞌ Ismaꞌel in aan feot goes amsaꞌ, kaan ee bi Basmat. Bi Basmat in naof ee, es reꞌ naiꞌ Nebayot. ");
INSERT INTO aaz_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Naiꞌ Esau in fee unu, bi Ada, nahoniꞌ naiꞌ Elifas. Bi Basmat nahoniꞌ naiꞌ Rehuel. ");
INSERT INTO aaz_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Rarit bi Ohoribama nahoniꞌ naiꞌ Yeus, naiꞌ Yaram, ma naiꞌ Kora. Naiꞌ Esau in aanh ein ok-okeꞌ, nahoniꞌ sin anbin pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Neot es, naiꞌ Esau nfooꞌ neu pah es aꞌtetaꞌ, naꞌroo naꞌko naiꞌ Yakop. In neik in fee-anah, ameupt ein, muꞌit ma ꞌmuiꞌf ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Naiꞌ Esau nbaits on nok in orif naiꞌ Yakop, natuin sin muiꞌt ein namfaun, ma sin aꞌmuꞌik bian, amfaun ii kah. Onaim sin naheun bare naan een. ");
INSERT INTO aaz_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Etun naiꞌ Esau (es reꞌ naiꞌ Edom), annao natua nbi baer maꞌtoeꞌf ein et Seir. ");
INSERT INTO aaz_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Naiꞌ Esau in sufan-kauꞌn ein, reꞌ sin nteek nain je mnak, ‘atoin Edomas’, esan reꞌ ia: sin natuan nbin baer maꞌtoeꞌf ein et Seir. ");
INSERT INTO aaz_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Naiꞌ Esau in fee bi Ada, nahoniꞌ riꞌaan moen jes, kaan ee naiꞌ Elifas. Naiꞌ Elifas in aan moen ein tuaf niim, esan reꞌ: naiꞌ Teman, naiꞌ Omar, naiꞌ Sefo, naiꞌ Gatam ma naiꞌ Kenas. Naiꞌ Elifas anmuiꞌ fee panaꞌ, kaan ee bi Timna. In nahoniꞌ riꞌaan moen jes, kaan ee naiꞌ Amalek. Naiꞌ Esau in fee bi Basmat nahoniꞌ riꞌaan moen jes, kaan ee naiꞌ Rehuel. Naiꞌ Rehuel nahoniꞌ aan mone haa, esan reꞌ: naiꞌ Nahat, naiꞌ Sera, naiꞌ Sama, ma naiꞌ Misa. ");
INSERT INTO aaz_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Naiꞌ Esau in fee bi Ohoribama, reꞌ naiꞌ Anah in aan feto, ma reꞌ naiꞌ Sibeon in upuf naan, nahoniꞌ riꞌaan mone teun, esan reꞌ: naiꞌ Yeus, naiꞌ Yaram, ma naiꞌ Kora. ");
INSERT INTO aaz_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Naiꞌ Esau in sufan-kauꞌn ein anbaits ok amfaun ma njarin uuf-uuf. Es-es ate nok kuun sin aꞌnaak uuf. Naiꞌ Esau in aan moen unu naiꞌ Elifas aanh ein, njarin aꞌnakat neu uuf Teman, aꞌnakat neu uuf Omar, aꞌnakat neu uuf Sefo, aꞌnakat neu uuf Kenas, aꞌnakat neu uuf Kora, aꞌnakat neu uuf Gatam, ma aꞌnakat neu uuf Amalek. Sin arsin reꞌ naan, naiꞌ Esau nok in fee bi Ada sin suufk ein. ");
INSERT INTO aaz_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Naiꞌ Esau in anah naiꞌ Rehuel in aanh ein anjarin aꞌnakat neu uuf Nahat, aꞌnakat neu uuf Sera, aꞌnakat neu uuf Sama, ma aꞌnakat neu uuf Misa. Sin arsin reꞌ naan, naiꞌ Esau nok in fee bi Basmat sin suufk ein. ");
INSERT INTO aaz_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Naiꞌ Esau nok in fee bi Ohoribama sin aanh ein, anjarin aꞌnakat neu uuf Yeus, aꞌnakat neu uuf Yaram, ma aꞌnakat neu uuf Kora. ");
INSERT INTO aaz_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Uuf ein reꞌ naan ok-okeꞌ, naiꞌ Esau in sufan-kaꞌun sin. ");
INSERT INTO aaz_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Anbi bare naan amsaꞌ, anmuiꞌ naan atoin Horis es, in kaan ee naiꞌ Seir. In aanh ein anbaits ok anjarin uuf-uuf amfaun, es-es ate nok in aꞌnakat. Rarit in aanh ein anjarin aꞌnakat neu uuf Rotan, aꞌnakat neu uuf Sobar, aꞌnakat neu uuf Sibeon, aꞌnakat neu uuf Anah, aꞌnakat neu uuf Dison, aꞌnakat neu uuf Eser, ma aꞌnakat neu uuf Disan. ");
INSERT INTO aaz_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Naiꞌ Rotan in aanh ein, esan reꞌ naiꞌ Hori, ma naiꞌ Heman (naiꞌ Rotan in feotf ee es reꞌ bi Timna). ");
INSERT INTO aaz_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Naiꞌ Sobar in aanh ein, esan reꞌ: naiꞌ Arwan, naiꞌ Manahat, naiꞌ Ebal, naiꞌ Sefo, ma naiꞌ Onam. ");
INSERT INTO aaz_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Naiꞌ Sibeon in aanh ein, esan reꞌ: naiꞌ Aya, ma naiꞌ Anah. Naiꞌ Anah in es reꞌ niit oe maat maputuꞌ nbi baer ruman oras in natuuk in aamf ee bikaes keledai ngguin. ");
INSERT INTO aaz_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Naiꞌ Anah in aan feot goe, es reꞌ, bi Ohoribama. Ma in aan moen je, es reꞌ naiꞌ Dison. Naiꞌ Dison in aanh ein, esan reꞌ: naiꞌ Hemdan, naiꞌ Esban, naiꞌ Yitran, ma naiꞌ Keran. ");
INSERT INTO aaz_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Naiꞌ Eser in aanh ein, esan reꞌ: naiꞌ Birhan, naiꞌ Saꞌaban, ma naiꞌ Akan. ");
INSERT INTO aaz_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Naiꞌ Disan in aanh ein esan reꞌ: naiꞌ Us ma naiꞌ Aran. ");
INSERT INTO aaz_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Onaim aꞌnaak uuf ein atoin Horis sin, esan reꞌ: naiꞌ Rotan, naiꞌ Sobar, naiꞌ Sibeon, naiꞌ Anah, naiꞌ Dison, naiꞌ Eser, ma naiꞌ Disan. Sin arsin natuan nbin pah Seir. ");
INSERT INTO aaz_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Oras pah Israꞌel ka nmuiꞌ fa usif fa feꞌe te, anbi pah Edom anmuꞌi nrair usif. Sin kaank ein anmaktun-tuin ein, esan reꞌ: ");
INSERT INTO aaz_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Sin nait naiꞌ Beor in anah naiꞌ Bera, njair usif nbi kota Dinhaba. ");
INSERT INTO aaz_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Oras naiꞌ Bera nmaet, naiꞌ Yobap anseun ee njair usif. In aamf ee, kaan ee naiꞌ Sera naꞌko kuan Bosra. ");
INSERT INTO aaz_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Oras naiꞌ Yobap anmaet, naiꞌ Husam anseun ee njair usif. Naiꞌ Husam naan, naꞌko atoin Temanas sin pah. ");
INSERT INTO aaz_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Oras naiꞌ Husam anmaet, naiꞌ Hadat anseun ee njair usif. In aamf ee, kaan ee naiꞌ Bedat naꞌko kuan Abit. (In reꞌ naan, es reꞌ niis atoin Midianas sin, oras sin nmakenan nbin pah Moap.) ");
INSERT INTO aaz_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Oras naiꞌ Hadat anmaet, naiꞌ Samra anseun ee njair usif. Naiꞌ Samra naan, naꞌko kuan Masreka. ");
INSERT INTO aaz_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Oras naiꞌ Samra nmaet, naiꞌ Saul anseun ee njair usif. Naiꞌ Saul naan naꞌko kuan Rehobot et noe je panin. ");
INSERT INTO aaz_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Oras naiꞌ Saul anmaet, naiꞌ Baꞌal-Hanan anseun ee njair usif. In aamf ee, kaan ee naiꞌ Akbor. ");
INSERT INTO aaz_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Oras naiꞌ Baꞌal-Hanan anmaet, naiꞌ Hadar anseun ee njair usif. Naiꞌ Hadar naan, naꞌko kuan Pau. In fee je, kaan ee bi Mehetabel. Bi Mehetabel in aamf ee, kaan ee naiꞌ Matret. Ma in naiꞌf ee, kaan ee naiꞌ Mesahap. ");
INSERT INTO aaz_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Onaim aꞌnaak uuf ein reꞌ npoin ma nboran naꞌkon naiꞌ Esau in suufk ein esan reꞌ: naiꞌ Timna, naiꞌ Arwa, naiꞌ Yetet, naiꞌ Ohoribama, naiꞌ Era, naiꞌ Pinon, naiꞌ Kenas, naiꞌ Teman, naiꞌ Mipsar, naiꞌ Magdiel, ma naiꞌ Iram. Sin es-es ate, nakanab sin pah anpaek kuuk sin kaank ein. Onaim sin reꞌ naan ok-okeꞌ, naiꞌ Esau in sufan-kaꞌun. Naiꞌ Esau njair aam uuf neu atoin Edomas sin. ");
INSERT INTO aaz_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Reꞌ ia, naiꞌ Yakop sin retaꞌ. Neon goes ii, naiꞌ Yakop anfani nteniꞌ, ma natuan nbin pah Kanaꞌan, reꞌ in amaf naiꞌ Isak natua nbi naan naꞌko unuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Oras naan, naiꞌ Yakop in aanh es naꞌko in fee bi Rahel, kaan ee naiꞌ Yusuf. Oras in nmoin naan toon boꞌes am hiut, in nok in taatf ein natiꞌ te sin nnaon ntiut sin aꞌbibin ma ꞌbib-kasen buꞌ-buaꞌ. In taatf ein, naiꞌ Yakop in fee bi Bilha ma bi Silpa sin aanh ein. Naiꞌ Yusuf reꞌ ia, in aktutaꞌ uab neu in amaf, anmatoon nok in taatf ein sin aꞌmoeꞌk ein. ");
INSERT INTO aaz_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Oras nahoniꞌ naiꞌ Yusuf, naiꞌ Yakop namnais jen. Etun in nneek nanesib naiꞌ Yusuf naꞌko in anah bian sin. Neot es naiꞌ Yakop ansoo baru mnaun es reokn ii kah, ma nfee je neu naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Oras in taatf ein nitan nak sin aamf ee nneek nanesib neu naiꞌ Yusuf ate, sin nsaken naiꞌ Yusuf, tar antea sin ka nromin fa he naꞌuab ein nok ne. ");
INSERT INTO aaz_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Fai jes, naiꞌ Yusuf namnei. Rarit in natoon amneit naan neu in taatf ein am nak, “Hae! Hi mneen feꞌ! Au umnei mnak hit tfuut hit maak-gandum sin atbi rene. Onaim au maak reif ein reꞌ mafuut ein naan, anfeen anhaken amneof aah. Mes hi maak ein anhaken nfuun naan au ngguin, rarit naꞌruir ein ma naꞌbesan neun au ngguin.” Annenan on naan ate, in taatf ein ansaken anteinꞌ ee. ");
INSERT INTO aaz_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Rarit sin nakainaꞌ naiꞌ Yusuf am nak, “Hoe! Ho mak oniꞌ ho he mjair usif he muprenat kai, oo?” Sin nsaekn ee maꞌtaniꞌ, natuin in natoon amneit naan neu sin. ");
INSERT INTO aaz_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Rarit naiꞌ Yusuf namnei ntein. Onaim in natoon neu in taatf ein am nak, “Hae! Au umnei ꞌtein. Au ꞌiit manas, funan, ma kfuun boꞌes am meseꞌ. Sin naꞌruir ein ma naꞌbesan kau rek-reko.” ");
INSERT INTO aaz_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Oras naiꞌ Yusuf natoon anrair mneit naan neu in amaf ma in taatf ein ate, in aamf ee napuun naiꞌ Yusuf ma nakain ee maꞌtaniꞌ mnak, “Mnei saaꞌ na es reꞌ naan! Ho mutenab mak, au ꞌok ho ainaꞌ ma sin ho tataꞌ sin neman he nneek ho haem ein naan, aa oo? Ho reokm ii!” ");
INSERT INTO aaz_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Onaim naiꞌ Yusuf in taatf ein nsaken batuur-batuur. Mes in aamf ee natenab mneit ein naan anbi in nekan. ");
INSERT INTO aaz_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Neot es, naiꞌ Yusuf in taatf ein neik sin aamf ee in aꞌbibin ma ꞌbib-kasen annaon npaumak-maak kuan Sikem. ");
INSERT INTO aaz_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ka ꞌroo fa te, in aamf ee nak, “Usu! Ho tataꞌ sin natukun muꞌit anpaumak-makan etan Sikem. Onaim ho mubarab he mnao mkius miit sin feꞌ.” Naiꞌ Yusuf nataah am nak, “Reko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Onaim in aamf ee nak, “Ho mnao mkius miit sin ho tataꞌ nok muꞌit ein feꞌ. Sin on mee? Rekon aa oo, aiꞌ on mee? Rarit ho mfain uum he mutoon kau.” Rarit naiꞌ Yusuf annao nasaitan amneraꞌ pah Hebron ma nkono ntea Sikem. ");
INSERT INTO aaz_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Antea nee te, in naim sin anfuun am nateef anbin amneraꞌ huun naan. Oras in nateef tuaf es, tuaf naan nataan ee mnak, “Ho maim saaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Naiꞌ Yusuf nataah am nak, “Aam, au ꞌaim sin au tataꞌ. Sin napooꞌ neik hai muiꞌt ein he naꞌekuꞌ sin anpaumak-maak anbin bare ia. Aiꞌ ho miit sin, tua?” ");
INSERT INTO aaz_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tuaf naan nataah ee mnak, “Sin ka etan fa ia ntenin. Mes sin nak am he nnaon nteinꞌ ein anpaumak-maak kuan Dotan.” Rarit naiꞌ Yusuf annao natuin sin, tar in niit sin anbin Dotan. ");
INSERT INTO aaz_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mes oras naiꞌ Yusuf feꞌe nbi ꞌroo, sin niit anrair je. Onaim sin nmaꞌakoran he nroor goe. ");
INSERT INTO aaz_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Rarit sin nmaꞌuab ein am nak, “Hi mkius miit. Amneit ee neem een! ");
INSERT INTO aaz_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Naa, iim nai he troor tisan. Rarit hit tait itpoirn ee neu koon hain es anbi ia. Rarit hit tatonan hit amaꞌ mtak, muiꞌ fui ngguin anpius goe ma neku nrair je goen! Maut he hit tkius tiit in amneit ein on mee!” ");
INSERT INTO aaz_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Anneen on naan ate, in tataf naiꞌ Ruben naim raan aꞌpoꞌi he nafetin naan naiꞌ Yusuf. Onaim in nakainaꞌ in oirf ein am nak, “Hae! Hit kais atroor goe! ");
INSERT INTO aaz_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reko nneis, hit tꞌokar tataam ee teu koon haniꞌ reꞌ ia. Bare ia, baer ruman. Onaim ka tiit fa tuaf reꞌ nahiin moꞌet ia. Asar hit kaisaꞌ tniimn ee he naaꞌ ii nsai.” In naꞌuab on naan, natuin in he nafetiꞌ naiꞌ Yusuf he nreun nggoe he nfain. ");
INSERT INTO aaz_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Oras naiꞌ Yusuf neem antea te, sin nheek je ma nhoroꞌ nain in baur reko naan. ");
INSERT INTO aaz_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Rarit sin nheer anfoont ee, ma nꞌokar nataam ee neu koon haniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Rarit sin ntebi nfanin ma nbukaen. Sin feꞌe nbukaen on naan ate, nok askeken sin niit atoniꞌ puukn es neman. Pukan amneemt ein naan anpaken bikaes unta. Sin nasaeb ein abruaꞌ he nraakn ein. Baer raakn ein naan esan reꞌ: hau foo meniꞌ in oen, bumbu humaꞌ-humaꞌ, ma hau reꞌu humaꞌ-humaꞌ. Ankis-kisun ate, pukan amneemt ein naan, atoin Ismaelas sin reꞌ neman naꞌkon kuan Gireat. Sin he nnaon neu bare ꞌroo neun pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Rarit naiꞌ Yahuda naꞌuab neu in orif-taatf ein am nak, “Hae! Reko nneis on nai. Hit kais atroor goe. Hit tapein saaꞌ? Maski on mee msaꞌ, hit ka neu he taꞌkoroꞌ taan fa in naaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Reko nneis hit taꞌsoos ee teu atoin Ismaelas sin. Maski hit tmoeꞌ je on mee msaꞌ, hit oir hoin aa. Onaim hit kaisaꞌ tniim ne.” Rarit sin nmaktuinaꞌ rasi naan. ");
INSERT INTO aaz_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Onaim oras atoin araakn ein naan he nkonon ate, naiꞌ Yusuf in taatf ein anheer napoitn ee naꞌko konaꞌ naan. Onaim sin naꞌsoos ee neu atoin Ismaelas sin. In oosn ii roi mutiꞌ fuaꞌ boꞌ nua. Rarit asoost ein naan neik naiꞌ Yusuf antean pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Oras sin naꞌsosaꞌ naiꞌ Yusuf ate, naiꞌ Ruben ka nahiin fa. Onaim oras in nnao neu konaꞌ naan ate, in naskeek, natuin naiꞌ Yusuf ka et na fa heen. Rarit in npius nakratiꞌ in paken anbi in aon, natuin in nsuus anmaet. ");
INSERT INTO aaz_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Onaim in ntebi nfain neu in oirf ein am nak, “Airoo! Naiꞌ Usu ka et fa koon ee! Oras ia au he unsaaꞌ aꞌtein?” ");
INSERT INTO aaz_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Rarit sin nroro ꞌbiib jes. Sin nait naiꞌ Yusuf in baur reko naan, ma nateep ee neu naaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Rarit sin nait baur manaaꞌ naan ma neik je neu sin amaf, ma natonan am nak, “Aam! Hai mait baru ia. Amkius miit ee. Kais-kaisaꞌ naiꞌ Usu in baru.” ");
INSERT INTO aaz_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ankius baru naan ate, naiꞌ Yakop nahiin nain je neu in aanh ee baru. Onaim in nataah am nak, “Airoo! Batuur, au aanh ee in baur gui es reꞌ ia. Ka tahiin neu muiꞌ fui ngguin npius niis ne et mee. Airoo! Au aanh ee nmate nrair!” ");
INSERT INTO aaz_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Rarit naiꞌ Yakop anpius nakratiꞌ in baru, ma ntainuus aꞌkaor bijae maaꞌ, natuin in nsuus ma nnanaꞌreen. In nkae nmeꞌ-meꞌur aꞌroo neu in anah naan. ");
INSERT INTO aaz_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","In aan mone ma aan feto neman ma nhaan mau goe, mes ka nabeiꞌ je fa. In naꞌuab am nak, “Kahaf! Au of aꞌsuus ma ꞌnanaꞌreen tar antea au ꞌmaet. Natuin au ka neu he ꞌnikaꞌ fa au anah reꞌ ia.” Onaim naiꞌ Yakop ansuus ma nnanaꞌreen piut, natuin in namnau in anah naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Oras naiꞌ Yakop feꞌ ansuus on naan ate, araakn ein naan antean nrarin pah Masir. Sin neik naiꞌ Yusuf ma naꞌsoos ee neu kaes kouꞌ goes, kaan ee naiꞌ Potifar. In reꞌ ia, usif pah Masir in aꞌnaak paot. ");
INSERT INTO aaz_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Rarit naiꞌ Yahuda nnao nasaitan in orif-tataf sin, ma natua nok in soob reko naiꞌ Hira anbi kuan Aduram. ");
INSERT INTO aaz_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Anbi naan, anmuiꞌ aꞌnaef es, atoin Kananas, in kaan ee naiꞌ Sua. Naiꞌ Yahuda anroim in aan feot goes. Rarit in nsao goe. Onaim in nahoniꞌ riꞌaan mone nmaktun-tuin ein. ");
INSERT INTO aaz_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Aan moen unu, sin nakaanb ee naiꞌ Er. ");
INSERT INTO aaz_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Aan mone tnanaꞌ, sin nakaanb ee naiꞌ Onan. ");
INSERT INTO aaz_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Rarit aheit suus goe, kaan ee naiꞌ Sera. Oras nahoniꞌ naiꞌ Sera, sin nfoꞌon neu kuan es, in kaan ee, Kesip. ");
INSERT INTO aaz_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Oras aan moen unu naiꞌ Er naꞌnae te, naiꞌ Yahuda nnao neik ripaꞌ-okoꞌ ma ntoitn ee riꞌ feot munif es, in kaan ee bi Tamar. Rarit naiꞌ Er ansao bi Tamar. ");
INSERT INTO aaz_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mes naiꞌ Er naan atoin maufinu. Es naan ate, Uisneno nhukun naꞌmate. Onaim naiꞌ Er nmaet, mes ka nmuiꞌ fa anah. ");
INSERT INTO aaz_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Rarit naiꞌ Yahuda nreun aan mone tnaan ee mnak, “Onan! Ho tataꞌ nmate nrair, mes in ka nmuiꞌ fa anah. Onaim oras ia, tatuin atoni mnais ein sin haart ii te, ho ro he msenuꞌ ho tataꞌ he msao in fee. Nok ranan naan ate, maut he ho muhoniꞌ riꞌanaꞌ neu ho tataꞌ in sapaan.” ");
INSERT INTO aaz_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Naiꞌ Onan nahiin harat naan. Mes in ka nroim fa he nahoniꞌ neu in tataf naiꞌ Er. Onaim karu in ntuup nok bi Tamar ate, in akmii oen ee nꞌoop ee npoi henatiꞌ bi Tamar kais naꞌapuꞌ he nahoniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Naiꞌ Onan anmoeꞌ on naan, onaim natoꞌob niis Uisneno. Etun Uisneno nhukun niis ne msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Oras naiꞌ Yahuda nkisu te in aan moen nuaꞌ ein reꞌ ansao bi Tamar naan anmaten ate, in natiun gon. In natenab, kais-kaisaꞌ in aan moen aheit susu naiꞌ Sera nsao bi Tamar ate, of in nmate msaꞌ. Onaim in nnao natonan in nanef bi Tamar am nak, “Tamar! Reko nneis ho mfain meu ho mahoin ein. Karu au anah naiꞌ Sera naꞌnae te, naꞌ ho mfain uum he msao.” Rarit bi Tamar anfain. ");
INSERT INTO aaz_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ka ꞌroo fa te, naiꞌ Yahuda in fee je nmaet. Onaim in nkae ma nsuus tar antea neon nuukt ein namsopun ate, in noꞌen in partei naiꞌ Hira, he sin nua sin annaon neun kuan Timna. Anbi naan, atoin ein ankateer aꞌbib-kaesn ein sin fuunk ein, he naꞌsosaꞌ sin. Akateers ein namfa-faun ma sin feest ein amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Onaim biak ein natonan bi Tamar am nak, “Ho aam babaꞌ annao et Timna, he nꞌurus tua akateer funu neu in aꞌbib-kaesn ein.” ");
INSERT INTO aaz_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Oras naan, naiꞌ Yahuda in aan moen aheit suus goe naꞌnae nrair. Mes bi Tamar nahini nrair nak in aam baabf ee ka nroim fa he naiꞌ Sera nsao goe. Onaim bi Tamar naim raan aꞌpoꞌi he naꞌtuiꞌ in sapaan. Onaim in nsenuꞌ nain in tai-baun ein, rarit in npaek tai-paek reko. In npaek poꞌuk ma nsakruub naan in human. Rarit in nnao ntoko nbi enoꞌ he ttaam teu kuan Enaim, nbi haa reꞌ ranan he tnao teu Timna. ");
INSERT INTO aaz_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Oras naiꞌ Yahuda nnao npeoꞌ kuan naan in rana ꞌtamas, in niit bifee jes. In natenab nak oniꞌ bifee aꞌhakeꞌ, natuin bi Tamar in paekn ee on reꞌ bifee aꞌhaek ein. Anneis-neis in nkuub naan in human. ");
INSERT INTO aaz_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Naiꞌ Yahuda ka nahiin naan fa nak, bifee naan in aan nanef. Onaim in nnao npaumaak bifee naan, ma nataan ee mnak, “Hae! Karu ho mromi te, au ꞌtuup ꞌok ko. Ho mtoit fauk?” Mes bi Tamar nataah am nak, “Es reꞌ ho, tua. Ho roim maan on mee te, au utuin aah.” ");
INSERT INTO aaz_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Naiꞌ Yahuda ntaabr ee mnak, “On mee karu au ꞌfee ko ꞌbib jes ate, ho mromi, oo?” Rarit bi Tamar nataah am nak, “Reko, tua. Asar ho mfee kau baer es feꞌ. Rekaꞌ-rekaꞌ ho msonuꞌ ꞌbibi naan, naꞌ ho mtoup mufaniꞌ ho baer tarun sin.” ");
INSERT INTO aaz_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Onaim naiꞌ Yahuda nataan anteinꞌ ee mnak, “Au he ꞌfee ko baer saaꞌ?” Bi Tamar nataah am nak, “Ho mfee kau baer marunaꞌ reꞌ ho muꞌheek je naan nok nain in tanin. Rarit ho teas naan amsaꞌ.” Onaim naiꞌ Yahuda nfee baerꞌ ein naan. Rarit sin nua sin nmakonin. Rarit bi Tamar anfain. In nhoroꞌ nain in tai-paek rekon naan ma in poꞌuk, rarit in npaek nafaniꞌ in tai-baun ein. Namuni te, bi Tamar annaben nak in naꞌapuꞌ nrair. ");
INSERT INTO aaz_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ka ꞌroo fa nteniꞌ te, naiꞌ Yahuda ntoit babat naꞌko in soob reko naiꞌ Hira mnak, “Ho meiki ꞌbibi ia meu bifee aꞌhakeꞌ reꞌ et Enaim, he mtoup maan kau au baerꞌ ein reꞌ in nnaaꞌ sin.” Naiꞌ Hira nnao ntea Enaim. In nataan neu-mneem, mes ka niit aiꞌ nateef fa bifee naan. ");
INSERT INTO aaz_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Onaim in nataan abitan bare naan am nak, “Au he utaan ꞌaan, tua. Hi miit bifee aꞌhakeꞌ es, reꞌ natiꞌ te antok-toko nbi kuan ee in enoꞌ ꞌtaamn ee, oo? In et mee?” Mes sin natahan am nak, “Aam, ka tiit fa bifee aꞌhakeꞌ et ia.” ");
INSERT INTO aaz_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Onaim naiꞌ Hira nfain neem neu naiꞌ Yahuda. In natoon am nak, “Au ka uteef ꞌok ꞌaan fa bifee naan. Au ꞌaim ma ꞌhae ꞌmaet, mes abitan nee nak, ka tiit fa bifee aꞌhakeꞌ nbi naan.” ");
INSERT INTO aaz_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Naiꞌ Yahuda nataah am nak, “Maut he in paar baerꞌ ein naan! Asar biak ein kais namaebaꞌ kit. Natuin au he ꞌbaen, mes hit ka tateef fa bifee naan ate.” ");
INSERT INTO aaz_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ankoon funan teun on naan ate, tuaf bian annaon ma natonan naiꞌ Yahuda mnak, “Ho aan nanef bi Tamar naan, anmoeꞌ jon on reꞌ bifee aꞌhakeꞌ. Oras ia in naꞌapuꞌ.” Anneen on naan ate, naiꞌ Yahuda natoꞌo nmaet. Rarit in nreun tua atonas naan am nak, “Amnao mheer meik kau bifee naan neem neu ia, he ttout goe ꞌhon-honis!” ");
INSERT INTO aaz_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Rarit sin nnaon ma nheer neik bi Tamar. Mes in nait napoin baer mamarak ma teas naan. Onaim in nreek tuaf he nnao natoon neu in aam baabf ee mnak, “Aam. Amtae murek-rekoꞌ baerꞌ ein reꞌ ia feꞌ. Tuaf reꞌ nmuiꞌ baer mamarak ma teas reꞌ ia, in es reꞌ naꞌapub kau.” ");
INSERT INTO aaz_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ankius niit baerꞌ ein naan ate, naiꞌ Yahuda nahiin nain nak baerꞌ ein naan, ro iin na. Rarit in naꞌuab am nak, “Batuur! Bifee naan ka nsaan fa. Au es reꞌ asanat. In ntoom. Amneon ii, au ro he usaob ee nok au anah naiꞌ Sera, mes au es reꞌ ka ꞌromif. Amnao mifeitn ee nai!” Rarit naiꞌ Yahuda ka ntuup nabua ntein fa nok bi Tamar. ");
INSERT INTO aaz_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Bi Tamar in oras he nahoin ii ntea goen. Onaim in nahoniꞌ riꞌaan koen. ");
INSERT INTO aaz_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Oras in nahoniꞌ, riꞌaan es napoit nahunun in aꞌniman. Bifee atuis mahoin ee nfutuꞌ aab meꞌe nbi in aꞌniman. In nak, “Reꞌ ia, es reꞌ ahunut.” ");
INSERT INTO aaz_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mes riꞌanaꞌ naan anheer nataam in aꞌniimn ee nfain. Rarit akoet ee npoi nahuun. Onaim bifee atusis naan nak, “Hoe. Ho ro maꞌtain, oo! Etun ho muꞌsetiꞌ ma mpoi muhuun!” Rarit sin nakanab riꞌanaꞌ naan naiꞌ Peres (reꞌ in oetn ii nak, ‘naꞌsetiꞌ npoi’). ");
INSERT INTO aaz_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Rarit naꞌ in orif reꞌ mafuut aab meꞌe naan anpoi. Sin nakaanb ee naiꞌ Sera (in oetn ii nak ‘meeꞌ rare’). ");
INSERT INTO aaz_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Neon goes ii, atoin Ismaelas sin neik naiꞌ Yusuf annao neu pah Masir. Anbi naan, anmuiꞌ kaes kouꞌ goes, kaan ee naiꞌ Potifar. In reꞌ naan, aꞌnakat neu areꞌ soraurs ein reꞌ npao usif pah Masir in sonaf. Naiꞌ Potifar ansoos naiꞌ Yusuf naꞌko araakn ein naan, he in nait je njair ate nbi in umi. Anbi naan, UISNENO anturun naiꞌ Yusuf. Es naan ate, in meupn ein ok-okeꞌ nanaob ok nok reko. ");
INSERT INTO aaz_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","In aam uisf ee nkius naiꞌ Yusuf in meupn ein naan ro reko, in nahiin batuur-batuur nak UISNENO nturun ma nbaab naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Es naan ate, aam usiꞌ naan anromi haa naiꞌ Yusuf, ma npirsai je. Onaim in nait naiꞌ Yusuf anjair mandoor neu in umi. In nnonaꞌ in uim je he naiꞌ Yusuf anꞌurus. In baer pusaak ein, naiꞌ Yusuf es anꞌurus sin amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Natuin naiꞌ Yusuf natua nbi naan, es naꞌ Uisneno nfee tetus neu in aam usif, atoin Masir naan. In uim je nanan, in pusaak ein, in rene-poꞌon, ma in mepun naan nanaob ok nok reko. ");
INSERT INTO aaz_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Oras naiꞌ Potifar niit naiꞌ Yusuf in meupn ein reko ok-okeꞌ, in ka natenab fa saaꞌ-saaꞌ antein. In nahini haa he naah. Oras naan, naiꞌ Yusuf in aon ma in human, reokn ii kah een. ");
INSERT INTO aaz_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","In natua nbi nee feꞌ ka ꞌroo fa, mes naiꞌ Potifar in fee je, ntaam neek neu ne. Onaim in naꞌokiꞌ naiꞌ Yusuf he karu reko te sin nua sin antupan. ");
INSERT INTO aaz_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mes naiꞌ Yusuf ka nroim fa. In nataah am nak, “Kais on naan, tua! Au aam usiꞌ Potifar anfee kau kuasa he ꞌurus in umi-moneꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Anbi umi ia, ka tiit fa tuaf reꞌ nnaaꞌ aprenat anneis kau. Aam usiꞌ nanaꞌat kau areꞌ saaꞌ-saaꞌ he ꞌurus sin. Mes in ka nanaꞌat ko fa neu kau. Nok ranan mee, au he ꞌmoeꞌ rais tafiꞌ reꞌ ia? Rasi naan, nasuir nok Uisneno In romin amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Maski on naan amsaꞌ, mes naiꞌ Potifar in fee je naꞌokiꞌ naiꞌ Yusuf piut. Mes naiꞌ Yusuf ka ntoe natuin ee fa. ");
INSERT INTO aaz_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Neot es, naiꞌ Yusuf antaam neu uim je he nkius mepu. Neno naan, ka tiit fa tuaf es anbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Onaim bifee naan neem ma nnaaꞌ naiꞌ Yusuf in baru, ma nheer ee mnak, “Uum nai! Hit nua kit atmes-mees. Uum he hit ttuup nai.” Mes naiꞌ Yusuf ka nroim fa. Onaim in nfoerait, tar antea in baru naan natpuuꞌ nain. Onaim in naen anpoi. Mes bifee naan annaaꞌ namaikaꞌ naiꞌ Yusuf in baru. ");
INSERT INTO aaz_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Oras naiꞌ Potifar in fee je niit naiꞌ Yusuf naen nasaitan in baur goe te, ");
INSERT INTO aaz_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","in noꞌen ameupt ein, ma natonan sin am nak, “Hae! Hi iim he mkius miit! Feꞌe na atoin Ibranis naan, antaam anbi au keꞌen. In he nmoeꞌ reꞌuf neu kau, mes au ꞌkoaꞌ uher-heer. Amkius miit, in naen anporin in baru. Au moen ji, in nait neik naan kuun atoin maufinu ia he ntao namab-maeb ahaa kit!” ");
INSERT INTO aaz_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Onaim naiꞌ Potifar in fee je, nnaaꞌ baru naan, tar antea in moen je nfain neem. ");
INSERT INTO aaz_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Oras in moen je nfain neem ate, in natoon ee mnak, “Amneen! Atoin Ibrani reꞌ ho mait meik je neem nok kit naan, feꞌe na in ntaam neu nbi au keꞌen. In he nkoin kau nok aꞌsekeꞌ! ");
INSERT INTO aaz_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mes au ꞌkoaꞌ uher-heer ma ꞌoꞌen ameupt ein. Onaim in naen namneuk, namaikaꞌ nain in baru ia.” ");
INSERT INTO aaz_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Anneen in fee je natoon on naan ate, naiꞌ Potifar natooꞌ reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Onaim in nreek tuaf ma nnaon nheek naiꞌ Yusuf. Onaim sin nataam ee nbi uisf ee in bui. ");
INSERT INTO aaz_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mes UISNENO ka nnikaꞌ fa naiꞌ Yusuf. Etun In ntuurn ee piut, tar antea aꞌnaak bui naan anneek aah ee. ");
INSERT INTO aaz_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Rarit in npirsai naiꞌ Yusuf. Onaim in nfee ne kuasa he nꞌurus atoin bui ngguin ma areꞌ kanan mepu nbi bui je nanan. ");
INSERT INTO aaz_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Es naan ate, aꞌnaak bui naan in ka natenab fa meup saaꞌ-saaꞌ nbi bui. UISNENO nturun ma nbaab naiꞌ Yusuf piut-piut, es naꞌ in mepun nbi bui je nanaob ok nok reko. ");
INSERT INTO aaz_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Anbi bui naan, anmuiꞌ naan aꞌnaak mepu tuaf nua reꞌ anmeup nitan anbin usif pah Masir in sonaf. Es naꞌnaak mepu barab roitan bukae-mninut neu usif; ma es antein naꞌnaak mepu barab roitan bukae-kokis neu usif. Sin nua sin anmoꞌen sanat neu usif. Es naꞌ uisf ee natooꞌ, ma nataam sin neun bui. Onaim sin nabuan bare meseꞌ nok naiꞌ Yusuf anbin bui naan. ");
INSERT INTO aaz_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Rarit aꞌnaak bui naan naprenat naiꞌ Yusuf he nꞌurus aꞌnakat tuaf nua reꞌ naan. Sin nabuan nbin bui naan, tar antea oniꞌ toon es-aꞌnua. ");
INSERT INTO aaz_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Fai jes ate, tua nuaꞌ ein naan namnein. Es-es ate, nok in amneit aa kuun. Ma mneit ein naan amsaꞌ sin oetk ein ka humaꞌ meseꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nokaꞌ on naan ate, naiꞌ Yusuf neem ma niit atoin nuaꞌ ein naan, sin huum fousun. ");
INSERT INTO aaz_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Onaim in nataan sin am nak, “Nansaaꞌ am es neno ia hi mhuum fous on naan?” ");
INSERT INTO aaz_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Onaim sin natahan am nak, “Fini na, hai mimnei. Mes hai ka mihiin fa in oten.” Rarit naiꞌ Yusuf nataah sin am nak, “Ka tiit fa mansian es, reꞌ he nahiin nain mneit ein sin aꞌmoufk ein naan, arahaa Uisneno es reꞌ nahiin sin. Mitoon miit kau hi mneit ein naan. Maut he au ꞌaim ꞌiit sin aꞌmoufk ein naꞌko Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Rarit aꞌnaak mepu barab roitan bukae-mninut neu uisf aan, natoon am nak, “On nai. Au umnei mnak, au ꞌiit hau anggur uuꞌ goes, ");
INSERT INTO aaz_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","taef teun. Hau naan nanoo, nasuuf, ma nafua sanaꞌ mfa-faun tar namnatun. ");
INSERT INTO aaz_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Onaim au ꞌiit, au ꞌnaaꞌ uisf ee in aꞌkoom oe. Onaim au ꞌait hau naan in fuan amnatus, ma au ꞌaes ꞌeu ꞌkoom oe naan. Onaim au ꞌnoon ee ꞌeu uisf ee he nbukae.” ");
INSERT INTO aaz_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Anneen on naan ate, naiꞌ Yusuf natoon ee mnak, “Aam. Amneit naan in oetn ii on nai: taef teun reꞌ naan, in oetn ii neno teun. ");
INSERT INTO aaz_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Anbi neno teun amnemat reꞌ ia, uisf ee of napoitan ko naꞌko bui ia. Rarit in nasaeb nafani ꞌpiruꞌ-baru neu ko, he muꞌnaak amfain meu barab roitan bukae-mninut neu ne. ");
INSERT INTO aaz_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Karu ho uam aan reko on naan ate, kais amnikan kau, joo! Karu ho mneek kau te, mturun kau he mutoon meu uisf ee, he napoitan kau naꞌko bare ia. ");
INSERT INTO aaz_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Natuin, karu he tkius rais ji in amneon ii te, sin nait kau nok aꞌsekeꞌ naꞌko abitan Ibrani sin pah. Anbi bare ia msaꞌ, au ka ꞌmoeꞌ fa rais reꞌuf meseꞌ msaꞌ. Mes sin nheek kau ma nataam kau neu bui, on reꞌ atoin maufinu.” ");
INSERT INTO aaz_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Anneen niit amneit naan in oetn ii reokn ii kah, on naan ate, aꞌnaak barab roitan bukae-kokis neu uisf ee naꞌuab neu naiꞌ Yusuf am nak, “Baꞌe! Au umnei msaꞌ on nai: au ꞌsuu abaꞌ ktutaꞌ teun. ");
INSERT INTO aaz_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Abaꞌ ktutaꞌ faof ne, matuaꞌ nok kokis humaꞌ-humaꞌ neu usif. Mes koorn ein neman ma nabroor naan koiks ein reꞌ nbin au ꞌnakak.” ");
INSERT INTO aaz_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Anneen on naan ate, naiꞌ Yusuf nataah am nak, “Aam! Ho mneit naan in aꞌmoufn ii on nai: aab teun ein naan, sin oetk ein neno tenu msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Neno teun amnemat reꞌ ia, uisf ee of anreek tuaf he neem ankeut nain ho ꞌnakam. Rarit sin nkaton ho aom aꞌnaen naan neu nii maꞌaikaꞌ. Onaim koorn ein neman, npisun ma nabroor naan ho siis maan okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Neno tenu nkoon on naan ate, nateef nok uisf ee in neon manohin. Onaim in nmoeꞌ fesat neu in aꞌnaak meupn ein ok-okeꞌ. In naprenat he sin nnaon napoitan aꞌnaak mepu tua nuaꞌ ein reꞌ etan bui. ");
INSERT INTO aaz_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Rarit in nasaeb ꞌpiruꞌ-baru nfain neu aꞌnaak barab roitan bukae-mninut, he nanaob nafaniꞌ in mepu. ");
INSERT INTO aaz_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mes aꞌnaak barab roitan bukae-kokis neu uisf aan, sin nkaton in aon ee, natai nok saaꞌ reꞌ naiꞌ Yusuf in uaban. ");
INSERT INTO aaz_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mes aꞌnaak barab roitan bukae-mninut naan, annikan nain naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Toon nua namsoup on naan ate, usif pah Masir namnei. In namnei mnak, in nhake nbi noe Nil in panin. ");
INSERT INTO aaz_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nok askeken ate, in niit bijae hiut anpook anmaten. Bijaen ia sin aok ein narim-riman. Sin npoin naꞌkon noe naan in nanan, ma nekun huun anbin naan. ");
INSERT INTO aaz_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Rarit anmuiꞌ naan bijae hitu ntein, anpoin naꞌkon noe naan. Sin aok ein, nmaknau bousen. Sin nhaken npaumaak bijae apookt ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Rarit bijae amaknaut ein naan, anꞌoor naan bijae apookt ein naan. Onaim uisf ee naskeek anfeen aah. ");
INSERT INTO aaz_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Oras in antuup ma nfini nfain, in namnei ntein. In niit makaꞌ puniꞌ hiut anpoin naꞌko makaꞌ uuꞌ goes reꞌ mrian ii kah een. Sin puink ein koꞌu ma maꞌafaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Rarit in niit antein makaꞌ puniꞌ hiut. Mes ain mapuut ee nfuu sin ma namnenen. Onaim sin nꞌaap ein. ");
INSERT INTO aaz_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Onaim maak aap ein naan anꞌoor naan maak mapuin ein naan. Rarit uisf ee nfeen. Naꞌ in nahiin nak, in namnei ntein. ");
INSERT INTO aaz_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Anmeu nfiin on naan ate, uisf ee in teenb ee ka ntaininaꞌ fa. Onaim in naprenat he noꞌen areꞌ kanan meo ma ahinit anbi pah Masir. Rarit in natonan sin amneit ein naan, mes ka tiit fa tuaf es, reꞌ bisa naꞌoteb sin. ");
INSERT INTO aaz_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Rarit aꞌnaak barab roitan bukae-mninut neu uisf ee, naꞌ namnau niit naiꞌ Yusuf. Onaim in nnao nbaiseun uisf ee mnak, “Au ꞌbaiseun, tua! Ho ate kau gui ꞌsaan. ");
INSERT INTO aaz_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Unuꞌ te, oras usiꞌ ho museus kau ꞌok au aok-bian, ma mutaam kai mbi bui, ");
INSERT INTO aaz_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","fai jes ate, hai nua kai mimnei. Es-es ate, nok in amneit aa kuun. Ma mneit ein naan amsaꞌ sin aꞌmoufk ein ka humaꞌ meseꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Anbi bui je, anmuiꞌ atoin Ibranis es, feꞌ munif. Aꞌnaak bui je nait je njair aꞌnaak mepu nbi bui. Hai mitoon ee hai mneit ein naan. Onaim in nbaan sin. ");
INSERT INTO aaz_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Naꞌko rasi naan, aam usiꞌ ho munaꞌat mufaniꞌ kau au mepu. Mes au aok-bian ee, ho mhukun muꞌmate. Rasin reꞌ naan, natai nok saaꞌ reꞌ atoin Ibranis naan naꞌoteb sin, tua!” ");
INSERT INTO aaz_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Anneen on naan ate, uisf ee nreek tuaf he naen rabah he neik naiꞌ Yusuf naꞌko bui. Rarit naiꞌ Yusuf nnao nkeu ma nsenuꞌ in paken, ma nnao he nateef nok usif. ");
INSERT INTO aaz_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","In neem antea te, uisf ee naꞌuab neu ne mnak, “Anah! Au umnei, mes ka tiit fa tuaf es, reꞌ nabeiꞌ he nbaan amneit ein naan. Mes anmuiꞌ tuaf reꞌ natoon kau nak ho bisa.” ");
INSERT INTO aaz_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Onaim naiꞌ Yusuf nataah am nak, “Aam usiꞌ. Ho ate kau msaꞌ ka uhiin fa saaꞌ-saaꞌ, tua. Uisneno nmees kuun es anbaan areꞌ kanan amneit. In of oniꞌ anroim he natoon ko rais reko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Rarit uisf ee natoon amneit ein naan. In nak, “Anbi au mneit ii naan, au ꞌhake ꞌbi noe Nil in panin. ");
INSERT INTO aaz_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Onaim anmuiꞌ bijae apokat hiut, sin aok ein narim-riman. Sin npoin naꞌkon noe naan, ma nnaon nekun huun nbin noe naan in panin. ");
INSERT INTO aaz_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Rarit anmuiꞌ bijae hitu ntein neman. Mes bijaen naan maknau-bousen. Au ka ꞌiit ꞌiit fa bijae human on reꞌ naan anbin pah Masir ia! ");
INSERT INTO aaz_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mes au ꞌsanmaak! Natuin, nok askeken ate, bijae amaknau-bousen naan, anꞌoor naan bijae apookt ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sin nꞌoro nrair sin on naan amsaꞌ, bijaen naan anmaknaun baar aah. Rarit au uskekeꞌ ꞌfeen aah. ");
INSERT INTO aaz_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Rarit au ꞌtuup ma ꞌfini ꞌfain. Onaim au umnei ꞌtein. Au ꞌiit makaꞌ puniꞌ hiut, npoin naꞌkon makaꞌ uuꞌ goes reꞌ mrian ii kah een. Sin puink ein koꞌu ma maꞌafaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Rarit au ꞌiit aꞌtein, makaꞌ puniꞌ hiut. Mes ain mapuut ee nfuu sin ma namnenen. Onaim sin nꞌaap ein. ");
INSERT INTO aaz_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Onaim maak aap ein naan anꞌoor naan maak mapuin ein naan. Rarit au ꞌfeen. Onaim au utoon amneit ein ia ꞌeu ahiint ein. Mes ka nmuiꞌ fa tuaf es, reꞌ nabeiꞌ he nbaan amneit ein naan.” ");
INSERT INTO aaz_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Rarit naiꞌ Yusuf anbaisenu mnak, “Aam usiꞌ. Amneit ein naan, sin aꞌmoufk ein meesꞌ aah. Uisneno natoon nain ko, saaꞌ-saaꞌ reꞌ In he nmoeꞌ je, tua. ");
INSERT INTO aaz_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Amneit ein naan sin aꞌmoufk ein on nai: bijae hiut apookt ein naan, ma maak hiut mapuin ein naan, esan reꞌ oras amnaaht ein anho-hoen toon hiut. Sin aꞌmoufk ein meesꞌ aah. ");
INSERT INTO aaz_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma bijae hiut amaknaut ein naan, ma maak puin hiut aꞌaap ein naan, esan reꞌ oras amnahas toon hiut, tua. ");
INSERT INTO aaz_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Onaim Uisneno natoon nain saaꞌ reꞌ In he nmoeꞌ je, tua. On reꞌ feꞌe na au uꞌuab. ");
INSERT INTO aaz_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hit of attean oras athoes toon hiut atbi pah Masir ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Rarit naꞌ hit ttean oras amnahas toon hiut. Amnahas naan maꞌtaniꞌ, tar antea ka tiit tain fa mnahat tbi hit pah ia. Areꞌ pah ii namnaah ok-okeꞌ, tar antea sin ka namnau ntein fa oras mnaaht ein nhoen. ");
INSERT INTO aaz_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Onaim aam usiꞌ, ho mupein mneit no nua reꞌ naan, in aꞌmoufk ein nak, Uisneno nafeek anrair nak, ka ꞌroo fa ntein ate, saaꞌ reꞌ In nafeek sin naan, ro he njair. ");
INSERT INTO aaz_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Es naan ate, au ꞌpeint ii on nai, tua: reko nneis aam usiꞌ ho maim tua ahiint es, reꞌ anꞌurus nahiin nok reko. Rarit ho mait je he nꞌator ma naroitan rek-reko pah reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Oras mnaah ahoet toon hiut naan, reko nneis aam usiꞌ ho mait tua ꞌteet es antein, he in nkaububuꞌ penaꞌ-makaꞌ naꞌko too gui sin renen. Penaꞌ-makaꞌ naan anbait sin paaꞌ niim, he natunuꞌ paaf es. ");
INSERT INTO aaz_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sin ro he natuin aam usiꞌ ho prenat, he sin ntoupun penaꞌ-makaꞌ naꞌko kuan-kuan nbin pah Masir ia. Rarit sin ro he natunuꞌ sin nbin umin reꞌ he tatunuꞌ mnaaht ein. Rarit ro he npao sin rek-reko. ");
INSERT INTO aaz_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","He karu toon hiut amnahas naan antea te, hit feꞌ atmuꞌi mnahat. Karu sin nꞌaotr ee on reꞌ naan ate, ka tiit fa tuaf he namnaah anmaet, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Anneen naiꞌ Yusuf naꞌuab on naan ate, uisf ee ma in aꞌnaak koꞌun ein, anromin he natuin in uab ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Rarit uisf ee naꞌuab am nak, “Uisneno In Asmaan ee ankuaas naiꞌ Yusuf reꞌ ia. Es naan ate, hit ka neu he tapein fa tuaf es antein, reꞌ nneis naꞌko naiꞌ Yusuf.” ");
INSERT INTO aaz_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Rarit uisf ee naꞌuab nok naiꞌ Yusuf am nak, “Uisneno natoon ko areꞌ kanan rasin ia. Oras ia, hai feꞌ mihiin mak ho atoin ahinit ko. Ma ho mahiin maan nneis naꞌko too mfaun. ");
INSERT INTO aaz_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Onaim oras ia, au ꞌait ko mjair au atoin mapirsaꞌi. Ho mjair aꞌnakat ambi au sonaf. Au too ngguin ro he natuin ho preent ein. Mes arahaa au ꞌmees, naꞌ au ꞌneis ko.” ");
INSERT INTO aaz_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Rarit uisf ee nous in krein mamarak, ma napaekb ee neu naiꞌ Yusuf in akrurun. Ma in naꞌuab am nak, “Nok ranan ia, au usaeb ꞌpiruꞌ-baru ꞌeu ko mjair au atoin mapirsaꞌi nbi pah Masir ia.” Rarit in napakeb naiꞌ Yusuf baru mnaun maꞌoos es, ma naꞌheekb ee ꞌhekeꞌ mnaut es. ");
INSERT INTO aaz_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Rarit in nanaꞌat in akreet bikaes es anteniꞌ, he naiꞌ Yusuf ansae. Anmuiꞌ tuaf-tuaf naen anbi kreet naan in matan ma nkoaꞌan nafan-faink ein am nak, “Awoo! Misoit ranan! Amfee hormaat! Aꞌnaet ii, he nkoen on ankoon!” Nok ranan naan, uisf ee nait naiꞌ Yusuf anjair in atoin mapirsaꞌi nbi pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Rarit uisf ee naꞌuab nok naiꞌ Yusuf am nak, “On nai. Ho muhiin main, au reꞌ ia usif. Au utoon aꞌrair too pah Masir ꞌak, karu ho ka mkonan sin fa te, sin ka nabeꞌin fa he nmoꞌen saaꞌ-saaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Rarit uisf ee nakanab naiꞌ Yusuf am nak, Safnat Panea, natuin abitan Masir sin kaank ein. In nasaob naiꞌ Yusuf nok riꞌ feot muinf es, in kaan ee bi Asnat. Naiꞌ Yusuf in aam baabf ee, kaan ee naiꞌ Potifera. In es reꞌ naꞌnaak rais pirsait anbi kota On. Nok ranan naan, naiꞌ Yusuf njair atoin makanaꞌ ma matekaꞌ nbi pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Oras sin nasaeb naiꞌ Yusuf aꞌpiruꞌ-baru te, in nmoin naan toon boꞌ teun goen. Rarit in nnao nfuun am nateef kuan-kuan ma bare-bare nbi pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Anbi oras athoes toon hiut naan, sekit ma mnonut anho-hoen. ");
INSERT INTO aaz_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Rarit naiꞌ Yusuf annao ma nkaububuꞌ sekit ma mnonut anneisi ntein, ma natunuꞌ sin nbin umin reꞌ he tatunuꞌ mnaaht ein. Sekit ma mnonut naꞌko bare-bare reꞌ npaumaak kota mee te, in natunuꞌ sin nbi uim ꞌtunuꞌ buaꞌ nbi kota naan. ");
INSERT INTO aaz_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tar antea makaꞌ reꞌ in nkaububuꞌ ma natunuꞌ sin naan, mfau-rutu. On reꞌ snaen ee et tais je ninin, tar antea ka tiit fa tuaf es, reꞌ bisa nsoiꞌ naan sin. ");
INSERT INTO aaz_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Oras amnahas naan ka ntea fa feꞌ, naiꞌ Yusuf in fee bi Asnat nahoniꞌ riꞌaan mone nua. ");
INSERT INTO aaz_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Onaim naiꞌ Yusuf naꞌuab am nak, “Uisneno nmoeꞌ kau ma au ꞌnikaꞌ ain au susat oras au ꞌpoi uꞌko au amaꞌ in umi.” Es naꞌ in nakanab in aan moen unu, naiꞌ Manase (reꞌ he noi on reꞌ kata es antein, nak ‘nikan’). ");
INSERT INTO aaz_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Oras in napein riꞌaan moen muin je te, in naꞌuab antein am nak, “Au upein suust am nanaꞌrenat amfaun ꞌbi bare ia. Mes Uisneno nfee kau tetus, ma au uhoniꞌ ꞌbi ia.” Onaim in nakanab riꞌanaꞌ naan, naiꞌ Efraim. ");
INSERT INTO aaz_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Rarit oras athoes toon hiut naan namsoup. ");
INSERT INTO aaz_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Onaim oras amnahas toon hiut naan anmurai ntaam, natai nok reꞌ naiꞌ Yusuf naꞌuab nain je. Anbi bare-bare, amnaahs ii ntaam een, mes anbi pah Masir, anmuꞌi mnahat. ");
INSERT INTO aaz_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ꞌRoo-ꞌroo on naan ate, abitan pah Masir anmurai namnahan. Rarit sin nnaon ma ntotin amnahat naꞌko usif. Onaim uisf ee nreek sin he nnaon neu naiꞌ Yusuf, he natuin in aprenat. ");
INSERT INTO aaz_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mes amnahas naan maꞌtain reꞌuf. Bare-bare nbi pah Masir in nanan napenin amnahas ok-okeꞌ. Onaim naiꞌ Yusuf anmurai nasoit uim ꞌtunuꞌ mnaaht ein ma naꞌsosaꞌ penaꞌ-makaꞌ neu abitan Masir. ");
INSERT INTO aaz_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Rarit biak ein naꞌkon mee-mee neman ma nsosan amnahat naꞌkon naiꞌ Yusuf nbin pah Masir. Natuin oras amnahas naan batuur-batuur maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Oras naan, aam Yakop anneen biak ein naꞌuab ein am nak, anmuiꞌ penaꞌ-makaꞌ et pah Masir. Onaim in naꞌuab nok in aanh ein am nak, “Hae, riꞌaan ein! Hi mtook he mtakaꞌnanaꞌ on reꞌ naan, aa oo? ");
INSERT INTO aaz_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Au ꞌneen aꞌrair nak anmuꞌi mnahat et pah Masir. Reko nneis hi mnao he msoos kit. Maut he on naan ate, hit kaisaꞌ tamnaah atmaet.” ");
INSERT INTO aaz_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Rarit naiꞌ Yusuf in taatf ein reꞌ tuaf boꞌes naan, nabaarb ein he nnaon nsosan amnahat neun pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mes naiꞌ Yakop ka nkonan fa naiꞌ Yusuf in orif naiꞌ Benjamin he nok sin. In natenab am nak, “Kais-kaisaꞌ riꞌanaꞌ naan napein siraak amsaꞌ on reꞌ in tataf.” ");
INSERT INTO aaz_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Anbi mee-mee te, biak ein annenan nrarin nak anmuꞌi mnahat et pah Masir, es naan ate, too mfaun ii nnaon ma nsosan amnahat anbin naan. Amnahas naan, ro nanoon antean pah Kanaꞌan amsaꞌ. Rarit naiꞌ Yakop in aanh ein annaon ma nsosan amnahat anbin nee msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Oras naan, naiꞌ Yusuf anjair tua pirsaꞌi neu usif pah Masir. Karu sekau-sekau neem naꞌko mee-mee he nsoos penaꞌ-makaꞌ te, naiꞌ Yusuf es naꞌsosaꞌ nfeen sin. Es naꞌ oras in taatf ein neman ntean ate, sin nriꞌtuun ma nhormaat ee, tar antea sin nneek afu. ");
INSERT INTO aaz_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Oras in niit sin on naan ate, in nahiin nain sin. Mes naiꞌ Yusuf nmoeꞌ jon on reꞌ atoin Masir, es naꞌ sin ka nahiin je fa. Rarit in nataan sin nok haan sesu mnak, “Hi reꞌ ia, miꞌko mee?” Sin natahan am nak, “Ho aten kai miꞌko pah Kanaꞌan. Hai iim he msoos amnahat miꞌko ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Rarit naiꞌ Yusuf namnau in amneit ein unuꞌ feꞌ. In akaꞌtau sin am nak, “Au ka ꞌpirsai ki fa! Hi of asuntirus ki. Hi iim maim he mihiin pah Masir in maꞌniifk ein, rarit hi mtebi mfain he iim ma mbaan kai, aiꞌ?” ");
INSERT INTO aaz_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mes sin natahan am nak, “Kaah, tua! Hai reꞌ ia suma ho aetn aa kai. Batuur-batuur hai suma iim he msosa haa mnahat. ");
INSERT INTO aaz_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Hai arkai reꞌ ia, hai amaꞌ meseꞌ. Hai ka asuntirus kai fa, tua! Hai atoin rekon kai, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mes naiꞌ Yusuf naꞌuab naheer am nak, “Hoe! Hi mipoi. Kais amputa-kriu kau! Au uhiin ꞌain ꞌak hi asuntirus ki. Hi iim he maim pah reꞌ ia in maꞌniifk ein!” ");
INSERT INTO aaz_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Rarit sin npenan reꞌuf. Onaim sin natahan neun naiꞌ Yusuf am nak, “Kaah, tua! Hai reꞌ ia suma ho aetn aa kai. Hai iim miꞌko pah Kanaꞌan. Hai mmaꞌori-tatan boꞌes am nua. Hai arkai amaꞌ meseꞌ. Hai oriꞌ aheit suus goe namaikaꞌ nok hai amaꞌ. Ma hai oirf es anteniꞌ, annao namneuk.” ");
INSERT INTO aaz_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Naiꞌ Yusuf nataah sin am nak, “Kahaf! Batuur uab reꞌ feꞌe na au aaꞌ ee naan. Hi reꞌ ia ro asuntirus ki. ");
INSERT INTO aaz_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Onaim hi ro he mfee kau bukti feꞌ, he au uhiin ꞌak hi uab ein feꞌe na batuur, aiꞌ kaah. Au ꞌsuup! Karu hi oriꞌ aheit suus goe ka mok ne neem fa neu ia te, hi ka bisa fa he mnao misaitan pah reꞌ ia! ");
INSERT INTO aaz_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Onaim hi mpiir maan tuaf es he nnao naan hi oriꞌ neem neu ia. Biak ein, au ꞌtahan sin. Au he ꞌiit, hi uab ein naan batuur, aiꞌ kaah. Karu kaah fa te, namneo, hi reꞌ ia asuntirus ki.” ");
INSERT INTO aaz_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Rarit naiꞌ Yusuf anrenu ma nataam sin neu bui je nanan, neno teun. ");
INSERT INTO aaz_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Neno teun on naan ate, naiꞌ Yusuf annao ma naꞌuab nok sin anbin bui je mnak, “Au reꞌ ia, umtausan Uisneno. Ma au utuin In roimn ee piut-piut. Au ufetin ki he hi mmoin. Mes hi ro he minokab uab es. ");
INSERT INTO aaz_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Karu hi uab ein batuur-batuur namneo te, hi ro he mikriraꞌ kau bukti. In raan aꞌpoiꞌ ji on nai: au ꞌtahan tuaf es anbi bui reꞌ ia. Hi bian amfain meu hi pah ee, he meiki mnahat meu hi nonot-asar sin. Natuin sin npao ki he mekin sin amnahat. ");
INSERT INTO aaz_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Rarit hi iim meik hi oirf aan, he njair bukti es, nak hi atoin neek amneꞌo. On naan ate, hi ka mipoi kau fa. Maut he nok ranan naan ate, au kais aꞌhukun uꞌmaet ki.” Sin nnenan on naan ate, sin nromin. ");
INSERT INTO aaz_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Rarit sin naꞌuab ein es nok es am nak, “Neu! Reok goen! Oras ia hit tapein hit aꞌmoꞌek neno naan in aafn ii jen. Hit tmoeꞌ reꞌuf neu hit oriꞌ. Hit tkius tiit ee neu in nsuus anmaet, in ntoit neik haan sakoit he hit ttuurn ee, mes hit ka tfairoir je fa. Etun oras ia, hit tsuus on reꞌ ia msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Onaim naiꞌ Ruben namnaub sin am nak, “Hae, sin au oriꞌ arki. Neno naan au ꞌtaar ki, he kais minsaaꞌ-saaꞌ riꞌanaꞌ naan! Mes hi ka mko-kosen main fa au uabak naan. Onaim oras ia, hit tseu fuan ii jen. Naiꞌ Usu in naaꞌ ee nsaen kit een.” ");
INSERT INTO aaz_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sin naꞌuab ein on reꞌ naan, mes sin ka nahinin fa neu naiꞌ Yusuf nahiin sin uab. Natuin oras naiꞌ Yusuf naꞌuab nok sin ite, in npaek uab Masir. Rarit naꞌ anmuiꞌ akoniꞌ uabaꞌ naꞌbain ee neu sin npaek uab Ibrani. ");
INSERT INTO aaz_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Anneen sin naꞌuab ein on naan ate, naiꞌ Yusuf annao nasaitan sin, ma nkae nmes-mees nbi bare reꞌ biak ein ka niit ee fa. Oras in nkae nrari te, in nfain neem neu sin. Rarit in nreek tuaf ma nfuut naiꞌ Simeon nbi in orif-tataf sin humak ma sin matak. ");
INSERT INTO aaz_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Rarit naiꞌ Yusuf naprenat in ameupt ein he narain penaꞌ-makaꞌ neu in taatf ein sin aꞌkaor ein. Ma sin ro he ntao nafaniꞌ roit ein nbin aꞌkaor ein sin feefk ein. Rarit ansoo sin. In nrenu he nfeen sin betiꞌ msaꞌ. Ameupt ein naan anmoꞌen natuin naiꞌ Yusuf in aprenat. ");
INSERT INTO aaz_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Rarit naiꞌ Yusuf in taatf ein nasaeb aꞌkaor ein naan neun sin bikaes keledai ngguin. Rarit sin npoin ma nnaon nasaitan pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Anbi raan atnanaꞌ, sin nasnasan. Oras tuaf es anfei in aꞌkaroꞌ he naꞌeku in bikaes keledai te, in niit in roit ein anbin aꞌkaor ee fefan. ");
INSERT INTO aaz_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","In naskeek! Onaim in nhaman in orif-tataf sin am nak, “Hoi! Hi iim he mkius miit ia feꞌ! Hit tmate tkoon! Sin ntao nafaniꞌ au roit ein esan au ꞌkaroꞌ.” Ankius nitan on naan ate, sin neek ein namnekun. Sin namtau nmaten. Rarit sin naꞌuab ein am nak, “Uisneno ntao saaꞌ antein es reꞌ ia neu kit?” ");
INSERT INTO aaz_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Rarit sin nnaon nkonon. Antean Kanaꞌan on naan ate, sin naretaꞌ neu sin aamf ee, saaꞌ-saaꞌ reꞌ sin nnaben niit ee, nmurai naꞌko sin nbin pah Masir, tar antea sin nfain neman. ");
INSERT INTO aaz_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Sin natonan am nak, “Aam honiꞌ! Usif pah Masir in tua pirsaiꞌ je, maꞌtain reꞌuf. In naꞌuab aah amsaꞌ, ka tiit fa haan maꞌnuraꞌ. In ntubin ma ntuꞌiran kai, mnak hai mnao msuntiur in pah. ");
INSERT INTO aaz_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mes hai mitaah am mak, ‘Kaah fa, tua! Hai miꞌuab batuur namneo, tua. Hai arkai reꞌ ia, ka asuntirus fa, tua. ");
INSERT INTO aaz_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hai atoin neek rekon kai, tua. Hai mmaꞌori-tatan tuaf boꞌes am nua. Hai amaꞌ meseꞌ. Mes tuaf es naꞌko kai, nnao namneuk, ma aheit suus goe namaik nok hai amaꞌ et pah Kanaꞌan.’ ");
INSERT INTO aaz_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Rarit kaes kouꞌ goe nak, ‘Au he ꞌsobaꞌ ki. Hi atoin amneot, aiꞌ kaah. Hi tuaf es ro he nabaar anbi ia. Hi bian amfain, meiki mnahat meu hi nonot-asar sin, he sin kaisaꞌ namnaah anmaten. ");
INSERT INTO aaz_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hi ro he meik hi oriꞌ neem neu ia feꞌ. Nok ranan naan ate, naꞌ au uhiin ꞌak hi ka asuntirus ki fa, mes batuur-batuur hi atoin neek amneꞌo. Onaim au of ufetiꞌ ki hi benuꞌ reꞌ au ꞌtaahn ee reꞌ naan. Ma au ꞌkonan ki he mnao meu mee-mee jah, ambi pah reꞌ ia.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Anpeo nrarin on naan ate, sin npukai sin aꞌkaor ein. Sin naskeken, natuin sin es-es ate, niit sin roit ein nbin sin aꞌkaor ein. Ankius on naan ate, naiꞌ Yakop nok in aanh ein namtau nmaten. ");
INSERT INTO aaz_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Rarit naiꞌ Yakop naꞌuab nok sin am nak, “Hi ꞌmoeꞌm ein, es naꞌ au aanh ein namnekun. Naiꞌ Usu namneuk goen. Amteniꞌ naiꞌ Meon. Oras ia hi he meiki mtein naiꞌ Min? Batuur-batuur hi he mhaꞌmuiꞌ kau, es reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Onaim naiꞌ Ruben naꞌuab neu in aamf ee mnak, “Aam honiꞌ! Amfee kau naiꞌ Min. Au utaah. Au ꞌbaꞌan ꞌain, au ro he ꞌuum ꞌeik je nfain neem ꞌeu ko, aam honiꞌ. Mes karu kaah fa te, aam honiꞌ, ho mroor au aan moen nuaꞌ ein naan.” ");
INSERT INTO aaz_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mes naiꞌ Yakop naꞌuab am nak, “Kahaf! Ka nabeiꞌ fa he hi meik naiꞌ Min. In tataf naiꞌ Usu nmate nrair. Oras ia, aar in nmees. Karu in napein siraak anbi raan atnanaꞌ te, hi misusab miis kau, au atoni mnasiꞌ ia, tar antea au ꞌtaam ꞌeu nopu ꞌmaten.” ");
INSERT INTO aaz_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Oras naan, amnahas anbi pah Kanaꞌan maꞌtain besi ntein. ");
INSERT INTO aaz_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Naiꞌ Yakop in uim je naan ee, nararin nrair amnaaht ein reꞌ neon goes ii, in aanh ein annaon nsoos sin naꞌkon pah Masir. Rarit in nak sin am nak, “Riꞌaan ein! Reko nneis hi mfain meu pah Masir, he msoos amtein kit amnahat feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Mes naiꞌ Yahuda nataah am nak, “Aam honiꞌ! Neon goes ii, usif pah Masir in tua pirsaiꞌ je namnaub kai maꞌtaniꞌ nak, hai ka mibeiꞌ fa he mikriraꞌ hai huum ein meu ne, karu hai ka mok fa ho aan aheit susu naiꞌ Min! ");
INSERT INTO aaz_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Onaim aam honiꞌ. Ho ro he mkonan kai naiꞌ Min, he nok kai, henaꞌ hai mfain he msoos kit amnahat. ");
INSERT INTO aaz_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mes karu ho ka mkonan kai fa naiꞌ Min ate, hai ka neu he mnao fa. Atoin Masir naan naꞌuab anrair on naan ate.” ");
INSERT INTO aaz_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","On nai te naiꞌ Yakop nakain sin am nak, “Nansaaꞌ am es hi mitonan atoniꞌ naan mak hi feꞌ ammuiꞌ oir muni es antein! Hi mami haa kau susat antein!” ");
INSERT INTO aaz_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Rarit sin nfuriꞌ naiꞌ Yakop am nak, “Aam honiꞌ! Atoniꞌ ne nataan piut, he nahiin kit nok nain hit uim je naan ee ok-okeꞌ. In nataan am nak, ‘On mee? Hi amaꞌ nmoin feꞌe, oo? Hi mmuiꞌ orif et hi umiꞌ feꞌe, oo?’ Onaim hai he mak saaꞌ antein! Onaim ro hai mitoon namneo goah. On nai te, sekau nahiin nain nak, in he nreun kai he hai mok naiꞌ Min on nee?” ");
INSERT INTO aaz_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Naiꞌ Yahuda naꞌuab antein am nak, “Aam honiꞌ! Mufetin kai naiꞌ Min he nok kai. Au ꞌbaꞌan ain, karu npoi saaꞌ-saaꞌ neu ne te, au utaah he ꞌsenuꞌ. Karu au ka ꞌeik je nfain neem fa nok ao-minaꞌ neu ko te, maut he ho musaan kau tar antea au ꞌmaet. Onaim ho mkonan kai naiꞌ Min, fin hai he mna-nao goa heen. Reko nneis hai mnao nai rabah, he hit kais tamnaah atmaet. ");
INSERT INTO aaz_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bait hai kais ampao ꞌroo-ꞌroo te, hai mnao ma mfain iim no nua goen.” ");
INSERT INTO aaz_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Rarit sin aamf ee nak, “Karu on naan ate, hi mmoeꞌ on nai: hi mnao mait meik hau fuaꞌ ma fuboon reko naꞌko hit pah. Esan reꞌ: bumbu sin, hau oef reꞌ foo meniꞌ, reꞌu he ttuis, oin hau, kanari, ma knaaꞌ bian. Rarit meik sin meu usif pah Masir in tua pirsaꞌi naan, ma mitoon am mak hai baerꞌ ein reꞌ ia njarin ook-sonun neu ko. ");
INSERT INTO aaz_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hi msaꞌ meiki mtein roit amsaꞌ anfain no nua naꞌko oras neon goes ii hi mnao. Natuin hi ro he mnonaꞌ mifaniꞌ roit ein reꞌ hi miit sin anbin hi ꞌkaor ein neon goes ii. Kais-kaisaꞌ sin es reꞌ antaon nsaan sin. ");
INSERT INTO aaz_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hi mok hi oriꞌ, mes natiꞌ mfain iim rabah, oo! ");
INSERT INTO aaz_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Au ꞌon-ꞌonen, karu Uisneno reꞌ Akuasat Maꞌtaniꞌ, nabanit usif pah Masir in tua pirsaꞌi naan he nkasian ki. He karu reko te, in nnonaꞌ nafaniꞌ ki au anah naiꞌ Min am naiꞌ Meon, he hi mfain iim buꞌ-buaꞌ. Mes karu au aanh ein namnekun okeꞌ te, maut he au usaah susat ia nkoon piut.” ");
INSERT INTO aaz_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Rarit sin nnaon ma nakbuaꞌ ein baer ook-soun ein am roit, he neikin nnaon neun pah Masir. Sin nok naiꞌ Benjamin amsaꞌ. Antean nee te, sin nnaon nbaiseun naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Oras naiꞌ Yusuf niit naiꞌ Benjamin nok in taatf ein ate, in nreek aꞌnaak mepu nbi in umi mnak, “Hoe! Meik atoin ein reꞌ ia ntaman neun au umi! Rarit amroor bijae jes, mihaan ee rek-reko. Sin ro he nbukaen nok kau oras maans ee naꞌpuup.” ");
INSERT INTO aaz_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Rarit aꞌnakat naan nmoeꞌ natuin naiꞌ Yusuf in aprenat. Onaim in nnao naat sin neu naiꞌ Yusuf in umi. ");
INSERT INTO aaz_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Oras sin nnaon neun naiꞌ Yusuf in umi, in taatf ein namtaun nmaten. Anbin raan ee te, sin naꞌuab ein am nak, “Amoo! Nansaaꞌ am es in nreun he neik kit teu ia? Kais-kaisaꞌ in he nasusab kit, natuin roit ein reꞌ sin nfee nafaniꞌ kit sin anbin hit iꞌkaor ein neon goes ii. Sin nmoeꞌ napo-poi kit he neem naat kit teu ia, he nok askeken ate, sin nheek kit, ma nmoeꞌ kit atjair sin aten. Rarit sin nasiik naan hit bikaes keledai ngguin okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Etun oras sin npaumaak naiꞌ Yusuf in uim je te, sin nataan aꞌnakat naan am nak, ");
INSERT INTO aaz_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Aam, kais mutoꞌ-toꞌon kai. Neon goes ii, hai iim amsoos miit amnahat ambi ia. ");
INSERT INTO aaz_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Rarit oras hai mfain meu hai kuan, hai misnaas ambi raan ee he mtuup. Onaim hai mfei ꞌkaor ein he miꞌekuꞌ muiꞌt ein. Heꞌe! Hai mtae miit hai roit ein, ntao nafaniꞌ kai sin inbin hai kaor maak ein sin feefk ein. Hai ka mihiin he sekau es reꞌ antao sin naan. Mes oras ia, hai meik mifaniꞌ sin okeꞌ. Onaim aam, kais mutooꞌ goo! Maut he ho muhiin, oras ia hai meik roit bian anteniꞌ he msoos amnaah amtein.” ");
INSERT INTO aaz_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Rarit aꞌnakat naan nataah sin am nak, “Hi mtaꞌ-taaꞌ kiim. Kais mimtau! Of oniꞌ hi Uisneon nggoe es anfee tetus neu ki nbi hi ꞌkaor ein naan. Neon goes ii, au ꞌtoup urair hi roit ein naan okeꞌ. Hi ka mmuiꞌ fa tusaꞌ!” Rarit in napoit naiꞌ Simeon naꞌko bui je he nabua nok sin. ");
INSERT INTO aaz_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Onaim sin ntaman okeꞌ neu naiꞌ Yusuf in umi. Rarit aꞌnakat naan anfeen sin oe ma nafaun sin haek ein. In naꞌekuꞌ sin bikaes keledai ngguin amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Rarit in natoon am nak, “Hi of ambukae mok hai aam usiꞌ oras maans ii naꞌpuup.” Oras sin npao naiꞌ Yusuf he neem nateef nok sin ite, sin nꞌator ook-soun ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Oras naiꞌ Yusuf neem antea te, sin nriꞌtuun ok-okeꞌ nbin in human ma in matan. Rarit sin nnonaꞌ ook-soun ein neu na. ");
INSERT INTO aaz_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Rarit naiꞌ Yusuf nataan sin am nak, “On mee? Hi arki mꞌao-minaꞌ, oo? Hi ama mnasiꞌ on mee? In nꞌao-minaꞌ msaꞌ, aa oo?” ");
INSERT INTO aaz_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sin natahan am nak, “Ho ate mnais ee, reꞌ hai aam honiꞌ, et reꞌ nee. In nꞌao-miin, tua.” Onaim sin naꞌruir ein ma nhormaat anteinꞌ ee. ");
INSERT INTO aaz_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Rarit naiꞌ Yusuf nait matan am ankius niit in orif naiꞌ Benjamin. Sin nua sin, ainaf ma amaf meseꞌ. Onaim in nak, “Ooo! Hi oriꞌ aheit susu reꞌ neon goes ii hi miton-toon ee ji, es reꞌ ia!” Rarit in naꞌuab neu naiꞌ Benjamin am nak, “Baꞌe! Au ꞌon-ꞌonen he Uisneno nfee ko tetus kouꞌ-koꞌu.” ");
INSERT INTO aaz_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ankius naiꞌ Benjamin on naan ate, naiꞌ Yusuf in rasi mnaut neu in oirf ee he noi npeꞌ-peeꞌ jah een. Natuin in nneek niis in orif naiꞌ Benjamin. In ka bisa ntahan naan fa in nekan naan antein. Onaim in nnao ntaam neu in keeꞌn ee rabah. Rarit in nkae nmeꞌ-meꞌur anbi naan. ");
INSERT INTO aaz_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ankae nrari te, in nnao nameu in human. In nafaniꞌ in nekan, rait in nnao nateef nok sin. Onaim in nreun in ameupt ein uim je naan ee, he nabaarb ein bukaet neun mei. ");
INSERT INTO aaz_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sin nabarab bukaet neu naiꞌ Yusuf anbi mei jes in nmees kuun. In orif-tataf sin nbukaen nbin mei jes aꞌtetaꞌ. In ameupt ein, nbukaen nbin mei jes kuuk. Natuin atoin Masir sin nnaben ate sin nhaiꞌniis sin tuak ein karu sin nbukaen buꞌ-buaꞌ nok atoin Ibranis sin. ");
INSERT INTO aaz_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aꞌnakat naan anꞌator anrair he naiꞌ Yusuf in orif-tataf sin antokon nmabain ein nok naiꞌ Yusuf. In nꞌator sin he ntokon nmaktun-tuin ein nmurai naꞌko atoin kouꞌ goe ntea aheit susu. Oras sin ankius niit reꞌ moꞌet reꞌ ia te, sin nsanmakan. ");
INSERT INTO aaz_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Rarit naiꞌ Yusuf anꞌator he in ameupt ein naan naitin bukaet naꞌkon in mei je neun in orif-tataf sin. Sin ntoupun humaꞌ meseꞌ. Mes naiꞌ Benjamin antoupu mfaun anneis no niim naꞌko in taatf ein naan. Rarit sin nbukaen tar antea sin namsenan batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sin nbukaen nrarin ate, naiꞌ Yusuf naꞌseꞌ-seꞌo aꞌnaak mepu nbi in uim je mnak, “Hoe! Ho mnao murai penaꞌ-makaꞌ meu atoin ein ia sin aꞌkaor ein naan, nahen-henun. Rarit ho mtao mufaniꞌ sin roit ein es-es ate meu sin aꞌkaor ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Rarit ho mait au ꞌkoom noin muit ee, ma mtao goe meu aheit suus goe in aꞌkaor aan.” Onaim in nmoeꞌ natuin naiꞌ Yusuf in aprenat. ");
INSERT INTO aaz_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Maan reꞌ snaat ee nsae te, naiꞌ Yusuf nafetin sin nok sin bikaes keledai ngguin he nnaon nfanin ma neikin amnahat. ");
INSERT INTO aaz_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sin nnaon ka ꞌroo fa feꞌ naꞌkon kota naan ate, naiꞌ Yusuf natoon neu aꞌnakat naan am nak, “Ho mnao mriuꞌ mutuin atoin ein naan rabah. Karu mupein sin ite, ho mak sin am mak, ‘Nansaaꞌ am es hi mmoeꞌ maufinu meu ꞌnaef ee? Hi mbaras in neek reok goe nok moeꞌ reꞌuf on naan! ");
INSERT INTO aaz_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","On mee mꞌes hi mibaak meik hai aꞌnaak te in aꞌkoom noin muit ee? Hi ka mihiin fa, oo? Naan ka npaek je fa he nbukae oe nmees jah. Anpaek je he naim atoniꞌ in uan, natuin aꞌkomaꞌ naan matuaꞌ ate! Hi moeꞌm ein ia, ro reuꞌ besi!’ ” ");
INSERT INTO aaz_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Rarit aꞌnakat naan nriuꞌ natuin sin tar antea napein sin. Onaim in natoon neu sin natuin ahaa naiꞌ Yusuf in uaban feꞌe na. ");
INSERT INTO aaz_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Rarit sin npenan mates am nak, “Aam, ho sairt ii, on mee? Hai msuup. Hai ka neu he mibeiꞌ fa he mmoeꞌ reꞌuf on naan! ");
INSERT INTO aaz_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ho muhiim kuum. Roit ein reꞌ neon goes ii nbin hai ꞌkaor ein naan, hai mfee sin nfanin neu ko. Onaim hai ka mibeiꞌ fa he mibaak hi aꞌnaak te in aꞌkomaꞌ naan naꞌko in umi. Hai ka neu he mibaak fa, tua! ");
INSERT INTO aaz_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Aam, ho mpukai ma mtae kuum. Mupein aꞌkomaꞌ naan anbi sekau in aꞌkaor ate, amhukun misan! Maut he hai bian ii, mjair ate meu ko.” ");
INSERT INTO aaz_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Rarit aꞌnakat naan naꞌuab am nak, “Kahaf! On nai. Karu au ꞌiit ee nbi sekau te, in reꞌ naan anjair au ate. Hi bian ii, mnao mkoon.” ");
INSERT INTO aaz_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Onaim sin nasanut aꞌkaor ein naan, rabah. Rarit sin npukai nain sin. ");
INSERT INTO aaz_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Onaim aꞌnakat naan anparikas aꞌkaor ein naan barisi, nmurai naꞌko atoin kouꞌ goe iin je, ntea aheit suus goe iin je. Onaim in niit aꞌkoom noin mutiꞌ naan, anbi naiꞌ Benjamin in aꞌkaroꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ankius nitan on naan ate, naiꞌ Benjamin in taatf ein sin neek ein akratiꞌ-krait ein. Rarit sin nasaeb nafaniꞌ sin aꞌkaor ein neun sin bikaes keledai ngguin, he ntaman nfanin neun kota. ");
INSERT INTO aaz_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Oras sin ntean naiꞌ Yusuf in uim je te, in nbi naan feꞌ. Onaim sin nriꞌtuun anbin naiꞌ Yusuf in human ma in matan. ");
INSERT INTO aaz_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Rarit naiꞌ Yusuf naskarak sin am nak, “Hoe! Nansaaꞌ am es hi mmoeꞌ kau on reꞌ ia? Hi ka mihiin fa? Aꞌnaet on reꞌ au, anpaek reꞌu reꞌ he naim atoniꞌ in uan.” ");
INSERT INTO aaz_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Rarit naiꞌ Yahuda nataah am nak, “Airoo! Uisneno npukai napoitan hit saant ein. Rarit hai he mak saaꞌ ntein, tua? Hai he mimneob hai tuam ein on mee, tua! Karu ho mtahan hai oriꞌ te, reko nneis ho mtahan kai okeꞌ. Mait kai mjair ho aten.” ");
INSERT INTO aaz_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mes naiꞌ Yusuf nataah am nak, “Kahaf! Niit aꞌkomaꞌ naan anbi sekau te, in es reꞌ he njair au ate! Hi bian ii, mifrei. Amfain nai meu hi amaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Rarit naiꞌ Yahuda nnao npaumak-maak naiꞌ Yusuf, ma naꞌuab am nak, “Au ꞌbaiseun, tua. Au uhiin ꞌak ho kuasam naan natai nok uisf ee in kuasan kuun. Natuin rasi naan, kais mutoꞌon kau, tua. Au ꞌtoit mainuan he au uꞌsitiꞌ aan aꞌkreꞌo, tua. ");
INSERT INTO aaz_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Neon goes ii, ho mutaan kai mmak, ‘Hi amaꞌ nok hi oriꞌ tuaf es etan naa feꞌe, oo?’ ");
INSERT INTO aaz_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Rarit hai mitaah am mak, ‘Hai amaꞌ namnasi nrair. Hai oriꞌ aheit suus goe meseꞌ. Oras nahoins ee te, hai amaꞌ namnais jen. Aheet suus goe in taatf ee, nmate nrair, tua. Sin nua sin, sin ainf ee nmate nrair. Onaim oras ia, hai oriꞌ aheit susu naan, in nmees. Es naꞌ hai amaꞌ nneek niis ne.’ ");
INSERT INTO aaz_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Rarit ho mreun kai he hai meik hai oriꞌ, he ho miit ee. ");
INSERT INTO aaz_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Onaim hai mitaah am mak, ‘Riꞌanaꞌ reꞌ ne, ka neu he nnao nporiꞌ fa hai amaꞌ. Karu in nnao npoirn ee te, hai amaꞌ ro he nmaet kuun nai, es reꞌ naan.’ ");
INSERT INTO aaz_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","On nai te, ho mutaah am mak, ‘Karu hi ka meik fa hi oriꞌ naan ate, hi ka neu he miit amtein kau fa heen.’ ");
INSERT INTO aaz_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Rarit hai mfain. Hai mtean hai amaꞌ ne te, hai mitoon main rasin reꞌ ho muꞌuab sin meu kai. ");
INSERT INTO aaz_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Aꞌroo-ꞌroo te, hai mnaaht ein oekꞌ ein. Rarit hai amaꞌ anreek kai he mfain iim amtein meu pah Masir he msoos amnahat. ");
INSERT INTO aaz_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mes hai mitaah am mak, ‘Aam honiꞌ! Hai ka neu he mnao fa meu ne ntein. Natuin uisf ee in tua pirsaiꞌ je, naꞌuab nain nak, karu hai ka mok fa hai oriꞌ te, hai ka neu he miit amtein fa in human. Onaim hai ro he meik hai oriꞌ aheit susu naan feꞌ, henaꞌ hai mnao.’ ");
INSERT INTO aaz_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Rarit hai amaꞌ naꞌuab am nak, ‘Hi mihiin main. Au fee bi Rahel in aanh ein, tuaf nua goah. ");
INSERT INTO aaz_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ahuunt ee nnao namneuk. Oniꞌ muiꞌ fui ngguin npius goe ma neku nrair je. Es naꞌ ntea oras ia, au ka ꞌiit aꞌteinꞌ ee fa. ");
INSERT INTO aaz_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Karu hi mait meik aheit suus gui ntein miꞌko kau, ma in napein siraak ate, hi mtao mtein kau susat meu au atoni mnasiꞌ kau gui, he ꞌmaet nai.’ ");
INSERT INTO aaz_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Es naan ate, usiꞌ. Au ꞌbaiseun, tua. Karu au ꞌfain ꞌeu au amaꞌ, mes au ka ꞌok fa aheit susu reꞌ ia te, ro hai amaꞌ nmaet kuun een. Natuin in asmaan ee, nmafuut nok riꞌanaꞌ ia te. On nai te, in namnais reꞌ-reuꞌf een. Onaim karu hai mtao mteinꞌ ee susat, in nmaet nai. ");
INSERT INTO aaz_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Saaꞌ antein, au ꞌbaꞌan urair ꞌeu au amaꞌ ꞌak, au utaah riꞌanaꞌ ia. Au ꞌbaꞌan ꞌeu au amaꞌ, karu au ka ꞌeik ufaniꞌ fa riꞌanaꞌ ia ꞌeu ne, maut he au utaah kuuk sanat naan, tar antea au ꞌmaet. ");
INSERT INTO aaz_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Onaim au ꞌbaiseun, tua. Maut he au umaik aꞌbi ia he ꞌseun ee, henatiꞌ au es reꞌ aꞌjair ho ate. Maut he in nfain nok in taatf ein. ");
INSERT INTO aaz_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Karu riꞌanaꞌ ia ka nok fa te, au ka neu he ꞌfain fa. Au ka neu he ꞌtahan aan fa au tuak, karu au ꞌiit au amaꞌ ansuus tar anmaet.” ");
INSERT INTO aaz_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Anneen on naan ate, naiꞌ Yusuf in neekn ee kratiꞌ-kratiꞌ, tar antea in ka ntahan naan fa in tuan ii ntein nbi in ameupt ein sin maatk ein. Etun in nreun sin he npoin, he in bisa nmees nok in orif-tataf sin. Nok ranan naan ate, in bisa natoon in tuan ee neu sin. ");
INSERT INTO aaz_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Rarit ameupt ein npoin okeꞌ. Onaim naiꞌ Yusuf ankae nmeꞌ-meꞌur ma npin-pinus. In ameupt ein, atoin Masir, reꞌ nhaken nbin moen ee, anneen amsaꞌ. Ma abitan uisf ee in soonf ee nnenan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Rarit naiꞌ Yusuf natoon namneo goah neu in orif-tataf sin am nak, “Airoo, tua. Au reꞌ ia, naiꞌ Usu kau. Hi oriꞌ. Hit arkit atmaꞌori-tatan. Hit amaꞌ feꞌ nmoni, oo?” Annenan on naan ate, in orif-tataf sin namtau nmaten, tar antea sin ka fefaꞌ meseꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Rarit naiꞌ Yusuf nak sin am nak, “Hae! Amsiriꞌ iim he mpaumaak kau feꞌ!” Onaim sin nsiir ein antaman ma npaumaak naiꞌ Yusuf. Onaim in naꞌuab nafanik am nak, “Au reꞌ ia, naiꞌ Yusuf, reꞌ neon goes ii, hi miꞌsosaꞌ mpoirn ee meu pah Masir ia. ");
INSERT INTO aaz_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Amneon ii, hi miꞌsosaꞌ kau goen. Mes kais mimtau, ma kais ammatoe ma mmasanan es nok es. Natuin Uisneno es neik kau ꞌuum aꞌtea ia, he ꞌjair ahunut ꞌeu ki. Nok ranan naan, In npaek kau he In nafetin naan too mfaun ii, he sin kaisaꞌ namnaah anmaten. ");
INSERT INTO aaz_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Oras ia, amnaahs ii feꞌ nnao naan toon nua. Aar toon niim feꞌ. Oras naan, ka tiit tain fa tuaf es he ntoof aiꞌ nkaun, nseen, ma ka tiit fa reen jes reꞌ he nmuiꞌ penaꞌ-makaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nok ranan reꞌ hit ka tahiin tain je fa reꞌ ia, Uisneno neik kau ꞌuum uhuun uꞌko ki. Henatiꞌ naꞌko hi arki, ma hi anah-upuf sin napenin aꞌhonis. ");
INSERT INTO aaz_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Onaim in batuurn ii, ka hi es ammoeꞌ kau fa he au ꞌuum aꞌtea ia, mes Uisneno In aꞌmoꞌen. In es nait kau ꞌjair uisf ee in tua pirsaꞌi ꞌbi pah Masir ia. Onaim au ꞌjair aꞌnakat aꞌbi uisf ee in sonaf. Ka tiit tain fa es he nneis naꞌko kau. ");
INSERT INTO aaz_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Onaim oras ia, hi mfain rabah nai, he mitoon au uabak reꞌ ia meu hit amaꞌ, mak on nai: ‘Aam honiꞌ, ho anah naiꞌ Yusuf anmoin feꞌ! In njair kaes koꞌu et pah Masir. In naskau ko aam honiꞌ, he mnao meu pah Masir rabah nai, tua. ");
INSERT INTO aaz_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Aam honiꞌ of ho mupein mainuan he mutua mbi pah Gosen mpaumaak ee. Bare naan mainuan. Onaim hi bisa mituuk ma miꞌekuꞌ hi ꞌbib-kasen, aꞌbibin, ma bijae ngguin ok-okeꞌ. In ntoit ko msaꞌ, he uum meik ho anah-upuf sin, nok nain sin uim je naan ee, ma sin baer pusaak ein ok-okeꞌ he mitua mibaar ambi nee, tua. ");
INSERT INTO aaz_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Karu aam honiꞌ mutua mbi Gosen ate, in bisa npairoir ko nbi nee. Natuin amnaahs ii aar toon niim antein feꞌ. Onaim in of anꞌator he aam honiꞌ mok ho nonot-asar sin, ma ho muiꞌt ein ok-okeꞌ ka nkuran ma nrabuꞌ fa saaꞌ-saaꞌ, tua.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Naiꞌ Yusuf natoon anrair on naan ate, in naꞌuab antein am nak, “Oras ia, hi miit meik hi matam, aa oo? Ho msaꞌ, Min. Au reꞌ ia, ho tataꞌ naiꞌ Yusuf teb-tebe. ");
INSERT INTO aaz_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Onaim mitoon meu hit amaꞌ mak, au kuasat aꞌbi pah Masir reꞌ ia, kouꞌ reꞌuf. Ma miretaꞌ meu hit amaꞌ saaꞌ-saaꞌ reꞌ hi miit sin. Rarit hi meik je neem rabah nai meu ia!” ");
INSERT INTO aaz_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Rarit in nhoo ma nneek in orif naiꞌ Benjamin, ma sin nua sin ankaen. ");
INSERT INTO aaz_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","In anhoo ma nneek in taatf ein meseꞌ-meseꞌ msaꞌ. Rarit naꞌ sin nmurai naꞌuab ein nok ne. ");
INSERT INTO aaz_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Rarit, oras uisf ee nok in aꞌnaak meupn ein annenan nak naiꞌ Yusuf in orif-tataf sin neman, sin nmariin anmaten. ");
INSERT INTO aaz_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Onaim uisf ee naꞌuab neu naiꞌ Yusuf am nak, “Yusuf! Mutoon meu sin ho benuꞌ, he sin nasaeb ein penaꞌ-makaꞌ neu sin bikaes keledai ngguin, he neikin nnaon neun pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Rarit amreun sin he neik ho amaꞌ ma nonot-asar sin neman okeꞌ, he sin nfooꞌ neman neun ia nai. Au of aꞌfeen sin afu ma bare reꞌ reko nneis nbi pah Masir ia, he sin natuan ma nmonin nbin naan, ma sin napenin amnahat naꞌko bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Amreun sin he sin neik nanin akreet bikaseꞌ fauk naꞌko ia, he sin nasaeb riꞌaan ein, ma ho amaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kais sin natenab baer pusaak ein reꞌ sin ka bisa neik sin fa. Natuin pah Masir ia, naheun nok bareꞌ reꞌ arekot. Sin of anpaar sin.” ");
INSERT INTO aaz_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Anneen on naan ate, naiꞌ Yusuf anfee kreet bikaseꞌ fauk, ma betiꞌ nbi ranan, natuin uisf ee in kabin. Ma in orif-tataf sin nabaarb ein he nfanin natuin uisf ee in kabin. ");
INSERT INTO aaz_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Naiꞌ Yusuf anfeen sin tai feꞌu msaꞌ, es ate paasn es. Mes in nfeen naiꞌ Benjamin roi mutiꞌ fuaꞌ natun teun, ma tai feꞌu pasan niim. ");
INSERT INTO aaz_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","In nsonuꞌ neu in aam hoin fe baer saaꞌ-saaꞌ reꞌ nareok naꞌko pah Masir, ma nasaeb sin nbi bikaes keledai mone boꞌes. In nfee naꞌbabaꞌ ntein penaꞌ-makaꞌ, utunuꞌ, ma mnahat humaꞌ-humaꞌ, nasaeb sin neun bikaes keledai ainaf boꞌes. In nꞌook-beit sin neu oras sin ntebi nfain neman neun pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Rarit in nnao naseonaꞌ sin, ma namnaub sin am nak, “Natiꞌ hi kaisaꞌ mmatoe mbi raan ee, joo!” ");
INSERT INTO aaz_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Rarit sin nnaon nfanin neun sin aamf ee et pah Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Antean ne te, sin natonan sin aamf ee mnak, “Aam honiꞌ! Ho anah naiꞌ Yusuf anmoin feꞌ. In kaes koꞌu et pah Masir! In nnaaꞌ aprenat.” Oras naiꞌ Yakop anneen ate, in ntakaꞌnanaꞌ ma ka npirsai fa sin uabk ein naan. ");
INSERT INTO aaz_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mes oras sin natonan nrair naiꞌ Yusuf in uab ein naan, ma in niit akreet bikaseꞌ reꞌ naiꞌ Yusuf ansoun ee he nasaeb neik je neu pah Masir te, naꞌ in npirsai. ");
INSERT INTO aaz_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Onaim in naꞌuab am nak, “Airoo! Au aanh ee nmoin feꞌ! On reꞌ naan ate, naꞌ au ꞌmariin. Au ro he ꞌnao ꞌkius ꞌaan ee feꞌ, naꞌ au ꞌmate msaꞌ, reko.” ");
INSERT INTO aaz_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Rarit naiꞌ Yakop nakbuaꞌ in aꞌbruaꞌ ein, ma nnao nasaitan pah Kanaꞌan. Sin ntean kuan Barseba te, in nroor muꞌit ma nafuat sin neu Uisneno, reꞌ in amaf naiꞌ Isak naꞌbees neu Ne naꞌko unuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Fai jes ate, naiꞌ Yakop namnei. Anbi mneit naan, in nneen Uisneno noeꞌn ee mnak, “Hoe! Yakop! Ho mfeen he mneen feꞌ!” Onaim in nataah am nak, “Tua!” ");
INSERT INTO aaz_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma Uisneno nak, “Au reꞌ ia, Uisneno reꞌ ho amaꞌ naꞌbees neu Na naꞌko unuꞌ. Ho kais mumtau he mnao meu pah Masir. Au of aꞌmoeꞌ ho sufam-kauꞌm ein anjarin too reꞌ masoꞌik anbin bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Au of ꞌok ko tnao teu pah Masir. Ma Au of ꞌok ufaniꞌ ho sufam-kauꞌm ein nfanin neun pah Kanaꞌan amsaꞌ. Oras ho mmate te, of ho anah naiꞌ Yusuf anhake nbi ho bnapam.” ");
INSERT INTO aaz_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Rarit naiꞌ Yakop nok in aanh ein, nnaon nasaitan kuan Barseba. Onaim sin nasaeb ee, ma sin fee-anah sin anbin kreet bikaes ein reꞌ usif pah Masir ansonuꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Sin nait neik sin baer pusaak ein ma muiꞌt ein ok-okeꞌ reꞌ sin nmuiꞌ sin, oras sin nbin pah Kanaꞌan. Rarit naiꞌ Yakop ma in aan feto-aan mone sin, ma in uupf ein ok-okeꞌ, nnaon neun pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Naiꞌ Yakop in nonot-asar reꞌ nok anfoꞌon neun pah Masir, esan reꞌ ia: Naiꞌ Ruben, aan moen unu. ");
INSERT INTO aaz_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","In aanh ein esan reꞌ: naiꞌ Henok, naiꞌ Paru, naiꞌ Hesron, ma naiꞌ Karmi. ");
INSERT INTO aaz_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Naiꞌ Simeon nok in aanh ein esan reꞌ: naiꞌ Yemuel, naiꞌ Yamin, naiꞌ Ohat, naiꞌ Yakin, ma naiꞌ Sohar. Ma naiꞌ Saul amsaꞌ, reꞌ nahoins ee naꞌko bifee Kananas. ");
INSERT INTO aaz_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Naiꞌ Lewi nok in aanh ein esan reꞌ: naiꞌ Gerson, naiꞌ Kehat, ma naiꞌ Merari. ");
INSERT INTO aaz_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Naiꞌ Yahuda nok in aanh ein esan reꞌ: naiꞌ Sela, naiꞌ Peres, ma naiꞌ Sera. Naiꞌ Yahuda in anah bian, naiꞌ Er ma naiꞌ Onan, nmate nrarin nbin Kanaꞌan. In neik naiꞌ Peres in aanh ein amsaꞌ, esan reꞌ: naiꞌ Hesron ma naiꞌ Hamur. ");
INSERT INTO aaz_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Naiꞌ Isaskar nok in aanh ein esan reꞌ: naiꞌ Tora, naiꞌ Pua, naiꞌ Ayup, ma naiꞌ Simron. ");
INSERT INTO aaz_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Naiꞌ Sebulon nok in aanh ein esan reꞌ: naiꞌ Seret, naiꞌ Eron, ma naiꞌ Yahreel. ");
INSERT INTO aaz_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sin ok-okeꞌ reꞌ naan, naiꞌ Yakop nok in fee bi Lea sin aan hoin ein, oras sin natuan nbin Mesopotamia. Anmuꞌi ntein sin aan feto, kaan ee bi Dina. Onaim naiꞌ Yakop nok in mahoin ii, tuaf boꞌ tenu mteun. ");
INSERT INTO aaz_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Onaim anmuiꞌ in anah naꞌko in fee bian es reꞌ: naiꞌ Gat, nok in aanh ein esan reꞌ: naiꞌ Sifion, naiꞌ Hagi, naiꞌ Suni, naiꞌ Esbon, naiꞌ Eri, naiꞌ Arodi, ma naiꞌ Areli. ");
INSERT INTO aaz_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Naiꞌ Aser, nok in aanh ein esan reꞌ: naiꞌ Yimna, naiꞌ Yiswa, naiꞌ Yiswi, naiꞌ Beria, nok sin feotf es, kaan ee bi Sera. Anmuꞌi msaꞌ naiꞌ Beria in aanh ein, esan reꞌ: naiꞌ Heber ma naiꞌ Markiel. ");
INSERT INTO aaz_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sin arsin reꞌ naan, tuaf boꞌes am nee. Esan reꞌ naiꞌ Yakop ma in fee bi Silpa in anah-upuf sin. Bi Silpa naan, ate reꞌ naiꞌ Laban anfee je neu in aan feto bi Lea, naiꞌ Yakop in fee mnasiꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Naiꞌ Yakop in fee jes antein, kaan ee bi Rahel. In nahoniꞌ riꞌanaꞌ nua, esan reꞌ: naiꞌ Yusuf ma naiꞌ Benjamin. ");
INSERT INTO aaz_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oras naan, naiꞌ Yusuf ansao nrair bi Asnat nbi pah Masir. In aam baabf ee, aꞌnaak rais pirsait anbi kota On, kaan ee naiꞌ Potifera. Naiꞌ Yusuf ma bi Asnat sin aanh ein esan reꞌ: naiꞌ Efraim ma naiꞌ Manase. ");
INSERT INTO aaz_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Naiꞌ Benjamin nok amsaꞌ neu pah Masir. In nok in aanh ein, esan reꞌ: naiꞌ Bera, naiꞌ Beker, naiꞌ Asibel, naiꞌ Gera, naiꞌ Naꞌaman, naiꞌ Ehi, naiꞌ Ros, naiꞌ Mupim, naiꞌ Hupim, ma naiꞌ Aret. ");
INSERT INTO aaz_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rarit naiꞌ Yakop ma in fee bi Rahel sin mahoink ein tuaf boꞌes am haa. ");
INSERT INTO aaz_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Naiꞌ Yakop in nmuꞌi ntein fee jes, kaan ee bi Bilha. Sin aanh ein esan reꞌ: naiꞌ Dan ma naiꞌ Naftali. Naiꞌ Dan in aanh ee, naiꞌ Husim. ");
INSERT INTO aaz_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naiꞌ Naftali nok in aanh ein esan reꞌ: naiꞌ Yaser, naiꞌ Guni, naiꞌ Yeser ma naiꞌ Sirem. ");
INSERT INTO aaz_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Naiꞌ Yakop nok in fee bi Bilha sin mahoink ein tuaf hiut. Bi Bilha naan, es reꞌ bi Rahel in ate, reꞌ in napein je naꞌko in amaf naiꞌ Laban. ");
INSERT INTO aaz_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Onaim naiꞌ Yakop in mahoin ein reꞌ nnaon neun pah Masir naan, tuaf boꞌ nee mnee. In aan naenf ein ka nsoiꞌ sin fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sin nmaꞌbaab ein nok naiꞌ Yusuf in aanh ein reꞌ nahoniꞌ sin anbin pah Masir, sin tuaf nua. Onaim naiꞌ Yakop in nonot-asar reꞌ natuan nbin Masir, sin ar-arsin tuaf boꞌ hiut. ");
INSERT INTO aaz_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Oras sin he noi ntean pah Masir ate, naiꞌ Yakop anreun in anah naiꞌ Yahuda he nnao nahuun, he noꞌen naiꞌ Yusuf, he neem nateef nok in aamf ee nbi pah Gosen. Oras sin ntean nrarin nbin Gosen, ");
INSERT INTO aaz_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","on naan ate, naiꞌ Yusuf ansae neu in aꞌkreet, he nnao nateef in aamf ee nbi naan. Oras sin natefan, naiꞌ Yusuf anhoo in aamf ee, ma nkae ꞌroo reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Rarit naiꞌ Yakop naꞌuab nok naiꞌ Yusuf am nak, “Usu! Oras ia, au ꞌiit ko goen. Onaim au uhiin ꞌak ho mmoin feꞌ. Maski oras ia au ꞌmate msaꞌ, reko.” ");
INSERT INTO aaz_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Rarit naiꞌ Yusuf natoon neu in orif-tataf sin am nak, “Au ro he ꞌnao ꞌbaiseun uisf ee, he utoon ꞌak au nonot-asar sin naꞌkon pah Kanaꞌan neman ntean nggoen. ");
INSERT INTO aaz_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Onaim au of utoon ꞌak hi reꞌ ia, atuuk muꞌit. Etun hi meik hi muiꞌt ein ma hi pusaak ein naꞌkon Kanaꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Karu uisf ee noꞌen ki, ma nataan hi meupm ein saaꞌ, ");
INSERT INTO aaz_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","hi mitaah am mak, hi arki reꞌ ia, atuuk muꞌit ammurai miꞌko hi aanꞌ-anaꞌ feꞌ, on reꞌ hi beꞌi-naꞌi sin. Nok ranan naan, in of anreun ki he mitua mbi Gosen.” Naiꞌ Yusuf natoon on naan, natuin abitan pah Masir anmaiꞌnisin karu sin natua nabuan nok atuuk muiꞌt ein. ");
INSERT INTO aaz_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Rarit naiꞌ Yusuf nok in tataf tuaf niim, annaon he nbaiseun usif. Naiꞌ Yusuf naꞌekub ma natefab sin nok usif. In naꞌuab am nak, “Aam usiꞌ! Au amaꞌ ma au oriꞌ-tataꞌ sin neman nrarin naꞌkon pah Kanaꞌan. Sin neman neik sin muiꞌt ein ma sin baerꞌ ein ok-okeꞌ. Oras ia sin etan pah Gosen.” ");
INSERT INTO aaz_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Rarit uisf ee nataan am nak, “Hi meupn ein es reꞌ saaꞌ?” On nai te, sin natahan am nak, “Hai reꞌ ia atukus, on reꞌ sin hai beꞌi-naꞌi. ");
INSERT INTO aaz_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Oras ia, pah Kanaꞌan nafauk-nai koꞌu, tar antea ka tiit fa mnahat ma huun antein. Etun hai iim meu pah reꞌ ia he mitua mtahan. Hai meik hai muiꞌt ein amsaꞌ. Onaim oras ia, hai mbaiseun ko usiꞌ, mkonan kai he hai mitua mbi pah Gosen, he hai mituuk hai muiꞌt ein anbin naan.” ");
INSERT INTO aaz_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Rarit uisf ee natoon in roimn ee neu naiꞌ Yusuf am nak, “Oras ia, ho amaꞌ ma sin ho benuꞌ etan ia. ");
INSERT INTO aaz_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Onaim sin napenin mainuan he sin natuan nbin ia on reꞌ sin pah akuuk. Au mahiink ii te, pah Gosen naan, bare reꞌ reko nneis nbi pah reꞌ ia. Onaim reko nneis sin natuan nbin reꞌ naan. Ma karu sin natuuk muꞌit am reko te, maut he sin natuuk au ngguin anbin naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Rarit naiꞌ Yusuf naꞌekub ma natefab in aamf ee nok usif. Onaim naiꞌ Yakop anꞌonen he Uisneno nfee tetus neu usif naan. ");
INSERT INTO aaz_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Onaim uisf ee nataan am nak, “Aam, ho toon fauk een?” ");
INSERT INTO aaz_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Naiꞌ Yakop nataah am nak, “Au ꞌmoin ꞌaan toon nautn es boꞌ teun, mes au ka utua ubaar ꞌiit fa feꞌ ꞌbi baer jes. Au beꞌi-naꞌi sin on naan amsaꞌ. Karu au he utaib ok, ꞌok sin ite, au toon aꞌmoin ji, feꞌ ka mfaun fa feꞌ. Mes naheun nok suust am nanaꞌrenat.” ");
INSERT INTO aaz_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Onaim naiꞌ Yakop antoti ntein Uisneno he nfee tetus-athoen neu usif pah Masir naan. Rarit sin nbaisenun ma nheer ok naꞌko uisf ee in matan, ma ntebi nfanin. ");
INSERT INTO aaz_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Rarit naiꞌ Yusuf natuin uisf ee in kabin, onaim in nruur bare neu sin nbi pah Gosen. Afu bare naan, mrian ii kah een. (Sin nakanab bare naan nbi neon amunit nak, ‘Rameses’.) Onaim naiꞌ Yusuf in amaf ma in orif-tataf sin natua nabaran nbin bare naan. ");
INSERT INTO aaz_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Rarit naiꞌ Yusuf nataah ma nasaah mnahat neu in amaf, ma in orif-tataf sin, sin fee-anah sin, naꞌko aꞌnaet tar antea aꞌbaut ein. ");
INSERT INTO aaz_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Anbi oras naan, ka tiit tain fa mnahat anbi mee-mee. Amnaahs ii ntaman kuan-bare, kota mpah. Naꞌko pah Masir ntea pah Kanaꞌan mansian ein nꞌore nmaten. Sin ka nabeꞌin fa he nmoꞌen saaꞌ-saaꞌ, natuin sin namnahan nmaten. ");
INSERT INTO aaz_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Rarit biak ein neman naꞌkon bare-bare neun pah Masir, ma areꞌ bare-bare nbi pah Kanaꞌan, he nsosan amnahat naꞌkon naiꞌ Yusuf. Onaim in naꞌbuaꞌ roit ein naan ok-okeꞌ, rarit in nnao natunuꞌ sin anbin uisf ee in sonaf. ");
INSERT INTO aaz_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Oras naan, abitan pah Masir ma pah Kanaꞌan sin nararin roit. Onaim sin ka nsoos nabeꞌin fa mnahat. Rarit sin neman neun naiꞌ Yusuf he ntotin. Sin naꞌuab ein am nak, “Usiꞌ! Hai mbaiseun ko, tua. Amfee kai mnahat, he hai kaisaꞌ mimnaah ammaet. Natuin hai mirair roit, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Rarit naiꞌ Yusuf nataah am nak, “Karu batuur-batuur hi mirair roit ate, hi mmoeꞌ on nai: mtuki mnahat nok hi muiꞌt ein naan. Au of aꞌfee ki mnahat.” ");
INSERT INTO aaz_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Rarit sin nnonaꞌ sin muiꞌt ein neun naiꞌ Yusuf he ntukin amnahat. Muiꞌt ein esan reꞌ: sin bijae ngguin, bikaseꞌ, bikaes keledai, ꞌbibi, ma sin ꞌbib-kasen. Natuin toon naan, naiꞌ Yusuf anꞌator on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Toon amneemt ii te, sin nfain neman neun naiꞌ Yusuf. Sin nbaisenun am nak, “Usiꞌ! Hai ro mbaiseun namneo goah, tua. Hai roit ma muꞌit, ho mtuik maan kuum sin een, tua. Oras ia, hai he mait saaꞌ antein. Hai ruman ankon-koon. Arahaa hai tuam ein anmes-mesen, nok hai afu ꞌteets ein. ");
INSERT INTO aaz_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kais amkonan kai he hai mmaet. Karu hai mmate te, sekau es reꞌ he npairoir hai afun naan!? Reko nneis, ho mait kai mjair ho aten. Ho mtoup hai afun naan, he ho mpaar kuum sin. Rarit ho mfee kai fini he hai mseen sin meu ko, tua. Onaim ho mfee kai mnahat natuin hai mihaeb om ambi ho renen. Asar hai kaisaꞌ mmaet!” ");
INSERT INTO aaz_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Natuin oras amnahas naan maꞌtain besi, etun abitan pah Masir sin naꞌsosaꞌ nain sin aufn ein ok-okeꞌ. Onaim naiꞌ Yusuf ansoos nain afun naan he njair usif pah Masir in auf pusaak ein. ");
INSERT INTO aaz_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nok ranan naan, abitan pah Masir sin njarin ate neun usif pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mes naiꞌ Yusuf ka nsoos fa aꞌnaak pirsait ein sin afun, natuin uisf ee nfeen sin mnahat piut. Etun sin ka naꞌsosaꞌ fa sin afun. ");
INSERT INTO aaz_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Oras naan, naiꞌ Yusuf naꞌuab neu too gui mnak, “Oras ia, hi mfain ate meu usif pah Masir. Au ꞌsoos aꞌrair hi aufn ee neu usif. Onaim hi mait finin reꞌ ia nai, he mnao mseen sin neun renen naan. ");
INSERT INTO aaz_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Oras sekit ma mnonut ate, hi mbait batis niim. Baits es neu usif. Neisk ein paaꞌ haa, bian hi mait fini, ma bian hi mait sin ntaam amnahat neu ki ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Rarit sin natahan am nak, “Koe aam. Ho msoi maan kai naꞌko amnahas ia, tua. Onaim hai mtoit makasi, tua. Maut he hai mjair ate meu hit usiꞌ, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Rarit naiꞌ Yusuf anpaek atoran naan anjair prenat anbi pah Masir. Etun sin nbatin batis niim naꞌko areꞌ penaꞌ-makaꞌ reꞌ sin nseik ma noun sin naan. Sapaaf es neu usif. Haaꞌ ein neun sin kuuk. Suma aꞌnaak pirsait ein sin aufn ee, uisf ee ka nsoos ein fa. Prenat naan, sin feꞌ anpaek je nnao nkoon. ");
INSERT INTO aaz_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Anmurai oras naan, atoin Israelas sin natuan nabaran nbin pah Gosen, et pah koꞌu Masir. Sin anjarin atoin amuꞌit. Ma sin nahoin ein ma nmaꞌbaab ok piut-piut. ");
INSERT INTO aaz_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Anbi pah Masir naan, naiꞌ Yakop anmoin naan toon boꞌes am hiut, tar antea in nmoin naan nabu-bua toon nautn es boꞌ haa mhiut. ");
INSERT INTO aaz_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Oras in neno ꞌmaetn ee npaumak-maak een ate, in noꞌen naiꞌ Yusuf ma natoon ee mnak, “Usu! Au ꞌnaben, ka ꞌroo fa heen ate, Uisneno noꞌen nafaniꞌ kau goen. Onaim au ꞌtoit ko, karu ho mneek kau te, ho msuup mak ho ka msuub kau fa mbi pah Masir ia. ");
INSERT INTO aaz_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ho ro he meik mufaniꞌ au aok-taꞌuk ia he msuub ee meu hit beꞌi-naꞌi sin nopun, ma msuub kau ꞌbi nee. Ho amaꞌ kau gui, au roimk ii on reꞌ naan.” Onaim naiꞌ Yusuf nataah am nak, “Reko, tua! Karu ho mroim maan on reꞌ naan ate, au utuin aah, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Onaim naiꞌ Yakop naꞌuab am nak, “Karu ho mroim mutuin kau on naan ate, oras ia ho msuup, mak ho mroim mutuin ho amaꞌ in romin.” Rarit naiꞌ Yusuf ansuup natuin naiꞌ Yakop in uab ein naan. Onaim naiꞌ Yakop nabaniꞌ ma nriꞌtuu nꞌain koi je ꞌnakan, ma nꞌonen he nasaeb sukuur neu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ka ꞌroo fa naꞌko oras naan ate, naiꞌ Yusuf napein hanaf nak, in aamf ee nameen maꞌfenaꞌ. Onaim in nok in aan moen nuaꞌ ein naan, esan reꞌ naiꞌ Manase ma naiꞌ Efraim, ma sin nnaon nkius sin naꞌif naiꞌ Yakop. ");
INSERT INTO aaz_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Oras naiꞌ Yakop nahiin nak naiꞌ Yusuf neem anrari te, in nareen on he ntoko nbi haraꞌ tupaꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Onaim in naꞌuab neu naiꞌ Yusuf am nak, “Usu! Neon goes ii, Uisneno reꞌ Akuaas Maꞌtaniꞌ naan, nakriir On neu kau nbi kuan Lus, et pah Kanaꞌan. Anbi naan, In nbaꞌan neu kau, ");
INSERT INTO aaz_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","mnak, ‘Au of umfaubaꞌ ho anah-upuf sin he njarin too mfau-rutu. Au of aꞌfeen sin bare reꞌ ia msaꞌ, he njair sin auf pusaak tar antea nabar-baar.’ ");
INSERT INTO aaz_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Onaim oras ia ho anah naiꞌ Efraim ma naiꞌ Manase, sin sapaak ein es reꞌ ia: au ꞌuum ꞌeu pah Masir ia te, sin nua sin anbi nanin ia. Maski on naan amsaꞌ, oras ia, au ꞌaan sin on reꞌ au aanh ein goa kuuk, on reꞌ naiꞌ Ruben ma naiꞌ Simeon. ");
INSERT INTO aaz_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mes karu ho muhoniꞌ mteniꞌ te, naꞌ ho anah. Au ka ꞌaan sin fa neu au aanh ein nu. Onaim maut he sin ntoup sin pusaak ein naꞌkon sin taatf ein, naiꞌ Efraim ma naiꞌ Manase. ");
INSERT INTO aaz_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au ꞌmoeꞌ on reꞌ naan, he umnau ho ainaꞌ bi Rahel. Oras hit tfain teem taꞌko pah Mesopotamia he teu pah Kanaꞌan ate, ho ainaꞌ nmate nbi raan atnanaꞌ nbi ranan reꞌ npaumaak kuan Efrata et pah Kanaꞌan. Oras naan, au ꞌsuus aꞌmaet! Onaim au ꞌsuub ee et raan ee ninen reꞌ he ttaam teu kuan Efrata naan.” (Oras ia, kuan reꞌ naan, sin nakaanb ee Betlehem.) ");
INSERT INTO aaz_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Naiꞌ Yakop naꞌuab anrair on naan ate, in nait matan ma nkius niit naiꞌ Yusuf in aan monen naan. Onaim in nataan naiꞌ Yusuf am nak, “Hoe, sekau aanh ein esan reꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Onaim naiꞌ Yusuf nataah am nak, “Riꞌaan ein reꞌ ia, Uisneno es anfee sin neu kau nbi pah Masir ia.” Rarit naiꞌ Yakop naꞌuab am nak, “Karu on naan ate, mpaumakab kau sin, he au ꞌonen ma ꞌtoit Uisneno he nfeen sin tetus.” ");
INSERT INTO aaz_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Naiꞌ Yakop namnasi nrair. In maatk ein ankupun. Etun in ka niit fa reko. Onaim naiꞌ Yusuf nok in aanh ein naan anpaumaak naiꞌ Yakop. Onaim naiꞌ Yakop anhoo ma nneek sin. ");
INSERT INTO aaz_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Rarit in naꞌuab neu naiꞌ Yusuf am nak, “Aꞌroo-ꞌroo reꞌ ia, au uten-teenb aah, ꞌak au ka neu he uteef ꞌok ko fa heen. Mes oras ia, Uisneno nmoꞌe nneisi ntein, tar antea au ubeiꞌ feꞌ he ꞌiit ho aanh ein.” ");
INSERT INTO aaz_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Rarit naiꞌ Yusuf naꞌrobaꞌ in aanh ein naꞌko naiꞌ Yakop. In nriꞌtuu ma in naꞌruriꞌ tar antea in nneek afu nbi in aamf ee in human ma in matan. ");
INSERT INTO aaz_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Rarit naiꞌ Yusuf anfeen. Onaim in nahakeꞌ in aanh ein anpaumak-maak in amaf. In nahakeꞌ in aan moen unu nbi naiꞌ Yakop in aꞌniman aꞌneꞌu. On nai te, aan moen muin je nbi naiꞌ Yakop in aꞌniman aꞌrii. ");
INSERT INTO aaz_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mes oras naiꞌ Yakop he ntao in aꞌniimk ein he ntoit Uisneno he nfeen sin tetus-athoen neu sin nua sin, in nkaisurib in aꞌniimk ein. In ntao in aꞌniman aꞌneuꞌ goe neu aan muni naiꞌ Efraim in aꞌnakan, ma in ntao in aꞌniman aꞌrii je neu aan unu naiꞌ Manase in aꞌnakan. ");
INSERT INTO aaz_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Rarit in nꞌonen ma ntoit Uisneno he nfeen naiꞌ Yusuf tetus-athoen am nak, “Ho naꞌi kaꞌo Abraham, ma ho naꞌi naiꞌ Isak, sin nua sin natuin Uisneno In roimn ee piut-piut. Uisneno kuun es reꞌ anpairoir ma npijaar kau anmurai naꞌko oras au munif tar antea oras ia. ");
INSERT INTO aaz_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","In kuun es reꞌ nsoi naan kau naꞌko siraak humaꞌ-humaꞌ. Onaim au ꞌtoit Je msaꞌ he In nfee tetus-athoen neu riꞌaan ein reꞌ ia ma sin suufk ein. Onaim karu sin nꞌoen ein neun Uisneno, sin ka nnikan fa he nteek kaꞌo naiꞌ Abraham, naꞌi naiꞌ Isak, ma au kanak. Maut he sin mahoink ein nasufan piut, he njarin too mfau-rutu nbin pah-pinan ia.” ");
INSERT INTO aaz_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mes oras naiꞌ Yusuf niit in aamf ee ntao in aꞌniman aꞌneuꞌ goe nbi aan muni naiꞌ Efraim in aꞌnakan naan ate, in nait nananiꞌ in aamf ee ꞌniman naan, ma ntao goe neu aan unu naiꞌ Manase in aꞌnakan. ");
INSERT INTO aaz_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","In naꞌuab neu in aamf ee mnak, “Aam honiꞌ, kais on naan. Naiꞌ Efraim in aan moen muni. In ka atoin kouꞌ goa fa. Ho ro he mtao ho ꞌnimam naan meu aan unu naiꞌ Manase in aꞌnakan. Natuin atoin kouꞌ goe in sapaa naan, es reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mes amaf naiꞌ Yakop ka nroim fa. In nak, “Usu. Au uhiin ꞌain. Naiꞌ Manase of anjair atoin maꞌtaniꞌ, ma in suufk ein amsaꞌ of anjarin too pah kouꞌ goes. Mes in orif naiꞌ Efraim naan, of maꞌtaniꞌ nneis naꞌko na. In suufk ein of amfau reꞌuf, tar antea sin njarin too pah amfaun reꞌ maꞌtain besi.” ");
INSERT INTO aaz_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Rarit in natoon neu riꞌaan nuaꞌ ein naan am nak, “Of karu atoin Israelas sin antotin neun Uisneno he nfeen sin tetus neu tuaf-tuaf ate, sin of anteek hi nua ki hi kaanm ein naan. Sin of antotin am nak, ‘Karu reko te, Uisneno nfee tetus neu ko, nahuum on reꞌ In nfee tetus neu naiꞌ Efraim ma naiꞌ Manase.’ ” Nok ranan naan, naiꞌ Yakop amsaꞌ anteek nahunun naiꞌ Efraim in kaan ee, naꞌko naiꞌ Manase in kanan. ");
INSERT INTO aaz_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Rarit naiꞌ Yakop naꞌuab neu naiꞌ Yusuf am nak, “Usu! Ka ꞌroo fa te, au he ꞌmaet jen. Mes Uisneno of anturun ma nbaab ki, onaim In ro he neik ki mfain meu hi beꞌi-naꞌi sin pah. ");
INSERT INTO aaz_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mes oras ia, au ꞌfee ko mneis muꞌko sin ho benuꞌ. Au ꞌfee uꞌbabaꞌ ko ꞌtoꞌef et pah Kanaꞌan reꞌ unuꞌ te au usiik ꞌaan ee ꞌeik au suniꞌ-kenat uꞌko atoin Amoris sin.” ");
INSERT INTO aaz_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Rarit naiꞌ Yakop anreun noꞌen in aanh ein ok-okeꞌ. Sin neman ntean on naan ate, in naꞌuab am nak, “Hi iim ampaumak-maak kau feꞌ. Au he utoon ki es-es ate hi ꞌmonim anbi neon amnemat.” ");
INSERT INTO aaz_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Rarit naiꞌ Yakop anmurai naꞌuab ma natoon nain neu in aanh ein am nak, “Naiꞌ Yakop in aanh ein ki! Hi mkoen om iim nai ma mhake mfuun maan kau. Amtakan hi ruikm ein he mneen am mitniin hi amaꞌ Israꞌel in uaban ma in aꞌan. ");
INSERT INTO aaz_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Neu ko, aam Ruben. Ho reꞌ ia, aan moen unu, asoit enoꞌ. Ho mjair on reꞌ au teas ma au ꞌnimak aꞌneꞌu. Areꞌ tuaf anhormaat ko. ");
INSERT INTO aaz_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mes feꞌ-feꞌ ete ho neek maan naꞌoniꞌ. Ho roim ii ka nhake nkiꞌif, on reꞌ noe sakoꞌ reꞌ ka tꞌeek taan ee fa. Nok askeken, ho mnao mtuup mok au fee bi Bilha, ma mhaiꞌniis ho amaꞌ in haraꞌ tupaꞌ. Es naan ate, ho sapaam reꞌ amjair on atoin koꞌu ma mone ꞌnaek ka matekaꞌ fa heen! ");
INSERT INTO aaz_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Naiꞌ Simeon ma naiꞌ Lewi! Hi nua ki taos meseꞌ. Atteek ahaa besi-benas ate, hi nua ki manoem ein kah een. Etun hi mhaꞌmuiꞌ ma misusab too mfaun. ");
INSERT INTO aaz_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hi mmariin ammaet, karu hi mꞌoet mifeek bijae ngguin sin pii oetk ein, tar antea sin nfukaꞌ nenuꞌ nabaar ahaa sin baark ein. Hi ꞌmoeꞌm ein maufinu batuur-batuur. Karu hi meek-meuk nisim, hi mroor miis atoniꞌ. Au kaꞌ roim fa he ꞌok aꞌseor hi rasim. ");
INSERT INTO aaz_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Onaim oras ia, au ꞌkaas hi neek mapuut ein naan, natuin hi mapuut besin ki! Ma hi tooꞌs ein naan ka mpaek fa rais kasian akreꞌo msaꞌ. Hi of ro he misaah kiim hi ꞌmoeꞌ reuꞌf ein. Uisneno of anporin nsiksakan hi sufam-kauꞌm ein. Sin of natuan nbin bare-bare nbin pah Israꞌel. ");
INSERT INTO aaz_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Neu ko, aam Yahuda. Ho kanam naan, in aꞌmoufn ii ‘pures-boꞌis’. Ho oriꞌ ma ho tataꞌ sin of anboꞌis ko ma nhormaat ko. Ho of miis ho muusn ein, tar antea sin ka bisa nait fa sin aꞌnaak ein. ");
INSERT INTO aaz_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ho reꞌ ia, on reꞌ singa muin maꞌtain es, reꞌ naim kuun amnahat. Ho on reꞌ singa keso reꞌ nbiun ma nakoo in aon ee he ntuup. Ka tiit fa es, reꞌ nabrain he noik ko. Ho on reꞌ singa ainaf amsaꞌ reꞌ npao in anah; ka tiit fa es nabrain he nakꞌaun ee. Ho on naan msaꞌ. Atoin ein of anmasahun ko, ma ka nabeiꞌ ein fa he nmoꞌen tafiꞌ-tafiꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ho of es amnaaꞌ aprenat. Ho sufam-kauꞌm ein of annaaꞌ aprenat anmaktun-tuin ein, tar antea tuaf es, reꞌ in nmuiꞌ sapaaf anneis-neis. In of es antook ma nnaaꞌ aprenat naan. Rarit too naꞌkon uuf-uuf sin of naꞌruir ein ma naꞌbesan neu ne. ");
INSERT INTO aaz_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ho of ammoin nok neek marine. Ho mroim saaꞌ-saaꞌ aah ate, of anmuiꞌ. Ho he mmoeꞌ saaꞌ amsaꞌ, of anjair! Onaim ho muiꞌt ein, nok ho reen ee aafk ein of amfaun ma nho-hoen. ");
INSERT INTO aaz_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ho bukaem ii ro namiin ka natfeek fa. ");
INSERT INTO aaz_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Neu ko, aam Sebulon. Ho auf pusaak ee of mainua feko ma npaumaak tasi, tar antea nmanaak nok kota Sidon. Abnao ngguin neman naꞌkon mee-mee ma nasanut sin boint ein nbin ho tais je in ninen nok mamut. ");
INSERT INTO aaz_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Neu ko, aam Isaskar. Ho reꞌ ia on reꞌ bikaes es, reꞌ nteek ee te, keledai maꞌtaniꞌ. Mes ho ꞌnaak fautm ii kah een. Karu ho mtuup ambi raan atnanaꞌ, sekau es reꞌ he npooꞌ ko he mnao mkoon. Mes karu ho miit kuan es in areokn ii et panin ne, es ka nreun ko fa msaꞌ ate, ho mait ho bruaꞌ ma mroi sin ma mnao meu nee. Ho on reꞌ nana nai! ");
INSERT INTO aaz_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Neu ko, aam Dan. Ho kanam naan, in aꞌmoufn ii, ‘afeek rasi’. Ho mok ho sufam-kauꞌm ein of amjair afeek rasi meu hi pah Israꞌel sin sin rasin. Hi mifeek rasi te, natai ma ka mpiir fa humaf. ");
INSERT INTO aaz_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ho mahiinm ii on reꞌ kaun araut reꞌ antuup anpao nbi raan ee ninen. Karu atoniꞌ nsae bikaseꞌ ma npeoꞌ naan ate, nok askeken, ho mrau mrair bikaseꞌ naan in haen tikan, tar antea in tuan naan anmouf. ");
INSERT INTO aaz_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Koi, UISNENO! Au ꞌon-ꞌonen he Ho mfee ꞌhonis meu kai ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Neu ko, aam Gat. Ho kaan maan atneen ete, in haan ii on reꞌ ‘mbaan musu’. Pukan apaikaurt ein of anbaan ko, mes ho of mbaan ambaras sin, ma miis sin. ");
INSERT INTO aaz_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Neu ko, aam Aser. Ho rene ma poꞌon sin aafk ein esan reꞌ reko nnes-nesin. Ho of ammoeꞌ kokis aminat humaꞌ-humaꞌ reꞌ maꞌosaꞌ, he uisf ein neman nsosan naꞌkon ko. ");
INSERT INTO aaz_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neu ko, aam Naftali. Ho on reꞌ ruu ainaf, reꞌ naen ma nfui nmaet. Es ka nabeiꞌ fa he nꞌator ko. Ho muhoniꞌ maan ho aanh ein, namasan rek-reko. ");
INSERT INTO aaz_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Neu ko, aam Yusuf. Ho on reꞌ fae reꞌ nmoni npaumaak oe mataꞌ. In taen ein of annoonk ein nsaen neun rame mnanuꞌ, on reꞌ ho sufam-kauꞌm ein annaon neun bare-bare. ");
INSERT INTO aaz_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Anmuiꞌ tuaf bian reꞌ nasaeb sin neek meens ein neu ko, on reꞌ musu reꞌ nakrao ko. ");
INSERT INTO aaz_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mes Uisneno reꞌ au uꞌbees ꞌeu Na ji, anturun ma nbaab ko. Es naan ate, In nmoeꞌ ho ꞌnimam naan naꞌbeiꞌ, tar antea ho mubeiꞌ ma mukrao mbaras meu ho musun naan, maski naꞌroo. Ho of miis sin, natuin Uisneno es anturun ma nbaab ko. Batuur In kuasn ee maꞌtaniꞌ! Etun au uꞌpeis ok ꞌeu Ne. Natuin In es anpao ma npanat kau. ");
INSERT INTO aaz_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","In of anpanat ko msaꞌ, ma nfee ko tetus-athoen humaꞌ-humaꞌ. Esan reꞌ: tetus naꞌko neno tunan, ma naꞌko pah-pinan, ma ho aan hoin ein amfaun ma nꞌao-minan. ");
INSERT INTO aaz_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Aꞌtoeꞌf ein ka namnekun fa. Tetus reꞌ au ꞌfee je ꞌeu ko reꞌ ia, anneis naꞌko ꞌtoeꞌf ein ok-okeꞌ! Maut he teuts ein reꞌ ia nasai piut neu ko, natuin ho mneis muꞌko ho oriꞌ-tataꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Neu ko, aam Benjamin. Ho brainm ii on reꞌ aus fui koꞌu reꞌ namnaah. Feꞌ kik-kiku msaꞌ, in nheek enrair in amnahat. Mes karu nfai te, in nnao ma nbati mnaah nesif naan neu in aanh ein. Ho sufam-kauꞌm ein of maꞌtaink ein on reꞌ naan amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Uab ein ia, naiꞌ Yakop in uab sin neu in aanh ein. In natoon nain sin, es-es ate in aꞌmonin, nok in sufan-kauꞌn ein anbi neno-neno amnemat. Sin arsin reꞌ naan, esan reꞌ anjarin aam uuf neun uuf boꞌes am nua nbin pah Israꞌel. ");
INSERT INTO aaz_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Rarit naiꞌ Yakop antoit in aanh ein he nmoꞌen rais manbaꞌan. In naꞌuab am nak, “Ka ꞌroo fa heen ate, au he ꞌmaet een. Karu au ꞌmaet, hi ro he mnao msuub kau meu naiꞌ-kaꞌo Abraham in nopu. Nopu naan et nuat reꞌ npaumaak kuan Makpera ma kuan Mamre et pah Kanaꞌan. Unuꞌ te, naiꞌ-kaꞌo Abraham ansoos nuat naan nok rene ma poꞌon naan he njair in baer subat. In nsoos nafeek ee naꞌko atoin Hetes es, kaan ee naiꞌ Efron. ");
INSERT INTO aaz_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Anbi naan, sin nsuub hit naiꞌ-kaꞌo Abraham, ma hit beiꞌ-kaꞌo bi Saraꞌ, au amaꞌ naiꞌ Isak, ma au ainaꞌ bi Ripka. Onaim hi ro he msuub kau mbi naan, ꞌbi au fee bi Lea in abnapan. ");
INSERT INTO aaz_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mimnau! Hi kais amnikan he msuub kau mbi nuat reꞌ naiꞌ-kaꞌo Abraham ansoos naan ee reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Naiꞌ Yakop naꞌuab anrair on naan ate, in ntuup anfain neu haraꞌ tuup ee, ma in nmaet. ");
INSERT INTO aaz_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Onaim naiꞌ Yusuf anhoo in aamf ee, ma nkae nmeꞌ-meꞌur. Ma in nneek nafan-fainꞌ ee. ");
INSERT INTO aaz_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Rarit naiꞌ Yusuf naprenat tua aꞌurus uis-minaꞌ he npairoir naiꞌ Yakop in aon-taꞌun he kais anpuun. ");
INSERT INTO aaz_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Onaim tua aꞌurus uis-miin ein naan, anpairoir naiꞌ Yakop in aon-taꞌun naan neno boꞌ haa, on reꞌ natiꞌ te, sin nmoeꞌ nani. Onaim abitan Masir ankaen amsaꞌ oras naiꞌ Yakop anmaet. Sin nkaenaꞌ naiꞌ Yakop tar antea neno boꞌ hiut (70), on reꞌ sin aꞌnaet es anmaet. ");
INSERT INTO aaz_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Neno boꞌ hiut namsopu te, naiꞌ Yusuf natoon neu in aꞌnaak meupn ee mnak, “Amneen mirek-rekoꞌ! Au ꞌtoit ki he meik au hanak ia meu uisf ee. Hi mak on nai: ");
INSERT INTO aaz_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Oras au amaꞌ he noi nmate te, in ntoit kau he ꞌnao ꞌsuub in aon-taꞌun ia ꞌeu pah Kanaꞌan. Onaim au ꞌbaiseun ko usiꞌ he mfee kau mainuan, he au ꞌeik au amaꞌ in aon-taꞌun ma ꞌnao ꞌsuub ee ꞌeu pah Kanaꞌan. Rarit, naꞌ au ꞌfain ꞌuum.’ ” ");
INSERT INTO aaz_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Oras uisf ee nneen hanaf naan ate, in nataah am nak, “Karu ho msuup amrair meu ho amaꞌ on naan ate, maut he mnao ma msuub ee.” ");
INSERT INTO aaz_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Onaim naiꞌ Yusuf annao he nsuub in amaf. Too mfaun ein nokan amsaꞌ. Sin esan reꞌ uisf ee in aꞌnaak meupn ein ok-okeꞌ, ma kaes koꞌun naꞌkon pah Masir. ");
INSERT INTO aaz_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Naiꞌ Yusuf in orif-tataf sin, ma sin ameupt ein ok-okeꞌ msaꞌ nokan nbin subat naan. Amaikaꞌ nbi Gosen, arahaa sin feek ein, riꞌaan ein, ma muiꞌt ein. ");
INSERT INTO aaz_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Soraurs ein nokan namfa-faun. Bian ansaen akreet bikaseꞌ, bian ansaen bikaseꞌ. Natuin amnokat sin namfaun, es naꞌ pukan anaot neu subat naan, naraor gok pirore mnanuꞌ. ");
INSERT INTO aaz_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Rarit sin arsin nnaon ma nraak noe Yarden, nbi baer jes in kaan ee, Atat. Natiꞌ te, abitan naan neman ma nterin makaꞌ nbin bare naan. Anbi naan, naiꞌ Yusuf sin nkaenaꞌ sin amaf. Sin nbeꞌen nteinꞌ ein fai hiut. ");
INSERT INTO aaz_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Oras abitan Kanaꞌan niit sin nsusan on naan ate, sin naꞌuab ein am nak, “Hae! Hi mkius miit. Atoin Masiras sin nbeꞌen amates ate, nuuꞌ gui ka aanꞌ-anaꞌ fa. Sin ankaen ate, on reꞌ ne joo!” Etun sin nakanab bare naan Abel-Misraim. In aꞌmoufn ii, nak ‘atoin Masiras sin nukat’. ");
INSERT INTO aaz_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Rarit naiꞌ Yakop in aanh ein nmoeꞌ natuin saaꞌ reꞌ sin nbaꞌan anrari. ");
INSERT INTO aaz_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Onaim sin nroi neik naiꞌ Yakop in aon-taꞌun naan, ma nnaon nsuub ee nbi nuat reꞌ npaumaak kuan Makpera ma kuan Mamre. Naiꞌ Abraham ansoos nafeek bare naan naꞌko atoin es naꞌko uuf Hetes, kaan ee naiꞌ Efron; he nmoeꞌ je njair sin baer subat. ");
INSERT INTO aaz_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Oras ansuub anrair sin amaf naiꞌ Yakop ate, naiꞌ Yusuf nok in orif-tataf sin, annaon nfanin neun pah Masir. Too mfaun reꞌ nokan nbin subat naan amsaꞌ on naan. ");
INSERT INTO aaz_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Oras sin ntean pah Masir ate, naiꞌ Yusuf in taatf ein nmurai namtaun, natuin sin aamf ee nmate nrair. Onaim sin naꞌuab ein es nok es am nak, “Hae! Hit tatenab tarek-rekoꞌ tiit feꞌ! Kais-kaisaꞌ naiꞌ Yusuf natenab kit feꞌ. Karu in he nmoeꞌ rais reꞌuf neu kit ate, on mee?” ");
INSERT INTO aaz_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Rarit sin nꞌakoran ma nsoun ein hanaf neu naiꞌ Yusuf am nak, “Usiꞌ. Hai mimnau feꞌ, oras hit amaꞌ anmoin feꞌ, in nreun kai ");
INSERT INTO aaz_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","he mitoon ko, tua, mak, ‘Naiꞌ Usu ro he nnikan nain in taatf ein sin saant ein. Natuin sin nmoꞌe nrarin rais reꞌuf neu ne.’ Hai mimnau msaꞌ am mak, hit amaꞌ in naꞌruriꞌ ma naꞌbees neu Uisneno naꞌko afi unuꞌ. Hai mfain Uisneno naan In aten amsaꞌ. Onaim oras ia hai iim amtoit saok sanat, natuin hai mmoꞌe mrair sanat meu ko, tua.” Anneen on naan ate, naiꞌ Yusuf ankae. ");
INSERT INTO aaz_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Rarit in taatf ein neikn ok neman ma nriꞌtuun nbin in matan, ma naꞌuab ein am nak, “Mait kai mjair ho aten, tua.” ");
INSERT INTO aaz_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mes naiꞌ Yusuf nak neu sin am nak, “Sin au tataꞌ arki! Hi kais mimtau mtein! Uisneno nmees kuun es reꞌ anmuiꞌ hak he nhukun tuaf. Mes au reꞌ ia, ka ꞌmuiꞌ fa hak, tua. ");
INSERT INTO aaz_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Unuꞌ te, batuur hi mꞌakoor he mmoeꞌ reꞌuf meu kau. Mes Uisneno nabanit hi sair amreꞌut naan, he nmoeꞌ je njair reko. Etun In nait kau ꞌjair aꞌnaet aꞌbi pah ia, henatiꞌ too mfaun ein napenin aꞌhonis. ");
INSERT INTO aaz_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Onaim oras ia, au utoon ki, he kais mimtau mten-teniꞌ. Au ufeek kuuk am ꞌak, au of aꞌkius ki, ma hi aanh ein ok-okeꞌ.” Nok uab naan ate, naiꞌ Yusuf nhaan mau in taatf ein. ");
INSERT INTO aaz_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Rarit naiꞌ Yusuf natua nabaar anbi pah Masir nok in orif-tataf sin ok-okeꞌ. In nmoin naan toon nautn es toon boꞌes. ");
INSERT INTO aaz_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","In niit naiꞌ Efraim in anah-upuf sin feꞌ. Ma in nkauh naiꞌ Manase in upuf, es reꞌ naiꞌ Makir in aanh ein. ");
INSERT INTO aaz_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Naiꞌ Yusuf naꞌuab neu in taatf ein am nak, “Sin au tataꞌ arki! Au ꞌnaben ate, au neno ꞌmaet ki he ntea goen. Mes au ꞌpirsai ꞌak Uisneno of anpairoir ki. In of neik ki mpoi miꞌko pah reꞌ ia. In of naꞌnaak neu ki he mfain meu pah reꞌ In nfee je neu hit naiꞌ-kaꞌo Abraham, naꞌi naiꞌ Isak, ma hit amaꞌ naiꞌ Yakop. In nfee bare naan neik rais supat.” ");
INSERT INTO aaz_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Onaim naiꞌ Yusuf antoit in orif-tataf sin he nsupan am nak, “Hi ro he mbaꞌan meu kau. Karu ntea oras reꞌ Uisneno neik ki mfain on hit pah ee te, hi ro he meik au aok-taꞌuk ia.” ");
INSERT INTO aaz_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Rarit naiꞌ Yusuf anmate nbi pah Masir, ma in nmoin naan toon nautn es toon boꞌes (110). Rarit sin npairoir in aon-taꞌun. Onaim sin natunuꞌ in aon-taꞌun naan nbi in noup paran. ");
INSERT INTO aaz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Surat reꞌ ia, naretaꞌ anmatoom nok Yesus Kristus, Tuaf reꞌ Uisneno nbaꞌan nain je naꞌko afi unuꞌ he nsoun Ee neem. In reꞌ naan, usif naiꞌ Daut in sufan, ma kaꞌo Abraham in sufan-kaꞌun. Anmurai naꞌko kaꞌo Abraham tar antea usif naiꞌ Daut, anmuiꞌ naan batan boꞌes am haa. Naꞌko batan neu batan sin, on nai: Naiꞌ Abraham nahonis naiꞌ Isak, naiꞌ Isak nahonis naiꞌ Yakop, naiꞌ Yakop nahonis naiꞌ Yahuda nok in orif-tataf sin, ");
INSERT INTO aaz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","naiꞌ Yahuda nahonis naiꞌ Peres ma naiꞌ Sera (sin nua sin, sin ainf ee, kaan ee bi Tamar), naiꞌ Peres nahonis naiꞌ Herson, naiꞌ Herson nahonis naiꞌ Ram, ");
INSERT INTO aaz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","naiꞌ Ram nahonis naiꞌ Aminadap, naiꞌ Aminadap nahonis naiꞌ Nahason, naiꞌ Nahason nahonis naiꞌ Soleman, ");
INSERT INTO aaz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","naiꞌ Soleman nahonis naiꞌ Boꞌas (in ainf ee, kaan ee bi Rahap), naiꞌ Boꞌas nahonis naiꞌ Obet (in ainf ee, kaan ee bi Rut), naiꞌ Obet nahonis naiꞌ Isai, ");
INSERT INTO aaz_vpl VALUES ("MT1_6a","070_1_6a","MAT","1","6a","6a","naiꞌ Isai nahonis naiꞌ Daut. ");
INSERT INTO aaz_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Naꞌko naiꞌ Daut tar antea too Israꞌel nmoufun nbin Babel, sin ar-arsin naan, batan boꞌes am haa ntein. Sin esan reꞌ: naiꞌ Daut nahonis naiꞌ Soleman (in ainf ee, nahunu te, naiꞌ Uria in fee). Naiꞌ Soleman nahonis naiꞌ Rahabeam, naiꞌ Rahabeam nahonis naiꞌ Abia, naiꞌ Abia nahonis naiꞌ Asaf, naiꞌ Asaf nahonis naiꞌ Yosafat, naiꞌ Yosafat nahonis naiꞌ Yoram, naiꞌ Yoram nahonis naiꞌ Usia, naiꞌ Usia nahonis naiꞌ Yotam, naiꞌ Yotam nahonis naiꞌ Ahas, naiꞌ Ahas nahonis naiꞌ Heskia, naiꞌ Heskia nahonis naiꞌ Manase, naiꞌ Manase nahonis naiꞌ Amos, naiꞌ Amos nahonis naiꞌ Yosias, naiꞌ Yosias nahonis naiꞌ Yekonya ma in oirf ein oras sin nmoufun nbin Babel. ");
INSERT INTO aaz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Naꞌko oras sin nmoufun nbin Babel antean naiꞌ Yesus, sin ar-arsin batan boꞌes am haa. Sin esan reꞌ: Naiꞌ Yekonya nahonis naiꞌ Saltiel, naiꞌ Saltiel nahonis naiꞌ Serubabel, naiꞌ Serubabel nahonis naiꞌ Abihut, naiꞌ Abihut nahonis naiꞌ Elyakim, naiꞌ Elyakim nahonis naiꞌ Asor, naiꞌ Asor nahonis naiꞌ Sadok, naiꞌ Sadok nahonis naiꞌ Akim, naiꞌ Akim nahonis naiꞌ Eliut, naiꞌ Eliut nahonis naiꞌ Eliaser, naiꞌ Eliaser nahonis naiꞌ Matan, naiꞌ Matan nahonis naiꞌ Yakop, rarit naiꞌ Yakop nahonis naiꞌ Yusuf. Naiꞌ Yusuf ansao bi Maria. Bi Maria reꞌ naan, es reꞌ nahonis Yesus Kristus. ");
INSERT INTO aaz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Onaim anmurai naꞌko naiꞌ Abraham antean naiꞌ Daut batan boꞌes am haa; naꞌko naiꞌ Daut antean oras sin nmoufun nbin Babel, batan boꞌes am haa; ma naꞌko Babel antean oras nahonis Kristus, batan boꞌes am haa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Oras bi Maria nahonis Naiꞌ Yesus naan, in reetn ii on nai: Bi Maria anmanaꞌan nok naiꞌ Yusuf. Sin nua sin ka ntuup-tuup nitan fa feꞌ on reꞌ fee-mone. Mes bi Maria naꞌapuꞌ naꞌko Uisneno In Asmaan Akninuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Oras naiꞌ Yusuf nahiin on naan ate, in he nafetin bi Maria. Mes in ka nroim fa he ntao namaeb ee nbi too mfaun ein sin maatk ein, natuin naiꞌ Yusuf in neekn ee kninuꞌ ma namnoon. Es naan ate, in he nafeitn ee mninuꞌ-mninuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Onaim in natenab he naim ranan neu-mneem. Fai jes, in namnei. Anbi mneit naan, in niit Uisneno In ameput es neem naꞌko sonaf neno tunan, ma natoon ne mnak, “Yusuf! Ho reꞌ ia usif naiꞌ Daut in sufan. Ho neek maan kais naꞌoniꞌ he ho msao bi Maria. Fin riꞌanaꞌ reꞌ et bi Maria in apun, naan Uisneno In Asmaan Akninuꞌ es antao. ");
INSERT INTO aaz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bi Maria of nahonis naan riꞌaan moen jes. Rarit ho ro he mukaanb ee, Naiꞌ Yesus, fin In es reꞌ of ansoi nafetin Uisneno Iin na naꞌkon sin sanat ma penu sin.” ");
INSERT INTO aaz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rasi reꞌ ia of anjair on naan, natuin Uisneno natoon nain naꞌko afi unuꞌ. In npaek niit In mafefa kninuꞌ naiꞌ Yesaya he ntui mnak, ");
INSERT INTO aaz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hi mneen, oo! Of anmuiꞌ bi non ao-ꞌtemef es, reꞌ ka ntuup-tuup niit fa feꞌ nok atoniꞌ, mes nok askeken ate, in naꞌapuꞌ. Rarit in nahonis Riꞌaan moen jes. Sin nakaanb ee, Imanuel.” (Anbi uab Ibrani, ‘Imanuel’ in oetn ii: Uisneno nok kit.) ");
INSERT INTO aaz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naiꞌ Yusuf namnei nrair on naan ate, in nfeen. Onaim in natuin nain Uisneno In uaban naan. In nait bi Maria njair in fee, ");
INSERT INTO aaz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mes in ka ntuup nabua nok ne fa on reꞌ fee-mone, tar antea bi Maria nahonis Riꞌanaꞌ naan. Rarit naiꞌ Yusuf nakanab Riꞌanaꞌ naan, Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oras nahonis Naiꞌ Yesus anbi kuan Betlehem et propinsi Yudea, usif Herodes annaaꞌ aprenat. Oras naan, anmuiꞌ tuaf fauk neman nbin kota Yerusalem. Sin naꞌkon pasaꞌ neon-saet, kuan am bare reꞌ naꞌroo. Sin arsin reꞌ naan, atoin akius ahini kfuun ein. ");
INSERT INTO aaz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Oras sin ntaman ntean kota Yerusalem, sin natanan neu-mneman am nak, “Atoin Yahudis sin usif reꞌ feꞌ nahoins Ee ji, et mee? Hai miit amrair kfuu goes mbi pasaꞌ neon-saet, reꞌ neik tanar nak, nahonis anrair Je. Es naan ate, hai iim he miꞌbees meu Ne.” ");
INSERT INTO aaz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oras usif Herodes anneen niit sin naꞌuab ein on naan ate, in nseor natenab. Onaim abitan kota Yerusalem sin ok-okeꞌ annaben nitan on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rarit usif Herodes naꞌbuaꞌ aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma tunggur agaam ein ok-okeꞌ he nataan sin. In nataan sin im nak, “Hi mitoon miit kau feꞌ! Kristus reꞌ Uisneno anbaꞌan anrair Je naan, karu nahoins Ee te nbi bare mee?” ");
INSERT INTO aaz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","On nai te sin natahan am nak, “Anbi kuan Betlehem, et propinsi Yudea, tua. Fin Uisneno In mafefa kninuꞌ naiꞌ Mika ntui nrair je naꞌko afi unuꞌ nak on nai: ");
INSERT INTO aaz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Abitan Betlehem, et propinsi Yudea. Hi kais mitenab am mak, hi kuan naan, suma kuan an-aan es, reꞌ ka matekaꞌ fa saaꞌ-saaꞌ. Fin of anmuiꞌ naan aꞌnaet es neem naꞌko bare naan. In of anjair atukus neu Au too Israelas sin.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Anneen anrair on naan ate, usif Herodes noꞌen atoin ahiint ein naan. In noꞌen sin amninuꞌ-mninuꞌ. Onaim in nataan sin anmatoom nok oras reꞌ sin nitan akfuu reꞌ anboor anbi neon goe tnanan. Onaim sin natonan neun usif naan, saaꞌ-saaꞌ reꞌ sin nahiin sin. ");
INSERT INTO aaz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rarit in nfeen sin mainuan he nkonon neun Betlehem. In natoon neu sin im nak, “Hi mnao maim Riꞌanaꞌ naan meu nee. Karu hi miit ma miteef mok Ne te, mtebi mfain iim he mitoon kau. Fin au he ꞌnao uꞌruriꞌ ma uꞌbees ꞌeu Ne msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Anneen anrair uisf ee in uaban naan ate, sin nnaon nkonon. Onaim sin niit akfuu reꞌ sin nkius niit ee afi unuꞌ nbi pasaꞌ neon-saet. Akfuu naan anboor anbi sin maatk ein, rarit in nnao tar nasnaas nataib on anbi Riꞌanaꞌ naan In bare ꞌtua-haꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ankius nitan on naan ate, sin nmarinan nmaten. ");
INSERT INTO aaz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rarit sin ntaman neun umi naan. Sin nitan kuuk Riꞌanaꞌ naan nok In ainaf bi Maria. Onaim sin nriꞌtuun he naꞌbesan neun Ne. Rarit sin nfei sin ook-soun ein reꞌ mamasaꞌ ma maꞌosaꞌ, ma annonaꞌ sin neun Riꞌanaꞌ naan. Sin nfeen noni mnatuꞌ, kemenyaan, ma hau oef foo meniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Rarit, oras sin ntupan ate, Uisneno nfeen sin amneit am nak, “Hi kais amtebi mfain meu usif Herodes amtein.” Etun sin nfanin neun sin pah ee, nnaon npeꞌon raan aꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oras atoin akius ahini kfuun ein nfanin nrarin on naan ate, Uisneno In ameput naꞌko sonaf neno tunan tuaf es neem. In natoon neu naiꞌ Yusuf anbi mneit am nak, “Yusuf! Amfeen nai! Maen meik Riꞌanaꞌ naan ma In ainaf meu pah Masir. Mitua mibaar ambi naan, tar antea Au utoon ꞌeu ki oras reꞌ hi he mfain iim, fin usif Herodes naim Riꞌanaꞌ naan he naꞌmate!” ");
INSERT INTO aaz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Rarit naiꞌ Yusuf naskeek ma nfeen. Onaim in neik in fee ma Riꞌanaꞌ naan annaon oras fai he sin naenan neun pah Masir ");
INSERT INTO aaz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sin natuan nbin pah Masir tar antea usif Herodes anmaet. Nok ranan naan Uisneno In kabin ro njair, natai nok Uisneno In mafefa kninuꞌ naiꞌ Hosea, reꞌ natoon nain nbi afi unuꞌ am nak, “Au ꞌoꞌen ufaniꞌ Au Anah, he npoin nfain neem naꞌko pah Masir.” ");
INSERT INTO aaz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Oras usif Herodes nahiin nak, atoin akius ahini kfuun ein napniub anrair je on naan ate, in natooꞌ maꞌtaniꞌ. In naprenat in soraurs ein am nak, “Amnao meu kuan Betlehem ma kuan-kuan bian reꞌ anmapaumaakn ein anbin bare naan. Amroor miis areꞌ kanan riꞌaan mone reꞌ feꞌ anmoin naan toon nua neiki nsaun.” Naiꞌ Herodes naprenat on naan, natuin in namnau niit uab naꞌko ahiint ein. In nsoiꞌ nmurai naꞌko oras akfuun aan anboor nbi neon goe tnanan. ");
INSERT INTO aaz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rasin reꞌ ia, anjarin natai nok saaꞌ reꞌ Uisneno In mafefa kninuꞌ naiꞌ Yermias antui nain je afi unuꞌ am nak, ");
INSERT INTO aaz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Anmuiꞌ haan kurut-kaet anpin-pinus anbi kota Rama. Bi Rahel ankae npin-pinus, natuin in aanh ein ok-okeꞌ anmaten nrarin. In ka nroim fa he tuaf anfuir ma nhaan mau goe, natuin in aanh ein ka tiit fa nteinꞌ een.” ");
INSERT INTO aaz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aꞌroo-ꞌroo te, usif Herodes anmaet. Oras naan naiꞌ Yusuf sin anbin pah Masir feꞌ. Uisneno In ameupt es neem naꞌko sonaf neno tunan, nakriir on neu naiꞌ Yusuf anbi mneit. ");
INSERT INTO aaz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ameput naan naꞌuab am nak, “Yusuf! Amfeen nai! Mait meik Riꞌanaꞌ naan nok In ainaf, amfain nai meu pah Israꞌel. Fin tuaf reꞌ he nroor Riꞌanaꞌ naan, anmate nrair.” ");
INSERT INTO aaz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Anneen on naan ate, naiꞌ Yusuf anfeen. Rarit in neik sin nfanin neun pah Israꞌel. ");
INSERT INTO aaz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mes oras in nneen niit nak, usif Herodes in anah naiꞌ Arkilaus oras ia annaaꞌ aprenat et propinsi Yudea, in namtau he nfain on naan. Rarit Uisneno napreent ee anbi mneit antein am nak, “Yusuf, ho kais mutua mbi pah Yudea.” Es naan ate, in nnao ma natua nbi propinsi Galilea, ");
INSERT INTO aaz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","anbi kuan es, kaan ee, Nasaret. Nok ranan naan, Uisneno In kabin, njair natai on reꞌ saaꞌ reꞌ In mafefa kninuꞌ sin antui nain sin im nak, “Sin of anteek Ee te, Atoin Nasaretas.” ");
INSERT INTO aaz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Oras Naiꞌ Yesus naꞌnae nrair on naan ate, naiꞌ Yohanis Asranit anmurai nanoniꞌ tuaf amfaun anbi baer ruman naꞌroo naꞌko kuan anbi propinsi Yudea. ");
INSERT INTO aaz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","In natoon am nak, “Aok-bian manekat arki! Hi ro he mmanakuꞌ ma misaitan hi sanat ma penu sin, he mtebi mfain meu Uisneno nai. Fin oras ia, ansuun tuaf bisa mtaam amjair Uisneno Iin Na.” ");
INSERT INTO aaz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Afi unuꞌ Uisneno In mafefa kninuꞌ tuaf es, kaan ee naiꞌ Yesaya, antui nmatoom nok naiꞌ Yohanis am nak, “Of anmuiꞌ tuaf reꞌ annao neu bare reꞌ ka matuaꞌ fa, anhunun ma nkoaꞌ am nak, ‘Hi ar-arki ro he mibarab ma miroitan ranan, he mseun ma mtoup Uisneno In amneman! Mineo ma minoon ranan he mseun Goe!’ ” ");
INSERT INTO aaz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Naiꞌ Yohanis in aꞌmoin ii, on reꞌ Uisneno In mafefa kniunꞌ ein afi unuꞌ sin. In paek ein, anmoeꞌ sin naꞌkon paus unta. In pasu ꞌfutuꞌ, anmoeꞌ je naꞌko pasu. In amnaaht ein, aknamat ma oin hau. ");
INSERT INTO aaz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Oras naan too mfaun ein neman he niit ma nateef nok naiꞌ Yohanis. Sin neman naꞌkon kota Yerusalem, ma propinsi Yudea in afan nanan sin ok-okeꞌ. Sin neman naꞌkon kuan ein reꞌ anpaumakan noe Yarden amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sin nfei sin neek ein, ma nmanakuꞌ kuuk sin sanat ma penu sin ok-okeꞌ. Rarit naiꞌ Yohanis nasrain sin anbin noe Yarden. ");
INSERT INTO aaz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Oras naan, tuaf naꞌkon partei pirsait Farisi ma partei pirsait Saduki msaꞌ neman ma ntoit naiꞌ Yohanis he nasrain sin. Mes oras in niit sin on naan ate, in naskarak sin im nak, “Hoe! Hi arki on reꞌ kaun aputa-kriut! Uisneno of anhukun ki natuin hi ꞌmoꞌem maufinu sin. Hi kais mitenab am mak, hi of maen ampoi ma ka mipein fa In hukun. ");
INSERT INTO aaz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Onaim reko nneis hi misaitan hi sanat ma penu sin ok-okeꞌ, ma mtebi mfain nai meu Uisneno. Rarit ammoeꞌ reko, nahuum on reꞌ hau roet reꞌ nafua fua reko. ");
INSERT INTO aaz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kais mitenab am mak, hi reko ki goen, natuin hi arki reꞌ ia, kaꞌo Abraham in sufan. Ampirsai kau! Fin Uisneno bisa nmoeꞌ fatun reꞌ ia njarin kaꞌo Abraham in sufan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ampaant om! Fin anmuiꞌ Tuaf reꞌ annaaꞌ fani, nabarab anrair he nnooꞌ areꞌ kanan roet reꞌ sin fuak ein ka reko fa. Annoꞌo nrair sin on naan ate, In nait inporin sin neun ai. ");
INSERT INTO aaz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Oras ia, au usrain ki ꞌpaek oe, he njair tanar nak, hi mkoit ma misaitan hi sanat ma penu sin. Mes of anmuiꞌ Tuaf es he neem. In reꞌ naan, maꞌtani nneis naꞌko kau. Maski au ꞌjari haa in aan renuꞌ-aan rekaꞌ msaꞌ, au ka umnees ꞌok Ne fa. In of naheun hi neekm ein nok Uisneno In Asmaan Akninuꞌ. In nakninuꞌ ki msaꞌ, nahuum on reꞌ tuaf anpaek ai he nout makrafuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Fin In nnaaꞌ aꞌtupaꞌ reꞌ matuaꞌ maak aꞌtaum he nakrai ma nakpesaꞌ nain maak apaꞌ anbi naan. Rarit In nasaeb maak akniunꞌ ein neun poꞌof. Mes maak aap ein naan, In nait inporin nataam sin neun ai mapinaꞌ abar-barat.” ");
INSERT INTO aaz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oras naan, Naiꞌ Yesus ansaun neem naꞌko Galilea neu noe Yarden. In neem antoit naiꞌ Yohanis he nasrain Je, ");
INSERT INTO aaz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","mes naiꞌ Yohanis ka nroim fa. In nprotees am nak, “On mee mꞌes au usrain Ko, Usiꞌ? Ka nsaan fa, oo? Usiꞌ, Ho es reꞌ he musrain kau, tua. Naan, es reꞌ au ꞌperluu!” ");
INSERT INTO aaz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mes Naiꞌ Yesus nataah am nak, “Reko, baꞌe. Mes oras ia, ho es reꞌ he musrain Kau. Nok ranan naan, hit tatuin Uisneno In romin.” Anneen on naan ate, naiꞌ Yohanis nataah am nak, “Reko, tua.” Onaim in nasrain Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nasrani nrair Je on naan ate, Naiꞌ Yesus anpoi naꞌko noe. Mes nok askeken ate, neon goe tnanan natfeꞌi. Rarit In niit Uisneno In Asmanan ansaun neem neu Na, nahuum on reꞌ kor-kefi, ma antoko nbi Na. ");
INSERT INTO aaz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Rarit sin nnenan Uisneno In hanan naꞌko neon goe tnanan naan am nak, “In reꞌ ia, Au Aan nekaꞌ. In nmoeꞌ Au neek ii nmariin piut-piut.” ");
INSERT INTO aaz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Rarit Uisneno In Asmaan Akninuꞌ neik Naiꞌ Yesus neu baer ruman naꞌroo naꞌko kuan, he nitu ꞌnaak kouꞌ goe noik ma nfuir Ee. ");
INSERT INTO aaz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Onaim in nanaah On fai boꞌ haa ma neno boꞌ haa nbi bare naan. Rarit In namnaah anmaet. ");
INSERT INTO aaz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oras In namnaah on naan ate, niutn ein sin aꞌnaak kouꞌ goe neem noik ma nfuir Ee mnak, “Batuur, aa oo? Ho reꞌ ia, batuur-batuur Uisneno In Anah? Karu batuur on naan ate, muprenat fatun reꞌ ia he njarin amnahat nai.” ");
INSERT INTO aaz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mes Naiꞌ Yesus nataah am nak, “Matuꞌi et Uisneno In Suur Akninuꞌ mnak: ‘Mansian ii ka nmoin fa naꞌko mnaaht ahaa. Mes sin ro he nneen ma natniin Uisneno In Kabin ma Prenat amsaꞌ, ma nmoeꞌ natuin In romin.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Onaim nitu ꞌnakaf naan neik Naiꞌ Yesus neu kota Yerusalem, es reꞌ Uisneno In kota kninuꞌ. Rarit In nasaeb Naiꞌ Yesus neu Uim Onen Uuf ee In aꞌpupun. ");
INSERT INTO aaz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Onaim nitu ꞌnakaf naan nak, “Karu Ho batuur-batuur Uisneno In Aanh ate, amꞌokar miit Ho tuam aan meu ꞌpinan ee nai. Fin matuꞌi et Uisneno In Suur Akniunꞌ ee msaꞌ, mnak: ‘Uisneno of naprenat In ameupt ein naꞌkon sonaf neno tunan, he npafaꞌ ma npanat Ko.’ Anbi Uisneno In Suur Akniunꞌ ee msaꞌ, matuꞌi mnak, ‘Sin of natnaat Ko npaek sin aꞌniimk ein, maut he Ho aom naan kais nameen, ma Ho kais musbeut fatu msaꞌ.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mes Naiꞌ Yesus nataah am nak, “Matuꞌi et Suur Akniunꞌ ee msaꞌ mnak, ‘Uisneno naan, ho Usiꞌ. Onaim ho kais amsoob Ee.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Rarit nitu ꞌnakaf naan neik Naiꞌ Yesus neu ꞌtoeꞌf es, reꞌ aꞌraat reꞌuf. Onaim in nakriraꞌ areꞌ kanan pah anbin pah-pinan, ma sin pinaꞌ ma krahaꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nakriraꞌ nrair sin on naan ate, nitu ꞌnakaf naan naꞌuab am nak, “Asar Ho muꞌruriꞌ ma muꞌbesan kau, au of aꞌfee sin ok-okeꞌ ꞌeu Ko.” ");
INSERT INTO aaz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mes Naiꞌ Yesus anpaes ee mnak, “Hoe nitu! Ho muꞌroo nai muꞌko ia. Fin Suur Akniunꞌ ee ntui mnak, ‘Ho ro he muꞌruriꞌ ma muꞌbesan Uisneno, ma ho ro he mmeup meu Ne nmees jah.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Anneen on naan ate, nitu ꞌnakaf naan annao nasaitan Naiꞌ Yesus. Mes Uisneno In ameupt ein naꞌkon sonaf neno tunan, neman ma nꞌurus Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Oras naan, usif Herodes nataam naiꞌ Yohanis Asranit anbi bui. Oras Naiꞌ Yesus anneen niit on naan ate, In ntebi nfain neu Galilea. ");
INSERT INTO aaz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","In nfain neu In kuan Nasaret, rarit In nkoon natua nbi kuan Kapernaum. Kuan naan et nefo Galilea in panin, et uuf naiꞌ Sebulon ma naiꞌ Naftali sin auf pusaak. ");
INSERT INTO aaz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nok ranan naan, In nmoeꞌ natuin saaꞌ reꞌ Uisneno In mafefa kninuꞌ naiꞌ Yesaya antui nain je mnak, ");
INSERT INTO aaz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Naiꞌ Sebulon in afu, ma naiꞌ Naftali in afu, reꞌ anpaumaak nefo Galilea, et noe Yarden in panin. Atoin sonaꞌ ka atoin Yahudis fa natua etan naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Sin nmonin nbin meisꞌokan, mes oras ia sin niit anrair Meꞌu. Fin oras ia, Meꞌu naan anmeuꞌ-siin, neu sekau-sekau reꞌ ka nahiin fa Uisneno fa feꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Anmurai naꞌko oras naan, Naiꞌ Yesus nanoniꞌ tuaf mnak, “Hi ro he maikoit ma misaitan main hi saant ein, he mmoni kninuꞌ nai. Fin oras ia, sekau-sekau goah bisa mtaam amjair Uisneno Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Neon goes, Naiꞌ Yesus annao npeoꞌ nefo Galilea in ninin. In nateef atoniꞌ tuaf nua, sin nmaꞌori-tatan. Es kaan ee, naiꞌ Simon, mes biasa sin nteek ee mnak, naiꞌ Petrus. Ma in oirf ee, kaan ee naiꞌ Anderias. Sin nkiif kain ikaꞌ nbin nefo, natuin sin nua sin naan, akiif kai ikaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Onaim Naiꞌ Yesus noꞌen sin im nak, “Hae, baꞌe sin. Iim he mituin Kau nai! Hi biasa maim ikaꞌ, mes oras ia, Au he unoniꞌ ki he hi mjair tuaf amnaim tuaf he njarin Uisneno Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Anneen anrarin on naan ate, sin nua sin nasaitan sin jala, ma nnaon natuin nain Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Rarit Naiꞌ Yesus ankono kreꞌo. Onaim In niit naiꞌ Sebedius in aanh ein. Ahuunt ee, kaan ee naiꞌ Yakobus, ma in oirf ee, kaan ee naiꞌ Yohanis. Sin nua sin nabarab pukat anbi kofaꞌ nok sin amaf. Onaim Naiꞌ Yesus noꞌen sin nua sin he natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Anneen anrarin on naan ate, sin nasaitan sin amaf ma sin kofaꞌ naan, ma natuin nain Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Rarit Naiꞌ Yesus sin nnaon nfuun am nateef anbin propinsi Galilea, he In nanoniꞌ tuaf anbin atoin Yahudis sin uim onen sin. In nanoniꞌ sin anmatoom nok Uisneno In Rais Reko, ma natoon ranan he atoniꞌ bisa natuin Uisneno In aprenat. Ma In narekoꞌ too mfaun ein amsaꞌ naꞌkon sin menas humaꞌ-humaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ka ꞌroo fa te, rasi anmatoom nok Naiꞌ Yesus In aꞌmoꞌen sin naan, masinaꞌ ma mabenoꞌ anfuun am natefan propinsi Siria. Rarit too mfaun ein neman ma neik ameent ein reꞌ namenan humaꞌ-humaꞌ neun Ee. Sin neikin tuaf amsaꞌ reꞌ anniut saen, reꞌ namaunun aꞌbibi, ma abuat ein. In narekoꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oras naan, too mfaun ein neman ma natuin Ee. Sin neman naꞌkon propinsi Galilea, ma naꞌkon pah Kota Boꞌes, reꞌ sin nteek ee mnak, Dekapolis. Bian anteniꞌ neman naꞌkon kota Yerusalem, naꞌkon propinsi Yudea, ma naꞌkon noe Yarden in pasaꞌ neon-saet. ");
INSERT INTO aaz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Oras Naiꞌ Yesus niit too mfaun ein neman ma natuin Ee te, In nsae neu ꞌtoeꞌ aan es, ma antoko nbi naan. In atoup noinꞌ ein reꞌ In npiir naan sin naan, neman npaumak-maak Ee, he nnenan ma natninan. ");
INSERT INTO aaz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Rarit In nmurai nanoniꞌ sin im nak, ");
INSERT INTO aaz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Atoin kasian sin napenin upan ma paꞌe arekot, natuin Uisneno In kuun, sin Usif arekot. ");
INSERT INTO aaz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Atoin akurut ma akaet napenin upan ma paꞌe arekot, natuin Uisneno kuun es reꞌ anhaan mau sin. ");
INSERT INTO aaz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Atoin ba-baun sin napenin upan ma paꞌe arekot, natuin sin of antoupun areꞌ tetus-athoen reꞌ Uisneno nbaꞌan anrair sin. ");
INSERT INTO aaz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Atoniꞌ reꞌ namnau Uisneno In raan amneot ma amnonot reꞌ-reꞌuf napenin upan ma paꞌe arekot, natuin In of naseen sin. ");
INSERT INTO aaz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Atoniꞌ reꞌ nakriraꞌ ma naruruꞌ rais kasian sin napenin upan ma paꞌe arekot, natuin Uisneno of ankasian ma nneek-amnau sin. ");
INSERT INTO aaz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Atoniꞌ reꞌ neek akninuꞌ sin napenin upan ma paꞌe arekot, natuin sin kuuk of niit Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Atoniꞌ reꞌ biasa narameꞌ tuaf, napenin upan ma paꞌe arekot, natuin Uisneno of nak, ‘Sin reꞌ naan, Au aanh ein na.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Atoniꞌ reꞌ napenin haꞌmuꞌit maꞌtaniꞌ natuin sin natuin Uisneno, sin napenin upan ma paꞌe arekot, natuin Uisneno kuun, sin Usif arekot. ");
INSERT INTO aaz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Karu tuaf bian anhaꞌmuiꞌ ki natuin hi mituin Kau, hi mipein upan ma paꞌe arekot amsaꞌ. Karu sin naꞌmunuꞌ ki nok rais puta-kriut reꞌ naꞌreꞌuf ma nkanaꞌpaar hi kaanm ein, hi mipein upan ma paꞌe arekot amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maski on naan amsaꞌ, hi ro he mmoeꞌ hi tuam ein ammariin, ma hi neekm ein anmarinan amsaꞌ, natuin Uisneno nabarab ma naroitan anrair he nbaras neu ki nathoe nbi hi sapaam et sonaf neno tunan. Mes mimnau! Ka hi mmees fa reꞌ mipein haꞌmuꞌit on naan. Un-unuꞌ te, tuaf-tuaf sin anmoꞌen maufinu neun Uisneno In mafefa kniunꞌ ein on naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Karu hit he tmoꞌe mnaaht ii he namiin ate, hit ro he ttao masik feꞌ. On naan amsaꞌ tuaf-tuaf reꞌ anmoni nbin pah-pinan ia, sin nperluu ki. Mes karu maisk ii miin ruman ate, he tpaek je neu saaꞌ? Suma tait itporin ma tteri. ");
INSERT INTO aaz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Hi ro he mmoin ma mpiin on reꞌ paku msaꞌ, he too mfaun ein nitan rek-reko. Hi ro he masnaa meꞌu, on reꞌ kota nbi ꞌtoeꞌf ee tunan, reꞌ too mfaun ein nitan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atoniꞌ nout pauk anaꞌ, ka nateek je fa ma ka napaan ee fa nbi ꞌnai-konat. Mes sin nateek paku naan naꞌraat, he bisa ntanaꞌ umi naan in naan ee ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hi ro he mmoin on naan amsaꞌ. Hi ro he masnaa meꞌu he tuaf bian sin nitan nak, hi ꞌmonim naan arekot. Sin nitan on naan ate, sin of anpures ma nboꞌis Uisneno mnak, ‘Hi Amaꞌ et sonaf neno tunan naan, mapinaꞌ-makrahaꞌ!’ ” ");
INSERT INTO aaz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Hi kais mitenab am mak, Au ꞌtaam ꞌuum ꞌeu pah-pinan ia he ꞌnoes ꞌain Uisneno In atoran reꞌ In nfee sin neu kaꞌo Musa. Ma kais mitenab mak, oniꞌ Au ka ꞌrae utuin fa saaꞌ reꞌ mafefa kninuꞌ Uisneno sin natoon sin naꞌko afi unuꞌ. Natuin Au ꞌtaam ꞌuum reꞌ ia, he ꞌmoeꞌ sin ok-okeꞌ njarin natai-tain on reꞌ saaꞌ-saaꞌ reꞌ sin naꞌuab nain sin naan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nok ranan naan, hi arki amneen mirek-rekoꞌ! Pah-pinan ma neno tunan of ka namreꞌun fa feꞌ, karu ka njair natuin fa Uisneno In atoorn ein. Maski titik an-aan es, ka tiit tain fa tuaf es he nnoes nain je. ");
INSERT INTO aaz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naꞌko Uisneno Iin na ok-okeꞌ, karu anmuiꞌ tuaf reꞌ antanhai Uisneno In atoran, natuin in natenab am nak, ‘Hae, atoran ia an-aan aah, in ka maꞌosaꞌ ma maꞌupan fa saaꞌ-saaꞌ!’ Rarit in nanoniꞌ on reꞌ naan neu tuaf bian, Uisneno et sonaf neno tunan of anmoeꞌ je njair aꞌbaut. Mes tuaf reꞌ anmoeꞌ natuin Uisneno In atoorn ein ok-okeꞌ, rarit in nanoniꞌ sin on naan amsaꞌ neu tuaf bian, Uisneno of anmoeꞌ je njair tuaf reꞌ maꞌosaꞌ ma maꞌupan. ");
INSERT INTO aaz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ampirsai meu Kau! Karu hi ka mmoin mimnoon ma mimneo fa reko nneis naꞌko tunggur agaam ein ma atoin partei Farisi sin on naan ate, hi ka bisa fa he mtaam amjair Uisneno Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hi mihini mrair kaꞌo Musa in atoran reꞌ in natoon anrair sin neu hit beꞌi-naꞌi sin nak, ‘Kaisaꞌ miꞌmaet atoniꞌ, natuin sekau naꞌmaet atoniꞌ, in of napein hukun.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mes Au he utoon ki on nai: kais ammaktoꞌon, natuin sekau-sekau reꞌ anmaktoꞌon nok in aok-bian, in of napein hukun. Tuaf reꞌ natoꞌon in aok-bian nak, ‘Ho roen masak nareꞌ!’ tuaf reꞌ naan of anbaiseun neu afeek rais pirsait ein. Ma tuaf-tuaf reꞌ naskarak in aok-bian, nak ‘Amonot!’ in of napein hukun anbi ai pinaꞌ abar-barat. ");
INSERT INTO aaz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Onaim karu ho meik fuaꞌ-turuꞌ meu Uisneno, mes ho mumnau mmak, ho aom-bian anmuiꞌ rais jes nok ko, ");
INSERT INTO aaz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kais amnonaꞌ ma mfee fuaꞌ-turuꞌ naan feꞌ. Ho mfain he muraem om mok ho aom-bian naan feꞌ, rarit naꞌ ho mfain uum he mnonaꞌ ma mfee fuaꞌ-turuꞌ naan meu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Karu nmuiꞌ tuaf reꞌ nmakaꞌrasiꞌ nok ko te, reko nneis muraem om rabah mok ne feꞌ. Karu kaah fa te, tuaf reꞌ naan of neik ko neu afeek rasi. Rarit afeek rasi nnonaꞌ ko neu porisi, onaim sin nataam ko neu bui. ");
INSERT INTO aaz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au uꞌuab batuur! Ho of mutua mbi bui naan piut tar antea ho mbaen mufeek ho tuus ein ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hi mihini mrair kaꞌo Musa in atoran reꞌ nak, ‘Kais ammakaek.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mes Au he utoon ki ꞌak on nai: atoniꞌ reꞌ naꞌaitiꞌ matan ma nkius bifee jes, rarit in neekn ee nsinmaak he ntuup nabua nok bifee naan ate, atoniꞌ naan anmakake nrair nok bifee naan anbi in nekan. ");
INSERT INTO aaz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Karu ho mmoꞌe msaan meik ho matam aꞌneꞌu te, mroꞌi mporin. Reko nneis ho mtaam meu sonaf neno tunan meiki haa mataf fuaꞌ meseꞌ, he kais sin nporin nataam ko neu ai abar-barat nok ho matam sin fuaꞌ nua. ");
INSERT INTO aaz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma karu ho mmoꞌe msaan meik ho ꞌniman aꞌneꞌu te, mketu mporin. Reko nneis ho mtaam meu sonaf neno tunan meiki haa ꞌnimaꞌ meseꞌ, he kais sin nporin nataam ko neu ai abar-barat nok ho ꞌnimam sin nua sin.” ");
INSERT INTO aaz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hi mihini mrair kaꞌo Musa in atoran nak, ‘Atoniꞌ reꞌ nporin in fee je te, in ro he nfee surat manporin neu in fee naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mes Au utoon ki on nai: atoniꞌ reꞌ nporin in fee, mes in fee je ka nbeon on niit fa, rarit bifee naan ansao ntein, naan on reꞌ in moen je anmakakeb. Ma karu anmuiꞌ atoniꞌ reꞌ ansao bifee reꞌ in moen je nporin, naan sin nua sin anmakaken nrarin amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hi mihini mrair kaꞌo Musa in atoran reꞌ natoon ee neu hit beꞌi-naꞌi sin, nak, ‘Karu ho muhakeꞌ rais manbaꞌan ambi supat ampaek Uisneno In kanan on naan ate, ho mmafutu mrair mok rais manbaꞌan naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mes Au utoon ki on nai: karu ho muhakeꞌ rais manbaꞌan ate, kais ampaek supat. Kais amsuup ampaek sonaf neno tunan in kanan, natuin sonaf neno tunan naan, Uisneno In sonaf. ");
INSERT INTO aaz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kais amsuup ampaek pah-pinan ia in kanan, natuin pah-pinan ia, Uisneno In bareꞌ ꞌteriꞌ. Ma kais amsuup ampaek kanaf Yerusalem, natuin Yerusalem naan, Uis Kouꞌ goe In kota. ");
INSERT INTO aaz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kais amsuup ampaek hi ꞌnakam. Fin hi ka mmuiꞌ fa kuasa he miprenat aꞌnaak funuꞌ noon es he njair metan aiꞌ mutiꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Onaim karu hi he mihakeꞌ rais manbaꞌan ate, karu mak, ‘tua’, mitoon mak, ‘Tua’ goah. Mes karu kaah fa te, mak, ‘Kaah fa, tua’. Karu hi miꞌuab aꞌtetaꞌ naꞌko naan ate, naan naꞌuu ma naꞌbaaꞌ naꞌko niut reꞌuf.” ");
INSERT INTO aaz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hi mihini mrair kaꞌo Musa in atoran nak, ‘Karu anmuiꞌ tuaf nareuꞌ ho matam ate, ambaras on naan amsaꞌ. Ma karu anmuiꞌ tuaf antuut namouf ho nisim ate, amtuut mumouf goe msaꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mes Au utoon ki on nai: kais ambaras maufinu nok maufinu. Karu anmuiꞌ tuaf anpaas ho ꞌkinom es ate, amkonan he npaas bian naan antein. ");
INSERT INTO aaz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Karu anmuiꞌ tuaf reꞌ anmakaꞌrasiꞌ nok ko, he nait ho baru te, amfee mtein ne ho baur manikin. ");
INSERT INTO aaz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Karu anmuiꞌ soraurs es naꞌsekeꞌ ko he mroi meik in baerꞌ ein mnao kiur goes ate, amroi meiki mtein sin mtean kiru nua. ");
INSERT INTO aaz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Karu anmuiꞌ tuaf antoit ho baer saaꞌ-saaꞌ ate, amfee ne. Ma karu anmuiꞌ tuaf anpinjam ho baer saaꞌ-saaꞌ ate, amfee ne.” ");
INSERT INTO aaz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hi mneen amrair tuaf nak, ‘Amneek ho aom-bian, ma mutoꞌon tuaf reꞌ natoꞌon ko.’ ");
INSERT INTO aaz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mes Au utoon ki on nai: ho ro he mneek tuaf reꞌ natoꞌon ko. Ma mtoit he Uisneno nfee tetus neu tuaf reꞌ anhaꞌmuiꞌ ko. ");
INSERT INTO aaz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Karu ho mmoeꞌ on naan ate, ho mukriir am mak, ho reꞌ ia Ama abit sonaf neno tunan In anah. Natuin In nmoeꞌ manas he ntanaꞌ neu atoin reko, ma In nmoeꞌ manas he ntanaꞌ atoin maufinu msaꞌ. In nasanut uran amsaꞌ neu tuaf-tuaf reꞌ anmoeꞌ natuin In aprenat nabu-buan nok tuaf-tuaf reꞌ nraban In aprenat. ");
INSERT INTO aaz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Onaim karu ho suma mneek maan ahaa tuaf-tuaf reꞌ nneek ko te, ho mak aiꞌ Uisneno of anbaras anfee ko tetus? Kaah fa, tua! Atoin maufinu msaꞌ anneek sin aok-biak ein reꞌ anneek sin. ");
INSERT INTO aaz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Onaim karu ho suma musee ma mtaeb ho aom-bian ate, in areokn ii saaꞌ? Fin tuaf reꞌ ka npirsai fa Uisneno anmoeꞌ on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Onaim mimnau! Hi Amaꞌ abit sonaf neno tunan, anneek nain mansian pah-pinan. Onaim hi ro he mmoeꞌ on naan amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Naiꞌ Yesus nanoniꞌ nkoon om nak, “Mimnau! Kais ammoeꞌ mitun-tuin ahaa rais pirsait ii in atoran henatiꞌ hi mipein boꞌis. Fin karu hi mmoeꞌ on naan ate, hi Amaꞌ abit sonaf neno tunan of ka nfee ki fa upan ma paꞌe saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Karu hi mroim he mturun atoin kasian sin ite, kais mibenoꞌ rasi naan. Fin karu hi mmoeꞌ on naan ate, hi on reꞌ tuaf reꞌ naꞌuab aꞌtetaꞌ, ma anmoꞌe ꞌtetaꞌ. Sin nromin he nnaon neu-mneman neun uim onen henatiꞌ biak ein anboꞌis sin im nak, ‘Hoe, atoniꞌ reꞌ ia maꞌtain besi, joo!’ Amneen mirek-rekoꞌ, fin Au uꞌuab batuur! Nok ranan reꞌ sin napenin boꞌis on naan ate, sin ntoupu nrarin sin upan ma sin paꞌen. ");
INSERT INTO aaz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Onaim karu hi mroim he mturun ma mbaab atoin kasian sin ite, kais mibenoꞌ rasi naan meu sekau-sekau. ");
INSERT INTO aaz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nok ranan naan, tuaf-tuaf anbin pah-pinan ia ka nahiin je fa. Mes hi Amaꞌ abit sonaf neno tunan es reꞌ nahiin saaꞌ reꞌ hi mmoeꞌ je mninuꞌ-mninuꞌ naan. In of anbaras neu ki tetus-athoen.” ");
INSERT INTO aaz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Oras hi mꞌonen ate, kais ammoeꞌ hi tuam ein on reꞌ tuaf reꞌ naꞌuab aꞌtetaꞌ, ma nmoꞌe ꞌtetaꞌ. Sin nroimk ein esan reꞌ he nnaon neu-mneman nbin raan opat, ma nhaken nbin uim onen, henatiꞌ too mfaun ein sin nitan ma nboꞌis sin im nak, ‘Sin atoni kniunꞌ ein, joo!’ Mes amneen mirek-rekoꞌ! Nok ranan reꞌ sin napenin boꞌis on naan, sin napenin nrair sin upan ma sin paꞌen. ");
INSERT INTO aaz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mes hi kais on reꞌ naan amsaꞌ. Karu hi mꞌonen ate, amtaam meu keꞌen, rarit miꞌeek enoꞌ. Rarit amꞌonen mirek-rekoꞌ meu hi Amaꞌ. Maski biak ein ka nitan fa, mes hi Amaꞌ niit. In of anbaras neu ki tetus nathoen. ");
INSERT INTO aaz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Karu hi mꞌonen ate, kais miꞌuab amnanu-mnanuꞌ meu-mꞌiim. Fin tuaf-tuaf reꞌ ka nahiin fa Uisneno nmoeꞌ on naan amsaꞌ. Sin nateenb ein nak, Uisneno nneen ma natniin sin onen reꞌ mnanu-mnanuꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kais ammoeꞌ mituin sin! Fin hi ka mtoit fa saaꞌ-saaꞌ fa feꞌ meu hi Amaꞌ et sonaf neno tunan, mes In nahini nrair saaꞌ reꞌ hi mperluu. ");
INSERT INTO aaz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Onaim karu amꞌonen ate, mak on nai: ‘Amaꞌ abit sonaf neno tunan! Ho kanam naan nakninuꞌ teeb. Maut he areꞌ mansian ein ok-okeꞌ nbin pah-pinan ia ntunaꞌ ma naꞌratan Ho kanam maꞌtaniꞌ naan, tua. ");
INSERT INTO aaz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maut he Ho mjair Usif meu mansian ein okeꞌ, tua! Maut he bifee-atoniꞌ sin arsin anmoꞌen natuin Ho preent ein anbin pah-pinan ia, nahuum on reꞌ Ho ameupt ein anmoeꞌ natuin Ho preent ein etan sonaf neno tunan, tua. ");
INSERT INTO aaz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amturun ma mbaab maan kai nok bukaet reꞌ nanokab ansuun neno, tua. ");
INSERT INTO aaz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hai mtoit Ko he Ho msaok main hai sanat ma penu sin, nahuum on reꞌ hai mnikan ma mniahan main tuaf-tuaf reꞌ anmoꞌen sanan neu kai, tua. ");
INSERT INTO aaz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ampafaꞌ ma mpanat kai he hai kais ammoeꞌ rais amreꞌut ma maufinu. Ma msoi mufetin kai naꞌko niut reuꞌf ee in kuasan, tua. Natuin Ho kuum, Usif reꞌ ammuiꞌ kuasa maꞌtaniꞌ ma mapinaꞌ-makraah reꞌuf. Ho kuum es reꞌ anaaꞌ aprenat nabar-baar, tua. Hai onen ma baisenut naꞌtuuk ma naꞌpaar on reꞌ naan, tua. Amin.’ ");
INSERT INTO aaz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mes amneen! Karu hi mnikan main biak ein sin saant ein neu ki, hi Amaꞌ abit sonaf neno tunan of ansaok nain hi sanat ma penu sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mes karu hi ka mroim fa he mnikan main biak ein sin saant ein neu ki, hi Amaꞌ abit sonaf neno tunan of ka nnikan nain fa hi sanat ma penu sin imsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Karu hi mꞌonen ma minaah om, kais amrisan hi humam on reꞌ tuaf reꞌ naꞌuab aꞌtetaꞌ, ma nmoꞌe ꞌtetaꞌ. Fin sin nmoꞌen on naan henatiꞌ atoniꞌ nboꞌis sin im nak, ‘Hoe! Sin reꞌ ia atoni kninuꞌ, joo!’ Mes amneen! Nok ranan naan, sin napein inrair sin upan ma sin paꞌen. ");
INSERT INTO aaz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mes karu hi minaah om, mimeu kninuꞌ-kninuꞌ, msoiꞌ hi ꞌnaak fuun ein rek-reko! ");
INSERT INTO aaz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Onaim tuaf ankius ki on naan ate, sin ka nahinin fa nak, hi minaah om. Mes hi Amaꞌ nahiin. In of anbaras neu ki nok tetus-athoen.” ");
INSERT INTO aaz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kais ammeup maꞌtaniꞌ henatiꞌ mbubun aꞌmuꞌif pah-pinan. Fin etas, ꞌfufuꞌ ma nutus of nareuꞌ sin. Ma abakat of neem ma npukai rarit nabaak neik sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mes reko nneis hi mmeup maꞌtaniꞌ he mbubun aꞌmuꞌif amfa-faun et sonaf neno tunan. Fin anbi bare naan, etas, ꞌfufuꞌ, ma nutus ka bisa nareuꞌ sin fa. Ma abakat ka bisa neem ma npukai he nabaak neik sin fa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hi mitunuꞌ hi ꞌmuiꞌm ein anbin mee te, hi neekm ein naꞌkiiꞌ naher-heran anbi naan.” ");
INSERT INTO aaz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Maat mansian ii, nahuum on reꞌ paku reꞌ ntanaꞌ nbi in nekan. Karu in maatn ein nakniunꞌ ein, in nnao natuin raan aꞌhonis arekot, nahuum on reꞌ atoniꞌ nnao nbi meꞌu. ");
INSERT INTO aaz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mes karu in maatn ein ankupun, in ka nnao natuin fa raan reko, on reꞌ tuaf reꞌ annao nbi meisꞌokan, nabre-reo goah. Onaim karu meuꞌ-sineꞌ reꞌ et hi neekm ein naan nameisꞌook, hi ammoni mbi meisꞌokan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atoniꞌ ka bisa fa he nmeup rek-reko neu aam usif tuaf nua, natuin in of anroim aam usif es anneis naꞌko aam usif es antein. In of natuin aam usif es, mes in of ka ntoe natuin fa aam usif es antein. Nok ranan naan, ho ka bisa fa he mak, ‘Uisneno naan, au usiꞌ,’ karu ho mpaek roit ii njair ho usif. ");
INSERT INTO aaz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Es naan ate, Au utoon ꞌeu ki on nai: kais mitenab humaꞌ-humaꞌ, mak au he ꞌmoin on mee, au he ꞌuah saaꞌ, ꞌiun saaꞌ, ma ꞌpaek saaꞌ? Hi mak aiꞌ moint ii es reꞌ he taah am tinu haa, oo? Ma aof ii es reꞌ tpake haa baru? Ka on fa naan, tua. ");
INSERT INTO aaz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Amkius miit koron reꞌ natpenen et neon goe tnanan. Sin ka nsenan fa, rarit nsekin aiꞌ nonun fa he natuun ein amnahat anbin poꞌof. Mes hi Amaꞌ abit sonaf neno tunan anpijaar ma npairoir sin piut. In bisa npijaar ma npairoir ki msaꞌ, anneis naꞌko sin. Onaim mitenab mirek-rekoꞌ feꞌ. In nnilei ki nneis naꞌko koron naan. ");
INSERT INTO aaz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Karu atoniꞌ ntae in human anbi nino, rarit in ntaisiub nok in tuan, in bisa naꞌbabaꞌ in asratan, aa oo? Ka bisa fa, tua! ");
INSERT INTO aaz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Karu kaah fa te, nansaaꞌ am es hi mtaisibub hi tuam ein he mitenab rasi anmatoom nok pake-nohas? Amnao mkius miit fuboon bakung et mneraꞌ huun. Sin ka nasuun ma ntenun fa. ");
INSERT INTO aaz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mes amneen mirek-rekoꞌ, joo! Usif Soleman in tai paken sin reꞌ maꞌosaꞌ nneis ji, ka namnees fa nok fuboon ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Fin Uisneno ntao In nekan neu fubonaꞌ reꞌ anmoin neno ia, rarit nokaꞌ on naan ate anmaet, onaim nait inporin neu ai. Karu In nmoeꞌ on naan, In ro tebes, nfee ki pake-nohas anneis naꞌko fuboon ein naan amsaꞌ. Onaim nansaaꞌ am es hi ka mpirsai Je fa batuur-batuur? ");
INSERT INTO aaz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Onaim kais hi teenb ein antaisibun am mak, ‘Hit he taah aiꞌ tiun saaꞌ?’ ai ‘Hit he tpaek saaꞌ?’ ");
INSERT INTO aaz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tuaf reꞌ ka npirsai fa Uisneno, sin nmeup maꞌtain-tain ein he nsobaꞌ niit rasin reꞌ naan ok-okeꞌ. Mes hi kais on naan! Fin hi Amaꞌ abit sonaf neno tunan nahini nrair saaꞌ reꞌ hi mperluu sin. ");
INSERT INTO aaz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mes hi ro he minaob mihunun In meup goe feꞌ, ma mituin mihunun In apreent ein feꞌ, rarit In naꞌbabaꞌ areꞌ kanan rasi reꞌ hi mperluu sin. ");
INSERT INTO aaz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Onaim kais amtaisibub hi teenb ein anmatoom nok saaꞌ reꞌ hi mperluu sin nokaꞌ-nmeu. Fin nokaꞌ-nmeu on naan ate, in nmuiꞌ in rais taisibu ntein. Susat neno ia, in nanookb on neno ia.” ");
INSERT INTO aaz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hi kais amtuꞌiran ma mikuu tuaf, he Uisneno kais antuꞌiran ma nakuu ki. ");
INSERT INTO aaz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hi mnilei tuaf on mee te, Uisneno of annilei ki on naan amsaꞌ. Hi mruuk ma mꞌukur es in sanat on mee te, Uisneno of anruuk ma nꞌukur ki on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Fin ho mroim he mtanar tuaf in sanat aanꞌ-anaꞌ, mes ho sanat reꞌ koꞌu, ho mak ho ka mmuiꞌ fa, tua. Naan on reꞌ ho mkisu skukuꞌ kboeꞌ aan es et ho aom-bian in matan. Te kaah, hau tuuk kouꞌ goes antoeb naan ho matam. Amneon ii, ho ka mnaben fa. ");
INSERT INTO aaz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","On nai te, nansaaꞌ am es ho mak, ‘Baꞌe! Uum he au ꞌfuu upoit makrafuꞌ et ho matam naan feꞌ.’ Te kaah, ho ka mkius miit fa saaꞌ-saaꞌ, fin anmuiꞌ naan hau tuuk kouꞌ goes antoeb naan ho matam. ");
INSERT INTO aaz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Koeh! Ho reꞌ naan, tebes ro apoit! Mait imporin hau tuuk koꞌu naan naꞌko ho matam feꞌ, naꞌ ho bisa miit, he mfuu mupoitan makrafuꞌ naꞌko ho aom-bian in matan naan. ");
INSERT INTO aaz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kais minoniꞌ rasi kninuꞌ meu tuaf-tuaf reꞌ akreꞌet ma aratin. Natuin sin reꞌ naan on reꞌ aus araut reꞌ antebi nfain neem ma nrau ki. Sin nmonon on reꞌ fafi. Karu tuaf anfee ne ꞌhekeꞌ naꞌko mutiara, in ka ntoe je fa! Fin in suma nteir ee he.” ");
INSERT INTO aaz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Karu hi mꞌonen, amtoit piut-piut meu Uisneno; In of anfee ma nnonaꞌ ki. Karu hi maim piut-piut; In of nakriraꞌ ma naruruꞌ ranan neu ki. Karu mhaman piut-piut; In of nasoit ma nfei enoꞌ neu ki. ");
INSERT INTO aaz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Fin tuaf-tuaf reꞌ ntoit piut-piut neu Uisneno, of ansium ma antoup goe. Tuaf-tuaf reꞌ naim piut-piut, of niit ma napein je. Tuaf-tuaf reꞌ nhaman piut-piut, In of nasoit ma nfei ne enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hi mitenab miit! Karu anmuiꞌ riꞌanaꞌ reꞌ antoit utunuꞌ, in aamf ee ka nfee ne fa fatu. ");
INSERT INTO aaz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Karu riꞌaan ii ntoit ikaꞌ te, in aamf ee ka nfee ne fa kaunaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hi Amaꞌ abit sonaf neno tunan, In reok reꞌuf. Onaim karu mansian amaufinut on reꞌ hi, amroim he mfee baer reko meu hi aanh ein, saaꞌ antein hi Amaꞌ! In of anfee ma nnonaꞌ saaꞌ reꞌ hi mtoit sin. ");
INSERT INTO aaz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Onaim saaꞌ reꞌ ho mroim he tuaf anmoeꞌ je neu ko, hena te, ho ro he mmoeꞌ je meu ne on naan amsaꞌ. Natuin rasi reꞌ ia, njariꞌ ꞌsukif naꞌko saaꞌ-saaꞌ reꞌ kaꞌo Musa nok mafefa kninuꞌ Uisneno bian sin, nanoniꞌ sin naꞌko afi unuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Karu tuaf anroim he ntaam neu sonaf neno tunan, in ro he nnao npeoꞌ raan maꞌrenat. Fin anmuꞌi ranan reꞌ in eonꞌ ee mainuan amsaꞌ, ma tuaf amfaun anromin he npeꞌon naan. Mes ampaant om! Fin ranan naan neik tuaf-tuaf antaam neun ai mararaꞌ abar-barat, he sin nbeits ok naꞌkon Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tuaf reꞌ nroim he ntaam neu sonaf neno tunan, ro he nnao npeoꞌ ranan reꞌ naheun nok susat ma ntaam anpeoꞌ eon maꞌrenat. Maski suma tuaf fuꞌ-fuaꞌ ahaa reꞌ annaon npeꞌon naan, mes raan maꞌrenat naan es reꞌ neik tuaf anꞌain Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ampaant om miꞌko apoit ein reꞌ naiks ok am nak, sin reꞌ naan mafefa kninuꞌ Uisneno. Fin sin nmoeꞌ jok rek-reko on reꞌ ꞌbib-kase. Te kaah, amneon ii, sin reꞌ naan anmaufinun on reꞌ aus fui reꞌ anheke ꞌbib-kase, anpius goe ma neuk goe. ");
INSERT INTO aaz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ammoeꞌ on meeꞌ he hi mihiin tuaf on reꞌ naan? Amkius miꞌko saaꞌ reꞌ sin nmoꞌe. Nahuum on reꞌ tuaf ankius hau fua-roet, nahiin hau fua-roet naan in uun. Hau fua-roet arekot, ka neu fa he naꞌko hau reꞌ ka reko fa. ");
INSERT INTO aaz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fin roet arekot, nafua fuaf arekot. Mes hau reꞌ ka reko fa nafua fua reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ka tiit tain fa hau roet arekot, nafua fua reꞌuf. Ma ka tiit tain fa hau reꞌ ka reko fa nafua hau fua-roet arekot. ");
INSERT INTO aaz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hau reꞌ nafua fua reꞌuf, tuaf of annooꞌ nain je, rarit nout nakratiꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","On naan amsaꞌ tuaf reꞌ anmoeꞌ jok anfanin mafefa kniun apoit ein. Hi bisa mihiin sin miꞌko saaꞌ-saaꞌ reꞌ sin nmoeꞌ sin.” ");
INSERT INTO aaz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Of anmuiꞌ tuaf anteek Kau mnak, ‘Usiꞌ!’ Mes suma nbi haa sin ruruk. Uisneno abit sonaf neno tunan of antitar napoitan sin. Fin suma neu tuaf-tuaf reꞌ natuin batuur-batuur In romin, In of antoup nain sin anjarin Iin na. ");
INSERT INTO aaz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Of antea neon amsoput, tuaf amfaun of anmanauk ein am nak, Au reꞌ ia sin Usif. Sin of anpaumaak ma nhaman Kau, mnak, ‘Usiꞌ ee! Hai mnao mitoon ma mibenoꞌ mrair Ho noinꞌ ein. Hai mriuꞌ niutn ein ampaek Ho kanam. Ma hai mmoeꞌ rais sanmakat humaꞌ-humaꞌ mpaek Ho kuasam.’ ");
INSERT INTO aaz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Maski sin naꞌuab ein on naan neun Kau msaꞌ, mes of Au utaan ꞌeu sin im ꞌak, ‘Hi reꞌ ia, sekau? Au ka uhiin ki fa, fin hi ka mmoin mituin fa Uisneno In romin. Onaim ampoi nai miꞌko bare ia!’ ” ");
INSERT INTO aaz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tuaf reꞌ neem ma nneen Kau, rarit anmoeꞌ natuin Au uabk ein, in reꞌ naan on reꞌ tuaf ahinit, reꞌ nafenaꞌ umiꞌ nbi faut fanderen. ");
INSERT INTO aaz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aꞌroo-ꞌroo te, uur kouꞌ gui neem ma noe saok gui nsae. Ain kouꞌ gui ankataas umiꞌ naan amsaꞌ. Mes umiꞌ naan ka ntaikoib fa, natuin in nhaek et faut fanderen maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tuaf reꞌ neem ma nneen Kau, mes ka nmoeꞌ natuin fa Au uabk ein, in reꞌ naan on reꞌ tuaf amonot reꞌ nafenaꞌ umi nbi snaen ee fafon. ");
INSERT INTO aaz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aꞌroo-ꞌroo te, uur kouꞌ gui neem tar antea noe saok gui nsae. Ain kouꞌ gui nkataas umi naan amsaꞌ. Onaim umi naan ntaikobi kratiꞌ-kratiꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Naiꞌ Yesus naꞌuab anrair on naan ate, sin ar-arsin ansanmakan nok In noinꞌ ein naan, ");
INSERT INTO aaz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","fin In nahiin batuur-batuur noinꞌ ein naan in afan. Cara reꞌ In npaek je gui, ka on fa tunggur agaam ein. ");
INSERT INTO aaz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Naiꞌ Yesus ansaun neem naꞌko ꞌtoꞌef, onaim too mfaun ein neman buꞌ-buaꞌ ma natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nok askeken ate, tuaf es neem anpaumaak Ee. Tuaf reꞌ ia nameen meen nui-atrokiꞌ. In nriꞌtuu ma nbaiseun Naiꞌ Yesus am nak, “Usiꞌ! Amturun maan kau, tua! Karu Usiꞌ Ho mromi te, Ho muneuk main au menas ia, maut he biak ein kais anmaiꞌnisin kau ntein, onaim au bisa ꞌonen aꞌbi uim onen.” ");
INSERT INTO aaz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Anneen on naan ate, Naiꞌ Yesus annonaꞌ In aꞌniman, rarit anreoꞌ amenat naan, ma naꞌuab am nak, “Au ꞌroim! Ho mureok nai!” Nok askeken ate, menas naan namneuk nain. ");
INSERT INTO aaz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Rarit Naiꞌ Yesus natoon neu ne mnak, “Mumnau! Ho mureok goen, mes kais mutoon ee meu sekau-sekau. Ho ro he mnao mmoeꞌ mutuin kaꞌo Musa in atoran afi unuꞌ. Onaim mnao nai meu aꞌnaak pirsait, maut he in nparikas ho aom, maut he in nahiin nak ho menas ia namneku, oo, aiꞌ kahaf? Rarit ho ro he meik fuaꞌ-turuꞌ njair tanar nak ho mfee makasi. Nok ranan naan, maut he too mfaun ein nahinin nak, ho mureko mrair.” ");
INSERT INTO aaz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Rarit Naiꞌ Yesus antaam neu kuan Kapernaum. Anbi naan, anmuiꞌ aꞌnaak sorarus Roma es neem he ntoit turun-babat. In nak, ");
INSERT INTO aaz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Usiꞌ! Au ameput tuaf es nmouf menas maꞌfenaꞌ et umi. In ka nfeen naan fa goen naꞌko harak, fin in nmakaar een, onaim he noi nmaet jen, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Naiꞌ Yesus nataah am nak, “Reko! Au of ꞌeit urekoꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mes aꞌnaak sorarus naan nak, “Usiꞌ! Ho kais muhaeb Om he uum meu au umi. Fin au ka pantas fa he ꞌtoup Ko ꞌbi au umi. Asar Ho muꞌuab ambi bare ia te, ro tebes au ameput naan of nareok nain. ");
INSERT INTO aaz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au uhiin rasi ia, natuin au aꞌnaakt ein anmuꞌin kuasa he naprenat kau. Ma au aꞌmuiꞌ kuasa msaꞌ he uprenat au soraurs ein. Karu au uprenat au soraur aan ein ꞌak, ‘Meu nee!’ Tebes! In ro he nnao. Karu au ꞌak, ‘Meu ia!’ Tebes! In ro he neem. On naan amsaꞌ, karu au ꞌreun au ameupt ein ꞌak, ‘Ammeup ia!’ Tebes! In ro he nmeup on naan. Onaim asar Usiꞌ Ho muꞌuab aah, ro tebes au ameput naan, nareok nain.” ");
INSERT INTO aaz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Anneen on naan ate, Naiꞌ Yesus ansanmaak. In naꞌuab neu too mfaun ein reꞌ natuin Ee naan am nak, “Ia rais sanmakat es! Aꞌroo-ꞌroo goen, mes Au ka ꞌiit ma uteef ꞌiit fa atoin Yahudis es, reꞌ in npirsai ne maꞌtaniꞌ on reꞌ atoin Romas ia! ");
INSERT INTO aaz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Amneen mirek-rekoꞌ! Fin of anmuiꞌ kase mfaun on reꞌ atoin Romas ia reꞌ neman naꞌkon pasaꞌ maans ee ꞌsaen ma pasaꞌ maans ee ꞌmoufun, reꞌ ntokon ma nbukaen buꞌ-buaꞌ nok kaꞌo Abraham, kaꞌo Isak, ma kaꞌo Yakop anbin Uisneno In baran et sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Maski Uisneno npiir inrair atoin Yahudis he njarin Iin na, mes tuaf amfaun naꞌko sin ka ntoe natuin Ee fa. In of antitar napoitan sin neun baer meisꞌook tape. Anbi bare naan kurut-kaet ma haꞌmuꞌit maꞌtain besi.” ");
INSERT INTO aaz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naꞌuab anrair on naan ate, Naiꞌ Yesus natoon neu aꞌnakat naan am nak, “Aam! Amfain nai. Fin ho ameput naan, nareko nrair, natuin ho rais pirsait.” Oras naan, ameput naan nareok nain. ");
INSERT INTO aaz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Neot es, Naiꞌ Yesus antaam anbi naiꞌ Petrus in umi. In niit naiꞌ Petrus in ain babaf antuup anbi harak. Bifee mnasiꞌ naan anmainiin. ");
INSERT INTO aaz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naiꞌ Yesus annaaꞌ in aꞌniman, onaim bifee mnasiꞌ naan in maininit, namneuk nain. Rarit in nfeen ma ntuthae Naiꞌ Yesus sin. ");
INSERT INTO aaz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oras maans ee nmouf, tuaf amfau neman. Sin nok tuaf-tuaf reꞌ anniut saen. Rarit Naiꞌ Yesus naprenat nitun naan am nak, “Hoe nitu! Ampoi nai miꞌko tuaf ein reꞌ ia!” Onaim nitun naan anpoi nanin oras naan. In narekoꞌ ameent ein ok-okeꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","In nmoeꞌ rasin reꞌ ia, he natuin saaꞌ reꞌ mafefa kninuꞌ Uisneno naiꞌ Yesaya antui nain je mnak, “In narekoꞌ hit menas. Ma In nasaah hit haꞌmuꞌit.” ");
INSERT INTO aaz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Rarit Naiꞌ Yesus niit too mfaun ein neman ma naub naan Ee. Onaim In nreun In atoup noinꞌ ein am nak, “Iim he hit tsae kofaꞌ ma tatnain teu neof gui panin.” ");
INSERT INTO aaz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Onaim tunggur agaam es naꞌuab am nak, “Aam Tungguru! Ho mꞌain mee-mee jah, au ꞌroim he utuin Ko piut, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mes Naiꞌ Yesus nataah am nak, “Reko msaꞌ! Mes mumnau. Mansian ma muꞌit anmuꞌin bare ꞌtua-haꞌ. Aus fui ji nfain neu in nuat. Koor gui nfain neu in kunaꞌ. Mes Au, Mansian Batuur-Batuur reꞌ ia, ka ꞌmuiꞌ kuuk fa umi he ꞌfain ꞌeu naa. Akaꞌnunuꞌ msaꞌ, ka ꞌmuꞌif.” ");
INSERT INTO aaz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Rarit tuaf es anteniꞌ reꞌ natun-tuin Ee, neem ma ntoti mnak, “Usiꞌ! Au he utuin Ko Usiꞌ, mes maut he au ꞌfain he ꞌkius ꞌaan au mahoint ein feꞌ. Karu au amaꞌ nmate nrair feꞌe te, naꞌ au ꞌuum he utuin Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mes Naiꞌ Yesus naꞌuab am nak, “On nai! Anbain he biak ein reꞌ ka npirsain fa neun Uisneno sin ansuub amaets ein. Fin karu ho mroim he mutuin Kau te, ho ro he mutuin batuur-batuur!” ");
INSERT INTO aaz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Rarit Naiꞌ Yesus ansae nbi kofaꞌ naan, nok In atoup noinꞌ ein. ");
INSERT INTO aaz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Oras sin nnaon neu neof goe panin, In ntuup. Ka ꞌroo fa te, ain kouꞌ gui neem. Oikn ein anpesan, onaim oe ji ntaam anbi kofaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ankisun on naan ate, atoup noinꞌ ein anpooꞌ Goe mnak, “Usiꞌ! Usiꞌ, ee! Amfeen he mturun maan kit feꞌ. Hit he treem atmaet jen, oo!” ");
INSERT INTO aaz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Onaim Naiꞌ Yesus nataah am nak, “Hae, nansaaꞌ am es hi mimtau on nai!? Hi ka mpirsai Kau fa, oo?” Onaim In nfeen. Rarit In nakain anin ma okin naan am nak, “Misnaas nai!” Onaim okin ma anin nasnaas nanin. ");
INSERT INTO aaz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Onaim Naiꞌ Yesus In atoup noinꞌ ein ansanmakan. Sin naꞌuab ein am nak, “Hae! In reꞌ ia, sekau? On mee mꞌes In bisa naprenat anin ma okin he natuin In romin?” ");
INSERT INTO aaz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ka ꞌroo fa te, sin ntean neof goe panin, anbi atoin Gadaras sin pah. Anbi bare naan, anmuiꞌ tuaf nua anniut saen. Sin natuan etan nuat baer subat. Sin reꞌ naan maufiunk ein kah een, tar antea ka tiit fa tuaf nabrain he nnao npeoꞌ bare naan. Sin nkius niit Naiꞌ Yesus neem on naan ate, ");
INSERT INTO aaz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","sin nkoaꞌ ein am nak, “Hoi Aan Uisneno! Nansaaꞌ am es Ho uum moik kai? In oras he nhukun kai ka ntea fa feꞌ, mes Ho he mhaꞌmuiꞌ kai.” ");
INSERT INTO aaz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Anbi bare naan, anmuiꞌ naan fafi pukan es amfaun ii kah. Sin oobn ein amnahat. ");
INSERT INTO aaz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Onaim niut ne nbaisenun ma ntotin neu Naiꞌ Yesus am nak, “Karu mroim he mriuꞌ kai te, amreun kai he mtaam meu fafin reꞌ nee, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Onaim Naiꞌ Yesus naprenat sin im nak, “Amnao nai!” Rarit nitun naan anpoin naꞌko tua nuaꞌ ein naan, onaim sin ntaman neun fafin naan. Onaim fafin naan naenan nsiksakn ok nsanun naꞌkon aꞌtoꞌef naan ma nmoufun neun nefo. Onaim sin nreem anmaten. ");
INSERT INTO aaz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ankius nitan on naan ate, atiut fafin naan naen anfanin neun kuan, onaim sin natonan abitan kuan ee nanan. ");
INSERT INTO aaz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Annenan on naan ate, too mfaun ein anpoin neun bare naan. Sin niit Naiꞌ Yesus, onaim sin nak Ee he nasaitan sin kuan ma bare naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Rarit Naiꞌ Yesus sin ansaen nfanin neun kofaꞌ naan, ma annaon nfanin neun neof goe panin, ma ntean In kota. ");
INSERT INTO aaz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Anbi bare naan, anmuiꞌ naan tuaf naꞌtaeb neik sin aok-bian reꞌ nameen buaꞌ neu Ne. Ankius niit sin on naan ate, Naiꞌ Yesus nahiin nak sin npirsai Je nak, In bisa narekoꞌ sin aok-bian amenat naan. Onaim In naꞌuab neu amenat naan am nak, “Anah! Amhaꞌtain ho nekam naan feꞌ! Fin Au ꞌsako ꞌrair ho saant ein.” ");
INSERT INTO aaz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mes anbi bare naan, anmuiꞌ tunggur agama Yahudi tuaf fauk anhaek nokan. Sin nneen Naiꞌ Yesus naꞌuab on naan. Onaim sin ruik ein anbesin. Rarit sin naꞌuab ein am nak, “Atoniꞌ reꞌ ia nabrain bainesiꞌ he naꞌuab on naan, oo! Suma Uisneno kuun es reꞌ bisa nsaok sanat. Mes atoniꞌ reꞌ ia in uaban naan, anmoeꞌ jon on reꞌ Uisneno. Ia rais manꞌakan neu Uisneno goen!” ");
INSERT INTO aaz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mes Naiꞌ Yesus nahini ntea sin nekak naank ein. Rarit In naꞌuab am nak, “Nansaaꞌ am es hi mitenab am mak, Au uꞌakan Uisneno? ");
INSERT INTO aaz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mee es maꞌkafaꞌ nneis? Karu Au ꞌak ꞌeu abuat reꞌ ia mꞌak, ‘Ho saant ein masakoꞌ nrairn een,’ aiꞌ Au ꞌak, ‘Amfeen nai, ma mfain nai.’ ");
INSERT INTO aaz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Karu in nfeen nain oras naan, naꞌ hi miit bukti, mmak, Au reꞌ ia, Mansian Batuur-Batuur. Fin Au ꞌmuiꞌ hak he ꞌsaok sanat.” Onaim Naiꞌ Yesus naprenat ameen buaꞌ naan am nak, “Amfeen nai! Mait ho baerꞌ ein ma mfain nai!” ");
INSERT INTO aaz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Onaim ameen buaꞌ naan anfeen, ma ntebi nfain. ");
INSERT INTO aaz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ankisun on naan ate, too mfaun ein ansanmakan. Rarit sin naikas ma npures naꞌrat-ratan Uisneno In kanan am nak, “Uisneno mapinaꞌ-makrahaꞌ! In nfee kuasa maꞌtaniꞌ on naan neu mansian.” ");
INSERT INTO aaz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Rarit Naiꞌ Yesus annao nkoon naꞌko bare naan, onaim In niit atoin ahoik beo tuaf es anmepu nbi kantoor pajak. Atoniꞌ naan kaan ee, naiꞌ Mateos. Rarit Naiꞌ Yesus nak ee mnak, “Uum mutuin Kau!” Anneen on naan ate, naiꞌ Mateos anfeen ma natuin nain Je oras naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Rarit naiꞌ Mateos naskau Naiꞌ Yesus sin neman neun in umi he nbukaen. In nfee haan askaut amsaꞌ neu in aok-bian ahoik beo ngguin, ma tamu bian sin, he neman ma nbukaen buꞌ-buaꞌ nok sin. ");
INSERT INTO aaz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mes tuaf fauk naꞌkon partei Farisi neman ma naꞌmuaꞌ ein anbin Naiꞌ Yesus In atoup noinꞌ ein. Sin naꞌuab ein am nak, “Nansaaꞌ am es hi tunggur goe naah-niun nok atoni krafun sin, on reꞌ ahoik beo, ma in aok-bian atoin maufiun ein?” ");
INSERT INTO aaz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mes Naiꞌ Yesus natoon neu sin im nak, “Ameent ii nperluu apairorit on reꞌ dokter. Mes ao-miin ii, ka nperluu goe fa. ");
INSERT INTO aaz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Reko nneis hi mfain ma mparikas mirek-rekoꞌ Uisneno In Kabin ma Prenat reꞌ mafefa kninuꞌ naiꞌ Hosea ntui je mnak, ‘Au roimk ii, es reꞌ, Au ngguin anmanekan es nok es, ma nakriraꞌ rais kasian. Karu sin ka nmoꞌen fa on naan ate, sin muꞌi-ꞌturuꞌ reꞌ sin neik sin neun Kau naan, ka maꞌupan ma mapaꞌen fa saaꞌ-saaꞌ.’ Uisneno es reꞌ naꞌuab on naan. Nok ranan naan, Au ka ꞌuum fa he ꞌurus tuaf-tuaf reꞌ naan in tuan ee nak in reko nrair, mes Au ꞌuum he ꞌurus tuaf-tuaf reꞌ amreuꞌt ein.” ");
INSERT INTO aaz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Rarit naiꞌ Yohanis Asranit in atoup noinꞌ ein neman ma nateef nok Naiꞌ Yesus. Sin nataan Ee mnak, “Hai atuinaꞌ naiꞌ Yohanis biasa minaah om. Atoin Farisis sin nanaah ok amsaꞌ. Mes nansaaꞌ am es Ho atoup noinꞌ ein naah-ninun piut? Sin ka nanaah ok fa, oo?” ");
INSERT INTO aaz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mes Naiꞌ Yesus nataah sin anpaek uab manporin am nak, “On nai: karu anmuiꞌ fesat kabin, taumn ein ka nanaah ok fa, mes sin ro he nbukaen tar namsenan. Karu baroit atoin ee nbi nana feꞌe te, sin of anbukaen buꞌ-buaꞌ. Mes of anbi oors es, karu tuaf bian anheek baroit atoin aan on naan ate, naꞌ in aok-biak ein ansusan. Oras naan sin nanaah ok. ");
INSERT INTO aaz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Atoniꞌ ka nait fa tai tuuk feꞌu, ma npaap ee neu baru kroef atpisuꞌ. Fin karu nsaef baru naan ate, tai tuuk feꞌu naan of annuun nggon. Nok ranan naan, baru kroef naan natpisuꞌ ma natkai nteniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","On naan amsaꞌ, atoniꞌ ka narai fa tua miin feꞌu neu ꞌsaap arapuꞌ. Fin aꞌsaap arapuꞌ naan of anpeeꞌ, onaim tua minaꞌ naan nroni ma nasai npoi. Onaim tua miin feꞌu ro he tarai je neu ꞌsaap feꞌu he nua sin ntaah ein rek-reko!” Nok ranan naan Naiꞌ Yesus nanoniꞌ sin im nak, In noniꞌ naan, feꞌu. Onaim kais maseroꞌ nok noniꞌ amnaaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Oras Naiꞌ Yesus feꞌ naꞌuab nok naiꞌ Yohanis in atoup noinꞌ ein on naan ate, aꞌnaak uim onen es neem ma nateef nok Ne. Atoniꞌ naan anriꞌtuu nbi Naiꞌ Yesus In human ma In matan, ma nbaisenu mnak, “Aam honiꞌ! Amturun maan kau, tua! Au aan feot goe, feꞌ nmaet. Au uskau Ko, tua, he mkoen Om uum, ma mtao Ho ꞌnimam meu ne, he reko te in nmoni nfain.” ");
INSERT INTO aaz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Anneen on naan ate, Naiꞌ Yesus nok In atoup noinꞌ ein, natuin atoniꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Anbin raan atnanaꞌ on naan ate, anmuiꞌ naan bifee jes natuin sin. In meen funan ka nasnaas niit fa toon boꞌes am nua goen. In natenab anbi in nekan am nak, “Asar au ꞌreoꞌ ꞌaan Naiꞌ Yesus in baru, au of ureok.” Onaim in npaumaak ma nreoꞌ Naiꞌ Yesus In baru. ");
INSERT INTO aaz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naiꞌ Yesus annaben niit, onaim In nbaniꞌ nꞌain bifee naan. Onaim In naꞌuab am nak, “Ain! Amhaꞌtain ho nekam naan. Natuin ho mpirsai batuur-batuur meu Kau, es naꞌ ho mureok.” Bifee naan nareok nain oras naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Rarit Naiꞌ Yesus sin nnao nkonon neun aꞌnaak uim onen naan in umi. Antean nee te, In ntaam ankius niit areuk nuukt ein, ma too mfaun ein ankaen npin-piuns ein. ");
INSERT INTO aaz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mes Naiꞌ Yesus naꞌuab neu sin im nak, “Misnasab hi kaet ein naan, ma mfain nai! Fin riꞌanaꞌ ia in ka nmaet fa. In suma ntuup kuun.” Mes sin nmani nfaer Ee. ");
INSERT INTO aaz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Rarit too mfaun ein naan anpoin ok-okeꞌ. Onaim Naiꞌ Yesus antaam neu riꞌanaꞌ naan in keꞌen, ma annaaꞌ in aꞌniman. Onaim riꞌanaꞌ naan anmoni nfain nain. ");
INSERT INTO aaz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ankisun on naan ate, too mfaun ein nmurai nareet ein buꞌ-buaꞌ nfuun am nateef sin pah naan, anmatoom nok saaꞌ reꞌ Naiꞌ Yesus anmoeꞌ je naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Rarit Naiꞌ Yesus annao nkoon. Anbi raan atnanaꞌ, anmuiꞌ naan aforot tuaf nua natun-tuin Ee. Sin nkoaꞌ ein am nak, “Usif naiꞌ Daut in sufan. Amkasian maan kai, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Naiꞌ Yesus antaam neu umiꞌ, onaim atoin nua afoort ein naan neman neu Ne. Rarit In nataan sin im nak, “Hi mpirsai batuur-batuur, mak Au ꞌmuiꞌ kuasa he urekoꞌ ki he hi bisa miit ma mkisu, oo?” Onaim sin natahan am nak, “Airoo, Aam! Kais mutaan amtein on naan, natuin hai mpirsai batuur-batuur meu Ko, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Anneen on naan ate, Naiꞌ Yesus anreoꞌ sin maatk ein, ma naꞌuab am nak, “Karu on naan ate, maut nai he njair natuin hi pirsait naan!” ");
INSERT INTO aaz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naiꞌ Yesus naꞌuab anrair on naan ate, sin niit nanin oras naan. Mes Naiꞌ Yesus namnaub sin maꞌtaniꞌ mnak, “Mimnau goo! Kais mitoon meu tuaf meseꞌ msaꞌ anmatoom nok rasi reꞌ njair oras ia!” ");
INSERT INTO aaz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mes sin ka bisa ntahan naan fa sin tuak ein. Rarit sin nnaon nfuun am nateef sin pah naan, he nasinaꞌ ma nabenoꞌ rasi anmatoon nok Naiꞌ Yesus In mepun naan. ");
INSERT INTO aaz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Atoin aforot tuaf nuaꞌ ein naan anpoin nrarin on naan ate, anmuiꞌ tuaf antaam neman neik tuaf es anteniꞌ neu Naiꞌ Yesus. Tuaf naan anmuu, onaim in ka naꞌuab nahiin fa, natuin niut goe natua et in tuan. ");
INSERT INTO aaz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ankius niit on naan ate, Naiꞌ Yesus naprenat nitu naan anpoi naꞌko tuaf naan. Nitu naan anpoi nain, onaim tuaf naan bisa naꞌuab nain oras naan. Rarit too mfaun ein reꞌ anbin bare naan ansanmakan. Sin naꞌuab ein am nak, “Hae! Hit atoin Yahudis ka tiit tiit fa rasi nahuum on reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mes atoin Farisis sin ka nmarinan fa. Sin naꞌuab ein am nak, “Hoe! Nitu ꞌnakaf es reꞌ anfee Ne kuasa he In bisa nriuꞌ napoitan nitu.” ");
INSERT INTO aaz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Rarit Naiꞌ Yesus annao nfuun am nateef kota ma kuan, he nanoniꞌ anbi uim oen ein. In nanoniꞌ anmatoom nok Uisneno In Rais Reko, ma anmoꞌen on mee he sin bisa anjarin Iin na. In narekoꞌ areꞌ ameent ein, ma tuaf-tuaf ein ok-okeꞌ reꞌ sin aok ein anmuiꞌ in akuran ma arabuꞌ amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ankius too mfaun ein on naan ate, Naiꞌ Yesus ankasian sin, natuin sin ka nahinin fa he nmoꞌen on mee. Fin sin ar-arsin reꞌ naan, nahuum on reꞌ ꞌbib-kase reꞌ ka nmuiꞌ fa atukus. ");
INSERT INTO aaz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Rarit Naiꞌ Yesus naꞌuab nok In atoup noinꞌ ein am nak, “Too mfaun ein reꞌ ia, nahuum on reꞌ sekit ma mnonut naꞌko rene ma etu. Maski sekit ma mnonut naan koꞌu, mes ameupt ein ka mfaun fa he nsekin ma nonun, ma natuun ee nbi poꞌof. ");
INSERT INTO aaz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nok ranan naan, hi ro he mꞌonen ma mtoit rene ma etu naan in Tuan, he nsonuꞌ ameput, maut he sin nbubun naan In rene ma etu sin aafk ein.” ");
INSERT INTO aaz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Rarit Naiꞌ Yesus noꞌen In atoup noinꞌ ein he neem nabuan. Onaim In nfeen sin kuasa he nriꞌun nitu ma narekoꞌ amenat humaꞌ-humaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Atoup noniꞌ tuaf boꞌes am nua reꞌ In nreek haefan sin naan, esan reꞌ: Ahunut, in kaan ee naiꞌ Simon (reꞌ biasa sin nteek ee nak, ‘Petrus’), rarit in orif, kaan ee naiꞌ Anderias, rarit naiꞌ Yakobus, ma in orif, kaan ee naiꞌ Yohanis (sin nua sin naan, aam Sebedius in aanh ein). ");
INSERT INTO aaz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Naiꞌ Felipus, naiꞌ Bertolomeos, naiꞌ Tomas, naiꞌ Mateos (ahoik beo), naiꞌ Yakobus (aam Alfius in anah), naiꞌ Tadius, ");
INSERT INTO aaz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","naiꞌ Simon (atuinaꞌ partei purtik Selot), ma naiꞌ Judas Iskariot (reꞌ of naꞌsosaꞌ Naiꞌ Yesus). ");
INSERT INTO aaz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Rarit Naiꞌ Yesus anreek haefan In atoup noniꞌ tuaf boꞌes am nua, ma In naprenat sin im nak, “Au ꞌreek haefan ki mnao meu hit atoin Yahudis sin, natuin tuaf amfaun naꞌko hit ni, ka natuin fa batuur anbi Uisneno In ranan. Sin reꞌ naan, on reꞌ ꞌbib-kase reꞌ anseek. Es naan ate, hi kais amnao meu tuaf reꞌ ka Yahudi sin fa, nahuum on reꞌ atoin Samarias sin. ");
INSERT INTO aaz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amnao mitoon meu hit atoin Israelas sin im mak, ‘Antea in oors aa goen he areꞌ tuaf ein arsin bisa njarin Uisneno Iin na.’ ");
INSERT INTO aaz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Amnao mirekoꞌ amenat, mimonib mifaniꞌ amates, mirekoꞌ ameen nui-atrokiꞌ, ma mriuꞌ mipoitan nitu. Uisneno nathoeb anfee ki, mes In ka ntoit fa saaꞌ-saaꞌ he njair seun baran. Onaim oras ia, hi ro he mnao mithoeb meu biak ein, mes hi kais amtoit mifaniꞌ saaꞌ-saaꞌ naꞌko sin. ");
INSERT INTO aaz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Amnao nai ruum-ruum aah, joo. Kais meik roit, ");
INSERT INTO aaz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","oe-betiꞌ, pake-nose, aꞌpein haef, aiꞌ teas. Fin atoniꞌ ro he nfee neu ameput, saaꞌ reꞌ natai nok saaꞌ reꞌ he sin bisa nmonin. ");
INSERT INTO aaz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Karu hi mtaam meu kota es, aiꞌ kuan es ate, hi maim tuaf reꞌ he ntoup ki. Rarit mitua mbi naan, tar antea hi misaitan bare naan. ");
INSERT INTO aaz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Karu hi mtaam meu tuaf es in umi te, miꞌuab am mak, ‘Hoore tua! Saloom! Tetus ma ao-minaꞌ naꞌko Uisneno neu ki.’ ");
INSERT INTO aaz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Karu uim tuaf aan antoup ki nok rek-reko, hi mtoit he Uisneno nfee tetus-athoen neu sin. Mes karu sin ka ntoup ki fa te, Uisneno ka nfee fa tetus-athoen neu sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Karu atoniꞌ ka nroim fa he nneen ma natniin ki te, mpoi miꞌko umi naan, aiꞌ kota naan, rarit mtekar askukuꞌ naꞌko hi haem ein, he njair tanar nak, sin ka nromin fa he nnenan ma natninan ki te, sin nasahan ma natahan kuuk. ");
INSERT INTO aaz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nokaꞌ-nmeu te, oras Uisneno he nfee hukun neu mansian pah-pinan ia, In of nasanut hukun maꞌfenaꞌ neu atoin Sodom ma Gomoras reꞌ unuꞌ feꞌe te maufiun reꞌuf. Mes mimnau, joo! Fin In of anfee hukun maꞌfenaꞌ nneisi nteniꞌ neu tuaf-tuaf reꞌ ka nromin fa he ntoup ki!” ");
INSERT INTO aaz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mimnau! Au ꞌreek haefan ki nahuum on reꞌ Au ꞌsonuꞌ ꞌbib-kase ntaam neu aus fui apisut sin baark ein. Etun hi ro he mpaek ronef on reꞌ kaun anonok. Ma hi neekm ein ro he namnonon on reꞌ koor kefi reꞌ ka naim nahiin fa rasi msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mes ampaant om! Atoniꞌ of anhaꞌmuiꞌ ki nahuum on reꞌ asu anrau ma npius naꞌmaet ꞌbib-kase. Sin of anheer neik ki meu bare reꞌ he nafekan rais pirsait. Ma sin of anbeos ki anbi sin uim oen ein. ");
INSERT INTO aaz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sin of anheer neik ki mnao meu gubernur aiꞌ usif, natuin hi mituin Kau. Mes hi ro he mpaek oras reꞌ naan he mitoon Au Rais Reko meu sin. Nok ranan naan, atoniꞌ reꞌ ka nahiin fa Uisneno, anneen rasi nmatoom nok Kau. ");
INSERT INTO aaz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mes karu sin nheer neik ki on naan ate, hi kais mimtau mmak, ‘Au he uꞌuab ꞌak saaꞌ?’ aiꞌ ‘Au he utaah ꞌak saaꞌ?’ Kais mitenab on naan, fin antea in oras on naan ate, hi Amaꞌ abit sonaf neno tunan natoon neu ki saaꞌ reꞌ hi ro he miꞌuab. ");
INSERT INTO aaz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Oras naan, saaꞌ reꞌ hi miꞌuab ee jaan ka naꞌuu ma naꞌbaaꞌ fa naꞌko hi tuam ein kiim, fin In Asmaan Akniunꞌ ee es reꞌ nanoniꞌ ki he hi miꞌuab saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hi mkius kiim, fin anbi uim jes in nanan, karu anmuiꞌ tuaf anpirsai Kau, of in aok-bian aa kuun es reꞌ naim ranan he naꞌmaet ee. Rarit karu in aanh ee es reꞌ apirsait, in aamf ee of es reꞌ naꞌmaet ee. Karu ainaf-amaf es reꞌ apirsait, of sin aanh ein esan reꞌ naꞌmaet sin. ");
INSERT INTO aaz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amkius kiim, of tuaf amfaun sin ok-okeꞌ nsaken mates neu ki, natuin hi mituin Kau. Mes tuaf reꞌ naran ma ntahan tar antea namsoup, Uisneno of ansoi nafetin naan ee. ");
INSERT INTO aaz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Karu atoniꞌ anhaꞌmuiꞌ ki anbi kota es ate, mfeen maen meu kota bian. Ro tebes! Au reꞌ ia, Mansian Batuur-Batuur. Hi of ka mnao misoup maan fa kota anbi Israꞌel sin ok-okeꞌ, mes Au ꞌtebi ꞌfain ꞌuum een. ");
INSERT INTO aaz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mansian ein biasa nhormaat neun tungguru tuaf es, anneis naꞌko in atoup noinꞌ ein. Ma sin anhormaat aam usiꞌ es, anneis naꞌko in ameupt ein. ");
INSERT INTO aaz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Karu atoup noin ii nanoniꞌ ma nahiin on reꞌ in tungguru, in nnaben ate, nanokab. Ma karu ameput nanoniꞌ ma nahiin on reꞌ in usin ate, in nnaben ate, nanokab amsaꞌ. Onaim mimnau! Karu tuaf noꞌen uim tuaf am nak, ‘Ho reꞌ ia Balsebul, es reꞌ nitu ꞌnakaf’ te, in uim je naan ee msaꞌ napein kanaf reꞌ ka reko fa ntein.” ");
INSERT INTO aaz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Onaim hi kais mimtausan tuaf-tuaf reꞌ anraban ki. Fin saaꞌ reꞌ atoniꞌ nmoeꞌ je nbi baer maꞌnifaꞌ-maꞌkoroꞌ, of mamnitaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Saaꞌ reꞌ au unoniꞌ ki sin ammees-mees, hi ro he mnao mitoon meu too mfaun. Ma saaꞌ reꞌ Au utoon ee mninuꞌ-mninuꞌ ro he mnao mitoon ee nfuun am nateef meu areꞌ bare-bare. ");
INSERT INTO aaz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kais mimtausan mansian, fin sin suma naꞌmate haa mansian ii in aon, mes sin ka bisa fa he nareꞌu tuaf in asmanan. Onaim hi ro he mimtausan meu Uisneno, fin In kuun es reꞌ anmuiꞌ kuasa he nporin nataam aof-taꞌuf ma smanaf neu ai abar-barat. ");
INSERT INTO aaz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Onaim amhaꞌtain hi neekm ein naan. Atoniꞌ naꞌsosaꞌ koor makaꞌ anbi ꞌmasaꞌ oosn ii maꞌkaaf aah. Mes ka tiit tain fa es he nmoufun nmaet, karu hi Amaꞌ abit sonaf neno tunan ka nfee fa mainuan. ");
INSERT INTO aaz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hi Amaꞌ abit sonaf neno tunan antae niit ki tar antea saaꞌ reꞌ aanꞌ-anaꞌ krisiꞌ. Hi ꞌnaak fuun ein amfauk ein amsaꞌ, In nahiin sin. ");
INSERT INTO aaz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Onaim hi kais mimtau! Natuin Uisneno naan ki maꞌosaꞌ nneis naꞌko koor maak ein ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Rarit Naiꞌ Yesus naꞌuab anteniꞌ mnak, “Tuaf reꞌ nabrain he nmanakuꞌ Kau nbi too mfaun ein sin humak ma sin maatk ein anbi pah-pinan ia, Au of aꞌmanakuꞌ ma uhiin je msaꞌ ꞌbi Au Amaꞌ abit sonaf neno tunan am ꞌak, ‘Tuaf reꞌ ia, Au Iin ja, tua.’ ");
INSERT INTO aaz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mes tuaf reꞌ nasuan ma natotan kau nbi too mfaun ein sin humak ma sin maatk ein am nak, in ka nahiin Kau fa, Au msaꞌ of utoon ꞌeu Au Amaꞌ abit sonaf neno tunan am ꞌak, ‘Au ka uhiin fa tuaf ia, tua.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Hi kais mitenab am mak, Au ꞌuum he ꞌeik rais rameꞌ ꞌeu pah-pinan ia. Fin Au ꞌuum he ꞌmoeꞌ mansian ein anmaraban es nok es. ");
INSERT INTO aaz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au ꞌuum aꞌbi pah-pinan ia, utuin saaꞌ reꞌ mafefa kninuꞌ Uisneno naꞌuab anrari mnak, ‘Aan mone of anraban in amaf, aan feto of anraban in ainaf, ma aan nanef of anraban in ain babaf, ");
INSERT INTO aaz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","fin uim jes in nanan anmamusun es nok es.’ ");
INSERT INTO aaz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Onaim tuaf reꞌ batuur-batuur anroim he natuin Kau, in ro he nneek Kau nneis naꞌko areꞌ saaꞌ-saaꞌ ii ok-okeꞌ, anneis naꞌko in ainaf-amaf, ma anneis naꞌko in aanh ein. Fin karu kaah fa te, tuaf reꞌ naan ka pantas fa he njair Au ngguin. ");
INSERT INTO aaz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Fin tuaf reꞌ anroim he natuin Kau, mes ka nroim fa he nasaah haꞌmuꞌit, in ka pantas fa he njair Au ngguin. ");
INSERT INTO aaz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tuaf reꞌ nabarab ma naroitan in tuan he nmaet, natuin in natuin Kau, in of napeni ꞌhonis piut-piut nok Uisneno. Mes tuaf-tuaf reꞌ suma nroim he nmoin arahaa neu in tuan aa kuun, of in aꞌmonin naan, namneuk on ahaa reꞌ naan!” ");
INSERT INTO aaz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tuaf reꞌ antoup ki nok rek-reko, in ntoup Kau msaꞌ. Ma tuaf reꞌ ntoup Kau, in antoup Uisneno msaꞌ reꞌ anreek haefan Kau. ");
INSERT INTO aaz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tuaf reꞌ ntoup mafefa kninuꞌ Uisneno, natuin mafefa kninuꞌ naan naꞌuab rasi nmatoom nok Uisneno, Uisneno of anbaras neu ne on reꞌ Uisneno nbaras neu mafefa kninuꞌ es. Ma tuaf reꞌ ntoup tuaf es, reꞌ neek amneꞌo, natuin tuaf reꞌ naan batuur-batuur natuin Uisneno In romin, Uisneno of anbaras neu ne on reꞌ Uisneno nbaras neu tuaf es, reꞌ in neekn ee mneꞌo. ");
INSERT INTO aaz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tuaf reꞌ antoup tuaf es, reꞌ aan ba-baun reꞌ-reꞌuf, natuin in natuin Kau, ro tebes Uisneno of anbaras neu ne. Maski suma atoniꞌ anfee oe ruum-ruum, Uisneno of ka nnikan ma niahan fa tuaf naan.” ");
INSERT INTO aaz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Oras Naiꞌ Yesus anfee nrair rais manbaꞌan neu In atoup noniꞌ boꞌes am nua on naan ate, In nnao neu kuan-kuan anbin pah reꞌ naan, he nanoniꞌ ma natoon Uisneno In Rais Reko. ");
INSERT INTO aaz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Oras naan, naiꞌ Yohanis anbi bui. Oras in nneen areꞌ rasin reꞌ Naiꞌ Yesus anmoeꞌ sin naan, in nreek haefan in atoup noinꞌ ein he nnao nataan Naiꞌ Yesus am nak, ");
INSERT INTO aaz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Uisneno nbaꞌan nain naꞌko afi unuꞌ mnak, In he nsonuꞌ Kristus antaam neem he nsoi nafetin kit atoin Yahudis. Onaim au he utaan ꞌak, Ho reꞌ ia, Kristus, aa oo? Aiꞌ hai ro he mpao tuaf es antein?” Onaim sin nnaon ma nataan Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Anneen on naan ate, Naiꞌ Yesus nataah am nak, “Hi mneen amrair ma miit kiim. Onaim amfain nai ma meu te mitonan naiꞌ Yohanis am mak, areꞌ saaꞌ-saaꞌ ii njari nrarin, natuin saaꞌ reꞌ mafefa kninuꞌ Uisneno naiꞌ Yesaya antui nain je mnak, ");
INSERT INTO aaz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aforot, ankius ma niit een. Abuat, anbibaꞌ-tuiꞌ, nfeen ma nnao goen. Ameen nui-atrokiꞌ, nareok ma nakniun een. Akosot, anneen anrair kuun een. Amates, anfeen ma nmoni mfain jen. Atoin kasian, anneen kuun Rais Reko. ");
INSERT INTO aaz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Onaim on nai: amnao nai, meu te mitonan naiꞌ Yohanis, in of napein in upan ma paꞌe karu in npirsai piut neu Kau. Natuin Uisneno of anfee tetus-athoen neu tuaf-tuaf reꞌ in pirsait ee neu Kau gui, naꞌkiiꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Oras naiꞌ Yohanis in atoup noinꞌ ein antebi nfanin on naan ate, Naiꞌ Yesus naꞌuab neu too mfaun ein anmatoom nok naiꞌ Yohanis am nak, “Oras hi mnao maim naiꞌ Yohanis anbi baer ruman naꞌroo naꞌko kuan on naan ate, hi mitenab mak, hi he miteef mok atoniꞌ human on reꞌ mee? Ka neu fa he hi mnao miteef mok atoin per-pero, on reꞌ aijooꞌ goan reꞌ ain ee nabeob ee natun-tuin aah! ");
INSERT INTO aaz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma ka neu fa he hi mnao mkius atoniꞌ reꞌ anpaek paek maꞌosaꞌ, fin tuaf on reꞌ naan, suma natua et sonaf! ");
INSERT INTO aaz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Onaim hi mnao mkius atoniꞌ human on reꞌ mee anbi bare naan? Hi mitenab am mak, hi mnao miteef mok mafefa kninuꞌ Uisneno? Batuur! Mes in reꞌ naan, mafefa kninuꞌ reꞌ maꞌtain reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Fin matuꞌi et Uisneno In Suur Akninuꞌ anmatoom nok naiꞌ Yohanis am nak, ‘Amneen! Au ꞌreek haef Au tuaf, he nnao nahuun ma nasoit enoꞌ ranan neu Ko.’ ");
INSERT INTO aaz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Amneen mirek-rekoꞌ! Anbi pah-pinan ia, ka tiit tain fa tuaf es, reꞌ maꞌtaniꞌ nneis naꞌko naiꞌ Yohanis. Mes naꞌko areꞌ mansian ein ok-okeꞌ reꞌ anmanakuꞌ Uisneno njair sin Usif, amunit baineis-neis ii msaꞌ maꞌtaniꞌ nneis naꞌko naiꞌ Yohanis. ");
INSERT INTO aaz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Anmurai naꞌko naiꞌ Yohanis nait in mepu tar antea oras ia, tuaf amfaun een antaam anjarin Uisneno Iin na. Mes anmuiꞌ bian natenab ansaan nak, sin ro he nmakenan he naꞌsekeꞌ biak ein he njarin Uisneno Iin na. ");
INSERT INTO aaz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Antea oras naiꞌ Yohanis Asranit in amneman, hit nonot atoniꞌ Yahudis biasa atmoin tatuin kaꞌo Musa ma mafefa kninuꞌ Uisneno sin atoorn ein. ");
INSERT INTO aaz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Onaim ampirsai meu Kau goah. Naiꞌ Yohanis naan, es reꞌ kaꞌo Elia reꞌ mafefa kninuꞌ Uisneno sin natoon nain in amneman. ");
INSERT INTO aaz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Onaim karu mroim he mihini te, mneen mirek-rekoꞌ! ");
INSERT INTO aaz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au he uꞌuab retaꞌ he hi bisa mihini mmak, mansian oras ia, mansian human on reꞌ mee. Fin sin reꞌ naan, nahuum on reꞌ riꞌaan ein reꞌ antok-tokon etan aꞌmasaꞌ. Sin anmahaamn ein es nok es am nak, ");
INSERT INTO aaz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hoe! Hai arkai amfuu bobe buꞌ-buaꞌ, mes hi ka mibsooꞌ ma mmarin-riin fa. Hai arkai amsii, siit kurut-kaet buꞌ-bua, mes hi ka msuus ma mkae fa.’ ");
INSERT INTO aaz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hi on reꞌ riꞌanaꞌ reꞌ ka nreen nahiin fa. Oras naiꞌ Yohanis neem, in nanaah on, ma ka nbukae fa tua min-kase. Mes atoniꞌ naꞌaakn ee mnak, ‘In nniut sae!’ ");
INSERT INTO aaz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mes oras ia, Au Mansian Batuur-Batuur reꞌ ia, Au ꞌuum aꞌrair. Au ka unaah Ok fa, ma Au ꞌiun tua min-kase. Mes atoniꞌ naꞌakan Kau mnak, ‘In reꞌ naan, mansian akomat ma aparuꞌ! Amauf raru! In nnao nkuaꞌnoon nok ahoik beo ngguin! Ankuaꞌnoon nok tuaf-tuaf reꞌ ka mapakeꞌ fa! Ka ntae nahiin fa in tuan!’ Mes hi mtanar kiim Au uabak reꞌ ia, hee! Uisneno In mahiin ee mamnitaꞌ anbi Iin na sin aꞌmoink ein.” ");
INSERT INTO aaz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Rarit Usif Yesus anmurai nakain kuan fauk sin too ngguin. In nmoꞌe nrair rais sanmakat maꞌtaniꞌ anbi baren reꞌ naan, mes sin ka nromin fa he nasaitan sin ꞌmoeꞌ saant ein, he ntebi nfanin ma natuin Uisneno In raan aꞌhonis amneot. ");
INSERT INTO aaz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naiꞌ Yesus nakain sin im nak, “Abitan Korasin ma Betsaidas sin! Ampaant om! Hi of mipein siraak! Au ꞌmoꞌe ꞌrair rais sanmakat humaꞌ-humaꞌ ꞌbi hi humam ma hi matam, mes hi ka mroim fa he mpirsai Uisneno. Te kaah, hi atoin Yahudis ki reꞌ ammanakuꞌ mak hi mihiin Uisneno. Mes karu rais sanmaakt ein reꞌ Au ꞌmoeꞌ sin aꞌbi hi kuan ein naan anjari nrarin anbin kota Tirus ma Sidon, onaim aꞌroo-ꞌroo te reꞌ ia abitan reꞌ nee, sin naꞌpisan nrarin, ma nasaitan sin saant am penu sin, rarit natuin Uisneno. Ma sin of anpaken tai-nukat amsaꞌ, ma antaon askukuꞌ anbi sin aꞌnaak ein he njarin tanar am nak, sin nmeiꞌ jok nok sin saant am penu sin. Te kaah, abitan Tirus ma Sidon naan, ka atoin Yahudis fa reꞌ anmanauk ein nak sin nahiin Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Batuur! Hi of miit kiim! Karu Uisneno nafeek areꞌ kanan mansian ein sin rasin, abitan Tirus ma Sidon sin napenin hukun maꞌkafaꞌ nneis naꞌko ki! ");
INSERT INTO aaz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hi abit Kapernaum! Ampaant om! Hi kais mitenab am mak, Uisneno naꞌratan ki mtaam meu sonaf neno tunan. Kaah fa, tua! Uisneno of nait inporin ki mtaam meu ai abar-barat! Bait rais sanmaakt ein reꞌ Au ꞌmoeꞌ sin aꞌbi hi kuan ein, anjair nahunun anbin kota Sodom, bait Uisneno ka nperluu fa he nareuꞌ niis kot maufinu naan. Fin karu abitan Sodom niit rais sanmaakt ein naan, bait sin nasaitan sin moeꞌ maufiun ein. ");
INSERT INTO aaz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Batuur! Hi of miit kiim! Karu Uisneno nafeek areꞌ kanan mansian ein sin rasin, abitan Sodom sin napenin hukun maꞌkafaꞌ nneis naꞌko ki!” ");
INSERT INTO aaz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naiꞌ Yesus naꞌuab anrair on naan ate, In nꞌonen am nak, “Amaꞌ Aꞌnaet et neno tunan ma pah-pinan. Au ꞌbaiseun ma usaeb makasi kouꞌ-koꞌu, natuin Ho mꞌekaꞌ rais huukn ein naan muꞌko Ho tuam aan meu tuaf-tuaf reꞌ annaben sin tuak ein ahiint ein, ma abeoꞌt ein. Mes Ho mꞌeut ma mutoon areꞌ kanan rasin naan meu atoin aꞌbaut ma atoin neek aꞌpaarn ein. ");
INSERT INTO aaz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Namneo, Aam! Fin rasin reꞌ naan anmoeꞌ Ho nekam naan anmariin, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Anꞌonen anrair on naan ate, Naiꞌ Yesus naꞌuab neu abitan reꞌ naan am nak, “Amneen mirek-rekoꞌ! Au Amaꞌ abit sonaf neno tunan, anfee nrair kuasa sin ok-okeꞌ neu Kau. Tuaf reꞌ nahiin Kau batuur-batuur ii, suma meseꞌ, es reꞌ Au Amaꞌ. Ma Tuaf reꞌ nahiin batuur-batuur Au Amaꞌ, suma Amaꞌ In Anah, es reꞌ Au reꞌ ia. Ma Au ꞌpiir tuaf bian sin he ꞌeut ma utoon ꞌeu sin, he sin nahiin narek-reokꞌ Ee. ");
INSERT INTO aaz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hi ar-arki reꞌ ammeup maꞌtaniꞌ ma mhae mmaet, iim nai he mituin Kau! Hi ar-arki reꞌ mroi ma misaah rais maꞌfenaꞌ, iim amꞌain Kau! ");
INSERT INTO aaz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Karu hi mtoup Au noniꞌ sin ma iim mituin Kau te, hit on reꞌ bijae luku nua reꞌ anheer hau luku noon es. Fin Au reꞌ ia, Au neek reko Kau, ma neek aꞌparan Kau. Karu hi mituin Kau te, hi miꞌbeꞌi mfain. ");
INSERT INTO aaz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Natuin Au noniꞌ naan, ka maꞌnukaꞌ ma susa fa. Ma Au prenat naan, ka maꞌfenaꞌ fa.” ");
INSERT INTO aaz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Neot es, nateef nok atoin Yahudis sin neno snasat, Naiꞌ Yesus nok In atoup noinꞌ ein annaon npeꞌon biak ein sin rene. In atoup noinꞌ ein namnahan, es naan ate sin nhetun maak-gandum in punin ma nahan oras sin nnaon. ");
INSERT INTO aaz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Anbi naan, anmuiꞌ naan tuaf fauk naꞌkon partei pirsait Farisi reꞌ annaaꞌ naher-heran harat Yahudi. Ankius nitan Naiꞌ Yesus In atoup noinꞌ ein anmoꞌen on naan ate, sin nakain Ee mnak, “Ho atoup noinꞌ ein anhetun maak-gandum nateef nok neno snasat! Kais on naan! Fin reꞌ naan antanhai nrair hit atoran.” ");
INSERT INTO aaz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Mes Naiꞌ Yesus nataah am nak, “On mee? Hi ka mimnau fa kaꞌo Daut in retaꞌ? Kaꞌo Daut nok iin na sin taik ein naꞌroton natuin sin namnahan nmaten. Onaim in ntaam neu Uisneno In Tenar Onen. Rarit in nait utunuꞌ reꞌ aꞌnaak pirsait ein anfee nrair sin neun Uisneno he sin nbukaen. Te kaah, utuun ein reꞌ naan suma aꞌnaak pirsait ein esan reꞌ nmuꞌin hak he nbukae sin. Aꞌtetaꞌ naꞌko naan ate, ka bole fa. Rarit kaꞌo Daut sin anbukaen, mes ka tiit fa tuaf es he nasaan sin. Hi on reꞌ ka mrees mihiin fa Uisneno In Suur Akninuꞌ! ");
INSERT INTO aaz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Fin anbi Suur Akninuꞌ naan, matuꞌi nmatoom nok aꞌnaak rais pirsait ein sin mepu, es reꞌ he ntuthaen anbin uim onen nateef nok neno snasat. Mes sin ka nsanan fa saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amneen! Unuꞌ feꞌ, uim onen ro pentiing, mes oras ia rais jes pentiing anneis. Es reꞌ Au, Mansian Batuur-Batuur reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anbi Suur Akninuꞌ, Uisneno naꞌuab am nak, ‘Au roimk ii on nai: Au ngguin ro he nakriraꞌ rais kasian, es nok es. Karu sin ka nmoꞌen fa on naan ate, sin muꞌi-ꞌturuꞌ reꞌ sin neik sin ma naꞌturuꞌ sin neun Kau naan, ka maꞌupan fa saaꞌ-saaꞌ.’ Onaim karu hi mihiin mirek-rekoꞌ Uisneno In Kabin ma Prenat naan ate, bait hi ka mikuu fa Au atoup noinꞌ ein mak sin nsanan. On nai te sin ka nsanan fa te! ");
INSERT INTO aaz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Fin Au reꞌ ia, Mansian Batuur-Batuur. Au ꞌmuiꞌ hak he ufeek ꞌak, mansian ii bole nmeup saaꞌ nateef nok neno snasat.” ");
INSERT INTO aaz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Rarit Naiꞌ Yesus annao nasaitan bare naan, he ntaam neu sin uim onen. ");
INSERT INTO aaz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anbi bare naan, atoin es in aꞌniman anmaet ao-biaf. Atoin Farisis sin namin ranan he nasaan Naiꞌ Yesus, kar-karu In narekoꞌ atoniꞌ naan nateef nok neno snasat. Rarit sin nataan Ee mnak, “Tatuin hit atoran rais pirsait, atoniꞌ bole narekoꞌ tuaf nateef nok neno snasat, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Rarit Naiꞌ Yesus nataah am nak, “Karu tuaf es in aꞌbib-kase es anmoufu ntaam anbi konaꞌ nateef nok neno snasat, ꞌbib-kase naan in tuan ee ro he napoitn ee, aiꞌ kaah? ");
INSERT INTO aaz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Onaim Uisneno anneek mansian, anneis naꞌko tuaf reꞌ anneek in aꞌbib-kase naan. Nok ranan naan, atoniꞌ bole nmoeꞌ rais reko nateef nok neno snasat.” ");
INSERT INTO aaz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onaim In naꞌuab neu atoniꞌ reꞌ in aꞌniman bian ee nmaet naan am nak, “Baꞌe! Amnonaꞌ ho ꞌnimam naan neem!” Rarit in nnonaꞌ in aꞌniman amates naan, onaim nareok nain oras naan, on reꞌ in aꞌniman bian. ");
INSERT INTO aaz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ankius nitan on naan ate, atoin Farisis sin nek-neuk nisik. Onaim sin nfeen annaon nasaitan uim onen naan. Sin nnao nmaꞌakoran am nak, “Hit ro he taim ranan he taꞌmaet Ee!” ");
INSERT INTO aaz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mes Naiꞌ Yesus nahiin sin reon maufinu naan, es naan ate, In nnao neu bare bian. Too mfaun ii natuin Ee, rarit In narekoꞌ ameent ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mes In ntaar sin im nak, “Hi kais mitoon meu tuaf bian anmatoom nok Kau.” ");
INSERT INTO aaz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","In nmoeꞌ on reꞌ naan, natuin saaꞌ reꞌ Uisneno natoon nain neu In mafefa kninuꞌ naiꞌ Yesaya mnak, ");
INSERT INTO aaz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Amkius miit! In reꞌ ia, Au tua renuꞌ tua rekaꞌ reꞌ Au ꞌpiir ꞌain Je. Au ꞌneek Ee, ma Au neek ii nmariin piut neu Ne. Au of aꞌfee ma ꞌnonaꞌ Au Smanak ꞌeu Ne, he In nnao nanoniꞌ mansian am tuaf et uuf am pah, anmatoom nok Au raan aꞌhonis amneot am amnonot. ");
INSERT INTO aaz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","In ka npaas fa In aꞌbasan. In ka naikas ma naꞌratan fa In tuan. ");
INSERT INTO aaz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In neekn ee reko. In ka nasusab fa es. Hau reꞌ he noi natꞌiup ma natriiꞌ, In ka nꞌiup goe fa. Pauk piin marak aanꞌ-anaꞌ, In ka nfukar niis ne fa. In nanoniꞌ piut, tar uuf am pah sin nahinin he natuin Uisneno In raan aꞌhonis amneot ma amnonot. ");
INSERT INTO aaz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mansian naꞌko uuf am pah of anpirsai Je, natuin sin nahinin nak, In reꞌ naan, sekau.” ");
INSERT INTO aaz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Neot es, anmuiꞌ tuaf neik neu Naiꞌ Yesus tuaf es, reꞌ anniut sae tar antea in nfoor ma nmuu nmaet. Onaim Naiꞌ Yesus nriuꞌ napoitan nitu naan, ma nareokꞌ ee. Rarit atoniꞌ naan bisa niit ma bisa naꞌuab oras naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ankius nitan on naan ate, too mfaun ein ansanmakan. Sin naꞌuab ein am nak, “Of oniꞌ In reꞌ ia, naiꞌ Daut in sufan, reꞌ mafefa kninuꞌ Uisneno sin antui nain je naꞌko afi unuꞌ. In reꞌ ia, oniꞌ Tuaf reꞌ hit tpa-pao!” ");
INSERT INTO aaz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mes oras atoin Farisis sin annenan on naan ate, sin ka ntoupun reko fa. Rarit sin naꞌuab ein am nak, “Hoe! Atoniꞌ reꞌ ia bisa nriuꞌ nitu, natuin nitu ꞌnakaf Balsebul es reꞌ anfee Ne kuasa.” ");
INSERT INTO aaz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mes Naiꞌ Yesus nahiin atoin Farisis sin uab ein naan. Onaim In natoon neu sin im nak, “Hi uab ein naan, tateenb ee te, ka nnao fa! Karu anbi pah es, in too gui anmabanan nmafan-faink ein, ka neu fa he pah reꞌ naan bisa nhaek nabar-baar. On naan amsaꞌ anbi kota es in nanan, aiꞌ anbi uim jes in nanan, es ankataas es, sin ro of anpeꞌen ma nbaits ok. ");
INSERT INTO aaz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Onaim karu niutn ein anmamusun ma anmariꞌun es nok es ate, sin aꞌnaakt ee ka bisa nnaaꞌ fa prenat naan aꞌroo. ");
INSERT INTO aaz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mimnau! Hi ngguin anriuꞌ nahinin nitu msaꞌ. Sin npaek kuasa naꞌko nitu, oo? Kahaf! Onaim hi kais miꞌuab tafiꞌ-tafiꞌ mmak, Au ꞌpaek nitu he ꞌriuꞌ kuasa naꞌko nitu. Hi ngguin kiim of esan reꞌ nafekan am nak, saaꞌ reꞌ hi mikukuꞌ sin meu Kau naan, ansaan. ");
INSERT INTO aaz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mes karu Au ꞌriuꞌ nitu ꞌpaek Uisneno In Asmaan ee In kuasan, naan nakriraꞌ nak, Uisneno naan, batuur-batuur Usif reꞌ anhake nrair et hi humam ma hi matam. ");
INSERT INTO aaz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Karu abaakt ii he ntaam nabaak anbi atoin maꞌtain es in umi, in ro he nfuut nahunun uim tuaf naan mates feꞌ. Rarit naꞌ in nait neik bareꞌ naꞌko umi naan. ");
INSERT INTO aaz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mimnau mirek-rekoꞌ. Tuaf reꞌ ka nkuaꞌnoon fa nok Kau, in reꞌ naan anmamuus nok Kau. Ma tuaf reꞌ ka nturun ma nbaab Kau fa nbi Au mepu, in reꞌ naan suma nareuꞌ goah. ");
INSERT INTO aaz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Onaim amneen mirek-rekoꞌ Au uabak reꞌ ia! Uisneno nabarab he nnoes nain mansian ein sin sanat. Ma karu atoniꞌ naꞌuab ka reko fa neu biak ein, Uisneno nabarab he nfee saok sanat neu ne. Mes karu anmuiꞌ tuaf nabrain he naꞌuab naꞌreꞌuf Uisneno In Asmaan Akninuꞌ, Uisneno ka nsaok nain fa in sanat naan. ");
INSERT INTO aaz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Karu atoniꞌ naꞌuab reꞌuf neu Kau, Mansian Batuur-Batuur reꞌ ia, Uisneno nabarab he nsaok nain in sanat. Mes karu atoniꞌ naꞌuab naꞌreꞌuf ma nraban Uisneno In Asmaan Akninuꞌ, Uisneno ka nsaok nain fa sanat naan tar antea nabar-baar amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Rarit Naiꞌ Yesus naꞌuab piut neu atoin Farisis sin im nak, “Mitenab mirek-rekoꞌ! Hau roet arekot, nafua fua reko. Mes hau reꞌuf, nafua fua reꞌuf. Fin, naꞌko roet ii in fuan, atoniꞌ bisa nahini mnak, hau roet naan reko, aiꞌ kaah. ");
INSERT INTO aaz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mes hi on reꞌ kaun aputa-kriut! Hi ka bisa miꞌuab fa rais reko. Natuin saaꞌ reꞌ et atoniꞌ in nekan, naan es reꞌ of anpoi npeoꞌ in fefan. ");
INSERT INTO aaz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atoin neek arekot, in of naꞌuab reko, natuin anmuiꞌ rais reko ma tenab reko et in nekan. Mes amaufinut, ro tebes naꞌuab maufinu, natuin anmuiꞌ rais maufinu et in nekan. ");
INSERT INTO aaz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ampirsai Kau! Oras pah-pinan ia namsoup, Uisneno anparikas mansian ein ok-okeꞌ sin rasin. Oras naan, es-es ate ro he nataah kuun in uaban reꞌ ka maꞌupan fa. ");
INSERT INTO aaz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Onaim ampaant om! Fin Uisneno of antai hi uab ein, ma nafeek am nak, hi mipein hukun, aiꞌ kaah.” ");
INSERT INTO aaz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Anneen Naiꞌ Yesus naꞌuab on naan ate, tunggur agama fauk ma atoin Farisis sin ntoit Je mnak, “Aam Tungguru! Hai mtoit he hai miit Ko mmoeꞌ rais sanmakat, he njair bukti mnak, Ho kuasam naan batuur-batuur amneemn ii naꞌko Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mes Naiꞌ Yesus naskarak sin im nak, “Hoe! Mansian oras ia ka nroim fa he nneen ma natniin Uisneno! Suma nahini haa he nmoꞌen kuuk maufinu! Maski hi mtoit rais sanmakat, mes Au ka ꞌmoeꞌ utuin ki fa. Natuin unuꞌ te, Uisneno nfee nrair rais sanmakat anpaek In mafefa kninuꞌ naiꞌ Yunus. Naan nanokab anrair! ");
INSERT INTO aaz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Naiꞌ Yunus natua neno teun ma fai teun anbi iik kouꞌ goes in tain. On naan amsaꞌ Au, Mansian Batuur-Batuur reꞌ ia. Au of utua neno teun ma fai tenu ꞌbi nua fatu, bare ꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Oras neon amsoput, Uisneno njair afeek rasi, abitan Niniwe sin nhaken njarin saksii he nakuu ki mnak, ‘Hi arki reꞌ ia, amonot!’ Unuꞌ te, abitan Niniwe sin nnenan ma natniin Uisneno In mafefa kninuꞌ naiꞌ Yunus, onaim sin naꞌpisan ma nasaitan sin saant am penu sin. Mes hi te, kahaf! Te kaah, oras ia, Tuaf reꞌ et hi tnaanm ein, maꞌtani nneis naꞌko naiꞌ Yunus. Tuaf reꞌ naan, es reꞌ Au reꞌ ia. Mes hi ka mroim fa he mfairoir Kau kreꞌo msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Oras neon amsoput, Uisneno njair afeek rasi, uis bifee bi Seba naꞌko pasaꞌ haaꞌ-nua, anhake njair saksii. In nakuu ki ar-arki reꞌ amonit oras ia mnak, ‘Hi ar-arki reꞌ ia, amonot!’ Unuꞌ te, uis bifee naan neem naꞌko bare ꞌroo-ꞌroo he niit nok in matan usif Soleman in mahinin. Te kaah, oras ia Tuaf reꞌ et hi tnaanm ein, maꞌtani nneis naꞌko usif Soleman. Tuaf reꞌ naan, es reꞌ Au reꞌ ia. Mes hi ka mroim fa he mfairoir Kau kreꞌo msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Karu niut gui nriuꞌ napoitn ee naꞌko tuaf es, nitu naan annao neu baer ruman he nasnaas. Mes in ka napein fa bare he natua. ");
INSERT INTO aaz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Onaim in natenab am nak, ‘Ahh! Au ka upein fa bare on nai te, reko nneis au ꞌfain he utua ꞌbi tuaf reꞌ neno na au utua gui.’ Rarit in ntebi nfain, onaim in niit bare naan nakninuꞌ nrair, ma ankikin narek-rekoꞌ nrair bare naan. ");
INSERT INTO aaz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Rarit nitu naan annao nhaman in partei ngguin tuaf hiut reꞌ maufinu nneis naꞌko ne. Onaim sin nnaon natuan nbin atoniꞌ naan, onaim sin nauban naan ee. Onaim oras ia, atoniꞌ naan in aꞌmoin ii nreꞌu nneis. On naan amsaꞌ anmatoom nok mansian oras ia.” ");
INSERT INTO aaz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Oras naan, Naiꞌ Yesus naꞌuab nok too mfaun ein feꞌ. Onaim In ainaf ma In oirf ein neman he nateef nok Ne. Sin nhaken nbin moneꞌ, ma nreun tuaf he noꞌen. ");
INSERT INTO aaz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Onaim anmuiꞌ tuaf neem natoon Ee mnak, “Aam! Ho ainaꞌ ma sin Ho oriꞌ etan moneꞌ. Sin he nateef nok Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rarit Naiꞌ Yesus nataah am nak, “Au ainaꞌ reꞌ batuur ii, sekau? Ma au orif-tataf reꞌ batuur ii, sekau?” ");
INSERT INTO aaz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Onaim In nruur neu too mfaun ein reꞌ natuin Ee, ma naꞌuab am nak, “Amkius kiim, sin ar-arsin reꞌ ia, Au ainaꞌ ma Au orif-tataf sin. ");
INSERT INTO aaz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Fin tuaf reꞌ nmoeꞌ natuin Au Amaꞌ abit sonaf neno tunan In romin, naan sin Au nonot-asar sin reꞌ batuur.” ");
INSERT INTO aaz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Neno naan, Naiꞌ Yesus anpoi nnao naꞌko umi naan he nnao ntoko nbi nefo Galilea in ninin. ");
INSERT INTO aaz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Onaim too mfaun ein neman ma naub naan Ee. Rarit In nsae ntoko nbi kofaꞌ es, reꞌ nhake nbi naan, he nanoniꞌ too mfaun. Abitan auf meot ee nnenan ma natniin Ee. ");
INSERT INTO aaz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Onaim In nanoniꞌ rasi mfaun neu sin, npaek retaꞌ. In naretaꞌ am nak, “Anmuiꞌ naan atoin tani es annao nꞌain in rene he nkaniꞌ fini. ");
INSERT INTO aaz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Oras in nkaniꞌ fini on naan ate, fini bian anmoufun nbin ranan. Onaim koorn ein neman ma nteon-nsiun nain finin naan okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mes fini bian anmoufun nbin auf mafatuꞌ. Finin naan natoron rabah, natuin afu naan mainihas. ");
INSERT INTO aaz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mes oras maans ee nsae on naan ate, fiin atoors ein naan namnenen ma nmeto nmaten. Fin sin aꞌbaaꞌk ein ka ntaman fa ntean auf goe ꞌpinan. ");
INSERT INTO aaz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fini bian anmoufun nbin huu maꞌaikaꞌ. Onaim huu maꞌaikaꞌ naan nakhapiꞌ naan sin tar antea finin naan anmaten. ");
INSERT INTO aaz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mes fini bian anmoufun nbin auf afaꞌ. Finin naan natoron, rarit anmonin, nasufan ma napunin. Bian nafuan no boꞌ teun, bian no boꞌ nee, ma bian no nautn es. ");
INSERT INTO aaz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sekau marukiꞌ, maut he nneen narek-rekoꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Rarit Naiꞌ Yesus In atoup noinꞌ ein neman ma nataan Ee mnak, “Nansaaꞌ am es Ho munoniꞌ too mfaun ein ate, ampaek retaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Onaim Naiꞌ Yesus nataah am nak, “Natuin hi mroim he mihiin batuur-batuur Uisneno In aprenat, es naan ate Au utoon ki retaꞌ naan in aꞌmoufun. Mes karu bian ate, Au unoniꞌ sin aꞌpaek retaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Fin atoniꞌ reꞌ he naim batuur-batuur neu Uisneno In romin, Uisneno of anmoeꞌ je nahini ntein. Mes atoniꞌ reꞌ ka ntoe natuin fa Uisneno In romin, Uisneno of anmoeꞌ je nmono nkoon. ");
INSERT INTO aaz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Au unoniꞌ sin aꞌpaek retaꞌ, natuin: ‘Sin nkisun ma nitan nrarin, mes sin ka nromin fa he nahinin. Sin nnenan ma natninan nrarin, mes sin ka nromin fa he nahinin.’ ");
INSERT INTO aaz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sin reꞌ naan on reꞌ mafefa kninuꞌ Uisneno naiꞌ Yesaya antui nain je mnak, ‘Hi of amneen ma mitniin, mes hi ka mroim fa he mihiin. Hi of amkius ma miit, mes hi ka mroim he mihiin fa saaꞌ reꞌ njair naan. ");
INSERT INTO aaz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Natuin tuaf ein reꞌ ia sin neek ein on fatu, sin nmoeꞌ sin ruik ein ankoson, sin nmoeꞌ sin maatk ein anforon. Onaim maut he sin on reꞌ naan, he sin ruik ein ankoson on reꞌ naan, mbain he on reꞌ naan, he sin maatk ein anforon on reꞌ naan. Maut he Au kais urekoꞌ sin, natuin sin ka nromin he ntoe natuin Kau fa.’ ");
INSERT INTO aaz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mes hi reꞌ ia, ro mipein paꞌe, joo! Fin hi miit kiim meik hi matam, ma mneen kiim meik hi rukim. ");
INSERT INTO aaz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ampirsai Kau! Afi unuꞌ mafefa kninuꞌ Uisneno, ma atoin neek amneoꞌn ein, anromin mat-maten he sin bisa niit saaꞌ-saaꞌ reꞌ hi miit sin, mes ka bisa fa. Sin anromin mat-maten amsaꞌ he nneen saaꞌ-saaꞌ reꞌ hi mneen sin, mes ka bisa fa.” ");
INSERT INTO aaz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Naꞌuab anrair on naan ate, Naiꞌ Yesus nak sin im nak, “Oras ia hi mneen retaꞌ naan in oten. ");
INSERT INTO aaz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Fini reꞌ anmoufun nbin ranan naan, nahuum on reꞌ tuaf reꞌ anneen Kabin ma Prenat anmatoom nok Uisneno In aprenat, mes in ka nahiin fa batuur-batuur. Rarit nitu ꞌnaakf ee neem ma nbakat naan Kabin ma Prenat naꞌko tuaf naan in nekan. ");
INSERT INTO aaz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fini reꞌ anmoufun nbin auf mafatuꞌ naan, nahuum on reꞌ tuaf reꞌ anneen Uisneno In Kabin ma Prenat, onaim in ntoup Goe nok neek marine. ");
INSERT INTO aaz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mes Uisneno In Kabin ma Prenat ka naꞌbaaꞌ fa. Es naan ate, ka mahikiꞌ-matunuꞌ ꞌroo fa nbi in nekan. Biak ein nasusab sin natuin sin ntoup Uisneno In Kabin ma Prenat on naan ate, in nafetin nain sin. ");
INSERT INTO aaz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma fini reꞌ anmoufun nbin huu maꞌaikaꞌ naan, nahuum on reꞌ tuaf reꞌ anneen Uisneno In Kabin ma Prenat. Mes in ntaisiub humaꞌ-humaꞌ nok in urusan he bisa nmoin nok ao-minaꞌ ma mamut. Onaim uruusn ein naan nsiuꞌ napoitan Uisneno In Kabin ma Prenat naꞌko in nekan, tar antea ka maꞌupan fa ntein. ");
INSERT INTO aaz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mes fini reꞌ anmoufun nbin auf afaꞌ, nahuum on reꞌ tuaf reꞌ ntakan in rukin he nneen ma natniin Uisneno In Kabin ma Prenat, ma natuin Uisneno In romin. Rarit in nmoeꞌ rais reko, nahuum on reꞌ fini reꞌ nasuuf ma nafua naan. Bian nafuan no boꞌ teun, bian no boꞌ nee, ma bian no nautn es.” ");
INSERT INTO aaz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Naiꞌ Yesus natoon antein retaꞌ es am nak, “Uisneno In aprenat nahuum on reꞌ atoin es ankaniꞌ fini nbi in rene. ");
INSERT INTO aaz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oras fai meisꞌokan on naan ate, pah ii ntupan nber-beran. Onaim amaufinut antaam, ma nkaniꞌ huu sufaꞌ anbi rene naan. ");
INSERT INTO aaz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Oras maak ee he napuin on naan ate, ameupt ein niit huun anmoin buꞌ-buaꞌ nok maak-gandum anbi naan. ");
INSERT INTO aaz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Rarit sin nnao natonan neu reen tuaf naan am nak, ‘Usiꞌ! Neon goes ii hit tkaniꞌ fiin reko tbi ho rene. Nansaaꞌ am es oras ia nmuiꞌ huun et reen je nanan?’ ");
INSERT INTO aaz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Usif naan nataah am nak, ‘Amaufiunt ee, in aꞌmoꞌen es reꞌ naan.’ Onaim in ameupt ein anfeen penit am nak, ‘Usiꞌ, hai mnao mtoof main huun ee, oo?’ ");
INSERT INTO aaz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mes in nataah am nak, ‘Kaisaꞌ! Natuin oras hi mtoof huun naan ate, hit maak ein of amfaik meik sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Anbain he sin nmonin nabu-buan tar antea oras he toun. Oras naan, naꞌ au utoon ꞌeu ameupt ein am ꞌak, “Hi mbubun mihunun huun naan. Rarit amfuut sin futu mes-meseꞌ, he mout sin. Namuni te, naꞌ ambubun maak-gandum arekot naꞌko rene naan, ma mait meik sin ma mitaam sin meu poꞌof.”’ ” ");
INSERT INTO aaz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Au uꞌuab aꞌteniꞌ retaꞌ es, he hi bisa mihiin, on mee mꞌes Uisneno njair Usif neu too mfaun. Iin na, nahunu te on reꞌ fua muis aan es, reꞌ atoniꞌ nseen ee nbi in poꞌon. ");
INSERT INTO aaz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maski fua musiꞌ naan aanꞌ-anaꞌ, mes karu nmoni te, in njair hau kouꞌ reuꞌf es anbi poꞌon naan in nanan. Tar antea areꞌ koro neman ma nakuun ein anbin in taek ein.” ");
INSERT INTO aaz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Naiꞌ Yesus naretaꞌ nteniꞌ mnak, “Uisneno Iin na, nahuum on reꞌ raur haef, reꞌ bifee jes nait je ma nseor goe nok uut sauk goes. Onaim uut maseroꞌ naan ansae, natuin raur haef aanꞌ-anaꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Naiꞌ Yesus nanoniꞌ too mfaun ein anpaek retaꞌ huma mfa-faun on naan. In uab ein ok-okeꞌ naan, suma npake haa retaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","In nanoniꞌ on naan he natuin saaꞌ reꞌ mafefa kninuꞌ Uisneno antui nain sin im nak, “Au of unoniꞌ too mfaun ein aꞌpaek retaꞌ. Au of utoon areꞌ kanan rasi reꞌ atoniꞌ ka nneen niit sin fa, anmurai naꞌko oras Uisneno nmoeꞌ pah-pinan tar antea oras ia.” ");
INSERT INTO aaz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Rarit Naiꞌ Yesus annao nasaitan too mfaun ein, ma ntebi nfain neu umi. Onaim In atoup noinꞌ ein neman he ntotin turun-babat neu Ne mnak, “Usiꞌ! Mutoon kai oten naꞌko retaꞌ anmatoom nok huun anbi reen je nanan feꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Onaim Naiꞌ Yesus nataah am nak, “Atoniꞌ reꞌ nkaniꞌ fiin rekon naan, es reꞌ Au, Mansian Batuur-Batuur reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma etu aiꞌ rene naan es reꞌ pah-pinan reꞌ ia. Fiin reok gui, es reꞌ tuaf-tuaf reꞌ antaman njarin Uisneno In nonot-asar sin. Ma huun naan, es reꞌ nitu ꞌnakaf nok iin na. ");
INSERT INTO aaz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Rarit amaufinut reꞌ neem ma nkaniꞌ huu sufaꞌ naan, es reꞌ nitu ꞌnakaf naan in neikn on. Oras amnonut naan, es reꞌ neon amsoput. Ameput reꞌ nonun naan, es reꞌ Uisneno In ameupt ein naꞌkon sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Oras neon amsoput, sin naꞌbuaꞌ naan huun ein naan ma nout niis sin. ");
INSERT INTO aaz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","On nai te Au, Mansian Batuur-Batuur reꞌ ia, Au of aꞌsonuꞌ ameput naꞌko sonaf neno tunan. Sin of annaon ma nbubun naan tuaf-tuaf reꞌ ka natuin fa Uisneno In aprenat. Ma sin nbubun naan reꞌ tuaf-tuaf reꞌ anfuriꞌ biak ein amsaꞌ, he sin kais natuin Uisneno In aprenat. ");
INSERT INTO aaz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sin of nait inporin amaufiunt ein ok-okeꞌ nꞌanin ai abar-barat, nahuum on reꞌ huun reꞌ npuut naan. Anbi bare naan, naꞌ sin nnaben niit susat ma nanaꞌrenat, ma kurut-kaet ka natfeek niit fa. ");
INSERT INTO aaz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mes tuaf-tuaf reꞌ anmoin nok amnonot ma amneot natuin Uisneno In romin, sin of natuan nok sin Aam Usif anbin sonaf neno tunan. Anbi bare naan, sin maask ein anpinan on reꞌ manas. Onaim tuaf-tuaf reꞌ he nahiin Kau, amtakan hi ruikm ein, ma mneen mirek-rekoꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Naiꞌ Yesus anfee ntein retaꞌ es am nak, “Tuaf reꞌ nroim he nahiin Uisneno In aprenat naan, nahuum on reꞌ atoniꞌ reꞌ nroim he napein kuun baer maꞌosaꞌ ꞌmaten, reꞌ atoniꞌ naꞌkoroꞌ nbi konaꞌ. Atoniꞌ naan neem ma nhain, onaim in napein bareꞌ naan, es naan ate, in nmariin anmaet. Rarit in nkuub nafaniꞌ bareꞌ naan. Onaim in ntebi nfain rabah, ma nnao naꞌsosaꞌ in aꞌmuiꞌn ein ok-okeꞌ. Rarit in nsoos afu pisaꞌ naan, he in npaar nain baer maꞌosaꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Naiꞌ Yesus naretaꞌ ntein am nak, “Tuaf reꞌ he nahiin Uisneno In aprenat naan, nahuum on reꞌ atoin arakan es, reꞌ anroim he nmuiꞌ mutiara reꞌ maꞌosaꞌ ꞌmaten. Rarit in naim mutiara naan he nsoos. ");
INSERT INTO aaz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oras in niit mutiara reꞌ reok reꞌuf on naan ate, in ntebi nfain rabah he naꞌsosaꞌ in aꞌmuiꞌk ein ok-okeꞌ. Rarit in nnao nsoos mutiara naan, maut he in npaar nain kuun mutiara naan.” ");
INSERT INTO aaz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Naiꞌ Yesus naretaꞌ ntein am nak, “Uisneno In aprenat, nahuum on reꞌ pukat es, reꞌ akiif kai ikaꞌ sin nasaunt ee neu nefo. Rarit pukat naan, naan ikaꞌ humaꞌ-humaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Oras pukat naan naheun nok ikaꞌ te, akiif kai ikaꞌ sin neman ma nheer napoitn ee, ma neik je neu niniꞌ. Rarit sin ntokon ma nsiun iikꞌ ein nbin pukat naan. Ikaꞌ mee reko te, sin nataam ee neu ꞌkoraꞌ. Mes ikaꞌ mee reꞌ ka reko fa te, sin nait inporin. ");
INSERT INTO aaz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","On naan amsaꞌ neon amsoput. Uisneno In ameupt ein of neman naꞌkon sonaf neno tunan, he nbetis amaufinut naꞌko atoin neek amneꞌo ma amnonot. ");
INSERT INTO aaz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sin of nait inporin amaufiunt ein ok-okeꞌ neun ai abar-barat. Anbi bare naan, naꞌ sin nnaben niit susat ma nanaꞌrenat maꞌtaniꞌ, ma kurut-kaet abar-barat.” ");
INSERT INTO aaz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naꞌuab anrair on naan ate, Naiꞌ Yesus nataan sin im nak, “Hi mihiin areꞌ saaꞌ-saaꞌ reꞌ feꞌe na Au uꞌuab sin, aiꞌ kaah?” Sin natahan am nak, “Hai mihiin sin, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rarit Naiꞌ Yesus nataah sin im nak, “Reko! Fin ansuun tuaf naꞌko tunggur agaam ein reꞌ batuur-batuur antoup noinꞌ ein naꞌkon Uisneno In Kabin ma Prenat reꞌ matuꞌi nain naꞌko afi unuꞌ, rarit in annaaꞌ naher-heran Au noniꞌ-taruꞌ sin amsaꞌ oras ia te, in nahuum on reꞌ uim tuaf es, reꞌ nasoit in poꞌof he nakriraꞌ in aꞌmuꞌin amnaaꞌ, nabu-bua nok in aꞌmuꞌin feꞌu.” ");
INSERT INTO aaz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Oras Naiꞌ Yesus nanoniꞌ nrair too mfaun ein anpaek retaꞌ on naan ate, In nnao nasaitan bare naan, ");
INSERT INTO aaz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","he nfain on In kuan Nasaret. Anbi naan, In ntaam anbi uim onen he nanoniꞌ too mfaun. Abitan uim onen sin ok-okeꞌ reꞌ anneen Ee, ansanmakan nmaten. Sin naꞌuab ein am nak, “Aih! Atoniꞌ ia In mahiin ii! In naskoor anbi mee? Anmoeꞌ on mee mꞌes in nmoeꞌ rais sanmaakt ein? ");
INSERT INTO aaz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Te kaah, In reꞌ ia atukan hau goe in anah. Hit tahiin tarek-rekoꞌ In ainaf bi Maria ma In oirf ein, esan reꞌ, nai Yakobus, naiꞌ Yusuf, naiꞌ Judas, ma naiꞌ Simon. ");
INSERT INTO aaz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hit tahiin In feotf ein imsaꞌ, te hit arkit tatua kuan meseꞌ. Onaim In napein In mahiin ii naꞌko mee ntein? Ma In napein In kuasa maꞌtaniꞌ naan naꞌko sekau ntein?” ");
INSERT INTO aaz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Es naan ate, sin nsaken ma ka nromi nteinꞌ ein fa he nneen ma natniin Ee. Mes Naiꞌ Yesus naꞌuab neu sin im nak, “Batuur! Anbi bare bian ate, biak ein anromin he nhormaat mafefa kninuꞌ Uisneno. Mes anbi in kuan aa kuun, ma in nonot-asar sin, atoniꞌ ka nromin fa he nhormaat ee.” ");
INSERT INTO aaz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","In ka nmoeꞌ fa rais sanmakat amfaun anbi bare naan, natuin sin neek ein on reꞌ fatu tar antea sin ka nromin fa he npirsain neun Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Oras naan, usif Herodes annaaꞌ aprenat anbi propinsi Galilea. In neen beno humaꞌ-humaꞌ anmatoom nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","In naꞌuab neu in haef-nimaf mapirsaꞌi sin im nak, “Naiꞌ Yesus naan, of oniꞌ naiꞌ Yohanis Asranit reꞌ neon goes ii au ꞌreek he nkeut naan in aꞌnakan. Oras ia, in nmoni nfani, oo? Es naan ate, in nmuiꞌ kuasa he nmoeꞌ rais sanmaakt ein on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Usif Herodes naꞌuab on naan, natuin unuꞌ te in nmakaꞌrasiꞌ nok naiꞌ Yohanis, tar antea in nheek naiꞌ Yohanis ma nataam ee neu bui. Rasi naan naꞌuu on nai: usif Herodes ansao naan in orif naiꞌ Felipus in fee, kaan ee bi Herodias. Te kaah, naiꞌ Felipus ma bi Herodias ka nmanpoirn ein fa. ");
INSERT INTO aaz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Etun naiꞌ Yohanis nakain usif Herodes fani-fani mnak, “Usiꞌ, ka nabeiꞌ fa he ho msao ho oriꞌ in fee. Natuin naan antanhai hit atoran harat Yahudi!” ");
INSERT INTO aaz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mes naiꞌ Herodes ka ntoe ma nrae natuin ee fa, onaim in nsao bi Herodias. Maski naiꞌ Herodes nroim he naꞌmaet naiꞌ Yohanis Asranit, mes in natiun gon nok too mfaun ein, natuin sin anpirsain am nak, naiꞌ Yohanis naan, Uisneno In mafefa kninuꞌ. Etun in nreun iin na he nataam naiꞌ Yohanis neu bui. ");
INSERT INTO aaz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mes aꞌroo-ꞌroo on naan ate, sin anmoꞌen fesat neu naiꞌ Herodes in neon mahonin. Oras naan, ain usif bi Herodias in aan feto, nabsooꞌ neu taumn ein. In nabsooꞌn ii reokn ii kah, tar antea naiꞌ Herodes in nekan naan anmariin anmaet. ");
INSERT INTO aaz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nabsoꞌo nrair on naan ate, naiꞌ Herodes noꞌen aan feto naan am nak, “Ho mtoit saaꞌ ate, mutoon! Au of aꞌfee ko. Au ꞌnaa au rais manbaꞌan reꞌ ia. Ma au ꞌsuup aꞌpaek Uisneno In kanan.” ");
INSERT INTO aaz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Anneen uisf ee naꞌuab on naan ate, aan feto naan in ainf ee naꞌseoꞌ goe. Onaim in ntoti mnak, “Usiꞌ! Au ꞌtoit naiꞌ Yohanis Asranit in aꞌnakan. Amtao maan ee neu dulang es, ma meik kau goe.” ");
INSERT INTO aaz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Anneen riꞌ feto naan antoit on naan ate, naiꞌ Herodes in teenb ee naen namneuk. Mes in ka bisa nheer nafaniꞌ fa in rais supat, fin taumn ein ok-okeꞌ annenan nrarin ate. Etun in natuin riꞌ feto naan in haan totis. ");
INSERT INTO aaz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Onaim in naprenat tuaf he nnao nkeut naiꞌ Yohanis in aꞌnakan anbi bui. ");
INSERT INTO aaz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sin nkeut naan naiꞌ Yohanis in aꞌnakan, rarit antao goe nbi dulang ma neik je neu riꞌ feto naan. In ntoup naan dulang naan, ma neik je neu in ainaf. ");
INSERT INTO aaz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oras naiꞌ Yohanis in atoup noinꞌ ein annenan nak sin nketu nrair in aꞌnakan on naan ate, sin neman ma nait in aon amates, ma nnaon nsuub ee. Rarit sin nnao natonan Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Oras Naiꞌ Yesus anneen beno anmatoom nok naiꞌ Yohanis in aꞌmaten on naan ate, In nok In atoup noinꞌ ein nasaitan bare naan. Onaim sin nsaen kofaꞌ he nnaon neun baer ruman naꞌroo naꞌko kuan he sin bisa nasnasan. Mes oras too mfaun ein nitan Naiꞌ Yesus sin kofaꞌ, sin natun-tuin ein npeꞌon neof goe ninin. Rarit sin npoi neman naꞌkon kuan-kuan ein, ma nnaon rabah anpeꞌon raan metoꞌ. Etun sin ntean nahunun Naiꞌ Yesus sin. ");
INSERT INTO aaz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Oras In nsaun naꞌko kofaꞌ naan, In niit too mfaun ein anpa-pao nain Je. Rarit In nkasian sin. Onaim In narekoꞌ areꞌ ameent ein. ");
INSERT INTO aaz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Oras maans ee he noi nmouf on naan ate, In atoup noinꞌ ein neman ma naꞌuab neu Ne mnak, “Usiꞌ! Reko nneis Ho mreun too mfaun ein ia he sin nfanin nsosan amnahat neun areꞌ kua paumaak ein. Fin maans ee he noi nmouf goen! Anbi bare ia ka tiit fa mnahat.” ");
INSERT INTO aaz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mes Naiꞌ Yesus nataah sin im nak, “Kaisaꞌ! Ro hi es reꞌ amtuthae sin.” ");
INSERT INTO aaz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mes sin natahan am nak, “Koeh Usiꞌ! Hai ka mmuiꞌ fa saaꞌ-saaꞌ he mtuthae too mfa-faun ein reꞌ ia. Hai he mmoeꞌ on mee? Hit muꞌi haa utunuꞌ fuaꞌ niim ma ikaꞌ fuaꞌ nua!” ");
INSERT INTO aaz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mes Naiꞌ Yesus naꞌuab am nak, “Reko. Meik sin neman!” ");
INSERT INTO aaz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Onaim In nreun too mfaun ein naan ntokon pukan-pukan anbin huun. Rarit In nait utunuꞌ fuaꞌ niim, ma ikaꞌ fuaꞌ nua. Onaim In nbaiseun neon goe ma ntoit makasi neu Uisneno. Rarit In nteib utuun ein naan ma nbatin nfeen In atoup noinꞌ ein, ma sin nnaon ntuthae too mfaun ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Rarit sin nbukaen buꞌ-buaꞌ tar namsenan. Anbukae nrarin on naan ate, sin nbubun nafaniꞌ amnaah neisf ein, naheun aꞌkoraꞌ boꞌes am nua. ");
INSERT INTO aaz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Too mfaun ein reꞌ nbukaen reꞌ naan, sin of oniꞌ nifun niim. Naan ansoiꞌ naan ahaa atoin ein nmesen. Bifee ma riꞌanaꞌ ka nsoiꞌ naan sin fa. ");
INSERT INTO aaz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sin arsin anbukaen nrarin on naan ate, Naiꞌ Yesus anreun In atoup noinꞌ ein nsaen kofaꞌ ma nnao nahunun neun neof goe panin. Mes In namaikaꞌ nbi bare naan feꞌ, he nreun too mfaun ein anfanin. ");
INSERT INTO aaz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Oras too mfaun ein anfanin on naan ate, Naiꞌ Yesus neiki nsae nbi ꞌtoeꞌf es he nꞌonen. Antea oras fai ji msaꞌ, In nbi naan anmees feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Oras naan, In atoup noinꞌ ein reꞌ anbin kofaꞌ antea nrarin neof goe tnanan. Sin nhae nmaten nok he nfoeꞌ kofaꞌ naan, natuin kofaꞌ naan nnao nbaniꞌ nꞌain anin, ma oik kouꞌ gui anbeson sin. ");
INSERT INTO aaz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Neis noi nmeu on naan ate, Naiꞌ Yesus natuin sin. In nnao nbi oe je fafon. ");
INSERT INTO aaz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ankius nitan on naan ate, In atoup noinꞌ ein naskeken ma naꞌtaiꞌ jein. Sin naꞌuab ein nok amtaus am nak, “Hoe! Akaꞌtaus ee natuin kit!” ");
INSERT INTO aaz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mes Naiꞌ Yesus naꞌuab neu sin im nak, “Hae! Hi kais mimtau. Au es reꞌ ia. Au naiꞌ Yesus Kau! Amhaꞌtain jom!” ");
INSERT INTO aaz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Anneen on naan ate, naiꞌ Petrus nataah am nak, “Usiꞌ! Karu batuur on naan ate, amreun kau ꞌnao ꞌbi oe ji fafon, he ꞌeit iꞌain Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Rarit Naiꞌ Yesus nataah am nak, “Reko! Uum nai!” Onaim naiꞌ Petrus anpoi naꞌko kofaꞌ he nnao nꞌain Naiꞌ Yesus. Naiꞌ Petrus annao nbi oe je fafon. ");
INSERT INTO aaz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mes oras naiꞌ Petrus annaben ain koꞌu on naan ate, in namtau nmaet. Onaim in nmurai nreem antaam on naan ate, in nkoaꞌ naheer am nak, “Koe Usiꞌ! Amturun maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Naiꞌ Yesus annonaꞌ In aꞌniman rabah ma nnaaꞌ naiꞌ Petrus. In naꞌuab am nak, “Peꞌu, Peꞌu! Nansaaꞌ am es ho neek maan nabait? Ho ka mpirsai fa meu Kau batuur-batuur, aa oo?” ");
INSERT INTO aaz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Rarit sin nua sin antaman neun kofaꞌ naan. Onaim anin naan nasnaas nain. ");
INSERT INTO aaz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ankius nitan on naan ate, In atoup noinꞌ ein naiks Ee mnak, “Usiꞌ! Ho ro batuur-batuur Uisneno In Anah!” ");
INSERT INTO aaz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oras sin ntean neof goe panin, sin nsanun nbin neof goe ninin, nbin kuan Genesaret. ");
INSERT INTO aaz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Oras sin nsaun neman on naan ate, too mfaun ein nahiin nain sin. Onaim sin nkoaꞌ ein am nak, “Hoe, Naiꞌ Yesus neem!” Sin naen anfuun kuan on naan ma nmaktoon ein. Sin neem neikin ameent ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sin ntotin he reko te, sin nreoꞌ naan ahaa In baru. Fin sin nateenb ein am nak, “Asar ameent ein anreoꞌ naan ahaa Naiꞌ Yesus In baur goe, sin of nareok nanin.” Onaim ameent ein ok-okeꞌ reꞌ anreoꞌ naan ahaa In baru, sin nareok nanin oras naan. ");
INSERT INTO aaz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Neot es, pukan atoin Farisis sin nok tunggur agaam ein neman naꞌkon Yerusalem he nateef nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Atoin Farisis sin annaaꞌ naher-heran atoran harat Yahudi. Oras sin nnenan am nak, Naiꞌ Yesus In atoup noinꞌ ein nbukaen mes ka nafaun fa sin aꞌniimk ein natuin sin haart ii in roim naan on naan ate, sin nsaken. Rarit sin neman he nasaan Naiꞌ Yesus am nak, “Nansaaꞌ am es Ho atoup noinꞌ ein nahan ate, ka nafaun fa sin aꞌniimk ein feꞌ natuin haart ii in romin? Naan antanhai hit atoran beꞌi-naꞌi sin harat!” ");
INSERT INTO aaz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mes Naiꞌ Yesus nataah sin im nak, “Hi arki reꞌ ia, ro tuaf reꞌ naꞌuab ate, aꞌtetaꞌ, ma nmoꞌe te, aꞌtetaꞌ. Hi mraban mihiin Uisneno In aprenat, he mituin hi beꞌi-naꞌi sin haart aa kuuk. ");
INSERT INTO aaz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Fin Uisneno naprenat anrari mnak, ‘Amhormaat hi ainaꞌ-amaꞌ sin.’ Antuta ntein am nak, ‘Karu tuaf es nasekuꞌ in ainaf aiꞌ in amaf, ro he napein hukun aꞌmaten.’ ");
INSERT INTO aaz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Uisneno nanoniꞌ on naan, mes hi minoniꞌ ꞌtetaꞌ ntein. Fin hi mak, ‘Tuaf es ka nperluu fa he npaek in bareꞌ he nturun ma nbaab in ainaf-amaf, maski sin nhaꞌmuiꞌ jok, karu in nbaꞌan anrair he nfee je neu Uisneno.’ Mes nok ranan hi minoniꞌ on naan, hi mporin main Uisneno In aprenat, ma mseun ee nok hi atoran. ");
INSERT INTO aaz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Etun feꞌe na Au ꞌak, hi reꞌ ia atoniꞌ reꞌ naꞌuab ate, aꞌtetaꞌ, ma nmoꞌe te, aꞌtetaꞌ! Naan natai nok saaꞌ reꞌ mafefa kninuꞌ Uisneno naiꞌ Yesaya antui nain je anmatoom nok ki naꞌko un-unuꞌ! Fin Uisneno npaek je he ntui mnak, ");
INSERT INTO aaz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Anmuiꞌ mansian anpures ma nboꞌis Kau, suma neik in rurun kotin, mes ka naꞌko fa in nekan. ");
INSERT INTO aaz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maski sin nmoꞌen on naan amsaꞌ, parsuum aah. Sin ka ntoe ma nrae natuin Kau fa, fin sin suma ntoe ma nrae natuin mansian ii in atoran.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Rarit Naiꞌ Yesus noꞌen tuaf bian anbi bare naan ma nanoniꞌ sin im nak, “Amtakan hi ruikm ein he mneen mirek-rekoꞌ, he hi bisa mihiin! ");
INSERT INTO aaz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saaꞌ reꞌ ntaam neu atoniꞌ in fefan, naan ka nhaiꞌniis je fa. Mes saaꞌ reꞌ npoi naꞌko atoniꞌ in fefan, naan es reꞌ anhaiꞌniis je.” ");
INSERT INTO aaz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Rarit Naiꞌ Yesus In atoup noinꞌ ein neman ma natoon Ee mnak, “Usiꞌ! Ho muhiin ii, oo? Atoin Farisis sin neek ein namenan, oras Ho muꞌuab on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mes Naiꞌ Yesus nataah am nak, “Au Amaꞌ et sonaf neno tunan of anfaki nporin tuaf-tuaf reꞌ ka nanoniꞌ fa natuin In romin. Naan nahuum on reꞌ atoniꞌ ntoof anporin roet reꞌ in ka roim je fa. ");
INSERT INTO aaz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Onaim kais amtoe mituin atoin Farisis sin. Fin sin reꞌ naan, nahuum on reꞌ aforot reꞌ nakriraꞌ ranan neu aforot. Sin of anroron kbuaꞌ meseꞌ neun konaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Rarit naiꞌ Petrus naꞌuab am nak, “Usiꞌ, amturun he mutoon maan kai uab manporin feꞌe na in aꞌmoufun.” ");
INSERT INTO aaz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naiꞌ Yesus nataah sin im nak, “On nai te, hi ka mihiin fa feꞌe msaꞌ? ");
INSERT INTO aaz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","In sairt ii on nai: saaꞌ reꞌ hit tbukae je, ntaam anpeoꞌ hit fefak, rarit antaam ankoon neu hit taik, ma npoi nfani npeoꞌ baer porin makrafuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mes saaꞌ reꞌ anpoi nfain naꞌko hit fefak, naan es reꞌ anhaiꞌniis atoniꞌ, tar antea Uisneno nmaiꞌniisn ee msaꞌ, ma ka nroim fa he ntoup goe. ");
INSERT INTO aaz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Fin rais maufinu mfaun npoin naꞌkon atoniꞌ in nekan! Nahuum on reꞌ: tenab maufinu, marorot, makaket, nbeon on nok tuaf reꞌ in ka fee je fa, aiꞌ in ka moen ja fa, bakan, saksii puta-kriut, naꞌuab naꞌreꞌuf es in kanan. ");
INSERT INTO aaz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rasin on reꞌ naan, esan reꞌ anhaiꞌniis atoniꞌ. Mes karu atoniꞌ suma nbukae ma ka nafaun fa in aꞌniman natuin harat on naan ate, naan ka ntaam fa rais jes.” ");
INSERT INTO aaz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Rarit Naiꞌ Yesus annao nasaitan bare naan, he nnao neu pah reꞌ anpaumaak kota Tirus ma kota Sidon. ");
INSERT INTO aaz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Anbi naan, anmuiꞌ naan bifee jes, reꞌ naꞌko bare naan. In ka atoin Yahudis fa. Oras in nneen nak Naiꞌ Yesus neem antea goen, in neem antoit nok neek akbubuꞌ mnak, “Usif naiꞌ Daut in sufan! Amkasian maan kau, tua! Au aan feot goe, anniut sae. Airoo, in nhaꞌmuiꞌ niis on, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mes Naiꞌ Yesus antaaꞌ kuun, ma ka nataah fa hanaꞌ meseꞌ msaꞌ. Onaim In atoup noinꞌ ein neman ma natonan am nak, “Usiꞌ, bifee reꞌ ia naꞌrotoꞌ piut. Onaim in nmoꞌe haa taisibu. Reko nneis, Ho mreun goe he nnao nai naꞌko bare ia!” ");
INSERT INTO aaz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Onaim Naiꞌ Yesus nataah am nak, “Uisneno nreun Kau he ꞌuum aꞌturun hit atoin Yahudis, natuin sin nteri nsaan ranan, nahuum on reꞌ ꞌbib-kaes aseket. In ka nreun Kau fa he ꞌturun atoin sonaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mes bifee naan neem antein ma npaumaak Naiꞌ Yesus. In nriꞌtuu ma nbaisenu ntein am nak, “Usiꞌ! Amturun maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mes Naiꞌ Yesus anfee uab manporin am nak, “Ka neu fa he tait imnahat naꞌko riꞌaan ein, ma ntokar atfeen asun.” Nok sarit maꞌnifaꞌ nak, Naiꞌ Yesus ro he nturun In atoin Yahudis sin feꞌ, rarit naꞌ anturun biak ein. ");
INSERT INTO aaz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mes bifee naan anbaras am nak, “Batuur, Usiꞌ! Mes ausn ein anpa-paon etan mei je nupun. Sin nahan saaꞌ reꞌ anmoufun naꞌkon riꞌaan ein sin aꞌpiik ein amsaꞌ.” Nok sarit nak, oras riꞌaan ein nbukaen, ausn ein nahan amsaꞌ. Maski Naiꞌ Yesus anturun Iin na, mes In ro he nkius biak ein imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Anneen on naan ate, Naiꞌ Yesus naꞌuab am nak, “Reko, ain! Ho mpirsai Kau batuur, oo! Onaim ho mfain nai, natuin saaꞌ reꞌ ho mtoit je naan, anjari nrair!” Rarit in ntebi nfain, ma in niit in anah naan nareko nrair oras naan. ");
INSERT INTO aaz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein nnaon nasaitan bare naan, ma sin nnaon npeꞌ-peoꞌn ahaa nefo Galilea in ninin. Onaim sin nsaen neun ꞌtoeꞌf es, rarit Naiꞌ Yesus antook he nanoniꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Rarit too mfaun ein neman neu Ne. Sin neik ein atoin hae heraꞌ, aforot, abuat, amuut, ma amenat bian sin amsaꞌ. Sin natupaꞌ ameent ein naan anpaumak-maak Naiꞌ Yesus In haek ein. Rarit In narekoꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ankius nitan on naan ate, too mfaun ein ansanmakan. Sin naꞌuab ein am nak, “Hae! Maꞌtain besi! Atoin hae heraꞌ, bisa nnao reko. Aforot, bisa niit. Abuat bisa nfeen ma nnao. Ma amuut ii, naꞌuab! Ia ro tebes Uisneno es reꞌ ameput. In reꞌ naan, Uisneno reꞌ hit beꞌi-naꞌi sin naꞌruir ein ma naꞌbesan naꞌko afi unuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Neno fauk ankono te, Naiꞌ Yesus noꞌen In atoup noinꞌ ein am nak, “Au ꞌkasian too mfaun ein ia. Bian neman naꞌkon bare ꞌroo-ꞌroo, ma sin nabuan nbin ia neno teun goen, tar antea nararin betiꞌ. Reko nneis sin kais anfanin nok tai ruman. Kais-kaisaꞌ sin ntuamafun nbin raan atnanaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mes Naiꞌ Yesus In atoup noinꞌ ein natahan am nak, “Usiꞌ! Baer ruman ia naꞌroo naꞌko kuan. Ka neu fa he hit ttuthae too mfa-faun ein ia.” ");
INSERT INTO aaz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mes Naiꞌ Yesus nataan sin im nak, “Hi utuun ein fuaꞌ fauk?” Sin natahan am nak, “Fuaꞌ hiut goah. Ma iikꞌ ein fuaꞌ fauk aah, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Rarit Naiꞌ Yesus anreun too mfaun ein naan he ntokon neun afu. ");
INSERT INTO aaz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Onaim In nait utuun fua hiut ein ma iikꞌ ein naan, ma ntoit makasi neu Uisneno. Rarit In nteib sin, ma In nnonaꞌ sin neun In atoup noinꞌ ein, he sin nnaon ntuthae too mfaun ein naan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Onaim sin nbukaen tar namsenan. Rarit sin nbubun nafaniꞌ mnaah neis fein naan, ma npaan sin nahenu ꞌponi hiut. ");
INSERT INTO aaz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Too mfaun ein reꞌ nbukaen ok-okeꞌ naan, of oniꞌ sin atoniꞌ nifun haa. Sin ka nsoiꞌ naan fa bifee ma riꞌaan ein. ");
INSERT INTO aaz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Rarit Naiꞌ Yesus anreun too mfaun ein naan he nfanin. Onaim In nsae kofaꞌ ma sin nnaon neun pah Magadan. ");
INSERT INTO aaz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Neot es, atoin Farisis ma atoin Sadukis fauk neman neun Naiꞌ Yesus. Sin he nataan Ee, he nakreo. Nok ranan naan, sin ntoit Je mnak, “Aam! Ho mukriraꞌ miit rais sanmakat es, he njair bukti mnak, Ho mupein kuasa muꞌko Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mes Naiꞌ Yesus nataah am nak, “Karu maans ee nmouf ma neon goe snaa meꞌe, hi mtanar am mak, ‘Nokaꞌ te ka naꞌuur fa.’ ");
INSERT INTO aaz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma karu maans ee nsae ma anbi neon goe nmuiꞌ noep maꞌfenaꞌ, hi mtanar am mak, ‘Neno ia of naꞌuur.’ Onaim karu hi bisa mihiin oras on naan ate, nansaaꞌ am es hi ka mihiin fa tanar naꞌko oras neu oras, batan neu batan? ");
INSERT INTO aaz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Airoo! Hi mansian oras ia, suma mihini haa he mmoeꞌ rais maufinu! Hi ka mtae mituin fa hit Usiꞌ! Maski hi mtoit rais sanmakat, mes Au ka ꞌmoeꞌ je fa, tua! Natuin afi unuꞌ Uisneno nfee nrair rais sanmakat npaek mafefa kninuꞌ naiꞌ Yunus. Onaim naan, nanokab!” Naꞌuab anrair on naan ate, Naiꞌ Yesus nasaitan sin. ");
INSERT INTO aaz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Oras Naiꞌ Yesus sin annaon neun neof goe panin, naꞌ In atoup noinꞌ ein namnaun am nak, sin nniikn ein ma ka neikin fa utunuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Anneen neu sin naꞌuab ein on naan ate, In nak sin im nak, “Hi ro he mpaant om miꞌko atoin Farisis ma Sadukis sin raur haef ee, joo.” ");
INSERT INTO aaz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Annenan on naan ate, In atoup noinꞌ ein antakaꞌnaan ein. Onaim sin naꞌuab ein es nok es am nak, “Aꞌnaef ee naꞌuab saaꞌ? In naꞌuab on reꞌ ne, natuin hit ka teik fa utunuꞌ, aa oo?” ");
INSERT INTO aaz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mes Naiꞌ Yesus nahiin sin tenab. Rarit In naꞌuab am nak, “Hi bainesiꞌ ki! Nansaaꞌ am es hi miꞌuab anmatoom nok utunuꞌ? Hi ka mpirsai kau fa, oo? ");
INSERT INTO aaz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ro hi ka mihiin fa feꞌ neu Au ꞌmuiꞌ kuasa? Fin neon goes ii, Au ꞌteib utunuꞌ fuaꞌ niim ma ꞌtuthae tuaf nifun niim, hi mbubun mifaniꞌ mnaah neis fein aꞌkoraꞌ fauk? ");
INSERT INTO aaz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rarit, on mee nok reꞌ utuun fua hiut ein reꞌ Au ꞌbati ꞌfee ꞌeu tuaf nifun haa? Hi mbubun mifaniꞌ mnaah neis fein ꞌponi fauk? ");
INSERT INTO aaz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nansaaꞌ am es hi ka mihiin fa Au uabak feꞌe na? Au ka uꞌuab fa anmatoom nok utunuꞌ. Au he umnaub ki, he hi mpaant om miꞌko atoin Farisis ma Sadukis sin noniꞌ-taruꞌ sin. Fin sin noniꞌ-taruꞌ sin bisa npengaru naan too mfaun ein, nahuum on reꞌ raur haef reꞌ nkuum naꞌbuaꞌ ee nok uut, rarit uut naan ansae.” ");
INSERT INTO aaz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naiꞌ Yesus naꞌuab on naan ate, naꞌ sin nahinin nak, In ka naꞌuab fa anmatoom nok utunuꞌ. Mes In naꞌuab anmatoom nok atoin Farisis ma Sadukis sin noniꞌ-taruꞌ reꞌ anbeon ma nsanan. ");
INSERT INTO aaz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Rarit Naiꞌ Yesus annao neu bare reꞌ npaumaak kota Kaisarea Filipi. Anbi raan atnanaꞌ, In nataan sin im nak, “Tatuin biak ein sin uab ein nak, Au reꞌ ia, Mansian Batuur-Batuur reꞌ ia, Au sekau Kau?” ");
INSERT INTO aaz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sin natahan am nak, “Bian nak, Ho reꞌ ia, naiꞌ Yohanis Asranit reꞌ anmoni nfain. Bian nak, of oniꞌ Ho reꞌ ia, kaꞌo Elia. Bian anteniꞌ nak, kaꞌo Yermias. Karu kaah fa te, mafefa kninuꞌ Uisneno tuaf es naꞌko un-unuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Rarit Naiꞌ Yesus nataan antein sin im nak, “Karu anbi hi teenb ein kiim ate, Au sekau Kau?” ");
INSERT INTO aaz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rarit naiꞌ Simon Petrus nataah am nak, “Usiꞌ! Ho reꞌ ia, Kristus, Tuaf reꞌ afi unuꞌ Uisneno anbaꞌan he nsoun Ee neem! Ma Usiꞌ! Ho reꞌ ia, Uisneno abar-barat In Anah!” ");
INSERT INTO aaz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Rarit Naiꞌ Yesus naꞌuab am nak, “Simon, naiꞌ Yunus in aan moen ja ko! Ho mapaeꞌ reko ko! Ka mansian aa fa es reꞌ natoon ko rasi naan. Mes Au Amaꞌ et sonaf neno tunan es reꞌ natoon ko. ");
INSERT INTO aaz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amneen! Oras ia, Au he ukanab ko ‘Petrus’. Fin kanaf naan in aꞌmoufn ii es reꞌ ‘fatu’. Natuin ho pirsait aan nahuum on reꞌ fatu, ho of amjair fanderen meu Au ngguin reꞌ npirsai Kau. Maski sin napenin haꞌmuꞌit tar antea nmaten amsaꞌ, sin naarn ein ma ntaah ein piut-piut. ");
INSERT INTO aaz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Au of aꞌfee hak ꞌeu ko, he ho mꞌurus Au ngguin, nahuum on reꞌ ho mnaaꞌ aꞌretu ꞌfoꞌe sonaf neno tunan. Fin saaꞌ reꞌ ho mtaar ee mbi pah-pinan, naan Uisneno ntaar ee et sonaf neno tunan amsaꞌ. Ma saaꞌ reꞌ ho mfei ma mkonan ambi pah-pinan ia, naan Uisneno of nafeitn ee et sonaf neno tunan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naꞌuab anrair on naan ate, Naiꞌ Yesus antaar sin he kais natonan neu sekau-sekau nak, In reꞌ naan, Kristus. ");
INSERT INTO aaz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Anmurai naꞌko oras naan, Naiꞌ Yesus natoon neu In atoup noinꞌ ein am nak, “Au ro he ꞌnao ꞌeu kota Yerusalem. Anbi nee, Au upein haꞌmuꞌit amfaun naꞌko atoni mnais haart ein, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma tunggur agaam ein ok-okeꞌ. Sin of anroor naꞌmaet Kau, mes anmeu te, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naiꞌ Yesus natoon on naan ate, naiꞌ Petrus anheer napaisb Ee, rarit in nak, “Kais muꞌuab on naan, Usiꞌ! Ka neu fa he Uisneno nkonan rasi naan!” ");
INSERT INTO aaz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mes naiꞌ Petrus in uaban naan, ka natuik-natai fa nok Uisneno In romin. Es naan ate, Naiꞌ Yesus nabaniꞌ ma nakain ee mnak, “Hoe, muꞌroo muꞌko ia! Naan nitu ꞌnakaf es reꞌ aꞌuab! Ho kais amꞌekaꞌ Kau! Ho suma mutenab mutuin mansian ii in romin kuun, mes ka mutuin fa Uisneno In romin!” ");
INSERT INTO aaz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Rarit Naiꞌ Yesus nanoniꞌ In atoup noinꞌ ein am nak, “Tuaf reꞌ he natuin Kau, in ro he naran ma ntahan piut ansuun oras! In ro he nnikan nain in roimn aa kuun, he natuin Uisneno In romin. Maski atoniꞌ he nroor naꞌmaet je msaꞌ, in ro he natuin piut, nahuum on reꞌ atoniꞌ nasaah hau nehe, he nnao nꞌain bare ꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Fin tuaf reꞌ nabarab in tuan ee, he nmaet natuin in natuinaꞌ Kau, in of napeni ꞌhonis piut nok Uisneno. Mes tuaf reꞌ suma nroim he nmoni nbi in tuan ee kuun, in aꞌmonin naan of namsaab ma namneuk on ahaa reꞌ naan! ");
INSERT INTO aaz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amneen! Karu ho mupein pah-pinan ia in afan sin ok-okeꞌ, mes Uisneno antorak napoitan ko te, in upan ma in paeꞌ ji saaꞌ? Maski ho mroi meik main pah-pinan ia in afan sin imsaꞌ, ho ka bisa fa he mtuik ma msenuꞌ maan fa ho smanam! ");
INSERT INTO aaz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au utoon ki rasin reꞌ ia ok-okeꞌ, natuin Au reꞌ ia, Mansian Batuur-Batuur. Au of aꞌsanu ꞌfain ꞌuum aꞌpaek Au Amaꞌ In pinan ma krahan, ubu-bua ꞌok In ameupt ein naꞌkon sonaf neno tunan. Oras naan, Au of aꞌbaras ꞌeu tuaf meseꞌ-meseꞌ utuin saaꞌ reꞌ in nmoꞌe. ");
INSERT INTO aaz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mimnau mirek-rekoꞌ! Naꞌko hi ar-arki reꞌ ia, tuaf fak-fauk of ka nmaten fa feꞌ, tar antea oras sin niit Kau, es reꞌ Mansian Batuur-Batuur reꞌ ia, aꞌjair Usif reꞌ annaaꞌ aprenat.” ");
INSERT INTO aaz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ankoon neno nee on naan ate, Naiꞌ Yesus noꞌen naiꞌ Petrus, naiꞌ Yakobus ma in orif naiꞌ Yohanis he nsaen neun aꞌtoeꞌf es, he sin nmes-mesen nbin naan. ");
INSERT INTO aaz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Antean aꞌtoꞌef naan in tunan, sin niit Naiꞌ Yesus naꞌbaniꞌ. In huumn ee npiin on reꞌ manas, ma In tais ein njarin mutiꞌ ma nariman. ");
INSERT INTO aaz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nok askeken on naan ate, sin niit Ee naꞌuab nok kaꞌo Musa ma kaꞌo Elia. ");
INSERT INTO aaz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Onaim naiꞌ Petrus antakaꞌnanaꞌ, tar antea in naꞌuab tafiꞌ-tafiꞌ am nak, “Usiꞌ, hit tbi bare ia te, naꞌ reko nneis! Onaim reko te hai mihakeb maan ropo teun. Es neu Ko Usiꞌ, es neu kaꞌo Musa, ma es anteniꞌ neu kaꞌo Elia.” ");
INSERT INTO aaz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Oras naiꞌ Petrus feꞌ naꞌuab on naan ate, nok askeken, noep ji nsaun neem ma nꞌaum naan sin. Onaim sin nsanmakan, oras sin nneen hanaf es anbi nope naan in nanan am nak, “Amneen! Naiꞌ Yesus reꞌ ia, Au Aan nekaꞌ. In nhariin Au nekak piut-piut. Amneen mirek-reokꞌ Ee!” ");
INSERT INTO aaz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Annenan on naan ate, atoup noinꞌ ein namtaun nmaten, tar antea sin nnoob ein. ");
INSERT INTO aaz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mes Naiꞌ Yesus neem ankaiꞌ sin im nak, “Amfeen nai. Kais mimtau!” ");
INSERT INTO aaz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Rarit sin nait matak, mes sin ka niit antein fa sekau-sekau nbi bare naan. Suma Naiꞌ Yesus anmees jah. ");
INSERT INTO aaz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Rarit sin nsanun nfanin naꞌkon aꞌtoꞌef naan. Onaim Naiꞌ Yesus antaar sin mates am nak, “Saaꞌ reꞌ hi miit ee feꞌe na, ka nabeiꞌ fa he mitoon ee meu sekau-sekau! Fin Au, Mansian Batuur-Batuur reꞌ ia, ro he ꞌmaet feꞌ. Rarit, karu Au ꞌmoni ꞌfain, naꞌ hi bisa mitoon ee.” ");
INSERT INTO aaz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Onaim sin nataan Ee mnak, “Usiꞌ, Ho reꞌ ia ro Kristus, mes kaꞌo Elia es mee? Fin tunggur agaam ein nanoin ein am nak, kaꞌo Elia ro he neem feꞌ, henaꞌ Kristus neem. Mes natuin Ho te, on mee?” ");
INSERT INTO aaz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naiꞌ Yesus nataah am nak, “Batuur. Kaꞌo Elia ro he neem feꞌ, he nfei ranan neu Kristus. ");
INSERT INTO aaz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mes amneen mirek-rekoꞌ! Kaꞌo Elia neem anrair, mes atoniꞌ ka nahiin je fa. Sin nasusab niis ne, natuin sin roimk ein. Sin of anmoeꞌ Kau, Mansian Batuur-Batuur reꞌ ia, on naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Annenan nrarin on naan ate, naꞌ sin nahinin am nak, kaꞌo Elia reꞌ Naiꞌ Yesus naꞌuab ee naan, es reꞌ naiꞌ Yohanis Asranit. ");
INSERT INTO aaz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oras Naiꞌ Yesus sin ntebi nfanin, sin nateef too mfaun reꞌ anpao nain sin. Onaim aꞌnaef es neem anriꞌtuu ma ntoit turun-babat, ");
INSERT INTO aaz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","am nak, “Usiꞌ! Amkasian maan au aanh ee, tua! In namaunu ꞌbibi, ma anhaꞌmuiꞌ jon. Karu menas naan neem ate, in nmoufu ntaam neu oe aiꞌ ai je, tua. Amturun maan kau, tua! ");
INSERT INTO aaz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au ꞌeik je goen aꞌbi Ho atoup noinꞌ ein, mes sin ka bisa nareokꞌ ee fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Anneen on naan ate, Naiꞌ Yesus naskarak In atoup noinꞌ ein am nak, “Hae! Ro hi bainesiꞌ ki! Au unoniꞌ ki fani-fani, mes hi ka mihiin mirek-rekoꞌ fa. Hi ka mpirsai fa batuur-batuur amsaꞌ meu Kau! Au ro he ꞌsabaar ꞌeu ki ꞌtea mee? Meik riꞌanaꞌ naan neem meu ia!” ");
INSERT INTO aaz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sin neik riꞌanaꞌ naan, rarit In nriuꞌ napoit niut reꞌuf naan. Rarit niut reꞌuf naan anpoi nasaitan riꞌanaꞌ naan, onaim in nareok nain oras naan. ");
INSERT INTO aaz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Rarit, oras Naiꞌ Yesus anmees nok In atoup noinꞌ ein on naan ate, sin nataan Ee mnak, “Usiꞌ! Nansaaꞌ am es feꞌe na hai ka bisa mriuꞌ mipoitan fa nitu naan?” ");
INSERT INTO aaz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Naiꞌ Yesus nataah am nak, “Hi ka bisa mriuꞌ fa nitu naan, natuin hi ka mpirsai fa batuur-batuur ate. Mimnau! Karu hi mpirsai batuur-batuur meu Kau te, maski aanꞌ-anaꞌ msaꞌ, hi bisa miprenat maan aꞌtoeꞌf es am mak, ‘Hoe! ꞌToꞌef! Munaniꞌ meu nee!’ In of nananiꞌ. Onaim hi bisa mmoeꞌ saaꞌ-saaꞌ aah, asar ramu hi mpirsai batuur-batuur meu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mes amneen! Niut reꞌuf human on reꞌ ia ro batuur sin maufinun bainesiꞌ. Karu hi ka mꞌonen ma minaah om fa, he mtoit turun-babat miꞌko Uisneno te, hi ka bisa fa he mriuꞌ nitu on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Neot es, Naiꞌ Yesus nok In atoup noinꞌ ein nabuan nbin propinsi Galilea. In natoon neu sin im nak, “Ka ꞌroo fa ntein ate, sin of naꞌsosaꞌ Kau neu biak ein. ");
INSERT INTO aaz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rarit sin naꞌmaet Kau, Mansian Batuur-Batuur reꞌ ia. Batuur Au ꞌmaet, mes nmeu on naan ate, Au ꞌmoni ꞌfain!” Anneen In uaban on naan ate, In atoup noinꞌ ein sin neek ein ansusan nmaten. ");
INSERT INTO aaz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oras Naiꞌ Yesus nok In atoup noinꞌ ein neman neun kuan Kapernaum, ahoik beo ngguin neman neu naiꞌ Petrus, ma nataan ee mnak, “Hi Tunggur goe anbaen Uim Onen Uuf in beo goe, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Onaim naiꞌ Petrus nataah am nak, “Anbaen, tua!” Oras in nfain on naan ate, Naiꞌ Yesus natoon nahuun ne mnak, “Hae, Simon! Ho mutenab miit. Uisf ein pah-pinan ia naitin beo naꞌko sekau? Naꞌko sin aanh ein, aiꞌ naꞌko tuaf bian?” ");
INSERT INTO aaz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naiꞌ Petrus nataah am nak, “Naꞌko tuaf bian, tua.” Naiꞌ Yesus naꞌuab anteniꞌ mnak, “Karu on naan ate, uisf ee in aanh ein kaisaꞌ nbaen ein beo, aiꞌ on mee? ");
INSERT INTO aaz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","On naan amsaꞌ nok Uim Onen Uuf in beo. Mes hit kais atmoeꞌ ahoik beo ngguin he natoꞌon. Reko nneis, ho mnao mtaun ikaꞌ meu nefo. Ho mtaun maan ika fua ahunut on naan ate, amfei in fefan. Ho of mupein roi mutiꞌ fua es anbi naan. Rarit ampaek roit naan, he mbaen hit nua kit, hit beo goe. Fin reꞌ naan nanookb een neu hit nua kit.” ");
INSERT INTO aaz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oras naan, Naiꞌ Yesus In atoup noinꞌ ein neman ma nataan Ee mnak, “Usiꞌ! Sekau es reꞌ koꞌu nneis anbin Uisneno Iin na?” ");
INSERT INTO aaz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Onaim Naiꞌ Yesus noꞌen naan riꞌaan es, rarit naꞌhaek ee nbi sin atnaank ein. ");
INSERT INTO aaz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Rarit In naꞌuabaꞌ am nak, “Amneen mirek-rekoꞌ! Tuaf reꞌ he njair Uisneno Iin na, in ro he nabanit nahiin in tenab he njair on reꞌ riꞌaan aꞌbaut reꞌ ia, reꞌ ka naꞌnaeb nahiin fa in tuan ii. ");
INSERT INTO aaz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Natuin tuaf reꞌ naꞌparan nahiin in tuan ii, on reꞌ riꞌaan aꞌbaut reꞌ ia, in es reꞌ koꞌu nneisi nbi Uisneno In human ma In matan. ");
INSERT INTO aaz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma tuaf reꞌ antoup atoin aꞌbaut on reꞌ riꞌanaꞌ reꞌ ia, natuin in npirsai Kau, tuaf reꞌ naan antoupu nrair Kau.” ");
INSERT INTO aaz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Rarit Naiꞌ Yesus natoon anteniꞌ sin im nak, “Karu nmuiꞌ tuaf reꞌ nmoeꞌ riꞌaan aꞌbaut es anteri nsaan, tar in ka npirsai nteniꞌ Kau fa, ampaant om, oo! Reko nneis atoniꞌ nfuut nakfirit faut kouꞌ goes anbi in neon, ma nporin nataam ee neu tais je tnanan. ");
INSERT INTO aaz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pah-pinan ia baer siraak batuur, natuin nmuiꞌ rasi mfaun reꞌ anmoeꞌ tuaf anmouf neu sanat. Mes tuaf reꞌ siraak anneis, es reꞌ tuaf reꞌ anmoeꞌ taos tafiꞌ-tafiꞌ, he tuaf bian nmoꞌe nsaan. ");
INSERT INTO aaz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Karu ho mmoꞌe msaan meik ho ꞌnimam, aiꞌ ho haem, mketu mporin! Reko nneis ho mtaam meu sonaf neno tunan meiki haa ꞌnimaꞌ meseꞌ, aiꞌ haꞌe meseꞌ, he kais sin nporin nataam ko neu ai abar-barat, mes ho ꞌnimam ma ho haem sin nua. ");
INSERT INTO aaz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Karu ho mmoꞌe msaan meik ho matam, mroꞌi mporin! Reko nneis ho mtaam meu sonaf neno tunan meiki haa mataf fuaꞌ meseꞌ, he kais sin nporin nataam ko neu ai abar-barat, mes ho matam sin fuaꞌ nua.” ");
INSERT INTO aaz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Naiꞌ Yesus naꞌuab anteniꞌ mnak, “Ampaant om, oo! Kais-kaisaꞌ hi mismeruꞌ riꞌaan aꞌbaut on reꞌ ia. Fin Uisneno nmuiꞌ ameput et sonaf neno tunan reꞌ anpanat sin. Ameupt ein naan bisa ntaman oras mee-mee jah, he natraak rasi anmatoom nok tuaf ein naan neun Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Hi mitenab mirek-rekoꞌ, Au ꞌpaek uab manporin on nai: anmuiꞌ tuaf es in aꞌbib-kaesn ein nautn es. Rarit neon goes, anmuiꞌ aꞌbib-kase es annao nsaan, anpeoꞌ kuun in ranan. Hi mitenab atukus naꞌko aꞌbib-kasen naan he nmoeꞌ saaꞌ? In ro nnao nasaitan boꞌ seo mseo ein nbin aꞌtoeꞌf ee tunan, he nnao naim aꞌbib-kaes reꞌ annao nsaan reꞌ naan. Karu in napein nafaniꞌ aꞌbib-kaes amnekut naan, in of anmariin anneis naꞌko reꞌ in he nkius in aꞌbib-kaes boꞌ seo mseo reꞌ ka namnekun fa. Au, Mansian Batuur-batuur reꞌ ia, ꞌuum he ꞌsoi ufetin tuaf reꞌ nteib ma nbeon on naꞌko raan amneot. ");
INSERT INTO aaz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Maski suma riꞌaan aꞌbaut es, es reꞌ namneku msaꞌ, Au Amaꞌ abit sonaf neno tunan ka nmariin fa.” ");
INSERT INTO aaz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Naiꞌ Yesus naꞌuab antein am nak, “Karu ho aom-bian apirsait anmoꞌe nsaan neu ko, ho ro he mnao muteef mok ne. Rarit karu hi nua ki mmees, naꞌ ho mutoon ee in sanat. Karu in natniin ho uabam naan, hi nua ki miraem om een. ");
INSERT INTO aaz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mes karu in ka natniin ko fa te, ho mnao meu ho partei tuaf es aiꞌ nua nnao nok ko. Rarit hi miteef mok ne, ma miꞌuab amteniꞌ. Fin anbi Suur Akninuꞌ Uisneno matuꞌi mnak, ‘Anbi rais jes, ro he nmuiꞌ tua asaksii nua aiꞌ teun reꞌ naꞌuab humaꞌ meseꞌ, henaꞌ bisa ntoup sin uabk ein naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mes karu in ka natniin ki fa te, amnao mitonan jemaaꞌt ein. Mes karu in ka ntoup reko fa jemaaꞌt ein sin uabk ein, maan ee on reꞌ tuaf reꞌ ka nahiin fa Uisneno. Kaah fa te, maan ee on reꞌ amaufinut nahuum on reꞌ ahoik beo. ");
INSERT INTO aaz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mimnau mirek-rekoꞌ saaꞌ reꞌ Au uꞌuab! Saaꞌ reꞌ hi mtaar ee mbi pah-pinan ia, Uisneno ntaar ee msaꞌ et sonaf neno tunan. Ma saaꞌ reꞌ hi mfei ma mkonan ambi pah-pinan ia, Uisneno nafetin anrair je et sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Au utoon aꞌteniꞌ ki mꞌak, karu nmuiꞌ tuaf nua naꞌko ki reꞌ mꞌonen nekaf meseꞌ, of Au Amaꞌ et sonaf neno tunan anfee ma nnonaꞌ saaꞌ reꞌ hi mtoit je. ");
INSERT INTO aaz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Karu nmuiꞌ tuaf nua aiꞌ teun nabuan ma nꞌoen ein, natuin sin reꞌ naan Au ngguin, Au ꞌbi sin atnaank ein amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Rarit naiꞌ Petrus neem nataan Naiꞌ Yesus am nak, “Usiꞌ, au he utaan akreꞌo. Karu au aok-bian atoin apirsait nmoꞌe nsaan kau fani-fani, au ro he ꞌfee ne ampon no fauk? No hitu, oo?” ");
INSERT INTO aaz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Onaim Naiꞌ Yesus nataah am nak, “Kahaf! Ho ro he mfee ne ampon no hitu nfain no boꞌ hiut, tar ho ka bisa msoꞌi mtein sin fa. ");
INSERT INTO aaz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Hi ro he mmoeꞌ mituin on naan, natuin Uisneno on reꞌ uisf es, reꞌ ansoiꞌ in pegawe sin tuus ein. ");
INSERT INTO aaz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oras in nmurai nsoiꞌ, in nreun in tuaf ein he nnaon nhaman pegawe es, reꞌ natuus roit anbi naa, tar hoto-hoto. ");
INSERT INTO aaz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mes pegawe naan ka bisa nbaen fa in tusaꞌ. Onaim uisf ee naprenat am nak, ‘Amnao miꞌsosaꞌ atoniꞌ ia nok in fee-anah sin, he sin njarin ate. Ma miꞌsosaꞌ main in aꞌmuꞌik ein, he nbaen in tuus ein.’ ");
INSERT INTO aaz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anneen on naan ate, pegawe naan anriꞌtuu ma nbaiseun uisf ee mnak, ‘Airoo, ama! Aam usiꞌ, amturun maan kau he mfee kau oras akreꞌo! Au of ufaniꞌ au tuus ein naan, tua.’ ");
INSERT INTO aaz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Anneen on naan ate, uisf ee nkasian ee. Onaim in nnoes nain pegawe naan in tuus ein. Rarit in nafetin pegawe naan. ");
INSERT INTO aaz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mes oras pegawe naan anpoi, in nateef nok in aok-bian es, reꞌ natuus roit akreꞌo nbi ne. Rarit in nheek in aok-bian naan, ma nkeer in neon ma naskaar ee mnak, ‘Hoe! Ambaen ho tuus aan, oras ia nai!’ ");
INSERT INTO aaz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Anneen on naan ate, in aok-bian ee nriꞌtuu ma ntoti mnak, ‘Airoo, baꞌe! Amturun maan kau he mfee kau oras akreꞌo! Au of ufaniꞌ au tuus ein naan, tua.’ ");
INSERT INTO aaz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mes pegawe naan nak, ‘Ka bisa fa! Ho ro he mbaenaꞌ oras ia!’ Rarit in nporin nataam in aok-bian naan nbi bui je nanan, tar in nbaenaꞌ in tuus ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Oras uisf ee in pegawe bian niit reꞌ in aꞌmoꞌen, sin neek ein ansusan nmaten. Rarit sin nnaon natrakan neun usif. ");
INSERT INTO aaz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Anneen on naan ate, uisf ee nhaman pegawe reꞌ ka ntae nahiin jon fa. In nakain ee mnak, ‘Hoe, atoin maufinu! Ho mtoit kau he au ꞌkasian ko, onaim au ꞌnoes ꞌain ho tuus ein. ");
INSERT INTO aaz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mes nansaaꞌ am es ho ka mkasian maan fa ho aom-bian naan, on reꞌ au ꞌkasian ko?’ ");
INSERT INTO aaz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Usif naan natooꞌ, onaim in nreun sin he nheek je ma nataam atoniꞌ naan anbi bui je nanan, anbain he sin haꞌmuiꞌ je, tar antea in nbaen in tuus ein ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Naiꞌ Yesus nasoup In retaꞌ, ma In natoon am nak, “Au Amaꞌ et sonaf neno tunan ansoiꞌ on naan amsaꞌ. In of anhukun ki, karu hi ka mnikan main fa hi aom-bian apirsait ein sin saant am penu sin.” ");
INSERT INTO aaz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Naiꞌ Yesus nanoniꞌ nrair sin on naan ate, In nnao nasaitan Galilea he nnao neu propinsi Yudea et noe Yarden in panin. ");
INSERT INTO aaz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Too mfaun ein natuin Ee. Onaim In narekoꞌ ameent ein anbin naan. ");
INSERT INTO aaz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atoin Farisis fauk neman he namouf Naiꞌ Yesus. Sin nataan Ee mnak, “Tatuin hit atoran rais pirsait, atoin amatsaos, in bole nporin in fee nok ranan saaꞌ ahaa oo, aiꞌ on mee, tua?” ");
INSERT INTO aaz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mes Naiꞌ Yesus nataah am nak, “Hi reꞌ ia, atoin ahiin rais pirsait. Mes nansaaꞌ am es hi ka mihiin fa Uisneno In Suur Akniunꞌ ee in afan? Fin anbi retaꞌ ahun-hunut, matuꞌi mnak, ‘Uisneno nmoeꞌ mansian, atoniꞌ ma bifee.’ ");
INSERT INTO aaz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Matuꞌi nteniꞌ mnak, ‘Es naan ate, atoin ii ro he nnao nasaitan in ainaf-amaf, he nmoin nabua nekaf meseꞌ ma ansaof meseꞌ nok in fee, fin sin nua sin njarin meseꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Onaim karu Uisneno neikn On es reꞌ naꞌmeseꞌ sin nua sin, mansian ii kais anbatis sin!” ");
INSERT INTO aaz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Anneen Naiꞌ Yesus naꞌuab on naan ate, atoin Farisis sin nataan antein Ee mnak, “Karu on naan ate, nansaaꞌ am es kaꞌo Musa nak, atoniꞌ bisa nporin in fee, asar in nfee suur manporin neu in fee?” ");
INSERT INTO aaz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Onaim Naiꞌ Yesus nataah am nak, “Kaꞌo Musa nkonan hi beꞌi-naꞌi sin nmanpoir ein nok sin feek ein, natuin sin aꞌnaak-fatun on reꞌ hi! Mes Uisneno nmoeꞌ pah-pinan ia, In sairt ii ka on fa naan. ");
INSERT INTO aaz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Onaim Au utoon, ki mꞌak: karu bifee ji anmakaek nahuun, atoin ii bisa nporin. Mes karu bifee ji ka nmakaek fa, mes atoin ii nporin, rarit ansao ntein bifee ꞌtetaꞌ, naan makaket!” ");
INSERT INTO aaz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Anneen In naꞌuab on naan, In atoup noinꞌ ein naꞌuab ein am nak, “Karu on naan, reko nneis kais atsao.” ");
INSERT INTO aaz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Onaim Naiꞌ Yesus nataah am nak, “Ka neu fa he tuaf amfaun bisa ntoup saaꞌ reꞌ Au uꞌuab ee reꞌ ia. Suma tuaf reꞌ Uisneno nruur ma nreek ee. ");
INSERT INTO aaz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anmuiꞌ tuaf ka nsao fa, natuin naꞌko oras nahoins ee te on naan. Anmuiꞌ tuaf bian ka nsao fa msaꞌ, natuin tuaf anmoeꞌ je on naan. Ma nmuiꞌ tuaf bian anpiir ranan he ka nsao fa, natuin in suma he nanaobaꞌ Uisneno In mepu. Tuaf reꞌ bisa nahiin ma ntoup noniꞌ reꞌ ia, maut he in ntoup goe.” ");
INSERT INTO aaz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oras naan, mahoin ein naskau neik sin aanh ein neu Naiꞌ Yesus he In ntao In aꞌniimk ein ma naꞌuab anfeen sin tetus. Mes In atoup noinꞌ ein nakain mahoin ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Onaim In naskarak In atoup noinꞌ ein am nak, “Amkonan riꞌaan ein naan neman Kau! Kais mikainaꞌ sin! Natuin tuaf reꞌ nahuum on reꞌ sin reꞌ naan, Uisneno Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Rarit In ntao In aꞌniimk ein nbi riꞌaan ein naan, ma In ntoit Uisneno he nfeen sin tetus. Rarit In nnao nasaitan bare naan. ");
INSERT INTO aaz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Neot es, anmuiꞌ tuaf es neem nataan Naiꞌ Yesus am nak, “Aam Tungguru! Au he ꞌmoeꞌ rais reko on mee, he uhiin batuur-batuur ꞌak, au bisa ꞌtaam ꞌeu sonaf neno tunan? Au he ꞌmoin ubar-baar ꞌok Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Onaim Naiꞌ Yesus nataah am nak, “Nansaaꞌ am es ho mutaan Kau nok saaꞌ es reꞌ reko? Suma Uisneno es reꞌ reko. Karu ho mroim he mmoin mok Ne te, ammoin mutuin In aprenat.” ");
INSERT INTO aaz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Atoniꞌ naan nataan anteniꞌ mnak, “Prenat reꞌ mee?” Onaim Naiꞌ Yesus nataah am nak, “Kais muꞌmaet mansian; kais ammakaek; kais mubaak; kais amjair saksii poi; ");
INSERT INTO aaz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","amhormaat ho ainaꞌ-amaꞌ sin; ma amneek ho aom-bian sin on reꞌ ho mneek ho tuam aan kuum.” ");
INSERT INTO aaz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Atoniꞌ naan nataah am nak, “Preent ein naan ok-okeꞌ, au utuin aꞌrair sin. Saaꞌ es reꞌ ankuran feꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Anneen on naan ate, Naiꞌ Yesus nataah am nak, “Karu ho mroim he mutuin Uisneno In roimn ein ok-okeꞌ te, mfain nai, ma mnao muꞌsosaꞌ mporin ho ꞌmuiꞌm ein ok-okeꞌ. Rarit amnao mbait roit ein meu amaꞌmuiꞌt ein. Rarit amfain uum he mutuin Kau. Fin Uisneno of anbaras anfee ko aꞌmuꞌif natho-hoen et sonaf neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Anneen on naan ate, atoniꞌ naan ntebi nfain nok neek susat, natuin in aꞌmuiꞌn ii kah een. ");
INSERT INTO aaz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Rarit Naiꞌ Yesus naꞌuab nok In atoup noinꞌ ein am nak, “Ampirsai Kau, atoin amuiꞌt ii susa maꞌtaniꞌ henaꞌ ntaam neu sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","In suust ee, on reꞌ bikaes unta kouꞌ goes, antaam neu in oꞌof anpeoꞌ aent ee konan.” ");
INSERT INTO aaz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anneen on naan ate, In atoup noinꞌ ein ansanmakan. Onaim sin natahan am nak, “Karu on naan ate, sekau es reꞌ bisa ntaam neu sonaf neno tunan?” ");
INSERT INTO aaz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","In nkius narek-rekoꞌ sin, rarit In naꞌuab am nak, “Batuur, karu mansian ii es reꞌ anmeup, ka bisa fa. Mes karu Uisneno es reꞌ anmeup, saaꞌ-saaꞌ ii ro njair.” ");
INSERT INTO aaz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Onaim naiꞌ Petrus namnaub am nak, “Aam! Hai mnao misaitan hai ꞌmuiꞌm ein oekꞌ een, he mituinaꞌ Ko. Onaim hai mipein saaꞌ, tua?” ");
INSERT INTO aaz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","In nataah am nak, “Ampirsai Kau! Oras Uisneno nmoeꞌ saaꞌ-saaꞌ ii ok-okeꞌ njair feꞌu te, Au, Mansian Batuur-Batuur reꞌ ia, aꞌtokoꞌ ꞌbi ꞌtokoꞌ prenat. Oras naan, hi reꞌ mituinaꞌ Kau, mtoko mbi ꞌtokoꞌ prenat boꞌes am nua, he mjair afeek rasi meu uuf Israꞌel boꞌes am nua! ");
INSERT INTO aaz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tuaf reꞌ nnao nasaitan in umi, in orif-tataf, in ainaf-amaf, in aanh ein, ma in rene, he natuinaꞌ Kau, in of antoup nafaniꞌ no nautn es. Rarit oras pah-pinan ia namsopu te, in nmoin nabar-baar nok Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Onaim mimnau! Tatuin Uisneno In tenab, tuaf reꞌ naꞌnaeb in tuan, in reꞌ naan, es reꞌ tua aꞌbaut. Mes tuaf reꞌ naꞌparan in tuan ee on reꞌ atoin aꞌbaut, in reꞌ naan, es reꞌ tua aꞌnaet natuin Uisneno In tenab.” ");
INSERT INTO aaz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Rarit Naiꞌ Yesus nanoniꞌ sin im nak, “Uisneno In aprenat naan, on reꞌ uab manporin reꞌ ia: anmuiꞌ pooꞌ tuaf es, reꞌ npoi nnao kik-kiku oras anreuk nee, nnao naim tuaf he nmepu nbin in pooꞌ anggur. ");
INSERT INTO aaz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","In napein ameput, onaim sin nnekaꞌ buan he nmeup neon goes, nok in nbaen sebaꞌ, roi mutiꞌ fua es, on reꞌ osaf biasa. Anromin nrarin on naan ate, in nreun sin nnaon nmepun. ");
INSERT INTO aaz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Oras anreuk seo te, in npoi nnao ntein neu ꞌmasaꞌ. Anbi naan in nkius niit tuaf fauk reꞌ antokon ntakaꞌnaan ein aah. ");
INSERT INTO aaz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Onaim in naꞌuab nok sin im nak, ‘Baꞌe sin! Hi mroim he mmepu mbi au pooꞌn ee, oo? Au of aꞌbaen ki nok reko.’ Annenan on naan ate, sin anromin, rarit sin nnaon nmepun. ");
INSERT INTO aaz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Oras anreuk boꞌes am nua on naan ate, pooꞌ tuaf naan anpoi nnao naim ameput antein. On naan amsaꞌ oras nreuk teun maans ee nteib. ");
INSERT INTO aaz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Maans ee nmaeb on naan ate, of oniꞌ nreuk niim pooꞌ tuaf naan npoi ntein. In nkius neu-mneem, anmuiꞌ tuaf reꞌ anhaek ruum aah. Rarit in nataan sin im nak, ‘Nansaaꞌ am es hi mhaek ruum aah naꞌko kiku ntea maans ee nmaeb jen, ma ka mmeup fa saaꞌ-saaꞌ?’ ");
INSERT INTO aaz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tuaf ein naan nataah am nak, ‘Aam! Ka nmuiꞌ fa tuaf reꞌ anfee kai mepu, tua.’ Rarit pooꞌ tuaf naan nak, ‘Karu on naan ate, hi mnao he mmeup meu au poꞌon!’ ");
INSERT INTO aaz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Antea oras reꞌ sin nasnasan naꞌkon sin meup goe te, pooꞌ tuaf ee nhaman in mandoor ee am nak, ‘Amhaman ameupt ein naan, he mbaen sin kai ngguin meseꞌ-meseꞌ. Ammurai muꞌko tuaf reꞌ antaam muniꞌ tar antea tuaf reꞌ ntaam nahuun naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Rarit mandoor ee nhaman ameupt ein reꞌ nmurai nmepun naꞌkon oras nreuk niim maans ee nmaeb. In nfeen sin es-es ate antoup roi mutiꞌ fua es. ");
INSERT INTO aaz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Rarit mandoor naan anhaman ameput bian, ntea tuaf reꞌ nmurai nmepun naꞌko oras nreuk nee kik-kiku. Reꞌ nmepun naꞌko kiku natenab am nak, sin of napenin nneis naꞌko tuaf reꞌ nmurai nmepun oras nreuk niim maans ee nmaeb. Te kaah, sin ntoup roi mutiꞌ fuaꞌ meesꞌ aah amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Antoupun on naan ate, sin nmaheek pooꞌ tuaf ee mnak, ");
INSERT INTO aaz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Hae! Aam! Ka bisa fa on nai. Sin neem namunin, suma anmeup naan jam meesꞌ aah. Mes hai reꞌ mtaam miꞌko kik-kiku, ammeup maꞌtaniꞌ ma mhae maet tar antea puus ein nsai! On nai te, nansaaꞌ am es ho mbaen kai natai?’ ");
INSERT INTO aaz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Onaim pooꞌ tuaf ee nataah am nak, ‘Baꞌe, au ka upoi ko fa. Fin ho es amroim kuum he mmeup neon goes, ma in sapaan ee roi mutiꞌ fua es. Batuur, aiꞌ on mee? Onaim au ꞌbaen utuin hit atfekaꞌ naan, aiꞌ? ");
INSERT INTO aaz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Reko nneis, ho mtoup ho roi sebaꞌ he mfain nai. Karu au ꞌroim he ꞌfee ꞌeu tuaf reꞌ ntaam anmeup muniꞌ naꞌko ko, natai nok saaꞌ reꞌ au ꞌfee je ꞌeu ko, naan au urusan. ");
INSERT INTO aaz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Au ꞌroim he ꞌpaek au roit utuin au romik. On mee mꞌes ho mutooꞌ natuin au neek ii reko?’ ");
INSERT INTO aaz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","On naan amsaꞌ, oras Uisneno njair Usif neu mansian ein, In nbaras neu In tuaf ein natuin In romin. Onaim tuaf reꞌ neem namuni te, in of antoup in sapaan ee on reꞌ tuaf reꞌ neem nahuun. Ma tuaf reꞌ neem nahuun, of in ntoup in sapaan ee on reꞌ tuaf reꞌ neem namuin.” ");
INSERT INTO aaz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Rarit Naiꞌ Yesus sin nmurai nnaon neun Yerusalem. Anbin raan atnanaꞌ, In nhaman In atoup noinꞌ ein he sin nmes-mesen nok Ne. Rarit In natoon antein am nak, ");
INSERT INTO aaz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hi mneen! Oras ia hit he tnao teu Yerusalem. Mes oras hit tbi nee, sin of naꞌsosaꞌ Kau, Mansian Batuur-Batuur, neu aꞌnaak pirsait Yahudi sin aꞌnaakt ein, ma tunggur agaam ein. Rarit sin nhukun naꞌmaet Kau. ");
INSERT INTO aaz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sin nanaꞌat Kau neu tuaf ein reꞌ ka nahiin fa Uisneno. Rarit sin naꞌuab namae Kau. Ma sin nbeos nakratiꞌ niis Au aok. Rarit naꞌ sin naꞌmaet Kau ꞌbi hau nehe. Batuur Au ꞌmaet. Mes nmeu te, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Rarit naiꞌ Sebedius in fee je nok in anah naiꞌ Yakobus ma naiꞌ Yohanis neman neun Naiꞌ Yesus. In nriꞌtuu ma nfee hormaat he nbaiseun neik uab furiꞌ neu Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Onaim Naiꞌ Yesus nataan ee mnak, “Ain! Ho mperluu saaꞌ?” In natoon am nak, “On nai, Aam! Au ꞌtoit he karu Ho mnaaꞌ aprenat ate, munaibaꞌ au aanh ein nua sin, he sin nnaꞌan aprenat nok Ko. Au ꞌtoit he mutokoꞌ es ambi Ho ꞌneꞌu, ma es anteniꞌ anbi Ho ꞌrii.” ");
INSERT INTO aaz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Anneen in ntoit on naan ate, Naiꞌ Yesus naꞌuab neu naiꞌ Yakobus ma naiꞌ Yohanis am nak, “Hi ka mihiin fa saaꞌ reꞌ hi mtoti. Fin Au of upein haꞌmuꞌit ma maꞌneꞌat amfaun. Onaim on mee? Hi of mitenab mak hi bisa misaah haꞌmuꞌit ma maꞌneꞌat naan mok Kau, oo?” Sin nua sin natahan nok haan maꞌkaf-kafaꞌ am nak, “Bisa, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Rarit In nataah antein sin im nak, “Batuur, hi of misaah haꞌmuꞌit ma maꞌneꞌat on reꞌ Au msaꞌ. Mes sekau reꞌ es atokos anbi Au ꞌnimak aꞌneꞌu aiꞌ aꞌrii, Au ka es reꞌ ufeek ee fa. Naan Uisneno In hak he nafeek. In nafeek anrair sekau-sekau reꞌ antoko nbi bare naan.” ");
INSERT INTO aaz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Oras atoup noniꞌ tuaf boꞌes anneen sin nua sin antotin on naan ate, sin nsaken. ");
INSERT INTO aaz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mes Naiꞌ Yesus anhaman naan sin ok-okeꞌ, onaim In naꞌuab neu sin im nak, “On nai! Hi mihini mrair, aiꞌ? Aꞌnaet ein reꞌ annaꞌan aprenat biasa sin nhaꞌmuiꞌ sin too ngguin, tar antea sin ka bisa nmoꞌen fa saaꞌ-saaꞌ. Ma aꞌnaakt ein naꞌkon pah reꞌ ka nahiin fa Uisneno, sin nasanut prenat humaꞌ-humaꞌ, tar antea too gui kaꞌ bisa nait fa ꞌnakan. ");
INSERT INTO aaz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mes hi kais ammoeꞌ on naan! Sekau naꞌko ki reꞌ he njair aꞌnaet, in ro he njair on reꞌ ate atuthaes neu tuaf bian. ");
INSERT INTO aaz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma sekau reꞌ he njair aꞌnakat, in ro he nmoeꞌ on reꞌ ate. ");
INSERT INTO aaz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amneen! Au on naan amsaꞌ. Au, Mansian Batuur-Batuur ia, ꞌuum he ꞌtuthae tuaf. Au ka ꞌuum fa he atoniꞌ ntuthae Kau. Fin Au ꞌuum he ꞌfee Au ꞌmoin ki ꞌteme-ꞌteme he ꞌsoi ꞌain too mfaun ein naꞌkon sin sanat ma penu sin.” ");
INSERT INTO aaz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Rarit Naiꞌ Yesus sin nnaon nkonon. Oras sin npoin naꞌkon kota Yeriko, nmuiꞌ too mfaun reꞌ natuin sin. ");
INSERT INTO aaz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anbi naan, anmuiꞌ aforot tuaf nua reꞌ ntokon nbin raan ee ninin. Oras sin nnenan nak, reꞌ annao npeoꞌ naan es reꞌ Naiꞌ Yesus naꞌko Nasaret, sin ankoaꞌ ein naher-heran am nak, “Usiꞌ! Sufaꞌ-kaꞌuf naiꞌ Daut! Hai mpao Ko ꞌroo-ꞌroo goen! Amkasian maan kai, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Anneen sin nkoaꞌan on naan ate, bian nakain sin im nak, “Hoe! Hi nua ki kais amtaisiub!” Mes sin nkoaꞌ ein naher-heran anteinꞌ ein am nak, “Usiꞌ! Sufaꞌ-kaꞌuf naiꞌ Daut! Amkasian maan kai, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Oras In nneen on naan ate, In nhaek. Onaim In nataan sin im nak, “Hi mroim he Au ꞌmoeꞌ saaꞌ ꞌeu ki?” ");
INSERT INTO aaz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sin natahan am nak, “Usiꞌ! Amturun kai, he hai bisa mkius miit, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Anneen sin naꞌuab ein on naan ate, In nkasian sin. Rarit In nreoꞌ sin maatk ein, onaim sin niit nanin oras naan. Rarit sin natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Rarit Naiꞌ Yesus sin nnaon nkonon tar antean kuan es, kaan ee Betfage, et aꞌtoꞌef Saitun in ninin. Kuan naan he npaumak-maak nok kota Yerusalem. Anbi naan sin nasnasan ntaahn ein. Onaim In nreek In atoup noniꞌ tuaf nua he nnaon nahunun. ");
INSERT INTO aaz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","In naprenat sin im nak, “Hi nua ki mnao meu kuan nee. Karu hi mtaam, hi of miit bikaes keledai ainf es nok in aan ee mafutuꞌ et naan. Hi mnao mseif sin ma mheer meik Kau sin neman. ");
INSERT INTO aaz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mes karu nmuiꞌ tuaf reꞌ nataan ki mnak, ‘Nansaaꞌ am es hi mheer meik biak ein sin bikaes keledai?’ Hi mitaah am mak, ‘Usiꞌ he npake. Karu In npake nrair je te, In of ansoun ee nfain neem.’ ");
INSERT INTO aaz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Rasin reꞌ naan ok-okeꞌ ro he njarin, natuin saaꞌ reꞌ Uisneno In mafefa kniunꞌ ein antui nain sin im nak, ");
INSERT INTO aaz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Hoe, hi atoin Yerusalemas arki! Amkoen om iim he mkius ma miit kiim! Fin hi Uisf ee, es reꞌ ankoen On antaam neem. In ntaam neem nok neek aꞌparat ma ba-baun. In ntaam neem ansae ma naꞌtuut On nbi bikaes keledai anaꞌ.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Rarit In atoup noinꞌ ein annaon ma nmoeꞌ natuin sin ok-okeꞌ, on reꞌ Naiꞌ Yesus anbaꞌan sin. ");
INSERT INTO aaz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sin nheer neik bikaes keledai ainf ee nok in aan ee neu Naiꞌ Yesus. Rarit sin ntaon tai-mutiꞌ njarin aꞌpeniꞌ, onaim In nsae nbi bikaes keledai naan, he ntaam neu kota. ");
INSERT INTO aaz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oras sin ntaman neun kota nanan, too mfaun ein nait sin tai-muit ein, ma sin pouk ein, he naꞌbeen sin anbin ranan. Anmuiꞌ tuaf reꞌ nnaon nꞌoten hau noo peta msaꞌ he sin naꞌbenan nbin raan ee tnanan. Nok ranan naan, sin nmoeꞌ tanar am nak, sin nseun Naiꞌ Yesus on reꞌ kaes koꞌu. ");
INSERT INTO aaz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma nmuiꞌ tuaf annaon nahunun anbin Naiꞌ Yesus In matan, ma bian namunin. Sin nsakanan ok-okeꞌ mnak, “Hosana! Hai mpures ma mboꞌis meu Uisneno! Natuin usif Daut in sufaꞌ-kaꞌuf neem anrair! Hosana! Hai mpures ma mboꞌis meu Uisneno! Natuin Uisneno nruur ma nreek haefan Atoniꞌ ia. Hosana! Hai mpures ma mboꞌis meu Uisneno! Natuin Uisneno ntuun On ma naprenat et neno aꞌraat reꞌuf!” ");
INSERT INTO aaz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oras Naiꞌ Yesus antaam neu Yerusalem sin nkoaꞌ ma nhunun on naan, kota naan in naan ee npoin ok-okeꞌ ma nmaktaan ein am nak, “Sekau es reꞌ amnemat reꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Too mfaun ii natahan am nak, “In reꞌ naan Uisneno In mafefa kninuꞌ. In kaan ee Naiꞌ Yesus, atoin Nasaretas, naꞌko propinsi Galilea.” ");
INSERT INTO aaz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Rarit Naiꞌ Yesus sin nnaon nkonon, onaim sin ntaman nbin Uisneno In Uim Onen Uuf. Anbi Uim Onen naan in kintal, atoin ein nmoeꞌ je njari ꞌmasaꞌ he sin naꞌsoos ein kor-kefi reꞌ atoniꞌ npaek je he nfee fuaꞌ-turuꞌ anbi onen. Ankius on naan ate, Naiꞌ Yesus nnao nriuꞌ napoitan sin. In npesek anporin mein reꞌ sin npaek sin he tukar roit, ma nabaniꞌ aꞌbeen ein reꞌ sin npaek sin he naꞌsoos ein koro. ");
INSERT INTO aaz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Onaim In natoon neu sin im nak, “Uisneno In mafefa kninuꞌ antui mnak, ‘Au uhakeꞌ ma ufenaꞌ Umi ia, he sekau-sekau goah bisa neman nꞌoen ein neun ia.’ Uisneno In sairt ee on reꞌ naan, mes hi mmoeꞌ je njair apaikaurt ein sin baer ekut-tefas!” ");
INSERT INTO aaz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Rarit afoort ein ma abuat ein neman neun Naiꞌ Yesus anbi Uisneno In Uim Onen naan. Onaim In narekoꞌ nain sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Anbi naan, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma tunggur agaam ein anhaek nokan amsaꞌ. Oras sin nkius Naiꞌ Yesus anmoeꞌ rais sanmakat, sin natoꞌon. Anneis-neisi nteniꞌ, oras sin nnenan riꞌaan ein ankoaꞌ ein ma nsakanan ok-okeꞌ nbin Uim Onen naan am nak, “Hosana! Hai mpures ma mboꞌis meu Uisneno! Natuin usif naiꞌ Daut in sufan-kaꞌun ankoen on neem anrair!” ");
INSERT INTO aaz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rarit aꞌnaakt ein natonan Naiꞌ Yesus am nak, “Ho mneen riꞌaan ein sin uabk ein? Reꞌ naan ka batuur fa!” Mes Naiꞌ Yesus nataah sin im nak, “Reko, Au ꞌneen. On nai te, hi teenb ee on mee? Hi ka mrees miit fa et Uisneno In Suur Akninuꞌ anmatoom nok anah-anah reꞌ npures ma nboꞌis neun Uisneno, aiꞌ? Fin anbi naan matuꞌi mnak, ‘Uisneno nabarab nain riꞌana kruꞌuf ma riꞌaan anaꞌ ma aꞌbaut, he sin npures ma nboiꞌs Ee.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Rarit Naiꞌ Yesus sin annaon nasaitan kota naan, he nnaon ntupan nbin kuan Betania. ");
INSERT INTO aaz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nokaꞌ kiuk anaꞌ te, Naiꞌ Yesus sin ntebi nfanin neun kota Yerusalem. Anbi raan atnanaꞌ In annaben ate namnaah. ");
INSERT INTO aaz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","In nkius niit hau uuꞌ goes anbi raan ee ninin reꞌ tuaf biasa neuk in fuan. Onaim In nnao npaumak-maak hau naan, he nkius niit ee nafua, aiꞌ kaah. Mes oras In ntea hau naan, In ka niit fa fuaf fuaꞌ meseꞌ msaꞌ, natuin hau naan feꞌ he nanoo. Onaim In naꞌuab neu hau naan am nak, “Natuin ho ka mufua fa meu Kau, es naan ate ho ka mufua mtein fa!” In naꞌuab anrair on naan ate, hau naan anmeot nain. ");
INSERT INTO aaz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","In atoup noinꞌ ein ankius nitan on naan ate, sin naskeken. Sin natanan am nak, “Nansaaꞌ am es nok askeken ate hau ia nmeot nain?” ");
INSERT INTO aaz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Onaim In nataah am nak, “Amneen mirek-rekoꞌ joo! Karu hi mpirsai batuur-batuur meu Uisneno, ma hi neekm ein ka naꞌoin ein fa kreꞌo msaꞌ, hi bisa mmoeꞌ on reꞌ Au ꞌmoeꞌ je naan. Hi bisa mmoꞌe nneis naꞌko naan. On reꞌ: hi bisa miprenat aꞌtoeꞌf es nananiꞌ neu tasi. Uisneno of nananiꞌ nain aꞌtoꞌef naan, asar hi mpirsai batuur-batuur meu Ne! ");
INSERT INTO aaz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Fin areꞌ kanan rasi reꞌ hi mtoit sin miꞌko Uisneno, hi of amtoup sin, asar hi mpirsai batuur-batuur meu Ne.” ");
INSERT INTO aaz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Rarit Naiꞌ Yesus sin nnaon nkonon. Antean Yerusalem ate, sin ntaman nfanin nbin Uim Onen Uuf ee in kintal. Oras In nanoniꞌ tuaf anmatoom nok Uisneno In raan aꞌhonis on nai te, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma atoni mnais haart ein neman ma nataan Ee mnak, “Sekau es reꞌ anreun ko he ho mtao taisibu mbi ia afi naa? Sekau es reꞌ anfee ko hak naan?” ");
INSERT INTO aaz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mes In nahiin neu sin namin ranan he namouf Goe. Rarit In nataah am nak, “Au he utaan ki msaꞌ. Hi mitaah Kau feꞌ, henaꞌ Au utaah ki. ");
INSERT INTO aaz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Au he utaan ki on nai: hi ok-okeꞌ mihiin naiꞌ Yohanis asranit, aiꞌ? Sekau es reꞌ anfee ne hak he nasrain? Uisneno, aiꞌ mansian?” Rarit sin nateenb ein neu-mneman, ma naꞌuab ein am nak, “Kreot ii naan kit ein, karu hit tak, ‘Uisneno es reꞌ anfee hak’, In of nataah am nak, ‘Karu on naan ate, nansaaꞌ am es hi ka mpirsai fa naiꞌ Yohanis?’ ");
INSERT INTO aaz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mes hit ka bisa fa he tak, ‘Mansian es reꞌ anfee hak’, natuin too mfaun ein of anmaheek kit. Natuin sin npirsain am nak, naiꞌ Yohanis naan, Uisneno In mafefa kninuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Es naan ate, sin natahan neun Naiꞌ Yesus am nak, “Hai ka mihiin fa, tua.” Onaim Naiꞌ Yesus nataah neu sin im nak, “Karu on naan ate, Au ka ꞌperluu fa he utoon ki ꞌak sekau es reꞌ anfee Kau hak.” ");
INSERT INTO aaz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Naiꞌ Yesus naꞌuab nok aꞌnaakt ein am nak, “Hi mitenab on mee nok uab manporin ia? Anmuiꞌ atoni mnais es nok in aan mone tuaf nua. In naprenat in aan moen unu mnak, ‘Neno ia ho mnao mmeup on reen je feꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mes aan moen unu naan nataah am nak, ‘Au ka ꞌnao fa.’ Mes ka ꞌroo fa te, in nmeiꞌ jon, rarit in nnao. ");
INSERT INTO aaz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Rarit atoni mnasiꞌ naan anreun in aan mone es antein am nak, ‘Neno ia, ho mnao mmeup on reen je feꞌ.’ Onaim anah naan nataah am nak, ‘Reko, tua. Au of aꞌnao’. Mes in ka nnao fa.” ");
INSERT INTO aaz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Naretaꞌ nrair on naan ate, Naiꞌ Yesus nataan sin im nak, “Au he utaan ki on nai: naꞌko riꞌaan nuaꞌ ein naan, reꞌ mee es reꞌ nmoeꞌ natuin in aamf ee prenat?” Onaim sin nataahn am nak, “Aan moen unu!” Rarit In naꞌuab am nak, “Reko, mes amneen mirek-rekoꞌ, fin Au uꞌuab batuur. Tuaf reꞌ hi mtanar nahuum on reꞌ sin ka mapaek ein fa, on reꞌ ahoik beo, ma bifee aꞌhakeꞌ, sin of antaman njarin Uisneno In tuaf ein reꞌ nahunun naꞌko ki. Hi suma mitaah ‘reko’ meu Uisneno goah, mes ka mmoeꞌ mituin fa In romin. ");
INSERT INTO aaz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Unuꞌ, Naiꞌ Yohanis asranit nanoniꞌ ma natoon anrair ki nok ranan on mee he hi bisa mmoin mimnoon ma mimneo. Mes hi ka mroim fa he mpirsai Je. Te kaah, oras tuaf reꞌ ka mapakeꞌ fa sin nneen naiꞌ Yohanis, sin nasaitan sin sanat ma penu sin he natuin in noinꞌ ein naan. Hi mihini mrair sin ok-okeꞌ. Mes hi ka misnaas fa miꞌko hi sanat ma penu sin, he mituin Uisneno In romin.” ");
INSERT INTO aaz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Rarit Naiꞌ Yesus naretaꞌ reet es antein am nak, “Anmuiꞌ naan auf tuaf es antao rene, he nseen hau anggur. Rarit in nbaah naan rene naan nfuun am nateef. Onaim in ntao baak he naes hau fua anggur oef. Ma in nmoeꞌ tobe. Rarit in naꞌsebaꞌ rene naan neu aseebt ein he sin npairori, ma rene naan in afan sin nbatin nfeen auf tuaf naan. Onaim in nnao nasaitan sin neu pah pen-pene bian. ");
INSERT INTO aaz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Oras he nseun hau fua anggur te, pooꞌ tuaf naan anreek in haef ein he neman neu aseebt ein naan, he ntoup in sapaan. ");
INSERT INTO aaz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mes aseebt ein naan sin ka nfairoir fa haef ein naan. Bian napenin besot, anroor bian, ma npoir bian nok fatu. ");
INSERT INTO aaz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mes pooꞌ tuaf naan anrenu nteniꞌ in haef ein puukn es, reꞌ namfau nneis naꞌko ahuunt ein. Mes aseebt ein naan nmoꞌen maufinu neu sin ok-okeꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aꞌroo-ꞌroo te, pooꞌ tuaf naan anreun in aan honiꞌ. In natenab am nak, ‘Karu au ꞌreek haefan ꞌeu au aan honiꞌ, sin of anseun goe rek-reko, ma sin of natniin ee.’ ");
INSERT INTO aaz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mes oras aseebt ein niit riꞌanaꞌ naan, sin naꞌuab ein am nak, ‘Hae, amkius miit! Aꞌnaef ee nreek haefan neu in aan honiꞌ, in of es reꞌ ntoupu ꞌnaef ee in pusaak ein ok-okeꞌ. Onaim iim he theek je ma troor tiis ne nai, maut he hit es atpaar kuuk poꞌon ia.’ ");
INSERT INTO aaz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Onaim sin nheek riꞌanaꞌ naan, rarit sin nheer neik je, ma npoirn ee neu poꞌon naan in kotin ma sin nroor niis ne.” ");
INSERT INTO aaz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naiꞌ Yesus naretaꞌ nrair on naan ate, In nataan sin im nak, “Au utaan ki on nai: karu pooꞌ tuaf naan anfain neem, in of he nmoeꞌ saaꞌ neu aseebt ein naan?” ");
INSERT INTO aaz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rarit atoin Yahudis sin aꞌnaakt ein natahan am nak, “In ro he nroor naꞌmaet atoin maufinun sin ok-okeꞌ. Rarit in naꞌsebaꞌ poꞌon naan neu tuaf bian antein. On naan ate, of nateef in oors ate, sin nbait poꞌon naan in afan.” ");
INSERT INTO aaz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Rarit Naiꞌ Yesus naꞌuab neu sin im nak, “Oniꞌ hi ka mrees miit fa saaꞌ reꞌ matuꞌi et Uisneno In Suur Akninuꞌ mnak, ‘Anmuiꞌ naan faut goes reꞌ tuukn ein nait inporin, mes oras ia, fatu naan anjair fatu ꞌsukiꞌ neu umiꞌ! Uisneno kuun es reꞌ anpiir ma nbetis nain je, he natokoꞌ fatu naan. Es naan ate, hit tahiin ma tiit in masan arekot!’ ” ");
INSERT INTO aaz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rarit Naiꞌ Yesus naꞌuab anteniꞌ mnak, “Onaim mitenab mirek-rekoꞌ. Unuꞌ te Uisneno npiir kit atoin Yahudis, he tjair Iin na. Mes natuin hi ka mituinaꞌ Kau fa, Uisneno of anpiir tua sonaꞌ. Fin tuaf reꞌ nmoin natuin Uisneno In romin es reꞌ bisa ntaam anjair Iin na. ");
INSERT INTO aaz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Au utoon unoon. Au reꞌ ia, es reꞌ fatu ꞌsukiꞌ naan. Tuaf reꞌ nastuun ma ntaikobi nbi fatu ia, of namreuꞌ. Ma karu fatu naan anmouf ma ntoom tuaf es, tuaf naan of namreuꞌ nain.” ");
INSERT INTO aaz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Oras aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma atoin Farisi sin nneen Naiꞌ Yesus In retaꞌ naan, sin nahinin am nak, In nseer sin. Sin arsin reꞌ naan natai nok reꞌ aseeb pooꞌ anggur naan, ma tukan fatu reꞌ nait inporin fatu ꞌsukiꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Onaim sin natoꞌon nmat-maten. Rarit sin nꞌator asraak he nheek Naiꞌ Yesus. Mes sin natiun gok neu too mfaun ein reꞌ naan Naiꞌ Yesus nak, Uisneno In mafefa kninuꞌ. Onaim sin ka bisa nmoꞌen fa saaꞌ-saaꞌ neu Ne. ");
INSERT INTO aaz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Rarit Naiꞌ Yesus naꞌuab antein anpaek retaꞌ mnak, ");
INSERT INTO aaz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uisneno In aprenat naan, nahuum on reꞌ uisf es, reꞌ nmoeꞌ fesat kabin neu in aan mone. ");
INSERT INTO aaz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oras naroitan anrair fesat naan ate, in nreek haefan in aten he nnaon naskau tuaf-tuaf reꞌ napenin haan askaut am nak. ‘Au uskau tua, natuin acara fesat he nmurai jen.’ Mes tuaf ein naan ka nromin fa he nokan. ");
INSERT INTO aaz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Rarit aten naan antebi nfanin ma natonan neun sin usif. Anneen on naan ate, usif naan nreek haefan in aten bian am nak, ‘Hi mnao miskau tuaf ein naan he neman, fin fest ee naroitan anrair je. Au ꞌroro ꞌrair bijae, ma uhaan namin-miin. Miskau sin he neman ma nbukaen fesat, fin au ubarab urair je.’ ");
INSERT INTO aaz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aten naan annaon naskaun on naan. Mes tuaf-tuaf reꞌ napenin haan askaut ka nfairorin fa. Bian annaon on poꞌon, bian annaon on baer mepu, ");
INSERT INTO aaz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma bian anheek usif naan in aten, ma nhaꞌmuiꞌ naꞌmaet sin. ");
INSERT INTO aaz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Anneen on naan ate, usif naan natooꞌ batuur-batuur. Rarit in naprenat in soraurs ein he nnaon nroor tuaf-tuaf reꞌ nroor in aten. Rarit soraurs ein naan nout kota naan tar namneer antea afu. ");
INSERT INTO aaz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Rarit usif naan anhaman in aten bian ma naꞌuab am nak, ‘Tabarab atrair fesat kabin, mes tuaf-tuaf reꞌ au uskau sin naan, ka neu fa he nokan anbin au fesat. ");
INSERT INTO aaz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oras ia, hi mnao meu raan oopt ein, he miskau sekau goah reꞌ hi miteef sin anbin naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Rarit aten naan annaon neun raan oopt ein. Sin neik tuaf amfaun reꞌ sin nateef sin anbin naan, he nnaon neun fesat kabin. Anmuiꞌ atoin reko ma anmuiꞌ atoin maufinu reꞌ neman namfa-faun anbin fesat naan. ");
INSERT INTO aaz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Rarit usif naan antaam neu baer fesat he nkisu nfuun am nateef in taumn ein ok-okeꞌ. Onaim in niit tamu tuaf es, reꞌ ka npaek fa baur fesat. ");
INSERT INTO aaz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rarit usif naan nataan am nak, ‘Hae, baꞌe! Nansaaꞌ am es ho mtaam meu ia ka mpaek fa baur fesat?’ Mes tuaf naan ntakaꞌnanaꞌ on ahaa reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Onaim usif naan naprenat in aten am nak, ‘Amfuut atoniꞌ reꞌ ia in haen-niman, he mait impoir ee meu moneꞌ. Maut he in nkae ma napein haꞌmuꞌit anbi baer meisꞌokan naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","On naan amsaꞌ, Uisneno nfee haan askaut ma naskau tuaf amfaun, mes In npiir ma nbetis naan ahaa bian reꞌ ka namfaun fa he njair Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anneen anrair Naiꞌ Yesus In uaban naan, atoin Farisis sin anꞌakoran he nakuu ma nakreo Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rarit sin nreek haefan sin aten ma tuaf naꞌko Herodes in partei purtik, he nataan Naiꞌ Yesus. Sin nanaib ma naꞌraatn Ee mnak, “Aam Tungguru! Hai mihiin mak Ho nekam naan amneꞌo. Ho ka mputa-kriu muhiin fa ma ka mpiir fa humaf. Ho munoniꞌ Uisneno In Kabin ma Prenat nok rek-reko. ");
INSERT INTO aaz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oras ia, hai mitaan maan Ko rais jes. Tatuin hit atoran pirsait Yahudi, hit ro he tbeos beo neu uis koꞌu keser Roma, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mes Naiꞌ Yesus nahiin nak sin he nakreo Goe, he In naꞌuab namouf anaꞌ prenat Roma. Onaim In nataah am nak, “Atoin puta-kriut ki! Nansaaꞌ am es hi he mikreo Kau nok rasi naan? ");
INSERT INTO aaz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mikriraꞌ miit Kau roi mutiꞌ fua es, reꞌ tuaf anpaek je he nbaen beo!” Onaim sin nakriraꞌ roi mutiꞌ fua es neu Ne. ");
INSERT INTO aaz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rarit In nataan sin im nak, “Sekau in human ma in kanan es reꞌ marunaꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sin natahan am nak, “Reꞌ naan keser, prenat Roma in uis koꞌu.” Onaim Naiꞌ Yesus natoon neu sin im nak, “Karu on naan ate, amfee meu preent ii saaꞌ reꞌ preent ii in hak. Ma mfee meu Uisneno saaꞌ reꞌ njair Uisneno In hak.” ");
INSERT INTO aaz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Anneen In nataah on naan ate, sin ok-okeꞌ nmasahun, In naꞌuab naan batuur. Es naan ate, sin ka bisa nakreo naan Ee fa. Onaim sin nnao nasaitan Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Anbi naan, anmuꞌi msaꞌ tuaf naꞌkon partei Saduki. Sin reꞌ ia nanoin ein am nak, atoin amaets ein ka bisa nmonin nfanin fa. Neno naan, sin namin ranan he nakreo Naiꞌ Yesus. Es naan ate, sin neman ma nataan Naiꞌ Yesus am nak, ");
INSERT INTO aaz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Aam Tungguru! Kaꞌo Musa antui nain kit atoran harat ia mnak: karu anmuiꞌ atoniꞌ nmate nporin in fee, mes ka nahoniꞌ fa riꞌanaꞌ, henaꞌ te atoniꞌ naan in oirf ee ro he nsao bifee banuꞌ naan, he nahoniꞌ nfee sufaꞌ neu in tataf amates naan. ");
INSERT INTO aaz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Batuur, unuꞌ te kaꞌo Musa nanoniꞌ on naan, mes oras ia hai he mitaan on nai: anmuiꞌ naan atoniꞌ tuaf hiut sin nmaꞌori-taatn ein. Aan moen unu nsao, mes anmaet ma ka nahoniꞌ fa. Onaim in orif reꞌ natuin ee ji nsao bifee banuꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka ꞌroo fa te, in nmaet ma ka nahoniꞌ fa. On naan amsaꞌ oirf es anteniꞌ; in nsao bifee banuꞌ naan, mes anmate ma ka nahoniꞌ fa msaꞌ. Matsaos naan nanaob on piut tar nasopu ntea aheit suus goe, mes in anmate msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Rarit bifee banuꞌ naan anmaet. ");
INSERT INTO aaz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Onaim oras ia, hai he mitaan on nai: bifee naan ansao niit atoniꞌ hiut. Oras pah-pinan ia namsopu te, Uisneno namonib nafaniꞌ amaets ein, bifee naan in moen je, es reꞌ mee?” ");
INSERT INTO aaz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rarit Naiꞌ Yesus nataah am nak, “Karu hi mitaan on naan, hi msaan koꞌu! Fin hi ka mihiin fa Uisneno In Suur Akninuꞌ In afan. Ma hi ka mihiin fa In kuasan reꞌ maꞌtaniꞌ msaꞌ! ");
INSERT INTO aaz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Batuurn ii, on nai. Oras Uisneno namonib nafaniꞌ amaets ein, sin ka nmatsao nteinꞌ ein fa on reꞌ In ameupt ein sonaf neno tunan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Au he uꞌuab amsaꞌ anmatoom nok amates anmoni nfain, aiꞌ kaah? Anbi kaꞌo Musa in surat anmuiꞌ retaꞌ hau aan es, reꞌ anpiin mes ka nputuf. Naꞌko retaꞌ naan hit tahiin tak, amates bisa nmoni nfain. Fin naan Uisneno natoon neu kaꞌo Musa mnak, ");
INSERT INTO aaz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au reꞌ ia, sin ho kaꞌo sin Uisneno. Esan reꞌ kaꞌo Abraham, kaꞌo Isak, ma kaꞌo Yakop. Sin arsin ok-okeꞌ naꞌruir ein ma naꞌbesan piut neun Kau ntean oras ia.’ Hi mihini mmak, oras Uisneno naꞌuab on naan, aꞌnaef ein naan anmaten nrarin aꞌroo-ꞌroo goen et unuꞌ. Mes Uisneno nak In njair sin Uisneon goa feꞌ. Es naan ate, hit tahiin tak, sin asmaank ein anmonin nkonon, maski sin nmate nrarin, mes sin nmonin nfanin. Fin suma atoin amonit es reꞌ naꞌruriꞌ ma naꞌbees neu Uisneno. Ka tiit fa amates naꞌbees neu Uisneno!” ");
INSERT INTO aaz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Anneen Naiꞌ Yesus nanoniꞌ on naan ate, tuaf ein naꞌkon partei Saduki sin ka bisa fa he nbaras saaꞌ-saaꞌ ntein. Mes too mfaun ein anmasahun ma naꞌuab ein am nak, “Amoo! Atoniꞌ ia, In noin ii maꞌtain reꞌuf!” ");
INSERT INTO aaz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Oras atoin Farisis sin annenan am nak, Naiꞌ Yesus niis anrair atoin Sadukis sin on naan ate, sin nabuan ok-okeꞌ he nataan Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sin tuaf ahinit es nbi rais pirsait, he nakreo nsobaꞌ Naiꞌ Yesus am nak, ");
INSERT INTO aaz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Aam Tungguru! Au he utaan on nai: hit haart ii in atoran ma rais pirsait ii in apreent ein, amfau reꞌuf. Naꞌko preent ein ok-okeꞌ reꞌ neman naꞌkon kaꞌo Musa naan, mee es reꞌ pentiing anneisi?” ");
INSERT INTO aaz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Onaim In nataah am nak, “Prenat reꞌ pentiing anneis anbi Uisneno In Suur Akninuꞌ naan nak, on nai: ‘Uisneno naan, hi Usiꞌ. Onaim hi ro he mneek Uisneno, anneis naꞌko areꞌ saaꞌ ii ok-okeꞌ. Es naan ate, hi ro he mimnau Goe piut-piut, mihiin mirek-reokꞌ Ee, ma mmeup maꞌtaniꞌ he mituin In romin.’ ");
INSERT INTO aaz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Prenat naan, es reꞌ pentiing anneis ma maꞌtaniꞌ nneis! ");
INSERT INTO aaz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma nmuiꞌ prenat es anteniꞌ, mnak on nai: ‘Ho ro he mneek ho aom-bian, on reꞌ ho mneek ho tuam aan kuum.’ ");
INSERT INTO aaz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Prenat noon nuaꞌ ein reꞌ ia, esan reꞌ naꞌuu ma naꞌbaꞌan naꞌkon kaꞌo Musa in atoran, ma Uisneno In mafefa kniunꞌ ein sin noinꞌ ein ok-okeꞌ. Tuaf ka bisa natuin fa prenat bian, karu sin ka natuin nahunun fa prenat noon nuaꞌ ein reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oras atoin Farisis sin nabuan feꞌe nbin naan ate, Naiꞌ Yesus nataan sin im nak, ");
INSERT INTO aaz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Naꞌko un-unuꞌ Uisneno anbaꞌan he nruur ma nreek Kristus he nsoi nafetin Iin na. Natuin hi peint ein ate, Kristus naan, sekau in sufan?” Onaim sin natahan am nak, “In reꞌ naan, usif naiꞌ Daut in sufan.” ");
INSERT INTO aaz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naiꞌ Yesus naꞌuab antein am nak, “Karu on naan ate, nansaaꞌ am es Uisneno In Asmaan Akninuꞌ natoon neu usif naiꞌ Daut he nteek Kristus nak ‘Usi’? Fin usif naiꞌ Daut antui mnak, ");
INSERT INTO aaz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Uisneno nꞌeut ma natoon neu au usiꞌ mnak, “Uum he mtoko mbi Au bnapak aꞌneꞌu, ambi bare reꞌ mahormataꞌ anneis-neisi. Fin Au of aꞌmoeꞌ ho muusn ein, tar antea sin naꞌruir ein neu ko.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Naꞌko surat naan, hit tahiin tak usif naiꞌ Daut amsaꞌ in neikn on anteek Kristus naan, ‘Usiꞌ’. Onaim karu anmuiꞌ tuaf nak Kristus naan, suma usif naiꞌ Daut in sufan, naan ka nanokab fa feꞌ! Natuin In njair usif naiꞌ Daut in Uisf amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Anneen Naiꞌ Yesus naꞌuab on naan ate, atoin Farisis sin anfeef aꞌtemen, ka tiit fa tuaf es reꞌ bisa nataah Naiꞌ Yesus amsaꞌ. Es naan ate, anmurai naꞌko neno naan, sin namtaun he natanan, ma sin ka nabranin fa ha nakreo ntein Ee. ");
INSERT INTO aaz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Rarit Naiꞌ Yesus nanoniꞌ In atoup noinꞌ ein, ma too mfaun ein reꞌ natuin sin. ");
INSERT INTO aaz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","In naꞌuab am nak, “Tunggur agaam ein ma atoin Farisis sin anmuꞌin hak he nanoniꞌ kaꞌo Musa in atoorn ein neu too mfaun. ");
INSERT INTO aaz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Onaim hi ro he mneen ma mitniin sin ma mituin sin noinꞌ ein naan. Mes kais mituin saaꞌ-saaꞌ reꞌ sin nmoeꞌ sin, natuin sin ka nmoeꞌ natuin fa saaꞌ-saaꞌ reꞌ sin nanoniꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sin naꞌsekeꞌ tuaf he nasaah ma nroi sin atoran rais pirsait reꞌ maꞌfenaꞌ. Mes sin tuak ein kuuk ka nromin fa he nturun ma nbaab tuaf he natuin atoran naan. ");
INSERT INTO aaz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Saaꞌ-saaꞌ reꞌ sin nmoeꞌ sin naan, henatiꞌ sin napenin boꞌis. On reꞌ: anmuiꞌ baer es, reꞌ matuaꞌ nok Uisneno In Kabin ma Prenat reꞌ mafutuꞌ nbi sin aꞌnaak ein ma sin aꞌniimk ein. Mes sin naꞌnaeb sin ein, ma sin namnanub sin tais ein sin fuuk ein, henatiꞌ tuaf bian nanaib sin im nak, ‘Sin reꞌ naan atoni kninuꞌ, joo!’ ");
INSERT INTO aaz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Karu sin ntaman neun uim onen, aiꞌ sin nokan anbin fesat, sin namin baer tokos reꞌ reko nneis, henatiꞌ too mfaun ein niit sin. ");
INSERT INTO aaz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Karu sin nnaon neun aꞌmasaꞌ, sin namin rais hormaat amsaꞌ. Sin nmoꞌen henatiꞌ atoniꞌ anhormaat sin im nak, ‘Tabe tua, aam tungguru mahormataꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mes hi kais mituin sin cara naan! Kais atoniꞌ nhaman ki mnak, ‘aam tungguru’, natuin hi Tunggur goe meseꞌ. Ma hi ar-arki reꞌ ia, ammaꞌori-tatan, mmabae-feton, ma mmabae-monen. ");
INSERT INTO aaz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kais maikas tuaf ambi pah-pinan ia mmak, ‘aam’, natuin hi Amaꞌ abit sonaf neno tunan meseꞌ kuun. ");
INSERT INTO aaz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atoniꞌ ka bole fa he nhaman ki mnak, ‘usiꞌ’, natuin hi Usiꞌ suma meseꞌ kuun, es reꞌ Au reꞌ ia, reꞌ Uisneno nruur ma nreek nain Kau naꞌko afi unuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Es naan ate, Au ꞌak hi kais maiks om nahuum on reꞌ tuaf-tuaf reꞌ namin rais hormaat. Sekau naꞌko hi arki reꞌ amroim he miꞌnae, in ro he nmoin nahuum on reꞌ ate reꞌ antuthae tuaf bian piut. ");
INSERT INTO aaz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Fin tuaf reꞌ nanaib on, Uisneno of nasaunt ee. Mes tuaf reꞌ naꞌbaun in tuan ee on reꞌ atoin aꞌbaut, Uisneno of nanaib ee.” ");
INSERT INTO aaz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi reꞌ naan, atoin puta-kriut ki! Hi of mipein siraak, natuin hi ka mpirsai Kau fa, Tuaf reꞌ Uisneno nbaꞌan he nreek Ee ntaam neem. Ma hi mmaufinu mneisi mtein, hi mꞌekaꞌ maan tuaf reꞌ neman he ntaman neun Uisneno In aprenat, he sin kais anpirsain neun Kau. ");
INSERT INTO aaz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi reꞌ naan atoin puta-kriut ki! Hi of mipein siraak, natuin hi mputa-kriu baun ein, rarit misiik maan sin umin. Mes anbi too mfaun ein maatk ein, hi miꞌkoroꞌ hi ꞌmoeꞌ maufinun naan, esan reꞌ hi mhake ma mꞌonen aꞌroo-ꞌroo he atoniꞌ nak hi neekm ein nakniunꞌ ein. Mes Uisneno of anfee ki hukun reꞌ maꞌfenaꞌ nneis. ");
INSERT INTO aaz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi reꞌ naan, atoin puta-kriut ki! Hi of mipein siraak, natuin hi msae bnao oe meu mee-mee, ma msae-msaun aꞌtoꞌef, suma he maim tuaf es aah, he in ntaam neu hi partei agama. Mes karu in ntaam anrair, hi mmoeꞌ in aꞌmoin ii njair maufinu nneisi ntein, tar antea in napein hukun anbi ai abar-barat maꞌfena nneis no nua naꞌko ki. ");
INSERT INTO aaz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hoe! Hi neekm ein nameisꞌokan, mes nansaaꞌ am es hi feꞌ he miruruꞌ ma mikriraꞌ ranan meu tuaf aꞌtetaꞌ ntein? Hi of mipein siraak natuin hi minoniꞌ tafiꞌ-tafiꞌ mmak, ‘Karu tuaf nait rais manbaꞌan anpaek supat ma nteek Uim Onen Uuf, tuaf naan ka nmafutuꞌ fa nok in rais manbaꞌan naan. Mes karu in nait rais manbaꞌan anpaek supat ma nteek bare mnatuꞌ reꞌ et Uim Onen naan, naꞌ in nmafutuꞌ nok rais manbaꞌan naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hi reꞌ ia atoin amonot ma aforot ki! Hi mitenab mak Uisneno naan bare mnatuꞌ pentiing anneis naꞌko Uim Onen Uuf? Kahaf! Fin Umi naan es reꞌ nmoeꞌ baerꞌ ein naan nakniunꞌ ein! ");
INSERT INTO aaz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hi minoniꞌ tafiꞌ-tafiꞌ msaꞌ am mak, ‘Karu atoniꞌ ansuup npaek supat ma nteek mei fuat reꞌ et Uim Onen Uuf, atoniꞌ naan ka nmafuut fa nok rais manbaꞌan naan. Mes karu in nait rais manbaꞌan anpaek supat ma nteek fuat reꞌ et mei je tunan, naꞌ in nmafuut nok rais manbaꞌan naan.’ ");
INSERT INTO aaz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hi reꞌ ia, amfoor batuur-batuur. Mei fuat reꞌ naan pentiing anneis naꞌko fuat reꞌ et mei je tunan. Fin mei naan, es anmoeꞌ tar antea atoniꞌ bisa nfee sin fuaꞌ-tuurꞌ ein neun Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Natuin rasi naan, karu atoniꞌ ansuup ma nteek mei fuat, naan nahuum on reꞌ in nteek mei naan, ma saaꞌ-saaꞌ ein ok-okeꞌ reꞌ etan mei naan in tunan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma karu atoniꞌ ansuup ma nteek Uim Onen Uuf, naan nahuum on reꞌ in nteek Uim Onen Uuf nok Uisneno In kanan. Fin In es reꞌ natua nbi naan. ");
INSERT INTO aaz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma karu atoniꞌ ansuup ma nteek sonaf neno tunan, naan nahuum on reꞌ in nteek Uisneno In aꞌtoko prenat nok In kanan, fin In es reꞌ nnaaꞌ aprenat anbi naan. ");
INSERT INTO aaz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi reꞌ naan, atoin puta-kriut! Hi of mipein siraak, natuin hi mihiin maꞌtaniꞌ he msoiꞌ bait boꞌ meu Uisneno. Hi msoiꞌ sin ok-okeꞌ, tar antea hi roet bumbu, hi msoiꞌ je mates amsaꞌ. On reꞌ hi msoiꞌ namnuut hi torereꞌ ma sipaꞌ, rarit aijonuus. Te kaah, hi mnikan main Uisneno In Atoran reꞌ pentiing anneisi! Fin hi ka mmoin fa nok amneꞌo ma namnoon. Hi ka mneek fa atoin amaꞌmuiꞌt ein. Ma hi ka mmoin fa piut-piut mituin Uisneno In romin. Reko nneis, hi mmoeꞌ mituin naan ok-okeꞌ feꞌ, naꞌ hi msoiꞌ hi bumbu sin, reꞌ he mfee sin meu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hi neekm ein nameisꞌokan, mes nansaaꞌ am es hi he miruruꞌ ma mikriraꞌ ranan meu tuaf bian antein? Hi miknutuꞌ atoran ma mreun biak ein nmoeꞌ natuin sin, mes Uisneno In atoran reꞌ pentiing anneis-neis naan, hi ka mituin ee fa. Naan nahuum on reꞌ hi mtai oe mninuꞌ he kais anmuꞌi kbenu. Mes bijae kouꞌ goes hi mꞌoor maan ee ꞌteme-ꞌteme! ");
INSERT INTO aaz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi arki atoin puta-kriut ki! Hi of mipein siraak, natuin hi msaef hi bare mnaaht ein tar antea narim-riman, mes naan suma nbi koit. Te kaah, in nanan nꞌoemeet natuin hi misiik ma mibaak nok rais sinmakat ma komat. ");
INSERT INTO aaz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hoe, hi atoin Farisis aforot ki! Amsaef hi bare mnaaht ein sin naank ein. Nok ranan naan, sin koitk ein of nakniunꞌ ein amsaꞌ! ");
INSERT INTO aaz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi arki atoin puta-kriut ki! Hi of mipein siraak, natuin hi on reꞌ faut rameꞌ anbi nopu. Atoniꞌ anseet ee nok seet mutiꞌ. Atoniꞌ nkisu te in koitn ee reok reꞌuf. Mes in nanan, naheun nok nuif naꞌko tuaf amates ma nafoo foo punuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hi on naan amsaꞌ! Hi mmoeꞌ jom on reꞌ atoni kninuꞌ. Atoniꞌ nkius niit ki on naan ate, sin nak hi atoin neek amneot ma amnonot ki. Te kaah, hi nekam nanan naheun nok rais maufinu. Natuin hi miꞌuab ate, aꞌtetaꞌ, ma mmoꞌe te, aꞌtetaꞌ, ma mnikan main Uisneno In apreent ein. ");
INSERT INTO aaz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hoe, hi tunggur agaam ein ma atoin Farisis ki! Hi arki atoin puta-kriut ki! Hi of mipein siraak! Hi mifenaꞌ faut nopu meu Uisneno In mafefa kniunꞌ ein, ma mhias faut nopun naan reok reuꞌf ein. ");
INSERT INTO aaz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mes hi mak, ‘Bait hit tmoin batan meseꞌ tok hit beꞌi-naꞌi sin ite, hit ka troor tiis fa mafefa kninuꞌ Uisneno sin.’ ");
INSERT INTO aaz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nok ranan naan, hi mitoon kiim am mak, hi reꞌ naan atoin amaufinut nahuum on reꞌ hi beꞌi-naꞌi sin. ");
INSERT INTO aaz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Onaim reko neis, hi mmaufiun piut tar antea namsoup, mituin hi beꞌi-naꞌi sin aꞌmoeꞌk ein reꞌ ansaan ma nbeon naan! ");
INSERT INTO aaz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hi arki ammaufiun batuur-batuur on reꞌ kaun araut. Hi mitenab am mak, of oniꞌ Uisneno ka nhukun ki fa, aiꞌ? Kais amharap ma mifnekan on naan! In of nait inporin ki meu ai pinaꞌ abar-barat! ");
INSERT INTO aaz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amneen mirek-rekoꞌ! Au of aꞌreek haefan Au haef ein, he sin nanoin ein ma naruruꞌ ki raan aꞌhonis amneot naꞌko Uisneno. Mes hi of amroor miis bian ma miꞌmaet bian anbin hau nehe. Bian hi mbeos sin anbin uim oen ein, ma bian anteniꞌ hi mhaꞌmuiꞌ sin, tar antea sin naenan naꞌkon kota es neu kota bian. ");
INSERT INTO aaz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Un-unuꞌ feꞌe te, hi naꞌi anroor niis naiꞌ Habel. Te kaah, naiꞌ Habel naan atoin neek amneot. Hi beꞌi-naꞌi naꞌmaet tuaf amneot ma amnonot sin piut-piut, naꞌko batan neun batan bian. Tar antea naiꞌ Sakarias, es reꞌ naiꞌ Barakia in anah. Sin naꞌmaet je anbi Uim Onen Uuf ee in kintal anpaumaak mei fuat. Natuin hi mituin hi beꞌi-naꞌi sin ꞌmoeꞌ maufinun, es naan ate, hi ro he misaah ma mitaah atoin neek amneot ma amnonot sin naaꞌ atꞌoops ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Batuur! Fin hi arki oras ia, hi of mipein hukun, natuin rais maufinun reꞌ hi beꞌi-naꞌi sin anmoeꞌ sin afi unuꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hi arki abitan Yerusalem! Hi es reꞌ biasa miꞌmaet Uisneno In mafefa kniunꞌ ein, ma mpoir miis In haef ein reꞌ neman he nturun ki. Au ꞌoꞌen ma ꞌfuir ki fani-fani he iim meu Kau, nahuum on reꞌ maun ainaf anpuput naan in aan ein anbin in ninin nanan. Mes hi ka mroim fa. ");
INSERT INTO aaz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Es naan ate, Uisneno ka nrae ma mfairoir fa hi umi. Rarit nokaꞌ-nmeu te, in ruman. ");
INSERT INTO aaz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Amneen mirek-rekoꞌ, joo! Fin hi ka miit amtein Kau fa, tar antea in oras hi mmanakuꞌ mmak, ‘Hai mtoit he Uisneno anfee tetus neu Tuaf reꞌ ia, natuin Uisneno es reꞌ anreek Ee.’ Hi mmanakuꞌ on reꞌ naan, es naꞌ hi miit amtein Kau.” ");
INSERT INTO aaz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Rarit Naiꞌ Yesus annao nasaitan Uim Onen Uuf. Oras In feꞌ npoi nnao te, In atoup noinꞌ ein neman ma naruruꞌ Uim Onen naan in arekon. ");
INSERT INTO aaz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mes In nataah sin im nak, “Umi ia batuur reokn ii kah een! Mes amneen mirek-rekoꞌ! Ka ꞌroo fa nteniꞌ te, sin naseer fatun ia ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Rarit Naiꞌ Yesus annao ntoko nbi ꞌtoꞌef Saitun. Onaim In atoup noinꞌ ein neman he naꞌuab anmes-mesen nok Ne. Sin naꞌuab ein am nak, “Aam! Mutoon mufaniꞌ kai saaꞌ reꞌ Ho muꞌuab ee feꞌe na. Of rekaꞌ te Ho mfain uum, tua? Ma in aꞌtaak ein on reꞌ mee? On mee nok neon amsoput naan amsaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Rarit Naiꞌ Yesus nataah am nak, “Ampanat hi tuam ein rek-reko, he kais napoi naan ki. ");
INSERT INTO aaz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Fin of anmuiꞌ tuaf humaꞌ-humaꞌ neman rarit anpaas ok am nak, ‘Au reꞌ ia Kristus, Tuaf reꞌ Uisneno anbaꞌan anrair Je naꞌko unuꞌ.’ Nok ranan naan, sin napoi too mfaun. ");
INSERT INTO aaz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Karu hi mkius makenat, aiꞌ hi mneen uab anin am nak, anmuiꞌ taisibu ma makenat et mee-mee, hi kais mimtau. Fin rasin reꞌ naan ro he njarin. Mes neon amsoput naan ka ntea fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Uuf es of anmakeen nok uuf bian. Pah es anmakeen nok pah bian. Of antainuun nbi mee-mee. Ma oras amnahas maꞌtain besi! ");
INSERT INTO aaz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mes naan ok-okeꞌ, feꞌ tanar ahunut reꞌ natoon am nak, oras neon amsoupt ii he neem een. Naan nahuum on reꞌ bifee reꞌ he feꞌ nmurai nnaben menas, natuin in oras he nahoniꞌ anpaumaak een. ");
INSERT INTO aaz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Onaim hi ro he mpanat hi tuam ein rek-reko! Sin of anhaꞌmuiꞌ ki ma nroor naꞌmaet ki. Ma tuaf naꞌko pah-pah of ka nroim nain ki fa, natuin hi mituinaꞌ Kau. ");
INSERT INTO aaz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Oras naan, too mfaun ii nkoit ma ka npirsain ntein Kau fa. Sin ka nmakaꞌroim ein fa, ma of anmaꞌsoos ein es nok es. ");
INSERT INTO aaz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Of anmuiꞌ aputa-kriut nak sin reꞌ naan, Uisneno In mafefa kninuꞌ. Ma too mfaun ii npirsai sin. ");
INSERT INTO aaz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Of tuaf ein sin maufiunk ein amfaun ma naꞌbaab ok antein, tar antea sin ka nmanekan fa es nok es. ");
INSERT INTO aaz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mes tuaf reꞌ naran ma ntahan piut-piut tar antea in nmaet, Uisneno of ansoi nafetin naan ee. ");
INSERT INTO aaz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Fin tuaf ro he natoon ma nasinaꞌ Uisneno In Rais Reko, tar antea pah-pinan ia no mes-meseꞌ, maut he bifee-atoniꞌ sin ok-okeꞌ nahiin Uisneno In raan aꞌhonis reꞌ batuur. Rarit naꞌ neon amsoupt ii neem.” ");
INSERT INTO aaz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Naiꞌ Yesus naꞌuab ankoon am nak, “Uisneno In mafefa kninuꞌ naiꞌ Daniel antui anmatoom nok tuaf reꞌ in maufinu maꞌtain reꞌuf. In of antaam anhaek neu baer nuni nbi Uisneno In Uim Onen Uuf. Nok ranan naan, in nhaiꞌniis bare naan. Es naan ate, Uisneno naikoit bare naan. Oras hi mkius miit on naan, ampaant om! (Sekau reꞌ anrees tuis ia, ro he nahiin narek-rekoꞌ!) ");
INSERT INTO aaz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Naan anjair tanar nak, neon suust ein anpaumaak een. Oras amkius on naan ate, abitan propinsi Yudea maen nai meu ꞌtoꞌef. ");
INSERT INTO aaz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Karu tuaf anpoi nrair naꞌko umi, kais anfain he nait bareꞌ ntein. Maen amkoon, maut he kais mipein siraak. ");
INSERT INTO aaz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tuaf reꞌ nbi rene ma poꞌon, kais anfain he nait tainusat antein. Maen amkoon nai! ");
INSERT INTO aaz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Reꞌ tkasian sin baineis-neis ii, es reꞌ bifee maꞌapuꞌ, ma bifee reꞌ nasuus riꞌana kruꞌuf. Te sin ka bisa naen nanan fa. ");
INSERT INTO aaz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Onaim reko nneis hi mꞌonen he siraak naan kais nateef nok oras naꞌuur, aiꞌ nateef nok neno snasat. ");
INSERT INTO aaz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Fin neno naan susat maꞌtaniꞌ! Anmurai naꞌko oras Uisneno nmoeꞌ pah-pinan tar antea oras ia, atoniꞌ ka nkius niit fa susat maꞌtaniꞌ nahuum on reꞌ naan. Ma atoniꞌ of ka nkius niit antein fa susat maꞌtaniꞌ nahuum on reꞌ naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mes hi mꞌua reok, fin Uisneno naꞌparan neno naan. Karu kaah fa te, ka tiit tain fa tuaf reꞌ ntahan he nmoin nabaar. Mes, natuin Uisneno nneek In tuaf ein reꞌ In npiir nain sin, es naan ate In naꞌparan neon suust ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Karu neno naan antea goen, hi mneen tuaf nak, ‘Amkius! Kristus es ia!’ Ma tuaf bian nak, ‘Kristus es nee!’ Mes hi kais ampirsai, joo! ");
INSERT INTO aaz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Fin of anmuiꞌ tuaf anpoi ma npaas ok nak, ‘Au reꞌ ia, Kristus!’ Ma bian antein nak, ‘Au reꞌ ia, Uisneno In mafefa kninuꞌ.’ Sin of anmoꞌen rais sanmakat humaꞌ-humaꞌ anpaken niutn ein sin kuasa he nputa-kriu atoniꞌ. Sin nsoob ein he napoi Uisneno Iin na msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Onaim hi ro he mpaant om rek-reko, joo! Neon suust ein naan ka ntean fa feꞌ, mes Au utoon ꞌain ki! ");
INSERT INTO aaz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Karu tuaf natoon ki mnak, ‘Kristus et amneraꞌ nee, joo!’ hi kais amnao meu nee. Ma karu nmuiꞌ tuaf nak, ‘Kristus et umi ia nanan!’, hi kais ampirsai sin aputa-kriut ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Fin Au reꞌ ia, Mansian Batuur-Batuur. Oras Au ꞌfain ꞌuum aꞌbi pah-pinan ia, too mfaun ii niit Kau, nahuum on reꞌ rimat reꞌ nariim naꞌko pasaꞌ maans ee ꞌsaen neu pasaꞌ neon-teas. ");
INSERT INTO aaz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Oras Au ꞌfain ꞌuum, hi of mihiin mak Au et mee. On reꞌ tuaf nahiin nak, karu nmuiꞌ koor amneuk puun ein nabu-buan anbin baer jes, naan anmuiꞌ punuꞌ et bare naan.” ");
INSERT INTO aaz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Rarit Naiꞌ Yesus naꞌuab antein, he natoon neu In atoup noinꞌ ein am nak, “Oras neon suust ein naan okeꞌ nrair, ‘Maans ee of anjair meisꞌokan, fuun ne ka masnaa fa ntein amsaꞌ. Kfuun ein of anbamoufun naꞌkon neon goe tnanan, ma kuasa et neon goe tnanan sin natseran.’ ");
INSERT INTO aaz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Rarit mansian ii niit tanar anbi neon goe tnanan nak, Mansian Batuur-Batuur ii he nkoen On anfain neem. Ankisun on naan ate, uuf-uuf ma pah-pah abitan pah-pinan namtaun tar antea sin ankaen. Au of aꞌsaun ꞌuum aꞌbi nope, naꞌ mansian ii niit Au kuasat ma Au ꞌpinaꞌ ma krahaꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Rarit Au ꞌpaek toꞌis reꞌ in haan ee maꞌtaniꞌ he uprenat Uisneno In ameupt ein etan sonaf neno tunan annaon naꞌbuaꞌ tuaf reꞌ Au ꞌpiir ꞌaan sin naꞌkon pah-pinan ia pani-mpain, naꞌko pasaꞌ maans ee ꞌsaen tar antea pasaꞌ neon-teas, naꞌko pasaꞌ ponain tar antea pasaꞌ haaꞌ-nua.” ");
INSERT INTO aaz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Au ꞌpake ꞌtopeꞌ naꞌko hau. Karu in noon ein nmurai namnaut moor ein, naan anjari ꞌtakaf nak, oras fauk nais ii he ntaam een. ");
INSERT INTO aaz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","On naan amsaꞌ, oras hi mkius neon suust ein neman, on reꞌ Au utoon ꞌain ki, tanar naan ꞌak, oras he Au ꞌuum ii npaumaak een. ");
INSERT INTO aaz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Oras ia, mneen mirek-rekoꞌ! Naꞌko mansian ii ok-okeꞌ reꞌ nmonin oras ia, of anmuiꞌ tuaf reꞌ ka nmaet fa feꞌ, oras neon suust ein naan neman. ");
INSERT INTO aaz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maski neon goe ma pah-pinan ia namnekun, mes Au aꞌat ma kabin sin nabar-baran kuuk.” ");
INSERT INTO aaz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ka tiit fa tuaf reꞌ nahiin oras Au ꞌfain ꞌuum. Uisneno In ameupt ein et sonaf neno tunan, ka nahinin fa msaꞌ. Au kuuk, ka uhiin fa msaꞌ. Suma Au Amaꞌ kuun es reꞌ nahini nmees. ");
INSERT INTO aaz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Fin Au reꞌ ia, Mansian Batuur-Batuur. Oras Au ꞌfain ꞌuum, nahuum on reꞌ un-unuꞌ oras naiꞌ Noh anmoin feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noe sakoꞌ naan ka nsaen sin fa feꞌ, mansian ii nbukaen amin-minat, ma nmatsaon on reꞌ biasa. Sin nmoꞌen on reꞌ naan piut-piut, tar antea naiꞌ Noh antaam neu bnao koꞌu naan. ");
INSERT INTO aaz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mes oras noe sakoꞌ ansaen sin, naꞌ sin maatk ein natfeꞌin, he sin nahinin saaꞌ reꞌ njair naan. On naan amsaꞌ, oras Au ꞌfain ꞌuum. ");
INSERT INTO aaz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Anbi oras naan, karu tuaf nua antofan nbin rene, nok askeken ate, Uisneno nait neik es, ma namaikaꞌ es. ");
INSERT INTO aaz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Karu bifee nua napaun makaꞌ, nok askeken ate, Uisneno nait neik es, ma namaikaꞌ es. ");
INSERT INTO aaz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Es naan ate, hi ro he mpao ma mpanat ansuun oras et fai ma manas, fin hi ka mihiin fa oras reꞌ rekaꞌ te, hi Usiꞌ ankoen On anfain neem. ");
INSERT INTO aaz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mitenab mirek-rekoꞌ! Karu anmuiꞌ uim tuaf reꞌ nahiin neu abaakt ee he ntaam mabeꞌ ia, in ro he npao ma npanat piut-piut, maut he abaakt ee kais antaam neu uim je nanan. ");
INSERT INTO aaz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Onaim hi ro mibaarb om batuur-batuur. Fin oras Au ꞌfain ꞌuum reꞌ naan, nok askeekn aah!” ");
INSERT INTO aaz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Hi ro he mjair on reꞌ ameput reꞌ natuin in uisn ee romin. Karu in uisn ee he nnao neu bare ꞌroo, in nait ameput on reꞌ naan, he nꞌurus mnahat ma mninut neu in uim je nanan. ");
INSERT INTO aaz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Karu in uisn ee nfain neem ma nkius niit in ameput naan anmeup rek-reko, ro tebes in of anmariin nok ameput naan. ");
INSERT INTO aaz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ampirsai Kau, fin usiꞌ naan of anfee kuasa neu ameput naan, he nꞌurus in aꞌmuiꞌk ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mes karu ameput naan maufinu, in of natenab anbi in nekan am nak, ");
INSERT INTO aaz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Reko! Usiꞌ nnao on nai te, sekau nahiin oras usiꞌ nfain neem, oo!’ Natenab on naan ate, in nmurai nbeos ma npokos ameput bian. Ma in ntoko ma naah-niun amin-minat nok amauft ein. ");
INSERT INTO aaz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mes feꞌ ka natenab naan fa saaꞌ-saaꞌ, nok askeken ate, in uisn ee nfain neem. ");
INSERT INTO aaz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Onaim usif naan anhaꞌmuiꞌ je maꞌtaniꞌ, rarit nait inpoirn ee neu moneꞌ, he in nabua nok atoin aputa-kriut ein. Anbi bare naan, sin ok-okeꞌ ankaen npin-piuns ein, natuin sin napenin susat ma nanaꞌrenat maꞌtaniꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Rarit Naiꞌ Yesus naꞌuab antein anmatoom nok Uisneno In aprenat am nak, “Hi ro he mibarab mirek-rekoꞌ he mseun Kau, on reꞌ retaꞌ reꞌ ia. On nai: neot es, anmuiꞌ bifee munif boꞌes, reꞌ npoin nbin oras fai ma neik ein paku, he nnao nseun baroit atoniꞌ nbi sin partei je in umi. ");
INSERT INTO aaz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mes naꞌko tuaf boꞌes naan, anmuiꞌ tuaf niim reꞌ anmonon, ma tuaf niim reꞌ nahinin. ");
INSERT INTO aaz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tuaf niim reꞌ anmonon naan ka neikin fa minaꞌ anneis. ");
INSERT INTO aaz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mes tuaf niim reꞌ nahinin, sin neik nanin minaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Antean umi naan, baroit atoin ee ka neem fa feꞌe msaꞌ. Aꞌroo-ꞌroo te bifee muinf ein naan anreur ein nmaten, onaim sin ntupan nfinin. ");
INSERT INTO aaz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Te kaah, fai je natnaan ate, sin annenan atoniꞌ nkoaꞌ ma nsakanan am nak, ‘Hoi! Baroit ee neem een, oo! Iim he tnao tseun goe!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Annenan on naan ate, bifee muinf ein naan anfenan ok-okeꞌ. Rarit sin nabarab sin pakun. ");
INSERT INTO aaz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mes bifee muinf ein reꞌ anmonon naꞌuab nok sin partei ngguin am nak, ‘Hae, baꞌe sin! Ambait maan kai miin aꞌkreꞌo. Hai paukn ii he noi nmaet neen!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mes bifee muinf ein reꞌ nahinin natahan am nak, ‘Amoo! Kais mitooꞌ, mes ka bisa fa. Fin hai miin ein ka nanokab fa neu kit ok-okeꞌ! Reko nneis hi mnao msoos minaꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Onaim sin annaon nsosan minaꞌ. Mes oras sin npoin nnaon, baroit naan neem antea goen. Rarit bifee muinf ein reꞌ nahinin sin ntaman natuin ein anbin baer fesat, nabuan nok baroit ma taumn ein ok-okeꞌ. Sin arsin antaman neun uim je nanan, onaim sin naꞌeek enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Rarit bifee muinf ein reꞌ anmonon neman amsaꞌ. Sin nhaamn ein am nak, ‘Usiꞌ! Usiꞌ! Musoin kai eonꞌ ii feꞌ, tua!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mes in nataah am nak, ‘Hoe, ka bisa fa. Au ka uhiin ki fa!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Es naan ate, hi ro he mibarab batuur-batuur he mhaat ma mpao piut-piut, fin hi ka mihiin fa msaꞌ am mak, oras Au ꞌfain ꞌuum nateef nok neon saaꞌ, aiꞌ nreuk fauk.” ");
INSERT INTO aaz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rarit Naiꞌ Yesus naꞌuab retaꞌ es antein am nak, “Oras Au usaitan ki, hi ro he mmeup rek-reko meu Kau, nahuum on reꞌ retaꞌ reꞌ ia. On nai: anmuiꞌ naan uisf es he nnao neu bare ꞌroo. Oras in nabarab he nnao, in noꞌen in ameupt ein, rarit in naprenat sin im nak, ‘Hi mpaek reꞌ roit reꞌ ia njair modal. Oras au ꞌfain ꞌuum ate, hi ro he mitoon kau mmak, hi miis fauk een.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Rarit in nfee neu in ameput ahuunt ee noni-roit ꞌkaroꞌ niim, he in nasufab roit ein naan. Rarit in ameput no nuan ii ntoup roit ꞌkaroꞌ nua. Ma ameput no teun ii ntoup roit aꞌkaor es, natuin sin es-es ate sin aꞌbeiꞌk ein. Rarit in nkoen on neu bare ꞌroo. ");
INSERT INTO aaz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Antoupu nrair roit ein naan, ameput ahuunt ee nnao nrakan. Ka ꞌroo fa te, in niis naan roit ꞌkaroꞌ niim antein. ");
INSERT INTO aaz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","On naan amsaꞌ ameput no nuan ii. In niis naan roit ꞌkaroꞌ nua ntein. ");
INSERT INTO aaz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mes ameput no teun ii reꞌ ntoup roit aꞌkaor meseꞌ naan, in nnao nhain konaꞌ, he naꞌkoroꞌ in uisn ee roit ein naan. ");
INSERT INTO aaz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aꞌroo-ꞌroo te, usif naan neem. Rarit in nabuab in ameupt ein he nmurai nparikas in roit ein reꞌ sin nꞌurus sin naan. ");
INSERT INTO aaz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ameput ahuunt ee ntaam ma nnonaꞌ roit ꞌkaroꞌ boꞌes. Rarit in nak, ‘Usiꞌ! Ia ho roit ein. Neon goes ii ho mnonaꞌ kau roit ꞌkaroꞌ niim. Mes oras ia, au ꞌiis ꞌaan kuuk aꞌkaroꞌ niim aꞌtein.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Anneen on naan ate, in uisn ee nmariin. In naꞌuab am nak, ‘Reko! Ho reꞌ ia, ameup reko. Ho mmakoe, ma mutuin meu au prenat, maski au ka ꞌbi fa ia. Natuin ho bisa mꞌurus rais aanꞌ-anaꞌ on reꞌ ia, au of ꞌait ko he mꞌurus rasi bian reꞌ koꞌu nneisi ntein. Au of aꞌmoeꞌ fesat he hit tmariin ok-okeꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Rarit ameput no nuan ii neem annonaꞌ in uisn ee roit ꞌkaroꞌ haa mnak, ‘Usi! Neon goes ii ho mnonaꞌ kau roit ꞌkaroꞌ nua. Amkius kuum, au ꞌiis ꞌaan kuuk roit aꞌkaroꞌ nua ꞌtein.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Usif naan anmariin msaꞌ. In naꞌuab am nak, ‘Reko! Ho reꞌ ia, ameup reok goes amsaꞌ. Ho mmakoe, ma mutuin meu au prenat, maski au ka ꞌbi fa ia. Natuin ho bisa mꞌurus rais aanꞌ-anaꞌ on reꞌ ia, au of ꞌait ko he mꞌurus rasi bian reꞌ koꞌu nneisi ntein. Au of aꞌmoeꞌ fesat he hit tmariin ok-okeꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Rarit ameput no teun ii neem. Onaim in natoon am nak, ‘Usiꞌ! Au uhiin ꞌak ho atoin maputuꞌ ko. Fin ho mait saaꞌ reꞌ biak ein anmoꞌe, ma mseu saaꞌ reꞌ biak ein anseen sin. ");
INSERT INTO aaz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Au umtau, tua. Kais-kaisaꞌ roit ein ia namnekun, rarit ho mhukun kau. Es naan ate, au uꞌkoro urek-rekoꞌ sin. Sin esan reꞌ ia, aam! Amtoup mufaniꞌ sin, fin ho roit aꞌkaor meseꞌ reꞌ ia ka saaꞌ-saaꞌ fa, tua.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Anneen on naan ate, in uisn ee naskaar ee mnak, ‘Ho reꞌ ia ameput reꞌ maufinu ma apehet! Karu ho muhiin main mak, au ꞌait saaꞌ reꞌ biak ein anmoꞌe, ma au ꞌseu saaꞌ reꞌ biak ein anseen sin, ");
INSERT INTO aaz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nansaaꞌ am es ho ka mutunuꞌ fa au roit ii meu bank? He au ꞌfain ꞌuum ate, au bisa upein in sufan, maski kreꞌ-reꞌo msaꞌ, reko!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Rarit usif naan anreun in ameput bian am nak, ‘Mait roit ein naꞌkon tuaf ia, he mnonaꞌ sin meu ameput reꞌ niis roit ꞌkaroꞌ niim naan. ");
INSERT INTO aaz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Fin tuaf reꞌ anꞌurus rek-reko saaꞌ reꞌ in nnaaꞌ ee, in of napeni mfaun antein. Mes tuaf reꞌ ka nꞌurus fa saaꞌ reꞌ in nnaaꞌ ee naan, of nait nain sin ok-okeꞌ naꞌko in tuan. ");
INSERT INTO aaz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amheek ameput reꞌ ka mapakeꞌ fa ia. Amheer amfonat ma mait impoir ne meu moneꞌ. Maut he in nkae nok haꞌmuꞌit anbi baer meisꞌokan naan!’ ” ");
INSERT INTO aaz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Au, Mansian Batuur-Batuur reꞌ ia, of aꞌsaun ꞌuum aꞌpaek Au Amaꞌ In kuasan reꞌ mapinaꞌ-makrahaꞌ, ubua ꞌok In ameupt ein naꞌkon sonaf neno tunan. Rarit Au ꞌtoko ꞌbi Au ꞌtokoꞌ prenat reꞌ mapinaꞌ-makrahaꞌ nneis, he uprikas mansian ein ok-okeꞌ sin aꞌmoink ein. ");
INSERT INTO aaz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mansian ii ok-okeꞌ reꞌ nmoin niit anbin pah-pinan ia, of neman nbaisenun Kau. Rarit Au ꞌbatis sin, nahuum on reꞌ atukus reꞌ nbatis ꞌbib-kase naꞌko ꞌbibi, he njair pukan nua. ");
INSERT INTO aaz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tuaf-tuaf reꞌ nmoin natuin Uisneno In romin, Au ꞌtao sin anbin Au bnapak aꞌneꞌu. Mes tuaf bian, Au ꞌtao sin anbin Au bnapak aꞌrii. ");
INSERT INTO aaz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oras naan, Au ꞌnaaꞌ aprenat nahuum on reꞌ Usif. Au of utoon ꞌeu tuaf ein reꞌ anbin Au bnapak aꞌneꞌu mꞌak, ‘Hi reꞌ ia, es reꞌ mtoup tetus-athoen miꞌko Au Amaꞌ. Iim he mtaam meu In uim je nanan reꞌ In nabarab nain je naꞌko un-unuꞌ neu ki. ");
INSERT INTO aaz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Au ꞌfee ki haan askaut, natuin unuꞌ feꞌ oras Au umnaah, hi es amfee Kau bukaet. Oras Au ꞌmeon, hi mfee Kau oe mninut. Au ꞌuum ate on reꞌ atoin kase, mes hi mtoup Kau ꞌbi hi umin. ");
INSERT INTO aaz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au ka ꞌmuiꞌ fa pake-nohas, mes hi msoo mfee Kau. Au umeen, hi es reꞌ iim amꞌurus Kau. Au ꞌbi bui, hi es reꞌ iim amkius Kau.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Annenan on naan ate, tuaf ein reꞌ neek amneꞌo nbin Au bnapak aꞌneꞌu naan, of natahan am nak, ‘Usiꞌ, on mee es reꞌ ia? Usiꞌ mak, Ho mumnaah, rarit hai mfee Ko bukaet. Ho mmeon oe, rarit hai mfee Ko oe mninut amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ho on reꞌ atoin kase, rarit hai mtoup Ko he mtaam meu hai umi. Ho ka mmuiꞌ fa pake-nohas, rarit hai msoo mfee Ko, tua. ");
INSERT INTO aaz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ho mumeen, rarit hai mnao mꞌurus Ko. Ho mbi bui, rarit hai mnao mturun Ko. Mes anbi oras mee, hai mmoeꞌ rasin reꞌ naan, tua?’ ");
INSERT INTO aaz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Au of utaah sin im ꞌak, ‘Ampirsai Kau! Fin oras hi mmoeꞌ rasin naan meu Au ngguin, maski mmoeꞌ meu tuaf reꞌ ka mapakeꞌ fa msaꞌ, reꞌ naan hi mmoꞌe mfee Kau goe!’ ");
INSERT INTO aaz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Rarit Au uꞌuab ꞌeu tuaf ein reꞌ nbin Au bnapak aꞌrii mꞌak, ‘Atoin maufinu ki! Uisneno nkaas anrair ki. Miꞌroo nai miꞌko ia! Au of aꞌreun tuaf he nnao nporin nataam ki meu ai abar-barat. Fin Uisneno nabarab anrair baer haꞌmuꞌit ma maꞌneꞌat naan neu niutn ein ma sin uis koꞌu. ");
INSERT INTO aaz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Au ꞌriꞌu ꞌporin ki, natuin oras Au umnaah, hi ka mfee Kau fa bukaet. Oras Au ꞌmeon oe, hi ka mfee Kau fa oe mninut. ");
INSERT INTO aaz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au ꞌuum on reꞌ atoin kase, mes hi ka mtoup Kau fa meu hi umi. Au ka ꞌmuiꞌ fa pake-nohas, mes hi ka msoo mfee Kau fa. Au umeen, mes hi ka iim fa he mꞌurus Kau. Au ꞌbi bui, mes hi ka iim fa he mturun Kau.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Annenan on naan ate, atoin maufiun ein of natahan am nak, ‘Usiꞌ, on mee es reꞌ ia? Usiꞌ mak Ho mumnaah, mes hai ka mfee Ko fa bukaet. Ho mmeon oe, mes hai ka mfee Ko fa oe mninut. Ho on reꞌ atoin kase, mes hai ka mtoup Ko fa meu hai umin. Ho ka mmuiꞌ fa pake-nohas, hai ka msoo mfee Ko fa. Ho mumeen, mes hai ka mnao he mꞌurus Ko fa. Ho mbi bui, mes hai ka mnao mturun Ko fa. Mes anbi oras mee reꞌ hai mmoeꞌ Ko on reꞌ naan, tua?’ ");
INSERT INTO aaz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Au of utaah sin im ꞌak, ‘Ampirsai Kau! Oras hi ka mturun fa tuaf ein reꞌ ka mapakeꞌ fa, reꞌ naan hi ka mturun Kau fa.’ ");
INSERT INTO aaz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rarit atoin maufiun ein napenin haꞌmuꞌit ma maꞌneꞌat piut-piut tar antea nabar-baar. Mes neu tuaf reꞌ neek amneot ma amnonot, sin napenin ꞌmonit piut-piut nok Uisneno tar antea nabar-baar.” ");
INSERT INTO aaz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Oras Naiꞌ Yesus nanoniꞌ nrair rasin reꞌ naan ok-okeꞌ neu sin, In naꞌuab neu In atoup noinꞌ ein am nak, ");
INSERT INTO aaz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hi mihini mrair, neno nua amnemat, hit neon koꞌu, es reꞌ Fesat Paska ntea goen. Oras naan, of anmuiꞌ tuaf reꞌ naꞌsosaꞌ Kau, Mansian Batuur-Batuur reꞌ ia. Rarit sin nkuus naꞌmaet Kau nbi hau nehe.” ");
INSERT INTO aaz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Neno naan, aꞌnaak pirsait Yahudi sin aꞌnaakt ein, ma atoni mnais haart ein nabuan nbin naiꞌ Kayafas in umi. Naiꞌ Kayafas naan, es reꞌ aꞌnaak pirsait Yahudi sin aꞌnaak koꞌu. ");
INSERT INTO aaz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sin namin ranan he nheek Naiꞌ Yesus amninuꞌ-mninuꞌ, he naꞌmaet Je. ");
INSERT INTO aaz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mes sin nꞌator asraak am nak, “Amtahan feꞌ! Hit kais atmanaap he theek Je, natuin neon koꞌu goe npaumaak een. Kais-kaisaꞌ too mfaun ein reꞌ anroim Je, napoit ein taisibu.” ");
INSERT INTO aaz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Anbi kuan Betania, anmuiꞌ tuaf es, kaan ee naiꞌ Simon. Unuꞌ te, atoniꞌ nmaiꞌniis ne, natuin in nameen meen nui-atrokiꞌ. Mes oras ia, in nareko nrair. Oras neon koꞌu naan ka ntea fa feꞌ, Naiꞌ Yesus sin annaon nbukaen nbin naiꞌ Simon in umi. ");
INSERT INTO aaz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Oras sin anbukaen ate, anmuiꞌ bifee jes neem nateef nok Naiꞌ Yesus. In nnaaꞌ bootr es, reꞌ anmoeꞌ je naꞌko faut maꞌosaꞌ. Botor naan narai miin foo meniꞌ reꞌ maꞌoos reꞌuf. Rarit bifee naan ntuut nareuꞌ bootr ee toben. Onaim in nꞌoop minaꞌ naan akreꞌo-kreꞌo neu Naiꞌ Yesus In aꞌnakan, he njair tanar am nak, in nhormaat Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mes oras Naiꞌ Yesus In atoup noinꞌ ein ankius bifee naan anmoeꞌ on naan ate, sin natoꞌon ma naꞌuab ein am nak, “Hoe! In kais anporin miin foo meniꞌ reꞌ maꞌoos reꞌuf ia! ");
INSERT INTO aaz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Reko nneis in naꞌsosaꞌ miin foo meniꞌ ia, maut he in roit ein, in nfee sin neun amaꞌmuiꞌt ein!” ");
INSERT INTO aaz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mes Naiꞌ Yesus nahiin sin teenb ein naan, onaim In naꞌuab am nak, “Hi kais misusab bifee ia! Maut he in nmoeꞌ on reꞌ naan! Au ꞌmariin, natuin in nꞌoop miin foo meniꞌ ia neu Au aok ii. ");
INSERT INTO aaz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Amaꞌmuiꞌt ein et hi sonam ma hi tnanam piut-piut. Mes ka ꞌroo fa te, Au reꞌ ia, ka ubua ꞌok ki fa heen. ");
INSERT INTO aaz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nok ranan reꞌ bifee ia naꞌpeeh Kau npaek miin foo meniꞌ reꞌ ia, in nabarab anrair Au aok ii, he nkakiꞌ nain fubonaꞌ neu Au aok amates. Fin Au ꞌmoink ii ka ꞌroo fa heen. ");
INSERT INTO aaz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mimnau mirek-rekoꞌ, joo! Anbi bare mee-mee jah, oras Uisneno In Rais Reko nanaob on anfuun am nateef anbi pah-pinan ia, sin of naretaꞌ anmatoom nok bifee reꞌ ia in arekon! Maut he mansian ii ok-okeꞌ namnau goe.” ");
INSERT INTO aaz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Anmuiꞌ tuaf es naꞌko Naiꞌ Yesus In atoup noniꞌ tuaf boꞌes am nuaꞌ ein reꞌ naan, kaan ee naiꞌ Judas Iskariot. Neno naan, in anpoi nnao naim aꞌnaak pirsait Yahudi sin aꞌnaakt ein, he nnonaꞌ Naiꞌ Yesus neu sin. ");
INSERT INTO aaz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Antea on naan ate, in nataan am nak, “Sin amaꞌ arki! Karu au ꞌturun ki he hi mheek Naiꞌ Yesus naan, hi mfee kau saaꞌ?” Onaim sin natahan am nak, “Karu ho mroim he muꞌsosaꞌ Naiꞌ Yesus meu kai te, hai mbaen.” Rarit sin nsoꞌin roi mutiꞌ fua boꞌ teun ma nnonaꞌ sin neun naiꞌ Judas. ");
INSERT INTO aaz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Rarit naiꞌ Judas anpoi, onaim in naim ranan he nnonaꞌ Naiꞌ Yesus neu sin. ");
INSERT INTO aaz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Toon baniꞌ toon, atoin Yahudis sin anmuiꞌ neon koꞌu reꞌ aꞌroon ii neno hiut. Sin nteek neon koꞌu naan nak, ‘Fesat Utunuꞌ ka Mamuur fa’. Oras fesat naan he nmurai jen, Naiꞌ Yesus In atoup noinꞌ ein neman ma nataan Ee mnak, “Aam! Mabeꞌ ia, hit ro he tmurai tanaob hit neon koꞌun ia. Onaim Ho mroim he hai mroro ꞌbib-kase ma mibarab baer fesat Paska on mee, tua?” ");
INSERT INTO aaz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rarit In nataah am nak, “Hi mtaam meu kota, hi of miteef mok atoin es. Mitoon ee mak on nai, ‘Baꞌe! Hai Aam Tungguru annaben neu ka ꞌroo fa ntein ate In he nmaet jen. Onaim In ntoit bare nbi ho umi, he In npaek je he ntao fesat Paska nok In atoup noinꞌ ein.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Annenan on naan ate, In atoup noinꞌ ein annaon nmoꞌen natuin In uaban naan. Rarit sin nabaarb ein bukae fesat Paska nbin naan. ");
INSERT INTO aaz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Oras fai te, Naiꞌ Yesus nok In atoup noniꞌ tuaf boꞌes am nuaꞌ ein naan antokon ma nbukaen fesat. ");
INSERT INTO aaz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oras sin nbukaen, In naꞌuab am nak, “Hi mneen, oo! Anmuiꞌ tuaf es naꞌko ki, of es reꞌ naꞌsosaꞌ Kau neu biak ein.” ");
INSERT INTO aaz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Annenan on naan ate, sin neek ein ka ntainiin ein fa. Onaim sin es-es ate nataan kuun Naiꞌ Yesus am nak, “Tuaf reꞌ Ho muꞌuab ee naan, ka au fa, oo?” ");
INSERT INTO aaz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Onaim In nataah am nak, “Tuaf reꞌ narepaꞌ utunuꞌ nbi ꞌpik-oef nok Kau, in es reꞌ naꞌsosaꞌ Kau. ");
INSERT INTO aaz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mimnau! Au, Mansian Batuur-Batuur reꞌ ia, ro he ꞌmaet on reꞌ sin ntui nain je nbi Uisneno In Suur Akninuꞌ. Mes mikeo! Tuaf reꞌ naꞌsosaꞌ Kau naan, in of nasaah kuun in siraak! Reko nneis in ainf ee kais nahoins ee!” ");
INSERT INTO aaz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Rarit naiꞌ Judas nataan amsaꞌ am nak, “Tuaf reꞌ Ho muꞌuab ee naan, ka au fa, oo?” Onaim Naiꞌ Yesus nataah am nak, “Ho kuum es muꞌuab on naan. He sekau ntein?” ");
INSERT INTO aaz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Oras sin nbukaen feꞌ, Naiꞌ Yesus nait utunuꞌ fuaꞌ es, ma ntoit makasi neu Uisneno. Rarit In nteib utunuꞌ naan, ma nnonaꞌ neu In atoup noinꞌ ein, ma naꞌuab am nak, “Utunuꞌ reꞌ ia, Au aok. Mait he mbukae nai, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Rarit In nait ikraas es naheun nok tua min-kase, ma ntoit makasi neu Uisneno. Rarit In nnonaꞌ neu In atoup noinꞌ ein, ma naꞌuab am nak, “Hi arki mait he mbukae nai, tua. ");
INSERT INTO aaz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Fin tua min-kase ia, Au naaꞌ. Au of aꞌmaet, Au naaꞌ ii natꞌoop ma nsai he nsoi naan too mfaun ein sin saant ein. Naaꞌ reꞌ ia njair tanar he mimnau mak, saaꞌ reꞌ Uisneno nbaꞌan anrair je, oras ia njair teb-tebe. Mait he mbukae nai, tua! ");
INSERT INTO aaz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mes amneen mirek-rekoꞌ! Anmurai naꞌko mabeꞌ ia, Au ka ꞌinu ꞌtein fa tua min-kase. Of oras Au ꞌok Au Amaꞌ mtook ma mnaaꞌ aprenat ambi sonaf neno tunan, naꞌ Au ꞌbukae ꞌtein ꞌok ki.” ");
INSERT INTO aaz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rarit sin nsiin siit es he npures ma nboꞌis Uisneno. Rarit mabeꞌ naan amsaꞌ, sin anpoi nnaon neun aꞌtoꞌef Saitun. ");
INSERT INTO aaz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oras sin annaon ate, Naiꞌ Yesus natoon nain In atoup noinꞌ ein am nak, “Mabeꞌ ia, hi arki of maen misaitan Kau. Fin matuꞌi nain et Uisneno In Suur Akninuꞌ mnak, ‘Uisneno of naꞌmaet atukus, rarit in aꞌbib-kaesn ein naenan nsiksakn ok.’ ");
INSERT INTO aaz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Au ꞌmaet batuur. Mes oras Au ꞌmoni ꞌfain, Au ꞌnao uhunun ki ꞌeu propinsi Galilea.” ");
INSERT INTO aaz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mes naiꞌ Petrus anprotees am nak, “Aam! Maski tuaf bian naen nasaitan Ko, mes au kaah fa, tua!” ");
INSERT INTO aaz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Onaim Naiꞌ Yesus nataah am nak, “Tebe, oo, Peꞌu? Ampirsai Kau! Mabeꞌ ia, maun goe ka nkokreoꞌ fa feꞌe te, ho musuan Kau no teun goen mak, ho ka muhiin Kau fa!” ");
INSERT INTO aaz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mes naiꞌ Petrus naheer am nak, “Kaah fa, tua! Karu Ho mmaet, au ꞌmaet ꞌok Ko msaꞌ. Fin au ka ꞌeu fa he ꞌaen usaitan Ko, tua!” Naiꞌ Petrus in partein ngguin naꞌuab ein on reꞌ naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Rarit Naiꞌ Yesus sin annao nkonon neun aꞌtoꞌef Saitun, antean nbin poꞌon es, kaan ee Getsemani. Anbi naan In natoon neu In atoup noinꞌ ein am nak, “Hi mtook mtahan ambi ia, Au he ꞌnao ꞌonen ꞌeu reꞌ nee.” ");
INSERT INTO aaz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mes In nhaman neik naiꞌ Petrus, naiꞌ Yakobus, ma naiꞌ Yohanis, he sin teun sin nok Ne. Anmurai naꞌko oras naan, In neekn ee nsuus ma ka ntaininaꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sin feꞌ nnao naan aꞌkreꞌo, In naꞌuab neu sin im nak, “Au neek ii nsuus anmaet! Au ꞌnaben ate on reꞌ he ꞌmaet een. Hi mtook ma mpao mok Kau mbi reꞌ ia feꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Rarit In nnao naꞌroo kreꞌo, onaim In nriꞌtuu ma nꞌonen am nak, “Aam Honiꞌ! Karu Ho mromi te, Au kais usaah maꞌneꞌat reꞌ ia. Mes kais mutuin Au romik, maut he mutuin Ho roim aan kuum, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anꞌonen anrair on naan ate, In nnao nfain neu In atoup noniꞌ tua teun ein naan. Mes sin ntupan nfinin. Rarit In npooꞌ nafenaꞌ sin, ma In naꞌuab nok naiꞌ Petrus am nak, “Hae Peꞌu! Hi mtuup neu saaꞌ? Au ꞌbi nee rabah, mes hi ka bisa fa he mpao kreꞌo msaꞌ! ");
INSERT INTO aaz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mimeu maatm ein naan feꞌ. Rarit amfeen he mpao mok Kau! Fin hi neekm ein amroim he mmoeꞌ rais reko, mes hi aom ein anꞌoren. Onaim reko nneis hi mꞌonen, he karu mipein furit ate, hi bisa maran ma mtahan.” ");
INSERT INTO aaz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Rarit In nnao nꞌonen antein am nak, “Usiꞌ! Karu ro Au es reꞌ he usaah maꞌneꞌat ia, maut he mutuin Ho roim aan kuum, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Anꞌonen anrair on naan ate, In ntebi nfain neu In atoup noniꞌ tua teun ein naan. Mes sin ntupan nfanin, natuin sin maatk ein maꞌfeen ein. ");
INSERT INTO aaz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Rarit In nfain he nꞌonen antein no goes. In ntoti ntein neu In Amaf, he kais nasaah maꞌneꞌat naan, mes maut he natuin In Aamf ee In romin. ");
INSERT INTO aaz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Anꞌonen anrair on naan ate, In ntebi nfain he npooꞌ nafenaꞌ In atoup noinꞌ ein. In naꞌuab am nak, “Hi mtuup kiim feꞌe, oo? Amfeen nai! Natuin tuaf reꞌ he naꞌsosaꞌ Kau, Mansian Batuur-Batuur reꞌ ia, anpaumaak een. Oras reꞌ ia, sin he nheek Kau goen, he nnonaꞌ Kau neu atoin maufiun ein. ");
INSERT INTO aaz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amfeen nai! Amfei maatm ein he mkius meu nee! Tuaf reꞌ naꞌsosaꞌ Kau naan, neem een.” ");
INSERT INTO aaz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Oras Naiꞌ Yesus naꞌuab on naan feꞌe te, naiꞌ Judas neem nok too mfaun ein. Sin neman neikin suniꞌ ma hau tukaꞌ he nheek Ee. Sin nmoꞌen on naan, natuin prenat naꞌko aꞌnaak pirsait Yahudi sin aꞌnaakt ein ma atoni mnais haart ein. ");
INSERT INTO aaz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Naiꞌ Judas ansenen nain sin im nak, “Amkius mirek-rekoꞌ, oo! Tuaf reꞌ au ꞌhoo ma ꞌneek Ee naan, hi mheek Je nai! Fin tuaf reꞌ naan, es reꞌ tuaf reꞌ hi mam-mami.” ");
INSERT INTO aaz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oras sin antean Naiꞌ Yesus, naiꞌ Judas nnao nhake nbi Naiꞌ Yesus In matan am nak, “Saloom, Aam Tungguru!” Onaim naiꞌ Judas anhoo ma nneek Ee. ");
INSERT INTO aaz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Rarit Naiꞌ Yesus nataan ee mnak, “Hae, Judas! Ho uum reꞌ ia, meik sairt ii es reꞌ ia, oo?” Onaim too mfaun ein naan neman, he nheek Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mes nok askeken, Naiꞌ Yesus In tuaf es anfaik benas, ma nsaip namouf atoin es in rukin noon es. (Atoniꞌ naan, es reꞌ pirsait Yahudi sin aꞌnaak kouꞌ goe in ate.) ");
INSERT INTO aaz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ankius on naan ate, Naiꞌ Yesus natoon ee mnak, “Muꞌtaap mufaniꞌ ho benas naan. Fin tuaf reꞌ nmoni nbi ꞌbae suniꞌ, in of anmaet nok suniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ho ka muhiin fa, oo? Au bisa ꞌtoit Au Amaꞌ he nreek In ameupt ein nifun-nifun naꞌkon sonaf neno tunan, he neman nturun Kau. ");
INSERT INTO aaz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mes noo goah nai. Anbain he tuaf ein reꞌ ia nheek Kau. Natuin saaꞌ reꞌ matuꞌi nain et Uisneno In Suur Akninuꞌ nmatoom nok Kau naan, ro he njarin.” ");
INSERT INTO aaz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Rarit Naiꞌ Yesus naꞌuab neu too mfaun ein reꞌ neman nheek Je mnak, “Hi mitenab mak, Au reꞌ ia atoin maufinu, oo? Nansaaꞌ am es hi iim amheek Kau meik suniꞌ ma hau tukaꞌ? Te kaah, neno-neno te Au unoniꞌ ki ꞌbi Uim Onen Uuf, mes ka tiit fa tuaf es, he nmoeꞌ saaꞌ-saaꞌ neu Kau. ");
INSERT INTO aaz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mes anbain nai! Iim amheek Kau nai! Natuin reꞌ ia matuꞌi nain naꞌko unuꞌ et Uisneno In Suur Akninuꞌ.” Ankisun on naan ate, Naiꞌ Yesus In atoup noinꞌ ein namtau nmaten. Onaim sin naenan ma nasaitan Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Rarit tuaf ein reꞌ nheek Naiꞌ Yesus, sin neik Je neu aꞌnaak pirsait Yahudis sin aꞌnaak koꞌu, naiꞌ Kayafas in umi, natuin aꞌnaakt ein nabuan nbin naan. Abuat ein naan, sin esan reꞌ: aꞌnaak pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, atoni mnais haart ein. ");
INSERT INTO aaz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Oras sin neik Je te, naiꞌ Petrus nnao naꞌkor-koroꞌ nbi sin koitk ein, antea aꞌnaak kouꞌ goe in umi. Naiꞌ Petrus antaam nok anbi kintal amsaꞌ he ntook nabua nok tuaf ein abitan naan. Fin in he nahiin saaꞌ reꞌ of he njair. ");
INSERT INTO aaz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anbi umi naan in nanan aꞌnaak pirsait Yahudi sin aꞌnaakt ein naꞌuab ein nok tuaf ein reꞌ afeek rais pirsait. Sin namin bukti he napenin ranan he nafeek hukun aꞌmaten neu Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Maski sin nataman saksii poi mfaun, mes sin ka napenin fa bukti saaꞌ-saaꞌ he npaek sin. Namuni te, sin napenin saksii tuaf nua. ");
INSERT INTO aaz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tua nuaꞌ ein naan ansaksii am nak, “Hai mneen miit Atoniꞌ ia naꞌuab am nak, ‘Au of useer Uim Onen Uuf. Mes Au of ufenaꞌ ufaniꞌ Umi naan neno teun goah.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Rarit aꞌnaak pirsait Yahudis sin aꞌnaak kouꞌ goe nfeen anhake nbi too mfaun ein sin maatk ein reꞌ ntokon nbin naan. Onaim in nataan Naiꞌ Yesus am nak, “Ho mneen amrair too mfaun ein nakuu Ko. Mes nansaaꞌ am es Ho mninuꞌ-mninuꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mes Naiꞌ Yesus ka nataah fa saaꞌ-saaꞌ. Onaim aꞌnaak kouꞌ goe nataan antein am nak, “Au he utaan Ko! Mes Ho ro he mutaah batuur-batuur, nahuum on reꞌ Ho mutaah meu Uisneno reꞌ nmoin et sonaf neno tunan. Anmuiꞌ tuaf nak, Ho reꞌ ia, Kristus, Uisneno In Anah reꞌ In nbaꞌan nain Je naꞌko unuꞌ. Batuur, aa oo?” ");
INSERT INTO aaz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Rarit Naiꞌ Yesus nataah am nak, “Batuur, on reꞌ ho muꞌuab naan. Mes, mimnau! Hi ar-arki of miit Kau, Mansian Batuur-Batuur reꞌ ia. Au of aꞌtoko ꞌbi sonaf neno tunan ꞌbi Uisneno In abnapan aꞌneꞌu, he ꞌnaaꞌ aprenat ꞌok Ne reꞌ akuaas reꞌuf. Rarit Au ꞌsanu ꞌfain ꞌuum aꞌbi nope.” ");
INSERT INTO aaz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Anneen Naiꞌ Yesus naꞌuab on naan ate, aꞌnaak kouꞌ goe natooꞌ maꞌtaniꞌ, tar antea in npius nakratiꞌ in baru mnanuꞌ. Rarit in nkoaꞌ ma natoon neu atooks ein naan ok-okeꞌ mnak, “Hit ka tperluu fa saksii ttein! Hi mneen kiim meik hi rukim, In uab naan. In nanaib kuun In tuan anjair Uisneno In Anah. Reꞌ ia rasi mꞌakan! Hi mihiin ok-okeꞌ mak, tatuin hit atoran pirsait, karu atoniꞌ nataib on, on reꞌ Uisneno, atoniꞌ naan ro he nmaet! ");
INSERT INTO aaz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Onaim oras ia, hi he mifeek mak saaꞌ?” Onaim sin nsakanan ok-okeꞌ mnak, “Batuur atoniꞌ ia nsaan! Onaim In ro he napein hukun aꞌmaten!” ");
INSERT INTO aaz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Rarit tuaf fauk antaman ma naroon Naiꞌ Yesus. Sin nbeos Goe ma npaas Ee msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rarit sin nakreeꞌt Ee mnak, “Hoe! Ho reꞌ ia Kristus, aa oo? Ho mteek miit! Sekau es antuuf Ko reꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Oras naan, naiꞌ Petrus antoko nbi kintal feꞌ. Rarit anmuiꞌ bifee ate es, neem naꞌuab nok naiꞌ Petrus am nak, “Feꞌe na, ho uum mok Naiꞌ Yesus, atoin Nasaretas naan, aiꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mes in nprotees anbi too mfaun ein sin maatk ein am nak, “Kaah fa, tua! Nansaaꞌ am es ho mutaan on naan! Au ka uhiin Je fa.” ");
INSERT INTO aaz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Rarit naiꞌ Petrus anpoi nhake nbi enoꞌ ꞌtamas. Onaim anmuiꞌ bifee jes anteniꞌ reꞌ nkius niit ee nbi naan. In natoon neu atoin ein reꞌ nbin naan am nak, “Au ꞌiit atoniꞌ ia nok Naiꞌ Yesus, atoin Nasaretas naan.” ");
INSERT INTO aaz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Onaim naiꞌ Petrus anprotees am nak, “Ho mumaunu, oo! Au ka uhiin fa atoniꞌ naan! Au ꞌsuup!” ");
INSERT INTO aaz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka ꞌroo fa te, tuaf bian sin reꞌ ntokon nbin naan naꞌuab anteinꞌ ein neu ne, mnak “Hae! Ho kais mupoi kai mak, ho ka mok fa Atoniꞌ naan! Fin hai mneen ho muꞌuab ate, humaꞌ mese on reꞌ atoin Galileas sin!” ");
INSERT INTO aaz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mes in nmurai nasekuꞌ, onaim in anraban am nak, “Hoe! Au ꞌsuup aꞌpaek Uisneno In kanan! Au ka uhiin fa Atoniꞌ naan!” Nateef in naꞌuab on naan ate, maun goe nkokreoꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Anneen maun goe nkokreoꞌ, naiꞌ Petrus namnau Naiꞌ Yesus In uaban feꞌe na, reꞌ nak, “Maun goe ka nkokreoꞌ fa feꞌe te, ho musuan amrair Kau no teun goen am mak, ho ka muhiin Kau fa.” Namnau niit on naan ate, in naen anpoi ma nkae npin-pinus. ");
INSERT INTO aaz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Neis noi nmeu on naan ate, too mfaun ein reꞌ anꞌaꞌan rais pirsait naan, nnekaꞌ buan he naꞌmaet Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Es naan ate, sin nfuut neik Je anꞌain gubernur Pilatus. Fin sin nromin he gubernur ee nhukun naꞌmaet Je. ");
INSERT INTO aaz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Oras naiꞌ Judas nahiin nak, Naiꞌ Yesus napein hukun aꞌmaten, in nmeiꞌ jon, natuin in es reꞌ naꞌsosaꞌ Naiꞌ Yesus. Rarit in nnao nfain neu aꞌnaak pirsait Yahudi sin aꞌnaakt ein ma atoni mnais haart ein, he nafaniꞌ sin roi mutiꞌ fuaꞌ boꞌ teun ein reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","In naꞌuab am nak, “Au ꞌsaan aꞌrair, natuin au ꞌnonaꞌ Tuaf reꞌ ka nmuiꞌ fa sanat meseꞌ msaꞌ.” Mes sin natahan am nak, “Hoe! Hai ka mfairoir ko fa! Ho ro he musaah ma mutaah kuum sanat naan.” ");
INSERT INTO aaz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Rarit naiꞌ Judas anporin roit ein neu Uim Onen Uuf. Onaim in nnao nakfirit niis on. ");
INSERT INTO aaz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Rarit aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein nsiun naꞌbuaꞌ roit ein reꞌ naiꞌ Judas anporin sin naan. Sin naꞌuab ein am nak, “Hit kais attao tafaniꞌ roit ein ia teu peit je nanan, natuin roit ein ia of anhaiꞌniis kit. ");
INSERT INTO aaz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Onaim reko nneis hit tsoos afu piis es taꞌko amoꞌe ꞌnaꞌi. Karu nmuiꞌ atoin sonaꞌ aiꞌ kase nmaet, ma tuaf es ka nahiin je fa, hit bisa tsuub ee nbi naan.” ");
INSERT INTO aaz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rarit sin npaek roit ein naan, he nsosan afu. Etun tar antea oras ia, atoniꞌ nteek bare naan nak, ‘Auf Naaꞌ’. ");
INSERT INTO aaz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nok ranan naan, sin natuin saaꞌ reꞌ Uisneno In mafefa kninuꞌ naiꞌ Yermias naꞌuab nain je mnak, “Sin npaek roi mutiꞌ fua boꞌ teun he nsosan afu. Sin npaek roit ein naan, fin roit ein naan osaf he nsosan mansian, natuin osaf reꞌ atoin Israelas sin nafeek nani. ");
INSERT INTO aaz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Afu naan sin nsoos ee naꞌko amoꞌe ꞌnaꞌi, natuin Uisneno In apreent ee neu kau.” ");
INSERT INTO aaz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Oras too mfaun ein neik Naiꞌ Yesus antean gubernur ee te, in nataan Naiꞌ Yesus am nak, “On mee? Ho reꞌ ia, batuur-batuur atoin Yahudis sin Uisf, aa oo?” In nataah am nak, “Batuur. On reꞌ ho muꞌuab aan, tua.” ");
INSERT INTO aaz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mes oras aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein ma atoni mnais haart ein nakuu rasi mfaun neun Naiꞌ Yesus, In ka nataah fa saaꞌ-saaꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Rarit gubernur ee nataan Ee mnak, “Ho ka mneen fa sin uab ein naan? Sin nasaan Ko mfaun een. Mes nansaaꞌ am es Ho ka mutaah fa?” ");
INSERT INTO aaz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mes In ka nataah nain fa msaꞌ, tar antea gubernur ee nsanmaak. ");
INSERT INTO aaz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Toon-toon ate, oras fesat Paska atoin Yahudis sin, too mfaun ein biasa npiir naan atoin hukun es, he gubernur ee nafetin. ");
INSERT INTO aaz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oras naan, anmuiꞌ atoin hukun es, in kaan ee naiꞌ Barabas. Too mfaun ein nahiin je neu in reꞌ naan sekau, natuin in maufiun ii maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Neno naan amsaꞌ, too mfaun ein annaon neun gubernur Pilatus, rarit sin nbaisenun ma ntotin he nafetin atoin hukun es, on reꞌ biasa. Onaim gubernur Pilatus nataan sin im nak, “Reko! Mes au he ufetin sekau? Naiꞌ Barabas reꞌ ia, aiꞌ Naiꞌ Yesus reꞌ tuaf anteek Ee mnak, Kristus, reꞌ ia msaꞌ. Au he ufetin es reꞌ mee? Hi mpiir nai.” ");
INSERT INTO aaz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernur ee naꞌuab on naan, natuin in nahiin nak, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein neik Naiꞌ Yesus neu ne, natuin sin natiun Goe mates.) ");
INSERT INTO aaz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oras gubernur ee nparikas rasi naan feꞌe te, in fee je ansonuꞌ hanaf neu ne mnak, “Ampaant om, tua. Naiꞌ Yesus naan Atoniꞌ reꞌ ka nmuiꞌ fa sanat saaꞌ-saaꞌ. In kakain am es reꞌ fini na au umnei ka reko fa. Tar antea oras ia msaꞌ au ꞌnaben ate ka reko fa.” ");
INSERT INTO aaz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mes aꞌnaak rais pirsait Yahudis sin aꞌnaakt ein ma atoni mnais haart ein anfuaruut too mfaun ein naan, he ntoit gubernur ee nafetin naiꞌ Barabas, ma nhukun naꞌmaet Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Rarit in nataan nafaniꞌ sin im nak, “Naꞌko tua nuaꞌ ein reꞌ ia, au ufetin es reꞌ mee?” Onaim sin natahan ok-okeꞌ mnak, “Barabas! Mufetin kai naiꞌ Barabas!” ");
INSERT INTO aaz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rarit in nataan sin im nak, “Karu on naan ate, au he ꞌmoeꞌ saaꞌ ꞌeu Naiꞌ Yesus, reꞌ atoniꞌ nteek Ee mnak, Kristus?” Onaim sin nkoaꞌ ein ma nhuun ein ok-okeꞌ mnak, “Amkuus muꞌpeit Ee meu hau nehe!” ");
INSERT INTO aaz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Rarit gubernur ee nataan antein am nak, “Mes In saant ee, saaꞌ? Au uprikas urair Je, mes au ka upein fa In sanat saaꞌ-saaꞌ!” Mes sin nkoaꞌ ein ma nhuun ein naher-heran anteinꞌ ein am nak, “Muꞌmate! Amkuus muꞌpeit Ee meu hau neeh je nai!” ");
INSERT INTO aaz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ka ꞌroo fa te, in nahini mnak, in ka bisa nmoeꞌ fa saaꞌ-saaꞌ ntein, fin too mfaun ein he ntaisiubn een. Onaim in nait oe ma nafaun in aꞌniimk ein anbi sin maatk ein, ma naꞌuab neu sin im nak, “Au ka utaah ma usaah fa Atoniꞌ ia in aꞌmaten! Maut he hi es reꞌ misaah ma mitaah kiim!” ");
INSERT INTO aaz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Onaim too mfaun ein nkoaꞌ ma nhuun ein am nak, “Reko, mbain nai! Maut he hai mok hai sufaꞌ-kaꞌuf sin es reꞌ mitaah ma misaah In naaꞌ naan!” ");
INSERT INTO aaz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anneen on naan ate, in naꞌuab am nak, “Reko!” Onaim in nafetin naiꞌ Barabas natuin sin roimk ein. Rarit in naprenat apaot ein, he nnaon nbeos Naiꞌ Yesus npaken aꞌkauboe. Anbeso nrair Je on naan ate, soraurs ein neik Je he nnao nkuus Ee neu hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Rarit soraurs ein anheer neik Naiꞌ Yesus neu sin koat ee in kintal mainuan. Anbi naan, sin noꞌen naan sin partei ngguin pukan es. ");
INSERT INTO aaz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Onaim sin napaekb Ee baru mnanuꞌ masnaa meeꞌ apinat. ");
INSERT INTO aaz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rarit sin nait hau maꞌaikaꞌ in taek ein he nkanen aꞌsoeb es. Onaim sin ntumaꞌniiꞌ ꞌsoeb maꞌaikaꞌ naan neu Naiꞌ Yesus In aꞌnakan, he naꞌraur ein on reꞌ sin he nasaeb Ee ꞌpiruꞌ-baru neu uisf feuꞌ goes. Rarit sin nanaaꞌt Ee hau noon es anbi In aꞌniman aꞌneꞌu nahuum on reꞌ teas aprenat. Ma sin nriꞌtuun ma nbaiseun Naiꞌ Yesus, ma sin nakreeꞌt Ee mnak, “Baisenut neu atoin Yahudis sin Usif.” ");
INSERT INTO aaz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Onaim sin npuran hape neu Ne, ma nait teas naan naꞌko In aꞌniman, he nteeꞌ naꞌba-bae In aꞌnakan. ");
INSERT INTO aaz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sin nakreꞌet anrair Je on naan ate, sin nhoroꞌ nporin baru mnanuꞌ naan. Rarit sin napakeb nafaniꞌ In tais ein. Rarit sin neik Je nnao npoin naꞌkon kota Yerusalem, he nkuus naꞌpeit Ee nbi hau nehe tar antea In nmaet. ");
INSERT INTO aaz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oras sin nheer neik Naiꞌ Yesus anbi raan atnanaꞌ, sin nateef atoin es naꞌko kota Kirene in feꞌ he ntaam neu kota. In kaan ee naiꞌ Simon. Sin naꞌseek ee he nasaah Naiꞌ Yesus In hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rarit sin antean baer jes, kaan ee, Golgota. (Anbi uab Aram, in oten nak, ‘Bare ꞌnaak nuif.’) ");
INSERT INTO aaz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Anbi naan sin naꞌinuꞌ Naiꞌ Yesus tua min-kase reꞌ sin nseor goe nok reuꞌ miin menuꞌ, maut he In ntahan menas. Naiꞌ Yesus annaben aꞌkreꞌo, mes rarit In ntorak. ");
INSERT INTO aaz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Rarit sin nkuus naꞌpeit Ee nbi hau nehe. Onaim soraurs ein anheran suur anaꞌ he naparaꞌ Naiꞌ Yesus In paken. ");
INSERT INTO aaz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Rarit sin ntokon npao Goe nbin naan. ");
INSERT INTO aaz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sin ntuin nbin hau piis es amsaꞌ am nak, “IA NAIꞌ YESUS, ATOIN YAHUDIS SIN USIF” Onaim sin nkuus anpasan hau pisaꞌ naan anbi Naiꞌ Yesus In hau nehe, antoom faof, he njair tuꞌin neu saaꞌ am es In napein hukun naan. ");
INSERT INTO aaz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Anbi naan, sin nkuus naꞌpetiꞌ atoin aburarut tuaf nua. Es anbi In abnapan aꞌneꞌu; es anbi In abnapan aꞌrii. ");
INSERT INTO aaz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Too mfaun ein reꞌ nnaon npeꞌon naan, ankius Goe. Onaim sin napenub sin nuurk ein ma naꞌuab nakreeꞌt Ee. ");
INSERT INTO aaz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Sin nkoaꞌ ein ma nhuun ein am nak, “Hoe! Ho mak Ho bisa museer Uisneno In Uim Onen Uuf, rarit Ho mufenaꞌ mufainꞌ ee anbi neno teun goah. Karu Ho batuur-batuur Uisneno In Anah, mufetin miit Ho tuam aan he msaun muꞌko hau nehe naan nai.” ");
INSERT INTO aaz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","On naan amsaꞌ aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, ma atoni mnais haart ein nakreeꞌt Ee mnak, ");
INSERT INTO aaz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“In nsoi nafetin naan kuun biak ein, mes In ka bisa fa nsoi nafetin naan In tuan. In nak, In atoin Israelas sin Usif! Karu on naan, maut he In nsaun nai naꞌko hau nehe naan. Karu hai mkius miit on naan, naꞌ hai mpirsai Je. ");
INSERT INTO aaz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Karu In batuur-batuur Uisneno In Anah, maut he, ‘In nafnekan ma nharap neu Uisneno. Onaim karu Uisneno nroim Je, maut he Uisneno es reꞌ ansoi nafetin naan Ee.’ ” ");
INSERT INTO aaz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aburarut nuaꞌ ein naan, nakreeꞌt Ee on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rarit meisꞌookn ii nꞌaum naan bare naan naꞌko maans ee natetab rek-reko tar antea nreuk teun maans ee nmaeb. ");
INSERT INTO aaz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nateef anreuk teun maans ee nmaeb on naan ate, Naiꞌ Yesus ankoaꞌ anpaek uab Aram am nak, “Eli! Eli! Lema sabaktani?” (In oten nak, “Koi Au Usiꞌ! Koi Au Uisneno! Nansaaꞌ am es Ho mkoit ma musaitan Kau on reꞌ ia?”) ");
INSERT INTO aaz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tuaf fauk reꞌ npaumak-maak anbin naan, annenan In hanan. Onaim sin nak, “Hae! Hi mneen feꞌ. In nkoaꞌ naꞌi naiꞌ Elia, Uisneno In mafefa kninuꞌ un-unuꞌ naan!” ");
INSERT INTO aaz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Rarit tuaf es naen nait aniꞌ-tei metoꞌ he narepaꞌ neu raur maꞌninuꞌ. In nkaot aniꞌ-tei metoꞌ naan neu hau noon es in panan, rarit naramib Naiꞌ Yesus he nmuis. ");
INSERT INTO aaz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mes tuaf bian antein naꞌuab ein am nak, “Maut he tkius tiit naꞌi naiꞌ Elia he neem ansoi nafetin naan Ee, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Rarit Naiꞌ Yesus ankoaꞌ antein nok haan hunun, rarit In nmaet. ");
INSERT INTO aaz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Anbi Uim Onen Uuf, anmuiꞌ naan tai eon kouꞌ goes nakfiir he nꞌekaꞌ Uisneno In Keꞌen Akninuꞌ nneis-neisi. Oras Naiꞌ Yesus natfeek, tai enoꞌ naan natkai nbatis nua, naꞌko faof tar antea ꞌpiin. Onaim antainuun, tar antea faut kouꞌn ein anpeꞌen. ");
INSERT INTO aaz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Noup fautn ein natfeꞌin amsaꞌ. Ma Uisneno In tuaf ein reꞌ nmate nrarin, bian In namonib nafaniꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Oras Naiꞌ Yesus anmonin nfain, sin npoin naꞌkon noup fautn ein, rarit sin ntaman neun Yerusalem. Too mfaun ein niit sin inbin naan. ");
INSERT INTO aaz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Anbi Golgota, anmuiꞌ aꞌnaak sorarus nok in soraur aan ein reꞌ npaon nbin Naiꞌ Yesus in hau nehe. Oras sin nnaben neu antainuun, ma nahinin nak areꞌ rasin reꞌ naan anjarin nrarin on naan ate, sin namtau nmaten. Sin naꞌuab ein am nak, “Aijoo! Atoniꞌ ia, batuur-batuur Uisneno In Anah!” ");
INSERT INTO aaz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Anbi naan amsaꞌ nmuiꞌ bifee tuaf fak-fauk, reꞌ anhaken nbin aꞌroo, ma napeen niit In aꞌmaten naan. Sin natuin Ee naꞌkon Galilea, fin sin esan reꞌ antuthae Je naꞌko unuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Naꞌko bifeen reꞌ naan, anmuiꞌ bi Maria naꞌko kuan Makdala, bi Maria es anteniꞌ (es reꞌ naiꞌ Yakobus ma naiꞌ Yusuf sin ainaf), ma naiꞌ Sebedius in fee (es reꞌ naiꞌ Yakobus ma naiꞌ Yohanis sin ainaf). ");
INSERT INTO aaz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Anbi naan anmuiꞌ atoin amuiꞌt es naꞌko kuan Arimatea, kaan ee naiꞌ Yusuf. In natuin Naiꞌ Yesus In noniꞌ-taruꞌ aꞌroo goen. Naiꞌ Yesus In aꞌmaten, nateef nok neon nimaꞌ. Nokaꞌ on naan ate, nateef nok atoin Yahudis sin neon onen. Es naan ate, oras maans ee he noi nmouf, naiꞌ Yusuf naim ranan he nasanut Naiꞌ Yesus In aon amates naan naꞌko hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rarit in nnao nbaiseun gubernur Pilatus, he ntoit Naiꞌ Yesus In aon amates. Rarit gubernur ee naprenat he sin nnonaꞌ amates naan neu ne. ");
INSERT INTO aaz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Onaim naiꞌ Yusuf annao nꞌain Golgota. Rarit in nasanut Naiꞌ Yesus In aon amates naan naꞌko hau nehe. Rarit in nꞌaum narek-reokꞌ Ee nok tai feꞌu reꞌ maꞌosaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Oras naan, naiꞌ Yusuf sin feꞌ anpahat anrair koon es anbin ꞌtoeꞌ fatu, he nabarab nain noup fatu neu sin nonot-asar sin karu sin nmaten. Onaim naiꞌ Yusuf sin natnaat ma nataam Naiꞌ Yesus neun noup fatu naan. Rarit sin narituꞌ faut kouꞌ goes, he sin ntoeb narek-rekoꞌ noup fatu naan. Onaim naiꞌ Yusuf sin ntebi nfanin. ");
INSERT INTO aaz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Oras naan, bi Maria naꞌko kuan Makdala ma bi Maria es antein, nokan amsaꞌ nbin naan. Sin ntokon nbain ein anꞌanin noup fatu naan. ");
INSERT INTO aaz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nokaꞌ on naan ate, nateef nok atoin Yahudis sin neno snasat. Onaim aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein ma atoin Farisis sin nnao nbaiseun gubernur. ");
INSERT INTO aaz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sin nbaisenun am nak, “Amaꞌ gubernur. Hai mimnau oras aputa-kriut naan anmoin feꞌ, In naꞌuab niit, on nai: ‘Batuur Au ꞌmaet, mes nkoon neno teun on naan ate, Au ꞌmoni ꞌfain.’ ");
INSERT INTO aaz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Es naan ate, hai mbaiseun ko, tua, he mreun ma mreek ho soraurs ein he npao narek-rekoꞌ noup fatu naan, tar antea neno teun. Nok ranan naan, In atoup noinꞌ ein ka bisa nabaak fa In aon amates, he napoi atoniꞌ mnak, In nmoni nfain. Fin karu sin napoin on reꞌ naan, naan maufinu nneis naꞌko unuꞌ sin napoin am nak, In reꞌ naan, es reꞌ Kristus.” ");
INSERT INTO aaz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Anneen on naan ate, gubernur ee nataah am nak, “Reko msaꞌ! Mes hi kiim ammuiꞌ tuaf apaot. Reko nneis ampaek sin, he nnao npaon narek-rekoꞌ nbin bare naan.” ");
INSERT INTO aaz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Rarit sin nnaon anbin bare naan, ma neik sin apaot ein. Antean bare naan, sin nmarak noup fatu naan in enoꞌ. Onaim sin nreun tuaf he npao bare naan ankoon, he tua ꞌtetaꞌ kais neem nait amates naan. ");
INSERT INTO aaz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Rarit neno krei kik-kiuk anaꞌ bi Maria naꞌko kuan Makdala ma bi Maria es antein, sin nnaon nkius noup fatu naan. ");
INSERT INTO aaz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nok askeken, antainuun maꞌtaniꞌ. Uisneno In ameput es naꞌko sonaf neno tunan ansaun neem, onaim in ntitar nananiꞌ faut koꞌu reꞌ ntoeb noup fatu naan. Rarit in ntoko nbi faut goe tunan. ");
INSERT INTO aaz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ameput naan in huumn ee anpiin on reꞌ rimat, ma in paek ein snaa mutiꞌ ma nariim. ");
INSERT INTO aaz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Apaot ein naan namtau nmaten, tar antea sin naꞌtaꞌin met-meot goah, ma sin ka bisa nakbeor ein fa on reꞌ amates. ");
INSERT INTO aaz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Onaim ameput sonaf neno tunan naan, naꞌuab neu bifeen naan am nak, “Hi kais mimtau! Au uhiin ꞌak hi iim maim Naiꞌ Yesus, Tuaf reꞌ sin nkuus naꞌmaet Je nbi hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mes In ka et fa ia goen. Natuin In nmoni nfain, naan nahuum on reꞌ In naꞌuab nain je. Amtaam nai he mkius kiim bare reꞌ sin ntao In aon amates. Bare naan ruman! ");
INSERT INTO aaz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Oras ia hi mtebi mfain nai! Amnao mitonan In atoup noinꞌ ein am mak, Naiꞌ Yesus anmoni nfain jen. In nnao nahuun et Galilea. Sin ro he nnaon natefan nok Ne nbin nee, on reꞌ unuꞌ te In nbaꞌan nain sin. Ampirsai nai. Amfain nai he mitoon saaꞌ reꞌ au uꞌuab ee reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Onaim bifeen naan naen nasaitan bare naan. Sin namtaun, mes sin nmarinan amsaꞌ. Sin ntebi nfanin he natoon rasin reꞌ naan ok-okeꞌ neun Naiꞌ Yesus In atoup noinꞌ ein. ");
INSERT INTO aaz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mes antean raan atnanaꞌ on naan ate, nok askeken Naiꞌ Yesus nateef nok sin. In naꞌuab am nak, “Saloom!” Sin nkius nitan on naan ate, sin neman npaumak-maak ma nhoo In haek ein, ma naꞌbees neu Ne. ");
INSERT INTO aaz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Onaim In naꞌuab am nak, “Kais mimtau! Amnao mitonan Au atoup noinꞌ ein, he sin nnaon npao Kau nbin Galilea.” ");
INSERT INTO aaz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oras bifeen naan feꞌ anbin raan atnanaꞌ, apaot ein naan anfanin neun kota. Sin nnao natonan neu aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, rasin reꞌ njarin ok-okeꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Onaim aꞌnaakt ein anꞌator aꞌsraak nok atoni mnais haart ein, he nfeen apaot ein naan roit amfa-faun, he sin fefaꞌ ꞌtemen. ");
INSERT INTO aaz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aꞌnaakt ein naan naprenat sin im nak, “On nai. Karu atoniꞌ nataan, hi ro he mitaah am mak, fai je natnaan hi mtuup amfiin. On nai te In atoup noinꞌ ein neman ma nabaak In aon amates. ");
INSERT INTO aaz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Karu gubernur ee anneen rasin naan, kais mimtau, natuin hai es amꞌator aꞌnaef ee.” ");
INSERT INTO aaz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Onaim apaot ein antoup roit ein naan. Sin nmoꞌen natuin aꞌnaakt ein sin roimk ein. Es naan ate, antea oras ia atoin Yahudis sin anpirsain uab puta-kriut naan feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anneen anrair bifeen naan sin uabk ein naan, Naiꞌ Yesus In atoup noniꞌ tuaf boꞌes am meseꞌ naan nnaon neun propinsi Galilea he natefan nok Ne nbin aꞌtoeꞌf es, natuin In rais manbaꞌan naan. ");
INSERT INTO aaz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Oras sin nkius niit Ee, sin naꞌruir ein ma naꞌbesan neun Ee. Maski on naan amsaꞌ, mes anmuiꞌ tuaf reꞌ neekn ee naꞌoniꞌ feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Rarit In neem anpaumak-maak sin, ma naꞌuab am nak, “Uisneno nfee Kau kuasat he Au uprenat saaꞌ-saaꞌ ii ok-okeꞌ nbi sonaf neno tunan ma nbi pah-pinan ia. ");
INSERT INTO aaz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Onaim hi mnao meu mee-mee jah ate, hi ro he mitoon Au Rais Reko meu pah-pah ma uuf-uuf ein ok-okeꞌ. Hi ro he minoniꞌ sin rek-reko, maut he sin njarin Au atoup noinꞌ ein. Ma hi ro he misrain sin he njarin tanar nak, sin nmafutuꞌ nrarin nok Amaꞌ Uisneno, ma In Anah, ma In Asmaan Akninuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma minoniꞌ sin he nmoꞌen natuin areꞌ preent ein ok-okeꞌ reꞌ Au utoon aꞌrair ki sin. Mimnau! Au ꞌbi hi soonm ein ma hi tnaanm ein piut-piut, tar antea pah-pinan ia namsoup.” ");
INSERT INTO aaz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ia rais reko anmatoom nok Uisneno In Anah. In kaan ne Yesus Kristus, reꞌ Uisneno nruur ma nreek nain Je naꞌko un-unuꞌ. In retan ia, naꞌuub on on nai: ");
INSERT INTO aaz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nahuun naꞌko Naiꞌ Yesus nait In mepu, Uisneno anreek haefan atoin es neem nahuun. Atoniꞌ reꞌ naan, kaan ne naiꞌ Yohanis. Naiꞌ Yohanis reꞌ ia, ro he neem nahuun he nfei ranan neu Naiꞌ Yesus. Mes nahuun naꞌko naiꞌ Yohanis he neem, Uisneno ansonuꞌ nahunun In mafefa kninuꞌ tuaf es, kaan ne naiꞌ Yesaya. Naꞌko afi ahunut, naiꞌ Yesaya antui nrair, nak on nai: “Amneen, oo! Au of aꞌreek haefan Au tuaf es, he nnao nfei ranan neu Ko. ");
INSERT INTO aaz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Haef naan of annao neu baer ruman, he nhunun ma ankoaꞌ am nak: ‘Usiꞌ he nkoen On neem! Bifee-atoniꞌ, iim he tabarab ranan ma taroitan bare! Iim he takninuꞌ ranan, ma atseun Goe.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Sin biasa nteek naiꞌ Yohanis ate, nak ‘Asrain Atoniꞌ’. In natua nbi baer ruman. In paekn ee anmoeꞌ je naꞌko bikaes unta in funun. In pasu ꞌfutuꞌ nmoeꞌ je naꞌko pasu. In naah sisi knamat ma niun oin hau. Naiꞌ Yohanis in aꞌmoin ii, nahuum on reꞌ mafefa kninuꞌ kaꞌo naiꞌ Elia afi unuꞌ. Oras naan, too mfaun naꞌkon kota Yerusalem, ma propinsi Yudea in afan nanan, sin neman ma natefan nok naiꞌ Yohanis anbi in baran. Sin neman he nitan nok sin maatk ein ma annenan nok sin ruik ein noniꞌ-taruꞌ naꞌko naiꞌ Yohanis. In nsaksii ma natoon neu sin am nak, “Hi ro he mmanakuꞌ ma misaitan hi sanat ma penu sin ok-okeꞌ, maut he Uisneno nnoes nain hi saant ein naan. Rarit hi ro he misrain feꞌ, he anjair tanar am nak, hi mmarameꞌ mfaim jen mok Uisneno. Oras sin nneen anrarin on naan ate, sin nmanakuꞌ sin saant ein, rarit sin nanaꞌat sin tuak ein neun naiꞌ Yohanis, ma in nasrain sin anbin noe Yarden. ");
INSERT INTO aaz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","In naꞌuab neu sin am nak, “Nokaꞌ-nmeu te, Atoin es of he neem. In maꞌtaniꞌ nneis naꞌko kau. Au ka masoꞌik kau fa, maski bait au ꞌjari haa In aan renu ma aan rekaꞌ, au ka umnees ꞌok Ne fa. ");
INSERT INTO aaz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au ꞌmanoek ii suma es reꞌ he usrain ki ꞌpaek oe, mes Atoniꞌ naan of anmoꞌe nneis naꞌko kau. Fin In of natuab ma namonib ki nok Uisneno In Asmaan Akninuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rarit Naiꞌ Yesus neem naꞌko kuan Nasaret et pah Galilea, he nateef nok naiꞌ Yohanis. Ma naiꞌ Yohanis nasrain Je anbi noe Yarden. ");
INSERT INTO aaz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma oras Naiꞌ Yesus anpoi naꞌko noe, nok askeken ate, neon goe natfeꞌi. Rarit Uisneno In Asmaan Akniunꞌ ee ansaun neem neu Ne, mamnitaꞌ on reꞌ kor-kefi. ");
INSERT INTO aaz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma hanaf Uisneno npoi neem naꞌko neon goe mnak, “Ho reꞌ ia, Au Aan nekaꞌ. Ho es reꞌ ammarineb Au nekak.” ");
INSERT INTO aaz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rarit Uisneno In Asmaan ee nheer neik Naiꞌ Yesus neu baer ruman. ");
INSERT INTO aaz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anbi bare naan, anmuiꞌ kaun fui sin. Naiꞌ Yesus natua nbi bare naan fai boꞌ haa ma neno boꞌ haa. Anbi bare naan amsaꞌ, niut reuꞌf ein sin aꞌnaak koꞌu neem ma nsobaꞌ Usif Yesus he natuin in uaban, mes ka nabeiꞌ Je fa. Rarit Uisneno In ameput naꞌko sonaf neno tunan neem he natutaꞌ ma nabhaeꞌ neu Ne nbi rasi aof ma smanaf. ");
INSERT INTO aaz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Anbi oors es, reꞌ sin nataam anrair naiꞌ Yohanis Asranit anbi bui, Naiꞌ Yesus annao neu propinsi Galilea, he natoon Rais Reko naꞌko Uisneno anbi naan. ");
INSERT INTO aaz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","In naꞌuab am nak, “Amneen, oo! Oras ia, Uisneno In oors antea goen. Oras ia, areꞌ bifee-atoniꞌ bisa nahinin nak, Uisneno nnaaꞌ aprenat. Onaim hi ro he miꞌpiis ma miꞌteꞌun hi sanat ma penu sin, he mtebi mfain ma mituinaꞌ Uisneno. Rarit ampirsai meu In Rais Reko ia nai!” ");
INSERT INTO aaz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Neot es, Naiꞌ Yesus annao nreuk nefo Galilea in ninin. In niit atoniꞌ nua. Es in kaan ee naiꞌ Simon, nok in oirf ee naiꞌ Anderias. Sin nua sin anꞌookr ein jala he nheken ikaꞌ. Mepu naan, sin meup goe neno-neno. ");
INSERT INTO aaz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naiꞌ Yesus noꞌen sin am nak, “Hoe, baꞌe sin! Iim he mituinaꞌ Kau nai! Hi amnaim ikaꞌ ki, mes anbi oras ia, Au he unoniꞌ ki he mjair amnaim tuaf meu pukan Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Anneen anrarin on naan ate, sin nua sin nasaitan jala naan, ma annao natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Rarit Naiꞌ Yesus annao nkono kreꞌo. In niit naiꞌ Sebedius in aanh ein tuaf nua. Aan unu in kaan ee naiꞌ Yakobus, ma in oirf ee, kaan ee naiꞌ Yohanis. Sin nua sin nabarab sin pukat anbi koof es in nanan. ");
INSERT INTO aaz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naiꞌ Yesus noꞌen sin am nak, “Hoe, baꞌe sin! Iim he mituinaꞌ Kau nai!” Onaim sin nua sin annao nasaitan sin amaf nok in ameupt ein anbin kofaꞌ naan, ma sin natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Rarit Naiꞌ Yesus nok tua haaꞌ ein naan, sin neman ntean kota Kapernaum. Neno naan nateef nok atoin Yahudis sin neon onen. Onaim Naiꞌ Yesus antaam anbi uim onen ma nanoniꞌ tuaf anbi naan. ");
INSERT INTO aaz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Oras sin nneen In uaban naan, sin nsanmakan, fin In nahiin batuur-batuur noniꞌ naan in afan. Naan aꞌtetaꞌ naꞌko atoin Yahudis sin tunggur agaam ein. ");
INSERT INTO aaz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oras naan, anmuiꞌ atoin es, reꞌ anniut sae. In ntaam nok anbi uim onen amsaꞌ. Rarit nitu reꞌ anbi atoniꞌ naan anhunun am nak, ");
INSERT INTO aaz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hoe! Yesus, atoin Nasaretas! Ho uum he mseroꞌ saaꞌ mok kai? Ho uum he mureuꞌ kai, aiꞌ? Hai mihiin Ko. Ho reꞌ ia, Atoniꞌ reꞌ Uisneno anbaꞌan nain je he nreek Ee neem naꞌko un-unuꞌ. Ho reꞌ ia, Uisneno In Atoni Kninuꞌ reꞌ ka mmuiꞌ fa sanat.” ");
INSERT INTO aaz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mes Naiꞌ Yesus naskaraꞌ atoniꞌ naan am nak, “Kaisaꞌ mufeef! Ho mpoi nai muꞌko atoniꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Rarit niut reꞌuf naan, anhasuꞌ atoniꞌ naan naher-heer. Ma in npoi naꞌko atoniꞌ naan nok haan hunun. ");
INSERT INTO aaz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Onaim abitan uim onen naan ansanmakan. Rarit sin naꞌuab ein am nak, “Amoo! Saaꞌ na es reꞌ ia! In naprenat niut reꞌuf ein he npoin, ma sin nneen Ee ma natuin In uaban. Ia noin feꞌu, aiꞌ? Aꞌnaef ee naꞌuab ate ro maꞌtaniꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Onaim sin nmurain nsaksiin ma natonan ꞌmoꞌet naꞌko Naiꞌ Yesus, naꞌko kuan neu kuan annono mnateef anbi propinsi Galilea. ");
INSERT INTO aaz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Oras sin npoin naꞌkon uim onen naan, Naiꞌ Yesus annao neu naiꞌ Simon ma naiꞌ Anderias sin umi. Naiꞌ Yakobus nok naiꞌ Yohanis nokan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naiꞌ Simon in ain baabf ee anmaniin, ma antuup anbi harak. Oras Naiꞌ Yesus nok In atoup noinꞌ ein antaman nbin umi naan, atoin es neem ma natonan naiꞌ Simon am nak, “Ho ain babaꞌ anmainiin.” ");
INSERT INTO aaz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Onaim Naiꞌ Yesus annao nasnekuꞌ bifee mnais amaininit naan. In nnaaꞌ in aꞌniman, ma anfiit nafeen ee. Oras naan, in nareok nain. Rarit bifee mnasiꞌ naan, anpoi ma ntuthae sin. ");
INSERT INTO aaz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oras maans ii he noi nmouf, too mfaun ein neikin areꞌ amenat, ma areꞌ tuaf reꞌ anniut saen. Sin neik sin neun Naiꞌ Yesus ma antotin turun-babat he narekoꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Areꞌ too mfaun anbin kota naan neman ma nauban naan anbin uim jaan in enon. ");
INSERT INTO aaz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Too mfaun ein naan, amenat humaꞌ-humaꞌ, ma Naiꞌ Yesus narekoꞌ sin ok-okeꞌ. Ma In nriuꞌ napoitan niut reꞌuf amfaun. Mes In ka nfee fa mainuan neu niut reuꞌf ein naꞌuab ein, natuin sin nahiin Je. ");
INSERT INTO aaz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neis noi nmeu reꞌ meisꞌokan, Naiꞌ Yesus anfeen ma annao nasaitan umi naan. In nnao neu baer ruman ma maꞌkoroꞌ, he nꞌonen ma naꞌuab nok Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Oras naiꞌ Simon nok in aok-bian ein anfenan, sin ka niit Ee fa. Onaim sin nnao naim Je. ");
INSERT INTO aaz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oras sin nateef nok Ne te, sin naꞌuab neu Ne mnak, “Aam! Too mfaun ein naim Ko. Atkoen ok he tfain nai, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mes In nataah am nak, “Reko msaꞌ. Mes reko nneis, hit tnao teu kuan bian anteniꞌ feꞌ, reꞌ anpaumakan etan reꞌ ia. Au he utoon Rais Reko ꞌeu sin imsaꞌ. Natuin Au meup uuf ii, es reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Rarit In nnao nfuun am nateef anbi propinsi Galilea, he nsaksii ma natoon Rais Reko naꞌko Uisneno anbi uim oen ein meseꞌ-meseꞌ. Anbi naan amsaꞌ, In nriuꞌ napoitan areꞌ kanan niut reuꞌf ein naꞌkon ameent ein. ");
INSERT INTO aaz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oras naan, anmuiꞌ atoin ameen nui-atrokiꞌ tuaf es neem neu Naiꞌ Yesus. In nriꞌtuu ma antoit turun-babat naꞌko Naiꞌ Yesus am nak, “Aam! Ambaab maan kau, tua! Au uhiin ꞌak Ho bisa murekoꞌ au menas, henatiꞌ atoniꞌ kaisaꞌ nmaiꞌnisin anteniꞌ kau. Asar Ho mroim, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Naiꞌ Yesus ankasian atoniꞌ naan, onaim In annonaꞌ In aꞌniman ma nreoꞌ goe. In naꞌuab am nak, “Au ꞌroim! Onaim Au urekoꞌ ko nai!” ");
INSERT INTO aaz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nok askeken ate, menas naan namneuk nain, ma in nareko nfain anbi oras reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Rarit Naiꞌ Yesus anreun atoniꞌ naan he nfain, ma namnaub ee, ");
INSERT INTO aaz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","mnak, “Amneen murek-rekoꞌ! Au he ꞌbaꞌan ko! Ho mureko mfain jen, mes ka nabeiꞌ fa he mutoon meu sekau-sekau. Ho ro he mutuin kaꞌo Musa in aprenat. Onaim ho mnao muhuun meu aꞌnaak rais pirsait Yahudi henatiꞌ in nparikas ho aom, he in nahiin batuur-batuur nak, ho mureko mfain jen, aiꞌ kaah? Rarit ho meik fuaꞌ-turuꞌ he anjair tanar nak, ho mtoit makasi, henaꞌ too mfaun ein nahinin am nak ho mureko mfain batuur-batuur een.” ");
INSERT INTO aaz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mes atoniꞌ naan anpoi nnao ma nsaksii naꞌko baer jes neu baer jes anbi mee-mee. Es naan ate, too mfaun ein namin ranan he natefan nok Naiꞌ Yesus, tar antea In ka bisa nakriraꞌ fa In tuan ee anbi kota. Onaim In natua nbi bare-bare reꞌ ruman ma maꞌkoroꞌ, reꞌ naꞌroo naꞌko kota. Ma too mfaun ein naꞌkon mee-mee, neman ma naim Je he nateef nok Ne. ");
INSERT INTO aaz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ankoon neno fauk on naan ate, Naiꞌ Yesus annao nfani ntein neu kota Kapernaum. Ma abitan bare naan anmaktoon ein anbin mee-mee mnak, In et umi. ");
INSERT INTO aaz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Es naan ate, too mfaun ein neman naꞌkon mee-mee. Sin nauban naan Ee tar antea umi naan naꞌkeek nok too. Ma umi naan in eonꞌ ee maꞌekaꞌ nok too msaꞌ. Anbi naan ate, Naiꞌ Yesus natonan sin Uisneno In Kabin ma Prenat. ");
INSERT INTO aaz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oras In naꞌuab feꞌe te, anmuiꞌ atoniꞌ haa nroi neik atoin abuat es, he neik je neu Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mes, natuin too mfaun ein naan, sin ka bisa neik fa atoniꞌ naan ntea Naiꞌ Yesus In matan. Onaim sin nsaen neun uim je tunan, ma sin npukai umi naan in tefin, nataib on anbi Naiꞌ Yesus In aꞌnakan. Oras sin npukai narair uim naan in teifn ate, naꞌ sin nasanut abuat naan nok nain in aꞌnahek. ");
INSERT INTO aaz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Oras Naiꞌ Yesus niit sin nmoꞌen on naan ate, In nahiin nak, sin npirsain batuur-batuur neu Ne. Onaim In nak neu abuat naan am nak, “Baꞌe! Ho saant ein masakoꞌ nrair.” ");
INSERT INTO aaz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Anbi naan, tunggur agama rais pirsait Yahudi tuaf fauk nok antokon. Oras sin nneen Naiꞌ Yesus In uaban naan, sin nnaben ate ka reko fa. ");
INSERT INTO aaz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Rarit sin naꞌuab ein es nok es am nak, “Airoo. Atoniꞌ ia, ro In nabrain he naꞌuab on reꞌ nee, joo! Suma Uisneno es reꞌ bisa nsaok atoniꞌ sin sanat. Mes atoniꞌ ia In uabn ii naiks on, on reꞌ In es reꞌ Uisneno. In naꞌakan Uisneno es reꞌ nee!” ");
INSERT INTO aaz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mes Naiꞌ Yesus nahini nrair sin neek ein. Rarit In nak sin am nak, “Hi kais mitenab on reꞌ naan, tua! ");
INSERT INTO aaz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Mee es maꞌkafaꞌ nneis ji? Karu Au ꞌak ꞌeu atoin abuat reꞌ ia mꞌak, ‘Ho saant ein masakoꞌ nrair,’ hi ka mihiin fa neu he njari oo, aiꞌ kaah? Mes karu Au ꞌak ‘Amfeen nai! Mait ho ꞌnahek ma mfain nai!’ Karu in nfeen oras naan ate, of naꞌ hi miit ma mihini mmak, Au es reꞌ Mansian Batuur-Batuur. Fin Au ꞌmuiꞌ kuasat ma hak he ꞌsaok sanat.” Rarit Naiꞌ Yesus nak neu atoin abuat naan am nak, ");
INSERT INTO aaz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Amneen, oo! Oras ia, ho mureok goen! Onaim amfeen nai, mait ho ꞌnaehk aan ma mfain nai.” ");
INSERT INTO aaz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anneen on naan ate, abuat naan anfeen nain. In nnuun ma nait in aꞌnaehk ee, rarit anpoi nnao. Areꞌ too mfaun ein reꞌ nitan nok sin maatk ein, ansanmakan, onaim naꞌuab ein am nak, “Amoo! Hit feꞌ tiit rasi reꞌ ia, joo! Uisneno ro mapinaꞌ-makrahaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Rarit Naiꞌ Yesus annao nfani ntein neu nefo Galilea in ninin. Too mfaun ein neman ma natefan nok Ne, ma In nanoniꞌ sin anmatoom nok Uisneno In Kabin ma Prenat. ");
INSERT INTO aaz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anbi bare naan, anmuiꞌ tuaf es, kaan ee naiꞌ Lewi, naiꞌ Alfius in aan mone. In meupn ii es reꞌ he nhoik beo he nfee je neu anaaꞌ aprenat pah Roma. Oras Naiꞌ Yesus annao npeoꞌ naan ate, In niit naiꞌ Lewi. Onaim In nak ee mnak, “Baꞌe! Uum he mutuinaꞌ Kau nai!” Anneen on naan ate, naiꞌ Lewi anfeen am natuinaꞌ nain Je. ");
INSERT INTO aaz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Rarit Naiꞌ Yesus sin antokon ma nbukaen nbin naiꞌ Lewi in umi, nabua nok naiꞌ Lewi in partei ahoik beo ngguin. Anbi naan amsaꞌ, anmuiꞌ tuaf bian reꞌ atoin Yahudis nakan sin atoin amoeꞌ reꞌuf, nok anbukaen. Too mfaun ein reꞌ antokon ma nbukaen nbin naan, anromin he nnenan Naiꞌ Yesus In uaban. ");
INSERT INTO aaz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Oras naan, tunggur agama tuaf fauk naꞌkon partei pirsait Farisi, sin niit Naiꞌ Yesus antook ma anbukae nok ahoik beo ngguin, ma areꞌ amoeꞌ reuꞌf ein. Onaim sin nataan In atoup noinꞌ ein am nak, “Nansaaꞌ am es hi Tunggur goe naah-niun nabua nok ahoik beo ngguin ma amoeꞌ reuꞌf ein?” ");
INSERT INTO aaz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mes Naiꞌ Yesus anneen sin haan tanas naan, rarit In nataah sin am nak, “Atoin amenat naim arekoꞌ menas, mes atoin ao-minaꞌ ka naim fa arekoꞌ menas. Au ꞌuum he ꞌpairoir atoniꞌ reꞌ namreuꞌ. Mes Au ka ꞌuum fa he ꞌpairoir atoniꞌ reꞌ annaben in tuan ii te, namneo.” ");
INSERT INTO aaz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Neot es, tuaf naꞌkon partei pirsait Farisi, sin nanaah ok. Sin niit naiꞌ Yohanis in atoup noinꞌ ein nanaah ok amsaꞌ. Mes sin ka niit nitan fa Naiꞌ Yesus in atoup noinꞌ ein nanaah ok on reꞌ sin. Es naan ate, tuaf bian naꞌko sin, neman ma natefan nok Naiꞌ Yesus, he natanan am nak, “Aam! Hai minaah om. Naiꞌ Yohanis in atoup noinꞌ ein nanaah ok amsaꞌ. Mes nansaaꞌ am es Ho atoup noinꞌ ein ka nanaah ok fa?” ");
INSERT INTO aaz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naiꞌ Yesus nataah sin am nak, “Hi mihini mrair, karu anmuiꞌ fesat kabin, taumn ein sin ka nanaah ok fa, mes sin nbukaen tar namsenan. Karu nai moen ji nbi naan feꞌ, sin of anbukaen buꞌ-buaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mes anbi oors es, karu tuaf nabaak neik nai mone naan ate, in aok-bian sin neek ein ansusan, naꞌ sin nanaah ok.” ");
INSERT INTO aaz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Rarit Naiꞌ Yesus naretaꞌ uab manporin es, am nak, “Ka tiit fa tuaf es he npaap sii feꞌu neu baru mnaaꞌ. Fin karu tsaef baru naan, sii feꞌu naan of anꞌuuk gon am anpisu nteniꞌ baru mnaaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","On naan amsaꞌ, ka tiit fa es, reꞌ narai tua miin feꞌu neu ꞌsaap arapuꞌ. Natuin aꞌsapaꞌ naan of natboor, ma tua minaꞌ naan of nasturun npoi okeꞌ. Onaim tua miin feꞌu, ro he tarai je neu ꞌsaap feꞌu.” Nok uabaꞌ naan, Naiꞌ Yesus nanoniꞌ sin am nak, In noniꞌ-taruꞌ feꞌu, kaisaꞌ sin nseor goe nok atoin Farisis sin noniꞌ amnaaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Neot es, nateef nok atoin Yahudis sin neon onen, Naiꞌ Yesus sin nnaon npeꞌ-peꞌon reen ein sin niink ein. Ma In atoup noinꞌ ein anhetun maak-gandum he sin nnahan. ");
INSERT INTO aaz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Atoin Farisis niit sin nmoꞌen on naan ate, sin nak neu Naiꞌ Yesus am nak, “Nansaaꞌ am es Ho atoup noinꞌ ein antanhai hit atoran rais pirsait? Sin nhetun maak-gandum nateef nok neno snasat! Ka nabeiꞌ fa he hi mmoeꞌ on reꞌ naan!” ");
INSERT INTO aaz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","In nataah am nak, “On mee? Hi ka mimnau fa retaꞌ naꞌko naiꞌ-kaꞌo naiꞌ Daut? Oras naan, naiꞌ Abiatar anjair aꞌnaak pirsait Yahudi sin aꞌnaak koꞌu. Naiꞌ Daut nok in tuaf ein sin taik ein naꞌroton tar namnahan nmaten. Onaim sin ntaman anbin Uisneno In Tenar Onen, ma nait utunuꞌ reꞌ aꞌnaak pirsait ein nafuat ma nanaꞌat anrair sin neun Uisneno, ma sin nbukaen. Te kaah, amneon ii, suma aꞌnaak pirsait ein esan reꞌ bisa nbukae sin, mes tua ꞌtetaꞌ naꞌko naan ate, ka bole fa. Rarit naiꞌ Daut sin nbukae utuun ein naan, mes ka tiit fa es, reꞌ nakainaꞌ sin.” ");
INSERT INTO aaz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Rarit Naiꞌ Yesus naꞌuab neu sin antein am nak, “Natiꞌ kaisaꞌ mnikan, mak Uisneno naparaꞌ neno snasat he nfee arekot reꞌ he nturun ma nbaab mansian arkit. Mes In ka nmoeꞌ fa mansian ii he natuin ahaa neno snasat in atoorn ein. ");
INSERT INTO aaz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Au reꞌ ia, Mansian Batuur-Batuur. Au ꞌmuiꞌ hak he ꞌreek mansian he bisa nmeup saaꞌ-saaꞌ anbi neno snasat. Ma Au ꞌmuiꞌ hak amsaꞌ he ꞌpenan mansian he kaisaꞌ nmeup saaꞌ-saaꞌ anbi neno snasat.” ");
INSERT INTO aaz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Rarit Naiꞌ Yesus anfani nteniꞌ nbi uim onen. Anbi naan, In niit atoin es, reꞌ in aꞌniman bian ee nmaet. ");
INSERT INTO aaz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Anbi naan amsaꞌ, anmuiꞌ tuaf bian reꞌ namin ranan piut-piut, he nasaan Naiꞌ Yesus. Es naan ate, sin nsuntiur Goe, he nahinin nak, In narekoꞌ atoin amenat nok neno snasat, aiꞌ kaah. ");
INSERT INTO aaz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Rarit Naiꞌ Yesus noꞌen atoniꞌ reꞌ in aꞌniman bian amates naan, am nak, “Baꞌe! Uum he mhaek meu matan ia.” ");
INSERT INTO aaz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Rarit In nataan sin ok-okeꞌ mnak, “Karu tatuinaꞌ hit atoran rais pirsait, hit bole tmoeꞌ saaꞌ nateef nok neno snasat? He tarekoꞌ, aiꞌ tareuꞌ? He tarekoꞌ atoin amenat, aiꞌ he troor tisan?” Mes sin ka ntonin fa saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Onaim Naiꞌ Yesus In neekn ee nsuus anmaet, natuin sin npeꞌen sin roenk ein he npairoir sin harat anneis naꞌko he npairoir atoniꞌ ꞌniim amates naan. Rarit In natooꞌ ma In naꞌkenaꞌ In maatk ein neu sin. Rarit In nak atoniꞌ naan am nak, “Baꞌe! Amnonaꞌ ho ꞌnimam naan neem!” Onaim atoniꞌ naan annonaꞌ in aꞌniman. Nok askeken ate, in aꞌniman nareok nain. ");
INSERT INTO aaz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Rarit atoniꞌ naꞌkon partei pirsait Farisi anpoin nnaon nasaitan uim onen naan. Ma sin annao natefan nok atoniꞌ naꞌkon partei purtik Herodes, he sin buꞌ-buaꞌ namin ranan he naꞌmaet Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Neot es, Naiꞌ Yesus nok In atoup noinꞌ ein annaon he nasnasan akreꞌo anbin nefo Galilea in ninin. Mes, natuin too mfaun ein anneen saaꞌ reꞌ In anmoꞌe nrair sin, es naan ate, too naꞌkon kuan-kuan neman he natuin Ee. Sin neman naꞌkon propinsi Galilea, Yudea, ma Idumea. Bian anteniꞌ neman naꞌkon kota Yerusalem, Sidon, ma Tirus. Bian anteniꞌ neman naꞌkon noe Yarden in panin et pasaꞌ neon-saet. Sin arsin namin ranan he natefan nok Ne. ");
INSERT INTO aaz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Naiꞌ Yesus anreek In atoup noinꞌ ein he nami nfeen Ee koof es, natuin amneemt ein naan, sin namfaun. In nroim he naꞌuabaꞌ anbi koofꞌ ee in tunan, henatiꞌ In mamnitaꞌ ma sin neen In hanan. ");
INSERT INTO aaz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Neon goes ii, In narekoꞌ niit amenat amfaun. Etun oras ia, areꞌ amenat bian sin anmabeꞌun he nreoꞌ naan Ee. ");
INSERT INTO aaz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Oras tuaf ein reꞌ anniut saen sin niit Ee, sin ntoofn ok anbin Naiꞌ Yesus In matan. Ma sin anhuun ein am nak, “Ho reꞌ ia, batuur Uisneno In Anah!” ");
INSERT INTO aaz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mes In ntaar sin batuur-batuur am nak, “Kaisaꞌ mitoon meu sekau-sekau saaꞌ-saaꞌ reꞌ anmatoom nok Kau!” ");
INSERT INTO aaz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Rarit Naiꞌ Yesus ansae nbi ꞌtoeꞌf es. In noꞌen naan atoniꞌ fauk he natuin Ee. Onaim sin neem natuin Ee. ");
INSERT INTO aaz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Rarit In nruur naan ahaa atoniꞌ boꞌes am nua. In nak sin am nak, “Au ꞌruur ki he hi mituinaꞌ Kau piut-piut. Au he ꞌreek ki he mnao mitoon Uisneno In Rais Reko neu mansian arsin. ");
INSERT INTO aaz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma Au of aꞌfee ki kuasat he mriuꞌ niut reuꞌf ein miꞌko mansian ein.” ");
INSERT INTO aaz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Atoup noniꞌ tuaf boꞌes am nuaꞌ ein naan, esan reꞌ: naiꞌ Simon (reꞌ Naiꞌ Yesus anteek ee te nak, naiꞌ Petrus), naiꞌ Yakobus, nok in orif, naiꞌ Yohanis, (sin nua sin, naiꞌ Sebedius in aanh ein. Naiꞌ Yesus anteek nanesaꞌ sin nua sin nak, ‘Boanerges’, reꞌ neik hit uab ii te nak ‘ꞌroots ee naꞌpunuꞌ’.) naiꞌ Anderias, naiꞌ Felipus, naiꞌ Bertolomeos, naiꞌ Mateos, naiꞌ Tomas, naiꞌ Yakobus (naiꞌ Alfius in aan mone), naiꞌ Tadius, naiꞌ Simon (atoniꞌ naꞌko partei purtik Selot), ma naiꞌ Judas Iskariot (reꞌ of he naꞌsosaꞌ Naiꞌ Yesus). ");
INSERT INTO aaz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein ansanun nfanin naꞌkon aꞌtoꞌef naan. Ma sin ntaman anbin umi. Too mfaun ein neem nauban antein Ee, tar Naiꞌ Yesus sin ka napenin fa mainuan he nbukaen. ");
INSERT INTO aaz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ankius on naan ate, tuaf naꞌuab ein am nak, “Amkius miit Naiꞌ Yesus. In nnikaꞌ nain In tuan, ma ka mapairoriꞌ fa.” In baꞌaasr ein sin anneen uabaꞌ naan, onaim sin neman he nok Ne nfain. ");
INSERT INTO aaz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Oras naan, tunggur agama fauk naꞌkon kota Yerusalem, neman ma natonan abitan reꞌ naan am nak, “Hi kais mituinaꞌ Naiꞌ Yesus. Natuin niut reuꞌf ein sin aꞌnaak kouꞌ goe, reꞌ anteek ee te nak Balsebul, antaam anrair et In tuan, ma nfee Ne kuasat he In nriuꞌ niut reuꞌf ein.” ");
INSERT INTO aaz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oras Naiꞌ Yesus anneen on naan ate, In nhaman nabuabaꞌ sin am nak, “Rasi naan, ka matopuꞌ reko fa, tua! Nok ranan mee, niut reuꞌf ein sin aꞌnaak kouꞌ goe bisa nriuꞌ nafani in tuan? ");
INSERT INTO aaz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Karu anbi pah es, in too goe nmatoen ma nmabanan piut, nok ranan mee henatiꞌ pah naan bisa nhaek nabaar? ");
INSERT INTO aaz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma nbi uim jes in nanan, karu sin es-es ate anmanau nanan, nok ranan mee henatiꞌ sin bisa nhaek nabaran? ");
INSERT INTO aaz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","On naan amsaꞌ, karu niut reuꞌf ein sin anmamusun es nok es, ro sin of anbaits ok. Karu njair on naan ate, sin namreꞌun nmaten. ");
INSERT INTO aaz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Karu atoin es he neem nabaak aiꞌ nasiik bareꞌ anbi atoin maꞌtaniꞌ es in umi, in ro he nfuut naheran atoin maꞌtaniꞌ naan nahuun feꞌ. Rarit naꞌ in napein mainuan he nait atoniꞌ naan in baerꞌ ein. ");
INSERT INTO aaz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Onaim Au utoon ꞌain ki: Uisneno nabarab ma npao he nnoes nain areꞌ mansian ein sin saant ein. Ma karu sekau naꞌuab naꞌreꞌuf tuaf es, Uisneno nabarab feꞌ he nsaok sanat naan. ");
INSERT INTO aaz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mes karu sekau-sekau naꞌuab naꞌreꞌuf Uisneno In Asmaan Akninuꞌ, Uisneno ka nsaok fa in sanat naan, tar antea nabar-baar!” ");
INSERT INTO aaz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Naiꞌ Yesus naꞌuab on naan, natuin sin naꞌuab naꞌreuꞌf Ee mnak, “Tuaf reꞌ ia, anniut sae!” ");
INSERT INTO aaz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Rarit Naiꞌ Yesus In ainf ee nok In oirf ein sin neman neun umi naan, he natefan nok Ne. Sin nhaken nbin moneꞌ ma anrekan tuaf he noeꞌn Ee. ");
INSERT INTO aaz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Oras naan, Naiꞌ Yesus antook ma naꞌuabaꞌ nok too mfaun anbi uim je nanan. Rarit tua reek ein naan antaman ma natoon Ee mnak, “Aam! Ho ainaꞌ nok Ho oirf ein etan moneꞌ. Sin he natefan nok Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mes Naiꞌ Yesus nataah neik haan tanas am nak, “Au ainaꞌ ma Au oriꞌ-tataꞌ amneot, esan reꞌ sekau?” ");
INSERT INTO aaz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Rarit In nait matan ma nkius too reꞌ antokon nibun naan Ee. In naꞌuab am nak, “Hi ar-arki reꞌ ia, amjair Au ainaꞌ ma Au oriꞌ-tataꞌ amneot. ");
INSERT INTO aaz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Fin sekau-sekau reꞌ natuinaꞌ Uisneno In aꞌromin, sin njarin Au nonot-asar amneot.” ");
INSERT INTO aaz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Neot es, Naiꞌ Yesus annao nfani ntein nbi nefo Galilea. Ma too mfaun ein neman ma naub naan Ee. Anmuiꞌ koof es anhake nbi naan. Rarit In ansae ma antoko nbi kofaꞌ naan in tunan, ma nanoniꞌ sin. Too mfaun ein reꞌ anbin nefo naan in ninin, anneen In uaban. ");
INSERT INTO aaz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Onaim In nanoniꞌ sin anmatoom nok rasin mfaun, neik retaꞌ mnak, ");
INSERT INTO aaz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hi mneen mirek-rekoꞌ! Anmuiꞌ naan akaniꞌ fini tuaf es annao ma nkaniꞌ fini nbi in rene. ");
INSERT INTO aaz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Oras in nkaniꞌ fini te, bian anmoufun anbin ranan. Es naan ate, koorn ein neman ma nteo-nsiun nain finin naan. ");
INSERT INTO aaz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma fini bian anmoufun anbin auf mafatuꞌ reꞌ in auf goe mainihas. Finin naan natoron rabah. Mes natuin afu naan mainihas, ");
INSERT INTO aaz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","es naan ate, oras maans ee nsae, fiin atoors ein naan namnenen ma nmaten, natuin sin aꞌbaaꞌk ein ka ntaman ntean fa auf goe in aꞌpinan. ");
INSERT INTO aaz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fini bian anteniꞌ nmoufun anbin huu maꞌaikaꞌ. Rarit huu maꞌaikaꞌ naan anneo niis finin naan, tar antea ka bisa napunin fa. ");
INSERT INTO aaz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma fini bian anmoufun nbin auf afaꞌ. Finin naan natoron, ma naꞌnaen tar napunin. Fini bian nasuuf no boꞌ teun, bian no boꞌ nee, ma bian no nautn es. ");
INSERT INTO aaz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Onaim sekau nneen ma nheek naan retaꞌ ia in aꞌmoufun, maut he in nateenb ee nnao nkoon.” ");
INSERT INTO aaz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Rarit oras Naiꞌ Yesus anmes-mees, In atoup noinꞌ ein tuaf boꞌes am nua, nok atoniꞌ bian antein reꞌ anneen niit In retaꞌ naan, neman he natefan nok Ne. Sin antotin henatiꞌ In natoon neu sin retaꞌ naan in aꞌmoufun. ");
INSERT INTO aaz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naiꞌ Yesus nataah sin am nak, “Natuin hi mroim he mihiin Uisneno In Aprenat batuur-batuur, es naan ate, Au utoon ki retaꞌ naan in aꞌmoufun. Mes neu tuaf bian, Au unoniꞌ sin ꞌeik retaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Atoniꞌ bian sin nahuum on reꞌ saaꞌ reꞌ Uisneno In mafefa kninuꞌ antui niit am nak, ‘Sin nitan nrarin, mes ka nromin fa he nahinin. Sin nnenan nrarin, mes sin ka nromin fa he ntoupun. Maut he sin kais anpirsain neun Uisneno, henatiꞌ Uisneno kais anperluu he nfeen sin saok sanat antein.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Rarit Naiꞌ Yesus anfei oten naꞌko retaꞌ naan am nak, “Karu hi ka mheek fa retaꞌ ia in aꞌmoufun, nok ranan mee, he hi bisa mheek retaꞌ bian sin aꞌmoufk ein? ");
INSERT INTO aaz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Onaim retaꞌ ia in aꞌmoufn ii on nai: akaniꞌ fini naan, es reꞌ tuaf reꞌ nsaksii ma natoon Uisneno In Kabin ma Prenat. ");
INSERT INTO aaz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Finin reꞌ anmoufun anbin ranan, tar antea koorn ein anteo-nsiun nain sin naan, esan reꞌ tuaf-tuaf reꞌ anneen Uisneno In Kabin ma Prenat. Mes ka ꞌroo fa te, niut reuꞌf ein sin aꞌnaak kouꞌ goe neem ma nasiik naan Kabin ma Prenat naan naꞌko sin neek ein. ");
INSERT INTO aaz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Finin reꞌ anmoufun nbin auf mafatuꞌ, esan reꞌ tuaf-tuaf reꞌ anneen ma antoup Kabin ma Prenat naan nok neek marinet. ");
INSERT INTO aaz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mes Kabin ma Prenat naan ka naꞌbaaꞌ fa. Es naan ate, in ka ntahan fa ꞌroo anbi sin neek ein. Ma oras atoniꞌ bian nasusab sin, natuin sin antoup Kabin ma Prenat naan, sin nporin nain Kabin ma Prenat reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Finin reꞌ anmoufun nbin huu maꞌaikaꞌ in aꞌtnanan, esan reꞌ tuaf ein reꞌ anneen anrair Kabin ma Prenat naan. ");
INSERT INTO aaz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mes sin ntaisibun mainenuꞌ nok rasi humaꞌ-humaꞌ, he sin nharineb sin tuak ein. Es naan ate, taisibu humaꞌ-humaꞌ naan, es reꞌ ansiuꞌ napoitan Kabin ma Prenat naan naꞌko sin neek ein, onaim Kabin ma Prenat naan ka nafua fa saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma finin reꞌ anmoufun neu auf afaꞌ, esan reꞌ sin reꞌ anneen ma antoup Kabin ma Prenat naan, rarit natuin Uisneno In aꞌromin. Rarit sin nmoeꞌ ꞌmoeꞌ areokt ein, on reꞌ finin reꞌ nafuan. Moꞌet bian nasuuf no boꞌ teun, bian no boꞌ nee, ma bian no nautn es.” ");
INSERT INTO aaz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Naiꞌ Yesus naꞌuab piut naꞌko koofꞌ ee in tunan. In nfee retaꞌ es anteniꞌ mnak, “On mee! Hi miit miit, aiꞌ kaah, karu atoniꞌ nout pauk anaꞌ, rarit antoeb je npaek aꞌkoraꞌ? Aiꞌ natuun ee nbi haark ee in nupun. Ka tiit fa feꞌ, aiꞌ? Karu natuun ee nbi naan, in ka npiin fa goen. Atoniꞌ ro he natunuꞌ paku nbi bare ꞌratan he npiin. ");
INSERT INTO aaz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nok ranan naan, rasi reꞌ nahunu te maꞌkoroꞌ, of mamnitaꞌ. Ma saaꞌ reꞌ oras ia ka mahiniꞌ fa, of mahiniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sekau es reꞌ anneen ma anheek naan retaꞌ ia in aꞌmoufun, maut he nateenb ee nnao nkoon. ");
INSERT INTO aaz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mitenab mirek-rekoꞌ! Karu hi mnilei atoniꞌ in aꞌmoꞌen, atoniꞌ bian of annilei ki on naan msaꞌ. Uisneno of annilei ki nneis naꞌko naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Karu sekau he naim Uisneno In romin batuur-batuur ate, in mahiin ee of nafaof gon piut. Mes tuaf reꞌ ka nrae natuin fa Uisneno In romin, in moon goe of nafaof gon piut amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Uisneno In Apreent ii anhainua ntein on, on reꞌ finin reꞌ maponeꞌ anbi atoniꞌ in rene. ");
INSERT INTO aaz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Maski atoniꞌ naan anfain neu in umi, ma fai-manas in ntuup ma nfeen, in nnikan nain finin naan. Mes finin naan natoor ma naꞌnaen piut. ");
INSERT INTO aaz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Finin naan anmonin kuuk anbin afu, anmurai naꞌnaen, nasufan, ma napunin. ");
INSERT INTO aaz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Karu maak ee namnatu te, in tuan ee suma neem he noun goah. Uisneno In Apreent ii on naan amsaꞌ. Areꞌ saaꞌ-saaꞌ ii, Uisneno es reꞌ anmeup sin.” ");
INSERT INTO aaz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Au ꞌfee ꞌteniꞌ ki reet es on nai. Uisneno Iin na, un-unuꞌ te sin fauk aah, mes naꞌko neno neu neno, sin nmaꞌbaab ok piut ma amfau reuꞌf ein. ");
INSERT INTO aaz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naan namnees on reꞌ fini reꞌ ana krisiꞌ nbi poꞌon. ");
INSERT INTO aaz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Karu hit tseen fua ana krisiꞌ naan, in naꞌnae njair hau kouꞌ reꞌuf nbi poꞌon naan. Tar antea koorn ein neman ma namin mafoꞌ anbin naan, ma nakuun ein.” ");
INSERT INTO aaz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Naiꞌ Yesus nanoniꞌ sin anpake cara on reꞌ naan, natai nok sin hinit. ");
INSERT INTO aaz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In biasa npaek retaꞌ karu In nanoniꞌ tuaf bian sin. Mes karu In nok In atoup noinꞌ ein, In natoon areꞌ retaꞌ naan sin aꞌmoufk ein. ");
INSERT INTO aaz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maans ii nmaeb jen, mes Naiꞌ Yesus anbi koofꞌ ee tuun ee feꞌ. Ma In nreun In atoup noinꞌ ein am nak, “Iim arkit atraak teu neof goe panin.” ");
INSERT INTO aaz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rarit sin nsaen kofaꞌ buꞌ-buaꞌ nok Naiꞌ Yesus. Ma sin nnao nasaitan too mfaun ein anbin naan. Mes bian ansaen nbin kofaꞌ ꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Oras naan Naiꞌ Yesus antao In aꞌnakan anbi akaꞌnunuꞌ ma ntuup anfiin anbi koofꞌ ee in kotin nanan. Sin annaon ka ꞌroo fa te, ain kouꞌ goe neem. Ma oikn ein anpesan sin, ma oe je ntaam anbi Naiꞌ Yesus sin kofaꞌ, tar antea aar akreꞌo te naheun. Onaim atoup noinꞌ ein namtau nmaten. Ma sin neem anpooꞌ nafeen Ee mnak, “Aam! Amfeen feꞌ! Hit he treem atmaet jen! Mes Ho ka mfairoir kit fa!” ");
INSERT INTO aaz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Anneen on naan ate, Naiꞌ Yesus anfeen ma ntaar anin am nak, “Musnaas nai!” Rarit In naprenat oikn ein naan am nak, “Miꞌtenaꞌ nai!” Oras naan, anin naan nasnaas nain, ma oikn ein naan naꞌteen ein nanin. ");
INSERT INTO aaz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Rarit Naiꞌ Yesus nakain In atoup noinꞌ ein am nak, “Nansaaꞌ am es hi mimtau baisekeꞌ on naan? Hi ka mmuiꞌ fa rasi fnekat meu Kau, oo?” ");
INSERT INTO aaz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sin arsin namtaun ma nsanmakan. Ma sin naꞌuab ein am nak, “In reꞌ ia, sekau? Tar antea anin ma oikn ein sin natuin In aprenat!” ");
INSERT INTO aaz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein antean nefo Galilea in panin, anbi baer jes reꞌ anteek ee te, nak Gerasa. ");
INSERT INTO aaz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Anbi naan, anmuiꞌ naan atoin es anniut sae tar in namaun. In natua nbi faut naetf ein. Fai-manas in naꞌoin neu-mneem nok ao afaꞌ nkoon anbi areꞌ kneteꞌ ma ꞌnoonf ein, ma nhunun ka natfeek fa. In ntuut napapaꞌ in aon neik fatu. In maꞌtain reꞌuf. Ka tiit fa es, reꞌ bisa nfuut goe, maski npaken korenit amsaꞌ. Sin nfuut in haen-niman fani-fani npaken korenit, mes in nafeek koreent ein naan, ma niit besin naan in naꞌiup sin naꞌkon in haek ein. In ro maꞌtain reꞌuf, tar antea ka tiit fa tuaf es, reꞌ bisa ntahan naan ee. Oras Naiꞌ Yesus sin ansanun naꞌkon kofaꞌ, aniut saes naan niit sin naꞌko aꞌroo. In npoi naꞌko faut naetf ein, ma in naen anꞌain Naiꞌ Yesus ma nriꞌtuu nbi In matan. ");
INSERT INTO aaz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Oras Naiꞌ Yesus niit atoniꞌ naan ate, In naꞌuab am nak, “Hoi! Niut reꞌuf! Ampoi nai muꞌko atoniꞌ ia!” Rarit atoniꞌ naan anhunun naher-heer am nak, “Hoi! Ho he munsaaꞌ kau? Au uhiin ꞌak Ho reꞌ ia Naiꞌ Yesus, Uisneno Akuasat In Anah. Au ꞌtoit Ko he Ho kaisaꞌ mhaꞌmuiꞌ kau, joo!” ");
INSERT INTO aaz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Rarit Naiꞌ Yesus nataan ee mnak, “Ho kaanm ii sekau?” In nataah am nak, “Au kaank ii naiꞌ Legion, natuin hai mfau reꞌuf, on reꞌ sorarus batalion-batalion ein!” ");
INSERT INTO aaz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Niut reuꞌf ein anpaek atoniꞌ naan he ntoit Naiꞌ Yesus he kaisaꞌ nreun sin he npoin naꞌkon bare naan. ");
INSERT INTO aaz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Anhaumaak bare naan, atoniꞌ fauk antitun fafi pukan kouꞌ goes. Fafin reꞌ naan sin of oniꞌ nifun nua. Sin namin amnahat anbin aꞌtoꞌef naan in abnapan. ");
INSERT INTO aaz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Rarit niut reuꞌf ein antotin am nak, “Amreun kai he hai mnao mtaam meu fafin nee, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naiꞌ Yesus antoup sin haan totis naan. Es naan ate, areꞌ niut reuꞌf ein naan anpoin ma antaman neun fafin naan. Fafi pukan naan, naen ansiksakn ok, ma nasroro nsanun npeꞌon aisanut ma nmoufun ntean niuf goe nanan. Ma sin nreem anmaten ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ankius nitan on naan ate, atiut faifn ein namtaun nmaten. Sin naenan nfuun am natefan kuan-kuan mapaumaak ein, ma natonan areꞌ too mfaun ein. Es naan ate, too mfaun ein anpoi neman he nkius nitan kuuk saaꞌ reꞌ anjarin nrair anbi naan. ");
INSERT INTO aaz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sin neem natefan nok Naiꞌ Yesus, ma sin niit atoin aniut saes naan antook anbi naan. Mes in teenb ee nareko nrair, ma in anpaek tais. Ma oras sin niit rasi naan sin arsin namtaun, fin sin nahinin nak sekau es reꞌ nabeiꞌ he nriuꞌ napoitan niut reuꞌf ein naꞌkon atoniꞌ naan, ro in atoin maꞌtain reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rarit sin arsin anmaktoon ein nak sin niit nok sin maatk ein nak, atoin aniut saes naan nareko nrair, ma faifn ein anreman nmaten. ");
INSERT INTO aaz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rarit sin ntotin teb-tebe he Naiꞌ Yesus annao nasaitan sin pah. ");
INSERT INTO aaz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Oras Naiꞌ Yesus he nsae nfain neu kofaꞌ naan ate, atoin aniut saes reꞌ nareko nrair naan neem ma ntoit he in bisa nnao nabua nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mes Naiꞌ Yesus anpeen. In naꞌuab neu atoniꞌ naan am nak, “Reko nneis ho mfain nai meu ho noont ein. Mutoon meu sin areꞌ kanan rasi reꞌ Uisneno nmoꞌe nrair sin neu ko. Mutoon meu sin am mak, Uisneno nneek ma nkasian ko!” ");
INSERT INTO aaz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Rarit atoniꞌ naan annao nfuun am nateef pah es nok nain in koat ein boꞌes, reꞌ anteek ee te, nak ‘Dekapolis’. In nsaksii ma natoon areꞌ kanan rasi reꞌ Naiꞌ Yesus anmoeꞌ nrair sin neu ne. Ma areꞌ tuaf-tuaf reꞌ anneen in uaban naan ansanmakan ma naꞌuab ein nak, “Ro maꞌtaniꞌ, oo!” ");
INSERT INTO aaz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Rarit Naiꞌ Yesus sin ansaen kofaꞌ ma anraak anfanin neun neof goe in panin. Oras sin ansanun naꞌko kofaꞌ naan, too mfaun ein neman ma nauban naan Ee. ");
INSERT INTO aaz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Anbi kota naan, anmuiꞌ naan atoin es, in kaan ee naiꞌ Yairus. In es reꞌ aꞌnakat anbi uim onen kota naan. Oras in niit Naiꞌ Yesus, in nriꞌtuu nbi Naiꞌ Yesus In matan, ");
INSERT INTO aaz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ntoit Je mnak, “Koi, Aam! Au aan feot goe feꞌ toon boꞌes am nua. In nameen ma he noi nmaet jen. Ho mkoen Om uum he mturun murekoꞌ maan au anah naan, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Onaim Naiꞌ Yesus annao natuin naiꞌ Yairus neu in umi. Oras sin annaon on naan ate, too mfaun ein nokan ma anbeuꞌ Goe. ");
INSERT INTO aaz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Anbi too mfaun ein naan, anmuiꞌ bifee jes reꞌ napein funan reꞌ nroni kreꞌo-kreꞌo ka natfeek niit fa oniꞌ toon boꞌes am nua goen. ");
INSERT INTO aaz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","In narair roit nok in aꞌmuiꞌk ein he nbaen arekoꞌ meens ein. Mes ka tiit fa tuaf es bisa narekoꞌ in menas naan. In naaꞌ ii ka nheut niit fa, tar in menas naan maꞌfenaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Bifee naan anneen fani-fani anmatoom nok Naiꞌ Yesus. Es naan ate, in nbeuꞌ too mfaun ein naan, he npaumak-maak anbi Naiꞌ Yesus In kotin. In natenab am nak, “Asar au ꞌreoꞌ ꞌaan ahaa In baru mnanuꞌ, au of ureok.” Oras in nreoꞌ Naiꞌ Yesus In baur goe te, nok askeken, naaꞌ naan anheut. In nnaben ate in nareok goen. ");
INSERT INTO aaz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nateef oras naan amsaꞌ, Naiꞌ Yesus annaben ate anmuiꞌ nenuf reꞌ anpoi naꞌko In tuan. Es naan ate, In nabaniꞌ ma nkius neu too mfaun ein naan. Rarit In nataan sin am nak, “Sekau es reꞌ anreoꞌ Au baru?” ");
INSERT INTO aaz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","In atoup noinꞌ ein natahan am nak, “Ho mkius Kuum. Too mfaun sin anmabeꞌun es nok es ate, Ho mutaan am mak, ‘Sekau es reꞌ anreoꞌ Au baru?’ ” ");
INSERT INTO aaz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naiꞌ Yesus ankius sin meseꞌ-meseꞌ he naim tuaf reꞌ anreoꞌ In baur goe. ");
INSERT INTO aaz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Anneen Naiꞌ Yesus nataan on naan ate, bifee reꞌ naan namtau ma naꞌtaꞌi. Rarit in nriꞌtuu nbi Naiꞌ Yesus In human ma In matan, ma nmanakuꞌ mnak, “Koi, Aam! Au es reꞌ aꞌreoꞌ ho baru naan, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Naiꞌ Yesus antoin bifee naan am nak, “Ain! Natuin ho nekam naꞌteeb batuur neu Kau, es naan ate ho mureok. Ho mfain nai nok neek marinet, fin ho susat naan namsoup goen.” ");
INSERT INTO aaz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Oras Naiꞌ Yesus naꞌuab feꞌ on naan ate, tuaf neman naꞌkon naiꞌ Yairus in umi, ma natoon am nak, “Eee, kasian! Ho aan feot goe, ain ee oekꞌ ein, tua. Kaisaꞌ muhaebaꞌ Uis tungguru mtein!” ");
INSERT INTO aaz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mes Naiꞌ Yesus ka nfairoir fa tuaf ein naan sin uabk ein. Onaim In naꞌuab neu naiꞌ Yairus am nak, “Kais mumtau! Ampirsai meu Uisneno!” ");
INSERT INTO aaz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Rarit Naiꞌ Yesus anreun too mfaun ein ok-okeꞌ he namaik antaahn ein nbin naan. Mes In nok ahaa naiꞌ Petrus, naiꞌ Yakobus ma in orif naiꞌ Yohanis, he sin annaon nkonon. ");
INSERT INTO aaz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oras sin antean naiꞌ Yairus in umi, sin niit too mfaun anꞌuurs ein biru ma tainaunus humaꞌ-humaꞌ, bian ankaen, ma bian nainin. ");
INSERT INTO aaz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Naiꞌ Yesus antaam anbi naan. In nataan sin am nak, “Nansaaꞌ am es hi mtaisiub ma mkae on reꞌ ia? Riꞌanaꞌ reꞌ ia ka nmaet fa. In suma ntuup kuun.” ");
INSERT INTO aaz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Oras sin neen Naiꞌ Yesus naꞌuab on naan ate, sin nmanin nfaer Ee. Rarit In nreun sin he npoin ok-okeꞌ. In noꞌen riꞌanaꞌ naan in ainaf-amaf, ma nok In atoup noniꞌ tuaf teun, rarit sin arsin antaman anbin riꞌanaꞌ naan in keꞌen. ");
INSERT INTO aaz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Onaim Naiꞌ Yesus annaaꞌ riꞌanaꞌ naan in aꞌniman, rarit In npaek sin uab Aram am nak, “Talita kum!” (Reꞌ neik hit uab ii te nak, “Aan feto! Amfeen nai!”) ");
INSERT INTO aaz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Nok askeken ate, riꞌaan feto naan anfeen ma anhaek. Naiꞌ Yesus anreek aan feto naan in ainf ee nak, “Amfee ne he naah!” Areꞌ too mfaun ein reꞌ niit rasi naan ansanmakan. Mes Naiꞌ Yesus antaar sin nok haan maꞌtaniꞌ mnak, “Kaisaꞌ mitonan es-es mak Au umonib ufaniꞌ riꞌaan feot amates reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein annaon nfanin neun In kuan Nasaret. ");
INSERT INTO aaz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nateef nok atoin Yahudis sin neon onen, Naiꞌ Yesus antaam anbi uim onen he nfee noniꞌ. Neno naan, too mfaun ein neman he nꞌoen ein. Oras sin arsin anneen In noinꞌ ein ate, sin nsanmakan ma naꞌuab ein am nak, “Atoniꞌ ia mahiin ii maꞌtaniꞌ! In anmuiꞌ kuasat amsaꞌ! Nok ranan mee mꞌes In bisa on reꞌ ia? ");
INSERT INTO aaz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Amneon ii, In suma tukan hau. Hit tahiin In ainaf bi Maria, nok areꞌ In oirf ein, esan reꞌ: naiꞌ Yakobus, naiꞌ Yoses, naiꞌ Judas nok naiꞌ Simon. Hit tahiin In feotf ein amsaꞌ. Hit tok Ne arkit tatua kuan meseꞌ!” Onaim sin nsaekn Ee ma ka nnenan ntein Ee fa. ");
INSERT INTO aaz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Rarit Naiꞌ Yesus naꞌuab am nak, “Tebe! Atoniꞌ anhormaat mafefaꞌ kninuꞌ Uisneno reꞌ anao-amnemat, anneis naꞌko mafefa kninuꞌ kua tuaf.” ");
INSERT INTO aaz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Too mfaun ein, sin neek manun baisekeꞌ, tar sin ka nromin fa he npirsain neun Naiꞌ Yesus. Es naan ate, In nsanmaak, tar antea In ka nmoꞌe nteniꞌ fa rais sanmakat anbi naan. In suma anreoꞌ narekoꞌ naan ahaa amenat fauk aah. ");
INSERT INTO aaz_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Rarit Naiꞌ Yesus annao neu kuan-kuan reꞌ anmapaumaakn ein anbi naan, ma nfee sin noniꞌ anmatoom nok Uisneno In romin. ");
INSERT INTO aaz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","In noꞌen naan atoup noniꞌ tuaf boꞌes am nua, ma nreun sin tuaf nu-nua, he nnaon ma natoon Uisneno In Rais Reko. In nfee kuasat amsaꞌ neu sin he nriꞌun niut reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","In nbaꞌan sin am nak, “Kaisaꞌ meik bruaꞌ amfaun ambi ranan, fin Uisneno of es reꞌ anꞌator hi perluut ein. Hi kais meik betiꞌ, noni-roit, ma ꞌkapiꞌ. Hi meiki haa teas, ꞌpein haef, ma mpaek maan ahaa baru meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Karu sekau ntoup ki he mtaam meu in umi, mimaikaꞌ ambi naan tar antea hi mnao mkoon meu bare bian. ");
INSERT INTO aaz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mes karu nbi bare mee sin ka ntoup ki fa, ma sin ka natniin ki fa, ampoi miꞌko bare naan. Ma mitonan sin am mak, ‘Natuin hi ka mroim he mitniin fa, es naan ate maut he hi msutai kiim in amreꞌun!’ ” ");
INSERT INTO aaz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Rarit sin nnaon ma natoon Rais Reko naan. Sin nak, “Areꞌ mansian arki ro he misaitan hi sanat ma penu sin, ma mtebi mfain he mmoin mituin Uisneno In romin.” ");
INSERT INTO aaz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Onaim sin anriuꞌ napoitan niut reuꞌf ein amfaun. On naan amsaꞌ, sin naronip minaꞌ neu atoin amenat sin aꞌnaak ein, ma nꞌoen ein he narekoꞌ sin. Onaim sin narekon. ");
INSERT INTO aaz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oras naan, too nbi bare-bare anneen anrair anmatoom nok Naiꞌ Yesus. Retaꞌ anmatoom nok Naiꞌ Yesus In kuasan manenaꞌ anrair antean usif Herodes amsaꞌ. Tuaf bian naꞌuab ein am nak, “Naiꞌ Yohanis Asranit anmoni nfain et Naiꞌ Yesus In tuan! Etun In naꞌbeiꞌ he nmoeꞌ areꞌ kanan rais sanmakat.” ");
INSERT INTO aaz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mes tuaf bian nak, “Kahaf! In reꞌ ia, mafefa kninuꞌ naiꞌ Elia es reꞌ anmoni nfain et In tuan.” Bian amsaꞌ nak, “In reꞌ naan, Uisneno In mafefa kninuꞌ tuaf es naꞌko ahuunt ein.” ");
INSERT INTO aaz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mes oras Usif Herodes anneen rasi naan ate, in nak, “Ia naiꞌ Yohanis Asranit, reꞌ neon goes ii au ꞌreek tuaf he nꞌoet nafeek in aꞌnakan. Oras ia in nmoin anfain jen.” ");
INSERT INTO aaz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Usif Herodes anreun on reꞌ naan, natuin in nmakaꞌrasiꞌ nok naiꞌ Yohanis. Rasi naan naꞌuub on, on nai: usif naiꞌ Herodes nasiik naan in orif naiꞌ Felipus in fee, kaan ee bi Herodias. Amneon ii, naiꞌ Felipus nok bi Herodias ka nmanpoirn ein fa feꞌ. Natuin rasi naan am es, naiꞌ Yohanis nakain ee fani-fani mnak, “Aam Usiꞌ! Ka nabeiꞌ fa he ho mait ho oriꞌ in fee. Natuin rasi naan antanhai hit harat atoin Yahudis.” Mes naiꞌ Herodes in nsao ruꞌ-ruuꞌ. Ma in nreek tuaf he nheek naiꞌ Yohanis ma nataam ee neu bui. ");
INSERT INTO aaz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Natuin naiꞌ Yohanis nakain ee fani-fani on reꞌ naan, es naan ate bifee naan natunuꞌ neek menas he nroor niis ne. Mes in ka napein mainuan fa feꞌ, fin naiꞌ Herodes nataam anrair naiꞌ Yohanis anbi bui, ");
INSERT INTO aaz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ma nreek soraurs ein he npao goe rek-reko. Naiꞌ Herodes anmanuꞌhain naiꞌ Yohanis. In nahiin nak Uisneno es reꞌ anreek haefan naiꞌ Yohanis. Ma naiꞌ Yohanis naan atoin neek reko. Naiꞌ Herodes anroim he nneen naiꞌ Yohanis in uaban. Mes neot es-neot es ate, in npenan naiꞌ Yohanis in uaban. ");
INSERT INTO aaz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Neot es, fenai Herodias napein mainuan he nateabaꞌ in neek menas naan. Oras naan, sin nfeest ein neun naiꞌ Herodes in neon mahonin. Sin naskau aꞌnaet ein he nokan nbukaen anbin fesat naan. Amnookt ein, sin esan reꞌ anaaꞌ aprenat, aꞌnaak sorarus, ma mnasi-mnasiꞌ pah Galilea. ");
INSERT INTO aaz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oras feest ii ntainua goen, fenai Herodias in aan feot goe antaam neem ma nabsooꞌ. In absooꞌn ii reokn ii kah een, tar antea nmoeꞌ Usif Herodes nok areꞌ taumn ein fesat naan anmariin anmaten. Es naan ate, Naiꞌ Herodes noꞌen riꞌfeot absoꞌot naan ma nak ee mnak, “Ho mroim he mtoit saaꞌ ate, mutoon! Au ro he ꞌfee ko. ");
INSERT INTO aaz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Maski ho mtoit tar antea nbait nua au preent ii msaꞌ, au ꞌfee ko goe. Au ꞌsuup ꞌeik Uisneno In kanan!” ");
INSERT INTO aaz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Riꞌaan feto naan annao ma nataan in ainf ee mnak, “Ain! Ho mroim he au ꞌtoit saaꞌ reꞌ reko nneis naꞌko amaꞌ?” Ma in ainf ee nataah ee nak, “Hau, oo! Reko! Amnao nai ma mtoit maan naiꞌ Yohanis in aꞌnakan.” ");
INSERT INTO aaz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Rarit riꞌaan feto naan neem rabah neu naiꞌ Herodes in matan am nak, “Aam! Au ꞌtoit he mfee kau naiꞌ Yohanis in aꞌnakan. Amtao maan ee mbi dulang es. Rabah!” ");
INSERT INTO aaz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Oras naiꞌ Herodes anneen haan totis naan ate, in neekn ii namneuk. In ka nabeiꞌ fa he nheer nafaniꞌ in haan supat, natuin areꞌ too mfaun ein anneen narair haan supat naan. ");
INSERT INTO aaz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Rarit in naprenat naan aꞌnaak soraurs es ma nnao nꞌoet neik naiꞌ Yohanis in aꞌnakan naꞌko uim bui. ");
INSERT INTO aaz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Rarit sin nꞌoet naan naiꞌ Yohanis in aꞌnakan, ma ntao goe nbi dulang es. Rarit sin annao naat ee neu riꞌaan feto naan. Riꞌaan feto naan antoup goe, ma nnao nfee je neu in ainaf. ");
INSERT INTO aaz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oras naiꞌ Yohanis in atoup noinꞌ ein annenan nak, anꞌote nrair naiꞌ Yohanis in aꞌnakan, sin neman ma nait neik naiꞌ Yohanis in aon, ma annaon nsuub ee. Retaꞌ anmatoom nok naiꞌ Yohanis in aꞌmaetn ii antuuꞌ ma nheuꞌ on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Neot es, Naiꞌ Yesus In atoup noinꞌ ein reꞌ In nreek haefan sin neon goes ii, sin nfain neman ma nabuan nok Ne. Sin natoon areꞌ kanan rasi reꞌ sin nmoꞌe nrair sin, nok areꞌ saaꞌ reꞌ sin nanoniꞌ nrair sin neu too mfaun ein. ");
INSERT INTO aaz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Oras naan, too mfaun ein annao naꞌonin neu-mneman he naim Naiꞌ Yesus. Tar antea In nok In atoup noinꞌ ein ka napenin fa mainuan he nbukaen. Naiꞌ Yesus naꞌuab nok In atoup noinꞌ ein am nak, “Iim he tnao taim baer maꞌkoroꞌ, he tapein mainuan he tasnaas akreꞌo.” ");
INSERT INTO aaz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Onaim sin arsin nsaen anbin kofaꞌ, ma sin nnao namin baer maꞌkoroꞌ, naꞌroo naꞌko kuan. ");
INSERT INTO aaz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mes too mfaun ein niit kofaꞌ naan nnao nabnoon anpeoꞌ nefo naan in ninin. Rarit sin natuin ein anpeꞌon raan metoꞌ, ma sin ntean nahunun Naiꞌ Yesus nok atoup noinꞌ ein. ");
INSERT INTO aaz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oras Naiꞌ Yesus ansaun naꞌko kofaꞌ naan, In niit too mfaun ein anpao nain Je. Rarit In nkasian sin, natuin sin ka nahinin fa he nmoꞌen saaꞌ, nahuum on reꞌ aꞌbib-kasen reꞌ ka nmuꞌin fa atukus. Rarit In nanoniꞌ sin Uisneno In romin ");
INSERT INTO aaz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","naꞌko oras maans ii naꞌpuup tar antea maans ii nmaeb. Onaim In atoup noinꞌ ein naꞌuab neu Ne mnak, “Aam! Reko nneis Ho mreun too mfaun ein ok-okeꞌ, he nnao nsosan mnahat anbi areꞌ kua paumakaꞌ nbi ia. Fin maans ii he noi nmouf goen, ma ka tiit fa mnahat et bare ia.” ");
INSERT INTO aaz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mes Naiꞌ Yesus nataah sin am nak, “Anbain! Ro hi es reꞌ he mfeen sin he nbukaen.” Mes sin nataan Ee mnak, “Airoo! Karu hit ttuthae too mfaun ein ia, hit ro he tapoinaꞌ roit ii koꞌu! Namnees nok ameupt es in kai nbi toon es! Hit he tapein roit amfaun naan taꞌko mee?” ");
INSERT INTO aaz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mes Naiꞌ Yesus nataah sin am nak, “Hi mnao maim miit feꞌ, sekau es amneik betiꞌ.” Rarit sin nnao natanan ma nfain neem natonan am nak, “Anmuiꞌ utunuꞌ fuaꞌ niim, nok ikaꞌ fuaꞌ nua goah.” ");
INSERT INTO aaz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Rarit Naiꞌ Yesus anreun too mfaun ein naan he ntokon pukan-pukan anbin huun. ");
INSERT INTO aaz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Onaim sin ntokon puukn ok. Pukan bian nabuan nat-natun, ma pukan bian anteniꞌ boꞌ nim-niim. ");
INSERT INTO aaz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rarit Naiꞌ Yesus nait naan utunuꞌ fuaꞌ niim ma ikaꞌ fuaꞌ nua. Onaim In nbaiseun neu neon goe tunan ma ntoit makasi neu Uisneno. Rarit In nteib utunuꞌ naan pisaꞌ-pisaꞌ, ma anfee sin neu In atoup noinꞌ ein, he nnao nbatin too mfaun ein naan ok-okeꞌ. Ikaꞌ fuaꞌ nuaꞌ ein naan amsaꞌ, In nbait sin neu sin arsin. ");
INSERT INTO aaz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Onaim sin arsin anbukaen tar antea namsenan. ");
INSERT INTO aaz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Oras sin anbukae nrarin on naan ate, atoup noinꞌ ein nabuab nafaniꞌ mnaah nesif naan, naheun aꞌkoraꞌ boꞌes am nua. ");
INSERT INTO aaz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sin arsin of oniꞌ too nifun niim. Naan sin nsoiꞌ naan ahaa atoin ein. Bifee ma riꞌanaꞌ ka masoꞌik fa. ");
INSERT INTO aaz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Rarit Naiꞌ Yesus anreun In atoup noinꞌ ein he nnao nsaen kofaꞌ he nnao nahunun neun kuan Betsaida et neof goe panin. Mes In namaikaꞌ nbi nana feꞌ, he nreun too mfaun ein he nnao nfanin. ");
INSERT INTO aaz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Oras sin arsin nfanin ate, In nsae neu ꞌtoeꞌf es ma nꞌonen. ");
INSERT INTO aaz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Oras maans ii nmabe nrari te, Naiꞌ Yesus ansanu nfain. In niit atoup noinꞌ ein sin koofꞌ ee ntea nrair neof goe tnanan. Mes sin anseopn ok maꞌtaniꞌ, natuin kofaꞌ naan annao nraban nok ain koꞌu. Oras neis noi nmeu te, Naiꞌ Yesus annao natuin sin. Mes In nnao npeꞌo haa oe je fafon. Oras In he nnao nahunun kofaꞌ naan ate, sin nkius niit Ee. Sin namtaun nmaten. Onaim sin maktaan ein es nok es am nak, “Hoe! Saaꞌ na es reꞌ nee? Niut goa oo?” Mes Naiꞌ Yesus naꞌuab am nak, “Hoe! Hi kaisaꞌ mimtau! Au es reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oras Naiꞌ Yesus antaam neu kofaꞌ naan, anin naan nasnaas nain. In atoup noinꞌ ein ansanmakan batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sin feꞌ niit Naiꞌ Yesus In npaek kuasat ma ntuthae too nifu niim anneis, mes sin ka nahiin namneo fa feꞌ In kuasat naan, natuin sin neek manun. ");
INSERT INTO aaz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Oras sin antean nefo naan in panin, sin nsanun anbi kota Genesaret in ninin. ");
INSERT INTO aaz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Oras sin nsanun naꞌkon kofaꞌ naan, too mfaun ein niit sin. Ma sin anmakoaꞌ ein am nak, “Hoe! Naiꞌ Yesus neem een, oo!” ");
INSERT INTO aaz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Sin arsin naenan ma nmaktoon ein nfuun am nateef, tar antea sin nroi neik areꞌ kanan ameent ein. Teik uab paraꞌ, asar sin nnenan nak Naiꞌ Yesus et bare mee, sin arsin nroi neik areꞌ kanan ameent ein, ma natupaꞌ sin anbi mneraꞌ huu sonaꞌ. Sin nateenb ein am nak, “Asar ameent ein anreoꞌ naan Naiꞌ Yesus In baru mnaun ee in tuukn ee te, sin of narekon.” Sin nmoꞌen on naan ate, sin nareok nanin. ");
INSERT INTO aaz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Anmuiꞌ naan atoin Farisis puukn es ma tunggur agama Yahudi fauk reꞌ neman naꞌkon Yerusalem he natefan nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Atoin Farisis sin annaaꞌ naher-heran sin harat atoin Yahudis. Tait iꞌtopeꞌ on reꞌ: karu atoniꞌ he nbukae, ro he nafaun in aꞌniman natuin haart ii in romin. On naan amsaꞌ, karu nfain neem naꞌko ꞌmasaꞌ, sin ro he naniun feꞌ. Tar antea sin bareꞌ umi ꞌhaan ee msaꞌ, on reꞌ ꞌpikaꞌ, kraas, pois oe, ro he nsaef sin natuin haart ii in romin, henaꞌ bisa npaek sin he nbukaen. Karu anmuiꞌ atoin Yahudis bian reꞌ ka natuin fa haart ein naan, atoin Farisis sin natoꞌon. Es naan ate, sin natoꞌon oras sin niit Naiꞌ Yesus In atoup noinꞌ ein nbukaen, mes ka nafaun fa sin aꞌniimk ein natuin haart ii in romin. Rarit sin neman ma nasaan Naiꞌ Yesus am nak, “Nansaaꞌ am es ho atoup noinꞌ ein nbukaen mes sin ka nafaun fa sin aꞌniimk ein? Naan, sin nraban hit atoran harat naꞌko atoni mnais uun ein!” ");
INSERT INTO aaz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Mes Naiꞌ Yesus nataah sin im nak, “Hi reꞌ ia on reꞌ atoniꞌ reꞌ naꞌuab ate, aꞌtetaꞌ, mes hi mmoꞌe te, aꞌtetaꞌ! Nahunu te, kaꞌo Yesaya antui nain Uisneno In kabin am nak, ‘Sin npures ma nboꞌis Kau, npaekn ahaa sin ruruk koitk ein, mes ka npoin fa naꞌkon sin neek ein. Sin aꞌmoeꞌk ein on reꞌ naan ruum am parsuum aah. Sin ka nfairoir fa Au romik, mes sin natuin ahaa mansian ii in romin.’ Hi humaꞌ meseꞌ on reꞌ sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Hi misaitan amrair Uisneno In aprenat ma mituin ahaa mansian ii in harat. Hi mahinim ma manoem ein maꞌtain reꞌuf! ");
INSERT INTO aaz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nahunu te, kaꞌo Musa natoon anrair Uisneno In aprenat am nak, ‘Amhormaat hi mahoint ein.’ Antuut antein am nak, ‘Karu tuaf es nasekuꞌ in ainaf aiꞌ in amaf, ro he thukun tiis ne.’ ");
INSERT INTO aaz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Uisneno nanoniꞌ ki on naan, mes hi minoniꞌ ꞌtetaꞌ naꞌko naan. Hi mak, ‘Karu tuaf es anbaꞌan anrair he nfee saaꞌ es neu Uisneno, maski in ainaf-amaf ansuus anmaten, mes bareꞌ naan ka bisa npaek je fa he nturun sin, natuin anbaꞌan anrair he nfee je neu Uisneno.’ ");
INSERT INTO aaz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Es naan ate, feꞌe na Au ꞌak ki mꞌak, hi mporin main Uisneno In romin, ma hi mseek ee meik atoran mansian. Anmuiꞌ atoran amfaun reꞌ hi mseek ee nahuum on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Rarit Naiꞌ Yesus noꞌen tuaf bian anbin naan, ma naꞌuab am nak, “Amneen mirek-rekoꞌ, he hi mihiin. ");
INSERT INTO aaz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Areꞌ saaꞌ reꞌ antaman neu atoniꞌ in tain ka nhaiꞌniis fa in tuan. Mes saaꞌ reꞌ anpoi nfain, es reꞌ neik haiꞌnisit neu in tuan. ");
INSERT INTO aaz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sekau he mneen ate, amneen he muhiin!” ");
INSERT INTO aaz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein annaon nasaitan too mfaun ein naan, ma antaman neun uim jes. In atoup noinꞌ ein nataan retaꞌ naan in aꞌmoufun. ");
INSERT INTO aaz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Naiꞌ Yesus nataah sin am nak, “Hi ka mihiin fa msaꞌ, aa oo? In aꞌmoufn ii on nai: saaꞌ reꞌ atoniꞌ nbukae je, naan in reko kuun. Mes saaꞌ reꞌ anpoi nfain naan, in es ka reko fa. Saaꞌ reꞌ hit tbukae je, antaam neu hit taik, rarit anpoi nfain. (Usif Yesus In sairt ii nak, atoniꞌ bole nbukae saaꞌ-saaꞌ aah. Ka taras fa.) ");
INSERT INTO aaz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mes saaꞌ reꞌ anpoi naꞌko atoniꞌ in nekan, naan es reꞌ neik haiꞌnisit, tar antea Uisneno nmaiꞌniisn ee, ma ka nroim fa he nabua nok ne. ");
INSERT INTO aaz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rais reꞌuf namfau anpoi naꞌko atoniꞌ in nekan, on reꞌ: tenab amreꞌut, rais makonit, rais bakan, rais marorot, ");
INSERT INTO aaz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rais paruꞌ, rais makaket, moeꞌ reꞌuf, puta-kriut humaꞌ-humaꞌ, sinmakat, mantinus, naꞌuab naꞌreꞌuf es, nabeoꞌ, ka nahiin fa atoran, ma naꞌnaak-faut. ");
INSERT INTO aaz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Areꞌ ꞌmoeꞌ reuꞌf ein on reꞌ naan anpoin naꞌkon atoniꞌ in nekan. Naan es reꞌ nareuꞌ nafaniꞌ in tuan. Ma Uisneno nmaiꞌniisn ee msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Rarit Naiꞌ Yesus sin nasaitan bare naan, ma nnaon neun kota es, kaan ee Tirus. Antean bare naan, sin ntaman anbin uim jes, natuin Naiꞌ Yesus In ka nroim fa he biak ein nahinin nak In et reꞌ naan. Mes In ka bisa naꞌkoroꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Anbi naan, anmuiꞌ naan bifee mnais es, reꞌ ka atoin Yahudis fa, reꞌ nahoins ee nbi pah Fenesia et propinsi Siria. Oras in nneen nak Naiꞌ Yesus neem ate, in nnao ma ntoit Je he nriuꞌ napoitan niut reꞌuf naꞌko in aan feto. ");
INSERT INTO aaz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Naiꞌ Yesus naꞌuab manporin am nak, “Riꞌaan ein sin ro he nbukaen nahunun, rarit naꞌ anꞌokar amnaah neisf ein neun asun.” Nok sarit maꞌnifaꞌ nak, Naiꞌ Yesus ro he nturun In atoin Yahudis sin feꞌ, naꞌ anturun atoin sonaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mes bifee naan nataah am nak, “Namneo, tua! Mes asun naan sin etan mei je nupun. Onaim sin nahan amnaah amouft ein naꞌko riꞌaan ein sin aꞌpiik ein.” Nok sarit nak, oras riꞌaan ein anbukaen, asun naan napenin amnahat amsaꞌ. Maski Naiꞌ Yesus anturun Iin na kuun, In ro he nkius atoin sonaꞌ amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Anneen on naan ate, Naiꞌ Yesus naꞌuab am nak, “Wee, bifee ia feꞌ! Ho uabam naan ro namneo! Es naan ate ho mfain nai, natuin niut reuꞌf ee anpoi nrair naꞌko ho anah.” ");
INSERT INTO aaz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Rarit bifee naan antebi nfain. Antea in umi te, in anah naan antuup anfiin. Niut reꞌuf naan anpoi nrair. ");
INSERT INTO aaz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Rarit Naiꞌ Yesus sin nasaitan kota Tirus, ma nnaon nabnonon npeꞌon ranan reꞌ et tais je ninin, nkoon kota Sidon. Naꞌko naan, sin nnaon nkonon tar antean nefo Galilea. Rarit sin nnaon neu pah es nok kota boꞌes, reꞌ sin nteek nain je mnak, ‘Dekapolis’. ");
INSERT INTO aaz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Anbi bare naan, anmuiꞌ atoin amuut es, reꞌ ankoos nok. In aok-bian sin neik je nnao neu Naiꞌ Yesus. Sin ntotin he Naiꞌ Yesus antao In aꞌniman neu amenat naan, he nareokꞌ ee. ");
INSERT INTO aaz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Onaim Naiꞌ Yesus nasaitan too mfaun ein, ma nnao nmees nok atoniꞌ naan. Naiꞌ Yesus nataam In akrurun neu atoniꞌ naan in ruikn ein nua sin. Rarit In ntao hape nbi In akrurun naan ma anreoꞌ atoniꞌ naan in maan. ");
INSERT INTO aaz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naiꞌ Yesus anbaiseun neu neon goe ma nheer In asnasan, rarit naprenat anpaek sin uab am nak, “Efata!” (In aꞌmoufn ii nak, “Mutfeꞌi nai!”) ");
INSERT INTO aaz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","In naꞌuab on ahaa reꞌ naan, mes amenat naan in ruik ein anneen nain oras naan. Ma in maan reꞌ ka naꞌuab nahiin fa naan, anmaꞌnuur nain amsaꞌ, onaim in nmurai naꞌuab nok reko. ");
INSERT INTO aaz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Rarit sin nua sin annao nfanin neun too mfaun. Naiꞌ Yesus antaar sin am nak, “Amneen, oo! Kaisaꞌ mitoon meu sekau-sekau mak, Au urekoꞌ urair atoniꞌ reꞌ ia.” Maski Naiꞌ Yesus antaar sin nok maꞌtaniꞌ amsaꞌ, mes sin naꞌuab ein piut anbin bare-bare. ");
INSERT INTO aaz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Too mfaun ein reꞌ anneen uab mantonas naan, ansanmakan. Sin naꞌuab ein am nak, “Maꞌtain reꞌuf! Atoniꞌ reꞌ ia anmoeꞌ areꞌ saaꞌ ii ro reko okeꞌ. Akoost ate, anneen. Amuut ate, naꞌuab.” ");
INSERT INTO aaz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Ka ꞌroo fa on naan ate, anmuiꞌ too mfaun neem nabuan he nneen Naiꞌ Yesus In uaban. Sin natuin Ee tar antea neno teun goen. Onaim sin nararin betiꞌ. Rarit Naiꞌ Yesus noꞌen In atoup noinꞌ ein am nak, “Au ꞌkasian too mfaun ein ia. Bian neman naꞌko bare ꞌroo, ma nabuan nok kit neno teun goen, tar antea sin nararin betiꞌ. Reko nneis sin kais annaon nfanin nok tai ruman. Kais-kaisaꞌ sin ntuamafun anbin raan atnanaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naiꞌ Yesus In atoup noinꞌ ein nataahn am nak, “Aam! Bare ia naꞌroo naꞌko kuan. Onaim hit ka neu fa he ntuthae taan too mfaun ein reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naiꞌ Yesus nataan sin am nak, “Hi mmuiꞌ utunuꞌ fuaꞌ fauk?” Sin natahan am nak, “Hai mmuꞌi haa utunuꞌ fuaꞌ hiut, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Rarit Naiꞌ Yesus anreun too mfaun ein naan he ntokon anbin afu. Rarit In nait utunuꞌ fuaꞌ hiut ein reꞌ naan, ma ntoit makasi neu Uisneno. Rarit In anteib sin pisaꞌ-pisaꞌ, ma nfee sin neu In atoup noinꞌ ein. Sin nnaon ma nbatin neun too mfaun ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma sin napenin ikaꞌ fak-fauk amsaꞌ. Rarit Naiꞌ Yesus antoit makasi nteniꞌ neu Uisneno anmatoom nok iikꞌ ein naan. Rarit In nreun In atoup noinꞌ ein, he nnaon nbatin nteniꞌ neu too mfaun ein. ");
INSERT INTO aaz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Sin arsin ok-okeꞌ of oniꞌ atoniꞌ nifun haa. Sin nbukaen tar namsenan. Nbukaen nrarin on naan ate, atoup noinꞌ ein nabuab amnaah neisf ein naheun ꞌponi hiut. Rarit Naiꞌ Yesus anreek sin he nfanin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma oras sin nnaon nfanin on naan ate, Naiꞌ Yesus nok In atoup noinꞌ ein ansaen neu kofaꞌ, ma nnaon nabnonon npeꞌon nefo naan in ninin, neun baer jes, kaan ee Dalmanuta. ");
INSERT INTO aaz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Oras Naiꞌ Yesus sin antean Dalmanuta, anmuiꞌ tuaf naꞌko partei pirsait Farisi neman he natefan nok Ne. Sin nataan naꞌkeeꞌt Ee, ma sin ntoit Je mnak, “Aam! Mukriraꞌ rais sanmakat he anjari ꞌtopeꞌ reꞌ mamnitaꞌ nak, Ho mupein Ho maꞌtanim muꞌko Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Naiꞌ Yesus anheer In asnasan, onaim In nak, “Karu Au ꞌneen hi uab ein naan, Au ꞌmeiꞌ jok! Nansaaꞌ am es hi mtoit rais sanmakat? Kais on naan! Rais sanmakat ro nmuꞌi msaꞌ, mes Au ka ꞌmoꞌe ꞌfee ki fa.” ");
INSERT INTO aaz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Rarit Naiꞌ Yesus annao nasaitan sin, ma ansae nfanin nbi kofaꞌ nabua nok In atoup noinꞌ ein. Ma sin nrakan neun nefo naan in panin. ");
INSERT INTO aaz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Oras Naiꞌ Yesus sin antean nefo naan in atnanan, naꞌ atoup noinꞌ ein namnaun nak, sin nnikan nanin nak, sin ka neik ein fa betiꞌ. Suma sin neik utunuꞌ fuaꞌ meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Anneen sin naꞌuab ein anteek utunuꞌ on naan ate, Naiꞌ Yesus nak sin am nak, “Hi ro he mpanat mirek-rekoꞌ! Kais hi mtoe mituin usif Herodes ma atoin Farisis sin rais makopoꞌ amreꞌut. Sin rais kopoꞌ naan, nahuum on reꞌ muur ii ankumu nseor goe nok uut, he uut naan nasraat ansae.” ");
INSERT INTO aaz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anneen In naꞌuab on naan ate, In atoup noinꞌ ein antakaꞌnaan ein. Ma sin naꞌuab ein nak, “Aꞌnaef ee naꞌuab rais saaꞌ? Of oniꞌ In naꞌuab on naan, natuin hit ka teik fa utunuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mes Naiꞌ Yesus nahiin sin neek tenab. Es naan ate, In naꞌuab am nak, “Nansaaꞌ am es hi miꞌuab ahaa utunuꞌ? Hi ka mheek maan fa Au sairt ii, oo? Hi roenm ein ro nbufun nmaten! ");
INSERT INTO aaz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hi miit amrair meik hi maatm ein, mes hi ka mihiin fa in aꞌmoufun! On reꞌ hi ka miit miit fa feꞌ! Hi mneen meik hi ruikm ein, mes hi ka mihiin fa saaꞌ-saaꞌ. On reꞌ hi ka mneen miit fa msaꞌ! Hi mnikan main ");
INSERT INTO aaz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","utunuꞌ fuaꞌ niim reꞌ Au ꞌteib sin pisaꞌ-pisaꞌ ma ꞌtuthae too nifun niim, aiꞌ? Neno naan hi mibuab maan utuun anesit ꞌkoraꞌ fauk?” Sin natahan am nak, “ꞌKoraꞌ boꞌes am nua, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Naiꞌ Yesus nataan anteniꞌ sin am nak, “Hi mimnau, aiꞌ kaah, neon goes ii, oras Au ꞌtebi ꞌbait utunuꞌ ma ꞌtuthae too nifun haa? Hi mibuab maan utuun neisf ein naan ꞌponi fauk?” Sin natahan am nak, “ꞌPoni hiut, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Onaim Naiꞌ Yesus nak, “Namneo! Hi miit nok hi matam. Mes nansaaꞌ am es hi ka mihiin fa, Au maꞌtaink ii in amneemn ii naꞌko mee?” ");
INSERT INTO aaz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rarit Naiꞌ Yesus sin antean kuan Betsaida. Anbi naan, anmuiꞌ tuaf neik atoin aforot es neu Naiꞌ Yesus. Sin ntoit Je he nreoꞌ narekoꞌ atoin aforot naan. ");
INSERT INTO aaz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Onaim Naiꞌ Yesus annaaꞌ atoniꞌ naan in aꞌniman ma neik je npoi neu kuan ee in kotin. Rarit In npuran hape neu atoniꞌ naan in matan, ma In nreoꞌ goe. In nataan am nak, “On mee? Ho bisa miit, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atoniꞌ naan naꞌaiti in matan, ma nkius aꞌrii-ꞌneꞌu, ma in nataah am nak, “Tua! Au ꞌiit mansian ein anbaknaon ein. Mes huumn ee on reꞌ au ꞌiit hau ngguin esan reꞌ anaot ein!” ");
INSERT INTO aaz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma Naiꞌ Yesus antao nteniꞌ In aꞌniman neu atoniꞌ naan in matan. Ma atoniꞌ naan ankius naher-heer anteniꞌ, ma in nahiin nak in niit reok goen. Oras ia in bisa niit nok akninuꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Rarit Naiꞌ Yesus anreun atoniꞌ naan he nnao nfain, ma namnaub ee mnak, “Ho mfain nai, mes amnao mutuin raan ꞌtetaꞌ! Kaisaꞌ amnao mfain meu Betsaida.” ");
INSERT INTO aaz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Rarit Naiꞌ Yesus sin annaon nfuun am natefan kuan-kuan anbin Kaisarea Filipi. Anbin raan atnanaꞌ te, Naiꞌ Yesus nataan sin am nak, “Karu tatuin too mfaun ein sin uabk ein, sin nak Au reꞌ ia, sekau?” ");
INSERT INTO aaz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sin natahan am nak, “Bian sin nak ‘naiꞌ Yohanis Asranit’. Bian sin nak, ‘kaꞌo Elia, mafefa kninuꞌ Uisneno unuꞌ naan’. Ma bian antein nak, Ho reꞌ ia tuaf es naꞌko Uisneno In mafefa kniun ahuunt ein.” ");
INSERT INTO aaz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Naiꞌ Yesus nataan anteniꞌ neu sin nak, “Mes natuin hi mahiinm ein ite, Au reꞌ ia, sekau?” Naiꞌ Petrus nataah am nak, “Ho reꞌ ia Kristus, reꞌ Uisneno anruur nain Je naꞌko unuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mes Naiꞌ Yesus antaar sin mates nak, “Ka nabeiꞌ fa he hi mitonan sekau-sekau saaꞌ reꞌ naiꞌ Petrus naꞌuab ee reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Rarit Naiꞌ Yesus anmurai naꞌuab neu In atoup noinꞌ ein am nak, “Au reꞌ ia, Mansian Batuur-Batuur Kau. Au of upein rais haꞌmuꞌit amfaun, natuin aꞌnaak haart ein, aꞌnaak rais pirsait Yahudis sin aꞌnaakt ein, ma tunggur agaam ein ok-okeꞌ of antorak Kau. Sin of anroor niis Kau, mes nmeu te, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Naiꞌ Yesus natoon maat-maat on naan, onaim naiꞌ Petrus anheer napaisb Ee, ma nakain Ee mnak, “Aam! Kaisaꞌ muꞌuab on naan! Au ka neu he ꞌkonan sin fa, he nniman Ko.” ");
INSERT INTO aaz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mes naiꞌ Petrus in uaban naan ka natuin fa Uisneno In romin. Es naan ate, Naiꞌ Yesus nabaniꞌ ma nkius In atoup noniꞌ bian ein. Rarit In nakainaꞌ naiꞌ Petrus nok haan maꞌtaniꞌ mnak, “Hoe! Naan niut reuꞌf ein sin aꞌnaak kouꞌ goe in uaban! Muꞌroo muꞌko ia! Ho suma mutenab meik tenab mansian, mes tenab naan ka natuin fa Uisneno In romin!” ");
INSERT INTO aaz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Rarit Naiꞌ Yesus noꞌen too mfaun he neem nabuan nok In atoup noinꞌ ein. Ma In nanoniꞌ sin am nak, “Atoniꞌ reꞌ anroim he natuin Kau, ro in he naran ma natuin Kau neno-neno! In ro he nnikan nain in roimn ein kuun, ma natuin ahaa neu Uisneno In romin. Maski atoniꞌ he nroor goe msaꞌ, mes in natuin piut, on reꞌ atoniꞌ nasaah in hau nehe he nnao neu in bare ꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Fin atoniꞌ reꞌ anmoin arahaa neu in tuan, of in aꞌmoin ii namneuk on ahaa reꞌ naan! Mes atoniꞌ reꞌ nabarab in tuan he nmaet natuin in njair Au ngguin ma natoon Uisneno In raan aꞌhonis, in of anmoin nabar-baar nok Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amneen, oo! Karu ho mpaar pah-pinan ia in aafn ii okeꞌ, mes Uisneno antorak ko, ho mupein saaꞌ? ");
INSERT INTO aaz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maski nak ho mroi meik pah-pinan in aafn ii okeꞌ msaꞌ, muꞌif naan ka neu he ntuik naan fa ho smaanm aan! ");
INSERT INTO aaz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mimnau! Mansian batan muniꞌ ia, anmoꞌen reꞌuf humaꞌ-humaꞌ. Sin ka nfairoir fa he natuinaꞌ Uisneno. Es naan ate, sekau reꞌ namaeb on he natuin Kau, aiꞌ namaeb on he natuin Au noinꞌ ein, Au of umaeb ok amsaꞌ he ꞌmanakuꞌ in tuan aꞌbi Uisneno In human ma In matan. Fin Au, Mansian Batuur-Batuur reꞌ ia, of Au ꞌfain ꞌuum uꞌko neno tunan. Ma Uisneno In ameupt ein naꞌkon neno tunan of naub naan Kau. Oras hai msaun iim miꞌko sonaf neno tunan meik Amaꞌ In pinan ma krahan, of mansian ii naꞌ nahinin nak, amneon ii Au reꞌ ia sekau. ");
INSERT INTO aaz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hi kaisaꞌ mnikan Au uabk ein reꞌ ia. Naꞌko hi arki ok-okeꞌ reꞌ ia, of anmuiꞌ tuaf reꞌ anmonin feꞌ, tar sin niit Uisneno ntook ma naprenat neik kuasat maꞌtaniꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Neno nee nkono te, Naiꞌ Yesus antoit naiꞌ Petrus, naiꞌ Yakobus, ma naiꞌ Yohanis, he nnaon nsaen buꞌ-buaꞌ on ꞌtoꞌe mnanuꞌ es, reꞌ ka nmuiꞌ fa tuaf. Oras sin antean in tunan, sin nkius niit Naiꞌ Yesus naꞌbaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma In tai-pake naan anjair mutiꞌ ma nariim. Ka nmuiꞌ fa bareꞌ anbi pah-pinan reꞌ ia, muitn ii namnees nok In tai-pake naan. ");
INSERT INTO aaz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nok askeken, sin niit Naiꞌ Yesus naꞌuab nok kaꞌo Elia ma kaꞌo Musa. ");
INSERT INTO aaz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Sin teun sin namtaun nmaten. Naiꞌ Petrus antakaꞌnanaꞌ, tar in naꞌuab tafiꞌ-tafiꞌ. Rarit in naꞌuab neu Naiꞌ Yesus am nak, “Aam! Hit tbi ia te, naꞌ reko nneis. Reko te, hit tmoeꞌ ropo teun. Es neu Ko, tua. Es neu kaꞌo Musa, ma es atfee je neu kaꞌo Elia.” ");
INSERT INTO aaz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Rarit anmuiꞌ nope reꞌ ansaun neem ma nꞌaum naan sin. Onaim sin anneen hanaf es anpoi neem naꞌko nope naan am nak, “Amneen nai, joo! Naiꞌ Yesus reꞌ ia, Au Aan nekaꞌ. Hi mneen ma mituin Ee rek-reko!” ");
INSERT INTO aaz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Oras naiꞌ Petrus sin nneen niit hanaf naan, sin ankisun nfuun am nateef, mes nok askeken sin ka niit anteniꞌ fa tua nuaꞌ ein naan. Suma Naiꞌ Yesus anmees. ");
INSERT INTO aaz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein ansanun nfanin naꞌkon ꞌtoꞌef naan. Ma Naiꞌ Yesus antaar sin am nak, “Saaꞌ reꞌ hi miit amrair je feꞌe na, hi kaisaꞌ mitoon meu sekau-sekau. Au reꞌ ia, Mansian Batuur-Batuur, Au ro he ꞌmaet feꞌ. Karu Au ꞌmoni ꞌfain, naꞌ hi mitoon rasi naan meu too mfaun ein.” ");
INSERT INTO aaz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sin nnaaꞌ naheran Naiꞌ Yesus In rais manbaꞌan naan, ma sin ka natoon ee fa neu tuaf es amsaꞌ. Mes sin teun sin anmaktaan ein es nok es am nak, “In sairt ii, on mee, es naꞌ In nak, In he nmoni nfain naꞌko In aꞌmaten reꞌ naan? On mee?” ");
INSERT INTO aaz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma sin nataan Ee mnak, “Tunggur agaam ein nak, kaꞌo Elia ro he neem nahuun feꞌ, rarit naꞌ Kristus neem. Mes anbi Ho teenb ii te, on mee?” ");
INSERT INTO aaz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naiꞌ Yesus nataah am nak, “Namneo on naan. Kaꞌo Elia ro he neem nahuun feꞌ, he nfei ranan neu Kristus, Tuaf reꞌ Uisneno anruur nain Je naꞌko un-unuꞌ. Mes on mee? Hi ka mihiin fa saaꞌ reꞌ sin ntui nain je et Uisneno In Suur Akninuꞌ anmatoom nok Mansian Batuur-Batuur? Fin sin ntui nrair Je mnak, karu In neem antea te, atoniꞌ of anhaꞌmuiꞌ Je ma sin of anroor niis Ne. ");
INSERT INTO aaz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma hi ro he mtakan hi ruikm ein rek-reko, joo! Kaꞌo Elia neem anrair jen. Ma atoniꞌ nhaꞌmuiꞌ je, natuin sin roimk ein. Rasi naan namnees nok saaꞌ reꞌ unuꞌ te, sin naꞌi antui nain je.” ");
INSERT INTO aaz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oras Naiꞌ Yesus nok In atoup noniꞌ tua teun ein natefan nfanin nok atoup noniꞌ bian, sin niit too mfaun ein nabuan. Too mfaun ein naan neman he niit atoup noniꞌ bian sin anmatoen nok tunggur agaam ein. ");
INSERT INTO aaz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oras too mfaun ein niit Naiꞌ Yesus on nai te, sin naskeken, fin sin teenb ein nak of oniꞌ In nabaar feꞌ et aꞌtoeꞌf ee in tunan. Ma sin naen anseun Goe. ");
INSERT INTO aaz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rarit Naiꞌ Yesus nataan sin am nak, “Hi mmatoen rais saaꞌ mok sin?” ");
INSERT INTO aaz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Anmuiꞌ atoin es neem naꞌuab am nak, “Aam, karu reko te, amneen maan kau, tua! Au ꞌeik au aan mone he Ho murekoꞌ maan ee. In nmuu ma ka bisa naꞌuabaꞌ fa, fin niut reuꞌf es ansaen ee. ");
INSERT INTO aaz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Karu niut reꞌuf naan ansaen ee, in nbeosn ee neu afu. Rarit riꞌanaꞌ naan in haepn ee naꞌfuriꞌ, ma in neuk in niisn ein. Rarit in aon aan anruur goah on reꞌ hau noon es. Au ꞌtoit ꞌiit Ho atoup noinꞌ ein, he sin nriuꞌ niut reꞌuf naan. Mes sin ka nabeiꞌ je fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Anneen on naan ate, Naiꞌ Yesus naskaraꞌ sin am nak, “Hoe! Ro hi bainesiꞌ ki! Au unoniꞌ ki fani-fani, mes hi ka mheek-heek maan fa. Ma hi ka mpirsai Kau fa batuur-batuur! Au he ꞌsabaar ꞌeu ki ꞌtea rekaꞌ! Meik Kau riꞌanaꞌ naan neem neu ia!” ");
INSERT INTO aaz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Rarit sin natnaat neik riꞌanaꞌ naan neem neu Naiꞌ Yesus. Oras niut reꞌuf naan nkius niit Naiꞌ Yesus on naan ate, in nbonan riꞌanaꞌ naan ma nriut ee nbi afu, ma in haep bua-neorn ee nsae. ");
INSERT INTO aaz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Rarit Naiꞌ Yesus nataan riꞌanaꞌ naan in aamf ee mnak, “Ho aanh ii in meens ii naꞌko rek-reek ii?” In aamf ee nataah am nak, “Naꞌko in aanꞌ-anaꞌ feꞌ, tua. ");
INSERT INTO aaz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Niut reꞌuf naan he naꞌmaet au aanh ii ꞌroo-ꞌroo goen. In nbeson au aanh ii fani-fani nbi ai, ma nareem ee nbi oe. Onaim amturun maan kai, tua! Karu reko te, amneek kai, he murekoꞌ maan au anah reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naiꞌ Yesus nataah am nak, “Nansaaꞌ am es ho mak ‘karu reko te’? Namneo Au bisa ꞌmoeꞌ areꞌ saaꞌ-saaꞌ, asar atoniꞌ ro he npirsai feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rarit atoni mnasi naan nataah ma nkae nok am nak, “Aam! Namneo, au ꞌpirsai ꞌrair. Mes amturun kau he au ꞌneek aꞌtebes reꞌ ia, maꞌtaniꞌ ntein!” ");
INSERT INTO aaz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Oras naan, Naiꞌ Yesus nkius too mfaun ein nmurain neem nauban sin. Onaim In naprenat niut reꞌuf naan am nak, “Hoi! Niut aburarut! Ho mpoi nai muꞌko riꞌanaꞌ reꞌ ia, he in bisa nneen, ma in bisa naꞌuabaꞌ. Ho kais amtaam amfain uum!” ");
INSERT INTO aaz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Anneen Naiꞌ Yesus naꞌuab on naan ate, niut reꞌuf naan anhunun naher-heer. In nmoeꞌ riꞌanaꞌ naan antaikoib ma npaiteetk on, rarit naꞌ anpoi nasaitn ee. Ma riꞌanaꞌ naan antuamauf on reꞌ anmate nrair. Tar too mfaun ein reꞌ anbin naan naꞌuab ein am nak, “Ooo! In nmate nrair!” ");
INSERT INTO aaz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mes Naiꞌ Yesus annaaꞌ riꞌanaꞌ naan in aꞌniman, ma nfiit nafeen ee. Onaim riꞌanaꞌ naan anfeen nain oras naan. ");
INSERT INTO aaz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein nnao nasaitan bare naan, ma ntaman neun uim jes. Anbi naan sin nataan Naiꞌ Yesus am nak, “Aam! Nansaaꞌ am es feꞌe na hai ka bisa mriuꞌ maan fa niut reꞌuf naan?” ");
INSERT INTO aaz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma Naiꞌ Yesus naꞌuab neu sin am nak, “Amneen mirek-rekoꞌ! Niut reuꞌf ein ro amaufiunt ein. Es naan ate, karu hi ka mꞌonen he mtoit fa Uisneno, hi ka mibeiꞌ fa he mriuꞌ niut reꞌuf on reꞌ naan.” ");
INSERT INTO aaz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein nnaon nasaitan bare naan, ma antaman neu propinsi Galilea. Oras naan, Naiꞌ Yesus ka nroim fa he atoniꞌ nahiin nak In et bare naan. ");
INSERT INTO aaz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mes In arahaa he nanoniꞌ In atoup noinꞌ ein. In naꞌuab neu sin am nak, “Ka ꞌroo fa heen, sin of naꞌsosaꞌ Kau neu atoin sonaꞌ. Rarit sin nroor niis Kau, Mansian Batuur-Batuur reꞌ ia. Namneo Au ro he ꞌmaet, mes anbi nmeu te, Au ro ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naiꞌ Yesus naꞌuab on naan, ma In atoup noinꞌ ein naskeken ntakaꞌnaan ein aah. Sin ka nabranin fa he nataan anteniꞌ Naiꞌ Yesus In teenb ii on mee. ");
INSERT INTO aaz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rarit Naiꞌ Yesus sin annaon ntean Kapernaum. Oras sin antaman anbin umi, In nataan neu In atoup noinꞌ ein am nak, “Feꞌe na hi mmatoenaꞌ rais saaꞌ anbi ranan?” ");
INSERT INTO aaz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mes ka tiit fa tuaf es he nataah, fin anbi raan atnanaꞌ, sin nmatoen am nak, sekau es reꞌ koꞌu nneis naꞌko sin. ");
INSERT INTO aaz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Rarit Naiꞌ Yesus antook ma nanoniꞌ sin am nak, “Sekau es reꞌ anroim he njair atoin koꞌu, in aꞌmoin ee ro he batuur-batuur on reꞌ atoin neek aꞌbaut, he ntuthae areꞌ too mfaun ein.” ");
INSERT INTO aaz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Rarit Naiꞌ Yesus naskau naan riꞌaan es anbi naan, ma nfain neu sin atnaank ein. Onaim In naꞌuab am nak, ");
INSERT INTO aaz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sekau reꞌ natuinaꞌ Kau ma ntuthae tau aꞌbaut ein on reꞌ riꞌaan aꞌbaut reꞌ ia, tuaf reꞌ naan on reꞌ antuthae Kau msaꞌ. Ma in ntuthae Au Amaꞌ reꞌ anreek haefan Kau he ꞌtaam ꞌuum aꞌbi pah-pinan ia msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Rarit Naiꞌ Yesus In atoup noniꞌ naiꞌ Yohanis, natraak am nak, “Aam! Anbi oors es, hai miit atoin es anpaek Ho kanam ma nriuꞌ niut reuꞌf ein. Mes hai mtaar ee, natuin hit ka hit ja fa.” ");
INSERT INTO aaz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mes Naiꞌ Yesus nataah am nak, “Hoe! Hi kaisaꞌ mikain ee. Fin sekau es anpaek Au kanak he nmoeꞌ rais sanmakat, in of ka neu naꞌuab naꞌreꞌuf fa Au kanak. ");
INSERT INTO aaz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Karu in ka nraban kit fa, on naan ate in reꞌ naan hit ja amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Es naan ate, mimnau mirek-rekoꞌ! Karu anmuiꞌ tuaf reꞌ nahiin nak hi mituinaꞌ Kristus, rarit in nturun ki, Uisneno ka neu nnikan fa in haet naan. Maski in suma naꞌinuꞌ ki neik oe ruman kraas es amsaꞌ, Uisneno ka neu nniikn ee fa.” ");
INSERT INTO aaz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Rarit Naiꞌ Yesus naꞌuab nteniꞌ neu sin am nak, “Karu atoin es anmoꞌe nsaan neu riꞌaan es, tar in ka npirsai nteniꞌ Kau fa, ampaant om, oo! Reko nneis, nait faut kouꞌ goes, ma nfuut nakfiirt ee neu in neon, ma nporin nataam ee neu tais je tnanan. ");
INSERT INTO aaz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Karu ho musanab meik ho ꞌnimam, mketu mporin ho ꞌnimam naan! Fin reko neis ho mtaam meu sonaf neno tunan meik ho ꞌnimam meseꞌ, naꞌko sin anporin nataam ko neu ai maputuꞌ ma ai mararaꞌ abar-barat meik ho ꞌnimam nua. ");
INSERT INTO aaz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ai mararaꞌ naan, namneo-namneo baer nanaꞌrenat. In ai ji ka nmaet niit fa. Ma areꞌ kaunaꞌ soeꞌ ji nsoe nareuꞌ ka nasnaas fa. ");
INSERT INTO aaz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Karu ho musanab meik ho haem, mketu mporin ho haem aan. Fin reko neis ho mtaam meu sonaf neno tunan meik ho haem meseꞌ, naꞌko sin anporin nataam ko neu ai maputuꞌ ma ai mararaꞌ abar-barat meik ho haem nua. ");
INSERT INTO aaz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ai mararaꞌ naan, namneo-namneo baer nanaꞌrenat. In ai ji ka nmaet niit fa. Ma areꞌ kaunaꞌ soeꞌ ji nsoe nareuꞌ ka nasnaas fa. ");
INSERT INTO aaz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma karu ho musanab meik ho matam, mroꞌi mporin ho matam naan. Fin reko neis ho mtaam meu sonaf neno tunan meik ho matam fuaꞌ meseꞌ, naꞌko sin anporin nataam ko neu ai maputuꞌ ma ai mararaꞌ abar-barat meik ho matam fuaꞌ nua. ");
INSERT INTO aaz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ai mararaꞌ naan, namneo-namneo baer nanaꞌrenat. In ai ji ka nmaet niit fa. Ma areꞌ kaunaꞌ soeꞌ ji nsoe nareuꞌ ka nasnaas fa.’ ");
INSERT INTO aaz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Au ꞌfee noniꞌ reꞌ ia, ro maꞌfenaꞌ. Es naan ate, sekau es reꞌ he natuinaꞌ Kau te, ro in he ntahan he nok Kau piut, on reꞌ siis seꞌik ro he npaek masik, henaꞌ sisi naan antahan aꞌroo. ");
INSERT INTO aaz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masik naan, ro reko. Hit tpaek je he taminab amnahat. Mes karu masik naan ka miin masik fa heen ate, he tpaek je neu saaꞌ antein? Ro hit tait itpoirn aah ee. Hi ro he mjair on reꞌ masik amsaꞌ, he mmoni mbi manekat mok areꞌ too mfaun ein. Onaim hi kais ammatoe mtein nai, mak sekau es reꞌ kouꞌ gui, ma sekau es aan ii.” ");
INSERT INTO aaz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Rarit Naiꞌ Yesus sin nnaon nfuun am nateef anbin propinsi Yudea, ma nbin bare bian antein et noe Yarden in panin, pasaꞌ neon-saet. Anbi mee-mee, too mfaun ein neman ma naub naan Ee. Ma Naiꞌ Yesus nanoniꞌ sin on reꞌ biasa. ");
INSERT INTO aaz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Atoin Farisis tuaf fauk neman he namouf Goe. Sin natanan am nak, “Natuin hit atoran rais pirsait, atoin amatsaos es bisa nporin in fee, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mes Naiꞌ Yesus nataah sin am nak, “Mimnau miit feꞌ! Atoran anmatoom nok matsaos fee-mone reꞌ kaꞌo Musa nbaꞌan nain je neu ki naan, nak on mee?” ");
INSERT INTO aaz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sin natahan am nak, “Kaꞌo Musa in atoorn ii nak, atoniꞌ bisa nporin in fee, mes ro he ntui surat manporin nahuun ma nnonaꞌ surat naan neu in fee.” ");
INSERT INTO aaz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mes Naiꞌ Yesus nataah sin am nak, “Amneen Kau feꞌ! Kaꞌo Musa antui on naan, natuin hi miꞌnaak-faut bainesiꞌ! ");
INSERT INTO aaz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hi kaisaꞌ mnikan retaꞌ un-unuꞌ oras Uisneno anmoeꞌ neno tunan ma pah-pinan! Fin matuꞌi et Suur Akninuꞌ mnak, ‘Uisneno nmoeꞌ mansian ein, atoniꞌ ma bifee. ");
INSERT INTO aaz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Es naan ate, atoin es ro he nnao nasaitan in ainaf ma in amaf, he nmoin nabuan nekaf meseꞌ ma ansaof meseꞌ nok in fee, ");
INSERT INTO aaz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","henatiꞌ sin nua sin njarin meseꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Karu Uisneno neikn On naꞌmeseꞌ sin, ka bole fa he mansian ii nbatis sin!” ");
INSERT INTO aaz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein antaman nmesen nbin uim jes. Anbi naan, sin nataan Naiꞌ Yesus anmatoom nok In nonin reꞌ feꞌe na. ");
INSERT INTO aaz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naiꞌ Yesus nataah sin am nak, “Sekau reꞌ anporin in fee, ma nsao nteniꞌ bifee ꞌtetaꞌ, naan antaam rais makaket amsaꞌ! ");
INSERT INTO aaz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","On naan amsaꞌ bifee! Karu in nporin in mone, rarit in nsao nteniꞌ atoniꞌ tetaꞌ, naan antaam rais makaket amsaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anbi oors es, sin neik sin aanh ein neman neu Naiꞌ Yesus, ma ntotin he In naꞌuab anfeen sin tetus. Mes Naiꞌ Yesus In atoup noinꞌ ein nakainaꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Oras Naiꞌ Yesus niit rasi naan ate, In natoꞌon In atoup noinꞌ ein. In naꞌuab am nak, “Mifetin riꞌaanꞌ ein naan he neman ntean Kau! Kaisaꞌ mikainaꞌ sin! Natuin atoniꞌ reꞌ nahuumb on, on reꞌ sin reꞌ naan, es reꞌ anjarin Uisneno Iin na. ");
INSERT INTO aaz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mimnau mirek-rekoꞌ! Sekau reꞌ anroim he neem anhaumaak Uisneno, sin ro he namnau niis Ne, on reꞌ riꞌaan ein namnau sin ainaf-amaf. Karu ka on naan fa te, ka nabeiꞌ fa he tteek sin tak Uisneno Iin na.” ");
INSERT INTO aaz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Rarit Naiꞌ Yesus anhoo naan riꞌaan ein naan, ma ntao In aꞌniman neu sin meseꞌ-meseꞌ he naꞌuab anfeen sin tetus. ");
INSERT INTO aaz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Oras Naiꞌ Yesus sin he nnaon nkonon, anmuiꞌ atoin amuiꞌt es naen neem he nateef nok Ne. In naꞌruriꞌ anbi Naiꞌ Yesus In matan, ma nataan Ee mnak, “Aam tungguru reꞌ au ꞌhormaat ꞌain je! Au he utaan akreꞌo. On nai, Aam. Of au he ꞌmoeꞌ on mee, henatiꞌ au bisa ꞌtaam ꞌeu sonaf neno tunan, he ꞌmoin ubar-baar ꞌok Uisneno?” ");
INSERT INTO aaz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Naiꞌ Yesus nataah am nak, “Nansaaꞌ am es ho mteek Kau mmak, ‘reꞌ au ꞌhormaat ꞌain je’? Ka tiit fa es reꞌ he thormaat tain je, mes Uisneno nmees Kuun. ");
INSERT INTO aaz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ho muhiin murair prenat ahunut naꞌko Uisneno reꞌ nak, ‘Kais amroor atoniꞌ; kais ammakaek; kais mubaak; kais amsaksii mipoi; kais amputa-kriu atoniꞌ in bareꞌ; ma mhormaat meu ho ainaꞌ ma ho amaꞌ.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Atoniꞌ naan nataah am nak, “Namneo, Aam tungguru! Au unaobaꞌ areꞌ kanan atoorn ein naan ꞌmurai uꞌko oras au feꞌ munif kau, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naiꞌ Yesus naꞌuab rais manekat neu atoniꞌ naan am nak, “Namneo! Mes anmuiꞌ rais jes anteniꞌ. Ho mfain nai ma muꞌsosaꞌ main areꞌ kanan ho ꞌmuiꞌm ein. Rarit meik roit ein reꞌ ho mupein sin naan ma mnao he mbait main sin meu amaꞌmuiꞌt ein. Rarit ho mtebi mfain uum nai he mutuinaꞌ Kau. Uisneno of anseun baran ko npake ꞌmuꞌif neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Oras in neen Naiꞌ Yesus In uaban naan ate, in neekn ii kratiꞌ-kratiꞌ. Ma in nfain nok neek susat maꞌtaniꞌ, natuin atoniꞌ reꞌ naan, amuꞌit batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ma Naiꞌ Yesus ankisu nfuun am nateef ma naꞌuab neu In atoup noinꞌ ein am nak, “Amneen, oo! Amuiꞌt ii naꞌ neu goah he ntaam neu sonaf neno tunan!” ");
INSERT INTO aaz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anneen rasi naan ate, In atoup noinꞌ ein anmukekun. Ma Naiꞌ Yesus naꞌuab antein am nak, “Amneen mirek-rekoꞌ! He tjair Uisneno Iin na, suust ii ka aanꞌ-anaꞌ fa! Kaisaꞌ mitenab am mak maꞌkaf-kafaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Atoin amuiꞌt es he ntaam neu sonaf neno tunan ma njair Uisneno In aanh ate, in suust ii humaꞌ meseꞌ on reꞌ bikaes unta he ntaam neu in oꞌof, annao ntaam anpeoꞌ aent es in konan.” ");
INSERT INTO aaz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naiꞌ Yesus In uaban naan anmoeꞌ sin anjarin ntakaꞌnaan ein antein. Ma sin nmaktaan ein am nak, “Karu namneo on naan ate, sekau es reꞌ bisa napeni ꞌhonis nabar-baar?” ");
INSERT INTO aaz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Naiꞌ Yesus ankius sin meseꞌ-meseꞌ, rarit naꞌuab am nak, “Natuin mahinif ma manoef mansian ii te, of ka njair fa saaꞌ es. Mes mimnau, natuin mahinif ma manoef Uisneno, ka tiit fa saaꞌ es, reꞌ of ka njair fa.” ");
INSERT INTO aaz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Rarit naiꞌ Petrus anmurai naꞌuab am nak, “Aam! Hai mnikan main areꞌ kanan saaꞌ-saaꞌ he mituinaꞌ Ko. Onaim hai of mipein saaꞌ, tua?” ");
INSERT INTO aaz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Naiꞌ Yesus nataah am nak, “Au he utoon ki mꞌak on nai: sekau es reꞌ natuinaꞌ Kau, ma annao naꞌroo naꞌko in ainaf-amaf, in orif-tataf, in aanh ein, in rene, in mepu, nok areꞌ in uim je nanan, he nnao natoon Uisneno In Rais Reko nbi mee-mee, in of antoup nafaniꞌ no nautn es. Areꞌ saaꞌ-saaꞌ reꞌ in nasaitan sin naan, of napein nafaniꞌ sin anneisi ntein naꞌko naan. In of napein haꞌmuꞌit amsaꞌ, natuin in natuinaꞌ Kau. Mes oras pah-piin ii namreꞌu te, in of anmoin nabar-baar nok Uisneno. Rasi reꞌ naan, es reꞌ anjair seun baran neu ne! ");
INSERT INTO aaz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mimnau, joo! Natuin Uisneno In teenb ete, sekau naꞌnaebaꞌ in tuan ii te, of naꞌbaunaꞌ. Ma sekau naꞌparan in tuan ii te, natuin Uisneno In tenab, of naꞌraatn ee.” ");
INSERT INTO aaz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Oras naan, Naiꞌ Yesus sin nnaon neun Yerusalem. Anbi pukan reꞌ naan, Naiꞌ Yesus es reꞌ ahunut. Ma In atoup noinꞌ ein nok tuaf bian antein anbin In kotin. Sin namnau In uaban neon goes ii reꞌ nak, biak ein of naꞌmaet Je nbi Yerusalem. Onaim sin nmukekun ma namtaun amsaꞌ. Anneen on naan ate, Naiꞌ Yesus noꞌen naan In atoup noinꞌ ein anmesen, ma naꞌuab antein saaꞌ reꞌ biak ein of anmoeꞌ Je nbi Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","In naꞌuab am nak, “Hi mneen, oo! Oras ia, hit tnao teu Yerusalem. Au reꞌ ia, Mansian Batuur-Batuur. Mes anbi Yerusalem sin of naꞌsosaꞌ Kau neu aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein ma tunggur agaam ein. Rarit sin of anhukun niis Kau. Ma sin nnonaꞌ Kau neu tua sonaꞌ reꞌ ka nahiin fa Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rarit sin naꞌakan Kau reꞌuf-reꞌuf. Sin naroon Kau. Sin nbeos Au aok ii tar papaꞌ okeꞌ. Rarit sin nroor niis Kau. Namneo, Au ꞌmaet. Ma nmeu te, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Rarit Naiꞌ Sebedius in aanh ein, esan reꞌ naiꞌ Yakobus ma naiꞌ Yohanis, sin neman neu Naiꞌ Yesus. Sin ntotin am nak, “Aam tungguru! Hai he miꞌuab maan akreꞌo, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naiꞌ Yesus nataan sin am nak, “Hi he miꞌuab saaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sin natahan am nak, “On nai, Aam! Natiꞌ karu Ho mtook ma mnaaꞌ aprenat ate, hai mtoit he Ho mutokoꞌ kai, tuaf es anbi Ho ꞌnimam aꞌrii, ma tuaf es anteniꞌ anbi Ho ꞌnimam aꞌneꞌu, he hai mnaaꞌ mok aprenat amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naiꞌ Yesus nataah sin am nak, “Hi nua ki ka mihiin main fa saaꞌ reꞌ hi mtoti. Au reꞌ ia, of upein susat ma nanaꞌrenat amfaun. Onaim on mee? Anbi hi teenb ii te, hi mak, hi mibeiꞌ he mnaben susat ma nanaꞌrenat tar ammaet mok Kau, oo?” ");
INSERT INTO aaz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sin natahan am nak, “Hai mibeiꞌ, tua!” Naiꞌ Yesus naꞌuab antein sin am nak, “Namneo. Hi of amnaben susat ma nanaꞌrenat amsaꞌ on reꞌ Au. ");
INSERT INTO aaz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mes sekau es reꞌ antoko nbi Au ꞌnimak aꞌrii aiꞌ aꞌneꞌu, Au ka ꞌseor Ok fa ꞌbi rasi naan. Natuin rasi naan, Uisneno es reꞌ nafeek. Ma In nafeek anrair sekau-sekau es reꞌ he ntoko nbin bare naan.” ");
INSERT INTO aaz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Oras atoup noniꞌ bian sin annenan naiꞌ Yakobus ma naiꞌ Yohanis sin haan totis on naan ate, sin natoꞌon maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Rarit Naiꞌ Yesus noꞌen sin ok-okeꞌ ma naꞌuab am nak, “On nai! Hi mihini mrair jen, aiꞌ kaah? Kaes koꞌu reꞌ annaꞌan aprenat, sin esan reꞌ natiꞌ te anhaꞌmuiꞌ too gui. Tar antea too gui ka nakbeor ein reko fa. Ma ꞌnakaf-aꞌnakaf anbi pah-pah reꞌ ka nahiin fa Uisneno, sin nanaobaꞌ atoran ma prenat humaꞌ-humaꞌ, tar sin too gui ka bisa nait fa sin aꞌnaak ein. ");
INSERT INTO aaz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mes ka nabeiꞌ fa he hi mmoeꞌ on reꞌ naan! Sekau naꞌko ki reꞌ anroim he njair kaes koꞌu, in ro he njair on reꞌ aꞌbaut he ntuthae in aok-bian ein. ");
INSERT INTO aaz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma sekau es reꞌ anroim he njair aꞌnakat, in ro he nmoeꞌ in tuan aan on reꞌ ate ma nmeup neno-neno on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Fin Au, Mansian Batuur-Batuur, es reꞌ ia. Au ka ꞌuum fa he atoniꞌ ntuthae Kau, mes Au ꞌuum he ꞌtuthae too mfaun ein. Au ꞌuum he ꞌnonaꞌ Au ꞌmoink ii ꞌteme-ꞌteme, he ꞌsoi ꞌaan too mfaun ein naꞌkon sin sanat ma penu sin.” ");
INSERT INTO aaz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naiꞌ Yesus nok In atoup noinꞌ ein ma too mfaun ein neem antean kota Yeriko. Oras sin he nnaon nkonon, sin niit atoin aforot tuaf es antook ma ntoit piut-piut anbi raan ee ninin. In kaan ee, naiꞌ Bartimeus, naiꞌ Timeus in anah. ");
INSERT INTO aaz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Oras in nneen nak, akonot naan Naiꞌ Yesus naꞌko Nasaret te, in nhunun naher-heer am nak, “Yesus! Ho reꞌ naan, sufaꞌ-kaꞌuf naꞌko naiꞌ Daut! Hai mpao Ko ꞌroo-ꞌroo goen, tua! Amturun maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anneen in hanan naan ate, too mfaun ein nakain ee mnak, “Hoe! Mumninuꞌ!” Mes in nhunun naheer antein am nak, “Yesus! Naiꞌ Daut in sufan! Mumnau maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma Naiꞌ Yesus anhake mnak, “Hi meik je neem!” Rarit sin nnaon neun ee mnak, “Noo goah nai! Aam tungguru noꞌen ko. Uum nai!” ");
INSERT INTO aaz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Anneen on naan ate, naiꞌ Bartimeus anporin nain in tai nusat, rarit anfeen ma nnao rab-raab he nateef nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Rarit Naiꞌ Yesus nataan ee mnak, “Ho mroim saaꞌ he Au ꞌmoeꞌ je ꞌeu ko?” Atoin aforot naan nataah am nak, “Koi, Aam! Au ꞌtoits ii es reꞌ karu reko te, au ꞌiit, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Naiꞌ Yesus naꞌuab antein am nak, “Natuin ho mpirsai mrair mak, Au bisa urekoꞌ ko, es naan ate oras ia ho mureok nai! Amkoen om amfain nai!” Rarit naiꞌ Bartimeos in matan afoort ein naan nareok nanin. Onaim in nok annao naat Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Oras sin nhaumaak kota Yerusalem, sin ntean kuan Betfage ma Betania, et aꞌtoꞌef Saitun in abnapan bian. Anbi bare naan, Naiꞌ Yesus sin nasnasan akreꞌo. Rarit In nreun In atoup noinꞌ ein tuaf nua he nnao nahunun. ");
INSERT INTO aaz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","In nbasan sin am nak, “Hi nua ki mnao mihuun meu kuan reꞌ nee. Oras hi mtaam, hi of miit bikaes keledai tipuꞌ es, reꞌ ka masaenaꞌ fa feꞌ, mafutuꞌ et bare naan. Hi mnao mseif in tani ma mheer meik je neem. ");
INSERT INTO aaz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Karu atoniꞌ nataan ki mnak, ‘Nansaaꞌ am es hi mheer meik bikaes keledai naan?’ On naan ate, hi mitaah am mak, ‘Hai Usiꞌ he npaek je. Ma karu In npake nrair je te, naꞌ hai of meik mifainꞌ ee neem.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Rarit tua nuaꞌ ein naan sin nnaon, ma sin niit bikaes keledai tipuꞌ naan mafutuꞌ anbi uim jes in enon, et raan ee ninin. Sin nseif je, he nheer neik je nnao. ");
INSERT INTO aaz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mes atoniꞌ fauk reꞌ anhaken anbin naan nataan sin am nak, “Hoe! Baꞌe! Nansaaꞌ am es hi mseif atoniꞌ in bikaseꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sin natahan am nak, “Hai Usiꞌ he npaek je. Karu npake nrair je te, hai of meik mifainꞌ ee neem, tua.” Onaim tuaf ein reꞌ naan, anfeen sin mainuan he nheer neik bikaseꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sin nheer neik je nnaon ntean Naiꞌ Yesus. Rarit sin naꞌpeniꞌ bikaseꞌ naan npaken tai-mutiꞌ. Rarit Naiꞌ Yesus ansae. ");
INSERT INTO aaz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Oras sin he noi ntaman neu kota, too mfaun ein nait sin tai-faof ein ma sin pouꞌk ein, rarit naꞌbeen sin anbin ranan. Anmuiꞌ tuaf bian anꞌoten on reꞌ pet-noꞌo nbi raan ee ninin, ma naꞌbeen sin anbi raan ee tnanan. Anpaek moꞌet naan, sin he natonan ma nakriir ein nak sin nseun Naiꞌ Yesus nok hormaat, nahuum on reꞌ sin nseun kaes koꞌu. ");
INSERT INTO aaz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Anmuiꞌ tuaf bian reꞌ annao nahunun anbin Naiꞌ Yesus In matan, ma bian namunin. Sin nmurai nsakanan am nak, “Hosana! Hai mpures ma mboꞌis Uisneno! Uisneno nfee tetus-athoen neu amnemat reꞌ neem ma neik Uisneno In kanan, natuin Uisneno es reꞌ anrenu nrair Je! ");
INSERT INTO aaz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Hai mpures ma mboꞌis Uisneno! Natuin Uisneno he nahakeꞌ nafaniꞌ usif naiꞌ Daut in aprenat! Hosana! Hai mpures ma mboꞌis Uisneno! Natuin Uisneno naprenat nan-nain et neno ꞌraat reꞌuf!” ");
INSERT INTO aaz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Oras sin ntean kota naan in nanan, Naiꞌ Yesus sin nnaon ntaman anbin Uisneno In Uim Onen Uuf ee in aꞌfeꞌon. Rarit Naiꞌ Yesus ankius natef-tefan bare naan. Mes, natuin oors ii ka nanokab fa, es naan ate sin ntebi nfanin neun kuan Betania. ");
INSERT INTO aaz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kiuk anaꞌ te, sin npoin naꞌkon Betania he ntaam anfanin neun kota Yerusalem. Anbin raan ee tnanan, Naiꞌ Yesus annaben ate In namnaah. ");
INSERT INTO aaz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","In niit hau roet uuꞌ goes et raan ee ninin. Biasa sin naah in fuan. Onaim Naiꞌ Yesus anhaumaak hau roet naan he nkius niit, kar-karu in nafua, aiꞌ kaah. Mes oras In ntea hau roet naan in uun ii te, In ka niit fa saaꞌ-saaꞌ, natuin hau naan in oors ee ka ntea fa feꞌ he nafua. In feꞌ he nanoo. ");
INSERT INTO aaz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Es naan ate, Naiꞌ Yesus naꞌuab neu hau roet naan am nak, “Natuin ho ka mufua fa meu Kau, es naan ate anmurai naꞌko oras ia, ho ka mufua mtein fa. Ma of ka tiit fa tuaf es he naah antein ho fuam.” In atoup noinꞌ ein annenan In uaban naan maꞌfenaꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Rarit sin nnaon nkonon tar antean Yerusalem, ma Naiꞌ Yesus antaam antein anbi Uisneno in Uim Onen Uuf. Anbi Uim Onen naan in aꞌfeꞌon, too mfaun ein anmoꞌen aꞌmasaꞌ ma naꞌsoos ein kor-kefi, reꞌ biasa sin npaek sin he nfeen fuaꞌ-turuꞌ. Oras Naiꞌ Yesus niit sin on naan ate, In nnao ma nriuꞌ napoitan sin. In nbeso nsisaꞌen mei ngguin reꞌ sin npaek sin he ntuukr ein roit, ma nbeso nsiksakan hau ꞌbeen ein reꞌ sin npaek sin he naꞌsoos ein koron naan. ");
INSERT INTO aaz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","In ntaar too mfaun ein he sin kais neik ein bareꞌ ma nnaon refin ntenin npeꞌon Uim Onen naan in aꞌfeꞌon. ");
INSERT INTO aaz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rarit In nanoniꞌ sin am nak, “Hi mihini mrair saaꞌ-saaꞌ reꞌ Uisneno In mafefa kninuꞌ ntui nain je mnak, ‘Au ufenaꞌ Au Uim ji, he tuaf-tuaf naꞌko areꞌ pah ma uuf neman he nꞌoen ein nbin bare naan.’ Mes hi mmoeꞌ Umi naan anjair baer buat neu abaakt ein!” ");
INSERT INTO aaz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oras aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein ma tunggur agaam ein annenan nak Naiꞌ Yesus anmoeꞌ rasi naan ate, sin natoꞌon ma nek-neuk niisk ein. Rarit sin namin ranan he nroor niis Ne. Mes sin namtausn Ee msaꞌ, natuin too mfaun ein nroim niis In nonin. ");
INSERT INTO aaz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma oras maans ii nmaeb on naan ate, Naiꞌ Yesus sin anpoin naꞌkon kota Yerusalem, ma ntebin nfanin he ntupan nbin kuan Betania. ");
INSERT INTO aaz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Kik-kiku te, sin nnaon nfanin neun Yerusalem. Anbi raan atnanaꞌ, sin nnaon npeꞌon hau roet reꞌ afi naa Naiꞌ Yesus naꞌuab neu ne. In atoup noinꞌ ein ansanmakan, natuin hau roet naan anmate nrair tar in aꞌbaaꞌn ee msaꞌ anmeto nmaet. Rarit naiꞌ Petrus namnau niit Naiꞌ Yesus In uaban afi naa. Rarit in naꞌuab am nak, “Aam! Amkius miit! Hau roet reꞌ afi naa Amaꞌ mtaar ee ji, nmate nrair!” ");
INSERT INTO aaz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Onaim Naiꞌ Yesus nataah am nak, “Namneo! Ro hi he mpirsai Uisneno on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Karu hi mpirsai batuur-batuur, hi of amreun ꞌtoeꞌf es he nananiꞌ bare neu tasi. Rarit Uisneno of nananiꞌ ꞌtoꞌef naan, asar hi kaisaꞌ mpirsai miꞌbaꞌ-baꞌe! Hi ro he mpirsai batuur-batuur meu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kais amnikan! Asar hi mpirsai batuur-batuur mak Uisneno bisa nfee saaꞌ-saaꞌ reꞌ hi mtoit je, In of anfee ki on naan. ");
INSERT INTO aaz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mes karu mꞌonen, ma mmuiꞌ neek maꞌfenaꞌ mok es feꞌe te, hi ro he mnao he mmarameꞌ mok ne. Nok ranan naan ate, naꞌ hi Amaꞌ abit sonaf neno tunan he nsaok nain hi saant ein. ");
INSERT INTO aaz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mes karu naꞌko ki, anmuiꞌ neek menas, ma ka mroim fa he msaok hi aom-bian in sanat, ro tebes hi Amaꞌ abit sonaf neno tunan ka nsaok fa hi saant ein amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Rarit sin nnaon nkonon. Oras sin ntean Yerusalem, sin ntaman ntenin anbin Uisneno In Uim Onen Uuf. Oras sin ntaman ntean in aꞌfeꞌon, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, ma amnais harat Yahudi sin neman ");
INSERT INTO aaz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ma nataan Naiꞌ Yesus am nak, “Afi naa sekau es reꞌ anreun ko he uum meik taisibu mbi bare ia? Sekau es reꞌ anfee ko hak!?” ");
INSERT INTO aaz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Naiꞌ Yesus nahiin nak sin namin ranan he namouf Goe. Rarit In nataah sin am nak, “Au he utaan ki msaꞌ. Hi mitaah Kau feꞌ, henaꞌ Au ꞌutaah ki. ");
INSERT INTO aaz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au he utaan ki on nai: hi arki mihiin naiꞌ Yohanis Asranit reꞌ naan, aa oo? Sekau es reꞌ anreek ee he nasrain? Uisneno oo, aiꞌ mansian?” ");
INSERT INTO aaz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Onaim sin nateenb ein neu-mneman, ma naꞌuab ein am nak, “Amoo! Hit tarair betiꞌ! Karu hit tataah am tak, ‘Uisneno es reꞌ anreun goe te,’ In of nataah kit am nak, ‘Karu on naan ate, neu saaꞌ am es hi ka mpirsai fa naiꞌ Yohanis!?’ ");
INSERT INTO aaz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mes karu hit tataah am tak, ‘Mansian ee es reꞌ anreun goe.’ Of areꞌ too mfaun ein antaisibun, natuin sin npirsain am nak, naiꞌ Yohanis reꞌ naan Uisneno In mafefa kninuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Onaim sin natahan am nak, “Ma neuꞌ! Hai ka mihiin fa, tua.” Rarit Naiꞌ Yesus nataah neu sin am nak, “Naa! Karu on naan ate, Au ka utoon ki fa msaꞌ, sekau es reꞌ anreun Kau.” ");
INSERT INTO aaz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Rarit Naiꞌ Yesus naꞌuab anteniꞌ nok aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, ma atoni mnais harat Yahudi sin. In naretaꞌ am nak, “Anmuiꞌ atoin es ankaun nais feꞌu he nroe anggur anbi naan. Rarit in nbaik poꞌon naan anfuun am nateef. Ma in nmoeꞌ bak he ntoroꞌ fua anggur in oen. In nmoeꞌ tobe msaꞌ. Rarit in naꞌsebaꞌ poꞌon naan neu tuaf bian, he sin nmeup poꞌon naan, he napein in aafn ee te, anbatin. Rarit in nnao neu pah aꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Antea oras he nseib anggur in fuan, auf tuaf naan anreun in ameput tuaf es, he nnao neu ameup poꞌon naan he nait in sapaan. ");
INSERT INTO aaz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mes oras in ntea te, ameup pooꞌn ein naan anheek ma nbeos goe. Rarit sin nreun goe he nfain ruum-ruum. ");
INSERT INTO aaz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rarit auf tuaf naan anrenu nteniꞌ in ameupt es. Mes ameup pooꞌn ein naan naꞌtutuꞌ in aꞌnaak ne tar papaꞌ-papaꞌ. Rarit sin namae je, ma nriuꞌ naꞌaenb ee. ");
INSERT INTO aaz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rarit auf tuaf naan anrenu nteniꞌ in ameput tuaf es aꞌtetaꞌ. Mes sin anroor niis ne. Maski sin nmoeꞌ on mee-on mee msaꞌ, mes auf tuaf naan anreun in ameupt ein piut. Mes ameup pooꞌn ein naan anbeos bian, ma nroor niis bian. ");
INSERT INTO aaz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Namuni te, auf tuaf ee anmuꞌi haa tuaf meseꞌ. Tua meseꞌ naan, es reꞌ auf tuaf ee in aan moen meseꞌ reꞌ in neek niis ne. Natuin ka tiit attein fa ranan bian, es naꞌ in nreun in aan mone naan. In natenab am nak, ‘Karu au ꞌreek au aan moen ji neikn on, sin of antoup goe nok rek-reko, ma sin of natniin ee msaꞌ.’ ");
INSERT INTO aaz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Onaim in anreek haefan in aan mone naan he nnao. Mes oras ameup pooꞌn ein naan niit riꞌanaꞌ naan neem ate, sin naꞌuab ein am nak, ‘Hoe! Hi mkius miit feꞌ! Aꞌnaef ee anreek haefan in aan hoin ee neikn on neem! Karu ꞌnaef ee nmate te, in reꞌ ia of es reꞌ antoup areꞌ baer pusaak ein. Onaim iim he troor tiis ne, he hit tpaar tain areꞌ kanan in aꞌmuiꞌn ein!’ ");
INSERT INTO aaz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Rarit sin arsin anheek je, ma anroor niis ne. Ma sin nporin in aon amates naan anbi pooꞌn ee in kotin. Retaꞌ naan antuuꞌ ma namsoup on reꞌ naan, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Rarit Naiꞌ Yesus nataan areꞌ kaes koꞌun naan am nak, “Natuin hi teenb ein ate, of auf tuaf naan anmoeꞌ saaꞌ neu ameup pooꞌn ein naan? Natuin Au teenb ii te, in of neem ma nroor niis areꞌ ameupt ein naan ok-okeꞌ. Rarit in naꞌsebaꞌ pooꞌ anggur naan neu atoin sonaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hit arkit atrees tiit atbi Uisneno in Suur Akninuꞌ mnak, ‘Anmuiꞌ faut goes reꞌ nahunu te tuukn ein nait inporin. Mes oras ia, fatu naan anjair fatu ꞌsukif neu nii ainaf. ");
INSERT INTO aaz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uisneno es reꞌ anpiir nain Kuun ee, ma nateek fatu naan. Onaim hit tiit atrair in masan arekon!’ ” ");
INSERT INTO aaz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kaes koꞌun naan nahinin nak, Naiꞌ Yesus ansair sin neik retaꞌ reꞌ naan. Sin humaꞌ meseꞌ nok atoin ameup pooꞌ anggur sin. Es naan ate, sin nmurai namin ranan he nheek Je. Mes sin namtausan too mfaun ein reꞌ anromin he natniin Naiꞌ Yesus In nonin. Onaim sin nnaon nasaitn aah Ee. ");
INSERT INTO aaz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Rarit atoin Yahudis sin aꞌnaakt ein anreun tuaf fauk naꞌkon partei pirsait Farisi ma naꞌkon partei purtik Herodes neman he nataan Naiꞌ Yesus he namouf Goe. ");
INSERT INTO aaz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sin neman ntean ate, sin nataan Ee mnak, “Aam tungguru! Hai arkai mihini mmak, Ho neek maan ro amneot, ma ka mputa-kriu miit fa. Ho mkisu haa atoniꞌ in nekan. Ho mutoon munoon Uisneno In romin, natuin Ho ka mpiir fa humaf. Onaim oras ia, hai he mitaan uab es. Tatuin hit atoran pirsait Yahudi te, of hit he tbaenaꞌ beo teu uis koꞌu pah Roma, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mes Naiꞌ Yesus nahini nrair nak, sin namin ranan he nkoop Ee, he nraban aprenat pah Roma. Onaim Naiꞌ Yesus nataah neik haan maꞌfenaꞌ am nak, “Nansaaꞌ am es hi he mkopoꞌ Kau meik rasi naan? Mikriraꞌ miit Kau roit fua es!” ");
INSERT INTO aaz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rarit sin nnonaꞌ roit fuaꞌ es neu Naiꞌ Yesus. In ntoup ma ntae roit naan. Rarit In nataan sin am nak, “Sekau in huumn ii es reꞌ ia? Sekau kaan ee es reꞌ matuꞌi reꞌ ia?” Sin natahan am nak, “Reꞌ naan uis koꞌu pah Roma.” ");
INSERT INTO aaz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Rarit Naiꞌ Yesus naꞌuab am nak, “Karu on naan ate, meik meu prenat saaꞌ reꞌ anjair preent ii in hak. Ma meik meu Uisneno saaꞌ reꞌ anjair Uisneno In hak.” Anneen In haan tahas on naan ate, sin arsin ansanmakan, natuin In uaban naan namneo. Onaim sin ka bisa namouf Goe fa. ");
INSERT INTO aaz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Rarit atoniꞌ fauk naꞌkon pukan pirsait bian neman he namouf Naiꞌ Yesus. (Sin naꞌkon pukan pirsait Saduki reꞌ nanoin ein am nak, amaets ii ka nmonin nfain niit fa). ");
INSERT INTO aaz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sin naꞌuab ein nok Naiꞌ Yesus am nak, “Aam tungguru! Kaꞌo Musa antui hit atoran harat es am nak: karu atoin es nmaet nasaitan in fee, ma ka nmuiꞌ fa anah, atoin amates naan in orif ro he nsao bifee banuꞌ naan, maut he nahoni nfee sufaꞌ-kaꞌuf neu in tataf reꞌ anmate nrair naan. ");
INSERT INTO aaz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Namneo, kaꞌo Musa nanoniꞌ kit on reꞌ naan. Onaim hai he mitaan miit Ko, tua. Anmuiꞌ atoniꞌ hiut anmaꞌori-taatn ein. Moen unu, ansao nahuun, rarit in nmaet, mes ka nahoniꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Onaim in orif reꞌ natuin ee ji ansao bifee banuꞌ naan. Mes ka ꞌroo fa te, in nmaet ma ka nahoniꞌ fa. On naan amsaꞌ, in orif reꞌ natuin ee ji, ansao bifee banuꞌ naan, ma in nmate msaꞌ, mes ka nahoniꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma rasi naan anjari msaꞌ neu amuint ein, tar antea aheit suus goe nmate msaꞌ. Rarit banuꞌ naan anmate msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Onaim oras ia, hai he mitaan on nai: bifee naan ansao niit atoniꞌ hiut! Karu pah-piin ii namsopu te, ma Uisneno namonib nafaniꞌ amaets ein, of sekau es reꞌ anjair mone neu bifee naan?” ");
INSERT INTO aaz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Naiꞌ Yesus nataah sin am nak, “Karu hi mitaan on naan, hi ka mihiin namneo fa Uisneno In Suur Akniun ii in afan. Ma hi ka mihiin fa Uisneno In kuasat amsaꞌ. Onaim hi msaan amrair! ");
INSERT INTO aaz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Amneen! Ka tiit fa rais matsaos et sonaf neno tunan. Areꞌ amates reꞌ Uisneno namonib nafaniꞌ sin, ka nmatsaon ntenin fa. On naan amsaꞌ Uisneno In ameupt ein naꞌkon sonaf neno tunan ka nmatsaon fa. ");
INSERT INTO aaz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Onaim anmatoom nok areꞌ amates he nmoni nfain, aiꞌ kaah, Au he utoon ki on nai: of oniꞌ hi feꞌ ka mitenab maan fa retaꞌ anmatoom nok ai reꞌ nout hau uuꞌ aan es, mes ka npuut fa. Retaꞌ naan nak, Uisneno naꞌuab neu kaꞌo Musa mnak, ‘Ho naiꞌ-kaꞌo sin Uisneon goe es reꞌ Au. Sin esan reꞌ kaꞌo Abraham, kaꞌo Isak, ma kaꞌo Yakop. Sin arsin naꞌruir ein ma naꞌbesan piut neu Kau, tar antea oras ia.’ ");
INSERT INTO aaz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Onaim hit tahini mtak sin naiꞌ-kaꞌo sin anmaten nrarin oras ahunut. Mes, natuin Uisneno nak, In anjair sin Uisneon goa feꞌ, es naan ate hit tahiin tak, sin nmonin nfanin. Onaim maski sin anmaten nrarin, mes sin nmonin nfanin amsaꞌ. Namneo, amoint ii es reꞌ naꞌruriꞌ ma naꞌbees neu Uisneno. Mes atoin amaets ii, kaah fa aiꞌ? Onaim karu hi mnaaꞌ miheran noniꞌ reꞌ nak, amaets ein ka nmonin nfanin fa, ro hi msaan teb-tebe!” ");
INSERT INTO aaz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anbi oras naan, anmuiꞌ naan tunggur agama tuaf es nok antook ma nneen Naiꞌ Yesus naꞌuab nok atoniꞌ pukan Saduki sin. Tunggur agama naan natenab nak, Naiꞌ Yesus nataah sin haan tanas sin nok reko. Rarit in nataan Naiꞌ Yesus am nak, “Aam! Au he utaan Ko on nai: hit atoran harat ma prenat rais pirsait ein amfau reꞌuf. Naꞌko areꞌ kanan prenat kaꞌo Musa, prenat mee es reꞌ pentiing anneis ji?” ");
INSERT INTO aaz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Naiꞌ Yesus nataah am nak, “Prenat reꞌ pentiing anneis anbi Uisneno In Suur Akninuꞌ nak on nai: ‘Areꞌ kanan atoin Israelas ki, amneen mirek-rekoꞌ! Uisneno ro hit Usif, ma hit Aꞌnakat. Ka tiit fa bian anteniꞌ, In nmees Kuun! ");
INSERT INTO aaz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Onaim hi ro he mneek Ee anneis naꞌko areꞌ bian sin. Es naan ate, hi ro he mimnau Goe piut-piut, mihiin Je batuur-batuur, ma mmeup maꞌtaniꞌ he mituin In romin.’ ");
INSERT INTO aaz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma prenat no nua ii nak: ‘Ho ro he mneek ho aok-bian, namnees on reꞌ ho mneek ho tuam aan kuum.’ Prenat noon nuaꞌ ein reꞌ ia, esan reꞌ pentiing anneis. Ka nmuiꞌ fa prenat bian reꞌ pentiing anneis naꞌkon preen nuaꞌ ein reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Rarit tunggur agama naan naꞌuab antein neu Naiꞌ Yesus am nak, “Namneo! Reꞌ Ho muꞌuab ee naan, namneo. Uisneno anjair hit Usif, ma ka tiit fa Uisneno ꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hit ro he tneek Ee anneis naꞌko areꞌ kanan saaꞌ-saaꞌ, ma tamnau Goe piut, tahiin Je, ma tmeup maꞌtaniꞌ he tatuin In romin, ma hit ro he tneek hit aok-bian ein namnees on reꞌ hit tneek hit tuak. Nok ranan naan ate, naꞌ Uisneno anmariin anneis, naꞌko hit arahaa he tatuin atoran rais pirsait anmees. Naan reko nneis naꞌko hit arahaa he troor muꞌit he taꞌturuꞌ, aiꞌ atfee bareꞌ bian neu Ne.” ");
INSERT INTO aaz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Anneen in haan tahas naan ate, Naiꞌ Yesus natenab nak tunggur agama naan nahiin In sarit naan nok reko. Onaim Naiꞌ Yesus nak, “Aar akreꞌo te, ho he noi mjair Uisneno Iin na.” Rarit, ka nmuiꞌ fa tuaf es anteniꞌ reꞌ he nroim he nataan Naiꞌ Yesus, fin ka tiit fa es reꞌ nabeiꞌ Je te. ");
INSERT INTO aaz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Rarit Naiꞌ Yesus nanoniꞌ too mfaun ein anbi Uisneno In Uim Onen Uuf. In nataan sin am nak, “Natuin hi teenb ii te, on mee? Tunggur agaam ein nanoin ein am nak, Kristus reꞌ naan es reꞌ Tuaf reꞌ Uisneno nruur nain Je naꞌko afi unu. Ma sin natenab nak, In suma sufaf naꞌko usif naiꞌ Daut. Mes tenab naan ka namneo fa. ");
INSERT INTO aaz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Natuin afi unuꞌ Uisneno In Asmaan Akninuꞌ anpaek naiꞌ Daut he ntui mnak, ‘Uisneno natoon anrair au usiꞌ mnak, “Uum he mtook meu baer amasat et Au ꞌnimak aꞌneꞌu. Au of aꞌmoeꞌ areꞌ ho muusn ein, tar sin naꞌruir ein neu ko.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Naꞌko naan ate, hit tahiin tak usif naiꞌ Daut anteek Kristus nak ‘Usif’. In aꞌmoufn ii nak, karu sin nteek ee nak Kristus naan suma usif naiꞌ Daut in sufan-kaꞌun, naan ka nanokab fa feꞌ. Fin In anjair usif naiꞌ Daut in Usin amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Oras Naiꞌ Yesus naꞌuab on naan ate, too mfaun ein anromin he nneen Ee. ");
INSERT INTO aaz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Rarit In naꞌuab antein neu sin am nak, “Hi ro he mpaant om miꞌko tunggur agaam ein. Sin nromin he npairiurs ok neik sin baru mnaun ein, he nnao nateef nok too mfaun ein, he sin niit sin am nak, ‘Hoe! Sin ro kaes koꞌu batuur!’ ");
INSERT INTO aaz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Karu sin antaman anbin uim onen, aiꞌ nokan nbin fesat, sin namin aꞌtook arekot he too mfaun ein niit sin. ");
INSERT INTO aaz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mes mpaant om! Fin sin reꞌ naan nputa-kriu bifee baun ein, he nasiik ma ntoup naan sin uimn ein. Mes anbi too mfaun ein sin maatk ein, sin naꞌkoroꞌ sin ꞌmoeꞌ reuꞌf ein naan nok sin onen amnanu-mnanuꞌ. Sin nromin he biak ein nahinin nak sin neek ein kniunꞌ ein. Mes Uisneno of anfee kasat maꞌfenaꞌ neu sin.” ");
INSERT INTO aaz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Rarit Naiꞌ Yesus antoko nbaniꞌ neu peti ꞌturuꞌ, anbi Uisneno In Uim Onen Uuf. In niit tuaf amfaun neman ma ntao sin roi kolekte nbin peti ꞌturuꞌ naan. In niit atoin amuꞌit sin neman ma nataam sin roit koꞌu nbin naan. ");
INSERT INTO aaz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rarit bifee banuꞌ amaꞌmuꞌit tuaf es neem ma nꞌonen nok. In nataam roit sen nua nbi peti naan. Roit naan in oosn ii aanꞌ-anaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Onaim Naiꞌ Yesus annapen In atoup noinꞌ ein ma naꞌuab neu sin am nak, “Hi mkius mirek-rekoꞌ meu bifee banuꞌ amaꞌmuꞌit nee. In nataam roit suma sen nua goah, mes in nfee nneis naꞌko areꞌ kanan afeet ein. ");
INSERT INTO aaz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sin arsin anfeen kolekte naꞌko roi nesif. Mes bifee banuꞌ ia, anfee nain in roit ein okeꞌ neu Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein anpoin naꞌkon Uim Onen Uuf. Oras sin npoin, In atoup noniꞌ tuaf es naruur Ee Uim Onen Uuf naan, ma naꞌuab am nak, “Bait Ho mkius miit ia feꞌ! Umi ia reokn ii kaah! Sin nbakin in faut kouꞌn ii reko ꞌmaten!” ");
INSERT INTO aaz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mes Naiꞌ Yesus nataah ee mnak “Uim Onen ia, ro namaas! Mes ka ꞌroo fa te, sin of anpukai natserab areꞌ fatun reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Rarit Naiꞌ Yesus sin nnaon neun aꞌtoꞌef Saitun, ma ntokon nbain ein anꞌanin Uisneno In Uim Onen Uuf. Rarit In atoup noinꞌ ein tuaf haa, neman ma naꞌuab nok Ne. Sin esan reꞌ naiꞌ Petrus, naiꞌ Yakobus, naiꞌ Yohanis, ma naiꞌ Anderias. ");
INSERT INTO aaz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Sin nataan Ee mnak, “Aam! Bait Ho mutoon mufaniꞌ miit kai Ho uabam feꞌe na. Rekaꞌ te in oors ii ntea? Ma in taanr ein, onan reꞌ mee?” ");
INSERT INTO aaz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Rarit Naiꞌ Yesus nataah am nak, “Asar hi mpanat mirek-rekoꞌ, he kais napoi naan ki. ");
INSERT INTO aaz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Natuin of anmuiꞌ tuaf amfaun reꞌ neman ma npaas sin aꞌbaask ein am nak, ‘Au reꞌ ia, Kristus, Atoniꞌ reꞌ Uisneno nbaꞌan nain Je naꞌko unuꞌ.’ Onaim sin napoi naan tuaf amfaun. ");
INSERT INTO aaz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Karu hi miit atoniꞌ anmakenan, aiꞌ hi mneen uab anin nak anmuiꞌ makenat et mee-mee, hi kais mimtau. Natuin areꞌ rasin naan ro he nboran, mes neon amsoupt ein ka ntea fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fin uuf es of anfeen ma nmaraban uuf es. Ma pah es of anmakeen nok pah es. Tainuuns ii anhasuꞌ anbi mee-mee. Amnaahs ii of maꞌtaniꞌ msaꞌ. Areꞌ rasin reꞌ ia anjarin tanar namnees on reꞌ bifee maꞌapuꞌ reꞌ nnaben meen mahoniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Onaim hi arki ro he mpanat mirek-rekoꞌ. Sin of neman ma nheek ki, rarit anheer neik ki neu umi feek rais pirsait. Ma sin of anbeos ki nbi uim oen ein sin naank ein. Ma sin of anfuut neik ki neu areꞌ anaaꞌ apreent ein, natuin hi mituinaꞌ Kau. Mes rasin naan amsaꞌ, anjarin asraak he hi mitonan sin areꞌ rasi anmatoom nok Kau. ");
INSERT INTO aaz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Fin Uisneno In aanh ein ro he nnaon ma natoon nahunun Au Rais Reko neun areꞌ uuf-uuf anbin pah-pinan ia, rarit naꞌ neon amsoupt ein antean. ");
INSERT INTO aaz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mimnau! Karu sin nfuut neik ki neu umi feek rasi, hi kais mimtau ma mitenab am mak, ‘Au he uꞌuab ꞌak saaꞌ? Aiꞌ au he utaah ꞌak saaꞌ?’ Karu in oors ii antea, hi miꞌuab mituinaꞌ saaꞌ reꞌ Uisneno In Asmaan Akninuꞌ natoon ee neu ki. ");
INSERT INTO aaz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anbi uim jes in nanan, karu tuaf es anpirsai neu Kau, of in orif-tataf sin es reꞌ namin ranan he nroor niis ne. Karu aanh ee es reꞌ anpirsai, of in aamf ee kuun es reꞌ neikn on anroor niis ne. Ma karu in ainaf-amaf anpirsai Kau, of sin aanh ein es reꞌ anroor niis sin. ");
INSERT INTO aaz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Onaim of biak ein nsaken niis ki, natuin hi mpirsai meu Kau. Mes sekau es reꞌ naran tar antea namsoup, Uisneno ro nafeitn ee ma nfee ne ꞌhonis.” ");
INSERT INTO aaz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Naiꞌ Yesus naꞌuab ankono mnak, “Tuaf es reꞌ neik amreꞌut of he neem. In ntaam ma nhake nbi baer nuni nbi Uisneno In Uim Onen Uuf, reꞌ ka pantas fa neu ne, tar in nhaiꞌniis bare naan. Es naan ate, Uisneno annao nasaitan bare naan. Karu hi miit rasi naan, hi mpanat mirek-rekoꞌ! (Sekau es reꞌ anrees reꞌ ia te, ro he npaant on!) Naan anjair tanar nak neon suust ein anpaumakan reꞌ-reuꞌf een. Karu hi miit on naan ate, abitan propinsi Yudea amfeen maen nai meu ꞌtoeꞌf ein. ");
INSERT INTO aaz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma hi ro he maen rab-raab, he kais amsiraak om. Karu tuaf mee npoi nrair naꞌko in umi, kais antebi nfain he nait bareꞌ bian antein. ");
INSERT INTO aaz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma tuaf reꞌ anbi rene, kais antebi nfain he nait tai nusat antein. Ro in naen ankoon! ");
INSERT INTO aaz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Reꞌ ansuus anneis-neis ji, es reꞌ bifee maꞌapuꞌ, ma bifee reꞌ nasuus riꞌanaꞌ. Fin sin ka bisa naen nanan fa. ");
INSERT INTO aaz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Onaim reko nneis hi mꞌonen ma amtoit he rais amreꞌut naan kais neem nateef nok oras uran-anin. ");
INSERT INTO aaz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Fin oras naan, maꞌnuuk ii kouꞌ reꞌuf! Anmurai naꞌko Uisneno nmoeꞌ pah-pinan ia tar antea neno ia, ka tiit fa suust es kouꞌn ii on reꞌ naan. Ma atoniꞌ of ka niit anteniꞌ fa susat nahuum on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Karu Uisneno ka naꞌparan fa neon suust ein naan, ka tiit fa tuaf he nmoni nkoon. Mes natuin Uisneno nneek niis In aan piir ein, es naan ate In naꞌparan neon suust ein naan. ");
INSERT INTO aaz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Karu nenon naan antean ate, hi of amneen biak ein naꞌuab ein am nak, ‘Amkius nai! Kristus es ia!’ Mes tuaf bian nak, ‘Kristus et nee!’ Mes natiꞌ hi kais amneen, oo! ");
INSERT INTO aaz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ma of anmuiꞌ atoniꞌ reꞌ anpoi ma npaas in aꞌbasan am nak, ‘Au reꞌ ia, Kristus!’ Bian anteniꞌ nak, ‘Au reꞌ ia, Uisneno In mafefa kninuꞌ.’ Sin of anmoꞌen rais sanmakat humaꞌ-humaꞌ neik kuasat naꞌkon niut reꞌuf he nputa-kriu. Sin namin ranan humaꞌ-humaꞌ he karu reko te, sin nasekeb Uisneno Iin na. ");
INSERT INTO aaz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hi ro he mpanat mirek-rekoꞌ! Neon suust ein naan ka ntean fa feꞌ, mes Au umnaub ꞌain ki sin!” ");
INSERT INTO aaz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Rarit Naiꞌ Yesus antaru ntein In uaban neu In atoup noinꞌ ein am nak, “Karu neon suust ein ankonon ate, ‘Maans ii of nameisꞌook, ma fuun ii of nasab-saab amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Akfuun ein of anbamoufun naꞌkon neon goe tnanan, ma areꞌ kuasat abitan neon goe tnanan anrikraakn ok.’ ");
INSERT INTO aaz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rarit naꞌ areꞌ mansian of niit Kau, Mansian Batuur-Batuur reꞌ ia. Of Au ꞌuum uꞌko neon goe tunan. Ma areꞌ too mfaun ein of niit Au kuasak, ma Au pinak ma krahak ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Rarit Au of aꞌreun Uisneno In ameupt ein naꞌkon sonaf neno tunan, he nnaon nabuabaꞌ areꞌ tuaf ein reꞌ Au ꞌpiri ꞌrair sin, naꞌkon pah-piin ii tuuk am tuuk, naꞌkon pasaꞌ neon-saet tar antea pasaꞌ neon-teas, naꞌkon pasaꞌ ponain tar antea pasaꞌ haaꞌ-nua.” ");
INSERT INTO aaz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Naiꞌ Yesus antaru ntein In uaban am nak, “Au ꞌait retaꞌ uꞌko hau. Karu hau naan in nook ein nmurai namnatun, naan anjair tanar nak oras fauk-nais ii anpaumaak een. ");
INSERT INTO aaz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","On naan amsaꞌ, karu hi miit neon suust ein naan neman, on reꞌ saaꞌ reꞌ Au utoon aꞌrair ki naan, naan anjarin tanar nak anpaumaak he Au ꞌuum een. ");
INSERT INTO aaz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Oras ia, amneen mirek-rekoꞌ! Naꞌko hi ar-arki reꞌ ia, of anmuiꞌ tuaf reꞌ anmoin feꞌ, oras neon suust ein naan antean. ");
INSERT INTO aaz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maski neno tunan ma pah-pinan namneuk, mes Au uabk ii of antahan nabar-baar.” ");
INSERT INTO aaz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Naiꞌ Yesus antaru ntein am nak, “Ka tiit fa tuaf es, reꞌ nahiin neno mee, aiꞌ anreuk fauk ate, of Au ꞌfain ꞌuum. Uisneno In ameupt ein sonaf neno tunan amsaꞌ ka nahinin fa. Au Tuak ii msaꞌ, ka uhiin fa. Suma Au Amaꞌ anmees nahiin. ");
INSERT INTO aaz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Natuin rasi naan ate, hi ro he mpanat mirek-rekoꞌ, natuin hi ka mihiin maan fa rekaꞌ te in oors ii ntea. ");
INSERT INTO aaz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka ꞌroo fa te, Au ꞌnao usaitan ki. Mes of Au ꞌfain ꞌuum. Namnees on reꞌ tuaf reꞌ annao nporin in umi neu bare ꞌroo-ꞌroo. In nreun in ameupt ein he npao in umi naan rek-reko. Ma in nbati nfeen sin es am es ate nok in mepu. In naprenat apao enoꞌ he npanat narek-rekoꞌ tar antea in nfain neem. ");
INSERT INTO aaz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hi ro he mpao fai-manas amsaꞌ, natuin hi ka mihiin fa oras mee te, uim tuaf naan of anfain neem. He maans ii nmabe, oo, fai tnanaꞌ, oo, maans ii naꞌpupuꞌ, oo, aiꞌ maans ii feꞌe nsae. Hi ka mihiin maan fa neu he rekaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kais-kaisaꞌ in neem nok askeken ate, in napein ki amtuup amfiin ma mikoon feꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Onaim saaꞌ reꞌ Au utoon ꞌeu ki ia, Au utoon ꞌeu bian sin amsaꞌ am ꞌak, ‘Hi ro he mpanat mirek-rekoꞌ he mseun Kau.’ ” Nok rasi naan ate, Usif Yesus naꞌtuꞌub In uaban nok In atoup noinꞌ ein nbin aꞌtoꞌef Saitun. ");
INSERT INTO aaz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Rarit aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein ma tunggur agaam ein namin raan maꞌnifaꞌ feꞌ he nheek Naiꞌ Yesus. Fin sin he nroor Goe. Ma sin anꞌaotr ein asraak am nak, “Kaisaꞌ feꞌ! Kais atmanaap he theek Je, fin neon kouꞌn ii anhaumaakn een. Kais-kaisaꞌ too mfaun ein napoitn ein taisibu.” Sin naꞌuab ein on naan, natuin anmeu te, atoin Yahudis sin nateef nok neon koꞌu ‘Paska’, ma ‘Fesat Utunuꞌ ka Maseor Muur fa’. Anbin nenon reꞌ naan, sin feest ein he namnau nafaniꞌ oras ahunut, reꞌ Uisneno napoitan sin beꞌi-naꞌi sin naꞌkon pah Masir. ");
INSERT INTO aaz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anbi kuan Betania, anmuiꞌ atoin es, kaan ee naiꞌ Simon. Nahunu te, atoniꞌ anmaiꞌniisn ee, natuin in ameen nui-atrokiꞌ. Mes oras ia, in nareko nrair. Onaim oras neon kouꞌ gui ka ntea fa feꞌ, Naiꞌ Yesus sin annaon ma nbukaen anbin naiꞌ Simon in umi. Oras sin nbukaen, bifee jes neem nateef nok Naiꞌ Yesus. In nnaaꞌ neik boot faut goes, reꞌ narai je nok miin foo meniꞌ reꞌ maꞌosaꞌ. Rarit bifee naan anꞌipu nporin botor naan in neon. Ma in naronib akreꞌo-kreꞌo neu Naiꞌ Yesus In aꞌnakan he anjair tanar nak in nhormaat Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mes anbi naan, anmuiꞌ atoniꞌ fauk reꞌ anbukaen nokan amsaꞌ. Oras sin niit bifee naan anmoeꞌ on reꞌ naan, sin natoꞌon ma naꞌuab ein nok haan beꞌo mnak, “Huu! Bifee saaꞌ na es reꞌ ia, es naꞌ in nporin nareuꞌ miin foo meniꞌ maꞌosaꞌ reꞌ ia!? ");
INSERT INTO aaz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Reko nneis in naꞌsosaꞌ minaꞌ reꞌ naan! Rarit in nbait roit ein naan neu amaꞌmuiꞌt ein! Natuin miin foo meniꞌ naan in oosn ii namnees nok kai tuaf es anbi toon es.” Rarit sin nakain ee nok maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mes Naiꞌ Yesus nataah sin am nak, “Hi kais misusab bifee reꞌ ia! Amkonan! Au ꞌmariin, natuin in nꞌoop anrair miin foo meniꞌ neu Au aok. ");
INSERT INTO aaz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Amaꞌmuiꞌt ein nok ki neno-neno. Onaim hi bisa mturun ma mbaab sin ansuun oras. Mes ka ꞌroo fa te, Au ka neu he ubua ꞌteniꞌ fa ꞌok ki. ");
INSERT INTO aaz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Au ꞌmoink ii ka ꞌroo fa goen. Ma bifee reꞌ naronib minaꞌ neu Kau, in npairoir nain Au aok ii, on reꞌ in nkakiꞌ nain fubonaꞌ neu Au aok-taꞌuk. ");
INSERT INTO aaz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mimnau mirek-rekoꞌ! Uisneno In Rais Reko of nanaob on anbi mee-mee nbi pah-pinan ia, ma tuaf of naretaꞌ anmatoom nok bifee ia in aꞌmoꞌen arekot. Maut he areꞌ mansian ein namnau goe.” ");
INSERT INTO aaz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Rarit anmuiꞌ tuaf es naꞌko atoup noniꞌ tuaf boꞌes am nua, kaan ee naiꞌ Judas Iskariot. In npoi nnao ma naim aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, he naꞌsosaꞌ Naiꞌ Yesus neu sin. Oras in nateef nok sin, in nateabaꞌ in sarit. ");
INSERT INTO aaz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oras aꞌnaakt ein anneen naiꞌ Judas in uaban naan, sin nmarinan nmaten. Ma sin nbaasn ee mnak, “Karu ho he muꞌsosaꞌ Naiꞌ Yesus meu kai, hai of ambaen ko.” Rarit naiꞌ Judas anpoi ma nmurai naim ranan he nanaꞌat Naiꞌ Yesus neu sin. ");
INSERT INTO aaz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Neno naan, neon ahunut naꞌko neon koꞌun atoin Yahudis sin. Anbi neno naan, sin biasa ntunun utunuꞌ reꞌ ka mamuur fa, ma sin nroron ꞌbib-kase msaꞌ. Onaim Naiꞌ Yesus In atoup noinꞌ ein neman ma nataan Ee mnak, “Aam! Neno ia, hit neon koꞌu Paska. Onaim Ho roim ii he hai mnao mibarab baer fesat Paska meu mee?” ");
INSERT INTO aaz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Rarit Naiꞌ Yesus anreun In atoup noniꞌ tuaf nua mnak, “Hi mnao mihuun nai meu kota. Anbi naan, of hi miteef mok atoin es reꞌ nasaah oe nbi kuis aan es. Hi mnao mituin ee. ");
INSERT INTO aaz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Karu in nnao ntaam neu umi mee te, hi mtaam mituin ee. Rarit hi mitoon meu uim tuaf naan am mak, ‘Aam! Hai Tungguur goe ntoit bare he nmoeꞌ fesat Paska nok In atoup noinꞌ ein.’ ");
INSERT INTO aaz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Fin atoniꞌ naan of naruruꞌ ki keꞌen mainuan es, et umi ktutaꞌ naan in fafon. In nkikin anrair keꞌen naan. Onaim hi nua ki mibarab bukaet ambi naan.” ");
INSERT INTO aaz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Rarit sin nua sin annaon neun kota. Anbi naan, sin nateef nok areꞌ saaꞌ-saaꞌ reꞌ Naiꞌ Yesus natoon anrair sin. Onaim sin nabarab he Naiꞌ Yesus sin nbukaen fesat Paska anbi naan. Rarit sin nua sin annao naskau Naiꞌ Yesus nok In atoup noniꞌ bian. ");
INSERT INTO aaz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Oras maans ii he noi nmouf, Naiꞌ Yesus nok In atoup noniꞌ boꞌes am nua nnaon ntaman neun bare naan. ");
INSERT INTO aaz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Anbin bare naan, sin ntokon ma nbukaen nabu-buan. Oras sin nbukaen, Naiꞌ Yesus naꞌuab am nak, “Hi mneen! Anmuiꞌ tuaf es naꞌko ki reꞌ of naꞌsosaꞌ Kau neu atoin sonaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oras sin nnenan on naan ate, sin neek ein naꞌuun ein. Rarit sin es-es ate nataan Naiꞌ Yesus am nak, “Aam! Reꞌ Ho mteek ee naan, ka au fa, oo?” ");
INSERT INTO aaz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naiꞌ Yesus nataah am nak, “Tuaf reꞌ narepaꞌ utunuꞌ nok Kau nbi ꞌpik-oef ia, of in es reꞌ naꞌsosaꞌ Kau. ");
INSERT INTO aaz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mimnau, joo! Au, Mansian Batuur-Batuur reꞌ ia, ro he ꞌmaet, on reꞌ matuꞌi nrair et Uisneno In Suur Akninuꞌ. Onaim ampaant om! Atoniꞌ reꞌ naꞌsosaꞌ Kau naan, of in nsutai kuun in amreꞌun! Reko nneis bait in ainf ee kais nahoins ee.” ");
INSERT INTO aaz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Oras sin nbukaen, Naiꞌ Yesus nait naan utunuꞌ fua es, ma ntoit makasi neu Uisneno. Rarit In nteib utunuꞌ naan pisaꞌ-pisaꞌ, ma nfee sin neu In atoup noinꞌ ein. Rarit In naꞌuab am nak, “Utunuꞌ reꞌ ia, Au aok. Mait ma mbukae nai, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Rarit In nait naan kraa mninut reꞌ matuaꞌ tua min-kase. Ma In ntoit makasi neu Uisneno. Rarit In nnonaꞌ kraas naan neu In atoup noinꞌ ein, he sin nbukaen. ");
INSERT INTO aaz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma In naꞌuab am nak, “Tua min-kase ia, Au naaꞌ. In of natꞌoop he nsoi nafetin too mfaun. Naaꞌ reꞌ ia, anjair tanar reꞌ namnaub kit nak, saaꞌ reꞌ Uisneno nbaꞌan anrair sin naan, anjarin esan reꞌ ia. Mait ma mbukaen nai. ");
INSERT INTO aaz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amneen mirek-rekoꞌ! Anmurai mabeꞌ ia, Au ka neu he ꞌbukae ꞌteniꞌ fa tua min-kase on reꞌ ia. Tar Au ꞌok Au Amaꞌ amtuun Om ma miprenat mibu-bua mbi sonaf neno tunan, naꞌ Au ꞌbukae ꞌteniꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rarit sin nsii siit es, he nboꞌis Uisneno. Rarit sin npoin oras fai, ma nnaon neun aꞌtoꞌef Saitun. ");
INSERT INTO aaz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oras sin nnaon nabuan naan, Naiꞌ Yesus natoon nanin sin am nak, “Mabeꞌ ia, hi arki of maen misaitan Kau. Fin matuꞌi nrair et Uisneno In Suur Akninuꞌ nak, ‘Uisneno of naꞌmaet atukus, ma in ꞌbib-kaesn ein naen ansiksaakn ok.’ ");
INSERT INTO aaz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Namneo, Au ro he ꞌmaet. Mes karu Au ꞌmoni ꞌfain jen ate, Au of aꞌnao uhunun ki ꞌeu propinsi Galilea.” ");
INSERT INTO aaz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Rarit naiꞌ Petrus anprotees am nak, “Aam! Maski sin naen nasaitan Ko, mes au ka neu fa he ꞌaen, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Naiꞌ Yesus nataah am nak, “Peꞌu! Natiꞌ mumnau! Mabeꞌ ia, nahuun naꞌko maun ii nkokreꞌon hanaꞌ nua, ho musuan amrair Kau eraꞌ teun goen mak, ho ka muhiin Kau fa!” ");
INSERT INTO aaz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mes naiꞌ Petrus haan ii nsae mnak, “Kaah fa, tua! Karu Ho mmate te, au ꞌmaet ꞌok. Au ka neu fa he ꞌaen usaitan Ko, tua!” Naiꞌ Petrus in aok-bian sin es-es ate naꞌuab on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Rarit Naiꞌ Yesus nok sin annaon nkonon ma ntean pooꞌn es et aꞌtoꞌef Saitun, kaan ee ‘Getsemani’. Onaim Naiꞌ Yesus naꞌuab neu sin am nak, “Amtoko mpao Kau mbi reꞌ ia. Au he ꞌnao ꞌonen ꞌeu reꞌ nee.” ");
INSERT INTO aaz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma In nhaman neik naiꞌ Petrus, naiꞌ Yakobus, ma naiꞌ Yohanis, he nnao nabua nok Ne. Anmurai naꞌko oras naan, In neekn ii nsuus ma ka ntaininaꞌ fa. ");
INSERT INTO aaz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","In naꞌuab neu sin am nak, “Au neek ii nsuus anmaet! Au ꞌnaben ate Au he ꞌmaet jen. Hi mtook ma mpao mbi reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Rarit In nnao nteniꞌ kreꞌo, rarit anriꞌtuu ma nꞌonen am nak, “Amaꞌ amanekat! Karu Ho mromi te, Au kais aꞌsutai nanaꞌrenat naan tar aꞌtea he ꞌmaet on reꞌ ia. Au uhiin urair ꞌak, ka tiit tain fa saaꞌ reꞌ Ho ka bisa mmoeꞌ maan ee fa. Onaim karu reko te, Ho mait muꞌrobaꞌ rais haꞌmuꞌit reꞌ ia naꞌko Kau. Mes kaisaꞌ mutuin Au romik; maut nai he mutuin Ho romim, tua.” ");
INSERT INTO aaz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Rarit In nfain neu In atoup noniꞌ tua teun ein naan, mes sin ntupan nfinin. Onaim In npooꞌ naꞌfenaꞌ sin, ma naꞌuab neu naiꞌ Petrus am nak, “Hoe! Peꞌu! Ho mtuup kuum, oo? Au ꞌbi nee rabah. Mes hi he mpao kreꞌo msaꞌ, hi ka mibeiꞌ fa! ");
INSERT INTO aaz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mumeu maatm ein naan feꞌ. Rarit amfeen he mpao mok Kau! Hi neekm ein anromin he hi mmoeꞌ rais reko, mes hi aom ein anꞌoren. Onaim reko nneis hi mꞌonen, he karu ꞌsuuꞌ te neem ate, kais niis ki.” ");
INSERT INTO aaz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Rarit Naiꞌ Yesus annao nꞌonen anteniꞌ haef es. In ntoit antein he Uisneno nait naꞌrobaꞌ rais haꞌmuꞌit reꞌ naan naꞌko In tuan. ");
INSERT INTO aaz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Rarit In nfain neem neu In atoup noniꞌ tua teun ein naan. Mes sin ntupan nfinin, fin sin maatk ein nmaꞌfenan reꞌ-reꞌuf. Onaim In npooꞌ nafenaꞌ ntein sin. Mes sin ka nahini ntein-teinꞌ ein fa, he nataah Ee nak saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Rarit Naiꞌ Yesus annao nasaitan sin he nꞌonen haeꞌ teun ii. Rarit In nfain neem, ma anpooꞌ nafenaꞌ antein sin. In naꞌuab am nak, “Airoo! Hi mtuup-tuup feꞌ, oo? Noo goah nai! Amfeen nai! Fin atoniꞌ reꞌ naꞌsosaꞌ Kau, Mansian Batuur-Batuur reꞌ ia, anpaumaak een. Oras ia, sin he nheek ma nnonaꞌ Kau neu atoin amoeꞌ saant ein. ");
INSERT INTO aaz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amfeen nai ma mkius nai! Atoniꞌ reꞌ naꞌsosaꞌ Kau, neem een. Iim he tnao tateef tok sin!” ");
INSERT INTO aaz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Oras Naiꞌ Yesus naꞌuab on naan feꞌe te, nok askeken naiꞌ Judas nok atoni mfaun ein neman. Sin neik suin tukaꞌ nok hau tukaꞌ, he nheek Naiꞌ Yesus. Sin nmoeꞌ rasi naan, fin sin napenin aprenat naꞌko atoin Yahudis sin aꞌnaakt ein. Sin arsin esan reꞌ aꞌnakat rasi pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, ma mnais harat Yahudi sin. ");
INSERT INTO aaz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naiꞌ Judas ansenen nain sin am nak, “Amkius mirek-rekoꞌ! Au ꞌneek sekau te, mheek Je nai! In es reꞌ hi mam-mami!” ");
INSERT INTO aaz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Onaim oras naiꞌ Judas nok sin antean bare naan, in neem anhake nbi Naiꞌ Yesus In matan. Ma in nasee Je mnak, “Aam Tungguru!” Onaim naiꞌ Judas anhoo ma nneek Ee. ");
INSERT INTO aaz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Rarit too mfaun ein neman he nheek Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mes Naiꞌ Yesus In atoup noniꞌ tuaf es anfaik in benas, ma nsaip namouf atoin es in rukin noon. Atoin ruik papaꞌ naan, aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe in ate. ");
INSERT INTO aaz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rarit Naiꞌ Yesus naꞌuab nok tuaf ein reꞌ he nheek Je naan am nak, “On mee? Hi mak Au reꞌ ia, atoin aburarut Kau, oo? Es naꞌ hi iim he mheek Kau meik suniꞌ ma hau tukaꞌ? ");
INSERT INTO aaz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Neno-neno te, Au unoniꞌ ki aꞌbi Uisneno In Uim Onen Uuf, mes ka tiit fa tuaf es, reꞌ neem he nheek Kau. Iim he mheek Kau nai! Fin rasi naan matuꞌi nrair naꞌko unuꞌ et Uisneno In Suur Akninuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Naiꞌ Yesus In atoup noinꞌ ein namtau nmaten. Onaim sin naen nasaitn Ee nmees. ");
INSERT INTO aaz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anbi naan, anmuiꞌ atoin muinf es, annao natuinaꞌ Naiꞌ Yesus. In tainuus tai tuuk es. Atoni mfaun sin he nheek je msaꞌ, ");
INSERT INTO aaz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mes sin nnaaꞌ naan ahaa in tais. Onaim in naen aaf-aaf aah, natuin in namtau nmaet. ");
INSERT INTO aaz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rarit sin neik Naiꞌ Yesus annao neu aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe in umi. Anbi naan, kaes kouꞌn ein nabuan nrarin. Sin arsin esan reꞌ aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, tunggur agaam ein, ma atoni mnais harat Yahudi sin. ");
INSERT INTO aaz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Oras sin nheek neik Naiꞌ Yesus ate, naiꞌ Petrus natuin nok aꞌkor-koroꞌ, tar antea aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe in umi. In ntaam anbi umi naan in kintal, ma in ntook nok araar ai ngguin. ");
INSERT INTO aaz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anbi umi naan in nanan, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein naꞌuab ein nok afeek rais pirsait ein. Sin arsin namin bukti he nasaan Naiꞌ Yesus, fin sin he nhukun naꞌmaet Je. Mes sin ka napenin fa bukti saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rarit sin noꞌen saksii namfau, he namouf Naiꞌ Yesus. Mes sin uabk ein nasurin es nok es. ");
INSERT INTO aaz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Rarit anmuiꞌ saksii bian reꞌ anfeen anhaken ma naꞌuab ein puta-kriu mnak, ");
INSERT INTO aaz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hai mneen atoniꞌ ia naꞌuab am nak, ‘Au of useer Uim Onen Uuf, reꞌ nafeen ee neik ꞌnimaf mansian. Ma neno tenu nteniꞌ te, Au ufena ufaniꞌ Umi naan, mes ka ꞌpaek fa ꞌnimaf mansian.’ ” ");
INSERT INTO aaz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mes sin uabk ein nasurin es nok es. ");
INSERT INTO aaz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Rarit aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe nfeen anhaek anbi areꞌ afeek rasin naan sin maatk ein. In nataan Naiꞌ Yesus am nak, “Too mfaun ii natraak Ko. Mes nansaaꞌ am es Ho mtaaꞌ kuum?” ");
INSERT INTO aaz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mes Naiꞌ Yesus ka ntoin fa fefaꞌ mese msaꞌ. Onaim aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe nataan Ee mnak, “Ho mutoon miit! In amneon ii, Ho reꞌ ia, batuur-batuur Kristus, Uisneno In Anah reꞌ In nbaꞌan nain Je naꞌko un-unuꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Naiꞌ Yesus nataah am nak, “Namneo! In es reꞌ Au reꞌ ia. Hi arki of miit Kau, Mansian Batuur-Batuur reꞌ ia, aꞌtoko ꞌbi sonaf neno tunan, aꞌbi Uisneno In abnapan aꞌneꞌu. Uisneno anmuiꞌ kuasat maꞌtaniꞌ nneis! Au of ꞌok Ne mnaaꞌ aprenat mibu-bua. Namuni te, Au ꞌsaun ꞌuum aꞌbi nope uꞌko sonaf neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Anneen Naiꞌ Yesus In uaban naan ate, aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe natooꞌ maꞌtaniꞌ, tar antea in npius nakratiꞌ in baru mnanuꞌ. Rarit in nkoaꞌ ma naꞌuab neu areꞌ afeek raisn ein am nak, “Hit kais taim atteniꞌ saksii! ");
INSERT INTO aaz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hi mneen meik hi ruikm ein kiim. In es neikn on naꞌuab on naan. In nait In tuan ii njair Uisneno in Anah. In naꞌreꞌuf Uisneno! Tatuin hit atoran rais pirsait, karu tuaf es nanees on nok Uisneno, in ro he nmaet! Onaim oras ia, hi he mifeek mak saaꞌ?” Onaim sin nafekan ok-okeꞌ mnak, “Namneo, atoniꞌ ia nsaan! Onaim ro he thukun tiis ne!” ");
INSERT INTO aaz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Rarit tuaf fauk neiki ntaman ma naroon Naiꞌ Yesus. Sin nꞌaum naan In maatk ein, rarit sin nbeos Goe. Onaim sin nataan Ee mnak, “Ho mtakseer miit, sekau es reꞌ antuuf ko?” Rarit sin noꞌen apao Uim Onen Uuf ein, he neem ma neik Naiꞌ Yesus. Oras sin neik Je nnao, sin npaas nafan-fainꞌ Ee. ");
INSERT INTO aaz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Oras naan, naiꞌ Petrus antoko nbi kintal feꞌ. Rarit aet bifee tuaf es naꞌko aꞌnaak rais pirsait Yahudi sin aꞌnaak kouꞌ goe, neem niit naiꞌ Petrus anraar ai. In nnanoꞌ narek-rekoꞌ naiꞌ Petrus in human, ma in naꞌuab am nak, “Feꞌe na, ho mubua mok Naiꞌ Yesus, atoin Nasaretas naan. Tebe, oo?” ");
INSERT INTO aaz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mes naiꞌ Petrus nataah am nak, “Kaah fa, tua! Nansaaꞌ am es ho mutaan on naan? Au ka uhiin Je fa!” Rarit naiꞌ Petrus anpoi ma nhaek anbi enoꞌ ꞌkonoꞌ. Nateef oras naan, maun goe ankokreoꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Rarit ate naan niit anteniꞌ naiꞌ Petrus. Ma in natonan atoni mfaun nbin naan am nak, “In reꞌ ia, tuaf es naꞌko sin amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mes naiꞌ Petrus anprotees am nak, “Of oniꞌ ho mumaun! Au ka uhiin Je fa!” Ka ꞌroo fa te, tua ꞌtetaꞌ es, reꞌ anhake nbi naan naꞌuab anteniꞌ naiꞌ Petrus am nak, “Hoe! Ho he mputa-kriu mak ho ka mubua mok sin fa! Hi arki atoin Galileas!” ");
INSERT INTO aaz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mes naiꞌ Petrus anraban maꞌtaniꞌ am nak, “Au ꞌsuup! Au ka uhiin fa atoniꞌ naan, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nateef oras in naꞌuab on naan ate, maun goe nkokreoꞌ no nua. Onaim naiꞌ Petrus namnau niit Naiꞌ Yesus In uaban feꞌe na nak, “Nahuun naꞌko maun ii ankokreꞌon no nua te, ho musuan Kau eraꞌ teun goen.” Oras namnau niit on naan ate, naiꞌ Petrus ankae nmeꞌ-meꞌur. ");
INSERT INTO aaz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Neis noi nmeu te, afeek raisn ein sin nneek mesen he naꞌmaet Naiꞌ Yesus. Onaim sin nfuut neik Je he nateef nok gubernur Pilatus. ");
INSERT INTO aaz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Oras sin ntean gubernur ee, in nataan Naiꞌ Yesus am nak, “On mee? Namneo ho reꞌ ia atoin Yahudis sin Usif?” Naiꞌ Yesus nataah am nak, “Batuur! Amaꞌ gubernur ho uabam naan, batuur.” ");
INSERT INTO aaz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Rarit aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein naꞌuab ein nok gubernur ee mnak, “Atoniꞌ ia In saant ii mfau reꞌuf!” Onaim sin nsoiꞌ In saant ein meseꞌ-meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Rarit gubernur naan nataan antein Naiꞌ Yesus am nak, “Ho ka mneen fa sin uabk ein naan, aa oo? Sin nasaeb ko sanat amfaun. Bait ho mutaah miit feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mes Naiꞌ Yesus ka ntoin fa fefaꞌ meseꞌ amsaꞌ, tar antea gubernur ee nsanmaak. ");
INSERT INTO aaz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Toon-toon ate, karu atoin Yahudis sin anmoꞌen fesat Paska, biasa too mfaun ein anpiir naan atoin bui tuaf es, he gubernur ee nafeitn ee naꞌko bui. ");
INSERT INTO aaz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oras naan, anmuiꞌ atoin bui tuaf es, kaan ee naiꞌ Barabas. Nahunu te, sin nheek je natuin in nraban anaaꞌ aprenat pah Roma, ma in nroor atoniꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Natuin fesat Paska naan anpaumaak een, es naꞌ atoni mfaun ein nnaon neun gubernur Pilatus ma nhuun ein am nak, “Amaꞌ gubernur! Neon koꞌu Paska anpaumaak een. Karu reko te, mufetin atoin bui tuaf es, on reꞌ toon-toon.” ");
INSERT INTO aaz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rarit gubernur ee ntoin sin am nak, “On naan ate, au he ufetin ki sekau? Karu au ufetin ki atoin Yahudis sin Usif reꞌ ia te, hi mromi, oo?” ");
INSERT INTO aaz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernur ee naꞌuab on naan, amneon ii in nahiin anrair nak, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein neik Naiꞌ Yesus neu ne, natuin sin neek ein namenan nmaten neu Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mes areꞌ aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein anhuitan too mfaun ein he sin ntoit neu gubernur ee mnak, “Hai ka mrom-roim main Je fa! Mufetin kai naiꞌ Barabas, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Rarit gubernur ee nataan anteniꞌ sin am nak, “Karu on naan ate, au he ꞌmoeꞌ saaꞌ ꞌeu Naiꞌ Yesus, reꞌ sin nteek nain Je mnak ‘atoin Yahudis sin Usif’ ia?” ");
INSERT INTO aaz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Onaim sin nhuun ein ok-okeꞌ am nak, “Muꞌmate He! Amkuus muꞌpeit Ee meu hau neeh je, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rarit gubernur ee nataan am nak, “In saant ii saaꞌ? Au uprikas urair Je, mes au ka upein fa sanat meseꞌ msaꞌ!” Mes sin arsin anhuun ein naher-heran nteinꞌ ein am nak, “Muꞌmate He! Amkuus Ee nai meu hau neeh je, tua!” ");
INSERT INTO aaz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Natuin gubernur ee he nharineb too mfaun ein sin neek ein, onaim in nafetin naiꞌ Barabas natuin sin roimk ein. Rarit in naprenat atoin apaot ein he sin nnao nbeos Naiꞌ Yesus anpaken aꞌkauboe. Anbeso nrair Je te, soraurs ein neik Naiꞌ Yesus anpoi nnaon he nkuus niis Ne nbi hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Rarit soraurs ein anheer neik Naiꞌ Yesus neu sin koat ee in kintal. Anbi naan, sin noꞌen nabuab sorarus puukn es, of oniꞌ tuaf natun niim. ");
INSERT INTO aaz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma sin nabaur Naiꞌ Yesus neik baru mnanuꞌ masnaa mee-umub, on reꞌ uisf ein biasa npake. Rarit sin nait noon maꞌaikaꞌ ma sin nriiꞌ ꞌsoeb es. Ma sin ntumaꞌniiꞌ nataam ꞌsoeb maꞌaikaꞌ naan neu Naiꞌ Yesus In aꞌnakan, he sin naꞌraur ein on reꞌ he nasaebaꞌ ꞌpiruꞌ-baru neu uis feuꞌ goes. ");
INSERT INTO aaz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rarit sin naꞌruir ein ma naꞌbesan, rarit nakreeꞌt Ee mnak, “Tabe, Aam Usiꞌ Yahudi!” ");
INSERT INTO aaz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma sin naꞌruir ein napo-poin anbi Naiꞌ Yesus In matan. Ma sin npuurn ein hape fani-fani neu In human. Rarit sin nteeꞌ nafan-faink Ee neikin hau. ");
INSERT INTO aaz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sin nakreꞌet narair Je on naan ate, sin npuuꞌ nain baru mnanuꞌ naan. Ma sin napakeb nafaniꞌ In paken. Rarit sin neik Je npoi naꞌko kota Yerusalem, he nkuus naꞌpeit Ee nbi hau nehe tar anmaet. ");
INSERT INTO aaz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oras sin npoin nnaon naꞌkon Yerusalem, sin nateef nok atoin es anbi raan atnanaꞌ. Atoniꞌ naan naꞌko kota Kirene, kaan ee naiꞌ Simon. In reꞌ naan, naiꞌ Aleksander ma naiꞌ Rufus sin amaf. In feꞌ he ntaam neu kota Yerusalem ate, soraurs ein anheer naan ee, ma naꞌseek ee he nasaah Naiꞌ Yesus In hau nehe. ");
INSERT INTO aaz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sin nheer neik Naiꞌ Yesus antea baer jes, kaan ee Golgota. (In aꞌmoufn ii ‘bare ꞌnaak nuif’.) ");
INSERT INTO aaz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anbi naan, sin he naꞌinuꞌ Naiꞌ Yesus neik raur maiꞌninuꞌ maseor reꞌu, he In bisa naran menas. Mes In ka nroim fa he niun. ");
INSERT INTO aaz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Rarit sin nkuus natneneb Naiꞌ Yesus anbi hau nehe. Onaim sin nahakeꞌ hau nehe naan, of oniꞌ feꞌ anreuk seo. Rarit soraurs ein anheran suur anaꞌ he naparaꞌ sekau es reꞌ napein Naiꞌ Yesus In paken. ");
INSERT INTO aaz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rarit sin ntuin anbi hau pisaꞌ es am nak: “Atoniꞌ ia, atoin Yahudis sin Usif” Rarit sin nkuus hau pisaꞌ naan, anbi hau nehe neis faof, anhaumaak Naiꞌ Yesus In aꞌnakan. Sin npaek rais matuꞌi naan he nhuukn Ee. ");
INSERT INTO aaz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Anbi naan, sin nkuus naꞌmaet aburarut tuaf nua msaꞌ. Es anbi Naiꞌ Yesus In abnapan aꞌneꞌu, ma es antein anbi ꞌrii. ");
INSERT INTO aaz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nok rasi naan ate, sin natuin saaꞌ reꞌ matuꞌi nain anbi Uisneno In Suur Akninuꞌ reꞌ nak, “Sin nmoeꞌ Je nahuum on reꞌ atoin amoeꞌ reꞌuf.” ");
INSERT INTO aaz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Areꞌ atoni mfaun ein reꞌ annaon natuin ranan naan, niit Naiꞌ Yesus makfiriꞌ anbi hau nehe. Onaim sin nkiuꞌn ein ma nakreꞌet Naiꞌ Yesus am nak, “Hoe! Ho es reꞌ mak, Ho he mpukai mureuꞌ Uisneno In Uim Onen Uuf, rarit mufenaꞌ mufainꞌ ee anbi neno teun in nanan. ");
INSERT INTO aaz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Maut he Ho msaun muꞌko hau nehe naan, he mufetin Ho tuam aan nai! Karu Ho mmoeꞌ on naan ate, naꞌ hai mpirsai mmak Ho reꞌ ia Uisneno In Anah.” ");
INSERT INTO aaz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein nok tunggur agaam ein nakreꞌet Naiꞌ Yesus amsaꞌ am nak, “In nsoi nafetin biak ein, mes In ka bisa nafetin naan fa In tuan. ");
INSERT INTO aaz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","In nteek In tuan ii nak ‘Kristus’, Atoniꞌ reꞌ Uisneno anbaꞌan nain Je naꞌko un-unuꞌ. Bian nak, In reꞌ naan atoin Israelas sin Usif. Karu namneo on naan ate, maut he In nsaun naꞌko hau nehe he hai miit feꞌ. Rarit hai mpirsai meu Ne.” Tua nuaꞌ ein reꞌ naꞌpetiꞌ sin buꞌ-buaꞌ nok Naiꞌ Yesus anbi sin hau nehe meseꞌ-meseꞌ, sin nakreꞌet Naiꞌ Yesus amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rarit meisꞌookn ii nꞌaum naan bare naan, naꞌko maans ii naꞌpuup tar antea nreuk teun maans ii nmaeb. ");
INSERT INTO aaz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oras anreuk teun on naan ate, Naiꞌ Yesus anhunun neik uab Aram am nak, “Eloi! Eloi! Lema sabaktani?” (Reꞌ neik hit uab ii te nak, “Koi, Au Usiꞌ! Koi, Au Uisneno! Nansaaꞌ am es Ho mparakan Kau on reꞌ ia?”) ");
INSERT INTO aaz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tuaf fauk reꞌ anhaumakan anbin naan, sin nnenan neu Naiꞌ Yesus In hanan naan. Onaim sin naꞌuab ein am nak, “Hoe! Hi mneen feꞌ! In nkoaꞌ kaꞌo Elia, Uisneno In mafefa kninuꞌ un-unuꞌ.” ");
INSERT INTO aaz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rarit tuaf es naen nait aniꞌ-tei metoꞌ ma nateep ee nbi raur maiꞌninuꞌ. Rarit napuunk ee nbi hau goes in tunan, ma naramib Naiꞌ Yesus he nmuis. Rarit atoniꞌ naan naꞌuab am nak, “Ampao he hit kius tiit! Kais-kaisaꞌ kaꞌo Elia neem ma nasaunt Ee naꞌko hau nehe.” ");
INSERT INTO aaz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Rarit Naiꞌ Yesus anhunun anteniꞌ, ma In nmaet. ");
INSERT INTO aaz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Anbi Uim Onen Uuf ee, anmuiꞌ naan tai eon kouꞌ goes, nakfiirꞌ ee he nakiin Uisneno In Keꞌen Akninuꞌ. Oras Naiꞌ Yesus snaasn ii natfeek, tai eon koꞌu naan natpisuꞌ nbait nua naꞌko faof tar antea ꞌpiin. ");
INSERT INTO aaz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anbi Golgota, atoin aꞌnaak paot es anhake nhaumaak Naiꞌ Yesus In hau nehe. Oras in niit Naiꞌ Yesus In aꞌmaten, in naskeek. Rarit in naꞌuab am nak, “Ai joo! Atoniꞌ ia namneo-namneo Uisneno in Anah!” ");
INSERT INTO aaz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Anmuiꞌ naan bifee fauk reꞌ napeen Naiꞌ Yesus In aꞌmaten naꞌkon aꞌroo. Sin esan reꞌ nahunu te antuthaen Naiꞌ Yesus nok In atoup noinꞌ ein anbin pah Galilea. Sin esan reꞌ ain Salome, bi Maria naꞌko kuan Makdala, nok ain Maria (reꞌ naiꞌ Yakobus muniꞌ nok naiꞌ Yoses sin ainaf), ma bifee mfaun bian anteniꞌ reꞌ neem nabu-buan nok Naiꞌ Yesus neun Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Rarit atoin es naim ranan he nasanut Naiꞌ Yesus In aon-taꞌun amates naꞌko hau nehe. Atoniꞌ naan kaan ee, naiꞌ Yusuf. In naꞌko kota Arimatea. In reꞌ naan tuaf es naꞌko pukan afeek rais pirsait Yahudi. In neekn ee reko. In anpao-pao prenat Uisneno reꞌ he neem. Naiꞌ Yesus anmaet nok neon nimaꞌ. Nokaꞌ te nateef nok atoin Yahudis sin neon onen. Es naan ate, anbi neon nimaꞌ naan, naiꞌ Yusuf he nasanut nahunun Naiꞌ Yesus In aon. Naiꞌ Yusuf anhaꞌtain in nekan, ma nnao nbaiseun gubernur Pilatus he nasanut Naiꞌ Yesus In aon amates naan. ");
INSERT INTO aaz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Oras gubernur ee anneen naiꞌ Yusuf in haan totis naan ate, in nsanmaak. Onaim in naꞌuab am nak, “Ai joo! Atoniꞌ naan anmaet rabah, oo! Anbi au teenb ii te, au ꞌak oniꞌ ka feꞌ.” Rarit in nreun tuaf he noꞌen aꞌnaak paot. Oras in neem antea te, gubernur ee nataan am nak, “On mee? Naiꞌ Yesus anmate nrari oo, aiꞌ kaah feꞌ?” ");
INSERT INTO aaz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aꞌnaak paot naan nataah am nak, “Namneo! In nmaet jen, tua.” Oras gubernur ee nneen on naan ate, in nfee mainuan neu naiꞌ Yusuf he nnao nasanut Naiꞌ Yesus In aon-taꞌun naan. ");
INSERT INTO aaz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Rarit naiꞌ Yusuf annao neu Golgota. Ma in nasanut Naiꞌ Yesus In aon naꞌko hau nehe. In nꞌaum uisminaꞌ naan neik tai feꞌu reꞌ maꞌosaꞌ. Neot naan, sin feꞌ anpahat anrair noup fatu es anbi kneet fatu. Rarit sin nsorot nataam uisminaꞌ naan neu noup fatu. Onaim sin narituꞌ faut been kouꞌ goes, he naꞌeek naꞌmaet noup fatu naan. Rarit naiꞌ Yusuf sin anfanin. ");
INSERT INTO aaz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Oras naan, bi Maria naꞌko Makdala, ma ain Maria (naiꞌ Yoses in ainaf), sin nokan anbin naan amsaꞌ. Sin nua sin ankius narek-rekoꞌ bare reꞌ sin natunuꞌ Naiꞌ Yesus In aon-taꞌun naan. ");
INSERT INTO aaz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nokaꞌ neon neꞌe, atoin Yahudis sin neon onen. Maans ii nmoufu nrari te, bi Maria naꞌko kuan Makdala, ma ain Maria (naiꞌ Yakobus in ainaf), nok ain Salome, sin nnao nsosan miin fubonaꞌ, he nokaꞌ te, sin he nnaon nkaik ein neu Naiꞌ Yesus In aon-taꞌun natuin sin harat atoin Yahudis. ");
INSERT INTO aaz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma nokaꞌ snaat ii nsae on naan ate, sin teun sin annaon neun noup fatu naan. ");
INSERT INTO aaz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Anbi raan atnanaꞌ sin naꞌuab ein am nak, “Amoo! Of sekau es reꞌ ntitar naꞌrobaꞌ kit faut koꞌu naan naꞌko noup goe in enon? Hit teun kit ka neu taꞌbeiꞌ je fa. Fatu naan kouꞌ reꞌuf!” Mes oras sin ntean bare naan, sin niit fatu naan natnanib anrari. ");
INSERT INTO aaz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Rarit sin ntaman nkonon anbin noup fatu naan. Mes nok askeken, sin niit atoin muinf es anpaek mutiꞌ nariim, antook anbi sin abnapak aꞌneꞌu. ");
INSERT INTO aaz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Onaim atoin munif naan naꞌuab neu sin am nak, “Hi kais mimtau! Au uhiin ꞌak hi iim he maim Naiꞌ Yesus, atoin Nasaretas naan, reꞌ sin naꞌmate nrair Je nbi hau nehe. In ka et fa ia. In nmoni nfain jen! Iim he hi mkius kiim bare reꞌ sin natunuꞌ Naiꞌ Yesus In aon-taꞌun naan. Ka tiit Ee fa goen! ");
INSERT INTO aaz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Onaim hi mfain nai rab-raab! Amnao mitoon meu naiꞌ Petrus sin am mak, Naiꞌ Yesus anmoni nfain jen. In nnao nahunun ki neu pah Galilea. Maut he sin nateef nok Naiꞌ Yesus anbin naan, on reꞌ nahunu te In natonan nrair sin. Onaim hi mfain nai!” ");
INSERT INTO aaz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Oras bifeen naan niit noup ruman naan ate, sin naskeken. Onaim sin naen anpoin. Sin nfanin rab-raab. Sin npeꞌon raan ee te, ma sin ka natonan fa sekau-sekau, natuin sin namtau nmaten. ");
INSERT INTO aaz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Anbi neno krei kik-kiku te, Naiꞌ Yesus annao nateef nahuun nok bi Maria reꞌ naꞌko kuan Makdala. Bi Maria reꞌ naan, nahunu te Naiꞌ Yesus anriuꞌ napoitan niut reꞌuf hiut naꞌko in tuan. ");
INSERT INTO aaz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oras bi Maria nateef anrair nok Naiꞌ Yesus, in nfain ma natoon neu amfaut ein reꞌ nahunu te sin natuin Naiꞌ Yesus. Sin nabu-buan nok susat ma kaet feꞌ, natuin sin namnau Naiꞌ Yesus In aꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Rarit bi Maria naꞌuab neu sin am nak, “Nansaaꞌ am es hi msuus ma mkae feꞌ? Kais amnanaꞌreen amtein, natuin Naiꞌ Yesus anmoni nfain jen! Feꞌe na, au uteef ꞌok Ne!” Mes sin arsin antonin am nak, “Ho mupoi!” ");
INSERT INTO aaz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Rarit Naiꞌ Yesus In atoup noniꞌ tuaf nua annaon neun kuan es. Anbin raan atnanaꞌ te, Naiꞌ Yesus nakriir On neu sin, mes In naꞌbaniꞌ. Mes ka ꞌroo fa on naan ate, sin nahiin Je. ");
INSERT INTO aaz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rarit sin nua sin anfanin ma natonan sin aok-bian ein am nak, “Hoe! Hi mneen feꞌ! Feꞌe na hai miteef mok Naiꞌ Yesus anbi ranan!” Mes sin aok-bian ein antonin am nak, “Heero! Hi kaisaꞌ mipoi on naan!” ");
INSERT INTO aaz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rarit Naiꞌ Yesus nateef nok In atoup noniꞌ tuaf boꞌes am meseꞌ. Oras naan, sin ntokon ma nbukaen. In naꞌuab neu sin am nak, “Hi ꞌnaak-fautm ein ii! Atoniꞌ natoon anrair ki mnak sin niit anrair Kau neik sin matak fuak ein, mes hi ka mpirsai fa joo! Hi mak, sin arsin napoin! Oras ia, Au ꞌeikn Ok ꞌuum. Namneo Au ꞌmaet, mes oras ia, Au ꞌmoni ꞌfain! Hi miit kiim meik hi matam fuam ein. ");
INSERT INTO aaz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Onaim oras ia hi ro he mnao mfuun am mitefan pah-pinan ia, he mitonan areꞌ mansian ein ok-okeꞌ Au Rais Reko ia. ");
INSERT INTO aaz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sekau reꞌ anpirsai neu Kau, ma nasrain je, of Uisneno nsoi nafeitn ee, he in natua nabar-baar nok Uisneno nbi sonaf neno tunan. Mes sekau reꞌ ka npirsai fa te, of in napein hukun, ma Uisneno nriuꞌ napoitn ee, rarit natua nabaar anbi moneꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma reꞌ apirsait neu Kau, of sin nmoꞌen rais sanmakat humaꞌ-humaꞌ, he too mfaun ein nahinin nak sin kuasat naan naꞌuu ma naꞌbaaꞌ naꞌko Uisneno. Aꞌtopeꞌ on reꞌ: sin bisa nriuꞌ niut reuꞌf ein neik Au kanak. Of Uisneno nmoeꞌ sin he sin naꞌuab ein neik uab bian reꞌ sin ka nahiin je fa. ");
INSERT INTO aaz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rarit karu sin nnaaꞌ kaun reꞌuf, aiꞌ sin niun naan raso, sin ka neu he nsiraak ok fa. Karu sin npohon ma nꞌoen ein neun amenat, amenat naan nareok.” ");
INSERT INTO aaz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oras In naꞌuab anrair nok In atoup noinꞌ ein on naan ate, Uisneno nait nasaebaꞌ Naiꞌ Yesus neu sonaf neno tunan. Anbi naan, In njair Uisneno In tua pirsaꞌi, he sin nua sin antokon ma napreent ein buꞌ-buaꞌ. ");
INSERT INTO aaz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Rarit In atoup noinꞌ ein nmoeꞌ natuin In aprenat. Sin nnaon neun bare-bare ma natonan areꞌ too mfaun ein anmatoom nok Naiꞌ Yesus In Rais Reko. Uisneno nfee kuasa neu sin, he sin nmoꞌen areꞌ rais sanmakat reꞌ Naiꞌ Yesus natoon anrarin sin. Onaim too mfaun anpirsain neu Naiꞌ Yesus, natuin sin nahinin nak Rais Reko naan ro namneo. ");
INSERT INTO aaz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Aam Teofilus reꞌ mahormataꞌ. Hoore, tua. Tuaf amfaun ein ansobaꞌ he ntui nitan retaꞌ anmatoom nok rasin reꞌ anjarin anbin hit sonak ma hit atnanak. Sin ntui rasin naan, anpaken retaꞌ reꞌ napniub on naba-baar aah naꞌko kai neu hai nmurai naꞌko oras unuꞌ, reꞌ hai mihiin main sin naꞌko Usif Yesus in tuaf ein reꞌ anpaumaak Ee, ma naꞌko tuaf bian amsaꞌ reꞌ nitan nok sin maatk ein kuuk. Areꞌ reet ein naan, batuur-batuur natuin ahaa Uisneno In rais manbaꞌan unuꞌ naan. Onaim au ꞌparikas urair sin ntea namtiis, nmurai naꞌko rasi naan in uun aꞌbaꞌan. Rarit au ufeek he ꞌtui urek-rekoꞌ sin utuin sin aꞌnaok ein. Nok ranan naan, ho bisa muhiin batuur-batuur saaꞌ-saaꞌ reꞌ anjarin nrarin. ");
INSERT INTO aaz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma ho bisa mpirsai mmak, saaꞌ reꞌ tuaf-tuaf sin nareet ein naan, ka rais poi fa. Rasin naan, batuur-batuur anjarin, tua! ");
INSERT INTO aaz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Retaꞌ reꞌ ia in uun aꞌbaaꞌn ii on nai: oras usif Herodes annaaꞌ aprenat anbi propinsi Yudea, anmuiꞌ naan atoin es, kaan ee naiꞌ Sakarias. In reꞌ naan, aꞌnaak rais pirsait Yahudi tuaf es. Ma in imsaꞌ tuaf es naꞌko pukan naiꞌ Abia in aꞌnaak pirsait ein. Naiꞌ Sakarias in fee je, es reꞌ bi Elisabet. Bi Elisabet naan naꞌko sufaꞌ-kaꞌuf aꞌnaak pirsait ein amsaꞌ, natuin kaꞌo Musa in tataf naiꞌ Harun in sufan-kaꞌun. ");
INSERT INTO aaz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sin nua sin nmonin natuin ahaa Uisneno In aprenat ma atoorn ein ok-okeꞌ. Atoniꞌ anhormaat sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma sin nua sin namnasin nrarin, mes ka nmuꞌin fa anah, natuin bi Elisabet naan, ankiu. ");
INSERT INTO aaz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Neot es, naiꞌ Sakarias nok in pukan Abia sin napenin tabu-mainuan he ntaman nmepun nbin Uim Onen Uuf nbin kota Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Natuin sin haart ii te, aꞌnaak pirsait ein anheran suur anaꞌ, he nahinin nak, sekau es reꞌ anmuiꞌ sapaaf he ntaam neu Uim Onen Uuf naan in Keꞌen Akninuꞌ nneis-neisi. Anbi naan, tuaf atamas naan ro he nout hau foo meniꞌ anbi Uisneno In human ma In matan. Neno naan, naiꞌ Sakarias es reꞌ anheer naan suur anaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Rarit in ntaam neu Keꞌen naan. Oras in nout hau foo meniꞌ nbi Keꞌen naan, too mfaun ein anꞌoen ein anbin kintal naan. ");
INSERT INTO aaz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nok askeken ate, Uisneno In ameput es neem naꞌko sonaf neno tunan ma nhake nbi bare reꞌ nout hau foo meniꞌ naan in aon bian aꞌneꞌu. ");
INSERT INTO aaz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ankius niit on naan ate, naiꞌ Sakarias namtau nmaet, tar antea in ka nahiin fa he nmoeꞌ saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mes ameput sonaf neno tunan naan naꞌuab am nak, “Sakarias! Kais mumtau! Fin Uisneno anneen anrair ho onen totis. Onaim ho fee jan of nahoniꞌ riꞌaan moen jes neu ko. Ho ro he mukaanb ee, naiꞌ Yohanis. ");
INSERT INTO aaz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Too mfaun ein of anmarinan buꞌ-buaꞌ nok ki, natuin hi mihoniꞌ. Riꞌanaꞌ reꞌ naan, of anharineb ho nekam naan. ");
INSERT INTO aaz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Uisneno In Asmaan Akniunꞌ ee ankuaas naan ee, nmurai naꞌko oras in nbi in ainf ee apun. In ro he nanunin areꞌ kanan mniun mafu. Oras in naꞌnae neem ate, Uisneno anpaek je njair atoin koꞌu. ");
INSERT INTO aaz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","In of anfuriꞌ too Israelas amfaun he ntebi nfanin natuin sin Usif, es reꞌ Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","In aꞌmoꞌen ma taos natai on reꞌ kaꞌo Elia, Uisneno In mafefa kninuꞌ unuꞌ naan. In neem nahunun hit Usiꞌ. In nabanit mahoint ein he nneek sin aanh ein. Ma tuaf-tuaf reꞌ nkoit Uisneno, in nabanit sin amsaꞌ, he sin nabain ein anfain neman, ma natuin Uisneno In romin. Nok ranan naan, in nabarab sin neek ein he ntoup Usiꞌ In amneman.” ");
INSERT INTO aaz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mes naiꞌ Sakarias nataan ameput naan am nak, “Heeꞌ! Naan of anjair on mee? Au ꞌok au fee je mimnasi mrair jen! Au ꞌmoeꞌ on mee, he au bisa uhiin ꞌak rasin naan of anjarin?” ");
INSERT INTO aaz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rarit ameput naan nataah am nak, “On nai! Au reꞌ ia, naiꞌ Gabrial, Uisneno In tua renuꞌ. In neikn On anreun kau he ꞌuum utoon ko rais reko reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mes ho ka mpirsai fa au uabk ein reꞌ ia. Onaim tanar reꞌ ho mtoit je ji, on nai! Ho maam aan of ka nakberoꞌ reko fa karu ho mroim he muꞌuab. Onaim ho ka bisa muꞌuab fa saaꞌ-saaꞌ, nmurai reꞌ oras ia, tar antea hi mihoniꞌ riꞌanaꞌ naan. Ho mkius kuum. Saaꞌ reꞌ au uꞌuab ee reꞌ ia of anjair, nateef nok in oras.” ");
INSERT INTO aaz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Too mfaun ein reꞌ anꞌoen ein etan moneꞌ-mainuan, antakaꞌnaan ein, natuin naiꞌ Sakarias ka npoi fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Oras in npoi neem ate, in ka naꞌuab nahiin fa saaꞌ-saaꞌ. Rarit in npaek in aꞌniman he nsenen sin. Onaim sin nahinin nak, Uisneno nakriraꞌ nrair je rais sanmakat es anbi Keꞌen Akninuꞌ nneis-neis naan. ");
INSERT INTO aaz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sin tabu-mainuan naan oekꞌ ein, onaim naiꞌ Sakarias antebi nfain neu in umi. ");
INSERT INTO aaz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ka ꞌroo-ꞌroo fa te, bi Elisabet naꞌapuꞌ. Onaim in ka npo-poi niit fa naꞌko sin umi tar antea funan niim. In naꞌuab am nak, “Pures-boꞌis neu Uisneno! Aijoo! Uisneno nakriraꞌ In nekan arekot neu kau. Karu au upein anah, biak ein ka namae kau fa goen.” ");
INSERT INTO aaz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Oras bi Elisabet in aupn ee naan funan nee te, Uisneno nreek In ameput naꞌko sonaf neno tunan nnao neu kuan es et propinsi Galilea. Kuan naan, kaan ee, Nasaret. Ameput naan, kaan ee naiꞌ Gabrial. ");
INSERT INTO aaz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anbi kuan Nasaret anmuiꞌ riꞌ feot ao-ꞌtemef es, kaan ee bi Maria. Bi Maria anmanaaꞌ nok atoin es, kaan ee naiꞌ Yusuf. Naiꞌ Yusuf reꞌ naan, Usif naiꞌ Daut in sufan-kaꞌun. On nai te, naiꞌ Gabrial annao ma nateef nok bi noon Maria. ");
INSERT INTO aaz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","In nakriraꞌ in tuan ee neu bi nona naan am nak, “Hoore, tua! Uisneno anpiir ma nbeit naan ko, he nmoeꞌ naan kuun rais reok goes neu ko. Uisneno nok ko, Maria.” ");
INSERT INTO aaz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anneen on naan ate, bi Maria ntakaꞌnanaꞌ, natuin ameput naan in uaban. In ka nahiin fa in aꞌmoufn ii saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Onaim ameput naan antuut antein am nak, “Maria! Kais mumtau. Fin Uisneno In sairt ii, nakriraꞌ In nekan arekot neu ko. ");
INSERT INTO aaz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka ꞌroo fa te, ho of muꞌapuꞌ, rarit ho of muhoniꞌ maan riꞌaan moen jes. Ho ro he mukaanb Ee, Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","In of anjair Atoin aꞌnaet. Uisneno of anteek Ee mnak, ‘In reꞌ naan, Au Aanh aa kuuk.’ Es reꞌ, Anah naꞌko Uisneno reꞌ Aꞌraat Reꞌuf. Uisneno of nanaib Ee he nnaaꞌ aprenat, nahuum on reꞌ In beif-naꞌif usif naiꞌ Daut. ");
INSERT INTO aaz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","In of es reꞌ annaaꞌ aprenat piut-piut neu too Israelas sin. Ma In aprenat naan nabar-baar.” ");
INSERT INTO aaz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mes bi Maria nataan naiꞌ Gabrial am nak, “Au ka ꞌtuu-tuup ꞌiit fa feꞌ ꞌok atoniꞌ! Onaim au he uꞌapuꞌ on mee?” ");
INSERT INTO aaz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rarit naiꞌ Gabrial nataah am nak, “On nai! Uisneno In Asmaan Akniunꞌ ee of neem neu ko. Ma Uisneno Aꞌraat Reꞌuf In kuasan naan of anniup naan ko. Nok ranan naan, Riꞌanaꞌ reꞌ of ho muhoniꞌ maan Ee naan, kninuꞌ batuur-batuur, natuin In reꞌ naan, Uisneno In Anah. ");
INSERT INTO aaz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kais amsanmaak! Ho nonot-asar es, kaan ee bi Elisabet, naꞌapuꞌ nrari msaꞌ. Te kaah, in namnasi nrair. Onaim biak ein nak, in ka bisa nahoniꞌ fa. Mes oras ia, in naꞌapuꞌ funan nee jen. ");
INSERT INTO aaz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anbi Uisneno te, saaꞌ-saaꞌ ii bisa njair!” ");
INSERT INTO aaz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Rarit bi Maria nataah am nak, “Reko, tua. Au reꞌ ia Uisneno in ate kau, tua. Maut he areꞌ saaꞌ-saaꞌ naan najairb ok natuin ho uabam naan. Au ubarab au tuak ii, he utuin ahaa Uisneno in romin, tua.” Rarit ameput sonaf neno tunan naan, nasaitan bi Maria. ");
INSERT INTO aaz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ankoon neno fauk ate, bi Maria naen rabah naꞌko Nasaret neu naiꞌ Sakarias in kuan et aꞌtoeꞌf ein propinsi Yudea. Antea nee te, in ntaam neu naiꞌ Sakarias in umi. Onaim in nasee ma ntaeb bi Elisabet. ");
INSERT INTO aaz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Oras bi Elisabet anneen bi Maria in haan buseet naan, riꞌanaꞌ reꞌ et bi Elisabet in aupn ee, natiik. Ma Uisneno In Asmaan Akniunꞌ ee neem ma ntaam neu bi Elisabet in tuan. ");
INSERT INTO aaz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Rarit in naꞌuab naher-heer am nak, “Maria! Mansian ein of nait naꞌratan ho kanam naan, anneis naꞌko areꞌ kanan bifee pah-pinan ia! Sin of nait naꞌratan Riꞌanaꞌ reꞌ et ho aupm aan! ");
INSERT INTO aaz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au tuak ii msaꞌ nanaib on, natuin au Usiꞌ In ainf ii neem nateef nok kau. ");
INSERT INTO aaz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ho maan musee te, riꞌanaꞌ reꞌ au uꞌaup ee ia, natiik, natuin in nmariin. ");
INSERT INTO aaz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Uisneno nakriraꞌ nrair In nekan arekot neu ko, natuin ho mpirsai mmak, In nroim he nmoeꞌ natuin In rais manbaꞌan.” ");
INSERT INTO aaz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bi Maria nmurai naꞌuab am nak, “Naꞌko au nekak nanan ia, au ꞌtunaꞌ uꞌratan Uisneno! ");
INSERT INTO aaz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au neek ii nmariin, natuin Uisneno nsoi nafetin naan kau! ");
INSERT INTO aaz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","In nkius ma ntae narek-rekoꞌ nrair kau, In aan renuꞌ-aan rekaꞌ reꞌ ka maꞌosaꞌ fa ia. Anmurai oras ia, areꞌ mansian ein of naꞌuab ein ma nteek kau, bifee reꞌ nꞌua reok reꞌuf kau, ");
INSERT INTO aaz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","natuin Uisneno nmoeꞌ rais sanmakat humaꞌ-humaꞌ neu kau. In imsaꞌ, Akuaas Reꞌuf ma Kniun Reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Uisneno nakriraꞌ ma natoon rais kasian neu areꞌ too mfaun reꞌ anhormaat ma naꞌbees neu Ne, naꞌko batan neu batan. ");
INSERT INTO aaz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In npaek In kuasan, he ntaisibub tuaf-tuaf reꞌ naꞌnaeb ma naikas sin tuak ein. ");
INSERT INTO aaz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In namouf tuaf-tuaf reꞌ annaꞌan kuasa, natuin sin nabeꞌon ma npaas ok. Mes In nanaib tuaf-tuaf reꞌ neek ein maꞌnuraꞌ ma ba-baun ein. ");
INSERT INTO aaz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In nhao ma nfait amnaahs ein tar antea namsenan, mes In nriuꞌ napoitan atoin amuiꞌt ein, he sin npoin naon, ka npooh neikin fa saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","In nturun ma nbaab In too Israelas sin, ma nakriraꞌ In rais kasian neu sin piut-piut. ");
INSERT INTO aaz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Unuꞌ te, In nahakeꞌ rais manbaꞌan nok hit beꞌi-naꞌi sin, es reꞌ, kaꞌo Abraham ma in sufan-kauꞌn ein ok-okeꞌ. Oras ia, rais manbaꞌan naan nmafutuꞌ ma nhaek nabar-baar.” ");
INSERT INTO aaz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naꞌuab anrair on naan ate, bi Maria natua nok bi Elisabet funan teun feꞌ. Rarit naꞌ in nfain neu kuan Nasaret. ");
INSERT INTO aaz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Antea in oors aa on naan ate, bi Elisabet nahoniꞌ naan riꞌaan moen jes. ");
INSERT INTO aaz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rasi naan nasiin on ma nabeon on neu in nonot-asar ma kuan naan in nanan, nak Uisneno nakriraꞌ nrair In nekan arekot neu bi Elisabet, es naan ate In nfee ne riꞌanaꞌ. Onaim sin ar-arsin anmarinan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Riꞌanaꞌ naan anmoin naan neno fanu te, sin naꞌheir ee natuin atoran harat atoin Yahudis. Sin he nakanab riꞌanaꞌ naan, naiꞌ Sakarias, on reꞌ in aamf ee kanan. ");
INSERT INTO aaz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mes in ainf ee npeen mates nak, “Ka on fa naan, tua! In kaan ee, ro he naiꞌ Yohanis!” ");
INSERT INTO aaz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mes sin nataah ee mnak, “Nansaaꞌ am es ho mpiir kanaf Yohanis? Ka tiit tain fa tuaf es naꞌko hi nonot-asar reꞌ anpaek kanaf naan!” ");
INSERT INTO aaz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Onaim sin nsenen naiꞌ Sakarias he nahiin in romin, he nakanab riꞌanaꞌ naan nak sekau. ");
INSERT INTO aaz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naiꞌ Sakarias ansenen sin he ntoit hau benaꞌ he ntui. Rarit sin nnoon ee hau benaꞌ. Onaim in ntui mnak, “In kaan ee naiꞌ Yohanis!” Onaim too mfaun ein ansanmakan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nok askeken ate, naiꞌ Sakarias in maan amates naan nakberoꞌ. Onaim in nsii ma nboꞌis naꞌnaeb Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tuaf-tuaf reꞌ natuan nbin bare naan, ansanmakan ma namtaun amsaꞌ. Onaim rasi naan nasiin on ma nabeon on naꞌko tuaf neu tuaf, tar antea abitan propinsi Yudea reꞌ natuan etan aꞌtoeꞌf ein nahinin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Areꞌ aneen rasi naan nateenb ein nak, “Naan batuur een, Uisneno In kuasan nok riꞌanaꞌ naan. In of naꞌnae neem ate, in taos-moꞌet on reꞌ mee?” ");
INSERT INTO aaz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Rarit Uisneno In Asmaan Akniunꞌ ee neem ma ntaam nbi naiꞌ Sakarias in tuan. Onaim in naꞌuab am nak, ");
INSERT INTO aaz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pures-boꞌis neu Uisneno, too Israelas sin Usif! Natuin In nkoen On neem he nsoi naan In tuaf ein, maut he sin kais on reꞌ ate. ");
INSERT INTO aaz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uisneno nait ma nanaib Tuaf es, reꞌ In kuaasn ee maꞌtaniꞌ, he nsoi nafetin kit. In reꞌ naan, usif naiꞌ Daut in sufan-kaꞌun. ");
INSERT INTO aaz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uisneno nbaꞌan nain rasi ia naꞌko afi unuꞌ, anpaek In mafeef akniunꞌ ein reꞌ naꞌkiꞌin neu Ne. ");
INSERT INTO aaz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Oras ia, In he nsoi nafetin kit, naꞌko hit muusn ein, ma naꞌko tuaf-tuaf reꞌ sin neek ein namenan neu kit. ");
INSERT INTO aaz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","In nakriraꞌ In nekan arekot neu hit beꞌi-naꞌi sin, natuin In namnau piut-piut neu In rais manbaꞌan nok sin, reꞌ In nfuut ma nahaek ee nok kaꞌo Abraham. ");
INSERT INTO aaz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In nsoi nafetin anrair kit naꞌko hit muusn ein, he hit bisa taꞌruriꞌ ma taꞌbees teu Ne, ma kais tamtau ttein. ");
INSERT INTO aaz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","In nsoi nafetin kit, he hit bisa tmoni kninuꞌ ma mneꞌo piut-piut atbi In human ma In matan. ");
INSERT INTO aaz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yohanis! Ho reꞌ ia, au aan hoin aa, ko. Tuaf of nahiin ko nak, ho reꞌ ia, Uisneno Aꞌraat Reꞌuf In mafefa kninuꞌ. Ho of amnao ma mutoon meu too mfaun ein, he sin npiraꞌ ma nnonaꞌ sin aꞌniimk ein he ntoup Usiꞌ In amneman. ");
INSERT INTO aaz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ho of amnao mukriraꞌ ma mutoon ranan meu Uisneno Iin na, he sin nahinin nak, sin napenin saok sanat ma ꞌhonis, natuin Uisneno nnoes ma nporin nain sin saant am penu sin. ");
INSERT INTO aaz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Natuin Uisneno neekn ee maꞌnuraꞌ ma nꞌoeteen neu kit, etun In nfee kit oras ma eti mainuan feꞌu, nahuum on reꞌ maan asaet-apisar reꞌ neik meꞌu ma piin feꞌu. Hit reꞌ abitan metan-meisꞌokan in nanan, ma hit reꞌ amtaus rais nitu-ꞌmaten kit, natuin hit ka taraem ok fa feꞌ tok Uisneno, of hit tapein paku ma meꞌu he nnao naat kit teu raan mamut ma rameꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naiꞌ Sakarias nboꞌis anrair Uisneno. Onaim naiꞌ Yohanis nmurai naꞌnae piut. Uisneno In Asmaan Akniunꞌ ee nhaꞌtain je piut. In naꞌnae neem on naan ate, in nnao natua nbi baer ruman naꞌroo naꞌko kuan, tar antea oras in nmurai nait in mepu neu too Israelas sin. ");
INSERT INTO aaz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Neot es, oras naiꞌ Kirenius naꞌnaak neu pah Siria, uis koꞌu keser, kaan ee naiꞌ Agustus, nakua kabin prenat nak, “Areꞌ too reꞌ anbin prenat Roma in pah, sin ar-arsin ro he nfanin on sin kuan ein meseꞌ-meseꞌ, he ntuin kanaf anbin sensus!” Sensus naan feꞌ no meseꞌ anbi prenat Roma, reꞌ antui ma nsoiꞌ too mfau-rutun naan. ");
INSERT INTO aaz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Onaim too mfaun ein anfanin neun sin kuan, he nok antuin kanaf anbin sensus naan. ");
INSERT INTO aaz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Oras naan, naiꞌ Yusuf natua nbi kuan Nasaret et propinsi Galilea. In nmanaaꞌ anrair nok bi noon es, kaan ee bi Maria, reꞌ naꞌapuꞌ. On nai te, naiꞌ Yusuf naan, usif naiꞌ Daut in sufan, onaim in ro he nfain neu naiꞌ Daut in kota Betlehem et propinsi Yudea, he naꞌ antui kanaf anbi sensus naan. Es naan ate, sin nua sin annaon neu kota Betlehem. ");
INSERT INTO aaz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Oras sin nbin Betlehem ate, bi Maria in oras he nahoin ii antea goen. ");
INSERT INTO aaz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mes anbi bare naan, sin ka napenin fa keꞌen anbi uim losmen sin. Onaim sin ntaman neu ooꞌf es. Rarit in nahonis in aan unu, riꞌ mone. Onaim sin ntainuus ee, ma natuup ee nbi muiꞌt ein sin bare mnahat. ");
INSERT INTO aaz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mabeꞌ naan, anmuiꞌ naan atuuk muꞌit fauk, reꞌ anbeꞌen ma ntiut sin aꞌbibin ma ꞌbib-kasen. Sin nbeꞌen anbin amneraꞌ nbi kota in kotin. ");
INSERT INTO aaz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nok askeken ate, sin niit Uisneno In ameupt es naꞌko sonaf neno tunan. Rarit anmuiꞌ snaaf naꞌko Uisneno ntanaꞌ natef-tefan sin, onaim sin namtau nmaten. ");
INSERT INTO aaz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mes ameput naan naꞌuab am nak, “Hi kais mimtau feꞌ! Amneen mirek-rekoꞌ, joo! Fin au ꞌuum he utoon ki rais reok goes. Sekau-sekau reꞌ anneen rasi ia, ro of anmarinan. ");
INSERT INTO aaz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rais reko ia nak on nai: Neno ia, anbi Betlehem, et usif naiꞌ Daut in kota naan, anmuiꞌ naan bifee jes nahoniꞌ nrair Kristus! Kristus naan, Tuaf reꞌ Uisneno nbaꞌan nain Je naꞌko afi unuꞌ. Uisneno nreek haefn Ee neem, he nsoi nafetin tuaf naꞌko sin saant am penu sin! In reꞌ ia, reꞌ of tuaf anteek Ee nak, ‘Usiꞌ’, fin areꞌ prenat, In es reꞌ annaaꞌ sin! ");
INSERT INTO aaz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hi of mihiin Je on nai: hi of miit Riꞌana kruuꞌf es, reꞌ antainuus naan Ee. In ntuup et muiꞌt ein sin bare mnahat.” ");
INSERT INTO aaz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ameput naan naꞌuab anrair on naan ate, nok askeken, Uisneno In ameput bian naꞌkon sonaf neno tunan neman namfa-faun ma nabuan nok ne. Onaim sin npures ma nboꞌis Uisneno neik siit am nak, ");
INSERT INTO aaz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hai mtunaꞌ ma miꞌratan Uisneno In kanan! In es reꞌ antook ma naprenat et neon goe tunan aꞌraat reꞌuf. Uisneno nroim he narameꞌ areꞌ mansian ein pah-pinan, reꞌ anharineb ma nhaan mau In nekan!” ");
INSERT INTO aaz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Rarit Uisneno In ameupt ein ntebin nfanin neun sonaf neno tunan. Onaim atuuks ein naan naꞌuab ein am nak, “Hoe! Iim he tnao teu Betlehem he tkius tiit Riꞌanaꞌ nee feꞌ! Fin Uisneno anfee nrair hanaf naan neu kit.” ");
INSERT INTO aaz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Rarit sin naenan rabah neun Betlehem. Onaim sin niit bi Maria ma naiꞌ Yusuf. Ma sin niit Riꞌana kruꞌuf naan amsaꞌ antuup et muiꞌt ein sin bare mnahat. ");
INSERT INTO aaz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oras sin niit Riꞌanaꞌ naan, sin nmurai naꞌuab ein am nak, “Feꞌe na Uisneno In ameupt ein neman naꞌkon sonaf neno tunan ma natoon kai anmatoom nok Riꞌanaꞌ reꞌ ia!” Onaim sin npeon rasi naan tar namsoup. ");
INSERT INTO aaz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Areꞌ tuaf amfaun ansanmakan oras sin nneen atuuks ein naan sin uab ein. ");
INSERT INTO aaz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mes bi Maria nahiik ma napaan sin anbin in nekan, areꞌ kanan rasi reꞌ anjarin naan. Ma in natenab ma namnau he naim niit nak, in aꞌmoufn ii saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Rarit atuuks ein naan antebi nfanin neun sin muiꞌt ein. Onaim sin npures ma nboꞌis Uisneno In kanan. Sin ntotin makasi neu Ne, natuin sin nnenan ma nitan natai on reꞌ saaꞌ reꞌ ameput Uisneno natoon ee jan. ");
INSERT INTO aaz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nahoniꞌ nrair neno faun on naan ate, sin naꞌheriꞌ Riꞌana kruꞌuf naan natuin kaꞌo Musa in atoran. Onaim in ainaf-amaf nakaanb Ee, ‘Naiꞌ Yesus’. Kanaf naan es reꞌ ameput naꞌko sonaf neno tunan natoon ee neu sin, oras In ainf ee ka naꞌaups Ee fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Anmuiꞌ atoran es naꞌko kaꞌo Musa nak, bifee reꞌ nahoniꞌ nrair neno boꞌ haa, ro he nnao nakninuꞌ in tuan nbi Uim Onen Uuf natuin atoran harat. Nok ranan naan, sin bisa ntaman neu uim onen on reꞌ natiꞌ te sin nmoꞌ-moeꞌ je ji. Etun naiꞌ Yusuf ma bi Maria nnaon neu kota Yerusalem he nmoeꞌ natuin atoran harat naan. Sin naskau neik Riꞌana kruꞌuf naan neu Uim Onen Uuf, he nanaaꞌt Ee njair Uisneno Iin ja. ");
INSERT INTO aaz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sin natuin Uisneno In atoran reꞌ nak, “Bifee reꞌ nahoniꞌ riꞌaan unu, karu mone te, in ro he nanaꞌat riꞌanaꞌ naan njair Uisneno Iin ja.” ");
INSERT INTO aaz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Natuin Uisneno In atoran, karu nanaꞌat riꞌanaꞌ naan neu Uisneno te, in mahoin ein ro he nfeen fuaꞌ-turuꞌ kor-kuku paasn es, aiꞌ kor-keif tipuꞌ nua. Etun naiꞌ Yusuf ma bi Maria nmoeꞌ natuin atoran naan. ");
INSERT INTO aaz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Oras naan, anmuꞌi ꞌnaef es, kaan ee naiꞌ Simeon, reꞌ natua nbi kota Yerusalem. In reꞌ naan, neek amneꞌo ma namnau Uisneno piut-piut. Uisneno In Asmaan Akniunꞌ ee natoon ee mnak, in of niit Kristus feꞌ, rarit naꞌ in nmaet. Kristus naan, of es reꞌ ansoi nafetin too Israelas sin. ");
INSERT INTO aaz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oras naan, Uisneno In Asmaan Akniunꞌ ee neik naiꞌ Simeon antaam neu Uim Onen Uuf. Oras in ntaam ate, in nateef nok Naiꞌ Yesus In ainaf-amaf sin neik Je, he nanaaꞌt Ee neu Uisneno he njair Iin ja. ");
INSERT INTO aaz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ankius Riꞌana naan ate, ꞌnaef Simeon antoup Goe ma naskau Goe. Rarit in npures ma nanaib Uisneno mnak, ");
INSERT INTO aaz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pures-boꞌis neu Uisneno! Uisneno nmoeꞌ ma ntao nrair natuin In rais manbaꞌan neu kau. Onaim oras ia, Uisneno bisa nfee kau oras ma eti mainuan, he reko te, au ꞌmaet kuuk nai ꞌbi mamut-aominaꞌ, ");
INSERT INTO aaz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","fin au ꞌiit urair Tuaf reꞌ Uisneno nreek haefn Ee neem, he nsoi nafetin kit naꞌko hit saant am penu sin! ");
INSERT INTO aaz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Uisneno anroim he npaek Riꞌanaꞌ reꞌ ia, he nsoi nafetin uuf-uuf ma pah-pah sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","In on reꞌ snaa pinaꞌ, reꞌ neik rais hormaat ma baisenut neu Uisneno In too pah Israelas sin. In on reꞌ meꞌu makrahaꞌ, reꞌ ntanaꞌ ma naruruꞌ Uisneno In ranan, neu areꞌ uuf-uuf ma pah-pah bian sin.” ");
INSERT INTO aaz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Annenan on naan ate, naiꞌ Yusuf ma bi Maria feefk ein nomkakan, natuin naiꞌ Simeon in uab ein naan reꞌ anmatoom nok Riꞌanaꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Rarit naiꞌ Simeon naꞌuab anfee tetus neu sin. Onaim in naꞌuab neu bi Maria mnak, “Yesus ainaf! Of too Israelas sin antorak ho Anah reꞌ ia. Mes sin ꞌmoeꞌt ein neu Na jan, of namouf nafaniꞌ sin. Ho Anah reꞌ ia, of anmoeꞌ tuaf-tuaf amfaun sin neek ein anmarinan. ");
INSERT INTO aaz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nok ranan naan, Uisneno of anpukai napoitan too mfaun ein sin neek ein. Mes ho, Maria, ho of amnaben miit maꞌnukaꞌ ka aanꞌ-anaꞌ fa, nahuum on reꞌ suin ee napau ho ansaom naan.” ");
INSERT INTO aaz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Anmuiꞌ bifee mnais es anbi Uim Onen Uuf naan, kaan ee bi Hana. In nmoin naan toon boꞌ fanu mhaa (84) goen. In aamf ee, kaan ee naiꞌ Fanual naꞌko uuf naiꞌ Aser. In nmatsao naan toon hitu te, moen je nmate nporin. Beꞌi bi Hana reꞌ naan, Uisneno In mafefa kninuꞌ. In meup goe, es reꞌ anꞌonen ma nanaah on anbi Uim Onen Uuf fai-manas. ");
INSERT INTO aaz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oras naiꞌ Simeon naꞌuab neu naiꞌ Yusuf ma bi Maria te, bifee mnasiꞌ naan neem anpaumak-maak. In anneen amsaꞌ sin naꞌuab ein naan, rarit in npures Uisneno. Onaim in naꞌuab anmatoom nok Naiꞌ Yesus neu tuaf-tuaf amfaun reꞌ anpa-pao Usif reꞌ Uisneno nbaꞌan he nreek haefn Ee neem he nsoi nafetin too Israelas. ");
INSERT INTO aaz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oras naiꞌ Yusuf ma bi Maria nmoꞌen nrarin natuin kaꞌo Musa in atoorn ein ok-okeꞌ nbi kota Yerusalem ate, sin ntebin nfanin neun propinsi Galilea, neu sin kuan Nasaret. ");
INSERT INTO aaz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naiꞌ Yesus naꞌnae, naꞌbeiꞌ, anmanoe, ma nahiin rasi mfaun. Uisneno nakriraꞌ In nekan arekot neu Ne msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Toon-toon ate, naiꞌ Yusuf ma bi Maria nnaon neu kota Yerusalem he nokan nbin fesat Paska. ");
INSERT INTO aaz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Neot es, oras Naiꞌ Yesus anmoin naan toon boꞌes am nua, sin nnaon buꞌ-buaꞌ neun Yerusalem he nokan anbin fesat Paska on reꞌ natiꞌ te, sin nmoꞌe. ");
INSERT INTO aaz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Oras neon fesat Paska sin oekꞌ ein, naiꞌ Yusuf ma bi Maria anfanin neun kuan Nasaret. Sin nnaon buꞌ-buaꞌ nok too mfaun ein reꞌ he nfanin neun Galilea. Mes sin ka nahinin fa nak, Naiꞌ Yesus namaik et Yerusalem. Sin nak of oniꞌ In nnao nok In partein ngguin. Mes oras maans ee nmouf, sin ka niit Ee fa. Onaim sin nmurai namin neu-mneman. Sin natanan neu sin nonot-asar sin ma sin partein ngguin. ");
INSERT INTO aaz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mes natuin sin ka niit aiꞌ nateef Ee fa, sin ntebi nfanin neun Yerusalem, he naim Je nbi nee. ");
INSERT INTO aaz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Antean nee te, sin naim Je neu-mneman tar antea neno teun, naꞌ sin niit Ee nbi Uim Onen Uuf ee In nanan. In ntoko ma nmakoin ein penit ma nmaktan-taan ein nok tunggur agama Yahudi sin. ");
INSERT INTO aaz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Too mfaun ein reꞌ annenan sin reꞌ naan, anmasahun, natuin In nahiin batuur-batuur Uisneno In Suur Akniunꞌ ee In afan. Ma In nataah nahiin haan taans ein nok reko msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ankius nitan on naan ate, in ainaf-amaf sin ansanmakan. Rarit In ainf ee nak, “Yesus! Nansaaꞌ am es Ho mususab kai on reꞌ ia? Hai nua kai Ho amaꞌ mfuun mitef-tefan bare-bare mbi ranan ma mbi kota reꞌ ia. Hai mtakaꞌnanaꞌ neu reꞌ hai he miit Ko mbi mee!” ");
INSERT INTO aaz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mes Naiꞌ Yesus nataah am nak, “Nansaaꞌ am es hi msusa mmaet he maim Kau? Hi mihini, oo? Au ꞌmuiꞌ urusan et Au Amaꞌ In Umi.” ");
INSERT INTO aaz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mes sin ka nahinin reko fa neu In sairt ii saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Rarit sin ntebin nfanin neun kuan Nasaret. Naiꞌ Yesus natuin In ainaf-amaf sin aprenat. Onaim In ainf ee nahiik ma napaan rasin naan ok-okeꞌ nbi in nekan. ");
INSERT INTO aaz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Onaim Naiꞌ Yesus naꞌnae piut, In mahinif ma manoef naꞌbaab on piut. Uisneno ma mansian sin arsin anneek Ee. ");
INSERT INTO aaz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Oras naan, naiꞌ Tiberius anjair uis koꞌu keser ma nnaaꞌ aprenat anbi pah Roma toon boꞌes am niim een. Naiꞌ Pontius Pilatus anjair gubernur anbi propinsi Yudea. Naiꞌ Herodes anjair gubernur anbi propinsi Galilea. Naiꞌ Herodes tataf naiꞌ Felipus, anjair gubernur anbi propinsi Iturea ma propinsi Trakonitis. Ma naiꞌ Lisanias anjair gubernur anbi propinsi Abilene. Oras naan amsaꞌ, naiꞌ Hanas ma naiꞌ Kayafas anjarin aꞌnaak rais pirsait Yahudi sin aꞌnaak koꞌu nbi kota Yerusalem. Oras naan, naiꞌ Yohanis, naiꞌ Sakarias in anah, natua nbi baer ruman naꞌroo naꞌko kuan. Anbi bare naan, Uisneno naꞌuab ma nbaasn ee. ");
INSERT INTO aaz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anneen anrair on naan ate, naiꞌ Yohanis antaam neu areꞌ kuan-kuan reꞌ anpaumaak noe Yarden, ma natoon neu abitan naan am nak, “Hi ro he mmanakuꞌ ma misaitan hi saant ein ok-okeꞌ, he Uisneno annoes nain sin. Rarit hi ro he misrain feꞌ, he njair tanar nak hi mmarameꞌ mfain mok Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Un-unuꞌ te, Uisneno In mafefa kninuꞌ kaꞌo Yesaya antui anmatoom nok naiꞌ Yohanis reꞌ ia mnak, “Anmuiꞌ tuaf reꞌ of annao neu bare reꞌ ka matuaꞌ fa, rarit anhunun ma nkoaꞌ am nak, ‘Areꞌ too mfaun ein ro he mibarab ma miroitan ranan, he mseun ma mtoup Usiꞌ In amneman! Mikninuꞌ ranan he mseun Goe. ");
INSERT INTO aaz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amkuub ma mnae mineer kefan ma kobaꞌif. Amnae ma mhain mineer aꞌtoeꞌf ein. Mineo ma minoon raan apeunt am abeot ein, Amhaꞌeik raan kobaꞌif ma faut putuk. ");
INSERT INTO aaz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Maut he tuaf-tuaf naꞌko uuf-uuf ma pah-pah, bisa nahinin nak, Uisneno nroim he nsoi nafetin mansian naꞌko sin saant am penu sin.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Too mfaun neman naꞌkon mee-mee, ma ntoit naiꞌ Yohanis he nasrain sin. Mes in naskaraꞌ sin im nak, “Hoe, aputa-kriu maufinu ki! Hi on reꞌ kaun araut aan! Hi kais mitenab mak, hi miꞌpiis mipo-poi he hi bisa msoi maan om miꞌko Uisneno In hukun! Kahaf! Ka ꞌroo fa te, Uisneno nasanut hukun neu tuaf-tuaf reꞌ naꞌpiis napo-poi jah! ");
INSERT INTO aaz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hit tahiin tak kaꞌo Abraham naan, Uisneno in partei. Mes hi kais mitenab am mak, ‘Au ka upein fa hukun, natuin au reꞌ ia kaꞌo Abraham in sufan.’ Hi mipein rasi naan naꞌko mee? Naan ka bisa nturun ki fa. Natuin rasi naan ka nmoeꞌ ki fa he mjair atoin neek amneꞌo. Uisneno bisa nmoeꞌ fatun reꞌ ia njarin kaꞌo Abraham in sufan. Au utoon ki, hee! Mikriraꞌ mbi hi ꞌmoinm ein naan nai, mak hi mnao misaitan hi saant ein ee jen, ma mfain iim mituin Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hi ro he mmoeꞌ rais reko. Kaah fa te, Uisneno In hukun maꞌfeen ee nmouf neu ki on reꞌ atoniꞌ npaek fani he nnooꞌ hau naꞌko in aꞌbaꞌan. On reꞌ naan, tua! Roet ii ka mapakeꞌ fa, karu ka nmuiꞌ fa in fuaf arekot! Onaim reko nneis amnooꞌ goe, rarit tout goe he nputu nmaet.” ");
INSERT INTO aaz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Rarit too mfaun ein nataan naiꞌ Yohanis am nak, “Onaim hai he mmoeꞌ on mee?” ");
INSERT INTO aaz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","On nai te, in nataah sin im nak, “Karu ho mmuiꞌ baru nua, nfee es meu tuaf reꞌ ka nmuiꞌ fa baru. Karu ho mmuꞌi mnahat, mbait meu tuaf reꞌ ka nmuiꞌ fa mnahat.” ");
INSERT INTO aaz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Rarit ahoik beon guin neman ma ntoit naiꞌ Yohanis he nasrain sin. Sin natanan am nak, “Aam tungguru! Hai he mmoeꞌ on mee?” ");
INSERT INTO aaz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","In nataah am nak, “Hi roim ein es reꞌ mputa-kriu. Mes nmurai oras ia, hi ro he mmeup nok neek amneot. Kais ambeos beo nneis-neis naꞌko preent ii in atoran. Maut he too gui nbaen ein beos beo natai nok atoran.” ");
INSERT INTO aaz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sorarus fauk anbin naan amsaꞌ. Sin nataan naiꞌ Yohanis am nak, “Karu hai te, on mee? Hai ro he mmoeꞌ on mee?” Rarit in nataah sin im nak, “Kais amhoik biak ein sin roit ein mituin hi roim ein naan. Kais amtuꞌiran biak ein tafiꞌ-tafiꞌ. Hi ro he misaeb sukuur ma minokab hi teenb ein nok ahaa hi kai ngguin naan.” ");
INSERT INTO aaz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Anneen in uab ein naan ate, too mfaun ein anmakaꞌin ma naꞌseꞌ-seoꞌ guin am nak, “Hae! Kais-kaisaꞌ naiꞌ Yohanis reꞌ ia, Kristus, reꞌ Uisneno nbaꞌan he nreek Ee neem naꞌko unuꞌ naan, oo!” ");
INSERT INTO aaz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mes naiꞌ Yohanis nakain sin im nak, “Amneen mirek-rekoꞌ! Anmuiꞌ tuaf es, reꞌ maꞌtaniꞌ nneis naꞌko kau of he neem. Maski au ꞌjari haa in aan renuꞌ msaꞌ, au ka umnees ꞌok Ne fa. Au suma bisa usrani haa ki ꞌpaek oe, mes In of anmoꞌe nneis naꞌko kau, natuin In naheun hi neekm ein nok Uisneno In Asmaan Akninuꞌ. In of nakninuꞌ ki, on reꞌ ttoutuꞌ nunuꞌ npaek ai. ");
INSERT INTO aaz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In nhukun tuaf reꞌ anmoꞌe nsaan, nahuum on reꞌ atoin tani reꞌ anpaek anin he natpeneb makaꞌ taum. Rarit in napaan makaꞌ anbi ꞌponi, mes nout nakratiꞌ maak taꞌuk ma maak apaꞌ. On naan amsaꞌ Kristus of anhukun tuaf-tuaf reꞌ anmoꞌen sanat, ma nait inporin sin neu ai mararaꞌ abar-barat.” ");
INSERT INTO aaz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nok ranan naan, naiꞌ Yohanis namnaub too mfaun ein nok rasi humaꞌ-humaꞌ, ma natoon Uisneno In Rais Reko neu sin. ");
INSERT INTO aaz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Oras naan, naiꞌ Yohanis anmurai naꞌuab maat-maat anmatoom nok naiꞌ Herodes in aꞌmoꞌen. In rais ji on nai: naiꞌ Herodes naan, gubernur et propinsi Galilea. In saant ein naꞌtupu nsae. Es, es reꞌ in nheer naan in oirf ee fee, kaan ee bi Herodias. Te kaah, in oirf ee anmoin feꞌ, ma ka nporin fa in fee bi Herodias fa feꞌ. Naiꞌ Herodes in aꞌmonin reꞌ ka batuur fa naan, anmoeꞌ naiꞌ Yohanis nakain ee maat-maat, tar naiꞌ Herodes anrenan. Rarit naiꞌ Herodes anheek naiꞌ Yohanis, ma nataam ee nbi bui. ");
INSERT INTO aaz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Unuꞌ te, oras sin ka nheek fa naiꞌ Yohanis fa feꞌ, in nasrain too mfaun. Ma in nasrain Naiꞌ Yesus amsaꞌ. Rarit Naiꞌ Yesus anꞌonen, onaim neon goe natfeꞌi. ");
INSERT INTO aaz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Rarit Uisneno In Asmaan Akniunꞌ ee nsaun neem neu Ne. Asmaan Akninuꞌ naan In maasn ee nahuum on reꞌ kor-kefi. Onaim anmuiꞌ hanaf naꞌko neon goe mnak, “Ho reꞌ ia, Au Aan nekaꞌ. Ho mmoeꞌ Au nekak ia, nmariin piut.” ");
INSERT INTO aaz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Oras Naiꞌ Yesus anmurai natoon neu too mfaun ein anmatoom nok Uisneno In ranan, In oniꞌ anmoin naan toon boꞌ teun goen. Tuaf amfaun nahinin nak, Naiꞌ Yesus naan, naiꞌ Yusuf in Anah. Naiꞌ Yusuf in uuf ein, on nai: Naiꞌ Yusuf in aamf ee, naiꞌ Eli. ");
INSERT INTO aaz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Naiꞌ Eli in aamf ee, naiꞌ Matat. Naiꞌ Matat in aamf ee, naiꞌ Lewi. Naiꞌ Lewi in aamf ee, naiꞌ Melki. Naꞌ Melki in aamf ee, naiꞌ Yanai. Naiꞌ Yanai in aamf ee, naiꞌ Yusuf. ");
INSERT INTO aaz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Naiꞌ Yusuf in aamf ee, naiꞌ Matatias. Naiꞌ Matatias in aamf ee, naiꞌ Amos. Naiꞌ Amos in aamf ee, naiꞌ Nahum. Naiꞌ Nahum in aamf ee, naiꞌ Hesli. Naiꞌ Hesli in aamf ee, naiꞌ Nagai. ");
INSERT INTO aaz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naiꞌ Nagai in aamf ee, naiꞌ Maat. Naiꞌ Maat in aamf ee, naiꞌ Matatias. Naiꞌ Matatias in aamf ee, naiꞌ Semein. Naiꞌ Semein in aamf ee, naiꞌ Yosek. Naiꞌ Yosek in aamf ee, naiꞌ Yoda. ");
INSERT INTO aaz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Naiꞌ Yoda in aamf ee, naiꞌ Yohanan. Naiꞌ Yohanan in aamf ee, naiꞌ Resa. Naiꞌ Resa in aamf ee, naiꞌ Serubabel. Naiꞌ Serubabel in aamf ee, naiꞌ Seltiel, Naiꞌ Seltiel in aamf ee, naiꞌ Neri. ");
INSERT INTO aaz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Naiꞌ Neri in aamf ee, naiꞌ Melki. Naiꞌ Melki in aamf ee, naiꞌ Adi. Naiꞌ Adi in aamf ee, naiꞌ Kosam. Naiꞌ Kosam in aamf ee, naiꞌ Elmadam. Naiꞌ Elmadam in aamf ee, naiꞌ Er. ");
INSERT INTO aaz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Naiꞌ Er in aamf ee, naiꞌ Yosua. Naiꞌ Yosua in aamf ee, naiꞌ Eliaser. Naiꞌ Eliaser in aamf ee, naiꞌ Yorim. Naiꞌ Yorim in aamf ee, naiꞌ Matat. Naiꞌ Matat in aamf ee, naiꞌ Lewi. ");
INSERT INTO aaz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Naiꞌ Lewi in aamf ee, naiꞌ Simeon. Naiꞌ Simeon in aamf ee, naiꞌ Yahuda. Naiꞌ Yahuda in aamf ee, naiꞌ Yusuf. Naiꞌ Yusuf in aamf ee, naiꞌ Yonam. Naiꞌ Yonam in aamf ee, naiꞌ Elyakim. ");
INSERT INTO aaz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Naiꞌ Elyakim in aamf ee, naiꞌ Melea. Naiꞌ Melea in aamf ee, naiꞌ Mena. Naiꞌ Mena in aamf ee, naiꞌ Matata. Naiꞌ Matata in aamf ee, naiꞌ Natan. Naiꞌ Natan in aamf ee, naiꞌ Daut. ");
INSERT INTO aaz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Naiꞌ Daut in aamf ee, naiꞌ Isai. Naiꞌ Isai in aamf ee, naiꞌ Obet. Naiꞌ Obet in aamf ee, naiꞌ Boꞌas. Naiꞌ Boꞌas in aamf ee, naiꞌ Soleman. Naiꞌ Soleman in aamf ee, naiꞌ Nahason. ");
INSERT INTO aaz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naiꞌ Nahason in aamf ee, naiꞌ Aminadap. Naiꞌ Aminadap in aamf ee, naiꞌ Atmin. Naiꞌ Atmin in aamf ee, naiꞌ Arni. Naiꞌ Arni in aamf ee, naiꞌ Hesron. Naiꞌ Hesron in aamf ee, naiꞌ Peres. Naiꞌ Peres in aamf ee, naiꞌ Yahuda. ");
INSERT INTO aaz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Naiꞌ Yahuda in aamf ee, naiꞌ Yakop. Naiꞌ Yakop in aamf ee, naiꞌ Isak. Naiꞌ Isak in aamf ee, naiꞌ Abraham. Naiꞌ Abraham in aamf ee, naiꞌ Tera. Naiꞌ Tera in aamf ee, naiꞌ Nahor. ");
INSERT INTO aaz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naiꞌ Nahor in aamf ee, naiꞌ Seruk. Naiꞌ Seruk in aamf ee, naiꞌ Rehu. Naiꞌ Rehu in aamf ee, naiꞌ Pelek. Naiꞌ Pelek in aamf ee, naiꞌ Eber. Naiꞌ Eber in aamf ee, naiꞌ Sela. ");
INSERT INTO aaz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Naiꞌ Sela in aamf ee, naiꞌ Kenan. Naiꞌ Kenan in aamf ee, naiꞌ Arpaksat. Naiꞌ Arpaksat in aamf ee, naiꞌ Sem. Naiꞌ Sem in aamf ee, naiꞌ Noh. Naiꞌ Noh in aamf ee, naiꞌ Lamek. ");
INSERT INTO aaz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Naiꞌ Lamek in aamf ee, naiꞌ Metusalak. Naiꞌ Metusalak in aamf ee, naiꞌ Hanok. Naiꞌ Hanok in aamf ee, naiꞌ Yaret. Naiꞌ Yaret in aamf ee, naiꞌ Maharael. Naiꞌ Maharael in aamf ee, naiꞌ Kenan. ");
INSERT INTO aaz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Naiꞌ Kenan in aamf ee, naiꞌ Enos. Naiꞌ Enos in aamf ee, naiꞌ Set. Naiꞌ Set in aamf ee, naiꞌ Adam. Naiꞌ Adam naan, Uisneno neikn On es anmoꞌe. ");
INSERT INTO aaz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oras naiꞌ Yohanis nasrani nrair Naiꞌ Yesus ate, Naiꞌ Yesus annao nasaitan noe Yarden. Uisneno In Asmaan Akniunꞌ ee nok Ne. Rarit Asmaan Akniunꞌ ee neik Je neu baer ruman naꞌroo naꞌko kuan. ");
INSERT INTO aaz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Naiꞌ Yesus natua nbi bare naan, ntea neno boꞌ haa. Oras naan, In ka nbukae niit fa saaꞌ-saaꞌ, tar antea In namnaah anmaet. Rarit niut reuꞌf ein sin aꞌnaakt ee neem he nakreo nsobaꞌ Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","In naꞌuab nakreo nsobaꞌ neu Naiꞌ Yesus am nak, “Karu batuur-batuur Uisneno In Aanh aa Ko, Ho mmuiꞌ kuasa. Onaim muꞌuab meu fatun reꞌ ia, he njarin utunuꞌ, he Ho bisa muah sin.” ");
INSERT INTO aaz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mes Naiꞌ Yesus nataah am nak, “Ho roim aan in reokn ii kaah een! Ho ka muhiin fa, oo? Matuꞌi et Uisneno In Suur Akninuꞌ mnak, ‘Mansian ii ka nmoin fa arahaa naꞌko mnahat!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Rarit aꞌnaak nitu naan neik Naiꞌ Yesus neu baer aꞌratas, ma nakriraꞌ neu Ne areꞌ prenat pah-pinan ia no mes-meseꞌ nok nain sin pinaꞌ ma krahaꞌ sin ok-okeꞌ. Rarit in nfuriꞌ Naiꞌ Yesus am nak, “Areꞌ pareent ein sin kuasa naan, au ngguin ok-okeꞌ! On naan amsaꞌ sin pinaꞌ ma krahaꞌ sin! Onaim au ꞌmuiꞌ hak he ꞌnonaꞌ ꞌeu sekau-sekau goah reꞌ au ꞌromi. ");
INSERT INTO aaz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Au ꞌroim he ꞌfee sin neu Ko. Suma Ho ro he mmoeꞌ maan rais jes, he naꞌ au ꞌnonaꞌ Ko goe. Maꞌkafaꞌ! Muꞌbees meu kau. Es ahaa reꞌ naan, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mes Naiꞌ Yesus nataah ee mnak, “Ho mupein rasi naan muꞌko mee? Anbi Uisneno In Suur Akniunꞌ ee matuꞌi mnak, ‘Ho ro he muꞌbees meu Uisneno nmees. Ma ho ro he mtuthae kuum Ee.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Rarit aꞌnaak nitu naan neik Naiꞌ Yesus antaam neu kota Yerusalem. Anbi naan, in nasaeb Naiꞌ Yesus anbi Uim Onen Uuf ee in aꞌpupun. Rarit in naꞌuab am nak, “Karu Ho batuur-batuur Uisneno In Anah, mumoufut Ho tuam aan nai! ");
INSERT INTO aaz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Fin matuꞌi et Uisneno In Suur Akniunꞌ ee mnak, ‘Uisneno of anreun In ameupt ein naꞌkon sonaf neno tunan, he npafaꞌ ma npanat Ko. ");
INSERT INTO aaz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Sin of natnaat Ko, maut he Ho haem ein kais nasbeut fatu kreꞌ-reꞌo msaꞌ.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mes Naiꞌ Yesus nataah am nak, “Kais muꞌkakeꞌ Kau. Fin matuꞌi et Uisneno In Suur Akniunꞌ ee mnak, ‘Kais amsobaꞌ Uisneno!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aꞌnaak nitu naan ansobaꞌ Naiꞌ Yesus npaek ranan humaꞌ-humaꞌ, mes ka niis Ee fa. Rarit In nnao nasaitan Naiꞌ Yesus he npao ntein oras bian. ");
INSERT INTO aaz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Rarit Naiꞌ Yesus anfani ntein on propinsi Galilea, fin Uisneno In Asmaan Akniunꞌ ee nfee Ne kuasa. Ka ꞌroo fa te, Naiꞌ Yesus In kaan ee nmurai matekaꞌ nbi abitan pah reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","In nanoniꞌ nbi atoin Yahudis sin uim oen ein anbin mee-mee. Onaim too mfaun ein anboiꞌs Ee mnak, “Naiꞌ Yesus naan, atoin maꞌtaniꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Neot es, Naiꞌ Yesus neem anbi In kuan Nasaret. Nateef nok atoin Yahudis sin neon onen, reꞌ sin nteek ee te, ‘neon Sabat’, In ntaam neu uim onen, on reꞌ natiꞌ te In nmoꞌe. Rarit In nhaek he nrees naꞌko Uisneno In Suur Akninuꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Onaim sin naꞌnaaꞌt Ee kaꞌo Yesaya in tuis. In nfei, he naim resat, onaim In nrees nak, ");
INSERT INTO aaz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kuasat naꞌko Uisneno In Asmaan ee, et Au. Etun In nruur ma nreek Kau, he utoon Uisneno In Rais Reko ꞌeu atoin kasian ein. In nreek haefan nrair Kau. he utoon am ꞌak, abitan bui je, of npoin mainuan; afoort ein, of bisa niit anfanin; tuaf-tuaf reꞌ napenin haꞌmuꞌit, of anmonin nbin mainuan. ");
INSERT INTO aaz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Fin oras ia, Uisneno In oors ii ntea goen, he nsoi nafetin Iin na.” ");
INSERT INTO aaz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Anrees anrair tuis naan ate, Naiꞌ Yesus annuun goe ma nnonaꞌ nafainꞌ ee neu ameup ibadat, rarit In ntook. Abitan uim onen naan ok-okeꞌ ankius Goe piut. ");
INSERT INTO aaz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Rarit In naꞌuab neu sin im nak, “Saaꞌ reꞌ feꞌe na hi mneen amrair je naan, oras ia najairb on.” ");
INSERT INTO aaz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rarit too mfaun ein reꞌ anbin naan, nmurai naꞌuab nanaib Naiꞌ Yesus am nak, “Hoe! Saaꞌ reꞌ feꞌe na In naꞌuab ee ji, reokn ii kah! Mes naiꞌ Usu Anah, aiꞌ? Nansaaꞌ am es on reꞌ ia?” ");
INSERT INTO aaz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Onaim Naiꞌ Yesus naꞌuab neu sin am nak, “Hi of mihiin uab es nak, ‘Hoe, apairoir menas! Murekoꞌ ho tuam aan feꞌ!’ Hi mpaek uab naan he mꞌoet Au uabak mak, ‘Nansaaꞌ am es Ho ka mmoeꞌ fa rais sanmakat es neu kai mbi ia, nahuum on reꞌ Ho mmoeꞌ je mbi kota Kapernaum?’ ");
INSERT INTO aaz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","In batuurn ii on nai: atoniꞌ ka nroim fa he ntoup Uisneno In mafefa kninuꞌ nbi in kuan ee kuun. ");
INSERT INTO aaz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Tait iꞌtopeꞌ naꞌko Uisneno In mafefa kninuꞌ, kaꞌo Elia. Neot es, uurn ii ka nmouf fa toon teun ma stenaꞌ. Oras naan, anmuiꞌ bifee banuꞌ mfaun nbi pah Israꞌel. Mes Uisneno ka nreek fa naiꞌ Elia he nturun too Israelas sin. Mes Uisneno nreek ee he nnao nturun baun es anbi kuan Sarfat npaumaak kota Sidon. Te kaah, bifee banuꞌ naan, ka atoin Yahudis fa. Mes in npirsai Uisneno In kuasan. ");
INSERT INTO aaz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tait iꞌtopeꞌ bian naꞌko Uisneno In mafefa kninuꞌ, naiꞌ Elisa. Oras naan, anmuiꞌ atoin Yahudis amfaun napenin meen nui-atrokiꞌ nbi pah Israꞌel. Mes Uisneno ka narekoꞌ sin fa. Uisneno suma nreun naiꞌ Elisa he narekoꞌ tuaf meesꞌ aah, kaan ee naiꞌ Naꞌaman. Te kaah, amenat naan atoin Sirias, ka atoin Yahudis fa. Mes in npirsai Uisneno In kuasan.” ");
INSERT INTO aaz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oras sin nneen Usif Yesus naꞌuab on naan ate, sin ar-arsin nek-neuk nisik neu Ne. ");
INSERT INTO aaz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Rarit sin nfenan buꞌ-buaꞌ, ma nriuꞌ napoitn Ee naꞌko uim onen naan. Rarit sin nheer neik Je neu kuan ee ninin, he ntitar nataam Ee neu kefa mnanuꞌ nbi naan. ");
INSERT INTO aaz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mes In suma nnao npoi kuun naꞌko too mfaun ein naan sin atnaank ein, rarit annao nasaitan sin anbin bare naan. ");
INSERT INTO aaz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Rarit Naiꞌ Yesus annao neu kota Kapernaum et nefo Galilea in ninin. Ansuun neon onen sin ate, In nanoniꞌ too mfaun anbin uim oen ein. ");
INSERT INTO aaz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Too mfaun ein ansanmakan oras sin nneen In uaban naan, fin In nahiin batuur-batuur saaꞌ reꞌ In nanoniꞌ sin naan in afan. ");
INSERT INTO aaz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Neot es, oras Naiꞌ Yesus nanoniꞌ anbi uim onen, anmuiꞌ naan tuaf es anniut sae ma nmurai nkoaꞌ naher-heer am nak, ");
INSERT INTO aaz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoe, Yesus, Atoin Nasaretas! Ho mmuiꞌ urusan saaꞌ mok kai! Ho uum he mureuꞌ miis kai, oo? Hai mihiin Ko. Ho reꞌ ia, Atoni Kninuꞌ reꞌ Uisneno anbaꞌan he nreek haefn Ee neem.” ");
INSERT INTO aaz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mes Naiꞌ Yesus naskaar ee mnak, “Kais mufeef! Ampoi nai muꞌko atoniꞌ naan!” Nok askeken ate, nitu naan nait anpesek atoniꞌ naan neu afu, anbi too mfaun ein sin maatk ein. Anpesek anrair je on naan ate, nitu naan anpoi naꞌko atoniꞌ naan ma nasaitn ee, ma ka nameenb ee fa. ");
INSERT INTO aaz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Too mfaun ein ansanmakan ok-okeꞌ mnak, “Airoo! Atoniꞌ ia In uabn ii anmuiꞌ kuasa maꞌtaniꞌ, joo! Tar antea niut reuꞌf ein amsaꞌ natuin In aprenat, ma npoin naꞌko tuaf-tuaf aniut saes ein!” ");
INSERT INTO aaz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Rarit retaꞌ anmatoom nok Naiꞌ Yesus nasiin ok ma nabeon ok nfuun am natef-tefan bare naan. ");
INSERT INTO aaz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Oras sin npoin naꞌkon uim onen naan, Naiꞌ Yesus annao neu atoin es in umi. Atoniꞌ naan, kaan ee naiꞌ Simon. Naiꞌ Simon in ain baabf ee nmaniin ma nbeis maꞌtaniꞌ. Rarit sin ntoit Naiꞌ Yesus am nak, “Aam! Amturun kai he murekoꞌ maan bifee mnais ee feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naiꞌ Yesus annao nhake nbi koi je matan, rarit nriuꞌ napoitan maininit naan. Oras naan amsaꞌ, maininit naan namneuk nain naꞌko bifee mnasiꞌ naan. Rarit in nfeen ma nabarab bukaet neu sin. ");
INSERT INTO aaz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oras maans ee noi nmouf naan, too mfaun ein nmurai neman ma neikin amenat humaꞌ-humaꞌ neu Naiꞌ Yesus. Rarit In ntao In aꞌniman neu sin ok-okeꞌ, ma narekoꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Anbi ameent ein naan amsaꞌ anmuiꞌ tuaf fauk reꞌ anniut saen. Rarit Naiꞌ Yesus naprenat niut reuꞌf ein naan he npoin naꞌkon tuaf-tuaf ein naan. Oras sin npoin, sin nhuun ein am nak, “Ho reꞌ ia, Uisneno In Anah!” Fin niut reuꞌf ein naan nahiin Je nak, In reꞌ naan, Kristus reꞌ Uisneno anbaꞌan nain Je he nreek Ee neem. Natuin rasi naan, es naꞌ Naiꞌ Yesus nakain sin nok maꞌtaniꞌ he sin kaisaꞌ naꞌuab ein hanaf meseꞌ msaꞌ anmatoom nok In tuan. ");
INSERT INTO aaz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oras snaat ee nsae te, Naiꞌ Yesus anfeen ma nnao neu baer ruman es nbi kota in kotin. Too mfaun ein naim Je nbin mee-mee. Oras sin niit ma nateef nok Ne, sin naꞌuab ein am nak, “Aam. Reko te, Ho mutua mok kai mbi ia nai! Kais amnao mtein meu bare bian!” ");
INSERT INTO aaz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mes In nataah am nak, “Au ro he ꞌnao ꞌeu kuan bian he utoon Rais Reko anmatoom nok Uisneno In Aprenat. Fin Uisneno reꞌ anhaef Kau gui, nak Au ro he ꞌmeup mepu naan.” ");
INSERT INTO aaz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Onaim In nmurai nnao, npoi ma ntaam naꞌko kuan es neu kuan es, ma nanoniꞌ tuaf anbin uim oen ein nbin propinsi Yudea. ");
INSERT INTO aaz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Neot es, Naiꞌ Yesus nanoniꞌ tuaf amfaun anbi nefo Galilea in ninin. Too mfaun ein neman ma nromin he natniin Uisneno In Kabin ma Prenat. Sin namfa-faun tar antea sin nmasiitr ein ma nmabeꞌun. Onaim sin he noi nsaen Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anpaumaak bare naan, anmuiꞌ naan akiif kai ikaꞌ nakninuꞌ sin pukat nbin metoꞌ. Onaim Naiꞌ Yesus niit kofaꞌ nua ruum ein anhaken nbin naan. ");
INSERT INTO aaz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Es naꞌko koof nuaꞌ ein naan, naiꞌ Simon iin ja. Rarit Naiꞌ Yesus ansae neu naiꞌ Simon in kofaꞌ, ma naꞌuab neu naiꞌ Simon he ntorak kofaꞌ naan neu oe je kreꞌo. Onaim In ntoko ma nmurai nanoniꞌ neu too mfaun ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nanoniꞌ nrari te, In naꞌuab neu naiꞌ Simon am nak, “Simon! Meik ho kofaꞌ ia meu neof goe tnaan ee kreꞌo, he ho musanut ho pukat ia meu naan. Hi of mipein ikaꞌ mfa-faun.” ");
INSERT INTO aaz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mes naiꞌ Simon nataah am nak, “Usiꞌ msaꞌ, Ho es-es! Hai mmeup fai jes aꞌteme-ꞌteme, mes ikaꞌ fuaꞌ meseꞌ msaꞌ hai ka mipenif! Mes neu Aam, Ho es muꞌuab on naan, maut he au ꞌsobaꞌ ꞌiit!” ");
INSERT INTO aaz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Onaim sin nasanut pukat naan. Rarit sin he nheer nafainꞌ ee, mes pukat naan nahenu nrair nok ikaꞌ tuunb es, tar antea pukat naan anmurai natkai. ");
INSERT INTO aaz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Onaim naiꞌ Simon ankoaꞌ in partein ngguin naꞌkon kofaꞌ bian he neman ntuurn ee. Rarit sin nnaun ikaꞌ ma nkuab ein neu kofaꞌ nua tar antea nahenun, onaim ara kreꞌo te anreman. ");
INSERT INTO aaz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Naiꞌ Simon in partein akiif kai ikaꞌ sin, naiꞌ Yakobus ma naiꞌ Yohanis, aam Sebedius in aanh ein, anbin naan amsaꞌ. Sin nsanmakan amsaꞌ, natuin sin napenin ikaꞌ mfa-faun naan. Oras naiꞌ Simon Petrus niit saaꞌ reꞌ anjari nbi naan, in naen neem ma nriꞌtuu nbi Naiꞌ Yesus In matan, ma naꞌuab am nak, “Au reꞌ ia, tuaf es reꞌ anmoꞌe nsaan amfau-rutu. Onaim reko nneis Usiꞌ kais ampaumaak kau ntein.” Mes Naiꞌ Yesus nataah am nak, “Kais mutenab naan kouꞌ-koꞌu. Au ꞌroim he ꞌpaek ki. Hi arki reꞌ ia, atoin amnaim ikaꞌ. Mes oras ia, Au he unoniꞌ ki he maim tuaf he natuin Kau!” ");
INSERT INTO aaz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Rarit sin nheer sin koofꞌ ein ntean metoꞌ. Onaim sin nnaon nasaitan areꞌ saaꞌ-saaꞌ, ma natuin Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anbi kuan es, Naiꞌ Yesus nateef nok tuaf es, reꞌ in aon ee no mes-meseꞌ nameen nui-atrokiꞌ. Oras in niit Naiꞌ Yesus, in nnao nriꞌtuu ma naꞌruriꞌ ntea afu nbi Naiꞌ Yesus In matan. Onaim in nak, “Aam! Amturun maan kau feꞌ, tua! Au uhiin ꞌak, Ho bisa muneuk main au menas reꞌ ia, he reko te, biak ein kais anmaiꞌnisin kau. Asar Ho mroim, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Rarit Naiꞌ Yesus ansoron In aꞌniman ma nreoꞌ goe. Onaim In naꞌuab am nak, “Au ꞌroim! Mureok nai!” Naꞌuab anrair on naan ate, menas naan namneuk nain. ");
INSERT INTO aaz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Onaim Naiꞌ Yesus namnaub ee mnak, “Mumnau murek-rekoꞌ! Ho mureok goen, mes kais mutoon meu sekau-sekau! Ho ro he mutuin kaꞌo Musa in aprenat unuꞌ naan. Onaim ho mnao meu aꞌnaak rais pirsait, he in nparikas ho aom aan, he in nahiin nak, ho menas naan namneuk batuur-batuur, aiꞌ kaah. Rarit ho mseun bain meik fuaꞌ-turuꞌ, he too mfaun ein nahinin batuur nak, ho mureok goen.” ");
INSERT INTO aaz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Maski Naiꞌ Yesus antaar ee on naan amsaꞌ, retaꞌ anmatoom nok In kuasan naan, nasiin on ma nabeon on naꞌko tuaf neu tuaf anbi mee-mee. Onaim too mfaun ein sin amneemk ein nasain on noe. Sin nmarinan he nneen In noinꞌ ein. Rarit In narekoꞌ tuaf amfaun naꞌkon sin menas humaꞌ-humaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mes Naiꞌ Yesus natiꞌ te nroim he napaisb On naꞌko too mfaun ein, he nnao nꞌonen anbi baer ruman maꞌkoroꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Neot es, Naiꞌ Yesus nanoniꞌ tuaf anbi uim jes. Oras naan anmuiꞌ tuaf naꞌko pukan partei pirsait Farisi ma tunggur agama tuaf fauk neman ma nokan nnenan neu Ne. Sin neman naꞌkon kuan-kuan anbin propinsi Galilea, propinsi Yudea, ma naꞌkon kota Yerusalem. Uisneno nfee kuasat neu Naiꞌ Yesus he narekoꞌ ameent ein. ");
INSERT INTO aaz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Oras naan, anmuiꞌ naan tuaf fauk naꞌtaeb neik tuaf es nameen buaꞌ anbi ꞌbokiꞌ. Sin nꞌusaha maꞌtaniꞌ he neik amenat naan, he Naiꞌ Yesus nareokꞌ ee. Mes umi naan naꞌkeek mates nok mansian, tar antea he naꞌseek ok he ntaman amsaꞌ ka bisa fa. Onaim sin neik amenat naan neu uim je porataꞌ pakan. Rarit sin npukai porataꞌ pakan naan, ma sin nasanut amenat naan nok nain in aꞌbokiꞌ. Sin nasaunt ee anbi too mfaun ein sin atnaank ein, nbi nain Naiꞌ Yesus In matan. ");
INSERT INTO aaz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ankius on naan ate, Naiꞌ Yesus nahiin neu sin npirsain nak, In bisa narekoꞌ sin partei amenat naan. Onaim In naꞌuab neu ameen buaꞌ naan am nak, “Baꞌe! Au ꞌnose ꞌrair ho saant ein naan.” ");
INSERT INTO aaz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anneen Naiꞌ Yesus naꞌuab on naan ate, atoin Farisis ma tunggur agaam ein nmurai nmaktaan ein am nak, “Heeꞌ! Suma Uisneno Kuun es reꞌ anmuiꞌ hak he nnoes nain sanat mansian. On nai te, in reꞌ ia, sekau, tar antea nmoeꞌ jon on reꞌ Uisneno! Rasi ia, manꞌakan maꞌtaniꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mes Naiꞌ Yesus nahini ntea sin nekak nanan. Rarit In naꞌuab neu sin am nak, “Nansaaꞌ am es hi mitenab mak Au reꞌ ia uꞌuab rais manꞌakan? ");
INSERT INTO aaz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Au reꞌ ia, Mansian Batuur-Batuur. Ma Au ꞌmuiꞌ hak he ꞌfee ampon ꞌeu sanat mansian. Karu Au suma utoon ꞌeu ameen buaꞌ ia mꞌak ‘Au ꞌampon urair ho sanat,’ hi ka miit fa Au kuasat anbi pah-pinan ia. Mes karu Au ꞌak, ‘Amfeen nai! Mait ho ꞌboik aan, ma mfain nai.’ Karu in nfeen nain oras naan, naꞌ hi miit Au kuasat. Es naan ate, Au he urekoꞌ ameen buaꞌ ia, maut he hi mihini msaꞌ mak, Au ꞌmuiꞌ hak he ꞌampon sanat mansian.” Onaim In nabaniꞌ nfain neu ameen buaꞌ naan. Rarit naꞌuab neu ne mnak, “Baꞌe! Amhaek nai! Mait ho ꞌboik aan, ma mnao nai!” ");
INSERT INTO aaz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nok askeken ate, amenat naan anfeen anhaek anbi too mfaun ein sin maatk ein. Rarit in nasaah naan kuun in aꞌbokiꞌ. Onaim in anpoi nnao nfain, ma nboꞌis Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nitan on naan ate, sin ar-arsin ansanmakan. Rarit sin nanaib Uisneno In kaan ee naꞌrat-raat am nak, “Uisneno mapinaꞌ-makrahaꞌ, joo! Neno ia hit tiit kuuk rais sanmakat es, teik hit maatk aa kuuk!” ");
INSERT INTO aaz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ka ꞌroo fa te, Naiꞌ Yesus anpoi naꞌko umi naan, ma In nateef nok tua ahoik beo goes, antoko nbi baer beos beo. Tuaf naan, kaan ee naiꞌ Lewi. Rarit Naiꞌ Yesus nak ee mnak, “Uum he mutuin Kau!” ");
INSERT INTO aaz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Anneen on naan ate, naiꞌ Lewi anfeen nain oras naan, ma nnao nasaitan areꞌ saaꞌ-saaꞌ anbin bare naan ok-okeꞌ, ma natuin Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Rarit naiꞌ Lewi nmoeꞌ fesat koꞌu ma naskau Naiꞌ Yesus neem nok anbi in umi. In naskau in partei ahoik beo ngguin ma tamu bian amsaꞌ, he sin nokan anbin fesat naan. ");
INSERT INTO aaz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mes anmuiꞌ tuaf fak-fauk naꞌko partei pirsait Farisi, ma tunggur agaam ein, naꞌmuaꞌ ein anbin Naiꞌ Yesus In atoup noinꞌ ein am nak, “Nansaaꞌ am es hi mtoko mmiah mibua mok atoin ka mapaek ein fa, on reꞌ ahoik beo ma atoin reuꞌf ein? Atoin reok gui kais amseor gom mok tuaf on reꞌ sin!” ");
INSERT INTO aaz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mes Naiꞌ Yesus natonan sin am nak, “Ameent ein ro nperluun apairoir menas. Mes ao-miin ein ka nperluu goe fa. ");
INSERT INTO aaz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au ꞌuum he ꞌurus tuaf-tuaf reꞌ ka mapaek ein fa. Mes Au ka ꞌuum fa, he ꞌurus tuaf-tuaf reꞌ annaben in tuan ee te, reko!” ");
INSERT INTO aaz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Rarit tuaf-tuaf naꞌko partei pirsait Farisi ma tunggur agaam ein naꞌmuaꞌ ein neun Naiꞌ Yesus am nak, “On nai, Aam! Naiꞌ Yohanis Asranit in atoup noinꞌ ein biasa nanaah ok ma nꞌoen ein. Atoin Farisis sin atoup noinꞌ ein on naan amsaꞌ. Mes nansaaꞌ am es ho atoup noinꞌ ein naah-niun piut-piut on naan? Sin ka nanaah nahiin jok fa. Neu saaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mes Naiꞌ Yesus nataah sin neik uab manporin am nak, “Hi mihini mrair, karu anmuiꞌ fesat kabin, taumn ee ka nanaah ok fa, mes sin nbukaen tar namsenan. Karu baroit atoin ee nbi naan feꞌ, sin ro he nbukaen buꞌ-buaꞌ tar namsenan. ");
INSERT INTO aaz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mes of neot es, karu tuaf bian nheek neik baroit atoin aan feꞌ, naꞌ in partein ngguin ansusan. Oras naan sin nanaah ok.” ");
INSERT INTO aaz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Rarit Naiꞌ Yesus anfee uab manporin es antein, nak, “Ka tiit fa tuaf reꞌ nait tai feꞌu ma npaap ee neu baru kroe atpisuꞌ. Fin karu tsaef baru naan ate, tai feꞌu reꞌ feꞌ anpaap ee naan, of annuun gon, ma baru kroe atpisuꞌ naan of natpisuꞌ nkoon. ");
INSERT INTO aaz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","On naan amsaꞌ atoniꞌ ka narai fa tua min-kaes feꞌu neu ꞌsaap rapuꞌ. Fin aꞌsapaꞌ naan of anpeeꞌ, onaim tua min-kase naan nsai ruum-ruum. Onaim tua min-kaes feꞌu ro he tarai je neu ꞌsaap feꞌu. Nok ranan naan, Naiꞌ Yesus nanoniꞌ sin am nak, In noin feꞌu kais amseor goe nok atoin Farisis sin noniꞌ mnaaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Atoniꞌ reꞌ niun niit tua min-kase mnaaꞌ, ka nroim fa he niun tua min-kaes feꞌu, natuin in nahini mnak, ‘Tua min-kase mnaaꞌ naan, es reꞌ aminat anneis-neisi!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Neot es, nateef nok atoin Yahudis sin neno snasat naꞌko mepu, Naiꞌ Yesus nok In atoup noinꞌ ein annaon npeꞌon biak ein sin reen je ninin. Onaim In atoup noinꞌ ein anheut naan maak-gandum in punin reꞌ anbin sin maatk ein. Rarit sin anfoer sin, ma nahan. ");
INSERT INTO aaz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anbi naan, anmuiꞌ tuaf fak-fauk naꞌkon partei pirsait Farisi reꞌ annaaꞌ naher-heran atoran harat Yahudi. Ankius niit Naiꞌ Yesus In atoup noinꞌ ein anmoꞌen on naan ate, sin nakain Ee mnak, “Nansaaꞌ am es Ho atoup noinꞌ ein antanhai hit atoran pirsait? Sin nmepun nateef nok neno snasat! Amkius sin! Sin nheut maak-gandum. Kais on naan!” ");
INSERT INTO aaz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Mes Naiꞌ Yesus nataah sin am nak, “He tak on mee, joo? Hi ka mimnau fa kaꞌo Daut in reetn ee oo? Kaꞌo Daut nok iin ne, sin taik ein naꞌroton natuin sin namnahan nmaten. Onaim sin ntaman neun Uisneno In Tenar Onen ma naitin utunuꞌ reꞌ aꞌnaak pirsait ein sin nanaꞌat anrair sin neu Uisneno, ma sin nahan. Te kaah, suma aꞌnaak pirsait ein es reꞌ nabeꞌin he naah utuun ein naan. Tuaf bian sin ka bole fa. Rarit kaꞌo Daut sin nahan, mes ka tiit tain fa tuaf es he nasaan sin. Hi on reꞌ ka mrees mihiin fa Uisneno In Suur Akninuꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Amtakan hi ruikm ein he mneen mirek-rekoꞌ! Au reꞌ ia, Mansian Batuur-batuur. Au ꞌmuiꞌ hak he ufeek ꞌak, atoniꞌ nabeiꞌ he nmoeꞌ saaꞌ-saaꞌ anbi neno snasat.” ");
INSERT INTO aaz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Neon goes, nateef nok neno snasat, Naiꞌ Yesus annao nanoniꞌ nbi uim onen. Anbi naan, anmuiꞌ atoin es, in aꞌniman es ee nmaet. ");
INSERT INTO aaz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anbi naan amsaꞌ, anmuiꞌ tunggur agama fak-fauk ma atoniꞌ naꞌkon partei pirsait Farisi reꞌ namin raan asraak he nakreo namouf Naiꞌ Yesus. Rarit sin nnuuꞌ Naiꞌ Yesus, kar-karu In narekoꞌ atoniꞌ naan, nateef nok neno snasat. Nok ranan naan, sin bisa ntuꞌiirn Ee maat-maat. ");
INSERT INTO aaz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mes Naiꞌ Yesus nahiin namneo-namneo neu sin sarit naan. Es naan ate, In noꞌen atoniꞌ naan nak, “Baꞌe! Uum amhaek meu reꞌ ia feꞌ!” Onaim in nnao ma nhake nbi naan. ");
INSERT INTO aaz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Rarit Naiꞌ Yesus nataan abitan reꞌ naan am nak, “Au he utaan ꞌaan ki feꞌ. Tatuin hit atoran rais pirsait, saaꞌ na es reꞌ hit he tmoeꞌ je nateef nok neno snasat taꞌko mepu? Tmoeꞌ reko, oo? Aiꞌ, tmoeꞌ maufinu? Tsoi tafetin tuaf, aa oo? Aiꞌ, tareuꞌ in aꞌmonin?” ");
INSERT INTO aaz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Rarit Naiꞌ Yesus ankius natef-tefan sin, ma In naꞌuab neu atoniꞌ naan am nak, “Amnonaꞌ ho ꞌnimam naan neem!” Rarit in nsoron in aꞌniman naan, ma nareok nain. ");
INSERT INTO aaz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ankius on naan ate, tuaf-tuaf reꞌ anmusun Naiꞌ Yesus nek-neuk nisik. Rarit sin nmurai nareon ein rais maufinu nak, “Hit ro he tami ꞌtein raan aꞌpoꞌi bian, he naꞌ bisa tamouf Goe!” ");
INSERT INTO aaz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka ꞌroo-ꞌroo fa ntein, Naiꞌ Yesus ansae neu ꞌtoꞌef es ma nꞌonen. In nꞌonen anbi naan fai jes aꞌteme. ");
INSERT INTO aaz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nokaꞌ kik-kiku on naan ate, In noꞌen naan In atoup noinꞌ ein. Rarit naꞌko sin reꞌ naan, in nbetis naan tuaf boꞌes am nua he njarin In haef ein. Tuaf ein reꞌ In nbetis sin naan, es reꞌ: ");
INSERT INTO aaz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Naiꞌ Simon (reꞌ natiꞌ te, Naiꞌ Yesus noeꞌn ee te nak, ‘Petrus’), naiꞌ Anderias (naiꞌ Simon orif), naiꞌ Yakobus, naiꞌ Yohanis (naiꞌ Yakobus orif), naiꞌ Felipus, naiꞌ Bertolomeos, ");
INSERT INTO aaz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","naiꞌ Mateos, naiꞌ Tomas, naiꞌ Yakobus (naiꞌ Alfius in anah), naiꞌ Simon (reꞌ ntaam partei purtik Selot), ");
INSERT INTO aaz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","naiꞌ Judas (naiꞌ Yakobus in anah), ma naiꞌ Judas Iskariot (reꞌ of naꞌsosaꞌ Usif Yesus). ");
INSERT INTO aaz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Oras ansaun neman naꞌko ꞌtoꞌef naan, Naiꞌ Yesus nok In atoup noinꞌ ein anhaken anbin amneraꞌ. Too mfaun ein nabua nanin anbin naan. Sin neman naꞌkon propinsi Yudea, kota Yerusalem, ma kota nua et tais je ninin, esan reꞌ Tirus ma Sidon. ");
INSERT INTO aaz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sin neman he nnenan kuuk naꞌkon Naiꞌ Yesus, ma bian he ntotin he In narekoꞌ amenat. Onaim In narekoꞌ sin. In narekoꞌ aniut saes ein, ma nriuꞌ napoitan niut reuꞌf ein naꞌkon tuaf ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sekau-sekau reꞌ anroim he nreoꞌ aiꞌ nasbetu haa Naiꞌ Yesus aꞌkreoꞌ goah, anmuiꞌ kuasa npoi naꞌko Na, ma narekoꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Rarit Naiꞌ Yesus nabaniꞌ neu In atoup noinꞌ ein ma nanoniꞌ sin am nak, “Atoin kasian ki! Hi mꞌua-paeꞌ ma mꞌua-reok, natuin Uisneno naan, hi Usif arekot! ");
INSERT INTO aaz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Atoin amnahas ki! Hi mꞌua-paeꞌ ma mꞌua-reok, natuin Uisneno of napeet ma naseen ki. Akae pin-pinus ma neek asusat ki! Hi mꞌua-paeꞌ ma mꞌua-reok, natuin hi of ammain ma mmariin. ");
INSERT INTO aaz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Tuaf reꞌ napein susat natuin in natuinaꞌ Kau, Mansian Batuur-batuur reꞌ ia! Hi mꞌua-paeꞌ ma mꞌua-reok, natuin Uisneno of anbaras neu ki et sonaf neno tunan. Maski atoniꞌ nakan ki, aiꞌ nareuꞌ hi kaan foo menin, aiꞌ anteir hae ki, aiꞌ anriuꞌ napoitan ki on reꞌ atoin maufinu, hi mꞌua-paeꞌ ma mꞌua-reok, natuin Uisneno of namnau ki mbi sonaf neno tunan. Onaim karu anmuiꞌ tuaf nasusab ki on naan, kais misusab hi neekm ein naan, mes amharineb hi neekm ein naan! Ma amtaikreit nok ma mmariin nok! Kais amsanmaak, natuin atoniꞌ reꞌ nasusab ki oras ia, sin beif-naꞌif sin es reꞌ nasusab Uisneno In mafefa kniunꞌ ein un-unuꞌ. Onaim karu hi mipein susat nahuum on reꞌ naan, mmoeꞌ hi neekm ein anmarinan, natuin Uisneno of anbaras neu ki nho-hoen nbi sonaf neno tunan! ");
INSERT INTO aaz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mes neu atoin amuꞌit ki! Hi mipein siraak, natuin hi ꞌmoinm ein ro marinan, suma antuꞌu nbi ia. ");
INSERT INTO aaz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amsenat ma apetas ki! Hi mipein siraak, natuin oras amnahas antaman ki. Atoin amain fareꞌ ki! Hi mipein siraak, natuin maꞌneꞌat nmoeꞌ ki mkae mpin-pinus. ");
INSERT INTO aaz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atoin asinmakan rais hormaat ki! Hi mipein siraak, natuin unuꞌ te hi beꞌi-naꞌi sin, nboꞌis ma nanaib amsaꞌ mafeef poin guin!” ");
INSERT INTO aaz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Rarit Naiꞌ Yesus antuta ntein In uaban am nak, “Amtakan hi ruikm ein he mneen mirek-rekoꞌ! Ho ro he mneek ho musun, ma mmoeꞌ ꞌmoeꞌ reko meu tuaf-tuaf reꞌ neekn ee nameen neu ko. ");
INSERT INTO aaz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Amꞌonen meu Uisneno he In nmoeꞌ reko neu tuaf-tuaf reꞌ ankaas ko. Ma mtoit Je he In nmoeꞌ ꞌmoeꞌ reko neu tuaf-tuaf reꞌ nmoꞌ-moeꞌ ko goan. ");
INSERT INTO aaz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Karu anmuiꞌ tuaf anpaas ho ꞌkinum es, mkoon ee he npaas ho ꞌkinum bian naan. Karu ntetak naan ho baur mainikin, mnoon ee ho baur guan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Karu anmuiꞌ tuaf antoit ho baer es, mnoon ee he. Ma karu anmuiꞌ tuaf nait neik ho baer es, maut he in npaar kuun ee. Kais amtoup mufaniꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ho ro he mmoeꞌ meu biak ein, natai on reꞌ ho mroim he sin nmoeꞌ saaꞌ neu ko. ");
INSERT INTO aaz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ho mrom-roim he mneek ho noont ein kuum. Naan reko. Mes in arekon anneis-neis ji, saaꞌ? Fin amoeꞌ maufiun ein amsaꞌ anneek sin tuaf ein kuuk! ");
INSERT INTO aaz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Karu ho suma mmoeꞌ reko meu tuaf-tuaf amoeꞌ reko neu ko, in arekon anneis-neis ji, es reꞌ mee? Fin amoeꞌ maufiun ein anbaras ꞌmoeꞌ reko on naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Karu ho mutusab roit meu tuaf-tuaf reꞌ bisa nbaen nafaniꞌ ko ho roit ein naan, in arekon anneis-neis ji, saaꞌ? Fin amoeꞌ maufiun ein natuusb ein roit neu tuaf bian, asar ramu nokaꞌ-nmeu te sin ntoup nafaniꞌ sin ite, nanookb ok. ");
INSERT INTO aaz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mes reꞌ reko anneis-neis ji, on nai: amneek ho musu sin! Ma mmoeꞌ ꞌmoeꞌ reko meu sin. Sin nperluu saaꞌ ate, mutusab sin. Kais mutenab mak, sin of bisa nfee nafaniꞌ ko sin, aiꞌ kaah. Nok ranan naan, Uisneno of anbaras neu ko. Ma ho mjair Uisneno Aꞌraat Reꞌuf In anah. Natuin ho mmoin on reꞌ ho Amaꞌ reꞌ anroim he nmoeꞌ reko neu tuaf-tuaf amoeꞌ maufinu. In anmoeꞌ ꞌmoeꞌ reko msaꞌ neu tuaf-tuaf reꞌ ka ntoit nahiin fa makasi. ");
INSERT INTO aaz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Onaim ho ro he mukriraꞌ rais kasian meu tuaf bian, nahuum on reꞌ ho Amaꞌ abit sonaf neno tunan nakriraꞌ In rais kasian neu ko.” ");
INSERT INTO aaz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Naiꞌ Yesus nanoniꞌ piut am nak, “Kais mutaib tuaf, he tuaf kais nataib neu ko msaꞌ. Kais mukritik tuaf, fin tuaf of nakritik nafaniꞌ neu ko msaꞌ. Amnikan main tuaf ein sin saant ein, he sin annikan nain ho saant ein amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Karu ho mfee meu tuaf saaꞌ reꞌ sin nperluu, ho of amtoup mufaniꞌ sin. Fin of Uisneno anꞌator he ho mtoup mufaniꞌ sin anho-hoen. Naan nahuum on reꞌ tuaf anꞌoop aknaaꞌ neu bree-ukur, rarit anhasuꞌ ma nneen je. Rarit nꞌopaꞌ nteinꞌ ein tar antea naheun ma natꞌoop. Reꞌ ho mtoup sin naan, nahuum on reꞌ naan. Karu ho mfee kreꞌ-reꞌo, ho mtoup mufaniꞌ sin kreꞌo msaꞌ. Mes karu ho mfee kouꞌ-koꞌu, ho mtoup mufaniꞌ sin anho-hoen.” ");
INSERT INTO aaz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naiꞌ Yesus nanoniꞌ npaek uab manporin amsaꞌ. In naretaꞌ am nak, “Afoort ii, ka neu he nakriraꞌ fa ranan neu aforot bian. Fin sin nua sin of anroron ntaman neu konaꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aan muirt ii, ka neu he nneis fa in tungguru! Mes karu in natuin rek-reko in tunggur goe in nonin, in bisa natai nok in tungguru. ");
INSERT INTO aaz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ho mroim he mtanar tuaf-tuaf bian sin sanat aanꞌ-anaꞌ. Mes ho sanat reꞌ kouꞌ-kouꞌ goan, ho mak, ka mnitaꞌ fa. Naan on reꞌ ho mtae miit afu skuuk aan es anbi es in matan. Te kaah, hau tbaa kouꞌ goes anꞌeek ho maat maan, mes ho ka mnaben fa! ");
INSERT INTO aaz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Anmoeꞌ on meeꞌ mꞌes ho mubrain he muꞌuab am mak, ‘Baꞌe, uum he au ꞌfuu upoin afu skukuꞌ naꞌko ho maatm aan feꞌ.’ Te kaah, ho tuam aan kuum ka miit fa saaꞌ-saaꞌ, natuin hau tuuk kouꞌ goes anꞌtoeb naan ho maatm ein naan! Hae! Ro ho batuur-batuur atoin aputa-kriut ko! Airoo! Mait imporin hau tbaat naan naꞌko ho maatm ein feꞌ. Naꞌ ho mkisu te nakninuꞌ, rarit naꞌ amfuu afu skuuk anaꞌ naan naꞌko ho baꞌe in matan.” ");
INSERT INTO aaz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Naiꞌ Yesus naꞌuab anteniꞌ rais manporin es am nak, “Ka neu fa he roet reok gui nafua fua reꞌuf. Ma ka neu fa he hau fua reok gui, npoi naꞌko hau reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atoniꞌ bisa ntanar, karu roet es reko, aiꞌ kahaf, es reꞌ naꞌko hau roet naan in fuan. Sekau-sekau goah nahinin nak, ka neu fa he atoniꞌ nseu kaut aiꞌ hau fua anggur, naꞌko hau maꞌaikaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","On naan amsaꞌ, atoin neek akninuꞌ bisa nmoeꞌ ꞌmoeꞌ arekot. Mes atoin neek meisꞌokan, nmoeꞌ ꞌmoeꞌ maufinu. Fin naꞌko atoniꞌ in uaban, in nakriraꞌ in tuan batuur.” ");
INSERT INTO aaz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Rarit Naiꞌ Yesus antuta ntein am nak, “Hi mhaman Kau te, mak ‘Usiꞌ’. Mes nansaaꞌ am es hi ka mroim fa he mituin Au uab ein? ");
INSERT INTO aaz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Atoniꞌ reꞌ neem ma natniin Kau, rarit anmoeꞌ natuin Au uabak, in reꞌ naan nahuum on reꞌ ");
INSERT INTO aaz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","tuaf reꞌ he nafenaꞌ uim reko maꞌtain es. In nhain uim baarf ee ntaam antea auf manuꞌ aiꞌ mafatuꞌ te, nasnasab. Rarit in nraem fanderen nmurai naꞌko auf manuꞌ aiꞌ mafatuꞌ naan, he naꞌ in nafenaꞌ umi. Karu noe saok goe nsae, umiꞌ naan antaaꞌ aah, natuin in faut fanderen naan maꞌtaniꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mes atoniꞌ reꞌ anneen nok neek ao-biaf neu Au uabak, tuaf reꞌ naan nahuum on reꞌ he nafenaꞌ umiꞌ rabah. In ka nraem fa fanderen, mes naꞌpesib umi naan anbi auf afaꞌ anpaumaak noe je ninin. Onaim oras noe saok goe neem ate, nsaen ma nmemun, rarit anroi neik umi naan!” ");
INSERT INTO aaz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nanoniꞌ nrair on naan ate, Naiꞌ Yesus ntebi nfain neu kota Kapernaum. ");
INSERT INTO aaz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Anbi naan, anmuiꞌ aꞌnaak sorarus Roma tuaf es. In nmuiꞌ naan ameput tuaf es, mapirsaꞌi. Ameput naan nameen, onaim he nmaet een. ");
INSERT INTO aaz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oras aꞌnakat naan anneen uab anmatoom nok Naiꞌ Yesus, in nreek haefan tuaf naꞌko atoin Yahudis sin he nnaon neu Naiꞌ Yesus, he naskau Goe neem narekoꞌ ameput naan. ");
INSERT INTO aaz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sin naꞌuab anfuir Naiꞌ Yesus, he karu reko te, In neem nok sin he narekoꞌ amenat naan. Sin nfuir Ee mnak, “Aam! Atoin Romas ia, atoin reko! In reꞌ naan, Ho mturun maan ee te, ro pantas. ");
INSERT INTO aaz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Fin In nafenaꞌ naan uim onen es neu kit, ma in nneek hit atoin Yahudis amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Onaim Naiꞌ Yesus natuin sin. Sin ka ntean fa feꞌ neu umi naan ate, aꞌnakat naan anreek haefan tuaf anteniꞌ he neem neik beno neu Naiꞌ Yesus am nak, “Usiꞌ kais muhaeb Om amtein, natuin au ka pantas fa he ꞌseun Ko ma ꞌeik Ko ꞌeu au umi. ");
INSERT INTO aaz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ma au ka pantas fa msaꞌ he ꞌbaiseun Ko, tua. Au uhiin ꞌak, Ho mmuiꞌ kuasa. Onaim asar Usiꞌ Ho muꞌuab ahaa muꞌko bare naan, ro tebes, au ameput naan of nareok nain. Au uhiin rasi ia, natuin au aꞌnaet ein anmuꞌin kuasa he naprenat kau. Ma au ꞌmuiꞌ kuasa msaꞌ he uprenat au soraurs ein. Karu au uprenat au soraur aan ein ꞌak, ‘Meu nee!’ ro tebes in nnao neu nee. Karu au ꞌak, ‘Meu ia!’ ro tebes in neem neu ia. Karu au ꞌreek au ameput es ꞌak, ‘Ammeup ia!’ ro tebes in nmeup on reꞌ naan. Onaim asar Usiꞌ Ho muꞌuab aah, ro tebes au ameput naan, nareok nain.” ");
INSERT INTO aaz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Anneen on naan ate, Naiꞌ Yesus ansanmaak. In nabaniꞌ neu tuaf-tuaf reꞌ nok Ne jan. Rarit In nkiꞌun ma naꞌuab am nak, “Aꞌroo-ꞌroo reꞌ ia, Au ka ꞌiit ꞌiit fa tuaf es naꞌko atoin Yahudis reꞌ in pirsait ee naꞌkiiꞌ maꞌtaniꞌ on reꞌ atoin Romas reꞌ ia!” ");
INSERT INTO aaz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Onaim Naiꞌ Yesus annao ntuꞌu haa bare naan. Rarit aꞌnaak sorarus naan in partein ngguin ntebi nfanin. Antean aꞌnakat naan in uim je te, sin niit amenat naan nareko nrair. ");
INSERT INTO aaz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nokaꞌ on naan ate, Naiꞌ Yesus nok In atoup noinꞌ ein, annaon neun kuan es, kaan ee, Nain. Too amfaun ein nok sin imsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oras sin he noi ntean neu kuan naan in enoꞌ ꞌtamas, anmuiꞌ too puukn es anpoin naꞌkon kuan naan, he nnaon nsuban amates. Amates naan, baun es in aan moen meseꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Oras Naiꞌ Yesus ankius bifee banuꞌ naan, In nkasian. Onaim In nhaan mau neu bifee banuꞌ naan am nak, “Ain! Kais amkae!” ");
INSERT INTO aaz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Rarit Naiꞌ Yesus annao npaumak-maak neu sin, ma nreꞌo ꞌbokiꞌ naꞌko amates naan. Onaim aꞌtaeb sin anhaken akreꞌo. Rarit Naiꞌ Yesus naꞌuab neu amates naan am nak, “Anah! Amfeen nai!” ");
INSERT INTO aaz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Onaim riꞌaan amates naan anmoni nfain, rarit anfeen ma ntook nain oras naan. Onaim in nmurai naꞌuab nok ahaekt ein reꞌ anniub naan ee reꞌ naan. Rarit Naiꞌ Yesus naꞌuab neu bifee banuꞌ naan am nak, “Ain! Ho aanh ii es ia.” ");
INSERT INTO aaz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abitan reꞌ naan ok-okeꞌ namtaun nmaten! Onaim sin nmurai nboꞌis nanaib Uisneno mnak, “Uisneno nreek anrair In mafefa kninuꞌ maꞌtain es neu kit!” Tuaf bian nak, “Uisneno ankoen On neem anrair es hit atnanak, ma nakriraꞌ In nekan arekot!” ");
INSERT INTO aaz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Onaim rasi naan masinaꞌ ma matonaꞌ nbi propinsi Yudea, tar antea pah bian amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Naiꞌ Yohanis Asranit in atoup noinꞌ ein anneen anrarin areꞌ kanan rasi reꞌ Naiꞌ Yesus anmoeꞌ sin. Rarit sin nnaon ma natonan naiꞌ Yohanis anbi bui. Onaim in nreek haefan tuaf nua he nnaon ma nataan Naiꞌ Yesus am nak, “Aam. Ho reꞌ ia batuur-batuur Kristus, reꞌ hai mpa-pao Goe ji, oo? Aiꞌ, hai ro he mpao mtein tuaf es?” Onaim sin nateef Naiꞌ Yesus ate, sin nataan Ee on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oras haef ein anbin naan, Naiꞌ Yesus narekoꞌ too mfaun ein sin meens ein humaꞌ-humaꞌ. Ma In nriuꞌ napoitan niut reuꞌf ein naꞌko tuaf-tuaf reꞌ anniut saen. Ma In narekoꞌ afoort ein he nitan nfanin. ");
INSERT INTO aaz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Rarit Naiꞌ Yesus natoon neu naiꞌ Yohanis in haef ein am nak, “Hi mnao mfain ma mitonan naiꞌ Yohanis, areꞌ kanan rasi reꞌ hi miit ma mneen kiim sin, natai on reꞌ Uisneno In mafefa kninuꞌ naiꞌ Yesaya antui mnak, ‘Aforot, niit anfain. Abuat, anfeen ma nnao. Ameen nui-atroki, nareko kninuꞌ. Akosot, anneen anfain. Amates, anmoni nfain. Atoin kasian, anneen Rais Reko.’ ");
INSERT INTO aaz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Amfain nai. Meu te mitonan naiꞌ Yohanis am mak, ‘Atoniꞌ reꞌ ka namaeb on fa he ntoup Kau, sin of napenin amnisat.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Oras naiꞌ Yohanis in haef ein antebi nfanin ate, Naiꞌ Yesus naꞌuab neu too mfaun ein naan, anmatoom nok naiꞌ Yohanis am nak, “Oras hi mnao maim naiꞌ Yohanis ambi baer ruman naꞌroo naꞌko kuan, hi teenb ein hi he miit ma miteef mok atoniꞌ human on reꞌ mee? Ka neu fa he hi miit aiꞌ miteef atoin apeort es, on reꞌ oo goan. Ain ee nfuu nabeub oo goan ate, in natun-tuin aah! ");
INSERT INTO aaz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka neu fa he hi mnao he miit aiꞌ miteef mok atoniꞌ reꞌ anpaek tai-maꞌosaꞌ, natuin tuaf on reꞌ naan, suma et ahaa sonaf! ");
INSERT INTO aaz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Onaim hi mnao mkius sekau mbi nee? Hi mitenab mak, hi mnao maim Uisneno In mafefa kninuꞌ? Batuur! Mes in reꞌ naan, mafefaꞌ reꞌ maꞌtain reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Fin antui nain je et Suur Akninuꞌ anmatoom nok naiꞌ Yohanis am nak, ‘Amneen! Au ꞌreek Au ꞌhaef, he nraip ranan neu Ko.’ ");
INSERT INTO aaz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anbi pah-pinan ia, ka tiit tain fa tuaf es, reꞌ maꞌtaniꞌ neis naꞌko naiꞌ Yohanis. Mes anbi Uisneno In aprenat, tua aꞌoret maꞌtaniꞌ nneis naꞌko naiꞌ Yohanis.” ");
INSERT INTO aaz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Too mfaun reꞌ anneen Naiꞌ Yesus In uaban naan, nahini nrarin nak, Uisneno In ranan naan, raan aꞌhonis batuur. Ahoik beo ngguin amsaꞌ on naan. Natuin unuꞌ te, naiꞌ Yohanis nasrani nrair sin ma nanoniꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mes tuaf-tuaf naꞌko partei pirsait Farisi ma ahiin rais hukun Yahudis sin, ka nromin fa he natuin Uisneno In romin. Etun sin ka nak fa naiꞌ Yohanis he nasrain sin. ");
INSERT INTO aaz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Rarit Naiꞌ Yesus nataan am nak, “Au he utaib atoniꞌ oras ia nok saaꞌ? Sin reꞌ naan, mansian human on reꞌ mee? ");
INSERT INTO aaz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sin reꞌ naan nahuum on reꞌ muinf ein reꞌ antok-tokon kuuk et aꞌmasaꞌ. Sin nmakoaꞌ ein ma anmatoen am nak, ‘Hit tfuu bobe ma treuk ok-okeꞌ, mes hi ka mmarinin fa bsoꞌot. Rarit hai msii mbi beꞌet, mes hi ka mkae fa.’ ");
INSERT INTO aaz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Naiꞌ Yohanis Asranit ka niun fa tua min-kase, ma in biasa nanaah on amsaꞌ, mes hi miꞌaakn ee mmak, ‘In nniut sae!’ ");
INSERT INTO aaz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mes oras ia, Au, Mansian Batuur-batuur, Au ꞌiun tua min-kase ma ꞌuah utunuꞌ on reꞌ biasa. On nai te, hi mak Kau mmak, ‘In reꞌ naan, akomat! Amauf maꞌtan-tain es antein! Amakuaꞌnoon nok ahoik beo ngguin! Anmapartei nok atoin ka mapaek ein fa! Ka ntae nahiin fa in tuan!’ ");
INSERT INTO aaz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mes hi mtanar kiim Au hanak reꞌ ia, hee! Atoniꞌ reꞌ nahiin batuur-batuur, sin natuin Uisneno In romin.” ");
INSERT INTO aaz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anbi kota naan, anmuiꞌ atoin Farisis es, kaan ee naiꞌ Simon. Neot es, in naskau Naiꞌ Yesus he neem anbukae nbi in umi. Antoupu nrair haan askaut naan ate, Naiꞌ Yesus sin annaon ma ntokon he nbukaen. ");
INSERT INTO aaz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oras naan, anmuiꞌ bifee aꞌhaek es anneen nak, Naiꞌ Yesus nok anbukae et bare naan. Onaim in ntaam. In nnaaꞌ neik miin foo meniꞌ bootr es. Minaꞌ ia in maꞌosaꞌ batuur. ");
INSERT INTO aaz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","In neem anpaumaak Naiꞌ Yesus naꞌko In kotin. Rarit in nriꞌtuu nbi Naiꞌ Yesus In haek ein. Onaim in nkae npin-pinus, tar antea in nuu-pinu nmoufun anbin Naiꞌ Yesus In haek ein. In nnoes Naiꞌ Yesus In haek ein anpaek in aꞌnaak fuun ein, ma anneek nafan-faniꞌ Naiꞌ Yesus In haek ein. Rarit in nꞌoop miin foo meniꞌ naan neu Naiꞌ Yesus In haek ein. ");
INSERT INTO aaz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naiꞌ Simon nahiin batuur-batuur bifee naan in aꞌhaken. Onaim in natenab anbi in nekan am nak, “Ia njair bukti es nak Naiꞌ Yesus ia, ka Uisneno In mafefa kniun aa fa! Karu batuur-batuur Uisneno es anreek ma nhaef Ee neem, ro batuurn ii, Naiꞌ Yesus nahiin nain bifee reꞌ anreoꞌ Goe reꞌ ia, bifee aꞌhakeꞌ. Uisneno In mafefa kniunꞌ ein, ka on fa In reꞌ ia, natuin atoniꞌ kniun ii, ka nabeiꞌ fa he npaumaak atoin ꞌoemetan sin!” ");
INSERT INTO aaz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mes Naiꞌ Yesus antae niit naiꞌ Simon In tenab. Onaim in naꞌuab am nak, “Airoo, Simon. Au he utoon ko rais jes.” Onaim naiꞌ Simon nataah am nak, “Muꞌuab kuum, Aam Tungguru.” ");
INSERT INTO aaz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Onaim Naiꞌ Yesus nfee uab manporin am nak, “Anmuiꞌ atoin es atusab roit neu tuaf bian. Neot es, in natusab roit neu tuaf nua. Tuaf es, in natusab roi mutiꞌ fuaꞌ natun niim (500). Es anteniꞌ, suma fuaꞌ boꞌ niim (50) aah. ");
INSERT INTO aaz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mes antea in oras he nafaniꞌ roit ein naan, tua nuaꞌ ein naan ka nabeꞌin fa. Onaim tua atusab roit naan ankasian sin nua sin. Es naan ate, in nafreib sin he kais anbaen sin tuus ein naan. Onaim karu tatuin aam Simon ho teenb aan ate, mee es reꞌ anneek nanesib tua atusab roit naan?” ");
INSERT INTO aaz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naiꞌ Simon nsenu nfeek am nak, “Ro amuiꞌ tuus amfaun naan!” Naiꞌ Yesus nataah am nak, “Batuur, aam!” ");
INSERT INTO aaz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Onaim In nabaniꞌ neu bifee naan, ma naꞌuab neu naiꞌ Simon am nak, “Ho mkius miit bifee reꞌ ia. Oras Au ꞌtaam ꞌuum ꞌeu ho uim ji, ho ka mubarab fa oe he ho mufaun Au haek ein mutuin hit atoran harat. Mes bifee ia, nafaun Au haek ein npaek in maat nuu ngguin, rarit annoes nakninuꞌ sin nok in aꞌnaak fuun ein. ");
INSERT INTO aaz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma feꞌe na, oras ho mseun Kau meu ho umi ia, ho ka mneek Kau fa mutuin hit atoran harat. Mes anmurai naꞌko oras Au ꞌtaam aꞌrair iꞌbi umi ia, bifee reꞌ ia anneek au haek ein piut-piut. ");
INSERT INTO aaz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aam Simon, ho mnikan main hit harat reꞌ he muꞌpeeh taumn ein, oras Au ꞌtaam ꞌuum feꞌe na. Mes bifee ia, naꞌpeeh Kau npaek miin foo meniꞌ reꞌ maꞌosaꞌ neu Au haek ein. ");
INSERT INTO aaz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Simon, ho mneen rek-reko feꞌ! Bifee reꞌ ia in saant ein ro mfau-rutun. Mes Uisneno nnose nrair sin, natuin in nakriraꞌ in rais manekat ma sukuur kouꞌ-koꞌu neu Kau. Mes tuaf-tuaf reꞌ annaben in tuan ee ka nmoeꞌ fa sanat amfaun, in nnaben nak in ka nperluu fa he napein ampon koꞌu. Etun in ka nmaneek nahiin fa, ma ka nasaeb nahiin fa sukuur neu Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Rarit Naiꞌ Yesus ankius bifee naan am nak, “Au ꞌnoes ꞌain ho saant ein naan een!” ");
INSERT INTO aaz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abukaet ein reꞌ nbin naan, anmaꞌseꞌ-seoꞌ guin am nak, “Hae! In natenab nak In reꞌ ia sekau?! In nabrain he nfee ampon neu atoin asanat, aa oo? Te kaah, suma Uisneno Kuun es reꞌ nmuiꞌ hak he nnoes nain sanat mansian! Phueh!” ");
INSERT INTO aaz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mes Naiꞌ Yesus naꞌuab neu bifee naan am nak, “Natuin ho mpirsai Kau, es naan ate, Uisneno nsoi naan ko. Amfain nai nok mamut-aominaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka ꞌroo fa nteniꞌ te, Naiꞌ Yesus ma In atoup noinꞌ ein, tuaf boꞌes am nua, annaon nfuun am natefan neun kota-kota ma kuan-kuan anbin pah naan. In nnao natoon Uisneno In aprenat. Naan njair rais reko ma beno arekot neu sin. ");
INSERT INTO aaz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Anbi pukan anaot ein naan, anmuiꞌ bifee fauk nokan amsaꞌ. Bifeen reꞌ ia, nameen nitan menas humaꞌ-humaꞌ, ma bian anniut sae nitan. Mes Naiꞌ Yesus nareko nrair sin ok-okeꞌ. Tuaf es, es reꞌ bi Maria naꞌko kuan Makdala. Unuꞌ te, Naiꞌ Yesus anriuꞌ napoitan niut reꞌuf hiut naꞌko bi Maria reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tuaf es, es reꞌ bi Susana, rarit ain Yohana. Ain Yohana reꞌ ia, aam Kusa in fee. Aam Kusa naan, aꞌnaak urusan et usif Herodes in sonaf. Ma nmuꞌi ntein bifee mfaun reꞌ nnaon nabu-buan nok Naiꞌ Yesus sin. Bifeen reꞌ ia, npaek kuuk sin roit he nataah baen neu Naiꞌ Yesus oras In nbi raan atnanaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Neot es, too mfaun ein neman naꞌkon kuan-kuan he naim Naiꞌ Yesus. Oras too mfaun ein nabua nrarin ate, Naiꞌ Yesus naretaꞌ sin anpaek uab manpoirn es nak, ");
INSERT INTO aaz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anmuiꞌ naan atoin tani es, anseen fini nbi in rene. Fini bian anmoufun anbin ranan. Oras atoniꞌ nnaon npeꞌon ranan naan, sin nteir finin naan. Rarit koorn ee neman ma nteo nain sin. ");
INSERT INTO aaz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fini bian anmoufun anbin auf faut-makhapiꞌ. Fini naan nmurai natoor, mes namnenen, natuin ka napein fa oe. ");
INSERT INTO aaz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fini bian anmoufun anbin baer maꞌaikaꞌ. Mes oras finin naan anmurai natoron, hau maꞌaik ein nhaip naꞌmaet sin. ");
INSERT INTO aaz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mes fini bian anteniꞌ nmoufun anbin auf amriat. Finin ia natoron, anmonin tar antea nasratan ma nasufan, rarit nafuan. Finin reꞌ ia, nafuan no fuaꞌ nautn es.” Naretaꞌ nrair on naan ate, Naiꞌ Yesus natuꞌub uab manporin naan. In nak, “Hi maruik ein ki, onaim mitenab mirek-rekoꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Rarit Naiꞌ Yesus In atoup noinꞌ ein nataan uab manporin naan in aꞌmoufun. ");
INSERT INTO aaz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","In nataah am nak, “On nai! Natuin hi mituin batuur-batuur meu Uisneno In romin, es naan ate, Au he utoon ki maat-maat, he hi mihiin nok ranan mee Uisneno he naprenat Iin na. Mes biak ein ka nfairoir fa Uisneno In romin. Etun Au unoniꞌ sin ꞌeik uab manporin. Fin Uisneno In mafefa kninuꞌ antui nain anmatoom nok atoin ein ia mnak, ‘Sin nitan nrarin, mes ka nromin fa he nahinin. Sin nnenan nrarin, mes ka nromin fa he nakeon.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Onaim Naiꞌ Yesus natoon uab manporin naan in aꞌmoufun am nak, “Finin naan, es reꞌ Uisneno In Kabin ma Prenat. ");
INSERT INTO aaz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fini reꞌ anmoufun anbin ranan, es reꞌ tuaf-tuaf reꞌ annenan Uisneno In Kabin ma Prenat, mes aꞌnaak niut kouꞌ goe neem ma ntetak neik Kabin ma Prenat naan naꞌko sin neek ein. Nok ranan naan, sin ka npirsain fa neu Uisneno, ma sin ka napenin fa saok sanat ma ꞌhonis. ");
INSERT INTO aaz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fini reꞌ anmoufun anbin auf faut-makhapiꞌ, es reꞌ tuaf-tuaf reꞌ anneen Uisneno In Kabin ma Prenat nok neek marine. Mes ka naꞌbaꞌaf. Sin nmurai npirsain, mes karu napenin susat, maan aa fa te, anmoufun. ");
INSERT INTO aaz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fini reꞌ anmoufun anbin auf maꞌaikaꞌ naan, es reꞌ tuaf-tuaf reꞌ annenan ma ntoup Uisneno In Kabin ma Prenat. Mes ka ꞌroo fa te, sin nnikan nain Kabin ma Prenat naan, natuin sin ntaisibun nok sin urusan humaꞌ-humaꞌ ma sin aꞌmuiꞌk ein humaꞌ-humaꞌ, ma sin aꞌmonik reꞌ he nmarin-riin aah. Etun sin neek pirsait naan, ka maꞌafaꞌ fa saaꞌ-saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mes fini reꞌ anmoufun anbin auf amriat naan, es reꞌ tuaf-tuaf reꞌ neek amneꞌo ma reko. Oras sin neen Uisneno In Kabin ma Prenat on naan ate, sin nahiik ma napaan nain sin anbin sin neek ein. Nok ranan naan, sin npirsain piut, ma nmoꞌen rais reko mfaun.” ");
INSERT INTO aaz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Ka neu fa he tout pauk anaꞌ, rarit tait iꞌnai konat ma ttobe. Ma ka tiit tain fa tuaf he nateek paku nbi haark ee nupun. Natuin karu nmoeꞌ on naan ate, of napenin meꞌu on mee ntein? Paku reꞌ mapakeꞌ, es reꞌ toutu trair je te, tateek je nbi baer aꞌratas, he in asnaan ee ntanaꞌ tuaf-tuaf reꞌ antaman neu umi. ");
INSERT INTO aaz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Areꞌ saaꞌ-saaꞌ reꞌ maꞌkoroꞌ oras ia, of mamnitaꞌ. Ma areꞌ kanan rasi reꞌ ka mahiniꞌ fa oras ia, of mahiin ein. ");
INSERT INTO aaz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Onaim hi ro he mitenab mirek-rekoꞌ rasin reꞌ ia. Tuaf reꞌ he naim batuur-batuur Uisneno In romin, in mahinif ma manoef of nafaof gon piut. Mes tuaf reꞌ ka nrae natuin fa Uisneno In romin, in moon goe of nafaof gon piut.” ");
INSERT INTO aaz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Neot es, Naiꞌ Yesus naꞌuab nok too mfaun ein. On nai te, In ainaf ma In oirf ein neman he nateef nok Ne. Mes sin ka bisa npaumak-maak Ee fa, natuin too gui kah een. ");
INSERT INTO aaz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Onaim anmuiꞌ tuaf annao natonan Naiꞌ Yesus am nak, “Aam! Ho ainaꞌ ma sin Ho oriꞌ sin etan moneꞌ. Sin he nateef nok Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Onaim In nataah am nak, “Tua. Mes on nai. Au ainaꞌ ma Au aok-bian sin batuur-batuur ii, es reꞌ tuaf-tuaf reꞌ anneen ma natniin Uisneno In Kabin ma Prenat, rarit anmoeꞌ natuin sin.” ");
INSERT INTO aaz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Neot es, Naiꞌ Yesus naꞌuab neu In atoup noinꞌ ein am nak, “Iim he tsae kofaꞌ he traak teu neof gui panin.” Onaim sin nsaen neu kofaꞌ es, ma nmurai nnaon. ");
INSERT INTO aaz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oras sin nnaon on naan ate, Naiꞌ Yesus antuup. Ka ꞌroo fa te, ain kouꞌ gui neem. Oikn ein anpesan antaman neu kofaꞌ naan. Sin he napenin siraak ein. ");
INSERT INTO aaz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ankisun on naan ate, atoup noinꞌ ein anpooꞌ nafenaꞌ Naiꞌ Yesus am nak, “Usiꞌ! Usiꞌ! Amfeen feꞌ! Hit he treem atmaet jen!” Onaim Naiꞌ Yesus anfeen. Rarit in nakain anin ma okin naan am nak, “Misnaas nai!” Onaim okin am anin nasnaas nanin oras naan. ");
INSERT INTO aaz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Rarit In naꞌuab neu In atoup noinꞌ ein am nak, “Nansaaꞌ am es hi ka mpirsai fa feꞌ meu Kau?” Sin namtaun ma nsanmakan. Onaim sin nmaktaan ein am nak, “Hae! Naiꞌ Yesus ia, sekau? Anmoeꞌ on mee mꞌes ain naꞌ natniin Ee? Oik naꞌ natniin Ee?” ");
INSERT INTO aaz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ka ꞌroo fa te, sin ntean Garasa nbi nefo Galilea in panin. ");
INSERT INTO aaz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Anbi bare naan, anmuiꞌ atoin es reꞌ niut reuꞌf ein ansaen ee ꞌroo-ꞌroo goen. In ka nmuiꞌ fa umi. Onaim in natua nbi haa niut naet ein. Neno-neno te, in nnao neu-mneem ma nꞌaaf-aaf aah. Niut reuꞌf ein napreent ee piut-piut. Biak ein anfuut goe fani-fani npaken korenit ma niit besi, mes in ntiup nafeek sin. Rarit niutn ee naꞌseek ee he naen neu baer ruman naꞌroo naꞌko kuan. Oras Naiꞌ Yesus sin ansanun naꞌkon kofaꞌ, amaunut naan neem anꞌain Je. Rarit amaunut naan ankoaꞌ ma nsuban in tuan ee neu Naiꞌ Yesus In haen. Onaim Naiꞌ Yesus naprenat am nak, “Hoe nitu! Ampoi muꞌko atoniꞌ ia!” Onaim amaunut naan nkoaꞌ am nak, “Hoe, kais musein kau! Natuin au uhiin ꞌak Ho reꞌ ia, Naiꞌ Yesus, Uisneno Aꞌraat Reꞌuf In Anah! Ho kais amhaꞌmuiꞌ kau!” ");
INSERT INTO aaz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naiꞌ Yesus nataan ee mnak, “Ho kaan maan sekau?” Onaim nitu naan nataah am nak, “Legion, natuin hai mimfau, on reꞌ sorarus nifun-nifun.” In naꞌuab on naan, natuin nmuiꞌ nitu mfaun antaman ma natuan et na. ");
INSERT INTO aaz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitun naan antoit Naiꞌ Yesus piut he reko te, kais anreun sin he nnaon neu Koon Haꞌmuꞌit, es reꞌ bare reꞌ npaek je he ntahan kuasat maufinu sin. ");
INSERT INTO aaz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mes anpaumak-maak bare naan, anmuiꞌ naan fafi pukan kouꞌ goes anꞌoobn ein anbin aꞌtoeꞌf ee ninin. Onaim nitun naan antotin Naiꞌ Yesus am nak, “Amreun kai he hai mtaam meu fafin nee!” Onaim Naiꞌ Yesus anroim natuin sin. ");
INSERT INTO aaz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Rarit nitun naan anpoin nnaon nasaitan atoniꞌ naan, ma ntaman neun fafin naan. Fafin naan ok-okeꞌ njarin faif amaunut, rarit sin naenan nsiksaakn ok ma nasroro nsanun naꞌkon ꞌtoꞌef naan, ma nmoufun ntaman naꞌkon aisanut neun neof goe nanan. Onaim sin nreem anmaten ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ankius nitan on naan ate, ahao fafin naan naenan neun kuan-kuan anbin naan, ma natonan abitan baren naan ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Anneen anrarin sin uab ein on naan ate, too mfaun ein neman neu bare naan. Sin he nitan kuuk saaꞌ reꞌ anjari nbi naan. Antean naan ate, sin niit atoin amaunut naan antoko ntaaꞌ-taaꞌ npaumaak Naiꞌ Yesus In haek ein. In npake nrair, ma in maun goe namneku nrair. Ankisun on naan ate, sin arsin namtaun. ");
INSERT INTO aaz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Rarit tuaf ein reꞌ feꞌe na niit rasi naan, natoon neu amneemt ein naan nak, anmoeꞌ on mee mꞌes naꞌ amaunut naan, nareok. ");
INSERT INTO aaz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Onaim abitan Garasa sin arsin reꞌ natuan anbin bare naan, antoit Naiꞌ Yesus he nnao nasaitan sin, natuin sin arsin namtaun nmaten. Onaim Naiꞌ Yesus sin ansaen nfanin neu kofaꞌ, he nnaon nfanin neun nefo Galilea in panin. ");
INSERT INTO aaz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mes amaunut reꞌ nareko nrair feꞌe na, ntoit nafan-fain neu Naiꞌ Yesus am nak, “Aam! Reko te au utuin Ko, tua!” Mes Naiꞌ Yesus nataah am nak, ");
INSERT INTO aaz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“On nai! Reko nneis ho mfain meu ho nonot-asar sin, ma mutonan sin Uisneno In arekon, reꞌ anmoꞌe nrair je neu ko.” Rarit atoniꞌ naan annao nfuun natef-tefan kota, nmurai natoon neu sekau-sekau goah anmatoom nok Naiꞌ Yesus reꞌ nareokꞌ ee naan. ");
INSERT INTO aaz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Rarit Naiꞌ Yesus sin nsaen kofaꞌ ma nfanin neun nefo Galilea in panin. Oras sin nsanun naꞌkon kofaꞌ naan, too mfaun ein anpao nain Je. Sin neman nseit-seitn ok he nseun Goe. ");
INSERT INTO aaz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Anbi naan, nmuiꞌ atoin es, kaan ee naiꞌ Yairus. In reꞌ naan, aꞌnaak uim onen anbi kota naan. In aan feot goe meseꞌ, anmoin naan toon boꞌes am nua goen. Oras ia, riꞌaan feto naan nameen maꞌfenaꞌ, ma he nmaet jen. Oras naiꞌ Yairus niit Naiꞌ Yesus In amneman naan, in nnao nseun Goe ma nriꞌtuu nbi In matan. In naskau Naiꞌ Yesus he nnao neu in umi, he nturun naan in aan feto. Naiꞌ Yesus nataah ee mnak, “Tua.” Onaim sin nnaon neu naiꞌ Yairus in umi. Mes too mfaun ein ka ntahan naan fa sin tuak ein he nokan. Onaim sin nnaon nseit-seitn ok. ");
INSERT INTO aaz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Anmuiꞌ naan bifee jes nnao nok anbi naan. In meen funan nroni kreꞌo-kreꞌo ka natfeek niit fa oniꞌ toon boꞌes am nua goen. In narair in roit ma in aꞌmuiꞌk ein ok-okeꞌ oras in npairoir in tuan, reꞌ he nbaen apairoirt ein. Mes ka tiit tain fa apairoirt es reꞌ nareokꞌ ee. Menas naan nfoe piut. ");
INSERT INTO aaz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Onaim in neem anpaumak-maak Naiꞌ Yesus nbi In kotin. Rarit in nreoꞌ naan kuun Naiꞌ Yesus In baur goe tukan. Anreꞌo nrair on naan ate, in naaꞌ aronit naan, nasnaas nain. ");
INSERT INTO aaz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nok askeken ate, Naiꞌ Yesus nasnaas ma nhaek. In nataan am nak, “Sekau es reꞌ anreoꞌ Kau?” Mes ka tiit fa tuaf es reꞌ anmanakuꞌ msaꞌ. Rarit naiꞌ Petrus nak, “Usiꞌ msaꞌ, Ho es-es! Ho ka miit fa neu too mfa-faun ein ia nmakseit ein! Sin es reꞌ anmatiitr ein naꞌkon kotin.” ");
INSERT INTO aaz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mes Naiꞌ Yesus nak neu ne mnak, “Kahaf! Feꞌe na Au ꞌnaben ate, anmuiꞌ kuasa npoi naꞌko Kau. Onaim Au uhiin ꞌak tuaf es anreoꞌ Kau.” ");
INSERT INTO aaz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Oras bifee naan nnaben nahiin neu in ka bisa naꞌkoroꞌ fa te, in nmurai namtau nmaet. In naꞌtaꞌi ma nriꞌtuu nbi Naiꞌ Yesus In matan. Rarit in naretaꞌ sin in rasi, nmurai naꞌko in uun-aꞌbaꞌan. In natoon am nak, oras in nreoꞌ Naiꞌ Yesus on naan ate, in nareok nain. ");
INSERT INTO aaz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Rarit Naiꞌ Yesus naꞌuab neu na mnak, “Fetoꞌ! Ho mureok, natuin ho mpirsai Kau. Amfain nai nok mamut!” ");
INSERT INTO aaz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Oras Naiꞌ Yesus naꞌuab feꞌ nok bifee naan ate, tuaf es naꞌko naiꞌ Yairus in umi neem natoon am nak, “Airoo, aam! Ho aanh ee, ain ee oekꞌ ein! Onaim kais muhaeb Aam Tungguru.” ");
INSERT INTO aaz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mes oras Naiꞌ Yesus anneen uabaꞌ naan ate, In nak neu naiꞌ Yairus am nak, “Baꞌe. Amtaaꞌ kuum! Kais neekm aan nabait! Ampirsai meu Uisneno. In es reꞌ narekoꞌ ho anah, maut he in nmoin.” ");
INSERT INTO aaz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Oras sin ntean naiꞌ Yairus in umi, too gui naheun nanin. Sin nkaen npin-piuns ein. Naiꞌ Yesus nakain sin am nak, “Hi misnasab hi kaet ein nai! Riꞌanaꞌ ia ka nmatef. In ntuup kuun!” Mes too mfaun ein anmanin nfaer Ee, natuin sin nitan nok sin matak fuak ein nak, riꞌanaꞌ naan natfeek. Rarit Naiꞌ Yesus antoit riꞌanaꞌ naan in ainaf-amaf, naiꞌ Petrus, naiꞌ Yohanis, ma naiꞌ Yakobus, he sin ntaman buꞌ-buaꞌ nok Ne. Biak ein In nreun sin he npaon nbin moneꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sin ntaman nrarin ate, Naiꞌ Yesus annaaꞌ riꞌanaꞌ naan in aꞌniman, ma nhaamn ee mnak, “Nona! Amfeen nai!” ");
INSERT INTO aaz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nok askeken ate, riꞌanaꞌ naan anmoni nfain, ma in nfeen nain. Rarit Naiꞌ Yesus anreun riꞌanaꞌ naan in ainf ee mnak, “Amfee ne he nbukae!” ");
INSERT INTO aaz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Riꞌaan feto naan in ainaf-amaf ansanmakan nmaten. Mes Naiꞌ Yesus namnaubaꞌ sin, he kais natoon rasi naan neu tuaf bian sin. ");
INSERT INTO aaz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Neot es, Naiꞌ Yesus nabuab In atoup noinꞌ ein tuaf boꞌes am nua. Rarit In ntaon sin kuasa he bisa nriꞌun niut reꞌuf, ma narekoꞌ menas humaꞌ-humaꞌ naꞌko amenat sin. ");
INSERT INTO aaz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","In nreek sin he nnaon ma natonan anmatoom nok Uisneno In aprenat. In anreek sin imsaꞌ he narekoꞌ amenat anbin mee-mee. ");
INSERT INTO aaz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mes In natoon neu sin am nak, “Mimnau mirek-rekoꞌ. Hi kais meik saaꞌ-saaꞌ ambi ranan. Amnao nai, mpake haa baru meseꞌ. Kais meik teas, ai aꞌkapiꞌ, aiꞌ oe-betiꞌ, aiꞌ roit. Kais meik tai senuꞌ msaꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Karu hi mtaam meu kuan es, ma nmuiꞌ tuaf antoup ki, amtuup ambi sin uim naan. Kais ampiir umi. Mitua mbi reꞌ naan, tar antea hi mnao misaitan kuan naan. ");
INSERT INTO aaz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Karu hi mtaam meu kuan es, rarit abitan kuan naan ka nroim he ntoup ma ka nroim he nneen ki fa te, ampoi mnao misaitan sin. Oras hi mpoi mnao misaitan sin naan, hi mtao maan acara es natuin harat: amtekar askukuꞌ naꞌko hi haem ein naan. Mitonan sin am mak, ‘Hi ka mroim fa he mitniin ate, maut he hi mitaah kiim!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Rarit atoup noinꞌ ein naan, annaon naꞌkon kuan neu kuan. Sin natonan ma nasinaꞌ neu tuaf-tuaf namfaun anmatoom nok Uisneno In Rais Reko. Rarit sin narekoꞌ ameent ein amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Oras naan, Usif Herodes Antipas anneen anrair beno humaꞌ-humaꞌ anmatoom nok Naiꞌ Yesus. Anneen uab ein naan ate, in ntakaꞌnanaꞌ, natuin tuaf fauk nak, “Naiꞌ Yesus naan, es reꞌ naiꞌ Yohanis Asranit reꞌ anmoni nfain.” ");
INSERT INTO aaz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bian anteniꞌ nak, “In reꞌ naan kaꞌo Elia reꞌ anmoni nfain.” Bian anteniꞌ nak, “In reꞌ naan, tuaf es naꞌko Uisneno In mafefa kninuꞌ bian un-unuꞌ sin.” ");
INSERT INTO aaz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mes naiꞌ Herodes namnau mnak, “Neon goes ii, au ꞌreek tuaf ankeut naiꞌ Yohanis in aꞌnakan. In nmoni nfani, oo? Rarit tuaf reꞌ ia, sekau ntein?” Onaim in nꞌusaha he nateef nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Neot es, atoup noinꞌ ein reꞌ Naiꞌ Yesus anreek haefan sin naan, sin nfain neman ma nabuan nfanin nok Ne. Sin natonan neu Ne areꞌ kanan rasi reꞌ sin anmoꞌen nrair sin. Rarit Naiꞌ Yesus nok In atoup noinꞌ ein annaon amninuꞌ-mninuꞌ neun baer jes anpaumaak kuan Betsaida, he nasnasan akreꞌo nbin naan. ");
INSERT INTO aaz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mes too mfaun ein nakeon neu sin he nnaon nꞌanin mee, rarit sin naꞌiuk Naiꞌ Yesus sin anbin sin koitk ein. Onaim Naiꞌ Yesus antoup sin, rarit In narekoꞌ ameent ein ok-okeꞌ, ma In natoon neu sin Uisneno In aprenat. ");
INSERT INTO aaz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Oras maans ee he noi nmouf on naan ate, In atoup noinꞌ ein boꞌes am nua, neman ma neikin haan totis am nak, “Aam! Reko nneis Ho mreun too mfa-faun ein ia he nnaon neu kuan-kuan reꞌ anmapaumaakn ein etan bare ia, he sin bisa napenin kuuk amnahat. Ma sin namin bare he ntupan ntaah ein. Natuin baer ruman on reꞌ ia te, sin he napenin amnahat on mee?” ");
INSERT INTO aaz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Mes Naiꞌ Yesus nataah am nak, “On nai! Hi ro he mtuthae sin!” Mes sin nprotees ein am nak, “Hee! Amaꞌ msaꞌ, Ho es-es! Too mfa-faun ein reꞌ ia, nifu niim anneis-neis. Nana feꞌ atoin ein, bifeen guin ma riꞌaan ein ka masoꞌik fa feꞌ! On nai te, hit utuun ein suma fuaꞌ niim aah, ma iikꞌ ein fuaꞌ nua goah. Onaim Aam. Karu Ho mroim he hai mtuthae too mfaun ein ia, hai he mmoeꞌ on mee he msoos maan amnahat meu sin?” Rarit Naiꞌ Yesus anreun sin am nak, “Amꞌator sin he ntokon pukan-pukan. Pukan es ate, tuaf boꞌ niim.” ");
INSERT INTO aaz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Onaim sin nnaon nꞌaotr ein on naan. ");
INSERT INTO aaz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oras sin ntokon on naan ate, Naiꞌ Yesus nait utuun fua niim ein naan, ma iik fua nuaꞌ ein naan. Rarit anbaiseun, ma nꞌonen nasaeb sukuur ma makasi. Rarit In nteib utunuꞌ ma iikꞌ ein naan. Onaim In nnonaꞌ neu In atoup noinꞌ ein he nnaon nbatin neu too mfaun ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sin ar-arsin anbukaen tar namsenan. Rarit amnaah neisf ein naan, sin nabuab nafaniꞌ sin anbin aꞌkoraꞌ boꞌes am nua nahen-henun. ");
INSERT INTO aaz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Neot es, Naiꞌ Yesus anmes-mese nꞌonen nbi baer jes. Rarit In atoup noinꞌ ein neman ma nabuan nok Ne. Anꞌonen anrari te, In nataan sin am nak, “Hi mneen biak ein naꞌuab ein neu Kau te, nak Au reꞌ ia, sekau?” ");
INSERT INTO aaz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sin natahan am nak, “Bian nak, Ho reꞌ ia, naiꞌ Yohanis Asranit. Bian antein nak, of oniꞌ Ho reꞌ ia, kaꞌo Elia. Karu kaah fa te, tuaf es naꞌko Uisneno In mafefa kniunꞌ ein un-unuꞌ reꞌ anmoni nfain.” ");
INSERT INTO aaz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Onaim Naiꞌ Yesus nataan sin anteniꞌ mnak, “Karu natuin hi peint ein ate, hi mak Au reꞌ ia, sekau?” Rarit naiꞌ Petrus nataah am nak, “Aam. Ho reꞌ ia Kristus, Tuaf reꞌ Uisneno nruur nain Je naꞌko unuꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rarit Naiꞌ Yesus antaar sin maꞌtaniꞌ, he kais natonan neu sekau-sekau, nak In reꞌ naan, Kristus. ");
INSERT INTO aaz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Au reꞌ ia, Mansian Batuur-Batuur. Au ro he usaah maꞌneꞌat ma maꞌfenaꞌ humaꞌ-humaꞌ. Atoni mnais harat Yahudi sin, aꞌnaak rais pirsait Yahudi sin aꞌnaakt ein, ma tunggur agaam ein ka nromin fa he ntoup Kau nak, Au Kristus Kau. Rarit sin of naꞌmaet Kau. Batuur Au ꞌmaet, mes anmeu te, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Rarit In naꞌuab neu too mfaun ein am nak, “Sekau-sekau reꞌ anroim he natuin Kau, in ro he naran piut ma natuin Kau neno-neno! In ro he nporin nain in roimn ein kuun. In ro he natuin piut-piut, maski he naꞌmaet je msaꞌ, nahuum on reꞌ atoniꞌ nasaah hau nehe he nnao neu bare ꞌmaten. ");
INSERT INTO aaz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tuaf reꞌ nabaarb on he nmaet natuin in nok Kau, in of anmoin piut nok Uisneno. Mes neu tuaf-tuaf reꞌ suma nroim he nmoin neu in tuan aa kuun, of in mabetis naꞌko Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Karu tuaf es napein nain pah-pinan ia in afan neesn ii barisi, mes Uisneno ntitar napoitn ee, in napeni mnisat saaꞌ? ");
INSERT INTO aaz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Au reꞌ ia, Mansian Batuur-Batuur. Onaim karu sekau-sekau namaeb on neu In natuin Kau, ma namaeb on neu in annaaꞌ Au noinꞌ ein, Au msaꞌ of umaeb Ok he ꞌmanauk ee ꞌbi Uisneno In human ma In matan, oras Au ꞌfain ꞌuum uꞌko sonaf neno tunan. Fin Au of aꞌfain ꞌuum ꞌeik Amaꞌ In kuasat reꞌ npiin ma nakraah reko, ubua ꞌok In ameupt ein naꞌkon sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Au utoon ki batuur-batuur. Anmuiꞌ naan tuaf fak-fauk naꞌko hi arki reꞌ ia, of nitan kuuk nok sin matak fuak ein Uisneno In Aprenat, rarit naꞌ sin bisa nmaten.” ");
INSERT INTO aaz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Neno fanu nkono te, Naiꞌ Yesus nok naiꞌ Petrus, naiꞌ Yohanis, ma naiꞌ Yakobus annao neikin nsaen neu ꞌtoꞌef he nꞌoen ein. ");
INSERT INTO aaz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oras Naiꞌ Yesus anꞌonen on naan ate, In maasn ee naꞌbaniꞌ, ma In paekn ein narim-riman. ");
INSERT INTO aaz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nok askeken ate, tuaf nua npoi neman. Tuaf nua reꞌ naan, es reꞌ kaꞌo Musa ma kaꞌo Elia. Onaim sin nua sin naꞌuab ein nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sin mamnitaꞌ nbin pinaꞌ ma krahaꞌ. Sin teun sin naꞌuab ein anmatoom nok Naiꞌ Yesus In aꞌmaten anbi kota Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oras naan, naiꞌ Petrus nok in partein tuaf nua naan, anreur ein reꞌ-reꞌuf, onaim sin ntupan. Oras sin anfenan ate, sin niit Naiꞌ Yesus anhaek nok atoniꞌ nua. Sin niit Naiꞌ Yesus namaas rimat amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oras kaꞌo Musa ma kaꞌo Elia he nfanin on naan ate, naiꞌ Petrus ankeuk. In ka nahiin neu he nmoeꞌ saaꞌ. Onaim in naꞌuab taif aah am nak, “Usiꞌ! Hit tbi ia te, naꞌ reko, joo! Onaim reko nneis hai mihakeꞌ maan raꞌat teun. Es neu Ko, Usiꞌ, es neu kaꞌo Musa, ma es antein neu kaꞌo Elia.” ");
INSERT INTO aaz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mes oras in naꞌuab feꞌ on naan ate, niup ee nsaun ma npuput naan sin. Rarit naiꞌ Petrus sin namtaun. ");
INSERT INTO aaz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Onaim sin nnenan hanaf naꞌko nipuꞌ naan in nanan am nak, “Au Anah reꞌ ia, Au ꞌpiir ain Je! In naꞌuab saaꞌ-saaꞌ ate, amneen mirek-rekoꞌ meu Ne.” ");
INSERT INTO aaz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hanaf naan okeꞌ te, naiꞌ Petrus sin niit Naiꞌ Yesus anmes-mees. Sin teun sin nfeef aꞌtemen. Sin ka natoon fa neu sekau-sekau saaꞌ reꞌ sin nitan nrair je naan. Aꞌroo-ꞌroo te, naꞌ sin nmurai natoon ee neu tuaf bian. ");
INSERT INTO aaz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nokaꞌ on naan ate, oras Naiꞌ Yesus ma naiꞌ Petrus sin nsanu nfanin naꞌkon aꞌtoꞌef naan, too mfaun ein neman ma nateef nok Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Onaim anmuiꞌ naan tuaf es ankoaꞌ Ee mnak, “Aam Tungguru! Amturun maan kau nok au aan mone. Airoo, in fuaꞌ meesꞌ aah, tua! ");
INSERT INTO aaz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anmuiꞌ niut reꞌuf annaaꞌ ee, anmoeꞌ je ma naskeke te, nkoaꞌ. Kroo te, nkoaꞌ ma nasteet ee, tar antea haep bua neorn ee npoi npeoꞌ in fefan. Nitu naan nbaan nafan-fainꞌ ee msaꞌ, ma noik je piut-piut. ");
INSERT INTO aaz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au ꞌtoit Ho atoup noinꞌ ein he nturun kau, he reko te, nitu naan anpoi naꞌko au anah. Mes ka nabeiꞌ je fa, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Anneen on naan ate, Naiꞌ Yesus naskarak sin ok-okeꞌ mnak, “Hae! Hi ka mpirsai fa mmak Uisneno bisa narekoꞌ tuaf? Hi ro batuur-batuur mansian reꞌ ka mmoin fa mbi raan amneꞌo! Au ro he ꞌok ki ꞌtea rekaꞌ, he naꞌ hi mpirsai meu Kau? Au he ꞌsabaar ꞌeu ki ꞌtea mee ntein?” Rarit In nabaniꞌ neu ꞌnaef naan am nak, “Meik riꞌanaꞌ naan neem neu ia!” ");
INSERT INTO aaz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Oras sin neik riꞌanaꞌ naan neu Naiꞌ Yesus, niut maufinu naan naꞌteet ee ma npeesk ee neu afu. Mes Naiꞌ Yesus naprenat niut goe he npoi nasaitan riꞌanaꞌ naan. Onaim in nareok nain. Rarit Naiꞌ Yesus annonaꞌ riꞌanaꞌ naan neu in amaf. ");
INSERT INTO aaz_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Too mfaun ein reꞌ niit Uisneno In kuasa maꞌtaniꞌ naan, sin ar-arsin ansanmakan batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Oras too mfaun ein ok-okeꞌ feꞌ naꞌuab ein anmatoom nok rais sanmaakt ein reꞌ Naiꞌ Yesus anmoeꞌ sin naan, In natonan In atoup noinꞌ ein am nak, ");
INSERT INTO aaz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Hi mtanar mirek-rekoꞌ Au uabak ia! Ka ꞌroo fa nteniꞌ te, tuaf naꞌsosaꞌ Kau, Mansian Batuur-Batuur reꞌ ia. Rarit sin naꞌnaꞌat Kau neu atoni ꞌteetꞌ ein.” ");
INSERT INTO aaz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mes In atoup noinꞌ ein ankekun. Sin ka nahinin fa neu In sairt ii saaꞌ. Sin he nataan in aꞌmouf ne amsaꞌ, namtaun. ");
INSERT INTO aaz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Neot es, Naiꞌ Yesus In atoup noinꞌ ein anmatoen rasi anmatoom neu sekau of es reꞌ anjair tuaf ahunut anbi maat. ");
INSERT INTO aaz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mes Naiꞌ Yesus nahiin sin rais matoes naan. Onaim In noꞌen naan riꞌaan es, rarit nahaek ee nbi In aon-bian. ");
INSERT INTO aaz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Rarit In natoon neu sin am nak, “Amneen mirek-rekoꞌ! Tuaf reꞌ natuin Kau ma ntuthae tuaf bian on reꞌ riꞌanaꞌ reꞌ ia, in aꞌmoufn ii nak, naan in ntuthae Kau msaꞌ. Ma in antuthae Au Amaꞌ et sonaf neno tunan amsaꞌ reꞌ anreek haefan Kau ꞌuum ꞌeu pah-pinan ia. Anmuiꞌ tuaf amfaun ankius nasbiin aah tuaf bian. On reꞌ atoin kasian, asusat, atoin ka mapakeꞌ fa, amaufinut, aꞌbaut. Hoe! Atoniꞌ reꞌ nroim he ntuthae tuaf-tuaf ein on reꞌ naan, Uisneno naan sin on atoin maꞌtaniꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Rarit naiꞌ Yohanis natoon neu Naiꞌ Yesus am nak, “Usiꞌ! Neot es, hai miit atoin es anriuꞌ niut reꞌuf te, anteek Ho kanam. Onaim hai mtaar ee, he kais anteek Ho kanam naan, natuin in ka hit ja fa, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mes Naiꞌ Yesus nataah am nak, “Kais on naan! Natuin atoniꞌ reꞌ ka nraban kit fa te, in oetn ii nak, naan hit partein ngguin kuuk.” ");
INSERT INTO aaz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Naiꞌ Yesus nahiin nak, In oras he nsae neu sonaf neno tunan naan anpaumaak een. Rarit In nafeek he nnao neu kota Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","In nreek haef he nnao nahuun naꞌko sin, he sin bisa nꞌator bukaet. Onaim haef ein naan antaman neun kuan es et propinsi Samaria he nꞌurus uim tupas. ");
INSERT INTO aaz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mes abitan Samaria sin ka nromin fa he ntoup Naiꞌ Yesus sin, natuin In he nnao naꞌbesan Uisneno neu kota Yerusalem. ");
INSERT INTO aaz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Oras naiꞌ Yakobus ma naiꞌ Yohanis annenan nak abitan Samaria sin iꞌmoeꞌk ein on naan ate, sin nfuriꞌ Naiꞌ Yesus am nak, “Usiꞌ! Reko te hit ttoit Uisneno he nasanut ai he nout nakratiꞌ sin.” ");
INSERT INTO aaz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mes Naiꞌ Yesus nabaniꞌ neu sin nua sin, ma nakain sin am nak, “Kais mitenab on naan.” ");
INSERT INTO aaz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Rarit sin nnaon nkonon neu kuan bian. ");
INSERT INTO aaz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oras sin nnaon on naan ate, anmuiꞌ atoin es naꞌuab neu Naiꞌ Yesus am nak, “Aam! Ho mnao mꞌain mee-mee jah, au utuin Ko piut, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mes Naiꞌ Yesus nataah am nak, “Reko msaꞌ! Mes mumnau. Areꞌ mansian ein ma muiꞌt ein anmuꞌin bare he natuan. Aus fui ji nfain neu in nuat he ntuup. Koor gui nfain neu in kunaꞌ. Mes Au, Mansian Batuur-Batuur ia, Au ka ꞌmuiꞌ kuuk fa umi he ꞌfain ꞌeu na. Akaꞌnunuꞌ msaꞌ, Au ka ꞌmuꞌif.” ");
INSERT INTO aaz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Neot es, Naiꞌ Yesus noꞌen tuaf es anteniꞌ mnak, “Uum he mutuin Kau, he mjair Au ngguin.” Mes tuaf naan nataah am nak, “Reko, tua! Mes, on nai feꞌ, Usiꞌ! Maut he au ꞌfain he ꞌurus ꞌaan mahoin ein ne feꞌ. Karu au amaꞌ nmate nrari te, naꞌ au ꞌuum he utuin Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mes Naiꞌ Yesus naꞌuab neu ne mnak, “On nai! Maut he tuaf-tuaf reꞌ ka npirsain fa neu Uisneno, nꞌurus amaets ein. Mes hi, reꞌ ampirsai meu Uisneno, hi meup gui es reꞌ he mnao minaobaꞌ Uisneno In Aprenat.” ");
INSERT INTO aaz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Anmuiꞌ tuaf es anteniꞌ naꞌuab am nak, “Usiꞌ! Au he utuin Ko piut-piut. Mes mfee maan kau mainuan akreꞌo he au ꞌnao ꞌmataeb aan ꞌok au nonot-asar sin feꞌ, naꞌ au ꞌuum he utuin Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mes Naiꞌ Yesus natoon ee mnak, “On nai! Karu tuaf anmurai nꞌoet nabaniꞌ afu, rarit antaisibu ntein urusan bian tar antea nnikan nain neu he nseen, in rene naan ka njarif. On naan amsaꞌ neu tuaf-tuaf reꞌ nafeek he natuin Kau, mes namnau piut-piut in aꞌmonin unuꞌ naan. Tuaf on reꞌ naan, ka mapakeꞌ fa njair ameput anbi Uisneno In aprenat.” ");
INSERT INTO aaz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Rarit Naiꞌ Yesus anpiir naan atoup noniꞌ bian antein, tuaf boꞌ hitu mnua (72). Rarit In nbait sin tuaf nu-nua, he nnaon nahunun neun bare-bare reꞌ In he ntaman sin. ");
INSERT INTO aaz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","In nreek haefan sin neik uab manbasan am nak, “Too mfaun ii on reꞌ makaꞌ reꞌ namnatu nrair et rene. Arahaa he reen tuaf ee nreun tuaf he nnaon nonun. Onaim hi ro he mꞌonen amtoit Uisneno he nreek naꞌbabaꞌ In tuaf ameput antein he naꞌbuaꞌ tuaf-tuaf reꞌ he natuin Kau. Natuin tuaf reꞌ he natuin Kau naan, amfaun. Mes tuaf ameupt ii, fuꞌ-fuaꞌ aah. ");
INSERT INTO aaz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Oras ia, mnao nai! Au ꞌreek haefan ki he mnao meu too mfaun ein. Mes mimnau. Hi on reꞌ ꞌbib-kaes anaꞌ reꞌ in neekn ee reko, reꞌ annao ma natua nbi aus fuin apiust ein sin atnaank ein. ");
INSERT INTO aaz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hi kais meik roit, aiꞌ tas he mpaan tais, aiꞌ pein-haef bian. Kais amporin oras he mmaseen ruum-ruum mok es ambi ranan. ");
INSERT INTO aaz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Karu hi he mtaam meu kuan es, hi kais mitnain umi, miꞌko uim jes meu umi bian. Karu atoniꞌ ntoup ki nok rek-reko te, mitua mbi naan, tar antea hi mnao mtein meu kuan bian. Karu hi mtaam meu uim jes, hi ro he mtoit Uisneno he nfee tetus neu tuaf anbi umi naan. Karu uim tuaf naan antoup ki nok rek-reko, Uisneno of nakriraꞌ In nekan arekot neu uim tuaf ein naan. Mes karu sin ka nromin fa he ntoup ki te, maut he Uisneno nakriraꞌ In nekan arekot naan neu haa ki mmees. Karu hi mtaam meu uim jes, aiꞌ kuan es, miah am miun saaꞌ-saaꞌ aah reꞌ sin nnonaꞌ ki sin. Amtoup sin nok neek marine, fin sin nfee sin he nseun banin hi maskeet ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mirekoꞌ sin ameent ein. Ma mitonan sin am mak, ‘Uisneno In aprenat et hi maatm ein aan!’ ");
INSERT INTO aaz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mes kuan bian sin tuak ein ka nromin fa he ntoup ki. Karu sin nmoꞌen on naan neu ki te, mnao mhaek meu kuan naan in ranan ma miꞌuab am mak, ");
INSERT INTO aaz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Amneen mirek-rekoꞌ! Hai iim meik Uisneno In Kabin ma Prenat neu ki, mes hi ka mrae mituin fa kreꞌ-reꞌo msaꞌ. Onaim oras ia, hai mtekar askukuꞌ naꞌko hai haem ein ia, he njair tanar nak, hi of mitaah ma misaah kiim in aꞌmoufun! Mes mimnau mirek-rekoꞌ! Uisneno In aprenat et hi maatm ein aan!’ ");
INSERT INTO aaz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hi mihiin kota Sodom in maufinun, aiꞌ? Au utoon ki, he! Nateef neon amsoupt ee te, of Uisneno nasanut hukun neu tuaf-tuaf reꞌ antorak ki, maꞌfenaꞌ nneis naꞌko abitan Sodom!” ");
INSERT INTO aaz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Naiꞌ Yesus antuta ntein am nak, “Hi abitan kuan Korasin ma kuan Betsaida, ampaant om, oo! Siraak ee of ansaen ki! Au ꞌmoeꞌ rais sanmakat humaꞌ-humaꞌ ꞌbi hi humam ma hi matam, mes hi ka mroim fa he mpirsai meu Uisneno. Te kaah, hi reꞌ ia, atoin Yahudis reꞌ ammanakuꞌ mmak hi mihiin Je. Mes karu rais sanmaakt ein reꞌ Au ꞌmoeꞌ sin aꞌbi hi kuan naan, anjair tanar anbi kota Tirus ma kota Sidon, abitan naan bait sin naꞌpisan aꞌroo-ꞌroo goen, ma nasaitan sin saant ein, rarit natuin Uisneno. Bait sin imsaꞌ anpaken tai-nukat, ma ntaon afu nbin sin aꞌnaak ein he njair tanar nak, sin nmeiꞌ jok naꞌkon sin saant ein. Te kaah, abitan Tirus ma Sidon sin, ka atoin Yahudis fa reꞌ anmanakuꞌ nak sin nahiin Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Batuur! Hi mkius kiim! Karu Uisneno nafeek nain areꞌ kanan rasi naꞌko too mfaun ein, abitan Tirus ma Sidon sin napenin hukun maꞌkafaꞌ nneis naꞌko hi nggoan. ");
INSERT INTO aaz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ampaant om, hi abit Kapernaum! Hi kais mitenab am mak, Uisneno of nait ki msae meu sonaf neno tunan on ahaa reꞌ naan. Kaah fa, tua! Uisneno of nait inporin ki meu ai maputuꞌ mararaꞌ abar-barat, tua! ");
INSERT INTO aaz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mimnau mirek-rekoꞌ! Tuaf-tuaf reꞌ anneen ki, humaꞌ meseꞌ on reꞌ anneen Kau. Mes tuaf-tuaf reꞌ ka nromin fa he nneen ki, humaꞌ meseꞌ on reꞌ ka nromin fa he nneen Kau. Saaꞌ antein, tuaf-tuaf reꞌ ka nroim fa he nneen Kau naan, humaꞌ meseꞌ on reꞌ sin ka nroim fa he nneen Uisneno, reꞌ anreek haefan Kau ꞌtaam ꞌuum ꞌeu pah-pinan ia.” ");
INSERT INTO aaz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Oras haef tuaf boꞌ hitu mnua (72) anfain neman, sin neek ein anmarinan. Sin nmurai naretaꞌ neu Naiꞌ Yesus am nak, “Maꞌtain besi, atoin ein! Oras hai mpaek Ho kaanm aan, he mriuꞌ mipoitan niutn ein, nitun naan sin natniin kai, onaim sin npoi nanin!” ");
INSERT INTO aaz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Onaim Naiꞌ Yesus nataah sin im nak, “Tua! Oras hi mmoeꞌ on naan ate, Au ꞌiit Uisneno anfain-firin niut reuꞌf ein nok sin aꞌnaakt ee naꞌko neno, on reꞌ rimat nariim ꞌrii-ꞌneꞌu. ");
INSERT INTO aaz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mimnau, joo! Niut reuꞌf ein sin aꞌnakat naan, hit musu. Ma in anmuiꞌ kuasa msaꞌ! Mes Au ꞌfee ꞌrair ki kuasa, he mireuꞌ main in kuasa naan. Onaim karu hi mteir maan kaun araut ein, aiꞌ kbiti te, hi ka mimeen fa saaꞌ-saaꞌ. Ka tiit fa tuaf reꞌ he bisa nsirakab ki. ");
INSERT INTO aaz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hi neekm ein anmarinan, natuin niut reuꞌf ein natniin ki. Naan reko msaꞌ, mes rasi naan, aanꞌ aah! Reko nneis hi neekm ein anmarinan, natuin Uisneno antui hi kaanm ein he mjair In too ngguin reꞌ antaman neun sonaf neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Oras naan, Uisneno In Asmaan Akniunꞌ ee, nmoeꞌ Naiꞌ Yesus In neekn ee nmariin. Rarit In nboꞌis Uisneno mnak, “Koi, Aam Uisneno! Ho es reꞌ amjair Uis Koꞌu et neno tunan ma pah-pinan. Au ꞌtoit makasi kouꞌ-koꞌu, natuin Ho mpuput-muꞌkoroꞌ maan rasin ia naꞌkon atoin ein reꞌ sin naan sin tuak ein anjarin atoin ahinit ma abeoꞌt ein. Mes Ho mukriraꞌ rasin reꞌ naan ok-okeꞌ meu riꞌaan ein ma tuaf-tuaf reꞌ nmuiꞌ neek aꞌparat. Batuur! Naan anharineb Ho nekam, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Rarit Naiꞌ Yesus natoon neu too mfaun ein am nak, “Amneen, oo! Au Amaꞌ et sonaf neno tunan, anfee nrair Kau areꞌ kanan kuasa sin ok-okeꞌ. Suma Au Amaꞌ nmees jah, es reꞌ nahiin Kau rek-reok gui nak, Au reꞌ ia sekau. Ma suma Amaꞌ In Anah, es reꞌ Au, es reꞌ uhiin Au Amaꞌ urek-reokꞌ ee ꞌak, Amaꞌ naan sekau. Ma Au ꞌpiir tuaf-tuaf bian sin, he utonan sin, maut he sin nahiin Je rek-reko msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Rarit Naiꞌ Yesus nabaniꞌ nꞌain In atoup noinꞌ ein am natonan sin nmes-mesen am nak, “Hi mꞌua-reok batuur-batuur, natuin hi miit Uisneno In kuasan. ");
INSERT INTO aaz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uisf ein ma mafefa kniunꞌ ein un-unuꞌ te, anmarinan nmaten he nitan kuuk saaꞌ reꞌ hi miit kiim sin, mes ka bisa fa. Sin anmarinan nmaten he nnenan kuuk saaꞌ reꞌ hi mneen sin, mes ka bisa fa msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Neot es, atoin ahiin rais atoran hukun Yahudi tuaf es, anhaek ma naꞌuab nok Naiꞌ Yesus he nakreo Goe. In nataan am nak, “Aam Tungguru! Amturun he mutoon maan kau feꞌ! Au he ꞌmoeꞌ saaꞌ, he bisa ꞌmoin ubar-baar ꞌok Uisneno ꞌbi sonaf neno tunan?” ");
INSERT INTO aaz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naiꞌ Yesus nataah am nak, “Kaꞌo Musa antui mnak saaꞌ, anmatoom nok rasi ia? Ho mahiinm ii on mee meu rasi ia?” ");
INSERT INTO aaz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Atoniꞌ naan nataah am nak, “In ntui mnak: ‘Ho ro he mneek Uisneno, ho Usiꞌ, anneis naꞌko saaꞌ ii ok-okeꞌ. Es naan ate, ho ro he mumnau Goe piut-piut, ammeup maꞌtaniꞌ he mutuin In romin, ma muhiin ma mukeo Goe.’ Matuꞌi msaꞌ am nak, ‘Ho ro he mneek ho aom-bian, on reꞌ ho mneek ho tuam aan kuum.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Naiꞌ Yesus nataah am nak, “Batuur! Karu ho mmoeꞌ mutuin sin on naan ate, ho mmoin mubar-baar mok Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mes atoniꞌ naan in nmoeꞌ in tuan ee on reꞌ atoin amakoet anbi rais Uisneno. Rarit in nataah Naiꞌ Yesus am nak, “Mes au ‘aok-bian’ naan, es reꞌ mee?” ");
INSERT INTO aaz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Onaim Naiꞌ Yesus nataah am nak, “On nai! Au he uꞌuabaꞌ aan reet es. Rarit ho of amteek, mee es batuur-batuur ho ‘aom-bian’. Retaꞌ naan on nai: anmuiꞌ naan atoin Yahudis es annao naꞌko kota Yerusalem, neiki nsaun neu Yeriko. Mes nok askeken, apaikaurt ein neman nkarfei atoniꞌ ia. Rarit anbaan ee ma nabaak neik in roit am in tais ein ok-okeꞌ. Rarit sin nait anhoeb ee nbi ranan, ma sin nnaon nasaitan. Atoniꞌ naan he nma-maet ja heen. ");
INSERT INTO aaz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mes ken-kenuꞌ te, anmuiꞌ aꞌnaak pirsait Yahudis es neem annao nsaun npeoꞌ ranan naan amsaꞌ. Suma oras in niit atoin ao apapaꞌ es antuup anhoeb on nbi raan ee te, in ka nasnaas fa he nturun. Mes in nteib neu raan ee panin, ma nnao nkoon. ");
INSERT INTO aaz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ka ꞌroo fa te, tuaf es anteniꞌ neem annao npeoꞌ ranan naan. Atoniꞌ naan naꞌko uuf naiꞌ Lewi reꞌ biasa ntuthae nbi Uisneno In Uim Onen Uuf. Oras in niit atoin ahoet naan anbi raan ee ninin, in nnao npaumak-maak ma ntae, mes ka ntuurn ee fa. Rarit in ntebi nꞌain raan ee panin, ma nnao nkoon. ");
INSERT INTO aaz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Ka ꞌroo fa te, atoin es naꞌko pah Samaria nok in bikaes keledai, neman nnaon npeꞌon ranan naan. Hit arkit tahiin tak, atoin Yahudis kit natiꞌ te, hit tiit atoin Samarias ate hit tasbiniꞌ sin. Oras atoin Samarias naan niit atoin mapaikaruꞌ naan ate, in nkasian ee. In neem anpaumak-maak he nturun atoniꞌ naan. In nꞌoop anggur he nakninuꞌ paap ein, rarit in nminaꞌ sin. Rarit anꞌaum paap ein naan rek-reko, ma nasaeb ee neu in bikaes keledai. In neik atoniꞌ naan antea kota. Rarit in natuabaꞌ ntahan atoniꞌ naan anbi losmen, ma anꞌuurs ee rek-reko. ");
INSERT INTO aaz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nokaꞌ on naan ate, atoin Samarias naan anbaen antahan roi mutiꞌ fuaꞌ nua neu losmen tuaf naan, ma naꞌuab am nak, ‘Ampaek roit ein reꞌ ia, he mꞌurus ameent ee rekaꞌ nareok. Karu ka nanokab fa te, mpake mtahan hi roit. Oras au ꞌfain ꞌuum, au of ꞌeik ki roit he ufaniꞌ sin ok-okeꞌ.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naiꞌ Yesus in retaꞌ naan antuuꞌ on naan. Rarit In nataan atoin ahiin rais hukun sin am nak, “Natuin ho teenb ii te, mee es reꞌ batuur-batuur ‘aon-bian’ neu atoin mapaikaruꞌ naan?” ");
INSERT INTO aaz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Atoniꞌ naan nataah am nak, “Batuur-batuur ii es reꞌ atoniꞌ reꞌ ankasian ee ji, oo!” Naiꞌ Yesus nataah am nak, “Batuur on naan, tua. Onaim amnao nai he mmoeꞌ mutuin on naan.” ");
INSERT INTO aaz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Rarit Naiꞌ Yesus nok In atoup noinꞌ ein nnaon piut neun kota Yerusalem. Sin neis nokan kuan es. Anbi kuan naan, anmuiꞌ naan bifee nua, sin nmaꞌori-taatn ein. Sin kaank ein, es bi Marta te, es bi Maria. Bi Marta nfee haan askaut neu Naiꞌ Yesus sin he ntupan naan fai jes aꞌnua nbi sin umi. Rarit Naiꞌ Yesus sin ntupan ntaahn ein anbin naan. Oras Naiꞌ Yesus antook ma nanoniꞌ tuaf, bi Marta nhae nmat-maet he nabarab bukae nbi umi ꞌhanaꞌ. Mes in orif bi Maria, antoko npaumak-maak Naiꞌ Yesus In haek ein, ma anneen kuun In uaban. Ka ꞌroo fa te, bi Marta ntaam neem ma naꞌmuaꞌ neu Naiꞌ Yesus am nak, “Hae, Aam! On mee mꞌes reꞌ ia? Au ꞌhae ꞌmat-maet he ubarab bukaet, onait bi Mia in ntook kuun es ia. Amreun goe he nturun naan kau kreꞌo!” ");
INSERT INTO aaz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mes Usif Yesus nataah am nak, “Marta. Ho mtaisiub kuum nok tenab humaꞌ-humaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Reko! Mes anmuiꞌ naan rais jes reko nneis oras ia. Bi Mia antook ma nneen Au Uab ein ia, in npiir naan kuun rais reok goes. Atoniꞌ ka bisa nabaak aiꞌ ntoup naan fa Uab ein naan naꞌkon bi Maria.” ");
INSERT INTO aaz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Neot es, Naiꞌ Yesus annao nꞌonen. Anꞌonen anrari te, In atoup noin es neem ma ntoti mnak, “Usiꞌ! Naiꞌ Yohanis Asranit nanoniꞌ nrair in atoup noinꞌ ein he nꞌoen ein nahinin. Hai mtoit Ko, he munoniꞌ kai he mꞌonen mihiin, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Rarit Naiꞌ Yesus nak, “Reko! Amꞌonen ampaek onen on reꞌ ia: Aam. Ho kanam naan nakninuꞌ teeb. Maut he mansian ein ok-okeꞌ, nanaib ma ntunaꞌ naꞌratan Ho kanam naan! Maut he Ho mjair Usif meu mansian ein ok-okeꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amturun ma mbaab kai nok rais bukaet, reꞌ nanokab neu kai neno-neno. ");
INSERT INTO aaz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Hai mtoit Ko, Aam, amnikan main hai saant ein ok-okeꞌ, on reꞌ hai amnikan main tuaf bian sin saant ein amsaꞌ, reꞌ sin nmoeꞌ sin neu kai. Ampafaꞌ ma mpanat kai he hai kais ammoeꞌ amreꞌut, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Rarit Naiꞌ Yesus nanoniꞌ ntein sin anmatoom nok rais onen. In npaek uab manporin am nak, “Karu fai tnanaꞌ, anmuiꞌ ho partei jes neem naꞌko ꞌroo, ma ntuup antahan anbi ho umi. Mes ho ka mmuiꞌ fa saaꞌ-saaꞌ he mfee ne he nbukae. Rarit ho mnao meu ho partei jes antein in umi. Ho mhake mbi moen ee, ma mtoit je mmak, ‘Baꞌe! Amfee mtahan maan kau utunuꞌ fuaꞌ teun feꞌ! Au ꞌmuiꞌ tamu et umi. Mes hai ka ti-tiit fa saaꞌ es he mtuthae je. Onaim amturun maan kau! Utunuꞌ fuaꞌ teun goah. Au of ufaniꞌ ko sin!’ ");
INSERT INTO aaz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Onait ho baꞌe of nataah ko mnak, ‘Airoo, ma ho msaꞌ ate! Au ꞌtuup aꞌfiin jen ate, ho uum he mpooꞌ kau goo! Eonꞌ ein au uꞌretuꞌ ꞌrair sin. Riꞌaan ein antupan nrarin. Neu, kais muꞌtooꞌ, baꞌe! Neot es anteniꞌ!’ ");
INSERT INTO aaz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Maski on naan amsaꞌ, mes mimnau mirek-rekoꞌ. Maski tuaf naan ka nfeen fa he nfee ko, natuin ho reꞌ naan in baef, mes karu ho mtoit je piut-piut, in of anfeen am anfee ko. ");
INSERT INTO aaz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","On naan amsaꞌ rais onen. Amtoit piut-piut meu Uisneno; In of anfee ma nnonaꞌ. Maim piut-piut; In of naruruꞌ ranan. Amhaman piut-piut; In of nasoin enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Fin sekau-sekau reꞌ antotin piut-piut neu Uisneno, of antoupun. Amnamit piut-piut, of napenin. Ahaman piut-piut, In of nasoin enoꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hi mitenab miit! Hi miit mahonit mee, reꞌ karu in aanh ee ntoit ikaꞌ te, anfee ne kaunaꞌ? ");
INSERT INTO aaz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aiꞌ, riꞌaan ee ntoit maun-tenoꞌ te, anfee ne kbiti? Ka neu he on na fa, aiꞌ? ");
INSERT INTO aaz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mansian ii ro maufinu. Mes hi Amaꞌ abit sonaf neno tunan naan, In reokn ii kah een. Onaim karu mansian amaufiunt ein on reꞌ hi, amroim he mfee baer reko meu hi aanh ein, saaꞌ antein Amaꞌ Uisneno! In ka nfee naan ahaa ki fa saaꞌ-saaꞌ reꞌ hi mperluu sin, mes anneis naꞌko naan, In nfee In Asmaan Akniunꞌ ee neu tuaf-tuaf reꞌ ntoit Je.” ");
INSERT INTO aaz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Neot es, Naiꞌ Yesus anriuꞌ napoitan niut reꞌuf naꞌko amuut es. Onaim amuut naan naꞌuab anfain. Atoin ein anmasahun. ");
INSERT INTO aaz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mes bian naꞌuab ein am nak, “Batuur, In bisa nriuꞌ nitu! Natuin In napein kuasa naꞌko niutn ee sin aꞌnakat, es reꞌ Balsebul.” ");
INSERT INTO aaz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bian he nsobaꞌ Naiꞌ Yesus. Rarit sin ntoit Je he In nmoeꞌ naan rais sanmakat es antein, he nakriraꞌ sin am nak, In kuasa naan batuur-batuur naꞌko Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mes Naiꞌ Yesus nahiin nain sin roen reꞌuf naan. Onaim In naꞌuab am nak, “Karu anbi pah es, in toon guin anmamusun piut, pah naan of kpeteꞌ-kpeteꞌ. On naan amsaꞌ anbi uim jes in nanan, abitan umi naan karu anmatoen piut-piut ate, umi naan, ro kah een! ");
INSERT INTO aaz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Onaim karu niut reuꞌf ein anmamusun ma anmariꞌun es nok es, henat sin aꞌnaakt ee ka bisa naprenat sin fa ꞌroo-ꞌroo ntein! Onaim ka ntaam fa neu ronef, karu hi mak, Au ꞌpaek niut reuꞌf ein sin kuasa he ꞌriuꞌ upoitan niut reꞌuf! ");
INSERT INTO aaz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mimnau he! Hi ngguin amsaꞌ anriuꞌ nahinin nitu. Sin npaek kuasa naꞌkon niutn ee, oo? Kaah fa! Onaim hi kais miꞌuab tafiꞌ-tafiꞌ mak, Au ꞌpaek niutn ee sin kuasa he ꞌriuꞌ nitu. Hi ngguin kiim of nafekan am nak saaꞌ reꞌ hi mtuꞌiran sin meu Kau naan, ansanan. ");
INSERT INTO aaz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mes karu Au batuur-batuur aꞌriuꞌ nitu ꞌpaek kuasa naꞌko Uisneno, naan nakriir on nak Uisneno In apreent ee et hi maatm ein naan. Mes, on reꞌ hi ka mikeo maan fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Karu tua maꞌtain es annaaꞌ suniꞌ-kenat nbi in aꞌniman aꞌrii-ꞌneꞌu ma npao in umiꞌ, in baerꞌ ein of ka namnekun fa. ");
INSERT INTO aaz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mes of anmuiꞌ tua maꞌtain es antein maꞌtaniꞌ nneis, neem ma nbaan niis ne, rarit nait nabaak neik tuaf naan in suniꞌ-kenat sin. Rarit nnau neik nain tuaf naan in aꞌmuiꞌk ein ok-okeꞌ, ma nbait sin neu iin ee. Aꞌroo-ꞌroo reꞌ ia, tua maꞌtain ahunut naan in npirsai batuur-batuur in suniꞌ-kenat sin. Mes oras ia, in ka bisa nharap sin fa goen antein. ");
INSERT INTO aaz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mimnau mirek-rekoꞌ! Sekau reꞌ ka nmapartein fa nok Kau, in reꞌ naan, Au musu. Ma sekau reꞌ ka nmaturun nok Kau fa nbi Au mepu, in reꞌ naan anmoꞌe haa taisibu.” ");
INSERT INTO aaz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Naiꞌ Yesus antuut antein In uaban am nak, “Karu hit triuꞌ nitu npoi naꞌko tuaf es, in naen neu baer ruman he nasnaas. Natuin in ka napein fa bare reꞌ natai nok in romin, onaim in natenab nak, ‘Aah! Au ka upein fa bare on reꞌ ia te, reko nneis au ꞌfain ꞌeu au barak neno naan.’ ");
INSERT INTO aaz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Rarit in ntebi nfain neem, ma niit bare naan, ansaup nakniunꞌ ee goen, ma nkikin anrair je goen. ");
INSERT INTO aaz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Onaim nitu naan annao noꞌen in partein hiut, reꞌ maufinu nneis. Rarit sin nnaon natuan nbin atoniꞌ naan, ma sin nbaan ee buꞌ-buaꞌ. Onaim oras ia, tuaf naan in aꞌmoin ii, nreꞌu nneisi ntein.” ");
INSERT INTO aaz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Oras naiꞌ Yesus naꞌuab feꞌ nok too mfaun ein naan, anmuiꞌ bifee jes anbi naan ankoaꞌ am nak, “Aijoo! Ho ainaꞌ ua-reko, natuin in nahoniꞌ naan Ko, ma nasuus naan Ko, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naiꞌ Yesus nataah am nak, “Batuur, ain! Mes tuaf reꞌ ua-reko nneis ji, es reꞌ tuaf reꞌ antakan in rukin ma anneen Uisneno In Kabin ma Prenat, ma nmoeꞌ natuin sin!” ");
INSERT INTO aaz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oras too mfaun ein naub naan Naiꞌ Yesus on naan ate, In nmurai naꞌuab am nak, “Mansian oras ia, suma nmoꞌ-moꞌe haa rais maufinu. Sin para ntoit Kau he ꞌmoeꞌ rais sanmakat neu sin, he sin nahinin nak Au reꞌ ia, batuur-batuur Uisneno Iin Ja. Te kaah, unuꞌ te Uisneno anfeen sin rais sanmakat anpaek In mafefa kninuꞌ, naiꞌ Yunus. Naan noo goah. ");
INSERT INTO aaz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Unuꞌ te, naiꞌ Yunus natoon neu abitan kota Niniwe nak, sin ro he naꞌpisan feꞌ. Onaim saaꞌ reꞌ anjair neu naiꞌ Yunus afi unuꞌ te, anjair tanar neu sin mnak, Uisneno es anreek haefn ee. On naan amsaꞌ anmatoom nok Kau, Mansian Batuur-Batuur. Au ꞌuum he utoon ki mꞌak, hi ro he miꞌteꞌun ma miꞌpiis feꞌ. Ma saaꞌ reꞌ anjari nbi Kau, naan of anjair tanar neu tuaf-tuaf oras ia mnak, tebes Uisneno es reꞌ anreek haefan Kau. ");
INSERT INTO aaz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Of anbi neon amsoupt ee on naan ate, karu Uisneno nhake njair afeek rasi, of bifee usif naꞌko haaꞌ-nua, nmoni nfain ma nhake njair saksii. In of anruur ki ok-okeꞌ reꞌ amonit oras ia mnak, ‘Hi arki amoont ein!’ Unuꞌ te uis bifee naan neem naꞌko ꞌroo-ꞌroo he niit kuun usif naiꞌ Soleman in mahinin. Te kaah, oras ia anmuiꞌ Tuaf es et hi sonam ma hi tnaanm ein, reꞌ maꞌtaniꞌ nneis naꞌko usif naiꞌ Soleman. Mes hi ka mfairoir maan Ee fa kreꞌ-reꞌo msaꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma in ka nmees fa! Abitan Niniwe msaꞌ of anfenan ma nruur hi amonit oras ia mnak, ‘Hi arki amoont ein!’ Sin naꞌuab ein on naan, natuin neno naan, oras naiꞌ Yunus annao natoon neu sin Uisneno In roimn ee, sin naꞌpiis nanin. Te kaah, oras ia Tuaf maꞌtani nneis naꞌko naiꞌ Yunus anmoin nok ki et hi sonam ma hi tnaanm ein ate, mes hi ka miꞌpiis fa kreꞌo msaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Naiꞌ Yesus antuut antein In uaban am nak, “Atoniꞌ nout pauk anaꞌ, rarit nateek je nbi ꞌratan, he in ntanaꞌ keꞌen neu abitan naan ok-okeꞌ. Ka tiit fa es he nout paku, rarit nait iꞌkora, ma ntoeb paku naan! Naan ka mapakeꞌ fa! ");
INSERT INTO aaz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hi maatm ein naan on reꞌ paku. In ntanaꞌ nameu hi neekm ein. Karu hi maatm ein nameisꞌokan, hi mkius meik neek maufinu. Mes karu hi maatm ein meꞌun, hi mkius meik neek akninuꞌ reko. ");
INSERT INTO aaz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ampanat he meꞌu nbi hi neekm ein naan, nmeuꞌ-siin batuur-batuur on reꞌ manas. Meꞌu nbi hi neekm ein naan, kais on reꞌ funan, reꞌ suma nfee haa mafof. ");
INSERT INTO aaz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Karu hi neekm ein meꞌun, tar antea ka tiit fa kobaiꞌ aan meisꞌookn es, hi ꞌmoinm ein of meꞌun on naan amsaꞌ, on reꞌ pauk koꞌu reꞌ antanaꞌ hi ꞌmonim.” ");
INSERT INTO aaz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Naiꞌ Yesus naꞌuab anrair on naan ate, anmuiꞌ naan atoin es naꞌko partei pirsait Farisi, naskau Goe he nbukaen on in umi. Antean nee te, Naiꞌ Yesus antaam ma ntook. Rarit sin nbukaen nbin mei mnahat. ");
INSERT INTO aaz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mes uim tuaf ee nsanmaak, natuin Naiꞌ Yesus nbukae, mes ka nafaun fa In aꞌniimk ein, natuin atoran atoin Farisis sin. ");
INSERT INTO aaz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Rarit Naiꞌ Yesus natoon ee mnak, “Hi atoin Farisis, ro maꞌtaniꞌ! Hi ro mnaaꞌ miher-heran hi atoran rais pirsait! Hi mimnau meu reꞌ he msaef mikninuꞌ ꞌpikaꞌ-ꞌsonoꞌ ma kraas ein sin koitk ein tar narim-riman, mes hi ka mimnau fa he mikninuꞌ hi nekam oemeetn ein reꞌ maufinu, ma akoomt ein naan! ");
INSERT INTO aaz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hoe amonot! Kais amnikan. Uisneno es reꞌ anmoeꞌ aof-kotif. In es reꞌ anmoeꞌ aof-nanaf amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Reko nneis, hi mfee meu atoin kasian ein saaꞌ-saaꞌ reꞌ hi mmuꞌi, he hi bisa kninuꞌ mbi Uisneno In human ma In matan. ");
INSERT INTO aaz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hi atoin Farisis arki! Hi of mipein siraak! Anmatoom nok rais bait boꞌ neu Uisneno, hi msoiꞌ sin ok-okeꞌ, anaꞌ-koꞌu. Tar antea hi roet bumbu aanꞌ-anaꞌ on reꞌ sipaꞌ ma aijonuus amsaꞌ, hi msoiꞌ sin! Mes hi ka mfairoir maan fa rais maꞌtain ein. Rasi anmatoom nok manekat meu Uisneno, ma rasi anmatoom nok taibaꞌ, hi mnikan main sin een! Batuur, hit ro he tfee Uisneno in sapaan, mes kais atnikan tain areꞌ rasi reꞌ pentiing anneis. ");
INSERT INTO aaz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hi of mipein siraak! Natuin hi mroim he maim bare ma mtook maat ambi uim oen ein, ma mrom-roim he biak ein anhormaat ki karu hi mibua mbi too mfaun ein sin humak ma sin maatk ein. ");
INSERT INTO aaz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hi of mipein siraak! Natuin hi on reꞌ faut baik natef reꞌ mnera-mneraꞌ. Tuaf annao nbi naan ate, sin ka nastunan ma nahinin fa, natuin ka tiit fa faut baik natef et naan, mes noup baraf naan in naan ee, foo puun ii kah ein. Te kaah, tatuin hit harat, tuaf reꞌ anteri nbi faut baik natef, naan anhaiꞌniis in tuan, onaim in ka nabeiꞌ fa he ntaam neu uim onen. Hi atoin Farisis on reꞌ faut baik natef! Hi mmoeꞌ jom on reꞌ atoniꞌ kninuꞌ batuur-batuur. Mes hi nekam naank ein naan, naheun nok tenab meisꞌokan.” ");
INSERT INTO aaz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Anmuiꞌ ahiin rais hukum Yahudi es anbi naan, anꞌoet Naiꞌ Yesus In uaban naan am nak, “Aam Tungguru! Ho uab ein feꞌe na ntoom kai msaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Rarit Naiꞌ Yesus nataah ee mnak, “Batuur! Hi ahiin rais hukun Yahudi, maut he hi mipein siraak amsaꞌ! Hi ka mturun fa tuaf he napein maꞌkafaꞌ, mes hi miꞌbabaꞌ susat nok hi atoran pirsait reꞌ hi mmoꞌ-moeꞌ sin naan, he mhaꞌfeen too. Rarit hi misahab atoran humaꞌ-humaꞌ reꞌ naan neu too. Mes hi tuaf es amsaꞌ ka amturun fa meiki kruruꞌ meseꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hi of mipein siraak! Hi mteuꞌ-bain om he mihakeꞌ faut tugu meu Uisneno In mafefa kniun uun ein, he mhormaat sin. Te kaah, hi beꞌi-naꞌi sin es anroor niis mafeef ein naan! ");
INSERT INTO aaz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hi taos meseꞌ mok hi beꞌi-naꞌi sin. Sin ntitar napoitan Uisneno In mafeef ein, ma nroor naꞌmaet sin. Rarit hi mihakeꞌ faut tugu meu mafeef ein naan, he njair tanar am nak, hi mroim mituin hi beꞌi-naꞌi sin. ");
INSERT INTO aaz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nok ranan naan, Uisneno reꞌ nahiin nain sin ok-okeꞌ, naꞌuab niit am nak, ‘Au of aꞌreek haefan Au mafefa kninuꞌ ma au haef bian sin neu too Israelas sin. Rarit sin anhaꞌmuiꞌ bian, ma nroor niis bian.’ ");
INSERT INTO aaz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Tuaf reꞌ anmoin oras ia, ro he nasaah tahas naꞌko tuaf-tuaf reꞌ naꞌmaet Uisneno In mafeef ein. Naan ansoiꞌ sin naꞌko oras Uisneno nmoeꞌ pah-pinan ia, nmurai naꞌko naiꞌ Habel in aꞌmaten, tar antea amuin reꞌuf, es reꞌ naiꞌ Sakarias. In reꞌ naan es reꞌ anroor goe nbi mei fuat ma Keꞌen Akninuꞌ sin atnanak anbi Uim Onen Uuf. Hi misaah maan kiim sin hukun naan amsaꞌ! ");
INSERT INTO aaz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hi ahiin rais hukun Yahudi arki! Hi of mipein siraak! Natuin hi mnaaꞌ aꞌretu ꞌfoꞌe reꞌ bisa mretu ꞌfoe enoꞌ, he atoniꞌ nahiin narek-rekoꞌ Uisneno In romin. Mes hi ka mtaam mok kiim fa, tua. Hi maufinu nneis-neis ji, hi mꞌekaꞌ atoniꞌ in ranan, he sin kais antaman neun naan!” ");
INSERT INTO aaz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Oras Naiꞌ Yesus naꞌuab anrair on naan ate, tunggur agaam ein ma atoin Farisis sin anmaheek niis Ne. Anmurai oras naan, sin natanan rasi humaꞌ-humaꞌ he nakreo namouf Naiꞌ Yesus. Sin nꞌator asraak he namin rasi humaꞌ-humaꞌ nok Ne. ");
INSERT INTO aaz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Oras naan, anmuiꞌ too nifu fak-fauk, neman he nneen Naiꞌ Yesus. Sin nnaon nseit-seitn ok ma naub naan Ee. Onaim In naꞌuab nahuun neu In atoup noinꞌ ein am nak, “Ampaant om he kais mituin atoin Farisis sin ꞌmoeꞌ po-poi. Fin sin biasa naꞌuab ein ate, aꞌtetaꞌ, ma nmoꞌen ate, aꞌtetaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sin nmoeꞌ napo-poin on naan ate, reko, mes sin ꞌmoeꞌ po-poi naan of mamnitaꞌ. Fin saaꞌ-saaꞌ reꞌ oras ia naꞌkoor ok, of mamniit ein. ");
INSERT INTO aaz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saaꞌ reꞌ hi miꞌuab ee nbi maꞌkoroꞌ oras ia, of manenaꞌ kninuꞌ-kninuꞌ. Saaꞌ reꞌ hi miꞌseꞌo sin anbin keꞌen, of biak ein naꞌuab naher-heran sin anbin too mfaun ein sin humak ma sin maatk ein.” ");
INSERT INTO aaz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Naiꞌ Yesus naꞌuab antein am nak, “Aok-bian arki! Kais mimtau, karu nmuiꞌ tuaf he nroor ki. Natuin sin bisa nroor hi aom ein naan, mes ka bisa naꞌmaet fa hi smaanm ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Au he utoon ki mꞌak, hi ro he mimtausan sekau. Hi ro he mimtausan Uisneno. Natuin In es reꞌ bisa nroor ki, rarit nporin nataam ki neu ai maputuꞌ ma mararaꞌ abar-barat. Onaim In reꞌ ia, es reꞌ hi ro he mimtausan meu Ne batuur-batuur. ");
INSERT INTO aaz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hi mitenab miit, kor-maak ii in oosn ii fauk, hah? Manaꞌ nima te, roit sen nua, aiꞌ? Maski on naan amsaꞌ, mes Uisneno ka nnikan nain fa meseꞌ msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","On naan amsaꞌ, Uisneno nkius ki. In nahiin namnuut hi ꞌnaak fuun ein, fauk. Onaim hi kais mimtau, natuin Uisneno ntao osaf neu ki te, anneis nain kor-maak ein ok-okeꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Rarit Naiꞌ Yesus naꞌuab antein neu In atoup noinꞌ ein am nak, “Amtakan hi ruikm ein rek-reko! Karu anmuiꞌ tuaf nabrain he nmanakuꞌ Au Tuak ii nbi biak ein sin huumk ein anbi pah-pinan ia, Au of aꞌmanauk ee ꞌbi Uisneno In ameupt ein et sonaf neno tunan am ꞌak, in reꞌ naan Au Iin ja. ");
INSERT INTO aaz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mes karu anmuiꞌ tuaf naꞌuab anbi mansian ein am nak, in ka nahiin Kau fa, Au of uꞌuab aꞌbi Uisneno In ameupt ein et sonaf neno tunan am ꞌak, Au ka uhiin je fa msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Au reꞌ ia, Mansian Batuur-Batuur. Karu anmuiꞌ tuaf naꞌuab naꞌreꞌuf Au kanak arekot, Uisneno nabarab he nnikan nain in sanat naan. Mes karu In naꞌuab naꞌreꞌuf Uisneno In Asmaan Akniunꞌ ee In kanan arekot, Uisneno ka nnikan nain fa sanat naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Of karu anmuiꞌ tuaf anheer neik ki mnao meu umi feek rais pirsait, aiꞌ mnao meu anaaꞌ aprenat, natuin hi mpirsai Kau, hi kais mimtau mak hi mimneob om on mee. ");
INSERT INTO aaz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Fin oras naan, Uisneno In Asmaan Akniunꞌ ee of natoon uab neu ki natai nok haan tanas he hi mitaah sin.” ");
INSERT INTO aaz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Rarit tuaf es naꞌko too mfaun ein naan nataan Naiꞌ Yesus am nak, “Aam Tungguru! Amreun maan au tataꞌ he nbait kai hai pusaak ein feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mes Naiꞌ Yesus nataah ee mnak, “Heeꞌ! Sekau es nait Kau ꞌjair afeek rasi ꞌeu hi rasi human on reꞌ naan?” ");
INSERT INTO aaz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rarit Naiꞌ Yesus naꞌuab neu too mfaun ein am nak, “Hi mpaant om he kaisaꞌ msinmaak! Fin aꞌmuiꞌf ii ka nfee fa rais mamut.” ");
INSERT INTO aaz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Rarit In naretaꞌ neik uab manporin am nak, “Anmuiꞌ atoin amuiꞌt es, in reen je naheun nok sekit ma mnonut anho-hoen. ");
INSERT INTO aaz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tar antea in pooꞌf ein naꞌseesn een, ma in ka nahini ntein he natunuꞌ neu mee. ");
INSERT INTO aaz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Rarit in nafeek am nak, ‘Au he ꞌmoeꞌ kuuk, on nai! Au ꞌpukai ꞌain uim mapoꞌof amnaaꞌ ia, rarit au ꞌmoꞌe ꞌtein uim mapoꞌof koꞌu nneis, rarit usaeb ꞌain au sekit ma mnonut sin ok-okeꞌ ma au ꞌmuꞌik bian sin anbin naan amsaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Karu njari nrair on naan ate, au of uꞌuab ꞌeu au tuak ii mꞌak, “Hoe! Pooꞌf ee naheun goen! Amnaaht ee nanokab he taseen ok toon baniꞌ toon. Onaim muah am miun nai namin-miin, amtoko ma mber-bero ha haem ein naan nai!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mes Uisneno natoon ee mnak, ‘Hae! Amonot! Mabeꞌ ia, ho mmaet. Rarit sekau es npaar kuun poꞌof naan in aafn ee ok-okeꞌ?’ ");
INSERT INTO aaz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Onaim, on nai! Mansian ein bisa naim he nmuiꞌ ꞌmuꞌif kouꞌ-koꞌu nbi pah-pinan ia neu in tuan aan kuun, mes anbi Uisneno In teenb ee, tuaf reꞌ naan nmaꞌmuꞌi nmaet, natuin in ka nmoin reko fa nok Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Rarit Naiꞌ Yesus nanoniꞌ ntein neu In atoup noinꞌ ein am nak, “Hi kais amtaisiub meu hi ꞌmoinm ein neno-neno, mak he miah saaꞌ, aiꞌ he mpaek saaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Natuin hit aꞌmonik ia, anneis naꞌko saaꞌ reꞌ hit tbukae, ma saaꞌ reꞌ hit tpake. ");
INSERT INTO aaz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Amkius miit kor-kae metan! Sin ka nsenan fa, ka nsekin ma nonun fa, ka nmuꞌin fa poꞌof he natunuꞌ sin sekit ma mnonut, mes Uisneno anpairoir sin. Karu on naan ate, In bisa npairoir ki msaꞌ. Natuin In nsoiꞌ ki nneis naꞌko koron naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Karu hi mtae hi huum ein anbin ninu, rarit amtaisiub humaꞌ-humaꞌ, in bisa ntuut hi ꞌmoinm ein, aa oo? Kaah fa, tua! ");
INSERT INTO aaz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Onaim karu mtaisiub nok rais aan es ma ka neik fa afaꞌ saaꞌ-saaꞌ ate, nansaaꞌ am es mtaisiub nok rais koꞌun? Sin aafk ein saaꞌ? ");
INSERT INTO aaz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Amnao mkius miit fubonaꞌ et nasi. Ka nkaun rene, ka nteun. Mes usif naiꞌ Soleman in paek ein reꞌ maꞌosaꞌ arim-riimt ein amsaꞌ, es ka on fa fuboon fui naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Fin Uisneno anpairoir huun anobaꞌ reꞌ ka maꞌsoꞌik fa. Reꞌ suma nmoin neno ia, ma nokaꞌ te, nmaet, rarit nout goe ma nputu nmaet. Karu on naan ate, In bisa npairoir ki msaꞌ reꞌ masoꞌik anneis naꞌko huun. Onaim nansaaꞌ am es hi ka miꞌpesiꞌ fa hi ꞌmoinm ein batuur-batuur meu Ne? ");
INSERT INTO aaz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","On naan amsaꞌ hi kais amtaisiub anmatoom rasi mnahat ma mninut. Fin Uisneno of anꞌurus sin. ");
INSERT INTO aaz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atoniꞌ reꞌ ka naꞌpesiꞌ fa in tuan neu Uisneno, sin nhaen nmat-maten neu reꞌ he nꞌurus rasin naan ok-okeꞌ. Mes hi kais on reꞌ naan, natuin hi Amaꞌ abit sonaf neno tunan nahiin nain saaꞌ-saaꞌ reꞌ hi mperluu sin. ");
INSERT INTO aaz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Karu hi minaob Uisneno In meup Gui feꞌ, naꞌ In nꞌurus ki areꞌ rasin naan neu ki.” ");
INSERT INTO aaz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Rarit Naiꞌ Yesus antuut antein am nak, “Hi on reꞌ ꞌbib-kase pukan aan es, reꞌ nꞌoren nmaten. Mes kais mimtau! Natuin hi Amaꞌ et sonaf neno tunan naan, Uis Koꞌu. Saaꞌ reꞌ Iin ja, In nmariin he nfee je neu In aan neek ein. ");
INSERT INTO aaz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Onaim amnao nai he miꞌsosaꞌ main hi baerꞌ ein, rarit ambait roit ein meu amaꞌmuiꞌt ein. Nok ranan naan hi mitunuꞌ aꞌmuꞌif et sonaf neno tunan nbi baer mamut abar-barat. Abaakt ee, ka bisa nabaak ee fa. Naem am etes ka nsoor goe fa. ");
INSERT INTO aaz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mimnau mirek-rekoꞌ! Hi ꞌmuiꞌm ein anbin mee te, hi neekm ein etan naan.” ");
INSERT INTO aaz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Naiꞌ Yesus naꞌuab antein am nak, “Hi mibarab he mtuthae Kau, fai-manas. Nahuum on reꞌ ate, reꞌ anbeeꞌ ma npao in uisn ee nfain neem naꞌko fesat kabin. Karu in uisn ee nhaman anbi eonꞌ ee te, in bisa nasoin ee raab aah. ");
INSERT INTO aaz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Karu sin uisn ee neem napein in ameupt ein anpa-paon on naan ate, sin uak ein reko. Fin sin uisn ee neikn on nakriraꞌ in nekan arekot neu sin. In npaek tai ate, rarit in ntuthae ameupt ein naan nok amnahat amin-minat. ");
INSERT INTO aaz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ameupt ein naan anꞌua rekon batuur-batuur, natuin sin ntuthae sin uisn ee nok reko. Maski sin uisn ee neem oras mee-mee jah, fai atnanas, aiꞌ neis-noi nmeu, sin nabaarb ein piut. ");
INSERT INTO aaz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mitenab mirek-rekoꞌ! Karu anmuiꞌ uim tuaf reꞌ nahiin nain neu abaakt ee he ntaam oras mee, in ka nfee fa mainuan he abakat naan anpukai in umi. ");
INSERT INTO aaz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Onaim hi ro he mibaarb om batuur-batuur, natuin ka tiit fa tuaf es nahiin batuur-batuur, rekaꞌ te, Mansian Batuur-Batuur ee, he nkoen On anfain neem.” ");
INSERT INTO aaz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Rarit naiꞌ Petrus nataan Naiꞌ Yesus am nak, “Aam Tungguru! Ho uab manporin feꞌe na antoom neu kai mmese oo, aiꞌ ntoom too mfaun ein barisi?” ");
INSERT INTO aaz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Onaim Naiꞌ Yesus nataah am nak, “Uab manporin feꞌe na antoom nain too mfaun ein ok-okeꞌ reꞌ anmepun on reꞌ aꞌnaak urusan reꞌ nꞌurus nahiin ma naꞌkiiꞌ neu in usin. Fin in uisn ee nait je he njair abati mnahat neu ameupt ein. Karu in nmakoe nbi mepu naan ate, maski in uisn ee neem oras mee-mee jah, mes in ro nmoeꞌ reko batuur. Rarit in nꞌua-reok, natuin in uisn ee of nait je njair aꞌurus neu aꞌmuiꞌf ein ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mes tsiraak karu ate naan nmurai natenab am nak, ‘Aah! Aꞌnaef ee of aꞌroo feꞌ te, naꞌ neem.’ Rarit in nmurai nbeos ma npokos ate bian, et bifee ma atoniꞌ. Rarit in ntoko ma naah-niun ma nmarin-riin tar antea nmafu nmaet. ");
INSERT INTO aaz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mes neon goes, oras ate naan ka natenab naan fa saaꞌ-saaꞌ, nok askeken ate, sin usin naan anfain neem. Oras sin usin naan nahiin rasin naan ate, in nbeso npokos, rarit anriuꞌ goe he napein kuun in sapaan ein et moneꞌ, nok tuaf-tuaf bian reꞌ ka naꞌkiꞌin fa natuin sin uisn ee in romin. ");
INSERT INTO aaz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Fin ate reꞌ nahiin nain in uisn ee in roimn ee, mes ka nabarab fa, aiꞌ ka nroim fa he nmoeꞌ on reꞌ naan, of napein hukun maꞌfenaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mes ate reꞌ nmepu nsaan, natuin in ka nahiin fa in uisn ee in mahinin, in of napein hukun maꞌkafaꞌ. Fin atoniꞌ reꞌ antoupu mfaun, in tuiꞌn ein amsaꞌ amfaun. Atoniꞌ reꞌ antoup meup koꞌu, in taahs ee msaꞌ koꞌu.” ");
INSERT INTO aaz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Naiꞌ Yesus antuut antein In haan ee mnak, “Au ꞌuum he ꞌbetis Au ngguin naꞌkon tuaf bian nbin pah-pinan ia. Naan on reꞌ tuaf anpaek ai, he nout makrafuꞌ. Au ꞌroim he ai naan anpiin anbi mee-mee. ");
INSERT INTO aaz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mes Au ro he usaah maꞌneꞌat reꞌ maꞌfenaꞌ nahuun feꞌ. Au of upein maꞌneꞌat batuur-batuur tar antea in oors ee okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hi mitenab am mak, Au ꞌuum he ꞌeik ki rais rameꞌ ma mamut anbi pah-pinan ia? Kaah fa, tua! Au ꞌuum he ꞌmoeꞌ mansian ein anmatoen, ma ansisaꞌen, natuin Au noink aan. ");
INSERT INTO aaz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Anmurai oras ia, orif-tataf, bae-feto, bae-mone sin of anbaits ok. Anbi uim jes in nanan, tuaf tenu te, anraban tuaf nua, ma tuaf nua te, anraban tuaf teun. ");
INSERT INTO aaz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Amaꞌ anraban anah; anah anraban amaf. Ainaꞌ anraban anah; anah anraban ainaf. Ain babaꞌ nraban aan nanef ma moen-feuf; aan nanef ma moen-feuf anraban ain babaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Onaim Naiꞌ Yesus naꞌuab nok too mfaun ein am nak, “Karu hi mkius noep je naꞌteem anbi pasaꞌ neon-teas, hi mak ‘tanar ia, uurn ii he nmouf goen.’ Batuur on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Karu anin naꞌko pasaꞌ haaꞌ-nua neem, hi mak, ‘Tanar ia, nak maan mapuut ii maꞌtaniꞌ.’ Batuur on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hae! Hi mansian puta-kriu ki, hi miꞌuab ate, aꞌtetaꞌ, ma mmoꞌe te, aꞌtetaꞌ! Hi mihiin main pah-pinan ia nok nain neon goe tnanan sin roimk ein. Mes nansaaꞌ am es hi ka mihiin fa Uisneno In roimn Ee nbi oras ia?” ");
INSERT INTO aaz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Naiꞌ Yesus naꞌuab antein am nak, “Karu hi mmakaꞌrasin, nansaaꞌ am es hi ka bisa mifeek kiim fa, mee es reꞌ batuur! Reko nneis amꞌurus rameꞌ nahuun! Kais-kaisaꞌ hi mtea mrair afeek rais je te, in nafeek ki he mtaam meu bui. ");
INSERT INTO aaz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Fin karu on naan ate, hi ka bisa mpoi maan fa, karu hi ka mbaen mirair fa hi tusaꞌ reꞌ afeek rais je nafeek ee neu ki naan.” ");
INSERT INTO aaz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Oras naan, anmuiꞌ tuaf natoon neu Naiꞌ Yesus am nak, gubernur Pilatus naꞌmaet atoniꞌ Yahudis fauk ein naꞌkon Galilea oras sin neman neun kota Yerusalem he neikin fuaꞌ-turuꞌ nbi Uim Onen Uuf. ");
INSERT INTO aaz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Anneen on naan ate, Naiꞌ Yesus nataan am nak, “On mee? Atoin Galileas reꞌ nmaet naan, sin saant ein koꞌun nneis naꞌko biak ein ok-okeꞌ, oo? Es naan ate, sin napenin hukun aꞌmaten, oo? ");
INSERT INTO aaz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kaah fa, tua! Mes karu hi ka misaitan fa hi ꞌmonim reꞌ ammaufinun naan, he mtebi mfain mituin Uisneno In romin, hi of amreuꞌ on reꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Onaim on mee ntein neu tua boꞌes am faun ein reꞌ neon goes ii rame mnanuꞌ Siloam antaikobi ma nmeuk niis sin? Sin saant ein koꞌun neis naꞌkon tuaf bian reꞌ anbin Yerusalem, aa oo? ");
INSERT INTO aaz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaah fa, tua! Mes karu hi ka misaitan fa hi ꞌmonim reꞌ nmaꞌeokb ok, he mituin Uisneno In romin amneot, hi of amreuꞌ on reꞌ sin amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Rarit Naiꞌ Yesus anfee uab manporin es am nak, “Anmuiꞌ naan atoin es, reꞌ anmuiꞌ hau roet mafuaꞌ es anbi in poꞌon. In neem piut-piut he nbaiseun hau roet naan he nahiin neu nafua goen aa oo, aiꞌ kaah feꞌ. Mes hau roet naan ka nafua fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rarit in nreun akninuꞌ poꞌon naan am nak, ‘Toon teun goen, au ꞌuum fani-fani he uhiin hau roet ia in fuan, mes au ka ꞌiit fa saaꞌ-saaꞌ. Onaim amnooꞌ goe he kais naah bare.’ ");
INSERT INTO aaz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mes akninuꞌ poꞌon naan nataah am nak, ‘Aam, kais mutooꞌ. Amfee mtein maan ee, oras toon es. Anbain he au ꞌkofan ꞌiit afu reꞌ roet ia in uun ii, rarit aꞌtao ne pupuk he namria. ");
INSERT INTO aaz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Karu anmaan fani ma nafua te, reko! Mes karu kaah fa te, amnoꞌo.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Neot es, nateef nok atoin Yahudis sin neon onen, Naiꞌ Yesus annao nanoniꞌ nbi uim onen. ");
INSERT INTO aaz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Anbi naan, anmuiꞌ naan bifee jes reꞌ in nui-ꞌsau-ꞌbook, toon boꞌes am faun goen, natuin niut reuꞌf ee nmoꞌe. In ka bisa nhaek namneo fa. ");
INSERT INTO aaz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Naiꞌ Yesus niit bifee naan, rarit anhaamn ee, ma naꞌuab nok ne mnak, “Ain! Oras ia, ho mureok nai.” ");
INSERT INTO aaz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Onaim Naiꞌ Yesus antao In aꞌniman neu bifee naan. Nok askeken ate, in nui-ꞌsau abokot naan, namneo nain. Onaim in ntoit makasi, ma nboꞌis Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mes uim onen naan in aꞌnaakt ee natooꞌ, natuin Naiꞌ Yesus narekoꞌ amenat nateef nok neon onen. Onaim in naꞌuab neu too mfaun ein am nak, “Krei jes naan ate, neno nee he hit tmeup. Onaim reko nneis ameent ein neman anbi nenon reꞌ naan, he namin tuaf he narekoꞌ sin. Kais neman oras neon onen!” ");
INSERT INTO aaz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mes Naiꞌ Yesus nataah ee mnak, “Hoe! Ho kais muꞌuab ate, ꞌtetaꞌ, ma mmoꞌe te, ꞌtetaꞌ. Anbi neon onen amsaꞌ hi mmeup, aiꞌ kaah?! Fin hi mnao mifetin hi bijae ngguin ma hi bikaes keledai ngguin he ninun oe, aiꞌ?! ");
INSERT INTO aaz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bifee reꞌ ia, kaꞌo Abraham in sufan, on reꞌ hit. Nitu ꞌnaakf ee nfuut goe toon boꞌes am faun. Onaim karu Au ureokꞌ ee nateef nok neon onen on nai te, ansaan saaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Anneen on naan ate, Naiꞌ Yesus in muusn ein namaeb ok. Mes too mfaun ein anmarinan In meup rekon naan. ");
INSERT INTO aaz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Onaim Naiꞌ Yesus antuta ntein In uaban naan am nak, “Au he utaib apirsait ein ꞌeik saaꞌ? ");
INSERT INTO aaz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Un-unuꞌ te, sin fuak fauk aah, mes anna-nao te namfaun. Sin nmurain on reꞌ musiꞌ fua es reꞌ anaꞌ krisiꞌ. Atoniꞌ anseen ee nbi poꞌon. Rarit anmoin, ma njair hau koꞌu. Onaim koorn ein neman ma nakuun ein anbin in taek ein.” ");
INSERT INTO aaz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Au he utaib Uisneno Iin na, ꞌpaek saaꞌ antein? ");
INSERT INTO aaz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In on reꞌ raur teif reꞌ bifee ngguin nait je ma nsoer goe nok uut saku nua, ankuum goe he nmoꞌen utunuꞌ. Onaim uu kumuꞌ naan ansae, natuin raur teif aanꞌ-anaꞌ naan. Uisneno Iin na anmuꞌin pengaru koꞌu on naan amsaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Rarit Naiꞌ Yesus sin anmurai nnaon neun kota Yerusalem. Anbin raan atnanaꞌ, sin neis nokan kota ma kuan he In nanoniꞌ tuaf. ");
INSERT INTO aaz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Antean baer jes, anmuiꞌ tuaf es nataan Ee mnak, “Aam Tungguru! Of oniꞌ tuaf fauk aah es reꞌ napenin saok sanat ma ꞌhonis, oo?” ");
INSERT INTO aaz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","In nataah am nak, “Sonaf neno tunan in enoꞌ ꞌtaams ee, maꞌrenaꞌ. Onaim mibarab hi tuam ein rek-reko he bisa mtaam ampeoꞌn aa. Fin anmuiꞌ tuaf amfaun anromin he nsoob ein antaman npeꞌon naan, mes ka bisa fa. ");
INSERT INTO aaz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Karu uim tuaf ee naꞌretuꞌ nrair enoꞌ naan ate, hi of amhake mbi moneꞌ, ma mteek enoꞌ naan, ma mhaman am mak, ‘Usiꞌ! Musoin kai eonꞌ ii feꞌ!’ Mes In nataah am nak, ‘Hi sekau, ki? Au ka uhiin ki fa!’ ");
INSERT INTO aaz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Onaim hi mak, ‘Onait usiꞌ ho ka muhiin kai fa? Airoo natiꞌ te, hit ttoko ma tbukae tabu-bua. Ho munoniꞌ kai nbi hai kuan ein amsaꞌ, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Onaim In of nataah am nak, ‘Feꞌe na Au ꞌak, au ka uhiin ki fa! Hi reꞌ ia mansian amoeꞌ maufinu. Miꞌroo miꞌko ia!’ ");
INSERT INTO aaz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Rarit karu Uisneno nafeek mansian ein sin rasin sin ok-okeꞌ, hi mkae mpin-pinus ma mek-meuk nisim. Fin hi miit kaꞌo Abraham, kaꞌo Isak, kaꞌo Yakop ma Uisneno In mafefa kniunꞌ ein antokon et sonaf neno tunan in nanan. Mes Uisneno nriuꞌ napoitan ki meu moneꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mansian ein of neman naꞌkon pah-pinan ia pani-mpain, naꞌko pasaꞌ neon-saet tar antea pasaꞌ neon-teas, naꞌko pasaꞌ ponain tar antea pasaꞌ haaꞌ-nua, he nbukaen buꞌ-buaꞌ nok Uisneno nbi In sonaf. ");
INSERT INTO aaz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Amtanar mirek-rekoꞌ rasi reꞌ ia: karu Uisneno nafeek anrair mansian ein sin rasin ok-okeꞌ, anmuiꞌ tuaf es, reꞌ unuꞌ te, sin nak aiꞌ aanꞌ-anaꞌ, mes in napein hormaat koꞌu. Ma bian unuꞌ te nak in atoin aꞌnaet, te kaah, Uisneno nak in aꞌbaut aah.” ");
INSERT INTO aaz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oras naan, anmuiꞌ naan atoin Farisis fauk neman ma nateef nok Naiꞌ Yesus. Rarit sin naꞌuab neu Ne am nak, “Reko nneis Aam Tungguru mnao muꞌroo-ꞌroo meu bare bian, natuin usif Herodes he naꞌmaet Ko, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Onaim Naiꞌ Yesus nataah am nak, “Aah! Aꞌnaef naan nahiin suma he nareuꞌ goah, on reꞌ metan et nasi! Hi mnao mitoon ee mmak, ‘Au ꞌriuꞌ niut reꞌuf ma urekoꞌ amenat neno ia mnokaꞌ. Anmeu te, naꞌ Au urair mepu.’ Maski on mee msaꞌ Au he ꞌmeup aan akreꞌo ꞌtein ꞌbi ranan reꞌ he ꞌeit ꞌeu kota Yerusalem. Fin abitan Yerusalem sin biasa naꞌmaet Uisneno In mafefa kniunꞌ ein. ");
INSERT INTO aaz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Airoo, hi arki abitan Yerusalem! Hi reꞌ ia, es reꞌ biasa miꞌmaet Uisneno In mafefa kniunꞌ ein, ma mpoir miis In haef ein reꞌ neman ma naruruꞌ ki ranan. Fani-fani Au he uꞌbuaꞌ ma ꞌpanat ꞌaan ki he ꞌekaꞌ ꞌaan ki naꞌko rais maufinu, nahuum on reꞌ maun ainaf anpuput naan in aan ein anbin in ninin nanan. Mes hi ka mroim fa. ");
INSERT INTO aaz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oras ia, Uisneno ka nrae ma mfairoir fa hi uim onen naan. Nokaꞌ-nmeu te, in ruman. Hi of ka miit amtein Kau fa, tar antea hi mmanakuꞌ mmak, ‘Uisneno anfee tetus-athoen neu tuaf reꞌ neem neik Uisneno In kanan, natuin Uisneno anreek haefn Ee!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Neot es, nateef nok neon onen, atoin Farisis sin aꞌnaakt es naskau Naiꞌ Yesus he neem anbukae nbi in umi. In ntook ma nbukae, mes anmuiꞌ tuaf reꞌ annuuꞌ Goe he nahinin nak in he nmoeꞌ saaꞌ nbi neon onen naan. ");
INSERT INTO aaz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oras naan anmuiꞌ tuaf es nameen boo bere-bere, reꞌ nok antoko nbi naan. ");
INSERT INTO aaz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Rarit Naiꞌ Yesus nataan neu ahiin rais hukun Yahudi ma atoin Farisis sin reꞌ antokon ma nbukaen nbin naan am nak, “Tatuin kaꞌo Musa in atoran, bole tarekoꞌ amenat nateef neon onen, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mes sin nfeef aꞌtemen ok-okeꞌ. Onaim Naiꞌ Yesus ansai amenat naan, rarit nareok nain. Onaim Naiꞌ Yesus anreun goe he nfain nai. ");
INSERT INTO aaz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Rarit Naiꞌ Yesus nataan sin ntenin am nak, “Karu anmuiꞌ riꞌaan es anmoufu ntaam neu oe haniꞌ nateef nok neon onen, hi mnao mipoin ee oo, aiꞌ kaah? Karu bijae je es anmoufu ntaam, hi mkoon ee oo, aiꞌ, mnao mipoin ee? Hi of amnao mheer mipoin. On nai te, naan in oetn ii nak, hi mmeup!” ");
INSERT INTO aaz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Annenan Naiꞌ Yesus In uaban on naan ate, ka tiit fa es he bisa nataah neu Ne. ");
INSERT INTO aaz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Oras naan, Naiꞌ Yesus ankius tuaf-tuaf reꞌ neman nbukaen nbin umi naan. Anmuiꞌ tuaf amfaun namin bare he ntokon nbin maat. Ankius on naan ate, In naꞌuab am nak, ");
INSERT INTO aaz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ampaant om, oo! Karu anmuiꞌ tuaf anfee haan askaut neu ki, he mnao meu fesat kabin, kais maim bare he mtoko mbi aꞌnaet ein sin baark ein. Kais-kaisaꞌ kabin tuaf ee anfee haan askaut neu aꞌnaet ein. ");
INSERT INTO aaz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Karu on naan ate, kabin tuaf naan of neem neu ko mnak, ‘Kais mutooꞌ goo! Au uskau he tananiꞌ teu kotin nee, natuin au ubarab aꞌtokoꞌ ia ꞌeu aꞌnaet reꞌ ia.’ Onaim ho mfeen muꞌko ꞌtokoꞌ naan ma mumaeb om. Rarit amnao mtoko mbi koit. ");
INSERT INTO aaz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Onaim karu ho mupein haan askaut, mnao mtook meu ꞌtokoꞌ abit kotin ee. Karu kabin tuaf ee niit ko te, in of neem am nak ko mnak, ‘Ee, Aam! Au uskau he tkoen ok teu matan ia.’ Nok ranan naan hi mipein hormaat anbi taumn ee ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fin tuaf reꞌ nanaib on, Uisneno of namouf goe. Mes tuaf reꞌ naꞌpaarn on on reꞌ atoin aꞌbaut, Uisneno of nait naꞌraatn ee.” ");
INSERT INTO aaz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Rarit Naiꞌ Yesus naꞌuab nok uim tuaf naan am nak, “Neot es anteniꞌ, karu ho mmoeꞌ fesat, kais amfee haan askaut meu ho nonot-asar ma ho partei amuiꞌt ein anmesen! Natuin sin of bisa nfeen haan askaut he nbaras ko. ");
INSERT INTO aaz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mes karu ho mmoeꞌ fesat, mfee haan askaut meu amaꞌmuꞌit, hae sah-sereꞌ, abuat, ma aforot sin. ");
INSERT INTO aaz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sin of ka bisa nbaras naan ko fa. Mes karu ho mfee haan askaut neu sin, Uisneno es reꞌ anbaras neu ko. Anbi oras Uisneno namonib nafaniꞌ In apirsait ein reꞌ anmaten nrarin, In ka nnikan fa ho ꞌmoeꞌ reko naan.” ");
INSERT INTO aaz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anneen on naan ate, tuaf es reꞌ nok antook mei meseꞌ nok Naiꞌ Yesus, naꞌuab am nak, “Ua reok reꞌuf, es reꞌ karu tbukae buꞌ-buaꞌ anbi Uisneno In sonaf!” ");
INSERT INTO aaz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naiꞌ Yesus nataah ee mnak, “Au ꞌmuiꞌ retaꞌ on nai: anmuiꞌ atoin es anmoeꞌ fesat koꞌu. Onaim in nfee haan askaut neu too mfaun ein. ");
INSERT INTO aaz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oras fesat naan sin naroitan anrair je te, in nreek haefan in ate ma nnao naskau tuaf-tuaf reꞌ napenin haan askaut am nak, ‘Au uskau tua, fin acara fesat he nmurai jen.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mes sin arsin anmoꞌen kuuk rasi ꞌsukif humaꞌ-humaꞌ, he sin kais nokan neun reꞌ fesat naan. Tuaf es anfee rasi ꞌsukif am nak, ‘Heeꞌ! Au feꞌ aꞌsoos auf feꞌu, onaim au ꞌnao he ꞌkius ꞌiit ee feꞌ. Kais mutoꞌ-tooꞌ! Au ka bisa ꞌuum fa, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Bian nak, ‘Au feꞌ aꞌsoos ꞌaan kuuk bijae abanit afu pasan niim. Au he ꞌnao ꞌsobaꞌ sin. Onaim au ꞌtoit maꞌaf, he!’ ");
INSERT INTO aaz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bian anteniꞌ nak, ‘Au ꞌmatsao feꞌu, onaim ka bisa fa, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Rarit ate naan antebi nfain ma natoon neu in usin. Anneen on naan ate, usif naan natooꞌ batuur-batuur. Rarit in naprenat in ate naan am nak, ‘Karu on naan ate, mnao rabah meu raan oopt ein, raan aanꞌ-aanꞌ ein anbin kota ia, he mheer meik kit atoin kasian ein, atoin hae sah-sereꞌ, atoin aforot ma abuat ein.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Anneen on naan ate, ate naan annao ma naskau tuaf-tuaf ein naan. Rarit in ntebi nfain ma natoon am nak, ‘Usiꞌ! Sin neman nrarin, mes bare bian ruum ein feꞌ, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Onaim usif naan naꞌuab am nak, ‘Karu on naan ate, amnao mtein meu kuan-kuan et kota in kotin, amtea reen ein. Muteef sekau-sekau te amfuir sin, he meik sin neman, asar baer fesat ia naheun. ");
INSERT INTO aaz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Amneen, he! Tuaf-tuaf reꞌ antorak au haan askaut naan, sin ka nnaben niit fa fesat ia in minan, maski kreꞌ-reꞌo msaꞌ!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Rarit Naiꞌ Yesus sin annaon nkonon neun Yerusalem. Too mfaun ein natuin Ee. Rarit In nabaniꞌ nꞌain sin am naꞌuab am nak, ");
INSERT INTO aaz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Atoniꞌ reꞌ batuur-batuur he natuin Kau, in ro he nneek Kau anneis naꞌko areꞌ kanan saaꞌ-saaꞌ ii barisi: anneis naꞌko in ainaf-amaf, anneis naꞌko in fee-anah, anneis naꞌko in orif-tataf, ma anneis naꞌko in tuan aan kuun. Karu kaah fa te, atoniꞌ naan ka pantas fa he njair Au atoup noniꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Fin atoniꞌ reꞌ ka nroim fa he nasaah haꞌmuꞌit ma maꞌneꞌat natuin in npirsai Kau, in ka pantas fa he njair Au ngguin. Tuaf reꞌ anroim he njair Au ngguin, maski atoniꞌ he nroor naꞌmaet je msaꞌ, mes in nasaah piut haꞌmuꞌit ma maꞌneꞌat naan. ");
INSERT INTO aaz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Onaim karu he mituin Kau, amtai mirek-rekoꞌ feꞌ. On reꞌ atoniꞌ he nafenaꞌ uim maktutaꞌ. In ro he nsoiꞌ nahunun uim je in oosn ii feꞌ, tar antea namtiis. Kais-kaisaꞌ roit ein ka nanokab fa. ");
INSERT INTO aaz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Karu ka nsoiꞌ sin fa tar namtiis, in of anfanderen anrari te, roit ein oekꞌ ein. Rarit biak ein anmains ee ma namae je, ");
INSERT INTO aaz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mnak, ‘Hi mkius miit atoniꞌ ne feꞌ! In feꞌ anfandeern aah ate, ka saaꞌ-saaꞌ fa feꞌ, mes narair roit.’ ");
INSERT INTO aaz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Uab conto bian, es reꞌ anmatoom nok makenat. Usif reꞌ he nnao neu makenat, ro he ntook he nsoiꞌ narek-rekoꞌ nok in aok-bian sin. Karu in suma nmuꞌi ha sorarus tuaf nifu boꞌes (10.000), in bisa niis anbi makenat nok musu tuaf nifu boꞌ nua (20.000), aiꞌ kaah? ");
INSERT INTO aaz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Karu anso-soꞌi nrari ma, nak in of ka niis fa nbi makenat naan, reko nneis, oras muusn ee feꞌ ka ntaman fa feꞌ, in nreek haefan tuaf he nnao nꞌurus rais rameꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","On naan amsaꞌ, tuaf reꞌ he natuin Kau. In ro he ntai nafan-faniꞌ mnak, in nabarab anrair he nasaitan sin ok-okeꞌ, aiꞌ kaah feꞌ? Fin karu ka on fa naan ate, tuaf reꞌ naan ka pantas fa he njair Au ngguin.” ");
INSERT INTO aaz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Naiꞌ Yesus antuut In uaban naan anpaek uab manporin es antein am nak, “Maisk ii reko. Hit tpaek je he taminab amnahat. Mes karu maisk ii ka miin mari fa goen, hit he tpaek je neu saaꞌ? Hit ka bisa tpaek je fa he tmasi amnahat. He ttao pupuk amsaꞌ, ka bisa fa. Hit tait itpoirn aah ee. Onaim hi ro he mjair on reꞌ masik amsaꞌ, he mmoin nok manekat mok areꞌ too mfaun ein. Sekau marukiꞌ te, amtakan mirek-rekoꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oras naan, ahoik beo ngguin ma atoin ka mapaek ein neman piut-piut neu Naiꞌ Yesus he nitan ma nnenan kuuk Ee. Mes atoin Yahudis sin naan sin, atoin reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ankius on naan ate, atoin Farisis ma tunggur agama Yahudi sin naꞌmuun ein am nak, “Phueꞌ! Atoniꞌ reꞌ ia anmapartei nok atoin reuꞌf ein. Antoko ma naah nok sin antein!” ");
INSERT INTO aaz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Anneen on naan ate, Naiꞌ Yesus naretaꞌ sin anpaek uab manporin am nak, ");
INSERT INTO aaz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Karu anmuiꞌ tuaf es naꞌko ki, in nmuiꞌ ꞌbib-kase manaꞌ nautn es. Onaim namneuk es. Oras ia, in he nmoeꞌ on mee? In ro nnao nasaitan boꞌ seo mseo ngguin nbi baer mamut es, rarit nnao naim amneukt ee rekaꞌ niit ee. ");
INSERT INTO aaz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Karu in napein ꞌbib-kaes amnekut naan ate, in nasaah neik je nok neek marine. ");
INSERT INTO aaz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Antea umi te, in noꞌen in nonot-asar sin ma natoon neu sin am nak, ‘Hae! Hi iim he mmarin-riin mok kau feꞌ! Fin au upein ufaniꞌ au ꞌbib-kaes amnekut naan.’ ");
INSERT INTO aaz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Anbi sonaf neno tunan on naan amsaꞌ. Karu anmuiꞌ tuaf asanat es naꞌpiis, rarit antebi nfain neu Uisneno, sonaf neno tunan in naan ee anmarinan ok-okeꞌ. Sin nmarinan nneis, natuin tuaf meseꞌ reꞌ anfain neem neu Uisneno, naꞌko tuaf boꞌ seo mseo reꞌ anmonin nok amneꞌo ma ka nseken fa.” ");
INSERT INTO aaz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Rarit Naiꞌ Yesus naretaꞌ anpaek uab manporin es antein am nak, “Anmuiꞌ bifee mnais es anmuiꞌ roi mutiꞌ fuaꞌ boꞌes. In ka nakeo naan fa te, fuaꞌ es namneuk. Onaim oras ia, in he nmoeꞌ on mee? In ro he nnao nout paku, rarit antanaꞌ narek-rekoꞌ nbi mee-mee, ma nsaup umi naan barisi, he naim roit naan rek-reko. ");
INSERT INTO aaz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oras in niit nafaniꞌ roit naan ate, in noꞌen abitan in uim je aon bian, rarit natoon neu sin am nak, ‘Au uskau ki, he hi iim ammarin-riin mok kau feꞌ, tua! Fin au ꞌiit ufaniꞌ au roi muit amnekut naan!’ ");
INSERT INTO aaz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Anbi sonaf neno tunan on naan amsaꞌ. Karu anmuiꞌ tuaf asanat es reꞌ naꞌpiis, rarit antebi nfain neu Uisneno, ameput sonaf neno tunan sin barisi anmarinan nmaten.” ");
INSERT INTO aaz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Rarit Naiꞌ Yesus antuut In retaꞌ npaek uab manporin es antein am nak, “Anmuꞌi ꞌnaef es nok in aan moen ee tuaf nua. ");
INSERT INTO aaz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Neot es, aheit suus goe nak in aamf ee mnak, ‘Aam honiꞌ! Ambati mfee kau au pusaak ein oras ia nai!’ Onaim In aamf ee nbait in aꞌmuiꞌf ein neun in aanh ein nua sin. ");
INSERT INTO aaz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka ꞌroo fa te, aheit suus goe naꞌsosaꞌ in sapaan. Rarit in nꞌaum in tais ein, ma nnao kuun neu pah aꞌroo-ꞌroo. Anbi bare naan in nbis-biisn ahaa roit ma nmoin nok marine reꞌ ka mapanat fa. ");
INSERT INTO aaz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Oras in narair roit on naan ate, pah reꞌ naan amnaahs ee ntaamn ee, tar antea in aꞌmoin ee njair atoin kasian. ");
INSERT INTO aaz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Onaim in nnao naim mepu. Atoin es nbi pah reꞌ naan antoup goe he nmeup. Atoniꞌ naan naruur ee meup goes, reꞌ he nhao fafi. ");
INSERT INTO aaz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Natuin riꞌanaꞌ ia namnaah ka nabeiꞌ fa goen, onaim in neekn ee he naah mnaah fafi naan. Fin ka tiit fa tuaf he nfee ne he naah. ");
INSERT INTO aaz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","In natenab aꞌroo-ꞌroo neu-mneem am nak, ‘Anbi au amaꞌ in umi, ameupt ein ok-okeꞌ, sin nahan tar namsenan. On nai te, au es ia ma umnaah aꞌmaet. ");
INSERT INTO aaz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Reko nneis, au ꞌtebi ꞌfain ꞌeu au amaꞌ nee. Rarit utoon ne mꞌak, “Aam honiꞌ! Au usanab aꞌrair ꞌeu Uisneno ma ꞌeu ko, aam honiꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au ka pantas fa he ꞌjair ho aan hoin aa goen. Maski ho mtoup kau ꞌjair aet kuri ꞌbi ho umi ia msaꞌ, reko!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Natenab anrair on naan ate, in nfeen ma nnao nfain neu in aamf ee umi. Oras in anbi ꞌroo goe feꞌ, mes aꞌnaef ee niit anrair je, onaim ansaon ee nmouf ma nkasian ee. In npoi naꞌko uim je naan ee, ma naen anseun goe. Rarit aꞌnaef ee nhoo ma nneek naan ee. ");
INSERT INTO aaz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Onaim riꞌanaꞌ naan naꞌuab neu in aamf ee mnak, ‘Aam honiꞌ! Au usanab koꞌu ꞌeu Uisneno ma ꞌeu ko, tua. Au ka pantas fa he ꞌjair ho aan hoin aa goen.’ ");
INSERT INTO aaz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mes in aamf ee naprenat in ameupt ein am nak, ‘Hae! Rabah! Mait meik maan baru mnaun feuꞌ goes he mibaru. Mikrein je ma msapaut in haek ein rek-reko. ");
INSERT INTO aaz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Amnao mheer bijae paron es ma mroor goe, he hit tmoeꞌ fesat kouꞌ-koꞌu. ");
INSERT INTO aaz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Natuin au anah reꞌ ia on reꞌ anmaet jen, mes oras ia nmoni nfain jen. In namneuk, mes oras ia au upein ufainꞌ ee.’ Naꞌuab anrair on naan ate, sin nmurai nfeest ein buꞌ-buaꞌ, ma sin nmarinan nmaten. ");
INSERT INTO aaz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Oras naan, aan moen uun goe ka nbi fa umi, in nbi rene. Oras in nfain neem naꞌko rene, in anbi ꞌroo goe feꞌe te, in nneen areukt am abobet ansiin ma nabsoꞌon. ");
INSERT INTO aaz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","In neem antea te, in noꞌen ate es, rarit nataan ee mnak, ‘Hae! Hi mmariin ambi fesat ia neu saaꞌ?’ ");
INSERT INTO aaz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ate naan nataah am nak, ‘Usiꞌ, ho oriꞌ nfain neem. Onaim amaꞌ nreek kai he hai mroor bijae he mmoeꞌ fesat ia, fin in aanh ee nfain neem nok ao-minaꞌ, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Anneen on naan ate, aan unu naan natooꞌ. In ka nromi ntein fa he ntaam neu umi. Onaim in aamf ee nnao nfuir ee he ntaam. ");
INSERT INTO aaz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mes in nmaheek je mnak, ‘Aam honiꞌ! Ho mutenab miit! Aꞌroo-ꞌroo reꞌ ia, au ꞌmeup on reꞌ kuri ꞌeu ko. Au ka ꞌtanhai ꞌiit fa ho atoran meseꞌ msaꞌ. Mes ho ka mroor miit fa ꞌbiib aan es, he au ꞌfesat ma ꞌmariin-riin ꞌok au aok-bian sin. ");
INSERT INTO aaz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mes ho aan nekaꞌ reꞌ ia, annao ma nporin roit ruum-ruum, anmakoin tafiꞌ-tafiꞌ nok bifee aꞌhaek ein. Oras ia, in nfain neem on nai te, ho mroor bijae paron ma mmoeꞌ fesat koꞌu neu ne.’ ");
INSERT INTO aaz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mes in aamf ee nataah am nak, ‘Unu! Amneen murek-rekoꞌ, hee! Ho mok kau ꞌroo-ꞌroo goen. Areꞌ saaꞌ-saaꞌ reꞌ ho amaꞌ kau gui ꞌmuꞌi sin, naan ho nggoa. ");
INSERT INTO aaz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mes oras ia, hit ro he tfesat he tmariin, natuin ho oriꞌ, fuaꞌ meseꞌ. Unuꞌ te, in on reꞌ nmaet, mes oras ia in nmoni nfain. In namneuk, mes oras ia, tiit tafainꞌ ee.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Rarit Naiꞌ Yesus naretaꞌ neu In atoup noinꞌ ein, npaek uab manporin es antein am nak, “Anmuiꞌ atoin amuiꞌt es reꞌ namepub atoin es njair in aꞌnaak urusan. Mes aꞌroo-ꞌroo on naan ate, in nneen uab anin nak, aꞌnaak urusan ia nmurai npaꞌeꞌob he naruikb ee. ");
INSERT INTO aaz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Onaim in noꞌen aꞌnaak urusan naan, he nataan ee. In naꞌuab am nak, ‘Au ꞌneen ate, nak ho mpaꞌeꞌob au ꞌmuꞌik. Onaim oras ia, ho mnao he mtui ho ꞌmeupm ein, rarit au he uprikas sin. Fin au he usnasab ko.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Anneen on naan ate, aꞌnaak urusan naan natenab neu-mneem am nak, ‘Au urair betiꞌ! Au he unsaaꞌ oras ia? Ureen, au ka ubeꞌif. Aꞌkuir roit, au ꞌmae kuuk. ");
INSERT INTO aaz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Karu au ka ꞌmeup fa ꞌteniꞌ ꞌbi ia te, au ro he ꞌaim ranan he biak ein anturun ma ntoup kau.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Es naan ate, in nmurai noꞌen tuaf-tuaf reꞌ natusan roit naꞌkon in usin. In nataan ahuunt ee mnak, ‘Hoe! Ho mutuus fauk et au usiꞌ?’ ");
INSERT INTO aaz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Atoniꞌ naan nataah am nak, ‘Au utuus miin saitun liter nifu haa (4.000), tua.’ Onaim aꞌnaak urusan naan, naꞌuab am nak, ‘Batuur! Ho surat reꞌ ho mutuus ii, es reꞌ ia. Oras ia mpius goe, rarit amtook he mtui suur tuus feꞌu mmak, ho mutuus liter nifu nua (2.000) goah.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Rarit in nataan atoin atusat es am nak, ‘Onait ho ntein. Ho mutuus fauk?’ In nataah am nak, ‘Au utuus makaꞌ taum karoꞌ niufn es (1.000), tua.’ Aꞌnaak urusan naan natoon am nak, ‘Ampisu mporiꞌ ho suur tusaꞌ mnaaꞌ aan, rarit amtui suur tuus feꞌu, mmak karoꞌ natun faun goah (800).’ ");
INSERT INTO aaz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","In nmoeꞌ on naan, tar antea in uisn ee nahiin in ronen naan. Mes usif naan ro he nmanakuꞌ nak, in aꞌnaak urusan reꞌ maufinu naan anpaꞌeꞌob nahiin batuur. Onaim Au utoon ki uab manporin ia, he hi mihiin mak, karu tataib atoin apirsait ii te, ka apirsait fa gui, ro batuur in manoe nneis he nmoni nbi too gui in atnanan. ");
INSERT INTO aaz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Onaim hi mitenab miit. Maski mansian pah-pinan ia npaek in aꞌmuꞌin he nmoeꞌ reꞌuf, mes reko nneis hi mpaek hi ꞌmuiꞌm ein he mmaturun es nok es. Nok ranan naan, hi mipein partein namfa-faun. Maski aꞌmuꞌif naan okeꞌ, mes Uisneno of nabarab ki bare et sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Karu tuaf ka napoi nahiin fa nbi rais aanꞌ-anaꞌ, in of ka napoi nahiin fa nbi rais koꞌun. Ma karu tuaf anpaꞌeꞌob anbi rais aanꞌ-anaꞌ, in of anpaꞌeꞌob nahiin anbi rais kouꞌ-koꞌun. ");
INSERT INTO aaz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Karu atoniꞌ ka bisa npirsai ki fa he mꞌurus rais aanꞌ-anaꞌ nbi pah-pinan ia, Uisneno he bisa npirsai ki he mmoeꞌ rais koꞌun, on mee? ");
INSERT INTO aaz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Karu hi ka bisa mꞌurus fa biak ein sin aꞌmuiꞌk ein hen ate, sekau nabrain he nfee ki in aꞌmuꞌin neu ki? ");
INSERT INTO aaz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tuaf ameput meseꞌ ka bisa ntuthae fa usif tuaf nua. Fin in of ka nneek fa tuaf es, ma anneek tuaf es. In naꞌkiiꞌ anbi tuaf es, mes ka nrae natuin fa tuaf es. On naan amsaꞌ hi arki. Hi ka bisa mneek fa Uisneno nata-tai nok hi mneek noni-roit.” ");
INSERT INTO aaz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Oras naan, anmuiꞌ atoin Farisis fauk nokan nnenan Naiꞌ Yesus In uab ein feꞌe na. Onaim sin nakreeꞌt Ee, natuin sin nakoman roit. ");
INSERT INTO aaz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mes Naiꞌ Yesus nataah am nak, “Hoe! Maski hi mikninuꞌ hi tuam ein anbi mansian ein sin maatk ein, mes Uisneno nahiin hi neekm ein naan, maufinu. Anmuiꞌ rasi mfaun reꞌ mansian ein antunaꞌ sin, te kaah, Uisneno naan rasin naan neu maufinu, ma nmaiꞌnisin sin. ");
INSERT INTO aaz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Anmurai naꞌko kaꞌo Musa ma mafefa kniunꞌ ein napein Uisneno In atoran, tar antea oras naiꞌ Yohanis Asranit neem antea msaꞌ, hit atoin Yahudis atmoin tatuin atoorn ein naan. Mes oras ia Uisneno In Rais Reko natoon On ma nasiin On antea mee-mee. Anmuiꞌ tuaf amfaun nꞌusaha maꞌtaniꞌ, he sin bisa nmoin natuin Uisneno In romin. ");
INSERT INTO aaz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maski neon goe tunan ma pah-pinan ia namneuk, mes Uisneno In atoran aanꞌ-anaꞌ msaꞌ, ka namneuk fa. Titik meseꞌ msaꞌ, ka namneuk fa! ");
INSERT INTO aaz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Atoniꞌ reꞌ nporin in fee, rarit ansao ntein bifee ꞌtetaꞌ, naan amakaket. Rarit atoniꞌ reꞌ ansao bifee porin naan, anmakakeꞌ msaꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Naiꞌ Yesus naretaꞌ ntein am nak, “Anmuiꞌ atoin amuiꞌt es. In biasa npaek tai amasat. Fai-manas in nfesat anmapii. ");
INSERT INTO aaz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Anbi bare naan anmuiꞌ naan atoin amaꞌmuiꞌt es, kaan ee naiꞌ Lasarus. In aon ee, napapaꞌ okeꞌ. Neno-neno te, in partein ngguin nok ne, ma natook ee nbi atoin amuꞌit naan in uim je enon he ttaam. ");
INSERT INTO aaz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","In nroim he napeni mnahat naꞌko atoin amuꞌit naan in amnaah neisf ein, mes ka napein niit fa saaꞌ-saaꞌ. Suma ausn ee neman ma nraim in paap oef ein. ");
INSERT INTO aaz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Rarit naiꞌ Lasarus anmaet. Onaim Uisneno In ameupt ein naꞌkon sonaf neno tunan neman ma neik je nnao. Rarit natook ee nbi kaꞌo Abraham in aon bian. Ka ꞌroo fa te, atoin amuꞌit naan anmate msaꞌ, rarit sin nsuub ee. ");
INSERT INTO aaz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mes in ka ntaam fa neu sonaf neno tunan. In ntaam anꞌain ai maputuꞌ ai mararaꞌ abar-barat, nabua nok amates amfaun. Anbi bare naan, in napein susat-haꞌmuꞌit ma maꞌneꞌat anmapii. Neot es, in nait matan on nai te, in niit naiꞌ Lasarus antoko ma nmarin-riin kuun anbi kaꞌo Abraham in aon bian. ");
INSERT INTO aaz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Onaim in nkoaꞌ am nak, ‘Kaꞌo Abraham! Airoo, mkasian maan kau feꞌ, tua! Amreun naiꞌ Lasarus he narepaꞌ in akrurun tuun aan neu oe, he neem napeet naan au maaꞌ tuun ii. Au he ꞌmaet kuuk een es ai abar-barat ia!’ ");
INSERT INTO aaz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mes kaꞌo Abraham nataah am nak, ‘Airoo, anah! Mumnau murek-rekoꞌ neno uun aan feꞌ! Neno naan, oras ho mmoin feꞌ mbi pah-pinan, ho mupein main areꞌ kanan reko. Mes naiꞌ Lasarus suma napeni haa susat. Onaim oras ia, Uisneno anseuꞌsaab ee nbi ia. Mes ho mupein suust am nanaꞌrenat. ");
INSERT INTO aaz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Anneis-neisi ntein, et ho ma hai, Uisneno nbetis kit. Anmuiꞌ kefa mnanuꞌ ma mainuan. Onaim tuaf anbi ia, ka bisa neitin fa neun naan, ma tuaf abitan naan ka bisa neman fa neun ia.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Rarit atoin amuꞌit naan antoti mnak, ‘Karu on naan ate, kaꞌo mreun naiꞌ Sarus he nfain neu au amaꞌ in uim je feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Au ꞌmuiꞌ orif tuaf niim et nee ja feꞌ. Amreun naiꞌ Sarus he nnao namnaub sin, he sin ntebi nfanin nai neu Uisneno. Maut he sin nmaten ate, sin kais antaman neu baer siraak reꞌ ia, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mes kaꞌo Abraham nataah am nak, ‘Uisneno nfee nrair sin kaꞌo Musa ma In mafefa kniunꞌ ein sin tuis ein. Sin ho oriꞌ bisa nrees nafan-faniꞌ sin, he nahinin batuur-batuur Uisneno In romin.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mes atoin amuꞌit naan anprotees am nak, ‘Kaꞌo Abraham. Naan ka nanokab fa feꞌ! Sin ka nfairoir fa Uisneno In Kabin ma Prenat naan! Ro he nmuiꞌ amates anpoi naꞌko nopu, he nnao natoon neu sin, naꞌ sin nromin he natninan.’ ");
INSERT INTO aaz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mes kaꞌo Abraham nataah am nak, ‘Karu sin ka nromin fa he natniin kaꞌo Musa ma Uisneno In mafefa kniunꞌ ein sin haank ein, maski amaets ein anpoin naꞌkon nopun amsaꞌ, sin of ka natninan fa.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Naiꞌ Yesus natoon neu In atoup noinꞌ ein am nak, “Fani-fani atoniꞌ bisa nmouf neu sanat, natuin tuaf bian sin taos ein. Mes atoin ataos ein naan, sin es reꞌ napein siraak anneis-neisi. ");
INSERT INTO aaz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Karu anmuiꞌ tuaf anmoeꞌ taos tafiꞌ-tafiꞌ tar antea riꞌanaꞌ ka npirsai Kau fa, Uisneno of anhukun maꞌfenaꞌ neu tuaf naan. Reko nneis taꞌaisaꞌ fatu ma taꞌheekb ee neu in neon, rarit tait itpoirn ee ntaam neu tasi. ");
INSERT INTO aaz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Onaim ampaant om, he hi kais ammoeꞌ biak ein anmoufun neun sanat! Mes karu ho aom-bian nmoꞌe nsaan, mukain ee. Karu in naꞌpiis, rarit neem ma ntoit ampon, amnikan main in sanat naan. ");
INSERT INTO aaz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Karu ho aom-bian anmoꞌe nsaan no hiut nbi neno meseꞌ, onaim in nroim he naꞌpiis, rarit in neem no hiut he ntoit ampon, ho ro he mnikan main in saant ein naan no hiut.” ");
INSERT INTO aaz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Neon goes, Naiꞌ Yesus In atoup noinꞌ ein neman ma nak Ee mnak, “Aam Tungguru! Hai neek pirsait ii ka maꞌtaniꞌ fa. Amhaꞌtain maan kai, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Onaim Naiꞌ Yesus nataah am nak, “Karu hi mmuiꞌ neek pirsait meu Uisneno In kuasan, maski aanꞌ-anaꞌ, mes hi bisa miprenat hau koꞌu ia mmak, ‘Mutfakiꞌ ma munaniꞌ nai meu tasi!’ Hau ia of natuin hi prenat naan nain.” ");
INSERT INTO aaz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Rarit Naiꞌ Yesus naꞌuab antein am nak, “Tait iꞌtopeꞌ. Anmuiꞌ ate reꞌ nꞌoet afu nbi rene, aiꞌ ntituꞌ ꞌbib-kase nbi mneraꞌ huun. Anmepu nrari te, ate naan anfain on umi. Ka neu fa he in uisn ee nak ee mnak, ‘Uum he hit nua kit atbukae nai!’ ");
INSERT INTO aaz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kaah fa, tua! Reꞌ biasa te, in usin naan napreent ee mnak, ‘Amnao mubarab mei je meu kau. Rarit ho muah ambi kotin nee.’ ");
INSERT INTO aaz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Karu ate naan anmoeꞌ natuin usif naan in romin, hi mak of usif naan of antoit makasi neu ne, oo? Kaah fa, tua! ");
INSERT INTO aaz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hi on reꞌ naan amsaꞌ. Karu hi mmepu mrair areꞌ saaꞌ-saaꞌ reꞌ Uisneno nanaꞌat ma nbasan ki sin ate, hi miꞌuab am mak, ‘Hai reꞌ ia, suma Ho aten kai reꞌ ka masoꞌik fa. Hai ka maim fa he munaib ma mboꞌis kai. Hai suma minaob ahaa hai mepu reꞌ Ho munaꞌat kai sin, tua.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Oras Naiꞌ Yesus sin annaon neun kota Yerusalem, sin ntean nakat propinsi Galilea ma propinsi Samaria. ");
INSERT INTO aaz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Oras sin he ntaman neu kuan es, anmuiꞌ atoin ameen nui-atrokiꞌ tuaf boꞌes neman he nateef nok Ne. Sin nhaken nbin aꞌroo, ");
INSERT INTO aaz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","rarit ankoaꞌ ein buꞌ-buaꞌ am nak, “Yesus! Usiꞌ! Amkasian maan kai, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Oras Naiꞌ Yesus niit sin on naan ate, In nrenu mnak, “Hi mnao mikriraꞌ hi aom ein meu aꞌnaak rais pirsait, maut he in naprikas ki nak, hi meen nui-atrokiꞌ naan namnekun nrarin, aiꞌ kaah.” Annenan on naan ate, sin nnaon. Mes anbin raan atnanaꞌ on naan ate, nok askeken, sin nareok nanin. ");
INSERT INTO aaz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sin nnaon nkonon ma nmarinan nmaten. Mes tuaf es antbin nfain neem ma nateef nok Naiꞌ Yesus. In nkoaꞌ am nak, “Pures ma boꞌis neu Uisneno! Au ureko ꞌrair, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Onaim in nriꞌtuu ma ntoit makasi kouꞌ-koꞌu neu Naiꞌ Yesus. (Te kaah, in ka atoin Yahudis fa. In reꞌ naan atoin Samarias reꞌ anmakaꞌrais ein piut nok atoin Yahudis sin.) ");
INSERT INTO aaz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Onaim Naiꞌ Yesus nataan neu tuaf ein reꞌ nok Ne ji mnak, “On mee? Feꞌe na Au urekoꞌ tuaf boꞌes, aiꞌ? Tua seoꞌ ne, etan mee? ");
INSERT INTO aaz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nansaaꞌ am es atoin sonaꞌ ia nfain neem he ntoit makasi neu Uisneno, ma nboiꞌs Ee?” ");
INSERT INTO aaz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Onaim Naiꞌ Yesus naꞌuab neu atoniꞌ naan am nak, “Ho mureok goen, natuin ho mpirsai batuur-batuur meu Kau. Onaim amfeen nai, ma mfain nai nok ao-minaꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Neon goes, anmuiꞌ atoin Farisis fauk neman ma nataan Naiꞌ Yesus am nak, “Aam Tungguru! Mutoon miit kai feꞌ! Rekaꞌ te Uisneno nmurai nanaob In aprenat?” Onaim Naiꞌ Yesus nataah am nak, “On nai! Kais mak Uisneno nanaob In aprenat nok tanar humaꞌ-humaꞌ nbi pah-pinan ia, he atoniꞌ bisa niit ee neik matan fuan. Atoniꞌ ka napein fa bukti he nak, ‘Amkius miit ia! Fin Uisneno nanaob In apreent ee, es ia!’ aiꞌ, ‘Es nee!’ Kaah fa, tua! Natuin In nanaob In apreent ee anbi hi sonam ma hi tnaanm ein et tuaf meseꞌ-meseꞌ in nekan nanan.” ");
INSERT INTO aaz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Rarit Naiꞌ Yesus naꞌuab neu In atoup noinꞌ ein am nak, “Ka ꞌroo fa te, Au Mansian Batuur-batuur reꞌ ia, ka ꞌok ki ubua fa goen. Of anbi neon maꞌnuuk ein, hi mroim he miit Kau oras Au ꞌtebi ꞌfain ꞌuum. Mes Au ka ꞌuum fa feꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rarit karu tuaf-tuaf neman ma natonan neu ki mnak, ‘Kristus es ia!’ aiꞌ, ‘Kristus es nee!’, hi kais amtaisiub he maen meu-mꞌiim, fin sin uab ein naan, puta-kriu goah. ");
INSERT INTO aaz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Fin oras reꞌ Mansian Batuur-Batuur naan anfain neem ate, in tanar naan mamnitaꞌ maat-maat, on reꞌ rimat reꞌ nariim he nmoeꞌ neon goe meꞌu naꞌko pani neu panin. ");
INSERT INTO aaz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mes In ro he nasaah haꞌmuꞌit humaꞌ-humaꞌ feꞌ. Ma mansian batan muniꞌ ia, ka nroim fa he nnenan ma ntorak napoitn Ee. ");
INSERT INTO aaz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mes oras In ntebi nfain neem, mansian ein anmonin maufinu on reꞌ biasa, nahuum on reꞌ naiꞌ Noh in baatn ein. ");
INSERT INTO aaz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Oras naan, sin nbukaen, nmoꞌen fesat kabin, tar antea oras naiꞌ Noh antaam neu bnao oe naan. Mes mansian ein ka nromin fa he natninan. Nok askeken ate, noe sakoꞌ nsaen sin ma nareuꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naan humaꞌ meseꞌ amsaꞌ on reꞌ mansian ein reꞌ anmonin maufinu oras naiꞌ Rot in batan. Oras naan, sin nbukaen kuuk, anraakn ein kuuk, nmepun rene, nmoꞌen umi, ma nmonin maufinu on reꞌ biasa sin nmoꞌ-moꞌen. ");
INSERT INTO aaz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mes mansian ein ka nromin fa he natninan. Rarit kik-kiku naan, oras naiꞌ Rot naen nasaitan kota Sodom, nok askeken ate, uur ai ma bariri nmouf neem naꞌko neon goe ma nout nakrat-ratiꞌ sin ok-okeꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Onaim hi mpaant om! Kais-kaisaꞌ Mansian Batuur-Batuur naan anfain neem, ma mansian ein suma nmonin on reꞌ biasa. Mes nok askeken ate, In nboor neem. ");
INSERT INTO aaz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Neno naan, tuaf reꞌ antoko nbi teras, kais amtaam amtein meu uim je nanan he mkikin umi. Tuaf reꞌ anmepu nbi rene, kais amfain he mait antein bareꞌ et umi. ");
INSERT INTO aaz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mimnau naiꞌ Rot in fee oras naan. In on mee? In nmaet, natuin in namnau in baerꞌ ein etan in umi. ");
INSERT INTO aaz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atoniꞌ reꞌ ka nroim fa he natuinaꞌ Kau, natuin in nneek In tuan, in aꞌmoin ee, of ruum am parsuum aah. Mes tuaf reꞌ annonaꞌ in aꞌmonin natuin in nneek Kau, Uisneno of ansoi nafeitn ee naꞌko in saant am penu sin, ma in nmoin nabar-baar nok Ne. ");
INSERT INTO aaz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au utoon ꞌain ki! Oras Mansian Batuur-Batuur ii nkoen On nfain neem, karu anmuiꞌ tuaf nua ntupan nbin harak, nok askeken ate, Uisneno nait tuaf es, ma namaikaꞌ tuaf es. ");
INSERT INTO aaz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Karu anmuiꞌ bifee nua napaun makaꞌ, Uisneno of nait tuaf es, ma namaikaꞌ tuaf es. ");
INSERT INTO aaz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Karu anmuiꞌ tuaf nua antofan nbin rene, Uisneno of nait tuaf es, ma namaikaꞌ tuaf es.” ");
INSERT INTO aaz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Annenan on naan ate, Naiꞌ Yesus In atoup noinꞌ ein nataan Ee mnak, “Aam Tungguru! Of areꞌ rasin naan anjarin nbin mee?” Onait Naiꞌ Yesus anpua-rituꞌ sin uab am nak, “On nai! Karu hi miit koor amneuk puun ein natpeen nabu-buan neun mee te, hi mihiin mak, naan anjair tanar am nak, sin niit puun ee baran.” Anpaek sarit maꞌnifaꞌ, oras Kristus ankoen On nfain neem, in tanar sin of mamnitaꞌ, karu atoniꞌ ntakan nahiin. ");
INSERT INTO aaz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Neot es, Naiꞌ Yesus nanoniꞌ In atoup noinꞌ ein, anpaek uab manporin, maut he sin nꞌoen ein kais natfeek ma kais anꞌoren. Sin ro he npirsain piut-piut neu Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In retaꞌ naan on nai: “Anbi kota es anmuiꞌ afeek rasi reꞌ ka nfairoir fa Uisneno. In ka nrae natuin fa sekau-sekau msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Anbi bare naan anmuiꞌ bifee baun es, neem fani-fani ma ntoit afeek rasi naan am nak, ‘Aam afeek rasi! Mufeek maan kau au rais ji, tua. Mufeek ee te, ro he natai!’ ");
INSERT INTO aaz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nahunu te, afeek rasi naan ka nrae natuin fa bifee banuꞌ naan. Mes anna-nao te, in nrenan bifee banuꞌ naan in hanan. Rarit in ntoko ma natenab am nak, ‘Batuur, au reꞌ ia ka ꞌfairoir fa Uisneno, saaꞌ antein mansian. ");
INSERT INTO aaz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mes bifee banuꞌ ia, annaak menab kau goen. Es naan ate, maut he au ufeek in rais ji, natai feꞌ! Kaah fa te, in of para nfain neem, he nahaeb niis kau goen.’ ");
INSERT INTO aaz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hi mitenab miit afeek rasi reꞌ amaufinut naan in uaban. ");
INSERT INTO aaz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Karu nna-nao ma in nturun bifee banuꞌ naan, Uisneno of anturun Iin na msaꞌ, reꞌ anꞌoen ein fai-manas he ntotin turun-babat naꞌkon Na. Mes Uisneno ka nfeꞌ-feꞌen fa. ");
INSERT INTO aaz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","In nꞌurus sin rasin naan rabah. Onaim Au he utaan ki on nai: oras Au, Mansian Batuur-Batuur reꞌ ia, ꞌtebi ꞌfain ꞌuum aꞌrair, Au of uteef ꞌok atoin apirsait anbin pah-pinan ia, aiꞌ kaah?” ");
INSERT INTO aaz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Naiꞌ Yesus naretaꞌ ntein anpaek uab manporin, anmatoom nok tuaf-tuaf reꞌ naan in tuan ee amneot, ma nasbiniꞌ biak ein. In naretaꞌ mnak, ");
INSERT INTO aaz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Anmuiꞌ naan aꞌnaef nua nnaon nꞌoen ein nbin Uim Onen Uuf. Tuaf es naꞌko pukan partei pirsait Farisi; es antein ahoik beo. Atoin Yahudis sin naan atoin Farisis sin, atoni kninuꞌ. Mes sin naan ahoik beon guin, atoin reꞌuf. ");
INSERT INTO aaz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Antean uim onen on nai te, atoin Farisis naan anfeen anhaek ma nꞌonen am nak, ‘Makasi Usiꞌ, natuin au reꞌ ia, atoin reko. Au ka maufiun fa on reꞌ biak ein. Au ka ubaak, ka ukoom, ka ꞌmakoin fa ꞌok es in fee. Makasi Usiꞌ, natuin au ka ꞌmaufiun fa on reꞌ ahoik beo reꞌ ia. ");
INSERT INTO aaz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au unaah au tuak ii no nua nbi krei jes in nanan. Au ꞌfee bait boꞌ naꞌko saaꞌ-saaꞌ reꞌ au upein kuuk sin.’ Atoin Farisis naan, anꞌonen on reꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mes ahoik beo naan anhaek naꞌroo-ꞌroo nbi kotin nee. In ka nabrain fa he nait in aꞌnakan ma nbaiseun on neno. In nꞌonen, mes in naꞌruir aah, ma in neekn ee kratiꞌ-kratiꞌ mnak, ‘Koi Usiꞌ! Amkasian maan kau, mansian asanat reꞌ ia, tua! Amfee maan kau saok sanat neu areꞌ au saant ein, tua!’ ");
INSERT INTO aaz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Oras tua nuaꞌ ein naan anfanin neun sin umin, sekau es reꞌ nmarameꞌ nrair nok Uisneno? Atoin Farisis abeꞌot naan aa oo, aiꞌ, ahoik beo? In ro he ntoup ahoik beo reꞌ neek maꞌnuraꞌ naan. Mes In ka nrae naan fa atoin Farisis naan. Fin Uisneno ntetak namouf abeꞌot, ma ntunaꞌ naꞌratan atoin neek maꞌnuraꞌ.” ");
INSERT INTO aaz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Neot es, mahoint ein naskau neik sin ana kruuꞌf ein neu Naiꞌ Yesus, he In ntao In aꞌniimk ein he naꞌuab anfeen sin tetus-athoen. Ankius on naan ate, Naiꞌ Yesus In atoup noinꞌ ein nakain mahoint ein naan. ");
INSERT INTO aaz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Mes Naiꞌ Yesus anseun riꞌaan ein naan, he neman neu Ne. Rarit In nakain In atoup noinꞌ ein am nak, “Amkonan riꞌana kruuꞌf ein naan neman neun Kau. Hi kais amꞌekaꞌ sin. Mimnau mirek-rekoꞌ! Fin tuaf-tuaf reꞌ anroim he njair Uisneno Iin ja, in ro he naꞌpesiꞌ in tuan neu Uisneno nahuum on reꞌ riꞌana kruꞌuf reꞌ naꞌpeis ok neu sin ainaf-amaf sin.” ");
INSERT INTO aaz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Neot es, aꞌnakat tuaf es naꞌko atoin Yahudis neem nataan Naiꞌ Yesus am nak, “Aam Tungguru reꞌ mahormataꞌ! Au he ꞌmoeꞌ on mee he uhiin batuur-batuur ꞌak, au bisa ꞌtaam ꞌeu sonaf neno tunan ma ꞌmoin ubar-baar ꞌok Uisneno?” ");
INSERT INTO aaz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Onaim Naiꞌ Yesus nataah am nak, “Nansaaꞌ am es ho musee Kau mmak, ‘reꞌ mahormataꞌ’? Suma tuaf meesꞌ aah reꞌ mahormataꞌ, es reꞌ Uisneno. ");
INSERT INTO aaz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ho muhini mrair Uisneno In atoran naꞌko unuꞌ nak: Kais ammakaek; kais amroor mansian; kais mibaak; kais amjair saksii poi; ma amhormaat ho ainaꞌ-amaꞌ sin.” ");
INSERT INTO aaz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Atoniꞌ naan nataah am nak, “Batuur, Aam! Au utuin aꞌrair atoorn ein naan nmurai naꞌko au aanꞌ-anaꞌ feꞌ!” ");
INSERT INTO aaz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Anneen on naan ate, Naiꞌ Yesus nak, “Reko! Mes ho mkuran rais jes. Oras ia, amtebi mfain nai he muꞌsosaꞌ mporin ho ꞌmuiꞌm ein ok-okeꞌ. Rarit amnao mbait roit ein meu amaꞌmuiꞌt ein. Rarit amtebi mfain uum he mutuin Kau. Fin Uisneno of anbaras anfee ko aꞌmuꞌif sonaf neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Anneen on naan ate, atoniꞌ naan neekn ee nsuus, natuin in aꞌmuiꞌn ii kah een. ");
INSERT INTO aaz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ankius neu in ntebi nfain nok neek susat on naan ate, Naiꞌ Yesus natoon neu In atoup noinꞌ ein am nak, “Atoin amuiꞌt ii, susa maꞌtaniꞌ he ntaam neu sonaf neno tunan. ");
INSERT INTO aaz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hit tataib ee nok rasi bian. Ka neu fa he bikaes unta ntaam neu in oꞌof anpeoꞌ aent ee konan. On naan amsaꞌ atoniꞌ reꞌ suma nharap ma nafnekan anbi in aꞌmuꞌin, mes ka nharap ma nafnekan fa neu Uisneno, ka neu fa he in ntaam neu sonaf neno tunan.” ");
INSERT INTO aaz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Too mfaun ein reꞌ annenan Naiꞌ Yesus naꞌuab on naan, nataan Ee mnak, “Karu batuur susa neu atoin amuꞌit on reꞌ naan, atoniꞌ human on reꞌ mee naꞌ bisa napeni saok sanat ma ꞌhonis?” ");
INSERT INTO aaz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naiꞌ Yesus nataah am nak, “Neu mansian ii te, batuur rasi namfaun ka neu he njair fa. Mes neu Uisneno te, areꞌ saaꞌ-saaꞌ ii ro bisa njarin.” ");
INSERT INTO aaz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Onaim naiꞌ Petrus antuut am nak, “Aam! Hai mnao misaitan hai ꞌmuiꞌm ein oekꞌ een, he mituin Ko. Onaim hai of mipein saaꞌ?” ");
INSERT INTO aaz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Naiꞌ Yesus nataah am nak, “Petrus! Amneen murek-rekoꞌ! Atoniꞌ reꞌ nasaitan in umi, in fee, in orif-tataf, in ainaf-amaf, aiꞌ in aanh ein, natuin in nanaob Uisneno In mepu, ");
INSERT INTO aaz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ro tebes, in ntoup nafaniꞌ sin amfaun anbin pah-pinan ia. Rarit anbi oras neon amsoput, in nmoin nabar-baar nok Uisneno.” ");
INSERT INTO aaz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Naiꞌ Yesus annao nok In atoup noinꞌ ein tuaf boꞌes am nua ma naꞌuab nok sin anmesen am nak, “Hi ar-arki mihini mrair mak, oras ia hit atnao teu kota Yerusalem. Attea nee te, areꞌ rasin reꞌ Uisneno In mafefa kniunꞌ ein antui sin unuꞌ anmatoom nok Mansian Batuur-Batuur naan, of anjair teb-tebe on reꞌ saaꞌ reꞌ sin ntui sin. ");
INSERT INTO aaz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sin of nanaꞌat Kau neu atoin sonaꞌ reꞌ ka npirsain fa neun Uisneno. Rarit sin nakreꞌet Kau, naꞌparan Kau humaꞌ-humaꞌ, npuran hape neu Kau, ");
INSERT INTO aaz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nbeos Kau, rarit anroor naꞌmaet Kau. Mes anmeu on naan ate, Au ꞌmoni ꞌfain.” ");
INSERT INTO aaz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Annenan on naan ate, Naiꞌ Yesus In atoup noinꞌ ein ankekun, natuin sin ka nheek naan fa In uab naan in aꞌmoufun. ");
INSERT INTO aaz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Oras Naiꞌ Yesus sin he noi ntaman neu kota Yeriko, anmuiꞌ atoin afoort es antook ma ntoit roit anbi raan ee ninin. ");
INSERT INTO aaz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Oras in nneen too mfaun ein nnaon npeꞌon naan ate, in nataan sin im nak, “Hoe! Saaꞌ na es reꞌ ia, tua?” ");
INSERT INTO aaz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Onaim sin natoon ee mnak, “Naiꞌ Yesus naꞌko Nasaret, neem annao npeoꞌ reꞌ ia.” ");
INSERT INTO aaz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Anneen on naan ate, aforot naan ankoaꞌ naher-heer am nak, “Yesus! Sufaꞌ-kaꞌuf usif naiꞌ Daut. Amkasian maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tuaf-tuaf reꞌ nahunun anbin Naiꞌ Yesus In matan nakain ee he namninuꞌ. Mes in nkoaꞌ piut, ma naher-heer am nak, “Auwoo, sufaf Daut! Amkasian maan kau, tua!” ");
INSERT INTO aaz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oras Naiꞌ Yesus anneen on naan ate, In nasnaas. Rarit In nreek tuaf he nnao nnaaꞌ neik aforot naan. Neman ntean Naiꞌ Yesus In matan ate, Naiꞌ Yesus nataan ee mnak, ");
INSERT INTO aaz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ho mroim he Au ꞌmoeꞌ saaꞌ ꞌeu ko?” In nataah am nak, “Aam! Au ꞌtoit he au bisa ꞌiit, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naiꞌ Yesus nataah ee mnak, “Reko. Natuin ho mpirsai mak Au bisa ureko ko, onaim oras ia ho mkius nai.” ");
INSERT INTO aaz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nok askeken ate, aforot naan nareok nain. Onaim in natuin Naiꞌ Yesus ma nboꞌis Uisneno. Too mfaun reꞌ nitan on naan, nanaib Uisneno msaꞌ. ");
INSERT INTO aaz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Rarit Naiꞌ Yesus sin antaman npeꞌon kota Yeriko he nnaon nkonon. ");
INSERT INTO aaz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Anbi naan, anmuiꞌ aꞌnaak hoik beo tuaf es neu prenat pah Roma. In kaan ee, naiꞌ Sakeos. In atoin aꞌmuꞌit. ");
INSERT INTO aaz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Oras in nneen Naiꞌ Yesus he neem annao nkoon on nai te, in nroim he niit Naiꞌ Yesus. Mes in ka bisa nkius niit Ee fa nꞌoekn On, natuin too mfaun ein naub naan Naiꞌ Yesus. Ma naiꞌ Sakeos amsaꞌ koer pu-pui. ");
INSERT INTO aaz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Etun in naen nahuun, rarit ansae nbi hau uuꞌ goes anbi raan ee ninin, reꞌ he Naiꞌ Yesus anpeoꞌ naan. ");
INSERT INTO aaz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Neem antea hau naan in uun ate, Naiꞌ Yesus anbaiseun. Rarit noꞌen naiꞌ Sakeos am nak, “Sakeos! Amsaun uum, rabah! Neno ia Au he ꞌtuup aꞌtahan ꞌbi ho umi.” ");
INSERT INTO aaz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Naiꞌ Sakeos anmasauh. Onaim in nsaun rabah, rarit nok Naiꞌ Yesus annaon neu in umi. In nmariin anmat-maet. ");
INSERT INTO aaz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mes too mfaun ein naꞌmuun ein am nak, “Phueh! Naiꞌ Sakeos ia, atoin reꞌuf! Nansaaꞌ am es Naiꞌ Yesus antuup antahan neu naiꞌ Sakeos in umi? Too mfaun ein nahinin nrair je te!” ");
INSERT INTO aaz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Neman ntean umi te, naiꞌ Sakeos anhake nbi Naiꞌ Yesus In matan, ma naꞌuab am nak, “Aam Tungguru! Anmurai neno ia, au ꞌbatis au ꞌmuiꞌk ein batis nua, he ꞌfee batis es ꞌeu amaꞌmuiꞌt ein. Karu au ꞌhoik beo ma bikaseꞌ naen neik anneis-neis, au ꞌfee ufaniꞌ sin no haa.” ");
INSERT INTO aaz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Naiꞌ Yesus nataah am nak, “Reko. Neno ia Uisneno nfee saok sanat ma ꞌhonis neu ho uim ji nanan, natuin ho mpirsai meu Uisneno on reꞌ kaꞌo Abraham. ");
INSERT INTO aaz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fin Uisneno nreek haefan Kau he ꞌjair Mansian Batuur-Batuur aꞌbi pah-pinan ia. Au ꞌuum he ꞌaim tuaf-tuaf aseket naꞌko Uisneno In ranan, he ꞌfeen sin saok sanat ma ꞌhonis.” ");
INSERT INTO aaz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oras naan, anmuiꞌ too mfaun reꞌ nok annenan Naiꞌ Yesus In uaban. Sin he noi ntaman neun kota Yerusalem. Sin nateenb ein nak In he nanaob Uisneno In apreent ee rabah een anbi naan, nahuum on reꞌ usif. Rarit Naiꞌ Yesus naretaꞌ sin reet es anpaek uab manporin, ");
INSERT INTO aaz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","am nak, “Anmuiꞌ naan kaes kouꞌ goes. In he nnao neu pah aꞌpen-pene bian, he sin nasaeb ee ꞌpiruꞌ-baru njair usif. Rarit naꞌ in he nfain neem anjair usif neu in pah aa kuun. ");
INSERT INTO aaz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oras in nabarab anrair he nnao, in noꞌen in ameput tuaf boꞌes, rarit in nanaꞌat sin roit, tuaf es ate, roi noni fuaꞌ es. In nfee prenat am nak, ‘Hi mpaek roit reꞌ ia njair modal. Oras au ꞌfain ꞌuum ate, hi mitoon kau mak hi miis fauk een.’ Rarit in nkoen on. ");
INSERT INTO aaz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mes in too gui bian, ka nroim je fa. Onaim sin nreek haefan tuaf neu bare nee, ma natonan am nak, ‘Hai ka mroim fa tuaf reꞌ ia he in nnaaꞌ aprenat neu kai.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Maski on naan amsaꞌ, mes sin nasaeb ee ꞌpiruꞌ-baru. Rarit in ntebi nfain neem. Neem antea in sonaf, in noꞌen ameput tuaf boꞌes reꞌ naan, rarit nataan sin am nak, ‘Hi miis maan fauk een naꞌko roi nonin reꞌ au ꞌfee sin naan?’ ");
INSERT INTO aaz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ameput ahuunt ee natoon am nak, ‘Usiꞌ! Au ꞌiis no boꞌes naꞌko modal reꞌ ho mfee kau goe ji, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Onaim usif naan nak ee mnak, ‘Reko! Ho reꞌ ia, ameup reok goes. Natuin au bisa ꞌpirsai ko ꞌbi rais aanꞌ-anaꞌ, onaim oras ia ho mnaaꞌ aprenat meu kota boꞌes.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Onaim ameput es natoon am nak, ‘Usiꞌ! Au ꞌiis roi noni fuaꞌ niim naꞌko modal reꞌ au ꞌtoup goe, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Rarit usif naan nak ee mnak, ‘Reko! Karu on naan ate, au ꞌait ko he mnaaꞌ aprenat meu kota niim.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ameput es anteniꞌ neem neik in roi noni naan. Rarit nbaiseun am nak, ‘Usiꞌ, ho roi noin ji es ia, tua. Au ꞌaum goe ma uꞌkoro urek-reokꞌ ee he kais namneuk. ");
INSERT INTO aaz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au ꞌmoeꞌ on reꞌ naan, natuin au umtaus ko, tua. Au uhiin ꞌak ho atoin maputuꞌ ma maꞌtaniꞌ ko, tua. Fin ho biasa mait saaꞌ reꞌ ka ho goa fa, ma mseu saaꞌ reꞌ ho ka mseen ee fa, tua.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Anneen on naan ate, uisf ee naskaar ee mnak, ‘Hoe, amonot! Ho uabam naan neik kuun atfekaꞌ neu ko. Ho mak oniꞌ au maꞌtaniꞌ kau, reꞌ au ꞌait saaꞌ reꞌ ka au goa fa, ma ꞌseu saaꞌ reꞌ ka ꞌseen ee fa. ");
INSERT INTO aaz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Karu on naan ate, nansaaꞌ am es ho ka mutunuꞌ fa roit ia meu bank? He oras au ꞌfain ꞌuum ate, au upein in sufan, maski kreꞌ-reꞌo msaꞌ, reko.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Onaim usif naan anreun tuaf bian anbin naan am nak, ‘Mait in roit naan, ma mnoon ee meu ameput reꞌ niis fuaꞌ boꞌes feꞌe na.’ ");
INSERT INTO aaz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mes sin nprotesan am nak, ‘Usiꞌ! Atoniꞌ naan in napein sero mfaun een. Onait nansaaꞌ am es tait taꞌko tuaf reꞌ anmuiꞌ kreꞌ-reꞌo, he taꞌbabaꞌ tteinꞌ ee?’ ");
INSERT INTO aaz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mes usif naan nataah am nak, ‘Mitenab mirek-rekoꞌ! Fin tuaf reꞌ anꞌurus nahiin saaꞌ reꞌ tuaf nanaaꞌt ee neu ne, of natnanab anfee ne. Mes tuaf reꞌ napeeh he nꞌurus saaꞌ reꞌ tuaf nanaaꞌt ee neu ne, of ansain nain saaꞌ-saaꞌ reꞌ in nmuiꞌ sin. ");
INSERT INTO aaz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Onaim oras ia, hi mnao mheek au musun reꞌ ka nroim kau fa he ꞌjair usif. Meik sin neman neun ia, rarit amroor sin anbin au matak. Amnao nai!’ ” ");
INSERT INTO aaz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Naiꞌ Yesus naretaꞌ nrair on naan ate, sin nnaon nkonon neun kota Yerusalem. Naiꞌ Yesus nahuun. ");
INSERT INTO aaz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oras sin he ntean kuan nua, es reꞌ kuan Betfage ma kuan Betania, reꞌ etan aꞌtoꞌef Saitun in ninin, In nreek haefan in atoup noniꞌ tuaf nua he nnaon nahunun. ");
INSERT INTO aaz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","In nreun sin am nak, “Hi mnao meu kuan reꞌ abit matan nee. Hi of miit bikaes keledai aan es mafutuꞌ et naan. Atoniꞌ ka nsaen niitn ee fa feꞌ. Hi mseif je, ma mheer meik je neem. ");
INSERT INTO aaz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Karu tuaf nataan ki mnak, ‘Nansaaꞌ am es hi mseif bikaes keledai naan?’ Hi mitaah am mak, ‘Hai Usiꞌ nroim he npake.’ ” ");
INSERT INTO aaz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Rarit sin nua sin nnaon ma niit bikaes keledai anaꞌ naan, on reꞌ Naiꞌ Yesus naꞌuab. ");
INSERT INTO aaz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Oras sin nseif bikaes keledai naan, in tuan ee nataan sin am nak, “Hoe! Nansaaꞌ am es hi mseif hai bikaes aan?” ");
INSERT INTO aaz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Onait sin natahan am nak, “Hai Usiꞌ anroim he npaek je, tua.” ");
INSERT INTO aaz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bikaes tuaf naan anroim, rarit sin nua sin anheer neik bikaes keledai naan neu Naiꞌ Yesus. Sin naꞌpeniꞌ bikaseꞌ naan npaken tai koꞌu. Onaim sin nasaeb Naiꞌ Yesus. ");
INSERT INTO aaz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Too mfaun ein nait sin tai muit ein ma sin pouk ein, rarit naꞌbeen sin anbin ranan, he nseun Naiꞌ Yesus on reꞌ kaes koꞌu. ");
INSERT INTO aaz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oras In nmurai nnao neiki nsanun naꞌko ꞌtoꞌef Saitun ate, too mfaun ein ma In atoup noinꞌ ein anmurai nkoaꞌ ein, ma nsakanan neik pures-boꞌis neu Uisneno, natuin areꞌ kanan kuasa sin tanar reꞌ sin niit sin naan. ");
INSERT INTO aaz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sin nsakanan am nak, “In reꞌ ia, Usif reꞌ Uisneno nreek haefn Ee neem! Uisneno