﻿USE sofia;
DROP TABLE IF EXISTS sofia.aak_vpl;
CREATE TABLE aak_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aak_vpl WRITE;
INSERT INTO aak_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xwɨyɨ́á rɨpɨ ɨ́wiárɨ́awé Jisasɨ Kiraisoyá nánɨrɨnɨ. Oyá ɨ́wiárɨ́awé nimóga nurɨ áwɨnɨ e mɨxɨ́ ináyɨ́ Depitorɨnɨ. Depitoyá ɨ́wiárɨ́awé nimóga nurɨ wigɨ́ xiáwo írɨŋo Ebɨrɨ́amorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebɨrɨ́amo Aisakomɨ emeaŋɨnigɨnɨ. E dánɨ Aisako Jekopomɨ emeaŋɨnigɨnɨ. E dánɨ Jekopo Judaomɨ tɨ́nɨ xegɨ́ xexɨrɨ́meáowamɨ tɨ́nɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","E dánɨ Judáo xiɨ́áí Temaí tɨ́nɨ ɨ́wɨ́ ninɨri Pereso tɨ́nɨ Serao tɨ́nɨ emeaŋɨnigɨnɨ. E dánɨ Pereso Xesɨronomɨ emeaŋɨnigɨnɨ. E dánɨ Xesɨrono Ramomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","E dánɨ Ramo Aminadapomɨ emeaŋɨnigɨnɨ. E dánɨ Aminadapo Nasonomɨ emeaŋɨnigɨnɨ. Nasono e dánɨ Sarɨmonomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","E dánɨ Sarɨmono émáyɨ́ apɨxí Rexapí nɨmearɨ Bowasomɨ emeaŋɨnigɨnɨ. E dánɨ Bowaso Rutímɨ nɨmearɨ Obetomɨ emeaŋɨnigɨnɨ. Obeto e dánɨ Jesiomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesio e dánɨ mɨxɨ́ ináyɨ́ Depitomɨ emeaŋɨnigɨnɨ. Depito e dánɨ apɨxɨ́ Yuraiaoyáí nurápɨrɨ Soromonomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromono e dánɨ Riabowamomɨ emeaŋɨnigɨnɨ. Riabowamo e dánɨ Abaisaomɨ emeaŋɨnigɨnɨ. Abaisao e dánɨ Esaomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esao e dánɨ Jexosapetomɨ emeaŋɨnigɨnɨ. Jexosapeto e dánɨ Joramomɨ emeaŋɨnigɨnɨ. Joramo e dánɨ Asaiaomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaiao e dánɨ Jotanomɨ emeaŋɨnigɨnɨ. Jotano e dánɨ Exaso emeaŋɨnigɨnɨ. Exaso e dánɨ Xesekaiaomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xesekaiao e dánɨ Manasaomɨ emeaŋɨnigɨnɨ. Manasao e dánɨ Emosomɨ emeaŋɨnigɨnɨ. Emoso e dánɨ Josaiaomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","12","Josaiao —Babironɨ dáŋɨ́ émáyɨ́ mɨxɨ́ nɨmeáa nɨbɨro Judayo nɨpɨkiomearo ɨwɨ́ nɨmearo nɨmeámɨ úáná Judayɨ́ aŋɨ́ e xwiogwɨ́ obaxɨ́ ŋweaŋáná Josaiao e dánɨ Jekonaiaomɨ tɨ́nɨ xegɨ́ xexɨrɨ́meáowamɨ tɨ́nɨ emeaŋɨnigɨnɨ. Jekonaiao e dánɨ Siatieromɨ emeaŋɨnigɨnɨ. Siatiero e dánɨ Serababeromɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababero e dánɨ Abiudomɨ emeaŋɨnigɨnɨ. Abiudo e dánɨ Eraiakimomɨ emeaŋɨnigɨnɨ. Eraiakimo e dánɨ Esomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso e dánɨ Sedokomɨ emeaŋɨnigɨnɨ. Sedoko e dánɨ Ekimomɨ emeaŋɨnigɨnɨ. Ekimo e dánɨ Eraiatomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eraiato e dánɨ Ereasaomɨ emeaŋɨnigɨnɨ. Ereasao e dánɨ Matanomɨ emeaŋɨnigɨnɨ. Matano e dánɨ Jekopomɨ emeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopo e dánɨ Josepo, Mariaímɨ xiagwomɨ emeaŋɨnigɨnɨ. Í Jisasomɨ xɨrɨŋɨnigɨnɨ. O yeáyɨ́ neayimɨxemeanɨ́a nánɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ xegɨ́ xiáwowayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋo eŋagɨ nánɨ xegɨ́ yoɨ́ bɨ Kiraisoyɨ rɨgɨ́orɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ayɨnánɨ xiáwo írɨŋo Ebɨrɨ́amo nemeága nɨbɨro mɨxɨ́ ináyɨ́ Depito emeaŋe nánɨ xiáwowa wé wúkaú sɨkwɨ́ waú waú imónɨŋɨ́rɨnɨ. Xiáwo Depito ŋweaŋe dánɨ nemeága nɨbɨro Babironɨ kɨrapusɨ́ omɨŋɨ́ wigɨ́e nánɨ xiáwowa wé wúkaú sɨkwɨ́ waú waú enɨ imónɨŋɨ́rɨnɨ. Omɨŋɨ́ wigɨ́e dánɨ Jisaso rémoŋe nánɨ ámɨ xiáwowa wé wúkaú sɨkwɨ́ waú waú imónɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Xwɨyɨ́á Jisasɨ Kiraiso xɨrɨŋe nánɨ rɨpɨrɨnɨ. Omɨ xɨnáí Mariaí Josepo meáwɨnɨgɨnɨrɨ ikɨyiŋɨ́ nɨyárɨmáná eŋáná ayaú sɨnɨ nɨmeánɨmɨ memé eŋáná í rɨxa Gorɨxoyá kwíyɨ́ tɨ́nɨ niaíwɨ́ agwɨ́ eŋɨnigɨnɨ. Í niaíwɨ́ agwɨ́ eŋagɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josepo, ímɨ meanɨ́o ámá sanɨŋo eŋagɨ nánɨ “Xwɨyɨ́á ímɨ ayá winɨpaxɨ́ wí murɨpa oemɨnɨ.” nɨyaiwirɨ “Ímɨ yumɨ́í emɨ omómɨnɨ.” nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sɨnɨ dɨŋɨ́ e nɨmóa warɨ́ná re eŋɨnigɨnɨ. Orɨŋá wɨnarɨ́ná Gorɨxoyá aŋɨ́najɨ́ wo sɨŋánɨ nɨwimónɨrɨ re urɨŋɨnigɨnɨ, “Josepoxɨ, mɨxɨ́ ináyɨ́ Depitoyá xiáwoxɨnɨ, dɨxɨ́ apɨxɨ́ Mariaímɨ éɨ́ nɨwirɨ emɨ mɨmopanɨ. Niaíwo ímɨ kwíyɨ́ Gorɨxoyápimɨ dánɨ eweáo eŋagɨ nánɨ ananɨ meaɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Í niaíwɨ́ oxɨ́ wo xɨrɨnɨ́árɨnɨ. Ámá xegɨ́ imónɨgɨ́áyo ɨ́wɨ́ yarɨgɨ́ápɨ nánɨ xwɨyɨ́á meárɨnɨpɨ́rɨxɨnɨrɨ yokwarɨmɨ́ nɨwiirɨ yeáyɨ́ uyimɨxemeanɨ́á eŋagɨ nánɨ xegɨ́ yoɨ́ Jisasoyɨ wɨ́rɨ́ɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ayɨ́ eŋíná wɨ́á rókiamoagɨ́á wo áwaŋɨ́ nɨrɨrɨ rɨ́wamɨŋɨ́ eaárɨŋɨ́ rɨpɨ “Re enɨ́árɨnɨ. Apɨxɨ́ oxɨ́ mɨmeánɨŋɨ́ wí niaíwɨ́ agwɨ́ nerɨ oxɨ́ wo xɨránáyɨ́, yoɨ́ Emaniueroyɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ Gorɨxo nene tɨ́nɨ nawínɨ ŋweanɨ́a nánɨrɨnɨ. Yoɨ́ e wɨ́rɨpɨ́rɨ́árɨnɨ.” Rɨ́wamɨŋɨ́ e nɨrɨrɨ eaárɨŋɨ́ apɨ xɨxenɨ imónɨnɨ́a nánɨ e imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aŋɨ́najɨ́ Gorɨxoyáo e urɨ́agɨ Josepo sá weŋe dánɨ nɨwiápɨ́nɨmearɨ aŋɨ́najo sekaxɨ́ urɨ́ɨ́pa nerɨ xegɨ́ apɨxɨ́ Mariaímɨ meaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ímɨ nɨmearɨ aí sɨnɨ niaíwo mɨxɨrɨpa nerɨ́ná í tɨ́nɨ sá bɨ mɨwé néra núɨsáná í rɨxa niaíwo xɨráná xegɨ́ yoɨ́ Jisasoyɨ wɨ́rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mariaí Jisasomɨ Judia pɨropenɨsɨ́yo aŋɨ́ yoɨ́ Betɨrexemɨ dánɨ nɨxɨrɨmáná eŋáná Judayɨ́ ámɨná wo mɨxɨ́ ináyɨ́ Xerotoyɨ rɨnɨŋo Jerusaremɨyo nɨŋwearɨ xegɨ́ Judayo meŋweaŋáná re eŋɨnigɨnɨ. Ámá siŋɨ́ nánɨ eŋwɨpearɨgɨ́á wa sogwɨ́ ɨ́wiaparɨŋɨ́mɨ dánɨ nɨbɨro Jerusaremɨ nɨrémoro ");
INSERT INTO aak_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yarɨŋɨ́ re wigɨ́awixɨnɨ, “Judayɨ́ mɨxɨ́ ináyɨ́ imónɨnɨ́a nánɨ niaíwɨ́ sɨŋɨ́ xɨrɨŋo gerɨnɨ? Sogwɨ́ ɨ́wiaparɨŋɨ́mɨnɨ nɨŋwearɨ́ná omɨ xɨráná siŋɨ́ o nánɨ ŋweáagɨ sɨŋwɨ́ nɨwɨnɨrane nánɨ omɨ yayɨ́ oumeanɨrane barɨŋwɨnɨ.” urémeáagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","mɨxɨ́ ináyɨ́ Xeroto “Niaíwo mɨxɨ́ ináyɨ́ nimónɨrɨ nɨmúronɨrɨ́enɨŋoɨ?” nɨyaiwirɨ dɨŋɨ́ rɨ́á nuxerɨ Jerusaremɨ ŋweáyɨ́ nɨ́nɨ enɨ dɨŋɨ́ rɨ́á nuxéa úagɨ ");
INSERT INTO aak_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","o apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwamɨ tɨ́nɨ awí neaárɨmáná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Kiraisoyɨ rɨnɨŋo, yeáyɨ́ neayimɨxemeanɨ́a nánɨ negɨ́ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo rɨ́wamɨŋɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ ge xɨrɨpɨ́rɨ́a nánɨ rɨnɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","awa re urɨgɨ́awixɨnɨ, “Negɨ́ Judia pɨropenɨsɨ́yo re aŋɨ́ yoɨ́ Betɨrexemɨyo xɨrɨpaxɨ́ imónɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Wɨ́á rókiamoagɨ́á wo áwaŋɨ́ nɨwurɨyirɨ rɨ́wamɨŋɨ́ re eaárɨŋɨ́rɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judayɨ́ aŋɨ́yo aŋɨ́ yoɨ́ Betɨrexemɨ ŋweáyɨ́né aŋɨ́ nɨyonɨ nánɨ ámá obaxɨ́yɨ́né meŋagɨ aiwɨ segɨ́ ámá wo mɨxɨ́ ináyɨ́ nimónɨrɨ gɨ́ Judayɨ́ nɨyonɨ meŋweanɨ́á eŋagɨ nánɨ segɨ́ aŋɨ́ apɨ aŋɨ́ xwé tɨ́nɨ xɨxenɨ imónɨnɨ́árɨnɨ.’ nɨrɨrɨ eaárɨŋɨ́rɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Xeroto yumɨ́í dɨŋɨ́ nɨyaiwimáná “Siŋɨ́yo eŋwɨpearɨgɨ́áwa obɨ́poyɨ.” nɨrɨrɨ awa rɨxa báná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Siŋo gíná ŋweáagɨ wɨnɨgɨ́awixɨnɨ. Siŋomɨ sɨŋwɨ́ nɨwɨnɨmáná eŋáná emá ararɨ pweŋɨ́rɨnɨ?” urɨ́agɨ awa rɨxa áwaŋɨ́ uráná ");
INSERT INTO aak_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","o Betɨrexemɨ nánɨ re urowárɨŋɨnigɨnɨ, “Soyɨ́né nuro niaíwo nánɨ píránɨŋɨ́ pɨ́á époyɨ. Rɨxa sɨŋwɨ́ nɨwɨnɨróná nionɨ enɨ nurɨ yayɨ́ seáyɨ e umemɨnɨrɨ nánɨ ámɨ nɨbɨro áwaŋɨ́ nɨrɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","awa arɨ́á e nɨwiro wigɨ́pɨ óɨ́yo warɨ́ná re eŋɨnigɨnɨ. Siŋɨ́ awa xámɨ sogwɨ́ ɨ́wiaparɨŋɨ́mɨnɨ nɨŋwearóná wɨnɨgɨ́o awamɨ xámɨ numearɨ aŋɨ́ niaíwo weŋiwámɨ seáyɨ e ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Siŋo e ŋweáagɨ nɨwɨnɨro seáyɨmɨ seáyɨmɨ nimónɨro dɨŋɨ́ niɨ́á nɨwinɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","aŋiwámɨ nɨpáwiro niaíwo xɨnáí Mariaí tɨ́nɨ ŋweaŋagɨ́i nɨwɨnɨro re egɨ́awixɨnɨ. Xwɨ́áyo nɨpɨ́kínɨmearo omɨ yayɨ́ numemáná amɨpí o nánɨ imónɨŋɨ́ wigɨ́ ayá rɨmɨxarɨgɨ́ápɨ nɨroaro sɨ́ŋá gorɨ́ tɨ́nɨ íkɨ́á dɨ́á —Dɨ́á yoɨ́ pɨrakenɨsanɨ́ tɨ́nɨ murɨ́ tɨ́nɨ nánɨ rɨnɨnɨ. Dɨ́á apɨ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ xɨxegɨ́nɨ sɨxɨ́ wɨ́xaú tɨ́nɨ mɨnɨ wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mɨnɨ nɨwimáná eŋáná Gorɨxo orɨŋá nupárɨrɨ rɨ́mɨŋɨ́ re urɨŋɨnigɨnɨ, “Mɨxɨ́ ináyɨ́ Xeroto tɨ́ŋɨ́ e nánɨ ámɨ mupa époyɨ.” urɨ́agɨ wigɨ́ aŋɨ́ e nánɨ nuróná óɨ́ xegɨ́ wíyo ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Awa rɨxa numáná eŋáná re eŋɨnigɨnɨ. Josepo orɨŋá nɨwɨnɨrɨ́ná aŋɨ́najɨ́ Gorɨxoyá wo sɨŋánɨ nɨrónapɨrɨ re urɨŋɨnigɨnɨ, “Rɨxa nɨwiápɨ́nɨmearɨ niaíwo tɨ́nɨ xɨnáí tɨ́nɨ nɨmeámɨ Isipɨyɨ́ aŋɨ́yo nánɨ éɨ́ úpoyɨ. Sepɨ́oyɨ́né nuro rémóɨ́e dánɨ ámɨ nionɨ searɨmɨ́aé nánɨ ŋweáɨ́rɨxɨnɨ. Xeroto niaíwomɨ pɨkinɨ pɨ́á énapɨnɨ eŋagɨ nánɨ rɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","o árɨ́wɨyimɨ aí nɨwiápɨ́nɨmearɨ niaíwo tɨ́nɨ xɨnáí tɨ́nɨ nɨmeámɨ Isipɨyɨ́ aŋɨ́yo nánɨ nuro ");
INSERT INTO aak_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nɨŋwearóná mɨxɨ́ ináyɨ́ Xeroto pée nánɨ ŋweaagɨ́árɨnɨ. Wɨ́á rókiamoagɨ́á wo xwɨyɨ́á Gorɨxoyá nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaárɨŋɨ́ rɨpɨ “Gɨ́ íwo Isipɨyɨ́ aŋɨ́yo ŋweaŋáná ‘Eɨnɨ.’ urɨmɨ́árɨnɨ.” nɨrɨrɨ eaárɨŋɨ́ apɨ xɨxenɨ imónɨnɨ́a nánɨ Josepo niaíwomɨ Isipɨyɨ́ aŋɨ́yo nánɨ nɨmeámɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Xeroto, Jerusaremɨyo xwayɨ́ nanɨrɨ ŋweaŋo sogwɨ́ ɨ́wiaparɨŋɨ́mɨ dánɨ urɨ́nénaparɨgɨ́áwa ámɨ xɨ́omɨ mɨwíménapɨ́agɨ́a nánɨ “Yapɨsɨ́ rɨ́a níwapɨyíoɨ?” nɨyaiwirɨ dɨŋɨ́ rɨ́á ápiáwɨ́nɨŋɨ́ wéagɨ xewanɨŋo awamɨ siŋo nánɨ yarɨŋɨ́ wíáná awa “Íná ŋweáagɨ wɨnɨŋwanigɨnɨ.” urɨ́ápɨ nánɨ dɨŋɨ́ nɨmorɨ porisowamɨ urowáráná awa nuro niaíwɨ́ oxɨ́ Betɨrexemɨ dáŋɨ́yɨ́yá tɨ́nɨ e mɨdɨmɨdánɨ nɨŋweaxa pugɨ́áyɨ́yá tɨ́nɨ, niaíwɨ́ oxɨ́ wigɨ́ xwiogwɨ́ waú wo sɨnɨ mɨmúropa egɨ́á nɨyonɨ mɨŋɨ́ rɨrómɨ́ emegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Mɨŋɨ́ rɨrómɨ́ eméáná xwɨyɨ́á Gorɨxoyá wɨ́á rókiamoagɨ́ Jeremaiaoyɨ rɨnɨŋo nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaárɨŋɨ́ rɨpɨ “Aŋɨ́ Rama dánɨ ‘Yeyɨ.’ nɨrɨnɨrɨ ŋwɨ́ eánarɨŋagɨ arɨ́á wiarɨŋoɨ. Reserímɨ xiɨ́áíwa wigɨ́ niaíwɨ́ nánɨ ŋwɨ́ pɨyɨ́ nɨwɨ́rɨnɨro wigɨ́ niaíwɨ́ wówɨ sɨŋwɨ́ mɨwɨnɨ́agɨ́a nánɨ mɨŋɨ́ ikɨŋwɨ́ umɨrɨ́agɨ́a aiwɨ pɨ́nɨ mɨwiárɨgɨ́awixɨnɨ.” rɨ́wamɨŋɨ́ eaárɨŋɨ́ apɨ íná xɨxenɨ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Xeroto rɨxa nɨpéáná re eŋɨnigɨnɨ. Josepo Isipɨyɨ́ aŋɨ́yo dánɨ orɨŋá nɨwɨnɨrɨ́ná aŋɨ́najɨ́ Gorɨxoyá wo sɨŋánɨ nɨrónapɨrɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Niaíwomɨ opɨkianeyɨnɨrɨ emegɨ́áwa rɨxa pegɨ́á eŋagɨ nánɨ nɨwiápɨ́nɨmearɨ niaíwo tɨ́nɨ xɨnáí tɨ́nɨ nɨmeámɨ dɨxɨ́ Isɨrerɨyɨ́ aŋɨ́yo nánɨ úpoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josepo nɨwiápɨ́nɨmearɨ niaíwo tɨ́nɨ xɨnáí tɨ́nɨ nɨmeámɨ nurɨ Isɨrerɨyɨ́ aŋɨ́yo nɨrémoro ");
INSERT INTO aak_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josepo arɨ́á re wiŋɨnigɨnɨ, “Xerotomɨ xewaxo Akereasoyɨ rɨnɨŋo xano mɨxɨ́ ináyɨ́ nimónɨrɨ neameŋweaagɨ́pa xewaxo enɨ mɨxɨ́ ináyɨ́ e nimónɨrɨ Judia pɨropenɨsɨ́yo re neameŋweanɨ.” rarɨŋagɨ́a arɨ́á nɨwirɨ wáyɨ́nɨwinɨrɨ “Arɨge nurɨ Judia pɨropenɨsɨ́yo ŋweámɨnɨréɨnɨ?” yaiwiarɨ́ná Gorɨxo Josepomɨ orɨŋá nupárɨrɨ éɨ́ urowáráná epówa Judia pɨropenɨsɨ́yo wiárɨ́ nɨmúroro Gariri pɨropenɨsɨ́yo nánɨ nuro ");
INSERT INTO aak_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","aŋɨ́ yoɨ́ Nasaretɨ rɨnɨŋɨ́pimɨ ŋweaagɨ́árɨnɨ. Wɨ́á rókiamoagɨ́áwa ámá xiáwowayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ re rɨgɨ́ápɨ “Ayɨ́ re rɨpɨ́rɨ́árɨnɨ, ‘O Nasaretɨ dáŋorɨnɨ.’ rɨpɨ́rɨ́árɨnɨ.” rɨgɨ́á apɨ xɨxenɨ imónɨ́wɨnɨgɨnɨrɨ Nasaretɨ nánɨ nuro ŋweaagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jono, wayɨ́ numeaia uŋo, Jisaso sɨnɨ Nasaretɨ ŋweaŋáná, o nurɨ Judia pɨropenɨsɨ́yo ámá dɨŋɨ́ meaŋe wáɨ́ nurɨmerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","re urayagɨ́rɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨneairɨ píránɨŋɨ́ neameŋweanɨ aŋwɨ ayo eŋagɨ nánɨ segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro píránɨŋɨ́ nɨsanɨro ŋweáɨ́rɨxɨnɨ.” urayagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨ́pɨ, “Ámá dɨŋɨ́ meaŋɨ́mɨ dánɨ ámá wo rɨ́aiwá re rarɨnɨ, ‘Ámɨnáo nánɨ segɨ́ dɨŋɨ́ óɨ́ naŋɨ́nɨŋɨ́ wimoiro óɨ́ píránɨŋɨ́ imoarɨgɨ́ápánɨŋɨ́ wimoiro nero ŋweáɨ́rɨxɨnɨ.’ rarɨnɨ.” rɨ́wamɨŋɨ́ e nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ xɨxenɨ Jono nurɨ axɨ́pɨ e yagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","O rapɨrapɨ́ naŋɨ́ nɨyínɨrɨ emeagomanɨ. Kamerɨ́ ɨ́á (iyɨ́á írɨkwɨ́nɨŋɨ́ imónɨŋɨ́ wú) nɨyínɨrɨ arerɨxɨ́ írɨŋɨ́yo yínagorɨnɨ. Aiwá enɨ naŋɨ́ nagomanɨ. Áxwaxɨ́ tɨ́nɨ pɨ́kɨ́ iniɨgɨ́ tɨ́nɨ nagorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Judayɨ́ wigɨ́ aŋɨ́ xwé Jerusaremɨ ŋweagɨ́áyɨ́ tɨ́nɨ Judia pɨropenɨsɨ́yo amɨ amɨ ŋweagɨ́áyɨ́ nɨ́nɨ tɨ́nɨ iniɨgɨ́ Jodanɨ rapápámɨ ŋweagɨ́áyɨ́ tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jono tɨ́ŋɨ́ e nánɨ nuro wigɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ nánɨ waropárɨ́ wíáná o wayɨ́ numeaia nurɨ aí ");
INSERT INTO aak_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parisiowa tɨ́nɨ Sajusiowa tɨ́nɨ —Awa weyɨ́nɨ nɨmenɨro ámá wíyo seáyɨ e wimónarɨgɨ́áwarɨnɨ. Awa Jono wayɨ́ oneameainɨro barɨŋagɨ́a Jono sɨŋwɨ́ e nɨwɨnɨrɨ ayɨ́ wigɨ́ ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro mé “Wayɨ́nɨ oneameainɨ.” nɨyaiwiro barɨŋagɨ́a nɨwɨnɨrɨ nánɨ re urɨŋɨnigɨnɨ, “Sidɨrɨ́ miáoyɨ́né, ‘Rɨ́wéná Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ éɨ́ úpoyɨ.’ go searɨ́agɨ rɨ́nɨŋɨ́ meaanɨgɨnɨrɨ wáyɨ́ nero nionɨ tɨ́ámɨnɨ éɨ́ barɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Soyɨ́né ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamorɨ́náyɨ́, píránɨŋɨ́ nero íkɨ́á sogwɨ́ naŋɨ́ nɨwerɨ́ná yarɨŋɨ́pa imónɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Re mɨnɨrɨpa époyɨ, ‘Negɨ́ arɨ́o Ebɨrɨ́amoyáone eŋagɨ nánɨ Gorɨxo wí xeanɨŋɨ́ neaikárɨnɨ́á menɨnɨ.’ mɨnɨrɨpa époyɨ. Gorɨxo ‘Ebɨrɨ́amoyá ɨ́wiárɨ́awé nánɨ “Nionɨ ayo xeanɨŋɨ́ nɨwirɨ́ná arɨge xwé obaxɨ́ imónɨnɨ́árɨnɨ?” nɨyaiwirɨ ududɨ́ winarɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ, Gorɨxo dɨŋɨ́ e yaiwipaxɨ́ menɨnɨ. Ananɨ sɨ́ŋá tɨ́yo dánɨ Ebɨrɨ́amo nánɨ ɨ́wiárɨ́awé wimɨxɨyipaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gorɨxo rɨxa rapɨwé íkɨ́á mɨ́kɨ́ tɨ́ŋɨ́ e nánɨ ɨ́á xɨrɨnɨ. Íkɨ́á gɨnɨ gɨna sogwɨ́ naŋɨ́ mɨwéagɨ nɨwɨnɨrɨ́ná nɨdɨkárɨrɨ rɨ́á ikeaárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nionɨ sa iniɨgɨ́ tɨ́nɨ wayɨ́ seameaiarɨŋárɨnɨ. Nionɨ eŋɨ́ eánɨŋáonɨ aiwɨ rɨ́wɨ́yo bɨnɨ́o nionɨ nɨmúrónɨnɨ. Seyɨ́né nionɨ nánɨ ‘Ámá wé rónɨŋorɨnɨ.’ niaiwiarɨŋagɨ́a aiwɨ o nionɨ tɨ́nɨ xɨxenɨ mimónɨŋagɨ nánɨ ámá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́ bosoyá sɨkwɨ́ sú gwɨ́ wíkweaiarɨgɨ́ápa nionɨ oyá wíkweaipaxɨ́ menɨnɨ. O wayɨ́ nɨseameairɨ́ná iniɨgɨ́ tɨ́nɨ seameainɨ́ámanɨ. Wiyɨ́né Gorɨxoyá kwíyɨ́ tɨ́nɨ seameairɨ wiyɨ́né rɨ́á tɨ́nɨ seameairɨ enɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gorɨxo ámá naŋɨ́yo yeáyɨ́ uyimɨxemearɨ sɨpíyo anɨpá imɨxɨrɨ enɨ́á eŋagɨ nánɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Omɨŋɨ́ yarɨgɨ́áyɨ́ pokɨ́ tɨ́nɨ witɨ́ aiwá eyeyírómɨ́ ero aiwá ná aŋɨ́yo tɨro mamɨwɨ́ tɨ́nɨ sɨyikɨ́ tɨ́nɨ rɨ́á ikeaárɨro yarɨgɨ́ápa Gorɨxo enɨ axɨ́pɨ e emɨ́ánɨrɨ witɨ́ mamɨwɨ́ tɨ́nɨ ná tɨ́nɨ eyeyírómɨ́ inɨŋe xegɨ́ pokɨ́ ɨ́á nɨxɨrɨrɨ ronɨ. Aiwá náyɨ́ aŋɨ́yo tɨrɨ mamɨwɨ́ tɨ́nɨ sɨyikɨ́ tɨ́nɨ rɨ́á supárɨpaxɨ́ mimónɨŋɨ́yo ikeaárɨrɨ enɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisaso Jono wayɨ́ onɨmeainɨrɨ nánɨ Gariri pɨropenɨsɨ́yo dánɨ nɨbɨrɨ iniɨgɨ́ Jodanɨ rapá tɨ́ŋɨ́ e nɨrémorɨ omɨ wímeáagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jono nurakímɨnɨrɨ nerɨ re urɨŋɨnigɨnɨ, “Joxɨ nionɨ nánɨ o wayɨ́ onɨmeainɨrɨ rɨbarɨŋɨnɨ? Oweoɨ, ‘Joxɨ wayɨ́ onɨmeainɨ.’ nimónarɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisaso re urɨŋɨnigɨnɨ, “Xe wayɨ́ oumeaimɨnɨrɨ sɨŋwɨ́ naneɨ. E neraínáyɨ́, Gorɨxo nionɨ nánɨ ‘O sɨwɨ́ wé rónɨŋɨ́yɨ́ nɨ́nɨ oenɨ.’ yaiwiarɨŋɨ́pɨ xɨxenɨ yanɨ́wiɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","o Jisasomɨ wayɨ́ umeaíáná o rɨxa nímɨnɨmeámɨ peyarɨ́ná re eŋɨnigɨnɨ. Aŋɨ́ pɨrɨ́yo dánɨ óɨ́ ináná kwíyɨ́ Gorɨxoyápɨ xawiówɨ́nɨŋɨ́ nɨweapɨrɨ omɨ wímeaŋɨnigɨnɨ. Omɨ wímeááná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aŋɨ́namɨ dánɨ xwɨyɨ́á re rɨnénapɨŋɨnigɨnɨ, “Gɨ́ niaíwɨ́ ayá tɨ́ŋorɨnɨ. Amɨpí o yarɨŋɨ́pɨ nánɨ yayɨ́ ninarɨnɨ.” rɨnénapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kwíyɨ́ Gorɨxoyápɨ Jisasomɨ nɨwímeámáná omɨ Obo iwamɨ́ó owíwapɨyinɨrɨ ámá dɨŋɨ́ meaŋɨ́ e nánɨ nɨméra úáná ");
INSERT INTO aak_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","o aiwá mɨnɨ́ ŋwɨ́á nɨŋwearɨ rɨxa sɨ́á 40 nórɨmáná eŋáná o agwɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","iwamɨ́ó wíwapɨyarɨŋo nɨbɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ ‘Niaíwɨ́ Gorɨxoyáonɨrɨnɨ.’ yaiwinarɨŋɨ́pɨ nepa eŋánáyɨ́, aiwá nɨrɨ nánɨ ‘Sɨ́ŋá tɨyɨ́ aiwá oimónɨnɨ.’ reɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisaso re urɨŋɨnigɨnɨ, “Oweoɨ, wí emɨméɨnɨ. Gorɨxoyá Bɨkwɨ́yo dánɨ rɨ́wamɨŋɨ́ re eánɨnɨ, ‘Ámá aiwá nánɨnɨ dɨŋɨ́ nɨmorɨ́náyɨ́ wí dɨŋɨ́ meapaxɨ́ menɨnɨ. Xwɨyɨ́á Gorɨxo rɨŋɨ́yɨ́ nɨyonɨ dɨŋɨ́ nɨkwɨ́rorɨ́náyɨ́ ayɨ́nɨ dɨŋɨ́ meapaxɨ́rɨnɨ.’ Rɨ́wamɨŋɨ́ e nɨrɨnɨrɨ eánɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Obo Jisasomɨ nɨmeámɨ Jerusaremɨ aŋɨ́ Gorɨxoyá ayá tɨ́ŋɨ́mɨnɨ nánɨ nurɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ rɨkwɨ́yo seáyɨ e nurárárɨmáná ");
INSERT INTO aak_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","re urɨŋɨnigɨnɨ, “Joxɨ ‘Niaíwɨ́ Gorɨxoyáonɨrɨnɨ.’ yaiwinarɨŋɨ́pɨ nepa eŋánáyɨ́, Gorɨxoyá Bɨkwɨ́yo dánɨ rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨŋagɨ nánɨ ‘Gorɨxo joxɨ sɨkwɨ́ sɨ́ŋáyo pɨ́rɨ́ uyɨkímɨ́ inɨrɨxɨnɨrɨ xegɨ́ aŋɨ́najowa awí nɨroro ɨ́á rɨxepɨ́rɨ nánɨ urowárɨnɨŋoɨ.’ nɨrɨnɨrɨ eánɨŋagɨ nánɨ ananɨ mɨ́mɨ nɨmawirɨ xeamoɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisaso re urɨŋɨnigɨnɨ, “Xwɨyɨ́á joxɨ mɨŋɨ́ nirorɨ rɨ́ɨ́pɨ eánɨŋagɨ aiwɨ xwɨyɨ́á rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Negɨ́ Gorɨxo nepa eŋɨ́ neánɨrɨ epaxorɨ́anɨrɨ iwamɨ́ó mɨwíwapɨyipanɨ.’ enɨ rɨnɨŋagɨ nánɨ nionɨ wí e emɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ámɨ Obo dɨ́wɨ́ mɨŋɨ́ seáyɨmɨ wiápɨ́nɨmeaŋɨ́ bimɨ nánɨ nɨmeámɨ nɨyirɨ aŋɨ́ nɨ́nɨ xwɨ́á rɨrí nɨrímɨnɨ ikwɨ́rónɨŋɨ́yo sɨwá nɨwirɨ xegɨ́ amɨpí ámá nɨwɨnɨróná ayá sɨ́wɨ́ nurorɨ nɨmeapaxɨ́ wimónarɨŋɨ́pɨ enɨ sɨwá nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","re urɨŋɨnigɨnɨ, “Joxɨ xwɨ́áyo nɨpɨ́kínɨmearɨ sɨmaŋwɨ́yónɨŋɨ́ nɨnurɨ́nɨrɨ nionɨ nánɨ yayɨ́ seáyɨmɨ nɨmeɨ. E níánáyɨ́, amɨpí sɨwá síá tiyɨ́ nɨpɨnɨ siapɨmɨ́ɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisaso re urɨŋɨnigɨnɨ, “Setenoxɨ pɨ́nɨ nɨnɨwiárɨmɨ éɨ́ uɨ. Xwɨyɨ́á rɨpɨ ‘Ámɨná Gorɨxo nánɨnɨ xwɨ́áyo nɨpɨ́kínɨmearo yayɨ́ seáyɨmɨ umero segɨ́ amɨpí “Ŋwɨ́áxɨnɨ.” rɨnɨŋɨ́yɨ́ emɨ nɨmoro sɨwɨ́ oyá nánɨnɨ dɨŋɨ́ ɨkwɨ́roro éɨ́rɨxɨnɨ.’ rɨnɨŋagɨ nánɨ joxɨ nɨrɨ́ɨ́pa wí emɨméɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Obo pɨ́nɨ nɨwiárɨmɨ úáná aŋɨ́najɨ́ wa nɨbɨro arɨrá wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisaso ámá wa Jono wayɨ́ numeaia warɨŋo nánɨ re rarɨŋagɨ́a “Omɨ rɨxa ɨ́á nɨxero gwɨ́ aŋɨ́yo ŋwɨrárɨ́árɨnɨ.” rarɨŋagɨ́a o arɨ́á e nɨwimo Gariri pɨropenɨsɨ́yo nánɨ nurɨ nɨŋwearɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","aŋɨ́ Nasaretɨ xɨ́o xwé iwiaroŋe pɨ́nɨ nɨwiárɨmɨ nurɨ aŋɨ́ xegɨ́ yoɨ́ Kapaneamɨyɨ rɨnɨŋɨ́yo —Aŋɨ́ apɨ ipí Gariri tɨ́nɨ ikwɨ́rónɨnɨ. Seburano tɨ́nɨ Napɨtaraio tɨ́nɨ awaúyá ɨ́wiárɨ́awé ŋweaagɨ́erɨnɨ. E nánɨ nurɨ ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ayɨ́ rɨpɨ nánɨrɨnɨ. Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo xwɨyɨ́á nɨwurɨyirɨ rɨ́wamɨŋɨ́ re eaárɨŋɨ́rɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Xwɨ́á Seburanoyá ɨ́wiárɨ́awé tɨ́nɨ Napɨtaraioyá ɨ́wiárɨ́awé tɨ́nɨ eŋíná ŋweaagɨ́e ipí tɨ́ŋɨ́mɨnɨ tɨ́nɨ iniɨgɨ́ Jodanɨ rapáyo jɨ́arɨwámɨ dánɨ tɨ́nɨ xwɨ́á Gariri imónɨŋɨ́mɨnɨ émáyɨ́ ŋweagɨ́e, ");
INSERT INTO aak_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ámá oxɨ́ apɨxɨ́ e ŋweagɨ́áyɨ́ nɨ́nɨ Gorɨxomɨ muxɨ́darɨŋagɨ́a nánɨ sɨ́á yinɨŋɨ́mɨ́nɨŋɨ́ ŋweagɨ́e rɨxa wɨ́á xwé bɨ ónɨ́agɨ wɨnɨgɨ́awixɨnɨ. Ayɨ́ apaxɨ́ mé pearɨŋagɨ́a nánɨ íkwapiŋɨ́nɨŋɨ́ umeaarɨŋɨ́yo rɨxa wɨ́á wókímɨxɨnɨ.” Rɨ́wamɨŋɨ́ e nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ Jisaso wɨ́ánɨŋɨ́ imónɨŋo e nánɨ nurɨ ŋweaagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","O aŋɨ́ e nánɨ nurɨ ŋweaé dánɨ wáɨ́ re urɨmeŋɨnigɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ píránɨŋɨ́ seamenɨ aŋwɨ ayo eŋagɨ nánɨ segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro sanɨŋɨ́ nimónɨro ŋweáɨ́rɨxɨnɨ.” nurɨmerɨ ");
INSERT INTO aak_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ipí Gariri imaŋɨ́pá tɨ́nɨ nɨpurɨ́ná sɨŋwɨ́ wɨnɨŋɨnigɨnɨ. Xɨráxogwá waú —Xɨráo xegɨ́ yoɨ́ Saimonorɨnɨ. O xegɨ́ yoɨ́ ámɨ bɨ Pitaorɨnɨ. Xogwáo Adɨruorɨnɨ. Agwiaú egɨ́ omɨŋɨ́ peyɨ́ ápearɨgɨ́íwaú eŋagɨ nánɨ ubenɨ́ peyɨ́ nánɨ ipíyo mamówárarɨŋagɨ́i Jisaso e nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","re urɨŋɨnigɨnɨ, “Agwiagwí nɨxɨ́dɨ́piyɨ. Peyɨ́ nánɨ yarɨgɨ́ípa ámá nionɨ nɨxɨ́dɨpɨ́rɨ́áyɨ́ enɨ axɨ́pɨ e wirɨmeapɨsi nánɨ eaíwapɨyimɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","agwiaú ubenɨ́ apaxɨ́ mé e nɨtɨmɨ rɨ́wɨ́yo uxɨ́dɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O e dánɨ nurɨ́ná sɨŋwɨ́ wɨnɨŋɨnigɨnɨ. Ámɨ xɨráxogwá waú —Agwiaú Sebediomɨ xewaxowaúrɨnɨ. Wɨ́o Jemisorɨnɨ. Wɨ́o xogwáo Jonorɨnɨ. Agwiaú xano tɨ́nɨ ewéyo nɨŋweámáná wigɨ́ ubenɨ́ arɨ́kínɨŋagɨ píránɨŋɨ́ yadɨrɨpɨ́narɨŋagɨ́a Jisaso e nɨwɨnɨrɨ rɨ́aiwá “Nɨxɨ́dɨ́piyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","agwiaú enɨ aŋɨ́nɨ egɨ́ ewé tɨ́nɨ xanomɨ tɨ́nɨ pɨ́nɨ nɨwiárɨmɨ nayoari númɨ uxɨ́dɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisaso Gariri pɨropenɨsɨ́yo amɨ amɨ nemerɨ́ná xegɨ́ Judayɨ́yá rotú aŋɨ́yo dánɨ uréwapɨyemerɨ xwɨyɨ́á yayɨ́ winɨpaxɨ́pɨ —Apɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́ápɨ nánɨ rɨnɨŋɨ́pɨrɨnɨ. Apɨ wáɨ́ urɨmerɨ ámá pí pí sɨmɨxɨ́ yarɨgɨ́áyo tɨ́nɨ uranɨ́ xɨxegɨ́nɨ imónɨgɨ́áyo tɨ́nɨ naŋɨ́ imɨxɨmerɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","o yarɨŋɨ́pɨ nánɨ yanɨ́ niwéa nurɨ Siria pɨropenɨsɨ́yo ŋweagɨ́áyɨ́ nɨ́nɨ arɨ́á nɨwiárɨro nánɨ wigɨ́ ámá sɨmɨxɨ́ xɨxegɨ́nɨ yarɨgɨ́áyɨ́ tɨ́nɨ rɨ́nɨŋɨ́ xɨxegɨ́nɨ winarɨgɨ́áyɨ́ tɨ́nɨ ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yɨ́ tɨ́nɨ xóxwɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ eŋɨ́ sɨwímɨ́ yárɨgɨ́áyɨ́ tɨ́nɨ o tɨ́ŋɨ́ e nánɨ nɨmeámɨ báná o píránɨŋɨ́ wimɨxɨyarɨŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ámá oxɨ́ apɨxɨ́ obaxɨ́ Gariri pɨropenɨsɨ́yo dáŋɨ́yɨ́ tɨ́nɨ Dekaporisɨ pɨropenɨsɨ́yo dáŋɨ́yɨ́ tɨ́nɨ Judia pɨropenɨsɨ́yo dáŋɨ́yɨ́ tɨ́nɨ wigɨ́ aŋɨ́ xwé Jerusaremɨ dáŋɨ́yɨ́ tɨ́nɨ iniɨgɨ́ Jodanɨ rapáyo jɨ́arɨwámɨnɨ dáŋɨ́yɨ́ tɨ́nɨ epɨ́royɨ́ nero omɨ númɨ uxɨ́dɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisaso ámá oxɨ́ apɨxɨ́ niaíwɨ́ obaxɨ́ o tɨ́ŋɨ́ e nánɨ bɨmiarɨŋagɨ́a nɨwɨnɨrɨ dɨ́wɨ́ mɨŋɨ́yo nánɨ nɨyoarɨ éɨ́ nɨŋwearɨ xegɨ́ wiepɨsarɨŋɨ́yɨ́ xɨ́o tɨ́ŋɨ́ e nánɨ báná ");
INSERT INTO aak_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","o nuréwapɨya nurɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ámá gɨyɨ́ gɨyɨ́né ‘Nionɨ nɨgɨ́pɨ apánɨrɨnɨ.’ mɨrɨpa éɨ́áyɨ́né, ‘Ámá arɨrá oneaípoyɨ.’ yaiwiarɨgɨ́áyɨ́né, Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ píránɨŋɨ́ seameŋweanɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ámá gɨyɨ́ gɨyɨ́né, ŋwɨ́ eanɨrɨ yarɨgɨ́áyɨ́né, Gorɨxo mɨŋɨ́ ikɨŋwɨ́ seamɨrɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ámá gɨyɨ́ gɨyɨ́né, ɨ́wɨ́ mé nɨrɨmaxɨnɨro sanɨŋɨ́ imónɨgɨ́áyɨ́né, Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e dánɨ xwɨ́á nɨrínɨ segɨ́ imónɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ámá gɨyɨ́ gɨyɨ́né, aiwá nánɨ agwɨ́ seairɨ iniɨgɨ́ nánɨ seainɨrɨ yarɨŋɨ́pa rɨ́á mɨkɨró píránɨŋɨ́ yarɨgɨ́á ayɨ́ nánɨ́nɨŋɨ́ nɨseaimónɨrɨ́ná Gorɨxo ananɨ xɨxenɨ seaiinɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ámá gɨyɨ́ gɨyɨ́né, ámá wíyo wá wianarɨgɨ́áyɨ́né, Gorɨxo enɨ wá seawianɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ámá gɨyɨ́ gɨyɨ́né, ámá sɨŋwɨ́ anɨgɨ́e dánɨranɨ, segɨ́pɨ úɨ́ámɨ dánɨranɨ, dɨŋɨ́ ná bɨnɨ nɨmoro axɨ́pɨnɨ yarɨgɨ́áyɨ́né, Gorɨxo xewanɨŋo sɨwá seainɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ámá gɨyɨ́ gɨyɨ́né, ámá mɨxɨ́ inarɨ́ná nuro pɨyɨ́á wɨ́rarɨgɨ́áyɨ́né, Gorɨxo ayɨ́ nánɨ ‘Gɨ́ niaíwɨ́xɨnɨ.’ rɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ámá gɨyɨ́ gɨyɨ́né, wé rónɨŋɨ́ Gorɨxo e éɨ́rɨxɨnɨrɨ wimónarɨŋɨ́pɨ xɨ́darɨŋagɨ́a nánɨ xeanɨŋɨ́ seaikárɨ́áyɨ́né, o xwioxɨ́yo mɨmeámɨ́ nɨseairɨ píránɨŋɨ́ seameŋweanɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ámá gɨyɨ́ gɨyɨ́né, nionɨ nɨxɨ́darɨŋagɨ́a nánɨ ikayɨ́wɨ́ searɨro xeanɨŋɨ́ seaikárɨro pí pí xwɨyɨ́á yapɨ́ seaxekwɨ́moro seaiarɨ́náyɨ́, yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Eŋíná wɨ́á rókiamoagɨ́áwamɨ xeanɨŋɨ́ nɨwikára wagɨ́ápa axɨ́pɨ seyɨ́né enɨ nɨseaikára warɨ́náyɨ́, seyɨ́né aŋɨ́namɨ nɨpeyirɨ́ná Gorɨxo yayɨ́ nɨseaimorɨ amɨpí ayá rɨmɨxarɨŋɨ́pɨ seaiapɨnɨ́á eŋagɨ nánɨ yayɨ́ seainɨpaxɨ́yɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Saxɨ́ aiwáyo nɨmorɨ nɨnɨrɨ́náyɨ́ awɨ́í yarɨŋɨ́pa seyɨ́né nionɨ seararɨŋáyo píránɨŋɨ́ nɨnɨxɨ́dɨróná ámá nɨyonɨ enɨ nɨwíwapɨyiro saxɨ́ awɨ́í yarɨŋɨ́pa axɨpɨ́nɨŋɨ́ wimɨxɨ́ɨ́rɨxɨnɨ. Saxɨ́ awɨ́í yarɨŋɨ́pɨ nɨpurɨ rɨxa uráwɨ́nɨŋɨ́ imónɨŋánáyɨ́ arɨre éáná ámɨ awɨ́í imónɨnɨŋoɨ? Oweoɨ, amɨpí wí imɨxɨpaxɨ́ mimónɨŋagɨ nánɨ óɨ́ e emɨ mɨwiárómóáná ámá xwɨrɨŋwɨ́ osɨxayarɨgɨ́árɨnɨ. Seyɨ́né nionɨ seararɨŋáyo nɨnɨwiaíkirɨ́náyɨ́, saxɨ́ rɨxa uráwɨ́nɨŋɨ́ imónɨŋɨ́pɨ emɨ moarɨgɨ́ápa Gorɨxo enɨ axɨ́pɨ emɨ e seamonɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Seyɨ́né ámá Gorɨxomɨ xɨ́dɨpɨ́rɨ́a nánɨ uyɨ́wɨ́ nɨmɨxároro wɨ́ánɨŋɨ́ uyamopɨ́rɨ́árɨnɨ. Aŋɨ́ dɨ́wɨ́ mɨŋɨ́yo ikwɨ́rónɨŋɨ́pɨ́nɨŋɨ́ ínɨmɨ mimónɨ́ eŋɨ́pɨ yapɨ seyɨ́né enɨ nionɨ píránɨŋɨ́ nɨnɨxɨ́dɨrónáyɨ́, ámá nɨyonɨ sɨŋánɨ e wimónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ámá ramɨxɨ́ nɨmɨxároro sɨxɨ́ wá nɨmearo sɨxɨ́ ikwaseaárarɨgɨ́ámanɨ. Nɨmɨxároro seáyɨ e íkwiaŋwɨ́yo ŋwɨrárárarɨgɨ́árɨnɨ. Seáyɨ e tánáyɨ́ ámá aŋɨ́yo ínɨmɨ ŋweagɨ́á nɨyonɨ wɨ́á wókiarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ramɨxɨ́ seáyɨ e ikwiáráráná ámá nɨyonɨ wɨ́á wókiarɨŋɨ́pánɨŋɨ́ seyɨ́né enɨ ámá sɨŋwɨ́yo dánɨ wé rónɨŋɨ́ imónɨro ámáyo arɨrá wiro nerónáyɨ́ ámá sɨŋwɨ́ nɨseanɨro ‘Ayɨ́ Gorɨxomɨ nɨxɨ́dɨro nánɨ rɨ́a yarɨŋoɨ?’ nɨyaiwiro omɨ seáyɨ e umepɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Seyɨ́né nionɨ nánɨ ‘O Gorɨxoyá ŋwɨ́ ikaxɨ́ Moseso nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́ápɨ tɨ́nɨ enɨ xwɨ́á iwenɨ nánɨ bɨŋɨ́rɨnɨ.’ mɨniaiwipanɨ. Xwɨ́á iwenɨ nánɨ mɨbɨ́ amɨpí nɨrɨnɨrɨ eánɨŋɨ́pɨ sɨnɨ xɨxenɨ imónɨnɨ́a nánɨ bɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aga nepa seararɨŋɨnɨ. Xwɨ́árí tɨ́nɨ aŋɨ́na tɨ́nɨ sɨnɨ eŋánáyɨ́ ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́ nɨpɨnɨ sɨnɨ xɨxenɨ mimónɨpa eŋánáyɨ́ ná bɨnɨ onɨmiápɨ rɨnɨŋɨ́ apɨ aiwɨ xwɨ́á iwenɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ámá gɨyɨ́ gɨyɨ́né ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ bɨ nánɨ ‘Xwémanɨ. Xwɨyɨ́á nɨmearɨpaxɨ́manɨ.’ nɨyaiwiro ogámɨ́ nero ámá wí enɨ axɨ́pɨ ogámɨ́ epɨ́rɨ nánɨ nɨwíwapɨyirɨ́náyɨ́, Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́íná e yarɨgɨ́áyɨ́ nánɨ ‘Sɨyikwɨ́piánɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ.’ rɨpɨ́rɨ́árɨnɨ. Gɨyɨ́ gɨyɨ́né ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ axɨ́pɨ nero ámá wí enɨ axɨ́pɨ epɨ́rɨ nánɨ nɨwíwapɨyirɨ́náyɨ́, Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́íná e yarɨgɨ́áyɨ́ nánɨ ‘Ámá xwé mamadɨ́rɨxánɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ.’ rɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","‘Seyɨ́né Parisiowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ “None ŋwɨ́ ikaxɨ́ eánɨŋɨ́pimɨ nɨxɨ́dɨrane e nerɨ́náyɨ́ wé rónɨŋɨ́ yarɨŋwɨnɨ.” yaiwinarɨgɨ́ápɨ mɨmúropa nerɨ́náyɨ́, Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́e wí ŋweapɨ́rɨ́ámanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Eŋíná Moseso segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná ‘Nɨwiápɨ́nɨmearɨ ámá mɨpɨkipanɨ. Ámá gɨyɨ́ e nerɨ́náyɨ́ xwɨrɨxɨ́ seamepɨ́rɨ́árɨnɨ.’ urɨŋɨ́pɨ seyɨ́né rɨxa arɨ́á nɨwiro nɨjɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ayɨ́ naŋɨ́ nerɨ aiwɨ agwɨ nionɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Ámá gɨyɨ́ xegɨ́ ámá imónɨgɨ́á wo nánɨ wikɨ́ nɨwónɨrɨ mɨxɨ́ nurɨrɨ́náyɨ́ aŋɨ́ e dánɨ xwɨrɨxɨ́ mepɨ́rɨ́árɨnɨ. Gɨyɨ́ xegɨ́ ámá imónɨgɨ́á womɨ “Dɨŋɨ́ mayɨ́ roxɨnɨ.” nurɨrɨ́náyɨ́ opisɨ́ aŋɨ́yo dánɨ xwɨrɨxɨ́ mepɨ́rɨ́árɨnɨ. Gɨyɨ́ xegɨ́ ámá imónɨgɨ́á womɨ “Majɨmajɨ́á ikárɨnarɨŋɨ́ roxɨnɨ.” nurɨrɨ́náyɨ́ xewanɨŋo xwɨyɨ́á nɨmeárɨnɨrɨ rɨ́á anɨŋɨ́ wearɨŋɨ́yo ikeaárɨpɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ayɨnánɨ Gorɨxo nánɨ aiwá peaxɨ́ tɨmɨnɨrɨ nerɨ́ná dɨŋɨ́ re sináná ‘Gɨ́ ámá imónɨgɨ́áyɨ́ wo sɨnɨ xwɨyɨ́á nɨmearɨpaxɨ́ imónɨnɨ.’ dɨŋɨ́ e sinánáyɨ́ ");
INSERT INTO aak_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","aiwá peaxɨ́ tarɨgɨ́e mɨdánɨŋɨ́ e nɨtɨmɨ nurɨ omɨ xámɨ pɨyɨ́á nɨwɨ́rɨnɨmáná ámɨ rɨ́wɨ́yo dánɨ nɨbɨrɨ dɨxɨ́ aiwá peaxɨ́ tɨrɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Seyɨ́né woxɨ ámá wo tɨ́nɨ xwɨyɨ́á mearɨnɨpaxɨ́ imónɨŋánáyɨ́ xwɨrɨxɨ́yo rɨwárɨnɨnɨ nánɨ sɨnɨ óɨ́ e o tɨ́nɨ nuríná aŋɨ́nɨ pɨyɨ́á wɨ́rɨnɨrɨ́ɨnɨ. E mepa nerɨ́náyɨ́, o xwɨrɨxɨ́yo rɨwáráná gapɨmanɨ́ xwɨrɨxɨ́ mearɨŋo e dánɨ porisowa tɨ́ŋɨ́ e rɨwáráná awa gwɨ́ aŋɨ́yo rɨwárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aga nepa re seararɨŋɨnɨ, ‘Joxɨ ɨ́wɨ́ eŋɨ́yɨ́ nánɨ nɨgwɨ́ ɨ́wɨ́ eŋɨ́pɨ tɨ́nɨ xɨxenɨ nɨroarɨ mɨwipa nerɨ́náyɨ́, anɨŋɨ́ e ŋweaŋáná wí pɨ́nɨ nɨrɨwiárɨro rɨwáramopaxɨ́ mimónɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Eŋíná Moseso segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná rɨ́wamɨŋɨ́ nearɨ ‘Meánɨgɨ́ípagwí ámá wí tɨ́nɨ ɨ́wɨ́ minɨpanɨ.’ nurɨrɨ eaŋɨ́pɨ seyɨ́né arɨ́á nɨwiro nɨjɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ayɨ́ naŋɨ́ nerɨ aiwɨ agwɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Ámá nɨ́nɨ gɨyɨ́ gɨyɨ́ apɨxɨ́ wímɨ “Nionɨ í tɨ́nɨ ɨ́wɨ́ inɨpaxonɨrɨnɨ.” yaiwimɨnɨrɨ nánɨ sɨŋwɨ́ ɨ́wɨ́ nɨwɨnɨrɨ́náyɨ́, o rɨxa dɨŋɨ́ tɨ́nɨ ɨ́wɨ́ inarɨŋiɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","O ámá ayɨ́ dɨŋɨ́ oeyírónɨ́poyɨnɨrɨ re urɨŋɨnigɨnɨ, “Segɨ́ sɨŋwɨ́ wɨyɨ́ji ‘Ɨ́wɨ́ apɨ eɨ.’ rɨránáyɨ́ sɨŋwɨ́ e rɨrɨ́ɨ́yi nɨyorɨ emɨ morɨ́ɨnɨ. E ninɨrónáyɨ́ rɨ́nɨŋɨ́ xwé nɨseainɨrɨŋɨ́ aiwɨ Gorɨxo rɨ́á anɨŋɨ́ wearɨŋɨ́yo seaikeaáráná rɨ́nɨŋɨ́ seainɨmɨnɨrɨ eŋɨ́pɨ́nɨŋɨ́ seainɨnɨ́ámanɨ. Sɨŋwɨ́ wɨyinɨ anɨpá nimónɨrɨ́náyɨ́ ayɨ́ naŋɨ́ meŋagɨ aiwɨ joxɨ sɨnɨ sɨŋɨ́ urɨ́á eŋagɨ nánɨ ayɨ́ ananɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dɨxɨ́ wé onamɨŋú tɨ́nɨ ɨ́wɨ́ nánɨ ɨ́eapá sinánáyɨ́ ‘Gorɨxo gɨ́ wará nɨrínɨ rɨ́á anɨŋɨ́ wearɨŋɨ́yo nikeaárɨnɨgɨnɨ.’ nɨyaiwirɨ wéú nɨwákwínɨrɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́náyɨ́ rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ rɨ́nɨŋɨ́ Gorɨxo rɨ́á anɨŋɨ́ wearɨŋɨ́yo sikeaáráná sinɨmɨnɨrɨ eŋɨ́pɨ́nɨŋɨ́ sinɨnɨ́ámanɨ. Wé wúnɨ nɨwákwínɨrɨ́náyɨ́ ayɨ́ naŋɨ́ meŋagɨ aiwɨ joxɨ sɨnɨ sɨŋɨ́ urɨ́á eŋagɨ nánɨ ayɨ́ ananɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Eŋíná Moseso ŋwɨ́ ikaxɨ́ nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨnigɨnɨ, ‘Ámá go go xegɨ́ xiepímɨ “Emɨ omómɨnɨ.” nɨyaiwirɨ́náyɨ́ ámá nɨ́nɨ “O apɨxímɨ rɨxa emɨ moŋoɨ.” yaiwipɨ́rɨ nánɨ payɨ́ wɨna nimɨxɨrɨ mɨnɨ wiowárɨ́wɨnɨgɨnɨ.’ Moseso rɨ́wamɨŋɨ́ naŋɨ́ e nɨrɨrɨ eaŋɨ́ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","agwɨ nionɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Go go xegɨ́ xiepí xámɨ meaŋí ámá wo tɨ́nɨ ɨ́wɨ́ bɨ minarɨ́ná emɨ nɨmorɨ́náyɨ́ í ámá womɨ nɨmeánɨrɨ aí xámɨ nɨmearɨ emɨ moŋoyá dɨŋɨ́yo dánɨ ɨ́wɨ́ inarɨŋiɨ. Go go apɨxɨ́ wa nɨmearo emɨ mogɨ́ímɨ nɨmearɨ́náyɨ́ ayɨ́ enɨ í tɨ́nɨ ɨ́wɨ́ inarɨŋiɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Eŋíná Moseso segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná rɨ́wamɨŋɨ́ rɨpɨ nearɨ re urɨŋɨnigɨnɨ, ‘Seyɨ́né woxɨ woxɨ sɨ́ŋáyo árɨxá nɨwirɨ “Sɨ́ŋá ro ŋweaŋe dánɨ rɨrarɨŋɨnɨ.” nurɨrɨ́ná yapɨ́ bɨ murɨpanɨ. E nurɨrɨ́ná Gorɨxoyá sɨŋwɨ́yo dánɨ axɨ́pɨ éɨrɨxɨnɨ.’ Rɨ́wamɨŋɨ́ e nurɨrɨ eaŋɨ́pɨ seyɨ́né arɨ́á nɨwiro nɨjɨ́á nimónɨrɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","agwɨ nionɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Xwɨyɨ́á bɨ nɨrɨrɨ́ná sɨ́ŋá tɨ́ŋɨ́ e dánɨ mɨrɨpa éɨ́rɨxɨnɨ. Aŋɨ́na ayɨ́ Gorɨxoyá íkwiaŋwɨ́ éɨ́ ŋweanɨ nánɨ imónɨŋagɨ nánɨ e dánɨ xwɨyɨ́á “E rɨrarɨŋɨnɨ.” mɨrɨpa éɨ́rɨxɨnɨ. Xwɨ́árí enɨ ayɨ́ Gorɨxoyá sɨkwɨ́ tɨ́nɨ xwɨrɨŋwɨ́ nosaxɨrɨ ŋweaŋɨ́rí eŋagɨ nánɨ xwɨ́á rɨrí eŋe dánɨ xwɨyɨ́á “E rɨrarɨŋɨnɨ.” mɨrɨpa éɨ́rɨxɨnɨ. Jerusaremɨ ayɨ́ aŋɨ́ mɨxɨ́ ináyɨ́ Gorɨxoyá eŋagɨ nánɨ aŋɨ́ apimɨ dánɨ enɨ murɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dɨxɨ́ dɨŋɨ́yo dánɨ dɨ́á wɨyi pɨ́pɨ́ó oŋɨ́ werɨ apɨ́á weŋɨ́ werɨ epaxɨ́ mimónɨŋagɨ nánɨ “Gɨ́ mɨŋɨ́ rɨyimɨ dánɨ rɨrarɨŋɨnɨ.” wí murɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pɨ́né nurɨrɨ́ná sa “Oyɨ.” urɨrɨ “Oweoɨ.” urɨrɨ xɨxenɨ éɨ́rɨxɨnɨ. Wínɨ nɨra nurɨ “Sɨ́ŋá tɨ́ tɨ́ŋɨ́ e dánɨ rɨrarɨŋɨnɨ.” nurɨrɨ́náyɨ́, rɨxa Oboyá dɨŋɨ́yo dánɨ yarɨŋoɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Eŋíná Moseso segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná rɨ́wamɨŋɨ́ nearɨ re urɨŋɨ́pɨ, ‘Ámá wa seyɨ́néyá womɨ sɨŋwɨ́ pɨ́rɨ́ seauyɨkíáná seyɨ́né enɨ wayá womɨ sɨŋwɨ́ pɨ́rɨ́ uyɨkirɨ́ɨnɨ. Wa seyɨ́néyá womɨ maŋɨ́ pɨ́rɨ́ seayíreááná seyɨ́né enɨ wayá womɨ pɨ́rɨ́ uyírearɨ́ɨnɨ.’ nurɨrɨ eaŋɨ́pɨ seyɨ́né arɨ́á nɨwiro nɨjɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ayɨ́ naŋɨ́ nerɨ aiwɨ agwɨ nionɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Mɨxɨ́ seyɨ́né seaíáná seyɨ́né xɨxe mɨwipanɨ. Ámá wo marɨpɨŋwɨ́yo iwaŋɨ́ reááná xɨ́omɨ enɨ meá ámɨ bɨ tɨ́nɨ reámɨnɨrɨ yarɨ́ná xe oneanɨrɨ marɨpɨŋwɨ́ mɨdánɨ wimɨxɨrɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ámá wo xwɨrɨxɨ́ nɨrɨmerɨ dɨxɨ́ sorɨ́á rɨrápɨmɨnɨrɨ yarɨ́ná xɨ́o xe onɨrápɨnɨrɨ sɨŋwɨ́ nɨwɨnɨrɨ iyɨ́á nɨpánɨ méú enɨ mɨnɨ wirɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Porisɨ́ woranɨ, gapɨmanɨ́ woranɨ, “Nɨgwɨ́ nánɨ marɨ́á, joxɨ saŋɨ́ nɨnɨrápɨrɨ nɨgɨ́ saŋɨ́ rɨpɨ nɨmeámɨ aŋɨ́ apimɨ nánɨ nuiɨ.” rɨráná “Nɨgwɨ́ meámɨ imorɨ nɨmeámɨ umɨnɨréɨnɨ?” mɨyaiwipanɨ. Aŋɨ́ xɨ́o rɨrɨ́ɨ́pimɨ nɨrémorɨ aiwɨ “Ámɨ aŋɨ́ bimɨ nánɨ ananɨ nɨmeámɨ oruimɨnɨ.” urɨrɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ámá wo amɨpí nánɨ xegɨ́ dɨŋɨ́ nɨyaiwirɨ rɨxɨŋɨ́ rɨrɨ́ɨ́pɨyɨ́ sa mɨnɨ wirɨ́ɨnɨ. Ámá wo “Amɨpí wí nionɨyá rɨ́wéná siapɨmɨ́a nánɨ joxɨyá niapeɨ.” rɨránáyɨ́ “Menɨnɨ.” murɨpanɨ. Sa mɨnɨ wirɨ́ɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Eŋíná Moseso segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná rɨ́wamɨŋɨ́ nearɨ re urɨŋɨ́pɨ, ‘Ámá dɨxɨ́yoyɨ́ dɨŋɨ́ sɨpí síwɨnɨgɨnɨ.’ nurɨrɨ eaŋɨ́pɨ seyɨ́né arɨ́á nɨwiro nɨjɨ́á imónɨŋoɨ. Xwɨyɨ́á rɨpɨ, segɨ́ ámɨnáowa rɨgɨ́ápɨ ‘Xepɨxepá rónɨgɨ́áyɨ́ tɨ́nɨ wikɨ́ tɨ́nɨ inɨrɨ́ɨnɨ.’ rɨgɨ́ápɨ enɨ seyɨ́né rɨxa nɨjɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ayɨ́ e nerɨ aiwɨ nionɨ ámɨ bɨ nɨpɨkwɨnɨ naŋɨ́ seáyɨ e nimɨxɨrɨ re seararɨŋɨnɨ, ‘Dɨxɨ́ xepɨxepá rónɨgɨ́áyɨ́ nánɨ dɨŋɨ́ sɨpí síwɨnɨgɨnɨ. Ámá xeanɨŋɨ́ seaikárarɨgɨ́áyo naŋɨ́ wí owímeanɨrɨ Gorɨxomɨ rɨxɨŋɨ́ urɨrɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Seyɨ́né e nerɨ́náyɨ́, nepa niaíwɨ́ segɨ́ ápo Gorɨxoyá niaíwɨ́yɨ́nénɨŋɨ́ imónɨŋoɨ.’ seararɨŋɨnɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Xewanɨŋoyá dɨŋɨ́ tɨ́nɨ ámá sɨpí ayo tɨ́nɨ naŋɨ́ ayo tɨ́nɨ sogwɨ́ wanarɨŋɨ́rɨnɨ. Iniá enɨ oyá dɨŋɨ́ tɨ́nɨ wé rónɨgɨ́á ayo tɨ́nɨ wé mɨrónɨgɨ́á ayo tɨ́nɨ eaarɨŋɨ́rɨnɨ. O ‘Ámá sɨpí ayo aiwɨ iniá wearɨ sogwɨ́ wanɨrɨ mepa oenɨ.’ yaiwiarɨŋɨ́manɨ. Seyɨ́né o xegɨ́ niaíwɨ́yɨ́né eŋagɨ nánɨ ámá segɨ́yo tɨ́nɨ xepɨxepá rónɨgɨ́áyo tɨ́nɨ aiwɨ Gorɨxo yarɨŋɨ́pa axɨ́pɨ wéyo merɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Seyɨ́né ámá dɨŋɨ́ sɨxɨ́ seayigɨ́áyonɨ dɨŋɨ́ sɨpí nɨwirónáyɨ́, ‘Nene e yarɨŋagwɨ nánɨ Gorɨxo yayɨ́ nɨneairɨ amɨpí ayá tɨ́ŋɨ́ bɨ neaiapɨnɨ́árɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ! Ámá takisɨ́ nánɨ nɨgwɨ́ nɨnearápɨrɨ́ná xɨxenɨ mɨnearápɨ́ bɨ ɨ́wɨ́ nearáparɨgɨ́áwa axɨ́pɨ dɨŋɨ́ sɨxɨ́ uyigɨ́áyonɨ dɨŋɨ́ sɨpí nɨwiro nánɨ ‘Gorɨxo amɨpí ayá tɨ́ŋɨ́ bɨ mɨnɨ winɨ́árɨnɨ.’ yaiwiarɨŋwáranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ámá dɨxɨ́yonɨ óɨ́ e sɨŋwɨ́ nɨwɨnɨrɨ yayɨ́ nɨwirɨ́náyɨ́, ‘Ámá wí yarɨgɨ́áyɨ́ tɨ́nɨ xɨxenɨ mimónɨ́ múroarɨŋwɨnɨ.’ rɨyaiwinarɨŋoɨ? Oweoɨ! Ámá Gorɨxomɨ mɨxɨ́dɨpa yarɨgɨ́áyɨ́ aí axɨ́pɨ seyɨ́né yarɨgɨ́ápa enɨ e yarɨŋagɨ́a nánɨ e mɨyaiwipanɨ. ");
INSERT INTO aak_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ayɨnánɨ segɨ́ séno, aŋɨ́namɨ ŋweaŋo wé rónɨŋɨ́ nimónɨrɨ ámá naŋɨ́ ayo tɨ́nɨ sɨpí ayo tɨ́nɨ aí dɨŋɨ́ sɨpí nɨwirɨ naŋɨ́ wiarɨŋɨ́pa seyɨ́né enɨ axɨ́pɨ e wirɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Seyɨ́né ‘Naŋɨ́ owiimɨnɨ.’ nɨyaiwirɨ́ná ámá sɨŋwɨ́ nɨseanɨro weyɨ́ seamepɨ́rɨ nánɨ wigɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ mɨwipanɨ. Seyɨ́né e nerónáyɨ́, séno, aŋɨ́namɨ ŋweaŋo rɨ́wéná ayá tɨ́ŋɨ́ wí seaiapɨnɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ayɨnánɨ ‘Uyípeayɨ́yo arɨrá nɨwirɨ rɨpɨ mɨnɨ owimɨnɨ.’ nɨyaiwirɨ́náyɨ́, ámá sɨpí erɨ naŋɨ́ erɨ yarɨgɨ́áyɨ́ ámá sɨŋwɨ́ nɨnanɨro weyɨ́ onɨmépoyɨnɨrɨ wigɨ́ ámá womɨ ‘Pékákɨ́ nɨra xámɨ nɨmeaɨ.’ nurɨrɨ óɨ́ eranɨ, rotú aŋɨ́yoranɨ, yarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. Nionɨ nepa seararɨŋɨnɨ. Ámá weyɨ́ numerɨ́náyɨ́ ayɨ́ wigɨ́ wimónarɨŋɨ́pɨ rɨxa meaarɨŋagɨ́a nánɨ rɨ́wéná Gorɨxo ayá tɨ́ŋɨ́ bɨ wimɨnɨrɨ eŋɨ́pɨ meapɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","‘Uyípeayɨ́yo arɨrá nɨwirɨ rɨpɨ mɨnɨ owimɨnɨ.’ nɨyaiwirɨ́náyɨ́, wé núkaúnɨ tɨ́nɨ mɨwipanɨ. Ná wúnɨ tɨ́nɨ ínɨmɨ ɨkwɨsóɨ́rɨxɨnɨ. Ínɨmɨ e nɨwirɨ́náyɨ́, ápo Gorɨxo sɨŋwɨ́ nɨseanɨrɨ rɨ́wéná yayɨ́ nɨseairɨ amɨpí ayá tɨ́ŋɨ́pɨ xɨ́o seaiapɨmɨnɨrɨ yarɨŋɨ́pɨ ananɨ nɨseaiapɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Seyɨ́né rɨpɨ enɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná ámá sɨpí rɨrɨ naŋɨ́ rɨrɨ yarɨgɨ́áyɨ́ ámá sɨŋwɨ́ nɨnanɨro weyɨ́ onɨmépoyɨnɨrɨ ge ge ámá obaxɨ́ tɨ́ŋɨ́ e rotú aŋɨ́yoranɨ, óɨ́ osɨsagwɨ́yoranɨ, éɨ́ nɨroro Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wiarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. Nionɨ nepa seararɨŋɨnɨ. E yarɨ́ná ámá sɨŋwɨ́ nɨwɨnɨro weyɨ́ numerɨ́náyɨ́ ayɨ́ wigɨ́ wimónarɨŋɨ́pɨ rɨxa meaarɨŋagɨ́a nánɨ rɨ́wéná Gorɨxo ayá tɨ́ŋɨ́ bɨ wimɨnɨrɨ eŋɨ́pɨ meapɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Seyɨ́né Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná re éɨ́rɨxɨnɨ. Dɨxɨ́ aŋɨ́yo ínɨmɨ nɨpáwirɨ ówaŋɨ́ nɨyárɨmáná dɨxɨ́ ápomɨ ínɨmɨ dánɨ rɨrɨmɨ́ wirɨ́ɨnɨ. Seyɨ́né ínɨmɨ dánɨ nerɨ́náyɨ́, Gorɨxo sɨŋwɨ́ nɨseanɨrɨ rɨ́wéná amɨpí ayá tɨ́ŋɨ́ xɨ́o seaiapɨnɨ́ápɨ ananɨ nɨseaiapɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná ámá Gorɨxo nánɨ majɨ́áyɨ́ omɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná ayá wí nɨra nuro ‘Nene e nerɨ́náyɨ́, Gorɨxo arɨ́á neainɨŋoɨ.’ nɨyaiwiro yarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Seyɨ́né amɨpí wí nánɨ dɨ́wɨ́ nikeamónɨro sɨnɨ segɨ́ séno Gorɨxomɨ yarɨŋɨ́ mɨwipa eŋáná o rɨxa xámɨ nɨjɨ́á imónɨŋagɨ nánɨ Gorɨxo nánɨ majɨ́áyɨ́ yarɨŋɨ́ ayá wí nɨwia nuróná yarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná re urɨ́ɨ́rɨxɨnɨ, ‘Negɨ́ ápoxɨnɨ, aŋɨ́namɨ ŋweaŋoxɨnɨ, “Ámá nɨ́nɨ joxɨnɨ ŋwɨ́áoxɨ eŋagɨ nánɨ wéyo orɨmépoyɨ.” neaimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“Joxɨ xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋwearɨ́a nánɨ oimónɨnɨ.” neaimónarɨnɨ. Aŋɨ́namɨ amɨpí joxɨ “E oépoyɨ.” simónarɨŋɨ́pɨ nánɨ yarɨgɨ́ápa nene “Xwɨ́á rɨrímɨ enɨ axɨ́pɨ e oyaneyɨ.” neaimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Agwɨ sɨ́á rɨyi aiwá nanɨ nánɨ neaiapeɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ámá nene ɨ́wɨ́ neaíɨ́áyo yokwarɨmɨ́ wiiarɨŋwápa joxɨ enɨ nene yokwarɨmɨ́ neaiiɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ámá wí eŋɨ́ eánɨgɨ́árɨ́anɨrɨ iwamɨ́ó owíwapɨyípoyɨnɨrɨ sɨŋwɨ́ mɨneanɨpanɨ. Obo mɨmɨwiaíkɨ́ neainɨgɨnɨrɨ awí neameŋweáɨrɨxɨnɨ. Xwioxɨ́yo mɨmeámɨ́ nɨneairɨ píránɨŋɨ́ neameŋweapaxoxɨ imónɨrɨ eŋɨ́ sɨxɨ́ eánɨpaxoxɨ imónɨrɨ ikɨ́nɨpaxoxɨ imónɨrɨ eŋoxɨ, íníná ayɨ́ joxɨnɨ eŋagɨ nánɨ rarɨŋɨnɨ. “E e imónɨ́wɨnɨgɨnɨ.” neaimónarɨnɨ. Gorɨxomɨ rɨxɨŋɨ́ nurɨrɨ́ná e urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Seyɨ́né ámá wí ɨ́wɨ́ seaíɨ́áyo yokwarɨmɨ́ wiíánáyɨ́, séno Gorɨxo, aŋɨ́namɨ ŋweaŋo seyɨ́néyá enɨ yokwarɨmɨ́ nɨseaiinɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","E nerɨ aí ɨ́wɨ́ seaíɨ́áyo yokwarɨmɨ́ mɨwipa éánáyɨ́, segɨ́ séno enɨ seyɨ́néyá yokwarɨmɨ́ seaiinɨmenɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Seyɨ́né aiwá ŋwɨ́á nɨŋwɨrárɨnɨrɨ́ná ámá sɨpí ero naŋɨ́ ero yarɨgɨ́áyɨ́ sɨ́mɨ́ nɨyɨmiro yarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. Ayɨ́ ámá sɨŋwɨ́ nɨranɨro sɨ́mɨmaŋɨ́ siyó xeŋáná ayɨ́ re yaiwipɨ́rɨ ‘O aiwá ŋwɨ́á ŋwɨrárɨnɨŋorɨ́anɨ?’ oyaiwípoyɨnɨrɨ emearɨgɨ́ápa mepa éɨ́rɨxɨnɨ. Nionɨ nepa re seararɨŋɨnɨ, ‘Ayɨ́ ámá weyɨ́ onɨmépoyɨnɨrɨ e nero wigɨ́ wimónarɨŋɨ́pɨ rɨxa ámá weyɨ́ uméagɨ́a nánɨ ayá tɨ́ŋɨ́ rɨ́wéná wimɨnɨrɨ eŋɨ́pɨ wí meapɨ́rɨ́ámanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Seyɨ́né aiwá ŋwɨ́á nɨŋwɨrárɨnɨrɨ́ná ámá ‘O aiwá ŋwɨ́á mɨŋweaŋorɨnɨ.’ yaiwipɨ́rɨ nánɨ dɨ́á komɨxɨ́ ninɨro sɨ́mɨmaŋɨ́yo wayɨ́ nɨrónɨro éɨ́rɨxɨnɨ. Seyɨ́né yumɨ́í e nerɨ́náyɨ́, segɨ́ séno Gorɨxo sɨŋwɨ́ nɨseanɨrɨ rɨ́wéná yayɨ́ nɨseairɨ ayá tɨ́ŋɨ́pɨ bɨ mɨnɨ nɨseaiapɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Xwɨ́á tɨ́yo amɨpí ayá rɨmɨxarɨŋɨ́pɨ wí ípɨkwɨyɨ́ xwɨrɨ́á ikɨxerɨ wí nɨgiyɨ́ kirɨ wí rɨweaxwɨ́ imónɨro nɨ́kwirɨ nɨpáwiro ɨ́wɨ́ mearo epaxɨ́ eŋagɨ nánɨ wínɨ wínɨ nánɨ dɨŋɨ́ nɨmoro nɨmeaayiro mɨtɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Seyɨ́né Gorɨxoyá sɨŋwɨ́yo dánɨ wé rónɨŋɨ́ nimónɨro yumɨ́í ámáyo arɨrá nɨwirɨ́náyɨ́ ayɨ́ seyɨ́né amɨpí ayá tɨ́ŋɨ́pɨ aŋɨ́namɨ awí eámeámɨ́nɨŋɨ́ yárarɨŋoɨ. E ípɨkwɨyɨ́ wí xwɨrɨ́á ikɨxerɨ nɨgiyɨ́ kirɨ rɨweaxwɨ́ imónɨro nɨ́kwiro nɨpáwiro ɨ́wɨ́ mearo epaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Segɨ́ amɨpí naŋɨ́ ayá rɨmɨxarɨgɨ́ápɨ xwɨ́á tɨ́yo weŋánáyɨ́ ayɨ́ xwɨ́á tɨ́yo nánɨ dɨŋɨ́ mopɨ́rɨ́árɨnɨ. Aŋɨ́namɨ weŋánáyɨ́ ayɨ́ e nánɨ dɨŋɨ́ mopɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Segɨ́ sɨŋwɨ́ ayɨ́ uyɨ́wɨ́nɨŋɨ́ imónɨnɨ. Sɨŋwɨ́ tɨ́nɨ píránɨŋɨ́ nanɨro wé rónɨŋɨ́ nerónáyɨ́ dɨŋɨ́ naŋɨ́nɨ aumaúmɨ́ ninɨro segɨ́ xwioxɨ́yo wɨ́ánɨŋɨ́ seaókiarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","E nerɨ aí segɨ́ sɨŋwɨ́yo dánɨ ɨ́wɨ́ nánɨ nanɨrónáyɨ́ segɨ́ dɨŋɨ́ xwioxɨ́yo sɨ́ánɨŋɨ́ yimɨxárɨnarɨŋoɨ. Dɨxɨ́ xwioxɨ́yo wɨ́ánɨŋɨ́ ónɨŋɨ́pɨ sɨ́á nɨyimɨxɨrɨ́náyɨ́ ayɨ́ aga sɨ́á xaíwɨ́nɨŋɨ́ yimɨxárɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ámá wo ámá waúyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiipaxɨ́ menɨnɨ. E nerɨ́náyɨ́ wɨ́omɨ dɨŋɨ́ sɨxɨ́ nuyirɨ wɨ́omɨ dɨŋɨ́ peá nɨmorɨ nerɨ wɨ́omɨ píránɨŋɨ́ ayá tɨ́nɨ nɨxɨ́dɨrɨ wɨ́omɨ peayɨ́ nɨwianɨrɨ enɨŋoɨ. Seyɨ́né nɨgwɨ́yɨ́yá omɨŋɨ́ wiiarɨŋɨ́nɨŋɨ́ nimónɨro ‘Nɨgwɨ́ wí mɨnɨmúropa oenɨ.’ nɨyaiwirɨ́náyɨ́, Gorɨxoyá omɨŋɨ́ wiiarɨŋɨ́ woxɨ́nɨŋɨ́ imónɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nionɨ re seararɨŋɨnɨ, ‘ “Arɨge píránɨŋɨ́ ŋweanɨréwɨnɨ?” mɨrɨpa nero aiwá tɨ́nɨ iniɨgɨ́ tɨ́nɨ nɨpɨ́rɨ nánɨ ududɨ́ mepa ero iyɨ́á aikɨ́ amɨpí waráyo yínɨpɨ́rɨ nánɨ ududɨ́ mepa ero éɨ́rɨxɨnɨ.’ seararɨŋɨnɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Segɨ́ dɨŋɨ́ jɨ́ayɨ́ aiwá nánɨ moarɨgɨ́áyo seáyɨ e imónɨrɨ wará jɨ́ayɨ́ enɨ aikɨ́ yínarɨgɨ́áyo seáyɨ e imónɨrɨ eŋagɨ nánɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Seyɨ́né iŋɨ́ nánɨ dɨŋɨ́ mópoyɨ. Iŋɨ́ aiwá ɨwɨ́á urɨrɨ aiwá mirɨ aŋɨ́yo awí eámeámɨ́ yárɨrɨ mepa yarɨgɨ́á aiwɨ segɨ́ séno Gorɨxo, aŋɨ́namɨ ŋweaŋo nɨmerɨ aiwá mɨnɨ wiarɨŋɨ́rɨnɨ. Seyɨ́né ‘Iŋowa neamúroŋoɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Seyɨ́né woxɨ, ‘Sepiá ámɨ bɨ oimónɨmɨnɨ.’ nɨyaiwirɨ ududɨ́ éoxɨ sepiá ámɨ bɨ imónarɨŋɨ́ranɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Seyɨ́né apɨ aí wí mepaxɨ́ imónɨŋagɨ́a nánɨ aikɨ́ nánɨ pí nánɨ ududɨ́ yarɨŋoɨ? Ará adowayɨ́ amɨ́yo eŋɨ́náɨna nánɨ dɨŋɨ́ mópoyɨ. Anɨŋɨ́ minɨ́ iyɨ́á óɨ́ earɨ aikɨ́ yirɨ yarɨŋɨ́ranɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","E nerɨ aí nionɨ re seararɨŋɨnɨ, ‘Eŋíná negɨ́ mɨxɨ́ ináyɨ́ Soromono nikɨ́nɨrɨ okiyɨ́á ninɨ́ɨsáná adowayɨ́ apɨ tɨ́nɨ xɨxenɨ mimónɨŋɨnigɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gorɨxo adowayɨ́ tɨ́nɨ aráyo —Ará agwɨ eŋɨ́yo ananɨ nɨyoaro sɨ́á wɨyimɨ rɨ́á ikeaárɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. Wiepɨsarɨŋɨ́yɨ́ “Gorɨxo ará nánɨ ayá sɨ́wɨ́ muroarɨnɨ.” oyaiwípoyɨnɨrɨ Jisaso e nurɨrɨ re urɨŋɨnigɨnɨ, “Oxɨ́ apɨxɨ́yɨ́né, Gorɨxomɨ dɨŋɨ́ onɨmiápɨ ɨkwɨ́roarɨgɨ́áyɨ́né Gorɨxo adowayɨ́ tɨ́nɨ aráyo okiyɨ́ánɨŋɨ́ yarɨŋagɨ nánɨ soyɨ́né enɨ aŋɨpaxɨ́ aikɨ́ e seayírɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aiwá tɨ́nɨ iniɨgɨ́ tɨ́nɨ pí nanɨréwɨnɨrɨ ududɨ́ mepanɨ. Aikɨ́ enɨ pí yínanɨréwɨnɨrɨ ududɨ́ mepanɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Émáyɨ́, ámá Gorɨxo nánɨ majɨ́áyɨ́ apɨ nɨpɨnɨ nánɨ anɨŋɨ́ minɨ́ nero meaanɨro yarɨgɨ́árɨnɨ. E nerɨ aí segɨ́ séno, aŋɨ́namɨ ŋweaŋo seyɨ́né apɨ nɨpɨnɨ nánɨ seainarɨ́ná o rɨxa nɨjɨ́á imónɨŋagɨ nánɨ seyɨ́né axɨ́pɨ e mepa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amɨpí apɨ meámɨnɨrɨ nánɨ mepa erɨ ‘Wé rónɨŋɨ́ Gorɨxo yarɨŋɨ́pɨ nionɨ oimónɨmɨnɨ.’ nɨyaiwirɨ erɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋweanɨ́e páwirɨ nánɨ amɨpí xɨ́o wimónarɨŋɨ́pɨ erɨ nerɨ́náyɨ́, Gorɨxo ananɨ apɨ nɨpɨnɨ nɨsiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ayɨnánɨ ‘Wɨ́áríná aikɨ́ pí yínɨrane aiwá pí nɨrane yanɨ́wárɨ́anɨ?’ nɨyaiwiro ududɨ́ mepanɨ. E nerɨ́ná ududɨ́ sɨ́á wɨyimɨ epɨ́rɨ́áyɨ́ tɨ́nɨ nawínɨ axínánɨ nɨkumɨxɨro ayá wí ududɨ́ yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gorɨxo seyɨ́né enɨ xwɨyɨ́á seamearɨnɨgɨnɨrɨ ámá wíyo xwɨyɨ́á mumearɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Seyɨ́né ámá wíyo xwɨyɨ́á umeararɨgɨ́ápa Gorɨxo enɨ xwɨyɨ́á seamearɨnɨ́árɨnɨ. Seyɨ́né rɨ́á tɨ́ŋɨ́ numearɨrɨ́náyɨ́, Gorɨxo enɨ rɨ́á tɨ́ŋɨ́ seamearɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Seyɨ́né ‘Ɨ́wɨ́ amɨpí e mepanɨ.’ urɨgɨ́ápimɨ dánɨ Gorɨxo apimɨ dánɨ xwɨrɨxɨ́ seamenɨ́árɨnɨ. Joxɨyá ɨ́wɨ́ yarɨŋɨ́pɨ sɨŋwɨ́yo írɨ́ónɨŋɨ́ weŋagɨ aiwɨ mɨsékínarɨŋagɨ́nɨŋɨ́ dɨxɨ́ ámá imónɨŋɨ́ wo ɨ́wɨ́ onɨmiápɨ yarɨŋɨ́pɨ sɨyikwɨ́nɨŋɨ́ ŋweaŋagɨ pí nánɨ wɨnarɨŋɨ́rɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Íkɨ́á írɨ́ó dɨxɨ́ sɨŋwɨ́yo weŋáná dɨxɨ́ ámá imónɨŋɨ́ woyá sɨŋwɨ́yo sɨyikwɨ́ ŋweaŋagɨ nɨwɨnɨro arɨre ‘Orɨmeámɨnɨ.’ urarɨŋɨ́rɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Joxɨ naŋɨ́ erɨ sɨpí erɨ yarɨŋoxɨnɨ, joxɨyá enɨ írɨ́ó urɨ́ weŋɨ́pɨ xámɨ emɨ nɨmamónɨmáná sɨŋwɨ́ píránɨŋɨ́ nɨwɨnɨrɨ oyá sɨŋwɨ́yo weŋɨ́pɨ enɨ ananɨ emɨ umamorɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Segɨ́ memiá odɨpí xwɨrɨŋwɨ́ osaxɨpɨ́rɨxɨnɨrɨ odɨpí yarɨŋe xwɨ́á e mɨtarɨgɨ́ápa xwɨyɨ́á naŋɨ́ Gorɨxoyá enɨ ámá ‘Ayɨ́ pí pɨ́nérɨ́anɨ?’ yaiwiarɨgɨ́áyɨ́ arɨ́á nɨwirɨ aí rɨ́wɨ́mɨnɨ mamopɨ́rɨxɨnɨrɨ murɨpa éɨ́rɨxɨnɨ. Sɨ́wí sɨ́wɨ́ nearopɨ́rɨxɨnɨrɨ amɨpí naŋɨ́ mɨnɨ mɨwiarɨgɨ́ápa xwɨyɨ́á Gorɨxoyá ámá arɨ́á mɨwíɨ́áyɨ́ xeanɨŋɨ́ seaiapɨ́rɨxɨnɨrɨ murɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Seyɨ́né Gorɨxomɨ yarɨŋɨ́ nɨwiro segɨ́ seaimónarɨŋɨ́pɨ nánɨ rɨxɨŋɨ́ uráná o ananɨ mɨnɨ seaiapɨnɨ́árɨnɨ. Rɨxɨŋɨ́ nurɨrɨ amɨpí wí o tɨ́ŋɨ́ e dánɨ pɨ́ánɨŋɨ́ nerɨ́ná ananɨ meapɨ́rɨ́árɨnɨ. Rɨxɨŋɨ́ nurɨrɨ wáɨ́ e nɨrómáná wakwɨ́ óránánɨŋɨ́ éáná Gorɨxo ananɨ arɨ́á nɨsirɨ aŋɨ́ ówaŋɨ́nɨŋɨ́ seaɨ́kwiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá nɨ́nɨ gɨyɨ́ gɨyɨ́ yarɨŋɨ́ nɨwirɨ wigɨ́ wimónarɨŋɨ́pɨ nánɨ Gorɨxomɨ rɨxɨŋɨ́ nurɨrɨ́náyɨ́ ananɨ meaarɨgɨ́árɨnɨ. Yarɨŋɨ́ nɨwirɨ Gorɨxo tɨ́ŋɨ́ e dánɨ pɨ́ánɨŋɨ́ nerɨ́náyɨ́ ananɨ meaarɨgɨ́árɨnɨ. Yarɨŋɨ́ nɨwirɨ Gorɨxoyá wáɨ́ e éɨ́ nɨrómáná wakwɨ́ óránánɨŋɨ́ éáná o ananɨ aŋɨ́ ówaŋɨ́nɨŋɨ́ wɨ́kwiiarɨŋɨ́rɨnɨ. Ayɨnánɨ ananɨ Gorɨxomɨ yarɨŋɨ́ wiayíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Seyɨ́né re éɨ́ ŋwɨxapɨgɨ́áyɨ́né woxɨ dɨxɨ́ íwo aiwá nánɨ rɨxɨŋɨ́ rɨráná xeŋwɨ́ sɨ́ŋá reŋɨ́yɨ́ nɨmearɨ umeaiarɨŋɨ́ranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Dɨxɨ́ íwo peyɨ́ nánɨ rɨxɨŋɨ́ rɨráná sidɨrɨ́ reŋɨ́ nɨmearɨ umeaiarɨŋɨ́ranɨ? Ayɨ́ enɨ ananɨmanɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Seyɨ́né ɨ́wɨ́ néra warɨgɨ́áyɨ́né aiwɨ segɨ́ niaíwɨ́ rɨxɨŋɨ́ searáná amɨpí awiaxɨ́yɨ́ mɨnɨ wiarɨgɨ́árɨnɨ. E nerɨ aí segɨ́ séno, aŋɨ́namɨ ŋweaŋoyɨ́ aŋɨpaxɨ́rɨnɨ. Gɨyɨ́ gɨyɨ́ rɨxɨŋɨ́ uráná amɨpí naŋɨ́pɨ ananɨ mɨnɨ winɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Seyɨ́né ‘Ámá e oneaiípoyɨ.’ nɨyaiwirɨ́náyɨ́, seyɨ́né ayo enɨ axɨ́pɨ e wiirɨ́ɨnɨ. Ŋwɨ́ ikaxɨ́ Moseso nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ xwɨyɨ́á wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́ápɨ tɨ́nɨ apɨ e rɨnɨŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Ɨ́wí onɨgɨ́ inɨŋɨ́yɨkwɨ́nimɨ páwianɨro éɨ́rɨxɨnɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ɨ́wí rɨ́wéná Gorɨxo xeanɨŋɨ́ winɨ́a nánɨ inɨŋɨ́yi óɨ́ xwé inɨŋagɨ nánɨ ámá obaxɨ́ Gorɨxo nánɨ dɨŋɨ́ mɨmó ayimɨ nɨpáwiro wigɨ́ dɨŋɨ́ tɨ́nɨ néra warɨŋoɨ. Ayɨnánɨ seyɨ́né óɨ́ Gorɨxo rɨ́wéná dɨŋɨ́ anɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ seaiapɨnɨ́a nánɨ onɨgɨ́ inɨŋɨ́yɨkwɨ́nimɨ páwipɨ́rɨ nánɨ anɨŋɨ́ minɨ́ o rɨŋɨ́pimɨ nɨxɨ́dɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mimónɨ́ wɨ́á rókiamoarɨgɨ́áwa wigɨ́ dɨŋɨ́ ínɨmɨnɨyɨ́ sɨ́wí sayɨ́ sɨ́ roarɨŋɨ́ yapɨ nimónɨmáná aiwɨ seyɨ́né tɨ́ámɨnɨ nɨbɨrɨ́ná sipɨsipɨ́ yapɨ́nɨŋɨ́ awayinɨ yarɨgɨ́ápa nimónɨmɨ seaímeapɨ́rɨ́árɨnɨ. Ayɨnánɨ sɨŋwɨ́ tɨ́nɨ erɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Seyɨ́né íkɨ́á naŋɨ́ wéɨ́na nɨwɨnɨrɨ́ná ‘Ana naŋɨ́narɨnɨ.’ rɨro sɨpí wéɨ́na nɨwɨnɨrɨ́ná ‘Ana sɨpínarɨnɨ.’ rɨro yarɨgɨ́ápa sɨpí imónɨŋɨ́ mimónɨ́ wɨ́á rókiamoarɨgɨ́áwa yarɨgɨ́ápɨ nɨwɨnɨrɨ́ná ‘Yapɨ́ rɨneaíwapɨyarɨŋoɨ? Nepa Gorɨxoyáowamanɨ.’ yaiwíɨ́rɨxɨnɨ. Ámá yapɨ́ seyɨ́né seaíwapɨyanɨro bɨ́áyɨ́ ekɨrɨkwɨ́nɨŋɨ́ imónɨŋoɨ. Wainɨ́ sogwɨ́ ekɨrɨkwɨ́yo darɨgɨ́áranɨ? Oweoɨ! Íkɨ́á pikɨ́ sogwɨ́ eŋwɨxɨ́yo darɨgɨ́áranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Rɨpɨ enɨ axɨ́pɨrɨnɨ. Íkɨ́á naŋɨ́yɨ́ sogwɨ́ naŋɨ́ wearɨŋɨ́rɨnɨ. Sɨpíyɨ́ sogwɨ́ sɨpí wearɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Íkɨ́á naŋɨ́yɨ́ sogwɨ́ sɨpí wepaxɨ́ mimónɨnɨ. Sɨpíyɨ́ sogwɨ́ naŋɨ́ wepaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Íkɨ́á nɨ́nɨ sogwɨ́ naŋɨ́ mɨwéɨ́yɨ́ nɨdɨkárɨro rɨ́á ikeaárarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ayɨnánɨ seyɨ́né íkɨ́á sogwɨ́yo nɨwɨnɨrɨ́ná nɨjɨ́á imónarɨgɨ́ápa sɨpí imónɨŋɨ́ mimónɨ́ wɨ́á rókiamoarɨgɨ́áwa yarɨgɨ́ápɨ nɨwɨnɨrɨ́ná ‘Gorɨxoyáowamanɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘Ámá Jisasomɨ “Ámɨnáoxɨnɨ, Ámɨnáoxɨnɨ” urarɨgɨ́á nɨ́nɨ xegɨ́ xano, aŋɨ́namɨ ŋweaŋo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́e páwipɨ́rɨ́árɨnɨ.’ mɨyaiwipanɨ. Ámá xɨ́o wimónarɨŋɨ́pɨ xɨ́darɨgɨ́á gɨyɨ́ gɨyɨ́, ayɨ́nɨ nɨpáwiro ŋweapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ ámá obaxɨ́ re nɨrayipɨ́rɨ́árɨnɨ, ‘Ámɨnáoxɨnɨ, Ámɨnáoxɨnɨ, nene yoɨ́ joxɨyáyo dánɨ xwɨyɨ́á wɨ́á rókiamoagwárɨnɨ.’ nɨnɨrɨro ‘Yoɨ́ joxɨyáyo dánɨ imɨ́ó mɨxɨ́ umáɨnowáragwárɨnɨ.’ nɨnɨrɨro ‘Yoɨ́ joxɨyáyo dánɨ emɨmɨ́ obaxɨ́ wíwapɨyagwárɨnɨ.’ nɨnɨrɨro epɨ́rɨ́á eŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ámá nɨyɨ́yá sɨŋwɨ́ anɨgɨ́e dánɨ re urɨmɨ́árɨnɨ, ‘Seyɨ́né nánɨ nionɨ nɨjɨ́á wí mimónɨŋɨnɨ. Rɨkɨkɨrɨ́ó yarɨgɨ́áyɨ́né nionɨ pɨ́nɨ nɨnɨwiárɨmɨ úpoyɨ.’ urɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ámá gɨyɨ́ gɨyɨ́ nionɨyá xwɨyɨ́á rɨpɨ arɨ́á nɨnirɨ xɨxenɨ e nɨnɨxɨ́dɨrɨ́náyɨ́ ayɨ́ ámá sɨ́ŋá aŋɨ́ nɨmɨrɨrɨ́ná dɨŋɨ́ píránɨŋɨ́ neŋwɨperɨ xwɨ́á nɨmiga nɨwerɨ sɨ́ŋá piárá ínɨmɨ yapɨnɨŋɨ́namɨ dánɨ sɨ́ŋá piárá aŋɨ́ mɨrɨnɨ́ápɨ e dánɨ nɨkɨkíróa nɨyapɨrɨ mɨrarɨŋónɨŋɨ́ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iniá earɨ iniɨgɨ́ waxɨ́ xwé weapɨrɨ rɨ́wɨpí erɨ nerɨ aiwɨ aŋiwá sɨ́ŋá ínɨmɨ yapɨnɨŋɨ́namɨ dánɨ nɨkɨkíróga yapɨnɨŋagɨ nánɨ mɨkwierómioaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ámá gɨyɨ́ gɨyɨ́ xwɨyɨ́á nionɨ rarɨŋápɨ arɨ́á nɨniro aí xɨxenɨ mepa nerɨ́náyɨ́ ayɨ́ ámá sɨ́ŋá aŋɨ́ nɨmɨrɨrɨ́ná majɨmajɨ́á nikárɨnɨrɨ inɨkíyo seáyɨ e dánɨ sɨ́ŋá nɨkɨkíróa nɨyapɨrɨ mɨrárarɨŋónɨŋɨ́ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iniá earɨ iniɨgɨ́ waxɨ́ weapɨrɨ rɨ́wɨpí erɨ yarɨ́ná aŋiwá nɨkwierónowirɨ rɨwɨ́ nɨra piéroŋɨnigɨnɨ.” Jisaso e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","xwɨyɨ́á apɨ nɨpɨnɨ rɨxa nɨra núɨsáná eŋáná ámá e epɨ́royɨ́ egɨ́áyɨ́ o ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa uréwapɨyarɨgɨ́ápa muréwapɨyí nénɨ́ tɨ́ŋónɨŋɨ́ uréwapɨyarɨŋagɨ nánɨ ududɨ́ néra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisaso nuréwapɨyíɨsáná dɨ́wɨ́ mɨŋɨ́yo dánɨ weaparɨ́ná oxɨ́ apɨxɨ́ niaíwɨ́ obaxɨ́ númɨ weaparɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ámá peyɨyɨ́ imónɨŋɨ́ wo nɨbɨrɨ nɨwímearɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ nionɨ nánɨ ‘Naŋɨ́ owimɨxɨmɨnɨ.’ nɨyaiwirɨ́ná ananɨ naŋɨ́ nimɨxɨpaxoxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisaso wé ɨ́eapá nɨwirɨ seáyɨ e nɨwikwiárɨrɨ “‘Joxɨ naŋɨ́ oimónɨnɨ.’ nimónarɨnɨ. Rɨxa naŋɨ́ imóneɨ.” uráná re eŋɨnigɨnɨ. Peyɨyɨ́ imónɨŋo naŋɨ́ imónɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ nionɨ naŋɨ́ simɨxɨ́áyɨ́ nánɨ amíná nurɨ ámáyo áwaŋɨ́ murɨpanɨ.” nurɨrɨ ámá o Moseso eŋíná ŋwɨ́ ikaxɨ́ ragɨ́pɨ mé ámáyo xewanɨŋo áwaŋɨ́ nura emenɨgɨnɨrɨ e nurɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Amíná apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa tɨ́ŋɨ́ e nánɨ nurɨ womɨ sɨwá nɨwinɨrɨ naŋwɨ́ rɨdɨyowá nánɨ negɨ́ arɨ́o Moseso eŋíná sekaxɨ́ nearagɨ́yɨ́ bɨ mɨnɨ wíɨrɨxɨnɨ. Gorɨxo nánɨ rɨdɨyowá siárirɨ joxɨ naŋɨ́ imónɨ́ɨ́pɨ nánɨ áwaŋɨ́ rɨrɨ oenɨrɨ mɨnɨ wíɨrɨxɨnɨ.” urowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","O aŋɨ́ yoɨ́ Kapaneamɨyo rémóáná wauyɨ́ porisɨ́ ámɨná imónɨŋɨ́ wo nɨwímearɨ waunɨ́ rɨxɨŋɨ́ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, gɨ́ inókínɨŋɨ́ nimónɨrɨ omɨŋɨ́ niiarɨŋo eŋɨ́ nɨ́nɨ sɨwímɨ́ nerɨ nɨwerɨ rɨ́nɨŋɨ́ xwé winarɨnɨ. Ananɨ naŋɨ́ imɨxɨréɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisaso re urɨŋɨnigɨnɨ, “Ananɨrɨnɨ. Nionɨ nurɨ naŋɨ́ imɨxɨmɨ́ɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","porisɨ́ ámɨná imónɨŋo re nɨyaiwirɨ “Porisɨ́ wa nionɨ ínɨmɨ nurɨ́nɨŋɨ́pa sɨmɨxɨ́yɨ́ enɨ Jisasomɨ ínɨmɨ wurɨ́nɨnɨ.” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nionɨ ámá wé rónɨŋɨ́ joxɨ tɨ́nɨ xɨxenɨ mimónɨŋagɨ nánɨ joxɨ gɨ́ aŋɨ́yo ɨ́wiapɨpaxɨ́ mimónɨnɨ. E nerɨ aí joxɨ re dánɨ ‘O naŋɨ́ oimónɨnɨ.’ ráná gɨ́ omɨŋɨ́ niiarɨŋo naŋɨ́ imónɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Nionɨ enɨ ámá omɨŋɨ́ ‘Ayɨ́ ayɨ́ eɨ.’ nɨrarɨgɨ́áwamɨ ínɨmɨ wurɨ́nɨŋɨnɨ. Nionɨ enɨ porisɨ́ wa ínɨmɨ nurɨ́nɨŋoɨ. Womɨ ‘Joxɨ aŋɨ́ uɨ.’ uráná sa ananɨ arɨ́á nɨnirɨ warɨŋɨ́rɨnɨ. Womɨ ‘Beɨ.’ uráná sa xɨxenɨ barɨŋɨ́rɨnɨ. Gɨ́ inókínɨŋɨ́ niiarɨŋɨ́ womɨ ‘E eɨ.’ uráná xɨxenɨ yarɨŋɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisaso arɨ́á e nɨwirɨ nánɨ ududɨ́ nerɨ ámá xɨ́omɨ númɨ warɨgɨ́áyo nɨkɨnɨmónɨrɨ re urɨŋɨnigɨnɨ, “Isɨrerɨyɨ́né woxɨ ámá ro dɨŋɨ́ seáyɨ e nɨnɨkwɨ́rorɨ yarɨŋɨ́pa xɨxenɨ e dɨŋɨ́ mɨnɨkwɨ́roarɨŋagɨ sɨŋwɨ́ ranɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nionɨ re seararɨŋɨnɨ, ‘Ámá Gorɨxo xegɨ́yɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweaŋáná émá obaxɨ́ sogwɨ́ ɨ́wiaparɨŋɨ́mɨnɨ ŋweagɨ́áyɨ́ tɨ́nɨ sogwɨ́ wearɨŋɨ́mɨnɨ ŋweagɨ́áyɨ́ tɨ́nɨ nɨbɨro segɨ́ arɨ́owa Ebɨrɨ́amo tɨ́nɨ Aisako tɨ́nɨ Jekopo tɨ́nɨ nawínɨ anɨ nɨŋwearo aiwá nɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","E nerɨ aí Isɨrerɨyɨ́né, Gorɨxo aŋɨpaxɨ́ xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweapaxɨ́yɨ́né Gorɨxo meŋweanɨ́e dánɨ sɨ́á yinɨŋɨ́mɨ seamoaíáná e dánɨ mɨmenɨŋwɨ́ ayɨkwɨ́ mɨsearɨnɨ́á eŋagɨ nánɨ ŋwɨ́ earo maŋɨ́ sɨ́wɨ́ rɨ́kwínɨro epɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","wauyɨ́ porisɨ́ ámɨná imónɨŋomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ aŋɨ́ uɨ. Joxɨ ‘O e epaxorɨnɨ.’ nɨniaiwirɨ dɨŋɨ́ nɨkwɨ́roarɨŋɨ́pɨ xɨxenɨ rɨxa oimónɨnɨ.” urowáráná axíná xegɨ́ omɨŋɨ́ wiiarɨŋo rɨxa naŋɨ́ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisaso Pitaoyá aŋɨ́yo nɨpáwirɨ́ná wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Pitaomɨ xɨneagwí wará rɨ́á pɨrɨ́ wiarɨŋagɨ íkwiaŋwɨ́yo sá riyí weŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","wé seáyɨ e ikwiáráná re eŋɨnigɨnɨ. Rɨ́á pɨrɨ́ pɨ́nɨ wiáráná nɨwiápɨ́nɨmearɨ Jisasomɨ aiwá nɨxerɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rɨxa sogwɨ́ wéáná ámá e dáŋɨ́yɨ́ wigɨ́ ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yɨ́ obaxɨ́ o tɨ́ŋɨ́ e nɨméra nɨbɨro wáráná oyá xwɨyɨ́á tɨ́nɨ mɨxɨ́ umáɨnowárayirɨ sɨmɨxɨ́yɨ́ nɨ́nɨ enɨ píránɨŋɨ́ imɨmɨxɨmɨ́ erɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo ámá xegɨ́ xiáwowayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ xwɨyɨ́á nɨrɨrɨ eaŋɨ́ rɨpɨ, “Xewanɨŋo negɨ́ sɨmɨxɨ́yɨ́ tɨ́nɨ uranɨ́ tɨ́gɨ́áyɨ́ tɨ́nɨ naŋɨ́ imɨmɨxɨmɨ́ enɨ́árɨnɨ.” rɨŋɨ́pɨ rɨxa xɨxenɨ imónɨnɨ nánɨ Jisaso e eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisaso ámá oxɨ́ apɨxɨ́ obaxɨ́ omɨ ɨkwɨkwierɨ́ wiarɨŋagɨ́a nɨwɨnɨrɨ xegɨ́ wiepɨsarɨŋowamɨ sekaxɨ́ re urɨŋɨnigɨnɨ, “None ipíwámɨ jɨ́arɨwámɨ dánɨ xemoanɨ nánɨ ewéyo pɨxemoánɨ́poyɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áyɨ́ wo nɨbɨrɨ re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, aŋɨ́ amɨ gɨmɨ gɨmɨ nánɨ úáná nionɨ númɨ rɨxɨ́dɨmemɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","o re urɨŋɨnigɨnɨ, “Sɨ́wí sayɨ́ sá wenɨ́a nánɨ sɨ́ŋá sirɨrɨkɨ́ tɨ́ŋɨ́rɨnɨ. Iŋɨ́ enɨ sá wenɨ́a nánɨ nɨyinɨ́ tɨ́ŋɨ́rɨnɨ. E nerɨ aí ámá imónɨŋáonɨ sá wémɨ́a nánɨ aŋɨ́ wí menɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xegɨ́ wiepɨsarɨŋɨ́yɨ́ ámɨ wo re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, gɨ́ ápo tɨ́nɨ nɨŋweaŋɨsáná o rɨxa péáná xwɨ́á nɨweyárɨmonɨ númɨ rɨxɨ́dɨmemɨ́a nánɨ ananɨranɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisaso ámá xɨ́omɨ dɨŋɨ́ mɨwɨkwɨ́roarɨgɨ́áyɨ́ nánɨ re urɨŋɨnigɨnɨ, “Xegɨ́ pɨyɨ́ wɨ́a xwɨ́á weyárɨ́ɨ́rɨxɨnɨrɨ sɨŋwɨ́ nɨwɨnɨrɨ nionɨ númɨ nɨxɨ́deɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E nurɨmɨ ewéyo pɨxemoánáná xegɨ́ wiepɨsarɨŋowa enɨ nɨpɨxemoánɨro ipíyo orɨwámɨ dánɨ nánɨ nɨmeámɨ warɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Rɨ́wɨpí xwé nerɨ iniɨgɨ́ imeamɨ́kwɨ́ nerɨ́ná rɨxa ewépá mɨwiárómɨnɨrɨ yarɨŋagɨ aiwɨ Jisaso sá maiwí weŋagɨ ");
INSERT INTO aak_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","wiepɨsarɨŋowa nuro saiwiárɨ́ nɨwiro re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, rɨxa nɨneamɨwiáropaxɨ́rɨnɨ. Arɨrá neaiɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","o re urɨŋɨnigɨnɨ, “Dɨŋɨ́ onɨmiápɨ nɨkwɨ́roarɨgɨ́oyɨ́né pí nánɨ wáyɨ́ seainarɨnɨ?” nurɨmɨ nɨwiápɨ́nɨmearɨ re rɨŋɨnigɨnɨ, “Imɨŋɨ́ tɨ́nɨ iniɨgɨ́ tɨ́nɨ samɨŋɨ́ oweárɨnɨ.” ráná re eŋɨnigɨnɨ. Imɨŋɨ́ pɨ́nɨ wiárɨrɨ iniɨgɨ́ wiŋwɨ́ mé rɨwoárɨrɨ nerɨ ŋɨŋiɨ́á imónárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋɨŋiɨ́á imónárɨ́agɨ nɨwɨnɨro re rɨnɨgɨ́awixɨnɨ, “Pí ámáorɨ́anɨ? Imɨŋɨ́ tɨ́nɨ iniɨgɨ́ tɨ́nɨ arɨ́á nɨwirɨ samɨŋɨ́ weárɨ́áyoɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","O tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ orɨwámɨ dánɨ ámá yoɨ́ Gadarayɨ́ aŋɨ́yɨ́ tɨ́ŋɨ́ e niwiékɨ́nɨmearo ewéyo dánɨ ayoááná ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́ waú —Awaú imɨ́ó nimónɨri sayɨ́ e roŋagɨ́i nánɨ ámá óɨ́ ayimɨ mɨpwarɨgɨ́árɨnɨ. Awaú xwárɨpá ámá tayarɨgɨ́á tɨ́ŋɨ́ aŋwɨ e dánɨ nɨbɨri nawínɨ órórɨ́ ninɨro ");
INSERT INTO aak_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","xwamiánɨ́ re urɨgɨ́isixɨnɨ, “Niaíwɨ́ Gorɨxoyáoxɨnɨ, joxɨ pí neaimɨnɨrɨ barɨŋɨnɨ? Gorɨxo rɨ́wéná rɨ́nɨŋɨ́ neaiapɨnɨ́á sɨnɨ eŋáná joxɨ rɨ́nɨŋɨ́ neaiapɨmɨnɨrɨ rɨbarɨŋɨnɨ?” nurɨro ");
INSERT INTO aak_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","odɨpí obaxɨ́ bɨ ná jɨ́amɨ nɨrómáná aiwá narɨŋagɨ́a nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “Joxɨ mɨxɨ́ nɨneamáɨnɨrɨ́náyɨ́, odɨpíyo oxɨxérópoyɨnɨrɨ sɨŋwɨ́ neaneɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","o “Emanɨ!” urɨ́agɨ ámá awaúmɨ pɨ́nɨ nɨwiárɨmɨ odɨpípimɨ xɨxéróáná re eŋɨnigɨnɨ. Pɨmaŋɨ́ mɨwiároŋɨ́mɨ aŋɨ́nɨ imegɨ́nɨ wéɨ́áyɨ́ ipíyo igwɨ́á nuyíroro iniɨgɨ́ nɨnamiro pɨyɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pɨyɨ́ éagɨ́a odɨpí awí mearoarɨgɨ́áwa sɨŋwɨ́ e nɨwɨnɨmɨ wigɨ́ aŋɨ́ apimɨ nánɨ mɨ́rɨ́ nuro odɨpí iniɨgɨ́ namíɨ́ápɨ tɨ́nɨ ámá imɨ́ó xɨxéroarɨgɨ́íwaú enɨ naŋɨ́ imónɨri éɨ́pɨ tɨ́nɨ nánɨ repɨyɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ámá oxɨ́ apɨxɨ́ nɨ́nɨ aŋɨ́ apimɨ dáŋɨ́yɨ́ Jisasomɨ wímeanɨro nánɨ nuro omɨ nɨwɨnɨro rɨxɨŋɨ́ “Joxɨ neneyá xwɨ́á re pɨ́nɨ nɨneawiárɨmɨ wí e nánɨ uɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisaso ewépámɨ nɨpɨxemoánɨrɨ nɨŋwearɨ nɨmeámɨ orɨwámɨ dánɨ nɨxemoaurɨ xegɨ́ aŋɨ́ ŋweaarɨŋɨ́pimɨ nɨrémorɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","re eŋɨnigɨnɨ. Ámá wa ámá eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋɨ́ wo íkwiaŋwɨ́yo nɨtɨmáná nɨmeámɨ báná Jisaso awa “O ananɨ naŋɨ́ neaimɨxɨyipaxɨ́rɨnɨ.” nɨyaiwiro xɨ́omɨ dɨŋɨ́ wɨkwɨ́roarɨŋagɨ́a nɨwɨnɨrɨ eŋɨ́ sɨwímɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Ámá roxɨnɨ, joxɨ ayá sɨ́wɨ́ mɨrɨropanɨ. Ɨ́wɨ́ joxɨ yarɨŋɨ́pɨ rɨxa yokwarɨmɨ́ siíárɨnɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa wigɨ́ xwioxɨ́yo dánɨ dɨŋɨ́ re nɨpɨkíga ugɨ́awixɨnɨ, “Ámá ro ‘Gorɨxo yarɨŋɨ́pɨ epaxonɨrɨnɨ.’ nɨyaiwirɨ nɨrɨrɨ́ná Gorɨxomɨ rɨperɨrɨ́ umearɨnɨ.” Ínɨmɨ dánɨ dɨŋɨ́ e yaiwiarɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisaso dɨŋɨ́ adadɨ́ nɨwirɨ nɨjɨ́á nimónɨrɨ re urɨŋɨnigɨnɨ, “Pí nánɨ segɨ́ dɨŋɨ́yo dánɨ ‘O Gorɨxomɨ rɨperɨrɨ́ numerɨ yarɨnɨ.’ niaiwiarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Nionɨ eŋɨ́ sɨwímɨ́ eŋomɨ ‘Dɨxɨ́ ɨ́wɨ́ yarɨŋɨ́pɨ rɨxa yokwarɨmɨ́ siíárɨnɨ.’ uráná soyɨ́né ‘O nénɨ́ tɨ́ŋorɨ́anɨ?’ niaiwipɨ́rɨréoɨ? Omɨ ‘Naŋɨ́ nimónɨrɨ nɨwiápɨ́nɨmeámɨ aŋɨ́ uɨ.’ uráná soyɨ́né ‘O nénɨ́ tɨ́ŋorɨ́anɨ?’ niaiwipɨ́rɨréoɨ? Ɨ́wɨ́ yarɨŋɨ́pɨ yokwarɨmɨ́ nɨwiirɨ́ná ínɨmɨ imónɨŋagɨ nánɨ e yaiwipaxɨ́ mimónɨnɨ. E nerɨ aiwɨ ámá imónɨŋáonɨ nánɨ ‘O xwɨ́á tɨ́yo nɨŋwearɨ́ná enɨ ɨ́wɨ́ yarɨgɨ́ápɨ yokwarɨmɨ́ wiinɨ nánɨ nénɨ́ tɨ́ŋorɨ́anɨ?’ niaiwipɨ́rɨ nánɨ sɨŋwɨ́ nanɨ́poyɨ.” nurɨrɨ ámá eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Joxɨ nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨxopemɨxɨrɨ nɨmeámɨ uɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","o nɨwiápɨ́nɨmeámɨ xegɨ́ aŋɨ́ e nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Xegɨ́ aŋɨ́ e nánɨ úagɨ oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ sɨŋwɨ́ e nɨwɨnɨro nánɨ dɨŋɨ́ nɨyeawárɨro “Gorɨxo ámá ro nénɨ́ tɨ́ŋónɨŋɨ́ wimɨxɨŋɨ́rɨ́anɨ?” nɨyaiwiro xɨ́omɨ yayɨ́ seáyɨmɨ dánɨ umegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisaso e pɨ́nɨ nɨwiárɨmɨ nurɨ́ná ámá wo xegɨ́ yoɨ́ Matɨyuoyɨ rɨnɨŋo takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á opisɨ́ aŋɨ́yo riwo ŋweaŋagɨ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ nɨxɨ́dɨméɨrɨxɨnɨ.” urɨ́agɨ o nɨwiápɨ́nɨmearɨ númɨ uxɨ́dɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisaso xegɨ́ wiepɨsarɨŋowa tɨ́nɨ aŋɨ́ Matɨyuoyá nánɨ nuro aiwá narɨ́ná ámá takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́áyɨ́ tɨ́nɨ ɨ́wɨ́ arɨ́kí yarɨgɨ́á wínɨyɨ́ tɨ́nɨ omɨ nɨwímearo nawínɨ aiwá narɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisiowa sɨŋwɨ́ e nɨwɨnɨro xegɨ́ wiepɨsarɨŋowamɨ re urɨgɨ́awixɨnɨ, “Segɨ́ searéwapɨyarɨŋɨ́ ro pí nánɨ ámá takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́á tɨyɨ́ tɨ́nɨ ɨ́wɨ́ arɨ́kí yarɨgɨ́á tɨyɨ́ tɨ́nɨ nawínɨ nɨŋwearo aiwá narɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisaso arɨ́á e nɨwirɨ xewanɨŋo nánɨ “Ámá ɨ́wɨ́ yarɨgɨ́áyo arɨrá wimɨnɨrɨ nánɨ weapɨŋorɨ́anɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ámá sɨmɨxɨ́ mɨyarɨgɨ́áyɨ́ xwɨrɨ́ tɨ́ŋɨ́ e nánɨ warɨgɨ́áranɨ? Oweoɨ, sɨmɨxɨ́ yarɨgɨ́áyɨ́nɨ xwɨrɨ́ tɨ́ŋɨ́ e nánɨ warɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","E nerɨ aí soyɨ́né nuro xwɨyɨ́á eŋíná wɨ́á rókiamoagɨ́ Xoseao nɨrɨrɨ eaŋɨ́ rɨpɨ, ‘ “Rɨdɨyowánɨ Gorɨxonɨ nánɨ níɨ́rɨxɨnɨ.” mɨnimónarɨnɨnɨ. “Ámá wíyo nánɨ ayá nurɨmɨxɨro arɨrá wíɨ́rɨxɨnɨ.” nimónarɨnɨ.’ nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ apimɨ ɨ́á nɨroro nɨjɨ́á imónɨ́poyɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá ‘Wé rónɨŋɨ́ yarɨŋwaénexɨnɨ.’ yaiwinarɨgɨ́áyo ‘Nionɨ tɨ́ámɨnɨ bɨ́poyɨ.’ urɨmɨnɨrɨ nánɨ weapɨŋámanɨ. ‘Ɨ́wɨ́ yarɨŋwaénexɨnɨ.’ yaiwinarɨgɨ́áyo nánɨ weapɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jono wayɨ́ numeaia warɨŋoyá wiepɨsarɨŋowa Jisaso tɨ́ŋɨ́ e nánɨ nɨbɨro re urɨgɨ́awixɨnɨ, “None tɨ́nɨ Parisiowa tɨ́nɨ Gorɨxo none nánɨ yayɨ́ owinɨnɨrɨ aiwá ŋwɨ́á ŋwɨrárɨnayarɨŋagwɨ aiwɨ dɨxɨ́ wiepɨsarɨŋowa pí nánɨ aiwá ŋwɨ́á mɨŋwɨrárɨnɨ́ yarɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisaso xewanɨŋo nánɨ “Omɨ wa nɨpɨkímáná eŋáná wiepɨsarɨŋɨ́yɨ́ dɨŋɨ́ sɨpí nɨwirɨ́ná aiwá ŋwɨ́á ŋwɨrárɨnɨpɨ́rɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Ámá apɨxɨ́ sɨŋɨ́ meáo xegɨ́ ámá imónɨgɨ́áyɨ́ tɨ́nɨ ŋweaŋáná o nánɨ dɨŋɨ́ sɨpí wipaxɨ́ menɨnɨ. E nero aí ámá wa omɨ anɨ́nɨmɨxáná íná aiwá ŋwɨ́á ŋwɨrárɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Xwɨyɨ́á Parisiowa nearéwapɨyarɨgɨ́ápɨ tɨ́nɨ Jisaso sɨŋɨ́ nearéwapɨyarɨŋɨ́pɨ tɨ́nɨ kumɨxɨpaxɨ́ mimónɨnɨ.” oyaiwípoyɨnɨrɨ ámɨ ewayɨ́ ikaxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá wigɨ́ sorɨ́á axenɨŋagɨ nɨwɨnɨróná rapɨrapɨ́ sɨnɨ mɨkɨkarínɨŋɨ́ bɨ nɨmearo urɨ́ óɨ́ inɨŋúmɨ nɨpɨ́roro gwɨ́ kiwearɨgɨ́ámanɨ. E nerɨ́náyɨ́, igɨ́á eánáná rapɨrapɨ́ sɨŋɨ́ pɨ́róɨ́ápɨ nɨkɨkarínɨrɨ́ná urú xwé naxega unɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Rɨpɨ enɨ ámá iniɨgɨ́ wainɨ́ sɨŋɨ́ memé wará sɨxɨ́ urɨ́wámɨ iwajɨ́á yarɨgɨ́ámanɨ. E nerɨ́náyɨ́, memé wará sɨxɨ́wá núpɨyinɨrɨ́ná iniɨgɨ́ wainɨ́ purɨ sɨxɨ́wá xwɨrɨ́á ikɨxénɨrɨ e enɨgɨnɨ. Wainɨ́ sɨŋɨ́yɨ́ memé wará sɨxɨ́ sɨŋɨ́wámɨ yíánáyɨ́, wará tɨ́nɨ iniɨgɨ́ tɨ́nɨ nɨpiaúnɨ naŋɨ́ enɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisaso xwɨyɨ́á apɨ sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Judayɨ́yá rotú aŋɨ́ meweŋɨ́ wo nɨbɨrɨ Jisaso sɨkwɨ́ tɨ́ŋɨ́ e mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ re urɨŋɨnigɨnɨ, “Gɨ́ miaí rɨxa pearɨnɨ. E nerɨ aí joxɨ nɨbɨrɨ wé seáyɨ e wikwiáráná naŋɨ́ oenɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","o nɨwiápɨ́nɨmearɨ númɨ nurɨ wiepɨsarɨŋowa enɨ nawínɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","re eŋɨnigɨnɨ. Apɨxɨ́ wí —Í xegɨ́ ragɨ́ anɨŋɨ́ pwarɨ́ná xwiogwɨ́ wé wúkaú sɨkwɨ́ waú múroŋírɨnɨ. Í “Niínɨ oyá iyɨ́áyonɨ amáɨ́ nɨrónɨrɨ́ná naŋɨ́ imónɨmɨnɨyɨ́rɨ́anɨ?” nɨyaiwia nɨbɨrɨ rɨ́wɨ́yo nɨrónapɨmáná Jisasoyá iyɨ́áyo sírɨ́wɨ́ jɨ́e amáɨ́ rónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Amáɨ́ rónɨ́agɨ Jisaso nɨkɨnɨmónɨrɨ ímɨ sɨŋwɨ́ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Gɨ́ ineyɨ, ayá sɨ́wɨ́ mɨrɨropanɨ. Jíxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨŋɨ́pimɨ dánɨ erɨ́kiemeánɨ́ɨnɨ.” uráná í rɨxa naŋɨ́ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisaso e dánɨ nurɨ rotú aŋɨ́ meweŋoyá aŋɨ́ e nɨrémorɨ oxɨ́ apɨxɨ́ epɨ́royɨ́ nɨyárɨmáná ŋwapé rɨro webɨ́í rɨro nero yaiwínɨŋɨ́ yarɨŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","re urɨŋɨnigɨnɨ, “Rɨxa peyeápoyɨ. Miáí pɨyɨ́ menɨnɨ. Sa sá wenɨ.” urɨ́agɨ ayɨ́ rɨpɨ́á nurɨro yarɨŋagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","nɨ́nɨ miáí tɨ́ŋɨ́ e pɨ́nɨ nɨwiárɨmɨ rɨxa nɨpeyeámáná eŋáná o nɨpáwirɨ miáímɨ wéyo ɨ́á nɨmaxɨrɨrɨ mɨ́eyoááná re eŋɨnigɨnɨ. Miáí wiápɨ́nɨmeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Í wiápɨ́nɨmeágɨ xwɨyɨ́á o éɨ́pɨ nánɨ xwɨyɨ́á aŋɨ́ nɨyonɨ rɨnárɨmeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisaso e dánɨ warɨ́ná ámá sɨŋwɨ́ supárɨgɨ́íwaú númɨ nuxɨ́dɨri rɨ́aiwá re urɨgɨ́isixɨnɨ, “Negɨ́ mɨxɨ́ ináyɨ́ Depitomɨ xiáwoxɨnɨ, yawawi ananɨ wá yeawianɨréɨnɨ?” nurɨri ");
INSERT INTO aak_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","o rɨxa aŋɨ́yo nɨpáwirɨ ŋweaŋagɨ awaú enɨ nɨpáwiri wímeááná Jisaso yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awagwí dɨŋɨ́ nɨnɨkwɨ́rori ‘O ananɨ sɨŋwɨ́ supárɨgwɨ́íyɨ́ naŋɨ́ yeaimɨxɨpaxorɨnɨ.’ rɨniaiwiarɨŋiɨ?” urɨ́agɨ awaú “Oyɨ, Ámɨnáoxɨnɨ, joxɨ e epaxoxɨrɨnɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","o egɨ́ sɨŋwɨ́yo wé ɨ́á nuxɨrɨrɨ re urɨŋɨnigɨnɨ, “Awagwí dɨŋɨ́ nɨkwɨ́roarɨgɨ́ípa xɨxenɨ oimónɨnɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Awaú sɨŋwɨ́ noxoari anɨgɨ́isixɨnɨ. Sɨŋwɨ́ noxoari anɨ́agɨ́i Jisaso arɨ́á jɨyikɨ́ norɨ re urɨŋɨnigɨnɨ, “Awagwí nionɨ eaíápɨ ámá wíyo áwaŋɨ́ murɨmepa éisixɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","awaú o tɨ́ŋɨ́ e dánɨ nuríná xɨ́o wíɨ́pɨ nánɨ amɨ amɨ repɨyɨ́ nɨwia emegɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jisaso e dánɨ warɨ́ná ámá wí wigɨ́ ámá imɨ́ó dɨŋɨ́ xɨxéroŋagɨ nánɨ maŋɨ́ pɨ́rónárɨŋɨ́ wo Jisaso pwarɨŋe nánɨ nɨmeámɨ nɨbɨro wáráná ");
INSERT INTO aak_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","o imɨ́óyo mɨxɨ́ umáɨnowáráná maŋɨ́ pɨ́rónárago rɨxa xwɨyɨ́á rarɨŋagɨ oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ sɨŋwɨ́ e éagɨ nɨwɨnɨro ududɨ́ nero re nɨra ugɨ́awixɨnɨ, “Aga eŋíná eŋíná aiwɨ Isɨrerene ámá wo e yarɨŋagɨ wɨnagwámanɨ.” nɨra úagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisiowa re rɨgɨ́awixɨnɨ, “Obo, imɨ́óyo umeŋweaŋoyá dɨŋɨ́ tɨ́nɨ mɨxɨ́ umáɨnowárarɨŋɨ́rɨnɨ.” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisaso Judayɨ́yá aŋɨ́ xwéyo tɨ́nɨ onɨmiáyo tɨ́nɨ nemerɨ́ná wigɨ́ rotú aŋɨ́yo nɨpáwirɨ uréwapɨyemerɨ xwɨyɨ́á yayɨ́ winɨpaxɨ́pɨ —Apɨ Gorɨxo ámá xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́ápɨ nánɨ rɨnɨŋɨ́pɨrɨnɨ. Apɨ nánɨ wáɨ́ urɨmerɨ ámá sɨmɨxɨ́ xɨxegɨ́nɨ yarɨgɨ́áyo tɨ́nɨ uranɨ́ xɨxegɨ́nɨ imónɨgɨ́áyo tɨ́nɨ naŋɨ́ imɨmɨxɨmɨ́ wiemerɨ nerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ámá oxɨ́ apɨxɨ́ epɨ́royɨ́ egɨ́áyɨ́ sipɨsipɨ́ xiáwo mayɨ́ nerɨ́ná úrapí nero dɨŋɨ́ sɨmɨgwɨ́á nɨyinɨrónɨŋɨ́ wiároárɨnarɨgɨ́ápa yarɨŋagɨ́a nɨwɨnɨrɨ wá nɨwianɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ámá xwɨyɨ́á Gorɨxoyá wáɨ́ urɨmepɨ́rɨ́a nánɨ obaxɨ́ mimónɨŋagɨ nánɨ xegɨ́ wiepɨsarɨŋɨ́yo re urɨŋɨnigɨnɨ, “Aiwá omɨŋɨ́yo pɨ́rɨpɨ́rɨ́ inárɨŋagɨ aiwɨ ámá nɨmipɨ́rɨ́a nánɨ obaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ayɨnánɨ Gorɨxomɨ rɨxɨŋɨ́ re urɨ́poyɨ, ‘Ámá aiwá apɨ rɨmiipɨ́rɨ nánɨ dɨxɨ́ omɨŋɨ́ tɨ́ŋɨ́ e nánɨ urowárɨ́ɨrɨxɨnɨ.’ urɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisaso xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ “Awí eánɨ́poyɨ.” nurɨmáná awa ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnowárɨro ámá sɨmɨxɨ́ xɨxegɨ́nɨ yarɨgɨ́áyo tɨ́nɨ uranɨ́ xɨxegɨ́nɨ imónɨgɨ́áyo tɨ́nɨ naŋɨ́ imɨxɨro epaxɨ́ imónɨ́ɨ́rɨxɨnɨrɨ eŋɨ́ weámɨxowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Xegɨ́ wáɨ́ wurɨmeiarɨgɨ́áwa, wé wúkaú sɨkwɨ́ waú imónɨgɨ́áwa wigɨ́ yoɨ́ rowarɨnɨ. Xámɨŋo Saimonorɨnɨ. Ámɨ yoɨ́ bɨ Pitaoyɨ wɨ́rɨnɨŋorɨnɨ. Xegɨ́ xogwáo Adɨruorɨnɨ. Sebediomɨ xewaxowaú Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripo tɨ́nɨ Batoromuo tɨ́nɨrɨnɨ. Tomaso tɨ́nɨ Matɨyuo tɨ́nɨ —O takisɨ́ nánɨ nɨgwɨ́ urápagorɨnɨ. O tɨ́nɨrɨnɨ. Arɨpiasomɨ xewaxo Jemiso tɨ́nɨ Tadiaso tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimono —O ámá “Émáyo mɨxɨ́ oxɨ́dowáraneyɨ.” rarɨgɨ́áyɨ́ tɨ́nɨ nawínɨ nɨkumɨxɨnɨrɨ emeagorɨnɨ. O tɨ́nɨ Isɨkariotɨ dáŋɨ́ Judaso —O Jisaso nánɨ mɨyɨ́ urɨŋorɨnɨ. O tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisaso wé wúkaú sɨkwɨ́ waú awamɨ nurowárɨrɨ́ná sekaxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né nuróná émáyɨ́yá aŋɨ́ tɨ́ŋɨ́mɨnɨ mupanɨ. Samariayɨ́ —Ámá ayɨ́ Judayɨ́ tɨ́nɨ xepɨxepá rónarɨgɨ́áyɨ́rɨnɨ. Ayɨ́yá aŋɨ́yo nánɨ enɨ mupanɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Soyɨ́né negɨ́ Isɨrerɨyɨ́ —Ayɨ́ sipɨsipɨ́ xiáwo píránɨŋɨ́ mɨmearɨ́ná amɨ amɨ uniamoarɨŋɨ́nɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ. Ayɨ́ tɨ́ŋɨ́ e nánɨnɨ úpoyɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Soyɨ́né nuróná wáɨ́ re urɨmerɨ́ɨnɨ, ‘Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋweanɨ aŋwɨ ayo eŋagɨ nánɨ segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.’ urɨmero ");
INSERT INTO aak_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ámá sɨmɨxɨ́yo naŋɨ́ imɨmɨxɨmɨ́ ero ámá péɨ́áyo dɨŋɨ́ sɨxɨ́ numímoro saiwiárɨ́ wiro ámá peyɨyɨ́ tɨ́gɨ́áyo wigɨ́ wará naŋɨ́ wimɨxɨro imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnowárɨro eméɨ́rɨxɨnɨ. Soyɨ́né nionɨ eŋɨ́ eánɨŋɨ́ anɨpá eŋɨ́ seaeámɨxowárɨ́áyɨ́ nánɨ soyɨ́né ámá sɨmɨxɨ́yo naŋɨ́ imɨmɨxɨmɨ́ nɨwirɨ́ná nɨgwɨ́ nánɨ murɨpa nero sa anɨpá naŋɨ́ imɨmɨxɨmɨ́ wíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Soyɨ́né nɨwanɨro nerɨ́ná nɨgwɨ́ sɨxɨ́ ímoarɨgɨ́áyo nɨgwɨ́ xwéranɨ, onɨmiáranɨ, nɨmearo sɨxɨ́ nímoro nɨmeámɨ mupa ero ");
INSERT INTO aak_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ɨ́á árupiaŋɨ́ aí tɨ́nɨ nimanɨmɨ mupa ero iyɨ́á wúkaú raiwakɨyɨ́ mepa ero sɨkwɨ́ sú nɨyínɨro aiwɨ ámɨ waú mɨmeapa ero xoyɨ́wá nɨmaxɨrɨmɨ mupa ero éɨ́rɨxɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá arɨrá wiarɨgɨ́omɨ ananɨ aiwá mɨnɨ wiarɨŋagɨ́a nánɨ soyɨ́né enɨ aiwá ananɨ seaiapɨpɨ́rɨ́á eŋagɨ nánɨ amɨpí nɨmeámɨ mupa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aŋɨ́ xwé bimɨranɨ, onɨmiá bimɨranɨ, nɨrémorɨ́ná ámá aŋɨ́ apimɨ ŋweagɨ́áyɨ́ ámá go go ɨ́wɨ́ amɨpí mɨyarɨŋomɨ nɨwɨnɨrɨ́ná oyá aŋɨ́yo nɨpáwiro aŋɨ́ apimɨ pɨ́nɨ nɨwiárɨmɨ upɨ́rɨ́íná nánɨ o tɨ́nɨnɨ wéɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ámá ‘O tɨ́nɨ oweaneyɨ.’ yaiwíɨ́oyá aŋɨ́yo nɨpáwirɨ́ná ayo yayɨ́ nɨwiro ‘ “Gorɨxo píránɨŋɨ́ oseamenɨ.” neaimónarɨnɨ.’ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ayɨ́ enɨ yayɨ́ nɨseairo segɨ́ pɨ́né arɨ́á seaipɨ́rɨ nánɨ wimónánáyɨ́, soyɨ́né yayɨ́ nɨwirɨ́ná urɨ́ápɨ ananɨ ‘Xe oimónɨnɨ.’ yaiwíɨ́rɨxɨnɨ. Ayɨ́ e mɨseaipa seaíánáyɨ́, soyɨ́né yayɨ́ nɨwirɨ́ná urɨ́ápɨ ‘Anɨpá oimónɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ámá gɨyɨ́ gɨyɨ́ wigɨ́ aŋɨ́yo nánɨ nɨseaipemeámɨ mupa ero soyɨ́néyá xwɨyɨ́á arɨ́á mɨseaimónɨpa ero éánáyɨ́ aŋɨ́ iwámɨranɨ, aŋɨ́ apimɨranɨ, pɨ́nɨ nɨwiárɨmɨ nurɨ́ná ámá e ŋweagɨ́áyɨ́ ‘Gorɨxo xeanɨŋɨ́ neaikárɨnɨ́a nánɨ tiyɨ́ réoɨ?’ oyaiwípoyɨnɨrɨ segɨ́ sɨkwɨ́yo sikɨ́ xénɨŋɨ́pɨ pɨ́rɨ́ wiaíkímɨ́ nɨyárɨmɨ úɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nionɨ nepa seararɨŋɨnɨ, ‘Sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ ámá eŋíná aŋɨ́ yoɨ́ Sodomɨyo ŋweaagɨ́áyɨ́ tɨ́nɨ Gomora ŋweaagɨ́áyɨ́ tɨ́nɨ aga rɨkɨkɨrɨ́ó néra wagɨ́áyo Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ wikárɨnɨ́á eŋagɨ aiwɨ ámá soyɨ́né arɨ́á mɨseaíɨ́áyo xeanɨŋɨ́ ayo wikárɨnɨ́ápa axɨ́pɨ xɨxenɨ e wikárɨnɨ́ámanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nionɨ soyɨ́né sipɨsipɨ́ mɨxɨ́ xɨxe mepa yarɨŋɨ́nɨŋɨ́ imónɨgɨ́oyɨ́né ámá sɨ́wí sayɨ́nɨŋɨ́ imónɨgɨ́áyɨ́ tɨ́ŋɨ́ e nánɨ searowárarɨŋɨnɨ. Ayɨnánɨ soyɨ́né nuróná ámá ayɨ́ nánɨ sɨŋwɨ́ tɨ́nɨ úɨ́rɨxɨnɨ. Sidɨrɨ́ yarɨŋɨ́pa dɨŋɨ́ émɨ saímɨ́ moro iŋɨ́ xawiówɨ́ uyɨ́niɨ́ bɨ mé awayinɨ yarɨŋɨ́pa ero néra úɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Soyɨ́né nionɨ nɨxɨ́darɨŋagɨ́a nánɨ ámá wí ɨ́á nɨseaxero negɨ́ Judayɨ́ ámɨná xwɨrɨxɨ́ mearɨgɨ́áwa tɨ́ŋɨ́ e xwɨrɨxɨ́ seamepɨ́rɨ nánɨ seawárɨro negɨ́ rotú aŋɨ́yo dánɨ sɨkwɨ́á ragɨ́ punɨ nánɨ seaearo ");
INSERT INTO aak_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","soyɨ́né pɨ́né nionɨyá émáyɨ́ arɨ́á egɨ́e dánɨ áwaŋɨ́ urɨpɨ́rɨ nánɨ gapɨmanowa tɨ́nɨ mɨxɨ́ ináyowa tɨ́nɨ tɨ́ŋɨ́ e nɨseameámɨ nuro seawárɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","E seawárɨpɨ́rɨ́a aiwɨ rɨxa xwɨyɨ́á urɨpɨ́rɨ ínánɨnɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ urɨpɨ́rɨ eŋagɨ nánɨ ayá sɨ́wɨ́ nɨsearorɨ ‘Arɨre uranɨréwɨnɨ? Pí pí uranɨréwɨnɨ?’ mɨyaiwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Awa rɨxa xwɨrɨxɨ́ seamearɨ́ná segɨ́ dɨŋɨ́yo dánɨ urɨpɨ́rɨ́ámanɨ. Segɨ́ séno Gorɨxoyá kwíyɨ́pimɨ dánɨ urɨpɨ́rɨ́á eŋagɨ nánɨ ayá sɨ́wɨ́ mɨsearopa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Xɨráxogwáowaú wɨ́o Jisasomɨ xɨ́darɨŋagɨ nánɨ wɨ́o ámá wí omɨ opɨkípoyɨnɨrɨ mɨyɨ́ urɨrɨ xano xewaxo nánɨ mɨyɨ́ urɨrɨ niaíwɨ́yɨ́ xanɨyaú nánɨ mɨyɨ́ urɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Soyɨ́né nionɨ dɨŋɨ́ nɨnɨkwɨ́roro nɨxɨ́darɨŋagɨ́a nánɨ ámá nɨ́nɨ sɨ́mɨ́ tɨ́nɨ seaiapɨ́rɨ́a aiwɨ gɨyɨ́ gɨyɨ́ sɨ́á yoparɨ́pɨ nionɨ weapɨmɨ́áyi nánɨ eŋɨ́ neánɨro ŋweáɨ́áyɨ́né Gorɨxo ananɨ yeáyɨ́ nɨseayimɨxemeanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aŋɨ́ bimɨ nɨseapɨkianɨro nánɨ númɨ seaméánáyɨ́, ámɨ aŋɨ́ bimɨ nánɨ éɨ́ úɨ́rɨxɨnɨ. Nionɨ nepa seararɨŋɨnɨ, ‘Isɨrerɨyɨ́ aŋɨ́yo pɨ́né nionɨyá wíyo sɨnɨ murɨnɨŋáná ámá imónɨŋáonɨ weapɨmɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jisaso xegɨ́ wiepɨsarɨŋowa “Omɨ sɨpí wikárɨpɨ́rɨ́á eŋagɨ nánɨ none enɨ sɨpí neaikárɨpaxɨ́rɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Wiepɨsarɨŋowa wigɨ́ uréwapɨyarɨŋomɨ seáyɨ e imónarɨgɨ́ámanɨ. Xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áwa enɨ wigɨ́ omɨŋɨ́ wiiarɨgɨ́omɨ seáyɨ e wimónarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wiepɨsarɨŋowa wigɨ́ uréwapɨyarɨŋo tɨ́nɨ xɨxenɨ nimónɨrɨ́náyɨ́, ayɨ́ apánɨrɨnɨ. Xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áwa enɨ wigɨ́ omɨŋɨ́ wiiarɨgɨ́o tɨ́nɨ xɨxenɨ nimónɨrɨ́náyɨ́, ayɨ́ apánɨrɨnɨ. Sénonɨ ikayɨ́wɨ́ imɨ́óyo xɨráónɨŋɨ́ imónɨŋoyɨ nɨnɨrɨrónáyɨ́, gɨ́ niaíwoyɨ́né enɨ aŋɨpaxɨ́ searɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ámá ɨ́wɨ́ ínɨmɨ dánɨ éɨ́áyɨ́ranɨ, ikayɨ́wɨ́ yumɨ́í rɨ́áyɨ́ranɨ, rɨ́wéná nɨpɨnɨ sɨŋánɨ imónɨnɨ́á eŋagɨ nánɨ ayo wáyɨ́ mɨwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Xwɨyɨ́á amɨpí nionɨ ínɨmɨ dánɨ árɨ́wɨyíná searɨ́ápɨ soyɨ́né ikwáwɨyíná áwaŋɨ́ urɨ́ɨ́rɨxɨnɨ. Amɨpí nionɨ yumɨ́í ikaxɨ́ searɨ́ápɨ aŋɨ́ rɨkwɨ́yo nɨxeŋweámáná áwaŋɨ́ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ámá nɨseapɨkiróná waránɨ seapɨkipaxɨ́rɨnɨ. Dɨŋɨ́ enɨ seaxekwapaxɨ́ meŋagɨ nánɨ wáyɨ́ mɨwipa éɨ́rɨxɨnɨ. E nerɨ aí Gorɨxo wará aí tɨ́nɨ dɨŋɨ́ aí tɨ́nɨ rɨ́á anɨŋɨ́ wearɨŋɨ́yo seaikeaárɨpaxɨ́ imónɨŋo nánɨ wáyɨ́ wíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Ámá makerɨ́áyo nánɨ nurɨ́ná iŋɨ́ sirɨ́kwá waú bɨ́ nerɨ́ná nɨgwɨ́ rɨ́á nɨŋɨ́ bɨ tɨ́nɨ bɨ́ yarɨgɨ́árɨnɨ. E nerɨ aí segɨ́ séno mɨwimónɨpa nerɨ́náyɨ́, wo ananɨ nɨperɨ xwɨ́áyo piéroarɨŋɨ́manɨ. Soyɨ́né iŋɨ́ onɨmiápiamɨ múrónɨŋagɨ nánɨ Gorɨxo amɨpí wí mɨwímeapa oenɨrɨ sɨŋwɨ́ nɨseanɨrɨ́náyɨ́, wí nɨseaímeanɨ́á eŋagɨ ámá nánɨ wáyɨ́ mepanɨ. Segɨ́ mɨŋɨ́yo dɨ́á ɨ́á ropaxɨ́ mimónɨŋagɨ aí Gorɨxo nɨjɨ́á eŋagɨ nánɨ re yaiwíɨ́rɨxɨnɨ, ‘O nene nánɨ aga nɨjɨ́á imónɨŋagɨ nánɨ ananɨ píránɨŋɨ́ neamenɨgɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ámá gɨyɨ́ gɨyɨ́ ámáyá sɨŋwɨ́yo dánɨ ‘Jisasomɨ xɨ́darɨŋáonɨrɨnɨ.’ uránáyɨ́ nionɨ enɨ gɨ́ ápo aŋɨ́namɨ ŋweaŋoyá sɨŋwɨ́yo dánɨ ‘O nionɨ nɨxɨ́darɨŋorɨnɨ.’ urɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","E nerɨ aí gɨyɨ́ gɨyɨ́ nionɨ nánɨ ámáyá sɨŋwɨ́yo dánɨ ‘O nánɨ nionɨ majɨ́árɨnɨ.’ uránáyɨ́ nionɨ enɨ o nánɨ gɨ́ ápo aŋɨ́namɨ ŋweaŋoyá sɨŋwɨ́yo dánɨ ‘O nionɨ majɨ́árɨnɨ.’ urɨmɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","O ámɨ re urɨŋɨnigɨnɨ, “Nionɨ nánɨ ‘Ámá nɨyonɨ pɨyɨ́á wɨ́rɨmɨ́ánɨrɨ bɨŋorɨnɨ.’ mɨniaiwipanɨ. Gorɨxoyá xwɨyɨ́á kirá mɨxɨ́ nánɨ́nɨŋɨ́ imónɨŋɨ́pá nɨmeámɨ bɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Arɨ́á niarɨgɨ́áyɨ́ tɨ́nɨ arɨ́á mɨniarɨgɨ́áyɨ́ tɨ́nɨ Gorɨxoyá Bɨkwɨ́yo nɨrɨnɨrɨ eánɨŋɨ́pa xepɨxepá orónɨ́poyɨnɨrɨ nɨmeámɨ bɨŋárɨnɨ. Xewaxo xanomɨ sɨ́mɨ́ tɨ́nɨ wirɨ xemiáí xɨnáímɨ sɨ́mɨ́ tɨ́nɨ wirɨ xewaxo xiepí xiɨ́áímɨ sɨ́mɨ́ tɨ́nɨ wirɨ oinɨ́poyɨnɨrɨ bɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ámá xwɨyɨ́á nionɨyá nɨxɨ́darɨgɨ́áyɨ́ wigɨ́ ámá imónɨgɨ́áyɨ́ mɨxɨ́ wimónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ámá gɨyɨ́ gɨyɨ́ xanomɨranɨ, xɨnáímɨranɨ, dɨŋɨ́ sɨxɨ́ uyarɨŋɨ́pimɨ nionɨ nɨyinɨnɨ nánɨ mɨmúrónɨpa nerɨ́náyɨ́, ámá nionɨyá imónɨpaxɨ́ mimónɨnɨ. Gɨyɨ́ gɨyɨ́ xewaxomɨranɨ, xemiáímɨranɨ, dɨŋɨ́ sɨxɨ́ uyarɨŋɨ́pimɨ nionɨ nɨnɨyinɨnɨ nánɨ mɨmúrónɨpa nerɨ́náyɨ́, nionɨyá imónɨpaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Gɨyɨ́ gɨyɨ́ ‘Jisasomɨ ouxɨ́dɨmɨnɨ.’ nɨyaiwirɨ aí xeanɨŋɨ́ nɨniro nɨpɨkipɨ́rɨxɨnɨrɨ mɨnɨxɨ́dɨ́ éɨ́ éɨ́áyɨ́ ayɨ́ nionɨyá imónɨpaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ámá goxɨ goxɨ ‘Nionɨ Jisasomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ nuxɨ́dɨrɨ́náyɨ́, nɨpɨkipɨ́rɨxɨnɨ.’ nɨyaiwirɨ xewanɨŋoxɨ éɨ́ nɨmenɨrɨ́náyɨ́, dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́ámanɨ. E nerɨ aí gɨyɨ́ gɨyɨ́ éɨ́ mɨmenɨpa nerɨ ‘Nionɨ Jisasomɨ xɨ́darɨŋagɨ nánɨ ámá wí nɨnɨpɨkirónáyɨ́, ayɨ́ ananɨrɨnɨ.’ nɨyaiwirɨ́náyɨ́, dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","O ámɨ re urɨŋɨnigɨnɨ, “Gɨyɨ́ gɨyɨ́ soyɨ́né wáɨ́ urɨmearɨ́ná arɨ́á nɨseairo naŋɨ́ nɨseairónáyɨ́ nionɨ searowárarɨŋagɨ nánɨ nionɨ́nɨŋɨ́ niro Gorɨxo nɨrowárénapɨŋomɨ́nɨŋɨ́ enɨ wiro yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ámá gɨyɨ́ ámá wo Gorɨxoyá wɨ́á rókiamoarɨŋo eŋagɨ nánɨ ‘Ámá ro Gorɨxoyá wɨ́á rókiamoarɨŋorɨ́anɨ?’ nɨyaiwirɨ nipemeámɨ xegɨ́ aŋɨ́yo nánɨ úoyɨ́ rɨ́wéná Gorɨxo xegɨ́ wɨ́á rókiamoarɨgɨ́áyo yayɨ́ nɨwirɨ ayá rɨmɨxarɨŋɨ́pɨ mɨnɨ winɨ́ápa axɨ́pɨ e winɨ́árɨnɨ. Gɨyɨ́ ámá wo wé rónɨŋo eŋagɨ nánɨ ‘Ámá ro wé rónɨŋorɨ́anɨ?’ nɨyaiwirɨ nipemeámɨ úoyɨ́ rɨ́wéná Gorɨxo ámá wé rónɨgɨ́áyo yayɨ́ nɨwirɨ ayá rɨmɨxarɨŋɨ́pɨ mɨnɨ winɨ́ápa axɨ́pɨ e winɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ámá gɨyɨ́ gɨyɨ́ soyɨ́né nionɨyá seaiapɨsarɨŋáoyɨ́né eŋagɨ nánɨ iniɨgɨ́ imɨŋɨ́ rɨŋɨ́ kapɨxɨ́ wá seaiapánáyɨ́ Gorɨxo ‘Omɨ wíɨmɨgɨnɨ.’ yaiwíɨ́pɨ anɨpá imónɨnɨ́ámanɨ. Oweoɨ! Nionɨ nepa seararɨŋɨnɨ, ‘Gorɨxo mɨnɨ winɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisaso xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ sekaxɨ́ e nurɨ́ɨsáná uréwapɨyemerɨ wáɨ́ urɨmerɨ emɨnɨrɨ nánɨ e dánɨ pɨ́nɨ nɨwiárɨmɨ Judayɨ́ aŋɨ́ amɨ amɨ ikwɨ́rónɨŋɨ́yo nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jono wayɨ́ numeaia warɨŋo gwɨ́ nɨŋweámáná arɨ́á re wiŋɨnigɨnɨ, “Jisaso e yarɨnɨ. E yarɨnɨ.” rarɨŋagɨ́a arɨ́á nɨwirɨ xɨ́o xegɨ́ wiepɨsarɨŋɨ́yɨ́ waúmɨ Jisaso tɨ́ŋɨ́ e nánɨ urowáráná ");
INSERT INTO aak_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","awaú nuri yarɨŋɨ́ re wigɨ́isixɨnɨ, “Jono ‘Ámá wo rɨ́wɨ́yo bɨnɨ́árɨnɨ.’ rarɨŋoxɨranɨ? Wenɨŋɨ́ nerɨ ŋweaanɨ nánɨ wo sɨnɨ rɨ́a barɨnɨ?” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisaso re urɨŋɨnigɨnɨ, “Awagwí nuri amɨpí nionɨ yarɨ́ná sɨŋwɨ́ nanɨ́ípɨ tɨ́nɨ arɨ́á níɨ́ípɨ tɨ́nɨ nánɨ repɨyɨ́ nɨwiri áwaŋɨ́ urémeápiyɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nionɨ yarɨ́ná ámá sɨŋwɨ́ supárɨgɨ́áyɨ́ sɨŋwɨ́ oxoaro sɨkwɨ́ ikɨ́ egɨ́áyɨ́ naŋɨ́ nimónɨro aŋɨ́ ero peyɨyɨ́ tɨ́gɨ́áyɨ́ wará naŋɨ́ inɨro arɨ́á pɨ́rónɨgɨ́áyɨ́ arɨ́á ero péɨ́áyɨ́ wiápɨ́nɨmearo ámá uyípeayɨ́ xwɨyɨ́á yayɨ́ winɨpaxɨ́ none wáɨ́ nemerane urarɨŋwápɨ arɨ́á wiro yarɨŋagɨ́a nánɨ Jonomɨ áwaŋɨ́ e urémeápiyɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rɨpɨ enɨ ‘Nionɨ nánɨ ámá go go sɨ́mɨ́ tɨ́nɨ wikɨ́ dɨŋɨ́ “O pí rɨ́a yarɨnɨ?” mɨniaiwipa nerɨ́náyɨ́, yayɨ́ owinɨnɨ.’ urémeápiyɨ.” nurowárɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","awaú rɨxa gwɨ́ aŋɨ́ Jono ŋweaŋiwá tɨ́ŋɨ́ e nánɨ warɨ́ná ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo Jono nánɨ re urɨŋɨnigɨnɨ, “Seyɨ́né ámá dɨŋɨ́ meaŋe nánɨ nurɨ́ná pí ámáyo wɨnanɨro wagɨ́árɨnɨ? Ámá samɨŋɨ́ imɨŋɨ́ onɨmiápɨ nerɨ aí rɨ́wɨ́ ɨwɨ́ apaxɨ́ mé wiŋwɨ́ yarɨŋɨ́pa yarɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro wagɨ́áranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","E nerɨ aí pí ámáyo wɨnanɨro wagɨ́árɨnɨ? Ámá rapɨrapɨ́ yarapayɨ́ eŋɨ́ wú yínɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro ámá dɨŋɨ́ meaŋe wagɨ́áranɨ? Oweoɨ! Ámá rapɨrapɨ́ yarapayɨ́ naŋɨ́nɨ nɨyínɨro mɨxɨ́ ináyɨ́yɨ́yá aŋɨ́yo ŋweaarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","E nerɨ aí seyɨ́né pí nánɨ ámá dɨŋɨ́ meaŋe nánɨ wagɨ́árɨnɨ? Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro wagɨ́áranɨ? Oyɨ, e nerɨ aí ‘O Gorɨxoyá wɨ́á rókiamoagɨ́áyɨ́ tɨ́nɨ xɨxenɨ imónɨŋomanɨ. Seáyɨ e múroŋorɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Xwɨyɨ́á Gorɨxo xewaxomɨ urɨŋɨ́pɨ wɨ́á rókiamoagɨ́ Marakaio nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́ rɨpɨ, ‘Arɨ́á eɨ. Gorɨxonɨ gɨ́ xwɨyɨ́á yaŋɨ́ wiowárɨmɨ́áo joxɨ gɨ́ íwoxɨ xámɨ rɨmeanɨ nánɨ urowárɨmɨ́árɨnɨ. O joxɨ nánɨ ámáyo nurɨrɨ́ná óɨ́nɨŋɨ́ simoinɨ́árɨnɨ.’ nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ apɨ Jono nánɨ rɨnɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nepa seararɨŋɨnɨ, ‘Jono ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o nánɨ óɨ́nɨŋɨ́ imoŋo eŋagɨ nánɨ ámá nɨ́nɨ aiwɨ wo Jonomɨ seáyɨ e imónɨnɨ xɨrɨgɨ́ámanɨ. E nerɨ aiwɨ gɨyɨ́ gɨyɨ́ nionɨ nɨxɨ́dɨro Gorɨxoyá xwioxɨ́yo páwiro yarɨgɨ́áyɨ́ xwɨyɨ́á nionɨ nánɨ wáɨ́ nurɨmeipɨ́rɨ́pɨ Jono wáɨ́ urɨmeŋɨ́pimɨ seáyɨ e imónɨŋagɨ nánɨ ámá ayɨ́ onɨ́pɨ aiwɨ Jonomɨ enɨ seáyɨ e wimónɨŋoɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jono wayɨ́ nɨneameaia warɨŋo xwɨyɨ́á ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋweanɨ́a nánɨ ámá wo urowárénapɨnɨŋoɨ.’ iwamɨ́ó searɨŋíná dánɨ ámá uyɨ́niɨ́ yarɨgɨ́áyɨ́ ‘Gorɨxoyá xwioxɨ́yo arɨge páwianɨréwɨnɨ?’ nɨyaiwiro pɨ́rɨ́ ɨ́kwieámɨ́ néra páwianɨro yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ŋwɨ́ ikaxɨ́ Moseso nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́ápɨ tɨ́nɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨyɨ́ wɨ́á nɨrókiamóa nɨbɨro Jono yoparɨ́ o axɨ́pɨ rɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eŋíná wɨ́á rókiamoagɨ́áyɨ́ wo re rɨŋɨ́pɨ, ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ rɨxa nimónɨmɨnɨrɨ aŋwɨ e eŋánáyɨ́ ámá wo wɨ́á rókiamoagɨ́ Iraijaónɨŋɨ́ imónɨŋɨ́ wo bɨnɨ́árɨnɨ.’ rɨŋɨ́pɨ tɨ́nɨ xɨxenɨ Jono rɨxa bɨŋɨ́rɨnɨ. Seyɨ́né omɨ nɨmímɨnɨrɨ́náyɨ́, o Iraijao imónɨŋɨ́pa imónɨmɨnɨrɨ eŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Arɨ́á tɨ́gɨ́áyɨ́né píránɨŋɨ́ nionɨyá xwɨyɨ́ápɨ arɨ́á erɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“E nerɨ aí pí ewayɨ́ xwɨyɨ́á nɨsearɨrɨ re searɨmɨ́ɨnɨ, ‘Ámá agwɨ ríná ŋweagɨ́áyɨ́né ayɨ́nɨŋɨ́ imónɨŋoɨ.’ searɨmɨ́ɨnɨ? Seyɨ́né niaíwɨ́ rɨpiánɨŋɨ́ imónɨŋoɨ. Niaíwɨ́ bɨ́bia makerɨ́á tɨ́ŋɨ́ e éɨ́ nɨŋwearo bɨ́bia tɨ́nɨ niɨ́á yanɨro nerɨ́ná rɨ́aiwá re urarɨŋoɨ, ");
INSERT INTO aak_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nene seyɨ́né sɨmɨnɨŋɨ́ epɨ́rɨ nánɨ soŋɨ́ eaarɨ́ná seyɨ́né sɨmɨnɨŋɨ́ méoɨ. Nene seyɨ́né ŋwapé rɨpɨ́rɨ nánɨ ŋwapé ráná ŋwapé saŋɨ́ mɨnearápáoɨ.’ E urarɨ́ná niaíwɨ́ anɨŋɨ́ winarɨŋɨ́pia yapɨ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Jono nɨbɨrɨ́ná aiwá ámá wimónarɨŋɨ́pɨ tɨ́nɨ iniɨgɨ́ wainɨ́ tɨ́nɨ mɨnɨ́ ŋwɨ́á ŋweaŋáná ámá wí dɨŋɨ́ mamó o nánɨ ‘Imɨ́ó dɨŋɨ́ xɨxéroŋagɨ nánɨ yarɨnɨ.’ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ámá imónɨŋáonɨ nɨbɨrɨ́ná aiwá iniɨgɨ́ amɨpí ananɨ narɨ́ná ámá wí ‘Ámá royɨ́ aiwá tɨ́nɨ iniɨgɨ́ wainɨ́ tɨ́nɨ rɨwɨ́ eŋɨ́ nerɨ ayá wí narɨŋorɨnɨ. Ámá takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́áwa tɨ́nɨ ɨ́wɨ́ néra warɨgɨ́á wínɨyɨ́ tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨgɨ́orɨnɨ.’ rarɨgɨ́árɨnɨ. Agwɨ e nɨrɨro aí idáná nionɨ yarɨŋápɨ tɨ́nɨ Jono yarɨŋɨ́pɨ tɨ́nɨ aiwánɨŋɨ́ ná wéánáyɨ́ re rɨpɨ́rɨ́árɨnɨ, ‘Ámá imónɨŋo tɨ́nɨ Jono tɨ́nɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ naŋɨ́ yagɨ́írɨnɨ.’ rɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisaso e nurɨ́ɨsáná ámá e epɨ́royɨ́ egɨ́áyo nurɨrɨ́ná aŋɨ́ o emɨmɨ́ obaxɨ́ wíwapɨyiŋɨ́pɨ yoɨ́ nɨrɨrɨ ámá ayo ŋweagɨ́áyɨ́ wigɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro mɨŋweá éagɨ́a mɨxɨ́ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","re urɨŋɨnigɨnɨ, “Korasinɨyo ŋweáyɨ́né aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨnɨ. Betɨsaida ŋweáyɨ́né aweyɨ! Sɨ́á wɨyi seyɨ́né enɨ majɨ́á seaórɨnɨ́árɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Emɨmɨ́ segɨ́ aŋɨ́yo seaíwapɨyiŋápɨ émáyɨ́ aŋɨ́ yoɨ́ Taiayɨ rɨnɨŋɨ́yo tɨ́nɨ Saidonɨyɨ rɨnɨŋɨ́yo tɨ́nɨ nɨwíwapɨyirɨ sɨŋwɨrɨyɨ́, ámá aŋɨ́ apiaúmɨ ŋweáyɨ́ eŋíná wigɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ nánɨ piaxɨ́ nɨweánɨro ayá ɨ́á nɨxɨrɨnɨro nánɨ iyɨ́á írɨkwɨ́ pánɨro rɨ́á uráwɨ́yo iwieánɨro yanɨrɨ egɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nepa seararɨŋɨnɨ. Sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ ámá Taia ŋweáyo tɨ́nɨ Saidonɨ ŋweáyo tɨ́nɨ winɨ́ápa axɨ́pɨ seainɨ́ámanɨ. Seyɨ́néyá seáyɨ e imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaneamɨ ŋweáyɨ́né enɨ ‘Gorɨxo aŋɨ́namɨ nánɨ nɨneaménapɨnɨ́árɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ! Rɨ́á anɨŋɨ́ wearɨŋɨ́yo nánɨ wepɨ́rɨ́árɨnɨ. Emɨmɨ́ nionɨ segɨ́ aŋɨ́ e seaíwapɨyiŋápɨ eŋíná Sodomɨ ŋweáyɨ́, rɨkɨkɨrɨ́ó yarɨŋagɨ́a Gorɨxo rɨ́á mamówárɨŋɨ́yɨ́ sɨŋwɨ́ nɨnanɨro sɨŋwɨrɨyɨ́, ayɨ́ nɨsanɨro agwɨ ŋweaŋwá re nánɨ nɨŋweaxa banɨro egɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nepa seararɨŋɨnɨ. Sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ Sodomɨ ŋweaagɨ́áyo winɨ́ápa xɨxenɨ axɨ́pɨ seainɨ́ámanɨ. Seyɨ́néyá seáyɨ e imónɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jisaso e nurɨmáná Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná re urɨŋɨnigɨnɨ, “Gɨ́ ápoxɨnɨ, Ámɨná aŋɨ́na imɨxɨrɨ xwɨ́á imɨxɨrɨ nerɨ tɨŋoxɨnɨ, xwɨyɨ́á nionɨ urarɨŋá rɨpɨ nánɨ ámá ‘Nionɨ nɨjɨ́onɨrɨnɨ. Go nɨréwapɨyinɨŋoɨ?’ yaiwinarɨgɨ́áyo yimárorɨ ámá niaíwɨ́ onɨmiápia yapɨ ‘Anɨŋɨ́ onɨréwapɨyípoyɨ.’ yaiwinarɨgɨ́áyo wɨ́á urókiamorɨ éagɨ nánɨ yayɨ́ seáyɨmɨ dánɨ orɨmemɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ápoxɨnɨ, joxɨ e simónarɨŋagɨ nánɨ dɨxɨ́ dɨŋɨ́ tɨ́nɨ e imónɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ámáyo re urɨŋɨnigɨnɨ, “Gɨ́ ápo xwɨyɨ́á amɨpí oyá nɨpɨnɨ bɨ yumɨ́í mɨní nɨpɨnɨ ɨ́ánɨŋɨ́ niepɨ́xɨ́niasiŋɨ́rɨnɨ. Ámá nɨ́nɨ aiwɨ wo xegɨ́ dɨŋɨ́ tɨ́nɨ xewaxonɨ nánɨ nɨjɨ́á mimónɨnɨ. Gɨ́ áponɨ nɨjɨ́á imónɨnɨ. Ámá wo xegɨ́ dɨŋɨ́ tɨ́nɨ gɨ́ ápo nánɨ enɨ nɨjɨ́á mimónɨnɨ. Xewaxonɨnɨ nɨjɨ́á imónɨŋɨnɨ. E nerɨ aí ámá xewaxonɨ ‘Gɨ́ ápo nánɨ xe nɨjɨ́á oimónɨ́poyɨ.’ nɨyaiwirɨ o nánɨ wɨ́á wókímɨxarɨŋáyɨ́ ayɨ́ enɨ gɨ́ ápo nánɨ nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ayɨnánɨ sekaxɨ́ ‘Rɨpɨ époyɨ. Rɨpɨ époyɨ.’ nɨrɨga uŋɨ́pɨ píránɨŋɨ́ ouxɨ́dɨmɨnɨrɨ nerɨ́ná saŋɨ́ xwé nɨmearɨ́nɨŋɨ́ nɨmeámɨ nuro anɨŋɨ́ seainarɨŋɨ́yɨ́né, nionɨyá dɨŋɨ́ tɨ́nɨ sá ŋweapɨ́rɨ nánɨ nionɨ tɨ́ámɨnɨ bɨ́poyɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nionɨ ámá nɨpenionɨ nimónɨrɨ seáyɨ e mimónarɨŋáonɨ eŋagɨ nánɨ saŋɨ́ nionɨyá íkɨ́ánɨŋɨ́ xwaŋwɨ́ níkwónɨmɨ nurɨ́náyɨ́ nionɨ searéwapɨyíáná segɨ́ dɨŋɨ́ emɨmówárɨ́ inɨpɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Xwɨyɨ́á nionɨyá saŋɨ́nɨŋɨ́ nɨmeámɨ upɨ́rɨ́pɨ ayɨ́ saŋɨ́ seainɨmenɨŋoɨ. Nayɨ́ seainɨ́ eŋagɨ nánɨ ananɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Íná Sabarɨ́á wɨyimɨ Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ óɨ́ witɨ́ omɨŋɨ́ áwɨnɨmɨ inɨŋɨ́yo nuróná wiepɨsarɨŋowa agwɨ́ wíagɨ witɨ́ siyɨ́ sɨŋɨ́ yɨyírɨnɨ́ yarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisiowa sɨŋwɨ́ e nɨwɨnɨro omɨ re urɨgɨ́awixɨnɨ, “Dɨxɨ́ wiepɨsarɨŋowa ‘Sabarɨ́áyo ŋwɨ́árɨnɨ.’ rɨnɨŋɨ́yo aiwá pí nánɨ miarɨŋoɨ?” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisaso re urɨŋɨnigɨnɨ, “Eŋíná negɨ́ mɨxɨ́ ináyɨ́ Depito tɨ́nɨ xegɨ́ nɨkumɨxɨnɨrɨ emearɨgɨ́áwa tɨ́nɨ agwɨ́ wíáná egɨ́ápɨ Gorɨxoyá Bɨkwɨ́yo rɨ́wamɨŋɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ sɨnɨ ɨ́á mɨroarɨŋɨ́ reŋoɨ? Oweoɨ, soyɨ́né ɨ́á nɨroro aiwɨ dɨŋɨ́ nɨpɨkwɨnɨ mɨmoarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Depito senɨ́á aŋɨ́ Gorɨxo nánɨ aiwá peaxɨ́ tarɨgɨ́iwámɨ nɨpáwirɨ bisɨ́kerɨ́á Gorɨxo nánɨ peaxɨ́ tarɨgɨ́ápɨ o tɨ́nɨ xegɨ́ ámá tɨ́nɨ nánɨ ‘Ŋwɨ́árɨnɨ.’ rɨnɨŋɨ́pɨ —Apɨ ‘Sa apaxɨ́pánɨŋɨ́ imónɨgɨ́áwanɨ ananɨ nɨpaxɨ́rɨnɨ.’ rɨnɨŋɨ́pɨrɨnɨ. Bisɨ́kerɨ́á apɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ xwéo umeaíáná Depito nurápɨrɨ nɨ́agɨ aiwɨ Gorɨxo mɨxɨ́ bɨ murɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo dánɨ re rɨnɨŋɨ́pɨ enɨ sɨnɨ ɨ́á mɨroarɨŋɨ́ reŋoɨ, ‘Sabarɨ́áyo apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwiro rɨdɨyowá neróná sɨ́á “Omɨŋɨ́ nɨ́nɨ ŋwɨ́áxɨnɨ.” rɨnɨŋɨ́yi xórórɨ́ nero aiwɨ xwɨyɨ́á meárɨnarɨgɨ́ámanɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ ɨ́á mɨroarɨŋɨ́ reŋoɨ? Soyɨ́né ɨ́á nɨroro aiwɨ sɨnɨ nɨpɨkwɨnɨ dɨŋɨ́ mɨmoarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa Sabarɨ́á ayimɨ xórórɨ́ nero aiwɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ nero nánɨ xwɨyɨ́á mɨmeárɨnɨpa yarɨgɨ́árɨnɨ. E nerɨ aiwɨ ámá wo re roŋɨ́ royɨ́ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ seáyɨ e múronɨ.” xewanɨŋo nánɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ámɨ re urɨŋɨnigɨnɨ, “Soyɨ́né xwɨyɨ́á Gorɨxo rɨŋɨ́, Bɨkwɨ́yo eánɨŋɨ́ rɨpɨ ‘Nionɨ ámá wí wíyo wá nɨwianɨrɨ arɨrá owípoyɨnɨrɨ nánɨ nimónarɨnɨ. Nionɨ nánɨ rɨdɨyowánɨ onípoyɨnɨrɨ nánɨ mɨnimónarɨnɨnɨ.’ rɨ́wamɨŋɨ́ e nɨrɨnɨrɨ eánɨŋɨ́ apɨ nánɨ soyɨ́né dɨŋɨ́ nɨmoro ɨ́á nɨxɨrɨro sɨŋwɨrɨyɨ́, ámá nionɨyá rowamɨ, wiwanɨŋowa xwɨyɨ́á meárɨnɨpaxɨ́ mimónɨgɨ́á rowamɨ xwɨyɨ́á uxekwɨ́moanɨro éɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ámá imónɨŋáonɨ Sabarɨ́á xiáwonɨ eŋagɨ nánɨ ‘Sabarɨ́áyo ayɨ́ ananɨrɨnɨ.’ rɨpaxɨ́ imónɨŋáonɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","O e dánɨ pɨ́nɨ nɨwiárɨmɨ nurɨ wigɨ́ rotú aŋɨ́ wiwámɨ nɨpáwirɨ ŋweaŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ámá wé kɨrɨŋɨ́ eŋɨ́ wo e ŋweaŋagɨ Parisiowa Jisasomɨ xwɨyɨ́á meárɨpɨ́rɨ nánɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “‘Negɨ́ “Sabarɨ́áyo ŋwɨ́áxɨnɨ.” rɨnɨŋɨ́yo ámá sɨmɨxɨ́yo naŋɨ́ nimɨxɨrɨ́ná xórórɨ́ mepaxɨ́rɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","o xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Soyɨ́né woxɨ, sipɨsipɨ́ wo tɨ́ŋoxɨ Sabarɨ́áyo sipɨsipo xwárɨŋwɨ́yo piéróánáyɨ́, sipɨsipomɨ mɨmɨxeaarɨŋɨ́ranɨ? Oweoɨ, apaxɨ́ mé mɨxeaarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ámá sipɨsipɨ́ tɨ́nɨ xɨxenɨ mimónɨŋagɨ nánɨ Sabarɨ́áyo aí ámáyo naŋɨ́ nɨwimɨxɨrɨ́náyɨ́, ayɨ́ ananɨrɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","wé kɨrɨŋɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ wé irú pɨ́mɨxeɨ.” urɨ́agɨ ámáo wé irú pɨ́mɨxáná wé naŋɨ́ wɨ́únɨŋɨ́ axɨ́pɨ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naŋɨ́ wɨ́únɨŋɨ́ axɨ́pɨ imónɨ́agɨ Parisiowa nɨwiápɨ́nɨmeámɨ nɨpeyearo wáɨ́ e dánɨ omɨ pɨkianɨro nánɨ mekaxɨ́ megɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisaso Parisiowa xɨ́o nánɨ mekaxɨ́ mearɨŋagɨ́a nánɨ nɨjɨ́á nimónɨrɨ nánɨ e pɨ́nɨ nɨwiárɨmɨ nurɨ oxɨ́ apɨxɨ́ obaxɨ́ númɨ xɨ́darɨŋagɨ́a sɨmɨxɨ́ egɨ́á nɨyonɨ naŋɨ́ imɨmɨxɨmɨ́ nerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ámáyo áwaŋɨ́ urɨpɨ́rɨxɨnɨrɨ “Nionɨ siíápɨ nánɨ áwaŋɨ́ murɨmepa époyɨ.” urayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Xwɨyɨ́á Gorɨxo rɨŋɨ́ wɨ́á rókiamoagɨ́ Aisaiao nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ rɨpɨ xɨxenɨ imónɨnɨ́a nánɨ Jisaso e eŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Arɨ́á époyɨ. Ámá ro gɨ́ omɨŋɨ́ niiarɨŋónɨŋɨ́ imónɨnɨ́a nánɨ rɨ́peaŋáorɨnɨ. Gɨ́ dɨŋɨ́ sɨxɨ́ uyiŋáorɨnɨ. Gɨ́ kwíyɨ́ enɨ omɨ wíáná émáyɨ́ ‘E nerɨ́ná wé rónɨŋɨ́ Gorɨxo wimónarɨŋɨ́pɨ imónanɨ́wárɨ́anɨ?’ yaiwipɨ́rɨ nánɨ wáɨ́ urepeárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O nɨpeniorɨnɨ. Ámá wí tɨ́nɨ xɨxewiámɨ́ nɨrɨnɨrɨ wíyo xwamiánɨ́ nɨwirɨ enɨ́ámanɨ. Sɨ́mɨ́ óɨ́yo dánɨ xwamiánɨ́ yarɨŋagɨ wɨnɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O ámá eŋɨ́ samɨŋɨ́ nɨwémɨ emearɨŋagɨ nɨwɨnɨrɨ́ná sɨxɨ́ mɨŋɨ́ eaaroarɨŋɨ́wánɨŋɨ́ imónɨŋagɨ nɨwɨnɨrɨ́ná wíyo ɨ́á wekɨmɨxɨnɨ́ámanɨ. O ámá wí ramɨxɨ́ gwɨ́ ápiáwɨ́ wearɨŋɨ́rí rɨxa nɨyupárɨmɨnɨrɨ yarɨŋɨ́nɨŋɨ́ imónɨŋagɨ nɨwɨnɨrɨ́ná ɨ́á supɨmɨxɨnɨ́ámanɨ. Xegɨ́ e enɨ́ápa arɨ́kí néra núɨsáná wé rónɨŋɨ́ xɨ́o yarɨŋɨ́pɨ seáyɨ e imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Émáyɨ́ ‘O arɨrá neaíwɨnɨgɨnɨ.’ nɨyaiwiro omɨ dɨŋɨ́ ukɨkayopɨ́rɨ́árɨnɨ.” Xwɨyɨ́á Gorɨxo e rɨŋɨ́pɨ xɨxenɨ imónɨnɨ́a nánɨ Jisaso nemerɨ́ná axɨ́pɨ e eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ámá womɨ imɨ́ó dɨŋɨ́ xɨxéroŋáná maŋɨ́ pɨ́rónɨrɨ sɨŋwɨ́ supárɨrɨ eŋomɨ Jisaso tɨ́ŋɨ́ e nánɨ nɨméra nɨbɨro wáráná Jisaso imɨ́ó mɨxɨ́ numáɨnowárɨrɨ píránɨŋɨ́ wimɨxáná o xwɨyɨ́á rɨrɨ sɨŋwɨ́ anɨrɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","E éáná oxɨ́ apɨxɨ́ obaxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ ududɨ́ niga nuro re rɨnɨgɨ́awixɨnɨ, “‘Ámá royɨ́ ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo, negɨ́ mɨxɨ́ ináyɨ́ Depitoyá xiáworɨnɨ.’ rɨyaiwiarɨŋwɨnɨ? Oweoɨ, omanɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisiowa arɨ́á e nɨwiro re rɨgɨ́awixɨnɨ, “O imɨ́ó xɨráónɨŋɨ́ imónɨŋo —O xegɨ́ yoɨ́ bɨ Bieseburoyɨ rɨnɨŋorɨnɨ. Oyá dɨŋɨ́yo dánɨ Jisaso imɨ́ó mɨxɨ́ umáɨnarɨŋorɨnɨ.” rarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisaso awa e rɨnarɨŋagɨ́a dɨŋɨ́ adadɨ́ nɨwirɨ nɨjɨ́á nimónɨrɨ xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ámá gwɨ́ axɨ́rí xepɨxepá nɨrónɨro mɨxɨ́ ninɨrónáyɨ́ ayɨ́ aŋɨ́ mɨwiárekɨxɨnɨpaxɨ́rɨnɨ. Ámá aŋɨ́ bimɨ ŋweáyɨ́ranɨ, aŋɨ́ wiwámɨ ŋweagɨ́áyɨ́ranɨ, enɨ xepɨxepá nɨrónɨro mɨxɨ́ ninɨrónáyɨ́, axɨ́pɨ aŋɨ́ mɨwiárekɨxɨnɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nionɨ Obo —Oyá yoɨ́ bɨ Setenoyɨ rɨnɨŋorɨnɨ. Nionɨ oyá dɨŋɨ́yo dánɨ xegɨ́ imɨ́óyo mɨxɨ́ numáɨnowárɨrɨ́náyɨ́, axɨ́yɨ́ rɨxa xepɨxepá nɨrónɨro nánɨ arɨge nero eŋɨ́ neánɨro ropɨ́ráoɨ? Oweoɨ. E nero aiwɨ soyɨ́né nionɨ nánɨ re rarɨŋoɨ, ‘Setenoyá eŋɨ́ eánɨŋɨ́yo dánɨ imɨ́ó mɨxɨ́ umáɨnowárarɨnɨ.’ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nionɨ imɨ́ó xɨráónɨŋɨ́ imónɨŋo, Bieseburoyá dɨŋɨ́yo dánɨ imɨ́ó mɨxɨ́ numáɨnowárɨrɨ́náyɨ́, segɨ́ wiepɨsarɨgɨ́áyɨ́ dɨŋɨ́ goyáyo dánɨ mɨxɨ́ umáɨnowárarɨgɨ́árɨnɨ? Ayɨ́ awa re rarɨgɨ́árɨnɨ, ‘Gorɨxoyá dɨŋɨ́yo dánɨ mɨxɨ́ umáɨnowárarɨŋwárɨnɨ.’ rarɨgɨ́áyɨ́ nánɨ awa xwɨyɨ́á seamearɨpɨ́rɨ́árɨnɨ. Nionɨ segɨ́ wa yarɨgɨ́ápa yarɨŋagɨ aiwɨ soyɨ́né pí nánɨ nɨxekwɨ́moarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","E nerɨ aí nionɨ kwíyɨ́ Gorɨxoyápɨ tɨ́nɨ imɨ́ó mɨxɨ́ umáɨnánáyɨ́, dɨŋɨ́ re yaiwirɨ́ɨnɨ, ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ rɨxa írɨ́anɨ?’ yaiwirɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Obo eŋɨ́ eánɨŋo aiwɨ Jisaso seáyɨ e imónɨŋorɨnɨ.” oyaiwípoyɨnɨrɨ ámɨ xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ámá wo eŋɨ́ eánɨŋɨ́ woyá amɨpí ɨ́wɨ́ meámɨnɨrɨ́ná xámɨ xɨ́omɨ ɨ́á nɨxɨrɨrɨ gwɨ́ nɨjárɨmáná ananɨ nɨpáwirɨ xegɨ́ amɨpí meanɨgɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ámá nɨ́nɨ Jisasomɨ dɨŋɨ́ wɨkwɨ́roro xɨ́dɨro epɨ́rɨxɨnɨrɨ pɨ́rɨ́ rakiámɨ́ wianɨro yarɨgɨ́áyɨ́ nánɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá nionɨ tɨ́ámɨnɨ mimónɨgɨ́áyɨ́, ayɨ́ nionɨ tɨ́nɨ mɨxɨ́ imónɨŋwáyɨ́rɨnɨ. Ámá nionɨ tɨ́nɨ sipɨsipɨ́ awí meaárɨpa yarɨgɨ́áyɨ́ sipɨsipɨ́ xɨ́dɨ́xɨ́dowárɨ́ yarɨgɨ́áyɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","re urɨŋɨnigɨnɨ, “Ayɨnánɨ nionɨ re seararɨŋɨnɨ, ‘Pí pí ɨ́wɨ́ yarɨgɨ́á tɨ́nɨ ámá wíyo pí pí rɨperɨrɨ́ umeararɨgɨ́á tɨ́nɨ Gorɨxo ananɨ yokwarɨmɨ́ nɨwiirɨ aiwɨ ámá gɨyɨ́ ámá wo Gorɨxoyá kwíyɨ́ tɨ́nɨ yarɨŋagɨ nɨwɨnɨrɨ́ná rɨperɨrɨ́ numerɨ “Ayɨ́ kwíyɨ́ Gorɨxoyápɨ tɨ́nɨ mɨyarɨnɨnɨ.” umearɨ́áyo Gorɨxo yokwarɨmɨ́ wiipaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ámá gɨyɨ́ gɨyɨ́ ámá imónɨŋáonɨ pɨ́né sɨpí nɨnɨrɨrɨ aiwɨ Gorɨxo ananɨ yokwarɨmɨ́ wiinɨ́árɨnɨ. E nerɨ aiwɨ gɨyɨ́ gɨyɨ́ Gorɨxoyá kwíyɨ́ nánɨ pɨ́né sɨpí rɨ́áyɨ́ agwɨ rínáranɨ, ná rɨ́wɨ́yoranɨ, Gorɨxo yokwarɨmɨ́ wiinɨ́á menɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Awa “Jisaso naŋɨ́nɨ yarɨŋagɨ nánɨ ‘Oboyá dɨŋɨ́yo dánɨ yarɨnɨ.’ rɨpaxɨ́ mimónɨnɨ.” oyaiwípoyɨnɨrɨ ámɨ xewanɨŋo nánɨ ewayɨ́ ikaxɨ́ rɨpɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né íkɨ́á wɨna sogwɨ́ naŋɨ́ weŋagɨ nɨwɨnɨrɨ́ná ‘Íkɨ́á naŋɨ́narɨnɨ.’ rɨrɨ́ɨnɨ. Íkɨ́á wɨna sogwɨ́ sɨpí weŋagɨ nɨwɨnɨrɨ́ná ‘Íkɨ́á rɨna sɨpínarɨnɨ.’ rɨrɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","mɨxɨ́ re urɨŋɨnigɨnɨ, “Weaxɨ́á miáoyɨ́né, rɨxa sɨpínɨ imónɨŋagɨ́a nánɨ arɨge nero pɨ́né naŋɨ́ rɨpɨ́ráoɨ? Oweoɨ, ámá pí pí dɨŋɨ́ aumaúmɨ́ inɨgɨ́áyɨ́ e dánɨ rarɨgɨ́á eŋagɨ nánɨ soyɨ́né pɨ́né naŋɨ́ wí rɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ámá naŋɨ́yɨ́ wigɨ́ ayá tɨ́ŋɨ́pɨ mearɨgɨ́ápa dɨŋɨ́ naŋɨ́nɨ aumaúmɨ́ ninɨro nánɨ xwɨyɨ́á nɨrɨrɨ́ná naŋɨ́nɨ rarɨgɨ́árɨnɨ. Ámá sɨpíyɨ́ sɨpí nánɨnɨ dɨŋɨ́ nɨmoro aumaúmɨ́ ninɨro nánɨ xwɨyɨ́á nɨrɨrɨ́ná sɨpínɨ rarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nionɨ re seararɨŋɨnɨ, ‘Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ nerɨ xwɨrɨxɨ́ nɨmerɨ́ná sɨpí ikaxɨ́ amɨpí úrapí rarɨgɨ́á nɨ́nɨ nánɨ yarɨŋɨ́ imɨmɨ́ wiarɨ́ná e dánɨ urɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gorɨxo sewanɨŋoyɨ́né rarɨgɨ́áyo dánɨ xwɨrɨxɨ́ nɨseamerɨ re searɨnɨ́árɨnɨ, “Xwɨyɨ́á tɨ́ŋoxɨrɨnɨ. Xwɨyɨ́á mayoxɨrɨnɨ.” searɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E urɨ́agɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa tɨ́nɨ Parisi wa tɨ́nɨ re urɨgɨ́awixɨnɨ, “‘None “Gorɨxo rɨrowárénapɨŋoxɨrɨ́anɨ?” yaiwianɨ nánɨ aŋɨ́namɨ dáŋɨ́ ekɨyiŋɨ́ bɨ neaíwapɨyiɨ.’ neaimónarɨnɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","o re urɨŋɨnigɨnɨ, “Seyɨ́né agwɨ ríná ŋweagɨ́áyɨ́né, Gorɨxomɨ rɨ́wɨ́mɨnɨ nɨmamoro segɨ́ ŋwɨ́áɨ rɨnɨŋɨ́pɨ tɨ́nɨ ɨ́wɨ́nɨŋɨ́ niga uro niga bɨro yarɨgɨ́áyɨ́né ekɨyiŋɨ́ nánɨ reaxɨ́ nɨseainɨrɨ seaimónarɨŋagɨ aiwɨ ekɨyiŋɨ́ wɨ́á rókiamoagɨ́ Jonao eŋɨ́pɨnɨ seaíwapɨyimɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","O peyɨ́ xwé womɨ agwɨ́yo ínɨmɨ ínɨŋáná sɨ́á wɨyaú wɨyi órɨŋɨ́pa ámá imónɨŋáonɨ xwɨ́áyo ínɨmɨ weŋáná sɨ́á wɨyaú wɨyi nórɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ámá eŋíná aŋɨ́ yoɨ́ Ninipayɨ rɨnɨŋɨ́yo ŋweagɨ́áyɨ́ —Ayɨ́ Gorɨxoyá wɨ́á rókiamoagɨ́ Jonao Gorɨxoyá xwɨyɨ́á wáɨ́ urɨméáná ayɨ́ wigɨ́ ɨ́wɨ́ egɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweagɨ́áyɨ́rɨnɨ. Ayɨ́ ámá wonɨ Jonaomɨ seáyɨ e imónɨŋáonɨ re éɨ́ nɨrómáná seararɨŋagɨ aiwɨ seyɨ́né arɨ́á mɨniarɨŋagɨ́a nánɨ ámá Ninipayɨ ŋweaagɨ́áyɨ́ sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ nɨwiápɨ́nɨmearo xwɨyɨ́á seameárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ apɨxɨ́ eŋíná Sibayɨ́ aŋɨ́yo meŋweaŋí —Í mɨxɨ́ ináyɨ́ Soromono nɨjɨ́á seáyɨ e nimónɨrɨ rɨrɨmɨ́ yarɨ́ná arɨ́á wimɨnɨrɨ nánɨ aŋɨ́ aga ná jɨ́amɨ dánɨ bɨŋírɨnɨ. Í ámá wonɨ Soromonomɨ seáyɨ e imónɨŋáonɨ re éɨ́ nɨrómáná seararɨŋagɨ aiwɨ seyɨ́né arɨ́á mɨniarɨŋagɨ́a nánɨ í sɨ́á ayimɨ nɨwiápɨ́nɨmearɨ xwɨyɨ́á seameárɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ámá ayɨ́ “Nene Jono nearáná sanɨŋɨ́ onɨmiápɨ nerane aiwɨ imɨ́ó xɨxéroarɨŋɨ́ rónɨŋɨ́ imónanɨgɨnɨ.” oyaiwípoyɨnɨrɨ ámɨ xɨxewisɨ́ ikaxɨ́ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Imɨ́ó xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowáráná ámá womɨ pɨ́nɨ nɨwiárɨmɨ nurɨ́ná iniɨgɨ́ mayɨ́mɨ ‘Ge ge sá oŋweámɨnɨ?’ nɨyaiwia nemerɨ pɨ́á nɨmegɨnɨméɨsáná ");
INSERT INTO aak_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","re yaiwiarɨŋɨ́rɨnɨ, ‘Gɨ́ ámɨ aŋɨ́ axɨ́ pɨ́nɨ nɨwiárɨmɨ bɨŋaé nánɨ oumɨnɨ.’ nɨyaiwimɨ nurɨ aŋɨ́ rɨxa síɨ́ peárɨnɨrɨ píránɨŋɨ́ imɨxárɨnɨrɨ yárɨnɨŋagɨ nɨwɨnɨrɨ sɨnɨ anɨ́á imónɨŋagɨ nɨwɨnɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ámɨ nurɨ imɨ́ó wé wɨ́úmɨ dáŋɨ́ waú ɨ́wɨ́ neróná xɨ́omɨ seáyɨ e múroro egɨ́áyo nɨwirɨmeámɨ nuro axomɨ nɨxɨxéroro e ŋweaarɨgɨ́árɨnɨ. Xámɨ sɨpí imónago aí ínáyɨ́ aga sɨpí ikeamónɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisaso sɨnɨ ámá xɨ́o tɨ́ŋɨ́ e epɨ́royɨ́ egɨ́áyo xwɨyɨ́á urarɨ́ná re eŋɨnigɨnɨ. Xɨnáí tɨ́nɨ xogwáowa tɨ́nɨ nɨbɨro “Omɨ ge dánɨ xwɨyɨ́á uranɨréwɨnɨ?” nɨyaiwiro bɨ́anɨrɨwámɨnɨ roŋáná ");
INSERT INTO aak_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ámá wo re urɨŋɨnigɨnɨ, “Ai, dɨxɨ́ rɨnáí tɨ́nɨ rɨgwáowa tɨ́nɨ joxɨ xwɨyɨ́á rɨranɨro nánɨ wáɨ́ e bɨraiyɨ́ roŋoɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","o re urɨŋɨnigɨnɨ, “Ayɨ́ neparɨnɨ. Gɨ́ inókí tɨ́nɨ gwɨ́áowa tɨ́nɨ wáɨ́ e nɨroro aiwɨ ámá aga gɨ́ inókíwa gwɨ́áowa imónɨgɨ́áyɨ́ ayɨ́ gɨyɨ́rɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","xegɨ́ wiepɨsarɨŋɨ́yo wé árɨxá nɨwirɨ ámá omɨ re urɨŋɨnigɨnɨ, “Gɨ́ inókíwa gwɨ́áowánɨŋɨ́ imónɨgɨ́áyɨ́ ámá tɨ́ ŋweagɨ́áyɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá gɨyɨ́ gɨyɨ́ gɨ́ ápo aŋɨ́namɨ ŋweaŋo wimónarɨŋɨ́pɨ yarɨgɨ́áyɨ́ ayɨ́ gɨ́ gwɨ́áowa napíwa inókíwánɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jisaso sɨ́á ayimɨ aŋɨ́yo pɨ́nɨ nɨwiárɨmɨ nɨpeyearɨ ipí maŋɨ́pá tɨ́nɨ éɨ́ nɨŋwearɨ ");
INSERT INTO aak_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ámá oxɨ́ apɨxɨ́ ayá wí epɨ́royɨ́ wiarɨŋagɨ́a nánɨ ewé bámɨ nɨpɨxemoánɨrɨ éɨ́ nɨŋwearɨ oxɨ́ apɨxɨ́ nɨ́nɨ sɨnɨ ipí imaŋɨ́pá tɨ́nɨ roŋáná ");
INSERT INTO aak_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ewayɨ́ xwɨyɨ́á ayá wí nura nurɨ́ná re urɨŋɨnigɨnɨ, “Ámá wo (Nene ayé siyɨ́ nɨwiáróa nurɨ́ná yarɨŋwápa) o xegɨ́ omɨŋɨ́yo witɨ́ siyɨ́ nɨwiáróa umɨnɨrɨ nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","rɨxa xwɨ́á yunɨ́ ikɨxeárɨnɨŋe píránɨŋɨ́ nɨwiárorɨ aí wí óɨ́ maŋɨ́pá tɨ́nɨ piéróɨ́yɨ́ iŋɨ́ nɨbɨrɨ mɨmánɨ́ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ámɨ wí sɨ́ŋá ínɨmɨ yapɨnɨŋáná xwɨ́á seáyɨ e onɨmiápɨ eŋɨ́yo piéróɨ́yɨ́ xwɨ́á akwɨnɨ́ánáɨ eŋagɨ nánɨ apaxɨ́ mé nerápɨrɨ nɨyapɨrɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","sogwɨ́ nɨwepɨ́nɨrɨ xaíwɨ́ anáná mɨ́mɨ rapiŋɨ́ mɨwárɨŋɨ́ eŋagɨ nánɨ yeáyɨ́ yɨweánárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ámɨ wí emɨ́ pɨpɨŋɨ́ arɨ́kiárɨnɨŋe wiároŋɨ́yɨ́ emɨ́ pɨpɨŋɨ́yo dánɨ nawínɨ nerápɨmáná emɨ́ xeŋwɨrárɨŋagɨ nánɨ witɨ́ ayɨ́ ná mɨweŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ámɨ wí xwɨ́á naŋɨ́yo wiároŋɨ́yɨ́ nerápɨrɨ nɨyapɨrɨ ná nɨkɨkɨreánɨrɨ́ná wí aga dɨŋɨ́ nɨmorɨ ɨ́á mɨropaxɨ́ werɨ wí xwé obaxɨ́ werɨ wí xwé onɨmiápɨ werɨ eŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","re urɨŋɨnigɨnɨ, “Seyɨ́né witɨ́ siyɨ́ nánɨ rɨ́á apɨ nánɨ arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wiepɨsarɨŋowa idáná Jisaso xegɨ́pɨ ŋweaŋáná nɨbɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ ámáyo nuréwapɨyirɨ́ná ewayɨ́ xwɨyɨ́á tɨ́nɨ pí nánɨ urarɨŋɨ́rɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","o re urɨŋɨnigɨnɨ, “Xwɨyɨ́á eŋíná dánɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ nánɨ yumɨ́í imónɨŋɨ́pɨ nionɨ soyɨ́né nɨjɨ́á imónɨpɨ́rɨ nánɨ áwaŋɨ́ nɨsearɨrɨ aiwɨ ámá wíyo áwaŋɨ́ murarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá nionɨ xwɨyɨ́á rarɨ́ná arɨ́á niro dɨŋɨ́ nɨkwɨ́roro nero nɨjɨ́á bɨ tɨ́ŋɨ́ imónarɨgɨ́á gɨyɨ́ gɨyɨ́ Gorɨxo ámɨ wí mɨnɨ winɨŋoɨ. Arɨ́á mɨnipa ero dɨŋɨ́ mɨnɨkwɨ́ropa ero yarɨgɨ́á gɨyɨ́ gɨyɨ́ ‘Nɨjɨ́á rɨpɨ imónɨŋɨnɨ.’ yaiwiarɨŋagɨ́a aí Gorɨxo apɨ aí ámɨ nurápɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ayɨnánɨ ámáyo nuréwapɨyirɨ́ná ewayɨ́ xwɨyɨ́á tɨ́nɨ urarɨŋárɨnɨ. Ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́ropa yarɨgɨ́áyɨ́ ewayɨ́ xwɨyɨ́á nionɨ rarɨŋápɨ arɨ́á nɨniro aiwɨ mɨ́kɨ́ nánɨ dɨŋɨ́ mɨmopa nero nɨjɨ́á wí imónarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ayɨ́ e yarɨ́ná xwɨyɨ́á Gorɨxo rɨŋɨ́ wɨ́á rókiamoagɨ́ Aisaiao nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ rɨpɨ rɨxa xɨxenɨ imónarɨnɨ, ‘Seyɨ́né aríkwɨ́kwɨ́ nɨwiro segɨ́ arɨ́á pɨ́rónɨro sɨŋwɨ́ supárɨro nero nánɨ arɨ́á nɨwia nuro aí nɨjɨ́á imónɨpɨ́rɨ́ámanɨ. Sɨŋwɨ́ nɨwɨga nuro aí dɨŋɨ́ wí mopɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ayɨ́ rɨpɨ nánɨrɨnɨ. Segɨ́ dɨŋɨ́ tɨ́nɨ néra warɨgɨ́áyɨ́né mɨŋɨ́ sɨ́ŋánɨŋɨ́ imoŋagɨ́a nánɨ seararɨŋɨnɨ. Wigɨ́ sɨŋwɨ́ mɨsupárɨpa ero arɨ́á mɨpɨ́rónɨpa ero nero sɨŋwɨrɨyɨ́, wigɨ́ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ anɨro arɨ́á ero dɨŋɨ́ píránɨŋɨ́ neyíroro moro wigɨ́ ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ mamoro éánáyɨ́ Gorɨxonɨ píránɨŋɨ́ wimɨxɨpaxɨ́rɨnɨ.’ Xwɨyɨ́á apɨ xɨxenɨ imónɨnɨ nánɨ ámáyɨ́ e yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","E nerɨ aí gɨ́ seaiepɨsarɨŋáoyɨ́né segɨ́ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ nanɨro arɨ́á tɨ́nɨ arɨ́á niro nero nánɨ yayɨ́ oseainɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aga nepa seararɨŋɨnɨ, ‘Wɨ́á rókiamoagɨ́á obaxɨ́yɨ́ tɨ́nɨ ámá wé rónɨgɨ́á obaxɨ́yɨ́ tɨ́nɨ enɨ soyɨ́né sɨŋwɨ́ nanɨro arɨ́á niro yarɨgɨ́á rɨpɨ nánɨ “None sɨŋwɨ́ wɨnɨ́wanɨgɨnɨ.” nɨyaiwiro aga nɨwimónɨrɨ aí wí arɨ́á niro sɨŋwɨ́ nanɨro yagɨ́ámanɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","E nurɨrɨ re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á ámá wo nurɨ witɨ́ siyɨ́ wiároŋɨ́pɨ mɨ́kɨ́ nánɨ áwaŋɨ́ osearɨmɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Witɨ́ siyɨ́ wiároŋɨ́yɨ́ xwɨyɨ́á Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ nánɨrɨnɨ. Ámá xwɨyɨ́á apɨ arɨ́á nero nɨjɨ́á mepa éɨ́áyɨ́ ayɨ́ witɨ́ siyɨ́ óɨ́ maŋɨ́pá tɨ́nɨ piéroŋɨ́pɨ́nɨŋɨ́ imónɨŋoɨ. Ayɨ́ arɨ́á wiarɨ́ná obo, arɨ́kí yarɨŋo nɨbɨrɨ ayɨ́ Gorɨxomɨ dɨŋɨ́ wɨkwɨ́ropɨ́rɨxɨnɨrɨ xwɨyɨ́á apɨ wigɨ́ xwioxɨ́yo mɨnɨŋɨ́yɨ́ emɨ rɨroámɨ́ yarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ámá xwɨyɨ́á apɨ arɨ́á nɨwirɨ́ná axíná yayɨ́ nero ‘Naŋɨ́rɨnɨ.’ yaiwíɨ́áyɨ́, ayɨ́ witɨ́ siyɨ́ sɨ́ŋá ínɨmɨ yapɨnɨŋáná xwɨ́á seáyɨ e akwɨnɨ́ánáɨ eŋɨ́yo piéroŋɨ́yɨ́nɨŋɨ́ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Witɨ́ siyɨ́ sɨ́ŋá ínɨmɨ yapɨnɨŋagɨ nánɨ rapiŋɨ́ ná ínɨmɨ mɨwárɨpa eŋɨ́yɨ́nɨŋɨ́ ámá ayɨ́ enɨ wigɨ́ dɨŋɨ́ rapiŋɨ́nɨŋɨ́ xwɨ́áyo mɨ́mɨ ɨ́á mumɨxɨŋagɨ nánɨ ámá wí ayɨ́ xwɨyɨ́á apɨ xɨ́darɨŋagɨ́a nánɨ xeanɨŋɨ́ wikáráná apaxɨ́ mé pɨ́nɨ wiárarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ámá xwɨyɨ́á apɨ arɨ́á nɨwiro aiwɨ wigɨ́ yarɨgɨ́ápa sɨnɨ nɨxɨ́dɨrónáyɨ́ amɨpí xwɨ́áyo dáŋɨ́ ayá tɨ́ŋɨ́pɨ nánɨ dɨŋɨ́ obɨbaxɨ́ moro ‘Amɨpí wí nionɨ mɨnɨmúropa oninɨ.’ yaiwiro ‘Amɨpí ayá tɨ́ŋɨ́pɨ arɨge nɨmeámɨ́árɨ́anɨ?’ yaiwiro néra warɨgɨ́áyɨ́ ayɨ́ witɨ́ siyɨ́ emɨ́ pɨpɨŋɨ́ kɨkɨdɨpeárɨgɨ́e piéroŋɨ́yɨ́nɨŋɨ́ imónɨŋoɨ. Witɨ́ emɨ́ xeŋwɨrárɨŋagɨ nánɨ ná mɨwepa eŋɨ́yɨ́nɨŋɨ́ ámá ayɨ́ enɨ ‘Amɨpí ayá tɨ́ŋɨ́pɨ arɨre nerɨ meámɨ́árɨ́anɨ?’ yaiwiarɨgɨ́ápɨ xwɨyɨ́á Gorɨxoyápimɨ yokwarɨmɨ́ éáná omɨ anɨŋɨ́ minɨ́ xɨ́darɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ámá xwɨyɨ́á apɨ arɨ́á nɨwiro nɨjɨ́á éɨ́áyɨ́ ayɨ́ witɨ́ siyɨ́ xwɨ́á naŋɨ́yo piéroŋɨ́yɨ́nɨŋɨ́ imónɨŋoɨ. Witɨ́ apɨ ná kɨkɨreánɨŋɨ́yɨ́nɨŋɨ́ ámá ayɨ́ enɨ ná nɨwerɨ́ná wí dɨŋɨ́ nɨmorɨ ɨ́á mɨropaxɨ́ werɨ wí xwé obaxɨ́ werɨ wí obaxɨ́ onɨmiápɨ werɨ yarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","O “Agwɨ Gorɨxo ámá sɨpíyɨ́ wigɨ́ dɨŋɨ́ tɨ́nɨ xe néra úɨ́rɨxɨnɨrɨ sɨŋwɨ́ nɨwɨnɨrɨ aiwɨ rɨ́wéná rɨ́áyo ikeaárɨnɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á ámɨ xegɨ́ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo xegɨ́ ámáyo xwioxɨ́yo mɨmeámɨ́ nerɨ meŋweámɨnɨrɨ nánɨ yarɨ́ná imónɨŋɨ́pɨ, ayɨ́ ámá wo xegɨ́ omɨŋɨ́yo xwɨ́á yunɨ́ nikɨxémáná witɨ́ siyɨ́ wiároŋɨ́pɨ tɨ́nɨ rɨ́ramɨŋɨyɨ́ epaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Witɨ́ siyɨ́ nɨwiároárɨmáná xegɨ́ aŋɨ́yo nánɨ nurɨ sá weŋáná o tɨ́nɨ sɨ́mɨ́ tɨ́nɨ inarɨgɨ́ío nɨbɨrɨ re eŋɨnigɨnɨ. Rɨpɨkɨ́ siyɨ́ witɨ́ siyɨ́ wiárónɨŋe seáyɨ e nɨwiároárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Nɨwiároárɨmɨ numáná eŋáná rɨxa witɨ́ nerápɨrɨ nɨyapɨrɨ rɨxa ná kɨkɨreánɨmɨnɨrɨ yarɨ́ná omɨŋɨ́ xiáwomɨ omɨŋɨ́ wiiarɨgɨ́áwa sɨŋwɨ́ wɨnɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Rɨpɨkɨ́ aí tɨ́nɨ nawínɨ eŋagɨ nɨwɨnɨmɨ nuro bosomɨ re urɨgɨ́awixɨnɨ, ‘None “Joxɨ dɨxɨ́ omɨŋɨ́yo siyɨ́ naŋɨ́nɨ wiároŋɨ́rɨnɨ.” neaimónarɨnɨ. Arɨre nerɨ rɨpɨkɨ́ enɨ nerápɨrɨ yapɨ́ɨ́rɨ́anɨ?’ urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","o re urɨŋɨnigɨnɨ, ‘Gɨ́ sɨ́mɨ́ tɨ́nɨ inarɨgwɨ́ío eŋɨ́rɨ́anɨ? Oyɨ, orɨnɨ!’ urɨ́agɨ xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwa yarɨŋɨ́ re wigɨ́awixɨnɨ, ‘None nurane rɨpɨkɨ́yɨ́ yɨyoámɨ́ yanɨréwɨnɨ?’ urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","o re urɨŋɨnigɨnɨ, ‘Oweoɨ, soyɨ́né rɨpɨkɨ́yɨ́ yɨyoámɨ́ nerɨ́ná witɨ́ aí tɨ́nɨ yɨyoámɨ́ epɨ́rɨxɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","aiwá mipɨ́rɨ́íná nánɨ nɨ́nɨ xe oenɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ. Witɨ́ rɨxa yóɨ́ eŋáná witɨ́ mɨwákwímɨ́ yarɨgɨ́áwamɨ re urɨmɨ́árɨnɨ, “Xámɨ rɨpɨkɨ́yɨ́ mɨwákwímɨ́ nero áwɨnɨ e gwɨ́ nɨkɨrɨ́wímáná rɨ́á ikeaárɨ́ɨ́rɨxɨnɨ. E nemáná witɨ́ mɨwákwímɨ́ nero aiwá aŋɨ́ nɨtiarɨgɨ́iwámɨ nɨtíɨ́rɨxɨnɨ.” urɨmɨ́árɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O ámá re oyaiwípoyɨnɨrɨ “Agwɨ ámá obaxɨ́ Jisasomɨ mɨxɨ́darɨŋagɨ́a aiwɨ rɨ́wɨ́yo Gorɨxo xegɨ́ ámáyo xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweaŋánáyɨ́ Jisasoyá ámá obaxɨ́ imónɨpɨ́rɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo seyɨ́né xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ, ayɨ́ masɨté aiwá siyɨ́nɨŋɨ́ imónɨnɨ. Masɨté aiwá xegɨ́ siyɨ́ aga onɨmiá imónɨnɨ. Masɨté siyɨ́ nɨmearo omɨŋɨ́yo moárarɨgɨ́áyɨ́ ");
INSERT INTO aak_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","aiwá siyɨ́ nɨyonɨ masɨté siyɨ́ aga onɨmiá eŋagɨ aiwɨ rɨxa nɨyapɨrɨ xwé nɨrorɨ́ná íkɨ́ánɨŋɨ́ roŋáná iŋɨ́ nɨbɨrɨ nɨŋwearɨ yéwɨ́ tɨpaxɨ́ imónarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O ewayɨ́ xwɨyɨ́á ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ, ayɨ́ yisɨ́nɨŋɨ́ —Yisɨ́ bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ eŋáná bɨ onɨmiápɨ ínɨmɨ táná nɨmɨnɨ íkwiaŋwɨ́ eapɨnarɨŋɨ́rɨnɨ. Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ, ayɨ́ yisɨ́nɨŋɨ́ imónɨnɨ. Apɨxɨ́ bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ dɨramɨxɨ́ xwé sɨxɨ́ ínɨŋáná yisɨ́ bɨ nɨmearo ínɨmɨ táná nɨmɨnɨ íkwiaŋwɨ́ eapɨnarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisaso oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo xwɨyɨ́á apɨ nɨpɨnɨ nuréwapɨyirɨ́ná ewayɨ́ xwɨyɨ́ánɨ nurɨrɨ uréwapɨyayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Xwɨyɨ́á Gorɨxoyá wɨ́á rókiamoagɨ́ wo nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́ rɨpɨ, “Nionɨ xwɨyɨ́á nɨrɨrɨ́ná ewayɨ́ xwɨyɨ́áyo dánɨ rɨrɨ xwɨyɨ́á Gorɨxo xwɨ́á imɨxɨŋíná dánɨ ínɨmɨ rɨnɨŋɨ́pɨ áwaŋɨ́ rɨrɨ emɨ́árɨnɨ.” nɨrɨrɨ eaŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ Jisaso nuréwapɨyirɨ́ná ewayɨ́ xwɨyɨ́á tɨ́nɨnɨ nurɨrɨ uréwapɨyagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","O oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo pɨ́nɨ nɨwiárɨmɨ nurɨ aŋɨ́yo nɨpáwirɨ ŋweaŋáná xegɨ́ wiepɨsarɨŋowa nɨbɨro re urɨgɨ́awixɨnɨ, “Joxɨ nearéwapɨyirɨ́ná ewayɨ́ ikaxɨ́ rɨpɨkɨ́ nánɨ nearɨ́ɨ́pɨ áwaŋɨ́ nɨnearɨrɨ píránɨŋɨ́ nearéwapɨyiɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","o re urɨŋɨnigɨnɨ, “Ámá witɨ́ siyɨ́ naŋɨ́ wiároŋoyɨ́ ámá imónɨŋáonɨ nánɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Omɨŋɨ́yɨ́ ayɨ́ xwɨ́á rɨrí nánɨrɨnɨ. Witɨ́ siyɨ́ naŋɨ́yɨ́, ayɨ́ ámá Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́áyɨ́ nánɨrɨnɨ. Rɨpɨkɨ́yɨ́ ayɨ́ ámá Gorɨxomɨ muxɨ́darɨgɨ́áyɨ́, ámá oboyáyɨ́ nánɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sɨ́mɨ́ tɨ́nɨ inarɨgɨ́ío, rɨpɨkɨ́ siyɨ́ wiároŋo, ayɨ́ Oborɨnɨ. Aiwá yóɨ́ eŋagɨ mipɨ́rɨ́ínáyɨ́ ayɨ́ sɨ́á yoparɨ́yi nánɨrɨnɨ. Witɨ́ mɨwákwímɨ́ nero mipɨ́rɨ́áyɨ́, ayɨ́ aŋɨ́najɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ayɨnánɨ rɨpɨkɨ́yɨ́ mɨwákwímɨ́ nero gwɨ́ nɨkɨrɨ́wímáná rɨ́á ikeaárɨgɨ́ápa imónɨŋɨ́yɨ́ sɨ́á yoparɨ́yimɨ axɨ́pɨ e imónáná ");
INSERT INTO aak_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ámá imónɨŋáonɨ ámá rɨkɨkɨrɨ́ó ero wa enɨ nene yarɨŋwápɨ oépoyɨnɨrɨ wíwapɨyiro yarɨgɨ́áyɨ́ gɨ́ ápo meŋweanɨ́e ŋweapɨ́rɨxɨnɨrɨ gɨ́ aŋɨ́najowa awí eámeámɨ́ epɨ́rɨ urowárɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Urowáráná awa awí eámeámɨ́ nemáná rɨ́á ápiáwɨ́ xwé anɨŋɨ́ wearɨŋɨ́rímɨ ikeaáráná ayɨ́ e dánɨ ‘Yeyɨ!’ nɨrɨro magí írónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E nerɨ aí oxɨ́ apɨxɨ́ wé rónɨgɨ́á Gorɨxoyáyɨ́ xɨ́o xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́e dánɨ sogwɨ́ nanɨrɨ́ná yarɨŋɨ́pa xɨxɨ́eá sɨŋánɨ inɨpɨ́rɨ́árɨnɨ. Seyɨ́né arɨ́á tɨ́gɨ́áyɨ́né eŋánáyɨ́, arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","O ámá re oyaiwípoyɨnɨrɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ ayá tɨ́ŋɨ́pɨ́nɨŋɨ́ imónɨŋagɨ nánɨ Jisaso pí pí nearɨ́agɨ aí xɨxenɨ éwanɨgɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́ápɨ, ayɨ́ xwɨ́á bimɨ wí e ayá rɨmɨxarɨŋɨ́pɨ wí pɨ́nɨ́ tɨnɨŋɨ́pɨ́nɨŋɨ́ imónɨnɨ. Ámá wo nemerɨ́ná wenɨŋɨ́ nerɨ nɨwɨnɨmearɨ yayɨ́ nikárɨnɨrɨ nánɨ re eŋɨnigɨnɨ. Mɨ́rɨ́ nurɨ ámá wíyo áwaŋɨ́ murɨ́ xegɨ́ amɨpí nɨ́nɨ nɨgwɨ́ nánɨ bɨ́ nerɨ nɨgwɨ́ apɨ tɨ́nɨ nɨmeámɨ nurɨ xwɨ́á apɨnɨ bɨ́ eŋɨnigɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ámɨ re urɨŋɨnigɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́ápɨ, ayɨ́ ámá amɨpí mɨmúrónɨŋɨ́ wo memiá awiaxɨ́nɨ awiaxɨ́nɨ nánɨ pɨ́á emearɨŋɨ́pánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bá nɨyonɨ múrónɨŋagɨ nɨwɨnɨmeaárɨmo aŋɨ́nɨ nurɨ xegɨ́ amɨpí nɨ́nɨ bɨ́ nemáná nɨgwɨ́ apɨ tɨ́nɨ memiápá bɨ́ eŋɨnigɨnɨ.” nurɨrɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋweanɨ́ápɨ ayá tɨ́ŋɨ́pɨ́nɨŋɨ́ imónɨŋagɨ nánɨ Jisaso pí pí nearɨ́agɨ aí xɨxenɨ éwanɨgɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","O re urɨŋɨnigɨnɨ, “Gorɨxo ámá xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweámɨnɨrɨ nerɨ́ná enɨ́ápɨ, ayɨ́ ubenɨ́ ipíyo nɨmamówárɨro peyɨ́ xɨxegɨ́nɨ ɨ́á mɨnarɨŋɨ́pánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Rɨxa peyɨ́ magwɨ́ mɨnɨŋagɨ nɨwɨnɨro nɨmɨxearo ipí imaŋɨ́pá tɨ́ŋɨ́ e nɨtɨro éɨ́ nɨŋweámáná peyɨ́ naŋɨ́nɨ neyíroro íkwiaŋwɨ́yo mɨmeámɨ́ nɨyárɨro sɨpíyɨ́ emɨ mɨmeámɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sɨ́á yoparɨ́yimɨ axɨ́pɨ e imónáná aŋɨ́najowa nɨweapɨro wé rónɨgɨ́áyo nɨmúroro sɨpí yarɨgɨ́áyo yɨyoámɨ́ nero ");
INSERT INTO aak_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","rɨ́á ápiáwɨ́ xwé anɨŋɨ́ wearɨŋɨ́rímɨ ikeaáráná ayɨ́ e dánɨ ‘Yeyɨ!’ nɨrɨro magí írónɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wiepɨsarɨŋɨ́yo re urɨŋɨnigɨnɨ, “Nionɨ searéwapɨyarɨŋápɨ nɨpɨnɨ mɨ́kɨ́ nánɨ rɨxa nɨjɨ́á rimónɨŋoɨ?” urɨ́agɨ “Oyɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","o re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á nionɨ nɨnɨxɨ́dɨro gɨ́ wiepɨsarɨŋáyɨ́ nimónɨro yarɨgɨ́á nɨ́nɨ ayɨ́ ámá amɨpí mɨmúrónɨgɨ́áyɨ́nɨŋɨ́ imónɨŋoɨ. Ayɨ́ wigɨ́ ayá rɨmɨxarɨgɨ́ápɨ aŋɨ́yo weŋɨ́mɨ sɨŋɨ́ bɨ tɨ́nɨ xámɨŋɨ́ bɨ tɨ́nɨ nɨmearo ámáyo sɨwá wiarɨgɨ́ápa gɨ́ seaiepɨsarɨŋáoyɨ́né xwɨyɨ́á eŋíná Moseso nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́pɨ tɨ́nɨ nionɨ agwɨ seararɨŋápɨ tɨ́nɨ axɨ́pɨ e epɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisaso ewayɨ́ xwɨyɨ́á apɨ nura núɨsáná e dánɨ pɨ́nɨ nɨwiárɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aŋɨ́ xɨ́o xegɨ́ xwé iwiaroŋe nɨrémorɨ rotú aŋɨ́yo nɨpáwirɨ xwɨyɨ́á uréwapɨyarɨ́ná ayɨ́ ududɨ́ nero re rɨnɨgɨ́awixɨnɨ, “Ámá royɨ́ nɨjɨ́á emɨmɨ́ yarɨŋɨ́ rɨpɨ gɨmɨ dánɨ nɨjɨ́á imónɨ́ɨ́rɨ́anɨ? ");
INSERT INTO aak_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","O aŋɨ́ mɨrarɨŋɨ́ Josepomɨ xewaxo menɨranɨ? Xɨnáí Mariaíyɨ mɨrɨnɨŋíranɨ? Xogwáowa Jemiso tɨ́nɨ Josepo tɨ́nɨ Saimono tɨ́nɨ Judaso tɨ́nɨ rɨnɨŋowa re mɨŋweagɨ́á reŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Xɨnapíwa nene tɨ́nɨ mɨŋweapa reŋoɨ? E eŋagɨ nánɨ ámá royɨ́ arɨge nɨjɨ́á apɨ imónɨ́ɨ́rɨ́anɨ?” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","wikɨ́ dɨŋɨ́ nɨwóga warɨŋagɨ́a Jisaso xewanɨŋo nánɨ re urɨŋɨnigɨnɨ, “Ámá xwɨyɨ́á Gorɨxoyá wɨ́á urókiamoarɨŋɨ́ womɨ aŋɨ́ mɨdáŋɨ́yɨ́ arɨ́á umónarɨgɨ́á aí xegɨ́ e dáŋɨ́yɨ́ tɨ́nɨ xexɨrɨ́meáyɨ́ tɨ́nɨ o nánɨ ‘Sa negɨ́ ámáorɨnɨ.’ nɨyaiwiro arɨ́á umónarɨgɨ́ámanɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ayɨ́ dɨŋɨ́ mɨwɨkwɨ́roarɨŋagɨ́a nánɨ e nɨŋwearɨ́ná emɨmɨ́ xwapɨ́ mɨwíwapɨyiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Íná mɨxɨ́ ináyɨ́ Xeroto —O Gariri pɨropenɨsɨ́ meŋweaŋorɨnɨ. O xwɨyɨ́á Jisaso nánɨ yanɨ́ niwéa warɨŋagɨ arɨ́á nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwamɨ re urɨŋɨnigɨnɨ, “Ayɨ́ nionɨ pɨkiŋáo, Jono wayɨ́ numeaia uŋorɨnɨ. Rɨxa xwárɨpáyo dánɨ nɨwiápɨ́nɨmearɨ nánɨ emɨmɨ́ ayɨ́ néra warɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ayɨ́ rɨpɨ nánɨ Xeroto e urɨŋɨnigɨnɨ. Xámɨ O Jono sɨnɨ emearɨ́ná xegɨ́ xexɨrɨ́meáo Piripoyá apɨxí Xerodiasíyɨ rɨnɨŋí nurápɨrɨ meáagɨ nánɨ Jono xwɨyɨ́á re urárayiŋɨnigɨnɨ, “Dɨxɨ́ rɨrɨxɨ́meáoyá apɨxí nurápɨrɨ nɨmearɨ́náyɨ́, ‘Ayɨ́ Nɨpɨkwɨnɨ yarɨŋɨnɨ.’ rɨyaiwinarɨŋɨnɨ?” urayarɨŋagɨ nánɨ Xeroto xegɨ́ porisɨ́yo urowáráná awa nuro omɨ ɨ́á nɨxero gwɨ́ nɨyiro nɨmeámɨ nɨbɨro gwɨ́ aŋɨ́yo ŋwɨrárɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Xeroto Jono nánɨ “Omɨ opɨkímɨnɨ.” nɨyaiwirɨ aiwɨ ámá oxɨ́ apɨxɨ́ “Jono Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ worɨnɨ.” yaiwiarɨgɨ́á eŋagɨ nánɨ wáyɨ́ nerɨ “Nionɨ enɨ nɨpɨkipɨ́rɨxɨnɨ.” nɨyaiwirɨ sa gwɨ́ aŋɨ́yo wárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","E nɨwárɨmáná eŋáná sɨ́á Xerotomɨ xɨnáí xɨrɨŋɨ́yi imónáná Xeroto xegɨ́ ámá wa tɨ́nɨ aiwá nimɨxɨro narɨ́ná omɨ xiepí Xerodiasímɨ xemiáí nɨbɨrɨ áwɨnɨ e nɨrómáná sɨmɨnɨŋɨ́ eŋɨnigɨnɨ. Í sɨmɨnɨŋɨ́ yarɨ́ná Xeroto sɨmɨnɨŋɨ́ í yarɨŋɨ́pɨ nánɨ yayɨ́ nɨwinɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","xwɨ́á e dánɨ re urɨŋɨnigɨnɨ, “Nionɨ jíxɨ sɨ́mɨmaŋɨ́yo dánɨ rɨrarɨŋɨnɨ, ‘Pí pí nánɨ nionɨ rɨxɨŋɨ́ nɨránáyɨ́ nɨsiapɨmɨ́ɨnɨ.’ rɨrarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","í xɨnáí tɨ́ŋɨ́ e nánɨ nurɨ ámɨ nɨbɨrɨ xɨnáí urepɨsíɨ́pɨ axɨ́pɨ re urɨŋɨnigɨnɨ, “Porisɨ́ wa Jono wayɨ́ numeaia warɨŋoyá siŋwɨ́ mɨŋɨ́ nɨwákwiro mɨŋo sɨŋwɨ́ wɨnɨmɨ nánɨ pɨrerɨxɨ́yo nɨtɨro nɨmeámɨ nɨbɨro oniapɨ́poyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Xeroto dɨŋɨ́ sɨpí wíagɨ aiwɨ awa tɨ́nɨ aiwá nawínɨ narɨgɨ́e dánɨ urɨ́agɨ nánɨ porisɨ́ wamɨ í urɨ́ɨ́pɨ axɨ́pɨ sekaxɨ́ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","urowáráná wo gwɨ́ aŋɨ́yo nánɨ nurɨ e dánɨ Jonomɨ siŋwɨ́ mɨŋɨ́ nɨwákwirɨ ");
INSERT INTO aak_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mɨŋo pɨrerɨxɨ́yo nɨtɨrɨ nɨmeámɨ nɨbɨrɨ miáímɨ mɨnɨ wíáná í nurápɨrɨ nɨmeámɨ nurɨ xɨnáímɨ mɨnɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","E éáná Jono xegɨ́ wiepɨsarɨŋowa nɨbɨro pɨyomɨ nɨmearo nɨmeámɨ nuro xwɨ́á nɨweyárɨmowa nuro Jisasomɨ áwaŋɨ́ urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisaso xwɨyɨ́á Jono nánɨ arɨ́á nɨwirɨ e pɨ́nɨ nɨwiárɨmɨ ewéyo nɨpɨxemoánɨrɨ ámá dɨŋɨ́ meaŋe nánɨ xegɨ́pɨ warɨŋagɨ aiwɨ oxɨ́ apɨxɨ́ obaxɨ́ aŋɨ́ bɨ bimɨ dáŋɨ́yɨ́ “Jisaso ewéyo puŋoɨ.” rɨnɨ́agɨ arɨ́á nɨwiro yánɨ óɨ́yo númɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisaso rɨxa ipí imaŋɨ́pá tɨ́ŋɨ́ e niwiékɨ́nɨmearɨ wɨnɨŋɨnigɨnɨ. Oxɨ́ apɨxɨ́ obaxɨ́ xɨ́o tɨ́ŋɨ́ e nánɨ bɨmiarɨŋagɨ́a nɨwɨnɨrɨ wá nɨwianɨrɨ wigɨ́ sɨmɨxɨ́yɨ́ píránɨŋɨ́ imɨmɨxɨmɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","sɨ́ápɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋowa nɨbɨro re urɨgɨ́awixɨnɨ, “Re ámá dɨŋɨ́ meanɨnɨ. Sɨ́á wórɨnɨgɨnɨ. Joxɨ ámá nɨ́nɨ wigɨ́ aiwá bɨ́ nero nɨpɨ́rɨ nánɨ aŋɨ́ onɨmiápia amɨ amɨ ŋweameŋɨ́yo nánɨ urowárapeɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisaso re urɨŋɨnigɨnɨ, “Ayɨ́ nupaxɨ́ mimónarɨnɨ. Soyɨ́né aiwá wí mɨnɨ wípoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","awa re urɨgɨ́awixɨnɨ, “Negɨ́ aiwá xwapɨ́ menɨnɨ. Sa bisɨ́kerɨ́á wé ná wúnɨ tɨ́nɨ peyɨ́ yeáyɨ́ waúnɨ tɨ́nɨrɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","o re urɨŋɨnigɨnɨ, “Nionɨ tɨ́ámɨnɨ nɨmeámɨ bɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","rɨxa nɨmeámɨ báná re urɨŋɨnigɨnɨ, “Oxɨ́ apɨxɨ́ nɨ́nɨ aráyo éɨ́ oŋweápoyɨ.” sekaxɨ́ e nurɨmáná bisɨ́kerɨ́á wé wú tɨ́nɨ peyɨ́ waú tɨ́nɨ nɨmearɨ aŋɨ́namɨ sɨŋwɨ́ nanánɨmáná Gorɨxomɨ aiwá apɨ nánɨ yayɨ́ nɨwirɨ bisɨ́kerɨ́á kwɨkwɨrɨmɨ́ nerɨ xegɨ́ wiepɨsarɨŋowamɨ mɨnɨ wíáná awa oxɨ́ apɨxɨ́ éɨ́ ŋweáɨ́áyo yaŋɨ́ nɨwia warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ámá nɨ́nɨ aiwá apɨ nɨnɨro agwɨ́ ímɨ uyiŋɨnigɨnɨ. Agwɨ́ ímɨ uyíagɨ wiepɨsarɨŋowa sɨŋwɨ́ e nɨwɨnɨro aiwá rɨxa apánɨ nɨnɨro e tɨ́ápia nɨmeamero soxɨ́ ɨ́á wé wúkaú sɨkwɨ́ waúmɨ nɨmeaayiro aumaúmɨ́ nero magwɨ́ nɨmiro tɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Niaíwɨ́ tɨ́nɨ apɨxɨ́ tɨ́nɨ nɨnɨrɨ aiwɨ oxowanɨ ámá 5,000 aiwá apɨ nɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisaso xegɨ́ wiepɨsarɨŋowa aiwá ámá ayɨ́ nɨnɨro tɨ́ápia soxɨ́ ɨ́áyo magwɨ́ nɨmiro táná re urowárɨŋɨnigɨnɨ, “Nionɨ oxɨ́ apɨxɨ́ tɨ́yo urowáraparɨ́ná soyɨ́né ewéyo nɨpɨxemoánɨro ipíwámɨ jɨ́arɨwámɨnɨ nánɨ xámɨ nɨmeápoyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","awa rɨxa nɨpɨxemoánɨro úáná ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo enɨ nurowárapɨmáná Gorɨxomɨ xwɨyɨ́á urɨmɨnɨrɨ nánɨ xegɨ́pɨ dɨ́wɨ́ mɨŋɨ́yo nánɨ nɨyirɨ rɨxa sɨ́á nóra warɨŋɨ́ tɨ́nɨ xegɨ́pɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ewépá sɨnɨ ipí áwɨnɨ e warɨ́ná iniɨgɨ́ ewépámɨ imeamɨ́kwɨ́ merɨ imɨŋɨ́ enɨ ewé sɨ́mɨ́mɨ dánɨ bɨrɨ nerɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","rɨxa wɨ́á nánɨ isɨ́á yinɨŋáná Jisaso ipíyo nosaxa nɨbɨrɨ wiepɨsarɨŋowamɨ rɨxa wímeámɨnɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","awa wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Jisaso ipíyo xwɨrɨŋwɨ́ nosaxa barɨŋagɨ nɨwɨnɨro wáyɨ́ nikárɨnɨro “Pɨyɨŋɨ́ siwí wo rɨ́a barɨnɨ?” nɨrɨro “Yeyɨ!” rekárɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né wáyɨ́ mikárɨnɨpanɨ. Ayɨ́ nionɨrɨnɨ. Dɨŋɨ́ sɨxɨ́ nínɨro ŋweápoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ayɨ́ nepa joxɨ eŋánáyɨ́, ‘Joxɨ enɨ ipíyo nosaxa nɨbɨrɨ nímeaɨ.’ nɨreɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisaso “Beɨ.” urɨ́agɨ Pitao ewépámɨ dánɨ nayoarɨ Jisaso tɨ́ŋɨ́ e nánɨ nosaxa nurɨ aí ");
INSERT INTO aak_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","imɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ wáyɨ́ éɨ́yɨ́ re eŋɨnigɨnɨ. Ipíyo rɨxa nurɨ́pínɨrɨ́ná rɨ́aiwá re urɨŋɨnigɨnɨ, “Nionɨ iniɨgɨ́ namimɨgɨnɨ! Ámɨnáoxɨnɨ, árɨ́wɨ́ nɨmeaɨ!” uráná ");
INSERT INTO aak_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","o aŋɨ́nɨ ɨ́eapá nɨyaurɨ wéyo nɨmaxɨrɨrɨ nɨmɨ́eyoarɨ re urɨŋɨnigɨnɨ, “Dɨŋɨ́ onɨmiápɨ nɨkwɨ́roarɨgɨ́oyɨ́nérɨnɨ. Pitaoxɨnɨ, joxɨ ‘Jisasoyá dɨŋɨ́ tɨ́nɨ ipíyo xwɨrɨŋwɨ́ nosaxa umɨ́ɨnɨ.’ nɨyaiwirɨ aí ámɨ pí nánɨ ‘Oyá dɨŋɨ́ tɨ́nɨ e epaxonɨmanɨ.’ yaiwiarɨŋɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","awaú rɨxa ewéyo pɨxemoánáná re eŋɨnigɨnɨ. Imɨŋɨ́ yarɨŋɨ́pɨ pɨ́nɨ wiárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Imɨŋɨ́ pɨ́nɨ wiáráná ewéyo ŋweagɨ́áyɨ́ mɨŋɨ́ ewéyo nɨkwɨ́roro omɨ yayɨ́ numerɨ́ná re urɨgɨ́awixɨnɨ, “Neparɨnɨ. Joxɨ niaíwɨ́ Gorɨxoyáoxɨrɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Awa ipíyo orɨwámɨ dánɨ nɨrémoro aŋɨ́ xegɨ́ yoɨ́ Genesaretɨyɨ rɨnɨŋɨ́pɨ tɨ́ŋɨ́ e iwiékɨ́nɨmeááná ");
INSERT INTO aak_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ámá e dáŋɨ́yɨ́ Jisasomɨ mí nɨwómɨxɨro aŋɨ́ nɨpimɨnɨ áwaŋɨ́ nɨrɨnárɨmáná wigɨ́ ámá sɨmɨxɨ́ yarɨgɨ́á nɨ́nɨ o tɨ́ŋɨ́ e nánɨ nɨméra nɨbɨro wáráná ");
INSERT INTO aak_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","sɨmɨxɨ́yɨ́ rɨxɨŋɨ́ re urayigɨ́awixɨnɨ, “Joxɨyá iyɨ́á sírɨ́wɨ́yo amáɨ́ onɨrónɨ́poyɨnɨrɨ sɨŋwɨ́ neaneɨ.” nurɨro nɨ́nɨ amáɨ́ e nɨrónayiro nánɨ naŋɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Íná Parisi wa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa tɨ́nɨ Jerusaremɨ dánɨ nɨbɨro Jisasomɨ nɨwímearo re urɨgɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Negɨ́ arɨ́owa érowiápɨ́nɨgɨ́ápɨ dɨxɨ́ wiepɨsarɨŋowa pí nánɨ pɨ́rɨ́ wiaíkímɨ́ yarɨŋoɨ? Aiwá nanɨrɨ́ná pí nánɨ arɨ́owa rɨgɨ́ápɨ wé wayɨ́ mɨrónɨpa nero narɨgɨ́árɨnɨ?” Jisasoyá wiepɨsarɨŋowa wé wayɨ́ nɨrónɨro aiwɨ xiáwowa egɨ́ápa axɨ́pɨ mɨyarɨŋagɨ́a nánɨ e uráná ");
INSERT INTO aak_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né enɨ segɨ́ seárɨ́awéwa érowiápɨ́nɨgɨ́ápimɨ xɨ́danɨro nánɨ pí nánɨ ŋwɨ́ ikaxɨ́ Gorɨxoyá rɨnɨŋɨ́pimɨ pɨ́rɨ́ wiaíkímɨ́ yarɨgɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gorɨxo rɨŋɨ́pɨ rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨnɨ, ‘Dɨxɨ́ rɨnomɨ wéyo merɨ rɨnáímɨ wéyo merɨ erɨ́ɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ. Rɨ́wamɨŋɨ́ rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Ámá gɨyɨ́ gɨyɨ́ xano nánɨranɨ, xɨnáí nánɨranɨ, pɨ́né sɨpí umeararɨ́náyɨ́ ayo emɨ opɨkímópoyɨnɨrɨ sɨŋwɨ́ wɨnɨrɨ́ɨnɨ.’ E nɨrɨnɨrɨ eánɨŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ámá gɨyɨ́ xanomɨranɨ, xɨnáímɨranɨ, ‘Amɨpí nionɨ nɨsiapɨrɨ arɨrá sipaxɨ́pɨ nánɨ Gorɨxomɨ urepeárɨŋá eŋagɨ nánɨ bɨ mɨnɨ siapɨpaxɨ́manɨ.’ urarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","soyɨ́né sɨŋwɨ́ e nɨwɨnɨróná re rarɨgɨ́árɨnɨ, ‘Ayɨ́ xaneyo wéyo mɨmepa yarɨŋagɨ aiwɨ apánɨ yarɨŋoɨ.’ rarɨgɨ́árɨnɨ. Soyɨ́né e nerɨ́ná Gorɨxoyá rɨnɨŋɨ́yɨ́ xórórɨ́ nero segɨ́ seárɨ́awéwa érowiápɨ́nɨgɨ́ápɨnɨ seáyɨ e mɨ́eyoarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naŋɨ́ rɨro sɨpí rɨro yarɨgɨ́oyɨ́né, xwɨyɨ́á Gorɨxo rɨŋɨ́ wɨ́á rókiamoagɨ́ Aisaiao nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́pɨ soyɨ́né nánɨ xɨxenɨ re rɨnɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ámá tɨyɨ́ “Gorɨxomɨ wéyo píránɨŋɨ́ mearɨŋwɨnɨ.” nɨrɨro aiwɨ nionɨ dɨŋɨ́ sɨxɨ́ mɨnɨyipa yarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","E neróná ámáyo amɨpí ámá wigɨ́ dɨŋɨ́ tɨ́nɨ érowiápɨ́nɨgɨ́ápɨ nánɨ nuréwapɨyiróná yapɨ́ re nurɨro “Xwɨyɨ́á tɨyɨ́ Gorɨxoyárɨnɨ.” nurɨro nánɨ “Gorɨxomɨ seáyɨ e umearɨŋwɨnɨ.” nɨrɨróná Gorɨxonɨyá yoɨ́nɨ surɨ́má rarɨgɨ́árɨnɨ.’ Aisaiao xwɨyɨ́á Gorɨxoyápɨ nɨwurɨyirɨ soyɨ́né nánɨ xɨxenɨ rɨ́wamɨŋɨ́ e eaŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","“Ámá oxɨ́ apɨxɨ́ re epɨ́royɨ́ egɨ́áyɨ́ obɨ́poyɨ.” nɨrɨrɨ ayɨ́ rɨxa aŋwɨ e awí eánáráná re urɨŋɨnigɨnɨ, “Arɨ́á nɨniro nɨjɨ́á imónɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “Amɨpí ámá nɨnɨro gwɨ́ nárearɨgɨ́ápɨ piaxɨ́nɨŋɨ́ weaarɨŋɨ́manɨ. Amɨpí xwioxɨ́yo dánɨ dɨŋɨ́ móɨ́ápɨ, ayɨ́ piaxɨ́nɨŋɨ́ weaarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xegɨ́ wiepɨsarɨŋowa nɨbɨro re urɨgɨ́awixɨnɨ, “Joxɨ Parisiowamɨ e nurɨrɨ́ná ‘Sɨ́mirɨrɨ́ mɨwiarɨŋɨnɨ.’ rɨyaiwiarɨŋɨnɨ?” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","o Parisiowa nánɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Rɨ́wéná Gorɨxo aiwá xɨ́o ɨwɨ́á murɨŋɨ́ nɨyonɨ emɨ yɨyoámɨ́ enɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ámɨ Parisiowa nánɨ re urɨŋɨnigɨnɨ, “Soyɨ́né awa nánɨ ayá sɨ́wɨ́ mɨsearopanɨ. Awa sɨŋwɨ́ supárɨgɨ́áwa sɨŋwɨ́ supárɨgɨ́áyo nipemeámɨ warɨgɨ́áwa yapɨ imónɨŋoɨ. Ámá sɨŋwɨ́ supárɨŋɨ́ wo sɨŋwɨ́ supárɨŋɨ́ womɨ nipemeámɨ nurɨ́ná nɨwaúnɨ xwárɨŋwɨ́yo piéropɨsɨ́iɨ. Ayɨnánɨ ayá sɨ́wɨ́ mɨsearopanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pitao re urɨŋɨnigɨnɨ, “Joxɨ ewayɨ́ xwɨyɨ́á ámá aiwá nɨnɨro gwɨ́nárearɨgɨ́ápɨ nánɨ rɨ́ápɨ áwaŋɨ́ neareɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","o re urɨŋɨnigɨnɨ, “Gɨ́ seaiepɨsarɨŋáoyɨ́né enɨ sɨnɨ majɨ́á rɨseainarɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Amɨpí ámá nɨ́ápɨ arɨ́owa egɨ́ápa wé wayɨ́ nɨrónɨro nɨnɨrɨ́náranɨ, awa egɨ́ápa mé nɨnɨrɨ́náranɨ, agwɨ́yo nínɨŋɨsáná íkɨ́ nemoro nánɨ piaxɨ́nɨŋɨ́ weaarɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","E nerɨ aiwɨ xwioxɨ́yo dánɨ ɨ́wɨ́ amɨpí nánɨ dɨŋɨ́ móɨ́ápɨ piaxɨ́nɨŋɨ́ weaarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Xwioxɨ́yo dánɨ dɨŋɨ́ nɨmoro yarɨgɨ́ápɨ ‘Sɨpí oimɨxɨmɨnɨ.’ yaiwiarɨgɨ́á rɨpɨrɨnɨ. Ámá pɨkirɨ ero ámá wí tɨ́nɨ ɨ́wɨ́ inɨro ero sɨwɨ́ piaxɨ́ eánɨpaxɨ́ imónɨŋɨ́yɨ́ niga uro ɨ́wɨ́ mearɨ ero yapɨ́ rɨrɨ ero ámá wí nánɨ ikayɨ́wɨ́ rɨrɨ ero ");
INSERT INTO aak_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","yarɨgɨ́ápɨ nɨmorɨ́ná wiwanɨŋɨ́yo piaxɨ́nɨŋɨ́ weaarɨŋɨ́rɨnɨ. E nerɨ aí ámá wé wayɨ́ mɨrónɨpa nerɨ aiwá nɨnɨrɨ́ná wiwanɨŋɨ́yo wí piaxɨ́ weaarɨŋɨ́manɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","O e dánɨ pɨ́nɨ nɨwiárɨmɨ nurɨ pɨropenɨsɨ́ émáyɨ́ aŋɨ́ Taia tɨ́nɨ Saidonɨ tɨ́nɨ tɨ́ŋɨ́ e emearɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Émáyɨ́ apɨxɨ́ Kenanɨ dáŋí aŋɨ́ apiaú tɨ́ŋɨ́ e dánɨ nɨbɨrɨ jɨ́amɨne dánɨ nuxɨ́dɨrɨ́ná rɨ́aiwá re nura uŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, mɨxɨ́ ináyɨ́ Depitomɨ xiáwoxɨnɨ, joxɨ wá nɨwianeɨ. Gɨ́ miáímɨ imɨ́ó dɨŋɨ́ nɨxɨxérorɨ xɨxeanɨŋɨ́ wikárarɨnɨ.” nura warɨŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jisaso xɨ́o enɨ bɨ murarɨŋagɨ nánɨ xegɨ́ wiepɨsarɨŋowa nɨbɨro arɨ́kí re urayigɨ́awixɨnɨ, “Apɨxɨ́ rí arɨ́kí rɨ́aiwá tɨ́nɨ neaxɨ́darɨŋagɨ nánɨ joxɨ xegɨ́ miáímɨ imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́pɨ mɨxɨ́ numáɨnowárirɨ ‘Emɨnɨ.’ urowáreɨ.” urayíagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","o re urɨŋɨnigɨnɨ, “Nionɨ émáyo arɨrá wimɨnɨrɨ bɨŋáonɨmanɨ. Gɨ́ Isɨrerɨyɨ́ —Ayɨ́ sipɨsipɨ́ xiáwo píránɨŋɨ́ mɨmearɨ́ná amɨ amɨ uniamoarɨŋɨ́nɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ. Ayɨ́ nánɨ bɨŋáonɨrɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","í aŋwɨ e nɨbɨrɨ xómɨŋɨ́ nɨyɨkwirɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, arɨrá niɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","o re urɨŋɨnigɨnɨ, “Nionɨ aiwá niaíwɨ́ narɨgɨ́ápɨ nurápɨrɨ sɨ́wíyo mɨnɨ wiarɨ́náyɨ́, jíxɨ ‘O naŋɨ́ yarɨnɨ.’ rɨyaiwiarɨŋɨnɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","í re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, wauyene sɨ́wínɨŋɨ́ imónɨŋagwɨ nánɨ nepa nɨrarɨŋɨnɨ. E nerɨ aí sɨ́wíyɨ́ xiáwo aiwá íkwiaŋwɨ́yo éɨ́ nɨŋweámáná aiwá nɨnɨrɨ yunɨ́ mamówárɨ́ éɨ́yɨ́ mɨmeánɨ́ yarɨŋɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","o re urɨŋɨnigɨnɨ, “Ineyɨ, jíxɨ aga dɨŋɨ́ xɨxenɨ nɨnɨkwɨ́rorɨ rarɨŋagɨ nánɨ jíxɨ simónɨ́ɨ́yɨ́ xɨxenɨ nimónɨnɨŋoɨ.” uráná re eŋɨnigɨnɨ. Xemiáí naŋɨ́ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisaso e dánɨ pɨ́nɨ nɨwiárɨmɨ nurɨ ipí Gaririwámɨ nɨpwerɨ dɨ́wɨ́ mɨŋɨ́yo nánɨ nɨyirɨ éɨ́ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ámá oxɨ́ apɨxɨ́ ayá wí o tɨ́ŋɨ́ e nánɨ nɨyoamiro wí sɨkwɨ́ ikɨ́ egɨ́áyo nɨméra yoaro sɨŋwɨ́ supárɨgɨ́áyo nɨméra yoaro xwɨyɨ́á marɨ́ maŋɨ́ pɨ́rónɨgɨ́áyo nɨméra yoaro sɨmɨxɨ́ xɨxegɨ́nɨ obaxɨ́ tɨ́gɨ́áyo nɨméra yoaro nero xegɨ́ sɨkwɨ́ tɨ́ŋɨ́ e tayarɨ́ná o naŋɨ́ imɨmɨxɨmɨ́ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Naŋɨ́ imɨmɨxɨmɨ́ wiarɨŋagɨ oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ maŋɨ́ pɨ́rónɨgɨ́áyɨ́ ámɨ xwɨyɨ́á rɨro eŋɨ́ kɨrɨŋɨ́ egɨ́áyɨ́ ámɨ ú úroro sɨkwɨ́ ikɨ́ egɨ́áyɨ́ ámɨ aŋɨ́ uro sɨŋwɨ́ supárɨgɨ́áyɨ́ ámɨ sɨŋwɨ́ anɨro yarɨŋagɨ́a nɨwɨnɨro ayá nɨrɨwamónɨro Ŋwɨ́á Isɨrerɨyɨ́yáomɨ yayɨ́ seáyɨ e umegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisaso xegɨ́ wiepɨsarɨŋowamɨ “Eɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá oxɨ́ apɨxɨ́ tɨyɨ́ nionɨ tɨ́nɨ sɨ́á wɨyaú rɨxa ŋweaŋwárɨnɨ. Wigɨ́ aiwá nɨpɨ́rɨ́yɨ́ meŋagɨ nánɨ nionɨ dɨŋɨ́ sɨpí niarɨnɨ. Nionɨ ayɨ́ agwɨ́ wiarɨ́ná nurowárɨrɨ́náyɨ́, óɨ́ e sɨŋwɨ́ xaxá upeyinɨgɨnɨrɨ nánɨ rarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Ámá dɨŋɨ́ meaŋɨ́ rɨmɨnɨyoɨ. Gɨmɨ nurane aiwá ámá none tɨ́nɨ epɨ́royɨ́ egɨ́á tɨyɨ́ nɨnɨro agwɨ́ ímɨ uyinɨ nánɨ urápanɨréwɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","o re urɨŋɨnigɨnɨ, “Soyɨ́né bisɨ́kerɨ́á ararɨ maxɨrɨŋoɨ?” urɨ́agɨ awa “Bisɨ́kerɨ́á wé wɨ́úmɨ dáŋɨ́ waú tɨ́nɨ peyɨ́ orá yeáyɨ́ bia tɨ́nɨrɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","o oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo “Xwɨ́áyo éɨ́ nɨŋweaxa úpoyɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bisɨ́kerɨ́á wé wɨ́úmɨ dáŋɨ́ waú apɨ tɨ́nɨ peyɨ́ apia tɨ́nɨ nurápɨrɨ Gorɨxomɨ yayɨ́ nɨwirɨ kwɨkwɨrɨmɨ́ nerɨ wiepɨsarɨŋowamɨ wiayíáná awa nurápɨro ámáyo yaŋɨ́ nɨwia úáná ");
INSERT INTO aak_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ayɨ́ nɨnɨro agwɨ́ ímɨ uyíagɨ wiepɨsarɨŋowa aiwá ayɨ́ nɨnɨro tɨ́ápia nɨmeamero soxɨ́ ɨ́á wé wɨ́úmɨ dáŋɨ́ waúmɨ magwɨ́ nɨmiro tɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Apɨxɨ́ tɨ́nɨ niaíwɨ́ tɨ́nɨ marɨ́áɨ, oxowa aiwá apɨ nɨ́áwa 4,000 imónɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisaso “Segɨ́ aŋɨ́ úpoyɨ.” nurowárɨmáná wiepɨsarɨŋowa tɨ́nɨ ewéyo nɨpɨxemoánɨro nuro Magadanɨ iwiékɨ́nɨmeagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi wa tɨ́nɨ Sajusi wa tɨ́nɨ Jisasomɨ nɨwímearo “O sɨmɨxɨ́yo naŋɨ́ imɨmɨxɨmɨ́ nerɨ aí ekɨyiŋɨ́ wí nepaxomanɨ.” nɨyaiwiro iwamɨ́ó owíwapɨyaneyɨnɨro re urɨgɨ́awixɨnɨ, “Joxɨ aŋɨ́namɨ dáŋɨ́ ekɨyiŋɨ́ bɨ neaíwapɨyiɨ.” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","o re urɨŋɨnigɨnɨ, “Seyɨ́né sɨ́ápɨ tɨ́nɨ yewaŋɨ́ eáagɨ nɨwɨnɨrɨ́ná re rarɨgɨ́áyɨ́nérɨnɨ, ‘Yewaŋɨ́ eáɨ́yɨ́ réwɨ́ enɨrɨ́enɨŋoɨ?’ rarɨgɨ́áyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wɨ́ápɨ tɨ́nɨ enɨ bɨramɨ dánɨ kɨpɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ́ná ‘Iniá yapɨnɨrɨ́enɨŋoɨ?’ rarɨgɨ́áyɨ́néxɨnɨ. Agwɨ́yo yewaŋɨ́ earɨ kɨpɨŋɨ́ yirɨ yarɨŋagɨ nɨwɨnɨróná xɨxenɨ ‘E nimónɨnɨŋoɨ.’ nɨrɨro aiwɨ amɨpí nionɨ sɨ́mɨmajɨ́ónɨŋɨ́ imɨxarɨŋápɨ sɨŋwɨ́ nɨnanɨróná ‘Gorɨxo e oyaiwípoyɨnɨrɨ rɨ́a neaíwapɨyarɨnɨ?’ mɨyaiwiarɨgɨ́áyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Agwɨ ríná ŋweagɨ́áyɨ́né, Gorɨxomɨ rɨ́wɨ́mɨnɨ nɨmamoro segɨ́ ŋwɨ́áɨ rɨnɨŋɨ́pɨ tɨ́nɨ ɨ́wɨ́nɨŋɨ́ niga uro niga bɨro yarɨgɨ́áyɨ́né, ekɨyiŋɨ́ nánɨ reaxɨ́ nɨseainɨrɨ seaimónarɨŋagɨ aiwɨ ekɨyiŋɨ́ wɨ́á rókiamoagɨ́ Jonao eŋɨ́pɨnɨ seaíwapɨyimɨgɨnɨ.” nurárɨmɨ pɨ́nɨ nɨwiárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wiepɨsarɨŋowa bisɨ́kerɨ́á bɨ nɨpɨ́rɨ nánɨ arɨ́á nikeamoro Jisaso tɨ́nɨ ipíyo jɨ́arɨwámɨnɨ nánɨ nuróná ");
INSERT INTO aak_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","o xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Soyɨ́né Parisiowa tɨ́nɨ Sajusiowa tɨ́nɨ awayá bisɨ́kerɨ́á nɨmɨga unɨ nánɨ imɨxarɨŋɨ́ yisoɨ rɨnɨŋɨ́pɨ nánɨ wáyɨ́ oseainɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","wiwanɨŋowa re rɨnɨgɨ́awixɨnɨ, “None bisɨ́kerɨ́á nɨmeámɨ mɨbɨ́wá eŋagɨ nánɨ o mɨxɨ́ nɨnearɨrɨ neararɨnɨ.” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisaso awa e rɨnarɨŋagɨ́a dɨŋɨ́ adadɨ́ nɨwirɨ re urɨŋɨnigɨnɨ, “Dɨŋɨ́ onɨmiápɨ nɨkwɨ́roarɨgɨ́oyɨ́né, pí nánɨ segɨ́pɨ re rɨnarɨŋoɨ, ‘None bisɨ́kerɨ́á nɨmeámɨ mɨbɨ́wá nánɨ neararɨnɨ.’ rɨnarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Soyɨ́né sɨnɨ nɨjɨ́á mimónɨpa reŋoɨ? Nionɨ bisɨ́kerɨ́á wé wúnɨ kwɨkwɨrɨmɨ́ éáná ámá 5,000 rɨxa apánɨ náná soyɨ́né ámɨ soxɨ́ ɨ́á ararɨyo miárɨgɨ́ápɨ nánɨ dɨŋɨ́ mɨseainarɨnɨranɨ? ");
INSERT INTO aak_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ámɨ bisɨ́kerɨ́á wé wɨ́úmɨ dáŋɨ́ waú ámá 4,000 nánɨ kwɨkwɨrɨmɨ́ éáná soyɨ́né soxɨ́ ɨ́á ararɨyo miárɨgɨ́ápɨ nánɨ enɨ dɨŋɨ́ mɨseainarɨnɨranɨ? ");
INSERT INTO aak_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Biaú nionɨ e éáná soyɨ́né soxɨ́ ɨ́á obaxɨ́yo miárɨgɨ́á eŋagɨ nánɨ nionɨ Parisiowa tɨ́nɨ Sajusiowa tɨ́nɨ yisɨ́ awayá nánɨ xɨxewisɨ́ ikaxɨ́ searáná arɨge nero ‘O aga bisɨ́kerɨ́á nánɨ mɨneararɨnɨ.’ mɨyaiwí yarɨŋoɨ? Nionɨ re seararɨŋɨnɨ, ‘Parisiowa tɨ́nɨ Sajusiowa tɨ́nɨ awayá yisɨ́ nánɨ wáyɨ́ oseainɨnɨ.’ seararɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","xegɨ́ wiepɨsarɨŋowa rɨxa re yaiwigɨ́awixɨnɨ, “Nepa yisɨ́ bisɨ́kerɨ́áyo táná nɨmɨga warɨŋɨ́pɨ nánɨ mɨneararɨnɨnɨ. Parisiowa tɨ́nɨ Sajusiowa tɨ́nɨ uréwapɨyarɨgɨ́ápɨ nánɨ mɨxɨ́dɨpa oépoyɨnɨrɨ neararɨnɨ.” yaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisaso pɨropenɨsɨ́ aŋɨ́ Sisaria Piripai tɨ́ŋɨ́mɨnɨ nurɨ nemerɨ́ná xegɨ́ wiepɨsarɨŋowamɨ iwamɨ́ó yarɨŋɨ́ re wiŋɨnigɨnɨ, “Oxɨ́ apɨxɨ́ nɨ́nɨ ámá imónɨŋáonɨ nánɨ goxɨnɨ rarɨŋoɨ?” yarɨŋɨ́ e wíagɨ ");
INSERT INTO aak_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","awa re urɨgɨ́awixɨnɨ, “Oxɨ́ apɨxɨ́ ‘Ámá eŋínaŋɨ́ wo nɨwiápɨ́nɨmearɨ rɨ́a yarɨnɨ?’ nɨyaiwiro nánɨ wí re rarɨŋoɨ, ‘Jono wayɨ́ nɨneameaia uŋorɨ́anɨ?’ rarɨŋoɨ. Ámɨ wí ‘Gorɨxoyá wɨ́á rókiamoagɨ́ mɨpé aŋɨ́namɨ nánɨ peyiŋo, Eraijaorɨ́anɨ?’ rarɨŋoɨ. Ámɨ wí ‘Wɨ́á rókiamoagɨ́ Jeremaiaorɨ́anɨ?’ rarɨŋoɨ. Ámɨ wí ‘Ayɨ́ wɨ́á rókiamoagɨ́áyɨ́ ámɨ worɨ́anɨ?’ rarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né enɨ nionɨ nánɨ goxɨnɨ yaiwiarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimonɨ Pitao re urɨŋɨnigɨnɨ, “Joxɨ Kiraisoxɨ, arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨrɨnɨ. Ŋwɨ́á anɨŋɨ́ sɨŋɨ́ imónɨŋomɨ xewaxoxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisaso re urɨŋɨnigɨnɨ, “Jonaomɨ xewaxoxɨ Saimonoxɨnɨ, joxɨ nɨrarɨŋɨ́pɨ ámá wo wɨ́á mɨrɨrókiamoŋoɨ. Gɨ́ ápo, aŋɨ́namɨ ŋweaŋo wɨ́á rɨrókiamóagɨ nánɨ joxɨ yayɨ́ osinɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rɨpɨ enɨ rɨrarɨŋɨnɨ, ‘Joxɨ sɨ́ŋánɨŋɨ́ nimónɨrɨ eŋɨ́ eánɨŋoxɨrɨnɨ. Sɨ́ŋá piárá eapɨnárɨŋɨ́ romɨ seáyɨ e ámá nionɨyá sɨyikɨ́ imónɨgɨ́áyɨ́ gɨ́ aŋɨ́ wiwánɨŋɨ́ mɨxárɨmɨ́árɨnɨ. Obo tɨ́nɨ imónɨgɨ́áyɨ́ eŋɨ́ neánɨro ámá pɨkipaxɨ́ imónɨgɨ́áyɨ́ aiwɨ nionɨ tɨ́nɨ imónɨgɨ́áyo wí xopɨrárɨ́ wipɨ́rɨ́ámanɨ.’ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gorɨxo tɨ́ŋɨ́ e páwipɨ́rɨ́a nánɨ rokɨ́ kínɨŋɨ́ imónɨŋɨ́ joxɨ siapɨmɨ́árɨnɨ. Joxɨ xwɨ́áyo re dánɨ ‘Ayɨ́ sɨpírɨnɨ.’ ránáyɨ́, Gorɨxo aŋɨ́namɨ dánɨ enɨ joxɨ sɨnɨ mɨrɨpa eŋáná o xámɨ ‘Ayɨ́ sɨpírɨnɨ.’ rɨnɨ́árɨnɨ. Joxɨ re dánɨ ‘Ayɨ́ ananɨrɨnɨ.’ ránáyɨ́, Gorɨxo xámɨ émɨ dánɨ enɨ ‘Ayɨ́ ananɨrɨnɨ.’ rɨnɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","xegɨ́ wiepɨsarɨŋowamɨ arɨ́á jɨyikɨ́ norɨ ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ámáyo nionɨ nánɨ ‘O yeáyɨ́ neayimɨxemeanɨ́a nánɨ negɨ́ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨnɨ.’ áwaŋɨ́ e murɨpanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Íná dánɨ o xegɨ́ wiepɨsarɨŋowamɨ sɨŋánɨ áwaŋɨ́ re nura uŋɨnigɨnɨ, “Gorɨxoyá dɨŋɨ́yo dánɨ nionɨ Jerusaremɨ nánɨ úáná negɨ́ Judayɨ́ ámɨnáowa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ xeanɨŋɨ́ wɨwí nikáráná wa nɨnɨpɨkíagɨ́a aiwɨ ámɨ sɨ́á wɨyaú wɨyi óráná Gorɨxoyá dɨŋɨ́yo dánɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitao Jisasomɨ xewi jɨ́amɨnɨ nɨmɨ́aumáná mɨxɨ́ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, oweoɨ! ‘Gorɨxoyá dɨŋɨ́yo dánɨ joxɨ nearɨ́ɨ́pɨ wí osípoyɨnɨrɨ sɨŋwɨ́ mɨranɨpa éwɨnɨgɨnɨ.’ nimónarɨnɨ. Wí nɨsimónɨnɨ́á menɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisaso Pitaomɨ rɨ́wɨ́ numorɨ re urɨŋɨnigɨnɨ, “Setenoxɨ, rɨ́wɨ́ rɨrɨwámɨnɨ nɨpuɨ. Joxɨ nionɨ nikɨrɨpeaánɨpaxɨ́ nikárɨmɨnɨrɨ nánɨ nɨrarɨŋɨnɨ. Joxɨ Gorɨxo dɨŋɨ́ wimónarɨŋɨ́yo nánɨ mamó ‘Jisaso rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ Jerusaremɨ dánɨ neameŋweaŋáná nionɨ seáyɨmɨ imónɨmɨnɨyɨ́rɨ́anɨ?’ nɨmorɨ nɨrarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","wiepɨsarɨŋɨ́ nowamɨnɨ re urɨŋɨnigɨnɨ, “Ámá ‘Jisasomɨ ouxɨ́dɨmɨnɨ.’ yaiwiarɨŋɨ́ goxɨ goxɨ re éɨrɨxɨnɨ. ‘Amɨpí nionɨ nɨgɨ́pɨ nánɨ oemɨnɨ.’ yaiwíɨ́yɨ́ dɨŋɨ́ peá nɨmorɨ re yaiwíɨrɨxɨnɨ, ‘Nionɨ Jisasomɨ xɨ́darɨŋagɨ nánɨ ámá wí nɨbɨro xeanɨŋɨ́ niro nɨpɨkiro nɨniro aí ayɨ́ ananɨrɨnɨ.’ nɨyaiwirɨ nɨxɨ́dɨ́ɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ámá Jisasomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xɨ́darɨ́ná nɨpɨkipɨ́rɨxɨnɨrɨ éɨ́ menarɨŋɨ́ goxɨ goxɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́ámanɨ. E nerɨ aiwɨ éɨ́ mɨmenɨpa nerɨ ‘Nionɨ Jisasomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xɨ́darɨŋagɨ nánɨ nɨnɨpɨkirónáyɨ́ ayɨ́ ananɨrɨnɨ.’ yaiwinarɨŋɨ́ goxɨ goxɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ámá wo nionɨ mɨnɨxɨ́dɨ́ iyɨ́á ɨ́á nɨgwɨ́ amɨpí emeámɨnɨrɨ nánɨnɨ néra nurɨ nɨmeáɨsáná xewanɨŋo anɨŋɨ́nɨ ikeamónáná oyá amɨpí anɨŋɨ́ nɨxɨrɨrɨ ŋweanɨ́árɨ́anɨ? Oweoɨ! Amɨpí nɨ́nɨ xwɨ́á tɨ́yo dáŋɨ́ nɨmearɨ aiwɨ xewanɨŋo anɨŋɨ́nɨ ikeamónáná amɨpí apɨ tɨ́nɨ anɨŋɨ́ ŋweanɨ́a nánɨ roayírónɨpaxɨ́ wí menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá imónɨŋáonɨ nikɨ́nɨmɨ nɨweapɨrɨ́ná xɨxɨ́eá gɨ́ ápo aŋɨ́namɨ inarɨŋɨ́pɨ aŋɨ́najowa tɨ́nɨ axɨ́pɨ niga nɨweapɨmáná nionɨ ámáyo neyírorɨ sɨpí yarɨgɨ́áyo xegɨ́ enɨ sɨpí wirɨ naŋɨ́ yarɨgɨ́áyo naŋɨ́ wirɨ emɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nepa seararɨŋɨnɨ. Woyɨ́né re rogɨ́á royɨ́né sɨnɨ mɨpepa egɨ́ámɨ eŋáná nionɨ woyɨ́né ámá imónɨŋáonɨ yeáyɨ́ nɨseayimɨxemearɨ xwioxɨ́yo mɨmeámɨ́ emɨ́a nánɨ nikɨ́nɨmɨ roŋáná woyɨ́né sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisaso e nurɨrɨ rɨxa sɨ́á wé wɨ́úmɨ dáŋɨ́ wo óráná Pitaomɨ tɨ́nɨ Jemisomɨ tɨ́nɨ xogwáo Jonomɨ tɨ́nɨ awamɨnɨ nɨwirɨmeámɨ dɨ́wɨ́ mɨŋɨ́ sepiá bimɨ nánɨ wigɨ́pɨ nɨyiro ");
INSERT INTO aak_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","nɨŋwearo Jisaso wiepɨsarɨŋɨ́ waú wo awa sɨŋwɨ́ anɨgɨ́e dánɨ re eŋɨnigɨnɨ. O xegɨ́ bɨ imónɨrɨ sɨ́mɨmaŋɨ́ oyá sogwɨ́nɨŋɨ́ anɨrɨ rapɨrapɨ́ oyá wɨ́á nókirɨ́ná xwɨnɨ́á eaárɨrɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","E éáná wɨ́á rókiamoagɨ́á waú Moseso tɨ́nɨ Iraijao tɨ́nɨ —Awaú eŋíná pegɨ́íwaúrɨnɨ. Awaú o tɨ́ŋɨ́ e aŋwɨ e nɨrónapɨri o tɨ́nɨ xwɨyɨ́á rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitao Jisasomɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, none re nɨŋwearɨ́ná naŋɨ́rɨnɨ. Nionɨ aŋɨ́ wíkaú wiwá re opákímɨnɨ. Joxɨ nánɨ wiwáyɨ. Moseso nánɨ wiwáyɨ. Iraijao nánɨ wiwáyɨ.” ");
INSERT INTO aak_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Agwɨ́ wɨ́á wúrárɨŋɨnigɨnɨ. Agwɨ́ wɨ́á wúráráná re eŋɨnigɨnɨ. Agwɨ́pimɨ dánɨ xwɨyɨ́á re rɨnɨŋɨnigɨnɨ, “Ayɨ́ oyɨ́ gɨ́ niaíwɨ́ dɨŋɨ́ sɨxɨ́ uyiŋáorɨnɨ. O amɨpí yarɨŋɨ́pɨ nánɨ nionɨ dɨŋɨ́ yayɨ́ ninarɨnɨ. O pí pí searánáyɨ́ arɨ́á wirɨ́ɨnɨ.” rɨnarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","wiepɨsarɨŋowa arɨ́á e nɨwiro xwɨ́ámɨ nɨpɨ́kínɨmearo wáyɨ́ nikárɨnɨro warɨ́ inɨŋáná ");
INSERT INTO aak_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisaso awa wegɨ́e aŋwɨ e nɨbɨrɨ wé seáyɨ e nɨwikwiárɨmáná re urɨŋɨnigɨnɨ, “Soyɨ́né wáyɨ́ mepanɨ. Wiápɨ́nɨmeápoyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","awa sagagɨ́ eméɨ́áyɨ́ Jisaso ámá wo tɨ́nɨ mɨró xegɨ́pɨ roŋagɨ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Awa dɨ́wɨ́ mɨŋɨ́ apimɨ pɨ́nɨ nɨwiárɨmɨ nɨwero Jisaso óɨ́ e dánɨ arɨ́á jɨyikɨ́ norɨ ŋwɨ́ ikaxɨ́ xaíwɨ́nɨ re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ sɨnɨ xwárɨpáyo dánɨ mɨwiápɨ́nɨmeapa eŋáná soyɨ́né éde sɨŋwɨ́ wɨnɨ́ápɨ nánɨ ámá wíyo áwaŋɨ́ murɨpa éɨ́rɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","wiepɨsarɨŋowa yarɨŋɨ́ re wigɨ́awixɨnɨ, “Negɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa pí nánɨ re rarɨgɨ́árɨnɨ, ‘Wɨ́á rókiamoagɨ́ Iraijao ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáomɨ xámɨ umeanɨ́árɨnɨ.’ pí nánɨ rarɨgɨ́árɨnɨ?” yarɨŋɨ́ e wíáná ");
INSERT INTO aak_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","o re urɨŋɨnigɨnɨ, “Iraijao nɨbɨrɨ ámá wigɨ́ dɨŋɨ́ wé rónɨŋɨ́ imónɨpɨ́rɨ nánɨ wáɨ́ nurɨmerɨ píránɨŋɨ́ imɨxɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","E nerɨ aí nionɨ re seararɨŋɨnɨ, ‘Ámá Iraijaónɨŋɨ́ imónɨŋɨ́ wo rɨxa bɨŋɨ́ eŋagɨ aiwɨ ayɨ́ “Xámɨ umeanorɨ́anɨ?” mɨyaiwí sɨŋwɨ́ mí mɨwómɨxɨpa nero wigɨ́ dɨŋɨ́yo dánɨ sɨ́mɨ́ tɨ́nɨ nɨwiro pɨkigɨ́awixɨnɨ. Ámá imónɨŋáonɨ enɨ axɨ́pɨ e nɨniro rɨ́nɨŋɨ́ niapɨpɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","xegɨ́ wiepɨsarɨŋowa “Jisaso e neararɨŋɨ́yɨ́ ayɨ́ Jono wayɨ́ nɨneameaia uŋo nánɨ rɨneararɨnɨ? Oyɨ, ayɨ́ orɨnɨ.” yaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","O tɨ́nɨ xegɨ́ wiepɨsarɨŋɨ́ waú wo awa tɨ́nɨ oxɨ́ apɨxɨ́ obaxɨ́ xegɨ́ wiepɨsarɨŋɨ́ wɨ́a tɨ́ŋɨ́ e epɨ́royɨ́ egɨ́e rémóáná ámá wo nɨbɨrɨ Jisasoyá sɨ́mɨmaŋɨ́mɨ dánɨ xómɨŋɨ́ nɨyɨkwirɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ámɨnáoxɨnɨ, gɨ́ íwo xóxwɨ́ nerɨ aga sɨpí ikeamónarɨnɨ. Wínɨ wíná rɨ́áyo ikeaárɨnɨrɨ iniɨgɨ́yo eámorɨ yarɨŋagɨ nánɨ joxɨ wá orunɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Joxɨ sɨnɨ émɨ ŋweaŋáná nionɨ dɨxɨ́ wiepɨsarɨŋowa tɨ́ŋɨ́ re nɨmeámɨ bɨ́agɨ aiwɨ awa naŋɨ́ mɨnimɨxɨyipa éɨ́á eŋagɨ nánɨ rɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisaso anɨŋɨ́ winɨ́agɨ re urɨŋɨnigɨnɨ, “Seyɨ́né agwɨ ríná ŋweagɨ́áyɨ́né dɨŋɨ́ nɨnɨkwɨ́roro mepa ero dɨŋɨ́ xeŋwɨ́nɨ moro yarɨgɨ́á tɨyɨ́né, ‘O íníná nene tɨ́nɨ nɨŋwearɨ arɨrá neainɨ́árɨnɨ.’ rɨyaiwiarɨŋoɨ? Nionɨ xwiogwɨ́ ararɨ re nɨŋwearɨ searéwapɨyarɨ́ná Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́roro eŋɨ́ eánɨŋɨ́ oyá gíná nɨjɨ́á imónɨpɨrɨ́árɨnɨ?” nurɨrɨ xanomɨ “Íwomɨ aŋwɨ re nɨmeámɨ beɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","rɨxa aŋwɨ e nɨmeámɨ báná Jisaso imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́ mɨxɨ́ umáɨnáná imɨ́ó pɨ́nɨ nɨwiárɨmɨ úáná íwo axíná naŋɨ́ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Rɨ́wɨ́yo wiepɨsarɨŋowa Jisaso xegɨ́pɨ ŋweaŋagɨ nɨwɨnɨro nɨbɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Pí nánɨ imɨ́ó íwomɨ dɨŋɨ́ xɨxéroarɨŋo none mɨxɨ́ umáɨnáná éɨ́ mú eŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","o re urɨŋɨnigɨnɨ, “Gorɨxomɨ dɨŋɨ́ onɨmiápɨ wɨkwɨ́roarɨŋagɨ́a nánɨ imɨ́ó o arɨ́á nɨseaimɨ muŋoɨ.” nurɨrɨ xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Nepa seararɨŋɨnɨ. Masɨté aiwá siyɨ́ negɨ́ omɨŋɨ́yo ɨwɨ́ urarɨŋwáyɨ́ aga onɨmiápɨ nerɨ aí rɨ́wéná nerápɨrɨ nɨrorɨ́ná íkɨ́ánɨŋɨ́ roarɨŋɨ́rɨnɨ. Segɨ́ dɨŋɨ́ Gorɨxomɨ wɨkwɨ́róɨ́áyɨ́ apɨ́nɨŋɨ́ nerɨ́náyɨ́, ‘Dɨ́wɨ́ mɨŋɨ́ rɨpɨxɨnɨ nurɨ wí e roɨ.’ uráná ananɨ arɨ́á nɨseaimɨ nurɨ wí e ropaxɨ́rɨnɨ. Soyɨ́né apɨ́nɨŋɨ́ nerɨ́náyɨ́, amɨpí wí mimɨxɨpaxɨ́ imónɨnɨ́ámanɨ. Nɨ́nɨ ananɨ epaxɨ́ imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","E nerɨ aí imɨ́ó eŋɨ́ eánɨŋɨ́ rónɨŋɨ́ imónɨŋɨ́yɨ́ Gorɨxomɨ yarɨŋɨ́ wirɨ aiwá ŋwɨ́á ŋwɨrárɨnɨrɨ nerɨ́nánɨ mɨxɨ́ umáɨnɨpaxɨ́rɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ Gariri pɨropenɨsɨ́yo awí neánɨróná o re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ nánɨ ámá wo mɨyɨ́ nurɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mɨyɨ́ nuráná awa nɨnɨpɨkiro aiwɨ ámɨ sɨ́á wɨyaú wɨyi weŋáonɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urɨ́agɨ nánɨ awa ayá sɨpí wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Awa rɨxa aŋɨ́ yoɨ́ Kapaneamɨyɨ rɨnɨŋɨ́pimɨ rémóáná ámá aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwá nánɨ nɨgwɨ́ xwé waú xwiogwɨ́ ayɨ́ ayo urápayarɨgɨ́áwa Pitaomɨ re urémeagɨ́awixɨnɨ, “Segɨ́ seaiepɨsarɨŋo aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨŋwáiwá nánɨ nɨgwɨ́ waú tarɨŋoranɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","o “Oyɨ.” nurɨmɨ nurɨ aŋɨ́yo nɨpáwirɨ Jisaso nánɨ e urɨ́ápɨ nánɨ áwaŋɨ́ murɨnɨŋáná Jisaso xámɨ xɨxewisɨ́ ikaxɨ́ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Saimonoxɨnɨ, dɨŋɨ́ joxɨyá arɨrerɨnɨ? Mɨxɨ́ ináyɨ́ xwɨ́á tɨ́yo meŋweagɨ́áyɨ́ ámáyo takisɨ́ nánɨ nɨgwɨ́ nurápɨróná wigɨ́ ámá imónɨgɨ́áyo uráparɨgɨ́áranɨ? Ámá xeŋwɨ́ wíyo uráparɨgɨ́áranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","o “Xeŋwɨ́yo uráparɨgɨ́árɨnɨ.” uráná Jisaso re urɨŋɨnigɨnɨ, “Ayɨnánɨ wigɨ́ imónɨgɨ́áyɨ́ takisɨ́ nánɨ áxeŋwarɨ́ inɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yawawi enɨ Gorɨxo mɨxɨ́ ináyɨ́ aŋɨ́namɨ meŋweaŋoyáwawi imónɨŋagwɨ́i nánɨ awa nɨgwɨ́ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwá nánɨ áxeŋwarɨ́ inɨpaxɨ́ mimónɨŋagɨ aiwɨ awa wikɨ́ dɨŋɨ́ yeaiwipɨ́rɨxɨnɨrɨ ipíwámɨ nánɨ nurɨ kipayá nɨmorɨ peyɨ́ iwamɨ́ó ápéomɨ maŋɨ́ ɨ́á neroámɨxɨmáná nɨgwɨ́ bɨ weŋagɨ wɨnɨrɨ́ɨnɨ. Nɨgwɨ́ apɨ nɨmeámɨ nurɨ joxɨ tɨ́nɨ nionɨ tɨ́nɨ nánɨ nawínɨ mɨnɨ yeawiɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Íná wiepɨsarɨŋowa “Noneyá negɨ́ wo seáyɨ e neaimónɨnɨ́o gorɨnɨ?” nɨyaiwiro Jisaso tɨ́ŋɨ́ e aŋwɨ e nɨbɨro re urɨgɨ́awixɨnɨ, “Joxɨ rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ neameŋweaŋáná noneyá wo go seáyɨ e neaimónɨnɨ́árɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","o niaíwɨ́ onɨmiá bimɨ “Eɨnɨ.” nurɨrɨ áwɨnɨ e nurárɨmáná ");
INSERT INTO aak_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ. Soyɨ́né dɨŋɨ́ ‘Ayo seáyɨ e omúrónɨmɨnɨ.’ yaiwiarɨgɨ́ápɨ dɨŋɨ́ yaíkiá mɨmopa ero niaíwɨ́ onɨmiánɨŋɨ́ mimónɨpa ero niaíwɨ́ ‘Ámá wo seáyɨ e nɨnimónɨrɨ́ná ayɨ́ ananɨrɨnɨ.’ yaiwiarɨgɨ́ápa axɨ́pɨ e mɨyaiwipa ero nerɨ́náyɨ́, aŋɨ́namɨ ŋweaŋoyá xwioxɨ́yo wí páwipaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ámá ‘Seáyɨ e imónɨŋáonɨmanɨ. Niaíwɨ́ rɨpɨ yapɨ imónɨŋɨnɨ.’ yaiwíɨ́á gɨyɨ́ gɨyɨ́ aŋɨ́namɨ ŋweaŋo xwioxɨ́yo mɨmeámɨ́ nerɨ meŋweanɨ́ápimɨ nɨpáwiro seáyɨ e imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gɨyɨ́ gɨyɨ́ nionɨ nɨnɨxɨ́dɨro nánɨ ámá niaíwɨ́ rɨpiamɨ́nɨŋɨ́ nɨmimónɨrónáyɨ́ ayɨ́ nionɨ enɨ́nɨŋɨ́ nɨmimónarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","E nerɨ aí ámá niaíwɨ́ rɨpiánɨŋɨ́ sɨnɨ dɨŋɨ́ nɨkwɨ́roanɨro yarɨgɨ́áyo mɨrɨrakɨ́ wiarɨgɨ́á gɨyɨ́ gɨyo Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ wikárɨnɨ́á eŋagɨ nánɨ sɨnɨ mɨrɨrakɨ́ mɨwinɨŋáná ámá wa sɨ́ŋá tɨ́nɨ siŋwɨ́yo gwɨ́ nɨjimáná rawɨrawáyo mamówáránáyɨ́ rɨ́nɨŋɨ́ xwé nɨwinɨrɨ aiwɨ Gorɨxo wimɨnɨrɨ eŋɨ́pɨ tɨ́nɨ xɨxenɨ mimónɨŋagɨ nánɨ ayɨ́ ananɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ámá wíyo óreámioápoyɨnɨrɨ wíwapɨyarɨgɨ́áyɨ́ aweyɨ! Sɨ́á wɨyi ayɨ́ majɨ́á wórɨnɨ́árɨnɨ. Gorɨxo xeanɨŋɨ́ wikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí wíwɨnɨgɨnɨ. Ámá wíyo óreámioápoyɨnɨrɨ wíwapɨyipɨ́rɨ́á aiwɨ ámá e wíwapɨyíɨ́áyɨ́ xeanɨŋɨ́ wímeanɨ́á eŋagɨ nánɨ aweyɨ! Sɨ́á wɨyi ayɨ́ majɨ́á wórɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dɨxɨ́ wéú tɨ́nɨranɨ, sɨkwú tɨ́nɨranɨ, ɨ́wɨ́ nánɨ nɨsimónɨrɨ́náyɨ́ ‘O rɨ́á anɨŋɨ́ wearɨŋɨ́yo nikeaárɨnɨgɨnɨ.’ nɨyaiwirɨ nɨwákwínɨrɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́náyɨ́, rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ wé rasɨ́á sɨkwɨ́ rasɨ́á eŋoxɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ nɨmearɨ́náyɨ́ ayɨ́ ananɨrɨnɨ. Mɨwákwínɨpa nerɨ wé núkaúnɨ tɨ́nɨ sɨkwɨ́ núkaúnɨ tɨ́nɨ sɨnɨ eŋánáyɨ́, o rɨ́áyo nɨsikeaárɨrɨ́ná ayɨ́ naŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dɨxɨ́ sɨŋwɨ́yi enɨ ‘Ɨ́wɨ́ apɨ eɨ.’ rɨránáyɨ́, ‘Gorɨxo rɨ́á anɨŋɨ́ wearɨŋɨ́yo nikeaárɨnɨgɨnɨ.’ nɨyaiwirɨ sɨŋwɨ́yi nɨyónɨrɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́náyɨ́, rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ sɨŋwɨ́ wɨ́onɨ anɨŋoxɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋwearɨ́a nánɨ nɨmearɨ́náyɨ́ ayɨ́ ananɨrɨnɨ. Mɨyónɨpa nerɨ sɨnɨ sɨŋwɨ́ nɨwaúnɨ tɨ́nɨ anɨŋánáyɨ́, Gorɨxo rɨ́áyo nɨsikeaárɨrɨ́ná ayɨ́ naŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Niaíwɨ́ onɨmiá rɨpia bimɨ peayɨ́ mɨwianɨpanɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ, ‘Aŋɨ́najɨ́ apiamɨ awí mearoarɨgɨ́áyɨ́ aŋɨ́namɨ Gorɨxoyá sɨ́mɨmaŋɨ́mɨnɨ ŋweaarɨŋagɨ́a nánɨ peayɨ́ wí mɨwianɨpanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá imónɨŋáonɨ ámá ɨ́wɨ́ néra nuro anɨŋɨ́ ikeamónanɨro yarɨgɨ́áyo nánɨ pɨ́á nerɨ yeáyɨ́ uyimɨxemeámɨnɨrɨ bɨŋáonɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","O xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Segɨ́ dɨŋɨ́ arɨrerɨnɨ? ‘Ámá wo xegɨ́ sipɨsipɨ́ 100 eŋáná wo anɨ́náná bɨ́bɨ 99 eŋɨ́pɨ dɨ́wɨ́yo nɨwárɨmɨ nurɨ wɨ́o nánɨ pɨ́á mepa enɨgɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ pɨ́á enɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ámɨ rɨxa nɨmearɨ́náyɨ́ nepa seararɨŋɨnɨ. Yayɨ́ sipɨsipɨ́ 99 manɨ́nɨŋɨ́pɨ nánɨ winarɨŋɨ́pɨ́nɨŋɨ́ winɨnɨ́ámanɨ. Anɨ́nɨ́o nánɨ aga yayɨ́ seáyɨmɨ dánɨ winɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Segɨ́ ápo, aŋɨ́namɨ ŋweaŋoyɨ́ enɨ ‘Niaíwɨ́ onɨmiá apia yapɨ imónɨgɨ́áyɨ́ wí oanɨ́nɨ́poyɨ.’ mɨyaiwinɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","O re urɨŋɨnigɨnɨ, “Ámá nionɨ nɨnɨxɨ́dɨro nánɨ rɨrɨxɨ́meá imónɨŋɨ́yɨ́ wo ɨ́wɨ́ sikáránáyɨ́, joxɨ nurɨ xegɨ́pɨ ŋweaŋagɨ nɨwɨnɨrɨ́ná joxɨ dɨxɨ́pɨ nɨwímearɨ ɨ́wɨ́ xɨ́o sikárɨ́ɨ́pɨ nánɨ yumɨ́í yarɨŋɨ́ wirɨ́ɨnɨ. O arɨ́á síánáyɨ́ joxɨ naŋɨ́ wimɨxɨ́agɨ nánɨ sɨnɨ rɨrɨxɨ́meá imónɨŋɨ́yɨ́ wónɨŋɨ́ nimónɨrɨ enɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","E nerɨ aí joxɨ arɨ́á mɨsipa yarɨŋagɨ nɨwɨnɨrɨ́náyɨ́, ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ nerɨ ámá wa re rɨpɨ́rɨ nánɨ, ‘None enɨ o yarɨŋɨ́ wíáná o “Oweoɨ, nionɨmanɨ.” rarɨŋagɨ arɨ́á wíwɨnɨ.’ rɨpɨ́rɨ nánɨ ámá waúmɨranɨ, womɨranɨ, nɨwirɨmeámɨ nurɨ obaxoyɨ́né ámɨ yarɨŋɨ́ wirɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O sɨnɨ arɨ́á mɨseaipa yarɨŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ́náyɨ́, ámá nionɨyá sɨyikɨ́ imónɨgɨ́áyo áwaŋɨ́ urɨrɨ́ɨnɨ. Ayo enɨ arɨ́á mɨwipa yarɨŋagɨ nɨwɨnɨrɨ́náyɨ́, re yaiwíɨ́rɨxɨnɨ, ‘Sɨnɨ nɨrɨxɨ́meáo wí mimónɨnɨ. Rɨxa émáyɨ́nɨŋɨ́ imónɨrɨ ámá takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́áwánɨŋɨ́ imónɨrɨ nerɨ wí eŋónɨŋɨ́ imónɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nepa seararɨŋɨnɨ. Seaiepɨsarɨŋáoyɨ́né xwɨ́áyo re dánɨ ‘Ayɨ́ sɨpírɨnɨ.’ ránáyɨ́, Gorɨxo aŋɨ́namɨ dánɨ enɨ soyɨ́né sɨnɨ mɨrɨpa eŋáná o xámɨ ‘Ayɨ́ sɨpírɨnɨ.’ rɨnɨ́árɨnɨ. Soyɨ́né re dánɨ ‘Ayɨ́ ananɨrɨnɨ.’ ránáyɨ́, Gorɨxo xámɨ émɨ dánɨ enɨ ‘Ayɨ́ ananɨrɨnɨ.’ rɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Rɨpɨ enɨ seararɨŋɨnɨ. Xwɨ́á tɨ́yo dánɨ soyɨ́néyá waú amɨpí wí nánɨ dɨŋɨ́ axɨ́pɨnɨ nɨmori gɨ́ ápo, aŋɨ́namɨ ŋweaŋomɨ yarɨŋɨ́ axɨ́pɨnɨ wíáná o arɨ́á nɨwirɨ xɨxenɨ e wimɨxɨyinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ámá nionɨyá imónɨgɨ́áyɨ́ waúnɨranɨ, waú wonɨranɨ, nionɨ seáyɨ e nɨmeanɨro nánɨ awí eánáná nionɨ áwɨnɨ e ŋweámɨ́á eŋagɨ nánɨ wigɨ́ dɨŋɨ́ axɨ́pɨ nɨmoro yarɨŋɨ́ wiarɨgɨ́ápɨ gɨ́ ápo arɨ́á nɨwirɨ xɨxenɨ wimɨxɨyinɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Íná Pitao nɨbɨrɨ Jisasomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ámá joxɨ nɨrɨxɨ́dɨrɨ nánɨ negɨ́ nɨrɨxɨ́meá wo ɨ́wɨ́ ararɨ nikáránáyɨ́, nionɨ enɨ xɨxenɨ xɨ́o nikárɨ́ɨ́pa yokwarɨmɨ́ wiimɨ́árɨnɨ? ‘Ɨ́wɨ́ wé wɨ́úmɨ dáŋɨ́ waú nikárɨ́ɨ́pɨ nánɨ yokwarɨmɨ́ nɨwiimáná eŋáná ámɨ wínɨ nikáráná yokwarɨmɨ́ wiipaxɨ́ menɨnɨ.’ nimónarɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ wé wɨ́úmɨ dáŋɨ́ waú apɨnɨ yokwarɨmɨ́ wiíánáyɨ́, ‘Ayɨ́ Apánɨrɨnɨ.’ rɨrɨmɨméɨnɨ. Joxɨ anɨŋɨ́ minɨ́ yokwarɨmɨ́ wiirɨ́a nánɨ rarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ámá Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́áyɨ́ anɨŋɨ́ minɨ́ yokwarɨmɨ́ wiíɨ́rɨxɨnɨrɨ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Gorɨxo, aŋɨ́namɨ meŋweaŋo, o mɨxɨ́ ináyɨ́ wo xegɨ́ omɨŋɨ́ wiiarɨgɨ́áyɨ́ wamɨ nɨgwɨ́ nɨwirɨ ‘Idáná awayá niapɨ́ɨ́rɨxɨnɨ.’ nɨyaiwirɨ nɨwimáná nɨŋweaŋɨsáná re eŋónɨŋɨ́ imónɨnɨ. O ‘Emá ayá wí rɨxa múroŋɨ́rɨnɨ. Agwɨ awa nɨbɨro awayá oniapɨ́poyɨ.’ ráná ");
INSERT INTO aak_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","awa nɨbɨro xɨ́oyá urápɨgɨ́ápɨ nánɨ awayá mɨnɨ nɨwirɨ́ná wo xɨ́oyá nɨgwɨ́ xwé ayá wí K10,000,000 urápɨŋo enɨ nɨbɨrɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","xɨ́oyá xɨxenɨ e mɨwipaxɨ́ eŋagɨ nánɨ mɨxɨ́ ináyo xegɨ́ wɨ́amɨ re urɨŋɨnigɨnɨ, ‘Nionɨ nɨgwɨ́ meámɨ nánɨ oyá iyɨ́á ɨ́á amɨpí nurápɨrɨ ámá wíyo bɨ́ époyɨ. O enɨ xiepí tɨ́nɨ niaíwɨ́ tɨ́nɨ ámá wayá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiipɨ́rɨ́a nánɨ bɨ́ nero nɨgwɨ́pɨ nɨmeámɨ nɨbɨro niapɨ́poyɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","K10,000,000 urápɨŋo mɨxɨ́ ináyoyá agwɨ́ rɨwámɨ dánɨ xwɨ́áyo nɨpɨ́kínɨmearɨ waunɨ́ nikárɨnɨrɨ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ niapɨŋɨ́pɨ nánɨ sɨnɨ dɨŋɨ́ nɨkwɨ́rorɨ yarɨŋɨnɨ. Rɨ́wéná nánɨ wenɨŋɨ́ nerɨ ŋweáɨrɨxɨnɨ. Nɨnímeááná joxɨ niapɨŋɨ́pa xɨxenɨ siapɨmɨ́árɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","mɨxɨ́ ináyo wá nɨwianɨrɨ nánɨ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ nionɨ siapɨŋápɨ nánɨ dɨŋɨ́ peá móɨnɨ. Joxɨ ananɨ uɨ.’ urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","omɨŋɨ́ wiiarɨŋo nɨpeyearɨ xegɨ́ wɨ́o ‘Rɨ́wéná oyá enɨ xɨxenɨ niapɨ́wɨnɨgɨnɨ.’ nɨyaiwirɨ K100 wiŋomɨ sɨŋwɨ́ nɨwɨnɨrɨ ɨ́á nɨxerɨ siŋwɨ́ ɨ́á nɨyámɨxɨrɨ re urɨŋɨnigɨnɨ, ‘Joxɨyánɨ rɨxa xɨxenɨ niapɨmɨnɨrɨ rɨyarɨŋɨnɨ?’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","xegɨ́ omɨŋɨ́ nawínɨ wiiarɨgɨ́ío xwɨ́áyo nɨpɨ́kínɨmearɨ waunɨ́ rɨxɨŋɨ́ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ joxɨ niapɨŋɨ́pɨ nánɨ sɨnɨ dɨŋɨ́ nɨkwɨ́rorɨ yarɨŋɨnɨ. Rɨ́wéná nánɨ wenɨŋɨ́ nerɨ ŋweáɨrɨxɨnɨ. Nɨnímeááná joxɨ niapɨŋɨ́pa xɨxenɨ siapɨmɨ́árɨnɨ.’ urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","wɨ́o ‘Rɨ́wéná niapɨ́wɨnɨgɨnɨ.’ mɨwimónɨ́agɨ ɨ́á nɨxɨrɨmɨ nurɨ gwɨ́ aŋɨ́yo nɨŋwɨrárɨrɨ porisɨ́yo re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ nionɨ wiŋápa xɨxenɨ niapáná ananɨ íkweawárɨ́ɨ́rɨxɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","mɨxɨ́ ináyoyá omɨŋɨ́ wiiarɨgɨ́á wɨ́a o e yarɨŋagɨ sɨŋwɨ́ nɨwɨnɨro ayá winɨ́agɨ nuro o éɨ́pɨ nánɨ mɨxɨ́ ináyomɨ áwaŋɨ́ uráná ");
INSERT INTO aak_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","mɨxɨ́ ináyo ‘Omɨŋɨ́ niiarɨŋo obɨnɨ.’ nurɨrɨ omɨ rɨxa nɨwirɨmeámɨ báná o re urɨŋɨnigɨnɨ, ‘Joxɨ omɨŋɨ́ niiarɨŋɨ́ sɨpíoxɨnɨ, joxɨ waunɨ́ rɨxɨŋɨ́ nɨrɨ́agɨ nánɨ nɨgwɨ́ ámɨ oyá niapɨ́wɨnɨgɨnɨrɨ siapɨŋápɨ nánɨ dɨŋɨ́ peá rɨmoíagɨ aiwɨ ámɨ joxɨ omɨŋɨ́ niiarɨgɨ́í wɨ́omɨ pí wikárɨ́ɨnigɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nionɨ ayá nɨrɨrɨmɨxɨrɨ “Dɨxɨ́ nɨgwɨ́ xe owenɨ.” rɨrɨ́agɨ aiwɨ joxɨ pí nánɨ dɨxɨ́ wɨ́omɨ ayá murɨmɨxɨpa éɨnigɨnɨ?’ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","wikɨ́ wónɨ́agɨ omɨ ɨ́á nɨxerɨ porisɨ́yo mɨnɨ nɨwirɨ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ nionɨ wiŋápa xɨxenɨ niapɨnɨ́e nánɨ iwaŋɨ́ nɨmépéa úɨ́rɨxɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámá nionɨ nɨnɨxɨ́dɨro nánɨ segɨ́ sérɨxɨ́meá imónɨgɨ́áyɨ́ ɨ́wɨ́ seaikárɨ́ápɨ yokwarɨmɨ́ mɨwiipa nerónáyɨ́, mɨxɨ́ ináyo xegɨ́ omɨŋɨ́ wiiarɨŋɨ́ sɨpíomɨ wiŋɨ́pa Gorɨxo enɨ axɨ́pɨ e seainɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisaso xwɨyɨ́á apɨ nɨpɨnɨ nurɨ́ɨsáná Gariri pɨropenɨsɨ́yo pɨ́nɨ nɨwiárɨmɨ nurɨ iniɨgɨ́ Jodanɨ rapáyo nɨxemorɨ Judia pɨropenɨsɨ́ arɨwámɨnɨ nemerɨ ");
INSERT INTO aak_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ámá oxɨ́ apɨxɨ́ obaxɨ́ númɨ uxɨ́darɨ́ná e sɨmɨxɨ́ tɨ́gɨ́áyo naŋɨ́ nɨwimɨxa warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi wa Jisaso mɨxɨ́ ináyɨ́ Xeroto meŋweaŋe emearɨŋagɨ nɨwɨnɨro “Jono wayɨ́ numeaia wago eŋɨ́pa xewanɨŋo xwɨyɨ́á nɨrɨrɨ́ná rɨ́á omeárɨnɨ.” nɨyaiwiro nɨbɨro iwamɨ́ó wíwapɨyanɨro nánɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Apɨxɨ́ pí pí nánɨ nɨpɨkwɨnɨ mɨyarɨŋagɨ nɨwɨnɨrɨ emɨ nɨmorɨ́náyɨ́, ayɨ́ ananɨranɨ? Xwɨyɨ́á tɨ́ŋɨ́ranɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisaso re urɨŋɨnigɨnɨ, “Bɨkwɨ́yo xwɨyɨ́á ‘Iwamɨ́ó amɨpí nɨ́nɨ nimɨxɨrɨ́ná oxɨ́ tɨ́nɨ apɨxɨ́ tɨ́nɨ imɨxɨŋɨ́rɨnɨ.’ rɨnɨŋɨ́pɨ soyɨ́né ɨ́á nɨroro aiwɨ sɨnɨ nɨjɨ́á mimónɨpa reŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Imɨxɨŋo xwɨyɨ́á ‘Ayɨnánɨ oxo xanɨyaúmɨ pɨ́nɨ nɨwiárɨmáná xegɨ́ apɨxí tɨ́nɨ nɨkumɨxɨnɨríná ná ayɨ́ ná bɨnɨ́nɨŋɨ́ imónɨpɨsɨ́írɨnɨ.’ rɨŋɨ́pɨ enɨ ɨ́á nɨroro aí sɨnɨ nɨjɨ́á mimónɨpa reŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","E nɨrɨnɨrɨ eánɨŋagɨ nánɨ ayaú xɨxegɨ́nɨ imónarɨgɨ́ímanɨ. Ná ayɨ́ ná bɨnɨ́nɨŋɨ́ nimónɨri emearɨgɨ́írɨnɨ. Ayaú meánɨpɨsíi nánɨ Gorɨxo ŋwɨrárɨŋɨ́ eŋagɨ nánɨ wí emɨ mɨmónɨpa yanɨgɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisiowa re urɨgɨ́awixɨnɨ, “Joxɨ neararɨŋɨ́pɨ nepa eŋánáyɨ́, Moseso ŋwɨ́ ikaxɨ́ nɨwurɨyirɨ rɨ́wamɨŋɨ́ nearɨ́ná pí nánɨ re nɨrɨrɨ eaŋɨ́rɨnɨ, ‘Dɨxɨ́ apɨxímɨ emɨ nɨmorɨ́ná “Ímɨ anɨŋɨ́ emɨ móárɨnɨ.” nɨrɨrɨ payɨ́ e nearɨ wiowárɨ́ɨrɨxɨnɨ.’ Moseso pí nánɨ e rɨŋɨ́rɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né arɨ́kí apɨxɨ́ emɨ moanɨro yarɨŋagɨ́a nɨseanɨrɨ nánɨ xe emɨ omópoyɨnɨrɨ sɨŋwɨ́ nɨseanɨrɨ aiwɨ iwamɨ́ó Gorɨxo xwɨ́á imɨxɨŋe dánɨ wí e eŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nionɨ re seararɨŋɨnɨ, ‘Go go xegɨ́ apɨxɨ́ xámɨŋímɨ emɨ nɨmorɨ sɨwɨ́ piaxɨ́ weánarɨŋɨ́pɨ nánɨ marɨ́áɨ, ámɨ sɨŋɨ́ wí nɨmearɨ́ná ayɨ́ ɨ́wɨ́ inarɨŋiɨ.’ seararɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","xegɨ́ wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “‘Ámá apɨxɨ́ nɨmeámáná emɨ mopaxɨ́ mimónɨpa eŋánáyɨ́, apɨxɨ́ mɨmeapa nerɨ́ná naŋɨ́ imónɨpaxɨ́rɨnɨ.’ neaimónarɨnɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","o re urɨŋɨnigɨnɨ, “Soyɨ́né rɨ́ápɨ naŋɨ́ e nimónɨrɨ aiwɨ ámá nɨ́nɨ dɨŋɨ́ axɨ́pɨ soyɨ́né yaiwíɨ́ápa yaiwipɨ́rɨméoɨ. Sa ámá wínɨ wínɨ Gorɨxoyá dɨŋɨ́yo dánɨ e yaiwipaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Oxowa apɨxɨ́ mɨmeapa epaxɨ́ imónɨŋɨ́yɨ́ mɨ́kɨ́ xɨxegɨ́nɨrɨnɨ. Wa xɨnáí agwɨ́yo dánɨ piáɨ́ mayɨ́ xɨrɨŋɨ́ nánɨ apɨxɨ́ mɨmeapa epaxɨ́ imónɨŋoɨ. Wa piáwɨ́ yónɨŋagɨ nánɨ ayɨ́ awa enɨ mɨmeapaxɨ́ imónɨŋoɨ. Wa Gorɨxo nánɨ wáɨ́ urɨmepɨ́rɨ nánɨ éɨ́áwa wigɨ́ dɨŋɨ́yo dánɨ enɨ apɨxɨ́ mɨmeapaxɨ́ imónɨŋoɨ. E nerɨ aí ‘Gorɨxo nánɨ wáɨ́ nurɨmerɨ́ná apɨxɨ́ mayonɨ éɨmɨgɨnɨ.’ yaiwiarɨŋɨ́ go go sa e yaiwíwɨnɨgɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ámá wí wigɨ́ niaíwɨ́piamɨ Jisaso wé seáyɨ wikwiárɨrɨ xwé imónɨpɨ́rɨ nánɨ Gorɨxomɨ yarɨŋɨ́ wirɨ oenɨrɨ nɨmeámɨ barɨŋagɨ́a wiepɨsarɨŋowa sɨŋwɨ́ e nɨwɨnɨro mɨxɨ́ urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisaso re urɨŋɨnigɨnɨ, “Niaíwɨ́pia xe obɨ́poyɨ. Ámá niaíwɨ́ onɨmiápia xanɨyaúmɨ dɨŋɨ́ nɨwɨkwɨ́roro yarɨgɨ́ápa Gorɨxomɨ dɨŋɨ́ wɨkwɨ́róɨ́áyɨ́ o xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́á eŋagɨ nánɨ niaíwɨ́pia xe obɨ́poyɨnɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ. Pɨ́rɨ́ mɨwiaíkipa époyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","apiamɨ wé seáyɨ e ikwɨkwiárɨmɨ́ nɨwimáná e dánɨ pɨ́nɨ nɨwiárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jisaso e dánɨ warɨ́ná re eŋɨnigɨnɨ. Ámá wo nɨbɨrɨ re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, nionɨ pí naŋɨ́yɨ́ nerɨ́ná dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ íníná ŋweámɨ́a nánɨ imónɨmɨ́árɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ pí nánɨ naŋɨ́yɨ́ nánɨ yarɨŋɨ́ niarɨŋɨnɨ? Gorɨxo ná wonɨ naŋɨ́ imónɨŋagɨ nánɨ joxɨ apɨ nánɨ dɨŋɨ́ rɨmoarɨŋɨnɨ? E nerɨ aí joxɨ ‘Dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ íníná ŋweámɨ́a nánɨ oimónɨmɨnɨ.’ nɨyaiwirɨ́náyɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo xɨ́dɨrɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ámáo re urɨŋɨnigɨnɨ, “Pí ŋwɨ́ ikaxɨ́ eánɨŋɨ́yɨ́ nánɨ nɨrarɨŋɨnɨ?” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Re nɨrɨnɨrɨ eánɨŋɨ́pɨ ‘Nɨwiápɨ́nɨmearɨ ámá mɨpɨkipa erɨ́ɨnɨ. Ámá wí tɨ́nɨ ɨ́wɨ́ minɨpa erɨ́ɨnɨ. Ɨ́wɨ́ mɨmeapa erɨ́ɨnɨ. Ámá wo nánɨ xwɨyɨ́á nɨyimárónɨrɨ yapɨ́ murɨpa erɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Dɨxɨ́ ápomɨ tɨ́nɨ inókímɨ tɨ́nɨ wéyo umerɨ́ɨnɨ. Ámá wíyo jɨwanɨŋoxɨ nánɨ dɨŋɨ́ sɨpí nɨsirɨ menarɨŋɨ́pa axɨ́pɨ e wirɨ́ɨnɨ.’ E nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨ́dɨrɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ámáo re urɨŋɨnigɨnɨ, “Apɨ nɨpɨnɨ nionɨ xɨ́darɨŋárɨnɨ. Nionɨ bɨ sɨnɨ mepa eŋáyɨ́ gɨpɨrɨ́anɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ ‘Píránɨŋɨ́ oimónɨmɨnɨ.’ nɨsimónɨrɨ́náyɨ́, nurɨ dɨxɨ́ iyɨ́á ɨ́á amɨpí nɨgwɨ́ nánɨ bɨ́ nerɨ nɨgwɨ́ nɨmearɨ́ná ámá uyípeayɨ́yo mɨnɨ nɨwimáná nɨbɨrɨ nionɨ nɨxɨ́dɨ́ɨrɨxɨnɨ. E nerɨ́náyɨ́, amɨpí ayá tɨ́ŋɨ́pɨ Gorɨxo aŋɨ́namɨ joxɨ nánɨ awí eámeámɨ́ siárinɨ́árɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jisaso e urɨ́agɨ o arɨ́á nɨwirɨ amɨpí xwé tɨ́ŋo eŋagɨ nánɨ xegɨ́ xwioxɨ́yo dánɨ dɨŋɨ́ rɨ́á uxéagɨ nánɨ dɨŋɨ́ sɨpí nɨyaiwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisaso xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Nionɨ aga nepa seararɨŋɨnɨ. Amɨpí mɨmúrónɨgɨ́áyɨ́ Gorɨxo ámá xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́e opáwianeyɨnɨrɨ anɨŋɨ́ minɨ́ nero aiwɨ nɨpáwipaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rɨpɨ enɨ seararɨŋɨnɨ, ‘Kamerɨ́ eŋɨ́ rapɨrapɨ́ gwɨ́ kiwearɨgɨ́á óɨ́yimɨ páwipaxɨ́ mimónɨnɨ. Ámá amɨpí mɨmúrónɨgɨ́áyɨ́ kamerɨ́ eŋɨ́ óɨ́yi mɨpáwipa yarɨŋɨ́yɨ́ yapɨ aŋɨ́namɨ ŋweaŋoyá xwioxɨ́yo páwipaxɨ́ mimónɨŋoɨ.’ seararɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","wiepɨsarɨŋɨ́yɨ́ —Judayɨ́ nɨ́nɨ “Amɨpí mɨmúrónɨgɨ́áyɨ́ Gorɨxoyá dɨŋɨ́ tɨ́nɨ amɨpí meaarɨŋagɨ́a nánɨ Gorɨxo yayɨ́ winarɨnɨ.” yaiwiagɨ́árɨnɨ. Wiepɨsarɨŋɨ́yɨ́ enɨ e nɨyaiwiro nánɨ Jisaso e urɨ́agɨ arɨ́á nɨwiróná ududɨ́ nɨwikárɨnɨro omɨ re urɨgɨ́awixɨnɨ, “Joxɨ rɨ́ɨ́yɨ́ nepa eŋánáyɨ́, Gorɨxo ámá gɨyo yeáyɨ́ uyimɨxemeanɨ́árɨ́anɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisaso sɨŋwɨ́ agwɨ́ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Ámá wigɨ́ dɨŋɨ́ tɨ́nɨ Gorɨxoyá xwioxɨ́yo páwipaxɨ́ mimónɨnɨ. E nerɨ aí Gorɨxo amɨpí mepa epaxɨ́ wí mimónɨŋagɨ nánɨ oyá dɨŋɨ́ jɨ́ayɨ́ tɨ́nɨ ayɨ́ aí ananɨ páwipaxɨ́ imónɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitao Jisaso ámáomɨ “Dɨxɨ́ iyɨ́á ɨ́á amɨpí nɨgwɨ́ nánɨ bɨ́ nerɨ uyípeayɨ́yo mɨnɨ nɨwia numáná nɨnɨxɨ́dɨrɨ́náyɨ́, Gorɨxo aŋɨ́namɨ amɨpí ayá tɨ́ŋɨ́pɨ rɨtinɨ́árɨnɨ.” urɨ́ɨ́pɨ nánɨ dɨŋɨ́ nɨmorɨ Jisasomɨ re urɨŋɨnigɨnɨ, “Arɨ́á eɨ. Amɨpí noneyá nɨ́nɨ rɨxa pɨ́nɨ nɨwiárɨmɨ joxɨ rɨxɨ́darɨŋwáyɨ́ pí meanɨ́wárɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ. Gorɨxo xwɨ́á sɨŋɨ́ wɨrí imɨxáná ámá imónɨŋáonɨ rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ meŋweaŋáná soyɨ́né enɨ negɨ́ Isɨrerɨyɨ́ gwɨ́ wɨrɨ́ wɨrí wé wúkaú sɨkwɨ́ waú eŋɨ́yo xɨráowayɨ́nénɨŋɨ́ nimónɨro mí ómómɨxɨmɨ́ nero meŋweapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ámá gɨyɨ́ gɨyɨ́ nionɨ nɨnɨxɨ́dɨro nánɨ wigɨ́ aŋiwámɨranɨ, xexɨrɨ́meáowamɨranɨ, xexɨrɨ́meáíwamɨranɨ, xanomɨranɨ, xɨnáímɨranɨ, niaíwɨ́yoranɨ, xegɨ́ omɨŋɨ́ranɨ, pɨ́nɨ nɨwiárɨrɨ́ná wigɨ́ amɨpí pɨ́nɨ nɨwiárɨmɨ uɨ́ápimɨ Gorɨxo wíɨ́pɨ aga seáyɨ e múrónɨnɨ́árɨnɨ. Ayɨ́ enɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ anɨŋɨ́ ŋweapɨ́rɨ́a nánɨ meapɨ́rɨ́árɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","nurɨrɨ wiepɨsarɨŋowa “None Jisasomɨ xámɨ xɨ́darɨŋagwɨ nánɨ seáyɨ e imónɨŋwɨnɨ.” yaiwipɨ́rɨxɨnɨrɨ re urɨŋɨnigɨnɨ, “Agwɨ ríná xámɨ xámɨ imónɨ́áyɨ́ rɨ́wéná surɨ́má imónɨpɨ́rɨ́árɨnɨ. Agwɨ ríná surɨ́má imónɨ́áyɨ́ xámɨ imónɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisaso ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Aŋɨ́namɨ ŋweaŋo ámá xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́áyo yaŋɨ́ numeirɨ́ná ayɨ́ mɨraxwɨ́ rónɨŋɨ́ imónɨnɨ. O wɨ́á mónɨŋɨ́mɨ 6:00 a.m. imónáná ámá xegɨ́ wainɨ́ omɨŋɨ́yo wiipɨ́rɨ wirɨmeámɨnɨrɨ nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ámá wa ‘Sɨ́á rɨyimɨ nánɨ xɨxegɨ́nɨ íkwɨ́ wɨna neaiapáná omɨŋɨ́ siianɨ́wɨnɨ.’ urɨ́agɨ́a xegɨ́ omɨŋɨ́yo nánɨ urowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ámɨ 9:00 a.m. imónáná awí eánarɨgɨ́e nánɨ nurɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Wa re kikiɨ́á riwa roŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","re urɨŋɨnigɨnɨ, ‘Soyɨ́né enɨ gɨ́ omɨŋɨ́ niipɨ́rɨ nánɨ úpoyɨ. Sɨ́ápɨ tɨ́nɨ soyɨ́né omɨŋɨ́ niíɨ́ápɨ nánɨ nɨgwɨ́ xɨxenɨ seaiapɨmɨ́ɨnɨ.’ urɨ́agɨ awa enɨ nuro omɨŋɨ́ wiigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ámɨ sogwɨ́ áwɨnɨ e eŋáná rɨxa 12:00 imónáná nurɨ ámɨ wa e kikiɨ́á roŋagɨ́a nɨwɨnɨrɨ axɨ́pɨ e urowárɨŋɨnigɨnɨ. Ámɨ 3:00 p.m. imónáná axɨ́pɨ e eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ámɨ rɨxa 5:00 p.m. aŋwɨ e imónáná nurɨ ámɨ wa e kikiɨ́á roŋagɨ́a nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, ‘Sɨ́á rɨyi nɨyimɨnɨ pí nánɨ kikiɨ́á re roŋoɨ?’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","awa re urɨgɨ́awixɨnɨ, ‘Ámá wo “Nɨgɨ́ omɨŋɨ́ niípoyɨ.” mɨnearɨ́one eŋagɨ nánɨ roŋwɨnɨ.’ urɨ́agɨ́a o re urɨŋɨnigɨnɨ, ‘Soyɨ́né enɨ omɨŋɨ́ niipɨ́rɨ gɨ́ wainɨ́ omɨŋɨ́yo nánɨ úpoyɨ.’ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sɨ́ápɨ tɨ́nɨ wainɨ́ omɨŋɨ́ xiáwo bosɨwomɨ re urɨŋɨnigɨnɨ, ‘Joxɨ omɨŋɨ́ niiarɨgɨ́áwamɨ “Eɨnɨ.” nurɨrɨ nɨgwɨ́ mɨnɨ nɨwirɨ́ná rɨ́wɨ́yo úɨ́áwamɨ nɨwia nurɨ xámɨ úɨ́áwamɨ nɨwirɨ pɨ́nɨ wiáreɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","o nurɨ mɨraxwo urɨ́ɨ́pa yarɨ́ná ámá 5:00 p.m. dánɨ úɨ́áwa nɨbɨrɨ́ná xɨxegɨ́nɨ íkwɨ́ wɨnánɨ wɨnánɨ nɨmeáa ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ámá wɨ́á mónɨŋɨ́mɨ dánɨ úɨ́áwa nɨbɨrɨ́ná nɨgwɨ́ seáyɨ e meapɨ́ráoɨnɨrɨ éɨ́áyɨ́ awa enɨ xɨxenɨ axɨ́pɨ íkwɨ́ wɨnánɨ wɨnánɨ nɨmeáa ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Íkwɨ́ wɨnánɨ wɨnánɨ nɨmeáa nurɨ́ná mɨraxwo omɨŋɨ́ xiáwo nánɨ anɨŋúmɨ́ ikaxɨ́ nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","omɨ re urɨgɨ́awixɨnɨ, ‘Sɨ́ápɨ tɨ́nɨ nuro omɨŋɨ́ onɨmiápɨ éɨ́áwamɨ none wɨ́á mónɨŋɨ́mɨ dánɨ nurane yarɨ́ná sogwɨ́ xaíwɨ́ neanarɨ́one tɨ́nɨ xɨxenɨ pí nánɨ mɨnɨ wíɨnɨ?’ urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","o awayá womɨ re urɨŋɨnigɨnɨ, ‘Gɨ́ ámaé, nionɨ sɨpí wí mɨsikárɨ́ɨnɨ. Joxɨ wɨ́á mónɨŋɨ́mɨ dánɨ re mɨnɨrɨpa réɨnigɨnɨ, “Joxɨ íkwɨ́ wɨna niapɨrɨ nánɨ omɨŋɨ́ siimɨ́ɨnɨ.” mɨnɨrɨpa réɨnigɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɨgwɨ́ nionɨ siapɨ́á dɨxɨ́pɨ nɨmeámɨ uɨ. Ámá sɨ́ápɨ tɨ́nɨ éɨ́ ro “Nɨgwɨ́ xɨxenɨ axɨ́pɨ owimɨnɨ.” nimónɨ́agɨ nánɨ joxɨ siapɨ́ápa axɨ́pɨ mɨnɨ wíɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Amɨpí nionɨ gɨ́yɨ́ niɨwanɨŋonɨ dɨŋɨ́ tɨ́nɨ nɨwirɨ́náyɨ́, “Ayɨ́ nɨpɨkwɨnɨmanɨ.” rɨniaiwiarɨŋɨnɨ? Nionɨ yaŋɨ́ ewaniɨ́ nimónɨrɨ yarɨŋagɨ nánɨ joxɨ sɨpí dɨŋɨ́ rɨniaiwiarɨŋɨnɨ?’ urɨŋɨnigɨnɨ.” Jisaso “None xámɨ xɨ́darɨŋagwɨ aí rɨ́wɨ́yo xɨ́dɨ́áyɨ́ tɨ́nɨ xɨxenɨ neaiapɨnɨ́árɨ́anɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á apɨ nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","re urɨŋɨnigɨnɨ, “Agwɨ ríná xámɨ xámɨ imónɨ́áyɨ́ rɨ́wéná surɨ́má imónɨpɨ́rɨ́árɨnɨ. Agwɨ ríná surɨ́má imónɨ́áyɨ́ xámɨ imónɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisaso óɨ́ Jerusaremɨ nánɨ warɨgɨ́áyo umɨnɨrɨ nánɨ nerɨ́ná xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ nɨwirɨmeámɨ ná dámɨne onɨmiápɨ óɨ́ e nuróná re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Arɨ́á époyɨ. Rɨxa Jerusaremɨ nánɨ warɨŋwɨnɨ. E rémóáná ámá imónɨŋáonɨ nánɨ mɨyɨ́ uráná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ xwɨyɨ́á nɨnɨmearɨróná nionɨ nánɨ re rɨnɨpɨ́rɨ́árɨnɨ, ‘Ámá romɨ opɨkípoyɨ.’ nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","émáyɨ́ nionɨ rɨperɨrɨ́ nɨmearɨro sɨkwɨ́á ragɨ́ pɨ́rɨ́ nuyɨkiro íkɨ́áyo nɨyekwɨroárɨro epɨ́rɨ nánɨ mɨnɨ nɨnɨwiro aiwɨ sɨ́á wɨyaú wɨyi óráná xwárɨpáyo dánɨ ámɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jerusaremɨ nánɨ óɨ́yo warɨ́ná Sebediomɨ xewaxowaú —Ayɨ́ Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨrɨnɨ. Awaú tɨ́nɨ xɨnáí tɨ́nɨ “Jisaso rɨxa Jerusaremɨ nɨrémorɨ́ná mɨxɨ́ ináyɨ́ nimónɨrɨ neameŋweanɨyɨ́rɨ́anɨ?” nɨyaiwiro nɨbɨro waunɨ́ rɨxɨŋɨ́ uranɨro nánɨ mɨŋɨ́ xwɨ́áyo ɨkwɨ́róagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisaso re urɨŋɨnigɨnɨ, “Sepɨ́oyɨ́né o pí oneainɨrɨ niarɨŋoɨ?” urɨ́agɨ í xegɨ́ niaíwowaú wiepɨsarɨŋɨ́ wɨ́amɨ seáyɨ e owimónɨ́piyɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ neameŋweaŋáná gɨ́ niaíwɨ́ rowaú wɨ́o wé náúmɨ dánɨ ŋwearɨ wɨ́o wé onamɨŋúmɨ dánɨ ŋwearɨ epɨsɨ́i nánɨ reɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisaso re urɨŋɨnigɨnɨ, “Sepɨ́oyɨ́né yarɨŋɨ́ niarɨgɨ́ápɨ nánɨ nɨjɨ́á mimónɨpa nero nánɨ yarɨŋɨ́ niarɨŋoɨ.” nurɨrɨ ewayɨ́ ikaxɨ́ ámá wa xɨ́omɨ pɨkipɨ́rɨ́á eŋagɨ nánɨ áwaŋɨ́ nurɨrɨ́ná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awagwí iniɨgɨ́ sɨxɨ́ nionɨ nɨmɨ́áwá ananɨ nɨpaxɨ́ imónɨpɨsɨ́íranɨ?” urɨ́agɨ awaú re urɨgɨ́isixɨnɨ, “Ananɨ nɨpaxowawirɨnɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","o re urɨŋɨnigɨnɨ, “Iniɨgɨ́ nionɨ nɨmɨ́áwá awagwí enɨ nɨpɨsɨ́írɨnɨ. E nerɨ aí ‘Wɨ́oxɨ rɨ́mɨ dánɨ ŋweaɨ. Wɨ́oxɨ rɨ́mɨ dánɨ ŋweaɨ.’ wí earɨpaxɨ́ mimónɨŋɨnɨ. Waú gowaú mɨdɨmɨdánɨ ŋweapɨsɨ́i nánɨ gɨ́ ápo rɨxa rárɨŋɨ́rɨnɨ. Ayɨnánɨ nionɨ e earɨpaxɨ́ wí menɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","wiepɨsarɨŋɨ́ wé wúkaú wɨ́a awaú Jisasomɨ yarɨŋɨ́ e wíagɨ́i arɨ́á nɨwiro nánɨ wikɨ́ dɨŋɨ́ wiaiwiarɨŋagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisaso xɨ́o tɨ́ŋɨ́ e nánɨ “Eɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né nɨjɨ́árɨnɨ. Émáyɨ́yá ámá ámɨná meŋweagɨ́áwa seáyɨ e nɨwimónɨro paimɨmɨ́ wiarɨgɨ́árɨnɨ. Wigɨ́ ámá eŋɨ́ rɨŋɨ́ meŋweagɨ́áwa enɨ seáyɨ e nɨwimónɨro ‘Xe nonenɨnɨ sɨmaŋwɨ́yónɨŋɨ́ yeáyɨ́ oneaurónɨ́poyɨ.’ nɨyaiwiro yarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","‘Awa seáyɨ e nɨwimónɨro yarɨgɨ́ápa soyɨ́né enɨ axɨ́pɨ nimónɨro mepa oépoyɨ.’ nimónarɨnɨ. ‘Gɨ́ wɨ́amɨ seáyɨ e oimónɨmɨnɨ.’ yaiwinarɨŋɨ́ goxɨ goxɨ awayá omɨŋɨ́ wiiarɨŋoxɨ́nɨŋɨ́ wimóneɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Neaiepɨsarɨŋone wonɨ xámɨ xámɨ oimónɨmɨnɨ.’ yaiwinarɨŋɨ́ goxɨ goxɨ ámá wí joxɨ nánɨ re rɨpɨ́rɨ nánɨ, ‘O wiepɨsarɨŋɨ́ wɨ́amɨ xɨnáínɨŋɨ́ nimónɨrɨ arɨrá wiarɨnɨ.’ rɨpɨ́rɨ nánɨ joxɨ e erɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ámá imónɨŋáonɨ yarɨŋápa axɨ́pɨ éɨ́rɨxɨnɨ. Nionɨ ámá wí arɨrá níɨ́rɨxɨnɨrɨ bɨŋámanɨ. Nionɨ ámá nɨyonɨ arɨrá wirɨ nionɨ nupeirɨ́ná gwɨ́nɨŋɨ́ uroayírorɨ emɨnɨrɨ bɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","O tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ aŋɨ́ yoɨ́ Jerikoyɨ rɨnɨŋɨ́yo dánɨ warɨ́ná oxɨ́ apɨxɨ́ ayá wí númɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","re eŋɨnigɨnɨ. Ámá sɨŋwɨ́ supárɨgɨ́íwaú óɨ́ maŋɨ́pá tɨ́nɨ ŋweagɨ́íwaú “Jisaso rimanɨ pwarɨnɨ.” rɨnarɨŋagɨ́a arɨ́á nɨwiri rɨ́aiwá re urɨgɨ́isixɨnɨ, “Ámɨnaé, negɨ́ mɨxɨ́ ináyɨ́ Depitomɨ xiáwoxɨnɨ wá yeawianeɨ.” ráná ");
INSERT INTO aak_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ámá obaxɨ́ Jisasomɨ xámɨ umeagɨ́áyɨ́ rɨ́mɨŋɨ́ tɨ́nɨ re urɨgɨ́awixɨnɨ, “Awagwí rɨ́aiwá mɨrɨpa épiyɨ.” urɨ́agɨ́a aiwɨ awaú arɨ́kí wínɨ eŋɨ́ tɨ́nɨ re rɨgɨ́isixɨnɨ, “Ámɨnaé, joxɨ negɨ́ mɨxɨ́ ináyɨ́ Depitomɨ xiáwoxɨnɨ, wá yeawianeɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisaso e éɨ́ nɨrónapɨmáná óɨ́ e dánɨ rɨ́aiwá re urɨŋɨnigɨnɨ, “Awagwí o pí oyeainɨrɨ rarɨŋiɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","awaú aŋwɨ e nɨbɨri re urɨgɨ́isixɨnɨ, “Ámɨnáoxɨnɨ, joxɨ yegɨ́ sɨŋwɨ́ oyeaoxoanɨrɨ rarɨŋwiɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisaso awaú nánɨ wá wunɨ́agɨ egɨ́ sɨŋwɨ́yo wé seáyɨ e wikwiáráná re egɨ́isixɨnɨ. Nɨwaúnɨ sɨŋwɨ́ noxoari nanɨmáná númɨ uxɨ́dɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusaremɨ rɨxa aŋwɨ e imónáná dɨ́wɨ́ Oripi tɨ́ŋɨ́ e aŋɨ́ yoɨ́ Betɨpasi rɨnɨŋɨ́pimɨ nɨrémómáná Jisaso wiepɨsarɨŋɨ́yɨ́ waúmɨ nurowárɨrɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","re urɨŋɨnigɨnɨ, “Awagwí aŋɨ́ jɨ́apimɨ nánɨ nuri dogí xɨnáí xegɨ́ miá tɨ́nɨ e yurárɨnɨŋagɨ nɨwɨnɨríná nɨwaúnɨ níkweari nɨmeámɨ bɨ́piyɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ámá wo sɨŋwɨ́ neanɨrɨ ‘Awagwí pí nánɨ íkweaarɨŋiɨ?’ earánáyɨ́, re urɨ́piyɨ, ‘Ámɨnáo seáyɨ e éɨ́ nɨŋwearɨ nɨmeámɨ umɨnɨrɨ yearowárɨŋoɨ.’ uráná xiáwo apaxɨ́ mé eaiapowárénapɨnɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Wɨ́á rókiamoagɨ́ wo nɨrɨrɨ rɨ́wamɨŋɨ́ rɨpɨ eaŋɨ́pɨ, “Saionɨ —Jerusaremɨ nánɨ nɨrɨro aiwɨ dɨ́wɨ́ bɨ nánɨ Saionɨyɨ rarɨgɨ́árɨnɨ. E ŋweagɨ́áyo re urɨ́poyɨ, ‘Arɨ́á époyɨ. Segɨ́ mɨxɨ́ ináyo awayinɨ́nɨŋɨ́ nimónɨrɨ dogí xwéomɨ marɨ́áɨ, dogí miá womɨ aí nɨŋweámáná seyɨ́né tɨ́ámɨnɨ barɨnɨ.’ urɨ́poyɨ.” nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ Jisaso awaúmɨ e urowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wiepɨsarɨŋɨ́ awaú nuri Jisaso urɨ́ɨ́pa e neri ");
INSERT INTO aak_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","dogí miá tɨ́nɨ xɨnáí tɨ́nɨ níkweari nɨmeámɨ nɨbɨri wigɨ́ iyɨ́á dogí miáomɨ seáyɨ e nikwiárɨro Jisaso seáyɨ e nɨŋwearɨ nɨmeámɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","mɨxɨ́ ináyɨ́yo yayɨ́ wianɨro nánɨ yarɨgɨ́ápa ámá oxɨ́ apɨxɨ́ epɨ́royɨ́ nero númɨ xɨ́darɨgɨ́áyɨ́ obaxɨ́ Jisaso iyɨ́áyo seáyɨ e nosaxa opunɨrɨ wigɨ́ iyɨ́á nɨpírɨro óɨ́ e íkwiaŋwɨ́ neapára uro wí wéwɨ́ ɨwɨ́ nɨdoayiro íkwiaŋwɨ́ neapára uro nerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","xámɨ umeaarɨgɨ́áyɨ́ tɨ́nɨ rɨ́wɨ́yo uxɨ́darɨgɨ́áyɨ́ tɨ́nɨ rɨ́aiwá re nura ugɨ́awixɨnɨ, “Mɨxɨ́ ináyɨ́ Depitomɨ xiáwo romɨ yayɨ́ seáyɨ e dánɨ oumeaneyɨ. Ámá Ámɨná Gorɨxo urowárénapɨŋɨ́ ro —Negɨ́ arɨ́owa o nánɨ wenɨŋɨ́ nerɨ ŋweaŋáná xwiogwɨ́ obaxɨ́ múroagɨ́rɨnɨ. O Gorɨxoyá dɨŋɨ́ tɨ́nɨ seáyɨ e imónɨ́wɨnɨgɨnɨ. Gorɨxo seáyɨ émɨ ŋweaŋomɨ yayɨ́ seáyɨmɨ dánɨ oumeaneyɨ.” Rɨ́aiwá e nɨra nuróná oxɨ́ nikéa nuro ");
INSERT INTO aak_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","rɨxa Jerusaremɨ rémóáná e ŋweagɨ́áyɨ́ mɨ́rɨ́ mɨ́rɨ́ neamero re rɨnɨgɨ́awixɨnɨ, “Ámá o go nánɨ rɨ́a rarɨŋoɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","oxɨ́ apɨxɨ́ xɨ́o tɨ́nɨ warɨgɨ́áyɨ́ re urɨgɨ́awixɨnɨ, “Gariri pɨropenɨsɨ́yo aŋɨ́ yoɨ́ Nasaretɨ dáŋo, Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ Jisaso nánɨ rarɨŋwɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisaso aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ ámá aŋɨ́ iwámɨ ínɨmɨ dánɨ bɨ́ inarɨgɨ́áyo mɨxɨ́dámɨ́ wiowárɨrɨ ámá nɨgwɨ́ senisɨ́ ninayiro tarɨgɨ́áyɨ́yá íkwiaŋwɨ́ mɨmɨwiárɨ́ erɨ ámá iŋɨ́ xawiówɨ́ rɨdɨyowá nánɨ bɨ́ inarɨgɨ́áyɨ́ íkwiaŋwɨ́ éɨ́ ŋweaarɨgɨ́ápɨ mɨmɨwiárɨ́ erɨ nerɨ ");
INSERT INTO aak_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","mɨxɨ́ re urɨŋɨnigɨnɨ, “Aŋɨ́ riwá nánɨ rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨnɨ, ‘Aŋɨ́ Gorɨxonɨyáiwá ámá xwɨyɨ́á rɨrɨmɨ́ nipɨ́rɨ́a nániwárɨnɨ.’ nɨrɨnɨrɨ eánɨŋagɨ aí soyɨ́né ɨ́wɨ́ meaarɨgɨ́áyɨ́ yarɨgɨ́ápa axɨ́pɨ́nɨŋɨ́ nero nánɨ aŋɨ́ riwá ɨ́wɨ́ meaarɨgɨ́áyɨ́yá aŋɨ́nɨŋɨ́ imónɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","E nurɨrɨ sɨnɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ ínɨmɨ emearɨ́ná sɨŋwɨ́ supárɨgɨ́áyɨ́ wí tɨ́nɨ sɨkwɨ́ ikɨ́ egɨ́áyɨ́ wí tɨ́nɨ o tɨ́ŋɨ́ e nánɨ báná o naŋɨ́ imɨmɨxɨmɨ́ wíagɨ ");
INSERT INTO aak_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Jisaso emɨmɨ́ e éɨ́pɨ sɨŋwɨ́ nɨwɨnɨro niaíwɨ́ o nánɨ aŋiwámɨ ínɨmɨ dánɨ rɨ́aiwá re nɨra warɨŋagɨ́a, “Negɨ́ mɨxɨ́ ináyɨ́ Depitomɨ xiáwo romɨ seáyɨ e oumeaneyɨ.” nɨra warɨŋagɨ́a arɨ́á e nɨwiro nánɨ wikɨ́ dɨŋɨ́ nɨwiaiwiro ");
INSERT INTO aak_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","mɨxɨ́ re urɨgɨ́awixɨnɨ, “Pɨ́né niaíwɨ́ joxɨ nánɨ rarɨgɨ́áyɨ́ arɨ́á rɨwiŋɨnɨ?” urɨ́agɨ́a Jisaso re urɨŋɨnigɨnɨ, “Oyɨ, arɨ́á nɨwirɨ aiwɨ soyɨ́né xwɨyɨ́á Gorɨxo nánɨ re nɨrɨnɨrɨ eánɨŋɨ́pɨ, ‘Dɨŋɨ́ joxɨyáyo dánɨ niaíwɨ́ onɨmiápia tɨ́nɨ sɨnɨ amɨŋɨ́ narɨŋɨ́pia tɨ́nɨ yayɨ́ seáyɨmɨ dánɨ rɨmepɨ́rɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ soyɨ́né ɨ́á nɨroro aí rɨxa agwɨ xɨxenɨ imónɨ́agɨ nɨwɨnɨro aí sɨnɨ dɨŋɨ́ mɨmoarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","E nurɨmo awamɨ pɨ́nɨ nɨwiárɨmɨ nɨpeyearɨ aŋɨ́ apimɨ pɨ́nɨ nɨwiárɨmɨ nurɨ aŋɨ́ yoɨ́ Betani nánɨ nurɨ e sá weŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sá weŋo wɨ́ápɨ tɨ́nɨ ámɨ Jerusaremɨ nánɨ nɨbɨrɨ́ná agwɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Íkɨ́á pikɨ́ wɨna óɨ́ e jɨ́ina roŋagɨ nɨwɨnɨrɨ “Sogwɨ́ bɨ odanɨmɨnɨ.” nɨyaiwimɨ nurɨ aŋwɨ e dánɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Sogwɨ́ mɨwepa ɨwɨ́nɨ inárɨŋagɨ nɨwɨnɨrɨ íkɨ́ánamɨ nɨramɨxɨrɨ re urɨŋɨnigɨnɨ, “Íkɨ́á pikɨ́ rɨnaxɨ, sogwɨ́ wínɨ werɨ́ámanɨ.” uráná apaxɨ́ mé yɨweárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Apaxɨ́ mé yɨweárɨ́agɨ wiepɨsarɨŋowa e nɨwɨnɨro ududɨ́ nɨwiro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Íkɨ́á pikɨ́ ana arɨre nerɨ apaxɨ́ mé yɨweárɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ, ‘Soyɨ́né Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roro dɨŋɨ́ biaú mɨmaxɨrɨpa ero “Gorɨxoyá dɨŋɨ́ tɨ́nɨ íkɨ́á rɨna e epaxɨ́namanɨ.” mɨyaiwipa ero nerɨ́náyɨ́, ayɨ́ xɨxenɨ nionɨ yarɨŋápa nimónɨnɨŋoɨ. Íkɨ́á rɨna nánɨnɨ mɨrarɨŋɨnɨ. Dɨ́wɨ́ mɨŋɨ́ apimɨ aí “Rɨpɨxɨnɨ nurɨ rawɨrawáyo piéroɨ.” uránáyɨ́ xɨxenɨ e nimónɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pí pí nánɨ Gorɨxomɨ rɨxɨŋɨ́ nurɨrɨ dɨŋɨ́ nɨkwɨ́rorɨ́náyɨ́, xɨxenɨ axɨ́pɨ e simɨxɨyinɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","O ámɨ Jerusaremɨ nɨrémorɨ rɨxa aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ ámáyo uréwapɨyarɨ́ná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ wigɨ́ Judayɨ́ mebáowa tɨ́nɨ nɨwímearo re urɨgɨ́awixɨnɨ, “Joxɨ arɨge nimónɨrɨ amɨpí nene aŋɨ́ riwámɨ ínɨmɨ dánɨ yarɨŋwápɨ pɨ́rɨ́ wiaíkímɨ́ yarɨŋɨnɨ? ‘Joxɨ nénɨ́ tɨ́ŋoxɨ imóneɨ.’ go rɨrɨ́agɨ e yarɨŋɨnɨ?” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ enɨ yarɨŋɨ́ bɨ oseaimɨnɨ. Soyɨ́né nionɨyápɨ áwaŋɨ́ nɨránáyɨ́, nionɨ enɨ ‘Apɨ eɨ.’ nɨrɨ́o nánɨ áwaŋɨ́ searɨmɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","re urɨŋɨnigɨnɨ, “Yarɨŋɨ́ nionɨyá rɨpɨ seaimɨ́ɨnɨ. Jono wayɨ́ nɨneameaia uŋo wayɨ́ Gorɨxoyá dɨŋɨ́ tɨ́nɨ neameaiŋɨ́ranɨ? Xegɨ́ dɨŋɨ́ tɨ́nɨ neameaiŋɨ́ranɨ?” Yarɨŋɨ́ e wíáná wiwanɨŋowa re rɨnɨgɨ́awixɨnɨ, “‘Jono Gorɨxoyá dɨŋɨ́ tɨ́nɨ eŋɨ́rɨnɨ.’ uránáyɨ́, re nearɨnɨŋoɨ, ‘Soyɨ́né pí nánɨ arɨ́á mɨwí egɨ́árɨnɨ?’ nearɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","E nerɨ aí ‘O xegɨ́ dɨŋɨ́ tɨ́nɨ eŋɨ́rɨnɨ.’ uránáyɨ́, ámá sɨpɨ́á re epɨ́royɨ́ egɨ́áyɨ́, ‘Jono Gorɨxoyá wɨ́á rókiamoŋorɨ́anɨ?’ yaiwiarɨgɨ́áyɨ́ iwaŋɨ́ neamépepɨ́rɨxɨnɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jisasomɨ re urɨgɨ́awixɨnɨ, “None majɨ́árɨnɨ. Jono dɨŋɨ́ goyá tɨ́nɨ eŋɨ́rɨ́anɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “Nionɨ enɨ ‘Amɨpí apɨ pɨ́rɨ́ wiaíkímɨ́ eɨ.’ nɨrɨ́o nánɨ áwaŋɨ́ searɨmɨméɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“E nerɨ aí ewayɨ́ xwɨyɨ́á rɨpɨ nánɨ segɨ́ dɨŋɨ́ arɨre yaiwiarɨŋoɨ? Ámá wo xegɨ́ niaíwɨ́ waú tɨ́ŋo xámɨ xɨráomɨ nurɨ re urɨŋɨnigɨnɨ, ‘Íwe, joxɨ negɨ́ wainɨ́ omɨŋɨ́yo nánɨ nurɨ omɨŋɨ́ eɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","o re urɨŋɨnigɨnɨ, ‘Oyɨ, numɨ́ɨnɨ.’ nurɨmáná muŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Xano xogwáomɨ nurɨ axɨ́pɨ ‘Omɨŋɨ́yo nánɨ nurɨ omɨŋɨ́ eɨ.’ uráná o re urɨŋɨnigɨnɨ, ‘Oweoɨ, numɨméɨnɨ.’ nurɨmáná rɨ́wɨ́yo dɨŋɨ́ sɨpí nɨyaiwirɨ ‘Gɨ́ ápomɨ “Oweoɨ.” pí nánɨ rɨ́a urɨ́ɨnɨ?’ nɨyaiwimɨ nurɨ omɨŋɨ́ eŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á apɨ nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","awamɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awaú go go xano urɨ́ɨ́pa xɨxenɨ arɨ́á nɨwirɨ eŋɨnigɨnɨ?” urɨ́agɨ awa “Xogwáorɨnɨ.” urɨ́agɨ́a Jisaso re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ. Apɨxɨ́ ede dánɨ iyɨ́ oikɨxearɨgɨ́íwa tɨ́nɨ ámá ɨ́wɨ́ yarɨgɨ́á, takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́á tɨ́nɨ Gorɨxoyá xwioxɨ́yo ananɨ nɨpáwiro ŋweapɨ́rɨ́a aiwɨ soyɨ́né páwipaxɨ́ mimónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Jono nɨbɨrɨ wé rónɨŋɨ́ oimónɨ́poyɨnɨrɨ searéwapɨyíagɨ aí soyɨ́né xɨráo eŋɨ́pa arɨ́á mɨwigɨ́awixɨnɨ. Apɨxɨ́ iyɨ́ ede dánɨ warɨgɨ́íwa tɨ́nɨ takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́áwa tɨ́nɨ xogwáo eŋɨ́pa Jonomɨ arɨ́á nɨwiro sanɨŋɨ́ imónarɨŋagɨ́a soyɨ́né sɨŋwɨ́ e nɨwɨnɨro aí xogwáo eŋɨ́pa ámɨ rɨ́wɨ́yo dɨŋɨ́ sɨpí nɨyaiwiro ‘None pí nánɨ arɨ́á mɨwipa yarɨŋwɨnɨ?’ nɨyaiwiro sanɨŋɨ́ mimónɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ arɨ́á nípoyɨ. Ámá xwɨ́á tɨ́ŋɨ́ wo wainɨ́ uraxɨ́ ɨwɨ́á nurɨrɨ xwɨ́ná nɨrorɨ wainɨ́ xegɨ́ iniɨgɨ́ nɨpɨ́rɨ́a nánɨ wainɨ́ sogwɨ́ xoyɨkímɨ́ enɨ́a nánɨ sɨ́ŋáyo óɨ́ nimorɨ wainɨ́ omɨŋɨ́yo áwɨnɨmɨ aŋɨ́ awí ŋweapɨ́rɨ́a nánɨ seáyɨ émɨ nɨmɨra nɨpeyirɨ néɨsáná ámá wí umeipɨ́rɨ́a nánɨ re urɨŋɨnigɨnɨ, ‘Wainɨ́ sogwɨ́ niáɨ́ éánáyɨ́, bɨ soyɨ́né segɨ́ mearo nionɨ gɨ́ mearɨ emɨ́a nánɨ nionɨyá omɨŋɨ́ rɨpimɨ ananɨ sɨŋwɨ́ nɨwɨnipɨ́rɨ́áranɨ?’ nurɨmɨ aŋɨ́ wíyo ememɨnɨrɨ nánɨ nurɨ nɨŋweaŋɨsáná ");
INSERT INTO aak_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","wainɨ́ sogwɨ́ rɨxa niáɨ́ éáná xegɨ́ omɨŋɨ́ wiiarɨgɨ́á wamɨ re urowárɨŋɨnigɨnɨ, ‘Soyɨ́né nuro wainɨ́ nionɨ nánɨ nɨtíɨ́ápɨ nurápauípoyɨ.’ urowárɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwa xɨ́o urowárɨ́áwamɨ womɨ iwaŋɨ́ mépero womɨ pɨkiro womɨ sɨ́ŋá earo egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Omɨŋɨ́ xiáwo ámɨ omɨŋɨ́ wiiarɨgɨ́áyɨ́ obaxɨ́ onɨmiápɨ wamɨ urowárɨ́agɨ aí omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwa xámɨŋowamɨ wigɨ́ápa axɨ́pɨ wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ámɨ rɨ́wɨ́yo o xegɨ́ xewaxo nurowárɨrɨ re yaiwiŋɨnigɨnɨ, ‘Nɨgɨ́ íwomɨyɨ́ xwɨyɨ́á xɨxenɨ arɨ́á wipɨ́ráoɨ.’ yaiwíagɨ aí ");
INSERT INTO aak_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwa xewaxo barɨŋagɨ nɨwɨnɨro re rɨnɨgɨ́awixɨnɨ, ‘Xanoyá dɨŋɨ́ tɨ́ŋo nimónɨrɨ amɨpí meanɨ́o iwo barɨnɨ. Oyá amɨpí meanɨ́wá nánɨ omɨ opɨkianeyɨ.’ nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","omɨ ɨ́á nɨxero omɨŋɨ́yo bɨ́anɨrɨwámɨnɨ nɨmoairo pɨkigɨ́awixɨnɨ.” Jisaso e nurɨrɨ Judayɨ́ ámɨnáowa re oyaiwípoyɨnɨrɨ “None omɨŋɨ́ sɨŋwɨ́ uwɨniarɨŋwáonénɨŋɨ́ imónɨŋagwɨ nánɨ rɨneararɨnɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á e nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ayo yarɨŋɨ́ re wiŋɨnigɨnɨ, “Omɨŋɨ́ xiáwo nɨbɨrɨ́ná omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwamɨ pí winɨgɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","awa re urɨgɨ́awixɨnɨ, “Sɨpí yarɨgɨ́áwamɨyɨ́ enɨ sɨpí nɨwikárɨmáná ámɨ ámá wa ‘Xwiogwɨ́ ayɨ́ ayo wainɨ́ sogwɨ́ niáɨ́ éáná ananɨ nɨdɨrane o nánɨ utianɨ́wárɨnɨ.’ yaiwíɨ́áwamɨ re urɨnɨ́árɨnɨ, ‘Gɨ́ omɨŋɨ́ rɨpɨ sɨŋwɨ́ nɨwɨníɨ́rɨxɨnɨ.’ urɨnɨ́árɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisaso re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á ámá Gorɨxo seyɨ́né yeáyɨ́ seayimɨxemeanɨ́a nánɨ urowárénapɨnɨ́o nánɨ nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ enɨ ‘Sɨ́ŋá aŋɨ́ mɨrarɨgɨ́áwa sɨ́ŋá awiaxɨ́ nánɨ pɨ́á nerɨ́ná wo “Sɨpírɨnɨ.” nɨrɨro emɨ móɨ́o nánɨ Gorɨxo “Sɨ́ŋá o tɨ́nɨ xámɨ nɨtɨrɨ́náyɨ́, aŋɨ́ eŋɨ́ neánɨrɨ naŋɨ́ imónɨnɨŋoɨ.” nɨrɨrɨ sɨ́ŋá o nɨmearɨ táná aŋɨ́ eŋɨ́ neánɨrɨ naŋɨ́ imónɨŋɨ́rɨnɨ. Gorɨxo e éɨ́ eŋagɨ nánɨ nene sɨŋwɨ́ nɨwɨnɨrɨ́ná aga imɨrɨŋɨ́ mimónɨŋagɨ wɨnɨŋwɨnɨ.’ E nɨrɨnɨrɨ eánɨŋɨ́pɨ soyɨ́né sɨnɨ ɨ́á mɨropa egɨ́áranɨ? Oweoɨ, ɨ́á nɨroro aiwɨ dɨŋɨ́ mɨmoarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ayɨnánɨ gɨ́ Judayɨ́né re seararɨŋɨnɨ, ‘ “Gorɨxo nene xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ neameŋweanɨ́árɨnɨ.” rɨyaiwiarɨŋoɨ? Oweoɨ! Omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwa yapɨ arɨ́kí néra warɨgɨ́áyɨ́né Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo nɨpáwiro oŋweápoyɨnɨrɨ sɨŋwɨ́ seanɨnɨ́ámanɨ. Ámá xeŋwɨ́ wí sanɨŋɨ́ nimónɨro wé rónɨŋɨ́ yarɨgɨ́áyɨ́ opáwípoyɨnɨrɨ sɨŋwɨ́ wɨnɨnɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xwasɨ́wɨ́ yeáyɨ́ bimɨ sɨ́ŋá nɨpiérorɨ nearɨ́ná yunɨ́ wárarɨŋɨ́pa sɨ́ŋáonɨ ámá gɨyo gɨyo nɨpiérorɨ nearɨ́ná axɨ́pɨ xwasɨ́wɨ́ yunɨ́nɨŋɨ́ imɨxɨmɨ́árɨnɨ.” Jisaso xɨ́o sɨ́ŋáónɨŋɨ́ nimónɨrɨ nánɨ e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Parisiowa tɨ́nɨ ewayɨ́ xwɨyɨ́á apɨ wiwanɨŋowa nánɨ rɨnarɨŋagɨ arɨ́á nɨwiro “None nánɨ rɨ́a rarɨnɨ?” nɨyaiwiro ");
INSERT INTO aak_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","“Omɨ rɨxa ɨ́á oxɨraneyɨ.” yaiwíɨ́áyɨ́ oxɨ́ apɨxɨ́ nɨ́nɨ Jisaso nánɨ “Gorɨxoyá wɨ́á rókiamoarɨŋorɨ́anɨ?” yaiwiarɨŋagɨ́a nánɨ ámɨ wáyɨ́ nero wí e megɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisaso ámɨ ewayɨ́ xwɨyɨ́á wí nurɨrɨ́ná re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ámá xwɨyɨ́á Gorɨxoyá arɨ́á nɨwiro sanɨŋɨ́ nimónɨro xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ meŋweanɨ́e ŋweapaxɨ́ imónɨŋɨ́yɨ́, ayɨ́ ewayɨ́ xwɨyɨ́á rɨpɨ́nɨŋɨ́ imónɨnɨ. Mɨxɨ́ ináyɨ́ wo xewaxo apɨxɨ́ omeanɨrɨ nánɨ aiwá xwé rɨyamɨ́ nɨyárɨmáná ");
INSERT INTO aak_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwamɨ re urowárɨŋɨnigɨnɨ, ‘Ámá nionɨ urepeárɨmeŋáyo “Aiwá nánɨ bɨ́poyɨ.” urɨmépoyɨ.’ urowáráná awa mɨxɨ́ ináyo urɨ́ɨ́pa nuro urɨméagɨ́a aiwɨ ayɨ́ mɨbɨpaxɨ́ wimónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mɨxɨ́ ináyo xegɨ́ omɨŋɨ́ wiiarɨgɨ́á ámɨ wamɨ re urowárɨŋɨnigɨnɨ, ‘Ámá nionɨ aiwá rɨpɨ nánɨ urepeárɨŋáyo re urɨmépoyɨ, “Aiwá rɨxa rɨyamɨ́ yárɨ́ɨnigɨnɨ.” nurɨro “Xegɨ́ burɨmákaú oxɨ́yɨ́ tɨ́nɨ sipɨsipɨ́ memé naŋwɨ́ xɨxegɨ́nɨ mɨnɨŋɨ́rɨxa tɨ́nɨ rɨxa nɨpɨkirɨ sɨ́ó kɨkɨrómɨ́ nerɨ sɨ́ŋá exárɨnɨnɨ. Xegɨ́ xewaxo apɨxɨ́ meanɨ nánɨ aiwá imɨxɨ́ápɨ nánɨ bɨ́poyɨ.” urɨmépoyɨ.’ urowáráná awa áwaŋɨ́ e urɨméagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","urepeárɨmeŋɨ́yɨ́ aríkwɨ́kwɨ́ nɨwiro wigɨ́ dɨŋɨ́ tɨ́nɨ numiro re egɨ́awixɨnɨ. Wo xegɨ́ aiwá omɨŋɨ́yo nánɨ uŋɨnigɨnɨ. Ámɨ wo xegɨ́ nɨgwɨ́ omɨŋɨ́ bɨ emɨnɨrɨ nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wɨ́a omɨŋɨ́ wiiarɨgɨ́áwamɨ ɨ́á nɨxɨrɨro iwaŋɨ́ nɨmépero pɨkigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mɨxɨ́ ináyo rɨxa wikɨ́ wónɨ́agɨ xegɨ́ sɨmɨŋɨ́ wínarɨgɨ́áwamɨ urowáráná awa nuro ámá xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwamɨ pɨkíɨ́áyo enɨ nɨpɨkiro wigɨ́ aŋɨ́yɨ́ enɨ rɨ́á nɨyárɨmáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","mɨxɨ́ ináyo xegɨ́ omɨŋɨ́ wiiarɨgɨ́á wamɨ re urɨŋɨnigɨnɨ, ‘Gɨ́ íwo apɨxɨ́ meanɨ nánɨ aiwá rɨxa rɨyamɨ́ inárɨnɨŋagɨ aiwɨ ámá aiwá apɨ nánɨ urepeárɨŋáyɨ́ mɨbɨpaxɨ́ wimónɨ́agɨ nánɨ ayɨ́ nɨpaxɨ́ mimónɨgoɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ayɨnánɨ soyɨ́né xwamɨdɨgɨ́yo nuro ámá óɨ́ e nɨmúrónɨrɨŋɨ́yo íwo apɨxɨ́ meanɨ nánɨ aiwá imɨxɨ́á rɨpɨ nɨpɨ́rɨ bɨpɨ́rɨ nánɨ áwaŋɨ́ urɨ́poyɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","omɨŋɨ́ wiiarɨgɨ́áwa óɨ́ wíyɨ́ wíyo nuro ámá nɨmúrónɨrɨ́náyɨ́ naŋɨ́ aí tɨ́nɨ sɨpí aí tɨ́nɨ nɨwirɨmeámɨ nɨbɨro aŋɨ́ aiwá nɨpɨ́rɨ nánɨ imɨxárɨ́iwámɨ dérogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aŋɨ́ iwámɨ rɨxa nɨdéroŋagɨ́a mɨxɨ́ ináyo ámá oxɨ́ apɨxɨ́ aiwá nɨpɨ́rɨ nánɨ bɨ́áyɨ́ sɨŋwɨ́ wɨnɨmɨnɨrɨ nánɨ nɨpáwirɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ámá wo aiwá nánɨ nɨbɨrɨ́ná aikɨ́ sɨŋɨ́ yínɨrɨ iyɨ́á sɨŋɨ́ pánɨrɨ nemo nɨbɨrɨ mɨŋweapa eŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","re urɨŋɨnigɨnɨ, ‘Ámáoxɨnɨ, joxɨ aiwá rɨpɨ nánɨ nɨbɨrɨ́ná pí nánɨ aikɨ́ sɨŋɨ́ yínɨrɨ iyɨ́á sɨŋɨ́ pánɨrɨ nemoxɨ mɨbɨpa éɨ́rɨnɨ?’ urɨ́agɨ o xwɨyɨ́á bɨ murarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","mɨxɨ́ ináyo xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwamɨ re urɨŋɨnigɨnɨ, ‘Soyɨ́né omɨ ɨ́á nɨxero gwɨ́ wéyo jiro sɨkwɨ́yo jiro nemáná sɨ́á yinɨŋɨ́ bɨ́arɨwámɨnɨ moaípoyɨ. Sɨ́á yinɨŋeyɨ́ rɨ́nɨŋɨ́ ayɨkwɨ́ mɨwinɨpa eŋagɨ nánɨ ámá ŋwɨ́ earo magí írónɨro epɨ́rɨ́árɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","re urɨŋɨnigɨnɨ, “Gorɨxo ámá obaxɨ́yo nurepeárɨrɨ ‘Nionɨ tɨ́ámɨnɨ bɨ́poyɨ.’ nurɨrɨ aiwɨ neyírorɨ́ná ámá naŋɨ́ imónɨŋɨ́yɨ́ árɨ́nɨ́ meanɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisiowa Jisaso e rarɨŋagɨ arɨ́á nɨwimowa nuro mekaxɨ́ nɨrɨro omɨ pasánɨŋɨ́ numero xwɨyɨ́ápai ŋwɨráranɨro nánɨ re rɨnɨgɨ́awixɨnɨ, “Omɨ yapɨ́ re uréwapɨyanɨ́wɨnɨ, ‘Takisɨ́ nánɨ nɨgwɨ́ émáyɨ́ nearáparɨgɨ́ápɨ sɨnɨ mɨnɨ wianɨréwɨnɨ?’ uranɨ́wɨnɨ. O ‘Oweoɨ, sɨnɨ mɨnɨ mɨwipa époyɨ.’ ránáyɨ́, émáyɨ́ omɨ ɨ́á nɨxero gwɨ́ yipɨ́ráoɨ. E mɨrɨpa nerɨ ‘Oyɨ, seyɨ́né mɨnɨ nɨwirɨ́ná apánɨ yarɨŋoɨ.’ ránáyɨ́, ámá omɨ xɨ́darɨgɨ́á ámɨ arɨ́á bɨ mɨwí nero pɨ́nɨ wiárɨpɨ́ráoɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","wiwanɨŋowayá wiepɨsarɨgɨ́á wamɨ tɨ́nɨ ámá mɨxɨ́ ináyɨ́ Xeroto nɨkumɨxɨnɨrɨ emearɨgɨ́á wamɨ tɨ́nɨ Jisaso nɨŋwearɨ uréwapɨyarɨŋe nánɨ urowárɨ́agɨ́a awa nuro Jisasomɨ re urémeagɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ nɨnearéwapɨyirɨ́ná nepánɨ nearéwapɨyarɨŋoxɨrɨnɨ. Ámá Ámɨnáowayá sɨŋwɨ́yo dánɨ aí xwɨyɨ́á ámɨ xegɨ́ bɨ mɨrɨ́ axɨ́pɨnɨ rarɨŋoxɨrɨnɨ. Sɨpí rɨrɨ naŋɨ́ rɨrɨ yarɨŋɨ́manɨ. Joxɨ xwɨyɨ́á Gorɨxoyánɨ nepánɨ xɨxenɨ nearéwapɨyarɨŋoxɨrɨnɨ.” Weyɨ́ e numearɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“Joxɨ none neareɨ. Dɨxɨ́ dɨŋɨ́ arɨre simónarɨnɨ? Judayene émáyɨ́yá mɨxɨ́ ináyɨ́ Sisaoyɨ rɨnɨŋomɨ takisɨ́ nánɨ nɨgwɨ́ mɨnɨ wiarɨŋwápɨ mɨnɨ nɨwirɨ́ná ‘Apánɨ yarɨŋwɨnɨ.’ rɨsimónarɨnɨ? ‘Nɨpɨkwɨnɨ mɨyarɨŋwɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisaso awa sɨpí wikáranɨro yarɨŋagɨ́a dɨŋɨ́ adadɨ́ nɨwirɨ re urɨŋɨnigɨnɨ, “Naŋɨ́ rɨrɨ sɨpí rɨrɨ yarɨgɨ́á royɨ́né, pí nánɨ iwamɨ́ó níwapɨyarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Émáyɨ́yá nɨgwɨ́ nene takisɨ́ nánɨ wiarɨŋwá wo sɨŋwɨ́ wɨnɨmɨ sɨwá nípoyɨ.” urɨ́agɨ awa nɨgwɨ́ xɨ́o urɨ́ɨ́ wo nɨmearo sɨwá wíáná ");
INSERT INTO aak_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","o re urɨŋɨnigɨnɨ, “Nɨgwɨ́ romɨ sɨ́mɨmaŋɨ́ imɨxɨnɨŋɨ́ tɨ́ tɨ́nɨ yoɨ́ eánɨŋɨ́ tɨ́ tɨ́nɨ goyárɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","awa re urɨgɨ́awixɨnɨ, “Ayɨ́ émáyɨ́ mɨxɨ́ ináyɨ́ Sisaoyárɨnɨ.” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “Amɨpí Sisaoyá imónɨŋagɨ nɨwɨnɨrɨ́ná ayɨ́ Sisaomɨ mɨnɨ wíɨ́rɨxɨnɨ. Gorɨxoyá imónɨŋagɨ nɨwɨnɨrɨ́ná xewanɨŋomɨ mɨnɨ wíɨ́rɨxɨnɨ.” nurɨrɨ ámá Gorɨxo xewanɨŋónɨŋɨ́ imɨxɨŋɨ́ eŋagɨ nánɨ omɨ dɨŋɨ́ owɨkwɨ́rɨ́poyɨnɨrɨ e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","awa arɨ́á e nɨwiro dɨŋɨ́ ududɨ́ nero pɨ́nɨ nɨwiárɨmɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sɨ́á axɨ́yimɨ Judayɨ́ Sajusiyɨ rɨnɨgɨ́á wí —Sajusiowa re rarɨgɨ́áwarɨnɨ, “Ámá pɨyɨ́yɨ́ ámɨ wiápɨ́nɨmeapɨ́rɨ́ámanɨ.” E rarɨgɨ́áwa nɨbɨro “None enɨ o neararɨŋɨ́pa ewayɨ́ xwɨyɨ́á bɨ nurɨrane majɨ́á owikɨxeáraneyɨ.” nɨyaiwiro Jisasomɨ yarɨŋɨ́ nɨwiróná ");
INSERT INTO aak_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, Moseso eŋíná re nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́rɨnɨ, ‘Ámá wo niaíwɨ́ memeá péánáyɨ́ xogwáo náo apɨxɨ́ aní nɨmearɨ xexɨrɨ́meáoyá niaíwɨ́ wiemeaíwɨnɨgɨnɨ.’ nɨrɨrɨ eaŋɨ́rɨnɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ewayɨ́ xwɨyɨ́á rɨpɨ urɨgɨ́awixɨnɨ, “Xɨráxogwá wé wɨ́úmɨ dáŋɨ́ waú imónɨgɨ́á none tɨ́nɨ ŋweaŋwáwa re egɨ́awixɨnɨ. Xɨráo xámɨŋo apɨxɨ́ nɨmearɨ niaíwɨ́ memeá péáná ");
INSERT INTO aak_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","xogwáo xɨ́o tɨ́ŋo xɨráoyá apɨxɨ́ aní nɨmearɨ aí o enɨ niaíwɨ́ memeá péáná wɨ́a enɨ ímɨ wo wo nɨmearo aí niaíwɨ́ memeá penowíánáyɨ́ ");
INSERT INTO aak_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","í enɨ yoparɨ́ rɨ́wɨ́yo peŋɨnigɨnɨ.” Ewayɨ́ xwɨyɨ́á apɨ nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jisasomɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Ámá nɨ́nɨ Gorɨxo mí ómómɨxɨmɨ́ enɨ́íná wiápɨ́nɨmeááná xɨráxogwá wé wɨ́úmɨ dáŋɨ́ waú imónɨgɨ́áwa apɨxí go goyá imónɨnɨ́árɨ́anɨ? Pí nánɨ? Ayɨ́ awa nowanɨ meagɨ́í eŋagɨ nánɨrɨnɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né xwɨyɨ́á Gorɨxoyá nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ oyá eŋɨ́ eánɨŋɨ́pɨ tɨ́nɨ majɨ́á eŋagɨ́a nánɨ majɨmajɨ́á nero xeŋwɨ́nɨ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá pegɨ́áyɨ́ nɨwiápɨ́nɨmearóná aŋɨ́najɨ́ yapɨ nero apɨxɨ́ mearo wiro epɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","E nerɨ aí xwɨyɨ́á ámá pegɨ́áyɨ́ wiápɨ́nɨmeapɨ́rɨ́ápɨ nánɨ Gorɨxo re searɨŋɨ́pɨ ‘Nionɨ Ŋwɨ́á Ebɨrɨ́amoyáonɨ tɨ́nɨ Aisakoyáonɨ tɨ́nɨ Jekopoyáonɨ tɨ́nɨ awayáonɨrɨnɨ.’ E nɨrɨnɨrɨ eánɨŋɨ́pɨ soyɨ́né sɨnɨ ɨ́á mɨropa egɨ́áranɨ? Oweoɨ, ɨ́á nɨroro aiwɨ nɨjɨ́á mimónɨpa nero rarɨŋoɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Gorɨxo ámá pegɨ́áyɨ́ nánɨ Ŋwɨ́áomanɨ. Ámá sɨnɨ dɨŋɨ́ tɨ́ŋɨ́yɨ́ nánɨ Ŋwɨ́áorɨnɨ.” nurɨrɨ awa dɨŋɨ́ re oyaiwípoyɨnɨrɨ, “Negɨ́ arɨ́owa pegɨ́á eŋagɨ aiwɨ wigɨ́ dɨŋɨ́ sɨnɨ sɨŋɨ́ rimónɨnɨ?” oyaiwípoyɨnɨrɨ e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ arɨ́á nɨwiro o xwɨyɨ́á uréwapɨyarɨŋɨ́pɨ nánɨ dɨŋɨ́ ududɨ́ nɨwiga ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisaso Sajusiowa xwɨyɨ́á nɨmeámɨ bɨ́ápɨ gwɨ́ mɨŋɨ́nɨŋɨ́ wákwíagɨ nánɨ ámɨ bɨ murarɨŋagɨ́a Parisiowa sɨŋwɨ́ e nɨwɨnɨro awanɨ axɨ́mɨnɨ awí neánárɨmáná ");
INSERT INTO aak_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","wigɨ́ wo —O ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ meweŋɨ́yɨ́ worɨnɨ. O Jisasomɨ yapɨ́ nɨwíwapɨyirane majɨ́á owikɨxeáraneyɨnɨrɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nearéwapɨyarɨŋoxɨnɨ, negɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yɨ́ nɨyonɨ gɨ́pɨ seáyɨ e imónɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jisaso re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ re nɨrɨnɨrɨ eánɨŋɨ́pɨ, ‘Dɨxɨ́ Ámɨná Gorɨxomɨ dɨŋɨ́ nɨŋwɨrárɨrɨ́ná dɨŋɨ́ sɨxɨ́ uyirɨ xwioxɨ́yo dánɨ dɨŋɨ́ wɨkwɨ́rorɨ erɨ́ɨnɨ.’ Ŋwɨ́ ikaxɨ́ e nɨrɨnɨrɨ eánɨŋɨ́pɨ seáyɨ e imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ŋwɨ́ ikaxɨ́ ‘Jɨwanɨŋoxɨ nánɨ dɨŋɨ́ sɨpí sinarɨŋɨ́pa ámá joxɨ sɨŋwɨ́ wɨnarɨŋɨ́yɨ́ nánɨ enɨ dɨŋɨ́ sɨpí axɨ́pɨ e wirɨ́ɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ enɨ seáyɨ e imónɨŋɨ́pɨ tɨ́nɨ xɨxenɨ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Xwɨyɨ́á Moseso tɨ́nɨ wɨ́á rókiamoagɨ́áwa tɨ́nɨ nɨrɨro rɨ́wamɨŋɨ́ eagɨ́á nɨpɨnɨ ŋwɨ́ ikaxɨ́ mɨ́kɨ́ rɨpiaúmɨ ɨkwɨkwɨ́rɨ́ inɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisiowa sɨnɨ awí eaárɨnɨŋáná Jisaso yarɨŋɨ́ bɨ nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","re urɨŋɨnigɨnɨ, “Kiraiso, ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o nánɨ segɨ́ dɨŋɨ́ arɨrerɨnɨ? Niaíwɨ́ goyáorɨnɨ yaiwiarɨŋoɨ?” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “Negɨ́ mɨxɨ́ ináyɨ́ Depitomɨ xiáworɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","o re urɨŋɨnigɨnɨ, “Kiraiso sa Depitomɨ xiáwo eŋánáyɨ́, o kwíyɨ́ Gorɨxoyá tɨ́nɨ rɨ́wamɨŋɨ́ nearɨ́ná o nánɨ arɨge ‘Gɨ́ Ámɨnáorɨnɨ.’ nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨ́rɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ámɨná Gorɨxo gɨ́ Ámɨnáomɨ re urɨŋɨnigɨnɨ, “Joxɨ tɨ́nɨ mɨxɨ́ imónɨgɨ́áyo xopɨrárɨ́ rɨwiimɨ́aé nánɨ gɨ́ wé náúmɨ dánɨ ŋweaɨ.” urɨŋɨnigɨnɨ.’ nɨrɨrɨ eaŋɨ́rɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depito Kiraiso, arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o nánɨ ‘Gɨ́ Ámɨnáorɨnɨ.’ rɨŋɨ́yɨ́ arɨge nerɨ ámɨ xegɨ́ xiáwo imónɨnɨ?” nurɨrɨ awa re oyaiwípoyɨnɨrɨ “Kiraiso Depitomɨ xiáwo imónɨŋagɨ aiwɨ seáyɨ e múrónɨŋagɨ nánɨ Gorɨxomɨ xewaxorɨ́anɨ?” oyaiwípoyɨnɨrɨ e uráná ");
INSERT INTO aak_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ámá ayɨ́ nɨ́nɨ “Kiraiso, ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o sa Depitomɨ xiáworɨnɨ.” nɨyaiwiro nánɨ wíyɨ́yá nɨwiápɨ́nɨmearɨ murɨpaxɨ́ wimónɨ́agɨ ámɨ íná dánɨ yarɨŋɨ́ bɨ mɨwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisaso xwɨyɨ́á apɨ nurɨ́ɨsáná ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo tɨ́nɨ oyá wiepɨsarɨŋowamɨ tɨ́nɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Parisiowa tɨ́nɨ wiwanɨŋowa nánɨ re rɨnɨgɨ́árɨnɨ, ‘Ŋwɨ́ ikaxɨ́ Moseso nɨnearéwapɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́pɨ newanɨŋonenɨ ámáyo uréwapɨyipaxɨ́rɨnɨ.’ ");
INSERT INTO aak_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","E rɨnɨgɨ́á eŋagɨ nánɨ nɨ́nɨ awa searɨ́áyɨ́ nɨxɨ́dɨro erɨ́ɨnɨ. E nerɨ aí awa naŋɨ́ nɨrɨro aiwɨ wiwanɨŋowa píránɨŋɨ́ mɨxɨ́darɨŋagɨ́a nánɨ wigɨ́ yarɨgɨ́ápa seyɨ́né enɨ mepanɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ámáyo ŋwɨ́ ikaxɨ́ nurɨróná saŋɨ́ xwé ayá wínɨŋɨ́ gwɨ́ nɨjiro saŋwɨ́yo ikwiárarɨgɨ́árɨnɨ. E nerɨ aí wiwanɨŋowa ‘Iwamɨ́ó wé reŋɨ́ ná wonɨ tɨ́nɨ omɨ́eyoámɨnɨ.’ wimónarɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Amɨpí awa yarɨgɨ́ápɨ ámá sɨŋwɨ́ oneanɨ́poyɨnɨrɨ yarɨgɨ́árɨnɨ. Awa ámá Gorɨxomɨ píránɨŋɨ́ xɨ́darɨgɨ́áyɨ́ dɨrɨ́ xwɨyɨ́á Gorɨxoyá nánɨ dɨ́kínarɨgɨ́árí mɨŋɨ́yo dɨ́kínɨro wigɨ́ iyɨ́á sírɨ́wɨ́yo dánɨ wayaxɨ́nɨŋɨ́ nɨyɨwára puŋɨ́yɨ́ yínɨro yarɨgɨ́ápa mé ámá sɨŋwɨ́ oneanɨ́poyɨnɨrɨ dɨrɨ́ xwé ɨ́á nɨwearo dɨ́kínɨro wayaxɨ́ enɨ sepiá yɨwárapɨŋɨ́ yínɨro nero emearɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Awa aiwá xwé imɨxarɨgɨ́e nánɨ nurónáranɨ, rotú aŋɨ́yo nánɨ nurónáranɨ, ámá sɨŋwɨ́ oneanɨ́poyɨnɨrɨ sɨŋánɨŋɨ́mɨnɨ nɨŋweamero yarɨgɨ́áwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Awí eánarɨgɨ́eranɨ, makerɨ́á imɨxarɨgɨ́eranɨ, ‘Nearéwapɨyarɨŋoxɨnɨ.’ onɨrɨ́poyɨnɨrɨ emearɨgɨ́áwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Awa e nero aí segɨ́ searéwapɨyarɨŋo ná wonɨrɨnɨ. Seyɨ́né nɨyɨ́nénɨ nionɨ nɨnɨxɨ́dɨro nánɨ ámá axɨ́ imónɨgɨ́áyɨ́né ‘Ráre, napíé rɨnɨgɨ́áyɨ́né imónɨŋagɨ nánɨ seyɨ́né awa yapɨ ‘Nearéwapɨyarɨŋoxɨnɨ.’ onɨrɨ́poyɨnɨrɨ e mepanɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Segɨ́ ápo aŋɨ́namɨ ŋweaŋo ná wonɨ onɨ eŋagɨ nánɨ enɨ xwɨ́á tɨ́yo dáŋɨ́ womɨ ‘Ápoxɨnɨ́ murɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɨseaméra unɨ́o ná wonɨ Kiraiso, ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o eŋagɨ nánɨ enɨ seyɨ́néyá wo nánɨ ‘Nɨneaméra warɨŋorɨnɨ.’ mɨrɨnɨpa époyɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Seyɨ́né gɨyɨ́né seáyɨ e seaimónɨŋoyɨ́ segɨ́ inókínɨŋɨ́ nimónɨrɨ omɨŋɨ́ seaiíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ámá gɨyɨ́ gɨyɨ́né sewanɨŋɨ́yɨ́né seáyɨ e menɨ́áyɨ́né, Gorɨxo xwɨ́ámɨ seaimɨxɨnɨ́árɨnɨ. Gɨyɨ́ gɨyɨ́né ‘Sɨpíenerɨnɨ.’ nɨyaiwinɨro ínɨmɨ imónɨ́áyɨ́né, Gorɨxo seáyɨ e seamenɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“E nerɨ aí ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ, naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Soyɨ́né ámá Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́roro oyá xwioxɨ́yo nɨpáwiro ŋweaanɨrɨ éɨ́áyo nuréwapɨyirɨ́ná pɨ́rɨpɨ́rɨ́nɨŋɨ́ wiarɨŋagɨ́a nánɨ Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. Sewanɨŋoyɨ́né Gorɨxomɨ dɨŋɨ́ mɨwɨkwɨ́ropa ero mɨpáwipa ero nero aí ámá enɨ xe opáwípoyɨnɨrɨ sɨŋwɨ́ wɨnarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né, sɨ́wí yáɨ́ rɨ́kínɨŋɨ́yɨ́ yapɨ ámáyá aiwá pɨrɨ́ nɨ́nɨ ɨ́wɨ́ manarɨŋɨ́pa soyɨ́né apɨxɨ́ anɨ́ apiaŋɨ́pia nánɨ dɨŋɨ́ sɨpí mɨseaí wigɨ́ amɨpí ɨ́wɨ́ nurápɨro anɨpápia wárarɨgɨ́árɨnɨ. Soyɨ́né Gorɨxomɨ rɨxɨŋɨ́ nurɨróná ámá arɨ́á nɨneairo weyɨ́ oneamépoyɨnɨrɨ ámá sɨŋwɨ́ anɨgɨ́e dánɨ sepiá nɨra warɨgɨ́oyɨ́nérɨnɨ. Ayɨnánɨ soyɨ́né xwɨyɨ́á ámá wí meárɨnɨpɨ́rɨ́ápa axɨ́pɨ meárɨnɨpɨ́rɨ́ámanɨ. Soyɨ́né rɨ́á tɨ́ŋɨ́ meárɨnɨpɨ́rɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ŋwɨ́ ikaxɨ́ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né, ‘Ámá ná jɨ́amɨ ŋweagɨ́áyɨ́ negɨ́nɨŋɨ́ imónɨ́ɨ́rɨxɨnɨ.’ nɨyaiwiro rawɨrawáyo xero xwɨ́áyo aŋɨ́ uro neróná segɨ́ yarɨgɨ́ápɨ ayo uréwapɨyarɨgɨ́oyɨ́nérɨnɨ. Ayɨ́ soyɨ́nénɨŋɨ́ nimónɨrɨ́náyɨ́ soyɨ́né rɨ́á anɨŋɨ́ wearɨŋɨ́yo ikeaárɨnɨpaxɨ́ aiwɨ soyɨ́né ayo wíwapɨyarɨŋagɨ nánɨ ayɨ́ soyɨ́né nɨseamúroro aŋɨpaxɨ́ rɨ́á anɨŋɨ́ wearɨŋɨ́yo ikeaárɨnɨpaxɨ́ imónɨŋoɨ. Ayɨnánɨ Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Soyɨ́né sɨŋwɨ́nɨŋɨ́ supárɨgɨ́oyɨ́né aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Sɨŋwɨ́nɨŋɨ́ supárɨgɨ́oyɨ́né aiwɨ ámá wíyo óɨ́ sɨwánɨŋɨ́ wiarɨgɨ́oyɨ́né, ámá wo ‘E emɨ́ɨnɨ. Aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨŋwá riwámɨ dánɨ rɨrarɨŋɨnɨ.’ rarɨŋagɨ nɨwɨnɨrɨ́ná re rarɨgɨ́oyɨ́nérɨnɨ, ‘Ananɨrɨnɨ. Xɨ́o rɨ́ɨ́pa mepa nerɨ́náyɨ́, xwɨyɨ́á meárɨnɨpaxɨ́ wí mɨrarɨnɨnɨ.’ rarɨgɨ́oyɨ́nérɨnɨ. E nerɨ aí ámá wo ‘E emɨ́ɨnɨ. Sɨ́ŋá gorɨ́ aŋɨ́ rɨdɨyowá yarɨŋwáiwámɨ ínɨmɨ weŋɨ́pimɨ dánɨ rɨrarɨŋɨnɨ.’ rarɨŋagɨ nɨwɨnɨrɨ́ná re rarɨgɨ́oyɨ́nérɨnɨ, ‘Xɨ́o rɨ́ɨ́pa mepa nerɨ́náyɨ́, xwɨyɨ́á meárɨnɨpaxɨ́ rarɨnɨ.’ rarɨgɨ́oyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Majɨmajɨ́á ikárɨnɨro sɨŋwɨ́nɨŋɨ́ supárɨro egɨ́oyɨ́né, gɨ́mɨnɨ gɨpɨ seáyɨ e imónɨnɨ? Sɨ́ŋá gorɨ́ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ weŋɨ́pɨ seáyɨ e rimónɨnɨ? Aŋɨ́ rɨdɨyowá yarɨgɨ́iwá seáyɨ e rimónɨnɨ? Aŋɨ́ rɨdɨyowá yarɨgɨ́á ŋwɨ́á iwámɨ gorɨ́ sɨ́ŋápɨ sa e weŋagɨ nánɨ enɨ ŋwɨ́á imónɨŋagɨ nánɨ aŋɨ́ iwá seáyɨ e imónɨnɨ. Ayɨnánɨ ámá wo rɨdɨyowá yarɨgɨ́iwámɨ dánɨ ráná pí nánɨ ‘Xwɨyɨ́á meárɨnɨpaxɨ́ bɨ mɨrarɨnɨnɨ.’ rarɨgɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Soyɨ́né rɨpɨ enɨ rarɨgɨ́oyɨ́nérɨnɨ. Ámá gɨyɨ́ gɨyɨ́ aiwá peaxɨ́ tanɨro nánɨ íráɨ́ noa peyinɨŋe dánɨ rarɨŋagɨ nɨwɨnɨrɨ́ná ‘Ayɨ́ ananɨrɨnɨ. Xwɨyɨ́á meárɨnɨpaxɨ́ bɨ mɨrarɨnɨnɨ.’ rɨro ámá aiwá peaxɨ́ seáyɨ e ikwiárɨnɨŋɨ́pimɨ dánɨ rarɨŋagɨ nɨwɨnɨrɨ́ná ‘Ayɨ́ apimɨ dánɨ rɨ́ɨ́pɨ xɨxenɨ mepa nerɨ́náyɨ́, xwɨyɨ́á meárɨnɨpaxɨ́ rarɨnɨ.’ rɨro yarɨgɨ́oyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sɨŋwɨ́nɨŋɨ́ supárɨgɨ́oyɨ́né arɨge nerɨ yapɨ́ e uréwapɨyarɨgɨ́árɨnɨ? Gɨ́mɨnɨ gɨ́pɨ seáyɨ e imónɨnɨ? Aiwá peaxɨ́ ikwɨkwiárɨmɨ́ yarɨgɨ́ápɨ seáyɨ e rimónɨnɨ? Íráɨ́ noa peyinɨŋɨ́pɨ seáyɨ e rimónɨnɨ? Íráɨ́ onɨŋɨ́pɨ aiwá ŋwɨ́á imɨxarɨŋagɨ nánɨ íráɨ́pɨ seáyɨ e imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ayɨnánɨ ámá íráɨ́ onɨŋɨ́pimɨ dánɨ nɨrɨróná aiwá seáyɨ e ikwiárɨnɨŋɨ́pimɨ dánɨ enɨ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ámá rɨdɨyowá yarɨgɨ́iwámɨ dánɨ nɨrɨróná Gorɨxo aŋiwámɨ ínɨmɨ ŋweaŋomɨ dánɨ enɨ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ámá ‘Aŋɨ́namɨ dánɨ rɨrarɨŋɨnɨ.’ nɨrɨróná Gorɨxo íkwiaŋwɨ́ éɨ́ ŋweaŋe dánɨ rɨro xewanɨŋo éɨ́ ŋweaŋomɨ dánɨ rɨro enɨ yarɨŋoɨ. Ayɨnánɨ xwɨyɨ́á soyɨ́né ‘E dánɨ nɨrɨrɨ́ná ananɨrɨnɨ.’ rarɨgɨ́áyɨ́ nɨpɨkwɨnɨ nɨpɨkwɨnɨ mɨrarɨgɨ́oyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ŋwɨ́ ikaxɨ́ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Sɨpí ero naŋɨ́ ero yarɨgɨ́oyɨ́né dɨŋɨ́ sɨpí oseainɨ. Soyɨ́né aiwá nɨmiróná anɨŋɨ́ minɨ́ yíyɨ́ tɨ́nɨ aɨ́ tɨ́nɨ siyó amɨpí píránɨŋɨ́ ɨ́á nɨroro rɨxa wé wúkaú imónɨŋáná wo Gorɨxomɨ mɨnɨ nɨwiro aí ŋwɨ́ ikaxɨ́ xwé rɨnɨŋɨ́ tɨ́yo ‘Dɨxɨ́ ámá imónɨŋɨ́yo xɨxenɨ wiiarɨŋɨ́pa ámá xeŋwɨ́yo enɨ axɨ́pɨ wiirɨ́ɨnɨ. Ámá xeŋwɨ́yo enɨ ayá urɨmɨxɨrɨ́ɨnɨ. Gorɨxomɨ dɨŋɨ́ wɨkwɨ́rorɨ́ɨnɨ.’ rɨnɨŋɨ́ ayo soyɨ́né ogámɨ́ nero onɨmiápianɨ xɨ́darɨgɨ́árɨnɨ. Segɨ́ anɨŋɨ́ minɨ́ yarɨgɨ́á jɨ́apɨ pɨ́nɨ mɨwiárɨpa ero ámáyo naŋɨ́ mimɨxɨpa yarɨgɨ́ápɨ enɨ ero nero sɨŋwɨrɨyɨ́, naŋɨ́ imónɨmɨnɨrɨ eŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Soyɨ́né sɨŋwɨ́nɨŋɨ́ supárɨgɨ́oyɨ́né aiwɨ ámá wíyo óɨ́ sɨwánɨŋɨ́ wiarɨgɨ́oyɨ́né, inaiwá nɨnɨro sidɨrɨ́á onɨmiápia weŋagɨ nɨwɨnɨróná ananɨ emɨ nɨmamoro aí kamerɨ́ xwérɨxa weŋáná sɨŋwɨ́ mɨwɨnɨ́ o tɨ́nɨ gwɨ́nárearɨgɨ́oyɨ́nérɨnɨ.” nurɨrɨ awa re oyaiwípoyɨnɨrɨ “None ŋwɨ́ ikaxɨ́ xwé eánɨŋɨ́yo ogámɨ́ neranéná ayɨ́ kamerɨ́nɨŋɨ́ gwɨ́nárearɨŋwárɨ́anɨ? Ŋwɨ́ ikaxɨ́ onɨmiápia eánɨŋɨ́yo píránɨŋɨ́ nɨxɨ́dɨranéná ayɨ́ sidɨrɨ́á emɨ́nɨŋɨ́ mamoarɨŋwárɨ́anɨ?” oyaiwípoyɨnɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ámɨ re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né, Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. Soyɨ́né kapɨxɨ́yo tɨ́nɨ xwárɨ́á sɨxɨ́yo tɨ́nɨ bɨ́arɨwámɨ dánɨ wayɨ́ nɨroro aí xwioxɨ́yómɨnɨ segɨ́ ɨ́wɨ́ meaarɨgɨ́áyɨ́ tɨ́nɨ uyɨ́niɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ magwɨ́ enɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi sɨŋwɨ́nɨŋɨ́ supárɨgɨ́oyɨ́né, kapɨxɨ́wámɨ tɨ́nɨ xwárɨ́á sɨxɨ́wámɨ tɨ́nɨ xámɨ xwioxɨ́yómɨnɨ wayɨ́ róáná bɨ́arɨwámɨnɨ enɨ naŋɨ́ imónɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ŋwɨ́ ikaxɨ́ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né, Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. Soyɨ́né ámá xwárɨpáyo seáyɨ e mɨ́á imɨxáná sɨmajiyɨ́ naŋɨ́ rarɨŋɨ́pánɨŋɨ́ imónɨŋoɨ. Ínɨmɨnɨyɨ́ ámá eŋɨ́ nórówapɨrɨ pɨyaŋɨ́ eaarɨŋɨ́pánɨŋɨ́ eŋánáɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ámá wí soyɨ́né sɨŋwɨ́ nɨseanɨróná ‘Wé rónɨgɨ́áwarɨnɨ.’ seaiaiwiarɨŋagɨ́a wí segɨ́ xwioxɨ́yómɨnɨ naŋɨ́ ero sɨpí ero yarɨgɨ́ápɨ tɨ́nɨ rɨkɨkɨrɨ́ó yarɨgɨ́ápɨ tɨ́nɨ magwɨ́ eŋagɨ sɨŋwɨ́ mɨseanarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ŋwɨ́ ikaxɨ́ mewegɨ́oyɨ́né tɨ́nɨ Parisioyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Naŋɨ́ ero sɨpí ero yarɨgɨ́oyɨ́né, Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. Soyɨ́né Gorɨxoyá wɨ́á rókiamoagɨ́áyɨ́yá xwárɨ́páyo maŋɨ́ e warɨpánɨŋɨ́ sɨ́ŋáyo xegɨ́ yoɨ́ nearo urárárɨro ámá wé rónɨgɨ́á eŋíná pegɨ́áwa xwɨ́á weyárɨnɨŋe enɨ mɨ́á imɨxɨro neróná ");
INSERT INTO aak_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","re rarɨgɨ́árɨnɨ, ‘None eŋíná arɨ́owa ŋweaagíná nɨŋwearane sɨŋwɨrɨyɨ́, awa wɨ́á rókiamoagɨ́áwamɨ pɨkiarɨ́ná none enɨ nawínɨ wí pɨkianɨrɨ eŋwámanɨ.’ rarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sewanɨŋoyɨ́né e nɨrɨróná xwɨyɨ́á nɨmeárɨnɨro rénɨŋɨ́ rɨnarɨŋoɨ, ‘Negɨ́ arɨ́owa wɨ́á rókiamoagɨ́áwamɨ pɨkiagɨ́owamɨ xiáwonerɨnɨ.’ áwaŋɨ́ énɨŋɨ́ rɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Soyɨ́né segɨ́ arɨ́owa wɨ́á rókiamoagɨ́áwamɨ nɨpɨkiro yagɨ́ápɨ nɨmúroro xwɨyɨ́á wínɨ meárɨnɨpɨ́rɨ nánɨ ananɨ éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sidɨroyɨ́ne, weaxɨ́á miáoyɨ́né Gorɨxo xwɨyɨ́á nɨseamearɨrɨ rɨ́á anɨŋɨ́ wearɨŋɨ́yo seaikeaáráná arɨge nerɨ urakínɨpɨ́rɨ́árɨnɨ? Oweoɨ, wí nurakínɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Píránɨŋɨ́ arɨ́á époyɨ. Nionɨ wɨ́á rókiamoarɨgɨ́áwamɨ tɨ́nɨ ámá nɨjɨ́áwamɨ tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwamɨ tɨ́nɨ soyɨ́né tɨ́ŋɨ́ e nánɨ urowárɨmɨ́á eŋagɨ aiwɨ soyɨ́né awa wamɨ pɨkiro wamɨ íkɨ́áyo yekwɨroárɨro wamɨ segɨ́ rotú aŋɨ́yo dánɨ sɨkwɨ́á ragɨ́ pɨ́rɨ́ uyɨkiro wa nuro aŋɨ́ bɨ bimɨ ŋweáɨ́e mɨxɨ́ nɨxɨ́da uro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ayɨ́ rɨpɨ nánɨ awamɨ soyɨ́né tɨ́ŋɨ́ e nánɨ urowárɨmɨ́árɨnɨ. Soyɨ́né xwɨ́á tɨ́yo xwɨyɨ́á ámá wé rónɨgɨ́á nɨyonɨ go go pɨkigɨ́á nánɨ rɨ́á meárɨnɨpɨ́rɨ awamɨ soyɨ́né tɨ́ámɨnɨ urowárɨmɨ́árɨnɨ. Iwamɨ́ó wé rónɨŋɨ́ Aiborɨ́omɨ pɨkiŋe dánɨ yoparɨ́ wɨ́á rókiamoagɨ́ Sekaraiaomɨ —O íráɨ́ rɨdɨyowá yanɨro ikwɨkwiárɨmɨ́ yarɨgɨ́e mɨdánɨ eŋáná Gorɨxoyá aŋɨ́ awawá ‘Ŋwɨ́áxɨnɨ.’ rɨnɨŋe mɨdánɨ eŋáná áwɨnɨmɨ e pɨkigɨ́orɨnɨ. Omɨ pɨkigɨ́e nánɨ xwɨyɨ́á meárɨnɨpɨ́rɨ ámá ayo segɨ́ tɨ́ámɨnɨ urowárɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nepa seararɨŋɨnɨ, ‘Oxɨ́ apɨxɨ́ agwɨ ríná ŋweagɨ́áyɨ́né amɨpí nionɨ seararɨŋá rɨpɨ nɨseaímeanɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusaremɨ ŋweáyɨ́né wɨ́á rókiamoarɨgɨ́áwamɨ pɨkiro ámá Gorɨxo seyɨ́né tɨ́ŋɨ́ e nánɨ urowárénapɨŋowamɨ sɨ́ŋá nearo pɨkiro yarɨgɨ́áyɨ́né, nionɨ karɨ́karɨ́ xɨnáí miá ɨwɨ́yo ínɨmɨ mɨmeámɨ́ yarɨŋɨ́pa nionɨ enɨ axɨ́pɨ seaimɨnɨrɨ yarɨ́ná seyɨ́né mɨseaimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Arɨ́á époyɨ. Gorɨxo yeáyɨ́ nɨseayimɨxemearɨ́ná aŋɨ́ seyɨ́né ŋweaanɨrɨ egɨ́e rɨxa anɨpá imónɨgoɨ. ");
INSERT INTO aak_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. ‘Seyɨ́né nionɨ sɨŋwɨ́ mɨnanɨ́ néɨ́asáná re rɨpɨ́rɨ́íná nánɨnɨ nanɨpɨ́rɨ́árɨnɨ, “Ámɨnáo urowárénapáná weapɨnɨ́omɨ yayɨ́ seáyɨ e oumeaneyɨ.” rɨpɨ́rɨ́íná nánɨnɨ sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ nɨpeyearɨ warɨ́ná xegɨ́ wiepɨsarɨŋowa aŋɨ́ Gorɨxo nánɨ e mɨrɨnɨŋɨ́yɨ́ awiaxɨ́ eŋagɨ “Jisaso píránɨŋɨ́ sɨŋwɨ́ owɨnɨnɨ.” nɨyaiwiro árɨxá wianɨro báná ");
INSERT INTO aak_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","o re urɨŋɨnigɨnɨ, “Soyɨ́né sɨ́ŋá aŋɨ́ tɨyɨ́ nɨ́nɨ sɨŋwɨ́ rɨwɨnarɨŋoɨ? Nepa seararɨŋɨnɨ. Rɨ́wɨ́yo sɨ́ŋá kɨkírónɨŋɨ́ rɨpɨyɨ́ wo wɨ́omɨ seáyɨ e ikwiárɨnɨnɨ́ámanɨ. Sɨ́ŋá ikwɨkweyárɨnɨŋɨ́ rɨpɨ nɨ́nɨ ɨkwierómioanɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E nurɨmɨ nurɨ dɨ́wɨ́ mɨŋɨ́ Oripiyo nɨyirɨ e éɨ́ ŋweaŋáná wiepɨsarɨŋowa Jisaso xegɨ́pɨ ŋweaŋagɨ nɨwɨnɨro aŋwɨ e nɨbɨro yumɨ́í yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ áwaŋɨ́ neareɨ. Sɨ́ŋápɨ gíná ɨkwierómioanɨ́árɨnɨ? Sɨŋwɨ́ ayo nɨwɨnɨrane ‘O rɨxa nɨweapɨnɨ aŋwɨ ayorɨ́anɨ?’ yaiwirane ‘Sɨ́á yoparɨ́yi rɨxa rɨyirɨ́anɨ?’ yaiwirane yanɨ́wá nánɨ pí ekɨyiŋɨ́yo wɨnanɨ́wárɨnɨ? Joxɨ neareɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","o áwaŋɨ́ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “Ámá wí yapɨ́ searéwapɨyipɨ́rɨxɨnɨrɨ dɨŋɨ́ ɨ́á nɨxɨrɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá obaxɨ́ wo wo nɨbayiro yoɨ́ nionɨyá nɨrɨnɨro yapɨ́ re searéwapɨyanɨro epɨ́rɨ́árɨnɨ, ‘Ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o imónɨŋáonɨrɨnɨ.’ searéwapɨyanɨro éáná ámá oxɨ́ apɨxɨ́ obaxɨ́ ‘Nepaxɨnɨ.’ nɨyaiwiro xeŋwɨ́yo xɨ́dɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Soyɨ́né ‘Aŋɨ́ nowamɨnɨ mɨxɨ́ íkwɨ́naroarɨnɨ.’ rɨnánáyɨ́ xwɨyɨ́á imɨŋɨ́ ‘Aŋɨ́ wímɨ mɨxɨ́ inarɨŋoɨ.’ rɨnɨméánáyɨ́ wáyɨ́ mepa éɨ́rɨxɨnɨ. Mɨxɨ́ ayɨ́ xámɨ niga nurɨ aiwɨ sɨ́á yoparɨ́ Jisasonɨ weapɨmɨ́áyi sɨnɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ámá gwɨ́ wɨrí nɨwiápɨ́nɨmearo wínɨyɨ́ tɨ́nɨ mɨxɨ́ inɨro ero mɨxɨ́ ináyɨ́ wí nɨwiápɨ́nɨmearo wínɨyɨ́ tɨ́nɨ mɨxɨ́ inɨro ero aŋɨ́ wíyɨ́ wíyo pobonɨ́ erɨ aŋɨ́ wamɨ agwɨ́ nánɨ ikeamónɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Apɨ nɨpɨnɨ e imónarɨŋagɨ nɨwɨnɨrɨ́ná re yaiwíɨ́rɨxɨnɨ, ‘Rɨ́wéná xwé enɨ́a nánɨ iwamɨ́ó ríyɨ́ rɨyarɨnɨ? Oyɨnɨ.’ yaiwíɨ́rɨxɨnɨ. Apɨxɨ́ niaíwɨ́ xɨrɨmɨnɨrɨ nerɨ́ná dɨŋɨ́ re yaiwiarɨgɨ́ápa, ‘Rɨ́wéná rɨ́nɨŋɨ́ xwé nimɨnɨrɨ nánɨ iwamɨ́ó rɨniarɨnɨ? Oyɨnɨ.’ yaiwiarɨgɨ́ápa soyɨ́né enɨ nionɨ rarɨŋápɨ imónarɨŋagɨ nɨwɨnɨrɨ́ná re yaiwíɨ́rɨxɨnɨ, ‘Rɨ́wéná xeanɨŋɨ́ xwé neaímeanɨ́árɨ́anɨ?’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Íná soyɨ́né ámá wí ɨ́á nɨseaxero xeanɨŋɨ́ seaikárɨro seapɨkiro epɨ́rɨ́a nánɨ ámá wíyo mɨnɨ wipɨ́rɨ́árɨnɨ. Ámá gwɨ́ rɨxɨ́ wɨrɨ́ wɨrímɨ dáŋɨ́ nɨ́nɨ soyɨ́né nionɨ nɨxɨ́darɨŋagɨ́a nánɨ sɨ́mɨ́ tɨ́nɨ seaipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E seaiarɨ́ná ámá obaxɨ́ nionɨ nɨxɨ́darɨgɨ́áyɨ́ rɨ́wɨ́ nɨnɨmoro wigɨ́ wínɨyɨ́ Jisasonɨ nɨxɨ́darɨgɨ́áyɨ́ nánɨ ámáyo mɨyɨ́ urɨro ayɨ́ tɨ́nɨ sɨ́mɨ́ tɨ́nɨ inɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ámá wí nɨwiápɨ́nɨmearo mimónɨ́ wɨ́á rókiamoarɨgɨ́áwa nimónɨro ámá oxɨ́ apɨxɨ́ obaxɨ́yo yapɨ́ wíwapɨyipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ámá rɨkɨkɨrɨ́ó niga upɨ́rɨ́á eŋagɨ nánɨ ámá obaxɨ́ wíyo wá nɨwianɨrɨ arɨrá wiarɨgɨ́ápɨ pɨ́nɨ wiárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","E nerɨ aí gɨyɨ́ gɨyɨ́ eŋɨ́ neánɨro nionɨ dɨŋɨ́ nɨnɨkwɨ́roro nɨxɨ́darɨgɨ́áyo sɨ́á yoparɨ́yimɨ nionɨ ananɨ yeáyɨ́ uyimɨxemeámɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Xwɨyɨ́á yayɨ́ seainarɨŋɨ́ ‘Gorɨxo xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.’ rɨnɨŋɨ́pɨ ámá nionɨ nɨxɨ́darɨgɨ́áyɨ́ nuro ámá gwɨ́ wɨrɨ́ wɨrí nɨyonɨ xwɨ́á rɨrí nɨrímɨnɨ amɨ gɨmɨ ŋweagɨ́áyo wáɨ́ nurɨmemáná eŋáná sɨ́á yoparɨ́yi imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Soyɨ́né wɨ́á rókiamoagɨ́ Daniero nɨrɨrɨ eaŋɨ́pɨ ámá sɨpí seaikárɨŋo aŋɨ́ awawá Gorɨxoyá ŋwɨ́á ikwɨ́rónɨŋɨ́wámɨ xórórɨ́ nerɨ xwɨrɨ́á ikɨxéagɨ nɨwɨnɨrɨ́ná —Ámá gɨyɨ́né xwɨyɨ́á rɨpɨ ɨ́á róɨ́áyɨ́né, dɨŋɨ́ píránɨŋɨ́ morɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","E nɨwɨnɨrɨ́ná Judia pɨropenɨsɨ́yo ŋweagɨ́áyɨ́ dɨ́wɨ́yo nánɨ éɨ́ yíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ámá gɨyɨ́ gɨyɨ́ aŋɨ́ waíwɨ́yo nɨpeyiro seáyɨ́mɨnɨ ikwɨ́rónɨŋɨ́wámɨ nɨŋwearóná ‘Sɨpí neaikárɨŋo rɨxa ŋwɨ́á imónɨŋe xwɨrɨ́á ikɨxearɨnɨ.’ rɨnarɨŋagɨ́a arɨ́á nɨwirɨ́ná sɨnɨ mepa éɨ́rɨxɨnɨ. Nɨwiápɨ́nɨmeámáná amɨpí ínɨmɨ ikwɨ́rónɨŋɨ́wámɨ weŋɨ́pɨ mieanɨro nánɨ nɨwepɨ́nɨro mɨpáwipa sa nɨwepɨ́nɨro dɨ́wɨ́yo nánɨ aŋɨ́nɨ éɨ́ yíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ámá aiwá omɨŋɨ́yo yarɨgɨ́áyɨ́ enɨ arɨ́á e nɨwirɨ́ná ámɨ iyɨ́á meaanɨro nánɨ aŋɨ́ e nánɨ mupa sa dɨ́wɨ́yo nánɨ éɨ́ yíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Íná apɨxɨ́ niaíwɨ́ agwɨ́ egɨ́íwa tɨ́nɨ sɨnɨ niaíwɨ́ amɨŋɨ́ narɨgɨ́íwa tɨ́nɨ aŋɨ́nɨ éɨ́ upaxɨ́ mimónɨŋagɨ nánɨ aweyɨ! Arɨge nero dɨ́wɨ́yo nánɨ aŋɨ́nɨ éɨ́ yipɨ́rɨ́árɨ́anɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aŋɨ́nɨ éɨ́ mupaxɨ́ neaimónɨnɨgɨnɨrɨ Gorɨxomɨ rɨxɨŋɨ́ re urɨ́ɨ́rɨxɨnɨ, ‘Íná imɨŋɨ́ mɨrɨpa éwɨnɨgɨnɨ. Sabarɨ́á enɨ mimónɨpa éwɨnɨgɨnɨ.’ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Gorɨxo xwɨ́á imɨxɨrɨ aŋɨ́na imɨxɨrɨ eŋe dánɨ ámá xeanɨŋɨ́ nimóga bagɨ́a aiwɨ sɨpí seaikárɨŋo ŋwɨ́á imónɨŋe xwɨrɨ́á ikɨxéáná xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaímeanɨ́árɨnɨ. Xeanɨŋɨ́ íná imónɨnɨ́á rɨpɨ tɨ́nɨ ámɨ wí xɨxenɨ imónɨnɨ́á menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gorɨxo xeanɨŋɨ́ imónɨnɨ́á apɨ nánɨ ‘Aŋɨ́nɨ pɨ́nɨ owiárɨnɨ.’ mɨyaiwiárɨpa nerɨ sɨŋwɨrɨyɨ́, ámá wíyo yeáyɨ́ uyimɨxemeapaxɨ́manɨ. Ámá xɨ́o eyíroárɨŋɨ́ eŋagɨ nánɨ xeanɨŋɨ́ apɨ nánɨ ‘Aŋɨ́nɨ anɨpá oimónɨnɨ.’ rɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Íná ámá wí ‘Sɨŋwɨ́ wɨnɨ́poyɨ. Yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo riworɨnɨ.’ re searánáranɨ, wí ‘Jɨ́iworɨnɨ.’ searánáranɨ, arɨ́á mɨwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá wa nɨwiápɨ́nɨmearo ‘Oxɨ́ apɨxɨ́ Gorɨxo eyíroárɨŋɨ́yo yapɨ́ wíwapɨyipaxɨ́ rɨ́a imónɨnɨ?’ nɨyaiwiro yapɨ́ wíwapɨyanɨro nánɨ wí ‘Kiraiso, arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o, ayɨ́ nionɨrɨnɨ.’ rɨro wí ‘Wɨ́á rókiamoarɨŋáonɨrɨnɨ.’ rɨro nero emɨmɨ́ xwé ámá sɨŋwɨ́ mɨwɨnarɨgɨ́ápɨ ero ayá rɨwamónɨpaxɨ́ bɨ ero epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Píránɨŋɨ́ arɨ́á mónɨ́poyɨ. Amɨpí rɨ́wéná imónɨnɨ́ápɨ nánɨ rɨxa áwaŋɨ́ seararɨŋagɨ yapɨ́ seaíwapɨyipɨ́rɨxɨnɨrɨ nánɨ dɨŋɨ́ nɨmoro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nionɨ rɨxa píránɨŋɨ́ áwaŋɨ́ searɨ́á eŋagɨ nánɨ ámá wí ‘Arɨ́á époyɨ. O ámá nánɨ dɨŋɨ́ meaŋe jɨ́amɨ ŋweanɨ.’ searáná soyɨ́né arɨ́á nɨwiro mupa éɨ́rɨxɨnɨ. Wí ‘Arɨ́á époyɨ. O aŋɨ́yo ná ínɨmɨ yumɨ́í ŋweanɨ.’ searáná arɨ́á mɨwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ámá imónɨŋáonɨ nɨweapɨrɨ́ná ápiaŋwɨ́ nerɨ́ná aŋɨ́ ɨkwɨ́rónɨŋɨ́ nɨmɨnɨ wɨ́á ókiarɨŋɨ́pa nionɨ enɨ wɨ́á nókía weapɨmɨ́á eŋagɨ nánɨ ámá wí ‘O yumɨ́í e ŋweanɨ.’ searánáyɨ́, arɨ́á mɨwipa éɨ́rɨxɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","awa re oyaiwípoyɨnɨrɨ, “Nionɨ weapɨmɨ́aé nánɨ ámá áwaŋɨ́ wí rɨpaxɨ́ menɨnɨ. Ámá nɨ́nɨ sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ ikaxɨ́ rɨpɨ urɨŋɨnigɨnɨ, “Naŋwɨ́ pɨyɨ́ weŋe apurɨ́ obaxɨ́ pénarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ámɨ re urɨŋɨnigɨnɨ, “E nerɨ aí xeanɨŋɨ́ apɨ nɨ́nɨ rɨxa nɨseaímeámáná eŋáná apaxɨ́ mé sogwɨ́ sɨ́á yinɨrɨ emá wɨ́á mónɨpa erɨ siŋɨ́ aŋɨ́namɨ dánɨ exweánowirɨ erɨ amɨpí eŋɨ́ eánɨŋɨ́ aŋɨ́namɨ eŋɨ́yɨ́ úpɨyinɨrɨ erɨ rɨxa nemáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","nionɨ ekɨyiŋɨ́nɨŋɨ́ niga nɨweapɨrɨ ámá nɨyonɨ sɨŋánɨ wimónáná ámá gwɨ́ arɨ́ arí nɨ́nɨ ámá imónɨŋáonɨ nikɨ́nɨmɨ gɨ́ eŋɨ́ eánɨŋɨ́ tɨ́nɨ aŋɨ́ pɨrɨ́yo dánɨ agwɨ́ tɨ́nɨ weaparɨŋagɨ sɨŋwɨ́ nɨnanɨróná ŋwɨ́ eapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","E yarɨ́ná pékákɨ́ aga eŋɨ́ tɨ́nɨ rɨnɨ́agɨ nionɨ gɨ́ aŋɨ́najowa ámá oxɨ́ apɨxɨ́ Gorɨxo eyíroárɨŋɨ́yɨ́ xwɨ́á rɨrí nɨrímɨnɨ amɨ gɨmɨ ŋweagɨ́áyo wirɨmeapɨ́rɨ urowárɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Soyɨ́né ewayɨ́ ikaxɨ́ íkɨ́á pikɨ́na nánɨ rɨnɨŋɨ́pɨ nánɨ dɨŋɨ́ nɨmoro nɨjɨ́á imónɨ́poyɨ. Íkɨ́á pikɨ́na mɨmiŋwɨ́ neánowimáná ámɨ iniɨgɨ́ sɨxɨ́ nínɨrɨ rɨxa mɨŋɨ́ ináná, ‘Rɨxa xwiogwɨ́rɨ́anɨ?’ yaiwiarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sɨŋwɨ́ e nɨwɨnɨro yaiwiarɨgɨ́ápa nionɨ seararɨŋáyɨ́ nɨ́nɨ imónarɨŋagɨ nɨwɨnɨrɨ́ná re yaiwíɨ́rɨxɨnɨ, ‘O nɨweapɨnɨ nánɨ rɨxa ɨ́wí énɨŋɨ́ rɨrónapɨnɨ? Oyɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nepa seararɨŋɨnɨ. Ámá ríná ŋweagɨ́áyɨ́né wiyɨ́né sɨnɨ mɨpé ŋweaŋáná amɨpí nionɨ seararɨŋápɨ nimónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aŋɨ́na tɨ́nɨ xwɨ́árí tɨ́nɨ anɨpá imónɨnɨ́á eŋagɨ aiwɨ xwɨyɨ́á nionɨyá wí surɨ́má imónɨnɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nionɨ ámɨ gínɨ gíná nɨweapɨmɨ́á nánɨyɨ́ ámá nɨ́nɨ aiwɨ wo nɨjɨ́á mimónɨnɨ. Aŋɨ́najɨ́ aiwɨ nionɨ aiwɨ nɨjɨ́á mimónɨŋwɨnɨ. Sa gɨ́ áponɨ nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ámá imónɨŋáonɨ ámɨ weapáná ámá Nowao tɨ́ŋíná yagɨ́ápa axɨ́pɨ yarɨŋagɨ́a wɨnɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iniɨgɨ́ waxɨ́ sɨnɨ nɨróga mɨwiápɨ́nɨmeapa eŋáná ayɨ́ sɨ́á Nowao sɨpɨxɨ́yo páwinɨ́e nánɨnɨ re néra ugɨ́awixɨnɨ. ‘Gorɨxo iniɨgɨ́ waxɨ́ tɨ́nɨ xwɨrɨ́á wí neaikɨxenɨ́ámanɨ.’ nɨyaiwiro aiwá nɨro iniɨgɨ́ nɨro néra nuro apɨxɨ́ nɨŋwɨrára uro nɨmeáa uro néra núɨsáná ");
INSERT INTO aak_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","‘Pí pí neaímeanɨ́árɨ́anɨ?’ mɨyaiwí néra warɨ́ná iniɨgɨ́ waxɨ́ nɨmárómɨ uŋɨnigɨnɨ. Ámá imónɨŋáonɨ ámɨ nɨweapɨrɨ́ná ámá maiwí axɨ́pɨ e néra warɨŋagɨ́a wímeámɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sɨ́á nionɨ weapɨmɨ́áyimɨ ámá waú, aiwá omɨŋɨ́yo yarɨgɨ́íwaú gɨ́ aŋɨ́najowa wɨ́omɨ nɨwirɨmearo aí wɨ́omɨ e wárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Apɨxɨ́ wípaú enɨ pɨrawá yunɨ́ ikɨxémɨ́ yarɨ́ná wɨ́ímɨ nɨwirɨmearo wɨ́ímɨ e wárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ayɨnánɨ soyɨ́né awínɨŋɨ́ ŋwearɨ́ɨnɨ. Dɨxɨ́ Ámɨnáonɨ bɨmɨ́á nánɨ soyɨ́né majɨ́á imónɨŋagɨ́a nánɨ dɨŋɨ́ tɨ́nɨ ŋweáɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ewayɨ́ ikaxɨ́ rɨpɨ nánɨ enɨ dɨŋɨ́ mópoyɨ. Ámá wo, aŋɨ́ xiáwo ‘Ɨ́wɨ́ meaarɨŋo sɨ́á rɨyimɨ ríná bɨnɨrɨ́enɨŋoɨ?’ nɨyaiwirɨ sɨŋwɨrɨyɨ́, awí nɨŋwearɨ́ná xe nɨ́kwirɨ opáwinɨrɨ sɨŋwɨ́ wɨnɨmɨnɨrɨ eŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ámá imónɨŋáonɨ weapɨmɨ́áyi nánɨ enɨ soyɨ́né sɨnɨ majɨ́á eŋagɨ́a nánɨ awínɨŋɨ́ ŋweáɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisaso ewayɨ́ ikaxɨ́ ámɨ bɨ urɨmɨnɨrɨ nánɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Omɨŋɨ́ wiiarɨŋɨ́yɨ́ wo xegɨ́ bosoyá maŋɨ́ arɨ́á nɨwirɨ dɨŋɨ́ neŋwɨperɨ nerɨ́náyɨ́ arɨge imónɨnɨ? O re imónɨnɨ. O omɨŋɨ́ rɨpɨ nánɨ bosɨwo oimónɨrɨ xegɨ́ boso rɨ́peaŋorɨnɨ. O xegɨ́ bosoyá omɨŋɨ́ wiiarɨgɨ́áyo umeirɨ aiwá yaŋɨ́ umeirɨ yarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Boso amɨ dánɨ nɨbɨrɨ xegɨ́ bosɨwo rɨ́peaŋo xámɨ yagɨ́pa axɨ́pɨ píránɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ́náyɨ́, bosɨwo yayɨ́ owinɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nepa seararɨŋɨnɨ. O píránɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ́náyɨ́, xegɨ́ omɨŋɨ́ nɨ́nɨ enɨ menɨ́a nánɨ rɨ́peanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","E nerɨ aiwɨ bosɨwɨ́ axo ‘Gɨ́ boso yapapɨ́nɨ bɨnɨmenɨŋoɨ.’ nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","xegɨ́ omɨŋɨ́ anɨ wiiarɨgɨ́áwamɨ iwaŋɨ́ nɨméperɨ ámá papɨkɨ́ yarɨgɨ́á wa tɨ́nɨ iniɨgɨ́ nɨro aiwá nɨro néra nurɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‘Boso sɨ́á rɨyimɨ nɨbɨnɨmenɨŋoɨ.’ nɨyaiwirɨ yarɨŋɨ́yɨ́ wɨyimɨ, sɨ́á xɨ́o bɨnɨyimɨ majɨ́á nimónɨrɨ yarɨŋɨ́yimɨ boso rɨxa nɨrémónapɨrɨ re winɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Omɨ mɨŋɨ́ nɨwákwirɨ ámá naŋɨ́ ero sɨpí ero yarɨgɨ́áyɨ́ tɨ́ŋɨ́ e wárɨnɨ́árɨnɨ. E rɨ́nɨŋɨ́ xwé winarɨ́ná ŋwɨ́ earo magí írónɨro epɨ́rɨ́erɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisaso ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Ámá ‘Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ oneameŋweanɨ.’ yaiwíɨ́áyɨ́ apɨxɨ́ apɨyá wé wúkaú riwánɨŋɨ́ imónɨŋoɨ. Íwa ‘Negɨ́ ámá o xegɨ́ apɨxɨ́ sɨŋɨ́ meanímɨ nɨwirɨmiaumɨ bɨnɨŋoɨ.’ rɨnɨ́agɨ arɨ́á nɨwiro óɨ́ e oneairɨmeáronɨrɨ wigɨ́ ramɨxɨ́ xɨxegɨ́nɨ nɨmɨxárómɨ nuro óɨ́ e wenɨŋɨ́ nero ŋweagɨ́íwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Apɨxɨ́ wé ná wúnɨ íwa majɨmajɨ́á ikárɨnɨgɨ́íwarɨnɨ. Wé wɨ́úmɨ dáŋɨ́ wíwa dɨŋɨ́ píránɨŋɨ́ mogɨ́íwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Majɨmajɨ́á ikárɨnɨ́íwa ramɨxɨ́ nɨmaxɨrɨ́ná piurɨ́ sɨxɨ́ mɨmaxɨrɨgɨ́íwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dɨŋɨ́ píránɨŋɨ́ móɨ́íwa ramɨxɨ́ nɨmaxɨrɨ́ná piurɨ́ sɨxɨ́ enɨ xɨxegɨ́nɨ maxɨrɨgɨ́íwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Íwa wenɨŋɨ́ nerɨ ŋweaŋáná apɨxɨ́ sɨŋɨ́ meano sɨnɨ sɨ́á órɨpɨ́nɨ́ yarɨ́ná íwa sá niówárɨ́ nero rɨxa sá weŋáná ");
INSERT INTO aak_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","rɨxa árɨwegɨ́ imónáná rɨ́aiwá re rɨnɨŋɨnigɨnɨ, ‘Wenɨŋɨ́ époyɨ. Apɨxɨ́ sɨŋɨ́ meáo rɨxa iwo barɨnɨ. Seyɨ́né óɨ́ e wirɨménapɨ́poyɨ.’ rɨnɨ́agɨ arɨ́á nɨwiro ");
INSERT INTO aak_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","apɨxɨ́ apɨyá níwanɨ nɨwiápɨ́nɨmearo ramɨxɨ́ ápiáwɨ́ xwé owenɨrɨ ɨ́á nɨkɨnɨmɨxɨmáná ");
INSERT INTO aak_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","majɨ́á ikárɨnɨ́íwa wigɨ́ piurɨ́ yeáyɨ́ nerɨ ramɨxɨ́ supárarɨŋagɨ nɨwɨnɨro dɨŋɨ́ píránɨŋɨ́ móɨ́íwamɨ re urɨgɨ́awixɨnɨ, ‘Negɨ́ ramɨxɨ́ supárɨmɨnɨrɨ yarɨŋagɨ nánɨ sewayɨ́né piurɨ́ bɨ neaiapɨ́poyɨ.’ urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","íwa re urɨgɨ́awixɨnɨ, ‘Oweoɨ, piurɨ́ newanéyá ramɨxɨ́ sewayɨ́néyá tɨ́nɨ newanéyá tɨ́nɨ xɨxenɨ mimónɨnɨ. Newanéyá enɨ supárɨnɨgɨnɨ. Sewayɨ́né nuro segɨ́ enɨ sɨtɨwá aŋɨ́yo ámá piurɨ́ bɨ́ yarɨgɨ́áyo bɨ́ époyɨ.’ urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","majɨmajɨ́á ikárɨnɨ́íwa piurɨ́ bɨ́ yanɨro nánɨ úáná ámá apɨxɨ́ sɨŋɨ́ meáo nɨbɨrɨ apɨyá wíwa píránɨŋɨ́ nimɨxɨnɨrɨ wenɨŋɨ́ nero ŋweagɨ́íwa o tɨ́nɨ nerɨmeánɨmɨ aŋɨ́ aiwá apɨxɨ́ meanɨ nánɨ imɨxárɨ́e nánɨ nuro aŋɨ́yo páwíáná ówaŋɨ́ yárɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ówaŋɨ́ rɨxa nɨyárɨnɨmáná eŋáná apɨyá piurɨ́ bɨ́ yanɨro úɨ́íwa nɨbɨro bɨ́arɨwámɨ dánɨ re urɨgɨ́awixɨnɨ, ‘Ámɨnáoxɨnɨ, Ámɨnáoxɨnɨ, newané ówaŋɨ́ neaɨ́kwiomeaɨ.’ urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","o re urɨŋɨnigɨnɨ, ‘Nionɨ nepa seararɨŋɨnɨ. Nionɨ sewayɨ́né nánɨ majɨ́onɨrɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","re urɨŋɨnigɨnɨ, “Sɨ́á nionɨ weapɨmɨ́áyi soyɨ́né majɨ́á eŋagɨ nánɨ píránɨŋɨ́ wenɨŋɨ́ nero awínɨŋɨ́ ŋweáɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ayɨ́ rɨpɨ nánɨ ‘Awínɨŋɨ́ ŋweáɨ́rɨxɨnɨ.’ seararɨŋɨnɨ. Nionɨ ámɨ nɨweapɨrɨ́ná ámá nionɨ nɨxɨ́darɨgɨ́áyo wigɨ́ niiarɨgɨ́ápɨ xɨxenɨ wiimɨ́á eŋagɨ nánɨ nionɨ ámá amɨpí mɨmúrónɨŋɨ́ rónɨŋɨ́ imónɨŋɨnɨ. O xegɨ́ aŋɨ́ wíyo urɨ́naumɨnɨrɨ nerɨ́ná ámá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áwamɨ ‘Eɨnɨ.’ nurɨrɨ xegɨ́ iyɨ́á ɨ́á nɨgwɨ́ amɨpí píránɨŋɨ́ umeipɨ́rɨ nánɨ yaŋɨ́ nɨwirɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","omɨŋɨ́ xɨxenɨ epaxowa eŋagɨ nɨwɨnɨrɨ womɨ nɨgwɨ́ K5,000 mɨnɨ wirɨ womɨ K2,000 mɨnɨ wirɨ womɨ K1,000 mɨnɨ wirɨ nemo aŋɨ́ wíyo urɨ́naumɨnɨrɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nɨgwɨ́ K5,000 wío apaxɨ́ mé nurɨ nɨgwɨ́ apɨ tɨ́nɨ omɨŋɨ́ nerɨ́ná sayá nimɨxɨrɨ ámɨ K5,000 bɨ sayá imɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nɨgwɨ́ K2,000 wío enɨ nɨgwɨ́ apɨ tɨ́nɨ omɨŋɨ́ nerɨ́ná ámɨ K2,000 bɨ sayá imɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","E nerɨ aí nɨgwɨ́ K1,000 wío nɨgwɨ́ apɨ nɨmeámɨ nurɨ mínɨŋwɨ́ nɨrɨpɨmáná mɨraxwoyá nɨgwɨ́ pɨ́nɨ́ e tɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mɨraxwo aŋɨ́ wíyo urɨ́naumɨnɨrɨ wago neméɨsáná ámɨ nɨbɨrɨ ‘Gɨ́ nɨgwɨ́ rɨxa sayá nimɨxa ugɨ́árɨ́anɨ? Sɨŋwɨ́ owɨnɨmɨnɨ.’ nɨyaiwirɨ ‘Gɨ́ omɨŋɨ́ niiarɨgɨ́á nɨgwɨ́ wiŋáwa obɨ́poyɨ.’ ráná ");
INSERT INTO aak_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ámá nɨgwɨ́ K5,000 wiŋo nɨgwɨ́ xɨ́o wiŋɨ́pɨ tɨ́nɨ nɨgwɨ́ K5,000 xɨ́o sayá imɨxɨŋɨ́pɨ tɨ́nɨ nɨmeámɨ nɨbɨrɨ sɨwá nɨwirɨ re urɨŋɨnigɨnɨ, ‘Mɨraxwe, joxɨ xámɨ K5,000 niapɨŋɨ́pɨ ámɨ nionɨ sayá nimɨxɨrɨ́ná K5,000 ámɨ bɨ imɨxɨŋá rɨpɨ sɨŋwɨ́ wɨneɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","mɨraxwo re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ niiarɨŋoxɨnɨ, joxɨ omɨŋɨ́ niirɨ́ná anɨŋɨ́ minɨ́ naŋɨ́ niiarɨŋoxɨnɨ, joxɨ awiaxɨ́ éɨ́rɨnɨ. Omɨŋɨ́ onɨmiá nionɨ siapɨŋápɨ joxɨ anɨŋɨ́ minɨ́ píránɨŋɨ́ niiŋɨ́ eŋagɨ nánɨ gɨ́ amɨpí obaxɨ́yo merɨ́a nánɨ “Bosɨwoxɨnɨ” nɨrɨrɨrɨ orɨrɨ́peámɨnɨ. Joxɨ nɨ́wiapɨrɨ nionɨ tɨ́nɨ nawínɨ nɨŋwearɨ́ná yayɨ́ nionɨ ninarɨŋɨ́pa axɨ́pɨ yayɨ́ osinɨnɨ.’ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ámá nɨgwɨ́ K2,000 wiŋo nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Mɨraxwe, joxɨ K2,000 niapɨŋɨ́pɨ nionɨ sayá nimɨxɨrɨ́ná K2,000 ámɨ bɨ rɨpɨ xɨrɨŋá rɨpɨ sɨŋwɨ́ wɨneɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","mɨraxwo re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ nɨniiarɨŋoxɨnɨ, joxɨ omɨŋɨ́ niirɨ́ná anɨŋɨ́ minɨ́ naŋɨ́ niiarɨŋoxɨnɨ, joxɨ awiaxɨ́ éɨ́rɨnɨ. Omɨŋɨ́ onɨmiá nionɨ siapɨŋápɨ joxɨ anɨŋɨ́ minɨ́ píránɨŋɨ́ niiŋɨ́ eŋagɨ nánɨ gɨ́ amɨpí obaxɨ́yo merɨ́a nánɨ “Bosɨwoxɨnɨ” nɨrɨrɨrɨ orɨrɨ́peámɨnɨ. Joxɨ nɨ́wiapɨrɨ nionɨ tɨ́nɨ nawínɨ nɨŋwearɨ́ná yayɨ́ nionɨ ninarɨŋɨ́pa axɨ́pɨ yayɨ́ osinɨnɨ.’ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ámá nɨgwɨ́ K1,000 wiŋo nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Mɨraxwe, joxɨ arɨ́á rɨ́á wé rarɨŋoxɨrɨnɨ. Aiwá joxɨ jɨwanɨŋoxɨ ɨwɨ́á murɨŋe mirɨ ɨwɨ́ mɨmó eŋe mirɨ yarɨŋoxɨ eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","nionɨ wáyɨ́ nerɨ nɨgwɨ́ K1,000 joxɨ niapɨŋɨ́pɨ nɨmeámɨ nurɨ xwɨ́á weyárɨŋárɨnɨ. Sɨŋwɨ́ wɨneɨ. Dɨxɨ́ nɨgwɨ́pɨ ripɨrɨnɨ.’ urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","mɨraxwo re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ niiarɨŋɨ́ rɨ́wɨ́ sɨwɨ́á yiŋɨ́ roxɨnɨ, joxɨ sɨpínɨ eŋɨ́rɨnɨ. Joxɨ “Xewanɨŋo ɨwɨ́á murɨŋe mirɨ ɨwɨ́ mɨmó eŋe mirɨ yarɨŋorɨnɨ.” nɨniaiwirɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nɨgwɨ́ nionɨ siapɨŋápɨ pí nánɨ nɨgwɨ́ aŋɨ́yo mɨtɨpa eŋɨ́rɨnɨ. E nɨtɨrɨ sɨŋwɨrɨyɨ́, nɨgwɨ́ apɨ tɨ́nɨ ámɨ bɨ seáyɨ e ikwiárɨnɨŋáná meámɨnɨrɨ éárɨnɨ.’ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","wamɨ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ K1,000 xɨrɨŋomɨ nurápɨro K10,000 xɨrɨŋomɨ mɨnɨ wípoyɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ nionɨ wiŋápɨ píránɨŋɨ́ mɨmepa nerɨ kikiɨ́á nerɨ́náyɨ́ apɨ aí nurápɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Omɨŋɨ́ niiarɨŋɨ́ sɨpíomɨ ɨ́á nɨxero sɨ́á yinɨŋɨ́ bɨ́arɨwámɨnɨ moaípoyɨ. Sɨ́á yinɨŋeyɨ́ rɨ́nɨŋɨ́ ayɨkwɨ́ mɨwinɨpa enɨ́á eŋagɨ nánɨ ámá ŋwɨ́ earo magí írónɨro epɨ́rɨ́erɨnɨ.’” Jisaso ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ámɨ re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ mɨxɨ́ ináyɨ́ nimónɨrɨ nikɨ́nɨmáná gɨ́ aŋɨ́najowa tɨ́nɨ nawínɨ xɨxɨ́eánɨŋɨ́ niga nɨweapɨrane íkwiaŋwɨ́ ámáyo mí ómómɨxɨmɨ́ emɨ́ánamɨ éɨ́ ŋweááná ");
INSERT INTO aak_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ámá gwɨ́ wɨrɨ́ wɨrí nɨ́nɨ gɨ́ sɨ́mɨmaŋɨ́mɨnɨ awí eaárɨpɨ́rɨ́árɨnɨ. Awí eaáráná nionɨ ámá sipɨsipɨ́ mearɨgɨ́áwa sipɨsipɨ́ tɨ́nɨ memé tɨ́nɨ neyíroro sipɨsipɨ́ mɨdánɨ memé mɨdánɨ wárarɨgɨ́ápa ámáyo axɨ́pɨ e neyírorɨ mɨdɨmɨdánɨ nɨwárɨrɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sipɨsipɨ́ wé náúmɨnɨ wárɨrɨ memé onamɨŋúmɨnɨ wárɨrɨ emɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","E nemáná mɨxɨ́ ináyonɨ wé náúmɨnɨ nɨŋweagɨ́áyo re urɨmɨ́árɨnɨ, ‘Ámá gɨ́ ápo píránɨŋɨ́ seaimɨxɨ́ɨ́yɨ́né nɨ́wiapɨro oyá xwioxɨ́yo ŋweápoyɨ. Aŋɨ́ o xwɨ́árí imɨxɨrɨ aŋɨ́na imɨxɨrɨ eŋe dánɨ seyɨ́né nánɨ wé roárɨŋe nɨ́wiapɨro ŋweápoyɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Nionɨ agwɨ́ niarɨ́ná seyɨ́né aiwá bɨ niapagɨ́árɨnɨ. Iniɨgɨ́ nánɨ nináná iniɨgɨ́ bɨ niapagɨ́árɨnɨ. Nionɨ aŋɨ́ mɨdáŋonɨ eŋáná seyɨ́né nɨnipemeámɨ wagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iyɨ́á mayonɨ eŋáná bɨ nɨpáragɨ́árɨnɨ. Sɨmɨxɨ́ yarɨ́ná seyɨ́né nɨbɨro nɨmeŋweaagɨ́árɨnɨ. Gwɨ́ aŋɨ́yo ŋweaŋáná seyɨ́né xwɨyɨ́á nɨŋwénapagɨ́árɨnɨ.’ urɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E uráná ámá wé rónɨgɨ́áyɨ́ re nɨrɨpɨ́rɨ́árɨnɨ, ‘Ámɨnáoxɨnɨ, gíná agwɨ́ nánɨ yarɨ́ná sɨŋwɨ́ nɨranɨrane aiwá siapagwárɨnɨ? Gíná iniɨgɨ́ nánɨ sináná iniɨgɨ́ siapagwárɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gíná joxɨ aŋɨ́ mɨdáŋoxɨ́nɨŋɨ́ imónɨŋáná nɨsipemeámɨ wagwárɨnɨ? Gíná iyɨ́á mayoxɨ emearɨŋagɨ nɨranɨrane iyɨ́á rɨpáragwárɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gíná joxɨ sɨmɨxɨ́ yarɨŋagɨ rɨmeŋweaagwárɨnɨ? Gíná gwɨ́ aŋɨ́yo ŋweaŋáná xwɨyɨ́á rɨŋwénapagwárɨnɨ?’ nɨráná ");
INSERT INTO aak_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","mɨxɨ́ ináyonɨ re urɨmɨ́árɨnɨ, ‘Nepa seararɨŋɨnɨ, “Seyɨ́né ámá nionɨ gɨ́ imónɨgɨ́á tɨ́yo sɨpí apiamɨ aiwɨ arɨrá nɨwirɨ e nɨwirɨ́náyɨ́ ayɨ́ nionɨ́nɨŋɨ́ niagɨ́awixɨnɨ.” seararɨŋɨnɨ.’ urɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","E nurɨmáná wé onamɨŋúmɨnɨ nɨŋweagɨ́áyo re urɨmɨ́árɨnɨ, ‘Gorɨxo nánɨ ramɨxɨnɨgɨ́áyɨ́né pɨ́nɨ nɨnɨwiárɨmɨ nuro rɨ́á anɨŋɨ́ wearɨŋɨ́ xɨ́o obo tɨ́nɨ aŋɨ́najɨ́ xɨ́omɨ ɨ́wɨ́ wikárɨgɨ́áwa tɨ́nɨ nánɨ imɨxárɨŋɨ́rímɨ nánɨ úpoyɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Nionɨ agwɨ́ nánɨ yarɨ́ná seyɨ́né aiwá bɨ mɨniapagɨ́árɨnɨ. Iniɨgɨ́ nánɨ nináná bɨ mɨniapagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aŋɨ́ mɨdáŋonɨ eŋáná nɨnipemeámɨ wagɨ́ámanɨ. Iyɨ́á mayonɨ emearɨ́ná iyɨ́á bɨ mɨnɨpáragɨ́árɨnɨ. Sɨmɨxɨ́ weŋáná mɨnɨmeŋweaagɨ́árɨnɨ. Gwɨ́ aŋɨ́yo ŋweaŋáná xwɨyɨ́á mɨnɨŋwénapagɨ́árɨnɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","wiwanɨŋɨ́yɨ́ re nɨrɨpɨ́rɨ́árɨnɨ, ‘Ámɨnáoxɨ gíná joxɨ agwɨ́ nánɨ erɨ iniɨgɨ́ nánɨ sinɨrɨ aŋɨ́ mɨdáŋoxɨ imónɨrɨ iyɨ́á mayoxɨ erɨ sɨmɨxɨ́ werɨ gwɨ́ aŋɨ́yo ŋwearɨ yarɨŋagɨ nene sɨŋwɨ́ nɨranɨrane arɨrá mɨsipa yagwárɨnɨ?’ nɨráná ");
INSERT INTO aak_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ayo re urɨmɨ́árɨnɨ, ‘Nepa seararɨŋɨnɨ. Seyɨ́né ámá nionɨ gɨ́ imónɨgɨ́á tɨ́yo sɨpí apiamɨ aiwɨ arɨrá mɨwipa nerɨ́náyɨ́ ayɨ́ nionɨ enɨ́nɨŋɨ́ niagɨ́awixɨnɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ayɨ́ rɨ́nɨŋɨ́ anɨŋɨ́ winɨne nánɨ upɨ́rɨ́árɨnɨ. E nerɨ aí wé rónɨgɨ́áyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ tɨ́gɨ́áyɨ́ ŋweapɨ́rɨ́e nánɨ upɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisaso xwɨyɨ́á apɨ nɨpɨnɨ nurɨ́ɨsáná xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Soyɨ́né nɨjɨ́árɨnɨ. Rɨxa sɨ́á wɨyaú óráná sɨ́á Gorɨxoyá aŋɨ́najo negɨ́ arɨ́owamɨ mɨpɨkí múroŋɨ́yi —Eŋíná sɨ́á ayi Judayo Isipɨyɨ́ mɨxɨ́ ináyo ɨ́á xeŋwɨrárɨŋáná Gorɨxo niaíwɨ́ xámɨŋɨ́ nɨyonɨ opɨkímɨnɨrɨ aŋɨ́najɨ́ oyáo urowárɨŋɨ́ aiwɨ Judayɨ́ o ŋwɨ́ ikaxɨ́ urɨŋɨ́pɨ tɨ́nɨ xɨxenɨ nero bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro nɨnɨro sipɨsipɨ́ miá nɨpɨkiro ówaŋɨ́yo ragɨ́ xópé yárɨ́á eŋagɨ nánɨ aŋɨ́najo ayo múroŋɨnigɨnɨ. Ayɨnánɨ xwiogwɨ́ o o pwéáná sipɨsipɨ́ miá nɨpɨkiro bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro narɨgɨ́árɨnɨ. “Sɨ́á ayi imónáná wa ámá imónɨŋáonɨ ɨ́á nɨnɨxero émáyɨ́ íkɨ́áyo oyekwɨroárɨ́poyɨnɨrɨ mɨnɨ nɨwipɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Íná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ wigɨ́ ámɨnáowa tɨ́nɨ awa nerɨmeánɨro aŋɨ́ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e imónɨŋo, xegɨ́ yoɨ́ Kaiapasoyɨ rɨnɨŋoyáyo awí neánɨro ");
INSERT INTO aak_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","mekaxɨ́ re megɨ́awixɨnɨ, “Jisasomɨ pɨkianɨyɨ́ yumɨ́í arɨge nerane ɨ́á xɨranɨréwɨnɨ?” mekaxɨ́ e nɨmeróná ");
INSERT INTO aak_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","re nɨra ugɨ́awixɨnɨ, “None ámáyo mɨxɨ́ émɨxamoanɨgɨnɨ. Aiwá sɨ́á Gorɨxo negɨ́ arɨ́owamɨ mɨpɨkí múroŋɨ́yi nánɨ imɨxarɨ́ná ɨ́á mɨxɨrɨpa oyaneyɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisaso aŋɨ́ Betani ŋweaŋáná aŋɨ́ ámá peyɨyɨ́ yago Saimonoyáyo ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","apɨxɨ́ wí werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ sɨxɨ́ wá —Sɨxɨ́ awá nɨgwɨ́ aga xwé roŋɨ́wárɨnɨ. Awá nɨmeámɨ nɨbɨrɨ o aiwá nɨmɨnɨrɨ ŋweaŋáná í omɨ mɨŋɨ́yo iwayɨmoŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iwayɨmóagɨ wiepɨsarɨŋowa sɨŋwɨ́ e nɨwɨnɨro ímɨ wikɨ́ dɨŋɨ́ nɨwiaiwiro re rɨnɨgɨ́awixɨnɨ, “Werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ apɨ nɨgwɨ́ xwé roŋɨ́pɨ pí nánɨ xwɨrɨ́á ikɨxearɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Werɨxɨ́ apɨ nɨgwɨ́ nánɨ bɨ́ nerane sɨŋwɨrɨyɨ́, nɨgwɨ́ xwé nɨmearɨ́ná ámá uyípeayɨ́yo arɨrá nɨwirane mɨnɨ wipaxɨ́rɨnɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisaso sɨŋwɨ́ e nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Í ayɨ́ naŋɨ́ niarɨŋagɨ nánɨ pí nánɨ ayá wí rarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ, ‘Ámá uyípeayɨ́ soyɨ́né tɨ́nɨ íníná ŋweapɨ́rɨ́á eŋagɨ nánɨ rɨ́wéná aí arɨrá wipaxɨ́rɨnɨ. E nerɨ aí nionɨ íníná soyɨ́né tɨ́nɨ ŋweámɨ́ámanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Í werɨxɨ́ apɨ nionɨ nɨniwayɨmorɨ́ná ayɨ́ xwɨ́á nɨweyipɨ́rɨ nánɨ iwamɨ́ó nimɨxarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nepa seararɨŋɨnɨ. Xwɨ́á rɨrí nɨrímɨnɨ amɨ gɨmɨ xwɨyɨ́á nionɨ nánɨ yayɨ́ seainarɨŋɨ́pɨ wáɨ́ nemero nurɨmerɨ́ná apɨxɨ́ rí nionɨ werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ rɨpɨ niwayɨmóɨ́pɨ nánɨ enɨ repɨyɨ́ wíáná ‘Jisasomɨ apɨxɨ́ wí e iyí reŋɨnigɨnɨ?’ yaiwipɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E uráná Isɨkariotɨ dáŋɨ́ Judaso apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́ŋɨ́ e nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","re urɨŋɨnigɨnɨ, “Nionɨ Jisaso nánɨ mɨyɨ́ searánáyɨ́ soyɨ́né ‘Omɨ pí wianɨ́wɨnɨ.’ seaimónarɨnɨ?” urɨ́agɨ nɨgwɨ́ sirɨpá 30 ɨ́áyo nɨroaro re urɨgɨ́awixɨnɨ, “Rɨpɨ siapanɨ́wɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","o e dánɨ “Xegɨ́pɨ ŋweaŋáná pasá umemɨ nánɨ sɨŋwɨ́ owɨnaxɨ́dɨmemɨnɨ.” nɨyaiwirɨ e eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sɨ́á iwamɨ́ó Judayɨ́ bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro narɨgɨ́áyɨ́ iwamɨ́óyi imónáná wiepɨsarɨŋowa Jisasomɨ nɨbɨro re urɨgɨ́awixɨnɨ, “Ge nurane aiwá Aŋɨ́najo Neamúroŋɨ́yimɨ nánɨ yeaanarɨŋwápɨ joxɨ tɨ́nɨ nanɨ imɨxanɨréwɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","o wiepɨsarɨŋɨ́yɨ́ waúmɨ re urɨŋɨnigɨnɨ, “Awagwí Jerusaremɨ nánɨ nuri ámá nionɨ eararɨŋáomɨ nɨwímearɨ́ná re urɨ́piyɨ, ‘Yegɨ́ yearéwapɨyarɨŋo re rɨŋoɨ, “Nionɨ xeanɨŋɨ́ nipɨ́rɨ aŋwɨ ayorɨnɨ. Gɨ́ wiepɨsarɨŋowa tɨ́nɨ joxɨyá aŋɨ́yo aiwá Aŋɨ́najo negɨ́ arɨ́owamɨ mɨpɨkí wiárɨ́ Múroŋɨ́yi nánɨ nanɨ́wɨnɨ.” rɨŋoɨ.’ urɨ́piyɨ.” urowárɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","wiepɨsarɨŋowaú nuri Jisaso urɨ́ɨ́pa axɨ́pɨ neri sɨ́á Aŋɨ́najo Múroŋɨ́yi nánɨ sipɨsipɨ́ miá wo nɨpɨkiri rɨyamɨ́ egɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sɨ́ápɨ tɨ́nɨ Jisaso xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú tɨ́nɨ nɨbɨro íkwiaŋwɨ́yo éɨ́ nɨŋwearo ");
INSERT INTO aak_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aiwá awaú nimɨxɨri tɨ́ípɨ nɨnɨróná o re urɨŋɨnigɨnɨ, “Nepa seararɨŋɨnɨ. Soyɨ́né woxɨ nionɨ nánɨ mɨyɨ́ nurɨrɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","awa dɨŋɨ́ rɨ́á uxéagɨ wo wo re nura ugɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, nionɨ nánɨ mɨrarɨŋɨnɨ. Nionɨ nánɨ mɨrarɨŋɨnɨ.” nura úagɨ́a ");
INSERT INTO aak_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","o re urɨŋɨnigɨnɨ, “Múyo nionɨ tɨ́nɨ axíná eagwiarɨgwɨ́ío mɨyɨ́ nurɨnorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ámá imónɨŋáonɨ rɨ́wamɨŋɨ́ neánɨrɨ rɨnɨŋɨ́pa xɨxenɨ nipɨ́rɨ aiwɨ ámá nionɨ nánɨ mɨyɨ́ nurɨrɨ pasá nɨmeno Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ winɨ́á eŋagɨ nánɨ aweyɨ. Xɨnáí omɨ mɨxɨrɨpa nerɨ sɨŋwɨrɨyɨ́, rɨ́nɨŋɨ́ Gorɨxo winɨ́ápɨ winɨmɨnɨrɨ eŋɨ́ meŋagɨ nánɨ naŋɨ́ imónɨmɨnɨrɨ eŋɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judaso, mɨyɨ́ urɨno re urɨŋɨnigɨnɨ, “Nɨréwapɨyarɨŋoxɨnɨ, ‘Aga nionɨmanɨ.’ nimónarɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Jɨwanɨŋoxɨ aí nɨrarɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisaso awa sɨnɨ aiwá nɨnɨróná bisɨ́kerɨ́á bɨ nɨmearɨ apɨ nánɨ Gorɨxomɨ yayɨ́ nɨwirɨ kwɨkwɨrɨmɨ́ nerɨ wiepɨsarɨŋowamɨ mɨnɨ nɨwirɨ re urɨŋɨnigɨnɨ, “Rɨpɨ ayɨ́ gɨ́ warárɨnɨ. Nɨnɨrápɨro nɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","kapɨxɨ́ iniɨgɨ́ wainɨ́ ínɨŋɨ́wá nɨmearɨ Gorɨxomɨ yayɨ́ nɨwimáná awamɨ mɨnɨ nɨwirɨ re urɨŋɨnigɨnɨ, “Noyɨ́nénɨ rɨwá nɨ́poyɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Nionɨ ámá nɨ́nɨ nánɨ nɨpɨkíáná ragɨ́ nionɨyá xwɨ́áyo pwarɨŋagɨ nɨwɨnɨrɨ́ná re yaiwipɨ́ráoɨ, ‘Xwɨyɨ́á sɨŋɨ́ réroárɨŋɨ́pɨ rɨxa yoxáɨ́nɨŋɨ́ yɨpámoŋoɨ. Nene ɨ́wɨ́ yarɨŋwápɨ yokwarɨmɨ́ neaiinɨ nánɨ rɨ́a eŋoɨ?’ yaiwipɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","E nerɨ aí re seararɨŋɨnɨ, ‘Nionɨ re dánɨ iniɨgɨ́ wainɨ́ ámɨ wí mɨnɨ́ néra núɨsáná gɨ́ ápo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nɨseairɨ seameŋweanɨ́e dánɨ ámɨ nionɨ tɨ́nɨ nawínɨ ananɨ nanɨ́wárɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","soŋɨ́ Gorɨxomɨ yayɨ́ umeanɨro nɨrɨmowa nɨpeyearo dɨ́wɨ́ Oripipámɨ nánɨ yigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisaso wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Sɨ́á rɨyimɨ soyɨ́né noyɨ́nénɨ nɨniepɨsamoárɨmɨ upɨ́ráoɨ. Rɨ́wamɨŋɨ́ neánɨrɨ ewayɨ́ xwɨyɨ́á soyɨ́né nánɨ re rɨnɨŋɨ́pɨ, ‘Gorɨxonɨ sipɨsipɨ́ xiáwomɨ pɨkioreawáráná sipɨsipɨ́ amɨ amɨ uminɨ́árɨnɨ.’ rɨnɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ nionɨ nɨniepɨsamoárɨmɨ éɨ́ upɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nionɨ nɨnɨpɨkiro aí nionɨ Gorɨxoyá dɨŋɨ́yo dánɨ nɨwiápɨ́nɨmeámáná Gariri pɨropenɨsɨ́yo nánɨ xámɨ yimɨ́árɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitao re urɨŋɨnigɨnɨ, “Ámá wa nowanɨ nɨsiepɨsamoárɨmɨ úagɨ́a aiwɨ nionɨ wí nɨsiepɨsamoárɨmɨ éɨ́ umɨméɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisaso re urɨŋɨnigɨnɨ, “Nepa rɨrarɨŋɨnɨ. Sɨ́á rɨyimɨ árɨwegɨ́mɨ karɨ́karɨ́ sɨnɨ rɨ́aiwá mɨrarɨ́ná joxɨ nionɨ nánɨ rɨpiaú rɨpɨ re nurɨrɨ́ɨnɨ, ‘Nionɨ o nánɨ majɨ́árɨnɨ.’ nurɨrɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitao re urɨŋɨnigɨnɨ, “Nionɨ enɨ joxɨ tɨ́nɨ nɨnɨpɨkiro aiwɨ ‘O nánɨ nionɨ majɨ́árɨnɨ.’ wí rɨmɨméɨnɨ.” nurɨrɨ wiepɨsarɨŋɨ́ wɨ́a enɨ axɨ́pɨnɨ e nura ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisaso awa tɨ́nɨ omɨŋɨ́ ojɨkwɨ́í Gesemaniyɨ rɨnɨŋe nɨrémoro re urɨŋɨnigɨnɨ, “Soyɨ́né re ŋweaŋáná nionɨ dae nurɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wimɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitaomɨ tɨ́nɨ Sebediomɨ xewaxowaúmɨ tɨ́nɨ nɨwirɨmeámɨ nurɨ dɨŋɨ́ rɨ́á uxearɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","awamɨ re urɨŋɨnigɨnɨ, “Nionɨ dɨŋɨ́ rɨ́á nɨxearɨŋagɨ nánɨ rɨxa nɨpepaxɨ́ niarɨnɨ. Soyɨ́né re nɨŋweámáná nionɨ tɨ́nɨ nawínɨ awí oŋweaaneyɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","nɨwárɨmɨ bɨ onɨmiápɨ nurɨ sɨ́mɨmaŋɨ́mɨnɨ nɨpɨ́kínɨmearɨ Gorɨxomɨ rɨxɨŋɨ́ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “Gɨ́ ápoxɨnɨ, ananɨ e epaxɨ́ eŋánáyɨ́, xeanɨŋɨ́ nionɨ nímeanɨ́yɨ́ kapɨxɨ́ nionɨ nɨmɨ́nɨŋɨ́ imónɨŋɨ́wá ananɨ nɨnɨrápɨrɨ emɨ miwayɨmorɨréɨnɨ? Nionɨ e rɨrarɨŋagɨ aiwɨ dɨŋɨ́ nionɨyáyo mɨxɨ́dɨ́ joxɨyáyo xɨ́deɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","wiepɨsarɨŋowa wárɨ́e nánɨ nɨbɨrɨ awa sá weŋagɨ́a nɨwɨnɨrɨ Pitaomɨ re urɨŋɨnigɨnɨ, “Soyɨ́né nionɨ tɨ́nɨ bɨ onɨmiápɨ awí nɨŋwearane nawínɨ mɨŋweapaxɨ́ rɨseaimónarɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Soyɨ́né dɨŋɨ́ re nɨseaimónɨrɨ aiwɨ, ‘Jisasomɨ pí pí wímeáagɨ aiwɨ ananɨ númɨ xɨ́danɨ́wárɨnɨ.’ nɨseaimónɨrɨ aiwɨ segɨ́ wará éɨ́ seainɨnɨŋoɨ. Éɨ́ mɨseainɨpa enɨ nánɨ awí nɨŋwearo Gorɨxomɨ rɨxɨŋɨ́ re urɨ́poyɨ, ‘Awamɨ obo yapɨ́ owíwapɨyinɨrɨ sɨŋwɨ́ mɨneanɨpa eɨ.’ urɨ́poyɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ámɨ bɨ nurɨ rɨxɨŋɨ́ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “Gɨ́ ápoxɨnɨ, nionɨ kapɨxɨ́ xeanɨŋɨ́ nímeanɨ nánɨ imónɨŋɨ́wá mɨnɨpaxɨ́ imónɨŋánáyɨ́, mɨnɨmúropaxɨ́ eŋánáyɨ́, joxɨ simónarɨŋɨ́pɨ oimónɨnɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ámɨ nɨbɨrɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Wiepɨsarɨŋowa sɨŋwɨ́ sipɨ́xɨpɨ́xɨ́ wiarɨŋagɨ sá riwa weŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ámɨ awamɨ pɨ́nɨ nɨwiárɨmɨ bɨ nurɨ xámɨ xanomɨ rɨxɨŋɨ́ nurɨrɨ́ná urɨ́ɨ́pa axɨ́pɨ ámɨ nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","nɨbɨrɨ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né sɨnɨ kikiɨ́á nero sá riwoyɨ́né rɨweŋoɨ? Arɨ́á reŋoɨ? Ámá imónɨŋáonɨ ɨ́wɨ́ yarɨgɨ́áyɨ́ pasá nɨnɨmero ɨ́á nɨxɨrɨpɨ́rɨ rɨxa iyíxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Rɨxa wiápɨ́nɨmeápoyɨ. Oweaneyɨ. Sɨŋwɨ́ wɨnɨ́poyɨ. Pasá nɨmeno rɨxa iwo yaparɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Judaso —O wiepɨsarɨŋɨ́ worɨnɨ. O ámá obaxɨ́ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ urowárɨ́áwa, wigɨ́ kirá tɨ́nɨ iwaŋɨ́ tɨ́nɨ nɨmaxɨmɨ Judasomɨ rɨ́wɨ́yo xɨ́dɨgɨ́áwa o nipemaxɨmɨ Jisaso tɨ́ŋɨ́ e rémónapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","E nɨrémónapɨmáná óɨ́ e dánɨ re urɨ́ɨ́pa, “Nionɨ pasá numerɨ kíyɨ́ miaúnáná ayɨ́ sɨ́mɨmajɨ́ónɨŋɨ́ seaiarɨŋɨnɨ. Soyɨ́né ‘O Jisasorɨ́anɨ?’ nɨyaiwiro ɨ́á xɨrɨ́ɨ́rɨxɨnɨ.” urɨ́ɨ́pa ");
INSERT INTO aak_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jisasomɨ nɨwímearɨ́ná aŋɨ́nɨ yayɨ́ “Gɨ́ nɨréwapɨyarɨŋoxɨnɨ” nurɨrɨ kíyɨ́ miaúnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kíyɨ́ miaúnáná Jisaso re urɨŋɨnigɨnɨ, “Nɨgɨ́ nɨkumɨxɨnɨrɨ emearɨgwɨ́íoxɨnɨ, joxɨ nionɨ nimɨnɨrɨ barɨŋɨ́pɨ rɨxa rɨniarɨŋɨnɨ?” uráná awa mɨ́rɨ́ nɨbɨro omɨ ɨ́á xɨrɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɨ́á xɨrarɨ́ná Jisaso tɨ́nɨ rogɨ́áwa wo xegɨ́ kirá reŋɨ́ nɨmɨxearɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá omɨŋɨ́ wiiarɨŋomɨ mɨŋɨ́ orómɨnɨrɨ éɨ́yɨ́ pɨ́rɨ́ nɨmoyɨ́kirɨ arɨ́á mɨŋɨ́ nɨwirɨ́piearɨ mamówárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Arɨ́á mɨŋɨ́ nɨwirɨ́piearɨ mamówáráná Jisaso re urɨŋɨnigɨnɨ, “Kirápá aŋɨ́wámɨ ámɨ sɨxɨ́ ikwaseaáreɨ. Xwɨyɨ́á re rɨnɨŋɨ́pɨ, ‘Ámá kirá ɨ́á nɨmaxɨrɨro ámá pɨkianɨro emearɨgɨ́á gɨyɨ́ gɨyo wínɨyɨ́ enɨ kirá tɨ́nɨ pɨkipɨ́rɨ́árɨnɨ.’ rɨnɨŋɨ́pɨ dɨŋɨ́ rɨmoarɨŋɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Joxɨ dɨŋɨ́ re rɨyaiwiarɨŋɨnɨ, ‘O xegɨ́ xanomɨ yarɨŋɨ́ nɨwirɨ́náyɨ́, xano éɨ́ umínɨ nánɨ aŋɨ́najɨ́ sɨmɨŋɨ́ wínarɨgɨ́áwa ɨ́á mɨropaxɨ́ wí e bɨ wí e bɨ miaúrárɨ́ wé wúkaú sɨkwɨ́ waú inɨŋɨ́pɨ murowárénapɨpaxɨ́rɨnɨ.’ rɨyaiwiarɨŋɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Oweoɨ, ápo nurowárénapɨpaxɨ́ aiwɨ nionɨ apɨ nánɨ yarɨŋɨ́ nɨwirɨ́náyɨ́, rɨ́wamɨŋɨ́ nionɨ nánɨ ‘E nɨwiro pɨkipɨ́rɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ arɨge xɨxenɨ imónɨnɨŋoɨ?” E nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","xɨ́omɨ ɨ́á xɨranɨro bɨ́áyo re urɨŋɨnigɨnɨ, “Soyɨ́né ámá ɨ́wɨ́ xauráparɨŋɨ́ womɨ ɨ́á xɨranɨro nánɨ yarɨgɨ́ápa kirá tɨ́nɨ iwaŋɨ́ tɨ́nɨ ɨ́á nɨmaxɨrɨmɨ nionɨ ɨ́á nɨxɨranɨro rɨbarɨŋoɨ? Sɨ́á ayɨ́ ayo nionɨ aŋɨ́ rɨdɨyowá nánɨ mɨrɨnɨŋiwámɨ nɨŋweámáná searéwapɨyarɨŋagɨ aiwɨ soyɨ́né wí ɨ́á nɨxɨranɨro egɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","E nerɨ aí wɨ́á rókiamoagɨ́áwa nionɨ nánɨ nɨrɨro Bɨkwɨ́yo eagɨ́ápɨ xɨxenɨ imónɨnɨ nánɨ soyɨ́né e niarɨŋoɨ.” uráná wiepɨsarɨŋowa nowanɨ omɨnɨ nɨwiepɨsamoárɨmɨ éɨ́ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisasomɨ ɨ́á xɨrɨ́áyɨ́ omɨ nɨméra nuro Kaiapasoyá aŋɨ́yo ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ awí eánarɨgɨ́e nánɨ nɨmeámɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitao “Jisasomɨ pí wipɨ́rɨréoɨ?” nɨyaiwirɨ ná jɨ́amɨ dánɨ anɨnaxɨ́dɨ́ nɨwiéra númɨ nurɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá aŋɨ́ ákɨŋáyo nɨpáwirɨ porisowa tɨ́nɨ nawínɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa nowanɨ tɨ́nɨ omɨ pɨkipɨ́rɨ nánɨ “Sɨŋwɨ́ ɨ́wɨ́ wɨnarogɨ́á xwɨyɨ́á omɨ pɨkipaxɨ́ imónɨŋɨ́yɨ́ bɨ ouxekwɨ́mópoyɨ.” nɨyaiwiro “Xwɨyɨ́á omɨ uxekwɨ́mopaxɨ́ bɨ oimónɨnɨ.” nɨyaiwiro rayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ámá obaxɨ́ nɨbayiro omɨnɨ nuxekwɨ́moro aiwɨ omɨ ananɨ pɨkipaxɨ́ wí mimónɨ́ nɨyayíɨ́asáná waú nɨbɨri ");
INSERT INTO aak_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","omɨ nuxekwɨ́mori re rɨgɨ́isixɨnɨ, “Ámá ro re rɨŋorɨnɨ, ‘Nionɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwá nɨpɨnearɨ sɨ́á wɨyaú wɨyimɨnɨ ámɨ mɨrɨpaxonɨrɨnɨ.’ rɨŋorɨnɨ.” rɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","E nɨrɨmáná eŋáná apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋo nɨwiápɨ́nɨmearɨ re urɨŋɨnigɨnɨ, “‘Joxɨnɨ́ xwɨyɨ́á rɨxekwɨ́moarɨgɨ́áyɨ́ nánɨ xwɨyɨ́á wí mɨrɨpaxɨ́ rɨsiarɨnɨ? Sɨnɨ xwɨyɨ́á nɨrɨxekwɨ́morɨ́ná rarɨgɨ́ípɨ, ayɨ́ pí nánɨ rarɨŋiɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisaso xwɨyɨ́á bɨ murɨŋɨnigɨnɨ. Xwɨyɨ́á bɨ murarɨŋagɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ xwéo sɨŋwɨ́ e nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ nepa Kiraisoxɨ, ámá yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨ eŋánáyɨ́, nepa niaíwɨ́ Gorɨxoyáoxɨ eŋánáyɨ́, Ŋwɨ́á anɨŋɨ́ sɨŋɨ́ imónɨŋo tɨ́ŋɨ́ e dánɨ́nɨŋɨ́ nɨrɨrɨ áwaŋɨ́ neareɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisaso re urɨŋɨnigɨnɨ, “Oyɨ, ayɨ́ rɨxa joxɨ rarɨŋɨnɨ. E nerɨ aí re rɨrarɨŋɨnɨ, ‘Rɨ́wéná seyɨ́né ámá imónɨŋáonɨ Gorɨxo eŋɨ́ sɨxɨ́ eánɨŋoyá wé náúmɨnɨ ŋweaŋagɨ sɨŋwɨ́ nanɨro aŋɨ́namɨ dánɨ agwɨ́ tɨ́nɨ weaparɨŋagɨ nanɨro epɨ́rɨ́árɨnɨ.’ rɨrarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Apaxɨ́pánɨŋɨ́ imónɨŋɨ́ xwéo wikɨ́ nɨwónɨrɨ xewanɨŋo xegɨ́ rapɨrapɨ́ yínɨŋú naxerɨ ámɨnáowamɨ re urɨŋɨnigɨnɨ, “Ámá ro Gorɨxomɨ xewaxonɨgɨnɨrɨ rɨxa omɨ rɨperɨrɨ́ umearɨnɨ. Ámá wínɨ wínɨ omɨ xwɨyɨ́á uxekwɨ́mopɨ́rɨ bɨpaxɨ́ mimónɨnɨ. Ai, o Gorɨxomɨ rɨperɨrɨ́ umearɨ́ná sewanɨŋoyɨ́né rɨxa arɨ́á wíoɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Soyɨ́né dɨŋɨ́ pí yaiwiarɨŋoɨ?” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “‘O rɨ́ɨ́pɨ rɨxa nɨpɨkipaxɨ́rɨnɨ.’ neaimónarɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","omɨ sɨ́mɨmaŋɨ́yo reaŋwɨ́ úrɨro wé amɨmá nemáná earo nerɨ́ná wa wé piárá nupɨkákwiayiróná ");
INSERT INTO aak_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","re urayigɨ́awixɨnɨ, “Kiraisoxɨnɨ, dɨxɨ́ imónɨgɨ́áyo yeáyɨ́ uyimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋoxɨnɨ, áwaŋɨ́ nɨnearɨrɨ wɨ́á nearókiamoɨ. Agwɨ iwaŋɨ́ go reaarɨnɨ? Iwaŋɨ́ go reaarɨnɨ?” urayigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitao, aŋɨ́ ákɨŋáyo ínɨrɨwámɨnɨ ŋweaŋomɨ apɨxɨ́ omɨŋɨ́ wiiarɨŋɨ́ wí re urɨŋɨnigɨnɨ, “Joxɨ Gariri pɨropenɨsɨ́yo dáŋɨ́ Jisaso tɨ́nɨ emearɨŋɨ́ woxɨrɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pitao “Oweoɨ.” nurɨrɨ “Jíxɨ rarɨŋɨ́yɨ́ nánɨ nionɨ majɨ́árɨnɨ.” nurɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ɨ́wí ákɨŋá tɨ́ŋɨ́ e roŋáná ámɨ wí nɨbɨrɨ omɨ sɨŋwɨ́ nɨwɨnɨrɨ ámá e ŋwɨxapɨgɨ́áyo re urɨŋɨnigɨnɨ, “Ámá royɨ́ Nasaretɨ dáŋɨ́ Jisaso tɨ́nɨ emearɨgɨ́áyɨ́ worɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitao “Oweoɨ.” nurɨrɨ́ná “Xwɨ́á tɨ́ tɨ́ŋɨ́ e dánɨ seararɨŋɨnɨ. Ámá o nánɨ nionɨ majɨ́árɨnɨ.” nurɨmáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","rɨ́wɨ́yo onɨmiápɨ e rówapɨgɨ́áyɨ́ aŋwɨ e nɨbɨro Pitaomɨ re urɨgɨ́awixɨnɨ, “‘Xwɨyɨ́á joxɨyá Gariri pɨropenɨsɨ́yo dáŋɨ́yɨ́ rarɨgɨ́ápɨ axɨ́pɨ rarɨŋagɨ nánɨ joxɨ ayɨ́yá woxɨrɨnɨ.’ neaimónarɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","o sɨpí ikaxɨ́ nɨméperɨ re urɨŋɨnigɨnɨ, “Xwɨ́á tɨ́ tɨ́ŋɨ́ e dánɨ re seararɨŋɨnɨ, ‘Nepa o nánɨ nionɨ majɨ́árɨnɨ.’ seararɨŋɨnɨ.” uráná re eŋɨnigɨnɨ. Karɨ́karɨ́ rɨ́aiwá rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Karɨ́karɨ́ rɨ́aiwá ráná ámɨ pɨ́né Jisaso urɨ́ɨ́pɨ “Karɨ́karɨ́ sɨnɨ rɨ́aiwá mɨrɨŋáná joxɨ biaú bɨ ámá wíyo re urɨrɨ́ɨnɨ, ‘O nánɨ nionɨ majɨ́árɨnɨ.’ urɨrɨ́ɨnɨ.” urɨ́ɨ́pɨ dɨŋɨ́ nɨwinɨrɨ e dánɨ nɨpeyearɨ ŋwɨ́ pɨyɨ́ wɨ́rɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wɨ́ápɨ tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ Jisasomɨ nɨpɨkipɨ́rɨ nánɨ xwɨyɨ́á numearɨmáná ");
INSERT INTO aak_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","gwɨ́ nɨyiro nɨmeámɨ nuro émáyɨ́ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e wárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judaso, Jisasomɨ mɨyɨ́ urɨ́o mebáowa “Jisaso xewanɨŋo rɨ́ɨ́pɨ nánɨ pɨkipaxɨ́ imónɨŋagɨ nánɨ émáyɨ́ opɨkípoyɨ.” rarɨŋagɨ́a arɨ́á nɨwirɨ dɨŋɨ́ sɨpí wíagɨ nɨgwɨ́ sirɨpá 30 mɨnɨ wíɨ́ápɨ ámɨ nɨmeámɨ nurɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ tɨ́nɨ Judayɨ́ mebáowamɨ tɨ́nɨ mɨnɨ wimɨnɨrɨ nerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","re urɨŋɨnigɨnɨ, “Nionɨ ámá ɨ́wɨ́ bɨ méomɨ mɨyɨ́ nurɨrɨ nánɨ sɨpí ikárɨnɨ́anigɨnɨ.” urɨ́agɨ aí awa re urɨgɨ́awixɨnɨ, “Jɨwanɨŋoxɨ éɨ́pɨ nánɨ none pí nánɨ neararɨŋɨnɨ? Jɨwanɨŋoxɨ ikɨxéɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judaso nɨgwɨ́pɨ rɨdɨyowá yarɨgɨ́iwámɨ e emɨ nɨmoánɨmo nurɨ xewanɨŋo gwɨ́ yaímɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judaso peyeááná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa nɨgwɨ́ apɨ nɨmearo re rɨnɨgɨ́awixɨnɨ, “Nɨgwɨ́ rɨpɨ ámá opɨkípoyɨnɨrɨ wíwápɨ eŋagɨ nánɨ nɨgwɨ́ Gorɨxo nánɨ aŋɨ́ riwámɨ tarɨgɨ́ápɨ tɨ́nɨ nawínɨ nɨkwierorɨ́náyɨ́, ayɨ́ nɨpɨkwɨnɨ menɨnɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","nɨgwɨ́ apɨ nánɨ xwɨyɨ́á nɨrɨnɨ́áwa nɨgwɨ́ apɨ nɨmeámɨ nuro ámá mɨdáŋɨ́ imónɨgɨ́áyɨ́ xwɨ́á weyipɨ́rɨ́a nánɨ xwɨ́á xegɨ́ yoɨ́ Xwárɨ́á Sɨxɨ́ Imɨxarɨgɨ́áyɨ́yápɨyɨ rɨnɨŋɨ́pɨ bɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɨgwɨ́ ámá opɨkípoyɨnɨrɨ wigɨ́ápɨ tɨ́nɨ xwɨ́á apɨ bɨ́ éagɨ́a nánɨ yoɨ́ Ragɨ́pɨyɨ wɨ́ragɨ́árɨnɨ. Agwɨ enɨ sɨnɨ e nɨra warɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Awa e éáná xwɨyɨ́á Gorɨxoyá wɨ́á rókiamoagɨ́ Jeremaiao nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́ rɨpɨ, “Awa nɨgwɨ́ 30 Isɨrerɨyɨ́ ‘Ámá wo xegɨ́ wo nánɨ mɨyɨ́ nearáná wianɨ́wárɨnɨ.’ rɨnɨgɨ́ápɨ nɨmearo ");
INSERT INTO aak_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","xwɨ́á xegɨ́ yoɨ́ Xwárɨ́á Sɨxɨ́ Imɨxarɨgɨ́áyɨ́yápɨyɨ rɨnɨŋɨ́pɨ Gorɨxo sekaxɨ́ nɨrɨŋɨ́pɨ tɨ́nɨ xɨxenɨ bɨ́ nero mɨnɨ wigɨ́awixɨnɨ.” Xwɨyɨ́á e nɨrɨnɨrɨ eánɨŋɨ́pɨ íná xɨxenɨ e imónɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasomɨ nɨmeámɨ nuro gapɨmanɨ́ Pairato tɨ́ŋɨ́ e mearémóáná gapɨmano yarɨŋɨ́ nɨwiayirɨ́ná re urɨŋɨnigɨnɨ, “Joxɨ mɨxɨ́ ináyɨ́ Judayɨ́yáoxɨranɨ?” urɨ́agɨ Jisaso “Joxɨ e rarɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́yá mebáowa tɨ́nɨ xwɨyɨ́á obaxɨ́ omɨnɨ uxekwɨ́moarɨŋagɨ́a aiwɨ o xwɨyɨ́á xɨxe urɨpaxɨ́ nimónɨrɨ aí bɨ murɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xwɨyɨ́á bɨ murɨ́ yarɨŋagɨ Pairato sɨŋwɨ́ e nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Xwɨyɨ́á obaxɨ́ ‘Joxɨnɨ́ rɨxekwɨ́moayarɨgɨ́áyo arɨ́á mɨwipa rɨyarɨŋɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisaso xɨ́omɨ uxekwɨ́moarɨgɨ́á bɨ nánɨ aí xɨ́o bɨ murɨ́ yarɨŋagɨ nɨwɨnɨrɨ ududɨ́ winɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sɨ́á Gorɨxo Judayo mɨpɨkí wiárɨ́ múroŋɨ́yi imónɨŋáná xwiogwɨ́ ayɨ́ ayo Judayɨ́ nuro wigɨ́ gwɨ́ ŋweagɨ́á wo nánɨ émáyɨ́ gapɨmanomɨ yarɨŋɨ́ wíáná o ayo yayɨ́ owimómɨnɨrɨ wigɨ́ go go nánɨ wimónarɨŋɨ́yɨ́ wáriagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Íná wigɨ́ ámá gwɨ́ ŋweaŋɨ́ wo Barabasoyɨ rɨnɨŋo Judayɨ́ nɨ́nɨ yoɨ́ oyá nɨjɨ́á imónɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ayɨnánɨ ámá sɨpɨ́á ayɨ́ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e awí eánáná o re urɨŋɨnigɨnɨ, “Nionɨ go seawárimɨ́ɨnɨ? Barabaso seawárimɨnɨréɨnɨ? Jisaso, ámá Kiraisoyɨ rarɨgɨ́o seawárimɨnɨréɨnɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ayɨ́ rɨpɨ nánɨ e urɨŋɨnigɨnɨ. O nɨjɨ́árɨnɨ. Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa Jisasomɨ sɨpí dɨŋɨ́ nɨwiaiwiro nánɨ xɨ́o tɨ́ŋɨ́ e wárɨ́á nánɨ o nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Rɨpɨ nánɨ enɨ “Jisaso seawárimɨnɨréɨnɨ?” urɨŋɨnigɨnɨ. O íkwiaŋwɨ́ xwɨrɨxɨ́ mearɨŋɨ́námɨ éɨ́ ŋweaŋáná xiepí Jisaso nánɨ xwɨyɨ́á re urowárénapɨŋɨnigɨnɨ, “Árɨ́wɨyimɨ ámá o nánɨ orɨŋá nɨwɨnɨrɨ́ná dɨŋɨ́ rɨ́á nɨxéɨnigɨnɨ. Ayɨnánɨ ámá wé rónɨŋɨ́ omɨ sɨpí wí mɨwimɨxɨpanɨ.” urowárɨ́ɨ́ eŋagɨ o ámá e epɨ́royɨ́ egɨ́áyo “Jisaso seawárimɨnɨréɨnɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","E urɨ́agɨ aiwɨ wɨ́á mónɨŋɨ́mɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́yá mebáowa tɨ́nɨ ámá oxɨ́ apɨxɨ́ aiwá apɨ nánɨ epɨ́royɨ́ egɨ́áyo re urɨméɨ́á eŋagɨ nánɨ, “‘Barabasomɨ neawáriɨ.’ urɨro ‘Jisasomɨ opɨkípoyɨ.’ urɨro éɨ́rɨxɨnɨ.” urɨméɨ́á eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","gapɨmano ámá e epɨ́royɨ́ egɨ́áyo “Ámá rowaú gɨ́mɨnɨ go seawárimɨ́ɨnɨ?” uráná ayɨ́ re urɨgɨ́awixɨnɨ, “Barabaso neawáriɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pairato re urɨŋɨnigɨnɨ, “Nionɨ Jisaso, ámá Kiraisoyɨ rarɨgɨ́omɨ pí wimɨ́ɨnɨ?” urɨ́agɨ nɨ́nɨ re urɨgɨ́awixɨnɨ, “Omɨ íkɨ́áyo seáyɨ e oyekwɨroárɨ́poyɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","o re urɨŋɨnigɨnɨ, “Pí nánɨ? Pí ɨ́wɨ́ éɨ́ nánɨ yekwɨroárɨmɨ́ɨnɨ?” urɨ́agɨ aiwɨ ayɨ́ xwamiánɨ́ nura nuro re urɨgɨ́awixɨnɨ, “Omɨ oyekwɨroárɨ́poyɨ.” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pairato “Gɨ́ xwɨyɨ́á arɨ́á mɨnipa epɨ́rɨ eŋagɨ nánɨ ámɨ bɨ nurɨrɨ aí naŋɨ́ wí imónɨnɨmenɨŋoɨ. Rɨxa mɨxɨ́nɨ épɨ́mɨxamopɨ́ráoɨ.” nɨyaiwirɨ ámá ayɨ́ re oyaiwípoyɨnɨrɨ, “O ‘Jisasomɨ xe oyekwɨroárɨ́poyɨ.’ nɨrɨrɨ aí ‘Reá mɨroánɨpa oemɨnɨ.’ nɨyaiwirɨ rɨ́a yarɨnɨ?” oyaiwípoyɨnɨrɨ wigɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ wé wayɨ́ nɨrónɨrɨ re urɨŋɨnigɨnɨ, “Ámá ro maŋɨ́ nionɨyáyo dánɨ pɨkipɨ́rɨméoɨ. Sewanɨŋɨ́yɨ́né segɨ́ maŋɨ́yo dánɨ pɨkipɨ́ráoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ámá nɨ́nɨ re urɨgɨ́awixɨnɨ, “Oyá ragɨ́ pí enɨŋoɨ xe oneaxénɨnɨ. Negɨ́ niaíwɨ́yo enɨ xe oxénɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pairato re eŋɨnigɨnɨ. Barabaso nɨwárirɨ porisowamɨ re urɨŋɨnigɨnɨ, “Jisasomɨ sɨkwɨ́á ragɨ́ pɨ́rɨ́ nuyɨkímáná íkɨ́áyo seáyɨ e yekwɨroárɨ́poyɨ.” nurɨrɨ mɨnɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Porisowamɨ mɨnɨ wíáná awa Jisasomɨ nɨmeámɨ gapɨmanɨ́yɨ́yá aŋɨ́yo —Aŋɨ́ yoɨ́ Pɨretoriumɨyɨ rɨnɨŋɨ́yorɨnɨ. Aŋɨ́ ayo nɨpáwiro porisɨ́ nowamɨnɨ “Eɨnɨ.” nurɨro “Omɨ rɨperɨrɨ́ omépeaneyɨ.” nɨrɨnɨro re egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Omɨ rapɨrapɨ́ xegɨ́ yínɨŋú nɨwirɨro emɨ moro ámɨ ayɨ́á rɨŋɨ́ wú, mɨxɨ́ ináyowa yínarɨgɨ́áyo dáŋɨ́yɨ́ wú nɨmearo uyírɨro ");
INSERT INTO aak_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ópɨyá eŋɨ́nɨŋɨ́ imónɨŋɨ́ wɨrí nɨkɨ́kɨyimáná mɨxɨ́ ináyɨ́ amɨnaŋwɨ́nɨŋɨ́ imónɨŋɨ́ mɨŋɨ́yo dɨ́kínarɨgɨ́ápa omɨ eŋɨ́ tɨ́nɨ mɨŋɨ́yo udɨ́kiárɨro xoyɨ́wá wɨyi mɨxɨ́ ináyowa maxɨrarɨgɨ́ápa ɨ́á umɨrɨro nemáná agwɨ́rɨwámɨnɨ xómɨŋɨ́ nɨyɨkwiro rɨperɨrɨ́ numerɨ́ná re urayigɨ́awixɨnɨ, “Judayɨ́yá mɨxɨ́ ináyoxɨnɨ, yayɨ́ osianeyɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","reaŋwɨ́ nɨwúrayiro xoyɨ́wáyi nurápɨro mɨŋɨ́yo neaayiro ");
INSERT INTO aak_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","rɨxa rɨperɨrɨ́ numearɨ́asáná rapɨrapɨ́ ayɨ́á rɨŋú nɨwirɨro ámɨ xegú nuyírɨmáná íkɨ́áyo seáyɨmɨ yekwɨroáranɨro nánɨ nɨméra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yekwɨroáranɨro nánɨ aŋɨ́ apimɨ dánɨ nɨméra nuróná Jisaso rɨxa eŋɨ́ meánɨ́ yarɨŋagɨ nɨwɨnɨro ámá wo, Sairini dáŋɨ́ Saimonomɨ sekaxɨ́ re urɨgɨ́awixɨnɨ, “Yoxáɨ́ rɨpá nɨmeámɨ wuiɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","rɨxa dɨ́wɨ́ mɨ́eyoaŋɨ́ apɨkwɨ xegɨ́ yoɨ́ Gorɨgotaɨ rɨnɨŋɨ́pimɨ —Dɨ́wɨ́ apɨ yoɨ́ mɨ́kɨ́ ámá mɨŋɨ́ gɨxweá nánɨrɨnɨ. Dɨ́wɨ́ apɨkwɨnimɨ nɨrémoro ");
INSERT INTO aak_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wa Jisaso rɨ́nɨŋɨ́ mɨwinɨpa oenɨrɨ marɨsɨnɨ́á yíkɨ́ yarɨŋɨ́ bɨ iniɨgɨ́ wainɨ́yo niwayɨmómáná nawínɨ oimónɨrɨ kɨrɨ́kɨrɨ́ nimearɨ e nero mɨnɨ wíáná iwamɨ́ó gɨ́gɨ́ éáná mɨnɨpaxɨ́ wimónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Porisowa omɨ rɨxa yoxáɨ́yo seáyɨ e nɨyekwɨroárɨmáná “Oyá rapɨrapɨ́ none go go meanɨrɨ́enɨŋoɨ?” nɨrɨnɨro áwɨnɨ e nɨtɨmáná sárú nemáná ");
INSERT INTO aak_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","éɨ́ nɨŋwearo Jisasomɨ awí nɨmeŋwearo ");
INSERT INTO aak_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ámá nɨ́nɨ “O ɨ́wɨ́ apɨ éɨ́ nánɨ rɨpɨkiarɨŋoɨ?” oyaiwípoyɨnɨrɨ íkɨ́á wárá nɨmearo “Ámá ro Jisaso Judayɨ́yá mɨxɨ́ ináyorɨnɨ.” nɨrɨro rɨ́wamɨŋɨ́ nearo mɨŋɨ́ tɨ́ŋɨ́ e seáyɨ e pɨ́raugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasomɨ nɨyekwɨroárɨrɨ́ná ámá ɨ́wɨ́ mearɨgɨ́íwaúmɨ enɨ mɨdɨmɨdánɨ yekwɨroárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ámá óɨ́yimɨ bɨrɨ urɨ nɨyayirɨ́ná peayɨ́ sɨŋwɨ́ nɨwɨnɨro mɨŋɨ́ kɨrɨ́kɨrɨ́ nimearo ikayɨ́wɨ́ numearɨróná ");
INSERT INTO aak_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","re urayigɨ́awixɨnɨ, “Re rɨŋoxɨranɨ? ‘Niɨwanɨŋonɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwá nɨpɨnearɨ gɨ́ niɨwɨnɨ sɨ́á wɨyaú wɨyimɨ ámɨ mɨrɨmɨ́árɨnɨ.’ rɨŋoxɨranɨ? Joxɨ nepa niaíwɨ́ Gorɨxoyáoxɨ eŋánáyɨ́, jɨwanɨŋoxɨ eŋɨ́ nɨyoaárɨnɨmɨ wepɨ́neɨ.” rayigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Judayɨ́yá mebáowa tɨ́nɨ ámá bɨrɨ uro yayarɨgɨ́áyɨ́ rɨperɨrɨ́ umeararɨgɨ́ápa awa enɨ rɨperɨrɨ́ numero re rɨgɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“O ámáyo ‘Nionɨ tɨ́ámɨnɨ báná yeáyɨ́ seayimɨxemeámɨ́árɨnɨ.’ uragɨ́ aí xewanɨŋo arɨrá minɨpaxɨ́rɨnɨ. Íkɨ́áyo dánɨ eŋɨ́ nɨyoaárɨmɨ wepɨ́nánáyɨ́, ananɨ dɨŋɨ́ wɨkwɨ́roanɨ́wɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O Gorɨxomɨ dɨŋɨ́ nɨŋwɨrárɨrɨ re rɨnarɨŋorɨnɨ, ‘Nionɨ niaíwɨ́ Gorɨxoyáonɨrɨnɨ.’ rɨnarɨŋorɨnɨ. Gorɨxo xewaxɨ́ ro nánɨ yayɨ́ nɨwinɨrɨ́náyɨ́, rɨxa éɨ́ oumínɨnɨ. Arɨrá winɨrɨ́enɨŋoɨnɨrɨ sɨŋwɨ́ wɨnanɨ́wɨnɨ.” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɨ́wɨ́ mearɨgɨ́íwaú mɨdɨmɨdánɨ yekwɨroárɨnɨgɨ́íwaú enɨ Jisasomɨ ikayɨ́wɨ́ numearɨrɨ́ná axɨ́pɨnɨ rɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E néra núɨ́asáná eŋáná rɨxa sogwɨ́ áwɨnɨ e 12:00 imónáná re eŋɨnigɨnɨ. Aŋɨ́ nɨmɨnɨ sɨ́á yinárɨŋɨnigɨnɨ. Sɨ́á nɨyinárɨŋɨsáná rɨxa 3:00 p.m. imónáná ámɨ wɨ́á ónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ámɨ wɨ́á ónáná Jisaso xegɨ́ Xibɨruyɨ́ pɨ́né tɨ́nɨ rɨ́aiwá re rɨŋɨnigɨnɨ, “Eri, Eri, ramɨ sabakɨtani?” urɨŋɨ́pɨyɨ́ re nɨrɨrɨ́ná urɨŋɨnigɨnɨ, “Gɨ́ Gorɨxoxɨnɨ, gɨ́ Gorɨxoxɨnɨ, joxɨ pí nánɨ niepɨsamoarɨŋɨnɨ?” rɨ́aiwá e ráná ");
INSERT INTO aak_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ámá e rówapɨgɨ́áyɨ́ wí Jisaso e rɨ́agɨ arɨ́á nɨwiro re rɨnɨgɨ́awixɨnɨ, “Wɨ́á rókiamoagɨ́ Iraijao nánɨ rɨ́aiwá rɨ́a rarɨnɨ?” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ayɨ́ wigɨ́ wo aŋɨ́nɨ nurɨ írɨkwɨ́ bɨ nɨmearɨ wegwɨ́á wá tɨ́nɨ ayɨŋwɨ́ nikɨroárɨmáná iniɨgɨ́ wainɨ́ niáɨ́ eŋɨ́ bɨ írɨkwɨ́pimɨ niwayɨmómáná Jisaso onɨnɨrɨ wimɨxánɨmɨnɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","xegɨ́ wínɨyɨ́ re urɨgɨ́awixɨnɨ, “E mepanɨ. Iraijao nɨwepɨ́nɨrɨ arɨrá winɨrɨ́enɨŋoɨ? Arɨrá mɨwipa enɨrɨ́enɨŋoɨ? Sɨŋwɨ́ owɨnaneyɨ.” rarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisaso ámɨ eŋɨ́ tɨ́nɨ rɨ́aiwá bɨ nɨrɨrɨ́ná xegɨ́ dɨŋɨ́ nɨyámɨga uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Xegɨ́ dɨŋɨ́ nɨyámɨga úáná re eŋɨnigɨnɨ. Rapɨrapɨ́ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awawá ŋwɨ́á Gorɨxoyá nánɨ nɨyimárónɨrɨ epaŋioárɨnɨŋú yoparɨ́ éde dánɨ xegɨ́pɨ naxega nɨwepɨ́nɨrɨ wúkaú imónɨrɨ xwɨ́á pobonɨ́ éáná sɨ́ŋá xwé áwɨnɨmɨ nɨjiga urɨ ");
INSERT INTO aak_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ámá xwárɨpá noxoága úáná ámá Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roagɨ́á pɨyɨ́yɨ́ wegɨ́e dánɨ sɨŋɨ́ ero egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pɨyɨ́ ayɨ́ Jisaso rɨxa nɨwiápɨ́nɨmeámáná eŋáná nuro Jerusaremɨ rémóáná ámá obaxɨ́ ayo sɨŋwɨ́ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Porisowamɨ seáyɨ e imónɨŋo tɨ́nɨ porisɨ́ xɨ́o tɨ́nɨ Jisasomɨ awí mearogɨ́áwa tɨ́nɨ xwɨ́á pobonɨ́ erɨ amɨpí e imónɨrɨ éagɨ nɨwɨnɨro óɨ́ nikárɨnɨro re rɨnɨgɨ́awixɨnɨ, “Ámá royɨ́ neparɨnɨ. Gorɨxomɨ xewaxorɨnɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Apɨxɨ́ obaxɨ́ “Jisasomɨ saŋɨ́ nurápa númɨ ouxɨ́daneyɨ.” nɨrɨro Gariri pɨropenɨsɨ́yo dánɨ bɨ́íwa ná jɨ́amɨ nɨrómáná sɨŋwɨ́ wɨnɨgɨ́íwa ríwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Íwa wí Magɨdara dáŋɨ́ Mariaírɨnɨ. Ámɨ wí Jemisomɨ tɨ́nɨ Josepomɨ tɨ́nɨ xɨnáí Mariaíyɨ rɨnɨŋírɨnɨ. Ámɨ wí Sebediomɨ xewaxowaúmɨ xɨnáírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rɨxa sogwɨ́ nokepá tɨ́nɨ ámá amɨpí mɨmúrónɨŋɨ́ wo —O Arimatia dáŋɨ́ Josepoyɨ rɨnɨŋorɨnɨ. O enɨ Jisaso wiepɨsiŋɨ́yɨ́ worɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O émáyɨ́ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e nánɨ nurɨ Jisaso pɨyomɨ xwɨ́á weyárɨmɨnɨrɨ nánɨ yarɨŋɨ́ wíáná Pairato porisowamɨ “Xe omeanɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josepo nurɨ pɨyomɨ nɨmearɨ rapɨrapɨ́ apɨ́á xaíwɨ́ weŋɨ́pɨ tɨ́nɨ xopɨxopɨ́ nɨrómáná ");
INSERT INTO aak_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sɨ́ŋá óɨ́ xewanɨŋo nánɨ rɨxɨŋɨ́yimɨ —Ayi ámá sɨnɨ mɨweŋɨ́yirɨnɨ. Ayimɨ nɨmeámɨ nɨpáwirɨ nɨtɨmáná sɨ́ŋá piárá xwé wo mɨmegwɨnárɨ́ nɨméra nuro sɨ́ŋá óɨ́yimɨ nɨpɨ́roárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magɨdara dáŋɨ́ Mariaí tɨ́nɨ Mariaí wɨ́í tɨ́nɨ ípaú sɨ́ŋá óɨ́yi mɨdánɨŋe nɨŋweámáná Jisaso pɨyomɨ e tarɨŋagɨ wɨnɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sɨ́á Sabarɨ́áyo nánɨ Judayɨ́ amɨpí píránɨŋɨ́ imɨxárarɨgɨ́áyi óráná wɨ́ápɨ tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Parisiowa tɨ́nɨ awa gapɨmanɨ́ Pairato tɨ́ŋɨ́ e awí neánɨro ");
INSERT INTO aak_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jisaso pɨyo nánɨ re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, yapɨ́ neaíwapɨyiŋo sɨnɨ mɨpé nɨŋwearɨ́ná re rɨŋɨ́pɨ, ‘Sɨ́á wɨyaú wɨyi óráná ámɨ wiápɨ́nɨmeámɨ́árɨnɨ.’ rɨŋɨ́pɨ nánɨ dɨŋɨ́ neainarɨŋagɨ nánɨ barɨŋwɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oyá wiepɨsarɨŋowa nɨbɨro pɨyomɨ ɨ́wɨ́ nɨmearo pɨ́nɨ́ nɨtɨmáná ámáyo re urɨpɨ́rɨxɨnɨrɨ, ‘O rɨxa wiápɨ́nɨmeáɨnigɨnɨ.’ urɨpɨ́rɨxɨnɨrɨ joxɨ porisɨ́ wamɨ sekaxɨ́ re urowáreɨ, ‘Omɨ xwɨ́á weyárɨgɨ́e nánɨ nuro awí sɨ́á wɨyaú wɨyimɨ mearópoyɨ.’ urowáreɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pairato re urɨŋɨnigɨnɨ, “Sewanɨŋoyɨ́né porisɨ́ wa awí mearopɨ́rɨ nánɨ nɨmeámɨ nuro soyɨ́né ɨ́wɨ́ mɨmeapa oépoyɨnɨrɨ yarɨgɨ́ápa wiepɨsarɨŋowa pɨyomɨ ɨ́wɨ́ meapɨ́rɨxɨnɨrɨ e e nurára úpoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","awa nuro Jisaso xwɨ́á weyárɨnɨŋe porisowamɨ e e nurára numáná sikɨ́ bɨ nɨmearo sɨ́mɨmajɨ́ó nánɨ sɨ́ŋá pɨ́rónɨŋomɨ seáyɨ e ikwiárárɨgɨ́awixɨnɨ. Apɨ mɨweŋáná “Ámá nɨpáwiro pɨyomɨ meáɨ́árɨ́anɨ?” yaiwianɨ́wánɨro nánɨ e egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Magɨdara dáŋɨ́ Mariaí tɨ́nɨ Mariaí wɨ́í tɨ́nɨ Sabarɨ́á rɨxa wéáná Sadéyo isɨ́áyo ípaú Jisasoyá xwárɨpáyo sɨŋwɨ́ wɨnanɨri nánɨ nuri ");
INSERT INTO aak_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","sɨnɨ mɨrémopa yarɨ́ná re eŋɨnigɨnɨ. Pobonɨ́ xwé wí éáná aŋɨ́najɨ́ Gorɨxoyá wo aŋɨ́namɨ dánɨ nɨweapɨrɨ sɨ́ŋá xwárɨpáyo óɨ́yimɨ pɨ́roárɨgɨ́o mɨmegwɨnárɨ́ néra nurɨ óɨ́yimɨ nɨwiemoárɨmáná sɨ́ŋáomɨ seáyɨ e éɨ́ ŋweáagɨ ");
INSERT INTO aak_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","4","porisɨ́ awí mearoarɨgɨ́áwa aŋɨ́najo ápiaŋwɨ́ yarɨŋɨ́pa wɨ́á énɨŋɨ́ nókirɨ ŋweaŋagɨ nɨwɨnɨro xegɨ́ rapɨrapɨ́ enɨ sɨŋwɨ́ mɨmɨŋɨ́ inɨ́ɨ́ yínɨŋagɨ nɨwɨnɨro óɨ́ nikárɨnɨro pɨyɨ́nɨŋɨ́ nimónɨro xwɨ́ámɨ piérɨnowigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aŋɨ́najo sɨnɨ xwárɨpá tɨ́ŋɨ́ e ŋweaŋáná ípaú rémónapɨ́agɨ́i re urɨŋɨnigɨnɨ, “Aípagwí wáyɨ́ mepanɨ. Nionɨ nɨjɨ́árɨnɨ. Aípagwí Jisaso, pɨyomɨ íkɨ́áyo yekwɨroárɨgɨ́omɨ sɨŋwɨ́ wɨnanɨri barɨŋiɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O re mɨwenɨnɨ. Xɨ́o searɨŋɨ́pa rɨxa nɨwiápɨ́nɨmeámɨ úɨnigɨnɨ. Aípagwí xɨ́omɨ tɨgɨ́e nɨbɨri sɨŋwɨ́ wɨnɨ́piyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ámɨ re urɨŋɨnigɨnɨ “Rɨxa nuri xegɨ́ wiepɨsarɨŋowamɨ re urémeápiyɨ, ‘ “O xwárɨpáyo dánɨ rɨxa nɨwiápɨ́nɨmeámɨ úɨnigɨnɨ. Arɨ́á épiyɨ. O Gariri pɨropenɨsɨ́yo nánɨ xámɨ yíɨ́mɨ soyɨ́né e nɨyoaro sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” urémeápiyɨ.’ eararɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ípaú aŋɨ́nɨ xwárɨpáyo pɨ́nɨ nɨwiárɨmɨ nurɨ́ná wáyɨ́ ikárɨnɨri yayɨ́ ikárɨnɨri néra nuri wiepɨsarɨŋowamɨ áwaŋɨ́ urémeanɨri aŋɨ́nɨ warɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jisaso ípaúmɨ nɨwímearɨ “Gɨ́ ámá aípagwí!” nurɨrɨ yayɨ́ e wíáná ípaú aŋwɨ e nuri mɨŋɨ́ xwɨ́áyo nɨkwɨ́rori xegɨ́ sɨkwɨ́ ɨ́á nɨxɨrɨríná omɨ seáyɨ e umegɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Seáyɨ e uméáná o re urɨŋɨnigɨnɨ, “Aípagwí wáyɨ́ mikárɨnɨpanɨ. Sa nuri gɨ́ ámá imónɨgɨ́áwamɨ áwaŋɨ́ re urɨ́piyɨ, ‘“Soyɨ́né Gariri pɨropenɨsɨ́yo nánɨ yíɨ́rɨxɨnɨ.” rɨŋoɨ.’ nurɨri re urɨ́piyɨ, ‘ “Nionɨ e sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” rɨŋoɨ.’ urɨ́piyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ípaú sɨnɨ wiepɨsarɨŋowa tɨ́ŋɨ́ e nánɨ warɨ́ná re eŋɨnigɨnɨ. Porisɨ́ awí mearóɨ́áwa Jerusaremɨyo nɨrémoro apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ wa wɨnɨ́ápɨ nɨpɨnɨ nánɨ repɨyɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","awa Judayɨ́yá mebáowamɨ awí neaárɨro xwɨyɨ́á nimɨxɨmáná porisowa áwaŋɨ́ murɨpa éɨ́rɨxɨnɨrɨ nɨgwɨ́ xwé obaxɨ́ mɨnɨ nɨwiro ");
INSERT INTO aak_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","re urɨgɨ́awixɨnɨ, “Ámá wí yarɨŋɨ́ seaíáná re urɨ́ɨ́rɨxɨnɨ, ‘Árɨ́wɨyimɨ none sá weŋáná xegɨ́ wiepɨsiŋowa nɨbɨro pɨyomɨ ɨ́wɨ́ nɨmeámɨ ugɨ́awixɨnɨ.’ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gapɨmanɨ́ Pairato xwɨyɨ́á apɨ rɨnarɨŋagɨ arɨ́á nɨwirɨ́náyɨ́, o iwaŋɨ́ seaeanɨgɨnɨrɨ samɨŋɨ́ imɨxanɨ́wá eŋagɨ nánɨ ayá sɨ́wɨ́ nɨsearorɨ dɨŋɨ́ obɨbaxɨ́ mɨmopanɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","porisowa nɨgwɨ́ apɨ nurápɨro apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa urɨ́ápa axɨ́pɨ e yarɨ́ná pɨ́né apɨ Judayɨ́ aŋɨ́yo rɨnɨmeŋɨ́pɨ agwɨ sɨnɨ rɨnɨmearɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wiepɨsiŋɨ́ wé wúkaú sɨkwɨ́ wo awa Gariri pɨropenɨsɨ́yo dɨ́wɨ́ Jisaso urárɨŋɨ́pimɨ nánɨ nɨyoaro ");
INSERT INTO aak_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","omɨ nɨwɨnɨróná seáyɨ e numero aiwɨ wa “Jisasorɨnɨ.” yaiwiro wa “Ámá ro nepa Jisasorɨ́anɨ?” yaiwiro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","o aŋwɨ e nɨbɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo ‘Amɨpí aŋɨ́namɨ imónɨrɨ xwɨ́árímɨ imónɨrɨ eŋɨ́pɨ nánɨ joxɨ apɨ nɨpɨnɨ nánɨ nénɨ́ tɨ́ŋoxɨ imónɨrɨ́ɨnɨ.’ nɨrɨ́ɨ́ eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","re seararɨŋɨnɨ, ‘Soyɨ́né nuro ámá gwɨ́ rɨxɨ́ wɨrɨ́ wɨrímɨ gɨ́ wiepɨsarɨŋáyɨ́nɨŋɨ́ nɨwimɨxa nuróná re erɨ́ɨnɨ. Yoɨ́ ápo Gorɨxoyápimɨ dánɨ tɨ́nɨ xewaxonɨyápimɨ dánɨ tɨ́nɨ kwíyɨ́pimɨ dánɨ tɨ́nɨ wayɨ́ umeairo ");
INSERT INTO aak_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","sekaxɨ́ nionɨ searɨŋá nɨpɨnɨ xɨ́dɨpɨ́rɨ́a nánɨ uréwapɨyiro erɨ́ɨnɨ. Rɨpɨ enɨ arɨ́á époyɨ. Nionɨ anɨŋɨ́ dɨŋɨ́ seakɨkayómɨ́árɨnɨ. Sɨ́á yoparɨ́yimɨ e nánɨ aí nɨseakɨkayóa umɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Xwɨyɨ́á iwamɨ́ó Gorɨxomɨ xewaxo Jisasɨ Kiraiso —O nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ Gorɨxo rɨ́peaŋorɨnɨ. O nánɨ xwɨyɨ́á yayɨ́ seainɨpaxɨ́pɨ rɨpɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Eŋíná Jono wayɨ́ nɨneameaia wago sɨnɨ meŋáná xwɨyɨ́á Gorɨxoyá wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo Jono ná rɨ́wɨ́yo bɨnɨ́o nánɨ Gorɨxo xegɨ́ xewaxomɨ urɨŋɨ́ rɨpɨ rɨ́wamɨŋɨ́ eaŋɨnigɨnɨ, “Arɨ́á eɨ. Gorɨxonɨ gɨ́ xwɨyɨ́á yaŋɨ́ wiowárɨmɨ́áo joxɨ gɨ́ íwoxɨ xámɨ rɨmeanɨ nánɨ urowárɨmɨ́árɨnɨ. O joxɨ nánɨ óɨ́ simoinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","O nurɨ ámá nánɨ dɨŋɨ́ meaŋe nɨŋwearɨ́ná joxɨ nánɨ rɨ́aiwá re rɨnɨ́árɨnɨ, ‘Ámɨná rɨ́wɨ́yo bɨnɨ́o nánɨ segɨ́ dɨŋɨ́ óɨ́ naŋɨ́nɨŋɨ́ nɨwimoiro ŋweáɨ́rɨxɨnɨ. Óɨ́ píránɨŋɨ́ imoarɨgɨ́ápánɨŋɨ́ segɨ́ dɨŋɨ́ píránɨŋɨ́ nimónɨro ŋweáɨ́rɨxɨnɨ.’ Gɨ́ xwɨyɨ́á yaŋɨ́ wiowárɨmɨ́áo rɨ́aiwá e rɨnɨ́árɨnɨ.” Gorɨxo e rɨŋɨ́pa ");
INSERT INTO aak_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jono wayɨ́ nɨneameaia wago ámá nánɨ dɨŋɨ́ meaŋe nɨrémorɨ wáɨ́ nurɨmerɨ re uragɨ́rɨnɨ, “Gorɨxo seyɨ́né ɨ́wɨ́ niga warɨgɨ́ápɨ yokwarɨmɨ́ seaiinɨ nánɨ segɨ́ uyɨ́niɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweápoyɨ. E nerɨ́náyɨ́, wayɨ́ seameaimɨ́ɨnɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ámá obaxɨ́ Judayɨ́yá aŋɨ́yo dáŋɨ́yɨ́ tɨ́nɨ áwɨnɨ e wigɨ́ aŋɨ́ xwé bɨ xegɨ́ yoɨ́ Jerusaremɨ dáŋɨ́yɨ́ tɨ́nɨ Jono tɨ́ŋɨ́ e nánɨ nuro wigɨ́ ɨ́wɨ́ niga warɨgɨ́ápɨ nánɨ waropárɨ́ wíáná iniɨgɨ́ Jodanɨ rapáyo wayɨ́ umeaiagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","O Gorɨxoyá xwɨyɨ́á yaŋɨ́ wiowárɨŋo aiwɨ seáyɨ e nerɨ weyɨ́ menagomanɨ. Rapɨrapɨ́ awiaxɨ́ yínagomanɨ. Kamerɨ́ —Ayɨ́ osɨ́nɨŋɨ́ imónɨŋɨ́rɨnɨ. Kamerɨ́ ɨ́á aga iyɨ́ánɨŋɨ́ imónɨŋɨ́ nɨyínɨmáná arerɨxɨ́ agwoŋɨ́nɨŋɨ́ írɨŋɨ́yo nɨyínɨrɨ emeagorɨnɨ. Aiwá enɨ awiaxɨ́ nagomanɨ. Xópé tɨ́nɨ pɨ́kɨ́ iniɨgɨ́ tɨ́nɨ nagorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O Jisaso, rɨ́wɨ́yo bɨnɨ́o nánɨ wáɨ́ nemerɨ́ná waunɨ́ xwɨyɨ́á re ragɨ́rɨnɨ, “Nionɨ eŋɨ́ eánɨŋáonɨ aiwɨ eŋɨ́ eánɨŋɨ́ nionɨyá tɨ́nɨ rɨ́wɨ́yo bɨnɨ́oyá tɨ́nɨ xɨxenɨmanɨ. Oyá nɨmúronɨ. Omɨŋɨ́ wiiarɨgɨ́áyɨ́ ananɨ wigɨ́ bosoyá sɨkwɨ́ sú gwɨ́ wíkweaiarɨgɨ́árɨnɨ. E nerɨ aiwɨ nionɨ sɨmaŋwɨ́yónɨŋɨ́ yeáyɨ́ nurɨ́nɨrɨ o aga seáyɨ émɨ nɨmúrónɨŋagɨ nánɨ oyá sɨkwɨ́ sú gwɨ́ wíkweaipaxɨ́ menɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","re uragɨ́rɨnɨ, “Nionɨ wayɨ́ nɨseameairɨ́ná sa iniɨgɨ́ tɨ́nɨnɨ igɨ́á seaeaarɨŋárɨnɨ. Rɨ́wɨ́yo bɨnɨ́o wayɨ́ nɨseameairɨ́ná kwíyɨ́ Gorɨxoyápɨ tɨ́nɨ seainɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jono wáɨ́ urarɨ́ná Jisaso Gariri pɨropenɨsɨ́yo xegɨ́ aŋɨ́ Nasaretɨ ŋweaŋe pɨ́nɨ nɨwiárɨmɨ nurɨ Jonomɨ wímeááná iniɨgɨ́ Jodanɨ rapáyo wayɨ́ numeairɨ ");
INSERT INTO aak_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Jisaso iniɨgɨ́yo dánɨ nímɨnɨmeámɨ yarɨ́ná aŋɨ́namɨ dánɨ óɨ́ inɨ́agɨ kwíyɨ́ Gorɨxoyá xawiówɨ́nɨŋɨ́ xɨ́o nánɨ weaparɨŋagɨ wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sɨnɨ e wɨnarɨ́ná Gorɨxo aŋɨ́namɨ dánɨ Jisasomɨ re urarɨŋagɨ arɨ́á wiŋɨnigɨnɨ, “Gɨ́ íwɨ́ dɨŋɨ́ sɨxɨ́ rɨyiŋáoxɨ nánɨ aga yayɨ́ seáyɨ e ninarɨnɨ.” urarɨŋagɨ arɨ́á nɨwimáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gorɨxoyá kwíyɨ́ Jisasomɨ rɨxa ámá nánɨ dɨŋɨ́ meaŋe nánɨ nɨméra nurɨ ");
INSERT INTO aak_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","o e ŋweaŋáná sɨ́á 40 nóra warɨ́ná Seteno —O imɨ́óyo xɨráónɨŋɨ́ imónɨŋagɨ nánɨ nɨ́nɨ sɨmaŋwɨ́yónɨŋɨ́ wurɨ́nɨgɨ́orɨnɨ. O nɨbɨrɨ Jisaso xanoyá maŋɨ́ pɨ́rɨ́ owiaíkinɨrɨ iwamɨ́ó wíwapɨyarɨŋagɨ aí o ɨ́wɨ́ wí mé sɨ́nɨ tɨ́ŋɨ́ e nɨŋwearɨ́ná aŋɨ́najɨ́ nɨwímearo sɨmɨŋɨ́ wínagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Rɨ́wéná Jisaso, Jono rɨxa gwɨ́ ŋweaŋáná, o Gariri pɨropenɨsɨ́yómɨnɨ nurɨ xwɨyɨ́á yayɨ́ winɨpaxɨ́ Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́ápɨ nánɨ wáɨ́ nurɨmerɨ ");
INSERT INTO aak_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","repɨyɨ́ re wiemeŋɨnigɨnɨ, “Rɨxarɨnɨ. Gorɨxo seyɨ́né xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́ápɨ sɨŋánɨ imónɨnɨ aŋwɨ ayo eŋagɨ nánɨ segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro xwɨyɨ́á yayɨ́ seainɨpaxɨ́ nionɨ seararɨŋá rɨpɨ dɨŋɨ́ nɨkwɨ́roro ŋweáɨ́rɨxɨnɨ.” nurɨmerɨ ");
INSERT INTO aak_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ipí xegɨ́ yoɨ́ Gariri rɨwoŋɨ́pámɨ nɨpurɨ́ná ámá peyɨ́ nánɨ yarɨgɨ́á waú Saimono tɨ́nɨ xogwáo Adɨruo tɨ́nɨ peyɨ́ nánɨ ubenɨ́ ipíyo mamówárarɨŋagɨ́i nɨwɨnɨrɨ nɨwímearɨ ");
INSERT INTO aak_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","re urɨŋɨnigɨnɨ, “Agwiagwí omɨŋɨ́ peyɨ́ nánɨ yarɨgɨ́í rɨpɨ pɨ́nɨ nɨwiárɨmɨ nɨxɨ́dɨ́piyɨ. Omɨŋɨ́ xegɨ́ bɨ peyɨ́ meaayarɨgɨ́ípa ámá enɨ axɨ́pɨ e meapɨsi oeaíwapɨyimɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","agwiaú re egɨ́isixɨnɨ. Rɨxa peyɨ́ nánɨ yarɨgɨ́ípɨ pɨ́nɨ nɨwiárɨmɨ númɨ ugɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Númɨ warɨ́ná Jisaso sɨnɨ ná jɨ́e onɨmiápɨ nurɨ́ná ámɨ ámá waú, Sebediomɨ xewaxowaú Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ ewéyo nɨŋweámáná egɨ́ ubenɨ́ peyɨ́ nánɨ yarɨgɨ́íú arɨ́kínɨŋagɨ yadɨrɨpɨ́narɨŋagɨ́i nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","rɨxa “Agwiagwí enɨ nɨxɨ́dɨ́piyɨ.” uráná agwiaú xano tɨ́nɨ o xegɨ́ ámá nɨgwɨ́ omɨŋɨ́ wiiarɨgɨ́á tɨ́nɨ sɨnɨ ewéyo ŋweaŋáná pɨ́nɨ nɨwiárɨmɨ omɨ númɨ ugɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisaso wirɨmeáróɨ́wa tɨ́nɨ nurɨ aŋɨ́ yoɨ́ Kapaneamɨyo nɨrémoro rɨxa Sabarɨ́á —Sɨ́á ayi Judayɨ́ omɨŋɨ́ wí mé kikiɨ́á nero xwɨyɨ́á Gorɨxoyá arɨ́á wianɨro nánɨ awí eánarɨgɨ́áyirɨnɨ. Sɨ́á ayi imónáná rotú aŋɨ́yo nɨpáwiro o ámáyo uréwapɨyarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ayɨ́ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa uréwapɨyarɨgɨ́ápa muréwapɨyí aga Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ xiáwónɨŋɨ́ rarɨŋagɨ nɨwɨnɨro o uréwapɨyarɨŋɨ́pɨ nánɨ mɨŋɨ́ sɨ́ŋá nɨweánɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","íná ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́ wo rotú aŋɨ́yo ínɨmɨ dánɨ makɨrɨ́wɨ́ nɨmorɨ ");
INSERT INTO aak_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","xwamiánɨ́ re urɨŋɨnigɨnɨ, “Nasaretɨ dáŋɨ́ Jisasoxɨ imɨ́one pí neaimɨnɨrɨ barɨŋɨnɨ? ‘Xwɨrɨ́á neaikɨxémɨnɨrɨ rɨ́a barɨŋɨnɨ?’ nimónarɨnɨ. Nionɨ nɨjɨ́árɨnɨ. Joxɨ Gorɨxo xewaxoxɨ xɨ́o rɨrɨ́peaŋoxɨrɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisaso mɨxɨ́ numáɨnɨrɨ re urɨŋɨnigɨnɨ, “Pɨ́nɨ wiáreɨ! Dɨŋɨ́ xɨxéroarɨŋɨ́pɨxɨnɨ nɨwáramómɨ uɨ!” uráná ");
INSERT INTO aak_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","imɨ́o ámáomɨ meaŋɨ́ neaárɨrɨ o sinapɨxwɨ́nɨ́ nerɨ weŋáná imɨ́o nurɨ́ná makɨrɨ́wɨ́ nɨmómɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Makɨrɨ́wɨ́ nɨmómɨ úagɨ ámá nɨ́nɨ sɨŋwɨ́ e nɨwɨnɨro mɨŋɨ́ sɨ́ŋá nɨweánɨro xwɨyɨ́á nɨrɨga nuro re rɨnɨgɨ́awixɨnɨ, “Xwɨyɨ́á apimɨ xiáwónɨŋɨ́ nearéwapɨyarɨŋɨ́pɨ xegɨ́ bɨrɨnɨ. Eŋíná arɨ́á wiagwámanɨ. Aga sɨnɨ sɨŋɨ́ aí arɨ́á wiarɨŋwɨnɨ. Imɨ́ó aí sekaxɨ́ uráná arɨ́á wiarɨŋoɨ.” rɨnɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","xwɨyɨ́á Jisaso éɨ́pɨ nánɨ Gariri pɨropenɨsɨ́yo rɨxa yanɨ́ amɨ amɨ niwéa uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisaso rotú aŋɨ́yo pɨ́nɨ nɨwiárɨmɨ nɨpeyearɨ nurɨ aŋɨ́ Saimonoyá tɨ́nɨ Adɨruoyá tɨ́nɨ xɨráxogwáowaúyá aŋɨ́yo nɨpáwiro Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ enɨ nawínɨ páwíáná ");
INSERT INTO aak_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonomɨ xɨneagwí wará rɨ́á pɨrɨ́ wiarɨŋagɨ nánɨ sá weŋagɨ Jisasomɨ rɨxa áwaŋɨ́ urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","o í weŋe nánɨ nurɨ wéyo ɨ́á meááná sɨmɨxɨ́ rɨxa pɨ́nɨ wiárɨ́agɨ í nɨwiápɨ́nɨmearɨ rɨxa aiwá rɨ́á nɨyearɨ tɨnɨŋɨ́pɨ nɨmearɨ mɨnɨ nɨwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rɨxa sɨ́á sisisaŋɨ́ imónarɨ́ná sogwɨ́ rɨxa wéɨ́mɨ eŋáná ámá aŋɨ́ apimɨ dáŋɨ́ sɨmɨxɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yɨ́ tɨ́nɨ nɨmeámɨ Jisaso tɨ́ŋɨ́ e nánɨ nɨbɨro ");
INSERT INTO aak_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","rɨxa oxɨ́ apɨxɨ́ niaíwɨ́ aŋɨ́ apimɨ dáŋɨ́yɨ́ aŋɨ́ Jisaso ŋweaŋiwámɨ ɨ́wí e awí eaárɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","o ámá pí pí sɨmɨxɨ́ yarɨgɨ́áyo naŋɨ́ imɨxowárɨrɨ ámá imɨ́ó sayá nɨmerɨ xɨxéroarɨŋɨ́yo enɨ imɨ́ó mɨxɨ́ umáɨnowárɨrɨ nerɨ́ná imɨ́ó o Gorɨxo xewaxo eŋagɨ nɨjɨ́á imónɨŋagɨ́a nánɨ mɨxɨ́ numáɨnowárɨrɨ́ná xwɨyɨ́á wí orɨ́poyɨnɨrɨ sɨŋwɨ́ mɨwɨnɨpa eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","O wɨ́á mónɨŋɨ́mɨ sɨnɨ sɨ́á xaíwɨ́ yinɨŋáná nɨwiápɨ́nɨmearɨ nɨpeyeámáná ámá mɨŋweagɨ́e nánɨ nurɨ e Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimono tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨgɨ́áwa tɨ́nɨ Jisaso sɨnɨ aŋɨ́yo mɨŋweaŋagɨ nɨwɨnɨro o nánɨ pɨ́á néra nuro ");
INSERT INTO aak_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","nɨwímearɨ́ná re urɨgɨ́awixɨnɨ, “Oxɨ́ apɨxɨ́ niaíwɨ́ nɨ́nɨ joxɨ nánɨ pɨ́á yanɨro yarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","o re urɨŋɨnigɨnɨ, “E nerɨ aiwɨ aŋɨ́ wíyo nionɨ xwɨyɨ́á ‘Gorɨxo píránɨŋɨ́ seameŋweanɨ sɨŋánɨ imónɨnɨ aŋwɨ ayorɨnɨ.’ rarɨŋápɨ wáɨ́ ourɨmemɨ nánɨ owaneyɨ. Xwɨyɨ́á apɨ aŋɨ́ amɨ amɨ áwaŋɨ́ urɨmɨnɨrɨ bɨŋárɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gariri pɨropenɨsɨ́yo amɨ amɨ nemerɨ́ná wigɨ́ rotú aŋɨ́ iwiwámɨ nɨpáwiemerɨ wáɨ́ urɨrɨ ámá imɨ́ó sayá nɨmerɨ xɨxéroarɨŋɨ́ tɨ́ŋɨ́yo mɨxɨ́ umáɨnowárɨrɨ nerɨ e emeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ámá peyɨyɨ́ —Sɨmɨxɨ́ apɨ ámá sɨŋwɨ́ nɨwɨnɨrɨ́ná neaxɨ́meanɨgɨnɨrɨ éɨ́ yarɨgɨ́ápɨrɨnɨ. Sɨmɨxɨ́ ayɨ́ tɨ́ŋɨ́ wo, Jisaso emearɨ́ná, omɨ nɨwímearɨ sɨ́mɨmaŋɨ́mɨnɨ xómɨŋɨ́ nɨyɨkwirɨ waunɨ́ rɨxɨŋɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ nɨsimónɨrɨ́náyɨ́, ananɨ píránɨŋɨ́ nimɨxɨpaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","o wá nɨwianɨrɨ wé ɨ́eapá nɨwirɨ omɨ seáyɨ e nɨwikwiárɨrɨ re urɨŋɨnigɨnɨ, “‘Nionɨ joxɨ naŋɨ́ oimónɨnɨ.’ nimónarɨnɨ. Rɨxa naŋɨ́ imóneɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Peyɨyɨ́ rɨxa axíná yɨ́moŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Rɨxa apaxɨ́ mé yɨ́móagɨ Jisaso apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa tɨ́ŋɨ́ e nánɨ nurowárɨrɨ́ná arɨ́á jɨyikɨ́ norɨ ");
INSERT INTO aak_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","re urɨŋɨnigɨnɨ, “Naŋɨ́ simɨxɨ́áyɨ́ nánɨ amíná nurɨ ámáyo áwaŋɨ́ murɨpanɨ.” nurɨrɨ ámá o wigɨ́ yarɨgɨ́ápɨ mé ámáyo xewanɨŋo áwaŋɨ́ nura emenɨgɨnɨrɨ e nurɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Amíná apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa tɨ́ŋɨ́ e nánɨ nurɨ womɨ sɨwá nɨwinɨrɨ naŋwɨ́ rɨdɨyowá nánɨ negɨ́ arɨ́o Moseso eŋíná ŋwɨ́ ikaxɨ́ nearagɨ́yɨ́ bɨ rɨdɨyowá siárirɨ joxɨ naŋɨ́ imónɨ́ɨ́yɨ́ nánɨ áwaŋɨ́ rɨrɨ enɨ mɨnɨ wíɨrɨxɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","o Jisasomɨ pɨ́nɨ nɨwiárɨmɨ nurɨ́ná arɨ́kí áwaŋɨ́ rɨmeŋɨnigɨnɨ. E éagɨ nánɨ Jisaso ámá arɨ́kí upupɨ́gɨ́ nipɨ́rɨxɨnɨrɨ aŋɨ́ bɨ bimɨ nurɨ́ná sɨŋánɨ mɨrémopaxɨ́ nɨwimónɨrɨ nánɨ ámá mayɨ́ e ŋweaŋáná ámá amɨ amɨ dánɨ o tɨ́ŋɨ́ e nánɨ bagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jisaso, sɨ́á wí rɨxa nóra núɨsáná, o ámɨ aŋɨ́ yoɨ́ Kapaneamɨyo nánɨ nurɨ xegɨ́ aŋɨ́yo ínɨmɨ ŋweaŋáná ámá obaxɨ́ arɨ́á re nɨwiro “O ámɨ xegɨ́ aŋɨ́yo ŋweanɨ.” rarɨŋagɨ́a arɨ́á e nɨwiro nɨbɨro ");
INSERT INTO aak_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","awí neánɨro nɨpáwiro aŋɨ́yo ínɨmɨ déroro aŋɨ́ ɨ́wí e enɨ pɨ́kwɨpɨ́kwɨ́ inɨro yarɨ́ná o ámá ayɨ́ nɨyonɨ wáɨ́ nɨwirɨ pɨ́né repɨyɨ́ wiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ámá wa eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋɨ́ womɨ —O aŋɨ́ epaxomanɨ. Omɨ íkwiaŋwɨ́yo nikwiárɨro níkwónɨmɨ nɨbɨro aí ");
INSERT INTO aak_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ámá aŋɨ́ ɨ́wí e pɨ́kwɨpɨ́kwɨ́ inɨŋagɨ́a nɨwɨnɨro aŋɨ́yo nɨpáwiro Jisaso tɨ́ŋɨ́ e tɨpaxɨ́ meŋagɨ nánɨ nɨmeámɨ nɨpeyiro aŋɨ́ rɨ́wɨ́ seáyɨyo dánɨ aŋɨ́ sɨ́á bɨ Jisaso ŋweaŋe núpɨyiro íkwiaŋwɨ́ xɨ́o weŋɨ́namɨ mɨdɨmɨdánɨ gwɨ́ nɨyurárárɨro gwɨ́yo ɨ́á nɨxɨrɨmáná aŋɨ́ sɨ́á úpɨyíɨ́e dánɨ awayinɨ mamówáráná ");
INSERT INTO aak_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisaso awa xɨ́omɨ dɨŋɨ́ nɨwɨkwɨ́roro “O negɨ́ ámá eŋɨ́ sɨwímɨ́ eŋomɨ ananɨ naŋɨ́ imɨxɨpaxɨ́rɨnɨ.” yaiwiarɨŋagɨ́a nɨwɨnɨrɨ omɨ re urɨŋɨnigɨnɨ, “Íwe, joxɨ ɨ́wɨ́ ikárɨnɨŋɨ́ rɨxa yokwarɨmɨ́ siiarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa Jisaso uréwapɨyarɨŋɨ́pɨ arɨ́á wianɨro nánɨ e nɨŋwearɨ́ná Jisaso eŋɨ́ sɨwímɨ́ eŋomɨ e urɨ́ɨ́pɨ arɨ́á nɨwiro ínɨmɨ dɨŋɨ́ re nɨmóa ugɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pí nánɨ rɨ́a urarɨnɨ? Nionɨ Gorɨxonɨnɨrɨ yokwarɨmɨ́ rɨwiiarɨnɨ? Sa Gorɨxonɨ ɨ́wɨ́ yokwarɨmɨ́ wiiarɨŋorɨnɨ. Ámá ro Gorɨxomɨ rɨperɨrɨ́ numearɨrɨ rɨ́a yarɨnɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisaso xegɨ́ kwíyɨ́yo dánɨ awa ínɨmɨ dɨŋɨ́ e nɨmóa warɨŋagɨ́a nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né pí nánɨ nionɨ nánɨ ínɨmɨ ‘O ɨ́wɨ́ ámá yarɨgɨ́ápɨ yokwarɨmɨ́ wiipaxomanɨ.’ nɨmóa warɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ámɨ re urɨŋɨnigɨnɨ, “Ámá wo ɨ́wɨ́ ikárɨnɨŋɨ́ nionɨ yokwarɨmɨ́ wiíánáyɨ́ ínɨmɨ imónɨŋagɨ nánɨ ámá woxɨ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ wɨnɨpaxɨ́ menɨnɨ. E nerɨ aiwɨ nionɨ ámá eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋɨ́ womɨ ‘Rɨxa nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ uɨ.’ uránáyɨ́ o naŋɨ́ imónɨ́agɨ ámá nɨyɨ́nénɨ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ wɨnɨpaxɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","re urɨŋɨnigɨnɨ, “Nɨyɨ́nénɨ nionɨ nánɨ re yaiwipɨ́rɨ nánɨ, ‘Ámá imónɨŋo ananɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ ɨ́wɨ́ ikárɨnɨ́ápɨ ananɨ yokwarɨmɨ́ wiipaxorɨnɨ.’ niaiwipɨ́rɨ nánɨ píránɨŋɨ́ sɨŋwɨ́ nanɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","eŋɨ́ sɨwímɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Nionɨ re rɨrarɨŋɨnɨ, ‘Joxɨ nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ aŋɨ́ e nánɨ uɨ.’ rɨrarɨŋɨnɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","O rɨxa naŋɨ́ nimónɨrɨ nɨwiápɨ́nɨmearɨ ámá nɨ́nɨ sɨŋwɨ́ anɨgɨ́e dánɨ íkwiaŋwɨ́ xwaŋwɨ́ níkwónɨmɨ peyeaŋɨnigɨnɨ. E éáná ámá ayɨ́ sɨrɨ́ nɨpɨkínɨro Gorɨxomɨ seáyɨ e numero re rɨgɨ́awixɨnɨ, “Nene eŋíná dánɨ aiwɨ ámá wo ro yarɨŋɨ́pa axɨ́pɨ re yarɨŋagɨ mɨwɨnagwárɨnɨ.” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisaso ámɨ aŋɨ́ e pɨ́nɨ nɨwiárɨmɨ nurɨ ipí imaŋɨ́pá tɨ́ŋɨ́ e ŋweaŋáná oxɨ́ apɨxɨ́ niaíwɨ́ nɨ́nɨ o tɨ́ŋɨ́ e nánɨ bayarɨŋagɨ́a o nuréwapɨya nurɨ ");
INSERT INTO aak_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","sɨnɨ ipí imaŋɨ́pámɨ nɨpurɨ́ná Arɨpiasomɨ xewaxo Ripaio —O takisɨ́ nánɨ nɨgwɨ́ uráparɨŋorɨnɨ. O opisɨ́ aŋɨ́yo éɨ́ nɨŋwearɨ xegɨ́ omɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ rɨ́wɨ́yo nɨxɨ́deɨ.” uráná o nɨwiápɨ́nɨmeámɨ rɨ́wɨ́yo nuxɨ́dɨrɨ nuro ");
INSERT INTO aak_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ripaioyá aŋɨ́yo nɨpáwiro Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nɨŋwearo aiwá nɨnɨro ámá takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á wa tɨ́nɨ (Eŋíná Judayɨ́ aŋɨ́yo takisɨ́ nánɨ nɨgwɨ́ urápɨgɨ́áwa takisɨ́ nánɨ nɨgwɨ́ nurápɨrɨ́náyɨ́ wigɨ́ meapɨ́rɨ́a nánɨ nɨgwɨ́ seáyɨ e bɨ ɨ́wɨ́ urápagɨ́á eŋagɨ nánɨ ámá nɨ́nɨ awa nánɨ xwioxɨ́yo dánɨ wikɨ́ nɨwónɨro kɨ́kɨ́mí nɨwimónɨrɨ yagɨ́árɨnɨ.) Awa tɨ́nɨ ɨ́wɨ́ yarɨgɨ́á wínɨyɨ́ tɨ́nɨ ámá ayɨ́ obaxɨ́ Jisasomɨ nɨxɨ́dɨro nánɨ ayɨ́ enɨ nawínɨ Jisaso tɨ́nɨ aiwá nɨnɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ámá Parisiyɨ rɨnɨŋɨ́yɨ́ wayá ámá Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa Jisaso ámá takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á wa tɨ́nɨ ɨ́wɨ́ yarɨgɨ́á wínɨyɨ́ tɨ́nɨ aiwá nawínɨ narɨŋagɨ́a nɨwɨnɨro xegɨ́ wiepɨsarɨŋowamɨ Jisaso nánɨ re urɨgɨ́awixɨnɨ, “O pí nánɨ ámá takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́á awa tɨ́nɨ ɨ́wɨ́ yarɨgɨ́á ayɨ́ tɨ́nɨ nawínɨ aiwá nɨro iniɨgɨ́ nɨro yarɨŋoɨ? O naŋɨ́ rɨyarɨnɨ?” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisaso e urarɨŋagɨ́a arɨ́á nɨwirɨ ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá sɨmɨxɨ́ mepa nerɨ́ná xwɨrɨ́ tɨ́ŋɨ́ e nánɨ warɨgɨ́ámanɨ. Sɨmɨxɨ́ tɨ́gɨ́áyɨ́ warɨgɨ́árɨnɨ. Nionɨ enɨ ámá ‘Nionɨ nɨgɨ́pɨ wé rónɨŋɨnɨ.’ yaiwinarɨgɨ́áyɨ́ nánɨ mɨbɨŋárɨnɨ. Ámá ‘Nionɨ ɨ́wɨ́ yarɨŋáonɨrɨnɨ.’ yaiwinarɨgɨ́áyɨ́ wigɨ́ uyɨ́niɨ́ yarɨgɨ́ápɨ yokwarɨmɨ́ wiíáná ayɨ́ wé rónɨŋɨ́ imónɨpɨ́rɨ nánɨ bɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ aiwá ŋwɨ́á bɨ mɨŋweapa yarɨŋagɨ́a Jono wayɨ́ numeaia warɨŋoyá wiepɨsarɨŋowa tɨ́nɨ ámá Parisiyɨ rɨnɨŋowa tɨ́nɨ aiwá nánɨ ŋwɨ́á nɨŋwɨrárɨnayiróná Jonoyá wiepɨsarɨŋowa tɨ́nɨ Parisiowayá wiepɨsarɨgɨ́á wa tɨ́nɨ nawínɨ nuro Jisasomɨ nɨwímearo re urɨgɨ́awixɨnɨ, “Jonoyá neaiepɨsarɨŋone tɨ́nɨ Parisiowayá neaiepɨsarɨgɨ́one tɨ́nɨ aiwá nánɨ ŋwɨ́á ŋwɨrárɨnayarɨŋwɨnɨ. Pí nánɨ joxɨyá wiepɨsarɨŋowa aiwá ŋwɨ́á mɨŋweá yarɨŋoɨ?” uráná ");
INSERT INTO aak_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisaso ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá apɨxɨ́ sɨŋɨ́ ŋwɨrárɨ́o sɨnɨ ŋweaŋáná oyá nɨkumɨxɨnɨrɨ emearɨgɨ́áwa aiwá ŋwɨ́á nɨxeŋwɨrárɨnɨro yarɨgɨ́áranɨ? Oweoɨ, o sɨnɨ awa tɨ́nɨ ŋweaŋáná aiwá ŋwɨ́á xeŋwɨrárɨnɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","E nerɨ aiwɨ o apɨxɨ́ nɨmearɨ nɨŋweaŋɨsáná eŋáná ámá wí omɨ anɨ́nɨmɨxáná íná aiwá ŋwɨ́á ŋweapɨ́rɨ́árɨnɨ.” nurɨrɨ xewanɨŋo apɨxɨ́ sɨŋɨ́ ŋwɨrárɨ́ónɨŋɨ́ imónɨŋagɨ nánɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ewayɨ́ xwɨyɨ́á ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá rapɨrapɨ́ eŋínaŋɨ́ nɨyíga bagɨ́á wú axenɨŋagɨ nɨwɨnɨrɨ́ná rapɨrapɨ́ sɨŋɨ́ sɨnɨ wayɨ́ mɨrónɨŋɨ́ wú nɨmearo nupákiro gwɨ́ kiwearɨgɨ́ámanɨ. E yanɨro éɨ́áyɨ́ wayɨ́ róáná sɨŋɨ́ upákíɨ́ú nɨkɨkarínɨrɨ eŋɨ́ nɨpɨperɨ́ná eŋínaŋú xwé naxega unɨŋoɨ.” nurɨrɨ ayɨ́ wigɨ́ eŋíná dánɨ “Nene e nerɨ́ná wé rónɨŋɨ́ nimónɨrane nɨperɨ́náyɨ́, ananɨ Gorɨxo tɨ́ŋɨ́ e nánɨ peyanɨ́wárɨnɨ.” nɨra wagɨ́ápɨ sɨnɨ yarɨgɨ́ápɨ tɨ́nɨ oyá xwɨyɨ́á sɨŋɨ́ tɨ́nɨ nawínɨ ɨkwieropɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ámɨ axɨ́pɨ oyaiwípoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Ámá iniɨgɨ́ wainɨ́ sɨŋɨ́ nɨmearo memé wará sɨxɨ́ soyɨ́ axɨ́yo iwajɨ́á yarɨgɨ́ámanɨ. Iwajɨ́á yanɨro éɨ́áyɨ́ núpɨyimɨ nɨpurɨ sɨxɨ́ soyɨ́wá enɨ rɨxa sɨpí enɨŋoɨ. Wainɨ́ sɨŋɨ́ memé wará sɨxɨ́ sɨŋɨ́yo iwajɨ́á yarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ Sabarɨ́áyo aŋɨ́ nemero witɨ́ aiwá omɨŋɨ́ tɨ́ŋɨ́ e óɨ́yo nɨpurɨ́ná wiepɨsarɨŋowa witɨ́ siyɨ́ nɨyíraga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ámá Parisiyɨ rɨnɨŋɨ́yɨ́ wa omɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Awa pí nánɨ ‘Sabarɨ́áyo ŋwɨ́árɨnɨ.’ rɨnɨŋɨ́pɨ nɨwiaíkiro witɨ́ aiwá nɨyírɨro narɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né xwɨyɨ́á negɨ́ mɨxɨ́ ináyɨ́ Depito nánɨ eánɨŋɨ́pɨ ɨ́á nɨroro aiwɨ dɨŋɨ́ wí mɨmoarɨŋoɨ. Eŋíná Depito, ámá Abaiataoyɨ rɨnɨŋo —O eŋíná apaxɨ́pánɨŋɨ́ imónɨŋɨ́ xwé worɨnɨ. O xegɨ́ Judayɨ́ Gorɨxomɨ rɨdɨyowá wianɨro nánɨ senɨ́á aŋɨ́ pákínɨŋɨ́yo meweŋáná, Depito tɨ́nɨ xegɨ́ ámá nɨkumɨxɨnɨrɨ emearɨgɨ́áwa tɨ́nɨ aiwá meŋagɨ nánɨ agwɨ́ wiarɨ́ná o senɨ́á aŋɨ́ pákínɨŋiwámɨ nɨpáwirɨ bisɨ́kerɨ́á Gorɨxo nánɨ peaxɨ́ tɨnɨŋɨ́pɨ umeaíáná Depito nɨnɨrɨ xegɨ́ ámáyo enɨ nɨnɨrɨ wiŋɨnigɨnɨ. Bisɨ́kerɨ́á apɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwanɨ ananɨ nɨpaxɨ́rɨnɨ. Apɨ Depito nɨnɨrɨ aiwɨ Gorɨxo o nánɨ xwɨyɨ́á bɨ murɨ́ eŋáná gɨ́ wiepɨsarɨŋá rowa enɨ agwɨ́ wiarɨŋagɨ nánɨ yarɨ́ná pí nánɨ xwɨyɨ́ánɨ meararɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","re urɨŋɨnigɨnɨ, “Gorɨxo ámá xámɨ nimɨxárɨmáná sɨ́á wɨyi kikiɨ́á ŋwearo dɨŋɨ́ sɨxɨ́ yínɨro epɨ́rɨ nánɨ Sabarɨ́á tɨŋɨ́rɨnɨ. Sabarɨ́á xámɨ nɨtɨrɨ ámá rɨ́wɨ́yo Sabarɨ́áyo mewepɨ́rɨ́a nánɨ imɨxɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ayɨnánɨ ámá imónɨŋáonɨ Sabarɨ́á ayo aí xiáwonɨrɨnɨ. Nionɨ ‘Sabarɨ́áyo ayɨ́ ananɨrɨnɨ.’ rɨpaxɨ́ imónɨŋáonɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisaso ámɨ rotú aŋɨ́ wiwámɨ nɨpáwirɨ ámá wé kɨrɨŋɨ́ eŋɨ́ wo ŋweaŋagɨ nɨwɨnɨrɨ uréwapɨyarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ámá Parisi wa —Awa re rarɨgɨ́árɨnɨ, “Sabarɨ́áyo omɨŋɨ́ nerɨ́náyɨ́ ayɨ́ ŋwɨ́árɨnɨ. Ámá aí Sabarɨ́áyo naŋɨ́ nimɨxɨrɨ́náyɨ́ ayɨ́ ŋwɨ́árɨnɨ.” rarɨgɨ́árɨnɨ. Awa Jisaso ámá wé kɨrɨŋɨ́ eŋɨ́ omɨ Sabarɨ́áyo naŋɨ́ wimɨxáná omɨ xwɨyɨ́á mearanɨro nánɨ sɨŋwɨ́ nɨwɨnɨro ŋweaŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","o wé kɨrɨŋɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Nɨwiápɨ́nɨmeámɨ nɨbɨrɨ áwɨnɨ e éɨ́ roɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Parisiowamɨ re urɨŋɨnigɨnɨ, “Segɨ́ dɨŋɨ́ píoɨ moarɨŋoɨ? ‘Sabarɨ́áyo ámáyo naŋɨ́ nɨwiirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Sabarɨ́áyo sɨpí nɨwikárɨrɨ́náyɨ́ ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ?” nurɨrɨ ámɨ re urɨŋɨnigɨnɨ, “ ‘Sabarɨ́áyo sɨmɨxɨ́yo píránɨŋɨ́ nimɨxɨrɨ́náyɨ́ ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Ámá nɨpɨkirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ?” urɨ́agɨ aiwɨ awa xwɨyɨ́á bɨ murɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xwɨyɨ́á bɨ murarɨŋagɨ́a nɨwɨnɨrɨ sɨŋwɨ́ nɨwɨnɨmerɨ́ná wikɨ́ nɨwóga nurɨ awa wé ikɨ́ eŋomɨ wá bɨ mɨwianɨ́ dɨŋɨ́ kɨ́kɨ́mí nɨwimóga warɨŋagɨ́a nɨwɨnɨrɨ awa nánɨ dɨŋɨ́ sɨpí enɨ nɨwirɨ omɨ re urɨŋɨnigɨnɨ, “Wé ɨ́eapá énapeɨ.” uráná o wé ɨ́eapá nerɨ́ná re eŋɨnigɨnɨ. Rɨxa naŋɨ́ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Rɨxa naŋɨ́ imónɨ́agɨ Parisiowa sɨŋwɨ́ e nɨwɨnɨro nɨwiápɨ́nɨmeámɨ nɨpeyearo ámá mɨxɨ́ ináyɨ́ Xeroto tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨgɨ́áwa tɨ́nɨ awí neánɨro Jisasomɨ pɨkianɨro nánɨ ínɨmɨ mekaxɨ́ megɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisaso, Parisiowa xɨ́o nánɨ mekaxɨ́ mearɨŋagɨ́a, o xegɨ́ wiepɨsarɨŋowa tɨ́nɨ ámɨ ipíwá rɨwoŋɨ́mɨnɨ úáná ámá Gariri pɨropenɨsɨ́yo dáŋɨ́ obaxɨ́ omɨ númɨ nuro ámá Judia pɨropenɨsɨ́yo dáŋɨ́yɨ́ tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","wigɨ́ aŋɨ́ xwé yoɨ́ Jerusaremɨ áwɨnɨ e mɨrɨnɨŋɨ́pimɨ dáŋɨ́yɨ́ tɨ́nɨ xwɨ́á yoɨ́ Idumia ŋweáyɨ́ tɨ́nɨ ámá iniɨgɨ́ Jodanɨ rapáyo orɨwámɨdánɨ ŋweáyɨ́ tɨ́nɨ émáyɨ́ aŋɨ́ biaú Saidonɨ tɨ́nɨ Taia tɨ́nɨ tɨ́ŋɨ́ e ŋweáyɨ́ tɨ́nɨ ámá xwé obaxɨ́ ayɨ́ Jisaso yarɨŋɨ́pɨ nánɨ arɨ́á nɨwiro xɨ́o tɨ́ŋɨ́ e nánɨ bɨmiarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jisaso ámá obaxɨ́ sɨmɨxɨ́yo naŋɨ́ imɨmɨxɨmɨ́ éɨ́ eŋagɨ nánɨ ámá nɨ́nɨ sɨmɨxɨ́yɨ́ omɨ amáɨ́ rónanɨro nánɨ ɨkwɨkwierɨ́ niga warɨŋagɨ́a nánɨ xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámá obaxɨ́ amáɨ́ nɨnɨrónɨrɨ́ná nɨnɨxoyɨ́pióa nɨbarɨŋoɨ. Ewéyo pɨxemoánɨmɨ nánɨ píránɨŋɨ́ aŋwɨ e nɨtípoyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ámá imɨ́ó dɨŋɨ́ xɨxéroarɨgɨ́áyɨ́ Jisasomɨ nɨwɨnɨrɨ́náyɨ́ sɨ́mɨmaŋɨ́mɨnɨ nɨpɨ́kínɨmearo waunɨ́ nɨwikárɨnɨro “Niaíwɨ́ Gorɨxoyáoxɨrɨnɨ.” uranɨro yarɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","o mɨxɨ́ numáɨnowárɨrɨ́ná mɨxɨ́ rɨ́á tɨ́ŋɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ Gorɨxomɨ xewaxonɨ eŋagɨ nánɨ áwaŋɨ́ mɨrowiáropanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisaso dɨ́wɨ́yo nánɨ nɨyirɨ ámá xɨ́o xegɨ́ wimónarɨŋowamɨ “Soyɨ́né enɨ yapɨ́poyɨ.” uráná awa enɨ xɨ́o tɨ́ŋɨ́ e nánɨ nɨyiro wímeááná ");
INSERT INTO aak_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","o ámá wé wúkaú sɨkwɨ́ waú xɨ́o tɨ́nɨ emepɨ́rɨ́a nánɨ imónɨro xɨ́o nánɨ wáɨ́ nurɨmero ámá imɨ́ó xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowárɨpaxɨ́ nimónɨro ero epɨ́rɨ́a nánɨ rɨ́peaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ámá wé wúkaú sɨkwɨ́ waú xɨ́o rɨ́peaŋowa wigɨ́ yoɨ́ rowarɨnɨ. Wo Saimono —O Jisaso yoɨ́ ámɨ bɨ Pitaoyɨ wɨ́rɨŋorɨnɨ. O tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ámɨ waú Sebediomɨ xewaxowaú Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ —Awaúmɨ Jisaso yoɨ́ Boanesisowaúyɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ awaú akɨrɨwɨ́nɨŋɨ́ imónɨgɨ́íwaú eŋagɨ nánɨrɨnɨ. Yoɨ́ e wɨ́rɨŋowaú tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ámɨ wo Adɨruo tɨ́nɨ ámɨ wo Piripo tɨ́nɨ ámɨ wo Batoromuo tɨ́nɨ ámɨ wo Matɨyuo tɨ́nɨ ámɨ wo Tomaso tɨ́nɨ ámɨ wo Arɨpiasomɨ xewaxo Jemisoyɨ rɨnɨŋo tɨ́nɨ ámɨ wo Tadiaso tɨ́nɨ ámɨ wo Saimono —O yoɨ́ ámɨ bɨ Seretoyɨ rɨnɨŋɨ́yɨ́ —Yoɨ́ mɨ́kɨ́ ayɨ́ “Émáyɨ́ ámɨ oxɨ́dowáraneyɨ.” rarɨgɨ́áyɨ́ nánɨrɨnɨ. E rɨnɨŋo tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ámɨ wo yoparo Isɨkariotɨ dáŋɨ́ Judaso —O Jisaso nánɨ mɨyɨ́ rorɨ́rɨmeŋorɨnɨ. O tɨ́nɨ ámá wé wúkaú sɨkwɨ́ waú awamɨ rɨ́peaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ ámɨ aŋɨ́ e nánɨ nuro ŋweaŋáná ámá obaxɨ́ o tɨ́ŋɨ́ e awí neánɨro epɨ́royɨ́ wiarɨŋagɨ́a nánɨ nɨyórɨ́moro aiwá mɨnɨpaxɨ́ wimónarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisasomɨ xexɨrɨ́meáyɨ́ ámá wí xɨ́o nánɨ “Xewanɨŋo rɨxa majɨ́á nikárɨnɨrɨ yarɨnɨ.” rarɨŋagɨ́a arɨ́á nɨwiro omɨ nɨwirɨmeámɨ wanɨro nánɨ barɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gorɨxoyá ŋwɨ́ ikaxɨ́ mewegɨ́á wa aŋɨ́ yoɨ́ Jerusaremɨ dánɨ nɨbɨmáná Jisaso tɨ́ŋɨ́ e rémónapɨ́áwa ámáyo Jisaso nánɨ re nura ugɨ́awixɨnɨ, “Imɨ́ó xɨráónɨŋɨ́ imónɨŋo Bieseburoyɨ rɨnɨŋo —O xegɨ́ yoɨ́ bɨ Setenorɨnɨ. O Jisasomɨ rɨ́wɨ́mɨnɨ nɨrómáná xɨxéroŋagɨ nánɨ o ámá imɨ́ó xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnowárarɨnɨ.” nura warɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisaso awamɨ “Niɨwanɨŋonɨ tɨ́ŋɨ́ e nánɨ bɨ́poyɨ.” nurɨrɨ ewayɨ́ ikaxɨ́ bɨ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “ ‘Seteno xegɨ́ wɨ́amɨ mɨxɨ́ umáɨnowárɨpaxɨ́ imónɨnɨ.’ rɨyaiwiarɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá axowa mɨxɨ́ ninɨro xepɨxepá nɨrónɨróná eŋɨ́ mɨweánɨpa nero mɨmiaŋwɨ́ upɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ámá gwɨ́ axɨ́rí enɨ mɨxɨ́ ninɨro xepɨxepá nɨrónɨróná eŋɨ́ mɨweánɨpa nero xwɨ́ámɨ imónɨpɨ́rɨ́árɨnɨ.” nurɨrɨ “Seteno xegɨ́ wɨ́amɨ mɨxɨ́ umáɨnowárɨpaxɨ́ mimónɨŋagɨ nánɨ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á apɨ nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ámɨ re urɨŋɨnigɨnɨ, “Seteno enɨ xegɨ́ wɨ́amɨ tɨ́nɨ mɨxɨ́ ninɨro xepɨxepá nɨrónɨrónáyɨ́ wiwanɨŋowa eŋɨ́ meánɨ́ ninɨro xopɨrárɨ́ inɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ayɨ́ xewanɨŋo nánɨ dɨŋɨ́ re oyaiwípoyɨnɨrɨ “Setenoyá eŋɨ́ eánɨŋɨ́pɨ tɨ́nɨ mé omɨ xopɨrárɨ́ wimɨnɨrɨ rɨ́a yarɨnɨ?” oyaiwípoyɨnɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ámɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo ámá rɨ́á rɨŋɨ́ woyá iyɨ́á ɨ́á urápekɨxémɨnɨrɨ nánɨ oyá aŋɨ́yo nɨpáwirɨ́ná amíná aŋɨ́ xiáwomɨ gwɨ́ nɨyirɨ nɨtɨmáná amɨpí oyá ananɨ urápekɨxenɨgɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ámɨ re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ. Ɨ́wɨ́ yarɨgɨ́ápɨranɨ, rɨperɨrɨ́ inarɨgɨ́ápɨranɨ, amɨpí sɨpí nɨ́nɨ ámá yarɨgɨ́ápɨ Gorɨxo ananɨ yokwarɨmɨ́ seaiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","E nerɨ aiwɨ ámá Gorɨxoyá kwíyɨ́ nánɨ rɨperɨrɨ́ méɨ́áyɨ́ Gorɨxo e rɨ́ápɨ ámɨ wí yokwarɨmɨ́ wiinɨ́ámanɨ. Anɨŋɨ́ e nimónɨrɨ xwɨyɨ́á meárɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ayɨ́ rɨpɨ nánɨ e urɨŋɨnigɨnɨ. Gorɨxoyá kwíyɨ́ tɨ́nɨ imɨ́ó mɨxɨ́ umáɨnowárarɨŋagɨ aiwɨ awa Gorɨxoyá kwíyɨ́ rɨperɨrɨ́ nɨmearɨro “Jisaso imɨ́ó dɨŋɨ́ xɨxéroŋagɨ nánɨ imɨ́ó wɨ́amɨ mɨxɨ́ umáɨnowárarɨnɨ.” rarɨŋagɨ́a nánɨ Jisaso xwɨyɨ́á apɨ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisaso sɨnɨ aŋɨ́yo ŋweaŋáná xegɨ́ xɨnáí tɨ́nɨ xogwáowa tɨ́nɨ nɨrémónapɨro bɨ́arɨwámɨnɨ nɨrómáná “Jisaso nɨ́wiapɨrɨ sɨŋwɨ́ oneanɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ámá Jisasomɨ epɨ́royɨ́ nɨwiro mɨnɨ mɨnɨ nɨŋweaxa pugɨ́á wí re urɨgɨ́awixɨnɨ, “Ai dɨxɨ́ rɨnáí tɨ́nɨ rɨrɨxɨ́meáowa tɨ́nɨ bɨ́arɨwámɨnɨ nɨrómáná joxɨ nánɨ rarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","o “Ewayɨ́ xwɨyɨ́á bɨ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ámá gɨyɨ́ gɨ́ nókí tɨ́nɨ gɨ́ nɨrɨxɨ́meáowa tɨ́nɨrɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ámá mɨnɨ mɨnɨ nɨŋweaxa pugɨ́áyo sɨŋwɨ́ nɨwɨnɨmerɨ́ná re urɨŋɨnigɨnɨ, “Gɨ́ inókíwayɨ́né, nɨrɨxɨ́meáowayɨ́né rɨxa tɨ́ ŋweagɨ́á ayoɨ. ");
INSERT INTO aak_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ámá gɨyɨ́ Gorɨxo rɨŋɨ́yo dɨŋɨ́ nɨkwɨ́roro xɨ́darɨgɨ́áyɨ́ ayɨ́ gɨ́ inókíwánɨŋɨ́ tɨ́nɨ gɨ́ nɨrɨxɨ́meánɨŋɨ́ tɨ́nɨ imónɨgɨ́áyɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisaso ámɨ ipí Gariri imaŋɨ́ tɨ́ŋɨ́ e nánɨ nurɨ nuréwapɨyirɨ ámá xwé obaxɨ́ awí neánɨro epɨ́royɨ́ wiarɨŋagɨ́a o ewéyo nɨpɨxemoánɨrɨ éɨ́ nɨŋwearɨ ámá nɨ́nɨ sɨnɨ ipí imaŋɨ́ e ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","o nuréwapɨyirɨ́ná xɨxewisɨ́ xwɨyɨ́á amɨpí obaxɨ́ nánɨ nuréwapɨyirɨ ");
INSERT INTO aak_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","re urɨŋɨnigɨnɨ, “Arɨ́á époyɨ. Ámá wo o xegɨ́ omɨŋɨ́yo axɨ́pɨ witɨ́ siyɨ́ nɨwiáróa umɨnɨrɨ nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","xwɨ́á yunɨ́ ikɨxeárɨnɨŋe píránɨŋɨ́ nɨwiáróa nurɨ aiwɨ wí óɨ́ maŋɨ́pá tɨ́nɨ piéróáná iŋɨ́ nɨbɨro mɨmeánɨ́ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ámɨ wí sɨ́ŋá ínɨmɨ yapɨnɨŋáná xwɨ́á onɨmiápɨ seáyɨ e eŋáná wiáróɨ́yɨ́ xwɨ́á akwɨnɨ́ánáɨ eŋagɨ nánɨ apaxɨ́ mé nerápɨmáná ");
INSERT INTO aak_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","sogwɨ́ nɨwepɨ́nɨrɨ xaíwɨ́ anarɨ́ná pɨpɨŋɨ́ mɨwárɨŋagɨ nánɨ nɨyɨweánɨrɨ yeáyɨ́ yárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ámɨ wí emɨ́ pɨpɨŋɨ́ arɨ́kiárɨnɨŋe wiáróɨ́yɨ́ emɨ́ pɨpɨŋɨ́yo dánɨ nerápɨrɨ xeŋwɨrárɨŋagɨ nánɨ witɨ́ siyɨ́ apɨ ná mɨweŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ámɨ wí xwɨ́á naŋɨ́ e wiáróɨ́yɨ́ píránɨŋɨ́ nerápɨrɨ xwé nerɨ ná nɨkɨkɨreánɨrɨ́ná wí xwé onɨmiápɨ nɨwerɨ wí xwé obaxɨ́ nɨwerɨ wí aga dɨŋɨ́ nɨmorɨ ɨ́á mɨropaxɨ́ weŋɨnigɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ámɨ re urɨŋɨnigɨnɨ, “Seyɨ́né witɨ́ siyɨ́ nánɨ nionɨ ewayɨ́ xwɨyɨ́á rɨ́á apɨ nánɨ arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Idáná o xegɨ́pɨ ŋweaŋáná wiepɨsarɨŋowa wé wúkaú sɨkwɨ́ waú tɨ́nɨ ámá wí xɨ́o tɨ́nɨ emearɨgɨ́áyɨ́ tɨ́nɨ wigɨ́pɨ ewayɨ́ xwɨyɨ́á xɨ́o rɨ́ɨ́pɨ nánɨ yarɨŋɨ́ wiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","o re urɨŋɨnigɨnɨ, “Xwɨyɨ́á Gorɨxo seyɨ́né xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ eŋíná dánɨ ínɨmɨ imónɨŋɨ́pɨ nionɨ rɨxa wɨ́á searókiamoarɨŋɨnɨ. E nerɨ aiwɨ ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́ró wigɨ́ dɨŋɨ́ tɨ́nɨ néra warɨgɨ́áyo nionɨ uréwapɨyarɨ́ná mɨ́kɨ́pɨ arɨ́á mɨní ewayɨ́ xwɨyɨ́á rarɨŋápɨnɨ arɨ́á niarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ayɨ́ rɨpɨ nánɨ ewayɨ́ xwɨyɨ́ánɨ urarɨŋɨnɨ. Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́ró wigɨ́ dɨŋɨ́ tɨ́nɨ néra warɨgɨ́áyɨ́ nánɨ eŋíná nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨnigɨnɨ, ‘Ámá ayɨ́ wigɨ́ uyɨ́niɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ mamóánáyɨ́ Gorɨxo yokwarɨmɨ́ wiinɨgɨnɨrɨ ewayɨ́ xwɨyɨ́á arɨ́á nɨwirɨ́ná arɨ́á nɨwiro aiwɨ nɨjɨ́á mimónɨ́ ero sɨŋwɨ́ nɨwɨnɨrɨ́ná sɨŋwɨ́ nɨwɨnɨro aiwɨ dɨŋɨ́ mɨmó ero epɨ́rɨ nánɨ ewayɨ́ xwɨyɨ́ánɨ urɨnɨ́árɨnɨ.’ Aisaiao eŋíná rɨ́wamɨŋɨ́ e eaŋɨ́pɨ tɨ́nɨ xɨxenɨ nionɨ xɨxenɨ e yarɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O ámɨ re urɨŋɨnigɨnɨ, “Soyɨ́né ewayɨ́ xwɨyɨ́á nionɨ rɨ́ápɨ sɨnɨ majɨ́á rimónɨŋoɨ? Ewayɨ́ xwɨyɨ́á apɨ nɨjɨ́á mimónɨpa nerɨ́náyɨ́, ewayɨ́ xwɨyɨ́á nionɨ rarɨŋá nɨpɨnɨ arɨge nerɨ nɨjɨ́á imónɨpɨ́rɨ́árɨnɨ? Mɨ́kɨ́pɨ áwaŋɨ́ osearɨmɨnɨrɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ámá witɨ́ siyɨ́ wiároarɨŋoyɨ́ xwɨyɨ́á Gorɨxo nánɨ wáɨ́ nemerɨ urɨmearɨŋónɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ámá wí witɨ́ siyɨ́ óɨ́pá tɨ́nɨ piéróɨ́pɨ iŋɨ́ nɨbɨrɨ manarɨŋɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxo nánɨ arɨ́á wíɨ́ápɨ Seteno ayɨ́ Gorɨxo nánɨ dɨŋɨ́ mopɨ́rɨxɨnɨrɨ aŋɨ́nɨ nɨbɨrɨ pɨ́rɨpɨ́rɨ́ nɨwirɨ emɨ mɨmeámɨ́ yarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ámá ámɨ wí witɨ́ siyɨ́ sɨ́ŋá ínɨmɨ yapɨnɨŋáná seáyɨ e xwɨ́á onɨmiápɨ eŋáná wiáróɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxo nánɨ arɨ́á nɨwiróná yayɨ́ nɨwinɨrɨ nɨxɨ́danɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","xwɨyɨ́á ná ínɨmɨ pɨpɨŋɨ́nɨŋɨ́ mɨwárɨŋagɨ nánɨ anɨŋɨ́ xɨ́darɨgɨ́ámanɨ. Xwɨyɨ́á Gorɨxo nánɨ xɨ́danɨro yarɨŋagɨ́a nánɨ ámá wí nɨbɨro nepa eŋɨ́ neánɨro rɨ́a xɨ́darɨŋoɨnɨrɨ iwamɨ́ó nɨwíwapɨyirɨ xeanɨŋɨ́ wikeáráná apaxɨ́ mé pɨ́nɨ wiárarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ámá ámɨ wí witɨ́ siyɨ́ emɨ́ pɨpɨŋɨ́ arɨ́kiárɨnɨŋe wiáróɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ enɨ xwɨyɨ́á Gorɨxo nánɨ arɨ́á nɨwiro aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amɨpí xwɨ́áyo dáŋɨ́ nánɨ dɨŋɨ́ obɨbaxɨ́ nɨmoro ‘Amɨpí wí nionɨ mɨnɨmúropa oninɨ.’ nɨyaiwiro amɨpí wí nánɨ ‘Arɨge nímeanɨ́árɨ́anɨ?’ nɨyaiwia nurɨ́náyɨ́ witɨ́ emɨ́ nerápɨrɨ xeŋwɨrárarɨŋɨ́ yapɨ nimónɨro aiwá ná mɨkɨkɨreánarɨŋɨ́yɨ́ yapɨ imónarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ámá ámɨ wí witɨ́ siyɨ́ xwɨ́á naŋɨ́ imónɨŋe wiáróɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxo nánɨ arɨ́á nɨwiro dɨŋɨ́ nɨkwɨ́roro píránɨŋɨ́ nɨxɨ́dɨróná witɨ́ siyɨ́ aiwá ná wí xwé onɨmiápɨ werɨ wí xwé obaxɨ́ werɨ wí aga dɨŋɨ́ nɨmorɨ ɨ́á mɨropaxɨ́ werɨ yarɨŋɨ́yɨ́nɨŋɨ́ imónɨnɨ.” Ewayɨ́ xwɨyɨ́á mɨ́kɨ́pɨ nánɨ áwaŋɨ́ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O wiepɨsarɨŋowa “Ámá ayo anɨŋɨ́ yumɨ́í winɨ́árɨnɨ.” yaiwipɨ́rɨxɨnɨrɨ sɨnɨ ewayɨ́ xwɨyɨ́á nánɨ áwaŋɨ́ nurɨrɨ́ná re urɨŋɨnigɨnɨ, “ ‘Ámá ramɨxɨ́ nɨmɨxárómáná sɨxɨ́ xwé wá nɨmearɨ upɨxákwiárɨpɨ́rɨxɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Pieŋɨ́ íkwiaŋwɨ́yo ínɨmɨ tɨpɨ́rɨxɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ, íkwiaŋwɨ́yo sɨŋánɨŋɨ́ e tarɨgɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","re urɨŋɨnigɨnɨ, “Xwɨyɨ́á eŋíná dánɨ Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ ínɨmɨ imónɨŋɨ́pɨranɨ, amɨpí pɨ́nɨ́ imónɨŋɨ́pɨranɨ, nɨpɨnɨ sɨŋánɨ imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xwɨyɨ́á nionɨ seararɨŋápɨ nánɨ arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","re urɨŋɨnigɨnɨ, “Arɨ́á nɨnirɨ́ná dɨŋɨ́ píránɨŋɨ́ nɨmoro arɨ́á nirɨ́ɨnɨ. E nerɨ́náyɨ́, Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨjɨ́á nimónɨro sɨnɨ dɨŋɨ́ píránɨŋɨ́ nɨmoro arɨ́á nɨnia nurɨ́náyɨ́, oyá dɨŋɨ́ tɨ́nɨ nɨjɨ́á ámɨ wínɨ nimóga upɨ́rɨ́árɨnɨ. E mepa nerɨ́náyɨ́, pɨ́né nionɨ seararɨŋápɨ rɨ́wɨ́mɨnɨ mamoro íkɨ́ nemoro nerɨ́náyɨ́, xwɨyɨ́á Gorɨxo nánɨpɨ nɨjɨ́á wí imónɨpɨ́rɨ́ámanɨ. Xwɨyɨ́á Gorɨxo nánɨpɨ nɨjɨ́á onɨmiápɨ imónɨgɨ́áyɨ́ aí xewanɨŋo ámɨ pɨ́rɨpɨ́rɨ́ winɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O sɨnɨ ámá e ŋweagɨ́á nɨyonɨ xwɨyɨ́á Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́a nánɨpɨ nurɨrɨ́ná ámɨ ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ re imónɨnɨ. Ámá wo omɨŋɨ́yo nánɨ nurɨ witɨ́ siyɨ́ nɨwiáróa núɨsáná ");
INSERT INTO aak_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","sá werɨ wiápɨ́nɨmearɨ yarɨ́ná witɨ́ siyɨ́ rɨxa nerápɨrɨ xwé nerɨ o ‘Arɨge nerápɨrɨ rɨ́a peyarɨnɨ?’ yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","xegɨ́pɨ xwɨ́áyo dánɨ nɨpeyirɨ ɨwɨ́ niga nɨyirɨ siyɨ́ nerɨ ná nɨkɨkɨreága nɨpeyirɨ ");
INSERT INTO aak_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","yóɨ́ éáná rɨxa mipaxɨ́ eŋagɨ nɨwɨnɨrɨ́ná kirá nɨmearɨ mɨwákwímɨ́ yarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. Gorɨxo xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́ápɨ axɨ́pɨ iwamɨ́ó nerɨ́ná ayɨ́ dɨŋɨ́ “Arɨge nerɨ́ná xwé imónɨnɨ́árɨnɨ?” nɨyaiwiro aiwɨ “Xegɨ́pɨ xwé imónɨnɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ nánɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ámɨ re urɨŋɨnigɨnɨ, “Pí pí ewayɨ́ xwɨyɨ́á nɨrɨrane Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ nánɨ ranɨ́wɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","O nɨbɨrɨ neameŋweanɨ́ápɨ masɨté aiwá siyɨ́nɨŋɨ́ imónɨnɨ. Masɨté aiwá siyɨ́ nurɨrɨ́ná aga onɨmiápia wiároarɨgɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","nerápɨmáná xwé nerɨ aiwá nɨ́nɨ negɨ́ omɨŋɨ́yo yarɨŋɨ́pimɨ seáyɨ e nɨmúrorɨ reŋɨ́ sepiá wiexáráráná iŋɨ́ nɨbɨrɨ yéwɨ́ ínɨrɨwámɨnɨ tarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. Ayɨ́ “Iwamɨ́óyɨ́ nene onɨmiápɨ nerɨ aiwɨ rɨ́wéná ámá xwé obaxene Gorɨxo neameŋweanɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Xwɨyɨ́á Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́ápɨ nánɨ nurɨrɨ́ná ámá ayɨ́ arɨ́á wipaxɨ́pɨ tɨ́nɨ xɨxenɨ ewayɨ́ xwɨyɨ́á obaxɨ́ axɨ́pɨ́nɨŋɨ́ imónɨŋɨ́ nura nurɨ ");
INSERT INTO aak_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","sɨŋánɨ áwaŋɨ́ bɨ murɨ́ ewayɨ́ xwɨyɨ́ánɨ nura nurɨ aiwɨ wiepɨsarɨŋowa tɨ́nɨnɨ nɨŋwearɨ́ná ewayɨ́ xwɨyɨ́á xɨ́o urarɨŋɨ́ mɨ́kɨ́pɨ nánɨ áwaŋɨ́ urayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","O ewayɨ́ xwɨyɨ́á nura núɨsáná sɨ́ápɨ tɨ́nɨ axíná xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ipíyo jɨ́arɨwámɨnɨ oxemoaneyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","awa ámá obaxɨ́ e awí eánɨgɨ́áyo pɨ́nɨ nɨwiárɨmɨ ewé Jisaso éɨ́ nɨŋwearɨ e dánɨ pɨ́né uréwapɨyarɨŋɨ́pámɨ enɨ nɨpɨxemoánɨro Jisaso tɨ́nɨ nuro ewé wí enɨ awa tɨ́nɨ warɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rɨ́wɨpí bɨrɨ iniɨgɨ́ enɨ imeamɨ́kwɨ́ erɨ nerɨ́ná ewéyo mɨmeámɨ́ yarɨ́ná ewéyo iniɨgɨ́ rɨxa nɨróga wiápɨ́nɨmeaarɨŋagɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisaso ewé íkwémɨŋɨ́mɨnɨ íkwiaŋwɨ́yo sá weŋomɨ saiwiárɨ́ nɨwiro re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, none rɨxa iniɨgɨ́ namianɨrɨ yarɨŋwáyoɨ! Joxɨ dɨŋɨ́ nɨmorɨ rɨweŋɨnɨ?” uráná ");
INSERT INTO aak_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","o nɨwiápɨ́nɨmearɨ re eŋɨnigɨnɨ. “Rɨ́wɨpí samɨŋɨ́ oweárɨnɨ.” rɨrɨ “Iniɨgɨ́ imeamɨ́kwɨ́ yarɨŋɨ́pɨ enɨ samɨŋɨ́ oweárɨnɨ.” rɨrɨ éáná apaxɨ́ mé rɨ́wɨpí samɨŋɨ́ werɨ iniɨgɨ́ enɨ samɨŋɨ́ werɨ yáráná ");
INSERT INTO aak_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","re urɨŋɨnigɨnɨ, “Soyɨ́né pí nánɨ wáyɨ́ seainarɨnɨ? Dɨŋɨ́ mɨnɨkwɨ́ropa nero nánɨ wáyɨ́ rɨseainarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","awa óɨ́ nikárɨnɨro nánɨ wigɨ́pɨ re rɨnɨgɨ́awixɨnɨ, “Pí ámáorɨ́anɨ? Imɨŋɨ́ tɨ́nɨ iniɨgɨ́ tɨ́nɨ o ráná arɨre ámánɨŋɨ́ arɨ́á nɨwirɨ samɨŋɨ́ rɨ́a weŋoɨ?” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nuro ipí yoɨ́ Gaririyo jɨ́arɨwámɨnɨ ámá wigɨ́ yoɨ́ Gegesayɨ́ aŋɨ́yo niwiékɨ́nɨmearo ");
INSERT INTO aak_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","o rɨxa ewéyo dánɨ ayoááná re eŋɨnigɨnɨ. Rɨxa ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́ wo ámá xwárɨpáyo dánɨ nɨweapɨrɨ Jisasomɨ nɨwímearɨ ");
INSERT INTO aak_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","—O ámá xwárɨpáyo anɨŋɨ́ e weagorɨnɨ. Ámá wí ainɨxɨ́ aí tɨ́nɨ aí gwɨ́ mɨjárɨpaxɨ́ yagɨ́orɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Íníná ainɨxɨ́ tɨ́nɨ gwɨ́ xaíwɨ́ wɨrí tɨ́nɨ sɨkwɨ́yo tɨ́nɨ wéyo tɨ́nɨ járarɨŋagɨ́a aiwɨ o narɨ́kiárɨmɨ wagorɨnɨ. Ámá wí eŋɨ́ neánɨro omɨ xayɨpemɨxɨpaxɨ́ yagɨ́omanɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xegɨ́pɨ anɨŋɨ́ xwárɨpáyo nɨŋwearɨ́ná ikwáwɨyíná árɨ́wɨyíná dɨ́wɨ́ tɨ́ŋɨ́ e dánɨ makɨrɨ́wɨ́ nɨmóa nurɨ sɨ́ŋá nɨmearɨ pɨ́rɨ́ nuyɨkíga wagorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","O Jisaso jɨ́amɨ barɨŋagɨ nɨwɨnɨrɨ mɨ́rɨ́ nɨwerɨ waunɨ́ nɨwikárɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisaso maŋɨ́ tɨ́nɨ “Ámá romɨ imɨ́oyɨ́né sɨnɨ dɨŋɨ́ mɨxɨxéropanɨ. Pɨ́nɨ wiárɨ́poyɨ.” urarɨŋagɨ o xwamiánɨ́ nɨwirɨ “Jisasoxɨ pí neaimɨnɨrɨ barɨŋɨnɨ?” nurɨrɨ “Gorɨxo ŋwɨ́á amɨpí nɨyonɨ seáyɨ e múroŋomɨ xewaxoxɨrɨnɨ. Waunɨ́ siarɨŋagwɨ nánɨ Gorɨxoyá sɨŋwɨ́yo dánɨ ‘Rɨ́nɨŋɨ́ wí seaiapɨmɨméɨnɨ.’ neareɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisaso yarɨŋɨ́ “Segɨ́ yoɨ́ pírɨnɨ?” wíáná imɨ́owa re urɨgɨ́awixɨnɨ, “None xwé obaxɨ́ mɨrónɨŋagwɨ nánɨ yoɨ́ Rijonɨyɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ mɨxɨ́ nánɨ xwé obaxɨ́ gwɨ́ mónarɨgɨ́á nánɨrɨnɨ. Yoɨ́ Rijonɨyɨ rɨnɨŋwɨnɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","waunɨ́ nɨwiro arɨ́kí “Xwɨ́á tɨ́yo dánɨ imɨ́one mɨxɨ́ mɨneamáɨnowárɨpanɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","odɨpí aga xwé obaxɨ́ bɨ dɨ́wɨ́ wíyo miaúrárɨ́ ninɨro aiwá narɨŋagɨ́a nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","waunɨ́ rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “Imɨ́one odɨpíyo rɨ́wɨ́mɨnɨ nɨrómáná dɨŋɨ́ oxɨxérópoyɨnɨrɨ sɨŋwɨ́ neaneɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisaso xe dɨŋɨ́ oxɨxérópoyɨnɨrɨ sɨŋwɨ́ wɨnáná imɨ́ó ámá omɨ dɨŋɨ́ xɨxérogɨ́ápɨ nɨmɨxearo ámɨ odɨpíyómɨnɨ xɨxéróáná re egɨ́awixɨnɨ. Pɨmaŋɨ́ éɨ́ roŋɨ́ wí e aŋɨ́nɨ wéɨ́áyɨ́ wiárɨ́ sɨwá nero anɨŋɨ́nɨ ipíyo nɨpiéroro pɨyɨ́ egɨ́awixɨnɨ. Odɨpí ayɨ́ wonɨ marɨ́áɨ, 2,000 pɨyɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","E éáná ámá odɨpí mearɨgɨ́áyɨ́ aŋɨ́nɨ nuro odɨpí éɨ́ápɨ nánɨ aŋɨ́ e ŋweagɨ́áyo áwaŋɨ́ nurárɨmɨ nuro omɨŋɨ́ tɨ́ŋɨ́ e yarɨgɨ́áyo enɨ áwaŋɨ́ nura eméáná ámá nɨ́nɨ “Pí rɨ́a eŋoɨ?” nɨyaiwiro sɨŋwɨ́ wɨnanɨro nuro ");
INSERT INTO aak_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jisaso tɨ́ŋɨ́ e nɨrémoro wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋo xegɨ́ yarɨŋɨ́pa mé dɨŋɨ́ sɨxɨ́ nínɨrɨ aikɨ́ nɨyínɨrɨ riwo éɨ́ ŋweaŋagɨ nɨwɨnɨro xámɨ imɨ́ó obaxɨ́ dɨŋɨ́ xɨxérogɨ́á nánɨ “Nepa imɨ́ó xɨxéroago orɨ́anɨ?” nɨyaiwiro wáyɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ámá Jisaso imɨ́ó mɨxɨ́ umáɨnowárɨ́agɨ wɨnɨ́áyɨ́ repɨyɨ́ nɨwiro imɨ́ó sayá meago éɨ́pɨ nánɨ tɨ́nɨ odɨpí éɨ́ápɨ nánɨ tɨ́nɨ repɨyɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jisasomɨ waunɨ́ nɨwiro re urɨgɨ́awixɨnɨ, “Negɨ́ xwɨ́á re pɨ́nɨ nɨneawiárɨmɨ uɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","o rɨxa ewéyo pɨxemoánɨmɨnɨrɨ yarɨ́ná imɨ́ó dɨŋɨ́ xɨxéróɨ́o waunɨ́ nurɨrɨ “Nionɨ enɨ joxɨ tɨ́nɨ wanɨ́wiɨ.” urarɨŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisaso nionɨ tɨ́nɨ xe ounɨrɨ sɨŋwɨ́ mɨwɨnɨpa nerɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ aŋɨ́ e nánɨ nurɨ dɨxɨ́ ámáyo Ámɨnáonɨ ayá nɨrɨrɨmɨxɨrɨ síápɨ nánɨ áwaŋɨ́ nura úɨrɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","o nurɨ aŋɨ́ Dekaporisɨyo apɨ apɨ nikwɨ́róga unɨŋɨ́yo áwaŋɨ́ nura nemerɨ amɨpí Jisaso wíɨ́pɨ nánɨ áwaŋɨ́ nura emearɨ́ná ámá nɨ́nɨ dɨŋɨ́ ududɨ́ nɨwinɨrɨ “Arɨge nerɨ naŋɨ́ éorɨ́anɨ?” yaiwiagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ ámɨ ewéyo núɨ́asáná ipíyo jɨ́arɨwámɨnɨ niwiékɨ́nɨmearo ewéyo dánɨ nayoaro ipí tɨ́ŋɨ́ aŋwɨ e roŋáná ámá obaxɨ́ nɨbɨro Jisaso tɨ́ŋɨ́ e epɨ́royɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ámá wo —O Judayɨ́yá rotú aŋɨ́ wíyo ámɨnáo nimónɨrɨ meŋweaŋorɨnɨ. Xegɨ́ yoɨ́ Jairasoyɨ rɨnɨŋorɨnɨ. O nɨbɨrɨ Jisasomɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná oyá sɨkwɨ́ tɨ́ŋɨ́ aŋwɨ e mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ waunɨ́ nɨwikárɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","waunɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Gɨ́ miáí rɨxa aŋwɨ ayo nɨpepaxɨ́ enɨ. Í naŋɨ́ nerɨ sɨŋɨ́ unɨ nánɨ joxɨ nɨbɨrɨ wé seáyɨ e ikwiáreɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisaso o tɨ́nɨ nawínɨ úáná ámá nɨ́nɨ nɨxɨ́dɨro ɨkwɨkwierɨ́ warɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Apɨxɨ́ wí —Í xegɨ́ ragɨ́ anɨŋɨ́ pwarɨ́ná xwiogwɨ́ wé wúkaú sɨkwɨ́ waú múroŋírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Í naŋɨ́ onimɨxɨ́poyɨnɨrɨ xwɨrɨ́ obaxɨ́yo nɨgwɨ́ ayá wí nɨroaayirɨ mɨnɨ nɨwirɨ aí rɨ́nɨŋɨ́ winarɨŋɨ́pɨ naŋɨ́ bɨ onɨmiápɨ mé nɨyɨpeí yarɨŋɨ́rɨnɨ. Xegɨ́ nɨgwɨ́ anɨpá imónɨŋagɨ aí ámɨ wínɨ mɨxɨ́nɨŋɨ́ yomɨxarɨgɨ́írɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Í Jisaso nánɨ arɨ́á nɨwirɨ́ná “Oyá iyɨ́áyo aí amáɨ́ nɨrónɨrɨ́náyɨ́ ámɨ naŋɨ́ emɨ́ɨnɨ.” nɨyaiwia nɨbɨrɨ ámá epɨ́royɨ́ egɨ́áyo áwɨnɨ e nɨdakwirɨ rɨ́wɨ́mɨ dánɨ wé ɨ́eapá nerɨ oyá iyɨ́á amáɨ́ rónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amáɨ́ rónáná ragɨ́ anɨŋɨ́ pwarɨŋɨ́pɨ yeáyɨ́ sɨkiárɨŋɨnigɨnɨ. Ragɨ́ yeáyɨ́ sɨkiárɨ́agɨ nainenɨrɨ re yaiwiŋɨnigɨnɨ, “Rɨxa naŋɨ́ riyínɨ réɨnɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisaso nɨjɨ́á nimónɨrɨ “Eŋɨ́ eánɨŋɨ́ nionɨyá bɨ nɨnowárɨmɨ ipɨ ruŋoɨ?” nɨyaiwirɨ nɨkɨnɨmónɨrɨ re rɨŋɨnigɨnɨ, “Gɨ́ iyɨ́áyo amáɨ́ go rónɨgoɨ?” ráná ");
INSERT INTO aak_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","xegɨ́ wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Joxɨ ámá epɨ́royɨ́ nɨsiro ɨkwɨkwierɨ́ nɨsiga warɨ́ná pí nánɨ ‘Go gɨ́ iyɨ́áyo amáɨ́ nɨrónɨgoɨ?’ rarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","apɨxɨ́ e wíímɨ sɨŋwɨ́ wɨnɨmɨnɨrɨ nánɨ sagagɨ́ emearɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","í “Jisaso píránɨŋɨ́ nimɨxɨ́ɨ́rɨnɨ.” nɨyaiwirɨ wáyɨ́ nerɨ eŋɨ́ óɨ́ néra nɨbɨrɨ Jisasomɨ agwɨ́rɨwámɨnɨ waunɨ́ nɨwikárɨnɨrɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ xɨ́í éɨ́pɨ nánɨ wɨ́á rókiamónɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisaso re urɨŋɨnigɨnɨ, “Ineyɨ, jíxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨŋɨ́pimɨ dánɨ erɨ́kiemeánɨ́ɨnɨ. Sɨmɨxɨ́ ayá sinarɨŋɨ́pɨ ámɨ wí sinɨnɨ́á meŋagɨ nánɨ ámɨ ayá bɨ mɨsinɨ́ kikiɨ́á néra uɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","sɨnɨ ímɨ e urarɨ́ná sɨnɨ miáí sɨmɨxɨ́ weŋe mɨrémopa nerɨ́ná ámá wí rotú aŋɨ́ meweŋoyá aŋɨ́ e dánɨ nɨbɨro Jisaso nánɨ re urémeagɨ́awixɨnɨ, “Nearéwapɨyarɨŋomɨ sɨnɨ ayá wí murɨŋweapanɨ. Dɨxɨ́ miáí rɨxa peŋoɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisaso arɨ́á e nɨwirɨ rotú aŋɨ́ meweŋomɨ re urɨŋɨnigɨnɨ, “E nerɨ aiwɨ wáyɨ́ mepanɨ. Dɨŋɨ́nɨ nɨnɨkwɨ́róa uɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ámá nɨ́nɨ e nurakioŋwɨrárɨmáná aiwɨ “Pitao tɨ́nɨ Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ awa nionɨ tɨ́nɨ xe obɨ́poyɨnɨrɨ sɨŋwɨ́ owɨnɨmɨnɨ.” nɨyaiwirɨ nuro ");
INSERT INTO aak_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","rotú aŋɨ́ meweŋoyá aŋɨ́ e nɨrémoro Jisaso yaiwínɨŋɨ́ ninɨrɨ rɨnarɨŋagɨ arɨ́á nɨwirɨ wí yeyɨ nɨra warɨ́ná wí ŋwapé rarɨŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","aŋɨ́yo nɨpáwirɨ re urɨŋɨnigɨnɨ, “Pí nánɨ ŋwɨ́ earo yeyɨ rɨro yarɨŋoɨ? Miáí rɨxa peŋoɨnɨrɨ ŋwɨ́ rɨmiearɨŋoɨ? Í sa sá wenɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","rɨpɨ́á nura warɨ́ná o ámá nɨ́nɨ emɨ mɨmɨxeámɨ́ nerɨ miáímɨ xanɨyaú tɨ́nɨ omɨ kumɨxɨnarɨgɨ́á waú wo awa tɨ́nɨ aŋɨ́ awawá ikwɨ́rónɨŋɨ́ miáí weŋɨ́wámɨ nɨpáwiro ");
INSERT INTO aak_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisaso miáímɨ wéyo ɨ́á nɨmaxɨrɨrɨ xegɨ́ pɨ́né tɨ́nɨ “Tarita kumi.” nurɨrɨ —Ayɨ́ agapɨ́né “Miá ríyɨ wiápɨ́nɨmeaɨ.” urarɨŋwápɨ nánɨrɨnɨ. E uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Í rɨxa nɨwiápɨ́nɨmearɨ xegɨ́ xwiogwɨ́ wé wúkaú sɨkwɨ́ waú eŋagɨ nánɨ rɨxa nɨwiápɨ́nɨmearɨ aŋɨ́ yarɨ́ná ayɨ́ sɨrɨ́ nɨpɨkínɨro “Arɨge ámɨ rɨ́a wiápɨ́nɨmeaŋoɨ?” nɨyaiwiro ududɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisaso ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Nionɨ éápɨ ámá wíyo áwaŋɨ́ murɨpa épiyɨ.” nurɨrɨ “Ímɨ aiwá bɨ mɨnɨ wípiyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisaso aŋɨ́ e pɨ́nɨ nɨwiárɨmɨ úáná xegɨ́ wiepɨsarɨŋowa nɨxɨ́da nuro o tɨ́nɨ xegɨ́ aŋɨ́ e nɨrémoro nɨŋweagɨ́asáná ");
INSERT INTO aak_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","rɨxa Sabarɨ́á imónɨŋáná o nurɨ rotú aŋɨ́yo nɨpáwirɨ xwɨyɨ́á Gorɨxoyá uréwapɨyarɨ́ná ámá arɨ́á wíɨ́áyɨ́ sɨrɨ́ nɨpɨkínɨro xwioxɨ́yo dánɨ rɨ́á nɨwóróa nuro re rɨnɨgɨ́awixɨnɨ, “Ro xwɨyɨ́á apɨ ge rɨ́a nɨjɨ́á imónɨgoɨ? Nɨjɨ́á oyá pí nɨjɨ́ápɨ rɨ́a neaíwapɨyarɨnɨ? Emɨmɨ́ o yarɨŋɨ́pɨ arɨge nɨjɨ́á imónɨŋɨ́rɨnɨ? Oweoɨ, re dáŋorɨnɨ. Nenénɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ámá ro xegɨ́ omɨŋɨ́ sa aŋɨ́ mɨrarɨŋorɨnɨ. Sa Mariaí xewaxorɨnɨ. Xegɨ́ xexɨrɨ́meáowa wigɨ́ yoɨ́ Jemiso tɨ́nɨ Josiso tɨ́nɨ Judaso tɨ́nɨ Saimono tɨ́nɨrɨnɨ. Xexɨrɨ́meáíwa nene tɨ́nɨ enɨ nawínɨ mɨŋweapa reŋoɨ? Arɨge nimónɨrɨ nearéwapɨyarɨnɨ?” nɨrɨga nuro “Arɨ́á mɨwipanɨ.” nɨrɨnɨro wigɨ́ xwioxɨ́yo dánɨ wikɨ́ nɨwóga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisaso xewanɨŋo nánɨ nurɨrɨ́ná wigɨ́ rarɨgɨ́ápɨ tɨ́nɨ xɨxenɨ re urɨŋɨnigɨnɨ, “Ámá aŋɨ́ mɨdáŋɨ́yɨ́ Gorɨxoyá wɨ́á urókiamoarɨgɨ́áyo arɨ́á umónarɨgɨ́á aí wigɨ́ e dáŋɨ́yɨ́ tɨ́nɨ xexɨrɨ́meáyɨ́ tɨ́nɨ ‘Sa negɨ́ ámáorɨnɨ.’ nɨrɨnɨro arɨ́á umónarɨgɨ́ámanɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","e emɨmɨ́ mɨwíwapɨyipaxɨ́ eŋagɨ aí ámá sɨmɨxɨ́ yarɨgɨ́á wíyonɨ wé seáyɨ e nɨwikwiárɨrɨ naŋɨ́ imɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E nerɨ́ná o ayɨ́ dɨŋɨ́ mɨwɨkwɨ́ropa nero arɨ́á mumónarɨŋagɨ́a nánɨ ududɨ́ winɨŋɨnigɨnɨ. O aŋɨ́ apɨ apɨ ikwɨ́rónɨŋɨ́ wíyɨ́ wíyonɨ nemerɨ xwɨyɨ́á Gorɨxoyá nuréwapɨya nemerɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","xegɨ́ wiepɨsarɨŋowa wé wúkaú sɨkwɨ́ waú awamɨ “Awí eánɨ́poyɨ.” nurɨrɨ waú waú xɨxegɨ́nɨ upɨ́rɨ nánɨ nɨkumɨxɨrɨ nɨwárɨrɨ́ná imɨ́óyo mɨxɨ́ umáɨnowárɨpɨ́rɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ bɨ xɨxegɨ́nɨ eŋɨ́ sɨxɨ́ neámɨxowárɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Wagwí wagwí aŋɨ́ wíyɨ́ wíyo wáɨ́ nemero ‘Gorɨxoyá xwioxɨ́yo ŋweanɨ́wá aŋwɨ ayo eŋagɨ nánɨ seyɨ́né uyɨ́niɨ́ néra warɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.’ nurɨrɨ́ná amɨpí wí nɨmeámɨ mupanɨ. Aiwá bɨranɨ, árupiaŋɨ́ wúranɨ, nɨgwɨ́ wowɨ́ bɨranɨ, bɨ nɨmeámɨ mupanɨ. Xoyɨ́wánɨ eraŋɨ́ nurɨga úpoyɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sɨkwɨ́ sú nɨyínɨro aiwɨ iyɨ́á wúkaú mɨpánɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wagwí wagwí aŋɨ́ wí e nɨrémorɨ́ná ámá wo ‘Awagwí ananɨ nɨ́wiapɨri sá wépiyɨ.’ earɨ́o o tɨ́nɨnɨ sá nɨwémɨ úisixɨnɨ. Sɨnɨ aŋɨ́ e ikwɨ́rónɨŋɨ́pimɨ nuréwapɨyirɨ́ná aŋɨ́ axiwámɨnɨ sá wéɨ́rɨxɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","re urɨŋɨnigɨnɨ, “Aŋɨ́ bimɨ soyɨ́né nɨseaipemeámɨ mupa ero arɨ́á mɨseaipa ero éánáyɨ́, aŋɨ́ apimɨ rɨxa pɨ́nɨ nɨwiárɨmɨ nurɨ́ná sɨkwɨ́ sú nɨwirɨro xwɨ́á sikɨ́ yeáyɨ́ xénɨŋɨ́pɨ pɨ́rɨ́ nɨwiaíkiárɨmɨ úɨ́rɨxɨnɨ. Ámá aŋɨ́ apimɨ ŋweáyɨ́ dɨŋɨ́ re yaiwipɨ́rɨ ‘Newanɨŋene ikárɨnɨŋwáyɨ́ nánɨ awaú Gorɨxo nene nánɨ xwɨrɨ́á winɨnɨ nánɨ iyɨ́ rɨyárɨ́iɨ?’ yaiwipɨ́rɨ nánɨ xwɨ́á sikɨ́ sɨkwɨ́yo xénɨŋɨ́pɨ pɨ́rɨ́ wiaíkiárɨ́ɨ́rɨxɨnɨ.” Sekaxɨ́ e urowáráná ");
INSERT INTO aak_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","wiepɨsarɨŋowa waú waú nɨkumɨxɨnɨmɨ numiro wáɨ́ nura nemeróná repɨyɨ́ re wigɨ́awixɨnɨ, “Seyɨ́né uyɨ́niɨ́ néra warɨgɨ́ápɨ emɨ nɨmoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.” repɨyɨ́ e nurɨro ");
INSERT INTO aak_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ámá obaxɨ́yo imɨ́ó rɨ́wɨ́yo nɨrómáná dɨŋɨ́ xɨxéroarɨŋɨ́pɨ mɨxɨ́ numáɨnowára nuro ámá obaxɨ́ sɨmɨxɨ́ wiarɨŋɨ́yo enɨ ranɨ́ tɨ́nɨ gɨ́niɨ́ nɨwiro naŋɨ́ nimɨxa ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mɨxɨ́ ináyɨ́ Xerotoyɨ rɨnɨŋo Jisasoyá wiepɨsarɨŋowa e néra emearɨ́ná aŋɨ́ nɨyonɨ “Jisaso e yarɨnɨ. E yarɨnɨ.” rɨnarɨŋagɨ́a o arɨ́á nɨwirɨ ŋweaŋáná ámá wí emɨmɨ́ Jisaso yarɨŋɨ́pɨ nánɨ re nɨrɨga ugɨ́awixɨnɨ, “Jono wayɨ́ nɨneameaia wago peŋo ámɨ nɨwiápɨ́nɨmearɨ Jisaso nimónɨrɨ nánɨ emɨmɨ́ apɨ rɨ́a éwapɨ́narɨnɨ?” e nɨrɨga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ámá wí re nɨrɨga ugɨ́awixɨnɨ, “Iraijao —O xwɨyɨ́á Gorɨxoyá wɨ́á nearókiamoagɨ́á wo sɨnɨ mɨpé yarɨ́ná Gorɨxo nɨwirɨmeámɨ aŋɨ́namɨ nánɨ peyiŋorɨnɨ. O nɨwepɨ́nɨrɨ emɨmɨ́ apɨ rɨ́a yarɨnɨ?” nɨrɨga warɨ́ná ámá wí re nɨrɨga ugɨ́awixɨnɨ, “Gorɨxoyá xwɨyɨ́á eŋíná wɨ́á nearókiamoagɨ́ánɨŋɨ́ imónɨŋɨ́ wo rɨ́anɨ?” nɨrɨga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","mɨxɨ́ ináyɨ́ Xeroto ámá Jisaso nánɨ xwɨyɨ́á xɨxegɨ́nɨ nɨra warɨŋagɨ́a arɨ́á nɨwirɨ aiwɨ re rayiŋɨnigɨnɨ, “Jono wayɨ́ numeaia wago, nionɨ siŋwɨ́ mɨŋɨ́ wákwiŋáo rɨxa nɨwiápɨ́nɨmearɨ emɨmɨ́ apɨ yarɨnɨ.” rayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Pí nánɨ? Ayɨ́ rɨpɨ nánɨrɨnɨ. Xámɨ o xegɨ́ xexɨrɨ́meáo Piripoyɨ rɨnɨŋoyá apɨxɨ́ Xerodiasíyɨ rɨnɨŋí nurápɨrɨ nɨmearɨ ŋweaŋáná Jono re urayiŋɨnigɨnɨ, “Joxɨ dɨxɨ́ rɨrɨxɨ́meáo xiepí nurápɨrɨ nɨmearɨ́náyɨ́ ‘Nɨpɨkwɨnɨ eŋárɨnɨ?’ rɨsimónarɨnɨ?” urayarɨŋagɨ mɨxɨ́ ináyɨ́ Xeroto ámá wíyo “Jonomɨ ɨ́á xépoyɨ.” urowáráná awa nuro Jonomɨ ɨ́á nɨxero gwɨ́ nɨyiro nɨmeámɨ nɨbɨro kɨrapusɨ́ aŋɨ́yo wáráná ");
INSERT INTO aak_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","mɨxɨ́ ináyɨ́ Xerotomɨ xiepí Xerodiasí Jono nánɨ sɨ́mɨ́ xwaŋwɨ́ níkwónɨrɨ arɨ́kí “Rɨxa opɨkípoyɨ.” rarɨŋagɨ aí Xeroto “Jono ámá wé rónɨŋorɨnɨ. Ámá ŋwɨ́á Gorɨxo urowárénapɨŋorɨ́anɨ?” nɨyaiwirɨ wáyɨ́ winarɨŋagɨ nánɨ xiepímɨ pɨ́rɨ́ nurakirɨ Jonomɨ kɨrapusɨ́ aŋɨ́yo nɨwárɨrɨ aiwɨ omɨ e dánɨ éɨ́ numínɨrɨ nɨŋwearɨ́ná pɨ́né Jonoyá arɨ́á wimɨnɨrɨ nánɨ nɨwimónɨrɨ “O nepa nɨrarɨnɨ.” nɨyaiwirɨ aí apɨxí nánɨ wimónarɨŋagɨ nánɨ dɨŋɨ́ ududɨ́ nɨwinɨrɨ “Arɨ emɨ́ɨnɨ?” nɨyaiwirɨ nɨŋweaŋɨsáná ");
INSERT INTO aak_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","sɨ́á xɨnáí xɨrɨŋɨ́yi imónáná Xerodiasí o aiwá xwé rɨyamɨ́ nɨyárɨmáná ámá ámɨná Gariri pɨropenɨsɨ́yo meŋweagɨ́áwamɨ tɨ́nɨ o xegɨ́ sɨmɨŋɨ́ wínarɨgɨ́á xɨráónɨŋɨ́ imónɨgɨ́áwamɨ tɨ́nɨ o xegɨ́ gapɨmanowamɨ tɨ́nɨ wáɨ́ urepeárɨ́agɨ í sɨŋwɨ́ e nɨwɨnɨrɨ re yaiwiŋɨnigɨnɨ, “Rɨxa gɨ́ oxomɨ yapɨ́ wíwapɨyíáná xewanɨŋo Jonomɨ nɨpɨkinɨŋoɨ.” nɨyaiwirɨ Xeroto tɨ́nɨ ámáowa tɨ́nɨ rɨxa awí neánɨro aiwá narɨ́ná í xegɨ́ xemiáímɨ re urowárɨŋɨnigɨnɨ, “Jíxɨ ápo tɨ́ŋɨ́ e nánɨ nurɨ sɨmɨnɨŋɨ́ eɨ.” urowáráná ");
INSERT INTO aak_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","í nɨpáwirɨ sɨmɨnɨŋɨ́ yarɨ́ná mɨxɨ́ ináyɨ́ Xeroto tɨ́nɨ ámá o tɨ́nɨ aiwá narɨgɨ́áwa tɨ́nɨ sɨmɨnɨŋɨ́ í yarɨŋɨ́pɨ nánɨ yayɨ́ nɨwinɨrɨ nánɨ Xeroto ímɨ re urɨŋɨnigɨnɨ, “Jíxɨ pí pí nánɨ simónɨ́ɨ́pɨ nánɨ yarɨŋɨ́ níáná ananɨ siapɨmɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ámɨ xwɨ́á e dánɨ re urɨŋɨnigɨnɨ, “Jíxɨ xwɨ́á nionɨ meŋweaŋápɨ nánɨ ‘Áwɨnɨ e nepayorɨ mɨdánɨ niapeɨ.’ nɨránáyɨ́ ananɨ nɨsiapɨmɨ́ɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","í nɨpeyearɨ xɨnáímɨ re urɨŋɨnigɨnɨ, “Inóke, pí nánɨ yarɨŋɨ́ wimɨnɨréɨnɨ?” uráná xɨnáí re urɨŋɨnigɨnɨ, “Jono wayɨ́ numeaia warɨŋo nánɨ ‘Siŋwɨ́ mɨŋɨ́ nɨwákwirɨ niapeɨ.’ ureɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","xemiáí ámɨ mɨ́rɨ́ nɨpáwirɨ mɨxɨ́ ináyomɨ re urɨŋɨnigɨnɨ, “Niínɨ re nimónarɨnɨ, ‘Aŋɨ́nɨ Jono wayɨ́ numeaia warɨŋomɨ siŋwɨ́ mɨŋɨ́ nɨwákwirɨ mɨŋo pɨrerɨxɨ́ wɨnamɨ nikwiárɨrɨ nɨmeámɨ nɨbɨrɨ niapeɨ.’ nimónarɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","o Jono nánɨ dɨŋɨ́ sɨpí nɨwirɨ aiwɨ miáímɨ xwɨ́á e dánɨ ámá o tɨ́nɨ aiwá narɨgɨ́áwa arɨ́á eŋáná urɨŋɨ́pɨ nánɨ ayá nɨwinɨrɨ “Oweoɨ.” murɨpaxɨ́ nɨwimónɨrɨ re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Xegɨ́ sɨmɨŋɨ́ wínarɨŋɨ́ womɨ sekaxɨ́ re urowárɨŋɨnigɨnɨ, “Jonomɨ siŋwɨ́ mɨŋɨ́ nɨwákwirɨ nɨmeámɨ beɨ.” urowáráná o nurɨ kɨrapusɨ́ aŋɨ́yo nɨpáwirɨ e siŋwɨ́ mɨŋɨ́ nɨwákwirɨ pɨrerɨxɨ́yo nikwiárɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nɨmeámɨ nɨbɨrɨ miáímɨ mɨnɨ wíáná í nurápɨmɨ nurɨ xɨnáímɨ mɨnɨ wíáná í “Rɨxa riwo rɨpɨkíoɨ?” yaiwiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","E éáná Jonoyá wiepɨsarɨŋowa arɨ́á nɨwiro náonɨ nɨménapɨro nɨmeámɨ nuro xwɨ́á weyárɨgɨ́awixɨnɨ. Xeroto Jonomɨ pɨkiŋɨ́ eŋagɨ nánɨ Jisaso rɨ́wɨ́yo emɨmɨ́ yarɨ́ná o re yaiwiagɨ́rɨnɨ, “Nionɨ Jono wayɨ́ numeaia wago siŋwɨ́ mɨŋɨ́ wákwiŋáo nɨwiápɨ́nɨmearɨ ámá Jisasoyɨ rɨnɨŋo nimónɨrɨ emɨmɨ́ rɨ́a yarɨnɨ?” yaiwiagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","E yaiwiarɨ́ná ámá Jisaso wáɨ́ urowárɨŋowa ámɨ nɨbɨro o tɨ́nɨ nerɨmeánɨro aŋɨ́ apɨ apimɨ wa emegɨ́ápɨ nánɨ omɨ repɨyɨ́ wiro xwɨyɨ́á amɨpí wa nuréwapɨya emegɨ́ápɨ nánɨ repɨyɨ́ wiro néɨsáná ");
INSERT INTO aak_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jisaso ámá obaxɨ́ omɨ sɨŋwɨ́ wɨnanɨro nánɨ bɨrɨ uro yayarɨŋagɨ́a xɨ́o tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ aiwá mɨnɨpaxɨ́ wiarɨŋagɨ nánɨ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Nonenɨ ámá dɨŋɨ́ meaŋe nánɨ nurane kikiɨ́á bɨ oŋweaaneyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ewéyo nɨpɨxemoánɨro wigɨ́pɨ ámá dɨŋɨ́ meaŋe nánɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ámá wí aŋɨ́ nɨyonɨ dánɨ wenɨŋɨ́ éɨ́áyɨ́ awa ewéyo pwarɨŋagɨ́a nɨwɨnɨro mí nómɨxɨro aŋɨ́nɨ xwɨ́áyo nuro xámɨ nɨrémoro ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisaso rɨ́wɨ́yo nɨrémorɨ ewéyo dánɨ nayoarɨ ámá xwé ayá wí epɨ́royɨ́ yárɨŋagɨ́a nɨwɨnɨrɨ ámá ayɨ́ sipɨsipɨ́ xiáwo mayɨ́nɨŋɨ́ nimónɨro píránɨŋɨ́ mɨŋweapaxɨ́ imónɨŋagɨ́a nɨwɨnɨrɨ nánɨ ayá nɨrɨmɨxɨrɨ amɨpí obaxɨ́ nánɨ nuréwapɨya nurɨ ");
INSERT INTO aak_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","nuréwapɨya núɨsáná eŋáná sɨ́ápɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋowa aŋwɨ e nɨbɨro re urɨgɨ́awixɨnɨ, “Rɨxa sɨ́árɨnɨ. Re aŋɨ́ wí mayɨ́ e eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ámá aŋɨ́ amɨ amɨ mɨrɨnɨŋɨ́yo nánɨ numiro aiwá bɨ́ nero nɨpɨ́rɨ nánɨ urowárapeɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisaso re urɨŋɨnigɨnɨ, “Aiwá nɨpɨ́rɨ nánɨ sewanɨŋoyɨ́né mɨnɨ wípoyɨ.” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “Aiwá mɨnɨ wianɨ nánɨ nurane bisɨ́kerɨ́á (Aiwá nɨ́nɨ nánɨ nɨrɨrɨ́ná Judayɨ́ bisɨ́kerɨ́áɨ ragɨ́árɨnɨ.) bisɨ́kerɨ́á nánɨ bɨ́ neranéná óɨ́ inɨŋɨ́ 200 mɨnɨ nɨwirane urápanɨréwɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","o re urɨŋɨnigɨnɨ, “Bisɨ́kerɨ́á ararɨ tɨ́gɨ́oyɨ́nérɨnɨ? Sɨŋwɨ́ wɨnaúpoyɨ.” uráná awa sɨŋwɨ́ nɨwɨnaumɨ nɨbɨro “Bisɨ́kerɨ́á wé wú núnɨ eŋáná peyɨ́ ná waúnɨrɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","o awamɨ “Ámá nɨyonɨ sekaxɨ́ re urɨ́poyɨ, ‘Aráyo miaúrárɨ́ niga uro éɨ́ nɨŋweaxa uro époyɨ.’ urɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ayɨ́ miaúrárɨ́ niga nurɨ́ná wí ámá 50 miaúrárɨ́ inɨro wí ámá 100 miaúrárɨ́ inɨro néra úáná ");
INSERT INTO aak_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisaso re eŋɨnigɨnɨ. Bisɨ́kerɨ́á wé wú núnɨ eŋɨ́pɨ nɨmearɨ peyɨ́ waúnɨ eŋɨ́waú enɨ nɨmearɨ sɨŋwɨ́ aŋɨ́namɨ nanánɨrɨ́ná Gorɨxomɨ aiwápɨ nánɨ yayɨ́ nɨwimáná kɨkwɨrɨmɨ́ néra nurɨ xegɨ́ wiepɨsarɨŋowa yaŋɨ́ wipɨ́rɨ nánɨ mɨnɨ nɨwiayirɨ peyɨ́waú enɨ nororɨ mɨnɨ wiayarɨ́ná wiepɨsarɨŋowa nurápayiro yaŋɨ́ nɨwia nuro ");
INSERT INTO aak_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ámá nɨ́nɨ nɨnɨro agwɨ́ ímɨ uyíagɨ ");
INSERT INTO aak_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kwɨkwɨrɨmɨ́ inɨŋɨ́ e tɨ́ápɨ nɨmeamero peyɨ́ ororómɨ́ inɨŋɨ́ e tɨ́ápɨ enɨ nɨmeamero soxɨ́ ɨ́á wé wúkaú sɨkwɨ́ waúmɨ aumaúmɨ́ nero nɨ́nɨ magwɨ́ miárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ámá oxɨ́ aiwá apɨ nɨgɨ́áwa nɨ́nɨ ayɨ́ ámá 5,000 nɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Jisaso, ayɨ́ aiwá nɨnɨro nemáná, o wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né ewéyo nɨpɨxemoánɨro ipíyo jɨ́arɨwámɨnɨ aŋɨ́ yoɨ́ Betɨsaida nánɨ xámɨ nɨmeápoyɨ.” nurɨrɨ awa rɨxa úáná ámá e epɨ́royɨ́ egɨ́áyo yayɨ́ nɨwirɨ xɨxegɨ́nɨ nurowárapɨmáná Gorɨxomɨ xwɨyɨ́á urɨnɨ nánɨ dɨ́wɨ́yo nɨyirɨ nɨŋweaŋɨsáná ");
INSERT INTO aak_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","árɨ́wɨyimɨ wiepɨsarɨŋowa sɨnɨ ipíyo áwɨnɨ e ewé nɨmeámɨ warɨ́ná xɨ́o sɨnɨ jɨ́e xwɨ́áyo nɨrómáná ");
INSERT INTO aak_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","wɨnɨŋɨnigɨnɨ. Awa eŋɨ́ tɨ́nɨ reaarɨŋagɨ́a aiwɨ imɨŋɨ́ xwé sɨ́mɨ́mɨnɨ nɨxemɨ barɨŋagɨ nánɨ ewé aŋɨ́nɨ mɨyarɨŋagɨ nɨwɨnɨrɨ ipíyo xwɨ́áyónɨŋɨ́ nosaxa nurɨ rɨxa isɨ́á yinɨŋáná xegɨ́ wiepɨsarɨŋowamɨ múrómɨnɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","nowanɨ wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. O ipíyo nosaxa warɨŋagɨ nɨwɨnɨro “Pɨyɨŋɨ́ siwí wo rɨ́a pwarɨnɨ?” nɨyaiwiro óɨ́ nikárɨnɨro “Yeyɨ!” nɨrɨro wáyɨ́ ayɨkwɨ́ mɨwinarɨ́ná o rɨxa xwɨyɨ́á nurɨrɨ re urɨŋɨnigɨnɨ, “Wáyɨ́ mepanɨ. Nionɨrɨnɨ. Dɨŋɨ́ sɨxɨ́ nínɨro eŋɨ́ neánɨro ŋweápoyɨ. Ananɨrɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","awamɨ nɨwímearɨ ewéyo pɨxemoánáná re eŋɨnigɨnɨ. Imɨŋɨ́ enɨ rɨxa pɨ́nɨ wiárɨ́agɨ sɨŋwɨ́ e nɨwɨnɨro dɨŋɨ́ “Imɨŋɨ́ axínánɨ pí nánɨ pɨ́nɨ rɨ́a wiárɨŋoɨ?” dɨŋɨ́ e nɨpɨkínɨro ududɨ́ néra nuro ");
INSERT INTO aak_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisaso xámɨ aiwá kwɨkwɨrɨmɨ́ yarɨŋagɨ nɨwɨnɨro aiwɨ dɨŋɨ́ wakɨsɨ́ ninɨrɨŋɨ́pimɨ dánɨ oyá eŋɨ́ eánɨŋɨ́ mí mómɨxɨ́ éɨ́á nánɨ sɨnɨ o nánɨ dɨŋɨ́ ududɨ́ néra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dɨŋɨ́ ududɨ́ néra warɨ́ná rɨxa ipíyo jɨ́arɨwámɨnɨ imaŋɨ́ e niwiékɨ́nɨmearo ");
INSERT INTO aak_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ewéyo dánɨ nayoaro gwɨ́ yurárarɨ́ná ámá wí Jisasomɨ rɨxa sɨŋwɨ́ mí nómɨxɨro ");
INSERT INTO aak_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aŋaŋɨ́nɨ ámá sɨmɨxɨ́ wegɨ́áyɨ́ nánɨ aŋɨ́ ayɨ́ ayo nánɨ numiamoro sɨmɨxɨ́yɨ́ íkwiaŋwɨ́yo nikwiárɨro “Jisaso e ŋweanɨ.” rɨnɨ́e nánɨ nɨmeámɨ nɨbɨro ");
INSERT INTO aak_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","o aŋɨ́ onɨmiá bɨ bimɨranɨ, aŋɨ́ xwé bɨ bimɨranɨ, omɨŋɨ́ inɨŋeranɨ, pwarɨŋagɨ nɨwɨnɨro sɨmɨxɨ́yɨ́ nɨmeámɨ nɨbɨro makerɨ́á imɨxarɨgɨ́e táná ámá sɨmɨxɨ́ gɨyɨ́ oyá rapɨrapɨ́ yínɨŋú sírɨ́wɨ́ mɨ́de amáɨ́ rónanɨro nánɨ waunɨ́ rɨxɨŋɨ́ nurɨro rapɨrapɨ́ sírɨ́wɨ́yo amáɨ́ nɨrónɨrɨ́ná nɨ́nɨ axíná naŋɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Parisi wa tɨ́nɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa tɨ́nɨ, Jisaso sɨnɨ Gariri pɨropenɨsɨ́yo ŋweaŋáná, awa Jerusaremɨ dánɨ nɨbɨro Jisasoyá wiepɨsarɨŋowa wigɨ́ Judayɨ́ xiáwowa yagɨ́ápa mé aiwá nɨnɨróná xámɨ wé igwɨ́á mɨwíró wé piaxɨ́ weaŋáná aiwá narɨŋagɨ́a nɨwɨnɨro Jisaso tɨ́ŋɨ́ e axɨ́ e awí neánárɨro ");
INSERT INTO aak_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","—Parisiowa tɨ́nɨ wigɨ́ Judayɨ́ nɨ́nɨ tɨ́nɨ nene piaxɨ́ neaeanɨgɨnɨrɨ wigɨ́ xiáwowa yagɨ́ápɨ aiwá nɨnɨróná xámɨ píránɨŋɨ́ wé igwɨ́á wímoarɨgɨ́árɨnɨ. Ayɨ́ makerɨ́áyo nánɨ nuro aiwá bɨ́ nemɨ aŋɨ́ e nánɨ nɨbɨróná enɨ piaxɨ́ neaeanɨgɨnɨrɨ igɨ́á meánɨpa nerɨ́ná aiwá mɨnarɨgɨ́árɨnɨ. Xiáwowa érowiápɨ́nɨgɨ́áyɨ́ anɨŋɨ́ minɨ́ ɨ́á nɨmaxɨrɨro nɨxɨ́dɨro sɨnɨ axɨ́pɨ nero kapɨxɨ́ tɨ́nɨ xwárɨ́á sɨxɨ́ tɨ́nɨ suyupenɨxɨ́ tɨ́nɨ íkwiaŋwɨ́ sá wearɨgɨ́ápɨ tɨ́nɨ igɨ́á eaagɨ́ápa axɨ́pɨ igɨ́á eaarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisiowa tɨ́nɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Jisaso tɨ́ŋɨ́ e axɨ́ e awí neánárɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Dɨxɨ́ wiepɨsarɨŋowa pí nánɨ negɨ́ arɨ́owa nero nearéwapɨyigɨ́ápɨ nɨwiaíkiro wé piaxɨ́ aí tɨ́nɨ aiwá narɨgɨ́árɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisaso re urɨŋɨnigɨnɨ, “Eŋíná Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo soyɨ́né naŋɨ́ rɨro sɨpí rɨro yarɨgɨ́oyɨ́né nánɨ xɨxenɨ nɨwurɨyirɨ rɨ́wamɨŋɨ́ re eaŋɨ́rɨnɨ, ‘Ámá tɨyɨ́ “Gorɨxomɨ wéyo píránɨŋɨ́ mearɨŋwɨnɨ.” nɨrɨro aiwɨ Gorɨxonɨ dɨŋɨ́ sɨxɨ́ mɨnɨyipa yarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","E nero ámáyo amɨpí ámá wigɨ́ dɨŋɨ́ tɨ́nɨ érowiápɨ́nɨgɨ́ápɨ nánɨ nuréwapɨyiróná yapɨ́ re nurɨro “Xwɨyɨ́á tɨyɨ́ Gorɨxo rɨŋɨ́rɨnɨ.” nurɨro nánɨ “Gorɨxomɨ seáyɨ e mearɨŋwɨnɨ.” nɨrɨróná Gorɨxonɨyá yoɨ́nɨ surɨ́má rarɨgɨ́árɨnɨ.’ Aisaiao soyɨ́né nánɨ xɨxenɨ e nɨwurɨyirɨ rɨ́wamɨŋɨ́ eaŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Soyɨ́né ámá érowiápɨ́nɨgɨ́ápɨ nɨxɨ́dɨróná ŋwɨ́ ikaxɨ́ Gorɨxo rɨŋɨ́pɨ íkɨ́ nɨnemoro yarɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ Gorɨxo rɨŋɨ́pɨ wiaíkiro amɨpí segɨ́ arɨ́owa érowiápɨ́nɨgɨ́ápɨ xɨ́dɨro yanɨro nánɨ dɨŋɨ́ obɨbaxɨ́ nɨmoro óɨ́ imoarɨgɨ́oyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Eŋíná xwɨyɨ́á Gorɨxo rɨŋɨ́pɨ Moseso nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨnigɨnɨ, ‘Dɨxɨ́ ápowamɨ tɨ́nɨ inókíwamɨ tɨ́nɨ wéyo merɨ́ɨnɨ.’ E nɨrɨrɨ nearɨ ámɨ rɨpɨ nɨrɨrɨ eaŋɨnigɨnɨ, ‘Ámá xanomɨranɨ, xɨnáímɨranɨ, ikayɨ́wɨ́ umearɨ́ɨ́yɨ́ emɨ pɨkímópoyɨ.’ Moseso e nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","soyɨ́né ámá wí xɨnáíwamɨranɨ, xanowamɨranɨ, re urarɨ́ná ‘Amɨpí nionɨ wéyo nɨrɨmerɨ́ná arɨrá nɨsirɨ siapɨpaxɨ́ imónɨŋɨ́yɨ́ nánɨ rɨxa Gorɨxomɨ re urɨ́anigɨnɨ, “Nionɨ nɨsiapɨmɨ́árɨnɨ.” nurɨrɨ nánɨ arɨge joxɨ nɨsiapɨrɨ arɨrá simɨ́ɨnɨ? Oweoɨ, aípagwí nánɨ wí menɨnɨ.’ Parisioyɨ́né ámá wí xanɨyaúmɨ e urarɨŋagɨ sɨŋwɨ́ nɨwɨnɨróná ‘O apánɨ yarɨnɨ.’ nɨrɨro ");
INSERT INTO aak_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","o xanɨyaúmɨ píránɨŋɨ́ wéyo mɨmepa yarɨŋagɨ nɨwɨnɨro aiwɨ o ayaúmɨ xe bɨ arɨrá owinɨnɨrɨ sɨŋwɨ́ wɨnarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","E nerɨ́ná soyɨ́né sɨwɨ́ arɨ́owa érowiápɨ́nɨgɨ́ápɨ nɨxɨ́dɨro xwɨyɨ́á Gorɨxo rɨŋɨ́ rɨpɨ xórórɨ́ nero wiaíkiarɨŋoɨ. E yarɨgɨ́ápa nerɨ́ná xwɨyɨ́á Gorɨxoyá xwé wí enɨ nɨwiaíkia warɨŋoɨ.” Jisaso Parisiowamɨ e nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ámá e epɨ́royɨ́ egɨ́áyo “Aŋwɨ e bɨ́poyɨ.” nurɨrɨ ayɨ́ rɨxa aŋwɨ e báná o “Nɨyɨ́nénɨ nɨjɨ́á imónɨpɨ́rɨ nánɨ píránɨŋɨ́ arɨ́á nípoyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Aiwá ámá nɨnɨrɨ́ná gwɨ́náreáɨ́ápɨ wí piaxɨ́ weaarɨŋɨ́manɨ. Pí pí xwioxɨ́yo dánɨ peyeaarɨŋɨ́pɨ ámáyo piaxɨ́ weaarɨŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á nionɨ rɨ́á rɨpɨ nánɨ arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” nurɨ́ɨsáná ");
INSERT INTO aak_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ámá e epɨ́royɨ́ egɨ́áyo e nɨwárɨmɨ nurɨ aŋɨ́yo nɨpáwirɨ nɨŋwearɨ xegɨ́ wiepɨsarɨŋowa ewayɨ́ xwɨyɨ́á xɨ́o urɨ́ɨ́pɨ nánɨ yarɨŋɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","o re urɨŋɨnigɨnɨ, “Soyɨ́né enɨ dɨŋɨ́ mayoyɨ́néranɨ? Xwɨyɨ́á ‘Aiwá ámá nɨnɨrɨ́ná gwɨ́náreáɨ́ápɨ wí xɨ́omɨ piaxɨ́ weaarɨŋɨ́manɨ.’ searɨ́ápɨ soyɨ́né sɨnɨ mɨ́kɨ́ nánɨ dɨŋɨ́ mɨmoarɨŋɨ́ reŋoɨ?” nurɨrɨ áwaŋɨ́ re urɨŋɨnigɨnɨ, “Aiwá wí ámáyo piaxɨ́ eapaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pí nánɨyɨ? Ayɨ́ aiwá gwɨ́náreááná nɨwerɨ írɨwɨ́yo ínɨŋɨ́ rɨ́wɨ́yo íkɨ́ emoarɨgɨ́á eŋagɨ nánɨrɨnɨ.” nurɨrɨ —E nurɨrɨ́ná aiwá nɨ́nɨ nánɨ “Ananɨ nɨpaxɨ́rɨnɨ.” rɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ámɨ re urɨŋɨnigɨnɨ, “Aga pípɨ ámáyo piaxɨ́ weaarɨŋɨ́rɨnɨ? Ayɨ́ pí pí dɨŋɨ́ xwioxɨ́yo dánɨ peyeáɨ́pɨ, amɨpí sɨpí nánɨ móɨ́pɨ ámáyo piaxɨ́ weaarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Xwioxɨ́yo dánɨ dɨŋɨ́ yaiwíɨ́ápimɨ dánɨ rɨpɨ rɨpɨ yarɨgɨ́árɨnɨ. Ɨ́wɨ́ amɨpí wí nánɨ dɨŋɨ́ moro ɨ́wɨ́ inɨro apɨxɨ́ erápenɨro amɨpí ɨ́wɨ́ mearo ámá pɨkíxwɨrɨ́ó ero oxɨ́ apɨxɨ́ iyɨ́ nánɨ niga uro ");
INSERT INTO aak_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sɨŋwɨ́ ɨ́wɨ́ wɨnɨro rɨkɨkɨrɨ́ó ero yapɨ́ wíwapɨyiro ayá bɨ mé arɨ́kí niga uro sɨpí dɨŋɨ́ wiaiwiro xwɨyɨ́ápámɨ ŋwɨrárɨro mɨxɨ́ kɨ́nɨro majɨmajɨ́á ikárɨnɨro yarɨgɨ́ápɨ ");
INSERT INTO aak_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","apɨ nɨpɨnɨ ámá dɨŋɨ́yo ínɨmɨ dánɨ nɨmorɨ́ná piaxɨ́ weaarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","O ewayɨ́ xwɨyɨ́á mɨ́kɨ́ apɨ nurɨmɨ aŋɨ́ e dánɨ nurɨ aŋɨ́ yoɨ́ Taia tɨ́ŋɨ́ e nɨrémorɨ aŋɨ́ wiwámɨ nɨpáwirɨ ámá e ŋweáyɨ́ “Aŋɨ́ riwámɨ o mɨŋweanɨnɨ.” oyaiwípoyɨnɨrɨ nerɨ sá ŋweaŋagɨ aiwɨ ámá wí omɨ sɨŋwɨ́ nɨwɨnɨmearo ");
INSERT INTO aak_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","apɨxɨ́ wí “Jisaso aŋɨ́ iwámɨ ŋweanɨ.” rarɨŋagɨ́a arɨ́á e nɨwirɨ í xegɨ́ xemiáí imɨ́ó xɨxéroarɨŋí eŋagɨ nánɨ o tɨ́ŋɨ́ e nánɨ aŋɨ́nɨ nɨbɨrɨ sɨkwɨ́ tɨ́ŋɨ́ e waunɨ́ nɨwikárɨnɨrɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ ");
INSERT INTO aak_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","—Í Judayɨ́ apɨxímanɨ. Gɨrikɨyɨ́ apɨxírɨnɨ. Pinisiayɨ́ aŋɨ́yo pɨropenɨsɨ́ Siriayɨ rɨnɨŋe dáŋírɨnɨ. Í Jisasomɨ “Gɨ́ miáímɨ imɨ́ó xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowárénapeɨ.” arɨ́kí urayarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","o í aŋɨ́ mɨdáŋí eŋagɨ nánɨ “Xámɨ gɨ́ Judayɨ́ saŋɨ́ ourápɨmɨnɨ.” nɨyaiwirɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Xámɨ niaíwɨ́ aiwá nɨnɨro agwɨ́ ímɨ uyinɨ nɨwirɨ́náyɨ́ ayɨ́ naŋɨ́rɨnɨ. Niaíwɨ́yɨ́yá aiwá nurápɨrɨ sɨ́wíyo nɨwirɨ́ná ayɨ́ naŋɨ́manɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","í “Nepa aŋɨ́ mɨdáŋínɨ sɨ́wínɨ́nɨŋɨ́ imónɨŋɨnɨ.” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nepa rarɨŋɨnɨ. E nerɨ aiwɨ sɨ́wí re yarɨŋɨ́rɨnɨ. Íkwiaŋwɨ́yo dánɨ niaíwɨ́ aiwá nɨnɨro yunɨ́ mamówárɨ́ápɨ mɨmeánɨ́ yarɨŋɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","o “Í nepa waunɨ́ nikárɨnɨrɨ dɨŋɨ́ nɨkwɨ́roarɨnɨ.” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Jíxɨ naŋɨ́ nɨrɨ́ɨ́yɨ́ nánɨ dɨxɨ́ miáímɨ imɨ́ó xɨxéroarɨŋɨ́pɨ rɨxa mɨxɨ́ umáɨnɨ́ɨnɨ. Dɨxɨ́ aŋɨ́ uɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","í ámɨ xegɨ́ aŋɨ́yo nánɨ nurɨ sɨŋwɨ́ wɨnɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Xemiáí imɨ́ó pɨ́nɨ nɨwiárɨmɨ úɨ́ eŋagɨ nánɨ píránɨŋɨ́ sá weŋagɨ wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisaso ámɨ nɨwiápɨ́nɨmearɨ aŋɨ́ yoɨ́ Taia tɨ́ŋɨ́ e pɨ́nɨ nɨwiárɨmɨ nurɨ aŋɨ́ yoɨ́ Saidonɨ tɨ́ŋɨ́ e áwɨnɨ e nurɨ xwɨ́á yoɨ́ Dekaporisɨyo nurɨ́ná ipí Gaririyo nɨrémorɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ámá wí ámá arɨ́á pɨ́rónárɨrɨ xwɨyɨ́á pɨ́rónárɨrɨ eŋɨ́ womɨ Jisaso tɨ́ŋɨ́ e nánɨ nɨmeámɨ nɨbɨro waunɨ́ rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “O naŋɨ́ enɨ nánɨ wé seáyɨ e ikwiáreɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisaso ámá awí eánárɨgɨ́e dánɨ omɨ nɨmeámɨ nurɨ egɨ́pɨ nerɨ́ná Jisaso xegɨ́ wé oyá arɨ́á óɨ́yo wíxwárɨrɨ xegɨ́ wéyo reaŋwɨ́ núrɨnɨmáná oyá aíwɨ́yo ikwiárɨrɨ nemáná ");
INSERT INTO aak_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","sɨŋwɨ́ aŋɨ́namɨ nanɨmáná rɨ́mɨŋɨ́ nɨrɨrɨ xegɨ́ pɨ́né tɨ́nɨ re urɨŋɨnigɨnɨ, “Epata.” —Wigɨ́ pɨ́né “Oxoaɨ.” nurɨrɨ́ná “Epata.” rarɨgɨ́árɨnɨ. E uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Xegɨ́ arɨ́á oxoánɨrɨ aíwɨ́ saŋɨ́ wiarɨŋɨ́pɨ nayɨ́ erɨ nerɨ xwɨyɨ́á píránɨŋɨ́ nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisaso ámɨ ámá awí eánárɨgɨ́áyo nɨwímearɨ ŋwɨ́ ikaxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ wíápɨ áwaŋɨ́ murɨmepanɨ.” urɨ́agɨ aiwɨ amɨ amɨ nemero arɨ́kí áwaŋɨ́ nɨra nuro ");
INSERT INTO aak_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ayá nɨrɨwamóga nuro re nɨra ugɨ́awixɨnɨ. “Amɨpí o éɨ́pɨyɨ́ aga naŋɨ́nɨ yarɨŋɨ́rɨnɨ. Arɨ́á pɨ́rónarɨgɨ́áyɨ́ tɨ́nɨ aíwɨ́ saŋɨ́ mearɨgɨ́áyɨ́ tɨ́nɨ aí píránɨŋɨ́ imɨxáná arɨ́á ero xwɨyɨ́á rɨro yarɨgɨ́árɨnɨ.” nɨra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Íná rɨ́wɨ́yo Jisaso ámá obaxɨ́ ámɨ o tɨ́ŋɨ́ e epɨ́royɨ́ nɨyárɨro wigɨ́ aiwá rɨxa meŋagɨ nɨwɨnɨrɨ xegɨ́ wiepɨsarɨŋowamɨ “Eɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","re urɨŋɨnigɨnɨ, “Ámá tɨyɨ́ sɨ́á wɨyaú wɨyi nionɨ tɨ́nɨ re nɨŋwearóná wigɨ́ aiwá rɨxa nowárɨgɨ́á eŋagɨ nánɨ wá nonarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wí aŋɨ́ aíwɨmɨ dánɨ bɨ́agɨ́á eŋagɨ nánɨ nionɨ ayɨ́ sɨnɨ agwɨ́ nánɨ yarɨ́ná nurowárɨrɨ́náyɨ́ ‘Sɨŋwɨ́ xaxá nɨwinɨrɨ eŋɨ́ sɨrɨrɨŋwɨ́ nɨwinɨrɨ ná neága upɨ́rɨxɨnɨ.’ nɨyaiwirɨ rarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","xegɨ́ wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Aŋɨ́ mɨmɨrɨnɨŋɨ́ re aiwá ámá tɨyɨ́ xɨxenɨ nɨpɨ́rɨ nánɨ ge bɨ́ yanɨ́wɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","o re urɨŋɨnigɨnɨ, “Segɨ́ bisɨ́kerɨ́á ararɨrɨnɨ?” uráná “Wé wɨ́úmɨ dáŋɨ́ waú tɨ́ŋwáonerɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","o ámá epɨ́royɨ́ egɨ́áyo “Xwɨ́ámɨ éɨ́ nɨŋweaxa úpoyɨ.” nurɨrɨ bisɨ́kerɨ́á nɨmearɨ Gorɨxomɨ aiwá apɨ nánɨ yayɨ́ nɨwimáná kwɨkwɨrɨmɨ́ nerɨ wiepɨsarɨŋowamɨ mɨnɨ wíáná nurápayiro ámá ayo mɨnɨ nɨwia nuro ");
INSERT INTO aak_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","wigɨ́ peyɨ́ bia eŋagɨ Jisaso apia enɨ nurápɨrɨ Gorɨxomɨ yayɨ́ nɨwimáná re urɨŋɨnigɨnɨ, “Peyɨ́ rɨpia enɨ yaŋɨ́ nɨwia úpoyɨ.” urɨ́agɨ xɨ́o urɨ́ɨ́pɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ámá nɨ́nɨ rɨxa nɨnɨro agwɨ́ ímɨ uyíagɨ wiepɨsarɨŋowa ayɨ́ aiwá nɨnɨro e tɨ́ápia nɨmeaayiro soxɨ́ ɨ́á wé wɨ́úmɨ dáŋɨ́ waúmɨ aumaúmɨ́ nero magwɨ́ miárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ámá 4,000 aiwá apɨ nɨgɨ́awixɨnɨ. Jisaso ayɨ́ aiwá nɨnɨmáná eŋáná wigɨ́ aŋɨ́ e nánɨ nurowárɨmɨ ");
INSERT INTO aak_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ewéyo wiepɨsarɨŋowa tɨ́nɨ nɨpɨxemoánɨro nɨmeámɨ ugɨ́awixɨnɨ. Ipíyo orɨwámɨ dánɨ aŋɨ́ yoɨ́ Darɨmanuta tɨ́ŋɨ́ e niwiékɨ́nɨmearo ayoagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi wa nɨwímearo rɨxa sɨ́mɨ́ tɨ́nɨ úrapí xwɨyɨ́á nurɨro omɨ iwamɨ́ó wíwapɨyanɨro nánɨ re urɨgɨ́awixɨnɨ, “Aŋɨ́namɨ dáŋɨ́ emɨmɨ́ bɨ neaíwapɨyiɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisaso awa nánɨ xegɨ́ xwioxɨ́yo dánɨ mɨŋɨ́ nɨpénɨrɨ “Iniɨ!” nɨrɨrɨ re urɨŋɨnigɨnɨ, “Judayɨ́ agwɨ ríná ŋweagɨ́áyɨ́né pí nánɨ ‘Emɨmɨ́ neaíwapɨyiɨ.’ nɨrarɨŋoɨ? E nɨrarɨŋagɨ́a aiwɨ emɨmɨ́ soyɨ́né nɨrarɨgɨ́ápɨ wí nemɨméɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ayo pɨ́nɨ nɨwiárɨmɨ wiepɨsarɨŋowa tɨ́nɨ ewéyo nɨpɨxemoánɨro ipíyo orɨwámɨ dánɨ nánɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nuróná aiwá nánɨ dɨŋɨ́ arɨ́á nikeamoro bisɨ́kerɨ́á ná bɨnɨ ewéyo weŋɨ́pɨnɨ nɨmeámɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisaso Parisiowa naŋɨ́ rayiro sɨpí rayiro yarɨŋɨ́pa wiepɨsarɨŋowa axɨ́pɨ yanɨro nerɨ́ná omɨ dɨŋɨ́ mɨkwɨ́ropa nero rɨ́wɨ́ nɨmopɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á nurɨrɨ́ná sekaxɨ́ re urɨŋɨnigɨnɨ, “Soyɨ́né píránɨŋɨ́ emépoyɨ. Bisɨ́kerɨ́á yisɨ́ —Bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ eŋáná yisɨ́ onɨmiápɨ tɨ́á aiwɨ nɨmɨnɨ íkwiaŋwɨ́ neapɨnárɨrɨ nɨmɨga wiápɨ́nɨmearɨŋɨ́rɨnɨ. Yisɨ́ Parisiowayá tɨ́nɨ Xerotoyá tɨ́nɨ nánɨ wáyɨ́ nero emépoyɨ.” urɨŋɨnigɨnɨ. Uyɨ́niɨ́ yisɨ́nɨŋɨ́ wigɨ́ xwioxɨ́yo íkwiaŋwɨ́ eapɨnɨnɨgɨnɨrɨ e urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","wiwanɨŋowa re rɨnɨgɨ́awixɨnɨ, “None bisɨ́kerɨ́á meŋagɨ nánɨ neararɨnɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","o arɨ́á nɨwirɨ mɨxɨ́ re urɨŋɨnigɨnɨ, “Pí nánɨ ‘Bisɨ́kerɨ́á mayonerɨnɨ.’ rɨnarɨŋoɨ? Sɨnɨ sɨŋwɨ́ oxoaro dɨŋɨ́ moro mepa reŋoɨ? Segɨ́ mɨŋɨ́ sɨ́ŋánɨŋɨ́ rimónɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sɨŋwɨ́ tɨ́gɨ́oyɨ́né aiwɨ sɨŋwɨ́ mɨwɨnɨpa rɨyarɨŋoɨ? Arɨ́á tɨ́gɨ́oyɨ́né aiwɨ arɨ́á mɨyarɨŋɨ́ reŋoɨ? Nionɨ bisɨ́kerɨ́á wé wú núnɨ kwɨkwɨrɨmɨ́ nerɨ ámá 5,000yo mɨnɨ wiŋá nánɨ dɨŋɨ́ mɨseainarɨnɨranɨ? ");
INSERT INTO aak_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aiwá ayɨ́ nɨnɨro tɨ́ápɨ soxɨ́ ɨ́á xwé ararɨyo aumaúmɨ́ yárɨgɨ́awixɨnɨ?” urɨ́agɨ awa “Wé wúkaú sɨkwɨ́ waú apimɨ aumaúmɨ́ yárɨŋwanigɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","o ámɨ re urɨŋɨnigɨnɨ, “Nionɨ bisɨ́kerɨ́á ámá 4,000yo nɨkwɨrɨrɨ wiŋápɨ soxɨ́ ɨ́á ararɨyo miárɨgɨ́awixɨnɨ?” urɨ́agɨ awa “Wé wɨ́úmɨ dáŋɨ́ waúmɨ miárɨŋwanigɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","o re urɨŋɨnigɨnɨ, “Soyɨ́né sɨnɨ majɨ́á rimónɨŋoɨ? ‘Aiwá meŋáná árɨ́none mɨneaiapɨpaxorɨnɨ.’ rɨniaiwiarɨŋoɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E nurɨ́ɨsáná nuro aŋɨ́ yoɨ́ Betɨsaidayo niwiékɨ́nɨmearo nayoaro emearɨ́ná ámá wí sɨŋwɨ́ supárɨŋɨ́ wo Jisaso píránɨŋɨ́ imɨxɨnɨ nánɨ nɨméra nɨbɨro waunɨ́ rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “Joxɨ wé seáyɨ e nɨwikwiárɨrɨ naŋɨ́ imɨxɨréɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisaso sɨŋwɨ́ supárɨŋomɨ wéyo ɨ́á nɨxɨrɨmɨ aŋɨ́ Betɨsaida e nɨwárɨmɨ nurɨ yánɨ e dánɨ nɨrómáná oyá sɨŋwɨ́yo reaŋwɨ́ núrɨrɨ wé seáyɨ e nɨwikwiárɨrɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Joxɨ amɨpí wí sɨŋwɨ́ rɨwɨnɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","o sɨŋwɨ́ nanɨrɨ re urɨŋɨnigɨnɨ, “Ámá wí aŋɨ́ emearɨŋagɨ́a sɨŋwɨ́ nɨwɨnɨrɨ aiwɨ íkɨ́ánɨŋɨ́ imónɨŋagɨ́a wɨnɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ámɨ bɨ wé sɨŋwɨ́yo seáyɨ e wikwiáráná o rɨxa sɨŋwɨ́ anɨŋɨ́ nanárɨrɨ xegɨ́ sɨŋwɨ́ rɨxa naŋɨ́ éagɨ amɨpí nɨyonɨ xɨxenɨ wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Xɨxenɨ wɨnáná Jisaso o xegɨ́ aŋɨ́ e nánɨ nurowárɨrɨ́ná re urɨŋɨnigɨnɨ, “Dɨxɨ́ aŋɨ́ e nánɨ nurɨ́ná ámɨ Betɨsaida tɨ́yo nánɨ mupanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nɨwiápɨ́nɨmeámɨ nuro aŋɨ́ xwé yoɨ́ Sisaria Piripai tɨ́ŋɨ́yo ikwɨ́rónɨŋɨ́pimɨ nánɨ nurɨ́ná awamɨ yarɨŋɨ́ nɨwirɨ re urɨŋɨnigɨnɨ, “Ámáyɨ́ nionɨ nánɨ arɨre rarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","awa re urɨgɨ́awixɨnɨ, “Wí re rarɨŋoɨ, ‘Jono wayɨ́ nɨneameaia wago ámɨ nɨwiápɨ́nɨmearɨ rɨ́a yarɨnɨ?’ rarɨŋoɨ. Ámɨ wí re rarɨŋoɨ, ‘Eŋíná Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́ mɨpé aŋɨ́namɨ peyiŋɨ́ Iraijaoyɨ rɨnɨŋo nɨweapɨrɨ rɨ́a yarɨnɨ?’ rarɨŋoɨ. Ámɨ wí re rarɨŋoɨ, ‘Eŋíná Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́á wo nɨwiápɨ́nɨmearɨ rɨ́a yarɨnɨ?’ rarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","o sɨnɨ yarɨŋɨ́ nɨwirɨ́ná re urɨŋɨnigɨnɨ, “Ayɨ́ e nɨrɨro aiwɨ sewanɨŋoyɨ́né nionɨ nánɨ gorɨnɨ rarɨŋoɨ?” urɨ́agɨ Pitao re urɨŋɨnigɨnɨ, “Joxɨ Kiraisoxɨ, nene yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋoxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","o ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Soyɨ́né nionɨ e eŋáonɨ nánɨ áwaŋɨ́ murɨpa époyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Xewanɨŋo nánɨ iwamɨ́ó nuréwapɨyirɨ re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ rɨ́nɨŋɨ́ xwé wí meámɨ́árɨnɨ. Negɨ́ mebáowa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ nionɨ rɨ́wɨ́ nɨmóáná wa nɨnɨpɨkipɨ́rɨ́árɨnɨ. E nerɨ aiwɨ sɨ́á wɨyaú wɨyi óráná ámɨ wiápɨ́nɨmeámɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","pɨ́né sɨŋánɨ e rɨmóagɨ Pitao Jisasomɨ nɨmeámɨ nurɨ yánɨmɨ nɨrómáná rɨxa mɨxɨ́ urɨmɨnɨrɨ nánɨ nerɨ “E wí mɨnearɨpanɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisaso omɨ rɨ́wɨ́ numorɨ wiepɨsarɨŋɨ́ wɨ́amɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná omɨ mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Setenoxɨnɨ, pɨ́nɨ nɨnɨwiárɨmɨ uɨ.” nɨrɨrɨ re urɨŋɨnigɨnɨ, “Pitaoxɨ amɨpí nánɨ Gorɨxo wimónarɨŋɨ́pɨ nánɨ dɨŋɨ́ mɨmó ámá wimónarɨŋɨ́pɨ nánɨ moarɨŋɨnɨ.” nurɨ́ɨsáná ");
INSERT INTO aak_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ámá e epɨ́royɨ́ egɨ́áyo “Eɨnɨ.” nurɨrɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nawínɨ awí neánɨmáná eŋáná re urɨŋɨnigɨnɨ, “Soyɨ́né woxɨ nionɨ yarɨŋápa emɨnɨrɨ nánɨ nionɨ tɨ́nɨ nurɨ́náyɨ́ re erɨ́árɨnɨ. Dɨxɨ́ simónarɨŋɨ́pɨ wí mé rɨ́wɨ́mɨnɨ nɨmamorɨ re nɨyaiwirɨ ‘Jisasomɨ xɨ́darɨŋagɨ nánɨ ámá wa íkɨ́áyo nɨnɨyekwɨroárɨro nɨnɨpɨkiróná ayɨ́ ananɨrɨnɨ.’ nɨyaiwirɨ nɨxɨ́dɨrɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ámá go go ‘Jisasomɨ nɨxɨ́dɨrɨ́náyɨ́ ámá wa nɨpɨkipɨ́rɨxɨnɨ.’ nɨyaiwirɨ nánɨ nionɨ mɨnɨxɨ́dɨ́ xegɨ́ wará éɨ́ nɨmenɨrɨ nerɨ́ná xewanɨŋo anɨŋɨ́nɨ ikeamónɨnɨ́árɨnɨ. E nerɨ aiwɨ ámá go go nionɨ nɨnɨxɨ́dɨrɨ xwɨyɨ́á yayɨ́ seainarɨŋɨ́pɨ nánɨ wáɨ́ emearɨŋagɨ nánɨ pɨkíánáyɨ́, o anɨŋɨ́nɨ mikeamónɨ́ nionɨ nɨnɨxɨ́dɨrɨŋɨ́pimɨ dánɨ erɨ́kiemeánɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ámá go go nionɨ mɨnɨxɨ́dɨ́ iyɨ́á ɨ́á nɨgwɨ́ amɨpí emeámɨnɨrɨ nánɨnɨ néra nurɨ nɨmeáɨsáná xewanɨŋo anɨŋɨ́nɨ ikeamónáná ayɨ́ naŋɨ́ranɨ? Oweoɨ! Amɨpí nɨ́nɨ xwɨ́á tɨ́yo dáŋɨ́ mɨmúropa nerɨ aiwɨ xewanɨŋo anɨŋɨ́ ikeamónáná amɨpí apɨ tɨ́nɨ xegɨ́ wará anɨŋɨ́ ŋweanɨ́a nánɨ roayírónɨpaxɨ́manɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","re urɨŋɨnigɨnɨ, “Seyɨ́né nuro ámá agwɨ ríná ŋweagɨ́áyɨ́ Gorɨxomɨ dɨŋɨ́ mɨwɨkwɨ́ró ɨ́wɨ́ néra warɨgɨ́áyɨ́ tɨ́ŋɨ́ e nemerɨ́ná nionɨ nánɨ ayá seainɨrɨ pɨ́né nionɨ rarɨŋápɨ enɨ nánɨ ayá seainɨrɨ yarɨŋagɨ nánɨ ámáyo yumɨ́í nɨwirɨ́náyɨ́, ámá imónɨŋáonɨ nɨweapɨrɨ́ná ikɨ́nɨŋáonɨ weapɨrɨ gɨ́ ápo xwɨnɨ́á eaarɨŋɨ́pa nionɨ enɨ xwɨnɨ́á eaŋáonɨ aŋɨ́najɨ́ wa tɨ́nɨ weapɨrɨ nerɨ xɨ́o nánɨ enɨ ayá nɨninɨrɨ ‘Go rɨ́anɨ?’ rɨmɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ámɨ re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋagɨ nánɨ píránɨŋɨ́ arɨ́á nípoyɨ. Ámá re rogɨ́á wiyɨ́né sɨnɨ mɨpepa nerɨ́ná eŋɨ́ eánɨŋɨ́ Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́a nánɨ imónɨŋɨ́pɨ imónarɨŋagɨ sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rɨxa sɨ́á wé wɨ́úmɨ dáŋɨ́ wo óráná o Pitaomɨ tɨ́nɨ Jemisomɨ tɨ́nɨ Jonomɨ tɨ́nɨ nɨwirɨmeámɨ dɨ́wɨ́ xwé bimɨ nɨpeyiro wiwɨnɨ nɨŋwearɨ́ná wigɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ re eŋɨnigɨnɨ. Jisaso wará xegɨ́ bɨ nimónɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","xegɨ́ rapɨrapɨ́ enɨ wɨ́á nókiárɨrɨ ámá wí wayɨ́ nɨrorɨ́ná apɨ́á e wéɨ́ mɨropaxɨ́ apɨ́á xaíwɨ́ weárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","E yarɨ́ná Gorɨxoyá wɨ́á rókiamoagɨ́ Iraijaoyɨ rɨnɨŋo tɨ́nɨ eŋíná yagɨ́ Moseso tɨ́nɨ omɨ nɨwímeari o tɨ́nɨ xwɨyɨ́á rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","wiepɨsarɨŋowa wáyɨ́ ayɨkwɨ́ mɨwinɨ́agɨ nánɨ Pitao “Píoɨ urɨmɨ́ɨnɨ?” nɨyaiwirɨ úrapí xwɨyɨ́á nurɨrɨ Jisasomɨ re urɨŋɨnigɨnɨ, “None re nɨŋwearɨ́ná naŋɨ́rɨnɨ. Ananɨ re ŋweapaxɨ́rɨnɨ. Aŋɨ́ pɨpákɨ́ wíkaú wí, joxɨ nánɨ wiwáyɨ, Moseso nánɨ wiwáyɨ, Iraijao nánɨ wiwáyɨ omɨraneyɨ.” nurɨmáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","agwɨ́ bɨ rɨtɨ́ wiáráná agwɨ́pimɨ dánɨ xwɨyɨ́á bɨ re rɨnɨŋɨnigɨnɨ, “O gɨ́ íwɨ́ dɨŋɨ́ sɨxɨ́ yiŋáorɨnɨ. Pí pí xwɨyɨ́á searánáyɨ́ arɨ́á wípoyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Ámá wo mepa Jisasonɨ iwo ŋweaŋagɨ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","E nɨwɨnɨmáná dɨ́wɨ́ mɨŋɨ́yo dánɨ pɨ́nɨ nɨwiárɨmɨ nɨweapɨróná Jisaso ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Rɨpɨ nanɨ́ápɨ nánɨ ámáyo áwaŋɨ́ murɨmepa époyɨ. Ámá imónɨŋáonɨ rɨxa nɨperɨ xwárɨpáyo dánɨ nɨwiápɨ́nɨmeámáná eŋáná íná ananɨ áwaŋɨ́ urɨméɨ́rɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","awa dɨŋɨ́nɨ ɨ́á nɨxɨrɨro xwɨyɨ́á “Nɨperɨ xwárɨpáyo dánɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urɨ́ɨ́pɨ nánɨ ududɨ́ nero “Pí nánɨ rɨ́a nearɨŋoɨ?” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","yarɨŋɨ́ re wigɨ́awixɨnɨ, “Pí nánɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa re rarɨgɨ́árɨnɨ, ‘Iraijao rɨxa bɨŋɨ́mɨ eŋáná rɨ́wɨ́yo ámá nene yeáyɨ́ neayimɨxemeanɨ́o arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́árɨnɨ.’ pí nánɨ rarɨgɨ́árɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","o re urɨŋɨnigɨnɨ, “Ayɨ́ neparɨnɨ. Iraijao xámɨ nɨbɨrɨ ámá wigɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ mamoro Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roro epɨ́rɨ nánɨ xwɨyɨ́á nurɨrɨ aiwɨ xwɨyɨ́á Gorɨxoyá nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ ‘Ámá imónɨŋomɨ rɨ́nɨŋɨ́ nɨwiayiro xwɨrɨ́á wikɨxepɨ́rɨ́árɨnɨ.’ xwɨyɨ́á apɨ enɨ pí nánɨ rɨnɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa e nɨrɨro aiwɨ nionɨ re seararɨŋɨnɨ, ‘Iraijao rɨxa bɨ́agɨ aiwɨ ámá rɨ́wamɨŋɨ́ xɨ́o nánɨ eánɨŋɨ́pɨ omɨ arɨ́á mɨwí wigɨ́ dɨŋɨ́ tɨ́nɨ sɨpí nɨwiéra ugɨ́awixɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisaso awa tɨ́nɨ ámɨ xegɨ́ wiepɨsarɨŋɨ́ wɨ́amɨ wímeanɨro nánɨ nɨweapɨro awa tɨ́e ámá epɨ́royɨ́ eŋagɨ́a nɨwɨnɨro awa ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa tɨ́nɨ xwɨyɨ́á sɨ́mɨ́ tɨ́nɨ rɨnarɨŋagɨ́a nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","rɨxa aŋwɨ e báná ámá e epɨ́royɨ́ egɨ́áyɨ́ Jisaso weaparɨŋagɨ nɨwɨnɨro sɨrɨ́ nɨpɨkínɨro yayɨ́ wianɨro nánɨ aŋɨ́nɨ nuro wímeááná ");
INSERT INTO aak_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","o yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awa tɨ́nɨ pí nánɨ xwɨyɨ́á sɨ́mɨ́ tɨ́nɨ rɨnarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ámá e epɨ́royɨ́ egɨ́áyɨ́ wo re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, gɨ́ íwomɨ imɨ́ó xɨxéroarɨŋagɨ nánɨ maŋɨ́ pɨ́rónárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Imɨ́ó meaŋɨ́ eááná meákɨ́kwiɨ́ánɨ yárɨrɨ maŋɨ́ sɨ́wɨ́ kɨrɨ́wɨnɨrɨ sɨkwɨ́ wé sɨwɨ́á yárɨrɨ yárarɨŋɨ́rɨnɨ. Nionɨ joxɨ nánɨ nɨmeáa bɨ́á aiwɨ joxɨ mɨŋweaŋagɨ nánɨ dɨxɨ́ wiepɨsarɨŋowamɨ ‘Soyɨ́né mɨxɨ́ umáɨnowárɨ́poyɨ.’ urɨ́agɨ aiwɨ awa wí ananɨ mɨxɨ́ umáɨnowárɨpaxɨ́manɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisaso rɨxa anɨdɨŋɨ́ nɨwiaiwirɨ nánɨ re urɨŋɨnigɨnɨ, “Agwɨ ríná ŋweagɨ́áyɨ́né nionɨ tɨ́nɨ nemerane emá obaxɨ́ nɨseamúróagɨ aiwɨ sɨnɨ Gorɨxomɨ dɨŋɨ́ mɨwɨkwɨ́roarɨgɨ́á reŋoɨ? Arɨre searayimɨ́ɨnɨ?” nurɨrɨ “Íwomɨ nɨwirɨmeámɨ bɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","rɨxa nɨwirɨmeámɨ nɨbɨro imɨ́ó Jisasomɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná re eŋɨnigɨnɨ. Meaŋɨ́ eááná sinapɨxwɨ́nɨ́ néra nɨpiérorɨ xwɨ́áyo niwieága urɨ meákɨ́kwiɨ́á pumirɨ yarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","xanomɨ Jisaso re urɨŋɨnigɨnɨ, “Sa ararɨ eŋɨ́rɨnɨ?” urɨ́agɨ re urɨŋɨnigɨnɨ, “Sɨnɨ onɨmiáo dánɨ e néra uŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Imɨ́ó íwomɨ íníná xwɨrɨ́á oikɨxémɨnɨrɨ re yarɨŋɨ́rɨnɨ. Nɨxerɨ rɨ́áyo ikeaárɨrɨ nɨxerɨ iniɨgɨ́yo mamówárɨrɨ yarɨŋɨ́rɨnɨ.” nurɨrɨ “Jisaso enɨ yopa megɨnɨrɨ́enɨŋoɨ?” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Joxɨ ‘Ananɨ naŋɨ́ imɨxɨpaxonɨrɨnɨ.’ nɨyaiwinɨrɨ́náyɨ́ wá nɨyeaomɨxɨrɨ arɨrá yeaiɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ ‘O naŋɨ́ mimɨxɨpaxorɨnɨ.’ nɨniaiwirɨ rɨnɨrarɨŋɨnɨ? Jɨwanɨŋoxɨ Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roɨ. Ámá gɨyɨ́ Gorɨxomɨ dɨŋɨ́ ɨkwɨ́róɨ́áyɨ́ amɨpí aí ananɨ arɨrá winɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","íwomɨ xano apaxɨ́ mé re urɨŋɨnigɨnɨ, “Gorɨxomɨ dɨŋɨ́ wɨkwɨ́rómɨnɨrɨ yarɨŋagɨ nánɨ aga píránɨŋɨ́ wɨkwɨ́rómɨ nimɨxeɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisaso ámá obaxɨ́ o tɨ́ŋɨ́ e nánɨ mɨ́rɨ́ bɨmiarɨŋagɨ́a nɨwɨnɨrɨ imɨ́ó íwomɨ xɨxéroarɨŋomɨ mɨxɨ́ numáɨnowárɨrɨ re urɨŋɨnigɨnɨ, “Maŋɨ́ pɨ́roárɨrɨ arɨ́á pɨ́roárɨrɨ eŋoxɨ íwomɨ pɨ́nɨ nɨwiárɨmɨ nurɨ ámɨ bɨ tɨ́nɨ rɨ́wɨ́mɨnɨ nɨrorɨ mɨxɨxéropanɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","imɨ́o makɨrɨ́wɨ́ nɨmorɨ meaŋɨ́ nearɨ íwo sinapɨxwɨ́nɨ́ nɨyárɨrɨ weŋáná omɨ pɨ́nɨ nɨwiárɨmɨ uŋɨnigɨnɨ. Pɨ́nɨ nɨwiárɨmɨ úáná íwo rɨxa nɨperɨ́nɨŋɨ́ weŋagɨ nɨwɨnɨro ámá obaxɨ́ “Rɨxa nɨperɨ rɨ́a weŋoɨ?” rarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jisaso xegɨ́ wéyo ɨ́á nɨmaxɨrɨmáná mɨ́eyoááná o wiápɨ́nɨmeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nɨwiápɨ́nɨmeámáná eŋáná Jisaso nurɨ aŋɨ́yo nɨpáwirɨ ŋweaŋáná xegɨ́ wiepɨsarɨŋowa wigɨ́pɨ ínɨmɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Pí nánɨ imɨ́ó íwomɨ xɨxéróomɨ mɨxɨ́ umáɨnowárɨpaxɨ́ mimónɨpa éwanigɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","o re urɨŋɨnigɨnɨ, “Soyɨ́né segɨ́ dɨŋɨ́ tɨ́nɨ imɨ́ó tɨ́nɨŋɨ́ imónɨŋɨ́yɨ́ mɨxɨ́ umáɨnowárɨpaxɨ́ menɨnɨ. Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roro yarɨŋɨ́ wiro nerónáyɨ́, ananɨ oyá dɨŋɨ́ tɨ́nɨ mɨxɨ́ umáɨnowárɨpaxɨ́ imónɨpɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Awa aŋɨ́ ayo pɨ́nɨ nɨwiárɨmɨ Gariri pɨropenɨsɨ́yo áwɨnɨmɨ nurɨ́ná Jisaso “Ámá nionɨ pwarɨŋagɨ nánɨ nɨjɨ́á mimónɨpa oépoyɨ.” yaiwiŋɨnigɨnɨ. Ayɨ́ rɨpɨ nánɨ e yaiwiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wiepɨsarɨŋowamɨnɨ nuréwapɨyirɨ re urayiŋɨnigɨnɨ, “Ámá imónɨŋáonɨ nánɨ mɨyɨ́ uráná nɨnɨpɨkipɨ́rɨ́árɨnɨ. Nɨpɨkíɨ́á aí sɨ́á wɨyaú wɨyi óráná xwárɨpáyo nɨwémáná ámɨ nɨwiápɨ́nɨmeámɨ́árɨnɨ.” urayarɨŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","awa sɨnɨ nɨpɨkwɨnɨ nɨjɨ́á mimónɨpa nero aí masɨsɨ́á nɨwiro nánɨ yarɨŋɨ́ bɨ mɨwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Awa aŋɨ́ yoɨ́ Kapaneamɨ nɨrémoro aŋɨ́yo nɨpáwiro nɨŋwearɨ́ná Jisaso wiepɨsarɨŋowamɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Óɨ́ e nɨbɨranéná pí xwɨyɨ́á nɨrɨga bɨ́awixɨnɨ?” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","awa “Negɨ́ woxɨ goxɨ ámɨná nimónɨrɨ neameŋweaŋáná wɨ́one sɨmaŋwɨ́yónɨŋɨ́ ínɨmɨ yeáyɨ́ rurɨ́nanɨ́wárɨnɨ?” nɨrɨga bɨ́á eŋagɨ nánɨ ayá nero xwɨyɨ́á bɨ murɨ́ kikiɨ́á yarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","o éɨ́ nɨŋweámáná wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ “Soyɨ́né awí neánɨro re ŋwénapɨ́poyɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá ‘Nionɨ sɨmaŋwɨ́yónɨŋɨ́ onurɨ́nayípoyɨ.’ nɨyaiwirɨŋo re éwɨnɨgɨnɨ. Ámá nɨyonɨ xɨnáínɨŋɨ́ nimónɨrɨ arɨrá wíwɨnɨgɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","niaíwɨ́ miá bɨ nɨmearɨ áwɨnɨ e éɨ́ nurárɨmáná wé nɨmakɨ́kɨyirɨ ámɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ámá wo nionɨ nɨxɨ́dɨrɨ́náyɨ́ niaíwɨ́ rɨpɨ́nɨŋɨ́ imónɨŋɨ́yo peayɨ́ mɨwianɨ́ wéyo nɨmerɨ́náyɨ́ apimɨnɨ wéyo mɨmearɨnɨnɨ. Nionɨ wéyo nɨmerɨ gɨ́ ápo, nɨrowárénapɨŋomɨ enɨ wéyo umerɨ yarɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jono re urɨŋɨnigɨnɨ, “Neaiepɨsarɨŋoxɨnɨ, none ámá wo yoɨ́ joxɨyá nɨrɨrɨ imɨ́ó mɨxɨ́ umáɨnowárarɨŋagɨ nɨwɨnɨrane o none tɨ́nɨ nawínɨ memearɨŋagɨ nánɨ xe oenɨrɨ sɨŋwɨ́ wɨnanɨrɨ eŋwámanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisaso re urɨŋɨnigɨnɨ, “Apɨ e imɨxáná pɨ́rɨ́ mɨwiaíkipanɨ. Ámá go go yoɨ́ nionɨyá nɨrɨrɨ emɨmɨ́ nemɨ nurɨ aŋɨ́nɨ ikayɨ́wɨ́ nɨmearɨpaxɨ́ imónɨnɨmenɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ámá ayɨ́ tɨ́ámɨnɨ mɨkumɨxɨnɨpa nerɨ́náyɨ́ ayɨ́ none tɨ́nɨ imónɨnɨ. Ayɨnánɨ e éɨ́áyo bɨ pɨ́rɨ́ mɨwiaíkipanɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ámá go go soyɨ́né Kiraisonɨ nɨxɨ́dɨro wáɨ́ urɨmero yarɨŋagɨ́a nánɨ arɨrá nɨseairɨ iniɨgɨ́ bɨ aí niwirɨ nɨseaiapɨrɨ́náyɨ́, Gorɨxo e éo nánɨ wí dɨŋɨ́ arɨ́á mikeamó omɨ xɨxenɨ arɨrá winɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“E nerɨ aiwɨ ámá go go niaíwɨ́ rɨpiamɨ nionɨ dɨŋɨ́ nɨkwɨ́roanɨro yarɨgɨ́ápiamɨ pɨ́rɨ́ wiaíkímɨnɨrɨ nerɨ ɨ́wɨ́ oépoyɨnɨrɨ wíwapɨyarɨ́ná Gorɨxo ‘O xwɨyɨ́á mayorɨnɨ.’ mɨrɨ́ rɨxa nɨpémáná eŋáná rɨ́nɨŋɨ́ xwé winɨ́árɨnɨ. Sɨnɨ niaíwɨ́piamɨ ɨ́wɨ́ nánɨ mɨwiepɨsipa eŋáná ámá wa omɨ ɨ́á nɨxero sɨ́ŋá xwé wo siŋwɨ́ tɨ́nɨ gwɨ́ nɨjárɨro rawɨrawáyo nɨmamówárɨrɨ́náyɨ́, sɨpí eŋagɨ aiwɨ rɨ́nɨŋɨ́ Gorɨxo wimɨnɨrɨ eŋɨ́pɨ́nɨŋɨ́ imónɨŋɨ́pɨmanɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ɨ́wɨ́ nánɨ wé ɨ́eapá nɨsinɨrɨ́náyɨ́ nɨwákwínɨrɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́ná rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ wé rasɨ́á eŋɨ́ tɨ́nɨ opéɨrɨ aí aŋɨ́namɨ nánɨ nɨpeyirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ. Wé núkaúnɨ ɨ́eapá nerɨ ɨ́wɨ́ meáú sɨnɨ ú tɨ́nɨ nerɨ́ná rɨ́á anɨŋɨ́ wearɨŋɨ́yómɨnɨ nurɨ rɨ́á nɨrɨnɨrɨ́náyɨ́ ayɨ́ naŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","‘Sɨkwɨ́ rú tɨ́nɨ ɨ́wɨ́ nánɨ aŋɨ́ oememɨnɨ.’ yaiwíú sɨkwɨ́ ú mɨŋɨ́ nɨwákwínɨrɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́ná rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ sɨkwɨ́ rasɨ́á eŋɨ́ tɨ́nɨ opéɨrɨ aí aŋɨ́namɨ nánɨ nɨpeyirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ. Sɨkwɨ́ ‘Ɨ́wɨ́ nánɨ oumɨnɨ.’ yaiwiarɨŋú tɨ́nɨ eŋáná nɨperɨ́ná Gorɨxo rɨ́á anɨŋɨ́ wearɨŋɨ́yo nɨsikeaárɨrɨ́náyɨ́ ayɨ́ naŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sɨŋwɨ́ wɨ́nɨyi tɨ́nɨ ɨ́wɨ́ nánɨ nɨmorɨ́náyɨ́ sɨŋwɨ́ ayi nɨyorɨ emɨ morɨ́ɨnɨ. E ninɨrɨ́ná rɨ́nɨŋɨ́ xwé nɨsinɨrɨ aiwɨ sɨŋwɨ́ ná wɨyinɨ nanɨmɨ opéɨrɨ aí aŋɨ́namɨ nánɨ nɨpeyirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ. Sɨŋwɨ́ ɨ́wɨ́ nánɨ móɨ́yi tɨ́nɨ néɨsáná nɨperɨ́ná Gorɨxo rɨ́á anɨŋɨ́ wearɨŋɨ́yo nɨsikeaárɨrɨ́náyɨ́ ayɨ́ naŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Rɨ́á anɨŋɨ́ wearɨŋe xweamɨ́í mɨpé anɨŋɨ́ nɨsirɨ rɨ́á enɨ anɨŋɨ́ rɨnɨrɨ yarɨŋerɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Saxɨ́ aiwáyo moarɨgɨ́ápa Gorɨxo rɨ́á enɨ ámá nɨ́nɨ naŋɨ́ oimónɨ́poyɨnɨrɨ saxɨ́nɨŋɨ́ e monɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Saxɨ́ aiwá awɨ́í imɨxarɨŋɨ́ eŋagɨ nánɨ naŋɨ́rɨnɨ. E nerɨ aí xegɨ́ awɨ́í yarɨŋɨ́pɨ anɨpá nerɨ aiwánɨŋɨ́ imónɨŋáná arɨge nerɨ ámɨ awɨ́í enɨŋoɨ? Soyɨ́né saxɨ́nɨŋɨ́ nimónɨro saxɨ́ aiwáyo awɨ́í imɨxarɨŋɨ́pa ámá nɨyonɨ píránɨŋɨ́ e nɨwirɨ́náyɨ́, sewanɨŋoyɨ́né mɨmɨ́eyoánɨpa nero píránɨŋɨ́ nɨkumɨxɨnɨro néra úɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisaso nɨwiápɨ́nɨmearɨ e pɨ́nɨ nɨwiárɨmɨ nurɨ Judia pɨropenɨsɨ́yo nɨmúrorɨ iniɨgɨ́ Jodanɨ rapáyo jɨ́arɨwámɨ dánɨ warɨ́ná oxɨ́ apɨxɨ́ epɨ́royɨ́ nero o tɨ́ŋɨ́ e awí eánáná xegɨ́ yarɨŋɨ́pa ámɨ uréwapɨyarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi wa nɨwímearo omɨ iwamɨ́ó nɨwíwapɨyiro re urɨgɨ́awixɨnɨ, “Wa negɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ ɨ́á nɨroro re rarɨgɨ́árɨnɨ, ‘Xegɨ́ oxo apɨxímɨ ananɨ emɨ mopaxɨ́rɨnɨ.’ rarɨgɨ́árɨnɨ. Wa ‘Emɨ mopaxɨ́manɨ.’ rarɨgɨ́árɨnɨ. Joxɨyá dɨŋɨ́ arɨge simónarɨnɨ? ‘Ananɨ emɨ mopaxɨ́rɨnɨ.’ rɨsimónarɨnɨ? ‘Ŋwɨ́árɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","re urɨŋɨnigɨnɨ, “Moseso eŋíná segɨ́ seárɨ́awéyo ŋwɨ́ ikaxɨ́ nurɨrɨ́ná píoɨ urɨŋɨnigɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","re urɨgɨ́awixɨnɨ, “Moseso ámá apɨxɨ́ emɨ moanɨro nánɨ ananɨ payɨ́ re rɨnɨŋɨ́pɨ ‘Nionɨ ímɨ anɨŋɨ́ emɨ móárɨnɨ.’ rɨnɨŋɨ́pɨ nearo owiowárɨ́poyɨnɨrɨ sɨŋwɨ́ neanagɨ́rɨnɨ.” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né segɨ́ dɨŋɨ́ tɨ́nɨ nɨxɨ́dɨro arɨ́kí segɨ́ apɨxɨ́ emɨ moanɨro yarɨŋagɨ́a nánɨ Moseso ŋwɨ́ ikaxɨ́ apɨ nɨrɨrɨ eaŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","E nerɨ aiwɨ xwɨyɨ́á rɨpɨ nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́rɨnɨ, ‘Gorɨxo eŋíná xwɨ́á imɨxɨrɨ aŋɨ́na imɨxɨrɨ nerɨ́ná oxɨ́ imɨxɨrɨ apɨxɨ́ imɨxɨrɨ eŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ayɨnánɨ oxo xanɨyaúmɨ pɨ́nɨ nɨwiárɨmáná xegɨ́ apɨxí tɨ́nɨ nɨkumɨxɨnɨríná ná ayɨ́ ná bɨnɨ́nɨŋɨ́ imónɨpɨsɨ́írɨnɨ.’ E nɨrɨnɨrɨ eánɨŋɨ́ eŋagɨ nánɨ xɨxegɨ́nɨ imónarɨgɨ́ímanɨ. Ná ayɨ́ ná bɨnɨ́nɨŋɨ́ nimónɨri emearɨgɨ́írɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ayaú nɨmeánɨmɨ nemerɨ́ná Gorɨxo ŋwɨrárɨŋɨ́ eŋagɨ nánɨ pɨ́nɨ nɨwiárɨnɨmɨ mupa oépiyɨ.” nurɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","aŋɨ́yo nɨpáwirɨ ŋweaŋáná wiepɨsarɨŋowa ámɨ o meánɨgɨ́á nánɨ urɨ́ɨ́pɨ nánɨ yarɨŋɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","o re urɨŋɨnigɨnɨ, “Ámá go go xegɨ́ apɨxɨ́ emɨ nɨmorɨ wí nɨmearɨ́náyɨ́, xámɨ meaŋímɨ sɨpí wikárarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Apɨxɨ́ gí gí enɨ xegɨ́ xiagwomɨ pɨ́nɨ nɨwiárɨmɨ nurɨ womɨ nɨmeánɨrɨ́náyɨ́, xámɨ meánɨŋomɨ sɨpí wikárarɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","14","Ámá wí Jisaso wigɨ́ niaíwɨ́ oimónɨ́poyɨnɨrɨ wé wikwiárɨnɨ nɨmeámɨ báná wiepɨsarɨŋowa mɨxɨ́ urarɨŋagɨ́a Jisaso awa pɨ́rɨ́ urakianɨro yarɨŋagɨ́a nɨwɨnɨrɨ wikɨ́ dɨŋɨ́ nɨwiaiwirɨ re urɨŋɨnigɨnɨ, “Soyɨ́né pɨ́rɨ́ murakipanɨ. Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ sɨŋánɨ nimónɨrɨ́ná o ámá niaíwɨ́ tɨyɨ́ yapɨ nionɨ dɨŋɨ́ nɨkwɨ́róɨ́áyo meŋweanɨ́á eŋagɨ nánɨ soyɨ́né pɨ́rɨ́ murakipanɨ. Nionɨ tɨ́e nánɨ xe obɨ́poyɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nionɨ nepa seararɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ niaíwɨ́pia xanɨyaúmɨ dɨŋɨ́ ɨkwɨ́roro sɨmaŋwɨ́yónɨŋɨ́ yeáyɨ́ urɨ́nɨro yarɨgɨ́ápánɨŋɨ́ Gorɨxomɨ e mepa nerɨ́náyɨ́, o xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́ápimɨ wí páwipɨ́rɨ́ámanɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","niaíwɨ́pia wímɨ nɨmearɨ sáɨ́yo nɨŋwɨrárɨnɨmáná wé seáyɨ e wikwiárɨrɨ “Gɨ́ ápo píránɨŋɨ́ oumenɨ.” rɨrɨ nɨwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisaso nɨwiápɨ́nɨmeámɨ aŋɨ́ wíyo umɨnɨrɨ yarɨ́ná ámá wo o tɨ́ŋɨ́ e nánɨ mɨ́rɨ́ nɨbɨrɨ sɨ́mɨmaŋɨ́mɨ dánɨ xómɨŋɨ́ nɨyɨkwirɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Nearéwapɨyarɨŋɨ́ naŋoxɨnɨ, arɨge nerɨ́ná nionɨ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́ŋáonɨ imónɨmɨ́árɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","o “Jisaso Gorɨxorɨ́anɨ?” oyaiwinɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ pí nánɨ ‘Nearéwapɨyarɨŋoxɨnɨ́ nɨnɨrɨrɨ́ná ‘Naŋoxɨnɨ́ nɨrɨ́ɨnɨ? Ámá wí naŋɨ́manɨ. Sa Gorɨxo naŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Joxɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ nánɨ rɨxa nɨjɨ́á imónɨŋɨnɨ. ‘Nɨwiápɨ́nɨmearɨ ámá wí mɨpɨkipa erɨ́ɨnɨ. Ámá wí tɨ́nɨ ɨ́wɨ́ minɨpa erɨ́ɨnɨ. Ɨ́wɨ́ mɨmeapa erɨ́ɨnɨ. Yapɨ́ murɨpa erɨ́ɨnɨ. Yapɨ́ nurepɨsirɨ ɨ́wɨ́ murápɨpa erɨ́ɨnɨ. Inókímɨ tɨ́nɨ ápomɨ tɨ́nɨ wéyo merɨ́ɨnɨ.’ E rɨnɨŋɨ́pɨ joxɨ rɨxa nɨjɨ́á imónɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","o re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, apɨ nɨpɨnɨ sɨnɨ ononɨ imónɨŋaé dánɨ pɨ́rɨ́ mɨwiaíkí píránɨŋɨ́ nɨxɨ́da bɨŋárɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisaso sɨŋwɨ́ agwɨ́ nɨwɨnɨrɨ wá nɨwianɨrɨ nánɨ re urɨŋɨnigɨnɨ, “Nɨpɨnɨ nɨxɨ́dɨrɨ aiwɨ ámɨ bɨ sɨnɨrɨnɨ. Joxɨ nurɨ dɨxɨ́ iyɨ́á ɨ́á tɨ́nɨ xwɨ́á tɨ́nɨ amɨpí dɨxɨ́yɨ́ nɨgwɨ́ nánɨ bɨ́ nerɨ nɨgwɨ́ meáɨ́yɨ́ ámá aiwá nánɨ ikeamónɨro aikɨ́ nánɨ ikeamónɨro egɨ́áyo mɨnɨ wíɨrɨxɨnɨ. E nemoxɨ nɨbɨrɨ nɨnɨxɨ́dɨmerɨ́náyɨ́, rɨ́wéná nɨpémáná aŋɨ́namɨ nánɨ nɨpeyirɨ́ná amɨpí joxɨyá aga xwé nɨdéronɨ́árɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","o amɨpí wí mɨmúrónɨŋo eŋagɨ nánɨ dɨŋɨ́ sɨpí nɨwirɨ e mepaxɨ́ wimónɨ́agɨ nánɨ sɨ́mɨmaŋɨ́ kɨpɨŋɨ́ nɨyimɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sɨ́mɨmaŋɨ́ kɨpɨŋɨ́ nɨyimɨ úagɨ Jisaso xegɨ́ wiepɨsarɨŋowamɨ sɨŋwɨ́ nɨwɨnɨmerɨ re urɨŋɨnigɨnɨ, “Amɨpí xwé tɨ́gɨ́áyɨ́ ananɨ Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́roro o xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́e páwipaxɨ́manɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","awa xɨ́o rɨ́ɨ́pɨ nánɨ ududɨ́ yarɨŋagɨ́a nɨwɨnɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Niaíwoyɨ́né, ámá wí anɨŋɨ́ minɨ́ yanɨro nero aiwɨ ananɨ Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́roro o xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́e páwipaxɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‘Kamerɨ́ eŋɨ́ rapɨrapɨ́ gwɨ́ kiwearɨgɨ́á óɨ́yimɨ ananɨ páwipaxɨ́rɨnɨ.’ rɨyaiwiarɨŋoɨ? Ámá amɨpí xwé tɨ́gɨ́áyɨ́ kamerɨ́ eŋɨ́ óɨ́yimɨ mɨpáwipa éɨ́pɨ́nɨŋɨ́ Gorɨxo seameŋweanɨ́e nánɨ ananɨ páwipaxɨ́manɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","awa ududɨ́ nikárɨnɨro re urɨgɨ́awixɨnɨ, “E imónɨŋáná ámá gɨyo Gorɨxo yeáyɨ́ uyimɨxemeanɨ́árɨ́anɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisaso sɨŋwɨ́ agwɨ́ nɨwɨnɨmáná re urɨŋɨnigɨnɨ, “Ámá wí mepa epaxɨ́ nimónɨmáná aiwɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ ananɨrɨnɨ. Amɨpí Gorɨxo mepa epaxɨ́ wí mimónɨŋagɨ nánɨ oyá dɨŋɨ́ tɨ́nɨ epaxɨ́rɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitao re urɨŋɨnigɨnɨ, “Ai, none negɨ́ amɨpí rɨxa pɨ́nɨ nɨwiárɨmɨ joxɨ rɨxɨ́dɨmearɨŋwɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisaso re urɨŋɨnigɨnɨ, “Nepa seararɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ nionɨ dɨŋɨ́ nɨnɨkwɨ́roro xwɨyɨ́á nionɨ nánɨ yayɨ́ seainarɨŋɨ́pɨ wáɨ́ urɨmero enɨ éɨ́áyɨ́ xexɨrɨ́meáyoranɨ, xɨnáíwamɨranɨ, xegɨ́ niaíwɨ́yoranɨ, xegɨ́ aŋɨ́ranɨ, xegɨ́ aiwá omɨŋɨ́ranɨ, pɨ́nɨ nɨwiárɨmɨ nɨxɨ́dɨrɨ́náyɨ́, sɨnɨ mɨpé xwɨ́áyo nɨŋwearɨ́ná xexɨrɨ́meá imónɨ́áyɨ́ xɨnáíwa imónɨ́áyɨ́ xegɨ́ niaíwɨ́ imónɨ́áyɨ́ xɨnáíwa imónɨ́áyɨ́ xegɨ́ niaíwɨ́ imónɨ́áyɨ́ xegɨ́ aŋɨ́ imónɨ́áyɨ́ xegɨ́ aiwá omɨŋɨ́ imónɨ́áyɨ́ wiwanɨŋɨ́yɨ́ pɨ́nɨ wiárɨ́áyo seáyɨ émɨ múrónɨnɨ́árɨnɨ. E nerɨ aí nionɨ nɨxɨ́darɨŋagɨ́a xeanɨŋɨ́ enɨ nɨwímeanɨ́árɨnɨ. Ayɨ́ enɨ aŋɨ́ rɨ́wéná imónɨnɨ́áyo dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́áyɨ́ nimónɨro ŋweapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E nerɨ aiwɨ ámá ‘Xwéonɨrɨnɨ.’ nɨrɨro xámɨ xámɨ imónarɨgɨ́áyɨ́ nɨperɨ́ná surɨ́má yárɨpɨ́rɨ́árɨnɨ. Agwɨ ríná surɨ́má ŋweagɨ́áyɨ́ nɨperɨ́ná xámɨŋɨ́yo múropɨrɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Awa óɨ́yo nuro aŋɨ́ yoɨ́ Jerusaremɨ nánɨ nɨyirɨ́ná wiepɨsarɨŋowa Jisaso arɨ́kí aŋɨ́ apimɨ nánɨ nɨyirɨ xámɨ umeaarɨŋagɨ nɨwɨnɨro ududɨ́ ninɨro ámá Jisasomɨ xɨ́darɨgɨ́áyɨ́ wí enɨ ayá sɨ́wɨ́ uroarɨŋagɨ o ámɨ xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ ná dámɨnɨ e nɨmɨ́aurɨ ámɨ xɨ́omɨ wa wipɨ́rɨ́ápɨ nánɨ áwaŋɨ́ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","re urɨŋɨnigɨnɨ, “None Jerusaremɨ nánɨ nɨyirane rémóáná ámá imónɨŋáonɨ re nikeaárɨpɨ́rɨ́árɨnɨ. Ámá wo nionɨ nánɨ mɨyɨ́ uráná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ nionɨ xwɨrɨxɨ́ nɨnɨmero xwɨyɨ́á nɨnɨmeárɨro ‘Sa joxɨnɨrɨnɨ.’ nɨnɨrɨro nɨpɨkímoanɨro wauyowamɨ mɨnɨ nɨwipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mɨnɨ nɨwíáná awa rɨperɨrɨ́ niro reaŋwɨ́ núrɨro iwaŋɨ́ nearo nɨníɨ́asáná nɨpɨkipɨ́rɨ́árɨnɨ. Nɨnɨpɨkiro aiwɨ sɨ́á wɨyaú wɨyi óráná ámɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebediomɨ xewaxowaú Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ aŋwɨ e nuri Jisasomɨ re urɨgɨ́isixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, yawawi pí pí nánɨ yarɨŋɨ́ síwíyɨ́ joxɨ ananɨ nɨyeaiirɨ́árɨ́anɨ?” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","o re urɨŋɨnigɨnɨ, “Nionɨ pí eaiimɨ nɨrarɨŋiɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","awaú yawawi enɨ ámɨná imónɨ́winigɨnɨrɨ wiepɨsarɨŋɨ́ wɨ́a yawawi sɨmaŋwɨ́yónɨŋɨ́ yeáyɨ́ yeaurɨ́nɨ́ɨ́rɨxɨnɨrɨ re urɨgɨ́isixɨnɨ, “Joxɨ idáná ámɨnáoxɨ nimónɨrɨ meŋweaŋáná ámá nɨ́nɨ sɨmaŋwɨ́yónɨŋɨ́ yeáyɨ́ rurɨ́náná yawawi joxɨyá wéyo mɨnɨ mɨnɨ oŋweápiyɨnɨrɨ sɨŋwɨ́ yeanɨrɨréɨranɨ?” urɨ́agɨ́i aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisaso re urɨŋɨnigɨnɨ, “Awagwí yarɨŋɨ́ niarɨgɨ́ípɨ nánɨ nɨjɨ́á mimónɨpa neri nánɨ yarɨŋɨ́ niarɨŋiɨ.” nurɨrɨ ewayɨ́ xwɨyɨ́á ámá wa xɨ́omɨ pɨkipɨ́rɨ́á eŋagɨ nánɨ áwaŋɨ́ nurɨrɨ́ná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awagwí iniɨgɨ́ sɨxɨ́ nionɨ nɨmɨ́áwá ananɨ nɨpaxɨ́ imónɨpɨsɨ́íranɨ? Iniɨgɨ́ waxɨ́yo nionɨ xémɨ́ápɨ awagwí enɨ ananɨ xepaxɨ́ imónɨpɨsɨ́íranɨ?” yarɨŋɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","awaú re urɨgɨ́isixɨnɨ, “Ananɨrɨnɨ. Yawawi nepaxɨ́rɨnɨ.” urɨ́agɨ́i o re urɨŋɨnigɨnɨ, “Iniɨgɨ́ nionɨ nɨmɨ́áwá awagwí enɨ nɨpɨsɨ́írɨnɨ. Iniɨgɨ́ waxɨ́ nionɨ xémɨ́ápɨ awagwí enɨ xepɨsɨ́írɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","E nerɨ aiwɨ ‘Woxɨ rɨ́mɨ dánɨ ŋweaɨ. Woxɨ rɨ́mɨ dánɨ ŋweaɨ.’ wí earɨpaxonɨmanɨ. Gorɨxo xewanɨŋo earɨpaxɨ́rɨnɨ. Xɨ́o wimónarɨŋɨ́ goxɨ goxɨ ‘Jisasomɨ mɨnɨ mɨnɨ ŋweápiyɨ.’ earɨpaxɨ́rɨnɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","wiepɨsarɨŋɨ́ wé wúkaú wɨ́a Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ e urarɨŋagɨ́i arɨ́á nɨwiro wikɨ́ dɨŋɨ́ nɨwiaiwiro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisaso “Nionɨ tɨ́ŋɨ́ aŋwɨ re bɨ́poyɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Émáyɨ́yá ámɨná meŋweagɨ́áwa seáyɨ e nimónɨro wigɨ́ ámáyo ayá mɨrɨmɨxɨ́ peayɨ́ wianarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","E nerɨ aiwɨ awa yarɨgɨ́ápa axɨ́pɨ mimónɨpanɨ. Go go segɨ́ rárónɨŋɨ́ nimónɨrɨ́náyɨ́ wɨ́oyɨ́néyá omɨŋɨ́ seaiiarɨŋo nimónɨrɨ arɨrá seaíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Go go xámɨ xɨráónɨŋɨ́ imónɨ́oxɨ xɨnáínɨŋɨ́ nimónɨrɨ ámá nɨyonɨ saŋɨ́ urápɨméɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nionɨ enɨ ámá imónɨŋáonɨ aí ámá saŋɨ́ nɨrápɨpɨ́rɨ nánɨ weapɨŋáonɨmanɨ. Ámá nɨ́nɨ nánɨ nupeirɨ gwɨ́nɨŋɨ́ roayíróɨmɨgɨnɨrɨ weapɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisaso wiepɨsarɨŋowa tɨ́nɨ nawínɨ sɨnɨ Jerusaremɨ nánɨ nɨyiro aŋɨ́ áwɨnɨ e bimɨ xegɨ́ yoɨ́ Jeriko nɨrémoro rɨxa aŋɨ́ apimɨ wiárɨ́ múroanɨro yarɨ́ná ámá sɨŋwɨ́ supárɨŋɨ́ wo —O omɨŋɨ́ mepaxo eŋagɨ nánɨ óɨ́ maŋɨ́pá tɨ́nɨ nɨŋweámáná nɨgwɨ́ nánɨ tɨ́nɨ aiwá nánɨ tɨ́nɨ rɨxɨŋɨ́ urarɨŋorɨnɨ. Xano xegɨ́ yoɨ́ Timiasorɨnɨ. Xɨ́o xegɨ́ yoɨ́ Batimiasorɨnɨ. O óɨ́ maŋɨ́pá tɨ́nɨ nɨŋwearɨ́ná arɨ́á wíɨ́yɨ́ re wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nasaretɨ dáŋɨ́ Jisaso daiwo pwarɨnɨ.” rarɨŋagɨ́a arɨ́á e nɨwirɨ rɨ́aiwá eŋɨ́ tɨ́nɨ re rayiŋɨnigɨnɨ, “Jisasoxɨ, rárɨ́awé mɨxɨ́ ináyɨ́ Depitoyáoxɨnɨ, wá nɨwianeɨ.” urarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ámá wí mɨxɨ́ rɨ́á tɨ́ŋɨ́ nurɨro “Rɨxa pɨ́nɨ wiáreɨ.” urɨ́agɨ́a aiwɨ arɨ́kí wínɨ eŋɨ́ tɨ́nɨ rɨ́aiwá re rayiŋɨnigɨnɨ, “Rárɨ́awé mɨxɨ́ ináyɨ́ Depitoyáoxɨnɨ, wá nɨwianeɨ.” urayarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisaso xegɨ́ pwarɨŋe nɨrómáná re rɨŋɨnigɨnɨ, “Omɨ rɨ́aiwá urɨ́poyɨ.” urɨ́agɨ ayɨ́ omɨ rɨ́aiwá nurɨro re urɨgɨ́awixɨnɨ, “O wiárɨ́ nɨmúroarɨnɨrɨ ayá sɨ́wɨ́ mɨrɨropanɨ. Joxɨ nánɨ rɨ́aiwá rɨrarɨnɨ. Rɨxa Wiápɨ́nɨmeaɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","iyɨ́á nɨpánɨrɨ ŋweaŋɨ́ nɨpírɨrɨ emɨ nɨmómɨ nɨwiápɨ́nɨmeámɨ nurɨ Jisasomɨ wímeááná ");
INSERT INTO aak_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","o re urɨŋɨnigɨnɨ, “Nionɨ pí simɨ nánɨ nɨrarɨŋɨnɨ?” urɨ́agɨ sɨŋwɨ́ supárɨŋo re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, nionɨ rɨxa sɨŋwɨ́ oanɨmɨnɨrɨ rɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","o re urɨŋɨnigɨnɨ, “Joxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ nánɨ dɨxɨ́ sɨŋwɨ́ rɨxa naŋɨ́ anɨ́ɨnɨ. Dɨxɨ́ aŋɨ́ uɨ.” uráná re eŋɨnigɨnɨ. Ámɨ rɨxa sɨŋwɨ́ noxoarɨ nanɨrɨ́ná óɨ́ e dánɨ Jisasomɨ rɨ́wɨ́yo númɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jerusaremɨ tɨ́ŋɨ́ aŋwɨ e nɨrémorɨ́ná aŋɨ́ onɨmiá biaú xegɨ́ yoɨ́ rɨpiaúrɨnɨ. Betɨpasi tɨ́nɨ Betani tɨ́nɨ apiaúrɨnɨ. Aŋɨ́ apiaúyɨ́ dɨ́wɨ́ xegɨ́ yoɨ́ Oripipá tɨ́ŋɨ́ e nɨrémoro Jisaso xegɨ́ wiepɨsarɨŋɨ́yɨ́ waúmɨ re urowárɨŋɨnigɨnɨ, “Awagwí aŋɨ́ dayo ikwɨ́rónɨŋɨ́pimɨ nánɨ nuri rɨxa nɨrémori dogí sɨpɨkɨ́ wo ámá wí sɨnɨ seáyɨ e éɨ́ mɨŋwearɨgɨ́o gwɨ́ yurárɨnɨŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná níkweari nɨmeámɨ bɨ́piyɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ámá wí ‘Pí nánɨ íkweaarɨŋiɨ?’ yarɨŋɨ́ e eaíánáyɨ́, re urɨ́piyɨ, ‘Yegɨ́ Ámɨnáo dogí romɨ seáyɨ e nɨxeŋwearɨ unɨ nánɨ íkweaarɨŋwiɨ. Rɨxa nɨxeŋwearɨ nɨmeámɨ numáná ámɨ re wɨ́rénapɨnɨŋoɨ.’ urɨ́piyɨ.” urowáráná ");
INSERT INTO aak_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","awaú nuri ámá wíyoyá aŋɨ́ ɨ́wí e dogí sɨpɨkɨ́ wo gwɨ́ nɨyurárɨnɨmáná óɨ́ e roŋagɨ nɨwɨnɨri íkweaarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ámá wí dae rogɨ́áyɨ́ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Awagwí pí nánɨ dogí o íkweaarɨŋiɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","awaú Jisaso “Re urɨ́piyɨ.” urɨ́ɨ́pɨ axɨ́pɨ uráná ayɨ́ xe oíkweápiyɨnɨrɨ sɨŋwɨ́ wɨnɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","awaú dogí sɨpɨko Jisaso tɨ́ŋɨ́ e nɨméra nɨbɨri nɨwárɨmáná Jisaso seáyɨ e éɨ́ xeŋweanɨ nánɨ wigɨ́ iyɨ́á seáyɨ e ikwiáráná o seáyɨ e nɨxeŋwearɨ nɨmeámɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ámá obaxɨ́ wí eŋíná mɨxɨ́ ináyowamɨ yayɨ́ wianɨro nánɨ wigɨ́ iyɨ́á nɨpírayiro óɨ́ e íkwiaŋwɨ́ neapára warɨgɨ́ápa axɨ́pɨ wigɨ́ iyɨ́á óɨ́ e íkwiaŋwɨ́ neapára warɨ́ná wí óɨ́pá tɨ́ŋɨ́ e írɨmɨŋɨ́ nánɨ́nɨŋɨ́ íkwiaŋwɨ́ nɨdoro óɨ́ e íkwiaŋwɨ́ neapára warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jisaso áwɨnɨ e eŋáná xámɨ warɨgɨ́áyɨ́ tɨ́nɨ rɨ́wɨ́yo warɨgɨ́áyɨ́ tɨ́nɨ rɨ́aiwá re nɨra ugɨ́awixɨnɨ, “Gorɨxomɨ seáyɨ e oumeaneyɨ. Ámá Ámɨná Gorɨxo urowárénapɨ́agɨ barɨŋɨ́ ro oyá dɨŋɨ́ tɨ́nɨ seáyɨ e imónɨ́wɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Arɨ́owa mɨxɨ́ ináyɨ́ Depitoyá xwioxɨ́yo ŋweaagɨ́ápa xwioxɨ́ nene ŋweanɨ́wá nánɨ nimóga barɨŋɨ́pɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ seáyɨ e imónɨ́wɨnɨgɨnɨ. Aŋɨ́namɨ seáyɨ e imónɨŋomɨ seáyɨ e oumeaneyɨ.” nɨra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Rɨxa Jerusaremɨ nɨrémoro Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ wáɨ́ ikwɨ́rónɨŋɨ́ e dánɨ wenɨŋɨ́ amɨ amɨ nemerɨ rɨxa sɨ́á órarɨŋagɨ nɨwɨnɨrɨ xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú tɨ́nɨ nawínɨ aŋɨ́ yoɨ́ Betani nánɨ nuro sá wegɨ́á ");
INSERT INTO aak_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","wɨ́ápɨ tɨ́nɨ nɨwiápɨ́nɨmeámɨ Betani pɨ́nɨ nɨwiárɨmɨ nurɨ́ná Jisaso agwɨ́ wíagɨ ");
INSERT INTO aak_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Íkɨ́á yoɨ́ pikɨ́yɨ rɨnɨŋɨ́ wɨna, ɨwɨ́ inɨŋɨ́na jɨ́amɨ jɨ́ina roŋagɨ nɨwɨnɨrɨ sogwɨ́ nánɨ pɨ́á emɨnɨrɨ aŋwɨ e nurɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ná mɨwé ɨwɨ́nɨ inarɨŋagɨ nɨwɨnɨrɨ xegɨ́ ná wearɨŋíná sɨnɨ mimónɨŋagɨ nánɨ ná mɨweŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","wiepɨsarɨŋowa arɨ́á egɨ́e dánɨ íkɨ́ánamɨ re urɨŋɨnigɨnɨ, “íkɨ́á rɨnaxɨnɨ, ámá wí sogwɨ́ mɨdanɨpa epɨ́rɨ́a nánɨ ná mɨwepa sa anɨŋɨ́ re éɨrɨxɨnɨ.” urarɨ́ná wiepɨsarɨŋowa arɨ́á wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusaremɨ nɨrémoro aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwiro Jisaso re eŋɨnigɨnɨ. Ámá aŋɨ́ iwámɨ ínɨmɨ bɨ́ inarɨgɨ́áyo mɨxɨ́dámɨ́ wiowárɨrɨ ámá nɨgwɨ́ senisɨ́ ninayiro tarɨgɨ́áyɨ́yá íkwiaŋwɨ́ mɨmɨwiárɨ́ erɨ ámá iŋɨ́ xawiówɨ́ rɨdɨyowá nánɨ bɨ́ inarɨgɨ́áyɨ́ íkwiaŋwɨ́ éɨ́ ŋweaarɨgɨ́ápɨ mɨmɨwiárɨ́ erɨ ");
INSERT INTO aak_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ámá saŋɨ́ amɨpí xwaŋwɨ́ níkwónɨmɨ aŋɨ́ iwámɨ áwɨnɨmɨ aŋwɨ e imónɨŋe xemoarɨgɨ́áyo pɨ́rɨ́ wiaíkímɨ́ wirɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","E nemáná iwamɨ́ó nuréwapɨyirɨ́ná mɨŋɨ́ nirorɨ re urɨŋɨnigɨnɨ, “Re mɨrɨnɨpa renɨ, ‘Aŋɨ́ Gorɨxonɨyáiwá nánɨ re rɨpɨ́rɨ́árɨnɨ, “Ámá gwɨ́ wɨrɨ́ wɨrí nɨ́nɨ Gorɨxomɨ xwɨyɨ́á urɨpɨ́rɨ́a nánɨ oyá aŋiwárɨnɨ.” rɨpɨ́rɨ́árɨnɨ.’ mɨrɨnɨpa renɨ? E nɨrɨnɨrɨ aiwɨ soyɨ́né ɨ́wɨ́ meaarɨgɨ́áyɨ́ yarɨgɨ́ápa axɨ́pɨ́nɨŋɨ́ nero nánɨ aŋɨ́ riwá ɨ́wɨ́ meaarɨgɨ́áyɨ́yá aŋɨ́nɨŋɨ́ imónɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ ámá wí “Jisaso e neararɨnɨ. E neararɨnɨ.” rarɨŋagɨ́a arɨ́á nɨwiro ámáyɨ́ o xwɨyɨ́á uréwapɨyarɨŋɨ́yɨ́ nánɨ rɨxa dɨŋɨ́ nɨpɨkínɨro nɨ́nɨ Jisasomɨnɨ xɨ́dɨpɨ́rɨxɨnɨrɨ wáyɨ́ nero ínɨmɨ omɨ pɨkianɨro nánɨ mekaxɨ́ nɨméra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sɨ́á ayɨ́ ayo sɨ́á órarɨ́ná o wiepɨsarɨŋowa tɨ́nɨ Jerusaremɨ pɨ́nɨ nɨwiárɨmɨ nuro aŋɨ́ wíyo sá weagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jisaso wiepɨsarɨŋowa tɨ́nɨ sá wegɨ́á wɨ́ápɨ tɨ́nɨ nɨwiápɨ́nɨmearo Jerusaremɨ nánɨ nurɨ́ná wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Íkɨ́á pikɨ́na mɨ́kɨ́ aí tɨ́nɨ rɨxa yeáyɨ́ yárɨ́agɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitao Jisaso agíná éɨ́pɨ nánɨ dɨŋɨ́ winɨ́agɨ mɨŋɨ́ sɨ́ŋá neánɨrɨ re urɨŋɨnigɨnɨ, “Ai, nearéwapɨyarɨŋoxɨnɨ, íkɨ́á pikɨ́na joxɨ agíná ramɨxárɨ́ɨ́na rɨxa yɨweánárɨnɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","o “Emɨmɨ́ nionɨ éápa awa enɨ epaxɨ́rɨnɨ.” nɨyaiwirɨ nánɨ re urɨŋɨnigɨnɨ, “Soyɨ́né enɨ Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́róa úpoyɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nionɨ nepa seararɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ ‘Dɨ́wɨ́ rɨpá nɨja rawɨrawáyo opiéronɨ.’ rɨrɨ dɨŋɨ́ ná bɨnɨ morɨ xɨ́o rɨ́ɨ́pɨ ‘Xɨxenɨ imónɨnɨŋoɨ.’ yaiwirɨ nerɨ́náyɨ́, Gorɨxoyá dɨŋɨ́ tɨ́nɨ xɨxenɨ enɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ayɨnánɨ soyɨ́né woxɨ woxɨ Gorɨxomɨ yarɨŋɨ́ nɨwirɨ́ná ‘Nionɨ re emɨ́árɨnɨ.’ urɨro omɨ dɨŋɨ́ wɨkwɨ́roro ‘Gorɨxoyá dɨŋɨ́ tɨ́nɨ xɨxenɨ imónɨnɨ́árɨnɨ.’ yaiwiro nerɨ́náyɨ́, oyá dɨŋɨ́ tɨ́nɨ xɨxenɨ imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Soyɨ́né woxɨ woxɨ éɨ́ nɨroro Gorɨxomɨ yarɨŋɨ́ nɨwirɨ́náyɨ́, ámá wí sɨpí seaikárɨ́áyɨ́ wikɨ́ mɨwónɨpa nero yokwarɨmɨ́ wiíɨ́rɨxɨnɨ. E nerɨ́náyɨ́, segɨ́ ápo aŋɨ́namɨ ŋweaŋo sɨpí soyɨ́né wimɨxɨ́ápɨ nánɨ enɨ yokwarɨmɨ́ seaiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","E mepa nerɨ́náyɨ́, aŋɨ́namɨ ŋweaŋo soyɨ́né maŋɨ́ pɨ́rɨ́ wiaíkigɨ́ápɨ nánɨ yokwarɨmɨ́ seaiinɨ́ámanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Rɨxa Jerusaremɨ nɨrémoro Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ ínɨmɨ aŋɨ́ emearɨ́ná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ omɨ nɨwímearo ");
INSERT INTO aak_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","re urɨgɨ́awixɨnɨ, “Aga go rɨrɨ́agɨ ámá aŋɨ́ rɨdɨyowá yarɨŋwáiwá riwámɨ bɨ́ inarɨgɨ́áyo mɨxɨ́dámɨ́ éɨnigɨnɨ? Dɨŋɨ́ goyá tɨ́nɨ e éɨnigɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ enɨ yarɨŋɨ́ bɨ oseaimɨnɨ. Soyɨ́né nionɨyápɨ áwaŋɨ́ nɨránáyɨ́, nionɨ enɨ ‘E éɨrɨxɨnɨ.’ nɨrɨŋo nánɨ ananɨ áwaŋɨ́ searɨmɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","re urɨŋɨnigɨnɨ, “Yarɨŋɨ́ nionɨyá rɨpɨrɨnɨ. Jono wayɨ́ nɨneameaia wago aŋɨ́namɨ ŋweaŋoyá dɨŋɨ́ tɨ́nɨ wayɨ́ nɨneameaia wagɨ́ranɨ? Xɨ́oyá dɨŋɨ́ tɨ́nɨ yagɨ́ranɨ? Nionɨyá apɨ nánɨ xámɨ áwaŋɨ́ nɨrɨ́poyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","wiwanɨŋowa dɨŋɨ́ nɨmoro ínɨmɨ yarɨŋɨ́ re niga ugɨ́awixɨnɨ, “None ‘Jono Gorɨxo dɨŋɨ́ ukɨkayoŋagɨ yagɨ́rɨnɨ.’ áwaŋɨ́ e nurɨranénáyɨ́ o re nearɨnɨŋoɨ, ‘Pí nánɨ Jono searagɨ́pɨ nánɨ mɨkwɨ́ropa néra ugɨ́awixɨnɨ?’ nearɨnɨŋoɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ámɨ ínɨmɨ re rɨnɨgɨ́awixɨnɨ, “None ‘Jono xegɨ́ dɨŋɨ́ tɨ́nɨ yagɨ́rɨnɨ.’ uranɨréwɨnɨ? Oweoɨ. Ámá sɨpɨ́á re epɨ́royɨ́ egɨ́áyɨ́ iwaŋɨ́ neaeapɨ́rɨxɨnɨ.” nɨrɨnɨro —Judayɨ́ nɨ́nɨ Jono nánɨ “Gorɨxoyá wɨ́á rókiamoagɨ́ worɨ́anɨ?” yaiwiarɨgɨ́á eŋagɨ nánɨ “Apɨ enɨ xɨxenɨ urɨpaxɨ́ mimónɨnɨ.” nɨrɨnɨro ámá iwaŋɨ́ neaeapɨ́rɨxɨnɨrɨ wáyɨ́ nero nánɨ áwaŋɨ́ murɨ́ ");
INSERT INTO aak_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","re urɨgɨ́awixɨnɨ, “Oweoɨ, none majɨ́árɨnɨ.” urɨ́agɨ́a Jisaso “Nionɨ enɨ ‘Joxɨ e éɨrɨxɨnɨ.’ nɨrɨŋo nánɨ áwaŋɨ́ wí nɨsearɨmɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisaso ewayɨ́ xwɨyɨ́á wí ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwamɨ tɨ́nɨ Parisiowamɨ tɨ́nɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá wo wainɨ́ uraxɨ́ ɨwɨ́á nurɨrɨ xwɨ́ná nɨrorɨ wainɨ́ xegɨ́ iniɨgɨ́ nɨpɨ́rɨ́a nánɨ wainɨ́ sogwɨ́ xoyɨkímɨ́ enɨ́a nánɨ sɨ́ŋáyo óɨ́ nɨrɨxɨrɨ wainɨ́ omɨŋɨ́yo áwɨnɨmɨ aŋɨ́ awí ŋweapɨ́rɨ́a nánɨ seáyɨ émɨ nɨmɨra nɨpeyirɨ néɨsáná ámá wí sɨŋwɨ́ uwɨnaxɨ́dipɨ́rɨ́a nánɨ re urɨŋɨnigɨnɨ, ‘Wainɨ́ sogwɨ́ niáɨ́ éánáyɨ́ bɨ soyɨ́né segɨ́ mearo nionɨ gɨ́ mearɨ emɨ́a nánɨ nionɨyá omɨŋɨ́ rɨpimɨ ananɨ sɨŋwɨ́ nɨwɨnipɨ́rɨ́áranɨ?’ nurɨmɨ aŋɨ́ wíyo ememɨnɨrɨ nánɨ nurɨ nɨŋweáɨsáná ");
INSERT INTO aak_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","wainɨ́ rɨxa niáɨ́ eŋáná xegɨ́ omɨŋɨ́ wiiarɨgɨ́á womɨ re urowárɨŋɨnigɨnɨ, ‘Joxɨ nionɨyá wainɨ́ omɨŋɨ́yo nánɨ nurɨ iniɨgɨ́ wainɨ́ awa nionɨ nánɨ nimɨxɨrɨ iwajɨ́á niáríɨ́ápɨ nurápɨyauiɨ.’ urowárɨ́agɨ o nurɨ ");
INSERT INTO aak_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","omɨŋɨ́yo rémóáná awa re egɨ́awixɨnɨ. Ɨ́á nɨxero wé neáɨ́asáná anɨpáomɨ urowárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Anɨpáomɨ urowárɨ́agɨ́a nánɨ omɨŋɨ́ xiáwo ámɨ xegɨ́ omɨŋɨ́ wiiarɨgɨ́á ámɨ womɨ urowáráná awa re egɨ́awixɨnɨ. Omɨ xegɨ́ mɨŋɨ́yo mɨŋɨ́ roro sɨpí wikárɨro wíagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","omɨŋɨ́ xiáwo ámɨ wo urowáráná omɨ nɨpɨkiro tɨ́agɨ́a o ámɨ wamɨ urowáráná wíyo iwaŋɨ́nɨ nearo wárɨro wíyo nɨpɨkiro tɨro néɨ́asáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ámɨ wo xegɨ́ xewaxo dɨŋɨ́ sɨxɨ́ uyiŋo sɨnɨ eŋagɨ omɨ nurowárɨrɨ́ná re rɨŋɨnigɨnɨ, ‘ “Gɨ́ íwo eŋagɨ nánɨ sɨpí wí mɨwimɨxɨpa nero arɨ́á wipɨ́ráoɨ.” nimónarɨnɨ.’ rɨ́ɨ́ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","xewaxo rémóáná wainɨ́ omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwa re rɨnɨgɨ́awixɨnɨ, ‘Íwɨ́ ro xanoyá dɨŋɨ́ tɨ́ŋo eŋagɨ nánɨ omɨŋɨ́ rɨpɨ nɨ́nɨ negɨ́pɨ meaanɨ́wá nánɨ opɨkianeyɨ.’ nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","omɨ ɨ́á nɨxero nɨpɨkiro omɨŋɨ́yo bɨ́anɨrɨwámɨnɨ moaigɨ́awixɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","re urɨŋɨnigɨnɨ, “Omɨŋɨ́ xiáwo omɨŋɨ́ sɨŋwɨ́ uwɨniarɨgɨ́áwamɨ pí winɨŋoɨ? O nɨbɨrɨ awamɨ xwɨrɨ́á nikɨxerɨ ámɨ sɨŋɨ́ wa sɨŋwɨ́ uwɨnipɨ́rɨ́a nánɨ wárɨnɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á Bɨkwɨ́yo eánɨŋɨ́ rɨpɨ enɨ ɨ́á mɨropa egɨ́áranɨ? ‘Sɨ́ŋá aŋɨ́ mɨrarɨgɨ́áwa sɨ́ŋá awiaxɨ́ nánɨ pɨ́á nerɨ́ná wo “Sɨpírɨnɨ.” nɨrɨro emɨ móɨ́o nánɨ Gorɨxo “Sɨ́ŋá o tɨ́nɨ xámɨ nɨtɨrɨ́náyɨ́ aŋɨ́ eŋɨ́ neánɨrɨ naŋɨ́ imónɨnɨŋoɨ.” nɨrɨrɨ sɨ́ŋá o nɨmearɨ táná aŋɨ́ eŋɨ́ neánɨrɨ naŋɨ́ imónɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gorɨxo e éɨ́ eŋagɨ nánɨ nene sɨŋwɨ́ nɨwɨnɨrɨ́ná aga naŋɨ́ imónɨŋagɨ wɨnarɨŋwárɨnɨ.’ E eánɨŋɨ́pɨ soyɨ́né ɨ́á mɨropa egɨ́áranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","awa “None nánɨ dɨŋɨ́ nɨneaiaiwirɨ ewayɨ́ xwɨyɨ́á apɨ rɨ́a neararɨnɨ?” nɨyaiwiro rɨxa ɨ́á oxɨraneyɨnɨrɨ éɨ́áyɨ́ ámá sɨpɨ́á Jisasomɨ arɨ́á wianɨro nánɨ o tɨ́ŋɨ́ e epɨ́royɨ́ egɨ́á nánɨ wáyɨ́ nero nánɨ omɨ pɨ́nɨ nɨwiárɨmɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Awa nuro ínɨmɨ re rɨnɨgɨ́awixɨnɨ, “Omɨ pasánɨŋɨ́ nurɨrane yapɨ́ re uréwapɨyanɨ́wɨnɨ, ‘Nɨgwɨ́ nánɨ takisɨ́ émáyɨ́ nearáparɨgɨ́ápɨ sɨnɨ mɨnɨ wianɨréwɨnɨ? Mɨnɨ mɨwipa yanɨréwɨnɨ?’ uranɨ́wɨnɨ. O ‘Oweoɨ, sɨnɨ mɨnɨ mɨwipa époyɨ.’ ránáyɨ́, wauyowa omɨ ɨ́á nɨxero gwɨ́ yipɨ́ráoɨ. E mɨrɨpa nerɨ ‘Oyɨ, seyɨ́né mɨnɨ nɨwirɨ́ná apánɨ yarɨŋoɨ.’ ránáyɨ́, ámá sɨpɨ́áyɨ́ ámɨ arɨ́á bɨ mɨwí nero pɨ́nɨ wiárɨpɨ́ráoɨ.” nɨrɨnɨro Parisi wa tɨ́nɨ mɨxɨ́ ináyɨ́ Xeroto tɨ́nɨ nɨkumɨxɨnɨro emearɨgɨ́á wa tɨ́nɨ xwɨyɨ́á apɨ tɨ́nɨ pasánɨŋɨ́ uranɨro nánɨ Jisaso tɨ́ŋɨ́ e urowáráná ");
INSERT INTO aak_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","awa omɨ nɨwímearo weyɨ́ numearɨro re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, nɨnearéwapɨyirɨ́ná nepánɨ nearéwapɨyarɨŋoxɨrɨnɨ. Ámá ámɨnáowayá sɨŋwɨ́yo dánɨ aí xwɨyɨ́á ámɨ xegɨ́ bɨ mɨrɨ́ axɨ́pɨnɨ rarɨŋoxɨrɨnɨ. Sɨpí rɨrɨ naŋɨ́ rɨrɨ yarɨŋɨ́manɨ. Xwɨyɨ́á Gorɨxoyánɨ xɨxenɨ nearéwapɨyarɨŋɨ́rɨnɨ.” nurɨrɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Émáyɨ́yá mɨxɨ́ ináyɨ́ Sisaoyɨ rɨnɨŋomɨ takisɨ́ nánɨ nɨgwɨ́ mɨnɨ wiarɨŋwápɨ sɨnɨ mɨnɨ wiayanɨréwɨnɨ? Pɨ́nɨ wiáranɨréwɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sɨnɨ ananɨ mɨnɨ wianɨréwɨnɨ? Mɨnɨ mɨwipa yanɨréwɨnɨ?” urɨ́agɨ́a aiwɨ o “Yapɨ́ nɨréwapɨyanɨro rɨnɨrarɨŋoɨ?” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Soyɨ́né pí nánɨ yapɨ́ pasánɨŋɨ́ níwapɨyarɨŋoɨ? Émáyɨ́yá monɨ́ bɨ sɨŋwɨ́ wɨnanɨ nɨmeámɨ bɨ́poyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","rɨxa nɨmeámɨ báná o re urɨŋɨnigɨnɨ, “Nɨgwɨ́ rɨpimɨ yoɨ́ goyá tɨ́nɨ sɨ́mɨmaŋɨ́ goyá tɨ́nɨ ŋweanɨ?” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “Émáyɨ́yá mɨxɨ́ ináyɨ́ Sisaoyá ŋweanɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","o re urɨŋɨnigɨnɨ, “Sisaoyá sɨ́mɨmaŋɨ́ ŋweaŋagɨ nánɨ ayɨ́ oyárɨnɨ. Ayɨnánɨ mɨnɨ wíɨ́rɨxɨnɨ.” nurɨrɨ ámá Gorɨxo xewanɨŋónɨŋɨ́ imɨxɨŋɨ́ eŋagɨ nánɨ omɨ dɨŋɨ́ owɨkwɨ́rópoyɨnɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Amɨpí Gorɨxoyánɨŋɨ́ imónɨŋɨ́pɨ Gorɨxomɨ enɨ mɨnɨ wíɨ́rɨxɨnɨ.” uráná awa ududɨ́ ayá wí winɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ámá Judayɨ́ wa Sajusiyɨ rɨnɨŋɨ́ wa —Sajusiowa re rarɨgɨ́áwa, “Ámá nɨpémáná eŋánáyɨ́ wí nɨwiápɨ́nɨmeapaxɨ́manɨ.” rarɨgɨ́áwarɨnɨ. Awa nɨbɨro Jisasomɨ nɨwímearo ");
INSERT INTO aak_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","mɨŋɨ́ niroro re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, Moseso eŋíná nene nánɨ ŋwɨ́ ikaxɨ́ bɨ re nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́rɨnɨ, ‘Ámá wo sɨnɨ niaíwɨ́ memeá péánáyɨ́ xegɨ́ apɨxí sɨnɨ ŋweaŋánáyɨ́ péomɨ xexɨrɨ́meáowa wo niaíwɨ́ wiemeainɨ nánɨ aní meáwɨnɨgɨnɨ.’ e nɨrɨrɨ eaŋɨ́rɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ewayɨ́ xwɨyɨ́á rɨpɨ urɨgɨ́awixɨnɨ, “Xexɨrɨ́meáowa wé wɨ́úmɨ dáŋɨ́ waú eŋáná wo apɨxɨ́ wí nɨmearɨ niaíwɨ́ memeá péánáyɨ́ ");
INSERT INTO aak_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ámɨ xexɨrɨ́meáowa wo anímɨ nɨmearɨ o enɨ niaíwɨ́ memeá péánáyɨ́ ");
INSERT INTO aak_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","xexɨrɨ́meáowa ámɨ wo awaú egɨ́ípa axɨ́pɨ nerɨ ");
INSERT INTO aak_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","nowanɨ enɨ e néra nuro niaíwɨ́ wí memeá nɨpémáná eŋánáyɨ́ apɨxí enɨ peŋɨnigɨnɨ.” Ewayɨ́ xwɨyɨ́á Jisasomɨ e nurɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Rɨ́wéná ámá pegɨ́á nɨ́nɨyɨ́ wiápɨ́nɨmeááná xexɨrɨ́meá wé wɨ́úmɨ dáŋɨ́ waú awa enɨ nɨwiápɨ́nɨmearɨ́ná apɨxɨ́ axímɨ meagɨ́áwa eŋagɨ nánɨ apɨxí go go meaŋagɨ wɨnanɨ́wárɨ́anɨ?” yarɨŋɨ́ e wíáná ");
INSERT INTO aak_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né xwɨyɨ́á Gorɨxoyá Bɨkwɨ́yo eánɨŋɨ́pɨ nánɨ nɨjɨ́á mimónɨpa ero eŋɨ́ sɨxɨ́ eánɨŋɨ́ Gorɨxoyápɨ nánɨ enɨ nɨjɨ́á mimónɨpa ero nero nánɨ xwɨyɨ́á wasɨwá rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pegɨ́áyɨ́ nɨwiápɨ́nɨmearóná ámɨ meánɨpɨ́rɨ́ámanɨ. Aŋɨ́najɨ́ aŋɨ́namɨ ŋweáwa imónɨgɨ́ápa axɨ́pɨ e ŋweapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","E nɨrɨrɨ aiwɨ segɨ́ dɨŋɨ́ ‘Pegɨ́áyɨ́ ámɨ wiápɨ́nɨmeapaxɨ́manɨ.’ yaiwiarɨgɨ́áyɨ́ nánɨ xwɨyɨ́á bɨ osearɨmɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Pegɨ́áyɨ́ ámɨ nɨwiápɨ́nɨmeapɨ́rɨ́árɨnɨ. Xwɨyɨ́á eŋíná Moseso íkɨ́á onɨmiánáɨna rɨ́á mɨnɨ́ ápiáwɨ́ wearɨŋagɨ wɨnɨŋɨ́pɨ nánɨ Bɨkwɨ́yo nɨrɨnɨrɨ eánɨŋɨ́pɨ sɨnɨ ɨ́á mɨropa regɨ́awixɨnɨ? Moseso rɨ́á apimɨ sɨŋwɨ́ wɨnáná xegɨ́ xiáwowa Ebɨrɨ́amo tɨ́nɨ Aisako tɨ́nɨ Jekopo tɨ́nɨ awa pegɨ́ámɨ eŋáná aiwɨ omɨ Gorɨxo re urɨŋɨnigɨnɨ, ‘Nionɨ dɨxɨ́ ráwowa Ebɨrɨ́amo tɨ́nɨ Aisako tɨ́nɨ Jekopo tɨ́nɨ awayá Ŋwɨ́á imónɨŋáonɨrɨnɨ.’ E urɨ́agɨ nánɨ awa pegɨ́áwa aiwɨ wigɨ́ dɨŋɨ́ sɨnɨ sɨŋɨ́ imónɨŋagɨ́a nánɨ Gorɨxo ‘Awayá Ŋwɨ́áonɨrɨnɨ.’ rɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","O ámá xɨ́omɨ dɨŋɨ́ nɨwɨkwɨ́roro péɨ́á aí ayɨ́ sɨnɨ wigɨ́ Ŋwɨ́áorɨnɨ. Ámá xɨ́omɨ dɨŋɨ́ mɨwɨkwɨ́ró pegɨ́á tɨ́nɨ sɨnɨ sɨŋɨ́ ŋweagɨ́á tɨ́nɨ aiwɨ wigɨ́ Ŋwɨ́áomanɨ. Soyɨ́né dɨŋɨ́ aga wasɨwá moarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wo nɨbɨrɨ Jisaso Sajusiowa tɨ́nɨ xwɨyɨ́á xɨmɨxɨmɨ́ ninɨro rɨnarɨŋagɨ́a nɨwɨnɨrɨ Jisaso rɨxa píránɨŋɨ́ ureŋwɨpearɨŋagɨ arɨ́á nɨwirɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́ nɨyonɨ gɨ́mɨnɨ gɨpɨ seáyɨ e imónɨnɨ?” yarɨŋɨ́ e wíagɨ ");
INSERT INTO aak_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisaso re urɨŋɨnigɨnɨ, “Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́ seáyɨ e imónɨŋɨ́pɨ rɨpɨrɨnɨ, ‘Isɨrerɨyɨ́né arɨ́á époyɨ. Negɨ́ Ámɨná Gorɨxo ná wonɨ onɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gorɨxomɨ dɨŋɨ́ sɨxɨ́ nuyirɨ́ná onɨmiápɨ onɨmiápɨ muyipa époyɨ. Dɨŋɨ́ sɨxɨ́ uyiro dɨŋɨ́ wɨkwɨ́roro eŋɨ́ neánɨro xɨ́dɨro éɨ́rɨxɨnɨ.’ Ŋwɨ́ ikaxɨ́ seáyɨ e imónɨŋɨ́pɨ apɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ámɨ axɨ́pɨ nɨrɨnɨrɨ eánɨŋɨ́ bɨ rɨpɨrɨnɨ, ‘Ámá aŋɨ́ nemerɨ́ná sɨŋwɨ́ wɨnarɨŋɨ́yɨ́ nánɨ wará dɨxɨ́ nánɨ dɨŋɨ́ sɨpí siarɨŋɨ́pa axɨ́pɨ dɨŋɨ́ sɨpí wirɨ́ɨnɨ.’ Ámɨ bɨ eánɨŋɨ́pɨ apɨrɨnɨ. Gorɨxoyá ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́yɨ́ rɨpiaúmɨ wí seáyɨ e mimónɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ meweŋo re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, neparɨnɨ. Joxɨ xɨxenɨ mɨŋɨ́ nirorɨ re rɨ́ɨnɨ, ‘Gorɨxo ná wonɨ onɨrɨnɨ. Axɨ́pɨ ónɨŋɨ́ wo mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gorɨxomɨ dɨŋɨ́ sɨxɨ́ nuyirɨ́ná dɨŋɨ́ sɨxɨ́ uyiro dɨŋɨ́ wɨkwɨ́roro eŋɨ́ neánɨro xɨ́dɨro erɨ́ɨnɨ. Ámá aŋɨ́ nemerɨ́ná sɨŋwɨ́ wɨnarɨŋɨ́yɨ́ nánɨ wará dɨxɨ́ nánɨ dɨŋɨ́ sɨpí siarɨŋɨ́pa axɨ́pɨ dɨŋɨ́ sɨpí wirɨ́ɨnɨ.’ Joxɨ xɨxenɨ e rɨ́ɨnɨ. Ámá Gorɨxo nánɨ sipɨsipɨ́ bɨ mɨnɨ́ nonɨ rɨ́á nikeaárɨrónáranɨ, bɨ nɨnɨro rɨdɨyowá nɨyárɨrónáranɨ, nerɨ́náyɨ́ naŋɨ́ yarɨgɨ́á aiwɨ ámá Gorɨxoyá ŋwɨ́ ikaxɨ́ apiaúmɨ xɨ́darɨgɨ́áyɨ́ seáyɨ e imónɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisaso ŋwɨ́ ikaxɨ́ meweŋo dɨŋɨ́ píránɨŋɨ́ nɨmorɨ naŋɨ́ e urarɨŋagɨ arɨ́á nɨwirɨ re urɨŋɨnigɨnɨ, “Joxɨ dɨŋɨ́ sɨnɨ e nɨmóa nurɨ́náyɨ́ nionɨ nánɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́e nánɨ páwipaxɨ́ imónɨrɨ́ɨnɨ.” urɨ́agɨ ámɨ rɨ́wɨ́yo ámá nɨ́nɨ ayá urarɨŋagɨ nánɨ wí yarɨŋɨ́ ámɨ bɨ owimɨnɨrɨ mɨbɨpa egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","O sɨnɨ Judayɨ́yá aŋɨ́ sipɨsipɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ nuréwapɨyirɨ́ná ámá e epɨ́royɨ́ egɨ́áyo yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa pí nánɨ re rarɨgɨ́árɨnɨ, ‘Ámá nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ niwiarorɨ́ná sa xiáwo mɨxɨ́ ináyɨ́ Depitoyáo imónɨnɨ́árɨnɨ.’ pí nánɨ rarɨgɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Depito Gorɨxoyá kwíyɨ́ tɨ́nɨ nɨrɨrɨ rɨ́wamɨŋɨ́ nearɨ́ná ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ re nɨrɨrɨ eaŋɨ́rɨnɨ, ‘Gorɨxo gɨ́ Ámɨnáomɨ re urɨŋɨnigɨnɨ, “Joxɨ wé náúmɨnɨ nɨŋwearɨ sɨŋwɨ́ nanɨrɨ ŋweaŋáná mɨxɨ́ sianɨro bɨ́áyo xopɨrárɨ́ rɨwiimɨ́árɨnɨ.” urɨŋɨnigɨnɨ.’ ");
INSERT INTO aak_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depito rɨ́wamɨŋɨ́ apɨ nɨrɨrɨ nearɨ́ná arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ ‘Gɨ́ Ámɨnáoyɨ́ rɨ́agɨ nánɨ arɨge nerɨ sa xegɨ́ xewaxo imónɨnɨ?” urɨ́agɨ ámá e epɨ́royɨ́ egɨ́áyɨ́ xegɨ́ xwɨyɨ́á arɨ́á nɨwiróná yayɨ́ winɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","O sɨnɨ nuréwapɨyirɨ́ná re nura uŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa yarɨgɨ́ápɨ mepa éɨ́rɨxɨnɨ. Awa ámá weyɨ́ oneamépoyɨnɨrɨ rapɨrapɨ́ sepiá nɨyínɨmɨ aŋɨ́ emero ámá yayɨ́ ‘Ámɨnáoxɨnɨ́ onearɨ́poyɨnɨrɨ awí eánarɨgɨ́e aŋɨ́ emero ");
INSERT INTO aak_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","rotú aŋɨ́yo nɨpáwirɨ́náranɨ, aiwá imɨxarɨgɨ́e nɨŋwearɨ́náranɨ, sɨ́mɨ́ sɨ́mɨ́ e ŋwearo ");
INSERT INTO aak_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","apɨxɨ́ aníwamɨ amɨpí nɨ́nɨ ɨ́wɨ́ urápanɨro nánɨ ero ámá arɨ́á egɨ́e dánɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná anɨŋɨ́ nɨwia uro yarɨgɨ́ápɨ seyɨ́né mepa éɨ́rɨxɨnɨ. Rɨ́wéná Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ nerɨ́ná awa xwɨyɨ́á xwé meárɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","O sɨnɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ ínɨmɨ aŋɨ́ nemerɨ́ná nurɨ Gorɨxo nánɨ nɨgwɨ́ tayarɨgɨ́e orɨwámɨnɨ e éɨ́ nɨŋweámáná ámá obaxɨ́ nɨmúroayiróná nɨgwɨ́ tarɨŋagɨ́a nɨwɨnɨrɨ nɨgwɨ́ xwé tɨ́gɨ́áyɨ́ xwé tarɨŋagɨ́a nɨwɨnɨ́ɨsáná wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Apɨxɨ́ anɨ́ uyípeayɨ́ wí omɨ nɨmúrorɨ monɨ́ rɨ́á nɨŋɨ́ biaú tɨ́agɨ nɨwɨnɨmáná ");
INSERT INTO aak_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","xegɨ́ wiepɨsarɨŋowamɨ “Eɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ. Apɨxɨ́ anɨ́ amɨpí mayɨ́ rí Gorɨxo nánɨ nɨgwɨ́ onɨmiá ná biaúnɨ tɨ́ɨ́ aiwɨ ámá nɨ́nɨ tɨ́áyo seáyɨ e imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ámá nɨgwɨ́ xwé tɨ́áyɨ́ ná sɨnɨ nɨweŋáná obaxɨ́ tarɨŋagɨ́a aiwɨ apɨxɨ́ ríyɨ́ mayí eŋagɨ aiwɨ xegɨ́ nɨgwɨ́ aiwá nánɨ bɨ́ epaxɨ́pɨ nɨ́nɨ tɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ pɨ́nɨ nɨwiárɨmɨ warɨ́ná xegɨ́ wiepɨsarɨŋowa wo re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, aŋɨ́ awiaxɨ́ ikwɨ́rónɨrɨ sɨ́ŋá naŋɨ́ nɨŋweaxa urɨ eŋɨ́ eyɨ́ sɨŋwɨ́ wɨneɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","o re urɨŋɨnigɨnɨ, “Aŋɨ́ xwé tɨyɨ́ sɨŋwɨ́ rɨwɨnɨŋɨnɨ? Rɨ́wéná sɨ́ŋá kɨkírónɨŋɨ́ rɨpɨyɨ́ womɨ seáyɨ e ikwiárɨnɨnɨ́ámanɨ. Nɨ́nɨ nɨkwierómioanɨ́árɨnɨ.” nurɨmɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","O dɨ́wɨ́ mɨŋɨ́ Oripiyɨ rɨnɨŋɨ́yo nɨŋwearɨ aŋɨ́ rɨdɨyowá yarɨgɨ́á pɨ́nɨ nɨwiárɨmɨ yapɨ́ámɨnɨ wenɨŋɨ́ nero ŋweaŋáná wiepɨsarɨŋɨ́ Pitao tɨ́nɨ Jemiso tɨ́nɨ Jono tɨ́nɨ Adɨruo tɨ́nɨ wigɨ́pɨ ");
INSERT INTO aak_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ ‘Sɨ́ŋá womɨ seáyɨ e ikwiárɨnɨ́ámanɨ. Nɨkwierónowinɨ́árɨnɨ.’ nearɨ́ɨ́pɨ gíná imónɨnɨ́árɨnɨ? Sɨŋwɨ́ ayo nɨwɨnɨrane ‘Rɨxa nimónɨnɨ aŋwɨ ayorɨ́anɨ?’ yaiwianɨ́wá nánɨ pí ekɨyiŋɨ́ neainɨnɨ́árɨnɨ? Ekɨyiŋɨ́ neainɨnɨ́ápɨ nánɨ áwaŋɨ́ neareɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","o áwaŋɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá wí yapɨ́ searéwapɨyanɨro epɨ́rɨ́á eŋagɨ nánɨ dɨŋɨ́ ɨ́á nɨxɨrɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ámá obaxɨ́ wo wo nɨbayiro yoɨ́ nionɨyá nɨrɨnɨro yapɨ́ re searéwapɨyanɨro epɨ́rɨ́árɨnɨ, ‘Yeáyɨ́ seayimɨxemeámɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋáonɨrɨnɨ.’ searéwapɨyanɨro éáná ámá obaxɨ́ ‘Nepaxɨnɨ.’ nɨyaiwiro xeŋwɨ́yo xɨ́dɨpɨ́rɨ́árɨnɨ. Ayɨnánɨ nionɨ seararɨŋápɨ dɨŋɨ́ ɨ́á nɨxɨrɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Seyɨ́né ‘Aŋɨ́ ayo mɨxɨ́ inarɨŋoɨ.’ ránáyɨ́, xwɨyɨ́á imɨŋɨ́ ‘Aŋɨ́ wúmɨ mɨxɨ́ inarɨŋoɨ.’ rɨnɨméánáyɨ́, wáyɨ́ mepanɨ. Mɨxɨ́ ayɨ́ xámɨ niga nurɨ aiwɨ sɨ́á yoparɨ́ Jisasonɨ weapɨmɨ́áyi sɨnɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ámá gwɨ́ wɨrí nɨwiápɨ́nɨmearo wínɨyɨ́ tɨ́nɨ mɨxɨ́ inɨro ero mɨxɨ́ ináyɨ́ wí nɨwiápɨ́nɨmearo wí tɨ́nɨ mɨxɨ́ inɨro ero aŋɨ́ wíyɨ́ wíyo pobonɨ́ erɨ aŋɨ́ wámɨ agwɨ́ nánɨ ikeamónɨro yarɨŋagɨ nɨwɨnɨrɨ́ná dɨŋɨ́ re yaiwipɨ́rɨ́á nánɨ ‘Rɨ́wéná xwé enɨ́a nánɨ iwamɨ́ó ríyɨ́ rɨyarɨnɨ?’ yaiwipɨ́rɨ́a nánɨ seararɨŋɨnɨ. Apɨxɨ́ niaíwɨ́ nɨxɨrɨrɨ́ná dɨŋɨ́ re yaiwiarɨgɨ́ápa ‘Rɨ́wéná rɨ́nɨŋɨ́ xwé nimɨnɨrɨ nánɨ iwamɨ́ó rɨniarɨnɨ?’ yaiwiarɨgɨ́ápa soyɨ́né enɨ nionɨ rarɨŋápɨ nɨwɨnɨrɨ́ná re yaiwíɨ́rɨxɨnɨ, ‘Rɨ́wéná xeanɨŋɨ́ xwé neaímeanɨ́árɨ́anɨ?’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nionɨ rɨ́wɨ́mɨnɨ nɨmamopɨ́rɨxɨnɨrɨ nionɨ seararɨŋápɨ sɨ́mɨ́mɨnɨ tɨro awínɨŋɨ́ ŋwearo éɨ́rɨxɨnɨ. Seyɨ́né nionɨ nɨxɨ́darɨŋagɨ́a nánɨ ámá wí pɨ́rɨ́ owiaíkianeyɨnɨro ɨ́á nɨseaxero negɨ́ Judayɨ́yá opisɨ́ aŋɨ́yo seawárɨro rotú aŋɨ́ neneyáyo dánɨ iwaŋɨ́ seamépero epɨ́rɨ́árɨnɨ. Mɨxɨ́ ináyɨ́ tɨ́nɨ gapɨmanɨ́ tɨ́nɨ ayɨ́yá sɨŋwɨ́yo dánɨ enɨ nɨseaurárɨmáná xwɨrɨxɨ́ seamepɨ́rɨ́á eŋagɨ aiwɨ nionɨ nánɨ sɨnɨ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Xwɨyɨ́á nionɨ nánɨ yayɨ́ seainarɨŋɨ́pɨ ámá gwɨ́ wɨrɨ́ wɨrí nɨ́nɨ arɨ́á wigɨ́ámɨ eŋáná ámɨ weapɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ayɨ́ ɨ́á nɨseaxero opisɨ́ aŋɨ́yo seawáráná ayá sɨ́wɨ́ nɨsearorɨ ‘Pɨ́né arɨre uranɨréwɨnɨ?’ mɨyaiwipa éɨ́rɨxɨnɨ. Íná Gorɨxo pí pí nánɨ searɨ́ɨ́yɨ́ ananɨ kwíyɨ́ oyápimɨ dánɨ urɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Xexɨrɨ́meá wo nɨwiápɨ́nɨmearɨ xexɨrɨ́meáomɨ opɨkípoyɨnɨrɨ ɨ́á nɨxerɨ opisɨ́ aŋɨ́yo wárɨrɨ xanowa enɨ wigɨ́ niaíwɨ́ opɨkípoyɨnɨrɨ ɨ́á nɨxero opisɨ́ aŋɨ́yo wárɨro niaíwɨ́yɨ́ enɨ xanɨyaúmɨ opɨkípoyɨnɨrɨ wárɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Seyɨ́né yoɨ́ nionɨyá nɨrɨro xɨ́darɨŋagɨ́a nánɨ wikɨ́ nɨseaónɨro sɨ́mɨ́ tɨ́nɨ seaipɨ́rɨ́árɨnɨ. E seaipɨ́rɨ́á eŋagɨ aiwɨ gɨyɨ́ gɨyɨ́né eŋɨ́ neánɨro nionɨ nɨxɨ́dɨro anɨŋɨ́ dɨŋɨ́ nɨkwɨ́roro nerɨ́náyɨ́, sɨ́á yoparɨ́ nionɨ ámɨ bɨmɨ́áyi Gorɨxo ananɨ yeáyɨ́ seayimɨxemeanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Seyɨ́né ámá sɨpí seaikárɨŋo ŋwɨ́á imónɨŋe xórórɨ́ nerɨ xwɨrɨ́á ikɨxéagɨ nɨwɨnɨrɨ́náyɨ́ ámá Judia pɨropenɨsɨ́yo ŋweagɨ́áyɨ́ dɨ́wɨ́ tɨ́ŋɨ́ e nánɨ éɨ́ yíɨ́rɨxɨnɨ. Ámá gɨyɨ́ xwɨyɨ́á rɨpɨ ɨ́á roarɨgɨ́áyɨ́ dɨŋɨ́ píránɨŋɨ́ móɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ámá gɨyɨ́ gɨyɨ́ aŋɨ́ waíwɨ́yo nɨpeyiro seáyɨ́mɨnɨ mɨrɨnɨŋiwámɨ nɨŋwearo ‘Sɨpí neaikárɨŋo rɨxa ŋwɨ́á imónɨŋe xwɨrɨ́á ikɨxéɨ́rɨnɨ.’ rɨnarɨŋagɨ́a arɨ́á nɨwirɨ́náyɨ́ nɨwiápɨ́nɨmeámáná amɨpí ínɨmɨ aŋɨ́ mɨrɨnɨŋiwámɨ weŋɨ́pɨ meaanɨro nánɨ mɨpáwipa sa dɨ́wɨ́ tɨ́ŋɨ́ e nánɨ aŋɨ́nɨ éɨ́ yíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ámá aiwá omɨŋɨ́yo yarɨgɨ́áyɨ́ enɨ arɨ́á e nɨwirɨ́náyɨ́ ámɨ iyɨ́á meaanɨro nánɨ aŋɨ́ e nánɨ mupa sa dɨ́wɨ́yo nánɨ éɨ́ yíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Íná apɨxɨ́ niaíwɨ́ agwɨ́ egɨ́íwa tɨ́nɨ sɨnɨ niaíwɨ́ amɨŋɨ́ narɨgɨ́íwa tɨ́nɨ aŋɨ́nɨ éɨ́ upaxɨ́ meŋagɨ nánɨ aweyɨ. Arɨge aŋɨ́nɨ dɨ́wɨ́yo nánɨ éɨ́ yipɨ́rɨ́árɨ́anɨ? ");
INSERT INTO aak_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aŋɨ́nɨ éɨ́ mupaxɨ́ neaimónɨnɨgɨnɨrɨ Gorɨxomɨ rɨxɨŋɨ́ re urɨ́ɨ́rɨxɨnɨ, ‘Íná imɨŋɨ́ mɨrɨpa éwɨnɨgɨnɨ.’ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gorɨxo xwɨ́á imɨxɨrɨ aŋɨ́na imɨxɨrɨ eŋɨ́ e dánɨ ámá xeanɨŋɨ́ nimóga bagɨ́a aiwɨ sɨpí seaikárɨŋo ŋwɨ́á imónɨŋe xwɨrɨ́á ikɨxéáná xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaikárɨnɨ́árɨnɨ. Xeanɨŋɨ́ íná imónɨnɨ́ápɨ tɨ́nɨ ámɨ wí xɨxenɨ imónɨnɨ́á menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gorɨxo ‘Xeanɨŋɨ́ apɨ aŋɨ́nɨ pɨ́nɨ owiárɨnɨ.’ mɨyaiwipa nerɨ́náyɨ́ ámá nɨ́nɨ mɨŋweapaxɨ́rɨnɨ. Ámá xɨ́o eyíroárɨŋɨ́yɨ́ nánɨ dɨŋɨ́ nɨmorɨ nánɨ ‘Xeanɨŋɨ́ apɨ aŋɨ́nɨ anɨpá oimónɨnɨ.’ yaiwinɨ́á eŋagɨ nánɨ apaxɨ́ mé pɨ́nɨ wiárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Xeanɨŋɨ́ apɨ seaímeááná ámá wí ‘Ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o jɨ́iwo ŋweanɨ.’ ránáyɨ́ranɨ, ‘Riwo ŋweanɨ.’ ránáyɨ́ranɨ, arɨ́á mɨwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wí epaxɨ́ eŋánáyɨ́, ámá Gorɨxo eyíroárɨŋɨ́yo yapɨ́ wíwapɨyanɨro nerɨ́ná nepa mimónɨpa nero aí ‘Arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋáonɨrɨnɨ.’ nurɨmáná emɨmɨ́ ero ayá rɨwamónɨpaxɨ́ imónɨŋɨ́pɨ ero epɨ́rɨ́árɨnɨ. Wí nepa mimónɨpa nero aí ‘Gorɨxoyá wɨ́á rókiamoarɨŋáonɨrɨnɨ.’ urɨro emɨmɨ́ ero ayá rɨwamónɨpaxɨ́pɨ ero epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amɨpí rɨ́wéná imónɨnɨ́ápɨ nánɨ rɨxa áwaŋɨ́ searɨ́agɨ yapɨ́ seaíwapɨyipɨ́rɨxɨnɨrɨ nánɨ dɨŋɨ́ nɨmoro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Xeanɨŋɨ́ apɨ nɨpɨnɨ rɨxa nɨseaímeámáná eŋáná sogwɨ́ sɨ́á yinɨrɨ emá wɨ́á mónɨpa erɨ ");
INSERT INTO aak_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","siŋɨ́ aŋɨ́namɨ dánɨ exweánowirɨ amɨpí eŋɨ́ eánɨŋɨ́ aŋɨ́namɨ eŋɨ́yɨ́ úpɨyinɨrɨ nemáná eŋáná ");
INSERT INTO aak_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ámá imónɨŋáonɨ eŋɨ́ neánɨrɨ agwɨ́yo dánɨ wɨ́á nókía weaparɨŋagɨ nanɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nanáná aŋɨ́najɨ́ ámá Gorɨxo eyíroárɨŋɨ́ xwɨ́á rɨrímɨ nɨrímɨnɨ aŋɨ́ gɨmɨ ŋweagɨ́áyo wirɨmeaemepɨ́rɨ urowárɨmɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","E nurɨrɨ́ná ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Íkɨ́á pikɨ́yɨ rɨnɨŋɨ́yɨ́ reŋɨ́ sɨŋɨ́ neánɨro mɨŋɨ́ ináná ‘Xwiogwɨ́ rɨxarɨ́anɨ?’ yaiwiarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pikɨ́yɨ́nɨŋɨ́ xwiogwíná nánɨ nɨjɨ́á imónɨpɨ́rɨ yarɨŋɨ́pa xwɨyɨ́á nionɨ ekɨyiŋɨ́ nánɨ searɨ́áyɨ́ rɨxa imónarɨŋagɨ nɨwɨnɨrɨ́náyɨ́ dɨŋɨ́ re yaiwíɨ́rɨxɨnɨ, ‘Jisaso rɨxa nɨweapɨrɨ nánɨ rɨyarɨnɨ? Rɨxa aŋɨ́ ɨ́wí énɨŋɨ́ rónapɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nepa seararɨŋɨnɨ. Ámá gwɨ́ axɨ́ rɨrí sɨnɨ anɨpá mimónɨpa eŋáná nionɨ searɨ́ápɨ wí surɨ́má mimónɨpa nerɨ nɨpɨnɨ xɨxenɨ imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Xwɨ́á tɨ́nɨ aŋɨ́na tɨ́nɨ anɨpá imónɨnɨ́á eŋagɨ aiwɨ xwɨyɨ́á nionɨyá wí surɨ́má imónɨnɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nionɨ ámɨ gínɨ gíná nɨweapɨmɨ́a nánɨyɨ́ ámá nɨ́nɨ aiwɨ wo nɨjɨ́á mimónɨnɨ. Aŋɨ́najɨ́ aiwɨ nionɨ aiwɨ majɨ́á imónɨŋwɨnɨ. Sa gɨ́ áponɨ nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ayɨnánɨ dɨŋɨ́ píránɨŋɨ́ nɨmoro ŋweáɨ́rɨxɨnɨ. Nionɨ gínɨ gíná nɨweapɨmɨ́a nánɨ seyɨ́né majɨ́á imónɨŋagɨ́a nánɨ xwayɨ́ nanɨrɨ ŋweáɨ́rɨxɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","re urɨŋɨnigɨnɨ, “Nionɨ nɨweapɨmɨ́a nánɨyɨ́ rénɨŋɨ́ imónɨnɨ. Ámá wo aŋɨ́ wímɨ urɨ́nɨmɨnɨrɨ nurɨ́ná xɨnáíwánɨŋɨ́ omɨŋɨ́ wiiarɨgɨ́áwa o omɨ ‘Nionɨ úáná omɨŋɨ́ joxɨ niiarɨŋɨ́pɨ píránɨŋɨ́ niíɨrɨxɨnɨ.’ nura uŋɨnigɨnɨ. E nerɨ́ná womɨ ‘Aŋɨ́ ɨ́wí e awí roarɨŋoxɨ xwayɨ́ nanɨrɨ awí róɨrɨxɨnɨ.’ urɨŋo eŋɨ́pɨ ");
INSERT INTO aak_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","soyɨ́né axɨ́pɨ éɨ́rɨxɨnɨ. O ‘Aŋɨ́ xiáwo gínɨ gíná bɨnɨrɨ́enɨŋoɨ?’ nɨyaiwirɨ ‘Sɨ́ápɨ tɨ́nɨ bɨnɨrɨ́enɨŋoɨ? Árɨ́wegɨ́yo bɨnɨrɨ́enɨŋoɨ? Karɨ́karɨ́ rɨ́aiwá rarɨ́ná bɨnɨrɨ́enɨŋoɨ? Wɨ́á mónɨŋɨ́mɨ bɨnɨrɨ́enɨŋoɨ?’ nɨyaiwia nurɨ majɨ́á nimónɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","o nionɨ sá weŋáná nímeanɨgɨnɨrɨ anɨŋɨ́ xwayɨ́ nanɨrɨ awí roarɨŋɨ́pa nɨyɨ́nénɨ enɨ nionɨ weapɨmɨ́a nánɨ píránɨŋɨ́ dɨŋɨ́ nɨmoro ŋweáɨ́rɨxɨnɨ. Seyɨ́né enɨ maiwí nikárɨga warɨŋagɨ́a sɨŋwɨ́ seanɨmɨgɨnɨrɨ nánɨ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rɨxa sɨ́á wɨyaú óráná sɨ́á eŋíná aŋɨ́najo Judayo múroŋɨ́ nánɨ bisɨ́kerɨ́á yisɨ́ mayɨ́ iwamɨ́ó narɨgɨ́áyi —Eŋíná sɨ́á ayi Judayo Isipɨyɨ́ mɨxɨ́ ináyo ɨ́á xeŋwɨrárɨŋáná Gorɨxo niaíwɨ́ xámɨŋɨ́ nɨ́nɨ opɨkímɨnɨrɨ aŋɨ́najɨ́ oyáo urowárɨŋɨ́ aiwɨ Judayɨ́ Gorɨxo ŋwɨ́ ikaxɨ́ urɨ́ɨ́pɨ tɨ́nɨ xɨxenɨ nerɨ bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro nɨnɨro sipɨsipɨ́ nɨpɨkiro ówaŋɨ́yo ragɨ́ xópé yárɨ́á eŋagɨ nánɨ aŋɨ́najo ayo múroŋɨnigɨnɨ. Ayɨnánɨ xwiogwɨ́ o o pwéáná Judayɨ́ Gorɨxo eŋɨ́pɨ nánɨ dɨŋɨ́ mɨwinɨpa enɨgɨnɨrɨ sipɨsipɨ́ nɨpɨkiro bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro narɨgɨ́árɨnɨ. Rɨxa sɨ́á wɨyaú óráná sɨ́á aŋɨ́najo Judayo múroŋɨ́ nánɨ bisɨ́kerɨ́á yisɨ́ mayɨ́ iwamɨ́ó narɨgɨ́áyi imónɨnɨ́a eŋáná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ awa Jisasomɨ arɨge ínɨmɨ ɨ́á nɨxɨrɨro pɨkianɨréwɨnɨro ínɨmɨ mekaxɨ́ nɨmero ");
INSERT INTO aak_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","re rɨnɨgɨ́awixɨnɨ, “Sɨ́á ayimɨ ámá nɨ́nɨ aiwá imɨxanɨro epɨ́royɨ́ egɨ́áyimɨ ayɨ́ mɨxɨ́ épɨ́mɨxamoanɨgɨnɨrɨ mɨpɨkipa éwanɨgɨnɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisaso ámɨ aŋɨ́ yoɨ́ Betani nánɨ nurɨ Saimono peyɨyɨ́ imónagoyá aŋɨ́yo nɨŋwearɨ aiwá narɨ́ná apɨxɨ́ wí werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ sɨxɨ́ wá —Sɨxɨ́ awá nɨgwɨ́ aga xwé roŋɨ́wárɨnɨ. Awá nɨmeámɨ nɨbɨrɨ ɨ́á nóxayimɨxɨrɨ Jisasomɨ mɨŋɨ́yo iwayɨmóáná ");
INSERT INTO aak_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","wa wikɨ́ dɨŋɨ́ nɨwiaiwiro re rɨnɨgɨ́awixɨnɨ, “Í pí nánɨ werɨxɨ́ nɨgwɨ́ xwé roŋɨ́pɨ xwɨrɨ́á ikɨxearɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nene werɨxɨ́ apɨ nɨgwɨ́ nánɨ bɨ́ nerɨ sɨŋwɨrɨyɨ́, nɨgwɨ́ K300 seáyɨ e nɨmearane ámá uyípeayɨ́yo arɨrá nɨwirane mɨnɨ wipaxɨ́rɨnɨ.” nɨrɨnɨro ímɨ mɨxɨ́ urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisaso re urɨŋɨnigɨnɨ, “Xe oenɨ. Pí nánɨ ayá wí urarɨŋoɨ? Í naŋɨ́ niarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ámá uyípeayɨ́ sɨnɨ seyɨ́né tɨ́nɨ anɨŋɨ́ ŋweapɨ́rɨ́á eŋagɨ nánɨ gínɨ gíná ‘Ayo arɨrá owianeyɨ?’ nɨrɨrɨ́ná ananɨ arɨrá wipaxɨ́rɨnɨ. E nerɨ aiwɨ nionɨ seyɨ́né tɨ́nɨ nawínɨ anɨŋɨ́ re ŋweámɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Í ‘Arɨge nerɨ́ná Jisasomɨ arɨrá wimɨ́árɨ́anɨ?’ nɨyaiwirɨ xwárɨpáyo nɨtɨpɨ́rɨ eŋagɨ nánɨ anɨŋɨ́nɨ xámɨ gɨ́ waráyo xópé niárarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nepa seararɨŋɨnɨ. Xwɨ́á rɨrí nɨrímɨnɨ amɨ gɨmɨ xwɨyɨ́á nionɨ nánɨ yayɨ́ seainarɨŋɨ́pɨ wáɨ́ nemero nurɨmerɨ́ná apɨxɨ́ rí nionɨ werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ rɨpɨ niwayɨmóɨ́pɨ nánɨ enɨ repɨyɨ́ wíáná ‘Jisasomɨ apɨxɨ́ wí e iyí reŋɨnigɨnɨ?’ yaiwipɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jisasoyá wiepɨsarɨŋɨ́ wo, Isɨkariotɨ dáŋɨ́ Judasoyɨ rɨnɨŋo apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ Jisaso nánɨ mɨyɨ́ urɨmɨnɨrɨ nurɨ nɨwímearɨ ");
INSERT INTO aak_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","mɨyɨ́ uráná awa yayɨ́ nero apaxɨ́ mé re urɨgɨ́awixɨnɨ, “Nɨgwɨ́ siapanɨ́wɨnɨ.” urɨ́agɨ́a Judaso nurɨ Jisaso xegɨ́pɨ ŋweáage awa ananɨ ɨ́á xɨrɨpɨ́rɨ́e sɨŋwɨ́ wɨnárɨmɨnɨrɨ omɨ sɨŋwɨ́ wɨnaxɨ́dɨmeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bisɨ́kerɨ́á yisɨ́ mayɨ́ iwamɨ́ó narɨgɨ́íná rɨxa aŋɨ́najo Judayo sɨ́á ayimɨ múroŋɨ́ nánɨ dɨŋɨ́ mopɨ́rɨ nánɨ sipɨsipɨ́ miá pɨkiarɨ́ná xegɨ́ wiepɨsarɨŋowa Jisasomɨ re urɨgɨ́awixɨnɨ, “Ge nurane aiwá aŋɨ́najo neamúroŋɨ́yi nánɨ rɨ́á yeaarɨŋwápɨ joxɨ tɨ́nɨ nawínɨ nanɨ́pɨ rɨyamɨ́ yáranɨ́wɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","o wiepɨsarɨŋɨ́yɨ́ waúmɨ nurowárɨrɨ re urɨŋɨnigɨnɨ, “Jerusaremɨ nánɨ nuri aŋɨ́yo áwɨnɨmɨ ámá wo iniɨgɨ́ sɨxɨ́ nɨxɨrɨmɨ warɨŋagɨ órórɨ́ ninɨrónáyɨ́ númɨ úisixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Númɨ nuri aŋɨ́ o páwíiwámɨ awagwí enɨ nɨpáwiri aŋɨ́ xiáwomɨ yarɨŋɨ́ re wíisixɨnɨ, ‘Yearéwapɨyarɨŋo re rɨ́ɨnigɨnɨ, “Gɨ́ wiepɨsarɨŋowa tɨ́nɨ aiwá Aŋɨ́najo Neamúroŋɨ́yi nánɨ nɨnɨrɨ́ná aŋɨ́ awawá gɨwámɨ dánɨ nanɨréwɨnɨ?” rɨ́ɨnigɨnɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","o aŋɨ́ awawá seáyɨmɨ ikwɨ́rónɨŋɨ́wá íkwiaŋwɨ́ nɨ́nɨ rɨxa píránɨŋɨ́ imɨxárɨnɨŋɨ́wá sɨwá eainɨŋoɨ. E eaíáná awagwí e aiwá none nánɨ rɨyamɨ́ éisixɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","awaú nɨpeyeari aŋɨ́pimɨ nánɨ nuri Jisaso urɨ́ɨ́pa xɨxenɨ neri aiwá Aŋɨ́najo Múroŋɨ́yi nánɨ rɨyamɨ́ egɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sɨ́ápɨ tɨ́nɨ Jisaso tɨ́nɨ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú tɨ́nɨ awaú aiwá rɨyamɨ́ éɨ́íe nánɨ nuro ");
INSERT INTO aak_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","aŋɨ́yo nɨpáwiro nɨŋwearo aiwá nɨnɨróná Jisaso re urɨŋɨnigɨnɨ, “Nepa seararɨŋɨnɨ. Aiwá narɨŋwá rone woxɨ nionɨ nánɨ mɨyɨ́ nurɨrɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","awa ayá sɨpí wíagɨ wo wo re urayigɨ́awixɨnɨ, “Nionɨmanɨ. Nionɨmanɨ.” urayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","o re urɨŋɨnigɨnɨ, “Wé wúkaú sɨkwɨ́ waú egɨ́oyɨ́né woxɨrɨnɨ. Soyɨ́né nionɨ tɨ́nɨ múyo eagwianarɨŋwáone woxɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Woxɨ xwɨyɨ́á Gorɨxoyá ámá imónɨŋáonɨ nánɨ rɨ́wamɨŋɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ nirɨ́ɨnɨ. Ámá imónɨŋáonɨ nánɨ mɨyɨ́ urɨ́oxɨyɨ́ sɨ́á wɨyi joxɨ majɨ́á rórɨnɨ́á eŋagɨ nánɨ aweyɨ! Xɨnáí omɨ mɨxɨrɨpa nerɨ sɨŋwɨrɨyɨ́, naŋɨ́ imónɨmɨnɨrɨ eŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sɨnɨ aiwá nɨnɨróná o bisɨ́kerɨ́á bɨ nɨmearɨ Gorɨxomɨ apɨ nánɨ yayɨ́ nɨwimáná kwɨkwɨrɨmɨ́ nerɨ yaŋɨ́ nɨwia nurɨ́ná re urɨŋɨnigɨnɨ, “Nɨrápɨ́poyɨ. Rɨpɨ gɨ́ warárɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","wainɨ́ iniɨgɨ́ kapɨxɨ́ wá nɨmearɨ Gorɨxomɨ yayɨ́ nɨwirɨ awamɨ mɨnɨ wíáná nowanɨ nɨga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","re urɨŋɨnigɨnɨ, “Wainɨ́ rɨpɨyɨ́ gɨ́ ragɨ́rɨnɨ. Nionɨ ámá nɨ́nɨ nánɨ nɨpɨkíáná ragɨ́ nionɨyá xwɨ́áyo pwarɨŋagɨ nɨwɨnɨrɨ́ná soyɨ́né re yaiwipɨ́rɨ́árɨnɨ, ‘Xwɨyɨ́á sɨŋɨ́ “Nionɨ nɨperɨŋɨ́pimɨ dánɨ yeáyɨ́ seayimɨxemeámɨ́árɨnɨ.” réroárɨŋɨ́yɨ́ neparɨnɨ.’ yaiwipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nepa seararɨŋɨnɨ, ‘Nionɨ iniɨgɨ́ wainɨ́ ámɨ wí mɨnɨ́ néra núɨsáná Gorɨxo rɨxa xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e ŋweaŋáná ámɨ sɨŋɨ́ nɨmɨ́árɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","soŋɨ́ bɨ nɨrɨmowa nɨpeyearo dɨ́wɨ́ Oripiyo nánɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisaso re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ arɨ́á nípoyɨ, ‘Gorɨxo sipɨsipɨ́ mearɨŋomɨ pɨkioreawáráná sipɨsipɨ́ nɨ́nɨ wɨwínɨ umiamonɨŋoɨ.’ E nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ soyɨ́né wáyɨ́ nero nionɨnɨ niepɨsamopɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","E nerɨ aiwɨ nionɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwiápɨ́nɨmeámáná Gariri pɨropenɨsɨ́yo xámɨ seameámɨ́árɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitao re urɨŋɨnigɨnɨ, “Ámá nɨ́nɨ siepɨsamopɨ́rɨ aiwɨ nionɨ wí e emɨméɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisaso re urɨŋɨnigɨnɨ, “Nepa rɨrarɨŋɨnɨ. Sɨ́á rɨyimɨ karɨ́karɨ́ sɨnɨ rɨ́aiwá biaú mɨrɨpa eŋáná jɨwanɨŋoxɨ biaú bɨ re rayirɨ́ɨnɨ, ‘Jisaso tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨŋá wonɨmanɨ.’ biaú bɨ rayirɨ́ɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pitao arɨ́kí re urɨŋɨnigɨnɨ, “Wa nionɨ tɨ́nɨ nawínɨ nɨyeapɨkirɨ aiwɨ nionɨ wí ‘Jisaso nánɨ majɨ́onɨrɨnɨ.’ rɨmɨméɨnɨ.” urarɨ́ná wiepɨsarɨŋɨ́ wɨ́a enɨ axɨ́pɨ rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Awa ojɨkwɨ́í yoɨ́ Gesemaniyo nɨrémoro Jisaso wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Nionɨ Gorɨxomɨ yarɨŋɨ́ wimɨ nánɨ yimɨ soyɨ́né re ŋweápoyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitaomɨ tɨ́nɨ Jemisomɨ tɨ́nɨ Jonomɨ tɨ́nɨ nɨwirɨmeámɨ nurɨ́ná ayá sɨ́wɨ́ nurorɨ dɨŋɨ́ rɨ́á uxearɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","re urɨŋɨnigɨnɨ, “Dɨŋɨ́ rɨ́á nɨxearɨŋagɨ nánɨ rɨxa nɨpepaxɨ́ niarɨnɨ. Soyɨ́né re xwayɨ́ nanɨro ŋweápoyɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","jɨ́amɨnɨ e onɨmiápɨ nurɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ Gorɨxomɨ yarɨŋɨ́ nɨwirɨ́ná imónɨpaxɨ́ eŋánáyɨ́ awa mɨnɨpɨkí wiárɨ́ onɨmúrɨ́poyɨnɨrɨ Gorɨxomɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Gɨ́ ápe, joxɨ ananɨ mepaxɨ́ wí mimónɨnɨ. Nɨpɨkianɨro yarɨgɨ́á iniɨgɨ́ yíkɨ́ yarɨŋɨ́nɨŋɨ́ imónɨŋɨ́ rɨpɨ ananɨ emɨ nɨmamorɨréɨnɨ? Nionɨ yarɨŋɨ́ nɨsirɨ aiwɨ gɨ́ dɨŋɨ́ xɨ́dɨmɨméɨnɨ. Dɨxɨ́ dɨŋɨ́ pí pí yaiwíɨ́yɨ́ nɨrɨxɨ́dɨmɨ́ɨnɨ.” Gorɨxomɨ e nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","nɨbɨrɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Awa sa weŋagɨ́a nɨwɨnɨrɨ Pitaomɨ re urɨŋɨnigɨnɨ, “Saimonoxɨ sá rɨweŋɨnɨ? Wenɨŋɨ́ nero onɨmiápɨ mɨŋweapaxɨ́ rɨseaimónarɨnɨ? ");
INSERT INTO aak_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Obo nɨbɨrɨ yapɨ́ seaíwapɨyinɨgɨnɨ. Sɨŋwɨ́ nanɨrɨ nɨŋwearo Gorɨxomɨ rɨxɨŋɨ́ urɨ́poyɨ. Dɨŋɨ́ tɨ́nɨ ananɨ ‘Jisasomɨ pí pí wímeáɨ́yɨ́ xɨ́danɨ́wɨnɨ.’ nɨyaiwiro aiwɨ segɨ́ wará nánɨ ayá nɨrɨmɨxɨnɨro nánɨ éɨ́ seainɨnɨŋoɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","nurɨ Gorɨxomɨ yarɨŋɨ́ wíɨ́pɨ axɨ́pɨ ámɨ nɨwimáná ");
INSERT INTO aak_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ámɨ nɨbɨrɨ awa wigɨ́ sɨŋwɨ́ sipɨ́xɨpɨ́xɨ́ winarɨŋagɨ nánɨ sá órówapɨŋagɨ́a nɨwɨnɨrɨ xwɨyɨ́á bɨ murɨ́agɨ́a nɨwɨnɨrɨ ámɨ Gorɨxomɨ yarɨŋɨ́ wimɨnɨrɨ nurɨ nɨŋweaŋɨsáná ");
INSERT INTO aak_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","nɨbɨrɨ re urɨŋɨnigɨnɨ, “Sɨnɨ sá riwoyɨ́né rɨweŋoɨ? Kikiɨ́á rɨyarɨŋoɨ? Rɨxarɨnɨ. Ámá imónɨŋáonɨ pasá níáná ɨ́wɨ́ yarɨgɨ́áwa ɨ́á nɨxepɨ́rɨ rɨxa agwɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wiápɨ́nɨmeápoyɨ. Rɨxa owaneyɨ. Pasá nino rɨxa iwo barɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú imónɨgɨ́áwa Judaso apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwamɨ tɨ́nɨ Judayɨ́ mebáowamɨ tɨ́nɨ mɨyɨ́ uráná awa wigɨ́ ámá iwaŋɨ́ tɨ́nɨ kirá tɨ́nɨ ɨ́á xɨrɨgɨ́áwamɨ awí nearo Judaso tɨ́nɨ Jisaso tɨ́ŋɨ́ e nánɨ wɨ́rénapáná awa nɨbɨro Jisaso wiepɨsarɨŋɨ́ wɨ́amɨ urarɨ́ná wímeagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jisasomɨ nɨwímearóná Judaso óɨ́ e nuróná re urɨ́ɨ́pa, “Nionɨ pasánɨŋɨ́ numerɨ omɨ kíyɨ́ nɨmiaúnɨrɨ́ná sɨ́mɨmajɨ́ónɨŋɨ́ re seaiarɨŋɨnɨ, ‘O Jisasorɨnɨ.’ Omɨ soyɨ́né ɨ́á nɨxɨrɨro nɨméra úpoyɨ.” Óɨ́ e nuróná e urɨ́ɨ́pa ");
INSERT INTO aak_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","rɨxa Jisasomɨ nɨwímearɨ́ná re eŋɨnigɨnɨ. Aŋwɨ e nurɨ “Nearéwapɨyarɨŋoxɨnɨ” nurɨrɨ kíyɨ́ miaúnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kíyɨ́ miaúnáná omɨ mɨ́rɨ́ nuro ɨ́á xɨrɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɨ́á xɨrarɨ́ná ámá Jisasoyá xɨ́o tɨ́nɨ rogɨ́á wo kirá arerɨxɨ́yo wérónɨŋɨ́pɨ nɨmɨxearɨ ámá Jisasomɨ ɨ́á xɨrarɨgɨ́á womɨ —O apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiarɨŋorɨnɨ. Omɨ mɨŋɨ́ orómɨnɨrɨ éɨ́yɨ́ pɨ́rɨ́ nɨmoyɨ́kirɨ arɨ́á mɨŋɨ́ nɨwirɨ́piearɨ mamówárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","E éáná Jisaso mɨxɨ́ bɨ́áwamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né ámá ɨ́wɨ́ yarɨgɨ́áyo ɨ́á xɨranɨro nánɨ mɨxɨ́ nimónɨmɨ warɨgɨ́ápa nionɨ enɨ ɨ́á nɨxɨranɨro nánɨ mɨxɨ́ nimónɨmɨ rɨbarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sɨ́á ayɨ́ ayimɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ sɨŋánɨ nimónɨrɨ searéwapɨyarɨ́ná soyɨ́né wí ɨ́á mɨnɨxɨrarɨgɨ́awixɨnɨ. Pí nánɨ? Ayɨ́ pɨ́né Gorɨxoyá nionɨ nánɨ nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ yarɨŋoɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","wiepɨsarɨŋɨ́ nowanɨ omɨ nɨwiepɨsamoárɨmɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Awa nɨwiepɨsamoárɨmɨ úáná niaíwɨ́ sɨkɨŋɨ́ Jisasomɨ xɨ́darɨŋɨ́ wo rapɨrapɨ́ apɨ́á weŋɨ́nɨ xopɨxopɨ́ nɨrónɨmɨ nɨbɨrɨ Jisaso tɨ́ŋɨ́ e axɨ́ e rónapáná mɨxɨ́ bɨ́áyɨ́ omɨ ɨ́á xɨranɨro éɨ́áyɨ́ ");
INSERT INTO aak_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","rapɨrapɨ́ ú nɨpírɨpeárɨmɨ aikɨ́ mayo éɨ́ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mɨxɨ́ bɨ́áyɨ́ Jisasomɨ nɨmeámɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋo tɨ́ŋɨ́ e nánɨ nuro e wáráná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ awí eánarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitao Jisasomɨ mɨxɨ́ bɨ́áyɨ́ nɨmeáa warɨ́ná ná rɨ́wɨ́yo númɨ nurɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá ákɨŋáyo nɨpáwirɨ porisowa tɨ́nɨ nɨŋweámáná rɨ́á imónarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ xwɨrɨxɨ́ mearɨgɨ́á nowanɨ tɨ́nɨ awa ámá sɨŋwɨ́ ɨ́wɨ́ wɨnarogɨ́á wí xwɨyɨ́á Jisasomɨ ananɨ nɨpɨkipaxɨ́ imónɨŋɨ́ bɨ orɨ́poyɨnɨrɨ nero aiwɨ Jisasomɨ pɨkipaxɨ́ bɨ mɨrarɨŋagɨ́a nɨwɨnɨro ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ámá obaxɨ́ omɨ nuxekwɨ́moayiro aiwɨ axɨ́pɨnɨ mɨrɨ́ bɨ bɨ nɨra nurɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ámá wí éɨ́ nɨroro Jisasomɨnɨ yapɨ́ nuxekwɨ́moro re urɨgɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nene o re rarɨŋagɨ arɨ́á wiŋwanigɨnɨ, ‘Nionɨ aŋɨ́ rɨdɨyowá yarɨgɨ́á riwá, ámá wé tɨ́nɨ mɨrɨgɨ́á riwá nɨpɨneámáná sɨ́á wɨyaú wɨyi óráná ámɨ wiwá, wé tɨ́nɨ mɨmɨrɨpa egɨ́á wiwá mɨrɨmɨ́árɨnɨ.’ rarɨŋagɨ wiŋwanigɨnɨ.” urarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","xwɨyɨ́á apɨ aí axɨ́pɨnɨ mɨrɨ́ bɨ bɨ nɨra warɨŋagɨ́a nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋo nɨwiápɨ́nɨmeámɨ aŋwɨ e nɨbɨrɨ Jisasoyá sɨ́mɨ́ e nɨrómáná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ayɨ́ xwɨyɨ́á ‘Joxɨrɨnɨ.’ rɨxekwɨ́moarɨgɨ́áyo xwɨyɨ́á joxɨyá wí enɨ mɨrɨpaxɨ́ rɨsiarɨnɨ?” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisaso xwɨyɨ́á wákwipaxɨ́ aiwɨ kɨ́kɨ́mí nimónɨrɨ xwɨyɨ́á bɨ murarɨŋagɨ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋo yarɨŋɨ́ ámɨ bɨ nɨwirɨ re urɨŋɨnigɨnɨ, “Joxɨ niaíwɨ́ Gorɨxoyáoxɨ, nene yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋoxɨranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisaso “Nionɨrɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ Gorɨxo eŋɨ́ sɨxɨ́ eánɨŋoyá wé náúmɨnɨ ŋwearɨ agwɨ́ tɨ́nɨ weapɨrɨ yarɨŋagɨ sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋo wikɨ́ nɨwónɨrɨ nɨkɨnɨmónɨrɨ xegɨ́ rapɨrapɨ́ naxerɨ xwɨrɨxɨ́ mearɨgɨ́á wɨ́amɨ re urɨŋɨnigɨnɨ, “Sɨŋwɨ́ ɨ́wɨ́ wɨnarogɨ́áyɨ́ rɨ́ápɨ nánɨ dɨŋɨ́ wí ɨkwɨ́roanɨméwɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xewanɨŋo Gorɨxomɨ rɨperɨrɨ́ umeararɨ́ná soyɨ́né rɨxa arɨ́á wíoɨ. Dɨŋɨ́ soyɨ́néyá pí ‘Oyaneyɨ.’ yaiwiarɨŋoɨ?” uráná awa “Xwɨyɨ́á ámɨ bɨ rɨpaxɨ́ mimónɨgoɨ. Rɨxa opɨkípoyɨ.” nɨrɨ́asáná ");
INSERT INTO aak_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","wa re egɨ́awixɨnɨ. Reaŋwɨ́ úrɨro írɨkwɨ́ sɨŋwɨ́yo rɨtɨ́ nɨyárɨmáná iwaŋɨ́ earo re urɨro, “Wɨ́á rókiamoarɨŋoxɨnɨ, amɨpí ínɨmɨ éɨ́ápɨ áwaŋɨ́ ragoxɨ, iwaŋɨ́ go reaarɨnɨ? Áwaŋɨ́ neareɨ.” urɨro néɨ́asáná aŋɨ́ rɨdɨyowá yarɨgɨ́iwá awí mearoarɨgɨ́áwamɨ mɨnɨ wíáná awa enɨ sɨ́mɨmaŋɨ́yo wé upɨkákwiayigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pitao, awa aŋɨ́yo ínɨmɨ Jisasomɨ xwɨrɨxɨ́ mépero iwaŋɨ́ earo yarɨ́ná, o mɨ́de ákɨŋáyo ínɨmɨ ŋweaŋáná apɨxɨ́ apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá omɨŋɨ́ wiiarɨgɨ́á wí nɨbɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitao rɨ́á imónarɨŋagɨ nɨwɨnɨrɨ sɨŋwɨ́ agwɨ́ nɨwɨnárɨŋɨsáná re urɨŋɨnigɨnɨ, “Joxɨ enɨ Nasaretɨ dáŋɨ́ Jisaso tɨ́nɨ emearɨgɨ́áyɨ́ woxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pitao “Oweoɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Jíxɨ rarɨŋɨ́pɨ nánɨ nionɨ majɨ́árɨnɨ.” nurɨmɨ nɨwerɨ ɨ́wíyi tɨ́ŋɨ́ e éɨ́ roŋáná ");
INSERT INTO aak_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","apɨxɨ́ apɨyá axí enɨ nɨwerɨ o e roŋagɨ nɨwɨnɨrɨ ámá e rówapɨgɨ́áyɨ́ tɨ́ŋɨ́ e dánɨ omɨ árɨxá nɨwirɨ re urɨŋɨnigɨnɨ, “Ámá oyɨ́ Jisaso tɨ́nɨ nawínɨ emearɨgɨ́á worɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","o “Oweoɨ. Nionɨmanɨ.” nurɨrɨ roŋáná ámɨ rɨ́wɨ́yo ámá e rówapɨgɨ́áyɨ́ re urɨgɨ́awixɨnɨ, “Neparɨnɨ. Joxɨ awa tɨ́nɨ emearɨŋoxɨrɨnɨ. Joxɨ Gariri pɨropenɨsɨ́yo dáŋoxɨ eŋagɨ nánɨ Jisaso tɨ́nɨ emearɨŋoxɨrɨnɨ.” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pitao sɨpí ikaxɨ́ nɨrɨrɨ xwɨ́á e dánɨ re urɨŋɨnigɨnɨ, “Ámá soyɨ́né rarɨgɨ́o nánɨ majɨ́onɨrɨnɨ.” rɨxa uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Karɨ́karɨ́ rɨ́aiwá ámɨ bɨ rɨ́agɨ arɨ́á nɨwirɨ Jisaso “Sɨ́á rɨyimɨ karɨ́karɨ́ sɨnɨ rɨ́aiwá biaú mɨrɨpa eŋáná joxɨ ‘Jisaso nánɨ nionɨ majɨ́onɨrɨnɨ.’ biaú bɨ rayirɨ́ɨnɨ.” urɨ́ɨ́pɨ nánɨ dɨŋɨ́ nɨwinɨrɨ yapɨ́ urɨ́ɨ́yɨ́ nánɨ ayá sɨpí wíagɨ ŋwɨ́ eaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wɨ́á mónɨŋɨ́mɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ awa Judayɨ́ xwɨrɨxɨ́ mearɨgɨ́á nɨ́nɨ tɨ́nɨ awí neánɨro xwɨyɨ́á nimɨxárɨmáná Jisasomɨ gwɨ́ nɨyiro nɨmeámɨ nuro émáyɨ́yá gapɨmanɨ́ Pairatoyɨ rɨnɨŋomɨ mɨnɨ wíáná ");
INSERT INTO aak_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","o Jisasomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Judayɨ́yá mɨxɨ́ ináyoxɨranɨ?” Yarɨŋɨ́ e wíagɨ Jisaso “Ayɨ́ joxɨ rarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa omɨ sɨ́mɨ́ tɨ́nɨ uxekwɨ́moarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairato ámɨ Jisasomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Xwɨyɨ́á joxɨyá wí nɨwiápɨ́nɨmearɨ mɨrɨpaxɨ́ rɨsiarɨnɨ? Ayɨ́ xwɨyɨ́á ‘Joxɨnɨ.’ rɨxekwɨ́moarɨgɨ́áyɨ́ onɨmiápɨ nɨrɨro mɨyarɨŋoɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisaso xwɨyɨ́á wákwipaxɨ́ aiwɨ ámɨ pɨ́né bɨ mɨrɨ́agɨ nánɨ Pairato dɨŋɨ́ ududɨ́ nɨwiga uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sɨ́á Aŋɨ́najo Judayo Múroŋɨ́yi imónɨŋáná xwiogwɨ́ ayɨ́ ayo Judayɨ́ nuro wigɨ́ gwɨ́ ŋweagɨ́á wo nánɨ émáyɨ́ gapɨmanomɨ yarɨŋɨ́ wíáná o ayɨ́ nionɨ nánɨ yayɨ́ onípoyɨnɨrɨ nɨmɨxearɨ uwáriagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Íná ámá wo Barabasoyɨ rɨnɨŋo —O ámá wa tɨ́nɨ nɨwiápɨ́nɨmearo “Wauyowamɨ mɨxɨ́ oxɨ́dowáraneyɨ.” nɨrɨnɨro awa tɨ́nɨ mɨxɨ́ ninɨróná o ámá womɨ pɨkíagɨ émáyɨ́ omɨ tɨ́nɨ ámá xɨ́o tɨ́nɨ nɨroro mɨxɨ́ egɨ́áwamɨ tɨ́nɨ gwɨ́ yíagɨ́a nánɨ o íná kɨrapusɨ́ aŋɨ́yo ŋweaŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","O nánɨ oxɨ́ apɨxɨ́ nɨ́nɨ aiwá apɨ nánɨ awí eánɨgɨ́áyɨ́ émáyɨ́ gapɨmanɨ́ Pairatomɨ nuro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Xwiogwɨ́ ayɨ́ ayo negɨ́ ámá gwɨ́ ŋweagɨ́á wo neaiapagɨ́pa ámɨ wo neaiapɨréɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pairato “Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa Jisasomɨ sɨpí dɨŋɨ́ nɨwiaiwiro nánɨ gwɨ́ nɨyiro nɨmeámɨ nɨbɨro niapáoɨ.” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Segɨ́ mɨxɨ́ ináyɨ́ Jisasoyɨ rɨnɨŋo seawárimɨnɨréɨnɨ?” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa wɨ́á mónɨŋɨ́mɨ ámá aiwá apɨ nánɨ epɨ́royɨ́ egɨ́áyo re rɨnárɨméɨ́á nánɨ “Jisaso pí enɨŋoɨ! O nánɨ yarɨŋɨ́ mɨwipanɨ. Barabaso nánɨ yarɨŋɨ́ wípoyɨ.” rɨnárɨméɨ́á eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ayɨ́ Pairatomɨ re urɨgɨ́awixɨnɨ, “Barabaso neawáriɨ.” urɨ́agɨ́a Pairato re urɨŋɨnigɨnɨ, “Judayɨ́néyá mɨxɨ́ ináyɨ́ urɨgɨ́omɨ pÍ emɨ́ɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ayɨ́ xɨxewiámɨ́ re urɨgɨ́awixɨnɨ, “Íkɨ́áyo yekwɨroáreɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pairato re urɨŋɨnigɨnɨ, “Pí ɨ́wɨ́ éɨ́ nánɨ e emɨ́ɨnɨ?” urɨ́agɨ aiwɨ awa xɨxewiámɨ́ nura nuro “Íkɨ́áyo yekwɨroáreɨ.” urayarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pairato ayo oyapemɨxɨmɨnɨrɨ nerɨ re eŋɨnigɨnɨ. Barabaso nɨmɨxearɨ nuwárimáná xegɨ́ porisowa Jisasomɨ iwaŋɨ́ xaíwɨ́ nɨmépéɨ́asáná eŋáná awamɨ re urɨŋɨnigɨnɨ, “Omɨ nɨmeámɨ nuro íkɨ́áyo yekwɨroárɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Porisowa Jisasomɨ nɨmeámɨ gapɨmanoyá aŋiwámɨ —Aŋɨ́ yoɨ́ ayɨ́ Pɨretoriumɨyɨ rɨnɨŋiwámɨrɨnɨ. Aŋɨ́ iwámɨ nɨpáwiro wauyɨ́ porisɨ́ nowamɨnɨ “Eɨnɨ.” nurɨro “Omɨ rɨperɨrɨ́ omépeaneyɨ.” nɨrɨnɨro re egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rapɨrapɨ́ ayɨ́á rɨŋɨ́ wú mɨxɨ́ ináyɨ́ yínarɨgɨ́á wú nɨmearo omɨ nuyírɨro ópɨyá eŋɨ́nɨŋɨ́ imónɨŋɨ́ wɨrí nɨkɨ́kɨyimáná mɨxɨ́ ináyɨ́ amɨnaŋwɨ́nɨŋɨ́ imónɨŋɨ́ mɨŋɨ́yo dɨ́kínarɨgɨ́ápa mɨŋɨ́yo xaíwɨ́ udɨ́kiárɨro nemáná ");
INSERT INTO aak_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","mɨxɨ́ ináyɨ́yo yayɨ́ wiarɨgɨ́ápa rɨperɨrɨ́ nɨwiro re urayigɨ́awixɨnɨ, “Judayɨ́yá mɨxɨ́ ináyoxɨrɨnɨ.” nurayirɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","wegwɨ́á tɨ́nɨ mɨŋɨ́yo iwaŋɨ́ earo reaŋwɨ́ úrɨro xómɨŋɨ́ nɨyɨkwiro mɨŋɨ́ xwɨ́áyo ɨkwɨ́roro nero ");
INSERT INTO aak_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","rɨxa rɨperɨrɨ́ numépéɨ́asáná rapɨrapɨ́ ayɨ́á rɨŋú nɨwirɨro ámɨ xegú nuyírɨro íkɨ́áyo yekwɨroáranɨro nánɨ nɨméra nuro ");
INSERT INTO aak_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","óɨ́ e nurɨ́ná ámá obaxɨ́ pwarɨgɨ́á womɨ xegɨ́ yoɨ́ Saimonoyɨ —O aŋɨ́ yoɨ́ Sairini dáŋorɨnɨ. Xewaxo yoɨ́ Arekɨsadaorɨnɨ. Xexɨrɨ́meáo yoɨ́ Rupasorɨnɨ. Omɨ porisowa ɨ́á nɨxero “Jisaso nánɨ íkɨ́á yoxáɨ́ rɨpá nɨmeámɨ wuiɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jisasomɨ nɨméra nuro dɨ́wɨ́ bɨ Gorɨgota rɨnɨŋɨ́pimɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ ámá mɨŋɨ́ gɨxweá nánɨrɨnɨ. Dɨ́wɨ́ apimɨ nɨrémoro ");
INSERT INTO aak_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ámá wa Jisaso rɨ́nɨŋɨ́ bɨ mɨwinɨpa oenɨrɨ marɨsɨnɨ́á murɨ́yɨ rɨnɨŋɨ́ bɨ iniɨgɨ́ wainɨ́yo niwayɨmorɨ mɨnɨ wianɨro yarɨŋagɨ́a aí o murápɨ́ “Oweoɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","porisowa omɨ íkɨ́áyo nɨyekwɨroárɨro xegɨ́ rapɨrapɨ́ yaŋɨ́ menanɨro sárúyo dánɨ “None go meanɨrɨ́enɨŋoɨ?” nɨrɨnɨro sárú egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jisasomɨ 9:00 a.m. imónáná rɨxa sogwɨ́ xaíwɨ́ anarɨ́ná íkɨ́áyo nɨyekwɨroárɨro ");
INSERT INTO aak_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ámá nɨ́nɨ “O ɨ́wɨ́ rɨpɨ éɨ́ nánɨ rɨpɨkiarɨŋoɨ?” oyaiwípoyɨnɨrɨ íkɨ́á wárá nɨmearo “Judayɨ́yá mɨxɨ́ ináyorɨnɨ.” nɨrɨro rɨ́wamɨŋɨ́ e nearo íkɨ́áyo seáyɨ e nɨpɨ́rauro ");
INSERT INTO aak_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ámá ámáyá amɨpí ɨ́wɨ́ pɨkioráparɨgɨ́íwaú enɨ Jisaso tɨ́ŋɨ́ e mɨdɨmɨdánɨ nɨyekwɨroárɨro nánɨ ");
INSERT INTO aak_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","rɨ́wamɨŋɨ́ eŋíná Bɨkwɨ́yo nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ, “O ɨ́wɨ́ yarɨgɨ́á tɨ́nɨ nawínɨ kumɨxɨgɨ́árɨnɨ.” rɨnɨŋɨ́pɨ xɨxenɨ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ámá Jisasomɨ mɨnɨ mɨnɨ nɨmúroayiro ikayɨ́wɨ́ numearɨro payɨ́ nɨwianɨróná mɨŋɨ́ kɨrɨ́kɨrɨ́ nimeaayiro re rɨgɨ́awixɨnɨ, “Re rɨŋoxɨranɨ? ‘Niɨwanɨŋonɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwá nɨpɨnearɨ gɨ́ niɨwɨnɨ sɨ́á wɨyaú wɨyimɨ ámɨ mɨrɨmɨ́árɨnɨ.’ rɨŋoxɨ ");
INSERT INTO aak_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","eŋɨ́ neánɨrɨ jɨwanɨŋoxɨ eŋɨ́ nɨyoárɨmɨ wepɨ́neɨ.” urayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ enɨ ikayɨ́wɨ́ numearɨro re rɨgɨ́awixɨnɨ, “O eŋɨ́ neánɨrɨ ámáyo arɨrá wiago aí xewanɨŋo arɨrá minɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋɨ́ ro Isɨrereneyá mɨxɨ́ ináyɨ́ rɨnɨŋɨ́ royɨ íkɨ́áyo seáyɨ e dánɨ nɨyoárɨnɨmɨ wepɨ́nɨ́agɨ sɨŋwɨ́ nɨwɨnɨranénáyɨ́, dɨŋɨ́ wɨkwɨ́roanɨ́wɨnɨ.” rarɨ́ná ámá Jisaso tɨ́ŋɨ́ e mɨdɨmɨdánɨ yekwɨroárɨgɨ́íwaú enɨ omɨ ikayɨ́wɨ́ axɨ́pɨ umearɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ayɨ́ e néra núɨ́asáná eŋáná rɨxa 12:00 ikwawedɨ́ imónáná re eŋɨnigɨnɨ. Aŋɨ́ nɨmɨnɨ sɨ́á nɨyinárɨrɨ sɨ́á nɨyinárɨŋɨsáná sɨ́á tɨ́nɨ 3:00 dánɨ ámɨ wɨ́á ókíáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jisaso rɨ́aiwá eŋɨ́ tɨ́nɨ nɨrɨrɨ xegɨ́ Xibɨruyɨ́ pɨ́né tɨ́nɨ re rɨŋɨnigɨnɨ, “Eroi, Eroi, rama sabakɨtani?” nɨrɨrɨ aga pɨ́né “Gɨ́ Gorɨxoxɨnɨ! Gɨ́ Gorɨxoxɨnɨ, pí nánɨ emɨ nɨmóɨnɨ?” urarɨgɨ́ápa Xibɨruyɨ́ pɨ́né tɨ́nɨ e rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ámá e rówapɨgɨ́á wa arɨ́á nɨwiro re rɨgɨ́awixɨnɨ, “Ai! Rɨxa Gorɨxoyá wɨ́á rókiamoagɨ́ mɨpé aŋɨ́namɨ peyiŋo Iraijao nánɨ rɨ́aiwá rarɨnɨ.” nɨrɨro ");
INSERT INTO aak_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ámá wo írɨkwɨ́ nɨmearɨ iniɨgɨ́ wainɨ́ niáɨ́ yarɨŋɨ́pimɨ igɨ́á nearɨ wegwɨ́á wá tɨ́nɨ ayɨŋwɨ́ nikɨroárɨmáná wegwɨ́áwámɨ nɨmaxɨrɨmáná o bɨ nɨnɨrɨ sɨŋɨ́ oenɨrɨ nánɨ seáyɨ émɨ nɨwimɨxánɨrɨ re rɨŋɨnigɨnɨ, “Iraijao omɨ íkɨ́á tɨ́nɨ eŋɨ́ onɨŋɨ́ nɨyoarɨ nɨmeámɨ wepɨ́nɨnɨ aŋɨ́namɨ dánɨ weapɨnɨrɨ́enɨŋoɨ?” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisaso rɨ́aiwá ámɨ bɨ eŋɨ́ tɨ́nɨ nɨrɨmo dɨŋɨ́ nɨyámɨga uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dɨŋɨ́ nɨyámɨga úáná rapɨrapɨ́ sepiá aŋɨ́ rɨdɨyowá yarɨgɨ́iwá awawá ŋwɨ́á tɨ́ŋɨ́mɨnɨ epaŋioárɨnɨŋú áwɨnɨ e axowárɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Porisowayá seáyɨ e imónɨŋo Jisaso nɨpearɨ́ná sɨ́mɨmaŋɨ́mɨnɨ nɨrorɨ Jisaso péagɨ nɨwɨnɨrɨ́ná dɨŋɨ́ nɨyámɨga e úagɨ nɨwɨnɨrɨ re rɨŋɨnigɨnɨ, “Ámá royɨ́ neparɨnɨ. Gorɨxomɨ xewaxorɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Apɨxɨ́ wíwa enɨ Jisaso péáná ná jɨ́amɨ nɨrómáná sɨŋwɨ́ wɨnarogɨ́íwa wigɨ́ yoɨ́ ríwarɨnɨ. Mariaí —Í aŋɨ́ yoɨ́ Magɨdara dáŋírɨnɨ. Í tɨ́nɨ apɨxɨ́ Mariaíyɨ rɨnɨŋɨ́ ámɨ wí —Í Jemiso onaxomɨ tɨ́nɨ Josesomɨ tɨ́nɨ xɨnáírɨnɨ. Í tɨ́nɨ ámɨ wí Saromíyɨ rɨnɨŋí tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Íwa Jisaso Gariri pɨropenɨsɨ́yo emearɨ́ná númɨ nuro arɨrá wigɨ́íwarɨnɨ. Ámɨ obaxɨ́ wíwa enɨ o tɨ́nɨ Gariri dánɨ Jerusaremɨ aŋɨ́yo nánɨ bɨgɨ́íwa Jisasomɨ pɨkiarɨ́ná jɨ́amɨ dánɨ sɨŋwɨ́ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Rɨxa sɨ́ápɨ tɨ́nɨ sɨ́á ayi Sabarɨ́á nánɨ amɨpí píránɨŋɨ́ imɨxárarɨgɨ́áyimɨ ");
INSERT INTO aak_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aramatia dáŋɨ́ Josepo —O Judayɨ́ mebá seáyɨ e imónɨgɨ́á worɨnɨ. O Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́a nánɨ dɨŋɨ́ nɨkɨkayorɨ wenɨŋɨ́ nerɨ ŋweaŋorɨnɨ. O masɨsɨ́á mɨwí dɨŋɨ́ sɨxɨ́ nínɨmɨ émáyɨ́ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e nánɨ nurɨ éɨ́ nɨrómáná Jisaso pɨyo nánɨ “Ananɨ omeámɨnɨ?” nurɨrɨ yarɨŋɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pairato Jisaso rɨxa rɨ́a péɨnigɨnɨrɨ “Porisowamɨ mearɨŋo obɨnɨ.” nɨrɨrɨ poriso rɨxa báná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Jisaso rɨxa rɨpéɨnigɨnɨ? Sɨnɨ mɨpepa réɨnigɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","poriso “O rɨxa péɨnigɨnɨ.” rɨ́agɨ Pairato arɨ́á e nɨwirɨ Aramatia dáŋɨ́ Josepo Jisaso pɨyomɨ xe omeanɨrɨ sɨŋwɨ́ wɨnɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josepo nurɨ rapɨrapɨ́ apɨ́á weŋɨ́ wú bɨ́ nerɨ nɨmeámɨ nɨbɨrɨ pɨyomɨ nɨyoarɨ nɨmeámɨ nɨwepɨ́nɨrɨ e nɨtɨmáná wigɨ́ yarɨgɨ́ápa xopɨxopɨ́ nɨróa numáná xwárɨpáyo nánɨ nɨmeámɨ nurɨ —Xwárɨpá ayi sɨ́ŋáyo óɨ́ rɨxárɨnɨŋɨ́yirɨnɨ. Ayimɨ nɨtɨmáná sɨ́ŋá xwé wo mɨmegwɨnárɨ́ nɨméra nɨpuro óɨ́ maŋɨ́wámɨ rɨtɨ́ nerɨ́ná éɨ́ rárárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E yarɨ́ná Magɨdara dáŋɨ́ Mariaí tɨ́nɨ Josesomɨ xɨnáí Mariaíyɨ rɨnɨŋí tɨ́nɨ “Jisaso ge tɨpɨ́rɨréoɨ?” nɨyaiwiri sɨŋwɨ́ wɨnaxɨ́dɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sá wegɨ́ípaú Sabarɨ́á ayi rɨxa pwéáná sɨ́ápɨ tɨ́nɨ Saromí tɨ́nɨ awí neánɨro wɨ́ápɨ tɨ́nɨ pɨyomɨ waráyo xópé wiaúwanɨgɨnɨrɨ íwa werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ bɨ bɨ́ nero nɨtɨro ");
INSERT INTO aak_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","sá wegɨ́íwa Sadéyo wɨ́á mónɨŋómɨ nɨwiápɨ́nɨmeámɨ Jisaso xwɨ́á weyárɨnɨŋe nánɨ nuro rɨxa sogwɨ́ xemónaparɨŋagɨ nɨrémorɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","wiwanɨŋíwa re rɨnɨgɨ́awixɨnɨ, “Ámá gowa sɨ́ŋá óɨ́ maŋɨ́wámɨ pɨ́roŋo mɨmegwɨnárɨ́ neaiipɨ́rɨréoɨ?” nɨrɨnɨrɨ́ná ");
INSERT INTO aak_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Sɨ́ŋá aga xwéo aí rɨxa mɨmegwɨnárɨ́ ninɨrɨ óɨ́yi sɨŋánɨ inɨŋagɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","aŋwɨ e nɨbɨro óɨ́yimɨ nɨpáwiro wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Aŋɨ́najɨ́ wo rapɨrapɨ́ apɨ́á weŋɨ́ sepiá wú nɨyínɨmáná daiwo éɨ́ ŋweaŋagɨ nɨwɨnɨro ududɨ́ wíagɨ́a ");
INSERT INTO aak_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","o re urɨŋɨnigɨnɨ, “Ududɨ́ mepanɨ. Nionɨ nɨjɨ́árɨnɨ. Sewayɨ́né Nasaretɨ dáŋɨ́ Jisaso, íkɨ́áyo yekwɨroárɨgɨ́omɨ sɨŋwɨ́ wɨnanɨro barɨŋoɨ. Sɨnɨ re mɨwenɨnɨ. Rɨxa wiápɨ́nɨmeáɨnigɨnɨ. Omɨ tɨgɨ́e anɨ́á rí imónɨŋagɨ wɨnɨ́poyɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Rɨxa nuro wiepɨsiŋowamɨ tɨ́nɨ Pitaomɨ tɨ́nɨ enɨ áwaŋɨ́ re urémeápoyɨ, ‘Jisaso Gariri pɨropenɨsɨ́yo nánɨ xámɨ seameanɨ́árɨnɨ. Xewanɨŋo searɨŋɨ́pa xɨ́omɨ e sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.’ urémeápoyɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","íwa nɨpeyearo xwárɨpáyo pɨ́nɨ nɨwiárɨmɨ éɨ́ nuróná eŋɨ́ óɨ́ ero sɨrɨ́ pɨkínɨro nero wáyɨ́ nikárɨnɨro nánɨ ámá wíyo áwaŋɨ́ murɨ́ éɨ́ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisaso Sadéyo wɨ́á mónɨŋɨ́mɨ rɨxa nɨwiápɨ́nɨmeámáná nurɨ Magɨdara dáŋɨ́ Mariaímɨ —Apɨxɨ́ í Jisaso xámɨ imɨ́ó ímɨ dɨŋɨ́ xɨxéroarɨgɨ́á wé wɨ́úmɨ dáŋɨ́ waú mɨxɨ́ umáɨnowárɨŋírɨnɨ. Ímɨ xámɨ sɨŋánɨ sɨwá winɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","í nurɨ ámá Jisaso tɨ́nɨ emeagɨ́áwa o nánɨ dɨŋɨ́ sɨpí nɨwirɨ nánɨ ámɨxɨ́á yarɨŋagɨ́a nɨwímearɨ Jisaso wiápɨ́nɨmeáɨ́ nánɨ áwaŋɨ́ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","re urɨŋɨnigɨnɨ, “O rɨxa sɨŋɨ́ eŋagɨ sɨŋwɨ́ wɨnɨ́ɨnɨ.” urɨ́agɨ awa arɨ́á nɨwiro aí dɨŋɨ́ nɨwɨkwɨ́roro “Nepa neararɨnɨ.” mɨyaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","E nemáná eŋáná xegɨ́ wiepɨsiŋɨ́ waú Jerusaremɨ pɨ́nɨ nɨwiárɨmɨ aŋɨ́ wíyo nánɨ warɨ́ná Jisaso xegɨ́ wónɨŋɨ́ nimónɨrɨ wímeáagɨ ");
INSERT INTO aak_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","awaú enɨ nuri wiepɨsiŋɨ́ wɨ́amɨ “Jisasomɨ sɨŋwɨ́ wɨnɨ́wiɨ.” urɨ́agɨ́i aiwɨ dɨŋɨ́ nɨwɨkwɨ́roro “Nepa neararɨŋiɨ.” mɨyaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","E nemáná eŋáná xegɨ́ wiepɨsiŋowa wé wúkaú sɨkwɨ́ wo awí neánɨro aiwá narɨ́ná Jisaso sɨŋánɨ sɨwá nɨwinɨrɨ awa sɨnɨ dɨŋɨ́ mɨwɨkwɨ́ró ero dɨŋɨ́ kɨ́kɨ́mí imónɨro yarɨŋagɨ́a nánɨ mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá nionɨ nɨwiápɨ́nɨmearɨ ámɨ sɨŋɨ́ eŋagɨ sɨŋwɨ́ nɨnanɨmɨ nɨbɨro áwaŋɨ́ searɨ́áyo arɨ́á nɨwiro dɨŋɨ́ mɨwɨkwɨ́ropa pí nánɨ yarɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","re urɨŋɨnigɨnɨ, “Xwɨ́á rɨrí nɨrímɨnɨ amɨ amɨ nemero xwɨyɨ́á nionɨ nánɨ yayɨ́ seainarɨŋɨ́pɨ ámá nɨyonɨ áwaŋɨ́ urɨméɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ámá gɨyɨ́ arɨ́á nɨseairo nionɨ nánɨ dɨŋɨ́ nɨnɨkwɨ́roro wayɨ́ meáɨ́áyo Gorɨxo yeáyɨ́ uyimɨxemeanɨ́árɨnɨ. E nerɨ aiwɨ ámá gɨyɨ́ nionɨ nánɨ dɨŋɨ́ mɨnɨkwɨ́róɨ́áyɨ́ xwɨyɨ́á meárɨnɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ámá nionɨ nánɨ dɨŋɨ́ nɨkwɨ́róɨ́áyɨ́ wáɨ́ nurɨmerɨ́ná Gorɨxoyá dɨŋɨ́yo dánɨ emɨmɨ́ rɨpɨ epɨ́rɨ́árɨnɨ. Gɨ́ yoɨ́yo dánɨ ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnowárɨro pɨ́né ámá wíyá majɨ́á aiwɨ Gorɨxoyá dɨŋɨ́yo dánɨ wigɨ́ pɨ́néyo dánɨ urɨro ");
INSERT INTO aak_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","sidɨrɨ́yo ɨ́á nɨtamɨxɨnɨrɨ́ná sidɨŋɨ́ nɨworɨ aiwɨ mɨpé ero iniɨgɨ́ ayáɨ́ inɨŋɨ́pɨ nɨnɨrɨ aiwɨ mɨpé ero ámá sɨmɨxɨ́yo wé seáyɨ e nikwiárɨro naŋɨ́ imɨxɨro epɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","E nurɨmɨ Jisaso Gorɨxoyá dɨŋɨ́ tɨ́nɨ aŋɨ́namɨ nánɨ nɨpeyirɨ́ná ámɨ o tɨ́nɨ xɨxenɨ nimónɨrɨ nánɨ wé náúmɨnɨ éɨ́ ŋweaŋɨnigɨnɨ. Éɨ́ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","awa nuro Jisasoyá xwɨyɨ́á amɨ amɨ nurɨmeróná ámá “Nepa neararɨŋoɨ.” yaiwipɨ́rɨ nánɨ emɨmɨ́ enɨ Ámɨná Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwíwapɨya wagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ámá obaxɨ́ amɨpí Jisaso xɨnáí xɨrɨŋe dánɨ nene tɨ́ŋɨ́ e imónɨŋɨ́pɨ nánɨ “Rɨ́wamɨŋɨ́ oeaaneyɨ.” nɨyaiwiro ámá iwamɨ́ó dánɨ Jisasomɨ sɨŋwɨ́ wɨnɨro arɨ́á wiro egɨ́áyɨ́ wáɨ́ nemerɨ́ná “Jisaso e eŋɨ́rɨnɨ. E eŋɨ́rɨnɨ.” nura úɨ́ápɨ rɨ́wamɨŋɨ́ eáagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","nionɨ enɨ “‘Gɨ́ ámɨnáoxɨ Tiopirasoxɨ xɨxenɨ nɨjɨ́á imónɨrɨ nánɨ rɨ́wamɨŋɨ́ awa xámɨ eagɨ́ápɨ nionɨ ɨ́á nɨrorɨ sɨŋwɨ́ wɨnagɨ́áyo yarɨŋɨ́ nɨwia nurɨ e nemáná píránɨŋɨ́ dɨŋɨ́ neŋwɨperɨ rɨ́wamɨŋɨ́ nearɨ joxɨ nánɨ wiowárénapɨmɨ́ɨnɨ.’ E nerɨ́ná naŋɨ́rɨnɨ.” nimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ayɨ́ rɨpɨ nánɨ yarɨŋɨnɨ. Joxɨ ɨ́á nɨrorɨ amɨpí rɨréwapɨyigɨ́ápɨ aga xɨxenɨ nɨjɨ́á imónɨrɨ́a nánɨ yarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eŋíná Judayɨ́ mɨxɨ́ ináyɨ́ Xerotoyɨ rɨnɨŋo meŋweaŋáná ámá apaxɨ́pánɨŋɨ́ imónɨgɨ́á wo, Sekaraiaoyɨ rɨnɨŋo ŋweaŋɨ́rɨnɨ. O xegɨ́ ámáyɨ́ Abaijaoyárɨnɨ. O xegɨ́ ámáyɨ́ eŋíná dánɨ Gorɨxoyá apaxɨ́pánɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ. Sekaraiao xegɨ́ apɨxí yoɨ́ Irisabetírɨnɨ. Í xegɨ́ ámáyɨ́ arɨ́o Eronoyáyɨ́rɨnɨ. Í xegɨ́ ámáyɨ́ enɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áyɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ayaú Gorɨxoyá sɨŋwɨ́yo dánɨ wé rónɨŋɨ́ eri Gorɨxo ŋwɨ́ ikaxɨ́ rɨrɨ sekaxɨ́ rɨrɨ eŋɨ́yo mɨwiaíkí eri neri aí ");
INSERT INTO aak_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Irisabetí rɨ́paíwɨ́ eŋí eŋagɨ nánɨ niaíwɨ́ mayɨ́yaú e néra nuri rɨxa xweyaŋɨ́ apiaŋɨ́ imónɨgɨ́írɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","O xegɨ́ ámáyɨ́ Abaijaɨ rɨnɨgɨ́áyɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ rɨdɨyowá nero wigɨ́ yarɨgɨ́ápa yarɨ́ná xɨ́o tɨ́nɨ enɨ nawínɨ nero ");
INSERT INTO aak_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","wigɨ́ nerɨ́ná yarɨgɨ́ápa “None gɨ́mɨnɨ go ‘Ŋwɨ́áxɨnɨ.’ rɨnɨŋɨ́wámɨ páwinɨrɨ́enɨŋoɨ?” nɨyaiwiro yarɨgɨ́ápa e nero Sekaraiao Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ awawá Gorɨxoyá tɨ́ŋɨ́ e “Ŋwɨ́áxɨnɨ.” rɨnɨŋe nɨpáwirɨ rɨ́á awɨ́í dɨŋɨ́ eaarɨŋɨ́pɨ nánɨ oikeanɨrɨ rɨ́peááná ");
INSERT INTO aak_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","oxɨ́ apɨxɨ́ bɨ́anɨrɨwámɨnɨ rówapɨgɨ́áyɨ́ Gorɨxomɨ rɨxɨŋɨ́ urarɨ́ná o awawá Gorɨxoyá tɨ́ŋɨ́ e nɨpáwirɨ Gorɨxo nánɨ rɨ́á awɨ́í dɨŋɨ́ earɨŋɨ́pɨ nikearɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Aŋɨ́najɨ́ wo rɨ́á sɨŋwɨrɨ́á wé náúmɨnɨ peyarɨŋɨ́mɨ dánɨ sɨŋwɨ́ nanɨrɨ yarɨŋe aí gínánɨŋɨ́ nɨbɨrɨ rónapɨŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","óɨ́ nerɨ wáyɨ́ ikárɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","aŋɨ́najo re urɨŋɨnigɨnɨ, “Sekaraiaoxɨnɨ, wáyɨ́ mikárɨnɨpanɨ. Dɨxɨ́ niaíwɨ́ nánɨ yarɨŋɨ́ wíɨ́pɨ Gorɨxo rɨxa arɨ́á sinɨ. Dɨxɨ́ apɨxí niaíwɨ́ oxɨ́ wo rɨxɨrɨyíáná joxɨ yoɨ́ Jonoyɨ wɨ́rɨ́ɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Omɨ nɨxɨráná joxɨ seáyɨ e nimónɨrɨ yayɨ́ yarɨ́ná oxɨ́ apɨxɨ́ obaxɨ́ enɨ yayɨ́ epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","O Gorɨxoyá sɨŋwɨ́yo dánɨ ámá ámɨná eŋɨ́ eánɨŋónɨŋɨ́ imónɨnɨ́árɨnɨ. O iniɨgɨ́ wainɨ́ mɨnɨpa erɨ papɨkɨ́ yarɨgɨ́áyɨ́ mɨnɨpa erɨ enɨ́árɨnɨ. O sɨnɨ xegɨ́ xɨnáíyá agwɨ́yo eŋáná Gorɨxoyá kwíyɨ́ ukɨkayonɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O segɨ́ ámá Isɨrerɨyo uráná obaxɨ́ arɨ́á nɨwiro ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro Gorɨxo wigɨ́ Ámɨnáomɨ ámɨ xɨ́dɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dɨxɨ́ íwo kwíyɨ́ Gorɨxoyápɨ xegɨ́ wɨ́á rókiamoagɨ́ Iraijaomɨ ukɨkayoŋáná eŋɨ́ neánɨrɨ yagɨ́pɨ́nɨŋɨ́ Jono axɨ́pɨ́nɨŋɨ́ e erɨ rɨrɨ enɨ́árɨnɨ. Xewaxowa tɨ́nɨ xanowa tɨ́nɨ pɨyɨ́á wɨ́rɨnɨro ámá uyɨ́niɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro wé rónɨŋɨ́ imónɨro éɨ́rɨxɨnɨrɨ Jono Gorɨxoyá Ámɨnáomɨ xámɨ umeanɨ́árɨnɨ. Dɨxɨ́ Isɨrerɨyɨ́ e ero Gorɨxoyá Ámɨnáomɨ yeáyɨ́ wurɨ́nɨro epɨ́rɨ nánɨ oimónɨrɨ xámɨ umeanɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraiao aŋɨ́najomɨ re urɨŋɨnigɨnɨ, “Arɨge nerɨ nionɨ nɨjɨ́á imónɨmɨ nɨrarɨŋɨnɨ? Nionɨ rɨxa xweyaŋonɨrɨnɨ. Gɨ́ apɨxí enɨ rɨxa apiaŋírɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","aŋɨ́najo ámɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Gɨ́ yoɨ́ Gebɨrieronɨrɨnɨ. Gorɨxoyá sɨ́mɨmaŋɨ́ e roarɨŋáonɨrɨnɨ. Gorɨxo nionɨ xwɨyɨ́á yayɨ́ seainɨpaxɨ́ apɨ áwaŋɨ́ urɨnɨrɨ nɨrowárénapɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amɨpí nionɨ xámɨ rɨrɨ́áyɨ́ nimónɨríná nimónɨnɨ́árɨnɨ. E nerɨ aiwɨ xwɨyɨ́á nionɨ rɨrɨ́áyɨ́ joxɨ ‘Neparɨnɨ.’ nɨyaiwirɨ dɨŋɨ́ mɨkwɨ́roarɨŋagɨ nánɨ joxɨ ámɨ xwɨyɨ́á bɨ mɨrɨpa imónɨrɨ maŋɨ́ pɨ́rónɨrɨ erɨ eɨ. Xámɨ nionɨ rɨrɨ́áyɨ́ nimónɨríná íná ámɨ xwɨyɨ́á rɨrɨ́a nánɨyɨ.” nurɨrɨ sɨnɨ e nura warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","oxɨ́ apɨxɨ́ Sekaraiao nánɨ wenɨŋɨ́ nero wáɨ́ e rogɨ́áyɨ́ ayá wí sɨ́á órɨnɨŋagɨ nánɨ ududɨ́ nero “Sekaraiao pí rɨ́a yarɨnɨ?” nɨyaiwiro ");
INSERT INTO aak_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","o nɨpeyeááná xwɨyɨ́á murɨpaxɨ́ imónɨŋagɨ nɨwɨnɨro “Gorɨxoyá awawá tɨ́ŋɨ́ e nerɨ́ná orɨŋá bɨ rɨ́a wɨnɨgoɨ?” yaiwiarɨ́ná o “Xwɨyɨ́á arɨge rɨmɨ́ɨnɨ?” nɨyaiwirɨ xegɨ́ maŋɨ́ nɨpɨ́rónɨrɨ nánɨ wé árɨxá néra uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraiao aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ xegɨ́ omɨŋɨ́ yarɨŋɨ́pɨ yoparɨ́pɨ nemɨ xegɨ́ aŋɨ́ e nánɨ yoaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","O aŋɨ́ e nánɨ nɨyoarɨ xiepímɨ nɨwímearɨ nɨŋweagɨ́isáná re eŋɨnigɨnɨ. Irisabetí niaíwɨ́ agwɨ́ nerɨ aŋɨ́yo ínɨmɨ pɨ́nɨ ŋweaŋáná emá wé wú múróáná ");
INSERT INTO aak_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","í re rɨŋɨnigɨnɨ, “Gorɨxo ayá nɨnɨrɨmɨxɨrɨ dɨŋɨ́ nɨkɨkayoŋagɨ nánɨ niínɨ agwɨ́ eŋárɨnɨ. Niínɨ ámáyá sɨŋwɨ́yo dánɨ ayá ninarɨŋɨ́pɨ Gorɨxo yokwarɨmɨ́ niŋɨ́rɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Gorɨxo, Irisabetí niaíwɨ́ agwɨ́ nerɨ emá wé wɨ́úmɨ dáŋɨ́ wo rɨxa eŋáná o aŋɨ́najɨ́ xegɨ́ yoɨ́ Gebɨrieromɨ apɨxɨ́ wí ŋweaŋe nánɨ —Í xegɨ́ yoɨ́ Mariaíyɨ rɨnɨŋírɨnɨ. Gariri pɨropenɨsɨ́yo aŋɨ́ yoɨ́ Nasaretɨyo ŋweaŋírɨnɨ. Í ŋweaŋe nánɨ urowárɨŋɨnigɨnɨ. Í apɨxɨ́ apɨyáí sɨnɨ oxɨ́ tɨ́nɨ memearɨŋírɨnɨ. Í ámá wo xegɨ́ yoɨ́ Josepoyɨ rɨnɨŋo —O mɨxɨ́ ináyɨ́ Depitoyá ɨ́wiárɨ́awé worɨnɨ. O xegɨ́ meámɨnɨrɨ nánɨ yarɨŋírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gorɨxo aŋɨ́najo í tɨ́ŋɨ́ e nánɨ urowáráná o nurɨ ímɨ re urémeaŋɨnigɨnɨ, “Apɨxɨ́ ríxɨ apánɨrɨnɨ. Gorɨxo dɨŋɨ́ sɨxɨ́ rɨyirɨ dɨŋɨ́ rɨkɨkayorɨ sinɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariaí arɨ́á e nɨwirɨ ududɨ́ nikárɨnɨrɨ dɨŋɨ́ re nɨpɨkíga uŋɨnigɨnɨ, “O pí nánɨ rɨ́a nɨrarɨnɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","aŋɨ́najo re urɨŋɨnigɨnɨ, “Mariae, wáyɨ́ mepanɨ. Gorɨxo jíxɨ dɨŋɨ́ sɨxɨ́ rɨyinɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Arɨ́á eɨ. Jíxɨ niaíwɨ́ agwɨ́ nerɨ niaíwɨ́ oxɨ́ wo nɨxɨrɨrɨ́náyɨ́ yoɨ́ Jisasoyɨ wɨ́rɨrɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","O Ámɨnáo nimónɨrɨ ámá nɨyonɨ seáyɨ e múrónɨnɨ́árɨnɨ. Ayɨ́ o nánɨ re rɨpɨ́rɨ́árɨnɨ, ‘Niaíwɨ́ Gorɨxo aŋɨ́ seáyɨ émɨ ŋweaŋoyáorɨnɨ.’ rɨpɨ́rɨ́árɨnɨ. Xiáwo Depito ámá Isɨrerɨyɨ́ nɨ́nɨ yeáyɨ́ urɨ́nayagɨ́ápa dɨxɨ́ niaíwo enɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ e nimónɨrɨ ɨ́wiárɨ́awé Jekopoyáyo anɨŋɨ́ minɨ́ umeŋweanɨ́árɨnɨ. O mɨxɨ́ ináyo yapɨ nimónɨrɨ ámá xwioxɨ́yo mɨmeámɨ́ nerɨ numeŋwearɨ́ná wí nɨpiéronɨ́ámanɨ. Anɨŋɨ́ umeŋweanɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariaí aŋɨ́najomɨ re urɨŋɨnigɨnɨ, “Niínɨ sɨnɨ oxɨ́ womɨ mɨmeánɨŋáyo joxɨ nɨrɨ́ɨ́yɨ́ arɨre nerɨ emɨ́árɨ́anɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","aŋɨ́najo ámɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Kwíyɨ́ Gorɨxoyápɨ jíxɨ tɨ́ámɨnɨ bɨrɨ eŋɨ́ eánɨŋɨ́ Gorɨxo seáyɨ émɨ ŋweaŋoyápɨ jíxɨ rɨkɨkayorɨ sinɨ́á eŋagɨ nánɨ niaíwɨ́ jíxɨ xɨrɨ́oyɨ́ nánɨ ‘Ŋwɨ́áorɨnɨ.’ rɨro ‘Niaíwɨ́ Gorɨxoyáorɨnɨ.’ rɨro epɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","re urɨŋɨnigɨnɨ, “Arɨ́á eɨ. Dɨxɨ́ rɨrówáí Irisabetí rɨxa apiaŋí aí niaíwɨ́ oxɨ́ wo agwɨ́ enɨ. ‘Oxɨ́ roŋíxɨrɨnɨ.’ urarɨgɨ́í aiwɨ agwɨ rɨxa agwɨ́ tɨ́ŋí eŋáná emá wé wɨ́úmɨ dáŋɨ́ wo imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Amɨpí wí Gorɨxo mimɨxɨpa epaxɨ́ wí menɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariaí re urɨŋɨnigɨnɨ, “Xewanɨŋínɨ Gorɨxoyá xɨnáínɨ́nɨŋɨ́ imónɨŋáínɨ omɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ yarɨŋɨnɨ. Joxɨ nɨrɨ́ɨ́yɨ́ ananɨ nimɨxɨnɨgɨnɨ.” uráná aŋɨ́najo ímɨ pɨ́nɨ nɨwiárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mariaí, aŋɨ́najo e nurárɨmɨ úáná, í nɨwiápɨ́nɨmeámɨ aŋɨ́nɨ nɨyirɨ dɨ́wɨ́nɨ eŋe Judia pɨropenɨsɨ́yo aŋɨ́ bimɨ nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","nɨrémorɨ́ná Sekaraiaoyá aŋɨ́yo nɨpáwirɨ xɨrówáí Irisabetímɨ yayɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","í arɨ́á nɨwirɨ́ná re eŋɨnigɨnɨ. Niaíwɨ́ agwɨ́ eŋo xɨxoyɨ́mɨ́ wirɨ kwíyɨ́ Gorɨxoyápɨ xɨ́ímɨ ukɨkayorɨ wíagɨ ");
INSERT INTO aak_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","pɨ́né eŋɨ́ tɨ́nɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Apɨxɨ́ nɨyonɨ nánɨ Gorɨxo jíxɨnɨ píránɨŋɨ́ simɨxɨŋɨ́rɨnɨ. Dɨxɨ́ niaíwɨ́ agwɨ́ eŋomɨ enɨ píránɨŋɨ́ wimɨxɨrɨ eŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","yayɨ́ numerɨ re urɨŋɨnigɨnɨ, “Gɨ́ Ámɨnáomɨ xɨnáíxɨ imónɨríxɨ, arɨre nerɨ niínɨ tɨ́ámɨnɨ bɨ́ɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","áwaŋɨ́ re urɨŋɨnigɨnɨ, “Ai, jíxɨ yayɨ́ níáná arɨ́á nɨsirɨ́ná gɨ́ niaíwɨ́ agwɨ́yo ínɨŋo yayɨ́ nerɨ xɨxoyɨ́mɨ́ níagɨ nánɨ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jíxɨ xwɨyɨ́á Gorɨxoyá rɨrɨŋɨ́pɨ dɨŋɨ́ nɨkwɨ́rorɨ ‘O nɨrɨ́ɨ́yɨ́ nepa nimónɨnɨ́árɨnɨ.’ yaiwirɨ éɨ́ eŋagɨ nánɨ xewanɨŋíxɨ yayɨ́ sinɨ́wɨnɨgɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariaí re rɨŋɨnigɨnɨ, “Gɨ́ xwioxɨ́yo dánɨ re yaiwiarɨŋɨnɨ, ‘Ámɨnáomɨ seáyɨ e oumemɨnɨ.’ yaiwiarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gorɨxo, niínɨ yeáyɨ́ neayimɨxemeanɨ́o nánɨ aga yayɨ́ seáyɨmɨ dánɨ ninarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Niínɨ o xegɨ́ xɨnáínɨ́nɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋáínɨ aiwɨ o dɨŋɨ́ nɨkɨkayoŋo eŋagɨ nánɨ niínɨ yayɨ́ ninarɨnɨ. Ámá agwɨ ríná ŋweagɨ́áyɨ́ niínɨ seáyɨ e nɨmero rɨ́wɨ́yo ŋweapɨ́rɨ́áyɨ́ enɨ seáyɨ e nɨmero nerɨ́ná re rɨpɨ́rɨ́árɨnɨ, ‘Gorɨxo ímɨ píránɨŋɨ́ wimɨxɨŋɨ́rɨnɨ.’ rɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gorɨxo, eŋɨ́ sɨxɨ́ eánɨŋo saŋɨ́ onɨmiá mɨnɨrápɨŋorɨnɨ. Gorɨxo ŋwɨ́áo nerɨŋɨ́yo dánɨ wé rónɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ámá gínɨ gíná ŋweagɨ́áyɨ́ xɨ́omɨ wáyɨ́ nɨwiro sɨmaŋwɨ́yónɨŋɨ́ ínɨmɨ wurɨ́nɨ́áyo wá wianarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O eŋɨ́ neánɨrɨ wíyo arɨrá wiemerɨ wíyo xopɨrárɨ́ wiemerɨ nerɨ́ná ámá dɨŋɨ́ ɨ́wɨ́ nánɨ nɨkɨkayorɨ ero weyɨ́ menɨro yarɨgɨ́áyɨ́ dowiakínɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","mɨxɨ́ ináyɨ́ seáyɨ émɨ imónɨgɨ́áwamɨ mamówárɨrɨ ámá sɨpípiamɨ seáyɨ e wimɨxɨrɨ nerɨ ");
INSERT INTO aak_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ámá agwɨ́nɨ yarɨgɨ́áyo aiwá naŋɨ́ nɨnɨro agwɨ́ ímɨ uyinɨ wimɨxɨyirɨ nerɨ ámá amɨpí múrónɨgɨ́áyo anɨpá urowárapɨrɨ eŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amɨpí nɨgɨ́ arɨ́owayá sɨ́mɨmaŋɨ́yo urɨŋɨ́yɨ́ dɨŋɨ́ yaíkiá mɨmó anɨŋɨ́ dɨŋɨ́ morɨ xegɨ́ omɨŋɨ́ wiiarɨŋwaéne Isɨrerene arɨrá neairɨ eŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","O arɨ́o Ebɨrɨ́amo nánɨ dɨŋɨ́ nɨmorɨ nánɨ omɨ tɨ́nɨ xegɨ́ ɨ́wiárɨ́awé nenenɨ tɨ́nɨ ayá anɨŋɨ́ nɨnearɨmɨxa unɨ́árɨnɨ.” Mariaí e nɨra uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Irisabetí tɨ́nɨ nɨŋweaŋɨsáná rɨxa emá waú wo múróáná ámɨ xegɨ́ aŋɨ́ e nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Irisabetí rɨxa niaíwɨ́ xɨrɨmɨnɨrɨ imónɨŋáná niaíwɨ́ sɨŋwɨ́ nɨwanɨrɨ oxɨ́ wo xɨrɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oxɨ́ wo xɨráná í xegɨ́ úrɨxɨ́meá tɨ́nɨ ámá aŋɨ́ ayo dáŋɨ́yɨ́ tɨ́nɨ arɨ́á re wigɨ́awixɨnɨ, “Irisabetímɨ Gorɨxo ayá urɨmɨxɨ́agɨ nánɨ niaíwɨ́ wo xɨrɨŋoɨ.” Arɨ́á e nɨwiro í tɨ́nɨ yayɨ́ seáyɨmɨ dánɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","rɨxa sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo imónáná ayɨ́ niaíwɨ́ iyɨ́ sɨ́mɨ́ sɨ́ó wákwianɨro nɨbɨro yoɨ́ axɨ́pɨ xano wɨ́rɨnɨŋɨ́pɨ Sekaraiaoyɨ wɨ́ranɨro nánɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","xɨnáí “Oweoɨ!” nurɨrɨ re urɨŋɨnigɨnɨ, “Nene ámɨ yoɨ́ axɨ́pɨ Sekaraiaoyɨ wɨ́rɨpaxɨ́ menɨnɨ. Jonoyɨ owɨ́raneyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ayɨ́ re urɨgɨ́awixɨnɨ, “Dɨxɨ́ oxoyá xoayowa aí wo yoɨ́ ‘Jonoyɨ́ rɨwɨ́rɨnɨnɨ? Oweoɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","xano arɨ́á enɨ pɨ́rónɨŋagɨ nánɨ wé árɨxá nɨwiro wé tɨ́nɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ yoɨ́ gɨ́pɨ ‘Owɨ́rɨmɨnɨ.’ yaiwiarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraiao pɨraiporɨ́á nánɨ árɨxá wíagɨ umeaíáná o rɨ́wamɨŋɨ́ re eaŋɨnigɨnɨ, “Xegɨ́ yoɨ́ Jonorɨnɨ.” e eáagɨ ayɨ́ ududɨ́ nero Jonoyɨ wɨ́rɨ́ɨ́yɨ́ “Pí nánɨ rɨ́a wɨ́rarɨnɨ?” yaiwiarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ámɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ maŋɨ́ nexoarɨ xwɨyɨ́á rɨpaxɨ́ nimónɨrɨ Gorɨxomɨ seáyɨ e numerɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ámá aŋɨ́ ayo dáŋɨ́yɨ́ ududɨ́ néra nuro aŋɨ́ nɨyonɨ Judia pɨropenɨsɨ́ dɨ́wɨ́ mɨŋɨ́yo amɨ gɨmɨ ŋweagɨ́á pɨ́né “Irisabetí niaíwɨ́ xɨráná xano Sekaraiao maŋɨ́ pɨ́rónɨŋo maŋɨ́ exoaŋoɨ.” rɨ́agɨ́a arɨ́á nɨwiro ");
INSERT INTO aak_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","dɨŋɨ́ aumaúmɨ́ ninɨro Gorɨxo Jonomɨ dɨŋɨ́ ukɨkayoŋagɨ nɨwɨnɨro re rɨnɨgɨ́awixɨnɨ, “Niaíwɨ́ o rɨ́wéná pí pí ámá imónɨnɨ́árɨ́anɨ?” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Xano Sekaraiaomɨ kwíyɨ́ Gorɨxoyápɨ ukɨkayoŋáná o wɨ́á rókiamorɨgɨ́á wónɨŋɨ́ nimónɨrɨ Jisaso nánɨ re rɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isɨrereneyá Ámɨná Gorɨxomɨ seáyɨ e oumeaneyɨ. O xegɨ́ ámaéne arɨrá neairɨ yeáyɨ́ neayimɨxemearɨ nɨneairɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ eŋɨ́ eánɨŋɨ́ wo iwiaroŋoɨ. O xɨ́oyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiagɨ́ Depitoyá ɨ́wiárɨ́awé worɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eŋíná o nánɨ Gorɨxoyá wɨ́á rókiamoagɨ́áwa xwɨyɨ́á Gorɨxo rɨŋɨ́ nɨwurɨyirɨ́ná negɨ́ arɨ́owamɨ re urɨgɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Ámá nene mɨxɨ́ neaiarɨgɨ́áyɨ́ nánɨ éɨ́ neamínɨrɨ wikɨ́ tɨ́nɨ neaiarɨgɨ́áyɨ́ nánɨ éɨ́ neamínɨrɨ enɨ́árɨnɨ.’ urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gorɨxo negɨ́ arɨ́owamɨ re urɨŋɨnigɨnɨ, ‘Nionɨ wá nɨseawianɨrɨ xwɨyɨ́á sɨ́mɨmaŋɨ́yo dánɨ “Nemɨ́árɨnɨ.” nɨrɨrɨ réroárɨŋáyɨ́ sɨ́mɨ́ e nɨtɨnɨrɨ nɨseaiimɨ́árɨnɨ.’ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","negɨ́ arɨ́o írɨŋo Ebɨrɨ́amomɨ sɨ́ŋá tɨ́ŋɨ́ e dánɨ re urɨŋɨnigɨnɨ, ‘Mɨxɨ́ seaianɨro yarɨgɨ́áyo aiwɨ éɨ́ seamínɨmɨ́árɨnɨ.’ urɨŋɨnigɨnɨ. Mɨxɨ́ neaianɨro yarɨgɨ́áyɨ́ emɨ neamamóáná nene ámɨ wáyɨ́ wí mé amɨpí o ŋwɨ́ ikaxɨ́ nearɨŋɨ́yɨ́ nɨxɨ́dɨrane nɨŋwearane ");
INSERT INTO aak_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sɨnɨ sɨŋɨ́ nɨŋwearɨ́ná wé rónɨŋɨ́ imónɨrane sanɨŋɨ́ imónɨrane nerane píránɨŋɨ́ xɨ́danɨ́wárɨnɨ.” Sekaraiao e nɨrɨ́ɨsáná ");
INSERT INTO aak_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","xewaxo Jono sɨnɨ pɨ́omɨ re umearɨŋɨnigɨnɨ, “Niaíwoxɨnɨ, ayɨ́ re rɨrɨpɨ́rɨ́árɨnɨ, ‘Gorɨxo seáyɨ e ŋweaŋoyá wɨ́á rókiamoarɨŋoxɨrɨnɨ.’ rɨrɨpɨ́rɨ́árɨnɨ. Joxɨ Ámɨnáomɨ óɨ́ nɨwimoirɨ xámɨ umearɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Joxɨ óɨ́ nɨwimoirɨ́ná xegɨ́ ámáyo re urayirɨ́árɨnɨ, ‘Seyɨ́né ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro éáná Gorɨxo segɨ́ ɨ́wɨ́ yarɨgɨ́áyɨ́ yokwarɨmɨ́ nɨseaiirɨ “Ananɨ eɨnɨ.” searɨnɨ́árɨnɨ.’ urayirɨ́árɨnɨ.” Sekaraiao e nɨrɨrɨ ámɨ ");
INSERT INTO aak_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","re rɨŋɨnigɨnɨ, “Gorɨxo wá neaomɨxɨrɨ ayá neawianɨrɨ neaiarɨŋorɨnɨ. O nene nánɨ aŋɨ́namɨ dánɨ sogwɨ́ wɨ́á ókiarɨŋɨ́nɨŋɨ́ wɨ́á neaókiénapɨnɨ́árɨnɨ. O nene sɨ́á yinɨŋɨ́mɨ ŋweaŋwaéne ámá nɨpeanɨrɨ yarɨŋwaéne óɨ́ sanɨŋɨ́yimɨ neawárɨnɨ́a nánɨ nene nɨneaméra nɨneaurɨ wɨ́á neaómɨxɨyinɨ́árɨnɨ.” Sekaraiao e rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Niaíwɨ́ Jono xwé nerɨ́ná xegɨ́ dɨŋɨ́ enɨ rɨxa eŋɨ́ neánɨrɨ dɨŋɨ́ sɨxɨ́ níga nurɨ́ná ámá dɨŋɨ́ meaŋɨ́ e nɨŋweaŋɨsáná xegɨ́ Isɨrerɨyo xewanɨŋo sɨŋánɨ wimónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jonomɨ rɨxa nɨxɨrɨmáná eŋáná Romɨyɨ́ mɨxɨ́ ináyɨ́ Sisa Ogasɨtasoyɨ rɨnɨŋo oyá ŋwɨ́ ikaxɨ́ bɨ re rɨŋɨ́rɨnɨ, “Ámá xwɨ́á nɨrímɨnɨ ŋweagɨ́áyɨ́ wigɨ́ xiáwo írɨŋowayá aŋɨ́ e nánɨ numiróná gɨ́ gapɨmanowamɨ yoɨ́ ŋwɨrárɨ́ɨ́rɨxɨnɨ.” rɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yoɨ́ ŋwɨrárarɨgɨ́áyɨ́ e dánɨ iwamɨ́ó ŋwɨrárɨgɨ́árɨnɨ. Yoɨ́ iwamɨ́ó ŋwɨrárɨgɨ́íná gapɨmanɨ́ xegɨ́ yoɨ́ Sairiniaso ínaŋorɨnɨ. O Siria pɨropenɨsɨ́yo meŋweaŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","E rɨŋɨ́ eŋagɨ nánɨ ámá nɨ́nɨ gapɨmanowamɨ yoɨ́ ŋwɨrárɨpɨ́rɨ nánɨ wigɨ́ xiáwowayá aŋɨ́ e nánɨ numiróná ");
INSERT INTO aak_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","ámá wo, xegɨ́ yoɨ́ Josepoyɨ rɨnɨŋo —O mɨxɨ́ ináyɨ́ Depitoyá ɨ́wiárɨ́awé worɨnɨ. O xiepí sɨnɨ xɨ́omɨ mɨmeánɨŋí —Í xegɨ́ yoɨ́ Mariaírɨnɨ. Sɨnɨ mɨmeánɨŋí aiwɨ niaíwɨ́ agwɨ́ eŋírɨnɨ. Í tɨ́nɨ nawínɨ Gariri pɨropenɨsɨ́yo aŋɨ́ yoɨ́ Nasaretɨ ŋweagɨ́íe dánɨ nɨweri Judia pɨropenɨsɨ́yo o xegɨ́ xiáwo írɨŋoyá aŋɨ́ e Betɨrexemɨyɨ rɨnɨŋe nɨrémori ");
INSERT INTO aak_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","e nɨŋwearɨ́ná í niaíwɨ́ agwɨ́ rɨxa yóɨ́ nerɨ ");
INSERT INTO aak_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","niaíwɨ́ oxɨ́ xámɨ iwamɨ́ó xɨrɨŋo o xɨrɨŋɨnigɨnɨ. Nɨxɨrɨmáná rapɨrapɨ́ tɨ́nɨ xopɨxopɨ́ nɨrorɨ aŋɨ́ ámá mɨdánɨ nɨbɨro wéɨ́rɨxɨnɨrɨ mɨrɨnɨŋiwá rɨxa nɨréroŋagɨ́a nánɨ burɨmákaú aiwá narɨŋe bokisɨ́ wámɨ ínɨmɨ sá wɨ́rárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aŋɨ́ apɨ tɨ́ŋɨ́ e ámá wa sipɨsipɨ́ awí mearoarɨgɨ́á wa árɨ́wɨyimɨ amɨ́yo wigɨ́ sipɨsipɨ́ ará wɨwákwínɨ́ yarɨŋe awí mearoŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aŋɨ́najɨ́ Gorɨxoyá wo wigɨ́ sɨ́mɨmaŋɨ́ tɨ́ŋɨ́mɨ dánɨ sɨŋánɨ rónapáná awa rogɨ́e mɨdɨmɨdánɨ Gorɨxoyá wɨ́á ókímɨxáná awa óɨ́ nikárɨnɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","aŋɨ́najo re urɨŋɨnigɨnɨ, “Wáyɨ́ mepanɨ. Xwɨyɨ́á naŋɨ́ ámá nɨ́nɨ dɨŋɨ́ yayɨ́ winɨpaxɨ́ bɨ soyɨ́né tɨ́ŋɨ́ e nánɨ nɨmeámɨ barɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Xwɨyɨ́á nionɨ nɨmeámɨ barɨŋápɨ rɨpɨrɨnɨ. Agwɨ ríná aŋɨ́ mɨxɨ́ ináyɨ́ Depito xwé iwiaroŋɨ́pimɨ apɨxɨ́ wí niaíwɨ́ seyɨ́né yeáyɨ́ seayimɨxemeanɨ́o xɨrɨŋoɨ. O Kiraisoyɨ rarɨgɨ́orɨnɨ. Yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́orɨnɨ. Ámɨnáorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Soyɨ́né nuro niaíwɨ́ xɨrɨ́o rapɨrapɨ́ nɨxopenɨmáná burɨmákaú aiwá narɨgɨ́ámɨ dánɨ bokisɨ́yo sá wɨ́rárɨnɨŋagɨ nɨwɨnɨrɨ́ná ‘Orɨ́anɨ?’ yaiwíɨ́rɨxɨnɨ.” urɨ́ɨ́yɨ́ re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aŋɨ́najɨ́ áwaŋɨ́ urɨ́o roŋe Gorɨxoyá sɨmɨŋɨ́ wínarɨgɨ́á obaxɨ́ aŋɨ́namɨ dáŋowa enɨ nɨrónapɨmáná Gorɨxomɨ seáyɨmɨ numero re rɨgɨ́awixɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ŋwɨ́á aŋɨ́namɨ seáyɨmɨ ŋweaŋomɨ seáyɨ e oumeaneyɨ. Ámá Gorɨxo nánɨ dɨŋɨ́ arɨ́á mikeamóagɨ́á —O ayɨ́ nánɨ wimónarɨŋɨ́rɨnɨ. Ayɨ́ Gorɨxoyá xewaxo rɨxa rémóáná dɨŋɨ́ wɨ́á wónáná awayinɨ nɨsanɨro ŋweáɨ́rɨxɨnɨ.” nɨrɨmowa ");
INSERT INTO aak_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","sipɨsipɨ́ awí mearoarɨgɨ́áwamɨ pɨ́nɨ nɨwiárɨmɨ aŋɨ́namɨ nánɨ peyíáná awa re rɨnɨgɨ́awixɨnɨ, “Betɨrexemɨ niaíwɨ́ rémóe irɨ́niɨ́ nurane Gorɨxo áwaŋɨ́ nearɨ́ɨ́ nánɨ sɨŋwɨ́ owɨnaneyɨ.” nɨrɨnɨmowa ");
INSERT INTO aak_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","17","aŋɨ́nɨ nuro Josepo tɨ́nɨ Mariaí tɨ́nɨ rípaú ŋweaŋagɨ́i nɨwɨnɨro ámɨ wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Niaíwo burɨmákaú aiwá narɨgɨ́e bokisɨ́yo riwo wɨ́rárɨnɨŋagɨ nɨwɨnɨro pɨ́né aŋɨ́najowa niaíwɨ́ o nánɨ urɨ́ɨ́pɨ nánɨ áwaŋɨ́ uráná ");
INSERT INTO aak_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ámá pɨ́né sipɨsipɨ́ awí mearoarɨgɨ́áwa urɨ́ápɨ arɨ́á wiarɨgɨ́áyɨ́ nɨ́nɨ dɨŋɨ́ ududɨ́ nero aí ");
INSERT INTO aak_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaí xwɨyɨ́á íwo nánɨpɨ dɨŋɨ́ aumaúmɨ́ ninɨrɨ dɨŋɨ́ nɨpɨkíga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","sipɨsipɨ́ awí mearoarɨgɨ́áwa ámɨ wigɨ́ sipɨsipɨ́ awí mearoarɨgɨ́e nánɨ nuróná aŋɨ́najo urɨ́ɨ́pɨ xɨxenɨ éɨ́ eŋagɨ wɨnɨro arɨ́á wiro nero nánɨ Gorɨxomɨ seáyɨmɨ umero yayɨ́ umero wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Niaíwo xɨnáí nɨxɨrɨmáná eŋáná rɨxa sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo óráná omɨ iyɨ́ sɨ́mɨ́ sɨ́ó wákwianɨróná yoɨ́ aŋɨ́najo eŋíná xɨnáí sɨnɨ agwɨ́ meŋáná “Yoɨ́ Jisasoyɨ wɨ́rɨ́ɨrɨxɨnɨ.” urɨŋɨ́pɨ wɨ́rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sɨ́á Mariaí “Ŋwɨ́ ikaxɨ́ Moseso eŋíná nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́pɨ tɨ́nɨ xɨxenɨ nerɨ igɨ́á oeánɨmɨnɨ.” yaiwiŋɨ́yi imónɨŋáná ayaú Jisaso Gorɨxoyá wo oimónɨrɨ mɨnɨ wianɨri nánɨ nɨmeámɨ Jerusaremɨ nánɨ nuri ");
INSERT INTO aak_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","—Ámɨnáoyá ŋwɨ́ ikaxɨ́ re nɨrɨnɨrɨ eánɨŋɨ́pɨ, “Niaíwɨ́ oxɨ́ xámɨ óɨ́ imóo Gorɨxomɨ mɨnɨ nɨwiro ‘Dɨxorɨnɨ.’ urɨ́ɨ́rɨxɨnɨ.” nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ ");
INSERT INTO aak_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","í niaíwɨ́ xɨrɨ́ɨ́ nánɨ igɨ́á eánɨmɨnɨrɨ nánɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ re rɨnɨŋɨ́pa “Nionɨ nánɨ xawiówɨ́ waúranɨ, agwɨrɨwɨ́ waúranɨ, rɨdɨyowá niíɨ́rɨxɨnɨ.” E rɨnɨŋɨ́pa ayaú naŋwɨ́ rɨdɨyowá yanɨri nánɨ nuri Jerusaremɨ nɨrémori aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwiri ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pa yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","íná ámá Jerusaremɨyo ŋweagɨ́áyɨ́ wo —O xegɨ́ yoɨ́ Simionorɨnɨ. O ámá wé rónɨŋɨ́ imónɨrɨ Gorɨxomɨ píránɨŋɨ́ uxɨ́dɨrɨ yarɨŋorɨnɨ. Ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ niwiarorɨ xegɨ́ Isɨrerɨyo yeáyɨ́ uyimɨxemeanɨ́o nánɨ xwayɨ́ nanɨrɨ ŋweaŋorɨnɨ. Kwíyɨ́ Gorɨxoyápɨ omɨ ukɨkayoŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gorɨxo Simionomɨ dɨŋɨ́ nukɨkayorɨ́ná kwíyɨ́ tɨ́nɨ wɨ́á re urókiamoŋɨnigɨnɨ, “Joxɨ sɨnɨ mɨpepa eŋáná ámá Ámɨnáonɨyá dɨŋɨ́ tɨ́nɨ yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́omɨ sɨŋwɨ́ wɨnɨrɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simiono Gorɨxoyá kwíyɨ́ ukɨkayoŋagɨ nánɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ Jisasomɨ xanɨyaú ŋwɨ́ ikaxɨ́ Gorɨxo rɨŋɨ́pa wiianɨri nánɨ xɨ́omɨ nɨmeámɨ ɨ́wiaparɨŋagɨ́i nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","íwomɨ nurápɨrɨ ɨ́á nɨmaxɨrɨmáná Gorɨxomɨ seáyɨmɨ numerɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ámɨnáoxɨnɨ, joxɨ nɨrɨŋɨ́pa ámá nene yeáyɨ́ neayimɨxemeanɨ́omɨ rɨxa sɨŋwɨ́ tɨ́ tɨ́nɨ nɨwɨnɨrɨ nánɨ ayá sɨ́wɨ́ mɨnɨró ananɨ xe pémɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Joxɨ rɨŋɨ́pa ámá nɨ́nɨyá sɨŋwɨ́yo dánɨ dɨxɨ́ yeáyɨ́ neayimɨxemeanɨ́o rɨxa neaiapɨ́ɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ámá joxɨ neaiapɨ́o wɨ́ánɨŋɨ́ ókiarɨŋɨ́pa émáyo nuréwapɨyirɨ́ná wɨ́á wómɨxɨyinɨ́árɨnɨ. O negɨ́ Isɨrereneyá aŋɨ́ re dánɨ xɨrɨ́ɨ́ eŋagɨ nánɨ ámá nɨ́nɨ nene seáyɨmɨ neamepɨ́rɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","íwomɨ xanɨyaú Simiono egɨ́ íwo nánɨ xwɨyɨ́á apɨ rarɨŋagɨ arɨ́á nɨwiri ududɨ́ neri mɨŋɨ́ sɨ́ŋá nɨweánɨri yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiono ayaúmɨ “Gorɨxo naŋɨ́ oeaimɨxɨnɨ.” nurɨrɨ íwomɨ xɨnáí Mariaímɨ re urɨŋɨnigɨnɨ, “Arɨ́á eɨ. Íwɨ́ romɨ Isɨrerɨyɨ́ nɨ́nɨ wí arɨ́á nɨwiro dɨŋɨ́ wɨkwɨ́róɨ́áyɨ́ seáyɨ e imónɨpɨrɨ́árɨnɨ. Wí arɨ́á mɨwí nero dɨŋɨ́ mɨwɨkwɨ́ró éɨ́áyɨ́ anɨpá imónɨpɨ́rɨ́árɨnɨ. Gorɨxo ‘Ámá nɨ́nɨ naŋɨ́ oimónɨ́poyɨ.’ wimónɨŋagɨ nánɨ íwɨ́ ro sɨ́mɨmajɨ́ónɨŋɨ́ yárɨnɨŋagɨ nánɨ ámá obaxɨ́ wikɨ́ nɨwónɨro ikayɨ́wɨ́ numearɨro yarɨ́ná ayɨ́ ínɨmɨ dánɨ dɨŋɨ́ wiawiarɨgɨ́áyɨ́ sɨŋánɨ imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jíxɨ mɨŋɨ́ mɨxɨ́ yarɨgɨ́ápá tɨ́nɨ rɨróagɨ́ánɨŋɨ́ íwɨ́ ro nánɨ íkɨ́nɨŋɨ́ sɨpí e sinɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gorɨxoyá wɨ́á rókiamoarɨgɨ́á wí —Í Panueromɨ xemiáí xegɨ́ yoɨ́ Anaírɨnɨ. Xiáwo írɨŋo Asao tɨ́nɨ gwɨ́ axɨ́rírɨnɨ. Í rɨxa apiaŋírɨnɨ. Oxɨ́ nɨmeánɨrɨ nɨŋwearɨ́ná xwiogwɨ́ wé wɨ́úmɨ dáŋɨ́ waú múróáná ");
INSERT INTO aak_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","xiagwo rɨxa nɨpéáná í apɨxɨ́ anɨ́ nimónɨrɨ nɨŋwearɨ xegɨ́ xwiogwɨ́ nɨ́nɨ rɨxa 84 imónɨŋírɨnɨ. Í aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ bɨ mɨpeyeá ikwáwɨyiranɨ, árɨ́wɨyiranɨ, aiwá ŋwɨ́á ŋwearɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wirɨ yarɨŋírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Í enɨ aŋiwámɨ íwo ɨ́á nɨxɨrɨrɨ ŋweagɨ́íe axíná nɨrémorɨ íwomɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná Gorɨxomɨ yayɨ́ nɨwimí nurɨ ámá “Gorɨxo gíná Jerusaremɨ ŋweaŋwaéne gwɨ́nɨŋɨ́ nearoayíronɨ́árɨ́anɨ?” yaiwiarɨgɨ́áyo íwɨ́ o nánɨ áwaŋɨ́ nura uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Xanɨyaú Gorɨxo ŋwɨ́ ikaxɨ́ rɨŋɨ́pa rɨxa nɨpɨnɨ nɨyárɨmɨ Gariri pɨropenɨsɨ́yo egɨ́ aŋɨ́ Nasaretɨyɨ rɨnɨŋe nánɨ íwomɨ nɨmeámɨ nɨyiri e ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","íwo xwé niwiarorɨ Gorɨxo omɨ ayá nurɨmɨxɨrɨ dɨŋɨ́ ukɨkayoŋagɨ nánɨ eŋɨ́ eánɨrɨ amɨpí nánɨ dɨŋɨ́ eŋwɨperɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xanɨyaú xwiogwɨ́ o omɨ aiwá Gorɨxoyá aŋɨ́najo xiáwowa Isipɨyɨ́ aŋɨ́yo ŋweaŋáná mɨpɨkí múroŋɨ́yimɨ —Sɨ́á ayimɨ aiwá Pasopayɨ rɨnɨŋɨ́ imɨxarɨgɨ́árɨnɨ. Sɨ́á ayi nánɨ dɨŋɨ́ winɨnɨ nánɨ Jerusaremɨ nánɨ nuayiri yayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisaso xwiogwɨ́ rɨxa wé wúkaú sɨkwɨ́ waú eŋáná sɨ́á Gorɨxo múroŋɨ́yi rɨxa aŋwɨ ayo imónɨŋáná xanɨyaú yarɨgɨ́ípa nánɨ Jisaso xɨ́o tɨ́nɨ Jerusaremɨ nánɨ nɨyiro ");
INSERT INTO aak_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","sɨ́á aiwá apɨ nanɨro nánɨ nɨŋweagɨ́asáná ámɨ aŋɨ́ e nánɨ nurɨ́ná Jisaso sɨnɨ Jerusaremɨ ŋweaŋáná xanɨyaú majɨ́á nimónɨri ");
INSERT INTO aak_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","re yaiwigɨ́isixɨnɨ, “Jisaso ámá negɨ́ wí tɨ́nɨ rɨxa púɨnigɨnɨ.” nɨyaiwiri warɨ́ná sɨ́á wɨyi órɨ́agɨ ayaú egɨ́ ámáyo tɨ́nɨ ámá egɨ́ imoarɨgɨ́íyo tɨ́nɨ pɨ́á imɨmɨ́ neri ");
INSERT INTO aak_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pɨ́á yopa nɨmegɨnárɨri ámɨ Jerusaremɨ nánɨ nɨyiri pɨ́á néra núɨ́isáná ");
INSERT INTO aak_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","rɨxa sɨ́á wɨyaú wɨyi óráná wenɨŋɨ́ éɨ́íyɨ́ wɨnɨgɨ́isixɨnɨ. Aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ ínɨmɨ riwo ŋweaŋagɨ nɨwɨnɨri o Gorɨxoyá ŋwɨ́ ikaxɨ́ uréwapɨyarɨgɨ́á wamɨ áwɨnɨ e nɨŋweámáná yarɨŋɨ́ wirɨ arɨ́á wirɨ yarɨŋagɨ nɨwɨnɨri ");
INSERT INTO aak_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ámá Jisaso pɨ́né ráná arɨ́á nɨwiro ŋweagɨ́áyɨ́ nɨ́nɨ aga ududɨ́ nero re yaiwigɨ́awixɨnɨ, “O arɨre nerɨ nɨjɨ́á nimónɨrɨ rɨ́a rarɨnɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","xanɨyaú omɨ sɨŋwɨ́ nɨwɨnɨri ududɨ́ nɨwiri xɨnáí re urɨŋɨnigɨnɨ, “Íwe, pí nánɨ e yeaíwapɨyarɨŋɨnɨ? Yaípawi ayá sɨ́wɨ́ yearoarɨŋagɨ nánɨ joxɨ nánɨ pɨ́á yarɨŋwiɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","o re urɨŋɨnigɨnɨ, “Pí nánɨ aípagwí nionɨ nánɨ amɨ amɨ pɨ́á emearɨŋiɨ? ‘Xanoyá dɨŋɨ́ tɨ́nɨ xɨ́oyá aŋɨ́ riwámɨ ínɨmɨ ŋweanɨ.’ mɨyaiwiarɨŋɨ́ reŋiɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","xwɨyɨ́á xɨ́o urɨ́ɨ́pɨ nánɨ xanɨyaú nɨpɨkwɨnɨ nɨjɨ́á mimónɨpa neri ");
INSERT INTO aak_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","xɨ́o tɨ́nɨ nawínɨ nuro wigɨ́ aŋɨ́ Nasaretɨ nɨrémoro Jisaso xanɨyaúmɨ arɨ́á yɨ́mɨgɨ́ nɨwirɨ ŋweaŋáná xɨnáí amɨpí nɨ́nɨ o éɨ́ nánɨ dɨŋɨ́ aumaúmɨ́ inarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisaso sɨnɨ xwé nimóga nurɨ́ná dɨŋɨ́ eŋwɨperɨ xwé imónɨrɨ néra warɨ́ná Gorɨxo tɨ́nɨ ámá nɨ́nɨ tɨ́nɨ enɨ o nánɨ “Ámá naŋorɨnɨ.” nɨyaiwia wagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibiriasɨ Sisao mɨxɨ́ ináyɨ́ nimónɨrɨ xwiogwɨ́ wé wúkaú sɨkwɨ́ wú ámá Romɨyo nɨmeŋweámáná eŋáná Podiasɨ Pairato Judia pɨropenɨsɨ́yo gapɨmanɨ́ nɨyonɨ nánɨ xɨráónɨŋɨ́ nimónɨrɨ meŋweaŋáná Adipasɨ Xeroto Gariri pɨropenɨsɨ́yo gapɨmanɨ́ ámɨnáo nimónɨrɨ meŋweaŋáná xexɨrɨ́meáo Piripo Ituria pɨropenɨsɨ́yo tɨ́nɨ Rɨrakonaitisɨ pɨropenɨsɨ́yo tɨ́nɨ gapɨmanɨ́ ámɨnáo nimónɨrɨ meŋweaŋáná Raiseniaso gapɨmanɨ́ ámɨnáo nimónɨrɨ Abirini pɨropenɨsɨ́yo meŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anaso tɨ́nɨ xɨneagwo Kaiapaso tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́íwaú seáyɨ e nimónɨri meŋweaŋáná Jono —O xegɨ́ xano Sekaraiaorɨnɨ. O ámá dɨŋɨ́ meaŋe ŋweaŋáná Gorɨxo nɨrɨ́pearɨ re urɨŋɨnigɨnɨ, “Nionɨyá xwɨyɨ́á rɨpɨ Isɨrerɨyo wáɨ́ urɨméɨrɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","o iniɨgɨ́ Jodanɨ rapá tɨ́ŋɨ́ e wáɨ́ nemerɨ re urɨmeŋɨnigɨnɨ, “Ámáyɨ́né ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro yarɨ́náyɨ́ nionɨ wayɨ́ seameairɨ Gorɨxo ɨ́wɨ́ yarɨgɨ́áyɨ́ yokwarɨmɨ́ seaiirɨ enɨ́árɨnɨ.” nurɨmerɨ ");
INSERT INTO aak_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","eŋɨ́pa Gorɨxoyá wɨ́á rókiamoagɨ́á wo xegɨ́ yoɨ́ Aisaiaoyɨ rɨnɨŋo eŋíná Jono sɨnɨ meŋáná o nánɨ nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨnigɨnɨ, “Ámá dɨŋɨ́ meaŋɨ́mɨ dánɨ ámá wo rɨ́aiwá re rɨnɨ́árɨnɨ, ‘Ámɨnáo rɨ́wɨ́yo bɨnɨ́o nánɨ segɨ́ dɨŋɨ́ óɨ́ naŋɨ́nɨŋɨ́ wimoiro óɨ́ píránɨŋɨ́ imoarɨgɨ́ápánɨŋɨ́ wimoiro neróná ");
INSERT INTO aak_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","sɨ́kwioxɨ́ imónɨŋɨ́yɨ́ xwɨ́á xewiároro dɨ́wɨ́ xwéranɨ, onɨmiáranɨ, yɨpároro óɨ́ nɨrɨ́rɨworɨ inɨŋɨ́yo naŋɨ́ imɨxárɨro óɨ́ sɨ́ŋá nɨŋwearɨ xɨxoarɨ́wɨ́ néra uŋɨ́yɨ́ píránɨŋɨ́ imɨxárɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","E nerɨ́ná ámá nɨ́nɨ Gorɨxo yeáyɨ́ neayimɨxemeámɨnɨrɨ yarɨŋagɨ wɨnɨpɨ́rɨ́árɨnɨ.’ Ámá wo rɨ́aiwá e rɨnɨ́árɨnɨ.” Aisaiao eŋíná Jono nánɨ e nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jono Gorɨxo urɨŋɨ́pa wáɨ́ urɨmearɨ́ná oxɨ́ apɨxɨ́ obaxɨ́ Jono wayɨ́ neameainɨŋoɨnɨrɨ o tɨ́ŋɨ́ e nánɨ barɨ́ná o ayɨ́ nɨsanɨro mé wayɨ́nɨ meaanɨro yarɨŋagɨ́a nɨwɨnɨrɨ re urayiŋɨnigɨnɨ, “Sidɨrɨ́ miaéyɨ́né, ‘Rɨ́wéná Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ éɨ́ úpoyɨ.’ go searɨ́agɨ seyɨ́né wáyɨ́ nero Gorɨxo e neaikárɨnɨgɨnɨrɨ nionɨ tɨ́ámɨnɨ éɨ́ barɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","re urɨŋɨnigɨnɨ, “Seyɨ́né ɨ́wɨ́ yarɨgɨ́ápɨ nepa rɨ́wɨ́mɨnɨ nɨmamorɨ́náyɨ́ píránɨŋɨ́ nero íkɨ́á sogwɨ́ naŋɨ́ nɨwerɨ́ná yarɨŋɨ́pa imónɨ́ɨ́rɨxɨnɨ. Seyɨ́né re mɨrɨnɨpa époyɨ, ‘Negɨ́ arɨ́o Ebɨrɨ́amoyaéne imónɨŋagwɨ nánɨ Gorɨxo wí xeanɨŋɨ́ neaikárɨnɨ́á menɨnɨ.’ mɨrɨnɨpa époyɨ. ‘Gorɨxo Ebɨrɨ́amoyá ɨ́wiárɨ́awé nánɨ “Nionɨ ayo xeanɨŋɨ́ nɨwirɨ́ná arɨge xwé obaxɨ́ imónɨnɨ́árɨnɨ?” nɨyaiwirɨ ududɨ́ winarɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ, Gorɨxo dɨŋɨ́ e yaiwipaxɨ́ menɨnɨ. Ananɨ sɨ́ŋá tɨ́yo dánɨ Ebɨrɨ́amo nánɨ ɨ́wiárɨ́awé wimɨxɨyipaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gorɨxo rɨxa rapɨwé íkɨ́á mɨ́kɨ́ tɨ́ŋɨ́ e nánɨ ɨ́á xɨrɨnɨ. Íkɨ́á gɨnɨ gɨna sogwɨ́ naŋɨ́ mɨwéagɨ nɨwɨnɨrɨ́ná nɨdɨkárɨrɨ rɨ́á ikeaárɨnɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ámá o tɨ́ŋɨ́ e epɨ́royɨ́ egɨ́áyɨ́ yarɨŋɨ́ nɨwiayiro re urɨgɨ́awixɨnɨ, “Nene nɨsanɨrɨ nɨŋwearanéná pí yanɨ́wárɨnɨ?” urayíagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jono re urayiŋɨnigɨnɨ, “Ámá iyɨ́á wúkaú tɨ́ŋo wú ámá iyɨ́á mayomɨ mɨnɨ wíwɨnɨgɨnɨ. Ámá aiwá tɨ́ŋo enɨ mayomɨ mɨnɨ wíwɨnɨgɨnɨ.” nurɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á wa wayɨ́ meaanɨro nɨbɨróná yarɨŋɨ́ re wigɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, none nɨsanɨrɨ nɨŋwearanéná pí yanɨ́wárɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","o re urɨŋɨnigɨnɨ, “Nɨgwɨ́ takisɨ́ nánɨ nɨnearápɨmerɨ́ná nɨgwɨ́ gapɨmanowa ‘Urápɨ́ɨ́rɨxɨnɨ.’ searɨgɨ́ápɨ wiárɨ́ nɨmúroro seáyɨ e mɨnearápɨpanɨ.” nurɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Porisɨ́ wa enɨ nɨbɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “None enɨ nɨsanɨrane nɨŋwearanéná pí yanɨ́wárɨnɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “Soyɨ́né ámáyá nɨgwɨ́ urápanɨro nánɨ iwaŋɨ́ eamero xwɨrɨxɨ́ mero yapɨ́ uxekwɨ́moro mepa éɨ́rɨxɨnɨ. Segɨ́ nɨgwɨ́ omɨŋɨ́ nero meáɨ́ápɨnɨ nɨmearɨ́ná ‘Ayɨ́ apánɨrɨnɨ.’ yaiwíɨ́rɨxɨnɨ. Ámá wayá nánɨ ayá sɨ́wɨ́ mɨsearopanɨ.” nurɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","oxɨ́ apɨxɨ́ nɨ́nɨ “Ámá Gorɨxoyá dɨŋɨ́yo dánɨ nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o gíná imónɨnɨ́árɨ́anɨ?” nɨyaiwiróná xwɨyɨ́á Jono wáɨ́ urɨmearɨŋɨ́pɨ arɨ́á nɨwiro nánɨ dɨŋɨ́ re nɨpɨkíga ugɨ́awixɨnɨ, “Ámá Gorɨxoyá dɨŋɨ́ tɨ́nɨ yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo ámá ro menɨranɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jono áwaŋɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ sa iniɨgɨ́ tɨ́nɨ wayɨ́ seameaiarɨŋɨnɨ. Nionɨ eŋɨ́ neánɨrɨ aiwɨ rɨ́wɨ́yo bɨnɨ́o nionɨ nɨmúrónɨnɨ. Nionɨ ámá naŋonɨ aiwɨ o nionɨ tɨ́nɨ xɨxenɨ mimónɨŋagɨ nánɨ ámá omɨŋɨ́ wiiarɨgɨ́áyɨ́ bosoyá sɨkwɨ́ sú gwɨ́ wíkweaiarɨgɨ́ápa nionɨ oyá wikweaipaxɨ́manɨ. O wayɨ́ nɨseameairɨ́ná iniɨgɨ́ tɨ́nɨ seameainɨ́ámanɨ. Gorɨxoyá kwíyɨ́ tɨ́nɨ seameairɨ rɨ́á tɨ́nɨ seameairɨ enɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gorɨxo ámá naŋɨ́yo yeáyɨ́ nuyimɨxemearɨ sɨpíyo anɨpá imɨxɨrɨ enɨ́á eŋagɨ nánɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá pokɨ́ tɨ́nɨ witɨ́ aiwá eyeyírómɨ́ ero aiwá ná aŋɨ́yo tɨro mamɨwɨ́ tɨ́nɨ sɨyikɨ́ tɨ́nɨ rɨ́á ikeaárɨro yarɨgɨ́ápa Gorɨxo enɨ axɨ́pɨ e emɨ́ánɨrɨ witɨ́ mamɨwɨ́ tɨ́nɨ ná tɨ́nɨ eyeyírómɨ́ inɨŋe aiwá náyɨ́ aŋɨ́yo tɨrɨ mamɨwɨ́ tɨ́nɨ sɨyikɨ́ tɨ́nɨ rɨ́á ikeaárɨrɨ emɨnɨrɨ nánɨ xegɨ́ pokɨ́ ɨ́á nɨxɨrɨrɨ ronɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E nurɨrɨ ámá dɨŋɨ́ oyaiwípoyɨnɨrɨ xwɨyɨ́á wí wí enɨ obaxɨ́ urɨrɨ xwɨyɨ́á yayɨ́ winɨpaxɨ́pɨ rɨ́wɨ́yo Gorɨxo urowárénapɨnɨ́o nánɨ urɨrɨ nerɨ ");
INSERT INTO aak_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","gapɨmanɨ́ Xeroto ɨ́wɨ́ erɨ xexɨrɨ́meáoyá apɨxɨ́ Xerodiasíyɨ rɨnɨŋí urápɨrɨ yarɨŋagɨ Jono mɨxɨ́ nurɨrɨ “Ɨ́wɨ́ nɨ́nɨ joxɨ yarɨŋɨ́pɨ naŋɨ́manɨ. Dɨxɨ́ rɨrɨxɨ́meáoyá apɨxí nurápɨrɨ́ná ‘Naŋɨ́ yarɨŋɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Xeroto ɨ́wɨ́ nɨ́nɨ apɨ neŋagɨ aí ámɨ wínɨ nerɨ Jonomɨ gwɨ́ nɨyirɨ kɨrapusɨ́ aŋɨ́yo ŋwɨrárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jisaso, Jono sɨnɨ gwɨ́ mɨŋwɨrárɨnɨ́ eŋáná ámáyo wayɨ́ numeairɨ yarɨ́ná, Jisaso enɨ nɨbɨrɨ Jono omɨ wayɨ́ umeaíáná Jisaso éɨ́ nɨrorɨ xano Gorɨxomɨ rɨxɨŋɨ́ urarɨ́ná re eŋɨnigɨnɨ. Aŋɨ́namɨ dánɨ óɨ́ inɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kwíyɨ́ Gorɨxoyá xawiówɨ́nɨŋɨ́ nimónɨrɨ o tɨ́ŋɨ́ e nánɨ weapɨrɨ aŋɨ́namɨ dánɨ xwɨyɨ́á wí re rɨnénapɨrɨ “Gɨ́ íwɨ́ dɨŋɨ́ sɨxɨ́ rɨyiŋáoxɨnɨ, joxɨ nánɨ aga yayɨ́ ninarɨnɨ.” rɨnénapɨrɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisaso ámáyo iwamɨ́ó nuréwapɨyemerɨ́ná xegɨ́ xwiogwɨ́ 30 imónɨŋɨnigɨnɨ. Oxɨ́ apɨxɨ́ o nánɨ dɨŋɨ́ re yaiwiagɨ́árɨnɨ, “Josepomɨ xewaxorɨnɨ.” yaiwiagɨ́árɨnɨ. Josepomɨ xano Xiraiorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Omɨ xano Matatorɨnɨ. Omɨ xano Ripaiorɨnɨ. Omɨ xano Merɨkaiorɨnɨ. Omɨ xano Janaiorɨnɨ. Omɨ xano Joseporɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Omɨ xano Matataiasorɨnɨ. Omɨ xano Emosorɨnɨ. Omɨ xano Neamorɨnɨ. Omɨ xano Esɨraiorɨnɨ. Omɨ xano Nagaiorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Omɨ xano Meatorɨnɨ. Omɨ xano Matataiasorɨnɨ. Omɨ xano Semenorɨnɨ. Omɨ xano Josekorɨnɨ. Omɨ xano Jodaorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Omɨ xano Joananorɨnɨ. Omɨ xano Resaorɨnɨ. Omɨ xano Serababerorɨnɨ. Omɨ xano Siarɨtierorɨnɨ. Omɨ xano Neraiorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Omɨ xano Merɨkaiorɨnɨ. Omɨ xano Edaiorɨnɨ. Omɨ xano Kosamorɨnɨ. Omɨ xano Erɨmedamorɨnɨ. Omɨ xano Erorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Omɨ xano Josuaorɨnɨ. Omɨ xano Eriesaorɨnɨ. Omɨ xano Jorimorɨnɨ. Omɨ xano Matatorɨnɨ. Omɨ xano Ripaiorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Omɨ xano Simionorɨnɨ. Omɨ xano Judaorɨnɨ. Omɨ xano Joseporɨnɨ. Omɨ xano Jonamorɨnɨ. Omɨ xano Eraiakimorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Omɨ xano Meriaorɨnɨ. Omɨ xano Menaorɨnɨ. Omɨ xano Matataorɨnɨ. Omɨ xano Netanorɨnɨ. Omɨ xano Depitorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Omɨ xano Jesiorɨnɨ. Omɨ xano Obetorɨnɨ. Omɨ xano Bowasorɨnɨ. Omɨ xano Sarɨmonorɨnɨ. Omɨ xano Nasonorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Omɨ xano Aminadaporɨnɨ. Omɨ xano Atɨminorɨnɨ. Omɨ xano Anaiorɨnɨ. Omɨ xano Xesɨronorɨnɨ. Omɨ xano Peresorɨnɨ. Omɨ xano Judaorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Omɨ xano Jekoporɨnɨ. Omɨ xano Aisakorɨnɨ. Omɨ xano Ebɨrɨ́amorɨnɨ. Omɨ xano Tiraorɨnɨ. Omɨ xano Nexorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Omɨ xano Serakorɨnɨ. Omɨ xano Reuorɨnɨ. Omɨ xano Perekorɨnɨ. Omɨ xano Ebeorɨnɨ. Omɨ xano Seraorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Omɨ xano Kenanorɨnɨ. Omɨ xano Apakɨsatorɨnɨ. Omɨ xano Siemorɨnɨ. Omɨ xano Nowaorɨnɨ. Omɨ xano Remekorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Omɨ xano Metusaraorɨnɨ. Omɨ xano Inokorɨnɨ. Omɨ xano Jaretorɨnɨ. Omɨ xano Maxararerorɨnɨ. Omɨ xano Kenanorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Omɨ xano Inosorɨnɨ. Omɨ xano Setorɨnɨ. Omɨ xano Adamorɨnɨ. Omɨ xano Gorɨxorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisaso kwíyɨ́ Gorɨxoyápɨ omɨ nɨwímearɨ ukɨkayoŋáná iniɨgɨ́ Jodanɨ rapáyo dánɨ peyarɨ́ná kwíyɨ́ Gorɨxoyápɨ ámá dɨŋɨ́ meaŋe nɨméra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","sɨ́á 40 órarɨ́ná Obo “O eŋɨ́ neánɨrɨ xano wimónarɨŋɨ́pɨnɨ xɨ́dɨnɨrɨ́enɨŋoɨ?” nɨyaiwirɨ omɨ iwamɨ́ó nɨwíwapɨyayirɨ yarɨ́ná sɨ́á ayo aiwá mɨnɨ́ néra núɨsáná sɨ́á 40 imónáná rɨxa agwɨ́ wiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Obo re urɨŋɨnigɨnɨ, “Joxɨ nepa niaíwɨ́ Gorɨxoyáoxɨ eŋánáyɨ́ aiwá nɨrɨ nánɨ sɨ́ŋá tɨyɨ́, ‘Bisɨ́kerɨ́á imóneɨ.’ ureɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisaso re urɨŋɨnigɨnɨ, “Oweoɨ, wí e emɨméɨnɨ. Gorɨxoyá Bɨkwɨ́yo dánɨ re nɨrɨnɨrɨ eánɨnɨ, ‘Ámá aiwá nɨpɨ́rɨ nánɨnɨ dɨŋɨ́ nɨmorɨ́náyɨ́, wí dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ meapaxɨ́ menɨnɨ.’ rɨnɨŋagɨ nánɨ joxɨ nɨrɨ́ɨ́pɨ wí emɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Obo Jisaomɨ seáyɨ émɨ nɨmeáa nɨpeyirɨ aŋɨ́ nɨ́nɨ xwɨ́á rɨrí nɨrímɨnɨ nánɨ imónɨŋɨ́yo aŋɨ́nɨ axíná sɨwá nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","re urɨŋɨnigɨnɨ, “Aŋɨ́ nɨ́nɨ xwɨ́á rɨrí nɨrímɨnɨ nánɨ imónɨŋɨ́yo joxɨ sɨwá siarɨŋápɨ ayɨ́ nionɨyárɨnɨ. Nɨ́nɨ rɨxa nɨgɨ́nɨ imónɨnɨ. ‘Ámá womɨ mɨnɨ owimɨnɨ.’ nɨyaiwirɨ́ná ananɨ mɨnɨ wipaxɨ́rɨnɨ. Joxɨ nionɨ nánɨ mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ nionɨ seáyɨ e nɨméánáyɨ́ ayɨ́ nɨ́nɨ weyɨ́ meararɨgɨ́ápɨ apɨ tɨ́nɨ dɨxɨ́ siapɨmɨ́ɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisaso re urɨŋɨnigɨnɨ, “Bɨkwɨ́ Gorɨxoyáyo re nɨrɨnɨrɨ eánɨnɨ, ‘Dɨxɨ́ Ámɨná Gorɨxomɨnɨ mɨŋɨ́ xwɨ́áyo ɨkwɨ́rorɨ seáyɨ e umerɨ erɨ́ɨnɨ.’ rɨnɨŋagɨ nánɨ joxɨ nɨrarɨŋɨ́pɨ wí e emɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Obo “Jisaso xegɨ́ xano Gorɨxo eŋɨ́ eánɨŋorɨ́anɨrɨ iwamɨ́ó owíwapɨyinɨrɨ yapɨ́ owíwapɨyimɨnɨ.” nɨyaiwirɨ omɨ aŋɨ́ Jerusaremɨyo nánɨ nɨmeáa nurɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ xegɨ́ rɨkwɨ́yo nɨŋwɨrárɨmáná re urɨŋɨnigɨnɨ, “Joxɨ nepa niaíwɨ́ Gorɨxoyáoxɨ eŋánáyɨ́, xwɨ́ámɨ nánɨ nɨmawirɨ xeamoɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ayɨ́ rɨpɨ nánɨ rɨrarɨŋɨnɨ. Gorɨxoyá Bɨkwɨ́yo xwɨyɨ́á rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Gorɨxo xegɨ́ aŋɨ́najɨ́ joxɨ nánɨ píránɨŋɨ́ awí ŋweapɨ́rɨ nánɨ re urɨnɨŋoɨ, “Omɨ awí mearópoyɨ.” urɨnɨŋoɨ.’ nɨrɨnɨrɨ eánɨŋagɨ nánɨ nɨmawirɨ xeamoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","re urɨŋɨnigɨnɨ, “Rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Joxɨ sɨkwɨ́ sɨ́ŋáyo pɨ́rɨ́ uyɨkieámɨ́ inɨrɨxɨnɨrɨ ayɨ́ ɨ́á rɨxɨrɨpɨ́rɨ wé awiá sipɨ́ráoɨ.’ enɨ nɨrɨnɨrɨ eánɨŋagɨ nánɨ ananɨ nɨmawirɨ xeamóáná ‘Gorɨxomɨ xewaxorɨ́anɨ?’ siaiwimɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ re dánɨ nɨpiérorɨ́náyɨ́, joxɨ nɨrarɨŋɨ́pa Gorɨxo aŋɨ́najɨ́ nionɨ ɨ́á nɨxɨrɨpɨ́rɨ nurowárénapɨpaxɨ́ aí rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Dɨxɨ́ Ámɨná Gorɨxoyá eŋɨ́ eánɨŋɨ́pimɨ iwamɨ́ó mɨwíwapɨyipanɨ.’ eánɨŋagɨ nánɨ wí nɨmawirɨ xeamómɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","E uráná obo iwamɨ́ó nɨ́nɨ e nɨwíwapɨyíɨsáná omɨ pɨ́nɨ nɨwiárɨmɨ nurɨ idáná ámɨ wíwapɨyipaxɨ́ imónáná nánɨ wenɨŋɨ́ nerɨ ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisaso kwíyɨ́ Gorɨxoyápɨ ukɨkayoŋagɨ ámá dɨŋɨ́ meaŋe pɨ́nɨ nɨwiárɨmɨ nurɨ ámɨ Gariri pɨropenɨsɨ́yo nemerɨ pɨ́né o nánɨ pɨropenɨsɨ́ ayo amɨ amɨ yanɨ́ iwénɨmearɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","o aŋɨ́ apɨ apimɨ nemerɨ wigɨ́ rotú aŋɨ́yo uréwapɨyemearɨ́ná oxɨ́ apɨxɨ́ nɨ́nɨ xɨ́omɨ seáyɨ e umeaagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisaso Nasaretɨyo nánɨ nurɨ —Aŋɨ́ ayo xɨ́o sɨnɨ onɨmiá íná nɨŋwearɨ xwé iwiaroŋɨ́yo nánɨ nurɨ xegɨ́ íníná yarɨŋɨ́pa Sabarɨ́áyo rotú aŋɨ́yo nɨpáwirɨ Bɨkwɨ́ Gorɨxoyá ɨ́á rómɨnɨrɨ nánɨ éɨ́ nɨrorɨ ");
INSERT INTO aak_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","rɨxa Bɨkwɨ́ Gorɨxoyá wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo eaŋɨ́pɨ umeaíáná o nɨparɨrɨ xwɨyɨ́á rɨpɨ rɨnɨŋe nánɨ pɨ́á nerɨ nɨwɨnɨrɨ́ná ɨ́á re roŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kwíyɨ́ Gorɨxoyápɨ nionɨ nɨkɨkayonɨ. Nionɨ ámá uyípeayɨ́yo xwɨyɨ́á yayɨ́ winɨpaxɨ́ imónɨŋɨ́pɨ urɨmɨ́a nánɨ nɨrɨ́pearɨ ámá ɨ́á xeŋwɨrárɨnɨŋɨ́yo ‘Sɨnɨ seyɨ́né ɨ́á mɨseaxeŋwɨrárɨnɨ. Ananɨ úpoyɨ.’ urɨmɨ́a nánɨ nɨrowárénapɨrɨ ámá sɨŋwɨ́ supárɨgɨ́áyo ‘Ananɨ sɨŋwɨ́ noxoarɨ anɨ́poyɨ.’ urɨmɨ́a nánɨ nɨrowárénapɨrɨ ámá iwaŋɨ́ mépero xopɨrárɨ́ wiro egɨ́áyo yeáyɨ́ imɨxɨmɨ́a nánɨ nɨrowárénapɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Gorɨxo xegɨ́ ámá éɨ́ uminɨnɨyɨ́ aŋwɨ ayorɨnɨ.’ urɨmɨ́a nánɨ nɨrowárénapɨrɨ eŋɨ́rɨnɨ.” Jisaso ɨ́á e nɨroárɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bɨkwɨ́ ámɨ nɨxopemɨxárɨmáná rotú aŋɨ́ mearɨŋɨ́ womɨ mɨnɨ nɨwimáná éɨ́ nɨŋwearɨ ámá rotú aŋɨ́yo ŋwɨxapɨgɨ́áyɨ́ omɨnɨ sɨŋwɨ́ agwɨ́ nɨwɨga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","o “Xɨ́o nánɨ rɨ́a rarɨnɨ?” oyaiwípoyɨnɨrɨ iwamɨ́ó nurɨrɨ re urɨŋɨnigɨnɨ, “Agwɨnɨ rɨ́wamɨŋɨ́ nionɨ ɨ́á róápɨ seyɨ́né arɨ́á nɨwirɨ́ná rɨxa xɨxenɨ imónɨgoɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","nɨ́nɨ o nánɨ naŋɨ́nɨ nɨra uro xwɨyɨ́á awɨ́ínɨŋɨ́ yarɨŋɨ́ xɨ́o rɨ́ɨ́ jɨ́apɨ nánɨ dɨŋɨ́ nɨpɨkíga uro nero aí re rɨnɨgɨ́awixɨnɨ, “Ámá royɨ́ sa aŋɨ́ re dáŋɨ́ Josepomɨ xewaxorɨnɨ. Arɨge nerɨ nɨjɨ́á xwé apɨ imónɨŋɨ́rɨ́anɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","o re urɨŋɨnigɨnɨ, “Seyɨ́né ewayɨ́ xwɨyɨ́á rɨpɨ nɨnɨrɨpɨ́ráoɨ, ‘Joxɨ nepa xwɨroxɨ eŋánáyɨ́, jɨwanɨŋoxɨ píránɨŋɨ́ imɨxɨneɨ.’ nɨrɨpɨ́ráoɨ. E nɨnɨrɨróná re nɨrɨpɨ́ráoɨ, ‘ “Emɨmɨ́ amɨpí aŋɨ́ Kapaneamɨyo eŋoɨ.” rarɨŋagɨ́a arɨ́á wiŋwápɨ ámɨ dɨxɨ́ aŋɨ́ re enɨ emɨmɨ́ neaiɨ.’ nɨrɨpɨ́ráoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","re urɨŋɨnigɨnɨ, “Nepa seararɨŋɨnɨ. Wɨ́á rókiamoarɨŋɨ́ wo o xegɨ́ aŋɨ́yo nánɨ nurɨ Gorɨxoyá xwɨyɨ́á uráná xegɨ́ ámá e ŋweagɨ́áyɨ́ omɨ mímɨnarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E nerɨ aiwɨ nionɨ nepa seararɨŋagɨ píránɨŋɨ́ arɨ́á nípoyɨ. Eŋíná wɨ́á rókiamoagɨ́ Iraijao emearɨ́ná agwɨ́ aŋɨ́ pɨrɨ́nɨ erɨ iniá meapa erɨ ámá nɨ́nɨ aiwá nánɨ dɨ́wɨ́ ikeamónɨro eŋáná Isɨrerɨyɨ́ apɨxɨ́ anɨ́ obaxɨ́ ŋweaŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gorɨxo Iraijao íwamɨ wímɨ arɨrá wíwɨnɨgɨnɨrɨ murowárɨ́ émáyɨ́ apɨxɨ́ wímɨnɨ —Í Saidonɨ tɨ́ŋɨ́ e aŋɨ́ onɨmiá Seraparɨ rɨnɨŋɨ́ bimɨ dáŋírɨnɨ. Ímɨnɨ arɨrá wíwɨnɨgɨnɨrɨ wárɨŋɨnigɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","re urɨŋɨnigɨnɨ, “Eŋíná wɨ́á rókiamoagɨ́ Iraisao nemerɨ́ná enɨ Isɨrerɨyɨ́ obaxɨ́ peyɨyɨ́ tɨ́gɨ́áyɨ́ egɨ́á aiwɨ Iraisao ayo womɨ naŋɨ́ wimɨxagɨ́manɨ. Émáyɨ́ womɨnɨ —O Siria dáŋɨ́ xegɨ́ yoɨ́ Nemenorɨnɨ. Omɨnɨ naŋɨ́ wimɨxɨŋɨ́rɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ámá nɨ́nɨ rotú aŋɨ́yo ŋweagɨ́á arɨ́á e nɨwiróná xwioxɨ́yo dánɨ rɨ́á ápiáwɨ́nɨŋɨ́ nɨwóróa nuro ");
INSERT INTO aak_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nɨwiápɨ́nɨmearo omɨ ɨ́á nɨxɨrɨro wigɨ́ aŋɨ́yo dánɨ nɨxoyɨ́pióa nuro dɨ́wɨ́ mɨŋɨ́ wigɨ́ aŋɨ́ mɨrɨnɨŋɨ́pimɨ dánɨ mamówáranɨro nánɨ xɨxoyɨ́piɨ́ nɨméra yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","o áwɨnɨmɨ nɨyékínɨmɨ xegɨ́ dɨŋɨ́ tɨ́nɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisaso Gariri pɨropenɨsɨ́yo nemerɨ́ná aŋɨ́ xegɨ́ yoɨ́ Kapaneamɨyo nɨrémorɨ Sabarɨ́áyo nuréwapɨyirɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ámá ayɨ́ arɨ́á nɨwiróná o xwɨyɨ́á apɨ xiáwónɨŋɨ́ rarɨŋagɨ nɨwɨnɨro mɨŋɨ́ sɨ́ŋá nɨweánɨro yarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ámá rotú aŋɨ́yo ŋweagɨ́áyɨ́ wo —O imɨ́ó dɨŋɨ́ xɨxéroarɨŋorɨnɨ. O nɨwiápɨ́nɨmearɨ makɨrɨ́wɨ́ nɨmorɨ ");
INSERT INTO aak_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","re urɨŋɨnigɨnɨ, “Ai! Nasaretɨ dáŋɨ́ Jisasoxɨnɨ, none pí neaimɨnɨrɨ barɨŋɨnɨ? Xwɨrɨ́á neaikɨxémɨnɨrɨ rɨbarɨŋɨnɨ? Joxɨ nánɨ nionɨ nɨjɨ́árɨnɨ. Gorɨxo xewaxoxɨ xɨ́o rɨrɨ́peáoxɨrɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisaso mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámɨ bɨ mɨrɨpa eɨ. Omɨ pɨ́nɨ nɨwiárɨmɨ uɨ.” uráná re eŋɨnigɨnɨ. Imɨ́o ámá omɨ xwɨrɨ́á wí mikɨxé ámáyo áwɨnɨmɨ dánɨ meaŋɨ́nɨ neaárɨmɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Meaŋɨ́nɨ neaárɨmɨ úáná ámá nɨ́nɨ óɨ́ nikárɨnɨro re rɨnɨgɨ́awixɨnɨ, “Xwɨyɨ́á oyá eŋɨ́ sɨxɨ́ eánɨnɨ. O nénɨ́ tɨ́ŋónɨŋɨ́ nɨrɨrɨ́ná sekaxɨ́ uráná imɨ́ó aí arɨ́á nɨwiro éɨ́ warɨŋoɨ.” nɨrɨnɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","xwɨyɨ́á o yarɨŋɨ́pɨ nánɨ pɨropenɨsɨ́ ayo amɨ amɨ yanɨ́ iwénɨmeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisaso nɨwiápɨ́nɨmeámɨ rotú aŋɨ́yo pɨ́nɨ nɨwiárɨmɨ nɨpeyearɨ xegɨ́ wiepɨsarɨŋɨ́ wo Saimonoyɨ rɨnɨŋoyá aŋɨ́yo nánɨ nurɨ nɨpáwirɨ omɨ xɨneagwí rɨ́á pɨrɨ́ wiarɨŋagɨ nánɨ ímɨ naŋɨ́ owimɨxɨnɨrɨ yarɨŋɨ́ wíagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","o í sá weŋe nánɨ nurɨ nɨrómáná rɨ́á pɨrɨ́yo mɨxɨ́ uráná re eŋɨnigɨnɨ. Sɨmɨxɨ́pɨ ímɨ pɨ́nɨ nɨwiárɨmɨ úáná í rɨxa aŋɨ́nɨ nɨwiápɨ́nɨmearɨ aiwá pɨrɨ́ nɨmearɨ nɨwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ámá aŋɨ́ apimɨ dáŋɨ́yɨ́ sogwɨ́ rɨxa nipɨ́meááná wigɨ́ ámá sɨmɨxɨ́ xɨxegɨ́nɨ yarɨgɨ́áyɨ́ nɨmeámɨ Jisaso tɨ́ŋɨ́ e nánɨ báná o ámá ayɨ́ ayo wé seáyɨ e ikwɨkwiárɨmɨ́ erɨ naŋɨ́ imɨmɨxɨmɨ́ erɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","imɨ́ó ámá ayo wíyo obaxɨ́ xɨxéroarɨŋɨ́yɨ́ ámá ayo pɨ́nɨ nɨwiárɨmɨ nuróná makɨrɨ́wɨ́ nɨmoayiro re urayigɨ́awixɨnɨ, “Niaíwɨ́ Gorɨxoyáoxɨrɨnɨ.” urayarɨŋagɨ́a o imɨ́owa xɨ́o arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o eŋagɨ nánɨ nɨjɨ́á imónɨŋagɨ́a nánɨ o mɨxɨ́ nurɨrɨ “Ámɨ bɨ mɨrɨpa époyɨ.” ururɨmɨ́ nerɨ e néɨsáná ");
INSERT INTO aak_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","sá weŋo wɨ́á mónɨŋɨ́mɨ nɨwiápɨ́nɨmeámɨ ámá mayɨ́ e nánɨ nurɨ ŋweaŋáná ámá oxɨ́ apɨxɨ́ nɨ́nɨ o nánɨ pɨ́á nemero omɨ nɨwímearóná “Nene pɨ́nɨ nɨneawiárɨmɨ mupanɨ.” uranɨro yarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","o re urɨŋɨnigɨnɨ, “Gorɨxo re nɨrowárénapɨŋɨ́rɨnɨ, ‘Aŋɨ́ ayɨ́ ayo re urɨméɨrɨxɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ seyɨ́né nɨsanɨro ŋweáɨ́rɨxɨnɨ.” urɨméɨrɨxɨnɨ.’ nɨrowárɨ́ɨ́ eŋagɨ nánɨ aŋɨ́ wíyo xwɨyɨ́á yayɨ́ winɨpaxɨ́ imónɨŋɨ́ apɨ urɨmɨnɨrɨ enɨ xe oumɨnɨ.” nurɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Judayɨ́yá aŋɨ́ apɨ apimɨ rotú aŋɨ́ mɨrɨnɨŋɨ́yo dánɨ nuréwapɨya uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisaso ipí xegɨ́ yoɨ́ Genesaretɨpámɨ éɨ́ nɨrómáná xwɨyɨ́á Gorɨxoyá urarɨ́ná ámá obaxɨ́ arɨ́á wianɨro nánɨ xɨmɨxɨmɨ́ ninɨro Jisasomɨ ɨkwɨkwierɨ́ winarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ewé bɨ́xaú, yánɨpámɨ tɨ́á bɨ́xaú weŋagɨ nɨwɨnɨrɨ peyɨ́ ápearɨgɨ́áwa ewé apɨ́xaúmɨ dánɨ nayoámáná wigɨ́ ubenɨ́ igɨ́á eaarɨŋagɨ́a nɨwɨnɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ewé bɨ́bá Saimonoyápámɨ nɨpɨxemoánɨrɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Inɨkí tɨ́ŋɨ́ re pɨ́nɨ nɨwiárɨmɨ ná jɨ́e onɨmiápɨ ananɨ nɨwanɨréwiɨ?” nurɨrɨ éɨ́ nɨŋweámáná ewé apámɨ dánɨ oxɨ́ apɨxɨ́ ipí maŋɨ́pá tɨ́ŋɨ́ e rówapɨgɨ́áyo nuréwapɨyirɨ ");
INSERT INTO aak_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","rɨxa nɨpɨnɨ nurárɨmáná Saimonomɨ re urɨŋɨnigɨnɨ, “Ipí ná mɨ́mɨ eŋe nánɨ nɨmeámɨ nuri peyɨ́ ɨ́áyo mɨnɨnɨ nánɨ ubenɨ́ mamówárɨ́piyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimono re urɨŋɨnigɨnɨ, “Negɨ́ neamemearɨŋoxɨnɨ, sɨ́á rɨyimɨ árɨ́wɨyimɨ peyɨ́ ɨ́á wí nɨmɨnɨrɨ́enɨŋoɨnɨrɨ anɨŋɨ́ minɨ́ mépearɨŋáná wɨ́á neaógoɨ. E nerɨ aiwɨ joxɨ e yearɨ́agɨ nánɨ ye iwamɨ́ó mamówáranɨ́wiɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","mamówáráná re eŋɨnigɨnɨ. Ubenɨ́ ú peyɨ́ obaxɨ́yo nɨmudɨ́morɨ rɨxa arɨ́kínɨmɨnɨrɨ yarɨŋagɨ nɨwɨnɨri ");
INSERT INTO aak_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","wigɨ́ wɨ́waúmɨ ewé bɨ́bámɨ ŋweagɨ́íwaú saŋɨ́ oyearápɨ́piyɨnɨrɨ wápiá nɨwiri awaú nɨbɨri ubenɨ́ nɨmɨxearo ewépɨ́xaúmɨ ikwiáráná ewépɨ́xaú rɨxa ná ínɨmɨnɨrɨ yarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimonɨ Pitao sɨŋwɨ́ e nɨwɨnɨrɨ nánɨ Jisasoyá sɨkwɨ́ tɨ́ŋɨ́ e mɨŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nionɨ ɨ́wɨ́ yarɨŋáonɨ eŋagɨ nánɨ pɨ́nɨ nɨnɨwiárɨmɨ uɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","peyɨ́ aga xwé nɨmearo nánɨ o tɨ́nɨ xegɨ́ ámá nɨkumɨxɨnɨrɨ peyɨ́ nánɨ yarɨgɨ́áwa tɨ́nɨ ududɨ́ nikárɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebediomɨ xewaxowaú Jemiso tɨ́nɨ xogwáo Jono tɨ́nɨ awaú Saimonomɨ nɨkumɨxɨnɨri peyɨ́ nánɨ yarɨgɨ́íwaú enɨ ududɨ́ ikárɨnarɨ́ná Jisaso Saimonomɨ re urɨŋɨnigɨnɨ, “Joxɨ wáyɨ́ mikárɨnɨpanɨ. Agwɨ re dánɨ peyɨ́ nánɨ yarɨŋɨ́pánɨŋɨ́ ámá nánɨ enɨ e néra urɨ́árɨnɨ. Ámá nionɨ nɨxɨ́dɨpɨ́rɨ́a nánɨ wirɨmearɨ́árɨnɨ.” nurɨmáná eŋáná ");
INSERT INTO aak_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","awa ewé nɨmeámɨ nɨbɨro yánɨ e dánɨ nayoaro ewé peyɨ́ amɨpí e nɨtɨmɨ omɨ nɨxɨ́da ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisaso aŋɨ́ wíyo nemerɨ aŋɨ́ bimɨ ŋweaŋáná ámá wo —O peyɨyɨ́ pɨpɨ́rɨmɨ́ó yárɨŋorɨnɨ. O Jisasomɨ nɨwɨnɨrɨ́ná oyá sɨkwɨ́ tɨ́ŋɨ́ e sɨ́mɨmaŋɨ́ xwɨ́áyo nɨkwɨ́rorɨ waunɨ́ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ naŋɨ́ nimɨxɨmɨnɨrɨ́náyɨ́ ananɨ naŋɨ́ nimɨxɨpaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisaso wé nɨmoaurɨ omɨ seáyɨ e nikwiárɨmáná re urɨŋɨnigɨnɨ, “Nionɨ ‘Joxɨ naŋɨ́ oimónɨnɨ.’ nimónarɨnɨ. Rɨxa naŋɨ́ imóneɨ.” uráná re eŋɨnigɨnɨ. Peyɨyɨ́ apɨ rɨxa naŋɨ́ imónáná ");
INSERT INTO aak_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisaso “Ámá wíyo nionɨ simɨxɨ́áyɨ́ nánɨ áwaŋɨ́ murɨpa eɨ.” nurɨrɨ ámá o Moseso eŋíná ŋwɨ́ ikaxɨ́ ragɨ́pɨ mé ámáyo xewanɨŋo áwaŋɨ́ nura emenɨgɨnɨrɨ e nurɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Amíná apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa tɨ́ŋɨ́ e nánɨ nurɨ womɨ sɨwá nɨwinɨrɨ naŋwɨ́ rɨdɨyowá nánɨ negɨ́ arɨ́o Moseso eŋíná sekaxɨ́ nearagɨ́yɨ́ bɨ rɨdɨyowá siárirɨ joxɨ naŋɨ́ imónɨ́ɨ́yɨ́ nánɨ áwaŋɨ́ rɨrɨ enɨ mɨnɨ wíɨrɨxɨnɨ.” Jisaso sekaxɨ́ e urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","xwɨyɨ́á emɨmɨ́ amɨpí Jisaso yayiŋɨ́yɨ́ nánɨ yanɨ́ rɨxa ná jɨ́amɨ niwéa nemerɨ yarɨ́ná oxɨ́ apɨxɨ́ obaxɨ́ omɨ arɨ́á wianɨro nánɨ bɨro sɨmɨxɨ́ wiarɨŋɨ́yɨ́ naŋɨ́ oneaimɨxɨnɨrɨ bɨro nero o tɨ́ŋɨ́ e nɨpɨ́nɨro nɨŋwearo e yayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","o íníná ámá dɨŋɨ́ meaŋe nánɨ nɨwayirɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wiagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","O sɨ́á wɨyimɨ ámáyo uréwapɨyarɨ́ná ámá wa Parisiyɨ rɨnɨŋɨ́yɨ́ wa tɨ́nɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ uréwapɨyarɨgɨ́áyɨ́ wa tɨ́nɨ —Awa Gariri pɨropenɨsɨ́yo aŋɨ́ ayɨ́ ayo dánɨ bɨmiro Judia pɨropenɨsɨ́yo aŋɨ́ ayɨ́ ayo dánɨ bɨmiro Isɨrerɨyɨ́ aŋɨ́ xwé Jerusaremɨ dánɨ enɨ bɨro egɨ́áwarɨnɨ. Awa Jisaso uréwapɨyarɨŋe éɨ́ nɨŋwearo arɨ́á wiarɨ́ná Jisaso ámá sɨmɨxɨ́ wiarɨŋɨ́yo naŋɨ́ owimɨxɨmɨnɨrɨ nánɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ Gorɨxoyápɨ ukɨkayoŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ámá wa wigɨ́ ámá womɨ —O eŋɨ́ nɨ́nɨ sɨwímɨ́ yárɨŋorɨnɨ. Omɨ íkwiaŋwɨ́yo nɨtɨro Jisaso naŋɨ́ owimɨxɨnɨrɨ nɨmeámɨ nɨbɨro “Nɨmeámɨ nɨpáwirane Jisasoyá sɨ́mɨmaŋɨ́mɨnɨ aŋwɨ e owɨ́ráraneyɨ.” nɨrɨro éɨ́áyɨ́ ");
INSERT INTO aak_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ámá obaxɨ́ aŋɨ́ ɨ́wí e pɨ́kwɨpɨ́kwɨ́ inɨŋagɨ́a óɨ́ nánɨ pɨ́á nɨmegɨnɨro aŋiwámɨ nɨmeámɨ nɨxéga nɨpeyiro aŋɨ́ sɨ́á tɨnɨŋɨ́yɨ́ wí nɨpɨneaayiro dae nɨtɨmáná íkwiaŋwɨ́na tɨ́nɨ gwɨ́ nɨyiro ámá aŋɨ́yo ínɨmɨ epɨ́royɨ́ egɨ́áyo áwɨnɨmɨ gwɨ́rí e e nɨmamówára nɨwepɨ́nɨro Jisaso sɨ́mɨmaŋɨ́ tɨ́ŋɨ́mɨnɨ táná ");
INSERT INTO aak_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisaso eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋoyá ámá nɨ́nɨ xɨ́o nánɨ dɨŋɨ́ wɨkwɨ́roro “Jisaso ananɨ naŋɨ́ imɨxɨpaxɨ́rɨnɨ.” wiaiwiro yarɨŋagɨ́a nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Ámáoxɨnɨ, dɨxɨ́ ɨ́wɨ́ yarɨŋɨ́pɨ rɨxa yokwarɨmɨ́ siíɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Parisiowa tɨ́nɨ ikeagɨgwɨ́ re nɨrɨga ugɨ́awixɨnɨ, “Ámá royɨ́ gorɨ́anɨ? Gorɨxomɨ rɨperɨrɨ́ numearɨrɨ yarɨŋɨ́ royoɨ? Ámá ɨ́wɨ́ yarɨgɨ́áyɨ́ yokwarɨmɨ́ yarɨŋɨ́ royɨ́ gorɨ́anɨ? E yarɨŋɨ́yɨ́ sa Gorɨxorɨnɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisaso xegɨ́ dɨŋɨ́ tɨ́nɨ adadɨ́ nɨwirɨ re urɨŋɨnigɨnɨ, “Nionɨ nánɨ segɨ́ xwioxɨ́yo dánɨ pí nánɨ dɨŋɨ́ e moarɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","re urɨŋɨnigɨnɨ, “Ámá wo ɨ́wɨ́ ikárɨnɨŋɨ́ nionɨ yokwarɨmɨ́ wiíánáyɨ́, ínɨmɨ imónɨŋagɨ nánɨ ámá woxɨ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ wɨnɨpaxɨ́ menɨnɨ. E nerɨ aiwɨ nionɨ ámá eŋɨ́ nɨ́nɨ sɨwímɨ́ eŋɨ́ womɨ ‘Rɨxa nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ uɨ.’ uránáyɨ́, o naŋɨ́ imónɨ́agɨ ámá nɨyɨ́nénɨ sɨŋwɨ́ tɨ́nɨ sɨŋwɨ́ wɨnɨpaxɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","re urɨŋɨnigɨnɨ, “Nɨyɨ́nénɨ nionɨ nánɨ re niaiwipɨ́rɨ, ‘Ámá imónɨŋo ananɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ ɨ́wɨ́ ikárɨnɨ́ápɨ enɨ ananɨ yokwarɨmɨ́ wiipaxorɨ́anɨ?’ niaiwipɨ́rɨ nánɨ píránɨŋɨ́ sɨŋwɨ́ nanɨ́poyɨ.” nurɨrɨ eŋɨ́ sɨwímɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Nionɨ re rɨrarɨŋɨnɨ, ‘Joxɨ nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ aŋɨ́ e nánɨ uɨ.’ rɨrarɨŋɨnɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","O ámá nɨ́nɨ sɨŋwɨ́ anɨgɨ́e dánɨ rɨxa naŋɨ́ nimónɨrɨ nɨwiápɨ́nɨmearɨ xegɨ́ íkwiaŋwɨ́ sá weŋɨ́na nɨmearɨ xwaŋwɨ́ níkwónɨmɨ nɨpeyearɨ Gorɨxomɨ seáyɨ e numéra xegɨ́ aŋɨ́ e nánɨ úáná ");
INSERT INTO aak_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","oxɨ́ apɨxɨ́ nɨ́nɨ óɨ́ nikárɨnɨro Gorɨxomɨ seáyɨ e numero wigɨ́ xwioxɨ́yo dánɨ sɨrɨ́ nɨpɨkínɨro re nɨrɨga ugɨ́awixɨnɨ, “Agwɨ xegɨ́ bɨ éagɨ ríyɨ́ wɨnɨ́wɨnɨ.” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisaso e dánɨ nɨpeyearɨ nurɨ́ná ámá nɨgwɨ́ takisɨ́ nánɨ uráparɨŋɨ́ wo —O xegɨ́ yoɨ́ Ripaiorɨnɨ. Xegɨ́ yoɨ́ ámɨ bɨ Matɨyuorɨnɨ. O xegɨ́ opisɨ́ aŋɨ́yo éɨ́ ŋweaŋagɨ Jisaso sɨŋwɨ́ e nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ nɨxɨ́deɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","o nɨwiápɨ́nɨmearɨ xegɨ́ amɨpí nɨ́nɨ e pɨ́nɨ nɨwiárɨmɨ Jisasomɨ uxɨ́dɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jisaso nánɨ xegɨ́ aŋɨ́yo aiwá xwé bɨ rɨyamɨ́ nerɨ ŋweaŋáná takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á wa tɨ́nɨ ámá wínɨyɨ́ tɨ́nɨ nɨbɨro nawínɨ awaú tɨ́nɨ nɨŋweámáná aiwá nɨnɨro yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi wa tɨ́nɨ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wo tɨ́nɨ Jisaso nánɨ wiepɨsarɨŋowamɨ anɨŋúmɨ́ ikaxɨ́ nurɨro re urɨgɨ́awixɨnɨ, “Soyɨ́né takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á awa tɨ́nɨ ámá ɨ́wɨ́ yarɨgɨ́á wínɨyɨ́ tɨ́nɨ pí nánɨ iniɨgɨ́ nɨro aiwá nɨro yarɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisaso ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá naŋɨ́ yarɨgɨ́áyɨ́ naŋɨ́ oneaimɨxɨnɨrɨ xwɨrɨ́ tɨ́ŋɨ́ e nánɨ warɨgɨ́áranɨ? Oweoɨ! Sɨmɨxɨ́ yarɨgɨ́áyɨ́nɨ xwɨrɨ́ tɨ́ŋɨ́ e nánɨ warɨgɨ́árɨnɨ.” Ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","re urɨŋɨnigɨnɨ, “Nionɨ ámá wé rónɨŋɨ́ imónɨgɨ́áyɨ́ wigɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ mamoro sanɨŋɨ́ imónɨro oépoyɨnɨrɨ bɨŋámanɨ. Ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ mamoro sanɨŋɨ́ imónɨro oépoyɨnɨrɨ bɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ámá wa Jisasomɨ re urɨgɨ́awixɨnɨ, “Jono wiepɨsarɨŋowa íníná aiwá ŋwɨ́á ŋwɨrárɨnɨro Gorɨxomɨ rɨxɨŋɨ́ urɨro yayarɨgɨ́árɨnɨ. Parisiowayá wiepɨsarɨŋowa enɨ axɨ́pɨ yarɨgɨ́árɨnɨ. E nero aiwɨ joxɨ wiepɨsarɨŋɨ́yɨ́ aiwá ŋwɨ́á bɨ mɨŋwɨrárɨnɨ́ íníná aiwá nɨro iniɨgɨ́ nɨro yarɨgɨ́árɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisaso “Nionɨ gɨ́ wiepɨsarɨŋáowa tɨ́nɨ ŋweaŋáná awa aiwá ŋwɨ́á ŋweapaxɨ́manɨ.” urɨmɨnɨrɨ nánɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo apɨxɨ́ meámɨnɨrɨ aiwá imɨxɨ́ɨ́yɨ́ ámá aiwá apɨ nɨpɨ́rɨ nánɨ bɨ́áyɨ́ apɨxɨ́ meáo sɨnɨ ayɨ́ tɨ́nɨ ŋweaŋáná aiwá ŋwɨ́á ŋwɨrárɨnarɨgɨ́áranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","E nerɨ aiwɨ apɨxɨ́ meáo sɨ́á obaxɨ́ wí nórɨmáná eŋáná ámá wí omɨ wanɨ́nɨmɨxáná íná ámá ayɨ́ dɨŋɨ́ sɨpí wiarɨŋagɨ nánɨ aiwá ŋwɨ́á ŋwɨrárɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Xɨ́o rapɨrapɨ́ sɨŋúnɨŋɨ́ imónɨŋagɨ nánɨ ewayɨ́ xwɨyɨ́á ámɨ rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo xegɨ́ rapɨrapɨ́ urú axenɨŋagɨ nɨwɨnɨrɨ́ná pɨ́rómɨnɨrɨ nánɨ xegɨ́ sɨŋú nɨmearɨ naxerɨ pɨ́roarɨŋɨ́ranɨ? Oweoɨ! Sɨŋú naxerɨ́ná xwɨrɨ́á ikɨxenɨŋoɨ. Sɨŋú enɨ naxerɨ pɨ́róánáyɨ́ urú yapɨ xɨxenɨ axɨ́pɨ imónɨnɨmenɨŋoɨ.” nurɨrɨ awa wigɨ́ eŋíná dánɨ “Nene e nerɨ́ná wé rónɨŋɨ́ nimónɨrane nɨperɨ́náyɨ́ ananɨ Gorɨxo tɨ́ŋɨ́ e nánɨ peyanɨ́wárɨnɨ.” nɨra wagɨ́ápɨ sɨnɨ yarɨgɨ́ápɨ tɨ́nɨ xwɨyɨ́á sɨŋɨ́ tɨ́nɨ nawínɨ ɨkwieropɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ámɨ axɨ́ rɨpɨ re urɨŋɨnigɨnɨ, “Ámá wo re yarɨŋɨ́manɨ. Memé wará sɨxɨ́ urɨ́yo iniɨgɨ́ wainɨ́ sɨŋɨ́ iwajɨ́á yarɨŋɨ́manɨ. E nerɨ́náyɨ́, memé wará sɨxɨ́ awá núpɨyinɨrɨ wainɨ́ apɨ purɨ memé wará sɨxɨ́wá xwɨrɨ́á ikɨxénɨrɨ enɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iniɨgɨ́ wainɨ́ sɨŋɨ́yɨ́ memé wará sɨxɨ́ sɨŋɨ́yo iwajɨ́á yarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Xɨ́o yarɨŋɨ́pɨ nánɨ ámɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá gɨyɨ́ iniɨgɨ́ wainɨ́ pɨrɨ́yɨ́ nɨnɨmáná sɨnɨ sɨŋɨ́yɨ́ nánɨ wimónarɨŋɨ́rɨnɨ? Oweoɨ, sɨnɨ sɨŋɨ́yɨ́ nánɨ mɨwimónɨ́ ‘Pɨrɨ́yɨ́ apánɨrɨnɨ.’ rarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisaso xegɨ́ wiepɨsarɨŋowa tɨ́nɨ Sabarɨ́á wɨyimɨ witɨ́ omɨŋɨ́yo áwɨnɨmɨ óɨ́yo nuróná witɨ́ siyɨ́ yánɨŋɨ́ sɨŋɨ́ yɨyírɨmɨ́ nemáná mamɨwɨ́ nánɨ wé tɨ́nɨ xwɨyɨxwɨyɨ́ nɨroro nɨgápaŋɨ́ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisi wa re urɨgɨ́awixɨnɨ, “Soyɨ́né sabarɨ́áyo ‘Ŋwɨ́árɨnɨ.’ rɨnɨŋɨ́yo pí nánɨ aiwá nɨmiaga warɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisaso re urɨŋɨnigɨnɨ, “Mɨxɨ́ ináyɨ́ Depito eŋíná eŋɨ́yɨ́ sɨnɨ ɨ́á mɨroarɨŋɨ́ reŋoɨ? Oweoɨ, ɨ́á nɨroro aiwɨ sɨnɨ nɨjɨ́á mimónɨŋoɨ. O tɨ́nɨ ámá xɨ́o tɨ́nɨ emearɨgɨ́áyɨ́ tɨ́nɨ agwɨ́ nɨwirɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","senɨ́á aŋɨ́ Gorɨxo nánɨ peaxɨ́ tayarɨgɨ́iwámɨ o nɨpáwirɨ ‘Ŋwɨ́árɨnɨ.’ rɨnɨŋɨ́yɨ́, bisɨ́kerɨ́á Gorɨxo nánɨ peaxɨ́ tayarɨgɨ́áyɨ́ nɨmearɨ nɨnɨrɨ xegɨ́ ámá nɨkumɨxɨnɨrɨ emearɨgɨ́áyo mɨnɨ wiŋɨnigɨnɨ. Bisɨ́kerɨ́á peaxɨ́ tayarɨgɨ́á apɨ sa apaxɨ́pánɨŋɨ́ imónɨgɨ́áwanɨ ananɨ nɨpaxɨ́rɨnɨ.” nurɨrɨ “Depito e yarɨ́ná Gorɨxo mɨxɨ́ wí murɨpa eŋɨ́ eŋagɨ nánɨ gɨ́ wiepɨsarɨŋáowamɨ pí nánɨ mɨxɨ́ urarɨŋoɨ?” urɨmɨnɨrɨ nánɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“ ‘Sabarɨ́áyo ayɨ́ ananɨrɨnɨ.’ rɨpaxorɨ́anɨ?” oyaiwípoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ Sabarɨ́áyo xiáwonɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","O Sabarɨ́á ámɨ wɨyimɨ rotú aŋɨ́yo nɨpáwirɨ uréwapɨyarɨ́ná ámá wo —O xegɨ́ wé náú kɨrɨŋɨ́ eŋorɨnɨ. O enɨ e ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wa tɨ́nɨ Isɨrerɨyɨ́yá Parisiyɨ rɨnɨŋɨ́yɨ́ wa tɨ́nɨ Jisaso ámá wé kɨrɨŋɨ́ eŋomɨ naŋɨ́ imɨxáná none xwɨyɨ́á oumeaaraneyɨnɨro omɨ xwayɨ́ nɨwɨnɨro ŋweaŋagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisaso awa xɨ́omɨ “Xwɨyɨ́á oumeaaraneyɨ.” nɨyaiwiro ŋweaŋagɨ́a nánɨ dɨŋɨ́ adadɨ́ nɨwirɨ ámá wé kɨrɨŋɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Nɨwiápɨ́nɨmeámɨ nɨbɨrɨ ámáyo áwɨnɨ e rónapeɨ.” urɨ́agɨ o nɨwiápɨ́nɨmeámɨ nɨbɨrɨ áwɨnɨ e róáná ");
INSERT INTO aak_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisaso ámá e awí eánɨgɨ́áyo re urɨŋɨnigɨnɨ, “Nionɨ yarɨŋɨ́ bɨ oseaimɨnɨ. ‘Sabarɨ́áyo naŋɨ́ nɨwirɨ́náyɨ́, ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Sɨpí nɨwirɨ́náyɨ́, ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Sabarɨ́áyo ámá naŋɨ́ oimónɨ́poyɨnɨrɨ naŋɨ́ nimɨxɨrɨ́náyɨ́, ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Ámáyo xwɨrɨ́á nikɨxerɨ́náyɨ́, ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ámá e éɨ́ ŋweagɨ́á nɨyonɨ sɨŋwɨ́ nɨwɨnɨmemáná wé kɨrɨŋɨ́ eŋomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ wé irú pɨ́mɨxeɨ.” urɨ́agɨ o e éáná re eŋɨnigɨnɨ. Xegɨ́ wé naŋɨ́ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xegɨ́ wé naŋɨ́ imónɨ́agɨ Parisiowa sɨŋwɨ́ e nɨwɨnɨro wigɨ́ xwioxɨ́yo dánɨ rɨ́ánɨŋɨ́ nɨwóróa úagɨ nuro wigɨ́pɨ jɨ́amɨ dánɨ re rɨnɨgɨ́awixɨnɨ, “None Jisasomɨ pí wipaxɨ́rɨnɨ?” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Íná Jisaso xano Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wimɨnɨrɨ dɨ́wɨ́ mɨŋɨ́yo nɨpeyirɨ sɨ́á ayimɨ Gorɨxomɨ xwɨyɨ́á nura nurɨ ");
INSERT INTO aak_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","rɨxa wɨ́ánɨ wónáná “Wiepɨsarɨŋáyɨ́ obɨ́poyɨ.” nɨrɨrɨ ayo wé wúkaú sɨkwɨ́ waúmɨnɨ nɨrɨ́pearɨ “Nɨgɨ́ wáɨ́ nurɨmeipɨ́rɨ́oyɨ́nérɨnɨ.” urɨŋɨnigɨnɨ. Ámá wé wúkaú sɨkwɨ́ waú rɨ́peaŋowa wigɨ́ yoɨ́ rowarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimono, omɨ Jisaso yoɨ́ ámɨ bɨ Pitaoyɨ wɨ́rɨŋorɨnɨ. O tɨ́nɨ omɨ xogwáo Adɨruo tɨ́nɨ Jemiso tɨ́nɨ Jono tɨ́nɨ Piripo tɨ́nɨ Batoromuo tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matɨyuo tɨ́nɨ Tomaso tɨ́nɨ Arɨpiasomɨ xewaxo Jemiso tɨ́nɨ Saimono tɨ́nɨ —O xegɨ́ yoɨ́ bɨ Seretoyɨ rɨnɨŋorɨnɨ. O tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemisomɨ xewaxo Judaso tɨ́nɨ Isɨkariotɨ dáŋɨ́ Judaso tɨ́nɨ —O Jisaso nánɨ mɨyɨ́ urɨŋorɨnɨ. O tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisaso ámá xɨ́o rɨ́peáowa tɨ́nɨ dɨ́wɨ́ mɨŋɨ́yo dánɨ nɨwero ayoxɨ́ naŋɨ́ e rówapáná oxɨ́ apɨxɨ́ obaxɨ́ íníná xɨ́omɨ xɨ́darɨgɨ́áyɨ́ tɨ́nɨ ámá obaxɨ́ Judia pɨropenɨsɨ́yo dáŋɨ́yɨ́ tɨ́nɨ wigɨ́ aŋɨ́ xwé bɨ Jerusaremɨ dáŋɨ́yɨ́ tɨ́nɨ ámá émáyɨ́ aŋɨ́ biaú Taiayɨ rɨnɨŋɨ́pɨ tɨ́nɨ Saidonɨyɨ rɨnɨŋɨ́pɨ tɨ́nɨ —Aŋɨ́ apiaú rawɨrawá imaŋɨ́ tɨ́nɨ aŋwɨ e ikwɨ́rónɨŋɨ́piaúrɨnɨ. Aŋɨ́ apiaúmɨ dáŋɨ́yɨ́ tɨ́nɨ ");
INSERT INTO aak_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ayɨ́ Jisasomɨ arɨ́á wianɨro bɨmiro negɨ́ sɨmɨxɨ́yɨ́ naŋɨ́ oneaimɨxɨnɨrɨ bɨmiro oxɨ́ apɨxɨ́ imɨ́ó dɨŋɨ́ xɨxérorɨ xɨxeanɨŋɨ́ wirɨ egɨ́áyɨ́ bɨmiro éáná o imɨ́ó mɨxɨ́ umáɨnɨrɨ ámá nɨyonɨ naŋɨ́ nimɨxa urɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","oxɨ́ apɨxɨ́ nɨ́nɨ oyá eŋɨ́ sɨxɨ́ eánɨŋɨ́pɨ ámá nɨyonɨ píránɨŋɨ́ imɨxarɨŋagɨ nɨwɨnɨro ayɨ́ enɨ nɨbɨro omɨ wé amáɨ́ rónanɨro egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisaso xegɨ́ wiepɨsarɨŋɨ́yo sɨŋwɨ́ nɨwɨga nurɨ re urɨŋɨnigɨnɨ, “Seyɨ́né amɨpí nánɨ dɨ́wɨ́ ikeamónarɨgɨ́áyɨ́né Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e páwipɨ́rɨ́a nánɨ yayɨ́ seáyɨmɨ dánɨ oseainɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aiwá nánɨ agwɨ ríná dɨ́wɨ́ ikeamónarɨgɨ́áyɨ́né ananɨ aiwá nɨro agwɨ́ ímɨ seayirɨ epɨ́rɨ́a nánɨ yayɨ́ seáyɨmɨ dánɨ oseainɨnɨ. Agwɨ seyɨ́né dɨŋɨ́ sɨpí nɨseairɨ ŋwɨ́ oeáɨ́rɨ aiwɨ rɨ́wéná Gorɨxo píránɨŋɨ́ seameŋweanɨ́e nɨpáwiro nɨŋwearɨ́náyɨ́ rɨpɨ́á rɨpɨ́rɨ́a nánɨ yayɨ́ seáyɨmɨ dánɨ oseainɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Seyɨ́né ámá imónɨŋáonɨ nɨxɨ́darɨgɨ́áyɨ́né eŋagɨ nánɨ ámá wa sɨ́mɨ́ tɨ́nɨ seairɨ xegɨ́ wúmɨ nánɨ mɨxɨ́ seaxɨ́dowárɨro ikayɨ́wɨ́ nɨsearɨro segɨ́ yoɨ́ xwɨraimɨmɨ́ searɨro seaíáná xwɨrɨ́á mimónɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ámá wí sɨpí e seaikárarɨŋagɨ́a nɨwɨnɨrɨ́náyɨ́, re yaiwíɨ́rɨxɨnɨ, ‘Nene sɨpí neaikárarɨgɨ́ápa wigɨ́ xiáwowa enɨ Gorɨxoyá wɨ́á rókiamoagɨ́áwamɨ sɨpí wikáragɨ́árɨ́anɨ?’ nɨyaiwiro seyɨ́né idáná aŋɨ́namɨ nɨpeyiróná Gorɨxo naŋɨ́ wí seaiapɨnɨ́á eŋagɨ nánɨ nɨmawirɨ nɨxeamorɨ yayɨ́ seáyɨmɨ dánɨ néra úɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","E nerɨ aiwɨ seyɨ́né amɨpí wí mɨmúrónɨpa egɨ́áyɨ́né anɨgwɨnɨ aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Agwɨ ríná amɨpí yayɨ́ seainɨpaxɨ́ imónɨŋɨ́pɨ rɨxa nɨmearo sɨrɨ́ munɨ́ nɨŋwearo aiwɨ rɨ́wéná rɨ́nɨŋɨ́ meapɨ́rɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí seaíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Anɨgwɨ íníná aiwá nɨro agwɨ́ ímɨ seayirɨ yarɨgɨ́áyɨ́né, aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Rɨ́wéná Gorɨxoyá xwioxɨ́yo mɨpáwí agwɨ́ná epɨ́rɨ́a nánɨ dɨŋɨ́ sɨpí seaíwɨnɨgɨnɨ. Anɨgwɨ yayɨ́ ero rɨpɨ́á rɨro yarɨgɨ́áyɨ́né, aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Rɨ́wéná Gorɨxo ámáyo píránɨŋɨ́ umeŋweanɨ́e mɨpáwipa nerɨ́ná dɨŋɨ́ sɨpí nɨseairɨ ŋwɨ́ eapɨ́rɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí seaíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Seyɨ́né ámá nɨ́nɨ seáyɨmɨ seameararɨgɨ́áyɨ́né, aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Eŋíná segɨ́ seáwowa mimónɨ́ wɨ́á rókiamoagɨ́áwamɨ seáyɨmɨ umearagɨ́ápa agwɨ seyɨ́né enɨ seáyɨmɨ seameararɨ́ná dɨŋɨ́ re nɨyaiwiro, ‘Nene enɨ ámá Gorɨxoyá mimónɨpa eŋagwɨ nánɨ oyá xwioxɨ́yo páwianɨ́wámanɨ.’ nɨyaiwiro dɨŋɨ́ sɨpí seaíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“E nɨrɨrɨ aiwɨ seyɨ́né arɨ́á niarɨgɨ́áyɨ́né re éɨ́rɨxɨnɨ. Ámá seyɨ́né wikɨ́ seaónɨgɨ́áyo nánɨ seaimónɨrɨ ámá sɨ́mɨ́ tɨ́nɨ seaiarɨgɨ́áyo naŋɨ́ wimɨxɨro ");
INSERT INTO aak_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ámá ikayɨ́wɨ́ tɨ́nɨ nɨramɨxɨrɨ seararɨgɨ́áyo Gorɨxo píránɨŋɨ́ owimɨxɨnɨrɨ ero ámá xwɨraimɨmɨ́ seararɨgɨ́áyɨ́ naŋɨ́ oimónɨ́poyɨnɨrɨ Gorɨxomɨ yarɨŋɨ́ wiro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ámá wo marɨpɨŋwɨ́yo mɨdánɨ reááná ámɨ mɨdánɨ enɨ ananɨ xe reáwɨnɨgɨnɨ. Ámá wo dɨxɨ́ iyɨ́á nɨrɨrápɨrɨ́náyɨ́, xe onɨrápɨnɨrɨ dɨxɨ́ sorɨ́á enɨ ‘Xe onɨrápɨnɨ.’ yaiwíɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ámá gɨyɨ́ gɨyɨ́ yarɨŋɨ́ síánáyɨ́, ananɨ mɨnɨ wirɨ gɨyɨ́ gɨyɨ́ rɨrápɨ́áyo ímɨ́ tɨ́nɨ ‘Ámɨ niapɨ́poyɨ.’ murɨpa erɨ éɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","‘Ámá e oniípoyɨ.’ yaiwiarɨŋɨ́pa joxɨ enɨ e wiíɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Joxɨ re nɨyaiwirɨ́náyɨ́, ‘Ámá nionɨ nánɨ wimónarɨŋɨ́yɨ́ nánɨnɨ nimónarɨnɨ.’ nɨyaiwirɨ́náyɨ́, ámá gɨyɨ́ seáyɨmɨ rɨmepɨ́rɨ́árɨnɨ? Oweoɨ! Ámá ɨ́wɨ́ néra warɨgɨ́áyɨ́ aí ámá wiwanɨŋɨ́yɨ́ nánɨ wimónarɨŋɨ́yɨ́ nánɨ wimónarɨŋɨ́rɨnɨ. Ayɨnánɨ seyɨ́né nánɨ wimónarɨŋɨ́yɨ́ nánɨnɨ nɨseaimónɨrɨ́náyɨ́, weyɨ́ ámá wí seamearɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Seyɨ́né ámá naŋɨ́ seaimɨxarɨgɨ́áyonɨ naŋɨ́ nɨwimɨxɨrɨ́náyɨ́, weyɨ́yɨ́ ámá gɨyɨ́ seamearɨpɨ́rɨ́árɨnɨ? Oweoɨ! Ɨ́wɨ́ néra warɨgɨ́áyɨ́ aí ámá naŋɨ́ wiarɨgɨ́áyo xɨxenɨ naŋɨ́ wiarɨgɨ́árɨnɨ. Ayɨnánɨ ámá seyɨ́né naŋɨ́ seaimɨxarɨgɨ́áyonɨ naŋɨ́ nɨwimɨxɨrɨ́náyɨ́, weyɨ́yɨ́ ámá wí seamearɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Seyɨ́né woxɨ ‘O idáná ámɨ xɨxenɨ niapɨpaxɨ́rɨnɨ.’ yaiwiarɨŋɨ́yonɨ mɨnɨ nɨwirɨ́náyɨ́, weyɨ́yɨ́ ámá gɨyɨ́ seamearɨpɨ́rɨ́árɨnɨ? Oweoɨ! Ámá ɨ́wɨ́ yarɨgɨ́áyɨ́ aí wigɨ́ wɨ́amɨ ‘Idáná ámɨ xɨxenɨ neaiapɨpaxɨ́rɨnɨ.’ yaiwiarɨgɨ́áyo mɨnɨ wiarɨgɨ́árɨnɨ. Ayɨnánɨ woxɨ ‘O idáná ámɨ xɨxenɨ niapɨpaxɨ́rɨnɨ.’ yaiwiarɨŋɨ́yo mɨnɨ nɨwirɨ́náyɨ́, weyɨ́yɨ́ ámá seamearɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ámá seyɨ́né sɨ́mɨ́ tɨ́nɨ seaiarɨgɨ́áyɨ́ nánɨ seaimónɨrɨ naŋɨ́ wimɨxɨro amɨpí wí mɨnɨ nɨwirɨ́ná ‘Xɨ́oyá enɨ oniapɨnɨ.’ mɨyaiwipa éɨ́rɨxɨnɨ. E nerónáyɨ́, niaíwɨ́ Ŋwɨ́á seáyɨ émɨ ŋweaŋoyá nimónɨro oyá naŋɨ́ wí meapɨ́rɨ́árɨnɨ. Seyɨ́né xɨ́oyá niaíwɨ́ eŋagɨ nánɨ ámá xɨ́omɨ yayɨ́ mɨwíɨ́áyo tɨ́nɨ sɨpínɨ yarɨgɨ́áyo tɨ́nɨ wá wianarɨŋɨ́pa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Segɨ́ ápo ámáyo ayá nurɨmɨxɨrɨ yarɨŋɨ́pa seyɨ́né ayá nurɨmɨxɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Joxɨ ámá wo yarɨŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná ‘O sɨpí yarɨnɨ.’ mɨrɨpanɨ. E nerɨ́náyɨ́, joxɨ nánɨ Gorɨxo ‘O sɨpí yarɨnɨ.’ rɨnɨ́ámanɨ. Joxɨ ámáyo xwɨyɨ́á mumearɨpanɨ. E nerɨ́náyɨ́, Gorɨxo xwɨyɨ́á rɨmearɨnɨ́ámanɨ. Joxɨ ámá wí ɨ́wɨ́ síɨ́ápɨ yokwarɨmɨ́ nɨwiirɨ́náyɨ́, Gorɨxo ananɨ joxɨyáyo yokwarɨmɨ́ siinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Joxɨ ámáyo mɨnɨ nɨwirɨ́ná sɨpɨ́í mɨwipa nerɨ yarɨŋɨ́pa Gorɨxo mɨnɨ siapɨnɨ́árɨnɨ. Ámáyo mɨnɨ nɨwirɨ́ná ‘Xwé owimɨnɨ.’ yaiwiro aiwá sɨxɨ́ ímímɨ́ neróná sɨxɨ́ úroro wé tɨ́nɨ kɨsɨkɨsɨ́ ero nemáná rɨxa nɨyurɨ́nowíáná mɨnɨ nɨwiróná xegɨ́ iyɨ́áyo wiároarɨgɨ́ápa Gorɨxo enɨ xɨxenɨ e mɨnɨ siapɨnɨ́árɨnɨ. Amɨpí xɨxenɨ joxɨ wiarɨŋɨ́pa Gorɨxo xɨxenɨ e siapɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisaso xegɨ́ wiepɨsarɨŋɨ́yɨ́ nionɨ urarɨŋá jɨ́ayɨ́ arɨ́á nikeamoro ámá sɨŋwɨ́ supárɨŋɨ́ imónɨpɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Seyɨ́né ‘Sɨŋwɨ́ supárɨŋɨ́ wo wɨ́omɨ ananɨ nipemeámɨ óɨ́yo unɨŋoɨ.’ rɨyaiwiarɨŋoɨ? Awaú nɨwaúnɨ xwárɨŋwɨ́yo eaínɨpɨsɨ́iɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","xɨ́oyá wiepɨsarɨŋɨ́ seáyɨ e nimónɨro wigɨ́ dɨŋɨ́yo dánɨ ananɨ epɨ́rɨxɨnɨrɨ re urɨŋɨnigɨnɨ, “Niaíwowa uréwapɨyarɨŋomɨ seáyɨ e múrónarɨgɨ́ámanɨ. Xámɨ nuréwapɨya numáná eŋáná uréwapɨyarɨŋo tɨ́nɨ xɨxenɨ imónarɨgɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","xɨ́oyá wiepɨsarɨŋɨ́yɨ́ ɨ́wɨ́ ayɨ́ yarɨgɨ́áyɨ́ pɨ́nɨ mɨwiárɨpa nero ámá wí yarɨgɨ́áyɨ́ nánɨnɨ “Pɨ́nɨ wiárɨ́poyɨ.” urɨpɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Segɨ́ sɨŋwɨ́yo íkɨ́á xwé wánɨŋɨ́ ŋweaŋagɨ aí sɨŋwɨ́ mainenɨpa nero dɨxɨ́ imónɨgɨ́áyɨ́ womɨ sɨŋwɨ́ sɨyikwɨ́ onɨmiá bɨ ŋweaŋáná pí nánɨ sɨŋwɨ́ wɨnɨmeaarɨgɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Íkɨ́á xwé awá segɨ́ sɨŋwɨ́yo ŋweaŋagɨ sɨŋwɨ́ mainenɨpa nerɨ́ná arɨge nerɨ dɨxɨ́ imónɨgɨ́á omɨ ‘Sɨŋwɨ́ sɨyikwɨ́ onɨmiá ŋweaŋɨ́pɨ orɨmeámɨnɨ.’ urɨrɨ́árɨnɨ? Naŋɨ́ rɨrɨ sɨpí rɨrɨ yarɨŋoxɨnɨ, íkɨ́á xwé joxɨyá sɨŋwɨ́yo ŋweaŋɨ́wá emɨ nɨmamónɨmáná sɨŋwɨ́ píránɨŋɨ́ nanɨmáná dɨxɨ́ rɨrɨxɨ́meáoyá sɨŋwɨ́yo onɨmiá ŋweaŋɨ́pɨ ananɨ mearɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Xegɨ́ wiepɨsarɨŋɨ́yɨ́ píránɨŋɨ́ nero oŋweápoyɨnɨrɨ ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Íkɨ́á siyɨwí rɨŋɨ́na sogwɨ́ naŋɨ́ wearɨŋɨ́manɨ. Íkɨ́á onagwá eŋɨ́na sogwɨ́ sɨpí wearɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ámá íkɨ́á sogwɨ́ weŋagɨ nɨwɨnɨrɨ́náyɨ́ dɨŋɨ́ ‘Íkɨ́á yoɨ́ ayo rɨnɨŋɨ́ iyɨ́ rɨwenɨ?’ yaiwiarɨgɨ́árɨnɨ. Íkɨ́á pikɨ́ sogwɨ́ nɨdɨrɨ́náyɨ́ eŋwɨxɨ́yo darɨgɨ́áranɨ? Wainɨ́ sogwɨ́ nɨdɨrɨ́náyɨ́ ará ekɨrɨkwɨ́yo darɨgɨ́áranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ámá naŋɨ́yɨ́ wigɨ́ xwioxɨ́yo dánɨ dɨŋɨ́ naŋɨ́ moro píránɨŋɨ́ néra uro yarɨgɨ́árɨnɨ. Ámá sɨpíyɨ́ wigɨ́ xwioxɨ́yo dánɨ dɨŋɨ́ sɨpí moro ɨ́wɨ́ néra uro yarɨgɨ́árɨnɨ. Ámá xwɨyɨ́á nɨrɨrɨ́náyɨ́ xwioxɨ́yo dánɨ sɨpí nánɨnɨ dɨŋɨ́ nɨmorɨ́ná sɨpínɨ rarɨgɨ́árɨnɨ. Naŋɨ́ nánɨnɨ nɨmorɨ́ná naŋɨ́nɨ rarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Pí nánɨ ‘Ámɨnáoxɨnɨ, Ámɨnáoxɨnɨ,’ nɨnɨrɨro aiwɨ nionɨ seararɨŋápɨ mepa yarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ámá gɨyɨ́ gɨyɨ́ nionɨ tɨ́ámɨnɨ nɨbɨro nionɨ searɨ́ápɨ arɨ́á nɨniro xɨxenɨ axɨ́pɨ yarɨgɨ́áyɨ́ ‘Ámá ónɨŋɨ́ rimónɨnɨ?’ oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á bɨ nɨrɨrɨ sɨwánɨŋɨ́ oseaimɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ámá o sɨ́ŋá aŋɨ́ nɨmɨrɨrɨ́ná xámɨ sɨ́ŋá nɨta yapɨ́rɨ́e xwɨ́á sewiárɨ́ónɨŋɨ́ xapɨxapɨ́ nɨmirɨ eŋɨ́ tɨ́nɨ ínɨmɨ nɨmiga nɨwémáná sɨ́ŋá yapɨnɨŋagɨ nɨwɨnɨrɨŋe dánɨ sɨ́ŋá piárá nɨkɨkíróa nɨyapɨrɨ aŋɨ́ mɨrarɨŋónɨŋɨ́ imónɨŋoɨ. Iniá xwé neáɨsáná iniɨgɨ́ waxɨ́ nɨwerɨ́ná aŋiwámɨ nɨmiákwirɨ pɨneámɨnɨrɨ éɨ́yɨ́ o píránɨŋɨ́ mɨrɨŋɨ́ eŋagɨ nánɨ wiŋwɨ́ wí mimeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","E nerɨ aiwɨ ámá gɨyɨ́ gɨyɨ́ nionɨ searɨ́ápɨ arɨ́á nɨniro aí xɨxenɨ axɨ́pɨ mepa yarɨgɨ́áyɨ́ ámá rónɨŋɨ́ imónɨŋoɨ. O aŋɨ́ nɨmɨrɨrɨ́ná sɨ́ŋá piárá yapɨnɨŋe dánɨ sɨ́ŋá nɨkɨkíróa yapɨnɨ nánɨ xwɨ́á bɨ mɨmí úrapí xwɨ́áyonɨ seáyɨ e nɨta nɨpurɨ mɨrárɨ́ɨ́yɨ́ iniɨgɨ́ waxɨ́ nɨweapɨrɨ miákwíáná aŋɨ́nɨ iniɨgɨ́yo nɨpɨneamioarɨ anɨpá imónárɨŋɨnigɨnɨ.” nurɨrɨ “Nene enɨ Jisaso nearɨ́ɨ́pɨ nɨwiaíkirɨ́ná aŋiwá yapɨ Gorɨxo anɨpá neaimɨxɨnɨ́árɨ́anɨ?” oyaiwípoyɨnɨrɨ nánɨ ewayɨ́ xwɨyɨ́á apɨ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisaso, oxɨ́ apɨxɨ́ arɨ́á wiarɨ́ná xwɨyɨ́á apɨ nɨpɨnɨ nurárɨmáná aŋɨ́ wíyo xegɨ́ yoɨ́ Kapaneamɨyo nánɨ nurɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","wauyɨ́ porisɨ́ ámɨná imónɨŋɨ́ woyá ámá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋo —O porisɨ́ ámɨná imónɨŋo dɨŋɨ́ sɨxɨ́ wiŋorɨnɨ. O sɨmɨxɨ́ nerɨ rɨxa nɨpémɨnɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","“Jisaso nɨbɨrɨ aŋɨ́ apimɨ ŋweanɨ.” rɨnarɨŋagɨ́a arɨ́á e nɨwirɨ Judayɨ́ ámɨná wa Jisasomɨ owirɨmeápoyɨnɨrɨ re urowárɨŋɨnigɨnɨ, “Soyɨ́né nuro gɨ́ inókínɨŋɨ́ omɨŋɨ́ niiarɨŋɨ́ ro nánɨ yarɨŋɨ́ re nɨwiípoyɨ, ‘Joxɨ ananɨ nɨbɨrɨ oyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋo rɨxa nɨpepaxɨ́ yarɨŋagɨ nánɨ píránɨŋɨ́ wimɨxɨréɨnɨ?’ yarɨŋɨ́ e nɨwiípoyɨ.” urowáráná ");
INSERT INTO aak_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","awa nuro Jisasomɨ nɨwímearo waunɨ́ rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “O émáyɨ́ wo eŋagɨ aiwɨ píránɨŋɨ́ neaiarɨŋo eŋagɨ nánɨ joxɨ nɨbɨrɨ oyá xɨnáínɨŋɨ́ omɨŋɨ́ wiiarɨŋomɨ píránɨŋɨ́ wimɨxɨyiɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","O Judayene dɨŋɨ́ nɨneaŋwɨrárɨrɨ negɨ́ rotú aŋɨ́ jɨ́ayɨ́ mɨranɨ nánɨ neaiapɨŋorɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisaso awa tɨ́nɨ nuro porisɨ́ ámɨná imónɨŋoyá aŋɨ́ tɨ́ŋɨ́ e aŋwɨ e rémóáná porisɨ́ ámɨná imónɨŋo xegɨ́ ámá nɨkumɨxɨnɨrɨ emearɨgɨ́á wamɨ re urowárɨŋɨnigɨnɨ, “Jisasomɨ nɨwímearɨ Porisɨ́ ámɨná imónɨŋo re nearowárɨŋoɨ urɨ́poyɨ, ‘Ámɨnáoxɨnɨ, nionɨ sɨnɨ upupɨ́gɨ́ siarɨ́ná naŋɨ́manɨ. Nionɨ ámá naŋonɨ sɨŋagwɨnɨ. Joxɨ nionɨyá aŋɨ́yo wí ɨ́wiapɨpaxɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Xámɨ niɨwanɨŋonɨ “Ámá naŋonɨ menɨnɨ.” nɨyaiwinɨrɨ nánɨ joxɨ sirɨmeámɨnɨrɨ mɨbɨ́árɨnɨ. Ayɨnánɨ dɨxɨ́ roŋe dánɨ pɨ́né ráná gɨ́ omɨŋɨ́ niiarɨŋo ámɨ naŋɨ́ imónɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nionɨ ámá “Omɨŋɨ́ ayɨ́ ayɨ́ eɨ.” nɨrarɨgɨ́owamɨ ínɨmɨ wurɨ́nɨŋɨnɨ. Nionɨ enɨ porisɨ́ wa ínɨmɨ nurɨ́nɨŋoɨ. Gɨ́ porisɨ́ womɨ “Joxɨ aŋɨ́ uɨ.” uráná sa warɨŋɨ́rɨnɨ. Womɨ “Beɨ.” uráná sa xɨxenɨ barɨŋɨ́rɨnɨ. Gɨ́ inókínɨŋɨ́ omɨŋɨ́ niiarɨŋɨ́ womɨ “E eɨ.” uráná xɨxenɨ yarɨŋɨ́rɨnɨ.’ Jisasomɨ e urɨ́poyɨ.” urowáráná ");
INSERT INTO aak_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","awa nuro Jisaso tɨ́nɨ óɨ́ e órórɨ́ ninɨro e uráná Jisaso ududɨ́ nɨwirɨ nɨkɨnɨmónɨrɨ oxɨ́ apɨxɨ́ epɨ́royɨ́ nero númɨ uxɨ́dɨgɨ́áyo re urɨŋɨnigɨnɨ, “Wauyɨ́ porisɨ́ ámɨná imónɨŋo dɨŋɨ́ nɨnɨkwɨ́rorɨ yarɨŋɨ́pa nɨgɨ́ Isɨrerɨyɨ́né aí woxɨ nionɨ dɨŋɨ́ xɨxenɨ mɨnɨkwɨ́roarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","xwɨyɨ́á urowárénapɨ́áwa ámɨ wigɨ́ aŋɨ́ e nánɨ nuro xegɨ́ omɨŋɨ́ wiiarɨŋo rɨxa ámɨ naŋɨ́ riwo ŋweaŋagɨ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jisaso wauyɨ́ porisoyá omɨŋɨ́ wiiarɨŋomɨ píránɨŋɨ́ nimɨxɨrɨ rɨxa sɨ́á wí óráná o aŋɨ́ bimɨ yoɨ́ Nenɨyɨ rɨnɨŋɨ́yo nánɨ nurɨ xegɨ́ wiepɨsarɨŋowa enɨ o tɨ́nɨ nuro ámá oxɨ́ apɨxɨ́ obaxɨ́ nawínɨ nuro ");
INSERT INTO aak_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","aŋɨ́ apimɨ ákɨŋá ɨ́wí e rémoanɨro yarɨ́ná Jisaso wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ámá pɨyɨ́ wo —O sɨnɨ íwɨ́ sɨkɨŋorɨnɨ. Xexɨrɨ́meáo wo mayorɨnɨ. Xɨnáí apɨxɨ́ anírɨnɨ. Omɨ xɨnáí tɨ́nɨ oxɨ́ apɨxɨ́ e dáŋɨ́ obaxɨ́ tɨ́nɨ xwɨ́á weyanɨro aŋɨ́ apimɨ dánɨ nɨmeámɨ ɨ́wiaparɨŋagɨ́a Jisaso sɨŋwɨ́ e nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","pɨyomɨ xɨnáímɨ wá nɨwianɨrɨ re urɨŋɨnigɨnɨ, “Ŋwɨ́ eaarɨŋɨ́yɨ́ pɨ́nɨ wiáreɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","aŋwɨ e nɨbɨrɨ íkwiaŋwɨ́ pɨyo weŋɨ́namɨ ɨ́á nɨxɨrɨrɨ ámá nɨmeámɨ warɨgɨ́áyɨ́ sa e rówapɨŋáná o pɨyomɨ re urɨŋɨnigɨnɨ, “ ‘Íwɨ́ sɨkɨŋɨ́ roxɨnɨ, rɨxa wiápɨ́nɨmeaɨ.’ rɨrarɨŋɨnɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pɨyo nɨwiápɨ́nɨmearɨ éɨ́ nɨŋwearɨ iwamɨ́ó pɨ́né rarɨ́ná Jisaso ámɨ xɨnáí tɨ́ŋɨ́ e uwáriarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ámá nɨ́nɨ wáyɨ́ nikárɨnɨro Gorɨxomɨ seáyɨ e numeróná re rɨgɨ́awixɨnɨ, “Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ seáyɨ e imónɨŋɨ́ wo riwo rɨneaurowárénapɨyiŋoɨ? Gorɨxo Isɨrerene nánɨ dɨŋɨ́ nɨmorɨ arɨrá neainɨnɨ́a nánɨ riwo rɨneaurowárénapɨyiŋoɨ?” nɨrɨro e yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisaso e éɨ́pɨ nánɨ xwɨyɨ́á Judayɨ́ aŋɨ́ nɨyonɨ yanɨ́ niwéa nurɨ mɨdɨmɨdánɨ enɨ rɨnɨmeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jono xegɨ́ wiepɨsarɨŋowa Jisaso éɨ́ apɨ nɨpɨnɨ nánɨ áwaŋɨ́ uráná ");
INSERT INTO aak_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","o xegɨ́ wiepɨsarɨŋɨ́ waúmɨ “Eɨnɨ.” nurɨrɨ Ámɨná Jisaso tɨ́ŋɨ́ e nánɨ re urowárɨŋɨnigɨnɨ, “Nuri yarɨŋɨ́ re wípiyɨ, ‘Joxɨ nánɨ Jono “Nɨbɨnɨ́árɨnɨ.” neararɨŋoxɨranɨ? Wo ámɨ rɨ́wɨ́yo bɨnɨ́o nánɨ sɨnɨ xwayɨ́ nanɨrɨ ŋweanɨ́wáranɨ?’ Nuri yarɨŋɨ́ e wípiyɨ.” urowárɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","awaú nuri Jisasomɨ re urémeagɨ́isixɨnɨ, “Jono wayɨ́ nɨneameaia warɨŋo joxɨ tɨ́e nánɨ re yearowárɨŋoɨ, ‘Omɨ yarɨŋɨ́ re wípiyɨ, “Joxɨ Jono ‘Rɨ́wɨ́yo nɨbɨnɨ́árɨnɨ.’ neararɨŋoxɨranɨ? Wo rɨ́wɨ́yo bɨnɨ́o nánɨ sɨnɨ xwayɨ́ nanɨrɨ ŋweanɨ́wáranɨ?” yarɨŋɨ́ e wípiyɨ.’ yearowárɨŋoɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","axíná Jisaso ámá sɨmɨxɨ́ xɨxegɨ́nɨ yarɨgɨ́áyo naŋɨ́ imɨxɨrɨ sɨŋwɨ́ supárɨgɨ́á obaxɨ́yo sɨŋwɨ́ anɨpɨ́rɨ nánɨ wirɨ imɨ́ó ámáyo xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnɨrɨ nerɨ ");
INSERT INTO aak_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","awaúmɨ re urɨŋɨnigɨnɨ, “Awagwí nuri amɨpí nɨ́nɨ nionɨ re yarɨ́ná sɨŋwɨ́ nanɨri arɨ́á niri éɨ́íyɨ́ nánɨ Jonomɨ áwaŋɨ́ urɨ́piyɨ, ‘Sɨŋwɨ́ supárɨgɨ́áyɨ́ ámɨ sɨŋwɨ́ anɨro sɨkwɨ́ ikɨ́ egɨ́áyɨ́ ámɨ aŋɨ́ ero peyɨyɨ́ tɨ́gɨ́áyɨ́ wigɨ́ wará naŋɨ́ inɨro arɨ́á pɨ́rónɨgɨ́áyɨ́ ámɨ arɨ́á ero ámá péɨ́áyɨ́ ámɨ wiápɨ́nɨmearo ámá sɨpíyo xwɨyɨ́á yayɨ́ winɨpaxɨ́pɨ arɨ́á wiro yarɨŋoɨ.’ urɨ́piyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","re urɨŋɨnigɨnɨ, “Rɨpɨ enɨ urɨ́piyɨ, ‘Yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o e enɨ́árɨnɨ. E enɨ́árɨnɨ.’ yaiwiarɨgɨ́ápɨ tɨ́nɨ xɨxenɨ mepa yarɨŋagɨ sɨŋwɨ́ nɨnanɨrɨ aiwɨ nóreámioarɨ dɨŋɨ́ mɨnɨkwɨ́ropa nerɨ ‘Ayɨ́ omanɨ.’ mɨyaiwipanɨ. Ámá e yarɨgɨ́á gɨyɨ́ gɨyɨ́ Gorɨxoyá dɨŋɨ́ tɨ́nɨ yayɨ́ winɨpaxɨ́yɨ́rɨnɨ. Jonomɨ e urɨ́piyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisaso, Jonoyá wiepɨsarɨŋowaú rɨxa úáná, o ámá e epɨ́royɨ́ egɨ́áyo Jono nánɨ re urɨŋɨnigɨnɨ, “Xámɨ seyɨ́né Jonomɨ sɨŋwɨ́ wɨnanɨro nánɨ ámá dɨŋɨ́ meaŋe nánɨ nuróná pí ámá sɨŋwɨ́ wɨnarɨgɨ́awixɨnɨ? Ámá eŋɨ́ meánɨŋɨ́ imɨŋɨ́ yarɨ́ná wakwɨŋwɨ́ wiŋwɨ́ nimearɨ́nɨŋɨ́ imónɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro rɨwarɨgɨ́awixɨnɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aga pí ámá sɨŋwɨ́ wɨnanɨro warɨgɨ́awixɨnɨ? Ámá rapɨrapɨ́ yarapayɨ́ eŋɨ́ wú yínɨŋɨ́ womɨ wɨnanɨro ámá dɨŋɨ́ meaŋe nánɨ rɨwarɨgɨ́awixɨnɨ? Oweoɨ! Ámá rapɨrapɨ́ yarapayɨ́ naŋɨ́nɨ nɨyínɨro ŋweagɨ́áyɨ́ mɨxɨ́ ináyɨ́yá aŋɨ́yo ŋweaarɨgɨ́árɨnɨ. Ámá dɨŋɨ́ meaŋe ŋweaarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aga pí ámá sɨŋwɨ́ wɨnanɨro warɨgɨ́awixɨnɨ? Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro rɨwarɨgɨ́awixɨnɨ? Oyɨ, wɨ́á rókiamoarɨŋɨ́ womɨ sɨŋwɨ́ wɨnanɨro ugɨ́á aiwɨ Jono ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ wáɨ́ urɨmemɨnɨrɨ nánɨ urowárénapɨŋɨ́ eŋagɨ nánɨ o Gorɨxoyá wɨ́á rókiamoarɨgɨ́á nɨyonɨ xɨxenɨ imónɨŋomanɨ. Seáyɨ e múroŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jono nánɨ Bɨkwɨ́ Gorɨxoyáyo rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨnɨ, ‘Gorɨxo xegɨ́ xewaxomɨ re urɨŋɨnigɨnɨ, “Nionɨ gɨ́ xwɨyɨ́á yaŋɨ́ wiowárɨmɨ́áo joxɨ xámɨ nɨrɨmearɨ ámá nɨsanɨrɨ epɨ́rɨ nánɨ óɨ́nɨŋɨ́ nɨsimoia unɨ́a nánɨ urowárɨmɨ́árɨnɨ.” urɨŋɨnigɨnɨ.’ Rɨ́wamɨŋɨ́ e nɨrɨnɨrɨ eánɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","re urɨŋɨnigɨnɨ, “Nionɨ seararɨŋɨnɨ. Jono ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ óɨ́nɨŋɨ́ imoŋo eŋagɨ nánɨ ámá nɨ́nɨ aiwɨ wo Jonomɨ seáyɨ e imónɨnɨ nánɨ xɨrɨgɨ́ámanɨ. E nerɨ aiwɨ ámá gɨyɨ́ gɨyɨ́ nionɨ nɨxɨ́dɨro Gorɨxoyá xwioxɨ́yo páwiro yarɨgɨ́áyɨ́ xwɨyɨ́á nionɨ nánɨ wáɨ́ nurɨmeipɨ́rɨ́pɨ xwɨyɨ́á Jono wáɨ́ rɨmeŋɨ́pimɨ seáyɨ e imónɨŋagɨ nánɨ ámá ayɨ́ onɨ́pɨ aiwɨ Jonomɨ enɨ seáyɨ e imónɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ámá nɨ́nɨ tɨ́nɨ takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́áyɨ́ tɨ́nɨ Jono wáɨ́ urɨmearɨŋagɨ arɨ́á nɨwiro nɨsanɨro Jono wayɨ́ umeaiarɨ́ná rɨpɨ urɨgɨ́ánɨŋɨ́ imónɨnɨ, “Gorɨxoxɨ wé rónɨŋoxɨ óɨ́ nene uyɨ́niɨ́nɨ yarɨŋwaéne nánɨ imóɨ́pɨ xɨxenɨ neamoíɨ́rɨnɨ.” urɨgɨ́ánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","E nerɨ aiwɨ Parisiowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Jono wayɨ́ oneameainɨrɨ sɨŋwɨ́ mɨwɨnɨpa neróná amɨpí Gorɨxo ‘Awa oépoyɨ.’ yaiwíɨ́pimɨ rɨ́wɨ́ umogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisaso ámɨ re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á pípɨ nɨrɨrɨ ámá agwɨ ríná ŋweagɨ́áyɨ́né ámá wo wo Gorɨxo seyɨ́né nánɨ urowárarɨŋagɨ aiwɨ seyɨ́né mɨseaimónarɨŋɨ́yɨ́né nánɨ ‘Ayɨ́nɨŋɨ́ imónɨnɨ.’ rɨmɨ́ɨnɨ? Seyɨ́né pínɨŋɨ́ imónɨŋoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","re urɨŋɨnigɨnɨ, “Seyɨ́né niaíwɨ́ rɨpiánɨŋɨ́ imónɨŋoɨ. Niaíwɨ́ bia makerɨ́á tɨ́ŋɨ́ e niɨ́á neróná niaíwɨ́ bɨ́biamɨ rɨ́aiwá re urarɨŋoɨ, ‘Nepiane webɨ́í rarɨŋagwɨ aí sepiayɨ́né sɨmɨnɨŋɨ́ mɨyarɨŋoɨ. Nepiane ŋwapé rarɨŋagwɨ aí sepiayɨ́né ámɨxɨ́á bɨ mɨyarɨŋoɨ.’ rɨnarɨgɨ́ápiánɨŋɨ́ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Seyɨ́né re egɨ́ápɨ nánɨ ewayɨ́ xwɨyɨ́á apɨ seararɨŋɨnɨ. Seyɨ́né Jono wayɨ́ nɨneameaia warɨŋo nɨbɨrɨ́ná aiwá naŋɨ́ mɨnɨpa erɨ iniɨgɨ́ wainɨ́ mɨnɨpa erɨ yarɨŋagɨ sɨŋwɨ́ nɨwɨnɨro nánɨ ‘Ámá royɨ́ imɨ́ó xɨxéroarɨŋorɨ́anɨ?’ rarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Seyɨ́né ámá imónɨŋáonɨ enɨ nɨbɨrɨ́ná aiwá nɨrɨ iniɨgɨ́ nɨrɨ yarɨŋagɨ nɨnanɨro nánɨ re rarɨgɨ́árɨnɨ, ‘O aiwá eŋɨ́ nerɨ narɨŋorɨnɨ. Iniɨgɨ́ wainɨ́ enɨ narɨŋorɨnɨ. Ámá takisɨ́ nánɨ nɨgwɨ́ nearáparɨgɨ́áwa tɨ́nɨ ámá ɨ́wɨ́ yarɨgɨ́á wínɨyɨ́ tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨŋorɨnɨ.’ rarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","E nerɨ aiwɨ oxɨ́ apɨxɨ́ wínɨ wínɨ dɨŋɨ́ píránɨŋɨ́ neŋwɨpero Jono tɨ́nɨ nionɨ tɨ́nɨ nánɨ ‘Awaú naŋɨ́ yarɨŋiɨ.’ yaiwiarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ámá Parisi wo Jisasomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Joxɨ ananɨ nionɨ tɨ́nɨ gɨ́ aŋɨ́yo aiwá nanɨréwiɨ?” urɨ́agɨ Jisaso oyá aŋɨ́yo nɨpáwirɨ aiwá nanɨri nánɨ wigɨ́ yarɨgɨ́ápa xwápɨyi nɨkɨ́rómáná nawínɨ aiwá narɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Apɨxɨ́ ɨ́wɨ́ inarɨŋɨ́ wí, aŋɨ́ apimɨ ŋweaŋí “Jisaso Parisioyá aŋɨ́yo nɨŋwearɨ aiwá narɨnɨ.” rɨnarɨŋagɨ arɨ́á e nɨwirɨ sɨ́ŋá tɨ́nɨ sɨxɨ́ imɨxɨnɨŋɨ́ wá iniɨgɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ bɨ ínɨŋɨ́wá nɨmeámɨ aŋɨ́ iwámɨ nɨpáwirɨ ");
INSERT INTO aak_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisaso sɨkwɨ́ tɨ́ŋɨ́ e rɨ́wɨ́ rɨwámɨnɨ éɨ́ nɨrómáná ŋwɨ́ nearɨ́ná xegɨ́ sɨŋwɨrɨxɨ́ Jisasoyá sɨkwɨ́ sosɨ́áyo nɨyorɨ í xegɨ́ dɨ́á sepiá tɨ́nɨ kwɨkwɨ́rɨmɨ́ nerɨ sɨkwɨ́yo kíyɨ́ nɨmiaúnɨrɨ iniɨgɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́pɨ niwayɨmómáná gɨ́niɨ́ nɨwirɨ e yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisio, Jisasomɨ imánɨ́ ikaxɨ́ urɨ́o apɨxɨ́ í e wiarɨŋagɨ nɨwɨnɨrɨ ínɨmɨ re rɨnɨŋɨnigɨnɨ, “Ámá ro nepa Gorɨxoyá wɨ́á rókiamoarɨŋo eŋánáyɨ́, apɨxɨ́ ɨ́á wiapɨyimɨxarɨŋí nánɨ xɨxenɨ nɨjɨ́á re imónɨpaxorɨnɨ, ‘Í apɨxɨ́ ɨ́wɨ́ inarɨŋɨ́ wírɨnɨ.’ yaiwipaxorɨnɨ.” Parisio ínɨmɨ dánɨ e yaiwinarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisaso o xwioxɨ́yo dánɨ e yaiwiarɨŋagɨ adadɨ́ nɨwirɨ re urɨŋɨnigɨnɨ, “Saimone, xwɨyɨ́á bɨ orɨrɨmɨnɨ.” urɨ́agɨ o re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, ananɨ nɨreɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisaso ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá womɨ ámá waú nɨbɨri nɨgwɨ́ urápɨgɨ́isixɨnɨ. Wɨ́o K500.00 urápɨrɨ wɨ́o K50.00 urápɨrɨ neri nɨŋweagɨ́isáná ");
INSERT INTO aak_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","awaú ámɨ xɨ́omɨ mɨwipa eŋáná o nɨwaúmɨnɨ ayá nurɨmɨxɨrɨ nɨgwɨ́ mɨnɨ wiŋɨ́pɨ nánɨ dɨŋɨ́ peá nɨmorɨ kikiɨ́á eŋɨnigɨnɨ. Ayɨnánɨ awaú go go nɨgwɨ́ mɨnɨ wiŋo nánɨ xwapɨ́ wimónɨnɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimono re urɨŋɨnigɨnɨ, “ ‘Nɨgwɨ́ K500.00 urápɨŋo, o xwapɨ́ wimónɨnɨŋoɨ.’ nimónarɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Joxɨ dɨŋɨ́ xɨxenɨ neŋwɨperɨ rarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","apɨxí tɨ́ámɨnɨ nɨkɨnɨmónɨmáná Saimonomɨ re urɨŋɨnigɨnɨ, “Apɨxɨ́ rí nionɨ niarɨŋɨ́ rí sɨŋwɨ́ wɨneɨ. Nionɨ dɨxɨ́ aŋɨ́yo ɨ́wiapánáyɨ́ joxɨ negɨ́ yarɨŋwápa mɨnií iniɨgɨ́ bɨ sɨkwɨ́ sosɨ́á igɨ́á eánɨmɨnɨrɨ nánɨ mɨniapɨ́ɨnɨ. E nerɨ aiwɨ apɨxɨ́ ríyɨ́ gɨ́ sɨkwɨ́ sosɨ́áyo sɨŋwɨrɨxɨ́ tɨ́nɨ igɨ́á nɨnearɨ xegɨ́ dɨ́á sepiá eŋɨ́ tɨ́nɨ nɨkwɨ́rɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Joxɨ ámá xwɨyɨ́á báná negɨ́ yarɨŋwápɨ kíyɨ́ mɨnɨmiaúnɨ́ɨnɨ. E nerɨ aí í nionɨ nɨ́wiapɨrɨ ŋweááíná dánɨ sɨkwɨ́ sosɨ́áyo kíyɨ́ nɨnɨmiaúga warɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Joxɨ negɨ́ yarɨŋwápa yayɨ́ mɨnipa nerɨ ranɨ́ bɨ mɨŋɨ́yo mɨniwayɨmóɨnɨ. E nerɨ aiwɨ apɨxɨ́ ríyɨ́ sɨkwɨ́ sosɨ́áyo iniɨgɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ bɨ nɨniwayɨmómáná gɨ́niɨ́ niŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ayɨnánɨ nionɨ re rarɨŋɨnɨ. Í ɨ́wɨ́ xwapɨ́ yagɨ́í aiwɨ nionɨ rɨxa yokwarɨmɨ́ wiíá eŋagɨ nánɨ í nionɨ nánɨ xwapɨ́ nɨwimónɨrɨ nánɨ naŋɨ́ e niarɨnɨ. Ámá ɨ́wɨ́ xwapɨ́ mé bɨ onɨmiápɨ yarɨgɨ́áyɨ́ nionɨ yokwarɨmɨ́ wiíáná ayɨ́ nionɨ nánɨ enɨ onɨmiápɨ wimónarɨŋɨ́rɨnɨ.” Saimonomɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","apɨxímɨ re urɨŋɨnigɨnɨ, “Nionɨ dɨxɨ́ ɨ́wɨ́ yarɨŋɨ́yɨ́ rɨxa yokwarɨmɨ́ siíárɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ámá xɨ́o tɨ́nɨ nawínɨ nɨŋwearo aiwá narɨgɨ́áyɨ́ re rɨnɨgɨ́awixɨnɨ, “Ámá royɨ́ ‘Ɨ́wɨ́ yarɨŋɨ́yɨ́ yokwarɨmɨ́ wiipaxonɨrɨnɨ.’ nɨyaiwirɨ rɨ́a rarɨnɨ?” nɨrɨnɨro e yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisaso apɨxímɨ re urɨŋɨnigɨnɨ, “Jíxɨ dɨŋɨ́ nɨkwɨ́roarɨŋagɨ nánɨ Gorɨxo yeáyɨ́ rɨyimɨxemeáɨ́rɨnɨ. Rɨxa kikiɨ́á néra uɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jisaso Saimono tɨ́nɨ aiwá nɨnɨrɨ nɨŋweaŋɨsáná rɨxa sɨ́á wí óráná o aŋɨ́ wíyɨ́ wíyo xwɨyɨ́á yayɨ́ winɨpaxɨ́ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́a nánɨ wáɨ́ nurɨmerɨ re urɨmeŋɨnigɨnɨ, “Seyɨ́né ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.” urɨmearɨ́ná xɨ́o xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú o tɨ́nɨ nawínɨ nemero ");
INSERT INTO aak_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","apɨxɨ́ wíwa enɨ o tɨ́nɨ nawínɨ nemero —Wíwa sɨmɨxɨ́ tɨ́gɨ́íwamɨ Jisaso naŋɨ́ imɨxɨrɨ wíwa imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́ tɨ́gɨ́íwamɨ mɨxɨ́ umáɨnɨrɨ wiarɨŋíwa wigɨ́ yoɨ́ ríwarɨnɨ. Wí Mariaírɨnɨ. Aŋɨ́ yoɨ́ Magɨdara dáŋí eŋagɨ nánɨ ímɨ yoɨ́ Magɨdara dáŋɨ́ Mariaíyɨ wɨ́rɨnɨŋírɨnɨ. Í Jisaso imɨ́ó wé wɨ́úmɨ dáŋɨ́ waú dɨŋɨ́ xɨxéroarɨŋɨ́ mɨxɨ́ umáɨnowárɨŋírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apɨxɨ́ ámɨ wí Xusao —O mɨxɨ́ ináyɨ́ Xerotoyá bosɨwɨ́ worɨnɨ. Omɨ xiepí í xegɨ́ yoɨ́ Joanaírɨnɨ. Ámɨ wí Sasanaírɨnɨ. Íwa tɨ́nɨ ámɨ wíwa enɨ wigɨ́ nɨgwɨ́ tɨ́nɨ aiwá bɨ́ imɨmɨ́ ero Jisasomɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋowamɨ tɨ́nɨ míraŋɨ́ nɨwiayiro númɨ wagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Oxɨ́ apɨxɨ́ obaxɨ́ aŋɨ́ ayɨ́ ayo dánɨ Jisaso tɨ́ŋɨ́ e nánɨ nɨbɨmiro awí eánarɨ́ná o ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ámá wo o xegɨ́ omɨŋɨ́yo witɨ́ siyɨ́ nɨwiáróa umɨnɨrɨ nánɨ nurɨ rɨxa xwɨ́á yunɨ́ ikɨxeárɨnɨŋe píránɨŋɨ́ nɨwiárorɨ aí wí óɨ́yo piéróɨ́yɨ́ ámá wí óɨ́yo nɨpurɨ́ná xwɨrɨŋwɨ́ osaxɨro iŋɨ́ nɨbɨrɨ mɨmánɨ́ erɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ámɨ wí sɨ́ŋá ínɨmɨ yapɨnɨŋáná xwɨ́á seáyɨ e onɨmiápɨ eŋɨ́yo piéróɨ́yɨ́ apaxɨ́ mé nerápɨrɨ nɨyapɨrɨ aiwɨ iniɨgɨ́ mɨrúnɨŋagɨ nánɨ apaxɨ́ mé yɨweárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ámɨ wí emɨ́ pɨpɨŋɨ́ arɨ́kiárɨnɨŋe wiároŋɨ́yɨ́ emɨ́ pɨpɨŋɨ́yo dánɨ nawínɨ nerápɨmáná emɨ́ xeŋwɨrárɨŋagɨ nánɨ witɨ́ ayɨ́ urɨ́ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ámɨ wí xwɨ́á naŋɨ́yo wiároŋɨ́yɨ́ nerápɨrɨ nɨyapɨrɨ ná nɨwerɨ́ná aga dɨŋɨ́ nɨmorɨ ɨ́á mɨropaxɨ́ weŋɨnigɨnɨ.” Ewayɨ́ xwɨyɨ́á e nurɨrɨ́ná re urayiŋɨnigɨnɨ, “Arɨ́á tɨ́gɨ́áyɨ́né ewayɨ́ xwɨyɨ́á rarɨŋá rɨpɨ nánɨ arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” urayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Xegɨ́ wiepɨsarɨŋowa ewayɨ́ xwɨyɨ́á apɨ mɨ́kɨ́pɨ nánɨ yarɨŋɨ́ wíáná ");
INSERT INTO aak_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","o re urɨŋɨnigɨnɨ, “Xwɨyɨ́á eŋíná dánɨ ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́árɨnɨ.’ nɨrɨrɨ ínɨmɨ imónɨŋɨ́pɨ nionɨ wɨ́á searókiamoarɨŋɨnɨ. E nerɨ aiwɨ ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́ró wigɨ́ dɨŋɨ́ tɨ́nɨ néra warɨgɨ́áyɨ́ nionɨ ewayɨ́ xwɨyɨ́á nuréwapɨyirɨ́ná wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́pa sɨŋwɨ́ nanɨro arɨ́á niro nero aiwɨ mɨ́kɨ́pɨ nánɨ nɨjɨ́á imónɨpɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́ánɨ uréwapɨyarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ewayɨ́ xwɨyɨ́á mɨ́kɨ́pɨ rɨpɨrɨnɨ. Witɨ́ siyɨ́ nánɨ rɨnɨŋɨ́pɨ ayɨ́ xwɨyɨ́á Gorɨxoyánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ámá wí siyɨ́ óɨ́ maŋɨ́pámɨ piéróɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxoyá arɨ́á nɨwiro aiwɨ axíná obo nɨbɨrɨ ayɨ́ xwɨyɨ́á oyápɨ dɨŋɨ́ móáná o yeáyɨ́ uyimɨxemeanɨgɨnɨrɨ mɨrɨrakɨ́ nɨwirɨ xwɨyɨ́á oyá wigɨ́ xwioxɨ́yo dánɨ emɨ mɨmeámɨ́ yárarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ámá wí witɨ́ siyɨ́ sɨ́ŋá ínɨmɨ yapɨnɨŋáná seáyɨ e xwɨ́á onɨmiápɨ eŋáná wiároŋɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxoyá arɨ́á nɨwiróná yayɨ́ nɨwinɨrɨ xɨ́danɨro yarɨ́ná xwɨyɨ́á ná ínɨmɨ pɨpɨŋɨ́nɨŋɨ́ mɨwárɨŋagɨ nánɨ anɨŋɨ́ xɨ́darɨgɨ́ámanɨ. Xwɨyɨ́á oyápɨ xɨ́danɨro yarɨŋagɨ́a nánɨ ámá wí nɨbɨro nepa eŋɨ́ neánɨro rɨ́a xɨ́darɨŋoɨnɨrɨ iwamɨ́ó wíwapɨyíáná pɨ́nɨ wiárarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ámá wí witɨ́ siyɨ́ emɨ́ pɨpɨŋɨ́ arɨ́kiárɨnɨŋe wiároŋɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ enɨ xwɨyɨ́á Gorɨxoyá arɨ́á nɨwiro aiwɨ wigɨ́ yarɨgɨ́ápa sɨnɨ nɨxɨ́dɨróná amɨpí xwɨ́áyo dáŋɨ́ nánɨ dɨŋɨ́ obɨbaxɨ́ moro ‘Amɨpí wí nionɨ mɨnɨmúropa oninɨ.’ yaiwiro amɨpí wí nánɨ nɨwimónɨro ‘Arɨge meámɨ́árɨ́anɨ?’ yaiwiro néra nurɨ́náyɨ́ witɨ́ emɨ́ nerápɨrɨ xeŋwɨrárɨŋɨ́ yapɨ nimónɨro aiwá ná nɨyínɨrɨ aiwɨ wí yóɨ́ yarɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ámá wí siyɨ́ xwɨ́á naŋɨ́ imónɨŋe wiároŋɨ́yɨ́nɨŋɨ́ imónɨnɨ. Ayɨ́ xwɨyɨ́á Gorɨxoyá nánɨ arɨ́á nɨwiro dɨŋɨ́ sɨpí wí mɨmaxɨrɨŋagɨ́a nánɨ mɨwáramó anɨŋɨ́ dɨŋɨ́ nɨkwɨ́roro xaíwɨ́ ɨ́á nɨxɨrɨro nerɨ́ná aiwá ná wearɨŋɨ́pɨ́nɨŋɨ́ imónarɨgɨ́árɨnɨ.” Wiepɨsarɨŋowamɨ ewayɨ́ xwɨyɨ́á mɨ́kɨ́pɨ nánɨ áwaŋɨ́ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Awa “Jisaso ámá ayo anɨŋɨ́ yumɨ́í winɨ́árɨnɨ.” yaiwipɨ́rɨxɨnɨrɨ ámɨ ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo re yarɨŋɨ́manɨ. Xegɨ́ ramɨxɨ́ nɨmɨxárorɨ sɨxɨ́ xwé wá nɨmearɨ upɨkákwiárarɨŋɨ́manɨ. Nɨmɨxárorɨ xegɨ́ sá íkwiaŋwɨ́yo ínɨmɨ éxwɨroárarɨŋɨ́manɨ. Nɨmɨxárómáná ámá gɨyɨ́ gɨyɨ́ nɨ́wiapɨrɨ́ná ananɨ sɨŋwɨ́ wɨnɨpɨ́rɨ nánɨ aiwá íkwiaŋwɨ́yo seáyɨ e tarɨŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","re urɨŋɨnigɨnɨ, “Amɨpí nɨ́nɨ ínɨmɨ imónɨŋɨ́ aiwɨ wɨ́á ókíáná nɨ́nɨ sɨŋánɨ imónáná ámá nɨ́nɨ ‘Tɨ́ ayɨ́rɨ́anɨ?’ yaiwipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ayɨnánɨ seyɨ́né pɨ́né arɨ́á nɨnirónáyɨ́ arɨ́á píránɨŋɨ́ nirɨ́ɨnɨ. Ámá gɨyɨ́ gɨyɨ́ nionɨ xwɨyɨ́á rarɨ́ná arɨ́á niro dɨŋɨ́ nɨkwɨ́roro nero nɨjɨ́á bɨ nimónɨrɨ́náyɨ́ Gorɨxo ámɨ wí mɨnɨ winɨŋoɨ. Gɨyɨ́ gɨyɨ́ arɨ́á mɨnipa ero dɨŋɨ́ mɨnɨkwɨ́ropa ero nerɨ́náyɨ́ ‘Nɨjɨ́á rɨpɨ imónɨŋɨnɨ.’ yaiwinarɨgɨ́ápɨ aí Gorɨxo apɨ aí ámɨ nurápɨnɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisasomɨ xɨnáí tɨ́nɨ xogwáowa tɨ́nɨ o tɨ́ŋɨ́ e nánɨ nɨbɨro ámá xwé obaxɨ́ omɨ epɨ́royɨ́ wiárɨŋagɨ́a epówa mɨpáwipaxɨ́ eŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ámá wí áwaŋɨ́ re urɨgɨ́awixɨnɨ, “Dɨxɨ́ rɨnáí tɨ́nɨ rɨgwáowa tɨ́nɨ sɨŋwɨ́ rananɨro nánɨ bɨ́amɨ bɨraiyɨ́ roŋoɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","o re urɨŋɨnigɨnɨ, “Ámá re ŋwɨxapɨgɨ́á tɨyɨ́, xwɨyɨ́á Gorɨxoyá arɨ́á wiro xɨxenɨ ero yarɨgɨ́áyɨ́, ayɨ́ gɨ́ inókíwánɨŋɨ́ nɨrɨxɨ́meáowánɨŋɨ́ imónɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Íná sɨ́á wɨyimɨ Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ ewéyo nɨpɨxemoánɨro o re urɨŋɨnigɨnɨ, “Ipíyo jɨ́arɨwámɨnɨ dánɨ oxemoaneyɨ.” nurɨrɨ nɨmeámɨ nuro ");
INSERT INTO aak_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ipíyo nɨmeámɨ warɨ́ná Jisaso rɨxa sá winɨ́agɨ sá weŋáná re eŋɨnigɨnɨ. Rɨ́wɨpí xwé wí nɨweapɨrɨ ipíyo nɨxemɨ nurɨ ewéyo iniɨgɨ́ mɨmeámɨ́ yarɨ́ná awa rɨxa iniɨgɨ́ namipaxɨ́ yarɨŋagɨ nainenɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","nuro saiwiárɨ́ nɨwimáná re urɨgɨ́awixɨnɨ, “Neamemearɨŋoxɨnɨ, neamemearɨŋoxɨnɨ, rɨxa iniɨgɨ́ namianɨ aŋwɨ ayorɨnɨ.” uráná Jisaso nɨwiápɨ́nɨmearɨ imɨŋɨ́ yarɨŋɨ́pimɨ tɨ́nɨ iniɨgɨ́ reakɨ́kwɨ́í yaparɨŋɨ́pimɨ tɨ́nɨ mɨxɨ́ nurɨrɨ “Pɨ́nɨ wiáreɨ.” uráná re eŋɨnigɨnɨ. Pɨ́nɨ nɨwiárɨrɨ́ná imɨŋɨ́ mé nerɨ iniɨgɨ́ samɨŋɨ́ weárɨrɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Rɨxa imɨŋɨ́ mé nerɨ iniɨgɨ́ samɨŋɨ́ weárɨrɨ éáná o wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né dɨŋɨ́ mɨnɨkwɨ́ropa pí nánɨ yarɨŋoɨ?” urɨ́agɨ awa wáyɨ́ ero ududɨ́ ero nero re rɨnɨgɨ́awixɨnɨ, “Ámá royɨ́ imɨŋɨ́ tɨ́nɨ iniɨgɨ́ tɨ́nɨ sekaxɨ́ uráná ámánɨŋɨ́ arɨ́á wíɨ́ royɨ́ gorɨ́anɨ?” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Awa ewépá nɨmeáa nuro ipí Gaririyo jɨ́arɨwámɨnɨ aŋɨ́ bɨ xegɨ́ yoɨ́ Gegesayɨ rɨnɨŋɨ́pɨ tɨ́ŋɨ́ e niwiékɨ́nɨmearo ");
INSERT INTO aak_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisaso nayoarɨ rɨxa xwɨ́áyo éɨ́ roŋáná ámá aŋɨ́ apimɨ dáŋɨ́ wo —Omɨ imɨ́ó wí xɨxéroarɨŋorɨnɨ. Eŋíná dánɨ iyaxɨ́ aikɨ́ mɨyínɨ́ néra urɨ aŋɨ́ wíyo mɨŋweapa erɨ ámá xwárɨpá tɨ́ŋɨ́ enɨ ŋwearɨ yarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","O Jisasomɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná xwamiánɨ́ nɨrɨrɨ Jisasomɨ agwɨ́ rɨwámɨnɨ nɨpɨ́kínɨmearɨ ímɨ́ tɨ́nɨ re urɨŋɨnigɨnɨ, “Jisasoxɨ, niaíwɨ́ Ŋwɨ́á seáyɨ émɨ ŋweaŋoyáoxɨ, pí neaimɨnɨrɨ barɨŋɨnɨ? Nionɨ waunɨ́ re rɨrarɨŋɨnɨ, ‘Xeanɨŋɨ́ wí mɨneaikárɨpanɨ.’ rɨrarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisaso sekaxɨ́ “Imɨ́oyɨ́né ámá romɨ pɨ́nɨ nɨwiárɨmɨ úpoyɨ.” urɨ́ɨ́ eŋagɨ nánɨ Jisasomɨ e nurɨrɨ —O imɨ́ó íníná dɨŋɨ́ xɨxéroarɨŋɨ́ eŋagɨ nánɨ xegɨ́ ámá omɨ ɨ́á nɨxero gwɨ́ wɨrí tɨ́nɨ ainɨxɨ́ ikasɨ́á inɨŋɨ́ wɨrí tɨ́nɨ nɨjiro awí meŋweaŋagɨ́a aiwɨ gwɨ́ jíɨ́ápɨ narɨ́kiárɨmɨ imɨ́ó ámá dɨŋɨ́ meaŋe nánɨ sayá nɨméra wayarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Omɨ Jisaso yarɨŋɨ́ re wiŋɨnigɨnɨ, “Segɨ́ yoɨ́ píxɨnɨ?” urɨ́agɨ imɨ́owa xwé obaxɨ́ mɨrónɨŋagɨ́a nánɨ re urɨgɨ́awixɨnɨ, “Negɨ́ yoɨ́ Rijonɨyɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ mɨxɨ́ nánɨ xwé obaxɨ́ gwɨ́ mónarɨgɨ́á nánɨrɨnɨ. Yoɨ́ e rɨnɨŋwɨnɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","waunɨ́ rɨxɨŋɨ́ re urayigɨ́awixɨnɨ, “Joxɨ none mɨxɨ́ nɨneamáɨnowárɨrɨ́ná sirɨrɨkɨ́ yoparɨ́ bɨ mimónɨŋɨ́yi tɨ́ŋɨ́ e Gorɨxo xeanɨŋɨ́ neaikárɨnɨ́e nánɨ mɨxɨ́ mɨneamáɨnowárɨpanɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","odɨpí xwé obaxɨ́ dɨ́wɨ́yo wiároárɨnɨŋagɨ́a nɨwɨnɨro waunɨ́ re urɨgɨ́awixɨnɨ, “Imɨ́one odɨpíyo rɨ́wɨ́mɨnɨ oxɨxérópoyɨnɨrɨ sɨŋwɨ́ neanɨrɨréɨnɨ?” urɨ́agɨ́a o xe oépoyɨnɨrɨ sɨŋwɨ́ wɨnáná ");
INSERT INTO aak_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","imɨ́owa ámá omɨ pɨ́nɨ nɨwiárɨmɨ nuro ámɨ odɨpíyo xɨxéróáná re eŋɨnigɨnɨ. Odɨpí ayɨ́ imegɨ́ aŋɨ́nɨ omíɨ́áyɨ́ sapɨpaŋɨ́mɨ sɨwá néra ipíyo nɨpáwiro pɨyɨ́ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ámá odɨpí awí mearoarɨgɨ́áyɨ́ wigɨ́ odɨpí e éagɨ́a nɨwɨnɨro wigɨ́ aŋɨ́ apimɨ nánɨ éɨ́ nuro ámá e ŋweagɨ́áyo áwaŋɨ́ urɨro ámá omɨŋɨ́yo yarɨgɨ́áyo áwaŋɨ́ urɨmero wíáná ");
INSERT INTO aak_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ámá ayɨ́ “Pí rɨ́a eŋoɨ?” nɨyaiwiro sɨŋwɨ́ wɨnanɨro nánɨ nɨbɨro Jisaso tɨ́ŋɨ́ e nɨrémoro wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Ámá imɨ́ó xɨxéroarɨŋo riwo aikɨ́ yínɨrɨ dɨŋɨ́ sɨxɨ́ yínɨrɨ nemáná Jisasoyá sɨkwɨ́ tɨ́ŋɨ́ e éɨ́ ŋweaŋagɨ nɨwɨnɨro wáyɨ́ nero yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ámá Jisaso imɨ́ó mɨxɨ́ umáɨnowárɨ́agɨ sɨŋwɨ́ wɨnɨ́áyɨ́ Jisaso imɨ́ó sayá mearɨŋomɨ píránɨŋɨ́ wimɨxɨ́ɨ́ nánɨ repɨyɨ́ nɨwiróná ");
INSERT INTO aak_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ámá ayɨ́ nɨ́nɨ aŋɨ́ Gegesa dáŋɨ́yɨ́ tɨ́nɨ ámá aŋɨ́ apimɨ mɨdɨmɨdánɨ ŋweagɨ́áyɨ́ tɨ́nɨ wáyɨ́ xwé nikárɨnɨro nánɨ Jisasomɨ waunɨ́ re urɨgɨ́awixɨnɨ, “ ‘Nene pɨ́nɨ nɨneawiárɨmɨ ounɨ.’ neaimónarɨnɨ.” urɨ́agɨ́a o ámɨ ewéyo nɨpɨxemoánɨrɨ umɨnɨrɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ámá imɨ́ó mɨxɨ́ umáɨnɨ́o waunɨ́ rɨxɨŋɨ́ “ ‘Nionɨ tɨ́nɨ owaiyɨ.’ nimónarɨnɨ.” urarɨŋagɨ aí Jisaso xegɨ́ aŋɨ́ e nánɨ nurowárɨrɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dɨxɨ́ aŋɨ́ e nánɨ nurɨ Gorɨxo siíɨ́pɨ nánɨ dɨxɨ́ ámáyo repɨyɨ́ nɨwirɨ ŋwearɨ uɨ.” urɨ́agɨ o Jisasomɨ pɨ́nɨ nɨwiárɨmɨ nurɨ aŋɨ́ apimɨ nɨpimɨnɨ Jisaso wiíɨ́pɨ nánɨ repɨyɨ́ wiemeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisaso ámɨ ipíyo jɨ́arɨwámɨnɨ iwiékɨ́nɨmeááná ámá obaxɨ́ e epɨ́royɨ́ ero o nánɨ xwayɨ́ nanɨrɨ ŋwearo egɨ́áyɨ́ omɨ yayɨ́ nɨwiro yarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ámá ámɨná wigɨ́ rotú aŋɨ́ wiwá meŋweaŋɨ́ wo —O xegɨ́ yoɨ́ Jairasorɨnɨ. Miáí ná wímɨnɨ xanorɨnɨ. O nɨbɨrɨ Jisasoyá sɨkwɨ́ tɨ́ŋɨ́ e nɨpɨ́kínɨmearɨ xɨ́o xegɨ́ miáí —Í xwiogwɨ́ wé wúkaú sɨkwɨ́ waú imónɨŋírɨnɨ. Í rɨxa nɨpémɨnɨrɨ yarɨŋagɨ nánɨ xano Jisasomɨ waunɨ́ rɨxɨŋɨ́ re urɨŋɨnigɨnɨ, “Gɨ́ miáímɨ naŋɨ́ imɨxɨrɨ nionɨ tɨ́nɨ gɨ́ aŋɨ́yo nánɨ nɨwanɨréwiɨ?” urɨ́agɨ o “Ananɨrɨnɨ.” nurɨrɨ awaú óɨ́ e warɨ́ná ámá e epɨ́royɨ́ egɨ́áyɨ́ nuxɨ́dɨro Jisasomɨ ɨkwɨkwierɨ́ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","apɨxɨ́ wí —Í xegɨ́ ragɨ́ anɨŋɨ́ pwarɨ́ná xwiogwɨ́ wé wúkaú sɨkwɨ́ waú múroŋírɨnɨ. Ámá obaxɨ́ naŋɨ́ imɨxanɨro nɨyayirɨŋɨ́ aí naŋɨ́ wí mimónɨŋírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Í “Jisasoyá iyɨ́áyonɨ amáɨ́ nɨrónɨrɨ́náyɨ́, ámɨ naŋɨ́ imónɨmɨ́ɨnɨ.” nɨyaiwia nɨxɨ́dɨrɨ rɨ́wɨ́mɨ dánɨ oyá iyɨ́á sírɨ́wɨ́yo amáɨ́ rónáná re eŋɨnigɨnɨ. Ragɨ́ anɨŋɨ́ pwarɨŋɨ́pɨ yeáyɨ́ sɨkiárɨŋɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeáyɨ́ sɨkiáráná Jisaso re rɨŋɨnigɨnɨ, “Amáɨ́ go nɨrónɨgoɨ?” rɨ́agɨ ámá nɨ́nɨ “Oweoɨ, nionɨmanɨ. Nionɨmanɨ.” nɨra warɨ́ná xegɨ́ wiepɨsarɨŋɨ́ wo Pitaoyɨ rɨnɨŋo re urɨŋɨnigɨnɨ, “Neamemearɨŋoxɨnɨ, ámá epɨ́royɨ́ nɨsiro ɨkwɨkwierɨ́ nɨsiga warɨŋoɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisaso re rɨŋɨnigɨnɨ, “Nepa ámá wo amáɨ́ nɨrónɨgoɨ. Nɨgɨ́ eŋɨ́ eánɨŋɨ́ bɨ nɨnɨwárɨmɨ ámá womɨ naŋɨ́ imɨxɨ́agɨ nainenɨrɨ nánɨ rarɨŋɨnɨ.” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","apɨxɨ́ í yumɨ́í mepaxɨ́ wimónɨ́agɨ nɨwɨnɨrɨ óɨ́ néra aŋwɨ e nɨbɨrɨ oyá sɨ́mɨmaŋɨ́rɨwámɨnɨ nɨpɨ́kínɨmearɨ oxɨ́ apɨxɨ́ nɨ́nɨ sɨŋwɨ́yo dánɨ wɨ́á re rókiamónɨŋɨnigɨnɨ, “Niínɨ gɨ́ ragɨ́ anɨŋɨ́ pwarɨŋagɨ nánɨ Jisasomɨ amáɨ́ rónɨ́ɨnɨ. Omɨ amáɨ́ nɨrónɨrɨ́ná rɨxa naŋɨ́ imónɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","o re urɨŋɨnigɨnɨ, “Miaé, jíxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ nánɨ naŋɨ́ imónɨ́ɨnɨ. Ámɨ ayá mɨsinɨpa nerɨ kikiɨ́á néra uɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","sɨnɨ ímɨ e urarɨ́ná ámá wo rotú aŋɨ́ meŋweaŋoyá aŋɨ́ e dánɨ nɨbɨrɨ omɨ re urɨŋɨnigɨnɨ, “Uréwapɨyarɨŋomɨ sɨnɨ ayá wí murɨŋweapanɨ. Dɨxɨ́ miáí rɨxa péɨnigɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisaso arɨ́á e nɨwirɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ miáí péɨ́ aiwɨ wáyɨ́ mepanɨ. Nionɨ dɨŋɨ́ nɨkwɨ́róánáyɨ́, í ámɨ naŋɨ́ imónɨnɨŋoɨ.” nurɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","aŋɨ́yo nɨpáwirɨ́ná ámá wí nawínɨ opáwianeyɨnɨrɨ sɨŋwɨ́ mɨwɨnɨpa nerɨ sa xegɨ́ wiepɨsarɨŋɨ́ Pitao tɨ́nɨ Jono tɨ́nɨ Jemiso tɨ́nɨ miáímɨ xɨnáí tɨ́nɨ xano tɨ́nɨ ayɨ́ tɨ́nɨnɨ nɨpáwiro ");
INSERT INTO aak_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ámá nɨ́nɨ ŋwɨ́ earo ámɨxɨ́á mero yarɨŋagɨ́a nánɨ Jisaso re urɨŋɨnigɨnɨ, “Ŋwɨ́ eaarɨgɨ́á pɨ́nɨ wiárɨ́poyɨ. Nɨperɨ mɨwenɨnɨ. Sa sá wenɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ayɨ́ “Í rɨxa pɨyɨ́xɨnɨ.” nɨyaiwiro nánɨ rɨpɨ́á urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","o íyá wépámɨ ɨ́á nɨmaxɨrɨmáná ímɨ́ tɨ́nɨ “Miá ríxɨnɨ, wiápɨ́nɨmeaɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Miáí ámɨ dɨŋɨ́ sɨxɨ́ wínáná apaxɨ́ mé wiápɨ́nɨmeaŋɨnigɨnɨ. Rɨxa wiápɨ́nɨmeááná Jisaso xanɨyaúmɨ “Aiwá bɨ umeaípiyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ayaú ududɨ́ ikárɨnɨ́agɨ́i Jisaso ŋwɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Aípagwí nionɨ éápɨ nánɨ ámá wíyo áwaŋɨ́ murɨpanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jisaso xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ “Awí eánɨ́poyɨ.” nurɨrɨ awa sɨmɨxɨ́ xɨxegɨ́nɨ naŋɨ́ imɨxɨpɨ́rɨ nánɨ ero imɨ́ó nɨ́nɨ mɨxɨ́ umáɨnowárɨpɨ́rɨ nánɨ ero epɨ́rɨ́a nánɨ kwíyɨ́ bɨ nɨwirɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ bɨ nɨweámɨxowárɨrɨ re urowárɨŋɨnigɨnɨ, “Soyɨ́né aŋɨ́ ayɨ́ ayo nemero Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ wáɨ́ urɨmero sɨmɨxɨ́ yarɨgɨ́áyo naŋɨ́ imɨxɨmero éɨ́rɨxɨnɨ.” nurowárɨrɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","re urɨŋɨnigɨnɨ, “Amɨ amɨ wagwí wagwí nuro urɨ́nɨpɨ́rɨ nánɨ segɨ́ amɨpí bɨ nɨmeámɨ mupanɨ. Eraŋɨ́ranɨ, ɨ́á árupiaŋɨ́ranɨ, aiwáranɨ, nɨgwɨ́ranɨ, iyɨ́á wúkaúranɨ, nɨmeámɨ mupanɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wáɨ́ nemerɨ́ná aŋɨ́ bimɨ nɨrémorɨ́náyɨ́ aŋɨ́ iwamɨ́ó nuro páwíɨ́áyo wéɨ́rɨxɨnɨ. Rɨxa ámá aŋɨ́ apimɨ ŋweagɨ́áyo nuréwapɨyimáná aŋɨ́ axiwámɨnɨ nɨŋweagɨ́isáná ‘Ámɨ aŋɨ́ bimɨ nánɨ owaiyɨ.’ nɨyaiwirínáyɨ́ aŋɨ́ axiwámɨ dánɨ pɨ́nɨ nɨwiárɨmɨ úɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wáɨ́ nurɨmerɨ́náyɨ́ aŋɨ́ bimɨ nɨrémorɨ́ná ámá e ŋweagɨ́áyɨ́ ‘Negɨ́ aŋɨ́ tɨ́yo ɨ́wiapɨ́poyɨ.’ mɨsearɨpa éánáyɨ́, ámá ayɨ́ dɨŋɨ́ ‘Newanɨŋene ikárɨnɨŋwáyɨ́ nánɨ awaú nene nánɨ ámɨ mɨbɨpa epɨsi nánɨ iyɨ́ rɨyárɨ́iɨ?’ yaiwipɨ́rɨ nánɨ sɨkwɨ́yo xwɨ́á sikɨ́ xénɨŋɨ́pɨ pɨ́rɨ́ wiaíkímɨ́ nɨyárɨmɨ úɨ́rɨxɨnɨ.” Sekaxɨ́ e nurɨ́ɨsáná eŋáná ");
INSERT INTO aak_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","awa omɨ pɨ́nɨ nɨwiárɨmɨ nuro aŋɨ́ bɨ bimɨ nánɨ numiro xwɨyɨ́á naŋɨ́ yayɨ́ winɨpaxɨ́pɨ wáɨ́ urɨmero sɨmɨxɨ́ egɨ́áyo naŋɨ́ imɨxɨro néra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gapɨmanɨ́ Xeroto Jisasoyá wiepɨsarɨŋowa yarɨgɨ́ápɨ nɨpɨnɨ nánɨ arɨ́á nɨwirɨ ududɨ́ nɨwinɨrɨ ŋweaŋáná ámá wí emɨmɨ́ apɨ yarɨŋagɨ́a nánɨ re nɨra ugɨ́awixɨnɨ, “Jono xwárɨpáyo dánɨ rɨxa nɨwiápɨ́nɨmearɨ rɨ́a yarɨnɨ?” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ámá ámɨ wí re nɨra ugɨ́awixɨnɨ, “Gorɨxoyá wɨ́á rókiamoagɨ́ Iraijaoyɨ rɨnɨŋo, mɨpé aŋɨ́namɨ peyiŋo rɨxa sɨŋánɨ nimónɨrɨ rɨ́a yarɨnɨ?” nɨra warɨ́ná ámá ámɨ wí re nɨra ugɨ́awixɨnɨ, “Eŋíná Gorɨxoyá wɨ́á rókiamoagɨ́á wo rɨxa nɨwiápɨ́nɨmearɨ rɨ́a yarɨnɨ?” nɨra warɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xeroto ududɨ́ nɨwinɨrɨ re rɨŋɨnigɨnɨ, “Niɨwanɨŋonɨ ráná Jonomɨ siŋwɨ́ mɨŋɨ́ wákwigɨ́awixɨnɨ. E nerɨ aiwɨ ámá nionɨ arɨ́á e wiarɨŋá royɨ́ gorɨ́anɨ?” nɨrɨrɨ Jisasomɨ sɨŋwɨ́ owɨnɨmɨnɨrɨ yayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","O xegɨ́ wáɨ́ wurɨmeiarɨgɨ́áwa ámɨ xɨ́o tɨ́ŋɨ́ e nánɨ nɨbɨro wigɨ́ néra ugɨ́ápɨ nánɨ repɨyɨ́ nɨwimáná eŋáná o awa tɨ́nɨnɨ nerɨmeánɨro ámá nɨ́nɨ pɨ́nɨ nɨwiárɨmɨ nuro wigɨ́pɨ aŋɨ́ wíyo xegɨ́ yoɨ́ Betɨsaidayo nánɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","oxɨ́ apɨxɨ́ obaxɨ́ Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ aŋɨ́ apimɨ nánɨ pwarɨŋagɨ́a nɨwɨnɨro númɨ nuro omɨ wímeááná o yayɨ́ nɨwirɨ xwɨyɨ́á “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́a nánɨ seyɨ́né nɨsanɨro éɨ́rɨxɨnɨ.” uréwapɨyirɨ sɨmɨxɨ́ egɨ́áyo naŋɨ́ imɨmɨxɨmɨ́ erɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú sogwɨ́ nokepá imónáná Jisasomɨ nɨbɨro re urɨgɨ́awixɨnɨ, “Ámá onɨ́ wówɨ re mɨŋweaŋagɨ́a nánɨ ámá epɨ́royɨ́ egɨ́á tɨyɨ́ aiwá nɨro sá wero epɨ́rɨ nánɨ omɨŋɨ́ aŋɨ́ amɨ amɨ mɨrɨnɨmeŋɨ́yo nánɨ uro aŋɨ́ apɨ apɨ ikwɨ́rónɨŋɨ́yo nánɨ uro oépoyɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","o re urɨŋɨnigɨnɨ, “Aiwá nɨpɨ́rɨ sewanɨŋoyɨ́né mɨnɨ wípoyɨ.” urɨ́agɨ re urɨgɨ́awixɨnɨ, “Negɨ́ aiwá xwé menɨnɨ. Bisɨ́kerɨ́á wé wú eŋáná peyɨ́ waúnɨrɨnɨ.” nurɨro ámá oxɨ́ 5,000 e ŋweaŋagɨ́a nánɨ re urɨgɨ́awixɨnɨ, “None nurane aiwá bɨ mepa nerɨ́náyɨ́, arɨge mɨnɨ wianɨ́wɨnɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “Ámá tɨ́yo re urɨ́poyɨ, ‘Seyɨ́né ámá 50 50 maxɨrɨnɨ́ wí e wí e nɨŋweaxa úpoyɨ.’ urɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","awa axɨ́pɨ e uráná ámá nɨ́nɨ 50 50 maxɨrɨnɨ́ wí e wí e nɨŋweaxa nuro ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisaso bisɨ́kerɨ́á wé wú tɨ́nɨ peyɨ́ awaú tɨ́nɨ aŋɨ́namɨ wenɨŋɨ́ nɨyánɨrɨ́ná aiwá apɨ nánɨ Gorɨxomɨ yayɨ́ nɨwirɨ kwɨkwɨrɨmɨ́ nerɨ xegɨ́ wiepɨsarɨŋowa yaŋɨ́ nɨwiaupɨ́rɨ mɨnɨ nɨwia warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ámá nɨ́nɨ nɨnɨro agwɨ́ ímɨ uyíáná aiwá nɨnɨro e tɨ́ápia wiepɨsarɨŋowa nɨmeamero soxɨ́ ɨ́á wé wúkaú sɨkwɨ́ waú apimɨ aumaúmɨ́ yárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sɨ́á wíyo Jisaso xegɨ́pɨ nɨŋwearɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ xegɨ́ wiepɨsarɨŋowa xɨ́o tɨ́nɨ ŋweaŋáná o yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ámá oxɨ́ apɨxɨ́ nɨ́nɨ nionɨ nánɨ gorɨnɨ rarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","awa re urɨgɨ́awixɨnɨ, “Wí joxɨ nánɨ ‘Jono wayɨ́ nɨneameaia uŋorɨnɨ.’ rarɨŋoɨ. Ámɨ wí ‘Gorɨxoyá wɨ́á rókiamoagɨ́ Iraijaorɨnɨ.’ rarɨŋoɨ. Ámɨ wí ‘Eŋíná Gorɨxoyá wɨ́á rókiamoagɨ́á wo rɨxa wiápɨ́nɨmeáɨ́rɨnɨ.’ rarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","o re urɨŋɨnigɨnɨ, “Ayɨ́ e nɨrɨro aiwɨ sewanɨŋoyɨ́né nionɨ nánɨ gorɨnɨ rarɨŋoɨ?” urɨ́agɨ Pitao re urɨŋɨnigɨnɨ, “Joxɨ Kiraisoyɨ rɨnɨŋoxɨ, ámá Isɨrerene yeáyɨ́ neayimɨxemearɨ́a nánɨ negɨ́ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rɨnɨŋoxɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitao e urɨ́agɨ aí o ŋwɨ́ ikaxɨ́ nurɨrɨ arɨ́á jɨyikɨ́ norɨ re urɨŋɨnigɨnɨ, “Aga bɨ onɨmiápɨ ámá wíyo murɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ámá imónɨŋáonɨ xeanɨŋɨ́ obaxɨ́ nikárɨpɨ́rɨ́árɨnɨ. Negɨ́ Judayɨ́ mebáowa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ nionɨ rɨ́wɨ́ nɨmóáná wa nɨpɨkipɨ́rɨ́árɨnɨ. E nerɨ aiwɨ sɨ́á wɨyaú wɨyi óráná ámɨ wiápɨ́nɨmeámɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xwɨyɨ́á rɨpɨ enɨ nowamɨnɨ urayiŋɨnigɨnɨ, “Ámá goxɨ goxɨ ‘Jisasomɨ ouxɨ́dɨmɨnɨ.’ nɨyaiwirɨ́náyɨ́, re éɨrɨxɨnɨ. Amɨpí ‘Nionɨ nɨgɨ́pɨ nánɨ oemɨnɨ.’ yaiwíɨ́yɨ́ dɨŋɨ́ peá nɨmorɨ re yaiwíɨrɨxɨnɨ, ‘Nionɨ Jisasomɨ xɨ́darɨŋagɨ nánɨ ámá wí xeanɨŋɨ́ nirɨ nɨpɨkirɨ nɨnirɨ aí ayɨ́ ananɨrɨnɨ.’ nɨyaiwirɨ nionɨ nɨxɨ́dɨ́ɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ámá goxɨ goxɨ nionɨ Jisasomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xɨ́darɨŋagɨ nánɨ nɨpɨkipɨ́rɨxɨnɨrɨ xewanɨŋoxɨ éɨ́ nɨmenɨrɨ́náyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́ámanɨ. E nerɨ aiwɨ ámá goxɨ goxɨ éɨ́ mɨmenɨpa nerɨ ‘Nionɨ Jisasomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xɨ́darɨŋagɨ nánɨ nɨnɨpɨkirónáyɨ́, ayɨ́ ananɨrɨnɨ.’ yaiwiarɨŋɨ́ goxɨ goxɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́ anɨŋɨ́ ŋwearɨ́a nánɨ mearɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ámá wo nionɨ mɨnɨxɨ́dɨ́ iyɨ́á ɨ́á nɨgwɨ́ amɨpí emeámɨnɨrɨ nánɨnɨ néra nurɨ nɨmeáɨsáná xewanɨŋo anɨŋɨ́nɨ ikeamónáná oyá amɨpí anɨŋɨ́ nɨxɨrɨrɨ ŋweanɨ́árɨ́anɨ? Oweoɨ!” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","re urɨŋɨnigɨnɨ, “Ámá nionɨ nánɨ ayá sinɨrɨ xwɨyɨ́á nionɨ rarɨŋápɨ nánɨ ayá sinɨrɨ nerɨ nánɨ mɨnɨxɨ́dɨpa yarɨŋɨ́ goxɨ goxɨ ámá imónɨŋáonɨ ámɨ nɨweapɨrɨ́ná ikɨ́nɨŋáonɨ weapɨrɨ wɨ́á nionɨyá tɨ́nɨ gɨ́ ápoyá tɨ́nɨ aŋɨ́najowayá tɨ́nɨ nɨpɨróa weapɨrɨ emɨ́áonɨ enɨ joxɨ nánɨ ayá nɨnirɨ re rɨrɨmɨ́árɨnɨ, ‘Oweoɨ, nionɨyáoxɨmanɨ.’ rɨrɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","E nerɨ aiwɨ wiyɨ́né re rogɨ́á tiyɨ́né sɨnɨ mɨpepa egɨ́ámɨ eŋáná Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ wiyɨ́né sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","E nurɨ́ɨsáná rɨxa sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo óráná o Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ winɨ Pitaomɨ tɨ́nɨ Jonomɨ tɨ́nɨ Jemisomɨ tɨ́nɨ nɨwirɨmeámɨ dɨ́wɨ́ xwé bimɨ nánɨ nɨyiro ");
INSERT INTO aak_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","o Gorɨxomɨ xwɨyɨ́á urarɨ́ná re eŋɨnigɨnɨ. Xegɨ́ sɨ́mɨmaŋɨ́ xegɨ́ bɨ írɨrɨ rapɨrapɨ́ yínɨŋú enɨ apɨ́á werɨ ápiaŋwɨ́nɨŋɨ́ xwɨnɨ́á earɨ nerɨ eŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ámá pɨ́né o tɨ́nɨ nawínɨ xwɨyɨ́á rarɨgɨ́íwaúyɨ́ —Awaú Gorɨxoyá wɨ́á rókiamoagɨ́íwaú Moseso tɨ́nɨ Iraijao tɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Awaú ikɨ́nɨgɨ́íwaú éɨ́ nɨrónapɨri Jisaso tɨ́nɨ o xwɨ́á tɨ́yo pɨ́nɨ nɨwiárɨmɨ ámɨ aŋɨ́namɨ nánɨ nɨpeyirɨ́ná Jerusaremɨyo perɨ ámá nɨyonɨ nánɨ wiirɨ enɨ́ápɨ nánɨ xwɨyɨ́á rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitao tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨgɨ́íwaú tɨ́nɨ xámɨ sá winarɨŋagɨ sá wegɨ́áwa, sainɨ́owa nɨwiápɨ́nɨmearo wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Jisaso ikɨ́nɨŋo roŋagɨ nɨwɨnɨro ámá nawínɨ rogɨ́íwaú enɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","awaú Jisasomɨ rɨxa pɨ́nɨ nɨwiárɨmɨ wanɨri yarɨŋagɨ́i nɨwɨnɨro Pitao dɨŋɨ́ nɨpɨkwɨnɨ mɨmó “Píoɨ urɨmɨ́ɨnɨ?” nɨrɨnɨrɨ Jisasomɨ úrapí xwɨyɨ́á re urɨŋɨnigɨnɨ, “Neamemearɨŋoxɨnɨ, none re nɨŋwearɨ́ná naŋɨ́rɨnɨ. Aŋɨ́ pɨpákɨ́ wíkaú wí, joxɨ nánɨ wiwáyɨ, Moseso nánɨ wiwáyɨ, Iraijao nánɨ wiwáyɨ oseamɨrɨyaneyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","sɨnɨ e urarɨ́ná agwɨ́ wí nɨyapɨrɨ awamɨ rɨtɨ́ wimɨnɨrɨ yarɨŋagɨ nɨwɨnɨro wáyɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","agwɨ́ apimɨ dánɨ xwɨyɨ́á bɨ re rɨnɨŋɨnigɨnɨ, “Gɨ́ niaíwɨ́ royoɨ, niɨwanɨŋonɨ rɨ́peaŋáomɨ arɨ́á wípoyɨ.” ráná ");
INSERT INTO aak_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Jisaso xegɨ́ xewɨnɨ roŋagɨ nɨwɨnɨro xwɨyɨ́á marɨ́ wiwanɨŋowa sɨŋwɨ́ wɨnɨ́ápɨ nánɨ íná ámá wíyo áwaŋɨ́ murɨpa egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sá e wegɨ́áwa wɨ́ápɨ tɨ́nɨ nɨwiápɨ́nɨmeámɨ dɨ́wɨ́yo weapáná oxɨ́ apɨxɨ́ obaxɨ́ epɨ́royɨ́ egɨ́áyɨ́ o tɨ́nɨ órórɨ́ ninɨro ");
INSERT INTO aak_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ámá apɨ epɨ́royɨ́ egɨ́ápimɨ dánɨ wo nɨwiápɨ́nɨmearɨ rɨ́aiwá re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, gɨ́ íwomɨ sɨŋwɨ́ owɨnɨnɨrɨ nánɨ waunɨ́ rɨxɨŋɨ́ rɨrarɨŋɨnɨ. O gɨ́ niaíwɨ́ ná wonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Imɨ́ó xɨxéróáná o makɨrɨ́wɨ́ nɨmorɨ rɨxa meaŋɨ́ nearɨ móáná sinapɨxwɨ́nɨ́ iwénɨrɨ meákɨ́kwiɨ́á erɨ yarɨ́ná omɨ xwɨrɨxwɨrɨ́á nikɨxerɨ rɨxa ayápɨnɨ mewɨ́narɨŋagɨ nɨwɨnɨrɨ́ná pɨ́nɨ wiárarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dɨxɨ́ wiepɨsarɨŋowamɨ waunɨ́ rɨxɨŋɨ́ ‘Imɨ́ó gɨ́ íwomɨ xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowárɨ́poyɨ.’ urɨ́á eŋagɨ aiwɨ awa wí e epaxɨ́ menɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisaso re rɨŋɨnigɨnɨ, “Ámá agwɨ tɨyɨ́né ŋweagɨ́áyɨ́né, nionɨ dɨŋɨ́ mɨnɨkwɨ́ropa ero xeŋwɨ́nɨ moro yarɨgɨ́áyɨ́né, ‘Jisaso íníná renɨnɨ nene tɨ́nɨ nɨŋwearane arɨrá neainɨ́árɨnɨ.’ rɨyaiwiarɨŋoɨ?” nɨrɨrɨ xanomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ íwo aŋwɨ re nɨmeámɨ beɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","íwomɨ sɨnɨ nɨmeámɨ barɨ́ná imɨ́ó meaŋɨ́ eááná sɨrɨrɨŋwɨ́ néra piéróagɨ aí Jisaso imɨ́omɨ mɨxɨ́ numáɨnowárɨmáná niaíwomɨ naŋɨ́ nɨwimɨxɨrɨ ámɨ xanomɨ mɨnɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mɨnɨ wíáná ámá nɨ́nɨ Gorɨxoyá eŋɨ́ eánɨŋɨ́ Jisaso éɨ́pɨ nánɨ ududɨ́ nero “Ayɨkwɨranɨ?” yaiwigɨ́awixɨnɨ. Ámá nɨ́nɨ Jisaso yarɨŋɨ́pɨ nánɨ ududɨ́ yarɨ́ná o wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Píránɨŋɨ́ arɨ́á nípoyɨ. Nionɨ arɨ́á eŋɨ́yo searémoarɨŋɨnɨ. Aŋɨ́namɨ dáŋɨ́ ámá imónɨŋáonɨ ámá wíyo mɨyɨ́ nurɨpɨ́rɨ́árɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","awa xwɨyɨ́á apɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ ínɨmɨ imónɨŋagɨ nánɨ píránɨŋɨ́ nɨjɨ́á mimónɨpa nero mɨ́kɨ́pɨ nánɨ yarɨŋɨ́ wianɨrɨ éɨ́áyɨ́ wáyɨ́ nɨwiro nánɨ masɨsɨ́á wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wiepɨsarɨŋowa xɨmɨxɨmɨ́ ninɨro “None go go seáyɨ e imónɨrɨ́enɨŋoɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisaso wigɨ́ xwioxɨ́yo adadɨ́ nɨwirɨ awa e yaiwiarɨŋagɨ́a nɨwɨnɨrɨ nánɨ niaíwɨ́ bɨ nɨmearɨ xɨ́o tɨ́ŋɨ́ e éɨ́ nurárɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","awamɨ re urɨŋɨnigɨnɨ, “Ámá woxɨ goxɨ goxɨ nionɨ nɨnɨxɨ́dɨrɨ nánɨ niaíwɨ́ rɨpimɨ peayɨ́ mɨwianɨ́ wéyo nɨmerɨ́náyɨ́ apimɨnɨ mɨmearɨŋɨnɨ. Nionɨ enɨ wéyo nɨmerɨ gɨ́ ápo nɨrowárénapɨŋomɨ enɨ wéyo umerɨ yarɨŋɨnɨ. Soyɨ́né woxɨ ‘Nionɨ awamɨ ínɨmɨ nɨwurɨ́nɨrɨ saŋɨ́ ourápɨmɨnɨ.’ yaiwinarɨŋo oyɨ́ seáyɨ e imónɨŋorɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wiepɨsarɨŋɨ́ Jono re urɨŋɨnigɨnɨ, “Neamemearɨŋoxɨnɨ, none ámá wo yoɨ́ joxɨyá nɨrɨrɨ imɨ́ó mɨxɨ́ umáɨnowárarɨŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná o none mɨneaxɨ́dɨpa nerɨ yarɨŋagɨ nánɨ mepa oenɨ urɨŋwanigɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisaso re urɨŋɨnigɨnɨ, “Ámá orɨ́wámɨ dánɨ mɨró segɨ́ tɨ́ŋɨ́mɨnɨ imónɨŋorɨnɨ. Ayɨnánɨ e mepa oenɨrɨ pí nánɨ urɨgɨ́awixɨnɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Rɨxa Gorɨxo Jisasomɨ aŋɨ́namɨ nánɨ wirɨménapɨnɨ aŋwɨ e imónɨŋáná Jisaso dɨŋɨ́ “Nionɨ Jerusaremɨyo nánɨ oumɨnɨ.” nɨkwɨ́rómɨ nurɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","xwɨyɨ́á yaŋɨ́ wiowárɨ́ɨ́ wí xɨ́omɨ xámɨ umeapɨ́rɨ nánɨ urowáráná awa nuro aŋɨ́ ámá wigɨ́ yoɨ́ Samariayɨ́ —Ayɨ́ Isɨrerɨyɨ́ tɨ́nɨ xepɨxepá rónɨgɨ́áyɨ́rɨnɨ. Ayɨ́yá aŋɨ́ bimɨ nɨrémoro Jisaso rɨ́wɨ́yo bɨnɨ nánɨ amɨpí píránɨŋɨ́ imɨxanɨro éɨ́áyɨ́ ");
INSERT INTO aak_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ámá aŋɨ́ apimɨ ŋweáyɨ́ Jisaso Jerusaremɨ nánɨ umɨnɨrɨ yarɨŋagɨ nɨwɨnɨro “Míraŋɨ́ bɨ owianeyɨ.” mɨwimónɨ́ yarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","xegɨ́ wiepɨsarɨŋɨ́ Jemiso tɨ́nɨ Jono tɨ́nɨ e nɨwɨnɨri Jisasomɨ re urɨgɨ́isixɨnɨ, “Ámɨnáoxɨnɨ, yawawi ‘Gorɨxo aŋɨ́namɨ dánɨ rɨ́á nɨmamówárénapɨrɨ ámá tɨ́yo rɨ́á nɨnɨ nánɨ ananɨ ourɨ́piyɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ́i aí ");
INSERT INTO aak_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","o nɨkɨnɨmónɨrɨ awaúmɨ mɨxɨ́ “E mɨrɨpanɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","aŋɨ́ ámɨ bimɨ nánɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Óɨ́yo warɨ́ná ámá wo Jisasomɨ re urɨŋɨnigɨnɨ, “Amɨ gɨmɨ joxɨ úɨ́mɨ nionɨ enɨ númɨ rɨxɨ́dɨmemɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","o ámá royɨ́ eŋɨ́ neánɨrɨ nɨxɨ́nɨrɨ́enɨŋoɨnɨrɨ re urɨŋɨnigɨnɨ, “Sɨ́wí sayɨ́ xegɨ́ sirɨrɨkɨ́ sá wenɨ́a nánɨ tɨ́ŋɨ́rɨnɨ. Iŋɨ́ enɨ xegɨ́ yéwɨ́ tɨ́ŋɨ́rɨnɨ. E nerɨ aiwɨ ámá imónɨŋáonɨyá sá wémɨ́a nánɨ aŋɨ́ wí menɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ámɨ womɨ re urɨŋɨnigɨnɨ, “Joxɨ nɨxɨ́deɨ.” urɨ́agɨ o re urɨŋɨnigɨnɨ, “Xámɨ xe nurɨ gɨ́ ápo péáná xwɨ́á oweyárɨnɨrɨ sɨŋwɨ́ nanɨrɨréɨnɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","o re urɨŋɨnigɨnɨ, “Ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́ropa yarɨgɨ́áyɨ́ ayɨ́ enɨ ámá pɨyɨ́nɨŋɨ́ imónɨŋagɨ́a nánɨ wigɨ́ ámá péáná xwɨ́á oweyárɨnɨ́poyɨnɨrɨ sɨŋwɨ́ wɨnɨ́ɨrɨxɨnɨ. E nerɨ aí joxɨ xwɨyɨ́á Gorɨxo xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́a nánɨpɨ amɨ amɨ wáɨ́ urɨméɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ámɨ ámá wo nɨbɨrɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nionɨ rɨxɨ́dɨmemɨ́ɨnɨ. E nerɨ aiwɨ xámɨ xegɨ́ ámáyo nurɨ yayɨ́ owiemenɨrɨ sɨŋwɨ́ naneɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisaso ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá omɨŋɨ́ mearɨŋɨ́ wo nɨkɨnɨmónɨrɨ rɨ́wɨ́mɨ dánɨ sɨŋwɨ́ anáná xɨ́o omɨŋɨ́ mearɨŋɨ́pɨ xɨxenɨ warɨŋɨ́manɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ enɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ nɨnɨxɨ́dɨ́ɨsáná ámɨ nɨkɨnɨmónɨrɨ amɨpí joxɨ pɨ́nɨ wiárɨ́ɨ́yɨ́ meámɨnɨrɨ nánɨ dɨŋɨ́ nɨmorɨ nerɨ́náyɨ́, omɨŋɨ́ Gorɨxo nánɨ píránɨŋɨ́ mɨwiipa erɨ oyá xwioxɨ́yo páwipaxɨ́ mepa erɨ imónɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisaso e nurɨmáná ámá ámɨ wíyo 72 nɨrɨ́pearɨ aŋɨ́ xɨ́o unɨ́á ayɨ́ ayo nánɨ waúnɨ waúnɨ xámɨ umeapɨ́rɨ nánɨ nurowárapɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","re urɨŋɨnigɨnɨ, “Ámá nionɨ xwɨyɨ́á yaŋɨ́ seaiapowárɨ́áyɨ́, ayɨ́ aiwá yóɨ́ pɨ́rɨpɨ́rɨ́ ninɨrɨ mɨnɨpaxɨ́nɨŋɨ́ imónɨnɨ. E nerɨ aiwɨ ámá seyɨ́né aiwá apɨ mipɨ́rɨ nánɨ obaxɨ́ mimónɨŋoɨ. Ayɨnánɨ Gorɨxo ámá wínɨ enɨ aiwá mipɨ́rɨ́nɨŋɨ́ nimónɨro xwɨyɨ́á yayɨ́ winɨpaxɨ́pɨ yaŋɨ́ wiowárɨpɨ́rɨ nánɨ yarɨŋɨ́ wípoyɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","re urɨŋɨnigɨnɨ, “Soyɨ́né óɨ́ nionɨ searɨ́áyo úpoyɨ. Ámá wí sɨ́wí sayɨ́ sipɨsipɨ́ roanarɨgɨ́ápánɨŋɨ́ seaipɨ́rɨ́e nánɨ searowárarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","re urɨŋɨnigɨnɨ, “Nuróná nɨgwɨ́ wowɨ́ bɨranɨ, ɨ́á árupiaŋɨ́ wúranɨ, sɨkwɨ́ súranɨ, nɨmeámɨ mupanɨ. Óɨ́ e ámáyo nɨwɨnɨrɨ́ná yayɨ́ ninɨro e éɨ́ mɨŋweapanɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aŋɨ́ wiwámɨ nɨpáwirɨ́ná yayɨ́ nɨwirɨ xámɨ re urɨ́ɨ́rɨxɨnɨ, ‘ “Seyɨ́né Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro oŋweápoyɨ.” neaimónarɨnɨ.’ urɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aŋiwámɨ xiáwo sanɨŋo imónɨŋagɨ nɨwɨnɨrɨ́ná xwɨyɨ́á yayɨ́ nɨwirɨ́ná e urɨ́ápɨ mɨdɨdɨ́ mikɨxepanɨ. Aŋɨ́ xiáwo sanɨŋo mimónɨŋagɨ nɨwɨnɨrɨ́ná yayɨ́ apɨ mɨdɨdɨ́ wikɨxéɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aŋɨ́ giwɨ giwámɨ nɨpáwiro nɨŋwearɨ́ná aiwá tɨ́nɨ iniɨgɨ́ tɨ́nɨ seaiapɨ́ápɨ ananɨ nɨnɨro ŋweáɨ́rɨxɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá nɨgwɨ́ omɨŋɨ́ nerɨ́ná nɨgwɨ́ meaarɨgɨ́ápa soyɨ́né wáɨ́ nemero nionɨ omɨŋɨ́ nɨniirɨ́ná iniɨgɨ́ tɨ́nɨ aiwá tɨ́nɨ seaiapɨ́áyɨ́ nɨgwɨ́nɨŋɨ́ wayɨ́á nɨpɨ́rɨ́árɨnɨ.” nurɨrɨ xegɨ́ wiepɨsarɨŋowa aiwá oneaiapɨ́poyɨnɨrɨ aŋɨ́ wiwá wiwámɨ emepɨ́rɨxɨnɨrɨ ámɨ re urɨŋɨnigɨnɨ, “Aŋɨ́ wiwámɨ nɨpáwiro ŋweáɨ́iwámɨ dánɨ aŋɨ́ axɨ́pimɨ ámɨ wiwámɨ ŋweanɨro nánɨ mupa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aŋɨ́ gɨpɨ gɨpimɨ nɨrémorɨ́ná aiwá míraŋɨ́ seaianɨro ‘Aŋɨ́yo nánɨ eɨnɨ.’ nɨsearɨmɨ úɨ́áyo númɨ nuro pí pí aiwá seaiapɨ́ápɨ sa ananɨ nɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aŋɨ́ apimɨ sɨmɨxɨ́ yarɨgɨ́áyo naŋɨ́ wimɨxɨro ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́á aŋwɨ ayo eŋagɨ nánɨ nɨsanɨro ŋweáɨ́rɨxɨnɨ.’ urɨro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","E nerɨ aiwɨ aŋɨ́ gɨpɨ gɨpimɨ nɨrémorɨ́ná ayɨ́ nɨseairɨmeámɨ wigɨ́ aŋɨ́yo nánɨ mɨseaupa éáná nuro óɨ́ aŋɨ́ apimɨ nánɨ inɨŋɨ́yimɨ dánɨ re urɨ́ɨ́rɨxɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Seyɨ́né dɨŋɨ́ re mopɨ́rɨ nánɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ neameŋweámɨnɨrɨ éɨ́ aiwɨ nene apɨ nánɨ mɨneaimónarɨŋagɨ nánɨ xɨ́o xeanɨŋɨ́ neaiapɨnɨ́árɨ́anɨ?” yaiwipɨ́rɨ nánɨ xwɨ́á sikɨ́ segɨ́ aŋɨ́ rɨpimɨ dáŋɨ́ aí negɨ́ sɨkwɨ́yo xénɨŋɨ́pɨ pɨ́rɨ́ wiaíkímɨ́ seasiarɨŋwɨnɨ.’ urɨ́ɨ́rɨxɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","re urɨŋɨnigɨnɨ, “Nionɨ aga nepa seararɨŋɨnɨ. Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ ámá aŋɨ́ Sodomɨ ŋweaagɨ́áyɨ́ —Eŋíná Sodomɨ ŋweaagɨ́áyɨ́ rɨ́ánɨ nɨkɨróa warɨŋagɨ́a Gorɨxo aŋɨ́namɨ dánɨ rɨ́á mamówáráná nɨyonɨ rɨ́á nɨŋɨnigɨnɨ. Sɨ́á ayimɨ ayo Gorɨxo xeanɨŋɨ́ xwé nɨwirɨ aiwɨ ámá soyɨ́né arɨ́á mɨseaí xe oúpoyɨnɨrɨ sɨŋwɨ́ seanɨ́áyo Gorɨxo xeanɨŋɨ́ nɨwirɨ́ná Sodomɨ ŋweaagɨ́áyo rɨ́nɨŋɨ́ winɨnɨ́ápɨ tɨ́nɨ xɨxenɨ winɨnɨ́ámanɨ. Seáyɨ e múronɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Isɨrerɨyɨ́né ‘Gorɨxo nene nánɨ aga wimónarɨnɨ.’ yaiwinarɨŋagɨ́a aí xeanɨŋɨ́ o seaikárɨnɨ́ápɨ ayɨkwɨ́ meŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨ. Isɨrerɨyɨ́né aŋɨ́ yoɨ́ Korasinɨyɨ rɨnɨŋɨ́yo ŋweagɨ́áyɨ́né tɨ́nɨ aŋɨ́ yoɨ́ Betɨsaida ŋweagɨ́áyɨ́né tɨ́nɨ aweyɨ! Sɨ́á wɨyi seyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Émáyɨ́ aŋɨ́ yoɨ́ Taiayɨ rɨnɨŋɨ́yo ŋweáyɨ́ tɨ́nɨ Saidonɨyɨ rɨnɨŋɨ́yo ŋweáyɨ́ tɨ́nɨ emɨmɨ́ nionɨ seaíwapɨyiŋápɨ sɨŋwɨ́ nɨwɨnɨro sɨŋwɨrɨyɨ́, ayɨ́ eŋíná nɨsanɨro iyɨ́á írɨkwɨ́ wú pánɨro rɨ́á uráwɨ́yo iwieánɨro yanɨrɨ egɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gorɨxo ámá nɨyonɨ xeanɨŋɨ́ winɨ́áyimɨ xeanɨŋɨ́ Taia ŋweáyo tɨ́nɨ Saidonɨ ŋweáyo tɨ́nɨ winɨ́ápɨ tɨ́nɨ seyɨ́né seaikárɨnɨ́ápɨ tɨ́nɨ axɨ́pɨ imónɨnɨ́ámanɨ. Seyɨ́né seaikárɨnɨ́ápɨ seáyɨ e múronɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Isɨrerɨyɨ́né, Kapaneamɨ ŋweáyɨ́né ‘Gorɨxo aŋɨ́namɨ nánɨ nɨneameámɨ neayinɨ́árɨnɨ.’ nɨyaiwiro seáyɨ e rɨyarɨŋoɨ? Rɨ́á anɨŋɨ́ wearɨŋɨ́yo nɨseamamówárɨnɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","wiepɨsarɨŋɨ́yo ámɨ re urɨŋɨnigɨnɨ, “Ámá gɨyɨ́ gɨyɨ́ soyɨ́né wáɨ́ urɨmearɨ́ná arɨ́á seaíɨ́áyɨ́ nionɨ enɨ arɨ́á niarɨŋoɨ. Gɨyɨ́ gɨyɨ́ arɨ́á mɨseaipa éɨ́áyɨ́ nionɨ enɨ arɨ́á mɨniarɨŋoɨ. Nionɨ arɨ́á mɨnipa éɨ́áyɨ́ Gorɨxo, nɨrowárénapɨŋomɨ enɨ arɨ́á mɨwiarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ámá 72 urowárapɨŋɨ́yɨ́ ámɨ dɨŋɨ́ yayɨ́ nɨyaiwia nɨbɨro Jisasomɨ nɨwímearo re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yo aí none yoɨ́ joxɨyá nɨrɨrane mɨxɨ́ umáɨnowáráná ananɨ arɨ́á nɨneaimɨ éɨ́ warɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","o re urɨŋɨnigɨnɨ, “Soyɨ́né imɨ́óyo mɨxɨ́ umáɨnowárarɨ́ná nionɨ Seteno —O imɨ́óyo xɨráónɨŋɨ́ imónɨŋorɨnɨ. O ápiaŋwɨ́nɨŋɨ́ aŋɨ́namɨ dánɨ piérónaparɨŋagɨ wɨnɨŋanigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Arɨ́á nípoyɨ. Nionɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ seaiapowárɨŋá eŋagɨ nánɨ soyɨ́né weaxɨ́á tɨ́nɨ wáré tɨ́nɨ ananɨ xórórɨ́ ero Seteno, ɨ́wɨ́ oépoyɨnɨrɨ seaíwapɨyarɨŋomɨ ananɨ xórórɨ́ wiro epaxɨ́rɨnɨ. E yarɨ́ná wí xwɨrɨ́á seaikɨxenɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","E nɨsearɨrɨ aiwɨ imɨ́ó xɨxéroarɨŋɨ́yo mɨxɨ́ umáɨnowáráná arɨ́á nɨseairo éɨ́ warɨgɨ́á eŋagɨ nánɨ seáyɨ e nimónɨro yayɨ́ mepanɨ. Sa rɨpɨ nánɨnɨ yayɨ́ époyɨ. Aŋɨ́namɨ íkwɨ́ ámá wé rónɨŋɨ́yɨ́ nánɨ ŋwɨrárɨnɨŋɨ́namɨ segɨ́ yoɨ́ enɨ ŋwɨrárɨnɨŋagɨ nánɨ yayɨ́ époyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kwíyɨ́ Gorɨxoyápɨ ukɨkayoŋagɨ nánɨ axíná yayɨ́ seáyɨmɨ dánɨ nerɨ Gorɨxomɨ re urɨŋɨnigɨnɨ, “Gɨ́ ápoxɨnɨ, xwɨ́á imɨxɨrɨ aŋɨ́na imɨxɨrɨ eŋoxɨnɨ, wiepɨsarɨŋowa yarɨgɨ́á apɨ nánɨ ámá seáyɨ e nimónɨro ‘Nionɨ nɨgɨ́pɨ dɨŋɨ́ rɨxa nɨjɨ́á imónɨŋáonɨ nánɨ go níwapɨyinɨŋoɨ?’ rɨnɨ́áyo joxɨ yumɨ́í wirɨ ámá ‘Nionɨ niaíwonɨ́nɨŋɨ́ nimónɨrɨ majɨ́á imónɨŋáonɨ nánɨ ananɨ níwapɨyiɨ.’ rɨnɨ́áyo joxɨ wɨ́á rókiamorɨ yarɨŋoxɨ eŋagɨ nánɨ seáyɨ e rɨmearɨŋɨnɨ. Ápe, joxɨ ‘E oemɨnɨ.’ simónarɨŋagɨ nánɨ rarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","re rɨŋɨnigɨnɨ, “Gɨ́ ápo amɨpí xwɨ́á rɨrímɨ nɨrímɨnɨ yanɨ́wá nánɨ ɨ́ánɨŋɨ́ niepɨ́xɨ́niasiŋɨ́rɨnɨ. Ámá wo Gorɨxomɨ xewaxo nánɨ xɨxenɨ nɨjɨ́á mimónɨnɨ. Gɨ́ áponɨ xɨxenɨ nɨjɨ́á imónɨnɨ. Ámá wo ápo nánɨ enɨ nɨjɨ́á mimónɨnɨ. Xewaxonɨnɨ nɨjɨ́árɨnɨ. Ámá ‘Xewaxonɨ gɨ́ ápo nánɨ wɨ́á orókiamómɨnɨ.’ yaiwíɨ́áyɨ́, ayɨ́ enɨ gɨ́ ápo nánɨ nɨjɨ́á imónɨŋoɨ.” nɨrɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","nɨkɨnɨmónɨrɨ xegɨ́ wiepɨsarɨŋowa wigɨ́pɨ ŋweaŋagɨ́a sɨŋwɨ́ nɨwɨnɨrɨ awamɨnɨ re urɨŋɨnigɨnɨ, “Amɨpí nionɨ erɨ xwɨyɨ́á rɨrɨ yarɨŋápɨ soyɨ́né sɨŋwɨ́ nanayíɨ́ápɨ nánɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ yayɨ́ seáyɨ e dánɨ seainɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gorɨxoyá wɨ́á rókiamoagɨ́á obaxɨ́yɨ́ tɨ́nɨ mɨxɨ́ ináyɨ́yɨ́ tɨ́nɨ amɨpí soyɨ́né sɨŋwɨ́ nanarɨgɨ́ápɨ ‘Sɨŋwɨ́ owɨnaneyɨ.’ nɨrɨro aiwɨ wí sɨŋwɨ́ mɨwɨnɨpa ero amɨpí soyɨ́né arɨ́á niarɨgɨ́ápɨ ‘Arɨ́á owianeyɨ.’ nɨrɨro aiwɨ wí arɨ́á mɨwipa ero yagɨ́árɨnɨ. Ayɨnánɨ soyɨ́né yayɨ́ seáyɨmɨ dánɨ seainɨpaxɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ámá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wo “Jisaso eŋɨ́ eánɨŋorɨ́anɨ? Iwamɨ́ó owíwapɨyimɨnɨ.” nɨyaiwirɨ nɨwiápɨ́nɨmearɨ re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, nionɨ arɨre nerɨ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́ŋáonɨ imónɨmɨ́árɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisaso re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ arɨre nɨrɨnɨrɨ eánɨnɨ? Joxɨ ɨ́á nɨrorɨ́ná arɨre rɨnɨŋagɨ roarɨŋɨ́rɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","o re urɨŋɨnigɨnɨ, “Re nɨrɨnɨrɨ eánɨnɨ, ‘Joxɨ dɨxɨ́ Ámɨná Gorɨxomɨ dɨŋɨ́ sɨxɨ́ nuyirɨ nerɨ́ná dɨxɨ́ xwioxɨ́ o nánɨ yayɨ́ osinɨnɨrɨ erɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ tɨ́nɨ xɨ́dɨrɨ dɨŋɨ́ tɨ́nɨ píránɨŋɨ́ wɨkwɨ́rorɨ éɨrɨxɨnɨ. Jɨwanɨŋoxɨ dɨŋɨ́ sɨpí inarɨŋɨ́pa ámá joxɨ tɨ́nɨ ŋweagɨ́áyɨ́ nánɨ enɨ axɨ́pɨ sinɨ́wɨnɨgɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ xɨxenɨ rarɨŋɨnɨ. E nerɨ́náyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́ŋoxɨ nimónɨrɨ anɨŋɨ́ ŋwearɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ meweŋo ámá nɨ́nɨ xewanɨŋo nánɨ re oyaiwípoyɨnɨrɨ “O ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ ámá xɨ́o tɨ́nɨ ŋweagɨ́áyɨ́ nánɨ dɨŋɨ́ sɨpí nɨwirɨ arɨrá wiarɨŋorɨ́anɨ?” oyaiwípoyɨnɨrɨ ámɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Ámá nionɨ tɨ́nɨ nawínɨ ŋweaŋwáyɨ́ gɨyɨ́rɨ́anɨ? Ámá gɨyɨ́ nánɨ niɨwanɨŋonɨ dɨŋɨ́ sɨpí inarɨŋápa dɨŋɨ́ sɨpí axɨ́pɨ e ninɨŋoɨ?” Yarɨŋɨ́ e wíáná ");
INSERT INTO aak_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisaso ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo aŋɨ́ yoɨ́ Jerusaremɨyɨ pɨ́nɨ nɨwiárɨmɨ aŋɨ́ yoɨ́ Jerikoyɨ rɨnɨŋɨ́yo nánɨ wearɨ́ná re eŋɨnigɨnɨ. Ámá ámáyá amɨpí ɨ́wɨ́ oxaurápaneyɨnɨro yarɨgɨ́á wa omɨ ɨ́á nɨxero xegɨ́ rapɨrapɨ́ wirɨro iwaŋɨ́ mépero rɨxa napénɨmearɨ́ná pɨ́nɨ nɨwiárɨmɨ ugɨ́awixɨnɨ. Rɨxa numáná eŋáná ");
INSERT INTO aak_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","apaxɨ́pánɨŋɨ́ imónɨŋɨ́ wo enɨ óɨ́ axɨ́yimɨ nɨwerɨ́ná wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Iwaŋɨ́ mépéɨ́o daiwo weŋagɨ nɨwɨnɨrɨ arɨrá bɨ mɨwí orɨwámɨ dánɨ múroŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ámɨ Judayɨ́ wigɨ́ yoɨ́ Ripaiyɨ rɨnɨgɨ́áyɨ́ wo —Ripaiyɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ arɨrá wiarɨgɨ́áyɨ́rɨnɨ. Ripaiyɨ rɨnɨgɨ́á wo iwaŋɨ́ mépéɨ́o weŋe nɨrémorɨ nɨwɨnɨrɨ aiwɨ o enɨ orɨwámɨ dánɨ múroŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","E nerɨ aiwɨ ámá Samariayɨ́ wo —Samariayɨ́ tɨ́nɨ Judayɨ́ tɨ́nɨ eŋíná dánɨ xepɨxepá rónagɨ́árɨnɨ. Samariao enɨ aŋɨ́ wíyo nánɨ nurɨ́ná wɨnɨŋɨnigɨnɨ. Ámá iwaŋɨ́ nearɨ tɨ́o riwo weŋagɨ nɨwɨnɨrɨ omɨ wa nɨwianɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aŋwɨ e nurɨ iniɨgɨ́ wainɨ́ bɨ tɨ́nɨ ranɨ́ bɨ tɨ́nɨ iwaŋɨ́ weáɨ́áyo gɨ́niɨ́ wirɨ wɨ́á utɨrɨ nemáná nɨmɨ́eyoarɨ xegɨ́ dogíyo seáyɨ e nɨŋwɨrárɨrɨ nɨmeámɨ aŋɨ́ ámá amɨ amɨ dánɨ nɨbɨrɨ wéɨ́rɨxɨnɨrɨ mɨrɨnɨŋɨ́ wiwámɨ nánɨ nurɨ e meweŋo ");
INSERT INTO aak_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","wɨ́ápɨ tɨ́nɨ íkwɨ́ wɨnɨ́xaú nɨroarɨ aŋiwámɨ mearɨŋomɨ nɨwirɨ re urɨŋɨnigɨnɨ, ‘Ámá romɨ nɨgwɨ́ rɨnamɨ dánɨ píránɨŋɨ́ méɨrɨxɨnɨ. Rɨna anɨpá imónáná o nánɨ joxɨ dɨxɨ́ nɨgwɨ́ xwɨrɨ́á ikɨxéánáyɨ́ ámɨ nionɨ nɨbɨrɨ́ná nionɨyá xɨxenɨ mɨnɨ siapɨmɨ́árɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á apɨ nurɨmáná ");
INSERT INTO aak_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ meweŋomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Joxɨ dɨŋɨ́ arɨre yaiwiarɨŋɨnɨ? Iwaŋɨ́ nearɨ tɨ́omɨ ámá waú wo nɨwɨnɨro aí awa go o tɨ́nɨ ŋweagɨ́á wónɨŋɨ́ nimónɨrɨ arɨrá wiŋɨnigɨnɨ?” uráná ");
INSERT INTO aak_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ meweŋomɨ re urɨŋɨnigɨnɨ, “ ‘Ámá nɨwɨnɨrɨ́ná wa nɨwianɨrɨ naŋɨ́ wiiŋo o tɨ́nɨ ŋweagɨ́á wónɨŋɨ́ imónɨŋɨnigɨnɨ.’ nimónarɨnɨ.” urɨ́agɨ Jisaso “Joxɨ enɨ nurɨ axɨ́pɨ e néra úɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisaso wiepɨsarɨŋɨ́yɨ́ tɨ́nɨ óɨ́yo nuróná aŋɨ́ bimɨ rémóáná apɨxɨ́ wí Mataíyɨ rɨnɨŋí aiwá míraŋɨ́ winɨ xegɨ́ aŋɨ́yo nánɨ nɨwirɨmeámɨ nurɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","í xegɨ́ xexɨrɨ́meáí Mariaíyɨ rɨnɨŋí nɨbɨrɨ Jisasoyá sɨkwɨ́ tɨ́ŋɨ́ e nɨŋweámáná oyá pɨ́né arɨ́á wiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mataí aiwá rɨyamɨ́ emɨnɨrɨ yarɨ́ná upupɨ́gɨ́ winarɨŋagɨ nɨbɨrɨ Jisasomɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, niínɨ aiwá rɨyamɨ́ yarɨ́ná gɨ́ nɨrɨxɨ́meáí pɨ́nɨ nɨnɨwiárɨmɨ nɨbɨrɨ ‘Ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋɨnɨ? Í saŋɨ́ nɨrápɨnɨ nánɨ urowárénapeɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ámɨnáo re urɨŋɨnigɨnɨ, “Mataíxɨ, Mataíxɨ, jíxɨ dɨŋɨ́ obɨbaxɨ́ morɨ amɨpí obaxɨ́ nánɨ ayá sɨ́wɨ́ rɨrorɨ yarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","E nerɨ aí jíxɨ anɨŋɨ́ minɨ́ epaxɨ́ imónɨŋɨ́yɨ́ obaxɨ́manɨ. Aga ná bɨnɨrɨnɨ. Mariaí apɨ nánɨ dɨŋɨ́ neyírorɨ arɨ́á niarɨnɨ. Í dɨŋɨ́ eyíroarɨŋɨ́pɨ mɨdɨdɨ́ mɨwikɨxepa nerɨ jíxɨ nɨrɨ́ɨ́pɨ bɨ urɨmɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jisaso wí e nurɨ rɨxa Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwimáná eŋáná xegɨ́ wiepɨsarɨŋɨ́yɨ́ wo re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, Jono wayɨ́ nɨneameaia wago xegɨ́ wiepɨsarɨŋowamɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wipɨ́rɨ nánɨ uréwapɨyiŋɨ́pa joxɨ enɨ e nearéwapɨyiɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","o awamɨ re urɨŋɨnigɨnɨ, “Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná re urɨ́ɨ́rɨxɨnɨ, ‘Ápoxɨnɨ, “Ámá nɨ́nɨ joxɨnɨ ŋwɨ́áoxɨ eŋagɨ nánɨ wéyo rɨméɨ́rɨxɨnɨ.” neaimónarɨnɨ. “Joxɨ xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋwearɨ́ápɨ sɨŋánɨ imónɨ́wɨnɨgɨnɨ.” neaimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nene aiwá sɨ́á ayɨ́ ayimɨ nanɨ́wá nánɨ neaiayíɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ámá nene ɨ́wɨ́ neaíɨ́áyo yokwarɨmɨ́ wiíagwɨ nánɨ joxɨ nene ɨ́wɨ́ yarɨŋwáyɨ́ yokwarɨmɨ́ neaiíɨrɨxɨnɨ. Ámá wí eŋɨ́ eánɨgɨ́áyɨ́rɨ́anɨrɨ iwamɨ́ó owíwapɨyípoyɨnɨrɨ sɨŋwɨ́ mɨneanɨpa éɨrɨxɨnɨ.’ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná e urɨ́ɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","E nurɨmáná ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Soyɨ́né woxɨ dɨxɨ́ ámá aŋɨ́ wí e dáŋɨ́ wo árɨwegɨ́yo símeááná aiwá meŋagɨ nánɨ joxɨ ámá nɨkumɨxɨnɨrɨ emearɨgɨ́áyɨ́ womɨ nurɨ aiwá nánɨ rɨxɨŋɨ́ nurɨrɨ́ná re urɨrɨ́ɨnɨ, ‘Gɨ́ ámá aŋɨ́ wí e dáŋɨ́ wo aŋɨ́ wíyo nánɨ únɨ́o rɨxa árɨwegɨ́ ríná nímeáagɨ omɨ aiwá bɨ mɨnɨ wimɨ nánɨ meŋagɨ nánɨ joxɨ tɨ́e nánɨ rɨxɨŋɨ́ barɨŋɨnɨ. Aiwá biaú bɨ nɨnɨmeairɨréɨnɨ?’ uráná aŋɨ́yo ínɨmɨ dánɨ, sá weŋɨ́mɨ dánɨ re rɨrɨnɨŋoɨ, ‘Aiwá nánɨ ayá wí mɨnɨrɨŋweapanɨ. Aŋɨ́ ówaŋɨ́ nɨyárɨmáná niaíwɨ́pia tɨ́nɨ íkwiaŋwɨ́yo rɨxa sá weŋwɨnɨ. Nionɨ wí nɨwiápɨ́nɨmearɨ aiwá rɨmeaipaxɨ́ menɨnɨ.’ rɨrɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nionɨ re seararɨŋɨnɨ, ‘Aŋɨ́ xiáwo aiwá nánɨ rɨxɨŋɨ́ bɨ́o xegɨ́ nɨkumɨxɨnɨrɨ emearɨŋɨ́ wo aiwɨ nɨwiápɨ́nɨmearɨ xɨ́o rɨxɨŋɨ́ urarɨŋɨ́yɨ́ umeaipaxɨ́manɨ. E nerɨ aiwɨ arɨ́kí rɨxɨŋɨ́ urayarɨ́ná nɨwiápɨ́nɨmearɨ xɨ́o wimónarɨŋɨ́pɨ nɨpɨnɨ mɨnɨ winɨgɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ayɨnánɨ nionɨ re seararɨŋɨnɨ, ‘Soyɨ́né Gorɨxomɨ amɨpí wí nánɨ yarɨŋɨ́ wíáná o ananɨ mɨnɨ seaiapɨnɨ́árɨnɨ. Rɨxɨŋɨ́ nurɨrɨ́ná amɨpí wí o tɨ́ŋɨ́ e nánɨ pɨ́á nerɨ́nánɨŋɨ́ ananɨ meapɨ́rɨ́árɨnɨ. Rɨxɨŋɨ́ nurɨrɨ́ná wáɨ́ e nɨrómáná wakwɨ́ óránánɨŋɨ́ o ananɨ arɨ́á nɨsirɨ aŋɨ́ ówaŋɨ́nɨŋɨ́ rɨ́kwiinɨgɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá nɨ́nɨ Gorɨxomɨ rɨxɨŋɨ́ urayarɨ́náyɨ́ ayɨ́ ananɨ wí meapɨ́rɨ́árɨnɨ. Ámá gɨyɨ́ amɨpí wí nánɨ pɨ́á nerɨ́ná ananɨ meapɨ́rɨ́árɨnɨ. Gɨyɨ́ wáɨ́ e dánɨ wakwɨ́ óráná o ananɨ aŋɨ́ ówaŋɨ́ wɨ́kwiinɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ápoyɨ́né woxɨ dɨxɨ́ íwo nɨbɨrɨ peyɨ́ nánɨ rɨxɨŋɨ́ rɨránáyɨ́, weaxɨ́á nɨmearɨ wirɨréɨnɨ? Oweoɨ, wí e wirɨméɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iŋɨ́ kímɨŋɨ́ nánɨ enɨ rɨxɨŋɨ́ rɨránáyɨ́, wáré nɨmearɨ wirɨréɨnɨ? Oweoɨ, e enɨ nɨmearɨ wirɨméɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Soyɨ́né ɨ́wɨ́ néra warɨgɨ́oyɨ́né aiwɨ segɨ́ niaíwɨ́ rɨxɨŋɨ́ searánáyɨ́, ananɨ amɨpí awiaxɨ́yɨ́ anɨpá mɨnɨ wiarɨgɨ́oyɨ́nérɨnɨ. E nerɨ aí segɨ́ ápo aŋɨ́namɨ ŋweaŋo aŋɨpaxɨ́rɨnɨ. ‘Omɨ gɨyɨ́ gɨyɨ́ rɨxɨŋɨ́ uránáyɨ́, kwíyɨ́ oyápɨ aí ananɨ mɨnɨ winɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisaso, imɨ́ó maŋɨ́ pɨ́rónɨŋɨ́ womɨ —O ámá womɨ dɨŋɨ́ xɨxéroarɨŋagɨ nánɨ ámáo enɨ maŋɨ́ pɨ́rónɨŋorɨnɨ. Imɨ́omɨ mɨxɨ́ umáɨnowáráná imɨ́o éɨ́ úáná ámá maŋɨ́ pɨ́rónɨŋo ámɨ pɨ́né rɨŋɨnigɨnɨ. Ámɨ pɨ́né rarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ámá e epɨ́royɨ́ egɨ́áyɨ́ sɨŋwɨ́ e nɨwɨnɨro ududɨ́ nero aí ");
INSERT INTO aak_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ámá wí re rɨgɨ́awixɨnɨ, “O imɨ́ó mɨxɨ́ numáɨnowárɨrɨ́ná imɨ́ó xɨráónɨŋɨ́ imónɨŋo —O xegɨ́ yoɨ́ bɨ Bieseburoyɨ rɨnɨŋorɨnɨ. Oborɨnɨ. O eŋɨ́ weámɨxowárɨ́agɨ nánɨ eŋɨ́ eánɨŋɨ́ oyá tɨ́nɨ umáɨnowárarɨŋɨ́rɨnɨ.” rarɨ́ná ámá ámɨ wí “Jisaso eŋɨ́ eánɨŋorɨ́anɨ? Iwamɨ́ó owíwapɨyaneyɨ.” nɨrɨnɨro nɨbɨro re urɨgɨ́awixɨnɨ, “Aŋɨ́namɨ dánɨ emɨmɨ́ bɨ iwamɨ́ó neaíwapɨyiɨ.” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","o wigɨ́ yaiwigɨ́á nánɨ adadɨ́ nɨwirɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Ámá gwɨ́ axɨ́rí xepɨxepá nɨrónɨro mɨxɨ́ ninɨrónáyɨ́, ayɨ́ aŋɨ́ mɨwiárekɨxɨnɨpaxɨ́rɨnɨ. Ámá xɨráxogwáowa enɨ xepɨxepá nɨrónɨro mɨxɨ́ ninɨrɨ́náyɨ́, ayɨ́ enɨ aŋɨ́ mɨwiárekɨxɨnɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ayɨnánɨ Seteno tɨ́nɨ xegɨ́ imɨ́ó axɨ́yɨ́ tɨ́nɨ xepɨxepá nɨrónɨro mɨxɨ́ ninɨrónáyɨ́, arɨge nero eŋɨ́ neánɨrɨ ropɨ́ráoɨ? Oweoɨ! E nerɨ aiwɨ seyɨ́né ‘Eŋɨ́ eánɨŋɨ́ Bieseburoyá tɨ́nɨ imɨ́ó mɨxɨ́ umáɨnowárarɨŋɨnɨ.’ nɨrarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nionɨ nepa Bieseburoyá eŋɨ́ eánɨŋɨ́ tɨ́nɨ imɨ́ó mɨxɨ́ numáɨnowárɨrɨ sɨŋwɨrɨyɨ́, segɨ́ ámá eŋɨ́ eánɨŋɨ́ goyá tɨ́nɨ mɨxɨ́ umáɨnowárarɨgɨ́árɨnɨ? Segɨ́ ámá imɨ́ó mɨxɨ́ umáɨnowárarɨgɨ́áwa sɨ́á yoparɨ́yimɨ nɨwiápɨ́nɨmearo yarɨŋɨ́ re seaipɨ́rɨ́árɨnɨ, ‘Nene ámá wo imɨ́ó mɨxɨ́ umáɨnowárarɨŋagɨ nɨwɨnɨrane “Eŋɨ́ eánɨŋɨ́ Gorɨxoyá tɨ́nɨ e yarɨnɨ.” rɨnarɨŋwá eŋagɨ nánɨ seyɨ́né pí nánɨ Jisaso axɨ́pɨ yarɨŋagɨ nɨwɨnɨrɨ́ná xwɨyɨ́á nɨmearɨro “Eŋɨ́ eánɨŋɨ́ oboyá tɨ́nɨ yarɨŋɨnɨ.” urɨgɨ́awixɨnɨ?’ Yarɨŋɨ́ e seaipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nionɨ eŋɨ́ eánɨŋɨ́ Gorɨxoyá tɨ́nɨ imɨ́ó mɨxɨ́ umáɨnowárarɨŋagɨ aí seyɨ́né ‘Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ rɨxa rimónɨnɨ?’ mɨyaiwiarɨŋoɨ. ‘Ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ urowárénapɨnɨ́o, arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo rɨxa nene tɨ́nɨ rimónɨŋwɨnɨ?’ mɨyaiwiarɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ewayɨ́ xwɨyɨ́á ámɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Ámá eŋɨ́ rɨŋɨ́ wo éwaikɨ́ oxá nayirɨ nɨtɨrɨ awí meŋweaŋáná ámá wo xegɨ́ aŋɨ́yo nɨpáwirɨ amɨpí wí ɨ́wɨ́ meapaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","E nerɨ aí ámá eŋɨ́ rɨŋomɨ nɨmúrorɨ omɨ seáyɨ e imónɨŋɨ́ wo nɨbɨrɨ mɨxɨ́ wimɨnɨrɨ nerɨ́ná xopɨrárɨ́ nɨwirɨ amɨpí nɨ́nɨ mɨxɨ́ nánɨ maxɨrɨŋɨ́yɨ́ nurápɨmáná amɨpí oyá nɨ́nɨ enɨ rɨxa nurápɨrɨ yaŋɨ́ nɨwia warɨŋɨ́rɨnɨ.” Jisaso eŋɨ́ eánɨŋɨ́ xɨ́oyá oboyápimɨ múroŋagɨ nánɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ámá wí ámáyɨ́ nɨ́nɨ Jisasomɨ dɨŋɨ́ wɨkwɨ́roro xɨ́dɨro epɨ́rɨxɨnɨrɨ pɨ́rɨ́ rakiámɨ́ wianɨro yarɨgɨ́áyɨ́ nánɨ ewayɨ́ xwɨyɨ́á ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá nionɨ tɨ́ámɨnɨ mimónɨgɨ́áyɨ́, ayɨ́ nionɨ tɨ́nɨ mɨxɨ́ imónɨŋwáyɨ́rɨnɨ. Ámá nionɨ tɨ́nɨ sipɨsipɨ́ awí meaárɨpa yarɨgɨ́áyɨ́, ayɨ́ sipɨsipɨ́ xɨ́dɨ́xɨ́dowárɨ́ yarɨgɨ́áyɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ámá ayɨ́ “Nene Jono nearáná sanɨŋɨ́ onɨmiápɨ nerane aiwɨ imɨ́ó xɨxéroarɨŋɨ́ rónɨŋɨ́ imónanɨgɨnɨ.” oyaiwípoyɨnɨrɨ ámɨ xɨxewisɨ́ ikaxɨ́ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Imɨ́ó xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowáráná ámá womɨ pɨ́nɨ nɨwiárɨmɨ nurɨ́ná iniɨgɨ́ mayɨ́mɨ ge ge sá oŋweámɨnɨrɨ nemerɨ pɨ́á nɨmegɨnɨméɨsáná re yaiwiárɨŋɨ́rɨnɨ, ‘Gɨ́ ámɨ aŋɨ́ axɨ́ pɨ́nɨ nɨwiárɨmɨ bɨŋaé nánɨ oumɨnɨ.’ nɨyaiwimɨ ");
INSERT INTO aak_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","nurɨ aŋɨ́ rɨxa síɨ́ peárɨnɨrɨ píránɨŋɨ́ imɨxárɨnɨrɨ yárɨnɨŋagɨ nɨwɨnɨrɨ sɨnɨ anɨ́á imónɨŋagɨ nɨwɨnɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ámɨ nurɨ imɨ́ó wé wɨ́úmɨ dáŋɨ́ waú ɨ́wɨ́ neróná xɨ́omɨ seáyɨ e múroro egɨ́áyo nɨwirɨmeámɨ nuro axomɨ nɨxɨxéroro e ŋweaarɨgɨ́árɨnɨ. Xámɨ sɨpí imónago aí ínáyɨ́ aga sɨpí ikeamónɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Xwɨyɨ́á apɨ urarɨ́ná apɨxɨ́ wí ámá e epɨ́royɨ́ egɨ́áyo dánɨ rɨ́aiwá re urɨŋɨnigɨnɨ, “Apɨxɨ́ joxɨ nɨrɨxɨrɨrɨ amɨŋɨ́ siapɨŋí Gorɨxoyá dɨŋɨ́ tɨ́nɨ yayɨ́ winɨpaxɨ́rɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","o re urɨŋɨnigɨnɨ, “E wí nɨyaiwirɨ mɨrɨpanɨ. Ámá gɨyɨ́ gɨyɨ́ xwɨyɨ́á Gorɨxoyá arɨ́á wiro axɨ́pɨ ero yarɨgɨ́áyɨ́ ámá ayɨ́nɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ yayɨ́ winɨpaxɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ámá obaxɨ́ Jisaso tɨ́ŋɨ́ e epɨ́royɨ́ eŋáná sɨnɨ wínɨ wínɨ epɨ́royɨ́ yarɨŋagɨ́a o re urɨŋɨnigɨnɨ, “Isɨrerɨyɨ́né, agwɨ ŋweagɨ́áyɨ́né ɨ́wɨ́ néra nuro arɨ́kí yarɨgɨ́áyɨ́né, emɨmɨ́ nánɨ seaimónarɨŋagɨ aiwɨ nionɨ emɨmɨ́ wí mɨseaíwapɨyipa nerɨ aiwɨ ná bɨnɨ Gorɨxoyá wɨ́á rókiamoagɨ́ Jonao yagɨ́pɨnɨ seaíwapɨyimɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Eŋíná Gorɨxoyá wɨ́á rókiamoagɨ́ Jonaoyɨ rɨnɨŋo —O sɨ́á wɨyaú wɨyi pɨyɨ́nɨŋɨ́ nimónɨrɨ peyɨ́ agwɨ́yo weagorɨnɨ. O ámá aŋɨ́ yoɨ́ Ninipayɨ rɨnɨŋɨ́yo ŋweaagɨ́áyo Gorɨxoyá sɨ́mɨmajɨ́ónɨŋɨ́ wiiŋɨ́pa ámá imónɨŋáonɨ ámá agwɨ ŋweagɨ́áyɨ́né Gorɨxoyá sɨ́mɨmajɨ́onɨ́nɨŋɨ́ seainɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ apɨxɨ́ eŋíná Sibayɨ́ aŋɨ́yo meŋweaagí —Í mɨxɨ́ ináyɨ́ Soromono nɨjɨ́á seáyɨ e nimónɨrɨ rɨrɨmɨ́ yarɨ́ná arɨ́á wimɨnɨrɨ nánɨ aŋɨ́ aga ná jɨ́amɨ dánɨ bɨŋírɨnɨ. Í ámá wonɨ Soromonomɨ seáyɨ e imónɨŋáonɨ re éɨ́ nɨrómáná seararɨŋagɨ aiwɨ seyɨ́né arɨ́á mɨniarɨŋagɨ́a nánɨ í sɨ́á ayimɨ nɨwiápɨ́nɨmearɨ xwɨyɨ́á seameárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ámá eŋíná aŋɨ́ yoɨ́ Ninipayɨ rɨnɨŋɨ́yo ŋweaagɨ́áyɨ́ —Ayɨ́ Gorɨxoyá wɨ́á rókiamoagɨ́ Jonao Gorɨxoyá xwɨyɨ́á wáɨ́ urɨméáná ayɨ́ wigɨ́ ɨ́wɨ́ egɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweaagɨ́áyɨ́rɨnɨ. Ayɨ́ ámá wo Jonaomɨ seáyɨ e imónɨŋáonɨ re éɨ́ nɨrómáná seararɨŋagɨ aiwɨ seyɨ́né arɨ́á mɨniarɨŋagɨ́a nánɨ ámá ayɨ́ sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ nɨwiápɨ́nɨmearo xwɨyɨ́á seameárɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","O xwɨyɨ́á Gorɨxoyá ramɨxɨ́nɨŋɨ́ imónɨŋagɨ nánɨ re rɨŋɨnigɨnɨ, “Ámá wo ramɨxɨ́ nɨmɨxárómáná aŋɨ́ sakwímaŋɨ́yo tarɨŋɨ́manɨ. Sɨxɨ́ wá nɨmearɨ upɨkákwiárarɨŋɨ́manɨ. Nɨmɨxárómáná ámá ɨ́wiapɨ́á gɨyɨ́ gɨyɨ́ wɨ́á ónɨŋagɨ sɨŋwɨ́ wɨnɨpɨ́rɨ nánɨ íkwiaŋwɨ́yo seáyɨ e ikwiárarɨŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","re urɨŋɨnigɨnɨ, “Segɨ́ sɨŋwɨ́ enɨ uyɨ́wɨ́nɨŋɨ́ imónɨnɨ. Segɨ́ sɨŋwɨ́ tɨ́nɨ píránɨŋɨ́ nanɨro wé rónɨŋɨ́ nerónáyɨ́, dɨŋɨ́ naŋɨ́nɨ aumaúmɨ́ ninɨro segɨ́ xwioxɨ́yo wɨ́ánɨŋɨ́ ókímɨxɨnarɨŋoɨ. E nerɨ aiwɨ segɨ́ sɨŋwɨ́ tɨ́nɨ ɨ́wɨ́ nánɨ nanɨróná segɨ́ xwioxɨ́yo sɨ́ánɨŋɨ́ yimɨxɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dɨŋɨ́ naŋɨ́nɨ aumaúmɨ́ ninɨro segɨ́ xwioxɨ́ wɨ́ánɨŋɨ́ seaókiarɨŋɨ́pɨ supɨkínɨnɨgɨnɨrɨ dɨŋɨ́ tɨ́nɨ éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Segɨ́ xwioxɨ́yo sɨ́á wí mɨyinɨ́ wɨ́ánɨ nókiárɨrɨ́ná uyɨ́wɨ́ wɨ́á seaókiarɨŋɨ́pánɨŋɨ́ segɨ́ xwioxɨ́ nɨ́nɨ wɨ́á seaókiárɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","E nurɨ́ɨsáná eŋáná Parisi wo “Gɨ́ aŋɨ́yo aiwá onaiyɨ.” nurɨrɨ nipemeámɨ úáná Jisaso nurɨ aiwá nɨpɨ́re éɨ́ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisio Jisaso xámɨ wé piaxɨ́nɨŋɨ́ eaŋɨ́ nánɨ wigɨ́ yarɨgɨ́ápa wé iniɨgɨ́yo igwɨ́á mɨwíró aiwá nɨpɨ́re éɨ́ ŋweaŋagɨ nɨwɨnɨrɨ ududɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisaso re urɨŋɨnigɨnɨ, “Parisioyɨ́né ɨ́wɨ́ mearo rɨ́á kɨroro yanɨro moarɨgɨ́ápɨ segɨ́ xwioxɨ́yo sɨnɨ magwɨ́ eŋáná kapɨxɨ́ tɨ́nɨ pɨrerɨxɨ́ tɨ́nɨ igɨ́á nearɨ́nánɨŋɨ́ kíyɨ́ bɨ́arɨwámɨ dánɨnɨ kwɨ́rɨnarɨgɨ́oyɨ́néxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Majɨmajɨ́á ikárɨnarɨgɨ́oyɨ́né ‘Bɨ́arɨwámɨnɨ imɨxarɨŋo ínɨrɨwámɨnɨ mimɨxɨŋɨ́rɨnɨ.’ rɨyaiwiarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Amɨpí soyɨ́né ɨ́á xɨrɨgɨ́ápɨ ámá uyípeayɨ́yo ayá nurɨmɨxɨro arɨrá nɨwiro mɨnɨ wíánáyɨ́, soyɨ́né igɨ́á neánɨrónɨŋɨ́ imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Parisioyɨ́né aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaikárɨnɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí oseainɨnɨ. Soyɨ́né aiwá nɨmiróná anɨŋɨ́ minɨ́ yíyɨ́ tɨ́nɨ aɨ́ tɨ́nɨ siyó amɨpí píránɨŋɨ́ ɨ́á nɨroro rɨxa wé wúkaú imónáná wo Gorɨxomɨ mɨnɨ nɨwiro aí ámáyo wé rónɨŋɨ́ wiarɨgɨ́áyɨ́ pɨ́nɨ wiárɨro Gorɨxomɨ dɨŋɨ́ sɨxɨ́ muyipa ero yarɨgɨ́oyɨ́néxɨnɨ. Soyɨ́né aiwá onɨmiápia aí segɨ́ anɨŋɨ́ minɨ́ yarɨgɨ́á jɨ́apɨ pɨ́nɨ mɨwiárɨpa ero ámáyo naŋɨ́ mimɨxɨpa yarɨgɨ́ápɨ enɨ ero nerɨ sɨŋwɨrɨyɨ́, naŋɨ́ imónɨmɨnɨrɨ eŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisioyɨ́né aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Soyɨ́né rotú aŋɨ́yo ámá sɨŋwɨ́ oneanɨ́poyɨnɨrɨ sɨ́mɨ́ sɨ́mɨ́ e ŋwearo makerɨ́áyo awí eánarɨgɨ́e ámá yayɨ́ ‘Ámɨnáoxɨnɨ.’ onearɨ́poyɨnɨrɨ emero ‘Oyaneyɨ.’ seaimónarɨŋagɨ nánɨ Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ámá nɨ́nɨ Parisiowamɨ nɨwɨnɨrɨ́ná “Naŋowarɨnɨ.” yaiwiarɨŋagɨ́a nɨwɨnɨrɨ awa wigɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ ámá pɨyɨ́ xwárɨpáyo ínɨmɨ weŋɨ́ yapɨ imónɨŋagɨ nánɨ re urɨŋɨnigɨnɨ, “Aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Soyɨ́né ámá pɨyɨ́ tɨgɨ́e xwɨ́á emadɨrónɨŋáná ámá ‘Ámá pɨyɨ́ tɨgɨ́erɨ́anɨ?’ mɨyaiwí maiwí pwarɨgɨ́énɨŋɨ́ imónɨgɨ́oyɨ́nérɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́á wo nɨwiápɨ́nɨmearɨ re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, Parisiowamɨ e nurɨrɨ́ná none enɨ ikayɨ́wɨ́ neameararɨŋɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisaso ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa ámáyo anɨŋɨ́ minɨ́ sekaxɨ́ “E éɨ́rɨxɨnɨ. E éɨ́rɨxɨnɨ.” nurɨro aí wiwanɨŋowa wí mɨyarɨgɨ́á eŋagɨ nánɨ re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́oyɨ́né enɨ aweyɨ! Sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Soyɨ́né ámáyo saŋɨ́ xwé ayá wí nɨwikwiárɨro aí sewanɨŋoyɨ́né saŋɨ́ xwé apɨ iwamɨ́ó mɨmɨ́eyoarɨgɨ́oyɨ́né eŋagɨ nánɨ Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Soyɨ́né Gorɨxoyá wɨ́á rókiamoagɨ́áwamɨ segɨ́ arɨ́owa pɨkiárɨgɨ́áyo xwárɨpáyo anɨŋɨ́ minɨ́ mɨ́á imɨxarɨgɨ́oyɨ́néxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Soyɨ́né e nerɨŋɨ́pimɨ dánɨ ámáyo áwaŋɨ́ rénɨŋɨ́ urarɨŋoɨ, ‘Negɨ́ arɨ́owa Gorɨxoyá wɨ́á rókiamoagɨ́áwamɨ nɨpɨkiárɨróná apánɨ yagɨ́á eŋagɨ nánɨ wigɨ́ xwárɨpáyo mɨ́á imɨxarɨŋwɨnɨ.’ Énɨŋɨ́ urarɨŋagɨ́a nánɨ Gorɨxo xeanɨŋɨ́ seaikárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ayɨnánɨ Gorɨxo dɨŋɨ́ neŋwɨperɨ soyɨ́né nánɨ xɨxenɨ re rɨŋɨnigɨnɨ, ‘Nionɨ wɨ́á rókiamoarɨgɨ́á wamɨ tɨ́nɨ xwɨyɨ́á wáɨ́ urɨmearɨgɨ́á wamɨ tɨ́nɨ urowáráná ayɨ́ wíyo pɨpɨkímɨ́ ero wíyo mɨxɨ́ xɨ́dowárapɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wɨ́á rókiamoagɨ́á nɨyonɨ nionɨ aŋɨ́na imɨxɨrɨ xwɨ́á imɨxɨrɨ eŋíná e eŋaé dánɨ nɨpɨkía bɨ́agɨ́a nánɨ ámá agwɨ ŋweagɨ́áyɨ́né nionɨ eŋɨ́ seameámɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aiborɨ́omɨ xámɨ xɨráo Keno pɨkiŋe dánɨ nɨpɨkía nɨbɨ́asáná yoparɨ́ nionɨyá wɨ́á rókiamoagɨ́ Sekaraiaomɨ pɨkigɨ́awixɨnɨ. Omɨ nionɨ nánɨ íkwiaŋwɨ́ rɨdɨyowá yanɨro ikwɨkwiárɨmɨ́ yarɨgɨ́e mɨdánɨ eŋáná gɨ́ aŋɨ́ awawá “Ŋwɨ́árɨnɨ.” rɨnɨŋe mɨdánɨ eŋáná áwɨnɨmɨ e pɨkigɨ́orɨnɨ. Omɨ pɨkigɨ́e nánɨ oxɨ́ apɨxɨ́ agwɨ ŋweagɨ́á tɨyɨ́né nionɨ eŋɨ́ seameámɨ́árɨnɨ.’ Gorɨxo e rɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa ámáyo Gorɨxo “Oépoyɨ.” wimónarɨŋɨ́pɨ mɨmɨwiaíkɨ́ wiarɨŋagɨ́a nánɨ xɨxewisɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́oyɨ́né aweyɨ! Soyɨ́né amɨpí Gorɨxo ‘Ámáyo owíwapɨyípoyɨ.’ wimónarɨŋɨ́pɨ mɨwíwapɨyipa yarɨŋagɨ́a nánɨ sɨ́á wɨyi soyɨ́né majɨ́á seaórɨnɨ́árɨnɨ. Soyɨ́né kí aŋɨ́ nɨjɨ́á nánɨ mɨrɨnɨŋiwá nánɨ ɨ́á nɨxɨrárɨro aí sewanɨŋoyɨ́né wí nɨ́kwiro mɨpáwipa ero ámá nɨpáwianɨrɨ éɨ́áyo soyɨ́né pɨ́rɨ́ mákɨ́mɨ́ wiro yarɨgɨ́árɨnɨ.” e nurɨ́ɨsáná ");
INSERT INTO aak_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","aŋɨ́ e pɨ́nɨ nɨwiárɨmɨ nurɨ emearɨ́ná re egɨ́awixɨnɨ. Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Parisiowa tɨ́nɨ wigɨ́ xwioxɨ́yo dánɨ rɨ́á ápiáwɨ́nɨŋɨ́ nɨwerɨ omɨ sɨ́mɨ́ tɨ́nɨ urɨro amɨpí obaxɨ́ wí nánɨ yarɨŋɨ́ wiayiro neróná ");
INSERT INTO aak_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","“O xwɨyɨ́á sɨpí ŋwɨ́ ikaxɨ́ eánɨŋɨ́ xɨxenɨ mimónɨŋɨ́ bɨ ráná xwɨrɨxɨ́ oumeaneyɨ.” nɨrɨnɨro arɨ́á wiaxɨ́dɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ámá oxɨ́ apɨxɨ́ obaxɨ́ ayá wí epɨ́royɨ́ nɨyárɨróná xokɨrɨ́pɨ́ inarɨ́ná Jisaso xegɨ́ wiepɨsarɨŋowa Parisiowa seáyɨ e nimónɨro sɨpí yayiro naŋɨ́ yayiro yarɨgɨ́ápa awa enɨ e epɨ́rɨxɨnɨrɨ awamɨ xámɨ re urɨŋɨnigɨnɨ, “Soyɨ́né bisɨ́kerɨ́á yisɨ́ (Bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ eŋáná yisɨ́ onɨmiápɨ tɨ́á aiwɨ nɨmɨnɨ íkwiaŋwɨ́ eapɨnárarɨŋɨ́rɨnɨ.) Soyɨ́né bisɨ́kerɨ́á yisɨ́ Parisiowayá nánɨ wáyɨ́ nero emépoyɨ. Wigɨ́ naŋɨ́ ero sɨpí ero yarɨgɨ́ápɨ nánɨ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","awa sɨpí ero naŋɨ́ ero mepa oépoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Amɨpí agwɨ ínɨmɨ imónɨŋɨ́yɨ́ rɨ́wéná sɨŋánɨ imónɨnɨ́árɨnɨ. Amɨpí ínɨmɨ nimónɨrɨ yokwarɨmɨ́ inɨŋɨ́yɨ́ rɨ́wéná ámá nɨ́nɨ nɨjɨ́á imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pí pí xwɨyɨ́á árɨ́wɨyimɨ yumɨ́í ikaxɨ́ rɨnɨ́áyɨ́ enɨ ámá nɨ́nɨ ikwáwɨyíná arɨ́á wipɨ́rɨ́árɨnɨ. Pí pí xwɨyɨ́á aŋɨ́ náyo ínɨmɨ dánɨ ikeagɨgwɨ́ rɨnɨ́áyɨ́ rɨ́wéná aŋɨ́ seáyɨyo nɨŋweámáná áwaŋɨ́ rowiáropɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","O re urɨŋɨnigɨnɨ, “Gɨ́ nɨkumɨxɨnɨrɨ emearɨgɨ́oyɨ́né, nionɨ re seararɨŋɨnɨ, ‘Segɨ́ waráyɨ́nɨ seapɨkiarɨgɨ́áwa nánɨ wáyɨ́ mepanɨ. Dɨŋɨ́ enɨ seaxekwapaxɨ́ meŋagɨ nánɨ ayɨ́ nánɨ wáyɨ́ mepanɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ámá wáyɨ́ wipaxo nánɨ nionɨ áwaŋɨ́ osearɨmɨnɨ. Ayɨ́ Gorɨxorɨnɨ. O ámáyo nɨpɨkímáná xewanɨŋo dɨŋɨ́ enɨ nɨseaxekwapɨrɨ rɨ́á anɨŋɨ́ wearɨŋɨ́yo seaikeaárɨpaxɨ́ eŋagɨ nánɨ wáyɨ́ omɨnɨ wíɨ́rɨxɨnɨ. Oyɨ, o nánɨ aga wáyɨ́ wíɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ámá ayɨ́ dɨŋɨ́ “Gorɨxo ámaéne nánɨ aŋɨpaxɨ́ dɨŋɨ́ moarɨŋɨ́rɨnɨ.” oyaiwípoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Ámá makerɨ́áyo nánɨ nurɨ iŋɨ́ sirɨ́kwá wé wú núnɨ bɨ́ nerɨ́ná nɨgwɨ́ rɨ́á nɨŋɨ́pia biaú tɨ́nɨ bɨ́ yarɨgɨ́árɨnɨ. Iŋɨ́ apia aga onɨmiápia nánɨ aiwɨ Gorɨxo wí dɨŋɨ́ peá nɨmorɨ arɨ́á ikeamoarɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Seyɨ́né nánɨ enɨ Gorɨxo wí arɨ́á ikeamoarɨŋɨ́manɨ. Segɨ́ mɨŋɨ́yo dɨ́á aí ararɨ weŋɨ́yɨ́ nánɨ o nɨjɨ́árɨnɨ. Gorɨxoyá sɨŋwɨ́yo dánɨ seyɨ́né iŋɨ́ onɨmiápia tɨ́nɨ xɨxenɨ mimónɨŋagɨ́a nánɨ wáyɨ́ bɨ mepanɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","re urɨŋɨnigɨnɨ, “Nionɨ re seararɨŋɨnɨ, ‘Ámá go go ámáyá sɨŋwɨ́yo dánɨ ananɨ “Jisasomɨ xɨ́darɨŋáonɨrɨnɨ.” urarɨŋo nánɨ ámá imónɨŋáonɨ nɨweapɨrɨ́ná o nánɨ enɨ Gorɨxoyá aŋɨ́najɨ́yá sɨŋwɨ́yo dánɨ “Gɨ́ ámáorɨnɨ.” rɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","E nerɨ aiwɨ go go ámá nánɨ wáyɨ́ nerɨ sɨŋwɨ́yo dánɨ “Jisasomɨ muxɨ́darɨŋáonɨrɨnɨ.” urarɨŋo nánɨ nionɨ enɨ Gorɨxoyá aŋɨ́najɨ́yá sɨŋwɨ́yo dánɨ “Gɨ́ ámáomanɨ.” rɨmɨ́árɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","re urɨŋɨnigɨnɨ, “Ámá go go ámá imónɨŋáonɨ yarɨŋápɨ nánɨ xwɨyɨ́á sɨpí nɨnɨmearɨrɨ aiwɨ ananɨ Gorɨxo yokwarɨmɨ́ wiipaxɨ́rɨnɨ. E nerɨ aiwɨ go go Gorɨxoyá kwíyɨ́ yarɨŋɨ́pɨ nánɨ ‘Eŋɨ́ eánɨŋɨ́ Setenoyá tɨ́nɨ yarɨnɨ.’ nɨrɨrɨ rɨperɨrɨ́ numearɨrɨ́náyɨ́, Gorɨxo ananɨ yokwarɨmɨ́ wiipaxɨ́ menɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","re urɨŋɨnigɨnɨ, “Ámá wí ɨ́á nɨseaxero rotú aŋɨ́yoranɨ, gapɨmanowa tɨ́ŋɨ́ eranɨ, ámɨná neameŋweagɨ́áwa tɨ́ŋɨ́ eranɨ, nɨmeámɨ nɨseaurónáyɨ́, ‘Arɨge xwɨyɨ́á wákwínanɨ́wɨnɨ?’ mɨyaiwipa nero ayá sɨ́wɨ́ mɨsearopa éɨ́rɨxɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Sa axíná Gorɨxoyá kwíyɨ́pɨ xwɨyɨ́á soyɨ́né urɨpɨ́rɨ́pɨ seaíwapɨyinɨ eŋagɨ nánɨ wáyɨ́ mepa éɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ámá e epɨ́royɨ́ egɨ́áyɨ́ wo Jisasomɨ re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, amɨpí ápo nɨperɨ́ná nɨtɨmɨ péɨ́pɨ gɨ́ ráro xegɨ́pɨ íkwɨ́naroarɨŋagɨ nánɨ ‘Dɨxɨ́ rɨgwáo tɨ́nɨ píránɨŋɨ́ yaŋɨ́ menɨ́piyɨ.’ ureɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","o re urɨŋɨnigɨnɨ, “Ámáoxɨnɨ, ámáyo xwɨrɨxɨ́ méwɨnɨgɨnɨrɨ go nɨrɨ́peáɨ́rɨnɨ? Go awagwíyá amɨpí yaŋɨ́ oeameinɨrɨ nɨrɨ́peáagɨ nánɨ nɨrarɨŋɨnɨ?” omɨ e nurɨmáná ");
INSERT INTO aak_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ámá nɨyonɨ re urɨŋɨnigɨnɨ, “Segɨ́ iyɨ́á ɨ́á amɨpí dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ seaiapɨpaxɨ́ menɨnɨ. Xwé ayá wí tɨ́ŋoxɨ aiwɨ wí dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ siapɨpaxɨ́ menɨnɨ. Ayɨnánɨ amɨpí naŋɨ́ sɨŋwɨ́ ɨ́wɨ́ nɨwɨnɨrɨ́ná ‘Nionɨ meapaxɨ́rɨnɨ.’ yaiwiarɨgɨ́ápɨ nɨpɨnɨ enɨ nánɨ wáyɨ́ oseainɨnɨ. Seyɨ́né iyɨ́á ɨ́á amɨpí nánɨnɨ dɨŋɨ́ ɨkwɨ́ropɨ́rɨxɨnɨrɨ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá amɨpí mɨmúrónɨŋɨ́ woyá omɨŋɨ́yo witɨ́ aiwá xwé pɨ́rɨpɨ́rɨ́ inɨŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","dɨŋɨ́ neyírorɨ re yaiwiŋɨnigɨnɨ, ‘Arɨ emɨnɨréɨnɨ? Aiwá pɨ́rɨpɨ́rɨ́ inɨŋɨ́ tɨ́ tɨmɨ nánɨ gɨ́ aŋɨ́ apánɨ menɨnɨ.’ nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","re rɨnɨŋɨnigɨnɨ, ‘Re oemɨnɨ. Aŋɨ́ aiwá nánɨ mɨrɨnɨŋɨ́yɨ́ emɨ pɨpɨnamɨ́ nɨyárɨmáná ámɨ aga xwé wiwɨ wiwá nɨmɨra numáná gɨ́ witɨ́ aiwá nɨ́nɨ tɨ́nɨ amɨpí nionɨyá tɨ́nɨ aŋɨ́ iwiwámɨ nɨta úɨmɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","E nɨyárɨmáná niɨwanɨŋonɨ re rɨ́ɨmɨgɨnɨ, “Gɨ́ amɨpí nɨ́nɨ rɨxa déronɨ. Aiwá xwiogwɨ́ ɨ́á ropaxɨ́ nánɨ mɨwenɨnɨ. Ananɨ kikiɨ́á ŋwearɨ aiwá nɨrɨ iniɨgɨ́ nɨrɨ nerɨ yayɨ́ éɨmɨgɨnɨ.” rɨ́ɨmɨgɨnɨ.’ rɨnɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Gorɨxo omɨ re urɨŋɨnigɨnɨ, ‘Majɨmajɨ́á ikárɨnarɨŋɨ́ roxɨnɨ, sɨ́á rɨyimɨnɨ joxɨ rɨxa nɨperɨ́ɨnɨ. Nɨpéáná dɨxɨ́ amɨpí píránɨŋɨ́ tɨŋɨ́pɨ go meanɨ́árɨnɨ?’ urɨŋɨnigɨnɨ.” Ayo e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","re urɨŋɨnigɨnɨ, “Ewayɨ́ xwɨyɨ́á apɨ ámá Gorɨxo nánɨ dɨŋɨ́ mɨmopa nero ‘Amɨpí xewanɨŋonɨ nɨgɨ́ wínɨ wínɨ nɨmeaayirɨ otɨmɨnɨ.’ yaiwiarɨgɨ́áyɨ́ nánɨrɨnɨ. Ámá e yarɨgɨ́áyɨ́ amɨpí wí mɨmúrónɨŋagɨ aiwɨ Gorɨxoyá sɨŋwɨ́yo dánɨ uyípeayɨ́ imónarɨgɨ́áyɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","O xegɨ́ wiepɨsarɨŋɨ́yo re urɨŋɨnigɨnɨ, “Ámá e yarɨgɨ́áyɨ́ amɨpí wí mɨmúroŋagɨ aiwɨ Gorɨxoyá sɨŋwɨ́yo dánɨ uyípeayɨ́ imónarɨgɨ́áyɨ́ eŋagɨ nánɨ re seararɨŋɨnɨ, ‘ “Arɨge píránɨŋɨ́ ŋweanɨréwɨnɨ?” nɨrɨro aiwá nɨpɨ́rɨ nánɨ ududɨ́ mepa ero waráyo aikɨ́ yínɨpɨ́rɨ nánɨ ududɨ́ mepa ero éɨ́rɨxɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ayɨ́ rɨpɨ nánɨrɨnɨ. Segɨ́ wárá jɨ́ayɨ́ aikɨ́yo múrónɨnɨ. Dɨŋɨ́ jɨ́ayɨ́ enɨ aiwáyo múrónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Soyɨ́né ámɨ iŋɨ́ áwɨ́ nánɨ dɨŋɨ́ morɨ́ɨnɨ. Iŋɨ́ awa aiwá omɨŋɨ́ nero mianarɨgɨ́ámanɨ. Wigɨ́ aiwá nɨmimɨ nuro aŋɨ́yo tɨpɨ́rɨ́áyɨ́ enɨ aŋɨ́ wí mɨmɨrɨnɨnɨ. E nerɨ aí Gorɨxonɨ mɨnɨ wiarɨŋɨ́rɨnɨ. Soyɨ́né dɨŋɨ́ re rɨyaiwiarɨŋoɨ, ‘Iŋɨ́yo mɨmúrónɨŋagwɨ nánɨ Gorɨxo none nánɨ enɨ aiwá neaimɨxɨyipaxomanɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ, dɨŋɨ́ e wí mɨmopa époyɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ámá ‘Sepiá ámɨ bɨ oimónɨmɨnɨ.’ nɨyaiwirɨ ududɨ́ éo sepiá ámɨ bɨ imónarɨŋɨ́ranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Soyɨ́né enɨ apɨ aí wí mepaxɨ́ nerɨ́náyɨ́ aikɨ́ tɨ́nɨ aiwá tɨ́nɨ nánɨ pí nánɨ ududɨ́ yarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Soyɨ́né adowayɨ́ nánɨ dɨŋɨ́ morɨ́ɨnɨ. Nɨyapɨrɨ́ná xegɨ́ iyɨ́á óɨ́ earɨ aikɨ́ yirɨ yarɨŋɨ́manɨ. E nerɨ aiwɨ eŋíná negɨ́ mɨxɨ́ ináyɨ́ Soromono okiyɨ́á ninɨrɨ meárɨnɨŋo nerɨ́náyɨ́ adowayɨ́ yapɨ awiaxɨ́ e imónagɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gorɨxo adowayɨ́ tɨ́nɨ aráyo —Ará agwɨ eŋɨ́yo ananɨ nɨyoaro sɨ́á wɨyimɨ rɨ́á ikeaárɨpɨ́rɨ́áyɨ́rɨnɨ.” urɨŋɨnigɨnɨ. Awa “Gorɨxo ará nánɨ ayá sɨ́wɨ́ muroarɨnɨnɨ.” oyaiwípoyɨnɨrɨ e nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxo adowayɨ́ tɨ́nɨ aráyo okiyɨ́ánɨŋɨ́ yarɨŋagɨ nánɨ soyɨ́né enɨ aŋɨpaxɨ́ aikɨ́ e seayírɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ayɨnánɨ soyɨ́né iniɨgɨ́ tɨ́nɨ aiwá tɨ́nɨ nánɨ ‘Pí nanɨréwɨnɨ?’ nɨrɨro ududɨ́ néra mupa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gorɨxomɨ mɨxɨ́dɨpa yarɨgɨ́áyɨ́ apɨ nánɨ anɨŋɨ́ minɨ́ nero meaanɨro yarɨgɨ́árɨnɨ. E nerɨ aí segɨ́ ápo Gorɨxo soyɨ́né apɨ nɨpɨnɨ aiwáranɨ, aikɨ́ranɨ seainarɨŋagɨ nánɨ nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Apɨ meaanɨro nánɨ mepa ero Gorɨxo xɨ́o xegɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e páwipɨ́rɨ nánɨ amɨpí xɨ́o wimónarɨŋɨ́pɨ ero nerɨ́náyɨ́, Gorɨxo ananɨ apɨ nɨpɨnɨ nɨseaiinɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Awa xwɨ́á tɨ́yo nɨŋwearɨ́ná wigɨ́ amɨpí xwé meŋagɨ nánɨ wáyɨ́ epɨ́rɨxɨnɨrɨ re urɨŋɨnigɨnɨ, “Seyɨ́né sipɨsipɨ́ miaúrárɨ́ inɨgɨ́áyɨ́ yapɨ imónɨgɨ́áyɨ́né, segɨ́ ápo Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e páwíɨ́rɨxɨnɨrɨ wimónarɨŋagɨ nánɨ wáyɨ́ mepa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Segɨ́ iyɨ́á ɨ́á amɨpí nɨgwɨ́ nánɨ bɨ́ nero nɨgwɨ́ meáɨ́áyɨ́ ámá uyípeayɨ́ imónɨgɨ́áyo arɨrá wianɨro nánɨ mɨnɨ wíɨ́rɨxɨnɨ. E nerɨ́náyɨ́, amɨpí aŋɨ́namɨ ayá rɨmɨxarɨgɨ́ápɨ́nɨŋɨ́ tarɨŋoɨ. Aŋɨ́namɨ amɨpí wí anɨpá imónarɨŋɨ́manɨ. Ɨ́wɨ́ yarɨgɨ́áyɨ́ wí páwipaxɨ́ mimónɨnɨ. Ípɨkwɨyɨ́ enɨ wí amɨpí xwɨrɨ́á ikɨxepaxɨ́ mimónɨnɨ. Ayɨnánɨ xwɨ́á tɨ́yo amɨpí wínɨ wínɨ nɨmeaayirɨ mɨtɨpa nerɨ ámáyo ayá nurɨmɨxɨrɨ arɨrá nɨwirɨ́náyɨ́, aŋɨ́námɨnɨ anɨŋɨ́ wenɨ́e awínɨŋɨ́ eaárarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Segɨ́ amɨpí naŋɨ́ ayá rɨmɨxarɨgɨ́ápɨ xwɨ́á tɨ́yo weŋánáyɨ́, ayɨ́ xwɨ́á tɨ́yo nánɨ dɨŋɨ́ mopɨ́rɨ́árɨnɨ. Aŋɨ́namɨ weŋánáyɨ́, Gorɨxo tɨ́ŋɨ́ e nánɨ mopɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","O gɨ́ wiepɨsarɨŋáyɨ́ wé nɨrónɨro ŋweáɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Ámá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áwa wigɨ́ boso nánɨ ‘Aiwá apɨxɨ́ meánɨnɨ nánɨ imɨxarɨgɨ́ápɨ gíná pɨ́nɨ nɨwiárɨmɨ bɨnɨrɨ́enɨŋoɨ?’ nɨyaiwiro rapɨrapɨ́ írɨŋɨ́yo kɨ́kɨyinɨgɨ́ú nɨkɨ́roro nɨpɨmoánɨro arerɨxɨ́ nɨyínɨro uyɨ́wɨ́ nɨmɨxároro o nɨrémorɨ wáɨ́ e dánɨ wakwɨ́ óráná apaxɨ́ mé ówaŋɨ́ ɨ́kwianeyɨnɨro xwayɨ́ nanɨrɨ ŋweaarɨgɨ́ápa seyɨ́né enɨ e éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Boso nɨrémorɨ omɨŋɨ́ wiiarɨgɨ́áwa sá mɨwé wé nɨrónɨro ŋweaŋagɨ́a nɨwɨnɨrɨ́náyɨ́, awa yayɨ́ winɨpaxɨ́rɨnɨ. ‘Boso omɨŋɨ́ wiiarɨgɨ́áwa wé nɨrónɨro ŋweaŋagɨ́a nɨwɨnɨrɨ xewanɨŋo rapɨrapɨ́ nɨkɨ́rorɨ arerɨxɨ́ nɨyínɨrɨ “Aiwá narɨgɨ́e éɨ́ ŋweápoyɨ.” nurɨrɨ aiwá mɨnɨ nɨwia unɨŋoɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O árɨwegɨ́yoranɨ, isɨ́áyoranɨ, nɨrémorɨ xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwa sɨnɨ wé nɨrónɨro ŋweaŋagɨ́a nɨwɨnɨrɨ́náyɨ́, awa yayɨ́ winɨpaxɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ewayɨ́ xwɨyɨ́á ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Rɨpɨ enɨ nánɨ dɨŋɨ́ mópoyɨ. Aŋɨ́ iwámɨ xiáwo ɨ́wɨ́ meanɨ bɨno nánɨ ‘Sɨ́á rɨyimɨ bɨnɨŋoɨ.’ nɨyaiwirɨ sɨŋwɨrɨyɨ́, awí nɨŋwearɨ ɨ́wɨ́ meano opáwinɨrɨ sɨŋwɨ́ mɨwɨnɨpa emɨnɨrɨ eŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","re urɨŋɨnigɨnɨ, “Seyɨ́né enɨ wé nɨrónɨro ŋwearɨ́ɨnɨ. Sɨ́á ámá imónɨŋáonɨ nánɨ ‘O nɨweapɨnɨmenɨŋoɨ.’ yaiwíɨ́áyimɨ nɨweapɨmɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ewayɨ́ xwɨyɨ́á apɨ rarɨŋɨ́pɨ nearéwapɨyarɨŋonenɨ nánɨ rɨrarɨŋɨnɨ? Ámá nɨyonɨ enɨ nánɨ rɨrarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jisaso ámɨ ewayɨ́ ikaxɨ́ urɨmɨnɨrɨ nánɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Omɨŋɨ́ wiiarɨŋɨ́ wo xegɨ́ bosoyá xwɨyɨ́á arɨ́á nɨwirɨ dɨŋɨ́ neŋwɨperɨ nerɨ́náyɨ́ arɨge imónɨnɨ? O re imónɨnɨ. O omɨŋɨ́ rɨpɨ nánɨ bosɨwo oimónɨrɨ xegɨ́ boso rɨ́peaŋorɨnɨ. O xegɨ́ bosoyá omɨŋɨ́ wiiarɨgɨ́áyo umeirɨ aiwá yaŋɨ́ umeirɨ yarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Boso amɨ dánɨ nɨbɨrɨ xegɨ́ bosɨwo xámɨ yagɨ́pa sɨnɨ axɨ́pɨ píránɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ́ná bosɨwo yayɨ́ winɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nepa seararɨŋɨnɨ. O píránɨŋɨ́ yarɨŋagɨ nɨwɨnɨrɨ́ná xegɨ́ omɨŋɨ́ nɨ́nɨ enɨ onɨmeinɨrɨ rɨ́peanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","E nerɨ aiwɨ bosɨwɨ́ axo ‘Gɨ́ boso yapapɨ́nɨ bɨnɨmenɨŋoɨ.’ nɨyaiwirɨ omɨŋɨ́ wiiarɨgɨ́áwamɨ tɨ́nɨ omɨŋɨ́ wiiarɨgɨ́íwamɨ tɨ́nɨ iwaŋɨ́ nɨméperɨ aiwá nɨrɨ iniɨgɨ́ nɨrɨ nemáná papɨkɨ́ nerɨ́náyɨ́ ");
INSERT INTO aak_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‘Boso nɨbɨnɨmenɨŋoɨ.’ nɨyaiwirɨ yarɨŋɨ́yimɨ sɨ́á xɨ́o bɨnɨyimɨ majɨ́á nimónɨrɨ yarɨŋɨ́yimɨ boso rɨxa nɨrémónapɨrɨ re enɨ́árɨnɨ. Bosɨwomɨ mɨŋɨ́ nɨwákwirɨ ámá arɨ́kí yarɨgɨ́áyɨ́ tɨ́nɨ wárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bosɨwɨ́ go go xegɨ́ boso wimónarɨŋɨ́pɨ nánɨ nɨjɨ́á nimónɨrɨ aiwɨ píránɨŋɨ́ mimɨxɨpa nerɨ wé nɨrónɨrɨ mɨŋweapa nerɨ́náyɨ́ boso nɨbɨrɨ́ná iwaŋɨ́ rɨpɨ rɨpɨ eámeámɨ́ eaayinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","E nerɨ aiwɨ bosɨwɨ́ go go xegɨ́ boso wimónarɨŋɨ́pɨ nánɨ nɨjɨ́á mimónɨpa nerɨ sɨpí o iwaŋɨ́ eapaxɨ́ bɨ nimɨxɨrɨ́náyɨ́, boso nɨbɨrɨ́ná iwaŋɨ́ onɨmiápɨ weaanɨ́árɨnɨ. Ámá nɨ́nɨ amɨpí xwé wí wíɨ́áyɨ́ rɨ́wéná ayɨ́ enɨ xwé urápɨpɨ́rɨ́árɨnɨ. Gorɨxo enɨ ámá gomɨ xegɨ́ omɨŋɨ́ wiinɨ urɨŋɨ́yɨ́ nánɨ rɨ́wéná yarɨŋɨ́ re winɨ́árɨnɨ, ‘Omɨŋɨ́ nionɨ siapɨŋáyɨ́ xɨxenɨ eŋɨ́ranɨ?’ urɨnɨ́árɨnɨ.” Jisaso xegɨ́ wiepɨsarɨŋɨ́yɨ́ xɨ́o mɨŋweaŋáná úrapí néra upɨ́rɨxɨnɨrɨ dɨŋɨ́ móɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á apɨ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","O re rɨŋɨnigɨnɨ, “Nionɨ ámá xwɨ́á tɨ́yo ŋweagɨ́áyo xeanɨŋɨ́ Gorɨxoyá rɨ́ánɨŋɨ́ wikeaárɨmɨ́a nánɨ bɨŋáonɨrɨnɨ. ‘Xeanɨŋɨ́ apɨ ápiáwɨ́nɨŋɨ́ rɨxa wémɨnɨrɨ nerɨ sɨŋwɨrɨyɨ́, ayɨ́ naŋɨ́rɨnɨ.’ nimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","E nerɨ aiwɨ xeanɨŋɨ́ ámá iniɨgɨ́ waxɨ́ márómɨnɨrɨ́nɨŋɨ́ yarɨŋɨ́pɨ nionɨ nímeanɨ́árɨnɨ. Sɨnɨ mɨnímeapa eŋagɨ nánɨ dɨŋɨ́ rɨ́á nɨxearɨnɨ.” Jisaso xɨ́omɨ pɨkipɨ́rɨ́á eŋagɨ nánɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","re urɨŋɨnigɨnɨ, “Nionɨ nánɨ ‘O ámá nɨyonɨ pɨyɨ́á wɨ́rɨmɨ́ánɨrɨ bɨŋorɨnɨ.’ rɨniaiwiarɨŋoɨ? Oweoɨ! Ámá nionɨ dɨŋɨ́ nɨnɨkwɨ́roro yarɨgɨ́áyɨ́ tɨ́nɨ uyɨ́niɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ xepɨxepá rónɨ́ɨ́rɨxɨnɨrɨ bɨŋáonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ríná dánɨ ná rɨ́wɨ́yo enɨ aŋɨ́ ná wiwámɨ dánɨ ámá wé wú axɨ́yɨ́ imónɨŋagɨ aiwɨ xwɨyɨ́á nionɨyápimɨ dánɨ xepɨxepá nɨrónɨro mɨdánɨ waú imónɨŋáná mɨdánɨ waú wo imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xano tɨ́nɨ xewaxo tɨ́nɨ xepɨxepá rónɨri xɨnáí tɨ́nɨ xemiáí tɨ́nɨ xepɨxepá rónɨri xiɨ́áí tɨ́nɨ xewaxomɨ xiepí tɨ́nɨ xepɨxepá rónɨri néra upɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","O ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyo re urɨŋɨnigɨnɨ, “Seyɨ́né sogwɨ́ wearɨŋɨ́mɨ dánɨ agwɨ́ yaparɨŋagɨ nɨwɨnɨrɨ́ná ‘Rɨxa iniá yaparɨnɨ.’ rarɨgɨ́ápa nepa eaarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Imɨŋɨ́ damɨ dánɨ enɨ barɨŋagɨ nɨwɨnɨrɨ́ná ‘Agwɨ ríná rɨ́á sínɨnɨŋoɨ.’ rarɨgɨ́ápa nepa rɨ́á sínarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Naŋɨ́ rɨro sɨpí rɨro yarɨgɨ́oyɨ́né, agwɨ́ tɨrɨ imɨŋɨ́ erɨ yarɨŋagɨ nɨwɨnɨrɨ́ná ananɨ ‘E imónɨnɨŋoɨ.’ xɨxenɨ rarɨgɨ́á aiwɨ amɨpí nionɨ sɨ́mɨmajɨ́ónɨŋɨ́ imɨxarɨŋápɨ sɨŋwɨ́ nɨnanɨro ‘Ayɨ́ Gorɨxo rɨpɨ nánɨ sɨwá rɨ́a neaiarɨnɨ?’ mɨyaiwiarɨgɨ́áyɨ́néxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Sewanɨŋoyɨ́né amɨpí sɨpí imónɨŋɨ́yɨ́ naŋɨ́nɨ eyeyírómɨ́ erɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo omɨ xwɨyɨ́á omearɨmɨnɨrɨ joxɨ tɨ́nɨ xwɨrɨxɨ́ yanɨri sirɨmeááná sɨnɨ óɨ́ e nurɨ́ná o tɨ́nɨ xwɨyɨ́á nimɨxɨnɨri omɨ píránɨŋɨ́ pɨyɨ́á wɨ́rɨrɨ́ɨnɨ. E mɨwipa nerɨ́náyɨ́, o xwɨrɨxɨ́ mearɨŋo tɨ́ŋɨ́ e nánɨ ɨ́á nɨrɨxémɨ nurɨ xwɨrɨxɨ́ nɨrɨméɨsáná eŋáná xwɨrɨxɨ́ mearɨŋo joxɨ ɨ́á nɨrɨxɨrɨrɨ porisɨ́ womɨ mɨnɨ wíáná o gwɨ́ aŋɨ́yo rɨŋwɨrárɨnɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Joxɨ nɨgwɨ́ yoparɨ́pɨ nɨroarɨ nɨroayírónɨrɨ́náyɨ́, gwɨ́ aŋɨ́yo dánɨ nɨpeyearɨ́ɨnɨ. ‘E mepa nerɨ́náyɨ́, anɨŋɨ́ e ŋwearɨ́árɨnɨ.’ seararɨŋɨnɨ.” Jisaso ayɨ́ “Xwɨrɨxɨ́ mearɨŋo Gorɨxorɨ́anɨ?” yaiwiro sɨ́á o ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyi sɨnɨ mimónɨŋáná “Nene dɨŋɨ́ nɨyaikirorane omɨ dɨŋɨ́ owɨkwɨ́roaneyɨ.” yaiwiro oépoyɨnɨrɨ ewayɨ́ xwɨyɨ́á e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jisaso ámá e epɨ́royɨ́ egɨ́áyo sɨnɨ uréwapɨyarɨ́ná ámá wí nɨwiápɨ́nɨmearo áwaŋɨ́ re urɨgɨ́awixɨnɨ, “Émáyɨ́ gapɨmanɨ́ Pairato porisɨ́ wamɨ urowáráná awa aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nuro ámá Gariri pɨropenɨsɨ́yo dáŋɨ́ wí rɨdɨyowá yarɨ́ná pɨpɨkímɨ́ egɨ́awixɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","o re urɨŋɨnigɨnɨ, “Seyɨ́né ‘Gariri dáŋɨ́ ayɨ́ rɨkɨkɨrɨ́ó néra nuróná ámá nɨyonɨ múrónɨgɨ́á eŋagɨ nánɨ e pɨkigɨ́awixɨnɨ.’ rɨyaiwiarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","‘Oweoɨ, seyɨ́né ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro mɨsanɨpa nerɨ́náyɨ́, seyɨ́né enɨ axɨ́pɨ énɨŋɨ́ anɨ́nɨpɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ámá 18 ayɨ́ aŋɨ́ rɨpɨŋwɨ́á wiwá ipí xegɨ́ yoɨ́ Siroamɨyɨ rɨnɨŋɨ́wá tɨ́ŋɨ́ e nɨpɨneamioarɨ ámá apimɨ pɨkiŋɨ́yɨ́ nánɨ seyɨ́né re rɨyaiwiarɨŋoɨ, ‘Ámá ayɨ́ rɨkɨkɨrɨ́ó néra nuro ámá Jerusaremɨ ŋweagɨ́á wínɨyɨ́ nɨyonɨ seáyɨ e múrónɨgɨ́á eŋagɨ nánɨ aŋɨ́ iwá nɨpiérorɨ pɨkíɨnigɨnɨ.’ rɨyaiwiarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oweoɨ, seyɨ́né ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro mɨsanɨpa nerɨ́náyɨ́, seyɨ́né enɨ axɨ́pɨ énɨŋɨ́ anɨ́nɨpɨ́rɨ́árɨnɨ.” Ámá e epɨ́royɨ́ egɨ́áyɨ́ “Xɨxenɨ e neaímeanɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","E nurɨrɨ́ná ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo xegɨ́ wainɨ́ uraxɨ́ omɨŋɨ́yo íkɨ́á pikɨ́ ɨwɨ́ nurárɨmáná rɨ́wéná sogwɨ́ dɨmɨnɨrɨ nɨbayirɨ aí pɨ́á megɨnayiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pɨ́á nɨmegɨnayirɨ nánɨ xegɨ́ omɨŋɨ́ ayɨ́ wiiarɨŋomɨ re urɨŋɨnigɨnɨ, ‘Íkɨ́á rɨna xwiogwɨ́ waú womɨ nionɨ sogwɨ́ nánɨ nɨbɨrɨ pɨ́á megɨnayíárɨnɨ. Ná mɨwearɨŋɨ́na íkwapiŋɨ́ meaarɨnɨ. Emɨ rómoáreɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","o re urɨŋɨnigɨnɨ, ‘Ámɨnáoxɨnɨ, ámɨ xwiogwɨ́ ro xe opwenɨ. Ná wenɨ nánɨ pɨpɨŋɨ́yo ará nɨyárɨmáná xwɨ́á pɨyɨ́ wiárómɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xwiogwɨ́ wɨ́omɨ ná wéagɨ nɨwɨnɨrɨ́náyɨ́, ayɨ́ naŋɨ́rɨnɨ. Ná mɨweŋagɨ nɨwɨnɨrɨ́ná nɨrorɨ emɨ móɨrɨxɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso ámá ayɨ́ “Nene íkɨ́á pikɨ́ anánɨŋɨ́ imónɨŋagwɨ nánɨ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ ikaxɨ́ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisaso sabarɨ́á wɨyimɨ rotú aŋɨ́yo nɨŋweámáná ámáyo uréwapɨyarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Apɨxɨ́ wí —Í imɨ́ó dɨŋɨ́ xɨxéroarɨŋagɨ nánɨ anɨŋɨ́ sɨmɨxɨ́ nerɨ nɨrɨ́kwínɨrɨ emearɨ́ná xwiogwɨ́ wé wúkaú sɨkwɨ́ wú eŋáná ámɨ wɨ́úmɨ dáŋɨ́ waú wo múroŋírɨnɨ. Éɨ́ ropaxɨ́ wiarɨŋímanɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Í e ŋweaŋagɨ Jisaso nɨwɨnɨrɨ́ná “Eɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Ineyɨ, sɨmɨxɨ́ siarɨŋɨ́pɨ rɨxa pɨ́nɨ rɨwiárɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","wé seáyɨ e ikwiáráná re eŋɨnigɨnɨ. Í éɨ́ píránɨŋɨ́ nɨrorɨ Gorɨxomɨ yayɨ́ seáyɨ e umeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","E éáná rotú aŋɨ́ meŋweaŋo Jisaso Sabarɨ́áyo apɨxímɨ naŋɨ́ wimɨxɨ́agɨ nánɨ wikɨ́ dɨŋɨ́ nɨwiaiwirɨ ámá e epɨ́royɨ́ egɨ́áyo re urɨŋɨnigɨnɨ, “Sɨ́á wé wɨ́úmɨ dáŋɨ́ wɨyi omɨŋɨ́ nánɨ imónɨnɨ. Sɨ́á ayo Jisaso naŋɨ́ seaimɨxɨnɨ́a nánɨ bɨrɨ́ɨnɨ. Sabarɨ́áyo mɨbɨpa erɨ́ɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","omɨ Jisaso mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Naŋɨ́ erɨ sɨpí erɨ yarɨgɨ́oyɨ́né, Sabarɨ́áyo aí burɨmákaú tɨ́nɨ dogí tɨ́nɨ wigɨ́ aŋɨ́yo nɨpáwirɨ níkweámɨ iniɨgɨ́ onɨnɨrɨ iniɨgɨ́ tɨ́ŋɨ́ e nánɨ nɨméra mupa yarɨgɨ́áranɨ?” Ayɨ́ Sabarɨ́áyo wigɨ́ burɨmákaú nánɨ dɨŋɨ́ nɨmoro aí ámá nánɨ dɨŋɨ́ mɨmoarɨŋagɨ́a nánɨ e nurɨrɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“Apɨxɨ́ rí Ebɨrɨ́amoyá ɨ́wiárɨ́awéyɨ́ wírɨnɨ. Seteno sɨmɨxɨ́ apɨ nɨwirɨ gwɨ́nɨŋɨ́ járɨnɨŋáná xwiogwɨ́ 18 múroŋírɨnɨ. ‘Ímɨ Sabarɨ́áyo gwɨ́nɨŋɨ́ nɨwíkwearɨ naŋɨ́ nɨwimɨxɨrɨ́ná nɨpɨkwɨnɨ mɨyarɨnɨnɨ.’ rɨniaiwiarɨŋoɨ?” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","omɨ wikɨ́ dɨŋɨ́ wiaiwíɨ́áwa ayá winɨŋɨnigɨnɨ. Ayá winarɨ́ná ámá oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ amɨpí ayá rɨwamónɨpaxɨ́ Jisaso yarɨŋɨ́pɨ nánɨ yayɨ́ seáyɨmɨ dánɨ néra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","O ámá obaxɨ́ dɨŋɨ́ mɨwɨkwɨ́ropa yarɨŋagɨ́a nɨwɨnɨrɨ re ragɨ́rɨnɨ, “Nionɨ ewayɨ́ xwɨyɨ́á bɨ pípɨ nɨrɨrɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ ‘Rɨpɨ́nɨŋɨ́ imónɨnɨ.’ rɨmɨ́ɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","re urɨŋɨnigɨnɨ, “Apɨ masɨté siyɨ́nɨŋɨ́ —Masɨté aiwá xegɨ́ siyɨ́ aga onɨmiárɨnɨ. Apɨ masɨté siyɨ́nɨŋɨ́ imónɨnɨ. Ámá wo masɨté siyɨ́ nɨmearɨ xegɨ́ omɨŋɨ́yo moáráná nerápɨrɨ íkɨ́á nimónɨrɨ peyíáná iŋɨ́ nɨbɨrɨ ápaxɨ́yo yéwɨ́ tɨŋɨnigɨnɨ.” urɨŋɨnigɨnɨ. Ámá “Agwɨ Jisasomɨ ámá obaxɨ́ dɨŋɨ́ mɨwɨkwɨ́ropa yarɨŋagɨ́a aiwɨ idáná obaxɨ́ dɨŋɨ́ wɨkwɨ́ropɨ́rɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ Jisaso e uragɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ewayɨ́ xwɨyɨ́á axɨ́pɨ ámɨ bɨ re urɨŋɨnigɨnɨ, “Arɨge nɨrɨrɨ Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ ‘Rɨpɨ́nɨŋɨ́ imónɨnɨ.’ rɨmɨ́ɨnɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","re urɨŋɨnigɨnɨ, “Apɨ yisɨ́nɨŋɨ́ —Yisɨ́ bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ eŋáná bɨ onɨmiápɨ ínɨmɨ táná yarɨŋɨ́pa nɨpɨnɨ íkwiaŋwɨ́ eapɨnarɨŋɨ́rɨnɨ. Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́ápɨ yisɨ́nɨŋɨ́ imónɨnɨ. Apɨxɨ́ wí bisɨ́kerɨ́á sɨnɨ sɨŋɨ́ dɨramɨxɨ́ xwé wámɨ sɨxɨ́ ínɨŋáná yisɨ́ bɨ nɨmearɨ ínɨmɨ táná nɨmɨnɨ íkwiaŋwɨ́ eapɨnárɨŋɨnigɨnɨ.” uragɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","O Jerusaremɨ nánɨ nurɨ́ná aŋɨ́ apɨ apimɨ nuréwapɨya warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ámá wo re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, sɨ́á Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ enɨ́áyimɨ o ámá womɨnɨ womɨnɨ nenenɨ yeáyɨ́ neayimɨxemeanɨ́áranɨ?” urɨ́agɨ o ámá ayo re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xɨ́darɨgɨ́ápɨ óɨ́ onɨgɨ́yɨkwɨ́nɨŋɨ́ inɨnɨ. Óɨ́ ayimɨ páwipɨ́rɨ nánɨ anɨŋɨ́ minɨ́ éɨ́rɨxɨnɨ. Ámá obaxɨ́ ananɨ opáwianeyɨnɨrɨ nerɨ́ná yopa megɨnɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Aŋɨ́ xiáwo nɨwiápɨ́nɨmearɨ aŋɨ́ ówaŋɨ́ yáráná seyɨ́né nɨbɨro wáɨ́ bɨ́arɨwámɨnɨ nɨrómáná wakwɨ́ nórɨrɨ ‘Ámɨnáoxɨnɨ, aŋɨ́ ówaŋɨ́ neaɨ́kwiénapeɨ.’ uráná re searɨnɨ́árɨnɨ, ‘Nionɨ majɨ́árɨnɨ. Aŋɨ́ gɨmɨ dáŋɨ́yɨ́néxɨnɨ?’ searáná ");
INSERT INTO aak_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","re uranɨrɨ éɨ́áyɨ́ ‘Joxɨ negɨ́ aŋɨ́ wáɨ́yo nɨrémorɨ nene tɨ́nɨ nawínɨ aiwá tɨ́nɨ iniɨgɨ́ tɨ́nɨ nɨnɨrane nearéwapɨyiŋenerɨnɨ.’ uranɨrɨ éɨ́áyɨ́ ");
INSERT INTO aak_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","aŋɨ́ xiáwo re searɨnɨŋoɨ, ‘Aŋɨ́ gɨmɨ dáŋɨ́yɨ́néxɨnɨ? Nionɨ majɨ́árɨnɨ.’ searɨnɨ́árɨnɨ. ‘Ɨ́wɨ́ yarɨgɨ́áyɨ́né nionɨ pɨ́nɨ nɨnɨwiárɨmɨ éɨ́ úpoyɨ.’ searɨnɨ́árɨnɨ.” nurɨrɨ Gorɨxo aŋɨ́ xiáwónɨŋɨ́ imónɨŋagɨ nánɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","re urɨŋɨnigɨnɨ, “Seyɨ́né re wɨnɨpɨ́rɨ́árɨnɨ. Segɨ́ seáwowa Ebɨrɨ́amo tɨ́nɨ Aisako tɨ́nɨ Jekopo tɨ́nɨ awa Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́áwa tɨ́nɨ xɨ́oyá xwioxɨ́yo nɨpáwiro ŋweaŋagɨ́a nɨwɨnɨro Gorɨxo ‘Segɨ́pɨ bɨ́anɨrɨwámɨnɨ ŋweápoyɨ.’ searɨ́agɨ nɨwɨnɨróná seyɨ́né maŋɨ́ magí nírónɨro ŋwɨ́ pɨyɨ́ wɨ́rɨnɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Émáyɨ́ oxɨ́ apɨxɨ́ sogwɨ́ weaparɨŋɨ́mɨ dáŋɨ́yɨ́ weapɨro sogwɨ́ wearɨŋɨ́mɨ dáŋɨ́yɨ́ yapɨro mɨdɨmɨdáŋɨ́yɨ́ enɨ bɨro nero Gorɨxoyá xwioxɨ́yo nɨpáwiro aiwá narɨŋagɨ́a sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","xewanɨŋo ámɨ nɨweapɨrɨ́ná nánɨ re urɨŋɨnigɨnɨ, “Émáyɨ́ xámɨ surɨ́má imónɨgɨ́áyɨ́ xámɨ xámɨ imónɨpɨ́rɨ́árɨnɨ. Xámɨ xámɨ imónɨgɨ́áyɨ́né surɨ́má epɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jisaso xwɨyɨ́á apɨ nurɨ́ɨsáná eŋáná Parisi wa re urémeagɨ́awixɨnɨ, “Gapɨmanɨ́ Xeroto rɨpɨkinɨ nánɨ wimónarɨŋagɨ nánɨ re pɨ́nɨ nɨwiárɨmɨ uɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","o re urɨŋɨnigɨnɨ, “Soyɨ́né nuro Xeroto, sɨ́wí sayɨ́nɨŋɨ́ ɨ́wɨ́ yarɨŋomɨ áwaŋɨ́ re urémeápoyɨ, ‘Jisaso re rarɨnɨ urémeápoyɨ, “Nionɨ sɨ́á árɨ́nɨ́ wíyo imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yɨ́ mɨxɨ́ umáɨnowárɨrɨ sɨmɨxɨ́yɨ́ píránɨŋɨ́ imɨmɨxɨmɨ́ erɨ nemáná omɨŋɨ́ (Omɨŋɨ́ ayɨ́ xewanɨŋo ámá nɨyonɨ nánɨ upeinɨ́á nánɨrɨnɨ.) Omɨŋɨ́ Gorɨxo o éwɨnɨgɨnɨrɨ nɨrowárénapɨŋɨ́pɨ yárɨmɨ́árɨnɨ.” rarɨnɨ.’ urémeápoyɨ.” nurowárɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ámá e epɨ́royɨ́ egɨ́áyo xewanɨŋo nánɨ re urɨnɨŋɨnigɨnɨ, “Nionɨ Xeroto nánɨ wáyɨ́ mɨninarɨŋagɨ aiwɨ nionɨ rɨxa úɨmɨgɨnɨ. Nionɨ sɨ́á árɨ́nɨ́ wíyo nurɨ Jerusaremɨ rémómɨ́árɨnɨ. Seyɨ́né ‘Wɨ́á rókiamoarɨgɨ́á womɨ amɨ amɨ nɨpɨkirɨ́ná ayɨ́ naŋɨ́manɨ. Jerusaremɨ nɨpɨkirɨ́náyɨ́ ayɨ́ ananɨrɨnɨ.’ yaiwiarɨŋagɨ́a nánɨ warɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","re urɨŋɨnigɨnɨ, “Jerusaremɨ ŋweáyɨ́né, wɨ́á rókiamoarɨgɨ́áwamɨ pɨkiro ámá Gorɨxo seyɨ́né nánɨ searowárɨ́áyo sɨ́ŋá tɨ́nɨ nearo pɨkiro yarɨgɨ́áyɨ́né, karɨ́karɨ́ xegɨ́ miá negirɨ xwioxɨ́yo mɨmeámɨ́ yarɨŋɨ́pa nionɨ íníná axɨ́pɨ e seaiayimɨnɨrɨ éagɨ aí seyɨ́né mɨseaimónarɨnɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Arɨ́á époyɨ. Aŋɨ́ Gorɨxo yeáyɨ́ nɨseayimɨxemearɨ́ná seyɨ́né ŋweanɨrɨ egɨ́e rɨxa anɨpá imónɨgoɨ. Nionɨ sɨŋwɨ́ mɨnanɨpa néra nuro rɨxa ‘Ámɨnáo urowáráná weapɨnɨ́o oyá dɨŋɨ́ tɨ́nɨ yayɨ́ winɨpaxorɨnɨ.’ nɨrɨróná ámɨ sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabarɨ́á wɨyimɨ Parisiowa wigɨ́ ámɨná wo Jisasomɨ “Yawawi nurai nionɨyá aŋɨ́yo aiwá onaiyɨ.” urɨ́agɨ Jisaso nɨpáwirɨ ŋweaŋáná awa omɨ sɨŋwɨ́ wɨnaxɨ́dɨŋáná ");
INSERT INTO aak_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ámá wo —O xegɨ́ sɨkwɨ́ anɨŋɨ́ mɨnekwɨdoárɨŋorɨnɨ. O Jisasoyá sɨ́mɨmaŋɨ́ tɨ́ŋɨ́mɨnɨ ŋweaŋagɨ Jisaso e nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwamɨ tɨ́nɨ Parisiowamɨ tɨ́nɨ xwɨyɨ́á bɨ nurɨrɨ́ná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Sabarɨ́áyo soyɨ́né ámá sɨmɨxɨ́ egɨ́áyɨ́ naŋɨ́ nimɨxɨrɨ́náyɨ́, ‘Ayɨ́ ananɨrɨnɨ.’ rɨyaiwiarɨŋoɨ? ‘Ŋwɨ́áxɨnɨ.’ rɨyaiwiarɨŋoɨ?” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","awa pɨ́né marɨ́ wimónɨŋagɨ́a Jisaso sɨkwɨ́ mɨnekwɨdoŋomɨ wé seáyɨ e nɨwikwiárɨrɨ ɨ́á nɨxɨrɨrɨ naŋɨ́ nɨwimɨxɨrɨ xegɨ́ aŋɨ́ e nánɨ nurowárɨmáná ");
INSERT INTO aak_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","awamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né woxɨ dɨxɨ́ íworanɨ, burɨmákaúranɨ, Sabarɨ́á ayo aiwɨ mínɨŋwɨ́ iniɨgɨ́ rɨwoŋɨ́yo piéróáná apaxɨ́ mé mɨmɨxeaarɨŋɨ́ranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pimɨ Sabarɨ́áyo ámáyo arɨrá nɨwirɨ́ná nánɨ rɨ́wamɨŋɨ́ meánɨŋagɨ nánɨ awa xwɨyɨ́á bɨ murɨpaxɨ́ wimónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisaso awa tɨ́nɨ aiwá nɨnɨrɨ nɨŋwearɨ́ná ámá aiwá nánɨ urepeárɨ́áyɨ́ xámɨ sɨ́mɨ́ sɨ́mɨ́ e oŋweaaneyɨnɨrɨ nɨ́wiapɨro wenɨŋɨ́ éagɨ́a Jisaso sɨŋwɨ́ e nɨwɨnɨrɨ rɨxa nɨ́nɨ nɨ́wiapɨro aiwá narɨ́ná o ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Woxɨ woxɨ apɨxɨ́ meánɨnɨ nánɨ aiwá imɨxɨ́ápɨ nánɨ rɨrepeáráná joxɨ nurɨ sɨ́mɨ́ sɨ́mɨ́ imónɨŋe mɨŋweapa éɨrɨxɨnɨ. Ámá urepeárɨ́á wo joxɨ seáyɨ e rɨmúroŋo enɨ nɨbɨrɨ́náyɨ́, ");
INSERT INTO aak_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ámá aiwá apɨ nánɨ earepeárɨ́o joxɨ ŋweaŋe nɨbɨrɨ re rɨnɨŋoɨ, ‘Joxɨ ŋweaŋɨ́ re o ŋweanɨŋoɨ.’ rɨráná joxɨ ayá néra nurɨ iwɨyɨ́á jɨ́amɨ ŋwearɨ́árɨnɨ. ‘Iwɨyɨ́á jɨ́amɨ ŋweaɨ.’ rɨrɨpɨ́rɨxɨnɨrɨ sɨ́mɨ́ sɨ́mɨ́ imónɨŋe mɨŋweapa éɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Rɨrepeáráná joxɨ nurɨ iwɨyɨ́á jɨ́e ŋwearɨ́ɨnɨ. Rɨrepeárɨ́o joxɨ iwɨmɨ ŋweaŋagɨ nɨranɨrɨ re rɨrɨnɨgɨnɨ, ‘Gɨ́ nɨkumɨxɨnɨrɨ emearɨgwɨ́íoxɨnɨ, joxɨ nurɨ áwɨnɨ dae ŋweaɨ.’ rɨráná ámá oxɨ́ apɨxɨ́ awí neánɨro joxɨ tɨ́nɨ aiwá narɨgɨ́áyɨ́yá sɨŋwɨ́yo dánɨ joxɨ ámɨnáoxɨ́nɨŋɨ́ imónɨrɨ́ɨnɨ.” Ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","re urɨŋɨnigɨnɨ, “Ámá go go xewanɨŋo weyɨ́ menɨ́o rɨ́wéná Gorɨxo wimɨxáná ayá nerɨ xwɨrɨ́á nimóga unɨ́árɨnɨ. Go go weyɨ́ mɨmenɨ́ waunɨ́ ikárɨnɨ́o omɨ Gorɨxo weyɨ́ umenɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","14","Ámɨ xwɨyɨ́á rɨpɨ aiwá apɨ nánɨ urepeárɨ́omɨ re urɨŋɨnigɨnɨ, “Ámá nánɨ aiwá rɨyamɨ́ nerɨ́náyɨ́ dɨxɨ́ nɨkumɨxɨnɨrɨ emearɨgɨ́áyɨ́ranɨ, rɨrɨxɨ́meáowaranɨ, dɨxɨ́ ámá axɨ́ joxɨyáyɨ́ranɨ, ámá aŋɨ́ axɨ́ e dáŋɨ́ amɨpí mɨmúrónɨgɨ́áyɨ́ranɨ, ayɨ́ rɨ́wéná joxɨ enɨ aiwá nánɨ rɨrepeáráná ayɨ́yá enɨ joxɨyá nɨgɨ́ápa axɨ́pɨ nɨmɨgɨnɨrɨ ayo murepeárɨpa éɨrɨxɨnɨ. Aiwá rɨyamɨ́ nerɨ́ná ámá uyípeayɨ́yo tɨ́nɨ ámá wará minɨŋɨ́yo tɨ́nɨ sɨkwɨ́ ikɨ́ egɨ́áyo tɨ́nɨ sɨŋwɨ́ supárɨgɨ́áyo tɨ́nɨ nurepeárɨrɨ́náyɨ́, ámá e imónɨgɨ́áyɨ́ joxɨ wí rɨyamɨ́ nerɨ siapɨpaxɨ́ meŋagɨ nánɨ rɨ́wéná ámá wé rónɨgɨ́á wiápɨ́nɨmeááná Gorɨxo mí ómómɨxɨmɨ́ nerɨ́ná xewanɨŋo joxɨyá nánɨ siapɨnɨ́á eŋagɨ nánɨ yayɨ́ seáyɨmɨ dánɨ osinɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ámá wo awa tɨ́nɨ nɨŋwearo aiwá narɨgɨ́o Jisaso e urarɨŋagɨ arɨ́á nɨwirɨ nɨwiápɨ́nɨmearɨ omɨ re urɨŋɨnigɨnɨ, “Ámá Gorɨxoyá xwioxɨ́yo nɨpáwirɨ nɨŋwearɨ aiwá nɨpɨ́rɨ́á gɨyɨ́ gɨyɨ́ ananɨ oyá dɨŋɨ́ tɨ́nɨ yayɨ́ winɨpaxɨ́yɨ́rɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","o ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Ámá wo ámá obaxɨ́ nurepeárɨmáná aiwá xwé rɨyamɨ́ nerɨ ");
INSERT INTO aak_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","rɨxa rɨyamɨ́ nɨyárɨ́ɨsáná ámá xegɨ́ xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋomɨ ‘Ámá nionɨ urepeárɨmeŋáyo “Bɨ́poyɨ. Aiwá rɨxa rɨyamɨ́ inárɨnɨ.” urɨmeɨ.’ wáɨ́ urowárɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ámá nɨ́nɨ áxeŋwarɨ́nɨŋɨ́ niga nuro ‘Aiwá apɨ nánɨ banɨméwɨnɨ. Banɨméwɨnɨ.’ nurɨróná ámá xámɨ nurɨ wáɨ́ wímeáo re urɨŋɨnigɨnɨ, ‘Gɨ́ xwɨ́á bɨ bɨ́ éáonɨ nurɨ sɨŋwɨ́ wɨnɨmɨ eŋagɨ nánɨ aiwá nánɨ bɨpaxɨ́ menɨnɨ. Xe xegɨ́ kikiɨ́á ounɨrɨ sɨŋwɨ́ naneɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","omɨŋɨ́ wiiarɨŋo nurɨ ámá ámɨ womɨ wáɨ́ wímeááná o enɨ re urɨŋɨnigɨnɨ, ‘Burɨmákaú omɨŋɨ́ enɨ́a nánɨ wé wúkaú bɨ́ éáonɨ nurɨ waú waú maxɨrɨnɨ́ nɨkumɨxára nurɨ iwamɨ́ó emɨ eŋagɨ nánɨ aiwá nánɨ bɨpaxɨ́ menɨnɨ. Xe xegɨ́ kikiɨ́á ounɨrɨ sɨŋwɨ́ naneɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","o ámá ámɨ womɨ wáɨ́ wímeááná o enɨ re urɨŋɨnigɨnɨ, ‘Apɨxɨ́ sɨŋɨ́ meááonɨ eŋagɨ nánɨ bɨpaxɨ́manɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","omɨŋɨ́ wiiarɨŋo nurɨ xegɨ́ boso, aiwá rɨyamɨ́ nɨyárɨrɨ ŋweaŋomɨ áwaŋɨ́ urémeááná wikɨ́ nónɨrɨ xegɨ́ omɨŋɨ́ wiiarɨŋomɨ re urɨŋɨnigɨnɨ, ‘Aŋɨ́nɨ nurɨ aŋɨ́ rɨpɨ rɨpimɨ óɨ́yo nemerɨ ámá uyípeayɨ́yo tɨ́nɨ wará minɨŋɨ́yo tɨ́nɨ sɨkwɨ́ ikɨ́ egɨ́áyo tɨ́nɨ sɨŋwɨ́ supárɨgɨ́áyo tɨ́nɨ nionɨyá aŋɨ́ re nánɨ nɨwirɨmeaamemɨ beɨ.’ urowárɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","o nurɨ xɨ́o urɨ́ɨ́pa nememɨ nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Bosoxɨnɨ, nionɨ joxɨ nɨrɨ́ɨ́pa néagɨ aiwɨ íkwiaŋwɨ́ wí sɨnɨ anɨpá imónɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","boso re urɨŋɨnigɨnɨ, ‘Aiwá rɨpɨ nánɨ gɨ́ aŋɨ́ magwɨ́ epɨ́rɨ nurɨ omɨŋɨ́ óɨ́ amɨ amɨ inɨŋɨ́yo nemerɨ ámá omɨŋɨ́ yarɨgɨ́áyo mɨxeaameɨ.’ urowárɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","o nurɨ xɨxenɨ éáná boso ámá aiwá nánɨ awí eánɨgɨ́áyo re urɨŋɨnigɨnɨ, ‘Nionɨ “Ámá xámɨ aiwá nánɨ urepeárɨmeŋáyɨ́ aiwá wí aíwɨ́ mepɨ́rɨméoɨ.” seararɨŋɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso Judayɨ́ “Nene ámá xámɨ aiwá nánɨ urepeárɨméɨ́yɨ́nɨŋɨ́ imónɨŋagwɨ nánɨ rɨ́a neararɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á apɨ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ámá oxɨ́ apɨxɨ́ epɨ́royɨ́ egɨ́áyɨ́ o tɨ́nɨ óɨ́yo nuróná o nɨkɨnɨmónɨrɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ámá go go nionɨ tɨ́ámɨnɨ nɨbɨrɨ ‘Wiepɨsarɨŋɨ́ oyáonɨ oimónɨmɨnɨ.’ nɨwimónɨrɨ́náyɨ́, Jisasonɨ dɨŋɨ́ sɨxɨ́ nɨyiŋɨ́pɨ o xegɨ́ xanomɨ uyiŋɨ́pɨranɨ, xɨnáímɨ uyiŋɨ́pɨranɨ, xiepímɨ uyiŋɨ́pɨranɨ, xegɨ́ niaíwɨ́yo uyiŋɨ́pɨranɨ, xexɨrɨ́meáyo uyiŋɨ́pɨranɨ, seáyɨ e mɨmúropa nerɨ́náyɨ́ o gɨ́ wiepɨsarɨŋáyɨ́ wo imónɨpaxɨ́ menɨnɨ. Go go Jisasonɨ nánɨ dɨŋɨ́ sɨpí wiarɨŋɨ́pɨ xewanɨŋo dɨŋɨ́ sɨpí yaiwinarɨŋɨ́pimɨ seáyɨ e mɨmúropa nerɨ́náyɨ́ o gɨ́ wiepɨsarɨŋáyɨ́ wo imónɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ámá go go nionɨ nɨnɨxɨ́dɨrɨ́ná ‘Nionɨ Jisasomɨ xɨ́darɨŋagɨ nánɨ ámá wí xeanɨŋɨ́ nikárɨrɨ aiwɨ anɨŋɨ́ xɨ́dɨmɨ́árɨnɨ.’ mɨyaiwipa nerɨ́náyɨ́ o gɨ́ wiepɨsarɨŋáyɨ́ wo imónɨpaxɨ́manɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ewayɨ́ ikaxɨ́ re urɨŋɨnigɨnɨ, “Seyɨ́né woxɨ aŋɨ́ sepiá wiwá nɨmɨra opeyimɨnɨrɨ́ná xámɨ éɨ́ nɨŋweámáná aŋɨ́ iwá mɨrɨrɨ nánɨ dɨŋɨ́ neŋwɨperɨ ‘Nɨgwɨ́ ararɨrɨ́anɨ?’ nɨyaiwirɨ ‘Nɨgwɨ́ nionɨyá ananɨ aŋiwá tɨ́nɨ xɨxenɨrɨ́anɨ?’ yaiwinarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","‘Nɨgwɨ́ ararɨrɨ́anɨ?’ nɨrɨrɨ meyíropa nerɨ rɨxa sɨ́ŋá nɨkɨkíróa nɨpeyirɨ́ná nɨgwɨ́ anɨpá imónɨŋagɨ nánɨ aŋɨ́ mɨramɨ́xwɨ́nɨ́ nɨyárɨmɨ úáná ámá aŋɨ́ iwámɨ nɨwɨnɨrɨ́ná joxɨ nánɨ rɨperɨrɨ́ nɨyayiro ");
INSERT INTO aak_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","re rɨpɨ́rɨ́árɨnɨ, ‘Ámá ro aŋɨ́ iwá mɨrɨmɨnɨrɨ éɨ́ aiwɨ niwánɨ mɨrɨpaxɨ́ mɨwimónɨ́agɨ nɨmɨramɨ́xwɨ́nárɨmɨ uŋɨ́rɨnɨ.’ rɨpɨ́rɨ́árɨnɨ.” nurɨrɨ Jisaso ámá nionɨ nɨxɨ́darɨgɨ́áyɨ́ aŋɨ́ mɨramɨ́xwɨ́nɨ́ nerónɨŋɨ́ nionɨ pɨ́nɨ nɨnɨwiárɨmɨ upɨ́rɨxɨnɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ewayɨ́ xwɨyɨ́á axɨ́pɨ ámɨ bɨ re urɨŋɨnigɨnɨ, “Mɨxɨ́ ináyɨ́ wo xegɨ́ sɨmɨŋɨ́ wínarɨgɨ́áyɨ́ ámá nɨ́nɨ 10,000 imónɨŋáná mɨxɨ́ ináyɨ́ jɨ́amɨ dáŋoyá sɨmɨŋɨ́ wínarɨgɨ́áyɨ́ ámá 20,000 imónɨŋagɨ nánɨ o xámɨ éɨ́ nɨŋwearɨ dɨŋɨ́ nɨyaikirorɨ ‘Mɨxɨ́ ninɨróná ananɨ xopɨrárɨ́ wimɨnɨréɨnɨ? Eŋɨ́ mɨwínɨpa emɨnɨréɨnɨ?’ yaiwinɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Rɨxa ‘Mɨxɨ́ ináyo xopɨrárɨ́ ninɨŋoɨ.’ nɨyaiwirɨ́náyɨ́ wɨ́o sɨnɨ ná jɨ́amɨ ŋweaŋáná xegɨ́ ámá wíyo re urowárɨnɨŋoɨ, ‘Nuro omɨ re urémeápoyɨ, “Negɨ́ mɨxɨ́ ináyo re rarɨnɨ urémeápoyɨ, ‘None soyɨ́né tɨ́nɨ mɨxɨ́ xɨxe seaipaxɨ́ menɨnɨ. Pí pí nearɨ́ɨ́yɨ́ nɨyanɨ́wárɨnɨ rarɨnɨ.’” urémeápoyɨ.’ urowárɨnɨŋoɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Seyɨ́né woxɨ dɨxɨ́ iyɨ́á ɨ́á amɨpí nánɨ dɨŋɨ́ yaíkiá mɨmopa nerɨ́náyɨ́ ayɨ́ gɨ́ siepɨsarɨŋáoxɨ imónɨrɨméɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","re urɨŋɨnigɨnɨ, “Ayɨnánɨ saxɨ́ awɨ́í yarɨŋɨ́ aiwɨ awɨ́í yarɨŋɨ́pɨ anɨpá nerɨ aiwánɨŋɨ́ imónɨŋáná ámɨ arɨge éáná awɨ́í enɨŋoɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sikɨ́ amɨpí omɨŋɨ́yo aiwá xwé oenɨrɨ wiároarɨgɨ́a aiwɨ saxɨ́ awɨ́í anɨpá imónáná aiwá urɨ́ enɨgɨnɨrɨ omɨŋɨ́yo wiáropaxɨ́ menɨnɨ. Anɨŋɨ́nɨ emɨ moarɨgɨ́árɨnɨ. Ámá gɨyɨ́né arɨ́á tɨ́gɨ́áyɨ́né arɨ́á ókiarɨ́ nɨmónɨ́poyɨ.” Jisaso xegɨ́ wiepɨsarɨŋɨ́yɨ́ saxɨ́nɨŋɨ́ imónɨŋagɨ nánɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ámá takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́á —Ayɨ́ émáyɨ́ gapɨmanowamɨ wipɨ́rɨ́a nánɨ wigɨ́ Judayo nɨgwɨ́ nɨwurápɨyiróná wigɨ́ meapɨ́rɨ́a nánɨ enɨ ámɨ bɨ ɨ́wɨ́ uráparɨgɨ́áyɨ́rɨnɨ. Ayɨ́ tɨ́nɨ ɨ́wɨ́ yarɨgɨ́á wínɨyɨ́ tɨ́nɨ Jisasomɨ xwɨyɨ́á arɨ́á wianɨro nánɨ aŋwɨ e barɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisiowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ sɨŋwɨ́ e nɨwɨnɨro mepí “Iyɨ́ tɨnarɨŋoɨ.” nɨrɨnɨro wigɨ́pɨ re rɨnɨgɨ́awixɨnɨ, “Ámá o ɨ́wɨ́ yarɨgɨ́áyo nɨmímɨnɨrɨ aiwá nawínɨ enɨ narɨgɨ́árɨnɨ.” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jisaso ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Soyɨ́né ámá woxɨ sipɨsipɨ́ 100 tɨ́ŋoxɨ wo anɨ́á imónánáyɨ́, amɨ́ eaŋɨ́yo dánɨ sipɨsipɨ́ 99 wínɨyɨ́ e nɨwárɨmoxɨ nurɨ anɨ́á imónɨ́o nánɨ pɨ́á néra núɨsáná rɨxa wɨnɨmearɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nɨwɨnɨmearɨ́ná nɨmearɨ yayɨ́ tɨ́nɨ xwaŋwɨ́ níkwónɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aŋɨ́ e nɨrémorɨ́ná dɨxɨ́ nɨkumɨxɨnɨrɨ emearɨgɨ́áyo tɨ́nɨ ámá aŋɨ́ axɨ́ e ŋweagɨ́áyo tɨ́nɨ rɨ́aiwá re urɨmerɨ́árɨnɨ, ‘Gɨ́ sipɨsipɨ́ anɨ́á imónɨ́o rɨxa pɨ́á nerɨ meáagɨ nánɨ nionɨ tɨ́nɨ nawínɨ yayɨ́ oyaneyɨ.’ urɨrɨ́árɨnɨ.” Jisaso ámá ɨ́wɨ́ yarɨgɨ́á o tɨ́ámɨnɨ barɨgɨ́áyɨ́ sipɨsipɨ́ anɨ́á imónɨ́o yapɨ imónɨŋagɨ́a nánɨ ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","re urɨŋɨnigɨnɨ, “Nionɨ re seararɨŋɨnɨ, ‘Ámá sipɨsipɨ́ nánɨ pɨ́á nerɨ nɨmearɨ nánɨ yayɨ́ éɨ́pa aŋɨ́najowa ámá ɨ́wɨ́ yarɨŋɨ́ wo nɨsanɨrɨ yarɨŋagɨ nɨwɨnɨróná yayɨ́ nero aí ámá 99 “Rɨxa wé rónɨŋwaénerɨnɨ. Nene sanɨŋɨ́ imónɨpaxɨ́ menɨnɨ.” yaiwinarɨgɨ́áyɨ́ nánɨ aŋɨ́najowa yayɨ́ yarɨgɨ́ámanɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ámɨ ewayɨ́ xwɨyɨ́á axɨ́pɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Apɨxɨ́ wí nɨgwɨ́ wé wúkaú tɨ́ŋí nɨgwɨ́ wo nɨmiáperɨ́náyɨ́ uyɨ́wɨ́ nɨmɨxároárɨmáná píránɨŋɨ́ pɨ́á nerɨ aŋɨ́ síyɨ́ nɨperɨ wɨnɨmeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nɨwɨnɨmearɨ́ná xegɨ́ imánɨŋɨ́ yarɨgɨ́íwamɨ tɨ́nɨ aŋɨ́ axɨ́ e ŋweagɨ́áyo tɨ́nɨ rɨ́aiwá re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ niínɨ miápéáo rɨxa meáagɨ nánɨ niínɨ tɨ́nɨ nawínɨ yayɨ́ oyaneyɨ.’ urɨŋɨnigɨnɨ.” Jisaso ámá ɨ́wɨ́ yarɨgɨ́á o tɨ́ámɨnɨ barɨgɨ́áyɨ́ nɨgwɨ́ miápéɨ́ yapɨ imónɨŋagɨ́a nánɨ ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","re urɨŋɨnigɨnɨ, “Nionɨ re seararɨŋɨnɨ, ‘Nɨgwɨ́ apɨxí nɨmiáperɨ pɨ́á nerɨ ámɨ meáo nánɨ́nɨŋɨ́ yayɨ́ éɨ́pa Gorɨxoyá aŋɨ́najowa ámá ɨ́wɨ́ yarɨŋɨ́ wo nɨsanɨrɨ yarɨŋagɨ nɨwɨnɨrɨ́ná yayɨ́ e yarɨgɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","E nurɨmáná ámɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Ámá wo xegɨ́ niaíwɨ́ oxɨ́ waú tɨ́ŋo ");
INSERT INTO aak_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","—Xogwáo xanomɨ nɨwiápɨ́nɨmearɨ re urɨŋɨnigɨnɨ, ‘Ápe, joxɨ nɨpéáná “Amɨpí omɨ wíɨmɨgɨnɨ.” yaiwiarɨŋɨ́pɨ rɨxa niapeɨ.’ urɨ́agɨ xano ‘Amɨpí rɨ́wéná yaŋɨ́ nɨmerɨ nionɨ wíɨmɨgɨnɨ.’ yaiwiarɨŋɨ́yɨ́ rɨxa awaúmɨ yaŋɨ́ numeirɨ mɨnɨ nɨwimáná eŋáná ");
INSERT INTO aak_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","rɨxa sɨ́á árɨ́nɨ́ óráná xogwáo o xegɨ́nɨ awí eámeámɨ́ nerɨ nɨmeámɨ aŋɨ́ wímɨ ná jɨ́amɨ nánɨ nurɨ aŋɨ́ ayo nɨŋwearɨ́ná uyɨ́niɨ́ nerɨ xegɨ́ nɨgwɨ́ amɨpí xano wiŋɨ́yɨ́ xwɨrɨxwɨrɨ́á ikɨxeŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Xegɨ́ nɨgwɨ́ xwɨrɨxwɨrɨ́á nikɨxerɨ ámáyo nɨwiememáná eŋáná re eŋɨnigɨnɨ. Ámá aŋɨ́ ayo dáŋɨ́yɨ́ aiwá nánɨ dɨ́wɨ́ nikeamónɨro yarɨ́ná o rɨxa uyípeayo imónɨ́ɨ́ eŋagɨ nánɨ o enɨ aiwá nánɨ dɨ́wɨ́ nikeamónɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","nurɨ ámá aŋɨ́ ayo dáŋɨ́ womɨ nɨgwɨ́ omɨŋɨ́ nánɨ rɨxɨŋɨ́ urɨ́agɨ o omɨŋɨ́ Judayɨ́ nɨ́nɨ xwɨrɨ́á winarɨŋɨ́pɨ nánɨ re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́yo nánɨ nurɨ gɨ́ odɨpíyo aiwá nɨwiiɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","o nurɨ omɨŋɨ́ e nerɨ́ná rɨxa agwɨ́ eŋɨ́ mɨwínárɨ́agɨ aiwá pɨ́á odɨpí narɨŋɨ́pɨ nɨpaxɨ́ wimónɨ́agɨ aiwɨ ámá wí omɨ aiwá bɨ mɨnɨ mɨwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","E eŋáná o ámɨ dɨŋɨ́ ɨ́á nɨxɨrɨrɨ re yaiwiŋɨnigɨnɨ, ‘Gɨ́ ápoyá omɨŋɨ́ wiiarɨgɨ́áyɨ́ nɨ́nɨ aiwá apánɨ nɨpɨ́rɨ nánɨ múrónɨŋagɨ aiwɨ nionɨ re nɨŋwearɨ aiwá agwɨ́ nánɨ nɨpémɨnɨrɨ rɨyarɨŋɨnɨ? ");
INSERT INTO aak_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nionɨ nɨwiápɨ́nɨmeámɨ nurɨ gɨ́ ápomɨ re urémeáɨmɨgɨnɨ, “Ápe, nionɨ ɨ́wɨ́ Gorɨxomɨ wikárɨrɨ joxɨ sikárɨrɨ éanigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nionɨ naŋɨ́ mimónɨŋagɨ nánɨ sɨnɨ dɨxɨ́ riwaxonɨ imónɨpaxɨ́ menɨnɨ. Joxɨ ‘Gɨ́ omɨŋɨ́ niiarɨŋoxɨ́nɨŋɨ́ imónɨŋoxɨnɨ.’ nɨreɨ.” Ápomɨ e urémeáɨmɨgɨnɨ.’ nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","nɨwiápɨ́nɨmeámɨ xano tɨ́ŋɨ́ e nánɨ nurɨ nurɨ rɨxa aŋwɨ e báná xano xegɨ́ xewaxo jɨ́iwo barɨŋagɨ nɨwɨnɨrɨ wá nɨwianɨrɨ mɨ́rɨ́ nurɨ nɨmakɨ́kɨyirɨ kíyɨ́ miaúnáná ");
INSERT INTO aak_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","xewaxo re urɨŋɨnigɨnɨ, ‘Ápoxɨnɨ, nionɨ Gorɨxomɨ ɨ́wɨ́ wikárɨrɨ joxɨ sikárɨrɨ eŋárɨnɨ. Nionɨ ámá naŋɨ́ mimónɨŋagɨ nánɨ sɨnɨ dɨxɨ́ riwaxonɨ imónɨpaxɨ́ menɨnɨ.’ urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","xano omɨŋɨ́ wiiarɨgɨ́áyo rɨ́aiwá re urɨŋɨnigɨnɨ, ‘Soyɨ́né rapɨrapɨ́ imɨrɨŋɨ́ mimónɨŋú aŋɨ́nɨ nɨmeámɨ nɨbɨrɨ uyírɨ́poyɨ. Omɨ okiyɨ́á numerɨ́ná wé ramaxɨ́ wá wéyo uyírárɨro sɨkwɨ́ sú uyírɨro époyɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","E nemáná burɨmákaú sɨpɨkɨ́ ikwanɨ́ imónarɨŋo nɨmeámɨ nɨbɨro pɨkípoyɨ. Nene nɨnɨrane íwo nánɨ yayɨ́ oyaneyɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nɨgɨ́ íwɨ́ ro peŋónɨŋɨ́ imónɨŋo ámɨ́nɨŋɨ́ wiápɨ́nɨmeaŋoɨ. “Anɨ́nɨŋɨnigɨnɨ.” yaiwiagwá ro ámɨ neaímeáagɨ nánɨ yayɨ́ yanɨ aiwá oimɨxaneyɨ.’ urɨ́agɨ awa o urɨ́ɨ́pa nero rɨxa aiwá rɨyamɨ́ nero yayɨ́ seáyɨmɨ dánɨ néra warɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Xewaxo xámɨŋo omɨŋɨ́yo yarɨŋɨ́mɨ dánɨ nɨbɨrɨ rɨxa aŋɨ́ tɨ́ŋɨ́ e aŋwɨ e dánɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Soŋɨ́ rɨro sɨmɨnɨŋɨ́ ero yarɨŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","omɨŋɨ́ wiiarɨgɨ́á womɨ rɨ́aiwá nurɨrɨ o rɨxa aŋwɨ e báná re urɨŋɨnigɨnɨ, ‘Ayɨ́ pí nánɨ nerɨ rarɨŋoɨ?’ uráná ");
INSERT INTO aak_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","o re urɨŋɨnigɨnɨ, ‘Dɨxɨ́ rɨgwáo rɨxa rémónapɨŋoɨ. O rɨ́nɨŋɨ́ wí mɨmeá naŋo emeago dɨxɨ́ ápomɨ wímeáagɨ nánɨ o burɨmákaú sɨpɨkɨ́ ikwanɨ́ imónarɨŋo pɨkiŋoɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","o wikɨ́ nónɨrɨ mɨpáwipaxɨ́ nɨwimónɨrɨ wáɨ́ e roŋáná xano nɨpeyearɨ pɨyɨpɨyɨ́ xwɨyɨ́á urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","xanomɨ mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, ‘Nionɨ rɨnáínɨ́nɨŋɨ́ nimónɨrɨ omɨŋɨ́ siiarɨ́ná xwiogwɨ́ obaxɨ́ nɨmúroarɨ́ná sekaxɨ́ amɨpí joxɨ nɨrɨ́ɨ́yɨ́ nánɨ nionɨ wí mɨrɨwiaíkiŋárɨnɨ. E nerɨ aí nionɨ gɨ́ nɨkumɨxɨnɨrɨ emearɨŋáyɨ́ tɨ́nɨ yayɨ́ yanɨ nánɨ memé miá aí wo mɨniapɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nionɨ mɨniapɨpa nerɨ aiwɨ dɨxɨ́ riwaxo, apɨxɨ́ iyɨ́ ede dánɨ oikɨxearɨgɨ́íwa tɨ́nɨ nemerɨ́ná dɨxɨ́ nɨgwɨ́ xwé nowárɨŋo nánɨ burɨmákaú sɨpɨkɨ́ ikwanɨ́ imónarɨŋo apánɨ upɨkiíɨnɨ.’ uráná ");
INSERT INTO aak_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","xano re urɨŋɨnigɨnɨ, ‘Gɨ́ íwoxɨnɨ, “Nionɨyáyɨ́ wí ámɨ o nɨrápɨnɨ́árɨnɨ.” mɨyaiwipanɨ. Joxɨ íníná nionɨ tɨ́nɨ ŋwearɨŋoxɨ amɨpí áponɨyáyɨ́ nɨ́nɨ dɨxɨ́nɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","E nerɨ aí dɨxɨ́ rɨgwáo peŋónɨŋɨ́ imónɨŋo ámɨ́nɨŋɨ́ wiápɨ́nɨmeaŋoɨ. “Anɨ́nɨŋɨnigɨnɨ.” yaiwiagwáo ámɨ neaímeáagɨ nánɨ “Yayɨ́ mepa oyaneyɨ.” rɨsimónarɨnɨ? Oweoɨ, xe yayɨ́ oyaneyɨ.’ urɨŋɨnigɨnɨ.” Jisaso Parisiowa “None xɨráxogwáowaú xɨráónɨŋɨ́ imónɨŋagwɨ nánɨ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ nánɨ ewayɨ́ xwɨyɨ́á apɨ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","O ewayɨ́ xwɨyɨ́á rɨpɨ enɨ xegɨ́ wiepɨsarɨŋowamɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá amɨpí nɨ́nɨ mɨmúrónɨŋɨ́ wo o xegɨ́ bosɨwo nánɨ ámá wí nɨbɨro áwaŋɨ́ re urɨgɨ́awixɨnɨ, ‘Dɨxɨ́ bosɨwo dɨxɨ́ iyɨ́á ɨ́á amɨpí xwɨrɨ́á ikɨxearɨnɨ.’ urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","o bosɨwo nánɨ ‘Obɨnɨ.’ nurɨrɨ o rɨxa báná re urɨŋɨnigɨnɨ, ‘Pí éagɨ nánɨ joxɨ nánɨ xwɨyɨ́á wí rarɨŋagɨ́a wíanigɨnɨ? Amɨpí nionɨyá joxɨ nɨnɨmeirɨ́ná arɨge nɨnɨmeia warɨŋɨnɨ? Amɨpí nionɨyá pɨ́nɨ nɨnɨwiárimɨ urɨ nánɨ nɨ́nɨ ɨ́á nɨrorɨ bɨkwɨ́yo nɨŋwɨrárɨrɨ niapeɨ. Joxɨ sɨnɨ gɨ́ bosɨwɨ́ nimónɨrɨ ŋwearɨméɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","bosɨwo nurɨ re yaiwiŋɨnigɨnɨ, ‘Nionɨ bosɨwɨ́ roarɨŋáyɨ́ boso “Joxɨ kikiɨ́á uɨ.” nɨránáyɨ́ arɨ emɨ́árɨ́anɨ? Bosɨwɨ́ nimónɨrɨ yarɨŋáonɨ xwɨ́á nɨmirɨ́ná eŋɨ́ meánɨ́ emɨ́árɨ́anɨ? Rɨxɨŋɨ́ nura nurɨ́ná ayá ninɨnɨ́árɨ́anɨ?’ nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","re yaiwiŋɨnigɨnɨ, ‘Ai, pí pí éɨmɨgɨnɨrɨ rɨxa nɨjɨ́á imónɨŋɨnɨ. Gɨ́ boso “Joxɨ kikiɨ́á uɨ.” nɨránáyɨ́ ámá nionɨ wigɨ́ aŋɨ́yo nánɨ ananɨ nɨmímɨnɨpɨ́rɨ nánɨ pí pí éɨmɨgɨnɨrɨ rɨxa nɨjɨ́á imónɨŋɨnɨ.’ nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ámá o xegɨ́ boso nɨgwɨ́ wayá rɨ́wéná niapɨ́ɨ́rɨxɨnɨrɨ wiŋɨ́yo ‘Bɨ́poyɨ.’ nurɨrɨ awa rɨxa báná xámɨ bɨ́omɨ re urɨŋɨnigɨnɨ, ‘Gɨ́ boso pí siapɨŋɨ́ nánɨ rɨ́wéná rɨrápɨnɨ́árɨnɨ?’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","re urɨŋɨnigɨnɨ, ‘Werɨxɨ́ sɨxɨ́ ínɨŋɨ́ dɨramɨxɨ́ 100 niapɨŋɨ́ nánɨ xɨxenɨ axɨ́pɨ nɨrápɨnɨ́árɨnɨ.’ urɨ́agɨ bosɨwo re urɨŋɨnigɨnɨ, ‘Dɨxɨ́ bɨkwɨ́ nɨgwɨ́ nánɨ ŋwɨrárarɨŋɨ́namɨ nɨmearɨ éɨ́ nɨŋweámáná werɨxɨ́ sɨxɨ́ ínɨŋɨ́ dɨramɨxɨ́ 100 nánɨ eánɨŋe nɨkwɨ́rɨrɨ 50 ŋwɨráreɨ.’ nurɨrɨ́ná xɨ́o enɨ bosoyá bɨkwɨ́yo axɨ́pɨ dɨramɨxɨ́ 100 nánɨ eánɨŋɨ́pɨ nɨkwɨ́rɨrɨ ámɨ 50 ŋwɨrárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ámá ámɨ wo báná bosɨwo yarɨŋɨ́ re wiŋɨnigɨnɨ, ‘Gɨ́ boso joxɨ siapɨŋɨ́yɨ́ ararɨrɨnɨ?’ urɨ́agɨ o re urɨŋɨnigɨnɨ, ‘O witɨ́ ɨ́á 1000 nionɨ niapɨŋɨ́ nánɨ xɨxenɨ axɨ́pɨ nɨrápɨnɨ́árɨnɨ.’ urɨ́agɨ bosɨwo re urɨŋɨnigɨnɨ, ‘Dɨxɨ́ bɨkwɨ́yo witɨ́ ɨ́á 1000 nánɨ ŋwɨrárɨnɨŋe nɨkwɨ́rɨrɨ witɨ́ ɨ́á 800 ŋwɨráreɨ.’ nurɨrɨ́ná bosoyá bɨkwɨ́yo enɨ nɨkwɨ́rɨrɨ axɨ́pɨ nɨŋwɨrárɨrɨ womɨ womɨ nɨ́nɨ e néra uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Boso xegɨ́ yapɨ́ wíwapɨyarɨŋɨ́ bosɨwo nánɨ ‘O “Nionɨ onɨmímɨnɨ́poyɨ.” nɨyaiwirɨ e éɨ́rɨnɨ.’ rarɨŋagɨ́a arɨ́á e nɨwirɨ o nánɨ ‘Dɨŋɨ́ émɨ saímɨ́ moŋorɨnɨ.’ nɨyaiwirɨ seáyɨ e umeŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ wiepɨsarɨŋɨ́yo ámɨ bɨ rɨpɨ urɨŋɨnigɨnɨ, “Ámá agwɨ ríná amɨpí xwɨ́á tɨ́yo weŋɨ́pɨ nánɨ dɨŋɨ́ nɨkwɨ́roro yarɨgɨ́áyɨ́ wigɨ́ wínɨyɨ́ tɨ́nɨ ninɨróná dɨŋɨ́ émɨ saímɨ́ nɨmoro nero nánɨ ámá nionɨ dɨŋɨ́ nɨnɨkwɨ́roro yarɨgɨ́áyo seáyɨ e imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ayɨnánɨ re seararɨŋɨnɨ, ‘Nɨgwɨ́pɨ ámá wí apɨ tɨ́nɨ sɨpí imɨxarɨgɨ́á aiwɨ soyɨ́né uyípeayɨ́ wí negɨ́ nɨkumɨxɨnɨrɨ emearɨŋwáyɨ́nɨŋɨ́ imónɨpɨ́rɨ nánɨ nɨgwɨ́pɨ tɨ́nɨ arɨrá wíɨ́rɨxɨnɨ. E nerɨ́náyɨ́ rɨ́wéná sɨ́á yoparɨ́yimɨ nɨgwɨ́ nɨ́nɨ rɨxa anɨpá imónáná Gorɨxo soyɨ́né xegɨ́ aŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ eŋɨ́yo páwipɨ́rɨ́a nánɨ seamímɨnɨnɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ámá omɨŋɨ́ onɨmiápia nerɨ́ná píránɨŋɨ́ dɨŋɨ́ nɨkwɨ́roro xɨxenɨ yarɨgɨ́á gɨyɨ́ gɨyɨ́ xwé enɨ xɨxenɨ yarɨgɨ́árɨnɨ. Ámá omɨŋɨ́ onɨmiápia nerɨ́ná dɨŋɨ́ nɨkwɨ́roro mé ámáyá sɨŋwɨ́yo dánɨ nɨwiepɨsiro omɨŋɨ́ yarɨgɨ́á gɨyɨ́ gɨyɨ́ omɨŋɨ́ xwé nánɨ aí axɨ́pɨ yarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ayɨnánɨ nɨgwɨ́ ámá wí nɨmearo ayɨ́ tɨ́nɨ sɨpí imɨxarɨgɨ́áyɨ́ soyɨ́né nɨgwɨ́ ayɨ́ aí tɨ́nɨ ámáyo mɨnɨ mɨwipa ero arɨrá mɨwipa ero nerɨ́náyɨ́ ‘Gorɨxo ananɨ xegɨ́ amɨpí naŋɨ́ aŋɨ́namɨ weŋɨ́yɨ́ none píránɨŋɨ́ umeianɨ́wá nánɨ neaiapɨnɨ́árɨnɨ.’ rɨyaiwiarɨŋoɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Soyɨ́né amɨpí ámá woyáyɨ́ sɨŋwɨ́ muwɨnaxɨ́dipa nerɨ́náyɨ́ omɨŋɨ́ soyɨ́néyápɨ mepɨ́rɨ́áyɨ́ go seaiapɨnɨ́árɨ́anɨ? Oweoɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ámá wo ámá waúyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiipaxɨ́ menɨnɨ. E nerɨ́náyɨ́ wɨ́omɨ dɨŋɨ́ sɨxɨ́ nuyirɨ wɨ́omɨ dɨŋɨ́ peá nɨmorɨ nerɨ wɨ́omɨ píránɨŋɨ́ ayá tɨ́nɨ nɨxɨ́dɨrɨ wɨ́omɨ peayɨ́ nɨwianɨrɨ enɨŋoɨ. Soyɨ́né nɨgwɨ́yɨ́yá omɨŋɨ́ wiiarɨŋɨ́nɨŋɨ́ nimónɨro ‘Nɨgwɨ́ wí mɨnɨmúropa oenɨ.’ nɨyaiwirɨ́náyɨ́, Gorɨxoyá omɨŋɨ́ wiiarɨŋɨ́ woxɨ́nɨŋɨ́ imónɨpaxɨ́ menɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jisaso xegɨ́ wiepɨsarɨŋowamɨ e urarɨ́ná Parisiowa —Awa nɨgwɨ́ nánɨ xwapɨ́ wimónarɨŋowarɨnɨ. Awa arɨ́á e nɨwiróná damɨ dánɨ rɨperɨrɨ́ umeararɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisaso e nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né ámáyá sɨŋwɨ́yo dánɨ ‘Wé rónɨŋwáonerɨnɨ.’ nɨrɨro yapɨ́ nɨwiepɨsiro rarɨgɨ́oyɨ́né aí Gorɨxo amɨpí segɨ́ xwioxɨ́yo ínɨmɨ imónɨŋɨ́pɨ nɨpɨnɨ nɨjɨ́á imónɨnɨ. Amɨpí nánɨ ámá ‘Rɨpɨ ayá tɨ́ŋɨ́pɨ imónɨnɨ.’ rɨ́ápɨyɨ́ Gorɨxoyá sɨŋwɨ́yo dánɨ xwɨrɨ́á winarɨŋɨ́yɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gorɨxo Ebɨrɨ́amo xɨ́omɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ píránɨŋɨ́ xɨ́darɨŋagɨ nánɨ re urɨŋɨnigɨnɨ, ‘Dɨxɨ́ seárɨ́awé ámá obaxɨ́ nimóga úɨ́áyɨ́ gɨ́ ayá tɨ́ŋɨ́nɨŋɨ́ nimóga upɨ́rɨ́árɨnɨ.’ urɨŋɨ́ eŋagɨ nánɨ Moseso tɨ́nɨ wɨ́á rókiamoagɨ́áwa tɨ́nɨ apɨ nánɨ Bɨkwɨ́yo nɨrɨro eagɨ́árɨnɨ. Seyɨ́né pɨ́né apɨ nɨsearéwapɨya bɨgɨ́árɨnɨ. E nerɨ aiwɨ Jono wayɨ́ nɨneameaia uŋo nɨrémorɨ́ná xwɨyɨ́á yayɨ́ seainɨpaxɨ́pɨ re searayiŋɨnigɨnɨ, ‘Seyɨ́né Gorɨxoyá xwioxɨ́yo páwipɨ́rɨ nánɨ ɨ́wɨ́ yarɨgɨ́ápɨ rɨ́wɨ́mɨnɨ nɨmamoro nɨsanɨro ŋweáɨ́rɨxɨnɨ.’ searayiŋɨnigɨnɨ. Ámá nɨ́nɨ aŋɨ́ ayómɨnɨ eŋɨ́ tɨ́nɨ óɨ́ nimóa páwianɨro yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E nerɨ aiwɨ amɨpí nɨ́nɨ Moseso tɨ́nɨ wɨ́á rókiamoagɨ́áwa tɨ́nɨ Gorɨxoyá Bɨkwɨ́yo eagɨ́ápɨ bɨ onɨmiápɨ aí surɨ́má imónɨnɨ́ámanɨ. Awa nɨrɨro eagɨ́ápa xɨxenɨ imónɨnɨ́árɨnɨ. Aŋɨ́na tɨ́nɨ xwɨ́á rɨrí tɨ́nɨ ananɨ anɨpá nimónɨrɨ aiwɨ Bɨkwɨ́ Gorɨxoyá ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ anɨpá imónɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Go go xegɨ́ xiepí xámɨ meaŋímɨ emɨ nɨmorɨ ámɨ wínɨ nɨmearɨ́náyɨ́ ayɨ́ ɨ́wɨ́ inarɨŋiɨ. Go go apɨxɨ́ ámá wo nɨmearɨ emɨ moŋímɨ nɨmearɨ́náyɨ́ ayɨ́ enɨ ɨ́wɨ́ inarɨŋiɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisaso ámá ayo re urɨŋɨnigɨnɨ, “Ámá wo amɨpí mɨmúrónɨŋo —O nɨgwɨ́ xwé tɨ́gɨ́áwa rapɨrapɨ́ awiaxɨ́nɨ yínarɨgɨ́ápa íníná rapɨrapɨ́ ayɨ́á rɨŋɨ́nɨ nɨyínɨrɨ sɨ́á ayɨ́ ayo aiwá naŋɨ́nɨ nɨnɨrɨ anɨŋɨ́ sɨrɨ́ munɨ́ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ámá wa wigɨ́ ámá wo xegɨ́ yoɨ́ Rasarasoyɨ rɨnɨŋo —O uyípeayɨ́ imónɨŋáná uranɨ́ xegɨ́ wí pɨpɨ́rɨmɨ́ó eŋorɨnɨ. Omɨ nɨmeámɨ nɨbɨro amɨpí mɨmúrónɨŋoyá ákɨŋá ɨ́wí e wɨ́rárɨgɨ́orɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Amɨpí mɨmúrónɨŋo íkwiaŋwɨ́yo éɨ́ nɨŋwearɨ aiwá nɨnɨrɨ yunɨ́pia piéróɨ́yɨ́ uranɨ́ tɨ́ŋo ‘Mɨmeánɨ́ oemɨnɨ.’ nɨyaiwirɨ yarɨ́ná sɨ́wí wí nɨbayiro xegɨ́ uranɨ́yo aíwɨ́ meayigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Uyípeayo rɨxa nɨpéagɨ aŋɨ́najɨ́ Gorɨxoyáyɨ́ oyá dɨŋɨ́pɨ nɨmeámɨ nɨyiro Ebɨrɨ́amo tɨ́ŋɨ́ e wárɨgɨ́awixɨnɨ. Amɨpí mɨmúrónɨŋo enɨ péagɨ omɨ enɨ xwɨ́á nɨweyárɨmáná eŋáná ");
INSERT INTO aak_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","o rɨ́á anɨŋɨ́ wearɨŋɨ́yo dánɨ rɨ́nɨŋɨ́ xaíwɨ́ inarɨ́ná sɨŋwɨ́ anaúɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ebɨrɨ́amo ná jɨ́amɨ ŋweaŋáná Rasaraso xɨ́o tɨ́ámɨnɨ kɨnɨmónénapɨŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","rɨ́aiwá re urɨŋɨnigɨnɨ, ‘Arɨ́o Ebɨrɨ́ame, rɨ́á tɨ́ mɨmenɨŋwɨ́ ayɨkwɨ́ mɨnɨrarɨnɨnɨ. Rasarasomɨ re urowárénapeɨ, “Wé sɨ́mɨ́pɨnɨ iniɨgɨ́yo igɨ́á neámáná aíwɨ́ imɨŋɨ́ urɨnɨ nánɨ wikwiárauɨ.” urowárénapeɨ.’ urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ebɨrɨ́amo re urɨŋɨnigɨnɨ, ‘Arɨ́oe, joxɨ sɨnɨ sɨŋoxɨ nɨŋwearɨ́ná amɨpí naŋɨ́nɨ símearɨ Rasarasomɨ sɨpínɨ wímearɨ yagɨ́rɨnɨ. E nerɨ aiwɨ agwɨ o sa kikiɨ́á yarɨ́ná joxɨ rɨ́nɨŋɨ́ nánɨ niwieánɨrɨ ŋweaŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rɨpɨ enɨ pɨŋɨ́ earɨrí segɨ́ tɨ́ámɨnɨ eadɨ́rorɨ negɨ́ tɨ́ámɨnɨ eadɨ́rorɨ eŋagɨ nánɨ seyɨ́né wí nene tɨ́ámɨnɨ mɨxemónapɨpaxɨ́rɨnɨ. Nene enɨ wí seyɨ́né tɨ́ámɨnɨ mɨxemónapɨpaxɨ́rɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","rɨ́á xaíwɨ́ weánarɨŋo re urɨŋɨnigɨnɨ, ‘Nionɨ tɨ́ámɨnɨ Rasarasomɨ re nánɨ urowárénapɨpaxɨ́ mepa eŋánáyɨ́, waunɨ́ rɨxɨŋɨ́ re orɨrɨmɨnɨ, “Gɨ́ ápoyá aŋɨ́mɨnɨ urowáreɨ.” orɨrɨmɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gɨ́ nɨrɨxɨ́meáowa wé bɨ nɨpɨnɨ imónɨgɨ́áwa nionɨ rɨ́nɨŋɨ́ meaarɨŋá rɨ́mɨ dánɨ bɨpɨ́rɨxɨnɨrɨ Rasaraso xwɨyɨ́á nɨjɨ́á wino urowáreɨ.’ urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ebɨrɨ́amo re urɨŋɨnigɨnɨ, ‘Awa rɨ́wamɨŋɨ́ Moseso nɨrɨrɨ eaŋɨ́ tɨ́nɨ wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́á tɨ́nɨ ananɨ ɨ́á nɨroro nɨjɨ́á imónɨpaxɨ́rɨnɨ. Xwɨyɨ́á apɨ rɨnɨŋɨ́pimɨ ananɨ arɨ́á wíɨ́rɨxɨnɨ.’ urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","rɨ́á xaíwɨ́ weánarɨŋo re urɨŋɨnigɨnɨ, ‘Arɨ́o Ebɨrɨ́ame, xwɨyɨ́á apimɨ arɨ́á umónɨpaxɨ́ meŋagɨ nánɨ rɨrarɨŋɨnɨ. Ámá pɨyɨ́ wo nɨwiápɨ́nɨmearɨ nɨjɨ́á wíánáyɨ́, ananɨ arɨ́á nɨwiro nɨsanɨro ŋweapaxɨ́rɨnɨ.’ urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","o re urɨŋɨnigɨnɨ, ‘Xwɨyɨ́á Moseso nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́ápɨ tɨ́nɨ arɨ́á mumónɨpa nerónáyɨ́, ámá pɨyɨ́ wo nɨwiápɨ́nɨmearɨ nɨjɨ́á wimɨnɨrɨ yarɨŋagɨ aí ayɨ́ arɨ́á wí wipaxɨ́ menɨnɨ.’ urɨŋɨnigɨnɨ.” Jisaso xwɨyɨ́á apɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","O xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámá wí wí ɨ́wɨ́ oépoyɨnɨrɨ iwamɨ́ó nɨwíwapɨyipɨ́rɨ́a aiwɨ ámá e wíwapɨyíɨ́áyɨ́ aweyɨ! Sɨ́á wɨyi ayɨ́ majɨ́á wórɨnɨ́árɨnɨ. Ayɨ́ xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ wímeanɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨpí wíwɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ayɨ́ niaíwɨ́ rɨpiamɨ nionɨ dɨŋɨ́ nɨkwɨ́roanɨro yarɨgɨ́ápiamɨ pɨ́rɨ́ wiaíkianɨro nero ɨ́wɨ́ oépoyɨnɨrɨ wíwapɨyarɨ́ná Gorɨxo ‘Ayɨ́ xwɨyɨ́á mayɨ́rɨnɨ.’ mɨrɨ́ rɨxa nɨpémáná eŋáná rɨ́nɨŋɨ́ xwé winɨ́árɨnɨ. Sɨnɨ niaíwɨ́piamɨ ɨ́wɨ́ nánɨ mɨwiepɨsipa eŋáná ámá wa ayo ɨ́á nɨxero sɨ́ŋá xwé wo siŋwɨ́ tɨ́nɨ gwɨ́ nɨjárɨro rawɨrawáyo nɨmamówárɨrɨ́náyɨ́, sɨpí eŋagɨ aiwɨ rɨ́nɨŋɨ́ Gorɨxo wimɨnɨrɨ eŋɨ́pɨ́nɨŋɨ́ imónɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ayɨnánɨ píránɨŋɨ́ éɨ́rɨxɨnɨ. “Joxɨ ámá wo, Gorɨxomɨ nɨxɨ́dɨrɨ nánɨ rɨrɨxɨ́meá imónɨŋo ɨ́wɨ́ síánáyɨ́ mɨxɨ́ urɨ́ɨrɨxɨnɨ. O rɨxa dɨŋɨ́ neyírorɨ nɨsanɨrɨ nerɨ́náyɨ́ ɨ́wɨ́ síɨ́pɨ yokwarɨmɨ́ nɨwiirɨ ‘Ananɨrɨnɨ.’ urɨ́ɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O ɨ́wɨ́ nɨsirɨ piaxɨ́ weánarɨŋagɨ nánɨ nɨbɨrɨ ‘Rɨxa dɨŋɨ́ neyírorɨ ɨ́wɨ́ ámɨ wínɨ simɨ́ámanɨ.’ rɨrémeááná joxɨ yokwarɨmɨ́ nɨwiirɨ ‘Ananɨrɨnɨ.’ urɨ́ɨrɨxɨnɨ. Sɨ́á axɨ́yimɨ o síɨ́pa axɨ́pɨ wé wɨ́úmɨ dáŋɨ́ waú rɨrémeaayíánáyɨ́, joxɨ enɨ yokwarɨmɨ́ wiayíɨrɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","wáɨ́ wurɨmeiarɨgɨ́áwa Ámɨnáomɨ re urɨgɨ́awixɨnɨ, “Joxɨ dɨŋɨ́ rɨkwɨ́roarɨŋwáyɨ́ ámɨ bɨ dɨŋɨ́ rɨkwɨ́roanɨ nánɨ neaiiɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né nɨjɨ́árɨnɨ. Masɨté aiwá siyɨ́ negɨ́ omɨŋɨ́yo ɨwɨ́ urarɨŋwáyɨ́ aga onɨmiápia nerɨ aiwɨ segɨ́ dɨŋɨ́ nionɨ nánɨ nɨkwɨ́roarɨgɨ́áyɨ́ ayɨ́nɨŋɨ́ nerɨ́náyɨ́, ‘Íkɨ́á xé roxɨnɨ nɨyoámɨga rawɨrawáyo e dánɨ roɨ.’ uránáyɨ́ ananɨ arɨ́ánɨŋɨ́ seainɨ́árɨnɨ. Amɨpí ‘Nionɨ epaxɨ́manɨ.’ yaiwiarɨgɨ́á aí ananɨ epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“E nerɨ aí soyɨ́né woxɨ dɨxɨ́ rɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ siiarɨŋɨ́ wo xwɨ́á nɨmirɨ yunɨ́ ikikémɨ́ yarɨŋe dánɨranɨ, sipɨsipɨ́ píránɨŋɨ́ nɨméra warɨŋe dánɨranɨ, pɨ́nɨ nɨwiárɨmɨ nɨbɨrɨ rémónapáná joxɨ ‘Ayá tɨ́nɨ aŋɨ́nɨ nɨ́wiapɨrɨ nɨŋwearɨ aiwá neɨ.’ urɨréɨnɨ? Oweoɨ, o sa dɨxɨ́ rɨnáínɨŋɨ́ omɨŋɨ́ siiarɨŋo eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","xámɨ re urɨrɨ́ɨnɨ, ‘Amíná aiwá rɨ́á nɨnɨyeairɨ dɨxɨ́ rapɨrapɨ́ nɨkɨ́kɨyinɨmáná aiwá nɨxerɨ niapáná nionɨ iniɨgɨ́ nɨrɨ aiwá nɨrɨ nemáná eŋáná joxɨ rɨ́wɨ́yo nɨrɨ́ɨnɨ.’ urɨrɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","O joxɨ sekaxɨ́ urɨ́ɨ́pɨ tɨ́nɨ xɨxenɨ siíáná omɨ weyɨ́ umerɨréɨnɨ? Oweoɨ, dɨxɨ́ omɨŋɨ́ siiarɨŋo eŋagɨ nánɨ yayɨ́ wirɨméɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","re urɨŋɨnigɨnɨ, “Gɨ́ seaiepɨsarɨŋáoyɨ́né enɨ sekaxɨ́ amɨpí nionɨ searɨ́áyɨ́ xɨxenɨ nerɨ́náyɨ́ seáyɨ e mimónɨpa nero re rɨ́ɨ́rɨxɨnɨ, ‘None xɨnáíwanénɨŋɨ́ nimónɨrane oyá omɨŋɨ́ wiiarɨŋwáonenɨrɨnɨ. Omɨŋɨ́ negɨ́nɨ nearɨ́ɨ́yɨ́nɨ eŋwárɨnɨ.’ rɨ́ɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisaso Jerusaremɨ nánɨ nurɨ Gariri pɨropenɨsɨ́ tɨ́nɨ Samaria pɨropenɨsɨ́ tɨ́nɨ mɨdɨmɨdánɨ eŋáná o áwɨnimanɨ nɨpurɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","aŋɨ́ bimɨ rémóáná ámá wé wúkaú peyɨyɨ́ tɨ́gɨ́áwa ná jɨ́amɨ nɨrómáná ");
INSERT INTO aak_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","rɨ́aiwá re urɨgɨ́awixɨnɨ, “Jisasoxɨ, negɨ́ neamemearɨŋoxɨnɨ, none nánɨ wá orunɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","o sɨŋwɨ́ nɨwɨnɨrɨ́ná re urɨŋɨnigɨnɨ, “Soyɨ́né nuro apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ sɨwá winaúpoyɨ.” urɨ́agɨ awa sɨnɨ óɨ́ e warɨ́ná re eŋɨnigɨnɨ. Wigɨ́ wará naŋɨ́ imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Naŋɨ́ imónáná awa wo wenɨŋɨ́ inɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Xegɨ́ wará naŋɨ́ imónɨŋagɨ nɨwɨnɨrɨ nɨkɨnɨmónɨmɨ nurɨ Gorɨxomɨ yayɨ́ numerɨ́ná rɨ́aiwánɨŋɨ́ nɨra nurɨ ");
INSERT INTO aak_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jisasoyá sɨkwɨ́ tɨ́ŋɨ́ e nɨpɨ́kínɨmearɨ omɨ yayɨ́ wiŋɨnigɨnɨ. Ámá oyɨ́ Samariayɨ́ worɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","O yayɨ́ wiarɨ́ná Jisaso ámá e rówapɨgɨ́áyo re urɨŋɨnigɨnɨ, “Ámá wé wúkaú naŋɨ́ imónɨ́awixɨnɨ. Wɨ́a gɨmɨnɨrɨnɨ? ");
INSERT INTO aak_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pí nánɨ ámá aŋɨ́ mɨdáŋɨ́ ronɨ Gorɨxomɨ yayɨ́ umemɨnɨrɨ bɨŋoɨ? Wɨ́a Judayowa ámɨ mɨbɨpa pí nánɨ éoɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Samariaomɨ re urowárɨŋɨnigɨnɨ, “Nɨwiápɨ́nɨmeámɨ uɨ. Joxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨŋɨ́pimɨ dánɨ erɨ́kiemeánɨ́ɨnɨ.” urowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisiowa “Gorɨxoyá dɨŋɨ́ tɨ́nɨ ámá nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ gíná arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́árɨ́anɨ?” nɨyaiwiro Jisasomɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ gíná imónɨnɨ́árɨnɨ?” Yarɨŋɨ́ e wíagɨ́a nánɨ o re urɨŋɨnigɨnɨ, “Sɨ́mɨmajɨ́ónɨŋɨ́ seainarɨ́ná sɨŋwɨ́ nɨwɨnɨro re rɨpɨ́rɨ́ámanɨ, ‘Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ rɨxa ríyɨ́rɨnɨ.’ rɨpɨ́rɨ́ámanɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Ámá Gorɨxoyá dɨŋɨ́ tɨ́nɨ yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo negɨ́ tɨ́nɨ áwɨnɨmɨ re riwo rɨronɨ?” oyaiwípoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Wí re rɨpɨ́rɨ́ámanɨ, ‘Sɨŋwɨ́ wɨnɨ́poyɨ. Ríyɨ́rɨnɨ. Sɨŋwɨ́ wɨnɨ́poyɨ. Jɨ́iyɨ́rɨnɨ.’ rɨpɨ́rɨ́ámanɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweáwɨnɨgɨnɨrɨ yarɨŋo rɨxa seyɨ́né tɨ́nɨ áwɨnɨmɨ re roŋɨ́ eŋagɨ nánɨ rarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Rɨ́wéná soyɨ́né ‘Sɨ́á ámá imónɨŋo ámɨ sɨŋánɨ nimónɨrɨ emenɨ́áyi aŋɨ́nɨ oimónɨnɨ.’ yaiwipɨ́rɨ́á aiwɨ aŋɨ́nɨ imónɨ́agɨ sɨŋwɨ́ wɨnɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ámá wí nionɨ nánɨ ‘Sɨŋwɨ́ wɨnɨ́poyɨ. Jɨ́iworɨnɨ. Sɨŋwɨ́ wɨnɨ́poyɨ. Riworɨnɨ.’ searánáyɨ́, nepa neararɨŋoɨnɨrɨ númɨ muxɨ́dɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ápiaŋwɨ́ nerɨ́ná wɨ́á aŋɨ́ ɨkwɨ́rónɨŋɨ́ nɨmɨnɨ ókiarɨŋɨ́pa ámá imónɨŋáonɨ nɨweapɨrɨ́ná ámá nɨ́nɨyá sɨŋwɨ́yo dánɨ sɨŋánɨ imónɨmɨ́á eŋagɨ nánɨ númɨ mupa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Xámɨ ámá agwɨ ríná ŋweagɨ́áyɨ́ rɨ́wɨ́ nɨmóáná nionɨ rɨ́nɨŋɨ́ xwé wí meámɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ámá eŋíná Nowao tɨ́ŋɨ́ íná néra wagɨ́ápa ámá imónɨŋáonɨ weapɨmɨnɨrɨ yarɨ́ná axɨ́pɨ epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ayɨ́ ‘Gorɨxo iniɨgɨ́ waxɨ́ tɨ́nɨ xwɨrɨ́á wí neaikɨxenɨ́ámanɨ.’ nɨyaiwiro o nánɨ dɨŋɨ́ peá nɨmoro aiwá nɨro iniɨgɨ́ nɨro néra nuro apɨxɨ́ nɨŋwɨrára uro nɨmeága uro yarɨ́ná Nowao rɨxa sɨpɨxɨ́yo ínɨmɨ páwíáná re eŋɨnigɨnɨ. Iniɨgɨ́ waxɨ́ xwé nɨróga nɨwiápɨ́nɨmearɨ oxɨ́ apɨxɨ́ nɨ́nɨ iniɨgɨ́ namigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nowao tɨ́ŋɨ́ íná dánɨ ná rɨ́wɨ́yo Roto tɨ́ŋɨ́ íná enɨ Sodomɨ ŋweagɨ́áyɨ́ axɨ́pɨ e yagɨ́árɨnɨ. Ayɨ́ enɨ Gorɨxo nánɨ dɨŋɨ́ peá nɨmoro aiwá nɨga uro iniɨgɨ́ nɨga uro nero amɨpí bɨ bɨ́ niga uro omɨŋɨ́ néra uro aŋɨ́ nɨmɨra uro yarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sɨ́á Roto Sodomɨ pɨ́nɨ nɨwiárɨmɨ éɨ́ úɨ́yimɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ rɨ́á tɨ́nɨ sɨ́ŋá tɨ́nɨ aŋɨ́namɨ dánɨ nɨpiérorɨ ámá aŋɨ́ apimɨ ŋweagɨ́áyɨ́ nɨ́nɨ rɨ́á nɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Rɨ́wéná enɨ ámá axɨ́pɨ e néra nuro ‘Gorɨxomɨ xewaxo nɨweapɨnɨ́ámanɨ.’ nɨyaiwia warɨ́ná ámá imónɨŋáonɨ sɨŋánɨ imónɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sɨ́á ayimɨ ámá aŋɨ́ pákɨ́kɨ́ nɨmɨrɨga peyiŋɨ́yo seáyɨ eŋiwámɨ ŋweagɨ́á gɨyɨ́ gɨyɨ́ nɨwepɨ́nɨro ‘Nɨgɨ́ iyɨ́á ɨ́á aŋɨ́ xwɨ́á eŋɨ́wámɨ weŋɨ́yɨ́ nɨmeámɨ éɨ́ oumɨnɨ.’ nɨyaiwiro mɨpáwipa éɨ́rɨxɨnɨ. Aiwá omɨŋɨ́yo yarɨgɨ́á gɨyɨ́ gɨyɨ́ enɨ wigɨ́ amɨpí meaanɨro nánɨ ámɨ aŋɨ́ tɨ́ŋɨ́ e nánɨ mupa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rotomɨ xiepí nánɨ dɨŋɨ́ oseainɨnɨ. Í xegɨ́ iyɨ́á ɨ́á amɨpí nánɨ dɨŋɨ́ sɨpí wíagɨ nɨkɨnɨmónɨrɨ wenɨŋɨ́ éɨ́yɨ́ re eŋɨnigɨnɨ. Nɨperɨ sɨ́ŋá imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ámá xegɨ́ amɨpí dɨŋɨ́ tɨ́ŋɨ́pɨ nánɨnɨ dɨŋɨ́ móɨ́ go go o dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́ anɨŋɨ́ ŋweanɨ́a nánɨpɨ sɨxɨ́ ínɨnɨ́ámanɨ. Ámá xegɨ́ amɨpí dɨŋɨ́ tɨ́ŋɨ́pɨ nánɨ aí ‘Pí enɨŋoɨ!’ yaiwíɨ́ go go o dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ anɨŋɨ́ ŋweanɨ́a nánɨ sɨxɨ́ ínɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sɨ́á ámá imónɨŋáonɨ weapɨmɨ́áyimɨ ámá waú aŋɨ́ íkwiaŋwɨ́yo sá weŋáná Gorɨxoyá aŋɨ́najowa wɨ́o, Gorɨxomɨ dɨŋɨ́ wɨkwɨ́roarɨŋomɨ nɨwirɨmearo wɨ́o dɨŋɨ́ mɨwɨkwɨ́roarɨŋomɨ e wárɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ayimɨ apɨxɨ́ wípaú enɨ pɨrawá yunɨ́ ikɨxémɨ́ yarɨ́ná wɨ́ímɨ nɨwirɨmearo wɨ́ímɨ e wárɨpɨrɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ámá waú enɨ omɨŋɨ́yo yarɨ́ná wɨ́omɨ nɨwirɨmearo wɨ́omɨ wárɨpɨ́rɨ́árɨnɨ.” Jisaso e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","xegɨ́ wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, joxɨ neararɨŋɨ́pɨ gɨmɨ imónɨnɨ́árɨnɨ?” urɨ́agɨ́a Jisaso “O weapɨnɨ́e nánɨ ámá áwaŋɨ́ wí nearɨpaxɨ́ menɨnɨ. Ámá nɨ́nɨ sɨŋwɨ́ tɨ́nɨ wɨnɨpɨ́rɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Pɨyɨ́ weŋe apurɨ́ obaxɨ́ pénarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisaso xegɨ́ wiepɨsarɨŋowa Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ́ná anɨŋɨ́ winɨ́agɨ pɨ́nɨ wiárɨpɨ́rɨxɨnɨrɨ ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","re urɨŋɨnigɨnɨ, “Aŋɨ́ bimɨ opisɨ́ aŋɨ́yo dánɨ xwɨrɨxɨ́ eyeyírómɨ́ yarɨŋɨ́ wo —O Gorɨxo nánɨ wáyɨ́ mepa erɨ ámá nɨ́nɨyo dɨŋɨ́ sɨpí mɨwipa erɨ yarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Omɨ apɨxɨ́ anɨ́ wí —Í enɨ aŋɨ́ apimɨ dáŋírɨnɨ. Í íníná o tɨ́ŋɨ́ e nánɨ nɨbayirɨ re urayiŋɨnigɨnɨ, ‘Ámá niínɨ pɨ́né nɨmeararɨgɨ́áyɨ́ joxɨ tɨ́nɨ nɨrorai saŋɨ́ nɨnɨrápɨrɨ xwɨrɨxɨ́ bɨ oyaiyɨ.’ urayíagɨ aí ");
INSERT INTO aak_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","o ‘Saŋɨ́ murápɨpa oemɨnɨ.’ nɨyaiwia núɨsáná rɨ́wéná í nánɨ rɨxa anɨŋɨ́ winɨ́agɨ re yaiwiŋɨnigɨnɨ, ‘Nionɨ Gorɨxo nánɨ wáyɨ́ mé nerɨ ámáyo dɨŋɨ́ sɨpí mɨwiarɨŋáonɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","apɨxɨ́ anɨ́ í anɨŋɨ́ nimoayarɨŋagɨ nionɨ í anɨŋɨ́ minɨ́ bayarɨ́ná anɨŋɨ́ ninɨnɨgɨnɨrɨ ímɨ oumearómɨnɨ.’ yaiwiŋɨnigɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ re urɨŋɨnigɨnɨ, “Ámá xwɨrɨxɨ́ eyeyírómɨ́ yarɨŋɨ́ sɨpío eŋɨ́pɨ nánɨ dɨŋɨ́ mópoyɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","O ámá sɨpío aiwɨ apɨxɨ́ aní íníná bayarɨŋagɨ nánɨ saŋɨ́ urápɨŋɨnigɨnɨ. Gorɨxo ámá ónɨŋɨ́ wí mimónɨŋagɨ aí re rɨyaiwiarɨŋoɨ, ‘Gorɨxo ámá xɨ́o xegɨ́nɨ eyíroŋɨ́yɨ́ omɨ árɨ́wɨyiranɨ, ikwáwɨyiranɨ, “Joxɨ saŋɨ́ nearápeɨ.” urayarɨ́náyɨ́ o kikiɨ́á néra núɨsáná ná rɨ́wɨ́yo dánɨ saŋɨ́ urápɨnɨgɨnɨ.’ rɨyaiwiarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Oweoɨ! ‘Aŋɨ́nɨ saŋɨ́ urápɨnɨ́árɨnɨ.’ seararɨŋɨnɨ. E nerɨ aiwɨ ámá imónɨŋáonɨ nɨweapɨrɨ́ná ámá sɨnɨ dɨŋɨ́ nɨnɨkwɨ́roro yarɨŋagɨ́a sɨŋwɨ́ wɨnɨmɨ́árɨ́anɨ? Rɨxa pɨ́nɨ nɨnɨwiárɨmɨ warɨŋagɨ́a wɨnɨmɨ́árɨ́anɨ? Ayɨnánɨ píránɨŋɨ́ dɨŋɨ́ mópoyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","O ewayɨ́ xwɨyɨ́á rɨpɨ enɨ wanɨ dɨŋɨ́ nɨkwɨ́rónɨro “None wé rónɨŋwáonerɨnɨ.” yaiwiro ámá wíyo peayɨ́ nɨwianɨro “Sɨpíowarɨnɨ.” yaiwiro yarɨgɨ́áyo nurɨrɨ́ná re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ámá waú —Wɨ́o Parisiorɨnɨ. Wɨ́o takisɨ́ nánɨ nɨgwɨ́ nearáparɨŋorɨnɨ. Awaú Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wianɨri nánɨ aŋɨ́ Gorɨxo nánɨ naŋwɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nánɨ axíná nuri ");
INSERT INTO aak_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisio xegɨ́pɨ aŋwɨ e nɨrómáná xegɨ́ dɨŋɨ́ tɨ́nɨ ínɨmɨ dánɨ re rɨrɨmɨ́ wiŋɨnigɨnɨ, ‘Gorɨxoxɨnɨ, nionɨ ámá wa yapɨ sɨpíonɨ meŋagɨ nánɨ yayɨ́ osimɨnɨ. Wa yapɨ ámáyo ɨ́wɨ́ uráparɨŋáonɨmanɨ. Wa yapɨ rɨkɨkɨrɨ́ó yarɨŋáonɨmanɨ. Wa yapɨ apɨxɨ́ tɨ́nɨ ɨ́wɨ́ inarɨŋáonɨmanɨ. Takisɨ́ nánɨ nɨgwɨ́ nearáparɨŋɨ́ dao yapɨ mimónɨŋɨnɨ. Ayɨnánɨ yayɨ́ osimɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sabarɨ́á ayɨ́ ayo sɨ́á wɨyaúmɨ aiwá ŋwɨ́á ŋwɨrárɨnarɨŋáonɨrɨnɨ. Amɨpí nionɨ meááyɨ́ enɨ yaŋɨ́ nɨmerɨ wé wúkaú eŋáná wo joxɨ nánɨ tarɨŋáonɨrɨnɨ.’ Parisio Gorɨxomɨ e urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","takisɨ́ nánɨ nɨgwɨ́ uráparɨŋo ná jɨ́amɨnɨ e nɨrómáná piaxɨ́ weánarɨŋagɨ nánɨ sɨŋwɨ́ nɨmɨ́eyoarɨ aŋɨ́namɨ manɨ́ ayá ɨ́á nɨxɨrɨnɨmáná Gorɨxomɨ rɨrɨmɨ́ re wiŋɨnigɨnɨ, ‘Gorɨxoxɨnɨ, nionɨ ɨ́wɨ́ yarɨŋáonɨrɨnɨ. Wá nɨwianeɨ.’ urɨŋɨnigɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","re urɨŋɨnigɨnɨ, “Ámá o Gorɨxoyá sɨŋwɨ́yo dánɨ wé rónɨŋɨ́ nimónɨmɨ xegɨ́ aŋɨ́ e nánɨ úagɨ aiwɨ wɨ́o wé rónɨŋɨ́ mimónɨŋɨnigɨnɨ. Ámá go go xewanɨŋo seáyɨ e menɨ́oyɨ́ Gorɨxo xwɨ́ámɨ imɨxɨnɨ́árɨnɨ. Go go ‘Sɨpíonɨrɨnɨ.’ nɨyaiwirɨ ínɨmɨ imónɨ́oyɨ́ Gorɨxo seáyɨ e umenɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wiepɨsarɨŋowa ámá wí wigɨ́ niaíwɨ́piamɨ Jisaso wé owikwiárɨnɨrɨ nɨmeámɨ barɨŋagɨ́a nɨwɨnɨro “Nɨmeámɨ mɨbɨpanɨ.” uranɨro yarɨŋagɨ́a Jisaso sɨŋwɨ́ e nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","niaíwɨ́piamɨ rɨ́aiwá “Bɨ́poyɨ.” nurɨrɨ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámá niaíwɨ́ onɨmiápia xanɨyaúmɨ dɨŋɨ́ nɨwɨkwɨ́roro yarɨgɨ́ápa Gorɨxomɨ dɨŋɨ́ wɨkwɨ́róɨ́áyɨ́ o xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ umeŋweanɨ́á eŋagɨ nánɨ niaíwɨ́ rɨpia xe obɨ́poyɨnɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ. Pɨ́rɨ́ mɨwiaíkipa époyɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","‘Ámá go go niaíwɨ́ onɨmiápiánɨŋɨ́ mimónɨpa erɨ Gorɨxomɨ yeáyɨ́ murɨ́nɨpa erɨ nerɨ́náyɨ́, oyá xwioxɨ́yo wí nɨpáwiro ŋweapɨ́rɨ́ámanɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Judayɨ́ ámɨná wo nɨwímearɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Nearéwapɨyarɨŋɨ́ naŋoxɨnɨ, nionɨ pí nerɨ́ná dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́ŋáonɨ anɨŋɨ́ íníná ŋweámɨ́a nánɨ imónɨmɨ́árɨnɨ?” yarɨŋɨ́ e wíagɨ ");
INSERT INTO aak_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisaso ámá o “Xɨ́o enɨ naŋo eŋagɨ nánɨ Gorɨxo tɨ́nɨ xɨxenɨ imónɨŋorɨ́anɨ?” oyaiwinɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ pí nánɨ ‘Naŋoxɨnɨ́ nɨrarɨŋɨnɨ? Ámá nɨyonɨ nánɨ Gorɨxonɨ naŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ joxɨ nɨjɨ́árɨnɨ. ‘Apɨxɨ́ tɨ́nɨ ɨ́wɨ́ minɨpanɨ. Nɨwiápɨ́nɨmearɨ ámá mɨpɨkipanɨ. Ɨ́wɨ́ mɨmeapanɨ. Ámá wo nánɨ xwɨyɨ́á nɨyimárónɨrɨ yapɨ́ murɨpanɨ. Rɨnɨyaúmɨ wéyo merɨ́ɨnɨ.’ Ŋwɨ́ ikaxɨ́ e eánɨŋɨ́pɨ joxɨ nɨjɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","yarɨŋɨ́ wío re urɨŋɨnigɨnɨ, “Nionɨ sɨnɨ niaíwɨ́ imónɨŋaé dánɨ nɨpɨnɨ nɨméra bɨŋárɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisaso arɨ́á e nɨwirɨ re urɨŋɨnigɨnɨ, “Ŋwɨ́ ikaxɨ́ apɨ píránɨŋɨ́ nɨméra nɨbɨrɨ aí bɨ sɨnɨ meŋɨ́rɨnɨ. Dɨxɨ́ iyɨ́á ɨ́á amɨpí nɨ́nɨ nɨgwɨ́ nánɨ bɨ́ nemáná ámá uyípeayɨ́yo mɨnɨ nɨwia nurɨ́náyɨ́, aŋɨ́namɨ amɨpí ayá tɨ́ŋɨ́ tɨ́ŋoxɨ imónɨrɨ́árɨnɨ. E nemáná nɨbɨrɨ nionɨ nɨxɨ́dɨ́ɨrɨxɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","o arɨ́á e nɨwirɨ́ná amɨpí xwé wí mɨmúrónɨŋo eŋagɨ nánɨ aga xwioxɨ́yo dánɨ dɨŋɨ́ rɨ́á nuxerɨ xwɨrɨ́á nimónɨrɨ kɨpɨŋɨ́ nɨyirɨ roŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisaso e nɨwɨnɨrɨ re rɨŋɨnigɨnɨ, “Ámá amɨpí mɨmúrónɨgɨ́áyɨ́ nene Gorɨxomɨ nuxɨ́dɨrane oyá xwioxɨ́yo páwianɨ nánɨ anɨŋɨ́ minɨ́ oyaneyɨnɨrɨ nero aiwɨ nɨpáwipaxɨ́ mimónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamerɨ́ eŋɨ́ rapɨrapɨ́ gwɨ́ kiwearɨgɨ́á óɨ́ ayɨkwɨnimɨ páwipaxɨ́ mimónɨnɨ. Ámá amɨpí mɨmúrónɨgɨ́áyɨ́ kamerɨ́ eŋɨ́ óɨ́yimɨ mɨpáwipa yarɨŋɨ́yɨ́ yapɨ Gorɨxoyá xwioxɨ́yo nɨpáwiro ŋweapaxɨ́ mimónɨŋoɨ.” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ámá e nɨŋweámáná arɨ́á wigɨ́áyɨ́ —Judayɨ́ nɨ́nɨ “Amɨpí mɨmúrónɨgɨ́áyɨ́ Gorɨxoyá dɨŋɨ́ tɨ́nɨ amɨpí meaarɨŋagɨ́a nánɨ Gorɨxo yayɨ́ winarɨnɨ.” yaiwiagɨ́áyɨ́rɨnɨ. Ámá e nɨŋweámáná arɨ́á wigɨ́áyɨ́ ududɨ́ winɨ́agɨ omɨ re urɨgɨ́awixɨnɨ, “Joxɨ nearɨ́ɨ́pɨ nepa eŋánáyɨ́, Gorɨxo ámá gɨyo yeáyɨ́ uyimɨxemeanɨ́árɨ́anɨ?” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","o re urɨŋɨnigɨnɨ, “Amɨpí ámá mepaxɨ́ imónɨŋɨ́yɨ́ Gorɨxo ananɨ e nepaxɨ́rɨnɨ. Gorɨxo ananɨ ámá yeáyɨ́ uyimɨxemeapaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitao re urɨŋɨnigɨnɨ, “Ai, ámá o xegɨ́ amɨpí pɨ́nɨ mɨwiárɨpa nerɨ rɨxɨ́dɨpaxɨ́ mɨwimónarɨŋagɨ aiwɨ none negɨ́ aŋɨ́ tɨ́nɨ amɨpí nɨ́nɨ pɨ́nɨ nɨwiárɨmɨ joxɨ númɨ rɨxɨ́dɨŋwɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jisaso awamɨ re urɨŋɨnigɨnɨ, “Gɨyɨ́ gɨyɨ́ nionɨ dɨŋɨ́ nɨnɨkwɨ́roro wínɨyɨ́ enɨ Gorɨxoyá xwioxɨ́yo páwíɨ́rɨxɨnɨrɨ wáɨ́ rɨmepɨ́rɨ nánɨ wigɨ́ aŋɨ́ranɨ, xiepímɨranɨ, xexɨrɨ́meáowamɨranɨ, xanɨyaúmɨranɨ, wigɨ́ niaíwɨ́yoranɨ, pɨ́nɨ nɨwiárɨmɨ nɨnɨxɨ́dɨrɨ́náyɨ́, anɨ́á imónɨpɨ́rɨ́ámanɨ. Agwɨ ríná Gorɨxo ayɨ́ pɨ́nɨ nɨwiárɨmɨ úɨ́á axɨ́pɨ wínɨ mɨnɨ nɨwimáná ámá nɨ́nɨ mí ómómɨxɨmɨ́ éíná ayɨ́ dɨŋɨ́ anɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ enɨ winɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","O xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ jɨ́amɨnɨ e nɨmeáa numáná re urɨŋɨnigɨnɨ, “Jerusaremɨ nánɨ warɨŋwɨnɨ. E rémóáná amɨpí Gorɨxoyá xwɨyɨ́á wɨ́á rókiamoagɨ́áwa ámá imónɨŋáonɨ nánɨ nɨrɨro eagɨ́ápɨ xɨxenɨ nímeanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Negɨ́ Judayɨ́ mɨyɨ́ nɨrorɨ́ráná émáyɨ́ wa ɨ́á nɨnɨxero ikayɨ́wɨ́ nɨmearɨro iwaŋɨ́ nɨmépero reaŋwɨ́ núrɨro ");
INSERT INTO aak_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","sɨkwɨ́á ragɨ́ pɨ́rɨ́ nuyɨkiro nɨnimáná nɨpɨkipɨ́rɨ́árɨnɨ. E nerɨ aiwɨ rɨxa sɨ́á wɨyaú wɨyi óráná ámɨ nɨwiápɨ́nɨmeámɨ́árɨnɨ.” áwaŋɨ́ píránɨŋɨ́ e urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","xwɨyɨ́á apɨ awamɨ ínɨmɨ́nɨŋɨ́ imónɨŋagɨ nánɨ nɨjɨ́á wí mimónɨpa nero xɨ́o rɨ́ɨ́yɨ́ “Ayɨ́ nánɨ rɨ́a neararɨnɨ?” mɨyaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","O aŋɨ́ xegɨ́ yoɨ́ Jeriko rɨnɨŋɨ́pɨ tɨ́ŋɨ́ e rɨ́mɨne rémoarɨ́ná ámá sɨŋwɨ́ supárɨŋɨ́ wo óɨ́ maŋɨ́pá tɨ́nɨ nɨŋweámáná ámá e pwarɨgɨ́áyo aiwá nánɨ rɨxɨŋɨ́ nurɨrɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","arɨ́á wíɨ́yɨ́ wiŋɨnigɨnɨ. Oxɨ́ apɨxɨ́ obaxɨ́ ɨkwɨkwierɨ́ pwarɨŋagɨ́a arɨ́á nɨwirɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Pí nánɨ yarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ámá wí áwaŋɨ́ re urɨgɨ́awixɨnɨ, “Nasaretɨ dáŋɨ́ Jisaso pwarɨŋagɨ yarɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","o rɨ́aiwá re rɨŋɨnigɨnɨ, “Jisasoxɨ, mɨxɨ́ ináyɨ́ Depitomɨ xiáwoxɨnɨ, joxɨ wá nɨwianeɨ.” rarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ámá Jisasomɨ xámɨ umeagɨ́áyɨ́ o rɨ́aiwá e rarɨŋagɨ arɨ́á nɨwiro mɨxɨ́ nurɨro “Pɨ́nɨ wiáreɨ.” urɨ́agɨ́a aiwɨ rɨ́aiwá eŋɨ́ tɨ́nɨ ámɨ wínɨ wínɨ nɨrɨrɨ re rɨŋɨnigɨnɨ, “Jisasoxɨ, Depitomɨ xiáwoxɨnɨ, joxɨ wá nɨwianeɨ.” urarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisaso e nɨrónapɨmáná sekaxɨ́ re urɨŋɨnigɨnɨ, “Omɨ nɨwirɨmeámɨ bɨ́poyɨ.” urɨ́agɨ ámá wí rɨxa nɨwirɨmeámɨ aŋwɨ e báná ");
INSERT INTO aak_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jisaso yarɨŋɨ́ re wiŋɨnigɨnɨ, “Nionɨ pí oninɨrɨ nɨrarɨŋɨnɨ?” urɨ́agɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nionɨ ámɨ sɨŋwɨ́ oanɨmɨnɨrɨ rɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisaso re urɨŋɨnigɨnɨ, “Dɨxɨ́ sɨŋwɨ́ ananɨ oxoarɨ́ɨnɨ. Dɨŋɨ́ nɨnɨkwɨ́rorɨŋɨ́pimɨ dánɨ erɨ́kiemeánɨrɨ́ɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","re eŋɨnigɨnɨ. Xegɨ́ sɨŋwɨ́ noxoarɨ sɨŋwɨ́ anɨŋɨnigɨnɨ. Sɨŋwɨ́ nanɨrɨ Jisasomɨ nuxɨ́dɨrɨ Gorɨxomɨ seáyɨ e umearɨ́ná ámá nɨ́nɨ o e éagɨ nɨwɨnɨro ayɨ́ enɨ Gorɨxomɨ seáyɨ e megɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisaso rɨxa Jeriko nɨrémorɨ aŋɨ́ apimɨ áwɨnɨmɨ pwarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ámá wo Sakiasoyɨ rɨnɨŋo —O ámá takisɨ́ nánɨ nɨgwɨ́ uráparɨgɨ́áyo xɨráowánɨŋɨ́ imónɨgɨ́á worɨnɨ. Amɨpí wí mɨmúrónɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","O “Ámá Jisasoyɨ rɨnɨŋo gorɨ́anɨ?” nɨyaiwirɨ sɨŋwɨ́ wɨnɨmɨnɨrɨ nerɨ aiwɨ rɨpɨ́wo eŋagɨ nánɨ oxɨ́ apɨxɨ́ uyimároarɨŋagɨ́a o yopa nɨmegɨnɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ayo xámɨ numearɨ aŋɨ́nɨ nurɨ “Jisaso óɨ́ rɨyimɨ punɨŋoɨ.” nɨyaiwirɨ omɨ sɨŋwɨ́ wɨnɨmɨnɨrɨ nánɨ íkɨ́á womɨ nɨpeyirɨ wenɨŋɨ́ nerɨ roŋáná ");
INSERT INTO aak_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisaso nɨbɨrɨ e nɨrónapɨmáná sɨŋwɨ́ anánɨ́ɨ́yɨ́ Sakiasomɨ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Sakiase, aŋɨ́nɨ wepɨ́neɨ. Sɨ́á rɨyi joxɨ tɨ́nɨ ŋweámɨ́ɨnɨ. Dɨxɨ́ aŋɨ́ e nánɨ owaiyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","o aŋɨ́nɨ nɨwepɨ́nɨrɨ yayɨ́ tɨ́nɨ nɨwirɨmeámɨ xegɨ́ aŋɨ́ e nánɨ nɨmeáa uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xegɨ́ aŋɨ́ e nánɨ nɨwirɨmeámɨ úagɨ ámá nɨ́nɨ sɨŋwɨ́ e nɨwɨnɨro wikɨ́ dɨŋɨ́ nɨwiaiwiro re rɨnɨgɨ́awixɨnɨ, “Ámá ɨ́wɨ́ yarɨŋɨ́ o tɨ́nɨ ŋweámɨnɨrɨ nánɨ pí nánɨ uŋoɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiaso éɨ́ nɨrómáná Jisasomɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nɨgɨ́ iyɨ́á ɨ́á amɨpí nɨ́nɨ bɨ biaú kɨkɨrɨ́ nepayómáná bɨ ámá uyípeayɨ́ imónɨgɨ́áyo mɨnɨ wimɨ́árɨnɨ. Ámá gɨyɨ́ gɨyo nionɨ yapɨ́ nɨwíwapɨyirɨ nɨgwɨ́ ɨ́wɨ́ urápɨŋáyo wigɨ́ ɨ́wɨ́ urápɨŋáyɨ́ tɨ́nɨ nionɨyá wí tɨ́nɨ seáyɨ e nikwiárɨrɨ mɨnɨ wimɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisaso re urɨŋɨnigɨnɨ, “Agwɨ ámá ro arɨ́o Ebɨrɨ́amo Gorɨxomɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ yagɨ́pa axɨ́pɨ nerɨ nɨsanɨrɨ éagɨ nánɨ Gorɨxo rɨxa yokwarɨmɨ́ nɨwiirɨ yeáyɨ́ uyimɨxemeaŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá imónɨŋáonɨ ámá ɨ́wɨ́ néra nuro anɨŋɨ́ ikeamónanɨro yarɨgɨ́áyo nánɨ pɨ́á nerɨ yeáyɨ́ uyimɨxemeámɨnɨrɨ bɨŋáonɨrɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ámá ayɨ́ xwɨyɨ́á apɨ arɨ́á nɨwiro Jerusaremɨ Jisaso warɨŋe nánɨ rɨxa aŋwɨ e imónɨŋagɨ nɨwɨnɨro dɨŋɨ́ re nɨmóa ugɨ́awixɨnɨ, “Gorɨxo nene xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ rɨxa nimónɨnɨŋoɨ. Jisaso Jerusaremɨ nɨrémorɨ́ná émáyo mɨxɨ́ nuxɨ́dowárɨmáná mɨxɨ́ ináyɨ́ nimónɨrɨ xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨŋoɨ.” Dɨŋɨ́ e nɨmóa warɨ́ná Jisaso “O negɨ́ mɨxɨ́ ináyɨ́ apaxɨ́ mé nimónɨmenɨŋoɨ.” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","re urɨŋɨnigɨnɨ, “Ámá ámɨná wo mɨxɨ́ ináyɨ́ imónaurɨ ámɨ nɨbɨrɨ xegɨ́ ámáyo meŋwearɨ emɨ́ánɨrɨ aŋɨ́ ná jɨ́amɨ imónɨŋɨ́mɨ umɨnɨrɨ nerɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","xegɨ́ xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiarɨgɨ́á wé wúkaú awamɨ ‘Eɨnɨ.’ nurɨrɨ nɨgwɨ́ gorɨ́ ámá anɨŋɨ́ minɨ́ omɨŋɨ́ emá waú wo nero meaarɨgɨ́o wonɨ wonɨ nɨwia nurɨ re urɨŋɨnigɨnɨ, ‘Nɨgwɨ́ nionɨ seaiaparɨŋá rɨpɨ sayá imɨxɨpɨ́rɨ́a nánɨ bisɨnisɨ́ nimɨxa warɨ́ná seaímeáɨmɨgɨnɨ.’ nurɨmɨ úáná ");
INSERT INTO aak_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ámá aŋɨ́ e xɨ́o tɨ́nɨ ŋweagɨ́áyɨ́ wigɨ́ xwioxɨ́yo dánɨ wikɨ́ dɨŋɨ́ nɨwiaiwiro wigɨ́ ámá wíyo re urowárɨgɨ́awixɨnɨ, ‘Mɨxɨ́ ináyɨ́ imɨmɨxɨmɨ́ yarɨŋomɨ nuro “O nene neameŋweanɨ́a nánɨ mɨneaimónarɨnɨ.” urɨ́poyɨ.’ urowárɨ́agɨ́a awa nuro mɨxɨ́ ináyɨ́ imɨmɨxɨmɨ́ yarɨŋomɨ e urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","o ámɨná bɨ́omɨ mɨxɨ́ ináyɨ́ nimɨxɨrɨ xegɨ́ aŋɨ́ e nánɨ urowárɨŋɨnigɨnɨ. O rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ aŋɨ́ e nɨrémorɨ́ná awa bisɨnisɨ́ nimɨxɨrɨ́ná nɨgwɨ́ sayá rɨ́a imɨxɨ́awixɨnɨrɨ sɨŋwɨ́ owɨnɨmɨnɨrɨ re rɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ niiarɨgɨ́á nɨgwɨ́ wiŋáwa obɨ́poyɨ.’ ráná ");
INSERT INTO aak_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","wo nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Negɨ́ neameŋweaŋoxɨnɨ, nɨgwɨ́ gorɨ́ joxɨ niapɨŋo tɨ́nɨ bisɨnisɨ́ nimɨxa nurɨ́ná rɨxa wé wúkaú sayá imɨxɨŋárɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","o re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ niiarɨŋɨ́ naŋoxɨnɨ, ayɨ́ awiaxɨ́rɨnɨ. Joxɨ nɨgwɨ́ nionɨ siapɨŋáo tɨ́nɨ nionɨ rɨrɨŋápa xɨxenɨ eŋɨ́ nánɨ gapɨmanɨ́ nimónɨrɨ aŋɨ́ wé biaúmɨ meŋweáɨrɨxɨnɨ.’ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ámɨ wo nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Negɨ́ neameŋweaŋoxɨnɨ, nɨgwɨ́ gorɨ́ joxɨ niapɨŋo tɨ́nɨ bisɨnisɨ́ nimɨxa nurɨ́ná rɨxa wé wú sayá imɨxɨŋárɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","mɨxɨ́ ináyo re urɨŋɨnigɨnɨ, ‘Joxɨ enɨ gapɨmanɨ́ nimónɨrɨ aŋɨ́ wé bimɨ meŋweáɨrɨxɨnɨ.’ urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ámɨ wo nɨbɨrɨ re urɨŋɨnigɨnɨ, ‘Negɨ́ neameŋweaŋoxɨnɨ, nɨgwɨ́ joxɨ niapɨŋo nionɨ írɨkwɨ́yo wowɨ́ nerɨ tɨŋáo sɨnɨ riworɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Joxɨ xeanɨŋɨ́ rarɨŋoxɨ eŋagɨ nánɨ wáyɨ́ ninɨ́agɨ “Nɨgwɨ́ ro xwɨrɨ́á ikɨxéánáyɨ́, iwaŋɨ́ neanɨ́árɨ́anɨ?” nɨyaiwirɨ bisɨnisɨ́ wí mimɨxɨŋárɨnɨ. Joxɨ amɨpí ámá wa tɨ́áyɨ́ dɨxɨ́ mearɨ aiwá ámá wa ɨwɨ́á urɨ́áyɨ́ dɨxɨ́ mirɨ yarɨŋoxɨ eŋagɨ nánɨ rɨrarɨŋɨnɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","o re urɨŋɨnigɨnɨ, ‘Omɨŋɨ́ niiarɨŋɨ́ sumí roxɨnɨ, jɨwanɨŋoxɨ nɨrɨ́ɨ́yo dánɨ xwɨyɨ́á rɨmearɨmɨ́ɨnɨ. Nionɨ xeanɨŋɨ́ rarɨŋáonɨ amɨpí ámá wa tɨ́áyɨ́ nɨgɨ́ mearɨ aiwá wa ɨwɨ́á urɨ́áyɨ́ nɨgɨ́ mirɨ yarɨŋáonɨ eŋagɨ nánɨ joxɨ nɨjɨ́á imónɨŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","pí nánɨ nɨgwɨ́ nionɨ siapɨŋáo nɨgwɨ́ aŋɨ́yo mɨnɨtipa eŋɨ́rɨnɨ. E nɨtɨrɨ sɨŋwɨrɨyɨ́, nɨgwɨ́ o tɨ́nɨ ámɨ bɨ seáyɨ e ikwiárɨnɨŋáná meámɨnɨrɨ éárɨnɨ.’ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ámá aŋwɨ e rogɨ́áyo re urɨŋɨnigɨnɨ, ‘Ámá romɨ nɨgwɨ́ ro nurápɨro nɨgwɨ́ wé wúkaú tɨ́ŋomɨ mɨnɨ wípoyɨ.’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","awa re urɨgɨ́awixɨnɨ, ‘Ai, negɨ́ neameŋweaŋoxɨnɨ, o rɨxa wé wúkaú tɨ́ŋorɨnɨ. Pí nánɨ ámɨ wo wirɨ́ɨnɨ?’ urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","o re urɨŋɨnigɨnɨ, ‘Nionɨ re seararɨŋɨnɨ, “Ámá gɨyɨ́ gɨyɨ́ nionɨ wiŋápɨ píránɨŋɨ́ nɨmero xwé nimɨxɨrɨ́náyɨ́ ámɨ wínɨ meapɨ́rɨ́árɨnɨ. Gɨyɨ́ gɨyɨ́ nionɨ wiŋápɨ mɨmepa nerɨ kikiɨ́á nerɨ́náyɨ́ apɨ aí ámɨ nurápɨmɨ́árɨnɨ.” seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E nerɨ aiwɨ nionɨ tɨ́nɨ mɨxɨ́ imónarɨŋwáyɨ́ “O negɨ́ mɨxɨ́ ináyɨ́ nimónɨrɨ neameŋweanɨ nánɨ mɨneaimónarɨnɨ.” yaiwíɨ́áyo nɨwirɨmeámɨ nɨbɨro gɨ́ sɨŋwɨ́ anɨŋaé dánɨ pɨkípoyɨ.’ urɨŋɨnigɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisaso ewayɨ́ xwɨyɨ́á apɨ nurárɨmɨ Jerusaremɨ nánɨ nɨyirɨ́ná xámɨ umeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jisaso aŋɨ́ onɨmiá biaú —Aŋɨ́ apiaú dɨ́wɨ́ Oripi rɨnɨŋɨ́pimɨ dánɨ aŋwɨ e imónɨnɨ. Apiaú yoɨ́ Betɨpasi rɨnɨŋɨ́pɨ tɨ́nɨ Betani rɨnɨŋɨ́pɨ tɨ́nɨ tɨ́ŋɨ́ e aŋwɨ e nɨrémorɨ́ná wiepɨsarɨŋɨ́yɨ́ waúmɨ re urowárɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Awagwí aŋɨ́ jɨ́apimɨ nánɨ nuri nɨrémorɨ́ná dogí sɨpɨkɨ́ e yurárɨnɨŋagɨ wɨnɨ́ío —Sɨnɨ ámá seáyɨ e éɨ́ mɨŋweaarɨgɨ́orɨnɨ. Omɨ níkweari nɨmeámɨ bɨ́piyɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ámá wo sɨŋwɨ́ neanɨrɨ ‘Awagwí pí nánɨ íkweaarɨŋiɨ?’ earánáyɨ́, re urɨ́piyɨ, ‘Ámɨnáo seáyɨ e éɨ́ nɨŋwearɨ nɨmeámɨ umɨnɨrɨ nánɨ yearowárɨŋoɨ.’ urɨ́piyɨ.” urowárɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","awaú nuríná xɨ́o urɨ́ɨ́pa axɨ́pɨ eŋagɨ nɨwɨnɨri ");
INSERT INTO aak_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","rɨxa dogí sɨpɨko íkweaarɨ́ná xiáwowa re urɨgɨ́awixɨnɨ, “Pí nánɨ dogíomɨ íkweaarɨŋiɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","awaú “Yegɨ́ Ámɨnáo seáyɨ e éɨ́ nɨŋwearɨ nɨmeámɨ unɨ nánɨ íkweaarɨŋwiɨ.” nurɨri ");
INSERT INTO aak_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jisaso pwarɨŋe nánɨ nɨmeámɨ nuri e nurárɨmáná wigɨ́ rapɨrapɨ́ seáyɨ e yínɨgɨ́ápɨ seáyɨ e nɨwikwiáriro Jisasomɨ seáyɨ e ŋwɨráráná ");
INSERT INTO aak_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","dogíomɨ éɨ́ nɨŋwearɨ nɨmeámɨ warɨ́ná oxɨ́ apɨxɨ́ xɨ́o tɨ́nɨ warɨgɨ́áyɨ́ mɨxɨ́ ináyɨ́yo yayɨ́ wianɨro yarɨgɨ́ápa wigɨ́ iyɨ́á saŋwɨ́yo rɨ́kárɨnɨgɨ́áyɨ́ nɨmearo óɨ́ e íkwiaŋwɨ́ neapára nuro ");
INSERT INTO aak_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","o rɨxa Jerusaremɨ tɨ́ŋɨ́ aŋwɨ e nɨrémorɨ́ná dɨ́wɨ́ mɨŋɨ́ Oripiyɨ rɨnɨŋɨ́pimɨ ipɨ́mieaarɨ́ná xegɨ́ wiepɨsarɨŋɨ́ obaxɨ́ xɨ́o tɨ́ŋɨ́ e epɨ́royɨ́ egɨ́áyɨ́ re egɨ́awixɨnɨ. Emɨmɨ́ Jisaso yarɨŋɨ́ nɨ́nɨyɨ́ sɨŋwɨ́ wɨnayigɨ́á nánɨ yayɨ́ seáyɨmɨ dánɨ nero Gorɨxo nánɨ rɨ́aiwánɨŋɨ́ nɨrɨro yayɨ́ numero ");
INSERT INTO aak_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","re nɨra ugɨ́awixɨnɨ, “Mɨxɨ́ ináyɨ́ Ámɨnáo neaurowáriŋɨ́ ro oyá dɨŋɨ́ tɨ́nɨ seáyɨ e oimónɨnɨ. ‘Aŋɨ́namɨ ŋweaŋoxɨnɨ, joxɨ nɨwayɨrónɨrɨ oŋweanɨ.’ neaimónarɨnɨ. Omɨnɨ seáyɨmɨ dánɨ yayɨ́ oumeaneyɨ.” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisi wa ámá epɨ́royɨ́ egɨ́áyo áwɨnɨmɨ dánɨ re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, dɨxɨ́ wiepɨsarɨŋɨ́yo mɨxɨ́ nurɨrɨ ‘E mɨrɨpa époyɨ.’ ureɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","o re urɨŋɨnigɨnɨ, “Wí pɨ́nɨ wiárɨpɨ́rɨméoɨ. Pɨ́nɨ nɨwiárɨrɨ́náyɨ́, sɨ́ŋá tɨyɨ́ enɨ rɨ́aiwánɨŋɨ́ nɨrɨro nionɨ nánɨ Gorɨxomɨ seáyɨ e umepɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisaso rɨxa Jerusaremɨ tɨ́ŋɨ́ e aŋwɨ e nɨrémorɨ́ná aŋɨ́ apimɨ nɨwɨnɨrɨ́ná ŋwɨ́ nearɨ ");
INSERT INTO aak_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","re rɨŋɨnigɨnɨ, “Jerusaremɨ ŋweáyɨ́né nionɨ éɨ́ píránɨŋɨ́ seaŋwɨrárɨpaxɨ́ imónɨŋápɨ nánɨ nɨjɨ́á nimónɨro sɨŋwɨrɨyɨ́, ayɨ́ naŋɨ́ imónɨmɨnɨrɨ eŋɨ́rɨnɨ. E nerɨ aiwɨ nionɨ segɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ pɨ́nɨ́nɨŋɨ́ imónɨŋagɨ nánɨ seyɨ́né majɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Rɨ́wéná ámá seyɨ́né tɨ́nɨ mɨxɨ́ inarɨgɨ́áyɨ́ awí nɨseamero segɨ́ ákɨŋápimɨ pɨxemoánanɨro nánɨ xwɨ́á waíwɨ́nɨŋɨ́ nɨta nɨpeyiro awí xapɨxapɨ́ nɨseamudɨ́mómáná ");
INSERT INTO aak_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","segɨ́ aŋɨ́ pɨpɨnamɨ́ néra uro niaíwɨ́ pɨpɨkímɨ́ ero nero aŋɨ́ nɨmɨrɨrɨ́ná sɨ́ŋá nɨkɨkírónɨga peyinɨŋɨ́yɨ́ bɨ xe okɨkírónɨnɨrɨ sɨŋwɨ́ wɨnɨpɨ́rɨ́ámanɨ. Yeáyɨ́ seayimɨxemeámɨ́a nánɨ seaímeáagɨ aiwɨ seyɨ́né mí mɨnómɨxɨpa yarɨŋagɨ́a nánɨ e e seaikárɨpɨ́rɨ́árɨnɨ” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisaso rɨxa Jerusaremɨ nɨrémorɨ aŋɨ́ naŋwɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ ámá makerɨ́á nimɨxɨro naŋwɨ́ rɨdɨyowá nánɨ bɨ́ yarɨgɨ́áyo mɨxɨ́dámɨ́ nɨwirɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","re urɨŋɨnigɨnɨ, “Bɨkwɨ́ Gorɨxoyápimɨ xegɨ́ aŋɨ́ riwá nánɨ re nɨrɨnɨrɨ eánɨnɨ, ‘Aŋɨ́ nionɨyáyɨ́ ámá nɨbɨro xwɨyɨ́á rɨrɨmɨ́ nipɨ́rɨ́iwárɨnɨ.’ nɨrɨnɨrɨ eánɨŋagɨ aiwɨ seyɨ́né aŋɨ́ ámá yapɨ́ nɨwiepɨsiro ɨ́wɨ́ uráparɨgɨ́áyɨ́yáiwánɨŋɨ́ imɨxarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","O sɨ́á ayɨ́ ayo aŋɨ́ iwámɨ dánɨ ámáyo uréwapɨyarɨ́ná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Judayɨ́ ámɨná seáyɨ e imónɨgɨ́áwa tɨ́nɨ omɨ “Opɨkianeyɨ.” nɨrɨro aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","oxɨ́ apɨxɨ́ nɨ́nɨ oyá xwɨyɨ́á arɨ́á wianɨro aga nɨwimónarɨŋagɨ nánɨ omɨ pɨkipaxɨ́ bɨ mimónɨŋagɨ nánɨ sɨŋwɨ́ wɨnaxɨ́dɨmegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sɨ́á Jisaso aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ ámáyo xwɨyɨ́á yayɨ́ winɨpaxɨ́ imónɨŋɨ́pɨ uréwapɨyarɨŋɨ́ wɨyimɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ omɨ nɨwímearo ");
INSERT INTO aak_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","re urɨgɨ́awixɨnɨ, “ ‘Joxɨ nénɨ́ tɨ́ŋoxɨ imóneɨ.’ go rɨrɨ́agɨ joxɨ ámá aŋɨ́ riwámɨ makerɨ́á nimɨxɨro naŋwɨ́ rɨdɨyowá nánɨ bɨ́ yarɨgɨ́áyo mɨxɨ́dámɨ́ éɨnigɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","o re urɨŋɨnigɨnɨ, “Nionɨ enɨ yarɨŋɨ́ bɨ oseaimɨnɨ. Soyɨ́né áwaŋɨ́ nɨránáyɨ́, nionɨ yarɨŋɨ́ niarɨgɨ́ápɨ nánɨ enɨ ananɨ áwaŋɨ́ searɨmɨ́ɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yarɨŋɨ́ re wiŋɨnigɨnɨ, “Jono wayɨ́ nɨneameaia uŋo Ŋwɨ́á aŋɨ́namɨ ŋweaŋo urɨ́agɨ rɨ́a eŋɨnigɨnɨ? Xegɨ́ dɨŋɨ́ tɨ́nɨ rɨ́a eŋɨnigɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","wiwanɨŋowa yarɨŋɨ́ ninɨro re rɨnɨgɨ́awixɨnɨ, “None ‘Gorɨxoyá dɨŋɨ́ tɨ́nɨ eŋɨnigɨnɨ.’ uráná re nearɨnɨŋoɨ, ‘Soyɨ́né pí nánɨ o rɨŋɨ́pɨ nánɨ arɨ́á nɨwiro dɨŋɨ́ mɨkwɨ́ropa egɨ́árɨnɨ?’ nearɨnɨ eŋagɨ nánɨ wí e urɨpaxɨ́ menɨnɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ámɨ re rɨnɨgɨ́awixɨnɨ, “E nerɨ aí none ‘Jono xegɨ́ dɨŋɨ́ tɨ́nɨ wáɨ́ nurɨmerɨ wayɨ́ nɨseameaia uŋɨ́rɨnɨ.’ uránáyɨ́ ámá nɨ́nɨ ‘Jono Gorɨxoyá dɨŋɨ́ tɨ́nɨ wɨ́á rókiamoŋɨ́ worɨnɨ.’ nɨyaiwiro nánɨ sɨ́ŋá nɨnearo neapɨkipɨ́rɨxɨnɨ. Apɨ enɨ wí murɨpa oyaneyɨ.” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jisasomɨ re urɨgɨ́awixɨnɨ, “None majɨ́árɨnɨ. Gorɨxoyá dɨŋɨ́ tɨ́nɨ yagɨ́rɨ́anɨ? Xegɨ́ dɨŋɨ́ tɨ́nɨ yagɨ́rɨ́anɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","o re urɨŋɨnigɨnɨ, “Soyɨ́né Jono nánɨ dɨŋɨ́ yaiwiarɨgɨ́ápɨ nánɨ áwaŋɨ́ mɨnɨrɨ́agɨ́a nánɨ nionɨ enɨ ‘Joxɨ e éɨrɨxɨnɨ.’ nɨrɨŋo nánɨ áwaŋɨ́ wí searɨmɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","O ewayɨ́ xwɨyɨ́á rɨpɨ urɨŋɨnigɨnɨ, “Ámá wo wainɨ́ uraxɨ́ omɨŋɨ́ bɨ ɨwɨ́á nura núɨsáná ámá wamɨ re urɨŋɨnigɨnɨ, ‘Gɨ́ omɨŋɨ́ rɨpɨ píránɨŋɨ́ sɨŋwɨ́ nuwɨnaxɨ́díɨ́rɨxɨnɨ.’ nurɨmɨ aŋɨ́ wímɨ urɨ́nɨmɨnɨrɨ nánɨ nurɨ emá obaxɨ́ nɨŋweaŋɨsáná ");
INSERT INTO aak_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","rɨxa wainɨ́ sogwɨ́ yóɨ́ éáná xegɨ́ omɨŋɨ́ wiiarɨgɨ́á wo xɨ́o xegɨ́ wí ourápauinɨnɨrɨ urowárɨ́agɨ aiwɨ omɨŋɨ́ sɨŋwɨ́ uwɨnaxɨ́diarɨgɨ́áwa omɨ ɨ́á nɨxero iwaŋɨ́ nɨmépero anɨ́omɨ wárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Omɨŋɨ́ xiáwo ámɨ xegɨ́ omɨŋɨ́ wiiarɨgɨ́á womɨ urowáráná omɨŋɨ́ sɨŋwɨ́ uwɨnaxɨ́diarɨgɨ́áwa omɨ enɨ iwaŋɨ́ nɨmépero o ayá owinɨnɨrɨ rɨperɨrɨ́ numero anɨ́omɨ wárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Omɨŋɨ́ xiáwo ámɨ omɨŋɨ́ wiiarɨgɨ́á womɨ urowáráná omɨ mɨŋɨ́ nɨroro bɨ́arɨwámɨnɨ moaigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Omɨŋɨ́ xiáwo awa íníná xegɨ́ omɨŋɨ́ wiiarɨgɨ́áwamɨ iwaŋɨ́nɨ nɨmépero anɨ́owamɨ urowárarɨŋagɨ́a nánɨ re yaiwiŋɨnigɨnɨ, ‘Nionɨ arɨre emɨnɨréɨnɨ? Gɨ́ íwɨ́ dɨŋɨ́ sɨxɨ́ uyiŋáomɨ ourowárɨmɨnɨ. “Omɨ xɨxenɨ arɨ́á wipɨ́rɨ́árɨnɨ.” nimónarɨnɨ.’ nɨyaiwirɨ urowárɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","awa xegɨ́ xewaxo barɨŋagɨ sɨŋwɨ́ nɨwɨnɨro re rɨnɨgɨ́awixɨnɨ, ‘Xanoyá dɨŋɨ́ meanɨ́o jɨ́iwo barɨnɨ. Omɨŋɨ́ amɨpíyɨ́ negɨ́ imónɨnɨ́a nánɨ omɨ opɨkianeyɨ.’ nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","omɨ ɨ́á nɨxero bɨ́arɨwámɨnɨ nɨmoaimáná pɨkigɨ́awixɨnɨ.” Jisaso ewayɨ́ xwɨyɨ́á e nurɨrɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Omɨŋɨ́ xiáwo xewaxomɨ pɨkíagɨ́a nánɨ awamɨ pí winɨ́árɨnɨ?” Yarɨŋɨ́ e nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","re urɨŋɨnigɨnɨ, “Omɨŋɨ́ xiáwo nɨbɨrɨ omɨŋɨ́ sɨŋwɨ́ uwɨnaxɨ́diarɨgɨ́áwamɨ pɨpɨkímɨ́ nɨyárɨmáná omɨŋɨ́ ámɨ wa sɨŋwɨ́ onɨwɨnaxɨ́dípoyɨnɨrɨ mɨnɨ winɨ́árɨnɨ.” urɨ́agɨ ámá e rówapɨgɨ́á arɨ́á e nɨwiro “Jisaso ‘Judayɨ́né omɨŋɨ́ sɨŋwɨ́ uwɨnaxɨ́diarɨgɨ́áyɨ́ yapɨ imónɨŋoɨ.’ rɨ́a neararɨnɨ?” nɨyaiwiro re rɨgɨ́awixɨnɨ, “ ‘Oweoɨ! Wí e enɨ́ámanɨ.’ neaimónarɨnɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","o sɨŋwɨ́ agwɨ́ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Seyɨ́né ‘Wí e epaxɨ́ menɨnɨ.’ yaiwiarɨŋagɨ́a aí pí nánɨ Bɨkwɨ́yo ewayɨ́ xwɨyɨ́á rɨpɨ eŋíná nɨrɨro eagɨ́awixɨnɨ, ‘Sɨ́ŋá aŋɨ́ mɨrarɨgɨ́áwa sɨ́ŋá awiaxɨ́ wo nánɨ pɨ́á nerɨ́ná wo “Sɨpíxɨnɨ.” nɨrɨro emɨ móɨ́o Gorɨxo “Awiaxorɨnɨ.” nɨrɨrɨ nɨmearɨ aŋɨ́ xɨ́o mɨrarɨŋiwámɨ iwamɨ́ó nɨtɨwayɨrorɨ mɨrɨŋɨ́rɨnɨ.’ xwɨyɨ́á wɨ́á rókiamoagɨ́áwa e nɨrɨro eagɨ́ápɨ pí nánɨ rɨnɨnɨ? Seyɨ́né dɨŋɨ́ rɨmoarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sɨxɨ́ botorɨxɨ́ sɨ́ŋáyo nɨpiérorɨ pɨ́rɨ́ miyeámɨ́ inarɨŋɨ́pa ámá gɨyɨ́ gɨyo sɨ́ŋáo nɨpiérorɨ xaíwɨ́ nearɨ́náyɨ́ axɨ́pɨ imónɨpɨ́rɨ́árɨnɨ. Xwasɨ́wɨ́ yeáyɨ́ bimɨ sɨ́ŋá nɨpiérorɨ nearɨ́ná yunɨ́ wárarɨŋɨ́pa sɨ́ŋáo ámá gɨyɨ́ gɨyo nɨpiérorɨ nearɨ́ná axɨ́pɨ xwasɨ́wɨ́ yunɨ́nɨŋɨ́ imɨxɨmɨ́árɨnɨ.” Jisaso xɨ́o sɨ́ŋáónɨŋɨ́ nimónɨrɨ nánɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ awa “Jisaso ewayɨ́ xwɨyɨ́á nɨnearɨrɨ́ná ‘Soyɨ́né omɨŋɨ́ xiáwomɨ xewaxo pɨkíɨ́ánɨŋɨ́ imónɨŋoɨ.’ rɨ́a neararɨnɨ?” nɨyaiwiro axíná “Rɨxa ɨ́á oxɨraneyɨ.” nɨyaiwiro aiwɨ oxɨ́ apɨxɨ́ e epɨ́royɨ́ egɨ́áyɨ́ nánɨ wáyɨ́ nɨwiro ɨ́á mɨxɨrɨpa nero ");
INSERT INTO aak_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","sɨŋwɨ́ nɨwɨnaxɨ́da nemero ámá wa yapɨ́ nɨwíwapɨyiro sɨŋwɨ́ nɨwɨnaróa oúpoyɨnɨrɨ nurowárɨro re urɨgɨ́awixɨnɨ, “Soyɨ́né ámá naŋoyɨ́nénɨŋɨ́ nimónɨro yapɨ́ nɨwíwapɨya nurɨ́ná pasánɨŋɨ́ nɨméra úpoyɨ. Xwɨyɨ́á omɨ ananɨ gwɨ́ yipaxɨ́ wí ránáyɨ́, rɨxa omɨ ɨ́á xepɨ́rɨ nánɨ gapɨmanomɨ áwaŋɨ́ uranɨ nánɨ re urɨ́poyɨ, ‘Takisɨ́ nánɨ nɨgwɨ́ émáyɨ́ nearáparɨgɨ́ápɨ sɨnɨ mɨnɨ wianɨréwɨnɨ? Mɨnɨ mɨwipa yanɨréwɨnɨ?’ urɨ́poyɨ. O ‘Oweoɨ, sɨnɨ mɨnɨ mɨwipa époyɨ.’ ránáyɨ́ émáyɨ́ omɨ ɨ́á nɨxero gwɨ́ yipɨ́ráoɨ.” urowárɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","awa nuro Jisasomɨ nɨwímearo pasánɨŋɨ́ nɨméra nurɨ́ná weyɨ́ re umearɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ xwɨyɨ́á nɨrɨrɨ nɨnearéwapɨyirɨ́ná náyonɨ nearéwapɨyarɨŋoxɨ eŋagɨ nánɨ nene nɨjɨ́árɨnɨ. Ámá gɨyɨ́ gɨyɨ́ símeáagɨ́a aí sɨ́mɨmaŋɨ́ sɨŋwɨ́ nɨwɨnɨrɨ sɨŋwɨ́ nánɨ wáyɨ́ mé xwɨyɨ́á Gorɨxoyá nepánɨ urarɨŋɨ́pɨ nearéwapɨyarɨŋoxɨrɨnɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","yarɨŋɨ́ re wigɨ́awixɨnɨ, “Dɨŋɨ́ joxɨyá píoɨ yaiwiarɨŋɨnɨ? ‘Nene émáyɨ́ mɨxɨ́ ináyɨ́ Sisaomɨ takisɨ́ nánɨ nɨgwɨ́ mɨnɨ nɨwiayiranéná apánɨ wiarɨŋwɨnɨ.’ rɨsimónarɨnɨ? ‘Nɨpɨkwɨnɨ mɨyarɨŋwɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jisaso yapɨ́ wíwapɨyanɨro yarɨgɨ́ápɨ nánɨ dɨŋɨ́ adadɨ́ nɨwirɨ nɨjɨ́á nimónɨrɨ nánɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Émáyɨ́yá monɨ́ bɨ sɨwá nípoyɨ.” nurɨrɨ rɨxa sɨwá wíáná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Nɨgwɨ́ rɨpimɨ yoɨ́ goyá eánɨrɨ sɨ́mɨmaŋɨ́ goyá ŋwɨrárɨnɨrɨ inɨnɨ?” urɨ́agɨ awa “Émáyɨ́ mɨxɨ́ ináyɨ́ Sisaoyá eánɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","o re urɨŋɨnigɨnɨ, “Nɨgwɨ́ rɨpimɨ sɨ́mɨmaŋɨ́ Sisaoyá ŋwɨrárɨnɨŋagɨ nánɨ xewanɨŋomɨ mɨnɨ wíɨ́rɨxɨnɨ. Amɨpí nɨ́nɨ oyá imónɨŋɨ́yɨ́ enɨ xewanɨŋomɨ wíɨ́rɨxɨnɨ. E nerɨ aí amɨpí Gorɨxoyá imónɨŋɨ́yɨ́ xɨ́omɨ wíɨ́rɨxɨnɨ.” Jisaso Gorɨxo ámá xewanɨŋónɨŋɨ́ imɨxɨnɨŋɨ́ eŋagɨ nánɨ omɨ dɨŋɨ́ owɨkwɨ́rɨ́poyɨnɨrɨ e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","awa yapɨ́ nɨwíwapɨyiro pasánɨŋɨ́ e uméɨ́á aí ámáyá sɨŋwɨ́yo dánɨ Jisaso xwɨyɨ́á meárɨnɨpaxɨ́ wí mɨrarɨŋagɨ arɨ́á nɨwiro ámá nɨ́nɨ enɨ Jisaso píránɨŋɨ́ e reŋwɨpearɨŋagɨ arɨ́á nɨwiro nánɨ ududɨ́ nero xwɨyɨ́á bɨ murɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ámá Judayɨ́ wa, Sajusiyɨ rɨnɨŋɨ́ wa —Sajusiowa re rarɨgɨ́áwarɨnɨ, “Ámá nɨpémáná eŋánáyɨ́ wí nɨwiápɨ́nɨmeapɨ́rɨ́ámanɨ.” rarɨgɨ́áwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Awa nɨbɨro Jisasomɨ yarɨŋɨ́ wianɨro nánɨ re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, eŋíná Moseso ŋwɨ́ ikaxɨ́ nɨnearɨrɨ́ná nene nánɨ nɨrɨrɨ rɨ́wamɨŋɨ́ re eaŋɨ́rɨnɨ, ‘Ámá go go apɨxɨ́ nɨmearɨ niaíwɨ́ memeá péánáyɨ́ ámɨ xexɨrɨ́meáo apɨxɨ́ anímɨ nɨmearɨ peŋoyá niaíwɨ́ wo wiemeaíwɨnɨgɨnɨ.’ Moseso e nɨrɨrɨ eaŋɨ́rɨnɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ewayɨ́ xwɨyɨ́á rɨpɨ urɨgɨ́awixɨnɨ, “Xɨráxogwá wé wɨ́úmɨ dáŋɨ́ waú egɨ́áwa xɨráo apɨxɨ́ wí nɨmearɨ niaíwɨ́ memeá péáná ");
INSERT INTO aak_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","xogwáo wo anímɨ nɨmearɨ niaíwɨ́ memeá péáná ");
INSERT INTO aak_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ámɨ wo nɨmearɨ niaíwɨ́ memeá péáná wé wɨ́úmɨ dáŋɨ́ waú imónɨgɨ́áwa nowanɨ o o ímɨ nɨmeaayiro aiwɨ niaíwɨ́ wí memeá nowanɨ rɨxa péáná ");
INSERT INTO aak_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","apɨxí enɨ xɨráxogwá nowamɨnɨ nɨmeánɨrɨ nɨpemɨxárɨmáná xɨ́í enɨ peŋɨnigɨnɨ.” Ewayɨ́ xwɨyɨ́á Jisasomɨ e nurɨmáná ");
INSERT INTO aak_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","omɨ majɨ́á wikɨxeáranɨro nánɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ winɨ́a nánɨ pegɨ́á nɨ́nɨ nɨwiápɨ́nɨmearɨ́ná í xɨráxogwá wé wɨ́úmɨ dáŋɨ́ waú nowanɨ meagɨ́í eŋagɨ nánɨ goyáí imónɨnɨ́árɨ́anɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisaso re urɨŋɨnigɨnɨ, “Ríná ámá apɨxɨ́ ŋwɨrárɨro mearo inarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","E nerɨ aí rɨ́wéná Gorɨxo meŋweaŋáná ámá oyá sɨŋwɨ́yo dánɨ ananɨ nɨwiápɨ́nɨmearo ŋweapɨ́rɨ́áyɨ́ apɨxɨ́ ŋwɨrárɨnɨro meánɨro inɨpɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Íná ámɨ bɨ nɨpepaxɨ́ imónɨpɨ́rɨ́ámanɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Aŋɨ́najowa yarɨgɨ́ápa nero ŋweapɨ́rɨ́árɨnɨ. Gorɨxoyá dɨŋɨ́yo dánɨ xwárɨpáyo dánɨ wiápɨ́nɨmeapɨ́rɨ́á eŋagɨ nánɨ ayɨ́ Gorɨxoyá niaíwɨ́ nimónɨro anɨŋɨ́ íníná ŋweapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Soyɨ́né dɨŋɨ́ ‘Pegɨ́áyɨ́ wí nɨwiápɨ́nɨmeapaxɨ́ menɨnɨ.’ yaiwiarɨŋagɨ́a aiwɨ ananɨ nɨwiápɨ́nɨmeapɨ́rɨ́árɨnɨ. Xwɨyɨ́á eŋíná Moseso íkɨ́á onɨmiánáɨna ɨwɨ́ rɨ́á mɨnɨ́ ápiáwɨ́ wearɨŋagɨ wɨnɨŋɨ́pɨ nánɨ rɨ́wamɨŋɨ́ nearɨ́ná Gorɨxo xewanɨŋo nánɨ urɨnɨŋɨ́pɨ re nɨrɨrɨ eaŋɨ́rɨnɨ, ‘Gorɨxonɨ dɨxɨ́ ráwowa Ebɨrɨ́amo tɨ́nɨ Aisako tɨ́nɨ Jekopo tɨ́nɨ awayá Ŋwɨ́áonɨrɨnɨ.’ Moseso rɨ́wamɨŋɨ́ e nearɨ́ná xiáwowa rɨxa pegɨ́á aiwɨ o rɨ́wamɨŋɨ́ e nɨrɨrɨ eaŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gorɨxo omɨ e nurɨrɨ́ná omɨ xiáwowa rɨxa pegɨ́ámɨ aiwɨ Gorɨxoyá sɨŋwɨ́yo dánɨ wigɨ́ dɨŋɨ́ sɨnɨ sɨŋɨ́ eŋagɨ nánɨ e rɨpaxɨ́rɨnɨ. Gorɨxo ámá pegɨ́áyɨ́ nánɨ Ŋwɨ́áomanɨ. Sɨŋɨ́ egɨ́áyɨ́ nánɨ Ŋwɨ́áorɨnɨ. Oyá sɨŋwɨ́yo dánɨ ámá nɨ́nɨ wí pegɨ́á aiwɨ, wigɨ́ dɨŋɨ́ sɨnɨ sɨŋɨ́ eŋagɨ nánɨ nɨ́nɨ sɨnɨ sɨŋɨ́rɨnɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa ámɨ dɨŋɨ́ sɨxɨ́ mínɨpa nero yarɨŋɨ́ ámɨ wínɨ bɨ mɨwí re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ wigɨ́ yarɨŋɨ́ síɨ́ápɨ nánɨ nurɨrɨ́ná aga naŋɨ́ urarɨŋɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisaso re urɨŋɨnigɨnɨ, “Ámá pí nánɨ re rarɨgɨ́árɨnɨ, ‘Ámá nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o sa mɨxɨ́ ináyɨ́ Depitoyá xiáwo imónɨnɨ́árɨnɨ.’ pí nánɨ rarɨgɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Bɨkwɨ́ Samɨyɨ rɨnɨŋɨ́yo Depito xewanɨŋo ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o nánɨ nɨrɨrɨ rɨ́wamɨŋɨ́ rɨpɨ eaŋɨ́rɨnɨ, ‘Gorɨxo gɨ́ Ámɨnáomɨ re urɨŋɨnigɨnɨ, “Joxɨ wé náúmɨnɨ éɨ́ nɨŋwearɨ joxɨ tɨ́nɨ mɨxɨ́ inɨ́áyo xopɨrárɨ́ rɨwiimɨ́aé nánɨ xwayɨ́ nanɨrɨ ŋweáɨrɨxɨnɨ.” Gorɨxo gɨ́ Ámɨnáomɨ e urɨŋɨnigɨnɨ.’ Depito rɨ́wamɨŋɨ́ apɨ nearɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","xegɨ́ xiáwo nánɨ ‘Gɨ́ Ámɨnáorɨnɨ.’ nɨrɨrɨ nánɨ arɨge xegɨ́ xiáwo imónɨnɨ?” Jisaso ámá nɨ́nɨ “Ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo ananɨ Depitomɨ seáyɨ e nimónɨrɨ nepa Gorɨxoyá xewaxorɨ́anɨ?” oyaiwípoyɨnɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ámá nɨ́nɨ o e rarɨŋagɨ arɨ́á wiarɨ́ná xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa yarɨgɨ́ápa mepa éɨ́rɨxɨnɨ. Awa ámá weyɨ́ oneamépoyɨnɨrɨ rapɨrapɨ́ sepiánɨ nɨyínɨmɨ aŋɨ́ emero ámá makerɨ́á imɨxarɨgɨ́e dánɨ ‘Ámɨnáoxɨnɨ.’ onearɨ́poyɨnɨrɨ emero rotú aŋɨ́yo nɨpáwirónáranɨ, aiwá imɨxarɨgɨ́e nɨrémorónáranɨ, ‘Ámá nɨyɨ́yá sɨ́mɨ́ sɨ́mɨ́ e oŋweaaneyɨ.’ nɨyaiwiro ero ");
INSERT INTO aak_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","sɨ́wí yáɨ́ rɨ́kínɨŋɨ́yɨ́ yapɨ ámáyá aiwá pɨrɨ́ nɨ́nɨ ɨ́wɨ́ manarɨgɨ́ápa apɨxɨ́ aníwayá amɨpí ɨ́wɨ́ urápanɨro nánɨ ero ámáyá sɨŋwɨ́yo dánɨ Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwiróná anɨŋɨ́ minɨ́ nɨra uro yarɨgɨ́ápa soyɨ́né enɨ axɨ́pɨ mepa éɨ́rɨxɨnɨ. Rɨ́wéná Gorɨxo ámá nɨyonɨ mí ómómɨxɨmɨ́ yarɨ́ná awa xwɨyɨ́á xwé meárɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","O sɨnɨ aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ ínɨmɨ nuréwapɨya nemerɨ́ná sɨŋwɨ́ anɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Amɨpí mɨmúrónɨgɨ́áyɨ́ nɨgwɨ́ Gorɨxo nánɨ tayarɨgɨ́e tarɨŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","apɨxɨ́ anɨ́ uyípeayɨ́ imónɨŋɨ́ wí enɨ nɨgwɨ́ rɨ́á inɨŋɨ́ waú nɨmeáa nɨbɨrɨ tɨ́agɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","xegɨ́ wiepɨsarɨŋɨ́yo re urɨŋɨnigɨnɨ, “Nionɨ nepa seararɨŋɨnɨ, ‘Apɨxɨ́ anɨ́ uyípeayɨ́ imónɨŋɨ́ rí Gorɨxo nánɨ nɨgwɨ́ onɨmiá sɨpípɨkwɨ nɨtɨrɨ aiwɨ Gorɨxoyá sɨŋwɨ́yo dánɨ amɨpí mɨmúrónɨgɨ́áyɨ́ tɨ́áyo seáyɨ e imónɨgoɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Amɨpí mɨmúrónɨgɨ́áyɨ́ wigɨ́ nɨgwɨ́ xwé ayo dánɨ bɨ nɨmearo nɨtɨro aiwɨ apɨxɨ́ anɨ́ ríyɨ́ xegɨ́ aiwá nánɨ bɨ́ yanɨpaxɨ́ ówɨ tɨ́agɨ nánɨ íyá seáyɨ e imónɨgoɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Xegɨ́ wiepɨsarɨŋɨ́ wa aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwá nánɨ re rɨgɨ́awixɨnɨ, “Aŋɨ́ riwá nɨmɨrɨrɨ́ná sɨ́ŋá awiaxɨ́ nɨkɨkíróa nuro aŋɨ́ riwá imɨrɨŋɨ́ mimónɨpa oenɨrɨ amɨpí naŋɨ́ ámá Gorɨxo nánɨ wigɨ́áyɨ́ nɨmearo okiyɨ́á egɨ́árɨnɨ.” rarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jisaso arɨ́á e nɨwirɨ re urɨŋɨnigɨnɨ, “Amɨpí naŋɨ́ soyɨ́né sɨŋwɨ́ wɨnarɨgɨ́á rɨpɨ rɨ́wéná ámá wa aŋɨ́ riwá nɨpɨnearɨ́ná sɨ́ŋá nɨkɨkírónɨga uŋɨ́ rɨpɨ nɨpɨneaayiro emɨ mɨmeámɨ́ éáná sɨ́ŋá wo womɨ sɨnɨ seáyɨ e ikwiárɨnɨnɨ́ámanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","awa yarɨŋɨ́ re wigɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ neararɨŋɨ́ apɨ gíná imónɨnɨ́árɨnɨ? Pí sɨ́mɨmajɨ́ónɨŋɨ́ neaináná ‘Rɨxa nimónɨnɨ ayorɨ́anɨ?’ yaiwianɨ́wárɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","o re urɨŋɨnigɨnɨ, “Ámá wa yapɨ́ seaíwapɨyipɨ́rɨxɨnɨrɨ dɨŋɨ́ píránɨŋɨ́ morɨ́ɨnɨ. Obaxɨ́ nɨbɨro gɨ́ yoɨ́ nɨrɨnɨro re rɨpɨ́rɨ́árɨnɨ, ‘Nionɨ onɨrɨnɨ. Rɨxa ínárɨnɨ.’ searáná arɨ́á nɨwiro númɨ muxɨ́dɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Soyɨ́né ‘Aŋɨ́ wíyo mɨxɨ́ inarɨŋoɨ.’ rarɨŋagɨ́a arɨ́á wiro ‘Ámá nɨpánɨ mɨxɨ́ íkwɨ́naroarɨŋoɨ.’ rarɨŋagɨ́a arɨ́á wiro nerɨ́ná wáyɨ́ mikárɨnɨpanɨ. Apɨ xámɨ imónɨnɨ́árɨnɨ. E eŋagɨ aiwɨ apɨ rɨxa nimónɨmáná eŋáná soyɨ́né ‘Sɨ́á yoparɨ́yi, o weapɨnɨ́áyi rɨxa nimónɨnɨŋoɨ.’ mɨyaiwipa éɨ́rɨxɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ámɨ re urɨŋɨnigɨnɨ, “Ámá gwɨ́ axɨ́rí nɨwiápɨ́nɨmearo ámá xeŋwɨ́ wí tɨ́nɨ mɨxɨ́ inɨro mɨxɨ́ ináyɨ́ woyá woyáyɨ́ tɨ́nɨ mɨxɨ́ inɨro ");
INSERT INTO aak_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","pobonɨ́ xwé néra urɨ aŋɨ́ nɨyonɨ aiwá nánɨ dɨ́wɨ́ ikeamónɨro aŋɨ́ wí e wí e sɨmiárɨ́ wímearɨ aŋɨ́ pɨrɨ́yo dánɨ xegɨ́ bɨ nimónɨrɨ ekɨyiŋɨ́ ináná ámá wáyɨ́ ikárɨnɨpɨ́rɨ nánɨ imónɨrɨ enɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ayɨ́ e enɨ́á imónɨŋagɨ aiwɨ sɨnɨ mimónɨpa eŋáná ɨ́á nɨseaxero xeanɨŋɨ́ seaikárɨpɨ́rɨ́árɨnɨ. E nɨseairɨ́ná xwɨrɨxɨ́ seamepɨ́rɨ nánɨ awí eánarɨgɨ́e nɨsearowárɨro gwɨ́ aŋɨ́yo nɨseaŋwɨrárɨro nionɨ nɨxɨ́darɨŋagɨ́a nánɨ xwɨyɨ́á seamearɨpɨ́rɨ nánɨ mɨxɨ́ ináyɨ́yá sɨŋwɨ́ tɨ́ŋɨ́ e nánɨ tɨ́nɨ gapɨmanɨ́yɨ́yá sɨŋwɨ́ tɨ́ŋɨ́ e nánɨ tɨ́nɨ nɨseameámɨ seaupɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","E seaipɨ́rɨ́á eŋagɨ aí ananɨrɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Xwɨrɨxɨ́ seamearɨ́ná nionɨ nánɨ áwaŋɨ́ urɨpɨ́rɨ imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Xwɨrɨxɨ́ seamearɨ́ná nionɨ dɨŋɨ́ nɨseakɨkayorɨ nɨjɨ́á nɨseaiapɨrɨ xwɨyɨ́á urɨpɨ́rɨ nánɨ imónɨpɨ́rɨ seaimɨxɨmɨ́á eŋagɨ nánɨ soyɨ́né xwɨrɨxɨ́ seamepɨ́rɨ́áyɨ́ wí pɨ́rɨ́ seawiaíkipaxɨ́ menɨnɨ. Ayɨnánɨ soyɨ́né sɨnɨ ɨ́á mɨseaxɨrɨpa eŋánáyɨ́, dɨŋɨ́ re móɨ́rɨxɨnɨ, ‘Ananɨrɨnɨ. Xwɨyɨ́á pɨ́rɨ́ wiaíkímɨnɨrɨ nánɨ meŋwɨpepa oemɨnɨ. Sa Gorɨxoyá dɨŋɨ́yo dánɨ urɨ́ɨmɨgɨnɨ.’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Segɨ́ sénáíwaranɨ, sénowaranɨ, sérɨxɨ́meáowaranɨ, nawínɨ mɨnɨgɨ́áyɨ́ranɨ, nɨkumɨxɨnɨrɨ emearɨgɨ́áyɨ́ranɨ, mɨyɨ́ seauráná segɨ́yɨ́ wɨ́amɨ pɨkipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Soyɨ́né nionɨ nɨxɨ́darɨŋagɨ́a nánɨ ámá nɨ́nɨ wikɨ́ nɨseaónɨro sɨ́mɨ́ tɨ́nɨ seaipɨ́rɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gorɨxo yeáyɨ́ seayimɨxemeanɨ́á eŋagɨ nánɨ soyɨ́né anɨpá wí imónɨpɨ́rɨ́ámanɨ. Segɨ́ dɨ́á wí aí anɨpá imónɨnɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Soyɨ́né eŋɨ́ neánɨro nionɨ anɨŋɨ́ nɨnɨxɨ́dɨrónáyɨ́, segɨ́ dɨŋɨ́pɨ erɨ́kiemeánɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“E nerɨ aí mɨxɨ́ nɨmeámɨ bɨ́áyɨ́ aŋɨ́ Jerusaremɨ rɨpimɨ awí mudɨ́móagɨ́a nɨwɨnɨróná ‘Rɨxa aŋɨ́ rɨpɨ xwɨrɨ́á ikɨxepɨ́rɨ aŋwɨ ayorɨ́anɨ?’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","E nɨwɨnɨróná ámá Judia pɨropenɨsɨ́yo ŋweagɨ́áyɨ́ dɨ́wɨ́ mɨŋɨ́yo nánɨ éɨ́ yiro ámá Jerusaremɨ apimɨ ŋweagɨ́áyɨ́ pɨ́nɨ nɨwiárɨmɨ uro ámá apimɨ bɨ́arɨwámɨnɨ omɨŋɨ́yo amɨ amɨ yarɨgɨ́áyɨ́ aŋɨ́ apimɨ ámɨ mɨrémopa ero éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ínáyɨ́ Gorɨxo xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaikárɨnɨ́á apɨrɨnɨ. Íná amɨpí nɨ́nɨ nánɨ Bɨkwɨ́yo nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Íná xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ xwɨ́á tɨ́yo seaímeanɨ́á eŋagɨ nánɨ apɨxɨ́ niaíwɨ́ agwɨ́ egɨ́íwa tɨ́nɨ sɨnɨ niaíwɨ́ amɨŋɨ́ wiarɨgɨ́íwa tɨ́nɨ éɨ́ aŋɨ́nɨ mupaxɨ́ imónɨŋagɨ nánɨ aweyɨ! Gorɨxo ámá tɨ́yo wikɨ́ nɨwónɨrɨ xeanɨŋɨ́ wikárarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","mɨxɨ́ nɨmeáa bɨ́áyɨ́ Jerusaremɨ ŋweáyo kirá tɨ́nɨ pɨpɨkímɨ́ ero ɨwɨ́ meaanɨro nánɨ nɨpɨkiomearo wigɨ́ aŋɨ́ ayɨ́ ayo nánɨ nɨmeámɨ umiro epɨ́rɨ́árɨnɨ. E nemáná émáyɨ́ nɨbɨro Jerusaremɨ dáŋɨ́yɨ́né seáyɨ e nɨseaimónɨro xwɨraimɨmɨ́ nɨseaikɨxéa nuro Gorɨxo ‘Yoparɨ́ e imónɨ́wɨnɨgɨnɨ.’ yaiwiárɨŋe imónɨŋáná rɨxa re imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sogwɨ́ tɨ́nɨ emá tɨ́nɨ siŋɨ́ tɨ́nɨ ekɨyiŋɨ́nɨŋɨ́ ináná ámá xwɨ́á tɨ́yo nɨyonɨ gwɨ́ ararí ŋweagɨ́áyɨ́ ayá sɨ́wɨ́ nurorɨ dɨŋɨ́ rɨ́á uxenɨ́árɨnɨ. Rawɨrawá enɨ xwé ayá wí nɨróga nɨwiápɨ́nɨmeáɨsáná nɨjirɨ moarɨŋagɨ nɨwɨnɨróná ududɨ́ winɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Siŋɨ́ sogwɨ́ amɨpí aŋɨ́ pɨrɨ́yo eŋɨ́yɨ́ aŋɨ́nɨ mɨxénapɨ́agɨ nɨwɨnɨróná ‘Xwɨ́á tɨ́yo ŋweaŋwaéne pí neaimɨnɨrɨ rɨ́a yarɨnɨ?’ nɨyaiwiro wáyɨ́ nikárɨnɨróná eanɨramoro wepɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","E neróná sɨŋwɨ́ re nanɨpɨ́rɨ́árɨnɨ. Ámá imónɨŋáonɨ nikɨ́nɨmáná eŋɨ́ neánɨrɨ agwɨ́ tɨ́nɨ nawínɨ weaparɨŋagɨ nanɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","E nerɨ aí soyɨ́né sogwɨ́ emá amɨpí ekɨyiŋɨ́ inarɨŋagɨ nɨwɨnɨrɨ́ná ‘Gwɨ́nɨŋɨ́ nearoayíronɨ aŋwɨ ayorɨ́anɨ?’ nɨyaiwiro píránɨŋɨ́ éɨ́ nɨrómáná nionɨ nánɨ wenɨŋɨ́ nɨyánɨrɨ róɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","O awamɨ ewayɨ́ xwɨyɨ́á bɨ re urɨŋɨnigɨnɨ, “Íkɨ́á pikɨ́ tɨ́nɨ íkɨ́á nɨ́nɨ enɨ yarɨŋɨ́pɨ nánɨ dɨŋɨ́ mópoyɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Íkɨ́á mɨŋɨ́ inarɨŋagɨ nɨwɨnɨróná ‘Rɨxa xwiogwɨ́rɨ́anɨ?’ yaiwiarɨgɨ́ápa ");
INSERT INTO aak_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","siŋɨ́ amɨpí ekɨyiŋɨ́nɨŋɨ́ enɨ axɨ́pɨ inarɨŋagɨ nɨwɨnɨróná ‘Gorɨxo nene xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ rɨxa aŋwɨ ayorɨ́anɨ?’ yaiwíɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nionɨ nepa seararɨŋɨnɨ, ‘Ámá agwɨ́ ríná ŋweagɨ́áyɨ́ sɨnɨ mɨpepa eŋáná amɨpí nɨ́nɨ nionɨ Jerusaremɨ nánɨ searɨ́ápɨ xɨxenɨ nimónɨnɨ́árɨnɨ.’ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aŋɨ́na tɨ́nɨ xwɨ́á rɨrí tɨ́nɨ ananɨ anɨpá nimónɨrɨ aiwɨ xwɨyɨ́á nionɨyá wí surɨ́má imónɨnɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mɨ́rɨxɨ́ maiwí nɨpúɨsáná mɨ́rogwɨ́ rɨxa ɨ́á nɨwiárɨmɨxɨrɨ́ná nɨpiérorɨ nearɨ́ná yarɨŋɨ́pa soyɨ́né enɨ segɨ́ waráyo nánɨnɨ nɨyaiwinɨro aiwá xwé nɨro iniɨgɨ́ wainɨ́ xwé nɨro yanɨro nánɨ yarɨ́náyɨ́ sɨ́á nionɨ weapɨmɨ́áyi axɨ́pɨ e seaímeanɨgɨnɨrɨ dɨŋɨ́ tɨ́nɨ ŋweáɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sɨ́á nionɨ weapɨmɨ́á nánɨ imónɨ́áyi ámá xwɨ́á rɨrí nɨrímɨnɨ ŋweagɨ́áyo nɨwimónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Soyɨ́né íníná awínɨŋɨ́ nɨŋwearóná Gorɨxomɨ yarɨŋɨ́ re wíɨ́rɨxɨnɨ, ‘None amɨpí neaímeááná eŋɨ́ neánɨrane múrorane ámá imónɨŋoyá sɨ́mɨmaŋɨ́mɨnɨ éɨ́ rorane yanɨ́wá nánɨ eŋɨ́ bɨ sɨxɨ́ neaímɨxeɨ.’ urɨ́ɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ikwáwɨyíná aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ ámáyo nuréwapɨya núɨsáná sɨ́ápɨ tɨ́nɨ nɨpeyearɨ dɨ́wɨ́ mɨŋɨ́ Oripiyɨ rɨnɨŋɨ́pimɨ sá wémɨnɨrɨ nánɨ yagɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","O sɨ́á ayɨ́ ayo e yarɨ́ná ámá nɨ́nɨ wɨ́á mónɨŋɨ́mɨ nɨwiápɨ́nɨmearo omɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ arɨ́á wianɨro nánɨ bayagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sɨ́á Judayɨ́ bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro narɨgɨ́áyi, sɨ́á Aŋɨ́najo Wiárɨ́ Neamúroagoɨ rɨnɨŋɨ́yi —Eŋíná sɨ́á ayi Judayo Isipɨyɨ́ mɨxɨ́ ináyo ɨ́á xeŋwɨrárɨŋáná Gorɨxo niaíwɨ́ oxɨ́ xámɨŋɨ́ nɨ́nɨ opɨkímɨnɨrɨ aŋɨ́najɨ́ oyáo urowárɨŋɨ́ aiwɨ Judayɨ́ Gorɨxo ŋwɨ́ ikaxɨ́ urɨŋɨ́pɨ bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro nɨnɨro sipɨsipɨ́ nɨpɨkiro ówaŋɨ́yo ragɨ́ xópé yárɨ́á eŋagɨ nánɨ aŋɨ́najo ayo múroŋɨnigɨnɨ. Ayɨnánɨ xwiogwɨ́ o o pwéáná sɨ́á ayi nánɨ dɨŋɨ́ mopɨ́rɨ nánɨ sipɨsipɨ́ nɨpɨkiro bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro narɨgɨ́árɨnɨ. Rɨxa sɨ́á ayi aŋwɨ e imónáná ");
INSERT INTO aak_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ oxɨ́ apɨxɨ́ nɨ́nɨ nánɨ wáyɨ́ nero nánɨ “Jisasomɨ arɨre yumɨ́í ínɨmɨ pɨkianɨ́wɨnɨ?” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Isɨkariotɨ dáŋɨ́ Judaso —O Jisasoyá wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú imónɨgɨ́áyɨ́ worɨnɨ. Omɨ Seteno rɨ́wɨ́mɨnɨ nɨrorɨ dɨŋɨ́ uxɨxéróáná ");
INSERT INTO aak_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","o nurɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́yá porisowa tɨ́nɨ xwɨyɨ́á nɨrɨnárɨro Judaso re urɨŋɨnigɨnɨ, “Soyɨ́né omɨ ɨ́á xɨrɨpɨ́rɨ nánɨ nionɨ arɨre nerɨ pasánɨŋɨ́ umemɨ́árɨnɨ?” uráná ");
INSERT INTO aak_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","awa yayɨ́ nɨwinɨro re urɨgɨ́awixɨnɨ, “Joxɨ e neaiíáná nɨgwɨ́ siapanɨ́wárɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judaso “Ananɨrɨnɨ.” nurɨmɨ nurɨ ámá oxɨ́ apɨxɨ́ epɨ́royɨ́ mɨwipa eŋáná omɨ pasá umemɨnɨrɨ nánɨ wenɨŋɨ́ wiaxɨ́dɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jisaso, sɨ́á bisɨ́kerɨ́á yisɨ́ mayɨ́ úrapí nimɨxɨro iwamɨ́ó nɨgɨ́áyi —Ayɨ́ sɨ́á Aŋɨ́najo mɨpɨkí Wiárɨ́ Múroŋɨ́ nánɨ sipɨsipɨ́ miá nɨpɨkiro narɨgɨ́áyirɨnɨ. Sɨ́á ayi imónáná ");
INSERT INTO aak_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","o Pitaomɨ tɨ́nɨ Jonomɨ tɨ́nɨ re urɨŋɨnigɨnɨ, “Awagwí none aiwá aŋɨ́najo eŋíná neamúroagɨ́ nánɨ nanɨ nánɨ nuri neaimɨxɨ́piyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","awaú re urɨgɨ́isixɨnɨ, “Joxɨ ‘Awaú ge nuri píránɨŋɨ́ oimɨxɨ́piyɨ.’ simónarɨnɨ?” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","o re urɨŋɨnigɨnɨ, “Awagwí aŋɨ́ e nɨrémorɨ́ná iniɨgɨ́ sɨxɨ́ maxɨrɨŋɨ́ wo tɨ́nɨ órórɨ́ ninɨrɨ́ná númɨ nuri aŋɨ́ o páwíiwámɨ awagwí enɨ nɨpáwiri ");
INSERT INTO aak_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aŋiwámɨ xiáwomɨ re urɨ́isixɨnɨ, ‘Yearéwapɨyarɨŋo re rɨŋoɨ, “Nionɨ gɨ́ seaiepɨsarɨŋáoyɨ́né tɨ́nɨ aiwá Aŋɨ́najɨ́ Wiárɨ́ Neamúroagɨ́yi nánɨ aŋɨ́ awawá ikwɨ́rónɨŋɨ́ gɨwámɨ dánɨ nanɨ́wɨnɨ?” Jisaso e rɨŋoɨ.’ nurɨri ");
INSERT INTO aak_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","o aŋɨ́ awawá seáyɨ émɨ ikwɨ́rónɨŋɨ́ xwé wámɨ aiwá narɨgɨ́áyɨ́ aiwá yeaanɨpɨ́rɨ mɨmiaurɨ́wɨ́ yárɨnɨŋɨ́wámɨ sɨwá eaíáná e aiwá rɨ́á neayeáisixɨnɨ.” urowáráná ");
INSERT INTO aak_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","awaú nuri Jisaso urɨ́ɨ́pɨ xɨxenɨ nɨwɨga nuri aiwá Aŋɨ́najo Wiárɨ́ Múroagɨ́yi nánɨ imɨxɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Rɨxa aiwá nɨpɨ́rɨ bɨ́íná Jisaso tɨ́nɨ wáɨ́ wurɨmeiarɨgɨ́áwa tɨ́nɨ aiwá nanɨro nánɨ nawínɨ nɨŋwearo ");
INSERT INTO aak_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","o re urɨŋɨnigɨnɨ, “Nionɨ sɨnɨ rɨ́nɨŋɨ́ mɨnímeapa nerɨ́ná ‘Gɨ́ seaiepɨsarɨŋoyɨ́né tɨ́nɨ xámɨ aiwá Aŋɨ́najɨ́ Neamúroagɨ́ nánɨ rɨpɨ onɨmɨnɨ.’ aga nɨnimónɨ́agɨ bɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. ‘Aiwá rɨpɨ ámɨ bɨ bɨ nionɨ tɨ́nɨ xwɨ́á tɨ́yo dánɨ nanɨ́wámanɨ. Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ seameŋweanɨ́e dánɨ aiwá rɨpɨ nánɨ mɨ́kɨ́pɨ xɨxenɨ imónɨnɨ́árɨnɨ. Íná dánɨ nionɨ ámɨ nɨweapɨrɨ nionɨ tɨ́nɨ nawínɨ nanɨ́wárɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","kapɨxɨ́ wá nɨmearɨ Gorɨxomɨ yayɨ́ nɨwimáná re urɨŋɨnigɨnɨ, “Kapɨxɨ́ rɨwá yaŋɨ́ ninɨro nɨga úpoyɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","‘Iniɨgɨ́ wainɨ́ ámɨ bɨ xwɨ́á tɨ́yo dánɨ nɨmɨ́ámanɨ. Rɨxa Gorɨxo soyɨ́né xwioxɨ́yo mɨmeámɨ́ nerɨ píránɨŋɨ́ seameŋweanɨ́e dánɨ iniɨgɨ́ wainɨ́ ámɨ íná nɨmɨ́árɨnɨ.’ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","bisɨ́kerɨ́á bɨ nɨmearɨ Gorɨxomɨ yayɨ́ nɨwimáná nɨkwɨrɨrɨ yaŋɨ́ nɨwia nurɨ re urɨŋɨnigɨnɨ, “Nionɨyá wará tɨyɨ́ soyɨ́né arɨrá seaimɨ́a nánɨ rɨdɨyowá nerɨ́nɨŋɨ́ imónɨnɨ. Rɨ́wéná nionɨ nánɨ dɨŋɨ́ seainɨnɨ́a nánɨ nionɨ éápa bisɨ́kerɨ́á kwɨrɨrɨ seaiapɨrɨ éápa axɨ́pɨ éɨ́rɨxɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","awa rɨxa aiwá nɨnɨmáná eŋáná bisɨ́kerɨ́á nɨmearɨ́ná éɨ́pa kapɨxɨ́ iniɨgɨ́ wainɨ́ rɨwoŋɨ́ wá nɨmearɨ re urɨŋɨnigɨnɨ, “Gorɨxo xwɨyɨ́á sɨŋɨ́ bɨ réroárɨŋɨ́pɨ nánɨ nionɨ nɨperɨ́ná gɨ́ ragɨ́ púɨ́yɨ́ iniɨgɨ́ wainɨ́ sɨxɨ́ rɨwánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","E nerɨ aiwɨ arɨ́á nípoyɨ. Ámá nionɨ nánɨ mɨyɨ́ nurɨno nionɨ tɨ́nɨ nɨŋwearane aiwá narɨŋwɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ámá imónɨŋáonɨ Gorɨxo rɨŋɨ́ jɨ́ayo axɨ́pɨ nɨnɨpɨkiro aiwɨ ámá nionɨ nánɨ mɨxɨ́yo mɨyɨ́ nurɨnomɨ Gorɨxo xeanɨŋɨ́ xwé winɨ́á eŋagɨ nánɨ aweyɨ!” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","wiepɨsarɨŋowa yarɨŋɨ́ re niga ugɨ́awixɨnɨ, “None go go e winɨ nánɨ rɨ́a rarɨnɨ?” nɨra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wiepɨsarɨŋowa xwɨyɨ́á rɨpɨ enɨ nɨrɨro sɨ́mɨ́ tɨ́nɨ re rɨnɨgɨ́awixɨnɨ, “None wo go go seáyɨ e neaimónɨrɨ eŋáná wone sɨmaŋwɨ́yónɨŋɨ́ wurɨ́nanɨ́wárɨ́anɨ?” nɨrɨga warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisaso re urɨŋɨnigɨnɨ, “Émáyɨ́yá mɨxɨ́ ináyɨ́yɨ́ ámáyɨ́yá sɨŋwɨ́ e dánɨ seáyɨ e nimónɨro wá enɨ bɨ mé sekaxɨ́nɨ nurɨro aiwɨ wiwanɨŋowa nánɨ re rɨnarɨgɨ́árɨnɨ, ‘Sɨ́wí niaíwɨ́ nɨ́nɨ nionɨ tɨ́ámɨnɨ imónɨgɨ́áyɨ́ arɨrá wiarɨŋáonɨrɨnɨ.’ rɨnarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Soyɨ́né enɨ awa yarɨgɨ́ápa axɨ́pɨ e mepanɨ. Segɨ́ rárónɨŋɨ́ imónɨ́oyɨ́ ségwáónɨŋɨ́ imónɨ́wɨnɨgɨnɨ. Segɨ́ bosónɨŋɨ́ imónɨ́oyɨ́ sénáínɨŋɨ́ omɨŋɨ́ seaiiarɨŋónɨŋɨ́ imónɨ́wɨnɨgɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dɨŋɨ́ píránɨŋɨ́ mópoyɨ. Nene píoɨ rarɨŋwárɨnɨ? Ámá kikiɨ́á nɨŋweámáná aiwá narɨŋo seáyɨ e imónɨŋorɨ́anɨ? Aiwá rɨ́á nuyeairɨ yaŋɨ́ wiarɨŋo seáyɨ e imónɨŋorɨ́anɨ? ‘Ayɨ́ kikiɨ́á nɨŋweámáná aiwá narɨŋo seáyɨ e imónɨŋorɨnɨ.’ rarɨŋwárɨnɨ. Nionɨ e imónɨŋáonɨ aiwɨ soyɨ́né tɨ́nɨ nɨŋwearɨ́ná ananɨ segɨ́ ókínɨ́nɨŋɨ́ nimónɨrɨ arɨrá seaiarɨŋáonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Soyɨ́né wa iwamɨ́ó níwapɨyanɨro yarɨ́ná nionɨ tɨ́nɨ éɨ́ nɨroro pɨ́nɨ nɨnɨwiárɨmɨ úɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ayɨnánɨ gɨ́ ápo ‘Joxɨ mɨxɨ́ ináyɨ́ nimónɨrɨ ámá ayo meŋweáɨrɨxɨnɨ.’ nɨrɨŋɨ́pa ");
INSERT INTO aak_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nionɨ enɨ re seararɨŋɨnɨ, ‘Nionɨ rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ meŋweaŋáná soyɨ́né nionɨ tɨ́nɨ nawínɨ aiwá nɨmɨ́aé aiwá nɨro iniɨgɨ́ nɨro nero negɨ́ Isɨrerɨyɨ́ gwɨ́ wɨrɨ́ wɨrí wé wúkaú sɨkwɨ́ waú eŋɨ́yo xɨráowayɨ́nénɨŋɨ́ nimónɨro meŋweapɨ́rɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","O re urɨŋɨnigɨnɨ, “Saimonoxɨnɨ, Saimonoxɨnɨ, Seteno soyɨ́né nánɨ Gorɨxomɨ sɨ́mɨ́ tɨ́nɨ re urarɨnɨ, ‘Ámá witɨ́ aiwá sikɨ́ tɨ́ŋɨ́yɨ́ neyírorɨ́ná yarɨgɨ́ápa nionɨ Jisaso wiepɨsarɨŋɨ́ awa eŋɨ́ rɨ́a eánɨŋoɨnɨrɨ iwamɨ́ó owíwapɨyimɨnɨ.’ Obo Gorɨxomɨ e urarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","E nerɨ aiwɨ dɨŋɨ́ soyɨ́néyá nɨkwɨ́roarɨgɨ́ápɨ samɨŋɨ́ mepa oenɨrɨ Gorɨxomɨ rɨxɨŋɨ́ seaurɨyíanigɨnɨ. Saimonoxɨnɨ, rɨ́wéná joxɨ ámɨ dɨŋɨ́ nɨmorɨ nɨkɨnɨmónɨrɨ nionɨ tɨ́ámɨnɨ nɨbɨrɨ́ná ámá nionɨ nɨxɨ́darɨŋagɨ́a nánɨ dɨxɨ́ rɨrɨxɨ́meáowa simónarɨgɨ́áyo eŋɨ́ sɨxɨ́ eámɨxɨ́ɨrɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, gwɨ́ rɨyíɨ́eranɨ, rɨpɨkíɨ́eranɨ, nɨwawinɨ yeaipɨ́rɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","o re urɨŋɨnigɨnɨ, “Pitaoxɨnɨ, sɨ́á rɨyimɨ karɨ́karɨ́ sɨnɨ rɨ́aiwá mɨrɨpa eŋáná xwɨyɨ́á biaú bɨ nionɨ nánɨ re urayirɨ́ɨnɨ, ‘Jisaso nánɨ nionɨ majɨ́árɨnɨ.’ urayirɨ́ɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O awamɨ re urɨŋɨnigɨnɨ, “Nionɨ xámɨ ‘Xwɨyɨ́á wáɨ́ emépoyɨ.’ nɨsearowárɨrɨ́ná ‘Nɨgwɨ́ wowɨ́ tɨ́nɨ árupiaŋɨ́ wú tɨ́nɨ sɨkwɨ́ sú ámɨ bɨ tɨ́nɨ nɨmaxɨrɨmɨ memepa époyɨ.’ searowárɨ́agɨ aiwɨ soyɨ́né amɨpí wí nánɨ dɨ́wɨ́ nikeamónɨro remegɨ́awixɨnɨ?” urɨ́agɨ awa “Oweoɨ, amɨpí wí nánɨ dɨ́wɨ́ mikeamónɨŋwanigɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","o re urɨŋɨnigɨnɨ, “E nerɨ aiwɨ agwɨ soyɨ́né goxɨ goxɨ nɨgwɨ́ wowɨ́ tɨ́ŋoxɨ nɨmaxɨrɨmɨ uɨ. Árupiaŋɨ́ eŋánáyɨ́ enɨ nɨmaxɨrɨmɨ uɨ. Goxɨ goxɨ kirá mɨxɨ́ nánɨ eŋɨ́yɨ́ mayoxɨ eŋánáyɨ́ dɨxɨ́ iyɨ́á nɨpírɨrɨ bɨ́ éɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Bɨkwɨ́yo nionɨ nánɨ re nɨrɨnɨrɨ eánɨnɨ, ‘Rɨ́á kɨroarɨgɨ́áyo mépearɨgɨ́ápa omɨ enɨ nɨkumɨxɨro axɨ́pɨ mépepɨ́rɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ. Amɨpí nionɨ nánɨ nɨrɨrɨ eánɨŋɨ́pɨ xɨxenɨ nimónɨnɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","awa re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, none mɨxɨ́ nánɨ mɨŋɨ́ bɨ́xaú rɨxa ripɨ́xaúrɨnɨ.” urɨ́agɨ́a o “Xwɨyɨ́á rɨxa apánɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","E nɨrɨnɨmɨ aŋɨ́yo nɨpeyearɨ xegɨ́ yarɨŋɨ́pa dɨ́wɨ́ mɨŋɨ́ Oripiyɨ rɨnɨŋɨ́pimɨ nánɨ yarɨ́ná xegɨ́ wiepɨsarɨŋowa enɨ númɨ nɨyiro ");
INSERT INTO aak_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","rɨxa nɨrémorɨ́ná awamɨ re urɨŋɨnigɨnɨ, “Seteno iwamɨ́ó mɨseaíwapɨyipa oenɨrɨ nánɨ Gorɨxomɨ rɨxɨŋɨ́ urɨ́poyɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ámá sɨ́ŋá ananɨ iwaŋɨ́ mopaxɨ́ imónɨŋe numáná xwɨ́áyo xómɨŋɨ́ nɨyɨkwímáná Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","re urɨŋɨnigɨnɨ, “Ápe, joxɨ nɨsimónɨrɨ́náyɨ́ xeanɨŋɨ́ nionɨ nímeanɨ́pɨ kapɨxɨ́ nionɨ nɨmɨ́nɨŋɨ́ imónɨŋɨ́wá ananɨ emɨ mɨwiárɨmopaxɨ́rɨnɨ. E nerɨ aiwɨ nionɨ nimónarɨŋɨ́pɨ mé dɨxɨ́ dɨŋɨ́ tɨ́nɨ xɨxenɨ ananɨ imónɨ́wɨnɨgɨnɨ.” urarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","aŋɨ́najɨ́ wo sɨŋánɨ nɨwimónɨrɨ eŋɨ́ sɨxɨ́ weámɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","E éáná Jisaso rɨ́nɨŋɨ́ agwɨ́ esɨŋwɨ́nɨŋɨ́ wímeáagɨ Gorɨxomɨ xwɨyɨ́á eŋɨ́ tɨ́nɨ nurɨrɨ́ná xegɨ́ okɨŋɨ́ nɨpwerɨ́ná ragɨ́nɨŋɨ́ nɨpurɨ xwɨ́áyo nɨyóɨsáná ");
INSERT INTO aak_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gorɨxomɨ xwɨyɨ́á rɨrɨmɨ́ wiarɨŋe dánɨ éɨ́ niwiearómɨ nurɨ xegɨ́ wiepɨsarɨŋowa tɨ́ŋɨ́ e wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Dɨŋɨ́ sɨpí wiarɨŋagɨ nánɨ eŋɨ́ samɨŋɨ́ nɨwóróa nuro sá órówapɨŋagɨ́a nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","re urɨŋɨnigɨnɨ, “Pí nánɨ soyɨ́né sá weŋoɨ? Seteno iwamɨ́ó mɨseaíwapɨyipa oenɨrɨ nánɨ nɨwiápɨ́nɨmearo Gorɨxomɨ rɨxɨŋɨ́ urɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Ámá wí ɨkwɨkwierɨ́ bɨmiarɨ́ná ámá Judasoyɨ rɨnɨŋo —O wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú imónɨgɨ́á worɨnɨ. O ámáyo nipemeámɨ nɨyapɨrɨ Jisasomɨ kíyɨ́ miaúnɨmɨnɨrɨ nánɨ aŋwɨ e báná ");
INSERT INTO aak_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisaso re urɨŋɨnigɨnɨ, “Judase, ámá imónɨŋáonɨ pasá nɨnɨmerɨ kíyɨ́ nɨmiaúnɨmɨnɨrɨ rɨbarɨŋɨnɨ?” uráná ");
INSERT INTO aak_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisaso tɨ́nɨ rogɨ́áwa omɨ rɨxa ɨ́á xɨranɨro yarɨŋagɨ́a nɨwɨnɨro re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, ‘Awamɨ mɨŋɨ́ orópoyɨ.’ rɨsimónarɨnɨ?” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","wo re eŋɨnigɨnɨ. Apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋomɨ mɨŋɨ́ rómɨnɨrɨ éɨ́yɨ́ pɨ́rɨ́ nɨmoyɨ́kirɨ arɨ́á wé náúmɨ dáŋo mɨŋɨ́ wirɨ́pieaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Arɨ́á mɨŋɨ́ wirɨ́pieáagɨ Jisaso “Pɨ́nɨ wiárɨ́poyɨ. E mepanɨ.” nurɨrɨ ámá arɨ́á mɨŋɨ́ wirɨ́pieáomɨ wé seáyɨ e nikwiárɨrɨ naŋɨ́ imɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Omɨ naŋɨ́ nimɨxɨmáná apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ porisɨ́ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ awa xɨ́omɨ ɨ́á xɨranɨro bɨ́áyo re urɨŋɨnigɨnɨ, “Soyɨ́né mɨŋɨ́ tɨ́nɨ iwaŋɨ́ tɨ́nɨ ɨ́á maxɨrɨgɨ́áyɨ́ ámá ɨ́wɨ́ xauráparɨgɨ́áyo ɨ́á xɨranɨro yarɨgɨ́ápa nianɨro rɨbarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nionɨ sɨ́á ayɨ́ ayo aŋɨ́ sipɨsipɨ́ rɨdɨyowá yarɨgɨ́iwámɨ ŋweaŋáná soyɨ́né ɨ́á wí mɨnɨxɨrarɨgɨ́awixɨnɨ. E nerɨ aiwɨ árɨ́wɨyíná obo emearɨ́ná soyɨ́né ɨ́á nɨxɨranɨro nánɨ rɨseaimónɨgoɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisaso e urɨ́agɨ aí awa omɨ ɨ́á nɨxero nɨméra nuro apaxɨ́pánɨŋɨ́ imónɨŋɨ́ seáyɨ e imónɨŋoyá aŋɨ́ e mearémóáná Pitao awamɨ rɨ́wɨ́yo yaxɨ́dɨ́ néra nurɨ ");
INSERT INTO aak_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ámá wí ákɨŋáyo aŋɨ́rɨwámɨ dánɨ rɨ́á nikearo ŋweaŋagɨ́a nɨwɨnɨrɨ o enɨ nɨpáwirɨ nɨwímearɨ e éɨ́ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","apɨxɨ́ omɨŋɨ́ wiiarɨŋɨ́ wí rɨ́á wɨ́á ónɨŋáná Pitaomɨ sɨ́mɨmaŋɨ́ sɨŋwɨ́ nɨwɨnɨrɨ sɨŋwɨ́ agwɨ́ nɨwɨga nɨpeyirɨ ámá e ŋwɨxapɨgɨ́áyo re urɨŋɨnigɨnɨ, “Ámá ro enɨ Jisaso tɨ́nɨ emearɨŋɨ́ worɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pitao “Oweoɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Ine, jíxɨ rarɨŋo nánɨ nionɨ majɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","nɨŋweámáná eŋáná ámɨ wo omɨ sɨŋwɨ́ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ enɨ ámá Jisasoyáowa woxɨ́nɨŋɨ́ imónarɨnɨ.” urɨ́agɨ aí Pitao “Royɨ, nionɨ xeŋwonɨrɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","nɨŋweaŋɨsáná eŋáná ámá ámɨ wo ámáyo arɨ́kí “Ámá ro enɨ Gariri pɨropenɨsɨ́yo dáŋo eŋagɨ nánɨ nepa Jisaso tɨ́nɨ emearɨŋorɨnɨ.” urayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pitao re urɨŋɨnigɨnɨ, “Royɨ, joxɨ rarɨŋɨ́yɨ́ nionɨ majɨ́árɨnɨ.” sɨnɨ e urarɨ́ná re eŋɨnigɨnɨ. Karɨ́karɨ́ wo rɨxa rɨ́aiwá rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Karɨ́karɨ́ rɨ́aiwá ráná Jisaso nɨkɨnɨmónɨrɨ Pitaomɨ sɨŋwɨ́ wɨnáná o Jisaso pɨ́né xámɨ re urɨ́ɨ́pɨ “Karɨ́karɨ́ sɨnɨ rɨ́aiwá mɨrɨ́ eŋáná joxɨ biaú bɨ ayo ‘Jisaso nánɨ nionɨ majɨ́árɨnɨ.’ urayirɨ́ɨnɨ.” urɨ́ɨ́pɨ nánɨ dɨŋɨ́ winɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","nɨpeyearɨ ákɨŋá bɨ́arɨwámɨ dánɨ ŋwɨ́ pɨyɨ́ wɨ́rɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ámá Jisasomɨ ɨ́á xɨrárɨgɨ́áyɨ́ ikayɨ́wɨ́ numearɨro iwaŋɨ́ nɨméperɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","xegɨ́ sɨŋwɨ́yo wɨ́á nɨtárɨmáná iwaŋɨ́ nearo re nura ugɨ́awixɨnɨ, “Wɨ́á nearókiamoarɨŋoxɨnɨ, iwaŋɨ́ go rɨ́a reaarɨnɨ? Joxɨ wɨ́á rókiamoarɨŋoxɨ eŋagɨ nánɨ rɨxa áwaŋɨ́ neareɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ikayɨ́wɨ́ numearɨróná ayá wí nurɨ́asáná ");
INSERT INTO aak_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","rɨxa wɨ́á ónáná Judayɨ́ mebáowa xwɨrɨxɨ́ imɨxarɨgɨ́áyɨ́, ayɨ́ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ awí eánáná Jisasomɨ awa tɨ́ámɨnɨ nɨméra nɨbɨro wárɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","awa re urɨgɨ́awixɨnɨ, “Joxɨ yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨ eŋánáyɨ́, áwaŋɨ́ neareɨ.” urɨ́agɨ́a aiwɨ o re urɨŋɨnigɨnɨ, “Nionɨ nɨsearɨ́agɨ aiwɨ soyɨ́né ‘Neparɨnɨ.’ nɨyaiwiro arɨ́á nipɨ́rɨméoɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nionɨ enɨ yarɨŋɨ́ bɨ seaíánáyɨ́, soyɨ́né áwaŋɨ́ wí nɨrɨpɨ́rɨméoɨ. ");
INSERT INTO aak_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","E nerɨ aiwɨ re seararɨŋɨnɨ, ‘Ámá imónɨŋáonɨ Gorɨxo, eŋɨ́ sɨxɨ́ eánɨŋoyá wé náúmɨnɨ ŋweámɨ nánɨ aŋwɨ ayorɨnɨ. Íníná o tɨ́nɨ nɨŋwearɨ ónɨŋɨ́ imónɨmɨ́árɨnɨ.’ seararɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","nowanɨ re urɨgɨ́awixɨnɨ, “Joxɨ niaíwɨ́ Gorɨxoyáoxɨranɨ?” urɨ́agɨ́a o “Soyɨ́né apɨ nɨrarɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","awa re rɨnɨgɨ́awixɨnɨ, “None xewanɨŋo xwɨyɨ́á meárɨnɨpaxɨ́pɨ rarɨŋagɨ arɨ́á wíwáyɨ́ nánɨ sɨŋwɨ́ wɨnarogɨ́á ámɨ wí nɨbɨro xwɨyɨ́á mearɨpaxɨ́ mimónɨnɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","E nɨrɨnɨro nowanɨ nɨwiápɨ́nɨmearo Jisasomɨ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e nánɨ nɨméra nuro ");
INSERT INTO aak_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","nɨrémómáná Jisaso nánɨ nɨxekwɨ́moro Pairatomɨ re urɨgɨ́awixɨnɨ, “O yapɨ́ nɨneaíwapɨya nurɨ Judayene yarɨŋwáyɨ́ nɨneawiaíkirɨ ‘Émáyɨ́yá mɨxɨ́ ináyɨ́ Sisaomɨ nɨgwɨ́ takisɨ́ nánɨ mɨnɨ mɨwipanɨ.’ nɨnearɨrɨ xewanɨŋo nánɨ re rarɨnɨ, ‘Nionɨ ámá yeáyɨ́ seayimɨxemeámɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaroŋáonɨ, mɨxɨ́ ináyɨ́ imónɨŋáonɨrɨnɨ.’ rarɨŋagɨ arɨ́á wíwárɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pairato Jisasomɨ yarɨŋɨ́ nɨwia nurɨ́ná yarɨŋɨ́ re wiŋɨnigɨnɨ, “Joxɨ Judayɨ́yá mɨxɨ́ ináyɨ́ imónɨŋoxɨranɨ?” urɨ́agɨ o “Joxɨ dɨxɨ́ rɨxa apɨ nɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pairato apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ tɨ́nɨ ámá e epɨ́royɨ́ egɨ́áyo tɨ́nɨ re urɨŋɨnigɨnɨ, “Xwɨyɨ́á mearɨpaxɨ́ imónɨŋɨ́ bɨ nánɨ pɨ́á megɨnarɨŋɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","awa arɨ́kí re urayigɨ́awixɨnɨ, “Jisaso Judia pɨropenɨsɨ́ re amɨ amɨ nemerɨ ámá nɨ́nɨ re oyaiwípoyɨnɨrɨ, ‘O negɨ́ mɨxɨ́ ináyɨ́ imónáná émáyo mɨxɨ́ xɨ́dowáranɨ́wárɨnɨ.’ oyaiwípoyɨnɨrɨ nuréwapɨya warɨŋorɨnɨ. Gariri pɨropenɨsɨ́yo dánɨ néra bɨŋɨ́yɨ́ re enɨ aí nearéwapɨyarɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pairato arɨ́á e nɨwirɨ awamɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “O Gariri pɨropenɨsɨ́yo dáŋoranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","awa re urɨgɨ́awixɨnɨ, “Oyɨ, Jisaso pɨropenɨsɨ́ gapɨmanɨ́ Xeroto meŋweaŋɨ́yo dáŋorɨnɨ.” urɨ́agɨ́a Xeroto enɨ íná Jerusaremɨ ŋweaŋagɨ nánɨ Pairato o tɨ́ŋɨ́ e nánɨ wiowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Judayowa Jisasomɨ gapɨmanɨ́ Xeroto tɨ́ŋɨ́ e nánɨ nɨméra úáná o eŋíná dánɨ amɨpí Jisaso yarɨŋɨ́yɨ́ nánɨ arɨ́á nɨwirɨ “Omɨ sɨŋwɨ́ owɨnɨmɨnɨ.” nɨyaiwia bagɨ́ nánɨ omɨ sɨŋwɨ́ nɨwɨnɨrɨ́ná yayɨ́ nɨwinɨrɨ “Jisaso emɨmɨ́ bɨ oníwapɨyinɨ.” nɨyaiwirɨ ");
INSERT INTO aak_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","yarɨŋɨ́ obaxɨ́ nɨwiayarɨŋagɨ aiwɨ xɨ́oyá bɨ murɨŋɨnigɨnɨ. Murɨpa yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ xwɨyɨ́á rɨ́á tɨ́ŋɨ́ xekwɨ́móagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Xeroto tɨ́nɨ xegɨ́ porisowa tɨ́nɨ uyɨ́niɨ́ mero ikayɨ́wɨ́ mearɨro nemáná rapɨrapɨ́ awiaxɨ́ wú mɨxɨ́ ináyowa yínarɨgɨ́á imónɨŋɨ́ wú nuyírɨro ámɨ Pairato tɨ́ŋɨ́ e nánɨ wiowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Xeroto tɨ́nɨ Pairato tɨ́nɨ xámɨ xepɨxepá rónagɨ́íwaú sɨ́á ayimɨ nawínɨ imónɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jisasomɨ ámɨ Pairato tɨ́ŋɨ́ e nánɨ nɨméra úáná Pairato “Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Judayɨ́ mebáowa tɨ́nɨ ámá nɨ́nɨ tɨ́nɨ obɨ́poyɨ.” nɨrɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","awa ámɨ báná re urɨŋɨnigɨnɨ, “Soyɨ́né xámɨ ámá ro nɨmeámɨ nɨbɨrɨ re nɨrɨ́awixɨnɨ, ‘O ámá nɨ́nɨ “Émáyo mɨxɨ́ xɨ́dowáranɨ́wárɨnɨ.” oyaiwípoyɨnɨrɨ nɨsearéwapɨya emearɨŋorɨnɨ.’ nɨrɨ́á aiwɨ soyɨ́né xwɨyɨ́á umeararɨgɨ́ápɨ nánɨ nionɨ segɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ yarɨŋɨ́ wiayíagɨ aiwɨ omɨ xwɨyɨ́á mearɨpaxɨ́ wí mimónɨ́ɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Xeroto enɨ pɨ́á nɨwirɨ aí omɨ xwɨyɨ́á mearɨpaxɨ́ bɨ mimónɨpa eŋagɨ nánɨ ámɨ none tɨ́ŋɨ́ e nánɨ seapowárénapɨ́ɨ́rɨnɨ. Arɨ́á époyɨ. None omɨ pɨkianɨ nánɨ uyɨ́niɨ́ eŋɨ́ bɨ aga mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ayɨnánɨ ‘Nionɨ yarɨŋápɨ nánɨ rɨnearɨŋoɨ?’ oyaiwinɨrɨ sa iwaŋɨ́nɨ nɨméperɨ wárɨmɨ́ɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Judayɨ́ xwiogwɨ́ ayɨ́ ayo aiwá Aŋɨ́najo Múroagɨ́ nánɨ narɨgɨ́áyimɨ “Émáyɨ́ gapɨmano negɨ́ ámá gwɨ́ ŋweaŋɨ́ wo oneawárinɨ.” nɨyaiwiro nánɨ ");
INSERT INTO aak_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","ámá e epɨ́royɨ́ egɨ́á nawínɨ nɨ́nɨ xɨxewiámɨ́ re urɨgɨ́awixɨnɨ, “Jisasomɨ nɨpɨkirɨ Barabasomɨ —O Jerusaremɨ ŋweagɨ́áyɨ́ wa tɨ́nɨ nɨwiápɨ́nɨmearo ‘Émáyo mɨxɨ́ oxɨ́dowáraneyɨ.’ nɨrɨro mɨxɨ́ nɨwiróná ámá pɨkíagɨ́a omɨ émáyɨ́ ɨ́á nɨxero gwɨ́ aŋɨ́yo ŋwɨrárɨgɨ́orɨnɨ. “Omɨ neawáriɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairato “Jisasomɨ owárɨmɨnɨ.” nɨyaiwirɨ ámá ayo ámɨ bɨ urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ayɨ́ rɨ́mɨŋɨ́ tɨ́nɨ re urayigɨ́awixɨnɨ, “Íkɨ́áyo yekwɨroáreɨ. Íkɨ́áyo yekwɨroáreɨ.” urayarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pairato rɨxa biaú urɨ́ɨ́ aiwɨ ámɨ bɨ re urɨŋɨnigɨnɨ, “Pí nánɨ? O pí ɨ́wɨ́ éɨ́ nánɨ íkɨ́áyo yekwɨroárɨmɨ́ɨnɨ? Xwɨyɨ́á omɨ nɨmearɨrɨ pɨkipaxɨ́ wí imónɨŋagɨ mɨwɨnɨmeáɨnɨ. Ayɨnánɨ iwaŋɨ́nɨ nɨméperɨ wárɨmɨ́ɨnɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ámá ayɨ́ Pairato omɨ íkɨ́áyo oyekwɨroárɨnɨrɨ arɨ́kí ámɨ wínɨ sɨ́mɨ́ tɨ́nɨ nurayiróná pɨ́né Pairatoyá xórórɨ́ wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pɨ́né oyá xórórɨ́ wíagɨ́a nánɨ re urɨŋɨnigɨnɨ, “Segɨ́ seaimónarɨŋɨ́pɨ xe oimónɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ámá nɨ́nɨ wiwanɨŋɨ́yɨ́ “Neawáriɨ.” urɨ́o —O Jerusaremɨ ŋweagɨ́áyɨ́ wa tɨ́nɨ nɨwiápɨ́nɨmearɨ “Émáyo mɨxɨ́ oxɨ́dowáraneyɨ.” nɨrɨro mɨxɨ́ nɨwiróná ámá pɨkíagɨ́a omɨ émáyɨ́ ɨ́á nɨxero gwɨ́ aŋɨ́yo ŋwɨrárɨgɨ́orɨnɨ. O nánɨ ayɨ́ “Neawáriɨ.” urɨ́omɨ Pairato nɨwárɨrɨ Jisaso nánɨ wigɨ́ dɨŋɨ́ yaiwíɨ́áyo nɨxɨ́dɨrɨ porisowa íkɨ́áyo yekwɨroárɨpɨ́rɨ nánɨ mɨnɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mɨnɨ wíáná porisowa omɨ nɨméra nurɨ́ná Jisasomɨ iwaŋɨ́ mépeayíɨ́á eŋagɨ nánɨ rɨxa eŋɨ́ meánɨpa nerɨ ná neága warɨŋagɨ nɨwɨnɨro ámá wo Saimonoyɨ rɨnɨŋo —O aŋɨ́ xegɨ́ yoɨ́ Sairini dáŋorɨnɨ. O maiwí amɨ́yo dánɨ Jerusaremɨ nánɨ barɨŋomɨ óɨ́ e órórɨ́ ninɨro “O íkɨ́á yoxáɨ́pá níkwónɨmɨ Jisasomɨ oxɨ́dɨnɨ.” nɨyaiwiro omɨ íkɨ́á yoxáɨ́pá saŋwɨ́yo nɨwikwiárɨro nɨméra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ámá oxɨ́ apɨxɨ́ obaxɨ́ ɨkwɨkwierɨ́ rɨ́wɨ́mɨnɨ nuro apɨxɨ́ obaxɨ́ wíwa enɨ rɨ́wɨ́yo númɨ nuróná ŋwapé tɨ́nɨ ámɨxɨ́á nɨwiaxɨ́da warɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisaso nɨkɨnɨmónɨrɨ re urɨŋɨnigɨnɨ, “Jerusaremɨ dáŋɨ́ apɨxɨ́ riwayɨ́né nionɨ ŋwɨ́ mɨnɨmieapa époyɨ. Sewanɨŋíwayɨ́né nánɨ mieainɨro segɨ́ niaíwɨ́yo miearo éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Rɨ́wéná xeanɨŋɨ́ rɨ́á tɨ́ŋɨ́ seaímeanɨ́á eŋagɨ nánɨ apɨxɨ́ niaíwɨ́ tɨ́gɨ́íwa wigɨ́ niaíwɨ́ nánɨ aga dɨŋɨ́ sɨpí winɨ́á eŋagɨ nánɨ ámá re rɨpɨ́rɨ́árɨnɨ, ‘Apɨxɨ́ oxɨ́ rogɨ́íwa tɨ́nɨ sɨnɨ apɨyá niaíwɨ́ mɨxɨrɨgɨ́íwa tɨ́nɨ apɨxɨ́ sɨnɨ niaíwɨ́ amɨŋɨ́ mɨnɨ mɨwipa yarɨgɨ́íwa tɨ́nɨ íwa yayɨ́ owinɨnɨ.’ rɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Xeanɨŋɨ́ apɨ aga xaíwɨ́ seaímeanɨ́á eŋagɨ nánɨ ámá dɨ́wɨ́ mɨŋɨ́yo ‘Nɨpiérorɨ neaɨkwarɨmoɨ.’ urɨro dɨ́wɨ́ mɨŋɨ́ onɨmiápia wímɨ enɨ ‘Seáyɨ e rɨtɨ́ neaiɨ.’ urɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wé rónɨŋáonɨ íkɨ́á sɨŋɨ́nɨŋɨ́ imónɨŋáonɨ aí xeanɨŋɨ́ nikárɨ́áyɨ́ nánɨ seyɨ́né ɨ́wɨ́ yarɨgɨ́áyo dánɨ íkɨ́á kɨrɨŋɨ́nɨŋɨ́ imónɨgɨ́áyɨ́né aŋɨpaxɨ́ seaikárɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ámá rɨkɨkɨrɨ́ó yarɨgɨ́íwaú enɨ Jisaso tɨ́nɨ nawínɨ pɨkianɨro nánɨ nɨkumɨxɨro nɨméra nuro ");
INSERT INTO aak_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","rɨxa yoɨ́ ámá Mɨŋɨ́ Gɨxweáɨ rɨnɨŋe nɨrémoro omɨ íkɨ́áyo nɨyekwɨroárɨmáná mɨdɨmɨdánɨ rɨkɨkɨrɨ́ó yarɨgɨ́íwaúmɨ enɨ yekwɨroárarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisaso Gorɨxomɨ re urɨŋɨnigɨnɨ, “Ápe, nionɨ niarɨgɨ́á tɨyɨ́ awa majɨ́á nimónɨmáná niarɨŋagɨ́a nánɨ joxɨ yokwarɨmɨ́ wiiɨ.” urarɨ́ná porisowa Jisasoyá rapɨrapɨ́ gonɨ gonɨ meámɨnɨréɨnɨrɨ sárú nero yaŋɨ́ inarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ámá númɨ bɨ́áyɨ́ e nɨrówapɨro sɨŋwɨ́ nɨwɨnɨro Judayɨ́ ámɨnáowa enɨ aí rɨperɨrɨ́ numero re rɨgɨ́awixɨnɨ, “O ámá wíyo arɨrá wiagorɨnɨ. O nepa ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo eŋánáyɨ́, Gorɨxo nɨrɨ́pearɨ nene yeáyɨ́ neayimɨxemeanɨ́a nánɨ urowárénapɨnɨ́oyɨ rarɨŋwáo eŋánáyɨ́, xewanɨŋo arɨrá oinɨnɨ.” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","porisowa enɨ ikayɨ́wɨ́ numearɨróná iniɨgɨ́ wainɨ́ mɨxɨ́ yarɨŋɨ́pɨ mɨnɨ wianɨro nánɨ aŋwɨ e nɨbɨro ");
INSERT INTO aak_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","re urayigɨ́awixɨnɨ, “Joxɨ Judayɨ́yá mɨxɨ́ ináyoxɨ eŋánáyɨ́, jɨwanɨŋoxɨ éɨ́ mínɨneɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“Ámá royɨ́ mɨxɨ́ ináyɨ́ Judayɨ́yáorɨnɨ.” nɨrɨro íkɨ́á wáráyo rɨ́wamɨŋɨ́ e neámáná oyá yoxáɨ́yo xwápɨyi seáyɨ émɨ pɨ́raugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Rɨkɨkɨrɨ́ó yarɨgɨ́íwaú, Jisasomɨ mɨdɨmɨdánɨ íkɨ́áyo yekwɨroárɨ́íwaú wɨ́o Jisasomɨ ikayɨ́wɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ nepa ámá yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨranɨ? Jɨwanɨŋoxɨ éɨ́ mínɨnɨrɨ yawawi enɨ yeamínɨrɨ eɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","wɨ́o “E murɨpanɨ.” nurɨrɨ mɨxɨ́ re urɨŋɨnigɨnɨ, “Rɨ́nɨŋɨ́ o meaarɨŋɨ́pɨ joxɨ axɨ́pɨ nɨmearɨ aiwɨ Gorɨxo nánɨ wáyɨ́ mɨsinarɨnɨranɨ? ");
INSERT INTO aak_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yawawi yeapɨkíáná ayɨ́ ananɨrɨnɨ. Ɨ́wɨ́ yarɨgwɨ́íyo dánɨ xɨxenɨ yeapɨkiarɨŋoɨ. Ámá royɨ́ ɨ́wɨ́ bɨ méagɨ aiwɨ pɨkiarɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jisasomɨ re urɨŋɨnigɨnɨ, “Joxɨ rɨxa mɨxɨ́ ináyɨ́ nimónɨrɨ nɨmeŋwearɨ́ná nionɨ nánɨ dɨŋɨ́ móɨrɨxɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisaso re urɨŋɨnigɨnɨ, “Nepa rɨrarɨŋɨnɨ. Agwɨ nionɨ tɨ́nɨ aŋɨ́namɨ ŋweanɨ́wiɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Rɨxa sogwɨ́ áwɨnɨ e ŋweaŋáná re eŋɨnigɨnɨ. Sogwɨ́ nɨsɨ́kwirɨ aŋɨ́ nɨmɨnɨ sɨ́á xaíwɨ́ nɨyinára nurɨ rɨxa 3:00 p.m. imónáná sogwɨ́ ámɨ noxárorɨ anɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sogwɨ́ sɨ́kwiárɨŋáná rapɨrapɨ́ sepiá aŋɨ́ sipɨsipɨ́ rɨdɨyowá yarɨgɨ́iwá ŋwɨ́á tɨ́ŋɨ́mɨnɨ epaŋioárɨnɨŋú áwɨnɨ e naxɨnowárɨrɨ wúkaú epaŋioárɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisaso rɨ́aiwá re rɨŋɨnigɨnɨ, “Ápoxɨnɨ, gɨ́ dɨŋɨ́ orɨŋwɨrárɨmɨnɨ.” nurɨmɨ dɨŋɨ́ yánɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jisaso dɨŋɨ́ yánɨ́agɨ porisowamɨ seáyɨ e imónɨŋo amɨpí ayɨ́ e éagɨ sɨŋwɨ́ e nɨwɨnɨrɨ Gorɨxomɨ yayɨ́ numerɨ re rɨŋɨnigɨnɨ, “Ámá ro nepa wé rónɨŋo, sɨpí wí mimɨxɨpa eŋomɨ aí pɨkíwɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ámá oxɨ́ apɨxɨ́ nɨ́nɨ Porisowa Jisasomɨ yekwɨroárarɨ́ná sɨŋwɨ́ wɨnanɨro bɨmíɨ́áyɨ́ sogwɨ́ sɨ́kwiárɨrɨ ámɨ oxárorɨ nerɨ Jisaso perɨ éagɨ nɨwɨnɨro ayá ɨ́á nɨxɨrɨnɨmɨ wigɨ́ aŋɨ́ e nánɨ umigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ámá Jisasoyá xegɨ́ imónɨŋɨ́yɨ́ tɨ́nɨ apɨxɨ́ Gariri pɨropenɨsɨ́yo dáŋɨ́ o tɨ́nɨ nawínɨ bɨgɨ́íwa tɨ́nɨ ná jɨ́amɨ onɨmiápɨ nɨrómáná omɨ pɨkiarɨ́ná amɨpí apɨ e éagɨ sɨŋwɨ́ wɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ámá wo xegɨ́ yoɨ́ Josepoyɨ rɨnɨŋo —O Judia pɨropenɨsɨ́yo aŋɨ́ xegɨ́ yoɨ́ Arimatia dáŋorɨnɨ. O Judayɨ́yá xwɨrɨxɨ́ mearɨgɨ́á mebáyɨ́ worɨnɨ. O wé rónɨŋo eŋagɨ nánɨ xegɨ́ wɨ́a Jisasomɨ pɨkianɨro nánɨ mekaxɨ́ nɨmero yarɨgɨ́ápɨ nánɨ “Apánɨrɨnɨ.” mɨwimónɨŋorɨnɨ. “Gorɨxo xwioxɨ́yo mɨmeámɨ́ nerɨ neameŋweanɨ́ápɨ gínɨ gíná imónɨnɨ́árɨ́anɨ?” nɨyaiwiro wenɨŋɨ́ nerɨ ŋweaŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O émáyɨ́ gapɨmanɨ́ Pairato tɨ́ŋɨ́ e nánɨ nurɨ Jisaso pɨyomɨ xwɨ́á weyárɨmɨnɨrɨ nánɨ yarɨŋɨ́ nɨwirɨ Pairato “Oyɨ.” urɨ́agɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jisaso pɨkíɨ́omɨ nɨmeámɨ nɨwepɨ́nɨrɨ xwɨ́á e dánɨ rapɨrapɨ́ apɨ́á weŋɨ́pɨ tɨ́nɨ xopɨxopɨ́ nɨrorɨ sɨ́ŋáyo ámá óɨ́ rɨxɨgɨ́áyimɨ —Ayi ámá sɨnɨ mɨtagɨ́áyirɨnɨ. Ayimɨ tɨmɨnɨrɨ nánɨ nɨmeámɨ nurɨ ínɨmɨ tɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabarɨ́á nánɨ amɨpí píránɨŋɨ́ nimɨxɨro tarɨgɨ́áyimɨ nɨtɨrɨ aiwɨ Sabarɨ́á náyi rɨxa aŋwɨ e eŋáná tɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Apɨxɨ́ Gariri pɨropenɨsɨ́yo dánɨ númɨ bɨ́íwa “Jisasomɨ arɨge rɨ́a tarɨnɨ?” nɨyaiwiro sɨŋwɨ́ wɨnanɨro númɨ nuro sɨ́ŋá óɨ́yimɨ sɨŋwɨ́ nɨwɨnɨróná xɨ́omɨ tarɨ́ná enɨ sɨŋwɨ́ nɨwɨnɨmɨ ");
INSERT INTO aak_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","wigɨ́ aŋɨ́ e nánɨ nuro Sadéyo Jisasoyá wará xópé éwanɨgɨnɨrɨ íkɨ́á dɨ́á dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ bɨ tɨ́nɨ gɨ́niɨ́ bɨ tɨ́nɨ píránɨŋɨ́ nimɨxɨro nɨtɨro sá wegɨ́íwa Sabarɨ́áyo ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ rarɨŋɨ́pa kikiɨ́á ŋweagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sadéyo aga wɨ́á mónɨŋɨ́mɨ íwa íkɨ́á dɨ́á tɨ́nɨ gɨ́niɨ́ tɨ́nɨ xámɨ píránɨŋɨ́ imɨxárɨgɨ́ápɨ nɨmeámɨ nuro ");
INSERT INTO aak_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","rɨxa Jisaso xwɨ́á weyárɨnɨŋe nɨrémoro sɨ́ŋá xwárɨpáyo maŋɨ́ e éɨ́ rárárɨnɨŋo mɨmegwɨnárɨ́ nɨmega nurɨ yánɨ e weŋagɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","óɨ́yimɨ nɨpáwiro aí Ámɨná Jisaso mɨweŋagɨ nɨwɨnɨro ");
INSERT INTO aak_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","“Pɨyo gerɨ́anɨ?” nɨyaiwiro ududɨ́ ninɨro roŋáná re eŋɨnigɨnɨ. Ámá waú egɨ́ rapɨrapɨ́ xwɨnɨ́á eagɨ́íwaú sɨ́mɨmaŋɨ́ e rónapɨgɨ́isixɨnɨ. Sɨ́mɨmaŋɨ́ e rónapáná ");
INSERT INTO aak_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","apɨxíwa wáyɨ́ nikárɨnɨro sɨ́mɨmaŋɨ́ xwɨ́áyo ɨkwɨ́róáná awaú re urɨgɨ́isixɨnɨ, “Sɨŋɨ́ úo nánɨ ámá xwɨ́á weyárarɨgɨ́e pí nánɨ pɨ́á yarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Sɨnɨ re mɨwenɨnɨ. Rɨxa wiápɨ́nɨmeáɨnigɨnɨ. O sɨnɨ seyɨ́né tɨ́nɨ Gariri pɨropenɨsɨ́yo nemerɨ́ná searɨŋɨ́pɨ nánɨ dɨŋɨ́ mópoyɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Re searɨŋɨ́rɨnɨ, ‘Negɨ́ Judayɨ́ ámá imónɨŋáonɨ mɨyɨ́ nɨnɨrɨróná ámá ɨ́wɨ́ yarɨgɨ́áyɨ́ ɨ́á nɨnɨxero íkɨ́áyo nɨyekwɨroárɨpɨ́rɨ́á eŋagɨ aí ámɨ sɨ́á wɨyaú wɨyi rɨxa nórɨmáná eŋáná wiápɨ́nɨmeámɨ́árɨnɨ.’ rɨŋɨ́rɨnɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","íwa Jisaso xwɨyɨ́á eŋíná urɨŋɨ́ apɨ nánɨ dɨŋɨ́ nɨwinɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","xwárɨpáyo pɨ́nɨ nɨwiárɨmɨ nuro wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ wo awamɨ íwa wɨnɨ́ápɨ nánɨ repɨyɨ́ nɨwiro ámá Jisasoyá xegɨ́ imónɨŋɨ́yo enɨ nɨyonɨ repɨyɨ́ wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Apɨxɨ́ repɨyɨ́ wiarɨgɨ́íwa Magɨdara dáŋɨ́ Mariaí tɨ́nɨ Joanaí tɨ́nɨ Jemisomɨ xɨnáí Mariaí tɨ́nɨ ámɨ wíwa tɨ́nɨrɨnɨ. Íwa wáɨ́ wurɨmeiarɨgɨ́áwamɨ wigɨ́ wɨnɨ́ápɨ nánɨ áwaŋɨ́ urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","“Íwa wigɨ́ xwɨyɨ́á íkɨ́á ɨwɨ́yo dánɨ́nɨŋɨ́ rarɨŋoɨ.” nɨyaiwiro “Nepaxɨnɨ.” mɨyaiwipa nero aí ");
INSERT INTO aak_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pitao nɨwiápɨ́nɨmearɨ aŋɨ́nɨ nurɨ xwárɨpáyo nɨrémómáná nɨpɨ́kwínɨrɨ ínɨmɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Rapɨrapɨ́ Jisasomɨ xopɨxopɨ́ rónɨŋúnɨ wí e weŋagɨ nɨwɨnɨrɨ ámɨ xegɨ́ aŋɨ́ e nánɨ nurɨ́ná e eŋagɨ wɨnɨ́ɨ́pɨ nánɨ ududɨ́ néra uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jisasoyá xegɨ́ ámá imónɨŋɨ́yɨ́ waú sɨ́á axɨ́yimɨnɨ aŋɨ́ Emeasɨyɨ rɨnɨŋɨ́pimɨ nánɨ nuri —Aŋɨ́ apɨ Jerusaremɨ dánɨ ná jɨ́amɨne onɨmiápɨrɨnɨ. 11 kiromita imónɨŋerɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Awaú óɨ́yo nuri Jerusaremɨyo amɨpí Jisasomɨ wíɨ́ápɨ nánɨ repɨyɨ́ niga nuri ");
INSERT INTO aak_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","xwɨyɨ́á nɨrɨga warɨ́ná Jisaso xewanɨŋo aŋwɨ e nɨbɨrɨ nɨwímearɨ awaú tɨ́nɨ nawínɨ nuro ");
INSERT INTO aak_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","awaú Jisasomɨ sɨŋwɨ́ nɨwɨnɨri aiwɨ omɨ mí mómɨxɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisaso yarɨŋɨ́ re wiŋɨnigɨnɨ, “Awagwí aŋɨ́ nurɨ́ná xwɨyɨ́á nɨrɨga warɨgɨ́ípɨ pí éɨ́ nánɨ nɨrɨga warɨŋiɨ?” uráná awaú éɨ́ nɨrómáná sɨ́mɨmaŋɨ́ kɨpɨŋɨ́ nɨyiri ");
INSERT INTO aak_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","wɨ́o, Kɨriopasoyɨ rɨnɨŋo re urɨŋɨnigɨnɨ, “Ámá nɨ́nɨ Jerusaremɨ urɨ́nanɨro úɨ́áyo sa joxɨnɨ e imónɨ́ɨ́pɨ nánɨ majɨ́áranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","o yarɨŋɨ́ re wiŋɨnigɨnɨ, “Jerusaremɨyo pí imónɨ́ɨnigɨnɨ?” urɨ́agɨ awaú re urɨgɨ́isixɨnɨ, “Nasaretɨ dáŋɨ́ Jisaso nánɨ rɨnarɨŋwiɨ. O Gorɨxoyá sɨŋwɨ́yo dánɨ ámá nɨ́nɨyá sɨŋwɨ́yo dánɨ enɨ wɨ́á rókiamoarɨŋɨ́ eŋɨ́ eánɨŋɨ́ wo nimónɨrɨ emɨmɨ́ erɨ xwɨyɨ́á píránɨŋɨ́ urɨmerɨ yarɨŋo nánɨ rɨnarɨŋwiɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Omɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ negɨ́ ámɨná neameŋweagɨ́áwa tɨ́nɨ xwɨrɨxɨ́ numero omɨ íkɨ́á seáyɨyo oyekwɨroárɨ́poyɨnɨrɨ émáyo mɨnɨ wíoɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Xámɨ nene dɨŋɨ́ re kɨkayówárɨnɨ, ‘Gorɨxo nene émáyɨ́yá gwɨ́ ŋweaŋwaénénɨŋɨ́ imónɨŋwaéne neaíkweanɨ́a nánɨ urowárénapɨnɨ́o ámá orɨ́anɨ?’ Dɨŋɨ́ e kɨkayówárɨnɨ. Xwɨyɨ́á apɨ aí ámɨ bɨ rɨpɨrɨnɨ. Omɨ rɨxa nɨpɨkímáná eŋáná sɨ́á wɨyaú wɨyi óráná ");
INSERT INTO aak_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","agwɨ sɨ́á rɨyimɨ neneyá apɨxíwa ayá nearemóoɨ. Íwa wɨ́á mónɨŋɨ́mɨ ámá xwárɨpá tɨ́ŋɨ́ e nánɨ nuro aí ");
INSERT INTO aak_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pɨyɨ́ tɨ́o mɨweŋagɨ nɨwɨnɨro nene ŋweaŋwaé nánɨ nɨbɨro re nearáoɨ, ‘Newané xwárɨpáyo dánɨ orɨŋá nɨwɨnɨranéná aŋɨ́najɨ́ waú nɨrónapɨri “O sɨŋɨ́ uŋoɨ.” nearɨ́iɨ.’ nearɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","negɨ́ ámá wa ámá pɨyo tɨ́e nánɨ nuro apɨxíwa nearɨ́ápɨ sɨnɨ axɨ́pɨ e imónɨŋagɨ nɨwɨnɨro aiwɨ pɨyomɨ sɨŋwɨ́ bɨ mɨwɨnáoɨ.” Jisasomɨ repɨyɨ́ e wíagɨ́i ");
INSERT INTO aak_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisaso re urɨŋɨnigɨnɨ, “Awagwí majɨmajɨ́á yarɨgɨ́íwagwírɨnɨ. Amɨpí wɨ́á rókiamoagɨ́áwa nɨrɨro rɨ́wamɨŋɨ́ eagɨ́ápɨ arɨ́á nɨwiri aiwɨ aŋɨ́nɨ ‘Neparɨnɨ.’ nɨyaiwiri dɨŋɨ́ mɨkwɨ́ropa yarɨgɨ́íwagwírɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Awagwí ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́o nánɨ re rɨyaiwiarɨŋiɨ, ‘O rɨ́nɨŋɨ́ bɨ mɨmeá ananɨ mɨxɨ́ ináyɨ́ nimónɨrɨ nikɨ́nɨmɨ Gorɨxo tɨ́ámɨnɨ ŋweapaxɨ́rɨnɨ.’ rɨyaiwiarɨŋiɨ? Oweoɨ, xámɨ rɨ́nɨŋɨ́ nɨmeámáná rɨ́wɨ́yo nikɨ́nɨpaxɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","rɨ́wamɨŋɨ́ Gorɨxoyáyo amɨpí xɨ́o nánɨ nɨrɨnɨrɨ eánɨŋɨ́pɨ Moseso eaŋe dánɨ repɨyɨ́ píránɨŋɨ́ nɨwiéra urɨ amɨpí wɨ́á rókiamoagɨ́áwa rɨ́wɨ́yo eagɨ́e dánɨ enɨ repɨyɨ́ píránɨŋɨ́ nɨwiéra urɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aŋɨ́ awaú warɨgɨ́íe rɨxa aŋwɨ e nɨrémorɨ́ná Jisaso awaú “O wiárɨ́ nɨmúrorɨ unɨŋoɨ.” oyaiwípiyɨnɨrɨ wíwapɨyarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","awaú urakioŋwɨráranɨri nánɨ re urɨgɨ́isixɨnɨ, “Joxɨ mɨyeamúropanɨ. Sogwɨ́ rɨxa wéɨ́ eŋagɨ nánɨ sɨ́á rórɨnɨŋoɨ. Yawawi tɨ́nɨ sá re oweaneyɨ.” urɨ́agɨ́i awaú tɨ́nɨ sá wémɨnɨrɨ nánɨ nawínɨ aŋɨ́yo nɨpáwiro ");
INSERT INTO aak_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","nɨŋweagɨ́asáná rɨxa aiwá nanɨro nerɨ́ná Jisaso bisɨ́kerɨ́ápɨ nɨmearɨ Gorɨxomɨ yayɨ́ nɨwimáná nɨkwɨrɨrɨ mɨnɨ wiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","awaú rɨxa sɨŋwɨ́ mí wómɨxɨpaxɨ́ nimónɨri omɨ sɨŋwɨ́ mí wómɨxáná re eŋɨnigɨnɨ. O awaú sɨŋwɨ́ anɨgɨ́íe dánɨ anɨ́nɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","O anɨ́nɨ́agɨ nɨwɨnɨri re rɨnɨgɨ́isixɨnɨ, “O tɨ́nɨ óɨ́yo nɨbɨranéná o xwɨyɨ́á Gorɨxoyá rɨ́wamɨŋɨ́ eánɨŋɨ́pɨ píránɨŋɨ́ repɨyɨ́ nɨyeaiéra barɨ́ná yegɨ́ xwioxɨ́yo dánɨ rɨxa dɨŋɨ́ niɨ́á yeaíɨ́rɨnɨ.” nɨrɨnɨri ");
INSERT INTO aak_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","axíná Jerusaremɨ nánɨ nɨwiápɨ́nɨmeámɨ nuri wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ wo egɨ́áwamɨ tɨ́nɨ ámá awa tɨ́nɨ nawínɨ ŋweagɨ́áyo tɨ́nɨ nɨwímeari ");
INSERT INTO aak_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ayɨ́ “Ámɨnáo rɨxa wiápɨ́nɨmeáɨnigɨnɨ. Saimonomɨ sɨŋánɨ wimónɨ́ɨnigɨnɨ.” rɨnarɨŋagɨ́a arɨ́á nɨwiri ");
INSERT INTO aak_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","amɨpí óɨ́yo néra úɨ́ípɨ nánɨ áwaŋɨ́ nurɨri re urɨgɨ́isixɨnɨ, “O rɨxa bisɨ́kerɨ́á kwɨrarɨ́ná yawawi rɨxa sɨŋwɨ́ mí wómɨxɨ́wɨ́isixɨnɨ.” urɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sɨnɨ Jisaso nánɨ áwaŋɨ́ e urarɨ́ná re eŋɨnigɨnɨ. Xewanɨŋo ámá nɨyonɨ áwɨnɨmɨ dánɨ sɨŋánɨ rónapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sɨŋánɨ rónapáná ayɨ́ sɨrɨ́ nɨpɨkínɨro wáyɨ́ nikárɨnɨro “Pɨyɨŋɨ́ siwí womɨ sɨŋwɨ́ rɨ́a wɨnɨŋwɨnɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","o re urɨŋɨnigɨnɨ, “Seyɨ́né óɨ́ nikárɨnɨro ‘Jisasorɨ́anɨ?’ mɨyaiwí dɨŋɨ́ obɨbaxɨ́ pí nánɨ nɨmóa warɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","‘Ayɨ́ Jisasorɨ́anɨ?’ yaiwipɨ́rɨ sɨkwɨ́yo tɨ́nɨ wéyo tɨ́nɨ sɨŋwɨ́ nanɨ́poyɨ. ‘Gɨ́wɨ́ tɨ́nɨ eŋɨ́ tɨ́nɨ enɨ rí renɨ?’ yaiwipɨ́rɨ wé seáyɨ e nikwiárɨ́poyɨ. Pɨyɨŋɨ́ siwí gɨ́wɨ́ tɨ́nɨ eŋɨ́ tɨ́nɨ tɨ́ŋɨ́ranɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","xegɨ́ wé tɨ́nɨ sɨkwɨ́ tɨ́nɨ sɨwá wíagɨ ");
INSERT INTO aak_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ayɨ́ yayɨ́ seáyɨmɨ dánɨ winanɨro nero aí sɨnɨ “Aga Jisasorɨ́anɨ?” mɨyaiwí ududɨ́ nɨwiga warɨ́ná o ayɨ́ “Pɨyɨŋɨ́ siwímanɨ. O aiwá narɨnɨ.” oyaiwípoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Nionɨ nɨmɨ nánɨ aiwá bɨ menɨranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ayɨ́ peyɨ́ pɨrɨ́ bɨ umeaíáná ");
INSERT INTO aak_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","o nurápɨrɨ wigɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ nɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","O re urɨŋɨnigɨnɨ, “Xámɨ nionɨ sɨnɨ seyɨ́né tɨ́nɨ nemerɨ́ná xwɨyɨ́á rɨpɨ searɨŋanigɨnɨ, ‘Rɨ́wamɨŋɨ́ amɨpí nionɨ nánɨ Moseso ŋwɨ́ ikaxɨ́ nɨrɨrɨ eaŋɨ́pɨ tɨ́nɨ wɨ́á rókiamoagɨ́áwa nɨrɨro eagɨ́ápɨ tɨ́nɨ Bɨkwɨ́ Samɨyo nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ wí surɨ́má mé aga xɨxenɨ nimónɨnɨ́árɨnɨ.’ searɨŋanigɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","awa rɨ́wamɨŋɨ́ xɨ́o nánɨ Bɨkwɨ́ Gorɨxoyáyo eánɨŋɨ́pɨ nɨjɨ́á oimónɨ́poyɨnɨrɨ wigɨ́ dɨŋɨ́ jɨ́ayo naŋɨ́ nɨwimɨxɨrɨ ");
INSERT INTO aak_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","re urɨŋɨnigɨnɨ, “Eŋíná dánɨ Bɨkwɨ́yo rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨnɨ, ‘Ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́o rɨ́nɨŋɨ́ nɨmearɨ nɨperɨ aiwɨ sɨ́á wɨyaú wɨyi óráná ámɨ xwárɨpáyo dánɨ wiápɨ́nɨmeanɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Rɨpɨ enɨ nɨrɨnɨrɨ eánɨnɨ, ‘Ámá omɨ dɨŋɨ́ nɨwɨkwɨ́rorɨŋɨ́pimɨ dánɨ xegɨ́ imónɨŋɨ́yɨ́ xwɨyɨ́á rɨpɨ wáɨ́ wurɨmeipɨ́rɨ́árɨnɨ, “Segɨ́ ɨ́wɨ́ yarɨgɨ́áyɨ́ rɨ́wɨ́mɨnɨ nɨmamoro sanɨŋɨ́ imónánáyɨ́, Gorɨxo yokwarɨmɨ́ seaiinɨŋoɨ.” Jerusaremɨ dánɨ aŋɨ́ nɨmɨnɨ wáɨ́ e wurɨmeipɨ́rɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Seyɨ́né amɨpí nionɨ nánɨ wɨnɨ́á rɨpɨ nánɨ áwaŋɨ́ urɨméɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Arɨ́á époyɨ. Gɨ́ ápo eŋíná segɨ́ seáwowayá sɨ́mɨmaŋɨ́ e dánɨ ‘Nionɨ segɨ́ seárɨ́awéyo gɨ́ kwíyɨ́pɨ wimɨ́árɨnɨ.’ urɨŋɨ́pɨ seyɨ́né seaímeanɨ́a nánɨ nionɨ rɨxa seaiapowárɨmɨ́ɨnɨ. Seyɨ́né Gorɨxoyá kwíyɨ́ émɨ dánɨ sɨnɨ eŋɨ́ mɨseaeámɨxɨpa nerɨ́ná aŋɨ́ rɨpimɨ pɨ́nɨ nɨwiárɨmɨ amɨ amɨ mupanɨ. E nerɨ aí rɨxa eŋɨ́ seaeámɨxáná nionɨ nánɨ amɨ amɨ wáɨ́ urɨméɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","O Jerusaremɨ dánɨ ayo nɨwirɨmeámɨ nurɨ aŋɨ́ xegɨ́ yoɨ́ Betaniyɨ rɨnɨŋɨ́pimɨ nɨrémómáná xegɨ́ wé seáyɨ e nimɨxɨrɨ ayɨ́ Gorɨxoyá dɨŋɨ́ tɨ́nɨ píránɨŋɨ́ oŋweápoyɨnɨrɨ amɨpí yarɨŋɨ́ nɨwirɨ ");
INSERT INTO aak_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","sɨnɨ nɨwiarɨ́ná Gorɨxo omɨ nɨménapɨmɨ rɨxa aŋɨ́namɨ nánɨ peyiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Rɨxa aŋɨ́namɨ nánɨ peyíagɨ ayɨ́ e sɨŋwɨ́ nɨwɨnɨmɨ ámɨ Jerusaremɨ nánɨ nuro seáyɨmɨ seáyɨmɨ nimóga nuróná ");
INSERT INTO aak_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","íníná aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwiayiro Gorɨxomɨ seáyɨ e umeagɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iwamɨ́ó xwɨ́á rɨrí sɨnɨ meŋáná Xwɨyɨ́áoyɨ rɨnɨŋo íná ŋweaŋɨ́rɨnɨ. O Gorɨxo tɨ́nɨ nawínɨ nɨŋwearɨ o tɨ́nɨ xɨxenɨ imónɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aga iwamɨ́ó dánɨ Gorɨxo tɨ́nɨ ŋweagɨ́íorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","O Gorɨxo nerɨŋɨ́pimɨ dánɨ amɨpí imónɨŋɨ́ nɨpɨnɨ imónɨŋɨ́rɨnɨ. Pí pí imónɨŋɨ́pɨ wí xegɨ́pɨ mimónɨ́ xɨ́o nerɨŋɨ́pimɨ dánɨnɨ imónɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","O dɨŋɨ́ ámá amɨpí sɨŋɨ́ imónɨnɨ́a nánɨ tɨ́ŋorɨnɨ. Dɨŋɨ́ o tɨ́ŋɨ́pɨ, ayɨ́ ámáyo Gorɨxo imónɨŋɨ́pɨ nánɨ wɨ́á wókinɨ́a nánɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wɨ́á apɨ sɨ́á yinárɨŋe wɨ́á ónarɨ́ná sɨ́ápɨ wí sɨ́á uyimɨxɨŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ámá wo —O wayɨ́ neameaiŋɨ́ Jonoyɨ rɨnɨŋorɨnɨ. Gorɨxoyá xwɨyɨ́á yaŋɨ́ wiowárɨŋorɨnɨ. Omɨ Gorɨxo urowárénapáná ");
INSERT INTO aak_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","o ámá nɨ́nɨ wɨ́á apɨ nánɨ arɨ́á nɨwiro dɨŋɨ́ ɨkwɨ́ropɨ́rɨ nánɨ áwaŋɨ́ urɨmɨnɨrɨ nánɨ bɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","O ámáyo wɨ́á wókiarɨŋomanɨ. Sa wɨ́á wókiarɨŋo nánɨ áwaŋɨ́ nearɨmɨnɨrɨ bɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aga nepa wɨ́á wókiarɨŋo, ayɨ́ rorɨnɨ. Xwɨ́á tɨ́yo nánɨ nɨbɨrɨ́ná Gorɨxo imónɨŋɨ́pɨ nánɨ dɨŋɨ́ mopɨ́rɨ nánɨ wɨ́á wókímɨxɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","O xwɨ́á tɨ́yo ŋweaŋáná xwɨ́árí tɨ́nɨ amɨpí tɨ́nɨ xɨ́o nerɨŋɨ́pimɨ dánɨ imónɨŋɨ́ aiwɨ oxɨ́ apɨxɨ́ mí mɨwómɨxɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O ámá xegɨ́ Judayɨ́ tɨ́ŋɨ́ e nánɨ úagɨ aiwɨ mumímɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","E nerɨ aiwɨ ámá omɨ numímɨnɨro dɨŋɨ́ wɨkwɨ́róɨ́áyɨ́ niaíwɨ́ Gorɨxoyá oimónɨ́poyɨnɨrɨ sɨŋwɨ́ wɨnɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ayɨ́ niaíwɨ́ ámá emeaarɨgɨ́á yapɨ imónɨgɨ́ámanɨ. Apɨxɨ́ xɨrarɨgɨ́á yapɨ imónɨgɨ́ámanɨ. Ámáyá dɨŋɨ́yo dánɨ enɨ imónɨgɨ́ámanɨ. Sa Gorɨxoyá dɨŋɨ́yo dánɨ xegɨ́ niaíwɨ́yɨ́ imónɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Xwɨyɨ́áoyɨ rɨnɨŋo aga ámá nimónɨrɨ xwɨ́á tɨ́yo nene tɨ́nɨ ŋweaŋáná nene seáyɨ e o imónɨŋɨ́pɨ aga xegɨ́ bɨ imónɨŋagɨ wɨnɨŋwanigɨnɨ. O, Gorɨxoyá siŋɨ́nɨŋɨ́ émiaoŋo xɨ́o tɨ́nɨ xɨxenɨ seáyɨ e imónɨŋagɨ wɨnɨŋwanigɨnɨ. Ámaéne wá ayá wí neawianarɨŋagɨ wɨnɨŋwanigɨnɨ. Gorɨxo imónɨŋɨ́pɨ nepa xɨxenɨ sɨwá neainarɨŋagɨ enɨ wɨnɨŋwanigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O nánɨ wayɨ́ neameaiŋɨ́ Jono áwaŋɨ́ nɨrɨrɨ́ná wáɨ́ re rɨŋɨnigɨnɨ, “O nionɨ re rɨŋáorɨnɨ, ‘Rɨ́wɨ́yo bɨnɨ́o nionɨ sɨnɨ meŋáná o xámɨ ŋweaŋagɨ nánɨ nionɨ seáyɨ e nimónɨnɨ.’ rɨŋáorɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ayɨ́ rɨpɨ nánɨ “Ámaéne wá ayá wí neawianarɨŋagɨ wɨnɨrane Gorɨxo imónɨŋɨ́pɨ nepa xɨxenɨ sɨwá neainarɨŋagɨ wɨnɨrane eŋwanigɨnɨ.” rarɨŋɨnɨ. O wá nɨneawianɨrɨ́ná bɨ onɨmiápɨ mɨneawianɨ́ xwapɨ́ ayá wí nɨneawianɨrɨ arɨrá ámɨ ámɨ neaiŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ayɨ́ rɨpɨ nánɨrɨnɨ. Moseso Gorɨxoyá dɨŋɨ́ tɨ́nɨ ŋwɨ́ ikaxɨ́ nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋɨ́ eŋagɨ aiwɨ ayɨ́ Jisasɨ Kiraiso neaíwapɨyiŋɨ́pimɨ dánɨ Gorɨxo wá neawianarɨŋɨ́pɨ nánɨ nɨjɨ́á imónɨrane nepa xɨ́o imónɨŋɨ́pɨ nánɨ nɨjɨ́á imónɨrane eŋwárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Waíná aiwɨ Gorɨxomɨ ámá go sɨŋwɨ́ wɨnɨŋɨ́rɨnɨ? E nerɨ aí Ŋwɨ́á siŋɨ́nɨŋɨ́ émiaoŋo —O íníná xanoyá sáɨ́yo ŋweaŋorɨnɨ. Nene “Xano imónɨŋɨ́pɨ apɨrɨ́anɨ?” yaiwianɨ wɨ́á neaókímɨxɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judayɨ́ wí Jerusaremɨ dánɨ re nɨyaiwiro, “Wayɨ́ umeaiarɨŋɨ́ Jono ámá Gorɨxoyá dɨŋɨ́ tɨ́nɨ yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨ́anɨ? Worɨ́anɨ?” nɨyaiwiro apaxɨ́pánɨŋɨ́ imónɨgɨ́á wa tɨ́nɨ ámá Ripaiyɨ rɨnɨŋɨ́yɨ́ wa tɨ́nɨ —Ripaiowa aŋɨ́ Gorɨxo nánɨ rɨdɨyowá yarɨgɨ́iwámɨ mewegɨ́áwamɨ saŋɨ́ uráparɨgɨ́áwarɨnɨ. Awa tɨ́nɨ nuro Jonomɨ “Goxɨrɨnɨ?” urɨ́poyɨnɨrɨ urowáráná ");
INSERT INTO aak_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","awa nuro omɨ nɨwímearo yarɨŋɨ́ “Goxɨrɨnɨ?” wíáná o yumɨ́í bɨ mɨwí waropárɨ́ ninɨrɨ “Aga nepa seararɨŋɨnɨ.” nurɨrɨ “Nionɨ ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́onɨmanɨ. Kiraisoyɨ rarɨgɨ́onɨmanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","awa yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ ayɨ́ o meŋánáyɨ́, goxɨrɨnɨ? Joxɨ wɨ́á rókiamoagɨ́ Eraijaoxɨranɨ?” urɨ́agɨ́a o “Ayɨ́ nionɨmanɨ.” urɨ́agɨ awa “Joxɨ wɨ́á rókiamoagɨ́ Isɨrerene xwayɨ́ nanɨrɨ ŋweaŋwáoxɨranɨ?” urɨ́agɨ́a o “Oweoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","awa “Joxɨ ‘Gonɨrɨnɨ.’ simónarɨnɨ? Ámá none nearowárénapɨ́áyo áwaŋɨ́ uranɨrɨ rarɨŋwɨnɨ. Jɨwanɨŋoxɨ píoɨ rɨnarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","o re urɨŋɨnigɨnɨ, “Nionɨ wɨ́á rókiamoagɨ́ Aisaiao rɨŋɨ́pɨ tɨ́nɨ xɨxenɨ ámá dɨŋɨ́ meaŋe dánɨ rɨ́aiwá re rarɨŋáonɨrɨnɨ, ‘Óɨ́ Ámɨnáo nánɨ píránɨŋɨ́ wimoípoyɨ.’ rarɨŋáonɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","awa —Parisiowa urowárɨ́áwarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Awa yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ ámá yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨ mimónɨpa erɨ wɨ́á rókiamoagɨ́ Iraijaoxɨ mimónɨpa erɨ wɨ́á rókiamoagɨ́ nene xwayɨ́ nanɨrɨ ŋweaŋwáoxɨ mimónɨpa erɨ eŋánáyɨ́, pí nánɨ ámáyo wayɨ́ numeaia warɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jono re urɨŋɨnigɨnɨ, “Nionɨ ámáyo wayɨ́ numeairɨ́ná iniɨgɨ́ tɨ́nɨnɨ umeaiarɨŋáonɨrɨnɨ. E nerɨ aí seyɨ́né tɨ́nɨ áwɨnɨmɨ roŋɨ́ wo soyɨ́né sɨŋwɨ́ mí mómɨxɨ́orɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ámá nionɨyá rɨ́wɨ́yo bɨnɨ́o nánɨ rarɨŋɨnɨ. Ámá nionɨ nánɨ ‘Wé rónɨŋorɨnɨ.’ niaiwiarɨŋagɨ́a aí o aga seáyɨ e nimónɨŋagɨ nánɨ oyá sɨkwɨ́ sú gwɨ́ wikweaipaxonɨmanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jono iniɨgɨ́ Jodanɨ rapáyo jɨ́arɨwámɨnɨ aŋɨ́ yoɨ́ Betani tɨ́ŋɨ́ e wayɨ́ umeaiarɨ́ná nɨwímearo yarɨŋɨ́ apɨ wigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wayɨ́ neameaiŋɨ́ Jono, sá weŋo Jisaso xɨ́o tɨ́ŋɨ́ e nánɨ barɨŋagɨ nɨwɨnɨrɨ re rɨŋɨnigɨnɨ, “Sipɨsipɨ́ miá rɨdɨyowánɨŋɨ́ ámá nɨnenenɨ uyɨ́niɨ́ yarɨŋwápɨ yokwarɨmɨ́ neaiinɨ́a nánɨ Gorɨxo neaiapɨŋo iworɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","O re rɨŋáorɨnɨ, ‘Ámá nionɨyá rɨ́wɨ́yo bɨnɨ́o nionɨ sɨnɨ meŋáná o ŋweaagɨ́ eŋagɨ nánɨ nionɨ seáyɨ e nimónɨŋorɨnɨ.’ rɨŋáorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xámɨ nionɨ enɨ ámá nɨbɨrɨ yeáyɨ́ neayimɨxemeanɨ́wɨnɨgɨnɨrɨ xwayɨ́ nanɨrɨ ŋweaŋwáomɨ mí mɨwómɨxɨpa nerɨ aiwɨ o nánɨ gɨ́ Isɨrerɨyo wayɨ́ numeaiarɨŋɨ́pimɨ dánɨ wɨ́á urókiamómɨnɨrɨ bɨŋárɨnɨ.” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wayɨ́ neameaiŋɨ́ Jono Gorɨxomɨ xewaxo wímeaŋɨ́pɨ nánɨ mɨ́ko nimónɨrɨ áwaŋɨ́ re nearɨŋɨnigɨnɨ, “Nionɨ kwíyɨ́ Gorɨxoyápɨ aŋɨ́namɨ dánɨ xawiówɨ́ yapɨ nɨweapɨrɨ omɨ xeŋweáagɨ wɨnɨŋanigɨnɨ.” nɨnearɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","re nearɨŋɨnigɨnɨ, “Xámɨ nionɨ enɨ ámá nɨbɨrɨ yeáyɨ́ neayimɨxemeanɨ́wɨnɨgɨnɨrɨ xwayɨ́ nanɨrɨ ŋweaŋwáomɨ mí mɨwómɨxɨpa nerɨ aiwɨ iniɨgɨ́ tɨ́nɨ wayɨ́ numeaia ounɨrɨ nɨrowárénapɨŋo re nɨrɨŋɨnigɨnɨ, ‘Ámá joxɨ kwíyɨ́ nɨweapɨrɨ wímeáagɨ wɨnɨrɨ́o nánɨ dɨŋɨ́ re yaiwíɨrɨxɨnɨ, “Ámáyo wayɨ́ numeairɨ́ná kwíyɨ́ tɨ́nɨ numeairɨ sɨxɨ́ umímonɨ́o, ayɨ́ orɨ́anɨ?” yaiwíɨrɨxɨnɨ.’ nɨrɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gorɨxo nɨrɨŋɨ́pɨ tɨ́nɨ xɨxenɨ niɨwanɨŋonɨ omɨ sɨŋwɨ́ nɨwɨnɨrɨ nánɨ nímeaŋɨ́pɨ nánɨ mɨ́konɨ ‘O niaíwɨ́ Gorɨxoyáorɨnɨ.’ seararɨŋɨnɨ.” nearɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wayɨ́ neameaiŋɨ́ Jono, sá weŋo wɨ́ápɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋɨ́ waú tɨ́nɨ nawínɨ éɨ́ nɨrorɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Jisaso aŋɨ́ warɨŋagɨ nɨwɨnɨrɨ re rɨŋɨnigɨnɨ, “Sipɨsipɨ́ miá rɨdɨyowá nánɨ Gorɨxo neaiapɨŋo iworɨnɨ.” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","wiepɨsarɨŋowaú Jono e rɨ́agɨ arɨ́á nɨwiri Jisasomɨ númɨ warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","o nɨkɨnɨmónɨrɨ wɨnɨŋɨnigɨnɨ. Awaú númɨ barɨŋagɨ́i nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Pí yanɨri númɨ nɨbarɨŋiɨ?” urɨ́agɨ awaú re urɨgɨ́isixɨnɨ, “Rabai —Negɨ́ agapɨ́né nɨrɨrɨ́ná ‘Nearéwapɨyarɨŋoxɨrɨnɨ.’ rarɨŋwápɨrɨnɨ. Rabai, joxɨ aŋɨ́ giwámɨ wearɨŋɨ́rɨnɨ?” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","o re urɨŋɨnigɨnɨ, “Awagwí nɨbɨri sɨŋwɨ́ wɨnɨ́piyɨ.” urɨ́agɨ awaú tɨ́nɨ nuro aŋɨ́ xɨ́o wearɨŋiwá sɨŋwɨ́ nɨwɨnɨri rɨxa sɨ́ápɨ tɨ́nɨ 4:00 p.m. imónɨŋagɨ nánɨ sɨ́á ayi o tɨ́nɨ e sá wegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wayɨ́ neameaiŋɨ́ Jono Jisaso nánɨ rɨ́agɨ arɨ́á nɨwiri númɨ úɨ́íwaú wɨ́o Adɨruorɨnɨ. O Saimonɨ Pitaomɨ xexɨrɨ́meáorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","O xámɨ nurɨ xexɨrɨ́meáo Saimono nánɨ pɨ́á nerɨ re urémeaŋɨnigɨnɨ, “Yawawi ámá negɨ́ Xibɨruyɨ́ pɨ́né tɨ́nɨ Mesaiaoyɨ rarɨŋwáo —O ámá yeáyɨ́ uyimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́orɨnɨ. Kiraisoyɨ enɨ rɨnɨŋorɨnɨ. Omɨ rɨxa sɨŋwɨ́ wɨnɨmeáwiɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","nɨwirɨmeámɨ Jisaso tɨ́ŋɨ́ e nánɨ nuri wímeááná Jisaso omɨ sɨŋwɨ́ agwɨ́ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ Jonomɨ xewaxoxɨ Saimonoxɨrɨnɨ. Ríná dánɨ yoɨ́ Sipasoxɨ —Yoɨ́ apɨ Gɨrikɨyɨ́ pɨ́né nɨrɨrɨ́ná Pitaoyɨ rarɨgɨ́ápɨrɨnɨ. (Yoɨ́ mɨ́kɨ́pɨ sɨ́ŋáɨ rɨnɨnɨ.) Yoɨ́ Sipasoxɨ rɨrɨpɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Jisaso, sá weŋo wɨ́ápɨ tɨ́nɨ Gariri pɨropenɨsɨ́yo nánɨ umɨnɨrɨ nerɨ́ná ámá womɨ —O Piripoyɨ rɨnɨŋorɨnɨ. Aŋɨ́ yoɨ́ Betɨsaida dáŋorɨnɨ. Aŋɨ́ apɨ ayɨ́ Adɨruo tɨ́nɨ Pitao tɨ́nɨ enɨ aŋɨ́ apimɨ dáŋowaúrɨnɨ. Jisaso Piripoyɨ rɨnɨŋomɨ nɨwímearɨ “Joxɨ nɨxɨ́deɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piripo nurɨ xegɨ́ ámá womɨ —O xegɨ́ yoɨ́ Natanieroyɨ rɨnɨŋorɨnɨ. Omɨ nɨwímearɨ re urɨŋɨnigɨnɨ, “Ámá Moseso eŋíná nɨrɨrɨ rɨ́wamɨŋɨ́ earɨ wɨ́á rókiamoagɨ́áwa nɨrɨro rɨ́wamɨŋɨ́ earo egɨ́o rɨxa sɨŋwɨ́ wɨnɨmeáwɨnɨ. O Nasaretɨ dáŋɨ́ Josepomɨ xewaxo Jisasorɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniero ámá Gorɨxo Isɨrerɨyo yeáyɨ́ uyimɨxemeanɨ́a nánɨ urowárénapɨnɨ́o nánɨ re urɨŋɨnigɨnɨ, “Joxɨ re rɨyaiwiarɨŋɨnɨ, ‘Nasaretɨ dánɨ nene ayá sɨ́wɨ́ nearopaxɨ́ imónɨŋɨ́ bɨ imónɨpaxɨ́rɨnɨ.’ rɨyaiwiarɨŋɨnɨ?” urɨ́agɨ Piripo re urɨŋɨnigɨnɨ, “Joxɨ nɨbɨrɨ sɨŋwɨ́ wɨneɨ.” nurɨmɨ nuri Jisaso tɨ́ŋɨ́ e barɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","o Nataniero barɨŋagɨ nɨwɨnɨrɨ o nánɨ re rɨŋɨnigɨnɨ, “Isɨrerɨyɨ́ wo ámáyo yapɨ́ bɨ mɨwíwapɨyarɨŋo iworɨnɨ.” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniero ududɨ́ nɨwinɨrɨ re urɨŋɨnigɨnɨ, “Arɨge nerɨ joxɨ nionɨ nánɨ nɨjɨ́á imónɨŋɨnɨ?” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Piripo sɨnɨ rɨ́aiwá mɨrɨrɨpa éɨ́mɨ joxɨ íkɨ́á pikɨ́namɨ íkwapiŋɨ́yo ŋweaŋáná sɨŋwɨ́ ranɨ́anigɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniero re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ niaíwɨ́ Gorɨxoyáoxɨrɨnɨ. Isɨrerene negɨ́ mɨxɨ́ ináyoxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ ‘Joxɨ íkɨ́á pikɨ́namɨ íkwapiŋɨ́yo ŋweaŋáná sɨŋwɨ́ ranɨ́anigɨnɨ.’ rɨrɨ́agɨ nánɨ joxɨ ‘Gorɨxomɨ xewaxorɨ́anɨ?’ nɨniaiwirɨ dɨŋɨ́ rɨnɨkwɨ́roarɨŋɨnɨ? Nionɨ apimɨ seáyɨ e imónɨŋɨ́ bɨ yarɨŋagɨ sɨŋwɨ́ nanɨrɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","omɨ re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Aŋɨ́namɨ dánɨ óɨ́ ináná Gorɨxoyá aŋɨ́najɨ́ ámá imónɨŋáonɨ tɨ́ŋɨ́ e nánɨ yirɨ weapɨrɨ yarɨŋagɨ́a sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sɨ́á wɨyaú pwéáná Gariri pɨropenɨsɨ́yo aŋɨ́ bɨ xegɨ́ yoɨ́ Kenaɨ rɨnɨŋɨ́pimɨ ámá wo apɨxɨ́ meaarɨŋagɨ nánɨ aiwá apɨ nimɨxɨro yarɨ́ná Jisasomɨ xɨnáí aŋɨ́ ayo ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","omɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋowamɨ tɨ́nɨ urepeárɨ́á eŋagɨ nánɨ awa enɨ nɨbɨro ŋweaŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ámá aiwá apɨ nánɨ awí eánɨ́áyɨ́ iniɨgɨ́ wainɨ́ nɨ́nɨ nowáráná Jisasomɨ xɨnáí re urɨŋɨnigɨnɨ, “Íwe, wainɨ́ nɨ́nɨ rɨxa nowáráoɨ. Bɨ sɨnɨ mɨwenɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisaso re urɨŋɨnigɨnɨ, “Ineyɨ, jíxɨ nionɨ pí oenɨrɨ nɨrarɨŋɨnɨ? Nionɨyá eŋɨ́ eánɨŋɨ́ sɨŋánɨ imónɨnɨyɨ́ rínámanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","xɨnáí ámá aiwá nɨxero yaŋɨ́ wiarɨgɨ́áwamɨ re urɨŋɨnigɨnɨ, “O pí pí searɨ́ɨ́yɨ́ xɨxenɨ xɨ́dɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jisaso sɨ́ŋá tɨ́nɨ xwárɨ́á sɨxɨ́ imɨxɨnɨŋɨ́ wé wɨ́úmɨ dáŋɨ́ wo —Apɨ wánɨ wánɨ iwajɨ́á nerɨ́ná 100 ritá iwajɨ́á epaxɨ́pɨrɨnɨ. Judayɨ́ wigɨ́ yarɨgɨ́ápɨ tɨ́nɨ xɨxenɨ nerɨ́ná Gorɨxoyá sɨŋwɨ́yo dánɨ amɨpí wé rónɨgɨ́á imónanɨro igwɨ́á wímoarɨgɨ́ápa yanɨrɨ yarɨgɨ́ápɨrɨnɨ. Jisaso sɨxɨ́ wé wɨ́úmɨ dáŋɨ́ wo apɨ weŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ámá aiwá yaŋɨ́ wiarɨgɨ́áwamɨ re urɨŋɨnigɨnɨ, “Iniɨgɨ́ niwiro iwajɨ́á nerɨ́ná magwɨ́ époyɨ.” urɨ́agɨ awa aga iniɨgɨ́ iwajɨ́á neróná magwɨ́ imɨmɨ́ yáráná ");
INSERT INTO aak_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","o awamɨ re urɨŋɨnigɨnɨ, “Xwárɨ́á sɨxɨ́ tɨ́yo dánɨ niwiro nɨmeámɨ nuro seáyɨ́ wiarɨgɨ́oyɨ́né seáyɨ e seaimónɨŋomɨ mɨnɨ wípoyɨ.” urɨ́agɨ awa nɨmeámɨ nuro mɨnɨ wíáná ");
INSERT INTO aak_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","seáyɨ́ wiarɨgɨ́áwamɨ bosɨ́ umiearɨŋo aga iniɨgɨ́ rɨxa wainɨ́ imónɨ́ɨ́pɨ gɨ́gɨ́ nerɨ —O awa iwíɨ́e nánɨ majɨ́á nerɨ aiwɨ aiwá yaŋɨ́ wiarɨgɨ́áwa nɨjɨ́árɨnɨ. O gɨ́gɨ́ nerɨ apɨxɨ́ meaarɨŋomɨ “Eɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","re urɨŋɨnigɨnɨ, “Ámá nɨ́nɨ iniɨgɨ́ wainɨ́ yaŋɨ́ nɨwia nuróná re yarɨgɨ́árɨnɨ. Xámɨ awiaxɨ́pɨ yaŋɨ́ nɨwia núɨsáná ámá wainɨ́ apɨ rɨxa nɨnɨmáná eŋáná naŋɨ́ onɨmiápɨ imónɨŋɨ́pɨ yaŋɨ́ nɨwia warɨgɨ́árɨnɨ. E yarɨgɨ́á eŋagɨ aiwɨ joxɨ e méɨnɨ. Joxɨ xámɨ wainɨ́ naŋɨ́ imónɨŋɨ́pɨ yaŋɨ́ nɨneaiapɨrɨ aiwɨ wainɨ́ aga awiaxɨ́pɨ yómɨŋɨ́ nɨmerɨ agwɨnɨ neaiaparɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisaso Gariri pɨropenɨsɨ́yo aŋɨ́ Kenayo nɨŋwearɨ́ná emɨmɨ́ apɨ iwamɨ́ó nɨwíwapɨyirɨŋɨ́pimɨ dánɨ eŋɨ́ eánɨŋɨ́ xɨ́o imónɨŋɨ́pɨ sɨwá winarɨ́ná xegɨ́ wiepɨsarɨŋowa sɨŋwɨ́ nɨwɨnɨro dɨŋɨ́ wɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","E nemo aŋɨ́ xegɨ́ yoɨ́ Kapaneamɨ rɨnɨŋɨ́pimɨ nánɨ nɨwerɨ xegɨ́ xɨnáí tɨ́nɨ xexɨrɨ́meáowa tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ enɨ nawínɨ nɨwero e sɨ́á árɨ́nɨ́ wí wegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jisaso sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi aŋwɨ e imónɨŋáná Jerusaremɨ nánɨ nɨyoarɨ ");
INSERT INTO aak_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ ákɨŋáyo nɨpáwirɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Nɨgwɨ́ nánɨ wa burɨmákaú bɨ́ ero sipɨsipɨ́ bɨ́ ero xawiówɨ́ bɨ́ ero yarɨŋagɨ́a nɨwɨnɨrɨ nɨgwɨ́ senisɨ́ wiarɨgɨ́áwa enɨ éɨ́ nɨŋwearo yarɨŋagɨ́a nɨwɨnɨrɨ re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sámí nɨmearɨ sɨkwɨ́á nɨyírearɨ́ná sipɨsipɨ́ tɨ́nɨ burɨmákaú tɨ́nɨ mɨxɨ́ xɨ́dowárɨrɨ xiáwowamɨ enɨ mɨxɨ́ xɨ́dowárɨrɨ nɨgwɨ́ senisɨ́ yarɨgɨ́áwayá nɨgwɨ́pɨ nɨmearɨ emɨ noyaxɨmorɨ wigɨ́ íkwiaŋwɨ́ enɨ mɨwiárorɨ nemáná ");
INSERT INTO aak_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","xawiówɨ́ bɨ́ yarɨgɨ́áwamɨ mɨxɨ́ re urɨŋɨnigɨnɨ, “Nɨmeámɨ úpoyɨ. Aŋɨ́ gɨ́ ápoyá riwá makerɨ́á aŋiwánɨŋɨ́ pí nánɨ imɨxarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","xegɨ́ wiepɨsarɨŋowa Bɨkwɨ́yo rɨ́wamɨŋɨ́ re nɨrɨnɨrɨ eánɨŋɨ́pɨ nánɨ dɨŋɨ́ winɨŋɨnigɨnɨ, “ ‘Ápoxɨnɨyá aŋiwámɨ píránɨŋɨ́ éɨ́rɨxɨnɨrɨ sɨ́mɨ́ nɨxeadɨ́pénɨrɨŋɨ́pimɨ dánɨ mɨyɨ́óyo urɨ́kwínarɨŋɨnɨ.’ nimónarɨnɨ.” nɨrɨnɨrɨ eánɨŋɨ́pɨ nánɨ dɨŋɨ́ winɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judayɨ́ ámɨnáowa Jisaso éɨ́pɨ sɨŋwɨ́ nɨwɨnɨro mɨxɨ́ re urɨgɨ́awixɨnɨ, “Nene ‘E epaxorɨ́anɨ?’ siaiwianɨ nánɨ emɨmɨ́ bɨ rɨxa rɨneaíwapɨyarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né aŋɨ́ riwá pɨneápoyɨ. E nerɨ́náyɨ́, nionɨ ámɨ sɨ́á wɨyaú wɨyimɨ mɨrɨmɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judayɨ́ ámɨnáowa re urɨgɨ́awixɨnɨ, “None aŋɨ́ riwá mɨrarɨ́ná xwiogwɨ́ 46 neamúroŋiwárɨnɨ. Joxɨ ananɨ sɨ́á wɨyaú wɨyimɨ mɨrɨpaxoxɨranɨ?” urɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","o e nurɨrɨ́ná ewayɨ́ ikaxɨ́ xewanɨŋo nánɨ nɨrɨrɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ayɨnánɨ rɨ́wéná Jisaso Gorɨxoyá dɨŋɨ́yo dánɨ pɨyɨ́ weŋe dánɨ nɨwiápɨ́nɨmeámáná eŋáná wiepɨsarɨŋowa ewayɨ́ ikaxɨ́ xɨ́o aŋiwá nánɨ urɨnɨŋɨ́pɨ nánɨ dɨŋɨ́ nɨwinɨrɨ “Bɨkwɨ́yo xɨ́o nánɨ nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xwɨyɨ́á xɨ́o rɨnɨŋɨ́pɨ tɨ́nɨ neparɨnɨ.” nɨyaiwiro dɨŋɨ́ wɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi nánɨ aiwá imɨxarɨgɨ́íná Jisaso sɨnɨ Jerusaremɨ nɨŋwearɨ́ná emɨmɨ́ yarɨŋagɨ ámá obaxɨ́ e ŋweagɨ́áyɨ́ sɨŋwɨ́ nɨwɨnɨro omɨ dɨŋɨ́ nɨwɨkwɨ́roro apaxɨ́ mé “Orɨ́anɨ?” yaiwiarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","xewanɨŋo nepaxɨŋo nimónɨrɨ sɨŋánɨ “Onɨrɨnɨ.” nɨrɨrɨ áwaŋɨ́ mɨrowiároŋɨnigɨnɨ. O ámá nɨ́nɨ yarɨgɨ́ápɨ nánɨ nɨjɨ́á imónɨŋo eŋagɨ nánɨ áwaŋɨ́ mɨrowiároŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ámá wigɨ́ yaiwiarɨgɨ́ápɨ xwioxɨ́yo adadɨ́ nɨwirɨ nɨjɨ́á imónɨŋo eŋagɨ nánɨ wí ámá nɨbɨro apɨ nánɨ áwaŋɨ́ urɨpaxomanɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ámá wo —O xegɨ́ yoɨ́ Nikodimasoyɨ rɨnɨŋorɨnɨ. Gwɨ́ mónɨgɨ́á yoɨ́ Parisiyɨ rɨnɨŋɨ́yɨ́ worɨnɨ. Axo Judayɨ́ mebá worɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","O sɨ́á wɨyimɨ árɨ́wɨyimɨ nurɨ Jisasomɨ nɨwímearɨ re urɨŋɨnigɨnɨ, “Rabai, ‘Joxɨ nearéwapɨyarɨŋɨ́ Gorɨxo rɨrowárénapɨŋoxɨ imónɨŋɨnɨ.’ neaimónarɨnɨ. Gorɨxo dɨŋɨ́ mukɨkayoŋáná ámá wo emɨmɨ́ joxɨ yarɨŋɨ́pɨ epaxɨ́ mimónɨŋagɨ nánɨ rarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa rɨrarɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ seáyɨmɨ dánɨ meweapa nerɨ́náyɨ́, Gorɨxoyá xwioxɨ́yo wí ŋweapɨ́rɨ́á menɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimaso re urɨŋɨnigɨnɨ, “Ámá go go rɨxa xwé niwiarómáná arɨge nerɨ ámɨ eweanɨŋoɨ? ‘Ámɨ xɨnáíyá agwɨ́yo páwíáná omɨ ámɨ sɨŋɨ́ xɨnáí xɨrɨpaxɨ́rɨnɨ.’ nɨrɨrɨ rɨnɨrarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa rɨrarɨŋɨnɨ. Ámá iniɨgɨ́yo dánɨ ewearɨ Gorɨxoyá kwíyɨ́yo dánɨ ewearɨ mepa nerɨ́náyɨ́, wí Gorɨxoyá xwioxɨ́yo nɨpáwirɨ ŋweapaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Xanɨyaúmɨ dánɨ xɨrarɨgɨ́ápɨ, ayɨ́ warápɨnɨrɨnɨ. Kwíyɨ́yo dánɨ imónarɨŋɨ́pɨ, ayɨ́ dɨŋɨ́ sɨŋɨ́ imónɨŋɨ́pɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nionɨ re rɨrɨ́ápɨ nánɨ, ‘Joxɨ “Gorɨxoyá xwioxɨ́yo ŋweáɨmɨgɨnɨ.” nɨsimónɨrɨ́ná wí seáyɨmɨ dánɨ ewearɨ́ɨ́pɨ nɨmúropaxɨ́manɨ.’ rɨrɨ́ápɨ nánɨ ududɨ́ mɨsinɨpanɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Imɨŋɨ́ yarɨŋɨ́pɨ nánɨ dɨŋɨ́ moɨ. Imɨŋɨ́ xegɨ́ wimónarɨŋimanɨ yarɨ́ná joxɨ ɨwɨ́ rarɨŋagɨ arɨ́á nɨwirɨ aiwɨ gɨmɨ dánɨ bɨ́ɨ́pɨranɨ, gɨmɨ nánɨ úɨ́pɨranɨ, joxɨ nɨjɨ́á imónarɨŋɨ́manɨ. Nɨjɨ́á mimónɨpa nerɨ aiwɨ ‘Imɨŋɨ́ menɨnɨ.’ rɨpaxɨ́manɨ. Kwíyɨ́ enɨ axɨ́pɨ imónɨnɨ. Ámá sɨŋɨ́ ewearɨ́ná sɨŋwɨ́ wɨnɨpaxɨ́ mimónɨŋagɨ aiwɨ ‘Sɨŋɨ́ meweáɨ́yɨ́rɨnɨ.’ rɨpaxɨ́ menɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimaso re urɨŋɨnigɨnɨ, “Joxɨ nɨrarɨŋɨ́pɨ arɨge nerɨ imónɨpaxɨ́rɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ ámɨná negɨ́ Isɨrerene nearéwapɨyarɨŋɨ́ woxɨ eŋagɨ aí nionɨ rɨrarɨŋápɨ nánɨ majɨ́á rimónɨŋɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aga nepa rɨrarɨŋɨnɨ. None nɨjɨ́á imónɨŋwáyɨ́ nánɨ rɨrane sɨŋwɨ́ wɨnɨŋwáyɨ́ nánɨ áwaŋɨ́ rɨrane yarɨŋagwɨ aiwɨ pɨ́né none rarɨŋwáyɨ́ soyɨ́né aríkwɨ́kwɨ́ yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amɨpí xwɨ́á rɨrímɨ imónɨŋɨ́yɨ́ nánɨ áwaŋɨ́ searáná soyɨ́né ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ mɨkwɨ́ropa yarɨŋagɨ́a nánɨ amɨpí aŋɨ́namɨ imónɨŋɨ́pɨ áwaŋɨ́ nɨsearɨrɨ́náyɨ́, arɨge nero ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ ɨkwɨ́ropɨ́ráoɨ? ");
INSERT INTO aak_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ámá imónɨŋo —O aŋɨ́namɨ dánɨ weapɨŋorɨnɨ. O ámá nɨyonɨ aiwɨ onɨ aŋɨ́namɨ nánɨ yiŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Eŋíná negɨ́ arɨ́owa ámá dɨŋɨ́ meaŋe nemeróná ámá weaxɨ́á sidɨŋɨ́ óɨ́yɨ́ sɨŋɨ́ upɨ́rɨ́a nánɨ Moseso ainɨxɨ́ tɨ́nɨ weaxɨ́ánɨŋɨ́ nimɨxɨrɨ íkɨ́áyo nɨŋwɨrárɨmáná seáyɨ e mɨ́eyoáɨ́pɨ sɨŋwɨ́ nɨwɨnɨrɨŋɨ́pimɨ dánɨ sɨŋɨ́ ugɨ́awixɨnɨ. Ainɨxɨ́ weaxɨ́ánɨŋɨ́ imɨxɨnɨŋɨ́pɨ nɨŋwɨrárɨro mɨ́eyoagɨ́ápa ámá imónɨŋomɨ axɨ́pɨ numɨ́eyoapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ámá omɨ dɨŋɨ́ wɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́áyɨ́ imónɨpɨ́rɨ́a nánɨ omɨ numɨ́eyoapɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ayɨ́ rɨpɨ nánɨrɨnɨ. Gorɨxo ámá nɨyonɨ dɨŋɨ́ sɨxɨ́ xwapɨ́ ayá wí nuyirɨ nánɨ xegɨ́ niaíwɨ́ siŋɨ́nɨŋɨ́ émiaoŋo nene nánɨ wɨ́rénapɨŋɨnigɨnɨ. Ámá xewaxomɨ dɨŋɨ́ wɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ manɨ́nɨpa nero dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́ imónɨpɨ́rɨ́a nánɨ wɨ́rénapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ayɨ́ rɨpɨ éwɨnɨgɨnɨrɨ Gorɨxo xegɨ́ xewaxomɨ xwɨ́á rɨrímɨ nánɨ urowárénapɨŋɨnigɨnɨ. O ámáyo xwɨyɨ́á umeárɨ́wɨnɨgɨnɨrɨ murowárénapɨŋɨnigɨnɨ. Yeáyɨ́ uyimɨxemeanɨ́wɨnɨgɨnɨrɨ urowárénapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Xewaxomɨ dɨŋɨ́ wɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ Gorɨxo xwɨyɨ́á umeárɨpaxɨ́ mimónɨŋoɨ. E nerɨ aiwɨ xewaxomɨ dɨŋɨ́ mɨwɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ Gorɨxoyá siŋɨ́nɨŋɨ́ émiaoŋomɨ dɨŋɨ́ mɨwɨkwɨ́roarɨgɨ́á eŋagɨ nánɨ rɨxa xwɨyɨ́á umeárɨpaxɨ́ imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sa mɨ́kɨ́ tɨ́yo dánɨ Gorɨxo ‘Xwɨyɨ́á tɨ́ŋoxɨnɨ.’ urɨrɨ ‘Xwɨyɨ́á mayoxɨnɨ.’ urɨrɨ enɨ́árɨnɨ. O xwɨ́árímɨ ŋweagɨ́áyɨ́ e éɨ́rɨxɨnɨrɨ wimónarɨŋɨ́pɨ wɨ́ánɨŋɨ́ wókíagɨ aiwɨ ámá wigɨ́ yarɨgɨ́ápɨ sɨpínɨ imónɨŋɨ́ eŋagɨ nánɨ wɨ́á ókiŋɨ́pɨ nánɨ mɨwimónɨpa nerɨ sɨ́á yinɨŋɨ́pɨ nánɨ wimónarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ayɨ́ rɨpɨ nánɨ ámá sɨpínɨ yarɨgɨ́áyɨ́ nɨ́nɨ wɨ́á ókiŋɨ́pɨ nánɨ aga mɨwimónɨ́ sɨ́á yinɨŋɨ́pɨ nánɨ wimónarɨŋɨ́rɨnɨ. Wigɨ́ yarɨgɨ́ápɨ wɨ́á ókímɨxɨnanɨgɨnɨrɨ wɨ́á ókiŋe nánɨ barɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","E nerɨ aiwɨ ámá yadɨmɨŋɨ́ yarɨgɨ́á gɨyɨ́ gɨyɨ́ Gorɨxo wimónarɨŋɨ́pɨ oemɨnɨrɨ arɨ́á nɨwirɨ yarɨŋɨ́pɨ sɨŋánɨ oimónɨrɨ wɨ́á ókiŋe nánɨ ananɨ barɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","E nemáná Jisaso tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ Judia pɨropenɨsɨ́yo nánɨ nuro wí e awa tɨ́nɨ nawínɨ nɨŋwearóná ámáyo wayɨ́ numeaia warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","wayɨ́ neameaiŋɨ́ Jono aŋɨ́ yoɨ́ Inonɨyɨ rɨnɨŋɨ́pimɨ —Aŋɨ́ apɨ Serimɨ dánɨ aŋwɨ erɨnɨ. Jono aŋɨ́ apimɨ nɨŋwearɨ́ná e iniɨgɨ́ obaxɨ́ wearɨŋe eŋagɨ nánɨ o enɨ ámá bɨmiarɨgɨ́áyo wayɨ́ numeaia warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","—Íná Jono sɨnɨ gwɨ́ aŋɨ́yo mɨŋwɨrárɨnɨŋínárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Íná Jono xɨ́o xegɨ́ wiepɨsarɨŋowa re egɨ́awixɨnɨ. Nɨwiápɨ́nɨmearo wigɨ́ Judayɨ́ wo tɨ́nɨ xwɨyɨ́á nɨrɨnɨróná Gorɨxoyá sɨŋwɨ́yo dánɨ naŋɨ́ imónanɨro nánɨ iniɨgɨ́yo igɨ́á eánarɨgɨ́ápɨ nánɨ xwɨyɨ́á xɨmɨxɨmɨ́ ninɨro ");
INSERT INTO aak_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","e nemowa wayɨ́ neameaiŋɨ́ Jono tɨ́ŋɨ́ e nánɨ nuro re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, ámá joxɨ tɨ́nɨ iniɨgɨ́ Jodanɨ rapáyo jɨ́arɨwámɨnɨ ŋweagɨ́ío —O joxɨ áwaŋɨ́ nearɨŋorɨnɨ. O re yarɨnɨ. Ámáyo wayɨ́ numeaia warɨnɨ. E yarɨ́ná oxɨ́ apɨxɨ́ niaíwɨ́ nɨ́nɨ o tɨ́ŋɨ́ e nánɨ warɨŋoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","wayɨ́ neameaiŋɨ́ Jono re urɨŋɨnigɨnɨ, “Ámá wigɨ́ dɨŋɨ́yo dánɨ seáyɨ e imónarɨgɨ́ámanɨ. Aŋɨ́namɨ ŋweaŋo ‘Ámá o e nerɨ seáyɨ e oimónɨnɨ.’ mɨyaiwipa nerɨ́náyɨ́, wí e nerɨ seáyɨ e imónɨpaxɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xámɨ nionɨ áwaŋɨ́ re seararɨŋagɨ arɨ́á nigɨ́árɨnɨ, ‘Nionɨ Kiraisonɨ, ámá yeáyɨ́ seayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨgɨ́onɨmanɨ. Omɨ xámɨ umeáwɨnɨgɨnɨrɨ nɨrowárénapɨŋonɨrɨnɨ.’ seararɨŋagɨ rɨxa arɨ́á nigɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ewayɨ́ xwɨyɨ́á bɨ rɨpɨ urɨŋɨnigɨnɨ, “Apɨxɨ́ ŋwɨrárɨ́oyɨ́ ayɨ́ apɨxɨ́ oyáírɨnɨ. Apɨ́ wáɨ́ wiiŋoyáímanɨ. E nerɨ aiwɨ o damɨ dánɨ éɨ́ nɨrorɨ apɨxɨ́ meáo yayɨ́ yarɨŋagɨ arɨ́á nɨwirɨ́ná xɨ́o enɨ yayɨ́ seáyɨmɨ dánɨ yarɨŋɨ́rɨnɨ. Ayɨnánɨ dɨŋɨ́ niɨ́á nɨninɨrɨ bɨ onɨmiápɨ mɨninarɨnɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nionɨ rɨxa yɨ́wɨ́ nimóga warɨ́ná xewanɨŋo niwiarorɨ aga nepa néra nunɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ámɨ re urɨŋɨnigɨnɨ, “Ámá eramɨ dáŋo ámá nɨyonɨ seáyɨ e wimónɨŋorɨnɨ. Ámá xwɨ́á rɨrímɨ dáŋonɨ aga ámá imónɨrɨ amɨpí xwɨ́á tɨ́yo dáŋɨ́ nánɨ rɨrɨ yarɨŋáonɨrɨnɨ. E nerɨŋɨ́ aiwɨ aŋɨ́namɨ dáŋo aga nɨyonɨ seáyɨ e wimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Xewanɨŋo aŋɨ́namɨ dánɨ sɨŋwɨ́ wɨnɨrɨ arɨ́á wirɨ eŋɨ́yɨ́ nánɨ ámáyo áwaŋɨ́ nura warɨŋagɨ aiwɨ wí o áwaŋɨ́ rarɨŋɨ́pɨ mumímɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","E seararɨŋagɨ aiwɨ ámá áwaŋɨ́ o rarɨŋɨ́pɨ arɨ́á nɨwirɨ ‘Neparɨnɨ.’ yaiwíɨ́á gɨyɨ́ gɨyɨ́ rénɨŋɨ́ rarɨŋoɨ, ‘Neparɨnɨ. Gorɨxo xɨ́o rarɨŋɨ́pɨ tɨ́nɨ xɨxenɨ yarɨŋorɨnɨ.’ rarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá Gorɨxo urowárénapɨŋomɨ xewanɨŋoyá kwíyɨ́ ayɨkwɨ́ mɨwiŋɨ́ eŋagɨ nánɨ xɨ́oyá xwɨyɨ́á nɨra warɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xano xewaxomɨ dɨŋɨ́ sɨxɨ́ nuyirɨ amɨpí nɨ́nɨ ɨ́ánɨŋɨ́ wiepɨ́xɨ́niasiŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ámá xewaxomɨ dɨŋɨ́ wɨkwɨ́roarɨgɨ́á gɨyɨ́ gɨyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́rɨnɨ. E nerɨ aiwɨ xewaxomɨ aríkwɨ́kwɨ́ wiarɨgɨ́áyo dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ wímeanɨ́á menɨnɨ. Wikɨ́ Gorɨxo ámá ayo wónarɨŋɨ́pɨ anɨŋɨ́ wikwɨ́monɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Parisiowa arɨ́á re wigɨ́awixɨnɨ, “Jisaso wiepɨsarɨŋɨ́yɨ́ imɨxɨrɨ wayɨ́ umeairɨ yarɨ́ná oyáyɨ́ wayɨ́ umeaiarɨŋɨ́ Jonoyá wiepɨsarɨŋɨ́yo rɨxa wiárɨ́ múroarɨŋoɨ.” arɨ́á e wíagɨ́a aiwɨ Jisaso xewanɨŋo ámáyo wayɨ́ umeaiarɨŋagɨ marɨ́áɨ, sa xegɨ́ wiepɨsarɨŋowa wayɨ́ umeaiarɨŋagɨ́a nánɨ Parisiowa arɨ́á e wigɨ́awixɨnɨ. Ámɨná Jisaso Parisiowa arɨ́á e wíɨ́á eŋagɨ nánɨ nɨjɨ́á nimónɨrɨ ámɨ Gariri pɨropenɨsɨ́yo nánɨ umɨnɨrɨ nánɨ Judia pɨropenɨsɨ́yo pɨ́nɨ nɨwiárɨmɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","“Aga Samariayɨ́ aŋɨ́ tɨ́ŋimanɨ oumɨnɨ.” nɨyaiwimo imanɨ nurɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samariayɨ́ aŋɨ́ bɨ xegɨ́ yoɨ́ Saikaɨ rɨnɨŋɨ́pɨ —Aŋɨ́ apɨ xwɨ́á eŋíná Jekopo xewaxo Josepomɨ wiŋɨ́pɨ tɨ́ŋɨ́ e aŋwɨ erɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mínɨŋwɨ́ Jekopo iniɨgɨ́ iwinɨ́a nánɨ rɨpɨŋɨ́wá erɨnɨ. Aŋɨ́ apɨ tɨ́e nɨrémómáná sogwɨ́ áwɨnɨ e ŋweaŋáná aŋɨ́ éɨ́ nánɨ eŋɨ́ samɨŋɨ́ uwéagɨ iniɨgɨ́ nánɨ mínɨŋwɨ́ rɨpɨnɨŋɨ́wá tɨ́ŋɨ́ e sá nɨŋwearɨ ");
INSERT INTO aak_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","wiepɨsarɨŋowa aiwá bɨ́ yanɨro nánɨ aŋɨ́ apimɨ nánɨ rɨxa numáná eŋáná Samariayɨ́ apɨxɨ́ wí iniɨgɨ́ iwimɨnɨrɨ barɨŋagɨ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Iniɨgɨ́ iwíɨ́pɨ bɨ onɨmɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","í re urɨŋɨnigɨnɨ, “Arɨge simónɨ́agɨ joxɨ ‘Iniɨgɨ́ bɨ niapeɨ.’ nɨrarɨŋɨnɨ? Joxɨ Judayɨ́ woxɨrɨnɨ. Niínɨ Samariayɨ́ apɨxɨ́ wínɨ eŋagɨ nánɨ rɨrarɨŋɨnɨ.” —Judayɨ́ Samariayɨ́ tɨ́nɨ wí kumɨxɨnarɨgɨ́á meŋagɨ nánɨ í e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisaso re urɨŋɨnigɨnɨ, “Jíxɨ Gorɨxo ámáyo anɨ́á wiarɨŋɨ́pɨ nánɨ nɨjɨ́á imónɨrɨ nionɨ ‘Iniɨgɨ́ bɨ niapeɨ.’ rɨrɨ́áonɨ nánɨ nɨjɨ́á imónɨrɨ nerɨ sɨŋwɨrɨyɨ́, jíxɨ yarɨŋɨ́ níáná nionɨ iniɨgɨ́ dɨŋɨ́ sɨŋɨ́ sieweapaxɨ́ imónɨŋɨ́ bɨ siapɨmɨnɨrɨ éárɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","í re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, iniɨgɨ́ ayɨ́ ná mɨ́mɨ rɨwonɨ. Iniɨgɨ́ iwirɨ nánɨ enɨ mɨmaxɨrɨŋagɨ nánɨ iniɨgɨ́ iwirɨ mimónɨŋɨnɨ. Ayɨnánɨ joxɨ iniɨgɨ́ dɨŋɨ́ sɨŋɨ́ eweapaxɨ́ imónɨŋɨ́pɨ ge iwirɨ́ɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Joxɨ ‘Negɨ́ arɨ́o Jekopomɨ —O mínɨŋwɨ́ rɨwá nɨrɨpɨrɨ iniɨgɨ́ xewanɨŋo nɨrɨ xewaxowa nɨro xegɨ́ sipɨsipɨ́ burɨmákaú amɨpí nɨro eŋorɨnɨ. Omɨ ananɨ wiárɨ́ múroŋáonɨrɨnɨ.’ rɨyaiwinarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisaso re urɨŋɨnigɨnɨ, “Ámá iniɨgɨ́ rɨwámɨ nɨ́á gɨyɨ́ gɨyɨ́ nɨ́nɨ ámɨ iniɨgɨ́ nánɨ winayinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","E nerɨ aiwɨ ámá iniɨgɨ́ nionɨ wíápɨ nɨ́á gɨyɨ́ gɨyɨ́ ámɨ iniɨgɨ́ nánɨ winayinɨ́á menɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Iniɨgɨ́ nionɨ mɨnɨ wíápɨ ámá xwioxɨ́yo iniɨgɨ́ sɨmɨŋɨ́ meaarɨŋe dánɨ úrúrɨmɨ́ yarɨŋɨ́pánɨŋɨ́ nimónɨrɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ íníná ŋweapɨ́rɨ́a nánɨ wimɨxɨnɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","apɨxí re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, niínɨ ámɨ gwɨ́nɨ́ yeáyɨ́ mɨnipa oenɨrɨ iniɨgɨ́ joxɨ rarɨŋɨ́pɨ niapeɨ. Iniɨgɨ́ iwimɨnɨrɨ mɨbɨpa emɨ́a nánɨ enɨ niapeɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","o re urɨŋɨnigɨnɨ, “Jíxɨ nurɨ dɨxɨ́ oxomɨ nɨwirɨmeámɨ re nánɨ bɨ́piyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","apɨxí re urɨŋɨnigɨnɨ, “Oxɨ́ mayínɨrɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Jíxɨ ‘Oxɨ́ mayínɨrɨnɨ.’ nɨrarɨŋɨ́pɨ xɨxenɨ nɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ayɨ́ rɨpɨ nánɨrɨnɨ. Jíxɨ oxɨ́ wé bɨ nɨpɨnɨ rɨmeagɨ́íxɨrɨnɨ. Jíxɨ ámá agwɨ meánɨŋo dɨxɨ́ oxo meŋagɨ nánɨ xɨxenɨ nepa nɨrarɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","apɨxí re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ‘Joxɨ e nɨrarɨŋagɨ nánɨ wɨ́á rókiamoarɨgɨ́á woxɨrɨ́anɨ?’ nimónarɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","re urɨŋɨnigɨnɨ, “Eŋíná negɨ́ arɨ́owa Gorɨxomɨ yarɨŋɨ́ wiro yayɨ́ wiro yanɨro nánɨ dɨ́wɨ́ rɨpimɨ nánɨ bagɨ́árɨnɨ. E nerɨ aiwɨ Judayɨ́né re rarɨgɨ́árɨnɨ, ‘Wí e marɨ́áɨ, sa Jerusaremɨ dánɨnɨ yayɨ́ nɨwirɨ́ná ayɨ́ apánɨ yarɨŋoɨ.’ rarɨgɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisaso re urɨŋɨnigɨnɨ, “Ineyɨ, píránɨŋɨ́ arɨ́á niɨ. Sɨ́á wɨyi dɨ́wɨ́ rɨpimɨ dánɨranɨ, Jerusaremɨ dánɨranɨ, ápo Gorɨxomɨ yayɨ́ mɨwipɨ́rɨ́a nánɨ parɨmonɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Seyɨ́né yayɨ́ wiarɨgɨ́o arɨgénɨŋɨ́ imónɨŋɨ́pɨ nánɨ majɨ́á imónɨŋoɨ. E nerɨ aiwɨ yayɨ́ wiarɨŋwáo arɨgénɨŋɨ́ imónɨŋɨ́pɨ nánɨ Judayene nɨjɨ́árɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Gorɨxo ámáyo yeáyɨ́ uyimɨxemeámɨnɨrɨ yarɨŋɨ́pɨ gwɨ́ Judayene imónɨŋwárímɨ dánɨ yarɨŋɨ́ eŋagɨ nánɨ o, yayɨ́ wiarɨŋwáo nene nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","E nɨrɨrɨrɨ aiwɨ sɨ́á ámá e nero yayɨ́ níɨ́rɨxɨnɨrɨ wimónarɨŋɨ́pɨ tɨ́nɨ xɨxenɨ wiarɨgɨ́áyɨ́ ápo Gorɨxomɨ xegɨ́ kwíyɨ́yo dánɨ yayɨ́ wiro xɨxenɨ xɨ́o imónɨŋɨ́pɨ nánɨ dɨŋɨ́ nɨmoro yayɨ́ wiro wipɨ́rɨ́yi rɨxa aŋwɨ e nerɨ rɨxa parɨmoŋoɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Ámá xɨ́o nánɨ e nero yarɨgɨ́áyɨ́ nionɨ gɨ́ yayɨ́ niarɨgɨ́áyɨ́ imónɨ́ɨ́rɨxɨnɨrɨ wimónarɨŋɨ́ eŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gorɨxo kwíyɨ́nɨ eŋorɨnɨ. Ayɨnánɨ omɨ yayɨ́ wiarɨgɨ́áyɨ́ xegɨ́ bɨ epaxɨ́manɨ. Sa kwíyɨ́yo dánɨ yayɨ́ wiro xɨxenɨ xɨ́o imónɨŋɨ́pɨ nánɨ nepa dɨŋɨ́ nɨmoro yayɨ́ wiro epaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","apɨxí re urɨŋɨnigɨnɨ, “Mesaiao —Ámá Gorɨxo yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨnɨ. O ámá nimónɨrɨ bɨnɨ́ápɨ nánɨ niínɨ nɨjɨ́árɨnɨ. O nɨbɨrɨ́ná amɨpí nɨ́nɨ áwaŋɨ́ nearɨnɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisaso re urɨŋɨnigɨnɨ, “Oyɨ, jíxɨ tɨ́nɨ xwɨyɨ́á rɨnarɨgwɨ́í ronɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","E urarɨ́ná xegɨ́ wiepɨsarɨŋowa, aŋɨ́ jɨ́apimɨ nánɨ úɨ́áwa ámɨ nɨbɨro wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Apɨxɨ́ wí tɨ́nɨ xwɨyɨ́á rɨnarɨŋagɨ́i nɨwɨnɨro ududɨ́ nero aiwɨ wo nɨwiápɨ́nɨmearɨ xwɨyɨ́á bɨ re murɨŋɨnigɨnɨ, “Joxɨ pí urápɨmɨnɨrɨ urarɨŋɨnɨ? Pí nánɨ í tɨ́nɨ xwɨyɨ́á rɨnarɨŋiɨ?” murɨpa éáná ");
INSERT INTO aak_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","apɨxí xwárɨ́á sɨxɨ́ e nɨtɨmí aŋɨ́ jɨ́apimɨ nánɨ nurɨ ámáyo re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ámá niínɨ eŋíná dánɨ néra bɨŋápɨ nɨpɨnɨ nánɨ áwaŋɨ́ nɨrarɨŋomɨ nurane sɨŋwɨ́ owɨnaneyɨ. O Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo menɨranɨ?” urémeááná ");
INSERT INTO aak_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ayɨ́ aŋɨ́pimɨ pɨ́nɨ nɨwiárɨmɨ Jisasomɨ sɨŋwɨ́ wɨnɨ́e nánɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wiepɨsarɨŋowa apɨxí ámáyo wirɨmeámɨnɨrɨ úáná “Nearéwapɨyarɨŋoxɨnɨ, aiwá bɨ neɨ.” urarɨŋagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","o re urɨŋɨnigɨnɨ, “Aiwá nɨmɨ nánɨ soyɨ́né majɨ́ápɨ tɨ́ŋáonɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","wiepɨsarɨŋowa nepa aiwá nánɨ neararɨnɨrɨ re rɨnɨgɨ́awixɨnɨ, “None jɨ́amɨ úáná ámá wo nɨbɨrɨ aiwá nɨnɨ nánɨ mɨnɨ rɨ́a wiŋoɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ nɨrowárénapɨŋo e éwɨnɨgɨnɨrɨ wimónarɨŋɨ́pɨ erɨ xɨ́o ‘Joxɨ e éɨrɨxɨnɨ.’ nɨrɨŋɨ́pɨ xɨxenɨ yárɨrɨ nerɨ́náyɨ́, ayɨ́ gɨ́ aiwánɨŋɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Seyɨ́né ewayɨ́ xwɨyɨ́á rɨpɨ mɨrɨpa yarɨgɨ́árɨnɨ, ‘Emá waú waú sɨnɨrɨnɨ. Rɨxa múróáná aiwá mianɨ́wárɨnɨ.’ mɨrɨpa yarɨgɨ́áranɨ? Seyɨ́né e nɨrɨro aiwɨ nionɨ re seararɨŋɨnɨ, ‘Nɨwiápɨ́nɨmearo omɨŋɨ́yo mɨnɨ mɨnɨ wenɨŋɨ́ emiamópoyɨ. Aiwá rɨxa yóɨ́ nerɨ mipaxɨ́ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Agwɨ aiwá miarɨŋɨ́ go go omɨŋɨ́ nerɨ́ná xegɨ́ éɨ́pɨ nánɨ nɨgwɨ́ nɨmearɨ ayɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨpɨ́rɨ́a nánɨ rɨxa yarɨnɨ. Aiwá ɨwɨ́á urarɨŋo tɨ́nɨ miarɨŋo tɨ́nɨ nawínɨ nɨwaúnɨ yayɨ́ epɨsi nánɨ e yarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Xwɨyɨ́á seyɨ́né re rarɨgɨ́ápɨ, ‘Wo ɨwɨ́á urɨrɨ wo mirɨ yarɨgɨ́árɨnɨ.’ rarɨgɨ́ápɨ, ayɨ́ nionɨ rɨrɨ́ápɨ tɨ́nɨ xɨxenɨ rɨnɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nionɨ gɨ́ seaiepɨsarɨŋáoyɨ́né, aiwá soyɨ́né ɨwɨ́á murɨgɨ́ápɨ mipɨ́rɨ nánɨ searowárɨŋárɨnɨ. Soyɨ́né aiwá wa ɨwɨ́á urɨgɨ́ápɨ nɨmiróná awa anɨŋɨ́ minɨ́ egɨ́ápɨ miarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariayɨ́, aŋɨ́ jɨ́apimɨ dáŋɨ́yɨ́ apɨxí áwaŋɨ́ re urɨ́agɨ “Ámáo niínɨ eŋíná dánɨ néra bɨŋápɨ nɨpɨnɨ nánɨ áwaŋɨ́ nɨrɨŋoɨ.” urɨ́ɨ́ eŋagɨ nánɨ obaxɨ́ o nánɨ dɨŋɨ́ nɨwɨkwɨ́roro nánɨ ");
INSERT INTO aak_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","nɨbɨro nɨwímearóná nene tɨ́nɨ oŋweaaneyɨnɨro yarɨŋɨ́ wíagɨ́a o sɨ́á wɨyaú e weŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ámá obaxɨ́ wínɨ wínɨ enɨ xwɨyɨ́á o rarɨŋɨ́pɨ arɨ́á nɨwiro nánɨ dɨŋɨ́ nɨwɨkwɨ́roro ");
INSERT INTO aak_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","apɨxímɨ re nura ugɨ́awixɨnɨ, “Jíxɨ nearɨ́ɨ́pɨ arɨ́á nɨwirane nánɨnɨ omɨ dɨŋɨ́ mɨwɨkwɨ́roarɨŋwɨnɨ. Newanɨŋene enɨ o xwɨyɨ́á rarɨŋagɨ arɨ́á nɨwirane rɨxa nɨjɨ́á nimónɨrɨ re yaiwiarɨŋwɨnɨ, ‘Ámá nɨyonɨ yeáyɨ́ uyimɨxemeámɨ́ánɨrɨ bɨŋorɨ́anɨ?’ yaiwiarɨŋwɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sɨ́á wɨyaú weŋo aŋɨ́ apimɨ pɨ́nɨ nɨwiárɨmɨ Gariri pɨropenɨsɨ́yo nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisaso xewanɨŋo re rɨŋo eŋagɨ nánɨ, “Wɨ́á rókiamoarɨŋɨ́ gomɨ ámá xegɨ́ aŋɨ́ e dáŋɨ́yɨ́ wé íkwiaŋwɨ́yo uŋwɨrárɨgɨ́áranɨ? Oweoɨ.” rɨŋo eŋagɨ nánɨ ámɨ Gariri pɨropenɨsɨ́yo nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ayɨnánɨ Gariri pɨropenɨsɨ́yo rémóáná Gariri ŋweáyɨ́ enɨ aiwá sɨ́á Aŋɨ́najo Múroagɨ́yi nánɨ Jerusaremɨyo nánɨ nɨyiro nɨŋwearóná amɨpí xɨ́o yarɨŋɨ́pɨ wɨnɨgɨ́á eŋagɨ nánɨ wigɨ́ aŋɨ́yo rémóáná umímɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisaso Gariri pɨropenɨsɨ́yo aŋɨ́ Kenaɨ rɨnɨŋe —E xámɨ aga iniɨgɨ́ aí wainɨ́ imɨxɨŋɨ́ erɨnɨ. E nɨrémorɨ ŋweaŋáná gapɨmanɨ́ wo xegɨ́ íwo sɨmɨxɨ́ nerɨ aŋɨ́ yoɨ́ Kapaneamɨyo ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","xano arɨ́á re wiŋɨnigɨnɨ, “Jisaso Judia pɨropenɨsɨ́yo pɨ́nɨ nɨwiárɨmɨ nɨbɨrɨ Gariri pɨropenɨsɨ́ tɨyómɨnɨ rémónapɨŋoɨ.” rarɨŋagɨ́a arɨ́á e nɨwirɨ Jisaso tɨ́ŋɨ́ e nánɨ nɨyapɨrɨ xegɨ́ niaíwo rɨxa nɨpémɨnɨrɨ aŋwɨ ayo eŋagɨ nánɨ o nɨweapɨrɨ gɨ́ íwomɨ naŋɨ́ oimɨxɨnɨrɨ yarɨŋɨ́ wíagɨ ");
INSERT INTO aak_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisaso re urɨŋɨnigɨnɨ, “Seyɨ́né nionɨ emɨmɨ́ mepa erɨ amɨpí ayá rɨwamónɨpaxɨ́ mepa erɨ yarɨŋagɨ nɨnanɨrɨ́náyɨ́, wí dɨŋɨ́ nɨkwɨ́ropɨ́rɨméoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","gapɨmano re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, gɨ́ íwo penɨgɨnɨrɨ joxɨ aŋɨ́nɨ weapeɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisaso re urɨŋɨnigɨnɨ, “Dɨxɨ́ aŋɨ́ uɨ. Dɨxɨ́ íwo sɨŋɨ́ unɨŋoɨ.” urɨ́agɨ o xwɨyɨ́á Jisaso urɨ́ɨ́pɨ “Neparɨnɨ.” nɨyaiwirɨ dɨŋɨ́ nɨkwɨ́rorɨ xegɨ́ aŋɨ́ e nánɨ nurɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","óɨ́ e sá weŋo wɨ́ápɨ tɨ́nɨ sɨnɨ óɨ́yo warɨ́ná xegɨ́ xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áwa óɨ́ e órórɨ́ ninɨro re urɨgɨ́awixɨnɨ, “Dɨxɨ́ íwo rɨxa sɨŋɨ́ úɨnigɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","o yarɨŋɨ́ re wiŋɨnigɨnɨ, “Gíná naŋɨ́ imónɨ́ɨnigɨnɨ?” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “Agíná 1:00 p.m. imónáná wará rɨ́á pɨrɨ́ pɨ́nɨ wiárɨ́ɨnigɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","xano re yaiwiŋɨnigɨnɨ, “Agíná Jisaso ‘Dɨxɨ́ íwo sɨŋɨ́ unɨŋoɨ.’ nɨrɨ́íná sɨmɨxɨ́ pɨ́nɨ wiárɨ́árɨ́anɨ?” nɨyaiwirɨ xɨ́omɨ dɨŋɨ́ nɨwɨkwɨ́rorɨ xegɨ́ ɨ́wiaxé enɨ dɨŋɨ́ wɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisaso Judia pɨropenɨsɨ́yo pɨ́nɨ nɨwiárɨmɨ ámɨ Gariri pɨropenɨsɨ́yo nemerɨ́ná emɨmɨ́ ámɨ bɨ apɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jisaso e nemo nɨŋweaŋɨsáná Judayɨ́ wigɨ́ yarɨgɨ́ápa Gorɨxo nánɨ dɨŋɨ́ moanɨro aiwá Jerusaremɨyo imɨxarɨ́ná o e nánɨ nɨyoarɨ nɨrémómáná ");
INSERT INTO aak_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","—Jerusaremɨyo ákɨŋá ɨ́wí wɨyi Sipɨsipɨ́yɨ rɨnɨŋɨ́yi tɨ́ŋɨ́ e ipí wá Xibɨruyɨ́ pɨ́né tɨ́nɨ xegɨ́ yoɨ́ Betesaidaɨ rɨnɨŋɨ́wá e rɨwoŋɨ́wárɨnɨ. Mɨdɨmɨdánɨ rɨ́wɨ́yi nánɨ aŋɨ́ wiámɨ́ó wé wú mɨrɨnɨŋerɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aŋɨ́ wiámɨ́ó wé bɨ apɨ mɨrɨnɨŋe ámá sɨmɨxɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ sɨŋwɨ́ supárɨgɨ́áyɨ́ tɨ́nɨ sɨkwɨ́ ikɨ́ egɨ́áyɨ́ tɨ́nɨ sɨkwɨ́ wé kɨrɨŋɨ́ egɨ́áyɨ́ tɨ́nɨ ayɨ́ obaxɨ́ e nɨŋwearo iniɨgɨ́ yaromí éɨ́pɨ sɨŋwɨ́ owɨnaneyɨnɨrɨ ŋweaarɨgɨ́erɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Waínɨ́ waíná aŋɨ́najɨ́ Gorɨxoyá wo nɨwerɨ ipíwámɨ yaromí méáná ámá sɨmɨxɨ́ tɨ́gɨ́áyɨ́ go go xámɨ páwíáná xegɨ́ wará naŋɨ́ imónarɨŋɨ́ eŋagɨ nánɨ ŋweaarɨgɨ́erɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jisaso e nɨrémorɨ ámá e ŋweaarɨgɨ́áyɨ́ wo —O xegɨ́ sɨmɨxɨ́pɨ yarɨ́ná xwiogwɨ́ 38 múroŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","O e weŋagɨ sɨŋwɨ́ nɨwɨnɨrɨ “Sɨmɨxɨ́ eŋíná dánɨ néra bɨŋorɨ́anɨ?” nɨyaiwirɨ nɨjɨ́á e nimónɨrɨ nánɨ re urɨŋɨnigɨnɨ, “Joxɨ ‘Naŋɨ́ oimónɨmɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","sɨmɨxo re urɨŋɨnigɨnɨ, “Ámá roxɨnɨ, ipíwá yaromí éáná ámá ipíyo nɨnɨmearɨ nɨwárɨpɨ́rɨ nánɨ mayonɨrɨnɨ. Niɨwanɨŋonɨ nɨwiápɨ́nɨmeámɨ nurɨ páwimɨnɨrɨ yarɨ́ná ámá wa xámɨ páwiarɨgɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisaso re urɨŋɨnigɨnɨ, “Nɨwiápɨ́nɨmearɨ dɨxɨ́ íkwiaŋwɨ́ nɨxoperɨ nɨmeámɨ uɨ.” uráná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naŋɨ́ nimónɨrɨ xegɨ́ íkwiaŋwɨ́ nɨmeámɨ aŋɨ́ uŋɨnigɨnɨ. Sɨ́á ayi Sabarɨ́á ayimɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ayɨnánɨ Judayɨ́ ámɨnáowa naŋɨ́ imónɨ́omɨ re urɨgɨ́awixɨnɨ, “Sabarɨ́áyimɨ eŋagɨ nánɨ dɨxɨ́ íkwiaŋwɨ́ xe nɨmeámɨ ounɨrɨ sɨŋwɨ́ ranɨpaxɨ́ mimónɨŋwɨnɨ. Ŋwɨ́árɨnɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","o re urɨŋɨnigɨnɨ, “Ámá nionɨ naŋɨ́ nimɨxɨ́o, o ‘Dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ uɨ.’ nɨrɨ́agɨ nɨmeámɨ warɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","awa yarɨŋɨ́ re wigɨ́awixɨnɨ, “‘Dɨxɨ́ íkwiaŋwɨ́ nɨmeámɨ uɨ.’ go rɨrɨŋoɨ?” yarɨŋɨ́ e wíagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ámá o xɨ́omɨ naŋɨ́ wimɨxɨ́o nánɨ nɨjɨ́á mimónɨpa nerɨ nánɨ áwaŋɨ́ urɨpaxɨ́ mimónɨŋɨnigɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Jisaso ámá e epɨ́royɨ́ egɨ́áyo áwɨnɨmɨ dakwíagɨ nánɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","E nemáná eŋáná Jisaso ámá o aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ roŋagɨ nɨwɨnɨrɨ re urɨŋɨnigɨnɨ, “Arɨ́á niɨ. Sɨmɨxɨ́ joxɨ yarɨŋɨ́pɨ rɨxa naŋɨ́ imónɨ́ɨnigɨnɨ. ‘Xámɨ síɨ́pimɨ ámɨ bɨ wiárɨ́ múrónɨŋɨ́pɨ sinɨgɨnɨrɨ nánɨ ɨ́wɨ́ ámɨ mepa éɨrɨxɨnɨ.’ rɨrarɨŋɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","o nurɨ Judayɨ́ ámɨnáowamɨ Jisaso nánɨ re urɨŋɨnigɨnɨ, “Naŋɨ́ nimɨxɨ́o, ayɨ́ orɨnɨ.” urɨ́agɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisaso Sabarɨ́áyo omɨ naŋɨ́ wimɨxɨ́ɨ́ eŋagɨ nánɨ awa “Rɨrɨxɨniɨ́ wikárɨ́wanɨgɨnɨ.” nɨyaiwiro iwamɨ́ó e wianɨro egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E wianɨro éagɨ́a aiwɨ Jisaso re urɨŋɨnigɨnɨ, “Amɨpí gɨ́ ápo bɨ pɨ́nɨ mɨwiárɨ́ anɨŋɨ́ minɨ́ néra bɨŋɨ́pɨ nionɨ enɨ axɨ́pɨ e nerɨ ámáyo arɨrá wiarɨŋɨnɨ.” urɨ́agɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Judayɨ́ ámɨnáowa rɨxa mekaxɨ́ nɨmero “Omɨ pɨkíwanɨgɨnɨ.” rɨnɨgɨ́awixɨnɨ. O “Sabarɨ́áyo ŋwɨ́árɨnɨ.” rɨnɨŋɨ́pɨ nɨwiaíkirɨ éɨ́yɨ́ nánɨnɨ marɨ́áɨ, xewanɨŋo Gorɨxo nánɨ “Gɨ́ áporɨnɨ.” nɨrɨrɨ́ná ayɨ́ rénɨŋɨ́ rɨ́ɨ́yɨ́, “Nionɨ Gorɨxo tɨ́nɨ xɨxenɨ imónɨŋɨnɨ.” énɨŋɨ́ rɨ́ɨ́yɨ́ nánɨ enɨ e rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ayɨnánɨ Jisaso nɨwiápɨ́nɨmearɨ “Xamɨŋonɨ bɨ osearɨmɨnɨ.” nurɨrɨ xewanɨŋo nánɨ re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Xewaxo xegɨ́ dɨŋɨ́yo dánɨ amɨpí wí epaxɨ́ menɨnɨ. Xano yarɨŋɨ́pimɨ sɨŋwɨ́ nɨwɨnɨrɨ apɨnɨ yarɨŋɨ́rɨnɨ. Pí pí xano yarɨŋɨ́pɨ xewaxo enɨ axɨ́pɨ e yarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Xano xewaxomɨ dɨŋɨ́ sɨxɨ́ nuyirɨ amɨpí xɨ́o yarɨŋɨ́pɨ sɨwá wiarɨŋɨ́rɨnɨ. Soyɨ́né ududɨ́ epɨ́rɨ́a nánɨ emɨmɨ́ xewaxo agwɨ yarɨŋɨ́pimɨ seáyɨ e imónɨŋɨ́ bɨ éwɨnɨgɨnɨrɨ wiepɨsinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Xano ámá pɨyɨ́yo ámɨ sɨŋɨ́ nimɨxɨrɨ dɨŋɨ́ sɨxɨ́ umímoarɨŋɨ́pa xewaxo enɨ xɨ́o xegɨ́ dɨŋɨ́yo dánɨ ámá xɨ́o wimónarɨŋɨ́yo ananɨ dɨŋɨ́ sɨxɨ́ umímoarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Rɨpɨ enɨ xano ámá womɨ xwɨyɨ́á umeararɨŋɨ́manɨ. Xewaxo ámá nɨyonɨ xwɨyɨ́á mearɨ́wɨnɨgɨnɨrɨ wiŋɨ́ eŋagɨ nánɨ onɨ xwɨyɨ́á meararɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ámá nɨ́nɨ xanomɨ wé íkwiaŋwɨ́yo uŋwɨrárarɨgɨ́ápa xewaxomɨ enɨ axɨ́pɨ e éɨ́rɨxɨnɨrɨ ámá nɨyonɨ xwɨyɨ́á mearɨ́wɨnɨgɨnɨrɨ mɨnɨ wiŋɨ́rɨnɨ. Ámá xewaxomɨ wé íkwiaŋwɨ́yo muŋwɨrárɨpa yarɨgɨ́áyɨ́ xano, urowárénapɨŋomɨ enɨ wé íkwiaŋwɨ́yo muŋwɨrárarɨgɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Ámá xwɨyɨ́á nionɨ rarɨŋápɨ arɨ́á niro nionɨ nɨrowárénapɨŋomɨ dɨŋɨ́ wɨkwɨ́roro éɨ́á gɨyɨ́ gɨyɨ́ rɨxa dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́rɨnɨ. Wí xwɨyɨ́á meárɨnɨpɨ́rɨ́a nánɨ mimónɨŋoɨ. Sɨnɨ óɨ́ pearɨgɨ́áyímɨnɨ mɨwarɨŋoɨ. Dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́ íníná ŋweapɨ́rɨ́áyímɨnɨ warɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Sɨ́á ámá pɨyɨ́nɨŋɨ́ imónɨgɨ́áyɨ́ maŋɨ́ Gorɨxomɨ xewaxoyá arɨ́á nɨwiro xɨ́dɨpɨ́rɨ́yi rɨxa aŋwɨ e nerɨ rɨxa parɨmoŋoɨ. Ámá arɨ́á nɨwiro xɨxenɨ éɨ́áyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ íníná ŋweapɨ́rɨ́a nánɨ meapɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ayɨ́ rɨpɨ nánɨrɨnɨ. Xano dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ mɨ́kɨ́ tɨ́ŋo nimónɨrɨ ámá xɨ́o wimónarɨŋɨ́yo wiarɨŋɨ́pa xewaxo enɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ mɨ́kɨ́ tɨ́ŋo oimónɨrɨ wiŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rɨpɨ enɨ xewaxo ámá imónɨŋo eŋagɨ nánɨ ananɨ ámá nɨyonɨ mí ómómɨxɨmɨ́ winɨ́a nánɨ enɨ imónɨ́wɨnɨgɨnɨrɨ ɨ́ánɨŋɨ́ wiepɨ́xɨ́niasiŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nionɨ searɨ́ápɨ nánɨ dɨŋɨ́ ududɨ́ mɨseainɨpanɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Sɨ́á ámá xwárɨpáyo wegɨ́á nɨ́nɨyɨ́ xewaxoyá maŋɨ́ ráná arɨ́á nɨwiro wiápɨ́nɨmeapɨ́rɨ́áyi aŋwɨ e nimóga barɨŋagɨ nánɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Arɨ́á nɨwiro xwárɨpáyo dánɨ nɨwiápɨ́nɨmearóná naŋɨ́ yarɨgɨ́áyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ íníná píránɨŋɨ́ ŋweapɨ́rɨ́a nánɨ mearo sɨpí yarɨgɨ́áyɨ́ xwɨyɨ́á meárɨnɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Niɨwanɨŋonɨ gɨ́ dɨŋɨ́yo dánɨ amɨpí wí epaxɨ́ mimónɨŋɨnɨ. Ápomɨ arɨ́á wiarɨŋápɨ tɨ́nɨ xɨxenɨ ámáyo xwɨyɨ́á umeararɨŋárɨnɨ. Nionɨ gɨ́ nimónarɨŋɨ́pɨ mɨxɨ́dɨpa nerɨ nɨrowárénapɨŋo wimónarɨŋɨ́pɨ nɨxɨ́dɨrɨ nánɨ ámáyo xwɨyɨ́á numearɨrɨ́ná xɨxenɨ ayo umeararɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ámɨ re urɨŋɨnigɨnɨ, “Soyɨ́né dɨŋɨ́ re niaiwiarɨŋagɨ́a aiwɨ, ‘Xewanɨŋo nánɨ áwaŋɨ́ nearáná “Neparɨnɨ.” wiaiwipaxɨ́ menɨnɨ.’ niaiwiarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ámɨ wo nionɨ nánɨ áwaŋɨ́ seararɨŋɨ́rɨnɨ. Nionɨ nánɨ nɨsearɨrɨ́ná ‘Ayɨ́ neparɨnɨ.’ yaiwipaxɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","re urɨŋɨnigɨnɨ, “Xámɨ segɨ́ wamɨ wayɨ́ neameaiŋɨ́ Jono tɨ́ŋɨ́mɨnɨ urowáráná o nionɨ nánɨ áwaŋɨ́ nɨsearɨrɨ́ná nepaxɨŋɨ́ imónɨŋɨ́pɨ tɨ́nɨ xɨxenɨ searɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Soyɨ́né re rɨseaimónarɨnɨ, ‘Xewanɨŋo nánɨ áwaŋɨ́ rɨnarɨŋɨ́pɨ aga ámá wí rarɨgɨ́ápimɨ dánɨ sopɨŋɨ́ ononɨrɨ rarɨnɨ.’ rɨseaimónarɨnɨ? Oweoɨ, seyɨ́né Gorɨxo yeáyɨ́ seayimɨxemeanɨ́a nánɨ wayɨ́ neameaiŋɨ́ Jono nionɨ nánɨ searɨŋɨ́pɨ mɨŋɨ́ nirorɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O uyɨ́wɨ́ ápiáwɨ́ wearɨŋɨ́pánɨŋɨ́ nerɨ ámáyo wɨ́á ókímɨxarɨ́ná soyɨ́né xegɨ́ xwɨyɨ́á uyɨ́wɨ́ wɨ́ánɨŋɨ́ imónɨŋáná yayɨ́ axínánɨ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","O nionɨ nánɨ áwaŋɨ́ nɨsearɨ́agɨ aiwɨ nionɨ nánɨ áwaŋɨ́nɨŋɨ́ searɨpaxɨ́ imónɨŋɨ́ bɨ omɨ seáyɨ e wimónɨnɨ. Emɨmɨ́ amɨpí gɨ́ ápo e epaxɨ́ imónɨ́wɨnɨgɨnɨrɨ niapɨŋɨ́pɨ nánɨ rarɨŋɨnɨ. Nionɨ emɨmɨ́ nɨseairɨ́ná apɨ nionɨ nánɨ áwaŋɨ́ rénɨŋɨ́ seararɨŋɨ́rɨnɨ, ‘Xegɨ́ xano urowárénapɨŋorɨnɨ.’ énɨŋɨ́ seararɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Gɨ́ ápo, nionɨ nɨrowárénapɨŋo enɨ nionɨ nánɨ rɨxa áwaŋɨ́ searɨŋɨ́rɨnɨ. Omɨ soyɨ́né arɨ́á bɨ wiro xɨ́o imónɨŋɨ́pɨ sɨŋwɨ́ bɨ wɨnɨro megɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Xwɨyɨ́á xɨ́o searɨŋɨ́yɨ́ segɨ́ xwioxɨ́yo mɨwenɨnɨ. Ayɨnánɨ ámá o nɨrowárénapɨŋonɨ dɨŋɨ́ mɨnɨkwɨ́roŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Soyɨ́né dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ meáwanɨgɨnɨro Gorɨxoyá Bɨkwɨ́yo ɨ́á roro parɨro yarɨgɨ́árɨnɨ. Rɨ́wamɨŋɨ́ ayo nɨrɨnɨrɨ eánɨŋɨ́pɨ nionɨ nánɨ áwaŋɨ́ rɨnɨŋagɨ aí ");
INSERT INTO aak_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","soyɨ́né dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́ imónɨpɨ́rɨ́a nánɨ nionɨ tɨ́ámɨnɨ mɨbɨpaxɨ́ seaimónarɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","re urɨŋɨnigɨnɨ, “Nionɨ ámá weyɨ́ nɨméɨ́rɨxɨnɨrɨ bɨŋáonɨ meŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","nionɨ soyɨ́né nánɨ nɨjɨ́árɨnɨ. Soyɨ́né Gorɨxomɨ dɨŋɨ́ sɨxɨ́ uyarɨgɨ́oyɨ́némanɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nionɨ gɨ́ dɨŋɨ́yo dánɨ bɨŋáonɨmanɨ. Gɨ́ ápo nɨnɨrɨ́pearɨ nɨrowárénapɨŋonɨ aiwɨ soyɨ́né mɨnɨmímɨnarɨŋoɨ. Ámá wo xɨ́o xegɨ́ dɨŋɨ́yo dánɨ bánáyɨ́, ananɨ numímɨnɨpaxoyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Soyɨ́né ámá weyɨ́ oneamépoyɨnɨrɨ ero Gorɨxo —Onɨ ŋwɨ́á imónɨŋorɨnɨ. O weyɨ́ oneamenɨrɨ xɨ́o wimónarɨŋɨ́pɨ mɨxɨ́dɨpa ero yarɨgɨ́oyɨ́né, soyɨ́né sɨnɨ e neróná arɨge nero dɨŋɨ́ nɨkwɨ́ropɨ́ráoɨ? Oweoɨ!” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","re urɨŋɨnigɨnɨ, “Nionɨ nánɨ re mɨniaiwipa époyɨ, ‘Xanoyá sɨŋwɨ́yo dánɨ nene xwɨyɨ́á neaxekwɨ́monɨ́árɨnɨ.’ mɨniaiwipa époyɨ. Ámá seyɨ́né seaxekwɨ́monɨ́o, ayɨ́ Mosesorɨnɨ. Soyɨ́né omɨ dɨŋɨ́ nɨwikwɨ́móa nuro re yaiwiarɨgɨ́árɨnɨ, ‘O arɨrá neainɨ́árɨnɨ.’ yaiwiarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Amɨpí Moseso nɨrɨrɨ eaŋɨ́pɨ dɨŋɨ́ nɨkwɨ́roro sɨŋwɨrɨyɨ́, nionɨ nánɨ nɨrɨrɨ eaŋɨ́ eŋagɨ nánɨ nionɨ enɨ dɨŋɨ́ nɨkwɨ́roanɨro egɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","E nerɨ aí xɨ́o nɨrɨrɨ eaŋɨ́pɨ nánɨ dɨŋɨ́ mɨkwɨ́ropa yarɨgɨ́oyɨ́né, soyɨ́né arɨge nero xwɨyɨ́á nionɨyápɨ enɨ dɨŋɨ́ ɨkwɨ́ropɨ́ráoɨ? Oweoɨ wí e epaxɨ́ menɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisaso e nurárɨmo neméɨsáná ipí Gariri rɨnɨŋɨ́wámɨ —Ipí awá xegɨ́ yoɨ́ ámɨ bɨ Taibiriasɨyɨ rɨnɨŋɨ́wárɨnɨ. Awámɨ jɨ́arɨwámɨ dánɨ nánɨ nurɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ámá obaxɨ́ emɨmɨ́ xɨ́o sɨmɨxɨ́ yarɨgɨ́áyo wiarɨŋɨ́pɨ sɨŋwɨ́ nɨwɨga nuro nánɨ epɨ́royɨ́ nero omɨ númɨ uxɨ́darɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","sɨ́á Judayɨ́ aiwá Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi nánɨ imɨxɨpɨ́rɨ rɨxa aŋwɨ e imónɨŋáná Jisaso dɨ́wɨ́yo nánɨ nɨyirɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ e éɨ́ nɨŋwearo ");
INSERT INTO aak_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Jisaso sɨŋwɨ́ anɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ámá aga ayá wí epɨ́royɨ́ nero xɨ́o tɨ́ámɨnɨ bɨmiarɨŋagɨ́a nɨwɨnɨrɨ xɨ́o enɨ́pɨ nánɨ nɨjɨ́á nimónɨrɨ aiwɨ re yaiwiŋɨnigɨnɨ, “Gɨ́ wiepɨsarɨŋá Piripo nepa eŋɨ́ neánɨrɨ dɨŋɨ́ rɨ́a nɨkwɨ́ronɨ? Iwamɨ́ó owíwapɨyimɨnɨ.” nɨyaiwirɨ re urɨŋɨnigɨnɨ, “Ámá tɨyɨ́ aiwá nɨpɨ́rɨ nánɨ ge bɨ́ nerɨ wianɨ́wɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piripo re urɨŋɨnigɨnɨ, “None aiwá óɨ́ inɨŋɨ́ 200 tɨ́nɨ bɨ́ nerane yaŋɨ́ nɨwiranénáyɨ́, ámá re epɨ́royɨ́ egɨ́áyɨ́ aga obaxɨ́ imónɨŋagɨ́a nánɨ wonɨ wonɨ bɨ onɨmiápɨ aí meapaxɨ́ imónɨnɨmenɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","wiepɨsarɨŋɨ́yɨ́ wo —O Saimonɨ Pitaomɨ xogwáo Adɨruoyɨ rɨnɨŋorɨnɨ. O re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Íwɨ́ woyá bisɨ́kerɨ́á pɨrawá barí tɨ́nɨ imɨxɨnɨŋɨ́ wé wú tɨ́nɨ peyɨ́ orá biaú tɨ́nɨ neŋagɨ aiwɨ ámá obaxɨ́ epɨ́royɨ́ egɨ́á tɨ́yo yaŋɨ́ wipaxɨ́ rimónɨnɨ? Oweoɨ!” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisaso ará xwapɨ́ eŋe nánɨ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámá nɨ́nɨ éɨ́ oŋweápoyɨnɨrɨ urɨ́poyɨ.” urɨ́agɨ wiepɨsarɨŋowa Jisaso urɨ́ɨ́pa éáná oxɨ́ nɨ́nɨ éɨ́ ŋweaŋáná ɨ́á róɨ́áyɨ́ 5,000 imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisaso ámá nɨ́nɨ éɨ́ ŋweáagɨ́a nɨwɨnɨrɨ bisɨ́kerɨ́á pɨrawá barí tɨ́nɨ imɨxɨnɨŋɨ́pɨ nɨmearɨ Gorɨxomɨ yayɨ́ nɨwimáná ámá e éɨ́ ŋweagɨ́áyo yaŋɨ́ nɨmerɨ nɨwia uŋɨnigɨnɨ. Peyɨ́ orápiaú enɨ nɨmearɨ axɨ́pɨ nerɨ́ná wigɨ́ onaneyɨnɨro wimónarɨŋɨ́pɨ tɨ́nɨ xɨxenɨ nɨwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rɨxa apánɨ nɨnɨro agwɨ́ ímɨ uyíagɨ nɨwɨnɨrɨ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Wí xwɨrɨ́á mikɨxepa oépoyɨnɨrɨ nɨnɨro tɨ́ápia awí eaamépoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","awa bisɨ́kerɨ́á pɨrawá barí tɨ́nɨ imɨxɨnɨŋɨ́ wé wú apɨ ámáyɨ́ nɨnɨro tɨ́ápia awí neaemero soxɨ́ ɨ́á xwé wé wúkaú sɨkwɨ́ waúmɨ aumaúmɨ́ nero magwɨ́ miárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ámáyɨ́ emɨmɨ́ Jisaso wíwapɨyíɨ́pɨ sɨŋwɨ́ nɨwɨnɨro nánɨ re rɨnɨgɨ́awixɨnɨ, “Neparɨnɨ. Wɨ́á rókiamoarɨŋɨ́ xwɨ́á tɨ́yo bɨnɨ́o orɨnɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisaso xɨ́omɨ mɨxɨ́ ináyɨ́ imɨxɨpɨ́rɨ nánɨ mɨwimónarɨŋagɨ aí ayɨ́ “Ɨ́á nuxerane mɨxɨ́ ináyo oimɨxaneyɨ.” yaiwiarɨŋagɨ́a dɨŋɨ́ adadɨ́ nɨwirɨ nɨjɨ́á nimónɨrɨ nánɨ ayo e nɨwárɨmɨ xegɨ́pɨ dɨ́wɨ́ mɨŋɨ́yo nánɨ yiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sɨ́ápɨ tɨ́nɨ xegɨ́ wiepɨsarɨŋowa ipí imaŋɨ́ e nánɨ nɨwero ");
INSERT INTO aak_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ewéyo nɨpɨxemoánɨro Kapaneamɨ nánɨ orɨwámɨ dánɨ xemoanɨro nánɨ nɨmeámɨ nuro rɨxa sɨ́á yinɨŋáná Jisaso awamɨ sɨnɨ mɨwímeáɨ́mɨ eŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rɨ́wɨpí xwé erɨ ipí imeamɨ́kwɨ́ erɨ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","wiepɨsarɨŋowa ewéyo nɨreaxa nuro sɨnɨ ipíyo áwɨnɨ e kiromita wé wúranɨ, wé wɨ́úmɨ dáŋɨ́ woranɨ, núɨ́asáná wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Jisaso ewé tɨ́ámɨnɨ ipíyo xwɨrɨŋwɨ́ nosaxa barɨŋagɨ wɨnɨgɨ́awixɨnɨ. Sɨŋwɨ́ e nɨwɨnɨro éɨ́ yarɨŋagɨ́a aí ");
INSERT INTO aak_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","o re urɨŋɨnigɨnɨ, “Ananɨre. Nionɨrɨnɨ. Wáyɨ́ mepanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","awa omɨ rɨxa “Re xemónapeɨ.” uranɨro yarɨ́ná re eŋɨnigɨnɨ. Rɨxa ipíyo jɨ́arɨwámɨnɨ aŋɨ́ wigɨ́ dɨŋɨ́ nɨyaiwiro warɨgɨ́e iwiékɨ́nɨmeagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ámá orɨwámɨ dánɨ bisɨ́kerɨ́á nɨ́e sá wegɨ́áyɨ́ wɨ́ápɨ tɨ́nɨ nɨwiápɨ́nɨmearo re yaiwigɨ́awixɨnɨ, “Agíná ewé ámɨ wí re mɨwé ná bánɨ weŋagɨ wɨnɨ́wanigɨnɨ. Nene sɨŋwɨ́ wɨnɨŋáná Jisaso xegɨ́ wiepɨsarɨŋowa tɨ́nɨ ewépámɨ mɨpɨxemoánarɨŋagɨ́a nɨwɨnɨrane wiepɨsarɨŋowanɨ nɨpɨxemoánɨro warɨŋagɨ́a wɨnowárɨ́wanigɨnɨ.” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ewé wí aŋɨ́ yoɨ́ Taibiriasɨ dánɨ bisɨ́kerɨ́á Ámɨnáo xegɨ́ xanomɨ yayɨ́ nɨwirɨ wíagɨ nɨ́e nánɨ báná ");
INSERT INTO aak_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ámá e epɨ́royɨ́ egɨ́áyɨ́ Jisaso sɨnɨ wigɨ́ tɨ́e mɨŋweaŋagɨ wɨnɨro wiepɨsarɨŋowa enɨ mɨŋweaŋagɨ́a wɨnɨro nerɨ nánɨ ewé bɨ́áyo nɨpɨxemoánɨro Jisaso nánɨ Kapaneamɨyo pɨ́á yanɨro ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ayɨ́ ipíyo jɨ́arɨwámɨnɨ Jisaso Kapaneamɨyo ŋweaŋáná nɨwímearo re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, joxɨ re nánɨ gíná bɨ́oxɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Seyɨ́né emɨmɨ́ nionɨ seaíwapɨyíápɨ sɨŋwɨ́ nɨwɨnɨróná sɨwánɨŋɨ́ nɨseairɨ seaíwapɨyimɨnɨrɨ éápɨ nánɨ nɨjɨ́á nimónɨro nánɨ nionɨ nánɨ pɨ́á rɨyarɨŋoɨ? Oweoɨ, seyɨ́né bisɨ́kerɨ́á nɨnɨróná agwɨ́ ímɨ seayíɨ́ eŋagɨ nánɨ nionɨ nánɨ pɨ́á yarɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Aiwá pɨyɨ́ pénarɨŋɨ́pɨ meaanɨro nánɨ mepa nero aiwá nɨnɨrɨŋɨ́pimɨ dánɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨpaxɨ́pɨ meaanɨro nánɨ éɨ́rɨxɨnɨ. Aiwá apɨ ámá imónɨŋáonɨ ananɨ seaiapɨpaxɨ́rɨnɨ. Ápo Gorɨxo ‘Mɨmɨwiároarɨŋorɨ́anɨ?’ nɨniaiwirɨ xɨ́o e éwɨnɨgɨnɨrɨ nɨrɨ́peaŋonɨ aiwá apɨ ananɨ seaiapɨpaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ayɨ́ re urɨgɨ́awixɨnɨ, “Nene pí nerɨ́ná Gorɨxo ámá e oépoyɨnɨrɨ wimónarɨŋɨ́pɨ yanɨ́wɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisaso re urɨŋɨnigɨnɨ, “Seyɨ́né rɨpɨ neróná Gorɨxo wimónarɨŋɨ́pɨ yarɨŋoɨ. Ámá xɨ́o nɨrowárénapɨŋonɨ dɨŋɨ́ nɨnɨkwɨ́rorónáyɨ́, xɨ́o wimónarɨŋɨ́pɨ yarɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ayɨ́ re urɨgɨ́awixɨnɨ, “Nene sɨŋwɨ́ nɨwɨnɨrane dɨŋɨ́ rɨkwɨ́roanɨ nánɨ pí emɨmɨ́ neaíwapɨyirɨ́ɨnɨ? Joxɨ aga píyɨ́ erɨ́ɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɨkwɨ́yo xwɨyɨ́á re nɨrɨnɨrɨ eánɨŋɨ́pa, ‘O aiwá nɨpɨ́rɨ nánɨ aŋɨ́namɨ dánɨ wiŋɨnigɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pa negɨ́ arɨ́owa ámá dɨŋɨ́ meaŋe nemeróná aiwá manáɨ rɨnɨŋɨ́pɨ —Aiwá apɨ Gorɨxoyá dɨŋɨ́yo dánɨ xegɨ́pɨ weagɨ́pɨrɨnɨ. Arɨ́owa ámá dɨŋɨ́ meaŋe nemeróná aiwá apɨ nagɨ́árɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ aga nepa seararɨŋɨnɨ. Aiwá eŋíná aŋɨ́namɨ dánɨ seaiapɨŋo, ayɨ́ Mosesomanɨ. Agwɨ enɨ aga aiwá nepaxɨŋɨ́pɨ aŋɨ́namɨ dánɨ seaiaparɨŋo, ayɨ́ gɨ́ áporɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aiwá nepaxɨŋɨ́ ápo Gorɨxo seaiparɨŋɨ́pɨ, ayɨ́ aiwá aŋɨ́namɨ dánɨ nɨweapɨrɨ ámá xwɨ́á tɨ́yo ŋweagɨ́á dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́áyɨ́ imónɨpɨ́rɨ́a nánɨ sɨxɨ́ umímoarɨŋorɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ayɨ́ re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, aiwá joxɨ neararɨŋɨ́pɨ íníná neaiapɨ́ɨrɨxɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisaso re urɨŋɨnigɨnɨ, “Aiwá nepaxɨŋɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨpɨ́rɨ́ápɨ, ayɨ́ nionɨrɨnɨ. Ámá nionɨ tɨ́ámɨnɨ bɨ́á gɨyɨ́ gɨyɨ́ ámɨ agwɨ́ wipaxɨ́ menɨnɨ. Nionɨ dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ ámɨ iniɨgɨ́ nánɨ bɨ gwɨ́nɨ́ yeáyɨ́ wipaxɨ́ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","E nɨsearɨrɨ aiwɨ nionɨ re searɨ́anigɨnɨ, ‘Seyɨ́né emɨmɨ́ nionɨ eŋápɨ sɨŋwɨ́ nɨnanɨro aiwɨ “Orɨ́anɨ?” nɨniaiwiro dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ.’ searɨ́anigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","E nerɨ aí ámá ápo ‘Dɨxɨ́rɨnɨ.’ nɨnɨrɨrɨ niapɨŋɨ́yɨ́ nɨ́nɨ xɨxenɨ dɨŋɨ́ nɨnɨkwɨ́roro nionɨ tɨ́ámɨnɨ bɨpɨ́rɨ́árɨnɨ. Nionɨ tɨ́ámɨnɨ bɨ́áyɨ́ mɨxɨ́ wí umáɨnɨmɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nionɨ aŋɨ́namɨ dánɨ nɨweapɨrɨ́ná nionɨ gɨ́ nimónarɨŋɨ́pɨ emɨ́ánɨrɨ weapɨŋáonɨmanɨ. Nionɨ nɨrowárénapɨŋo wimónarɨŋɨ́pɨ emɨ́ánɨrɨ nɨweapɨrɨ nánɨ ámá xɨ́oyá dɨŋɨ́ tɨ́nɨ nionɨ tɨ́ámɨnɨ bɨ́áyɨ́ mɨxɨ́ wí umáɨnɨmɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nionɨ nɨrowárénapɨŋo e éwɨnɨgɨnɨrɨ wimónarɨŋɨ́pɨ, ayɨ́ rɨpɨrɨnɨ. Nionɨ ámá xɨ́o niapɨŋɨ́yɨ́ wíyo mɨyorɨ́rɨpa erɨ sɨ́á yoparɨ́yi imónáná ámɨ wiápɨ́nɨmeapɨ́rɨ́a nánɨ dɨŋɨ́ sɨxɨ́ umímorɨ emɨ́a nánɨ wimónarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","‘Gɨ́ ápo e éwɨnɨgɨnɨrɨ wimónarɨŋɨ́pɨ, ayɨ́ rɨpɨrɨnɨ.’ seararɨŋɨnɨ. O ámá xewaxonɨ sɨŋwɨ́ nɨnanɨro dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ tɨ́gɨ́áyɨ́ imónɨpɨ́rɨ́a nánɨ wimónɨrɨ nionɨ sɨ́á yoparɨ́yimɨ ayɨ́ ámɨ wiápɨ́nɨmeapɨ́rɨ́a nánɨ dɨŋɨ́ sɨxɨ́ umímómɨ́a nánɨ wimónɨrɨ yarɨŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judayɨ́ xewanɨŋo re rɨnɨ́ɨ́pɨ nánɨ, “Aiwá aŋɨ́namɨ dánɨ weapɨŋɨ́pɨ, ayɨ́ nionɨrɨnɨ.” rɨnɨ́ɨ́pɨ nánɨ anɨŋúmɨ́ nirɨnɨro o nánɨ ");
INSERT INTO aak_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","re rɨnɨgɨ́awixɨnɨ, “Jisaso ro Josepomɨ xewaxo menɨranɨ? Xanɨyaú nánɨ nene majɨ́áranɨ? O arɨge nerɨ ‘Aŋɨ́namɨ dánɨ wepɨ́nɨŋáonɨrɨnɨ.’ rɨ́a rarɨnɨ?” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisaso re urɨŋɨnigɨnɨ, “Pí nánɨ anɨŋúmɨ́ nirɨnɨro rɨnarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ámá wo aí xewanɨŋoyá dɨŋɨ́yo dánɨ nionɨ tɨ́ámɨnɨ bɨpaxɨ́ menɨnɨ. Ápo, nɨrowárénapɨŋo xe o tɨ́ámɨnɨ ounɨrɨ dɨŋɨ́ ukɨkayoŋánánɨ nionɨ tɨ́ámɨnɨ bɨpaxɨ́rɨnɨ. Ayɨ́ sɨ́á yoparɨ́yimɨ wiápɨ́nɨmeapɨ́rɨ́a nánɨ nionɨ dɨŋɨ́ sɨxɨ́ umímómɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Rɨ́wamɨŋɨ́ wɨ́á rókiamoagɨ́áwa eagɨ́áyo re rɨnɨnɨ, ‘Gorɨxo ámá nɨyonɨ wíwapɨyinɨ́árɨnɨ.’ rɨnɨnɨ. Ayɨnánɨ ámá ápo wíwapɨyarɨ́ná arɨ́á wigɨ́á gɨyɨ́ gɨyɨ́ nɨ́nɨ nionɨ tɨ́ámɨnɨ barɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gorɨxo wíwapɨyiŋɨ́ aiwɨ ayɨ́ wí Gorɨxomɨ sɨŋwɨ́ wɨnɨgɨ́á nánɨ mɨrarɨŋɨnɨ. Ná wonɨ Gorɨxo tɨ́ŋɨ́ e dánɨ bɨŋáonɨ ápomɨ sɨŋwɨ́ wɨnɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aga nepa seararɨŋɨnɨ. Nionɨ dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ tɨ́gɨ́áyɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aiwá nɨnɨrɨŋɨ́pimɨ dánɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨpaxɨ́pɨ, ayɨ́ nionɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Eŋíná segɨ́ seárɨ́awéyɨ́ ámá dɨŋɨ́ meaŋe nemeróná aiwá manáɨ rɨnɨŋɨ́pɨ nɨnɨro aiwɨ nɨŋweagɨ́asáná pegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aiwá aŋɨ́namɨ dánɨ weapɨŋɨ́ rɨpɨ xegɨ́ bɨxɨnɨ. Ámá nɨnɨrɨ́náyɨ́, nɨpepɨ́rɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aiwá dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨpɨ́rɨ nánɨ aŋɨ́namɨ dánɨ weapɨŋɨ́pɨ, ayɨ́ nionɨrɨnɨ. Ámá gɨyɨ́ gɨyɨ́ aiwá rɨpɨ nɨnɨrɨ́náyɨ́, anɨŋɨ́ íníná ŋweapɨ́rɨ́árɨnɨ. Aiwá ámá xwɨ́á rɨrímɨ ŋweagɨ́á nɨ́nɨ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́áyɨ́ nimónɨro íníná ŋweapɨ́rɨ́a nánɨ mɨnɨ wimɨ́ápɨ, ayɨ́ gɨ́ warápɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judayɨ́ wigɨ́pɨ xwɨyɨ́á xɨmɨxɨmɨ́ ninɨro re rɨnarɨŋagɨ́a, “Ámá ro arɨge nerɨ xɨ́oyá wará nanɨ́wá nánɨ neaiapɨnɨ́árɨ́anɨ?” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Seyɨ́né ámá imónɨŋáonɨyá warápɨ mɨnɨpa ero ragɨ́pɨ mɨnɨpa ero nerónáyɨ́, dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́né menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gɨ́ wará nɨro gɨ́ ragɨ́ nɨro éɨ́á gɨyɨ́ gɨyɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́ eŋagɨ́a nánɨ sɨ́á yoparɨ́yimɨ owiápɨ́nɨmeápoyɨnɨrɨ dɨŋɨ́ sɨxɨ́ umímómɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gɨ́ wará rɨpɨ aiwá nepaxɨŋɨ́ imónɨrɨ gɨ́ ragɨ́pɨ iniɨgɨ́ nepaxɨŋɨ́ imónɨrɨ eŋagɨ nánɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ámá gɨ́ wará nɨrɨ ragɨ́ nɨrɨ éɨ́ go go nionɨ tɨ́nɨ nɨkumɨxɨnɨrai nawínɨ imónɨŋwiɨ. Nionɨ enɨ xɨ́o tɨ́nɨ nɨkumɨxɨnɨrai nawínɨ imónɨŋwiɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ápo, dɨŋɨ́ nɨyɨmɨŋɨ́pɨ mɨ́kɨ́ tɨ́ŋo nɨrowárénapɨŋɨ́rɨnɨ. Ápo e eŋɨ́ eŋagɨ nánɨ nionɨ enɨ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ mɨ́kɨ́ tɨ́ŋáonɨ imónɨŋɨnɨ. Ayɨnánɨ go go nɨbɨrɨ nionɨ nɨnɨnɨrɨ́náyɨ́, nionɨ enɨ dɨŋɨ́ mɨ́kɨ́ tɨ́ŋáonɨ eŋagɨ nánɨ xɨ́o enɨ dɨŋɨ́ nɨyɨmɨŋɨ́ íníná ŋweanɨ́a nánɨ tɨ́ŋɨ́ wo imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aiwá aŋɨ́namɨ dánɨ weapɨŋɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Rɨpɨ aiwá eŋíná negɨ́ arɨ́owa nɨnɨro nɨŋweagɨ́asáná pegɨ́ápɨ yapɨ mimónɨnɨ. Go go aiwá rɨpɨ nɨnɨrɨ́náyɨ́, dɨŋɨ́ íníná ŋweanɨ́a nánɨ tɨ́ŋɨ́ wo imónɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisaso rotú aŋɨ́ Kapaneamɨyo mɨrɨnɨŋiwámɨ dánɨ nuréwapɨyirɨ́ná e nura uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ayɨnánɨ xegɨ́ wiepɨsarɨŋɨ́yɨ́ obaxɨ́ amɨpí o nuréwapɨyirɨ́ná nura úɨ́pɨ arɨ́á nɨwiróná re rɨgɨ́awixɨnɨ, “Xwɨyɨ́á o rarɨŋɨ́pɨ ududɨ́ inɨŋɨ́pɨ rarɨnɨ. Ámá go xɨxenɨ arɨ́á winɨrɨ́enɨŋoɨ?” rarɨŋagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisaso xegɨ́ wiepɨsarɨŋɨ́yɨ́ obaxɨ́ o rɨ́ɨ́pɨ nánɨ anɨŋúmɨ́ irɨnarɨŋagɨ́a nɨjɨ́á nimónɨrɨ re urɨŋɨnigɨnɨ, “Xwɨyɨ́á ududɨ́ seainɨpaxɨ́ searɨ́ápimɨ dánɨ róreámioarɨŋoɨ? Nionɨ pɨ́nɨ nɨnɨwiárɨmɨ upɨ́rɨ rɨseaimónarɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Seyɨ́né ámá imónɨŋáonɨ xewanɨŋonɨ weapɨŋaé nánɨ ámɨ peyarɨŋagɨ nɨnanɨrɨ́náyɨ́, pí wipɨ́rɨ seaimónɨnɨ́árɨ́anɨ? Sɨnɨ pɨ́nɨ nɨnɨwiárɨmɨ upɨ́rɨ nánɨ seaimónɨnɨ́árɨ́anɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","re urɨŋɨnigɨnɨ, “Dɨŋɨ́ nɨyɨmɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ wiarɨŋɨ́pɨ, ayɨ́ kwíyɨ́ Gorɨxoyápɨrɨnɨ. Ámáyɨ́ wigɨ́ eŋɨ́ eánɨgɨ́á tɨ́nɨ wí e imónɨpaxɨ́ menɨnɨ. Xwɨyɨ́á nionɨ searɨ́ápɨ ámá dɨŋɨ́ nɨkwɨ́rorɨŋɨ́pimɨ dɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ kwíyɨ́ ewearɨŋɨ́pɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","E nerɨ aí wiyɨ́né xwɨyɨ́á nionɨyá sɨnɨ dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ.” urɨŋɨnigɨnɨ. Jisaso iwamɨ́ó dánɨ ámá xɨ́omɨ dɨŋɨ́ mɨwɨkwɨ́róɨ́áyɨ́ nánɨ nɨjɨ́á imónɨrɨ xɨ́o nánɨ mɨyɨ́ urɨnɨ́o nánɨ enɨ nɨjɨ́á imónɨrɨ eŋo eŋagɨ nánɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","re urɨŋɨnigɨnɨ, “Wiyɨ́né dɨŋɨ́ mɨnɨkwɨ́roarɨŋagɨ́a nánɨ re searɨ́anigɨnɨ, ‘Ápo ámá go go nionɨ tɨ́ŋɨ́ e xe ounɨrɨ sɨŋwɨ́ mɨwɨnɨpa nerɨ́náyɨ́, o nionɨ tɨ́ámɨnɨ wí bɨpaxɨ́ menɨnɨ.’ searɨ́anigɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Xwɨyɨ́á apɨ nura úɨ́ eŋagɨ nánɨ xegɨ́ wiepɨsarɨŋɨ́yɨ́ obaxɨ́ omɨ pɨ́nɨ nɨwiárɨmɨ nuro ámɨ o tɨ́nɨ nawínɨ bɨ aŋɨ́ memegɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ayɨnánɨ Jisaso xegɨ́ wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awamɨ re urɨŋɨnigɨnɨ, “Soyɨ́né enɨ ‘Rɨxa pɨ́nɨ nɨwiárɨmɨ owaneyɨ.’ rɨseaimónarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimonɨ Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, none go tɨ́ámɨnɨ wanɨ́wɨnɨ? Xwɨyɨ́á dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́ŋwáone imónanɨ nánɨ imónɨŋɨ́pɨ joxɨnɨ tɨ́ŋoxɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","None rɨxa dɨŋɨ́ nɨrɨkwɨ́rorane nɨjɨ́á re imónɨŋwɨnɨ, ‘Joxɨ sɨyikwɨ́ mínɨŋɨ́ Gorɨxo rɨrɨ́peaŋoxɨrɨ́anɨ? Yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo, ayɨ́ joxɨrɨnɨ.’ nɨyaiwirane nɨjɨ́á imónɨŋwɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ ámá wé wúkaú sɨkwɨ́ waú soyɨ́né mɨsearɨ́peapa reŋanigɨnɨ? E nerɨ aí woxɨ oboxɨ́nɨŋɨ́ imónɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Isɨkariotɨ dáŋɨ́ Saimonomɨ xewaxo Judaso —O wiepɨsarɨŋɨ́ wé wúkaú sɨkwɨ́ waú awa worɨnɨ. O xɨ́o nánɨ mɨyɨ́ urɨnɨ́o eŋagɨ nánɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jisaso e nɨyárɨmo néɨsáná Judayɨ́ ámɨnáowa xɨ́omɨ pɨkianɨro nánɨ mekaxɨ́ mearɨŋagɨ́a nɨjɨ́á nimónɨrɨ nánɨ “Judia pɨropenɨsɨ́yo oememɨnɨ.” mɨwimónɨ́ Gariri pɨropenɨsɨ́yo aŋɨ́ emearɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","aiwá Judayɨ́ aŋɨ́ pákɨ́ pákɨ́ inɨŋɨ́yo nɨŋwearɨ́ná imɨxayarɨgɨ́ápɨ —Aiwá apɨ, ayɨ́ eŋíná ɨ́wiárɨ́awé Moseso tɨ́nɨ nemeróná senɨ́á aŋɨ́yo nɨŋweaxa wagɨ́ápɨ nánɨ dɨŋɨ́ winɨnɨ nánɨ xwiogwɨ́ ayɨ́ ayo Judayɨ́ wigɨ́ aŋɨ́yɨ́ pɨ́nɨ nɨwiárɨmɨ nuro sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo aŋɨ́ pákɨ́ pákɨ́ inɨŋɨ́yo nɨŋwearo aiwá imɨxarɨgɨ́ápɨrɨnɨ. Aiwá apɨ rɨxa aŋwɨ e imónɨŋáná ");
INSERT INTO aak_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","xogwáowa re urɨgɨ́awixɨnɨ, “Dɨxɨ́ wiepɨsarɨŋɨ́ wínɨyɨ́ enɨ emɨmɨ́ amɨpí joxɨ yarɨŋɨ́pɨ sɨŋwɨ́ wɨnɨpɨ́rɨ nánɨ aŋɨ́ re pɨ́nɨ nɨwiárɨmɨ Judia pɨropenɨsɨ́yo nánɨ uɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ayɨ́ rɨpɨ nánɨ rɨrarɨŋwɨnɨ. Ámá wo ámá nɨ́nɨ xɨ́o nánɨ nɨjɨ́á oimónɨ́poyɨnɨrɨ nɨwimónɨrɨ́náyɨ́, xegɨ́ yarɨŋɨ́pɨ ínɨmɨ yarɨŋɨ́manɨ. Emɨmɨ́ joxɨ yarɨŋɨ́pɨ nepa nerɨ́náyɨ́, jɨwanɨŋoxɨ nurɨ ámá nɨyɨ́yá sɨŋwɨ́yo dánɨ sɨwá winɨrɨ́ɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Awa xegɨ́ xogwáowa aí dɨŋɨ́ mɨwɨkwɨ́ropa nero nánɨ e urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né upɨ́rɨ́íná ananɨ gínɨ gíná upɨ́rɨ́a nánɨ imónɨŋagɨ aiwɨ nionɨ umɨ́áíná sɨnɨ mimónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ámá xwɨ́á tɨ́yo dáŋɨ́ nɨ́nɨyɨ́ soyɨ́né tɨ́nɨ sɨ́mɨ́ tɨ́nɨ inɨpaxɨ́ mimónɨŋoɨ. E nerɨ aiwɨ nionɨ wigɨ́ yarɨgɨ́ápɨ nánɨ ‘Sɨpírɨnɨ.’ nurɨrɨ waropárɨ́ wiararɨŋagɨ nánɨ sɨ́mɨ́ tɨ́nɨ niarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Segɨ́pɨ aiwá nene xwiogwɨ́ o omɨ imɨxayarɨŋwápɨ nánɨ yoápoyɨ. Nionɨ gɨ́ umɨ́áíná sɨnɨ mimónɨŋagɨ nánɨ wí umɨméɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","nurárɨmɨ Gariri pɨropenɨsɨ́yo ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisaso, xexɨrɨ́meáowa rɨxa aiwá apɨ nánɨ yoáɨ́ámɨ eŋáná xɨ́o enɨ ámáyá sɨŋwɨ́yo dánɨ mɨyoá yumɨ́í ínɨmɨ nɨyirɨ Jerusaremɨ nɨrémorɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judayɨ́ aiwá imɨxarɨgɨ́e xɨ́o nánɨ pɨ́á néra nuro “O gerɨnɨ?” nɨrɨga nuro ");
INSERT INTO aak_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ámá e epɨ́royɨ́ egɨ́áyɨ́ ikeagɨgwɨ́ ayá wí nɨrɨga nuro wí “Ámá naŋorɨnɨ.” rɨro wí “Oweoɨ, naŋomanɨ. Ámá nɨyonɨ dɨŋɨ́ nukɨnɨmɨxɨrɨ xeŋwɨ́mɨ nipemeámɨ warɨŋorɨnɨ.” rɨro nero aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judayɨ́ ámɨnáowa nánɨ wáyɨ́ nero nánɨ ámá wí o nánɨ ámá sɨ́mɨmaŋɨ́ e dánɨ mɨrɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jisaso sɨ́á aiwá imɨxarɨgɨ́áyɨ́ rɨxa áwɨnɨ e imónɨŋáná aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nánɨ nurɨ nɨpáwirɨ ámáyo uréwapɨyarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judayɨ́ ámɨnáowa dɨŋɨ́ ududɨ́ nɨwinɨro re rɨgɨ́awixɨnɨ, “Arɨre nerɨ nɨjɨ́á o rarɨŋɨ́pɨ nimónɨrɨ rɨ́a rarɨnɨ? Sɨkurɨ́á meŋoyoɨ.” rarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisaso re urɨŋɨnigɨnɨ, “Xwɨyɨ́á nionɨ searéwapɨyarɨŋápɨ nionɨ gɨ́pɨmanɨ. Nionɨ nɨrowárénapɨŋoyápɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","‘O wimónarɨŋɨ́pɨ oemɨnɨ.’ wimónarɨŋɨ́ gɨyɨ́ gɨyɨ́ nionɨ searéwapɨyarɨŋápɨ nánɨ nɨjɨ́á nimónɨrɨ re yaiwipaxɨ́rɨnɨ, ‘Gorɨxoyá dɨŋɨ́yo dánɨ rɨ́a nearéwapɨyarɨnɨ? Xɨ́o xegɨ́ dɨŋɨ́yo dánɨ rɨ́a nearéwapɨyarɨnɨ?’ nɨyaiwirɨ nɨjɨ́á imónɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ámá go go xɨ́o xegɨ́ dɨŋɨ́yo dánɨ nɨrɨrɨ́náyɨ́, ámá weyɨ́ onɨmépoyɨnɨrɨ yarɨŋɨ́rɨnɨ. E nerɨ aí ámá nɨ́nɨ ámá xɨ́omɨ urowárénapɨŋomɨ weyɨ́ oumépoyɨnɨrɨ yarɨŋo, o aga nepaxɨŋorɨnɨ. Yadɨmɨŋɨ́ yarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Eŋíná Moseso ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ mɨseaiapɨpa reŋɨnigɨnɨ? E nerɨ aí soyɨ́néyá wo aí ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ píránɨŋɨ́ xɨ́darɨŋɨ́manɨ. Pí nánɨ soyɨ́né nionɨ nɨpɨkianɨro yarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ámá e epɨ́royɨ́ egɨ́áyɨ́ re urɨgɨ́awixɨnɨ, “Imɨ́ó xɨxéroarɨŋɨ́ roxɨnɨ, ámá gɨyɨ́ rɨpɨkianɨro yarɨŋagɨ́a rarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ emɨmɨ́ ná bɨnɨ éagɨ seyɨ́né sɨnɨ ududɨ́ ikárɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moseso ŋwɨ́ ikaxɨ́ ‘Segɨ́ niaíwɨ́yo nɨxɨrɨmáná sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo múróáná sɨ́á ayimɨ iyɨ́ sɨ́mɨ́ sɨ́ó wákwíɨ́rɨxɨnɨ.’ rɨŋɨ́rɨnɨ. E nɨsearɨrɨ aiwɨ ayɨ́ Moseso marɨ́áɨ, negɨ́ arɨ́owa sɨwɨ́ apɨ érowiápɨ́nɨgɨ́árɨnɨ. Ayɨnánɨ seyɨ́né segɨ́ niaíwɨ́yɨ́ ŋwɨ́ ikaxɨ́ rɨnɨŋɨ́pɨ nɨxɨ́dɨrɨŋɨ́pimɨ dánɨ naŋɨ́ oimónɨ́poyɨnɨrɨ Sabarɨ́áyo aiwɨ iyɨ́ sɨ́mɨ́ sɨ́ó wákwiarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Seyɨ́né ‘Naŋɨ́ nerane ŋwɨ́ ikaxɨ́ Moseso nɨrɨrɨ eaŋɨ́pɨ pɨ́rɨ́ mɨwiaíkipa oyaneyɨ.’ nɨyaiwiro Sabarɨ́áyo enɨ iyɨ́ sɨ́mɨ́ sɨ́ó wákwiarɨgɨ́árɨnɨ. Seyɨ́né e yarɨgɨ́á eŋagɨ nánɨ pí nánɨ nionɨ ámá womɨ Sabarɨ́áyo naŋɨ́ wimɨxɨ́ápɨ nánɨ wikɨ́ nónarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sɨŋwɨ́ tɨ́nɨnɨ nɨwɨnaxɨ́dɨro mɨrɨpa époyɨ. Xɨ́o yarɨŋagɨ́pɨ enɨ mí nómɨxɨrɨ́ná rɨ́ɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ámá Jerusaremɨ ŋweagɨ́áyɨ́ wí re nɨra ugɨ́awixɨnɨ, “Ámá ro ámá nɨpɨkianɨro egɨ́o menɨranɨ? ");
INSERT INTO aak_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sɨŋwɨ́ wɨnɨ́poyɨ. Ámá nɨ́nɨ arɨ́á egɨ́e sɨŋánɨ nɨrorɨ rarɨŋagɨ aí mebá neameŋweagɨ́áwa omɨ xwɨyɨ́á bɨ murarɨŋoɨ. Awa ‘Ámá ro Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo, ayɨ́ orɨ́anɨ?’ mɨyaiwipa rɨyarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E nerɨ aí ‘Ámá o Kiraiso, ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨ́anɨ?’ wiaiwipaxɨ́ menɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Nene xɨnáí xɨ́omɨ xɨrɨŋe nánɨ nɨjɨ́á imónɨŋwɨnɨ. E nerɨ aiwɨ Kiraiso, ámá Gorɨxo yeáyɨ́ neayimɨxemeanɨ́a nánɨ urowárénapɨnɨ́o imónɨnɨ́ánɨyɨ́ ámá wo ‘E dáŋorɨnɨ.’ rɨpaxɨ́ menɨnɨ. Ayɨnánɨ ‘O Kiraisorɨ́anɨ?’ wiaiwipaxɨ́ mimónɨŋwɨnɨ.” rarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ nuréwapɨyirɨ́ná eŋɨ́ tɨ́nɨ nɨrɨrɨ re urɨŋɨnigɨnɨ, “Seyɨ́né nepa nionɨ nánɨ nɨjɨ́á ero ‘O e dáŋorɨnɨ.’ rɨpaxɨ́ imónɨro yarɨgɨ́áyɨ́néranɨ? Nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ bɨŋámanɨ. Nepaxɨŋɨ́ imónɨŋo —O soyɨ́né majɨ́orɨnɨ. O nionɨ nɨrowárénapɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","O tɨ́ŋɨ́ e dánɨ bɨŋáonɨ eŋagɨ nánɨ o nionɨ nɨjɨ́árɨnɨ. O nionɨ nɨrowárénapɨŋɨ́rɨnɨ.” urɨ́agɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","omɨ ɨ́á xɨranɨro nero aiwɨ ɨ́á xɨrɨpaxíná sɨnɨ mimónɨŋagɨ nánɨ ɨ́á bɨ mɨxɨrɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E nerɨ aí ámá e epɨ́royɨ́ egɨ́áyɨ́ obaxɨ́ wí dɨŋɨ́ nɨwɨkwɨ́roro re nɨra ugɨ́awixɨnɨ, “Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo nimónɨrɨ́ná emɨmɨ́ ámá ro yarɨŋɨ́pimɨ nɨmúrorɨ enɨ́áranɨ? Oweoɨ.” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisiowa ámá e epɨ́royɨ́ egɨ́áyɨ́ Jisaso nánɨ ikeagɨgwɨ́ e rarɨŋagɨ́a arɨ́á nɨwiro nánɨ awa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ dɨŋɨ́ axɨ́pɨ nɨxɨrɨro Jisasomɨ ɨ́á oxɨrɨ́poyɨnɨrɨ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́á wamɨ urowárɨ́agɨ́a awa nuro o uréwapɨyarɨŋe rémóagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisaso re urɨŋɨnigɨnɨ, “Seyɨ́né tɨ́nɨ re bɨ onɨmiápɨ nɨŋweámonɨ gɨ́ nɨrowárénapɨŋo tɨ́e nánɨ umɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rɨxa úáná seyɨ́né nionɨ nánɨ pɨ́á nɨniro aiwɨ wí sɨŋwɨ́ nanɨpɨ́rɨ́ámanɨ. Seyɨ́né nionɨ ŋweámɨ́aé upaxɨ́ wí mimónɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judayɨ́ ámɨnáowa re rɨnɨgɨ́awixɨnɨ, “O gɨmɨ nánɨ umɨnɨrɨ rarɨnɨ? Aga gɨmɨ nánɨ úáná nene o nánɨ pɨ́á megɨnanɨ́wárɨnɨ? Negɨ́ ámáyɨ́ Gɨrikɨyɨ́ aŋɨ́yo ŋweagɨ́ámɨ nánɨ nurɨ émáyo uréwapɨyimɨ́ánɨrɨ rɨ́a neararɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Xwɨyɨ́á o re rɨ́ɨ́pɨ, ‘Seyɨ́né nionɨ nánɨ pɨ́á nɨniro aiwɨ wí sɨŋwɨ́ nanɨpɨ́rɨ́ámanɨ. Seyɨ́né nionɨ ŋweámɨ́aé upaxɨ́ wí mimónɨŋoɨ.’ rɨ́ɨ́pɨ pí nɨyaiwirɨ rɨ́a rɨŋoɨ?” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sɨ́á aiwá apɨ imɨxarɨgɨ́áyɨ́ yoparɨ́yi —Ayi seáyɨ e imónɨŋɨ́yirɨnɨ. Sɨ́á ayi imónɨŋáná Jisaso éɨ́ nɨrorɨ eŋɨ́ tɨ́nɨ re rɨŋɨnigɨnɨ, “Ámá iniɨgɨ́ nánɨ gwɨ́nɨ́ yeáyɨ́ wíɨ́ gɨyɨ́ gɨyɨ́ nionɨ tɨ́ámɨnɨ nɨbɨro iniɨgɨ́ onɨ́poyɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nionɨ dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ Bɨkwɨ́yo nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ tɨ́nɨ xɨxenɨ imónɨpɨ́ráoɨ, ‘Wigɨ́ xwioxɨ́yo ná ínɨmɨ dánɨ iniɨgɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imɨxarɨŋɨ́pɨ oyɨ́á tɨ́ŋɨ́ pwenɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ imónɨpɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisaso e nɨrɨrɨ́ná kwíyɨ́ Gorɨxoyá xɨ́omɨ dɨŋɨ́ wɨkwɨ́róɨ́áyɨ́ meapɨ́rɨ́ápɨ nánɨ e urɨŋɨnigɨnɨ. Íná Jisaso sɨnɨ aŋɨ́namɨ nɨpeyirɨ mikɨ́nɨpa éíná eŋagɨ nánɨ Gorɨxo sɨnɨ xegɨ́ kwíyɨ́pɨ ámáyo sɨxɨ́ mumímopa yagínárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ámá e epɨ́royɨ́ egɨ́áyɨ́ o e rarɨŋagɨ arɨ́á nɨwiro wí re nɨra ugɨ́awixɨnɨ, “Aga neparɨnɨ. Ámá ro wɨ́á rókiamoagɨ́ nene xwayɨ́ nanɨrɨ ŋweaŋwáorɨnɨ.” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","wí re nɨra ugɨ́awixɨnɨ, “ ‘Ámá ro Gorɨxo yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo, Kiraisorɨnɨ.’ neaimónarɨnɨ.” nɨra warɨ́ná wí re nɨra ugɨ́awixɨnɨ, “Gariri pɨropenɨsɨ́yo dáŋɨ́ wo Kiraiso, ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo imónɨpaxɨ́ranɨ? Oweoɨ, e dáŋɨ́ wo ámá arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo imónɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bɨkwɨ́yo re mɨrɨnɨpa renɨ, ‘Kiraiso, arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo negɨ́ arɨ́o Depitoyá ɨ́wiárɨ́awé wo imónɨnɨ́árɨnɨ. Aŋɨ́ Betɨrexemɨ —Eŋíná Depito xegɨ́ ŋweaagerɨnɨ. Omɨ e dánɨ xɨrɨnɨ́árɨnɨ.’ mɨrɨnɨpa renɨ?” nɨra nuro nánɨ ");
INSERT INTO aak_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ámá e epɨ́royɨ́ egɨ́áyɨ́ o nánɨ dɨŋɨ́ xɨxegɨ́nɨ tɨ́nɨ nepayoro nɨrɨróná ");
INSERT INTO aak_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","wí “Rɨxa ɨ́á oxɨraneyɨ.” nɨwimónɨrɨ aiwɨ omɨ ɨ́á bɨ mɨxɨrɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwa ámɨ nuro apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowamɨ tɨ́nɨ Parisiowamɨ tɨ́nɨ wímeááná awa re urɨgɨ́awixɨnɨ, “Pí nánɨ omɨ ɨ́á mɨxɨrɨ́ anɨpáoyɨ́né barɨŋoɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","awí mearoarɨgɨ́áwa re urɨgɨ́awixɨnɨ, “Eŋíná aiwɨ ámá o nearéwapɨyarɨŋɨ́pa wo mɨnearéwapɨyagɨ́rɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisiowa ikayɨ́wɨ́ nurɨro re urɨgɨ́awixɨnɨ, “Soyɨ́né enɨ rɨxa dɨŋɨ́ nɨseakɨnɨmɨxɨrɨ xeŋwɨ́mɨ nɨseaipemeámɨ mupa reŋoɨ?” nurɨro ");
INSERT INTO aak_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","re urɨgɨ́awixɨnɨ, “Seameŋweaŋwáone woranɨ, Parisione woranɨ, omɨ dɨŋɨ́ bɨ wɨkwɨ́róɨ́ranɨ? Oweoɨ! ");
INSERT INTO aak_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","E nerɨ aí ámá epɨ́royɨ́ egɨ́á jɨ́ayɨ́ ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́pɨ nánɨ píránɨŋɨ́ nɨjɨ́á mimónɨpa nero nánɨ Gorɨxoyá sɨŋwɨ́yo dánɨ anɨ́nɨpɨ́rɨ́a nánɨ ramɨxárɨnɨŋɨ́yɨ́rɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimaso —O enɨ Parisi worɨnɨ. Xámɨ árɨ́wɨyimɨ nurɨ Jisasomɨ nɨwímearɨ yarɨŋɨ́ wiŋorɨnɨ. O nɨwiápɨ́nɨmearɨ re urɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Negɨ́ ŋwɨ́ ikaxɨ́ nɨrɨnɨrɨ eánɨŋɨ́yo bɨ rɨpɨ rɨrɨnɨnɨ, ‘Ámá womɨ xɨ́o rɨnarɨŋɨ́pɨ arɨ́á mɨwipa erɨ o yarɨŋɨ́pɨ píránɨŋɨ́ nɨjɨ́á mimónɨpa erɨ nemáná ananɨ xwɨyɨ́á umeárɨpaxɨ́rɨnɨ.’ rɨrɨnɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","awa ikayɨ́wɨ́ re urɨgɨ́awixɨnɨ, “Joxɨ enɨ Gariri dáŋɨ́ iwoxɨrɨ́anɨ? Bɨkwɨ́yo píránɨŋɨ́ ɨ́á rorɨ pɨ́á merɨ nerɨ́náyɨ́, joxɨ re nɨyaiwirɨ nɨjɨ́á imónɨrɨ́ɨnɨ, ‘Wɨ́á rókiamoarɨŋɨ́ wo Gaririyo dánɨ imónarɨŋɨ́manɨ.’ nɨyaiwirɨ nɨjɨ́á imónɨrɨ́ɨnɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ámá nɨ́nɨ wigɨ́ aŋɨ́ xɨxegɨ́nɨyo umíagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisaso dɨ́wɨ́ xegɨ́ yoɨ́ Oripiyo nánɨ nurɨ ");
INSERT INTO aak_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","sá weŋo wɨ́á mónɨŋɨ́mɨ ámɨ nɨwiápɨ́nɨmeámɨ nɨbɨrɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ ámá nɨ́nɨ xɨ́o tɨ́ámɨnɨ barɨŋagɨ́a nánɨ o éɨ́ nɨŋweámáná uréwapɨyarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ŋwɨ́ ikaxɨ́ eánɨŋɨ́pɨ mewegɨ́áwa tɨ́nɨ Parisiowa tɨ́nɨ awa apɨxɨ́ ámá wí ɨ́wɨ́ inarɨŋagɨ wɨnɨmeáɨ́á wímɨ nɨméra nɨbɨro áwɨnɨ e éɨ́ nurárárɨmáná ");
INSERT INTO aak_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","omɨ re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, apɨxɨ́ rí ɨ́wɨ́ inarɨŋagɨ wɨnɨmeáɨ́írɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Apɨxɨ́ rínɨŋɨ́ imónɨŋɨ́yɨ́ nánɨ ŋwɨ́ ikaxɨ́ Moseso nɨrɨrɨ eaŋɨ́pimɨ dánɨ re rɨnɨnɨ, ‘Sɨ́ŋá tɨ́nɨ iwaŋɨ́ nearo pɨkíɨ́rɨxɨnɨ.’ rɨnɨŋagɨ aí joxɨ píoɨ rɨrɨ́ɨnɨ?” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rɨ́wéná o Moseso rɨŋɨ́pɨ nɨwiaíkirɨ xegɨ́ bɨ́ rɨ́ɨ́pimɨ dánɨ xwɨyɨ́á uxekwɨ́moaneyɨnɨro iwamɨ́ó nɨwíwapɨyiro e urɨ́agɨ́a aiwɨ o ípɨ́pá éɨ́ nɨŋweámáná xwɨ́áyo webɨ́á tɨ́nɨ rɨ́wamɨŋɨ́ nearɨ ");
INSERT INTO aak_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","awa arɨ́kí ámɨ ámɨ yarɨŋɨ́ wiayarɨŋagɨ́a o ámɨ éɨ́ nɨrorɨ re urɨŋɨnigɨnɨ, “Soyɨ́né woxɨ goxɨ ɨ́wɨ́ bɨ mɨyarɨŋoxɨ xámɨ ímɨ sɨ́ŋá eaɨ.” nurɨmɨ ");
INSERT INTO aak_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ámɨ ípɨ́pá éɨ́ nɨŋwearɨ xwɨ́áyo rɨ́wamɨŋɨ́ eaarɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Awa Jisaso e urɨ́agɨ arɨ́á nɨwiro wonɨ wonɨ Jisaso tɨ́ŋɨ́ e pɨ́nɨ nɨwiárɨmɨ nuróná ámɨnáowa xámɨ numearo nɨ́nɨ rɨxa núáná apɨxínɨ xegɨ́ xewɨnɨ Jisasoyá sɨ́mɨ́ e éɨ́ roŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ámɨ éɨ́ nɨrorɨ ímɨ re urɨŋɨnigɨnɨ, “Ineyɨ, ámáyɨ́ gɨmɨnɨrɨnɨ? Ayɨ́ wo xwɨyɨ́á mɨrɨmearɨ́ɨ́ranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","í re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, wo xwɨyɨ́á mɨnɨmearɨ́ɨ́rɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Nionɨ enɨ xwɨyɨ́á wí rɨmearɨméɨnɨ. Dɨxɨ́ aŋɨ́ uɨ. Re dánɨ ámɨ ɨ́wɨ́ bɨ minɨpa éɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisaso ámɨ re urɨŋɨnigɨnɨ, “Nionɨ ámá xwɨ́á tɨ́yo ŋweagɨ́á nɨyonɨ uyɨ́wɨ́ wɨ́ánɨŋɨ́ wókímɨxarɨŋáonɨrɨnɨ. Ámá nionɨ nɨxɨ́dɨ́áyɨ́ sɨ́á yinɨŋɨ́mɨnɨ aŋɨ́ emepɨ́rɨ́á menɨnɨ. Wɨ́á dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́áyɨ́ imɨxɨpaxɨ́ imónɨŋɨ́pɨ wókímɨxɨnɨ́árɨnɨ.” urɨ́agɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisiowa re urɨgɨ́awixɨnɨ, “Joxɨ e rɨ́ɨ́pɨ jɨwanɨŋoxɨ símeaŋɨ́ mɨ́koxɨ́nɨŋɨ́ nimónɨrɨ áwaŋɨ́ rɨnarɨŋagɨ nánɨ ‘Neparɨnɨ.’ nɨyaiwirane arɨ́á seaianɨméwɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ aí niɨwanɨŋonɨ nánɨ áwaŋɨ́ rɨnarɨŋápɨ, ayɨ́ neparɨnɨ. Ayɨ́ rɨpɨ nánɨ seararɨŋɨnɨ. Ge dánɨ rɨ́a bɨŋanigɨnɨrɨ gɨmɨ nánɨ umɨ́árɨ́anɨrɨ imónɨŋɨ́pɨ nánɨ nɨjɨ́á nimónɨrɨ nánɨ seararɨŋɨnɨ. E nerɨ aí soyɨ́né nionɨ bɨŋaé nánɨranɨ, nionɨ umɨ́aé nánɨranɨ, majɨ́á nimónɨro nánɨ nɨrarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Soyɨ́né ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ yarɨgɨ́ápa sɨŋwɨ́ tɨ́nɨnɨ nɨwɨnaxɨ́dɨro rarɨŋagɨ́a aí nionɨ ámá womɨ aí sɨŋwɨ́ tɨ́nɨnɨ nɨwɨnaxɨ́dɨrɨ xwɨyɨ́á mumeararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nionɨ xwɨyɨ́á numearɨrɨ sɨŋwɨrɨyɨ́, nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ mepa nerɨ ápo, nɨrowárénapɨŋoyá dɨŋɨ́yo dánɨ nerɨ nánɨ nepa xɨxenɨ imónɨŋɨ́pɨ tɨ́nɨ umearɨpaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Segɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo aí re nɨrɨnɨrɨ eánɨnɨ, ‘Ámá waú xwɨyɨ́á áwaŋɨ́ nɨrɨríná axɨ́pɨnɨ nɨrɨrɨ́náyɨ́, xwɨyɨ́á apɨ nepa imónɨnɨ.’ nɨrɨnɨrɨ eánɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","‘Nionɨ niɨwanɨŋonɨ nánɨ áwaŋɨ́ searɨnɨrɨ ápo, nɨrowárénapɨŋo enɨ nionɨ nánɨ áwaŋɨ́ searɨrɨ yarɨŋagɨ nánɨ soyɨ́né nionɨ seararɨŋápɨ nánɨ “Neparɨnɨ.” yaiwipaxɨ́rɨnɨ.’” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","awa re urɨgɨ́awixɨnɨ, “Dɨxɨ́ ápo ge ŋweanɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “Soyɨ́né nionɨ nánɨ nɨjɨ́á mimónɨpa ero gɨ́ ápo nánɨ nɨjɨ́á mimónɨpa ero yarɨŋoɨ. Soyɨ́né nionɨ nánɨ nɨjɨ́á nimónɨro sɨŋwɨrɨyɨ́, gɨ́ ápo nánɨ enɨ nɨjɨ́á imónanɨro éɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ Gorɨxo nánɨ nɨgwɨ́ tarɨgɨ́á tɨ́ŋɨ́ e dánɨ nuréwapɨyirɨ́ná xwɨyɨ́á apɨ urarɨŋagɨ aiwɨ omɨ ɨ́á xɨrɨpɨ́rɨ́íná sɨnɨ mimónɨŋagɨ nánɨ ɨ́á bɨ mɨxɨrɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O ámɨ re urɨŋɨnigɨnɨ, “Nionɨ pɨ́nɨ nɨseawiárɨmɨ úáná soyɨ́né nionɨ nánɨ pɨ́á nɨniro aí segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ sɨnɨ yokwarɨmɨ́ minɨŋáná pepɨ́rɨ́árɨnɨ. Nionɨ umɨ́aé soyɨ́né bɨpaxɨ́ wí mimónɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judayɨ́ ámɨnáowa re nɨra ugɨ́awixɨnɨ, “O ‘Nionɨ umɨ́aé soyɨ́né bɨpaxɨ́ mimónɨŋoɨ.’ rɨ́agɨ nánɨ xewanɨŋo pɨkínɨmɨnɨrɨ nánɨ mɨnearɨpa rɨyarɨnɨ?” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","o re urɨŋɨnigɨnɨ, “Nionɨ eramɨ dáŋonɨrɨnɨ. Soyɨ́né bɨramɨ dáŋoyɨ́nérɨnɨ. Soyɨ́né xwɨ́á tɨ́yo dáŋoyɨ́nérɨnɨ. Nionɨ xwɨ́á tɨ́yo dáŋonɨmanɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ayɨnánɨ re searɨ́ɨnɨ, ‘Segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ sɨnɨ yokwarɨmɨ́ minɨŋáná pepɨ́rɨ́árɨnɨ.’ searɨ́ɨnɨ. Ayɨ́ rɨpɨ seararɨŋɨnɨ. Soyɨ́né dɨŋɨ́ nɨnɨkwɨ́roro ‘Ayɨ́ orɨnɨ.’ mɨniaiwipa nerónáyɨ́, segɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ sɨnɨ yokwarɨmɨ́ minɨŋáná pepɨ́rɨ́árɨnɨ.” urarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","awa re urɨgɨ́awixɨnɨ, “Goxɨrɨnɨ?” urɨ́agɨ́a Jisaso re urɨŋɨnigɨnɨ, “Nionɨ iwamɨ́ó dánɨ searagáonɨ onɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Soyɨ́né yarɨgɨ́ápɨ nánɨ xwɨyɨ́á searɨmearɨmɨ nánɨ xwɨyɨ́á xwapɨ́ xɨrɨŋáonɨrɨnɨ. Soyɨ́né arɨ́á mɨniarɨŋagɨ́a aiwɨ nionɨ nɨrowárénapɨŋo nepaxɨŋorɨnɨ. Amɨpí omɨ arɨ́á wiŋápɨ ámá nɨ́nɨ arɨ́á egɨ́e dánɨ rarɨŋárɨnɨ.” urɨ́agɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ayɨ́ majɨ́á nimónɨro “Ápo Gorɨxo nánɨ rɨ́a neararɨnɨ?” mɨyaiwiarɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né ámá imónɨŋáonɨ íkɨ́áyo nɨyekwɨroárɨpɨ́rɨ seáyɨ e nɨnɨmɨ́eyoarɨ́ná nɨjɨ́á ‘Ayɨ́ orɨnɨ.’ imónɨpɨ́rɨ́árɨnɨ. Nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ amɨpí bɨ yarɨŋámanɨ. Ápo nɨréwapɨyiŋɨ́pɨnɨ rarɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Íníná nionɨ nɨrowárénapɨŋo yayɨ́ winɨpaxɨ́pɨnɨ yarɨŋagɨ nánɨ nionɨ pɨ́nɨ nɨnɨwiárɨmɨ mɨnú sɨnɨ dɨŋɨ́ nɨkɨkayonɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Xwɨyɨ́á apɨ urarɨ́ná ámá obaxɨ́ dɨŋɨ́ wɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisaso Judayɨ́ omɨ dɨŋɨ́ wɨkwɨ́róɨ́áyo re urɨŋɨnigɨnɨ, “Seyɨ́né gɨ́ xwɨyɨ́á rarɨŋápɨ dɨŋɨ́ ɨ́á nɨxɨrɨrónáyɨ́, nionɨyá gɨ́ seaiepɨsarɨŋá nepaxɨŋɨ́yɨ́né imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xwɨyɨ́á nepaxɨŋɨ́ imónɨŋɨ́pɨ nánɨ nɨjɨ́á nimónɨro e nemáná xwɨyɨ́á apɨ dɨŋɨ́ ɨ́á nɨxɨrɨrɨŋɨ́pimɨ dánɨ áxeŋwarɨ́ minɨgɨ́áyɨ́né imónɨpɨ́rɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","wa re urɨgɨ́awixɨnɨ, “Negɨ́ arɨ́o Ebɨrɨ́amoyá ɨ́wiárɨ́awenerɨnɨ. Eŋíná dánɨ ámá wayá xɨnáíwanénɨŋɨ́ nimónɨrane omɨŋɨ́ mɨwiiagwaéne, joxɨ arɨge nerɨ ‘Áxeŋwarɨ́ minɨgɨ́áyɨ́né imónɨpɨ́rɨ́árɨnɨ.’ neararɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Ámá ɨ́wɨ́ yarɨŋɨ́ go go ɨ́wɨ́ xɨ́o yarɨŋɨ́piyá xɨnáínɨŋɨ́ nimónɨrɨ áxeŋwarɨ́ winɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ámá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́ anɨŋɨ́ aŋiwámɨ xiáwo tɨ́nɨ ŋweaarɨgɨ́ámanɨ. E nerɨ aí xewaxo íníná anɨŋɨ́ e ŋweaarɨŋɨ́rɨnɨ.” nurɨrɨ ámá e rówapɨgɨ́áyɨ́ re oyaiwípoyɨnɨrɨ, “ ‘Seyɨ́né xɨnáíwayɨ́nénɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́né yapɨ imónɨŋoɨ.’ rɨ́a neararɨnɨ?” oyaiwípoyɨnɨrɨ ewayɨ́ xwɨyɨ́á apɨ nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","re urɨŋɨnigɨnɨ, “Ayɨnánɨ xewaxonɨ xɨnáíwayɨ́nénɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́né áxeŋwarɨ́ seainɨŋɨ́pɨ anɨpá seaimɨxɨyíáná aga áxeŋwarɨ́ minɨgɨ́áyɨ́nɨŋɨ́ imónɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","re urɨŋɨnigɨnɨ, “Nionɨ nɨjɨ́árɨnɨ. Seyɨ́né arɨ́o Ebɨrɨ́amoyá ɨ́wiárɨ́awéyɨ́nérɨnɨ. E nimónɨro aí seyɨ́né gɨ́ xwɨyɨ́ápɨ segɨ́ xwioxɨ́yo aumaúmɨ́ minɨ́ɨ́ eŋagɨ nánɨ nionɨ nɨpɨkianɨro nánɨ yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nionɨ ápo tɨ́nɨ nɨŋwearɨ́ná sɨŋwɨ́ wɨnɨŋápɨ nánɨ rarɨŋárɨnɨ. Seyɨ́né enɨ amɨpí segɨ́ ápo rarɨŋagɨ arɨ́á wigɨ́ápɨ yarɨgɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Awa re urɨgɨ́awixɨnɨ, “Negɨ́ arɨ́o Ebɨrɨ́amorɨnɨ.” urɨ́agɨ́a Jisaso re urɨŋɨnigɨnɨ, “Nepa Ebɨrɨ́amoyá ɨ́wiárɨ́awéyɨ́né eŋánáyɨ́, xɨ́o yagɨ́pa epaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","E nerɨ aí nionɨ xwɨyɨ́á nepánɨ Gorɨxomɨ arɨ́á wiŋápɨ seararɨŋáonɨ nɨnɨpɨkianɨro yarɨŋoɨ. Soyɨ́né nianɨro yarɨgɨ́ápa arɨ́o Ebɨrɨ́amo wí e meŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ayɨnánɨ re searɨ́ɨnɨ, ‘Segɨ́ ápo yarɨŋɨ́pɨ yarɨŋoɨ.’ searɨ́ɨnɨ.” urɨ́agɨ ayɨ́ re urɨgɨ́awixɨnɨ, “Negɨ́ inókíwa ɨ́wɨ́ ninɨro neaxɨrɨgɨ́ámanɨ. Negɨ́ ápo imónɨŋo ná wonɨ Gorɨxorɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ bɨŋámanɨ. Gorɨxo nɨrowárénapɨ́agɨ o tɨ́ŋɨ́ e pɨ́nɨ nɨwiárɨmɨ bɨŋá eŋagɨ nánɨ Gorɨxo nepa segɨ́ ápo eŋánáyɨ́, soyɨ́né nionɨ dɨŋɨ́ sɨxɨ́ nɨyipaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Soyɨ́né nionɨ xwɨyɨ́á rarɨ́ná arɨ́á nero aí pí nánɨ nɨjɨ́á mimónɨpa yarɨŋoɨ? Ayɨ́ rɨpɨ nánɨrɨnɨ. ‘Xwɨyɨ́á arɨ́á owianeyɨ.’ mɨseaimónarɨŋagɨ nánɨ nɨjɨ́á mimónɨpa yarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Soyɨ́né niaíwɨ́ segɨ́ ápo oboyáoyɨ́né eŋagɨ́a nánɨ xɨ́o wimónarɨŋɨ́pa niaíwɨ́yɨ́né enɨ ‘Axɨ́pɨ oyaneyɨ.’ seaimónarɨŋɨ́rɨnɨ. O eŋíná dánɨ ámáyo pɨkíxwɨrɨ́ó yagorɨnɨ. Nepa bɨ mɨrɨpaxɨ́ imónɨŋo eŋagɨ nánɨ pí pí xwɨyɨ́á nɨrɨrɨ́ná yapɨ́nɨ rarɨŋorɨnɨ. O yapɨ́ rarɨŋo imónɨrɨ ámá yapɨ́ rarɨgɨ́á nɨyɨ́yá xanónɨŋɨ́ imónɨrɨ eŋagɨ nánɨ gínɨ gíná yapɨ́ nɨrɨrɨ́ná sa mɨ́kɨ́ xɨ́o imónɨŋɨ́pɨ tɨ́nɨ xɨxenɨ rarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","E nerɨ aí nionɨ nepaxɨŋɨ́ imónɨŋɨ́pɨnɨ seararɨŋagɨ nánɨ ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Soyɨ́né goxɨ ɨ́wɨ́ nánɨ xwɨyɨ́á nɨmeárɨpaxɨ́rɨnɨ? Oweoɨ, wí xwɨyɨ́á nɨmeárɨpaxɨ́manɨ. E nerɨ aí nionɨ nepánɨ seararɨ́ná pí nánɨ ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ámá Gorɨxoyáyɨ́ xwɨyɨ́á xɨ́oyápɨ arɨ́á wiarɨgɨ́árɨnɨ. Soyɨ́né Gorɨxoyáoyɨ́né mimónɨŋagɨ́a nánɨ xwɨyɨ́á oyápɨ arɨ́á mɨniarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judayɨ́ ámɨnáowa omɨ ikayɨ́wɨ́ re urɨgɨ́awixɨnɨ, “None joxɨ re nɨrɨrɨranéná, ‘Ámá sɨpí roxɨyɨ́ Samariayɨ́ woxɨrɨnɨ. Imɨ́ó xɨxéroarɨŋɨ́ roxɨnɨ.’ nɨrɨrɨranéná xɨxenɨ mɨrɨrɨpa réwɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ imɨ́ó dɨŋɨ́ mɨnɨxɨxéroarɨnɨnɨ. Gɨ́ ápomɨ wé íkwiaŋwɨ́yo uŋwɨrárarɨŋagɨ aí soyɨ́né wé íkwiaŋwɨ́yo mɨnɨŋwɨrárarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ seáyɨ e imónɨmɨ́ánɨrɨ mɨyarɨŋagɨ aiwɨ wo nionɨ nánɨ ‘Seáyɨ e oimónɨnɨ.’ niaiwíoyɨ́ soyɨ́né tɨ́nɨ nionɨ tɨ́nɨ neaepayonɨ́o ŋweanɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aga nepa seararɨŋɨnɨ. Ámá gɨyɨ́ gɨyɨ́ xwɨyɨ́á nionɨyápɨ nɨxɨ́dɨrɨ́náyɨ́, wí nɨpepɨ́rɨ́ámanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judayɨ́ ámɨnáowa re urɨgɨ́awixɨnɨ, “Joxɨ e rarɨŋagɨ nánɨ rɨxa nɨjɨ́á re imónɨŋwɨnɨ, ‘Joxɨ imɨ́ó xɨxéroarɨŋɨ́ woxɨnɨ.’ nɨjɨ́á e imónɨŋwɨnɨ. Arɨ́o Ebɨrɨ́amo tɨ́nɨ wɨ́á rókiamoagɨ́áwa tɨ́nɨ pegɨ́árɨnɨ. E éagɨ́a aí joxɨ re rarɨŋɨnɨ, ‘Ámá gɨyɨ́ gɨyɨ́ xwɨyɨ́á nionɨyápɨ nɨxɨ́dɨrɨ́náyɨ́, wí nɨpepɨ́rɨ́ámanɨ.’ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","‘Joxɨ negɨ́ arɨ́o Ebɨrɨ́amo peŋomɨ seáyɨ e mɨwimónɨŋoxɨrɨnɨ.’ neaimónarɨnɨ. Wɨ́á rókiamoagɨ́áwa enɨ pegɨ́árɨnɨ. Joxɨ gonɨrɨnɨ yaiwinarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisaso re urɨŋɨnigɨnɨ, “Niɨwanɨŋonɨ seáyɨ e nɨmɨ́eyoánɨrɨ́náyɨ́, surɨ́má imónárɨpaxɨ́rɨnɨ. Seáyɨ e nɨmɨ́eyoarɨŋo, ayɨ́ gɨ́ áporɨnɨ. O nánɨ soyɨ́né ‘Negɨ́ Ŋwɨ́áorɨnɨ.’ rarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","E nɨrɨro aí xɨ́o nánɨ nepa nɨjɨ́á mimónɨŋoɨ. E nerɨŋɨ́ aiwɨ nionɨ nɨjɨ́árɨnɨ. ‘O nionɨ majɨ́árɨnɨ.’ nɨrɨrɨ́náyɨ́, nionɨ soyɨ́nénɨŋɨ́ yapɨ́ rarɨŋáonɨ imónɨpaxɨ́rɨnɨ. E nerɨ aí o nionɨ nepa nɨjɨ́á nimónɨrɨ nánɨ xwɨyɨ́á oyápɨ xɨ́darɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Segɨ́ arɨ́o Ebɨrɨ́amo sɨ́á nionɨyáyi nánɨ ‘Sɨŋwɨ́ wɨnɨmɨ́árɨ́anɨ?’ nɨyaiwirɨ nánɨ yayɨ́ winɨŋɨnigɨnɨ. Oyɨ, o sɨŋwɨ́ nɨnanɨrɨ yayɨ́ seáyɨmɨ dánɨ winɨŋɨnigɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judayɨ́ ámɨnáowa re urɨgɨ́awixɨnɨ, “Joxɨ sɨnɨ xweyaŋoxɨ meŋɨ́yɨ́ ‘Arɨ́o Ebɨrɨ́amomɨ sɨŋwɨ́ wɨnagáonɨrɨnɨ.’ rɨrarɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisaso re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Arɨ́o Ebɨrɨ́amo sɨnɨ meŋáná nionɨ xámɨ ŋweaagárɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","awa “ ‘Gorɨxo tɨ́nɨ xɨxenɨ imónɨŋorɨ́anɨ?’ oniaiwípoyɨnɨrɨ rɨ́a neararɨnɨ?” nɨyaiwiro omɨ sɨ́ŋá eanɨro nánɨ sɨ́ŋá meáagɨ́a aiwɨ xewanɨŋo re eŋɨnigɨnɨ. Yumɨ́í nimónɨrɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨ peyeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","E nemo nɨpurɨ́ná wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Ámá wo xɨnáí xɨrɨŋe dánɨ sɨŋwɨ́ supárɨŋɨ́ néra uŋo ŋweaŋagɨ wɨnáná ");
INSERT INTO aak_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","xegɨ́ wiepɨsarɨŋowa enɨ sɨŋwɨ́ nɨwɨnɨro yarɨŋɨ́ re wigɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, ɨ́wɨ́ go eŋɨ́pimɨ dánɨ xɨnáí sɨŋwɨ́ supárɨŋɨ́ ro xɨrɨŋɨ́rɨnɨ? Xɨ́o éagɨ nánɨranɨ, xanɨyaú éagɨ́i nánɨranɨ?” yarɨŋɨ́ e wíagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisaso re urɨŋɨnigɨnɨ, “Ámá ro ɨ́wɨ́ éagɨ marɨ́áɨ, xanɨyaú enɨ ɨ́wɨ́ éagɨ́i marɨ́áɨ, sa omɨ dánɨ emɨmɨ́ Gorɨxoyá sɨwánɨŋɨ́ inɨnɨ́a nánɨ e eŋo xɨrɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Agwɨ sɨnɨ ikwáwɨyíná imónɨŋáná emɨmɨ́ nɨrowárénapɨŋo ‘E éwɨnɨgɨnɨ.’ yaiwiarɨŋɨ́pɨ éwanɨgɨnɨ. Árɨ́wɨyíná ámá wo emɨmɨ́ mepaxɨ́ imónɨŋíná rɨxa aŋwɨ e eŋagɨ nánɨ rarɨŋɨnɨ.” urɨŋɨnigɨnɨ. Dɨŋɨ́ re oyaiwípoyɨnɨrɨ, “Xɨ́omɨ pɨkíáná árɨ́wɨyínɨŋɨ́ imónɨnɨ́árɨnɨ.” oyaiwípoyɨnɨrɨ e nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ámɨ re urɨŋɨnigɨnɨ, “Nionɨ xwɨ́á tɨ́yo nɨŋwearɨ́ná ámá nɨ́nɨyɨ́ nánɨ wɨ́á wókímɨxɨŋɨnɨ.” nurárɨmɨ ");
INSERT INTO aak_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","xwɨ́áyo reaŋwɨ́ núrɨmáná xwɨ́á tɨ́nɨ reaŋwɨ́ tɨ́nɨ yiyɨ́ nɨdɨrɨ ámáoyá sɨŋwɨ́yo xópé nɨwimáná ");
INSERT INTO aak_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","re urɨŋɨnigɨnɨ, “Joxɨ nurɨ ipí Siroamɨyɨ rɨnɨŋɨ́wámɨ nánɨ —Yoɨ́ mɨ́kɨ́ ayɨ́ mewárɨnɨŋɨ́ nánɨrɨnɨ. E rɨnɨŋɨ́wámɨ nánɨ nurɨ sɨ́mɨmaŋɨ́yo wayɨ́ róneɨ.” urowárɨ́agɨ o nurɨ sɨ́mɨmaŋɨ́yo wayɨ́ nɨrónɨmáná re eŋɨnigɨnɨ. Rɨxa sɨŋwɨ́ anɨŋo bɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rɨxa sɨŋwɨ́ anɨŋo barɨŋagɨ ámá aŋɨ́ xɨ́o tɨ́ŋɨ́ e ŋweagɨ́áyɨ́ sɨŋwɨ́ e nɨwɨnɨro sɨŋwɨ́ supárɨŋo eŋagɨ nánɨ éɨ́ nɨŋweámáná aiwá nánɨ rɨxɨŋɨ́ urago barɨŋagɨ sɨŋwɨ́ nɨwɨnɨro re nɨra ugɨ́awixɨnɨ, “Ámá royɨ́ e nɨŋweámáná aiwá nánɨ rɨxɨŋɨ́ neararɨŋo menɨranɨ?” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","wí re nɨra ugɨ́awixɨnɨ, “Ayɨ́ orɨnɨ.” nɨra warɨ́ná wí “Oweoɨ, ayɨ́ o yapɨ imónɨŋɨ́yɨ́ worɨnɨ.” nɨra warɨ́ná xewanɨŋo arɨ́kí re urɨŋɨnigɨnɨ, “Nionɨ onɨrɨnɨ.” urarɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ayɨ́ re urɨgɨ́awixɨnɨ, “Joxɨ arɨge nerɨ dɨxɨ́ sɨŋwɨ́ oxoáɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","o re urɨŋɨnigɨnɨ, “Ámá Jisasoyɨ rarɨgɨ́o xwɨ́á bimɨ reaŋwɨ́ núrɨrɨ yiyɨ́ nɨdɨrɨ gɨ́ sɨŋwɨ́yo xópé nɨnimáná re nɨrɨŋoɨ, ‘Joxɨ ipí Siroamɨwámɨ nánɨ nurɨ wayɨ́ róneɨ.’ nɨrɨ́agɨ nionɨ nurɨ wayɨ́ nɨrónɨrɨ́ná re éɨnɨ. Sɨŋwɨ́ noxoarɨ anɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ayɨ́ re urɨgɨ́awixɨnɨ, “Ámá o ge ŋweanɨ?” urɨ́agɨ́a o “Nionɨ majɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","ámá ayɨ́ sɨ́á Jisaso xwɨ́ápimɨ reaŋwɨ́ núrɨrɨ yiyɨ́ nɨdɨrɨ omɨ sɨŋwɨ́ naŋɨ́ wimɨxɨŋɨ́yi Sabarɨ́áyi eŋagɨ nánɨ ámá xámɨ sɨŋwɨ́ supáragomɨ Parisiowa tɨ́ŋɨ́ e nánɨ nɨméra nuro wáráná ");
INSERT INTO aak_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parisiowa enɨ omɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Joxɨ arɨge nerɨ sɨŋwɨ́ oxaóɨ́rɨnɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “O xwɨrɨŋwɨ́ bɨ tɨ́nɨ gɨ́ sɨŋwɨ́yo xópé níáná nionɨ nurɨ wayɨ́ nɨrónɨrɨ́ná sɨŋwɨ́ oxoáɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisiyɨ́ wɨ́a re nɨra ugɨ́awixɨnɨ, “Ámá o Sabarɨ́á nánɨ ŋwɨ́ ikaxɨ́ rɨnɨŋɨ́pimɨ xopɨrárɨ́ nɨyayirɨ nánɨ Gorɨxo tɨ́ŋɨ́ e dánɨ bɨŋomanɨ.” nɨra warɨ́ná wɨ́a re nɨra ugɨ́awixɨnɨ, “Ámá ɨ́wɨ́ yarɨŋɨ́yɨ́ wo eŋánáyɨ́, arɨge nerɨ emɨmɨ́ o yarɨŋɨ́pɨ́nɨŋɨ́ imónɨŋɨ́pɨ epaxɨ́rɨnɨ?” nɨra nuróná dɨŋɨ́ xɨxegɨ́nɨ tɨ́nɨ nepayoro nánɨ ");
INSERT INTO aak_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ámɨ sɨŋwɨ́ supáragomɨ re urɨgɨ́awixɨnɨ, “O dɨxɨ́ sɨŋwɨ́ roxaóɨ́ eŋagɨ nánɨ pí ámáoxɨnɨ rarɨŋɨnɨ?” urɨ́agɨ́a o re urɨŋɨnigɨnɨ, “O Gorɨxoyá wɨ́á rókiamoarɨŋɨ́ wo menɨranɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","O xegɨ́ sɨŋwɨ́ oxoáɨ́yɨ́ nánɨ píránɨŋɨ́ áwaŋɨ́ urarɨŋagɨ aiwɨ xámɨ sɨŋwɨ́ supáragomɨ aiwɨ Judayɨ́ ámɨnáowa arɨ́á mɨwipa nero re yaiwigɨ́awixɨnɨ, “Nepa sɨŋwɨ́ supárago ámɨ sɨŋwɨ́ manɨŋorɨnɨ.” nɨyaiwiro “Ámá sɨŋwɨ́ oxoáoyá xanɨyaú obɨ́piyɨ.” nɨrɨro ayaú rɨxa báná ");
INSERT INTO aak_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","yarɨŋɨ́ nɨwiróná re urɨgɨ́awixɨnɨ, “Niaíwɨ́ ayagwíyáoranɨ? Ayagwí re rɨrarɨŋiɨ, ‘Xɨnáí nɨxɨrɨrɨ́ná sɨŋwɨ́ supárɨŋo xɨrɨŋɨ́rɨnɨ.’ rɨrarɨŋiɨ? E xɨrɨŋɨ́ eŋánáyɨ́, arɨge nerɨ agwɨ sɨŋwɨ́ noxoarɨ anarɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","xanɨyaú re urɨgɨ́isixɨnɨ, “Ayɨ́ yegɨ́ íwo eŋagɨ nánɨ yayawi nɨjɨ́árɨnɨ. Xɨnáí nɨxɨrɨrɨ́ná sɨŋwɨ́ supárɨŋɨ́ eŋɨ́yɨ́ nánɨ enɨ yayawi nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","E nerɨ aí agwɨ o sɨŋwɨ́ oxoáɨ́yɨ́ nánɨ yayawi majɨ́árɨnɨ. Sɨŋwɨ́ supárɨŋɨ́yɨ́ woxoáo nánɨ enɨ yayawi majɨ́árɨnɨ. Xewanɨŋomɨ yarɨŋɨ́ wípoyɨ. Sɨnɨ onomanɨ. Xewanɨŋo nánɨ áwaŋɨ́ osearɨnɨ.” urɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Xanɨyaú Judayɨ́ ámɨnáowa nánɨ wáyɨ́ winɨ́agɨ nánɨ e urɨgɨ́isixɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Judayɨ́ ámɨnáowa re rɨnárɨgɨ́á eŋagɨ nánɨ, “Ámá gɨyɨ́ gɨyɨ́ Jisaso nánɨ waropárɨ́ nero ‘ “O Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨnɨ.” neaimónarɨnɨ.’ ránáyɨ́, rotú aŋɨ́yo dánɨ yoɨ́ emɨ kwɨ́rɨmoanɨ́wárɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","rɨnárɨgɨ́á eŋagɨ nánɨ xanɨyaú re urɨgɨ́isixɨnɨ, “Onomanɨ. Xewanɨŋomɨ yarɨŋɨ́ wípoyɨ.” urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Parisiowa ámɨ “Sɨŋwɨ́ supárago obɨnɨ.” nɨrɨro o rɨxa báná re urɨgɨ́awixɨnɨ, “Joxɨ Gorɨxomɨnɨ seáyɨ e numɨ́eyoarɨ waropárɨ́ ineɨ. Ámá ‘Naŋɨ́ nimɨxɨŋoɨ.’ rarɨŋo ɨ́wɨ́ yarɨŋɨ́yɨ́ wo eŋagɨ nánɨ none nɨjɨ́árɨnɨ. Ayɨnánɨ waropárɨ́ ineɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","o re urɨŋɨnigɨnɨ, “O ɨ́wɨ́ yarɨŋoranɨ? Naŋoranɨ? Nionɨ majɨ́árɨnɨ. E nerɨ aí rɨpɨ nánɨ nionɨ nɨjɨ́árɨnɨ. Xámɨ sɨŋwɨ́ supáragáonɨ aiwɨ agwɨ o níɨ́pimɨ dánɨ sɨŋwɨ́ noxoarɨ anɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","awa re urɨgɨ́awixɨnɨ, “O pí síɨ́rɨnɨ? Arɨge nerɨ dɨxɨ́ sɨŋwɨ́ roxoáɨ́rɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","o re urɨŋɨnigɨnɨ, “Nionɨ rɨxa áwaŋɨ́ searɨ́agɨ aí arɨ́á mɨniarɨŋoɨ. Arɨge nɨyaiwiro ‘Ámɨ arɨ́á osianeyɨ.’ nɨrarɨŋoɨ? Soyɨ́né enɨ rɨxa xegɨ́ wiepɨsarɨŋɨ́yɨ́nɨŋɨ́ imónanɨro mɨrɨpa rɨyarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","awa ikayɨ́wɨ́ numearɨro re urɨgɨ́awixɨnɨ, “Xewanɨŋoxɨnɨ xegɨ́ wiepɨsarɨŋɨ́yɨ́ woxɨrɨnɨ. None neaiepɨsagɨ́ Mosesoyáonerɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","None Mosesomɨ xwɨyɨ́á Gorɨxo urɨŋɨ́pɨ nánɨ nɨjɨ́á imónɨŋwɨnɨ. E nerɨ aí ámá oyɨ́ e dáŋorɨ́anɨrɨ none majɨ́árɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ámá o re urɨŋɨnigɨnɨ, “Soyɨ́né rarɨgɨ́ápɨ ududɨ́ ninɨpaxɨ́ rarɨŋoɨ. Soyɨ́né o bɨŋe dánɨ majɨ́á eŋagɨ́a aiwɨ o gɨ́ sɨŋwɨ́ noxaóɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ámá ɨ́wɨ́ yarɨgɨ́áyɨ́ Gorɨxomɨ rɨxɨŋɨ́ uráná arɨ́á mɨwipa yarɨŋɨ́ eŋagɨ nánɨ nene nɨjɨ́árɨnɨ. E nerɨ aí ámá go go Gorɨxomɨ wéyo numerɨ xɨ́o wimónarɨŋɨ́pɨ nɨxɨ́dɨrɨ́náyɨ́, Gorɨxo ámáomɨ arɨ́á nɨwirɨ xɨ́o rɨxɨŋɨ́ urarɨŋɨ́pɨ nánɨ arɨrá wipaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aga eŋíná dánɨ aí nene arɨ́á wí re mɨwiŋwárɨnɨ, ‘Ámá wo nɨwiápɨ́nɨmearɨ xɨnáí xɨrɨŋe dánɨ sɨŋwɨ́ supárɨŋɨ́ womɨ sɨŋwɨ́ oxoáɨnigɨnɨ.’ rarɨŋagɨ́a arɨ́á mɨwiŋwárɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","re urɨŋɨnigɨnɨ, “Ámá o Gorɨxo tɨ́ŋɨ́ e dánɨ mɨbɨpa nerɨ sɨŋwɨrɨyɨ́, xɨ́o yarɨŋɨ́pɨ bɨ epaxɨ́ imónɨmɨnɨrɨ éɨ́manɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","awa mɨxɨ́ re urɨgɨ́awixɨnɨ, “Ɨ́wɨ́ ninɨrɨŋɨ́pimɨ dánɨ rɨxɨrɨŋoxɨnɨ, joxɨ none rɨnearéwapɨyarɨŋɨnɨ?” nurɨmáná xegɨ́ yoɨ́ emɨ kwɨ́rɨmogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisaso “Ámá sɨŋwɨ́ supáragoyá yoɨ́ kwɨ́rɨmóoɨ.” rarɨŋagɨ́a arɨ́á e nɨwirɨ o nánɨ pɨ́á nemerɨ nɨwímeámáná re urɨŋɨnigɨnɨ, “Joxɨ ámá imónɨŋomɨ dɨŋɨ́ rɨwɨkwɨ́roŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","o re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ámá imónɨŋo gorɨnɨ. Nionɨ dɨŋɨ́ wɨkwɨ́rómɨ nánɨ áwaŋɨ́ nɨreɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisaso re urɨŋɨnigɨnɨ, “Omɨ joxɨ rɨxa sɨŋwɨ́ wɨnɨŋɨ́rɨnɨ.” nurɨrɨ sɨŋánɨ re urɨŋɨnigɨnɨ, “Joxɨ tɨ́nɨ rɨnarɨgwɨ́í ronɨ, ayɨ́ onɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","o re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nionɨ rɨxa dɨŋɨ́ rɨkwɨ́roŋɨnɨ.” nurɨmɨ xɨ́o tɨ́ŋɨ́ e xómɨŋɨ́ nɨyɨkwirɨ yayɨ́ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisaso re rɨŋɨnigɨnɨ, “Ámá nɨyonɨ epayómɨ́a nánɨ xwɨ́á tɨ́yo nánɨ bɨŋárɨnɨ. Ámá sɨŋwɨ́ supárɨgɨ́áyɨ́nɨŋɨ́ imónɨŋɨ́yɨ́ sɨŋwɨ́ anɨpɨ́rɨ imónɨro sɨŋwɨ́ anɨgɨ́áyɨ́nɨŋɨ́ imónɨŋɨ́yɨ́ sɨŋwɨ́ supárɨpɨ́rɨ imónɨro epɨ́rɨ́a nánɨ bɨŋáonɨrɨnɨ.” rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi xɨ́o tɨ́nɨ aŋwɨ e rówapɨgɨ́áwa re urɨgɨ́awixɨnɨ, “None nánɨ enɨ ‘Sɨŋwɨ́ supárɨgɨ́oyɨ́nérɨnɨ.’ rɨneararɨŋɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né sɨŋwɨ́ supárɨgɨ́oyɨ́né sɨŋwɨrɨyɨ́, rɨ́wɨ́ nɨmoarɨgɨ́ápɨ nánɨ xwɨyɨ́á meárɨnɨpaxɨ́manɨ. E nerɨ aí soyɨ́né ‘Sɨŋwɨ́ anɨŋwáonerɨnɨ.’ nɨrɨro nánɨ rɨ́wɨ́ nɨmoarɨgɨ́ápɨ nánɨ xwɨyɨ́á meárɨnɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Aga nepa seararɨŋɨnɨ. Go go sipɨsipɨ́ xwɨ́ná ɨ́wíyo mɨpáwipa nerɨ wí e dánɨ ogámɨ́ nerɨ nɨpɨxemoánɨrɨ́náyɨ́, ɨ́wɨ́ mearɨŋɨ́ wo imónɨnɨ. Ɨ́wɨ́ xauráparɨŋɨ́ wo enɨ imónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","E nerɨ aí xwɨ́ná ɨ́wíyo páwiarɨŋo, ayɨ́ sipɨsipɨ́ xiáworɨnɨ. Awí mearoarɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O xwɨ́ná rónɨŋe nánɨ báná ɨ́wí e íníná awí roŋo ówaŋɨ́ wɨ́kwiíáná xiáwo xegɨ́ sipɨsipɨ́ nánɨ yoɨ́ ráná xiáwoyá maŋɨ́ arɨ́á nɨwirɨ uxɨ́dáná nɨméra nɨpeyearɨ ");
INSERT INTO aak_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","rɨxa xɨ́oyá nɨ́nɨ bɨ́arɨwámɨnɨ eŋáná o xámɨ umearɨ́ná sipɨsipɨ́yɨ́ xiáwoyá maŋɨ́ umɨŋɨ́narɨŋɨ́ eŋagɨ nánɨ númɨ warɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Xeŋwɨ́ womɨ wí númɨ uxɨ́dɨpɨ́rɨméoɨ. Maŋɨ́ ámá xeŋwɨ́ woyá umɨŋɨ́narɨŋagɨ nɨwɨnɨro nánɨ númɨ muxɨ́dɨpa nero éɨ́ upɨ́ráoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisaso ewayɨ́ xwɨyɨ́á apɨ urɨ́agɨ aiwɨ xɨ́o apɨ nánɨ nɨjɨ́á oimónɨ́poyɨnɨrɨ uréwapɨyimɨnɨrɨ yarɨŋɨ́pɨ nánɨ nɨjɨ́á mimónɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O ayɨ́ nɨjɨ́á mimónɨpa yarɨŋagɨ́a nánɨ ámɨ ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Nionɨ sipɨsipɨ́ xwɨ́ná ɨ́wínɨŋɨ́ imónɨŋáonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nionɨ sɨnɨ mɨbɨpa eŋáná bɨgɨ́á gɨyɨ́ gɨyɨ́ ɨ́wɨ́ meaarɨgɨ́áyɨ́nɨŋɨ́ imónɨŋoɨ. Ɨ́wɨ́ xauráparɨgɨ́áyɨ́nɨŋɨ́ enɨ imónɨŋoɨ. E nerɨ aí sipɨsipɨ́yɨ́ wigɨ́ maŋɨ́ arɨ́á mɨwigɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nionɨ niɨwanɨŋonɨ ɨ́wínɨŋɨ́ imónɨŋáonɨrɨnɨ. Gɨyɨ́ gɨyɨ́ nionɨyáyómɨnɨ ɨ́wiapáná yeáyɨ́ uyimɨxemeámɨ́árɨnɨ. Ará wɨwákwínɨ́ epɨ́rɨ́a nánɨ ɨ́wiapɨro peyearo nero epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ɨ́wɨ́ meaarɨŋo sipɨsipɨ́yo pípɨ wimɨnɨrɨ barɨŋɨ́manɨ. Ɨ́wɨ́ xaurápɨrɨ pɨpɨkímɨ́ erɨ xwɨrɨ́á ikɨxerɨ wimɨnɨrɨ barɨŋagɨ aiwɨ xewanɨŋonɨ rɨpɨ wimɨnɨrɨ bɨŋárɨnɨ. Ewáránɨŋɨ́ éɨ́rɨxɨnɨrɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ sɨxɨ́ umímómɨnɨrɨ bɨŋáonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipɨsipɨ́ nánɨ píránɨŋɨ́ awí mearoarɨŋáonɨ, ayɨ́ nionɨrɨnɨ. Sipɨsipɨ́ nánɨ awí píránɨŋɨ́ mearoarɨŋáonɨ sipɨsipɨ́ arɨrá wimɨnɨrɨ nerɨ́ná ‘Nionɨ nɨpɨkíáná ayɨ́ ananɨrɨnɨ.’ yaiwiarɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nɨgwɨ́ meámɨnɨrɨ awí mearoarɨŋɨ́ wo —O sipɨsipɨ́ xiáwo nimónɨrɨ píránɨŋɨ́ awí mearoarɨŋo marɨ́áɨ, o sɨ́wí sayɨ́ sipɨsipɨ́ roanɨmɨnɨrɨ barɨŋagɨ nɨwɨnɨrɨ́ná sipɨsipɨ́ pɨ́nɨ nɨwiárɨmɨ éɨ́ úáná sɨ́wí sayɨ́ rɨrómɨ́ erɨ xɨ́dɨ́xɨ́dowárɨ́ erɨ yarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","O sa nɨgwɨ́ nánɨ meámɨnɨrɨ yarɨŋo eŋagɨ nánɨ sipɨsipɨ́ nánɨ nepa dɨŋɨ́ moarɨŋɨ́manɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","re urɨŋɨnigɨnɨ, “Sipɨsipɨ́ píránɨŋɨ́ awí mearoarɨŋáonɨ, ayɨ́ nionɨrɨnɨ. Ápo tɨ́nɨ nionɨ tɨ́nɨ xɨxe mí ómɨxɨnarɨgwɨ́ípa nionɨ tɨ́nɨ sipɨsipɨ́ nionɨyáyɨ́ tɨ́nɨ enɨ xɨxe mí ómɨxɨnarɨŋwárɨnɨ. ‘Nionɨ gɨ́ sipɨsipɨ́ imónɨŋɨ́yo arɨrá wimɨnɨrɨ nánɨ nupeirɨ́ná ayɨ́ ananɨrɨnɨ.’ yaiwiarɨŋáonɨrɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","re urɨŋɨnigɨnɨ, “Nionɨ sipɨsipɨ́ ámɨ wí —Sipɨsipɨ́ xwɨ́ná tɨ́yo dáŋɨ́ imónɨŋɨ́yɨ́ marɨ́áɨ, ámɨ wí enɨ tɨ́ŋáonɨrɨnɨ. Ayɨ́ wí anɨŋɨ́ e xe ŋweáɨ́rɨxɨnɨrɨ sɨŋwɨ́ wɨnɨpaxɨ́ mimónɨŋɨnɨ. Ayo enɨ wínɨyɨ́ tɨ́ŋɨ́ e awí neaárɨ́ɨmɨgɨnɨ. Ayɨ́ gɨ́ maŋɨ́ arɨ́á nɨniro xwɨ́ná tɨ́yo dáŋɨ́yɨ́ tɨ́nɨ nawínɨ imónɨro awí mearoarɨŋɨ́ ná wonɨ axonɨ tɨ́ŋɨ́ imónɨro epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ámɨ sɨŋɨ́ nimónɨrɨ wiápɨ́nɨmeámɨ́a nánɨ sipɨsipɨ́yo arɨrá wimɨnɨrɨ nerɨ́ná ‘Nionɨ nɨperɨ́ná ayɨ́ ananɨrɨnɨ.’ yaiwiarɨŋagɨ nánɨ ápo dɨŋɨ́ sɨxɨ́ nɨyinɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nionɨ ámá xe onɨpɨkípoyɨnɨrɨ sɨŋwɨ́ mɨwɨnɨpa nerɨ́náyɨ́, wí nɨnɨpɨkipaxɨ́manɨ. Xe onɨpɨkípoyɨnɨrɨ sɨŋwɨ́ wɨnarɨŋáyɨ́ gɨyɨ́ marɨ́áɨ, niɨwanɨŋonɨrɨnɨ. Perɨ ámɨ wiápɨ́nɨmearɨ emɨ́a nánɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́pɨ tɨ́ŋáonɨrɨnɨ. Gɨ́ ápo o e éwɨnɨgɨnɨrɨ sekaxɨ́ nɨrɨŋɨ́ éagɨ nánɨ apɨ e epaxonɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judayɨ́ ámɨnáowa Jisaso e rarɨŋagɨ arɨ́á nɨwiro nánɨ dɨŋɨ́ xɨxegɨ́nɨ tɨ́nɨ nepayoro bɨ bɨ nɨrɨnɨróná ");
INSERT INTO aak_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","wɨ́a obaxowa re nɨra ugɨ́awixɨnɨ “Imɨ́ó dɨŋɨ́ uxɨxéroarɨŋagɨ nánɨ xóxwɨ́ nerɨ rarɨnɨ. Pí nánɨ arɨ́á wiarɨŋoɨ?” nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","wɨ́a re nɨra ugɨ́awixɨnɨ, “Xwɨyɨ́á o rarɨŋɨ́pɨ imɨ́ó xɨxéroarɨŋɨ́ wo yapɨ mɨrɨnarɨnɨnɨ. ‘Ámá imɨ́ó dɨŋɨ́ xɨxéroarɨŋɨ́yɨ́ ámá sɨŋwɨ́ supárɨgɨ́áyo sɨŋwɨ́ woxoapaxɨ́ imónɨŋoɨ.’ rɨseaimónarɨnɨ? Oweoɨ.” nɨra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sɨ́á Judayɨ́ eŋíná émáyɨ́ wa aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ xórórɨ́ nero xwɨrɨ́á ikɨxegɨ́á eŋagɨ nánɨ ámɨ píránɨŋɨ́ imɨxáragɨ́ápɨ sɨ́á apɨ nánɨ dɨŋɨ́ winɨnɨ nánɨ awí neánɨro yayɨ́ yayarɨgɨ́ápɨ imónɨŋáná ");
INSERT INTO aak_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","—Ayɨ́ iniá earɨ imɨŋɨ́ rɨrɨ yarɨŋínárɨnɨ. Íná Jisaso aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ nɨpáwirɨ aŋɨ́ wiámɨ́ó wigɨ́ eŋínaŋɨ́ mɨxɨ́ ináyɨ́ Soromono nánɨ rɨnɨŋɨ́pimɨ emearɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judayɨ́ ámɨnáowa nɨwímearo mɨnɨ mɨnɨ xapɨxapɨ́ numero re urɨgɨ́awixɨnɨ, “Gíná jɨwanɨŋoxɨ nánɨ xe nɨjɨ́á oimónɨ́poyɨnɨrɨ nearɨrɨ́árɨnɨ? Anɨŋɨ́ yumɨ́í neairɨ́áranɨ? Joxɨ Kiraisoxɨ, ámá yeáyɨ́ neayimɨxemearɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáoxɨ eŋánáyɨ́, sɨŋánɨ áwaŋɨ́ nearɨneɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisaso awamɨ re urɨŋɨnigɨnɨ, “Nionɨ rɨxa áwaŋɨ́ searɨ́agɨ aiwɨ soyɨ́né ‘Nepa neararɨnɨ.’ nɨyaiwiro dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ. Emɨmɨ́ gɨ́ ápo e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́ nionɨ yarɨŋápɨ sɨŋánɨ áwaŋɨ́ ayɨ́ orɨnɨ́nɨŋɨ́ seararɨŋagɨ aí ");
INSERT INTO aak_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","soyɨ́né gɨ́ sipɨsipɨ́yɨ́nénɨŋɨ́ mimónɨpa nerɨ nánɨ nionɨ dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipɨsipɨ́ nionɨyáyɨ́ gɨ́ maŋɨ́ arɨ́á nɨniro nɨxɨ́darɨgɨ́árɨnɨ. Nionɨ ayo mí nɨwómɨxɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","dɨŋɨ́ anɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ mɨnɨ wiarɨŋagɨ nánɨ wí anɨ́nɨpɨ́rɨ́á menɨnɨ. Sipɨsipɨ́ nionɨyáyɨ́ nɨnɨwéú tɨ́nɨ ɨ́á xɨrɨŋagɨ nánɨ ámá gɨyɨ́ nɨrápɨpɨ́rɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Gɨ́ ápo sipɨsipɨ́yɨ́ niapɨŋɨ́rɨnɨ. O ámá nɨyonɨ seáyɨ e wimónɨŋagɨ nánɨ nionɨyá gɨ́ imónɨŋɨ́yɨ́ ápo nɨnɨwéɨ́ tɨ́nɨ enɨ ɨ́á xɨrɨŋagɨ nánɨ ámá gɨyɨ́ urápɨpɨ́rɨ́árɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nionɨ tɨ́nɨ ápo tɨ́nɨ axowawirɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judayɨ́ ámɨnáowa xámɨ yanɨro egɨ́ápa sɨ́ŋá tɨ́nɨ Jisasomɨ opɨkianeyɨnɨro meaarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ emɨmɨ́ ápo e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́pɨ obaxɨ́ seaíwapɨyíárɨnɨ. Gɨ́mɨnɨ gɨpɨ seaíwapɨyíápɨ nánɨ sɨ́ŋá tɨ́nɨ nɨpɨkianɨro yarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judayɨ́ ámɨnáowa re urɨgɨ́awixɨnɨ, “Amɨpí naŋɨ́ joxɨ yarɨŋɨ́pɨ wí nánɨ sɨ́ŋá tɨ́nɨ rɨpɨkianɨrɨ mɨyarɨŋwɨnɨ. Joxɨ aga ámáoxɨ eŋagɨ aiwɨ Ŋwɨ́áonɨrɨnɨ́nɨŋɨ́ nɨrɨnɨrɨŋɨ́pimɨ dánɨ Gorɨxomɨ rɨperɨrɨ́ umeararɨŋagɨ nánɨ rɨpɨkianɨrɨ yarɨŋwɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisaso xɨ́omɨ wikɨ́ wónarɨgɨ́ápɨ pɨyɨ́á owépoyɨnɨrɨ re urɨŋɨnigɨnɨ, “Segɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́pimɨ Gorɨxo re rɨŋɨ́pɨ nɨrɨnɨrɨ meánɨpa renɨ, ‘Ŋwɨ́áonɨ re rɨŋanigɨnɨ, “Seyɨ́né enɨ ŋwɨ́aéyɨ́né imónɨŋoɨ.” rɨŋanigɨnɨ.’ nɨrɨnɨrɨ meánɨpa renɨ? ");
INSERT INTO aak_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Soyɨ́né nɨjɨ́árɨnɨ. Xwɨyɨ́á Bɨkwɨ́yo eánɨŋɨ́pɨ wí surɨ́má rɨnɨpaxɨ́ mimónɨnɨ. Ayɨnánɨ Gorɨxo segɨ́ arɨ́owamɨ ‘Seyɨ́né enɨ ŋwɨ́aéyɨ́né imónɨŋoɨ.’ urɨŋɨ́ eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","soyɨ́né pí nánɨ ápo nɨnɨrɨ́pearɨ xwɨ́á tɨ́yo nɨrowárénapɨŋonɨ re searáná, ‘Nionɨ Gorɨxomɨ xewaxonɨrɨnɨ.’ searáná pí nánɨ mɨxɨ́ nɨnɨrɨro ‘Joxɨ Gorɨxomɨ rɨperɨrɨ́ umearɨŋɨnɨ.’ nɨrarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nionɨ emɨmɨ́ gɨ́ ápo e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́pɨ mepa nerɨ́náyɨ́, dɨŋɨ́ nɨnɨkwɨ́roro ‘Nepa orɨnɨ.’ mɨniaiwipa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","E nɨsearɨrɨ aiwɨ nionɨ emɨmɨ́ ápo e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́pɨ nepa nerɨ́náyɨ́, soyɨ́né xwɨyɨ́á nionɨ seararɨŋápɨ arɨ́á nɨniro dɨŋɨ́ mɨnɨkwɨ́ropa nero aí emɨmɨ́ nionɨ yarɨŋagɨ sɨŋwɨ́ nɨnanɨro nánɨ dɨŋɨ́ nɨnɨkwɨ́roro ‘Ayɨ́ orɨnɨ.’ niaiwíɨ́rɨxɨnɨ. ‘Ápo tɨ́nɨ nawínɨ imónɨgɨ́íwaúrɨnɨ. Axowaúrɨnɨ.’ nɨniaiwiro nɨjɨ́á imónɨpɨ́rɨ nánɨ emɨmɨ́ nionɨ yarɨŋápɨ dɨŋɨ́ ɨkwɨ́rópoyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","xámɨ yanɨro egɨ́ápa omɨ ɨ́á oxɨraneyɨnɨro yarɨ́ná ananɨ éɨ́ múroŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisaso ámɨ nurɨ iniɨgɨ́ Jodanɨ rapáyo nɨxerɨ Jono xámɨ ámáyo wayɨ́ umeaiŋe nánɨ nurɨ e ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ámá obaxɨ́ xɨ́o tɨ́ŋɨ́ e nánɨ nɨbɨro re rɨnayigɨ́awixɨnɨ, “Wayɨ́ neameaiŋɨ́ Jono emɨmɨ́ wí mepa nerɨ aiwɨ amɨpí ámá ro nánɨ rɨŋɨ́yɨ́ rɨxa xɨxenɨ imónɨnɨ.” nɨrɨnayiróná ");
INSERT INTO aak_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ámɨ obaxɨ́ wí dɨŋɨ́ wɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ámá wo, Betani dáŋɨ́ Rasarasoyɨ rɨnɨŋo sɨmɨxɨ́ yarɨ́ná —Aŋɨ́ ayɨ́ xɨ́o xegɨ́ xexɨrɨ́meáípaú Mariaí tɨ́nɨ xɨnapí Mataí tɨ́nɨ ípaúyá aŋɨ́ enɨ erɨnɨ. Mariaí ayɨ́ apɨxɨ́ rɨ́wɨ́yo Ámɨnáoyá sɨkwɨ́yo werɨxɨ́ nɨwiwayɨmómáná dɨ́á tɨ́nɨ kwɨ́rɨŋírɨnɨ. Ímɨ xexɨrɨ́meáo Rasaraso sɨmɨxɨ́ wiarɨŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","xɨnapɨxanɨŋípaú Jisaso tɨ́ŋɨ́ e nánɨ xwɨyɨ́á re urowárɨgɨ́isixɨnɨ, “Ámɨnáoxɨnɨ, arɨ́á eɨ. Ámá joxɨ dɨŋɨ́ sɨxɨ́ uyarɨŋoyɨ́ sɨmɨxɨ́ yarɨnɨ.” urowárɨ́agɨ́i aí ");
INSERT INTO aak_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisaso arɨ́á e nɨwirɨ́ná re rɨŋɨnigɨnɨ, “Sɨmɨxɨ́ o yarɨŋɨ́pɨ nɨpenɨ nánɨmanɨ. Ámáyɨ́ eŋɨ́ sɨxɨ́ eánɨŋɨ́ Gorɨxoyá sɨŋwɨ́ wɨnanɨrɨ ero Gorɨxomɨ xewaxonɨ yayɨ́ seáyɨ e dánɨ nɨmeanɨrɨ ero epɨ́rɨ́a nánɨ sɨmɨxɨ́ apɨ wímeaŋɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisaso Mataímɨ tɨ́nɨ xɨnanɨŋímɨ tɨ́nɨ ípaúmɨ xexɨrɨ́meáo Rasarasomɨ tɨ́nɨ ayo dɨŋɨ́ sɨxɨ́ nuyirɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Rasaraso sɨmɨxɨ́ yarɨnɨ.” urɨ́agɨ́a arɨ́á nɨwirɨ́ná ámɨ sɨ́á wɨyaú xɨ́o ŋweaŋe ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","E nɨŋweaŋɨsáná xegɨ́ wiepɨsarɨŋowamɨ re urɨŋɨnigɨnɨ, “Ámɨ Judia pɨropenɨsɨ́yo nánɨ owaneyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Nearéwapɨyarɨŋoxɨnɨ, ayɨ́ xámɨ sɨ́ŋá tɨ́nɨ rɨpɨkianɨrɨ egɨ́e nánɨ ámɨ numɨnɨrɨ rɨneararɨŋɨnɨ?” urɨ́agɨ́a xɨ́o ikwáwɨyínɨŋɨ́ imónɨŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ewayɨ́ xwɨyɨ́á re urɨŋɨnigɨnɨ, “Sogwɨ́ ɨ́wiapɨ́e dánɨ wée nánɨ awá wé wúkaú sɨkwɨ́ waú tɨ́ŋɨ́rɨnɨ. Ámá ikwáwɨyíná aŋɨ́ nerɨ́ná ná eánarɨgɨ́ámanɨ. Xwɨ́á tɨ́yo wɨ́á ókiŋagɨ nánɨ sɨŋwɨ́ píránɨŋɨ́ nɨwɨnaxɨ́da nuro nánɨ ná eánarɨgɨ́ámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","E nerɨ aí ámá árɨ́wɨyimɨ aŋɨ́ nerɨ́ná ná eánarɨgɨ́árɨnɨ. Sɨŋwɨ́ nɨwɨga upɨ́rɨ wɨ́á mókiŋagɨ nánɨ ná eánarɨgɨ́árɨnɨ.” nurɨrɨ ayɨ́ re oyaiwípoyɨnɨrɨ “Gorɨxo wimónarɨŋɨ́pɨ nɨxɨ́dɨrɨ́ná ayɨ́ ikwáwɨyíná aŋɨ́ nemerɨ́nánɨŋɨ́ rɨ́a imónɨnɨ?” oyaiwípoyɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","e nurɨmáná awamɨ re urɨŋɨnigɨnɨ, “Negɨ́ nɨkumɨxɨnɨrɨ emearɨŋwáo Rasaraso sɨmɨxɨ́ nerɨ sá wenɨ. E nerɨ aí nionɨ saiwiárɨ́ wimɨnɨrɨ warɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, sa sánɨ nɨwerɨ́ná ananɨ naŋɨ́ imónɨnɨŋoɨ.” nurɨro ");
INSERT INTO aak_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","awa “Rasaraso sa sá weŋagɨ nánɨ rɨ́a neararɨnɨ?” nɨyaiwiro e urɨ́agɨ́a aí Rasaraso rɨxa péɨ́ nánɨ ínɨmɨ nurɨrɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ámɨ nɨpɨkwɨnɨ sɨŋánɨ áwaŋɨ́ re urɨŋɨnigɨnɨ, “Rasaraso rɨxa pɨyɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E nerɨ aí soyɨ́né sɨŋwɨ́ wɨnɨpɨ́rɨ́pɨ nánɨ yayɨ́ ninarɨnɨ. O sɨmɨxɨ́ yarɨ́ná nionɨ xɨ́o tɨ́nɨ mɨŋweáá eŋagɨ nánɨ soyɨ́né nionɨ emɨ́ápɨ sɨŋwɨ́ nɨnanɨróná dɨŋɨ́ nɨkwɨ́ropɨ́rɨ nánɨ yayɨ́ ninarɨnɨ. O tɨ́ŋɨ́ e nánɨ owaneyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaso —O xegɨ́ yoɨ́ ámɨ bɨ Didimasoyɨ rarɨgɨ́orɨnɨ. O xɨ́o tɨ́nɨ wiepɨsarɨŋɨ́ wɨ́amɨ re urɨŋɨnigɨnɨ, “O tɨ́nɨ nawínɨ peanɨ́wá nánɨ none enɨ owaneyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisaso Rasarasoyá aŋɨ́ tɨ́ŋɨ́ e nánɨ aŋwɨ e nɨbɨrɨ́ná arɨ́á re wiŋɨnigɨnɨ, “O rɨxa nɨperɨ xwárɨpáyo tɨgɨ́ámɨ eŋáná sɨ́á wɨyaú wɨyaú pwéɨ́rɨnɨ.” arɨ́á e wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aŋɨ́ Rasarasoyá Betaniyɨ rɨnɨŋe Jerusaremɨ dánɨ aíwɨmɨmanɨ. Sa kiromita waú wo imónɨŋerɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayɨnánɨ Judia pɨropenɨsɨ́yo dáŋɨ́ obaxɨ́ wí xexɨrɨ́meáo Rasaraso péɨ́ nánɨ Mataímɨ tɨ́nɨ Mariaímɨ tɨ́nɨ ípaúmɨ ogaŋɨ́ wianɨro nánɨ nɨbɨro ípaú tɨ́nɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mataí “Jisaso barɨnɨ.” rɨnarɨŋagɨ́a arɨ́á nɨwirɨ óɨ́ e wirɨmiaumɨnɨrɨ nurɨ xɨnanɨŋí Mariaí sɨnɨ aŋɨ́yo ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","í Jisasomɨ re urémeaŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ re nɨŋwearɨ sɨŋwɨrɨyɨ́, gɨ́ nɨrɨxɨ́meáo nɨpémɨnɨrɨ eŋɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E nerɨ aí niínɨ re nipɨmónarɨnɨ, ‘Gorɨxomɨ pí pí nánɨ yarɨŋɨ́ wíɨ́yɨ́ agwɨ aí ananɨ xɨxenɨ siinɨŋoɨ.’ nipɨmónarɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisaso re urɨŋɨnigɨnɨ, “Dɨxɨ́ rɨrɨxɨ́meáo ámɨ nɨwiápɨ́nɨmeanɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mataí re urɨŋɨnigɨnɨ, “O sɨ́á yoparɨ́yi ámá nɨ́nɨ nɨwiápɨ́nɨmearóná o enɨ wiápɨ́nɨmeanɨ́ápɨ nánɨ niínɨ nɨjɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisaso re urɨŋɨnigɨnɨ, “Ámá pɨyɨ́ egɨ́áyɨ́ ámɨ nɨwiápɨ́nɨmearo sɨŋɨ́ epɨ́rɨ nánɨ dɨŋɨ́ sɨxɨ́ umímoarɨŋáyɨ́, ayɨ́ nionɨrɨnɨ. Nionɨ dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ nɨpero aí ámɨ sɨŋɨ́ upɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ámá sɨŋɨ́ nero dɨŋɨ́ nɨkwɨ́róɨ́á gɨyɨ́ gɨyɨ́ wí anɨ́nɨpɨ́rɨ́á menɨnɨ. Jíxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ ‘O nepa rɨ́a nɨrarɨnɨ?’ rɨniaiwiarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","í re urɨŋɨnigɨnɨ, “Oyɨ, Ámɨnáoxɨnɨ, niínɨ joxɨ dɨŋɨ́ nɨrɨkwɨ́rorɨ re siaiwiarɨŋɨnɨ, ‘Kiraisoxɨ, niaíwɨ́ Gorɨxoyáoxɨrɨ́anɨ? Eŋíná dánɨ re rɨgɨ́oxɨrɨ́anɨ, “Arɨ́owayá xwɨ́á piaxɨ́yo dánɨ ámá wo yeáyɨ́ neayimɨxemeanɨ́a nánɨ iwiaronɨ́árɨnɨ.” rɨgɨ́oxɨrɨ́anɨ?’ siaiwiarɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E nurɨmí nurɨ xɨnanɨŋí Mariaímɨ “Eɨnɨ.” nurɨrɨ yumɨ́í re urɨŋɨnigɨnɨ, “Nearéwapɨyarɨŋo nɨrémónapɨrɨ jíxɨ nánɨ ‘Obɨnɨ.’ rarɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","í arɨ́á e nɨwirɨ́ná aŋɨ́nɨ nɨwiápɨ́nɨmeámɨ Jisaso tɨ́ŋɨ́ e nánɨ uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisaso sɨnɨ aŋɨ́ e mɨrémónapɨ́ sɨnɨ Mataí tɨ́nɨ órórɨ́ inɨ́íe ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judayɨ́ aŋɨ́yo Mariaí tɨ́nɨ nawínɨ nɨŋweámáná ogaŋɨ́ wiarɨgɨ́áyɨ́ í aŋɨ́nɨ nɨwiápɨ́nɨmeámɨ peyeáagɨ nɨwɨnɨro xexɨrɨ́meáoyá xwárɨpáyo ámɨxɨ́á emɨnɨrɨ nánɨ warɨnɨrɨ númɨ úagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaí Jisaso roŋe nɨrémorɨ nɨwɨnɨrɨ́ná xɨ́oyá sɨkwɨ́ tɨ́ŋɨ́ e nɨpɨ́kínɨmearɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ re nɨŋwearɨ sɨŋwɨrɨyɨ́, gɨ́ nɨrɨxɨ́meáo pémɨnɨrɨ eŋɨ́manɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisaso í ámɨxɨ́á yarɨŋagɨ nɨwɨnɨrɨ Judayɨ́ í tɨ́nɨ barɨgɨ́áyɨ́ enɨ ámɨxɨ́á yarɨŋagɨ́a nɨwɨnɨrɨ wá nɨwunɨrɨ xwioxɨ́yo dánɨ dɨŋɨ́ rɨ́á uxearɨŋagɨ ");
INSERT INTO aak_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","re urɨŋɨnigɨnɨ, “Seyɨ́né omɨ ge tɨgɨ́awixɨnɨ?” urɨ́agɨ re urɨgɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, nɨbɨrɨ sɨŋwɨ́ wɨneɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisaso enɨ ŋwɨ́ eaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ŋwɨ́ eáagɨ Judayɨ́ sɨŋwɨ́ e nɨwɨnɨro re rɨgɨ́awixɨnɨ, “Omɨ aga dɨŋɨ́ sɨxɨ́ uyiŋo eŋagɨ nánɨ rɨ́a eaarɨnɨ?” rarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","wí re rɨgɨ́awixɨnɨ, “Ámá royɨ́ sɨŋwɨ́ supárɨŋomɨ sɨŋwɨ́ mɨwoxoapa eŋɨ́ranɨ? Rasaraso sɨnɨ sɨŋɨ́ eŋɨ́mɨ nɨbɨrɨ sɨŋwɨrɨyɨ́, pɨyɨ́ mepa oenɨrɨ sɨŋɨ́ imɨxɨmɨnɨrɨ mepa epaxɨ́rɨ́anɨ?” rɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisaso ámɨ wá bɨ nɨwunɨrɨ́ná oyá xwárɨpá —Awá sɨ́ŋá óɨ́yi eŋagɨ nánɨ sɨ́ŋá wo pɨ́roárɨnɨŋɨ́wárɨnɨ. Awá tɨ́ŋɨ́ e nɨrémorɨ ");
INSERT INTO aak_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","re rɨŋɨnigɨnɨ, “Sɨ́ŋá ro rɨwómópoyɨ.” uráná peŋomɨ xexɨrɨ́meáí Mataí re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, nene omɨ tɨŋwaé dánɨ sɨ́á wɨyaú wɨyaú rɨxa órɨŋɨ́ eŋagɨ nánɨ rɨxa pɨyaŋɨ́ neaeanɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ re mɨrɨrɨpa réanigɨnɨ, ‘Jíxɨ dɨŋɨ́ nɨnɨkwɨ́rorɨ́náyɨ́, eŋɨ́ eánɨŋɨ́ Gorɨxoyápɨ sɨŋwɨ́ wɨnɨrɨ́ɨnɨ.’ mɨrɨrɨpa réanigɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","wa sɨ́ŋá emɨ rɨwómóáná Jisaso aŋɨ́namɨ sɨŋwɨ́ nanánɨrɨ re rɨŋɨnigɨnɨ, “Ápoxɨnɨ, Rasaraso nánɨ rɨxɨŋɨ́ wurɨyíápɨ arɨ́á níagɨ nánɨ yayɨ́ siarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nionɨ rɨxɨŋɨ́ rɨránáyɨ́, joxɨ íníná arɨ́á niarɨŋagɨ nánɨ nionɨ nɨjɨ́á aiwɨ oxɨ́ apɨxɨ́ re rogɨ́á tɨ́ dɨŋɨ́ nɨnɨkwɨ́roro ‘Gorɨxo urowárénapɨŋorɨ́anɨ?’ oniaiwípoyɨnɨrɨ rɨrarɨŋɨnɨ.” nɨrɨmáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eŋɨ́ tɨ́nɨ nɨrɨrɨ rɨ́aiwá re rɨŋɨnigɨnɨ, “Rasarase, ɨ́wiapeɨ.” ráná ");
INSERT INTO aak_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","re eŋɨnigɨnɨ. Peŋo ɨ́wiapɨŋɨnigɨnɨ. Peŋo ɨ́wiapáná írɨkwɨ́ wí wéyo tɨ́nɨ sɨkwɨ́yo tɨ́nɨ xopɨxopɨ́ rónɨrɨ rapɨrapɨ́ wú tɨ́nɨ mɨŋɨ́yo xopɨxopɨ́ rónɨrɨ eŋagɨ nánɨ Jisaso re urɨŋɨnigɨnɨ, “Xopɨxopɨ́ rónɨŋɨ́yɨ́ íkwɨ́kweámɨ́ nɨwiro wárɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judayɨ́ obaxɨ́ wí Mariaí tɨ́ŋɨ́ e nánɨ bɨ́áyɨ́ Jisaso e éagɨ nɨwɨnɨro omɨ dɨŋɨ́ wɨkwɨ́róagɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","wí Parisiowa tɨ́ŋɨ́ e nánɨ nuro Jisaso éɨ́pɨ nánɨ áwaŋɨ́ urɨ́agɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Parisiowa tɨ́nɨ Jisaso nánɨ xwɨyɨ́á imɨxanɨro nánɨ Judayɨ́ mebáowamɨ awí neaárɨro re nɨrɨga ugɨ́awixɨnɨ, “Ámá oyɨ́ emɨmɨ́ ayá wí yarɨŋagɨ nánɨ arɨre yanɨ́wárɨnɨ?” nɨra nurɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","re rɨnɨgɨ́awixɨnɨ, “None o xegɨ́ yarɨŋɨ́pɨ xe anɨŋɨ́ néra ounɨrɨ sɨŋwɨ́ nɨwɨnárɨrɨ́náyɨ́, ámá nɨ́nɨ omɨ dɨŋɨ́ nɨwɨkwɨ́roro neróná Romɨ dáŋɨ́yo —Ámá Romɨyɨ́ rɨnɨgɨ́áyɨ́ Judayɨ́ sɨmaŋwɨ́yónɨŋɨ́ ínɨmɨ wurɨ́nɨgɨ́áyɨ́rɨnɨ. ‘Ámá ayo mɨxɨ́ oxɨ́dowáraneyɨ.’ rarɨ́ná ayɨ́ nɨbɨro negɨ́ aŋɨ́ rɨdɨyowá yarɨŋwáiwá pɨpɨnamɨ́ ero negɨ́ ámáyo enɨ xwɨrɨ́á ikɨxero epɨ́rɨxɨnɨrɨ nánɨ arɨ yanɨ́wárɨ́anɨ?” rɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","wigɨ́yɨ́ wo, Kaiapasoyɨ rɨnɨŋo —O xwiogwɨ́ omɨ dánɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋorɨnɨ. O nɨwiápɨ́nɨmearɨ mɨxɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Soyɨ́né aga nɨjɨ́á bɨ mimónɨgɨ́oyɨ́nérɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Rɨpɨ nánɨ enɨ dɨŋɨ́ neŋwɨpero mɨmoarɨŋoɨ, ‘Negɨ́ ámá nɨ́nɨ pepɨ́rɨxɨnɨrɨ ayɨ́ rɨ́nɨŋɨ́ meaanɨrɨ éɨ́ápɨ nánɨ ámá ná wonɨ rɨ́nɨŋɨ́ apɨ nɨmearɨ nɨperɨ́náyɨ́, negɨ́ dɨŋɨ́yo dánɨ naŋɨ́rɨnɨ.’ mɨmoarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O rɨŋɨ́pɨ xegɨ́ dɨŋɨ́yo dánɨ mɨrɨŋɨnigɨnɨ. O xwiogwɨ́ omɨ dánɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋo eŋagɨ nánɨ wɨ́á nɨrókiamorɨ rénɨŋɨ́ rɨŋɨnigɨnɨ, “Jisaso negɨ́ Judayo arɨrá nɨwirɨ́ná upeinɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Negɨ́ Judayɨ́ nánɨnɨ marɨ́áɨ, Gorɨxoyá niaíwɨ́ imónɨgɨ́á amɨ gɨmɨ ŋweagɨ́áyɨ́ enɨ ámá axɨ́yɨ́nɨŋɨ́ imónɨpɨ́rɨ́a nánɨ upeinɨŋoɨ.” énɨŋɨ́ rɨ́agɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","sɨ́á ayimɨ dánɨ xɨ́omɨ pɨkianɨro nánɨ mekaxɨ́ nɨra ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jisaso xɨ́omɨ pɨkianɨro mekaxɨ́ nɨra warɨŋagɨ́a nánɨ Judayɨ́ tɨ́ŋɨ́ e ámɨ sɨŋánɨŋe memepa nerɨ ámá dɨŋɨ́ meaŋɨ́ tɨ́ŋɨ́mɨnɨ omɨŋɨ́ tɨ́ŋɨ́ e nánɨ nurɨ aŋɨ́ onɨmiá bɨ Ipɨremɨyɨ rɨnɨŋɨ́pimɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nawínɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi aŋwɨ e imónɨŋagɨ nánɨ ámá obaxɨ́ sɨ́á ayi sɨnɨ mimónɨpa eŋáná Judayɨ́ wigɨ́ yarɨgɨ́ápa Gorɨxo oneamímɨnɨrɨ igɨ́á eánanɨro nánɨ wigɨ́ omɨŋɨ́ tɨ́ŋɨ́mɨnɨ pɨ́nɨ nɨwiárɨmɨ Jerusaremɨyo nánɨ nuro ");
INSERT INTO aak_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","e dánɨ Jisaso nánɨ pɨ́á nemero aŋɨ́ rɨdɨyowá yarɨgɨ́iwáyá ákɨŋáyo ínɨrɨwámɨnɨ éɨ́ nɨromeróná re nɨrɨga ugɨ́awixɨnɨ, “ ‘O aiwá rɨpɨ nánɨ wí mɨbɨpa epaxɨ́rɨnɨ.’ rɨseaimónarɨnɨ?” nɨrɨga ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ Parisiowa tɨ́nɨ Jisasomɨ ɨ́á oxɨraneyɨnɨróná re rɨnárɨgɨ́á eŋagɨ nánɨ “Jisaso ge ge ŋweaŋagɨ ámá go go nɨwɨnɨrɨ́ná nɨbɨro áwaŋɨ́ nearɨ́ɨ́rɨxɨnɨ.” rɨnárɨgɨ́á eŋagɨ nánɨ e nɨrɨga ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jisaso sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi imónɨnɨ́a nánɨ sɨ́á wé wɨ́úmɨ dáŋɨ́ wo sɨnɨ eŋáná o aŋɨ́ Betaniyɨ rɨnɨŋe Rasaraso, ámɨ sɨŋɨ́ imɨxɨŋo ŋweaŋɨ́pimɨ nánɨ nurɨ ŋweaŋáná ");
INSERT INTO aak_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ámá aŋɨ́ apimɨ dáŋɨ́ wí aiwá Jisaso nánɨ rɨ́á nɨyearo Mataí aiwá nɨxerɨ yaŋɨ́ nɨwia warɨ́ná Rasaraso ámá Jisaso tɨ́nɨ aiwá narɨgɨ́áyɨ́ tɨ́nɨ nawínɨ nɨŋweámáná aiwá narɨ́ná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariaí werɨxɨ́ awiaxɨ́ nɨgwɨ́ xwé roŋɨ́ wá —Sɨxɨ́ wɨ́xaú eŋáná xegɨ́ saŋɨ́ kiro wo imónɨpaxɨ́wárɨnɨ. Awá nɨmearɨ Jisasomɨ sɨkwɨ́ sosɨ́áyo niwayɨmómáná xegɨ́ dɨ́á tɨ́nɨ kwɨkwɨ́rɨmɨ́ yarɨ́ná xegɨ́ sinadɨŋɨ́ ámá aŋiwámɨ ŋweagɨ́áyo nɨyonɨ weaárɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Isɨkariotɨ dáŋɨ́ Judaso —O wiepɨsarɨŋowa enɨ worɨnɨ. Jisaso nánɨ mɨyɨ́ wurɨmɨ́ánɨrɨ imónɨŋo, ayɨ́ orɨnɨ. O nɨwiápɨ́nɨmearɨ re rɨŋɨnigɨnɨ, ");
INSERT INTO aak_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Pí nánɨ werɨxɨ́ dɨŋɨ́ naŋɨ́ eaarɨŋɨ́ awá ámáyo K300.00 nánɨ bɨ́ nerane nɨgwɨ́ meáwápɨ ámá uyípeayɨ́yo arɨrá wianɨ nánɨ mɨnɨ mɨwipa réwɨnɨ?” rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O uyípeayɨ́yo dɨŋɨ́ sɨpí nɨwirɨ nánɨ e murɨ́ ɨ́wɨ́ meaarɨŋorɨnɨ. Ayɨnánɨ nɨgwɨ́ wowɨ́yɨ́ o ɨ́á nɨxɨrɨrɨ nánɨ nɨgwɨ́ wa tɨ́ápɨ bɨ ɨ́wɨ́ meaarɨŋo eŋagɨ nánɨ e rɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisaso re rɨŋɨnigɨnɨ, “Í niarɨŋɨ́pɨ xe owinɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ. Sɨ́á nionɨ nɨtɨpɨ́rɨ́áyimɨ e nánɨ xe oxɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ámá uyípeayɨ́ sɨnɨ seyɨ́né tɨ́nɨ anɨŋɨ́ ŋweapɨ́rɨ́á eŋagɨ nánɨ ayo gínɨ gíná ‘Arɨrá owianeyɨ.’ nɨseaimónɨrɨ́náyɨ́, ananɨ arɨrá wipaxɨ́rɨnɨ. E nerɨ aiwɨ nionɨ seyɨ́né tɨ́nɨ nawínɨ anɨŋɨ́ re ŋweámɨ́á meŋagɨ nánɨ seararɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judayɨ́ obaxɨ́ “Jisaso aŋɨ́ apimɨ ŋweanɨ.” rɨnarɨŋagɨ́a arɨ́á nɨwiro Jisasomɨnɨ sɨŋwɨ́ wɨnanɨro marɨ́áɨ, Rasaraso, sɨŋɨ́ imɨxɨŋomɨ enɨ wɨnanɨro bɨ́agɨ́a aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa xwɨyɨ́á nimɨxɨro “Rasarasomɨ enɨ pɨkíwanɨgɨnɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jisaso Rasaraso pɨyomɨ sɨŋɨ́ imɨxɨŋɨ́ eŋagɨ nánɨ Judayɨ́ obaxɨ́ wigɨ́ ámɨnáowa tɨ́ámɨnɨ pɨ́nɨ nɨwiárɨmɨ nuro Jisasomɨ dɨŋɨ́ wɨkwɨ́roarɨŋagɨ́a sɨŋwɨ́ nɨwɨnɨro nánɨ e nɨrɨnɨro mekaxɨ́ megɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ámá obaxɨ́ aiwá sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi nánɨ imɨxarɨgɨ́ápɨ nánɨ Jerusaremɨyo epɨ́royɨ́ egɨ́áyɨ́ sá wegɨ́á wɨ́ápɨ tɨ́nɨ arɨ́á re wigɨ́awixɨnɨ, “Jisaso Jerusaremɨyo re nánɨ barɨnɨ.” arɨ́á e nɨwiro ");
INSERT INTO aak_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","írɨmɨŋɨ́ eaarɨgɨ́áyɨ́ wí nɨdoro o tɨ́nɨ óɨ́ e órórɨ́ inanɨro nánɨ nɨmeámɨ nuróná apɨ́ re nɨra ugɨ́awixɨnɨ, “Gorɨxomɨ seáyɨ e oumeaneyɨ. Ámá Gorɨxo urowárénapɨŋɨ́ royɨ́ oyá dɨŋɨ́ tɨ́nɨ seáyɨ e oimónɨnɨ. O mɨxɨ́ ináyɨ́ Isɨrerene negorɨnɨ.” O tɨ́nɨ óɨ́ e órórɨ́ inanɨro apɨ́ e nɨra warɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Jisaso Bɨkwɨ́yo re nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ eŋɨnigɨnɨ, “Saionɨ —Jerusaremɨ nánɨ dɨ́wɨ́ yoɨ́ bɨ Saionɨrɨnɨ. Apimɨ ŋweáyɨ́né sɨŋwɨ́ wɨnɨ́poyɨ. Segɨ́ mɨxɨ́ ináyo dogí sɨpɨkɨ́yo nɨŋweámáná iwo barɨŋagɨ nánɨ amɨpí wí nánɨ wáyɨ́ mepanɨ.” nɨrɨnɨrɨ eánɨŋɨ́pɨ tɨ́nɨ xɨxenɨ o dogí sɨpɨkɨ́ wo nɨmearɨ seáyɨ e nɨxeŋwearɨ nɨmeámɨ bɨŋɨnigɨnɨ. E éagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","axínáyɨ́ wiepɨsarɨŋowa xɨ́o yarɨŋɨ́pɨ nánɨ “Ayɨ́ nánɨ rɨ́a yarɨnɨ?” mɨyaiwí majɨ́á néra núɨ́asáná Jisaso rɨxa nikɨ́nɨrɨ nɨwiápɨ́nɨmeámɨ aŋɨ́namɨ nánɨ nɨpeyimáná eŋáná xɨ́o nánɨ e nɨrɨnɨrɨ eánɨŋɨ́pɨ nánɨ dɨŋɨ́ winɨrɨ ámá ayɨ́ xɨ́omɨ seáyɨ e numero wigɨ́ápɨ nánɨ enɨ dɨŋɨ́ winɨrɨ egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ámá Jisaso Rasaraso xwárɨpáyo weŋáná “Ɨ́wiapeɨ.” nurɨrɨ sɨŋɨ́ imɨxarɨ́ná xɨ́o tɨ́nɨ e nɨŋwearo sɨŋwɨ́ wɨnarogɨ́áyɨ́ o éɨ́pɨ nánɨ repɨyɨ́ nɨwiéra emearɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ámá epɨ́royɨ́ egɨ́áyɨ́ emɨmɨ́ xɨ́o eŋɨ́ apɨ nánɨ repɨyɨ́ néra warɨŋagɨ́a arɨ́á wíɨ́á eŋagɨ nánɨ o tɨ́nɨ óɨ́ e órórɨ́ inanɨro nánɨ ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ayɨnánɨ Parisiowa re rɨnɨgɨ́awixɨnɨ, “Sɨŋwɨ́ wɨnɨ́poyɨ. Ámá obaxɨ́ tɨ́nɨ barɨŋagɨ́a nánɨ none o nánɨ rɨnárɨ́wápɨ arɨge yanɨ́wɨnɨ? Sɨŋwɨ́ wɨnɨ́poyɨ. Oxɨ́ apɨxɨ́ sɨ́wí niaíwɨ́ nɨ́nɨ omɨ rɨxa númɨ barɨŋoɨ.” rɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ámá sɨ́á aiwá apɨ imɨxarɨgɨ́ápimɨ Gorɨxomɨ seáyɨ e umeanɨro nánɨ úɨ́áyɨ́ wí ámá Gɨrikɨyɨ rɨnɨŋɨ́yɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ayɨ́ Piripomɨ —O wiepɨsarɨŋowa wo aŋɨ́ Betɨsaida rɨnɨŋɨ́ Gariri pɨropenɨsɨ́yo ikwɨ́rónɨŋɨ́pimɨ dáŋorɨnɨ. Ayɨ́ omɨ nɨwímearo rɨxɨŋɨ́ re urɨgɨ́awixɨnɨ, “Rároxɨnɨ, ‘Jisasomɨ sɨŋwɨ́ owɨnaneyɨ.’ neaimónarɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piripo nurɨ xexɨrɨ́meáo Adɨruomɨ áwaŋɨ́ nurɨmɨ awaú nuri Jisasomɨ áwaŋɨ́ urɨ́agɨ́i ");
INSERT INTO aak_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisaso ámá ayo re urɨnɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ seáyɨ e nimónɨrɨ ikɨ́nɨmɨ́a nánɨ rɨxa aŋwɨ ayorɨnɨ.” nurɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ewayɨ́ xwɨyɨ́á bɨ xɨ́o penɨ́ápɨ nánɨ re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Witɨ́ siyɨ́ wo urɨ́ nerɨ xwɨ́áyo mɨpiéropa nerɨ́náyɨ́, xegɨ́pɨ ropaxɨ́rɨnɨ. Urɨ́ nerɨ xwɨ́áyo nɨpiérorɨ́náyɨ́, ná obaxɨ́ wepaxɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ámá xewanɨŋo nánɨnɨ ayá rɨmɨxɨnɨ́ɨ́ go go anɨ́nɨmɨxɨnɨnɨ́árɨnɨ. Ámá xewanɨŋo nánɨnɨ ayá mɨrɨmɨxɨnɨ́ ámá wíyo nánɨ enɨ ayá urɨmɨxɨnɨ́ɨ́ go go manɨ́nɨmɨxɨnɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́ŋo imónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ámá ‘Jisaso wimónarɨŋɨ́pɨ éɨmɨgɨnɨ.’ yaiwiarɨŋɨ́ go go nionɨ nɨxɨ́dɨ́wɨnɨgɨnɨ. Nionɨ amɨ gɨmɨ ŋweáámɨ ‘Jisaso wimónarɨŋɨ́pɨ éɨmɨgɨnɨ.’ yaiwíɨ́ go go xɨ́o enɨ e ŋweanɨ́árɨnɨ. Ámá nionɨ e éɨrɨxɨnɨrɨ nimónarɨŋɨ́pɨ yarɨŋɨ́ gomɨ gomɨ ápo wé íkwiaŋwɨ́yo uŋwɨrárɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Agwɨ ríná rɨxa dɨŋɨ́ rɨ́á nɨxearɨŋagɨ ápomɨ píoɨ urɨmɨ́ɨnɨ? ‘Ápoxɨnɨ, xeanɨŋɨ́ nionɨ nímeanɨ́pɨ “Mɨwímeapa oenɨ.” osimónɨnɨ.’ urɨmɨnɨréɨnɨ? Oweoɨ, ríná apɨ onímeanɨrɨ nánɨ bɨŋá eŋagɨ nánɨ wí e urɨmɨméɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","‘Ápoxɨnɨ, dɨxɨ́ yoɨ́ seáyɨ e imɨxɨrɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ joxɨyápɨ ámáyo sɨwá wirɨ éɨrɨxɨnɨ.’ rɨrarɨŋɨnɨ.” ráná re eŋɨnigɨnɨ. Aŋɨ́namɨ dánɨ xwɨyɨ́á bɨ re rɨnénapɨŋɨnigɨnɨ, “Nionɨ emɨmɨ́ joxɨ nɨwíwapɨyirɨŋɨ́pimɨ dánɨ gɨ́ yoɨ́ rɨxa seáyɨ e nimɨxɨrɨ gɨ́ eŋɨ́ sɨxɨ́ eánɨŋɨ́pɨ sɨwá nɨwirɨ aiwɨ ámɨ bɨ tɨ́nɨ sɨwá wimɨ́ɨnɨ.” rɨnénapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Xwɨyɨ́á e rɨnénapɨ́agɨ ámá e epɨ́royɨ́ nero rówapɨgɨ́áyɨ́ arɨ́á e nɨwiro nánɨ wí “Sa akɨrɨwɨ́ rarɨnɨ.” rarɨ́ná wí “Aŋɨ́najɨ́ wo xɨ́omɨ urɨŋoɨ.” rarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisaso ayɨ́ e rɨnarɨŋagɨ́a arɨ́á nɨwirɨ re urɨŋɨnigɨnɨ, “Maŋɨ́ apá nionɨ nánɨ mɨrɨnénapɨŋoɨ. Seyɨ́né dɨŋɨ́ mopɨ́rɨ nánɨ rɨnénapɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gorɨxo ámá xwɨ́á tɨ́yo dáŋɨ́yo xwɨyɨ́á umeárɨnɨ rɨxa aŋwɨ ayorɨnɨ. Xwɨ́á rɨrímɨ meŋweaŋo —O oborɨnɨ. Omɨ xopɨrárɨ́ winɨ enɨ aŋwɨ ayorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Niɨwanɨŋonɨ xwɨ́ámɨ dánɨ seáyɨ e nɨmɨ́eyoááná nionɨyá dɨŋɨ́yo dánɨ ámá nɨ́nɨ nionɨ tɨ́ámɨnɨ bɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","xewanɨŋomɨ íkɨ́áyo nɨyekwɨroárɨrɨ́ná penɨ́ápɨ nánɨ dɨŋɨ́ omópoyɨnɨrɨ e urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ámá e epɨ́royɨ́ egɨ́áyɨ́ re urɨgɨ́awixɨnɨ, “Negɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo dánɨ ‘Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáo, anɨŋɨ́ íníná ŋweanɨ́árɨnɨ.’ rɨnɨŋagɨ arɨ́á wiŋwá eŋagɨ nánɨ joxɨ arɨge nerɨ ‘Ámá imónɨŋomɨ nɨpɨkiro íkɨ́áyo nɨŋwɨrárɨro seáyɨ e umɨ́eyoapɨ́rɨ́árɨnɨ.’ neararɨŋɨnɨ? Ámá imónɨŋoyɨ́ gorɨnɨ?” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisaso xewanɨŋo wɨ́ánɨŋɨ́ eŋagɨ nánɨ ewayɨ́ xwɨyɨ́á bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Wɨ́ápɨ sɨ́á árɨ́nɨ́ wíyo seyɨ́né tɨ́ŋɨ́ e ónɨnɨŋoɨ. Sɨ́á seaórɨnɨgɨnɨrɨ sɨnɨ wɨ́á ónɨŋáná aŋɨ́ époyɨ. Ámá sɨ́á yinɨŋɨ́mɨ yarɨgɨ́áyɨ́ ‘Amɨ iyɨ́ rɨwarɨŋɨnɨ?’ mɨyaiwiarɨgɨ́á eŋagɨ nánɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wɨ́ápɨ sɨnɨ seyɨ́né tɨ́nɨ nɨŋwearɨ seaónɨŋáná wɨ́ápiyá niaíwɨ́yɨ́nénɨŋɨ́ wimónɨpɨ́rɨ́a nánɨ wɨ́ápimɨ dɨŋɨ́ wɨkwɨ́rópoyɨ.” urɨŋɨnigɨnɨ. O xwɨyɨ́á apɨ nurárɨmɨ pɨ́nɨ nɨwiárɨmɨ nurɨ pɨ́nɨ́ ŋweaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Judayɨ́ Jisaso wigɨ́ sɨŋwɨ́ tɨ́ŋɨ́ e dánɨ emɨmɨ́ ayá wí wíwapɨyíagɨ aí sɨnɨ dɨŋɨ́ mɨwɨkwɨ́ró nero “Ayɨ́ orɨ́anɨ?” mɨyaiwigɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ayɨ́ rɨpɨ nánɨ e egɨ́awixɨnɨ. Xwɨyɨ́á wɨ́á rókiamoagɨ́ Aisaiaoyɨ rɨnɨŋo xegɨ́ Judayɨ́ nánɨ nɨrɨrɨ eaŋɨ́ rɨpɨ, “Ámɨnáoxɨnɨ, negɨ́ repɨyɨ́ wiarɨŋwápɨ gɨyɨ́ ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ neaɨkwɨ́rogɨ́árɨnɨ? Oweoɨ. Ámɨnáoxɨnɨyá eŋɨ́ sɨxɨ́ eánɨŋɨ́pɨ gɨyo sɨwá wíáná mí nómɨxɨro nɨjɨ́á imónɨgɨ́árɨnɨ? Oweoɨ.” nɨrɨrɨ eaŋɨ́pɨ xɨxenɨ imónɨnɨ́a nánɨ Judayɨ́ Jisasomɨ dɨŋɨ́ mɨwɨkwɨ́rogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Xwɨyɨ́á ámɨ bɨ Aisaiao nɨrɨrɨ eaŋɨ́ rɨpɨ, “Ámá ayɨ́ píránɨŋɨ́ sɨŋwɨ́ wɨnɨro dɨŋɨ́ píránɨŋɨ́ moro neróná sanɨŋɨ́ nimónɨro wigɨ́ ɨ́wɨ́ yarɨgɨ́ápɨ emɨ nɨmamoro ámɨ Gorɨxo tɨ́ámɨnɨ upɨ́rɨxɨnɨrɨ sɨŋwɨ́ upɨ́rorɨ dɨŋɨ́ sɨ́ŋánɨŋɨ́ wimɨxɨrɨ eŋɨ́rɨnɨ.” Aisaiao e nɨrɨrɨ eaŋɨ́pɨ xɨxenɨ imónɨnɨ́a nánɨ Judayɨ́ Jisasomɨ dɨŋɨ́ mɨwɨkwɨ́ropaxɨ́ imónɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiao orɨŋá nɨwɨnɨrɨ́ná Gorɨxo urowárénapɨnɨ́o nikɨ́nɨrɨ ŋweaŋagɨ nɨwɨnɨrɨ nánɨ o nánɨ e rɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judayɨ́ nɨ́nɨ Jisasomɨ dɨŋɨ́ mɨwɨkwɨ́roarɨŋagɨ́a aiwɨ Judayɨ́ ámɨná obaxɨ́ wí aí omɨ dɨŋɨ́ nɨwɨkwɨ́roro aiwɨ Parisiowa negɨ́ rotú aŋɨ́yo dánɨ yoɨ́ emɨ neakwɨ́rɨmopɨ́rɨxɨnɨrɨ wáyɨ́ nero nánɨ waropárɨ́ ninɨro “Jisasomɨ xɨ́darɨŋáonɨrɨnɨ.” mɨrɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Weyɨ́ Gorɨxo umearɨŋɨ́pɨ nánɨ mɨwimónɨpa nerɨ weyɨ́ ámá umearɨgɨ́ápɨ nánɨ nɨwimónɨrɨ nánɨ waropárɨ́ ninɨro “Jisasomɨ xɨ́darɨŋáonɨrɨnɨ.” mɨrɨnɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisaso eŋɨ́ tɨ́nɨ rɨ́aiwá nɨrɨrɨ re rɨŋɨnigɨnɨ, “Nionɨ dɨŋɨ́ nɨkwɨ́roarɨgɨ́á gɨyɨ́ gɨyɨ́ nionɨnɨ dɨŋɨ́ mɨnɨkwɨ́roarɨŋoɨ. Nɨrowárénapɨŋomɨ enɨ dɨŋɨ́ wɨkwɨ́roarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nionɨ sɨŋwɨ́ nanarɨgɨ́á gɨyɨ́ gɨyɨ́ nɨrowárénapɨŋomɨ enɨ sɨŋwɨ́ wɨnarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ámá nionɨ dɨŋɨ́ nɨkwɨ́róɨ́áyɨ́ anɨŋɨ́ sɨ́á yinɨŋe mɨŋweapa éɨ́rɨxɨnɨrɨ xwɨ́á tɨ́yo wɨ́ánɨŋɨ́ wókímɨxɨmɨnɨrɨ bɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nionɨ ámá xwɨ́á tɨ́yo ŋweagɨ́áyo xwɨyɨ́á umeárɨmɨnɨrɨ mɨbɨ́ ámá nɨyonɨ yeáyɨ́ uyimɨxemeámɨ́ánɨrɨ bɨŋárɨnɨ. Ayɨnánɨ ámá xwɨyɨ́á nionɨ rarɨŋápɨ arɨ́á nɨniro aí mɨnɨxɨ́dɨ́á gɨyɨ́ gɨyo nionɨ wí xwɨyɨ́á umeárarɨŋámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ámá nionɨ rɨ́wɨ́ nɨnɨmoro xwɨyɨ́á nionɨ rarɨŋápɨ peayɨ́ nɨwianɨro éɨ́áyɨ́ wonɨ wonɨ xwɨyɨ́á meárɨnɨpaxɨ́pɨ rɨxa wenɨ. Xwɨyɨ́á nionɨ uráná arɨ́á mɨnigɨ́áyo dánɨ sɨ́á yoparɨ́yimɨ xwɨyɨ́á meárɨnɨpaxɨ́ eŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nionɨ gɨ́ dɨŋɨ́yo dánɨ wí mɨrɨ́ ápo, xewanɨŋo nɨrowárénapɨŋo amɨpí nionɨ urɨmɨ́ápɨ nánɨ sekaxɨ́ nɨrɨŋɨ́ eŋagɨ nánɨ gɨ́ dɨŋɨ́yo dánɨ rarɨŋámanɨ. ");
INSERT INTO aak_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ápo sekaxɨ́ rɨŋɨ́pimɨ ámá dɨŋɨ́ nɨkwɨ́rorɨŋɨ́pimɨ dánɨ dɨŋɨ́ nɨyɨmɨŋɨ́ tɨ́gɨ́á anɨŋɨ́ íníná ŋweapɨ́rɨ́a nánɨ imónɨpaxɨ́ eŋagɨ nánɨ nionɨ nɨjɨ́árɨnɨ. Ayɨnánɨ amɨpí nionɨ seararɨŋápɨ, ápo nɨrɨŋɨ́pɨnɨ seararɨŋárɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aiwá sɨ́á Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi nánɨ sɨnɨ mimɨxɨpa eŋáná Jisaso xwɨ́á tɨ́yo pɨ́nɨ nɨwiárɨmɨ xano tɨ́e nánɨ yinɨ aŋwɨ ayo eŋagɨ nánɨ o nɨjɨ́árɨnɨ. Ámá xɨ́o xegɨ́ imónɨgɨ́áyo dɨŋɨ́ sɨxɨ́ nuya nɨbɨ́ɨsáná xɨ́o pene nánɨ aí nuya uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sɨ́ápɨ tɨ́nɨ xɨ́o tɨ́nɨ wiepɨsarɨŋowa tɨ́nɨ aiwá apɨ nanɨro nánɨ awí neánɨmáná Obo re eŋɨnigɨnɨ. Saimonomɨ xewaxo Isɨkariotɨ dáŋɨ́ Judaso nurɨ Jisaso nánɨ mɨyɨ́ ourɨnɨrɨ dɨŋɨ́ nɨwɨkwɨ́rómáná eŋáná ");
INSERT INTO aak_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisaso xegɨ́ xano amɨpí nɨ́nɨ ɨ́ánɨŋɨ́ wiepɨ́xɨ́niasiŋɨ́ eŋagɨ nánɨ nɨjɨ́á imónɨrɨ Gorɨxo tɨ́ámɨnɨ bɨŋɨ́pɨ nánɨ nɨjɨ́á imónɨrɨ ámɨ xɨ́o tɨ́ámɨnɨ unɨ́ápɨ nánɨ enɨ nɨjɨ́á imónɨrɨ nerɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","aiwá narɨgɨ́e dánɨ nɨwiápɨ́nɨmearɨ xegɨ́ rapɨrapɨ́ e pánɨŋɨ́yɨ́ nɨpírárɨmáná roarɨxɨ́ wú nɨmearɨ írɨŋɨ́yo nɨkɨ́kɨyinɨmáná ");
INSERT INTO aak_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","iniɨgɨ́ pɨrerɨxɨ́ wɨnamɨ niwayɨmorɨ wiepɨsarɨŋowamɨ sɨkwɨ́ sosɨ́áyo igɨ́á nɨweáa nurɨ roarɨxɨ́ kɨ́kɨyinɨŋú tɨ́nɨ nɨkwɨ́ra nurɨ ");
INSERT INTO aak_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","rɨxa Saimonɨ Pitaomɨ wimɨnɨrɨ yarɨ́ná re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ gɨ́ sɨkwɨ́yo igɨ́á neámɨnɨrɨ rɨyarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ simɨ́pɨ nánɨ agwɨ joxɨ majɨ́á nimónɨrɨ aiwɨ rɨ́wéná ‘E níwapɨyimɨnɨrɨ rɨ́a eŋɨnigɨnɨ?’ nɨyaiwirɨ nɨjɨ́á imónɨrɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitao re urɨŋɨnigɨnɨ, “Ná rɨ́wɨ́yo aiwɨ joxɨ gɨ́ sɨkwɨ́yo wí igɨ́á nearɨ́á menɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Nionɨ dɨxɨ́ sɨkwɨ́yo igɨ́á mɨreapa nerɨ́náyɨ́, joxɨ nionɨ tɨ́nɨ nawínɨ kumɨxɨnɨpaxɨ́ mimónɨŋɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimonɨ Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, sɨkwɨ́yonɨ igɨ́á mɨneapanɨ. Gɨ́ wéyo tɨ́nɨ mɨŋɨ́yo tɨ́nɨ aí igɨ́á neaɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisaso re urɨŋɨnigɨnɨ, “Igɨ́á eánɨŋɨ́ go go kíyɨ́ bɨ meŋagɨ nánɨ sa sɨkwɨ́yonɨ igɨ́á eánɨpaxɨ́ imónɨnɨ. Soyɨ́né kíyɨ́ bɨ meŋagɨ aiwɨ noyɨ́nénɨ marɨ́á.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Xɨ́o nánɨ mɨyɨ́ wurɨno nánɨ nɨjɨ́á nimónɨrɨ nánɨ “Noyɨ́nénɨ kíyɨ́ mayoyɨ́némanɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Rɨxa sɨkwɨ́yo igɨ́á nɨweáa núɨsáná xegɨ́ rapɨrapɨ́ nɨmearɨ nɨyínɨrɨ aiwá narɨgɨ́e ámɨ éɨ́ nɨŋwearɨ re urɨŋɨnigɨnɨ, “Nionɨ seaíápɨ nánɨ dɨŋɨ́ ‘Ayɨ́ nánɨ rɨ́a neaiarɨnɨ?’ rɨmoŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Soyɨ́né ‘Nearéwapɨyarɨŋoxɨnɨ́ nɨrɨro ‘Ámɨnáoxɨnɨ́ nɨrɨro yarɨgɨ́árɨnɨ. E imónɨŋáonɨ eŋagɨ nánɨ e nɨnɨrɨróná xɨxenɨ nɨrarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nionɨ Ámɨnáonɨ imónɨrɨ searéwapɨyarɨŋáonɨ imónɨrɨ eŋagɨ aiwɨ segɨ́ sɨkwɨ́ sosɨ́áyo igɨ́á seaeáɨnɨ. Ayɨnánɨ soyɨ́né enɨ segɨ́ sɨkwɨ́yo xɨxe igɨ́á eánɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nionɨ rɨxa sɨŋwepɨgɨ́ seaíwapɨyíagɨ nánɨ nionɨ seaíápa soyɨ́né enɨ axɨ́pɨ e niga úɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aga nepa seararɨŋɨnɨ. Ámá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋɨ́yɨ́ go xegɨ́ bosomɨ seáyɨ e wimónarɨŋɨ́rɨnɨ? Xwɨyɨ́á yaŋɨ́ wiowárɨŋo enɨ urowárɨŋomɨ seáyɨ e wimónarɨŋɨ́ranɨ?” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","re urɨŋɨnigɨnɨ, “Soyɨ́né nionɨ sɨŋwepɨgɨ́ seaíwapɨyíá apɨ nánɨ nɨjɨ́á nimónɨro xɨxenɨ nerɨ́náyɨ́, yayɨ́ seainɨpaxɨ́ seaímeanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nionɨ noyɨ́nénɨ nánɨ mɨseararɨŋɨnɨ. Searɨ́peárɨŋáoyɨ́né imónɨgɨ́ápɨ nánɨ nionɨ nɨjɨ́á aiwɨ Bɨkwɨ́yo re nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ, ‘Ámá nionɨ tɨ́nɨ aiwá nawínɨ narɨgwɨ́ío nionɨ xopɨrárɨ́ nimɨnɨrɨ sɨkwɨ́ nɨmɨ́eyoarɨ sosɨ́á neanɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨ́wɨnɨgɨnɨrɨ noyɨ́nénɨ searɨ́peaŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Soyɨ́né amɨpí rɨ́wɨ́yo imónɨnɨ́pɨ imónarɨŋagɨ nɨwɨnɨróná ‘Ayɨ́ orɨ́anɨ?’ niaiwipɨ́rɨ nánɨ agwɨ re dánɨ amɨpí sɨnɨ mimónɨpa éɨ́mɨ áwaŋɨ́ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aga nepa seararɨŋɨnɨ. Ámá nionɨ urowárarɨŋáyo umímɨnɨpɨ́rɨ́á gɨyɨ́ gɨyɨ́ nionɨ enɨ nɨmímɨnarɨŋoɨ. Nionɨ nɨmímɨnɨpɨ́rɨ́áyɨ́ nɨrowárénapɨŋomɨ enɨ umímɨnarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisaso e nurɨ́ɨsáná dɨŋɨ́ rɨ́á uxéagɨ sɨŋánɨ áwaŋɨ́ nurɨrɨ re urɨŋɨnigɨnɨ, “Aga nepa seararɨŋɨnɨ. Soyɨ́né woxɨ mɨyɨ́ nurɨnɨŋoɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","xegɨ́ wiepɨsarɨŋowa o rɨ́o nánɨ majɨ́á eŋagɨ́a nánɨ kɨ́kɨ́mí nimónɨro sɨŋwɨ́ nainega nuróná ");
INSERT INTO aak_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","wiepɨsarɨŋowa wo —O Jisaso xɨ́o dɨŋɨ́ sɨxɨ́ uyiŋorɨnɨ. O xɨ́o tɨ́ŋɨ́ e aŋwɨ e éɨ́ ŋweaŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimonɨ Pitao omɨ sɨ́mɨmajɨ́ó nɨwirɨ́ná rénɨŋɨ́ urɨŋɨnigɨnɨ, “Joxɨ yarɨŋɨ́ nɨwirɨ ámá xɨ́o rɨ́o nánɨ áwaŋɨ́ reɨ.” Énɨŋɨ́ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","wiepɨsarɨŋo xɨ́o tɨ́ámɨnɨ nɨkɨnɨmónaumáná yarɨŋɨ́ re wiŋɨnigɨnɨ ‘Ámɨnáoxɨnɨ, joxɨ rɨ́o, ayɨ́ gorɨnɨ?’ urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisaso re urɨŋɨnigɨnɨ, “Aiwápimɨ múyo neagwirɨ wimo, ayɨ́ orɨnɨ.” nurɨmáná aiwápɨ múyo neagwirɨ Isɨkariotɨ dáŋɨ́ Saimonomɨ xewaxo Judasomɨ mɨnɨ wiŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mɨnɨ wíáná Seteno Judasomɨ dɨŋɨ́ xɨxéróagɨ Jisaso re urɨŋɨnigɨnɨ, “Joxɨ erɨ́pɨ aŋɨ́nɨ eɨ.” urɨ́agɨ aí ");
INSERT INTO aak_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","xɨ́o tɨ́nɨ aiwá narɨgɨ́áwa o Judaso e oenɨrɨ urɨ́ɨ́pɨ nánɨ majɨ́á nero ");
INSERT INTO aak_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","wí dɨŋɨ́ re yaiwigɨ́awixɨnɨ, “Judaso nɨgwɨ́ wowɨ́ xɨrɨŋo eŋagɨ nánɨ re rɨ́a urɨŋoɨ, ‘Aiwá Aŋɨ́najɨ́ Neamúroagɨ́ rɨpɨ nánɨ nanɨ́pɨ joxɨ bɨ́ neaiɨ.’ rɨ́a urɨŋoɨ? ‘Uyípeayɨ́yo arɨrá wimɨnɨrɨ nánɨ amɨpí bɨ mɨnɨ wiɨ.’ rɨ́a urɨŋoɨ?” yaiwiarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judaso, múyo neagwirɨ wíɨ́pɨ nurápanɨmo árɨ́wɨyimɨ peyeaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","O rɨxa peyeááná Jisaso re rɨŋɨnigɨnɨ, “Ámá imónɨŋáonɨ rɨxa seáyɨ e imónɨ́agɨ ámáyɨ́ sɨŋwɨ́ nanɨpɨ́rɨ rɨxa rínárɨnɨ. Nionɨ e éagɨ nɨnanɨrɨ́ná Gorɨxoyá eŋɨ́ sɨxɨ́ eánɨŋɨ́pɨ nánɨ enɨ nɨjɨ́á imónɨpɨ́ráoɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nionɨ e nimónɨrɨŋɨ́pimɨ dánɨ Gorɨxoyá eŋɨ́ eánɨŋɨ́ sɨŋánɨ nimónɨrɨ́náyɨ́, nionɨ enɨ seáyɨ e nɨnimɨxɨrɨ nɨniinɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gɨ́ niaíwoyɨ́né, sɨnɨ soyɨ́né tɨ́nɨ bɨ onɨmiápɨ ŋweámɨ́ɨnɨ. Soyɨ́né nionɨ nánɨ pɨ́á nipɨ́rɨ́á eŋagɨ aiwɨ negɨ́ Judayo re urɨŋápa, ‘Nionɨ umɨ́aé soyɨ́né enɨ wí upaxɨ́ menɨnɨ.’ urɨŋápa agwɨ soyɨ́né enɨ axɨ́pɨ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","re urɨŋɨnigɨnɨ, “Nionɨ ŋwɨ́ ikaxɨ́ sɨŋɨ́ bɨ osearɨmɨnɨ. Nionɨ dɨŋɨ́ sɨxɨ́ seayarɨŋápa soyɨ́né enɨ axɨ́pɨ xɨxe dɨŋɨ́ sɨxɨ́ yinɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sewanɨŋoyɨ́né dɨŋɨ́ sɨxɨ́ xɨxe nɨyinɨrɨ́náyɨ́, ámá sɨŋwɨ́ nɨseanɨro re seaiaiwipɨ́rɨ́árɨnɨ, ‘Oyá wiepɨsiŋowarɨ́anɨ?’ seaiaiwipɨ́rɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimonɨ Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ gɨmɨ umɨnɨrɨ nánɨ neararɨŋɨnɨ?” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Agwɨ nionɨ ume agwɨ joxɨ wí mɨnɨxɨ́dɨpaxɨ́ eŋagɨ aí rɨ́wéná joxɨ ananɨ nɨxɨ́dɨrɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitao re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, pí nánɨ ‘Agwɨ joxɨ mɨnɨxɨ́dɨpaxɨ́rɨnɨ.’ nɨrarɨŋɨnɨ? Joxɨ éɨ́ rɨmínɨmɨnɨrɨ nánɨ yarɨ́ná nionɨ nɨpɨkirɨ́náyɨ́, ananɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ nepa nionɨ éɨ́ nɨmínɨrɨ nánɨ rɨpɨkipaxoxɨranɨ? Aga nepa rɨrarɨŋɨnɨ, ‘Karɨ́karɨ́ sɨnɨ rɨ́aiwá mɨrɨpa eŋáná joxɨ biaú bɨ nionɨ nánɨ “O nánɨ nionɨ majɨ́árɨnɨ.” rɨrɨ́ɨnɨ.’ rɨrarɨŋɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wiepɨsarɨŋɨ́yo “Soyɨ́né dɨŋɨ́ rɨ́á mɨseaxepanɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Gorɨxomɨ dɨŋɨ́ wɨkɨ́roro nionɨ enɨ dɨŋɨ́ nɨkwɨ́roro éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aŋɨ́ gɨ́ ápoyáyo awawá obaxɨ́ ikwɨ́rónɨnɨ. Nionɨ soyɨ́né nánɨ aŋɨ́ wé searoárimɨ́á eŋagɨ nánɨ aŋɨ́ awawá ayɨ́ mikwɨ́rónɨpa nerɨ sɨŋwɨrɨyɨ́, ananɨ áwaŋɨ́ searɨmɨnɨrɨ eŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nionɨ nurɨ aŋɨ́ wé nɨsearoárimɨ ámɨ nɨbɨrɨ soyɨ́né enɨ nionɨ ŋweámɨ́aé nionɨ tɨ́nɨ nawínɨ ŋweapɨ́rɨ́a nánɨ nɨseairɨménapɨmɨ umɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Óɨ́ nionɨ aŋɨ́ apimɨ nánɨ umɨ́áyi nánɨ soyɨ́né nɨjɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ urɨ́e nánɨ none majɨ́á nerane nánɨ arɨge óɨ́ urɨ́áyi nánɨ nɨjɨ́á imónɨŋwɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisaso re urɨŋɨnigɨnɨ, “Ámá ‘Gorɨxo tɨ́ŋɨ́ e nánɨ úɨmɨgɨnɨ.’ wimónarɨŋɨ́yo nánɨ niɨwanɨŋonɨ óɨ́yínɨŋɨ́ imónɨŋáonɨrɨnɨ. Amɨpí Gorɨxo nánɨ nepa imónɨŋɨ́pɨ ámá ayo sɨwá wirɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ sɨxɨ́ umímorɨ yarɨŋáonɨrɨnɨ. Ámá wo óɨ́ wɨyimɨ dánɨ ápo tɨ́ŋɨ́ e nánɨ wímeapaxɨ́manɨ. Nionɨnɨ óɨ́ ápo tɨ́e nánɨyínɨŋɨ́ imónɨŋáonɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Soyɨ́né nionɨ nánɨ ‘Orɨ́anɨ?’ nɨniaiwiro píránɨŋɨ́ nɨjɨ́á nimónɨro sɨŋwɨrɨyɨ́, gɨ́ ápo nánɨ enɨ píránɨŋɨ́ nɨjɨ́á imónanɨro egɨ́árɨnɨ. E nɨsearɨrɨ aiwɨ agwɨ ríná dánɨ soyɨ́né o nánɨ nɨjɨ́á nimónɨro sɨŋwɨ́ wɨnɨgɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piripo re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, joxɨ ápo sɨwá neaíáná ‘Ayɨ́ apánɨrɨnɨ.’ neaimónarɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisaso re urɨŋɨnigɨnɨ, “Piripe, nionɨ soyɨ́né tɨ́nɨ eŋíná dánɨ emeŋá aiwɨ joxɨ nionɨ nánɨ sɨnɨ píránɨŋɨ́ nɨjɨ́á mimónɨpa reŋɨnɨ? Ámá nionɨ sɨŋwɨ́ nanɨ́á gɨyɨ́ gɨyɨ́ ápomɨ enɨ wɨnɨ́áyɨ́ eŋagɨ nánɨ joxɨ pí nánɨ ‘Ápo enɨ sɨwá neaiɨ.’ nɨrarɨŋɨnɨ? ");
INSERT INTO aak_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ápo xewaxonɨ tɨ́nɨ nawínɨ imónɨrai xewaxonɨ ápo tɨ́nɨ nawínɨ imónɨrai eŋagwɨ́i nánɨ joxɨ sɨnɨ ‘O xano tɨ́nɨ axowaúrɨ́anɨ?’ nɨniaiwirɨ dɨŋɨ́ mɨnɨkwɨ́roarɨŋɨ́ reŋɨnɨ? Xwɨyɨ́á nionɨ seararɨŋápɨ gɨ́ dɨŋɨ́yo dánɨ seararɨŋámanɨ. Amɨpí nionɨ yarɨŋápɨ enɨ ápo, nionɨ tɨ́nɨ nawínɨ imónɨgwɨ́íoyá dɨŋɨ́yo dánɨ yarɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xwɨyɨ́á nionɨ re searɨ́ápɨ, ‘Ápo nionɨ tɨ́nɨ nawínɨ imónɨrai nionɨ ápo tɨ́nɨ nawínɨ imónɨrai eŋwiɨ.’ searɨ́ápɨ nánɨ ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ nɨkwɨ́rópoyɨ. ‘E oyaneyɨ.’ mɨseaimónɨpa nerɨ́náyɨ́, emɨmɨ́ amɨpí nionɨ nɨseaíwapɨya barɨ́ná soyɨ́né sɨŋwɨ́ wɨnɨgɨ́ápɨ nánɨnɨ ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ nɨkwɨ́rópoyɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aga nepa seararɨŋɨnɨ. Nionɨ dɨŋɨ́ nɨkwɨ́roarɨgɨ́á gɨyɨ́ gɨyɨ́ amɨpí nionɨ seaíwapɨyarɨŋápɨ enɨ epɨ́rɨ́árɨnɨ. Oyɨ, nionɨ ápo tɨ́e umɨ́á eŋagɨ nánɨ amɨpí nionɨ seaíwapɨyarɨŋápimɨ wiárɨ́ seáyɨ e imónɨŋɨ́pɨ aí epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Xewaxonɨ eŋɨ́ eánɨŋɨ́ ápoyá ámáyo sɨwá nɨwirɨŋɨ́pimɨ dánɨ ‘Ápo seáyɨ e imónɨŋorɨ́anɨ?’ wiaiwíɨ́rɨxɨnɨrɨ soyɨ́né pí pí nánɨ ápomɨ rɨxɨŋɨ́ nurɨrɨ́ná xegɨ́ xewaxonɨmɨ dánɨ nurɨrɨ rɨxɨŋɨ́ uránáyɨ́, nionɨ ananɨ xɨxenɨ nɨseaiimɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Amɨpí ápomɨ rɨxɨŋɨ́ nurɨrɨ́ná nionɨmɨ dánɨ nurɨrɨ rɨxɨŋɨ́ urɨ́ápɨ nionɨ ananɨ nɨseaiimɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Soyɨ́né nionɨ dɨŋɨ́ sɨxɨ́ nɨnɨyirɨ́náyɨ́, nionɨ sekaxɨ́ searɨŋápɨ xɨxenɨ xɨ́dɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nionɨ ápomɨ rɨxɨŋɨ́ uráná arɨrá seaipaxɨ́ imónɨŋɨ́ ámɨ wo soyɨ́né tɨ́nɨ nawínɨ anɨŋɨ́ íníná ŋweáwɨnɨgɨnɨrɨ segɨ́ tɨ́ámɨnɨ urowárénapɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kwíyɨ́ xɨ́o nánɨ nepa imónɨŋɨ́pɨnɨ seaíwapɨyarɨŋɨ́pɨ nánɨ rarɨŋɨnɨ. Ámá xɨ́omɨ dɨŋɨ́ mɨwɨkwɨ́roarɨgɨ́áyɨ́ kwíyɨ́ xɨ́oyápimɨ mí nɨwómɨxɨro nɨjɨ́á mimónɨpaxɨ́ eŋagɨ nánɨ arɨrá wimɨnɨrɨ enɨ́ápɨ umímɨnɨpaxɨ́ menɨnɨ. E nerɨ aí kwíyɨ́pɨ rɨxa soyɨ́né tɨ́nɨ nawínɨ imónɨŋagɨ nánɨ apɨ nánɨ nɨjɨ́á imónɨŋoɨ. Idáná soyɨ́né enɨ nɨseaímearɨ xwioxɨ́yo seaŋweanɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nionɨ wimiáoyɨ́nénɨŋɨ́ segɨ́pɨ nɨseawárɨmɨ umɨ́ámanɨ. Ámɨ soyɨ́né tɨ́ŋɨ́ e nánɨ bɨmɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ámá nionɨ dɨŋɨ́ mɨnɨkwɨ́roarɨgɨ́áyɨ́ sɨŋwɨ́ mɨnanɨpa epɨ́rɨ nánɨ aŋwɨ ayorɨnɨ. E nerɨ aí soyɨ́né ámɨ sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ. Nionɨ ámɨ sɨŋɨ́ emɨ́a eŋagɨ nánɨ soyɨ́né enɨ sɨŋɨ́ epɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sɨ́á soyɨ́né nionɨ ámɨ sɨŋɨ́ éáná nanɨpɨ́rɨ́áyimɨ re nɨyaiwiro nɨjɨ́á imónɨpɨ́rɨ́árɨnɨ, ‘O xano tɨ́nɨ imónɨrɨ eŋáná none xɨ́o tɨ́nɨ imónɨrane xɨ́o none tɨ́nɨ imónɨrɨ eŋagwɨ nánɨ xɨ́o tɨ́nɨ axonerɨnɨ.’ nɨyaiwiro nɨjɨ́á imónɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ámá go go gɨ́ sekaxɨ́ rarɨŋápɨ ɨ́á nɨxɨrɨrɨ nɨxɨ́dɨrɨ́náyɨ́, nionɨ dɨŋɨ́ sɨxɨ́ nɨyarɨŋorɨnɨ. Nionɨ dɨŋɨ́ sɨxɨ́ nɨyarɨŋɨ́ gomɨ gomɨ gɨ́ ápo dɨŋɨ́ sɨxɨ́ uyirɨ nionɨ uyirɨ nerɨ niɨwanɨŋonɨ nánɨ yumɨ́í bɨ mɨwí xɨxenɨ sɨwá winɨmɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judaso —Isɨkariotɨ dáŋɨ́ Judaso marɨ́áɨ, wiepɨsarɨŋowa Judasoyɨ rɨnɨŋɨ́ worɨnɨ. O re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, pí éagɨ nánɨ ámá nɨ́nɨ xwɨ́á tɨ́yo ŋweagɨ́áyo sɨwá mɨwinɨpa nerɨ newanɨŋonenɨ sɨwá neainɨrɨ́árɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisaso re urɨŋɨnigɨnɨ, “Ámá go go nionɨ dɨŋɨ́ sɨxɨ́ nɨnɨyirɨ́náyɨ́, xwɨyɨ́á nionɨ rarɨŋápɨ xɨ́dɨnɨ́árɨnɨ. Omɨ gɨ́ ápo dɨŋɨ́ sɨxɨ́ nuyirɨ yawawi o tɨ́ámɨnɨ nɨbɨrai o tɨ́nɨ nawínɨ anɨŋɨ́ ŋweanɨ́wárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ámá nionɨ dɨŋɨ́ sɨxɨ́ mɨnɨyarɨgɨ́áyɨ́ nionɨ rarɨŋápɨ xɨ́darɨgɨ́ámanɨ. Xwɨyɨ́á nionɨ seararɨ́ná soyɨ́né arɨ́á niarɨgɨ́ápɨ, ayɨ́ nionɨ gɨ́ dɨŋɨ́ tɨ́nɨ rarɨŋápɨmanɨ. Ápo nɨrowárénapɨŋoyá dɨŋɨ́ tɨ́nɨ rarɨŋápɨrɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","re urɨŋɨnigɨnɨ, “Nionɨ sɨnɨ soyɨ́né tɨ́nɨ nɨŋwearɨ́ná amɨpí apɨ nánɨ searɨ́ɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","E nerɨ aí rɨ́wéná arɨrá seainɨ́o —O kwíyɨ́ Gorɨxoyápɨrɨnɨ. Xɨ́o ámá nionɨ nɨxɨ́darɨgɨ́áyo nánɨ urowárénapɨnɨ́ápɨrɨnɨ. Apɨ amɨpí nɨ́nɨ nánɨ seaíwapɨyíáná nionɨ nɨseara warɨŋá nɨpɨnɨ nánɨ dɨŋɨ́ seainɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nionɨ soyɨ́né pɨ́nɨ nɨseawiárɨmɨ nurɨ aiwɨ soyɨ́né nionɨyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro ŋweapɨ́rɨ́árɨnɨ. Nionɨyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro ŋweapɨ́rɨ́ápɨ nánɨ nɨrɨrɨ́ná ámá xwɨ́á tɨ́yo dáŋɨ́ wigɨ́ dɨŋɨ́ tɨ́nɨ yarɨgɨ́ápɨ nánɨ mɨrarɨŋɨnɨ. Nionɨyá dɨŋɨ́ tɨ́nɨ aga nɨwayɨrónɨro ŋweapɨ́rɨ́a nánɨ imónɨpɨ́rɨ́árɨnɨ. Ayɨnánɨ dɨŋɨ́ rɨ́á nɨseaxerɨ wáyɨ́ bɨ minɨpa éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xwɨyɨ́á nionɨ searɨ́á rɨpɨ, ‘Nionɨ pɨ́nɨ nɨseawiárɨmɨ nurɨ ámɨ seyɨ́né tɨ́ŋɨ́ e nánɨ bɨmɨ́árɨnɨ.’ searɨ́ápɨ soyɨ́né rɨxa arɨ́á níoɨ. Nionɨ ápo tɨ́ŋɨ́ e nánɨ umɨ eŋagɨ nánɨ soyɨ́né nepa dɨŋɨ́ sɨxɨ́ nɨnɨyirɨ́náyɨ́, yayɨ́ seáyɨmɨ dánɨ seainɨmɨnɨrɨ éɨ́rɨnɨ. Ápo seáyɨ e nɨmúroŋo eŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Soyɨ́né nionɨ searɨ́ápɨ xɨxenɨ imónɨ́agɨ nɨwɨnɨrɨ́ná dɨŋɨ́ nɨkwɨ́roro ‘Ayɨ́ o nearɨŋɨ́pɨrɨ́anɨ?’ yaiwiro oépoyɨnɨrɨ sɨnɨ mimónɨpa éɨ́mɨ seararɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","re urɨŋɨnigɨnɨ, “Xwɨ́á tɨ́yo meŋweaŋo —O oborɨnɨ. O rɨxa barɨŋagɨ nánɨ nionɨ soyɨ́né tɨ́nɨ nɨŋwearɨ ámɨ ayá wí searɨmɨméɨnɨ. O nionɨ eŋɨ́ mɨneánɨŋo eŋagɨ aiwɨ ");
INSERT INTO aak_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ nɨ́nɨ re niaiwíɨ́rɨxɨnɨrɨ, ‘O xanomɨ dɨŋɨ́ sɨxɨ́ uyiŋorɨ́anɨ?’ niaiwíɨ́rɨxɨnɨrɨ ápo sekaxɨ́ nɨrɨŋɨ́pɨ tɨ́nɨ xɨxenɨ oemɨnɨ.” nurɨrɨ re urɨŋɨnigɨnɨ, “Re dánɨ nɨwiápɨ́nɨmeámɨ rɨxa owaneyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisaso ewayɨ́ xwɨyɨ́á nurɨrɨ re urɨŋɨnigɨnɨ, “Wainɨ́ uraxɨ́ nepaxɨŋɨ́ imónɨŋɨ́pɨ, ayɨ́ nionɨrɨnɨ. Wainɨ́ omɨŋɨ́ xiáwo gɨ́ áporɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wireŋɨ́ nionɨmɨ dánɨ neánɨrɨ ná mɨwéɨ́yɨ́ nɨ́nɨ ápo emɨ wixɨmoarɨŋɨ́rɨnɨ. Wireŋɨ́ ná wearɨŋɨ́yɨ́ nɨ́nɨ xwiogwɨ́ wɨ́omɨ ná xwé wéwɨnɨgɨnɨrɨ o emɨ wɨwákwímɨ́ nɨyárɨmáná mɨ́á imɨxárarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Xwɨyɨ́á nionɨ seararɨŋápimɨ dánɨ soyɨ́né rɨxa mɨ́ánɨŋɨ́ inɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Soyɨ́né uraxɨ́ wireŋɨ́ eánɨŋɨ́pa axɨ́pɨ nionɨ neánɨ́ɨ́rɨxɨnɨ. E nerɨ́náyɨ́, nionɨ wireŋɨ́nɨŋɨ́ axɨ́pɨ soyɨ́né seaeánɨmɨ́árɨnɨ. Wainɨ́ mɨ́komɨ wireŋɨ́ meánɨpa nerɨ́náyɨ́, ná mɨwepaxɨ́ imónɨŋɨ́pa soyɨ́né enɨ nionɨ wireŋɨ́nɨŋɨ́ mɨneánɨpa nerɨ́náyɨ́, ná wepaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nionɨ uraxɨ́ wainɨ́ mɨ́kɨ́nɨŋɨ́ imónɨŋáonɨrɨnɨ. Soyɨ́né uraxɨ́ wainɨ́ wireŋɨ́nɨŋɨ́ imónɨgɨ́oyɨ́nérɨnɨ. Ámá nionɨ wireŋɨ́nɨŋɨ́ neánɨŋɨ́ go go nionɨ xɨ́oyá mɨ́kɨ́ imónɨŋáonɨ eŋagɨ nánɨ ná xwénɨŋɨ́ wearɨŋɨ́rɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Soyɨ́né nionɨ pɨ́nɨ nɨnɨwiárɨmɨ nurɨ́náyɨ́, amɨpí wí epaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wireŋɨ́ emɨ móɨ́yɨ́ yeáyɨ́ yárarɨŋɨ́pa ámá nionɨ wireŋɨ́nɨŋɨ́ mɨneánɨpa éɨ́ gomɨ gomɨ emɨ móáná yeáyɨ́ yárarɨŋɨ́rɨnɨ. Wireŋɨ́ axɨ́pɨnɨ e eŋɨ́yɨ́ awí neaárɨrɨ rɨ́á ikeaáráná rɨ́á nowárarɨŋɨ́rɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","re urɨŋɨnigɨnɨ, “Soyɨ́né nionɨ wireŋɨ́nɨŋɨ́ neánɨrɨ xwɨyɨ́á nionɨyápɨ xɨ́dɨrɨ nerɨ́náyɨ́, soyɨ́né pí pí seaimónarɨŋɨ́yɨ́ nánɨ ápomɨ rɨxɨŋɨ́ uráná ananɨ seaiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Soyɨ́né e nero ná xwénɨŋɨ́ nerɨŋɨ́pimɨ dánɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ gɨ́ ápoyápɨ ámáyo sɨwá wíáná ‘O seáyɨ e imónɨŋorɨ́anɨ?’ wiaiwipɨ́rɨ́árɨnɨ. Soyɨ́né e nerɨŋɨ́pimɨ dánɨ enɨ ‘Xegɨ́ wiepɨsiŋɨ́yɨ́ wírɨ́anɨ?’ wipɨmónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ápo dɨŋɨ́ sɨxɨ́ nɨyiŋɨ́pa nionɨ enɨ dɨŋɨ́ sɨxɨ́ seayiŋɨnɨ. Ayɨnánɨ nionɨ dɨŋɨ́ sɨxɨ́ seayiŋápɨ anɨŋɨ́ neayíwɨnɨgɨnɨrɨ éɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Soyɨ́né nionɨ sekaxɨ́ searɨ́áyo xɨxenɨ nɨxɨ́dɨrónáyɨ́, nionɨ gɨ́ ápo sekaxɨ́ nɨrɨŋɨ́pɨ píránɨŋɨ́ xɨ́darɨŋagɨ nánɨ dɨŋɨ́ sɨxɨ́ nɨyarɨŋɨ́pa nionɨ enɨ axɨ́pɨ anɨŋɨ́ soyɨ́né dɨŋɨ́ sɨxɨ́ seayimɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dɨŋɨ́ niɨ́á bɨ onɨmiápɨ seairɨ yayɨ́ bɨ onɨmiápɨ seainɨrɨ oenɨrɨ nánɨ mɨseararɨŋɨnɨ. Dɨŋɨ́ niɨ́á nɨnirɨ yayɨ́ ninarɨŋɨ́pa soyɨ́né enɨ dɨŋɨ́ niɨ́á ayá wí seairɨ yayɨ́ seainɨrɨ oenɨrɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sekaxɨ́ nionɨ rarɨŋápɨ rɨpɨrɨnɨ. Nionɨ dɨŋɨ́ sɨxɨ́ seayarɨŋápa soyɨ́né enɨ axɨ́pɨ xɨxe dɨŋɨ́ sɨxɨ́ yinɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ámá wo xegɨ́ ámáyo dɨŋɨ́ sɨxɨ́ nuyirɨ́ná arɨrá wimɨnɨrɨ nánɨ upeíɨ́pɨ dɨŋɨ́ sɨxɨ́ uyarɨgɨ́ápɨ bɨ tɨ́nɨ xɨxenɨ mimónɨnɨ. Aga seáyɨ e múrónɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Soyɨ́né nionɨ sekaxɨ́ seararɨŋápɨ xɨxenɨ axɨ́pɨ nerónáyɨ́, gɨ́ ámáyɨ́né imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́ wigɨ́ boso ‘E emɨ́ánɨrɨ nánɨ rɨ́a neararɨnɨ?’ mɨyaiwí majɨ́á imónarɨgɨ́á eŋagɨ nánɨ sɨnɨ ‘Inókiwayɨ́nénɨŋɨ́ imónɨgɨ́oyɨ́néyɨ́ searɨmɨméɨnɨ. Amɨpí ápo nɨrarɨ́ná arɨ́á wiŋá nɨpɨnɨ áwaŋɨ́ nɨsearɨrɨ nánɨ ‘Gɨ́ ámáoyɨ́néyɨ́ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Soyɨ́né nionɨ ɨ́á nɨyamɨxɨgɨ́ámanɨ. Ayɨ́ nionɨ soyɨ́né nuro ámáyo nuréwapɨyirɨŋɨ́pimɨ dánɨ aiwá nɨyɨmɨ́nɨŋɨ́ wéɨ́rɨxɨnɨrɨ ɨ́á yɨyamɨxɨmɨ́ nɨseairɨ searɨ́peaŋárɨnɨ. Ayɨnánɨ pí pí nánɨ ápomɨ rɨxɨŋɨ́ nurɨrɨ́ná nionɨmɨ dánɨ nurɨrɨ uránáyɨ́, ananɨ xɨxenɨ seaiinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sekaxɨ́ nionɨ rarɨŋápɨ rɨpɨrɨnɨ. Aga xɨxe dɨŋɨ́ sɨxɨ́ yinɨ́ɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ámá xwɨ́á tɨ́yo eŋɨ́pɨ nánɨnɨ moarɨgɨ́áyɨ́ soyɨ́né sɨ́mɨ́ tɨ́nɨ seaiarɨŋagɨ́a nɨwɨnɨrɨ́ná dɨŋɨ́ re móɨ́rɨxɨnɨ, ‘None sɨnɨ sɨ́mɨ́ tɨ́nɨ mɨneaipa nerɨ́ná xámɨ Jisasomɨ wigɨ́áranɨ?’ móɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Soyɨ́né ámá xwɨ́á tɨ́yo weŋɨ́pɨ nánɨnɨ moarɨgɨ́áyɨ́ tɨ́nɨ nawínɨ nimónɨrɨ sɨŋwɨrɨyɨ́, soyɨ́né wigɨ́yɨ́ imónanɨrɨ éɨ́á eŋagɨ nánɨ dɨŋɨ́ sɨxɨ́ seayipaxɨ́rɨnɨ. E nerɨ aí soyɨ́né ámá xwɨ́á tɨ́yo weŋɨ́pɨ nánɨnɨ moarɨgɨ́áyɨ́ tɨ́nɨ nawínɨ mimónɨpa ero ayɨ́ tɨ́nɨ axɨ́pɨ mimónɨpa éɨ́rɨxɨnɨrɨ ɨ́á yɨyamɨxɨmɨ́ seairɨ eŋá eŋagɨ nánɨ ayɨ́ sɨ́mɨ́ tɨ́nɨ seaiarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ewayɨ́ xwɨyɨ́á nionɨ searɨ́á rɨpɨ, ‘Ámá xɨnáínɨŋɨ́ nimónɨrɨ omɨŋɨ́ wiiarɨŋɨ́ go go xegɨ́ bosomɨ seáyɨ e wimónarɨŋɨ́manɨ.’ searɨ́ápɨ nánɨ dɨŋɨ́ móɨ́rɨxɨnɨ. Nionɨ xeanɨŋɨ́ nɨnikárɨrónáyɨ́, soyɨ́né enɨ xeanɨŋɨ́ seaikárɨpɨ́rɨ́árɨnɨ. Xwɨyɨ́á nionɨyápɨ arɨ́á nɨniro nɨnɨxɨ́dɨrónáyɨ́, soyɨ́néyápɨ enɨ arɨ́á nɨseairo seaxɨ́dɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","E nerɨ aí nionɨ nɨrowárénapɨŋo nánɨ nɨjɨ́á píránɨŋɨ́ mimónɨpa nero nánɨ soyɨ́né nionɨ nɨnɨxɨ́dɨro ‘Jisasoyáonerɨnɨ.’ rarɨŋagɨ́a nánɨ xeanɨŋɨ́ rɨpɨ nɨpɨnɨ seaikárɨpɨ́rɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","re urɨŋɨnigɨnɨ, “Nionɨ nɨbɨrɨ xwɨyɨ́á murɨpa nerɨ sɨŋwɨrɨyɨ́, wigɨ́ ɨ́wɨ́ nero nionɨ rɨ́wɨ́ nɨmóɨ́ápɨ nánɨ xwɨyɨ́á meárɨnɨpaxɨ́ imónanɨrɨ éɨ́ámanɨ. Nionɨ rɨxa bɨŋá eŋagɨ nánɨ ayɨ́ re wí rɨpaxɨ́ menɨnɨ, ‘Negɨ́ eŋwápɨ nerɨ́ná ɨ́wɨ́ mɨyarɨŋwɨnɨrɨ eŋwárɨnɨ.’ rɨpaxɨ́ menɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ámá nionɨ sɨ́mɨ́ tɨ́nɨ niarɨgɨ́áyɨ́ gɨ́ ápomɨ enɨ sɨ́mɨ́ tɨ́nɨ wiarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nionɨ emɨmɨ́ amɨpí ámá eŋíná dánɨ aiwɨ mɨwíwapɨyigɨ́á bɨ mɨwíwapɨyipa nerɨ sɨŋwɨrɨyɨ́, wigɨ́ ɨ́wɨ́ nero nionɨ rɨ́wɨ́ nɨmóɨ́ápɨ nánɨ xwɨyɨ́á meárɨnɨpaxɨ́ menɨnɨ. E nerɨ aiwɨ nionɨ emɨmɨ́ wíwapɨyiŋápɨ sɨŋwɨ́ nɨnanɨro aí nionɨ tɨ́nɨ gɨ́ ápo tɨ́nɨ enɨ nɨwawinɨ sɨ́mɨ́ tɨ́nɨ yeaiarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Rɨ́wamɨŋɨ́ nionɨ nánɨ wigɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo dánɨ eánɨŋɨ́ rɨpɨ, ‘Mɨ́kɨ́ meŋagɨ aiwɨ sɨ́mɨ́ tɨ́nɨ nigɨ́árɨnɨ.’ nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ niarɨŋoɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ámɨ re urɨŋɨnigɨnɨ, “Arɨrá seainɨ́o —O Gorɨxoyá kwíyɨ́pɨrɨnɨ. Apɨ nionɨ ápo tɨ́ŋɨ́ e dánɨ soyɨ́né tɨ́ŋɨ́ e nánɨ urowárénapɨmɨ́ápɨrɨnɨ. Apɨ kwíyɨ́ Gorɨxoyápɨ xɨ́o tɨ́ŋɨ́ e dánɨ nɨbɨrɨ xɨ́o nánɨ nepa imónɨŋɨ́pɨnɨ seaíwapɨyarɨŋɨ́pɨ nánɨ rarɨŋɨnɨ. Apɨ nɨbɨrɨ́ná nionɨ nánɨ áwaŋɨ́ searɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Soyɨ́né nionɨ ámáyo iwamɨ́ó nuréwapɨya uŋaé dánɨ nionɨ tɨ́nɨ emeagɨ́oyɨ́né eŋagɨ nánɨ seaímeaŋɨ́ mɨ́koyɨ́né enɨ ámáyo nionɨ nánɨ áwaŋɨ́ urɨpɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Soyɨ́né axínánɨ dɨŋɨ́ nɨnɨkwɨ́roro nemáná óreámioapɨ́rɨxɨnɨrɨ apɨ nɨpɨnɨ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ayɨ́ re seaipɨ́rɨ́árɨnɨ. Rotú aŋɨ́yo dánɨ segɨ́ yoɨ́ emɨ nɨseakwɨ́rɨmoro aiwɨ rɨ́wéná xe nimónɨríná ámá seapɨkíɨ́áyɨ́ Gorɨxo wimónarɨŋɨ́pɨnɨ yarɨŋwɨnɨrɨ seapɨkipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ápo nánɨ nɨjɨ́á píránɨŋɨ́ mimónɨpa ero nionɨ nánɨ enɨ axɨ́pɨ e mimónɨpa ero nero nánɨ apɨ seaipɨ́rɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Xwɨyɨ́á nionɨ searɨ́ápɨ, ayɨ́ rɨpɨ nánɨ searɨ́ɨnɨ. Xeanɨŋɨ́ apɨ rɨxa nimónarɨ́ná nionɨ nɨseara úápɨ nánɨ dɨŋɨ́ mopɨ́rɨ́a nánɨ searɨ́ɨnɨ. Apɨ nánɨ iwamɨ́ó soyɨ́né tɨ́nɨ emeŋwaé dánɨ áwaŋɨ́ mɨsearɨŋanigɨnɨ. Sɨnɨ soyɨ́né tɨ́nɨ nemerɨ nánɨ áwaŋɨ́ mɨsearɨŋanigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Rɨxa nɨrowárénapɨŋo tɨ́ŋɨ́ e nánɨ warɨŋagɨ aí soyɨ́né woxɨ ‘Joxɨ gɨmɨ nánɨ urɨ́ɨnɨ?’ mɨnɨrarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nionɨ ‘Rɨxa numɨ́ɨnɨ.’ searɨ́agɨ nánɨ soyɨ́né íkɨ́nɨŋɨ́ sɨpí seaiarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E nerɨ aí aga nepa seararɨŋɨnɨ, ‘Nionɨ soyɨ́né tɨ́nɨ anɨŋɨ́ re nɨŋwearɨ́ná arɨrá nɨseaipaxɨ́ aiwɨ pɨ́nɨ nɨseawiárɨmɨ nurɨ́ná arɨrá aga seáyɨ e imónɨŋɨ́pɨ seaipaxɨ́rɨnɨ.’ seararɨŋɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Nionɨ pɨ́nɨ nɨseawiárɨmɨ mupa nerɨ́náyɨ́, arɨrá seainɨ́omɨ —Kwíyɨ́pɨ nánɨ rarɨŋɨnɨ. Omɨ murowárénapɨpa epaxɨ́rɨnɨ. Nionɨ nurɨ́náyɨ́, omɨ soyɨ́né tɨ́ámɨnɨ urowárénapɨmɨ́á eŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kwíyɨ́pɨ nɨbɨrɨ́ná ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ re yaiwíɨ́rɨxɨnɨrɨ, ‘Nene “Ɨ́wɨ́pɨ, ayɨ́ apɨrɨ́anɨ?” moarɨŋwápɨ tɨ́nɨ “Wé rónɨŋɨ́pɨ, ayɨ́ apɨrɨ́anɨ?” moarɨŋwápɨ tɨ́nɨ “Gorɨxo ámáyo xwɨyɨ́á numeárɨrɨ́ná e winɨ́árɨ́anɨ?” moarɨŋwápɨ tɨ́nɨ apiaú apɨ xeŋwɨ́nɨ moarɨŋwárɨ́anɨ?’ yaiwíɨ́rɨxɨnɨrɨ wíwapɨyinɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ayɨ́ nionɨ dɨŋɨ́ mɨnɨkwɨ́ropa yarɨŋagɨ́a nánɨ kwíyɨ́pɨ ‘Ɨ́wɨ́pɨ, ayɨ́ apɨrɨ́anɨ?’ oyaiwípoyɨnɨrɨ wíwapɨyirɨ ");
INSERT INTO aak_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","nionɨ ápo tɨ́ŋɨ́ e nánɨ yíáná o nɨnɨmímɨnɨmáná soyɨ́né sɨnɨ sɨŋwɨ́ ámɨ wí mɨnanɨ́á eŋagɨ nánɨ kwíyɨ́pɨ ‘Wé rónɨŋɨ́pɨ, ayɨ́ apɨrɨ́anɨ?’ enɨ oyaiwípoyɨnɨrɨ wíwapɨyirɨ ");
INSERT INTO aak_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gorɨxo obo, ámá xwɨ́á tɨ́yo meŋweaŋomɨ rɨxa xwɨyɨ́á umeárɨŋɨ́ eŋagɨ nánɨ kwíyɨ́pɨ ‘Gorɨxo xwɨyɨ́á numeárɨrɨ́ná e winɨ́árɨnɨ.’ enɨ oyaiwípoyɨnɨrɨ wíwapɨyirɨ enɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ámɨ re urɨŋɨnigɨnɨ, “Nionɨ xwɨyɨ́á xwapɨ́ ámɨ bɨ tɨ́nɨ ‘Osearɨmɨnɨ.’ nimónarɨŋagɨ aiwɨ agwɨ soyɨ́né arɨ́á nipaxɨ́ mimónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","E nerɨ aiwɨ kwíyɨ́ amɨpí nepaxɨŋɨ́ imónɨŋɨ́pɨ nánɨ rarɨŋɨ́pɨ nɨbɨrɨ́ná Gorɨxo nánɨ nepánɨ imónɨŋɨ́pɨ nɨ́nɨ seaíwapɨyinɨ́árɨnɨ. Apɨ xegɨ́ dɨŋɨ́ tɨ́nɨ wí mɨsearɨpa nerɨ ápomɨnɨ arɨ́á wiarɨŋɨ́pɨnɨ rɨnɨ́á eŋagɨ nánɨ amɨpí Gorɨxo nánɨ imónɨŋɨ́pɨ xɨxenɨ searéwapɨyinɨ́árɨnɨ. Amɨpí rɨ́wɨ́yo imónɨnɨ́ápɨ nánɨ enɨ wɨ́á searókiamonɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kwíyɨ́pɨ xwɨyɨ́á nionɨ rarɨŋápɨ wɨ́á nɨsearókiamorɨ nionɨ nánɨ nɨsearɨrɨ nánɨ nionɨ seáyɨ e nimɨxɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ápo nionɨ ɨ́ánɨŋɨ́ niepɨ́xɨ́niasiŋɨ́ eŋagɨ nánɨ amɨpí nɨ́nɨ oyá imónɨŋɨ́pɨ nionɨyárɨnɨ. Ayɨnánɨ nionɨ re searɨ́ɨnɨ, ‘Kwíyɨ́pɨ nionɨ rarɨŋápɨ arɨ́á nɨnirɨ wɨ́á searókiamonɨ́árɨnɨ.’ searɨ́ɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisaso ámɨ re urɨŋɨnigɨnɨ, “Nionɨ bɨ onɨmiápɨ soyɨ́né tɨ́nɨ nɨŋweámáná eŋáná sɨŋwɨ́ nanɨpɨ́rɨméoɨ. Soyɨ́né segɨ́pɨ ámɨ bɨ onɨmiápɨ nɨŋweámáná sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","wiepɨsarɨŋɨ́yɨ́ wa re rɨnɨgɨ́awixɨnɨ, “O pí enɨ́pɨ nánɨ rɨ́a re áwaŋɨ́ neararɨnɨ, ‘Nionɨ bɨ onɨmiápɨ nɨŋweámáná eŋáná sɨŋwɨ́ nanɨpɨ́rɨméoɨ. Soyɨ́né segɨ́pɨ ámɨ bɨ onɨmiápɨ nɨŋweámáná sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.’ Rɨpɨ enɨ ‘Ápo tɨ́ŋɨ́ e umɨnɨrɨ rarɨŋɨnɨ.’ neararɨŋɨ́pɨ pí enɨ́pɨ nánɨ rɨ́a neararɨnɨ?” nɨrɨnɨro ");
INSERT INTO aak_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","re rɨnɨgɨ́awixɨnɨ, “ ‘Bɨ onɨmiápɨyɨ́ rarɨŋɨ́yɨ́ pí nánɨ rɨ́a neararɨnɨ? None xɨ́o rarɨŋɨ́pɨ nánɨ nɨjɨ́á mimónɨŋwɨnɨ.” rɨnarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisaso awa yarɨŋɨ́ owianeyɨnɨro wimónarɨŋagɨ nánɨ nɨjɨ́á nimónɨrɨ nánɨ re urɨŋɨnigɨnɨ, “Nionɨ ‘Bɨ onɨmiápɨ nɨŋweámáná eŋáná sɨŋwɨ́ nanɨpɨ́rɨméoɨ. Segɨ́pɨ ámɨ bɨ onɨmiápɨ nɨŋweámáná sɨŋwɨ́ nanɨpɨ́rɨ́árɨnɨ.’ searɨ́ápɨ nánɨ yarɨŋɨ́ ninɨro rɨrɨnarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aga nepa seararɨŋɨnɨ. Soyɨ́né ámɨxɨ́á nero ŋwɨ́ pɨyɨ́ wɨ́rɨnɨpɨ́rɨ aiwɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ —Ayɨ́ Gorɨxo tɨ́nɨ xepɨxepá rónɨgɨ́áyɨ́rɨnɨ. Ayɨ́ yayɨ́ seáyɨmɨ dánɨ winɨnɨŋoɨ. Ríná soyɨ́né íkɨ́nɨŋɨ́ sɨpí nɨseairɨ aiwɨ rɨ́wéná dɨŋɨ́ niɨ́á seainɨnɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ewayɨ́ xwɨyɨ́á bɨ rɨpɨ urɨŋɨnigɨnɨ, “Apɨxíwa niaíwɨ́ nɨxɨrɨrɨ́ná yarɨgɨ́ápɨ nánɨ dɨŋɨ́ mópoyɨ. Apɨxɨ́ niaíwɨ́ sɨŋwɨ́ wanarɨ́ná ‘Rɨnɨŋɨ́ nɨninɨrɨ niaíwɨ́ xɨrɨmɨ nánɨ rɨxa rínárɨ́anɨ?’ nɨyaiwirɨ nánɨ íkɨ́nɨŋɨ́ sɨpí wiarɨŋɨ́rɨnɨ. E nerɨ aí rɨ́wéná niaíwɨ́ rɨxa nɨxɨrɨmáná niaíwɨ́ xɨrɨ́o nánɨ dɨŋɨ́ niɨ́á winarɨŋagɨ nánɨ rɨ́nɨŋɨ́ winɨ́ɨ́pɨ nánɨ arɨ́á ikeamoarɨŋɨ́rɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Soyɨ́né enɨ axɨ́pɨ́nɨŋɨ́ seaimónɨnɨ. Agwɨ soyɨ́né íkɨ́nɨŋɨ́ sɨpí nɨseairɨ aiwɨ nionɨ ámɨ sɨŋwɨ́ seanáná xwioxɨ́yo dɨŋɨ́ niɨ́á seainɨnɨ́árɨnɨ. Yayɨ́ apɨ ámá wí amɨpí wí nɨseaikárɨro aí pɨ́rɨ́ searakipaxɨ́ mimónɨŋɨ́pɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Dɨŋɨ́ yayɨ́ seainɨ́e dánɨ nionɨ ámɨ amɨpí bɨ nánɨ yarɨŋɨ́ nipɨ́rɨ́ámanɨ. Aga nepa seararɨŋɨnɨ. Ápomɨ amɨpí bɨ nánɨ rɨxɨŋɨ́ nurɨrɨ́ná nionɨmɨ dánɨ uránáyɨ́, ananɨ nɨseaiapɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ínɨná dánɨ ápomɨ nionɨmɨ dánɨ rɨxɨŋɨ́ murɨpa néra nɨbɨ́asáná aí dɨŋɨ́ niɨ́á seainɨnɨ́ápɨ bɨ onɨmiápɨ mɨseainɨpa éwɨnɨgɨnɨrɨ omɨ ananɨ rɨxɨŋɨ́ urɨ́ɨ́rɨxɨnɨ. Rɨxɨŋɨ́ uráná seaiapɨnɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ámɨ re urɨŋɨnigɨnɨ, “Xwɨyɨ́á nionɨ nɨseara úápɨ ewayɨ́ xwɨyɨ́á tɨ́nɨ nɨsearɨrɨ aiwɨ rɨ́wéná ewayɨ́ xwɨyɨ́á tɨ́nɨ ámɨ bɨ mɨsearɨ́ ápo nánɨ sɨŋánɨ áwaŋɨ́ searɨmɨ́áíná nimónɨnɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Íná Gorɨxomɨ rɨxɨŋɨ́ nurɨrɨ́ná nionɨmɨ dánɨ urɨpɨ́rɨ́árɨnɨ. Sewanɨŋoyɨ́né rɨxɨŋɨ́ uráná ananɨ arɨ́á seainɨ́á eŋagɨ nánɨ ‘Íná nionɨ soyɨ́né nánɨ ápomɨ rɨxɨŋɨ́ seaurɨyimɨ́árɨnɨ.’ mɨseararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Xewanɨŋo dɨŋɨ́ sɨxɨ́ nɨseayirɨ nánɨ arɨ́á seainɨ́árɨnɨ. Soyɨ́né nionɨ dɨŋɨ́ sɨxɨ́ nɨyiro ‘Ápo tɨ́ŋɨ́ e dánɨ bɨŋorɨ́anɨ?’ niaiwiro yarɨŋagɨ́a nánɨ xewanɨŋo dɨŋɨ́ sɨxɨ́ nɨseayirɨ nánɨ arɨ́á seainɨ́árɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","re urɨŋɨnigɨnɨ, “Eŋíná nionɨ ápo tɨ́nɨ ŋweaagáonɨ aí o tɨ́ŋɨ́ e dánɨ pɨ́nɨ nɨwiárɨmɨ xwɨ́á tɨ́yo nánɨ bɨŋárɨnɨ. Re nɨŋweaŋɨsáná xwɨ́á tɨ́yo pɨ́nɨ nɨwiárɨmɨ ámɨ o tɨ́ŋɨ́ e nánɨ umɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","xegɨ́ wiepɨsarɨŋowa re urɨgɨ́awixɨnɨ, “Ayɨ́ apɨrɨnɨ. Agwɨ joxɨ ewayɨ́ xwɨyɨ́á tɨ́nɨ mɨneararɨŋɨnɨ. Rɨxa sɨŋánɨ áwaŋɨ́ neararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Agwɨ none dɨŋɨ́ re nɨsiaiwirane nɨjɨ́á imónɨŋwɨnɨ, ‘Amɨpí nɨ́nɨ nánɨ nɨjɨ́orɨ́anɨ? Ámá yarɨŋɨ́ mɨwipa éɨ́mɨ aiwɨ wigɨ́ xwioxɨ́yo “Yarɨŋɨ́ apɨ owimɨnɨ.” yaiwiarɨgɨ́ápɨ nánɨ nɨjɨ́á imónɨŋorɨ́anɨ?’ nɨsiaiwirane nɨjɨ́á imónɨŋwɨnɨ. Ayɨnánɨ dɨŋɨ́ re nɨsiaiwirane dɨŋɨ́ rɨkwɨ́roarɨŋwɨnɨ, ‘Joxɨ Gorɨxo tɨ́ŋɨ́ e dánɨ bɨŋoxɨrɨnɨ.’ rɨkwɨ́roarɨŋwɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisaso re urɨŋɨnigɨnɨ, “Agwɨ soyɨ́né dɨŋɨ́ rɨnɨkwɨ́roarɨŋoɨ? ");
INSERT INTO aak_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Soyɨ́né xɨ́dɨ́xɨ́dowárɨ́ seaíáná nionɨ nɨgɨ́pɨ pɨ́nɨ nɨnɨwiárɨmɨ segɨ́ aŋɨ́mɨ nánɨ xɨxegɨ́nɨ umipɨ́ríná rɨxa aŋwɨ e nerɨ rɨxa imónɨnɨ. Soyɨ́né nionɨ pɨ́nɨ nɨnɨwiárɨmɨ núagɨ́a aí ápo dɨŋɨ́ nɨkɨkayoŋagɨ nánɨ nionɨ nɨgɨ́pɨ ŋweapaxɨ́manɨ. ");
INSERT INTO aak_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Soyɨ́né ayá sɨ́wɨ́ mɨsearó ‘O tɨ́nɨ ikárɨnɨŋwáonerɨ́anɨ?’ nɨyaiwinɨro kikiɨ́á éɨ́rɨxɨnɨrɨ xwɨyɨ́á nionɨ nɨseara bɨ́ápɨ searɨ́árɨnɨ. Soyɨ́né xwɨ́á tɨ́yo ŋweaŋáná ámá Gorɨxo tɨ́nɨ xepɨxepá rónɨgɨ́áyɨ́ xeanɨŋɨ́ seaikárɨpɨ́rɨ́á eŋagɨ aiwɨ nionɨ ayo rɨxa xopɨrárɨ́ wíá eŋagɨ nánɨ dɨŋɨ́ sɨxɨ́ nínɨro ŋweáɨ́rɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisaso xwɨyɨ́á apɨ nura núɨsáná aŋɨ́namɨ nánɨ sɨŋwɨ́ nanánɨrɨ re rɨŋɨnigɨnɨ, “Ápoxɨnɨ, nimónɨnɨ nánɨ rɨxa rínárɨnɨ. Dɨxɨ́ riwaxonɨ eŋɨ́ sɨxɨ́ eánɨŋɨ́ joxɨyápɨ ámáyo sɨwá wimɨ nánɨ joxɨ ‘O ámá nɨyonɨ seáyɨ e imónɨŋorɨ́anɨ?’ oniaiwípoyɨnɨrɨ niíɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ámá joxɨyá dɨŋɨ́yo dánɨ nionɨ nɨxɨ́darɨgɨ́áyo dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ sɨxɨ́ umímopaxo imónɨ́wɨnɨgɨnɨrɨ ‘Ámá nɨ́nɨ nánɨ nénɨ́ tɨ́ŋoxɨ imóneɨ.’ nɨrɨŋɨ́ eŋagɨ nánɨ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ámá rɨpɨnɨ nerɨŋɨ́pimɨ dánɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́ imónarɨgɨ́árɨnɨ. Joxɨ nánɨ ‘Ŋwɨ́á imónɨŋo, ayɨ́ Gorɨxorɨnɨ. Ámɨ wo mɨŋweanɨnɨ.’ dɨŋɨ́ rɨmoro Jisasɨ Kiraisonɨ, joxɨ nɨrowárénapɨŋonɨ nánɨ ‘Nepa ayɨ́ orɨnɨ.’ dɨŋɨ́ nɨmoro yarɨgɨ́áyɨ́, ayɨ́ dɨŋɨ́ nɨyɨmɨŋɨ́pɨ imónarɨgɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Joxɨ o e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́pɨ xɨxenɨ nɨpɨnɨ nɨyárɨrɨ́ná eŋɨ́ sɨxɨ́ eánɨŋɨ́ joxɨyápɨ nɨwíwapɨyirɨŋɨ́pimɨ dánɨ seáyɨ e joxɨ imónɨŋɨ́pɨ ámá xwɨ́á tɨ́yo dáŋɨ́yo sɨwánɨŋɨ́ wíárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ápoxɨnɨ nionɨ e éá eŋagɨ nánɨ xámɨ xwɨ́á rɨrí sɨnɨ mimónɨpa eŋɨ́mɨ joxɨ tɨ́nɨ nɨŋwearɨ́ná nikɨ́nɨrɨ ŋweaagápɨ ‘Ámɨ nionɨ tɨ́nɨ nɨŋwearɨ́ná nionɨ tɨ́nɨ nawínɨ seáyɨ e nimónɨrɨ axɨ́pɨ oikɨ́nɨnɨ.’ osimónɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","re urɨŋɨnigɨnɨ, “Ámá xwɨ́á tɨ́yo dáŋɨ́ joxɨyá dɨŋɨ́ tɨ́nɨ nionɨ nɨxɨ́darɨgɨ́áyɨ́ joxɨ imónɨŋɨ́pɨ nánɨ xɨxenɨ nɨjɨ́á oimónɨ́poyɨnɨrɨ wíwapɨyiŋárɨnɨ. Ayɨ́ ámá dɨxɨ́yɨ́ nionɨ niapɨŋɨ́yɨ́ nánɨ rɨrarɨŋɨnɨ. Dɨxɨ́ xwɨyɨ́á nionɨ nɨrɨŋɨ́pimɨ píránɨŋɨ́ nɨxɨ́da nɨbɨro ");
INSERT INTO aak_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","rɨxa nɨjɨ́á re imónɨŋoɨ, ‘Amɨpí joxɨ ɨ́ánɨŋɨ́ niepɨ́xɨ́niasiŋɨ́ nionɨ nɨrɨrɨ yarɨŋápɨ nɨpɨnɨ joxɨ niapɨŋɨ́rɨnɨ.’ Nɨjɨ́á e imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Xwɨyɨ́á joxɨ nɨrɨŋɨ́pɨ xewanɨŋonɨ rɨxa urɨ́á eŋagɨ nánɨ nɨjɨ́á e imónɨŋoɨ. Xwɨyɨ́á nionɨyápɨ arɨ́á nɨniróná dɨŋɨ́ nɨnɨkwɨ́roro xɨxenɨ re nɨsiaiwiro nɨjɨ́á imónɨŋoɨ, ‘Gorɨxo tɨ́ámɨnɨ bɨŋorɨnɨ.’ nɨsiaiwiro ‘Gorɨxo urowárénapɨŋorɨ́anɨ?’ niaiwiárɨŋoɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","re urɨŋɨnigɨnɨ, “Ámá xwɨ́á tɨ́yo dáŋɨ́ ápoxɨ tɨ́nɨ xepɨxepá rónɨgɨ́áyo arɨrá owinɨrɨ yarɨŋɨ́ mɨsiarɨŋɨnɨ. Ámá joxɨyá dɨŋɨ́ tɨ́nɨ dɨŋɨ́ nɨkwɨ́roarɨgɨ́áyɨ́ dɨxɨ́ imónɨŋagɨ nánɨ yarɨŋɨ́ siarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Amɨpí ámá aí nionɨyáyɨ́ ayɨ́ joxɨyá imónɨnɨ. Amɨpí ámá aí joxɨyáyɨ́ enɨ ayɨ́ nionɨyá imónɨnɨ. Ayɨ́ dɨŋɨ́ nɨnɨkwɨ́rorɨŋɨ́pimɨ dánɨ ámáyo rénɨŋɨ́ urarɨŋoɨ, ‘Seáyɨ e imónɨŋo, ayɨ́ orɨnɨ.’ urarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nionɨ joxɨ tɨ́ámɨnɨ bɨmɨ eŋagɨ nánɨ xwɨ́áyo re bɨ tɨ́nɨ sɨnɨ ŋweámɨméɨnɨ. E nerɨ aí ámá rowa sɨnɨ xwɨ́á tɨ́yo re ŋweapɨ́rɨ́á eŋagɨ nánɨ ápoxɨnɨ, —Joxɨ sɨyikwɨ́ mínɨŋɨ́ imónɨŋoxɨrɨnɨ. Joxɨ dɨxɨ́ eŋɨ́ eánɨŋɨ́pɨ —Eŋɨ́ eánɨŋɨ́ joxɨ neámɨxowárɨŋɨ́pɨ nánɨ rarɨŋɨnɨ. Apɨ tɨ́nɨ píránɨŋɨ́ uméɨrɨxɨnɨ. Yawawi nawínɨ imónɨgwɨ́ípa ayɨ́ enɨ axɨ́pɨ nawínɨ imónɨpɨ́rɨ́a nánɨ píránɨŋɨ́ uméɨrɨxɨnɨrɨ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nionɨ awa tɨ́nɨ emearɨ́ná eŋɨ́ sɨxɨ́ eánɨŋɨ́ joxɨ neámɨxowárɨŋɨ́pɨ tɨ́nɨ nɨméra nɨbɨrɨ awínɨŋɨ́ numearóa barɨ́ná awa wo mɨyorɨ́rɨnɨpa nemáná aiwɨ Bɨkwɨ́yo dánɨ rɨ́wamɨŋɨ́ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ awa wonɨnɨ xewanɨŋo nerɨŋɨ́pimɨ dánɨ yorɨ́rɨnɨmɨnɨrɨ yarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Agwɨ nionɨ joxɨ tɨ́ŋɨ́ e nánɨ bɨmɨ́ɨnɨ. E nerɨ aí dɨŋɨ́ niɨ́á nionɨ ninarɨŋɨ́pa awa enɨ bɨ onɨmiápɨ mɨwinɨ́ xwé wíwɨnɨgɨnɨrɨ sɨnɨ xwɨ́á tɨ́yo nɨŋwearɨ́ná nionɨ nɨra warɨŋápɨ rɨrarɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","re urɨŋɨnigɨnɨ, “Nionɨ ámá ápoxɨ dɨŋɨ́ rɨkwɨ́roarɨŋɨ́yo xwɨyɨ́á joxɨyápɨ urɨŋá eŋagɨ nánɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ ayo sɨ́mɨ́ tɨ́nɨ wiarɨŋoɨ. Nionɨ xwɨ́á tɨ́yo dáŋonɨ mimónɨpa eŋápa awa enɨ xwɨ́á tɨ́yo dáŋɨ́nɨŋɨ́ mimónɨŋagɨ́a nánɨ sɨ́mɨ́ tɨ́nɨ wiarɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Awamɨ joxɨ xwɨ́á tɨ́yo dánɨ owirɨmeanɨrɨ mɨrɨrarɨŋɨnɨ. Sɨpí wikárarɨŋo xwɨrɨ́á mɨwikɨxepa enɨ́a nánɨ joxɨ píránɨŋɨ́ méwɨnɨgɨnɨrɨ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nionɨ xwɨ́á tɨ́yo dáŋonɨ mimónɨpa eŋápa awa enɨ xwɨ́á tɨ́yo dáŋɨ́nɨŋɨ́ mimónɨpa eŋagɨ́a nánɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ tɨ́nɨ axɨ́yɨ́ mimónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xwɨyɨ́á joxɨyápɨ aga nepánɨ imónɨŋagɨ nánɨ ámá rowa joxɨ simónarɨŋɨ́pɨ nánɨ xɨxenɨ kumɨxɨnɨpɨ́rɨ nánɨ xwɨyɨ́á apɨ nuréwapɨyirɨŋɨ́pimɨ dánɨ píránɨŋɨ́ imɨxɨ́ɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Joxɨ xwɨ́áyo nánɨ úwɨnɨgɨnɨrɨ nɨrowárénapɨŋɨ́pa xamɨŋonɨ enɨ awamɨ urowárɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Joxɨ ámáyɨ́ nánɨ wiíwɨnɨgɨnɨrɨ nɨrowárénapɨŋɨ́pɨ tɨ́nɨ xɨxenɨ niɨwanɨŋonɨ owiimɨnɨrɨ nánɨ okumɨxɨnɨmɨnɨ. Ámá rowa enɨ joxɨ e éɨ́rɨxɨnɨrɨ simónarɨŋɨ́pɨ nánɨ okumɨxɨnɨ́poyɨnɨrɨ nánɨ joxɨ wiíwɨnɨgɨnɨrɨ nɨrowárénapɨŋɨ́pɨ tɨ́nɨ xɨxenɨ owiimɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","re urɨŋɨnigɨnɨ, “Nionɨ awa nánɨnɨ rɨxɨŋɨ́ mɨrɨrarɨŋɨnɨ. Awa uréwapɨyíáná dɨŋɨ́ nɨkwɨ́róɨ́áyɨ́ nánɨ enɨ ápoxɨnɨ rɨrarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ayɨ́ nɨ́nɨ axɨ́yɨ́nɨŋɨ́ imónɨpɨ́rɨ́a nánɨ yarɨŋɨ́ siarɨŋɨnɨ. ‘Ápoxɨ nionɨ tɨ́nɨ imónɨrɨ nionɨ joxɨ tɨ́nɨ imónɨrɨ egwɨ́ípa ayɨ́ enɨ yawawi tɨ́nɨ nawínɨ oimónɨ́poyɨ.’ nimónarɨnɨ. Ámá nɨ́nɨ dɨŋɨ́ nɨnɨkwɨ́roro ‘Gorɨxo urowárénapɨ́agɨ weapɨŋorɨ́anɨ?’ niaiwíɨ́rɨxɨnɨrɨ ‘Ámá tɨyɨ́ axɨ́yɨ́nɨŋɨ́ oimónɨ́poyɨ.’ nimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eŋɨ́ sɨxɨ́ eánɨŋɨ́ joxɨ neámɨxowárɨŋɨ́pɨ awa enɨ yawawi axowawi imónɨgwɨ́ípa axowánɨŋɨ́ oimónɨ́poyɨnɨrɨ nánɨ weámɨxowárɨŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Awa aga xɨxenɨ axowánɨŋɨ́ oimónɨ́poyɨnɨrɨ nionɨ awa tɨ́nɨ nawínɨ imónɨrɨ joxɨ nionɨ tɨ́nɨ nawínɨ imónɨrɨ eŋwɨnɨ. Ámá nɨ́nɨ re nɨyaiwiro nɨjɨ́á imónɨpɨ́rɨ́a nánɨ e imónɨŋwɨnɨ, ‘Gorɨxo omɨ urowárénapɨŋɨ́rɨnɨ. Omɨ dɨŋɨ́ sɨxɨ́ uyiŋɨ́pa awamɨ enɨ dɨŋɨ́ sɨxɨ́ uyinɨ.’ nɨyaiwiro nɨjɨ́á imónɨpɨ́rɨ́a nánɨ e imónɨŋwɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","re urɨŋɨnigɨnɨ, “Ápoxɨnɨ, ámá joxɨyá dɨŋɨ́ tɨ́nɨ nɨxɨ́darɨgɨ́á rowa nionɨ xámɨ joxɨ tɨ́nɨ nɨŋwearɨ́ná nikɨ́nɨrɨ ŋweaagápa ámɨ nikɨ́nɨrɨ ŋweaŋáná sɨŋwɨ́ nanɨpɨ́rɨ́a nánɨ nionɨ ŋweámɨ́aé awa enɨ nionɨ tɨ́nɨ ŋweáɨ́rɨxɨnɨrɨ nánɨ nimónarɨnɨ. Ápoxɨnɨyá dɨŋɨ́ tɨ́nɨ nikɨ́nɨrɨ ŋweaagápɨ nánɨ rɨrarɨŋɨnɨ. Ayɨ́ rɨpɨ nánɨrɨnɨ. Xwɨ́á rɨrí sɨnɨ mimónɨŋáná dɨŋɨ́ sɨxɨ́ nɨyiŋoxɨ eŋagɨ nánɨ rarɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ápoxɨnɨ, joxɨ wé rónɨŋoxɨrɨnɨ. Joxɨ nánɨ ámá xwɨ́á tɨ́yo dáŋɨ́yɨ́ nɨjɨ́á xɨxenɨ mimónɨpa eŋagɨ́a aiwɨ nionɨ joxɨ nánɨ nɨjɨ́á xɨxenɨ imónɨŋɨnɨ. Rowa enɨ joxɨ nánɨ ‘O omɨ urowárénapɨŋorɨ́anɨ?’ nɨsiaiwiro nɨjɨ́á imónɨŋoɨ. ");
INSERT INTO aak_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Joxɨ imónɨŋɨ́pɨ nánɨ awamɨ rɨxa nɨwíwapɨyirɨ wɨ́á urókiamoŋárɨnɨ. Dɨŋɨ́ joxɨ sɨxɨ́ nɨyarɨŋɨ́pa awa enɨ wínɨyo axɨ́pɨ uyipɨ́rɨ́a nánɨ ámɨ bɨ tɨ́nɨ wíwapɨyimɨ́ɨnɨ. Nionɨ enɨ awa tɨ́nɨ nawínɨ imónɨmɨ́a nánɨ ámɨ bɨ tɨ́nɨ wíwapɨyimɨ́ɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Gorɨxomɨ rɨxɨŋɨ́ e nurárɨmo xegɨ́ wiepɨsarɨŋowa tɨ́nɨ nuro írɨreŋɨ́ xegɨ́ yoɨ́ Kidɨronɨyɨ rɨnɨŋɨ́pámɨ nɨxemoro omɨŋɨ́ ojɨkwɨ́í bɨ orɨwámɨ dánɨ inɨŋɨ́pɨ tɨ́e rémogɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judaso, Jisaso nánɨ mɨyɨ́ urɨno enɨ Jisaso tɨ́nɨ xegɨ́ wiepɨsarɨŋowa tɨ́nɨ íníná e awí eánayarɨgɨ́á eŋagɨ nánɨ omɨŋɨ́ ojɨkwɨ́í apɨ nánɨ nɨjɨ́árɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","O émáyɨ́ porisɨ́ wamɨ awí earɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwamɨ enɨ Parisiowa tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́ŋɨ́ e dánɨ awí earɨ nemáná awa ramɨxɨ́ tɨ́nɨ uyɨ́wɨ́ tɨ́nɨ mɨxɨ́nápɨ tɨ́nɨ nɨxɨrɨmáná ojɨkwɨ́ípimɨ nánɨ nuro rémóáná ");
INSERT INTO aak_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisaso xɨ́omɨ wikárɨpɨ́rɨ́pɨ nɨpɨnɨ nánɨ rɨxa nɨjɨ́á nimónɨrɨ nánɨ aŋwɨ e nurɨ re urɨŋɨnigɨnɨ, “Soyɨ́né go nánɨ pɨ́á yarɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","awa re urɨgɨ́awixɨnɨ, “Nasaretɨ dáŋɨ́ Jisaso nánɨ pɨ́á yarɨŋwɨnɨ.” urɨ́agɨ́a Judaso xɨ́o nánɨ pasánɨŋɨ́ umearɨŋo awa tɨ́nɨ roŋáná Jisaso “Ayɨ́ nionɨrɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ayɨ́ nionɨrɨnɨ.” uráná awa re egɨ́awixɨnɨ. Óɨ́ nero rɨ́wɨmɨnaŋɨ́ úɨ́áyɨ́ xwɨ́áyo pɨkínɨmeagɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Xwɨ́áyo pɨ́kínɨmeáagɨ́a o ámɨ re urɨŋɨnigɨnɨ, “Go nánɨ pɨ́á yarɨŋoɨ?” urɨ́agɨ awa “Nasaretɨ dáŋɨ́ Jisaso nánɨ pɨ́á yarɨŋwɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisaso “ ‘Ayɨ́ nionɨrɨnɨ.’ rɨxa searɨ́anigɨnɨ. Ayɨnánɨ nionɨ nánɨ pɨ́á nɨnirɨ́náyɨ́, ámá rowayɨ́ xe oúpoyɨnɨrɨ sɨŋwɨ́ wɨnɨ́poyɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Xámɨ Gorɨxomɨ re urɨ́ɨ́pɨ, “Ámá joxɨyá dɨŋɨ́ tɨ́nɨ xɨ́dɨ́ɨ́rɨxɨnɨrɨ niapɨŋɨ́yɨ́ womɨ mɨwiorɨ́rɨŋárɨnɨ.” urɨ́ɨ́pɨ xɨxenɨ imónɨnɨ nánɨ e urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","E urarɨ́ná Saimonɨ Pitao kirá bá nɨmɨxearɨ re eŋɨnigɨnɨ. Mɨ́rɨ́ nurɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋoyá omɨŋɨ́ wiiarɨŋomɨ —O xegɨ́ yoɨ́ Marɨkasoyɨ rɨnɨŋorɨnɨ. Omɨ mɨŋɨ́ rómɨnɨrɨ éɨ́yɨ́ pɨ́rɨ́ noyɨ́kirɨ arɨ́á mɨŋɨ́ wirɨ́pieaŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pɨ́rɨ́ noyɨ́kirɨ arɨ́á mɨŋɨ́ wirɨ́pieáagɨ Jisaso Pitaomɨ mɨxɨ́ re urɨŋɨnigɨnɨ, “Kirápá xegɨ́ aŋɨ́yo ámɨ upɨ́roɨ. Xeanɨŋɨ́ kapɨxɨ́nɨŋɨ́ ápo o onɨnɨrɨ niaparɨŋɨ́pɨ ‘Mɨnɨpa oenɨ.’ rɨsimónarɨnɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Émáyɨ́ porisowa tɨ́nɨ wigɨ́ seáyɨ e wimónɨŋo tɨ́nɨ Judayɨ́ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwa tɨ́nɨ Jisasomɨ ɨ́á nɨxero gwɨ́ nɨjiro ");
INSERT INTO aak_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","xámɨ Anaso tɨ́ŋɨ́ e nánɨ nɨméra ugɨ́awixɨnɨ. Anasomɨ xɨneagwo Kaiapasorɨnɨ. Xwiogwɨ́ omɨ o apaxɨ́pánɨŋɨ́ imónɨgɨ́áwa seáyɨ e wimónɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Xámɨ xegɨ́ Judayo re urɨŋo, ayɨ́ orɨnɨ, “ ‘Negɨ́ ámá nɨ́nɨ pepɨ́rɨxɨnɨrɨ ayɨ́ rɨ́nɨŋɨ́ meaanɨrɨ éɨ́ápɨ nánɨ ámá ná wonɨ rɨ́nɨŋɨ́ apɨ nɨmearɨ nɨperɨ́náyɨ́, ananɨrɨnɨ.’ nimónarɨnɨ.” urɨŋorɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Omɨ xɨneagwo, Anasoyɨ rɨnɨŋo tɨ́ŋɨ́ e nánɨ Jisasomɨ nɨméra warɨ́ná Saimonɨ Pitao tɨ́nɨ wiepɨsarɨŋɨ́yɨ́ ámɨ wo tɨ́nɨ awaú Jisasomɨ rɨ́wɨ́yo nɨxɨ́da nuri apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋoyá aŋɨ́ tɨ́ŋɨ́ e nɨrémómáná wiepɨsarɨŋɨ́ wɨ́omɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋo sɨ́mɨmaŋɨ́ oyá nɨjɨ́á eŋagɨ nánɨ o Jisaso tɨ́nɨ aŋɨ́ ákɨŋáyo ínɨmɨ nɨpáwiri ");
INSERT INTO aak_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitao sɨnɨ bɨ́arɨwámɨnɨ ɨ́wí e roŋagɨ nánɨ nurɨ apɨxɨ́ ákɨŋá ɨ́wíyimɨ awí roarɨŋímɨ Pitao nánɨ nurɨmo nɨpeyearɨ nɨwirɨmeámɨ ɨ́wiaparɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","apɨxɨ́ ákɨŋá ɨ́wíyimɨ awí roarɨŋí Pitaomɨ re urɨŋɨnigɨnɨ, “Joxɨ enɨ ámá royá wiepɨsarɨŋɨ́ woxɨ menɨranɨ?” urɨ́agɨ o “Nionɨmanɨ.” nurɨmɨ nɨpáwirɨ ");
INSERT INTO aak_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ yarɨgɨ́áyɨ́ tɨ́nɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwa tɨ́nɨ e nɨrówapɨro imɨŋɨ́ rarɨŋagɨ nánɨ rɨ́á nikeámáná rɨ́á imónarɨ́ná Pitao enɨ rɨ́á oimónɨmɨnɨrɨ aŋwɨ e nurɨ awa tɨ́nɨ nawínɨ nɨrorɨ rɨ́á imónarɨŋagɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋo Jisasoyá wiepɨsarɨŋɨ́yɨ́ nánɨ yarɨŋɨ́ wirɨ xwɨyɨ́á ámáyo uréwapɨyarɨŋɨ́pɨ nánɨ yarɨŋɨ́ wirɨ éagɨ ");
INSERT INTO aak_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ ámá nɨyonɨ sɨŋánɨŋe dánɨ uréwapɨyarɨŋárɨnɨ. Nionɨ gínɨ gíná nuréwapɨyirɨ́ná rotú aŋɨ́yo dánɨranɨ, aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ dánɨranɨ, sa negɨ́ Judayɨ́ awí eánarɨgɨ́e dánɨ uréwapɨyarɨŋá eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","joxɨ pí nánɨ nionɨ yarɨŋɨ́ niarɨŋɨnɨ. Nionɨ xwɨyɨ́á urarɨ́ná arɨ́á niarɨgɨ́áyo yarɨŋɨ́ wiɨ. Pí pí urarɨŋápɨ nánɨ ayɨ́ ananɨ nɨjɨ́árɨnɨ.” uráná ");
INSERT INTO aak_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áyɨ́ wo aŋwɨ e éɨ́ nɨrómáná Jisasomɨ wé tɨ́nɨ nupɨkákwirɨ re urɨŋɨnigɨnɨ, “Apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋomɨ e nurɨrɨ́ná ‘Apánɨ urarɨŋɨnɨ.’ rɨsimónarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ xeŋwɨ́nɨ nɨrɨrɨ sɨpínɨ rarɨ́náyɨ́, xeŋwɨ́ rɨ́ápɨ nánɨ áwaŋɨ́ neareɨ. Nionɨ naŋɨ́ rarɨ́náyɨ́, pí nánɨ iwaŋɨ́ neaarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anaso Jisaso sɨnɨ gwɨ́ jinɨŋáná apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋɨ́ ámɨ wo, Kaiapasoyɨ rɨnɨŋo tɨ́ŋɨ́ e nánɨ wiowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimonɨ Pitao rɨ́á ikeaárɨnɨŋe éɨ́ nɨrómáná rɨ́á imónarɨ́ná e rówapɨgɨ́áyɨ́ wí re urɨgɨ́awixɨnɨ, “Joxɨ enɨ xegɨ́ wiepɨsarɨŋɨ́yɨ́ woxɨ menɨranɨ?” urɨ́agɨ́a aí o “Oweoɨ.” nurɨrɨ “Nionɨ enɨ wonɨmanɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Apaxɨ́pánɨŋɨ́ imónɨgɨ́áwamɨ seáyɨ e wimónɨŋoyá xɨnáíwánɨŋɨ́ nimónɨro omɨŋɨ́ wiiarɨgɨ́áyɨ́ wo —O Pitao arɨ́á mɨŋɨ́ wirɨ́pieaŋomɨ xexɨrɨ́meá worɨnɨ. O enɨ Pitaomɨ re urɨŋɨnigɨnɨ, “Nionɨ ojɨkwɨ́íyo Jisaso tɨ́nɨ nawínɨ roŋagɨ sɨŋwɨ́ ranɨ́áoxɨ menɨranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitao ámɨ “Oweoɨ.” uráná re eŋɨnigɨnɨ. Karɨ́karɨ́ rɨ́aiwá rɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wɨ́á mónɨŋɨ́mɨ Kaiapaso tɨ́ŋɨ́ e dánɨ émáyɨ́ gapɨmanowayá aŋiwámɨ nánɨ Jisasomɨ nɨméra nuro aiwɨ Judayɨ́ ámɨnáowa none nɨpáwirɨŋɨ́pimɨ dánɨ xwɨrɨ́á ikɨxenáná aiwá Aŋɨ́najo Neamúroagoɨ rɨnɨŋɨ́yi nánɨ mɨnɨpaxɨ́ imónanɨgɨnɨrɨ mɨpáwí yarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","gapɨmanɨ́ pɨrimiá imónɨŋo —O émáyɨ́ wo xegɨ́ yoɨ́ Pairatoyɨ rɨnɨŋorɨnɨ. O awa tɨ́ŋɨ́ e nánɨ nɨ́wiapɨrɨ re urɨŋɨnigɨnɨ, “Omɨ pí xwɨyɨ́á nánɨ xwɨyɨ́á mearanɨro nɨmeámɨ barɨŋoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","awa re urɨgɨ́awixɨnɨ, “Ámá ro ɨ́wɨ́ mɨyarɨŋo eŋánáyɨ́, joxɨ tɨ́e nánɨ nɨmeámɨ banɨrɨ éwámanɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pairato re urɨŋɨnigɨnɨ, “Sewanɨŋoyɨ́né nɨmeámɨ nuro segɨ́ ŋwɨ́ ikaxɨ́ rarɨŋɨ́pɨ tɨ́nɨ xɨxenɨ xwɨyɨ́á umearɨ́poyɨ.” urɨ́agɨ Judayowa re urɨgɨ́awixɨnɨ, “Émáoyɨ́né ɨ́wɨ́ yarɨgɨ́áyo opɨkípoyɨnɨrɨ sɨŋwɨ́ neanarɨgɨ́ámanɨ.” urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Xwɨyɨ́á Jisaso xámɨ re urɨŋɨ́pɨ, “Nionɨ nɨnɨpɨkirɨ́ná e nɨniro nɨpɨkipɨ́rɨ́árɨnɨ.” urɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ Judayowa Pairatomɨ xwɨyɨ́á e urɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pairato ámɨ gapɨmanowa wigɨ́ aŋɨ́ iwámɨ nɨpáwímáná “Jisaso obɨnɨ.” nɨrɨrɨ re urɨŋɨnigɨnɨ, “Joxɨ mɨxɨ́ ináyɨ́ Judayɨ́yáoxɨranɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisaso re urɨŋɨnigɨnɨ, “Dɨxɨ́ dɨŋɨ́ tɨ́nɨ rɨnɨrarɨŋɨnɨ? Wa rɨrɨ́agɨ́a rɨnɨrarɨŋɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pairato re urɨŋɨnigɨnɨ, “Nionɨ dɨxɨ́ Judayɨ́ wonɨranɨ? Dɨxɨ́ gwɨ́ axɨ́rí imónɨgɨ́áyɨ́ tɨ́nɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ joxɨ nɨrɨmeámɨ nɨbɨro nionɨ tɨ́ŋɨ́ re rɨwáráoɨ. Joxɨ pí éagɨ nɨmeámɨ rɨbáoɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisaso re urɨŋɨnigɨnɨ, “Ámá mɨxɨ́ ináyɨ́ nimónɨro xwɨ́á tɨ́yo meŋweaarɨgɨ́áyɨ́ yapɨ mimónɨŋɨnɨ. Nionɨ xwɨ́á tɨ́yo dáŋɨ́yɨ́ mɨxɨ́ ináyɨ́ imónɨ́wɨnɨgɨnɨrɨ mɨnɨrɨ́peagɨ́á eŋagɨ nánɨ xwɨ́á tɨ́yo meŋweaarɨgɨ́áyɨ́nɨŋɨ́ mimónɨŋɨnɨ. Mɨxɨ́ ináyɨ́ xwɨ́á tɨ́yo dáŋɨ́ wonɨ nimónɨrɨ sɨŋwɨrɨyɨ́, gɨ́ Judayowa ɨ́á mɨnɨxɨrɨpa oépoyɨnɨrɨ gɨ́ sɨmɨŋɨ́ nínarɨgɨ́áyɨ́ mɨxɨ́ nɨwiipaxɨ́rɨnɨ. E nɨrɨrɨrɨ aí mɨxɨ́ ináyɨ́ nionɨ imónɨŋápɨ xwɨ́á tɨ́yo dáŋɨ́manɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pairato re urɨŋɨnigɨnɨ, “Ayɨnánɨ ‘Joxɨ mɨxɨ́ ináyɨ́ woxɨrɨnɨ.’ nimónarɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “ ‘Mɨxɨ́ ináyoxɨrɨnɨ.’ joxɨ xɨxenɨ nɨrarɨŋɨnɨ. Nionɨ nepaxɨŋɨ́ imónɨŋɨ́pɨ ámáyo áwaŋɨ́ urɨ́ɨmɨgɨnɨrɨ gɨ́ ókí nɨxɨrɨrɨ xwɨ́á tɨ́yo nánɨ bɨrɨ eŋárɨnɨ. Ámá nepaxɨŋɨ́ imónɨŋɨ́pɨ xɨ́darɨgɨ́á gɨyɨ́ gɨyɨ́ nɨ́nɨ nionɨ arɨ́á niarɨgɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pairato re urɨŋɨnigɨnɨ, “Nepaxɨŋɨ́ imónɨŋɨ́pɨ pírɨnɨ?” urɨŋɨnigɨnɨ. E nurɨmo Judayɨ́ nɨ́nɨ tɨ́ŋɨ́ e nánɨ nɨpeyearɨ re urɨŋɨnigɨnɨ, “O xwɨyɨ́á meárɨnɨpaxɨ́ bɨ rarɨŋagɨ arɨ́á mɨwíɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E nerɨ aí xwiogwɨ́ ayɨ́ ayo sɨ́á Aŋɨ́najo Neamúroagoɨ rarɨgɨ́áyi nánɨ aiwá imɨxarɨ́ná ámá gwɨ́ ŋweaŋɨ́ wo seawáriarɨŋárɨnɨ. ‘Judayeneyá mɨxɨ́ ináyɨ́ imónɨŋo oneawárinɨ.’ rɨseaimónarɨnɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ayɨ́ xwamiánɨ́ nɨwiéra nuro “Omɨ mɨneawáripanɨ. Barabasomɨ —O ámáyá amɨpí pɨkioráparɨŋɨ́ worɨnɨ. Omɨ neawáriɨ.” nura ugɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ayɨ́ Pairatomɨ e urarɨŋagɨ́a nánɨ porisowa Jisasomɨ nɨmeámɨ nuro sɨkwɨ́á nearo ragɨ́ pɨ́rɨ́ nuyɨkiárɨmáná ");
INSERT INTO aak_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ópɨyá eŋɨ́nɨŋɨ́ imónɨŋɨ́ wɨrí nɨkɨ́kɨyimáná mɨxɨ́ ináyɨ́ amɨnaŋwɨ́nɨŋɨ́ imónɨŋɨ́ mɨŋɨ́yo dɨ́kínarɨgɨ́ápa mɨŋɨ́yo udɨ́kiárɨro rapɨrapɨ́ ayɨ́á rɨŋɨ́ mɨxɨ́ ináyɨ́ yínarɨgɨ́á wú nɨmearo omɨ uyírɨro nɨyárɨmáná ");
INSERT INTO aak_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","xɨ́o tɨ́ŋɨ́ e aŋwɨ e uro “Ámɨnáoxɨnɨ, Judayɨ́yá mɨxɨ́ ináyoxɨrɨnɨ.” urɨro wé upɨkákwiro nɨyayimáná eŋáná ");
INSERT INTO aak_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pairato ámɨ nɨpeyearɨ re urɨŋɨnigɨnɨ, “Arɨ́á nípoyɨ. ‘Xwɨyɨ́á meárɨnɨpaxɨ́ bɨ mɨrarɨŋagɨ arɨ́á nɨwirɨ nɨmeámɨ rɨ́wiaparɨnɨ?’ oniaiwípoyɨnɨrɨ nɨmeámɨ ɨ́wiaparɨŋɨnɨ.” nurɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jisaso, ópɨyá eŋɨ́nɨŋɨ́ imónɨŋɨ́rí udɨ́kiárɨro rapɨrapɨ́ ayɨ́á rɨŋú uyírɨro éɨ́o ɨ́wiapáná Pairato ámá e awí neaárɨmáná rogɨ́áyo re urɨŋɨnigɨnɨ, “Ámá royoɨ. Sɨŋwɨ́ wɨnɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa tɨ́nɨ aŋɨ́ rɨdɨyowá yarɨgɨ́iwámɨ awí mearoarɨgɨ́áwa tɨ́nɨ omɨ sɨŋwɨ́ nɨwɨnɨróná xwamiánɨ́ nɨwiro “Íkɨ́áyo yekwɨroárɨ́poyɨ. Íkɨ́áyo yekwɨroárɨ́poyɨ.” urɨ́agɨ́a Pairato re urɨŋɨnigɨnɨ, “Nionɨ o xwɨyɨ́á meárɨnɨpaxɨ́ bɨ mɨrarɨŋagɨ arɨ́á nɨwirɨ nánɨ sewanɨŋoyɨ́né nɨmeáa nuro yekwɨroárɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judayowa re urɨgɨ́awixɨnɨ, “O nánɨ negɨ́ ŋwɨ́ ikaxɨ́ eánɨŋɨ́yo dánɨ bɨ rɨnɨnɨ. Ayo dánɨ ‘Xe sɨŋɨ́ ounɨ.’ rɨpaxɨ́ mimónɨnɨ. O ‘Niaíwɨ́ Gorɨxoyáonɨrɨnɨ.’ rɨnɨŋɨ́ eŋagɨ nánɨ xe sɨŋɨ́ ounɨrɨ sɨŋwɨ́ wɨnɨpaxɨ́ menɨnɨ. Xe pɨkoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pairato xwɨyɨ́á apɨ arɨ́á nɨwirɨ́ná wáyɨ́ ámɨ bɨ tɨ́nɨ nɨwinɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ámɨ gapɨmanowayá aŋiwámɨ nɨpáwirɨ Jisasomɨ yarɨŋɨ́ re wiŋɨnigɨnɨ, “Joxɨ gɨmɨ dáŋoxɨrɨnɨ?” urɨ́agɨ aí Jisaso xwɨyɨ́á bɨ murɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Xwɨyɨ́á bɨ murarɨŋagɨ nɨwɨnɨrɨ nánɨ re urɨŋɨnigɨnɨ, “Joxɨ xwɨyɨ́á bɨ mɨnɨrɨ́ rɨyarɨŋɨnɨ? ‘O íkɨ́áyo nɨyekwɨroárɨrɨ níkweawárɨrɨ mepa epaxorɨnɨ.’ rɨniaiwiarɨŋɨnɨ? Gɨ́ dɨŋɨ́ tɨ́nɨ nɨrɨyekwɨroárɨrɨ́ná nɨrɨyekwɨroárɨpaxɨ́rɨnɨ. Nɨrɨwárɨrɨ́ná nɨrɨwárɨpaxɨ́rɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisaso re urɨŋɨnigɨnɨ, “Eramɨ ŋweaŋo apɨ xe oimónɨrɨ sɨŋwɨ́ mɨranɨpa nerɨ sɨŋwɨrɨyɨ́, joxɨyá dɨŋɨ́ tɨ́nɨ wí e rɨpaxɨ́ imónɨmɨnɨrɨ éɨ́manɨ. Ayɨnánɨ sɨpí joxɨ nirɨ́pɨ xwé nerɨ aiwɨ nionɨ joxɨ tɨ́e nánɨ nɨwiowárɨ́oyápɨ aga seáyɨ e imónɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pairato arɨ́á e nɨwirɨ nánɨ omɨ wárɨmɨnɨrɨ éɨ́yɨ́ Judayɨ́ xwamiánɨ́ nɨwiayiro re urɨgɨ́awixɨnɨ, “Joxɨ ámá romɨ níkwearɨ nɨwárɨrɨ́náyɨ́, émáyɨ́néyá mɨxɨ́ ináyɨ́ Sisao tɨ́nɨ nɨkumɨxɨnɨrɨ emearɨŋɨ́ woxɨ mimónɨŋɨnɨ. Ámá go go xewanɨŋo nánɨ ‘Mɨxɨ́ ináyonɨrɨnɨ.’ nɨrɨnɨrɨ́náyɨ́, Sisaomɨ mamówárɨmɨnɨrɨ yarɨŋɨ́ eŋagɨ nánɨ rarɨŋɨnɨ.” urarɨŋagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairato xwɨyɨ́á apɨ arɨ́á e nɨwirɨ nánɨ Jisasomɨ nɨmeámɨ wáɨ́ e nɨpeyearɨ sɨ́ŋá tɨ́nɨ wáɨ́ imɨxɨnɨŋe —Ayɨ́ Xibɨruyɨ́ pɨ́né tɨ́nɨ Gabataɨ rɨnɨŋerɨnɨ. E íkwiaŋwɨ́ xwɨrɨxɨ́ numerɨ́ná éɨ́ ŋweaarɨgɨ́ánamɨ éɨ́ nɨŋwearɨ ");
INSERT INTO aak_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","—Sɨ́á ayi Judayɨ́ Aŋɨ́najo Múroŋɨ́yi nánɨ aiwá imɨxárarɨgɨ́áyirɨnɨ. Ayimɨ sogwɨ́ rɨxa áwɨnɨmɨ ŋweámɨnɨrɨ eŋáná Pairato re urɨŋɨnigɨnɨ, “Sɨŋwɨ́ wɨnɨ́poyɨ. Segɨ́ mɨxɨ́ ináyo riworɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Judayɨ́ xwamiánɨ́ re wigɨ́awixɨnɨ “Xe nɨmeáa xe nɨmeáa oúpoyɨ. Nɨmeáa nuro íkɨ́áyo yekwɨroárɨ́poyɨ.” urarɨŋagɨ́a Pairato re urɨŋɨnigɨnɨ, “Segɨ́ mɨxɨ́ ináyo ‘Íkɨ́áyo oyekwɨroárɨnɨ.’ rɨseaimónarɨnɨ?” urɨ́agɨ apaxɨ́pánɨŋɨ́ imónɨgɨ́á xwéowa re urɨgɨ́awixɨnɨ, “Negɨ́ mɨxɨ́ ináyɨ́ ámɨ wo menɨnɨ. Émáyɨ́néyá mɨxɨ́ ináyɨ́ Sisao enɨ negorɨnɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pairato Jisasomɨ oyekwɨroárɨpoyɨnɨrɨ porisowamɨ tɨ́nɨ wiowárɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisasomɨ aŋɨ́ apimɨ dánɨ nɨméra nuróná xewanɨŋo íkɨ́á yoxáɨ́pá xwaŋwɨ́ níkwónɨmɨ nurɨ wí e xwɨ́á yoɨ́ bɨ Mɨŋɨ́ Gɨxweáɨ rɨnɨŋe —Xibɨruyɨ́ pɨ́né Gorɨgotaɨ rɨnɨŋerɨnɨ. E nɨrémoro ");
INSERT INTO aak_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","e Jisasomɨ yekwɨroárɨgɨ́awixɨnɨ. Nɨyekwɨroárɨróná Jisaso áwɨnɨ e eŋáná ámá waú enɨ mɨdɨmɨdánɨ yekwɨroárɨgɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pairato rɨ́wamɨŋɨ́ bɨ re nɨrɨrɨ nearɨ yoxáɨ́pámɨ seáyɨ e pɨ́rauŋɨnigɨnɨ, “Nasaretɨ dáŋɨ́ Jisaso, Judayɨ́ mɨxɨ́ ináyorɨnɨ.” rɨ́wamɨŋɨ́ e nearɨ pɨ́raúagɨ ");
INSERT INTO aak_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisasomɨ yekwɨroárɨ́e aŋɨ́ apimɨ ná jɨ́amɨ mimónɨŋagɨ nánɨ Judayɨ́ obaxɨ́ nɨpuróná rɨ́wamɨŋɨ́pɨ —Apɨ nearɨ́ná Xibɨruyɨ́ pɨ́né tɨ́nɨ earɨ Romɨyɨ́ pɨ́né tɨ́nɨ earɨ Gɨrikɨyɨ́ pɨ́né tɨ́nɨ earɨ eŋɨ́pɨrɨnɨ. Apɨ ɨ́á roarɨŋagɨ́a nánɨ ");
INSERT INTO aak_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Apaxɨ́pánɨŋɨ́ imónɨgɨ́á seáyɨ e imónɨgɨ́áwa Pairatomɨ re urɨgɨ́awixɨnɨ, “Joxɨ rɨ́wamɨŋɨ́ re nɨrɨrɨ meapanɨ, ‘Judayɨ́ mɨxɨ́ ináyorɨnɨ.’ nɨrɨrɨ meapanɨ. Sa re nɨrɨrɨ eaɨ, ‘Xewanɨŋo “Judayɨ́ mɨxɨ́ ináyonɨrɨnɨ.” rɨnɨŋorɨnɨ.’ nɨrɨrɨ eaɨ.” urɨ́agɨ́a aí ");
INSERT INTO aak_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pairato re urɨŋɨnigɨnɨ, “Nionɨ eáápɨ xe oeánɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Porisowa Jisasomɨ rɨxa nɨyekwɨroárɨmáná rapɨrapɨ́ amɨpí o yínɨŋɨ́pɨ yaŋɨ́ nɨmero biaú biaú nɨtɨro nowanɨ xɨxenɨ nɨmearo aí xegɨ́ sorɨ́á gwɨ́ bɨ mɨkiwénɨŋú —Ú nimɨxɨrɨ́ná axúnɨ imɨxárɨgɨ́úrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ú nánɨ re rɨnɨgɨ́awixɨnɨ, “None maxepa oyaneyɨ. Áwɨnɨ e nɨtɨmáná go go meanɨrɨ́enɨŋoɨnɨrɨ sárú oyaneyɨ.” rɨnɨgɨ́awixɨnɨ. Bɨkwɨ́yo xwɨyɨ́á nɨrɨnɨrɨ eánɨŋɨ́ rɨpɨ, “Rapɨrapɨ́ nionɨ seáyɨ e yínarɨŋáyɨ́ yaŋɨ́ ninɨro gɨ́ sorɨ́á meapɨ́rɨ nánɨ go go meanɨrɨ́enɨŋoɨnɨrɨ sárú egɨ́awixɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ porisowa e egɨ́awixɨnɨ. Jisasomɨ xɨnáí tɨ́nɨ xɨnɨsɨmáí tɨ́nɨ Kɨriopasomɨ xiepí Mariaí tɨ́nɨ Magɨdara dáŋɨ́ Mariaí tɨ́nɨ íwa íkɨ́á yoxáɨ́ Jisasomɨ yekwɨroárɨnɨŋɨ́pámɨ aŋwɨ e roŋáná ");
INSERT INTO aak_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisaso xegɨ́ xɨnáí e roŋagɨ nɨwɨnɨrɨ wiepɨsarɨŋɨ́ xɨ́o dɨŋɨ́ sɨxɨ́ uyiŋo enɨ aŋwɨ e roŋagɨ nɨwɨnɨrɨ xɨnáímɨ re urɨŋɨnigɨnɨ, “Ineyɨ, dɨxɨ́ íwo iworɨnɨ.” nɨrɨmáná ");
INSERT INTO aak_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","wiepɨsarɨŋomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ rɨnáí iyírɨnɨ.” urɨ́agɨ wiepɨsarɨŋo sɨ́á ayimɨ dánɨ xegɨ́ aŋɨ́yo nánɨ píránɨŋɨ́ numéra uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","E nurárɨmo nɨjɨ́á re nimónɨrɨ́ná “Xano e éwɨnɨgɨnɨrɨ nɨrɨŋɨ́pɨ rɨxa nɨpɨnɨ yárɨ́ɨnɨ.” nɨjɨ́á e nimónɨrɨ́ná Bɨkwɨ́yo xɨ́o nánɨ nɨrɨnɨrɨ eánɨŋɨ́ nɨpɨnɨ xɨxenɨ oimónɨrɨ re rɨŋɨnigɨnɨ, “Iniɨgɨ́ nánɨ ninarɨnɨ.” ráná ");
INSERT INTO aak_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","sɨxɨ́ wainɨ́ mɨxɨ́ yarɨŋɨ́pɨ magwɨ́ ínɨŋɨ́ wá weŋagɨ nánɨ wa írɨkwɨ́ bɨ nɨmearo iniɨgɨ́ wainɨ́ apimɨ igɨ́á neámáná xisopɨ́yɨ rɨnɨŋɨ́ wegwɨ́ánɨŋɨ́ imónɨŋɨ́wámɨ nikɨroárɨmáná xegɨ́ maŋɨ́ tɨ́ŋɨ́ e wimɨxɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisaso wainɨ́ mɨxɨ́ yarɨŋɨ́pɨ nɨnɨmáná “Rɨxa pɨxwɨ́nɨgoɨ.” nɨrɨrɨ mɨŋɨ́ warɨ́ ninɨrɨ dɨŋɨ́ nɨyámɨga uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sɨ́á Jisasomɨ yekwɨroárɨgɨ́áyi —Ayi aŋɨ́najo Judayo múroŋɨ́ nánɨ aiwá amɨpí píránɨŋɨ́ nimɨxɨro tarɨgɨ́áyirɨnɨ. Ayi rɨxa sɨ́á óráná Sabarɨ́á aga seáyɨ e imónɨŋɨ́yi nimónɨnɨ eŋagɨ nánɨ porisowa Jisasomɨ tɨ́nɨ awaúmɨ tɨ́nɨ awí meŋweaŋáná sabarɨ́á imónɨnɨgɨnɨrɨ Judayɨ́ ámɨnáowa nuro Pairatomɨ re urɨgɨ́awixɨnɨ, “Apaxɨ́ mé dɨŋɨ́ sɨmɨgwɨ́á nɨyinɨrɨ opépoyɨnɨrɨ sɨkwɨ́yo eŋɨ́ pɨ́rɨ́ jeápoyɨ. Nɨpéáná wigɨ́ warápɨ oyoaneyɨnɨrɨ eŋɨ́ pɨ́rɨ́ jeápoyɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","porisowa nuro mɨdɨmɨdánɨ yekwɨroárɨgɨ́íwaúmɨ sɨkwɨ́yo pɨ́rɨ́ nɨjearo aí ");
INSERT INTO aak_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jisaso yekwɨroárɨnɨŋe wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. O rɨxa nɨpéagɨ nɨwɨnɨro nánɨ xegɨ́ sɨkwɨ́ pɨ́rɨ́ mɨjeapa nero aí ");
INSERT INTO aak_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","porisɨ́ wo wákwɨrɨxá tɨ́nɨ ayɨŋwɨ́ ikɨróáná axíná iniɨgɨ́ tɨ́nɨ ragɨ́ tɨ́nɨ ɨ́wiapɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ámá Porisowa e yarɨ́ná sɨŋwɨ́ wɨnaroŋáonɨ áwaŋɨ́ nɨrɨrɨ́ná xɨxenɨ aga nepa rɨŋárɨnɨ. Nionɨ rarɨŋápɨ nɨjɨ́á xɨxenɨ e nimónɨrɨ nánɨ seyɨ́né “Neparɨnɨ.” yaiwiro dɨŋɨ́ ɨkwɨ́roro éɨ́rɨxɨnɨrɨ áwaŋɨ́ seararɨŋɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bɨkwɨ́yo re nɨrɨnɨrɨ eánɨŋɨ́pɨ xɨxenɨ imónɨnɨ nánɨ porisowa omɨ e wigɨ́awixɨnɨ, “Xegɨ́ eŋɨ́ bɨ pɨ́rɨ́ jeapɨ́rɨ́ámanɨ.” ");
INSERT INTO aak_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bɨkwɨ́yo ámɨ bɨ re nɨrɨnɨrɨ eánɨŋɨ́pɨ, “Ayɨŋwɨ́ ikɨroárɨgɨ́omɨ sɨŋwɨ́ wɨnɨpɨ́rɨ́árɨnɨ.” rɨnɨŋɨ́pɨ enɨ xɨxenɨ e imónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","E nɨyárɨmáná eŋáná ámá wo —O Arimatia dáŋɨ́ Josepoyɨ rɨnɨŋorɨnɨ. O Jisasoyá wiepɨsarɨŋɨ́yɨ́ wo aí Judayɨ́ ámɨnáowamɨ wáyɨ́ nɨwirɨ nánɨ ínɨmɨ xɨ́darɨŋorɨnɨ. O Pairato tɨ́ŋɨ́ e nánɨ nurɨ “Jisaso pɨyo omeámɨnɨ.” uráná Pairato xe omeanɨrɨ sɨŋwɨ́ wɨnɨ́agɨ o nurɨ pɨyomɨ xwɨ́á weyárɨmɨnɨrɨ nánɨ nɨmeámɨ úáná ");
INSERT INTO aak_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ámá ámɨ wo —Xegɨ́ yoɨ́ Nikodimasoyɨ rɨnɨŋorɨnɨ. O xámɨ árɨ́wɨyimɨ Jisaso tɨ́nɨ xwɨyɨ́á rɨnɨgɨ́íorɨnɨ. O enɨ nɨbɨrɨ íkɨ́á dɨ́á biaú —Bɨ murɨ́yɨ rɨnɨŋɨ́pɨ tɨ́nɨ bɨ earosɨ́yɨ rɨnɨŋɨ́pɨ tɨ́nɨ apiaúrɨnɨ. Apiaú xámɨ nawínɨ niɨ́á megɨ́ápiaú xegɨ́ saŋɨ́ 30 kiro imónɨŋɨ́pɨrɨnɨ. Apɨ tɨ́nɨ pɨyomɨ xópé oemɨnɨrɨ nɨmeámɨ nɨbɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","awaú pɨyomɨ nɨmeari Judayɨ́ wigɨ́ ámá pɨyɨ́ nɨtɨrɨ́ná yarɨgɨ́ápa rapɨrapɨ́yo rɨ́gwɨrɨ́gwɨ́ nɨroríná íkɨ́á dɨ́á dɨŋɨ́ naŋɨ́ earɨŋɨ́pɨ tɨ́nɨ xópé nɨyárɨmáná ");
INSERT INTO aak_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","nɨmeámɨ omɨŋɨ́ aŋwɨ e inɨŋɨ́pimɨ nánɨ —Omɨŋɨ́ apɨ Jisasomɨ yekwɨroárɨ́e dánɨ aŋwɨ e eŋɨ́pɨrɨnɨ. Sɨ́ŋá óɨ́ sɨnɨ ámá mɨtarɨgɨ́áyi tɨ́ŋɨ́pɨrɨnɨ. Omɨŋɨ́ apimɨ nánɨ nɨmeáa nuri ");
INSERT INTO aak_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","sɨ́á ayi Sabarɨ́á nánɨ Judayɨ́ amɨpí píránɨŋɨ́ nimɨxɨro tarɨgɨ́áyi imónɨŋagɨ nánɨ sɨ́ŋá óɨ́ aŋwɨ e inɨŋɨ́yimɨ nánɨ nɨmeámɨ nuri e tɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sadéyo wɨ́á mónɨŋɨ́mɨ sɨnɨ sɨ́á yinɨŋáná Magɨdara dáŋɨ́ Mariaí sɨ́ŋá óɨ́yimɨ Jisaso weŋe nánɨ nurɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Sɨ́ŋá xwé óɨ́yimɨ éɨ́ rárárɨnɨŋo sɨnɨ mɨpɨ́rónɨ́ rɨxa wí e weŋagɨ nɨwɨnɨmɨ ");
INSERT INTO aak_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","aŋɨ́nɨ nurɨ Saimonɨ Pitaomɨ tɨ́nɨ wiepɨsiŋɨ́ wɨ́o, xɨ́o dɨŋɨ́ sɨxɨ́ uyiŋomɨ tɨ́nɨ nɨwímearɨ re urɨŋɨnigɨnɨ, “Ámɨnáomɨ rɨxa nexwearo gɨmɨ rɨ́a tɨ́awixɨnɨ? Newané majɨ́árɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pitao tɨ́nɨ wiepɨsiŋɨ́ wɨ́o tɨ́nɨ aŋɨ́ e pɨ́nɨ nɨwiárɨmɨ xwárɨpáyo nánɨ nuri ");
INSERT INTO aak_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","aŋaŋɨ́nɨ nuri wɨ́o Pitaomɨ nɨmúrorɨ xwárɨpáyo xámɨ nɨrémorɨ ");
INSERT INTO aak_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","nɨrɨ́kwínɨrɨ ínɨmɨ wenɨŋɨ́ yánɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Rapɨrapɨ́ Jisasomɨ xopɨxopɨ́ rónɨŋúnɨ weŋagɨ nɨwɨnɨrɨ aiwɨ ínɨmɨ mɨpáwí wenɨŋɨ́ yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimonɨ Pitao enɨ rɨ́wɨ́yo nɨbɨrɨ bɨ́arɨwámɨnɨ éɨ́ nɨrómáná wenɨŋɨ́ mé xwárɨpáyo ínɨmɨ nɨpáwirɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Rapɨrapɨ́ xopɨxopɨ́ rónɨŋúnɨ weŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","rapɨrapɨ́ mɨŋɨ́yo xopɨxopɨ́ rogɨ́íú wɨ́ú tɨ́nɨ nawínɨ mɨwé xegɨ́ wí e nɨkɨ́rónɨrɨ weŋagɨ wɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","wiepɨsiŋɨ́ wɨ́o, xámɨ xwárɨpáyo rémóo enɨ nɨpáwirɨ rapɨrapɨ́ e imónɨŋagɨ nɨwɨnɨrɨ “Neparɨnɨ.” nɨyaiwirɨ dɨŋɨ́ wɨkwɨ́roŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Íná awaú Bɨkwɨ́yo Jisaso ámɨ xwárɨpáyo dánɨ nɨwiápɨ́nɨmeanɨ́ápɨ nánɨ nɨrɨnɨrɨ eánɨŋɨ́pɨ nánɨ sɨnɨ píránɨŋɨ́ dɨŋɨ́ mɨmopa neri majɨ́á neri nánɨ ");
INSERT INTO aak_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ámɨ egɨ́ aŋɨ́ e nánɨ ugɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariaí xwárɨpá tɨ́ŋɨ́ e aŋwɨ e nɨrómáná ŋwɨ́ nearɨ e nerɨ́ná xwárɨpáyo ínɨmɨ nɨrɨ́kwínɨrɨ wenɨŋɨ́ yánɨ́ɨ́yɨ́ wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jisaso tɨgɨ́e aŋɨ́najɨ́ waú rapɨrapɨ́ apɨ́á weŋɨ́ nɨyínɨmáná wɨ́o mɨŋɨ́ tɨgɨ́ámɨnɨ ŋwearɨ wɨ́o sɨkwɨ́ tɨgɨ́ámɨnɨ ŋwearɨ eŋagɨ́i wɨnáná ");
INSERT INTO aak_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","awaú Mariaímɨ re urɨgɨ́isixɨnɨ, “Ineyɨ, jíxɨ pí nánɨ ŋwɨ́ eaarɨŋɨnɨ?” urɨ́agɨ́i í re urɨŋɨnigɨnɨ, “Gɨ́ Ámɨnáo nexwearɨ tɨ́e nánɨ niínɨ majɨ́á eŋagɨ nánɨ ŋwɨ́ eaarɨŋɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","nɨkɨnɨmónɨrɨ wenɨŋɨ́ éɨ́yɨ́ wɨnɨŋɨnigɨnɨ. Jisaso daiwo roŋagɨ nɨwɨnɨrɨ aiwɨ mí mɨwómɨxɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mí mɨwómɨxɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Ineyɨ, pí nánɨ jíxɨ ŋwɨ́ eaarɨŋɨnɨ? Go nánɨ pɨ́á yarɨŋɨnɨ?” urɨ́agɨ Mariaí omɨŋɨ́ xiáwo nɨrarɨnɨrɨ re urɨŋɨnigɨnɨ, “Ápoxɨnɨ, joxɨ pɨyomɨ nɨmeámɨ nurɨ wí e tɨ́ɨrá oeŋwɨrɨyɨ́ áwaŋɨ́ nɨreɨ. Niínɨ nurɨ nɨmearɨ nɨmeámɨ umɨ́ɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisaso “Mariaíxɨnɨ!” urɨ́agɨ í nɨkɨnɨmónɨrɨ Xibɨruyɨ́ pɨ́né tɨ́nɨ Rabonaiyɨ —Apɨ “Nearéwapɨyarɨŋoxɨnɨ.” nɨrɨrɨ́ná rarɨgɨ́ápɨrɨnɨ. E urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisaso re urɨŋɨnigɨnɨ, “Nionɨ sɨnɨ gɨ́ ápo tɨ́e nánɨ mɨpeyíá eŋagɨ nánɨ jíxɨ ɨ́á mɨnɨxepanɨ. Jíxɨ nurɨ ámá nionɨ gɨ́ nɨrɨxɨ́meá imónɨgɨ́áyo re ureɨ, ‘O re rɨŋoɨ, “Nionɨ gɨ́ ápo Gorɨxo tɨ́e nánɨ peyarɨŋɨnɨ. O seyɨ́né enɨ segɨ́ ápo Gorɨxorɨnɨ.” rɨŋoɨ.’ urémeaɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magɨdara dáŋɨ́ Mariaí nurɨ xegɨ́ wiepɨsiŋɨ́yo áwaŋɨ́ re urémeaŋɨnigɨnɨ, “Niínɨ Ámɨnáomɨ rɨxa sɨŋwɨ́ wɨnɨ́ɨnɨ. Xɨ́o nɨrɨ́ɨ́pɨ, ayɨ́ apɨrɨnɨ. Ayɨ́ apɨrɨnɨ.” nura uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sadéyo sɨ́á axɨ́yimɨ sɨ́ápɨ tɨ́nɨ wiepɨsiŋowa Judayɨ́ ámɨnáowa nánɨ wáyɨ́ nero nánɨ aŋɨ́ wigɨ́ ŋweagɨ́iwámɨ ówaŋɨ́ xaíwɨ́ nɨyárɨmáná ŋweaŋáná re eŋɨnigɨnɨ. Jisaso awamɨ áwɨnɨ e nɨrónapɨrɨ re urɨŋɨnigɨnɨ, “ ‘Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro oŋweápoyɨ.’ nimónarɨnɨ.” nurɨmáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wé nirɨ́ ogɨ́úkaú sɨwá wirɨ miwɨ́ wákwɨrɨxá tɨ́nɨ ikɨrogɨ́áyi sɨwá wirɨ éagɨ wiepɨsiŋowa Jisaso ámɨ sɨŋɨ́ eŋagɨ sɨŋwɨ́ nɨwɨnɨro nánɨ dɨŋɨ́ niɨ́á winarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ámɨ re urɨŋɨnigɨnɨ, “ ‘Soyɨ́né Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro oŋweápoyɨ.’ nimónarɨnɨ. Ápo nionɨ xwɨ́á tɨ́yo nɨrowárénapɨŋɨ́pa nionɨ enɨ soyɨ́né searowárarɨŋɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","awamɨ pɨ́rámɨ́ imɨmɨ́ nɨwiowárɨrɨ re urɨŋɨnigɨnɨ, “Kwíyɨ́ Gorɨxoyápɨ numímɨnɨro apɨ tɨ́nɨ nawínɨ eméɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Soyɨ́né ámá ɨ́wɨ́ yarɨgɨ́ápɨ yokwarɨmɨ́ nerɨ́náyɨ́, ayɨ́ Gorɨxo enɨ yokwarɨmɨ́ wiiarɨnɨ. Soyɨ́né yokwarɨmɨ́ mɨwiipa nerɨ́náyɨ́, ayɨ́ Gorɨxo enɨ yokwarɨmɨ́ mɨwiiarɨnɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wiepɨsiŋowa wo, Tomaso —O wiepɨsiŋɨ́ wé wúkaú sɨkwɨ́ waú imónɨgɨ́áwa worɨnɨ. Xegɨ́ yoɨ́ ámɨ bɨ Didimasorɨnɨ. O mɨŋweaŋáná wɨ́a Jisaso wiwanɨŋowamɨnɨ wímeáɨ́ eŋagɨ nánɨ ");
INSERT INTO aak_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomasomɨ re urɨgɨ́awixɨnɨ, “None Ámɨnáomɨ rɨxa sɨŋwɨ́ wɨnɨ́wɨnɨ.” urɨ́agɨ́a aí o re urɨŋɨnigɨnɨ, “Nionɨ wéyo nirɨ́ ogɨ́áyaú mɨwɨnɨpa erɨ nirɨ́ ogɨ́áyaúmɨ wé mɨwíxɨ́mopa erɨ miwɨ́ wákwɨrɨxá tɨ́nɨ ikɨrogɨ́áyimɨ gɨ́ wé mɨwíxɨ́mopa erɨ nerɨ́náyɨ́, dɨŋɨ́ wí ‘Nepa orɨnɨ.’ nɨyaiwirɨ wɨkwɨ́rómɨméɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sɨ́á wé wɨ́úmɨ dáŋɨ́ waú wo nórɨmáná eŋáná ámɨ xegɨ́ wiepɨsiŋowa aŋɨ́yo ínɨmɨ ŋweaŋáná Tomaso enɨ wɨ́a tɨ́nɨ nerɨmeánɨro ŋweaŋáná Jisaso aŋɨ́ ówaŋɨ́ nɨyárɨnɨŋagɨ aiwɨ awamɨ áwɨnɨ e nɨrónapɨmáná re urɨŋɨnigɨnɨ, “ ‘Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨwayɨrónɨro oŋweápoyɨ.’ nimónarɨnɨ.” nurɨmáná ");
INSERT INTO aak_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasomɨ re urɨŋɨnigɨnɨ, “Dɨxɨ́ wé sɨ́mɨ́ re nɨnimɨxénapɨrɨ gɨ́ wéyo sɨŋwɨ́ naneɨ. Dɨxɨ́ wé re nɨnimɨxénapɨrɨ gɨ́ miwɨ́yo nɨwíxɨ́moɨ. Sɨnɨ dɨŋɨ́ mɨnɨkwɨ́ró mepanɨ. Aga dɨŋɨ́ nɨkwɨ́roɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso re urɨŋɨnigɨnɨ, “Joxɨ gɨ́ Ámɨnáoxɨrɨnɨ. Gɨ́ Ŋwɨ́áoxɨrɨnɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisaso re urɨŋɨnigɨnɨ, “Joxɨ sɨŋwɨ́ nɨnanɨrɨ nánɨ rɨxa ‘Neparɨnɨ.’ nɨyaiwirɨ dɨŋɨ́ rɨnɨkwɨ́róɨnɨ? Ámá nionɨ sɨŋwɨ́ mɨnanɨpa nero aí ‘Neparɨnɨ.’ nɨyaiwiro dɨŋɨ́ nɨkwɨ́róɨ́áyɨ́ yayɨ́ winɨŋɨ́yɨ́rɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisaso emɨmɨ́ ámɨ ayá wí wiepɨsarɨŋowa sɨŋwɨ́ anɨgɨ́e dánɨ eŋɨ́ aí apɨ nánɨ bɨkwɨ́ rɨpimɨ rɨ́wamɨŋɨ́ bɨ meánɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","E nerɨ aí seyɨ́né Jisasomɨ dɨŋɨ́ wɨkwɨ́roro “O Kiraiso, ámá yeáyɨ́ neayimɨxemeanɨ́a nánɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ arɨ́owayá xwɨ́á piaxɨ́yo dánɨ iwiaronɨ́oyɨ rarɨŋwáorɨ́anɨ?” wiaiwiro “Gorɨxoyá xewaxorɨ́anɨ?” wiaiwiro éɨ́rɨxɨnɨrɨ rɨ́wamɨŋɨ́ rɨpɨ nɨrɨnɨrɨ eánɨnɨ. Omɨ dɨŋɨ́ nɨwɨkwɨ́rorɨŋɨ́pimɨ dánɨ dɨŋɨ́ nɨyɨmɨŋɨ́ imónɨŋɨ́pɨ tɨ́gɨ́áyɨ́ imónɨ́ɨ́rɨxɨnɨrɨ nɨrɨnɨrɨ eánɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jisaso e néɨsáná xegɨ́ wiepɨsiŋowamɨ ipí Taibiriasɨyɨ rɨnɨŋɨ́wá —Xegɨ́ yoɨ́ bɨ Gaririyɨ rɨnɨŋɨ́wárɨnɨ. Awá rɨwoŋe ámɨ sɨŋánɨ sɨwá nɨwinɨrɨ́ná rɨpɨ eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimonɨ Pitao tɨ́nɨ Tomaso, Didimasoyɨ rɨnɨŋo tɨ́nɨ Gariri pɨropenɨsɨ́yo aŋɨ́ yoɨ́ Kena dáŋɨ́ Nataniero tɨ́nɨ Sebediomɨ xewaxowaú tɨ́nɨ wiepɨsiŋɨ́ ámɨ waú tɨ́nɨ awa nerɨmeánɨro nawínɨ nɨŋwearóná ");
INSERT INTO aak_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimonɨ Pitao re urɨŋɨnigɨnɨ, “Nionɨ ubenɨ́ ipíyo mamówárɨmɨ umɨ́ɨnɨ.” urɨ́agɨ awa re urɨgɨ́awixɨnɨ, “None enɨ joxɨ tɨ́nɨ wanɨ́wɨnɨ.” nurɨro nɨpeyearo ewéyo nɨpɨxemoánɨro sɨ́á ayimɨ árɨ́wɨyimɨ peyɨ́ nánɨ néra nuro aiwɨ sɨmí egɨ́awixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rɨxa sogwɨ́ xemónapɨmɨnɨrɨ yarɨŋɨ́ tɨ́nɨ Jisaso nɨbɨrɨ ipí imaŋɨ́pá tɨ́nɨ roŋagɨ aiwɨ xegɨ́ wiepɨsiŋowa omɨ mí mɨwómɨxɨ́ éagɨ́a ");
INSERT INTO aak_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisaso re urɨŋɨnigɨnɨ, “Niaíwɨ́yɨ́né, segɨ́ ubenɨ́ mamówárarɨgɨ́áyo peyɨ́ ɨ́á mɨmɨnɨpa reŋoɨ?” uráná awa “Oweoɨ.” urɨ́agɨ́a ");
INSERT INTO aak_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","o re urɨŋɨnigɨnɨ, “Ubenɨ́ ewé námɨnɨ mamówáráná peyɨ́ bɨ mɨnɨnɨŋoɨ.” urɨ́agɨ o rɨ́ɨ́pɨ tɨ́nɨ xɨxenɨ yarɨ́ná re eŋɨnigɨnɨ. Peyɨ́ xwé obaxɨ́ ayá wí mɨnɨ́agɨ nánɨ mɨmɨxeapaxɨ́ wimónɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mɨmɨxeapaxɨ́ wimónɨ́agɨ wiepɨsiŋɨ́ Jisaso dɨŋɨ́ sɨxɨ́ uyiŋo Pitaomɨ re urɨŋɨnigɨnɨ, “E nearɨ́o negɨ́ Ámɨnáorɨnɨ.” urɨ́agɨ Saimonɨ Pitao arɨ́á e nɨwirɨ Jisasomɨ xámɨ owímeámɨnɨrɨ xegɨ́ rapɨrapɨ́ seáyɨ e yínarɨŋú —Ú nɨwirárɨmáná yarɨŋúrɨnɨ. Ú nɨmearɨ nɨyínɨmáná ipíyo nɨmawirɨ xeamoŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ipíyo nɨmawirɨ xeamóagɨ aí wiepɨsiŋɨ́ wɨ́a ipí imaŋɨ́pá tɨ́ŋɨ́ e aŋwɨ e sa 100 mita imónɨŋagɨ nánɨ ewépámɨ peyɨ́ ubenɨ́ magwɨ́ mɨnɨŋú ú tɨ́nɨ nɨmɨxeáa nɨbɨro ");
INSERT INTO aak_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","imaŋɨ́pámɨ niwiékɨ́nɨmearo wenɨŋɨ́ éɨ́áyɨ́ wɨnɨgɨ́awixɨnɨ. Rɨ́á nikeánɨmáná peyɨ́ bɨ rɨ́kwamɨŋɨ́yo werɨ bisɨ́kerɨ́á bɨ enɨ werɨ eŋagɨ wɨnarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisaso re urɨŋɨnigɨnɨ, “Peyɨ́ soyɨ́néyá ubenɨ́yo mɨnɨ́ɨ́pɨ bɨ nɨmeámɨ yapɨ́poyɨ.” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimonɨ Pitao ewéyo nɨpɨxemoánɨrɨ ubenɨ́ peyɨ́ magwɨ́ mɨnɨŋú imaŋɨ́pá tɨ́e nánɨ nɨmɨxeáa bɨŋɨnigɨnɨ. Peyɨ́ xwérɨxanɨ 153 mɨnɨŋagɨ aiwɨ ubenɨ́ ú wí marɨ́kínɨŋagɨ wɨnɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisaso re urɨŋɨnigɨnɨ, “Soyɨ́né aŋwɨ e nɨbɨro aiwá nɨ́poyɨ.” urɨ́agɨ xegɨ́ wiepɨsiŋowa omɨ rɨxa mí nɨwómɨxɨro “Negɨ́ Ámɨnáorɨnɨ.” nɨwiaiwiro nánɨ wo yarɨŋɨ́ “Goxɨrɨnɨ?” wipaxɨ́ mimónɨpa yarɨ́ná ");
INSERT INTO aak_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisaso rɨ́á wearɨŋe aŋwɨ e nurɨ bisɨ́kerɨ́á nɨmearɨ yaŋɨ́ nɨwia nurɨ peyɨ́ enɨ axɨ́pɨ e nɨwia uŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisaso xwárɨpáyo dánɨ nɨwiápɨ́nɨmeámáná wiepɨsiŋowamɨ xámɨ biaú sɨwá nɨwinɨmáná ámɨ sɨwá winɨŋɨ́ bɨ apɨrɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Rɨxa aiwá nɨnɨmɨ Jisaso nɨwiápɨ́nɨmearɨ Saimonɨ Pitaomɨ re urɨŋɨnigɨnɨ, “Jonomɨ xewaxo Saimonoxɨnɨ, joxɨ dɨŋɨ́ sɨxɨ́ nɨnɨyirɨ́ná dɨŋɨ́ sɨxɨ́ ámá rowa nɨyigɨ́ápimɨ wiárɨ́ nɨmúrorɨ rɨnɨyiŋɨnɨ?” urɨ́agɨ o re urɨŋɨnigɨnɨ, “Oyɨ, Ámɨnáoxɨnɨ, nionɨ dɨŋɨ́ sɨxɨ́ rɨsiŋápɨ nánɨ joxɨ nɨjɨ́árɨnɨ.” urɨ́agɨ o re urɨŋɨnigɨnɨ, “Sipɨsipɨ́ miá nɨmerɨ́ná aiwá wiarɨgɨ́ápa joxɨ ámá nionɨ tɨ́ámɨnɨ bɨ́áyo axɨ́pɨ nerɨ píránɨŋɨ́ uréwapɨyíɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisaso ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Jonomɨ xewaxo Saimonoxɨnɨ, joxɨ dɨŋɨ́ sɨxɨ́ rɨnɨyiŋɨnɨ? Mɨnɨyiŋɨ́ reŋɨnɨ?” urɨ́agɨ o “Oyɨ, Ámɨnáoxɨnɨ, nionɨ dɨŋɨ́ sɨxɨ́ rɨsiŋápɨ nánɨ joxɨ nɨjɨ́árɨnɨ.” urɨ́agɨ Jisaso “Ámá sipɨsipɨ́ awí mearoarɨgɨ́ápa joxɨ axɨ́pɨ nerɨ ámá nionɨ gɨ́ imónɨŋɨ́yo píránɨŋɨ́ uméɨrɨxɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisaso ámɨ bɨ nurɨrɨ re urɨŋɨnigɨnɨ, “Jonomɨ xewaxo Saimonoxɨnɨ, joxɨ dɨŋɨ́ sɨxɨ́ rɨnɨyiŋɨnɨ? Mɨnɨyiŋɨ́ reŋɨnɨ?” urɨ́agɨ Pitao Jisaso rɨxa biaú bɨ “Joxɨ dɨŋɨ́ sɨxɨ́ rɨnɨyiŋɨnɨ?” urɨ́ɨ́pɨ nánɨ dɨŋɨ́ sɨpí nɨwinɨrɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, amɨpí nɨ́nɨ nánɨ joxɨ nɨjɨ́oxɨrɨnɨ. Nionɨ dɨŋɨ́ sɨxɨ́ rɨyiŋápɨ nánɨ enɨ nɨjɨ́oxɨrɨnɨ.” urɨ́agɨ Jisaso re urɨŋɨnigɨnɨ, “Sipɨsipɨ́ aiwá wiarɨgɨ́ápa joxɨ enɨ ámá nionɨ nɨxɨ́darɨgɨ́áyo axɨ́pɨ nerɨ píránɨŋɨ́ uréwapɨyíɨrɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aga nepa rɨrarɨŋɨnɨ. Joxɨ sɨnɨ íwɨ́ sɨkɨŋɨ́ nerɨ́ná jɨwanɨŋoxɨ arerɨxɨ́ nɨyínɨrɨ dɨxɨ́ simónɨ́ɨ́mɨnɨ wagɨ́rɨnɨ. E nerɨ aí joxɨ rɨxa xweyaŋɨ́ nerɨ́ná dɨxɨ́ wé wúkaú wimɨxáná ámá wí gwɨ́ nɨrɨjiro joxɨ ‘Mupa oemɨnɨ.’ yaiwiarɨŋɨ́mɨnɨ nɨmeáa rupɨrɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Wiepɨsiŋowa re oyaiwípoyɨnɨrɨ, “Pitao penɨ́ápɨ nánɨ rɨ́a neararɨnɨ? O e nerɨ nɨperɨŋɨ́pimɨ dánɨ seáyɨ e Gorɨxo imónɨŋɨ́pɨ nánɨ sɨwá neainɨ́árɨ́anɨ? Oyɨ.” oyaiwípoyɨnɨrɨ e urɨŋɨnigɨnɨ. E nurɨmáná re urɨŋɨnigɨnɨ, “Joxɨ nɨxɨ́deɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitao nɨkɨnɨmónɨrɨ wiepɨsiŋɨ́ Jisaso dɨŋɨ́ sɨxɨ́ uyiŋo —O xámɨ nerɨmeánɨmáná aiwápɨ nɨnɨróná Jisaso tɨ́ámɨnɨ nɨkɨnɨmónaurɨ yarɨŋɨ́ re wiŋorɨnɨ, “Ámɨnáoxɨnɨ, mɨyɨ́ rurɨno gorɨnɨ?” urɨŋorɨnɨ. O awaúmɨ númɨ barɨŋagɨ nɨwɨnɨrɨ ");
INSERT INTO aak_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jisasomɨ re urɨŋɨnigɨnɨ, “Ámɨnáoxɨnɨ, ámá romɨ enɨ pí wipɨ́rɨ́árɨ́anɨ?” urɨ́agɨ ");
INSERT INTO aak_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisaso re urɨŋɨnigɨnɨ, “O nionɨ ámɨ aŋɨ́namɨ dánɨ weapɨmɨ́áíná nánɨ xe ŋweáwɨnɨgɨnɨrɨ nɨnimónɨrɨ́náyɨ́, ayɨ́ dɨŋɨ́ joxɨyá meŋagɨ nánɨ pí nánɨ nɨrarɨŋɨnɨ? Jɨwanɨŋoxɨnɨ sa nɨxɨ́deɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ayɨnánɨ ámá Gorɨxoyá imónɨgɨ́áyɨ́ rɨpɨ rɨnɨmegɨ́árɨnɨ, “Wiepɨsiŋɨ́ o wí nɨpenɨ́ámanɨ.” rɨnɨmegɨ́á aiwɨ Jisaso “Joxɨ nɨperɨ́ámanɨ.” wí murɨ́ rɨpɨnɨ urɨŋɨnigɨnɨ, “O nionɨ ámɨ weapɨmɨ́áíná nánɨ xe ŋweáwɨnɨgɨnɨrɨ nɨnimónɨrɨ́náyɨ́, ayɨ́ dɨŋɨ́ joxɨyá meŋagɨ nánɨ pí nánɨ nɨrarɨŋɨnɨ?” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","O Jisaso wiepɨsarɨŋɨ́ Pitaomɨ e urɨŋorɨnɨ. O amɨpí apɨ nánɨ áwaŋɨ́ nɨrɨrɨ rɨ́wamɨŋɨ́ eaŋorɨnɨ. Nene o nánɨ nɨjɨ́á re imónɨŋwɨnɨ, “O áwaŋɨ́ rɨŋɨ́pɨ nepánɨ rɨnɨnɨ.” nɨjɨ́á e imónɨŋwɨnɨ. ");
INSERT INTO aak_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Amɨpí Jisaso eŋɨ́ ámɨ obaxɨ́ ayá wí enɨ eŋagɨ aiwɨ nionɨ re nimónarɨnɨ, “O eŋɨ́pɨ nɨpɨnɨ nánɨ bɨkwɨ́yo rɨ́wamɨŋɨ́ píránɨŋɨ́ nearɨ́náyɨ́, xwɨ́á tɨ́yo bɨkwɨ́ apɨ déropaxɨ́rɨnɨ.” nimónarɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiopirasoxɨnɨ, rɨ́wamɨŋɨ́ nionɨ xámɨ nɨrɨrɨ eaŋápɨ, ayɨ́ Jisaso iwamɨ́ó erɨ wíwapɨyirɨ eŋɨ́pɨ tɨ́ŋɨ́ e dánɨ sɨ́á xegɨ́ wáɨ́ wurɨmeiarɨgɨ́áwamɨ —Awa xɨ́o rɨ́peaŋowarɨnɨ. Awamɨ Gorɨxoyá kwíyɨ́yo dánɨ sekaxɨ́ nurɨmáná xɨ́o aŋɨ́namɨ nánɨ peyiŋɨ́yi tɨ́ŋɨ́ e nánɨ nɨrɨrɨ eaŋárɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","O rɨ́nɨŋɨ́ nɨmearɨ nɨperɨ nɨwiápɨ́nɨmeámáná sɨ́á 40 nóra warɨ́ná awa “O ámɨ sɨŋɨ́ rɨ́a ŋweanɨ?” oyaiwípoyɨnɨrɨ ámɨ ámɨ sɨwá winayirɨ Gorɨxo ámá xɨ́oyáyɨ́ xwioxɨ́yo mɨmeámɨ́ nerɨ umeŋweanɨ́ápɨ nánɨ uréwapɨyirɨ nerɨ́ná awa sɨnɨ ududɨ́ mé “Ayɨ́ orɨ́anɨ?” nɨyaiwiro nɨwipɨmónɨmáná eŋáná re eŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Awamɨ awí neaárɨmáná sekaxɨ́ re urɨŋɨnigɨnɨ, “Ápo ‘Nɨseaiapɨmɨ́árɨnɨ.’ searɨŋɨ́pɨ —Apɨ, ayɨ́ nionɨ searáná soyɨ́né arɨ́á niarɨgɨ́ápɨrɨnɨ. Apɨ sɨnɨ mɨseaímeapa eŋáná aŋɨ́ Jerusaremɨ tɨ́yo dánɨ nɨwárɨmɨ mupa nero apɨ nánɨ wenɨŋɨ́ nero ŋweáɨ́rɨxɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ayɨ́ rɨpɨ nánɨrɨnɨ. Jono wayɨ́ nɨseameairɨ́ná iniɨgɨ́ tɨ́nɨ seameaiŋɨ́ aiwɨ sɨnɨ sɨ́á obaxɨ́ mórɨpa eŋáná Gorɨxo xɨ́oyá kwíyɨ́ tɨ́nɨ wayɨ́ seameainɨ́árɨnɨ.” urɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Awa rɨxa awí neánɨmáná omɨ yarɨŋɨ́ re wigɨ́awixɨnɨ, “Ámɨnáoxɨnɨ, eŋíná negɨ́ wa mɨxɨ́ ináyɨ́ nimónɨro negɨ́ neárɨ́awéyo umeŋweaagɨ́ápa ríná dánɨ joxɨ enɨ axɨ́pɨ mɨxɨ́ ináyɨ́ nimónɨrɨ Isɨrerene xwioxɨ́yo mɨmeámɨ́ nɨneairɨ neameŋwearɨ́áranɨ?” Yarɨŋɨ́ e wíagɨ́a ");
INSERT INTO aak_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","o re urɨŋɨnigɨnɨ, “Sɨ́á seyɨ́né yarɨŋɨ́ niarɨgɨ́ápɨ nánɨ parɨmonɨ́áyi —Ayi ápo Gorɨxo xɨ́o xegɨ́ nénɨ́ tɨ́ŋo nimónɨrɨŋɨ́pimɨ dánɨ nɨrɨrɨ tagɨ́yirɨnɨ. Ayi nánɨ seyɨ́né nɨjɨ́á imónɨpɨ́rɨ mimónɨŋagɨ nánɨ áwaŋɨ́ searɨmɨméɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","E nerɨ aiwɨ rɨpɨ nánɨ nɨjɨ́á imónɨpɨ́rɨ nánɨ áwaŋɨ́ searɨmɨ́ɨnɨ. Kwíyɨ́ oyápɨ nɨseaímearɨ eŋɨ́ sɨxɨ́ seaímɨxáná soyɨ́né nionɨ seaímeaŋá mɨ́koyɨ́né nimónɨro ámá Jerusaremɨ ŋweagɨ́áyo áwaŋɨ́ urɨmero ámá Judia pɨropenɨsɨ́yo tɨ́nɨ Samaria pɨropenɨsɨ́yo tɨ́nɨ amɨ amɨ ŋweagɨ́áyo urɨmero ámá xwɨ́á yoparɨ́ ɨkwɨ́rónɨŋɨ́mɨ ŋweagɨ́áyo aí urɨmero éɨ́rɨxɨnɨ.” ");
INSERT INTO aak_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","E nurárɨmáná awa sɨnɨ sɨŋwɨ́ wɨnarɨ́ná o Gorɨxoyá dɨŋɨ́ tɨ́nɨ nɨpeyirɨ wigɨ́ sɨŋwɨ́ anɨgɨ́e dánɨ agwɨ́ bimɨ aínɨŋɨnigɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nɨpeyirɨ agwɨ́ bimɨ aínáná awa sɨnɨ aŋɨ́namɨ sɨŋwɨ́ anánɨŋáná re eŋɨnigɨnɨ. Ámá rapɨrapɨ́ apɨ́á weŋɨ́ yínɨgɨ́íwaú awa tɨ́ŋɨ́ e nɨrónapɨri ");
INSERT INTO aak_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","re urɨgɨ́isixɨnɨ, “Gariri pɨropenɨsɨ́yo dáŋoyɨ́né, pí nánɨ re éɨ́ nɨrómáná aŋɨ́namɨ wenɨŋɨ́ yánɨŋoɨ? Ámá o, Jisasoyɨ rɨnɨŋo seyɨ́né tɨ́e dánɨ Gorɨxoyá dɨŋɨ́ tɨ́nɨ aŋɨ́namɨ nánɨ rɨxa nɨpeyirɨ aí soyɨ́né sɨŋwɨ́ wɨnarɨ́ná peyíɨ́pa ámɨ axɨ́pɨ wepɨ́nɨnɨ́árɨnɨ.” urɨgɨ́isixɨnɨ. ");
INSERT INTO aak_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Awa dɨ́wɨ́ Oripiyɨ rɨnɨŋɨ́pimɨ —Apɨ Jerusaremɨ dánɨ aŋwɨ e eŋɨ́pɨrɨnɨ. Sabarɨ́áyo Judayɨ́ ná jɨ́amɨ mupa nero aí Jerusaremɨ dánɨ dɨ́wɨ́ mɨŋɨ́ apɨ tɨ́ŋɨ́ e nánɨ ananɨ wagɨ́ápɨrɨnɨ. Apimɨ pɨ́nɨ nɨwiárɨmɨ nuro ");
INSERT INTO aak_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","rɨxa Jerusaremɨ nɨrémoro aŋɨ́ pákɨ́kɨ́ seáyɨ émɨ mɨrɨnɨŋiwámɨ —Iwá awa sá wearɨgɨ́iwárɨnɨ. Iwámɨ nánɨ waíwɨ́yo nɨpeyiro páwigɨ́awixɨnɨ. Awa wigɨ́ yoɨ́ rowarɨnɨ. Pitao tɨ́nɨ Jono tɨ́nɨ Jemiso tɨ́nɨ Adɨruo tɨ́nɨ Piripo tɨ́nɨ Tomaso 