﻿USE sofia;
DROP TABLE IF EXISTS sofia.aai_vpl;
CREATE TABLE aai_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aai_vpl WRITE;
INSERT INTO aai_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iti i Jesu ana’a’agir wabih, aiwob ana efane i David ana rara’ane tufuw naatu omatanenane i Abraham ana rara’ane tufuw. Naatu iti i hai gin anayimih. ");
INSERT INTO aai_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham natun i Isaac, naatu Isaac natun i Jacob, Jacob natun i Judah, Judah i taitin tuwahinah bairi hitufuw. ");
INSERT INTO aai_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Naatu Judah natunatun i Perez tain Zerah hairi hitufuw, hinah wabin Tamar. Naatu Perez natun i Hezron, Hezron natun i Ram, ");
INSERT INTO aai_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram natun i Aminadab, Aminadab natun i Nashon, Nashon natun i Salmon. ");
INSERT INTO aai_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Naatu Salmon natun i Boaz, hinah wabin Rahab, naatu Boaz natun i Obed, hinah wabin Ruth, naatu Obed natun i Jesse. ");
INSERT INTO aai_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse natun i David, aiwob orot. David natun i Solomon, naatu Solomon hinah i orot Uriah ana kwafur. ");
INSERT INTO aai_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon natun i Rehoboam, Rehoboam natun i Abaijah, Abaijah natun i Asa, ");
INSERT INTO aai_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natun i Jehosafat, Jehosafat natun i Jehoram, Jehoram natun i Uzaiah, ");
INSERT INTO aai_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaiah natun i Jotham, Jotham natun i Ahaz, Ahaz natun i Hezekiah. ");
INSERT INTO aai_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Naatu Hezekiah natun i Manasseh, Manasseh natun i Amon, Amon natun i Josiah, ");
INSERT INTO aai_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah natun i Jeconiah, Jeconiah taitin tuwahinah bairi hibitutufuw ana veya’amaim baiyow matar Babilon sabuw hina hibuwih hire hin Babilonamaim hima. ");
INSERT INTO aai_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonane himatabir maiye hinan ufunamaim Jeconiah natun i Shealtiel, naatu Shealtiel natun i Zerubbabel, ");
INSERT INTO aai_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel natun i Abiud, naatu Abiud natun i Eliakim, Eliakim natun i Azor, ");
INSERT INTO aai_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor natun i Zadok naatu Zadok natun i Akim, Akim natun i Eliud, ");
INSERT INTO aai_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud natun i Eleazar, Eleazar natun i Mathan, Mathan natun i Jacob, ");
INSERT INTO aai_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob natun i Joseph, Joseph aawan i Mary, naatu Mary natun i Jesu, it isan Keriso tarouw ta’o. ");
INSERT INTO aai_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imih Abraham ana veya’amaim busuruf re na David ana veya’amaim titit, agi’agir kwerekweren etei 14, naatu David ana veya’amaim re na hin Babilon hima’ama i 14, naatu Babilon hima’am imaim busuruf na Keriso ana veya’amaim titit i na’atube 14. ");
INSERT INTO aai_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu Keriso ana tufuw an i iti na’atube busuruf. Jesu hinah Mary i orot Joseph bai’awanin isan ana rum hi’o, baise hairi nanabin hima’am ana veya, Mary Anun Kakafiyin re targabuw yan wanawanan rara bobokafuf i so’ob. ");
INSERT INTO aai_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naatu Joseph i orot gewasin, imih men kok boro bebeyanamaim Mary tibiya’uhuw; imih wa’iwa’iramaim Mary kwahirin isan bogaigiwas. ");
INSERT INTO aai_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Baise ma binotanot tasinafumih, Regah ana tounamatar kakafiyin mimumaim tit eo, “Joseph, David ana agir, Mary bai na bai’awanin isan men inabirumih, anayabin iti i God Anunin Kakafiyinane yan matar. ");
INSERT INTO aai_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I boro kek orot nayai, o wabin Jesu iniwab, anayabin i boro ana sabuw hai bowabow kakafihine niyawasih.” ");
INSERT INTO aai_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sawar iti etei himamatar i abisa God ana dinab orot wanawananamaim eo Buk Atamaninamaim kikirum i na iturobe. ");
INSERT INTO aai_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","m “Babin biyan numin boro yan namatar, nataub kek orot nayai wabin Immanuel hiniwab” anayabin God it biyatamaim. ");
INSERT INTO aai_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph matan nuw mimisir ufunamaim, Regah ana tounamatar biyun na’atube Mary bai i’awan hairi hin ana bar. ");
INSERT INTO aai_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Baise Joseph i Mary hairi inu’e hima hin Mary taub kek orot yai, naatu Joseph kek bai wabin Jesu iwab eaf. ");
INSERT INTO aai_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea wanawanan Herod bi’aiwob ana veya’amaim, merar bar ta wabin Bethlehem imaim Jesu tufuw. Nati’imaim orot so’obayah afa daman baiyabayah veya yeninane hina Jerusalem hitit, ");
INSERT INTO aai_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","naatu sabuw hibatiyih, “Jew hai aiwob kek tutufuw i menamaim inu’in? Aki ana daman veya yeninane yey a’itin imih kwafirinamih ana.” ");
INSERT INTO aai_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aiwob orot Herod iti tur nonowar i ana not kasiy, naatu Jerusalem wanawanan sabuw etei’imak auman hai not kasiy. ");
INSERT INTO aai_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basit firis ukwarih naatu Ofafar Bai’obaiyenayah etei eaf hina ibatiyih, “Keriso i boro menamaim natufuw?” ");
INSERT INTO aai_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hiya’afut hio, “Judea wanawanan bar merar ta wabin Bethlehemamaim. Anayabin dinab orot iti na’atube Buk Atamaninamaim hikirum, ");
INSERT INTO aai_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judah tafaram wanawanan, bar merar etei hai aiwob wanawanahimaim, O Bethlehem wab boro nara’at, anayabin one boro nabatanenayan orot natufuw, ayu au sabuw Israel nabonawiyih.’” ");
INSERT INTO aai_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Imaibo Herod veya yenin nanawan hina hima’am eaf hirun wa’iwa’iramaim ibatiyih, kok taso’ob veya abistanamaim daman yey hi’itin. ");
INSERT INTO aai_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naatu au Bethlehem biyafarih i’uwih eo, “Kwanan kek kwananuwih gewas kwana’itin naatu kwanamatabir au tur kwana’owen, saise ayu’ubo anan anakwafir.” ");
INSERT INTO aai_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aiwob orot iti na’atube eo hinonowar ufunamaim hitit hin, naatu daman ta’imon veya yeninane hi’itin hinan au nah i’iyon na kek inu’in tafanamaim nutanub bat. ");
INSERT INTO aai_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nati daman hi’i’itin ana veya hiyasisir naatu hikawasa men kafaita. ");
INSERT INTO aai_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bar wanawanan hirun kek hinah Mary hairi hi’itih, suh hiyowen kek hikwafir. Imaibo hai kaukufet hirufamen hai siwar gold, frankincense, naatu myrrh hibotaiten kek hisiwar. ");
INSERT INTO aai_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Naatu matabir maiye Herod biyan titamih hio’o, baise fai hai mimumaim God imatnuwih, naatu ef ta hibai hin hai tafaram hitit. ");
INSERT INTO aai_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nanawan orot hinan ufunamaim, Regah ana tounamatar Joseph ana mimumaim tit iu, “Kumisir kek hinah hairi kubuwih kwabihir kwan Egypt imaim kwanama’am boro ana’obo kwanatit, anayabin Herod i kek asabuninamih ana ef enunuwet.” ");
INSERT INTO aai_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Basit Joseph misir kek hinah hairi buwih gugumin wanawanan hibihir hin Egypt hitit, ");
INSERT INTO aai_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nati’imaim hima’am Herod morob. Imih sawar iti himamatar i abisa Regah ana dinab orot iwan Buk Atamaninamaim kikirum i na i turobe, “Egyptane ayu Natu abotait tit.” ");
INSERT INTO aai_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod veya yenin nanawan hai baifuwen titita’ur ana veya, yan so’ar gagamat bufut naatu orotokek nati Bethlehem wanawanan naatu bar merar nati sisibinamaim iyabowat hai kwamur rou’ab au babe re’er etei asabunuw isan ana baiyowayah iyunih hitit. Iti na’atube eo biyunih anayabin i veya abisa’amaim nanawan daman hi’itin hio nonowar imaim sinaf. ");
INSERT INTO aai_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naatu abisa dinab orot Jeremiah eo kikirum i na yabin matar. ");
INSERT INTO aai_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah bar meraramaim yuwen atubob gagamin maiyow re’er hinowar, tibikirir naatu tererey, Rachel natunatun isah erererey men ekokok hini’awafut, anayabin ana kek etei himorob sawar.” ");
INSERT INTO aai_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod momorob ufunamaim, Joseph Egypt ma’ama Regah ana tounamatar Joseph ana mimumaim tit iu, ");
INSERT INTO aai_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kumisir kek hinah hairi kubuwih kwamatabir maiye kwan au Israel, anayabin sabuw iyab kek asabuninamih hi’o i himoroboka.” ");
INSERT INTO aai_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Basit Joseph matan nuw misir, Jesu hinah hairi buwih himatabir maiye hina Israel hitit. ");
INSERT INTO aai_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Baise Arselaus tamah Herod ana efan bai, Judea wanawanan ma bi’aiwob Joseph ana tur nowar, naatu imaim na ma’amih bir. Mimumaim auman God imatanuw, imih i au Galilee na’at na, ");
INSERT INTO aai_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bar merar ta wabin Nazareth imaim bar wowab ma, saise abisa dinab oro’orot Buk Atamaninamaim hi’o hikikirum i na yabin matar, “Jesu isan boro hinao i Nazareth matuwan”. ");
INSERT INTO aai_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kwamur bai’ab na’atube sawar ufunamaim, John Baptist Judea arar yan tit busuruf binan ");
INSERT INTO aai_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","eo, “Bowabow kakafih kwasisinaf etei kwanihamiyen, anayabin mar ana aiwob i na iyubin.” ");
INSERT INTO aai_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dinab orot Isaiah, Buk Atamaninamaim John isan kikirum iti na’atube eo, “Orot ta arar yan tit bat eafa’af, Regah ana ef kwayabuna, naatu ana ef kwaimutufur.” ");
INSERT INTO aai_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John ana faifuw i camel bunibuninamaim sakir iyoun, ana kikir i bobaituw ta kanabinamaim naiwan kik, ana bay i sisik naatu kaiyar tafu. ");
INSERT INTO aai_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem wanawanan, Judea wanawanan bar merar etei naatu sabuw nati Jordan harew sisibin hima’am etei ikwei hina. ");
INSERT INTO aai_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hai bowabow kakafih hi’e’en, Jordan harewamaim John bapataito itih. ");
INSERT INTO aai_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Baise i wanawanahimaim Pharisee naatu Sadducee maumurih na’in bapataito bainamih hinan itih eo, “Kwa i kokobe aso’ob hira’at! Yait eo kwanowar God ana baimakiy nabiyafar boro wan kwanabibir? ");
INSERT INTO aai_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Turobe kakafihine dogor baikitabir kwanabaib i boro a yawas gewasinamaim ni’obaiyi, kwa i anababatun dogor baikitabir matar. ");
INSERT INTO aai_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Men kwananot kwanao, ‘Abraham i aki ai agir,’ baise a tur ao’owen, God karam kabay iti boro nabow nasinaf Abraham wawawan hinamatar. ");
INSERT INTO aai_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","God ana kariwak i wan iur, ai an wairoronika tarinamih yai inu’in, ai menatan ebiw ro’on men gewasin boro natar nare wairaf wan nayara’ah na’arah. ");
INSERT INTO aai_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ayu i dogor baikitabiren ana bapataito harewamaim abit. Baise orot ayu ufu’umaim enan ana fair i ra’at ayu natabiru, an ana sumasum ayu men karam boro ana’abar. I boro Anun Kakafiyin naatu wairafamaim bapataito nit. ");
INSERT INTO aai_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I umanamaim i raububuna’en ana fok ema’am, imaim boro rice narab narububunai ani’anin korom nayai, naatu hain wairaf aidahin in etoto’ab wan nayara’ah na’arah.” ");
INSERT INTO aai_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nati ana veya’amaim, Jesu Galilee ine tit na Jordan tit, John bapataito baitinin isan. ");
INSERT INTO aai_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Baise John rutawiy eo, “O i karam boro ayu bapataito ititu, baise aisim ayu isou kunan?” ");
INSERT INTO aai_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu iya’afut eo, “Boun abisa au’uwi i kusinaf, anayabin ef iti’imaim God ana kok gewasin isan yayakitifuw boro tanasinaf yabih hinamatar.” Naatu John ibasit Jesu bapataito itin. ");
INSERT INTO aai_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesu bapataito baib ufunamaim matabir yen tafan bat. Nati ana maramaim mar botawiy God Anunin Kakafiyin itin mamu imak na’atube rob re na Jesu tar gabuw, naatu tafanamaim marakaw. ");
INSERT INTO aai_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mar wanawanan Orot fanan hinowar eo, “Iti kek i ayu Natu ta’imon, au yabow, I isan ayu abiyasisir.” ");
INSERT INTO aai_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Imaibo Anun Kakafiyin Jesu nawiy hin arar yan imaim Demon kakafin routubunin isan. ");
INSERT INTO aai_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Auyit 40 gugumin 40 na’atube bay en ma yoyoyoban ufunamaim bayumih morob. ");
INSERT INTO aai_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Basit Demon Mowan na Jesu biyan tit eo, “O God Natun na’at, kabay iti ku’uwih tebotabiren rafiy tematar ku’aa.” ");
INSERT INTO aai_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Baise Jesu iya’afut eo, “Buk Atamaninamaim hikikirum i iti na’atube eo, ‘Orot boro men bay akisin niyawasimih, baise God awanamaim tur abisa etitit boro i niyawasih.’” ");
INSERT INTO aai_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naatu Demon Mowan Jesu nawiy hin Jerusalem hitit, Tafaror Bar afe’en hiyen tafantoro’ot bat. ");
INSERT INTO aai_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jesu iu, “O God Natun na’at, kukununuw kure. Anayabin Buk Atamaninamaim hikikirum iti na’atube eo, ‘God ana tounamatar boro o isa niyafarih, umah yanamaim inare hinabuwi, naatu kabay boro men a natakakirimih.’” ");
INSERT INTO aai_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu iya’afut eo, “Baise Buk Atamaninamaim iban eo maiye, ‘Regah a God men routobonamaim inanawiyimih.’” ");
INSERT INTO aai_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Naatu Demon Mowan iban Jesu nawiy maiye hiyen hin oyaw manin tafantoro’ot bat, tafaram tutufin ana gewasin etei ana aiwob auman i’obaiy ");
INSERT INTO aai_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","eo, “Su inayowen ayu inakwafiru, sawar iti etei boro o anit”. ");
INSERT INTO aai_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesu iya’afut iu eo, “Demon Mowan na kutabaratait! Anayabin Buk Atamaninamaim hikikirum iti na’atube eo, ‘Regah a God akisinamo inakwafir isan inabow.’” ");
INSERT INTO aai_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Imaibo Demon Mowan nati’imaim Jesu ihamiy tabaratait, naatu God ana tounamatar hina Jesu hitafafar hinawiy bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","John dibur bar ma’am Jesu ana tur nowar, basit matabir na Galilee tit, ");
INSERT INTO aai_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","naatu Nazareth ihamiy na Capernaum imaim ma, harew kukuf sisibin Naphtali, Zeburun wawawan hai me’emaim, ");
INSERT INTO aai_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","saise tur abisa dinab orot Isaiah wanawananamaim titit i na iturobe. ");
INSERT INTO aai_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zeburun ana me, Naphtali ana me, ef yan in tor re’ere, Jordan harew rounane, Galilee wanawanan Eteni Sabuw hai me’emaim, ");
INSERT INTO aai_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","sabuw gugumin ma’ayah boro marakaw hina’itin; naatu sabuw iyab morob kakafin ana me’emaim gugumin wanawanan tema’am marakaw boro isah nakusisiar narun.” ");
INSERT INTO aai_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nati ana veya’amaim Jesu busuruf binan eo, “Bowabow kakafih kwasisinaf etei kwanihamiyen, anayabin mar ana aiwob ina iyubin”. ");
INSERT INTO aai_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu Galilee tor rewarewan remor inan orot ainuf hairi itih, Simon wabin ta Peter, tain Andrew hairi tor yan siy bowamih buwat hiya’ay. ");
INSERT INTO aai_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu eaf eo, “Kwana kwai’ufnunu bairit tan boro ani’obaiyi orot isah kwanaway”. ");
INSERT INTO aai_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mar ta’imonamo hai buwat hitumar Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hin kafa’imo, orot rou’ababo ainuf hairi itih, James tain John hairi, Zebedee natunatun. Tamah bairi wa tafan hima hai buwat hitatar futifut, Jesu bai’ufnunin isan ea’afih ana veya, ");
INSERT INTO aai_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","mar ta’imonamo wa hihamiy naatu tamah auman wa tafan hihamiy ma, i hairi Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilee wanawanan Jesu runtit Jew hai Kou’ay Bar gidigidihimaim mar ana aiwob isan tur gewasin binan, naatu sabuw yarug yumatah ta ta, sawow yumatah ta ta hibow hima’am etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesu ana tur ra’at in Syria tafaram wanawanan etei hinowar, basit sabuw sawusawuwih, ah umah kafikafirih, rara ani’anih, kokom ani’anih, koko’aw, mayamayay naatu sabuw afa hai sawow yumatah ta ta etei hiteten hina Jesu iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sabuw rou’ay gagamin maiyow Galilee’ine naatu Bar Merar Etei Umat Rororon wanawanahimaim naatu Jerusalem, Judea naatu Jordan wanawanan auman sabuw etei Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesu sabuw rou’ay gagamin maiyow hinan itih, basit heher yen in koun yan mare ana bai’ufununayah hina sisibinamaim himarir. ");
INSERT INTO aai_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Naatu busuruf i’obaibiyih eo, ");
INSERT INTO aai_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sabuw iyab ayubih ana’amorob tebaib boro baigegewasin hinab, anayabin mar ana aiwob boro ninowah hinab. ");
INSERT INTO aai_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sabuw iyab hiyababan tererey God boro ni’afutih baigegewasin nitih. ");
INSERT INTO aai_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sabuw iyab taiyuwih teyayara’iyih boro baigegewasin hinab, anayabin me tafaram boro ninowah hinab. ");
INSERT INTO aai_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sabuw iyab gewasin sinaf isan hi’amorob sikah emamamah boro baigegewasin hinab, anayabin God boro nitih hinab nasusuwih. ");
INSERT INTO aai_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sabuw iyab tekakabeber boro baigegewasin hinab, anayabin God boro nakabibirih. ");
INSERT INTO aai_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sabuw iyab dogoroh uhew boro baigegewasin hinab, anayabin God boro hina’itin. ");
INSERT INTO aai_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sabuw iyab tufuw ma gewas isan tebowabow boro baigegewasin hinab, anayabin God boro natunatumih nabuwih. ");
INSERT INTO aai_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sabuw iyab gewasin tisisinaf isan hirouw tibi’a’akirih boro baigegewasin hinab, anayabin mar ana aiwob boro hinab. ");
INSERT INTO aai_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kwabi’ufununu isan sabuw boro tur kakafin hina’uwi, hinarabi hini’a’a’akiri naatu baifuwenamaim tur kakafih maiyow hina’u’uwi isan, baigegewasin boro kwanab. ");
INSERT INTO aai_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kwaniyasisir naatu kwanakawasa, anayabin a siwar gagamin na’in auyom maramaim inu’in boro kwanab. Ef ta’imon nati na’atube marasika dinab oro’orot hirouw hi’a’a’akirih. ");
INSERT INTO aai_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kwa i riy na’atube sabuw etei isah. Baise riy naniyan nabi’en na’at boro men karam hiniwa’an naniyan namatar maiye’emih, naatu sawar isan ana gewasin boro men ta nama, imih boro hinisaroun haw nare, sabuw tafan hinawas kamakamar hinaremor. ");
INSERT INTO aai_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kwa i tafaram ana marakaw. Bar merar gagamin oyaw wan hiwowab ebatabat boro men karam hinibun wa’irimih. ");
INSERT INTO aai_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na’atube orot babin men ta ramef ito’ab noukwat wanawanan tarafut inumih. Baise ana sisikofamaim boro nasikof bar wanawanan etei namarakaw kawin hinama. ");
INSERT INTO aai_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ef ta’imon nati na’atube a marakaw sabuw etei matahimaim kwanabotawiy, saise abisa gewasin kwabowabow hina’itin naatu Tamat maramaim wabin hinabora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayu anan men kwananot Moses ana ofafar naatu dinab oro’orot hai bai’obaiyen baihamiyen isan ao’omih. Ayu men i kouseiren isan anamih, baise sinaf yabih matar isan. ");
INSERT INTO aai_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Anababatun a tur a’owen, mar tafaram ema’am wanawananamaim kirum kikimin maiyow hikikirum, naatu pen wanamaim abisa hikukuyowan boro men ta anakusairimih, baise etei boro anasinaf yabih hinamatar. ");
INSERT INTO aai_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Orot yait ofafar kikimin maiyow itin yabin en rouw eastu’ub naatu sabuw afa i’obaiyih nati na’atube tisisinaf, mar ana aiwobomaim ibo boro hina’itfuruw, anayabin en hinarouw hinao, baise orot yait iti ofafar ia’ait naatu sabuw afa ebi’obaiyih mar ana aiwobomaim i boro orot gagamin. ");
INSERT INTO aai_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A tur ao’owen o yait abosunusunub nara’at Pharisee naatu Ofafar Bai’obaiyenayah inananatabirih na’at, o i nuhinafot mar ana aiwobomaim i kurur. ");
INSERT INTO aai_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tur marasika hio uwatanah hinonowar i hio kwanowar, men sabuw kwana’asbunuw, naatu orot yait sabuw ea’asbunuwih boro ofafar nafatum hinibatiy. ");
INSERT INTO aai_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Baise boun i a tur ao’owen, orot yait taintuwan isan yan nasoso’ar boro ofafar nafatum hinibatiy, naatu orot yait taintuwan isan fudirin en narouw nao’o, i boro kaniser hinibatiy. Baise orot yait taintuwan na’oraraf anayabin en nao, nati orot i enan kakafin ana wairaf wan nayenamih. ");
INSERT INTO aai_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Isan imih gem kakafiyin tafamaim o a siwar ya’inamih ibai kuyey, naatu nati’imaim o nuhi nataseb, tai ta o isa i yan esoso’ar. ");
INSERT INTO aai_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Basit a siwar nati gem tafanamaim inihamiy na’in, o inamatabir maiye inan tai airi kwanao gewas uma kwanabow kwanitonuw, imaibo inamatabir inan a siwar God initin. ");
INSERT INTO aai_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ofafar ta ina’astu’ub taituwa baibatiyihimih nabuwi kwanan, airi kwanao gewas kwanitonuw, veya kikimin nama’am na’at, imaibo inan baibatiyenamaim inarun, anayabin nati’imaim tura boro nabuwi baibatiyenayan orot gagamin umanamaim naya’i, naatu baibatiyenayan orot boro nabuwi furisiman nitih hinabuwi kwanan dibur bar hinayaruyi. ");
INSERT INTO aai_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anababatun a tur ao’owen, nati’imaim o boro inama kabay hio na’atube inatubuni, imaibo boro hinabotait inatit. ");
INSERT INTO aai_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tur hio uwatanah hibi’obaibiy i hio kwanowar, turanah a’aawah ufuh men kwanan. ");
INSERT INTO aai_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naatu boun a tur ao’owen orot yait matanawat nuw babin itin ana notamaim hairi baiwa’anamih enotanot ana notamaim hairi hiwa’anaka. ");
INSERT INTO aai_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Imih o mata asukwafune nuw kwaneyan, o in bowabow kakafin kusisinaf, kukubai kwisaroun, men basit mata ta’imon ana kakafinamaim o biya etei tan wairaf wan tayen ta’arah. ");
INSERT INTO aai_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na’atube uma asukwafune eof kwaneyan, ku’afuw kwisaroun men basit uma ta’imon ana of kwanekwanemaim o biya etei tan wairaf wan tayen ta’arah. ");
INSERT INTO aai_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Moses ana ofafaramaim eo, ‘Orot yait aawan nakwakwahir gewasin kwahikwahiren ana fef nakirum babin nitin nab auman nan.’ ");
INSERT INTO aai_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Baise boun i a tur ao’owen, orot yait nibobowen aawan nakwahir nan orot ta ni’awan, hairi hinabiwa’an i men babin ana ubar, baise orot ana ubar anayabin i kok imih babin esisinaf, naatu orot yait nati babin bai bi’awan auman bowabow kakafin esisinaf. ");
INSERT INTO aai_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tur marasika hio uwatanah hinonowar i hio kwanowar, ‘A omatanen men kwana’astu’ub, baise sinafumih God kwao’omatan i kwanasinaf.’ ");
INSERT INTO aai_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Baise boun i a tur ao’owen, God wabinamaim men asir kwanao kwanifaro’omih, na’atube auyom mar isan, anayabin nati i God ana ma’ama efan. ");
INSERT INTO aai_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Me yan auman men isan kwanifaro, anayabin nati i God an ana baibiyarir efan, Jerusalem auman, anayabin nati i ata aiwob gagamin God ana tafaram. ");
INSERT INTO aai_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naatu o taiyuw auman men arib isan inao baifaro’omih, anayabin o men karam boro arib ta inab inau nikwes o nafurum. ");
INSERT INTO aai_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imih inakwahir o inarufut, anayabin abisa awamaim iya’abar i’o etitit i Demon Kakafin biyanane enan. ");
INSERT INTO aai_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Marasika ana tur hio kwanowar, ‘Orot yait mata nakubai, ibo matan kukubai, naatu orot yait wa nimarir, ibo wan kwimarir.’ ");
INSERT INTO aai_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Baise boun i a tur ao’owen, orot yait isa nasisinaf kakaf men wan inay, rebareb rounane nifafar inatatabir rounane’ebo nifafar. ");
INSERT INTO aai_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Naatu orot yait niyaso’ar baibatiyimih nabuwi kwananan, a biya baibiyon baban nikiya’ub nabaib, a biya baibiyon tafan auman inikiya’ub initin. ");
INSERT INTO aai_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Baiyowayan orot ta nan nakwarari ana hafoy abarin veya ta’imon airi namih nao, ina’abar veya rou’ab airi kwanan. ");
INSERT INTO aai_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Orot babin ta isa sawaramih nafefeyani kwitin, naatu orot babin ta a sawar bai na mar kafai imaim bowamih nao, kwitin ebai en. ");
INSERT INTO aai_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Marasika ana tur hio a’a’agir hinonowar i hio kwanowar, ‘Taituwa kwaniyabuwih naatu a kamabiy sabuw kwanimat gigigirih.’ ");
INSERT INTO aai_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Baise boun a tur ao’owen, a kamabiy sabuw kwaniyabuwih naatu sabuw iyab terurukoukuwi isah kwanayoyoban. ");
INSERT INTO aai_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Saise kwa boro Tamat auyom maramaim natunatumih nabuwi, anayabin God sinaf sabuw gewasih kakafih etei tafahimaim veya erararan, sabuw iyab gewasin tisisinaf naatu kakafin tisisinaf etei God taun ebitih. ");
INSERT INTO aai_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sabuw kabay o’onayah tisisinaf na’atube kwanasinaf sabuw iyabowat isa tibiyabowawat isah kwanabiyabow, God boro men ana siwar gewasin ta nitimih. ");
INSERT INTO aai_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Naatu Eteni Sabuw taih tuwah akisih hai merar tiyiy na’atube kwanasinaf taituwa akisih hai merar kwanayiyi, ana gewasin boro men kwanabaimih. ");
INSERT INTO aai_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","A yawas uhew bitan kwanama, Tamat auyom maramaim ana yawas uhew bitan ema’am na’atube. ");
INSERT INTO aai_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Yate nanub, men iti baifa’i isan a bowabow gewasih sabuw nahimaim kwanabowamih, nati na’atube kwanasisinaf na’at, Tamat maramaim boro men a baiyan nitimih. ");
INSERT INTO aai_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Imih veya ta akir wairafin sawar inabitin men inakurereb sabuw etei hinanowaramih, men sabuw wanawanah rerekabih Kou’ay Bar wanawanan, naatu ef gagamih yahimaim sabuw itih baifa’ih isan tisisinafube kwanasinafumih, anababatun a tur ao’owen, nati sabuw i boro men hai siwar ta God nitihimih. ");
INSERT INTO aai_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Isan imih akir wairafin inabibais, wa’iwa’iramaim inibais, saise a’of iti sisib ema’am men naso’ob o abisa kusisinaf. ");
INSERT INTO aai_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iti sawar i wa’iwa’iramaim inasinaf, saise Tamat maramaim o abisa wa’iwa’iramaim isisinaf na’iti boro a baiyan nit. ");
INSERT INTO aai_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Naatu yoyobanamih men wanawanah rerekabih tisisinafube, kwanasinafumih, anayabin i tekokok Kou’ay Bar wanawanan hinabat hinayoyoban, o ef na’ih awah kaukusebamaim hinabat hinayoyoban, saise sabuw hina’itih, baise anababatun a tur ao’owen, nati sabuw hai baiyan i hibaika. ");
INSERT INTO aai_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Baise o yoyobanamih a bar inarun, etawan inahir, Tamat wa’iwa’iramaim ema’am isan inayoyoban, naatu Tamat abisa wa’iwa’iramaim isinaf i’itin boro a baiyan nit. ");
INSERT INTO aai_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Naatu yoyobanamih men a tur nidun namomonamih, Eteni Sabuw iyab God men hisusu’ub i na’atube tisisinaf. Tenotanot yoyoban manin hinayoyoban God boro hai yoyoban nanowar. ");
INSERT INTO aai_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Men i hai sinaf kwani’u’ur, anayabin abisa inotanot Tamat i so’obabo o kubifefeyan. ");
INSERT INTO aai_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Imih iti na’atube kwanayoyoban, ‘Tamai maramaim, O wab i kakafiyin. ");
INSERT INTO aai_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A aiwob tan, tafaramamaim a kok atasinaf, maramaim tisisinaf na’atube, ");
INSERT INTO aai_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyai ana fair isan mar etei ai bay initi. ");
INSERT INTO aai_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ai kakafih kunotawiyen, taituwai hai kakafin anonotawiyen na’atube. ");
INSERT INTO aai_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Men routobonamaim inanawiyi’imih, baise kakafihine inatar fafari, a aiwob, a fair, a marakaw nama wanatowan, Amen.’ ");
INSERT INTO aai_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Taituwa o isa bowabow kakafin hisisinaf inanotawiyen, Tamat maramaim o a kakafih auman boro nanotawiyen. ");
INSERT INTO aai_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Baise hai kakafih men inanotanotwiyen na’at, o a kakafin auman Tamat boro men nanotawiyen. ");
INSERT INTO aai_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kwanayoyohar ana veya men sabuw wanawanah rerekabih kwani’u’urih, anayabin nati na’atube teyoyohar, saise taituwah hina’itih yoharayah hinarouw hinifa’ih isan. Anababatun a tur ao’owen nati sabuw hai baiyan i hibaika. ");
INSERT INTO aai_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Baise kwanayoyohar ana veya yumat kwanasouwen arib raiy kwanay kwanisuwar, ");
INSERT INTO aai_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","saise sabuw afa boro men hina so’ob kwa i kwayoyohar, baise Tamat wa’iwa’iramaim ema’ama, o abisa akisimo isinaf i’itin boro a baiyan nit. ");
INSERT INTO aai_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“A sawar gewasih iti tafaramamaim inaya inatototo, ganidor boro na’aan fufur naatu simur boro na’arah, naatu bainowah auman boro a bar hinakwib hinarun a sawar hinabain. ");
INSERT INTO aai_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Imih a sawar etei maramaim inaya inatoto, saise ganidor boro men hina’aan, naatu simur boro men na’arah, naatu bainowah boro men a bar hinakwib hinarun hina bainuwihimih. ");
INSERT INTO aai_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A toto abuyoy menamaim kuya’aya, o dogor boro imaim mar etei nama. ");
INSERT INTO aai_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matat i biyat ana hinow, matat gewasin, biyat etei boro marakawin. ");
INSERT INTO aai_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Baise matat kakafin, biyat tutufin etei boro gugumin kakafin, naatu nati gugumin i wanu’umin kakafin. ");
INSERT INTO aai_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Orot ta’imon men karam boro orot gagamih rou’ab isah nabow, ana gewasin orot ta i boro nakwahir, naatu orot ta isan niyabow, orot ta ana tur i boro nanowar naatu orot ta boro nifutuw. ");
INSERT INTO aai_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Isan imih a tur ao’owen, ayawas isan men kwaniyababan, a tom isan, biya isan, naatu ar faifuw isan. Kwanotanot yawas i sawar gagamin ar faifuw naatu a tom hairi natabirih? ");
INSERT INTO aai_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kwanuw mamu kwa’itah, men masaw tebob naatu men masaw tefafour, na’atube aurih bay ana korom en baise Tamat maramaim kaifih bay ebitih. Imih kwa i men mamu ekakaifih na’atube ekakaifimih. ");
INSERT INTO aai_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Imih yababan men karam boro a yawas nakumanin kwanama’amih ");
INSERT INTO aai_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Naatu aisim ar faifuw isah kwabiyababan? Sigar beran kwanuw kwa’itih, men kafai hibow raro’oh ebababan, o biyah isan ar faifuw tesasakiramih. ");
INSERT INTO aai_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Baise a tur ao’owen, aiwob orot Solomon toto buyoy wairafin, ana faifuw eo’osen i men ta iti beran ana gewasinabe’emih. ");
INSERT INTO aai_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God kaiyar fotan ebi’osen wainih kwana’itin, fotan iti boun natasasar, maras boro nakimow nare wairaf wan hinayara’aten hina’arah. Baise kwa i Tamat God uman yanamaim ekakaifi, aisim men kwabitumitum? ");
INSERT INTO aai_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Imih men kwaniyababan kwanao, au ar au faifuw boro menamaim anabow ana’osen, naatu bay boro menamaim anabow ana, harew menamaim anahun anatom? ");
INSERT INTO aai_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eteni Sabuw i sawar iti isah tibiyababan, naatu Tamat maramaim kwa a yababan etei i so’ob. ");
INSERT INTO aai_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Baise wan i mar ana aiwob naatu ma gewasin kwananuwih kwanab, naatu sawar iti etei boro tafan naya’abar nit kwanabow. ");
INSERT INTO aai_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Isan imih maras isan men kwaniyababan, anayabin maras ibo akisin ana yababan. Na’atube veya ta’ita’imon hai yababan men inabo’ay inanot a yababan nara’atamih. ");
INSERT INTO aai_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Taituwa hai kakafin men ina’itin inibibatiyih, God boro nibatiyi. ");
INSERT INTO aai_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anayabin God boro ef ta’imon taituwa ibibatiyih na’atube, o boro nibatiy, naatu fufun ta’imon taituwa ifufufunihimaim, o boro nafufuni. ");
INSERT INTO aai_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Aisim taituwa matah mutusukwar i’itin kikin ku’o naatu o mata ahay gagamin yi ebatabat men kui’itin. ");
INSERT INTO aai_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","O taituwa isan boro mi’itube awa fariniwa’an inao, ‘Aro nekuna mata mutusukwar abosair.’ Naatu baise o mar etei i matan ahay yi ebatabat. ");
INSERT INTO aai_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wanawan rerekabih, mat o taiyuw mata a’ahay ina’uy, saise boro inanuw gewas taituwa matan ana ahay ina’uy. ");
INSERT INTO aai_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Abisa kakafiyin men haru aninamih kwanitih, boro hinatatabir hinayubi. Naatu a nugunug men for nahimaim kwanarub nare, boro tafan hinayen hinawasu’uru’um. ");
INSERT INTO aai_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Inafefeyan boro inab, inanuwet boro inatita’ur, naatu inarukikitar etawan boro isa nabotawiy. ");
INSERT INTO aai_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anayabin orot yait efefeyan boro nab, orot yait enunuwet boro natita’ur naatu orot yait erurukikitar etawan boro isan nabotawiy. ");
INSERT INTO aai_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“O yait natu, wahimih fefeyan kabay ibai itin ean? ");
INSERT INTO aai_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na’atube siyamih rererey kok ibai itin ean? ");
INSERT INTO aai_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","En baise Kwa i bowabow kakafih sinafuyah, baise kwaso’ob natunat boro siwar gewasih kwanitih, imih Tamat maramaim i ma tainin erubirub orot yait efefeyan boro siwar gewasin nitin. ");
INSERT INTO aai_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Imih sawar etei taituwa isah inabow, o kukok isa tebowabow na’atube, anayabin Moses ana ofafar naatu dinab oro’orot hai bai’obaiyen an anababatun i iti’imaim ku’ay inu’in. ");
INSERT INTO aai_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Etawan awan kukurinamaim kwanarun kwan, anayabin etawan awan gagamin, naatu ef awan hahabin inarun inanan yomaninamaim i gurugurusen ema’am naatu sabuw moumurih na’in imaim tenan. ");
INSERT INTO aai_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Baise etawan awan kukurin naatu ef awan tuwafutin inarun inanan yomaninamaim i yawas ema’am, naatu sabuw matan ta’amo imaim tenan. ");
INSERT INTO aai_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mata to niwa’an dinab baifufuwenayah hinanan kwana’itih, anayabin hinanan ufuhine ana itinin boro sheep na’atube, baise dogoroh wanawanan ana itinin i haru tuwetuwenih. ");
INSERT INTO aai_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hai bowabowamaim boro kwana’inanih, agor ro’on boro men kiw tafanamaim inima’ub, naatu wanob ro’on boro men kiw tafanamaim inima’ub? ");
INSERT INTO aai_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ai gewasin boro niw gewas, baise ai wanawanan kour nabiw ro’on boro nukunukuwin. ");
INSERT INTO aai_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ai gewasin boro men ro’on nukunukuwin nayai, na’atube ai kakafin boro men ro’on gewasin nayai. ");
INSERT INTO aai_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ai menatan men ebiw gewas boro natar nare nab nan wairaf wan nayara’ah na’arah. ");
INSERT INTO aai_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Imih dinab baifufuwenayah boro hai bowabowamaim kwana’inanih. ");
INSERT INTO aai_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Men sabuw etei ayu wabu hisu’ub teo, ‘Regah, Regah’ boro mar ana aiwobomaim hinarun, baise sabuw iyabowat ayu Tamai ana kok tisisinafuwat boro hinarun. ");
INSERT INTO aai_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Baibatebat ana veya nanan, sabuw moumurih na’in boro hinao, Regah, Regah, o wabimaim aki tur abai aorereb, o wabimaim aki demon kakafih anunih hibihir, naatu o wabimaim aki ina’inan moumurih na’in asinaf. ");
INSERT INTO aai_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Imaibo ayu boro anauwih anao, Ayu men aso’ob kwa iyab. Biyau’umaim kwatit sa’ab kwan, bowabow kakafih sinafuyah. ");
INSERT INTO aai_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Isan imih orot yait au tur nowar ebobosiyasiyar, i orot not wairafin ana bar to tafan wowab batabat na’atube. ");
INSERT INTO aai_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Taun gagamin yar, harew tit, naatu wowog tit bar babin, baise bar men ufar re’emih, anayabin bar ana bubu an i to wanawanan rouw re wowab. ");
INSERT INTO aai_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Baise orot yait au tur nowar naatu men ebobosiyasiyar, i orot aurin not en bar ana bubu dones yan rouw wowowab na’atube. ");
INSERT INTO aai_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Taun yar, harew tit, naatu wowog babin, bar babinakouw, naatu nati bar re’ere i ra’iy tagurugurus sawar.” ");
INSERT INTO aai_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu iti tur eo in sasawar ufunamaim, sabuw rou’ay gagamin na’in Jesu binan hinonowar isan hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Anayabin bi’obaiyih ana itinin i roubabaruwen ana fair isan ma’am na’atube, men Ofafar Bai’obaiyenayah na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu oyaw wanane re nan ana veya’amaim, sabuw rou’ay gagamin na’in hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Naatu orot ta biyan kokom ani’anin na Jesu nanamaim sun yowen eo, “Regah inakokok na’at basit biyou iniwa’an nigewasin.” ");
INSERT INTO aai_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu uman ru’atayan orot biyan butubun eo, “Ayu akokok, biya igewasin.” Mar ta’imonamo orot biyan kokom etei hihururuw hire orot biyan igewasin. ");
INSERT INTO aai_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Naatu Jesu orot iu, “Men orot babin ta ana tur inaowenamih, baise mutufor kwen firis biya enutitiy naatu Moses ana obaiyunen tur eo na’atube, sibor inayai sabuw etei matahimaim hina’itin o biya igewasin.” ");
INSERT INTO aai_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nati ana veya’amaim Jesu na Capernaum titit, basit Roman baiyowayan hai orot ukwarin na baibais isan Jesu ifefeyan. ");
INSERT INTO aai_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Regah, ayu au bowayan orot ta i sawow, an uman himorob, baremaim inu’in, misir isan men karam, biyan ebababan kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Basit Jesu eo, “Boro anan a orot aniyawas.” ");
INSERT INTO aai_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Baiyowayan orot ukwarin Jesu iya’afut eo, “Regah ayu men orot gewasu boro inan au bar wanawanan inarun, baise turawat kuo au bowayan orot eyawas. ");
INSERT INTO aai_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Anayabin ayu i roubabaruwen ana fair biyau’umaim ema’am, naatu baiyowayah etei ayu bab’umaim tema’am, imih baiyowayan orot ta isan anao, ‘Ni’imaim kwen,’ i boro nan, naatu orot ta isan anao, ‘Iti imaim kuna,’ i boro nan, naatu au bowayan orot ta isan anao, iti kusinaf, i boro nasinaf, imih turawat kuo au orot boro nayawas.” ");
INSERT INTO aai_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu iti tur nonowar ifofofor men kafaita, naatu sabuw hi’ufunun bairi hinan tatabir isah eo, “Anababatun a tur ao’owen, Israel wanawanan men kafa’imo orot ta ana baitumatum gagamin iti na’atube bitumatum atita’urimih. ");
INSERT INTO aai_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A tur ao’owen, sabuw moumurih boro veya yeninane naatu veya ra’iyinane hinan mar ana aiwobomaim hina run, gem sisibinamaim hai efan hinabow Abraham, Isaac, naatu Jacob bairi hiniyasisir. ");
INSERT INTO aai_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Baise sabuw iyab mar ana aiwobomaim hitarur i boro maramaim hinabow hinarauw hinare gugumin wanawanan hinarun. Nati’imaim hinama hinarerey wah hinanib kakikak hiniwa’an.” ");
INSERT INTO aai_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Imaibo Jesu baiyowayan orot ukwarin iu, “Aubar kwen, naatu abisa kubitumatum i boro namatar.” Naatu nati ana veya’amaim akir wairafin bar sawow inu’in yawas. ");
INSERT INTO aai_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naatu Jesu na Peter ana bar titit, Peter rawan babin sawow biyan fora’ab inu’in itin. ");
INSERT INTO aai_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Basit Jesu babin uman baib ana veya’amaim, ana sawow i en misir bay bogaigiwas. ");
INSERT INTO aai_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Birabirab sabuw wagabur kouh hiyen hima’am hibow hina Jesu biyan hitit, naatu awanawat eaf eo wagabur hibihir hititit, naatu sabuw afa hisawow hibow hinan auman etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sawar iti himamatar i dinab orot Isaiah eo kikirum na iturobe, “I akisinamo it ata sawow ata biyababan ebobosairen.” ");
INSERT INTO aai_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sabuw rou’ay gagamin maiyow hiruru’ay Jesu itih, basit ana bai’ufununayah iuwih eo, “Kwabobuna tarabon harew kukuf rewan rounane.” ");
INSERT INTO aai_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Naatu ofafar bai’obaiyenayan orot ta na Jesu isan eo, “Bai’obaiyenayan, ayu o menamaim kwenan ayu boro imaim airit tanan.” ");
INSERT INTO aai_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu iya’afut eo, “Sigarafor i hai batar tema’am, naatu mamu hai batar tema’am imaim ti’inu’in, baise Orot Natun inure in biyan tubaiwa’an isan aurin efan en.” ");
INSERT INTO aai_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bai’ufununayah orot tabo na Jesu isan eo, “Regah karam wan itihamiyu atan tamai momorob atayai’ibo atan ati’uf nuni airit tanan?” ");
INSERT INTO aai_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Baise Jesu iya’afut eo, “Ayu kwi’ufnunu tan, iyab himomorob taiyuwih boro hinaya’ih.” ");
INSERT INTO aai_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naatu Jesu wa isra’at ana bai’ufununayah hiyen bairi hiboy hirabon. ");
INSERT INTO aai_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naniyan meyemeye yabat gagamin misir wan kikiy yen wa iwanasum. Baise Jesu wa uranane nuhin bur inu’in ufu’ufut. ");
INSERT INTO aai_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bai’ufununayah hina Jesu hibunibun hio, “Regah, iniyawasi, wa iu’unun kafa’imo tana morob.” ");
INSERT INTO aai_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu iyafutih eo, “Kwa aisim kwabirubir? A not men nakabom, ayu kwanitutumu boro men kwanamorobomih.” Imaibo misir kwarar yabat kotar eotanih mar ta’imon nuwarob eafuw. ");
INSERT INTO aai_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ana bai’ufununayah hifofor hio, “Iti orot i abi orot? Karam yabat naatu kotar boro fanan hinab hinanutanub.” ");
INSERT INTO aai_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Naatu hirabon hina harew kukuf rewan rounane tafaram wabin Gadara hititit ana veya, orot rou’ab marasika wagabur kouh hito hirun rah yanamaim hima’ama hitit, hai itinin i birubir naatu nati efanamaim men yait ta reremoramih, anayabin hibirubir orot rou’ab isah. Baise Jesu nati’imaim titit ana veya, hairi hina Jesu biyan hitit. ");
INSERT INTO aai_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hiwow hio, “God Natun, aki isai mi’itube inasinafumih kunan? Aki baimakiy initi’imih, bo aki ai baimakiy ana veya binatit.” ");
INSERT INTO aai_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naatu nati’imaim for i men ef yok hima hi’u’ufar. ");
INSERT INTO aai_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Imih wagabur Jesu hifefeyan hio, “Aki inanuni ana titit akokok iniyuni anan for wanawanah ana run.” ");
INSERT INTO aai_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu eo, “Kwatit kwan.” Hirouwatait hinunuw hin for wanawanah hirun, for himisir fan hinunuw hire hin harew kukuf yan hire hi’aa tomatom himorob. ");
INSERT INTO aai_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Orot nati for hima’uten hima’am himisir hibihir hin bar merar hitit, abisa’awat himamatar hai tur hi’owen naatu orot rou’ab isah abisa mamatar auman hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Imaibo sabuw nati bar merar hima’am etei hitit hina Jesu bairi hitar naatu hi’i’itin ana veya hifefeyan hiu hai tafaram ihamiy tit. ");
INSERT INTO aai_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu wa afe’en yen naatu matabir maiye rabon na ana bar ana meraramaim tit. ");
INSERT INTO aai_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nati’imaim sabuw afa orot ta an uman murubin emo’emomaim hiwan hi’abar hina Jesu biyan hitit, naatu Jesu sabuw hai baitumatum itin, basit orot an uman murubin isan eo, “Natu men iniyababan, o a bowabow kakafih i anotanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naatu Ofafar Bai’obaiyenayah afa taiyuwih hibabatiyih hio, “Iti orot i tur kakafin maiyow eo God ebi’ib.” ");
INSERT INTO aai_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesu abisa hinotanot itin naatu eo, “Kwa aisim dogor wanawanan not kakafih kwanotanot? ");
INSERT INTO aai_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ef menatan i hamehamen, orot ana kakafih notawiyen isan anao i hamehamen ai anau namisir nabat nareremor i hamehamen? ");
INSERT INTO aai_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Baise kwakakasiy, imih ani’obaiyi kwana’itin, orot Natun i tafaramamaim fair bai bowabow kakafih notawiyen isan.” Naatu orot an uman murubin isan eo, “Kumisir a ir kunuw kubai a ubar kwen.” ");
INSERT INTO aai_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Orot misir ana ir nuw bai ana ubar in. ");
INSERT INTO aai_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sabuw iti na’atube matar hi’i’itin ana mar hai hibir ra’at naatu God wabin hibora’ara’ah fair iti na’atube orot bitih isan. ");
INSERT INTO aai_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu efan nati ihamiy remor inan auman, kabay o’onayan wabin Matthew ana bowabow efanamaim ma’am itin naatu iu, “Kumisir kwi’ufnunu.” Matthew ma’am misir Jesu iufunun hairi hin. ");
INSERT INTO aai_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesu Matthew ana baremaim ma bay hi’au, ana maramaim kabay o’onayah naatu bowabow kakafih sinafuyah moumurih maiyow hina Jesu ana bai’ufununayah bairi hikofanih bay aa ana efanamaim himare. ");
INSERT INTO aai_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Naatu Ofafar Bai’obaiyenayah hi’itih ana maramaim, Jesu ana bai’ufununayah hibatiyih, “Aisim kwa a bai’obaiyenayan kabay o’onayah naatu sabuw kakafih bairi hima bay te’aa?” ");
INSERT INTO aai_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu hio nowar naatu iyafutih eo, “Sabuw aurih sawow en adanafur orot boro men hinakok, baise sabuw iyab sawusawuwih boro adanafur orot hinakok. ");
INSERT INTO aai_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kwa Buk Atamaninamaim kwabiyab tur yabin kwa’itin? ‘Ayu i akokok kabeber, men sibor.’” ");
INSERT INTO aai_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naatu John Baptist ana bai’ufununayah hina Jesu hibatiy hio, “Aisim aki naatu ofafar bai’ufununayah bairi mar etei ayoyohar naatu o a bai’ufununayah i en?” ");
INSERT INTO aai_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu iyafutih eo, “Men karam sabuw orot boubun tatatabin ana yasisir isan hitaruru’ay, hitama orot yawasin hitabotouw, baise mar boro nanan orot boro hinabosair naatu nati ana veya’amaim imaibo hinifoufur hinirowarow. ");
INSERT INTO aai_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na’atube faifuw atamanin boro men karam hinab faifuw boubun hinafitimih, anayabin faifuw boubun hinasasauw ana veya boro nakaro’om natakweb mahar nara’at. ");
INSERT INTO aai_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na’atube men yait ta wine boubun ebai wine ana kibub atamaninamaim eriririmih, anayabin wine boubun boro nara’at naatu kibub natafofor wine nasuwa na re, imih wine boubun i boro wine ana kibub boubunamaim hinarir, saise hairi boro gewasih hinabat.” ");
INSERT INTO aai_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iti na’atube eo auman Tafaror Bar kaifenayan orot ta na Jesu biyan tit nanamaim sun yowen eo, “Ayu natu babitai i veya boun morob, baise akokok inan umawat inabutubun nayawas.” ");
INSERT INTO aai_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Basit Jesu misir ana bai’ufununayah bairi orot hi’ufunun hin. ");
INSERT INTO aai_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naatu babin ta ana faifuwamaim rara bota’ar ma’am kwamur etei 12 sasawar, na Jesu ufunane tit, ");
INSERT INTO aai_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ana notamaim eo, “Jesu ana faifuw tainin ana butubun boro ana yawas.” Naatu ana faifuw tainin butubun. ");
INSERT INTO aai_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu tatabir babin itin eo, “Natu men iniyababan, abai tumatumamaim kubigewasin.” Iti na’at eo ana veya’amaim, mar ta’imonamo babin igewasin. ");
INSERT INTO aai_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Imaibo Jesu na Kou’ay Bar kaifenayan orot ana bar wanawanan run. Sabuw hiru’ay hima hirerey itih, naatu rerey ana fik hibababin nowar. ");
INSERT INTO aai_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesu eo, “Iti kek babitai i matan fot inu’in, men morobomih, kwamisir ufun kwatit.” Baise sabuw isan himarib, anayabin i hiso’ob kek i morob. ");
INSERT INTO aai_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Basit sabuw etei himisir ufun hitit sawar, imaibo Jesu run in kek inu’in ana efanamaim tit, naatu babitai uman bai imisiruw yawas misir. ");
INSERT INTO aai_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iti sisinaf ana tur ra’at tasasar in nati tafaram hima’am ana fofonin etei hinowar. ");
INSERT INTO aai_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu efan nati itumar tit remor inan, orot rou’ab matah fim hitit hi’ufunun hin hi’af hio, “David uwan, kwiwanbabani.” ");
INSERT INTO aai_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesu na bar wanawanan run naatu orot rou’ab hina biyan hitit, Jesu ibatiyih eo, “Kwabitumatum ayu boro aniyawasi?” Hairi hiya’afut hio, “Regah abitumitum.” ");
INSERT INTO aai_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Basit Jesu hairi matah botobonen eo, “Kwabitumatum na’atube isa namatar.” ");
INSERT INTO aai_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hairi matah higewasin hinuw naatu Jesu eofafarih eo, “Men yait ta ana tur kwana’owen.” ");
INSERT INTO aai_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Baise hairi hitit hin Jesu ana tur hibosemor ra’at, nati tafaram hima’am ana fofonin etei hinowar. ");
INSERT INTO aai_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Orot rou’ab hinan ufut sabuw afa orot ta yoyom hirab awan igug ma’am hibai hina Jesu biyan hitit. ");
INSERT INTO aai_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naatu Jesu yoyom mowan nun tit orot busuruf tur eo sabuw etei hifofor hio, “Sawar iti na’atube Israel wanawananamaim men ta i’itin bounabo ta’i’itin.” ");
INSERT INTO aai_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Baise Ofafar Bai’obaiyenayah hio, “Iti i Demon Hai Ukwarin fair itin imih demon nunih titit.” ");
INSERT INTO aai_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu bar awan awan run tit sabuw inanawanih bar merar hai Kou’ay Baremaim sabuw i’obaibiyih, mar ana aiwob isan Tur Gewasin eo hinowar naatu sabuw hai sawow yumatah ta ta hibow hinan etei iyayawasih. ");
INSERT INTO aai_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesu iti rou’ay gagamin maiyow hinan itih yan baban, anayabin hai not kwaris naatu aurih baibais en, ana itinin i sheep na’atube aurih nabatanenayan orot en. ");
INSERT INTO aai_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Basit ana bai’ufununayah isah eo, “Masaw i gagamin na’in baise ana fourayah i men moumurih. ");
INSERT INTO aai_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imih masaw matuwan isan kwanayoyoban saise bowayah afa niyafarih hinan bay hinafour, anayabin bay i hiyamur.” ");
INSERT INTO aai_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu ana bai’ufununayah etei 12 eaf ayuwih hina, sawow yumatah ta ta, feher yumatah ta ta, sabuw biyahimaim baiyawasih isan fair itih naatu igegewasinih. ");
INSERT INTO aai_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Naatu iti i bai’ufununayah nah 12 wabih, wantoro’ot i Simon wabin ta Peter tufuturan Andrew hairi, James tufuturan John hairi, orot Zebedee natunatun. ");
INSERT INTO aai_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Bartholomew hairi, kabay onayan wabin Matthew i Thomas hairi, naatu Alpheus natun James i Thaddeus hairi, ");
INSERT INTO aai_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tafaram kafafarayan orot wabin Simon. Jesu ana yanuwayan orot Judas Iscariot hairi. ");
INSERT INTO aai_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Orot nah 12 Jesu iyunih hititit iuwih eo, “Ufun Sabuw hai tafaramamaim men kwanan naatu Samaria sabuw hai bar hai meraramaim men kwanarun. ");
INSERT INTO aai_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Baise kwanan Israel sabuw bobaituw na’atube hikasiy tema’am biyahimaim kwanarun kwaniyawasih. ");
INSERT INTO aai_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kwanan iti tur i kwanabinan, Mar ana aiwob i na iyubinaka. ");
INSERT INTO aai_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sawusawuwih kwaniyawasih, murumurubih kwanao hinamisir, sabuw iyab biyah kokom ani’anih kwaniyawasih naatu demon kakafih kwananunih hinatit. Sawar ana baiyan en kwabaib, imih kwanabow ana baiyan en. ");
INSERT INTO aai_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Men kabay ta kwanab a koukut kwaniwan, naiw a kikiramaim kwanarobere auman kwananamih. ");
INSERT INTO aai_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Remor isan men hafoy ta kwanab, men biya baibiyon ta, a baibiyon ta, tu ta, kwanabow auman kwananamih. anayabin bowayah abis kikimin tibitin boro nakaram. ");
INSERT INTO aai_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kwanan bar merar kikimin o bar merar gagamin kwanarur, sabuw iyab merarayow wairafih kwananuwihih, naatu i hai baremaim kwanama, a bowabow kwanisawar imaibo kwihamiyih kwanan. ");
INSERT INTO aai_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Naatu bar runamih sabuw a merarayow kwanitih. ");
INSERT INTO aai_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Naatu sabuw bar wanawanan tufuw ana merarayow hinabaib, basit a merarayow kwanihamiy nati baremaim nama, baise men hinabaib a tufuw ana merarayow kwanabosair kwanab maiye. ");
INSERT INTO aai_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Orot babin yait a merar men nay naatu a tur men nanonowar, kwanamisir ura kwanarutatab efan nati kwanihamiy kwanan efan ta. ");
INSERT INTO aai_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Anababatun a tur ao’owen, baibatebat ana veya God Sodom, Gomorah sabuw boro nakabibirih, baise nati bar merar sabuw hai baimakiy i boro God tafan nayara’ah gagamin na’in hinab. ");
INSERT INTO aai_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kwananowar, kwa i bobaituw sheep na’atube haru fairih wanawanahimaim abiyuni kwanatit kwananamih, imih kok na’atube kwanakakaf naatu mamu imak na’atube kwananutanub. ");
INSERT INTO aai_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Mata toniwa’an sabuw isah, anayabin boro hinabuw hinafatumi kwanan kanisel nahimaim hibabatiy, naatu Kou’ay Baremaim boro hinaborabirabi. ");
INSERT INTO aai_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ayu wabu’umaim kwabowabow isan boro aiwob sabuw naatu gawan orot gagamih na’atube Ufun Sabuw nahimaim Tur Gewasin kurereb nowar isan boro hinarab hinataini. ");
INSERT INTO aai_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Baise hinafatum hinabuw baibabatiyimih kwanan men kwaniyababan tur isan, o tur o isan, hinabibatiy ana veya’amaim tur boro imaim natit kwanao. ");
INSERT INTO aai_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anayabin nati tur i men o a notamaim tit kuo’omih, baise Tamat Anunin o iwani awa rukirir kuo. ");
INSERT INTO aai_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Orot ain boro tain baban nao namorob, regah boro natun nifa’ifa’i baban nao namorob, na’atube kek boro hinah tamah hinifa’ifa’ih babah hinao hinamorob. ");
INSERT INTO aai_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ayu wabu’umaim kwabowabow isan sabuw boro hinifa’ifa’i, baise orot yait nabat kikin nabowabow yomaninamaim boro yawas natita’ur. ");
INSERT INTO aai_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bar merar ta’amaim hinarukoukuw kwanabia’akir, kwanabihir kwanan bar merar ta, anababatun a tur ao’owen, Israel wanawanan bar merar etei boro men kwanabow kwanisawaribo Orot Natun namatabir maiye nanamih. ");
INSERT INTO aai_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kirum kek boro men ana bai’obaiyen orot na natabirimih, na’atube akir wairafin boro men ana orot ukwarin na natabirimih. ");
INSERT INTO aai_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Baise kirum kek na kok ana bai’obaiyen orot na’atube mataramih, basit i ukwarin na rerekab na kirum gewas, na’atube akir wairafin nabow gewas ana orot ukwarin boro nayara’ah ibe namatar, baise bar matuwan orot isan Beelzebul hinarouw hinao na’at, i ana akir wairafin isah boro tur kakafin maiyow hina’uwih wabih hini’a’afiy. ");
INSERT INTO aai_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Baise sabuw isah men kwanabir, anayabin abisa sum wanawanan wa’iwa’irin inu’in boro hina botait nirereb, naatu sawar baibunuwenamaim ti’inu’in etei boro hinatit hinibebeyan sabuw etei hinaso’ob. ");
INSERT INTO aai_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Abisa wa’iwa’iramaim ao kwanonowar sabuw etei nahimaim kwanao hinanowar, naatu abisa akisimo ao kwanonowar, kwanayen gem tafahimaim kwanabat kwanabinan sabuw etei hinanowar. ");
INSERT INTO aai_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sabuw biya te’a’asabun isan men kwanabirumih, anayabin anun boro men hina’asabunimih, baise God isan i kwanabir, anayabin i boro biya naatu anun hairi’ika na’asbunuwen hinamorob. ");
INSERT INTO aai_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mamu kwikwik rou’ab hai baiyan i one toea’maim boro inatubun, baise mamu ta boro men Tamat so’oba’e namorob haw nare’emih. ");
INSERT INTO aai_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Naatu kwa ukwarimaim arib i etei God iyab sawar. ");
INSERT INTO aai_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Imih men kwanabir, Tamat ana yabow kwa isa i ra’at men mamu kwikwik na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Orot yait sabuw etei nahimaim ayu isou eo’orereb, ayu auman boro maramaim na’atube ana sinaf Tamai nanamaim. ");
INSERT INTO aai_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Baise orot babin yait sabuw etei nahimaim ayu ekwakwahiru, ayu auman mar Tamai nanamaim boro ibo anakwahir. ");
INSERT INTO aai_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Men kwananot ayu i tufuw abai tafaramamaim anan, En. Ayu i men tufuw abai ananamih, baise kauseb abai anan. ");
INSERT INTO aai_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayu anan anayabin ‘Kek orot boro tamah hairi hinagam, babitai boro hinah hairi hinagam, babine boro rawan babin hairi hinagam. ");
INSERT INTO aai_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Imih orot ana kamabiy anababatun i boro i taiyuwin ana rara.’ ");
INSERT INTO aai_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Orot yait ana yabow ayu isou ikikimin naatu hinah tamah isah ebiyabow kwanekwan i men karam boro ni’ufnunu, na’atube orot yait ana yabow ayu isou ikikimin naatu i natun orot naatu babitai isah ebiyabow kwanekwan, i men karam boro ni’ufnunu. ");
INSERT INTO aai_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Naatu orot babin yait ana onaf men na’abar ayu nabi’ufnunu i men karam boro ayu airi ani’of. ");
INSERT INTO aai_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Orot babin yait taiyuwin ana yawas enunuwih boro ana yawas nikasiy, baise orot babin yait ana yawas isou ebi’inuw boro natita’ur. ");
INSERT INTO aai_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Orot yait kwa a merar eyiyi, ayu au merar eyiyi, naatu orot yait ayu au merar eyiyi, i orot yait ayu iyunu anan i ana merar eyiyi. ");
INSERT INTO aai_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Orot babin yait dinab orot ana merar eyiyi, anayabin i dinab orot, nati orot boro dinab orot ana baiyan turin nab. Naatu orot yait, orot ana yawas mutufurin ana merar eyiy, anayabin i orot ana yawas mutufurin boro orot ana yawas mutufurin ana baiyan turin nab. ");
INSERT INTO aai_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naatu orot babin yait kek kikimin harewawat hun itin etomatom, anayabin i ayu au bai’ufununayan, anababatun a tur ao’owen i ana baiyan boro nab.” ");
INSERT INTO aai_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu ana bai’ufununayah nah 12 roube’aten tur bitih ufunamaim efan nati itumar naatu na Galilee wanawanan bar merar afa imaim sabuw i’obaibiyih naatu binan. ");
INSERT INTO aai_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John Baptist dibur bar ma’am Jesu bowabow bigan nowar, basit ana bai’ufununayah orot afa iyunih hin Jesu hibatiy. ");
INSERT INTO aai_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ku’o anowar, John isa eo anonowaraban o iti ina, ai aki boro orot tabo isan anama anakaif?” ");
INSERT INTO aai_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu iyafutih eo, “Kwamatabir kwan abisa kwa’i’itin naatu kwanonowar i John ana tur kwana’owen. ");
INSERT INTO aai_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Matah fim higewasin, ah kafikafirih higewasin hibat tereremor, sabuw biyah kokom ani’anih etei higewasin, tainih gugurih tur tenonowar, murumurubih hiyawas maiye timimisir, naatu Tur Gewasin i yababan sabuw isah tibibinan. ");
INSERT INTO aai_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Orot yait ayu asisinaf isan erekasiy auman ebitumatum, i boro men baigegewasin nab.” ");
INSERT INTO aai_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John ana bai’ufununayah hinan ufut, Jesu sabuw ibatiyih, “Arar yan kwatit kwanan John abisa sisinaf itinamih kwanot kwan? Kotar wadar i’inuwas inu’in itinamih kwan? ");
INSERT INTO aai_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ai abisa itinamih kwan? Orot eabur gewas batabat itinamih kwan? Baise sabuw hai abur gewasin i bar gewasihimaim tema’am. ");
INSERT INTO aai_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kwa’o anowar, abisa itinamih kwan, dinab orot? Turobe, baise a tur ao’owen iti orot i dinab etei natabirih. ");
INSERT INTO aai_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anayabin iti orot John isan i Buk Atamaninamaim iti na’atube hikirum. ‘Ayu au kob abarayan boro wan o namaim aniyun nan, i boro o a ef nayabuna.’ ");
INSERT INTO aai_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Anababatun a tur ao’owen John Baptist baibin hitatoub wanawanahimaim i orot gagamin ta hitoub hiyai. Baise orot yait mar ana aiwobomaim ebikek boro John nan natabir. ");
INSERT INTO aai_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Baptist bibinan ana veya na iti boun titit, sabuw fairih i mar ana aiwob bain isan hai fairamaim hibiturafef. ");
INSERT INTO aai_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anayabin Dinab oro’orot naatu ofafar bukamaim hikikirum i hima hio inan John natit. ");
INSERT INTO aai_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Imih iti tur inanowar bainamih inakokok na’at basit kubai, anayabin dinab orot Elijah matabir maiye namih hio kikirum, i John ana efan bai na titika. ");
INSERT INTO aai_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Imih o yait tain nama’am na’at tur inanowar. ");
INSERT INTO aai_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Itinin boro abisa’amaim iti boun ana sabuw isah anao kwanowar, sabuw iti boun hai itinin i kek gidigidih ahar efanamaim tema, hai ofonah bairi fafowamih tibi’afa’afa na’atube. ");
INSERT INTO aai_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aki tabin ana ew atatabor, baise kwa men kwabenaben, naatu morob ana ew atatabor baise kwa men kwarerey.’ ");
INSERT INTO aai_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“John nan ana veya’amaim i yohar naatu harew fokarih men tom, naatu sabuw etei hio, iti orot i yoyom koun hiyen ema’am. ");
INSERT INTO aai_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Baise Orot Natun nan i bay eaa, harew fokarin tom, sabuw etei hio, ’Iti orot kwa’itin, anaa, anatom kakafin! Kabay o’onayah naatu sabuw bowabow kakafih sinafuyah bairi hiof tema’am.’ Baise God ana so’ob i turobe sinafumaim tit yabin emamatar.” ");
INSERT INTO aai_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bar merar moumurih maiyow Jesu ina’inanen moumurih na’in sinaf, baise sabuw men hikokok boro hai kakafihine hisisinaf dogor baikitabir hitab, imih Jesu yan so’ar iuwih eo. ");
INSERT INTO aai_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kwa Chorazin sabuw bai’akir kakafin boro kwanab, naatu kwa Bethsaida sabuw bai’akir kakafin boro kwanab! Iti ina’inan kwa biyamaim asisinaf, Taiya sabuw naatu Sidon sabuw wanawanahimaim atasisinaf na’at, marasika boro ar faifuw kakafih hita’osen, yuh wah gao hitarab, hai kakafihine dogor baikitabir hitabaika. ");
INSERT INTO aai_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Baise a tur aowen, baibatebat ana veya’amaim Taiya sabuw naatu Sidon sabuw hai baikwatutunen i boro ana fofonin, baise kwa abai kwatutunen boro tafan hiya’abar kwanab. ");
INSERT INTO aai_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Naatu kwa Capernaum sabuw wab yen maramaim inu’in boro nare moroboyah hai efanamaim na’in. Ina’inan iti boun kwa biyamaim asisinaf marasika Sodom sabuw biyahimaim ata sisinaf na’at, iti boun ana veya i boro tama. ");
INSERT INTO aai_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Baise a tur ao’owen, baibatebat ana veya, Sodom sabuw hai baikwatutunen i boro ana fofonin, baise kwa a baikwatutunen boro tafan hiya’abar kwanab.” ");
INSERT INTO aai_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nati ana veya’amaim Jesu yoyoban eo, “Tamai mar tafaram ana Regah a merar ayiyi, anayabin not gewasih sabuw so’oso’obayah hai notamaim ibun wa’ir ma’am natunat bereberefiy biyahimaim iwa’an ebirerereb. ");
INSERT INTO aai_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Turobe Tamai, abisa kokokomaim isinaf temamatar imih gewasin. ");
INSERT INTO aai_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Sawar etei’imak i ayu Tamai itu. Men yait ta so’ob ayu i God Natun, naatu men yait ta so’ob God i ayu Tamai, imih sabuw iyab ayu arurubinih boro ani’obaiyih i auman hiso’ob God i ayu Tamai. ");
INSERT INTO aai_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kwa iyabowat bit kwa’abar tun rarabi, kwana ayu biyau, ayu boro efan anit kwaniyarir. ");
INSERT INTO aai_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ayu au bai’obaiyen hamehamen kwanab kwani’ufunun, anayabin ayu i taiyuwu ayara’iyu anutanub, imih kwanan ayu biyu’umaim boro biya tuniwa’an. ");
INSERT INTO aai_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anayabin ayu au bai’obaiyen i kiririn imih an bi’obaiyi i boro hamehamen.” ");
INSERT INTO aai_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Veya bai’ab na’atube sawar ufunamaim, Jesu Baiyarir Ana Veya sanabey wanawanah remor inan ana bai’ufununayah a himorob, basit sanabey afa hirut hikeb ro’oro’oh hibow hi’aa. ");
INSERT INTO aai_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naatu ofafar bai’obaibiyenayah hi’itih basit Jesu hi’u, “A bai’ufununayah ku’itih, abis tisisinaf i ata ofafar te’a’a’stu’utu’ub, anayabin boun i Baiyarir ana veya. ");
INSERT INTO aai_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Jesu iyafutih eo, “David ana sabuw bairi aa himomorob ana maramaim, David God ana bar wanawanan run, rafiy God isan hisibor hi’inu’in, bow ana sabuw bairi hi’aa, Buk Atamaninamaim hikirum inu’in kwaiyab kwa’itin? Nati i ofafar hi’astu’ub, anayabin nati sibor i hi’ofafar firis akisihimo hinabow hina, men David ana sabuw o men yait ta’aamih. ");
INSERT INTO aai_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naatu Moses ana ofafar ta kwaiyab kwa’itin? Baiyarir ana veya firis terun Tafaror Bar teyayabuna men ofafar te’a’astu’ub? En. ");
INSERT INTO aai_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Baise boun i a tur ao’owen, sawar gagamin anababatun i na tit, men iti Tafaror Bar na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buk Atamaninamaim i iti na’atube eo, ‘Kabeber i akokok men sibor.’ Kwa iti sawar yabin anababatun kwatasoso’ob na’at sabuw gewasih boro men kwatakusairih. ");
INSERT INTO aai_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Anayabin Orot Natun i Baiyarir Tamah anababatun.” ");
INSERT INTO aai_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu nati efan itumar na hai Kou’ay Bar ta wananwanan run, ");
INSERT INTO aai_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","orot ta uman murubin ma’ama’amaim, naatu sabuw afa nati’imaim hima’am i ef hinunuwet Jesu gamin uwin isan, imih Jesu hibatiy hio, “It ata ofafaramaim Baiyarir ana veya orot babin boro taniyawas ai en?” ");
INSERT INTO aai_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Baise Jesu iyafutih eo, “Bo o orot ta a sheep Baiyarir ana veya hub tare’er, boro itatain tayen o itihamiy ta’in tamorob? ");
INSERT INTO aai_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Orot ana yawas i ra’at kwanekwan men for na’atube’emih. Isan imih Baiyarir ana veya orot babin tanabibais i men tasisinaf kakaf ofafar ta’a’astu’ubimih.” ");
INSERT INTO aai_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Imaibo orot uman murubin isan eo, “Uma ku’otofair a’itin.” Naatu orot uman otofair naatu uman igewasin uman rounane na’atube matar. ");
INSERT INTO aai_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Basit Pharisee Jesu hihamiy hitit ufun, rabin morob isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu rabinamih hiyayanuw tur nowar naatu efan nati ihamiy sa’ab in, sabuw rou’ay gagamin na’in hi’itin hi’ufunun bairi hinan, iyabowat hisawow hinan etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naatu eo fafarih eo, “Sabuw afa hai tur men kwana’owenamih. ");
INSERT INTO aai_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iti i abisa dinab orot Isaiah ana bukamaim kikirum na iturobe. ");
INSERT INTO aai_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Iti orot i ayu isau bowamih arubin, ayu au yabow orot, i isan ayu abiyasisir, Ayu Anunu boro anitin, naatu i boro ma gewas isan sabuw tutufin etei isah naorerereb. ");
INSERT INTO aai_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I boro men nagam naatu boro men fanan aumetawat niwow; Fanan boro men ef gagamin yanamaim hinanowar. ");
INSERT INTO aai_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sawasaw ririmih hikimow tere’er boro men na’abar faifiyen, na’atube ana marakaw kikimin etoto’ab boro men nihamiy, baise boro nihamiy nato’ab nanan ma gewas ana fair nara’at. ");
INSERT INTO aai_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Naatu sabuw etei hai not hai baitumatum i biyanamaim hinayai.’” ");
INSERT INTO aai_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Imaibo sabuw afa orot ta matan fim naatu demon awan gugin toun bububur ma’am hibai hina Jesu biyan hitit iyawas naatu misir tur eo naatu matan igewasin nuw. ");
INSERT INTO aai_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sabuw rau’ay gagamin na’in Jesu abisa iwa’an hi’i’itin hai hikasiy ra’at hio, “Iti orotom David uwan ta?” ");
INSERT INTO aai_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Baise Pharisees hinonowar hio, “Iti orot demon enununih, anayabin demon hai ukwarin wabin Beelzebul fair itin, nati esisinaf.” ");
INSERT INTO aai_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu abisa hinotanot so’ob, naatu uwih eo, “Tafaram ta’imon hinakusib rou’ab namatar hinabiyow boro men manin hiniyowamih, naatu bar meraramaim o ain uf rara’amaim hinakusib hinabiyow hai ma boro hini’afiy. ");
INSERT INTO aai_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Imih Demon Ana Aiwob wanawananamaim hinakusib taiyuwih hinabiyow, i ana aiwob wanawanan ana fair boro naririm. ");
INSERT INTO aai_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naatu kwa i ayu Beelzebul fair baitu demon nunih kwarouw kwa’o. Bo kwa a bai’ufununayah i yait ana fairamaim demon tenununih? Isan imih kwa taiyuw abai’ufununayah hai sinafumaim ebi’obaiyi God ana baibatiyen i wan kwamara’at. ");
INSERT INTO aai_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Baise ayu i God Anunin Kakafiyin ana fairamaim demon anununih, imih nati ebi’obaiyit mar ana aiwob i na tit kwa wanawananamaim. ");
INSERT INTO aai_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Orot fairin ana bar boro men asir hinarun ana sawar hinabainomih, baise wantoro’ot orot hinab hinafatum nabat, imaibo ana sawar hinabainuw. ");
INSERT INTO aai_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Orot yait ayu airi men abita’imon i ayu au wosai, naatu orot yait men ayu ibaisu airi bobaituw abigenamih, nati orot i wasgeyayan. ");
INSERT INTO aai_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ana’an nati isan imih a tur ao’owen, bowabow kakafih ta ta naatu bai’ib tur ta ta God boro nanotawiyen, baise orot yait Anun Kakafiyin ni’ib isan tur kakafin na’o, i ana bowabow kakafih boro men nanotawiyimih. ");
INSERT INTO aai_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naatu orot yait Orot Natun isan tur kakafin na’o nabigigim boro ana bowabow kakafin nanotawiyen, baise orot yait God Anun Kakafiyin isan na’o nabi’iyab, i boro tafaramamaim men nanotawiy na’atube maramaim. ");
INSERT INTO aai_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“A ai inakaif gewas boro ro’on gewasin inab, a ai men inakaif gewas ro’on boro kakafin inab, anayabin ai i boro ro’onamaim ina’inan. ");
INSERT INTO aai_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kwa i tuwamorob foufuh, dogor wanawanan kakafin ema’am boro mi’itube tur gewasih kwana’o. Anayabin abisa dogor wanawanan ema’am i awamaim etitit. ");
INSERT INTO aai_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Orot gewasin ana bar wanawanan sawar gewasih ya ti’inu’in boro nabow naya taiten, naatu orot kakafin ana bar wanawanan sawar kakafih ya ti’inu’in boro naya taiten. ");
INSERT INTO aai_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Imih a tur ao’owen, baibatebat ana maramaim sabuw etei awahimaim tur abisa hi’o boro God ana tur hina’owen aisim nati tur hi’o. ");
INSERT INTO aai_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Naatu o taiyuw a tur io’omaim God boro nibatiyi, naatu o taiyuw a turamaim boro naorereb o i gewas o kakaf.” ");
INSERT INTO aai_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Imaibo Pharisee naatu Ofafar bai’obaiyenayah afa himisir hi’o, “Bai’obaiyenayan, aki akokok ina’inan ta iniwa’an ana’itin.” ");
INSERT INTO aai_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Baise Jesu iyafut eo, “Kwa iti mar boun nan ana sabuw a fanasair ra’at, ina’inan itinamih kwa’o. Baise ina’inan boro men ta kwana’itinamih, ina’inan ta’imon nati dinab orot Jonah biyanamaim kwa’itinika. ");
INSERT INTO aai_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah siy gagamin tonan yan wanawanan in fai tounu auyit tounu na’atube, Orot Natun boro fai tounu auyit tounu me wanawanan na’in. ");
INSERT INTO aai_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonah binan Nineveh sabuw hinonowar ufunamaim hai bowabow kakafih hisisinaf etei hihamiyen, imih baibatebat ana veya boro hinamisir kwa kwabiwa’an kakaf isan boro hina’uwi, anayabin binan iti boun abit i men marasika Jonah bibinan na’atube’emih! ");
INSERT INTO aai_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na’atube tafaram Sheba hai aiwob babin Solomon ana binan gewasin nowaramih ana tafaram ef yok na’in ihamiy na tur nowar, imih baibatebat ana veya boro namisir, kwabiwa’an kakaf isan na’uwi, anayabin Solomon bibinan i men boun ayu abibinan na’atube’emih! ");
INSERT INTO aai_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Demon kakafin orot biyanamaim ema’am tenun etit i boro watu owararinamaim ma baiyarir isan ana efan nanuwet, naatu efan men natitita’ur na’at, ");
INSERT INTO aai_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i boro na’o, ‘Ayu boro anamatabir maiye au ubar anan.’ Naatu namatabir nan ana bar natitit, ana bar wanawanan i owararin naatu hirereb hiyabuna inu’in boro na’itin. ");
INSERT INTO aai_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Imaibo boro namatabir maiye demon kakafih anababatun etei seven nanawiyih bairi hinan nati bar hinasusuw hinama. Naatu nati orot i boro na’af narauwabon men marasika ma’am na’atube’emih. Imih iti sabuw boun hima kakafih tesisinaf boro isah na’atube namatar.” ");
INSERT INTO aai_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu eo, sabuw hima hinonowar ana tur baisawarina’e, hinah taitin hina hitit ufun hibat hi’o, “Aki akokok Jesu bairi ana’o.” ");
INSERT INTO aai_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Basit orot ta run Jesu iu, “Hinat taiti hina ufun tebatabat, tekokok bairi kwana’o.” ");
INSERT INTO aai_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesu orot iya’afut eo, “Ayu hinai naatu taitu anababatun ana’o inanowar.” ");
INSERT INTO aai_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Imaibo ana bai’ufununayah isah uman fufunih eo, “Ayu hinai naatu taitu i iti tema’am ku’itih. ");
INSERT INTO aai_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Orot yait ayu Tamai maramaim eo na’atube fanan bai esisinaf i ayu taiu, ayu rubu naatu ayu hinai.” ");
INSERT INTO aai_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nati veya ta’imon Jesu bar itumar tit na harew kukuf sisibinamaim sabuw bai’obaiyih isan mara’iy. ");
INSERT INTO aai_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Naatu sabuw moumurih maiyow hiru’ay hi’ar bebera’uh itih, basit wa bai inatait tafan mare, sabuw baise dones yan himarir hima. ");
INSERT INTO aai_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Imaibo ma sawar moumurih na’in oroubonamaim eo hima hinowar. Naatu ana oroubon ta i iti na’atube eo, “Ana veya ta orot masaw bowayan ana ub tanumamih tit in. ");
INSERT INTO aai_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ana ub afa tata’asiyen i ef yanamaim hire, naatu mamu hire hibow hi’aa, ");
INSERT INTO aai_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ana ub afa i to’ato yan hire’ere ana kamar men gagamin imih saisewat hikubounih hiyen. Anayabin kamar baban i fokarin. ");
INSERT INTO aai_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Baise veya yey ana mar wabuburinamaim ub etei hi’arat, naatu hikimow hire anayabin wairoroh men babanika hire. ");
INSERT INTO aai_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ub afa kokor wanawanan hire, naatu kokor ana fafa’amaim isuken. ");
INSERT INTO aai_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Naatu ub afa i me gewasin yan hire hikuboubunih hiyen gewas ro’oro’oh hiya, afa hibiw 100 na’atube, afa i 60 na’atube, afa i 30 na’atube. ");
INSERT INTO aai_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Imih o yait tain nama’am tur inanowar.” ");
INSERT INTO aai_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naatu Jesu ana bai’ufununayah hina hibatiy hi’o, “Aisim oroubonamaim sabuw kubi’obaiyih?” ");
INSERT INTO aai_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu iyafutih eo, “Orereb ana so’ob wa’iwa’irin mar ana aiwob isan i God kwa it, men iti sabuw itihimih. ");
INSERT INTO aai_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Imih orot yait orereb ana so’ob biyan ema’am, God boro tafan naya’abar nitin ana so’ob nara’at, baise orot yait nati so’ob men biyan ema’am naatu ana so’ob kikimin nati biyanamaim ema’am God boro nabosair. ");
INSERT INTO aai_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ana’an nati ayu oroubonamaim sabuw abi’obaiyih. Sabuw matah ema’am baise boro men hina’itin, Tainih ema’am baise boro men hinanowar naniyan hinab. ");
INSERT INTO aai_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dinab orot Isaiah ana Bukamaim eo kikirum i na ibiturobe. ‘Iti sabuw tur hinanowar, baise boro men naniyan hinabaimih matah ema’am baise boro men hina’itinimih. ");
INSERT INTO aai_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Anayabin ukwarih fokar, tainih higibud, matah hibofafaren. Sawar iti men hitasinaf, karam tur boro hitanowar, abis emamatar hita’itin hai not takusib, tur naniyan hitab, kakafih hitihamiyen, hita’intabir ayu atiyawasih.’ ");
INSERT INTO aai_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Baise Kwa i kwabiyasisir, anayabin matayan kwa’i’itin naatu tain yan tur kwanonowar. ");
INSERT INTO aai_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anababatun a tur ao’owen, dinab orot moumurih na’in naatu sabuw gewasih hikok kwanekwan, kwa abisa kwa’i’itin i hita’itin naatu abisa kwanonowar i hitanowar. Baise nati ana maramaim sawar men matar boro hita’itin.” ");
INSERT INTO aai_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tain kwanarub ub tanumayan ana oroubon ao kwananowar naniyan kwanab, yabin kwanaso’ob. ");
INSERT INTO aai_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sabuw iyab mar ana aiwob isan Tur Gewasin ao tenonowar naatu naniyan men tabaib i ub ef yanamaim orot ta’asiy re’er na’atube, Tur Gewasin tenonowar ana maramaim demon kakafin ena hai not ebikwaris. ");
INSERT INTO aai_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Naatu orot ana ub afa to yan hire’ere ana itinin i sabuw iyab tur tenonowar ana maramaim i tibiyasisir. ");
INSERT INTO aai_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Baise dogoroh wanawanan nati ub wairoron i men re eof barur, imih Tur Gewasin isan hina’uwih hinarurukaukuwih boro mar ta’imonamo hai baitumatum hinihamiy. ");
INSERT INTO aai_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Naatu orot ana ub afa fotan wanawanan hire’er ana itinin i sabuw iyab tur tenonowar, baise iti tafaram ana yasisir isan tibiyababan naatu totobuyoy hai not ebikwaris imih tur ana ro’on men emamatar. ");
INSERT INTO aai_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Baise orot ana ub me gewasin yan ta’asiy hire’ere ana itinin i sabuw iyab Tur Gewasin tenowar naatu naniyan tabai tiw tehahamu, afa ro’oh 100, afa 60, afa 30.” ");
INSERT INTO aai_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu oroubon tabo iti na’atube eo, “Mar ana aiwob i iti na’atube, ana veya ta orot ana ub bow in ana masawamaim tanum. ");
INSERT INTO aai_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Baise gugumin sabuw etei hi’inu’in ufut, orot ana rakit mowan fotan kakafih bow na sanabey wanawanah tanum naatu bihir. ");
INSERT INTO aai_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sanabey hikuboubunih hiyey wanawanahimaim fotan kakafih auman hikubounih bairi hiyen. ");
INSERT INTO aai_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Orot ana bowayah hina hio, ‘Regah, o ub gewasih a masawamaim itanum, baise aisim fotan kakafih auman hikuboubunih teyey?’ ");
INSERT INTO aai_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Orot iyafutih eo, ‘Rakit sabuw afa hisinaf.’ Naatu akir wairafih hibatiy hio, ‘Bo kukokok anan fotan ana uyarir?’ ");
INSERT INTO aai_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Orot iyafutih eo, ‘En. Fotan kakafih kwana’u’uyarir boro sanabey afa auman kwana’uyarir. ");
INSERT INTO aai_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Imih kwaihamiyih bairi hinayen hiniw naatu tarin ana veya boro tarayah aniyafarih hinan, fotan wan hinatar hinafatum hinabow hinan hina’afusar, imaibo sanabey hinatar hinabow hinan bar hinaya.’” ");
INSERT INTO aai_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu ana oroubon tabo eo, “Mar ana aiwob ana itinin ta i iti na’atube, orot ana ai momor ro’on kikimin maiyow bai in ana masaw yan tanum. ");
INSERT INTO aai_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iti ai ro’on i men ai ro’on afa gagamih na’atube’emih, baise tanum kuboun yey ana veya’amaim ra’at ai gagamin na’in matar naatu mamu hina famefamenamaim hibatar hima.” ");
INSERT INTO aai_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu iban oroubon tabo eo maiye, “Mar ana aiwob itinin ta i iti na’atube. Babin yeast ebai ana faraw wanawanan eyai ekamat inu’in era’at eyey na’atube.” ");
INSERT INTO aai_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu sawar iti etei isah i oroubonamaim eo sabuw rou’ay gagamin bi’obaiyih; ana bai’obaiyenamaim i mar etei oroubonamaim sabuw bi’obaiyih. ");
INSERT INTO aai_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iti na’atube sisinaf anayabin abisa dinab orot eo kikirum tan titurobe isan. “Ayu i boro oroubonamaim anao sabuw hinowar, naatu tafaram mamatar ana buriburin men hisoso’ob etei anao hinanowar.” ");
INSERT INTO aai_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu sabuw rou’ay ihamiyih naatu na bar wanawanan run, ana bai’ufununayah ufun hina hirun hibatiy hio, “Masaw yan fotan kakafin ana oroubon i kukubuna anowar.” ");
INSERT INTO aai_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu iyafutih eo, “Orot ub gewasih tatanum i Orot Natun. ");
INSERT INTO aai_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Masaw ana itinin i tafaram, naatu ub gewasin i sabuw iyab mar ana aiwob isan tebowabow, naatu ub kakafin i Demon Kakafin natunatun. ");
INSERT INTO aai_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naatu rakit orot ub kakafin bai na masaw yan tatanum i Demon Mowan. Naatu masaw biyamur i mar yomanin na’atube, masaw fourayah i God ana tounamatar. ");
INSERT INTO aai_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Imih mar yomanin iti ub kakafih hi’uyarir hifatum hibow hin hi’a’afusar na’atube boro namatar. ");
INSERT INTO aai_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Orot Natun boro ana tounamatar niyafarih hinatit, sinaf kakafih naatu sabuw iyab bowabow kakafin kura’ahih hima kakafih tisisinaf etei i ana aiwob wanawananamaim boro fotan kakafin na’atube hinatar hinafatum. ");
INSERT INTO aai_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Naatu hinabow hinan wairaf wan hinaya hina’afusar, nati’imaim boro na’arahih wah takitak niwa’an hina’in hinarerey. ");
INSERT INTO aai_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Imaibo God ana sabuw gewasih nabow mar ana aiwobomaim hinarun veya na’atube hinararan. Imih o yait tain nama’am iti tur inanowar. ");
INSERT INTO aai_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mar ana aiwob itinin ta i iti na’atube, orot ta nugunug hibun inu’in itin bai, naatu me nati nugunug titita’urimaim kair maiye ibun, naatu yasisir auman in ana sawar etei sabuw hitobon naatu matabir maiye na nati me tutubun na’atube. ");
INSERT INTO aai_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naatu mar ana aiwob itinin tabo iti na’atube. Orot sawar tobonayan wakek enunuwet na’atube. ");
INSERT INTO aai_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wakek nuwet inan wakek ta gewasin ana baiyan gagamin na’in tita’ur, naatu na ana sawar etei yataiten hitobon kabay bai in nati wakek tutubun na’atube. ");
INSERT INTO aai_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iban maiye mar ana aiwob i buwat na’atube. Orot siy bowayan ana buwat eya ema’am siy i yumatah ta ta te’ona’on. ");
INSERT INTO aai_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Naatu buwat awan ekakaratan ana veya etab erun dones yan ema siy gewasih ikiyarir fetan iwan, naatu kakafih ikiyarir ebow ebis rouruwen na’atube. ");
INSERT INTO aai_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Imih mar yomanin nanan itinin i boro nati na’atube. God boro ana tounamatar niyafarih hinatit hinan sabuw gewasih wanawanahimaim sabuw kakafih hinabow ");
INSERT INTO aai_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wairaf wan hiyara’aten na’arahih hina’in hina rerey wah takitak niwa’an.” ");
INSERT INTO aai_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu ibatiyih eo, “Oroubon iti ao’oban naniyah kwabow?” Ana bai’ufununayah hiya’afut hio, “Naniyah abow.” ");
INSERT INTO aai_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naatu Jesu iuwih eo, “Isan imih, ofafar bai’obaiyenayan orot yait mar ana aiwob isan bai’obaiyen hibitin i bar matuwan matar, imih nati bar wanawanan ana sawar boubuh naatu atamanih etei boro nayataiten.” ");
INSERT INTO aai_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu iti oroubon eo hinonowar ufunamaim nati efan itumar, ");
INSERT INTO aai_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","naatu remor na i ana bar meraramaim tit Kou’ay Bar ta wanawanan run, busuruf sabuw i’obaibiyih. Naatu sabuw hima hinonowar hifofor hio, “Iti orot ana ukwar rerekab naatu ina’inanen sinaf isan ana fair i menamaim bow? ");
INSERT INTO aai_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iti orot tamah i bar wowabayan naatu hinah i Mary naatu James, Joseph, Simon, Judas i taitin. ");
INSERT INTO aai_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naatu taitin baibitar auman bairit iti tama’am, imih iti sawar etei i menamaim bow?” ");
INSERT INTO aai_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iti na’atube hio hina’ufut hin. Jesu iuwih eo, “Dinab orot tafaram afa’amaim i tekakafiy, baise i ana bar meraramaim naatu i tain tuwan i men tekakafiy.” ");
INSERT INTO aai_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naatu nati’imaim men ina’inan moumurih sinafumih, anayabin nati sabuw aurih baitumatum en. ");
INSERT INTO aai_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nati ana veya’amaim Herod tafaram Galilee ana kaifayan orot Jesu bowabow ana tur nowar. ");
INSERT INTO aai_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naatu ana orot ukwarih hai tur eowen eo, “Ni’i orot i John Baptist, morobone yawas maiye, imih fair bai nati ina’inan isisinaf.” ");
INSERT INTO aai_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod i John Baptist bai fatum in dibur yari’iy aawan Herodias baiyasisirin isan. ");
INSERT INTO aai_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","John tur fokarin maiyow Herod Herodias i tain Philip aawan bai bi’aawan isan gam iu, “O i ofafar iastu’ub tai aawan ibai i’awan.” Tur fokarin iti eo isan Herod yan bai dibur yari’iy. ");
INSERT INTO aai_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod kok i John ta’asabun, baise Jew sabuw isah bir, anayabin John hi’i’itin i dinab orot ta na’atube. ");
INSERT INTO aai_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naatu Herod ana tufuw isan hibiyasisir ana veya’amaim, Herodias natun babitai run sabuw rou’ay gagamin nahimaim benaben, Herod itin iyasisir gagamin maiyow. ");
INSERT INTO aai_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Naatu taiyuwin isan eo baifaro babitai eomatan eo, “Abisa kukokok boro anit?” ");
INSERT INTO aai_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naatu babitai hinah ana turamaim na eo, “Ayu akokok boun John Baptist ukwarin tew yan iniwan inab inan initu.” ");
INSERT INTO aai_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aiwob orot iti tur nonowar i uwan yi, baise sabuw rou’ay gagamin matahimaim eomatan, imih ana baiyowayah orot iuwih babitai ana kokok hisinaf. ");
INSERT INTO aai_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","John dibur bar wanawananamaim ma’am hin sikan hi’afuw, ");
INSERT INTO aai_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ukwarin tew yan hiwan hibai hina babitai hitin, bai in hinah itin (so’ob John i morob). ");
INSERT INTO aai_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John ana bai’ufununayah hina biyan hibai hin hiyai, imaibo hin Jesu ana tur hiowen. ");
INSERT INTO aai_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesu John ana tur nonowar ufunamaim, wa bai akisinamo efan nautanubinamaim in. Baise sabuw menamaim inan i ana tur hinowar, ababawat bar merar ta ta hirun hitit hi’ufunun hin. ");
INSERT INTO aai_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesu wa biyut ana veya nuwanuw sabuw rou’ay gagamin maiyow i’itih iyababan, naatu hai sabuw sawusawuwih hibow hinan etei iyayawasih. ");
INSERT INTO aai_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Veya re birabirab auman Jesu ana bai’ufununayah hin hiu, “Veya i re sawar. Igewasin sabuw iniyafarih hinan bar merar yubinamaim bay hinatobon hinaa hinayawas.” (Anayabin iti efan i arar yan sabuw en).” ");
INSERT INTO aai_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu iyafutih eo, “Men karam asir ana’uwih hinan. Gewasin, kwa a efanamaim bay kwana’itin kwanitih hina hinayawas.” ");
INSERT INTO aai_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Baise hiya’afut hio, “Aki ai efanamaim rafiy fafar etei umat roun naatu siy rou’ab na’atumo ti’inu’in, men karam boro iti sabuw rou’ay gagamin anituwih.” ");
INSERT INTO aai_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu eo, “Kwabow kwana kwaitu.” ");
INSERT INTO aai_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naatu sabuw iuwih fotan yan himare, imaibo Jesu rafiy fafar umat roun, siy rou’ab auman bow au mar nuw ra’at, God ana merar yi sawar, basit rafiy imseseb ana bai’ufununayah itih, naatu ana bai’ufununayah hibow sabuw hifaramih hi’aa. ");
INSERT INTO aai_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sabuw etei hi’aa yah iw, naatu ana bai’ufununayah bay rebareb hi’aa hi’inu’in hibow hibiwan sakasak etei 12 hiwan foten. ");
INSERT INTO aai_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Orot iti bay hi’aa hibiyab etei 5,000 kek babin men auman hiyabamih. ");
INSERT INTO aai_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesu matan kabiy ana bai’ufununayah iuwih wa hibai wan hirabon hin harew kukuf rewan rounane na’at. Naatu Jesu ma sabuw iyafarih hai au bar hin. ");
INSERT INTO aai_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sabuw iyafarih hinan ufut akisinamo yen in oyawamaim yoyoban isan. Naatu nati’imaim, akisinamo ma’am mar bu’u’um. ");
INSERT INTO aai_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Iti ana veya’amaim ana bai’ufununayah i hire hin hikukuyowen ana veya yabat misir wa rab naatu kotar nahine na kufutih. ");
INSERT INTO aai_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mar sibisib auman Jesu riy tafanamaim bat ana bai’ufununayah isah remor na. ");
INSERT INTO aai_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Riy tafan bat remor nan ana bai’ufununayah hi’i’itin ana maramaim, hai bir ra’at hio, “Iti i wagabur mowan.” Hikirir hirerey. ");
INSERT INTO aai_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Baise Jesu mar ta’imon eaf eo, “Men kwanabir, ayu anan.” ");
INSERT INTO aai_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naatu Peter iya’afut eo, “Anababatun o na’at, basit ku’uwu riy tafan abat ana biya atit.” ");
INSERT INTO aai_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu eo, “Kuna.” Peter wa afe’en isure riy tafan bat in Jesu biyan tit. ");
INSERT INTO aai_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Baise kotar gagamin bababin naniyan bai, ana bir ra’at, basit busuruf unun re, re’ere auman Regah isan ererey eaf eo, “Regah kwiyawasu.” ");
INSERT INTO aai_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesu mar ta’imon eof nunuw uman bai iu eo, “A baitumatum men nikikimin, aisim kukakasiy.” ");
INSERT INTO aai_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Naatu hairi wa tafan hiyey ana veya kotar bababin nutanub. ");
INSERT INTO aai_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Imaibo bai’ufununayah wa tafan hima’am Jesu hibora’ah hio, “O i anababatun God Natun!” ");
INSERT INTO aai_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hirabon hina rewan rounane hitit naatu hin Genesaret, imaim hai wa hitain yen. ");
INSERT INTO aai_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Naatu nati’imaim sabuw Jesu hi’i’inan ana veya, tur hiyafar nati tafaram wanawanan bar merar gidigidihimaim, sabuw sawusawuwih etei hibow hina Jesu biyan hitit. ");
INSERT INTO aai_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Naatu ana faifuw taininawat butubunin isan hifefeyan, naatu sabuw iyab ana faifuwawat hibubutubun i etei hiyawas. ");
INSERT INTO aai_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pharisee naatu Ofafar Bai’obaiyenayah afa Jerusalemane hina Jesu hibatiy hio, ");
INSERT INTO aai_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aisim o a bai’ufununayah, bai’obaiyen ata a agir hibitit men tebobosiyasiyar, naatu umah sauwena’e ere kato auman bay te’au?” ");
INSERT INTO aai_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu iyafutih eo, “Bo kwa aisim God ana obaiyunen tur kwa’astu’ub uwatanah hai binanakwar kwabi’ufunun? ");
INSERT INTO aai_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anayabin God eo, ‘Hinat tamat kwanakakafiyih’ naatu ‘yait hinah tamah isan tur kakafin na’u’uwih i boro hina’asabun namorob.’ ");
INSERT INTO aai_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Baise kwa a bai’obaiyenamaim, orot ta boro hinat tamat isah iti na’atube inao, ‘Sawar iti o atabibaisi i God ana siwaramih ayai, imih boro men karam anibaisi.’ ");
INSERT INTO aai_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sinaf iti na’atube’eban hinat tamat kwakakafiyih? En! Baise, kwa asinaf iti’imaim God ana obaiyunen tur kwayara’iy kwa taiyuw abai’obaiyen kwabi’ufunun. ");
INSERT INTO aai_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wanawan rerekabih! Isaiah i tur anababatunamaim kwa isa eo kirum, ");
INSERT INTO aai_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iti sabuw ufurihiwat ayu tirursagiyu, baise hai notamaim i ef yok na’in tema’am. ");
INSERT INTO aai_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hai kwafiren ayu isou i wanawanan nikuwat; men basit orot hai notamaim ofafar hikikirum sabuw kwati’obaiyih hiti’ufunun.’” ");
INSERT INTO aai_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Imaibo Jesu rou’ay eaf ayuwih iuwih eo, “Abisa ao kwananutanub kwananowar naatu kwanasinaftobon yabin kwanab. ");
INSERT INTO aai_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Abisa orot awanamaim erur i men biyan ebobokarit, baise abisa orot awanamaim etitit i biyan ebobokarit.” ");
INSERT INTO aai_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Imaibo bai’ufununayah hina Jesu hibatiy, “Pharisee abisa i’o isan hai naniyan ibi’afiy iso’ob?” ");
INSERT INTO aai_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu iyafutih eo, “Ai menatan ayu Tamai maramaim men tatanum i boro an wairoron etei na’uy ra’ah. ");
INSERT INTO aai_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nati Pharisee biyahimaim kwanahaiw, anayabin i matah fim na’atube sabuw afa matah fim tibi’unawiyih, naatu boro etei hinan hub hinare.” ");
INSERT INTO aai_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter eo, “Oroubon anayabin kuo anowar.” ");
INSERT INTO aai_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naatu Jesu uwih eo, “Kwa auman boro’ika tur hai yabih men kwaso’obamih? ");
INSERT INTO aai_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Abistan awatamaim erur i en kabutitamaim etit naatu en uratane ere’er i kwaso’ob ai en? ");
INSERT INTO aai_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Baise abisa awatamaim etitit i dogor wanawananane etitit, naatu i boun orot biyan ebobokarit. ");
INSERT INTO aai_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Anayabin abisa orot dogoromaim etitit i not kakafin, sabuw rauw morob, turanah a’aawah ufuh na, baiwa’an kwanekwan, bain, baifufuwen, naatu yanuw koutabitabir. ");
INSERT INTO aai_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iti sawar i boun orot babin ebi’afiy, baise uma sauwena’e ere kato bay ina’aa boro men ni’afiyimih.” ");
INSERT INTO aai_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu nati efan ihamiy naatu in tafaram Taiya Sidon hairi wanawanahimaim bar merar afa imaim tit. ");
INSERT INTO aai_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaan babin nati’imaim ma’ama na Jesu isan rerey eo, “Regah, David uwan, kukabibiru; ayu natu babitai i demon kakafih wanawanan hirun hiforatoun hibonawiy bai’akir kakafin maiyow ebaib.” ");
INSERT INTO aai_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Baise Jesu men babin isan tur ta eo. Imih ana bai’ufununayah hina hifefeyan hio, “Babin ku’u sa’ab en, rerey ufut enan.” ");
INSERT INTO aai_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu iya’afutih eo, “Orot Natun nan i Israel sabuw sheep na’atube hikasiy hima’am akisih isah na.” ");
INSERT INTO aai_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Baise babin na Jesu nanamaim sun yowen eo, “Regah Jesu kwibaisu.” ");
INSERT INTO aai_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu eo, “Kek hai bay men karam boro tanarouw nare haru hina’aan.” ");
INSERT INTO aai_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Babin iya’afut eo, “Turobe Regah, baise bay momosarih tamah ana gemane tere’ere haru tebow te’aa.” ");
INSERT INTO aai_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Imaibo Jesu eo, “Babin o a baitumatum i ra’at kwanekwan, imih abisa kukokok i namatar.” Naatu nati ana maramaim natun babitai yawas. ");
INSERT INTO aai_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu efan nati ihamiy naatu Galilee harew kukuf rewarewan remor in, imaibo oyaw ta sisibinamaim yen in tafan mare. ");
INSERT INTO aai_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sabuw moumurih maiyow hai sabuw ah kafikafirih, matah fim, ah umah murumurubih, awah gugih naatu sawusawuwih afa moumurih maiyow auman hibow hina Jesu nanamaim hiya, naatu etei’imak iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Awah gugih tur hio, ah umah murubih higewasin, ah kafikafirih hibat hiremor, naatu matah fim higewasin hinuw sawar hi’itah isan, sabuw hifofofor men kafaita. Naatu Israel hai God wabin hibora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesu ana bai’ufununayah eaf hina biyan hitit naatu iuwih eo, “Ayu sabuw aitih abiyababan anayabin hina bairi ama’ama veya tounu sawar naatu boun hai efanamaim men abisa ta ema’am boro hina’aan. Ayu men akokok a murumurubih aniyafarih hai ubar hinan. Hinanan boro efamaim bayumih hinigagamat.” ");
INSERT INTO aai_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naatu ana bai’ufununayah hiya’afut hio, “Iti arar yan bay boro menamaim tanab nakaram iti rakit gagamin tana’afuwagiy?” ");
INSERT INTO aai_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu ibatiyih, “Kwa rafiy bai’ab kwabobotanen?” Hiya’afut hio, “Rafiy fafar etei seven, naatu siy gidigidih kwafur ta.” ");
INSERT INTO aai_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Basit Jesu sabuw iuwih me yan himarir. ");
INSERT INTO aai_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesu rafiy fafar seven naatu siy auman bow God ana a merar yiy, naatu imseseb ana bai’ufununayah itih hibow sabuw hifaramih. ");
INSERT INTO aai_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hi’aa etei yah iw, naatu bai’ufununayah bay sabuw hi’aa rebarebah hibiwanen sakasak etei seven hiwanfoten. ");
INSERT INTO aai_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sabuw etei 4000 na’atube bay hi’aa, kek baibin men auman hiyabamih. ");
INSERT INTO aai_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Imaibo Jesu sabuw iyafarih hinan ufunamaim, wa bai rabon na tafaram wabin Magadan imaim tit. ");
INSERT INTO aai_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee naatu Sadducees afa hikok i Jesu hitikubibiruw, imih hina hio, “Aki akokok ina’inan ta marane ini’obaiyi saise anaso’ob o i anababatun God ana fair ibai.” ");
INSERT INTO aai_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Baise Jesu iyafutih eo, “Rabirab mar ebiwuwun kwa’i’itin, boro kwanao, maras boro veya gewasin nayen. ");
INSERT INTO aai_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Naatu mar auman gagub niwuwun naatu turin nafufurum kwana’itin boro kwanao, boun boro nayar. Kwa i gagub akisin ana itinin kwaso’ob boro kwanao, baise abisa iti boun temamatar hai yabih men karam boro kwanaso’ob. ");
INSERT INTO aai_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mar iti boun ana sabuw hai fanasair naatu hai tafa’asar i ra’at, ina’inan isah tinunuwet. En! Baise ina’inan ta’imon ebi’obaiyi i Jonah ana i’inan.” Basit Jesu sabuw nati’imaim ihamiyih hima i sa’ab in. ");
INSERT INTO aai_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesu ana bai’ufununayah harew kukuf hirabon hina rewan rounane hiyey ana maramaim, nuhih taseb hio, “It rafiy men ta tabai auman tarabonamih.” ");
INSERT INTO aai_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu iten ya’ih eo, “Mata to niwa’an kwanakaifi gewas, Pharisee naatu Sadducee hai yeast isan.” ");
INSERT INTO aai_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naatu bai’ufununayah taiyuwih hibabatiy hio, “It rafiy baina’e tanan isan ma eo?” ");
INSERT INTO aai_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu abisa isan hio i naniyan bai, imih ibatiyih, “Aisim rafiy ta baina’e tanan isan taiyuw kwakasiy kwama kwabibabatiyi? Kwa a baitumatum i kikimin anababatun. ");
INSERT INTO aai_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A not boro’ika kwarisin ema’am. Sabuw etei 5, 000 rafiy fafar faive’imo imaim abituwih isan nuhi bur? naatu kwaso’ob sakasak etei bai’ab kwaiwanfoten? ");
INSERT INTO aai_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na’atube rafiy sevenimo sabuw 4, 000 abituwih sakasak etei bai’ab kwaiwanfoten? ");
INSERT INTO aai_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aisim a not boro’ika hikwaris ayu rafiy isan ao kwararouw, en baise Pharisee naatu Sadducee hai yeast isan kwanakaifi gewasomih ao.” ");
INSERT INTO aai_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Imaibo bai’ufununayah naniyan hibai, Jesu i men yeast maiyow rafiy wanawanan teyai’iyai isan matah toniwa’anamih, baise Pharisee naatu Sadducee hai bai’obaiyen isan matah toniwa’an. ");
INSERT INTO aai_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu na Caesarea Philipi wanawananamaim titit ana veya, ana bai’ufununayah ibatiyih, “Sabuw Orot Natun isan mi’itube teo kwanonowar?” ");
INSERT INTO aai_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hiya’afut hio, “Sabuw afa i teo John Baptist, afa Elijah, afa i Jeremiah, naatu afa teo i dinab orot ta.” ");
INSERT INTO aai_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ana bai’ufununayah ibatiyih eo, “Bo kwa ayu isau i mi’itube kwa’o?” ");
INSERT INTO aai_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter iya’afut eo, “O i God Tafa eof nowah God ma’ama wanatowanin Natun.” ");
INSERT INTO aai_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu iya’afut eo, “Simon, Jonah natun abigegewasini. Anayabin nati tur anababatun i men orot ta biyanane na irererebamih, baise marane Tamai mutufor o it. ");
INSERT INTO aai_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Imih a tur ao’owen o i Peter. Iti kabay tafanamaim ayu boro au ekaleisia anawowab. Naatu morob ana fair boro men kafa’imo natafufur nare’emih. ");
INSERT INTO aai_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ayu boro mar ana tufatan anit; abisa iti tafaramamaim kututufatan, maramaim boro ana tufatan. Naatu abisa iti tafaramamaim kururufam, maramaim boro ana rufam.” ");
INSERT INTO aai_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Imaibo Jesu ana bai’ufununayah awah bofot eo, “Ayu i Tafau hi’of nowah imih men yait ta ana tur kwana’owenamih.” ");
INSERT INTO aai_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nati ana veya’amaim Jesu busuruf ana bai’ufununayah isah tur mutufor iuwih eo, “Ayu i anan Jerusalem ana tit biyababan gagamin maiyow boro anab, orot ai’in biyahine, Firis ukwarih naatu Ofafar Bai’obaiyenayah biyahine, hina’asabunu ana morob. Baise veya tounu ufunamaim morobone boro anamisir maiye.” ");
INSERT INTO aai_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter bai hin nabinamaim eo, “Regah, iti na’atube men akokok isa namatar”. ");
INSERT INTO aai_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesu tatabir Peter kwarar iu, “Au’uf kwen, Satan! O i kabay kiru nou kuyayare, anayabin o a not i men God enotanot na’atube kunotanotamih. O i orot babin hai notabe kunotanot.” ");
INSERT INTO aai_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Imaibo Jesu tatabir ana bai’ufununayah isah eo, “O yait inakok ayu airit namih, taiyuw ina kwahiri a onaf ina’abar ini’ufnunu airit tanan. ");
INSERT INTO aai_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anayabin orot yait taiyuwin ana yawas isan ebowabow boro nikasiy. Baise orot yait ana yawas ayu isau ebi’inuw boro natita’ur. ");
INSERT INTO aai_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tafaram wanawanan sawar tutufin etei ibai aur karam, baise inamomorob ana veya ana gewasin boro inab? En anababatun. Boro men kafa’imo nati sawaramaim a yawas inatubun inab maiye’emih. ");
INSERT INTO aai_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anayabin Orot Natun i Tamah ana fair ana bonamanamarinamaim nan, ana tounamatar kakafiyih bairi, imaibo nati ana maramaim i boro orot babin hibowabow ana fofoninamaim hai baiyan nitih. ");
INSERT INTO aai_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anababatun a tur ao’owen, sabuw afa iti kwama tur kwanonowar boro morobo’e kwanama’am Orot Natun ni’aiwob maramaim nanan kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Veya etei six sasawar ufunamaim Peter naatu James tain John hairi Jesu buwih bairi akisimo nawiyih hiyen hin oyaw gagamin tafantoro’ot hitit. ");
INSERT INTO aai_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naatu nati’imaim matah yan hi’itin Jesu ana yumat botabir, ana itinin i veya’abe matar, ana faifuw i hikwes anababatun marakaw ta na’atube. ");
INSERT INTO aai_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Imaibo, Moses Elijah hairi hitit Jesu bairi hio ana bai’ufununayah hi’itih. ");
INSERT INTO aai_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter Jesu isan eo, “Regah, gewasin aki iti ama’ama, o ina kokok na’at ayu boro sis tounu ana wowab ta o isa, ta Moses isan, naatu ta Elijah isan.” ");
INSERT INTO aai_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Baise iti na’at bat eo auman, sakuk ana marakawin auman na tar gabuwih, naatu sakuk wanawanan orot fanan hinowar eo, “Iti kek i ayu Natu, au yabow anababatun, i isan ayu abiyasisir, tain kwanarub nao’o kwananowar.” ");
INSERT INTO aai_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bai’ufununayah iti orot fanawat hinonowar ana maramaim hai bir ra’at yumatah au babe me yan hira’iy. ");
INSERT INTO aai_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Baise Jesu na butubunih eo, “Kwamisir, men kwanabirumih.” ");
INSERT INTO aai_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Imaibo nah hitara’ah hinunuw ra’at men yait ta hi’itin, baise Jesu akisinamo batabat hi’itin. ");
INSERT INTO aai_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oyaw wanane hire hinan basit Jesu awah bofot eo, “Abisa oyaw wan kwa’i’itin men yait ta ana tur kwana’owen. Kwanama, Orot Natun morobone namisiribo.” ");
INSERT INTO aai_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naatu bai’ufununayah Jesu hibatiy hio, “Bo aisim Ofafar Bai’obaiyenayah teo Elijah i boro mat nan.” ");
INSERT INTO aai_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu iyafutih eo, “Tur anababatun. Elijah i boro mat nan sawar etei nayabuna. ");
INSERT INTO aai_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Baise a tur a’owen, Elijah i na titaka, baise sabuw men hi’inan, imih hai kokomaim sawar kakafih isan hisinaf. Ef nati ta’imon Orot Natun boro na’atube isan hinasinaf umahimaim ni’akir.” ");
INSERT INTO aai_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Imaibo bai’ufununayah naniyan hibai, Jesu i John Baptist isan hai tur eo’owen. ");
INSERT INTO aai_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hire hina sabuw rau’ay gagamin biyah hititit ana maramaim, orot ta na Jesu nanamaim sun yowen ");
INSERT INTO aai_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","eo, “Regah au kek kwiwanbaban, au kek i sawow kakafin bai ebimamayay, mar etei en wairaf wan eyey, naatu harew yan ere’er. ");
INSERT INTO aai_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ayu abai ana a bai’ufununayah isah, baise i men karam boro hitiyawas.” ");
INSERT INTO aai_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu eawar foten eo, “Kwa sabuw isa i baitumatum en naatu a ef i kwasa’ir. Kwanotanot ayu boro bairi maninaka tanama? Naatu kwanotanot abit boro maninaka ana’abar bairi tanan? Kek kwabai kwana a’itin.” ");
INSERT INTO aai_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu demon kakafin kwarar tatab naatu kek ihamiy bihir tit. Nati ana maramaim kek mar ta’imon yawas. ");
INSERT INTO aai_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Imaibo Jesu ana bai’ufununayah hina akisinamo biyan hitit hibatiy hio, “Aisim aki demon kakafin men anun tit?” ");
INSERT INTO aai_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu iuwih eo, “Anayabin, kwa a baitumatum i kikimin maiyow. Anababatun a tur ao’owen, a baitumatum iti ai momor ro’on na’atube nama’am na’at, iti oyaw isan boro kwanao, ‘Iti’imaim kwen ni’imaim kubat.’ Karam boro namatar, boro men abisa ta isa nafokaramih. ");
INSERT INTO aai_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sawar iti na’atube i yoyoban naatu yoharamaim boro hinamatar men abisa ta’amaim.” ");
INSERT INTO aai_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesu ana bai’ufununayah hina Galilee hibita’imon ana maramaim iuwih eo, “Orot Natun boro baban hinao hinab gawan sabuw umahimaim hinayai. ");
INSERT INTO aai_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nati sabuw boro hina’asabun namorob, veya tounu ufunamaim boro morobone na misir maiye.” Ana bai’ufununayah hai yababan ra’at. ");
INSERT INTO aai_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesu ana bai’ufununayah bairi hina Capernaum hititit ana maramaim, Tafaror Bar ana kabay o’onayah hina Peter hibatiy hio, “O a bai’obaiyenayan Tafaror Bar isan kabay ebibaiyan?” ");
INSERT INTO aai_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter iyafutih eo, “Jesu i Tafaror Bar isan kabay ebibaiyan.” Peter na bar wanawanan rur ana maramaim Jesu i wan awan tara’ah eo, “Peter o kunotanot sawar etitit naatu erur na’atube orot ta’ita’imon ana kabay aiwob isan i yait ebibaiyan, bar matuwan o nanawan sabuw?” ");
INSERT INTO aai_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter iya’afut eo, “Nanawan sabuw.” Iti na’atube eo imaibo Jesu eo, “Tur anababatun bar matuwan i asir tema’am kwanekwan. ");
INSERT INTO aai_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Baise men basit sabuw isah tanasinaf kakaf, kabay o’onayah yah naso’ar, imih inan harew kukufamaim initokar siy wan inatatain awan inabohai’i kabay inab inan airit isat inibaiyan.” ");
INSERT INTO aai_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nati ana maramaim bai’ufununayah hina Jesu biyan hitit hibatiy hio, “Mar ana aiwobomaim yait i orot gagamin?” ");
INSERT INTO aai_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu kek kikimin eaf na nahimaim bat. ");
INSERT INTO aai_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Imaibo eo, “Anababatun a tur ao’owen, o yait ayawas men inabotabir inan iti kek gidigidih na’atube mar ana aiwobomaim boro men inarun. ");
INSERT INTO aai_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isan imih orot yait taiyuwin yare iti kek kikiminabe emamatar mar ana aiwobomaim i orot gagamin. ");
INSERT INTO aai_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Naatu orot yait kek kikimin iti na’atube ayu wabu’umaim ana merar eyiy, i ayu au merar eyiy. ");
INSERT INTO aai_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Baise orot yait iti kek kikimin ayu bitutumu eoraraf in bowabow kakafin esisinaf, gewasin nati orot i boro sikan aumor hina’utan taiy yan hinitaiy nare na’atomatom namorob. ");
INSERT INTO aai_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Tafaram i kakafin wanawanan run, imih nati sawaramaim sabuw bonawiyih bowabow kakafin tisisinaf. Sawar kakafih nati na’atube i boro hinamatar, baise orot yait biyanamaim iti sawar temamatar i boro kakafin anababatun nab. ");
INSERT INTO aai_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","O yait uma o a nabonawiy kakafin inasisinaf na’at, ku’afuw kwisaroun, saise a uma duboduboh inan ma’ama wanatowan inarun. Men basit a uma hai ubaramaim o biya etei itan wairaf wan itayen ta’arahi. ");
INSERT INTO aai_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naatu mata nuw kwanekwan kakafin kusisinaf, kukubai kwisaroun. Mata rounawat saise inan ma’ama wanatowan inarun, men basit mata ta’imon ana ubaramaim mata rou’abaka inan wairaf wan inayen na’arahi. ");
INSERT INTO aai_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Abisa kusisinaf i inaso’ob men kek gidigidih inanuw furuwih, a tur ao’owen anayabin kek gidigidih hai tounamatar mar etei maramaim Tamai nan tebatabat. ");
INSERT INTO aai_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Orot Natun nan ana’an i sabuw kasikasiyih bow baiyawasih isan na. ");
INSERT INTO aai_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Orot ana bobaituw 100 hitama’am ta’imon takakasiy isan a not i mi’itube kwanotanot? Ana bobaituw 99 tihamiyen oyaw wan hitama, i tare tan ta’imon kakasiy tanuwih ai en? ");
INSERT INTO aai_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Naatu ana bobaituw tatita’ur tabaib ana maramaim, a tur ao’owen ana for ta’imon isan boro tiyasisir men kafaita, men 99 isah ebiyasisir na’atube anayabin i men hikasiy. ");
INSERT INTO aai_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Imih ef ta’imon nati na’atube Tamat maramaim men ekokok boro ana kek kikimin ta nakasiy. ");
INSERT INTO aai_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“O taituwa ta wanawanamaim isa bowabow kakafin nasisinaf na’at wa’iwa’iramaim inan biyan ana kakafin matanamaim ini’obaiy. Inao fana nanonowar na’at i boro airi kwanitafen tutur. ");
INSERT INTO aai_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Baise inao men nanonowar, orot ta’imon o rou’ab inabuwih bairi kwanan, saise o abisa’awat inao orot rou’ab boro sif hinaruboun. Buk Atamaninamaim hio na’atube. ");
INSERT INTO aai_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Baise hinao men nanonowar na’at, basit ekaleisia matahimaim kwanakurereb kwanao, naatu ekaleisia hinao men nanowar na’at, basit kwanihamiy eteni orot na’atube nama o tax o’onayan na’atube nama. ");
INSERT INTO aai_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Anababatun a tur ao’owen, abisa iti tafaramamaim ku’a’uh maramaim boro ana’uh. Naatu abisa iti tafaramamaim kururufam maramaim boro anarufam. ");
INSERT INTO aai_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Iban ao maiye, orot rou’ab iti tafaramamaim abisa isan hairi hibasit tefefeyan, Tamai maramaim boro isah nasinaf. ");
INSERT INTO aai_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Orot rou’ab o tounu ayu wabu’umaim tekuku’ay, ayu i nati wanawanahimaim bairi.” ");
INSERT INTO aai_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Imaibo Peter na Jesu biyan tit ibatiy, “Regah, ayu taiu isau mar etei bowabow kakafih nasisinaf mar boro bai’ab ana kakafih ana notawiyen? Ana kakafih ana notawiyen nayen seven nanatabir?” ");
INSERT INTO aai_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu iya’afut eo, “Men seven, baise mar etei 70 tafanamaim seven auman. ");
INSERT INTO aai_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Anayabin aiwob maramaim ana itinin i aiwob orot ana akir wairafih hai bowabow nunutitiy na’atube. ");
INSERT INTO aai_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nuteteyan ana bowabow busuruf ana veya aiwob orot kabay million na’atube orot ta bai ma bowabow hibai hina hirun. ");
INSERT INTO aai_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naatu nati akir wairafin aiwob orot ana kabay wan yin isan aurin men karam. Imih aiwob orot iuwih orot aawan, natunatun naatu ana sawar etei hitabow hitan sabuw afa hitatobon hai akir wairafihimih hitabow, saise nati kabayamaim aiwob orot ana kabay wan tab isan eo. ");
INSERT INTO aai_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Baise akir wairafin aiwob orot nanamaim sun yowen fefeyan eo, ‘Regah a kokok yate nanub naatu ayu boro ana sinaftobon a sawar etei wah anayow anit.’ ");
INSERT INTO aai_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aiwob orot ana akir wairafin itin yan baban naatu ana kabay wan yin isan auman ibagun naatu iu tit ana ubar in. ");
INSERT INTO aai_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Baise nati akir wairafin tit in naatu ana kabay bai’abamo bowayan turan biyanamaim bai ma’am biyan tit, eof sikan bai eo, ‘Au kabay o biya inu’in boun wan inay initu.’ ");
INSERT INTO aai_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Bow turan orot nanamaim sun yowen ifefeyan eo, ‘Yate nanub mar kafai ayu boro a kabay wan anay anit.’ ");
INSERT INTO aai_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Baise orot men kok boro turan fanan tanowar, imih bai furisiman itih hibai hin dibur bar hiya’ariy. Naatu orot turan iu, ‘Iti’imaim inama au kabay wan inay initu imaibo inatit.’ ");
INSERT INTO aai_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Akir wairafih afa iti sawar matar hi’itin men hiyasisir, imih hin abisa’awat himamatar isan aiwob orot ana tur hiowen. ");
INSERT INTO aai_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Imaibo aiwob orot ana akir wairafin eaf na iu eo, ‘O i anababatun orot kakaf. Ayu au kabay gagamin maiyow o biyamaim ma’am i asafam, anayabin ayu ifefeyanu. ");
INSERT INTO aai_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gewasin bow tura itakabibir o akakabibiri na’atube.’ ");
INSERT INTO aai_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aiwob orot yan so’ar tatabir ana dibur kaifenayah iuwih hifatum dibur hiya’ariy naatu iu, ‘Iti’imaim inama’am au kabay wan inay initu imaibo inatit.’” ");
INSERT INTO aai_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ef ta’imon ayu Tamai maramaim kwa ta’ita’imon isa boro iti na’atube nasinaf, o yait taituwa ana kakafin men dogor tutufin etei inanotanotawiy na’at.” ");
INSERT INTO aai_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu iti tur eo in sawar ufunamaim, Galilee ihamiy in Judea wanawananamaim tit, Jordan harew rewan rounane. ");
INSERT INTO aai_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sabuw rou’ay gagamin hi’ufunun hinan etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ofafar bai’obaiyenayah hina Jesu an hitain hibatiy hio, “Orot aawan nasisinaf kakaf isan karam boro nakwahir, naatu na kwakwahir i ofafar e’astu’ub ai en?” ");
INSERT INTO aai_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu iyafutih eo, “Bo aneika God orot babin hairi sinafih himamatar isan Buk Atamaninamaim hikirum inu’in kwaiyab kwaitin?” ");
INSERT INTO aai_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tur an i nati imih God eo, “Orot boro hinah tamah nihamiyih, aawan hairi hinita’imon biyah rou’ab, baise hairi hinita’imon biyah ta’imon namatar. ");
INSERT INTO aai_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Imih hairi men biyah rou’ab baise ta’imon. Abisa God bita’imon men yait ta natarbounih.” ");
INSERT INTO aai_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ofafar bai’obaiyenayah hibatiy maiye hio, “Bo aisim Moses ana ofafar ta kirum eo, ‘Orot aawan kwahirinamih, kwahikwahiren ana fef nakirum babin nitin nab nan.’” ");
INSERT INTO aai_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu iyafutih eo, “Kwa a tafa’asaramaim, imih Moses ibasit baibin kwahiren isan eo, baise aneika i men iti na’atube ma’ama’amih. ");
INSERT INTO aai_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Anababatun a tur ao’owen, orot yait aawan anayabin en asir nakwahir, naatu nare babin ta ufun nan hairi hinibiwa’an i bowabow kakafin esisinaf.” ");
INSERT INTO aai_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naatu Jesu ana bai’ufununayah hibatiy hio, “Orot babin hairi hai ma kakaf nati na’atube tama’am, gewasin men hitatabin, monok baibitar hitama.” ");
INSERT INTO aai_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Baise Jesu iuwih eo, “Men orot etei boro iti bai’obaiyen hini’ufununimih, baise iyabowat God rurubinihiwat boro hini’ufunun. ");
INSERT INTO aai_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ef hai yabih moumurih na’in, imih orot men tetatabinamih, afa men tetatabin anayabin afa i yahoh fim, orot afa i yahoh tebowabow, naatu afa i God ana bowabow isan tenotanot, imih men tetatabin. Orot yait iti bai’obaiyen bainamih nakok, basit nab i akisin.” ");
INSERT INTO aai_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sabuw afa kek gidigidih Jesu uman tafah tayara’aten yoyoban isan hibow hinan, ana bai’ufununayah sabuw hikwararih hiotanih. ");
INSERT INTO aai_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Baise Jesu eo, “Kek kwaihamiyih tena biyau tetit, men kwana’otanih. Anayabin sabuw iyab iti kek hai baitumatum na’atube God ana aiwobomaim tema’am.” ");
INSERT INTO aai_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Basit Jesu kek tafah yara’aten isah yoyoban sawar, imaibo ihamiyih in. ");
INSERT INTO aai_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana veya ta orot ta na Jesu ibatiy eo, “Bai’obaiyenayan, sawar menatan gewasin anasinaf boro ma’ama wanatowan anab?” ");
INSERT INTO aai_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu orot iya’afut eo, “Aisim sawar gewasin isan ayu kubibatiyu? God akisinamo i orot gewasin. O inakok ma’ama wanatowan bain ma’amih, basit ofafar ini’ufunun.” ");
INSERT INTO aai_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Orot Jesu ibatiy eo, “Ofafar i menatan?” Jesu iya’afut eo, “Men tura ina’asabun, turanah a’aawah bairi men kwaniwa’an, men inabain, men orot babin afa isah inayanuw, ");
INSERT INTO aai_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hinat tamat inakakafiyih naatu o taiyuw isa kubiyabow na’atube taituwa isah iniyabow.” ");
INSERT INTO aai_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Orot iya’afut eo, “Iti ofafar etei asinaf sawar, abisa’awat tema’am boro anasinaf?” ");
INSERT INTO aai_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu iu eo, “O inakok a yawas baigewasinamih. Basit inan a sawar etei sabuw hai sawaramih initih hinatobon, naatu kabay inab yababan wairafih initih. O inan ini’ufununu, nati na’atube inasinaf maramaim o boro isa sawar nakaram.” ");
INSERT INTO aai_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Orot iti tur nonowar ana maramaim yababan auman ana ubar in, anayabin i aurin sawar etei karam. ");
INSERT INTO aai_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naatu Jesu tatabir ana bai’ufununayah iuwih eo, “Tur anababatun au’uwi. Orot sawar wairafin i men karam mar ana aiwobomaim narun, boro isan nafokar. ");
INSERT INTO aai_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Au’uwi maiye camel sou’umaim sorabon isan i fokar, anayabin koun butun gagamin. Ef ta’imon nati na’atube orot sawar wairafin i men karam mar ana aiwobomaim narun, boro isan nafokar.” ");
INSERT INTO aai_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bai’ufununayah iti tur hinonowar ana maramaim hifofofor men kafaita. Naatu hio, “Yait i boro yawas nab?” ");
INSERT INTO aai_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu mutufor nuw itih eo, “Sawar etei orot isah i hifokar, baise God isan sawar etei i men fokarihimih.” ");
INSERT INTO aai_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Basit Peter misir eo, “Kwi’iti, aki ai sawar etei ai hamiyen o abi’ufununi abisa boro anab?” ");
INSERT INTO aai_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu iuwih eo, “Anababatun a tur ao’owen. Tafaram nabobotabir ana maramaim, Orot Natun boro ana urama’ama bonamanamarinamaim namare. Naatu kwa ayu au bai’ufununayah na 12 auman boro urama’amamaim kwanamare Israel sabuw hai big etei 12 kwanakaifih kwanama. ");
INSERT INTO aai_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sabuw iyab ayu wabu’umaim hai bar hai me, taituwah, ruburubuh, hinahinah tamahinah hihamiyen ayu tibi’ufununu boro hai yawas tafan ana ya’abar anitih. Naatu yawas wanatowan auman anitih hinab. ");
INSERT INTO aai_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Baise sabuw iyab boun wan hi’iyon tenan boro hinan hini’uf naatu sabuw iyab hi’uf tenan boro hinan wan hini’iyon. Imih sabuw iyab iti tafaramamaim orot gagamih tema’am maramaim boro aurih efan en. Baise sabuw iyab iti tafaramamaim God isan tibi’akir maramaim boro orot gagamih hinama.” ");
INSERT INTO aai_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“God nabi’aiwob ana maramaim i boro iti na’atube. Ana veya ta orot masaw matuwan, sabuw afa tobon ana masawamaim bowamih tit na. ");
INSERT INTO aai_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bowayah bow naatu veya ta’imon ana baiyan isan bairi hio hibibasit ufunamaim iyafarih hin grape ana masawamaim hibow. ");
INSERT INTO aai_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nine korok na’atube tit maiye na ahar efanamaim. Orot afa hai bowabow en asir hibatabat itih. ");
INSERT INTO aai_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Basit eo, ‘Igewasin kwa auman boro kwanan au masawamaim kwanabow, naatu kwa a baiyan boro etei anafofonin anit.’ Naatu bowamih hin. ");
INSERT INTO aai_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Auyit naatu three korok hairi tit inan i bowabow ta’imon sinaf sabuw asir hibatabat itih naatu uwih hin ana masaw hibow. ");
INSERT INTO aai_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naatu veya re five korok na’atube, orot tit na maiye, ahar efanamaim titit. Sabuw afa’abo hibatabat itih eo, ‘Kwa aisim asir kwabatabat veya re?’ ");
INSERT INTO aai_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Hiya’afut hio, ‘Men yait ta tubuni.’ “Basit orot eo, ‘Kwanan au masawamaim kwabow.’ Naatu ana masaw bowamih hin. ");
INSERT INTO aai_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Veya re birabirab auman, masaw matuwan ana orot ukwarin eaf na iu, ‘Sabuw ina’afih hinan hai baiyan initih, uf hinan hai baiyan wan initih naatu wan hinan uf initih,’ basit eafih hina hirun sawar. ");
INSERT INTO aai_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Imaibo orot iyab five korok hibusuruf hibowabow, hai baiyan itih, veya ta’imon ana fofonin. ");
INSERT INTO aai_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Orot mat hina hibowabow, hai biyan bainamih hinan i hinotanot boro hai baiyan gagamin hitab, baise i auman baiyan ta’imon hibai, veya ta’imon ana fofonin. ");
INSERT INTO aai_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Hai kabay hibai sawar hitit hibat. Basit higam masaw matuwan hiu, ");
INSERT INTO aai_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Iti sabuw i veya re’er auman hina men manin hibag, baise aki bairi ai baiyan ta’imon iti. Aki ai baiyan i boro gagamin atab, anayabin aki mar auman ana a bow in veya re.’ ");
INSERT INTO aai_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Masaw matuwan misir orot ta isan eo, ‘Au begon inaso’ob. Ayu men asinaf kakafemih. Anayabin kwa i kwaibasit veya ta’imon ana baiyan isan, imih kwabow in veya re ana fofonin ait. ");
INSERT INTO aai_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Abisa abit i kwabai a ubar kwan. Iti oro’orot uf hinan i ayu arubinih hina, imih hai kabay abitih i kwa bairi a baiyan ta’imon. ");
INSERT INTO aai_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Anayabin ayu au sawar, au kokomaim au kabay mi’itube anim, ayu akisu. Men orot babin ta isan anasisinaf gewas isan ya naso’aramih.’” ");
INSERT INTO aai_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Naatu Jesu ana tur yomaninamaim eo, “Sabuw iyab iti tafaramamaim orot gagamih tema’am boro maramaim aurih efan en. Baise sabuw iyab iti tafaramamaim God isan tibi’akir maramaim boro orot gagamih hinama.” ");
INSERT INTO aai_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu ana bai’ufununayah bairi au Jerusalem hinan efamaim buwih nabin akisihimo hai tur eowen eo, ");
INSERT INTO aai_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tanan Jerusalemamaim Orot Natun boro sabuw hinab. Firis ukwarih naatu Ofafar Bai’obaiyenayah hinitih rabin asabunin morobomih hinao. ");
INSERT INTO aai_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Naatu hinab Eteni Sabuw hinitih, hina’u hi’i’iyab hinarab hina’onaf namorob. Baise veya baitonin ufunamaim boro namisir maiye.” ");
INSERT INTO aai_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Imaibo Zebedee aawan natunatun rou’ab bairi Jesu baifefeyanimih hina nanamaim sun yowen natunatun rou’ab isah fefeyan baibaisinamih eo. ");
INSERT INTO aai_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu ibatiy eo, “Abisa kukokok?” Babin iya’afut eo, “Ayu akokok inao matanu o ina bi’aiwob ana maramaim, ayu natunatu hairi sisib roun roun hinamare bairi kwani’aiwob.” ");
INSERT INTO aai_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu iya’afut eo, “Kwa men kwaso’ob abisa isan kwafefeyanu. Karam ayu au harew ana tomatom turin boro kwanatom?” Tufuturan hairi hiya’afut hio, “Aki karam.” ");
INSERT INTO aai_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu iuwih eo, “Ayu harew atomatom boro kwanatom, baise ta au asukwafune mare ta au beyawane mare. Ayu men karam boro anarubin. Nati efan i sabuw iyab ayu Tamai isah bobogaigiwas i hai efan.” ");
INSERT INTO aai_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bai’ufununayah etei ten iti tur hinonowar orot tufuturan hairi isan yah so’ar. ");
INSERT INTO aai_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Baise Jesu etei eaf ayuwih i’uwih eo, “Kwanaso’ob orot iyab Eteni Sabuw tekakaifih i God men tebitumitum, imih i taiyuwih hai fairamaim sabuw tibiruwih fanah tebai tibi’ufununih. ");
INSERT INTO aai_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Baise kwa wanawanamaim men iti na’atube nama’amih. O yait inakok bai’ukwarinamih, basit taituwa isah inabow ini’akir. ");
INSERT INTO aai_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Naatu O yait inakok wan bai’iyon bai’ukwarinamih, basit taituwa isah ini’akir. ");
INSERT INTO aai_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iti na’atube kwanasinaf, anayabin Orot Natun nan i men sabuw isan bowamih namih, baise nabow ana yawas sabuw isah ni’inuw saise i ana yawasamaim sabuw niyawasih.” ");
INSERT INTO aai_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu ana bai’ufununayah bairi tafaram Jericho hitumar hitit, basit sabuw rou’ay gagamin na’in hitit hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hinan efamaim orot rou’ab matah fim hima’am Jesu ana tur hinowar, basit hi’af Jesu hifefeyan hio, “David uwan kwiwanbabani.” ");
INSERT INTO aai_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sabuw rou’ay gagamin na’in hinan orot rou’ab hikwararih awah fotamih hi’uwih, baise hairi awah aumetawat hi’af hio, “Regah David uwan kwiwanbabani.” ");
INSERT INTO aai_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu inan bat naatu hairi eafih hina ibatiyih eo, “Kwakokok abisa isa anasinaf?” ");
INSERT INTO aai_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Orot rou’ab hiya’afut hio, “Regah aki akokok matai hinigewasin ananuw.” ");
INSERT INTO aai_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu hairi itih iyababan basit matah bobotobonen ana maramaim mar ta’imonamo hairi matah higewasin himisir Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesu ana bai’ufununayah bairi au Jerusalem hirun hinan, hina bar merar ta wabin Bethage hitit, Olive Oyawemaim, Jesu ana bai’ufununayah rou’ab wan iyunih ");
INSERT INTO aai_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eo, “Kwanan bar merar nati namaim kwanatitit boro donkey hi’utan ebatabat kwana’itin naatu donkey boubun auman sisibinamaim ebatabat. Hairi kwanarufamen kwanabow kwanan. ");
INSERT INTO aai_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Orot ta nati’imaim nabibatiyi ana tur kwana’owen, ‘Regah ekokok naatu boro nihamiyen kwanabow kwanan.’ Baise ana tur kwana’owen boro niyafarih hinamatabir maiye.” ");
INSERT INTO aai_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iti sawar himamatar abisa God ana dinab orot eo kikirum ina i turobe. ");
INSERT INTO aai_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem sabuw hai tur kwana’owen, a aiwob enan kwa’itin, taiyuwin yare donkey afe’en mara’at enan, ana donkey boubun tafanamaim mara’at enan.” ");
INSERT INTO aai_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Basit Jesu ana bai’ufununayah eo baimanih na’at hin hisinaf. ");
INSERT INTO aai_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donkey hibai hina hai faifuw tafah hibosairen hiyabar afa rabod rourih hi’afuw ef yan hiyabar. ");
INSERT INTO aai_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sabuw rou’ay gagamin na’in hai faifuw hibosairen hiyabar afa ai raurih hi’afuw hiyabar. ");
INSERT INTO aai_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sabuw Jesu nanane hinan, naatu ufunane hinan fanah sib hiwow hio, “David natun tanabora’ara’ah God nigegewasin Regah wabinamaim enan God tanabora’ara’ah!” ");
INSERT INTO aai_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesu na Jerusalem rur, kawasa ra’at uruw giririf retenafut, sabuw hibatebat hio, “Iti orot yait?” ");
INSERT INTO aai_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rou’ay gagamin hiyafutih hio, “God ana dinab orot wabin Jesu, Galilee wanawananamaim tafaram Nazareth orot.” ");
INSERT INTO aai_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Naatu Jesu na Tafaror Bar run. Sabuw iyab nati hima hai sawar hitotobon rauw nunih hai urama’ama, hai gemogem bora’aten, kabay hisuwa hire, urama’ama afe’eh hima mamu imak hitotobon bow israuwen ufun hitit. ");
INSERT INTO aai_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naatu iuwih eo, “Buk Atamaninamaim God eo hikikirum i iti na’atube eo, ‘Ayu au Tafaror Bar i yoyoban ana bar,’ baise kwa abisa kwasisinaf i kwabotabir bainowah hai watu matar.” ");
INSERT INTO aai_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sabuw matah fim naatu ah umah kakafih hina Tafaror Bar hirun Jesu etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Firis ukwarih naatu Ofafar Bai’obaiyenayah Jesu sawar gewasih sisinaf hi’itin yah so’ar. Kek auman Tafaror Bar wanawanan fanah sib Jesu hibora’ara’ah hio, “Orokaiwa David natun, ensairen.” ");
INSERT INTO aai_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesu hiu, “Iti kek teo kunonowar?” Jesu iyafutih eo, “Anonowar. Buk Atamaninamaim hikikirum kwaiyab kwa’itin, mi’itube hikirum? ‘Kek gidigidih naatu kek sosof ini’obaiyih merarayow gewasin anababatun baitinin isan.’” ");
INSERT INTO aai_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naatu nati’imaim ihamiyih hima i tit in Bethany bar merar imaim mar fo in. ");
INSERT INTO aai_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mar auman Jesu au merar gagamin matabir inan, basit bayumih morob. ");
INSERT INTO aai_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naatu ef rewanamaim ai fafou batabat itin, basit na ai an tit, baise men ro’on ta itin, raurinawat. Basit ai isan eo, “O i boro men iniw.” Mar ta’imonamo ai fenem. ");
INSERT INTO aai_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana bai’ufununayah hi’itin hifofor men kafaita, naatu hio, “Ai fafou mi’itube’emih mar ta’imon fenem?” ");
INSERT INTO aai_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu iyafutih eo, “Anababatun a tur ao’owen. Men erekasiy auman kwanasinafumih, baise kwanitumatum. Karam abis iti boun ai fafou isan asisinaf boro kwanasinaf namatar. Baise men iti akisin. Karam oyaw isan kwanao, kumisir kwen riy yan kubat boro namatar. ");
INSERT INTO aai_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Initumatum abisa isan kuyoyoban boro inab.” ");
INSERT INTO aai_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu matabir maiye Tafaror Baremaim run bat bi’obaibiyih. Basit Firis ukwarih naatu Jew hai orot ukwarih hina Jesu biyan hitit hibatiy hio, “O yait fair it iti sawar kusisinaf, naatu yait ibasit ina kubowabow?” ");
INSERT INTO aai_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu iyafutih eo, “Ayu auman au baibat ta’imon kwa anibatiyi kwanao ananowar, imaibo ayu boro anao kwananowar, ayu fair menamaim abai abowabow. ");
INSERT INTO aai_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John ana fair menane bai sabuw bapataito itih Godane bai, ai orot maiyow biyahine bai?” Hai kasiy ra’at taiyuwih hibabatiyih hio, “Mi’itube tanao? Godane tanao’o i boro nao bo aisim John men kwaitumitum. ");
INSERT INTO aai_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Baise it orot biyanane fair bain tanao, sabuw isah tabirubir anayabin sabuw etei tebitumatum John i God ana dinab orot ta.” ");
INSERT INTO aai_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Imih sabuw Jesu isan hiya’afut hio, “Aki men aso’ob.” Naatu Jesu iuwih eo, “Ayu auman boro men anao kwananowar, baibasit menane abai iti sawar asisinaf. ");
INSERT INTO aai_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Kwa mi’itube kwanotanot? Ana veya ta orot natunatun bairi hima’am basit orot natun ain isan eo, ‘Aro ayu akokok boun inan grape ana masaw inabow.’ ");
INSERT INTO aai_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Naatu kek tamah iya’afut eo, ‘Ayu men akokok.’ Baise ma kafai ana not botabir re in masaw bow. ");
INSERT INTO aai_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Naatu orot na maiye natun uf isan tit tur i ta’imonaban eo, naatu kek rufut eo, ‘Basit, Regah boro anan.’ Baise kwahir bar ma men in masaw bowamih. ");
INSERT INTO aai_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Naatu kek menatan i tamah fanan bai?” Hima’am hio, “Kek ain.” Jesu uwih eo, “Anababatun a tur ao’owen. Kwa kabay o’onayah naatu sagasagadiy i sabuw kakafih kwarouw kwao, baise i boro wan hini’iyon hinan mar ana aiwob hinab. ");
INSERT INTO aai_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Anayabin John Baptist na ef gewasin bai’ufnunin isan bi’obaiyi, kwa men kwaitumitumimih, baise kabay o’onayah, naatu sagasagadiy hitumitum, sawar i kwa’itin, baise men kafa’imo a not uf kwabotabir kwaitumitumimih.” ");
INSERT INTO aai_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesu eo maiye, “Oroubon tabo kwananowar. Orot me matuwan ana veya ta masaw bo grape tanum, fur ear ituwafut naatu Wine bunubunuw ana hub bai naatu ana masaw sabuw bowayah uwih hima’uh hima i tafaram afa bai nanawanamih in. ");
INSERT INTO aai_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Naatu grape hiyamur bairuhin ana veya kakabom, basit orot ana akir wairafih iyafarih hina bowayah biyah ibo au nowahine ai ro’oh bairut isan. ");
INSERT INTO aai_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Baise bowayah himisir orot ana akir wairafih hibow, ta hibai hirab, ta hi’asabun morob, naatu ta kabayamaim hirab. ");
INSERT INTO aai_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Orot ana akir wairafih afa’abo iyafarih hina, moumurihika men marasika biyafarih na’atube’emih, baise bowayah himisir akir wairafih hibow, wan hinan isah hisisinaf na’atube hisinaf hibow hirouw. ");
INSERT INTO aai_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Uftoro’ot i natun iyun na bowayah isah, not eo, ‘Sabuw boro natu hinakakafiy.’ ");
INSERT INTO aai_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Baise bowayah orot natun nan hi’itin hio, ‘Iti orot masaw matuwan natun enan kwanatabai tarab emorob, saise iti sawar etei boro it ata sawaramih tanabow.’ ");
INSERT INTO aai_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hina kek hibai fur ufunane hirouw re hitit hibai hi’asabun morob.” ");
INSERT INTO aai_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naatu Jesu ibatiyih eo, “Masaw matuwan namatabir nanan iti sabuw bowayah isah boro mi’itube nasinaf?” ");
INSERT INTO aai_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hiya’afut hio, “Nati orot bowayah etei boro narauw hinamorob, naatu masaw boro nab sabuw afa nitih hinama hinakaif, saise ai ro’oh hinabiyamur bowayah boro hinirut ibo au nowan hinitin.” ");
INSERT INTO aai_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Imaibo Jesu iuwih eo, “Buk Atamaninamaim hikirum inu’in kwaiyab kwa’itin. ‘Kabay nati bar wowabayah hi’itin kakafin hirouw hikwakwahir, I botabir na taf ana wabat matar, iti sawar i Regah sinaf, ana itinin gewasin maiyow ta’i’itin.’ ");
INSERT INTO aai_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Isan imih a tur ao’owen. Mar ana aiwob kwa biyamaim tema’am boro nabosairen sabuw iyab ub gewasih hitanum teyey boro i nitih. ");
INSERT INTO aai_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Orot yait iti agim afe’en nare narabirab i boro natarsisib, baise agim nare orot babin narabirab boro mutufor nifofob.” ");
INSERT INTO aai_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Firis hai ukwarih naatu Ofafar Bai’obaiyenayah Jesu ana oroubon eo hinowar hitatam. ");
INSERT INTO aai_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imih bain fatuminamih himisir, baise sabuw rou’ay hina hima’ama isah hibir. Anayabin sabuw etei Jesu hi’i’itin i God ana dinab orot ta. ");
INSERT INTO aai_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naatu Jesu iban maiye oroubon tabo sabuw hai tur eowen eo, ");
INSERT INTO aai_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mar ana Aiwob ana itinin i boro iti na’atube. Ana veya ta aiwob orot natun tabin isan ana hiyuw bogaigiwas. ");
INSERT INTO aai_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naatu ana akir wairafih iyunih kob hin sabuw iyabowat hiyuw aamih hibowabow isah, baise etei’imak hikwahir hima. ");
INSERT INTO aai_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Imih aiwob orot iban maiye ana akir wairafih afa’abo iyunih eo, ‘Kwanan sabuw iyabowat na hiyuw aamih au’uwih hai tur kwana’owen, masanuw etei arauw hitab, naatu hiyuw etei abogaigiwas sawar, imih kwanan tabin ana hiyuw tanaa.’ ");
INSERT INTO aai_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Baise hin hi’o, sabuw hiyuw aayah tur men hinowar, hai kokomaim hire nanabin hin. Orot ta au masaw in, orot ta re ana sitow bowamih in. ");
INSERT INTO aai_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Naatu sabuw afa akir wairafih hibow hirouw, afa hi’asbunubunuw himorob. ");
INSERT INTO aai_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aiwob orot anababatun yan so’ar, basit ana baiyowayah iyafarih hin sabuw ana akir wairafih hi’asbunubunuw etei hibow hirouw himorob naatu hai bar etei hi’afusar. ");
INSERT INTO aai_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Imaibo aiwob orot ana akir wairafih afa’abo eaf hina iuwih eo, ‘Tabin ana hiyuw i abogaigiwas sawar, baise sabuw au’uwih men yait ta namih. ");
INSERT INTO aai_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imih kwanatit kwanan ef gagamih yahimaim sabuw kwana’i’itih etei kwana’uwih hinan tabin ana hiyuwamaim hinarun.’ ");
INSERT INTO aai_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Basit akir wairafih hitit hin ef gagamih yahimaim orot babin hi’itih etei hibow, kakafin, gewasin etei hiteten hinatabin ana efanamaim hitit. ");
INSERT INTO aai_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Aiwob orot na nanawan hai merar yi ibabatiyih inan, basit orot ta tabin ana faifuw usina’e na ma’am itin. ");
INSERT INTO aai_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naatu ibatiy eo, ‘Au begon, o mi’itube’emih tabin ana faifuw usina’e ina irun kuma’am, etawan menane irun?’ Baise orot men tur ta eo. ");
INSERT INTO aai_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Basit aiwob orot ana akir wairafih iuwih eo, ‘Orot an uman kwafatum kwabai kwan ufun kwaisaroun ere gugumin wanawanan nama, narerey wan nitarfofor naso’ob.’” ");
INSERT INTO aai_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Naatu Jesu ana tur yomaninamaim eo, “Sabuw moumurih na’in God ea’afih, baise matan ta’amo boro narubinih.” ");
INSERT INTO aai_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Basit Ofafar Bai’obaiyenayah afa hin sa’ab akisihimo hiku’ay Jesu baikubibiruwin isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Imaibo hai bai’ufununayah afa naatu Herod ana kou’ay sabuw afa hin Jesu biyan hitit hio, “Bai’obaiyenayan, aki aso’ob. O i anababatun turamaim kuo, God ana sabuw isah abisa ekokokomaim kubi’obaiyih, abisa sabuw tenotanot isan men kubiyababan, anayabin o men orot babin ufuhine ku’i’itin. ");
INSERT INTO aai_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Imih kuo anowar. Caesar isan kabay tanabibaiyan boro ata ofafar tana’astu’ub, ai en? O mi’itube kunotanot?” ");
INSERT INTO aai_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesu mar ta’imon hio hai tur naniyan bai uwih eo, “Kwa i wanawan rerekabih! Aisim ayu kwabikubibiruwu? ");
INSERT INTO aai_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kabay kwabai kwana kwai’obaiyu aitin.” Naatu kabay hibai hina hitin. ");
INSERT INTO aai_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Itin sawar imaibo eo, “Iti kabayamaim i yait ayubin naatu wabin tema’am?” ");
INSERT INTO aai_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hiya’afut hio, “Caesar.” Basit Jesu iuwih eo, “Abisa Caesar nowan Caesar kwanitin, naatu abisa God nowan God kwanitin.” ");
INSERT INTO aai_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iti na’at eo hinonowar ana maramaim hifofor men kafaita. Naatu hihamiy himatabir maiye hin. ");
INSERT INTO aai_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nati veya ta’imon kau’ay ta wabin Sadducee hai sabuw afa hina Jesu biyan hitit hio, “Sabuw morobone boro men hinayawas maiye.” ");
INSERT INTO aai_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Naatu hio maiye, “Bai’obaiyenayan Moses eo tautabin orot ain natun en namomorob tain boro tuwah ana kwafur ni’aawan, saise hairi hina’in kek hinatufuw tuwah efanin. ");
INSERT INTO aai_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Imih marasika orot, ain uf nah etei seven hima’am, basit orot ain tabin naatu kek en morob. Ana kwafur tain i’aawan. ");
INSERT INTO aai_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","I auman kek en morob. Naatu tain ta bo kwafur i’aawan maiye. Kek en morob ef ta’imon na’atube hisinaf re in yomanin hi’asa’ub. ");
INSERT INTO aai_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Uf toro’ot, babin morob. ");
INSERT INTO aai_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Orot etei i babin ta’imon hi’aawan, imih ana maramaim morobone hinamimisir maiye, babin i boro menatan ni’aawan?” ");
INSERT INTO aai_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu iyafutih eo, “Kwa i a not hikwaris. Anayabin Buk Atamanin men kwaso’ob, naatu God ana fair auman men kwaso’ob. ");
INSERT INTO aai_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Anayabin morobone hinamimisir ana veya tounamatar maramaim tabina’e tema’am na’atube bairi boro hinama. ");
INSERT INTO aai_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Naatu morobone hinamisir maiye isan God eo Buk Atamaninamaim hikirum inu’in kwaiyab kwa’itin ei en? God iti na’atube eo, ");
INSERT INTO aai_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ayu i Abraham ana God, Isaac ana God, naatu Jacob ana God.’ Nati God i sabuw yawasih hai God men sabuw murubih hai Godamih.” ");
INSERT INTO aai_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sabuw rou’ay gagamin iti tur hinonowar, hifofor men kafaita, anayabin abisa bi’obaiyih i tur anababatun. ");
INSERT INTO aai_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesu tur eo Sadducee sabuw hai tur etei rabirab ana maramaim Pharisee sabuw hi’itin. Basit etei hina hita’imon. ");
INSERT INTO aai_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wanawanahimaim ofafar so’obayan orot ta na Jesu ikubibiruw eo, ");
INSERT INTO aai_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bai’obaiyenayan, obaiyunen tur menatan i gagamin ofafar etei wanawanahimaim?” ");
INSERT INTO aai_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu iya’afut eo, “Regah, a God isan dogor tutufin etei, a not tutufin etei, naatu biya tutufin etei iniyabuw. ");
INSERT INTO aai_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iti ofafar i gagamin naatu ofafar ana ukwarin. ");
INSERT INTO aai_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Naatu ofafar bairou’abin i iti. ‘Taituwa isah iniyabow o taiyuw isa kubiyabow na’atube.’ ");
INSERT INTO aai_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses ana ofafar tutufin etei naatu God ana dinab oro’orot hai bai’obaiyen etei i iti ofafar rou’ab tebi’ukwarih.” ");
INSERT INTO aai_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee sabuw hiru’ay hita’imon, basit Jesu ibatiyih ");
INSERT INTO aai_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","eo, “Kwa a notamaim Keriso isan mi’itube kwanotanot? I boro orot yait natun?” Naatu i hiya’afut hio, “Keriso i boro David ana agirane nan.” ");
INSERT INTO aai_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naatu Jesu ibatiyih eo, “Bo aisim Anun Kakafiyin ana fairamaim David iwanasum, Regah isan eo, ");
INSERT INTO aai_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Regah au Regah isan eo, Umau au asukwafune kumare inama’am. Ana maramaim ayu boro anatit a kamabiy sabuw anabow babamaim anaya.’ ");
INSERT INTO aai_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“David Roubininenayan orot isan i ana Regah rauw eo, imih men karam Roubininenayan orot i David ana agir narauw nao.” ");
INSERT INTO aai_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Men yait ta Jesu ana tur wan yimih. Nati ana veya’amaim men yait ta baibat afa bow na Jesu ibatiyimih. ");
INSERT INTO aai_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Imaibo Jesu sabuw rou’ay gagamin naatu i ana bai’ufununayah isah eo, ");
INSERT INTO aai_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ofafar bai’obaiyenayah naatu Pharisee i Moses ana ofafar etei hisora’ub. ");
INSERT INTO aai_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Imih abistan tibi’obaiyi i kwanabosiyasiyar, baise men kwani’u’urih. Anayabin abisa teo i men na’atube tisisinafumih. ");
INSERT INTO aai_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ofafar fokarih maiyow sabuw tuwabuh hiyara’ah hi’abar tibi’akir, naatu i men kafa’imo boro umah hina’ofere hinibaisih bit nakereremih. ");
INSERT INTO aai_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Sawar etei bebeyanamaim tisisinaf sabuw itihimih. God ana Tur ai kanabihimaim hikirum, ukwarih, umah, hai faifuwamaim hikubabaren sabuw itihimih. ");
INSERT INTO aai_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hiyuw hai mar tekokok efan gewasih hinabow hinamare hinama, naatu Kou’ay Bar wanawanan tekokok efan gewasih imaim hinama. ");
INSERT INTO aai_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hai kok gagamin i ahar efanamaim sabuw hinakakafiyih, hai merar hinay hinabora’ara’ahih bai’obaiyenayah gewasih hinarouw. ");
INSERT INTO aai_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Baise kwa men bai’obaiyenayah hinarauw hina’omih. Anayabin kwa etei i ain uf, naatu a Bai’obaiyenayan i ta’imon. ");
INSERT INTO aai_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Men yait ta iti tafaramamaim Tamat kwana’omih, anayabin kwa Tamat i ta’imonamo maramaim ema’am. ");
INSERT INTO aai_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naatu men yait ta kwa isa bai’obaiyenayah narouw nao, anayabin kwa A Bai’obaiyenayan i ta’imon Keriso akisin. ");
INSERT INTO aai_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Orot gagamin kwa wanawananamaim i orot yait taintuwan isah ebi’akir. ");
INSERT INTO aai_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Orot yait taiyuwin ebobora’ah God boro nayare, naatu orot yait taiyuwin eyayare God boro nabora’ah orot gagamin namatar. ");
INSERT INTO aai_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yababan boro kwanab, Ofafar Bai’obaiyenayah naatu Pharisee, wanawanah rerekabih! Sabuw mar ana aiwobomaim run isan hai etawan kwahir, naatu kwa run isan kwakwahir, sabuw afa runamih tisisinaftobon baise kwa men kwabibasit boro hinarun. ");
INSERT INTO aai_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yababan boro kanab, Ofafar Bai’obaiyenayah naatu Pharisee, wanawan rerekabih! Kwafur baibin kwai’a’afiyih hai sawar kwabowabow, naatu iti baifa’i isan kwai’o’orot yoyoban manimanih kwayoyoyoban ");
INSERT INTO aai_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yababan boro kwanab, Ofafar Bai’obaiyenayah naatu Pharisee, wanawanan rerekabih! Tafaram, tafaram un boy kwabai sabuw dogoroh baikitabirin a kou’ayomaim run isan kwa’u’uwih, naatu orot ta’imon kwabai a kou’ayomaim erur i ana kakafin tafan kwaya’abar kwai’afiy kakafin natun matar kwa bairi kwanan kwani’akiramih. ");
INSERT INTO aai_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Yababan boro kwanab! Mata fimih! A bai’obaiyenamaim sabuw kwai’obaiyih kwao, ‘Orot yait Tafaror Bar isan na’obaifaro, nati ana’obaifaro yabin en, baise orot yait Tafaror Bar wanawanan gold isan na’obaifaro, nati anao matanen i nakakafiy.’ ");
INSERT INTO aai_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mata hifim kwabobosa! Sawar menatan i gagamin, gold o Tafaror Bar? Baise Tafaror Bar i gagamin anayabin i wanawananamaim gold i kakafiyih himatar ti’inu’in. ");
INSERT INTO aai_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iban maiye sabuw kwai’obaiyih kwao, ‘Orot yait sibor ana gem kakafiyin isan nao’obaifaro, nati anao baifaro i yabin en, baise gem kakafiyin afe’enamaim siwar isan na’obaifaro nati ana’obaifaro i nakakafiy.’ ");
INSERT INTO aai_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mata hifim kwabobosa! Sawar menatan i gagamin, siwar o sibor ana gem kakafiyin tafanamaim siwar tena kakafiyin kakafiyin temamatar i gagamin? ");
INSERT INTO aai_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isan imih orot yait sibor ana gem kakafiyin isan eobaifaro, sawar etei nati gem tafaramamaim ti’inu’in auman isah eobaifaro. ");
INSERT INTO aai_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na’atube orot yait Tafaror Bar isan eobaifaro, i God nati wanawananamaim ema’am auman isan eobaifaro. ");
INSERT INTO aai_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naatu orot yait mar isan eobaifaro i God ana urama’ama efan isan eobaifaro, anayabin nati i God ana ma’ama efan. ");
INSERT INTO aai_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Yababan boro kwanab, Ofafar Bai’obaiyenayah naatu Pharisee, wanawanan rerekabih! Kwa i fiyow yamurih gewasih, bay hai momon, bay matah haibaib gewasih i roumukur kwayai God kwabitin, baise ofafar gagamih ma gewas isan, kabeber, bosunusunub isan eo i kwakwahiren. Ofafar iti i gagamih, gewasin i kwatabosiyasiyar ofafar afa auman. ");
INSERT INTO aai_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bonawiyenayah mata fim! Ofafar rimiyafof totomar i kwarurububuna, baise camel koun butun i kwatotonan. ");
INSERT INTO aai_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Yababan boro kwanab, Ofafar Bai’obaiyenayah, naatu Pharisee wanawanan rerekabih! A kerowas naatu a tew ufuhine i kwasasouwen, baise wanawanah i kato rabirabih, bain, bai’o’orot, kabat, gamin baiyow awan karatan inu’in. ");
INSERT INTO aai_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mata hifim kwabobosa Pharisee! Gewasin a tew naatu a kerowas wanawanahine wan kwanasouwen, saise ufuhine auman boro hinigewasih. ");
INSERT INTO aai_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Yababan boro kwanab, Ofafar Bai’obaiyenayah naatu Pharisee. wanawan rerekabih! Kwa a’itinin i rah ufunane tewowab gewas ebatabat na’atube, baise wanawanan i orot babin hai rarik awan karatan masin kakafin. ");
INSERT INTO aai_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Imih kwa ayumat i nati na’atube, ufunane sabuw matahimaim a’itinin i gewasin, baise wanawananamaim a kakafin naatu a tafasar i ra’at. ");
INSERT INTO aai_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Yababan boro kwanab, Ofafar Bai’obaiyenayah, naatu Pharisee, wanawan rerekabih! dinab oro’orot hai yawas gewasih naatu sabuw hai yawas mutufurih himomorob hai rah i kwabobuna’en kwama kwabi’aburen. ");
INSERT INTO aai_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naatu kwao, aki ai a’agir hima’am hai veya’amaim bairi ata ma’am aki boro men dinab oro’orot ata rauw hitamorobomih. ");
INSERT INTO aai_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Imih nati turamaim kwa taiyuw kwao’orereb kwa uwatanah i dinab oro’orot hi’asbunubunuw himorob. ");
INSERT INTO aai_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Imih abisa uwatanah hibubusuruf hisisinaf i kwaisawar nuhi efot. ");
INSERT INTO aai_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kok hai yumat! naatu kok natunatun! God ana baimakiy boro kwanahaiw? ");
INSERT INTO aai_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Isan imih a tur ao’owen, dinab oro’orot, bai’obaiyenayah naatu orot not wairafih boro aniyafarih hinan. Baise boro kwanabow kwanarauw hinamorob, afa boro kwana’onafih, naatu boro kwanarouw hinamorob, afa boro Kou’ay bar wanawanan kwanawabirih, naatu bar merar ta ta’amaim kwaninunih kwanaremor. ");
INSERT INTO aai_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sinaf ana an nati isan, sabuw gewasih himorob hai rara susuwa anabit etei boro kwa tafa nayen baimakiy kwanab. Abel orot gewasin momorob ana veya’ika re na Berakiah natun Zechariah, iti Tafaror Bar naatu sibor kakafiyin hai founamaim kwarab momorob i ana veya’amaim tit. ");
INSERT INTO aai_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Imih tur anababatun a tur ao’owen, Sabuw himorob hai rara re’er hai bit etei kwa iti boun yawasih kwama’am boro kwanab. ");
INSERT INTO aai_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem! dinab oro’orot etei i’asbunuw himorob, naatu kob abarayah hiyunih hinan etei kabayamaim irauw himorob. Mar etei a kok kwanekwan umau’umaim natunat atabuwih hitan ta’imon hitamatar. Kokorere natunatun ita’imonih ebaba’afuwih na’atube, baise o men kafa’imo baibasit itu. ");
INSERT INTO aai_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Isan imih a bar a merar boro hinakwahir naowarar. ");
INSERT INTO aai_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A tur ao’owen ayu boro men kwana’itu maiye’emih. Ana maramaim kwanao, ‘Yait Regah wabinamaim enan boro baigegewasin nab.’” ");
INSERT INTO aai_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu Tafaror Bar gagamin ihamiy tit inan auman, ana bai’ufununayah hina hiu, “Tafaror bar kwi’itin gewasin maiyow.” ");
INSERT INTO aai_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu iyafutih eo, “Sawar iti kwa’i’itan, a tur ao’owen, kabay etei boro natafofor nare naatu kabay ta boro men ana efanamaim na’inu’in kwana’itinimih.” ");
INSERT INTO aai_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu yen Olive Oyaw tafan mare, ana bai’ufununayah wa’iwa’iramaim hina biyan hitit hibatiy hio, “Kuo anowar mar i boro biy iti sawar hinamatar? Naatu o inanan ina’inanen boro abisa ana’itin anaso’ob. Naatu mar yomanin nakakabon boro mi’itube ana so’ob?” ");
INSERT INTO aai_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu iyafutih eo, “Matato niwa’an, men sabuw hinan hinifufuwimih. ");
INSERT INTO aai_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabuw moumurih na’in boro ayu wabu’umaim hinan hinao, ‘Ayu i Keriso’ naatu sabuw moumurih na’in boro hinifufuwih. ");
INSERT INTO aai_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Baiyow ana tur boro kwananowar, naatu baiyow isan ana tur boro kwananowar, baise men kwanabir. Sawar yumatah ta ta boro hinamatar, baise nati i men mar yomanin. ");
INSERT INTO aai_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tafaram ta boro tafaram ta hairi hiniyow, na’atube bar merar ta boro bar merar ta ana aiwob hairi hiniyow. Baimar kakafin, iriyoy boro tafaram awan nakaratan. ");
INSERT INTO aai_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sawar iti etei hinamatar i kek tufuwamih ebobotukwar na’atube. ");
INSERT INTO aai_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sabuw boro hinafatumi hinabuw kwanan hini’a’akir, hina’asbuni kwanamorob, ayu wabu’umaim kwabowabow isan. ");
INSERT INTO aai_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nati ana veya’amaim baitumatumayah boro hai baitumatum hinihamiy, naatu turahinah babah hinao, taiyuwih turahinah hinifa’ifa’ih, ");
INSERT INTO aai_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","dinab baifufuwenayah moumurih na’in boro hinatit sabuw moumurih na’in hinifufuwih. ");
INSERT INTO aai_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tafa’asar boro nara’at natasasar sabuw momurih na’in hai yabow boro wan natutum. ");
INSERT INTO aai_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Baise yait nabukikin nan yomanin natitit i boro yawas nab. ");
INSERT INTO aai_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tur Gewasin, mar ana aiwob isan, i boro tafaram wanawanan etei hinabinan sabuw etei hinanowar, imaibo mar yomanin boro nan natit. ");
INSERT INTO aai_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Biya’ohow Ana Sawar Kakafin boro efan kakafiyinamaim nabatabat kwana’itin, dinab orot Daniel eo na’atube. Baiyabayan orot iti tur nabiyab naniyan nab gewas. ");
INSERT INTO aai_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sabuw iyab Judea wanawananamaim tema’ama boro hinabihir hinan oyaw wan hinayen. ");
INSERT INTO aai_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Orot yait ana bar faifiy wan ema’am boro men nare ana sawar bar wanawanan nabowamih, veya en. ");
INSERT INTO aai_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Orot yait masaw ebowabow boro men namatabir ana biya baibiyon bar nabaimih. ");
INSERT INTO aai_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nati ana veya’amaim baibin iyab siasiar tema’ama naatu baibin iyab kek tibitotoman boro hini’akir yababan hinab. ");
INSERT INTO aai_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","God isan kwanayoyoban, saise men rarab kokou ana veya’amaim o Sabbath ana veya’amaim namataramih. ");
INSERT INTO aai_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nati ana veya’amaim boro yababan kakafin men marasika anamaim o boro namamatar na’atube namataramih. ");
INSERT INTO aai_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","God nati veya narurukabum na’at sabuw boro yawas men hinab. Baise ana sabuw rurubiniyih isah enotanot, imih veya boro narukabum. ");
INSERT INTO aai_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nati ana veya sabuw afa hinan hina’uwi, ‘Keriso’oban iti!’ o ‘Iban ni’i!’ men kwanitumatum. ");
INSERT INTO aai_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anayabin Keriso na’atube naatu dinab baifufuwenayah boro hinan ina’inan fokarih hinasinaf God ana rourubinen sabuw moumurih na’in boro hinabow. ");
INSERT INTO aai_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Imih abimatuwibo sawar hinamatar. ");
INSERT INTO aai_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Sabuw a tur hinaowen hinao, ‘Iban nati arar yan ema’am,’ men imaim kwanan kwananuwih. O hinao, ‘Nati nanawan bar wanawanan wa’ir ema’am,’ men kwanitumatum. ");
INSERT INTO aai_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Veya yeninane namanamar ebowabow veya ra’iyinane uman emamarakaw, Orot Natun nanan ana marakaw boro nati na’atube. ");
INSERT INTO aai_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Menamaim orot babin biyan murubin inu’in mamu ikou boro etei imaim hinaru’ay. ");
INSERT INTO aai_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Yababan iti hinamamatar ufunamaim ‘Veya boro matan nagugum, sumar boro men nakaw, daman boro hinihururuw hinare. mar wanawanan sawar ti’inu’in etei boro hai efan hinasairen.’ ");
INSERT INTO aai_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Imaibo Orot Natun maramaim boro natit, tafaram wanawanan sabuw etei orot Natun ana fair ana marakaw bonamanamarin auman natit sakuk wanawanan nanan hina’itin hinama hinarerey. ");
INSERT INTO aai_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ana tounamatar boro taur douduf auman hinatit tafaram tutufin wanawanan umasusun kwafe’en etei God ana sabuw rurubinih hinabow hinita’ay. ");
INSERT INTO aai_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ai fofou raurihimaim ebi’obaiyih kwanaso’ob, ai raurih boubuh tititit kwa kwaso’ob, ai hai buwayan ana veya i natit. ");
INSERT INTO aai_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bai’obaiyen i ta’imon, sawar iti na’atube hinamamatar kwa boro kwanaso’ob, veya i nakabom etawan awanamaim ebatabat. ");
INSERT INTO aai_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anababatun a tur ao’owen, sabuw iti boun yawas kwama’am boro iti sawar namatar kwana’itinibo kwanamorob. ");
INSERT INTO aai_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mar tafaram i boro nasawar, baise ayu au tur boro men nasawar. ");
INSERT INTO aai_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Orot men yait ta Jesu ana na isan veya o sumar so’obamih. tounamatar maramaim men hiso’ob na’atube i Natun auman men so’ob, baise Tamah akisinamo so’ob. ");
INSERT INTO aai_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noah ana veya’amaim abisa mamatar na’atube Orot Natun nanan boro na’atube namatar. ");
INSERT INTO aai_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nati ana veya tuw yena’e ana veya orot babin hiyuw hibow, hiaa hitom, hitabin hibiyasisir ufut Noah ark wanawanan run; ");
INSERT INTO aai_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","naatu so’oba’e hima’am kwanekwan tuw yen etei e’aruwih hin himorob. Imih orot Natun nanan ana itinin i boro nati na’atube. ");
INSERT INTO aai_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Orot rou’ab boro hai masaw hinama hinabob, Orot ta boro tounamatar hinabora’ah ta boro hinihamiy nama. ");
INSERT INTO aai_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Baibin rou’ab boro hinama maiwok hinakakair, babin ta boro hinabora’ah, babin ta boro hinihamiy nama. ");
INSERT INTO aai_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Isan imih mata to niwa’an, anayabin men kwaso’ob mar biy boro a Regah nan. ");
INSERT INTO aai_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Baise tur iti ao i naniyan kwanab. Orot bar matuwan bainowan hai veya nasoso’ob, boro matan nanuw nama’am nanunih hinabihir, ana bar boro men hinakwib hinabainuwimih. ");
INSERT INTO aai_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Imih mar etei mata to niwa’an kwanabobuna kwanama, anayabin Orot Natun boro men o veya kunotanotamaim natitamih. ");
INSERT INTO aai_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Akir wairafin bosunusunubayan naatu not wairafin ana orot ukwarin boro nayara’ah akir wairafih afa nakaifih hai bay ana veya’amaim nitih. ");
INSERT INTO aai_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naatu ana orot ukwarin namatabir nanan bowabow gewasin nabowabow na’itin boro niyasisir. ");
INSERT INTO aai_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A tur ao’owen nati akir wairafin boro nayara’ah sawar etei nakaifen. ");
INSERT INTO aai_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Baise akir wairafin nitafasar nao, ‘Au orot ukwarin men saise matabir enanamih.’ ");
INSERT INTO aai_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naatu natatabir akir wairafih afa narauw ni’a’afiyih bay naa, harew tomayah bairi hinaa hinatom hinabikoko’aw wanawanan ");
INSERT INTO aai_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","veya naatu sumar so’oba’e nama’am kwanekwan ana orot ukwarin namatabir nan natit. ");
INSERT INTO aai_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naatu orot ukwarin nati ana akir wairafin boro nab narab ufun narauwatait, sabuw afa wanawanah rerekabih bairi baimakiy kakafin hinab hinama hinarerey wah takitak niwa’an. ");
INSERT INTO aai_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nati ana veya’amaim mar ana aiwob itinin i boro baibitar nah ten biyah numin tabin boubun itinamih hai ramef hibow hinan na’atube. ");
INSERT INTO aai_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baibitar five i not wairafih, naatu baibitar five i men not wairafih. ");
INSERT INTO aai_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Baibitar men not wairafih hai ramef hibow, baise karisin men ta hirirabar hibaimih. ");
INSERT INTO aai_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Baibitar five not wairafih hai ramef hibow naatu kibubumaim karisin hirirbaren hibow auman hin. ");
INSERT INTO aai_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tabin boubun ana orot men saise na, baibitar isan hima hikakaif matah fot hi’inurir hi’in.” ");
INSERT INTO aai_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Fainaiwan sabuw fanah sibisib hinowar, ‘Tabin boubun ana orot enan kwana kwa’itin.’” ");
INSERT INTO aai_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Imaibo baibitar ten hi’inu’in himisir, hai ramef matah hibobaituturen naatu hito’aben. ");
INSERT INTO aai_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Baibitar men not wairafih turahinah not wairafih isah hio, ‘A karisin turin kwaibaisi, aki ai ramef temomorob.’” ");
INSERT INTO aai_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Baise baibitar five not wairafih hiyafutih hio, ‘Men karam boro kwa turin anit naatu aki turin anab. Gewasin boro kwanan sabuw biyahimaim kwabo isa kwanatobon.’” ");
INSERT INTO aai_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Basit baibitar karisin tobonamih hinan ufut, tabin boubun ana orot natit, baibitar five hibobuna hima’am bairi hin tabin ana yasisir wanawanan hirun etawan hitufabon.” ");
INSERT INTO aai_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Men manin baibitar five hina hitit hi’afririy ‘Regah, Regah, etawan kubotawiy arun!’” ");
INSERT INTO aai_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Baise orot efatait eo, ‘Anababatun a tur ao’owen, ayu men aso’ob kwa iyab.’” ");
INSERT INTO aai_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Isan imih mata to niwa’an kwanama, anayabin veya o sumar men kwa so’ob, mar biy boro iti sawar hinamatar.” ");
INSERT INTO aai_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maramaim mar ana aiwob itinin ta i iti na’atube. Orot ef yok bainanawan isan bobobunabuna ana veya; ana akir wairafih e’afih hina ana sawar kaifen isan faramih. ");
INSERT INTO aai_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hai so’ob ana fofoninamaim orot ta ana kabay 5,000 itin, orot ta 2,000, orot ta 1,000. Imaibo i ana nanawan busuruf in. ");
INSERT INTO aai_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Akir wairafin 5,000 baib in banikamaim yari’iy in bowabow, 5,000 tafan hiya’abar bai. ");
INSERT INTO aai_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Akir wairafin bairou’abin i na’atube sinaf. Kabay 2,000 bai in imaim ma bikukumiyaw 2,000 tafan hiya’abar bai. ");
INSERT INTO aai_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Baise akir wairafin ta ana kabay 1,000 baib i mutufor in hub bai regah ana kabay hub iwan taunafut in. ");
INSERT INTO aai_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hima manin maiyow, imaibo akir wairafih hai orot ukwarin matabir na tit, naatu hai bowabow nuteteyan itah. ");
INSERT INTO aai_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naatu akir wairafin kabay 5,000 baib na run ana regah nanamaim eo, ‘Regah o 5,000 itu, baise ayu abowabow tafanamaim 5,000 abaib i iti kubai.’” ");
INSERT INTO aai_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Regah iya’afut eo, ‘A merar ayiy, o i bowayan orot gewas naatu bosunusunubayan, bowabow gidigidih ibosunusunub kukakaifen gewas, imih boro anayara’ahi inayen sawar gagamih inakaifen. Kuna kurun au yasisir turin kubai!’ ");
INSERT INTO aai_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Naatu akir wairafin bairou’abin kabay 2,000 baib na run eo, ‘Regah o a kabay 2,000 ibitu i iti, naatu abowabow tafanamaim 2,000 abaib i iti kubai.’ ");
INSERT INTO aai_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Regah eo, ‘A merar ayiyi, o i bowayan orot gewas naatu bosunusunubayan, sawar matan ta ibosunusunub kukakaifen gewas. Imih boro anayara’ahi inayen sawar moumurihika inakaifen. Kuna kurun au yasisir turin kubai.’ ");
INSERT INTO aai_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Imaibo akir wairafin baitonin kabay 1,000 baib na run eo, ‘Regah ayu aso’ob, o i a tur fokarin, turanah hai masaw o aribe kufafaur naatu turanah nowah o kutatanumabe kutaratar. ");
INSERT INTO aai_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imih ayu o isa abir. A kabay abai an hub agais aibun inu’in, iti abai ana abit maiye kwitin.’ ");
INSERT INTO aai_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ana Regah iya’afut eo, ‘O i orot kakaf nokonokow anababatun! O iso’ob, ayu i tebob nonowatih afafour naatu tetatanum nonowatih ataratar. ");
INSERT INTO aai_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gewasin au kabay banikamaim itayi ta’in tabowabow, ayu atanan, saise tafan hitaya’abar auman hitutu atab.’ ");
INSERT INTO aai_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Naatu orot ukwarin eo, ‘Kabay iti orot umanamaim kwabosair kwabai kwan akir wairafin kabay 10,000 baib i kwaitin. ");
INSERT INTO aai_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Anayabin orot yait uman ebi’e’etaw boro sawar tafan hinaya’abar moumurihika nabow isan nakaram. Baise orot yait uman nutanub ema’am biyanamaim sawar etei’imak boro hinabosairen. ");
INSERT INTO aai_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Imih iti akir wairafin nukunukuwin kwabai kwan kwarauw ufun gugumin wanawanan ere, nati imaim nama narerey wan nayob nitafofofor.’ ");
INSERT INTO aai_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Orot Natun ni’aiwob nanan ana maramaim ana tounamatar kakafiyih boro bairi hinan ana urama’am bonamanamarin tafan namare. ");
INSERT INTO aai_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naatu tafaram wanawanan sabuw tutufin etei boro hinaru’ay Jesu nanamaim hinabat. Imaibo i boro sabuw nakusib rou’ab hinamatar, nabatanenayan sheep naatu goat bairi ekukusibih na’atube. ");
INSERT INTO aai_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sheep i boro uman ana asukwafune hinabat naatu goat boro uman ana beyawane hinabat.” ");
INSERT INTO aai_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Imaibo aiwob orot boro sabuw uman ana asukwafune isah nao, ‘Kwa i Tamai ebigegewasini, kwana mar ana aiwob nowamih kwabai. Anayabin tafaram matara’e ana veya God kwa isa yabuna. ");
INSERT INTO aai_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayu bayumih amomorob bay kwaitu, sikau mamamah harew kwaitu atom, abinanawan au merar kwayi a baremaim ama ra’at ama. ");
INSERT INTO aai_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Segar ama’am faifuw kwaitu aus, asawow ainu’in, kwakaifu naatu dibur bar ama’am kwana kwainanawanu.’” ");
INSERT INTO aai_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sabuw gewasih boro hiniya’afut hinao, ‘Regah mar biyika bayumih imomorob ai’it bay ait, o sika mamamah harew ait itom? ");
INSERT INTO aai_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naatu biyika inanawan inan ai’it a merar ayiy abuwi ai sebomaim imara’at? O segar ima’am faifuw ait ius? ");
INSERT INTO aai_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naatu mar biyika isawow inu’in akaifi, o dibur bar ima’ama ainanawani?’” ");
INSERT INTO aai_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aiwob orot boro niyafutih nao, ‘Anababatun au’uwi, nati ana veya’amaim ayu taitu gidigidih isah kwasisinaf, i ayu isau kwasinaf.’” ");
INSERT INTO aai_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Imaibo sabuw ana beyawane hinabatabat isah boro nao, ‘Biyau’umaim kwatit sa’ab kwan. Kwa i orarafen wanawanan kwarun, Demon Mowan ana tounamatar bairi isah wairaf wanatowan hibobogaigiwas kwan imaim kwarun bairi e’arahi. ");
INSERT INTO aai_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ayu aa amomorob, men abisa ta kwaitu aan, sikau mamamah harew men kwaitu atom. ");
INSERT INTO aai_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ai nanawan anan men au merar kwayi a sebomaim amara’at. Segar ama’am faifuw men kwaitu ausimih, a sawow ainu’in, o dibur baremaim ama’am men kwana kwainanawanu.’” ");
INSERT INTO aai_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Naatu i boro hiniya’afut hinao, ‘Regah, mar biyika o aa imomorob, o harewamih sika mamamah, o ibinanawan, o segar ima’am, o isawow inu’in, o dibur bar ima’am men aibaisimih?’” ");
INSERT INTO aai_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Imaibo i boro niyafutih nao, ‘Anababatun a tur ao’owen, ayu taitu gidigidih men kwabibaisih, nati i men kwakok ayu kwatibaisu.’” ");
INSERT INTO aai_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Naatu nati sabuw i boro hinan ma’ama wanatowan ana baimakiy hinab. Baise sabuw gewasih boro hinan yawas ma’ama wanatowan hinab hinama hiniyasisir.” ");
INSERT INTO aai_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesu bi’obaibiyih ufunamaim, ana bai’ufununayah isah eo, ");
INSERT INTO aai_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kwanaso’ob veya rou’ab ufunamaim Tar Nowaten ana hiyuw enan. Nati ana veya’amaim Orot Natun boro hinab rakit sabuw umahimaim hinayai hina’onaf.” ");
INSERT INTO aai_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Imaibo Firis ukwarih naatu regaregah ai’in etei firis gagamin Kaiafas ana baremaim hiru’ay. ");
INSERT INTO aai_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Naatu Jesu wa’iwa’iramaim fatumin bain asabunin isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Baise hio, “Men hiyuw tanabowabow wanawananamaim, anayabin rakit boro tanaku’ub was hinagiy.” ");
INSERT INTO aai_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu na Bethany orot Simon biyan kokom ani’anin ana baremaim tit, ");
INSERT INTO aai_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mare ma bay eaa auman babin ta kibub kikimin kabay wabin alabaster imaim hikwak raiy ana baiyan gagamin hisuwai batabat bai na run Jesu aribun yan isuwai re. ");
INSERT INTO aai_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ana bai’ufununayah hi’itin yah so’ar hio, “Iti sawar i yabin en asir esisinaf. ");
INSERT INTO aai_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Igewasin iti raiy ana baiyan tatayara’ah hitatubun kabay tatab, sabuw yababan wairafih tatitih.” ");
INSERT INTO aai_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Baise Jesu so’ob abisa hio, imih iuwih eo, “Babin men yumatanamaim kwana’umih. Anayabin sawar gewasin maiyow ayu isau esisinaf. ");
INSERT INTO aai_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sabuw yababan wairafih boro mar etei bairi kwanama kwanibaisih, baise ayu i boro men mar etei bairi tanama’amih. ");
INSERT INTO aai_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iti babin ayu biyau raiy erabirab i ayu au morob isan eyayabuna. ");
INSERT INTO aai_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anababatun a tur ao’owen, tafaram wanawananamaim iti Tur Gewasin hinabibinan ana maramaim abisa gewasin iti babin sisinaf boro kik owe’owen na’atube auman hinabinan.” ");
INSERT INTO aai_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Imaibo bai’ufununayah nah 12 wanawanahimaim orot wabin Judas Iscariot tit in firis ukwarih biyah tit, ");
INSERT INTO aai_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","naatu ibatiyih, “Ayu Jesu anab kwa anabit boro abisa ayu kwanitu?” Naatu matanamaim kabay hibotait hiyab in 30 na’atube hiya’asair. ");
INSERT INTO aai_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nati ana veya’amaim Judas ef ana gewasin nuwet Jesu batih isan. ");
INSERT INTO aai_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Faraw Wanawanan Yeast En ana hiyuw veya wantoro’ot bubusuruf, Jesu ana bai’ufununayah hina hio, “Menamaim kukokok Tar Nowaten ana bay anabogaigiwas?” ");
INSERT INTO aai_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu iyafutih eo, “Kwanan Jerusalem bar merar kwanatit orot iti ana tur kwana’owen kwanao, ‘Bai’obaiyenayan eo, ayu au veya i natit, akokok au bai’ufununayah bairi boro o abaremaim Tar nowaten ana hiyuw anaa aniyasisir.’” ");
INSERT INTO aai_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bai’ufununayah Jesu eobaimanih na’atube hisinaf, Tar Nowaten ana hiyuw hibogaigiwas. ");
INSERT INTO aai_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naatu nati rabirab bai’ufununayah etei 12 Jesu bairi himare hibusuruf bay hiaa. ");
INSERT INTO aai_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bay hiaa wanawananamaim Jesu eo, “Turobe a tur ao’owen, kwa wanawanamaim orot ta boro babau inao anamorob.” ");
INSERT INTO aai_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ana bai’ufununayah hai yababan ra’at, naatu ta’ita’imon hibusuruf Jesu hibabatiy hio, “Regah, nati i men ayu’umih?” ");
INSERT INTO aai_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu iyafutih eo, “Orot menatan ayu airi tew wanawanan ai rafiy anabubutu’ub, nati orot i boro ayu babau nao. ");
INSERT INTO aai_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Orot Natun i boro namorob Bukamaim hikirum hio na’atube. Baise orot yait ayu babau nao, nati orot i boro yababan gagamin na’in nab. Gewasin nati orot tafaramamaim men tatufuwamih!” ");
INSERT INTO aai_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas yanuwayan Jesu ibatiy eo, “Regah, o kunotanot i men ayu’umih?” Jesu iya’afut eo, “O wai.” ");
INSERT INTO aai_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bay hia wanawanan Jesu rafiy bai, i gegewasin sawar, imasib, ana bai’ufununayah itih eo, “Iti i ayu biyau kwabai naatu kwa’aan.” ");
INSERT INTO aai_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Imaibo wine kerowasamaim hisuwai batabat bai God ana merar yi sawar, itih eo, “Kwa etei’imak iti kwanatom. ");
INSERT INTO aai_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iti i ayu au rara, au Obaibasit Boubun abisuwai sabuw moumurih hai bowabow kakafih notawiyen isan. ");
INSERT INTO aai_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A tur ao’owen, ayu iti wine boro men anatom, anama’am nati ana veya’amaim wine boubun kwa bairit Tamai ana aiwobomaim tanatom.” ");
INSERT INTO aai_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Naatu himisir ew ta hitabor hitit hin Olive Oyawamaim hitit. ");
INSERT INTO aai_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Imaibo Jesu hai tur eowen eo, “Iti boun gugumin kwa etei boro kwanabihir ayu kwanihamiyu, Buk Atamaninamaim eo na’atube, ‘Ayu nabatanenayan orot boro ana’asabun, naatu bobaituw etei boro na’abaragiy nanabin hinan.’ ");
INSERT INTO aai_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Baise ayu morobone anamimisir ufunamaim boro au na ani’iyon wan anan Galilee anatit.” ");
INSERT INTO aai_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter iya’afut eo, “Turau’unah boro hinabihir, baise ayu boro men anabihir o anihamiyimih.” ");
INSERT INTO aai_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu Peter iu, “Anababatun a tur ao’owen, boun gugumin o boro ayu inayaubu mar tounu, naatu i ufunamaim kokorere boro nao’o inanowar.” ");
INSERT INTO aai_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter raro’on rab eo, “Ayu boro men kafa’imo tur nati ana’omih, morobomih na’at airit tanamorob.” Naatu bai’ufununayah etei tur ta’imon hio. ");
INSERT INTO aai_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Imaibo Jesu ana bai’ufununayah bairi hitit hin Gethsemane hitit naatu iuwih eo, “Iti imaim kwamare kwama, ayu anan auweyane anayoyoban.” ");
INSERT INTO aai_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter naatu Zebedee natunatun rou’ab buwih bairi hin, ana not kwaris naatu dogoron wanawanan ana yababan ra’at ");
INSERT INTO aai_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","iuwih eo, “Dogorou wanawanan au yababan i ra’at kwanekwan dogorou emama’afut. Imih iti’imaim kwamare mata nanuw bairit tanama.” ");
INSERT INTO aai_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesu akisinamo nabinamaim in yumatan au babe ra’iy yoyoban eo, “Tamai, karam iti biyababan ana kerowas ayu biyau’umaim itabosair, baise men ayu au kok, o a kok.” ");
INSERT INTO aai_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naatu matabir maiye na ana bai’ufununayah nah tounu hi’inu’in itih, Peter isan eo, “Anayabin aisim nataunu’uka mata hifot kwa’inu’in, karam one hour na’atube mata tanuw bairit tatama? ");
INSERT INTO aai_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mata to iwa’an kwayoyoban, saise men routobon kwanabaimih. Anun i ekokok yoyoban, baise biya i himorob.” ");
INSERT INTO aai_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mar bairou’abin Jesu in maiye yoyoban eo, “Tamai, iti biyababan ana kerowas bosairin isan ana ef men nama’am na’at, basit anatom, saise a kokok anasinaf namatar.” ");
INSERT INTO aai_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Matabir maiye nan matah kou bit hi’in yugaranih inan itih. ");
INSERT INTO aai_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naatu ihamiyih hi’in i mar baitonin matabir in tur ta’imon eo yoyoban maiye. ");
INSERT INTO aai_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Imaibo matabir na ana bai’ufununayah biyah tit eo, “Kwa boro’ika kwa’in kwabiyarir? Mata tinuw, kwamisir, Orot Natun ana veya i natit, sabuw kakafih umahimaim eyey. ");
INSERT INTO aai_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kwamisir tan! Orot yanuwayanaban iti enan kwa’i’itin.” ");
INSERT INTO aai_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu eo ana tur sawara’e, bai’ufununayah 12 wanawanahimaim orot ta, wabin Judas, sabuw kou’ay gagamin na’in, firis ukwarih naatu regaregah ai’in hibiyafarih nawiyih kaiy, kefat, mis hiteten auman bairi hina hitit. ");
INSERT INTO aai_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Orot yanuwayan sabuw eobaimanih eo, “Orot menatan anamamamay orotoban nati kwanab kwanafatum.” ");
INSERT INTO aai_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas mutufor in Jesu biyan tit eo, “Tufuw isa nama Bai’obaiyenayan!” naatu mamay. ");
INSERT INTO aai_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu iya’afut eo, “Au begon, abisa isan inot inan saife kusinaf.” Imaibo sabuw hibatabat hitit Jesu uman hibai hibukikin. ");
INSERT INTO aai_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bai’ufununayan orot ta ana kaiy bora’ah, firis gagamin ana akir wairafin tainin roun eafuw. ");
INSERT INTO aai_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naatu Jesu iu, “A kaiy ana efanamaim kwiwan maiye, anayabin sabuw iyab umahimaim kaiy tema’am boro kaiyomaim hinamorob. ");
INSERT INTO aai_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O men iso’obamih, ayu Tamai isan atabifefeyan boro mar ta’imon tounamatar sibisib na’atube tiyafarih ayu hitawasfafaru. ");
INSERT INTO aai_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Baise nati na’atube anasinaf, Buk Atamaninamaim mataramih hi’o hikikirum boro men niturobe’emih.” ");
INSERT INTO aai_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naatu tatabir sabuw isah eo, “Ana itinin ayu bainowan mowan na’atube, imih kaiy kefat kwaiteten ayu yuwu rabu’umih kwanan. Mar etei Tafaror Bar wanawananamaim ama sabuw abi’obaiyih aisim men imaim kwatafatumu? ");
INSERT INTO aai_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Baise abisa God ana dinab oro’orot Buk Atamaninamaim hio hikikirum emamatar saife nan niturobe.” Nati’imaim ana bai’ufununayah etei hihamiy hibihir. ");
INSERT INTO aai_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sabuw Jesu hibai hifatum hibai hin firis gagamin wabin Kaiafas ana baremaim hitit, nati’imaim Ofafar Bai’obaiyenayah naatu regaregah ai’in hiru’ay hima’am. ");
INSERT INTO aai_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Baise Peter yokaika Jesu i’ufunun bairi hina, firis gagamin ana bar sebosebomaim hitit naatu run ma’utenayan oro’orot bairi himare abisa tamamatar ta’itin isan. ");
INSERT INTO aai_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Firis gagamin naatu kaniser ana kau’ay etei hiru’ay nuhinot tur hitabow hitit hitifufuwen Jesu tamorob isan. ");
INSERT INTO aai_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Baise nuhinot tur hinunuwet men ta hibai. Sabuw moumurih maiyow hitit Jesu morobomih hibifufuwen hai tur naniyan en. Yomaninamaim orot rou’ab hitit, ");
INSERT INTO aai_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hiorereb hio “Iti orot eo, ‘Ayu i karam God ana Tafaror bar anagurus nare, naatu veya tounu wanawanan boro anawowab efanin namatar.’” ");
INSERT INTO aai_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imaibo Firis gagamin misir Jesu isan eo, “O boro men tur ta inao? Orot hairi o a tur isan hio’orereb inonowar boro tur ta inao ai en?” ");
INSERT INTO aai_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Baise Jesu awanamaim men tur ta titamih. Naatu Firis gagamin eo maiye, “God wanatowan ma’anin wabinamaim aobaifaro, o God ana Roubinen orot na’at basit kuo anowar.” ");
INSERT INTO aai_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu iya’afut eo, “Tur i nati kuo, baise kwa etei a tur ao’owen. Mar boro nanan orot Natun boro God uman ana asukwafune nabat mar ana rofom wanawanan nanan kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Firis gagamin iti tur nonowar ana veya ana faifuw bai sib eo, “Iti orot i tur kakafin maiyow eo God ebi’ib! Aisim boro tanama sif rubonayah afa’abo tananuwet? Kwa taiyuw bai’ib tur eo kwanowar, ");
INSERT INTO aai_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","kwa a not i mi’itube?” Etei hiya’afut hio, “I bowabow kakafin sinaf imih namorob!” ");
INSERT INTO aai_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Imaibo yumatan hikwaitututur, hiborabirab naatu sabuw afa hiboborabirab, ");
INSERT INTO aai_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hio, “Keriso, o God ana dinab orot na’at kuo anowar! Yait o rab?” ");
INSERT INTO aai_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter ufun bar ana seboseb wanawanan mare ma’am, Firis Gagamin ana bowayan babitai tit iu, “O auman i Galilee orot Jesu ana of ta.” ");
INSERT INTO aai_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Baise Peter sabuw etei nahimaim yaub eo, “Ayu o a tur kuo yabin men aso’ob.” ");
INSERT INTO aai_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naatu misir tit in bar ana etawan awanamaim tit, nati’imaim bowayan babitai ta itin naatu oro’orot nati’imaim hibatabat hai tur eowen eo, “Iti orot i Jesu Nazareth mowan ana of ta.” ");
INSERT INTO aai_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter iban maiye yaub naatu ifaro eo, “Ayu nati orot men aso’ob.” ");
INSERT INTO aai_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hima kafa’imo orot afa nati’imaim hibatabat hina Peter biyan hitit hio, “O i anababatun ni’i orot ana of ta, anayabin a tur kuo ana nowarin naatu a sawar io’osen ana itinin i ta’imon.” ");
INSERT INTO aai_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Imaibo Peter ifaro eo, “Ana bifufuwen na’at God ana orarafen anab, tur anababatun a tur ao’owen, ayu iti orot men aso’ob.” Mar ta’imon kokorere eo. ");
INSERT INTO aai_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Basit Peter nuhin taseb Jesu eo not, “O boro mar tounu ayu inayaubu, imaibo kokorere boro nao.” Naatu Peter tit in ufun rerey igagagamat. ");
INSERT INTO aai_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Maraumanika Firis ukwarih etei naatu regaregah ai’in bairi Jesu morob isan hio hiyabunai sawar. ");
INSERT INTO aai_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Basit uman hifatum hibai hitit Roman hai gawan Pilate umanamaim hiyai. ");
INSERT INTO aai_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, yanuwayan Jesu kakafinamaim hiya’iyai i’itin ana veya dogoron rusib, kabay 30 bai matabir na Firis ukwarih naatu regaregah ai’in nahimaim tit, eo ");
INSERT INTO aai_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ayu asinaf kakaf orot gewasin baban ao emomorob.” Hiya’afut hio, “Nati o a yababan, o akisimo ina’itin inayabunai.” ");
INSERT INTO aai_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas kabay nati Tafaror Bar kabay teya’aya’amaim itaiy re naatu ihamiyih tit in sikan warasa yai morob. ");
INSERT INTO aai_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Firis ukwarih kabay hibai hio, “Iti i rara ana kabay, ata ofafar men ebibasit boro Tafaror Bar ana kabay ya’aya’amaim tanayai na’in.” ");
INSERT INTO aai_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Etei’imak hio hibibasit ufunamaim, kabay hibai noukwat bu’urayan ana kamar hitubun, saise nah touman sabuw hai rah ana efan namatar. ");
INSERT INTO aai_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ana’an nati isan kamar wabin “Rara ana Kamar” hibiwab in na iti boun ana veya tit. ");
INSERT INTO aai_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Naatu abistan dinab orot Jeremiah eo ina iturobe. “Israel sabuw orot ana baiyan baitinin isan kabay etei 30 hibibasit. ");
INSERT INTO aai_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Noukwat bu’urayan ana kamar hitubun Regah ayu iu’uwu na’atube.” ");
INSERT INTO aai_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesu Roman gawan nanamaim bat, naatu gawan Jesu ibatiy, “O Jews sabuw hai aiwob?” Jesu iya’afut eo. “Nati kuo, ayu boro abi tur anao.” ");
INSERT INTO aai_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Firis ukwarih naatu regaregah ai’in Jesu ubar hitin tur kakafin isan hio men kafa’imo iyafutimih. ");
INSERT INTO aai_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Basit Pilate Jesu iu, “Sabuw kakafih isan ubar hit teo’orereb kunonowar?” ");
INSERT INTO aai_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Baise Jesu men kafa’imo awanamaim tur ta tit, naatu Gawan orot ana kasiy ra’at ifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tar Nowaten hiyuw ana veya, gawan hai binanakwar eo na’atube, mar etei dibur barane sabuw hai kok orot menatan tirurubin i ebobotait. ");
INSERT INTO aai_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nati ana veya orot wabin gagamin Jesu Barabas dibur ma’am. ");
INSERT INTO aai_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naatu sabuw hiru’ay sawar, basit Pilate ibatiyih, “Orot menatan kwakokok diburune anabotait, Jesu Barabas o Jesu Keriso?” ");
INSERT INTO aai_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Anayabin sabuw bobowenamaim Jesu hibai Pilate umanamaim hiya’iyai i so’ob. ");
INSERT INTO aai_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate baibabatiyen ana efanamaim ma’am, aawan tur iyafar na eo, “Orot nati gewasin isan men abisa ta inasinaf, anayabin fai ayu mim fokarin maiyow isan amim au not ekakasiy” ");
INSERT INTO aai_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Baise firis ukwarih naatu regaregah ai’in sabuw tafah fair hiyai, Barabas botaitin naatu Jesu asabunin isan Pilate hiokikin. ");
INSERT INTO aai_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilate sabuw ibatiyih, “Orot i rou’ab, imih orot menatan kwakokok ana botait?” Etei’imak hiya’afut hio, “Barabas!” ");
INSERT INTO aai_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate sabuw ibatiyih, “Bo Jesu wabin Keriso isan boro mi’itube anasinaf?” Etei’imak hiya’afut hio, “Ku’onaf!” ");
INSERT INTO aai_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate ibatiyih, “Abisa kakafin sinaf?” Baise sabuw hitar koukuw hio, “Ku’onaf!” ");
INSERT INTO aai_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate naniyan bai men karam boro ef ta tasinaf, naatu sabuw auman kougeyagey hibusuruf, imih harew bai sabuw etei nahimaim uman sauwen eo, “Ayu iti orot namomorob isan men ana ubar anabaimih. Nati i kwa akis a ubar.” ");
INSERT INTO aai_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sabuw etei hiya’afut hio, “I namomorob ana ubar i aki anab naatu natunatu auman ana ubar hinab.” ");
INSERT INTO aai_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Imaibo Pilate Barabas botait, naatu Jesu wabir ana baiyowayah iuwih, onafin isan hibai hin. ");
INSERT INTO aai_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Imaibo Pilate ana baiyowayah Jesu hibai hin gawan ana bar hitit, nati’imaim baiyowayah etei hiru’ay hibebera’uh. ");
INSERT INTO aai_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ana faifuw hi’oromen, faifuw namar hibai hi’us, ");
INSERT INTO aai_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kokor hififin ukwarin ana raramamih hiyara’ah, uman ana asukwafune tu hitin, nanamaim suh hiyowen hi’i’iyab hio, “Jews hai aiwob tanabora’ara’ah.” ");
INSERT INTO aai_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yumatan hikwaitututur, uman tu hibosair ukwarinamaim hiborabirab. ");
INSERT INTO aai_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hibi’i’iyab ufunamaim, faifuw hi’us ma’am hibosair ana faifuw hibow hina hi’us, imaibo hibai hin onafin isan. ");
INSERT INTO aai_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hitit hinan efamaim Sairini orot wabin Simon bairi hitar naatu baiyowayah hi’ukikin Jesu ana onaf bai e’abar. ");
INSERT INTO aai_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hina efan wabin Golgotha imaim hitit, nati efan hibiwab yabin efan ana itinin i orot ukwarin ana gifow na’atube. ");
INSERT INTO aai_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nati’imaim wine harew tenakuyakuy auman hisartabir Jesu tomanih hitin bai kakartubun ufunamaim kwahir. ");
INSERT INTO aai_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naatu hi’o’onaf ana veya arowamaim ana faifuw hikusib hifaram hibow. ");
INSERT INTO aai_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Imaibo nati’imaim himarir Jesu hima’uh hima. ");
INSERT INTO aai_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naatu tafanamaim ubar hibitin ana tur hikirum hikubar, “ITI I JESU, JEW SABUW HAI AIWOB.” ");
INSERT INTO aai_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Naatu bainowan orot rou’ab Jesu bairi hi’onafih, ta ana beyawane ta ana asukwafune. ");
INSERT INTO aai_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sabuw nanane hinan ukwarih hita’asi’asiy ubar hitin tur kakafih maiyow Jesu hi’i’iyab hio, ");
INSERT INTO aai_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Tafaror bar tarabounin veya tounu wanawananamaim wowabin sawaramih io! Bo o God Natun na’at kwiyawasi cross afe’enane kure’eban a’it?” ");
INSERT INTO aai_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ef ta’imon firis ukwarih, Ofafar Bai’obaiyenayah naatu regaregah ai’in auman Jesu hi’i’iyab hio, ");
INSERT INTO aai_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Sabuw afa iyawasih, baise i taiyuwin men karam boro niyawas, Israel sabuw hai aiwob! Bo cross afe’enane boun nare tana itin boro tanitumitum. ");
INSERT INTO aai_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","God i bitumitum, bo God boun iyawasiban ta’itin, anayabin i taiyuwin i God Natun rouw eo.” ");
INSERT INTO aai_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ef ta’imon bainowah orot rou’ab Jesu bairi hi’onafih hi’inu’in ubar hitin tur kakafih hi’u. ");
INSERT INTO aai_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Veya yen tafat yan tafaram etei gugum inu’in veya botabir re 3 korok bai. ");
INSERT INTO aai_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Veya 3 korok na’atube, Jesu fanan aumetawat rerey eo, “Eloi, Eloi Lema Sabachthani?” Anayabin, “Au God, au God, aisim ihamiyu?” ");
INSERT INTO aai_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sabuw afa nati’imaim hibatabat hinowar hio, “Elijah isan eafa’af kwanowar.” ");
INSERT INTO aai_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naatu orot ta nunuw in sawar ta biyan sou’usau bai, wine tenakuyakuy butu’ub, eot ra’ah Jesu awanamaim yai tomamih. ");
INSERT INTO aai_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Baise sabuw afa hio, “Kubat, Elijah nan nabiyawas tana’itin!” ");
INSERT INTO aai_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesu iban maiye fanan aumetawat rerey, naatu ayubin tabaratait. ");
INSERT INTO aai_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Faifuw Tafaror Bar wanawanan hita’iy re efan kakafiyin hirafut inu’in yate rusib re in uran tit rou’ab himatar, iriyoy tit kabay hitaseseb. ");
INSERT INTO aai_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rah awah hiha’e, sabuw kakafiyih moumurih na’in marasika himorob hi’inu’in etei hiyawas himisir. ");
INSERT INTO aai_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hai rah hitumaren hitit, Jesu morobone mimisir ufunamaim, murumurubih etei hitit hin Jerusalem hitit, sabuw moumurih na’in hi’itih. ");
INSERT INTO aai_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Baiyowayah hai orot ukwarih naatu baiyowayah afa bairi nati’imaim Jesu hima’uh hima’am iriyoy hitatam, naatu abisa’awat himamatar hi’itah hai bir ra’at hio, “Turobe iti orot i anababatun God Natun!” ");
INSERT INTO aai_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nati’imaim baibin moumurih na’in hina ef yokaika hibat abisa’awat himamatar hi’itah. Iti baibin i Galilee’ine Jesu hi’ufunun bairi hina hibibais. ");
INSERT INTO aai_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Baibin wanawanahimaim i Mary Magdalene, Mary, James, Joseph hairi hinah naatu Zebedee aawan. ");
INSERT INTO aai_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Birabirab auman orot sawar wairafin, wabin Joseph ana tafaram Arimathea’ane na tit. Iti orot i Jesu ana bai’ufununayan ta, baise wa’iwa’iramaim bi’ufununun. ");
INSERT INTO aai_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joseph na Pilate nanamaim tit, Jesu biyan bai na ya’in isan fefeyan, naatu Pilate ana baiyowayah uwih Jesu biyan hibai hitin. ");
INSERT INTO aai_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph, Jesu biyan bai faifuw boubunamaim sum ");
INSERT INTO aai_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bai in hub boubun i isan iti boro’omo to naiwanamaim bai inu’in, imaim Jesu yai naatu kabay ifururuw na sou hir naatu ana ubar in. ");
INSERT INTO aai_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene naatu Mary, James, Joseph hairi hinah i rah rewan rounane himare hima hi’itin. ");
INSERT INTO aai_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mar natot i boro Sabbath ana veya, imih Firis ukwarih naatu Pharisee hina Pilate nanamaim hitit ");
INSERT INTO aai_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hio, “Regah ni’i orot baifufuwenayan yawasin ma’am eo, ‘Ayu boro veya tounu ufunamaim morobone anamisir.’ Iti na’atube eo i aki anotanot. ");
INSERT INTO aai_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isan imih akokok baiyowayah afa iniyafarih hinan rah hinama’uh hinama veya tounu, saise ana bai’ufununayah boro men hinan biyan hinabain hinabihir, naatu morobone misir maiye hinarouw hinao sabuw hinifuwihimih. Anayabin baifuwen iti boun natitit boro kakafin anababatun men wan anabifuwen na’atube’emih.” ");
INSERT INTO aai_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate iyafutih eo, “Ma’utenayah orot kwa aso’obamaim kwanabuwih naatu kwana’uwih matah toniwa’an rah hinama’uh gewas hinama.” ");
INSERT INTO aai_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basit hitit hin rah ana etawan kabay tafanamaim kwah hiyai, naatu ma’utenayah orot nati’imaim rah hima’uh hima. ");
INSERT INTO aai_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath ufunamaim, Sunday yasi’uw Mary Magdalene naatu Mary ta hairi rah fahiwinamih hin. ");
INSERT INTO aai_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naniyan meyemeye iriyoy gagamin na’in hitatam, Regah ana tounamatar marane re na agim ifururuw tit naatu afe’en mara’at ma. ");
INSERT INTO aai_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ana itinin i namanamar ebowabow na’atube, ana faifuw hibikwes itinin i wakasakas na’atube. ");
INSERT INTO aai_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Orot rah hima’uh hima’am hai bir ra’at, ah umah duduwar rab hire himamayay hi’in. ");
INSERT INTO aai_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Baise tounamatar baibin hairi isah eo, “Men kwanabir, ayu aso’ob kwa i Jesu hio’onaf momorob kwanunuwih. ");
INSERT INTO aai_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Baise i morobone misir maiye, eo kwanonowar na’atube, kwarun inu’in ana efan kwa’i’itin. ");
INSERT INTO aai_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Saise kwanamatabir kwan ana bai’ufununayah hai tur kwana’owen, ‘Jesu i morobone misir maiye, naatu mat au Galilee enan, imaim boro kwana’itin.’ Abisa asoso’ob iti a tur ao’owen.” ");
INSERT INTO aai_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Basit baibin rah hitumar, hai bir ra’at, baise erekawasa auman hinunuw hin ana bai’ufununayah hai tur owenamih. ");
INSERT INTO aai_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naniyan meyemeye Jesu nahine nan bairi hitar naatu iuwih eo, “Tufuw isa nama.” Hinunuw hina nanamaim suh hiyowen hire an hibutubun hikwafir. ");
INSERT INTO aai_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesu iuwih eo, “Men kwanabir, kwan taitu hai tur kwana’owen hinan Galilee imaim boro ayu hina’itu.” ");
INSERT INTO aai_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Baibin hairi himatabir efamaim hinan, baiyowayah orot afa rah hima’uh hima’ama himatabir hin Jerusalem hitit, naatu abisa’awat himamatar firis ukwarih hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naatu nati’imaim firis hai ukwarih orot gagamih bairi hiku’ay hai not hiyabuna sawar, imaibo agim gagamin na’in baiyowayah hitih ");
INSERT INTO aai_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","naatu hi’uwih, sabuw hai tur kwana’owen, “Aki ainu’in ufut Jesu ana bai’ufununayah hina biyan hibai hibihir. ");
INSERT INTO aai_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Saise gawan orot iti tur nanonowar aki boro kwa isa anakubuna gewas nanowar naatu boro men abisa ta isa nasinaf.” ");
INSERT INTO aai_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Basit baiyowayah agim hibai hiobe’atih na’atube hisinaf. Imih iti boun ana veya’amaim iti tur i ra’at tasasar tit, Jews wanawanahimaim etei hiso’ob. ");
INSERT INTO aai_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Imaibo bai’ufununayah nah 11 Jesu iu’uwih na’atube hina Galilee oyawamaim hitit, ");
INSERT INTO aai_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","nati’imaim hi’i’itin ana weya hikwafir, baise bai’ufununayah afa i erehikasiy auman. ");
INSERT INTO aai_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu na sisibihimaim bat eo, “Mar naatu tafaram ana roubabaruwen fair etei God ayu itu. ");
INSERT INTO aai_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isan imih kwanatit kwanan tafaram wanawananamaim sabuw kwanabow au bai’ufununayah hinamatar, naatu God Tamah, God Natun, God Anunin Kakafiyin wabihimaim babataito kwanitih. ");
INSERT INTO aai_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Naatu au obaiyunen tur etei kwani’obaiyih hinabosiyasiyar. Naatu kwanaso’ob ayu i mar etei nati biyamaim boro bairi tanama tanan mar yomanin tanatit.” ");
INSERT INTO aai_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iti i Tur Gewasin ana busurufin i Jesu Keriso God Natun isan. ");
INSERT INTO aai_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ana tur i dinab orot Isaiah kikirum imaim busuruf eo. “‘Ayu boro au tur abarayan o namaim aniyun nan, i boro o a ef nayabuna.’ ");
INSERT INTO aai_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Orot ta fanan arar yanamaim eafa’af, ‘Regah ana ef kwanayabuna ana ef kwanimutufur imaim naremor!’” ");
INSERT INTO aai_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John arar yanane tit na dogor baikitabir bapataito bain, saise God bowabow kakafih notawiyen isan binan. ");
INSERT INTO aai_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea bar merar tutufin etei naatu Jerusalem sabuw tutufin etei hitit hin biyan hitit. Hai kakafih hi’e’en naatu Jordan harewamaim bapataito itih. ");
INSERT INTO aai_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John ana faifuw i camel bunibunin sakir iyoun, naatu ana kikir i bobaituw ta kanabin e’afuw naiwan kik, ana bay i sisik naatu kutor tafu. ");
INSERT INTO aai_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana tur i iti binan, “Orot ta ayu ufu’umaim enan ana fair i ra’at ayu natabiru, an ana sumasum ayu men karam boro ana kwafure anarufam. ");
INSERT INTO aai_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ayu i harewamaim bapataito abit, baise i boro Anun Kakafiyinamaim bapataito nit.” ");
INSERT INTO aai_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nati ana veya’amaim tafaram gagamin Galilee wanawanan bar merar Nazarethane Jesu na Jordan harewamaim John bapataito itin. ");
INSERT INTO aai_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu harewane yey ana maramaim, mar botawiy, Anun Kakafiyin mamu imak na’atube re na tafan yey itin. ");
INSERT INTO aai_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naatu maramaim orot fanan tit eo, “O i ayu Natu, ayu Natu au yabow, o isa ayu abiyasisir.” ");
INSERT INTO aai_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mar ta’imonamo Anun Kakafiyin iunawiy arar yan tit. ");
INSERT INTO aai_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Veya 40 na’atube imaim ma, Satan routobon itin. Sigarafor yumatah ta ta wanawanahimaim, naatu tounamatar nati’imaim i hina hitatafafar. ");
INSERT INTO aai_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John dibur hiyayari’iy ufunamaim Jesu na Galilee tit, naatu God ana tur gewasin binan eo, ");
INSERT INTO aai_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Veya anababatun i na tit, God ana aiwob i na iyubin, bowabow kakafin kwasisinaf i kwanihamiyen kwanamatabir tur gewasin kwanitumitum!” ");
INSERT INTO aai_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Naatu Jesu harew Galilee kukuf dones yan remor inan, siy bowayah orot rou’ab itih, Simon Peter tain Andrew hairi buwatamaim siy hibowabow. ");
INSERT INTO aai_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu iuwih eo, “Kwai’ufnunu bairi tan ayu boro ani’obaiyi sabuw kwanabow.” ");
INSERT INTO aai_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mar ta’imonamo hai buwat hihamiyen naatu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","In kikiminamo orot rou’ab itih, James tain John hairi, orot Zebedee natunatun, hai wa wanawanan hima hai buwat hiyayabuna. ");
INSERT INTO aai_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesu e’afa’af ana veya hairi matah kabiy himisir tamah Zebedee ana bowabow sabuw bairi wa afe’en hihamiyih hima, i Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu ana bai’ufununayah bairi hina tafaram Capernaum hitit, naatu Baiyarir ana veya na Kou’ay Bar run naatu busuruf i’obaiyih eo. ");
INSERT INTO aai_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sabuw hinonowar hifofofor men kafaita. Anayabin bai’obaiyen bitih ana itinin i roubabaruwen ana fairamaim bi’obaiyih, men Ofafar bai’obaiyenayah na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Men yok afiy kakafin orot iwanasum ma’am na Kou’ay Bar run ikirir eo, ");
INSERT INTO aai_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesu Nazareth mowan, aki biyai’imaim o abisa sinafumih kukokok? O kukokok aki inagurusi’imih? Ayu aso’ob o i yait, O i God ana Orot Kakafiyin!” ");
INSERT INTO aai_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu afiy kakafin kwarar iu, “Awa efot orot biyanamaim kutit!” ");
INSERT INTO aai_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Afiy kakafin orot iyuwiyuw naatu fanan auman bihir tit. ");
INSERT INTO aai_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sabuw etei hifofofor men kafaita naatu taiyuwih hibabatiyih hio, “Iti anayabin i abisa? Bai’obaiyen boubun roubabaruwen ana fair auman, anayabin afiy kakafih eo biyunih i fanan tebaib!” ");
INSERT INTO aai_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naatu Jesu ana tur saisewat tasasar tit tafaram Galilee ana uman men sanet hima’am eretei tur hinowar. ");
INSERT INTO aai_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kou’ay Bar hibihamiy ufunamaim James, John hairi mutufor hin Simon Andrew hairi hai bar hitit. ");
INSERT INTO aai_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon rawan babin sawow biyan fora’ab inu’in Jesu na titit ana veya ana tur hi’owen, ");
INSERT INTO aai_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Naatu na biyan tit uman bai ibais misir, nati’imaim sawow ihamiy busuruf bow. ");
INSERT INTO aai_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nati rabirab veya re’er auman sabuw sawusawuwih naatu afa demon hitarsumih hima’am hibuwih hina Jesu isan. ");
INSERT INTO aai_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sabuw nati bar merar hima’am etei hiru’ay nati bar nanamaim, ");
INSERT INTO aai_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu sawow yumatah ta ta hibow hinan etei iyawasih naatu demon moumurih nunih hitit, men ibasit boro demon tihamiyih tur hitao, anayabin i hiso’ob i yait. ");
INSERT INTO aai_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mar tomih ana gugumin iu’ufiy auman Jesu misir bar ihamiy tit remor in bar merar gagamin natabir na efan noutanubinamaim tit imaim ma yoyoban. ");
INSERT INTO aai_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Baise Simon ana ofonah bairi hitit hinuwih hin. ");
INSERT INTO aai_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Naatu hititita’urih ana veya hi’u, “Sabuw o tenunuwihi.” ");
INSERT INTO aai_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Baise Jesu iyafutih eo, “It tanan bar merar afa iti bar merar gagamin sisibinamaim auman isah anabinan, anayabin nati isan ayu ana.” ");
INSERT INTO aai_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Imih Galilee wanawanan etei remor hai Kou’ay Baremaim binan naatu demon kakafih nunih hitit. ");
INSERT INTO aai_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Orot biyan kokom ani’anin na Jesu nanamaim tit sun yowen baibaisin isan ifefeyan eo, “Inakokok na’at basit iniwa’an anigewasin.” ");
INSERT INTO aai_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu dogoron wanawanan yababan awan karatan uman ru’atayan naatu biyan butubun eo, “Ayu akokok. Kwigewasin!” ");
INSERT INTO aai_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mar ta’imonamo orot biyan kokom hihururuwih hire naatu igewasin. ");
INSERT INTO aai_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Baise Jesu ana baimatnuwen tur fokarinaka orot iu naatu biyafar eo, ");
INSERT INTO aai_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Inanowar men yait ta ana tur ina’owen, baise mutufor inan firis biyan inatit o biya nanutitiy, naatu Moses eo na’atube sibor inayai, saise orot babin matahimaim hinaso’ob o igewasin.” ");
INSERT INTO aai_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Baise orot tit in busuruf tur bosemor tafaram etei bai. I ana turamaim Jesu men karam boro bebeyan tan bar merar tarun, imih i efan noutanubinamaim ma, baise sabuw efan ta ta i boro’ika hina biyan hititit. ");
INSERT INTO aai_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Veya bai’ab na’atube sasawar ufunamaim Jesu matabir maiye na ana bar Capernaum titit ana veya, ana tur tasasar tit etei hinowar. ");
INSERT INTO aai_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Naatu sabuw moumurih maiyow hiru’ay bar awan karatan tit in etawan awan auman bai daririr iwa’an. Naatu i busuruf binan hima hinowar. ");
INSERT INTO aai_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nati ana maramaim orot kwafe’en turan an uman murubin hi’abar Jesu isan hina. ");
INSERT INTO aai_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Baise rou’ay gagamin orot bain run isan men karam, imih orot hibai hiyen Jesu batabat tafanamaim faifiy wan hitarayouw. Naatu orot ana emo’em auman murabamaim hiruru ra’iy. ");
INSERT INTO aai_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Naatu Jesu hai baitumatum i’itin ana maramaim orot an uman murubin isan eo, “Natu a bowabow kakafih anotanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nati’imaim Ofafar bai’obaiyenayah afa hima’am hai notamaim hibabatiyih hio, ");
INSERT INTO aai_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Orot aisim iti na’atube eo’o? Iti i baigigimen tur, God akisinamo bowabow kakafih enotanotawiyen, men yait ta.” ");
INSERT INTO aai_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Abisa isan hinotanot Jesu mar ta’imon so’ob, naatu eo, “Aisim nati na’atube kwanotanot? ");
INSERT INTO aai_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Menatan i hamehamen? Orot an uman murubin ana abowabow kakafih notawiyen isan ana’o i hamehamen? Ai, anau ana ir nanu nab nanan i hamehamen? ");
INSERT INTO aai_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Baise ani’obaiyi kwanaso’ob, Orot Natun iti tafaramamaim ana fair i ema’ama bowabow kakafih notawiyen isan.” Naatu orot an uman murubin isan eo, ");
INSERT INTO aai_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ayu au’uwi, kumisir a ir kunu kubai au bar kwen!” ");
INSERT INTO aai_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Inu’in misir, ana ir tensamur bai nu nah yan foun hibat hi’itin remor tit in, nati’imaim sabuw etei hifofofor men kafaita naatu God hibora’ara’ah hio, “Aki sawar iti na’atube men a’itin!” ");
INSERT INTO aai_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu matabir na Galilee harew kukuf rewanamaim tit, rou’ay gagamin isan hina naatu i busuruf i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nati’imaim remor inan kabay o’onayan Levi, Alpheus natun ana bowabow efanamaim ma’am itin isan eo, “Ayu kwi’ufnunu.” Levi misir Jesu i’ufunun hairi hin. ");
INSERT INTO aai_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nati ufunamaim Jesu Levi ana bar wanawanan kabay o’onayah naatu bowabow kakafih sinafuyah moumurih maiyow Jesu hi’ufunun bairi hinan ana bai’ufununayah bairi himare bay hi’aa, naatu sabuw kakafih afa moumurih maiyow auman hibi’ufunun. ");
INSERT INTO aai_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ofafar bai’obaiyenayah iyab Pharisee ana kou’ayamaim hima’ama hi’itin hina ana bai’ufununayah hibatiyih, “Aisim sabuw nati na’atube bairi te’aa?” ");
INSERT INTO aai_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu nowar naatu iyafutih eo, “Sabuw aurih sawow en adanafur orot boro men hinakok, baise sabuw iyab sawusawuwih adanafur orot boro hinakok. Ayu men sabuw gewasih isah anamih, baise kakafih isah.” ");
INSERT INTO aai_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Veya ta John Baptist ana bai’ufununayah naatu Pharisee bairi hiyoyohar isan, sabuw afa hina Jesu biyan hitit hibatiy, “Aisim John Baptist ana bai’ufununayah naatu Pharisee hai bai’ufununayah bairi teyoyohar baise o a bai’ufununayah i en?” ");
INSERT INTO aai_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu iyafutih eo, “Kwanotanot sabuw tabin ana yasisir isan nanawan hinanan boro amurumurubih hinamatabir? Aiyab! Tabin boubun isan nanawan sabuw nati’imaim boro men hinayoharamih. ");
INSERT INTO aai_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Baise veya enan tabin boubun boro biyahimaim hinabosair imaibo hinayohar. ");
INSERT INTO aai_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Na’atube faifuw boubun reban men karam hinab faifuw atamanin hinafitimih, anayabin faifuw boubun nakaro’om faifuw atamanin boro natakweb mahar nara’at. ");
INSERT INTO aai_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na’atube men yait ta wine boubun bai, wine ana koukufet atamaninamaim ririmih, anayabin wine boubun nagadid nayen koukufet boro nataseb, naatu wine, koukufet hairi boro hai yabih en hinamatar. Imih wine boubun i boro koukufet boubunamaim hinarir saise hairi boro gewasih hinabat.” ");
INSERT INTO aai_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baiyarir ana veya Jesu ana bai’ufununayah bairi sanabey wanawanan hiremor hinan naatu hibusuruf sanabey hirut, ");
INSERT INTO aai_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisee Jesu hi’u, “Kwi’itin aisim it ata Baiyarir ana ofafar o abai’ufununayah te’a’astu’ub?” ");
INSERT INTO aai_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu iyafutih eo, “David ana orot bairi aa himomorob ana veya abisa sisinaf kwaiyab kwa’itin? Ana orot bairi aa himomorob ana veya ");
INSERT INTO aai_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","in God ana bar wanawanan run naatu faraw kakafiyin bai eaan. Iti mamatar i Abiathar Firis Gagamin ma’am ana veya. It ata ofafar eo i firis akisihimo iti rafiy hinaa, baise David eaan naatu ana orot turin itih hi’aa.” ");
INSERT INTO aai_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naatu Jesu ana tur yomanin baisawarin isan iti na’atube eo, “Baiyarir i orot ana gewasin isan matar, baise orot i men Baiyarir isan ni’akiramih. ");
INSERT INTO aai_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Imih Orot Natun i Baiyarir Tamah anababatun.” ");
INSERT INTO aai_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesu iban matabir maiye na Kou’ay Bar wanawanan run, naatu orot uman murubin i nati’imaim ma’ama. ");
INSERT INTO aai_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sabuw afa Jesu baikubibiruwin isan i nati’imaim hima hi’i’itin, saise orot uman murubin Baiyarir Ana Veya tabiyawas hitikubibiruw isan. ");
INSERT INTO aai_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu orot uman murubin iu, “Kuyen kuna iti nou’umaim.” ");
INSERT INTO aai_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Imaibo sabuw isah eo, “Baiyarir ana veya’amaim ata ofafar i gewasin sinaf isan ebibasit or kakafin sinaf isan ebibasit? Orot tanibais yawas nab or tanimurub?” Baise i men tur ta hi’omih. ");
INSERT INTO aai_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu nan ufun inuwanuw itih yumatah fofokar isan yan so’ar, baise ibanak maiye isah iyababan, anayabin matah kufaf hisisinaf kakaf. Imaibo orot isan eo, “Uma ku’otofair.” Orot uman otofair tit igewasin. ");
INSERT INTO aai_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Basit Pharisee mar ta’imonamo Kou’ay Bar hitumar hitit hin Herod ana kou’ay bairi rabin morob isan baban hio. ");
INSERT INTO aai_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu ana bai’ufununayah bairi hitit hina Galilee harew Kukufamaim hitit. Naatu sabuw rou’ay gagamin maiyow hi’ufunun hinan i Galilee’ine, Judea’ane, ");
INSERT INTO aai_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalemane, Idumea ana umanika, naatu Jordan sisibin veya yeninane na’atube bar merar gagamin Taiya naatu Sidon wanawanahine hina. Sabuw etei i Jesu abisa sisinaf ana tur hinowar hina. ");
INSERT INTO aai_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Naatu rou’ay i ra’at kwanekwan kafa’imo yaten hitayen, imih Jesu ana bai’ufununayah iuwih wa ta hiyabuna. ");
INSERT INTO aai_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Anayabin sabuw moumurih na’in iyawasih, naatu sabuw afa hisasawow i ef hinunuwet hitan hitabutubun isan. ");
INSERT INTO aai_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naatu sabuw afa biyahimaim afiy kakafih hima’am hinuw hi’i’itin ana maramaim i nanamaim hire rabih hikirir hio, “O God Natun.” ");
INSERT INTO aai_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu afiy kakafih kwararih iuwih eo, “Men yait ta ana tur kwana’owen ayu i yait!” ");
INSERT INTO aai_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Imaibo Jesu yen in heher wanamaim bat, basit orot i ana kokomaim eafih hina biyan hitit. ");
INSERT INTO aai_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naatu nah 12 rubinih tur abarayah iwabih eo, “Ayu arubini saise kwa boro bairit tanama aniyafari kwanatit kwanan kwanabinan. ");
INSERT INTO aai_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Naatu boro fair kwanab Wagabur kwananunih hinatit.” ");
INSERT INTO aai_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Orot nah 12 Jesu rurubiniyih wabih i iti, Simon, wabin ta Peter (Jesu ufibo iwab), ");
INSERT INTO aai_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James, tain John hairi, orot Zebedee natunatun, Jesu wabih Boaneges, wabih anayabin farafarar natunatun. ");
INSERT INTO aai_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James, orot Alpheus natun, Thaddeus, tafaram kafafarayan orot wabin Simon ana orot ta, ");
INSERT INTO aai_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","naatu Jesu ana yanuwayan orot Judas Iscairot. ");
INSERT INTO aai_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Imaibo Jesu ana au bar in, ibanak maiye sabuw moumurih na’in hiru’ay naatu Jesu ana bai’ufununayah bairi veya men ma boro bay hitaa. ");
INSERT INTO aai_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Naatu i taintuwan tur hinonowar ana veya bainamih hina hitit, anayabin sabuw hio, “I koko’aw isan matar!” ");
INSERT INTO aai_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ofafar bai’obaiyenayah afa Jerusalemane hinan hio, “I biyanamaim i Wagabur Beelzebul hitarasum ema’am, imih Wagabur hai ukwarin fair itin Wagabur nunih tititit.” ");
INSERT INTO aai_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Imih Jesu e’af hina biyan hitit naatu oroubonamaim eo, “Satan boro mi’itube i taiyuwin nanun? ");
INSERT INTO aai_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tafaram ta’imon hinakusib rou’ab namatar hinabiyow i hai fair boro naririm, ");
INSERT INTO aai_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","na’atube ain uf rara’amaim hinakusib hinabiyow i hai fari boro naririm. ");
INSERT INTO aai_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Imih Demon Ana Aiwob wanawananamaim hinakusib taiyuwih hinabiyow, i hai aiwob boro nariririm, naatu boro nan yomanin nasawar. ");
INSERT INTO aai_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Men yait ta boro orot fairin ana bar nakwib narun ana sawar nabowamih, baise wantoro’ot orot fairin nab nafatum, imaibo boro narun ana sawar nabow. ");
INSERT INTO aai_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Turobe a tur ao’owen sabuw bowabow kakafih tisisinaf naatu baigigimen tur teo’o etei boro notawiyen hinab. ");
INSERT INTO aai_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Baise orot yait Anun Kakafiyin isan baigigimen tur nao’o boro men nanotawiyimih, anayabin i wanatowan ana bowabow kakafin sinaf ana ubar bai.’” ");
INSERT INTO aai_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu tur iti eo anayabin sabuw afa hi’o, “Afiy kakafin biyanamaim hitarasum tema’am.” ");
INSERT INTO aai_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Imaibo Jesu hinah naatu taitin hina hitit ufun hibat naatu tur hiyafar run isan. ");
INSERT INTO aai_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sabuw rou’ay gagamin Jesu hi’arbebera’uh hima’am himisir isan hio, “Ku’itin o hinat, tait ruburub etei ufun tebatabat, tekokok o hina’iti.” ");
INSERT INTO aai_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu iyafutih eo, “Ayu hinai, naatu ayu taitu i, iyab?” ");
INSERT INTO aai_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesu nuw sabuw nan ufun hima’am itih naatu eo, “Kwa iti kwama’am i ayu hinai naatu taitu. ");
INSERT INTO aai_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yait God ana kokomaim esisinaf i ayu taitu, ruburubu naatu hinai.” ");
INSERT INTO aai_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iban maiye Jesu harew Galilee sisibinamaim ana bai’ubaiyen bai tit. Sabuw i himour kwanekwan imih i wa afe’en yen mare naatu sabuw harew sisibin dones yan himarir ");
INSERT INTO aai_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","naatu i oroubonamaim sawar moumurih na’in i’obaiyih eo. ");
INSERT INTO aai_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kwananowar! Masaw bowayan ana masawamaim ub tanumamih in. ");
INSERT INTO aai_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Naatu ana ub tata’asi’asiy ana maramaim ub afa i ef yan hira’iy, naatu mamu hina hibow hi’aa. ");
INSERT INTO aai_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ub afa i karakarar yan kamar men gagamin yanamaim hira’iy, naatu saisewat hikuboubunih hiyen, anayabin me kikimin baban inu’in. ");
INSERT INTO aai_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Imih veya yen rararan ana mar ana fora’abinamaim, nati ub hikukubounih i hi’arat himorob, anayabin ah wairoron i men ra’iy me babanika. ");
INSERT INTO aai_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ub afa i fotan kokor wanawanan hira’iy, naatu ro’oh men matar, anayabin fotan yen fafa rab isuk. ");
INSERT INTO aai_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Baise ub afa i me gewasin yan hira’iy, naatu hikubounih hiyen hibiw, afa i magamagar 30 na’atube, afa i rubirubih 60 na’atube, naatu afa i hiwai re 100 na’atube.” ");
INSERT INTO aai_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naatu Jesu iuwih eo, “O yait tain nama’am na’at iti tur nanowar ininotanot.” ");
INSERT INTO aai_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu akisin ma’am ana maramaim ana bai’ufununayah nah 12 naatu sabuw afa iyab tur hinonowar hina hibatiy oroubon anayabin so’ob isan. ");
INSERT INTO aai_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naatu iuwih, “God ana aiwob ana buriburin i hibai kwa hit. Baise iyab no ufunamaim tema’am sawar etei i boro oroubonamaim hina’uwih. ");
INSERT INTO aai_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Saise, ‘i hinanuw naatu hinanuw maiye baise boro men hina’itin, tur hinanowar naatu hinanowar maiye. Baise hai not boro men nataseb naniyan hinab. Baise tur hinanowar hai yawas hinabobotabir Regah boro nanotawiyih!’” ");
INSERT INTO aai_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naatu Jesu i’uwih, “Kwa iti oroubon naniyan men kwanabaib na’at oroubon afa auman naniyah boro mi’itube kwanaso’ob? ");
INSERT INTO aai_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Masaw bowayan i God ana tur ub na’atube ta’asiy re. ");
INSERT INTO aai_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sabuw afa i ub ef yan ta’asi’asiyen hire’erebe, God ana tur tenonowar ufunamaim, Satan boro nan abisa re hai yawasamaim tatanum boro nabosair. ");
INSERT INTO aai_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Afa i ub karakarar yanamaim hire’erebe, tur gewasin tenonowar ana veya i boro matah nakabiy ereyasisir auman hinab. ");
INSERT INTO aai_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Baise i an wairoroh en, imih boro men maninaka nawainabih, anayabin tur gewasin hibaib isan ahay waf naatu bai’akir kakafin wanawanan hinarur ana maramaim i boro saisewat hinare. ");
INSERT INTO aai_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Naatu baise ub afa i fotan kokor wanawanan hire’erebe, i tur gewasin tenonowar, ");
INSERT INTO aai_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","baise i hai yababan biyah ana yasisir isan, totobuyoy ana baitenbibiren, naatu hai kok sawar ta ta men gewasih erun, tur gewasin hai yawasamaim erabirab, imih men ebiwamih. ");
INSERT INTO aai_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Naatu sabuw afa i ub me gewasin yanamaim hire’ere’ebe, tur hinowar hibasit hibai naatu hai yawasamaim ro’on matar, afa i 30, afa 60, naatu afa i 100.” ");
INSERT INTO aai_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Naatu i’uwih, “Kwa ramef kwabito’ab i noukwatamaim kwatatarafut? O gem babanamaim kwaya’iyai? Ai ana sisikofamaim kwasisikof? ");
INSERT INTO aai_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anayabin sawar abisa baibunuwenamaim ti’inu’in boro hinagatur, naatu sawar abisa wa’iwa’irih ti’inu’in boro hinatit hinibebeyan. ");
INSERT INTO aai_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","O yait tain nama’am na’at iti tur inanowar inanot!” ");
INSERT INTO aai_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ibanak iuwih maiye, “Kwananowar gewas! O sabuw kufufufunih na’atube, nati fufun ta’imonamaim boro God o nafufuni, baise boro afe’enamaim naya’abar auman nafufuni. ");
INSERT INTO aai_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yait aurin ema’am boro afe’en hinaya’abar hinitin, yait aurin en, abistanawat biyan ti’inu’in boro hinabosair.” ");
INSERT INTO aai_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ibanak eo maiye, “God ana aiwob i orot ub me yan tatanum na’atube. ");
INSERT INTO aai_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Fai mar in emimisir, i men so’ob ub i mi’itube kuboun yen erara’at. ");
INSERT INTO aai_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Me akisin ub ituw eyey, wantoro’ot i boro nakufufun, naatu naiwan nayai, imaibo boro niw ro’on namatar. ");
INSERT INTO aai_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Naatu sanabey ibiyamur ana maramaim, masaw bowayan boro ana nikok nab natit nan natar.” ");
INSERT INTO aai_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Naatu ibanak eo maiye, “God ana aiwob boro abisa’amaim tanayai tanao, o oroubon boro menatanamaim tanakubuna kwananowar? ");
INSERT INTO aai_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I ana itinin i momor ro’on kikimin maiyow na’atube, tafaramamaim iti ro’on i kikimin maiyow o boro me yan inatanum. ");
INSERT INTO aai_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Baise inatatanun ufunamaim, boro nara’at nayen masaw etei nanatabir, ai gagamin famefamen auman namatar, naatu famenamaim mamu boro hinan hinabatar.” ");
INSERT INTO aai_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oroubon maumurih na’in iti na’atube imaim binan sabuw hima hinowar, saife isah tirerereb naniyan hitab. ");
INSERT INTO aai_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sabuw isah i oroubonamaim eo hinonowar, baise nabinamaim oroubon hai yabih i ana bai’ufununayah eo hinonowar. ");
INSERT INTO aai_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nati veya ta’imon ana rabirab, i ana bai’ufununayah iuwih, “It i boro tanarabon harew rounane.” ");
INSERT INTO aai_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ana bai’ufununayah hire wa i afe’en ma’amamaim hisra’at. Naatu wa afa i nati’imaim auman hibatabat. ");
INSERT INTO aai_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hirarabon wowog tafair tit, naatu yabat misir, harew wa wanawanan iwan yen awan kakaratan. ");
INSERT INTO aai_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu wa uranane ukwarin kunuwar yara’ah matan fot inu’in. Ana bai’ufununayah hibunibun misir hiu, “Bai’obaiyenayan it morob isan men kunotanot?” ");
INSERT INTO aai_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Misir wowog naatu yabat kwarar eo, “Kwanutanub! Kwa’inbaibinub!” Naatu wowog morob ra’iy nuwarob eafuw. ");
INSERT INTO aai_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ana bai’ufununayah iuwih, “Aisim kwabirubir? Kwa men kwabitumatum?” ");
INSERT INTO aai_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ana bai’ufununayah hibir naatu taiyuwih hibabatiyih, “Iti orot i yait? Wowog naatu yabat hairi fanan hibai!” ");
INSERT INTO aai_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu ana bai’ufununayah bairi harew Galilee hirabon hina tafaram Gerasa imaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesu wa wanawanan tit bisure auman, mar ta’imonamo orot ta afiy kakafih hitounbubur ma’am rahane tit na biyan tit. ");
INSERT INTO aai_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iti orot i rahamaim in ma reremor, naatu sabuw murab fokarih anababatun hifafatum men karam. ");
INSERT INTO aai_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Anayabin mar etei an uman murab fokarihimaim tefafatumen, baise eyi erab an uman murab tetoro’oro’omen naatu aur tetatafofor, fair kwanekwan men karam boro hitarouh. ");
INSERT INTO aai_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Fai mar rahamaim naatu oyawemaim in ma itar koukuw taiyuwin biyan agimamaim bobeyabeyaten reremor. ");
INSERT INTO aai_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesu no ef yokaika nan itin, nunuw in nanamaim ra’iy sun yowen. ");
INSERT INTO aai_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Naatu fanan aumetawat na’in iwow eo, “O ayu biyau’umaim abisa kukokok, Jesu God auyom ma’ama’anin Natun? God wabinamaim abifefeyan men biyababan initu’umih!” ");
INSERT INTO aai_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anayabin Jesu iu, “O afiy kakafin orot biyanane kutit!” ");
INSERT INTO aai_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naatu Jesu ibatiy, “O wab i abistan?” Orot iya’afut eo, “Ayu wabu i ‘Kou’ay,’ anayabin aki i nai moumurih na’in.” ");
INSERT INTO aai_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Naatu Jesu fefeyan kikin men hikok boro tiyafarih hitatit tafaram nati hitihamiy. ");
INSERT INTO aai_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","For burut kakafin nati yubin heher ta sisibinamaim hima hi’u’ufar. ");
INSERT INTO aai_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Afiy kakafih Jesu hifefeyan hio, “Karam boro iti yafari atan for wanawanah atarun?” ");
INSERT INTO aai_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu afiy kakafih baibasit itih, orot biyanane hitit hin for wanawanah hirun, for 2,000 na’atube heher sisibin hinunuw hira’iy harew yan hire hi’ar tomatom himorob. ");
INSERT INTO aai_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Orot iyab hima for hibituw hinunuw hin bar merar gagamin naatu bar merar afa hai tur hi’owen. Naatu sabuw abisa mamatar itininamih hitit hina. ");
INSERT INTO aai_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hina Jesu biyan hitit hinuwanuw orot afiy kakafih hitounbububur ma’am, i boun ana not rumutufur faifuw gewasin iyoun mare ma’am hi’i’itin ana maramaim hibir. ");
INSERT INTO aai_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sabuw iyab matah yan orot afiy hitounbububur ma’am isan mi’itube mamatar, naatu for isah abisa mamatar hi’i’itan sabuw hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naatu sabuw Jesu hifefeyan hai tafaram baihamiyinamih hiu. ");
INSERT INTO aai_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu wa afe’en yenamih orot afiy hitounbububur ma’am na Jesu ifefeyan hairi namih. ");
INSERT INTO aai_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Baise Jesu men ibasit, naatu orot iu, “O kwen a bar hinat tamat naatu taituwa, Regah ana gewasin o isa sisinaf naatu ana kabeber bit i hai tur ku’owen.” ");
INSERT INTO aai_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basit orot nati’imaim ihamiyih Bar Merar Etei Umat Roron imaim remor Jesu mi’itube biyawas sabuw hai tur eowen, naatu sabuw hinonowar i hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu ibanak maiye wa isra’at rabon harew rounane hitit, naatu re riy sisibin bat, imaibo sabuw moumurih na’in hina hi’arbebera’uh. ");
INSERT INTO aai_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Naatu Kou’ay bar ana ukwarin orot wabin Jairus na tit, nuw Jesu i’itin ana maramaim na anamaim ra’iy. ");
INSERT INTO aai_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naatu fefeyan kikin eo, “Ayu natu babitai i emomorob, akokok inan umamaim au kek biyan inabutun saise nayawas!” ");
INSERT INTO aai_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naatu Jesu orot Jairus hairi hin, sabuw himour kwanekwan hibi’ufunun naatu yaten hiyey. ");
INSERT INTO aai_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wanawanahimaim i babin ta, baibin hai sawow bai ma kwamur etei 12 sawar. ");
INSERT INTO aai_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I’akir manin na’in, adanafur bowayah ta ta isah run tit kabay gagamin na’in ibaiyanih, baise men yawas ta tita’ur ana sawowone i rara’at sasa. ");
INSERT INTO aai_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesu ana tur nowar, naatu sabuw wanawanahimaim inan babin Jesu ufunane tit ana faifuw butubun. ");
INSERT INTO aai_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Anayabin i na’at not, “Ayu ana faifuw ana butubun boro ana yawas.” ");
INSERT INTO aai_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naatu bubutubun mar ta’imonamo rara nununuw nutanub naatu biyan wanawanan naniyan tatatam nati bai’akirane yawas. ");
INSERT INTO aai_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesu fair biyanane titit i naniyan tatam, sabuw wanawanahimaim tatabir ibatiyih, “Yait ayu au faifuw butubun?” ");
INSERT INTO aai_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana bai’ufununayah hiu, “O sabuw moumurih na’in yate teyey, naatu baise o kubibat, yait ayu butubuni?” ");
INSERT INTO aai_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Baise Jesu bat inuwanuw menatan sisinaf itininamih. ");
INSERT INTO aai_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naatu babin biyanamaim abisa mamatar i so’ob, imih tit Jesu nanamaim ra’iy an uman hi’oror mi’itube isan mamatar etei eorerereb. ");
INSERT INTO aai_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Naatu babin iu, “Natu, o abaitumatumamaim iyawasi, tufuwamaim kwen, a bai’akirane o arufami kutitit.” ");
INSERT INTO aai_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu bat eo’o auman, sabuw afa Kou’ay Bar orot ukwarin ana barene hina Jairus hiu, “O natu babitai i morob, Bai’obaiyenayan men inarowenbibibir.” ");
INSERT INTO aai_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Abisa hio Jesu nowar, natu Jairus iu “Men inabir o initumatum.” ");
INSERT INTO aai_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sabuw etei eotanih hima, i Peter, James naatu John akisihimo iuwih bairi hin. ");
INSERT INTO aai_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hina Jairus ana bar hititit ana veya sabuw yababan gagamin na’in buwih fanah aumetawat na’in hima hirererey Jesu nowar. ");
INSERT INTO aai_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Naatu bar wanawanan run sabuw iuwih, “Kwa aisim kwarererey? Iti kek i men morobomih, i matan fot inu’in.” ");
INSERT INTO aai_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Baise sabuw Jesu eo isan himarib. Naatu Jesu sabuw iuwih ufun hitit, kek hinah tamah naatu ana bai’ufununayah akisihimo hirun hin kek inu’inumaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kek babitai umanamaim bai naatu iu, “Talitha koum!” Nati anayabin i iti na’atube, “Babitai kafai o au’uwi kumisir!” ");
INSERT INTO aai_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mar ta’imonamo babitai misir an yan bat remor, babitai ana kwamur 12 iti mamatar i hi’oror sa’ir hai kasiy ra’at hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu ofafarih uwih eo, “Men sabuw hai tur kwana’owenamih, bay kwabai babitai kwaitin eaan.” ");
INSERT INTO aai_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu efan nati ihamiy matabir maiye ana bai’ufununayah hitur bairi hina ana bar ana merar hitit. ");
INSERT INTO aai_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Baiyarir ana veya Kou’ay Baremaim busuruf sabuw i’obaibiyih, naatu sabuw moumurih ana tur hinonowar i hifofofor naatu hio, “Iti orot menamaim kirum so’ob? Naatu not rerekab yait itin ina’inanen fokarih esisinaf? ");
INSERT INTO aai_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iti orot i bar wowabayan. Mary natun taitin James, Joseph, Judas naatu Simon, ruburubun baibitar iti’imaim bairit tama’am?” Iti na’atube hio naatu hikwahir. ");
INSERT INTO aai_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Naatu Jesu hai tur eowen bar merar afa’amaim dinab orot i tekakakafiy, baise orot taiyuwin ana bar merar, ana sabuw, ana rara men tekakakafiy. ");
INSERT INTO aai_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naatu ana bar meraramaim ina’inan men ta sinaf, sawusawuwih bai’abamo biyah botobonen hiyawas. ");
INSERT INTO aai_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sabuw men hibitumatum isan Jesu ifofofor men kafai ta. Naatu bar merar afa run tit sabuw i’obaibiyih remor. ");
INSERT INTO aai_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana bai’ufununayah nah 12 eafih hina hitit afiy kakafih nunih isan fair itih naatu orot rouru’ab iyafarih hitit. ");
INSERT INTO aai_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Naatu iuwih, “Remor kwanabubusuruf a tu akisin kwanab, men sawar ta, men rafiy, men hafoy, naatu men kabay ta kwanab naiw a kikiramaim kwanarobere. ");
INSERT INTO aai_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","A baibiyon kwaniyoun, baise biya baibiyon men bairou’abin kwanab.” ");
INSERT INTO aai_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Naatu iuwih, “Bar merar menatan kwarur imaim kwanama kwanabow nanan a veya nab imaibo nati bar merar kwanihamiy. ");
INSERT INTO aai_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Naatu efan menamaim a merar men hinay hinabubuwi, o fana men hinanonowar kwana’orarafih kwanana’ufut tafaram kwanihamiy kwanan, nati i hai baimatnuwen!” ");
INSERT INTO aai_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basit hitit hin bowabow kakafihine dogor baikitabiren isan hibinan. ");
INSERT INTO aai_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wagabur moumurih maiyow hinunih hitit naatu sawusawuwih moumurih na’in biyah raiy hirarouw etei hiyawas. ");
INSERT INTO aai_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesu wabin ra’at aiwob orot Herod nowar, anayabin sabuw afa hio’o Iti i John Baptist morobone misir maiye, imih biyanamaim fair ma ina’inanen ta ta sinaf temamatar. ");
INSERT INTO aai_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Afa hio, “Iti i Elijah. Afa ibanak hio’o, ‘Iti i marasika dinab orot ta na tit.’” ");
INSERT INTO aai_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Baise Herod nonowar ana maramaim eo, “John sikan abuburu’um i morobone misir maiye?” ");
INSERT INTO aai_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Anayabin Herod taiyuwin iuwih John hifatum hibai hin dibur baremaim hiyaru’uy. Iti sisinaf ana’an i Herod tain Philip aawan bi’awan isan. ");
INSERT INTO aai_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Anayabin Herod tain aawan bi’aawan isan John gam tur fokarin maiyow eo, “O i ofafar iastu’ub yawas kakafin kusisinaf.” ");
INSERT INTO aai_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Imih Herodias yan so’ar kok kwanekwan boro John ta’asabun, baise ef men ta ma boro tasinaf. ");
INSERT INTO aai_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Baise Herod i John isan birubir anayabin i so’ob John i orot kakafiyin, ana yawas mutufurin imih tatafafar, John binan Herod nonowar ana not i’afiy baise Herod ana kok i John tabinan i tanowar. ");
INSERT INTO aai_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Basit veya gewasin ta Herod tutufuw ana veya baiyasisir isan hiyuw bogaigiwas, ana sabuw nukwanukwarih, baiyowayah nukwanukwarih, naatu Galilee wanawanan sabuw gagamih etei e’af ayuwih. ");
INSERT INTO aai_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nati’imaim Herodias natun babitai na run benaben Herod ana nanawan sabuw hiru’ay hima’am etei hiyasisir men kikimin ta. Naatu aiwob babitai iu, “Abisa kukokok inifefeyan ayu boro anit?” ");
INSERT INTO aai_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naatu babitai isan eobaifaro eo, “Abisa isan inifefeyan au aiwob turin auman boro anit.” ");
INSERT INTO aai_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Babitai in hinah ibatiy, “Ayu boro abisa isan anifefeyan?” Hinah iya’afut iu, “John Baptist ukwarin!” ");
INSERT INTO aai_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Babitai matan kabiy in aiwob biyan tit ifefeyan eo, “Ayu akokok John Baptist ukwarin tew yan inayai iti boun inab inan initu.” ");
INSERT INTO aai_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aiwob orot yababan gagamin bai, baise men karam sabuw matahamaim babitai isan eo’obaifaro ta’astu’ub. ");
INSERT INTO aai_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mar ta’imonamo tur iyafar sika afu’afuw orot iyun in John dibur baremaim ma’am sikan buru’um. ");
INSERT INTO aai_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Naatu ukwarin tew yan iwan bai na babitai itin imaibo bai in hinah itin. ");
INSERT INTO aai_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John ana bai’ufununayah tur hinonowar ana veya hina biyan hibai hin rahamaim hiyai. ");
INSERT INTO aai_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tur Abarayah himatabir hina Jesu biyan hitit mi’itube hibowabow naatu sabuw hibi’obaiyih ana tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Naatu Jesu iuwih eo, “Tarabon tan efan sira’utubinamaim mar kafai taniyarir. Anayabin sabuw moumurih Jesu isan hirun hititit, ana bai’ufununayah bay men karam boro hitaa. ");
INSERT INTO aai_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Imih akisihimo wa afe’en hisra’at hin efan ana sira’utubinamaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Baise hinan sabuw moumurih na’in hi’itih hi’inanih, naatu hai bar hai merar hihamiyen aunah hi’iyon hina hima isan hikakaif na run, ");
INSERT INTO aai_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","wa’ane bisure auman sabuw kou’ay gagamin hima’am itih iyababan, anayabin iti sabuw i sheep na’atube aurih nabatanenayan en, naatu busuruf sawar moumurih na’in i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Veya ra’iy birabirab auman, ana bai’ufununayah hina biyan hitit hio, “Iti efan i yok na’in naatu veya i sawar, ");
INSERT INTO aai_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","sabuw kwiyafarih ten bar merar afa iti yubinamaim naatu masaw baremaim bay hinatobon hinaa.” ");
INSERT INTO aai_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Baise Jesu iyafutih eo, “Kwa a efanamaim abisa ema’am i kwaitih te’aan.” Naatu hiya’afut hio, “Bay nati na’atube i boro sumar etei eight orot ta’imon ana baiyan ana fofonin tanatobon sabuw tanituwih.” ");
INSERT INTO aai_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu ibatiyih, “Kwa rafiy fafar bai’ab isa tema’am? Kwan kwa’itin.” Hin hiso’ob hina ana tur hi’owen rafiy fafar etei five naatu siy rou’ab. ");
INSERT INTO aai_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Imaibo Jesu eo, “Sabuw kwa’uwih matan, matan fotan gewasin yan timarir.” ");
INSERT INTO aai_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naatu sabuw hi’uwih matan, matan fotan gewasin yan himarir, afa 100 na’atube afa 50 na’atube. ");
INSERT INTO aai_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu rafiy five naatu siy rou’ab auman bow au mar nuw ra’at God ana merar yi imseseben ana bai’ufununayah itih hibow sabuw hifaramih. ");
INSERT INTO aai_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sabuw etei nati bay hi’aa hai fofonin bai. ");
INSERT INTO aai_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ana bai’ufununayah rafiy rebarebah, naatu siy turih sabuw hi’aa hibow sakasak etei 12 hiwan foten. ");
INSERT INTO aai_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oro’orot bay hi’aa i etei 5,000. ");
INSERT INTO aai_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mar ta’imonamo Jesu ana bai’ufununayah iuwih wa hisra’at au Bethsaida wan iyafarih hirabon naatu i baise ma sabuw itubabarih hai ubar hin. ");
INSERT INTO aai_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sabuw itubarih hinan ufunamaim yoyobanamih yen in oyaw wan tit. ");
INSERT INTO aai_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Birabirab auman wa re in kuyowen naatu Jesu akisinamo i me yanamaim ma. ");
INSERT INTO aai_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ana bai’ufununayah i’itih i hiboy hibi’akir, anayabin yourabad nahine bababin, mar tot auman Jesu tit riy yan bat remor in biyah tit tanatabirihimih. ");
INSERT INTO aai_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Baise hinuw harew yan bat remor nan hi’itin ana veya wagabur mowan ta hirouw hitar koukuw. ");
INSERT INTO aai_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Anayabin Jesu iti na’atube sinaf hi’itin i hibir men kikimin ta, baise Jesu matan kabiy iuwih eo, “Ya hinakwat! Men kwanabirumih! Ayu anan.” ");
INSERT INTO aai_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naatu wa afe’en yen nuwarob eafuw ana bai’ufununayah hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Anayabin rafiy bimasib ana kirikirifot men hiso’ob, baise dogorohine i fokar. ");
INSERT INTO aai_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Naatu harew hirabon tafaram Genesaret imaim hirun hai wa hirouw, ");
INSERT INTO aai_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","wa’ane hitit hirara’iy ana veya sabuw Jesu hi’itin hi’inan. ");
INSERT INTO aai_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naatu nati tafaram wanawanan sabuw himatkabikabiy hinunuw sawusawuwih emo’em hiwan hi’abar Jesu ana tur hinonowar imaim hi’abar hin. ");
INSERT INTO aai_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bar merar kikimin o gagamin, naatu masaw bar imaim inan ana tur hinonowar, sawusawuwih hibow hitit ahar efanamaim hiya hifefeyan hai kok i mi’itube ana waifuw yomaninawat hitabutubun. Naatu sabuw etei Jesu hibubutubun iyawasih. ");
INSERT INTO aai_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pharisee naatu Ofafar bai’obaiyenayah afa Jerusalemane hinan hina Jesu hibebera’uh. ");
INSERT INTO aai_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naatu ana bai’ufununayah umah souwena’e eregubagub auman hi’aa hitomatom hi’itih. ");
INSERT INTO aai_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee naatu Jew sabuw etei’imak i hai binanakwar ti’ufunun hai a’agir hi’o na’atube umah tesouwenabo te’aau. ");
INSERT INTO aai_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ahar efanane tenan boro men abistan hina’aan, baise wantoro’ot i boro hinakif nakusouwih, naatu hai binanakwar afa maumurih maiyow tebi’ufunun, boun kerowas, naukwat, ya’aya baibitab ana noukwat, i na’atube tesasouwen. ");
INSERT INTO aai_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Imih Pharisee naatu Ofafar bai’obaiyenayah Jesu hibatiy, “Aisimamih o abai’ufununayah bai’obaiyen it ata a’agir hibai nan men tibi’ufununimih, naatu baise i umah gubagub auman te’aau?” ");
INSERT INTO aai_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iyafutih eo, “Isaiah kwa arerekabih isan eo i turobe, Bukamaim eo kikirum na’atube, ‘Iti sabuw awahimaim ayu tekakafiyu, baise dogoroh ayu isau i ef yokaika inu’in. ");
INSERT INTO aai_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I hai kwafiren ayu isau i yabin en, anayabin i hai bai’obaiyen i orot ofafar hiya’aya imaim tebi’obaibiyih!’ ");
INSERT INTO aai_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kwa God ana obaiyunen kwabosair sa’ab kwayai naatu orot hai bai’obaiyen kwabai kwabukikin kwanan.” ");
INSERT INTO aai_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Naatu Jesu iuwih eo, “Kwa God ana obaiyunen bosairen sa’ab ya’in naatu taiyuw abinanakwar bai’ufnunin isan i kwaso’ob kwanekwan! ");
INSERT INTO aai_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses na’atube eo, ‘hinat tamat inakakafiyih, yait ta hinah tamah erarafih i boro hina’asabun namorob.’ ");
INSERT INTO aai_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Baise o ta hinat tamat isah iti na’atube inao, abistan ayu’une kwa abibaisi i God ana sibor yayasairen. ");
INSERT INTO aai_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tur nati na’atube nao, naatu boro men kafa’imo hinah tamah isah abisa ta nasinafumih. ");
INSERT INTO aai_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwa a’a’agir hai binanakawar kwabukikin naatu God ana tur i kamomow ebi’en naatu sawar afa moumurih maiyow auman nati na’atube kwasisinaf.” ");
INSERT INTO aai_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iban maiye Jesu sabuw rou’ay gagamin eafih hina iuwih eo, “Kwa etei iti tur anao i kwananowar naniyan kwanab. ");
INSERT INTO aai_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Men sawar iti ufunane en orot wanawanan irun iwa’an gub kakafin etatounimih, baise abisa orot wanawananane etitit imaim iwa’an orot gub kakafih etatoun. ");
INSERT INTO aai_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tain hinama’am na’at tur kwanonowar kwananot.” ");
INSERT INTO aai_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sabuw rou’ay gagamin ihamiyih in bar rur ufunamaim ana bai’ufununayah iti oroubon isan hibatiy. ");
INSERT INTO aai_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iuwih eo, “Kwa auman boro’ika kwakakasiy? men abistan ta ufunane en erun iwa’an gub kakafin orot etatounimih. ");
INSERT INTO aai_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Anayabin men orot dogoronamaim erurumih, baise en yan kabutin wanawanan erur naatu eafuwatait ere’er.” Iti na’atube eo ana maramaim Jesu kurerereb eo, “Bay etei’imak i gewasih kwanaa.” ");
INSERT INTO aai_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Naatu ibanak eo maiye, “Abistan orot wanawananane etitit imaim iwa’an i’isan gub kakafin etatoun. ");
INSERT INTO aai_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Anayabin orot dogoron wanawanantoro’ot etitit, i not kakafin, sesebar, bar kweb, asabunubunuw, turahinah a’aawah ufuh na, ");
INSERT INTO aai_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kabat, tur karur, tenagogor, baiwa’an ana yeyewra’aten, bahiy, koutabitabir, bai’o’orot, naatu baifufuwen. ");
INSERT INTO aai_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iti not kakafih etei’imak i orot wanawanane enan imaim iwa’an i’isan gub kakafin etatoun.” ");
INSERT INTO aai_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu efan nati ihamiy in tafaram Taiya wanawananamaim tit, naatu bar wanawanan run, men kok sabuw hitaso’ob i nati’imaim ma’am, baise men karam boro yumatan tibun. ");
INSERT INTO aai_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nati’imaim babin natun babitai kikimin afiy kakafin tarasum ma bi’a’afiy Jesu ana tur nowar na biyan tit anamaim ra’iy. ");
INSERT INTO aai_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Babin i Greek matuwan, baise ana tufuw an i Fonisia imaim tufuw tafaram Syria wanawanan, i Jesu ifefeyan natun biyanamaim afiy kakafin tanun tatit isan. ");
INSERT INTO aai_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Baise Jesu babin isan eo, “Wantoro’ot i boro kek abisa tekokok tanituwih, men ef ema’am boro kek hai bay tanab tanarub haru nahimaim nare hinab hina’aan.” ");
INSERT INTO aai_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Baise babin eo, “Turobe Regah baise kek hai bay te’aa momosarih gem baban tere’er haru te’aau.” ");
INSERT INTO aai_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Imaibo Jesu babin iu, “O abaiya’afotenamaim imih kwen, afiy o natu ihamiyika.” ");
INSERT INTO aai_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Babin matabir in ana bar tit ana kek gem yan inu’in itin afiy ihamiy titaka. ");
INSERT INTO aai_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Imaibo Jesu tafaram Taiya ihamiy Sidon wanawananamaim remor in Galilee harew kukuf yan re, naatu rabon Bar Merar Etei Umat Ronron hai me yan tit. ");
INSERT INTO aai_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nati’imaim sabuw afa orot tainin gugurin, naatu menan sarusarubet i hibai hina Jesu biyan hitit naatu uman biyan tabutubun isan hifefeyan. ");
INSERT INTO aai_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Imih Jesu orot bai tit sabuw rou’ay gagamin ihamiyih akisinamo nabinamaim, naatu uman orot tainin wanawanan iuturiy, imaibo kwaitutur naatu orot menan butubun. ");
INSERT INTO aai_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Matan au mar nuw ra’at dogoron tutufin erawous naatu orot isan eo, “Efata,” anayabin “Kubotawiy!” ");
INSERT INTO aai_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mar ta’imonamo orot tainin botawiy tur nowar naatu menan yamutufur tur eo gaigiwas. ");
INSERT INTO aai_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Naatu Jesu sabuw eotanih eo, “Men yait ta ana tur kwana’owen.” Baise i mar etei sisinaf imih mar etei isan hio. ");
INSERT INTO aai_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sabuw anababatun hai kasiy ra’at hifofofor men kafaita, naatu hio “Sawar etei’imak sinafen gewas! Naatu i karam boro niwa’an tainih gugurih tur hinanowar naatu awah gugih tur hinao!” ");
INSERT INTO aai_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Veya nati wanawananamaim sabuw rou’ay gagamin tabo hiru’ay maiye. Nati ana maramaim sabuw isah men abistan ta ma’am boro hita’aan aurih bay en. Jesu ana bai’ufununayah eafih hina biyan hitit naatu iuwih eo, ");
INSERT INTO aai_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ayu sabuw iti ai’itih abiyababan anayabin hina bairi ama’am veya tounu sawar naatu boun boro abistan hina’aan. ");
INSERT INTO aai_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ayu a murumurubih aniyafarih au bar hinanan, asir boro efamaim bayumih matah nabib anayabin sabuw afa ef yok hina.” ");
INSERT INTO aai_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naatu bai’ufununayah Jesu hiya’afut hi’u, “Iti i arar yan tama’am, bay boro menamaim tanab sabuw tanituwih?” ");
INSERT INTO aai_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu ibatiyih eo, “Bo kwa aur rafiy bai’ab tema’am?” Ana bai’ufununayah hiya’afut hio, “Rafiy fafar etei umat roun rou’ab.” ");
INSERT INTO aai_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesu sabuw iuwih me yan himarir naatu rafiy fafar etei umat roun rou’ab bow God ana merar yi naatu imseseb ana bai’ufununayah itih hibow sabuw hifaramih. ");
INSERT INTO aai_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na’atube siy gidigidih matan ta auman bow God ana merar yi naatu ana bai’ufununayah iuwih hibow sabuw hifaramih. ");
INSERT INTO aai_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sabuw etei’imak hi’aa hai fofonin bai, naatu bay hi’aa ufunamaim momosarih bai’ufununayah hibiwanen sakasak etei umat roun rou’ab awah hikartanen. ");
INSERT INTO aai_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sabuw etei i 4,000 na’atube hiru’ay, imaibo Jesu sabuw iyafarih hai ubar hin. ");
INSERT INTO aai_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Naatu Jesu ana bai’ufununayah bairi wa tafan hiyen hin tafaram Daramanuta wanawananamaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee afa hina Jesu biyan hitit hibusuruf hibabatiy baikubibiruwin isan, hai kok i ina’inan ta marane tasinaf hita’itin. ");
INSERT INTO aai_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu kwairin tom naatu iyafutih eo, “Aisim iti boun ana sabuw ina’inanen itin isan tefefeyan? Anababatun a tur ao’owen, ina’inan ta boro men iti boun ana sabuw isah ana sinaf hina’itinimih!” ");
INSERT INTO aai_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basit nati’imaim sabuw ihamiyih wa afe’en yen rabon harew kukuf rewan rounane. ");
INSERT INTO aai_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bai’ufununayah nuhih bur rafiy ta baina’e i rafiy fafar ta’imonamo hibai hitit wa hisra’at hirabon. ");
INSERT INTO aai_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu iten ya’ih eo, “Mata toniwa’an kwanakaifi gewas, Pharisee naatu Herod bairi hai faraw ra’ara’at wabin yeast isan.” ");
INSERT INTO aai_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naatu bai’ufununayah taiyuwih hima hibabatiyih, “Iti eo anayabin it rafiy ta men tabai tanan isan.” ");
INSERT INTO aai_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu so’ob i abistan isan hima hio, imih ibatiyih, “Aisim rafiy baina’e tanan isan kwama kwao’o? Kwa mata men toiwa’an naatu tur naniyan men kwabaib? Dogor boro’ika tefofokar? ");
INSERT INTO aai_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mata ema’am baise men kwa’i’itin, tain ema’am baise men kwanonowar? Naatu men kwanotanot, ");
INSERT INTO aai_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ayu rafiy fafar etei umat roun rou’ab abow aimseseb sabuw etei 5,000 abituwih bay rebarebah sakasak bai’ab kwaiwanfoten?” Bai’ufununayah hiya’fut hio, “Sakasak etei 12. ");
INSERT INTO aai_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bo rafiy etei umat roun rou’ab abow aimseseb sabuw 4,000 abituwih bay rebarebah sakasak bai’ab kwaiwanfoten?” ");
INSERT INTO aai_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ana bai’ufununayah hiya’afut hio, “Sakasak etei umat roun rou’ab.” Jesu iuwih eo, “Kwa i boro’ika kwakakasiy.” ");
INSERT INTO aai_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hina tafaram Bethsaida hitit imaim sabuw afa orot matan fim hibai hina Jesu biyan hitit butubunin isan hifefeyan. ");
INSERT INTO aai_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu orot matan fim uman bai hairi bar merar hihamiy hitit hin sa’ab, Jesu orot matan kwaitutur uman matanamaim rumum naatu ibatiy, “Sawar afa ku’i’itah?” ");
INSERT INTO aai_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Orot nuw ra’at naatu eo, “U, ayu sabuw ai’itih, baise ai’itih i boun ai’ibe hibat tereremor.” ");
INSERT INTO aai_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu iban maiye umanamaim orot matan rumum. Imaibo orot matan kubuna nuw naatu sawar itih gewagewas. ");
INSERT INTO aai_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu orot ana ubar biyafar iu, “Men ina’intabir maiye inan nati bar merar inatitamih.” ");
INSERT INTO aai_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naatu Jesu ana bai’ufununayah bairi hin bar merar Caesarea Philip i wanawananamaim hitit, efamaim hinan ana bai’ufununayah ibatiyih, “Kwao anowar, sabuw ayu isou i mi’itube te’o kwanonowar?” ");
INSERT INTO aai_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hiya’afut hio, “Sabuw afa te’eo o i John Baptist, afa Elijah, naatu afa i dinab orot ta.” ");
INSERT INTO aai_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naatu Jesu ibatiyih, “Bo kwa mi’itube ayu isou kwa’o?” Peter iya’afut eo, “O i Roubininenayan.” ");
INSERT INTO aai_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Naatu Jesu eofafarih eo, “Men yait ta ana tur kwana’owen ayu isou.” ");
INSERT INTO aai_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naatu Jesu busuruf ma i’obaibiyih eo, “Orot Natun i boro sawar moumurih wanawanan narun ni’akir. Jew sabuw hai ukwarih, firis ukwarih, ofafar kirumayah boro hinakwahir naatu hinarab namorob, baise veya tounu ufunamaim boro namisir maiye.” ");
INSERT INTO aai_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tur bebeyan iti na’atube eo hinowar, Peter bai hairi hin sa’ab naatu busuruf Jesu kwarar eofafar. ");
INSERT INTO aai_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Baise Jesu tatabir ana bai’ufununayah isah nuw naatu Peter kwarar iu, “Au’uf kwen Satan mowan, o a not i men Godane enan, baise orotone enan.” ");
INSERT INTO aai_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu ana bai’ufununayah sabuw bairi eafih hina biyan hitit naatu iuwih eo, “Yait nakok ayu bai’ufununu’umih taiyuwin nakwahir ana onaf na’abar ayu ni’ufnunu. ");
INSERT INTO aai_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anayabin orot yait taiyuwin ana yawas ebobotan boro nikasiy, baise orot yait ayu wabu isan naatu tur gewasin isan ana yawas nakwakwahir boro natita’ur. ");
INSERT INTO aai_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Orot tafaram tutufin etei nab nabiyasisir wanawanan i namomorob ana gewasin boro abisa nab? ");
INSERT INTO aai_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Men abisa ta ema’am boro orot nab ana yawas natubun nab maiye. ");
INSERT INTO aai_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Anayabin iti boun i veya kakafin, God bat ufutin naatu tenagogor i erara’at, imih yait ayu isou naatu au tur isan biya na’ohow, Orot Natun boro obo isa biyan na’ohow Tamah ana marakaw wanawanan ana tounamatar kakafiyih bairi hinanan ana veya’amaim.” ");
INSERT INTO aai_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu sabuw iuwih eo, “Turobe a tur ao’owen kwa afa iti kwama’am boro morobo’e yawas kwanama’am maramaim God ana aiwob fairin boro nanan kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Veya etei six sasawar ufunamaim Peter, James naatu John, Jesu buwih bairi akisihimo hiyen hin oyaw tafantoro’ot hitit. Nati’imaim matah yan hi’itin Jesu ana yumat botabir. ");
INSERT INTO aai_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naatu ana faifuw hina hikwes anababatun, men karam tafaramamaim orot babin ta na’atube tasouwen hitikwes. ");
INSERT INTO aai_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nati’imaim Elijah, Moses hairi hirerereb Jesu bairi hibat hio’o bai’ufununayah nah tounu hi’itih. ");
INSERT INTO aai_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter Jesu isan eo, “Regah aki bairi tanan i gewasin maiyow, aki boro sis tounu ana wowab, ta o isa, ta Moses isan, naatu ta Elijah isan.” ");
INSERT INTO aai_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nah tounu hai bir ra’at Peter tur erekasiy auman eo kwanekwan. ");
INSERT INTO aai_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naatu sakuk earuw na ana youninamaim tarsumih naatu sakuk wanawanan orot fanan hinowar eo, “Iti i ayu Natu au yabow, tain kwanarub nao kwananowar!” ");
INSERT INTO aai_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Naatu matah doda iwa’an hibat hibinuwanuw men yait ta hi’itin, baise Jesu akisinamo bairi hibatabat hi’itin. ");
INSERT INTO aai_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Oyawane hire hinan auman abisa hi’itin isan Jesu tur fokarin maiyow eofafarih eo, “Men yait ta ana tur kwana’owen kwanama’am Orot Natun morobone namisiribo.” ");
INSERT INTO aai_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesu abistan eo i fanan hibai, baise morobone misir maiye eo anayabin hikasiy taiyuwih hima hibabatiyih. ");
INSERT INTO aai_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Imaibo Jesu hibatiy, “Aisim Ofafar bai’obaiyenayah hio Elijah i boro wan nan?” ");
INSERT INTO aai_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu iyafutih eo, “Kwanaso’ob Elijah i wan Roubininenayan orot aunan i’iyon na sawar etei yabuna, baise aisimamih Bukamaim hikikirum hio, ‘Orot Natun nanan i boro hinakwahir naatu bai’akir gagamin na’in nab.’ ");
INSERT INTO aai_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Baise a tur ao’owen, Elijah i marasika na naatu sabuw hai kokomaim yawas kakafin maiyow isan hisinaf mi’itube Bukamaim eo na’atube.” ");
INSERT INTO aai_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hire hinan ana bai’ufununayah afa bairi hibita’imon ana veya sabuw hiru’ay hi’a’ar bebera’uh hi’itih. Naatu Ofafar bai’obaiyenayah afa auman hina hibusuruf bairi higam. ");
INSERT INTO aai_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sabuw hiru’ay Jesu hi’i’itin ana veya hifofofor men kafaita naatu hinunuw hin hibai ana merar hiyi. ");
INSERT INTO aai_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu ana bai’ufununayah ibatiyih, “Abistan isan bairi kwagamigam?” ");
INSERT INTO aai_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Orot ta kou’ay wanawanan iya’afut eo, “Bai’obaiyenayan ayu au kek abai ana o isa, anayabin afiy kakafin iwanasum awan bofafaren tur men eo’omih. ");
INSERT INTO aai_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naatu afiy kakafin kaun eyey ana veya ebai erouw me yan ere awan fusifusin ekubar naatu wan eyob takitak tebiwa’an naatu an uman etei’imak tewowofaf. Ayu a bai’ufununayah afiy kakafin nuninamih auwih, baise men karam hitasinaf.” ");
INSERT INTO aai_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu iuwih eo “Kwa iti boun ana sabuw ayu men kwabitutumu, mar boro bai’ab bairi tanama? Ayu boro men manin kwa bairit tanama tanabow? Kek kwabai kwana aitin.” ");
INSERT INTO aai_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kek hibai hina Jesu biyan hitit, afiy kakafin nuw Jesu i’itin ana veya kek busuruf an uman duduwar rab naatu me yan re rab firur awan fusifusin kubar. ");
INSERT INTO aai_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu kek tamah ibatiy, “Iti kek sawow maninaka bai ma?” Tamah iya’afut eo, “Tasiyar ana mareika sawow bai, ");
INSERT INTO aai_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","matan fufur asabuninamih ebai en wairaf wan eyey naatu harew yan ere’er, baise o baiyawasin isan isa nakakaram na’at basit kwiwanbabanu baibais kwiti.” ");
INSERT INTO aai_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu iya’afut eo, “Karam, o inabitumatum na’at sawar etei o isa boro hamehameh maiyow hinamatar.” ");
INSERT INTO aai_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kek tamah mar ta’imonamo iya’afut eo, “Ayu abitumatum baise kwibaisu au baitumatum tafan kuya’abar era’at.” ");
INSERT INTO aai_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu sabuw i’itih i hina yaten hiyey, imih Jesu afiy kakafin isan tur fokarin maiyow eaf iu, “O afiy tain gugurin awa gugin au’uwi kek biyanamaim kwihamiy kutit naatu men ina’intabir inarun maiye!” ");
INSERT INTO aai_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Afiy kakafin iwow itarakouw kek busuruf an uman duduwar rab, naatu afiy kakafin rauwatait bihir kek re imamayay in, naatu sabuw hinot i morob hirouw. ");
INSERT INTO aai_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Baise Jesu na ofere kek uman bai ibais imisiruw misir. ");
INSERT INTO aai_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nati ufunamaim Jesu bar wanawanan run naatu ana bai’ufununayah wa’iwa’iramaim hibatiy, “Aisim aki afiy kakafin men anun titamih?” ");
INSERT INTO aai_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu iyafutih eo, “Men abistanamaim boro sawar iti na’atube hinamataramih, baise yoyoban akisinamo.” ");
INSERT INTO aai_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesu ana bai’ufununayah bairi nati efan hihamiy, i hibusuruf Galilee wanawanan hiremor hin. Jesu men kok sabuw etei hitaso’ob i menamaim hinan. ");
INSERT INTO aai_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Anayabin i ana bai’ufnunenayah bi’obaibiyih. Naatu ana bai’obaiyenamaim iuwih eo, “Orot Natun boro hinabonawiy gawan umahimaim hinayai naatu hina’asabun namorob, veya tounu ufunamaim boro namisir maiye.” ");
INSERT INTO aai_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bai’ufnunenayah iti tur bi’obaiyih naniyan men hibai naatu baibatiyin isan hibir. ");
INSERT INTO aai_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Imaibo hina Capernaum hitit, naatu hirun bar wanawanan hima’am Jesu ibatiyih, “Efamaim tanan kwa abisa isan kwagamigam?” ");
INSERT INTO aai_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Baise fanan men hiya’afutimih, anayabin efamaim hinan i taiyuwih higam yait i orot gagamintoro’ot. ");
INSERT INTO aai_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesu mare ana bai’ufnunenayah nah 12 eafih hina biyan hitit naatu iuwih eo, “Yait wan bai’iyonamih, i taiyuwin boro nan uftoro’ot nabat, sabuw etei’imak isah ni’akir nabow.” ");
INSERT INTO aai_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naatu kek bai na nahimaim iu bat, uman kek tuwabunamaim rauwabon naatu eo, ");
INSERT INTO aai_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“O yait ayu wabu’umaim kek gidigidih inabuwih hai merar inayiy, ayu au merar kuyiy, naatu o yait ayu au merar kuyiy, men ayu akisu au merar kuyiy baise yait ayu iyunu anan auman ana merar kuyiy.” ");
INSERT INTO aai_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John eo, “Bai’obaiyenayan aki orot ta o wabimaim wagabur kakafih nununih ai’itin naatu a’otan, anayabin i men it ata kou’ay orot ta’amih.” ");
INSERT INTO aai_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu iya’afut eo, “Orot men kwana’otanimih! Orot yait ayu wabu’umaim ina’inan nati na’atube esisinaf boro men karam nati bowabow ufunamaim ayu isau tur kakafih na’omih, ");
INSERT INTO aai_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","anayabin orot babin yait men it isat ibiwosai, nati it nowat. ");
INSERT INTO aai_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anababatun a tur o’owen, orot babin yait ayu wabu’umaim o harew it kutomatom anayabin o i ayu nowau, i turobe ana baiyan boro nab. ");
INSERT INTO aai_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Naatu ayu au bai’ufununayah hai baitumatum kikimin, orot yait nan hai not nabi’afiy, gewasin nati orot i boro sikan aumor hita’utan taiyan hititaiy tare. ");
INSERT INTO aai_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","O uma nabonawiy bowabow kakafin inasisinaf na’at, ku’afuw kwisaroun! Uma rounawat ma’ama wanatowanamaim inarur i gewasin, men basit uma rou’abaka itan efan kakafin wairaf wanatowan wan itayen, ");
INSERT INTO aai_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","motamot hita’ani naatu wairaf wanatowan in etoto’ab ta’arahi. ");
INSERT INTO aai_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Naatu a nabonawiy bowabow kakafin inasisinaf na’at, ku’afuw kwisaroun! A dubon ma’ama wanatowanamaim inarur i gewasin, men basit a rou’abaka inan efan kakafin, ");
INSERT INTO aai_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","motamot hina’aani naatu wairaf wanatowan in etoto’ab na’arahi. ");
INSERT INTO aai_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Naatu mata nabonawiy bowabow kakafin inasisinaf na’at, kukubai kwisaroun! Mata ta’imon God ana aiwobomaim inarur i gewasin, men basit mata rou’abaka hinisrouni efan kakafinamaim inare, ");
INSERT INTO aai_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nati’imaim ‘motamot yawasih ti’inu’in boro hina’ani naatu wairaf yayaurin na’arahi.’ ");
INSERT INTO aai_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sabuw etei’imak boro wairafamaim na’arahih narusouwih hinan riyabe hinamatar. ");
INSERT INTO aai_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Riy i gewasin baise naniyan nabi’en boro men karam hiniwa’an naniyan namatar maiye, imih kwa i riy wanawanamaim nama, saise taituwa bairi boro tufuwamaim kwanama.” ");
INSERT INTO aai_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu nati efan ihamiy harew Jordan rabon rewan rounane Judea wanawananamaim tit. Ibanak maiye sabuw rou’ay gagamin maiyow hiru’ay naatu Jesu ana yawas mar etei esisinaf na’atube ma i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee afa hina Jesu biyan hitit naatu hisinaftobon hitikubibiruw isan hibatiy hi’o, “Ku’o anowar ai ofafar eo i karam orot aawan boro nakwahir?” ");
INSERT INTO aai_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu ibatiyih eo, “Moses ana ofafaramaim mi’itube eobaiyuni?” ");
INSERT INTO aai_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hiya’afut hi’o, “Aki Moses ibasit orot aawan kwahirin isan boro kwahikwahiren ana fef nakirum babin nitin nab auman nan.” ");
INSERT INTO aai_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Baise Jesu iya’afutih eo, “Moses iti ofafar kirum, anayabin kwa obai’obaiyen tur nowar isan dogor i fokar kwanekwan. ");
INSERT INTO aai_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Baise aneika mar tafaram mamatar ana veya God ‘Orot babin hairi sinafen himatar.’ ");
INSERT INTO aai_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ana an nati isan orot boro hinah tamah nihamiyih naatu i boro aawan hairi hinita’imon. ");
INSERT INTO aai_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Naatu rou’ab boro nan biyah ta’imon namatar.’ Imih i boro men biyah rou’ab baise biyah ta’imon. ");
INSERT INTO aai_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Isan imih orot babin hairi God bita’imonih men yait ta natarbounih.” ");
INSERT INTO aai_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Imaibo himatabir hin bar hititit ana veya Jesu ana bai’ufununayah hibatiy, “Iti tur anayabin i abisa?” ");
INSERT INTO aai_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hai tur eowen eo, “Orot yait ta a wan nakwahir nare babin ta nabaib ana moser i takweb. ");
INSERT INTO aai_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na’atube babin yait aawan nakwahir, nare orot ta nabaib ana moser i takweb.” ");
INSERT INTO aai_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sabuw afa kek gidigidih hibow Jesu butubunih isan hinan, ana bai’ufununayah sabuw hikwararih hiotanih. ");
INSERT INTO aai_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Baise Jesu iti i’itin ana veya men iyasisir, naatu ana bai’ufununayah isah eo, “Kek gidigidih kwaihamiyih tena isou men kwanarufutih, anayabin God ana aiwob i kek gidigidih iti na’atube i nowah. ");
INSERT INTO aai_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anababatun a tur ao’owen, o yait God ana aiwobomaim runamih, inayare ana itinin kek gidigidih inamamatar boro inarun.” ");
INSERT INTO aai_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Imaibo Jesu kek gidigidih buwih uman tafah yara’aten naatu igegewasinih. ");
INSERT INTO aai_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu misir busuruf inan auman, orot ta nunuw na Jesu nanamaim tit sun yowen, ibatiy, “Bai’obaiyenayan gewas, abisa ana sinaf boro yawas wanatowan nowau’umih namatar?” ");
INSERT INTO aai_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu iya’afut eo, “Aisimamih ayu gewasu irouw ku’o? God akisinamo i gewasin men yait ta. ");
INSERT INTO aai_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ofafar o iso’ob. ‘Men asabunuwen isa nama, men turanah a’aawah ufuh inan, men inabain, men inakutabitabir, men inifufuwen, hinat tamat inabosiyasiyarih.’” ");
INSERT INTO aai_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Orot eo, “Bai’obaiyenayan, ayu kek kikimu ana veya iti ofafar etei’imak abosiyasiyar.” ");
INSERT INTO aai_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu mutufor nuw orot itin naatu isan yabow auman iu, “Sawar ta’imonamo men isinaf. Inan a sawar etei sabuw hinatobon, kabay inab gagaganiy sabuw initih naatu o inan ayu i ni’ufnunu, saise maramaim o boro guguw wairafi inama.” ");
INSERT INTO aai_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Orot iti tur nonowar anamaramaim gubamin hurir naatu ereyababan auman in anayabin orot i guguw wairafin. ");
INSERT INTO aai_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Imaibo Jesu tatabir ana bai’ufununayah isah eo, “Guguw wairafih God ana aiwob efanamaim run isan i fokar kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bai’ufununayah iti tur hinonowar hifofofor men kafaita, baise Jesu ibanak eo maiye, “Ayu natunatu, God ana aiwob run isan ana ef i fokar anababatun. ");
INSERT INTO aai_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sinak ana sou’umaim camel sorabon isan i hamehamen maiyow boro nasorabon, baise orot guguw wairafih God ana aiwobomaim run isan i fokar kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iti tur hinonowar bai’ufununayah hikasiy men kafaita naatu taiyuwih hima hibabatiyih, “Yait boro yawas nab?” ");
INSERT INTO aai_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu mutuforomo nuw itih naatu iya’afutih eo, “Sabuw isah iti i fokar, baise God isan i hamehamen maiyow, anayabin sawar etei God boro nasinaf hinamatar.” ");
INSERT INTO aai_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter Jesu isan eo, “Kwi’itin aki sawar etei aihamiyen naatu o abi’ufnuni.” ");
INSERT INTO aai_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu eo, “Anababatun a tur ao’owen, yait ta ana bar, taintuwan, ruburubun, hinah, tamah, natunatun, naatu ana tafaram ihamiyen, na’atube ayu isou naatu tur gewasin isan iti sawar bihamiyen. ");
INSERT INTO aai_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Iti boun ana veya i boro ana bar, taintuwan, ruburubun, hinahinah, natunatun naatu ana me etei i boro hundred ta’ita’imon tafan anayababar anitin, bai’akir kakafin auman, yomaninamaim boro yawas wanatowan nab. ");
INSERT INTO aai_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Baise sabuw moumurih maiyow boun wan tibi’iyon boro hini’uf naatu sabuw iyab tibi’uf boro hini’iyon.” ");
INSERT INTO aai_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesu ana bai’ufununayah bairi hitit Jerusalem ana ef hibai naatu Jesu ana bai’ufununayah aunah i’iyon, ana bai’ufununayah ufun hinan hinuw hi’i’itin ana veya hai kasiy ra’at, naatu sabuw iyab hibi’ufunun hai bir ra’at. Jesu ana bai’ufununayah 12 buwih nabinamaim hin naatu busuruf hai tur eowen sawar boro mi’itube hinamamatar isan. ");
INSERT INTO aai_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hai tur eowen eo, “Kwananowar, it i au Jerusalem tayey nati’imaim Orot Natun boro hinabonawiy nan firis hai ukwarih naatu Ofafar bai’obaiyenayah biyah natit. Imaim boro morobomih hinao naatu hinabonawiy nan Eteni Sabuw biyah. ");
INSERT INTO aai_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Imaim hini’i’iyab, hinakwaitututur, hinarab, naatu hina’asabun namorob, baise veya tounu ufunamaim i boro nayawas na misir maiye.” ");
INSERT INTO aai_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedee natunatun rou’ab, James naatu John hairi hina Jesu biyan hitit naatu hifefeyan, “Bai’obaiyenayan aki akokok abisa isan anabifefeyani inasinaf.” ");
INSERT INTO aai_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu ibatiyih, “Bo abistan kwakokok boro isa anasinaf?” ");
INSERT INTO aai_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hiya’afut hi’o, “O a aiwob ana bonamanamarinamaim inabi’ukwarin ana veya, aki akokok ina’uwi ta uma a’asukwafune namare ta uma a beyawane namare.” ");
INSERT INTO aai_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu iyafutih eo, “Kwa men kwaso’ob abistan isan kwabifefeyan? Karam biyababan ana kerowas ana tomatom boro kwanatom? Naatu morob wanawanan anarun ana momorob boro kwanarun?” ");
INSERT INTO aai_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hiya’afut hi’o, “Aki karam.” Jesu uwih eo, “Biyababan ana harew i karam boro kwanatom naatu morob wanawanan boro kwanarun. ");
INSERT INTO aai_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Baise o ta au asukwafune mare naatu ta au beyawane mare i men karam boro ayu kwa anit. Nati i sabuw iyabowat God isah yayabuna boro nitih.” ");
INSERT INTO aai_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bai’ufununayah nah ten iti tur hinonowar yah so’ar, James, John hairi isah. ");
INSERT INTO aai_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Basit Jesu etei’imak eafayuwih hina biyan hitit naatu uwih eo, “Eteni Sabuw wanawanahimaim orot hirurubin akisinamo ana fair ema’am boro sabuw nakaifih, naatu i akisinamo ana fairamaim boro nabonawiyih. ");
INSERT INTO aai_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Baise kwa wanawananamaim iti na’atube i men ema’ama, o yait kukokok iti kou’ay wanawanan orot gagam mataramih, o i boro turanah isah ini’akir inabow. ");
INSERT INTO aai_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","naatu o yait kukokok iti kou’ay wanawanan wan bai’iyonamih, o i boro bai’akirayan inamatar. ");
INSERT INTO aai_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Anayabin Orot Natun i men sabuw isan bowamih na; baise sabuw isah nabow ana yawas isah ni’inuw, saise sabuw moumurih natubunih.” ");
INSERT INTO aai_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hina tafaram Jericho hitit, naatu Jesu ana bai’ufununayah bairi nati efan baihamiyinamih sabuw rou’ay gagamin maiyow hiru’ay, naatu orot matan fim fefeyanayan wabin Bartimais, Timias natun ef sisibinamaim ma’am. ");
INSERT INTO aai_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesu Nasaret mowan na inan hi’o nowar. Basit eaf, “Jesu David uwan kwiwanbabanu!” ");
INSERT INTO aai_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sabuw moumurin maiyow orot matan fim hi’u awan fotamih. Baise men karam fanan aumetawat iwow eaf, “David uwan kwiwanbabanu!” ");
INSERT INTO aai_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu an kutan naatu eo, “Kwa’af kwa’u ena.” Basit orot matan fim isan hi’af, “Yate inbainub! Kumisir, isa eafa’af.” ");
INSERT INTO aai_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Orot duku iwa’an misir ana faifuw tafan bosair yare remor na Jesu biyan tit. ");
INSERT INTO aai_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu ibatiy, “Abistan kukokok o isa ana sinaf?” Matan fim iya’afut eo, “Bai’obaibiyenayan ayu akokok matu nigewasin ananuw maiye.” ");
INSERT INTO aai_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu iu eo, “Kwen o abaitumatumamaim iyawasi.” Mar ta’imon matan igewasin nuw naatu busuruf Jesu efamaim inan i’ufunun hairi hin. ");
INSERT INTO aai_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hina Jerusalem ana aiyom hibai, bar merar Bethage naatu Bethany sisibin oyaw Olive imaim Jesu ana bai’ufununayah rou’ab aunan iyafarih, ");
INSERT INTO aai_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","naatu eobaimanih eo, “Kwan bar merar nati namaim donkey orot boubun biyan numin imaim hi’utan ebatabat boro kwanatita’ur, kwanarufam kwanab kwanan. ");
INSERT INTO aai_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Naatu yait ta nati’imaim nibatiyi. ’Aisim iti na’atube kwasisinaf?’ Ana tur kwana’owen Regah ekokok naatu boro’omo niyafar nan maiye.” ");
INSERT INTO aai_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Basit bai’ufununayah orot rou’ab hairi hin bar ef awan imaim bobaituw wabin donkey etawan awan hi’utan batabat hi’itin hirun murab hirurufam, ");
INSERT INTO aai_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","basit sabuw afa nati’imaim hibatabat hibatiyih, “Abistan kwasisinaf? Aisim bobaituw kwarurufam?” ");
INSERT INTO aai_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesu iu’uwih na’atube sabuw hai tur hi’owen naatu sabuw bai’ufununayah hihamiyih hibai hin, ");
INSERT INTO aai_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bobaituw hibai hin Jesu biyan hitit, hai faifuw tafah hibosaisiren bobaituw tafan hiyabar naatu Jesu yen mara’at. ");
INSERT INTO aai_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Naatu sabuw moumurih maiyow hai faifuw tafah hibosairen ef yan hiyabaren naatu afa ai rourih hi’afuw ef yan hituyabayabar. ");
INSERT INTO aai_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sabuw wan hibi’iyon naatu ufununane hibi’ufunun fanah sib hiwow hio, “Orokaiwa!’ “God nigegewasini Regah wabinamaim kunan.” ");
INSERT INTO aai_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ata agir David ana aiwob enan isan taniyasisir.” “God auyomtoro’ot ana merar tanay, Orokaiwa!” ");
INSERT INTO aai_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu na Jerusalem run naatu in Tafaror Baremaim tit bat remor sawar etei itah, baise nati i veya re’er imih ana bai’ufununayah nah 12 bairi hitit hin Bethany. ");
INSERT INTO aai_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mar to Bethany ine himatabir maiye au Jerusalem hinan Jesu aamorob. ");
INSERT INTO aai_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ef yokaika nuw ai fafou raurin sabibin itin, naatu na iyubin ro’on ta tama’am na’at bain anin isan. Baise na ai biyan titit raurinawat batabat itin, yabin nati i men ai ana baiw ana veya. ");
INSERT INTO aai_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naatu Jesu ai isan eo, “O boro men yait ta ro’o nab na’aan!” Iti na’at eo’o ana bai’ufununayah i hinowar. ");
INSERT INTO aai_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hin Jerusalem hitit naatu Jesu in Tafaror Bar run sabuw imaim hima hitotobon rouw nunih hitit, kabay bosemorayah hai gem bow eabatabiren hisuwa naatu ura ma’ama afe’en hima mamu hitotobon bow isrowen ufun hitit. ");
INSERT INTO aai_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Naatu Jesu men ibasit sabuw boro sawar hita’abar Tafaror Bar ana efanamaim hitatit hitan. ");
INSERT INTO aai_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naatu Jesu ma sabuw bi’obaiyih eo, “Buk Atamaninamaim hikikirum God iti na’atube eo, ‘Ayu au Tafaror Bar i yoyoban ana efan sabuw tutufin etei isah.’ Baise kwa kwabotabir bainowan hai wawa’ir ana ‘watu matar’!” ");
INSERT INTO aai_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Firis gagamih naatu Ofafar bai’obaiyenayah iti tur hinonowar yah so’ar Jesu bai asabunin isan ana ef hinuwet, baise hibir anayabin sabuw moumurih maiyow ana bai’obaiyen isan hibifofofor. ");
INSERT INTO aai_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Veya re birabirab Jesu ana bai’ufununayah bairi Jerusalem hihamiy hitit hin. ");
INSERT INTO aai_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mar auman Jesu ana bai’ufununayah bairi efamaim hiremor hinan, ai fafou wairoronika fenem batabat hi’itin. ");
INSERT INTO aai_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naatu Peter nuhin taseb Jesu isan eo, “Bai’obaiyenayan ai fafou kwi’itin, irarafiban fenem ebatabat!” ");
INSERT INTO aai_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu iya’afut eo, “A baitumatum God isan nama’am na’at. ");
INSERT INTO aai_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Anababatun a tur ao’owen o yait oyaw iti isan inao, Ku’uy ra’ah kwen riy yan kure kubat, naatu dogoromaim men erekasiy, auman ina’omih. Baise initumatum abistan God isan kubifefeyan boro nasinaf namatar. ");
INSERT INTO aai_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Isan imih iti isan a tur ao’owen God isan inayoyoyoban sawar ta baitimih, initumatum abisa isan kubifefeyan boro nit. ");
INSERT INTO aai_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Naatu inabat inayoyoban ana veya, sabuw afa hai kakafih isa nama’am na’at inanotawiyen, saise Tamat maramaim ema’am boro obo a kakafih nanotawiyen. ");
INSERT INTO aai_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","O sabuw hai kakafih men inanotanotawiyen na’at, Tamat maramaim ema’am obo a kakafih boro men nanotawiyen a yoyoban nanowar.” ");
INSERT INTO aai_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesu ana bai’ufununayah bairi himatabir maiye hina Jerusalem hitit. Jesu Tafaror Bar awanamaim bat reremor basit Firis ukwarin naatu Ofafar bai’obaiyenayah, regaregah ai’in hina Jesu biyan hitit, ");
INSERT INTO aai_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hibatiy, “O fair menane ibai iti sawar kusisinaf? Naatu fair yait it iti sawar sinaf isan?” ");
INSERT INTO aai_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu iyafutih eo, “Ayu au baibat ta’imon ana bibatiyi kwaniyafutu boro ayu’ubo anao kwananowar. Ayu au fair menane abai iti sawar asisinaf, ");
INSERT INTO aai_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","kwao anowar, John ana fair menane bai bapataito isan, Godane bai ai orot biyanane bai?” ");
INSERT INTO aai_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hibusuruf taiyuwih hibabatiyih hio, “Boro mi’itube tanao, Godane tanao i boro nao bo aisim John men kwabitumitum? ");
INSERT INTO aai_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naatu it tanao orotone.” Baise sabuw isah hibir yabin sabuw etei hibitumatum John i dinab orot ta. ");
INSERT INTO aai_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Imih Jesu isan hio, “Aki men aso’ob.” Basit Jesu iyafutih eo, “Ayu auman boro men anao kwananowar ayu au fair menane abai iti sawar asisinaf.” ");
INSERT INTO aai_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Imaibo Jesu oroubonamaim sabuw i’obaiyih eo, “Orot ana masaw bo ai ro’on tanum fur ear ituwafut, naatu wine bunubunuw ana hub bai, kaifenayan ana bar wowab sawar naatu sabuw afa tubunih hima masaw hikaif, masaw matuwan bainanawanamih in. ");
INSERT INTO aai_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Grape iyamur bairuhin ana veya, ana akir orot iyafar na masaw kaifenayah biyah tit ibo aunowan bairuhin isan. ");
INSERT INTO aai_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baise masaw kaifenayah akir orot hibai hirab uman en hiyafar matabir in. ");
INSERT INTO aai_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naatu masaw matuwan ibanak akir orot ta iyafar maiye na. Masaw kaifenayah akir orot hibai ukwarin hitut hi’a’afiy erebiya’ohow matabir. ");
INSERT INTO aai_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Masaw matuwan akir orot tabo iyafar maiye nan hibai hirab morob, naatu akir wairafih moumurih maiyow biyafarih afa hibow hirouw afa hibow hi’asbunubunuw himorob. ");
INSERT INTO aai_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Orot ta’imonamo ihamiy ma’am i masaw matuwan natun ana yabow akisinamo, uftoro’ot iyafar not eo, ‘Natu boro hinakakafiy.’ ");
INSERT INTO aai_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Baise masaw kaifenayah orot natun nan hi’itin taiyuwih hio, ‘Masaw matuwan natunaban iti, kwana ta’asabun, saise sawar tanab it ninowat.’ ");
INSERT INTO aai_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Imih himisir kek hibai hirab morob naatu biyan hibai hisaroun masaw ufunane ra’iy. ");
INSERT INTO aai_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Masaw matuwan iti tur nanonowar boro mi’itube nasinaf? Orot boro nan masaw kaifenayah nabow narouw hinamorob naatu masaw boro nab sabuw afa nitih hinama hinakaif. ");
INSERT INTO aai_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Buk iti na’atube hikikirum kwaiyab kwa’itin, ‘Kabay nati bar wowabayah hi’itin kakafin hirouw hikwakwahir, i botabir taf etei hai wabat matar. ");
INSERT INTO aai_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iti i Regah sinaf matar ana itinin gewagewasin maiyow!’” ");
INSERT INTO aai_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Basit Jew ukwarih hikok Jesu hitab hitarab, anayabin iti oroubon eo’o ana naniyan hibaib i isah eo, baise rou’ay gagamin isan hibir, imih Jesu hihamiy in. ");
INSERT INTO aai_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharisee afa naatu Herod ana kou’ay sabuw afa auman hiyafarih hin Jesu biyan hitit baibatemaim baikubibiruwin isan. ");
INSERT INTO aai_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hina biyan hitit naatu hio, “Bai’obaiyenayan aki aso’ob o abisa kuo’o i turobe, sabuw abisa tisisinaf isan men kunotanot, naatu sabuw hai not o men kui’itin, baise turobe God ana kok abisa sabuw kubi’obaiyih. Kuo anowar Caesar isan kabay ana bibaiyan boro ata ofafar ana astu’ub ai en? ");
INSERT INTO aai_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Imih kabay anayai ai en?” Baise Jesu hai baifuwen itin naatu eo, “Aisim ayu kwabikubibiruwu? Kabay kwabai kwana kwai’obaiyu aitin.” ");
INSERT INTO aai_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kabay hibai hina hitin naatu ibatiyih, “Yait ana yumat naatu wabin?” Hiya’afut hio “Caesar.” ");
INSERT INTO aai_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Imaibo Jesu iuwih eo, “Abisa Caesar nowan Caesar kwanitin, abisa God nowan God kwanitin.” Naatu sabuw hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Imaibo Sadducee morobone misir maiye isan men tibitumatum hina Jesu biyan hitit hibatiy. ");
INSERT INTO aai_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bai’obaiyenayan Moses aki isai ofafar iti kirum, ‘Orot natabin natun en namomorob na’at, kwafur i boro orot ta ni’aawan saise kek hinatufuw tuwah momorob efanin.’ ");
INSERT INTO aai_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Imih marasika orot ain uf nah etei seven hima’am, basit orot ain tabin natun en morob. ");
INSERT INTO aai_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Naatu orot ufunamaim tuwah ana kwafur i’aawan, ibo na’atube kek en morob. Ef ta’imon matar orot founamaim, ");
INSERT INTO aai_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","naatu etei’imak nah seven babin hi’aawan aurih kek en himumurub, uftoro’ot babin morob. ");
INSERT INTO aai_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Morobone hina mimisir ana veya babin i boro orot menatan ni’aawan? Anayabin nah seven etei babin ta’imon hi’aawan.” ");
INSERT INTO aai_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu iyafutih eo, “Kwa i anot hikwaris! Anayabin kwa Buk Atamanin hikikirum men kwaiyab naatu God ana fair auman men kwaso’ob? ");
INSERT INTO aai_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Morobone misir maiye ufunamaim tabin men ema’am, sabuw etei boro mar ana tounamatar na’atube hinama. ");
INSERT INTO aai_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Naatu morobone misir maiye isan Moses ana buk kutor wairaf ea’arah isan nati’imaim kikirum kwaiyab kwa’itin? God iti na’atube eo, ‘Ayu i Abraham ana God, Isaac ana God naatu Jacob ana God.’ ");
INSERT INTO aai_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I men murubih hai Godamih, baise yawasih hai God, kwa i anababatun ef kwasa’ir!” ");
INSERT INTO aai_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ofafar bai’ubaiyenayan ta nati’imaim ma tur nonowar Jesu tur gewasin Sadducee biya’afut itin, na Jesu ibatiy. “Ofafar tur etei wanawanahimaim tur menatan i gagamin?” ");
INSERT INTO aai_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu iya’afut eo, “Ofafar tur gagamin i iti, kwananowar Israel sabuw, Regah ata God akisinamo ata Regah. ");
INSERT INTO aai_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Regah a God isan iniyabow, dogor tutufin etei, ayub tutufin etei, a not tutufin etei naatu a fair tutufin etei. ");
INSERT INTO aai_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Naatu ofafar gagamin bairou’abin i iti, ‘taituwa isah iniyabow o taiyuw isa kubiyabow na’atube.’ Ofafar iti rou’ab i gagamih ofafar etei hinatabirih.” ");
INSERT INTO aai_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Orot eo, “Abisa kuo i turobe bai’obaiyenayan, Regah akisinamo i God men god afa. ");
INSERT INTO aai_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Imih dogor tutufin etei, a not tutufin etei naatu a fair tutufin etei a God isan iniyabow naatu taituwa isah inabiyabow o isa kubiyabow na’atube, iti ofafar rou’ab i gagamih men for kwarouw sibor kwa’a’afusar na’atube naatu men sibor afa God isan kwaya’ay na’atube’emih.” ");
INSERT INTO aai_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu orot ana baiya’afot i’itin i so’ob, iti orot i not wairafin, imih eo, “God ana aiwobomaim o men yokaika kuma’am.” Nati ufunamaim men yait ta Jesu isan baibat afa bow na ibaitiyimih. ");
INSERT INTO aai_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu Tafaror Baremaim ma bi’obaibiyih basit ibatiyih, “Aisim Ofafar bai’obaiyenayah Keriso isan i David ana agirane na hirouw teo’o? ");
INSERT INTO aai_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David Anun Kakafiyin biwan ana veya iti na’atube eorereb, ‘God au Regah isan eo, Umau asukwafune kumare inama’am a kamabiy sabuw ana bow abatabat babanamaim anaya.’ ");
INSERT INTO aai_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David taiyuwin Keriso isan i ana ‘Regah’ rouw eo, naatu mi’itube boro Keriso David ana agirane nan?” Sabuw rou’ay gagamin maiyow hiru’ay Jesu eo’o ereyasisir hima hinowar. ");
INSERT INTO aai_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu ma bi’obaibiyih eo, “Mata toniwa’an Ofafar bai’obaiyenayah isah, i hai kok faifuw manimanih hina’osen hinaremor naatu ahar efanamaim sabuw merarayow hinitih, ");
INSERT INTO aai_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kou’ay Baremaim urama’ama yayasairen i tebowabow naatu hiyuw ana veya efan gewasih tebowabow. ");
INSERT INTO aai_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kwafukwafur baibin tifufuwih hai sawar tebowabow naatu hai itinin baigewasin isan yoyoban manimanih teyoyoyoban, imih hai baimakiy kakafin anababatun boro hinab!” ");
INSERT INTO aai_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu Tafaror Bar ana kabay teya’ay sisibinamaim mare ma sabuw itih hai siwar hiya’ay. Sabuw totobuyoy wairafih kabay gagaminaka hiya. ");
INSERT INTO aai_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Baise kwafur babin yababan wairafin na ana kabay gidigidih rou’ab tew wanawanan iwan ana fofonin one toea na’atube. ");
INSERT INTO aai_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu ana bai’ufununayah eaf ayuwih hina hai tur eowen eo, “Anababatun a tur ao’owen, iti kwafur babin ana siwar tew biwan i gagamin na’in sabuw etei hiya’iy natabirih. ");
INSERT INTO aai_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Afa hiya’aya i aurih karam turin hiyai turin hibotan, baise kwafur babin yababan wairafin abisa biyan ma’am etei’imak bai na yai.” ");
INSERT INTO aai_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu Tafaror Bar bihamiy ana veya, ana bai’ufununayah orot ta eo, “Bai’obaiyenayan kwi’itin! Kabay gewagewasin maiyow naatu bar hiwowowab ana’itin gewasin maiyow.” ");
INSERT INTO aai_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu iya’afut eo, “Iti bar gagamin kwi’i’itin boro men kafa’imo kabay ta ana efanamaim kwana’itinimih, etei boro nihururuw nara’iy nasawar.” ");
INSERT INTO aai_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesu yen in Olive Oyaw tafan Tafaror Bar batabat rounane imaim mare ma’am basit Peter, James, John naatu Andrew wa’iwa’iramaim hina biyan hitit, ");
INSERT INTO aai_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","hibatiy, “Kuo anowar mar boro biy iti sawar hinamatar? Naatu ina’inanen boro abisa ni’obaiyi ana so’ob veya ina ebiyubin.” ");
INSERT INTO aai_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Imaibo Jesu hai tur eowen eo, “Mata toniwa’an men yait ta nan nikubibiruwimih. ");
INSERT INTO aai_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sabuw moumurih na’in boro ayu wabu’umaim hinao, ‘Ayu’uban iti!’ Naatu moumurih maiyow boro hinanawiyih hai ef hinasair. ");
INSERT INTO aai_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Baiyow nidun iti yubinamaim o ef yokamaim kwananonowar men kwanabir, sawar iti na’atube boro hinamatar, baise men kwananot mar yomanin i natit. ");
INSERT INTO aai_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tafaram ta boro namisir tafaram ta hairi hiniyow, aiwob ta boro aiwob ta hairi hiniyow. Nati’imaim iriyoy tafaram etei boro nab, naatu baimar kakafin boro namatar. Iti sawar hinamamatar i babin taubumih kek ebobotukwar na’atube. ");
INSERT INTO aai_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kwa i kwanakaifi gewas mata toniwa’an, kwa boro hinafatumi naatu hinabuwi kwanan baibabatiyi isan, Kou’ay Baremaim boro hinaborabirabi, bonawiyenayah hai ukwarih naatu aiwob nahimaim kwanabat ayu wabu’umaim tur Gewasin hai tur kwana’owen. ");
INSERT INTO aai_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Baise wan tur gewasin tafaram wanawanan sabuw etei isah kwanabinan. ");
INSERT INTO aai_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naatu hinafatumi baibabatiy isan kwananan men tur isan kwaniyababan kwanabirumih, tur o ana veya abisa a notamaim etitit i kwanao, anayabin men kwa kwao’omih, baise Anun Kakafiyin. ");
INSERT INTO aai_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Oro’orot boro taiyuwih taituwah babah hinao hinamorob, regaregah boro natunatuh babah hinao hinamorob, kek boro hinitafasar hinah tamah babah hinao hinamorob. ");
INSERT INTO aai_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sabuw etei boro hinifa’ifa’i anayabin ayu isou, baise orot yait nabatabatkikin yomaninamaim boro yawas nab. ");
INSERT INTO aai_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Gurugurusen ana sawar itinin birubir kakafin marasika nati’imaim men batabat boro nabatabat kwana’i’itin ana veya, sabuw iyab Judea tema’am boro hinabihir hin oyawamaim hinatit, o yait kubiyab iti tur anayabin i naso’ob. ");
INSERT INTO aai_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Orot yait ana bar afe’en ema’am men narubir o nare ana bar wanawanan narun ana sawar nabow. ");
INSERT INTO aai_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Orot yait ma masaw ebob men namatabir bar ana faifuw nabaimih, ");
INSERT INTO aai_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nati ana veya’amaim baibin iyab yah auman naatu kek tibitotomanen boro yababan gagamin maiyow hinab! ");
INSERT INTO aai_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kwanayoyoban saise iti sawar men yakukur ana veya namatar. ");
INSERT INTO aai_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Anayabin iti bai’akir kakafin boun emamatar i aneika God tafaram bimatar iti na’atube men matar naatu boro men namatar maiye. ");
INSERT INTO aai_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Baise Regah nati veya men tayayakabum na’at, sabuw boro men yawas hitab, baise i ana sabuw rurubiniyih isah iti veya yakabum. ");
INSERT INTO aai_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naatu nati ana veya orot yait isa nao, ‘Kwanuw Keriso enan kwa’itin’, o iban ‘Iti ema’am!’ Men kwanitumitum. ");
INSERT INTO aai_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anayabin Keriso na’atube naatu dinab orot na’atube boro hinatit ina’inan ta ta, naatu baifofofor fairih hinasinaf sabuw hinabonawiyih hai ef hinasair, naatu hai ef nama’am na’at God ana roubinen sabuw auman boro hai ef hinawasa’ir. ");
INSERT INTO aai_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sawar iti etei isah ao kwanonowarabo namatar, imih kwanakaifi gewas! ");
INSERT INTO aai_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Baise nati bai’akir hinamamatar ana veya, ‘I nanamaim veya boro matan nagugum, naatu sumar boro men nakaw, ");
INSERT INTO aai_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","daman auyomane boro hinihururuw hinare, naatu mar ana sawar etei boro niyuwiyuw, fair ta ta maramaim boro hai efan hinasairen.’ ");
INSERT INTO aai_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Nati ana veya’amaim Orot Natun boro kasakasaw wanawananamaim nanan kwana’itin ana fair bonamanamarin auman. ");
INSERT INTO aai_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","I boro ana tounamatar niyafarih hinatit tafaram tutufin wanawanan ana huhun etei kwafe’en imaim hinarun hinatit God ana roubiniyen sabuw hinabow hinan yomanin hinatit. ");
INSERT INTO aai_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ai fofou rourinamaim ebi’obaiyi kwana’itin, ai famefamenamaim rourin narusasar kwana’i’itin kwa boro kwanao ai abeb ana veya tit, ");
INSERT INTO aai_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ef i nati ta’imon sawar iti hinamatar kwana’i’itin, kwa i kwanaso’ob veya i nakabom, iyubin etawan awan ebatabat. ");
INSERT INTO aai_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Anababatun a tur ao’owen, sabuw iti tema’am boro hinama’am sawar namatar hina’itinibo hinamorob. ");
INSERT INTO aai_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mar tafaram boro nasawar, baise ayu au tur boro men nasawar.” ");
INSERT INTO aai_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Men yait ta veya o fur so’obamih, tounamatar no maramaim na’atube i Natun, baise Tamah akisinamo so’ob. ");
INSERT INTO aai_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mata toniwa’an kwanabat yewayew, anayabin veya men kwaso’ob mar biy boro namatar. ");
INSERT INTO aai_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ana itinin i nanawan orot na’atube, orot bainanawanamih ana’akir wairafih boro ta’ita’imon bowabow nitih. Naatu orot etawan kaifin isan ya’iyai boro nau, matan toniwa’an etawan nakaif nama. ");
INSERT INTO aai_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Imih mata toniwa’an, anayabin kwa men kwaso’ob orot bar matuwan i boro biy namatabir, rabirab nan, o fai inusabobor, kwasiy hinao ana veya, o yasi’uw, ");
INSERT INTO aai_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","naniyan meyemeye natitit na’at men kwana’inu’in natitamih. ");
INSERT INTO aai_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Abisa au’uwi, i sabuw etei isah ao’o, ‘Mata toniwa’an!’” ");
INSERT INTO aai_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tar Nowaten naatu Faraw Wanawanan Yeast En ana hiyuw i veya rou’ab nahimaim bat. Naatu firis ukwarih, Ofafar bai’obaiyenayah i wa’iwa’iramaim ef hinuwet mi’itube Jesu hitab hita’asabun isan. ");
INSERT INTO aai_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naatu hio, “Men hiyuw tanabowabow wanawanan tanasinafumih, anayabin rakit boro tanaku’ub.” ");
INSERT INTO aai_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesu in Bethany orot Simon biyan kokom ani’anin ana bar wanawanan run, ma bay eaau basit babin ta kibub kabayamaim hikwak raiy yamurin gewasin hisuwai batabat bai narun, iti raiy i ana baiyan gagamin, kibub sikan ana gigiwaiyomaim takakir Jesu aribun yan isuwai re. ");
INSERT INTO aai_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sabuw afa nati’imaim hima’am hi’i’itin yah so’ar naatu taiyuwih hima higam hio, “Aisim iti raiy yamurin gewasin asir ebisuwai kwanikwaniy? ");
INSERT INTO aai_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iti raiy i 300 denari tafanamaim auman boro hitatubun naatu kabay sabuw bai’akirayah hitibaisih!” Naatu babin hi’i’iyab higam hiu kwanikwaniy. ");
INSERT INTO aai_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Baise Jesu eo, “Babin kwaihamiy! Aisim kwaowa’awa’an? Sawar gewasin maiyow ayu isou sinaf. ");
INSERT INTO aai_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kwa boro mar etei bai’akirayah bairi kwanama, veya afa baibaisih isan kwanakokok boro kwanibaisih. Baise ayu boro men mar etei bairit tanama’amih. ");
INSERT INTO aai_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Babin abistan sisinaf i karam ayu isou sinaf, raiy yamurin gewasin biyau imaim isuwai re’er i ayu yanowahu biyau eyayabunai ufibo hinayai. ");
INSERT INTO aai_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Anababatun a tur ao’owen, iti Tur Gewasin tafaram tutufin wanawanan hinao hinabibinan, iti babin abisa sisinaf sabuw boro isan hinao naatu hinanuh.” ");
INSERT INTO aai_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Imaibo Judas Iscariot Jesu ana bai’ufununayan orot ta nah 12 wanawanahimaim tit in firis ukwarih biyah tit saise ef tanuwet Jesu umahimaim tayai hitarab tamorob. ");
INSERT INTO aai_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Naatu abistanawat eo hinonowar hiyasisir men kafaita, naatu kabay baitinin isan hi’omatan. Judas misir ef ana gewasin nuwet imaim Jesu tab titih hita’asabun isan. ");
INSERT INTO aai_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Faraw Wanawanan Yeast En ana hiyuw aa ana veya wantoro’ot ebubusuruf, nati’imaim Tar Nowaten ana hiyuw aa isan bobaituw sheep natunatuh wabih lamb imaim terouw tisisibor. Imih Jesu ana bai’ufununayah hibatiy, “O kukokok boro menamaim Tar Nowaten ana hiyuw ana bogaigiwas o isa?” ");
INSERT INTO aai_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Basit Jesu ana bai’ufununayah orot rou’ab eobaimanih eo, “Kwanan bar oto’otowen kwanatitit nati’imaim orot ta boro noukwatamaim harew nahun na’abar nan bairi kwanitar, ");
INSERT INTO aai_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","naatu kwani’ufunun bairi kwanan, bar menatan erur imaim kwanarun. Nati’imaim bar matuwan kwanau, ‘Bai’obaiyenayan ebibat bar awan menatan ayu au bai’ufnunayah bairi Tar Nowaten ana hiyuw anaa?’ ");
INSERT INTO aai_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naatu bar tafantoro’ot awan ta gewasin hiyabun inu’in nabi’obaiyi imaim kwanabogaigiwas.” ");
INSERT INTO aai_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bai’ufnunayah hitit hin bar oto’otowen hitit naatu Jesu iu’uwih na’atube sawar etei’imak hitita’uren, naatu Tar Nowaten ana hiyuw hibogaigiwas. ");
INSERT INTO aai_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Veya re birabirab Jesu ana bai’ufununayah 12 bairi hina ");
INSERT INTO aai_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","hima bay hi’aa wanawanan Jesu misir eo, “Anababatun a tur ao’owen kwa wanawananamaim orot ta boro babau nao anamorob, nati orot i ayu airi efan ta’imon ama a’au.” ");
INSERT INTO aai_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bai’ufununayah gubamih hurir himisir ta’ita’imon Jesu hibabatiyih, “O kunotanot ayu ai en?” ");
INSERT INTO aai_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu iyafutih eo, “Kwa na 12 wanawanamaim yait ana rafiy nab ayu airi tew yan anabubutu’ub orotoban nati. ");
INSERT INTO aai_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Orot Natun i boro namorob Bukamaim hikikirum na’atube, baise yait Orot Natun baban eo emomorob i boro bai’akir kakafin maiyow nab, gewasin nati orot iti tafaramaim men tatufuw.” ");
INSERT INTO aai_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bay hi’aa wanawanan Jesu rafiy bai merar yi yoyoban sawar imasib, ana bai’ufununayah itih eo, “Kwabai kwa’aan, iti i ayu biyou.” ");
INSERT INTO aai_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naatu kerowas bai God ana merar yi sawar, ana bai’ufununayah itih etei’imak hitom. ");
INSERT INTO aai_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naatu iuwih eo “Iti i ayu au rara au Obaibasit Boubun kwa etei isa abisuwai. ");
INSERT INTO aai_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anababatun a tur ao’owen, Ayu iti wine boro men anatom maiye, anama’am wine boubun Tamai ana aiwobomaimibo anatom.” ");
INSERT INTO aai_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naatu ew hitabor sawar himisir hitit hin Olive oyawemaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu ana bai’ufununayah hai tur eowen eo, “Kwa etei’imak boro kwanabihir ayu kwanihamiyu, anayabin Bukamaim iti na’atube hikirum.” ‘Ayu boro bobaituw kaifenayan anarab, naatu bobaituw etei boro na’abaragiy nanabin hinabihir.’ ");
INSERT INTO aai_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Baise morobone ana mimisir ufunamaim ayu boro wan anan Galilee anatit.” ");
INSERT INTO aai_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter iya’afut eo, “Au ofonah boro hinabihir, baise ayu boro men anihamiy ana bihiramih.” ");
INSERT INTO aai_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu Peter isan eo, “Anababatun a tur ao’owen boun gugumin o mar tounu ayu inayayoubu ufunamaim kokorere boro mar rou’ab nao’o inanowar.” ");
INSERT INTO aai_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter fair raro’on rab eo, “Ayu boro men kafa’imo nati tur ana’omih, ayu o airit morobomih wabin abatun.” Naatu bai’ufununayah etei’imak tur ta’imon hio. ");
INSERT INTO aai_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naatu hina efan wabin Gethsemane imaim hitit, Jesu ana bai’ufununayah isah eo, “Iti’imaim kwanama ayu anan anayoyoban.” ");
INSERT INTO aai_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Peter, James, naatu John buwih bairi hin. Dogoron wanawanan busuruf yababan naatu biyababan ana bit tatam. ");
INSERT INTO aai_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Naatu ana bai’ufununayah nah tounu isah eo, “Dogorou wanawanan yababan i ra’at kwanekwan kafa’imo nimfufuru, imih iti’imaim kwamare naatu mata nanuw kwanama.” ");
INSERT INTO aai_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesu in kafa’imo yumatan aubabe me yan ra’iy naatu yoyoban saife ef tama’am na’at bai’akir ana veya tanan men tab. ");
INSERT INTO aai_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jesu yoyoban eo, “Tamai, Taimaya! Sawar etei i hamehamen karam boro inasinaf iti biyababan ana kerowas biyau’umaim kubosair, men ayu au kok baise o a kok.” ");
INSERT INTO aai_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naatu Jesu matabir maiye nan ana bai’ufununayah nah tounu hi’inu’in itih Peter isan eo, “Simon o mata fot ku’inu’in? Karam boro one hour ana fofonin mata hitanuw bairit tatama?” ");
INSERT INTO aai_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nah tounu isah eo, “Mata to’iwa’an kwayoyoban saise men routobon kwanab, ayub i ekokok baise biya i himorob.” ");
INSERT INTO aai_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesu matabir maiye yoyobanamih in, tur ta’imonabanak eo yoyoban. ");
INSERT INTO aai_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naatu matabir maiye nan ana bai’ufununayah biyah tit matah koun bit sawar hi’inu’in itih, naatu Peter tur o isan kasiy awan bit. ");
INSERT INTO aai_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesu mar baitounin matabir maiye na ana bai’ufununayah biyah tit eo, “Kwa i boro’ika kwai’in kwabiyarir? Kwaiyariraka! Mata tenuw. Orot Natun i sabuw kakafih umahimaim hiyai hinab hinafatumimih. ");
INSERT INTO aai_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kwamisir tan, kwa’itin, orot yanuwayan i natitaka, nabuwu’umih.” ");
INSERT INTO aai_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu ana tur eo sawara’e, bai’ufununayah nah 12 wanawanahimaim Judas yanuwayan, firis ukwarih, Ofafar bai’obaiyenayah naatu regaregah ai’in kou’ay gagamin kaiy kefat auman Judas nawiyih bairi hina hitit. ");
INSERT INTO aai_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yanuwayan i kou’ay eobaimanih, “Orot menatan ayu anab ana mamamay kwa a kok orotoban nati, kwanab kwanafatum naatu kwanakaif auman kwanan.” ");
INSERT INTO aai_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Basit hina hititit ana veya Judas mutufor in Jesu biyan tit eo, “Bai’obaiyenayan!” Naatu mamay. ");
INSERT INTO aai_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Naatu Jesu hibai hirab hifatum. ");
INSERT INTO aai_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Baise orot ta nati’imaim batabat kaiy bai firis ukwarin ana akir wairafin tainin buru’um. ");
INSERT INTO aai_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu awan tara’ah kou’ay isah eo, “Kwa a kaiy, a kefat kwaiteten kwanan ayu fatumu’umih ana itinin ayu i bainowan orot na’atube. ");
INSERT INTO aai_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mar etei Tafaror Baremaim ama abibinan men imaim kwatafatumu? Baise abisa Bukamaim hi’o hikikirum i nan niturobe.” ");
INSERT INTO aai_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nati’imaim ana bai’ufununayah etei’imak hihamiy hibihir. ");
INSERT INTO aai_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Orot boubun ta ana faifuw baban akisin ius Jesu bi’ufunun, hisinaftobon hitab hitafatumimih, ");
INSERT INTO aai_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","baise ana faifuwawat hibai i segar bihir. ");
INSERT INTO aai_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Firis Gagamin, orot ai’in, Ofafar bai’obaiyenayah, etei hiru’ay hima’am Jesu hibai hina firis ukwarih ana baremaim hirun. ");
INSERT INTO aai_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter ef yokaika i’ufnunih bairi hina Firis Gagamin ana bar merar hitit imaim ma’utenayah wairaf hi’asir hima rararih i na bairi hima rarih. ");
INSERT INTO aai_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Firis ukwarih naatu kanisel ana kou’ay sabuw tutufin etei hisinaftobon baifuwen tur hibow hitit saise imaim Jesu hita’asabun isan, baise ana kakafin men ta hitita’urimih. ");
INSERT INTO aai_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sifrubonayah moumurih maiyow Jesu isan hifufuwen, baise hai tur hio men Jesu sisinafumaim hi’o’omih. ");
INSERT INTO aai_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Naatu sabuw afa himisir Jesu isan baifuwen tur hibow hit hio. ");
INSERT INTO aai_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Aki eo anowar, ‘Sabuw umahimaim Tafaror Bar hiwowowab ayu boro anataraboun nare naatu veya tounu ufunamaim boro ana wowab maiye, men sabuw umahimaim hiwowowab na’atube.’” ");
INSERT INTO aai_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Baise hai tur hio men ta sisinafumaim hi’o’omih. ");
INSERT INTO aai_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Imaibo Firis Gagamin misir sabuw nahimaim bat Jesu ibatiy, “Orot hairi sif hirurubon inowar naatu boro hai tur wan inay ai en?” ");
INSERT INTO aai_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Baise Jesu men kafa’imo tur ta eomih, Firis Gagamin ibanak ibatiy maiye, “O i Roubininayan God Baigegewasinayan Natun?” ");
INSERT INTO aai_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu iya’afut eo, “Ayu i Natun, naatu kwa etei boro Orot Natun God fairin uman asukwafune namare rofom wanawanan nanan kwana’itin!” ");
INSERT INTO aai_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naatu Firis Gagamin iti tur nonowar ana faifuw bow seb naatu eo, “Aki men akokok sif rubonayah! ");
INSERT INTO aai_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Baigigimen tur eo kwanowar, mi’itube kwanotanot?” Etei’imak hio, “I bowabow kakafin sinaf naatu i boro namorob?” ");
INSERT INTO aai_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sabuw afa Jesu yumatan hikwaitututur naatu matan faifuwamaim hisum hirab hio, “Kuo anowar yait o rabi?” Ma’utenayah auman rebareban hifafar. ");
INSERT INTO aai_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter ufun bar meraraka ma’am basit Firis Gagamin ana akirwairafin babitai na sisibinamaim tit, ");
INSERT INTO aai_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Naatu Peter ma wairaf rarar babitai bat itin kikin naatu eo, “O auman Jesu airi Nazarethane kwana.” ");
INSERT INTO aai_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Baise Peter youb, “Ayu men aso’ob o abitur ku’o.” Basit i bar merar ana etawan gagamin ufunane tit, naatu kokorere eo. ");
INSERT INTO aai_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Akir babitai Peter itin maiye, naatu nati’imaim sabuw hibatabat tur ta’imon hai tur eowen, “Iti orot i Jesu ana bai’ufununayan ta!” ");
INSERT INTO aai_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Baise Peter ibanak youb maiye, hima kikimin sabuw bairi hibatabat Peter hiu, “Tur anababatun o i Jesu ana bai’ufununayan orot ta, anayabin o auman i Galilee orot.” ");
INSERT INTO aai_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter eobaifaro eo, “Anababatun a tur ao’owen, God baimakiy nitu ayu ana bifufuwen na’at, ayu nati orot men aso’ob!” ");
INSERT INTO aai_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mar ta’imonamo kokorere mar bairou’abin eo, naatu imaibo Peter nuhin taseb Jesu mi’itube eo not, “Kokorere mar rou’ab nao ana veya o boro mar tounu ayu inayoubu.” Naatu Peter busuruf rerey. ");
INSERT INTO aai_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maraumanaika, firis ukwarih naatu regaregah ai’in, Ofafar bai’obaiyenayah naatu kaniser etei hiru’ay hiyakitifuw. Imaibo Jesu uman hifatum hibonawiy hin Pilate biyan hitubar. ");
INSERT INTO aai_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate Jesu ibatiy eo, “O Jew hai aiwob?” Jesu iya’afut eo, “Bo nati ku’o.” ");
INSERT INTO aai_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Naatu firis ukwarih Jesu isan baifufuwen maumurih maiyow hibow hitit bowabow kakafin sinaf hirouw hio. ");
INSERT INTO aai_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Imih Pilate Jesu ibatiy maiye? “O boro tur ta inao? O baifufuwenayan hiruw te’o kunonowar!” ");
INSERT INTO aai_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Baise Jesu men kok boro tur tao maiye, imih Pilate ana kasiy ra’at men kafaita. ");
INSERT INTO aai_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gawan hai sinaf mar etei Tatar Nowaten hiyuw ana veya sabuw hai kokomaim teo orot menatan dibur ema’am Pilate ebobotait. ");
INSERT INTO aai_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nati ana veya orot wabin Barabas i diburamaim ma’am, iti orot i sabuw hai kou’ay ta hibai uruw hirufufur hinan wanawanan orot ta easabun morob. ");
INSERT INTO aai_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Imih sabuw hai kou’ay hibai naatu hai kok orot menatan mar etei esisinaf na’atube tabotait isan Pilate hifefeyan. ");
INSERT INTO aai_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Naatu Pilate ibatiyih, “Kwakokok ayu Jew hai aiwob isa anabotait?” ");
INSERT INTO aai_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Anayabin Pilate i so’ob firis ukwarih Jesu isan hibibobowen, imih hibai hina umanamaim hiyai. ");
INSERT INTO aai_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Baise firis ukwarih sabuw tafah fair hiyai hi’o totofarih Jesu efanin Barabas botaitin isan Pilate hifefeyan. ");
INSERT INTO aai_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate iban maiye sabuw ibatiyih, “Abistan kwakokok ayu iti orot Jew hai aiwob kwarouw kwao isan ana sinaf?” ");
INSERT INTO aai_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sabuw hiwow hio, “Ku’onaf!” ");
INSERT INTO aai_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate ibatiyih maiye, “‘‘Bo abistan kakafin sinaf?” Baise sabuw fanah aumetawat hiwow hio, “Ku’onaf!” ");
INSERT INTO aai_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate kok kwanekwan mi’itube rou’ay tiyasisirih, imih sabuw isah Barabas diburane botait tit. Naatu Jesu bai misamaim biyan rab tut veyaveyar, imaibo baiyowayah uwih onafin isan hibai hitit. ");
INSERT INTO aai_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Baiyowayah Jesu hibai gawan ana bar merar imaim hirun, gawan hai bowabow efan gagamin naatu hai ofonah etei’imak hi’af ayuwih. ");
INSERT INTO aai_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Faifuw namar hibai Jesu hi’osenawain, kokor nukwarin ana kowasamih hififin. ");
INSERT INTO aai_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naatu hibusuruf hi’i’iyab ana merar hiyi hio, “Aki erekakaf abobora’ara’ahi Jew hai aiwob!” ");
INSERT INTO aai_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wabukamaim nukwarin hitut, hikwaitututur, suh hiyowen hikwafir moyamoy. ");
INSERT INTO aai_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hibi’i’iyab ufunamaim, faifuw namar hibosair naatu Jesu ana faifuw hi’us maiye, naatu hibonawiy hitit onafin isan hin. ");
INSERT INTO aai_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hitit hinan efamaim orot wabin Simon Sairini mowan, masaw barene au Jerusalem bar merar nan bairi hitar, Alexander naatu Rufus hairi tamah. Baiyowayah hi’ukikin Jesu ana onaf abarin isan. ");
INSERT INTO aai_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesu hibai hin efan wabin Golgotha hitit, efan ana’itin i ukwarih ana rarikabe. ");
INSERT INTO aai_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nati’imaim wine naatu harew fokarin ta wabin myrrh auman hisartabir Jesu tomamih hibitin, baise men tom. ");
INSERT INTO aai_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baiyowayah Jesu hi’onaf, ana faifuw hifaram hibow hima hi’arow saise arowamaim ti’obaiyih, Jesu ana faifuw menatan boro tab. ");
INSERT INTO aai_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mar auman veya nine korok na’atube Jesu hi’onaf. ");
INSERT INTO aai_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesu sinaf kakaf hirouw hio ubar hibitin ana tur ukwarinamaim hikirum hio, “Jew Hai Aiwob.” Tafanamaim hikubar. ");
INSERT INTO aai_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Naatu orot kakafih rou’ab auman hi’onafih, ta ana beyawane ta ana asukwafune. ");
INSERT INTO aai_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iti na’atube mamatar i Bukamaim hikikirum na iturobe, i boro bainowah bairi hina’onafih. ");
INSERT INTO aai_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sabuw na hinan, ne hinan Jesu hi’i’itin hi’i’iyab nah hita’asi’asiy hio, “Ige aro! O Tafaror Bar tarabounin veya taunu wanawanan wowabin yen irouw i’o’oban iti ku’inu’in?” ");
INSERT INTO aai_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Taiyuw kwiyawasi onaf afe’enane kura’iyeban a’itin. ");
INSERT INTO aai_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sinaf ta’imon firis ukwarih naatu Ofafar bai’obaiyenayah Jesu hi’i’iyab, taiyuwih hio, “Afa ibiyawasih, baise i taiyuwin boro men niyawas. ");
INSERT INTO aai_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kwabat Rubininenayan ta’itin, Israel sabuw hai aiwob boun onaf afe’enane nare tana’itin, saife tanitumitum.” Naatu orot rou’ab Jesu bairi hi’o’onafih auman tur ta’imon hi’o higigim. ");
INSERT INTO aai_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Veya yen in tafat yan, basit tafaram tutufin etei gugum in veya three korok bai. ");
INSERT INTO aai_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Veya three korok baib Jesu fanan aumetawat itarakouw rerey eo, “Eloi, Eloi, lema sabaktani” anayabin “Au God Au God, aisimamih ihamiyu?” ");
INSERT INTO aai_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sabuw afa nati’imaim hibatabat hinowar hio, “Kwanowar Elijah isan eafa’af.” ");
INSERT INTO aai_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Orot ta nunuw in harew sususub tainen bai wine tenakuyakuy butu’ub naatu isik yomaninamaim iyouw, eot ra’ah Jesu susubinamih, baise orot ta eo, “Kwabat! Elijah nan onafane nab nayayare tana’itin!” ");
INSERT INTO aai_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu ibanak maiye fanan aumetawat na’in itarakouw rerey, basit ayubin tabaratait naatu morob. ");
INSERT INTO aai_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tafaror Bar wanawanan efan kakafiyin awan faifuw hitenafut in rorore tafantoro’ot taseb re uran tit rou’ab himatar. ");
INSERT INTO aai_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Baiyowayan orot ukwarin nati onaf nanamaim batabat, Jesu mi’itube momorob itin naatu eo, “Turobe iti orot i anababatun God Natun!” ");
INSERT INTO aai_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nati’imaim i baibin afa auman, ef yokaika hibat hinuwanuw. Baibin wanawanahimaim i Mary Magdalin, Mary kek James boubun naatu Joseph hairi hinah naatu Salome. ");
INSERT INTO aai_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iti baibin i Galilee’imaim Jesu hi’ufunun baibais hitin bairi hibowabow i hina. Naatu baibin maumurih maiyow bairi hina Jerusalem hititit i auman nati’imaim hibatabat. ");
INSERT INTO aai_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Veya re irabirab, naatu nati rabirab i yabunabuna ana veya, anayabin mar natoto i Baiyarir ana veya. ");
INSERT INTO aai_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Imih Joseph Arimathea’ane na tit. Iti orot i kaniser ana kou’ay orot ta. God ana aiwob isan ma kakakaf. Joseph Jesu biyan bain isan itafofor na Pilate nanamaim tit ifefeyan. ");
INSERT INTO aai_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naatu Pilate Jesu momorob ana tur men so’ob, imih baiyowayah ukwarin isan e’af na ibatiy. ");
INSERT INTO aai_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Baiyowayah ukwarin eo nonowar ufunamaim Pilate ibasit Joseph Jesu biyan bain isan. ");
INSERT INTO aai_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Naatu bairahiya ana faifuw bai na Jesu bu’ub yare sum, bai in to naiwanamaim tar inu’in imaim yai, kabay gagamin ifururuw na hub awan hir. ");
INSERT INTO aai_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalin naatu Mary Joseph hinah hairi Jesu biyan menamaim hiya’iy i hi’itin. ");
INSERT INTO aai_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Baiyarir ana veya sasawar ufunamaim, Mary Magdalin, Mary, James hinah naatu Salome, spices hitobon hibow hin Jesu biyan hitarab isan. ");
INSERT INTO aai_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fur ebubusuruf i anamaim maraumanika, baibin hin rahemaim hitit. ");
INSERT INTO aai_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hinan efamaim taiyuwih hibabatiyih hio, “Hub awanamaim kabay gagamin hihirafut inu’in boro yait nifururuw natit?” ");
INSERT INTO aai_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baise baibin nah hitara’ah hinuwanuw nahimaim hub awanamaim kabay gagamin i hifururuw au sisibin titaka batabat. ");
INSERT INTO aai_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Naatu baibin mutufor hin hub wanawanan hirun, hinuwanuw hai asukwafune orot boubun ana faifuw kwes us ma’am hi’itin naatu yah birubir fafar. ");
INSERT INTO aai_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Baise orot eo, “Men kwanabir, ayu aso’ob kwa i Jesu Nasaret mowan hi’onaf momorob i kwanunuwih, i morobone misir, naatu men iti’imaim ema’ama. Ana efan iti kwa’itin en. ");
INSERT INTO aai_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Baise kwanan ana bai’ufununayah hai tur kwana’owen, Peter auman ana tur kwana’owen, Jesu i mat enan au Galilee. Kwa boro imaim kwana’itin marasika iu’uwi na’atube.’” ");
INSERT INTO aai_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Baibin hikasiy naatu ah umah duduwar rab, rah hihamiy hitit naatu hibihir hin. Abistanawat mamatar men yait ta ana tur hi’owen anayabin hibir. ");
INSERT INTO aai_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu morobone mimisir ufunamaim, fur bubusuruf i anamaim maraumanika wantoro’ot i Mary Magdalin isan irerereb, nati babin Mary biyanamaim wagabur etei seven nunih hitit. ");
INSERT INTO aai_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Etei hima hiyababan hirererey, Mary na hai tur eowen, ");
INSERT INTO aai_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","baise Jesu yawas maiye misir matan yan itin na eo hinonowar men hitumitum. ");
INSERT INTO aai_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nati ufunamaim, Jesu ana bai’ufununayah rou’ab masaw bar hinan efamaim Jesu nah touman hai itinin na’atube isah irerereb. ");
INSERT INTO aai_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hi’intabir hina hai ofonah afa hai tur hi’owen baise men kafa’imo hitumatum. ");
INSERT INTO aai_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Uftoro’ot bai’ufununayah nah 11 hima bay hi’aau Jesu isah irerereb, naatu men hibitumatum naatu dogoroh fofokar isan gam iuwih, anayabin sabuw iyab i morobone misir isah birerereb hi’itin hina hai tur hi’o’owen men hitumatum. ");
INSERT INTO aai_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesu iuwih eo, “Tafaram wanawanan etei kwanaremor naatu Tur Gewasin kwanabinan tafaram tutufin etei isah. ");
INSERT INTO aai_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yait nitumatum bapataito kwanabitin boro yawas nab; baise yait men nabitumatum ana yawas boro nikasiy. ");
INSERT INTO aai_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Naatu ina’inan iti boro iyab ayu tibitutumu biyahimaim nakwah auman hinatit, ayu wabu hinasu’ub wagabur kakafih boro hinabihir; menah nabotabir tur afa boubuh hina’o. ");
INSERT INTO aai_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kok hinabowabow boro men hinayubih, moromorob harew hinatomatom boro men hinamorob. Sabuw hinasawow hina’inu’in umah biyahimaim hinayara’aten boro hinayawas.” ");
INSERT INTO aai_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesu ana bai’ufununayah isah eo sasawar ufunamaim, earura’ah yen au mar Tamah God ana asumaiyowane mara’iy. ");
INSERT INTO aai_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bai’ufununayah hitit hin, tafaram tutufin wanawanan Tur Gewasin sabuw isah hibinan. Naatu Regah wanawanahimaim bow tur gewasin hibibinan ina’inan fairih sisinafumaim hai bowabow na i turobe. ");
INSERT INTO aai_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Are Theophilus, Sabuw maumurih na’in abisa iti biyatamaim mamatar isan hisinaftobon ana tur etei’imak bukamaim hikirumen. ");
INSERT INTO aai_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Abisa hikikirum i sabuw iyab iti sawar matar matah yan hi’itin hio hinonowar i hikirum, naatu sabuw iyab iti tur isan hibow hibibinan i hio hinowar hikirum. ");
INSERT INTO aai_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Isan imih Theophilus o i gewas maiyow, ayu iti sawar himamatar isan kiruminamih anot, imih sawar no aneika anutitiy, sabuw ai babatiyih hai an abow gewas, naatu akubaitutur o isa iti a kikirum, ");
INSERT INTO aai_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","saise o boro inaso’ob sawar iti etei o hibi’obaiyi i turobe. ");
INSERT INTO aai_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea wanawanan Herod bi’aiwob ana maramaim, firis wabin Zechariah i Abaijah ana kou’ay wanawanan ma firis ana bowabow bowabow, naatu aawan Elizabeth ana tufuw an i Aaron ana rara’ane na tufuw. ");
INSERT INTO aai_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iti orot aawan hairi God matanamaim hai yawas i gewasin, God ana ofafar naatu ana tur etei hibosiyasiyar hibi’ufunun. ");
INSERT INTO aai_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Baise hairi natunatuh en hima hin hiregah hibabine, anayabin Elizabeth i a’arin. ");
INSERT INTO aai_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Veya ta Jerusalem Tafaror Bar gagamin wanawanan firis ana bowabow isan matan fufur tebowabow na’atube, Zechariah ibo ana veya na tit Tafaror Bar wanawanan ana bowabow isan run. ");
INSERT INTO aai_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Firis hai binanakwaramaim eo na’atube, gem kakafiyin tafanamaim fi’ufiu afunin isan hibi’arow Zechariah wabin tit, basit na Regah ana Tafaror Bar wanawanan run. ");
INSERT INTO aai_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Naatu Tafaror Bar wanawanan fi’ufiu Zechariah ea’afun ana veya’amaim, sabuw etei i bar ufunane hibat hiyoyoyoban. ");
INSERT INTO aai_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Regah ana tounamatar, gem kakafiyin tainin asukwafune fi’ufiu ea’afunimaim tit irerereb bat. ");
INSERT INTO aai_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah tounamatar tit batabat itin yan hamu iwa’an ana bir ra’at, ");
INSERT INTO aai_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","baise tounamatar eo, “Zechariah men inabir! God a yoyoban nowar. O aaw Elizabeth boro yan namatar naatu nataub kek orot nayai o wabin John iniwab. ");
INSERT INTO aai_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nati kek orot natutufuw ana veya o ya wanawanan boro yasisir kawasa awan nakaratan, na’atube sabuw moumurih maiyow auman boro hiniyasisir, ");
INSERT INTO aai_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","anayabin Regah matanamaim i boro orot gagamin ta. Iti kek wine o harew fokarih men natom, naatu God Anunin Kakafiyin boro niwanasum auman nama’ama natufuw. ");
INSERT INTO aai_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I boro Israel sabuw maumurih na’in nabow hinamatabir maiye Regah hai God isan. ");
INSERT INTO aai_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naatu God ana dinab orot Elijah ana fair baib na’atube boro nab Regah aunan ni’iyon nan, kek tamahinah bairi dogoroh nikitabir hinan hinita’imon maiye; sabuw baifanasairayah dogoroh nikitabir hinan mutufor ma ana not gewasin hinab, naatu Regah ana sabuw nabobunabuna’ih.” ");
INSERT INTO aai_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah tounamatar iu, “Iti i boro mi’itube anitumatum? Anayabin ayu i ai regah, naatu aawau auman ibabine sawar.” ");
INSERT INTO aai_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tounamatar iya’afut eo, “Ayu i Gabriel God nanamaim abatabat, imih ayu iyafaru o airit oisan tur gewasin abai ana o a tur ao’owen, ");
INSERT INTO aai_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","baise ayu au tur men itumitum, imih o boro mena nabit, inama nanan sawar mataramih ao ana veya’amaim namatar, abisa ao’omatan nan niturobe.” ");
INSERT INTO aai_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nati ana maramaim sabuw ufunane hima’am hai kasiy ra’at, Zechariah manin maiyow Tafaror Bar wanawanan ma’am isan. ");
INSERT INTO aai_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Naatu Zechariah Tafaror Barene titit ana mar, tur oisan menan bit, sabuw nati’imaim hi’itin hiso’ob ina’inan ta isan matar, naatu tur o isan menan bit umanamaim imanuman bairi hio. ");
INSERT INTO aai_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zechariah ana bowabow Tafaror Bar wanawanan sasawar ufunamaim matabir maiye na ana bar tit. ");
INSERT INTO aai_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nati ufunamaim a wan Elizabeth yan matar, sumar etei umatroun na’atube baremaim nutanub ma. ");
INSERT INTO aai_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeth eo, “Regah bounabo ibaisu au biya’ohow, orot babin matahimaim etei’imak bosair.” ");
INSERT INTO aai_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth ana sumar umatroun ta’imon ana maramaim God ana tounamatar Gabriel iyafar in Galilee wanawananamaim bar merar ta wabin Nazareth imaim tit. ");
INSERT INTO aai_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nati’imaim babitai ta biyan numin Joseph, aiwob orot David ana agir ta i ana rum hiomatan ma’ama biyan tit, babitai wabin Mary. ");
INSERT INTO aai_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tounamatar na babitai biyan tit eo, “Tufuw isa nama! Regah o isa i yan ebaib kwanekwan, naatu baigegewasin o ebit.” ");
INSERT INTO aai_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary iti tur nonowar ana veya biyababan na’atube bai naatu ana kasiy ra’at iti merarayow ana’an isan. ");
INSERT INTO aai_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Baise tounamatar eo “Mary, men inabirumih, anayabin God o isa ebiyasisir gagamin maiyow. ");
INSERT INTO aai_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","O boro ya namatar inatoub kek orot inayai, naatu wabin Jesu iniwab. ");
INSERT INTO aai_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I boro orot gagamin naatu God auyomtoro’ot Natun narouw nao, naatu Regah God boro aiwob nitin, marasika ana’agir David bitin na’atube. ");
INSERT INTO aai_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Naatu Jacob ana rara’ane i boro ni’aiwob wanatowan, naatu ana aiwob i boro nama wanatowan, wanatowan ana yomanin en.” ");
INSERT INTO aai_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary tounamatar isan eo, “Ayu i biyau numin. Iti i boro mi’itube namatar?” ");
INSERT INTO aai_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tounamatar iya’afut eo, “Anun kakafiyin boro niwani, naatu God ana fair boro natarsumi, imih iti kek Kakafiyin natutufuw i boro God Natun hinarouw hinao. ");
INSERT INTO aai_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naatu o tura Elizabeth sabuw a’arin hirouw hio baise boun babine tafan yan matar ana sumar umatroun ta’imon sawar. ");
INSERT INTO aai_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anayabin God isan sawar etei’imak i men ta fokarinamih.” ");
INSERT INTO aai_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary eo, “Ayu i Regah ana akir wairafin, abis isou kuo na’atube namatar.” Naatu tounamatar Mary itumar tit. ");
INSERT INTO aai_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nati ana veya’amaim, Mary matan kabiy bobuna ra’iy yen in Judah wanawananamaim oyaw na’atune bar merar gagamin ta imaim tit, ");
INSERT INTO aai_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zechariah ana bar wanawanan run Elizabeth ana merar yi. ");
INSERT INTO aai_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth Mary ana merarayow nonowar ana maramaim, yan wanawanan kek inu’in ia’ayob, nati’imaim Anun Kakafiyin Elizabeth iwan ");
INSERT INTO aai_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fanan aumetawat eo, “God ana baigegewasin o ebit baibin etei tafahimaim, naatu ya wanawanan a ub auman God ebigegewasin! ");
INSERT INTO aai_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aisim sawar gagamin na’in iti na’atube isou matar, au Regah hinah na ebinanawanu? ");
INSERT INTO aai_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","O a merarayow anonowar ana mar, kek yau wanawanan inu’in yasisir auman ia’ayob. ");
INSERT INTO aai_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","O a baitumatumamaim baigegewasin ibai, God eo’omatani boro nan turobe namatar!” ");
INSERT INTO aai_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary eo, “Ayu dogorou wanawanan God ebobora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Naatu yau wanawanan yasisir awan karatan, God au baiyawasenayan isan abiyasisir. ");
INSERT INTO aai_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Anayabin i ana akir wairafin wabin men gagamin baise nuh, imih boun ebubusuruf sabuw etei boro ayu baigegewasinayan hinarouw hinao. ");
INSERT INTO aai_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anayabin sawar gagamih God Fairin ayu isou sinaf. I wabin i kakafiyin, ");
INSERT INTO aai_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","I ana kabeber i aunan etuwatuw, sabuw hitufuw tema’am, afa boro hina tutufuw isah, iyab God hibiruw tekakakafiy i boro nakabibirih. ");
INSERT INTO aai_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God umanamaim sawar fairih sinaf, naatu uman fairinamaim sabuw bai o’orotoyah hai not wa’iwa’irih etei egugurusen. ");
INSERT INTO aai_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aiwob fairih hai ura ma’ama’amaim bow yara’iyih, naatu sabuw hiyara’iyih hima’am bow hiyen efan itih. ");
INSERT INTO aai_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sabuw aa himomorob, sawar gewasihimaim ituwih, baise sabuw sawar wairafih umah en iyafarih hin. ");
INSERT INTO aai_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana omatanen ata a’agir eo’omatanih i kaif, naatu na ana akirwairafin Israel baibais itin ");
INSERT INTO aai_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham nuh kakabibir na’atube, i wawawan etei boro nakabibirih wanatowan!” ");
INSERT INTO aai_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary sumar etei tounu na’atube Elizabeth hairi hima, imaibo matabir maiye na ana bar tit. ");
INSERT INTO aai_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth ana toub isan veya na tit, naatu toub ana kek orot yai. ");
INSERT INTO aai_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tain tuwan naatu ana ofonah, God ana baigegewasin gagamin na’in Elizabeth bitin ana tur hinowar hina ana merar hiyi bairi hiyasisir. ");
INSERT INTO aai_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Naatu fur ta’imon ufunamaim, kek ana’ar mo’on afuwin wabin baiwabin isan tain tuwan etei hina. Tain tuwan hikokok kek wabin i boro Zechariah, tamah wabinamaim hitiwabimih hio, ");
INSERT INTO aai_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","baise hinah eo, “En! Kek wabin i boro John taniwab.” ");
INSERT INTO aai_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sabuw hio, “O taituwa wabih men ta nati na’atube ema’ama boro kek wabin nati taniwab.” ");
INSERT INTO aai_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Basit umahimaim kek tamah isan himan wabin menatan kokok baiwabin isan hibatiy. ");
INSERT INTO aai_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah eo fef hibai hina hitin imaim kirum eo, “Kek wabin i John.” Sabuw etei hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nati ana veya’amaim Zechariah menan bit ma’am menan kerer busuruf tur eo, God bora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Taintuwan etei awah hae’e hai baifofofor ra’at, baise abisa himamatar ana tur tasasar tit tafaram Judea wanawanan sabuw etei hinowar. ");
INSERT INTO aai_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sabuw etei iti sawar matar ana tur hinonowar isan hai kasiy ra’at taiyuwih hibabatiyih hio, “Iti kek narara’at ana itinin i boro mi’itube?” Anayabin Regah uman i iti kek biyanamaim ma’am. ");
INSERT INTO aai_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John tamah Zechariah Anun Kakafiyin targabuw, God ana ewamaim tabor eo. ");
INSERT INTO aai_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Regah tanabora’ara’ah, Israel sabuw hai God, anayabin i ana sabuw baiyawasih isan natit, ");
INSERT INTO aai_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Baiyawasenayan fairin anababatun David ana rara’ane enan, ");
INSERT INTO aai_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","marasika ana dinab wanawanahimaim eo’omatanih na’atube. ");
INSERT INTO aai_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","boun it boro ata kamabiy sabuw umahine, naatu sabuw fairih tibifa’ifa’it umahine niyawasit. ");
INSERT INTO aai_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ana obaibasit kakafiyin bimatar imaim nuh ata a’agir kabeber itih, ");
INSERT INTO aai_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","naatu iti obaibasit i marasika God ata agir Abraham eomatan, ");
INSERT INTO aai_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","imih boun it ata kamabiy sabuw umahine baiyawasit isan natit ebiyawasit, naatu fair ebitit God isan men erebir auman tanabow, ");
INSERT INTO aai_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","God matanamaim tanakakaf naatu tanayasairit ata ef mutufurinamaim tanakwafir wanatowan, wanatowan. ");
INSERT INTO aai_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naatu o ayu natu, o boro God auyomtoro’ot ana dinabumih inamatar, Regah aunan ini’iyon inan ana ef inayabuna, ");
INSERT INTO aai_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ana sabuw yawas isan inakubuna hai tur ina’owen bowabow kakafih hinihamiyen God hai kakafih nanotawiyen yawas hinab. ");
INSERT INTO aai_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anayabin ata God, i ana manaw kabeber wairafin, i wanawananamaim marakaw marane boro nakusisiar nare, ");
INSERT INTO aai_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sabuw iyab guguminamaim tema’am naatu murumurubih hai youninamaim tema’am tafatamaim namarakaw, at narumutufur nanawiyit tanatit tufuw ana efamaim tanaremor.” ");
INSERT INTO aai_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kek biyan naatu ayubin hairi ana fofonin ra’at yen orot matar, naatu run in arar yan imaim ma ana fair bai, imaibo tit ana bowabow Israel sabuw etei nahimaim busuruf bow. ");
INSERT INTO aai_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nati ana veya, sabuw iyab Roman gawan babanamaim hima’am wabih bukamaim kirum isan Caesar Augustus iuwih. ");
INSERT INTO aai_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sabuw baiyab isan marasika i men hiyab, baise Quirinius tafaram Syria isan bigawan ana veya imaibo hibusuruf sabuw hiyab wabih bukamaim hikirum. ");
INSERT INTO aai_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nati baiyab ana veya’amaim sabuw etei hin hai bar merar gagamihimaim hitit wabih bukamaim hikirum. ");
INSERT INTO aai_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph auman tafaram Galilee wanawanan bar merar ta wabin Nazareth imaim ma’am yen na Judea wanawanan bar merar ta wabin Bethlehem imaim tit, aiwob orot David ana tutufuw efan. Joseph na nati’imaim tit, anayabin i David uwan ta. ");
INSERT INTO aai_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naatu Joseph nati’imaim in titit ana’an ta i Mary hairi tabin isan hi’omatanih hima’am, imih hairi wabih bukamaim kirumin isan hiyen hin. Nati ana veya Mary i yan auman, ");
INSERT INTO aai_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","hiyen hina Bethlehem hima’am, Mary ana toub ana veya na tit. ");
INSERT INTO aai_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Naatu toub ana kek orot ain yai, faifuw ta bai e’armetan for hai bay te’aau ana efanamaim i’inuw in, anayabin nanawan bar etei sabuw hirun hibai karam. ");
INSERT INTO aai_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nati gugumin bobaituw kaifenayah afa Bethlehem sisibinamaim hima hai bobaituw hikakaifen, ");
INSERT INTO aai_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","basit Regah ana tounamatar isah irerereb, naatu Regah ana marakaw tafahimaim kusisiar re biyah etei marakaw hi’itin hai bir ra’at. ");
INSERT INTO aai_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Baise tounamatar iuwih eo, “Men kwanabir! Ayu tur gewasin abai a tur owenamih ana, iti tur gewasin sabuw hinanonowar boro etei hiniyasisir. ");
INSERT INTO aai_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anayabin iti boun gugumin David ana bar meraramaim, kwa a baiyawasenayan Regah Keriso i tufuw. ");
INSERT INTO aai_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naatu ana i’inan, i boro iti na’atube kwana’itin, kwananan kek boro faifuw boubunamaim hisum bobaituw hai bay te’aa ana efanamaim hi’inuw inu’in kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iti na’at eo marta’imon, maramaim tounamatar hai kou’ay gagamin na’in hitit, ana merar hiyi hibora’ara’ah hio, ");
INSERT INTO aai_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Marakaw bonamanamarin etei God auyomtoro’ot isan nama, naatu tafaramamaim sabuw iyab God isah ebiyasisir tufuw isah nama.” ");
INSERT INTO aai_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tounamatar himatabir maiye hin mar wanawanan hirur ufunamaim, bobaituw kaifenayah himisir hio, “It boro tanan Bethlehem tanatit, sawar abisa himatar Regah eo tanonowar i tana’itah.” ");
INSERT INTO aai_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Basit matah kabiy himisir hin Mary Joseph hairi hinuwihih hinan hitita’urih, naatu kek bobaituw hai bay te’aa hai efanamaim hi’inuw inu’in hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bobaituw kaifenayah kek hi’i’itin ufunamaim, kek isan tounamatar mi’itube hio hinonowar hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sabuw iyabowat nati’imaim hima’am bobaituw kaifenayah iti kek isan hio hinonowar hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Baise Mary iti tur nonowar i dogoronamaim ya hima inotanot. ");
INSERT INTO aai_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bobaituw kaifenayah himatabir hinan efamaim, abisa tounamatar hio hinonowar na’atube hi’i’itin isan, God ana merar hiyi hibora’ara’ah auman hin. ");
INSERT INTO aai_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fur ta’imon sasawar ufunamaim, Kek hibai hina ana ar kanabin hi’afuw, wabin Jesu hiwab. Wabin marasika Mary yan matara’e ma’am ana veya, tounamatar na eo na’atube. ");
INSERT INTO aai_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kousouwih isan Moses ana ofafaramaim bi’obaiyih na’atube, ana veya na tit hibisawar ufunamaim, Mary Joseph hairi Jesu hibai hina Jerusalem hitit, Tafaror Bar hirun Regah ana siwaramih hitin. ");
INSERT INTO aai_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anayabin Regah ana ofafaramaim eo na’atube, “Kek orot ain i kwanaya’asair Regah kwanitin.” ");
INSERT INTO aai_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naatu Regah ana ofafaramaim eo na’atube sibor ya’inamih auman hin, mamu imak rou’ab naatu ma’ufor rou’ab hibow auman hina hitit. ");
INSERT INTO aai_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","nati ana veya’amaim, regah ta wabin Simeon i Jerusalem ma’am, iti regah ana yawas i mutufurin naatu yoyoban wairafin. God Anunin tar gabuw ana ofafar eo na’atube ma bow God ana sabuw Israel baiyawasih isan eomatanih i ma kakaif. ");
INSERT INTO aai_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anun Kakafiyin God ana buriburih isan irerereb eo, “O boro yawas inama’am Regah God ana Roubininenayan natufuw ina’itin imaibo inamorob.” ");
INSERT INTO aai_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nati ana veya’amaim Jesu hinah tamah hibai hina hirun, hai binanakwaramaim ofafar eo na’atube sinaf isan. Naatu God Anun Kakafiyin auman Simeon bonawiy na Tafaror Bar run. ");
INSERT INTO aai_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon kek bai irurubun hiyaf God ana merar yi eo, ");
INSERT INTO aai_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Regah i’o na’atube a’omatanen ikaif, imih boro’obo a’akir wairafin tufuwamaim inihamiy niyarir. ");
INSERT INTO aai_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Taiyuwu matau’umaim a baiyawasenayan tafaramamaim ibiyafar aitin. ");
INSERT INTO aai_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iti baiyawasenayan i ibogaigiwas sabuw etei matahimaim kubitih boro hina’itin. ");
INSERT INTO aai_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naatu yawas ana marakaw boro nab natit Ufun Sabuw isah nirerereb hina’itin, naatu Israel sabuw nahimaim o ayawas ana marakaw boro nama.” ");
INSERT INTO aai_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kek hinah tamah Simeon kek isan abisa eo hinonowar i hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon baigegewasin itih sawar, basit kek hinah Mary isan eo “Iti kek i God rubin sabuw moumurih na’in Israel wanawanan boro nagurusih naatu moumurih na’in boro niyawasih. Hai kirikirifot etei boro niwa’an hinirerereb, ina’i’inan nati isan sabuw boro ana tur hinakwahir. ");
INSERT INTO aai_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Naatu yababan o dogor wanawanan boro ahay na’atube nay.” ");
INSERT INTO aai_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nati’imaim dinab babine ta Asher ana bigane ma’am, wabin Anna Fanuel natun, Anna tabin kwamur etei seven ma naatu aawan morob. ");
INSERT INTO aai_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kwamur etei 84 i kwafur ma naatu Tafaror Bar men kafa’imo ihamiy. Fai mar i yohar, ma yoyoban God bobora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nati ana veya’amaim babine na run God ana merar yi. Jerusalem wanawanan sabuw iyab baiyawasenayan isan hima hikakaif hai tur eowen eo, “Roubininenayan natit.” ");
INSERT INTO aai_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph, Mary hairi Regah ana ofafaramaim abisa eo na’atube hisisinaf ufunamaim, himatabir maiye hin hai bar merar wabin Nazareth imaim hitit, tafaram Galilee wanawananamaim. ");
INSERT INTO aai_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naatu God ana bosiyasiyar wanawananamaim Kek ra’at yen ana fair bai fudirin rerekab naatu ana not ra’at taseseb. ");
INSERT INTO aai_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kwamur ta ta wanawanahimaim Jesu hinah tamah mar etei Tar Nowaten Hiyuw isan au Jerusalem tenan. ");
INSERT INTO aai_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ana veya ta Jesu ana kwamur 12 na’atube basit hiyen hin hiyuw ta isan hai binanakwar eo na’atube. ");
INSERT INTO aai_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hiyuw ufunamaim hai ubar himatabir maiye, baise kek Jesu i Jerusalem ma. Hinah tamah men kafa’imo hiso’ob. ");
INSERT INTO aai_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hinotanot kek i nati sabuw wanawanamaim bairi hinan hirouw, imih nati veya ta’imon i nuhih fot hiremor hin, baise veya re birabirab, hibusuruf kek hinuwih, hai ofonah naatu taituwah hibabatiyih hinunuwet, ");
INSERT INTO aai_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","men hitita’ur, basit himatabir maiye hin Jerusalem hitit hinuwih. ");
INSERT INTO aai_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Veya baitounin Tafaror Bar wanawanan Ofafar Bai’obaiyenayah wanawanah mare tur hi’o nowar ma bibabatiyih hitita’ur. ");
INSERT INTO aai_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sabuw etei Jesu tur buriburih eo, naatu iyafutih hinonowar isan, hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hinah tamah kek hitita’ur ana veya hiororsa’irih Mary Natun iu, “Aro aisim iti na’atube isinaf? Tamat airi ai yababan ra’at, o anuwihi men kikimin ta.” ");
INSERT INTO aai_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iyafutih eo, “Aisim ayu kwanunuwuhu? Kwa men kwaso’ob ayu i Tamai ana baremaim ama’am?” ");
INSERT INTO aai_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Baise Kek abisa eo hinah tamah ana tur naniyan men hibai. ");
INSERT INTO aai_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Basit Jesu misir bairi himatabir maiye hire hin Nazareth hitit, imaim hinah tamah fanah bosiyasiyar bairi hima naatu hinah iti sawar etei ana notamaim ya ma inotanot. ");
INSERT INTO aai_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu ra’at yen orot matar ana not auman ra’at yen God itin yan sisir na’atube sabuw auman. ");
INSERT INTO aai_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roman sabuw hai orot gagamin wabin Caesar Taibirias bi’aiwob ana kwamur 15 baib wanawananamaim Pontius Pilate i Judea wanawanan igawan, Herod i Galilee isan igawan, naatu tain Philip i tafaram Iturea naatu Trakonaitis hairi isah igawan naatu; Lysanias i tafaram Abilene isan igawan. ");
INSERT INTO aai_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Naatu Annas Kaiafas hairi i firis gagamih. Nati ana maramaim Zechariah natun John arar yan ma’am God ana tur na biyan tit. ");
INSERT INTO aai_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Basit misir tit harew Jordan, sisibinamaim tafaram ta ta run tit binan eo, “Kakafih kwasisinaf kwanihamiyen kwanan bapataito anit saise God boro a kakafih nanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","God ana dinab orot Isaiah ana Bukamaim kikirum na’atube eo, “Orot ta arar yan bat eafa’af, ‘Regah isan ef kwanabo gaigiwas, ef kwanimutufur iwat naremor nan! ");
INSERT INTO aai_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Awa’awah etei kwanatounen hinayen hinituturin, heher oyaw etei kwanatar hinare hinituturin. Ef bibirih kwanarumutufuren, naatu ef kakafih kwanayabuna gewas. ");
INSERT INTO aai_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sabuw tutufin etei God baiyawasenayan nabiyafar boro hina’itin!’” ");
INSERT INTO aai_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sabuw rau’ay gagamin John bapataito baitih isan hinan iuwih eo, “Kok natunatun! Yait imatnuwi God ana baimakiy nabiyafar boro wan kwanabibir? Men kwananot kwanao, ayu bapataito abai imih boro natafafaru en. ");
INSERT INTO aai_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Baise wantoro’ot i a yawas nigewasin kwanama saise nati’imaim boro kwa isa niturobe bowabow kakafih kwasisinaf etei kwaihamiyen. Naatu men kwanao, Abraham i aki ai agir imih God boro men baimakiy niti! Baise a tur ao’owen God karam kabay iti nabow niwa’an Abraham wawawan hinamatar. ");
INSERT INTO aai_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ai tebiw ro’oro’oh men gewasih i boro hinatar wairaf wah hinayara’aten hina’arat, imih kariwak i ai tarinamih hiya’ataitik inu’in.” ");
INSERT INTO aai_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sabuw hibatiy, “Bo aki boro mi’itube ana sinaf?” ");
INSERT INTO aai_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Iyafutih eo, “O yait isa biya baibiyon rou’ab hinama’am ta inab menatan isan biya baibiyon en initin, naatu yait isan bay nakakaram nafaram.” ");
INSERT INTO aai_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kabay o’onayah bapataito bainamih hina hitit hibatiy, “Bai’obaiyenayan aki boro mi’itube ana sinaf?” ");
INSERT INTO aai_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Kwa kabay o’onamih hio hibiyuni na’atube ana fofonin kwana’o’on men tafan kwanayara’ah auman kwana’o’onamih.” ");
INSERT INTO aai_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Roman baiyowayah orot afa auman hio, “Bo aki i boro mi’itube?” Iuwih eo, “Sabuw men kwanao kikinih kabay hinitimih o men baifuwenamaim hai kabay kwanabowamih, baise a bowabow isan a baiyan hinabit i kwaniyasisir.” ");
INSERT INTO aai_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sabuw hai notamaim hinotanot John i baiyawasenayan. ");
INSERT INTO aai_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Imih John iuwih eo, “Ayu i harewamaim bapataito abit, baise orot ta boro enan ana fair i ra’at. Ayu i men gewasu boro an ana baibiyon anaku’ub. I boro Anun Kakafiyin naatu wairafamaim bapataito nit. ");
INSERT INTO aai_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I umanamaim i roububuna’en ana sawar auman bai enan, boro imaim wheat narububunai ani’anin korom nayai, naatu hain boro nabow nan wairaf wanatowanin in etoto’ab wan naya na’afusar.” ");
INSERT INTO aai_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","John ef maumurih maiyow sabuw isah binan naatu hai yawas auman botabirinamih iuwih. ");
INSERT INTO aai_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Baise Herod tuwah aawan Herodias bi’aawan isan, naatu bowabow kakafih maumurih maiyow sisinaf isan John kwarar yayamutufur ana maramaim ");
INSERT INTO aai_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod ibanaka sinaf kakafin tabow sinaf John bai dibur bar yari’iy. ");
INSERT INTO aai_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sabuw etei’imak bapataito hibaib ufunamaim, Jesu auman ibapataito. Naatu yoyoyoban ana maramaim mar botawiy, ");
INSERT INTO aai_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Anun Kakafiyin marane mamu imakabe ra’iy targabuw. Naatu orot fanan marane tit. “O i ayu Natu ta’imonamo. O isa ayu abiyasisir.” ");
INSERT INTO aai_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu ana kwamur 30 imaim ana bowabow busuruf. Sabuw hisoso’ob Jesu i Joseph natun imih Joseph isan hinot, Joseph tamah i Heli, ");
INSERT INTO aai_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tamah i Mathat, Mathat tamah i Levi, Levi tamah i Melkai, Melkai tamah i Jannai, Jannai tamah i Joseph, ");
INSERT INTO aai_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph tamah i Matathias, Matathias tamah i Amos, Amos tamah i Nahum, Nahum tamah i Esli, Esli tamah i Naggai, ");
INSERT INTO aai_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai tamah i Maatah, Maatah tamah i Matathias, Matathias tamah i Semein, Semein tamah i Josech, Josech tamah i Joda, ");
INSERT INTO aai_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda tamah i Joanan, Joanan tamah i Rhesa, Rhesa tamah i Zerubbabel, Zerubbabel tamah i Shealtiel, Shealtiel tamah i Neri, ");
INSERT INTO aai_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tamah i Melkai, Melkai tamah i Addi, Addi tamah i Cosam, Cosam tamah i Elmadam, Elmadam tamah i Er, ");
INSERT INTO aai_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tamah i Joshua, Joshua tamah i Eliezer, Eliezer tamah i Jorim, Jorim tamah i Mathat, Mathat tamah i Levi ");
INSERT INTO aai_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi tamah i Simeon, Simeon tamah i Judah, Judah tamah i Joseph, Joseph tamah i Jonam, Jonam tamah i Eliakim, ");
INSERT INTO aai_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim tamah i Melea, Melea tamah i Menna, Menna tamah i Matatha, Matatha tamah i Nathan, Nathan tamah i David, ");
INSERT INTO aai_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David tamah i Jesse, Jesse tamah i Obed, Obed tamah i Boaz, Boaz tamah i Salmon, Salmon tamah i Nashon, ");
INSERT INTO aai_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon tamah i Aminadab, Aminadab tamah i Admin, Admin tamah i Arni, Arni tamah i Hezron, Hezron tamah i Perez, Perez tamah i Judah, ");
INSERT INTO aai_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah tamah i Jacob, Jacob tamah i Isaac, Isaac tamah i Abraham, Abraham tamah i Terah, Terah tamah i Nahor, ");
INSERT INTO aai_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor tamah i Serug, Serug tamah i Reu, Reu tamah i Peleg, Peleg tamah i Eber, Eber tamah i Shelah, ");
INSERT INTO aai_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah tamah i Cainan, Cainan tamah i Arafasad, Arafasad tamah i Shem, Shem tamah i Noah, Noah tamah i Lamech, ");
INSERT INTO aai_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech tamah i Methuselah, Methuselah tamah i Enoch, Enoch tamah i Jared, Jared tamah i Mahalalel, Mahalalel tamah i Cainan, ");
INSERT INTO aai_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan tamah i Enos, Enos tamah i Seth, Seth tamah i Adam, Adam tamah i God. ");
INSERT INTO aai_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu biyan tutufin etei God Anun Kakafiyin karatan Jordan harewane matabir yen naatu Anun Kakafiyin i’unawiy in Judea arar yan tit. ");
INSERT INTO aai_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nati’imaim veya etei 40 bay en ma’am ufunamaim bayumih morob. Naatu nati ana maramaim Demon Mowan na routobon itin, ");
INSERT INTO aai_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","eo, “O i God Natun na’at, kabay iti ku’uwih tebotabir rafiy tematar ku’aa.” ");
INSERT INTO aai_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Baise Jesu iya’afut eo, “Buk Atamaninamaim hikirum hio, ‘Orot men bayumaim akisin niyawasimih.’” ");
INSERT INTO aai_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naatu Demon Mowan Jesu i’unawiy maiye hiyen hin koun yan bat, imatanubamo tafaram tutufin etei itin. ");
INSERT INTO aai_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Naatu Demon Mowan eo, “Ayu boro fair etei o anit naatu tafaram ana aiwob auman boro anit. Anayabin etei’imak ayu hitu, ayu orot yait arurubin boro i anitin nab. ");
INSERT INTO aai_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imih O ayu inakwakwafiru na’at, iti sawar etei boro o nowamih anit.” ");
INSERT INTO aai_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu iya’afut eo, “Buk Atamaninamaim hikirum hio, ‘A Regah a God akisinamo inakwafir isan inabow.’” ");
INSERT INTO aai_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Naatu iban maiye Demon Mowan Jesu bai nawiy hin Jerusalem hitit, hiyen hin Tafaror Bar tafantoro’ot bat naatu iu, “O God Natun na’at, kukununuw kura’iy. ");
INSERT INTO aai_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anayabin Buk Atamaninamaim hikirum hio, ‘God boro ana tounamatar na’uwih hinatafafari, ");
INSERT INTO aai_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","umah yanamaim inare hinabuwi, boro men kabay a narab natakakirimih.’” ");
INSERT INTO aai_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Baise Jesu iya’afut iu, “Buk Atamaninamaim hikirum hio, ‘A Regah a God men routobon initinimih.’” ");
INSERT INTO aai_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Demon Mowan routobon ta ta Jesu bitin ufunamaim itumar tabaratait tit mar kafai ufunamaim bat. ");
INSERT INTO aai_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Imaibo Jesu God Anun Kakafiyin ana fair bai auman matabir na Galilee tit. Ana tur ra’at tasasar tit tafaram nati sisibinamaim hima’am etei’imak hinowar. ");
INSERT INTO aai_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kou’ay Bar wanawanan run bi’obaibiyih sabuw etei’imak tur hinonowar, hifai hibora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesu remor na Nazareth tit, bar merar i ma rara’atamaim, Baiyarir ana veya matanfufur isisinaf na’atube, in Kou’ay Bar run, Buk ta baiyab isan misir. ");
INSERT INTO aai_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Naatu dinab orot Isaiah ana buk hibai Jesu hitin, bai rusasar tur iti na’atube hikirum inu’in ana efanamaim tit. ");
INSERT INTO aai_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Regah Anun Kakafiyin i ayu wanawana’umaim ema’am, anayabin ayu rubinu tur gewasin sabuw yababan wairafih isah anabinan. God iyafaru sabuw dibur tema’am hai tur ana’owen anabotaitih, matah fim anibaisih matah nigewasin hinanuw. Naatu sabuw iyab hirouw tibia’afiyih anibaisih hinama gewas. ");
INSERT INTO aai_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Naatu anakurereb sabuw hinanowar Regah ana sabuw baiyawasih isan ana veya i natit.” ");
INSERT INTO aai_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesu buk itakum orot kaifenayan itin i mara’iy. Sabuw Kou’ay Bar wanawanan hima’am etei’imak matah hito’ab Jesu hi’itin kikin. ");
INSERT INTO aai_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Baise Jesu misir busuruf sabuw hai tur eowen eo, “Tur iti aiyab kwananowar i boun na iturobe.” ");
INSERT INTO aai_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sabuw etei’imak nati’imaim hima Jesu eo hinonowar hio, “Turobe iti orot ana tur i gewasin.” Naatu tur mumunin bitan eo hinonowar isan hifofofor, naatu taiyuwih hibatiyih hio, “Iti orot i Joseph natun?” ");
INSERT INTO aai_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naatu Jesu iuwih eo, “Binan tur gewasin matan fufur sabuw teo’omaim boro kwana’uwu kwanao, ‘Adanafur ana orot, taiyuw kwiyawasi.’ Naatu iban boro kwana’uwu maiye, ‘Capernaum ma bow bigan tanonowar na’atube, iti ana bar ana meraramaim nabow tana’itin.’” ");
INSERT INTO aai_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesu iban maiye iuwih eo, “Anababatun a tur ao’owen, dinab orot ana bar ana meraramaim boro men ana merar hinay hinabaimih. ");
INSERT INTO aai_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Naatu tur anababatun a tur ana’owen, Elijah ma’am ana veya’amaim kwafukwafur maumurih na’in Israel wanawanan hima’am afow matar. Nati ana veya’amaim kwamur etei tounu naatu sumar six na’atube toun men yar, baimar kakafin na, nati tafaram wanawananamaim bar merar etei’imak bay i’en. ");
INSERT INTO aai_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nati ana veya’amaim God men Elijah iyafar Israel wanawanan kwafur babin ta ibaisimih, baise Sidon wanawanan Zarepat bar meraramaim kwafur babin ta’imon ma’am isan God iyafar in tit baibais itin. ");
INSERT INTO aai_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naatu dinab orot Elisha ma’am ana veya Israel sabuw moumurih maiyow kokom ani’anih hima’ama men yait ta na Elisha iyawasimih, baise tafaram Syria orot wabin Naaman akisinamo na Elisha iyawas.” ");
INSERT INTO aai_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sabuw Kou’ay Bar wanawanan hima iti tur hinonowar ana veya, yah wanawanan so’aso’ar yen higagamat, ");
INSERT INTO aai_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","himisir Jesu hibai hitain ufun hitit, bar merar hitumar, hiyen fan tafan hibat hitarouw fan tare’emih hiwa’an, anayabin bar merar i fan tafan hiwowab hima’am. ");
INSERT INTO aai_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Baise Jesu sabuw rau’ay gagamin hibatabat umah aren sorabon hai foun remor tit in. ");
INSERT INTO aai_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesu na Galilee wanawananamaim bar merar ta wabin Capernaum imaim tit, Baiyarir ana veya run sabuw i’obaibiyih hima hinonowar. ");
INSERT INTO aai_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sabuw etei’imak hifofofor men kafaita. Anayabin ana tur eo i tur anababatun naatu fairin. ");
INSERT INTO aai_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nati Kou’ay Baremaim orot ta wagabur iwan demon kakafin anababatun auman na run ma’am, fanan aumetawat na’in iwow eo, ");
INSERT INTO aai_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei! Aki isai abisa inasinafumih kunan? Aki gurusi’imih? Jesu Nazareth mowan. Ayu aso’ob. O i yait, O i God ana tur abarayan Orot Kakafiyin.” ");
INSERT INTO aai_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu wagabur mowan kwarartatab eo, “Yate inbainub orot biyanamaim kutit!” Wagabur mowan sabuw nahimaim orot itaiy re tabaratait tit, men isan abisa ta sinafumih. ");
INSERT INTO aai_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Baise Sabuw etei’imak hai baifofofor ra’at, taiyuwih hibabatiyih hio, “Iti orot ana tur i fair kwanekwan. Ana onowaten naatu ana fair auman iti tur eo demon kakafih biyunih i hitit!” ");
INSERT INTO aai_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Naatu Jesu abisa sisinaf isan ana tur tasasar tit tafaram nati hima’am wanawanan etei hinowar. ");
INSERT INTO aai_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu misir Kou’ay Bar itumar tit na Simon ana bar tit, Simon rawan babin sawow biyan fora’ab anababatun inu’in, sabuw Jesu hifefeyan baiyawasinamih hio. ");
INSERT INTO aai_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Basit Jesu na babin inu’in sisibin tit bat sawow i’ari’ar naatu sawow babin biyanane tit, babin yawas misir bay bow eafusar itab hi’aa. ");
INSERT INTO aai_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Veya re’er ufunamaim, sabuw sawow yumatah ta ta hibow hi’inu’in, turahinah hibuwih hina Jesu biyan hitit, sabuw ta’ita’imon butubutubunih etei’imak hiyawas. ");
INSERT INTO aai_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sabuw moumurih na’in auman biyahine demon kakafih hitit hiwow hio, “O i God Natun!” Baise Jesu demon awah bofafaren men karam boro hitao’rereb. Anayabin demon hiso’ob Jesu i Roubininenayan. ");
INSERT INTO aai_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Martot auman Jesu nati bar merar itumar tit in efan ta nautanubinamaim akisinamo ma. Baise sabuw hinuwih hinan hititita’ur ana veya, bairi nati’imaim ma isan hi’otan. ");
INSERT INTO aai_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Baise Jesu iuwih eo, “Ayu boro anan God ana aiwob isan tur gewasin bar merar afa’amaim auman anabinan hinanowar. Anayabin ayu nati bowabow isan God iyunu ana.” ");
INSERT INTO aai_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naatu Jesu tafaram Judea wanawananamaim Kou’ay Bar etei run tit binan remor. ");
INSERT INTO aai_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Veya ta Jesu Genesaret harew kukuf rewarewan batabat sabuw rou’ay gagamin na’in God ana tur nowaramih hinahinah hina biyan hitit. ");
INSERT INTO aai_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naatu nati dones yanamaim siy bowayah hai wa rou’ab hitain hiyen hi’inu’in Jesu itah, baise siy bowayah hin hai buwat hisasouwen. ");
INSERT INTO aai_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu wa nati awar hibatabat wanawanahimaim Simon ana wa bai afe’en yen mare iu inatait tetenane rouw. Naatu Jesu mare sabuw rau’ay gagamin ma i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bi’obaibiyih ufunamaim, Simon iu, “A’wa kukutait itit taiyomaim a sabuw bairi buwat kwaya kwaway.” ");
INSERT INTO aai_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon eo, “Regah, fai manin buwat aya ama’am mar to men kafai siy ta eon, baise o kuo’o imih boro anasinaf.” ");
INSERT INTO aai_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Basit, buwat hitaiy re, siy batabat wanawanan run buwat kafa’imo tatakweb. ");
INSERT INTO aai_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Turahinah wa ta afe’en hima’am na baibaisih isan himan, naatu turahinah hina bairi siy hibow wa rou’ab hiwan yen awah karatan, wa hairi kafa’imo hita’unun. ");
INSERT INTO aai_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Abisa matar Simon Peter i’itin ana maramaim Jesu nanamaim sun yowen re eo, “Regah, kwihamiyu sa’ab kwen, ayu i bowabow kakafin wairafu.” ");
INSERT INTO aai_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naatu Simon ana ofonah bairi siy moumurih na’in hibowabow isan hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedee natunatun James naatu John hairi auman hifofofor men kafaita (Simon ana ofonah). Jesu Simon iu, “Men inabirumih, boun ana veya ebubusuruf o boro orot isah inaway.” ");
INSERT INTO aai_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naatu wa hibow hirun dones yan hitain hiyen, sawar etei’imak hihamiyen himisir Jesu hi’ufunun bairi hin. ");
INSERT INTO aai_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana veya ta Jesu tafaram ta in orot biyan kokom ani’anin ma bi’akiramaim tit. Orot Jesu i’itin ana maramaim tit nanamaim sun yowen ifefeyan eo “Regah inakokok na’at basit iniyawasu!” ");
INSERT INTO aai_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesu uman bora’ah orot butubun eo, “Ayu akokok o inayawas!” Iti na’at eo mar ta’imon orot biyanamaim kokom etei na’am in sawar. ");
INSERT INTO aai_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesu orot eofafar eo “Men sabuw hai tur ina’owen, baise, inan a firis biyan inatit biya nanutitiy na’itin. Imaibo Moses iu’uwi na’atube Regah isan sibor inayai, saise sabuw hina’itin hinitumatum o biya i turobe igewasin.” ");
INSERT INTO aai_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Baise Jesu ana tur ra’at tasasar tit etei’imak hinowar, sabuw rau’ay gagamin na’in hina ana tur hinowar naatu baiyawasih isan hifefeyan iyawasih. ");
INSERT INTO aai_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Baise mar etei Jesu efan nautanubinamaim akisinamo ma yoyoban isan en ema eyoyoyoban. ");
INSERT INTO aai_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Veya ta Jesu binan sabuw hima hinonowar wanawanahimaim i Pharisee naatu Ofafar Bai’obaiyenayah hina hima tur hinowar. Iti sabuw i tafaram Galilee naatu Judea wanawanan bar merar tata’ane hina, naatu Jerusalemane auman hina. Nati ana maramaim yawas ana fair Regah biyanane i na Jesu biyan tit sabuw sawusawuwih baiyawasih isan. ");
INSERT INTO aai_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sabuw afa orot an uman Kafikafirin hibai emo’em hiwan hi’abar hina, hikok kwanekwan bar wanawanan hitarun Jesu nanamaim hitayare. ");
INSERT INTO aai_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Baise sabuw i ra’at kwanekwan men ana mahar ta ma boro orot hitab hitarun. Imih hibai hiyen bar faifiy afe’en hiyare, kabay hibosaisiren sou hikuyouw imaim orot emo’em auman hiruru sabuw hima’am hai founafoun ra’iy, Jesu ma’am nanamaim tit. ");
INSERT INTO aai_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu iti sabuw hai baitumatum itin basit orot isan eo, “Au begon o a bowabow kakafih i anotanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pharisee naatu Ofafar bai’obaiyenayah hima’ama taiyuwih hio, “Iti orot i menatan God ebi’ib? God akisinamo boro bowabow kakafih nanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Abisa hinotanot Jesu so’ob basit iuwih, “Kwa dogor wanawanah not kakafih nati na’atube aisim kwanotanot? ");
INSERT INTO aai_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ef menatan i hamehamen, ana bowabow kakafih notawiyen isan anao, i hamehamen o misir bat remor, isan anao i hamehamen? ");
INSERT INTO aai_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Baise ayu anasinaf kwana’itin saise kwanitumatum. Orot Natun i God eonowah tafaramamaim sabuw hai bowabow kakafih notawiyen isan.” Basit Jesu orot an auman kafikafirin isan eo, “Kumisir a emo’em kubai a ubar kwen!” ");
INSERT INTO aai_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Orot mar ta’imonamo nahifunik inu’in misir ana emo’em bai e’abar tit God ana merar yi bora’ara’ah auman ana ubar in. ");
INSERT INTO aai_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sabuw etei’imak hima’am hifofofor men kafaita, yah birubir fafar auman, naatu God ana merar hiyi hibora’ara’ah hio, “Ina’inan iti men na’atube ta’i’itin efa’efanin bounabo matar taitin.” ");
INSERT INTO aai_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iti ufunamaim Jesu tit in orot kabay o’onayan wabin Levi ana bowabow baremaim ma’am itin basit isan eo, “Kumisir ayu kwi’ufnunu.” ");
INSERT INTO aai_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ma’am misir sawar etei’imak ihamiyen Jesu i’ufunun. ");
INSERT INTO aai_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi baitab gagamin ta ana baremaim Jesu isan itab, Levi ana ofonah bairi hai bowabow ta’imon naatu sabuw afa auman hiru’ay. ");
INSERT INTO aai_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pharisee naatu Ofafar bai’obaiyenayah himisir higam Jesu ana bai’ufununayah hibatiyih, “Kwa aisim nati kabay o’onayah naatu bowabow kakafih sabuw bairi kwama kwa’aa kwatomatom?” ");
INSERT INTO aai_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu iyafutih eo, “Sabuw iyab gewasih adanafur orot men tekokok, baise sabuw sawow wairafih adanafur orot i tekokok. ");
INSERT INTO aai_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ayu i men sabuw gewasih bow dogoroh baikitabirin isan anamih, baise sabuw bowabow kakafin wairafih.” ");
INSERT INTO aai_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sabuw afa Jesu hibatiy hio, “John ana bai’ufununayah i mar etei teyohar teyoyoyoban naatu Pharisee hai bai’ufununayah i na’atube tisisinaf, baise o abai’ufununayah i hi’aa tetomatom.” ");
INSERT INTO aai_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu iyafutih eo, “Kwanotanot tabin boubun ana sabuw a baitab isan hinaruru’ay boro na’uwih aamoromorob hinamatabir maiye hinan? Men karam. ");
INSERT INTO aai_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Baise veya ta tabin boubun orot boro hinabosair sa’ab nan ana sabuw nihamiyih, imaibo i boro hinayohar.” ");
INSERT INTO aai_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naatu Jesu oroubon ta iti na’atube eo, “Men yait ta faifuw boubun e’afuw faifuw atamanin fitimih, nati na’atube nasinaf faifuw boubun boro natakweb. Naatu faifuw boubun hinab atamanin hinafitifit ana itinin boro men gewasin. ");
INSERT INTO aai_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na’atube men yait ta wine boubun bai wine atamanin ana kibubumaim ririmih. Anayabin wine boubun ana kibub inab atamaninamaim inaririr wine boro nara’at kibub atamanin natafofor naatu wine nasuwa nare. ");
INSERT INTO aai_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Imih wine boubun ibo kibub boubunamaim tiririr. ");
INSERT INTO aai_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Baise men yait ta wine atamanin tomatom ufunamaim wine boubun tom isan kokomih, aiyab. Anayabin nati orot iti na’atube eo, “Wine atamanin i gewasin anababatun.” ");
INSERT INTO aai_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Baiyarir ana veya ta Jesu sanabey wanawanah remor inan, ana bai’ufununayah sanabey hirut kanabih hikeb ro’oro’oh hibow hi’aa. ");
INSERT INTO aai_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ofafar bai’obaiyenayah afa hi’itih basit hibatiyih. Kwa aisim Baiyarir ana veya ata ofafar kwa’astu’ub iti na’atube kwasisinaf? ");
INSERT INTO aai_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu iyafutih eo, “David ana sabuw bairi bayumih himorob, abisa sisinaf Buk Atamaninamaim hikirum inu’in kwaiyab kwaitin? ");
INSERT INTO aai_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David God Ana Bar wanawanan run Regah isan rafiy hisibor inu’in bai eaan, naatu turin ana sabuw itih hi’aa. Nati i ata ofafar eastu’ub. Anayabin firis akisihimo nati rafiy sibor hinab hina’aan men yait ta. ");
INSERT INTO aai_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naatu Jesu ana tur yomaninamaim iti na’atube eo, “Orot Natun i Baiyarir ana ukwarin.” ");
INSERT INTO aai_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baiyarir ana veya ta Jesu na Kou’ay Bar wanawanan run sabuw bai’obaiyih isan. Naatu nati sabuw wanawanahimaim i orot ta uman asukwafune murubin auman na ma’am. ");
INSERT INTO aai_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ofafar bai’obaiyenayah naatu Pharisee Jesu himtitiy Baiyarir ana veya orot ta tabiyawas na’at hita’itin, saise hai fair imaim hitab hitagam hita’umih. ");
INSERT INTO aai_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Baise sabuw abisa hinotanot i Jesu so’ob, imih orot isan eo, “Kumisir kutit iti sabuw nahimaim kubat.” Basit orot ma’am misir bat. ");
INSERT INTO aai_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Imaibo Jesu sabuw isah eo, “Ayu kwa abibatiy, ata ofafaramaim Baiyarir ana veya abistan i ebibasit boro tanasinaf? Orot babin tanibais gewasin tanasinaf o kakafin tanasinaf? Orot babin ana ma gewas isan taniyawas o ana yawas tanagurus?” ");
INSERT INTO aai_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu tatabir sabuw nutitiyih in sawar basit orot isan eo, “Uma kubora’ah.” Naatu orot uman bora’ah, marta’imon orot uman igewasin. ");
INSERT INTO aai_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Etei hima’am yah so’ar higagamat taiyuwih hibabatiyih hio, “Iti orot Jesu isan boro mi’itube tanasinaf?” ");
INSERT INTO aai_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nati ana veya’amaim Jesu yoyobanamih yen in oyaw wanamaim tit, naatu imaim ma God isan yoyoban in marto. ");
INSERT INTO aai_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mar auman basit, ana bai’ufununayah etei eaf ayuwih hiru’ay, naatu wanawanahimaim orot etei 12 rubinih, wabih tur abarayan iwaben. ");
INSERT INTO aai_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Naatu iti i tur abarayah wabih, Simon (wabin ta Peter, Jesu uf biwab) naatu Peter tain Andrew, James, John, Philip naatu Bartholomew, ");
INSERT INTO aai_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas naatu Alpheus natun James naatu Simon (Zerot teo), ");
INSERT INTO aai_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","James natun Judas, naatu Judas Iscariot, (Jesu baban eo momorob). ");
INSERT INTO aai_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu ana tur abarayah bairi oyawane himatabir hire hina hititit ana maramaim, ana bai’ufununayah etei hiru’ay butun ana yabarinamaim bairi hibat, naatu sabuw maumurih na’in Judea wanawanan, Jerusalem wanawanan hiru’ay, naatu torane bar merar rou’ab, Taiya, Sidon auman sabuw etei hiru’ay. ");
INSERT INTO aai_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hiruru’ay anayabin i tur nowar isan naatu hai sawow yumatah ta ta hibow hima’am baiyawasih isan hina. Naatu sabuw afa demon kakafih hibiwawa’anih auman hinan etei iyawasih. ");
INSERT INTO aai_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sabuw etei i hikokok Jesu hitabutubun, anayabin hibubutubun ana veya, ana fair titit i etei biyawasih. ");
INSERT INTO aai_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesu ana bai’ufununayah nutitiyih in sawar basit eo, “Yababan wairafi yasisir boro kwanab, anayabin God ana aiwob i kwa nowa! ");
INSERT INTO aai_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kwa iyab boun bayumih kwabi’akir boro kwaniyasisir bay kwanaa ya hinagadid! Kwa iyab boun kwarererey boro kwaniyasisir kwanamarib! ");
INSERT INTO aai_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sabuw hinifa’ifa’i, hinakwahiri, tur kakafih hina’uwi naatu kakafi hinarouw hinao ana maramaim kwaniyasisir, anayabin Orot Natun kwabi’ufunun! ");
INSERT INTO aai_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Imih sawar iti na’atube hinamamatar ana veya kwanakawasa naatu kwaniyasisir kwanaben. Anayabin a baiyan gagamin na’in maramaim inu’in. Abisa tisisinaf anayabin hai a’agir dinab oro’orot isah sawar iti na’atube hisinaf. ");
INSERT INTO aai_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Baise kwa iyab boun sawar wairafi kwama’am boro yababan gagamin maiyow kwanab! Anayabin kwa i yasisiramaim kwama’am! ");
INSERT INTO aai_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kwa iyab boun bay kwa’aa ya higadid kwama’am boro yababan gagamin maiyow kwanab bayumih kwanamorob! Kwa iyab boun kwaiyasisir kwamamarib boro yababan gagamin maiyow kwanab kwanarerey kwanitarkoukuw. ");
INSERT INTO aai_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kwa iyab sabuw wab tebobora’ara’ah boro yababan gagamin maiyow kwanab! Anayabin hai a’agir dinab baifufuwenayah isah na’atube hisinaf. ");
INSERT INTO aai_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kwa iyab iti tur kwanonowar a tur ao’owen a kamabiy sabuw kwaniyabuwih, sabuw iyab tibifa’ifa’i isah gewasin kwanasinaf. ");
INSERT INTO aai_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sabuw iyab hinao’orarafi, God kwanifefeyan baigegewasin nitih, naatu sabuw iyab isa kakafin hinasisinaf isah kwanayoyoban. ");
INSERT INTO aai_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Orot yait rebareb nabifafar na’at, raunane’ebo inabotabir nifafar. Naatu orot ta a biyabaibiyon tafan nikiya’ub nabaib na’at, baban auman inau nikiya’ub nab. ");
INSERT INTO aai_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Orot babin ta sawar isan nabifefeyani initih, naatu orot babin ta sawar o nowa ebaib, kwihamiy ebai, men bainamih inao maiye. ");
INSERT INTO aai_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A kok mi’itube sabuw isa tisisinaf na’atube, ibo isah na’atube inasinaf. ");
INSERT INTO aai_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sabuw o tibiyabuw akisih isah inabiyabow na’at, aisim boro baigegewasin inab? Sabuw kakafih turahinah tibiyabuwih akisih boro hiniyabuwih! ");
INSERT INTO aai_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naatu sabuw o isa gewasin tesisinafuwat isah gewasin inasisinaf na’at, aisim boro baigegewasin inab? Sabuw bowabow kakafin wairafih na’atube tisisinaf. ");
INSERT INTO aai_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sabuw iyab kubitih o iso’ob i boro wan hinay maiye hinabit na’at, aisim boro baigewasin inab? Sabuw bowabow kakafin wairafih i hiso’ob turahinah tibitih ana fofonin boro wan hinab maiye! ");
INSERT INTO aai_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","En! Baise akamabiy sabuw kwaniyabuwih, a gewasin kwanitih. Kwanitin men wan isan kwananot. Saise a baiyan gagamin na’in boro kwanab, naatu God auyomtoro’ot natunatunamih boro kwanamatar. Anayabin sabuw iyab aurih merarayow en, sabuw kakafih God nati sabuw isah i ebigewasin. ");
INSERT INTO aai_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tamat ekakabeber na’atube kwanakabeber. ");
INSERT INTO aai_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Taituwa inibatiyih, God boro obo nibatiyi, naatu taituwa ubar initih God boro obo ubar nit, taituwa hai kakafin inanotawiy, God boro a kakafin nanotawiy. ");
INSERT INTO aai_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uma natasasar taituw isah, God boro uman natasasar o isa. Tur anababatun o boro inab uma awan nakasuwai. Turobe baibais boro uma yan nasuwa nare inab nayen uma awan nakaratan. Sabuw inabitih ana fofonin God boro na’atube fofon ta’imon nit.” ");
INSERT INTO aai_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naatu Jesu oroubon ta iti na’atube eo, “Orot matan fim men karam boro fim turan nanawiy hairi hinan, anayabin nanawiy hairi hinanan na’at boro hairi’ika hinan hub hinare. ");
INSERT INTO aai_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kirum kek men yait ta boro ana bai’obaiyenayan nanatabirimih, baise na kirum nan yomanin na’a’asa’ub ana veya, i boro ana bai’obaiyenayan na’atube namatar. ");
INSERT INTO aai_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Aisim tai matan momor i’itin ku’u? Baise o mata ai bahun yi ebatabat men kutatatam. ");
INSERT INTO aai_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","O mata ai bahun yi batabat men itatam, naatu tai isan i’o Aro, nekuna mata momor abosair, a naniyan mi’itube ibai kuo? Wanawanan rerekabih! Matoro’ot o mata ai bahun ina’uy, imaibo boro inanuw gewas tai matan momor ina’itin inabosair. ");
INSERT INTO aai_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ai gewasin nabiw ro’on boro men kakafin nayai, na’atube ai wanawanan kour nabiw ro’on boro men gewasin nayai. ");
INSERT INTO aai_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ai etei’imak boro ro’ohimaim ina’itah, fafou ro’on boro men agor afe’en inima’ub, na’atube waris boro men digumar afe’en inawasarir hinare. ");
INSERT INTO aai_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Orot gewasin totobuyoy gewasin dogoronamaim tema’am boro nitaman nit. Orot kakafin totobuyoy kakafih dogoronamaim tema’am boro nitaman nit. Anayabin orot awanamaim abisa kakafin ititit, dogoron wanawanan i kakafin awan karatan inu’in. ");
INSERT INTO aai_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aisim ayu isau kwa’o, ‘Regah, Regah,’ baise abisa au’uwi i men na’atube kwasisinaf? ");
INSERT INTO aai_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Orot yait na ayu au tur nowar ebobosiyasiyar, ana itinin i iti ani’obaiyi kwana’itin. ");
INSERT INTO aai_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Orot ana bar wowabinamih hub kair re kabay afe’en tutut rouw, bar wowab. Harew tit yen bar bufut rab, baise bar men iyuwiyuw, anayabin bar wowab gewas. ");
INSERT INTO aai_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Baise o yait ayu au tur inowar men kubobosiyasiyar, i orot ana bar wabat en wowowab na’atube, bar tutut en wowab batabat, harew tit yen bar rabirab ana veya mar ta’imonamo ufar re, naatu nati bar re’er i mutufor tarogowan.” ");
INSERT INTO aai_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu tur etei eo binan sabuw hinowar in sasawar ufunamaim na Capernaum tit. ");
INSERT INTO aai_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nati’imaim Roman baiyowayan orot ukwarin ana akirwairafin isan biyabow kwanekwan i sawow gagamin bai morobomih biwa’an. ");
INSERT INTO aai_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Baise Jesu na nati’imaim titit ana tur nonowar ana maramaim, Jew hai orot gagamih iyunih hin Jesu biyan hitit ana akir wairafin baiyawasin isan Jesu hifefeyan. ");
INSERT INTO aai_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Basit Jew hai orot gagamih hina Jesu biyan hitit turobe’emaim hifefeyan hio, “Iti orot ana yababan i ekokok kwanekwan o baibais initin ana akir wairafin iniyawas. ");
INSERT INTO aai_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Anayabin ata sabuw isah i yabow, aki ai Kou’ay Bar wowab.” ");
INSERT INTO aai_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Basit bairi hin, naatu hina bar hibiyubin auman, baiyowayan orot ana ofonah afa iyunih hin Jesu biyan hitit hio, “Regah aki ai of iti na’atube eo, Aisim inan a nababan, anayabin ayu men orot gagamu boro inan au bar inatit. ");
INSERT INTO aai_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na’atube ayu auman taiyuwu ai’itu ayu men orot gewasu boro anan nanamaim anatit, baise akokok turawat nao au akir wairafin boro nayawas. ");
INSERT INTO aai_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anayabin ayu auman baiyowayah orot isah, au fair ema’am, orot ta aniyun anao, ‘Ni’imaim kwen.’ I boro nan, naatu orot ta isan anao, ‘Iti’imaim kuna.’ I boro nan, naatu au akir wairafin orot ta isan anao, ‘Iti kusinaf.’ I boro nasinaf.” ");
INSERT INTO aai_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu iti orot ana tur nonowar ifofofor men kafaita, naatu tatabir sabuw hi’ufunun bairi hinan iuwih eo, “Anababatun a tur ao’owen Israel wanawananamaim ama areremor, men kafa’imo orot ta ana baitumatum iti na’atube aitinimih.” ");
INSERT INTO aai_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Imaibo orot kob nayah himatabir maiye hin bar hititit, akir wairafin yawas ma’am hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nati ufunamaim sabuw rau’ay gagamin na’in, naatu Jesu ana bai’ufununayah bairi hin bar merar wabin Nain imaim hitit. ");
INSERT INTO aai_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesu na bar merar ana fur awan titit auman, kwafur babin natun orot ta’imonamo morob, sabuw rau’ay gagamin na’in kwafur babin hibai hirerey auman natun hi’abar hititit bairi hitar. ");
INSERT INTO aai_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesu nuw kwafur babin i’itin ana maramaim dogoron wanawanan yababan awankaratan naatu kwafur isan eo, “Babin men inarerey.” ");
INSERT INTO aai_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Imaibo na sabuw biyah tit eof ir sum butubun, sabuw orot hi’abar hinan hinutanub hibat, Jesu orot murubin isan eo, “Orot boubun kumisirimih ayu ao!” ");
INSERT INTO aai_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Orot murubin inu’in yawas misir mare ma tur eo. Jesu nawiy hairi hin hinah itin. ");
INSERT INTO aai_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sabuw etei orot murubin yawas mimisir hi’itin hai bir ra’at baise God ana merar hiyi wabin hibora’ara’ah hio, “Dinab orot fairin anababatun wanawanatamaim tit! God ana sabuw baiyawasih isan na!” ");
INSERT INTO aai_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesu iti sisinaf ana tur ra’at tafaram Judea wanawanan hima’am etei hinowar na’atube tafaram nati sisibinamaim hima’am auman hinowar. ");
INSERT INTO aai_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Sawar iti etei isah John ana bai’ufununayah hina ana tur hio’owen ufunamaim, ana bai’ufununayah orot rou’ab iuwih eo, “Kwanan Regah kwanibatiy, John o isa eo anonowar, o iti ina, ai aki boro orot ta isan anama anakaif?” ");
INSERT INTO aai_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iti na’atube eo imaibo hina Jesu biyan hitit ana tur hi’owen hio, “Aki John Baptist o baibatiyimih iyafari ana, imih akokok inao ananowar, John o isa eo anonowar o iti ina, o aki boro orot ta isan anama anakaif.” ");
INSERT INTO aai_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nati ana veya’amaim Jesu sabuw maumurih na’in hai sawow yumatah ta ta, naatu demon kauh hiyen hima hibiwawa’anih etei biyawasih. Naatu sabuw moumurih na’in matah fim iwa’an matah higewasin hinuwanuw. ");
INSERT INTO aai_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Imih Jesu John ana bai’ufununayah iyafutih eo, “Kwamatabir kwan abisa kwa’i’itah John ana tur kwa’owen. Sabuw matah fim higewasin tinuwanuw, ah kafikafirih higewasin hibat tereremor, kokom ani’anih biyah igewasin, tainih gugurih higewasin tur tenonowar, naatu sabuw morobone abiyawasih, tur gewasin i yababan sabuw isah abibinan. ");
INSERT INTO aai_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sabuw iyab erekasiy auman ayu tibitutumu i boro men baigegewasin hinab!” ");
INSERT INTO aai_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kob nayah himatabir John isan hinan ufut, Jesu tatabir sabuw rau’ay gagamin hina hima’am ibatiyih eo, “Arar yan John abisa sisinaf itinamih kwatit kwan? Kotar wadar bi’inuwas itinamih kwan? ");
INSERT INTO aai_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Abisa itinamih kwatit kwan? Orot sawar wairafin e’abur gewas ma’am itinamih kwan? En anayabin sabuw hai abur gewasin i bar gewasihimaim tema’am. ");
INSERT INTO aai_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Imih kwao anowar. Abisa itinamih kwan? Dinab orot? Turobe, baise a tur ana’owen, iti orot i dinab oro’orot etei tafahimaim. ");
INSERT INTO aai_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Anayabin John isan, God iti na’atube eo Buk Atamaninamaim hikirum, ‘Ayu au tur abarayan boro wan o namaim aniyafar nan o a ef nayabuna.’ ");
INSERT INTO aai_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesu iban eo maiye, “‘Tur anababatun a tur ao’owen, baibin hitatoub wanawanahimaim, orot men yait ta John natabirimih. Baise orot ta God ana aiwobomaim taiyuwin bikafai i John natabir.” ");
INSERT INTO aai_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sabuw etei, kabay o’onayah auman tur hinonowar ana maramaim, hiorereb God ana ef i turobe mutufurin, anayabin iti sabuw etei’imak i John bapataito itih. ");
INSERT INTO aai_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Baise Pharisee naatu Ofafar Bai’obaiyenayah God abisa sinafumih kokok i hikwahir men hisinaf naatu John ana bapataito hikwahir. ");
INSERT INTO aai_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Imih sabuw iti boun tema’am hai itin boro abisa’amaim anayai anao? Hai itinin i mi’itube? ");
INSERT INTO aai_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sabuw hai itinin i Kek gidigidih urababan tefafafow na’atube. Kek turih boro turahinah isah hio, ‘Aki tabin ana douduf arabirab baise kwa men kwabenabenamih. Naatu aki morob ana ew atatabor, baise kwa men kwarerereyamih.’ ");
INSERT INTO aai_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","John Baptist nan ana veya’amaim yohar bay, harew fokarih men eaa tomatom, naatu kwa kwao, ‘Iti orot i demon kaun hiyen!’ ");
INSERT INTO aai_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Baise Orot Natun na bay harew eaa tomatom kwa kwao, ‘Iti orot i ana bay aa naatu ana harew tom kakafin, kabay o’onayah naatu sabuw bowabow kakafih sinafuyah hai begon!’ ");
INSERT INTO aai_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Baise God ana ukwar rerekab i sabuw iyab hikok tebaib isah ebiturobe.” ");
INSERT INTO aai_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee orot ta wabin Simon Jesu ifefeyan na ana baremaim hairi bay aa isan, basit Jesu na orot ana bar run hairi hima bay hi’aa. ");
INSERT INTO aai_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Babin ta bowabow kakafin wairafin nati bar meraramaim ma’am, Jesu Pharisee ana baremaim ma bay eaa ana tur nowar, basit re kibub wabin alabaster kabayamaim hikwak biya rarouw yamurin gewasin hisuwai batabat bai na ");
INSERT INTO aai_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesu ufunane bat, anamaim rerey maturin re an hihuruf, naatu kwafure aribunamaim Jesu an sasam naatu an mamay. Imaibo raiy bai Jesu anamaim isuwai re. ");
INSERT INTO aai_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iti na’atube sisinaf Pharisee orot i’itin ana maramaim, nuhinamaim not eo, “Iti orot dinab mowan na’at iti babin ebubutubun boro taso’ob, naatu boro taso’ob iti babin i yait, anayabin iti babin i bowabow kakafin wairafin!” ");
INSERT INTO aai_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Naatu Jesu eo, “Simon, ayu tur ta anao inanowar.” “Bo i aisim bai’obaiyenayan. Kuo anowar.” ");
INSERT INTO aai_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesu eo, “Orot rou’ab hin orot ta kabay wairafin biyan kabay isan hifefeyan, basit orot 500 kina bai orot ta itin naatu 50 kina bai orot ta itin. ");
INSERT INTO aai_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Baise ana maramaim orot hairi aurih men karam boro orot kabay wairafin ana kabay wan hitay, imih orot kabay matuwan turan hairi’ika wabih bosairen. Imih orot menatan isan i ana yabow ra’at?” ");
INSERT INTO aai_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon Jesu iya’afut eo, “Anotanot orot nati kabay gagamin baibine.” Imaibo Jesu Simon iu, “Nati kuo i turobe.” ");
INSERT INTO aai_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Imaibo Jesu tatabir babin isan Simon iu, “Iti babin i’itin? Ayu ana o a bar atit o men au sauwin isan harew iyai’imih, baise iti babin maturinamaim au sauw naatu aribunamaim au sasam. ");
INSERT INTO aai_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","O men au merar iyi imamayu’umih, baise iti babin a bar aruruka busuruf au mamay men ihamiyimih. ");
INSERT INTO aai_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O men olive iroro’onamaim aribu isuwei’imih, baise iti babin raiy yamurin gewasin au’umaim isuwai re. ");
INSERT INTO aai_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Imih anababatun a tur ao’owen, iti babin ana bowabow kakafin maumurih na’in etei’imak anotanot tawiyen, anayabin ana yabow gagamin na’in ayu itu. Baise orot yait ana bowabow kakafin kikimin anotanotawiyen i ana yabow kikimin.” ");
INSERT INTO aai_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Imaibo Jesu babin isan eo, “A bowabow kakafih etei i anotanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sabuw afa bairi hima bay hi’aau, hibusuruf taiyuwih hibabatiyih, “Iti i abi’orot bowabow kakafih notawiyenayan.” ");
INSERT INTO aai_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Baise Jesu babin isan eo, “O a baitumatumamaim iyawasi tufuwamaim inatit inan.” ");
INSERT INTO aai_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Veya bai’ab na’atube sasawar ufunamaim, Jesu ana bai’ufununayah nah 12 bairi hin bar awan, awan hirun hitit God ana aiwob isan Tur Gewasin binan hiremor. ");
INSERT INTO aai_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hinan wanawanahimaim, i baibin afa sawow yumatah ta ta hibow hima’am, naatu demon kakafih hitar gubih hima’am Jesu biyawasih auman bairi hin. Mary wabin ta Magdalin biyanamaim demon seven Jesu nunih hititit auman bairi hin. ");
INSERT INTO aai_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Naatu Herod ana bowayan orot ukwarin wabin Chuza i aawan Joanna, Susanna, naatu baibin afa auman bairi hin. Naatu iti baibin hai kabayamaim Jesu ana bai’ufununayah bairi hibaisih hai bowabow wanawananamaim. ");
INSERT INTO aai_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sabuw rou’ay gagamin maiyow bar awan ta ta’ane hinan tafaram awan karatan, naatu Jesu oroubonamaim sabuw iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ana veya ta orot ana ub tanumamih bow in ana me bifufubiy yanamaim tit, naatu ana ub ta ta asi’asiy ana veya ub afa i ef yanamaim hire, sabuw hina tafan hibat hiwas tatanen hin, naatu mamu hire hibow hi’aa. ");
INSERT INTO aai_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ub afa i to yanamaim hire, baise hikuboubunih hiyey ana maramaim veya re rarih etei himorob, anayabin me owasasin. ");
INSERT INTO aai_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ub afa i kokor ro’oh wanawanahimaim hire, naatu hikuboubunih bairi hiyen, baise kokor hiyen sasa hai fafa’amaim ub gewasih hirouw. ");
INSERT INTO aai_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Naatu ub afa i me gewasin yanamaim hire, hikuboubunih hiyen gewas hiw ai ta’ita’imon afe’eh ro’oro’oh etei 100 na’atube hiya.” Naatu Jesu ana tur yomaninamaim eo, “O yait tain nama’am na’at iti tur inanowar.” ");
INSERT INTO aai_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesu ana bai’ufununayah hikok oroubon anayabin so’ob isan hina hibatiy. ");
INSERT INTO aai_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Baise Jesu iyafutih eo, “So’ob wa’iwa’irin God ana aiwob isan i God kwa it, baise sabuw afa isah i oroubonamaim ao, saise abisa bukamaim hikikirum niturobe, ‘Matah hinakubar hinanuw, baise boro men hina’itin, tainih nawayay tur hinanowar, baise boro men naniyan hinab.’” ");
INSERT INTO aai_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Oroubon anayabin i iti. Ub i God ana tur gewasin. ");
INSERT INTO aai_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ub ef yanamaim hire’ere i sabuw God ana tur hinowar hibai, baise Demon Mowan na tur gewasin sabuw dogorohimaim bosair, anayabin Demon Mowan men ekokok sabuw tur gewasin hinanowar hinitumatum naatu yawas hinab. ");
INSERT INTO aai_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ub afa to yan hire’ere, i sabuw God ana tur tenonowar ana maramaim i tibiyasisir, baise aurin an wairoron en, anayabin tur tenonowar ana veya boro hinitumitum naatu routobon nan nabubuwih ana veya boro mar ta’imon hinara’iy. ");
INSERT INTO aai_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ub afa kokor ro’on wanawanah hire’ere, i sabuw God ana tur tenonowar, baise iti tafaram ana yasisir, tafaram ana yababan, naatu tafaram ana sawar isah tenotanot kwanekwan; imih ro’oh etei tekokokor naatu men ta ebiyamur. ");
INSERT INTO aai_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Baise ub me gewasin yan hire’ere, i sabuw iyab God ana Tur Gewasin hinowar dogoroh tutufin etei hibai, naatu nati tur isan hiten nowanowar tebowabow boro niw. ");
INSERT INTO aai_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Orot men yait ta ramef ito’ab noukwat wanawanan tarafut in, o gem babanamaim yai in to’abamih. Baise ana efanamaim sikof, saise sabuw boro ana marakawin hina’itin naatu kawin hinan bar hinarun.” ");
INSERT INTO aai_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Anayabin abisa baibunuwenamaim inu’in, God boro nabotait nirerereb, naatu abisa hisakirafut inu’in, sum boro natakweb nan bebeyan marakawamaim natit.” ");
INSERT INTO aai_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Imih tur iti kwanonowar i kwananowar gewas, anayabin orot yait isnubanub tur enonowar gewagewas, God boro dogoron nabotawiy tur moumurih na’in naniyah boro naso’ob. Baise orot yait tur isan men isnubanub enonowar, dogoron boro nahirafut naatu abisa kikimin ana notamaim ma enotanot auman God boro nabosair.” ");
INSERT INTO aai_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu hinah naatu taitin itinamih hina, baise men karam boro hita run biyan hitatit, anayabin sabuw rou’ay gagamin na’in ef hifut. ");
INSERT INTO aai_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Orot ta na Jesu biyan tit eo, “O hinat naatu taitit hina ufun tebatabat tekokok o hina’iti.” ");
INSERT INTO aai_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesu sabuw etei nati hibatabat iuwih eo, “Sabuw iyab God ana tur hinowar tebobosiyasiyar, nati sabuw i ayu hinai naatu taitu.” ");
INSERT INTO aai_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ana veya ta Jesu ana bai’ufununayah bairi wa afe’en hiyen naatu iuwih, “Kwana boy tana rabon tanan harew kukuf rewan raunane tanayen.” Basit wa hinatait hitit, ");
INSERT INTO aai_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","rar hikutatar hirabon hin. Nati ana veya’amaim Jesu matan fot wa wanawanan inure inu’in naniyan meyemeye wowog batabat tafair tit kukuf yan re rabih, wa harew iwan hisiwisiw men karam. ");
INSERT INTO aai_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Basit bai’ufununayah hina Jesu hibunibun hio, “Regah, Regah! Wa iu’unun tana morob!” Jesu misir wowog, yabat hairi kwararih iuwih, mar ta’imonamo nuwarob e’afuw. ");
INSERT INTO aai_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Imaibo ana bai’ufununayah ibatiyih, “Kwa a baitumatum i menamaim kwayai?” Baise bai’ufununayah hifofofor naatu hibir taiyuwih hibabatiyih hio, “Iti orot i yait? Yabat naatu wowog iu’uwih i marta’imon fanan hibai.” ");
INSERT INTO aai_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesu ana bai’ufununayah bairi hiboy hirabon hin tafaram Gerasa imaim hitit, Galilee harew kukuf rewan raunane. ");
INSERT INTO aai_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu wa afe’enane dones yan bisure auman, orot ta nati bar merarane demon koun hiyen hiforatoun kwamur manin maiyow ana bar itumar, segar rah yahimaim, watu’umaim in ma reremor tit nan hairi hitar. ");
INSERT INTO aai_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Naatu nuw Jesu i’itin ana veya nanamaim ra’iy rerey fanan aumetawat na’in iwow eo, “Jesu God auyomtoro’ot Natun, ayu isau boro abisa inasinafumih kunan? Abifefeyani men baimakiy initu!” ");
INSERT INTO aai_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iti na’atube eo, anayabin demon mowan orot baihamiyin titamih Jesu kwarartatab iu. Mar maumurih maiyow demon kakafih iti orot ana yawas etei hibi’a’afiy, an uman seinimaim ti’utan dibur baremaim tekaif tema’am, baise itukwar chain tituru’uru’um, tebonawiy ten arar yan imaim ema ereremor. ");
INSERT INTO aai_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu ibatiy eo, “O wab i mi’itube?” Orot iya’afut eo, “Ayu wabu i ‘Burut.’” Anayabin demon maumurih na’in iti orot wanawanan hirun hiforatoun hima’am. ");
INSERT INTO aai_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Demon Jesu hifefeyan men hikok boro tiyafarih hitan Sou Awan Wanu’umin hitama. ");
INSERT INTO aai_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naatu nati oyaw sisibinamaim i for burut hima hi’u’ufar, imih demon na for wanawanah run isan Jesu hifefeyan, naatu Jesu ana baibasit itih, iuwih hibihir hitit. ");
INSERT INTO aai_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Demon orot biyanane hitit i hinunuw hin for wanawanah hirun, naatu for burut hibatabat fan naiwan hinunuw hire hin harew kukuf yan hire etei hi’atomatom himorob. ");
INSERT INTO aai_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Naatu orot nati for hima’uten hima’am, abisa matar hi’itin, himisir hinunuw hin bar merar hitit, sabuw etei hai tur hi’owen. Naatu tur tasasar in sabuw afa bar merar gidigidihimaim hima’am auman hinowar. ");
INSERT INTO aai_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sabuw abisa mamatar itinamih hitit hina Jesu biyan hititit, orot demon hiforatoun hima’am Jesu biyawas, i Jesu sisibinamaim mare, ukwarin ruboun ar bai us ma’am hi’itin hai bir ra’at. ");
INSERT INTO aai_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Naatu sabuw afa orot demon hiforatoun hima’am Jesu mi’itube iyawas hi’i’itin sabuw afa hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Naatu sabuw nati tafaram Gerasa wanawanan hima’ama, Jesu hiu tafaram itumar, anayabin hai bir ra’at, naatu Jesu re wa bai matabir maiye rabon. ");
INSERT INTO aai_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Naatu Orot nati demon biyanamaim hititit Jesu ifefeyan hairi namih, baise Jesu eo, “O i abiyafari ");
INSERT INTO aai_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ina’intabir maiye a bar, abisa God isa sisinaf, i sabuw hai tur ina’owen.” Basit orot in bar merar run remor Jesu isan mi’itube sisinaf sabuw etei hai tur eowen. ");
INSERT INTO aai_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu matabir rabon na harew kukuf rewan raunane yey ana maramaim, sabuw rou’ay gagamin na’in hitit ana merar hiyi, anayabin isan hima hikakaif natit. ");
INSERT INTO aai_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naatu Jew hai Kou’ay Bar kaifenayan orot wabin Jairus na Jesu nanamaim sun yowen ifefeyan, ana kok i mi’itube Jesu hairi hitan ana bar. ");
INSERT INTO aai_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Anayabin i natun babitai ta’imonamo ana kwamur 12 na’atube i ana sawow ra’at momorob. Naatu Jesu busuruf inan, sabuw rou’ay gagamin na’in hitit nan ufun awan karatan. ");
INSERT INTO aai_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nati sabuw wanawanahimaim i babin ta ana faifuwamaim rara kakafin bota’ar ma’am kwamur etei 12 na’atube sawar, yawas isan kabay gagamin maiyow doket tubunih baiyawasin isan sinaf, baise men yait ta iyawasimih. ");
INSERT INTO aai_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nati ana veya’amaim sabuw rau’ay hinan wanawanan babin na Jesu ufunane tit eof ana faifuw tainin butubun, naatu mar ta’imonamo rara kakafin nununuw nutanub. ");
INSERT INTO aai_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu naniyan tatam eo, “Yait ayu butubunu?” Baise sabuw etei hiyaub, naatu Peter eo, “Regah, sabuw rau’ay gagamin na’in na ufu awan karatan tenan ku’i’itih o kuo.” ");
INSERT INTO aai_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Baise Jesu eo, “Sabuw afa ayu hibutubunu. Anayabin hibubutubunu ana veya’amaim au fair titit naniyan atatam.” ");
INSERT INTO aai_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Babin naniyan baib i yawas naatu men karam boro tibun, imih Jesu nanamaim an uman hi’oror auman tit sun yowen, sabuw etei matahimaim ana tur eowen aisim butubun, naatu bubutubun ana veya’amaim marta’imon yayawas auman ana tur eowen. ");
INSERT INTO aai_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Imaibo, Jesu babin isan eo, “Natu a baitumatumamaim iyawas. Tufuwamaim ina remor inan.” ");
INSERT INTO aai_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu iti na’at bat eo auman, Kou’ay Bar ana bonawiyen orot ana barene kob hina hitit hio, “Jairus o natu babitai i morob, imih men bai’obaiyenayan nawiyin airi na isan inanotamih.” ");
INSERT INTO aai_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iti na’at hibat hio Jesu nowar, naatu Jairus isan eo, “Men inabir, baise initumatum natu babitai boro nayawas.” ");
INSERT INTO aai_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naatu hina bar hititit ana veya’amaim, sabuw etei eotanih ufun hibat, i Peter, John, James, naatu kek hinah tamah akisihimo iuwih bairi bar wanawanan hirun. ");
INSERT INTO aai_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sabuw etei kek momorob isan hiyababan hima hirererey, Jesu iuwih eo, “Men kwanarerey, kek i matan fot inu’in, men morobomih.” ");
INSERT INTO aai_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sabuw etei Jesu eo i bai’iyab na’atube imih himarib. Anayabin i matah yan kek morob hi’itin hiso’ob. ");
INSERT INTO aai_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Baise Jesu na kek uman bai, eaf eo, “Babitai, kumisir!” ");
INSERT INTO aai_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Babitai ayubin matabir na wanawanan run, mar ta’imon yawas misir mare ma. Imaibo Jesu kek bay baitin aa isan hinah tamah iuwih. ");
INSERT INTO aai_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kek hinah tamah hifofofor men kafaita, baise Jesu eofafarih eo, “Abis matar kwa’i’itin men orot babin ta ana tur kwana’owenamih.” ");
INSERT INTO aai_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu ana bai’ufununayah etei I2 eaf ayuwih hina hitit, demon kakafih nunih isan, naatu sawow yumatah ta ta bosaisiren isan fair itih, naatu eonowahih. ");
INSERT INTO aai_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Imaibo God ana aiwob binan isan naatu sawusawuwih baiyawasih isan iyafarih hitit hin. ");
INSERT INTO aai_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naatu iuwih, “A nanawan isan kwanatitit ana maramaim men sawar afa kwanabow auman kwananamih, men hafoy, tu, kabay, bay, o wanabir. ");
INSERT INTO aai_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kwananan sabuw iyab hina’iti a merar hinay hinabubuwi na’at, nati bar meraramaim kwanama a bowabow kwanisawar imaibo kwanatit. ");
INSERT INTO aai_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Baise sabuw men a merar hinay hinabubuwi na’at, a fofob kwanarutatab nare naatu nati bar merar kwanihamiy kwanatit, baimatnuwen ana orereb na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Imaibo bai’ufununayah hitit hin bar awan, awan hirun hitit God ana aiwob isan tur gewasin hibinan naatu sawusawuwih hiyayawasih. ");
INSERT INTO aai_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, Galilee sabuw hai aiwob orot, sawar iti himamatar hai tur nonowar ana veya ana kasiy ra’at, anayabin sabuw afa hio John Baptist morobone matabir maiye, ");
INSERT INTO aai_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","sabuw afa hio, Elijah marane ra’iy, sabuw afa hio, “Dinab orot ta marasika momorob i yawas maiye matabir na.” ");
INSERT INTO aai_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Baise Herod eo, “Ayu taiyuwu aso’ob John i ayu sikan ao hi’afuw, naatu iti orot i yait iti bowabow sinaf ana tur anonowar?” Iti na’atube eo naatu kok i orot ana yumat itinamih nuwih. ");
INSERT INTO aai_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesu ana tur abarayah himatabir hina hitit, sawar abisa’awat hisisinaf ana tur hi’owen. Naatu nawiyih hitit akisihimo hin tafaram wabin Bethsaida imaim hima. ");
INSERT INTO aai_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baise sabuw maumurih na’in Jesu au Bethsaida inan ana tur hinowar, naatu hi’ufunun hin biyan hitit. Hai merar yi God ana aiwob isan binan hinowar naatu sawusawuwih iyawasih. ");
INSERT INTO aai_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Veya re birabirab auman bai’ufununayah 12 hin Jesu hiu, “Sabuw kwiyafarih ten bar iti yubinamaim naatu masawabar iti yubinamaim taituwah tema’am biyah bay hinanuwet hinabow hinaa, naatu efan auman hinanuwet fai hina’in, anayabin iti efan i owararin.” ");
INSERT INTO aai_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Baise Jesu iuwih, “Bay i boro kwa kwanitih hinaa.” Bai’ufununayah hiya’afut, “Rafiy fafar umat roun naatu siy rou’abamo efanamaim ti’inu’in. Kukokok aki anan sabuw etei’imak isah bay anatobon?” ");
INSERT INTO aai_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sabuw nati’imaim hiru’ay hima tur hinonowar nah etei i 5,000 na’atube. Jesu ana bai’ufununayah iuwih, “Sabuw kwa’uwih nah 50 na’atube kou’ay tata’amaim timarir.” ");
INSERT INTO aai_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bai’ufununayah Jesu eo na’atube sabuw hi’uwih himarir. ");
INSERT INTO aai_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Imaibo Jesu rafiy fafar umat roun bow, naatu siy rou’ab bow, au mar nuw ra’at, God ana merar yi igegewasin sawar, im seseb ana bai’ufununayah itih hibow sabuw hifaramih hi’aa. ");
INSERT INTO aai_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sabuw etei hi’aa yah iw naatu bai’ufununayah kaifet etei 12 hibow sabuw bay hi’aau turih hibihamiyen hiwan awah hikufoten. ");
INSERT INTO aai_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ana veya ta Jesu akisinamo ma yoyoyoban ana bai’ufununayah hina biyan hitit ibatiyih eo, “Sabuw ayu isau mi’itube’ewat teo kwanonowar?” ");
INSERT INTO aai_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hiya’afut hio, “Sabuw afa teo o i John Baptist, afa teo o i Elijah, naatu afa teo o i God ana dinab oro’orot marasika himomorob i ta morobone yawas maiye na.” ");
INSERT INTO aai_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naatu ana bai’ufununayah ibatiyih, “Bo kwa ayu isou mi’itube kwanotanot?” Peter iya’afut eo, “O i God ana Roubininenayan.” ");
INSERT INTO aai_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Imaibo Jesu eofafarih eo, “Men yait ta ana tur kwana’owenamih.” ");
INSERT INTO aai_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naatu Jesu iuwih eo, “Jew hai orot gagamih, firis hai ukwarih na’atube Ofafar Bai’obaiyenayah boro Orot Natun hinakwahir, biyababan gagamin na’in nab, hina’asabun namorob, baise veya baitounin ufunamaim boro morobone namisir maiye.” ");
INSERT INTO aai_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naatu etei’imak iuwih eo, “Orot yait ayu bai’ufnunu’umih nakokok na’at, taiyuwin ana yawas i nakwahir, mar etei ana onaf na’abar ayu ni’uf nunu. ");
INSERT INTO aai_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Anayabin orot yait ana yawas i taiyuwin isan eo’oharihar boro nikasiy, baise orot yait ana yawas nakwahir ayu nabi’ufnunu, ma’ama wanatowan boro natita’ur. ");
INSERT INTO aai_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tafaram wanawanan orot ta sawar tutufin etei i bow karam, baise i taiyuwin ana yawas nabi’afiy, o hina bigegesair na’at, iti sawar bow ya ma tototo boro hinibais? ");
INSERT INTO aai_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Orot yait ayu isou biyan eo’ohow, naatu au tur isan biyan nao’ohow na’at, Orot Natun ana bonamanamarinamaim na’atube Tamah God ana bonamanamarinamaim naatu ana tounamatar kakafiyih auman hai bonamanamarinamaim namatabir maiye nanan ana veya, boro ibo isan biyan na’ohow. ");
INSERT INTO aai_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Anababatun a tur ao’owen, kwa iyab iti kwama’am boro yawas kwanama’am God ana aiwob kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tur iti eo hima fur ta’imon sasawar ufunamaim, Peter, John, naatu James buwih bairi hiyen hin oyaw wan yoyoban isan. ");
INSERT INTO aai_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Naatu hiyen hin yoyoyoban ana maramaim yumatan botabir, ana faifuw hikwes anababatun namanamar ebowabow emamarakaw na’atube. ");
INSERT INTO aai_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nati ana maramaim naniyan meyemeye orot rou’ab, Moses, Elijah hairi hirerereb, ");
INSERT INTO aai_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","mar ana marakaw bonamanamarin auman hira’iy Jesu ana bowabow iti tafaramamaim baisawarin matabir maiye isan, naatu God ana kok abisa Jesu Jerusalemamaim sinaf baiturobe isan bairi hio. ");
INSERT INTO aai_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter ana ofonah bairi i nuhih bur hi’inu’in ufut iti sawar himatar, baise matah nuw himimisir auman Jesu biyanamaim bobonamanamar hi’itin naatu orot rou’ab bairi hibatabat hi’itih. ");
INSERT INTO aai_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Naatu orot rou’ab Jesu hibihamiy auman, Peter Jesu isan eo, “Regah igewasin aki iti ama’amamaim sis tounu ana wowab, ta o isa ta Moses isan naatu Elijah isan!” Iti na’atube eo anayabin i men so’ob abisa eo. ");
INSERT INTO aai_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter iti na’at bat eo auman sakusakuk ra’iy ana youninamaim tar sumih, naatu wanawanan hirur auman, bai’ufununayah yah birubir fafar. ");
INSERT INTO aai_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sakukuw wanawanan God eafatait eo, Iti Orot i Ayu Natu, ayu arubin imih nao’o kwananowar.” ");
INSERT INTO aai_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Iti tur hinowar in sasawar ufunamaim Jesu akisinamo batabat hi’itin. Naatu bai’ufununayah sawar abisa nati ana veya’amaim hi’itin men yait ta ana tur hi’owen awah hibofot hima. ");
INSERT INTO aai_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Marto Jesu ana bai’ufununayah bairi hire hina oyaw an hitit, naatu nati’imaim sabuw hima’am hina biyah hitit. ");
INSERT INTO aai_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Orot ta sabuw rau’ay wanawanahimaim batabat e’af eo, “Bai’obaiyenayan, abifefeyani kunuw natu ku’itin, natu ta’imon maiyow! ");
INSERT INTO aai_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Demon kakafih kaun teyey ana veya eororsair iwow ere erab awan fusifusin ekubar in erabirab biyan riririr ebiwa’an. Naatu iti na’atube i mar etei esisinaf men kafa’imo ebihamiyimih. ");
INSERT INTO aai_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A bai’ufununayah ai fefeyanih, demon nuninamih auwih, baise men karam.” ");
INSERT INTO aai_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu iyafutih eo, “Kwa sabuw iti boun ana veya aur baitumatum naatu ayawas etei i hibibir. Kwanotanot ayu boro bairit manin tanama abit ana’abar? A kek kubai kuna aitin.” ");
INSERT INTO aai_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kek nan auman demon kakafin kek bai rab rouw me yan re naatu ifiruruw in hub itaiy re. Baise Jesu demon kakafin kwarar tatab nun tit kek iyawas bai tamah itin. ");
INSERT INTO aai_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sabuw etei’imak God ana fair hi’itin hifofofor men kafaita. Sabuw Jesu abisa sisinaf isan, hibat hibifofofor wanawanan Jesu ana bai’ufununayah isah eo, ");
INSERT INTO aai_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tain kwanarub gewas tur iti anao kwananowar. Orot Natun i boro baban hinao naatu hinab sabuw umahimaim hinayai.” ");
INSERT INTO aai_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Baise bai’ufununayah iti tur naniyan men hibai, tur anayabin hai notamaim ibun, naatu baibatiyin tur anayabin o nowar isan hibir. ");
INSERT INTO aai_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bai’ufununayah taiyuwih wanawanahimaim, yait orot gagamin isan hio hinan gamin matar. ");
INSERT INTO aai_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu abisa hinotanot itin, basit kek kafa’i ta bai na sisibinamaim iu bat. ");
INSERT INTO aai_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Imaibo iuwih, “Orot yait kek kafai iti na’atube nab ayu wabu’umaim ana merar nayiy, i ayu au merar eyiy. Naatu orot yait ayu au merar eyiy i orot yait ayu iyunu anan i ana merar eyiy. Anayabin orot yait kwa wanawanamaim wabin en kek kikimin na’atube ema’am, nati orot i gagamin.” ");
INSERT INTO aai_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John misir eo, “Regah, orot ta o wabimaim demon kakafih nununih a’itin naatu a’otan. Anayabin nati orot i men it ata kou’ayomaim ema’ama.” ");
INSERT INTO aai_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu iya’afut eo, “Men ina’otanimih, anayabin orot yait kwa isa men ebirakit i kwa isa ebatabat.” ");
INSERT INTO aai_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesu au mar yen isan ana veya na kakabom auman, ana not bogaigiwas yen in au Jerusalem. ");
INSERT INTO aai_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naatu kob wan iyafarih hin Samaria bar merar hitit ana efan hitayabuna tanan imaim ta’in isan. ");
INSERT INTO aai_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Baise Samaria sabuw men ana merar hiyi hibai efan hitinimih, anayabin hiso’ob Jesu i au Jerusalem yey. ");
INSERT INTO aai_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Naatu bai’ufununayah orot rou’ab James John hairi iti na’atube hi’i’itin yah so’ar hio, “Regah, kukokok wairaf marane anao nara’iy iti sabuw nagurusih?” ");
INSERT INTO aai_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Baise Jesu tatabir hairi’ika kwararih. ");
INSERT INTO aai_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naatu Jesu ana bai’ufununayah bairi hin bar merar ta hitit. ");
INSERT INTO aai_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ef hiyen hinan naiwanamaim orot ta Jesu ana tur eowen eo, “Ayu boro ani’ufnuni o menamaim kwenan boro imaim tanan.” ");
INSERT INTO aai_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu orot iya’afut iu, “Haruharu hai sau tema’am, naatu mamu hai batar tema’am, baise Orot Natun mare ma biyan tubaiwa’an isan aurin efan i en.” ");
INSERT INTO aai_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naatu Jesu tatabir orot ta isan eo, “Kwi’ufnunu airit tan.” Baise orot eo, “Regah akokok wan i boro inihamiyu anan tamai morob inu’in anab anan ana yai imaibo ani’ufnuni?” ");
INSERT INTO aai_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Baise Jesu orot iya’afut eo, “Murubih kwaihamiyih boro murubih taiyuwih hinaya’ih. Baise o i kwen, God ana aiwob isan kubinan.” ");
INSERT INTO aai_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naatu orot ta na maiye eo, “Regah ayu i boro o ani’ufnuni, baise wan i boro anan hinai tamai naatu taitu tuwai’inah anao tuturih.” ");
INSERT INTO aai_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu iya’afut iu, “Orot yait busuruf ana me bifufubiy, naatu misir maiye bat au’uf enunutabitabir, God ana aiwobomaim boro men karam nabow.” ");
INSERT INTO aai_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iti ufunamaim Jesu orot afa’abo rubinih, nah etei 72. Naatu efan i na bainanawanamih notanot imaim rouru’ab wan iyafarih hin. Bar awan, awan hirun hitit hibinan hiremor. ");
INSERT INTO aai_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesu iuwih eo, “Masaw i gagamin na’in iyamur, baise fourayah i matan ta’amo. Isan imih Regah fourayan matuwan isan kwanayoyoban saise bowayah moumurihika niyafarih hinan masaw hinafour. ");
INSERT INTO aai_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kwatit kwan! Sheep na’atube abiyafari haru kakafih wanawanahimaim kwananamih. ");
INSERT INTO aai_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kwanatitit umamaim men Kaukut ta kwanab, hafoy, a baibiyow ta kwanab; naatu efamaim men kwanabat sabuw kwanibabatiyihimih. ");
INSERT INTO aai_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bar menatan kwanarur wantoro’ot kwanao, “Tufuw kwa etei isa nama.’ ");
INSERT INTO aai_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Naatu nati bar wanawanan tufuw ana orot nama’am na’at, kwa tufuw kwabitin boro nab, baise en na’at, a tufuw kwabitin boro namatabir maiye kwanab. ");
INSERT INTO aai_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Naatu bar nati kwarun kwabaib imaim kwanama, siwar abisa’awat tibit i kwanabow kwanaa kwanatom bairi kwanama, anayabin bowabow sabuw tebowabow i hai baiyan tebaib. Naatu men bar bar afe kwana yara’ara’ah kwanaremor. ");
INSERT INTO aai_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bar merar menatan kwanatitit a merar hinay hinabuwi, abisa hinabit kwanab kwana’aan, ");
INSERT INTO aai_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","nati bar meraramaim sawusawuwih kwaniyawasih, naatu hai tur kwana’owen ‘God ana aiwob i natit sawar.’ ");
INSERT INTO aai_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Baise bar merar menatan kwanarur sabuw men a merar hinayiy, kwanatit ef yan kwanabat kwanao, ");
INSERT INTO aai_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aki ai fofob iti a bar a meraramaim arutatab bebeyan abimatnuwi kwa a baimakiy isan. Baise men nuhi nabur God ana Aiwob i na iyubin sawar.’ ");
INSERT INTO aai_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Anababatun a tur ao’owen baibatebat ana veya nati bar merar sabuw i boro baimakiy gagamin na’in hinab, men Sodom sabuw hibaib na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chorazin sabuw naatu Bethsaida sabuw, kwa i boro sawar kakafin maiyow isa namatar! Anayabin ina’inan iti kwa biyamaim asisinaf marasika Taiya, Sidon sabuw biyahimaim ata sinaf, mar ta’imon boro hai bowabow kakafih notawiyen isan yuhwah gao hitarab hai kakafih hitae’en! ");
INSERT INTO aai_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Baise baibatebat ana veya Taiya naatu Sidon sabuw God boro kaifai nakabibirih, naatu kwa i boro baimakiy gagamin na’in kwanab. ");
INSERT INTO aai_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kwa Capernaum sabuw! Wab kwabora’ah a fair kwabibigan, God boro nagurusi morob ana efanamaim nitaiy kwanare!” ");
INSERT INTO aai_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Naatu Jesu ana bai’ufununayah iuwih eo, “Orot yait a tur enonowar, nati i ayu au tur enonowar, na’atube orot yait ekwakwahiri nati i ayu ekwakwahiru. Naatu orot yait ayu ekwakwahiru, nati i yait ayu iyafaru anan i ekwakwahir.” ");
INSERT INTO aai_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Orot nah etei 72 yasisiramaim hina Jesu biyan hitit hio, “Regah, o wabimaim demon au’uwih i mar ta’imon fanai hibai hititit.” ");
INSERT INTO aai_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu iyafutih eo, “Satan marane namanamar na’atube bokiyakiyat hea’obow re’er a’itin. ");
INSERT INTO aai_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kwananowar fair etei kwa ait aonowahi sawar, imih kwa boro kok naatu sana’ar tafah kwanabat kwanaremor, na’atube rakit hai ahay hai waf etei boro kwanawasatan, boro men abis ta niyababanimih. ");
INSERT INTO aai_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naatu demon kakafih kwa’uwih fana hibai hibibihir isan men kwaniyasisir. baise maramaim God wab kikirum isan i kwaniyasisir.” ");
INSERT INTO aai_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nati ana veya’amaim God Anunin Kakafiyin Jesu iwa’an yan wanawanan yasisir awan karatan eo, “Tamai o i mar tafaram ana aiwob! A merar ayiy anayabin sawar iti etei o sabuw so’obayah naatu sabuw notanotayah men i’obaiyih, baise ibun na’atube ma’am boro’obo natunat bereberefiy i i’obaiyih tesoso’ob isan, Tamai a merar ayiy, iti sawar etei i o a kokomaim isinaf temamatar.” ");
INSERT INTO aai_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Naatu Jesu iuwih eo, “Sawar tutufin etei Tamai ayu itu, men yait ta so’ob ayu i God Natun, baise Tamai akisinamo so’ob, na’atube men yait ta Tamai so’ob, baise ayu i Natun akisu’umo aso’ob. Naatu sabuw iyabowat i Natun rurubinihiwat boro God isah nirerereb hinaso’ob.” ");
INSERT INTO aai_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Imaibo Jesu tatabir ana bai’ufununayah akisihimo iuwih eo, “Kwa i kwabiyasisir anayabin God ana bowabow anababatun mata yan kwa’i’itin. ");
INSERT INTO aai_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Anababatun a tur ao’owen, dinab oro’orot naatu aiwob sabuw hikok kwanekwan kwa abisa kwa’i’itin i hita’itin naatu abisa kwanonowar, i hitanowar, baise men hi’itin naatu men hinowar.” ");
INSERT INTO aai_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ofafar bai’obaiyenayan orot so’obayan ta, Jesu baikubibiruwinamih misir ibatiy eo, “Bai’obaiyenayan, ayu i boro abisa anasinaf ma’ama wanatowan anab?” ");
INSERT INTO aai_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu iya’afut eo, “Buk Atamaninamaim hikirum inu’in ibiyab hai yabih abisa’awat i’itan?” ");
INSERT INTO aai_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Orot iya’afut eo, “Regah, a God isan, dogor tutufin etei, ayub tutufin etei, a fair tutufin etei, naatu a not tutufin etei a Regah isan iniyabow, naatu taituwa isah iniyabow, o taiyuw isa kubiyabow na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu iya’afut eo, “Abisa i’o i tur anababatun i’o, isan imih kwen abisa i’o na’atube kusinaf saise ma’ama wanatowan boro inab.” ");
INSERT INTO aai_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Baise ofafar bai’obaiyenayan taiyuwin bora’ah na’atube, imih Jesu ibatiy maiye, “Ayu taituwau i iyab?” ");
INSERT INTO aai_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu iya’afut eo, “Ana veya ta Jerusalemane orot ta au Jericho re inan basit, sabuw kakafih wanawanah run, hitit ana faifuw hi’oromen hibai hirab hitaiy re imamayay in, ana sawar hibow hibihir hin. ");
INSERT INTO aai_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nati veya ta’imon firis ibo Jerusalemane au Jericho re inan basit, orot ef awan inu’in itin, baise ef sisibin raunane yagebageb bihir in. ");
INSERT INTO aai_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levi orot ibo auman nati ef ta’imon re nan orot inu’in itin, naatu ef au waraunane yagebageb in. ");
INSERT INTO aai_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Baise Samaria orot nati ef ta’imon remor re nan orot inu’in koun yen, naatu nuware i’itin ana veya’amaim ana yababan ra’at. ");
INSERT INTO aai_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Basit na orot inu’inumaim tit, biyan feher matahimaim raiy isusuwa’en naatu biyan fiyow sawar, basit bai ana donkey afe’en yara’ah naatu bai hin nanawan bar ta imaim yai ma’uh ma. ");
INSERT INTO aai_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hi’in marto ana kaukut eofere kabay rou’ab bai orot bar kaifenayan itin eo, ‘Iti orot inakaif airi kwanama, naatu abisa’awat isan inasisinaf ana matabir anan au tur ina’owen boro anibaiyani.’” ");
INSERT INTO aai_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iti na’at eo sawar basit, Jesu orot ibatiy, “Orot tounu wanawanahimaim orot menatan i taituwan kakafih hirab inu’in isan ana yabow i’inuw?” ");
INSERT INTO aai_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ofafar bai’obaiyenayan Jesu iya’afut eo, “Orot taituwan itin yan baban bibais.” Imaibo Jesu orot iu, “Kwenan nati na’atube kusinaf.” ");
INSERT INTO aai_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu ana bai’ufununayah bairi efamaim hiremor hinan basit hina babin wabin Martha ana bar ana meraramaim hitit; hai merar yi buwih ana baremaim hirun. ");
INSERT INTO aai_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naatu i tain Mary na Jesu nanamaim mare ma, Jesu abisa eo i ma nonowar, ");
INSERT INTO aai_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","baise Martha bowabow etei akisin bowabow isan yan so’ar na eo, “Regah Mary sawar etei ihamiyen akisu abowabow ku’i’itin i mi’itube kunotanot? Karam boro itau tan tibaisu airi ata bow ai en?” ");
INSERT INTO aai_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Regah iya’afut eo, “Martha, Martha, o i sawar moumurih na’in isah inot a yababan ra’at ya esoso’ar, ");
INSERT INTO aai_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","baise sawar ta’imon i takokok gagamin. Mary i sawar gewasih rubin, naatu boro men yait biyanamaim nabosairimih.” ");
INSERT INTO aai_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Veya ta Jesu efan ta’amaim ma yoyoban inan, ana yoyoban sasawar ufunamaim ana bai’ufununayah orot ta natit eo, “Regah, kwi’obaiyi ana yoyoban, John ana bai’ufununayah bi’obaiyih na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu iuwih eo, “Yoyobanamih iti na’atube kwanayoyoban. Tamai, ‘A merar ayiy wab kakafiyin abobora’ara’ah, a aiwob nan wanawana’imaim narun. ");
INSERT INTO aai_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mar etei ana fofonin ai bay initi. ");
INSERT INTO aai_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ai bowabow kakafih kunotawiyen, sabuw afa aki isai hisisinaf kakaf anotanotawiyih na’atube. Naatu men routobonamaim inanawiyi.’” ");
INSERT INTO aai_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Imaibo Jesu ana bai’ufununayah iuwih eo, “O yait a of auman boro fainaiwan itan itafefeyan itao, “Au of akokok rafiy fafar tounu inibaisu, ");
INSERT INTO aai_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","anayabin ayu au of ta bai’esegamih inan na au bar tit naatu ayu auru bay en, imih o isa abifefeyan inibaisu.’ ");
INSERT INTO aai_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naatu a of bar wanawanan boro na’afatit nao, ‘Men akokok au in ini’afiy, etawan i atufatan, naatu ayu natunatu bairi i a’inu’in, imih men karam boro ana misir bay anit.’ ");
INSERT INTO aai_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Naatu kwanotanot nati orot boro namisir ana of bay nitin? Ai, boro namisir ana of bay nitin, baise a tur ao’owen orot namisir ana of bay nabitin i men i ana of imih bay ebitin, baise anayabin, nati orot i ana fefeyanamaim ana of ihahar imih misir bay itin. ");
INSERT INTO aai_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Imih a tur ao’owen. Inafefeyan boro inab, inanuwet boro inatitau’ur, inarukikitar etawan boro nabotawiy. ");
INSERT INTO aai_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anayabin Orot yait efefeyan boro nab, orot yait enunuwet boro natita’ur; naatu orot yait erurukikitar etawan boro nabotawiy. ");
INSERT INTO aai_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kwa kek tamahinah natunat siyamih hitarererey na’at boro siy efanin kok kwatitih hita’an? ");
INSERT INTO aai_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O mamu foufunamih hitarererey na’at boro kafukafus kwatitih hita’an? ");
INSERT INTO aai_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwa kek tamahinah, kwa i sawar kakafih moumurih maiyow kwasisinaf, baise natunat isah boro men nuhi naburumih, abisa isan hikokok tibiyababan boro kwanab kwanan kwanitih. Imih kwanaso’ob, Tamat maramaim baitinin isan i igewasin kwanekwan, imih sabuw iyab Anun Kakafiyin isan tefefefeyan boro nitih!” ");
INSERT INTO aai_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesu demon awan bey nun tit; naatu demon bihir tit orot bihamiy ana veya’amaim orot busuruf tur eo, sabuw hai tur sawar hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Baise sabuw afa hio, “Nati i demon hai ukwarin wabin Beelzebul ana fair itin imih enununih.” ");
INSERT INTO aai_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naatu sabuw afa hikok i marane ina’inan ta tiwa’an hita’itin, imih hikubibiruw. ");
INSERT INTO aai_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Baise abisa hinotanot Jesu so’ob naatu iuwih, “Tafaram ta’imon hinakusib rou’ab namatar hinabiyow, hai fair boro hina gurus, na’atube orot aawan natunatun aawat bairi hinakusib hinabiyow boro hinama kakaf. ");
INSERT INTO aai_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Imih Satan an aiwob wanawananamaim hina kusisib hinabiyow, ana aiwob boro mi’itube fair nab nabat? Ayu iti tur ao anayabin i kwa a turamaim, ayu Beelzebul hai ukwarin fair baitu demon nunih kwarouw kwa’o. ");
INSERT INTO aai_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Baise ayu Beelzebul ana fairamaim demon ana nununih na’at, bo kwa a bai’ufununayah fair yait itih demon tinununih? Imih kwa taiyuw a bai’ufununayah iti kwa’o isan hinabi’obaiyi kwa a tur i men turobe! ");
INSERT INTO aai_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Baise ayu God ana fairamaim demon ana nunih hinatitit na’at, nati ebi’obaiyi God ana aiwob i natitaka. ");
INSERT INTO aai_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Orot fairin aurin ahay waf karam ma ana bar ekakaif, ana sawar etei boro natafafar hina’in. ");
INSERT INTO aai_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Baise orot fairin anababatun nati orot boro nawasfufur narun ana ahay ana waf tafahimaim ema’am boro niteten nan ana ofonah nafaramih bairi hinabow. ");
INSERT INTO aai_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Orot yait ayu ananamaim men enan, i ayu isou ebiwosai, naatu orot yait men ibaisu airi sabuw abita’ay, i was geyayan. ");
INSERT INTO aai_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Demon kakafin orot biyanamaim titit ana veya i efan gewasin ta imaim ma baiyarir isan nuwet in, baise nuwet inan efan men ta tita’ur, naatu eo, “Ayu i boro ana matabir maiye au bar abihamiy ana’itin.” ");
INSERT INTO aai_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Basit matabir maiye na ana bar titit, hirereb hina yabuna inu’in itin. ");
INSERT INTO aai_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naatu tit in demon kakafih anababatun etei seven nawiyih bairi hina nati’imaim hisusuw hima. Yomaninamaim orot ana itinin botabir kakafin anababatun matar men marasika ma’am na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu iti na’atube bat binan sabuw hai tur eo’owen auman, babin ta sabuw wanawanahimaim ma’am, Jesu isan eo, “Babin yait taub o ya’i bitoman i ebiyasisir.” ");
INSERT INTO aai_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Baise Jesu eo, “Sabuw iyab God ana tur hinowar tibi’ufunun i turobe anababatun tibiyasisir.” ");
INSERT INTO aai_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sabuw moumurih maiyow hiru’ay Jesu hi’ar bebera’uh, naatu Jesu iuwih eo, “Boun ana veya’amaim sabuw hai yawas etei i eaf, ina’inan matar itah isan tefefefeyan, baise ina’inan ta boro men anitih, ina’inan ta’imon i Jonah isan mamatar i hiso’obaka. ");
INSERT INTO aai_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anayabin Jonah biyanamaim ina’inan mamatar i Nineveh sabuw isah. Imih Orot Natun i sabuw iti boun tema’am hai i’inanen. ");
INSERT INTO aai_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Baibatebat ana veya tafaram Sheba hai aiwob babin boro namisir. Sabuw iti boun tema’ama boro tur fokarin maiyow na’uwih, anayabin ef yok na’in tafaram yomaninaka aiwob orot Solomon ana binan gewasin nowaramih natit, baise a tur ao’owen, sawar ta iti boun kwa’i’itin i Solomon natabir. ");
INSERT INTO aai_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Naatu a tur ao’owen maiye, Baibatebat ana veya Nineveh sabuw boro hinamisir kwa iti kwama’am boro tur fokarin maiyow hina’uwi, anayabin Jonah binan hinonowar ufunamaim hai bowabow kakafih etei hihamiyen dogor baikitabir hibai, naatu boun i a tur ao’owen, orot ta Jonah tafanamaim i natit iti wanawanamaim ema’am. ");
INSERT INTO aai_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Orot men ta ramef ito’ab naatu bai run ibunimih, o noukwat wanawanan tarafutimih. Baise ana sisikofamaim sikof, saise sabuw hinanan ana marakawin hina’itin boro hinarun. ");
INSERT INTO aai_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata i biya ana hinow, mata gewasin biya etei boro marakawin. Baise mata kakafin biya etei boro nagugum. ");
INSERT INTO aai_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Isan imih kwanakaifi gewas a marakaw biyamaim men kwaniwa’an nagugum. ");
INSERT INTO aai_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Biya tutufin etei namamarakaw na’at, biya turin boro men nagugum. Baise na biya wanawanan tutufin etei namarakaw, ramef ana marakaw tafamaim in ekukusisiyar na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu iti tur eo in sasawar ufunamaim, Pharisee orot ta kok i boro Jesu hairi hitan ana baremaim bay hitaa. Imih Jesu ifefeyan hairi hina ana bar hitit naatu bay aa ana efanamaim mare. ");
INSERT INTO aai_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Baise Pharisee orot Jesu i’itin i men ofafar i’ufunun an souwibo na bay aa ana efanamaim mare, imih Pharisee orot ana kasiy ra’at. ");
INSERT INTO aai_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naatu Jesu iu, “Kwa Pharisee i a kerowas naatu a tew ufuhine kwa sasouwen, baise kwa dogor wanawanan i baribar kakafin naatu rougoy rabirabin. ");
INSERT INTO aai_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kwabikoko’aw! God biya ufunane wowowab na’atube biya wanawanan auman wowowab men kwaso’ob? ");
INSERT INTO aai_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Imih a kerowas naatu a tew wanawanah abisa’awat tema’am yababan wairafih kwanitih hinaa, saise kwa a sawar etei boro hinigewasin. ");
INSERT INTO aai_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yababan boro gagamin maiyow kwanab, kwa Pharisee sabuw! Anayabin kwa iti mint, rue, naatu adanafur afa God baitinin isan i men nuhi eburubur, mar etei ana mumusin God kwabitin, baise ma gewas naatu God ana yabow isan i nuhi eburubur, gewasin nati sawar i kwati’a’ait sawar afa auman kwatasinaf. ");
INSERT INTO aai_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yababan boro kwanab, kwa Pharisee sabuw! Anayabin kwa a kok gagamin i Kou’ay Bar wanawanah efan gewasih kwanabow kwanamare kwanama, naatu ahar hai efanamaim a kok gagamin i sabuw a merar hinay naatu hinakakaf. ");
INSERT INTO aai_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yababan boro kwanab! Anayabin kwa i rah atamanih hai i’inanen en sabuw so’oba’e tafah hibat tereremor na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ofafar so’obayan orot ta Jesu ibatiy, “Bai’obaiyenayan iti tur i’o i aki auman irabi.” ");
INSERT INTO aai_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu iya’afut eo, “Kwa Ofafar Bai’obaiyenayah so’ob wairafi auman boro yababan kwanab. Anayabin bit gagamin na’in sabuw tuwabuh kwayara’ah hi’abar tun erarabih, naatu kwa i men kafa’imo uma ta baibais isan kwabitihimih. ");
INSERT INTO aai_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yababan boro kwanab! Anayabin dinab oro’orot kwa a’agir hirouw himomorob i hai rah kwama kwawowowab gaigiwas. ");
INSERT INTO aai_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Imih kwa i taiyuw kwakukubuna, abisa a’agir hisisinaf a baibasit kwabitin, dinab oro’orot a’agir hirouw himorob naatu kwa i hai rah kwawowowab. ");
INSERT INTO aai_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anayabin iti isan, God ana so’obamaim eo ‘Ayu boro dinab oro’orot naatu kob abarayah aniyafarih, afa boro hina rouw hina morob, afa boro bai’akir kakafin hinab.’ ");
INSERT INTO aai_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Isan imih kwa sabuw iti boun kwama’am, God ana dinab oro’orot tafaram aneika hirouw himomorob ana baimakiy i boro kwa kwanab. ");
INSERT INTO aai_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel ana rara’ika busuruf na Zechariah ana rara’amaim tit. Zechariah i Tafaror Baremaim iti sibor ana gem naatu Regah ana Bar Kakafiyin hairi hai founamaim hi’asabun morob. Imih anababatun a tur ao’owen kwa iti boun kwama’am iti sabuw hai baimakiy boro kwa kwanab. ");
INSERT INTO aai_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kwa Ofafar Bai’obaiyenayah so’ob wairafi. Yababan boro kwanab. Anayabin etawan botawiyin run so’ob bain ana tufatan i kwa kwabobotan, naatu kwa iti bar i men kwakokok boro kwarun so’ob kwanab, baise sabuw afa run so’ob bainamih tisisinaftobon kwa i hai ef kwahirihir.” ");
INSERT INTO aai_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu efan nati bihamiy ana veya’amaim Ofafar Bai’obaiyenayah naatu Pharisee yah so’ar hiu kwanikwaniy naatu baibatebat moumurih na’in hibow hitit hibabatiy, ");
INSERT INTO aai_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","naatu hikubibiruw na’atube abisa tao kakaf na’at saise ubar hititin hitafatum isan. ");
INSERT INTO aai_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nati ana veya’amaim sabuw hiruru’ay ana itinin i sibisib na’atube, naatu sabuw himour kwanekwan efan etei hibai karam hi’a’abinamo hibat. Jesu ana bai’ufununayah iuwih eo, “Pharisee hai yeast isan mata toniwa’an, nati sabuw ufuhine ana itinin i gewasin baise wanawanah i rerekabin, imih a tur ao’owen. ");
INSERT INTO aai_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abisa hisabuw inu’in boro sabusabuw hinabosair, naatu abisa wa’iwa’irin inu’in boro nirerereb. ");
INSERT INTO aai_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Abisa guguminamaim kuo boro natit marakawamaim hinanowar, naatu abisa akisimo bar etawan ihir taituwa taininamaim kubitarasib boro bar faifiy wan hinabat hinao rereb. ");
INSERT INTO aai_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Au ofonah a tur ao’owen sabuw iyab biya hina’a’asabun isan men kwanabir, anayabin nati ufunamaim boro men abisa ta hinasinaf. ");
INSERT INTO aai_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Orot yait kwana bibiruw i anao kwananowar. God i kwanabiruw, anayabin biya na’a’asabun ufunamaim ana fair ema’am boro baimakiy ana efanamaim nitaiy kwanare. Imih a tur ao’owen God i kwanabiruw. ");
INSERT INTO aai_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mamu kwikwik etei five hai biyan i two toea tetotobon, baise God boro men kafa’imo nati mamu kikimin ta isan nuhin eburuburumih. ");
INSERT INTO aai_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na’atube ukwarimaim arib eretei bai’ab tebatabat God i so’ob, imih men kwanabir. Kwa a baiyan i ra’at men mamu kwikwik na’atube. ");
INSERT INTO aai_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A tur ao’owen, orot yait ayu isou sabuw etei nahimaim eo’orereb, Orot Natun auman boro God ana tounamatar etei nahimaim nati orot isan naorereb. ");
INSERT INTO aai_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Baise orot yait sabuw etei nahimaim ayu eyayaubu. Orot Natun auman boro na’atube God ana tounamatar etei nahimaim ibo nayaub. ");
INSERT INTO aai_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yait Orot Natun isan tur nao kakaf na’at boro nanotawiy, baise orot yait Anun Kakafiyin isan tur kakafin nao nabi’ib boro men nanotawiy. ");
INSERT INTO aai_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Baibabatiyi isan hinabuwi kwanan Kou’ay Baremaim, o gawan sabuw nahimaim, o aiwob sabuw nahimaim, men taiyuw wasfafari isan, o tur mi’itube eo isan kwaniyababanamih. ");
INSERT INTO aai_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Anayabin God Anun Kakafiyin nati ana veya’amaim boro tur ni’obaiyi kwanao.” ");
INSERT INTO aai_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Rou’ay wanawanahimaim orot ta Jesu iu, “Bai’obaiyenayan, ayu akokok tuwai ana tur ina’owen, tamai momorob ana kwahan nafaram airi ana bow.” ");
INSERT INTO aai_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu iya’afut eo, “Aro, ayu au ef men ema’am boro anibasit tuwat airi a sawar kwahan ana faram?” ");
INSERT INTO aai_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naatu Jesu tatabir sabuw etei iuwih eo, “Mata toniwa’an sawar moumurih na’in bow isan men mata nananan niwa’an. Anayabin yawas wanatowan boro men orot ana sawar moumurih imaim hinafufun hinitinimih.” ");
INSERT INTO aai_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naatu Jesu oroubon ta eo, “Ana veya ta orot sawar wairafin ana masaw bo ana ub hiyen gewas hiw ro’oh moumurih na’in hiya itah, ");
INSERT INTO aai_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","basit mare ma not. ‘Ayu boro mi’itube ana sinaf? Anayabin iti bay hinafafour efan i boro en.’ ");
INSERT INTO aai_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naatu ana notamaim eo, ‘Ayu boro iti na’atube ana sinaf, bay hai bar atamanih ana ku’uben hinare naatu gagamih ana wowab. Saise au bay ana ya naatu au sawar afa auman imaim ana ya.’ ");
INSERT INTO aai_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Imaibo anao, ‘Darik orot, anababatun abow, kwamur manin na’in ana fofonin sawar etei abogaigiwas sawar, imih bounabo hamen ana mare anama gewas, anaa anatom taiyuwu aniyasisir!’ ");
INSERT INTO aai_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Baise God iu, ‘Kwikwekwe’aw gewas! Boun gugumin boro inamorob naatu a sawar iti ibobogaigiwas boro yait nabow?’” ");
INSERT INTO aai_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Naatu Jesu ana tur yomaninamaim eo, “Imih itinin i ta’imon, sabuw iyab aurih sawar karam hiya tetototo God matanamaim i men sawar wairafih.” ");
INSERT INTO aai_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Imaibo Jesu ana bai’ufununayah iuwih eo, “A yawas isan a tur ao’owen men kwaniyababan kwanao, ‘bay boro menamaim anab ana’aan,’ o biya isan kwanao, faifuw boro menamaim anab ana’us. ");
INSERT INTO aai_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Anayabin it etei taso’ob yawas i sawar gagamin men bay na’atube naatu biyat i sawar gagamin men ar faifuw na’atube. ");
INSERT INTO aai_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Baise kwanuw mamu awaw kwana’itih, i men me hikwair hitar, masaw hibo, naatu hifour hitab te’aa’umih en, na’atube men bay hai bar hiwowab imaim bay teya’aya’amih en, baise God akisin ebituwih! Imih kwa i God ana sawar gagamin men mamu na’atube! ");
INSERT INTO aai_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Isan imih iti sawar isah kwana biyababan ana gewasin i boro abisa namatar? Kwanotanot nati kwana biyababanamaim boro kwamur tabo ayawas tafan hina yara’ah namanin kwanama? Men karam. ");
INSERT INTO aai_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A yababan iti sawar gidigidih isah kwabiyababan men emamatar, aisim sawar gagamih isah kwabiyababan? ");
INSERT INTO aai_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kwanuw rarab bogay ebatabat kwa’itin, men masaw hitar tebob, o ar faifuw tesasakir en, baise a tur ao’owen aiwob orot Solomon ana bar bonamanamarinamaim ma’am ana veya ana faifuw eo’osen hai gewasih i men iti beran ana gewasin na’atube’emih en. ");
INSERT INTO aai_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Imih kwana’itin, God ar faifuw kutor fotan ius ana itinin gewasin maiyow boun ina’itin baise maras boro nakimow naha’obow nare hinab hinan wairaf wan hina yara’ah na’arah ni’en. Baise kwa i God ana sawar gagamin fai mar etei boro nakaifi ar faifuw nit kwana’osen, aisim a not ebikikimin! ");
INSERT INTO aai_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Imih men mar etei aa tom isan kwananot kwaniyababanamih. ");
INSERT INTO aai_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anayabin Eteni Sabuw iti tafaram wanawanan tutufin etei iti sawar isah hinuwet tibiyababan, naatu kwa Tamat iti sawar etei isah kwakok kwabiyababan i so’ob. ");
INSERT INTO aai_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Baise wan i God ana aiwob kwananuwih kwanab dogoromaim nama, imaibo iti sawar isah kwanot kwabiyababan boro etei nit. ");
INSERT INTO aai_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kwa i ayu au bobaituw na’atube imih men kwanabir, anayabin Tamat aiwob bait isan i ebiyasisir boro nit. ");
INSERT INTO aai_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Imih a sawar eretei sabuw kabay wairafih ku’uwih tetobon naatu o kabay kubai yababan wairafih kufaramih, saise a kaukut no maramaim inabaib boro men natakweb; a sawar etei maramaim inaya’ay boro men ta nakasiy, o boro men ta bainowan hinabain naatu boro men ta ganidor hina’aanimih en anababatun. ");
INSERT INTO aai_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anayabin o sawar menamaim kuya’aya a not tutufin etei boro imaim na’in. ");
INSERT INTO aai_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mar etei inabobuna a ar uwakamukamut inarab, a ramef inito’ab namarakaw o mata nuwinuwin inama, anayabin o men iso’ob boro abisa namatar. ");
INSERT INTO aai_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ana’itin akir wairafih hai orot ukwarin tabin ana hiyuwane matabir maiye nan isan hima hikakaif, hai orot ukwarin matabir na etawan rurukikitar ana veya mar ta’imon hinowar naatu etawan hibotawiy rur na’atube. ");
INSERT INTO aai_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Anababatun a tur ao’owen, akir wairafih iyab matah nuwinuwin hinama’am hai orot ukwarin namatabir nan na’i’itih ana veya, yasisir boro gagamin maiyow hinab! Anayabin i boro ana akir wairafih na’uwih hinamare naatu orot ukwarin boro bay semosemor ana faifuw na’us bay nasemor nitih hinama hinaa. ");
INSERT INTO aai_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akirwairafih hina bobuna matah nuwinuwin hina ma’am hai orot ukwarin nan natit, o mar natot auman nan natit na’i’itih na’at, boro yasisir gagamin maiyow hinab! ");
INSERT INTO aai_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Imih iti tur ao i naniyan kwanab naatu kwananot, orot bar matuwan bainowan mowan bainuwinamih enan ana veya nasoso’ob na’at, ana bar boro men nihamiy bainowan mowan nakwib narun nabainuwimih en. ");
INSERT INTO aai_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imih itinin ta’imon i nati, kwa auman kwana bogewas mata nuwinuwin kwanama, anayabin Orot Natun boro men veya kwa kwanotanotamaim natitamih.” ");
INSERT INTO aai_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter eo, “Regah, iti oroubon kuo i aki isai, o sabuw eretei isah kuo?” ");
INSERT INTO aai_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Regah iya’afut eo, “Anababatun a tur ao’owen Akir wairafin orot gewasin naatu ana not rerekabin, orot ukwarin nati akir wairafin boro nab akir wairafih afa isah ni’ukwarin naatu hai bay baitih isan boro ana veya’amaim nitih hinaa. ");
INSERT INTO aai_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Anayabin orot ukwarin matabir nan nati akir wairafin bowabow gewasin maiyow bowabow itin, imih iyasisir ana akir wairafin bai yara’ah bowabow gagamin na’in itin! ");
INSERT INTO aai_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ana bar wanawanan sawar tutufin etei i akisin i’ukwarin kaif. ");
INSERT INTO aai_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Baise akir wairafin na’at nao, ‘Orot ukwarin bisaise enan, no’om boro ma hamen hamen erurubirabir, imih ayu boro au kokomaim anasinaf.’ Naatu namisir bowabow sabuw, oro’orot baibin nabow narouw kwanekwan ni’a’afiyih, naatu ana kokomaim naa natom kwanekwan nikoko’aw nanan ana veya. ");
INSERT INTO aai_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Imaibo Orot ukwarin boro nan natit, veya men nati akir wairafin so’ob ma ekakaifimaim boro nanamih, naatu na isan ana veya boro baimatnuwina’e nama’am nan natit. Naatu orot ukwarin nan natitit ana veya nati akir wairafin boro nab nabeyah natarsisib nisaroun baifanasairayah hai efanamaim bairi hinama.” ");
INSERT INTO aai_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Akir wairafin ana orot ukwarin abisa sinafumih kokok i so’ob baise men saife taiyuwin yabuna ana orot ukwarin abisa kok eo’omaim sisinaf, nati orot boro hinawabir biyababan gagamin na’in nab. ");
INSERT INTO aai_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Baise akir wairafin ana orot ukwarin abisa sinafumih kokok i men so’ob, naatu isisinaf kwanekwan biyababan enunuwih boro au hamenamo hinawabir biyan nababan. Sabuw iyab sawar gagamin na’in tebaib, i na’atube sawar gagamin na’in boro wan hinay maiye. Orot yait gagamin anababatun tibitin i auman boro gagamin anababatun isan hinafefeyan nitih maiye. ");
INSERT INTO aai_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ayu i wairaf abai iti tafaram afuninamih ana atit, au kok gagamin na’in i mi’itube iti tafaram marasika tabusuruf ta’arah. ");
INSERT INTO aai_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ayu i bapataito fokarin maiyow nou’umaim ema’am boro wanawanan ana run anab, imih boun dogorou wanawanan i yababan awan karatan ama anotanot anan yomanin anisawar imaibo nuhunafot! ");
INSERT INTO aai_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kwa kwanotanot ayu i tufuw abai tafaramamaim ana? En, a tur ao’owen, ayu i men tufuw abai anamih, baise kauseb abai ana. ");
INSERT INTO aai_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mar iti boun orot aawan natunatunawat nah etei five boro hinakusib tounu rounane hinabat rou’ab rounane hinabat taiyuwih hinakusib hinigamigam. ");
INSERT INTO aai_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kek tamah hairi boro taiyuwih hinakusib hinagam. Babitai hinah hairi boro hinakusib hinagam na’atube babine rawan babin hairi boro hinakusib hinagam.” ");
INSERT INTO aai_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu sabuw isah iban eo maiye, “Veya ra’iyinane sakuk nayen nabi’afar badowan kwana’i’itin ana maramaim, kwa boro mar ta’imon kwanao, ‘boun boro toun nayar’, naatu toun eyarayar. ");
INSERT INTO aai_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Naatu gurufune gagub nayen narab kwananowar kwa boro kwanao, Veya boro nararan, naatu veya erararan. ");
INSERT INTO aai_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wanawanan rerekabih! Me kamar hai sawar naatu gagub wanawanan hai sawar abisa temamatar i kwa’itah kwa’inanen kwaso’ob kwa’o. Baise aisim sawar abisa iti boun temamatar hai yabih men kwaso’ob? ");
INSERT INTO aai_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aisim sawar abisa gewasin sinaf isan men taiyuw kwabibabatiyi? ");
INSERT INTO aai_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sabuw baibatiyih isan hinabuwi kwanan inasinaftobon airi kwanayabuna kwanitounuw, imaibo kwananan baibatiyenamaim kwanatit. Baise o men inasisinaf na’at, i boro nabuw narab natain kwekwetar kwanan baibabatiyenayan orot nanamaim kwanatit naatu i boro nabuw furisiman nitih hinabuwi dibur hina yariyi. ");
INSERT INTO aai_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A tur ao’owen, o boro dibur bar imaim inama agim hio na’atube inibaiyan imaibo boro dibur barene hinabotaiti inatit.” ");
INSERT INTO aai_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nati ana veya’amaim sabuw afa hina hitit, Galilee sabuw sibor hiya’aya wanawanan Pilate rouw himomorob isan Jesu ana tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naatu Jesu iyafutih eo, “Kwanotanot Galilee wanawanan nati sabuw hai bowabow kakafih ra’at sabuw afa hinatabirih imih biyababan nati na’atube hibai himorob? ");
INSERT INTO aai_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Baise en! A tur ao’owen bowabow kakafihine dogor baikitabir kwanab, baise boro kwanamorob i himomorob na’atube. ");
INSERT INTO aai_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Naatu sabuw 18 Siloam bar gagamin tafan katub re rabih himomorob, kwanotanot Jerusalem wanawanan i akisih hai tafasar ra’at sabuw afa hinatabirih, imih nati na’atube himorob? ");
INSERT INTO aai_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Baise en! A tur ao’owen, bowabow kakafihine dogor baikitabir kwanab, baise boro kwanamorob i himomorob na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Imaibo Jesu oroubon ta iti na’atube eo, “Veya ta orot ana masaw wanawanan ai fafou tanum yen ra’at. Naatu veya ta ro’oh isan tit na nura’at baise men ro’on ta itin. ");
INSERT INTO aai_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Basit nati masaw ana kaifinayan isan eo, ‘Aro, kwamur tounu wanawanan ai iti afe’enamaim ro’on men kafa’imo ta aitin. Akokok inatar nare asir bat ata me ebi’afiy.’ ");
INSERT INTO aai_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Baise orot ai ana kaifinayan eo, ‘Regah inihamiy kwamur ta’imon nabat tana’itin, ayu boro anamaim hub anab hain ana yai tana’itin. ");
INSERT INTO aai_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Maras kwamur ai nabiw na’at basit gewasin, boro tanihamiy nabat, baise men nabiw na’at, imaibo boro inatar nare ina’afun.’” ");
INSERT INTO aai_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Baiyarir ana veya ta Jesu na Kou’ay Baremaim ma sabuw bi’obaiyih. ");
INSERT INTO aai_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nati’imaim babin ta afiy kakafih hirab kwatut ma kwamur etei 18 sasawar i na run. Nati babin koun ana rarik i kwabibin, baimutufurin isan biwa’an men karam. ");
INSERT INTO aai_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu nuw babin i’itin ana veya, babin eaf na nanamaim bat. Imaibo eo, “Babin, a sawowone abiyawasi.” ");
INSERT INTO aai_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naatu uman babin tafan yara’ah isan yoyoyoban ana veya, naniyan meyemeye babin koun ana rarik kwabeb inu’in mutufor misir bat God ana merar yi bora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kou’ay bar ana kaifenayan yan so’ar, anayabin Jesu Baiyarir ana veya’amaim babin iyawas, naatu sabuw iuwih, “Veya etei six wanawananamaim i tanabow naatu yawas kwana kokok nati veya’amaim kwanan yawas kwanab, baise men Baiyarir ana veya’amaim.” ");
INSERT INTO aai_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Regah orot iya’afut eo, “Wanawanan rerekabih! Baiyarir ana veya kwa taita’imon a donkey o a ox men kwarufamen kwabow kwan harew kwaitih tetomatom? ");
INSERT INTO aai_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iti babin i Abraham uwan ta, Satan bai fatum wainab kwamur etei 18 sawar, naatu boun ana bai’akirane Baiyarir ana veya abobotait yawas baib isan asinaf kakaf?” ");
INSERT INTO aai_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iti na’atube eo ana veya ana rakit sabuw biyah eohow, baise sabuw moumurih na’in sawar gewasih sinaf hi’i’itan isan hiyasisir. ");
INSERT INTO aai_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Imaibo Jesu ibatiyih, “God ana aiwob itinin i mi’itube? Abisa biyanamaim boro anayai kwana’itin? ");
INSERT INTO aai_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Itinin ta i orot ana ai momor ro’on bai in ana masawamaim tanum, naatu kuboun yen ra’at ai mamatar ana veya’amaim, mamu hina famefamenamaim hibatar hima’am na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesu iban maiye ibatiyih, “God ana aiwob i boro abisa’amaim ana yai kwana’itin? ");
INSERT INTO aai_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ana itinin ta i babin ana faraw afuninamih bai tew gagamin wanawanan isuwai re yeast auman wanawanan nayai kamat ra’at yen tew awan kakaratan na’atube.” ");
INSERT INTO aai_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Imaibo Jesu au Jerusalem yen inan ana maramaim, bar merar gagamih naatu bar merar gidigidih imaim run tit, sabuw i’obaibiyih auman yen in. ");
INSERT INTO aai_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Orot babin ta na Jesu ibatiy, “Regah o kunotanot boro sabuw matan ta’amo God yawas nitih?” Jesu iyafutih eo, ");
INSERT INTO aai_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kwanabow gewas etawan awan kukurinamaim kwanarun, anayabin sabuw moumurih na’in boro nati etawanamaim run isan hinasinaftobon, baise a tur ao’owen boro men nakaram. ");
INSERT INTO aai_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Regah bar matuwan namisir etawan nahirihir kwa boro ufun kwanabat etawan kwanarukikitar kwanao, ‘Regah etawan kubotawiy arun,’ naatu i boro nao, ‘Ayu men aso’ob kwa iyab, naatu menane kwana.’ ");
INSERT INTO aai_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Imaibo kwa boro kwaniya’afut kwanao, ‘Aki o bairi taa tatom, naatu ai bar ai meraramaim ibi’obaibiyi iso’ob, aisim kukakasiy.’ ");
INSERT INTO aai_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Baise i boro nao maiye, ‘Ayu men aso’ob kwa iyab naatu menane kwana. Biyau’umaim kwatit sa’ab kwan, bowabow kakafin sinafuyah.’ ");
INSERT INTO aai_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Naatu boro narukouwi ufun kwanatit kwanama kwanarerey, wa kwanayob kakikak hiniwa’an, naatu kwananuwanuw boro Abraham, Isaac, Jacob naatu dinab oro’orot God ana aiwobomaim hinabat hinabiyasisir kwana’itih! ");
INSERT INTO aai_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sabuw boro veya yeninane, veya ra’iyinane, naatu torene, oyawane etei hinaru’ay God ana aiwobomaim hai efan hinabow hinamare hinama hiyuw hinaa hinabiyasisir boro kwana’itih. ");
INSERT INTO aai_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sabuw iyab boun wan tibi’iyon boro hini’uf, naatu sabuw iyab boun tibi’uf boro wan hini’iyon efan hinab. ");
INSERT INTO aai_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nati veya ta’imon, Pharisee afa hina Jesu ana tur hi’owen hio, “O boro efan iti inihamiy inan efan ta, anayabin Herod ekokok o na’asbuni inamorobomih ef enunuwet.” ");
INSERT INTO aai_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu iyafutih eo, “Kwan nati haruharu ana tur kwa’owen, ayu boun naatu maras hairi i boro sabuw iyab hisawow tema’am biyahimaim demon boro ana nunih naatu sawusawuwih aniyawasih, naatu veya baitounin i ayu au bowabow abisa bowamih anot anan i yomanin anisawar. ");
INSERT INTO aai_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Baise boun, maras, naatu mar natot ayu boro au ef anab maiye anayen anan, anayabin ef men ema’am dinab orot boro Jerusalem ufunane namorob. ");
INSERT INTO aai_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem, Jerusalem, dinab oro’orot irouw himorob, naatu kob abarayah God biyafarih kabayamaim irouw himorob. Mar bai’ab a kok a sabuw ataba’afuwih, kokorere natunatun bebenamaim ebaba’afuwih na’atube, baise o men i kok. ");
INSERT INTO aai_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Imih a bar boro hinihamiy barikokow natuw. A tur ao’owen, ayu boro men kwana’itu, ana veya’amaim boro inao, ‘Yait Regah wabinamaim enan boro baigegewasin nab!’” ");
INSERT INTO aai_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Baiyarir ana veya ta, Pharisee hai ukwarin ana baremaim Jesu bay aamih na, baise sabuw nati’imaim hima’ama i Jesu hibimtitiy. ");
INSERT INTO aai_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naatu nati’imaim orot ta an uman hikurut ma’am yawas isan na Jesu nanamaim tit. ");
INSERT INTO aai_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Baise Jesu Pharisee naatu ofafar so’ob wairafih ibatiyih, “Baiyarir ana veya’amaim ata ofafar ebibasit boro orot babin taniyawas ai en?” ");
INSERT INTO aai_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Baise men tur ta hio. Basit Jesu orot bai iyawas naatu iu ana ubar in. ");
INSERT INTO aai_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Imaibo ibatiyih, “O orot ta natu o a bobaituw Baiyarir ana veya hub tare’er na’at boro itihamiy ta’in tamorob, o boro mata takabiy itarowen ra’ah tayen?” ");
INSERT INTO aai_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sabuw baiyafutinamih hikasiy hima kwanekwan. ");
INSERT INTO aai_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nanawan sabuw afa bay aa ana efanamaim efan gewasih hirurubinen Jesu itih, basit oroubonamaim sabuw iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Orot ta, tabin ana hiyuw isan a kob nan na’uwi inanan men inayen efan gewasinamaim inamare’emih, anayabin orot gagamin ta auman ana kob hinan boro enan. ");
INSERT INTO aai_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Imih orot hiyuw matuwan airi a kob na uwi kwanan boro nayen na’uwi, ‘Aro o kumisir haw kure, tura eyen iti’imaim emare,’ o boro biya’ohow auman inamisir haw inare. ");
INSERT INTO aai_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Imih a kob hinan hina’uwi inanan, haw inamare, saise orot hiyuw matuwan a kob nan boro na’uwi, ‘Au begon kuyen seb ir yan kumare,’ o boro yasisir auman ina misir seb inayen efan gewasin inab nanawan afa bairi ir yan kwanama. ");
INSERT INTO aai_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anayabin orot yait taiyuwin i’itin ra’ah, God boro nab haw nayare, baise orot yait taiyuwin i’itin furuw God boro nayara’ah orot gagamin namatar.” ");
INSERT INTO aai_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Imaibo Jesu bar matuwan hairi bay aamih iu nan isan eo, “Auyit o rabirab ana bay inabitab, men o a of, tait bairi a rara ta’imon, taituwa o isusu’ubih, naatu a’ofonah guguw wairafih ina’uwih hinan bairi kwana’aamih. Anayabin o nati na’atube inasinaf, i boro a bay wan hitab hinit inaa. ");
INSERT INTO aai_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Baise hiyuw inabowabow ana veya, yababan wairafih, ah umah kurut, ah umah duboh, matah fim, ina’uwih hinan bairi bay kwanaa, ");
INSERT INTO aai_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","saise God boro baigegewasin nit. Anayabin sabuw nati boro men a hiyuw wan hinay hinit, baise sabuw gewasih morobone hinamimisir ana veya’amaim, abisa isisinaf isan God boro imaim a wayow nit.” ");
INSERT INTO aai_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Orot ta nati bay ana gemamaim hairi hima’am iti tur nowar, basit Jesu isan eo, “Orot yait God ana aiwobomaim hiyuw isan namamare boro yasisir gagamin maiyow nab.” ");
INSERT INTO aai_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Baise Jesu oroubonamaim orot iu, “Veya ta orot ana hiyuw bogaigiwas, naatu sabuw maumurih na’in hai kob in. ");
INSERT INTO aai_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Naatu hiyuw aanin isan ana veya natit, tur iyafar ana ofonah isah eo, ‘Kwanan hiyuw tanaa, sawar etei ai moyab sawar.’ ");
INSERT INTO aai_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Baise etei hikwahir tur ta ta hibow hitit, orot ta eo, ‘Ayu au me boubun atubun ananutitiyimih anan, a tur ao’owen men karam boro anan.’ ");
INSERT INTO aai_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Orot ta eo, ‘Ayu au cow baubuh etei ten atobon, imih baimanamen isan anan, a tur ao’owen men karam boro anan.’ ");
INSERT INTO aai_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naatu orot ta eo, ‘Ayu i boubun atabin, imih men karam boro aawau anihamiy nama airit tanan.’ ");
INSERT INTO aai_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Akir wairafin matabir maiye na orot gagamin ana tur eowen. Bar matuwan yan so’ar ana akir wairafin iu, ‘Saife kutit kwen ef gagamih yahimaim naatu bar merar hai ef yahimaim sabuw kakafih, yababan wairafih, ah umah kurut, ah umah murubih, matan fim initeten inan hiyuw tanaa.’ ");
INSERT INTO aai_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naatu akir wairafin eo, Regah, io na’atube i asinaf, baise bar awan i men karatan.’ ");
INSERT INTO aai_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Imaibo orot ana akir wairafin iu, ‘Kutit kwen bar merar hai ef gagamih yahimaim, naatu ef gidigidih rewahimaim, sabuw iyab nati’imaim ina’i’itih inabuwih kwanan, saise au bar awan nakaratan.’ ");
INSERT INTO aai_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A tur ao’owen sabuw iyab wan hai kob anan i men hikok imih boro men yait ta au hiyuw nakatubunimih!” ");
INSERT INTO aai_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ana veya ta sabuw rau’ay gagamin na’in Jesu hi’ufunun bairi hinan tatabir iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Orot yait ayu ebi’ufnunu, baise hinah, tamah, aawan natunatun, taitin, ruburubun isah ebiyabow naatu i taiyuwin auman ana yawas isan ebiyabow, nati orot i men karam boro ayu ni’ufnunu. ");
INSERT INTO aai_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Orot yait ana onaf na’abar ayu ananamaim ni’ufnunu airi ananan i ayu au bai’ufununayan. ");
INSERT INTO aai_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Orot ta ana bar wowabinamih boro men asir nawowab kwaniyimih, baise wan i boro namare ana bar ayubin nayakitifuw, ana baiyan boro bai’ab naatu ana kabay karam boro iti bar nawowab nisawar ai en. ");
INSERT INTO aai_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Anayabin ana kabay men nakakaram na’at boro tafah nararauwen ufunamaim wowabina’e nabat, naatu sabuw afa tafawat hinabatabat hina’itin boro hini’iyab hinamarib, ");
INSERT INTO aai_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","hinao, ‘Iti orot bar wowabinamihibe busuruf tafawat rauwen naatu ihamiy ebatabat.’ ");
INSERT INTO aai_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Itinin tabo iti, aiwob orot ta ana baiyowayah etei 10,000 tabow, aiwob orot ta hairi baiyowamih tan, baise aiwob orot ta ana baiyowayah etei i 20,000 imih nati aiwob ta i boro tamare tama tanot, ‘Ayu karam boro nati aiwob orot airi aniyow?’ ");
INSERT INTO aai_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Naatu tanotanot men takakaram na’at, i boro ef yok tama tur tiyafar aiwob turan hairi hitao tufuw hita’afuw. ");
INSERT INTO aai_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ef i nati ta’imon, orot yait nakok ayu bai’ufnunu’umih mat i ana sawar etei nakwahir nayaraiyen. ");
INSERT INTO aai_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Riy i gewasin, baise naniyan nabi’en boro hinisaroun, anayabin men karam boro hiniwa’an riy namatar maiye. ");
INSERT INTO aai_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naatu me yan ub yen gewas isan hinayayare boro men ana gewasin ta namatar, imih boro hinisaroun. Imih o yait tain ema’am inarub tur iti inanowar gewas!” ");
INSERT INTO aai_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana veya ta kabay o’onayah naatu sabuw kakafih Jesu ana tur nowaramih hiru’ay. ");
INSERT INTO aai_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Baise Pharisee naatu Ofafar Bai’obaiyenayah yah so’ar higam hio, “Iti orot sabuw kakafih hai merar yi buwih bairi hima hi’aa tetomatom kwa’itih.” ");
INSERT INTO aai_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Basit Jesu oroubonamaim iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“O ta a bobaituw sheep etei 100 hitama’am, naatu ta’imon takakasiy boro mi’itube itasinaf? A bobaituw 99 boro raiyarayar yan dihamiyih hitama, naatu a sheep kakasiy boro itanunuwih itatita’uribo nuhi tafot. ");
INSERT INTO aai_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Naatu itabaib ana veya boro itiyasisir gagamin maiyow, ita’abar itan. ");
INSERT INTO aai_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A bar taituwa, a ofonah etei ita’af ayuwih hai tur ita’owen, ‘Kwana bairit taniyasisir, anayabin ayu au sheep kakasiy i abaika.’ ");
INSERT INTO aai_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A tur ao’owen, ef i nati na’atube, orot ta’imon bowabow kakafinane dogor baikitabir ebaib isan maramaim i tibiyasisir gagamin maiyow, men sabuw 99 gewas hirouw kakafih auman tema’am na’atube’emih. ");
INSERT INTO aai_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Itinin tabo iti na’atube, babin ana kabay ten kina ana fofonin yai inu’in one kina kasiy, naatu babin notanot men karam misir ramef ito’ab bar wanawanan yahib, huhun etei nuwet inan ana kabay tita’ur. ");
INSERT INTO aai_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Naatu ana kabay baib ana veya ana ofonah naatu tain tuwan etei e’af ayuwih eo, ‘Kwanan bairit taniyasisir, anayabin au kabay kakasiy i abaika.’ ");
INSERT INTO aai_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Imih a tur ao’owen, ef i nati na’atube, God ana tounamatar maramaim orot ta’imon bowabow kakafin wairafin ana kakafihine dogor baikitabir baib isan boro yasisir gagamin na’in hinab.” ");
INSERT INTO aai_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu iban maiye oroubon ta eo, “Ana veya ta orot natunatun rou’ab bairi hima’am. ");
INSERT INTO aai_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Natun uf misir tamah isan eo, ‘Tamai ayu akokok au nowau sawar inakusib initu.’ Tamah misir sawar etei bai natunatun hairi isah ana fofonin kusib faramih. ");
INSERT INTO aai_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Naatu veya bai’ab na’atube sasawar ufunamaim kek uf ana sawar bobuna misir tafaram ta ef yok na’in imaim remor in. Naatu nati’imaim ma ana kabay etei asir isaroun kwanikwaniy sawar. ");
INSERT INTO aai_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ana kabay isaroun kwanikwaniy in sasawar ufunamaim, baimar kakafin nati tafaramamaim tit, kek busuruf aa morob. ");
INSERT INTO aai_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naatu misir in nati’imaim tafaram matuwan orot ta biyan tit, naatu nati orot bai iyafar in for baibituw ana efanamaim tit ma for ituw. ");
INSERT INTO aai_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aa morob kok kwanekwan for hai bay hi’aa turih taa, baise men yait ta abisa itin eaanimih. ");
INSERT INTO aai_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Veya ta ma binotanot ana notamaim nuhin taseb eo, ‘Tamai ana bowayah moumurih na’in i aurih bay karam hi’aa hitom yah iw tema’am, baise ayu iti’imaim aa amomorob. ");
INSERT INTO aai_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gewasin ayu boro ana misir anan tamai biyan anatit ana tur ana’owen anao. Tamai ayu i bowabow kakafin maiyow asinaf God matanamaim, naatu o auman matamaim. ");
INSERT INTO aai_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Isan imih ayu i men karam boro o natumih inabuwu maiye, baise a bowayah sabuw ibaiyanih isa tebowabow na’atube ayu isou inasinaf.’ ");
INSERT INTO aai_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iti na’atube eo, basit misir tamah isan matabir maiye remor na bar ariyan titit auman, tamah bat nuwanuw natun nan itin, dogoron wanawanan yababan awan karatan, nunuw in natun bai rouh mamay. ");
INSERT INTO aai_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Baise kek eo, ‘Tamai ayu i bowabow kakafin maiyow God isan asinaf kakaf na’atube o isa asinaf kakaf, isan imih ayu i men karam o natumih inabuwu.’ ");
INSERT INTO aai_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Baise regah ana bowayah iuwih eo, ‘Saise kwan faifuw boubun gewasin kwabai natu kwai’us, uman ring kwaiyoun naatu a baibiyon boubun kwabai kwana an kwaiyoun. ");
INSERT INTO aai_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naatu for biyan kabinitut kwarab kwaitab tana’aan taniyasisir. ");
INSERT INTO aai_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Anayabin ayu natu i morob na’atube ma’am, boun i yawas maiye, naatu kasiy na’atube ma’am boun i tatita’ur maiye.’ Naatu douduf hitaiy re. ");
INSERT INTO aai_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Baise nati ana veya’amaim regah natun ain ma sheep kakaifen matabir na bar biyubin auman hiyasisir hibenaben douduf nidun nowar. ");
INSERT INTO aai_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naatu bowayah orot ta eaf na ibatiy, ‘Abisa emamatar?’ ");
INSERT INTO aai_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Orot eo, ‘O tai matabir maiye na bar tit, imih tamat for biyan kabinitut rab abiyasisir, anayabin gewasinamaim matabir maiye na bar tamat biyan tit.’ ");
INSERT INTO aai_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Basit orot ain yan so’ar kwanekwan, men kok boro bar wanawanan tarun. Naatu tamah tit natun ain eobaibinub runamih iu. ");
INSERT INTO aai_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Baise orot ain eo, ‘Tamai kwamur manin maiyow akirwairafih na’atube isa abow men kafa’imo fana asair. Naatu au yasisir isan abisa itu? En anababatun! Men kafa’imo goat ta itu au ofonah bairi ai yasisiramih. Aiyab! ");
INSERT INTO aai_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Baise o natu kabay etei baibin baiwa’an kwanekwaneyah biyahimaim isaroun kwanikwaniy sawar, naatu matabir na bar titit, o isan for biyan kabinitut irab kwabiyasisir.’ ");
INSERT INTO aai_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Regah natun ain iya’afut eo, ‘Natu o i airit mar etei iti’imaim tama’am, naatu ayu au sawar tutufin etei iti baremaim tema’am i o nowa, men yait ta nowanamih. ");
INSERT INTO aai_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Baise tanaben taniyasisir, anayabin tai morobobe yumatan taboyauw tama’am boun yawas maiye, naatu kasiyobe ma’am boun tatita’ur maiye.’” ");
INSERT INTO aai_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu ana bai’ufununayah iuwih eo, “Ana veya ta orot guguw wairafin ana bowayan orot ukwarin sawar kakaifen kakaf isan ana tur nowar. ");
INSERT INTO aai_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Basit orot ukwarin eaf na ibatiy, ‘O a bowabow isan tur anonowar i men gewasin. Ayu akokok a bowabow isan inao gewas ananowar? O a bowabowamaim i esasawar.’ ");
INSERT INTO aai_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ana bowayan orot ukwarin ma binotanot eo, ‘Ayu au regah i au bowabowamaim ebobotaitu, ayu men fairu boro me anakwair anatar, naatu fefeyan isan boro biyau na’ohow. ");
INSERT INTO aai_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Baise aso’ob boro sawar ta anasinaf, saise au bowabow nasawar anatitit au ofonah afa boro au merar hinay hinabuwu bairi anama.’ ");
INSERT INTO aai_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Basit akirwairafih iyabowat orot guguw wairafin ana sawar hibow imaim hima hibowabow eaf hina, orot ta wan run ibatiy, ‘O au regah ana sawar bai’ab kubobotan boro inibaiyan?’ ");
INSERT INTO aai_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akirwairafin iya’afut eo, ‘Olive iroro’on ana momon etei 3,000 litres ana fofonin kibub wanawanan ebatabat.’ Orot ukwarin fef itin eo, ‘Kumare kibub wanawanan iroro’on 1,500 litres ana fofonin kukirum.’ ");
INSERT INTO aai_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Orot bairou’abin ibatiy, ‘O au regah ana sawar bai’ab kubobotan boro inibaiyan?’ Akirwairafin iya’afut eo, ‘35,000 litres ana fofonin rafiy abobotan.’ Fef itin eo, ‘Kumare 17,500 kukirum.’ ");
INSERT INTO aai_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Naatu orot guguw wairafin orot ana sawar kaifenayan kirum bisawar ufunamaim ana bowabow i’itin ana maramaim ana merar yi bora’ara’ah. Anayabin sabuw iyab iti tafaram nowan i hai not rerekabin nati na’atube hikirum hifufuwen o tur maiyow kurarouw, baise marakaw ana sabuw men nati na’atube tesisinaf. ");
INSERT INTO aai_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Naatu a tur ao’owen, tafaram ana sawaramaim sabuw kwanibaisih bairi kwani’of, saise nati sawar o biyamaim nabi’en ana veya maramaim boro a merar hinay hinabuwi bairi kwanama. ");
INSERT INTO aai_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Orot yait sawar gidigidih hitumitum hibitin ekakaifen gewas, sawar gagamih auman boro hinitin nakaifen gewas, naatu orot yait sawar gidigidih hibitin men ekakaifen gewas, sawar gagamih auman boro men nakaifen gewas. ");
INSERT INTO aai_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Imih o iti tafaram ana sawar hitutumi hibit men kukakaifen gewas, mar ana sawar gewasih hinabit boro men inakaifen gewasomih. ");
INSERT INTO aai_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sabuw afa hai sawar o hitutumi hibit men kukakaifen gewas, o a sawar hinabit boro mi’itube inakaif gewas? ");
INSERT INTO aai_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bowayan orot ta’imon men karam boro orot gagamih rou’ab isah nabow, baise nakok bowamih orot ta nab naatu ta nihamiy, o orot ta isan nisnubanub naatu ta isan niskwarakwarab. O men karam boro God naatu Kabay hairi isah inabow.” ");
INSERT INTO aai_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee Jesu eo hima hinonowar himisir Jesu hi’i’iyab himarib, anayabin i kabay hai momorob. ");
INSERT INTO aai_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu misir iuwih eo, “Kwa sabuw matahimaim kwasisinaf gewas saise sabuw iti orot gewas rauwamih, baise God kwa dogor wanawanan etei i nuwatet sawar. Anayabin sawar nati na’atube sabuw hi’itah gagamih hirouw teora’ara’at, God matanamaim nati sawar i hai yabih en. ");
INSERT INTO aai_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses ana ofafar naatu dinab oro’orot hai tur imaim hibinan hinan John Baptist ana veya’amaim tit. Baise boun i Tur Gewasin God ana aiwob isan hibusuruf tibibinan, naatu sabuw moumurih na’in hisinaftobon hibusuruf tirur. ");
INSERT INTO aai_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mar tafaram hairi i hamehamen maiyow boro sahiniwa’an, baise ofafar Buk Atamaninamaim hikikirum ana kouk yowanen kikimin ta boro men hinakusa’ir. ");
INSERT INTO aai_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Orot yait aawan nakwahir, babin ta nabi’aawan i ana moser takweb, naatu orot yait nati babin hikwahir ma’am bai ebi’aawan i auman ana moser takweb. ");
INSERT INTO aai_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Marasika orot ta sawar wairafin ma’am ana veya, ana sawar etei gewasih, ana bar tot samir wanawanan ma mar etei hiyuw bow nan douduf in re’er. ");
INSERT INTO aai_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naatu ana bar ufunane fur awanamaim i orot wabin Lazarus, yababan wairafin biyan fehefeheriy, mar etei nati’imaim teyare ema efefeyan. ");
INSERT INTO aai_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana kok i mi’itube orot ana bay taa momor gem babanamaim hitare’er i tabow taa, bi’akir naatu haru auman tena ana feher teremarem. ");
INSERT INTO aai_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Basit veya ta orot yababan wairafin morob tounamatar hire hinawiy hin maramaim Abraham biyasisir biyan hitit sisibinamaim mare. Naatu orot sawar wairafin morob hibai hire hiyai. ");
INSERT INTO aai_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ayubin in wairaf wanatowanin wan yen biyababan gagamin maiyow bai, nuwra’at no yate ef yok na’in Abraham itin, sisibinamaim Lazarus batabat. ");
INSERT INTO aai_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Basit eaf ra’at, ‘Tamai Abraham! Ayu wairaf e’arahu biyababan gagamin na’in abaib, kukabibiru Lazarus kwiyafar uman harew yan eotore menau inub, menau tobeya!’ ");
INSERT INTO aai_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Baise Abraham eo, ‘Natu inanot o tafaramamaim ima’am ana veya, sawar gewasih etei o isa karam. Lazarus ana sawar i kakafih. Baise boun i Lazarus ana veya tit ebiyasisir naatu o ayababan ana veya tit kubiyababan. ");
INSERT INTO aai_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naatu ata founamaim i ku’itin, fan gagamin na’in inu’in, imih sabuw iyab aki biyai’ine boro men karam o isa hinarabon, na’atube o biyane aki isai men karam boro hinarabon.’ ");
INSERT INTO aai_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Basit orot sawar wairafin eo, ‘Tamai Abraham abifefeyani, Lazarus iniyafar nan tamai ana bar natit. ");
INSERT INTO aai_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anayabin nati’imaim ayu taitu nah etei five tema’am nimatnuwih, saise i auman men hinan iti biyababan ana efanamaim hinatit biyah nababanamih.’ ");
INSERT INTO aai_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Baise Abraham iya’afut eo, ‘Tait i Moses ema’am naatu dinab oro’orot tema’am, boro i hinimatnuwih naatu abisa hinao’o, nowar hina kok tur hinanowar.’ ");
INSERT INTO aai_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Orot sawar wairafin iya’afut eo, ‘Tamai Abraham, nati i men karam, baise ana gewasin orot ta morobone namatabir maiye nan hai tur na’owen boro hai bowabow kakafih tisisinaf hinihamiyen hina’in tabir yawas gewasin hinab.’ ");
INSERT INTO aai_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Baise Abraham iya’afut maiye eo. ‘Moses naatu dinab oro’orot hinao men hinanowar hai yawas hinabobotabir na’at, orot morobone nan nao boro men hai yawas hinabotabir.’” ");
INSERT INTO aai_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu ana bai’ufununayah iuwih eo, “Bowabow kakafin ana routobon i turobe boro hinamatar, baise orot yait iti sawar niwa’an hinamamatar boro yababan gagamin na’in nab. ");
INSERT INTO aai_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Naatu orot yait nati na’atube nasisinaf, ana gewasin nati orot boro sikan aumor hina’utan taiy yan hinitaiy nare, men basit nama au kek gidigidih niwawa’anih bowabow kakafih hinasinaf. ");
INSERT INTO aai_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Imih abisa kwasisinaf mata toniwa’an, taituwa baitumatumayan bowabow kakafin nasisinaf na’at, inakwarar tatab nihamiy, naatu bowabow kakafin nihamiyen dogoron nabikitabir na’at ana bowabow kakafih inanot tawiyen. ");
INSERT INTO aai_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Naatu veya ta’imon wanawanan mar etei seven na’atube o isa nasisinaf kakaf isan, mar etei seven namatabir maiye nan biya natit nao. Ayu o isa bowabow kakafin asinaf, ana bowabow kakafih inanot tawiyen. ");
INSERT INTO aai_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tur Abarayah Jesu isan hio, “Regah ai baitumatum kwira’at.” ");
INSERT INTO aai_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Regah iyafutih eo, “Kwa a baitumatum ai momor ro’on na’atube, kwa boro iti ai uwa isan kwanao, ‘A wairoron etei ku’uy ra’ah kwen tor yan kure kubat,’ boro fana nab kwao na’atube nasinaf. ");
INSERT INTO aai_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Naatu itinin ta i iti na’atube, o ta a bowayan orot masaw tabowabow o sheep takakaifen rabirab au bar tanan, boro men ana merar itay naatu itau, ‘Kurun kumare bay ta ku’aan.’ ");
INSERT INTO aai_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ai’abin, o boro mat a bay tabogaigiwas itaa, imaibo i tamare taa tatom. ");
INSERT INTO aai_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Naatu a bowayan orot iyun sisinaf isan i boro men o ana merar yin isan tama takaifimih en. ");
INSERT INTO aai_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imih kwa auman ef i nati ta’imon, abisa bowamih hinao hiyuni kwa bowabow ufunamaim, kwa na’atumo kwanao, ‘It i akirwairafit wabit men gagamin aisim merarayow isan tananot, abisa hi’u’uwit na’atube tasinafuka.’” ");
INSERT INTO aai_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu au Jerusalem yey ana veya i tafaram Samaria naatu Galilee hairi hai yoyow ana founamaim yen in. ");
INSERT INTO aai_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naatu na bar merar ta titit auman, orot nah etei 10 biyah kokom ani’anih bairi hitar. Ef yok na’in hibat ");
INSERT INTO aai_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","naatu hi’af hio, “Regah Jesu kwiwanbabani!” ");
INSERT INTO aai_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu nuw itih, basit iuwih eo, “Kwan firis biyan kwatit naatu biya enuteteyan itah.” Baise hitit efamaim hinan, biyah etei higewasin. ");
INSERT INTO aai_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Naatu wanawanahimaim orot ta’imon biyan bigewasin itin, basit matabir maiye fanan sib God bora’ara’ah auman na. ");
INSERT INTO aai_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesu nanamaim me yan ra’iy ana merar yi. Naatu iti orot i Samaria matuwan. ");
INSERT INTO aai_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naatu Jesu eo, “Orot nah etei i ten biyah higewasin, naatu orot nah nine i menamaim tema’am? ");
INSERT INTO aai_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aisim iti orot menan ta akisinamo na God ana merar eyiy?” Naatu Israel sabuw aisim boro men iti na’atube hitasinaf? ");
INSERT INTO aai_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Imaibo Jesu orot iu eo, “Kumisir au bar kwen, a baitumatumamaim iyawas.” ");
INSERT INTO aai_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee afa Jesu hibatiy hio, “God ana aiwob i boro mar biy nan?” Jesu iyafutih eo, “God ana aiwob i men bebeyanamaim enan, ");
INSERT INTO aai_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","boro sabuw hina’itin hinao, ‘Kwa’itin iban iti, o iban ni’i.’ Anayabin God ana aiwob i kwa wanawanamaim ema’am.” ");
INSERT INTO aai_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Imaibo ana bai’ufununayah iuwih eo, “Mar enan kwa boro kwanakaibaban kwanao, ‘Orot Natun ana veya mi’itube tanan tata’itin,’ baise nati ana veya boro men kwana’itinimih. ");
INSERT INTO aai_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sabuw boro hina’uwi hinao, ‘I ban ni’i enan kwa’itin, o iti enan kwa’itin.’ Sabuw hinao men ufuh kwananunuwamih. ");
INSERT INTO aai_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anayabin Orot Natun namatabir maiye nanan ana veya, tafaram wanawanan ana’itin i boro namanamar ebow tafaram etei emamarakaw na’atube boro namarakaw. ");
INSERT INTO aai_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Baise wantoro’ot i boro sabuw iyab iti boun tema’am ana veya’amaim boro hinab hini’a’akir, hinakwahir biyababan ta ta hinitin. ");
INSERT INTO aai_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ana itinin i boro Noah ana veya’amaim mamatar na’atube, Orot Natun ana veya’amaim boro na’atube namatar. ");
INSERT INTO aai_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah ana veya’amaim sabuw hi’aa hitomatom, orot babin hitatabin, wanawanan Noah wa wanawanan run harew gagamin tit sabuw etei himorob. ");
INSERT INTO aai_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naatu ana itinin ta i Lot ana veya’amaim mamatar na’atube. Orot babin hi’aa hitom, masaw hitar hibow, bar hiwowab, hitobon hi’aa hinan wanawanan ");
INSERT INTO aai_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot tafaram Sodom bihamiy ana veya wairaf marane God iyafar re sabuw etei e’arahih himorob.” ");
INSERT INTO aai_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ana itinin i ta’imon, Orot Natun nanan ana veya boro nati na’atube namatar. ");
INSERT INTO aai_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nati ana veya’amaim orot yait ana or ema’am boro men nayen bar ana sawar nabow, na’atube orot ana masaw ebow boro men namatabir bar sawar nabowamih. ");
INSERT INTO aai_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Orot Lot aawan isan abisa namatar i kwananot! ");
INSERT INTO aai_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Orot yait i taiyuwin ana yawas enunuwih boro men nabaimih, baise orot yait ana yawas ayu isou kwakwahir ana yawas boro natita’ur nab. ");
INSERT INTO aai_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A tur ao’owen, nati ana guguminamaim, orot rou’ab boro gem ta’imon tafan hina inu’in, orot ta boro hina bora’ah, ta boro gem tafan hinihamiy na’in. ");
INSERT INTO aai_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Baibin rou’ab boro hinama maiwok hinakakair, babin ta boro hina bora’ah ta boro hinihamiy nama. ");
INSERT INTO aai_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Orot rou’ab boro hinama masaw hinabob, orot ta boro hina bora’ah, ta boro masaw yan hinihamiy nama.” ");
INSERT INTO aai_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ana bai’ufununayah hibatiy hio, “Regah iti boro menamaim namatar?” Jesu iyafutih eo, “Efan menamaim murumurubih biyah ti’inu’in mamu ikou boro imaim hinaru’ay.” ");
INSERT INTO aai_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu bai’obaiyen ta oroubonamaim ana bai’ufununayah i’obaiyih eo, “Mar etei kwanayoyoyoban, men guban nahurir yoyoban kwanihamiyimih.” ");
INSERT INTO aai_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Veya ta bar merar gagamin ta’amaim tur nowarayan orot ta nati’imaim ma’am, i men kafa’imo God isan birubir naatu orot babin isah birubirumih. ");
INSERT INTO aai_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nati bar meraramaim i kwafur babin auman ma’am. Nati babin mar etei tur nowarayan orot ifefeyan eo, ‘Ayu akokok inibaisu au kamabiy wairafin airi kwanao ayu ana ma gewas.’ ");
INSERT INTO aai_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Veya moumurih maiyow orot iti babin ana fefeyan nonowar men kafa’imo abisa ta sinafumih. Baise yomaninamaim taiyuwin ma binotanot eo, ‘Ayu i men God abibiruw naatu orot babin men akakafiyih. ");
INSERT INTO aai_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Baise iti babin i mar etei isau enan, gewasin babin i boro anibais nama gewas, saise men mar etei nan ayu nihaharu’umih.’” ");
INSERT INTO aai_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naatu Regah Jesu eo, “Tur nowarayan orot kakafin ana tur kwanowar. ");
INSERT INTO aai_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naatu kwanotanot God ana roubinen sabuw fai mar isan hinarererey boro men na’itin nibaisih hinama gewas? Naatu baibaisih isan boro nama narubirabir? ");
INSERT INTO aai_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Baise a tur ao’owen, God i boro hai yababan na’itin naatu boro matan nakabiy nasinaf. Baise Orot Natun namatabir maiye nanan ana veya, tafaramamaim boro sabuw baitumatumayah natita’urih.” ");
INSERT INTO aai_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sabuw afa taiyuwih tebora’ahih gewasih terouw, taih tuwah tinunufuruwih isan, Jesu oroubonamaim eo. ");
INSERT INTO aai_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ana veya ta orot rou’ab hitit hin Tafaror Baremaim yoyoban isan, orot ta i Pharisee, naatu orot ta i kabay o’onayan. ");
INSERT INTO aai_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee orot akisin nabin bat yoyoban eo, ‘God a merar ayiy gagamin maiyow, anayabin ayu i men sabuw afa na’atube’emih, ayu men kabat mowan, men baifufuwenayan, men bainowan mowan, men taituwau a’aawah ufuh a nan, naatu ayu i men iti kabay o’onayan na’atube. ");
INSERT INTO aai_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fur ta’imon wanawanan mar rou’ab ayoyohar naatu au kabay abaib roumukur etei o a siwar abit ofafaramaim eo na’atube.’ ");
INSERT INTO aai_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Baise kabay o’onayan akisin babanane bat, uwan yi dogoron rab yoyoban eo, ‘God kwiwanbabanu, ayu bowabow kakafin wairafu.’ ");
INSERT INTO aai_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A tur ao’owen, orot rou’ab yoyoban ufunamaim au bar hinan kabay o’onayan God matanamaim i roumutufuren bai yasisiramaim ana ubar in, men Pharisee. Anayabin orot yait taiyuwin ebobora’ah God boro nab nayare, baise orot babin yait taiyuwin eyayare God boro nayara’ah orot gagamin namatar.” ");
INSERT INTO aai_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sabuw afa natunatuh Jesu baigegewasinih isan hibow hina biyan hititit, ana bai’ufununayah hi’itih, sabuw higam hi’uwih. ");
INSERT INTO aai_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Baise Jesu kek eafih hina biyan hitit naatu eo, “Kek kwaihamiyih tena biyou titit, men kwanao tanihimih, anayabin sabuw iyab dogoroh iti kek gidigidih na’atube God ana aiwobomaim boro hinarun. ");
INSERT INTO aai_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A tur ao’owen, orot yait nayare iti kek na’atube God ana aiwobomaim boro narun.” ");
INSERT INTO aai_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jew sabuw hai bonawiyenayan orot ta Jesu ibatiy, “Bai’obaiyenayan Gewas, kuo anowar, abisa anasinaf boro yawas ma’ama wanatowan anab.” ");
INSERT INTO aai_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu iya’afut eo, “O aisim ayu orot gewasu irouw kuo’o? Men yait ta gewasinamih, baise God akisinamo i gewasin. ");
INSERT INTO aai_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ofafar etei Moses ana Bukamaim kikirum iso’ob? ’Taituwa a’aawah ufuh men inan, men sabuw ina’asbunuw, men inabain, men inifufuwen, men inayanuw, naatu hinat tamat fanah inabosiyasiyar.’” ");
INSERT INTO aai_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Orot iya’afut eo, “Ayu kek ana veya’ika abusuruf iti ofafar etei ai’ufnunen, men ta astu’ubimih.” ");
INSERT INTO aai_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu nonowar ufunamaim eo, “Sawar ta’imonamo men isinafumih. Inan sawar etei inabow sabuw hinatobon naatu kabay yababan wairafih inafaramih. Imaibo inan ayu ni’ufnunu, saise maramaim o boro totobuyoy wairaf inamatar.” ");
INSERT INTO aai_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Baise orot iti tur nonowar ana maramaim ana yababan ra’at, anayabin i totobuyoy wairafin. ");
INSERT INTO aai_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu iti orot biyababan itin basit eo, “Sabuw iyab totobuyoy wairafih maramaim run isan boro isah nafokar. ");
INSERT INTO aai_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sinak ana sou awan kikimin camel imaim boro karam nasorabon, baise orot totobuyoy wairafin God ana aiwobomaim run isan boro men karam narun.” ");
INSERT INTO aai_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sabuw iti tur hinonowar hio, “Orot yait i boro yawas natita’ur?” ");
INSERT INTO aai_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu iyafutih eo, “Sabuw isah i fokar, baise God isan i hamehamen maiyow.” ");
INSERT INTO aai_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Imaibo Peter, Regah isan eo, “Aki ai bar ai tumar o abi’ufnuni ku’itin.” ");
INSERT INTO aai_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu iuwih eo, “Anababatun a tur ao’owen, orot yait ana bar, aawan, natunatun, taintuwan, hinah tamah, ihamiyen God ana aiwob isan i’akir ebowabow ");
INSERT INTO aai_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","boro sawar moumurih na’in iti tafaramamaim tafan hinaya’abar nabow naatu yawas mar boro enan ma’ama wanatowan boro nab.” ");
INSERT INTO aai_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu ana tur abarayah nah 12 buwih nabinamaim iuwih eo, “Kwananowar! It i au Jerusalem tayey, naatu nati’imaim dinab oro’orot Orot Natun isan abisa mataramih hio hikikirum boro imaim yabin namatar. ");
INSERT INTO aai_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nati’imaim i boro hinab Eteni Sabuw umahimaim hinayai, hinab hini’i’iyab, hinigigim, hinakwaitututur, hinawabir naatu hina’asabun namorob. ");
INSERT INTO aai_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baise veya tounu ufunamaim boro nayawas maiye namisir.” ");
INSERT INTO aai_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Naatu bai’ufununayah Jesu abisa eo men kafa’imo tur naniyan hibai hinotaboun. Anayabin kawen turamaim eo naniyan bain isan fokar. ");
INSERT INTO aai_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu yena Jericho biyubin auman orot ta matan fim nati ef yanamaim ma fefefeyan. ");
INSERT INTO aai_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sabuw hinan fanah nowar, basit ibatiyih, “Abisa matar kwa’i’itin?” ");
INSERT INTO aai_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Sabuw hiya’afut hio, “Jesu Nazareth matuwan enan.” ");
INSERT INTO aai_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Basit orot matan fim erererey auman eaf eo, “Jesu David ana’agir kwiwanbabanu.” ");
INSERT INTO aai_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sabuw wan hi’iyon hinan hitatabir orot hikwarar tatab awan fotamih hio. Baise orot matan fim fan sib aumetawat na’in eaf eo, “David ana agir kwiwanbabanu!” ");
INSERT INTO aai_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Basit Jesu nutanub bat naatu eo, “Orot kwabai kwana aitin.” Orot hibai hina Jesu biyan hitit, Jesu orot ibatiy. ");
INSERT INTO aai_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Abisa kukokok isa anasinaf?” Orot iya’afut eo, “Regah ayu akokok matau nigewasin ana nuw maiye.” ");
INSERT INTO aai_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Basit Jesu orot iu, “Mata igewasin kunuw, abaitumatumamaim ebiyawasi.” ");
INSERT INTO aai_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mar ta’imonamo orot matan igewasin nuw naatu God ana merar yi bora’ara’ah auman Jesu i’ufunun hairi hin. Naatu abisa matar sabuw hi’itin ana maramaim God ana merar hiyi wabin hibora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu na Jericho tit naatu nati bar merar wanawanan remor inan, ");
INSERT INTO aai_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","basit nati’imaim orot totobuyoy wairafin wabin Zakias, kabay o’onayah hai orot ukwarin ma’am tit. ");
INSERT INTO aai_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kok kwanekwan Jesu ana yumat ta’itin, baise i orot kabumin sabuw rou’ay gagamin na’in nan hisumisum i men karam boro Jesu ta’itin. ");
INSERT INTO aai_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naatu sabuw aunah i’iyon nunuw in ai sycamore afe’en yen mare ma Jesu nan ta’itinimih, anayabin Jesu ef nati’iwat inan. ");
INSERT INTO aai_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Baise Jesu na nati ai anamaim titit ana veya an kutan bat, naatu ai afe’en nuw ra’at eo, “Zakias saise kura’iy, anayabin ayu akokok boun o abaremaim airit tanama.” ");
INSERT INTO aai_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakias matan kabiy kayam rena haw tit, kawasa auman Jesu ana merar yi ");
INSERT INTO aai_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sabuw etei’imak hi’i’itin men hiyasisir naatu higam hio, “Iti orot i bowabow kakafin wairafin ana nanawan orotomih matar hairi tenan ana bar.” ");
INSERT INTO aai_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakias misir eo, “Regah ayu i boro au sawar founafoun ana kuru’um turin yababan wairafih anitih, naatu sabuw iyab aifufuwih hai sawar abowabow boro hai sawar tafanamaim matah kwakwafe’en auman anaya’abar anitih.” ");
INSERT INTO aai_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu misir Zakias iu, “Boun iti baremaim God ana yawas natit orot ebiyawasi, anayabin iti orot auman i Abraham uwan ta. ");
INSERT INTO aai_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Orot Natun i sabuw iyab hikasiy tema’am nuwihih bow naatu baiyawasih isan na.” ");
INSERT INTO aai_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesu na Jerusalem tit biyubin auman, sabuw abisa Jesu eo hinowar hinan hinotanot i God ana aiwob iti boro’omo tatit ana naniyanabe, baise Jesu i kofan maiye oroubonamaim iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ana veya ta orot gagamin tafaram ta’amaim roubinin aiwob baitin, imaibo matabir maiye isan in tafaram ta ef yok na’in imaim tit. ");
INSERT INTO aai_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Baise na isan bobobunabuna ana veya, ana akirwairafih etei 10 e’af hina gold taita’imon faramih naatu iuwih. ‘Kabay iti abit kwanab, imaim kwanama kwanabowabow ayu ana matabir.’ ");
INSERT INTO aai_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Baise i taiyuwin ana tafaram sabuw hifa’ifai naatu men hikok nati orot ti’aiwob, imih sabuw hiyafarih hin hitit hio, ‘Aki men akokok iti orot aki isai ni’aiwob.’ ");
INSERT INTO aai_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Baise nati orot aiwob hitin naatu matabir na ana bar tit. Imaibo ana akirwairafih iyab kabay bitih hina hitit ibatiyih, kok taso’ob, kabay itih hibowabow baibi’ab tafan hiya’abar hibow. ");
INSERT INTO aai_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Orot ta wan run eo, “Regah ayu au kabay itu ama abowabow tafan i ten hiya’abar abai.’ ");
INSERT INTO aai_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ana regah eo, ‘O i bowayan orot gewas, au bowabow kikimin abit ikaif gewas, imih bar merar etei ten abit inakaifen.’ ");
INSERT INTO aai_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Orot bairou’abin run eo, ‘Regah ayu kabay itu ama abowabow tafan etei five aya’abar abai.’ ");
INSERT INTO aai_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naatu ana orot ukwarin iyasisir eo, ‘O i bar merar etei five abit inakaifen.’ ");
INSERT INTO aai_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Naatu orot baitounin run eo, ‘Regah a kabay ibitu i abai an koukufet wanawanan asum ai boun inu’in iti abai ana abit maiye. ");
INSERT INTO aai_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ayu o isa abir, anayabin o a tur fokarin, turanah arih o aribe asir kubowabow kwanekwan, naatu turanah hai masaw o kubobobe asir kufafour kwanekwan.’ ");
INSERT INTO aai_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Regah misir iu, ‘O i bowayan orot kakaf nokonokow! Nati a tur i’o’omaim boro natatabir nafatumi! O iso’ob ayu i au tur fokarin, sabuw hai sawar abowabow kwanekwan, naatu hai masaw ayu abobobe afafour. ");
INSERT INTO aai_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Gewasin au kabay banikamaim itayai tabowabow amatabir anan saise tafan hitaya’abar atab.’ ");
INSERT INTO aai_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naatu tatabir sabuw nati’imaim hibatabat iuwih, ‘Iti orot uman kabay gold kwabosair kwabai kwan akir wairafin kabay etei ten bowabow i kwaitin. ");
INSERT INTO aai_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Baise hitatabir hio, ‘Regah nati orot i ana kabay etei ten bowaka.’ ");
INSERT INTO aai_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Iyafutih eo, ‘A tur ao’owen, sabuw iyab umah i’e’etaw sawar moumurih tebowabow boro tafan hinaya’abar nab, baise sabuw iyab umah nutanub tema’am aurin boro sawar en, naatu abisa kikimin nati biyahimaim tema’am boro hinabosairen. ");
INSERT INTO aai_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naatu boun i akokok sabuw iyab ayu bai’aiwob isan men hikokok kwabow kwana iti nou’umaim kwarouw temorob.” ");
INSERT INTO aai_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iti na’at eo ufunamaim sabuw au nah i’iyon, wan au Jerusalem yen in. ");
INSERT INTO aai_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yen na tafaram Bethage naatu Bethany hairi sisibihimaim tit, Olive Oyaw an, basit ana bai’ufununayah orot rou’ab eobaimanih naatu wan iyafarih ");
INSERT INTO aai_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","eo, “Kwanan bar merar ta nati namaim kwanatit naatu kwanarur auman donkey boubun hi’utan ebatabat boro kwana’itih, nati donkey i men yait ta bai afe’en yen remoramih. Kwana rufam kwanab kwan iti kwanatit. ");
INSERT INTO aai_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Naatu orot ta nati’imaim na’iti nibatiy nao, ‘Aisim kwarurufam?’ ana tur kwana’owen, ‘Ai Regah ekokok.’” ");
INSERT INTO aai_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Orot hairi hiremor hin, sawar abisa Jesu eo na’atube etei isah himatar. ");
INSERT INTO aai_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hina hitit donkey boubun hirurufam, ana matuwan itih naatu ibatiyih, “Aisim au donkey kwarurufam?” ");
INSERT INTO aai_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hiya’afut hio, “Ai Regah ekokok.” ");
INSERT INTO aai_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Basit ihamiyih hirufam hibai hin Jesu biyan hitit, naatu hai biya baibiyon tafah hibosaisiren donkey tafan hiyabar uman hibai yen tafan mare. ");
INSERT INTO aai_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sabuw hai faifuw tafah hibosaisiren ef yan hiyabar tafanamaim remor in. ");
INSERT INTO aai_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na Jerusalem tit biyubin auman, ef ta Olive Oyaw na’at re inan i awanamaim hitit naatu ana bai’ufununayah sabuw moumurih na’in Jesu ina’inan iwa’an hi’itah isan fanah sib God ana merar hiyi hibora’ara’ah hio. ");
INSERT INTO aai_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“God ata aiwob nigegewasin, Regah wabinamaim nan, tufuw maramaim nama naatu God auyomtoro’ot isan fair nama!” ");
INSERT INTO aai_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pharisee afa nati rou’ay wanawanamaim Jesu hiu, “Bai’obaiyenayah, a bai’ufununayah kukwararih awah tefot.” ");
INSERT INTO aai_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Baise Jesu iyafutih eo, “I ana’uwih awah nafot, kabay iti ti’inu’in boro fanah nasib God hinabora’ara’ah.” ");
INSERT INTO aai_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesu na Jerusalem tit iyubin nuw bar hiwowab batabat i’itin ana veya ana yababan ra’at rerey eo, ");
INSERT INTO aai_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Tufuwamaim ma isan ana ef iti boun enan akisin itaso’ob. Baise boro men ina’itin, anayabin mata hibofafar. ");
INSERT INTO aai_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mar boro enan a rakit sabuw boro roun roun hina’ar bebera’uh a ef hinarufut, run tit isan boro nafokar, ");
INSERT INTO aai_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","hinabat hinayuw hinarab, hinagurus, natunatun wanawanamaim tema’am etei boro hinarouw hinamorob. kabay iti etei boro hinarab hinagurus nasawar, boro men ta hinihamiy ana efanamaim na’inumih, anayabin God ana sabuw baiyawasihimih nan o men i’inanimih!” ");
INSERT INTO aai_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu na Tafaror Bar wanawanan run, ana was efanamaim sabuw sawar hiya hima hitotobon itih naatu nunih ufun hitit. ");
INSERT INTO aai_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iuwih eo, “Buk Atamaninamaim God iti na’atube eo hikirum, ‘Ayu au Bar i yoyoban ana bar, baise kwa kwabai kwabotabir na bainowan hai wawa’ir watu matar!’” ");
INSERT INTO aai_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nati’imaim Jesu mar etei Tafaror Baremaim ma sabuw i’obaibiyih. Baise firis ukwarih, Ofafar Bai’obaiyenayah, naatu sabuw hai ukwarih hikok kwanekwan i mi’itube hitarab temorob. ");
INSERT INTO aai_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Baise ef hinunuwet men ta hitita’urimih, anayabin sabuw etei’imak i Jesu ana tur akisin hinonowar naatu men hikok boro tur ta hitasa’ir. ");
INSERT INTO aai_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Veya ta Jesu in Tafaror Bar run ma sabuw i’obaiyih Tur Gewasin binan hima hinonowar, basit firis ukwarih, ofafar bai’obaiyenayah naatu regaregah ai’in bairi hina ");
INSERT INTO aai_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesu hibatiy. “Kuo anowar, a fair menane ibai iti bowabow kusisinaf? Naatu iti fair i yait it?” ");
INSERT INTO aai_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu iyafutih eo, “Bo ayu’ubo kwa abibatiyi. ");
INSERT INTO aai_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John fair i menane bai sabuw bapataito itih, God biyanane ai sabuw biyahine? Kwao anowar.” ");
INSERT INTO aai_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baise sabuw hikasiy taiyuwih hitatabir hima hibabatiyih hio, “Mi’itube tanao? God biyanane tanao, boro nao, ‘Bo aisim John bibinan men kwaitumitum.’ ");
INSERT INTO aai_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naatu sabuw biyahine fair bain tana rouw tanao, iti sabuw rau’ay gagamin tema’am boro kabayamaim hinarabit, anayabin etei tibitumatum John i God ana dinab orot ta.” ");
INSERT INTO aai_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iti na’at hio sawar, basit hiya’afut hio, “Aki men aso’ob John ana fair menane bai.” ");
INSERT INTO aai_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Naatu Jesu iuwih eo, “Ayu auman au fair menane abai abowabow boro men anao kwananowar.” ");
INSERT INTO aai_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Naatu Jesu sabuw oroubonamaim iti na’atube eo, “Ana veya ta orot masaw bow, ana ai grape tanum naatu sabuw masaw bowayah afa tubunih hima hikaif, i ef yok bai nanawanamih in. ");
INSERT INTO aai_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Naatu grape hiw hi’inu’in hiyamur, basit bairut ana veya natit, orot ana akir wairafin ta iyafar eo, ‘Inan ai ro’oh hibirut ayu au nowau ta inab inan initu ana’aan, baise nan masaw bowayah himisir akirwairafin hibai hirab uman en hiyafar matabir. ");
INSERT INTO aai_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Naatu akir wairafin tabo iyafar maiye na tit, baise masaw bowayah hibai hirab hiu kwanikwaniy naatu hi’i’iyab uman en matabir maiye in. ");
INSERT INTO aai_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iban maiye ana aki wairafin baitounin iyafar na tit, baise masaw bowayah hibai hirab feher hitin hibai hitit ufun hisaroun re. ");
INSERT INTO aai_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Imaibo orot masaw matuwan eo, ‘Abisa boro anasinaf? Anotanot ayu natu ta’imon isan abiyabow aniyafar nan, saise i boro hina’itin hinakakafiy.’ ");
INSERT INTO aai_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Baise orot natun iyafar na titit ana veya sabuw masaw bowayah hi’itin taiyuwih himare hiyabuna sawar hio, ‘Iti i masaw matuwan natun enan, gewasin i boro tanarab namorob, saise iti sawar boro it ninowat.’ ");
INSERT INTO aai_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Basit orot natun hibai hirab masaw ana fur ufunane hitaiy re hi’asabun morob.’” Naatu Jesu sabuw ibatiyih eo, “Iti orot masaw matuwan nanan sabuw masaw bowayah isah boro mi’itube nasinaf? ");
INSERT INTO aai_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I boro sabuw nabow narouw hinamorob, naatu masaw i boro nab sabuw afa nitih hinakaif hinama.” Iti na’at eo sabuw hinonowar hio, “Iti na’at i men namatar!” ");
INSERT INTO aai_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Baise Jesu nuw sabuw itih sawar, basit eo, “Buk Atamaninamaim hikikirum anayabin i kwaso’ob. ‘Kabay gagamin bar wowabayah hi’itin kakafin hirouw hikwakwahir, baise botabir na bar ana bubu’umih matar.” ");
INSERT INTO aai_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Imih sabuw iyab iti kabay afe’en hinare nararabih boro hina taweyaweyar, baise iti kabay i tafah nare nararabih boro hinimusumus. ");
INSERT INTO aai_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ofafar bai’obaiyenayah naatu firis ukwarih hikok Jesu nati ana veya’amaim hitab hitafatum, anayabin ana oroubon eo naniyan hibaib i iuwih, baise sabuw isah hibir. ");
INSERT INTO aai_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Imih hin sabuw afa hitobon, hiyafarih ana itinin sabuw gewasih na’atube hina Jesu hibabatiy abitur tao na’at, saise Jew sabuw hitab Roman gawan hititin baimakiy titin isan ana ef hinuwet. ");
INSERT INTO aai_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Basit iti oro’orot hina Jesu hibatiy, “Bai’obaiyenayan aki aso’ob abisa o sabuw kubi’obaiyih i tur anababatun naatu ana efamaim kuo, naatu o i men sabuw ufuhine ku’i’itinimih, baise o i anababatun God ana efamaim sabuw kubi’obaiyih. ");
INSERT INTO aai_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Imih kuo anowar, Rome Ana Aiwob isan kabay tabibaiyan i ata ofafar ta’a’astu’ub ai en?” ");
INSERT INTO aai_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Baise Jesu hai baifuwen itin, naatu iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kabay kwabai kwana kwai’obaiyu aitin.” Naatu kabay hibai hitin basit ibatiyih, “Iti kabay wanawanan i yait ana yumat naatu wabin tema’am?” Hiya’afut hio, “Caesar.” ");
INSERT INTO aai_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesu iuwih eo, “Caesar nowan Caesar kwanitin naatu God nowan God kwanitin.” ");
INSERT INTO aai_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fatumin isan hai tur hibogaigiwas hina hibikubibiruw sabuw nahimaim iyafutih gewas hai kasiy ra’at, naatu men abisa hisinaf. ");
INSERT INTO aai_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nati’imaim Sadducee orot afa morob ufunamaim yawas maiye isan men tibitumatum i hina Jesu hibatiy, ");
INSERT INTO aai_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bai’obaiyenayan, Moses ofafar ta aki isai iti na’atube kirum, orot natabin nama’am aurin kek en namorob, kwafur i boro nati tain ni’awan, saise kek hinatufuw orot murubin efanin. ");
INSERT INTO aai_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Imih, marasika orot ain uf nah etei seven hima’am, basit orot ain tabin naatu aurin kek en morob. ");
INSERT INTO aai_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Naatu orot ufunamaim tuwah ana kwafur i’awan, i auman kek en morob. ");
INSERT INTO aai_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Naatu orot baitounin kwafur i’awan, kek en morob naatu orot ufi’uf kwafur hibi’awan kek en etei himorob in sawar. ");
INSERT INTO aai_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Basit uftoro’ot kwafur babin morob. ");
INSERT INTO aai_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Imih morobone hinayawas maiye hinamimisir ana veya, iti babin boro yait ni’awan, anayabin orot ain uf nah seven etei iti babin ta’imon hi’awan?” ");
INSERT INTO aai_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu iyafutih eo, “Orot babin iti tafaramamaim tema’am ana veya i tetatabin. ");
INSERT INTO aai_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Baise sabuw iyab gewasih nati efan gewasinamaim ma isan hirurubih naatu morobone misir maiye isan hirurubinih i morobone hinamimisir maiye boro men hinatabin. ");
INSERT INTO aai_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","I boro tounamatar na’atube hinama naatu men hinamorob. Nati sabuw i God natunatun na’atube hinama, anayabin morobone himisir maiye. ");
INSERT INTO aai_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses bebeyan ebi’obaiyit i turobe, morobone boro hinamisir maiye anayabin buk wanawanan wairaf toto’ab isan kirum. Nati’imaim Moses Regah isan eo, ‘O i Abraham ana God, Isaac ana God, naatu Jacob ana God.’ ");
INSERT INTO aai_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Imih iti God i ma’ama wanatowan ana God, men murubih hai Godamih. Sabuw iyab i wanawananamaim tema’am i yawasih.” ");
INSERT INTO aai_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ofafar bai’obaiyenayah afa nati’imaim hima hinonowar himisir hio, “Anababatun turamaim iyafutih bai’obaiyenayan!” ");
INSERT INTO aai_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nati ufunamaim men yait ta baibat afa bow na Jesu ibatiyimih. ");
INSERT INTO aai_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Imaibo Jesu ibatiyih eo, “Aisim sabuw teo Roubinenayan orot i boro aiwob orot David ana rara’ane natufuw? ");
INSERT INTO aai_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Anayabin David akisin iti na’atube eorereb Buk Atamanin wabin Psalm imaim kirum, ‘Regah God ayu au Regah isan eo. Sisibu au asukwafune kumare. ");
INSERT INTO aai_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ina ma’am ayu boro a rakit sabuw anabow amaim ana ya inasasam.’ ");
INSERT INTO aai_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David Roubinenayan orot isan i ana Regah rouw eo, naatu mi’itube’emih Roubinenayan i boro David ana rara’ane nan natufuw?” ");
INSERT INTO aai_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesu eo sabuw hima hinonowar auman, ana bai’ufununayah iuwih eo, ");
INSERT INTO aai_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mata to niwa’an Ofafar Bai’obaiyenayah hinanan kwanahaiwih, anayabin i hai kok faifuw manih hina’osen hinabat hinaremor, ahar hai efanamaim sabuw hina’itih hai merar hinay hinakakafiyih, naatu Kou’ay Bar wanawanan efan gewasih hinabow hinamare hinama, na’atube hiyuw ana veya efan gewasih hinabow saise sabuw hai merar hinay. ");
INSERT INTO aai_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kwafur baibin hai sawar boro asir hinabow kwanekwan, yoyoban manimanih hinayoyoban, nati sabuw hai baimakiy i boro kakafin anababatun hinab.” ");
INSERT INTO aai_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu Tafaror Bar wanawanan siwar ya’aya ana efamaim mare ma sabuw kabay wairafih hina hai siwar tew wanawanan hibiwanen itih. ");
INSERT INTO aai_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naatu kwafur babin yababan wairafin auman na ana kabay gidigidih rou’ab tew wanawanan biwan itin. ");
INSERT INTO aai_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naatu sabuw iuwih eo, “Anababatun a tur ao’owen, iti kwafur babin, yababan wairafin ana siwar God bitin i sabuw etei natabirih. ");
INSERT INTO aai_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Anayabin sabuw afa i totobuyoy wairafih, imih hai siwar gagamin na’in hiyai, baise iti kwafur babin ana efanamaim abisa i isan yai inu’in i etei bai na ana siwar yai.” ");
INSERT INTO aai_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jesu ana bai’ufununayah afa Tafaror Bar hiwowowab ana gewasin hi’itin, naatu kabay hitar hikikirum isan, na’atube siwar ta ta God isan hiyasairen bar hibi’abur hi’itah isan hio hibifofofor. Baise Jesu eo, ");
INSERT INTO aai_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sawar iti etei kwa’itih kwa’o, mar boro kabay iti etei boro nihururuw nare narubar na’in, boro men ta iti hai efanamaim hina’inumih.” ");
INSERT INTO aai_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sabuw Jesu hibatiy hio, “Bai’obaiyenayan, mar i boro biy iti sawar hinamatar, naatu ina’inan i boro abisa namatar saise aki ana’itin ana so’ob veya i na tit?” ");
INSERT INTO aai_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu iuwih eo, “Mata toniwa’an, men koko’aw na’atube hinifufuwimih. Anayabin orot moumurih na’in boro ayu wabu’umaim hinao, ‘Ayu i Keriso, naatu Veya i na kabom.’ Men kwani’ufnunih. ");
INSERT INTO aai_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hinabiyow tur kwananonowar men kwanabir, naatu yababan nara’at ef hinafofokar auman men kwanabir, anayabin sawar nati na’atube boro wan hinamatar, baise men kwananot mar yomanin i na kabom.” ");
INSERT INTO aai_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Naatu iban iuwih maiye eo, “Tafaram ta ta boro taiyuwih hinagam hiniyow na’atube bar merar ta ta boro taiyuwih hinagam hiniyow. ");
INSERT INTO aai_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iriyoy gagamih boro hinamatar, baimar kakafin, sawow yumatah ta ta tafaram wanawanan boro awan nakaratan, maramaim sawar itah birubir boro hinamatar. ");
INSERT INTO aai_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wabu’umaim kwabowabow isan, hinarab hini’a’akir, hinabuw hinafatumi kwanan Kou’ay Bar hai ukwarih umahimaim hinayai, naatu i boro hinabuw kwanan dibur hinayariyi, tafaram ana aiwob na’atube orot gagamih nahimaim kwanatit hinibabatiy. ");
INSERT INTO aai_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Imih nati’imaim kwanatitit, veya keboroban i nati, ayu mi’itube kwaitutumu kwabowabow i hai tur kwana’owen. ");
INSERT INTO aai_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naatu baibatiyimih hinabuw kwananan men bogaigiwas taiyuw was fafari isan kwananot kwaniyababanamih. ");
INSERT INTO aai_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anayabin ayu boro tur anit a not hinarerekab tur kwanao a kamabiy sabuw hinanonowar boro men karam a tur hinarukouw naatu bairi kwanibasamih. ");
INSERT INTO aai_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hinat, tamat, taituwa, a ofonah boro baba hinao, hinabuw orot gagamih umahimaim hinaya’i, baimakiy hinit naatu kwa afa boro hina’asbuni kwanamorob. ");
INSERT INTO aai_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sabuw etei boro hinifa’ifai, anayabin ayu kwabi’ufnunu isan. ");
INSERT INTO aai_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Baise ukwarimaim arib ta boro men nakasiyomih. ");
INSERT INTO aai_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Naatu kwa a batkikinamaim yawas boro kwanatita’ur kwanab kwanama gewas. ");
INSERT INTO aai_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Baiyowayah sabuw Jerusalem hina’ar bebera’uh kwana’i’itin kwa i kwanaso’ob, Jerusalem rabin baitaiyin isan ana veya i kabom. ");
INSERT INTO aai_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sabuw iyab Judea wanawanan tema’am boro hinabihir hinan oyaw wan hinayen, sabuw iyab Jerusalem tema’am boro tafaram hinihamiy, sabuw iyab bar meraramaim tema’am boro men hinan Jerusalem hinatit. ");
INSERT INTO aai_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Anayabin nati i baimakiy ana veya, saise abisa bukamaim hikirum inu’in nan niturobe. ");
INSERT INTO aai_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nati ana veya’amaim baibin iyab yah auman naatu hai kek sosof auman bihir isan boro nafokar, yababan gagamin na’in boro iti tafaramamaim namatar naatu sabuw boro baimakiy hinab. ");
INSERT INTO aai_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sabuw afa boro ahay wan hinayen hina morob, afa boro hinabow hinan tafaram ta ta’amaim dibur hinaya. Naatu Eteni Sabuw Jerusalem boro hinarab nare tafan hinatet, naatu hinama hinakaif hai veya God bitih na’atube nan niturobe. ");
INSERT INTO aai_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Maramaim veya, sumar, daman boro ina’inan yumatah ta ta hinamatar. Tafaram tutufin wanawan etei boro ayay hinabosair abisa namamatar isan, yabat boro namisir, gis nayen ana’itin boro birubir kakafin. ");
INSERT INTO aai_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sabuw boro hai bir nara’at hinimamayay hinao, ‘Abisa tafaram wanawan emamatar.’ Anayabin maramaim sawar etei ti’inu’in hai efan boro hinasa’iren nanabin hinan. ");
INSERT INTO aai_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Imaibo Orot Natun sakukuw wanawanan ana fair ana marakaw bonamanamarin auman natit nanan hina’itin. ");
INSERT INTO aai_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sawar iti hinabusuruf hinamamatar ana veya’amaim, kwanamisir kwananuw ra’at, anayabin God ana sabuw baiyawasih isan ana veya i na rukabom.” ");
INSERT INTO aai_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Imaibo Jesu oroubon ta eo, “Ai fafou kwana’itin naatu ai afa auman kwana’itah. ");
INSERT INTO aai_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hiw ana veya natitit kwa boro kwanao, ai abeb ana veya na, ai rourih hina’abebemih. ");
INSERT INTO aai_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Imih ef i boro nati ta’imon, ana veya’amaim sawar iti na’atube hinamatar kwana’i’itah, kwa boro kwanaso’ob, God ana aiwob namih ana veya i na kabom. ");
INSERT INTO aai_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Anababatun a tur ao’owen sabuw iti tema’am boro moroboe hinama’am sawar iti hinamatar. ");
INSERT INTO aai_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mar tafaram boro nasawar, baise ayu au tur i boro men nasawaramih. ");
INSERT INTO aai_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mata toniwa’an, men aa tom namomon, naatu iti tafaram ana yawas isan a yababan nara’at, anayabin veya i boro naniyan meyemeye ");
INSERT INTO aai_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","warasa na’atube nabuw kwana’oror. Sabuw iti tafaram wanawanan boro etei isah namatar. ");
INSERT INTO aai_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Imih mata toniwa’an mar etei kwanayoyoban, saise fair kwanab sawar iti hinamamatar wanawanahimaim kwanahaiw kwan Orot Natun nanamaim kwanabat.” ");
INSERT INTO aai_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesu veya etei Tafaror Baremaim na sabuw bi’obaibiyih, baise rabirab en Olive Oyawemaim inu’in. ");
INSERT INTO aai_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Baise mar etei mar auman sabuw i tena Tafaror Baremaim eo tema tenonowar. ");
INSERT INTO aai_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Faraw Wanawanan Yeast en ana hiyuw wabin Tar Nowaten aa isan ana veya i na kabom. ");
INSERT INTO aai_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Naatu nati ana veya’amaim firis ukwarih naatu Ofafar Bai’obaiyenayah wa’iwa’iramaim ef hinunuwet mi’itube Jesu hitab hitarab tamorob isan, anayabin bebeyanamaim sinafumih sabuw hibiruwih. ");
INSERT INTO aai_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nati ana veya’amaim, Jesu ana bai’ufununayah 12 wanawanahimaim orot Judas wabin ta Iscariot Satan dogoron wanawanan run. ");
INSERT INTO aai_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Basit na firis ukwarih naatu Tafaror Bar ma’utenayah hai orot ukwarih biyah tit, Jesu mi’itube nab nabitih isan bairi hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Naatu orot ukwarih hiyasisir Judas kabay baitinin isan hio’matan. ");
INSERT INTO aai_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ibasit naatu ef ana gewasin wa’iwa’iramaim nuwet, mi’itube Jesu tab tabitih, sabuw men hitaso’ob. ");
INSERT INTO aai_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Faraw Wanawanan Yeast en hiyuw ana veya natit, nati ana veya’amaim i Tar Nowaten isan sheep natunatuh lamb terouw sibor teya’aya. ");
INSERT INTO aai_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Imih Peter, John hairi Jesu eobaimanih iyafarih eo, “Kwanan Tar Nowaten ana hiyuw kwanabogaigiwas tanaa.” ");
INSERT INTO aai_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hibatiy hio, “Menamaim kukokok boro ana bogaigiwas?” ");
INSERT INTO aai_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu iyafutih eo, “Kwanan Jerusalem kwanatitit auman orot ta boro noukwatamaim harew nahun na’abar nanan bairi kwanitar, naatu kwani’ufunun bairi kwanan bar erurumaim kwanarun. ");
INSERT INTO aai_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Naatu bar matuwan orot kwanibatiy, ‘Bai’obaiyenayan,’ o isa iti na’atube eo. ‘Ayu au bai’ufununayah bairi nanawan bar awan menatan boro imaim Tar Nowaten ana bay anaa?’ ");
INSERT INTO aai_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naatu i boro bar awan gagamin yate tafan ni’obaiyi kwana’itin, nati’imaim sawar etei hirereb hiyabuna inu’in, imaim kwanabogaigiwas.” ");
INSERT INTO aai_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Orot rou’ab hitit hinan sawar etei Jesu eo na’atube hi’itah, basit Tar Nowaten hiyuw hibogaigiwas. ");
INSERT INTO aai_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bay aa isan ana veya tit, naatu Jesu ana tur abarayah bairi bay aa ana efanamaim himare. ");
INSERT INTO aai_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Baise iuwih eo, “Ayu akokok kwanekwan iti Tar Nowaten ana bay kwa bairit tanaa, imaibo ani’akir biyau nababan. ");
INSERT INTO aai_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Anayabin a tur ao’owen, ayu i boro men kafa’imo iti bay anaa maiye, ana veya’amaim iti sawar yabin anababatun niturobe God ana aiwob wanawananamaim.” ");
INSERT INTO aai_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Imaibo Jesu kerowas bai, God ana merar yi, naatu ana bai’ufununayah itih eo, “Kerowas iti kwabai etei’imak kwafaram kwatom. ");
INSERT INTO aai_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A tur ao’owen, veya iti boun ebubusuruf ayu iti wine boro men anatom, ayu boro iti na’atube ana ma nan God ana aiwob nan natit.” ");
INSERT INTO aai_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naatu rafiy bai God ana merar yi sawar, imasib ana bai’ufununayah itih eo, “Iti i ayu biyou, kwa abit, iti na’atube kwanasinaf saise imaim ayu kwananuhu.” ");
INSERT INTO aai_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naatu kerowas isan i na’atube sinaf, bay hi’aa ufunamaim bai itih eo. “Iti kerowas i God ana Obaibasit Boubun ayu au rara’amaim ibour kwa etei isa ebisuwai. ");
INSERT INTO aai_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Baise kwanaso’ob orot yait ayu morobomih babau eo, i iti gemamaim airi ama’am. ");
INSERT INTO aai_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Orot Natun i boro namorob God isan yayakitifuw na’atube, baise orot yait baban eo emomorob i boro baimakiy gagamin na’in nab.” ");
INSERT INTO aai_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Basit bai’ufununayah taiyuwi hibabatiyih hio, “Iti kou’ay wanawanamaim o yait iti na’atube sinafumih iyakitifuw ima kunotanot?” ");
INSERT INTO aai_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bai’ufununayah taiyuwih wanawanahimaim gamin matar hai kokok hitaso’ob yait i orot gagamin. ");
INSERT INTO aai_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu iuwih eo, “Tafaram wanawanan Eteni Sabuw hai aiwob ana sabuw kaifih isan i hai fair ema’am imih sabuw tekakaifih, naatu sabuw iyab onowaten hibai sabuw tebobonawiyih, i tekokok wabih nara’at Bonawiyenayah hinarouw. ");
INSERT INTO aai_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Baise kwa wanawanamaim i men na’atube nama, o yait orot gagamin mataramih taiyuw inayare inikek, naatu o yait bonawiyenayan mataramih taituwa isah ini’akir inabow. ");
INSERT INTO aai_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yait i orot gagamin, orot bay aayan o orot bay semorayan? Orot mare ma bay eaau i turobe orot gagamin. Baise ayu kwa wanawanamaim i akir wairafin na’atube ama kwa isa abowabow. ");
INSERT INTO aai_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Au routobon fokarih wanawananamaim men kwaihamiyu, baise sisibu’umaim mar etei bairi tama’am. ");
INSERT INTO aai_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tamai aiwob ana fair itu abi’aiwob na’atube nati fair ta’imon kwa abit kwani’aiwob ");
INSERT INTO aai_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kwa boro au aiwob wanawananamaim kwanaa, kwanatom yasisir kwanab, aiwob hai ura ma’ama’amaim kwanamare Israel sabuw hai big etei 12 kwanakaifih.” ");
INSERT INTO aai_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesu eo, “Simon, Simon! Satan i baibasit God biyanane bai, kwa routobon nit nakubaituturimih. Orot masaw bowayan ana rice erab erububunai ani’aanin nabin eyai, naatu kanabin nabin eya’iyai na’atube. ");
INSERT INTO aai_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Baise Simon, ayu o isa ayoyoyoban, saise a baitumatum men nara’iy, naatu ayu isou inamamatabir ana veya, taituwa koufair initih hinabatkikin.” ");
INSERT INTO aai_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Baise Peter iya’afut eo, “Regah ayu airit na dibur run naatu na morob isan abobuna ama’am.” ");
INSERT INTO aai_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu eo, “Peter, boun gugumin o boro mar tounu inayoub inao, ‘Ayu orot nati men aso’ob,’ i ufunamaim kokorere boro nao inanowar.” ");
INSERT INTO aai_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Imaibo Jesu ana bai’ufununayah ibatiyih eo, “Kwanotanot ayu ai yuni aur kaukut, hafoy naatu a baibiyon en kwatit kwanan ana veya’amaim, sawar afa isah kwaiyababan.” Hiya’afut hio, “Men abistan ta isan ai yababanamih.” ");
INSERT INTO aai_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesu iuwih eo, “Baise a tur ao’owen, o yait aur kaukut, o hafoy ema’am inab, naatu o yait aur kaiy en, a biya baibiyon inab inan hinatubun naatu kabay inab kaiy inatubun uma inisinfafar. ");
INSERT INTO aai_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Anayabin a tur ao’owen, Buk Atamaninamaim iti na’atube hio hikirum, ‘Hi’i’itin i bainowan mowanabe,’ naatu nati tur i ayu isou hikirum, naatu boro anasinaf nan yabin namatar’’” ");
INSERT INTO aai_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bai’ufununayah hio, “Regah kaiy rou’ab iti abobotanen kui’itan.” Jesu iyafutih eo, “Nati ana fofonin.” ");
INSERT INTO aai_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesu ana bai’ufununayah bairi matan fufur tisisinaf na’atube Jerusalem hihamiy hiyen hin Olive Oyawemaim hitit. ");
INSERT INTO aai_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jesu na nati efanamaim titit ana veya, basit ana bai’ufununayan iuwih eo, “Kwanayoyoban saise routobon nanan boro kwanarukouw.” ");
INSERT INTO aai_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Imaibo in fotafot wan ana fofonin na’atube, sun yowen yoyoban ");
INSERT INTO aai_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","eo, “Tamai inakokok na’at, basit iti biyababan ana kerowas biyau’umaim kubosair, men ayu au kok, baise abisa o kukokok na’atube namatar.” ");
INSERT INTO aai_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Jesu dogoron wanawan yababan yan awan karatan, dogoron tutufin etei yoyoban ana foyab rara na’atube hituhorohoror me yan hire, naatu God ana tounamatar marane hire hina fair hitin. ");
INSERT INTO aai_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yoyoban sawar misir inan, ana bai’ufununayah matah fot hi’inu’in itih, hai yababan ra’at kwanekwan easbunih hi’inu’in. ");
INSERT INTO aai_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iuwih eo, “Aisim kwa’inu’in? Kwamisir kwayoyoban saise men routobon kwanab.” ");
INSERT INTO aai_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu iti na’atube bat eo auman, bai’ufununayah 12 wanawanahimaim orot ta wabin Judas sabuw rou’ay gagamin na’in nawiyih hina hitit. Naatu Judas mutufor in Jesu biyan tit bai mamay. ");
INSERT INTO aai_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Baise Jesu iu, “Judas o iti mamayenamaim Orot Natun ibai rakit sabuw kubitih?” ");
INSERT INTO aai_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bai’ufununayah bairi hibatabat Jesu isan abisa mamatar hi’itin, basit hibatiy, “Regah karam boro kaiyomaim bairi aniyow?” ");
INSERT INTO aai_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Naatu ana bai’ufununayah orot ta ana kaiy bora’ah, Firis Gagamin ana akir wairafin ta tainin asukwafune buru’um. ");
INSERT INTO aai_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Baise Jesu eo, “Men inasinaf maiye kunutanub!” Naatu Jesu orot tainin butubun efanin matar maiye. ");
INSERT INTO aai_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Imaibo Jesu firis ukwarih, Tafaror Bar ana firis ukwarin, furisiman, naatu regaregah ai’in Jesu bain fatuminamih hinan iuwih eo, “Kwa iti kaiy, kefat yuwu rabu’umih kwabow kwanan ana itinin i ayu orot kakafu bainowan na’atube? ");
INSERT INTO aai_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ayu mar etei Tafaror Bar gagamin wanawanan bairit tama’am, men kwakok boro imaim ayu kwatafatumu? Baise iti boun i kwa a veya, imih abisa kwakokok na’atube kwasinaf. Anayabin gugumin ana orot ebobonawiyi.” ");
INSERT INTO aai_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesu hibai hifatum hibai hin Firis Gagamin ana bar hitit, naatu Peter nabineika bat i’uf nunih bairi hin hitit. ");
INSERT INTO aai_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wairaf merar yan foun hi’asir himare hima rararih, Peter na wanawanah mare bairi hima rararih, ");
INSERT INTO aai_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","basit akir wairafin babitai ta nuw Peter ma wairaf rarar itin, naatu matan kubar itinbunai sawar imaibo eo, “Iti orot auman i Jesu hairi hima hireremor.” ");
INSERT INTO aai_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Baise Peter yaub eo, “Babitai, ayu nati orot i men kafa’i aso’ob.” ");
INSERT INTO aai_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hima kafa’imo, orot ta itin maiye eo, “O i ni’i orot ana bai’ufununayan ta.” Baise Peter iya’afut eo, “Aro, ayu men nati orot ana bai’ufununayan ta’amih.” ");
INSERT INTO aai_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hima one hour na’atube sawar, basit orot tabo iban eo maiye “Tur anababatun iti orot i Galilee matuwan Jesu hairi hima hireremor men kasikasiy ta’amih.” ");
INSERT INTO aai_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Baise Peter orot iya’afut eo, “Aro ayu men kafa’i aso’ob o abisa kuo.” Iti na’at eo auman kokorere eo. ");
INSERT INTO aai_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Regah tatabir mutufor nuw Peter itin, naatu Regah abisa eo i not, “Boun gugumin o boro mar tounu ayu inayayoubu ufunamaim kokorere boro nao.” ");
INSERT INTO aai_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Basit Peter misir tit in ufun re rerey i gagagamat. ");
INSERT INTO aai_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Orot afa Jesu hima’uh hima’am himisir faifuw ta hibai matan hisum, ");
INSERT INTO aai_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","imaibo hi’i’iyab naatu hiborabirab hio, “Kuo anowar, yait o rabi?” ");
INSERT INTO aai_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Naatu tur kakafih moumurih maiyow hiu kwanikwaniy hi’i’iyab. ");
INSERT INTO aai_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mar sibisib auman sabuw hai regaregah ai’in, firis ukwarih naatu Ofafar Bai’obaiyenayah etei hiru’ay hita’imon, imaibo Jesu hinawiy hina Kaniser nahimaim bat ");
INSERT INTO aai_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","naatu hibatiy, “Kuo anowar o i Keriso?” Jesu iyafutih eo, “A tur ana’owen boro men kwanitutumu’umih, ");
INSERT INTO aai_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","naatu ana bibatiyi auman boro men kwaniyafutu’umih. ");
INSERT INTO aai_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Baise mar enan Orot Natun boro God fairin uman asukwafune namare nama’am kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naatu etei’imak hibatiy hio, “Bo o God Natun?” Jesu iyafutih eo, “Ayu God Natun kwarouw kwao i tur anababatun kwao.” ");
INSERT INTO aai_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Imaibo sabuw hio, “Men takokok koubuna’ayah sabuw afa tanabow, anayabin tur awanamaim titit i tainitamaim tanowar!” ");
INSERT INTO aai_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kou’ay tutufin etei himisir Jesu hibai hina Pilate nanamaim hitit. ");
INSERT INTO aai_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nati’imaim ubar hitin hio, “Iti orot i ma kakaf bai na ai sabuw nawiyih tafaram hiti’afiyimih aki atita’ur, naatu sabuw eo’otanih Caesar isan kabay men hinibaiyan, naatu i taiyuwin isan eo, ‘Ayu i Keriso aiwob orot.’” ");
INSERT INTO aai_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Imaibo Pilate Jesu ibatiy, “O Jew sabuw hai aiwob?” Jesu iya’afut eo, “Nati kuo.” ");
INSERT INTO aai_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate firis ukwarih naatu sabuw hiru’ay hibatabat iuwih eo, “Iti orot baimakiyin isan anunuwet men ana kakafin ta atita’urimih.” ");
INSERT INTO aai_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Baise abisa hio i hiukikin. “Iti orot i kougeyageyayan, ana bai’obaiyenamaim Galilee wanawanan busuruf sabuw etei hai ma bi’a’afiy boun na Judea wanawanan sabuw etei kugiyigiyih hai ma eafe’af.” ");
INSERT INTO aai_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate iti na’atube hio nonowar ufunamaim, ibatiyih eo, “Iti orot i Galilee matuwan?” ");
INSERT INTO aai_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilate nati ana veya’amaim so’ob Jesu i Herod ana aiwob babanamaim ma’am, imih Herod isan iyafar hibai hin. Anayabin nati ana veya Herod auman i na Jerusalem ma’am. ");
INSERT INTO aai_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod Jesu i’itin ana maramaim yansisir gagamin maiyow, anayabin ana tur marasika nowar naatu kok kwanekwan Jesu taitin, ina’inan auman ta tiwa’an ta’itin. ");
INSERT INTO aai_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Imih Herod tur moumurih maiyow Jesu ibabatiy, baise Jesu men iya’afut tur ta eomih. ");
INSERT INTO aai_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Firis ukwarih naatu Ofafar Bai’obaiyenayah hitit tur fokarin maiyow hio ubar hitin hiu kwanikwaniy. ");
INSERT INTO aai_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Imaibo Herod ana baiyowayah bairi Jesu hi’iyab hiu kwanikwaniy. Naatu faifuw gewasin hibai hi’us hiyafar maiye matabir in Pilate biyan tit. ");
INSERT INTO aai_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nati ana veya’amaim Herod Pilate hairi hitounuw, baise marasika i hairi rakit na’atube nanabih hima’am. ");
INSERT INTO aai_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Firis ukwarih naatu bonawiyenayah, sabuw ukwarih etei’imak Pilate e’af ayuwih hina ");
INSERT INTO aai_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iuwih eo, “Iti orot kwabai kwana biyou kwatit sabuw nawiyih kakaf kwarouw kwa’o, naatu ayu kwa etei namaim ai babatiy kwa’itin, baise ana kakafin kwao anonowar na’atube men ta atita’urimih. ");
INSERT INTO aai_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na’atube Herod nunuwet ana kakafin men tatita’ur, imih iyafar maiye matabir na. Anayabin men abisa kakafin ta sinaf boro namorob. ");
INSERT INTO aai_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Isan imih ayu boro anarab naatu anabotait natit nan.” ");
INSERT INTO aai_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Matan fufur Tar Nowaten hiyuw ana veya, Pilate mar etei dibur orot ta’imon sabuw isah ebobotait. ");
INSERT INTO aai_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Baise sabuw rou’ay gagamin na’in hibatabat hiwow hio, “Nati orot i na morob! Aki akokok Barabas inabotait natit!” ");
INSERT INTO aai_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas i Jerusalemamaim kukugeyagey, naatu orot babin ta easabun momorob isan dibur hiyai ma’am.) ");
INSERT INTO aai_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate kok kwanekwan i Jesu tabotait tatit, imih fanan aumetawat na’in eafare maiye sabuw ifefeyanih. ");
INSERT INTO aai_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Baise sabuw fah sib hinow hi’af ra’at hio, “Ku’onaf! Ku’onaf!” ");
INSERT INTO aai_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate iban mar baitounin ibatiyih maiye, “Abisa kakafin sinaf? Ayu ana kakafin men ta a’itin boro namorob, imih ayu boro anarab naatu anabotait.” ");
INSERT INTO aai_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Baise sabuw fanah sib Jesu morobomih hiwow hio hinan yomaninamaim hai kok na yabin matar. ");
INSERT INTO aai_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Basit sabuw hio na’atube hai kokomaim Pilate sinaf, Jesu morob isan ibasit. ");
INSERT INTO aai_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naatu orot kougeyageyayan naatu asbunuwayan dibur ma’am isan hibifefeyan i botait, naatu Jesu isan abisa sinafumih hikokok na’atube bai itih. ");
INSERT INTO aai_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Roman baiyowayah Jesu onafinamih hibai hitit hinan efamaim, Sairini orot wabin Simon ana barene na au Jerusalem rur bairi hitar. Naatu hikwarar tatab, onaf hibai hitin e’abar Jesu ufun bairi hin. ");
INSERT INTO aai_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sabuw rou’ay gagamin na’in Jesu hi’ufunun bairi hinan wanawanahimaim baibin afa Jesu hi’itin yah baban hirerey. ");
INSERT INTO aai_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu tatabir itih eo, “Jerusalem baibin ayu isau men kwanarerey, baise kwa taiyuw isa naatu natunat isah kwaniyababan kwanarerey. ");
INSERT INTO aai_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anayabin mar boro enan sabuw boro hinao, ‘Baibin iyab a’arih, taubu’e tema’am naatu kek men tibitotomanen boro hiniyasisir.’ ");
INSERT INTO aai_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nati ana veya’amaim sabuw boro oyaw isah hinao, ‘Oyaw kure kutouni, naatu hihib kubu’ub kure kutouni!’ ");
INSERT INTO aai_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anayabin sawar iti na’atube ai biyan ahiy ana veya’amaim tisisinaf, baise ai nakekerer ana veya’amaim hinasisinaf boro mi’itube?” ");
INSERT INTO aai_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nati ana veya’amaim orot kakafih rou’ab auman Jesu bairi morobomih hinawiyih hitit hin. ");
INSERT INTO aai_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hitit hina efan wabin Gifow imaim hitit naatu Jesu hi’onaf orot kakafih rou’ab auman, orot ta ana asukwafune, orot ta ana beyawane. ");
INSERT INTO aai_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Imaibo Jesu eo, “Tamai hai bowabow kakafih kunotawiyen men hiso’ob abisa tisisinaf.” Naatu ana faifuw hibosairen arowamaim hifaram hibow. ");
INSERT INTO aai_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sabuw nati’imaim hibat hi’i’itin ana maramaim, bonawiyenayah orot ukwarih Jesu hi’iyab hio, “Sabuw afa iyawasih bo i Keriso God narurubin na’at taiyuwin niyawasiban tana’itin.” ");
INSERT INTO aai_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Roman baiyowayah auman hi’iyab, naatu wine tenakuyakuy tomamih hitin ");
INSERT INTO aai_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hio, “O Jew sabuw hai aiwob na’at taiyuw kwiyawasi!” ");
INSERT INTO aai_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Naatu ukwarinamaim hikirum hio, “Iti I Jew Sabuw Hai Aiwob.” ");
INSERT INTO aai_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Orot kakafin ta hi’onaf inu’in Jesu isan eafabon tur kakafih eo. “O Keriso na’at kwiyawas kure naatu aki auman kwiyawasi.” ");
INSERT INTO aai_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Baise orot ta rounane inu’in turan kwarar iu, “O God isan kubirubir ai en? It etei i baimakiy ta’imon tabaib. ");
INSERT INTO aai_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","It airit biyababan tabaib i ana efamaim tabaib, anayabin atasisinaf kwanekwanemaim wan tama ra’at biyat ebababan. Baise iti orot i men kafa’imo kakafin ta sinaf, asir biyababan ebaib.” ");
INSERT INTO aai_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naatu Jesu isan eafabon eo, “Jesu a aiwobomaim inarur ayu inanuhu.” ");
INSERT INTO aai_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu iya’afut eo, “Ao’omatani, boun ayu Paradise imaim ana rur o boro airit tanarun.” ");
INSERT INTO aai_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Veya yen na i’ouyit, veya rararan matan gugum tafaram etei fobe inu’in veya re three korok na’atube bai. ");
INSERT INTO aai_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Basit faifuw gagamin Tafaror Bar wanawan hitaiy re efan kakafiyin, kakafiyin hirafut inu’in taseb rou’ab himatar. ");
INSERT INTO aai_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Imaibo Jesu fanan aumetawat rerey eo, “Tamai umamaim ayubu abit inab.” Iti na’atube eo basit morob. ");
INSERT INTO aai_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Baiyowayah hai ukwarin nati’imaim bat abisa mamatar itin, God wabin bora’ara’ah eo, “Turobe iti orot i gewasin.” ");
INSERT INTO aai_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sabuw nati’imaim hiru’ay hibat abisa mamatar hi’itin, dogoroh hirab yababan auman hai ubar himatabitabir hin. ");
INSERT INTO aai_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sabuw afa Jesu hisusu’ub, naatu baibin afa Galilee ine hi’ufunun bairi hina hibibais, nabinamaim hibat Jesu momorob hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nati’imaim Arimathea orot wabin Joseph ma’am, Arimathea i Judea wanawananamaim bar merar ta. Iti orot Joseph i orot gewasin naatu ana ef mutufurin, God ana aiwob nan isan ma kakaif, naatu i auman Kaniser hai kou’ay orot ta, baise abisa hio hiyayanuw i ana baibasit men ta nati’imaim ma’amih. ");
INSERT INTO aai_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na Pilate nanamaim tit Jesu biyan bai na ya’in isan ifefeyan naatu aiwob orot ibasit. ");
INSERT INTO aai_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Joseph na Jesu biyan onaf afe’en inu’in bosair bai re faifuw boubunamaim sum bai in hub boubun to naiwanamaim tar numin inu’in imaim yai. ");
INSERT INTO aai_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naatu nati veya i Friday, Baiyarir busurufin isan ana veya nakabom. ");
INSERT INTO aai_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baibin Galilee ine Jesu hi’ufunun bairi hinan i Joseph bairi hin hubemaim hitit, Jesu biyan mi’itube ya’iyai i hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Naatu himatabir hin bar hitit Jesu biyan yabuna’in isan ana raiy hibogaigiwas naatu mar to Baiyarir Ana Veya i hima hiyarir hai ofafar eo na’atube. ");
INSERT INTO aai_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sunday maraumanika baibin raiy hibogaigiwas hi’inu’in hibow hin rah yan hitit. ");
INSERT INTO aai_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Naatu hin rah yan hitit ana veya kabay gagamin Jesu ana hub awan hiya’afut inu’in hifururuw tit hub awan asir inu’in hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Basit wanawanan hirun hin, baise Regah Jesu biyan men hitita’urimih. ");
INSERT INTO aai_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nati’imaim hai kasiy ra’at hibat hibinubunibun naniyan meyemeye orot rou’ab hai bonamanamarin auman sisibihimaim himatar hibat. ");
INSERT INTO aai_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Baibin hai bir ra’at nahimaim yumatah au babe me yan hire, baise orot rou’ab hi’uwih hio, “Kwa aisim orot yawasin isan sabuw murubin hai efanamaim kwanunuwih? ");
INSERT INTO aai_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iti’imaim boro men kwana’itin, i morobone misir maiye! Galilee imaim bairi kwama’am ana veya tur abisa eo i kwanotanot. ");
INSERT INTO aai_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Orot Natun i boro hinab sabuw kakafih umahimaim hinayai, hina’onaf, naatu veya tounu ufunamaim morobone nayawas maiye.’” ");
INSERT INTO aai_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Imaibo baibin ana tur eo nuhih taseb hinot. ");
INSERT INTO aai_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Naatu rahane himatabir maiye hina bar hitit. Sawar abisa’awat hi’i’itah ana bai’ufununayah nah 11 naatu bai’ufununayah afa nati baremaim hima’am auman hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Baibin iyabowat sawar hi’itah hina Jesu ana tur abarayah hai tur hio’owen wabih i Mary Magdalin, Joanna naatu Mary, James hinah naatu baibin afa auman. ");
INSERT INTO aai_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Baise Jesu ana tur abarayah baibin hio men hitumatum, anayabin hai tur hinonowar naniyan i tamim tao kwanekwan na’atube. ");
INSERT INTO aai_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Baise Peter misir nunuw in rah yan tit, hub wanawanan kwaf nuwariy faifuwawat hi’inu’in itah, basit abisa mamatar isan erebainotanot auman matabir in. ");
INSERT INTO aai_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nati veya ta’imon Jesu ana bai’ufununayah orot rou’ab Jerusalemane hin bar merar ta wabin Emmaus imaim hitit. Jerusalem in Emmaus titit ana fofonin i 11 kilometres na’atube. ");
INSERT INTO aai_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baise iti orot rou’ab efamaim sawar abisa’awat himamatar isah hairi hio hidudur hinan ana veya, ");
INSERT INTO aai_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jesu ufuhine natit botanih bairi hita’imon hiremor hin. ");
INSERT INTO aai_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naatu bairi hinan i hi’itin baise men kafa’imo hi’inan. ");
INSERT INTO aai_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu ibatiyih, “Kwa abisa isan tura airi kwaidudur auman kwanan?” Naatu orot rou’ab hinutanub yah rererey yen hibat. ");
INSERT INTO aai_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Orot ta wabin Cleopas ibatiy eo, “Jerusalem wanawanan o akisimo nanawan orot, imih sawar abisa fai fur wanawanan mamatar o men iso’obamih?” ");
INSERT INTO aai_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu ibatiyih, “Sawar abistan?” Hiya’afut hio, “God ana dinab orot wabin Jesu Nazareth matuwan, God matanamaim na’atube sabuw matahimaim ana tur eo naatu ana bowabow sisinaf etei i fairih naatu turobe. ");
INSERT INTO aai_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Baise aki ai firis ukwarih naatu bonawiyenayah orot ukwarih hibai Roman gawan hitin, morobomih eo ibasit naatu hibai hin hi’onaf morob. ");
INSERT INTO aai_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aki anotanot iti orot boro Israel sabuw baiyawasih arouw nuhifot ama’am, baise iti orot hirab momorob i veya boun tounu sawar. ");
INSERT INTO aai_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naatu baibin afa aki ai kou’ayomaim boun maraumanika hin rah yan hititit biyan hiboyouw ");
INSERT INTO aai_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","naatu himatabir hina hio, ‘Aki tounamatar ai’itih, naatu tounamatar ai tur hi’owen Jesu i morobone misir maiye.’ Iti na’at hio aki aoror sa’iri ai kasiy ra’at. ");
INSERT INTO aai_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Basit ai kou’ayomaim sabuw afa hin rah yan hit abisa baibin hio hinowar na’atube hi’itah, baise Jesu men hi’itinimih.” ");
INSERT INTO aai_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Imaibo Jesu iuwih eo, “Kwa i kwabikoko’aw, aisim dinab oro’orot abisa hio hikikirum men fudir rerekab kwabitumatumamih! ");
INSERT INTO aai_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso iti sawar etei isah ni’akir biyan nababan saise ana aiwob maramaim narun nabi’aiwob isan men kwaso’ob?” ");
INSERT INTO aai_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Imaibo Jesu taiyuwin isan aneika Moses ana Buk kikirum imaim busuruf idudur rena God ana dinab oro’orot hai Buk hikikirum imaim tit. ");
INSERT INTO aai_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Naatu bar merar hinuh hinanamaim hititit auman, Jesu bar merar ta namihibe iwa’an hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Baise hi’otan hio, “Veya sawar naatu mar efof imih tarun bairit ta’in.” Iti na’at hio itin, basit bairi inumih hirun. ");
INSERT INTO aai_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bay aa isan Jesu bairi himare, eof rafiy bai God ana merar yi sawar imasib itih. ");
INSERT INTO aai_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Imaibo hairi matah to iwa’an hi’inan, baise marta’imon na’am sa’iwa’an. ");
INSERT INTO aai_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hairi himisir hio, “Efamaim tanan Buk Atamaninamaim bidudur dogorot ahayabe yiy naniyan itatam?” ");
INSERT INTO aai_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Basit himisir himatabir maiye hin Jerusalem hitit, nati’imaim bai’ufununayah nah 11 naatu afa auman hiru’ay hima’am hi’itih, ");
INSERT INTO aai_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","hai tur hi’owen hio, “Tur anababatun Regah i morobone misir maiye Simon isan irerereb. ");
INSERT INTO aai_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Orot rou’ab efamaim abisa mamatar naatu mi’itube rafiy imasib bitih ana veya’amaim matah to iwa’an hi’i’inan etei hidudur turahinah hinowar. ");
INSERT INTO aai_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Orot rou’ab iti na’atube hima hio hinonowar auman naniyan meyemeye Regah nah yan foun matar bat iuwih eo, “Tufuw isa nama.” ");
INSERT INTO aai_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Etei hi’oror, hai bir ra’at, hinotanot i yoyom mowan itinin hirouw. ");
INSERT INTO aai_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Baise Jesu iuwih eo, “Aisim kwabirubir naatu aisim a not boro’ika tekakasiy? ");
INSERT INTO aai_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Au umau kwa’itah, naatu biyau kwabutubun finimu au rakit naniyan kwatatam, saise kwanaso’ob iti i anababatun ayu, anayabin yoyom i aurih finimih en.” ");
INSERT INTO aai_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iti ra’at eo sawar basit an uman i’obaiyih hi’itan. ");
INSERT INTO aai_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Baise men kafa’imo hitumatumamih, hai kawasa ra’at hikasiy auman, basit Jesu ibatiyih, “Kwa bay urey ta kwayai inu’in?” ");
INSERT INTO aai_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Siy baibitab finimin reban hibai hitin ");
INSERT INTO aai_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","naatu nahimaim bat eaan hi’itin. ");
INSERT INTO aai_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Imaibo hai tur eowen eo, “Ayu i sawar iti isah bairit tama’ama ana veya a tur aowen. Sawar abisa ayu isau mataramih Moses ana Bukamaim, dinab hai Bukamaim na’atube Psalms imaim hio hikikirum hina hiturobe.” ");
INSERT INTO aai_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Imaibo hai not botawiy Buk Atamaninamaim abisa isan hio hikikirum naniyan hibai. ");
INSERT INTO aai_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naatu iuwih eo, “Abisa hio hikikirum anayabin i iti, Keriso i ni’akir biyan nababan namorob, naatu veya tounu ufunamaim boro nayawas maiye namisir. ");
INSERT INTO aai_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Saise i wabinamaim ya baikitabir naatu notawiyen ana tur Jerusalemamaim an hinayai hinabinan hinatit hinan tafaram tutufin etei hinanowar. ");
INSERT INTO aai_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imih kwa abisa matamaim kwa’i’itin i kwanakubuna sabuw etei hai tur kwana’owen hinanowar. ");
INSERT INTO aai_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jerusalemamaim kwanama ayu Tamai abisa baitimih eo’omatani marane aniyafar nare a fair kwanab.” ");
INSERT INTO aai_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Imaibo nawiyih bairi Jerusalem hihamiy hitit hin Bethany hitit, nati’imaim uman bora’ah isah yoyoban igegewasinih. ");
INSERT INTO aai_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bigegewasinih auman ihamiyih earura’ah yen in mar wanawanan run. ");
INSERT INTO aai_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hibora’ara’ah yasisir yah awan karatan auman himatabir maiye hin Jerusalem hitit. ");
INSERT INTO aai_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nati’imaim mar etei hin Tafaror Baremaim God ana merar hiyiy naatu hibobora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tafaram matara’e ana veya Tur i wan ma, naatu Tur i God hairi hima, naatu Tur i God taiyuwin. ");
INSERT INTO aai_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tur i God hairi wan hima’abo tafaram matar. ");
INSERT INTO aai_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tur wanawananamaim God sawar etei’imak sinafen himatar; iti sawar himamatar i etei tur wanawananamaim himatar men ta asir matar kwaneyanamih. ");
INSERT INTO aai_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tur i yawas an anababatun, naatu iti yawas i sabuw isah marakaw bai na. ");
INSERT INTO aai_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iti marakaw guguminamaim kusisiar, naatu gugumin men karam boro marakaw na’asabun. ");
INSERT INTO aai_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ana kob abarayan wabin John iyafar na tit; ");
INSERT INTO aai_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","marakaw isan sif ruboun eorereb sabuw hinowar, naatu sabuw iyab tur hinonowar hitumatum. ");
INSERT INTO aai_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I taiyuwin i men marakaw; i marakaw akisin ana sif narubonamih na. ");
INSERT INTO aai_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iti marakaw i turobe, marakaw anababatun, tafaramaim na sabuw tafahimaim ekukusisiar. ");
INSERT INTO aai_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tur i na tafaram eo mamatar wanawananamaim ma, baise tafaram i men inanimih. ");
INSERT INTO aai_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I na ana tafaram tit, baise taiyuwin ana sabuw i men hibaimih. ");
INSERT INTO aai_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Baise sabuw afa hibai naatu wabinamaim hitumitum, naatu baibasit itih i hina God natunatun himatar. ");
INSERT INTO aai_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God natunatun himamatar i men orot anarara, o men orot babin aawan hairi hi’in kek tetutufu na’atube’emih, baise i God akisin anakokok sinaf i natunatun himatar. ");
INSERT INTO aai_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tur i na orot matar, naatu wanawanatamaim ma, ana marakaw bonamanamarin i taitin, iti marakaw bonamanamarin i God Natun ta’imonamo ebitin. Iti tur wanawanan i turobe naatu manaw kabeber awan karatan. ");
INSERT INTO aai_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John iti orot isan fanan sib binan eo,” Iti orot ayu isan ao’oban iti enan, anamaramaim ayu iti na’at ao, ‘I ayu ufu enan i ana fair ra’at ayu natabiru, anayabin i wan ma’abo ayu atufuw.’” ");
INSERT INTO aai_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I wanawanan manaw kabeber karsuwei it etei ebigegewasinit, ana baigegewasin tafan baban ebitit. ");
INSERT INTO aai_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anayabin God ana ofafar i Moses itin, baise manaw kabeber naatu turobe i Jesu Keriso’one na. ");
INSERT INTO aai_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Men yait ta God itin. baise God Natun ta’imon Tamah wanawananamaim ema’am akisinamo God bai na bebeyanamaim tasusu’ub. ");
INSERT INTO aai_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jew hai ukwarih Jerusalem hima’am firis afa naatu hai baibaisayah afa hiyafarih hin John hibatiy? “O i yait?” ");
INSERT INTO aai_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I men baifuwenamaim iyafutih, baise i mutufor bebeyanamaim eorereb, “Ayu i men Keriso.” ");
INSERT INTO aai_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Naatu hibatiy, “Bo o i yait? Om Elizah?” John eo, “Ayu men Elizah.” Ai o dinab orot?” John iya’afutih eo, “Ayu men dinab orot.” ");
INSERT INTO aai_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ibanak hibatiy maiye hio, “O i yait? Ku’o anowar saise anamatabir anan iyab hiyafari anan hai tur ana’owen. O taiyuw isa boro inakubuna ananowar.” ");
INSERT INTO aai_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John iya’afutih dinab orot Isaiah Buk Atamaninamaim kirum inu’in imaim eo, “Ayu i orot ta fanan araramaim eafa’af. Ef kwanarumutufur Regah ana remor isan!” ");
INSERT INTO aai_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kob nayah Pharisee hiyafarih hina, ");
INSERT INTO aai_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","John hibatiy, “Bo o men Keriso, o Elizah o dinab orot na’at, aisim sabuw bapataito kubitih?” ");
INSERT INTO aai_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John hai tur eowen eo, “Ayu harewamaim sabuw bapataito abitih, Baise kwa wanawanamaim orot ta ebatabat kwa men kwaso’ob. ");
INSERT INTO aai_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I Ayu ufu’umaim enan, an ana baibaiyon murab men gewasu boro anarufamen.” ");
INSERT INTO aai_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iti sawar etei i Bethany himatar harew Jordan sisibin veya yeninane, John sabuw bapataito bitihimaim. ");
INSERT INTO aai_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mar to John nuw Jesu nan itin eo, “Kwanuw God Ana Lamb tafaram ana kakafin bosairenayan enan kwa’itin!” ");
INSERT INTO aai_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iti orot isan ao’orereb anamaramaim iti na’atube ao, ‘Orot ayu ufu’umaim enan i ana fair ra’at kwanekwan, anayabin i wan ma’abo ayu a tufuw.’ ");
INSERT INTO aai_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ayu taiyuwu auman iti orot men asu’ub, baise anayabin nati isan ayu harewamaim sabuw bapataito abitih imaim Israel sabuw isah tirerereb hitaso’ob’. ");
INSERT INTO aai_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Naatu John iti tur eorereb. “Ayu Anunin mamu imag na’atube marane ra’iy naatu i tafanamaim mamara’at aitin. ");
INSERT INTO aai_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ayu iti orot i boro men ataso’ob, baise God iyunu ana harewamaim sabuw bapataito abitih i au tur eowen, ‘Orot yait Anunin nara’iy tafanamaim namara’at ina’i’itin, i boro Anun Kakafiyinamaim bapataito nitih.’” ");
INSERT INTO aai_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","John eo, “Ayu aitinika naatu ao’orereb iti i God Natun.” ");
INSERT INTO aai_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ana martot John iban maiye ana bai’ufununayah orot rou’ab bairi hina efan ta’imonamaim hibatabat. ");
INSERT INTO aai_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naatu Jesu na natabirih inan i’itin anamaramaim, John eo, “God ana Lamb enan kwa’itin!” ");
INSERT INTO aai_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anamaramaim bai’ufununayah orot rou’ab iti hinonowar, i hairi Jesu hi’ufunun. ");
INSERT INTO aai_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu nunutabir, orot rou’ab hibi’ufunun itih naatu ibatiyih, “Kwa abistan kwakokok?” Hiya’afutih hi’o, “Rabbi” (anayabin Bai’obaiyenayan), “O menamaim kuma’am?” ");
INSERT INTO aai_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I iya’afutih eo, “Kwanatan, kwa taiyuw efan kwa’itin.” Naatu hin efan menamaim ma’am hi’itin, naatu veya tutufin bairi imaim hima. Nati i tanao 4 korok na’atube. ");
INSERT INTO aai_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","John abistan eo’o orot rou’ab hinowar Jesu hibi’ufunun orot ta i Andrew, Simon Peter tain ");
INSERT INTO aai_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew Jesu bihamiy ufunamaim wantoro’ot i tuwah Simon nuwih, naatu tita’ur ana tur eowen, “Ayu i Roubininenayan atita’ur, nati i Keriso.” ");
INSERT INTO aai_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naatu Andrew tuwah Simon nawiy in Jesu biyan tit. Jesu nura’at itin naatu eo, “O i Simon, John natun. O boro wab hina’af Cephas.” Cephas, Peter hairi hai yabin i kabay. ");
INSERT INTO aai_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana marto, Jesu au Galilee namih bobogaigiwas, Philip tita’ur naatu iu, “Kuna kwi’ufnunu tan.” ");
INSERT INTO aai_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip ana tafaram i Betsaida, Andrew tuwah Peter bairi hai bar merar ta’imon. ");
INSERT INTO aai_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip na Nathanael tita’ur naatu iu, “Iti orot isan Moses Buka Atamaninamaim eo kikirum naatu dinab oro’orot auman hikikirum i boun atita’ur, iti orot tamah i Joseph ana bar ana merar i Nazareth.” ");
INSERT INTO aai_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Nazareth! Sawar gewasin ta boro imaim namatar?” Nathanael ibat. Philip eo, “Kuna tan, kwi’itin.” ");
INSERT INTO aai_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Anamaramaim Jesu nuw Nathanael nan itin, isan eo, “I turobe Israel mowan, i orot ana yawas gewasin men baifufuwenayan.” ");
INSERT INTO aai_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael ibatiy, “O mi’itube ayu isu’ubu?” Jesu iya’afut eo, “O i ai fig an anayouninamaim ima’am ayu ait, naatu ufibo Philip o isa eaf.” ");
INSERT INTO aai_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Imaibo Nathanael eorereb eo, “Rabbi, Bai’obaiyenayan o i God Natun! o i Israel hai Aiwob.” ");
INSERT INTO aai_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu eo, “O i tumatum anayabin ayu a tur aowen o i ai fig an ima’am ait. O boro sawar gagamihika ina’itan men iti i’i’itin na’atube.” ");
INSERT INTO aai_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tur tafan ya’abar maiye eo, “Turobe a tur ao’owen, kwa boro mar ana etawan nabotawiy, naatu God ana tounamatar Orot Natun biyanamaim hinayen hinarara’iy kwana’itih.” ");
INSERT INTO aai_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Veya baitonin ufunamaim tafaram Galilee wanawanan bar merar Canna imaim tabin ana hiyuw hibogaigiwas. Jesu hinah i nati’imaim. ");
INSERT INTO aai_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Naatu Jesu ana bai’ufunanayah auman bairi hibuwih tabin ana hiyuw aa wanawanan hirun. ");
INSERT INTO aai_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sabuw wine hitom sasawar anamaramaim Mary natun Jesu isan eo, “Wine hitom sawar.” ");
INSERT INTO aai_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu iya’afut eo, “Babine, ayu men inabobaru iti hiyuw aa wanawanan. Ayu au veya i men baimih.” ");
INSERT INTO aai_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hinah sabuw bowayah isah eo, “Abistanawat na’u’uwi imaim kwanasinaf.” ");
INSERT INTO aai_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sisibihimaim noukwat buhuw etei umat roun ta’imon kabayamaim hikwakwen hibatabat, iti noukwat i Jew hai koksouwen binanakwar noukwat. Nati noukwat wanawananan i karam harew boro 70 o 100 litres hinisuwei nayen awan nakaratan. ");
INSERT INTO aai_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu bowayah uwih, “Buhuw harew kwariren teyen.” Imih harew hiriren hiyen awah hikartanen, ");
INSERT INTO aai_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","naatu uwih, “Bounabo turin kwahun kwabai kwan tabin ana orot ukwarin kwaitin.” Eo na’atube hisinaf. ");
INSERT INTO aai_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Naatu tabin ana orot ukwarin harew bai kakartubun harew botabir in wine naniyan matar. I men so’ob wine i menane na, baise bowayah iyab harew hihuh i hiso’ob. Naatu tabin boubun eaf na bai tit nabinamaim ibatiy naatu, ");
INSERT INTO aai_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","eo, “Mar etei hiyuw ana veya wine hai baiyan gagamin i wan tetomatom, naatu ufunamaim nanawan sabuw tetom terarouwabon i wine ana baiyan kikimin tetomatom. Baise o bounabo wine gewasin iya’asair inu’in ibotait.” ");
INSERT INTO aai_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iti i Jesu ana ina’inan fairin wantoro’ot tafaram Galilee wanawanan bar merar Canna imaim sinaf matar. Nati’imaim i ana fair botait, naatu i ana bai’ufununayah hi’itin hitumatum. ");
INSERT INTO aai_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iti ufunamaim Jesu hinah naatu taitin ana bai’ufununayah bairi hire hin Capernaum hitit. Nati’imaim veya bai’ab na’atube hima. ");
INSERT INTO aai_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naatu Jew hai Tar Nowaten Hiyuw i na kakabom auman, Jesu yen in Jerusalem tit. ");
INSERT INTO aai_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tafaror Bar wanawanan ana seboseb rur sabuw hima, sheep, mamu hitotobon, naatu sabuw afa i gem afe’en hima kabay hibiyabonen tita’urih. ");
INSERT INTO aai_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Imih i murab bai eam wabir matar imaim wabirih nunih seboseb hihamiy ufun hitit, naatu for hiyataiten hima hitotobon auman naatu kabay hibiyabonebonen hai kabay tar baisrouwen hai gemogem eabar tabitabiren hisuwa hire. ");
INSERT INTO aai_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sabuw iyab mamu hiyateiten hitotobon isan i eo, “Iti kwabosairen kwatit ufun. Aisim Tamai ana bar kwiwa’an in ahar bar matar!” ");
INSERT INTO aai_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesu ana bai’ufnunenayah nuhih taseb Buk Atamaninamaim mi’itube hikirum inu’in hinot, “Ayu dogorou O a Bar isan aniyababan wairafabe na’arahu anamorob.” ");
INSERT INTO aai_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Imaibo Jew sabuw tur fokarinamaim Jesu hibatiy, “Ina’inanen baifofofor afa kusinafen a’itah saife imaim ni’obaiyi o sawar etei sinaf isan ana fair ibai?” ");
INSERT INTO aai_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu iyafutih eo, “Iti Tafaror Bar anagurus nare, naatu veya tounu wanawananamaim ana bora’ah maiye.” ");
INSERT INTO aai_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jew sabuw hiya’afut hi’u, “Iti Tafaror Bar hiwowowab i kwamur etei 46 sawar, naatu o ku’o i veya tounu wanawananamaim inawowab maiye?” ");
INSERT INTO aai_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Baise Jesu Tafaror Bar isan eo nati i taiyuwin biyan isan eo. ");
INSERT INTO aai_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesu morobone mimisir ufunamaim, ana bai’ufnunenayah nuhih taseb abistanawat eo hinot. Naatu imaibo Buk Atamaninamaim hikikirum hitumatum naatu Jesu tur eo auman hitumatum. ");
INSERT INTO aai_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu Jerusalem ma’am ana veya Tar Nowaten ana hiyuwamaim ina’inan baifofofor sisinafen i sabuw moumurih maiyow hi’itah naatu i wabinamaim hitumatum. ");
INSERT INTO aai_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Baise Jesu taiyuwin so’ob nati sabuw i men ebitutumih, anayabin orot babin etei i su’ubih, ");
INSERT INTO aai_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","imih men karam orot babin hai not i ana tur hita’owen anayabin abisa orot dogoron wanawanan i so’ob. ");
INSERT INTO aai_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jew hai ukwarin orot wabin Nicodemus i Pharisee ana kou’ayamaim orot ta. ");
INSERT INTO aai_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Guguminamaim na Jesu biyan tit, naatu eo, “Bai’obaiyenayan, aki aso’ob o i bai’obaiyenayan God biyanane ina. Men yait ta karam boro ina’inanen fairih o kusisinafube nasinaf, God men hairi hinama’am na’at.” ");
INSERT INTO aai_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mar ta’imonamo Jesu iya’afut, “Ayu tur anababatun a tur ao’owen, men yait ta boro God ana ma’ama wanatowan na’itin, baise i boro natufuw maiye’ebo.” ");
INSERT INTO aai_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Orot ra’at gagamin na’in ema’am, boro mi’itube natufuw maiye?” Nicodemus ibat. “Men karam hinah yan wanawanan narun mar bairou’abin natufuw maiye!” ");
INSERT INTO aai_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu iya’afut eo, “Turobe a tur ao’owen, men yait ta boro God ana ma’ama wanatowan narun, baise i harew naatu Anuninamaim natufuw. ");
INSERT INTO aai_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Biyat etatoub, i biyat eya’iy, baise Anun Kakafiyin etatoub Anun Kakafiyin iya’iy. ");
INSERT INTO aai_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","O boro men ita’ororsa’ir ayu tur iti tufuw maiye ao isan. ");
INSERT INTO aai_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Waruw ana kokomaim ebababin. O i nidun kunonowar, baise o men karam boro inao, i menane na enan, o au mena’at babin enan. Imih orot babin anunihine i nati na’atube tetutufuw.” ");
INSERT INTO aai_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus i bat, “Iti i mi’itube?” ");
INSERT INTO aai_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu eo, “O i Israel hai bai’obaiyenayan naatu o iti sawar men imanamamih?” ");
INSERT INTO aai_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jesu iya’afut eo, “Ayu turobe a tur ao’owen, aki abisa asoso’ob i a’o, naatu abisa aki a’i’itin i isan a’o, baise kwa i boro’ika aki ai tur naniyan men kwabaibimih. ");
INSERT INTO aai_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ayu tafaram ana sawar isah ao kwanowar baise kwa men kwabitumatum. Kwa boro mi’itube kwanitumatum ayu mar ana sawar isah ana’o na’at?” ");
INSERT INTO aai_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Men yait ta in mar run, baise orot Natun marane nan akisinamo. ");
INSERT INTO aai_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses mi’itube arar yan kok bora’ah na’atube, orot natun hinabora’ah nayen, ");
INSERT INTO aai_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","saise iyabowat i tebitumatum boro ma’ama wanatowan hinab. ");
INSERT INTO aai_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God tafaram iyabuw kwanekwan imih i Natun ta’imonamo iyafar na, saise yait i ebitumitum boro men namorob, baise boro yawas wanatowan nab. ");
INSERT INTO aai_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God i men tafaram bai’afiyin isan Natun iyafar na tafaramaim titamih, baise tafaram baiyawasin isan na tit. ");
INSERT INTO aai_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","O yait I kubitumitum boro men ina’afemih, baise o yait men ebitumitum i eaf sawar, anayabin i men God Natun Ta’imon, i akisinamo wabin itumitumamih. ");
INSERT INTO aai_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iti i baib’afiyen. Marakaw na tafaramamaim tit, baise orot marakaw efanin gugumin iyabuw anayabin hai sinaf kakafih. ");
INSERT INTO aai_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Orot babin etei sinaf kakafih tesisinaf i marakaw hikwahir naatu boro men hinan marakaw wanawanan hinarun, tebirubir hai sinaf boro hinirerereb. ");
INSERT INTO aai_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Baise yait ta turobe’emaim ema’am marakaw wanatowan erur, saise i ana bowabow God wanawananamaim bowabow boro nirerereb. ");
INSERT INTO aai_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iti ufunamaim, Jesu ana bai’ufununayah bairi hitit hin Judea tafaram ufunane hirun, nati’imaim mar kikimin hima naatu bapataito itih. ");
INSERT INTO aai_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nati’imaim John auman tafaram Aenonamaim sabuw bapataito bitih, Salim i men ef yok i sisibinamaim, anayabin nati’imaim i harew moumurih, naatu sabuw i nan ufun hinan bapataito bain isan. ");
INSERT INTO aai_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Iti John dibur hiyaru’uy ma’am nanamaim.) ");
INSERT INTO aai_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John ana bai’ufununayah afa naatu Jew sabuw afa wanawanahimaim gamin matar, bapataito ana ofafaren isan. ");
INSERT INTO aai_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I hina John biyan hitit naatu hi’o, “Bai’obaiyenayan, orot nati o airi no Jordan harew rounane menatan isan o i’o’orerereb, i boun bapataito sabuw ebitih, naatu sabuw etei i isan tenan.” ");
INSERT INTO aai_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nati isan John iya’afut eo, “Orot abistanawat marane tebitin iwat nab. ");
INSERT INTO aai_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kwa taiyuw i karam ayu ao i kwanao’rereb, Ayu i men Keriso, baise ayu i nanamaim hiyafaru ana. ");
INSERT INTO aai_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Babin orot ana rum hi’o ema’am, orot ana of menatan i bai’awaninamih i orot isan ma tainin rub ma ekakaif, naatu i ana rum fanan enonowar ana veya i anababatun ekakawasa. Iti kawasa i ayu nowau, naatu kawasa i boun ana yomanin a’asa’ub. ");
INSERT INTO aai_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I ana fair ra’at natabiru, ayu fair i men ra’at.” ");
INSERT INTO aai_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yeit auyomane nan i ra’at etei natabirih, menatan iti tafaramane nan i tafaram nowan, naatu tafaram ana sawar isah i ebidudur. Menatan marane nan i sawar etei tafahimaim. ");
INSERT INTO aai_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I abis nonowar, i’itanen i isah eo’orerereb, baise men yait ta ana tur ebaibimih. ");
INSERT INTO aai_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Orot yait ta i ana tur nabitumitum na’at, i ebi’obaiyit i ebitumatum God abistan eo’o i turobe. ");
INSERT INTO aai_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Menatan God biyafar i God ana tur eo’orerereb; anayabin God i Anun i nowanamih itin anababatun ");
INSERT INTO aai_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamah Natun iyabuw kwanekwan naatu sawar etei i ana fair babanamaim ya. ");
INSERT INTO aai_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yait ana baitumatum Natunamaim naya’iy boro yawas wanatowan nab, baise yait ta God Natun nabifutuw boro men yawas nitinimih, God ana yaso’ar tafahimaim nama. ");
INSERT INTO aai_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisee hinowar Jesu i bigegesairih naatu John natabir ana bai’ufununayah moumurih na’in bapataito ebitih, ");
INSERT INTO aai_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","turobe iti i men Jesu bapataito ebitih, baise i ana bai’ufununayah. ");
INSERT INTO aai_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Anamaramaim Jesu, i Judea ihamiy naatu matabir maiye in Galilee. ");
INSERT INTO aai_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Boun ana remoramaim i boro Samaria wanawanan narun nan. ");
INSERT INTO aai_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Imih i Samaria bar merar wabin Sychar tit, Jacob ana me kamar i natun Joseph bitin i sisibinamaim. ");
INSERT INTO aai_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob ana harew karakar i nati’imaim, naatu Jesu ef nan hahar, karakar sisibin mara’at ma. Nati i ouyit. ");
INSERT INTO aai_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria babin harew huninamih nan anamaramaim, Jesu babin isan eo, “Karam harew ititu atatom? ");
INSERT INTO aai_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","I ana bai’ufununayah hin bar merar bay tobonamih. ");
INSERT INTO aai_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria babin Jesu isan eo, “O i Jew naatu ayu i Samaria babin. Mi’itube ayu isou harewamih kufefefeyan?” (Jew hai naukwat, o hai kerowas boro men Samaria bairi hinafaram hinaa hinatom.) ");
INSERT INTO aai_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu, babin isan iya’afut eo, “O God ana siwar itasoso’ob na’at yait o isa harew tomamih efefeyan, o boro itibatiy i boro yawas ana harew tit itatom”. ");
INSERT INTO aai_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Babin eo, “Aro, o taratarfuruwen men ibai ina naatu karakar ana sou i manin na’in ra’iy in. Karakar menatanamaim boro iti yawas ana harew inab? ");
INSERT INTO aai_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iti karakar i aki agir Jacob kair imaim ma tomatom, naatu ana haru ana for ouman. Iti karakar aki iti. O taiyuw ku’o’o, o Jacob inatabir? ");
INSERT INTO aai_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu iya’afut eo, “Orot babin etei iti harew natomatom boro sikan namamah maiye, ");
INSERT INTO aai_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","baise yait ayu harew anitin natomatom boro men sikan namamah. Naatu harew nati ayu anabitin boro wanawananamaim harew buruburur namatar. Naatu yawas’anaharew imaim na’in nitin, naatu yawas wanatowan nab. ");
INSERT INTO aai_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Babin Jesu isan eo,” Aro, harew nati ayu kwiti saise ayu men sikou namamaa nan naatu men mar etei iti’imaim harew huninamih anan.” ");
INSERT INTO aai_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu babin iu, “Kwen ku’af aaw isan naatu kumatabir kuna.” ");
INSERT INTO aai_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Babin iya’afut eo, “Ayu aawu en.” Jesu eo,” O aaw en ku’o’o i turobe.” ");
INSERT INTO aai_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Anababatun, o oro’orot etei five, i aa’awanen naatu orot iti boun airi kwama’am i men o aawamih. Abistan iti boun i’o’o i turobe.” ");
INSERT INTO aai_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Babin eo, “Aro, ayu ai’iti, o i dinab orot.” ");
INSERT INTO aai_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Aki ai a’agir iti oyawemaim hikwakwafir, baise kwa Jew kwa’o’o kwafiren efan i Jerusalemamaim tanakwafir.” ");
INSERT INTO aai_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu eorereb eo, “Babin ayu initutumu, veya i enan anamaramaim kwa boro men Tamat no oyawemaim o Jerusalemamaim kwanakwafir. ");
INSERT INTO aai_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kwa Samaria men kwaso’ob abistan kwakwakwafir, aki aso’ob abistan a kwakwafir, anayabin yawas i Jew sabuw biyahine na. ");
INSERT INTO aai_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Veya i enan naatu natitaka anamaramaim anababatun kwafirenayah boro Regah turobe naatu Anuninamaim hinakwafir, naatu kwafirinayah iti na’atube i boun Regah enunuwet. ");
INSERT INTO aai_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God i Anunin, naatu i ana kwafirenayah i turobe naatu Anuninamaim hinakwafir.” ");
INSERT INTO aai_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Babin eo, “Ayu nati Roubininenayan i aso’ob (Keriso terarouw) i enan. I nanan ana veya i boro sawar etei it isat nakubuna.” ");
INSERT INTO aai_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Imaibo Jesu eorereb eo, “Ayu i yait? Ayu yait airit ta’o’o.” ");
INSERT INTO aai_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesu eo oumatan, ana bai’ufununayah himatabir hina hitit naatu Jesu babin hairi hibidudur hi’itih hi’ororsa’ir. Baise men yait ta kok babin tibatiy, o Jesu hitibatiy, “Anayabin aisimamih babin airi kwabidudur?” ");
INSERT INTO aai_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Naatu babin ana harew hunihun ihamiy, i matabir in bar merar tit naatu sabuw nati’imaim hima’am hai tur eo’wen, ");
INSERT INTO aai_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Kwana tan orot kwa’itin, sawar abistanawat asisinaf etei’imak au tur eowen. Ta’itin i Roubinineyan wariten?” ");
INSERT INTO aai_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naatu bar merar hihamiy naatu sabuw etei ef hinuwet hin Jesu biyan hitit. ");
INSERT INTO aai_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nati ana veya’amaim ana bai’ufununayah hi’o, “Bai’obaiyenayan bay ta ku’aan ya kurutan!” ");
INSERT INTO aai_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Baise i isah eo, “Ayu au bay menamaim ana’ani’aan kwa men kafa’imo kwaso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Imih bai’ufununayah taiyuwih hima hi’o, “Ta’itin sabuw afa bay hibow hina hitin eaa wariten?” ");
INSERT INTO aai_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu eo, “Ayu au bay, i yait ayu biyafaru i anakok anabosiyasiyar anasinaf naatu bowabow ayu bitu i anabow anisawar. ");
INSERT INTO aai_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kwa iti na’atube kwa’o’o, ’Sumar kwafe’en o tafanamaim aki boro anafour’. Baise a tur ao’owen, Kwa matatoniwa’an me kwana’itin gewas naatu bay iyamur sawar fourin isan ana veya tit. ");
INSERT INTO aai_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Boun auman fourayan boro hibaiyan ana kabay nab, naatu bay four eya’ay ma’ama wanatowan isan, imih ta’itin tanumayan naatu fourayan i hairi auta’imon hiniyasisir. ");
INSERT INTO aai_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Abistan hi’o’o i turobe, “Orot ta’imon etatanum naatu orot ta’imon efafour”. ");
INSERT INTO aai_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","“Efan men imaim ima ibowabow, ayu aiyafari kwenan inafouramih naatu i hai fairamaim hibowabow o nonowatin inafour inaa’amih”. ");
INSERT INTO aai_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria moumurih maiyow nati bar merar Jesu hitumitum anayabin babin ana turamaim, “I ayu au sinaf etei eo anowar”. ");
INSERT INTO aai_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Imih anamaramaim Samaria sabuw hina Jesu biyan hititit, hifefeyan bairi ma isan, imih veya rou’ab bairi hima. ");
INSERT INTO aai_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sabuw moumurin maiyow hitumatum anayabin i ana turamaim, ");
INSERT INTO aai_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","naatu babin isan hi’o, “Aki bounabo abitumatum, men babin i’o isan, baise abistan tur eo’o aki taiyuwika taini anowar”. ");
INSERT INTO aai_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Veya rou’ab sasawar ufunamaim Jesu efan nati ihamiy, naatu au Galilee na’at misir in. ");
INSERT INTO aai_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Anayabin i taiyuwin isan eorereb eo, “Dinab orot taiyuwin ana tafaram sabuw isan men tekakakaf”. ");
INSERT INTO aai_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Imih anamaramaim na Galilee titit, sabuw ana merar hiyi hibai. Anayabin hin Jerusalem Tar Nowaten Hiyuw aa isan hiruru’ay, nati’imaim sawar abistanawat sinaf hi’i’itin isan. ");
INSERT INTO aai_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Naatu matabir maiye in Canna tit, nati Canna i Galilee wanawanan, imaim harew botabir wine mamatar. Naatu nati’imaim gawan ana orot ukwarin natun sawow Capernaumamaim inu’in. ");
INSERT INTO aai_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesu Judea’ane na Galilee tit ma’am ana tur na nowar. Misir in biyan tit ana tur eowen naatu ifefeyan i tare tan natun sawow inu’in tiyawas i kafa’imo namorob. ");
INSERT INTO aai_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu sabuw iuwih, “Kwa sabuw ina’inan naatu baifofofor kwana’itah, baise boro men kwanitumatum.” ");
INSERT INTO aai_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gawan ana orot ukwarin Jesu isan eo, “Aro, inare tananabo au kek namorob.” ");
INSERT INTO aai_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu orot isan eo, “Kwen! O a kek yawas ema’am!” Orot itumatum abistan Jesu tur isan eo naatu ana ef rura’ah in. ");
INSERT INTO aai_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I ra’iy inan efamaim ana akir orot bairi hitar naatu ana tur hi’owen, “O a kek i yawas ema’am ");
INSERT INTO aai_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naatu ibatiyih, Veya abistanamaim au kek yawas?” Naatu i hiya’afut hi’o, “Fai ouyit one korok na’atube imaim sawow ihamiy”. ");
INSERT INTO aai_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naatu imaibo tamah not nati ana veya Jesu eo, “O a kek i boro nayawas.” Imih nati ana baremaim hima’am etei hitumatum. ");
INSERT INTO aai_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iti ina’inan bairu’abin men tesinaf emamatar Jesu sinaf matar, no Judea’ane na au Galilee inan ufunamaim. ");
INSERT INTO aai_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Veya bai’ab sawar ufunamaim, Jew hai hiyuw aa isan Jesu yen in Jerusalem. ");
INSERT INTO aai_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem wanawanan efan wabin For Hirahir sisibinamaim i harew kukuf, naatu ana seboseb etei umatroun hiwowaben Aramek fanahimaim tisusu’ub Betsaida, ");
INSERT INTO aai_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","nati sebosebomaim sabuw sawusawuwih moumurin maiyow hiya hi’inu’in, matah fim, ah umah kafikafirih, naatu ah umah ririmih hima hikakaif harew tabi’etaw isan. ");
INSERT INTO aai_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Anayabin veya ta ta Regah ana tounamatar boro nara’iy harew kukuf nabenei niyabat rarouw nayen. Naatu sabuw sawow ana yumat ta ta hibow hina ti’inu’in, yait wan nara’iy nakifukif i boro nayawas. ");
INSERT INTO aai_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Orot ta sawow bai ma kwamur etei 38 i nati wanawanahimaim. ");
INSERT INTO aai_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesu nuw orot nati’imaim inu’in itin, naatu so’ob orot sawow nati bai virurumin maiyow, imih orot ibatiy, “O kukokok inayawas?” ");
INSERT INTO aai_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Orot iya’afut eo, “Regah, anamaramaim harew iyabat rarouw eyey, men yait ta boro nibaisu nabuwu anara’iy harew kukuf yan. Ayu misir ra’iyemih abiwa’an, sabuw afa i wan hira’iyeka.” ");
INSERT INTO aai_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Naatu Jesu orot isan eo, “Kumisir! A ir kunu naatu kuremor kwen.” ");
INSERT INTO aai_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mar ta’imon orot yawas; misir ana ir nu bat remor. Iti sawar mamatar i Baiyarir Ana Veya. ");
INSERT INTO aai_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Naatu Jew sabuw orot yayawas isan hi’o, “Iti boun i Baiyarir ana veya, ata ofafar men ebibasit o a ir ina’abar.” ");
INSERT INTO aai_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Baise iya’afutih eo, “Orot yait ayu biyawasu iuwu, ‘Kumisir a ir kunu naatu kubat kuremor.’” ");
INSERT INTO aai_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Imih hibatiy, “Nati orot i yait uwi a ir inu i’abar ibat kureremor?” ");
INSERT INTO aai_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Orot nati yayawas i men kafa’imo so’ob orot i yait, anayabin sabuw moumurin maiyow nati’imaim hibatabat Jesu sorabon in kasiy. ");
INSERT INTO aai_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nati ufunamaim Jesu Tafaror Bar wanawanan tita’ur naatu iu, “Kwi’itin, o iyawas. Bowabow kakafih inihamiyen o sawar kakafin anababatun boro biyamaim namatar.” ");
INSERT INTO aai_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Orot nati’imaim tit in, Jew sabuw hai tur eowen i Jesu iyawas. ");
INSERT INTO aai_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Imih hibusuruf Jesu isan turamaim hi’u hi’a’a’afiy, anayabin i Baiyarir ana veya sawar iti na’atube sinaf isan. ");
INSERT INTO aai_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesu isah eo, “Ayu Tamai i mar etei ebowabow, imih ayu auman boro anabow.” ");
INSERT INTO aai_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ana’an iti isan Jew hisinaftobon ef hinuwet Jesu asabunin isan; men Baiyarir ana ofafar ea’eastu’ub akisin, baise God isan Tamah rouw eo’omaim, iwa’an taiyuwin bai yen in God hairi anafofonin matar. ");
INSERT INTO aai_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesu iyafutih eo. “Turobe a tur ao’owen, Orot Natun akisin ana kok men karam nasinaf; baise Tamah abistan sinaf i i’itinimaim boro nasinaf, anayabin Tamah abistan isisinaf na’atube Natun isisinaf. ");
INSERT INTO aai_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Anayabin Tamah i Natun iyabuw sawar etei esisinaf na’atube Natun i’obaiy imaim esisinaf. Turobe, kwa a baifofofor isan, i boro sawar gagamihika ni’obaiy nasinaf men boun iti na’atube. ");
INSERT INTO aai_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamah murumurubih imisiruwih yawas ebitih na’atube, nati ef ta’imon Natun ekok yait yawas baitinamih boro nitin. ");
INSERT INTO aai_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","I na’atube Tamah men yait ta ebibatiy, baise baibabatiyen ana fair tutufin etei Natun itin. ");
INSERT INTO aai_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Saise sabuw etei Tamah tirurusagiy na’atube, Natun boro hinarusagiy. Imih o yait Natun men kururusagiy, Tamah, i ana baiyonenayan auman men kururusagiy. ");
INSERT INTO aai_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Turobe a tur ao’owen, o yait ayu au tur inowar naatu menatan ayu iyafaru anan kubitumitum, o i yawas ma’ama wanatowan ibaika, naatu o boro men baibatebat inab, anayabin morobone irabon yawas wanawanan irun. ");
INSERT INTO aai_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Turobe a tur ao’owen, veya i enan naatu i na titaka, nati ana veya murumurubih boro God Natun fanan hinanowar naatu iyab fanan hinanonowar boro yawas hinab hinama. ");
INSERT INTO aai_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Anayabin Tamah taiyuwin i yawas an, imih nati yawas ta’imon Natun itin yawas an matar. ");
INSERT INTO aai_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naatu i baibabatiyen ana fair Natun itin, anayabin i, i Orot Natun. ");
INSERT INTO aai_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Tur iti ao isan men kwana’ororsa’ir; veya i nati namamataramaim enan, murumurubih etei boro fanan hinanowar, ");
INSERT INTO aai_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hai rahane hinatit, naatu iyab gewasin hisisinaf boro hinamisir yawas hinab, iyab kakafih hinasisinaf boro hinakusairih.” ");
INSERT INTO aai_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ayu men karam akisu au kok ana sinaf, baise abisa God iu’uwu’umaim sabuw abibabatiyih, imih ayu au baibatiyen i mutufor, anayabin men ayu au kokomaim asisinaf, baise orot yait ayu iyunu anan i anakok asisinaf. ");
INSERT INTO aai_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ayu taiyuwu au sinaf isan ana’o’orereb na’at, au tur i men turobe’emih. ");
INSERT INTO aai_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Baise orot ta ayu isou eo’orereb, i a tur ao’owen i ana orereb ayu isou i turobe. ");
INSERT INTO aai_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kwaso’ob gewasomih kob abarayah John isan kwaiyafarih hinan John i turobe kwa a tur eowen. ");
INSERT INTO aai_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iti i men kwa orot maiyow isou kwataorereb, baise iti ao saise mi’itube kwa yawas kwatab isan. ");
INSERT INTO aai_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John i hinow na’atube to’ab marakaw kwa it, naatu mar kikimin kwa ana marakaw isan kwaiyasisir. ");
INSERT INTO aai_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Baise ayu au orererebayan orot i gagamin, men iti John eo’orereb na’atube. Ayu au orererebayan i abisa Tamai iyunu ana asisinaf i eo’orereb, naatu nati ebi’obaiyi ayu i Tamai iyafaru anasinaf isan, orot ta eo’orereb i John eo’orereb natabir, anayabin iti bowabow ayu Tamai bitu i anisawar, naatu iti bowabowamaim eo’orereb Ayu Tamai iyunu ana i ana bowabow anabow. ");
INSERT INTO aai_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naatu Tamai iyunu anan i taiyuwin ayu isou eo’orereb. Kwa men kafa’imo fanan kwanowar naatu yumatan kwa’itin. ");
INSERT INTO aai_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kwa ana tur men dogor wanawanan run, anayabin menatan ayu iyunu anan i men kwabitumitum. ");
INSERT INTO aai_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kwa Buk Atamaninamaim hikikirum kwaiyab kwabinotanot anayabin boro imaim yawas wanatowan kwanab. Nati tur i ayu isou eo, ");
INSERT INTO aai_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","baise men kwakokok kwanan ayu biyau yawas kwanab. ");
INSERT INTO aai_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ayu men orot babin bora’ara’ahu isan ao’omih. ");
INSERT INTO aai_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","baise kwa orot babin a yawas ayu aso’ob, kwa a yabow God isan dogoromaim i men ema’am. ");
INSERT INTO aai_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ayu Tamai wabinamaim anan kwa men kwabuwu au merar kwayi, baise orot babin ta i taiyuwin wabinamaim nanan boro kwanab ana merar kwanay. ");
INSERT INTO aai_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kwa taiyuw baifa’i isan a kok gagamin, baise God ta’imonamo ana baifa’en i men kwakokok, imih ayu abisa ao boro kwanitutumu? ");
INSERT INTO aai_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Men kwananot ayu boro Tamai nanamaim ubar kwa bait kwanarouw en, baise Moses kwa a not tutufin imaim kwayai kwama’am boro ubar nabit kwana’itin. ");
INSERT INTO aai_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses kwatabitumitum na’at, ayu boro kwatitutumu, anayabin i ayu isou kirum. ");
INSERT INTO aai_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Baise Moses abistan kikirum kwa men kwanabitumatum na’at, boro mi’itube ayu ao kwanitumatum?” ");
INSERT INTO aai_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nati ufunamaim ana veya ta, Jesu Galilee harew isobon rabon rewan rounane (wabin ta Taibirias kukuf.) ");
INSERT INTO aai_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Naatu sabuw rou’ay gagamin maiyow hi’ufunun hin anayabin sabuw sawusawuwih biyahimaim ina’inan sinaf biyawasih hi’itan isan. ");
INSERT INTO aai_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Naatu Jesu yen in oyaw sisibinamaim tit naatu ana bai’ufununayah hina biyanamaim himarir hima. ");
INSERT INTO aai_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jew sabuw hai Tar Nowaten hiyuw ana veya i na biyubin. ");
INSERT INTO aai_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu nuw ra’at sabuw rou’ay gagamin maiyow isan hinan itih, naatu Philip ibatiy, “Rafiy menamaim boro tanatobon iti sabuw tanituwih?” ");
INSERT INTO aai_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iti i Philip fufunin isan ibibatiy, anayabin i ana notamaim so’obaka i boro abistan nasinaf. ");
INSERT INTO aai_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip iya’afut eo, “Orot ana baiyan sumar eight ana fofonin tatab rafiy tatutubun sabuw ta’ita’imon tatabituwih i kikimin kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Imaibo ana bai’ufununayah orot ta, Andrew, Simon Peter tain awan tara’ah eo, ");
INSERT INTO aai_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kek ta iti’imaim rafiy afu’afusar umat roun naatu siy rou’ab umanamaim hima’am aitin. Baise anotanot boro men nakaram, sabuw i ra’at kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nati’imaim samar gewasin tuw inu’in, imih Jesu eo, “Sabuw kwa’uwih samar yan timarir. naatu sabuw samar yan himarir hima, naatu oro’orotowat hibiyab etei 5,000. ");
INSERT INTO aai_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesu faraw bai, God ana merar yi, naatu sabuw himarir hima’am faramih, siy bai ef ta’imon sinaf, etei hi’aa yah gadid hai fofonin bai. ");
INSERT INTO aai_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naatu hai fofonin baib ufunamaim, Jesu ana bai’ufununayah iuwih eo, “Hi’aa tuturih etei kwaita’ay, men ta kwanihamiy.” ");
INSERT INTO aai_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Basit hi’aa tuturih hi’o’on naatu kaifet hibiwanen etei 12, iti i rafiy fafar umat roun naatu siy rou’abamaim sabuw bituwih. ");
INSERT INTO aai_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iti ina’inan Jesu sinaf sabuw hi’i’itin ufunamaim hibusuruf hi’o, “Turobe iti orot i dinabamon, i namih hi’o’oban na tafaramamaim tit.” ");
INSERT INTO aai_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu itih so’ob boro kafa’imo hinan hinab naatu hinau’kikin ni’aiwob, imih i hamenamo nati efan ihamiy naatu akisinamo yen in oyaw wan. ");
INSERT INTO aai_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Veya re birabirab ana bai’ufununayah hire hin harew kukuf hitit, ");
INSERT INTO aai_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesu isan hima hikakaif mar bu’u’um, men na biyah tit, imih wa hibai hiboy hirabon au Capernaum. ");
INSERT INTO aai_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nati ana veya kotar bitufuwan wanawanan hin naatu yabat busuruf ra’at. ");
INSERT INTO aai_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hiboy hitit hire hikuyowen five o six kilometres na’atube hinuwanuw Jesu nahine riy yan bat remor wa isan nan hi’itin yah birubir fafar. ");
INSERT INTO aai_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Baise isah eaf eo, “Ayu o! men kwanabirumih!” ");
INSERT INTO aai_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Imaibo ereyasisir hiu na wa afe’en yen, naatu men yok efan hinot hinanamaim awar hiyut. ");
INSERT INTO aai_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Marto, sabuw rou’ay nati harew kukuf rounane hima hinunuwabon wa ta’imon nati’imaim batabat hi’inan, naatu hiso’ob Jesu i men nati wa’amaim isra’at bairi hinamih, baise ana bai’ufununayah akisihimo hinan hi’itih. ");
INSERT INTO aai_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Imaibo wa afa Taibiriasine hina efan nati Regah faraw bai igegewasin sabuw bituwih sisibinamaim hirun. ");
INSERT INTO aai_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Naatu sabuw wa afe’en hinunuwatet Jesu ana bai’ufununayah bairi men hi’it fa’arih, matah kabiy wa hibow au Capernaum na’at Jesu hinuwih hin. ");
INSERT INTO aai_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesu harew kukuf rewan rounane ma’am hitita’ur, naatu hibatiy, “Bai’obaiyenayan, biyika ina itit kuma’am?” ");
INSERT INTO aai_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu iyafutih eo, “Anababatun a tur ao’owen, ayu kwanunuwuhu i men ina’inan asisinaf kwa’i’itin isan, baise kwa rafiy kwa’aan ya gagadid isan ayu kwanuwuhu kwanan. ");
INSERT INTO aai_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bay nati eafe’af isan men kwanabowamih, baise ma’ama wanatowan ana bay isan i raro nanababan, nati bay i Orot Natun boro kwa nit. Anayabin God ayu Tamai ana baibasit nati bay roufaramin isan ana fair ayu itu.” ");
INSERT INTO aai_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Imaibo Jesu hibatiy, “Bo aki boro mi’itube anasinaf saise God abistan eo imaim anasinaf?” ");
INSERT INTO aai_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu iyafutih eo, “God ana bowabow bow isan i iti. Orot yait God biyafar i kwanitumitum. ");
INSERT INTO aai_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Imih i hibatiy, “Ina’inan fairin menatan boro inasinaf aki ana’itin naatu o anitutumi? O boro abistan inasinaf? ");
INSERT INTO aai_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","It ata a’agir arar yanamaim i rafiy wabin manna hi’aa; Buk Atamaninamaim hikirum hi’o’o na’atube, I mar ana rafiy itih hi’aa.” ");
INSERT INTO aai_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Naatu Jesu hai tur eowen eo, “Anababatun a tur ao’owen, “Iti mar ana rafiy kwa kwa’ani’aan i men Moses kwa itimih, baise ayu Tamai rafiy anababatun marane kwa it. ");
INSERT INTO aai_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anayabin God ana rafiy i orot yait marane rara’iy sabuw etei tafaram wanawanan yawas ebitih.” ");
INSERT INTO aai_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sabuw hi’o, “Regah iti rafiy i mar etei initi ana’aan.” ");
INSERT INTO aai_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Imaibo Jesu iuwih eo, “Ayu i yawas ana rafiy. Orot Yait ayu isou enan i boro men kafa’imo bayumih namorob, naatu orot yait ayu isou ebitumatum boro men kafa’imo sikan namamahimih.” ");
INSERT INTO aai_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naatu iti tur i ao kwanowaraka naatu mata yan kwa’i’itin baise men kafa’imo kwabitutumu. ");
INSERT INTO aai_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sabuw iyabowat ayu Tamai bitu boro ayu isou hinan, naatu orot babin yait ayu isou enan boro men ananun ufun natitamih. ");
INSERT INTO aai_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anayabin ayu marane arara’iy, i men ayu au kok sinaf isanamih, baise orot yait ayu iyunu anan i ana kok anasinaf. ");
INSERT INTO aai_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Naatu orot yait ayu iyunu anan ana kok i iti, sabuw iyabowat ayu bitu etei men ta anikasiy, baise mar yomaninamaim etei’imak anabuwih hinamisir. ");
INSERT INTO aai_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Anayabin ayu Tamai ana kok i sabuw iyab matah etei Natun akisin ti’i’itin naatu tibitumitum boro ma’ama wanatowan ana yawas hinab; naatu mar yomaninamaim ayu boro anabuwih hinamisir. ");
INSERT INTO aai_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Imaibo Jew sabuw hibusuruf Jesu isan higam, anayabin i eo, “Ayu i mar ana rafiy. ");
INSERT INTO aai_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Basit sabuw hi’o, “Iti orot i Jesu, Joseph natun, hinah tamah i taso’ob. Naatu baise boun i eo’o, Ayu i marane ara’iy.” ");
INSERT INTO aai_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu iyafutih eo, “Taiyuw men kwanagam. ");
INSERT INTO aai_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sabuw boro men ayu isou hinan kwaneyan, baise Tamai ayu iyunu anan boro nabonawiyih hinan ayu biyau hinatit; naatu mar yomaninamaim ayu boro ana bora’ahih hinamisir. ");
INSERT INTO aai_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dinab oro’orot hikirum hi’o na’atube, ‘Sabuw etei boro God ni’obaiyih. Orot yait Tamai fanan nowar naatu biyanane so’ob ebaib boro ayu isou nan. ");
INSERT INTO aai_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Men yait ta Tamai itin; baise orot yait Godane nan i akisinamo Tamai itin. ");
INSERT INTO aai_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Turobe a tur ao’owen, orot yait ebitumatum, yawas wanatowan i baika. ");
INSERT INTO aai_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ayu i yawas ana rafiy. ");
INSERT INTO aai_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kwa a’a’agir hai veya, rafiy wabin manna arar yanamaim hibow hi’aa, baise etei himorob. ");
INSERT INTO aai_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Baise rafiy iti i marane ra’iy, sabuw iyab hinab hina’ani’aan boro men hina morob. ");
INSERT INTO aai_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ayu i yawas ana rafiy, marane hiyafaru are. Orot babin yait iti rafiy na’ani’aan na’at boro nama wanatowan. Iti rafiy i ayu finimu boro anit, saise sabuw boro tafaramamaim yawas hinab hinama.” ");
INSERT INTO aai_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naatu Jew sabuw iti tur hinonowar isan yah so’ar hibusuruf taiyuwih wanawanahimaim higam hikwaris hio, “Iti orot biyan finimin boro mi’itube nitit tana’animih eo?” ");
INSERT INTO aai_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu iuwih eo, “Turobe a tur ao’owen, Orot Natun biyan finimin men kwana’aan naatu ana rara men kwanatomatom, kwa wanawanamaim yawas men ema’am. ");
INSERT INTO aai_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Orot yait ayu biyou finimin na’aan naatu au rara natomatom yawas wanatowan i bai, naatu yomaninamaim ayu boro ana bora’ah namisir. ");
INSERT INTO aai_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anayabin ayu biyou finimin i bay anababatun naatu au rara i harew anababatun, ");
INSERT INTO aai_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","orot babin yait ayu biyou finimin na’aan naatu au rara natomatom boro wanawana’umaim nama naatu ayu i wanawananamaim anama. ");
INSERT INTO aai_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamat yawas ana’an i ayu iyunu ana, anayabin i ema’am isan imih, ayu auman ama’am, ef ta’imonaban orot yait ayu biyau’umaim bai eani’aan boro yawasin nama anayabin ayu ama’am isan imih. ");
INSERT INTO aai_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iti rafiy marane rara’iy i men kwa a a’agir manna hi’aa hibimumurub na’atube’emih, baise o yait iti rafiy boun marane rara’iy inab ina’ani’aan boro inama wanatowan.” ");
INSERT INTO aai_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tur iti etei i Capernaum Kou’ay Bar wanawananamaim ma sabuw hai tur eowen i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesu ana bai’ufununayah moumurin na’in tur iti hinonowar hi’o, “Iti bai’obaiyen i fokarin. Yait boro iti tur nanowar nab?” ");
INSERT INTO aai_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Baise Jesu ana bai’ufununayah abisa isan hio higamigam so’ob naatu iuwih eo, “Tur iti kwanonowar imaim kwa a naniyan ebi’afiy? ");
INSERT INTO aai_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bo Orot Natun nayen ana efan marasika ma’am imaim nama kwana’itin boro mi’itube kwanao! ");
INSERT INTO aai_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anun Kakafiyin i yawas ebit biyat i aurin fair en. Iti tur kwa isa a’o i ayub ana tur naatu wanawananamaim i yawas ema’am. ");
INSERT INTO aai_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Baise kwa afa iti kwama’am i men kwabitumatum. Anayabin iyab men hinabitumatum naatu orot yait baban na’o Jesu so’obaka.” ");
INSERT INTO aai_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ibanak eo maiye, “Anayabin iti isan kwa au’uwi, orot babin boro men asir ayu isou nan kwaneyanamih, baise Tamai ana baibasitamaim boro niwa’an isah naham hinan ayu isou.” ");
INSERT INTO aai_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nati ana veya’amaim ana bai’ufununayah moumurih na’in hihamiy naatu himatabitabir hina’ufut hin. ");
INSERT INTO aai_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesu ana bai’ufununayah nah 12 ibatiyih. “Kwa auman kwakokok kwanan?” ");
INSERT INTO aai_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter iya’afut eo, “Regah yait isan boro anan? Yawas wanatowan ana tur o akisimo biya ema’am. ");
INSERT INTO aai_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aki abitumatum naatu aso’ob o i Kakafiyin Ta’imon Godane ina.” ");
INSERT INTO aai_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Imaibo Jesu iyafutih eo, “Kwa na 12, i ayu arubini, baise kwa wanawanamaim orot ta i demon mowan.” ");
INSERT INTO aai_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Jesu iti tur eo’o i Judas Simon Iscariot natun isan, Judas i bai’ufununayan nah 12 wanawanahimaim orot ta, yomaninamaim i boro Jesu nayanuw namorob.) ");
INSERT INTO aai_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nati ufunamaim Jesu Galilee wanawanan run titit remor in, men kok au Judea tan anayabin Jew hai ukwarih hima hikakaif hitarab tamorob isan. ");
INSERT INTO aai_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Baise Jew sabuw Yagama Sis ana hiyuw aa ana veya i nabiyubin, ");
INSERT INTO aai_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Imih Jesu taitin hi’o, “O boro efan iti inihamiy naatu inan Judea inatit, saise a bai’ufununayah bowabow gewasih abistan kusisinaf hina’itin. ");
INSERT INTO aai_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Anayabin orot yait sabuw etei su’ubin isan boro men wa’iwa’iramaim nabowamih. Baise bebeyanamaim nabow hina’itin. Imih a bowabow bebeyanamaim inabow tafaram tutufin etei ini’obaiyih hina’itin.” ");
INSERT INTO aai_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","I taiyuwin taitin men hitumitum, imih iti tur hi’o. ");
INSERT INTO aai_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Naatu Jesu iuwih eo, “Ayu au veya i men na tit, baise kwa a veya i mar etei bobotawiyen inu’in. ");
INSERT INTO aai_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sabuw kwa boro men hinifutuwi, baise ayu boro hinifutuwu, anayabin ayu mar etei sabuw hai kakafih ao’orerereb. ");
INSERT INTO aai_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hiyuw isan kwa akis kwanan ayu men bairit tanan, anayabin ayu au veya anababatun i men na tit.” ");
INSERT INTO aai_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iti na’atube eo, i Galilee wanawananamaim ma. ");
INSERT INTO aai_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Taitin hiyuw isan hiyen hinan, i auman ufuh yen in, men bebeyanamaim in baise i wa’iwa’iramaim in. ");
INSERT INTO aai_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nati hiyuw wanawanan Jew hai ukwarih Jesu isan hinuwet sabuw hibabatiyih, “Iti orot menamaim ema’am?” ");
INSERT INTO aai_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sabuw wanawanahimaim baitarsibesib busuruf ra’at. Sabuw afa hi’o, “I orot gewasin,” afa hi’o, “Aiyabin i sabuw ebifufuwih?” ");
INSERT INTO aai_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Baise men yait ta boro fanan aumetawat isan hitao, anayabin Jew ukwarih isah hibir. ");
INSERT INTO aai_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hiyuw hi’aa na biyanfoun, Jesu na Tafaror Bar run naatu bai’obaiyen busuruf. ");
INSERT INTO aai_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jew hai ukwarih hifofofor men kafai ta naatu hi’o, “Iti orot menamaim kirum iti so’ob bai?” ");
INSERT INTO aai_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Imaibo Jesu iyafutih eo, “Bai’obaiyen ayu abi’obaiyi i men ayu nowau, baise God ayu biyafaru i nowan. ");
INSERT INTO aai_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","O Yait ta God anakok kusisinaf boro inaso’ob ayu au bai’obaiyen i Godane enan, ai ayu taiyuwu au fairamaim ao’o. ");
INSERT INTO aai_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yait taiyuwin ana fairamaim eo’o, i taiyuwin ana gewasin bain isan enunuwih, baise orot yait God ayu iyafaru anan ana gewasin enunuwih nati orot i turobe, i wanawananamaim men baifuwen ema’am. ");
INSERT INTO aai_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ofafar kwa it ai en? Aisim ofafafar men kwabi’ufunun naatu ayu rabu morobomih kwabiwa’an?” ");
INSERT INTO aai_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sabuw hiya’afut hi’o, “O wanawan i demon tema’am. Yait o asabunimih ebiwa’an?” ");
INSERT INTO aai_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu iya’afutih eo, “Ayu ina’inan ta’imon asinaf kwa’itin naatu kwaifofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses uwi natunat oro’orot Baiyariri hai veya’amaim hai ar, mo’oh kwa’afuw, nati i men Mosesine na, nati i kwa a’agir wabih gagamihine na. Imih kwa kek oro’orot hai ar mo’oh kwa’a’afuw. ");
INSERT INTO aai_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kwa Baiyarir ana veya’amaim kek orot ana ar mo’on kwana’a’afuw nati Moses ana ofafar i men kwa’a’astu’ub, aisimamih ayu Baiyarir Ana Veya orot biyan tutufin abiyawas isan kwa ya esoso’ar? ");
INSERT INTO aai_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Men ufun ana’itininamaim sabuw kwanibabatiyih, baise a baibabatiyen i turobe’emaim kwanibatiyih.” ");
INSERT INTO aai_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nati isan Jerusalem sabuw afa hibusuruf hibatebat hi’o, “Orotoban iti i boun rabin morobomih ana ef tenunuwet? ");
INSERT INTO aai_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kwa’itin iban iti bebeyanamaim eo’o, naatu i men tur ta isan te’eo’omih. Kwa kwanotanot sabuw ukwarihiban hiso’ob gewas iti orot i turobe Rourubinen? ");
INSERT INTO aai_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Baise iti orot menane nan i aki aso’ob; Rourubinen nanan anamaramaim boro men yait ta naso’ob i menane na.” ");
INSERT INTO aai_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Imaibo Jesu Tafaror bar wanawanan ma bi’obaibiyih fanan aumetawat na’in eo, “Turobe ayu kwa kwaso’ob, naatu menane anan kwa kwaso’ob? Ayu iti anan i men taiyuwu au kok ana, baise turobe ana God ayu iyunu ana. Nati orot kwa men kwaso’ob ");
INSERT INTO aai_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ayu asu’ub, anayabin ayu ine ana naatu i iyunu ana.” ");
INSERT INTO aai_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nati’imaim sabuw bain fatuminamih hiwa’an, baise men yait ta biyan butubun, anayabin ana veya i men natit. ");
INSERT INTO aai_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Baise rou’ay gagamin wanawanan sabuw moumurin maiyow hitumitum naatu hi’o, “Rourubinen nanan ina’inan fairih moumurihika nasinaf iti orot boro nanatabir.” ");
INSERT INTO aai_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Rou’ay wanawanan Jesu sawar sisinaf isan hibitarsibesib Pharisee hinowar. Basit firis gagagamih naatu Pharisee Tafaror Bar ma’utayah hiyafarih hin Jesu bain fatuminamih. ");
INSERT INTO aai_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Imih Jesu eo, “Ayu boro men manin bairit tanama, naatu anamatabir maiye anan yait iyunu anan biyan anatit. ");
INSERT INTO aai_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kwa boro ayu kwananuwuhu, baise boro men kwanatita’uru, naatu ayu menamaim anama’am, kwa boro men kwanan.” ");
INSERT INTO aai_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jew sabuw taiyuwih hima hi’o, “Iti orot boro menamaim nan nama naatu it men karam tanatita’ur? Ai i boro nan Greek wanawanah ata sabuw hitagey nanabin tema’am imaim nama ni’obaibiyih? ");
INSERT INTO aai_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kwa boro ayu isou kwananuwet baise boro men kwanatita’uru naatu ayu menamaim anama’am kwa boro men kwanan? Iti tur eo’o anayabin i abisa?” ");
INSERT INTO aai_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hiyuw gagamin hi’aa sasawar ana yomanin, Jesu misir naatu fanan aumetawat na’in eo, “Yait ta sikan namamamah, kwanihamiy nan ayu biyau harew natom! ");
INSERT INTO aai_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yait ayu inabitutumu na’at kuna biyau harew kutom. Buk Atamaninamaim eo na’atube ‘Harew yawasin boro o wanawananamaim nanunuw.’” ");
INSERT INTO aai_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iti tur i sabuw iyab Jesu hinibitumitum Anun Kakafiyin hinabaib i isah eo. Iti boun ana veya Anun Kakafiyin i men yait itin bai, anayabin Jesu i men Tamah ana aiwob itinimih. ");
INSERT INTO aai_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Rou’ay wanawanan hima tur hinonowar sabuw afa hi’o, “Anababatun iti orot i God ana dinab orot.” ");
INSERT INTO aai_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Afa hi’o, “Iti orot i Rourubinen.” Naatu sabuw afa ibanak hi’o, “Rourubinen ana orot i boro men Galilee’ine nan? ");
INSERT INTO aai_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buk Atamaninamaim eo Rourubinen i boro aiwob orot David ana rara’ane naatu boro Bethlehem David ana bar meraramaim.” ");
INSERT INTO aai_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Imih nati kou’ay wanawanan kouseb matar anayabin Jesu isan. ");
INSERT INTO aai_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sabuw afa hikok hitab hitafatum, baise men yait ta biyan butubun. ");
INSERT INTO aai_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Imaibo Tafaror bar ma’utenayah himatabir hin firis ukwarih naatu Pharisee biyah hitit naatu firis ukwarih himisir ma’utenayah hibatiyih, “Aisimamih men kwa bai kwana kwatit?” ");
INSERT INTO aai_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma’utenayah hiya’afutih hi’o, “Iti orot tur eo’o, i men orot afa te’eo na’atube eomih!” ");
INSERT INTO aai_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisee hibatiyih, “Kwa kwa’o anananiyan kwa auman ifuwi ebobonawiyi kakaf i?” ");
INSERT INTO aai_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Kwata’itin ukwarih afa o Pharisee orot afa tur hinonowaraban Jesu hitumitum? ");
INSERT INTO aai_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aiyabin! Iti rou’ay Moses ana ofafar i men ta hiso’ob, imih i God ana orarafen baban tema’am!” ");
INSERT INTO aai_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","I taiyuwih hai orot ta wabin Nicodemus i wan in Jesu biyan tit, ");
INSERT INTO aai_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Imih i ana kou’ay ibatiyih, “It ata ofafar eo orot anasinaf kakaf i wan tananuwet imaibo tanab tanan ata ofafaramaim tanibabatiy.” ");
INSERT INTO aai_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hiya’afut hi’o, “Nicodemus o auman i Galilee orot? Baise Buk Atamaninamaim inanunuwet boro men inatita’ur, dinab orot i men Galilee’ine na.” ");
INSERT INTO aai_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Naatu rou’ay hima’am hitarboubun himisir hai bar hai bar hin.) ");
INSERT INTO aai_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Imaibo Jesu Olive Oyaw na’at tit yen in. ");
INSERT INTO aai_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Maraumanika Jesu matabir maiye Tafaror Bar ana meraramaim bat, sabuw moumurin maiyow hiru’ay hi’arbebera’uh naatu i busuruf ma sabuw i’ubaibiyih. ");
INSERT INTO aai_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ofafar bai’obaiyenayah naatu Pharisee babin turan aawan hairi hi’inu’in hibai hina hirun. Naatu hi’u kou’ay nahimaim bat. ");
INSERT INTO aai_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naatu Jesu isan hi’o, “Bai’obaiyenayan, iti babin i turan aawan hairi hi’inu’in atita’ur. ");
INSERT INTO aai_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ofafaramaim Moses aki iti na’atube eobaiyuni, babin yait ta iti na’atube nasisinaf boro kabayamaim anarab namorob. O a not ta ema’am boro inao.” ");
INSERT INTO aai_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iti baibat hibai hititit i mi’itube Jesu hitikubibiruw, saise abitur ta’o na’at imaim hitabat ubar hititin isan. Baise Jesu kwafure fofob yan uman kimamaim ma kubebebeyan. ");
INSERT INTO aai_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hi’u hibibabatiy anamaramaim, Jesu nakwetan tara’ah naatu isah eo, “O yait aur bowabow kakafin men nama’am na’at, o wan kabay kubai babin isan kurouw.” ");
INSERT INTO aai_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Naatu i kwafure maiye me yan ma kubebebeyan. ");
INSERT INTO aai_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iti tur hinonowar anamaramaim ta’ita’imon hitabartaitit hin, oro’orot atamanih wan hi’iyon hibusuruf hitit. Babin akisinamo hihamiy Jesu nanamaim bat ");
INSERT INTO aai_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu totofar misir babin itin basit isan eo, “Babin iti sabuw menika hin? Naatu yait ta o isa rouw’ouri ai en?” ");
INSERT INTO aai_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Babin eo, “Regah men yait ta ema’am.” Naatu Jesu eo, “Basit gewasin! Ayu auman men karam boro anibatiyi. Kwen, iti boun inabubusuruf bowabow kakafih men inasinaf maiye.” ");
INSERT INTO aai_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesu sabuw isah eo maiye, “Ayu i tafaram ana marakaw. Yait ayu ebi’ufnunu i boro men guguminamaim naremor, baise i boro yawas ana marakaw nab.” ");
INSERT INTO aai_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee Jesu isan hi’o, “Iti tur ku’o’o i o taiyuw isa ku’o’orerereb naatu abistan o ku’o’orerereb i men turobe.” ");
INSERT INTO aai_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu iyafutih eo, “Ayu taiyuwu isou ana’orerereb na’at, ayu ao’orereb i turobe, anayabin ayu aso’ob menane ana naatu menamaim ananan. Baise ayu menane ana naatu menamaim ananan kwa i men kwa so’ob. ");
INSERT INTO aai_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kwa sabuw hai itininamaim kwa’itih kwabibabatiyih. Ayu men yait ta ana itininamaim aitin abibabatiyimih. ");
INSERT INTO aai_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Baise ayu anabibatiyi na’at, ayu au baibatiyen i turobe. Anayabin ayu i men akisu. Ayu Tamai iyunu anan i airi ama’am. ");
INSERT INTO aai_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kwa taiyuw a’ofafaramaim iti na’atube hikirum, anamaramaim sifroubonayan orot rou’ab te’orereb tebibasit nati i turobe. ");
INSERT INTO aai_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ayu i orot ta taiyuwu isou ao’orereb; Tamai ayu iyunu anan ayu au sifroubounayan ta.” ");
INSERT INTO aai_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naatu sabuw hibatiy, “O Tamat i menamaim ema’am?” Jesu iyafutih eo, “Kwa ayu men kwaso’ob na’atube Tamai auman men kwaso’ob. Kwa ayu kwatasusu’ubu na’at Tamai auman boro kwatasu’ub.” ");
INSERT INTO aai_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iti tur i tafaroror bar wanawanan kabay teya’ay ana efan sisibinamaim Jesu ma i’obaibiyih. Men yait ta bai fatumimih, anayabin i ana veya men baimih. ");
INSERT INTO aai_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesu ibanak isah eo maiye, “Ayu boro kwa anihamiyi anan, naatu kwa boro ayu isou kwananuwet naatu kwa a kakafih wanawanahimaim boro kwanamorob. Ayu menamaim ananan kwa boro men imaim kwanan.” ");
INSERT INTO aai_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naatu Jew hai ukwarih hi’o, “I eo, ayu menamaim anan kwa men karam kwanan. Iti eo anayabin i boro taiyuwin na’asabun?” ");
INSERT INTO aai_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Baise Jesu eo maiye in, “Kwa i babe ma’ani, Ayu i yate ma’anu. Kwa i tafaram nowan, baise ayu i men tafaram nowan. ");
INSERT INTO aai_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ayu ao kwanowaraka, ayu men kwanasu’ubu kwanabitutumu na’at, kwa boro anababatun a kakafih wanawanahimaim kwanamorob. Ayu’uban tur iti ao’o.” ");
INSERT INTO aai_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hibatiy hio, “O i yait?” Jesu iyafutih eo, “Tabubusurufika kwa a tur aowen taremor tana. ");
INSERT INTO aai_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kwa isa ayu boro tur moumurika anao anibabatiyi. Baise yait ayu iyunu anan i turobe? Naatu abistan i eo anonowar ayu sabuw hai tur ao’owen.” ");
INSERT INTO aai_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesu Tamah isan sabuw hai tur eo’eowen naniyan men hibai. ");
INSERT INTO aai_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Imih Jesu eo, “Orot Natun kwanabobora’ah anamaramaim, kwa boro kwanaso’ob; Ayu i Yait; naatu ayu men taiyuwu au kokomaim asisinafumih, baise Tamai abistan tur mutufor bi’obaiyu’umaim ao’o. ");
INSERT INTO aai_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Naatu yait ayu iyunu anan airi ama’am i men ihamiyu, anayabin mar etei i ana kokomaim asisinaf isan ebiyasisir.” ");
INSERT INTO aai_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nati eo’omaim sabuw moumurih maiyow hitumitum. ");
INSERT INTO aai_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Imih Jesu Jew sabuw iyab i hibitumatum isah eo, “Ayu au bai’obaiyen kwanabubukikin na’at, kwa i anababatun ayu au bai’ufununayah, ");
INSERT INTO aai_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","naatu kwa boro turobe kwanaso’ob naatu turobe boro imaim narufami kwanatit.” ");
INSERT INTO aai_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sabuw hiya’afut hi’o, “Aki Abraham ana a’agir. Naatu aki men yait ta ana akir wairafin. Mi’itube inarufami anatit isan kuo’o?” ");
INSERT INTO aai_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu sabuw isah eo, “Turobe a tur ao’owen, o yait ta bowabow kakafin kukusisinaf i bowabow kakafin ana akir wairafin imatar. ");
INSERT INTO aai_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Akir wairafin taitin tuwahinah wanawanahimaim i boro namarorore, baise Natun i ana efan wanatowan. ");
INSERT INTO aai_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imih Natun kwa narurufami, kwa i anababatun narufami, ");
INSERT INTO aai_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ayu aso’ob kwa i Abraham ana a’agir, baise kwa i ef kwanunuwet ayu kwana’asbunu. Anayabin kwa dogor wanawanan, ayu au tur ana efan i men ema’am. ");
INSERT INTO aai_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ayu Tamai ana taragub wanawanan abistan i’obaiyu ai’itin i a tur ao’owen, naatu kwabo tamat demon hi’o kwanonowar na’at kwasisinaf.” ");
INSERT INTO aai_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sabuw hiya’afut hi’o, “Abraham i aki tamai.” Jesu eo maiye, “Kwa Abraham natunatun na’at kwa boro i sisinafube kwatasinaf. ");
INSERT INTO aai_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Itinin i iti. God anababatun au tur eowen ao kwanonowar isan kwa a not kwabobaifufun ayu asabunu’umih. Abraham iti na’atube men sinaf. ");
INSERT INTO aai_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kwa tamatanah mi’itube hisisinaf na’atube kwasisinaf.” Sabuw hiya’afut hi’o, “Aki Tamai i ta’imon God akisinamo, aki i men ometakek aki i natunatun anababatun.” ");
INSERT INTO aai_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu sabuw isah eo, “God kwa Tamat na’at ayu boro kwatiyabuwu, anayabin ayu Godane ana naatu boun iti bairit tama’am. Ayu men taiyuwu au kokomaim anamih, baise i ayu iyunu ana. ");
INSERT INTO aai_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aisimamih ayu tur ao’o naniyan men kwabaib? Abistan ayu ao men kwananonowar anayabin kwa tain i gugurih. ");
INSERT INTO aai_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kwa i tamat demon mowan natunatun, naatu kwa a kok i tamat esisinafube kwani’ufunun. Aneika i asbunubunuwenayan, i men turobe’emaim batamih, anayabin i wanawanan turobe en. Baifufuwen nati i ana tur, anayabin i baifufuwenayan naatu baifufuwenayah etei tamah. ");
INSERT INTO aai_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Baise ayu tur anababatun ao’o, kwa i men kwabitutumu. ");
INSERT INTO aai_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","O yait ta karam ayu au kakafin inaorerereb? Ayu turobe ana’o na’at, aisim men kwabitutumu? ");
INSERT INTO aai_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yait Godamaim ema’am naatu ana tur enonowar i i God nowan. Kwa tur men kwanonowar anayabin Kwa i men God nowan.” ");
INSERT INTO aai_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jew sabuw Jesu hiya’afut hi’o, “Aki’ima turobe ao’o, oma Samaria mowan naatu demon hitounbuburi kuma’am.” ");
INSERT INTO aai_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu iya’afutih eo, “Ayu men demon hitounbuburu ama’am. Ayu Tamai akisinamo akakakafiy, baise kwa ayu men kwakakafiyu. ");
INSERT INTO aai_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ayu men taiyuwu wabu bora’ara’ahin isan anunuwet, baise orot ta i ayu isou akisinamo nanuwet naatu i boro ayu nibabatiyu. ");
INSERT INTO aai_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tur anababatun au’uwi, yait ayu au tur ebobosiyasiyar boro men namorob.” ");
INSERT INTO aai_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jew sabuw Jesu isan hi’o, “Aki bounabo aso’ob o i demon hitoububuni kuma’am! Abraham morob naatu dinab oro’orot himorob, baise o ku’o’o yait ta ayu au tur nabobosiyasiyar boro men namorob. ");
INSERT INTO aai_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aki tamai Abraham i morob o men taiyuw inabora’ahi Abraham inanatabir? Naatu God ana dinab auman himorob. O kunotanot o i yait?” ");
INSERT INTO aai_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu iya’afutih eo, “Ayu taiyuwu anabobora’ahu na’at ayu au bora’ara’aten anayabin en. Ayu Tamai kwa a God kwarouw kwa’o’o i akisinamo ayu ebobora’ara’ahu. ");
INSERT INTO aai_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kwa i men kafa’imo kwasu’ub, baise ayu asu’ub. Ayu men su’ubin anarouw ana’o na’at, ayu boro baifuwenayan kwa ana karam, baise ayu i asu’ub naatu i ana tur abobosiyasiyar. ");
INSERT INTO aai_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kwa tamat Abraham ayu au na ana veya nuw i’itin i iyasisir naatu veya na titit isan i kawasa.” ");
INSERT INTO aai_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jew sabuw Jesu isan hi’o, “O a kwamur i men 50 baimih naatu mi’itube Abraham i’itin.” ");
INSERT INTO aai_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu iyafutih eo, “Anababatun a tur ao’owen, ayu wan ama’abo Abraham tufuw.” ");
INSERT INTO aai_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nati isan sabuw kabay hi’o’on Tafaror Bar wanawanan hitarabimih baise Jesu sabuw umah aren sorabon ufun tit. ");
INSERT INTO aai_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Orot matan fim auman tufuw ma’am Jesu remor inan itin. ");
INSERT INTO aai_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ana bai’ufununayah Jesu hibatiy, “Bai’obaiyenayan, yait ana kakafinamaim iwa’an iti orot matan fim auman tufuw? I taiyuwin ana kakafin o i hinah tamat hai kakafinamaim?” ");
INSERT INTO aai_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu eo, “Orot matan fim i men anabowabow kakafinamaim iwa’an matan ifimemih o i hinah tamah hai kakafinamaim, baise i ana fimemaim God ana fair iti orot biyanamaim nirerereb hina’itin. ");
INSERT INTO aai_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iti ana veya’amaim yait ayu iyunu anan i ana bowabow tanabow, gugumin i enan men karam yait ta nabow. ");
INSERT INTO aai_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ayu boun iti tafaramamaim ama’am, ayu i tafaram ana marakaw.” ");
INSERT INTO aai_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iti tur eo ufunamaim, Jesu kwei me yan re naatu iyuriyur bai bora’ah orot matan idadawir. ");
INSERT INTO aai_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Naatu iu, “Kwen harew Siloam kukuf (nati wab anayabin iyafar) imaim kururub.” Imih orot in rurub naatu matan nuw sawar itah auman matabir au bar in. ");
INSERT INTO aai_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Orot tain tuwan naatu sabuw afa marasika hi’i’itin ma fefefeyan, hibatiy, “Iti orot ta’imon mar etei ema efefefeyanaban i iti?” ");
INSERT INTO aai_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sabuw afa hi’o, “Orot i nati.” Afa hi’o, “En nati i ana yumatabe.” Baise orot taiyuwin eo, “Nati orot i ayu.” ");
INSERT INTO aai_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sabuw hibatiy, “Mi’itube o mat igewasin kunuwanuw?” ");
INSERT INTO aai_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Orot iyafutih eo, “Orot wabin te’o Jesu i yur bai matou idadawir naatu na Siloam harew kukufamaim rurubamih iuwu. Imih ayu an arurub, naatu matou to iwa’an anuwanuw.” ");
INSERT INTO aai_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sabuw hibatiy, “Bo iti orot i menamaim ema’am?” Orot iya’afutih eo, “Ayu men aso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nati orot Jesu biyawas hibai hina Pharisee biyah hitit. ");
INSERT INTO aai_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Baiyarir ana veya’amaim Jesu nati orot matan fim yuramaim idawir matan igewasin nuw. ");
INSERT INTO aai_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Isan imih Pharisee ibanak maiye orot hibatiy mi’itube matan igewasin. Orot hai tur eowen eo, “I yuramaim matou idadawir uwu harewamaim arurub naatu boun i anuwanuw.” ");
INSERT INTO aai_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisee afa hi’o, “Iti orot i men Godane na, anayabin Baiyarir ana ofafar i men ekakaif.” Baise afa hi’o, “Bowabow kakafin orot boro mi’itube iti ina’inan tasinaf?” Naatu nati’imaim kouseb matar. ");
INSERT INTO aai_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Imih Pharisee hitatabir orot ibanak hibatiy maiye, “Iti orot o mata iwa’an bigewasin isan o boro mi’itube inao?” Orot iya’afutih eo, “I i dinab orot.” ");
INSERT INTO aai_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jew hai ukwarih men kafa’imo hititumatum iti orot matan fim ma’am naatu bounabo matan nuw, naatu orot hinah tamah isah hi’af hina, imaibo hibatiyih. ");
INSERT INTO aai_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Iti orot i kwa natu? Kwa kwa’o’o i matan fim auman tutufuw kekeban iti? Naatu boun i mi’itube enuwanuw?” ");
INSERT INTO aai_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hinah tamah hiyafutih hi’o, “Aki aso’ob iti kek i aki natu, naatu matan fim auman tufuw. ");
INSERT INTO aai_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Baise aki men aso’ob, boun i mi’itube enuwanuw, o yait matan iwa’an igewasin, kwaibatiy i sanaman, karam taiyuwin isan boro nao.” ");
INSERT INTO aai_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hinah tamah iti tur hi’o, i Jew sabuw isah hibir, anayabin iti tur i marasika Jew ukwa’ukwarih hi’o hibasit, yait Jesu isan naorereb Keriso nararauw boro kou’ay barene hinabotait ufun nama. ");
INSERT INTO aai_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iti isan imih i hinah tamah hi’o, “Kwa taiyuw kwaibatiy kwa’itin, i sanaman.” ");
INSERT INTO aai_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mar bairu’abin orot matan fim nuwanuw isan hi’af na, naatu hibatiy maiye, “Turobe God nanamaim ai tur ina’owen! Aki aso’ob orot yait o biyawasi i bowabow kakafin wairafin.” ");
INSERT INTO aai_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Orot iyafutih eo “Ayu men aso’ob i bowabow kakafin wairafin o en? Ayu sawar ta’imonamo asoso’ob i ayu matou fim ama’am naatu boun i anuw a’i’itah.” ");
INSERT INTO aai_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naatu orot hibatiy, “Abistanawat o isa sinaf? Mi’itube sinaf o mata botawiy?” ");
INSERT INTO aai_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Orot iyafutih eo, “Ayu marasika kwa isa aoka naatu kwa men kwanowar. Aisim kwakokok anao maiye kwananowar? Ta’itin kwa auman kwakokok i ana bai’ufununayah kwanamatar?” ");
INSERT INTO aai_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hi’obaibiyab naatu hi’o, “O i nati orot ana bai’ufununayan, baise aki i Moses ana bai’ufununayah. ");
INSERT INTO aai_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aki aso’ob God mutufor Moses hairi hi’o, baise orot nati Jesu tibiwab, aki men kafa’imo aso’ob i menane na?” ");
INSERT INTO aai_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Orot matan fim bigewasin iyafutih eo, “Abifofofor men kafaita! I menane nan kwa men kwaso’ob, baise i ayu matu fim iwa’an anuwanuw. ");
INSERT INTO aai_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","It Taso’ob bowabow kakafih wairafih God hai tur men enonowar. God ana sabuw i ana kok tesisinaf naatu isan tekakakaf i hai tur enonowar. ");
INSERT INTO aai_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Men yait ta tafaram wanawanan orot matan fim auman tufuw ma’am matan botawiy nuwanuw ana tur nowaramih. ");
INSERT INTO aai_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iti orot men Godane tanan na’at, i boro men karam iti bowabow tasinaf.” ");
INSERT INTO aai_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iti isan hi’o, “O bowabow kakafin wanawanan itufuw ira’at iyey, i boun aki ini’obaiyi!” Naatu kou’ay barene hibotait tit ufun ma. ");
INSERT INTO aai_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu orot hinun tit ufun ma’am ana tur nowar, naatu titita’ur anamaramaim ibatiy, “O Orot Natun kubitumitum?” ");
INSERT INTO aai_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Orot Jesu ibatiy, “Regah, iti orot i menatan ku’o anowar saise i anitumitum!” ");
INSERT INTO aai_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu orot isan eo, “Orot i iti kwi’i’itin, boun iti airi kwa’o’o.” ");
INSERT INTO aai_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naatu orot eo, “Regah, Ayu abitumatum.” Naatu Jesu nanamaim sun yowen kwafir. ");
INSERT INTO aai_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu eo, “Ayu ana iti tafaramaim atitit anayabin i sabuw ana kusibih, saise iyab mata fim boro hinanuw, naatu iyab tenuwanuw boro matah fimabe hinamatar.” ");
INSERT INTO aai_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisee afa nati’imaim bairi hima’am iti tur eo’o hinowar, naatu hibatiy, “Nati tur ku’o’o, aki auman matai fim?” ");
INSERT INTO aai_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu iyafutih eo, “Kwa mata fim na’at, kwa boro men kakafimih. Baise boun kwa kwa’o’o aki matai anuwanuw, kwa a kakafih i tema’am.” ");
INSERT INTO aai_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Turobe a tur ao’owen, bobaituw hai fur ana etawanamaim orot men imaim narun, baise nakayam ef ta’ane narun, nati orot i bainowan mowan. ");
INSERT INTO aai_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Orot yait etawanamaim erur, i bobaituw kaifenayan. ");
INSERT INTO aai_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Orot fur kaifenayan boro etawan isan nabotawiy naatu bobaituw boro orot fanan hina’inan naatu ana bobaituw ta’ita’imon wabih naso’oben na’afih hinanowar naatu nabotaitih ufun hinatit. ");
INSERT INTO aai_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","I ebotaitih ufun tetitit anamaramaim, i wan ebi’iyon, naatu ana bobaituw ti’ufunun bairi tenan anayabin i fanan hiso’ob. ");
INSERT INTO aai_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Baise fanan ta boro men hini’ufunun, anayabin i fanan men hi’inan imih boro hinabihir.” ");
INSERT INTO aai_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu iti kawen turamaim eo, baise tur ana naniyan i men hibaimih abistan isan eo’o. ");
INSERT INTO aai_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Imih Jesu tur ibanak eo maiye, “Turobe a tur ao’owen, Ayu i etawan bobaituw isah. ");
INSERT INTO aai_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sabuw afa wan hinan i bainowah naatu bokwanekwaneyah, baise bobaituw men tainih isah hirub fanah hinowaramih. ");
INSERT INTO aai_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ayu i etawan, yait ayu wanawana’umaim run enan boro yawas nab, boro hinarun hinatit fotan gewasin hinagatur. ");
INSERT INTO aai_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bainowan tenan i bain, asbunin naatu gurusin akisin hinot tenan; Ayu anan i boro yawas gewasin hinab hinama boro men abistan ta isan hiniyababan.” ");
INSERT INTO aai_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ayu i bobaituw gewasu. Bobaituw Kaifenayan gewasin ana bobaituw isah ana yawas ebi’inuw. ");
INSERT INTO aai_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bobaituw kaifenayan orot ta men karam bobaituw nakaifen naatu i men nowan. Imih anamaramaim haru tuwetuwenih nan na’i’itin, i boro bobaituw nihamiyih nabihir. Naatu haru tuwenituwenih boro bobaituw bairi hiniyow naatu hina’abargiyih nanabin hinabihir. ");
INSERT INTO aai_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Orot boro nabihir anayabin i orot ta hibai na ma ekakaifen, imih bobaituw isah i men enotanot gagamin. ");
INSERT INTO aai_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ayu i bobaituw kaifenayan gewasu. Au bobaituw asu’ubih naatu i ayu hisu’ubu. ");
INSERT INTO aai_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tamai ayu susu’ubu na’atube, ayu Tamai asu’ub naatu au yawas bobaituw isah ai’inuw. ");
INSERT INTO aai_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bobaituw afa ayu nowau i men iti fur wanawanan tema’am. I auman anabuwih hinan hinarun. I auman ayu fanau hinanowar, nati’imaim i boro bobaituw ta’imon naatu kaifenayan ta’imon. ");
INSERT INTO aai_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamai ebiyabuwu anayabin ayu au yawas ani’inuw, saise yawasu anama maiye. ");
INSERT INTO aai_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Men yait ta ayu au yawas nabosair, baise ayu taiyuwu au kokomaim au yawas anayara’iy. Ayu au fair ema’am anayara’iy naatu au fair ema’am anabora’ah maiye. Iti obaiyunen i Tamai biyanane abai.” ");
INSERT INTO aai_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iti tur hinonowar anamaramaim Jew sabuw tarsibih maiye. ");
INSERT INTO aai_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sabuw moumurih maiyow hi’o, “I demon hitounbubur ema’am naatu ebikoko’aw. Aisim ana tur kwanonowar.” ");
INSERT INTO aai_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Baise sabuw afa hi’o, “Tur iti na’atube men karam orot demon hinatounbubur ema’am nao’omih. Mi’itube demon orot matan fim nabotawiy? ");
INSERT INTO aai_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nati rarabkokou wanawanan Tafaror Bar ana hiyuw wabin Koksouwen i Jerusalemamaim hibogaigiwas. ");
INSERT INTO aai_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naatu Jesu Solomon ana efan awan ta Tafaror Bar wanawanan imaim bat reremor. ");
INSERT INTO aai_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jew hai ukwarih hiru’ay hi’arbebera’uh hi’u, “Mar bai’ab boro inabotani anama anakaifi? O Keriso na’at, bebeyanamaim ku’o anowar.” ");
INSERT INTO aai_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu iyafutih eo, “Ayu kwa a tur aowen, baise kwa men kwaitumatum. Ina’inanen ayu Tamai wabinamaim asisinaf i ayu isou eo’orereb. ");
INSERT INTO aai_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Baise kwa men kwabitumatum anayabin kwa men ayu au bobaituw. ");
INSERT INTO aai_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ayu au bobaituw asu’ubih imih fanau hinowar tebi’ufnunu. ");
INSERT INTO aai_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ayu yawas wanatowan abitih; naatu boro men ta nakasiy; men ta ayu umou’umaim nabosair. ");
INSERT INTO aai_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamai ayu bow bitu i ra’at etei natabirih, imih ayu Tamai umanamaim men yait ta nabosairen. ");
INSERT INTO aai_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tamai naatu Ayu airi i ta’imon. ");
INSERT INTO aai_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ibanak maiye Jew sabuw kabay hibow hitarabimih, ");
INSERT INTO aai_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","baise Jesu sabuw isah eo, “Ayu Tamai biyanane ina’inan gagamih moumurih maiyow ai’obaiyi. Anayabin iti isan ayu kabayamaim kwanarabu.” ");
INSERT INTO aai_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jew hiya’afut hi’o, “Aki men nati isan kabayamaim anarabi, baise o God kubi’i’iyab, anayabin o i orot maiyow, naatu taiyuw God kurarouw.” ");
INSERT INTO aai_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu iyafutih eo, “Kwa a Buk Atamaninamaim iti na’atube hikirum ema’am, ayu ao’o kwa etei i god? ");
INSERT INTO aai_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I etei god narouw na’a’afih na’at, tur God i menane na naatu Buk Atamaninamaim hikikirum men hina’astu’ub. ");
INSERT INTO aai_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ayu Tamai yasairu i nowanamih amatar naatu irubinu naatu iyafaru ana iti tafaramaim atitit i boro mi’itube? Mi’itube ayu God bai’i’iyabin kwarouw kwa’o’o, anayabin ayu God Natun arouw ao’omih? ");
INSERT INTO aai_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ayu Tamai sisinafube men ana sisinaf bibaitutumu. ");
INSERT INTO aai_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Baise ayu ata sinaf kwa men kwatabitutumu na’at, karam nati ina’inanen kwata’itah kwataso’ob imaim kwatitumatum, ayu i Tamai wanawanan, naatu Tamai i ayu wanawanau.” ");
INSERT INTO aai_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ibanak maiye bain rabinamih hiwa’an, baise i umahine soratait tit. ");
INSERT INTO aai_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Naatu Jesu ibanak matabir maiye Jordan rabon rounane, marasika John sabuw imaim bapataito bitih efan imaim tit naatu Jesu imaim ma. ");
INSERT INTO aai_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Naatu sabuw moumurin maiyow hina biyan hitit, naatu hi’o, “John ina’inan men ta sinaf a’itin, baise John iti orot isan eo’o i turobe.” ");
INSERT INTO aai_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Efan nati’imaim sabuw moumurin maiyow Jesu hitumitum. ");
INSERT INTO aai_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Orot wabin Lasarus i Bethany orot imaim ma’am sawow, nati i Mary tain Martha hairi hai bar hai merar. ");
INSERT INTO aai_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Iti Mary raiy yamurin mamarin Regah aribun yan isuwei rara’iy naatu aribunamaim an sasafam, i boun rubun orot Lazarus sawow. ");
INSERT INTO aai_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Imih i ruburubun tur hiyafar Jesu isan, “Regah orot o ibiyabuw i sawow.” ");
INSERT INTO aai_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu iti tur nonowar anamaramaim eo, “Nati Lazarus ana sawow boro men nan morobomaim natitamih. En, iti i God ana fair bairerereb isan, saise i wanawananamaim God Natun hinifai hinabora’ara’ah.” ");
INSERT INTO aai_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martha tuwah babitai hairi naatu rubun orot Lazarus, Jesu iyabuwih kwanekwan. ");
INSERT INTO aai_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baise Lazarus sawow inu’in ana tur Jesu nonowar i men saise in, i nati’imaim ma veya rou’ab sawar. ");
INSERT INTO aai_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Naatu ana bai’ufununayah isah eo, “It tanamatabir maiye tanan Judea.” ");
INSERT INTO aai_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Baise bai’obaiyenayan, ana bai’ufununayah hi’o, “Iti boro’omo Jew sabuw kafa’imo kabayamaim hitarabi, naatu o baise imatabir maiye imaim kwenan.” ");
INSERT INTO aai_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu iya’afutih eo, “Veya ta’imon erararan ana manin men tarsisib in 12. Anayabin veya kusisiar tafaram marakaw itin, imih orot mar nuw enan boro men an narusukun nara’iy. ");
INSERT INTO aai_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Baise guguminamaim naremor nanan boro an narusukun nara’iy, anayabin i aurin marakaw en.” ");
INSERT INTO aai_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iti tur eo ufunamaim, ibanak ikofan hai tur eowen eo, “It ata of Lazarus i matanfot inu’in; baise ayu imaim anan anibunibun namisir.’ ");
INSERT INTO aai_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ana bai’ufununayah hiya’afut hi’o, Regah, i matan nafot na’inu’in na’at, i boro matannanuw namisir.” ");
INSERT INTO aai_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesu Lazarus ana morob isan eo’o, baise ana bai’ufununayah hinotanot i boun matat efot ta’inu’in na’atube hirouw. ");
INSERT INTO aai_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naatu imaibo mutuforomo hai tur eowen, “Lazarus i morob. ");
INSERT INTO aai_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Naatu ayu men nati’imaim ama’am isan abiyasisir anayabin, kwa taiyuw kwana’itin kwanaso’ob naatu kwanitumatum. Boro’obo tan ta’itin.” ");
INSERT INTO aai_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas wabin ta Kikifukek bai’ufnunenayah etei’imak isah eo, “It auman tan, bairit tamorob youn.” ");
INSERT INTO aai_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesu natitit ana veya imaibo so’ob Lazarus i rahemaim hiyai in veya kwafe’en sawar. ");
INSERT INTO aai_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalem ef i men yok inan Bethany inatit, ");
INSERT INTO aai_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","naatu Martha, Mary hairi rubuh bihamiyih isan. Jew sabuw moumurih na’in hina koubainunub baitihimih. ");
INSERT INTO aai_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesu nan Martha ana tur nonowar anamaramaim, hairi baitaramih tit in, baise Mary i bar ma. ");
INSERT INTO aai_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha Jesu isan eo, “Regah, o iti’imaim itama’am na’at, ayu tuwai i boro men tamorob. ");
INSERT INTO aai_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Baise ayu aso’ob veya iti boun auman karam abistan isan inafefefeyan God boro nit.” ");
INSERT INTO aai_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu Martha isan eo, “O tuwat boro nayawas namisir maiye.” ");
INSERT INTO aai_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha iya’afut eo, “Ayu aso’ob nati i mar yomaninabo nayawas namisir.” ");
INSERT INTO aai_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu Martha isan eo, “Ayu i misir maiye naatu yawas. Yait ayu ebitutumu boro yawasin nama naatu namomorob auman yawasin nama. ");
INSERT INTO aai_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Naatu yait ta ayu’umaim ema’am naatu ebitutumu boro men kafa’imo namorob. Iti tur ao’o kwabitumatum?” ");
INSERT INTO aai_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha iya’afut eo, “Ai Regah anowar, Ayu abitumatum. O i Keriso, God Natun. O na tafaramamaim titamih hi’o’oban oban iti. ina itit.” ");
INSERT INTO aai_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tur iti eo’o ufunamaim, Martha intabir in Mary eaf na hamenamo ana tur eowen. “Bai’obaiyenayan i na tit, naatu o isa ebibatebat?” ");
INSERT INTO aai_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary iti tur nonowar anamaramaim, duku iwa’an misir naatu in biyan tit. ");
INSERT INTO aai_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu men na bar merar tit, baise efan menamaim Martha hairi hima’am boro’ika imaim ma’am. ");
INSERT INTO aai_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mary duku iwa’an mimisir Jew sabuw ana baremaim hima koubainunub hibitin hi’itin, naatu himisir hi’ufunun ufun hitit, hinotanot i enan rahemaim nama narerey. ");
INSERT INTO aai_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary remor in Jesu menamaim ma’am biyan tit naatu eo, “Regah, O iti’imaim itama’am na’at ayu tuwai boro men tamorob.” ");
INSERT INTO aai_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mary rererey, naatu Jew sabuw hi’ufunun bairi hinan auman hirererey Jesu i’itih anamaramaim, dogoron yababan awankaratan naatu naniyan kwaris. ");
INSERT INTO aai_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ibatiyih “Menamaim kwayai inu’in?” I hi’o “Regah Kuna kwi’itin.” ");
INSERT INTO aai_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu maturin ra’iy rerey. ");
INSERT INTO aai_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jew sabuw hi’o, “Kwa’itin i ana yabow Lazarus isan i ra’at kwanekwan!” ");
INSERT INTO aai_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Baise sabuw afa hi’o, “I orot matan fim botawiy. Karam iti orot auman tabotan men tamorobomih.” ");
INSERT INTO aai_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu ibanak dogoron wanawanan yababan kuyuyuw, na rahamaim tit. Rah i watu, awan i kabayamaim hihir. ");
INSERT INTO aai_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu eo, “Kabay kwabosair.” Murubin rubun Martha eo, “Baise Regah, Lazarus nati’imaim hiyai in boun veya kwafe’en sawar, mas yamurin mataraka.” ");
INSERT INTO aai_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naatu Jesu eo, “Ayu au’uwi men kwanowar? Kwa kwanabitumatum na’at God ana fair boro nirerereb kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Naatu rah awan kabay hibosair. Jesu nakwetan tara’ah au mar na’at nura’at eo, “Tamai, O a merar ayiy, ayu abistan ao’o inowar.” ");
INSERT INTO aai_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ayu aso’ob mar etei fanau kunonowar, baise iti ao’o i sabuw iti tebatabat isah, saise hina’itin hinitumatum, O ayu iyunu ana.” ");
INSERT INTO aai_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iti eo ufunamaim, Jesu fanan aumetawat na’in eaf, “Lazarus kumisir kutit!” ");
INSERT INTO aai_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Orot murubin, an uman, yumatan faifuw metametan auman misir tit na. Jesu sabuw isah eo, “Rah ana faifuw kwabosairen naatu kwaihamiy au bar en.” ");
INSERT INTO aai_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Isan imih Jew sabuw moumurin maiyow hina Mary hibinanawan ana mar, Jesu abistan sinaf hi’i’itin, i hitumitum. ");
INSERT INTO aai_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Baise afa hin Pharisee hai tur hi’owen abistan Jesu sisinaf. ");
INSERT INTO aai_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Firis hai ukwarih naatu Pharisee bairi hi’af’ayuwih kou’ay hibai. Taiyuwih hibatiyih, “Abistan tao tasisinaf men emamatar? Kwanaso’ob iti orot ina’inan moumurin maiyow esisinaf! ");
INSERT INTO aai_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","It tanihamiy na’at nama nasisinaf sabuw etei boro hinitumitum. Naatu Roman sabuw boro hinan ata me ata tafaram hinab.” ");
INSERT INTO aai_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","I hai orot ta wabin Kaiafas, nati kwamur i Firis ukwarin ma’am awan tara’ah eo, “Kwa men ta kwaso’ob! ");
INSERT INTO aai_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kwa men matato iwa’an kwa’i’itin, anagewasin orot ta’imon tamorob sabuw isah, men karam tafaram tutufin etei hitarab hitagurus.” ");
INSERT INTO aai_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I men taiyuwin ana notamaim iti tur yai eomih, baise nati kwamur wanawanan i firis ukwarin ma’am Jesu Jew sabuw isah namomorob isan eorereb. ");
INSERT INTO aai_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Naatu men i akisih isah, baise God ana sabuw efan nanabin tema’am nabuwih hinan nita’imonih biyah ta’imon namatar. ");
INSERT INTO aai_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Naatu hibusuruf Jesu baban hi’o rabin morob isan. ");
INSERT INTO aai_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Imih Jesu Judea wanawanan i men bebeyanamaim ma remoramih, baise efan nati ihamiy naatu in efan arar sisibinamaim ma, bar merar wabin Efaram, imaim ana bai’ufununayah bairi hima. ");
INSERT INTO aai_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jew hai Tar Nowaten ana Hiyuw, i na biyubin ana veya, naatu tafaram wanawanan efan ta ta hima’am hiyen hin Jerusalem, kouksouwen ana kou’ay bainabo, Tatar nowaten ana veya nan natit. ");
INSERT INTO aai_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesu isan hinunuwet, naatu Tafaror Bar ana efanamaim hibat ta’ita’imon nane hibibabatiyih, “Kwa mi’itube kwanotanot? Forag isan kafai enan?” ");
INSERT INTO aai_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Baise firis ukwarih naatu Pharisee sabuw obaiyunen hitih, menamaim Jesu nama’am hina’i’itin na’at, hinan hinao hinanowar saise i hinan hinab hinafatum. ");
INSERT INTO aai_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Veya six nasasawar ufunamaim i Tar Nowaten ana veya, Jesu na Bethany tit, Lazarus morobone biyawas i ana bar merar. ");
INSERT INTO aai_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nati’imaim rabirab ana bay hibogaigiwas Jesu bairi aa isan, Martha ibaisih bairi bay hisemor. Lazarus orot afa auman Jesu bairi himarir gem sisibinamaim hima’am. ");
INSERT INTO aai_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Raiy yamurin mamarin wabin nard i ai rourin hibun iroro’on hibai. Nati raiy iroro’on ana baiyan i gagamin na’in, Mary bai na isuwei ra’iy Jesu an rororon ihurufen, naatu aribunamaim safam. Naatu yamurin ana mamarin bar wanawanan etei itakwar. ");
INSERT INTO aai_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Baise ana bai’ufununayan orot ta, Judas Iscariot boro ufibo baban nao, i eo, ");
INSERT INTO aai_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ana gewasin iti raiy yamurin mamarin ana baiyan 300 silver coins tatayai sabuw hitatubun naatu kabay tatab bai’akirayah tatibaisih.” ");
INSERT INTO aai_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iti tur eo’o, asir sabuw hinanot i akir sabuw baibaisih isah not eo hinarouw, baise i bainowan orot ta, anayabin hai kabay koukufet kakaif, abistan ekokok i ebai ana kokomaim esisinaf. ");
INSERT INTO aai_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu iya’afut eo, “Babin kwaihamiy! Abistan biyanamaim ema’am i ayu anamorob hinayaya’u isan eyayabuna. ");
INSERT INTO aai_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kwa boro mar etei akir sabuw wanawanahimaim kwanama, baise ayu boro men mar etei kwa bairit tanama’amih.” ");
INSERT INTO aai_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sabuw moumurin maiyow tur hinowar Jesu i na Bethany ma’am, imih sabuw Jesu itinamih hin, men i akisin itinamih hin baise Lazarus morobone Jesu biyawas auman itinamih hin. ");
INSERT INTO aai_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Imih firis gagamih ef hinuwet hiyakitifuw Lazarus auman hitarab tamorob isan. ");
INSERT INTO aai_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Anayabin Lazarus biyanamaim abistan matar hi’itin Jew sabuw moumurin maiyow himisir firis gagamih hikwahirih naatu Jesu isan higeger hitumitum. ");
INSERT INTO aai_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Marto sabuw rou’ay gagamin maiyow hiru’ay Tar Nowaten ana Hiyuw isan, tur hinowar Jesu i enan au Jerusalem. ");
INSERT INTO aai_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sabuw ai rourih hikakir naatu hitit hin Jesu nan bairi baitaramih, hitarkoukuw hi’o, “God tanifai! Regah wabinamaim enan, God nigegewasin! Israel hai aiwob inigegewasin!” Hitit hin bairi hitar. ");
INSERT INTO aai_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bobaituw boubun wabin donkey hitita’ur naatu afe’enamaim mara’at ma remor yen in. Buk Atamaninamaim hikirum hi’o na’atube. ");
INSERT INTO aai_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Zion Natun Babitai, Men inabir; Kwa a aiwob enan, kwa’itin, donkey boubun afe’en mare ema’am.” ");
INSERT INTO aai_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Abistan nati ana veya himamatar ana bai’ufununayah men hiso’ob. Baise Jesu ana fair nabaib ufunamaim, imaibo hina’itin hinaso’ob. Buk Atamaninamaim i isan hi’o hikirum, naatu hisinafen himatar. ");
INSERT INTO aai_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sabuw iyab Jesu bairi hin rahemaim hitit Lazarus morobone yawas misir hi’i’itin hi’o tur ra’at tasasar. ");
INSERT INTO aai_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sabuw moumurin maiyow hitit hin Jesu biyan hitit, anayabin tur hinowar i ina’inan iti na’atube men tisinaf emamatar i sinaf matar. ");
INSERT INTO aai_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Imih Pharisee taiyuwih himare hi’o, “It abistan tayayakitifuw men kafa’imo emamatar. Sabuw etei i’etaw tebi’ufunun kwa’i’itin!” ");
INSERT INTO aai_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Greek sabuw afa wanawanahimaim bairi hiyen hin Jerusalem hiyuw ana veya imaim kwafirin isan. ");
INSERT INTO aai_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hina Philip biyan hitit, i Betsaida orot Galilee wanawanan, isan hifefeyan hi’o, “Aro, aki akokok Jesu ana’itin.” ");
INSERT INTO aai_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip in Andrew ana tur eowen, naatu Andrew Philip hairi hin Jesu ana tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu iyafutih eo, “Orot Natun baifa’in naatu bora’ara’ahin isan ana veya na kabom. ");
INSERT INTO aai_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ayu turobe a tur ao’owen, sanabey tutufin ta’imon hinama’ub me yan hinataun na’inu’in, naatu nabikubobun boro moumurih na’in hinayen naatu ani’anin boro moumurih na’in naya. ");
INSERT INTO aai_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Orot yait taiyuwin ana yawas ebiyabuw i boro yawas narusa’ir, naatu yait iti tafaramamaim taiyuwin ana yawas ekwakwahir boro nabotan yawas wanatowan isan.” ");
INSERT INTO aai_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yait ayu isou nabowabow, i ayu ni’ufnunu, naatu ayu menamaim ama’am au akir orot boro airi imaim anama. Yait ayu isou ebowabow Tamai boro nifai nabora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ayu dogorou i yababan awan karatan, Tamai ayu boro mi’itube anao? Iti bai’akir ana veya iniyawasu? ‘Aiyabin, Tamai iti bai’akir ana veya nan anabaib isan ana atit. ");
INSERT INTO aai_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamai o wab anabora’ah.” Naatu marane fanan tit eo, “Ayu wab abora’ahika naatu boro anabora’ah maiye.’” ");
INSERT INTO aai_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sabuw rou’ay nati’imaim hibatabat hinowar, afa hi’o, gunum rab naatu afa hi’o, “Tounamatar isan eo.” ");
INSERT INTO aai_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu eo, “Iti fanan i kwa isa eo, men ayu isou. ");
INSERT INTO aai_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Veya boun iti tafaram baibabatiyin isan naatu iti tafaram ana aiwob boun boro hinabosair. ");
INSERT INTO aai_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Baise Ayu iti tafaramamaim hinabobora’ahu anamaramaim, sabuw etei boro anabonawiyih hinan ayu akisu biyou hinatit.” ");
INSERT INTO aai_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iti tur eo, i mi’itube ti’obaiyih i ana morob ana itinin boro mi’itube namorob. ");
INSERT INTO aai_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sabuw hi’o, “Aki ofafaramaim anonowar Keriso boro nama wanatowan, naatu o mi’itube ku’o’o, Orot Natun boro hinabora’ah. Iti Orot Natunam yait?” ");
INSERT INTO aai_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Naatu Jesu uwih eo, “Kwa mar kafai boro marakaw kwanab, marakaw kwabaibimaim kwanaremor, imaibo gugumin nan natarsumi. Orot yait guguminamaim ereremor i men so’ob menamaim enan. ");
INSERT INTO aai_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Marakaw nati kwabai kwama’am a baitumatum i kwanitin. Saise kwa boro kwanan marakaw natunatun kwanamatar.” Iti eo’o ufunamaim, Jesu sabuw ihamiyih naatu i taiyuwin ibunwa’ir. ");
INSERT INTO aai_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mensanet Jesu wanawanahimaim sawar faifirih imamataren, baise i boro’ika men tibitumitum. ");
INSERT INTO aai_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iti i mi’itube dinab orot Isaiah ana tur eo’o i titurobe isan. “Regah, yait aki tur a’o ebitumitum? Yait biyanamaim Regah ana fair ebirerereb?” ");
INSERT INTO aai_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Anayabin iti isan, men karam hititumatum, imih Isaiah eo maiye; ");
INSERT INTO aai_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God iwa’an matah hifim naatu dogoroh rufoten, saise men hina’itin, naatu hai not nakwaris anayabin boro men hinaso’ob. naatu Regah eo, ayu isou boro men hinatatabir. Naatu tena ayu aniyawasih.” ");
INSERT INTO aai_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah iti eo’o, anayabin Jesu ana marakaw itin naatu isan eo i nowar. ");
INSERT INTO aai_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naatu nati veya ta’imon wanawanan Jew ukwa’ukwarih wanawanahimaim Jesu hitumitum. Baise anayabin Pharisee isah hibir, men karam hai baitumatum hitao rereb, i boro kou’ay barene hitabotaitih. ");
INSERT INTO aai_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Anayabin i orot babin isah tibiyabow men boun God isan tebiyabow na’atube. ");
INSERT INTO aai_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Basit Jesu fanan aumetawat eo, “Orot ayu ebitutumu, i men ayu akisu ebitutumu, baise yait ayu iyafaru anan auman ebitumitum. ");
INSERT INTO aai_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yait ayu i’itu anamaramaim, ayu iyafaru anan auman i’itin. ");
INSERT INTO aai_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ayu i marakaw na’atube ana tafaramamaim atit, saise yait ayu ebitutumu i boro men guguminamaim nama. ");
INSERT INTO aai_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Orot yait ayu au tur enonowar baise men ebaib, ayu boro men anibatiy. Ayu men tafaram fufuninamih ana atit, baise baiyawasinamih ana. ");
INSERT INTO aai_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yait ayu ebifutuwu naatu au tur men ebaib i ana baibatiyenayan ema’am. Tur iti ayu a’o i boro mar yomaninamaim nibabatiyi. ");
INSERT INTO aai_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Anayabin ayu men taiyuwu au kokomaim ao’omih, baise Tamai ayu iyafaru anan tarbaiyunu tur abistanawat anao naatu boro mi’itube ana’o. ");
INSERT INTO aai_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naatu ayu aso’ob i ana tarbaiyunen tur boro nabonawiy inan ma’ama wanatowan. Imih ayu abistan ao’o i mutufor, Tamai uwu imih ao’o.” ");
INSERT INTO aai_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tar Nowaten ana Hiyuw nanamaim. Jesu so’ob i isan veya na kabom iti tafaram nihamiy naatu nan Tamah isan. Sabuw i nowan iti tafaramamaim tema’am isah i yabow men kafaita, naatu bounabo ana yabow yomanin ni’obaiyih nan na’asa’ub. ");
INSERT INTO aai_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Rabirab ana bay hibusuruf hi’aa’u, naatu demon ana not kakafin Judas Iscariot, Simon natun marasika ana notamaim yaru’uy Jesu baban eo rabin isan. ");
INSERT INTO aai_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu so’ob Tamah sawar etei i ana fair babanamaim ya, naatu i Godane na naatu God boun isan emamatabir maiye. ");
INSERT INTO aai_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Imih bay hi’aa wanawanan misir, ana faifuw tafan iyoun ma’am bosair, naatu biya rarouw bai naiwan fifin. ");
INSERT INTO aai_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I ufunamaim harew bai tew yan isuwei naatu busuruf ana bai’ufununayah ah souwen, naatu biya rarouw naiwanamaim fifin ma’am bai ah safamen. ");
INSERT INTO aai_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesu na Simon Peter biyan titit ana veya, Simon Jesu isan eo, “Regah ayu au inasouwimih?” ");
INSERT INTO aai_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu iyafut eo, “Ayu abisa boun asisinaf o boro men inaso’ob, baise boro ufibo inaso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter eo, “Aiyabin, ayu men abibasit au inasouwen.” Jesu iyafut eo, “Ayu a men ana sasouw na’at, o i men ayu au bai’ufununayan.” ");
INSERT INTO aai_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Naatu Simon Peter iyafut eo, “Regah, Men au akisih, baise umou naatu ukwaru auman kwikifuwu.” ");
INSERT INTO aai_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu iyafut eo, “Orot yait biyan tutufin ekifukif? I an akisinamo tanasouw, i biyan tutufin etei i gewasin. Naatu kwa etei i gewas, baise men etei gewasamih.” ");
INSERT INTO aai_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu so’ob yait boro nayanuw, naatu anayabin iti isan i eo kwa etei i men gewas. ");
INSERT INTO aai_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ah souwen sasawar ufunamaim, ana faifuw bosair yai inu’in bai iyoun naatu matabir maiye ana efan mara’iy. Jesu ibatiyih, “Kwa isa ayu abistan asisinafuban kwaso’ob?” ");
INSERT INTO aai_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kwa ayu isou “Bai’obaiyenayan naatu Regah kwarouw kwa’o’o, nati i gewasin maiyow. Anayabin i nati, Ayu i nati na’atube ama’am. ");
INSERT INTO aai_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Boun ayu kwa a Regah, a bai’obaiyenayan a souwen, kwa auman turanah ah kwanasouwen. ");
INSERT INTO aai_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ayu bai’obaiyen kwa isa asinaf, kwa isa iti boun asisinaf i na’atube kwanasinaf. ");
INSERT INTO aai_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ayu turobe a tur ao’owen, akir orot i men ebi’ukwarin ana orot ukwarin isan, o tur abarayan i men orot baiyuninenayan na’atube. ");
INSERT INTO aai_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bounabo kwa sawar etei kwaso’ob, kwa iti kwanasisinaf na’at, kwa boro baigegewasin kwanab. ");
INSERT INTO aai_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ayu men kwa etei isa ao’omih; ayu iyab arurubiniyih i aso’ob. Baise iti i mi’itube Buk Atamaninamaim hikikirum i tan titurobe. ‘Yait ayu airi rafiy afafaram, i koun ayu itu.’ ");
INSERT INTO aai_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ayu bounaika a tur a’o’owenabo namatar, saise anamaramaim abistan namamatar kwa boro kwanitumatum Ayu i Yait? ");
INSERT INTO aai_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Turobe a tur ao’owen, yait ayu aiyun en ebaib, nati i Ayu ebubuwu; naatu yait Ayu ebubuwu, nati i yait Ayu iyunu anan i ebaib.” ");
INSERT INTO aai_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu iti tur eo’o ufunamaim, dogoron yababan awan karatan naatu eorereb, Turobe kwa a tur ao’owen, kwa wanawanamaim orot ta ayu boro babu nao. ");
INSERT INTO aai_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana bai’ufununayah taiyuwih hima hinubunibun, hai kasiy ra’at yait isan eo’o. ");
INSERT INTO aai_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesu ana bai’ufnunenayan orot ta i biyabuw, sisibinamaim ma’am. ");
INSERT INTO aai_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter isan itarasib eo, “Kwaibatiy, ait isan eo’o.” ");
INSERT INTO aai_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naatu Bai’ufununayan na fufufur Jesu sisibinika tit naatu ibatiy, “Regah yaita?” ");
INSERT INTO aai_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu iyafutih eo, “Ayu rafiy anab tew yan anabutu’ub anabitin i orotoban nati.” Anamaramaim rafiy butu’ub, Judas Iscariot, Simon natun itin. ");
INSERT INTO aai_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas rafiy baib ana mar Satan marta’imon dogoron wanawanan run. Jesu iu eo, “Abistan o kunotanot sinafumih, saise’ewat kusinaf.” ");
INSERT INTO aai_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Baise bay hi’aa wanawanan Jesu tur abistan i isan eo’o men yait ta naniyan bai. ");
INSERT INTO aai_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nati ana veya Judas i kabay kakaif, imih Jesu iti tur eo’o i hinot na bay tobon bow na hiyuw isan, o sabuw aurih sawar meyemeye bow na baitih hirouw. ");
INSERT INTO aai_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nati gugumin wanawanan. Judas faraw bai eani’aan ana veya, i misir ufun tit. ");
INSERT INTO aai_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ufun titit anamaramaim, Jesu eo, “Sabuw bounabo Orot Natun ana aiwob nab nibirerereb hina’itin. Naatu Jesu wanawananamaim God ana fair natit sabuw hina’itin. ");
INSERT INTO aai_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Naatu God ana fair i wanawananamaim nabirerereb na’at, naatu God taiyuwin Orot Natun biyanamaim boro ana fair saise’ewat niwa’an nirerereb. God Natun akisinamo wanawananamaim boro nifai nabora’ara’ah naatu boro mar ta’imonamo. ");
INSERT INTO aai_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Natunatu, Ayu boro men manin bairit tanama. Mi’itube Jew sabuw hai tur ao’owen na’atube kwa boun a tur ao’owen. Kwa boro ayu kwananuwuhu. Ayu efan menamaim anan, kwa men karam kwanan.” ");
INSERT INTO aai_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Obaiyunen tur boubun kwa abit. Turanah kwaniyabuwih. Ayu kwa abiyabuw na’atube, turanah bairi kwaniyabowbonen. ");
INSERT INTO aai_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kwa turanah bairi kwanabiyabowbonen na’at, sabuw etei boro hinaso’ob kwa i ayu au bai’ufununayah.” ");
INSERT INTO aai_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter Jesu ibatiy, “Regah, o menika kwenan?” Jesu iyafut eo, “Ayu menamaim anan, o men karam boun boro ayu ini’ufnunu, baise o boro ufibo ini’ufnunu.” ");
INSERT INTO aai_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter ibat “Regah, aisimamih boun men ani’ufnuni? Ayu au yawas boro o isa anaya’ra’iy.” ");
INSERT INTO aai_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Naatu Jesu iya’afut eo, “O anababatun ibogaigiwas ayu isou a yawas inayara’iy? Turobe a tur ao’owen, kokorere o’e nanamaim, o boro mar tounu inao inayoubu, ayu orot nati men aso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesu ana bai’ufununayah isa eo, “Men kwaniyababan, God kwanitumatum naatu ayu auman kwanitutumu. ");
INSERT INTO aai_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ayu Tamai ana baremaim bar awah moumurih na’in ti’inu’in naatu ayu anan kwa isa a bar awah anayabuna naatu bar awah men hitama’am na’at, aisim boro a tur ata’owen. ");
INSERT INTO aai_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ayu anan kwa a efan anayayabuna ufunamaim boro taiyuwu anamatabir anan ananawiyi bairi tanan ayu menamaim ama’am kwa boro imaim kwanama. ");
INSERT INTO aai_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ayu efan menamaim anan kwa i kwaso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas Jesu isan eo, “Regah, aki men aso’ob o menamaim kwenan, ef boro mi’itube anaso’ob?” ");
INSERT INTO aai_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu iya’afut eo, “Ayu i ef, turobe, naatu yawas. Men yait ta nan Tamai biyan baise ayu’une nan Tamai biyan natit. ");
INSERT INTO aai_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kwa anababatun ayu kwanasusu’ubu gewas na’at, Tamai boro auman kwanasu’ub. Bounabo kwasoso’ob naatu kwa’i’itin.” ");
INSERT INTO aai_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip eo, “Regah Tamat kwi’obaiyi a’itin saise aki boro nuhinafot.” ");
INSERT INTO aai_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu iya’afut eo, “Philip manin maiyow airit tama baise men isu’ubu? Yait ta ayu i’itu Tamai i’itin? Aisimamih ayu isou i’o, ‘Tamat kwi’obaiyi a’itin?’ ");
INSERT INTO aai_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ayu i Tamai wanawananamaim ama’am naatu Tamai ayu wanawana’umaim ema’am. Philip o men kubitumatum? Iti tur i kwa isa ao’o, i men ayu au kokomaim ao’omih baise Tamai ayu wanawana’umaim ema’am bowabow i esisinaf. ");
INSERT INTO aai_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kwanitumatum ana maramaim iti tur anao’o, ayu i Tamai wanawanan ama’am naatu Tamai i ayu wanawanau ema’am, o men kwanabitumatum na’at ina’inan asisinaf imaim boro ni’obaiyi kwana’itin. ");
INSERT INTO aai_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ayu anababatun a tur ao’owen yait ayu ebitutumu ayu abistan asisinaf boro nasinaf hinamatar, naatu sawar boro au gagamihika nasinaf. Anayabin ayu Tamai isan anan. ");
INSERT INTO aai_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Naatu abistanawat ayu wabu’umaim kwafefefeyan boro ana sinaf saise Natun Tamah wabin nabora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kwa sawar abistanawat ayu wabu’umaim kwanafefeyan boro anasinaf namatar. ");
INSERT INTO aai_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ayu kwanabiyabuwu na’at, au obaiyunen tur boro kwanabosiyasiyar. ");
INSERT INTO aai_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Naatu ayu boro Tamai anifefeyan i boro kwa a Baibaisayan ta wabin Turobe Ana Anun Kakafiyin nit bairi kwanama wanatowan. ");
INSERT INTO aai_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iti tafaram men nab, anayabin i boro men na’itin o boro men nasu’ub. Baise kwa i kwasu’ub, anayabin kwa bairi kwama’am naatu boro wanawanamaim nama. ");
INSERT INTO aai_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ayu boro men anihamiyi kwanigaganamih, Ayu boro kwa isa anamatabir maiye anan. ");
INSERT INTO aai_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mar kafai iti tafaram boro men na’itu, baise kwa boro kwana’itu. Anayabin ayu ama’am isan kwa auman kwama’am. ");
INSERT INTO aai_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nati anamaramaim kwa boro kwanaso’ob ayu i Tamai wanawanan ama’am naatu kwa i ayu wanawanau kwama’am naatu ayu i kwa wanawan ama’am. ");
INSERT INTO aai_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yait obaiyunen tur bai, ebobosiyasiyar, i ayu ebiyabuwu. Yait ayu ebiyabuwu i Tamai ebiyabuw naatu ayu auman boro aniyabuw naatu ayu taiyuwu anirerereb i isan.” ");
INSERT INTO aai_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (men Judas Iscariot) Jesu isan eo, “Regah aisimamih tafaram ana sabuw men isah inirerereb baise aki akisi isai inirerereb?” ");
INSERT INTO aai_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu iya’afutih eo, “Yait ta ayu isou ebiyabow boro au bai’obaiyen nabosiyasiyar? Ayu Tamai boro isan niyabow, naatu ayu Tamai airi biyanamaim ai bar anawowab bairi anama. ");
INSERT INTO aai_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yait ayu isou men ebiyabow au bai’obaiyen boro men nabosiyasiyar naatu iti tur ao kwanonowar i men ayu au turamih baise iti tur ayu Tamai iyafaru anan i biyanane enan. ");
INSERT INTO aai_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Boun bairit tama’amamaim sawar etei’imak ao kwanowaraka. ");
INSERT INTO aai_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Baise Baibaisayan, Anun Kakafiyin, boro Tamai niyun ayu wabu’umaim nan, i boro sawar etei ni’obaibiyi naatu sawar etei’imak au’uwi boro a not nakusisib. ");
INSERT INTO aai_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tufuw kwa biyamaim abihamiy, ayu tufuw kwa abit. Iti tufuw i men tafaram kwa bit na’atube abitimih. Yare kouh kwanayey a not men narukasiy naatu men kwanabir. ");
INSERT INTO aai_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Iti tur i ao kwanowaraka. ‘Ayu i anan kwa isa boro anamatabir anan.’ Ayu kwanabiyabuwu na’at, kwaniyasisir ayu i Tamai isan anan anayabin Tamai i ra’at ayu natabiru. ");
INSERT INTO aai_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bounaika a tur ao’owenabo sawar hinamatar, imih abistan hinamamatar kwa i kwanitumatum. ");
INSERT INTO aai_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ayu boro men tur manin bairit tanao, anayabin tafaram ana kaifenayan kakafin i enan. I aurin fair men ema’am ayu nisnowahu. ");
INSERT INTO aai_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Baise sabuw iti tafaramamaim i hinaso’ob ayu Tamai abiyabow isan imih Tamai abistan eo etatarbaiyunu imaim asisinaf. “Efan iti kwihamiy, kwanatan.” ");
INSERT INTO aai_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ayu i ai an anababatun, naatu Tamai i masaw Matuwan. ");
INSERT INTO aai_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ayu famufamu ro’oro’on men ebiw gewas boro na’afuw nisaroun, naatu ro’oro’on ebiw gewas boro famufamu natobubunei saise ro’o’ro’on moumurihika niw naya. ");
INSERT INTO aai_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kwa i marasika kwaigewasin sawar, anayabin ayu turamaim ao kwanowar sawar. ");
INSERT INTO aai_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wanawana’umaim kwanitubonen kwanama, naatu ayu kwa wanawanamaim anitubonen anama. Famen akisin men karam taiyuwin niw ro’on nayai, baise i boro ai naiwan nituw. Ef ta’imon kwa ayu wanawanau kwanitubonen boro ro’oro’o moumurihika kwanaya. ");
INSERT INTO aai_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ayu i ai, naatu kwa i ai famefamen, o yait ayu wanawana’umaim inabituwabon naatu ayu o wanawananamaim anabituwabon, i boro ro’oro’o moumurihika naya; anayabin, o akis men karam boro inasinaf namatar. ");
INSERT INTO aai_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","O yait ta ayu airit men tanibitubonen na’at, i boun ai famefamen hituw batabat kekerer na’atube, nati boro hina’o’on wairaf wan hinaroura’aten hinikubaren hina’arat. ");
INSERT INTO aai_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","O yait ayu wanawana’umaim inabitubonen naatu ayu au tur o wanawanamaim nabitubonen na’at, o a kok abistan isan kufefefeyan o boro anit. ");
INSERT INTO aai_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kwa ro’oro’o moumurihika kwanaya’ay kwa boro taiyuw kwana’inani, kwa i ayu au bai’ufununayah naatu Tamai ana gewasin boro sabuw kwani’obaiyih. ");
INSERT INTO aai_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamai ebiyabuwu na’atube; kwa abiyabuwi. Au yabowamaim kwanitubonen kwanama. ");
INSERT INTO aai_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kwa ayu ou’obaiyunen tur kwanabobosiyasiyar na’at, boro ayu au yabowamaim kwanitubonen kwanama, boun ayu Tamai ana’obaiyunen tur abosiyasiyar naatu i ana yabowamaim aitubonen ama’am na’atube. ");
INSERT INTO aai_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ayu a tur aowen kwanowar sawar saise au yasisir kwa wanawanamaim nama, naatu kwa mar etei yasisiramaim kwanama. ");
INSERT INTO aai_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ayu au obaiyunen tur i iti. Turanah bairi kwaniyabowbonen, ayu kwa abiyabuwi na’atube. ");
INSERT INTO aai_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yait ta ana ofonah isah namomorob na’at, nati ebi’obaiy i ana yabow ra’at kwanekwan. ");
INSERT INTO aai_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ayu obaiyunen tur abistan sinaf isan ou’uwi, i kwanasisinaf na’at, kwa i ayu au ofonah. ");
INSERT INTO aai_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayu boro men kafa’imo kwa isa akir anarouw ana’af, anayabin akir orot i men so’ob ana orot ukwarin abistan esisinaf. Nati efanin ayu kwa isa au ofonah arouw ao’o, anayabin ayu Tamai biyanane tur abistanawat anonowar etei’imak a tur aowen kwanowar sawar. ");
INSERT INTO aai_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kwa men ayu kwarubinu, ayu kwa arubini naatu atarbaiyuni kwanatit kwanan kwaniw ro’oro moumurihika kwanaya–nati ro’o’ro’on boro men hinamun. Naatu abistan isan ayu wabu’umaim kwafefefeyan Tamai boro nit. ");
INSERT INTO aai_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iti i ayu ou’obaiyunen tur. Turanah bairi kwaniyabowbonen. ");
INSERT INTO aai_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kwa sabuw hinabifutuwi na’at, kwa kwanaso’ob nati ayu wan ifutuwu’ubo kwa uf ifutuw. ");
INSERT INTO aai_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kwa tafaram nowan kwanama’am na’at, tafaram boro niyabuwi nowan na’atube kwanamatar kwanama, kwa i men iti tafaram nowan, baise kwa tafaramane arubini abotaiti kwatit. Nati isan tafaram kwa ebifutuwi. ");
INSERT INTO aai_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Iti tur kwa isa ao’o i a notamaim nama. ‘Orot ana bowayan i men ra’at ana orot ukwarin natabirimih.’ Kwa hinarabi hinabi’a’afiyi na’at, ayu auman hirabu tibi’afiyu. Ayu au bai’obaiyen hinabobosiyasiyar na’at, kwa auman boro hinabosiyasiyari. ");
INSERT INTO aai_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ayu wabu isan, kwa isa boro iti na’atube hinamatar. anayabin i men hiso’ob yait ayu iyunu ana. ");
INSERT INTO aai_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ayu men atan biyah atatit naatu tur gewasin men atao hitanonowar na’at, kakafin isan boro men ubar hitabaimih; baise boun boro men hai kakafin isan hinifufuwenamih. ");
INSERT INTO aai_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yait ayu ebifutuwu Tamai auman i ebifutuw. ");
INSERT INTO aai_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ayu wanawanahimaim asisinaf men yait ta sisinaf na’atube asinafumih, imih i boro men kakafin hitasinaf. Baise boun ina’inan hi’itah, naatu ayu Tamai airi’ika hikwahiri. ");
INSERT INTO aai_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Baise iti mamatar, i abistanawat hai ofafaramaim hi’o hikikirum i na iturobe, Anayabin en ayu hifutuwu. ");
INSERT INTO aai_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ayu boro Baibaisayan aniyafar nan, nati i turobe ana Anun Kakafiyin, i boro Tamai biyanane niyafar nan kwa biya natit, naatu ayu isou boro nao rerereb. ");
INSERT INTO aai_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","naatu kwa auman boro ayu isou kwana’orerereb, anayabin no aneika kwa ayu bairit tama. ");
INSERT INTO aai_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Sawar etei’imak i ao kwanowar sawar, saise kwa boro men ef kwanarukasiy. ");
INSERT INTO aai_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jew hai Kou’ay Bar wanawanan boro hinanuni ufun kwanatit, veya nanan anamaramaim o yait ta na’a’asbuni, i boro asir nanot God ana sibor eya’iy narouw. ");
INSERT INTO aai_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sabuw boro kakafin isa hinasinaf, anayabin Tamat men hisu’ub naatu ayu auman men hisu’ubu. ");
INSERT INTO aai_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ayu kwa a tur ao’owen, saise ana veya nanan kwa boro kwananot ayu i ai’matnuwi sawar, anayabin ayu kwa bairit tama’am isan, men saise a tur aowenamih. ");
INSERT INTO aai_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Boun ayu amatabir maiye anan, yait ayu iyunu anan i biyan anatit, naatu men yait ta ayu ibatiyu’umih, ‘O menika kwenan’ ");
INSERT INTO aai_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Anayabin ayu tur iti ao isan, kwa yababan yen bufuti. ");
INSERT INTO aai_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Baise turobe a tur ao’owen. Iti i kwa a gewasin isan ayu amamatabir maiye. Ayu men ananan na’at, Baibaisayan boro men nan, baise ayu ananan i boro aniyun nan kwa isa. ");
INSERT INTO aai_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","I nanan ana maramaim sabuw iti tafaram ana kakafinamaim hima tesisinaf nabotabirih hinan yawas roumutuforen hinab naatu God ana baibabatiyen saise hinaso’ob gewas. ");
INSERT INTO aai_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","sabuw ayu men tebitutumu anayabin i kakafin wanawanan tema’am; ");
INSERT INTO aai_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","naatu tenotanot roumutufuren i kakafin terarouw, anayabin ayu anan Tamai biyan, naatu boro men kwana’itu maiye; ");
INSERT INTO aai_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","naatu baibabatiyen i boro nan, anayabin God marasika iti tafaram ana kaifenayan i ibabatiy sawar. ");
INSERT INTO aai_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ayu auru tur moumurin maiyow boro atao kwatanowar, baise boun kwa isa ana’o boro men naniyan kwanab. ");
INSERT INTO aai_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Baise anamaramaim turobe ana Anun Kakafiyin nanan, i Boro turobe ana ef etei nabonawiyi. I boro men taiyuwin ana notamaim na’omih, abistanawat enonowar i akisinamo nao, naatu sawar uf hinamamatar isan boro a tur na’owen. ");
INSERT INTO aai_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ayu boro nabora’ara’ahu, anayabin ayu au tur biyau’une bai na kwa a tur eo’owen isan. ");
INSERT INTO aai_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sawar etei ayu Tamai biyan tema’am i ayu nowau naatu abistan ayu biyau ema’am boro Anun Kakafiyin nab nan niwa’an kwa isa nirerereb, anayabin iti isan kwa a tur ao’owen. ");
INSERT INTO aai_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Mar kikimin kwa boro men ayu kwana’itu naatu mar kafai kikimin kwa boro ayu kwana’itu. ");
INSERT INTO aai_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ana bai’ufununayah afa taiyuwih hima hibabatiyih? “Anayabin abistan isan i tur iti na’atube eo, ‘Mar kikimin kwa boro men kwana’itu, naatu mar kafai ufunamaim ayu boro kwana’itu’ naatu ‘Anayabin ayu anan Tamai biyan?’ ");
INSERT INTO aai_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Naatu i hima hi’o hibabatiyih, Iti anayabin nam abisa isan eo’o, ‘Iti mar kikimin?’ Aki men aso’ob i abistan eo’o.” ");
INSERT INTO aai_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu itih so’ob iti isan boro hinibatiy, imih i isah eo, “Ayu iti tur ao isan kwa tayuwiwat kwama kwabibabatiyi anayabin isan, anamaramaim ayu iti na’at ao, ‘Mar kikimin ayu boro men kwana’itu, naatu mar kafai ufunamaim ayu boro kwana’itu.’ ");
INSERT INTO aai_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ayu anababatun a tur ao’owen, Kwa boro kwanarererey naatu kwanigagamat baise tafaram naben nakawasa. Kwa boro kwaniyababan, baise kwa a yababan boro nabotabir yasisir namatar. ");
INSERT INTO aai_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Babin anatoub ana veya nakabom ebiyababan na’atube anayabin biyababan ana veya i na kabom; baise anamaramaim kek tufuw, i ana biyababan inatbuhuruw anayabin kek tafaramamaim tufuw i ebiyasisir. ");
INSERT INTO aai_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Imih kwa auman. Boun i kwa a veya kwaniyababan, baise ayu boro kwa ana’iti maiye naatu kwaniyasisir naatu men karam yait ta kwa a yasisir biyane nabosair. ");
INSERT INTO aai_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nati anamaramaim o men yait ta ayu isou sawaramih inafefeyan. Tur anababatun a tur ao’owen, sawar abistan isan ayu wabu’umaim inabifefeyan, ayu Tamai boro nit. ");
INSERT INTO aai_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Marasika na iti boun kwa men yait ta iti na’atube ayu wabu’umaim fefeyanamih. Boun kwanafefeyan, naatu kwa boro kwanab, naatu kwa boro mar etei yasisiramaim kwanama. ");
INSERT INTO aai_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ayu mar etei kawen turamaim ao kwanowar sawar, mar i enan ayu boro men kafa’imo kawen turamaim anao, baise ayu Tamai isan i boro mutufor bebeyanamaim anao kwananowar, ");
INSERT INTO aai_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nati ana veya’amaim kwa boro ayu wabu’umaim kwanafefeyan. Ayu ao i men kwa au kou anabat Tamai anifefeyanimih. ");
INSERT INTO aai_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aiyabin, Tamai i taiyuwin kwa isa ebiyabow, anayabin kwa ayu isou kwabiyabow naatu kwabitumatum ayu i God iyafaru ana. ");
INSERT INTO aai_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ayu Tamai iyafaru ana, tafaram wanawanan arun abow aremor, boun ayu tafaram abihamiy naatu anan Tamai biyan. ");
INSERT INTO aai_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Naatu Jesu ana bai’ufununayah hi’o, “Bounabo tur bebeyanamaim ku’o’o naatu men kawenamaim ku’o’omih. ");
INSERT INTO aai_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bounabo aki mataito’iwa’an a’i’itin o sawar etei i so’ob, naatu o men yait ta kukokok boro o isa baibat nabow natit. Aki iti’imaim i’obaiyi abitumatum o i Godane ina.” ");
INSERT INTO aai_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu iyafutih eo, “Kwa bounabo kwabitumatum?” ");
INSERT INTO aai_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Baise veya i enan, naatu na titaka, anamaramaim kwa boro na’abargiyi taiyuw a bar a merar na’at kwanabihir. Ayu boro kwanihamiyu nakutatabu ana bat. Baise ayu men akisu anayabin Tamai ayu airi ama’am. ");
INSERT INTO aai_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ayu sawar etei ao kwanowaraka, saise ayu wanawana’umaim kwanama’am kwa karam boro tufuwamaim kwanama. Iti tafaramamaim kwa boro yare wanawanan kwanarun kwani’akir. Baise kwanafair kwanabat! Ayu Tafaram aigegesair.” ");
INSERT INTO aai_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu ana bai’ufununayah isah eo sasawar ufunamaim, au mar nuwra’at naatu yoyoban eo, “Tamai, veya i na tit sawar. Natu wabin kwifai kubora’ara’ah na’atube o Natun Tamah ifai ebora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Anayabin sabuw etei kaifih isan fair itin, saise sabuw iyab o ibitin etei boro yawas wanatowanin nitih. ");
INSERT INTO aai_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iti yawas wanatowan anayabin o su’ubi isan, o akisimo i turobe ana God, naatu Jesu Keriso ibiyafar i auman su’ubin isan. ");
INSERT INTO aai_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iti tafaramamaim a fair ibitu sabuw ai’obaiyih hi’itin, naatu bowabow sinafumih ibitu etei abow aisawar. ");
INSERT INTO aai_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamai nati fair mar tafaram matara’e ana veya ayu itu airit tama’am boun i ayu kwitu maiye.” ");
INSERT INTO aai_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Iyabowat tafaramamaim hima hibowabow ibow ayu ibitu ai obaiyih o hisu’ubi sawar. Nati sabuw i o nowa ibow ayu itu, naatu o a tur hibosiyasiyar hibow. ");
INSERT INTO aai_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naatu bounabo sabuw hiso’ob, sawar ibow ayu ibitu etei o biyane hina. ");
INSERT INTO aai_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tur ayu ibitu etei au bai’ufnunayah ao hinowar sawar naatu hibai hibukikin, hiso’ob i men baifuwenamih. Naatu hiso’ob hitumatum ayu o biyane iyafaru ana. ");
INSERT INTO aai_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ayu ibitu isah ayoyoyoban, men tafaram wanawanan sabuw tema’am isah ayoyoyobanamih baise iyabowat ayu ibitu i isah ayoyoyoban, anayabin nati sabuw i o nowa. ");
INSERT INTO aai_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naatu abistanawat ayu biyau tema’am etei i o nowa naatu abistanawat o biya tema’am i ayu nowau, naatu ayu au fair bonamanamarin i bai’ufununayah biyahimaim irerereb sabuw hi’itin. ");
INSERT INTO aai_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naatu boun i ayu o isa anan, ayu boro men tafaramamaim anama maiye’emih, baise i boro tafaramamaim hinama. Tamai o i Kakafiyin o wab ana fairamaim inatarfafarih nati wab o ibitu’umaim saise hinan ta’imon hinamatar, boun o ayu airit ta’imon tama’am na’atube. ");
INSERT INTO aai_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ayu i bairi ama’am anamaramaim, o wab ayu ibitu imaim atafafarih akaifih gewas bairi ama. Men ta kasiyomih, baise orot ta’imonamo i bai’akir kakafin bai, saise abisa Buk Atamaninamaim hikikirum na iturobe. ");
INSERT INTO aai_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Naatu ayu boun i o isa anan, iti tafaram wanawanan ama’am anamaramaim iti sawar etei isah aobo, saise ayu au yasisir tutufin i wanawanahimaim nakarsuwei. ");
INSERT INTO aai_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ayu a tur aitih, naatu tafaram kwahirih, anayabin i men tafaram nowanamih, boun ayu na’atube men iti tafaram nowanamih. ");
INSERT INTO aai_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ayu au yoyoban i men au bai’ufununayah bosairih isan, baise ayu abifefeyani o wagabur kakafihine inatarfafarih. ");
INSERT INTO aai_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ayu i men iti tafaram nowan, imih i auman men iti tafaram nowanamih. ");
INSERT INTO aai_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","O a turobe’emaim kweiwa’an uhew tematar, O a tur i turobe anababatun. ");
INSERT INTO aai_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ayu tafaram wanawanan aiyafarih hin boun ayu tafaram wanawanan i yafaru anan na’atube. ");
INSERT INTO aai_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","I isah ayu taiyuwu aiwa’an uhew amatar, saise ibo auman o isa anababatun uhew hitamatar. ");
INSERT INTO aai_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ayu men i akisih isah ayoyoyobanamih, baise iyab i hai turamaim ayu isou tebitutumu i isah auman ayoyoyoban, ");
INSERT INTO aai_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","saise i etei hinan ta’imon hinamatar. Tamai boun ayu wanawana’umaim kuma’am na’atube ayu o wanawanamaim anama. Karam i auman hitan wanawanatamaim hitama, saise tafaram hititumatum o i ayu iyafaru ana. ");
INSERT INTO aai_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","O a gewasin ayu ibitu, i aitih, saise i hinan ta’imon hinamatar, boun o ayu airit ta’imon tama’amabe. ");
INSERT INTO aai_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ayu i wanawanahimaim naatu o ayu wanawana’umaim, saise i hinan anababatun ta’imon hinamatar. Saise tafaram boro naso’ob ayu i o iyafaru, naatu o i kubiyabuwih boun ayu kubiyabuwu na’atube. ");
INSERT INTO aai_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamai iyab ayu ibitu i akokok menamaim ama’am bairi imaim anama, saise ayu au marakaw bonamanamarin hina’itin, nati marakaw bonamanamarin o ayu itu, anayabin o iyabuwu ufibo tafaram matar. ");
INSERT INTO aai_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamai mokob maiyow; sabuw iti tafaramamaim o men hisu’ubi, baise ayu wan asu’ubi, naatu etei hiso’ob ayu i o iyafaru ana. ");
INSERT INTO aai_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","O isa ayu aorereb hinowar sawar, naatu ayu boro’ika boro o isa anao’rerereb saise yabow nati ayu ibitu i wanawanahimaim nama naatu ayu taiyuwu i wanawanahimaim anama.” ");
INSERT INTO aai_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu yoyoban sasawar ufunamaim ana bai’ufnunenayah bairi efan nati hihamiy hin Kidron Kwaf hirabon. Nati’imaim i masaw ta, imaim Jesu ana bai’ufnunenayah bairi ten tema’am. ");
INSERT INTO aai_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas yanuwayan menamaim hima’am i so’ob, anayabin Jesu anabai’ufununayah bairi mar etei imaim teruru’ay. ");
INSERT INTO aai_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Imih Judas Romans hai baiyowayah hai kou’ay bonawiyih naatu afa i orot ukwa’ukwarih firis ukwarih biyahine hiyafarih hin naatu afa i Pharisee biyahine hin. I umah, ahay waf hibow naatu hinow hitoto’aben kawih hin masaw yan hitit. ");
INSERT INTO aai_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesu abistanawat boro isan hinamamatar i so’ob, imih au nah isutait tit naatu ibatiyih, “Kwa yait kwanunuwih?” ");
INSERT INTO aai_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hiya’afut hi’o, “Jesu Nazareth mowan. Jesu eo, “Ayu iti wei.” Judas yanuwayan i bairi nati’imaim hibatabat. ");
INSERT INTO aai_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Anamaramaim Jesu eo, “Ayu i iti. I ou’uf hibat naatu me yan hira’iy rabih. ");
INSERT INTO aai_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ibanak i batiyih maiye, “Kwa i yait kwanunuwih.” Naatu i hiya’afut. “Jesu Nazareth mowan.” ");
INSERT INTO aai_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Ayu kwa ouwi wei, ayu i iti.” Jesu iya’afut. “Ayu kwananunuwuhu na’at, basit au bai’ufununayah kwanihamiyih hinan.” ");
INSERT INTO aai_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iti namamatar saise tur abistan hi’o’o i nan niturobe. “Tamaim abistan ibitu, men ta kasiy.” ");
INSERT INTO aai_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Naatu Simon Peter, i ana kaiy auman batabat, rowenra’ah firis ukwarin ana akir orot tainin asukwafune eafuru’um. Akir orot wabin Malchus. ");
INSERT INTO aai_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesu Peter isan eo, “A kaiy kwiwan maiye! O kunotanot, Ayu Tamai kerowas bitu boro men anatom” ");
INSERT INTO aai_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Imaibo Rom rakit wairafih hai ukwarih bairi naatu Jew hai ma’utenayah bairi Jesu hibai hifatum, ");
INSERT INTO aai_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","naatu wantoro’ot hibai hin Annas biyan hitit, nati kwamur wanawanan i Firis ana ukwarin ma’am ana veya, nati orot i Kaiafas rawan. ");
INSERT INTO aai_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iti orot Kaiafas i Jew uwih eo, gewasin orot ta’imon sabuw etei isah tamorob. ");
INSERT INTO aai_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter naatu bai’ufununayan turan ta hairi Jesu hi’ufunun bairi hin. Nati bai’ufununayan ta i firis ukwarin i su’ub, imih i ufunun bairi hin firis ukwarin ana bar merar wanawanan hirun, ");
INSERT INTO aai_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","baise Peter etawan awan bat. Bai’ufnunenayan ta iban matabir maiye tit etawan awan akir babitai ifefeyan naatu babitai Peter iu basit, Peter na fur wanawanan run. ");
INSERT INTO aai_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Babitai etawan awanamaim Peter isan eo, o i ni’i orot ana bai’ufnunenayan orot ta? Peter iya’afut eo, “En ayu men asu’ubimih.” ");
INSERT INTO aai_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nati ana gugumin i siba’u kwanekwan imih akir wairafih naatu ma’utenayah bairi wairaf hi’asir hi’ar bebera’uh hibat rararih. Imih Peter rabon in bairi hibat rararih. ");
INSERT INTO aai_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Firis ukwarin Jesu ana bai’ufnunenayan naatu ana bai’obaibiyen isan ibatiy. ");
INSERT INTO aai_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu iya’afut eo, “Ayu i bebeyan sabuw etei matahimaim a’o a binan hinonowar, naatu au bai’obaiyen mar etei i sibor ya’aya efanamaim naatu Tafaror Bar wanawanan sabuw etei teruru’ay matahimaim. Ayu men abistan ta awa’ir aomih. ");
INSERT INTO aai_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aisim ayu kubibabatiyu, sabuw ayu abistanawat a’o hinonowar i kwibatiyih ayu abisa ao i hiso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu iti na’at eo ana mar ma’utenayan orot ta nati’imaim batabat Jesu rebareban ifar eo, “Men iti na’atube firis ukwarin isan ina’omih.” ");
INSERT INTO aai_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu iya’afutih eo, “Ayu abisa ana’o kakaf na’at sabuw etei hai tur ku’owen, tur menatan i a’o kakaf. Baise ayu tur etei ana’o’o gewas na’at i aisim irabu”. ");
INSERT INTO aai_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Imaibo Annas Jesu uman fatufatum auman iyafar in Kaiafas firis ukwarin isan. ");
INSERT INTO aai_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peter boro’ika ma fora’ab rarar, sabuw afa nati’imaim bairi hima’am hibatiy hio, “O nati orot ana bai’ufnunenayan ta” Baise Peter youb eo, “En, orot nati men ayu’umih.” ");
INSERT INTO aai_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Firis ukwarin ana akir orot ta i Peter tainin ea’afuw ana rara orot ta nati’imaim batabat, eawafoten eo, “O airi ayu masawamaim ait” ");
INSERT INTO aai_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ibanak mar baitounin Peter eo, “En!” naatu mar ta’imon kokorerek eo. ");
INSERT INTO aai_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Maraumanaika Jesu Kaiafas ana barene hibai hin gawan orot ana baremaim hirun. Jew hai ukwarih bar wanawanan i men hirun hinamih, anayabin i men hikok wanawanah kato tamatar naatu hai Tar Nowaten ana hiyuw men hita’aamih. ");
INSERT INTO aai_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Imih Pilate ufun tit sabuw ibatiyih, “Iti orot abisa isan kwa ubar kwabitin?” ");
INSERT INTO aai_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hiya’afut hi’o, “I men kakafin tasisinaf na’at, i boro men atab atan o biya atanamih.” ");
INSERT INTO aai_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate isah eo, “Kwabai kwan, kwa taiyuw a’ofafar eo na’atube kwasinaf.” Ibo hai tur hirutabir hio, “Aki auri men baibasit ta ema’am boro yait ta ana asabunimih.” ");
INSERT INTO aai_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iti na’atube mamatar i Jesu ana tur mi’itube ana morob isan yai eo’o i tan titurobe isan. ");
INSERT INTO aai_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate matabir maiye ana bar wanawanan run naatu Jesu eaf na ibatiy, “O Jew sabuw hai aiwob?” ");
INSERT INTO aai_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu iya’afut eo, “Iti baibat i o taiyuw a not ayu kubibatiyu o sabuw afa ayu isou a tur hi’owen?” ");
INSERT INTO aai_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate iya’afut, “O kunotanot ayu i Jew orot? O taiyuw a sabuw naatu firis ukwa’ukwarih o hibuw hinawiy ina ayu isou. Abisa isinaf?” ");
INSERT INTO aai_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu eo, “Ayu au aiwob i men iti tafaram nowanamih, baise ayu au aiwob iti tafaram nowan na’at, ayu au bai’ufununayah boro isou hitiyow, naatu Jew hai ukwarih umah wahine boro hitawasfafaru. En, ayu au aiwob i men iti faram nowanamih.” ");
INSERT INTO aai_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Imih Pilate ibatiy, “Bo o i aiwob orot? Jesu iya’afut eo, “Nati tur i gewasin ku’o’o, ayu i aiwob. Ana an ta’imon i nati isan. Ayu atufuw ana iti tafaram wanawanan arun, turobe ata’orereb. Yait turobe oukoun ebatabat fanau ebobosiyasiyar.” ");
INSERT INTO aai_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate Jesu ibatiy, “Turobe i abistan” Iti tur nonowar ibanak matabir maiye ufun tit Jew sabuw isah eo, “I biyanamaim men kakafin ta atita’ur boro imaim anibabatiy. ");
INSERT INTO aai_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Baise kwa a binanakwar eo na’atube. Tar Nowaten hiyuw aa ana veya diburane orot ta kwa isa anabotait. Kwa kwakokok Jew hai aiwob anabotait na tit.” ");
INSERT INTO aai_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Isan hitarakouw hiwow hi’o, “En, men nati orotomih! Aki akokok i Barabas.” ");
INSERT INTO aai_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Naatu Pilate ma’utenayah uwih, Jesu hibai hibowabiwabir sawar. ");
INSERT INTO aai_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","imaibo ma’utenayah kokor hi’afuw hififin ana kowasimih ukwarin hiyoun, naatu faifuw wair hibai hi’osenawein, ");
INSERT INTO aai_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","naatu hiyen hin biyan hitit naatu hi’o, “Jew hai aiwob ma’ama’anin!” Naatu yumatanamaim hifafar. ");
INSERT INTO aai_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate ibanak tit maiye sabuw rou’ay isah eo, “Ayu iti orot kwa namaim abai atitit i anao kwanaso’ob, i biyanamaim ayu men kakafin ta atita’ur.” ");
INSERT INTO aai_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesu ana kowas kokor ukwarin hiyow naatu ana waifuw wair hi’osenawein imaibo hibai hititit. Pilate sabuw isah eo, “Orotoban iti.” ");
INSERT INTO aai_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Firis ukwarih naatu i ana sabuw ukwa’ukwarih bairi hinuw hi’i’itin anamaramaim hitarakouw hi’o, “ku’onaf, ku’onaf!” Pilate eo “I Kwabai kwan kwa’onaf, ayu isou’une i ana kakafin men ta atita’ur.” ");
INSERT INTO aai_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sabuw hiya’afut maiye hi’o, “Aki ai ofafar eo i boro namorob, anayabin i taiyuwin eorerereb God natun rauw eo.” ");
INSERT INTO aai_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate iti nonowar i ana bir ra’at, ");
INSERT INTO aai_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","matabir maiye bar wanawanan run naatu Jesu ibatiy, “O menane ina?” Baise Jesu men tur ta eomih. ");
INSERT INTO aai_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate Jesu isan eo, “O men kukokok tur ta ayu isou inao?” “Inaso’ob, ayu isou i fair ema’am boro o ana botaiti inatit o boro ana onafi.” ");
INSERT INTO aai_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu iya’afut, “Iti fair ayu tafau’umaim ibai kuma’am, anayabin iti fair i God it. Imih orot yait ayu o isa yayabunu i bowabow kakafin gagamin maiyow bai. ");
INSERT INTO aai_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ana maramaim Pilate iti tur nonowar ef nuwet mi’itube Jesu tabotait isan. Baise rou’ay hitarakouw i matabir maiye run, “o nati orot inabobotait ana itinin o i men Caesar ana ofamih. O yait ta aiwob inararouw, o i Ceaser ana wosai orot”. ");
INSERT INTO aai_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate iti tur nonowar ana maramaim Jesu bai tit ufun efan wabin teo kabay ana’ubun imaim baibabatiyen ana ura ma’ama tafan mare (Hebrew tur i te’o Gabbatha). ");
INSERT INTO aai_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Veya na bi’ouyit nati i Tar Nowaten ana hiyuw ana veya nanamaim Pilate sabuw isah eo. “Kwa a aiwob orot i iti”. ");
INSERT INTO aai_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hitarkoukuw hi’o, “kwa’asabun! kwa’asabun!” kwa’onaf! Pilate ibatiyih, “Kwakokok ayu a aiwob ana onaf?” Firis ukwa’ukwarih hiya’afut hi’o, “Aki ai aiwob i ta’imon maiyow, Caesar akisinamo”. ");
INSERT INTO aai_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Imaibo Pilate Jesu ya’abun i isah onafinamih hibai hin. Naatu Jesu hibonawiy onafinamih hin. ");
INSERT INTO aai_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesu tit ana onaf abar remor in ukwarih rarik ana efanamaim tit. (Hebrew fanahimaim Golgotha). ");
INSERT INTO aai_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nati’imaim hi’onafen, naatu orot rou’ab auman, Jesu foun in, orot rou’ab roun roun hi’in. ");
INSERT INTO aai_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate fef kirum naatu onafamaim hidudun, Kikirum i JESU NASARETH OROT, JEWS HAI AIWOB. ");
INSERT INTO aai_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sabuw moumurih maiyow iti kikirum hi’itin hiyab, anayabin efan iti Jesu hio’onaf i men yokomih bar merar gagamin sisibin. Iti tur i Hebrew, Latin naatu Greekamaim kirum. ");
INSERT INTO aai_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Firis ukwarih, Pilate isan hio, “Jew hai aiwob bikirumin, i eo i Jew hai aiwob.” ");
INSERT INTO aai_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate iya’afut, “Abistan ayu akikirum, i kirum.” ");
INSERT INTO aai_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Rakit wairafih Jesu hio’onaf ufunamaim ana waifuw hibow hiyarouseben matah kwafe’en himatar, matah taita’imon hiya, rakit wairafih taita’imon isah. Naatu faifuw tafan ebiyoun aurin sakisakir en auman hibai. ");
INSERT INTO aai_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rakit sabuw taiyuwih isah hio, “Men tanasib baise tani’arow tana’itin yait boro nab.” Iti mamatar i tur marasika hio hikirum inu’in i titurobe isan. “Au faifuw hibow taiyuwih hai fonamaim hiyarouseb hibow naatu au tafan baibiyon hibai hi’arouw.” Naatu baiyowayah i iti na’atube hisinaf. ");
INSERT INTO aai_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesu ana onaf anamaim i hinah batabat, naatu i hinah rubun, Mary Clopas aawan naatu Mary Magdalin. ");
INSERT INTO aai_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu hinah naatu ana bai’ufununayan orot i ana yabow hairi hibatabat itih, imih hinah isan eo, “Natu ina’itin.” ");
INSERT INTO aai_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Naatu bai’ufununayan orot isan eo, “Hinat ina’itin”. Nati ana veya’amaim bai’ufununayan orot hinah bai hairi hin ana baremaim hima. ");
INSERT INTO aai_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesu so’ob bounabo sawar etei’imak na ana yomanin tit, marasika Buk Atamaninamaim hikirum inu’in na iturobe. Jesu eo “Ayu sikou mamah.” ");
INSERT INTO aai_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tew ta nati’imaim harew tenakuyakuy awan karatan batabat, wanabir hibai harew hibu’utu’ub isikar wan himetan hi’otra’ah Jesu ufurinamaim hiyei. ");
INSERT INTO aai_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesu harew kartoman naatu eo, “Iti’imaim sawar.” Imaibo sikan sir naatu ayubin tabaratait. ");
INSERT INTO aai_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jew ukwa’ukwarih Pilate hifefeyan baibasit baitih orot hio’onafih ah tarkakakiren isan, naatu biyah onaf afe’enane bow yara’iyen isan. Hifefeyan anayabin ana mar natot i Baiyarir Ana Veya. I men hikok biyah boro auyom hita’in. ");
INSERT INTO aai_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Imih baiyowayah hin orot ta wan an hitarkakiren naatu hin orot bairu’abin an hitar kakiren, iti orot hairi i Jesu bairi hio’onafih. ");
INSERT INTO aai_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Baise hina Jesu biyan hititit i moroboka inu’in hi’itin, isan imih an men hitarkakiren. ");
INSERT INTO aai_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","An hitatakakiren efanin sorodiy kiram robra’at Jesu naiwan yi naatu mar ta’imon rara naatu harew auman suwa re. ");
INSERT INTO aai_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Orot iti matar i’itin i eo’orereb, naatu anaorerereb i turobe. I so’ob abistan eo i turobe, isan imih kwa auman kwana’itin kwanitumatum. ");
INSERT INTO aai_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iti na’atube matar saise abisa Buk Atamaninamaim hikikirum na iturobe. “Boro men ana rarik ta natato’ob.” ");
INSERT INTO aai_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tur tabo Buk Atamaninamaim eo, “Sabuw boro hinanuw nati hiyiy hina’itin.” ");
INSERT INTO aai_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iti ufunamaim Joseph Arimathea orot, Jesu ana bai’ufununayan ta wa’iwa’iramaim na Pilate ifefeyan Jesu biyan tab isan. Anayabin Jew hai ukwarih isah bir. Pilate ana baibasitamaim, Joseph na Jesu biyan bai yare. ");
INSERT INTO aai_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus gugumin ta i wan in Jesu i’itin, i boun raiy ta wabin myrrh naatu raiy ta wabin aloes auman higagamuw ana bit i 30 kilos bai na Joseph hairi hin. ");
INSERT INTO aai_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Orot hairi Jesu biyan hibu’ub hiyare naatu Jew hai bairahiya ana efamaim biyan raiyamaim hibobunei naatu rah ana faifuwamaim hisum. ");
INSERT INTO aai_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Efan menamaim Jesu momorob i sisibinamaim i masaw ta, naatu nati masaw wanawanan hub boubun men yait ta imaim hiyai. ");
INSERT INTO aai_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iti ufunamaim i Baiyarir Ana Veya, anayabin hub i yubin, isan imih Jesu biyan hibai hin imaim hiyai. ");
INSERT INTO aai_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Fur an bubusuruf, maraumanika Mary Magdalin eregugumin auman in hubemaim tit, nuwanuw hub awan kabay hifururuw tit inu’in itin. ");
INSERT INTO aai_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Imih i matabir erenunuw in Simon Peter biyan naatu bai’ufununayan orot ta Jesu biyabuw i hairi biyah tit naatu eo, “Sabuw hina Regah biyan hubemaim hibosair naatu i menamaim hiya’iy, it men taso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Imih Peter naatu bai’ufununayan orot ta hairi hub itinamih hin. ");
INSERT INTO aai_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Naatu hairi erenununuw hin, baise bai’ufununayan orot ta Peter i gegesair i wan in hubemaim tit. ");
INSERT INTO aai_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naatu i kwafure nuwariy waifuw Jesu hisumisum inu’in itin baise men runamih. ");
INSERT INTO aai_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Naatu Simon Peter, uf nunuw na tit naatu in hub wanawanan run, waifuw Jesu hisum inu’in itin. ");
INSERT INTO aai_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","naatu murubih tesumasum ana faifuw Jesu nukwarin himetan auman inu’in itin. Nati waifuw i taiyuwinawat nu nabin in, men Jesu biyan hisumisum aumanamih. ");
INSERT INTO aai_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naatu bai’ufunenayan orot ta wan na hubamaim titit, i auman run. Itin itumatum. ");
INSERT INTO aai_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Naatu Buk Atamaninamaim eo i men hiso’ob, Jesu i boro morobone namisir. ");
INSERT INTO aai_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naatu bai’ufnunenayah himatabir hai ubar hin. ");
INSERT INTO aai_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","baise Mary hub ufunane bat rererey. Rerey auman kwafure hub wanawanan nuwariy ");
INSERT INTO aai_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","naatu tounamatar rou’ab hai waifuw kwes Jesu inu’in ana efanamaim hima’am, ta nukwarinane ta anane. ");
INSERT INTO aai_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","I babin hibatiy, “O aisim kurererey?” Babin eo, “Au Regah hibosair hibai hin menamaim hiyai, naatu ayu men aso’ob.” ");
INSERT INTO aai_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iti na’atube eo ana veya tatatabir Jesu nati’imaim batabat itin, baise i men so’ob nati i Jesu. ");
INSERT INTO aai_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu eo, “Babin, o aisim kurererey? O i yait kununuwih” Babin notanot i masaw bowayan ta, imih i eo, “O inab inanan na’at, kuo anowar menamaim iyai saise ayu anan anab.” ");
INSERT INTO aai_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu babin isan eo, “Mary” Naatu Mary tatabir Jesu isan rerey Aramaic turamaim eo, “Rabboni.” Anayabin i Bai’obaiyenayan. ");
INSERT INTO aai_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu eo, “Biyau men inabutubun, anayabin ayu men amatabir an Tamai biyan atitamih. baise kwen taitu hai tur ku’owen. Ayu amamatabir Tamai isan na’atube kwa Tamat, ayu au God kwa auman a God.” ");
INSERT INTO aai_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalin tur bai matabir in bai’ufnunenayah biyah tit, eo, “Ayu Regah aitin.” Naatu Jesu abistanawat eo nonowar i hai tur eowen. ");
INSERT INTO aai_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Fur antoro’ot bubusuruf ana rabirab, bai’ufununayah etei’imak hiru’ay bar wanawanan etawan hitufabon hima’am, anayabin Jew hai ukwarih isah hibir. Jesu na hai founamaim bat naatu eo, “Tufuw isa nama.” ");
INSERT INTO aai_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iti na’atube eo’o ufunamaim, i uman naatu sisibin i’obaiyih. Anamaramaim Regah hi’i’itin, bai’ufununayah yasisir dogoroh awan karatan. ");
INSERT INTO aai_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu ibanak eo maiye, “Tufuw isa nama! Tamat ayu iyunu ana, na’atube ayu kwa abiyuni.” ");
INSERT INTO aai_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Naatu earatit tafahimaim yen naatu eo, “Anun Kakafiyin kwabai. ");
INSERT INTO aai_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","O yait ta tura ana kakafin inanonotawiy na’at, i i notawiy, o men hai kakafih inanonotawiyen na’at, God men nanotawiyihimih.” ");
INSERT INTO aai_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas, wabin ta Kikifukek, bai’ufununayah nah 12 i orot ta, i men bairi hima’am Jesu natitamih. ");
INSERT INTO aai_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bai’ufnunenayah afa ana tur hi’owen, “Aki Regah a’itin.” Baise i’uwih eo, “Ayu matou yan tout ana fit ana itin naatu menamaim tout ana fit umu kim anakutuwariy naatu sisibin ana fit anabutubun, ayu boro men anitumatum.” ");
INSERT INTO aai_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Fur nati ufunamaim ana baitumatumayah ibanak hiru’ay maiye bar wanawanan hima’am, naatu Thomas i nati’imaim bairi etawan hitufabon hima’am, Jesu na hai founamaim bat naatu eo, “Tufuw isa nama!” ");
INSERT INTO aai_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Naatu Thomas isan eo, “Uma kim iti’imaim kuyai, umu kwi’itah. Uma ku’ut ena au fit kubutubun. Kasiy kwihamiy naatu kwitumatum.” ");
INSERT INTO aai_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas Jesu isan eo, “Ayu au Regah, au God.” ");
INSERT INTO aai_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Naatu Jesu Thomas iu, “Anayabin o ayu i’itu imih kubitumatum; iyab men ayu ti’i’itu baise tebitumatum i baigegewasin tebaib.” ");
INSERT INTO aai_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu ina’inanen afa gewagewasih moumurih maiyow sinafen ana bai’ufununayah matahimaim, nati afa men bukamaim hikirumen ti’inu’in. ");
INSERT INTO aai_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Baise iti afa i hikirumen ti’inu’in saise imaim kwana’itin kwanitumatum Jesu Keriso, i God Natun, naatu i wabinamaim kwanabitumitum kwa boro yawas kwanab. ");
INSERT INTO aai_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iti ufunamaim Jesu ibanak maiye ana bai’ufnunenayah isah irerereb, Taibirias Harew Kukufamaim. Anamatar i iti na’atube matar. ");
INSERT INTO aai_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas wabin ta Kikifukek, Nathanael Canna orot, Galilee wanawanan, Zebedee natunatun, naatu bai’ufnunenayah rou’ab auman nati’imaim bairi hima’am. ");
INSERT INTO aai_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter turahinah iuwih, “Ayu anan buwat anaya’amih.” Turahinah hio, “Aki boro bairit tanan.” Imih hitit hin wa hibai buwat ya’amih hin. Baise nati gugumin men siy ta eonamih. ");
INSERT INTO aai_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Maraumanika Jesu dones yan tit bat, baise bai’ufnunenayah Jesu men hi’inan. ");
INSERT INTO aai_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesu isah eafatait eo, “Au ofonah, kwa siy ta kwabai?” Hiya’afut hio, “Eno.” ");
INSERT INTO aai_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesu iuwih eo, “A buwat wa sisibin asukwafune kwaya boro siy afa hina’on.” Imih i eo na’atube hisinaf, naatu men karam boro buwat hitabora’ah tayen, anayabin siy buwat etei bai sonan. ");
INSERT INTO aai_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naatu bai’ufnunenayan menatan Jesu biyabuw i Peter isan eo, “No’om Regah wei.” Simon Peter tur Regah nonowar mar ta’imon ana biya baibiyon tafan bosair i kununuw riy yan re. ");
INSERT INTO aai_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bai’ufnunenayah afa hi’ufunun, buwat siy sonan auman hitain hirun. Naatu dones tit in i biyah titit men yok, 100 metres anafofonin. ");
INSERT INTO aai_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hirun wa hiyut hinunura’at wairaf ana waru’umawat dones yan inu’in hi’itin siy naatu rafiy afa auman wairaf wan hi’in hi’a’arat. ");
INSERT INTO aai_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu iuwih eo, “Siy iti boun kwabowabow afa kwabow kwana kwaitu.” ");
INSERT INTO aai_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter yen wa afe’en bat buwat bai tain na dones rewan yen. Siy gagagamih buwat awan karatan, etei 153, siy moumurih maiyow hi’on baise buwat men takweb. ");
INSERT INTO aai_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu isah eo, “Kwana marauman ana bay taa.” Bai’ufnunenayah men ta not baibatiyin isan, “O i yait?” I hiso’ob nati i Regah. ");
INSERT INTO aai_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesu na faraw bai naatu itih, siy auman na’atube sinaf. ");
INSERT INTO aai_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iti i mar baitaunin Jesu ana bai’ufnunenayah isah irerereb morobone mimisir ufunamaim. ");
INSERT INTO aai_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bay hi’aa sasawar ufunamaim, Jesu Simon Peter isan eo, “Simon John natun, o turobe ayu kubiyabuwu men iti afa tebiyabuwu na’atube?” Simon eo, “Au Regah, o iso’ob ayu o abiyabuwi.” Jesu eo, “Au bowbaituw inituw” ");
INSERT INTO aai_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesu ibanak eo maiye, “Simon, John natun o turobe ayu kubiyabuwu?” Simon iya’afut eo, “Au Regah, o i so’ob ayu o abiyabuwi.” Jesu eo, “Au bobaituw inakaifen.” ");
INSERT INTO aai_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesu mar baitonin Simon isan eo, “Simon John natun, o ayu kubiyabuwu?” Peter iyababan anayabin Jesu mar baitonin ibatiy, “O ayu kubiyabuwu?” Peter eo, “Regah, sawar etei o iso’ob, o iso’ob ayu o abiyabuwi.” Jesu eo, “Au bobaituw inituw.” ");
INSERT INTO aai_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Turobe a tur ao’owen. “Orot boub ima’am ana veya o taiyuw i’osenweini, naatu menamaim a kok imaim iremor, baise inabiregah anamaramaim o boro uma ina’oftobotobon, sabuw afa boro hini’osweini naatu efan men akok boro imaim hinabonawiyi kwanaremor.” ");
INSERT INTO aai_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu tur iti na’atube eo anayabin, i Peter ana morob ef mi’itube boro namorob imaim God wabin nifai nabora’ara’ah. Naatu Peter isan eo, “Kuna kwi’ufnunu.” ");
INSERT INTO aai_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter tatabir nuw, naatu bai’ufununayan Jesu biyabuw i bi’ufnunih itin. Iti bai’ufnunenayan i aa fufun ana bay hi’aa Jesu sisibinamaim tugeger eo, “Regah yait boro o nayanuwi?” ");
INSERT INTO aai_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter nuw ayu John i’itu ana maramaim, Jesu ibatiy, “Regah iti orot isan i mi’itube?” ");
INSERT INTO aai_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu iya’afut eo, “Ayu anakok i yawasin ma ayu matabir maiye anararauw na’at, o isa mi’itube kunotanot? Kwi’ufnunu.” ");
INSERT INTO aai_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Anayabin iti isan tur tasasar tit bowturah etei hinowar, iti bai’ufnunenayan i boro men namorob. Baise Jesu eo’o i men morob rouw eomih. I tur iti akisinamo eo, “Ayu anakok i yawasin ma ayu matabir isan, nati o i mi’itube kunotanot?” ");
INSERT INTO aai_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bai’ufnunenayan iti i boun sawar etei isah eorereb naatu kirumen. It taso’ob i ana eorereb i turobe. ");
INSERT INTO aai_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesu sawar moumurih maiyow afa auman sinafen. Sawar etei’imak fefemaim hitakikirum na’at, ayu anotanot iti tafaram tutufin wanawanan boro fef awan takaratan. ");
INSERT INTO aai_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus au buk wantoro’ot i Jesu ana bowabow etei mi’itube busuruf bow sabuw i’obaibiyih inan ");
INSERT INTO aai_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","God bora’ah au mar yey isan i ao akirum. Baise au mar yena’e ana veya orot iyab kob abarin isan rurubinih i Anun Kakafiyinane roube’aten tur itih. ");
INSERT INTO aai_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ana bai’akir ufunamaim, isah irerereb hai not hikwaris hima hibinotanot ana sinaf ef tata’amaim botabirih hi’itin hiturobe i, i yawasin ma’ama, veya 40 wanawanan ana bairererebamaim God ana aiwob isan i’obaibiyih hima hinowar. ");
INSERT INTO aai_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Veya ta bairi hima bay hi’aa ana maramaim, iuwih eo, “Jerusalem men kwanihamiy, baise kwanama Tamai a siwar baitimih eomatani, ao kwanonowar isan kwanakaif. ");
INSERT INTO aai_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Anayabin John i harewamaim bapataito it, baise veya bai’ab na’atube ufunamaim kwa boro Anun Kakafiyinamaim bapataito kwanab.” ");
INSERT INTO aai_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Basit Tur Abarayah etei hina hibita’imon ana veya hibatiy, “Regah, karam iti boun aiwob itab Israel sabuw ititih maiye?” ");
INSERT INTO aai_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iyafutih eo, “Veya naatu sumar abisa’amaim iti sawar hinamamatar isan i God akisin ana fair tafanamaim veya yakitifuw, i boro men kwa kwanaso’obamih. ");
INSERT INTO aai_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Baise kwa i Anun Kakafiyin nanan ana veya’amaim fair boro kwanab, naatu ayu isau Jerusalemamaim boro kwanabusuruf kwanakubuna, kwanatit Judea wanawanan, Samaria, naatu kwanatit kwanan tafaram yomanin.” ");
INSERT INTO aai_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iti na’atube eo ufunamaim, God bora’ah yen himtitiy auman in sakuk wanawanan run himat kasiy. ");
INSERT INTO aai_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Matah etei hikubar nati mar wanawanan rurumaim hibat hi’i’itin, naniyan meyemeye orot rou’ab hai faifuw kwes sisibihimaim himatar. ");
INSERT INTO aai_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Naatu hi’uwih. “Galilee oro’orot, kwa aisim kwabat au mar kwanuwanuw? Iti Jesu ta’imon God kwa biyamaim bora’ah au mar yey, i boro ef ta’imon kwa’itin yeyebe boro namatabir maiye nanan kwana’itin.” ");
INSERT INTO aai_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Imaibo Olive Oyaw hihamiy himatabir maiye hin Jerusalem hitit, ef ana manin i one kilometre na’atube. ");
INSERT INTO aai_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hina bar hitit, naatu hiyen bar awan ta no tafan i hima’ama’amaim hitit. Iyabowat nati’imaim hima’ama wabih i iti, Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, naatu James, Alpheus natun, naatu Simon Kafafarayan, naatu Judas, James natun. ");
INSERT INTO aai_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iti orot i mar etei hina hita’imon hiyoyoyoban, baibin bairi, naatu i wanawanahimaim i Mary Jesu hinah naatu taitin auman. ");
INSERT INTO aai_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nati ana veya’amaim bai’ufununayah etei 120 na’atube wanawanahimaim Peter misir eo, ");
INSERT INTO aai_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Taitu, marasika Anun Kakafiyin David iwan Bukamaim eo kikirum i Judas ana sinafumaim nati tur na yabin matar. I rafot rouwayan na’atube sabuw bonawiyih Jesu hifatum. ");
INSERT INTO aai_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas i ata kou’ay orot ta naatu iti bowabow wanawananamaim bairi tabow. ");
INSERT INTO aai_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bowabow kakafin sisinaf isan ana baiyan hibitin imaim me tubun ukwarin aubabe re yi yan fudir kabutin ihouw. ");
INSERT INTO aai_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sabuw Jerusalem hima’ama etei ana tur hinowar, imih hai turamaim nati efan wabin Akeldama hiwab. Wab anayabin ‘Rara ana Efan.’ ");
INSERT INTO aai_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Anayabin Psalm wanawananamaim iti na’atube eo, ‘Ana bar kwaihamiy eowarar, naatu men yait ta nati’imaim narun nama’amih.’ Naatu iban maiye eo. ‘Ana efan orot ta kwanitin.” ");
INSERT INTO aai_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Isan imih, igewasin orot yait ata Regah Jesu wanawanatamaim ma reremor ana veya i bairi tama tabowabow boro i tanarubin. ");
INSERT INTO aai_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Naatu nati orot i John Baptist ana veya’amaim bairi taibuya tana Jesu hibora’ah au mar yey i boro tanarubin. Anayabin ata orot ta nati na’atube tanarurubin i boro Jesu morobone mimisir isan bairi sif tanarubon.” ");
INSERT INTO aai_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Basit orot rou’ab hikutaitih, Joseph wabin ta Barsabas, wabin baitounin Justus naatu Mathias hairi hirubinih. ");
INSERT INTO aai_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Imaibo hiyoyoban. “Regah o sabuw etei dogoroh iso’ob. Imih abifefeyani orot iti rou’ab kwi’obaiyi menatan i o irubin. ");
INSERT INTO aai_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas ana efan nab tur abarayan namatar, anayabin Judas iti efan ihamiy ana ma’ama efan rurubinimaim in.” ");
INSERT INTO aai_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Imaibo hi’arow, naatu Mathias wabin hisusu’ub ana veya arow ben, basit Mathias hibai tur abarayah nah 11 hima’ama wanawanah run. ");
INSERT INTO aai_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost ana veya na tit, etei’imak hiru’ay efan ta’imonamaim hima. ");
INSERT INTO aai_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Naniyan meyemeye yaurabad nidun wowogabe marane rena bar hima’am imaim run awan karatan. ");
INSERT INTO aai_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Naatu abisa hi’i’itin i wairaf orot menan na’atube tamunimun na ta’ita’imon tafahimaim mara’ara’at. ");
INSERT INTO aai_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Etei’imak Anun Kakafiyin iwanih menah botabir tur tata’amaim hio, Anun Kakafiyin fair bitih na’atube. ");
INSERT INTO aai_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nati ana veya, Jew sabuw God ana bowayah orot gagamih etei tafaram tata’ane hiru’ay Jerusalemamaim hima’am. ");
INSERT INTO aai_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iti nidun hinonowar ana maramaim sabuw rou’ay gagamin na’in hiru’ay hima’am, hai kasiy ra’at naatu hifofofor men kafaita, anayabin etei hai turamaim hio hinowar. ");
INSERT INTO aai_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kasiy gagamin maiyow isah matar naatu taiyuwih hibabatiyih. “Iti sabuw tur teo etei i Galilee oro’orot? ");
INSERT INTO aai_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naatu mi’itube’emih it ata turamaim hio tanonowar? ");
INSERT INTO aai_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","It i tafaram ta ta’ika tana, Partia, Media, Ilam naatu afa i Mesopotamia’ane hina, Judea, Kapadosia, Pontus naatu Asia, ");
INSERT INTO aai_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigia, Pamfilia, Egypt naatu Libia wanawanan turin Sairini na’atune auman hina tema’ama. Naatu Romene nanawan auman hina Jerusalem tema’am. Nati i Jew sabuw naatu sabuw afa hai baitumatum hibotabir hina Jew sabuw himamatar auman. ");
INSERT INTO aai_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","It afa i Kurit naatu Arab sabuw. Baise God sawar gewasih maiyow sisinaf isan ata turamaim hio tanonowar!” ");
INSERT INTO aai_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sabuw hifofofor naatu hai kasiy ra’at taiyuwih hibabatiyih hio, “Iti sawar anayabin i abisa?” ");
INSERT INTO aai_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Baise sabuw afa hi’iyab hio, “Nati sabuw i harew fokarin, hitom imih teo kwanekwan!” ");
INSERT INTO aai_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tur Abarayah etei 11 hai founamaim Peter misir fanan aumetawat sabuw rou’ay gagamin na’in isah eo, “Taitu tuwai’inah Jew sabuw naatu kwa iyab Jerusalem wanawanan kwama’am, akokok tain kwanarub gewas sawar iti mamatar anayabin anakubuna kwananowar. ");
INSERT INTO aai_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kwa kwanotanot iti orot i harew fokarin hitom tibikoko’aw, baise, boun i nine korok mar auman. ");
INSERT INTO aai_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imih i men harew hitomamih, baise dinab orot Joel ana Bukamaim Atamaninamaim kirum eo, ");
INSERT INTO aai_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mar ana yomaninamaim God eo, Ayubu boro sabuw etei tafahimaim anisuwai nare. Kwa natunat oro’orot naatu baibitar boro dinabatur hinao, a orot baubuh boro matah hinabora’ah sawar hina’itah, naatu a orot gagamih boro hinamim. ");
INSERT INTO aai_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Isa’amih, nati ana veya ayu au akir wairafih, oro’orot naatu baibin etei, tafahimaim Anunu anisuwai nare dinabatur hinao. ");
INSERT INTO aai_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ayu boro maramaim baifofofor ana sinaf naatu ina’inan tafaramaim ana sinaf, Nati’imaim boro rara, wairaf, naatu sow agor kutikutin kwana’itin. ");
INSERT INTO aai_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Veya matan boro nagugum naatu sumar matan boro rara namatar, imaibo Regah ana veya gagamin bodiridirin nanan natit. ");
INSERT INTO aai_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Orot yait Regah wabin su’ub e’afa’af boro yawas nab.’” ");
INSERT INTO aai_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel sabuw tur iti kwananowar! Jesu Nazareth mowan i God rubin naatu i wanawanamaim ina’inan yumatah ta ta, baifofofor ta ta God kwa biyamaim sinaf kwa’itin kwaso’ob. ");
INSERT INTO aai_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iti orot hibai kwa umamaim hiyai kwa’a’asabun i God ana kok naatu marasika yakitifuw inu’inumaim matar, naatu kwa sabuw kakafih hai baibaisamaim Jesu kwabai onaf afe’en kwa’onaf morob. ");
INSERT INTO aai_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Baise God morobone iyawas maiye misir, naatu morob ana biyababanane rufam tit, anayabin morob ana fair men karam boro diburamaim tabotan tama. ");
INSERT INTO aai_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David nati orot isan eo, ‘Ayu Regah mar etei nau’umaim ai’itin, anayabin i ayu umau asukwafune, imih ayu boro men hininanawiyu. ");
INSERT INTO aai_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Isan imih ayu dogorou ebiyasisir naatu awau’umaim i kawasa tur etitit, ayu i orot afa na’atube, baise God ana’omatanen isan ayu i nuhufot ama’am. ");
INSERT INTO aai_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anayabin o boro men ininatbuhuruwu rahemaim ana’in, na’atube a Orot Kakafiyin boro men ina’itin namasamih. ");
INSERT INTO aai_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O yawas ana ef i’obaiyu, naatu o ataragub wanawananamaim aiyasisir boro iniwansumu.’” ");
INSERT INTO aai_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Taituwau Jew, bebeyan a tur ao’owen aiwob orot David ata agir wabin gagamin, morob hiyai naatu ana rah i iti biyatamaim inu’in. ");
INSERT INTO aai_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Naatu David i dinab orot God omatanen ana obaifaro auman yayare i so’ob, veya ta David ana rara’ane i uwan ta boro ni’aiwob. ");
INSERT INTO aai_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God mar boro nanan abisa nasisinaf David i so’ob, Keriso morobone misir maiye isan ana tur i nowar. ‘Biyan boro men ninatbuhuruw moroboyah hai efanamaim na’in na’atube biyan boro men na’itin namasamih.’” ");
INSERT INTO aai_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“God iti Jesu i boun morobone iyawas maiye misir, naatu aki i iti sawar himamatar ana sif robonayah. ");
INSERT INTO aai_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God iti Jesu bora’ah yen uman asukwafune mare, naatu Tamah biyanane Anun Kakafiyin eo’omatan bai aki tafai yan isuwai re’er boun iti kwa’i’itin naatu kwanonowar. ");
INSERT INTO aai_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Naatu David i men au mar yenamih, baise iti tur i eo, ‘Regah au Regah isan eo Umau asukwafune kumare. ");
INSERT INTO aai_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Inama’am a kamabiy sabuw ana bow a babanamaim anaya.’ ");
INSERT INTO aai_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Isan imih kwa Israel sabuw iti tur ao i kwanaso’ob gewas. God iti Jesu kwabai kwao’onaf i bai yen ata Regah naatu ata Roubininenayan matar!” ");
INSERT INTO aai_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sabuw iti tur hinonowar ana veya dogoroh rusib Peter naatu Tur Abarayah hibatiyih, “Taitu tuwai’inah aki boro mi’itube ana sinaf?” ");
INSERT INTO aai_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter iyafutih eo, “Kwa etei dogor hinikitabir naatu Jesu Keriso wabinamaim bapataito kwanab, saise a bowabow kakafih nanotawiyen, naatu God ana usar Anun Kakafiyin boro kwanab. ");
INSERT INTO aai_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Iti omatanen i kwa isa naatu kwa natunat isah, na’atube sabuw tutufin etei iyab ef yok tema’am ata Regah God boro na’a’afih isah.” ");
INSERT INTO aai_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter tur maumurih na’in imaim imatnuwih naatu ifefeyanih eo, “Sabuw tafa’asarih wanawanah kwama’am saisewat kwanatit kwaniyawasi!” ");
INSERT INTO aai_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sabuw maumurih na’in iti tur hinonowar hitumatum naatu bapataito hibai, nati ana veya’amaim sabuw etei 3000 na’atube nati kou’ayamaim hirun. ");
INSERT INTO aai_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Naatu hai veya hiya’asair Tur Abarayah biyahine tur hinowar bairi hibita’ay, rafiy himseseb hifaram hi’aa naatu hiyoyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tur Abarayah wanawanahimaim ina’inan naatu baifofofor maumurih maiyow hisisinaf sabuw awah ha’e. ");
INSERT INTO aai_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bai’ufununayah mar etei hina hita’imon sawar i nowah etei nena hifafarambonen. ");
INSERT INTO aai_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Naatu hai sawar was arin, roumukur arin etei hibow hin hitobon kabay hibai hina wanawanahimaim sabuw iyab hai kok abisa isan hibiyababan etei ana fofonin hifafarambonen. ");
INSERT INTO aai_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Veya matan hiyi Tafaror Bar gagaminamaim hiruru’ay. Naatu hai baremaim bay himseseb dogoroh ere yasisir auman hi’aa, ");
INSERT INTO aai_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","God hibobora’ara’ah naatu sabuw etei tur abarayah isah i hibiyasisir. Naatu veya ta’ita’imon ana fofonin sabuw iyab God biyawasih Regah bow ana kou’ay wanawanan yababar rara’at. ");
INSERT INTO aai_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Veya ta rabirab three korok na’atube Peter, John hairi Tafaror Bar gagaminamaim yoyobanamih hiyen hin. ");
INSERT INTO aai_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nati Tafaror Bar gagamin ana seboseb Etawan Gewagewasin awanamaim orot an kafikafirin auman tutufuw, i mar etei te’abar tena nati’imaim teyare sabuw tirun titit isah ema efefeyan. ");
INSERT INTO aai_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter, John hairi hina hirur itih, isah kabayamih fefeyan. ");
INSERT INTO aai_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter John hairi mutufor isan hinuw naatu Peter eo, “Aki kui’iti!” ");
INSERT INTO aai_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Basit orot isah nuw, notanot boro hairi biyahimaim abisa ta tab. ");
INSERT INTO aai_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Baise Peter isan eo, “Ayu auru kabay en, baise abistan abai anan i boro anit. Jesu Keriso Nazareth mowan i wabinamaim, abiyuni kumisir kubat kuremor!” ");
INSERT INTO aai_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Naatu ofere uman ana asukwafune bai ibais misir an yan bat. Mar ta’imon orot an fuk sun higewasih, ");
INSERT INTO aai_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","fasi iwa’an misir an yan bat remor. Imaibo bairi etawan awan hirun kunununuw God ana merar yi wabin bora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sabuw rou’ay gagamin hima’am kawasa kununuw God bobora’ah hi’itin, ");
INSERT INTO aai_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Naatu hi’i’inan i fefeyanayan Etawan Gewagewasin awanamaim ma’ama, naatu biyanamaim abisa matar hi’i’itin isan hi’oror sa’irih naatu hai kasiy ra’at. ");
INSERT INTO aai_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Orot na Peter, John hairi biyahimaim bukikinih batabat sabuw hi’i’itin ana veya hifofofor erekasiy auman hinunuw hin biyah hitit, efan wabin Solomon ana seboseb efanamaim. ");
INSERT INTO aai_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter bat sabuw itih in sawar naatu iuwih eo, “Israel sabuw, aisim iti sawar mamatar isan kwabifofofor? Naatu aisim aki kwa’i’iti kikini? Kwanotanot iti i aki ai fairamaim, ai aki ai kakafiyinamaim iti orot ai yawas bat ereremor? ");
INSERT INTO aai_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iti i Abraham, Isaac naatu Jacob hai God, naatu it ata’a’agir auman hai God, ana omatanen i iti ana’akir orot Jesu kakafiyin isan eo, baise kwa kwabai a orot ukwarih umahimaim kwayai hi’asabun, naatu Pilate botaitinamih eo ana veya Pilate nanamaim kwakwahir. ");
INSERT INTO aai_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kwa Orot Kakafiyin naatu ana Yawas Mutufurin kwakwahir, efanin Pilate kwaifefeyan sabuw asbunuwenayan i botait. ");
INSERT INTO aai_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kwa ayawas ana bonawiyenayan orot kwa’asabun. Baise God morobone bora’ah misir maiye naatu aki i iti yawas ana kourerebayah. ");
INSERT INTO aai_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aki abitumatum Jesu wabinamaim iti orot iyawas fair bai. Iti i Jesu wabinamaim naatu baitumatum i wanawananamaim na, iti orot biyan tutufin etei iyawas boun iti kwa’i’itin naatu kwaso’so’ob. ");
INSERT INTO aai_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Taitu tuwai’inah Jew, ayu bounabo aso’ob kwa a ukwarih bairi a kasiyomaim Jesu isan iti na’atube kwasinaf. ");
INSERT INTO aai_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Baise God marasika ana dinab orot biyahimaim itenaya, ana Roubininenayan orot boro ni’akir naatu ana tur nati i boun na iturobe. ");
INSERT INTO aai_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Imih dogor kwanikitabir naatu God isan kwanatatabir maiye, saise i boro a kakafih nakusouwen. ");
INSERT INTO aai_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nati namamatar ana veya, imaibo ayub ana fair bain baiboubun isan boro Regah wanawananamaim nan biya natit. Jesu, i ana Roubinineyan orot marasika kwa isa rurubin boro niyafar. ");
INSERT INTO aai_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","I boro maramaim nama nanan God ana veya ya’iyai nan natit, sawar etei nasinaf hinan hiniboubuh maiye, marasika ana dinab orot kakafiyih biyahimaim kukurereb na’atube. ");
INSERT INTO aai_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses eo, ‘Regah a God boro kwa wanawanamaim a orot ta narubin dinab orot namatar ayu rurubinu na’atube, imih tain kwanarub sawar etei sinafumih nao kwananowar. ");
INSERT INTO aai_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Orot yait nati dinab orot fanan men nabobosiyasiyar i boro God ana sabuw biyahine hina’afuru’um natit anababatun.’ ");
INSERT INTO aai_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Dinab oro’orot etei tur hibai, Samuel ma’am ana veya’amaim dinab orot afa i ufununamaim auman iti veya boun boro abistan namamatar isan i hi’orerebaka. ");
INSERT INTO aai_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God ana’omatanen dinab biyahine nan i kwa isa, naatu obaibasit iti boun kwafafaram God bai uwatanah bairi hibasit ana veya, Abraham isan iti na’atube eo, ‘O wawaw wanawanahimaim sabuw tafaram wanawanan tutufin etei boro baigegewasin hinab.’ ");
INSERT INTO aai_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Imih God ana bai’akirayan orot rubin iyafar kwa isa wan na, anayabin God ana kok i kwa baigegewasin tit naatu kwa ta’ita’imon a ef kakafihine kwama’am kwatamatabir maiye isan.” ");
INSERT INTO aai_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Firis afa naatu Tafaror Bar gagamin kaifenayah hai ukwarih, Sadducee bairi hiyen hina Peter, John hairi hibat sabuw hai tur hi’owen biyah hitit. ");
INSERT INTO aai_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ya so’ar yen bufutih, anayabin Peter John hairi sabuw hi’obaiyih hio, “Sabuw karam boro morobone hinamisir maiye, Jesu morobone mimisir maiye na’atube.” ");
INSERT INTO aai_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Peter, John hairi hibuwih hifatumih hin dibur bar hiyariyih imaim hi’in, anayabin veya re mar fo. ");
INSERT INTO aai_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Baise sabuw iyab nati rou’ay gagamin wanawanan hima binan hinonowar, hitumatum naatu orot nati kou’ay wanawanan hibiyab yena 5,000 bai. ");
INSERT INTO aai_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Marto marauman sabuw hai bonawiyenayah, ai’in naatu Ofafar bai’obaiyenayah etei Jerusalemamaim kou’ay hibai. ");
INSERT INTO aai_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas Firis Gagamin na nati’imaim, Kaiafas hairi, John, Alexander naatu orot afa iyab Firis Gagamin ana nibur wanawananamaim hima’am auman hina. ");
INSERT INTO aai_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peter John hairi hibuwih hina nahimaim hibat naatu hibusuruf hibabatiyih hio, “Kwa mi’itube kwasinaf orot igewasin? Naatu fair menane kwabai iti kwasinaf? O yait wabinamaim kwasinaf?” ");
INSERT INTO aai_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Imaibo Peter Anun Kakafiyin iwanasum batabat iyafutih eo, “Sabuw bonawiyenayah naatu regaregah ai’in. ");
INSERT INTO aai_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Aki kwa’afi orot an kafikafirin biyanamaim sawar gewasin iti matar kwa’i’itin isan naatu mi’itube bigewasin isan kwabibatiyi, ");
INSERT INTO aai_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","i boro iti na’atube atao, kwa naatu sabuw tutufin etei Israel wanawanan kwama’am kwataso’ob, orot boun iti namaim biyan tutufin etei igewasin ebatabat, i Jesu Keriso Nazareth mowan kwabai onaf afe’en kwa’asabun naatu morobone God bora’ah maiye mimisir i wabinamaim iti orot yawas. ");
INSERT INTO aai_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iti orot isan Bukamaim hikirum hio, ‘Iti kabay kwa wowabayah kakafin kwarouw kwarurutawiy i boun na bar ana bubu matar.’ ");
INSERT INTO aai_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yawas boro men yait ta biyanamaim tanatita’ur, anayabin tafaram tutufin wanawanan men yait ta wabin nati na’atube ema’ama boro imaim niyawasitamih.” ");
INSERT INTO aai_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naatu Peter John hairi hibitafofor hi’itin ana veya hi’inanih iti orot i kirumatih, orot maiyow bar ma’anih, naatu hifofofor men kafaita, imaibo hi’inanih hiso’ob iti orot i Jesu bairi hima hireremor. ");
INSERT INTO aai_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Naatu iban maiye orot hibiyawas i bairi hibatabat hi’i’itin hai tur etei sawar. ");
INSERT INTO aai_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Imih hi’uwih Kaniser hai efan hihamiy ufun hitit naatu i taiyuwih hibabatiyih ef hinuwet hio. ");
INSERT INTO aai_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Abisa boro tanasinaf iti orot isah? Sabuw etei Jerusalem wanawananamaim tama’am hiso’ob iti sawar gagamin ta hisinaf, naatu it boro men karam tanibun wa’irimih. ");
INSERT INTO aai_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Baise iti sawar tasasar tit sabuw wanawanah run isan, it boro tana’otanih naatu tanimatnuwih iti orot wabinamaim men sabuw hini’obaiyihimih.” ");
INSERT INTO aai_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Imaibo hi’af maiye hirun naatu hiofafarih Jesu wabinamaim men hinabinan naatu men yait ta hini’obaiy maiye’emih. ");
INSERT INTO aai_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Baise Peter, John hairi hi’awar foten hio, “Kwa taiyuw kwafufun kwa’itin, God nanamaim kwa fana anabaib i gewasin o God fanan anabaib i gewasin? ");
INSERT INTO aai_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aki taiyuwi abistan a’itin naatu anonowar iti tur boro men anihamiy.” ");
INSERT INTO aai_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Obiruwen tur afa hio ufunamaim hibotaitih hin, baikwatutunen ana ef men ta ma’am boro hititih, anayabin sabuw etei’imak abisa mamatar isan God hibobora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Naatu orot nati yayawas ana kwamur i 40 tafanamaim. ");
INSERT INTO aai_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hibobotaitih ufunamaim Peter, John hairi hin hai sabuw biyah firis ukwarih naatu regaregah ai’in mi’itube hi’u’uwih etei hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iti hinonowar etei’imak auta’imon yoyobanamaim fanah hibora’ah God isan hio, “Regah fair matuwanin, mar, tafaram naatu riy baimatarenayan, naatu wanawanahimaim sawar etei auman ana baimatarenayan. ");
INSERT INTO aai_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Anun kakafiyinamaim a’akir orot, aki uwai David awanamaim eore eo, ‘Eteni Sabuw aisim hitara’at naatu sabuw aisim hai yakitifuwen yabin men temamatar? ");
INSERT INTO aai_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tafaram ana aiwob baiyow isan teyayabuna, naatu bonawiyenayah etei hiku’ay Regah tibigigim naatu ana Roubininayan tibigigim.’ ");
INSERT INTO aai_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Turobe Herod, Pontius Pilate hairi Ufun Sabuw naatu Israel sabuw bairi iti bar merar gagaminamaim hibobaita’ay o a Roubininenayan orot wabin Jesu, o a’akir wairafin kakafiyin isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iti sabuw i marasika o a kok abisa mataramih a fairamaim iyayakitifuw i nonowatin hisinaf emamatar. ");
INSERT INTO aai_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naatu boun Regah, aki teo’obiruwi kunowar, aki o a’akir wairafi kwibaisi fair kwiti, saise ana batkikin a tur anabinan. ");
INSERT INTO aai_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uma kuru’atayan o a’akir kakafiyin Jesu wabinamaim yawas kwiyafar etit naatu ina’inanen fokarih, baifofofor, kusinaf.” ");
INSERT INTO aai_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yoyoban hibisawar ufunamaim, efan nati hima’ama’amaim busuruf ibiguw, naatu Anun Kakafiyin iwanih hitafofor hitit hibusuruf God ana tur hibinan. ");
INSERT INTO aai_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Baitumatumayah hai not naatu dogoroh etei na ta’imon matar. Men yait ta ana sawar akisin nowan rouwamih, baise hai sawar etei hifafarambonen. ");
INSERT INTO aai_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tur Abarayah fair gagamin maiyow iwanih hibat Regah Jesu ana misir maiye hiorerereb, naatu manaw kabeber Godane gagamin maiyow tafahimaim isuwai ra’iy. ");
INSERT INTO aai_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Naatu nati kou’ay wanawananamaim men yait ta sawar isan biyababanamih, anayabin sabuw iyab isah me hima’am naatu bar hima’am i hiyateten hitobon kabay hibow hina, ");
INSERT INTO aai_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tur abarayah nahimaim hiyaraiyen naatu i hibow sabuw hai yababan ana fofoninamaim hifafaramih. ");
INSERT INTO aai_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iti na’atube mamatar ana veya baitumatumayan orot ta wabin Joseph Levite ana bowabow orot ta, Cyprus imaim tufuw, naatu tur abarayah wabin ta Barnabas hiwab (anayabin Koufair Ana Orot). ");
INSERT INTO aai_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ana me ya’atait hitubun naatu kabay bai na tur abarayah itih. ");
INSERT INTO aai_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Orot wabin Ananias aawan Sapphira hairi auman hai sawar turin hiya’aitit sabuw hitubun. ");
INSERT INTO aai_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Naatu kabay turin i botan, aawan i so’ob, naatu i ana baibasit auman iwa’an, turinawat bai in tur abarayah nahimaim ihouw ra’iy. ");
INSERT INTO aai_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter Ananias isan eo, “Aisim Satan not kakafin dogor wanawanan yaru’uy Anun Kakafiyin matanamaim ifuwen, a me hitutubun kabay turin o isa ibotan? ");
INSERT INTO aai_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Inaso’ob iti me i o nowa, baise o a baibasitamaim sabuw hitubun, naatu sabuw hitutubun ufunamaim iti kabay i o nowa. Aisim iti na’atube isinaf? O men orot ifuw, baise God ifuw.” ");
INSERT INTO aai_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias tur iti nonowar ana maramaim an uy re morob, sabuw etei’imak tur iti hinonowar hai hibir ra’at. ");
INSERT INTO aai_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Oro’orot boubuh hina hirun biyan hibai hisum hibai hin rahemaim hiyai. ");
INSERT INTO aai_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Three hours na’atube sasawar ufunamaim aawan babin na tit, i men so’ob Ananias isan abisa mamatar. ");
INSERT INTO aai_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter babin ibatiy, “Ku’o gewas anowar, aaw airi a me hitutubun baiyanaban ana fofonin iti kwabai?” Babin iya’afut eo, “Me hitutubun ana baiyan etei i nati.” ");
INSERT INTO aai_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter babin isan eo, “Aisim aaw airi kwaibasit, Regah Anunin kwarutubun? Oro’orot iyab o aaw hibai hin hiya’iy i nati etawanamaim tebatabat o hina’abar kwananamih.” ");
INSERT INTO aai_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mar ta’imon babin Peter anamaim ra’iy rab morob, oro’orot boubuh hina hirur babin morob inu’in hi’itin hi’abar hin aawan sisibinamaim hiyai. ");
INSERT INTO aai_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sawar iti mamatar ekaleisia sabuw naatu sabuw afa auman iti tur hinonowar hi’oror sa’irih naatu hai hibir ra’at. ");
INSERT INTO aai_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tur Abarayah ina’inan naatu baifofofor moumurih maiyow sabuw wanawanahimaim hisisinaf. Naatu baitumatumayah hai rou’ay mar etei i Solomon ana sebosebomaim hiruru’ay. ");
INSERT INTO aai_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Orot babin ufunane men karam boro hitakofanih, basit baitumatumayah hai gewasih isan sabuw wabih hibobora’ara’ah. ");
INSERT INTO aai_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Naatu orot babin iyab Regah hibitumatum hina hirun kou’ay yayababar yen ra’at. ");
INSERT INTO aai_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Rou’obow nati’imaim sabuw sawusawuwih hi’abaren hitit ef gagamih yah emo’em afe’eh naatu ir yah hi’i’inuwih, saise Peter tanan ana youn afa tafahimaim tarabon isan. ");
INSERT INTO aai_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sabuw rou’ay gagamin maiyow hiru’ay, naatu bar merar afa Jerusalem sisibinamaim hima’am hai sabuw sawusawuwih naatu afa afiy kakafih hitoun buriburih hima’am hibuwih hinan etei’imak hiyayawasih. ");
INSERT INTO aai_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Firis Gagamin ana ofonah etei naatu Sadducee hai kou’ay bairi hibusuruf tur abarayah isah yah so’ar hibobowen, naatu sinafumaim hiyai. ");
INSERT INTO aai_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tur Abarayah hibow hifatumih naatu hibuwih hin dibur bar gagaminamaim hiyariyih. ");
INSERT INTO aai_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Baise gugumin wanawanan Regah ana tounamatar na etawan etei botawiyen tur abarayah iunawiyih hitit, iuwih eo, ");
INSERT INTO aai_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kwanan Tafaror Bar gagamin wanawanan kwanabat iti yawas boubun ana tur tutufin sabuw etei hai tur kwana’owen.” ");
INSERT INTO aai_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mar sibisib auman tur abarayah Tafaror Bar wanawanan was efanamaim hibusuruf sabuw hi’obaibiyih. Firis Gagamin ana ofonah bairi hina hirun naatu Kaniser ana kou’ay tutufin etei hi’af ayuwih, Jew hai regaregah ai’in etei auman hina kou’ay wanawanan hirun, imaibo diburane tur abarayah buwih na isan tur hiyafar. ");
INSERT INTO aai_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Baise hina dibur baremaim hititit hibouyuwih naatu ma’utenayah hai ukwarih himatabir maiye hina hai tur hio’wen hio, ");
INSERT INTO aai_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Aki an dibur bar atitit etawan etei i tufatufbonen naatu etawan ma’utenayah auman hibatabat ai’itih, baise etawan abobotawiyen i men yait ta nati bar wanawananamaim atita’urimih.” ");
INSERT INTO aai_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Firis ukwarih naatu Tafaror Bar kaifenayan hai ukwarin iti tur hinonowar etei hai kasiy ra’at hio, “Iti orot isah abisa matar?” ");
INSERT INTO aai_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Rubira’e orot ta na run eo, “Kwananowar oro’orot kwabow dibur kwaya’aya i Tafaror Bar wanawanan sabuw tibi’obaibiyih.” ");
INSERT INTO aai_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Naatu kaifenayan ukwarin ana orot afa bairi hin tur abarayah hibuwih bairi himatabir maiye, men hifair o hikwararihimih, anayabin sabuw agimamaim borabirabih hirouw hibir. ");
INSERT INTO aai_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tur Abarayah hibuwih hina hirun Kaniser (Sanhedrin) nahimaim hibat naatu Firis Gagamin ibatiyih eo, ");
INSERT INTO aai_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Aki tur fokarin maiyow ao fafari iti orot wabinamaim sabuw men kwani’obaiyih, naatu baise kwa abai’obaiyen i tit Jerusalem wanawanan sabuw etei tenonowar, naatu kwakok iti orot momorob ana ubar aki bain isan kwayayamatat.” ");
INSERT INTO aai_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter naatu tur abarayah afa bairi hiyafutih hio, “Aki i God fanan anab men orot fanahimih. ");
INSERT INTO aai_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","It ata a’agir hai God Jesu kwa onaf tafanamaim kwa’onaf kwa’asabun momorob i morobone God bora’ah maiye, ");
INSERT INTO aai_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God bora’ah yen uman ana asukwafune ima’an, bonawiyenayan naatu baiyawasayan matar, saise Israel sabuw hai ef nabotawiy dogor baikitabiren naatu notawiyen hinab. ");
INSERT INTO aai_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aki i iti sawar hai sifrubonayah, naatu sabuw iyab hibifanabow isan God Anun Kakafiyin bitih auman siftirurubon.” ");
INSERT INTO aai_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaniser sabuw iti tur hinonowar ana veya, gagamat yen bufutih hikokok kwanekwan i boro tur abarayah hita’asbunih. ");
INSERT INTO aai_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Baise Pharisee orot wabin Gamaliel, ofafar bai’obaiyenayan, sabuw etei iti orot hikakakafiy, kou’ay wanawanan misir iuwih tur abarayah hibuwih hitit ufunamaim mar kafai hibat. ");
INSERT INTO aai_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Naatu imaibo Kaniser iuwih eo, “Taituwau Israel, abisa iti orot isah kwayayakitifuw mata toniwa’an gewas kwananotabo kwanasinaf. ");
INSERT INTO aai_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kwananot iti boro’omo Theudas tit orot gagamin ta rouw eorereb naatu oro’orot etei 400 na’atube hikofan, Baise hi’a’asabun ana veya ana bai’ufununayah etei hitaragiy nanabin hin, naatu ana kou’ay re rumoromorob sawar. ");
INSERT INTO aai_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nati ufunamaim Judas Galilee orot sabuw hibiyab ana veya tit, sabuw bow kou’ay busuruf, baise i auman hi’asabun naatu ana bai’ufununayah hitaragiy nanabin hin. ");
INSERT INTO aai_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Isan imih abisa iti boun emamatar isan au’uwi, iti orot kwaihamiyih, naatu kwa’uwih ten, anayabin orot ana notane hinayakitifuw hinasisinaf na’at boro nasawar. ");
INSERT INTO aai_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Baise Godane nanan na’at, kwa men karam boro kwana’otanih, kwa boro taiyuw God bairi kwanabiyow kwana’itin.” Iti na’atube eo dogoroh ikitabir. ");
INSERT INTO aai_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tur Abarayah hi’afih hirun naatu hirouw. Imaibo tur fokarin maiyow hi’uwih naatu hiofafarih Jesu wabin men hinao rerereb, naatu hi’uwih hai au ubar hin. ");
INSERT INTO aai_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tur Abarayah Kaniser hihamiyih hitit naatu ereyasisir auman hin, anayabin Jesu wabinamaim hibi’akir i igewasin kwanekwan. ");
INSERT INTO aai_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mar etei Tafaror Baremaim naatu hai baremaim sabuw hibi’obaiyih naatu tur gewasin Jesu Keriso isan sabuw hai tur hi’o’owen. ");
INSERT INTO aai_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nati ana veya’amaim bai’ufununayah hai kou’ay busuruf ra’at. Naatu Jew sabuw iyab Greek tur hio yah so’ar himisir Jew sabuw iyab Hebrew tur hio higam hi’uwih. Anayabin veya ta’ita’imon hai faramamaim kwafukwafur baibin i hikukusairih. ");
INSERT INTO aai_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Imih tur abarayah nah 12 hi’af bai’ufununayah sabuw etei’imak hiru’ay naatu hi’uwih hio, “Aki God ana tur anihamiy sabuw ana bituw ana itinin aki isai men igewasin. ");
INSERT INTO aai_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isan imih taitu, wanawanamaim orot nah seven iyab kwa’i’itih i God Anunin iwansumih tema’am naatu not wairafih i kwanarubinih, saise aki iti bowabow i anitih sabuw hinakaifih. ");
INSERT INTO aai_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naatu aki baise ai veya tutufin etei yoyoban anitin naatu tur ana binan.” ");
INSERT INTO aai_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tur Abarayah iti not hibai hititit isan kou’ay tutufin etei hiyasisir naatu Stephen hirubin, orot baitumatumayan naatu Anun Kakafiyin ana way, Philip, Prokorus, Nicanor, Timon, Parmenas auman hirubinih, naatu Nicolaus Antioch orot marasika dogoron hikitabir Jew hai kwafirenamaim run ma’am auman hirubin. ");
INSERT INTO aai_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Orot nah seven hibow hina tur abarayah nahimaim hitit isah hiyoyoban sawar naatu umah ta’ita’imon tafahimaim hiyara’aten. ");
INSERT INTO aai_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naatu God ana tur tuw ra’at. Jerusalem wanawanan sabuw moumurih na’in hitumatum naatu bai’ufununayah hai kou’ay wanawanan hirun kou’ay ra’at, naatu firis oro’orot auman baitumatum hibai. ");
INSERT INTO aai_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen God ana baigegewasin naatu ana fair gagamin maiyow itin, ina’inanen gagamih fokarih sabuw wanawanahimaim ma sinaf. ");
INSERT INTO aai_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Baise orot iyab Roufamen ana Kou’ay barane himisir Stephen bairi higam. (Roufamen Kou’ay bar i wabih). Nati i Jew sabuw Sairini’ine naatu Alexandria’ane hinan, na’atube Jew afa Silisia naatu Asia wanawanahine hina. ");
INSERT INTO aai_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Baise God Anunin Stephen baibais itin ukwarin rerekab tur eo i men karam boro fanan hitiya’afut. ");
INSERT INTO aai_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sabuw afa wa’iwa’iramaim hitubunih naatu awah hiore hitit hio, “Stephen, Moses isan naatu God isan baigigimen tur eo aki anonowar!” ");
INSERT INTO aai_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iti na’atube hio, sabuw, regaregah ai’in, naatu Ofafar bai’obaiyenayah yah hiora’ah, Stephen hibai hifatum hibai hina Kaniser nahimaim hitit. ");
INSERT INTO aai_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sabuw afa baifufuwenayah hibow hina Stephen isan hifufuwen hio, “Iti orot i mar etei ata Bar Kakafiyin isan naatu Moses ana ofafar isan eo ibigigim.” ");
INSERT INTO aai_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naatu iban maiye iti na’atube eo aki anowar, “Jesu Nazareth mowan i boro iti bar kakafiyin nagurus nare naatu ata binanakwar Moses ya’abun rena tabaib boro nab nabotabir!” ");
INSERT INTO aai_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iyabowat nati Kaniser ana kou’ay wanawanan hima Stephen hi’itin kweyakweyar, yumatan botabir tounamatar ana yumatabe matar hi’itin. ");
INSERT INTO aai_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Imaibo Firis Gagamin Stephen ibatiy, “Tur iti i anababatun o isa teo?” ");
INSERT INTO aai_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen iya’afut eo, “Taitu tuwai’inah naatu tamai’inah anao kwananowar! Ata agir Abraham ufibo na Haram imaim ma, baise wan Mesopotamia ma’am ana veya’amaim Marakaw ana God isan irerereb eo. ");
INSERT INTO aai_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘A tafaram naatu taituwa inihamiyih inan tafaram ayu ana bi’obaiyi imaim inama.’ ");
INSERT INTO aai_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Imih Kaldia tafaram ihamiy naatu na Haram imaim ma. Tamah momorob ufunamaim God nawiy na me tafaram iti bitin boun kwa iti kwama’am. ");
INSERT INTO aai_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God men abisa ta Abraham nowanamih itin naatu men kafa’imo me kikimin eafuw nowanamih itin. Baise God eomatan tafaram tutufin etei boro nowanamih nab naatu wawawan uf hinatutufuw boro hinab. Nati ana veya’amaim Abraham i aurin kek en ma’am God eomatan. ");
INSERT INTO aai_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naatu God iti na’atube eo, ‘O wawaw i boro nah toumanih hai tafaramamaim hinama, nati’imaim boro nah toumanih hai fair babanamaim hinama bowabow fokarin maiyow hinabow, hinarouw hini’a’afiyih kwamur etei 400 na’atube nasawar.’ ");
INSERT INTO aai_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Baise God iuwih eo, ‘Ayu nati tafaram hinabuwi babahimaim kwanama kwanabowabow boro baimakiy anitih. Nati ufunamaim boro tafaram kwanihamiy kwanatit efan iti’imaim ayu kwanakwafiru. ");
INSERT INTO aai_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Imaibo God ar afu’afuw ana obaibasit Abraham itin ina’inanen na’atube kaif. Imih Abraham natun Isaac tufuw fur ta’imon sasawar ufunamaim ana ar kanabin e’afuw. Nati ufunamaim Isaac natun Jacob ana ar kanabin e’afuw naatu Jacob natunatun 12 it uwatanah wabih gagamin auman hai ar kanabih e’afuw. ");
INSERT INTO aai_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Baise uwatanah wabih gagamin Joseph isan hibobowen akir wairafin na’atube hitih hitubun hibai hin Egypt imaim ma. Baise God i mar etei biyanamaim ma’am. ");
INSERT INTO aai_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Naatu ana yababan ta ta wanawanamaim bibais. Veya ta Joseph Egypt hai aiwob nanamaim titit ana veya aiwob orot Joseph i’itin yan bai naatu ana kakaf isan ma, anayabin God ukwar rerekab Joseph itin. Imih aiwob orot Joseph bai ana gawanamih yai, naatu aiwob ana bar gagamin wanawanan auman kaifin isan ana fair itin.” ");
INSERT INTO aai_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Nati ana veya’amaim baimar kakafin na, Egypt naatu Canaan tafaram wanawanan yababan gagamin na’in matar, naatu it uwatanah bayumih hi’akir. ");
INSERT INTO aai_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egyptamaim bay ma’am ana tur Jacob nonowar ana veya uwatanah hai nanawan wantoro’ot imaim hin. ");
INSERT INTO aai_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hai nanawan bairou’abin ana veya Joseph taiyuwin botait irerereb tuwahinah hai tur eowen, naatu Pharaoh nati’imaim Joseph ana nibur isah so’ob. ");
INSERT INTO aai_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nati ufunamaim Joseph tamah Jacob isan, naatu tamah ana nibur isah tur iyafar, nah etei 75 na’atube. ");
INSERT INTO aai_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Imaibo Jacob rena Egypt tit, nati’imaim i natunatun bairi himorob, it uwatanah. ");
INSERT INTO aai_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Naatu biyah i hibow himatabir maiye tafaram wabin Shekem rahamaim hiya, nati me i Abraham orot Hamor natunatun biyahine tubun. ");
INSERT INTO aai_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“God ana omatanen Abraham eo’omatan na baiturobe isan ana veya na kabom, naatu ata sabuw Egypt hima’am busuruf ra’at tafaram awan karatan. ");
INSERT INTO aai_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Imaibo aiwob orot ta Joseph men susu’ub i busuruf Egypt isan i’aiwob. ");
INSERT INTO aai_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ata a’agir ifufuwih, biyababan kakafin anababatun itih, eokikinih hai kek sosof hisrouwen hi’in himorob. ");
INSERT INTO aai_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Nati ana veya’amaim Moses tufuw, kek ana itinin gewasin maiyow. Baremaim hinah tamah hibunwa’ir ma sumar etei tounu na’atube sawar. ");
INSERT INTO aai_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Imaibo barene hibotait titit ana veya, Pharaoh natun babitai natunamih bai ituw ra’at yen orot matar. ");
INSERT INTO aai_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt ana ukwar rerekab etei Moses hi’obaiy so’ob, naatu ana tur ana sinafumaim eo sisinaf etei i fairih. ");
INSERT INTO aai_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses ana kwamur etei 40 na’atube baib ana maramaim ana not bogaigiwas tit ana sabuw Israel inananawanih. ");
INSERT INTO aai_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tit inan Egypt orot ta Israel orot boborabirab itin, basit na ibais wasfafar naatu anasa bow Egypt orot rab morob. ");
INSERT INTO aai_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses not eo, ‘God ana baibais ayu wanawana’umaim esisinaf au sabuw boro hina’itin hinaso’ob, baise men hi’itinimih.’ ");
INSERT INTO aai_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Marto Israel orot rou’ab hairi hibiyow itih, basit na fafar naatu iuwih, ‘Kwa airi i ain uf, aisim taiyuw kwabiyow?’ ");
INSERT INTO aai_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Baise orot ta biwa’an kakafene Moses rukouw eo, ‘O aki bainabatani naatu baibabatiyi isan yait rubini?’ ");
INSERT INTO aai_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘O kukokok ayu ina’asbunu fai Egypt orot ia’asabun na’atube?’ ");
INSERT INTO aai_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses iti tur nonowar ana veya Egypt ihamiy bihir in tafaram wabin Midian imaim ma, nati’imaim touman orot na’atube ma’am natunatun orot rou’ab hitufuw. ");
INSERT INTO aai_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kwamur 40 sasawar ufunamaim oyaw Sinai sisibinamaim arar yan tounamatar Moses isan irerereb wairaf na’atube wa’ab wanawanan to’ab. ");
INSERT INTO aai_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses iti wairaf to’ab i’itin ana veya ana kasiy ra’at, naatu itinbunai isan na biyubin auman Regah fanan nowar; ");
INSERT INTO aai_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ayu i o uwatanah hai God, Abraham ana God, Isaac, naatu Jacob.’ Moses yan wanawanan birubir fafar an uman hioror naatu men karam boro tanuw ta’itin. ");
INSERT INTO aai_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Imaibo Regah eo, ‘A ana sumasum kubosair anayabin iti kamar i kakafiyin yan kubatabat. ");
INSERT INTO aai_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ayu au sabuw Egypt imaim bai’akir kakafin maiyow hibaib aitih, naatu hitef hirererey anowar, imih rufamih botaitih isan are ana. O kuna aiyafari kumatabir maiye au Egypt.’ ");
INSERT INTO aai_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses i orot ta’imon Israel sabuw hikwahir hiu, ‘O yait rubini aki bainabatani naatu baibatiyi isan?’ Nati orot ta’imon sabuw bainabatanih naatu rufamih botaitih isan God taiyuwin ana tounamatar iyafar na wa’ab toto’abamaim irerereb Moses fair itin. ");
INSERT INTO aai_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sabuw nawiyih Egypt hihamiy hitit, naatu ina’inan men hi’i’itah efa’efanin Egyptamaim, Red Sea imaim, naatu kwamur 40 arar yanamaim iwa’an hi’itah. ");
INSERT INTO aai_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Iti orot Moses i boun Israel sabuw hai tur eowen, ‘God boro dinab orot kwa wanawananamaim a orot ta niyafar nan, ayu biyafaru na’atube.’ ");
INSERT INTO aai_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iti orot Moses Israel sabuw bairi kou’ay hibai arar yanamaim hibat naatu ata a’agir bairi Sinai oyawemaim tounamatar tur yawasin bai re itin naatu ya’abun it isat rena. ");
INSERT INTO aai_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Baise it ata a’agir fanan men hibosiyasiyar, naatu fanan hikwahir hikokok i mi’itube hitamatabir maiye hitan Egypt hitatit. ");
INSERT INTO aai_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Imih Aaron hiu, ‘Aki akokok god ta kusinaf au nai i’iyon ebonawiyi. Moses Egyptane nawiyi atitit men aso’ob abisa isan matar.’ ");
INSERT INTO aai_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nati ana veya’amaim aibat ta cow natun ana yumatabe hibu’ur. Naatu sibor hibow hina sawar i umahimaim hisinaf mamatar ana sibor hiyai naatu ana hiyuw hibow hiyasisir. ");
INSERT INTO aai_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Baise God mafutih, naatu mar ana sawar kwafirih isan ibasit. Dinab orot hai Bukamaim hikikirum na iturobe, ‘Kwa iti bobaituw kwarouw sibor kwaya’ayaban ayu isou? kwamur 40 arar yan kwama’am ana veya Israel sabuw, ");
INSERT INTO aai_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kwa i god Moloch ana sis kwa’abar kwareremor, naatu daman Rephan ayubin ana god umamaim aibat kwatar kwakwakwafir. Isan imih ayu boro aniyafari kwanan Babilon ufunane kwanama.’ ");
INSERT INTO aai_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ata a’agir God ana sis arar yanamaim hiyai hima’am i God ana itinin nati’imaim bairi hima’am. Nati sis i God mi’itube Moses iu bi’obaiy na’atube naatu God yayakitifuw na’atube hiwowab. ");
INSERT INTO aai_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nati ufunamaim, ata a’agir sis tamahinah biyahine nan hibai hi’abar Joshua babanamaim bonawiyih bairi hirun sabuw afa hai tafaram God nunih hititit i hai tafaram hibai. Naatu nati sis i ma’am David ana veya’amaim tit. ");
INSERT INTO aai_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David ana baibais gagamin na’in God biyanane bai, imih ifefeyan bar tawowab. Jacob ana God isan ");
INSERT INTO aai_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","baise iti bar i Solomon wowab. ");
INSERT INTO aai_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Baise Auyomtoro’ot ana God i men orot bar tewowowabimaim ema’ama’amih, dinab orot eo kikirum na’atube. ");
INSERT INTO aai_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mar i ayu au urama’ama, naatu kamar i ayu au ana baibiyarir. Regah eo, Abi bar boro ayu isou kwanawowab? Efan i boro menamaim aniyarir? ");
INSERT INTO aai_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sawar iti kwanotanot men ayu asinaf himatar?’ ");
INSERT INTO aai_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kwa i dogor fokarih naatu dogor wanawanan gugumin naatu tain gugurih God ana tur men kwanonowar! Kwa i a’a’agir ah kwabat, mar etei Anun Kakafiyin kwarurukouw! ");
INSERT INTO aai_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kwa a’agir dinab orot marasika hima’am etei hirouw hi’a’akirih, nati dinab oro’orot i marasika iti orot gewasin nan isan hikurereb. Baise kwa uwatanah hirouw himorob, naatu boun kwa iti orot gewasin nan baban kwao kwarab morob. ");
INSERT INTO aai_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kwa i God ana ofafar tounamatar hiyafar re’er kwabai, baise men kwabobosiyasiyar!” ");
INSERT INTO aai_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaniser hima Stephen eo hinonowar yah so’ar gagamat bufutih hikarmusiyan himisir ");
INSERT INTO aai_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Baise Stephen God Anun Kakafiyin biyan etei karatan batabat au mar nuwra’at God ana marakaw itin naatu Jesu sisibin asukwafune batabat itin. ");
INSERT INTO aai_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Basit eo, “Kwanuw ra’at! Ayu mar ana etawan botawiy Orot Natun God ana asukwafune bat ai’itin!” ");
INSERT INTO aai_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Fanah aumetawat hiwow tainih higibud, imaibo etei au ta’imon hinunuw hibai ");
INSERT INTO aai_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","hitain hitit bar merar gagamin ufunane hitaiy re kabayamaim hirab, orot iyab baifuwenamaim sif hirurubon, hai faifuw nati orot boubun wabin Saul anamaim hiya. ");
INSERT INTO aai_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kabayamaim hibat hirabirab auman Stephen Regah isan ifefeyan eo “Regah Jesu ayubu kubai!” ");
INSERT INTO aai_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sun yowen fanan aumetawat erererey auman i wow eo, “Regah abisa ayu isou tisisinaf hai ");
INSERT INTO aai_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stephen hi’asabun momorob isan Saul auman isaito. Nati ana veya’amaim ekaleisia Jerusalem wanawananamaim isah bai’akir kakafin matar, naatu bai’ufununayah etei nanabin hibihir. Afa au Judea na’at hibihir naatu afa au Samaria na’at hibihir. Baise tur abarayah akisihimo Jerusalem hima. ");
INSERT INTO aai_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kwafirenayah sabuw afa Stephen hiyai naatu isan hiyababan rerey gagamin maiyow hima hirererey. ");
INSERT INTO aai_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Naatu Saul ekaleisia gurusin busuruf bar awan awan run tit orot babin bow rouw fatum iteten in dibur baremaim yaririyen. ");
INSERT INTO aai_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iyab hitagey nanabin hititit i God ana tur hibinan auman hinan. ");
INSERT INTO aai_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip re in Samaria bar merar gagaminamaim Keriso ana tur binan in. ");
INSERT INTO aai_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Philip eo sabuw hinonowar naatu ina’inanen sinaf hi’i’itan etei hina hiyubin ana tur nowar isan. ");
INSERT INTO aai_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sabuw moumurih maiyow wanawanahimaim afiy kakafih tarsumih hima’am erefanah auman hititit, naatu ah umah kafikafirih naatu ah umah murumurubih moumurih maiyow auman iyayawasih ");
INSERT INTO aai_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Imih nati bar meraramaim yasisir gagamin maiyow tafair tit. ");
INSERT INTO aai_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Baise nati bar meraramaim i orot ta wabin Simon ma farum eafusar farum Samaria orot babin bibibiruwih, naatu taiyuwin wabin bora’ara’ah orot gagamin rouw eo. ");
INSERT INTO aai_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Naatu sabuw etei nati bar merar hima’am, orot kikimin yen in orot gagamin etei fanan akisin hinonowar hio, “Iti orot i God ana fair bai, wabin ‘Fair Gagamih.’” ");
INSERT INTO aai_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sabuw etei hibi’ufunun anayabin manin maiyow ana farumamaim bibibiruwih. ");
INSERT INTO aai_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Baise ana maramaim Philip na tur gewasin God ana aiwob isan naatu Jesu Keriso ana fair isan binan hinonowar, orot babin etei hitumatum naatu bapataito hibai. ");
INSERT INTO aai_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon taiyuwin auman itumatum naatu bapataito bai misir Philip mi’itube inan na’atube i’ufunun hairi hin naatu ina’inan gagamih maiyow himamatar i’itah isan ifofofor morob. ");
INSERT INTO aai_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tur Abarayah Jerusalem hima’am Samaria sabuw God ana tur hibasit hibaib tur hinowar, Peter John hairi hiyafarih isah hin. ");
INSERT INTO aai_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hin hititit ana veya isah hiyoyoban, saise Anun Kakafiyin hitab. ");
INSERT INTO aai_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Anayabin Jesu Keriso wabinamaim bapataito hibaib ana veya, Anun Kakafiyin men yait ta tafanamaim yenamih. ");
INSERT INTO aai_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Imaibo Peter John hairi umah tafah hiyara’aten isah hiyoyoban naatu Anun Kakafiyinane hibai. ");
INSERT INTO aai_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sabuw tafah umah hiyara’aten Anun Kakafiyin re hibaib Simon i’itin ana veya, kabay baih tur abarayah itih naatu ");
INSERT INTO aai_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","eo, “Ayu auman akokok nati fair ayu kwanitu, saise sabuw iyabowat tafah ayayara’aten i auman Anun Kakafiyin hinab.” ");
INSERT INTO aai_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Baise Peter iya’afut eo “O akabay airi mi’itube kwatamorob, anayabin o kunotanot God ana siwar i boro kabayamaim inatubun. ");
INSERT INTO aai_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","O a bowabow ta men aki biyai’imaim ema’am, anayabin o dogor God nanamaim i men mutufurinamih. ");
INSERT INTO aai_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Iti not kakafihine dogor kwikitabir naatu Regah isan kuyoyoban ta’itin a not kakafin nati dogoromaim ema’am boro nanotawiy. ");
INSERT INTO aai_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Anayabin ayu ai’iti o dogor wanawanan i bahiy iwansumi mata ebifefek naatu bowabow kakafin ana dibur irun kuma’am.” ");
INSERT INTO aai_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Imaibo Simon iyafutih eo, “Regah isan kwayoyoban wainu, saise sawar iti na’atube men ta isou namataramih.” ");
INSERT INTO aai_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Regah ana yawas hio’orereb naatu ana tur hibibinan ufunamaim, Peter John hairi himatabir maiye au Jerusalem hiyey ana veya, Samaria bar merar ta ta wanawanahimaim tur gewasin hibinan auman hin. ");
INSERT INTO aai_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Imaibo God ana tounamatar Philip iu, “A ef asukwafune inab, arar yan ana ef Jerusalemane re in Gaza titit iwat inab inare inan.” ");
INSERT INTO aai_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Imih Philip misir ef nati butitiy inan founamaim Ethiopia orot gagamin hairi hitar. Iti orot i Ethiopia hai queen ana kabay etei ana nutitiyenayan gagamin, aiwob babin ana aiwob wabin i Kandis. Iti orot gagamin yena Jerusalem God kwafir sawar, ");
INSERT INTO aai_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","me yan ana wa bai ana ubar matabir maiye re’er, ef yanamaim dinab orot Isaiah ana buk rusasar ma iyab auman inan. ");
INSERT INTO aai_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Naatu Anun Kakafiyin Philip iu, “Kwen ni’i wa sisibinamaim kwiyubin.” ");
INSERT INTO aai_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip imaibo nunuw yen na iyubin, tainin i’abar dinab orot Isaiah ana tur biyab nowar, naatu Philip orot ibatiy, “Nati buk kubiyab anayabin iso’ob?” ");
INSERT INTO aai_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Orot iya’afut eo, “Mi’itube boro anaso’ob? Orot ta isou nakubuna boro anaso’ob?” Naatu Philip ifefeyan yen sisibin mare. ");
INSERT INTO aai_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Orot gagamin i buk firorow wanawanan ana hanef iti rusasar ma biyab. ‘Bobaituw sheep na’atube beyahinamih hibai hin, sheep natun lamb na’atube bunibunin hi’a’afuw men fanan sib itkwarakwar. ");
INSERT INTO aai_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Taiyuwin yare, ma gewas ana baitafen tutur isan men hinuwet gewas, aurin kek en morob. Anayabin i ana yawas tafaramamaim i na yomanin tit.’ ");
INSERT INTO aai_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Naatu Ethiopia orot Philip ibatiy, “Ku’o anowar, yait isan iti dinab orot eo? I taiyuwin isan, ai orot babin ta isan?” ");
INSERT INTO aai_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Imaibo Philip Buk ana hanef menamaim busuruf biyab imaim tur gewasin Jesu isan ana tur eowen. ");
INSERT INTO aai_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ef yan hire hinan auman hina harew soson ta’amaim hitit naatu orot gagamin eo, “Harew iti, tare bapataito kwitu.” ");
INSERT INTO aai_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip iya’afut eo, “O karam boro bapataito inab, dogor tutufin etei inabitumatum na’at.” Iya’afut eo, “Ayu abitumatum Jesu Keriso i God Natun. ");
INSERT INTO aai_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Orot gagamin ana wa rowenatan naatu Philip hairi hire hin harew yan hire nati’imaim Philip orot bapataito itin. ");
INSERT INTO aai_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Harewane hiyeye ana maramaim, Regah Anunin Philip bora’ah. Orot gagamin men itin maiye, baise ereyasisir auman ana ef rura’ah maiye remor in. ");
INSERT INTO aai_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nati ana veya’amaim Philip i Azotus imaim rouwatait, naatu in Caesarea tit, efamaim inan bar awan, awan run tit tur gewasin binan auman remor in.” ");
INSERT INTO aai_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Baise Saul i Regah ana bai’ufununayah rouw morob isan menan bi’arakok. Imih na firis ukwarih biyah tit, fef tab auman tan Damaskas wanawanan Kou’ay Bar ta ta hai ukwarih hitaso’ob isan ");
INSERT INTO aai_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ifefeyan, saise sabuw iyab Regah ana efamaim hima’ama orot o babin etei tafatumih tabow tan Jerusalem dibur taya. ");
INSERT INTO aai_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nati isan au Damaskas yen inan, na bar merar biyubin auman naniyan meyemeye marakaw marane namanamarabe bow sisibin roun roun etei e’arasib re, ");
INSERT INTO aai_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","naatu me yan re rab, orot fanan nowar wabin su’ub eo “Saul, Saul aisim ayu irabu kubia’akiru?” ");
INSERT INTO aai_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul ibatiy, “Regah o yait?” Orot fanan tit maiye iya’afut eo, “Ayu i Jesu o irabu kubia’akiru. ");
INSERT INTO aai_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Baise kumisir kwen bar merar gagamin kutit, nati’imaim boro hinao inanowar abisa boro inasinaf.” ");
INSERT INTO aai_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Orot afa Saul bairi hinan hai tur sawar hinutanub hibat orot fanan hinowar, baise men yait ta ana yumat hi’itin. ");
INSERT INTO aai_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul me yan inu’in misir matan nuw, baise matan isukway men abisa ta itin, basit uman hibai hi’unawiy hin Damaskas hitit. ");
INSERT INTO aai_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Veya tounu na’atube matan ifim ma. Nati ana maramaim men kafa’imo bay ta eaan naatu harew tom. ");
INSERT INTO aai_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Baitumatumayan orot ta wabin Ananias Damaskas ma’am matan hibora’ah tainin tayowan Regah isan eafa’af fanan nowar, “Ananias!” Ananias iya’afut eo “Regah ayu iti.” ");
INSERT INTO aai_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Regah eo, “Inabogaigiwas inan ef gagamin wabin mutufor imaim inatit naatu Judas ana baremaim Tarsus orot wabin Saul isan inibatiyih, i ma eyoyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Naatu Saul matan hibora’ah orot ta wabin Ananias itin narun umanamaim matan butubun nuwanuw maiyen itin.” ");
INSERT INTO aai_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias iya’afut eo, “Regah sabuw moumurih na’in nati orot isan hio anowar, sawar kakafih maiyow o a sabuw Jerusalem hima’am isah sinaf. ");
INSERT INTO aai_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naatu boun i firis ukwarih biyahine fair bai na iti Damaskas tit sabuw iyab o tekwakwafiri bow fatumen isan.” ");
INSERT INTO aai_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Baise Regah iu, “O i boro inan anayabin ayu nati orot arubin isou nabowamih, wabu nab natit Ufun Sabuw, aiwob sabuw, naatu Israel sabuw wanawanahimaim nabosemor. ");
INSERT INTO aai_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naatu ayu taiyuwu boro ani’obaiy bai’akir gagamin na’in ayu wabu isan ni’akir.” ");
INSERT INTO aai_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Basit Ananias misir in bar efan Regah eo’omaim tit naatu bar wanawanan run, uman Saul tafanamaim yara’ah eo, “Saul ayu taiu Regah Keriso efamaim o isa birerereb i ayu iyunu anan o mata nigewasin inanuw maiye, naatu Anun Kakafiyin niwani. ");
INSERT INTO aai_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Naniyan meyemeye matan siy kanabinin na’atube ma’am hea’obow re, matan kubunai nuw maiye, naatu misir re bapataito bai. ");
INSERT INTO aai_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bay eaa ufunamaim ana fair matabir maiye bai. Veya bai’ab na’atube Saul bai’ufununayah bairi Damaskas hima. ");
INSERT INTO aai_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saul misir mutufor in Kou’ay Bar run busuruf Jesu isan binan eo, “Jesu i turobe God Natun.” ");
INSERT INTO aai_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sabuw etei hinowar hifofofor naatu hibabatiyih hio, “Orotoban iti Jerusalemamaim sabuw iyab Jesu wabinamaim hikwakwafir rouw himorob? Naatu iti’imaim nan ana’an i nati sawar ta’imon isan na, sabuw fatum bow na firis gagamin baitihimih?” ");
INSERT INTO aai_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Baise Saul binan inan ana fair ra’at, Jew sabuw iyab Damaskas hima’am hai not botabir naatu i’obiyih Jesu i anababatun Keriso, iti na’at eo sabuw tur omih hikasiy. ");
INSERT INTO aai_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fur bai’ab na’atube sasawar ufunamaim Jew sabuw hiru’ay Saul morob isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Baise abisa sinafumih hiyayakitifuw i hio nowar, fai mar i etawan awan hima’afut hima’am tatitit hita’asabunimih. ");
INSERT INTO aai_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Baise gugumin ta ana bai’ufununayah Saul kaifet wanawananamaim hiwan fur ana sou ta’amaim hiruru re. ");
INSERT INTO aai_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul na Jerusalem tit sinaftobon bai’ufununayah bairi baita’imonin isan. Baise bai’ufununayah i Saul isan hai bir ra’at, anayabin men hibitumatum Saul i turobe baitumatumayan ta matar ai en. ");
INSERT INTO aai_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Imaibo Barnabas na ibais bai in Tur Abarayah biyah tit, kubuna mi’itube efamaim Regah itin naatu Regah eo nowar. Ana binan fairin Jesu wabinamaim auman eo hinowar. ");
INSERT INTO aai_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Naatu hibai bairi hima Jerusalem ana uman men sanet etei remor Regah wabinamaim binan. ");
INSERT INTO aai_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jew sabuw iyab Greek tur hio bairi hi’o hibas naatu rabin morob isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Baise baitumatumayah afa tur hinowar basit, Saul hibai hire Caesarea hitit naatu au Tarsus hiyafar in. ");
INSERT INTO aai_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Imaibo ekaleisia sabuw Judea, Galilee naatu Samaria wanawanahimaim etei tufuwamaim hima hiyasisir. Naatu Anun Kakafiyin ana baibaisamaim fair hibai naatu hai kou’ay busuruf wowab ra’at yen, Regah nanamaim kakaf auman hima. ");
INSERT INTO aai_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter efan ta ta etei run tit ana sabuw itih remor inan, veya ta God ana sabuw iyab Lydda bar merar gagamin hima’ama bainanawanihimih in. ");
INSERT INTO aai_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nati’imaim orot ta wabin Aeneas, an uman murubin bai’etaw en gem yan inu’in kwamur etei eight sawar. ");
INSERT INTO aai_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Basit Peter isan eo, “Aeneas Jesu Keriso o ebiyawasi kumisir, a ir kunu ku’abar.” Orot mar ta’imonamo misir. ");
INSERT INTO aai_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sabuw etei Lydda naatu Sharon wanawanan hima’am abisa matar hi’i’itin etei hitumatum naatu Regah isan hitatabir. ");
INSERT INTO aai_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa bar meraramaim babin ta wabin Tabitha, Greek fanahimaim i Dorcas. Iti babin i baitumatumayan ta mar etei gewasin esisinaf naatu yababan wairafih ebibaisih. ");
INSERT INTO aai_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nati ana veya’amaim sawow bai naatu morob biyan hisouw hibai hiyen bar tafantoro’ot hi’inuw. ");
INSERT INTO aai_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa na Lydda titit i men ef yok, imih bai’ufununayah Joppa hima’am Peter na Lydda’amaim titit ana tur hinowar. Basit orot rou’ab hiyafarih hin hifefeyan hio, “Are Peter akokok saise inan biyai inatit, men inarubir.” ");
INSERT INTO aai_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Basit Peter bobuna misir bairi hin, hina hitit hiyen bar awan yate tafan imaim hirun. Naatu kwafukwafur baibin etei hai faifuw Dorcas yawasin ma’am ana veya sakir bitih auman hibow hina hi’obaibiy hirerey auman hirun. ");
INSERT INTO aai_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter sabuw etei iuwih ufun hitit, i sun yowen yoyoban imaibo eo, “Tabitha kumisir!” Babin matan nuw naatu nura’at Peter i’itin ana maramaim misir mare ma. ");
INSERT INTO aai_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter eof babin bai ibais misir bat, imaibo baitumatumayah naatu kwafukwafur isah eaf hina yawasin batabat i’obaiyih hi’itin. ");
INSERT INTO aai_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tur tasasar tit Joppa sabuw etei hinowar naatu moumurih na’in Regah hitumitum. ");
INSERT INTO aai_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter veya moumurih na’in Joppa’amaim orot wabin Simon ana baremaim hairi hima. ");
INSERT INTO aai_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea imaim orot wabin Cornelius Rome baiyowayah hai orot ukwarin baiyow ana kou’ay wabin Italian Regiment. ");
INSERT INTO aai_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelius i God ana orot ta, i ana nibur tutufin etei God hikwakwafir, baibais gagamin maiyow yababan wairafih bitih, naatu mar etei God isan yoyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Veya ta rabirab three korok na’atube matan hibora’ah God ana tounamatar na run wabin su’ub eo, “Cornelius!” ");
INSERT INTO aai_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius matan takiyat itinkikin erebirubir auman eo, “Regah abisa kukokok?” Tounamatar iya’afut eo, “God ayoyoban naatu a siwar yababan sabuw ibitih Regah nanamaim hitit itin nuhin kusib. ");
INSERT INTO aai_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Imih boun orot afa iniyafarih hinan Joppa orot Simon, wabin ta Peter, i hinanawiy bairi hinan. ");
INSERT INTO aai_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon bobaituw kanabihimaim sawar yumatah ta ta sakirayan i ana baremaim bairi tema’am, ana bar tor rewan ebatabat.” ");
INSERT INTO aai_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Basit tounamatar hairi hio inan ufut, Cornelius ana bowayah orot rou’ab naatu baiyowayah orot ta’imon e’af ayuwih. Iti baiyowayan orot auman i God ana orot, Cornelius biyan ana tafafarayan orot. ");
INSERT INTO aai_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sawar etei himamatar na’atube hai tur eowen, basit iyafarih hin Joppa hitit. ");
INSERT INTO aai_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mar to orot efamaim hina Joppa hibiyubin auman, Peter auyit yen in bar tafan yoyoban isan. ");
INSERT INTO aai_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Basit bayumih morob ana kok i bay taa, bay hibogaigiwas bifotamih i matan taratan. ");
INSERT INTO aai_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mar botawiy naatu sawar ta rar gagamin na’atube umasusun kwafe’en hikuhamihamiy re me yan titit itin. ");
INSERT INTO aai_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nati wanawanan for yumatah ta ta, kok uma’ar, gabunam, naatu kutor mamu. ");
INSERT INTO aai_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Orot fanan nowar eo, “Peter kumisir iti sawar kurouw ku’aa.” ");
INSERT INTO aai_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Baise Peter iya’afut eo, “Men karam Regah, ayu men kafai sawar iti na’atube karitanih eregubagub auman aa’umih.” ");
INSERT INTO aai_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Orot fanan iban bairou’abin e’af maiye, “Sawar abisa God eorereb gewasin rarouw men o a notamaim kakafin inarouw inao.” ");
INSERT INTO aai_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sawar iti na’atube mar tounu matar, imaibo naniyan meyemeye sawar matabir maiye yen mar run. ");
INSERT INTO aai_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter matan hibora’ah sawar iti i’itin anayabin so’ob isan kasiy ma binotanot, orot Cornelius iyafarih hinan bar hitita’ur hina fur awan hibat. ");
INSERT INTO aai_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hi’afariy hibatiyih hio, “Orot wabin Simon Peter iti a baremaim ema’am?” ");
INSERT INTO aai_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter matan hibobora’ah isan boro’ika ma binotanot, Anun Kakafiyin iu eo, “Simon, orot nah tounu o tenunuwihi. ");
INSERT INTO aai_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Imih kumisir kura’iy bar baban, men a inakutan baise bairi kwanan, anayabin ayu aiyafarih hina.” ");
INSERT INTO aai_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peter misir ra’iy naatu iuwih eo, “Ayu orotoban iti kwa ayu kwanunuwuhu, kwa a’an aisim kwana?” ");
INSERT INTO aai_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hiya’afut hio, “Aki i baiyowayan orot ukwarin wabin Cornelius iyafari ana. Iti orot ana yawas i gewasin, naatu God ebibiruw, Jew sabuw etei iti orot i tekakakafiy. Tounamatar kakafiyin iu, o tifefeyani itan ana bar, saise o abisa itao’o i tanowar isan.” ");
INSERT INTO aai_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Basit Peter nah tounu buwih bar hirun bairi fai ta’imon hi’in. Mar to Peter ana orot bairi himisir naatu baitumatumayah afa Joppa’ane auman hiturih bairi hin. ");
INSERT INTO aai_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Veya baitonin hina Caesarea hitit. Cornelius i ma matan ef i’itin, taintuwan afa e’af ayuwih hina ana baremaim bairi hima Peter hikakaif. ");
INSERT INTO aai_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter na bar rur ana maramaim, Cornelius nanamaim sun yowen kwafir re. ");
INSERT INTO aai_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Baise Peter imisiruw eo, “Kumisir ayu i orot o na’atube.” ");
INSERT INTO aai_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter tur busuruf auman Cornelius hairi hirun hin bar wanawanan hitit naatu sabuw kou’ay gagamin na’in hima’am kouh yen. ");
INSERT INTO aai_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Iuwih eo, “Kwa etei kwaso’ob Jew hai ofafar men ebibasit boro Ufun Sabuw atinanawani bairi tatitayo’ay. Baise God i’obaiyu aitin ayu men orot ta biyan karitanin o gubagub anarouw anao. ");
INSERT INTO aai_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Imih ayu isou tur kwabiyafar, ayu men erekwahir auman anamih. Ayu kwa abibatiy, aisim ayu isou tur kwaiyafar ana?” ");
INSERT INTO aai_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius iya’afut eo, “Veya kwafe’en na’atube sawaraka, veya three korok na’atube rabirab au baremaim ayoyoyoban, naniyan meyemeye orot ana faifuw kwes nau’umaim bat eo, ");
INSERT INTO aai_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelius, ayoyoban God nowar naatu a siwar sabuw yababan wairafih ibitih imaim ana not kusib. ");
INSERT INTO aai_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","‘Orot ta kwiyafar en Joppa imaim orot wabin Simon wabin ta Peter i Simon bobaituw kanabihimaim sawar ta ta sakirayan ana bar tor rewanamaim ema’am biyan etit.’ ");
INSERT INTO aai_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Imih o isa tur saisewat aiyafar, naatu gewasin maiyow o ina itit, naatu aki etei God nanamaim Regah sawar etei eo biyuni nowaramih ama akakaif.” ");
INSERT INTO aai_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Imaibo Peter busuruf binan eo, “Ayu bounabo aso’ob, God men orot babin ta’imon itin yan ebaibimih. ");
INSERT INTO aai_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Baise orot menan ta ta iyab i tibibiruw naatu abisa gewasin tisisinaf. ");
INSERT INTO aai_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tur God iyafar na Israel biyah titit i etei kwaso’ob, iti tur gewasin i tufuw Jesu Keriso wanawanamaim ema’am. It etei ata Regah. ");
INSERT INTO aai_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Naatu kwaso’ob sawar abisa Judea wanawanan mamatar, John bapataito isan bibinan ufunamaim iti sawar i Galilee imaim busuruf. ");
INSERT INTO aai_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mi’itube Anun Kakafiyinamaim God Jesu Nazareth matuwan tafan eof nowah naatu fair tafan bisuwai i kwaso’ob. Naatu ana bowabow mi’itube run tit bow yawas gewasin sinaf, sabuw iyab afiy hai fairamaim hima’am etei biyawasih auman i kwaso’ob, anayabin God i hairi hima’am. ");
INSERT INTO aai_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sawar abisa Jew hai me yan naatu Jerusalemamaim sisinaf etei i aki a’itah sif arurubon. Naatu onaf afe’enamaim hikubar momorob auman i aki aso’ob. ");
INSERT INTO aai_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Baise veya tounu ufunamaim God morobone bora’ah maiye naatu iwa’an tit irerereb sabuw hi’itin. ");
INSERT INTO aai_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Men sabuw etei hi’itin, baise sabuw iyab God rurubinihiwat, nati i aki iyab morobone mimisir maiye ufunamaim bairi a’aa atomatomawat. ");
INSERT INTO aai_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Naatu eobaiyuni tur gewasin sabuw etei isah ana binan hai tur ana’owen Jesu i God Rubin sabuw yawayawasih naatu murumurubih baibabatiyih isan. ");
INSERT INTO aai_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dinab orot etei isan hibinan hio sabuw iyab i wabinamaim hinabitumatum boro hai bowabow kakafih nanotawiyen.” ");
INSERT INTO aai_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter iti na’atube bat eo inan wanawanan Anun Kakafiyin ra’iy sabuw iyab hima tur hinonowar tar gabuwih. ");
INSERT INTO aai_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jew baitumatumayah afa Peter bairi Joppa’ane hinan hifofofor men kafaita. God ana usar Anun Kakafiyin Ufun Sabuw auman tafahimaim isuwai re’ere isan. ");
INSERT INTO aai_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Naatu sabuw menah botabir tur ta ta hio God hibora’ara’ah. Imaibo Peter eo, ");
INSERT INTO aai_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iti sabuw boro yait harewamaim bapataito bain isan na’otanih? Anayabin Anun Kakafiyin it tabaib na’atube i auman hibaika. ");
INSERT INTO aai_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Basit iuwih Jesu Keriso wabinamaim bapataito hibai, naatu Peter veya bai’ab na’atube bairi ma isan hifefeyan nati’imaim bairi hima. ");
INSERT INTO aai_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tur Abarayah naatu baitumatumayah Judea wanawanan Ufun Sabuw God ana tur hibaib isan tur hinowar. ");
INSERT INTO aai_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Imih Peter yena Jerusalem titit ana veya baitumatumayah hai ar afu’afuw himisir higam hio, ");
INSERT INTO aai_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“O in Ufun Sabuw hai ar mo’oh tutufih bairi kwama kwa’aa kwatomatom iti ina.” ");
INSERT INTO aai_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Naatu Peter busuruf aneika abisa mamatar i kubuna hai tur eowen eo. ");
INSERT INTO aai_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Veya ta Joppa ama ayoyoyoban ana maramaim matau hibora’ah sawar ta rar gagamin na’atube tainin kwafe’en marane hikuhamihamiy rena sisibu’umaim nutanub. ");
INSERT INTO aai_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ayu anunuwariy for yumatah ta ta a’itan, uma’ar, kok, uway naatu mamu aitah, ");
INSERT INTO aai_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","basit orot ta fanan anowar iuwu eo, ‘Peter kumisir sawar iti kurouw ku’aa.’ ");
INSERT INTO aai_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Baise ayu ao, ‘Regah men karam, anayabin bay kakafih naatu gubagub auman men kafa’imo awau’umaim narunamih.’ ");
INSERT INTO aai_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Baise orot fanan iban maiye marane eafare eo, ‘Sawar abisa God kurereb gewasin eo, o men kakafin inarouw inao’omih.’ ");
INSERT INTO aai_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sawar iti i mar tounu matar, basit yomaninamaim sawar tutufin etei matabir maiye in mar wanawanan run. ");
INSERT INTO aai_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nati ana veya’amaim orot tounu Caesarea’ane ayu isou hiyafarih hina bar ama’ama imaim hitit. ");
INSERT INTO aai_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Anun Kakafiyin iuwu bairi kwanan men inakwahir, naatu Joppa’ane taitu nah six hituru bairi an Caesarea atit naatu orot wabin Cornelius ana bar arun. ");
INSERT INTO aai_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cornelius ana bar wanawanan Tounamatar mi’itube irerereb i’itin i ai tur eowen naatu tounamatar iu, ‘Orot afa iniyunih hinan Joppa orot wabin Simon Peter biyan hinatit. ");
INSERT INTO aai_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Naatu i boro ayawas ana tur nab nan nao kwananowar, naatu nati turamaim o a nibur bairi naatu taituwa afa bairi kwama’am boro yawas kwanab.’ ");
INSERT INTO aai_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Naatu ayu abusuruf ao anan ana maramaim Anun Kakafiyin re targabuwih, anamaim it tatar gabuwit na’atube. ");
INSERT INTO aai_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Imaibo ayu Regah abisa eo i anot, ‘John i harewamaim bapataito it, baise kwa boro Anun Kakafiyinamaim bapataito kwanitih.’ ");
INSERT INTO aai_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Imih iti i bebeyan, God siwar ta’imon Ufun Sabuw itih, it Regah Jesu Keriso tabitumitum ana maramaim bitit na’atube. Imih ayu yait God abisa sisinaf boro ata’otan?” ");
INSERT INTO aai_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iti tur hinonowar ana veya hai gamin sawar, God hibora’ara’ah hio, “Turobe. God Ufun Sabuw auman kakafih baihamiyen yawas bain isan hai ef botawiy itih.” ");
INSERT INTO aai_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Biyababan bai’akir kakafin Stephen hirab momorob ana maramaim matar, baitumatumayah tarbounih hitit nanabin hin. Afa hin Fonisia, Cyprus, naatu Antioch imaim hitit Jew akisihimo isah tur gewasin hifaram. ");
INSERT INTO aai_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Baise baitumatumayah afa Cyprus naatu Sairini hima’am hin Antioch hitit Ufun Sabuw auman isah hibinan tur gewasin Jesu Keriso isan hai tur hi’owen. ");
INSERT INTO aai_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Regah ana fair tafah mara’at hibinan sabuw moumurih na’in hitumatum Regah isan hitatabir. ");
INSERT INTO aai_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abisa hisisinaf ana tur in Jerusalem ekaleisia hinowar, basit Barnabas hiyafar na Antioch tit. ");
INSERT INTO aai_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Natitit ana maramaim God sabuw mi’itube bigegewasinih itih, basit yan sisir naatu koufair itih eo, dogor tutufin etei kwaniturobe Regah sisibinika kwanama. ");
INSERT INTO aai_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas i orot gewasin, Anun Kakafiyin biyan karatan naatu ana baitumatum fairin, imih sabuw moumurih na’in bow hina Regah biyan hitit. ");
INSERT INTO aai_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Imaibo Barnabas Saul nuwihinamih in Tarsus tit. ");
INSERT INTO aai_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nuwih inanan baib ana maramaim nawiy hairi hina Antioch hitit, imaim kwamur ta’imon tutufin ekaleisia nati’imaim bairi hima. Naatu sabuw bai’ufununayah boubuh kou’ay gagamin na’in hi’obaibiyih. Imih bai’ufununayah tafaram Antioch imaim wab iti Kirisiyan teo imaim matar. ");
INSERT INTO aai_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nati ana veya’amaim dinab orot afa Jerusalemane hina Antioch hitit. ");
INSERT INTO aai_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Naatu dinab orot ta wabin Agabus Anun Kakafiyin ana fairamaim misir eo, “Baimar kakafin boro’omo tafaram wanawanan namatar.” Iti baimar i Claudius i’aiwob ma’ama ana veya’amaim matar. ");
INSERT INTO aai_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bai’ufununayah hai not hibogaigiwas i hai mour ana fofonin na’atube tuwahinah Judea hima’am baibaisih isan hio, ");
INSERT INTO aai_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","naatu hisinaf. Imaibo Barnabas, Saul hairi umahimaim hiyafar hibai hin ai’in Jerusalem hima’am hitih. ");
INSERT INTO aai_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nati ana veya’amaim Herod busuruf sabuw afa hina ekalesia ana kou’ayamaim hima’am bow fatum bai’akir kakafin maiyow itih. ");
INSERT INTO aai_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naatu John tuwah James uwih hibai kaiyomaim hiyi morob. ");
INSERT INTO aai_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iti na’atube sinaf Jew sabuw hibiyasisir itih, basit, Faraw Wanawanan Yeast En ana hiyuw hi’aa ana mar eo Peter hibai hifatum. ");
INSERT INTO aai_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter hibai hifafatum ufunamaim hibai hin dibur hiyari’iy, baiyowayah etei 16 hima’uh hima. Pilate kokok i Tar Nowaten hiyuw ufunamaim sabuw etei matahimaim tibatiy isan. ");
INSERT INTO aai_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Imih Peter diburamaim hibotan hima, baise ekaleisia dogoroh tutufin etei God isan hiyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nati gugumin ta’imon Pilate yayakitifuw mar tatot tibatiyimih, Peter baise ma’utenayah orot rou’ab hai founamaim uman rororon chain hi’utan. Naatu au waraunane i ma’utenayah umah hi’utan naatu i matan fot in. Dibur etawan auman ma’utenayah hibat hikakaif. ");
INSERT INTO aai_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Naniyan meyemeye Regah ana tounamatar run bat naatu marakaw bar wanawanan kusisiar re, tounamatar Peter tuwabun bai ibunibun eo, “Mata enuw kumisir saife.” Mar ta’imonamo Peter uman chain hiha’obow hire. ");
INSERT INTO aai_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Imaibo tounamatar Peter iu, “A faifuw kwiyoun naatu a baibiyon kwiyoun.” Peter na’atube sinaf naatu tounamatar eo, “A faifuw tafan baibiyon naiw kufifin naatu kwi’ufnunu.” ");
INSERT INTO aai_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter i’ufunun hairi hitit dibur bar ufunane hire, baise Peter men kafa’imo so’ob tounamatar abisa sisinaf, i notanot i mimim rouw. ");
INSERT INTO aai_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hitit ma’utenayah etawan wan hibatabat naatu etawan bairou’abin hibatabat hinatabirih. Naatu hina etawan gagamin in bar merar titit awanamaim hitit, etawan akisin botawiy hitit ef yan hire. Ef nati hibutitiy hin yomaninamaim hitit, basit tounamatar sa’iwa’an. ");
INSERT INTO aai_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter imaibo matan to iwa’an eo, “Turobe, iti sawar i anababatun ayu isou matar. Regah ana tounamatar iyafar Herod ana fairane naatu Jew sabuw sawar abisa hinotanot mataramih i umahine ayu iyawasu. ");
INSERT INTO aai_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Peter ana not kukubunai ufunamaim na John Mark hinah Mary ana bar tit. Nati’imaim sabuw moumurih na’in hiru’ay hima hiyoyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter na etawan ufunane bat rukikitar, naatu bowabow babitai wabin Rhoda etawan botawiyinamih na. ");
INSERT INTO aai_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Baise Peter fanan i’inan ana maramaim yan wanawanan yasisir awan karatan etawan botawiyina’e i matabir nunuw run e’af eo, “Peter na ufun ebatabat.” ");
INSERT INTO aai_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sabuw hi’u, “O anot i kwaris.” Baise i ana yanibebemaim, imih hio, “Nati i Peter ayubin.” ");
INSERT INTO aai_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Baise Peter bat rurukikitar etawan hibotawiy, naatu hi’i’itin ana veya hifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter umanamaim iman awah bofot naatu Regah mi’itube diburane bobotait hai tur eowen, “Iti i James ana tur kwana’owen naatu taitu auman hai tur kwana’owen.” Imaibo ihamiyih tit efan ta’amaim in. ");
INSERT INTO aai_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mar auman baiyowayah wanawanahimaim kasiy gagamin na’in matar, taiyuwih hibabatiyih hio, “Peter isan mi’itube’emih iti na’atube matar?” ");
INSERT INTO aai_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod kwararih hin hinuwih, baise men hitita’ur. Basit ma’utenayah orot nah 16 buwih ibabatiyih sawar eo hibow hin hirouw himorob. Iti ufunamaim imaibo Pilate Judea ihamiy re in Caesarea imaim mar kafai ma. ");
INSERT INTO aai_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod ana yaso’ar gagamin na’in Taiya naatu Sidon sabuw isah biyaso’aso’ar. Imih sabuw kou’ay hibai Herod itinamih hina. Wantoro’ot aiwob ana orot gagamin wabin Blastus yan hiyi rabon isahine bat imaibo hina Herod biyan hitit tufuw isan hifefeyan. Anayabin hai tafaram ana bay i Herod ana tafaramane nan. ");
INSERT INTO aai_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Veya hirurubin na’atube aiwob hai gub ana faifuw bai iyoun ana urama’ama’amaim mare ma sabuw isah binan. ");
INSERT INTO aai_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sabuw tur hinonowar hio, “Iti men orot ebibinanumih, baise god.” ");
INSERT INTO aai_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mar ta’imon Regah ana tounamatar Herod rab re morob biyan motamot hi’an morob, anayabin sabuw bora’aten hibitin men bai God itinimih. ");
INSERT INTO aai_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naatu God ana tur ra’at tasasar tit sabuw etei hinowar. ");
INSERT INTO aai_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas, Saul hairi hai bowabow hibisawar ufunamaim Jerusalemane himatabir maiye John Mark hibai bairi hin. ");
INSERT INTO aai_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ekaleisia Antioch wanawananamaim orot afa i dinab oro’orot naatu afa i bai’obaiyenayah, naatu orot wabih i iti: Barnabas, Simeon, wabin ta i Niger, Lucius Sairini matuwan, Manaen, Herod hairi bay ta’imon hi’aan hirara’at naatu Saul. ");
INSERT INTO aai_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Veya ta hiyohar Regah hikwakwafir wanawanan, Anun Kakafiyin iuwih eo, “Barnabas, Saul hairi kwayasairih ayu isou, anayabin bowabow ta isan a’afih hinabowamih.” ");
INSERT INTO aai_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Naatu hiyohar hiyoyoyoban ufunamaim, umah tafah hiyara’aten fair hitih imaibo hiyafarih hitit hin. ");
INSERT INTO aai_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas Saul hairi Anun Kakafiyin ana bonawiyenamaim hina Seleucia hitit naatu wa hibai hirabon hin Cyprus imaim hitit ");
INSERT INTO aai_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Naatu hina Salamis hititit ana maramain Jew hai Kou’ay baremaim God ana tur hibinan, John Mark i iti bowabow wanawananamaim baibaisih isan hibai bairi hin. ");
INSERT INTO aai_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nuw ana fofonin na’atube hiremor hin au waraunane bar merar wabin Pafos hitit, nati’imaim Jew orot kwerayan ma’am koun hiyen, wabin Bar-Jesus, iti i orot taiyuwin isan dinab orot erouw eo’o. ");
INSERT INTO aai_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Naatu iti orot i gawan orot wabin Sergius Paulus ana of ta. Sergius i orot not wairafin, nati nuw ana gawan orot. Barnabas, Saul hairi e’af hina nanamaim hitit God ana tur nowar isan ifefeyanih. ");
INSERT INTO aai_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Baise kwerayan wabin Elimas (wabin Greekamain) eotanih men kok gawan orot tur tanowar baitumatum tab. ");
INSERT INTO aai_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Imaibo Saul wabin ta Paul, Anun Kakafiyin iwanasum ma’am mutufor nuw kwerayan orot itinkikin ");
INSERT INTO aai_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","naatu eo, “O i Demon natun! Sawar gewasih etei hai rakit wairafin i o. O i baifuwen kakafih yumatah ta ta biya awan karatan, o i mar etei Regah ana turobe kubotabiren baifuwen temamatar! ");
INSERT INTO aai_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Imih Regah uman boun boro tafamaim nare mata nifim naatu marakaw boro mar kafai men ina’itin.” Mar ta’imonamo Elimas matan matakis bai matan gugum naatu misir eof tobotobon sabuw uman bai nawiyin na isan ifefeyanih. ");
INSERT INTO aai_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gawan orot abisa matar i’itin i itumatum, anayabin Regah ana bai’obaiyen tur nonowar i ifofofor men kafaita. ");
INSERT INTO aai_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul ana ofonah bairi Pafos imaim wa hibai hirabon hina Perga hitit tafaram Pamfilia wanawanan. John Mark nati’imaim ihamiyih, naatu matabir maiye in Jerusalem tit. ");
INSERT INTO aai_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Baise Barnabas Paul hairi hikofan maiye hin Pisidia Antioch hitit tafaram Pisidia wanawanan. Naatu Baiyarir Ana Veya Kou’ay Bar hirun himare. ");
INSERT INTO aai_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Buk Atamaninamaim Moses ana ofafar kikirum naatu dinab hai buk hibiyab ufunamaim. Kou’ay Bar ana ukwarih isah tur hiyafar hio, “Taitu kwa aur koufair tur ta nama’am na’at aki akokok iti sabuw kwanao hinanowar.” ");
INSERT INTO aai_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul misir umanamaim rutanih naatu busuruf eo, “Israel orot baibin naatu kwa Ufun Sabuw iyab iti’imaim kwama God kwakwafir, anao kwananowar! ");
INSERT INTO aai_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel Sabuw ata God uwatanah rubinih naatu nah toumanih na’atube Egypt hima’am ana veya iwa’an wabih ra’at, naatu ana fairamaim nawiyih hitit. ");
INSERT INTO aai_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Naatu arar yanamaim kwamur etei 40 na’atube ba’afuwih bairi hima. ");
INSERT INTO aai_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tafaram seven Canaan wanawanan gurusih naatu me bai ana sabuw nowahimih itih. ");
INSERT INTO aai_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Sawar iti himamatar i kwamur etei 450 na’atube wanawananamaim himatar. Iti ufunamaim imaibo yamutufurenayan oro’orot gagamih ya hima hikaifih hina dinab orot Samuel ana veya’amaim hitit. ");
INSERT INTO aai_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Naatu sabuw aiwob isan hifefeyan, God Saul bai itih orot Kish natun, Benjamin wawawan, Saul i’aiwob ma kwamur etei 40 na’atube. ");
INSERT INTO aai_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Naatu God Saul bobosair ufunamaim David bai Saul efanin yai. God iti na’atube eo, ‘David o Jesse natun, orot o na’atube isa i ayu au yasisir gagamin na’in, ayu abisa sinafumih akokok etei boro i nasinaf.’ ");
INSERT INTO aai_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ana’omatanen eo na’atube, orot David ana rara’ane Israel Sabuw hai baiyawasinayan God bai na. ");
INSERT INTO aai_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesu nanamaim John mat na bowabow kakafih baihamiyen dogor baikitabiren bapataito bain isan busuruf eorerereb Israel sabuw tutufin etei isah. ");
INSERT INTO aai_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Naatu John ana bowabow bisawar auman sabuw iuwih eo, ‘Kwa anot ayu isou mi’itube kwanotanot? Kwanotanot ayu’uban i nati orot? En, baise orot ta ayu ufu’umaim enan, ayu men karam boro ana kwafure an ana sumasum anarufam.’ ");
INSERT INTO aai_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Taitu, Abraham ana niburune kwana warar kwatatain, naatu kwa Ufun Sabuw iyab God kwabiruw kwakakafiy, it isat yawas ana tur i hiyafar na tit. ");
INSERT INTO aai_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Anayabin Jerusalem bar merar sabuw hai ukwarih bairi Jesu ana bowabow men hi’inan, naatu dinab oro’orot hai tur mar etei Baiyarir Ana Veya hibiyab men naniyan hibaib, imih abisa hisisinaf i tur hio inu’in na iturobe. ");
INSERT INTO aai_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Basit morob isan ana ef men hitita’ur, Pilate asabunin morob isan hifefeyan naatu easabun morob. ");
INSERT INTO aai_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bukamaim abisa i isan eo na’atube hikirum inu’in hisisinaf ufunamaim, onaf afe’enane hibai hire hub wanawanan hiyai. ");
INSERT INTO aai_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Baise morobone God bora’ah misir maiye. ");
INSERT INTO aai_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naatu veya moumurih na’in sabuw iyab Galilee’ine hi’ufunun bairi hina Jerusalem hititit isah irerereb, naatu nati sabuw i boun hitit sabuw afa isah sif tirurubon. ");
INSERT INTO aai_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Naatu iti tur gewasin i abisa God ata’a’agir eo’omatanih abai kwa isa anan. ");
INSERT INTO aai_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Iti tur i bai it isat ebiturobe, it i ata’a’agir natunatuh, Jesu morobone mimisiramaim. Psalm bairu’abin eo na’atube, ‘O i ayu natu, boun ayu ana o Tamat.’ ");
INSERT INTO aai_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Naatu ana’an aisim God morobone bora’ah maiye mimisir, naatu boro men nihamiy maiye na’in namasamih. Nati isan ana tur iti na’atube eo, ‘Ayu yawas kakafiyin naatu baigegewasin David ao’omatan boro baigegewasin anit.’ ");
INSERT INTO aai_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Buk efan ta’ane eo maiye, ‘God boro men ana orot kakafiyin nihamiy na’in namas ni’akiramih.’ ");
INSERT INTO aai_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Anayabin David ana veya’amaim God ana kok bow bisawar ufunamaim morob uwahinah sisibihimaim hiyai mas i’akir ");
INSERT INTO aai_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Baise orot yait God morobone iyawas mimisir i men mas i’akir. ");
INSERT INTO aai_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Isan imih taitu kwananowar, iti orot Jesu wabinamaim bowabow kakafih notawiyen isan ana tur i ao’orerereb, ");
INSERT INTO aai_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","iti Jesu wabinamaim sabuw iyab tibitumatum hai bowabow kakafihine i rufamih titit anayabin Moses ana ofafaramaim boro men karam narufami. ");
INSERT INTO aai_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Imih kwanakaifi gewas, saise abisa dinab hio men isa hinamatar. ");
INSERT INTO aai_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Okwanekwaneyah Kwana’itin! Boro kwana’oror naatu kwanamorob! Anayabin kwa a veya’amaim ayu boro bowabow ta ana sisinaf, kwa boro men kwanitumatum, basit sabuw afa hina hikurereb hio kwanonowar auman boro men kwanitumatum!’ ");
INSERT INTO aai_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul, Banabas hairi Kou’ay Bar hibihamiy auman sabuw hifefeyanih fur ta Baiyarir ana veya’amaim iban hitan maiye iti sawar isah hitidudur hitanowar. ");
INSERT INTO aai_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kou’ay Bar ana rou’ay hibihamiy ufunamaim, Jew sabuw maumurih na’in naatu sabuw iyab Jew hai kwafiren ana kakafemaim hima’am, Paul Barnabas hibi’ufununih koufair hitih God ana manaw ana kabeberamaim ma’amih hifefeyanih. ");
INSERT INTO aai_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Baiyarir Ana Veya bairou’abin sabuw nati bar merar tutufin etei Regah ana tur nowaramih hina. ");
INSERT INTO aai_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Baise Jew sabuw rou’ay gagamin hi’i’itin ana veya hibobowen naatu baigigimen tur hibow hitit, Paul abisa eo isan hibas. ");
INSERT INTO aai_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Imaibo Paul, Barnabas hairi hiofok hio, “God ana tur i wantoro’ot kwa ao kwanowar, baise kwa tur i kwakwahir, taiyuw kwanunutitiy ma’ama wanatowan kwa isa men karam, isan imih abihamiy aki anan Ufun Sabuw isah. ");
INSERT INTO aai_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Anayabin Regah ana obaiyunen tur biti iti na’atube eo, ‘Ayu kwa ayasairi Ufun Sabuw hai marakaw isan, saise kwa i boro yawas kwanab kwanatit kwanan tafaram yomanin kwanatit.’ ");
INSERT INTO aai_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ufun Sabuw iti tur hinonowar ana maramaim hiyasisir Regah ana tur hibora’ara’ah. Naatu sabuw moumurih na’in ma’ama wanatowan isan hirubinih hima’am hina baitumatumayah himatar. ");
INSERT INTO aai_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Naatu Regah ana tur ra’at tasasar tit nati bar merar ana fofonin etei hinowar. ");
INSERT INTO aai_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Baise Jew hai ukwarih himisir bar merar orot gagamih naatu God ana bowayah baibin gagamih yah hi’ora’ah Paul, Barnabas hairi isah hiwosai, naatu hinunih hitit nati bar merar ufunane hire. ");
INSERT INTO aai_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Basit Paul Barnabas hairi ah fofob hiru’uh re i hin Ikonium hitit. ");
INSERT INTO aai_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Naatu bai’ufununayah Antioch hima’am yasisir yah awan karatan naatu Anun Kakafiyin iwansumih. ");
INSERT INTO aai_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Matanfufur tisisinaf na’atube Ikonium bar meraramaim Paul, Barnabas hairi hin Kou’ay bar hirun hai tur hio’omaim Jew sabuw naatu Greek sabuw moumurih maiyow hibotabirih hina baitumatumayah himatar. ");
INSERT INTO aai_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Baise Jew sabuw iyab baitumatum hikwakwahir, himisir Ufun Sabuw yah hiyi hikura’ara’ahih inan himisir baitumatumayah sabuw isah yah so’ar. ");
INSERT INTO aai_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tur Abarayah nati’imaim manin maiyow hima, Regah ana tur men kafai birumaim hi’omih, baise tur fokarin maiyow hio hibinan. Hai tur baiturobe isan Regah fair itih ina’inan gagamih himamataren, saise sabuw hitaso’ob nati tur i Regah biyanane nan. ");
INSERT INTO aai_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Sabuw nati bar merar gagamin wanawanan hima’am hikusib rou’ab matar, sabuw turin Jew isah hin, turin Tur Abarayah isah hin. ");
INSERT INTO aai_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Imaibo Ufun Sabuw naatu Jew sabuw hai ukwarih bairi awah ta’imon hibasit Tur Abarayah kabayamaim rouw bai’a’afiyih isan hio. ");
INSERT INTO aai_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tur Abarayah tur hinonowar ana veya hibihir hin tafaram Laikonia wanawanan bar merar gagamih rou’ab, Lystra naatu Derbe imaim hitit hima. Naatu bar merar afa ");
INSERT INTO aai_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nati’imaim hirun hibusuruf Tur Gewasin hibinan hiremor. ");
INSERT INTO aai_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra wanawananamaim i orot ta an murubin ma’am. Iti orot i tutufuwaka an kakafin auman tufuw naatu men kafai reremoramih. ");
INSERT INTO aai_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paul eo orot nati’imaim ma nonowar, basit Paul orot ana baitumatum itin karam boro nayawas, imih Paul mutufor nuw orot itin ");
INSERT INTO aai_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","naatu fanan aumetawat eaf eo, “Kumisir mutufor a yan kubat!” Orot ma’am fasi’iwa’an misir an yan bat busuruf remor. ");
INSERT INTO aai_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sabuw rou’ay gagamin na’in hima’am abisa Paul sinaf hi’i’itin basit Laikonia turamaim fanah sib hio, “Anababatun god orotobe himatar isat hina hitit!” ");
INSERT INTO aai_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Naatu Barnabas wabin Zeus hiwab naatu Paul wabin Hermes hiwab anayabin Paul tur bi’ukwarin. ");
INSERT INTO aai_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeus ana firis, i ana Tafaror Bar gagamin i bar merar ufunane batabat, firis naatu sabuw bairi hikokok i Tur Abarayah hai sibor hitayai. Imih firis cow naatu beran bow na bar merar ana fur awanamaim tit. ");
INSERT INTO aai_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Baise Barnabas, Paul hairi sabuw abisa hibiwa’an hi’itih hairi hai faifuw hiseb naatu hinunuw sabuw hai founamaim hirun hio, ");
INSERT INTO aai_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kwa aisim iti kwasisinaf? aki i orot maiyow orot babin kwa na’atube. Aki iti’imaim anan aiyabin i Tur Gewasin ana binan, sawar iti hai yabin en kwanihamiyen, naatu God ma’ama wanatowan yait iti mar tafaram riy naatu sawar wanawanahimaim tema’am bimataren isan kwanamatabir. ");
INSERT INTO aai_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Marasika tafaram ta ta sabuw hai kok abisa hisisinaf i men rufutih, ");
INSERT INTO aai_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","baise mar etei sawar gewasih esisinaf imaim ekukubuna i turobe. Anayabin gagub marane iwa’an ere bay ana veya’amaim ematar bay ebit naatu dogor wanawanan yasisir awan ekakaratan.” ");
INSERT INTO aai_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paul, Barnabas hairi iti turamaim hisinaftobon sabuw rou’ay gagamin na’in hai siwar siboromih hibow hinan hio’otanih towa rufufurih. ");
INSERT INTO aai_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Imaibo Jew sabuw hai ukwarih afa Antioch naatu Ikoniumane hinan sabuw hiora’ahih himisir Paul higam hiu, naatu kabayamaim hirab hitain hitit hin bar merar ufunane hihamiy, hinotanot i morob hirouw. ");
INSERT INTO aai_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Baise bai’ufununayah hiru’ay hi’ar bebera’uh hibatabat inu’in misir matabir in bar merar tit, mar to i Barnabas hairi hin Derbe hitit. ");
INSERT INTO aai_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul, Barnabas hairi Tur Gewasin Derbe wanawanan hibinan naatu bai’ufununayah moumurih na’in hibow. Imaibo himatabir maiye hin Lystra, Ikonium naatu Antioch hitit Syria wanawanan. ");
INSERT INTO aai_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nati’imaim bai’ufununayah hibaisih naatu koufair hitih hi’uwih hio. “A baitumatum kwabaib imaim kwaniturobe kwanama, yababan moumurih maiyow boro tanabow, imaibo tanan God ana aiwobomaim tanarun.” ");
INSERT INTO aai_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ekaleisia hai kou’ay tata wanawanahimaim Paul Barnabas hairi orot ukwarih hirubinih, hibow naatu hiyohar isah hiyoyoban sawar, imaibo Regah i hai baitumatum ana’an umanamaim hiya. ");
INSERT INTO aai_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tafaram Pisidia wanawanan hi’afuw hirabon rounane hire’er ufunamaim hina Pamfilia hitit. ");
INSERT INTO aai_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Naatu Perga imaim hibibinan ufunamaim hire hina Atalia hitit. ");
INSERT INTO aai_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Wa imaim hibai himatabir maiye hin Antioch hitit, efan nati’imaim God ana tafafar naatu ana manaw ana kabeber hibai bowabow hibusuruf hibowabow yomanin himatabir hina nati’imaim hi’asa’ub. ");
INSERT INTO aai_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Imih hina Antioch hititit ana maramaim ekaleisia sabuw etei hi’af ayuwih hai tur hiowen mi’itube God i wanawanahimaim sinaf baitumatum ana etawan botawiy Ufun Sabuw auman isah. ");
INSERT INTO aai_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naatu bai’ufununayah bairi nati Antioch imaim bairi manin maiyow hima. ");
INSERT INTO aai_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Orot afa Judea’ane hire hina Antioch hitit baitumatumayah nati’imaim hima’am hi’obaibiyih hio, “Kwa i Moses ana ofafar eo na’atube a’ar mo’oh hina’afuw kwa boro yawas kwanab.” ");
INSERT INTO aai_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul, Barnabas hairi iti bai’obaiyen isan nati orot bairi higam tur manin maiyow hio, basit Paul Barnabas hairi naatu Antioch orot afa na Jerusalem tur abarayah naatu regaregah ai’in bairi iti tur yamutufurin isan hirubinih. ");
INSERT INTO aai_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ekaleisia ana kou’ay wanawananamaim iti sabuw hiyafarih hin. Naatu hiremor hina Fonisia naatu Samaria’amaim hi’afuwabon hirabon. Ufun Sabuw mi’itube God hibai hibitumatum isan hai tur hi’owen, naatu baitumatumayah nati’imaim hima’am iti tur hinowar yasisir dogoroh awan karatan. ");
INSERT INTO aai_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hina Jerusalem hititit ana veya’amaim, God ana ekaleisia, Tur Abarayah, naatu regaregah ai’in etei nati’imaim hima’am hai merar hiyi. Naatu Paul Barnabas hairi hibinanawan ana veya God isah mi’itube sisinaf hai tur hio’owen. ");
INSERT INTO aai_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Baise baitumatumayah afa Pharisee hai kou’ayane himisir hio, “Nati sabuw i boro hai ar kanabih hina’afuw naatu tana’uwih Moses ana ofafar hini’ufunun.” ");
INSERT INTO aai_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tur Abarayah regaregah bairi hina hiku’ay iti baibat nutitiyin isan ");
INSERT INTO aai_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Manin maiyow hibas inan ufunamaim Peter misir eo, “Taitu baitumatumayah kwa kwaso’ob marasika God ayu kwa wanawanamaim rubinu iti Tur Gewasin Ufun Sabuw isah binan isan, saise i auman iti tur hitanowar naatu hititumatum.” ");
INSERT INTO aai_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God orot etei dogoroh i so’ob, imih Anun Kakafiyin it bitit na’atube Ufun Sabuw auman itih, nati’imaim ebi’obaiyit God nati sabuw auman ibasit ebowabow. ");
INSERT INTO aai_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","God it isat esisinaf na’atube i auman isah ef ta’imon esisinaf, anayabin i hai baitumatumamaim dogoroh eyayafur. ");
INSERT INTO aai_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Naatu boun aisim bit gagamin it uwatanah naatu it men karam tata’abar i kwabai bai’ufununayah tuwabuh kwayara’ah God routobon kwabitin. ");
INSERT INTO aai_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","En! Baise, manaw kabeber ata Regah Jesu’umaim nan it ta’ita’imon taitumatum tabai biyawasit na’atube ibo hitumatum hibai yawas itih.” ");
INSERT INTO aai_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kou’ay nati etei awah fot hima Paul Barnabas hairi God ina’inan fokarih naatu baifofofor mi’itube i wanawanahimaim Ufun Sabuw isah sisinaf i hai tur hiowen hima hinowar. ");
INSERT INTO aai_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hio in sasawar ufunamaim, James misir eo, “Taitu naatu tuwai’inah anao kwananowar! ");
INSERT INTO aai_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon iti boun mi’itube God ana naniyan wantoro’ot Ufun Sabuw wanawanahimaim bow i ana sabuw nowan himatar kakaifih isan iti kubuna tanowar. ");
INSERT INTO aai_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dinab oro’orot hai tur etei iti tur isan i tibasit. Bukamaim iti na’atube eo. ");
INSERT INTO aai_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Iti ufunamaim ayu boro ana matabir, Regah eo, naatu David ana bar ufar re’er ana wowab maiye. Ana bar huhurir ana bobunai, naatu ana itinin anan bobaun maiye. ");
INSERT INTO aai_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Saise sabuw afa boro ayu hinanuwuhu hinan, Ufun Sabuw iyab ayu nowau arouw a’afih. ");
INSERT INTO aai_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Imih Regah eo, iti i marasika eo hinowaraka.’ ");
INSERT INTO aai_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Iti i ayu au not,” James ikofan eo maiye, “Ufun Sabuw God isan temamatabir men tana’otanih. ");
INSERT INTO aai_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Baise nati efanin fef tanakirum hai tur tana’owen, bay sibor hiya’ay biyah eregubagub auman men hinaa, men hina’in tabitabir hiniwa’an kwanekwan, masanuw sikah birabir naatu wanawanah rara auman men hinaa. ");
INSERT INTO aai_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Anayabin Moses ana ofafar i kwamur moumurin maiyow Kou’ay Baremaim Baiyarir Ana Veya mar etei hibiyab hibinan hinonowar.” ");
INSERT INTO aai_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Imaibo tur abarayah, Regaregah ai’in naatu kirisiyan sabuw bairi hita’imon hai not hibogaigiwas orot afa kou’ayomaim roubinih Paul Barnabas bairi au Antioch baiyafarih isan hio. Basit Judas wabin ta Barsabas, Silas hairi hirubinih, iti orot rou’ab i baitumatumayah hai bonawiyenayah orot gagamih. ");
INSERT INTO aai_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naatu fef i iti na’atube hikirum hitih hibai hin. “Aki kwa tuwatanah Tur Abarayah, regaregah ai’in. Kwa Ufun Sabuw iyab baitumatumayah nati Antioch, Syria naatu Silisia wanawanahimaim kwama’am etei a merar ayiy.” ");
INSERT INTO aai_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Aki tur anowar orot afa aki ai kou’ayane hitit hina hai turamaim abisa hio i kwa anot hikwaris. Naatu nati orot i men kafai aki biyai’ine fair aitih nati tur hibai hinamih. ");
INSERT INTO aai_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Isan imih aki aru’ay ao aibasit tur abarayah afa arubinih kwa isa abiyafarih. Iti orot i boro ata ofonah Barnabas Paul bairi hinan. ");
INSERT INTO aai_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iti orot rou’ab ata Regah Jesu Keriso wabin isan hai yawas etei hikwahir tebowabow. ");
INSERT INTO aai_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Imih Judas Silas hairi kwa isa abiyafarih, i boro hinao kwanowar sawar ta’imon iti fefemaim akikirum na’atube. ");
INSERT INTO aai_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Aki Anun Kakafiyin bairi aibasit men bit gagamin atit kwatab, ofafar iti bai’ufnunin isan aibasit abit sisibinamaim. ");
INSERT INTO aai_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bay wagaburisah hisisibor men kwanaa, for rara auman men kwanaaf for sikah hibir himomorob men kwanaa, naatu in baisesebar kwanekwan i kwanahaiw. Sawar iti ao na’atube kwanasisinaf kwa a ef etei boro namutufor. Gewasinamaim aotuturi, kwanama.” ");
INSERT INTO aai_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Orot hiyafarih tur hibai hin Antioch hitit, nati’imaim ekaleisia tutufin etei hi’af ayuwih rou’ay gagamin hibai naatu fef hitih. ");
INSERT INTO aai_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Fef hibai hibiyab ana maramaim dogor wanawanan yasisir awan karatan koufair tur hinonowar isan. ");
INSERT INTO aai_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silas hairi i God ana dinab oro’orot, imih i tur manih maiyow hima hidudur, baitumatumayah koufair hitih naatu tafah fair hiyai. ");
INSERT INTO aai_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Fur bai’ab na’atube hima’am ufunamaim himisir taih tuwah tufuwamaim hio tuturih naatu sabuw iyab hibiyafarih isah himatabir maiye hin. ");
INSERT INTO aai_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Baise Silas nati’imaim ana not bogaigiwas iban ma maiye. ");
INSERT INTO aai_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Naatu Paul Barnabas hairi Antioch imaim mar kafai hima, naatu baitumatumayah afa nati’imaim bairi sabuw afa hi’obaibiyih naatu Regah ana tur gewasin hibinan hiremor. ");
INSERT INTO aai_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Veya bai’ab na’atube sasawar ufunamaim Paul ana not bogaigiwas Barnabas isan eo, “It boro tanamatabir maiye bar merar etei taituwat tema’ama’amaim tanarun tanatit taninanawanih, Regah ana tur nati’imaim tabibinan tana’itin sabuw basit tema’am. ");
INSERT INTO aai_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nati ana veya Barnabas i kok John Mark tab bairi hitan. ");
INSERT INTO aai_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Baise Paul i men kok boro John Mark hitab bairi hitan, anayabin i men bairi hima hai bowabow hibow in yomanin hisawarimih, baise i Pamfilia imaim ihamiyih matabir maiye. ");
INSERT INTO aai_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nati’imaim Barnabas Paul hairi higam tur fokarih hio, naatu hairi hikusib Barnabas Mark bai hairi wa hibai au Cyprus hin. ");
INSERT INTO aai_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paul Silas rubin bai naatu tafaram bihamiy ana veya, baitumatumayah orot rou’ab hibuwih higegewasinih Regah ana manaw ana kabeber wanawanan hiyari’iyih takaifih isan. ");
INSERT INTO aai_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Basit Paul misir Syria naatu Silisia wanawanahimaim run remor ekaleisia koufair itih. ");
INSERT INTO aai_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul remor na Derbe tit imaibo ikofan maiye na Lystra tit, nati’imaim baitumatumayan wabin Timothy ma’am biyan tit, Timothy hinah i Jew babin, baitumatumayan ta, baise tamah i Greek orot. ");
INSERT INTO aai_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra naatu Ikonium wanawanan baitumatumayah etei Timothy i hibifai. ");
INSERT INTO aai_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul kok i Timothy tab bairi hitan, imih ana’ar kanabin e’afuw, iti na’atube sinaf anayabin Jew etei nati’imaim hima’am hiso’ob Timothy tamah i Greek orot. ");
INSERT INTO aai_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bar merar tata hirun hitit roube’aten tur abisa tur abarayah naatu regaregah ai’in Jerusalemamaim bai’ufnunin isan hio hibibasit, baitumatumayah hai tur hi’owen auman hin. ");
INSERT INTO aai_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ekaleisia sabuw fair hitih hai baitumatum ra’at naatu sabuw boubuh hirun hai kou’ay ra’at. ");
INSERT INTO aai_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paul ana ofonah bairi Firigia naatu Galasia wanawanahimaim hiremor naatu Anun Kakafiyin Asia wanawanan hireremor men ibasit boro imaim hitabinan. ");
INSERT INTO aai_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hiremor hina Maisia ana yoyowamaim hitit, hisinaftobon hitan Bitiniya wanawanan hitarun isan baise Jesu Anunin men ibasit boro hitan. ");
INSERT INTO aai_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Imih hina Maisia hihamiy hirabon hire hina Troas hitit. ");
INSERT INTO aai_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nati gugumin Paul mim, Masedonia orot bat fefeyan eo, “Kwanarabon Masedonia imaim aki kwaibaisi!” ");
INSERT INTO aai_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul iti mim i’itin ufunamaim aki abobuna au Masedonia arabon, anayabin aki ai not abogaigiwas God ea’afi nati’imaim God ana tur binan isan. ");
INSERT INTO aai_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aki Troas imaim wa abai mutufor arabon an Samoteres atit naatu mar to aikofan maiye an Neapolis atit. ");
INSERT INTO aai_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nati’imaim wa ai’hamiy ai’iwat arun an Philipi atit, Masedonia wanawanan ana bar merar gagamin ta, naatu iti bar merar i Rome gawan wowab. Aki nati’imaim veya bai’ab na’atube ama. ");
INSERT INTO aai_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Baiyarir Ana Veya atit bar merar ana fur aihamiy ana harew sisibinamaim atit, nati’imaim anotanot boro yoyoban ana efan atatita’ur. Nati’imaim amare baibin iyab hinan i ai obaibiyih. ");
INSERT INTO aai_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Naatu babin ta iti tur ao nonowar i wabin Lydia ana tafaram Taiyatira, iti babin i sawar biyah namar iwa’an sabuw tetotobon naatu i God kwafirinayan babin ta, nati ana veya’amaim God dogoron botawiy. Paul tur abisa eo etei nowar. ");
INSERT INTO aai_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Naatu nati babin taintuwan bairi nati baremaim hima’am etei bapataito hibai, imaibo ifefeyani eo, “Kwananotanot ayu Regah ana bitumitum na’at, basit kwana tan au baremaim bairit tama.” Iti na’at aki eokikini bairi an. ");
INSERT INTO aai_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Veya ta aki yoyoban ana efan isan anan akir babitai ta bairi aitar. Iti babitai i afiy kakafin hitarasum ma sawar abisa temamatar isah i eo, naatu sawar iti na’atube sisinaf ana sabuw kabay gagamin maiyow hibaib. ");
INSERT INTO aai_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Iti babitai Paul aki bairi i’ufnuni iwow eo, “Iti orot i God auyomtoro’ot ana’akir wairafih, kwa mi’itube na yawas bain isan teo’orereb.” ");
INSERT INTO aai_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Babitei iti na’atube mar moumurih maiyow sinaf inan yomaninamaim, Paul yan so’ar naatu tatabir afiy nati babitai tar gabuw ma’am isan eo, “Jesu Keriso wabinamaim o abi’a’ari babitai kwaihamiy kutit!” Naatu mar ta’imon afiy babitai ihamiy tit. ");
INSERT INTO aai_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Babitei ana matuwan sabuw hai kabay imaim hima hibaib ana ef sasawar hi’i’itin ana maramaim, Paul Silas hairi hirout hibow hitainih hitit ahar ana efanamaim hiya baibatiyenayah baibatiyih isan. ");
INSERT INTO aai_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hibuwih hina Rome tur nowarayah nahimaim hitit hio, “Iti Orot rou’ab i Jew sabuw, hairi iti ata bar meraramaim ma kakaf hibai hitit. ");
INSERT INTO aai_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","It Rome sabuw ata ofafar men ebibasit i sinafumih teo, naatu aki men karam boro nati bai’obaiyen anibasit anab ani’a’it.” ");
INSERT INTO aai_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Sabuw moumurih na’in hina hirun kou’ay ra’at orot rou’ab bow rouw isan. Tur nowarayan orot iuwih Paul Silas hairi hai faifuw hiseb hibosaisiren naatu hiwabirih. ");
INSERT INTO aai_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hiwawabirih ufunamaim hibow hin dibur hiyariyih, naatu dibur kaifenayan orot matan tobaiwa’an ma kaifih isan hiu. ");
INSERT INTO aai_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iti obaiyunen tur nonowar ufunamaim, dibur kaifenayan bow hirun dibur wanawanantoro’ot imaim ah ai gagamih rou’ab areh ya kiktanen hima. ");
INSERT INTO aai_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Fainaiwan Paul Silas hairi God isan hiyoyoban hima ew hitatabor dibur sabuw afa hima hinonowar, ");
INSERT INTO aai_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","naniyan meyemeye iriyoy gagamin na dibur bar iyuwiyuw re an ana wabat etei bora’ah. Naatu mar ta’imon etawan botawiy chain dibur sabuw ah umah hifatum hima’am etei hihururuw hire. ");
INSERT INTO aai_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Dibur kaifenayan matan nuw misir naatu Dibur etawan bobotawiyen itin, basit taiyuwin sikan afuwinamih ana kaiy bora’ah, anayabin not dibur sabuw etei hibihir rouw. ");
INSERT INTO aai_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Baise Paul fanan aumetawat na’in e’af eo, “Taiyuw bi’asabuni! Aki etei iti ama’am!” ");
INSERT INTO aai_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dibur kaifayan hinow isan e’af naatu nunuw run, an uman hi’oror auman Paul Silas hairi nahimaim ra’iy. ");
INSERT INTO aai_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Imaibo nawiyih bairi hitit naatu ibatiyih eo, “Regaregah abisa ana sinaf boro yawas anab?” ");
INSERT INTO aai_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hiya’afut hio, “Regah Jesu initumitum boro yawas inab, o a nibur bairi.” ");
INSERT INTO aai_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Imaibo Regah ana tur nati bar wanawanan hibinan dibur kaifenayan ana sabuw bairi hinowar. ");
INSERT INTO aai_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nati veya ta’imon gugumin wanawanan dibur kaifenayan buwih hai feher souwen naatu i ana nibur bairi bapataito hibai. ");
INSERT INTO aai_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Naatu Paul Silas buwih ana bar wanawanan hirun bay itih hi’aa. Nati orot ana nibur bairi dogoroh yasisir awan karatan, anayabin i hina God ana baitumatumayah himatar. ");
INSERT INTO aai_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mar to tur nowarayah hai orot gagamih naatu ma’utenayah hai orot ukwarih hiyafarih hio, “Kwan dibur kaifenayan kwau! Nati orot ebotaitih ten.” ");
INSERT INTO aai_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Basit dibur kaifenayan Paul ana tur eowen eo, “Tur nowarayah orot gagamih tur hiyafar hio, O Silas airi i abobotaiti, airi kwatit tufuwamaim kwan!” ");
INSERT INTO aai_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Baise Paul ma’utenayah hai oro’orot isah eo, “Aki men abisa kakafin ta asinaf naatu men hibatiyi, baise bebeyanamaim hirabi hi’afiyi naatu dibur hiyariyi, kwanaso’ob aki i Rome ana fef abai ama’am! Naatu boun tekokok i wa’iwa’iramaim hiniyafari’imih. Men karam, aki akokok kwana’uwih i taiyuwih hinan hinabotaiti.” ");
INSERT INTO aai_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ma’utenayah hai orot ukwarih himatabir baibatiyih orot gagamih hai tur hi’owen, naatu Paul Silas hairi Rome ana fef hibai hima’am isan, ana tur hinonowar ana maramaim hibir. ");
INSERT INTO aai_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Basit hina abis kakafin isah hisisinaf isan hairi matahimaim hi’e’en naatu diburane hibotaitih, naatu bar merar baihamiyin isan hi’uwih. ");
INSERT INTO aai_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul, Silas hairi dibur bar hihamiy hina Lydia ana bar hitit, nati’imaim baitumatumayah hi’itih kaufair ana tur hitih naatu hihamiyih. ");
INSERT INTO aai_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hiremor hina Amfipolos naatu Apolonia bar merar hihamiy naatu hina Thessalonica hitit, nati’imaim i Jew hai kou’ay bar ta batabat. ");
INSERT INTO aai_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paul ana yawas mar etei esisinaf na’atube in kou’ay bar run, Baiyarir veya tounu wanawanahimaim buk rusasar tur hai yabih sabuw bairi hima hidudur. ");
INSERT INTO aai_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Buk wanawanan dinab hikikirum kubuna hai tur eowen eo, “Keriso i biyan nababan namorob naatu morobone namisir maiye.” Naatu Jesu isan iti aorereb kwanonowar, God ana Roubinen Orot. Keriso’oban i nati. ");
INSERT INTO aai_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sabuw afa Paul yah ikitabir naatu Paul Silas hairi hikofanih. Na’atube Greek sabuw rou’ay gagamin God hikwakwafir auman hirun, naatu bar merar baibin ukwarih auman hirun. ");
INSERT INTO aai_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Baise Jew sabuw hibobowen sabuw ef yan rimurih hibow kou’ay gagamin himatar. Naatu nati bar merar gagamin wanawanan hibuyuw hinunuw hin Jason ana bar hiyi hirab. Hikokok Paul Silas tibunuwih hitama’am na’at tabotaitih sabuw titih. ");
INSERT INTO aai_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Baise hirun hinunuwet ana veya’amaim men hititourih. Basit Jason hibai hifatum baitumatumayah bairi hitainih hina bar merar hai orot gagamih biyah hitit hiwow hio, “Iti orot tafaram wanawanan sabuw hai ma hi’a’afiy hinan boun hina iti ata bar ata merar hitit. ");
INSERT INTO aai_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason hai merar yi buwih ana baremaim hima aiwob orot Caesar ana ofafar hi’astu’ub teo, Aiwob orot ta i ema’am wabin Jesu.” ");
INSERT INTO aai_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tur iti na’atube hio hinonowar sabuw rou’ay gagamin na’in naatu bar merar hai orot gagamih hai not hikwaris. ");
INSERT INTO aai_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Basit bar merar orot gagamih Jason naatu orot afa bairi kabay hi’uwih hibaiyan, imaibo hibotaitih hin. ");
INSERT INTO aai_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hima in mar fo, basit baitumatumayah Paul Silas hairi hiyafarih au Berea hin, naatu hina nati’imaim hititit ana veya mutufor hin Jew hai Kou’ay Bar hirun. ");
INSERT INTO aai_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nati sabuw i dogoroh hibotawiy men Thessalonica sabuw na’atube’emih. Tur hinonowar i yah bai kwanekwan hima hinowar veya matan hiyi hai buk hiyab hikok hitaso’ob Paul abisa eo i turobe Buk eo’omaim eo ai en? ");
INSERT INTO aai_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Naatu sabuw moumurih maiyow hitumatum, Greek baibin gagamih afa naatu orot moumurih na’in auman hitumatum. ");
INSERT INTO aai_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Baise Jew Thessalonica hima’am Paul Berea bibinan ana tur hinonowar ana maramaim hirabon hina yare baimatarin isan hikukeraker. ");
INSERT INTO aai_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Naatu baitumatumayah marta’imon Paul hibai hiyafar autor re. Baise Silas Timothy hairi Berea hima. ");
INSERT INTO aai_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Orot afa Paul hinawiy bairi hina Athens ana fofoninamaim hihamiy, imaibo i himatabir. Paul iuwih eo, “Kwanan Silas Timothy hairi kwana’uwih saisewat hinan bairi anita’imon.” ");
INSERT INTO aai_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul Athens imaim Silas Timothy hairi ma kakaifih wanawanan, nati bar merar hai totob awan karatan hima’am i’itih isan men iyasisir. ");
INSERT INTO aai_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Basit in Kou’ay Bar run Jew naatu Ufun Sabuw iyab God hibitumitum bairi hio, naatu mar etei ahar efanamaim sabuw iyab nati’imaim hinan iti sawar isah i hai tur eo’owen. ");
INSERT INTO aai_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Naatu orot afa Epikuria kirum efanane hititit naatu orot afa Sitoik kirumane hititit Paul bairi hibas, so’obayah afa hio, “Iti orot rarik kartatanenayan abisa eo’oweh?” Afa hio, “I ana itinin nanawan hai god isah eo.” Iti na’atube hio anayabin Paul i Jesu morobone mimisir maiye isan bibinan. ");
INSERT INTO aai_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Basit Paul hibai hinawiy hina kaniser Areopagus kou’ay nahimaim hitit naatu hio, “Aki akokok iti bai’obaiyen boubun sabuw kubi’obaibiyih inao ana nowar gewas.” ");
INSERT INTO aai_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sawar afa i’o aki anonowar i tur afa boubun aki isai, imih akokok o inakubunabuna gewas inao ananowar.” ");
INSERT INTO aai_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Athens tafaram matuwan naatu nahtoumanih iyab makwaniyih hai bowabow mar etei tur boubun menamaim tenonowar i boro hinab nati ef yanamaim hinao hinareremor aurih bowabow en. ");
INSERT INTO aai_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul kaniser hai kou’ay Areopagus nahimaim misir eo, “Athens orot! Ayu kwa ai’iti kwa etei i a yawas yayasairenamaim kwama’am. ");
INSERT INTO aai_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Anayabin iti bar merar abat areremor akwafiren efan etei aitah, na’atube sibor ana gem ta aitin tafanamaim iti na’atube kwakirum. ‘God wa’iwa’irin takwakwafir.’ God nati wa’iwa’irin kwakwakwafir, baise men kwaso’ob nati God i yait, imih boun akokok nati isan anaorereb kwananowar. ");
INSERT INTO aai_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God iti tafaram sinaf naatu tafaram wanawanan sawar etei auman sinaf himatar. I mar tafaram ana Regah baise i men orot umahimaim Tafaror Bar hiwowowab imaim ema’amamih. ");
INSERT INTO aai_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Naatu orot umahimaim abisa mamatar i men ekokok nab, anayabin yawas naatu yourabad naatu sawar tutufin etei i akisin biyanane na sabuw yawas tebaib. ");
INSERT INTO aai_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Orot ta’imon biyanane sabuw menan ta ta tafaram tutufin etei karatan, nowanowah hibai tema’am. Naatu marasika yakitifuw hai veya anababatun yai, sabuw iyab tafaram menatan hinab nowanowah namatar hinama’am i so’ob hai veya yai. ");
INSERT INTO aai_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God iti na’atube sinaf, saise sabuw hitatit hitanuwih naatu umah hitaruteteyan hitanan boro hitatita’ur. Baise i men ef yok na’in ema’am, it ta’ita’imon sisibitamaim ema’am. ");
INSERT INTO aai_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Anayabin ’i ana fairamaim it yawasit tama taremor biyat ebi’e’etaw. Kirumamaim tur kabumih kwakikirum na’atube, ‘It i natunatun.’ ");
INSERT INTO aai_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Isan imih it i God natunatun ai’in, men tananot God ana itinin i gold o silver o kabay ta sabuw tar so’obayah i hai yumatabe hitar hirouwen ebatabatamih. ");
INSERT INTO aai_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Marasika God it ata kasiy ata tengogor i’itah etei was tanen, baise boun sabuw tutufin etei dogorot baikitabir isan ebiyunit tanasinaf. ");
INSERT INTO aai_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Anayabin veya ta yayakitifuw i ema’ama, nati’imaim orot ta tafaram tutufin etei ef gewasinamaim baibatiyin isan i rubinika, naatu nati orot it itinin baiturobe isan i morobone bora’ah maiye.” ");
INSERT INTO aai_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Morobone misir maiye isan Paul eo hinonowar ana maramaim hi’iyab himarib. Baise afa hikok veya ta na maiye baidudur nowar isan hifefeyan. ");
INSERT INTO aai_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nati’imaim Paul kaniser hai kou’ay ihamiyih misir in. ");
INSERT INTO aai_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Orot afa hitumatum Paul hi’ufunun, naatu Areopagus ana kou’ay wanawananamaim orot wabin Dionysius auman itumatum naatu babin wabin Damaris naatu baibin afa auman hitumatum. ");
INSERT INTO aai_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Iti ufunamaim Paul Athens ihamiy naatu na Corinth tit. ");
INSERT INTO aai_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nati’imaim Jew orot wabin Aquila hairi hitar, Aquila i Pontus imaim tufuw baise aawan Priscilla hairi Italy hihamiy hitit, anayabin Caesar Claudius Jew sabuw etei Rome hima’am ia’arih iuwih hitit. Imih Paul na Corinth titit i na Aquila Priscilla hairi inanawanih. ");
INSERT INTO aai_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Naatu anayabin i auman i kanawas sakirayan ta, imih ma bairi kanawas hisasakir. ");
INSERT INTO aai_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Baiyarir Ana Veya mar etei Kou’ay Baremaim tur binan gewasin Jew naatu Greek sabuw yah baikitabirih isan tur yayare. ");
INSERT INTO aai_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas Timothy hairi Masedonia’ane hina hititit ana veya’amaim, Paul ana veya tutufin etei binanumaim eorereb, Jew hai tur eowen, Jesu i God ana Roubinenayan orot. ");
INSERT INTO aai_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Baise Jew sabuw Paul ana tur hikwahir tur kakafih isan hio ana veya, Paul ana faifuw tafan baibiyon bai fofob rutatab i’uwih eo, “Umamaim rara nama’ama na’at, ana ubar i kwa akis kwanab, ayu au bit i aikisisir. Veya boun ayu i boro Ufun Sabuw isah aninanawanih.” ");
INSERT INTO aai_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Naatu ihamiyih in Ufun orot ta wabin Titius Justus ana baremaim ma. Iti orot ibo kwafirenayan orot ta, i ana bar i Kou’ay Bar sisibin ma’am. ");
INSERT INTO aai_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Orot wabin Krisipas Kou’ay Bar ana orot ukwarin aawan natunatun ana nibur bairi Regah ana tur hinowar hitumatum, na’atube Corinth sabuw moumurih auman hitumatum naatu bapataito hibai. ");
INSERT INTO aai_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Fai ta Paul ana mimumaim Regah eo, “Paul men inabir baise inabinan, men awa nafot binan inihamiy inama’amih. ");
INSERT INTO aai_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Anayabin ayu airit tama’am, naatu orot babin ta boro men karam o narab ni’afiy, yabin sabuw maumurih iti bar meraramaim tema’am i ayu au sabuw.” ");
INSERT INTO aai_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Basit Paul kwamur ta’imon sumar six nati’imaim ma God ana tur sabuw i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Baise Galio tafaram Akaiya isan bigawan ana veya, Jew etei hita’imon Paul hifatum hibai hin baibatiyenamaim hiyai hio. ");
INSERT INTO aai_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Iti orot i esisinaftobon sabuw yah nikitabir aki ai ef naatu ai ofafar hina’astu’ub i hai kokomaim God hinakwafirimih.” ");
INSERT INTO aai_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul tur omih biwa’an ana veya Galio Jew sabuw isah eo, “Kwa iti orot sawar kakafin tasinaf kwata’itin isan kwatagamigam na’at, ayu boro ata ma a tur atanowar. ");
INSERT INTO aai_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Baise kwa a gamin ai’itin i tur, wab naatu kwa a ofafar isah kwagamigam, imih nati sawar i kwabai kwan kwa akis kwayabunai, ayu iti sawar i boro men ana butubun.” ");
INSERT INTO aai_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Naatu baibatiyen bar wanawanan nunih ufun hitit. ");
INSERT INTO aai_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Basit Sosthenes Kou’ay Bar ana ukwarin hirouh hibai hirab baibatiyen bar merar yan. Baise nati hisisinaf Galio men kafa’imo i yababanamih. ");
INSERT INTO aai_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul Corinthimaim veya moumurihika baitumatumayah bairi hima, imaibo eo tuturih Priscilla, Aquila hairi buwih bairi wa hibai hina Syria hitit. Namih ana veya Sensera imaim aribun mafur anayabin i omatanen ta biwa’an isan. ");
INSERT INTO aai_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Naatu hina Ephesus hitit imaim Priscilla Aquila hairi ihamiyih. Paul na Kou’ay Bar run Jew bairi baidudur isan. ");
INSERT INTO aai_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Naatu hifefeyan hikokok i nati’imaim veya maninaka bairi hitama, baise i aurin veya en imih kwahir. ");
INSERT INTO aai_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Naatu bihamiyih auman iuwih eo, “God nakokok na’at boro ana matabir isa anan.” Naatu wa bai Ephesus ihamiy in. ");
INSERT INTO aai_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na Caesarea titit ana veya na Jerusalem tit, ekaleisia sabuw nati hima’am hai merar yi, imaibo in Antioch tit. ");
INSERT INTO aai_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nati’imaim veya bai’ab na’atube ma’am ufunamaim ihamiyih, i na Galasia, Firigia imaim run tit bai’ufununayah kaufair itih. ");
INSERT INTO aai_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jew orot ta wabin Apollos, ana tafaram Alexandria imaim tufuw, basit nati ana veya’amaim i na Ephesus tit. Iti orot binan isan i ana siwar bai, naatu Buk wanawanan etei i so’ob kwanekwan. ");
INSERT INTO aai_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Regah ana ef isan i hio’baiy gewas naatu sabuw afa Jesu isan bi’obaiyih, ana itinin i orot so’obayan sawar etei so’ob eo na’atube. Naatu tur abisa eo i men ta sa’ir, baise i ana so’ob i John ana bapataito akisin so’ob. ");
INSERT INTO aai_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kou’ay Bar wanawanan itafofor binan. Baise Priscilla Aquila hairi nati’imaim hima’am tur hinonowar ufunamaim hibai bairi hin hai bar God ana ef anababatun hikubunabuna gewas nowar. ");
INSERT INTO aai_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollos ana not bogaigiwas Akaiya namih binotanot ana veya, tuwahinah koufair hitin naatu fef hikirum auman hitin bai na Akaiya tit, saise bai’ufununayah nati’imaim hima’am ana merar hitay. Na titit ana veya sabuw iyab God ana manaw ana kabeberamaim hina bai’ufununayah himamatar baibais gagamin maiyow itih. ");
INSERT INTO aai_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Anayabin Jew sabuw hibifufuwen isan bebeyanamaim tur fokarin gam iuwih naatu God ana turamaim kubunabuna hai tur eowen eo, “Turobe Jesu i Roubininenayan.” ");
INSERT INTO aai_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos Corinth ma’am ana veya Paul tafaram ta ta oyaw wanane run tit remor na Ephesus tit. Nati’imaim bai’ufununayah sabuw afa titaurih. ");
INSERT INTO aai_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Naatu bai’ufununayah ibatiyih, “Kwabitumatum ana maramaim Anun kakafiyin re iwani?” Hiya’afut hio, “Aki nati Anun Kakafiyin ana tur men kafa’imo hio anowar.” ");
INSERT INTO aai_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Basit Paul ibatiyih, “Bo kwa bapataito i menatan kwabai?” Hiya’afut hio, “John Baptist nowan.” ");
INSERT INTO aai_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul iuwih eo, “John ana bapataito i dogor baikitabiren kakafih hibihamiyen isan. Naatu orot ta wabin Jesu i ufunamaim nan baitutumin isan iuwih. ");
INSERT INTO aai_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tur iti na’atube eo hinonowar ufunamaim etei Regah Jesu wabinamaim bapataito hibai. ");
INSERT INTO aai_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Naatu Paul uman tafah yara’aten yoyoban ana veya Anun Kakafiyin re iwanih menah botabir tur ta ta hio naatu tur Godane nan hi’orerereb. ");
INSERT INTO aai_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Orot nah etei i 12 iti kou’ay wanawanan. ");
INSERT INTO aai_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul Kou’ay Bar run itafofor sumar tounu wanawanan sabuw bairi hio, God ana aiwob isan sabuw iuwih dogoroh rouw tafofofor. ");
INSERT INTO aai_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Baise sabuw afa dogoroh fokar, men kafa’imo hikok boro hititumatum naatu bebeyanamaim Regah ana ef gewasin isan tur kakafih maiyow hi’o. Basit Paul ihamiyih naatu bai’ufununayah buwih bairi hin. Veya matan yimo Tyrannus ana bai’obaiyen efanamaim ma bi’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iti na’atube ma sinaf kwamur rou’ab sawar, naatu sabuw etei nati Asia wanawanan Jew naatu Ufun Sabuw etei Regah ana tur hinowar. ");
INSERT INTO aai_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Paul wanawananamaim God ina’inan fokarih maiyow sisinaf. ");
INSERT INTO aai_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Paul ana agesaf naatu ana faifuw i biyan gubamin hibai hin sawusawuwih biyah hiyayanowahih i hiyayawas naatu afiy kakafih auman i hibibihir. ");
INSERT INTO aai_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jew sabuw afa bar merar ta ta hirun hitit sabuw iyab biyahimaim afiy kakafih hitar sumih hima’am Regah Jesu wabinamaim hinununih. Naatu hai tur i iti na’atube hio, “Demon kakafih hinununih seven Paul ana orot wabin Jesu isan ebibinan i wabinamaim kwa abi’a’ari kwatit!” ");
INSERT INTO aai_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Naatu Jew hai Firis Gagamin wabin Skeva natunatun etei seven i iti na’atube auman hisisinaf. ");
INSERT INTO aai_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Baise afiy kakafin iuwih eo, “Jesu i ayu aso’ob naatu Paul auman i ayu aso’ob, bo kwa iyab?” ");
INSERT INTO aai_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Naatu orot nati afiy kakafih hiwan ma’am misir bow yow tar, hai faifuw seb nunih ufun hitit segar biyah ererara ana bar hihamiy hibihir. ");
INSERT INTO aai_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jew sabuw etei naatu Ufun Sabuw etei iyab nati Ephesus wanawanan hima’am iti tur hinonowar ana veya, etei yah birubir fafar, naatu Regah Jesu Keriso wabin bora’ara’aten gagamin maiyow hitin. ");
INSERT INTO aai_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sabuw moumurih na’in iyab hina bai’ufununayah himamatar bebeyanamaim hitit abisa kakafin hisisinaf isan etei hi’e’en. ");
INSERT INTO aai_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Sabuw moumurih na’in iyab hikwerakwer hai buk hibow hina hibutuw naatu sabuw etei matahimaim hi’afusar. Naatu buk ta’ita’imon hai baiyan hibiyab i 50,000 drachma ana fofonin. ");
INSERT INTO aai_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sinaf fairih iti himamataramaim Regah ana tur tasasar tit naatu busuruf ra’at ana fair bai yen. ");
INSERT INTO aai_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sawar iti himamatar ufunamaim Paul ana not bogaigiwas Akaiya naatu Masedonia tafaram hairi wanawanahiwat remor na. Naatu na Jerusalem titamih ana not bogaigiwas eo, “Iti tafaram anabinanawan ufunamaim ayu boro anan Rome ana’itin.” ");
INSERT INTO aai_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Basit ana baibais orot rou’ab Timothy, Erastus hairi iyafarih hin Masedonia wanawanan hima, i baise veya au gagaminaka Asia wanawanan imaim ma. ");
INSERT INTO aai_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nati ana veya’amaim yare kakafin anababatun Ephesus wanawanan matar, anayabin Regah ana Ef isan. ");
INSERT INTO aai_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Orot wabin Demetrius silver imaim sawar ebu’ur temamatar i nati’imaim ma’am. Iti orot i god babin wabin Artemis ana kwafiren gagamin ana yumatabe, silver amaim bu’ur sabuw hitotobon. Naatu nati bowabowamaim kabay gagamin maiyow bai ana sabuw isah rur. ");
INSERT INTO aai_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Basit ana bowayah etei e’af ayuwih naatu sabuw afa i bairi hai bowabow ta’imon auman e’af hiru’ay iuwih eo “Au sabuw kwanaso’ob, ata bowabow iti’imaim kabay gagamin tatain erur. ");
INSERT INTO aai_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Naatu boun iti orot Paul abisa esisinaf i kwa taiyuw matamaim kwa’itin naatu tainimaim kwanonowar, god orot umahimaim tibiwa’an i men kafa’imo godamih.” Tur iti na’atube eo i orot babin moumurih maiyow yah ikitabir. Iti sawar i men Ephesus wanawanan akisin emamatar, baise Asia wanawanan etei kafa’imo nisawar. ");
INSERT INTO aai_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iti ata bowabow i kakafin wanawanan run naatu ata bowabow wabin boro na’af, men wabit akisin na’af, baise god babin Artemis ana kwafiren bar gagamin auman boro yabin en namatar. Naatu sabuw nati Asia wanawanan, naatu tafaram wanawanan sabuw etei iti god babin hikakafiy hikwakwafir boro nuhih nabur.” ");
INSERT INTO aai_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sabuw hiru’ay hima iti tur hinonowar higagamat himisir hiwow hio, “Ephesus ana god Artemis akisinamo i turobe gagamin.” ");
INSERT INTO aai_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Basit nati bar merar gagamin wanawanan uruw ra’at, na hibuyuw ne hibuyuw hinunuw. Masedonia orot rou’ab Gaius Aristakus hairi Paul bairi hinanawan hinan hibuwih hinunuw hin sabuw hai rou’ay efan gagaminamaim hitit. ");
INSERT INTO aai_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul akisin i kok sabuw nahimaim tatit, baise bai’ufununayah hi’otan. ");
INSERT INTO aai_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nati tafaram wanawanan hai orot gagamih, iyab Paul ana ofonah auman tur hiyafar hifefeyan men hikok boro tan kou’ay ana efan gagaminamaim yumatan ta’ototait. ");
INSERT INTO aai_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nati ana veya’amaim kou’ay ana efanamaim uruw i na’at, sabuw afa nati’imaim i tur ta hiwow hio, sabuw afa ni’imaim ibo tur ta hiwow hio. Naatu sabuw au moumurihika i men kafai hiso’ob aisim hina iti kou’ayamaim hitit. ");
INSERT INTO aai_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Naatu Jew sabuw afa Alexander hibonawiy hitit nahine bat, naatu sabuw afa roube’aten tur hitin, imaibo Alexander umanamaim sabuw rutanih awah fot naatu i taiyuwin wasfafarin isan ana tur eo. ");
INSERT INTO aai_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Baise nati veya’amaim i hi’inan Alexander i Jew orot, imih sabuw etei au ta’imon hiwow sawar ta’imon isan hio inan hours rou’ab sawar. “Ephesus ana god Artemis akisinamo i turobe Gagamin!” ");
INSERT INTO aai_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Inan yomaninamaim bar merar ana kirumayan sabuw rou’ay gagamin eotatanih inan nuwarob e’afuw basit eo, “Ephesus ana orot ana babin! Sabuw etei hiso’ob Ephesus bar merar i god gagamin Artemis ma’uh ema’am. Iti kabay kakafiyin marane hea’obow re’er boun iti inu’in auman ma’uh ema’am. ");
INSERT INTO aai_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iti sawar i boro men yait ta nayaubamih, isan imih kwa yate enub kwamare naatu men abisa ta nota’e mata nakabiy kwanasinafumih. ");
INSERT INTO aai_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kwa iti orot kwabow kwana ai’itih i men Tafaror Bar ana sawar ta hi’afiy o ata god babin isan tur kakafih hi’omih. ");
INSERT INTO aai_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Baise Demetrius ana bowayah orot bairi orot babin isan hai gamin tur afa hinama’am na’at, ata orot gagamih tur nowarayah i tema’am. Naatu tur nowar yababan yabaituturin isan ana efan i bobotawiyin inu’in boro hinan imaim hiyabaitutur. ");
INSERT INTO aai_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Baise yababan tur gagaminaka omih na’at i kwanan Kou’ay Bar gagaminamaim orot tur nowarayah matahimaim a yababan kwanaorereb tur nowarayah boro hinayabunei. ");
INSERT INTO aai_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Naatu boun hibubuyuw isan hina’af tanarun hinabibatiy boro tanao kwanekwan, anayabin tur ana’an it men taso’ob naatu it men karam boro asir tanao tanifufuwen.” ");
INSERT INTO aai_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Iti eo ufunamaim, sabuw iuwih hai ubar hin. ");
INSERT INTO aai_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Sabuw hibuyuw in sawar nuwarob ea’afuw ufunamaim, Paul bai’ufununayah etei e’af ayuwih koufair tur itih naatu eo tuturih. Imaibo ihamiyih au Masedonia na’at in. ");
INSERT INTO aai_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Naatu Masedonia ana uman men sanet imaim bar merar ta ta run tit baitumatumayah isah binan koufair itih remor na Greek tit. ");
INSERT INTO aai_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nati’imaim sumar tounu ma, naatu au Syria na’at na isan bobobuna Jew sabuw rabinamih hiyayakitufuw tur nowar. Imih i ana not bogaigiwas matabir maiye Masedonia awat na. ");
INSERT INTO aai_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Orot iti na’atube i hitur bairi hin, Berea bar merarane i orot Fairahus natun Sopater, Thessalonica’ane i Aristakus, Secundus hairi, Derbe’ine i Gaius, naatu Asia’ane i Tychicus, Trofimus hairi, naatu Timothy. ");
INSERT INTO aai_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Iti oro’orot i wa ta hibai wan hirabon Troas imaim hima aki hikaifi. ");
INSERT INTO aai_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Faraw Wanawanan Yeast En ana hiyuw sasawar ufunamaim Philipi imaim wa abai, veya umat roun ufunamaim Troas imaim ai ta’imon, nati’imaim fur ta’imon ama. ");
INSERT INTO aai_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Fur antoro’ot ebubusurufimaim, bai’ufununayah etei rafiy kakafiyin baimasibin isan abita’ay ana veya, Paul binan sabuw iuwih naatu mar natot boro nan, imih kutuw binan in fainaiwan tit. ");
INSERT INTO aai_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Naatu bar tafan aki ama’amamaim i ramef moumurih na’in hitoto’ab. ");
INSERT INTO aai_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bar ana sou awanamaim i orot boubun wabin Eutikas ma Paul ana binan nonowar. Baise Paul kutuw binan ma nowar inan busuruf matan fot taf koukuw. Naatu naniyan meyemeye matan anababatun fot ikitabir bar noyate tafan ana tet tounu imaim hima’am raiy rab easabun, hire murubin hibai hibora’ah. ");
INSERT INTO aai_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Baise Paul raiy orot isnowah kwafure rouh eo, “Men kwaniyababan, yawasin inu’in.” ");
INSERT INTO aai_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Imaibo matabir maiye yen bar tafan rafiy bai imasib eaan. Naatu fai manin ma binan in mar tot basit ihamiyih. ");
INSERT INTO aai_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Orot yawasin hibai hin au bar dogoroh ereyasisir auman. ");
INSERT INTO aai_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wa abai arabon an Asos atit naatu Paul iu’uwi na’atube baiwaninamih arun, anayabin i ababawat boro ufui rarabon. ");
INSERT INTO aai_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tafaram Asos imaim bairi abitar ana veya na wa afe’en yen bairi ana Mitilin atit. ");
INSERT INTO aai_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mar to wa ainatit ana Kios nuw aihamiy, veya bairou’abin ufunamaim Samos nuw a’afuwabon, naatu veya baitounin ana Miletus atit. ");
INSERT INTO aai_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul Ephesus baihamiyin mutufor yan rabon isan ana not bogaigiwas, men kok boro veya gagamin Asia wanawananamaim tama, anayabin bimatkabiy ana kok i Jerusalem natitabo Pentecost ana veya nab. ");
INSERT INTO aai_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus imaim Paul Ephesus ekaleisia orot ukwarih na bairi o isan isah tur iyafar. ");
INSERT INTO aai_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Naatu hina hititit ana veya iuwih eo “Ayu boubuntoro’ot ana Asia wanawanan atit bairi mi’itube tama’am i kwa kwaso’ob. ");
INSERT INTO aai_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Taiyuwu ayara’iyu Regah ana akir wairafin na’atube yawas fokarin wanawanan wainabu abow eremamaturu auman, Jew sabuw asabunu isan hiyakitifuw men anot. ");
INSERT INTO aai_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kwa kwaso’ob ayu kwa isa abibinan ana veya men kafa’imo abir, a baibais ana tur ta abotanimih, en baise etei bebeyanamaim bar arun atit a binan kwanowar. ");
INSERT INTO aai_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jew sabuw naatu Ufun Sabuw isah i bebeyan hai kakafih baihamiyen God isan tatabir naatu Regah Jesu baitutumin isan auwih. ");
INSERT INTO aai_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Naatu boun Anun kakafiyin fatumu, i ana kokomaim au Jerusalem anan, men aso’ob nati’imaim boro abisa isou namatar. ");
INSERT INTO aai_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ta’imonamo Anun Kakafiyin bimatnuwu i aso’ob, bar merar ta ta anarun anatitit dibur naatu biyababan i nati’imaim hima tekakaifu. ");
INSERT INTO aai_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Baise ayu taiyuw au yawas ai’itin i men sawar gagamin ta. Ayu au kok i bowabow Regah Jesu bitu i ana bow yomanin ana’asa’ub, naatu nati bowabow i tur gewasin God ana manaw ana kabeber isan anao rerereb. ");
INSERT INTO aai_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Naatu boun kwa iyab wanawanamaim ama aremor God ana aiwob isan a binan kwanonowar aso’ob boro men kwana’itu maiye. ");
INSERT INTO aai_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Isan imih boun kwa etei matamaim akukurereb, o yait ef inasa’ir inan inamomorob ana bit men ayu anab. ");
INSERT INTO aai_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Anayabin God abisa not yayakitifuw etei akurereb kwanowar sawar men ta abotan au’uf abatamih. ");
INSERT INTO aai_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Taiyuw mata toniwa’an kwanakaifi, naatu bobaituw Anun Kakafiyin kwa babamaim ya’aya kwanakaifih. God ana ekaleisia kwaninabatan gewas, anayabin i taiyuwin Natun momorobomaim sinaf nati sabuw hina nowan himatar. ");
INSERT INTO aai_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ayu aso’ob kwa ana bihamiy ufunamaim haru kakafih boro hinan wanawan hinarun bobaituw hinatar giyigiyih. ");
INSERT INTO aai_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kwa taiyuw a kou’ay wanawananamaim auman orot afa boro hinamisir turobe hinabotabir hinifufuwen, saise bai’ufununayah boro i hini’ufnunih. ");
INSERT INTO aai_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Imih mata toniwa’an! Kwamur tounu bairi tama fai mar erematuru abimatnuwih i kwananot. ");
INSERT INTO aai_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Naatu boun kwa i God ana tafafarenamaim ayayariyi naatu i ana manaw ana kabeber turamaim nawowabi kwanayen abisa ana sabuw baitihimih eo kwa auman nowamih nit. ");
INSERT INTO aai_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ayu men kafai orot babin ta ana gold o ana silver isan abahiy o ana ar ana faifuw isan abahiyamih. ");
INSERT INTO aai_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kwa etei kwaso’ob, ayu taiyuwu umau’umaim sawar abisa isah abiyababan asinaf himatar abow, naatu bow turou’unah hibiyababan afaram hibow karam. ");
INSERT INTO aai_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ayu ef etei ai’obaiyi, kwanabow raro nababan, saise nati’imaim boro sabuw aurih fair en kwanibaisih. Ata Regah Jesu taiyuwin awanamaim iti tur eo i kwananot ’Baitinin ana baigegewasin i ra’at men tabaib na’atube.” ");
INSERT INTO aai_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul eo sasawar ufunamaim sun yowen bairi hiyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sabuw etei erererey auman hirouh himamay naatu hio tutur. ");
INSERT INTO aai_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Etei hai yababan ra’at anayabin tur iti na’atube eo isan, ayu boro men ana’iti maiye naatu hinawiy bairi hin wa biyan hitit. ");
INSERT INTO aai_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nati’imaim aotuturih naatu aihamiyih hima aki wa abai mutufor arabon ana tafaram Kos atit; mar to ana Rodes atit, nati’imaim aikofan ana Patara atit. ");
INSERT INTO aai_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wa ta au Fonisia inan atita’ur aitafabon abai atit are arabon. ");
INSERT INTO aai_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Yan ararabon anuwariy Cyprus a’itin naatu ai beyaw na’atune bat aki au Syria arabon ana Taiya imaim arun wa aiyut sawar hitarsuwai. ");
INSERT INTO aai_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nati’imaim bai’ufununayah afa atita’ourih fur ta’imon bairi ama. Naatu Anun Kakafiyin sabuw hai tur eowen Paul hitimatanuw, saise au Jerusalem men tayen. ");
INSERT INTO aai_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Baise bairi ama na fur yomanin tit, ai veya baib ufunamaim, ai hamiyih aki ai ef arura’ah maiye. Bai’ufununayah a’aawah natunatuh etei bairi hinawiy bar merar ai tumar ana tor dones yan are imaim sui ayowen ayoyoban. ");
INSERT INTO aai_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Imaibo bairi abi’otututuren ufunamaim, wa afe’en ayen, naatu i hai ubar himatabir maiye hin. ");
INSERT INTO aai_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Taiya’ane wa abai anan i Polemais imaim wa aiyut, nati’imaim taiti baitumatumayah hai merar ayi bairi veya ta’imon ama. ");
INSERT INTO aai_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Marto ai hamiyih hima aki ana Seseria atit, binanuyan orot Philip ana baremaim bairi ama. Philip i Jerusalemamaim orot 7 hirurubinih i orot ta. ");
INSERT INTO aai_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","I natunatun baibitar etei kwafe’en biyah numih God ana tur orerereb isan ana usar hibai hima’am. ");
INSERT INTO aai_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Seseria imaim veya bai’ab na’atube ama’am ufunamaim dinab orot wabin Agabus Judea’ane natit. ");
INSERT INTO aai_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Na aki biyai tit basit Paul ana kikir bai i taiyuwin an uman iutatanen naatu eo, “God Anun Kakafiyin iti na’atube eo, Orot iti kikir matuwan Jerusalemamaim Jew sabuw boro iti na’atube isan hinasinaf hinab Eteni Sabuw hinitih.” ");
INSERT INTO aai_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Aki iti tur anonowar ana maramaim sabuw nati’imaim hima’am bairi ai fefeyan ayai Paul au Jerusalem na isan a’otan. ");
INSERT INTO aai_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Baise Paul iyafuti eo, “Kwa aisim iti na’atube kwao kwarerey ayu dogorou ana babanin kwabitin? Ayu i men buwu fatumu akisin isan abogaigiwasomih, baise Jerusalemamaim Regah Jesu wabinamaim morob isan auman abogaigiwas.” ");
INSERT INTO aai_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yan baikitabirin isan asinaf, baise men karam. Imih aibagun naatu ao, “Regah ana kok na’atube namatar.” ");
INSERT INTO aai_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Veya bai’ab na’atube nati’imaim ama’am ufunamaim ai sawar abobuna au Jerusalem amisir. ");
INSERT INTO aai_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Seseria’amaim bai’ufununayah afa hinawiyi bairi ana orot Mason ana baremaim atit, iti orot ana tafaram i Cyprus, naatu i auman marasika baitumatumayan matar ma’am. ");
INSERT INTO aai_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ayen ana Jerusalem atitit ana veya baitumatumayah nati’imaim hima’am hiyasisir ai merar hiyi. ");
INSERT INTO aai_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Marto Paul bairi ana James a’itin naatu nati ana veya’amaim regaregah ai’in etei nati’imaim hiru’ay. ");
INSERT INTO aai_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul hai merar yi naatu i ana bowabow etei Ufun Sabuw wanawanahimaim God mi’itube ibais bowabow ana tur etei aneika busuruf idudur in yomanin easa’ub. ");
INSERT INTO aai_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Eo hinonowar ufunamaim etei’imak God ana merar hiy hibora’ara’ah. Imaibo Paul isan hio, “Taiu inaso’ob Jew moumurih na’in thousand ana fofonin hina baitumatumayah himatar. Baise etei’imak tekokok i ofafar hinabukikin hinabosiyasiyar. ");
INSERT INTO aai_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Baise iti’imaim tur i iti na’atube hinowar, O i Jew sabuw iyab nati Ufun Sabuw hai tafaramamaim tema’am kubi’obaiyih Moses ana ofafar i hinihamiy, naatu hai kek hai ar men hina’afuw naatu Jew hai binanakwar men hini’ufunun. ");
INSERT INTO aai_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aki boro abisa ana sinaf, anayabin o ina ititit a tur i sabuw hinowaraka. ");
INSERT INTO aai_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Imih abisa anao na’atube inasinaf? Orot etei kwafe’en i hai omatanen ta God isan hio baifaro. ");
INSERT INTO aai_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Imih o i boro inikofanih bairi kwanan kouksouwen ana yohar wanawanan kwanarun naatu aribuh mafur o inibaiyanih aribuh hinamafur, saise o isa iti’imaim hibifufuwen sabuw boro hinaso’ob nati tur i baifuwen, anayabin i hiso’ob o i ofafar kubi’ufunun. ");
INSERT INTO aai_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Baise Ufunane sabuw baitumatumayah isah, aki fef ta ai yafar in hai tur a’owen bay uma matamatar isah hisisibor men hinaa, masanuw rara auman men hinaa, o for sikah birabir men hinaa naatu men hina’in hinisesebar kwanekwan.” ");
INSERT INTO aai_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Marto Paul orot buwih bairi hai binanakwar eo na’atube kousouwih isan hirun, orot kwafe’en hikukusouwih i auman kusouw. Imaibo i na Tafaror Bar hai tur eowen veya biy boro kouksouwen ana yomanin nasawar naatu siwar orot ta’ita’imon isah hinasibor. ");
INSERT INTO aai_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kousouwen in fur ta’imon yomanin tit baisawarinamih auman Jew sabuw afa Asia wanawanane hina hima’am Paul Tafaror Baremaim hi’itin. Sabuw kou’ay gagamin na’in hikura’ara’ahih himisir Paul bain bai’a’afiyin isan hinunuw, ");
INSERT INTO aai_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","hitar koukuw hi’af hio, “Israel Oro’orot kwana kwaibaisi! Iti orot efan etei remor ana bai’obaiyenamaim it ata sabuw isah tur kakafin maiyow eo, naatu ata ofafar baihamiyin isan eo’o, naatu iti Tafaror Bar wabin ebi’afiy. Naatu kakafin gagamin anababatun sisinaf i kwana’itin, Ufunane Sabuw buwih hina hirun ata Bar Gagamin gubagub tibitin. ");
INSERT INTO aai_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Iti na’atube hio anayabin Trofimus, Ephesusine nan hairi nati bar merar gagaminamaim Paul bairi hima hireremor hi’itih, naatu hinot i hibuwih bairi Tafaror Bar ana efanamaim hirun.) ");
INSERT INTO aai_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nati bar merar gagamin ana sabuw etei kura’ara’ahih nan ufun hinunuw hitit Paul hibai hitain kwekwekwetar hitit Tafaror Bar gagamin ufunane hire. Naatu marta’imon etawan hihir. ");
INSERT INTO aai_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paul hita’asabunimih hibiwa’an, baise tur marta’imon nunuw Rome baiyowayah hai ukwarin nowar Jerusalem wanawanan i uruw giririf mamatar. ");
INSERT INTO aai_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Matan kabiy baiyowayah orot afa hai ukwarih bairi buwih hinunuw hire kou’ay wanawanah hirun, sabuw kakafih baiyowayah hai orot ukwarih bairi hinan hi’itih Paul hirabirab hihamiy. ");
INSERT INTO aai_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Baiyowayah hai ukwarin na Paul biyan tit bai ana orot uwih chain rou’ab hibow hifatum, imaibo ibatiyih, “Iti orot i yait naatu abisa sinaf?” ");
INSERT INTO aai_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sabuw kou’ay wanawanan hibatabat asir hi’af hi’o kwanekwan, baiyowayan ukwarin sawar yabin abisa isan mamatar nowar gewasomih biwa’an men karam, anayabin uruwane ra’at imih baiyowayah iuwih Paul hibai hirun baiyowayah hai bar hiyari’y. ");
INSERT INTO aai_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paul hibai hirun wawanamaim hitit rakit sabuw hiturafef hi’itin, basit baiyowayah Paul hibora’ah hi’abar. ");
INSERT INTO aai_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Sabuw ufuh hitarkoukuw hina hio, “Kwa’asabun emorob!” ");
INSERT INTO aai_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paul hibai baiyowayah hai bar hirur auman baiyowayah hai ukwarin isan eo, “Karam boro tur ta atao itanowar?” Baiyowayan hai orot ukwarin Paul ibatiy, “O Greek tur iso’ob? ");
INSERT INTO aai_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","O men Egypt orot iti boro’omo sabuw 4,000 baiyow kwanekwaneyah ibow arar yan itit gawan isan ibirakit wari’en?” ");
INSERT INTO aai_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul iya’afut eo, “Ayu i Jew orot, Tarsus imaim atufuw Silisia wanawanan, bar merar gagamin ayu i ana matuwan ama’am imih akokok o baibasit ititu sabuw isah atao.” ");
INSERT INTO aai_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Baiyowayah hai orot ukwarin baibasit Paul itin yen wawan afe’en bat umanamaim sabuw etei rutanih etei awah fot, imaibo Paul Hebrew turamaim eo hinowar. ");
INSERT INTO aai_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Tamai’inah, naatu taitu tuwai’inah au wasfafaren ana tur anao kwananowar.” ");
INSERT INTO aai_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebrew turamaim eo hinonowar ana veya etei surur binon tar. Imaibo Paul eo, ");
INSERT INTO aai_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ayu i Jew orot Tarsus imaim atufuw tafaram Silisia wanawanan, baise Jerusalemamaim ama ara’at. Gamaliel ana bai’obaiyen babanamaim ama, uwatanah hai ofafar etei ayu i’obaiyu, naatu ayu i baibobowenayan orot ta God ana ofafar tur isan, kwa boun iti kwama’am na’atube. ");
INSERT INTO aai_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Sabuw iyab ef iti hibi’ufun abow ai’a’akirih arouw asbunubunuwen naatu afa abow ana dibur aya. ");
INSERT INTO aai_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Firis Gagamin naatu Kaniser tutufin etei abisa ao i hiso’ob turobe. Anayabin i fef hikirum hitu abai an Damaskas wanawanan, sabuw baitumatumayah nati’imaim hima’am fatumih bow na Jerusalem tit isan ayen an.” ");
INSERT INTO aai_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ana Damaskas abiyubin auman i’ouyit, naniyan meyemeye marakaw namanamarabe bow marane ra’iy sisibu etei marakaw. ");
INSERT INTO aai_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ayu me yan ara’iy rabu naatu orot ta fanan anowar eo, ‘Saul! Saul! O aisim ayu kubi’a’akiru?’ ");
INSERT INTO aai_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ayu aibatiy ao ‘Regah o yait? Iyafutu eo, ‘Ayu i Jesu Nazareth mowan, o irabu kubi’a’akiru!’ ");
INSERT INTO aai_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Sabuw bairi anan marakaw hi’itin, baise orot ayu isou eo fanan men hinowar. ");
INSERT INTO aai_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ayu aibatiy, ‘Regah ayu boro abisa anasinaf?’ Naatu Regah iuwu eo, ‘Kumisir kwen Damaskas kutit naatu nati’imaim God ana bowabow abisa o bowamih bit boro hinao inanowar.’ ");
INSERT INTO aai_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Naatu au sabuw bairi anan umou hibai hinawiyu an Damaskas atit, anayabin marakaw ana bonamanamarin re ayu matou yi ifim. ");
INSERT INTO aai_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nati bar meraramaim i orot wabin Ananias God, ana orot ta ma’am, ofafar etei i bobosiyasiyar naatu Jew sabuw nati’imaim hima’am etei i hikakakafiy. ");
INSERT INTO aai_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Na biyou tit sisibu’umaim bat naatu eo, ‘Taiu Saul, mata ekubunai kunuw maiye!’ Mar ta’imon matau kubunai anuw Ananaias a’itin. ");
INSERT INTO aai_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Imaibo iuwu eo, ‘Uwatanah hai God o rubini i ana kok o so’ob isan, saise Orot ana Yawas Mutufurin boro ina’itin naatu abisa nao’o o taiyuw tainika fanan inanowar. ");
INSERT INTO aai_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Anayabin o boro i isan inakubuna, abisa i’itin naatu inonowar sabuw etei hai tur ina’owen. ");
INSERT INTO aai_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Imih boun abisa ao inonowar aisim boro inama inakaif? Kumisir bapataito kubai, naatu kuyoyoban a bowabow kakafih ekusouwen.’ ");
INSERT INTO aai_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ayu amatabir maiye ana Jerusalem atit naatu ayoyoyoban ana maramaim matou bora’ah ina’inanen ta aitin. ");
INSERT INTO aai_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nati matou bobora’ah ana maramaim Regah aitin naatu isou eo, ‘Mata nakabiy Jerusalem saisewat inihamiy, anayabin iti’imaim ayu isou inaorereb sabuw boro men hinitumatum.’ ");
INSERT INTO aai_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ayu ai ya’afut ao, ‘Regah sabuw etei hiso’ob ayu Kou’ay Bar ta ta arun atit sabuw iyab o hibitutumi abow arow afatum dibur aya’ay. ");
INSERT INTO aai_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Naatu Stephen orot wantoro’ot iti ef isan hirab ana rara re’er ana veya ayu i nati’imaim.’ Ayu auman aisaito hirab morob naatu sabuw iyab hi’a’asabun hai faifuw i ayu abotanen abat. ");
INSERT INTO aai_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Imaibo Regah ayu iuwu eo, ‘O abiyafari inan ef yok Ufun Sabuw isah.’” ");
INSERT INTO aai_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sabuw hibat Paul eo hinowar in ana tur sawar. Baise iban maiye sabuw hibusuruf hitar koukuw hio? Sa’ab kwabai kwan! Kwa’asabun! Men karam boro nama!” ");
INSERT INTO aai_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Hitar koukuw fah sib hai faifuw hibow hirudab, naatu fofob hibow asir hirouw kwanekwan. ");
INSERT INTO aai_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Baiyowayan hai orot ukwarin iuwih Paul hibai baiyowayah hai bar wanawanan hirun naatu wabirin isan iuwih, saise biyan tababan tao hitanowar ana’an aisim Jew sabuw iti na’atube isan fanah sibisib. ");
INSERT INTO aai_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Baise wabirinamih hibai hifafatum ana veya Paul baiyowayan hai bonawiyenayan orot ukwarin ta i nati sisibinamaim batabat itin naatu ibatiy, “Orot Rome tafaram bai matuwan isan ana fef bai ema’am, baibatiyinae asir kwanarabirab boro ofafar kwana’astu’ub ai en?” ");
INSERT INTO aai_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Baiyowayah hai bonawiyenayan orot ukwarin iti tur nonowar ana veya in baiyowayah hai orot ukwarin ibatiy, “O abisa inasinafumih? Iti orot i Rome ana fef bai ema’am.” ");
INSERT INTO aai_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Naatu baiyowayah hai orot ukwarin na Paul ibatiy eo, “Kuo anowar, o i Rome ana fef ibai kuma’am?” Paul rufut eo “Ayu i Rome orot anababatun ana fef abai ama’am.” ");
INSERT INTO aai_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Imaibo baiyowayah hai orot ukwarin eo, “Ayu iti tafaram bai matuwan isan kabay gagamin na’in au fef atubun.” Baise Paul iya’afut eo, “Ayu i Rome wanawanan atufuw.” ");
INSERT INTO aai_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sabuw iyab baibatiyinamih hinan marta’imon au’uf hibat. Baiyowayah hai orot ukwarin ana bir ra’at, anayabin Paul Rome ana fef bai ma’am so’oba’e bai fatum. ");
INSERT INTO aai_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Marto mar auman baiyowayah hai orot ukwarin kok taso’ob gewas, aisim Jew sabuw Paul hibubuw hi’u’u kwanikwaniy, Paul hifatum ma’am hirufamen, naatu firis ukwarih Kaniser tutufin etei iuwih hiru’ay. Imaibo Paul bai na nahimaim bat. ");
INSERT INTO aai_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul nuw Kaniser itihkikin naatu eo, “Taituwau ayu au yawas tutufin etei God matanamaim men kafa’imo erekasiy auman ama na iti boun titamih.” ");
INSERT INTO aai_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Iti na’at eo basit Firis Gagamin wabin Ananias orot iyab Paul sisibinamaim hibatabat awan roufoforamih iuwih. ");
INSERT INTO aai_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Baise Paul iu, “God o awa boro narufofoforen, yumat rah ana sis! O baibabatiyenayan orot wai, aisim o taiyuw ofafar ibai awau roufoforenamih sabuw kubiyunih!” ");
INSERT INTO aai_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Orot Paul sisibin hibatabat hio, “O God ana Firis Gagamin isan men tur kakafih inao’omih!” ");
INSERT INTO aai_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul iyafutih eo, “Teutuwau ayu men aso’ob i Firis Gagamin. Buk Atamaninamaim eo, ‘O men tur kakafin a sabuw hai bonawiyenayan isan inao’omih.’” ");
INSERT INTO aai_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Imaibo nati ana maramain Kaniser sabuw Paul inanih, sabuw nati’imaim hiruru’ay afa i Sadducee afa i Pharisee, naatu Paul Kaniser sabuw isah fanan aumetawat eaf eo, “Teituwou! Ayu i Pharisee, naatu Pharisee orot natun. Ayu iti baibatiyen efanamaim abatabat anayabin abitumatum morobone misir maiye ana nuhufot abai ama’am isan!” ");
INSERT INTO aai_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Iti na’atube eo ana maramaim, Pharisee naatu Sadducee bairi hitarayouw higam naatu kou’ay hikusib. ");
INSERT INTO aai_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Anayabin Sadducee tibitumatum sabuw moroboyah boro men hinamisir maiye, naatu tounamatar men tema’am naatu afiy auman en. Baise Pharisee it sawar tounu etei isah tibitumatum. ");
INSERT INTO aai_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Naatu gamin gagamin na’in matar, Ofafar bai’obaiyenayah iyab Pharisee ana kou’ay himisir fanah sib higam hio, “Paul i men abisa ta kakafin sinafumih, men taso’ob afiy o tounamatar ta na hairi hio.” ");
INSERT INTO aai_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Gamin ra’at sasa, naatu baiyowayah hai orot ukwarin bir eo, Paul boro hinarab hinatensisib, naatu baiyowayah iuwih hire hin kou’ay wanawanan hirun Paul umahine hiba’aruwih hibai hina hai bar hiyari’ay. ");
INSERT INTO aai_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nati gugumin Regah na Paul sisibinamaim bat eo “Koufair inab! Jerusalemamaim ayu isou i’orereb na’atube inan Rome imaim ef ta’imon inasinaf inaorerereb.” ");
INSERT INTO aai_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Marto, marauman Jew sabuw afa hina hita’imon hiyakitifuw naatu omatanen hiwa’an harew o bay men hinaa hinatom hinama’am Paul hinarab namorobabo. ");
INSERT INTO aai_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sabuw iyab Paul asabunin isan hiyayakitifuw nah etei i 40 na’atube tafanamaim auman. ");
INSERT INTO aai_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Imaibo hin firis ukwarih naatu regaregah ai’in biyah hitit hio, “Aki etei omatanen fokarin a’obaifaro bay boro men anaa anama nan Paul ana’asabun imaibo boro bay anaa. ");
INSERT INTO aai_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Isan imih boun aki akokok kwa naatu Kaniser bairi tur kwaniyafar Rome Baiyowayan isan Paul nab kwa isa nare nan. Kwanifuw taiyuwin biyanamaim nuwet gewas kwanarouw kwanao nare nan. Baise aki boro efamaim anawa’ir anama’am nanan ana’asabun.” ");
INSERT INTO aai_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Baise Paul rubin babin natun hiyayanuw nowar basit na barik bar tit run Paul ana tur eowen. ");
INSERT INTO aai_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Naatu Paul sorodiy orot ta isan eaf na iu, “Iti monokai kwabai kwan baiyowayan ukwarin biyan, i tur ta boro ana tur na’owen.” ");
INSERT INTO aai_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Baiyowayah hai orot gagamin monokai bai in baiyowayan ukwarin biyan tit eo, “Dibur orot Paul eaf arun orot iti abai o isa anan anayabin i boro tur ta nao inanowar.” ");
INSERT INTO aai_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Baiyow hai ukwarin orot uman bai nawiy nabin akisihimo hin naatu ibatiy, “O abisa kukokok boro inao ananowar?” ");
INSERT INTO aai_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Orot iya’afut eo, “Jew orot gagagamih etei hibasit maras boro o hinifefeyani Paul inab inare Kaniser hai kou’ayomaim ana yare hinanuwetamih, baise nati i hai baifuwen. ");
INSERT INTO aai_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Imih hai tur men inanowar, anayabin orot etei 40 tafanamaim auman boro efamaim hinawa’ir hinama hinakaif. Iti oro’orot i omatanen fokarin hio baifaro bay harew hairi boro men hinaa, hinama’am Paul hina’asabunibo bay hinaa harew hinatom. Etei i sinafumih hiyabuna sawar o anot abisa inao’o i hima tekakaif.” ");
INSERT INTO aai_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Baiyowayan ukwarin eo, “Men yait ta ana tur ina’owen abisa io anonowar.” Naatu orot iyafar tit in. ");
INSERT INTO aai_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Baiyowayah hai orot gagamih rou’ab eafih hina iuwih eo, “Baiyowayah 200 kwanabow, horse ana orot etei 70, naatu 200 ahay bowayah, kwanabobuna boun gugumin nine korok iti tafaram kwanihamiy kwanan Caesarea kwanatit. ");
INSERT INTO aai_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Horse ta Paul kwanitin afe’en namare naatu kwanatafafar gewas kwanab kwanan Gawan Felix biyan kwanatit kwanitubar.” ");
INSERT INTO aai_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Imaibo baiyowayah hai ukwarin mare fef kirum eo. ");
INSERT INTO aai_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ayu Claudius Lysias, O Felix gawan orot gewas a merar ayiy. ");
INSERT INTO aai_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iti orot i Jew sabuw hibai kafa’imo hitarab tamorob, baise ayu au baiyowayah bairi ana aiyawas. Anayabin ayu hio anowar iti orot i Rome ana fef bai ema’am. ");
INSERT INTO aai_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ayu akok i ataso’ob yabin abisa isan hiu hibiwa’wa’an, imih abai an hai Kaniser biyah atit. ");
INSERT INTO aai_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Anunuwet men abisa kakafin iwa’an boro hitarab tamorob o dibur tarun, iti i Jew sabuw hai baitumatum naatu hai ofafar isan. ");
INSERT INTO aai_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Naatu asabuninamih hiyayanuw hiofa’ar anowar, imih saisewat au not abogaigiwas o isa iti abiyafar, sabuw iyabowat i isan higam teo i auwih boro hinan o namaim bairi ana tur kwananowar kwanayabunei.” ");
INSERT INTO aai_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Baiyowayah hai bowabow hibitih na’atube hisinaf, Paul hibai gugumin wanawanan hinawiy hin kakafih hai wawa’ir ana sou Antipatris imaim hitubar. ");
INSERT INTO aai_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Naatu marto baiyowayah ahiwat himatabir maiye hina yarir bar hitit, baise horse hai orot i Paul hinawiy bairi hin. ");
INSERT INTO aai_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hinawiy hina Caesarea hitit fef gawan hitin naatu Paul auman hibai hirun umanamaim hiyai. ");
INSERT INTO aai_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gawan fef iyab naatu Paul ibatiy ana tafaram menane na, naatu Paul ana tafaram Silisia’ane rouw eo nonowar ana maramaim ");
INSERT INTO aai_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","eo, “Ayu boro a kamabiy sabuw hinanabo inao anowar.” Imaibo iuwih hibai hin gawan ana bar gagaminamaim dibur bar hiyari’y. ");
INSERT INTO aai_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Veya etei umat roun sasawar ufunamaim firis gagamin Ananias regaregah ai’in afa naatu ofafar so’obayan orot wabin Tertulus bairi hire hin Caesarea hitit. Naatu Paul ana kakafih hibow hitit gawan Felix nanamaim ubar hitin. ");
INSERT INTO aai_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Imaibo Paul hibai hina hirun naatu Tertulus busuruf ubar itin eo, “Felix o i gawan orot gewas so’ob wairaf, o a aiwob i gewasin bonawiyi manin maiyow tufuwamaim tama. Naatu sawar hi’afe’af iwowab maiye ata tafaram ana gewasin isan. ");
INSERT INTO aai_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Efan tata’amaim naatu ef tata’ane, o a merar ayiy asinaf gewasin iti isan, abiyasisir gagamin maiyow o isa. ");
INSERT INTO aai_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ayu men akokok boro a veya gagamin anab, baise abifefeyani mar kafai tain inarub au tur ukwarihiwat anao inanowar. ");
INSERT INTO aai_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Iti orot i kou’obo’obowanayan, naatu wow atubob i iti orot ebimamataren, Jew sabuw hai tafaram wanawanan iti orot i ku’obo’obow kakafih temamatar, naatu kou’ay wabin Nazareth Kou’ay i’ukwarin sabuw etei ebobonawiyih. ");
INSERT INTO aai_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Naatu Tafaror Bar gagamin bisnowanowah atita’ur, imih afatum ai ofafar eo na’atube boro atibatiy. ");
INSERT INTO aai_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Baise Baiyowayan hai orot ukwarin wabin Lisias fokarin maiyow narun e’abar giyi orot umai’imaim bosair, naatu sabuw iyab ubar hibitin iyunih baina o namaim baibatiyin isan iuwih. ");
INSERT INTO aai_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Imih o taiyuw iti orot inabibatiy boro inaso’ob sawar abisa isan aki ubar abitin boro inatita’ur.” ");
INSERT INTO aai_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jew sabuw hirun hikofan ubar hitin hio, “Abisa iti orot eo i turobe.” ");
INSERT INTO aai_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gawan orot Paul isan umanamaim iman tur tao isan, naatu Paul eo, “Ayu aso’ob kwamur moumurih maiyow o Jew sabuw hai tur ikaif. Isan imih ayu abiyasisir o namaim ayu taiyuwu ana wasfafaru’umih. ");
INSERT INTO aai_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","O taiyuw itita’ur kusoso’ob veya 12 na’atube i sawaraka, ayu ayen an Jerusalem atitit i God kwafirin isan. ");
INSERT INTO aai_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Naatu men kafa’imo Tafaror Bar gagamin wanawanan Jew sabuw bairi agamigam hi’itu’imih, na’atube men kafa’imo Kou’ay Baremaim naatu nati bar merar gagamin wanawanamaim kakafin baimatarin isan aku’obo’obowamih. ");
INSERT INTO aai_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Naatu abisa ayu kakafin sinaf hirouw ubar hitu teo boro men anayabin gewasin ta hinao inanowaramih. ");
INSERT INTO aai_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ayu iti bebeyan aorereb inanowar. Ayu i God uwai’inah hikwakwafir i boun akwakwafir naatu Ef nati i abi’ufunun isan ayu yawas boubun baimatarin hirouw teo. Naatu ayu i sawar tutufin etei Moses ana ofafaramaim naatu dinab hai Bukamaim hikikirum etei abitumatum. ");
INSERT INTO aai_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Naatu iti sabuw God isan nuhih fot hima tekakaif na’atube ayu auman nati not ta’imon abai ama akakaif, sabuw kakafih naatu gewasih etei boro morobone hinamisir maiye. ");
INSERT INTO aai_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Imih ayu mar etei asisinaftobon God matanamaim naatu sabuw matahimaim au not etei roumutufurinamaim nama anabow. ");
INSERT INTO aai_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kwamur moumurih maiyow ayu Jerusalem ai hamiy ufunamaim abow aremor, imih amatabir maiye anan i kabay abai sabuw yababan wairafih baibaisih isan naatu sibor auman ya’inamih ana. ");
INSERT INTO aai_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ayu iti asisinaf ana maramaim Tafaror Bar wanawanan ana sebosebomaim hitita’uru, ofafar eo na’atube kouksouwen abai yomanin a’asa’ub ufunamaim, nati’imaim sabuw rou’ay en naatu uruw auman en. ");
INSERT INTO aai_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Baise Jew sabuw afa Asia’ane hinan i nati’imaim, igewasin nati sabuw i mi’itube hitan o namaim, saise au kakafih afa hitasoso’ob na’at ubar hititu hitao. ");
INSERT INTO aai_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O sabuw iti tebatabat kwibatiyih ayu abisa kakafin hai kaniser (Sanhedrin) hinunuwet biyau’umaim hititita’ur boro hinao inanowar. ");
INSERT INTO aai_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Baise sawar ta’imon nahimaim asinaf i kakafin hirouw teo i iti. Morobone misir maiye isan abibinan hibuwu ana o namaim abat kubibabatiyu. ");
INSERT INTO aai_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Imaibo Felix iti Ef isan nonowar gewas ufunamaim, tur rufut au’uf nawiy. Naatu Paul iu, “Baiyowayah hai orot ukwarin Lisias nan natitabo a tur anonowar boro ana fufufun anao inanowar.” ");
INSERT INTO aai_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Naatu Felix baiyowayan orot gagamin babanamaim iu, “Paul inakif, baise baibasit initin nama naremor naatu tain tuwan baibasit initih abis nakokok na’at hinibais nama.” ");
INSERT INTO aai_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Veya bai’ab na’atube ufunamaim Felix aawan Drusila hairi hina. Drusila i Jew babin, Paul isan tur iyafar na tit naatu baitumatum Jesu Keriso wanawananamaim ema’ama isan idudur hima hinowar. ");
INSERT INTO aai_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Naatu Paul ma gewasin, yawas kaifin ma gewas, yawas mutufurin ma naatu baibabatiyen gagamin God boro sabuw nabibatiyih isan bidudur Felix bir naatu eo, “O i boro inihamiyu, veya gewasin ta anab maiye boro isa tur aniyafar.” ");
INSERT INTO aai_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felix ana notamaim Paul boro kabay ta titin imaim ana tur tatubun isan mar etei eaf ena hairi tema tibidudur. ");
INSERT INTO aai_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kwamur rou’ab sasawar ufunamaim Posias Festus yen Felix ana efan bai igawan. Naatu Felix Jew sabuw baiyasisir i wabin bora’ahin isan Paul diburamaim ihamiy ma. ");
INSERT INTO aai_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus na Judea wanawanan gawan ana efan bai ma veya tounu ufunamaim Caesarea ihamiy yen na Jerusalem tit. ");
INSERT INTO aai_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nati’imaim firis ukwarih naatu Jew hai orot ukwarih hina Paul ana kakafih isan ubar hitin Festus hifefeyan. ");
INSERT INTO aai_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hikokok i mi’itube hai kokomaim tasinaf Paul tiyafar au Jerusalem tayen. Iti na’atube hisisinaf anayabin i Paul tayen tanan efamaim hita’asabun isan hiyakitifuw. ");
INSERT INTO aai_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Baise Festus iyafutih eo, “Paul i Caesarea imaim dibur ema’am, naatu ayu taiyuwu iti boro’omo nati’imaim anan. ");
INSERT INTO aai_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Imih a orot ukwarih i boro ayu bairi anan Caesarea anatit abis kakafin sisinaf na’at boro imaim ana kakafih isan ubar hinitin.” ");
INSERT INTO aai_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus veya etei eight o ten na’atube nati’imaim bairi hima, imaibo au Seseria matabir maiye re. Naatu in marto basit Festus baibatiyen ana efanamaim mare naatu iuwih Paul hibai hina hirun. ");
INSERT INTO aai_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul hibai hina hirur ana maramaim Jew sabuw iyab Jerusalemane hire hinan etei hina sisibin roun roun hi’a’ar bebera’uh baifuwen tur kakafih moumurih maiyow hibow hitit ubar hitin hio, baise hai tur hio i men kafaita biturobe’emih. ");
INSERT INTO aai_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Imaibo Paul taiyuwin wasfafar eo, “Ayu i men kafai abisa ta kakafin asinaf. Jew hai ofafar ai gigim, na’atube Tafaror Bar ai gigim, o Rome ana Aiwob ai gigimimih. ");
INSERT INTO aai_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Baise Festus i kok mi’itube Jew sabuw tiyasisirih, imih ibatiy eo, “O kukokok inayen Jerusalem imaim iti ubar tibit isan a baibatiyen imaim ananowar?” ");
INSERT INTO aai_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul iya’afut eo, “Ayu i Rome Aiwob ana baibatiyen efan nanamaim abatabat, imih ayu i boro iti imaim ana baibatiyen anab. O iso’ob ayu i men kafai abisa kakafin asinaf Jew sabuw isah. ");
INSERT INTO aai_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ayu ofafar ana’astu’ub imaim nabonawiyu morob ana baibasit anabaib i boro men morob ana haiw. Baise baifuwenamaim ubar hinabitu na’at, orot babin men ta ana fair ema’am boro ayu nabuw umahimaim nitihimih, ayu i boro kwaniyafaru anan Caesar nanaimaim au tur nanowar.” ");
INSERT INTO aai_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Imaibo Festus ana kou’ay orot gagamih not wairafih bairi hio ufunamaim tatabir Paul iya’afut eo, “O Caesar a tur nowar isan io, imih o boro Caesar isan inan.” ");
INSERT INTO aai_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Veya afa ufunamaim aiwob orot Agripa, Bernis hairi hina Caesarea hitit, Festus ana bowabow baib isan ana merar yinamih. ");
INSERT INTO aai_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Hina nati’imaim hima veya bai’ab na’atube sasawar ufunamaim Paul ana tur eowen eo, “Paul mi’itube wawasfafar isan Festus aiwob orot ihamiy ema’am. ");
INSERT INTO aai_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Naatu ayu au Jerusalem anan ana veya’amaim Jew hai firis ukwarih naatu regaregah ai’in, orot ukwarih ubar hitin ayu asabunin morob isan hi’uwu. ");
INSERT INTO aai_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Baise ayu auwih, aki Rome ai ofafaramaim orot asir bai na baibatiyen isan ana ef men ema’am, baise wantoro’ot i boro sabuw iyab ubar tibin bairi roun roun hinabat hina’o, saise i ana ef nama’am na’at taiyuwin boro nahimaim nabat nawasfafar. ");
INSERT INTO aai_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Naatu nati sabuw ayu bairi ana atitit ana veya, ayu veya men au’uf atain, faiwat a’in marto baibatiyen ana efanamaim amare, orot auwih hibai hina hirun. ");
INSERT INTO aai_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Sabuw ubar hibitin ana kakafih hibow hititit i men kafa’imo sawar kakafih ayu anotanotamaim hibow hitit ubar hitinimih. ");
INSERT INTO aai_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","En baise, gamin afa ibo taiyuwih hai kwafiren isan. Naatu orot wabin Jesu momorob Paul yawasin ma rouw eo isan hibow hitit. ");
INSERT INTO aai_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Au kasiy ra’at, iti tur boro mi’itube ata bow gewas, imih ayu Paul au i takokok na’at tayen tan Jerusalem imaim iti ubar isan hitibatiy. ");
INSERT INTO aai_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Baise Paul ifefeyanu kok i Caesar baibatiyen titin, imih ayu auwih dibur baremaim hihirafut hima’uh hima, ayu ef atanuwet imaibo atiyafar tan Aiwob Caesar biyan.” ");
INSERT INTO aai_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Basit Agripa Festus iu, “Ayu akokok iti orot nao ayu taiyuwu ananowar.” Festus iya’afut eo, “Marasibo nao inanowar.” ");
INSERT INTO aai_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hi’in marto Agripa, Bernis hairi hirutaburih auman hinawiyih rou’ay bar gagamin wanawanan hirun, baiyowayah hai orot gagamih naatu bar merar hai orot gagamih bairi. Naatu Festus iyunih Paul hibai hina hirun. ");
INSERT INTO aai_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus eo, “Aiwob Agripa naatu kwa iyab boun iti’imaim bairi tabita’imon, orot iti kwa’itin! Jew sabuw iyab iti’imaim tema’am naatu Jerusalemamaim iti orot isan ubar gagamin maiyow hitin ayu matou’umaim, fanah aumatawat na’in hiwow men hikokok iti orot boro yawasin tama. ");
INSERT INTO aai_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Naatu ayu anunuwet men kakafin ta sinaf boro imaim tabonawiy tan tamorob. Baise anayabin ayu ifefeyanu ana kok i boro Rome ana Aiwob nahimaim tabat ana tur hitanowar. Ayu au ef men ta ema’am boro atarufut, imih ayu au Rome baiyafarin isan abogaigiwas. ");
INSERT INTO aai_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Baise fef kiruminamih ayu akasiy, tur abisa boro Aiwob Caesar isan anakirum. Anayabin ubar hibitin men ta yabin auman. Imih ayu abai atit kwa etei namaim, o Aiwob Agripa inibabatiy inanuwet gewas tur yabin anababatun inab naatu fef ana kirum. ");
INSERT INTO aai_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Anayabin ayu ai’itin ayu isou men gewasin iti dibur orot ana ubar en asir taniyafar nanan ana itinin i men basit.” ");
INSERT INTO aai_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa iu, “O i baibasit abit taiyuw isa inao.” Paul uman bora’ah naatu taiyuwin wasfafar eo, ");
INSERT INTO aai_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Aiwob Agripa, ayu i abiyasisir anayabin boun o namaim Jew sabuw abisa isan ayu ubar hibitu i boro ana wasfafaru anao inanowar. ");
INSERT INTO aai_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Iti ao i turobe, anayabin o i Jew sabuw hai binanakwar naatu hai ofafar iso’ob kwanekwan, imih o abifefeyani yatenanub inama ana’o inanowar. ");
INSERT INTO aai_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jew sabuw etei ayu kek ana veya mi’itube ama’am i hiso’ob, ayu au yawas no aneika au tafaramamaim mi’itube ama’am ana Jerusalem atit ama’ama etei i hiso’ob. ");
INSERT INTO aai_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ayu i manin maiyow bairi ama, imih ayu i hisu’ubu kwanekwan. Hinakokok na’at hina’orereb. Anaika ayu i Pharisee orot, kwafiren ana ofafar fokarin wanawanan i ayu ama, naatu men kafa’imo ofafar ta astu’ub. ");
INSERT INTO aai_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Naatu boun ayu iti ubar tibitu anayabin God ana’omatanen ai a’agir bitih imaim ayu nuhufot ama’am isan, ubar hitu bairi tao. ");
INSERT INTO aai_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iti omatanen i aki ai big etei 12 hibitumitum mi’itube hita’itin titurobe, imih fai mar dogoroh tutufin etei God hikwakwafir, naatu anayabin iti baitumatum isan. Aiwobomon, Jew sabuw ayu ubar hitu iti tao. ");
INSERT INTO aai_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwa Jew sabuw iyab iti kwabatabat aisim God sabuw murumurubih ibiyawasih baitutumin isan kwa isa efofokar? ");
INSERT INTO aai_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ayu auman mat i na’atube anot, sawar moumurih na’in ata sinaf Jesu Nazareth mowan wabin ati’ib isan. ");
INSERT INTO aai_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Naatu nati na’atube Jerusalemamaim asinaf. Firis ukwarih biyahine fair abai God ana sabuw moumurih maiyow abow dibur aya. Naatu rouw morobomih teo ana veya ayu auman aibasit terouw temomorob. ");
INSERT INTO aai_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mar moumurih maiyow Kou’ay Bar efan tata’amaim abow biyababan aitih, naatu hai baitumatum baihamiyin isan a’okikimih. Na’atube hai baitumatum baigigimin isan a’okimih, naatu atit an menah tatabirih hai bar hai meraramaim bai akir kakafin maiyow aitih. ");
INSERT INTO aai_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ana’an iti isan ayu firis ukwarih biyahine fair hitu hiyunu an Damaskas atit. ");
INSERT INTO aai_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Baise efamaim anan bi’auyit auman, Aiwobomon, marakaw no marane, mamarakaw men veya na’atube, marakaw kwanekwan re ayu au sabuw bairi anan tarbebera’uhi. ");
INSERT INTO aai_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Aki etei’imak me yan are, naatu ayu orot fanan anowar Hebrew turamaim iuwu eo, ‘Saul! Saul! aisim ayu irabu kubia’akiru? Ayu kubi’a’akiru i o taiyuw biya irab kubi’a’afiy.’ ");
INSERT INTO aai_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ayu aibatiy ao, ‘O yait Regah?’ Naatu Regah eo, ‘Ayu i Jesu, o irabu kubia’akiru. ");
INSERT INTO aai_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Baise kumisir kubat, ayu o isa abirerereb ana rubini isou inabow naatu boun abisa isa mamatar sabuw afa hai tur ina’owen. Naatu abisa isa namamatar boro ani’obaiyi. ");
INSERT INTO aai_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ayu o a sabuw Jew umahine naatu Ufun Sabuw umahine boro anatafafari. Ayu abiyafari nati sabuw wanawanahimaim inan, ");
INSERT INTO aai_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","matah inabotawiy naatu guguminane inanawiyih hinatit marakawamaim hinarun. Naatu Satan umane inabow God initin, saise bowabow kakafihine notawiyen hinab, naatu God ana rourubin sabuw wanawanahimaim hai efan hinab hinamare.’ ");
INSERT INTO aai_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Nati isan Aiwobomon Agripa, ayu abisa marane re ai’itin men ai fanasair. ");
INSERT INTO aai_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Bowabow wantoro’ot i Damaskas imaim abusuruf naatu ana sabuw iyab Jerusalem hima’am isah atit, Judea wanawanan etei abinan naatu Eteni Sabuw wanawanahimaim auman a binan. Abibinan anayabin sabuw bowabow kakafihine God isan hitatatabir naatu hai bowabowamaim titurobe i dogor baikitabir hibai. ");
INSERT INTO aai_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ana’an nati isan Jew sabuw ayu Tafaror Bar wanawanan ana sebosebomaim hibuwu hifatumu rabu morobomih hiwa’an. ");
INSERT INTO aai_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Baise God tafafaru yawasu ama ana it boun atit, imih o namaim abat orot babin kikimin yen in orot babin gagamin etei matahimaim abisa isou mamatar i ao’orerereb. Ayu au tur ao i dinab oro’orot naatu Moses sawar abisa mataramih hi’o inu’in mamatar imaim ao. ");
INSERT INTO aai_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Roubininenayan boro biyan nababan ni’akir naatu morobone, moroboyah wanawanahimaim i boro wan namisir marakaw ana yawas Jew sabuw naatu Ufun Sabuw isah nakurereb.” ");
INSERT INTO aai_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paul iti na’atube taiyuwin wasfafar eo inan auman Festus Paul isan iwow eo, “O i kubikoko’aw so’obamaim nawiyi in kubikoko’aw!” ");
INSERT INTO aai_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul iya’afut eo, “Ayu i men abikoko’aw, au Aiwobomon! Tur abisa ao i turobe hai yabih auman. ");
INSERT INTO aai_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Aiwob Agripa, ayu o namaim men erebir auman ao’omih, anayabin iti sawar etei o iso’ob, naatu sawar iti himamatar boro men karam nuhinaburumih. Anayabin iti sawar men ta umasusunamaim mataramih. ");
INSERT INTO aai_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Aiwob Agripa o dinab orot kubitutumih? Ayu aso’ob o kubitumatum!” ");
INSERT INTO aai_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Aiwob Agripa Paul iya’afut eo, “O kunotanot iti veya ta’imon o boro ayu dogorou inikitabir anan Kirisiyan anamatar?” ");
INSERT INTO aai_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul iya’afut eo, “Veya kabumin o veya manin ayu au yoyoban God isan i men o akis baise kwa iyab iti boun ao kwanonowar i mi’itube kwatan ayu ama’am na’atube kwatamatar. Baise men akokok hinafatum dibur hinayariyi kwanama.” ");
INSERT INTO aai_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Naatu Aiwob orot, gawan orot Bernis, naatu sabuw afa hima’am etei himisir. ");
INSERT INTO aai_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Efan hima tur hinonowar hihamiy hitit, naatu taiyuwih turahinah bairi hibidudur hio, “Iti orot i men abisa ta kakafin sinaf boro namorob o dibur narun.” ");
INSERT INTO aai_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Naatu Aiwob Agripa Festus isan eo, “Iti orot Caesar isan baifefeyanina’e tama’am, iti boun boro ata botait.” ");
INSERT INTO aai_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Aki au Italy na’at na isan hinot hiyayabuna ufunamaim Paul naatu dibur sabuw afa bairi hibuwih Rome baiyowayah hai orot ukwarin babanamaim wabin Julius umanamaim hiya’i. Caesar baiyowayah orot hai kou’ay wabin Aiwob ana Baiyowayah. ");
INSERT INTO aai_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aki wa tafaram Adaramitiamane na batabat abai, iti wa i Asia wanawanan awar etei run titamih nununuw abai. Masedonia orot wabin Aristakus ana tafaram Thessalonica i auman is ra’at bairi an. ");
INSERT INTO aai_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Anan marto Sidon arun, Julius, Paul isan i igewasin, baibasit itin ana ofonah bainanawanihimih itih ana kokok abisa baibaisin isan iu. ");
INSERT INTO aai_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nati’imaim atit maiye ana, baise yabat kufuti, imih aki wa abai ai kewakew Cyprus nuw sisibinamaim isinfafari anunuw an. ");
INSERT INTO aai_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Anunuw anan i atit are Silisia naatu Pamfilia hai riy yan foun autubun arabon ana Maira arun Laisia wanawanan. ");
INSERT INTO aai_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nati’imaim Julius orot ukwarin Alexandria hai wa ta au Italy nununuw tita’ur, basit aki imaim yara’ahi. ");
INSERT INTO aai_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Veya moumurih maiyow efamaim aremor, yabat rabi auman awani ayey ana bar merar Sinidus anatabir. Baise yabat i ra’at men karam boro mutufor atanunuw, imih aki Kurit nuw isinfafari anunuw Samone sisibin rounane. ");
INSERT INTO aai_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kufuti auman awani tor rewarewan anunuw ana efan wabin Umabibin imaim atit, bar merar Lasea sisibinamaim Umabibin imaim arun. ");
INSERT INTO aai_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nati’imaim veya manin maiyow ama naatu busurufin maiye na isan yabat i ra’at re sakirafut. Anayabin gagar ana veya i mar etei notawiyen ana hiyuw ufunamaim ebubusuruf. Imih Paul imatnuwih eo, ");
INSERT INTO aai_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Oro’orot ayu ai’itin it tanatit tananan i boro kakafin wan tanamara’at, wa boro nataseb, sawar etei boro tanisaroun naatu it auman boro tanamorob.” ");
INSERT INTO aai_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Baise baiyowayan hai orot gagamih Julius, Paul ana tur men nowar, baise wa ana kaifenayan, naatu wa matuwan abisa hio hai tur i’ufunun. ");
INSERT INTO aai_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Naatu nati awar wa rouwin rarab siba’u imaim ma isan men igewasin, imih orot etei hai kok i boro wa hitimtawiy takakaram na’at atarabon Phoenix imaim rarab siba’u atama. Phoenix awar i tafaram Kurit wanawanan naatu nati awar i gewasin anayabin umabibin oyaw na’atune veya ere’er boro ina’itin nare. ");
INSERT INTO aai_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Waruw kikimin gurufune tarsisin, orot hinotanot abisa hio i mamatar, imih aumor hitain hiyen naatu rarar hibora’aten Kurit dones sisibin akutitiy. ");
INSERT INTO aai_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Baise men yok yabat gagamin wabin wowog oyawane babin re. ");
INSERT INTO aai_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wa rab, aki bai kewakew run maiye isan abiwa’an men karam basit yabat wan amara’at atit are. ");
INSERT INTO aai_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Baise anunuw ana nuw kikimin wabin Kauda guruf na’atune bat aki sisibin umabibin isinfafari, naatu hifafair wa kikimin uranane atain yen, ");
INSERT INTO aai_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","murab hibow hikiktatan gaigiwas, wa afe’en baginayah yabat buwih run Libia dones yen yara’ahih hirouw hibir, basit rar hitaiyen hire wa bat earuw. ");
INSERT INTO aai_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yabat i wan fus kubar rouw in marto, naatu wa afe’en sabuw sawar hibow hisrouruwen riy yan hire. ");
INSERT INTO aai_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Naatu veya baitaunin i wa ana sawar afa: rar, murab, koutataren, naatu boy i hibow taiyan hitaiyen hire. ");
INSERT INTO aai_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tafaram etei gugum aki sumar, daman men a’itah veya manin maiyow yabat kutuw rouw inan aki etei akasiy yawas isan anotanot ai not etei sawar. ");
INSERT INTO aai_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Orot nati wa afe’en veya bai’ab ama yabat rarabi bay men yait ta eaan, Paul misir nah yan foun bat eo, “Oro’orot kwa gewasin ayu fanau kwatanowar Kurit tatama’am iti sawar boro men hita’af naatu boro men ta yababan tab. ");
INSERT INTO aai_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Baise boun i kwa abifefeyani koufair kwanab, anayabin kwa orot etei boro men ta inamorobomih. Wa akisinamo boro natafofor na’unun. ");
INSERT INTO aai_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Fai gugumin God ayu aru, naatu God ayu akwakwafir i ana tounamatar iyafar ayu sisibu’umaim bat, ");
INSERT INTO aai_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","naatu iuwu, ‘Paul men inabir, o i boro Caesar nanamaim ubar hibit hinibabatiyi. God i ana kabeberamaim sabuw iti bairi wa afe’en kwanan hai yawas etei o umamaim ya, imih boro men yait ta namorob.’ ");
INSERT INTO aai_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Imih oro’orot koufair kwanab! Anayabin ayu God abitumitum abisa eo anonowar na’atube boro nasinaf. ");
INSERT INTO aai_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Baise it i boro narabit tanan nuw ta ana donesamaim boro nayara’ahit.” ");
INSERT INTO aai_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Yabat rabi Mediterenean tor yan areremor fur rou’ab sawar veya 14 baib ana veya nati ana gugumin imaim wa afe’en baginayah naniyah hibaib aki i ana tafaram abiyubin. ");
INSERT INTO aai_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Basit murab hibai aumor hi’utan hitaiy re taiy hifufufum ana fofonin i 40 metres naatu hima kafai naatu hifufun maiye hi’tin i 30 metres. ");
INSERT INTO aai_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Naatu hai bir i ra’at yabin yabat boro wa nab anan ar afe’en nayara’ah, imih aumor etei kwafe’en wa uranane hitaiyen hire naatu mar saise to isan hima hiyoyoban. ");
INSERT INTO aai_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Imaibo wa afe’en bowayah wa baihamiyin bihiramih hima hiyakitifuw. Naatu wa kafai hirufam harew yan hitaiy re, hitifuwen wa nanane aumor baitaiyin hitarouw hitanan i aunah hitanamih. ");
INSERT INTO aai_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Baise Paul baiyowayah hai orot ukwarin bobonawiyih naatu baiyowayah iuwih eo, “Iti wa afe’en bowayah wa afe’en men hinama’am na’at, kwa etei i men karam boro yawas kwanab.” ");
INSERT INTO aai_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Basit baiyowayah kaiy hibow wa kafai ana murab hi’afuw naatu hitumar e’aruw in. ");
INSERT INTO aai_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Mar sibisib auman, Paul orot etei iuwih eo, “Kwa i bay kwanaa, anayabin bay en kwama’am boun fur rou’ab sawar naatu ya wanawanan i men abisa ta ema’am. ");
INSERT INTO aai_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Imih abifefeyani bay kwanaa fair kwanab, arib boro men ta nata’uy nare nakasiyomih.” ");
INSERT INTO aai_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paul iti eo ufunamaim rafiy bai orot etei nahimaim God ana merar yi, imasib naatu busuruf eaan. ");
INSERT INTO aai_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Etei hi’itin koufair hibai naatu etei’imak bay afa hibow yah hirutan. ");
INSERT INTO aai_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Naatu aki nati wa afe’en anan nai etei i 276. ");
INSERT INTO aai_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Orot etei bay hi’aa yah biw ufunamaim, wheat nati wa afe’en hi’iuin hibow harew yan hitaiyen hire wa kerer. ");
INSERT INTO aai_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mar totoririb ana veya wa afe’en baginayah dones men hi’inan, baise umabibin ana dones hi’itin naatu wa hibai hisinaftobon nati dones yen baitet ra’ahin isan hinunuw. ");
INSERT INTO aai_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wa ana aumor hi’afuw tai yan hi’in naatu gunig ana murab au ta’imon hirufam, imaibo rar hibora’ah wa bai aki au dones anunuw arun. ");
INSERT INTO aai_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Baise wa nunuw rur yabat rab mamay yan yen naatu yara’ah nanane re tatab bai’etaw isan men karam, naatu uranane yabat rab tagurugurus. ");
INSERT INTO aai_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Baiyowayah dibur etei rouw morob isan hiyakitifuw, men hikok boro hitataiy dones hitayen hitabihir. ");
INSERT INTO aai_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Baise baiyowayah hai orot gagamin i Paul tiyawas imih baiyowayah abisa hinot hio i eotanih, naatu iuwih eo, “O yait itaiy isoso’ob wan kukununuw kure kutaiy kwen dones kuyen. ");
INSERT INTO aai_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Naatu afa i boro uf hinare wa rab tatagurugurus rebarebah afe’eh hinayen hinataiy hinarun.” Aki iti na’atube asinaf etei yawasi ataiy an dones yan ayen men yait ta morob. ");
INSERT INTO aai_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ataiy ana dones ayey men yait ta aboyouw, naatu nuw imaibo ai’inan, aki i ana Malta nuw ayen. ");
INSERT INTO aai_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nuw sabuw merarayow gewasin maiyow hiti, ai merar hiyi wairaf hi’asir rari, anayabin toun i yarayar naatu tutuban ea’ani. ");
INSERT INTO aai_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul ai heaf na wairaf wan yayara’aten, naatu kok wairaf wabuburin bai kayam tit, Paul uman yub fifin. ");
INSERT INTO aai_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nuw sabuw Paul umanamaim kok fifin inu’in hi’itin basit taiyuwih hio, iti orot i uman rara. Riy yan yawasin taiy na yen, baise koubaitotorayan ana god men ekokok boro yawasin nama. ");
INSERT INTO aai_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Baise Paul uman ta’asiy kok wairaf wan yen earah naatu men abisa ta isan matar. ");
INSERT INTO aai_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sabuw hima hi’itin hinotanot i boro uman tadaw o an ta’uy tare tamorob. Baise manin maiyow hima hikakaif men abisa ta isan matar, imih hai not hibotabir hio, “Iti orot i god wari’en!” ");
INSERT INTO aai_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nati dones inan sisibin turin i orot wabin Publius ana bar merar. Publius i nati nuw hai orot gagamin. Ai merar yi, veya tounu ana nanawan na’atube bairi ama ituwi. ");
INSERT INTO aai_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius tamah sawow biyan ana fora’abin ra’at, naatu yan yub ana gem yan inu’in. Paul na ana bar run isan yoyoban, biyan butubun naatu yawas. ");
INSERT INTO aai_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sawar iti mamatar ana tur hinowar, sabuw iyab nati nuwamaim hisawow hi’inu’in hinan etei hiyawas. ");
INSERT INTO aai_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Naatu hai kakaf gagamin na’in aki hiti, wa afe’en ayey ana veya ai remor isan abisa akokok etei hibaisi. ");
INSERT INTO aai_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sumar tounu ama’ama ufunamaim wa ta Alexandria’ane nan abai. Iti wa wabin, “God Kikifu” anayabin iti wa nanamaim i Kastor naatu Folux hairi hai yumat hikirum hi’inu’in. Rarab siba’u aki nati nuwamaim wa tafan ama in rarab siba’u sawar. ");
INSERT INTO aai_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wa abai atit an tafaram wabin Sarakus imaim arun veya tounu imaim ama. ");
INSERT INTO aai_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Naatu nati’imaim atit anunuw ana Rhegium bar merar gagamin arun imaim a’in. Mar to waruw gurufune busuruf babin, naatu aki atit anunuw veya bairu’abin Puteoli arun. ");
INSERT INTO aai_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nati’imaim baitumatumayah afa hima’am atitourih naatu hifefeyani bairi fur ta’imon ama. Imaibo aremor ana Rome atit. ");
INSERT INTO aai_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Baitumatumayah Rome hima’am aki anan bigai hinowar basit hina Apius ahar ana efan hitit, naatu afa hina Nanawan Bar Tounu hibatabat imaim hi’iti ai merar hiyi, Paul iti sabuw i’itih ana veya God ana merar yi naatu i koufair gagamin maiyow bai. ");
INSERT INTO aai_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ana Rome atitit ana veya, Paul akisin ma isan ana baibasit hitin, naatu baiyowayah orot ta hiyai kaif hairi hima. ");
INSERT INTO aai_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Veya tounu ufunamaim Jew orot ukwarih etei Paul eaf hiru’ay. Eaf hiruru’ay ana veya’amaim iuwih eo, “Taitu ayu i men kafa’imo ata sabuw isah asinaf kakaf, naatu uwatanah hai binanakwar abisa hibitit aigigimimih, baise Jerusalem imaim ayu hifatumu naatu hibuwu Rome gawan umanamaim hiya’u. ");
INSERT INTO aai_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ayu ubar hitu bairi ao hinunutitiy au kakafin men ta hitita’ur boro ata morob, imih hikok boro hitabotaitu. ");
INSERT INTO aai_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Baise Jew sabuw men hikok ayu hitabotaitu, imih ayu Caesar isan ai fefeyan. Iti asisinaf i men ata sabuw ubar baitih na’atube abiwa’an. ");
INSERT INTO aai_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ana’an iti isan ayu kwa aifefeyan kwatan kwata’itu bairit tatao isan. Ayu hifatumu dibur ama’am anayabin i Israel sabuw orot nati biyanamaim nuhih fot tema’am isan.” ");
INSERT INTO aai_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Hiya’afut hio, “Aki Judea’ane men fef ta o isa abaimih, na’atube taituwat nati’ine men o asinaf isan naatu abisa isisinaf kakaf ana tur men ta na eo anowar. ");
INSERT INTO aai_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Baise aki akokok o anot i ku’o anowar, anayabin efan ta ta etei sabuw iti o a kou’ay boubun isan hio tegamigam anonowar.” ");
INSERT INTO aai_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Basit Paul bairi veya hiyai naatu nati veya’amaim sabuw rou’ay gagamin na’in hiru’ay. Paul ma’am ana efanamaim. Mar auman Paul busuruf God ana aiwob isan kubuna naatu eorerereb etei hinowar. Sinaftobon Moses ana ofafaramaim naatu dinab oro’orot hai turamaim sabuw botabirih Jesu dogoroh baitinin isan ma iuwih in veya re. ");
INSERT INTO aai_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sabuw afa abisa eo i hitumatum, baise sabuw afa i men hitumatum. ");
INSERT INTO aai_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Taiyuwih wanawanahimaim Paul ana tur yomanin eo isan hibusuruf hibibas ufunamaim himisir hitit hin. Paul eo, “Anun Kakafiyin i turobe uwatanah isah dinab orot Isaiah iwan eo, ");
INSERT INTO aai_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kwen sabuw iti isah kuo, Kwa i boro tain kwanarub tur kwananowar, baise boro men naniyan kwanab. Mata boro natakiyat kwananuw baise yabin boro men kwana’itin. ");
INSERT INTO aai_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Anayabin nati sabuw fudirih i fokar. Tainih higibud tur men karam hinanowar, naatu matah hibofafaren. Asire matahimaim boro hita’itin tainihimaim tur boro hitanowar, fudirih boro tarerekab hitaso’ob, naatu isou boro hitamatabir, ayu atiyawasih.’ ");
INSERT INTO aai_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Isan imih ayu akokok kwa kwanaso’ob, God ana yawas i Ufun Sabuw isah ebiyafar naatu i boro tur hinanowar!” ");
INSERT INTO aai_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Tur iti eo ufunamaim Jew hihamiy taiyuwih higam auman hin. ");
INSERT INTO aai_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwamur rou’ab tutufin Paul bar ta tutubun imaim ma naatu sabuw iyab itinamih hinan i mar etei hai merar yiy. ");
INSERT INTO aai_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nati’imaim ma’am men kafa’imo bir naatu men abisa ta ana ef ya’afutimih, baise God ana aiwob isan ma binan, naatu Jesu Keriso isan sabuw i’obaibiyih. ");
INSERT INTO aai_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ayu Paul, Jesu Keriso ana akir wairafin, tur abarin isan rubinu, naatu Tur Gewasin binan isan God eafu atit. ");
INSERT INTO aai_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Iti Tur Gewasin i marasika God ana dinab hai veya’amaim eomatanih, dinab oro’orot Buk Kakafiyinamaim hikirum. ");
INSERT INTO aai_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Iti tur ana an gagamin i Natun it ata Regah Jesu Keriso isan. Biyanane ana tufuw i David ana rara’ane tufuw. ");
INSERT INTO aai_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Baise i Ayubin ana kakafiyinamaim morobone mimisir ana veya, bebeyan ebi’obaiyit turobe i, i God Natun fairin. ");
INSERT INTO aai_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","I wanawananamaim naatu i wabin isan ayu manaw kabeber itu ana tur abarayan amatar, saise tafaram wanawanan Ufun Sabuw anabuwih hinan tur hinitumatum naatu hinabosiyasiyar. ");
INSERT INTO aai_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Naatu kwa auman i nati sabuw wanawanahimaim Jesu Keriso nowan matar isan God eafi. ");
INSERT INTO aai_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Naatu Rome wanawanan kwa iyab God iyabuwi naatu rubini i ana sabuwamih kwamatar kwama’am etei, isa ayoyoyoban manaw kabeber, tufuw Tamat Godane naatu ata Regah Jesu Keriso’one mar etei kwa isa nama. ");
INSERT INTO aai_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Wantoro’ot Jesu Keriso wabinamaim ayu au God ana merar ayiy kwa etei isa, anayabin kwa a baitumatum i tuw ra’at tafaram wanawanan sabuw etei tenonowar. ");
INSERT INTO aai_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","God isan dogorou tutufin etei abow i Natun ana tur gewasin abibinan, i so’ob, ayu mar etei kwa anunuhi. ");
INSERT INTO aai_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Matanfufur isa ayoyoyoban, naatu au yoyobanamaim God abifefeyan nakokok na’at boun ana veya ef nabotawiy isou naham anan kwa aninanawani. ");
INSERT INTO aai_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Au kok gagamin i mi’itube kwa ayumat ata itin, saise ayubit ana usar kwa atit imaim a fair kwatab. ");
INSERT INTO aai_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Iti tur i men ayu akisu kwa fair bait isan ao’omih, baise kwa auman ayu koufair kwanitu bairi tanibaibaisbonen ata baitumatum nakwat isan ao’o. ");
INSERT INTO aai_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Taitu tuwa’inah ayu akokok tain anayai kwanaso’ob, mar moumurih na’in abogaigiwas atan kwa ata’iti, saise kwa wanawanamaim Ufun Sabuw afa atabow hitan baitumatum wanawanan hitarun, nati’imaim abow hina baitumatum wanawanan hirur na’atube. Baise sawar moumurih maiyow ayu au ef hirufutifut tama tanan iti boun tatit. ");
INSERT INTO aai_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ayu i sabuw etei’imak isah bai’akiramih atit, Greek sabuw naatu sabuw iyab men Greek, na’atube sabuw so’ob wairafih naatu men so’ob wairafih etei’imak isah anabow anibaisih. ");
INSERT INTO aai_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ana’an nati isan ayu akokok kwanekwan tur gewasin kwa iyab nati Rome kwama’ama auman isa anabinan. ");
INSERT INTO aai_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ayu Tur Gewasin ao’orereb isan men biyou eo’ohow, anayabin God ana fair i ef iti’imaim tit sabuw iyab tibitumatum ebiyawasih. Iti yawas i wantoro’ot Jew sabuw isah, baise Ufun Sabuw auman. ");
INSERT INTO aai_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Anayabin yawas mutufurin Godane i tur gewasinamaim orot babin eyayamutufurih, baitumatumamaim ebubusuruf naatu boro baitumatumamaim nasawar. Buk Atamaninamaim hikikirum iti na’atube eo, “Orot ana yawas mutufurin boro baitumatumamaim nama.” ");
INSERT INTO aai_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Sabuw bowabow kakafih sinafuyah naatu sabuw tafa’asarih, i hai kakafinamaim turobe ana gewasin esumisum, imih maramaim God ana ya so’ar tit ibirerereb nati sabuw isah. ");
INSERT INTO aai_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sawar tutufin etei i rereb yah hi’itah tesoso’ob, anayabin God etei bebeyanamaim sinaf tibirerereb. ");
INSERT INTO aai_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Anamaim God tafaram sinaf mamatar ana veya, God ana yawas wa’iwa’irin, ana fair wanatowanin naatu i ana itinin etei i sawar sinaf himamataramaim bebeyah hi’itan hiso’ob, imih boro men yait ta God su’ubina’e nao nifufuwenamih. ");
INSERT INTO aai_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nati sabuw i God hisu’ub, baise men kafa’imo God hirouw tebora’ara’ah, o merarayow tibitinimih. Nati efanin i hai not bonawiyih kwarikwarisen wanawanan hirun dogoroh eowarar naatu gugumafut. ");
INSERT INTO aai_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Basit i not wairafih hirouw teo, baise hai not botabir hina koko’aw na’atube himatar, ");
INSERT INTO aai_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","God morob atin bonamanamarin kwafirina’e i hitatabir orot hai yumatabe o mamu, o harufor, uma’ar, kok, i hai yumatabe hitar hima tekwakwafirih. ");
INSERT INTO aai_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Isan imih God nati sabuw ihamiyih hitit bowabow kakafih ta ta wanawanan hirun. Dogoroh ana kok na’atube tisisinaf, orot baibin hai faifuw hikwahir naatu baibin ibo orot hai ar hikwahir taiyuwih hi’in hisesebar biyah tebobokarikarit. ");
INSERT INTO aai_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Turobe God nowan i hibotabir efanin baifuwen hiyari’iy, naatu God Sawar Sinafuyan kwafirina’e, hitatabir sawar i sinaf himamatar hai fair babahimaim hirun hikwafirih isah tebowabow. Baise ana gewasin sabuw i God akisinamo hitakwafir hitabora’ara’ah wanatowan, wanatowan, Amen. ");
INSERT INTO aai_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ana an iti isan God ihamiyih insesebar naniyan kakafin anababatun hibai tisisinaf. Baibin oro’orot hai ar hikwahir, i taiyuwih hi’in tibisesebar kwanekwan. ");
INSERT INTO aai_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ef nati ta’imon oro’orot auman baibin hai faifuw hikwahir i taiyuwih baisesebar isan tibifi’afi. Naatu oro’orot taiyuwih hi’in tibisesebar kwanekwan. Ana an nati isan i taiyuwih hai kakafinamaim baimakiy tebaib. ");
INSERT INTO aai_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Anayabin sabuw God ana so’ob anababatun bain isan hai not kowarar naatu hirutawiy, imih God ihamiyih hitit not kwarikwarisen hibai hima kakafih men hitasisinaf i hima tisisinaf. ");
INSERT INTO aai_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Dogoroh wanawanan bowabow kakafih ta ta etei awan karatan: not kakafih, kabat, tafa’asar, bobowen, sabuw rouw morob; baiyow, baifufuwen, nuw okwanekwan, yanuw, ");
INSERT INTO aai_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","koutabitabir, God baifa’ifa’in, kakaf en, nuw furuwen, ora’ara’at, naatu bowabow kakafih sinaf isan hai ef boubuh tibimamataren. Naatu hinah tamah fanah tibifanasair. ");
INSERT INTO aai_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nati sabuw i hai naniyan en, aurih bosunusunub en, yabow, baiwan babanen en. ");
INSERT INTO aai_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Naatu God ana ofafaramaim sabuw iti na’atube hinasisinaf isan hinamomorob i hiso’ob, baise i hima kakafin tisisinaf. Naatu sabuw afa bowabow iti na’atube tisisinaf auman isah i baibasit hitih hima tisisinaf. ");
INSERT INTO aai_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Isan imih kwa isa men ef ta ema’am boro imaim kwanabat sabuw afa hai kakafih kwanasebmatar ubar kwanitih, anayabin nati kakafin ta’imon kwa auman kwasisinaf. ");
INSERT INTO aai_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Baise God turobe tafanamaim bat sabuw iyab kakafih tisisinaf isan baibatiyen ebitih i taso’ob. ");
INSERT INTO aai_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Imih o orot maiyow, sawar kakafin o kusisinaf na’atube sabuw tisisinaf isan o kubibatiyih o kunotanot God ana baibatiyen boro inahaiw? ");
INSERT INTO aai_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ai o God ana baiwanbabanen, ana yawanan, ana yatenub i ku’i’itin furuw. Naatu o iwanbabani dogor baikitabirin isan enanawiyi kwa’i’itin ai en? ");
INSERT INTO aai_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Baise anayabin kwa i kwafokar naatu dogor kwahir, a baimakiy kwama kwatutu ra’at eyey ana Veya’amaim God ana yaso’ar bebeyan nab natit turobe’emaim tafaram boro nabibatiy kwana’itin. ");
INSERT INTO aai_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","God boro ta’ita’imon abowabow ana fofonin a baiyan nit. ");
INSERT INTO aai_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Sabuw iyab yatehnub hima gewasin tisisinaf, naatu marakaw, baifa’en, ma wanatowan tinunuwih boro ma’ama wanatowanin nitih. ");
INSERT INTO aai_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Baise sabuw iyab i taiyuwih hai yawas tinunuwih, naatu turobe hikwahir kakafih tibi’ufunun, God ana gagamat naatu ana yaso’ar boro tafah yan nisuwai nare. ");
INSERT INTO aai_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Sabuw iyab bowabow kakafih tisisinaf i boro bai’akir naatu biyababan gagamin maiyow hinab. Jew sabuw biyahimaim boro nabusuruf nan Ufun Sabuw biyahimaim nisawar. ");
INSERT INTO aai_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Baise sabuw iyab bowabow gewasih tisisinaf, God boro fair, baifa’en, borara’aten naatu tufuw nitih, Jew sabuw biyahimaim boro nabusuruf nan Ufun Sabuw biyahimaim nisawar. ");
INSERT INTO aai_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Anayabin God i ana fofoninamaim sabuw bai’ubaren ebitih, men ta aukoun ebatabatamih. ");
INSERT INTO aai_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Sabuw iyab ofafar ufunane hima kakafin hisisinaf auman boro baimakiy hinab. Naatu sabuw iyab ofafar babanamaim hima kakafin hisisinaf boro ofafar nibatiyih. ");
INSERT INTO aai_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Anayabin sabuw i boro men ofafar tenonowaramaim nayamutufurih God matanamaim hinatitamih, en baise ofafar hinowar tibi’ufunun boro nayamutufurih. ");
INSERT INTO aai_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Eteni Sabuw aurih ofafar i en, baise abisa i hai yawasamaim eo na’atube tisisinaf i hai ofafar turaban nati, basit i aurih ofafar anababatun i en. ");
INSERT INTO aai_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Anayabin kakafin gewasin kousibin ana not i ofafar na’atube dogoromaim ema’am boro a tur na’owen, a kakafin isan boro ubar nit nakusairi, naatu a gewasin isan boro natafafari. ");
INSERT INTO aai_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Tur Gewasin iti ao’orereb na’atube boro namatar. Nati baibatebat ana veya God boro Jesu Keriso narubin sabuw hai not wa’iwa’irih etei boro nabow hinatit rerereb yah naya. ");
INSERT INTO aai_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Baise kwa Jew sabuw kwarouw kwao, naatu ofafar tafanamaim kwabat God isan kwanao ra’at. ");
INSERT INTO aai_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","God ana kokok sinaf isan i kwaso’ob, naatu kakafin gewasin hairi kusibin isan i ofafaramaim ebi’obaiyi. ");
INSERT INTO aai_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Taiyuw kwaso’ob, kwa i matah fim hai nabatanayah, gugumin ma’ayah hai marakaw ");
INSERT INTO aai_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","koko’aw sabuw hai roube’atenayah, bereberefiy hai bai’obaiyenayan, naatu ofafar wanawanan ana kinitur tutufin etei naatu turobe etei auman i kwaso’ob. ");
INSERT INTO aai_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Sabuw kwabi’obaibiyih, baise kwa taiyuwiban kwabi’obaiyi ai en? A binanumaim kwao, “Men kwanabain” Baise o kubabain ai en? ");
INSERT INTO aai_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Sabuw turahinah aawah ufun na isan i kuo’otanih, baise o turanah aawah ufuh kwenan ai en? Umataratar baifa’ifa’ih irouw kuo, baise hai kwafiren bar wanawanan o kubabain ai en? ");
INSERT INTO aai_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","God ana ofafar isan i kuo’ora’ara’at, baise ofafar i’astu’ub God biya’ohow kubitiniban kui’itin ai en? ");
INSERT INTO aai_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Buk Atamaninamaim iti na’atube hikirum, “Eteni Sabuw God wabin tibigigim anayabin kwa Jew sabuw asinafumaim.” ");
INSERT INTO aai_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","O ofafar inabobosiyasiyar na’at, a’ar hi’a’afuw i boro nan ana’an gagamin namatar, baise ofafar ina’a’astu’ub, o a’ar kanabin hi’a’afuw ana’itin i afuwina’e. ");
INSERT INTO aai_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Sabuw iyab hai ar kanabih men hi’afuw, baise ofafar eo biyunih na’atube tebobosiyasiyar, nati sabuw i sabuw iyab hai ar kanabih hi’a’afuw hinasairih. ");
INSERT INTO aai_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Orot yait biyanane ana ar kanabin men hi’afuw, baise ofafar i ebobosiyasiyar, o boro nasiksairi, anayabin o i ofafar iso’ob naatu a’ar kanabin hi’afuw, baise ofafar men kubobosiyasiyar. ");
INSERT INTO aai_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","O yait Jew orot kumamatar i men biya ufunane hi’a’afuw imaim o ina Jew orot kumamataramih. ");
INSERT INTO aai_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","En baise, Jew orot anababatun i dogor wanawanan. Naatu afu’afuw anababatun i dogor wanawananamaim Anun Kakafiyin esisinaf, men biya. Naatu bora’ara’aten etei i Godane nan inab men orot biyahine. ");
INSERT INTO aai_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Jew orot inamamatar boro Ufun Sabuw inanatabirih? Naatu a’ar kanabin hina’a’afuw ana gewasin i boro men tomar inab? ");
INSERT INTO aai_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ef tata’ane etei i gewasih, wantoro’ot God ana tur i Jew sabuw hitutumih hitih. ");
INSERT INTO aai_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Baise sabuw afa men hibitumitum isan, kwanotanot God ana omatanen isan boro men nabosunusunub? ");
INSERT INTO aai_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","En anababatun! God ana tur i mar etei turobe, baise sabuw i baifuwenayah. Buk Atamaninamaim iti na’atube hikirum, “Tur awamaim etitit i mar etei asinafumaim initurobe, naatu baibatiyen ana veya hai tur boro inisnowah.” ");
INSERT INTO aai_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Baise it ata sinaf kakafihimaim God ana sinaf gewasin bebeyan natit sabuw hina’i’itin ana veya, it boro mi’itube tanao? God baifuwenamaim yan so’ar baimakiy ebitit? it i anababatun taikoko’aw tao kwanekwan. ");
INSERT INTO aai_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nati tur i men turobe tao’omih, anayabin sinaf nati na’atube nama’am, God boro mi’itube tafaram ana sabuw nibatiyih? ");
INSERT INTO aai_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Orot babin ta boro nagam nao, “Ayu i men bosunusunubayan, baise au bowabowamaim turobe God nowan tit irerereb sabuw hi’itin God hifai tebobora’ara’ah, aisim God ayu kakafu rouw eo ekukusairu?” ");
INSERT INTO aai_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Naatu iban boro kwanao maiye, kakafin tanasinaf, saise sinaf gewasin boro ine natit. Sabuw afa ayu iti na’atube o hirouw higam tiu’uwu, God nati sabuw boro baimakiy nitih. ");
INSERT INTO aai_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Iti sawar ana an i abisa? It Jew ata gewasin i ra’at Eteni Sabuw tanatabirih? En anababatun! Jew sabuw naatu Eteni Sabuw etei i bowabow kakafin ana fair babanamaim tama’am. ");
INSERT INTO aai_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Buk Atamaninamaim iti na’atube hikirum, “Orot babin men yait ta ana ef mutufurin, men kafa’imo orot ta’imon; ");
INSERT INTO aai_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Men yait ta ana not rerekabin, men yait ta God enunuwih. ");
INSERT INTO aai_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Etei hitatabir kouh God hitin, etei hisinaf kakaf hikowarar, men kafa’imo yait ta gewasin esisinaf, men kafa’imo orot ta’imon. ");
INSERT INTO aai_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Sikah dub i tahahab sabuw tetotonan, menah kautabitabir ana efan matar, ufurihimaim kok tuwamorob awakirurin awan karatan.” ");
INSERT INTO aai_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Awah i orarafen awan karatan naatu tenakuyakuy.” ");
INSERT INTO aai_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Iti sabuw umah i rara awan karatan. ");
INSERT INTO aai_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Menamaim tenan ma kakaf naatu gurugurusen mar etei imaim emamatar, ");
INSERT INTO aai_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Naatu tufuwamaim ma ana ef i men h